﻿USE sofia;
DROP TABLE IF EXISTS sofia.rup_vpl;
CREATE TABLE rup_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES rup_vpl WRITE;
INSERT INTO rup_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Atsea esti cartea a farãljei al Isus Hristos, hiljilu al David, hiljilu al Avraham. ");
INSERT INTO rup_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Al Abrahamu lji s-amintã Isacul, al Isac lji s-amintã Iacovul. Al Iacovu lji s-amintã Iuda shi fratsilji a lui, ");
INSERT INTO rup_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","al Iuda lji s-amintã di la Tamara Faresul shi Zara. Al Faresul lji s-amintã Hezromul, al Hezromul lji s-amintã Aramul, ");
INSERT INTO rup_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","al Aramu lji s-amintã Aminadabul, al Aminadabu lji s-amintã Naasonul, al Naasonu lji s-amintã Salmonul, ");
INSERT INTO rup_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","al Salmonu lji s-amintã Boazul di la Rahabi, al Boazu lji s-amintã Obedul di la Ruth, al Obedu lji s-amintã Iesseul, ");
INSERT INTO rup_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","al Iesse lji s-amintã Davidul amirã. Al amirãlu David lji s-amintã Solomonul di la muljeara tsi eara al Uriah, ");
INSERT INTO rup_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","al Solomonu lji s-amintã Roboamul, al Roboamu lji s-amintã Abiahul, al Abiahul lji s-amintã Asaful, ");
INSERT INTO rup_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","al Asafu lji s-amintã Iosafatul, al Iosafatu lji s-amintã Ioramul, al Ioramu lji s-amintã Oziaul, ");
INSERT INTO rup_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","al Oziau lji s-amintã Ioatamul, al Ioatamu lji s-amintã Ahazul, al Ahazu lji s-amintã Ezekia, ");
INSERT INTO rup_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","al Ezekia lji s-amintã Manaseul, al Manaseu lji s-amintã Amonul, al Amonu lji s-amintã Iosia, ");
INSERT INTO rup_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","al Iosia lji s-amintã Iekonia shi fratsilji a lui tu chirolu a mutariljei tu Babilon. ");
INSERT INTO rup_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Dupã mutarea tu Babilon al Iekonia lji s-amintã Salatielul, al Salatielu lji s-amintã Zorobabelul, ");
INSERT INTO rup_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","al Zorobabelu lji s-amintã Abiudul, al Abiudu lji s-amintã Eliakimul, al Eliakimu lji s-amintã Azorul, ");
INSERT INTO rup_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","al Azoru lji s-amintã Sadokul, al Sadoku lji s-amintã Achimul, al Achimu lji s-amintã Eliudul, ");
INSERT INTO rup_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","al Eliudu lji s-amintã Eleazarul, al Eleazaru lji s-amintã Mathanul, al Mathanu lji s-amintã Iacovul, ");
INSERT INTO rup_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","al Iacovu lji s-amintã Iosiful, bãrbatilu ali Marii, di la ea s-amintã Isusul, tsi s-acljimã Hristos. ");
INSERT INTO rup_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ashã cã tuti gheneratili di la Abrahamul pãnã la Davidul s-fac patrusprãdzatsi di ghenerati, shi di la Davidul pãnã la mutarea tu Babilon, patrusprãdzatsi di ghenerati, shi di la mutarea tu Babilon pãnã la Hristolu, patrusprãdzatsi di ghenerati. ");
INSERT INTO rup_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Amintarea al Isus Hristolu fu ashã: Maria, muma a lui, eara susita al Iosif, ma, nãinti tsi s-apãrnjea s-bãna deadun, armasi greauã di la Duhlu Sãmtu. ");
INSERT INTO rup_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Atumtsea Iosiful, susitlu a ljei, tsi eara un om ndreptu sh-nu vrea s-u arushina nãintea a oamnjilor, apofãsi s-u alasã ascumtã. ");
INSERT INTO rup_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ma, iarã minduea singur aestu lucru, s-afãnisi tu yis un anghil di la Domnul sh-lji dzãsi: “Iosif, hiljilu al David, s-nu ai fricã s-u ljeai Maria ca muljeara a ta, cã tsi s-acãtsã tu nãsã easti lucru di la Duhlu Sãmtu. ");
INSERT INTO rup_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Shi ea va s-amintã un ficior, sh-tini va lji badzã numa Isus, cã elu va s-ascapã populu a lui di amãrtiili a lor.” ");
INSERT INTO rup_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Shi tutã aestã s-featsi tsi si mplineascã zborlu a Domnului dupã prufitul tsi dzãtsi: ");
INSERT INTO rup_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Ia, virghina va armãnã greauã sh-va amintã un ficior, tsi va lj-bagã numa Emanuel,” tsi va s-dzãcã: “Dumnidzãlu cu noi.” ");
INSERT INTO rup_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Sh-Iosiful, dupã tsi si sculã di somnu, featsi ashã cum lu avea ursit anghilu a Domnului, sh-u lo ningã nãsu muljeara a lui. ");
INSERT INTO rup_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ma elu nu u cunuscu, pãnã tsi ea amintã ficiorlu a ljei sh-elu lu acljimã Isus. ");
INSERT INTO rup_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Dupã tsi Isusul s-amintã tu Betlehem a Iudeiljei tu chirolu al amirãlu Ierod. Ia, niscãntsã shtiuts di la Rãsãrit agiumsirã la Ierusalem, ");
INSERT INTO rup_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","dzãcãnda: “Iu easti amirãlu a Iudeilor, tsi s-amintã? Cã vidzum steaua a lui la Rãsãrit sh-vinim s-nã ncljinãm.” ");
INSERT INTO rup_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Amirãlu Ierod, cãndu avdzã aesti zboari, s-tulburã, sh-deadun cu nãsu tut Ierusalemlu. ");
INSERT INTO rup_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Sh-dupã tsi lã adunã tuts mãrilji a preftsãlor shi scriblji a popului, lji ntribã iu prindi s-aminta Hristolu. ");
INSERT INTO rup_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Sh-elji lji dzãsirã: “Tu Betlehemlu a Iudeiljei, cã ashã easti scriatã di la prufitlu: ");
INSERT INTO rup_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Sh-tini, Betlehem, loc al Iuda, nu eshti ma njic di printsilji a Iudeiljei, cã di la tini va easã un conducãtor, tsi va pascã populu a meu, Israelu.’” ");
INSERT INTO rup_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Atumsea Ierodul lã acljimã pi ascumtu shtiutslji, sh-ntribã cu mari cãshtigã elji, di chirolu cãndu lu avea vidzutã steaua di prota oarã. ");
INSERT INTO rup_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Sh-lji pitricu la Betlehem sh-lã dzãsi: “Imnats shi ntribats ghini ti cilimeanlu. Sh-cãndu s-lu aflats, dimãndats-nji tsi s-yin sh-mini s-mi ncljinu.” ");
INSERT INTO rup_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Sh-elji, dupã tsi lu avdzãrã amirãlu, fudzirã. Sh-ia, steaua tsi avea vidzutã la rãsãrit, s-dutsea nãintea a lor pãnã s-dãnãsi la loclu iu eara cilimeanlu. ");
INSERT INTO rup_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Elji, cãndu u vidzurã steaua, s-hãrsirã multu. ");
INSERT INTO rup_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Sh-dupã tsi intrarã tu casã, vidzurã cilimeanlu cu Maria, muma a lui, shi cãdzurã pri dzinucljiu shi si ncljinarã. Deapoea disfeatsirã ayishtearea a lor sh-durusirã: furii, timeamã shi njir. ");
INSERT INTO rup_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Dupã tsi Dumnidzãlu lã dimãndã tu yis tsi s-nu s-turna la Irod, elji s-turnarã tu loclu a lor pri unã altã cali. ");
INSERT INTO rup_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Tora, dupã tsi shtiutslji s-nchisirã, ia, un anghil a Domnului lji si fãnirusi tu yis al Iosif shi lj-dzãsi: “Scoalã-ti, ljea cilimeanlu shi muma a lui sh-fudzi tu Eghiptu, shi shedz aclo pãnã s-tsã dzãc mini, cã Ierodul va lu caftã cilimeanlu ti vãtãmari.” ");
INSERT INTO rup_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Elu, si sculã, lo cilimeanlu sh-muma a lui noaptea shi fudzi tu Eghiptu. ");
INSERT INTO rup_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Armasi aclo pãnã muri Irodul, tsi si mplinea tsi eara dzãsã di Domnul prit prufitlu: “Lu acljimai hiljilu a meu di Eghyptu.” ");
INSERT INTO rup_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Atumtsea Ierodul, vidzãnda cã shtiutslji lu avea arãs, s-nãrãi multu sh-ordinã si s-vatãmã tuts cilimenjilji mascuri tsi eara tu Betlehem shi tu tuti locurili di anvãrliga a lui, di la doi anji sh-nghios, dupã chirolu tsi lu avea aflatã di la shtiutslji. ");
INSERT INTO rup_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Atumtsea si mplini atsea tsi eara dzãsã di la prufitlu Ieremia cã: ");
INSERT INTO rup_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Tu Ramã s-avdzã unã zghileari, unã vãitari, un plãngu shi patathimã mari. Rachela vãita hiljilji a ljei sh-nu va si s-diznjeardã, cã elji nu sãntu ma.” ");
INSERT INTO rup_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Dupã tsi Ierodul muri, ia un anghil a Domnului si lj-fãnirusi tu yis al Iosif tu Eghyptu, ");
INSERT INTO rup_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","shi lj dzãsi: “Scoal-ti, ljea cilimeanlu sh-muma a lui sh-imnã tu loclu al Israel cã atselji tsi vrea s-lu vãtãma cilimeanlu au muritã.” ");
INSERT INTO rup_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Sh-elu si sculã, lo cilimeanlu sh-muma a lui shi s-dusi tu loclu al Israel. ");
INSERT INTO rup_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ma, cãndu avdzã cã Arhelaul, domnea la Iudea tu loclu al Ierod, tatãl a lui, avu fricã si s-ducã aclo. Shi, dupã tsi s-urnipsi di la Dumnidzãlu tu yis, s-dusi tu loclu a Galileiljei. ");
INSERT INTO rup_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Sh-dupã tsi agiumsi aclo, shidzu la un cãsãbã tsi s-acljima Nazaret, tsi si mplinea atsea tsi eara dzãsã di la prufitsilji: “Elu va si s-acljeamã Nazareas.” ");
INSERT INTO rup_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tu atseali dzãli vini Ioan Pãtidzãtorlu, tsi predica tu irnjia a Iudeiljei, ");
INSERT INTO rup_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","shi dzãtsea: “Mitãnjiusits-vã, cã amirãriljea a tserurilor easti aproapi!” ");
INSERT INTO rup_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Sh-ti Ioanul avea gritã prufitlu Isaia cãndu dzãsi: “Boatsea atsilui tsi aurlã tu irnjii: ‘Ndridzets-u calea a Domnului, ndriptats cãrãrili a lui.’” ");
INSERT INTO rup_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ioanul avea nviscutã un stranji di lãna a cãmilãljei sh-un brãn di chealã la mesi. Elu s-hrãnea cu carcaletsi shi njeari-agrã. ");
INSERT INTO rup_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Atumtsea oamnjilji a Ierusalemlui, di tutã Iudea sh-di locurili a Iordanlui s-dutsea cãtrã nãsu, ");
INSERT INTO rup_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","shi s-pãtidza di la nãsu, tu arãu Iordan mãrtirsinda amãrtiili a lor. ");
INSERT INTO rup_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ma elu, vidzãnda cã multsã Farisei shi Saducei ma yinea s-pãtidzea la nãsu, lã dzãsi a lor: “Pulji di nãpãrtitsi, cai vã ari nvitsatã tsi s-ascãpats di nãrirea al Domnului tsi ma yini? ");
INSERT INTO rup_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Dats fruti buni trã mitãnjiusirea a voastrã! ");
INSERT INTO rup_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Sh-nu dzãtsets cu mintea a voastrã: ‘Noi avem Abrahamul ca tatã.’ Cã mini ma vã dzãc cã Dumnidzãlu poati s-da hilji a Abrahamului sh-dit aesti chetri. ");
INSERT INTO rup_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Sh-tora tupoara easti tu rãdãtsina a ponjilor. Itsi pom, tsi nu da fruti buni, va si s-talji sh-va si s-arucã tu foc. ");
INSERT INTO rup_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Mini ma vã pãtedz cu apã, trã mitãnjiusiri, ma atsel tsi yini dupã mini easti ma mari di mini, sh-mini nu hiu axiu nitsi s-tsãn sandalili a lui. Elu va s-vã pãteadzã cu Duhlu Sãmtu sh-cu foc. ");
INSERT INTO rup_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Elu tsãni tu mãnã lupata sh-va lu cãtãrãseascã tut grãnarlu a lui, grãnlu a lui va lu adunã tu hãmbar, ma cotsala va lu ardã tu foc niastes.” ");
INSERT INTO rup_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Atumtsea vini Isusul dit Galilea la Iordan, la Ioanul tra s-pãteadz di la nãsu. ");
INSERT INTO rup_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ma Ioanul lu ncuntrã dzãcãnda: “Mini prindi s-mi pãtedzu di la tini, sh-tini ma yinji la mini?” ");
INSERT INTO rup_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Sh-Isusul, apãndisinda, lji dzãsi: “Alasã si s-facã tora, cã ashã mplinim itsi ndriptati.” Atumtsea elu lu alãsã. ");
INSERT INTO rup_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Sh-Isusul, macãt s-pãtidzã, ishi dit apã. Shi ia, tserurili s-disfeatsirã, sh-elu vidzu Duhlu a Dumnidzãlui dipunãnda ca un purumbu sh-vininda pristi nãsu. ");
INSERT INTO rup_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Shi ia, unã boatsi dit tser tsi lj-dzãsi: “Aestu easti Hiljiu a meu vrut, di la cai escu hãrãsit.” ");
INSERT INTO rup_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Atumtsea Duhlu lu adusi Isusul tu irnjii, tsi draclu su cãrtea. ");
INSERT INTO rup_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Shi dupã tsi tsãnu pãreasinj patrudzãtsi di dzãli sh-patrudzãtsi di noptsã, ma napoi u lo foama. ");
INSERT INTO rup_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Atumtsea cãrtitorlu, dupã tsi s-apruche, lji dzãsi: “Ma s-hii Hiljiu a Dumnidzãlui, dzã tsi aesti chetri si s-facã pãnji.” ");
INSERT INTO rup_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ma elu lj-apãndisi: “Scritura dzãtsi: ‘Omlu nu bãneadzã mash cu pãni, ma cu itsi zbor tsi easi dit gura a Dumnidzãlui.’” ");
INSERT INTO rup_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Atumtsea draclu lu adusi tu sãmtul cãsãbã sh-lu bãgã tu mãeaua a tempului, ");
INSERT INTO rup_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","sh-lji dzãsi: “Ma s-hii Hiljiu a Dumnidzãlui, arucã-ti nghios, cã Scritura dzãtsi: ‘Elu va da ordin a anghiljilor a lui trã tini, sh-atselji va ti tsãnã tu mãnjili a lor tsi s-nu agudeshti cu ciciorlu a tãu vãrã cheatrã.’” ");
INSERT INTO rup_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Isusul lj-dzãsi: “Scritura dzãtsi tutashã: ‘S-nu lu cãrteshti Domnul, Dumnidzãlu a tãu.’” ");
INSERT INTO rup_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Draclu lu dusi dinou pri un munti multu analtu sh-lji spusi tuti amirãriljili a lumiljei sh-mãrirea a lor, ");
INSERT INTO rup_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","sh-lji dzãsi: “Mini va tsã li dau tuti aesti, macã tini cadz pri dintsã nãintea a mea sh-va-nji ti-ncljinji.” ");
INSERT INTO rup_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Atumtsea Isusul lji dzãsi: “Fudzi, Satane, cã easti scriatã: ‘Alavdã Domnul, Dumnidzãlu a tãu, sh-lucreadzã mash trã nãsu.’” ");
INSERT INTO rup_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Atumtsea draclu lu alãsã, sh-ia, s-apruchearã anghilji tra s-lji huzmitipsea. ");
INSERT INTO rup_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Cãndu Isusul avdzã cã Ioanul lu avea bãgat tu hapsi, s-trapsi tu Galilea. ");
INSERT INTO rup_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Deapoea alãsã Nazaretul shi s-dusi s-bãneadzã la Capernaum, cãsãbã ningã amari, tu sinurili al Zabulon shi Neftali, ");
INSERT INTO rup_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","tsi si mplineascã tsi eara dzãsã di la prufitlu Isaia cai dzãsi: ");
INSERT INTO rup_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Loclu al Zabulon sh-loclu al Neftali, mardzina a amariljei, loclu napãrti di Iordan, Galilea a pãngãnjilor, ");
INSERT INTO rup_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","populu tsi bãna tu scutidi ari vidzutã unã lunjinã mari, sh-pristi atselji tsi stãtea tu loclu a aumbriljei a moartiljei, arãsãri lunjina.” ");
INSERT INTO rup_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Di atumtsea Isusul apãrnji s-predica shi s-dzãtsea: “Mitãnjiusits-vã cã amirãriljea a tserurilor easti aproapi.” ");
INSERT INTO rup_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Cãndu ma fudzea ningã amarea a-Galileiljei, Isusul vidzu doi frats: Simonul tsi s-acljima Petru, sh-Andrea, frati-su, tsi ma aruca plãsili tu amari cã eara piscari. ");
INSERT INTO rup_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Sh-lã dzãsi a-lor: “Haidets dupã mini sh-mini va vã facã piscari di oaminji.” ");
INSERT INTO rup_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Sh-dinãoarã elji alãsarã plãsili sh-lu urmarã. ");
INSERT INTO rup_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Sh-cum s-dusi ma nclo, vidzu doi altsã frats: Iacovul, hiljiu al Zevedeu sh-Ioanul, fratili a lui, tu varcã deadun cu Zevedeu tatili a lor, tsi ma ndridzea plãsili. Sh-lji acljimã. ");
INSERT INTO rup_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Elji alãsarã trãoarã varca sh-tatãl a lor shi s-dusirã dupã nãsu. ");
INSERT INTO rup_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Isusul strãbãtea tutã Galilea, nvitsãnda tu sinagodzili a lor, predicãnda evanghelul a amirãriljei sh-vindicãnda itsi lãngoari sh-itsi niputeari eara tu popul. ");
INSERT INTO rup_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ashã anamea a lui si arãspãndi tu tutã Siria, sh-lji adutsea tuts lãndzitslji tsi s-munduea di niputeri sh-dureri soi di soi, demonizatsi, epileptici sh-paralizatsi, sh-elu lji vindica. ");
INSERT INTO rup_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Sh-un multsãmi mari di oaminji nidzea dupã nãsu dit Galilea, dit Decapoli, dit Ierusalem, dit Iudea sh-di napãrti di Iordan. ");
INSERT INTO rup_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Sh-cãndu Isusul vidzu multsãmea, s-alinã pri munti, sh-dupã tsi shidzu, s-apruchearã di nãsu ucenitsilji a lui. ");
INSERT INTO rup_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Sh-elu discljisi gura, sh-lji-nvitsã. Elu dzãsi: ");
INSERT INTO rup_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ghinicuvãntats suntu atselji oarfãnjlji tu duh, cã a lor easti amirãriljea a tserurilor. ");
INSERT INTO rup_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ghinicuvãntats suntu atselji tsi vãiteascã, cã elji va s-diznjeardã. ");
INSERT INTO rup_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ghinicuvãntats sãntu atselji froninji, cã elji va mushtineadzã loclu. ");
INSERT INTO rup_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ghinicuvãntats suntu atselji tsi au foami shi seati ti ndriptati, cã elji va s-fãnãteascã. ");
INSERT INTO rup_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ghinicuvãntats suntu atselji njiluitsilji, cã elji va aflã njilã. ");
INSERT INTO rup_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ghinicuvãntats suntu atselji tsi suntu curats tu inimã, cã elji va lu veadã Dumnidzãlu. ");
INSERT INTO rup_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ghinicuvãntats suntu atselji tsi aducã pacea, cã elji va s-acljeamã hiljilji a Dumnidzãlui. ");
INSERT INTO rup_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ghinicuvãntats suntu atselji avinatsilji trã ndriptati, cã a lor easti amirãriljea a tserurilor. ");
INSERT INTO rup_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ghinicuvãntats va-hits voi cãndu va vã ngiurã, sh-va vã avinã, sh-arãdãnda, va dzãc tuti arãli contra voi, trã itia a mea. ");
INSERT INTO rup_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Hãrãsits-vã shi harãcupsits-vã, cã mari easti arãsplãtirea a voastrã tu tseruri, cã ashã lji avinarã sh-prufitsãlji nãintea a voastrã.” ");
INSERT INTO rup_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Voi hits sarea a loclui. Ma, macã sarea s-aspardzi cum poati su amintã njurizma? Nu fatsi di tsiva, di cãt trã arcari, shi su calcã oaminjili. ");
INSERT INTO rup_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Voi hits lunjina a lumiljei. Un cãsãbã adratã pri munti nu poati si s-ascundã. ");
INSERT INTO rup_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Tutashã nu s-aprindi un cãndilã tra si s-bagã sum vasã, ma tra si s-bagã pri shandan shi s-facã lunjinã trã tuts tsi suntu la casã. ");
INSERT INTO rup_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ashã s-lunjineadzã lunjina a voastrã nãintea a oamnjilor, tra s-veadã faptili a voastri atseali buni, shi s-mãreascã Tatãl a vostru tsi easti tu tseruri.” ");
INSERT INTO rup_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Nu minduits cã mini vinj s-aspargu legea icã prufitsilji. Mini nu vinj s-aspargu, ma s-li mplinescu. ");
INSERT INTO rup_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Cã dealihea vã dzacã: Pãnã cãndu tserlu shi loclu s-treacã, nitsi unã iotã sh-nitsi unã chicutã nu va s-trecã di legea, ma nãinti tsi si mplineascã tuti. ");
INSERT INTO rup_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Atsel tsi va ncalcã un di aesti ordini ma njitsi, sh-va s-aibã nvitsatã oaminjili, elu va s-acljeamã ma njiclu tu amirãriljea a tserurilor. Ma atsel tsi va li bagã tu practicã sh-va li-nveatsã a alantsãlor, va s-acljeamã ma marli tu amirãriljea a tserurilor. ");
INSERT INTO rup_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Trã atsea mini ma vã dzãc: macã ndriptatea a voastrã nu va s-lu treacã atsea a Scribilor sh-a Fariseilor, voi nu va s-intrats tu amirãriljea a tserurilor. ");
INSERT INTO rup_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Voi avets avdzãt cã fu dzãs a vecljilor: ‘Nu vatãmats. Caitsido tsi vatãmã va s-hibã sum giudicari.’ ");
INSERT INTO rup_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ma mini ma vã dzãc: Caitsido tsi s-nãrãeashti fãrã sibepi cu fratili a lui, va s-hiba giudicatã. Sh-cai lji dzãtsi a fratilui a lui: ‘Aspartã di-minti,’ va hibã sum giudicata al Sinedriu, sh-cai va lji dzãcã: ‘Glare,’ va hibã tu foclu ali Gheheni. ");
INSERT INTO rup_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Macã tini aduts doara a ta la altar, sh-aclo aduts aminti cã fratili a tãu ari tsiva contra tini, ");
INSERT INTO rup_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","alasã aclo doara a ta, nãintea a altarlui, sh-duti ma nãinti puituea-ti cu fratili a tãu sh-deapoea toarnã-ti shi dã doara a ta. ");
INSERT INTO rup_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Puituea-ti cu contrarlu a tãu, pãnã cãndu eshti la un cali cu nãsu, tsi s-nu ti prida contrarlu a tãu la giudicãtorlu, sh-giudicãtorlu s-ti prida la gardianlu sh-tini s-agiundz tu hapsi. ");
INSERT INTO rup_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Dealihea tsã dzãc cã nu va eshi di-aclo, ni plãtit centezimul a fundu. ");
INSERT INTO rup_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Voi avets avdzãt cã a vecljilor fu dzãsã: ‘Nu ncãlcats curuna.’ ");
INSERT INTO rup_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ma mini ma vã dzãcã cã caitsido tsi mutreashti unã muljeari tra s-u aibã, ari ncãlcatã curuna cu nãsã tu inima a lui. ");
INSERT INTO rup_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Macã ocljiul a tãu atsel ndreptu ti dutsi tu amãrtii, scoati-l shi arucã-l diparti di tini. Cã easti ma ghini ti tini tsi s-cherdzi un di mãdularili a tali, di cãt si s-arucã tu Ghehenã tut truplu a tãu. ");
INSERT INTO rup_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Sh-macã mãna a ta atsea ndreapta ti dutsi tu amãrtii, si-u talji shi si-u arutsi diparti di tini. Cã ma ghini easti s-cherdzi unu din mãdularili a tali, di cãt si s-arucã tu Ghehenã tut truplu a tãu. ");
INSERT INTO rup_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Fu dzãsã tutashã: ‘Cai alasã muljearea a lui, s-lji da cartea a dispãrtsãrilje.’ ");
INSERT INTO rup_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ma mini ma vã dzãcã: Cãtsido tsi u alasã muljearea a lui, di cãt tu arastea a putãnsiriljei, u fatsi s-ncalcã curuna. Caitsido tsi si nsoari cu unã muljear alãsatã ncalcã curuna. ");
INSERT INTO rup_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Voi avets avdzãtã tutashã cã a vecljilor fu dzãsã: ‘Nu fã spigiurari arãdioasi, ma mplinea spigiurarea a ta tsi lji ai faptã a Domnului.’ ");
INSERT INTO rup_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ma mini ma vã dzãcã: Nu spigiurats-vã dip, nitsi pri tserlu, cã easti thronlu a Dumnidzãului, ");
INSERT INTO rup_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","nitsi pri loclu, cã easti scamnul a cicioarilor a lui, nitsi pri Ierusalemlu cã easti cãsãbãlu a Amirãlu atsel marilui. ");
INSERT INTO rup_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nu ti spigiur nitsi pri caplu a tãu, cã nu ai fuchii s-alãgheshti icã s-lãeshti macari sh-un hir di per. ");
INSERT INTO rup_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ma sborlu a tãu s-hibã: ‘Ie, ie’ icã ‘Nu, nu.’ Cã itsido ma multu yini di la slablu. ");
INSERT INTO rup_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Voi avets avdzãtã cã fu dzãsã: ‘Ocljiu trã ocljiu shi dinti trã dinti.’ ");
INSERT INTO rup_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ma mini ma vã dzãcã: Nu lji ncuntreadzã a arãului (cu arãu). Macã vãrã ti agudeashti pri fatsa atsea nandreapta, toarnã-lji sh-alanta. ");
INSERT INTO rup_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Sh-macã vãrã va ti ducã tu giudic, tra s-ljea tunica a ta, dã-lji sh-mantelul. ");
INSERT INTO rup_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Shi macã vãrã ti strindzi sã imnji unã milje, tini fã doauã cu nãsu. ");
INSERT INTO rup_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Dã-lji a tsilui tsi ts-caftã, sh-nu arnisea s-lji dai atsilui tsi ts-caftã mprumutã. ");
INSERT INTO rup_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Voi avets avdzãtã cã fu dzãsã: ‘S-vrei aproapilu a tãu shi s-aurãshti neamiclu a tãu.’ ");
INSERT INTO rup_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ma mini ma vã dzãcã: S-vrets neamitsilji a voshtri, ghinicuvãntats atselji tsi vã blastimã. Fãtsets ghini atsilor tsi vã aurãscu, shi pãrãcãlsits-vã trã atselji tsi vã fac arãu, shi vã aĝunescu, ");
INSERT INTO rup_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","tra s-hits hiljilji a Tatãlui a vostru tsi easti tu tseruri. Cã elu fatsi s-easã soarili a lui pri bunjilji shi pri arãljilji, shi fatsi s-da ploai pri ndreptsãlji shi pri nidreptsãlji. ");
INSERT INTO rup_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Cã ma s-vrets mash atselji tsi vã vor, tsi arãsplatã va avets? Nu fac ashã shi taxidarlji? ");
INSERT INTO rup_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Sh-macã salutats mash fratsãlji a voshtri, tsi ma multã dicãt altsãlji fãtsets voi? Nu fac ashã sh-pãngãnilji? ");
INSERT INTO rup_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","S-hits ashã perfectsã ashã cum easti perfect sh-Tatãl a vostru tserescu.” ");
INSERT INTO rup_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Isusul dzãsi: “Bãgats mintea s-nu fãtsets ghini nãintea a oaminjilor, tsi elji s-vã alavdã a voauã, altã soi nu va vã arãsplãtits di la Tatãl a vostru tsi easti tu tseruri. ");
INSERT INTO rup_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Cãndu s-dai dicunji, nu bati trumpeta nãintea a ta, ashã cum fac ipucritsilji tu sinagogã sh-pri cãljiuri, tra s-hibã tinjisits di oaminjli. Dealihea vã dzãc ca elji tora u-au loatã arãsplata a lor. ");
INSERT INTO rup_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Cãndu fatsi ghini, astãnga a ta s-nu shtii tsi fatsi a andrepta a ta. ");
INSERT INTO rup_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Cãndu u fats buneatsa a ta, s-facã pri ascumtu. Sh-Tatãl a tãu tsi veadi pri ascumtu, el va-ti arãsplãteascã a tsãia nãintea a tutulor. ");
INSERT INTO rup_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Sh-cãndu tini ti pãrãcãlseshti, nu ti fã ca ipucritslji cã a lor lã arãseashti s-pãrãcãlseascã mproshtsi tu sinagogã, sh-tu pãdzili a cãljurilor tra s-hibã vidzuts di oamnjilji. Dealihea vã dzãc cã elji tora u au loat arãsplata a lor. ");
INSERT INTO rup_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ma tini candu s-ti pãrãcãlseshti intrã tu udãlu a tãu, ncljidi usha sh-pãrãcãlseati a Tatãlui a tãu pri ascumtu. Sh-Tatãl a tãu tsi veadi pri ascumtu va ti arãsplãteascã nãintea a tutulor. ");
INSERT INTO rup_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Cãndu vã pãrãcãlsits s-nu folosits idyili zboari ca pãngãnjilji, cã elji mindueascã cã va si-mplineascã pãrãcãlsirea cã au dzãsã multi zboari. ");
INSERT INTO rup_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nu vã fãtsets ca atselji, cã Tatãl a vostru li shtii tuti di tsi avets ananghi, ma nãinti tsi voi s-li cãftats. ");
INSERT INTO rup_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ma voi pãrãcãlsits-vã ashã: ‘Tatãl a nostru tsi eshti tu tseruri, si sãmtseascã numa a ta. ");
INSERT INTO rup_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","S-yinã amirãriljea a ta. Si s-facã vrearea a ta tu loc, ashã di cum tu tser. ");
INSERT INTO rup_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Pãnea a noastrã di cathi dzuã, dã-nã-u a noauã azã. ");
INSERT INTO rup_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Sh-ljeartã-nã amãrtiili a noastri, ashã di-cum sh-noi lã ljirtãm a amãrtioshilor a noshtri. ");
INSERT INTO rup_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Sh-nu nã alasã s-cãdem tu cãrteari, ma nã ascapã di atsel arãu. Cã a ta easti amirãriljea, sh-putearea, sh-mãrirea di totãna. Amen.’ ");
INSERT INTO rup_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Cã macã voi lã ljirtats a oamnjilor amãrtiili a lor, Tatãl a vostru dit tser va vã li ljeartã sh-a voauã. ");
INSERT INTO rup_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ma, macã voi nu lã ljirtats a oamnjilor amãrtiili a lor, nitsi Tatãl a vostru nu va li ljeartã amãrtiili a voastri. ");
INSERT INTO rup_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Sh-cãndu s-tsãnets pãreasini s-nu vã spunets nvirinats ca ipucritsilji. Cã elji aspargã fãtsili tsi s-aspunã a oamnjilor cã tsãnã pãreasini. Dealihea vã dzãc cã elji tora u-au loatã arãsplata a lor. ");
INSERT INTO rup_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Iarã tini, cãndu s-tsãnji pãreasini, aundzi caplu sh-aspealã fatsa a ta, ");
INSERT INTO rup_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","tra s-nu lã aspunji a oamnjilor cã tini ma tsãnji pãreasini, ma a Tatãlui a tãu pri ascumtu sh-Tatãl a tãu cai mutreashti pri ascumtu, va ti arãsplãteascã nãintea tutulor.” ");
INSERT INTO rup_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Nu adunats trã voi ayishteari pri loc, iu li aspargã molitsa sh-arudzina, sh-iu furlji sapã shi furã. ");
INSERT INTO rup_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ma aduanats trã voi ayishteari tu tser, iu nitsi molitsa, nitsi arudzina nu li aspargu, sh-iu furlji nu sapã shi nu furã. ");
INSERT INTO rup_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Cã iu easti ayishtearea a vostrã, aclo va s-hibã sh-inima a voastrã. ");
INSERT INTO rup_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Lunjina a truplui easti ocljiul. Macã ocljilu a tãu easti curat, tut truplu va s-hibã lunjinat. ");
INSERT INTO rup_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Macã ocljiul a tãu easti arãu, tut truplu a tãu va s-hibã tu scutidi. Macã lunjina tsi easti la tini easti scutidi, cãt ma mari va s-hibã scutidlu! ");
INSERT INTO rup_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Vãrã nu poati s-huzmitipseascã la doi domnji. Cã icã va s-lu aurascã unlu sh-va alantu, icã va armãn pistimen la unu, sh-va dispretsueascã alantu. Nu pots s-huzmitipseshti a Dumnidzãlui sh-a pãradzãlor.” ");
INSERT INTO rup_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Trã atsea ma vã dzãc: Nu vã minduits ti bana a voastrã, tsi va mãcats shi tsi va bets, nits ti truplu a vostru trã atsea tsi va nvishtets. Vahi nu easti bana ma scumpã di cãt hrana, sh-truplu ma scumpu di nvishtearea? ");
INSERT INTO rup_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mutrits puljilji a tserlui, elji nu seaminã, nitsi seatsirã, nu adunã tu hãmbãri, cu tut atsea Tatãl a vostru dit tser lji hrãneshti. Nu custusits voi ma multu di cãt atselji? ");
INSERT INTO rup_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Sh-cai di voi cu tut cãshtiga a lui poati s-adavgã la statura a lui macari un cubit singur? ");
INSERT INTO rup_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Cã tse vã cãrtits di nvishtearea a voastrã? Mutrits cum creascã zãmbatsilji a cãmpului, nu lucreadzã sh-nitsi torcu. ");
INSERT INTO rup_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Sh-ma vã dzãc cã nitsi Solomonul, cu tutã mãrirea a lui, nu eara nviscutã ca vãrã di elji. ");
INSERT INTO rup_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Tora macã Dumnidzãlu u-nveashti ashã iarba a cãmpului tsi azã easti sh-mãni va si s-arucã tu cireapu, vahi nu va vã-nveascã a voauã ma multu, oaminji pisti-putsãn? ");
INSERT INTO rup_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Nu vã cãrtits dzãcãnda: ‘Tsi va mãcãm icã tsi va bem, icã cu tsi va nã nvishtem?’ ");
INSERT INTO rup_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Cã suntu pãngãnjili tsi caftã tuti aesti lucri. Tatãl a vostru di tser lu shti ghini cã voi avets ananghi trã tuti aesti lucri. ");
INSERT INTO rup_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ma, nãnti di tuti cãftats amirãriljea a Dumnidzãlui shi ndriptatea a lui sh-tuti aesti ananghi va s-vã adavgã a voauã. ");
INSERT INTO rup_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","S-nu avets gaile trã dzua di mãni. Cã dzua di mãni va si s-cãshtigheadzã di nãsã. Lj-agiundzi a dzuãljei arãutatea a ljei.” ");
INSERT INTO rup_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Isusul dzãsi: “Nu giudicats, tra s-nu s-hits giudicats. ");
INSERT INTO rup_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Cã voi va vã giudicats dupã giudicarea tsi voi fãtsets, sh-cu metrul tsi misurats, va vã misurats. ");
INSERT INTO rup_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Cãtse vedz paljiu tu ocljiul a fratilui a tãu, sh-nu vedz grenda tu ocljiul a tãu? ");
INSERT INTO rup_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Icã, cum pots s-lji dzãtsi a fratilui a tãu: ‘Ashteaptã s-tsã scot paljiu dit ocljiu’, cãndu ai un grendã tu ocljilul a tãu? ");
INSERT INTO rup_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ipocrite, scoati ma nãinti grenda dit ocljiul a tãu, sh-deapoea va vedzi curatã tra s-lji scots paljiul dit ocljiul a fratilui a tãu. ");
INSERT INTO rup_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Nu lã dats a cãnjilor tsi easti sãmtã sh-nu lã-arucats mãrgãritãrili a voastri nãintea a portsilor, tsi s-nu li ncalcã cu cicioari shi si s-toarnã contra voi shi s-vã disicã.” ");
INSERT INTO rup_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Dicunjats sh-va vã da, cãftats sh-va aflats, asunats la ushã shi va vã si dischljidã. ");
INSERT INTO rup_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Cai dicunji, ljea. Cai caftã, aflã, sh-va si discljidã atsilui tsi asuni. ");
INSERT INTO rup_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ari vãrã om namisa di voi, tsi ma s-lji caftã hiljiu pãni, s-lji da cheatrã? ");
INSERT INTO rup_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Icã ma s-lji caftã peshti, s-lji da nãpãrticã? ");
INSERT INTO rup_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Atumtsea, macã voi tsi hits arãi shtits s-dats doari buni a hiljilor a voshtri, ahãt ma multu Tatãl a vostru, tsi easti tu tseruri, va da lucri buni atsilor tsi lj-caftã. ");
INSERT INTO rup_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Itsido tsi voi vrets s-vã facã oaminjili, fãtsets-li sh-voi atsilor, cã aestã easti Legea sh-Prufitsilji. ");
INSERT INTO rup_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Intrats pri poarta atsea strimta, cã largã easti poarta sh-mari easti calea tsi ti dutsi tu aspãrdzeari, sh-mutlsã suntu atselji tsi intrã prit nãsã. ");
INSERT INTO rup_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ma strimtã easti poarta sh-greauã easti calea tsi dutsi tu banã! Sh-putsãnji suntu atselji tsi u-aflã.” ");
INSERT INTO rup_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Afirits-vã di prufitsãlji arãdioshi, tsi yin la voi nvãscuts ca oi, ma di nãuntru suntu luchi arãchitori. ");
INSERT INTO rup_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Voi va lji cunushtets di frutili a lor. S-adunã vahi aua di la pãljuiri, icã hits di la scalji? ");
INSERT INTO rup_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ashã itsi pom bun da fruti buni, iarã pomlu atsel arãu da fruti arali. ");
INSERT INTO rup_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nu poati un pom bun s-da fruti arali, nitsi un pom arãu s-da fruti buni ");
INSERT INTO rup_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Itsi pom tsi nu da fruti buni, si s-talji shi s-arucã tu foc. ");
INSERT INTO rup_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Voi va lji cunushtets prufitsãlji di frutili a lor. ");
INSERT INTO rup_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Nu itsi om tsi nj-dzãtsi: ‘Doamne, Doamne,’ va intrã tu amirãriljea a tserurilor. Ma va intrã singur atsel tsi fatsi vrearea a Tatãlui a meu tsi easti tu tseruri. ");
INSERT INTO rup_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Multsã va nji dzãcã tu atsea dzuã: ‘Doamne, Doamne, nu prufitipsimã tu numa a ta? Nu l-aĝunim demonjilji tu numa a ta? Sh-nu avem faptã multi thavmati tu numa a ta?’ ");
INSERT INTO rup_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Sh-atumtsea va lã spunã a lor: ‘Mini nu vã am cunuscut pute. Dipãrtats-vã di la mini, voi tuts, tsi avets lucrat anapuda.’ ” ");
INSERT INTO rup_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Trã atsea caitsido tsi li avdi aesti zboari a meali sh-li mplineashti, undzeashti cu un om mintimen, tsi u-ari adratã casa a lui pri cheatrã. ");
INSERT INTO rup_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Sh-deadi ploai, vini nãcarea, s-uflarã vimturi, shi s-plãscãnirã pri atsea casã, ma ea nu cãdzu, cã eara thimiljeatã pri cheatrã. ");
INSERT INTO rup_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Iarã caitsido tsi lã avdi zboarili sh-nu li mplineashti, undzeashti cu un glar, tsi u adrã casa a lui tu arinã. ");
INSERT INTO rup_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Sh-deadi ploai, vini nãcarea, s-uflarã vimturi, s-plãcsãnirã pri atsea casã sh-ea cãdzu, sh-aspãrdzerea a ljei eara mari.” ");
INSERT INTO rup_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Tora, cãndu Isusul ascãpã di-aesti zboari, multsãnjili armasirã ciudisiti di nvitsãtura a lui, ");
INSERT INTO rup_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","cã elu lã nvitsa ca un om cu puteari, sh-nu ca scriblji. ");
INSERT INTO rup_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Tora cãndu Isusul dipunã dit munti, multsãmi mãri lu urma. ");
INSERT INTO rup_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Sh-ia, un lepros vini sh-si ncljinã, dzãcãnda: “Doamne, ma s-vrei tini pots s-mi curi.” ");
INSERT INTO rup_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Sh-Isusul timsi mãna, lu bãgã pi nãs sh-lji-dzãsi: “Ie, mini voi, curã-ti!” Sh-tu atsea oarã s-vindicã di lepra a lui. ");
INSERT INTO rup_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Atumtsea Isusul lji dzãsi: “Vedzi, si nu lj-spunji a vãrui, ma duti nãintea a preftului, sh-fã doara tsi ari ursitã Moisiul tsi aestã s-hibã mãrtirii trã caitsido.” ");
INSERT INTO rup_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Cãndu Isusul intrã tu Capernaum, lji vini un tsenturion pãrãcãlsinda, ");
INSERT INTO rup_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","shi lji dzãsi: “Doamne, sclavul a meu easti paralizat tu pat n-casã shi ma s-mundueashti multu.” ");
INSERT INTO rup_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Sh-Isusul lji dzãsi: “Va yin shi va lu vindicã.” ");
INSERT INTO rup_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Tsenturionlu apãndisinda lji dzãsi: “Doamne, mini nu escu axiu tsi tini s-intsri tu streaha a mea, ma dzã mash un zbor shi sclavlu a meu va si s-vindicã. ");
INSERT INTO rup_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Cã sh-mini escu un om sum autoritatea a altsilor, sh-lji-am suldatslji sum mini. Ma s-lji dzãc a unui: ‘Duti!’, elu s-dutsi, shi ma s-lji dzãc a altui: ‘Ajdi!’, elu yini, shi ma s-lji dzãc a sclavulu a meu: ‘Fã aestã!’, elu u-fatsi.” ");
INSERT INTO rup_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Cãndu Isusul lavdzã aestã, s-ciudisi sh-lã dzãsi atsilor tsi lu urma: “Dealihea ma vã dzãc, cã iuva tu Israel nu aflai un pisti ahãntã mari. ");
INSERT INTO rup_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mini ma vã dzãc cã multsã va yin di la rãsãrit sh-di la ascãpitat, sh-va apunã la measã cu Abrahamul, cu Isacul sh-cu Iacovul tu amirãriljea a tserurilor, ");
INSERT INTO rup_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ma hiljilji a amirãriljei, atselji aleptsã di la Dumnidzãlu, va hibã arcats tu scutidlu di nafoarã. Aclo va hibã plãngul sh-cãrtsãnirea a dintsilor.” ");
INSERT INTO rup_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Atumtsea Isusul lji dzãsi a tsenturionul: “Du-ti, shi si s-facã ashã cum pistipsishi!” Sclavul s-vindicã tu atsea oarã. ");
INSERT INTO rup_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Deapoea Isusul intrã tu casa a Petrului sh-vidzu soacra a lui tsi eara tu pat cu hevri. ");
INSERT INTO rup_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Candu elu lji bãgã mãna hevrili u-alãsarã. Sh-ea si sculã sh-ahurhi s-lji huzmitipsea a lui. ");
INSERT INTO rup_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Cãndu vini seara, lji adusirã multsã demonizatsi, sh-elu cu zbor aĝuni duhurili sh-vindicã tuts lãndzitslji, ");
INSERT INTO rup_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","tsi ashã si mplineascã zborlu a prufitlui Isaia cãndu dzãsi: “Elu li lo niputerili a noastri sh-li purtã lãngoarili a noastri.” ");
INSERT INTO rup_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Cãndu Isusul vidzu anvãrliga di nãsu multsãmi mãri, ordinã s-treacã di napãrti. ");
INSERT INTO rup_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Atumtsea un scrib s-apruche sh-lji dzãsi: “Nvitsãtore, mini va ti urmedzu iutsido tsi va ti duts.” ");
INSERT INTO rup_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Sh-Isusul lji dzãsi: “Vulpili au guvãli a lor, sh-puljilji a tserlui au cuibairili, ma Hiljiu a omlui nu ari iu s-bagã caplu.” ");
INSERT INTO rup_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Deapoea un din ucenitsilji a lui lji dzãsi: “Doamne, dã-nji volje ma nãinti s-mi duc s-ngrop tatãl a meu.” ");
INSERT INTO rup_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ma Isusul lji dzãsi: “Urmeadz-mã, sh-alasã mortsãlji s-ngroapã mortsãlji a lor.” ");
INSERT INTO rup_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Dupã tsi elu s-alinã tu varcã, ucenitsilji a lui lu-urmarã. ");
INSERT INTO rup_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Sh-ia, tu amari si sculã unã furtunã mari, sh-vãljurili ma anvãlea varca, ma Isusul durnjea. ");
INSERT INTO rup_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","S-apruchearã la nãsu ucenitsilji a lui, lu dishtiptarã shi lji dzãsirã: “Doamne, ascapã-nã, cã noi ma nã nicãm.” ");
INSERT INTO rup_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Isusul lã dzãsi a lor: “Cãtse avets fricã, voi oaminj cu pisti-putsãnã?” Cum si sculã, aurlã a vimturilor sh-a amariljei shi s-featsi tãtseari mari. ");
INSERT INTO rup_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Atumtsea oaminjli s-thãvmãtisirã shi dzãtsea: “Cai easti aestu, tsi ma lu ascultã vimturli shi amarea?” ");
INSERT INTO rup_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Cãndu Isus agiumsi tu alantã parti tu loclu a Gadarenjilor, lji ishirã nãinti doi demonizats tsi avea ishitã di murmintsã. Elji eara ahãntu turbatsi, cãt nitsunu nu putea s-tritsea pi atsea cali. ");
INSERT INTO rup_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Sh-ia, elji ahurhirã s-aurlã: “Tsi ai cu noi, Isus, Hiljiu a Dumnidzãlui? Ai vinit aoa s-nã mundueshti ma nãinti di oara tsi prindi?” ");
INSERT INTO rup_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Sh-nu multu diparti di nãshi un cupii mari di portsi ma pãshtea. ");
INSERT INTO rup_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Atumtsea demonjilji s-pãrãcãlsirã a lui: “Macã nã aĝuneshti, alasã-nã s-intrãm tu atsea cupii di portsi.” ");
INSERT INTO rup_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Elu lã dzãsi a lor: “Dutsets-vã!” Ashã elji dupã tsi ishirã, intrarã tu atsea cupii di portsi. Ia, tutã cupia s-arcã di ripã tu amari, shi s-nicarã tu apã. ");
INSERT INTO rup_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Atselji tsi lã pãshtea fudzirã tu cãsãbã sh-cãndu agiumsirã aclo spusirã tuti aesti, tutashã tsi avea undzitã cu demonizatsilji. ");
INSERT INTO rup_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Atumtsea, tutã cãsãbãlu ishi nãintea a Isusului. Cãndu lu vidzurã lji pãrãcãlsirã tsi s-dipãrta dit loclu a lor. ");
INSERT INTO rup_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Isusul dupã tsi intrã tu varcã, tricu tu alantã parti, shi vini tu cãsãbãlu a lui. ");
INSERT INTO rup_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Sh-ia, lji adusirã un om paralizat tu pat, sh-Isusul cãndu vidzu pistea tsi avea elji, lji dzãsi a paralizatlui: “S-ai curaiu, hiljle, amãrtili a tali suntu ljirtati!” ");
INSERT INTO rup_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Atumtsea niscantsã scribi dzãsirã cu mintea a lor: “Aestu ma blastimã!” ");
INSERT INTO rup_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ma Isusul cunuscãnda minduirili a lor dzãsi: “Cãtse minduits lucri arali tu ininjili a voastri? ");
INSERT INTO rup_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Tsi easti ma lishor trã dzãtseari: ‘Amãrtiili a tali suntu ljirtati,’ icã: ‘Scoalã-ti sh-imnã’? ");
INSERT INTO rup_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ma tora tsi s-shtits cã Hiljiu a omlui ari puteari pri loc s-ljeartã amãrtiili.” Lji dzãsi a paralizatlui: “Scolã-ti, ljea patlu sh-duti la casã a ta.” ");
INSERT INTO rup_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Sh-elu si sculã shi s-dusi la casã a lui. ");
INSERT INTO rup_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Multsãnjili cãndu lu vidzurã aestã, s-ciudisirã sh-mãrirã Dumnidzãlu, tsi avea datã a oamnjilor ahtari puteari. ");
INSERT INTO rup_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Deapoea cãndu s-dusi Isusul nclo, vidzu un om tsi shidea la yimbruchi, acljimatã Mateu, sh-lji-dzãsi: “Urmeadzã-mã!” Sh-elu si sculã sh-lu urmã. ");
INSERT INTO rup_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Cãndu Isusul shidea la measã la casã, vinirã multsã taxidari sh-amãrtioshi, s-apunarã sh-mãcarã deadun cu nãsu sh-cu ucenitsilji a lui. ");
INSERT INTO rup_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Fariseilji cãndu vidzurã aestã, lji dzãsirã a ucenjitsilor a lui: “Cãtse nvitsãtorlu a vostru mãcã cu taxidarlji sh-cu amãrtioshlji?” ");
INSERT INTO rup_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Candu Isusul avdzã aesti, lã dzãsi a lor: “Nu suntu sãnãtoshlji tsi au ananghi di doctor ma atselji lãndzitslji. ");
INSERT INTO rup_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Tora dutsets-vã sh-nvitsats tsi va s-dzac: ‘Mini voi njilã sh-nu curbani.’ Cã nu vinj s-acljem trã mitãnjusiri ndreptsãlji, ma amãrtioshlji.” ");
INSERT INTO rup_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Atumtsea s-apurchearã ucenitsilji a Ioanului shi ntribarã: “Cãtse noi sh-Fariseilji tsãnem pãreasinji di multi ori, iarã ucenitsilji a tãlji nu tsãn pãreasinji?” ");
INSERT INTO rup_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Isusus lã dzãsi a lor: “Pot numtarlji s-aibã jali, pãnã cãndu dzinirli easti cu nãshi? Ma va yin chirolu cãndu va lu ljea dzinirli di la elji sh-atumtsea elji va s-aĝiuneadzã. ");
INSERT INTO rup_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Vãrã nu bagã tu stranji veclji un petic nou, cã altã soi arupi stranjiu shi azmuldzearea s-fatsi ma mari. ");
INSERT INTO rup_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Vãrã nu bagã yinlu atsel noulu tu folji veclji, cã altã soi foljilji s-arup, yinlu s-vearsi sh-foljilji chearã. Ma yinlu atsel noulu s-bagã tu folji noauã, ashã veaglji un-alantu.” ");
INSERT INTO rup_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Cãndu Isusul lj-dzãtsea aestã, s-apruche un di mãrilji a sinagogãljei, cãdzu pri dintsã nãintea a lui sh-lji-dzãsi: “Macãt nj-muri hiljea, haidi sh-bagã mãna pri nãsã sh-ea va bãneadzã.” ");
INSERT INTO rup_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Isusul si sculã shi s-dusi dupã nãsu deadun cu ucenitsilji a lui. ");
INSERT INTO rup_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Sh-ia, unã muljeari tsi di doisprãdzãtsi di anji lj-cura sãndzili, s-apruche di nãpoi sh-bãgã mãna tu mardzina a stranjilui a lui. ");
INSERT INTO rup_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Cã dzãtsea cu mintea a ljei: “Ma s-bagã mãna la stranjiu a lui, va mi vindicã.” ");
INSERT INTO rup_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Isusul s-turnã, lu vidzu sh-dzãsi: “S-ai curaiu hiljea a mea, pistea a ta ti vindicã.” Shi tu ora atsea muljearea s-vindicã. ");
INSERT INTO rup_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Cãndu Isusul agiumsi la casa a mãrilui a sinagogãljei sh-vidzu fluerãtorilji sh-multsãmea turburatã, ");
INSERT INTO rup_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","lã-dzãsi a-lor: “Dipãrtats-vã cã feata nu ari murit, ma doarmi.” Sh-elji arãsirã cu nãsu. ");
INSERT INTO rup_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Deapoea, cãndu multsãmea u-scoasirã nafoarã, elu intrã, u-acãtsã di mãnã sh-ea si sculã. ");
INSERT INTO rup_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Shi anamea aishtei anami s-disfeatsi tu tut loclu. ");
INSERT INTO rup_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Cãndu Isusul ma fudzea di aclo, doi orghi lu urma aurlãnda sh-dzãcãnda: “Njilua-nã noi, Hiljiu al David!” ");
INSERT INTO rup_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Cãndu Isusul agiumsi la casã, orghilji s-apruchearã sh-elu lã dzãsi a lor: “Pistipsits voi cã mini pot s-u fac aestã?” Elji apãndisirã: “Ie, Doamne.” ");
INSERT INTO rup_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Atumtsea elu bãgã mãna la ocljilji a lor, dzãcãnda: “Si s-facã dupã pistea a voastrã.” ");
INSERT INTO rup_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Deapoea a lor lã si discljisirã ocljilji. Sh-Isusul lã ordinã dzãcãnda: “Videts s-nu shtibã vãrã om.” ");
INSERT INTO rup_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ma elji macãt ishirã u arãspãndirã anamea a lui tu tut loclu. ");
INSERT INTO rup_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Cãndu elji ma isha, lji adusirã un bãrbat mut shi demonizat. ");
INSERT INTO rup_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Dupã tsi Isusul aĝuni demonul, mutlu grãi. Sh-multsãnjili s-ciudisirã sh-dzãsirã: “Nu easti vidzut pute un ahtar lucru tu Israel!” ");
INSERT INTO rup_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ma Fariseilji dzãtsea: “Elu aĝuneashti demonjilji cu agiutarea a printslui a demonjilor.” ");
INSERT INTO rup_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Isusul tritsea pri tuti cãsãbadzili sh-hoarili, nvitsãnda tu sinagogãli a lor, predicãnda evanghelul a amirãriljei, shi vindicãnda itsi lãngoari sh-itsi niputeari tu popul. ");
INSERT INTO rup_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Cãndu vidzu multsãnjili avea njilã trã nãshi, cã eara nvirinati sh-arãspãnditi ca oili fãrã picurar. ");
INSERT INTO rup_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Atumtsea elu lã dzãsi a ucenitsilor a lui: “Sitsirarea easti dealihea mar, ma lucrutorilji suntu putsãnji. ");
INSERT INTO rup_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Pãrãcãlsits-vã, a Domnului a sitsirãrilor s-pitreacã lucrutori la sitsirãrili a lui.” ");
INSERT INTO rup_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Atumtsea Isusul lã acljimã di doisprãdzatsi ucenitsilji a lui ningã nãsu, sh-lã deadi autoritat s-li aĝuneascã duhurili atseali nicuarati, shi s-vindicã itsi lãngoari sh-itsi niputeari. ");
INSERT INTO rup_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Aesti suntu numili a doisprãdzatsi apostulji: protlu Simonul acljimat Petru, shi Andrea, fratili a lui, Iacovul hiljiu al Zevedeu, shi Ioanul, fratili a lui, ");
INSERT INTO rup_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipul sh-Bartolomeu, Toma sh-Mateu taxidarlu, Iacovul hiljiu al Alfeu, sh-Tadeul, ");
INSERT INTO rup_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon Cananeulu, sh-Iuda Iscariotul atsel tsi deapoea lu prideadi. ");
INSERT INTO rup_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Aeshti suntu di doisprãdzatslji tsi Isusul lji pitricu sh-lã deadi ordinli aesti: “Nu vã dutsets cãtrã pãngãnjili sh-nu intrats tu vãrã cãsãbã a Samaritenjilor. ");
INSERT INTO rup_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ma dutsets-vã ma ghini la oili atseali chiruti di la casa al Israel. ");
INSERT INTO rup_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Dutsets-vã sh-predicats, dzãcãnda: ‘Amirãriljea a tserurilor s-apruche.’ ");
INSERT INTO rup_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Vindicats lãndzitsãlji, curats leproshilji, injiats mortsãlji, aĝunits demonjili. Geaba loatã, geaba s-dats. ");
INSERT INTO rup_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Nu adunats furii, nitsi asimi, nitsi bãcãr tu punga a voastrã, ");
INSERT INTO rup_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","nitsi tastru ti cali, nitsi doauã pãreclji di tunicã, nitsi sandali, nitsi ciumagã, cã lucrutorlu easti axiu ti hranea a lui. ");
INSERT INTO rup_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Tu itsi cãsãbã icã hoarã tsi s-intrats, ntribats macã ari aclo vãrã om axiu, shi shãdets aclo pãnã-cãndu s-vã nchisits. ");
INSERT INTO rup_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Shi cãndu s-intrats tu casã, s-lu salutats. ");
INSERT INTO rup_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Sh-macã atsea casã easti axiu, va yinã pacea a voastrã pri ea, macã nu easti axiu, pacea a voastrã va s-toarnã nãpoi la voi. ");
INSERT INTO rup_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Sh-macã vãrã nu vã ashteaptã, sh-nu lã avdi zboarili a voastri, ishinda di atsea casã icã di atsel cãsãbã, scuturats puhlu di cicioarili a voastri. ");
INSERT INTO rup_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Dealihea ma vã dzãc cã tu dzua a giudicatiljei loclu a Sodomãljei sh-a Gomoriljei va hibã cu ma multã lishureatsã di atsel cãsãbã. ");
INSERT INTO rup_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ia, mini ma vã-pitrecã ca oili namisa di luchilji. S-hits mintimenji ca nãpãrtisili sh-curats ca purunghilji. ");
INSERT INTO rup_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Afiritsi-vã di oaminjili cã va s-vã prida nãintea a sinedriului a lor, shi va s-vã batã tu sinagogãli a lor. ");
INSERT INTO rup_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Sh-va vã aducã nãintea a guvernatorilor sh-nãintea a amiradzilor trã itia a mea, tsi s-mãrtirsits nãintea a lor shi a pãgãnjilor. ");
INSERT INTO rup_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Sh-cãndu s-vã prida tu mãnjili a lor, nu vã minduits cã tsi va s-grits, cã tu atsea oarã va vã si da atsea tsi prindi dzãtsets. ");
INSERT INTO rup_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Cã nu va s-hits voi tsi grits, ma Duhlu a Tatãlui a vostru tsi va s-greascã trã voi. ");
INSERT INTO rup_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Tora fratili va prida frati-su la moarti, sh-tatili hiljiu a lui, cilmenjilji va si scoalã contra a pãrintsãlor, sh-va lji vatãmã. ");
INSERT INTO rup_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Sh-tuts va vã aurascã trã numa mea, ma atsel tsi va aravdã pãnã tu soni va s-ascapã. ");
INSERT INTO rup_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Cãndu vã s-aĝuneascã tu un cãsãbã, fudzits tu un altã, cã dealihea vã dzãc, cã nu va s-bitisits tricãnda cãsãbadzili a Israelui ma nãinti tsi s-yinã Hiljiu a omlui. ");
INSERT INTO rup_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Uceniclu nu easi prisupru di nvitsãtorlu a lui, nitsi servitorlu prisupru di nicuchirlu a lui. ");
INSERT INTO rup_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Lj-agiundzi a uceniclui si s-facã ca nvitsãtorlu a lui, sh-a huzmichearlu ca nicuchirlu a lui. Macã nicuchirlu a casiljei lu acljimarã Belzebub, ahãntu ma multu va s-lji acljeamã ashã atselji a casiljei a lui! ");
INSERT INTO rup_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","S-nu avets fricã, cã nu ari tsiva anvãlitã tsi nu s-dizvãleascã, sh-vãrã tsiva ascumtu tsi nu va s-facã cunuscutã. ");
INSERT INTO rup_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Atsea tsi mini vã dzãc tu scutidi, dzãtsets-u tu lunjinã, sh-atsea tsi avdzãts tu ureclji, predicats-u pri citii. ");
INSERT INTO rup_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Sh-nu vã aspãrats di atselji tsi vatãmã truplu, ma nu pot s-vatãmã suflitul. S-vã aspãratsã ma multu di atsel tsi poati s-chearã suflitlu sh-truplu tu Gehenã. ");
INSERT INTO rup_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Nu s-vindu vahi doi harabelji ti un aspru? Cu tut atsea nitsiunu di elji nu cadi mpadi fãrã vrearea a Talãlui a vostru. ");
INSERT INTO rup_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ma a voauã sh-perilji di capã vã suntu numirati. ");
INSERT INTO rup_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","S-nu avets fricã! Voi custusits ma multu di multsã harabelji. ");
INSERT INTO rup_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Trã atsea, caitsido tsi va mãrtiriseascã ti mini nãintea a oamnjilor, sh-mini va mãrtirisescu nãintea a Tatãlui a meu, tsi easti tu tseruri. ");
INSERT INTO rup_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ma caitsido tsi va mi aleapid nãintea a oamnjlor, sh-mini va lu aleapid nãintea a Tatãlui a meu tsi easti tu tseruri. ");
INSERT INTO rup_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","S-nu vã minduits cã mini am vinit s-aducã pacea pri loc. Nu vinj s-aducã pacea, ma spata. ");
INSERT INTO rup_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Cã mini vinj s-dispartu hiljiu di tatãl, hiljea di muma, sh-nveasta di soacra, ");
INSERT INTO rup_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","sh-neamitsilji a omlui va hibã atselji di casa a lui. ");
INSERT INTO rup_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Atsel tsi va tatãl, icã mumã ma multu dicãt mini, nu easti axiu trã mini. Sh-atsel tsi va hiljiu icã hiljiea ma multu dicãt mini, nu easti axiu trã mini. ");
INSERT INTO rup_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Sh-atsel tsi nu ljea crutsea a lui sh-nu yini dupã mini, nu easti axiu trã mini. ");
INSERT INTO rup_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Cai va s-tsãnã bana a lui va u-chearã, ma atsel tsi va u-chearã trã mini va u-aflã. ");
INSERT INTO rup_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Atsel tsi vã aproachi, mi aproachi mini, sh-atsel tsi mi aproachi mini, aproachi atsel tsi mi ari pitricut. ");
INSERT INTO rup_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Atsel tsi aproachi un prufit tu numa a prufitului, va ljea arãsplata a prufitlui. Sh-atsel tsi aproachi ndreptul tu numa a ndreptului, va ljea arãsplata a ndreptului. ");
INSERT INTO rup_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Sh-caitsido tsi lj-da di beari un putir di apã aratsi a vãrui di aeshti njitsi, tu numa a unui ucenic, dealihea vã dzãc cã elu nu va s-chearã pute rãsplãtirea a lui.” ");
INSERT INTO rup_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Dupã tsi Isusul bitisi darea a dimãndãrilor a lui a doisprãdzatsi di ucenitsi a lui, fudzi di atsel loc, trã nvitsari sh-trã predicari tu cãsãbadzili di Galilea. ");
INSERT INTO rup_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ioanul, tsi avea avdzãt tu hapsi si zbura di faptili a Hristolui, pitricu doi di ucenitsilji a lui ");
INSERT INTO rup_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","s-lji dzãtsea: “Eshti tini atsel tsi prindi s-yin, icã prindi s-ashtiptãm vãrã altu?” ");
INSERT INTO rup_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Sh-Isusul apãndisi a lor: “Imnats shi spunets a Ioanului aesti tsi avdzãts sh-videts: ");
INSERT INTO rup_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Orghilji ma ved, shcljiochilji ma imnã, leprozilji suntu curats, surdzãlji ma avdu, mortsãlji ma s-nyeadzã shi evanghelul ma s-preadicã la oarfãnji. ");
INSERT INTO rup_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ca hara di atsel tsi nu va si zurliseascã di mini!” ");
INSERT INTO rup_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Sh-cãndu elji ma s-dipãrta, Isusul apãrnji s-lã dzãtsea ali multsãmi trã Ioanul: “Tsi vrets s-videts tu irnjii? Cãlamlu tsi lu ascuturã vimtul? ");
INSERT INTO rup_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Cãtse avets ishit s-videts? Omlu nviscut cu stranji moali? Ia, atselji tsi si nvescu cu stranji moali bãneadzã tu pãlatili a amiradzilor. ");
INSERT INTO rup_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Atumtsea, cãtse ishit afoarã s-videts? Un prufit? Ie, mini vã dzãc, elu easti ma multu di un prufit. ");
INSERT INTO rup_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Cã aestu easti atsel ti cai easti scriatã: ‘Ia mini ma vã pitrec anghilu a meu nãintea a fatsãljei a ta; el va u-fac etimu calea a ta nãintea a ta.’ ");
INSERT INTO rup_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Dealihea ma vã dzãc: Di atselji tsi suntu amintats di muljearea nu ari ishit pute vãrã ma mari di Ioan Pãtidzãtorlu. Ma, ma njiclu tu amirãriljea a tserurilor easti ma mari di elu. ");
INSERT INTO rup_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Sh-di tu dzãlili al Ioan Pãtidzãtorlu sh-pãnã tora amirãriljea a tserurilor ma s-rebilipseashti sh-rebilji u-arãchescu. ");
INSERT INTO rup_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Tuts Prufitsilji sh-Legea au prufitipsitã pãnã la Ioanul. ");
INSERT INTO rup_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Sh-macã vrets s-lu aprucheats, elu easti Ilia, tsi va yinã. ");
INSERT INTO rup_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Cai ari ureclji ti avdzãri, si-avdã ");
INSERT INTO rup_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Cu cai s-u undzescu aestã gheneratã? Undzeashti cu cilimenjilji tsi sta prit pãdzi sh-aurlã a sotsilor a lor ");
INSERT INTO rup_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","dzãcãnda: ‘Noi avem bãtut flueara ti voi ma voi nu giucat; ahurhim s-vãitãm ma voi nu plãmsit.’ ");
INSERT INTO rup_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Vini Ioanul tsi nitsi mãca, nitsi bea, sh-elji dzãc: ‘Elu ari un demon.’ ");
INSERT INTO rup_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Vini Hiljiu a omlui, tsi mãca sh-bea sh-elji dzãc: ‘Ia un mãcãtor sh-un biutor, oaspili a taxidarilor sh-a amãrtioshilor.’ Ma mintimeniljea easti aspus ndreaptã di la hiljilji a ljei.” ");
INSERT INTO rup_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Atumtsea, Isusul apãrnji s-vãrgheascã atseali cãsãbadzi, iu eara faptã ma multi di thavmatili a lui, cã atseali nu eara mitãnjusiti, dzãcãnda: ");
INSERT INTO rup_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Ca vai di tini, Corazin! Ca vai di tini, Betsaida! Cã, macã tu Tiro sh-tu Sidon va eara faptã thavmatili tsi s-featsir tu voi, di cu chiro va eara mitãnjusitã cu sac sh-cu chinushi. ");
INSERT INTO rup_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Trã-atsea mini ma vã dzãc cã tu dzua a giudicatãljei, Tiro sh-Sidon va s-giudicã cu ma multã lishuredzi dicãt voi. ");
INSERT INTO rup_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Sh-tini, Capernaum, tsi ti sculash pãnã tu tser, va ti dipunji pãnã tu Colasi. Cã macã va eara faptã tu Sodoma thavmatili atseali mãrili tsi suntu faptã la tini, atsea va eara sh-azã tu aestã dzuã. ");
INSERT INTO rup_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Trã atsea mini ma vã dzãc cã dzua a giudicatãljei a Sodomiljei va s-hibã ma lishor di a tsãia.” ");
INSERT INTO rup_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Tu atsel chiro Isusul apãrnji sh-dzãsi: “Mini ti alavdu, Tatãl, Domnul a tserlui sh-a loclui, cã li ascumsesh aesti lucri a mintimenlui sh-a nvitsatlui, sh-lji li discupirish a njitsilor. ");
INSERT INTO rup_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ie, Tatã, cã ashã ts-arãseashti a tsãia. ");
INSERT INTO rup_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Itsido nji si easti datã tu mãnã di la Tatãl a meu, sh-vãrã nu lu cunoashti Hiljiu, dicãt mash Tatãl, sh-vãrã nu lu cunoashti Tatãl, dicãt mash Hiljiu sh-atsel tsi Hiljiu va lji-lu discoapirã. ");
INSERT INTO rup_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Haidets la mini, tuts voi curmatsi sh-munduitsi, sh-mini va vã dau discurmari. ");
INSERT INTO rup_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Loats pri voi giuglu a meu shi nvitsats di la mini, cã mini escu inimã-moali sh-tapin, sh-voi va aflats arihati tu suflitli a voastri. ");
INSERT INTO rup_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Cã giuglu a meu easti moali shi sartsina a mea easti lishoarã!” ");
INSERT INTO rup_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Tu atsel chiro Isusul ma tritsea unã Sãmbãtã prit siminãturili cu grãn. Sh-ucenitsilji a lui, agiunji, apãrnjirã s-arupã schicuri shi s-li mãcã. ");
INSERT INTO rup_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ma Fariseilji, cãndu vidzurã aestã, lji dzãsirã: “Ia, ucenitsilji a tãlji ma facã atsea tsi nu easti volje s-facã sãmbãta.” ");
INSERT INTO rup_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Sh-elu lã dzãsi a lor: “Nu avets cãntatã cã tsi featsi Davidul cãndu avu foami, elu sh-atselji tsi eara cu nãsu? ");
INSERT INTO rup_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Elu intrã tu casa a Dumnidzãlui sh-mãcã pãnji sãmtsãti, tsi nu prindea s-li mãca nitsi elu sh-nitsi elji tsi eara cu nãsu, dicãt mash preftsãlji. ");
INSERT INTO rup_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Icã nu avets cãntatã tu lege cã tu templu, cathe Sãmbãtã, preftsãlji calcã sãmbãta sh-cu tutatsea nu suntu vinovats? ");
INSERT INTO rup_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Sh-mini ma vã dzãc cã aoa easti un ma mari dicãt templu. ");
INSERT INTO rup_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Sh-ma s-avets shtiutã cã tsi va s-dzãcã: ‘Mini voi njilã sh-nu curbani,’ nu va aveat condamnat nivinovatsilji. ");
INSERT INTO rup_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Cã Hiljiu a omlui easti Domnu sh-a Sãmbãtãljei.” ");
INSERT INTO rup_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Deapoea, dupã tsi s-dipãrtã di aclo, Isusul intrã tu sinagoga a lor, ");
INSERT INTO rup_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","sh-ia, aclo eara un bãrbat a cui s-eara uscatã mãna. Elji lu ntribarã Isusul, cu scupo tsi s-lu acuza ma napoi: “Easti volje tsi cariva s-vindicã dzua di sãmbãtã?” ");
INSERT INTO rup_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Sh-elu lã dzãsi a lor: “Easti vãrã di voi tsi ari unã oai, shi aeastã lji cadi tu groapã dzua di sãmbãtã, sh-elu nu va u-acatsã shi s-u-scoatã afoarã? ");
INSERT INTO rup_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ia ashã, cãt ma multu custeadzi omlu di oaia! Ia, easti volje s-fatsã ghini Sãmbãta?” ");
INSERT INTO rup_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Atumtsea elu lji dzãsi a omlui: “Tindi mãna a ta!” Elu u-timsi sh-mãna a lui s-featsi sãnãtoasã ca alanta. ");
INSERT INTO rup_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ma Fariseilji, dupã tsi ishirã afoarã, fãtsea plan contra a lui cum s-lu vãtãma. ");
INSERT INTO rup_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ma cãndu Isusul nvitsã aestã, fudzi di aclo sh-unã multsãmi mari lu urma sh-elu lji vindicã tuts. ");
INSERT INTO rup_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Sh-lã ordinã atselji si nu aspunea cai eara elu, ");
INSERT INTO rup_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","tra si mplineascã tsi eara dzãsã di la prufitlu Isaia tsi dzãtsea: ");
INSERT INTO rup_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ia, huzmichearlu a meu, tsi mini lu alepshu, vrutlu a meu, tu cai mini escu hãrsit. Mini va lu-bag Duhlu a meu pristi nãsu sh-elu va aspunã ndriptatea la lumea. ");
INSERT INTO rup_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Elu nu va si ncaci sh-nitsi va aurlã sh-vãrã nu va avdã boatsea a lui pri pãdzi. ");
INSERT INTO rup_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Elu nu va lu sãrmã cãlamlu atsel frãmtu sh-nu va u-astingã cãndila tsi fatsi fum, pãnã-cãndu elu s-nu aibã faptã s-amintã ndriptatea. ");
INSERT INTO rup_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Sh-oaminjilji va s-nãdãeascã tu numa a lui.” ");
INSERT INTO rup_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Atumtsea lji adusirã un demonizat, tsi eara orbu sh-mut. Sh-Isusul lu vindicã, ashã cã elu videa sh-zbura. ");
INSERT INTO rup_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Sh-multsãmea s-ciudisea sh-dzãtsea: “Nacã aestu easti Hiljiu al David?” ");
INSERT INTO rup_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ma Fariseilji, cãndu avdzãrã aestã, dzãsirã: “Aestu lã aĝuneashti demonjilji mash cu fuchiia a Beelzebul, printsul a demonjilor.” ");
INSERT INTO rup_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Sh-Isusul, cunuscãnda minduirili a lor, lã dzãsi: “Itsi amirã, tsi s-disparti tu nãsã, s-dutsi cãtrã aspãrdzeari, sh-itsi cãsãbã icã casã, tsi s-disparti tu nãsã, nu va si sta multu. ");
INSERT INTO rup_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Atumtsea, macã draclu aĝuneashti draclu, elu easti dispãrtsãtã tu nãsã, sh-cum poati sta amirãriljea a lui? ");
INSERT INTO rup_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Sh-macã mini aĝunescu dratsilji cu agiutarea a Beelzebul, cu agiutarea a cui lã agunescu hiljilji a voshtri? Tr-atsea elji va hibã giudicãtorlji a voshtri. ");
INSERT INTO rup_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ma, macã mini aĝunescu dratsilji cu agiutarea al Duhlu a Dumnidzãlui, atumtsea amirãriljea al Dumnidzãu ari vinitã la voi. ");
INSERT INTO rup_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Icã, cum poati vãrã s-intrã tu casa a vãrtoslu shi s-lji furã ayishtearea a lui, ma s-nu lu ari ligatã ma nãinti vãrtoslu? Mash atumtsea elu va s-poatã s-lji furã casa. ");
INSERT INTO rup_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Cai nu easti cu mini, easti contra di mini sh-cai nu adunã cu mini hãrgiueashti. ");
INSERT INTO rup_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Trã atsea mini ma vã dzãc: Itsi amãrtii sh-blãstem va lã si ljeartã a oamnjilor, ma blãstemlu contra a Duhlui nu va lã si ljeartã a lor. ");
INSERT INTO rup_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Sh-caitsido tsi greashti contra a Hiljilui a omlui va lji si ljeartã, ma atsel tsi greashti contra a Duhlui Sãmtu nu va lji si ljeartã nitsi tu aestã etã, nitsi tu atsea tsi va yinã. ");
INSERT INTO rup_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Icã fãtsets bun pomlu, sh-atumtsea frutlu a lui va s-hibã bun, icã fãtsets arãu pomlu sh-frutlu a lui va hibã arãu. Cã pomlu s-cunoashti di frutlu. ");
INSERT INTO rup_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Pulji di nãpãrtitsi! Cum putets s-grits ghini, cãndu hits arãi? Cã gura greashti di mplinirea a inimãljei. ");
INSERT INTO rup_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Omlu atsel bunlu dit ayistearea atsea buna a inimiljei a lui, scoati lucri buni, ma omlu atsel arãulu scoati lucri arali dit ayistearea a lui arauã. ");
INSERT INTO rup_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ma mini ma vã dzãc cã dzua a giudicatãljei caitsido va da lugurii trã itsi zbor di geaba tsi au dzãsã. ");
INSERT INTO rup_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Cã dupã zboarili a tali va ti ndriptãtseshti, sh-dupã zboarili a tali va ti condamnji.” ");
INSERT INTO rup_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Atumtsea niscãntsã scribi sh-Farisei lj-dzãsirã: “Nvitsãtore, noi vrem s-videm vãrã semnu di la tini.” ");
INSERT INTO rup_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ma elu apãndisinda lã dzãsi a lor: “Aestã farã anapudã sh-curunã-cãlcatã caftã un semnu, ma vãrã semnu nu va lji si da, di cãt semnul al prufitlu Iona. ");
INSERT INTO rup_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Cã, ashã cum Iona armasi trei dzãli sh-trei noptsã tu pãnticlu a peshtilui atsel marli, ashã sh-Hiljilu a omlui va s-hibã trei dzãli sh-trei noptsã tu inima a loclui. ");
INSERT INTO rup_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Bãnãtorlji di Ninive va si scoalã la giudicatã deadun cu aestã farã sh-va u-condamnã, cã elji s-mitãnjiusirã cu predicarea al Iona. Sh-ia, aoa easti un ma mari di Iona. ");
INSERT INTO rup_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Amirãroanjea di sud va si scoalã la giudicatã deadun cu aestã farã sh-va u-condamnã, cã ea vini dit mardzina ma diparti a loclui ti avdzãri mintimeniljea al Solomonul sh-ia, aoa easti un ma mari di Salomonul. ");
INSERT INTO rup_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Tora cãndu duhlu nicurat ari ishit dit un om, imnã prit locuri fãrã di apã, cãftãnda arihati, ma nu u aflã. ");
INSERT INTO rup_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Atumtsea dzãtsi: ‘Va mi tornu la casa a mea, di iu am ishitã.’ Ma cãndu agiundzi u-aflã goalã, cãtãrsitã shi stulsitã. ");
INSERT INTO rup_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Atumtsea s-dutsi sh-ljea cu nãsu shapti duhuri alti ma arali dicãt elu, tsi intrã sh-bãneadzã aclo. Ashã catandisea di ma napoi a aishtui om s-fatsi ma arãu di atsea di ma nãinti. Ashã va s-undzeascã sh-cu aestã farã anapuda.” ");
INSERT INTO rup_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Cãndu Isusul ninga lji grea ali multsãmi, ia muma a lui sh-fratsãlji a lui ma stãtea nafoarã sh-cãfta si zbura cu nãsu. ");
INSERT INTO rup_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Sh-un lji dzãsi: “Ia, muma a ta sh-fratsilji a tãlji suntu aclo nafoarã sh-vor sã zburãscã cu tini.” ");
INSERT INTO rup_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ma elu apãndisinda, lji dzãsi atsilui tsi lji grãi: “Cai easti muma a mea sh-cai suntu fratsãlji a melji?” ");
INSERT INTO rup_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Timsi mãna a lui cãtrã ucenitsilji a lui sh-dzãsi: “Ia, muma a mea sh-fratsilji a melji. ");
INSERT INTO rup_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Cã caitsido tsi fatsi vrearea a Tatãlui a meu tsi easti tu tseruri, nji easti frat, sor sh-mumã.” ");
INSERT INTO rup_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Tu atsea dzuã, Isusul ishi di la casã shi shidzu ningã amari. ");
INSERT INTO rup_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Multsãnji mãri s-adunarã anvãrliga di nãsu sh-elu s-alinã tu unã varcã shi shidzu, sh-tut populu stãtea mprostu mardzina di amari. ");
INSERT INTO rup_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Sh-elu lã aspusi multi lucri a lor tu parabolã, dzãcãnda: “Ia, un siminãtor ishi tra s-seaminã. ");
INSERT INTO rup_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Iarã ma simina, nãscãnti simintsã cãdzurã ningã cali. Puljilji vinirã sh-li mãcarã. ");
INSERT INTO rup_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Nãscãnti alti cãdzurã tu un loc chitros, iu nu avea multã tsarã, sh-fitrusirã trãoarã cã nu avea tsarã multã. ");
INSERT INTO rup_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ma cãndu ishi soarili s-pãlirã shi s-uscarã cã nu avea rãdãtsinã. ");
INSERT INTO rup_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Altili cãdzurã prit schinji, ma schinjilji criscurã sh-lji acãtsarã anasa. ");
INSERT INTO rup_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ma, atsea simintsã tsi cãdzu tu loc bunã deadi carpo, unã sutã di ori, alanta shaidzãtsi di ori sh-alanta treidzãtsi di ori. ");
INSERT INTO rup_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Cai ari ureclji trã avdzãri, si avdã!” ");
INSERT INTO rup_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Atumtsea ucenitsilji s-apruchearã la Isus sh-lji dzãsirã: “Cãtse lã zburãshti a lor cu parabolã?” ");
INSERT INTO rup_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Sh-elu apãndisinda lã dzãsi a lor: “Cã a voauã vã si easti datã s-cunushtets mistiryili a amirãriljei a tserurilor, iarã a lor nu lã si easti datã. ");
INSERT INTO rup_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Cã atsilui tsi ari, va lji si da sh-altã sh-va lji artiriseascã. Iarã a atsilui tsi nu ari, va lji si ljea sh-atsea tsi ari. ");
INSERT INTO rup_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Trã atsea mini lã zburãscu a lor cu parabolã, cã vidzãndalui nu ved, sh-avdzãndalui nu avdu sh-nitsi nu aduchescu. ");
INSERT INTO rup_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ashã tu elji si mlineashti prufitia al Isaia, tsi dzãtsi: ‘Voi dealihea va s-avdzãts, ma nu va s-aduchits, dealihea va s-mutrits, ma nu va s-videts. ");
INSERT INTO rup_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Cã inima a popului ashtui easti ni sãmtsãt, elji suntu faptã grelji di ureclji sh-au ncljisã ocljilji, tsi s-nu veadã cu oclji sh-nu avdã cu ureclji, shi nu giudicã cu inima shi nu s-toarnã, sh-mini s-lji vindicã.’ ");
INSERT INTO rup_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ma ca hara di ocljilji a voshtri cã ved sh-urecljili a voastri cã avdu. ");
INSERT INTO rup_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Cã alihea vã dzãc cã multsã prufits sh-ndreptsã vrurã s-li veadã atseali tsi voi ma videts sh-nu li vidzurã, shi s-li avdu atseali tsi voi avdzãts shi nu li avdzãrã! ");
INSERT INTO rup_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Trã atsea voi aduchits parabola a siminãtorlui. ");
INSERT INTO rup_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Cãndu vãrã avdi zborlu a amirãriljei sh-nu lu aducheashti, yini slablu sh-lji arãcheashti atsea tsi eara siminatã tu inima a lui. Atsea easti simintsa siminat ningã cali. ");
INSERT INTO rup_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Shi simintsa tu loclu chitros, easti atsel tsi avdi zborlu sh-lu aproachi trãoarã cu harauã. ");
INSERT INTO rup_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ma, nu ari arãdãtsinã pri nãsu sh-easti ti putsãn chiro. Cãndu yinu munduirea icã avinarea trã itia a zborlui, s-apãrãtseashti trãoarã. ");
INSERT INTO rup_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Shi simintsa cãdzut trã schinji easti atsel tsi u-ascultã zborlu, ma nvirinarea a lumiljei aishtei sh-arãderili a ayishterilor lji nec zborlu, sh-ea s-fatsi fãrã carpo. ");
INSERT INTO rup_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ma atsea simintsã tsi cadi tu loc bun, easti atsel cai ascultã zborlu, lu aducheashti sh-da carpo. Sh-un fatsi unãsutã di ori, altu shaidzãtsi di ori shi altu treidzãtsi di ori.” ");
INSERT INTO rup_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Elu l-pripunã a lor un parabolã altã: “Amirãriljea a tserurilor lj-undzeashti a unui om tsi siminã simintsã bunã tu agrul a lui. ");
INSERT INTO rup_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ma, iarã oaminjilji ma durnjea, vini neamiclu a lui shi siminã ordzu prit grãn sh-fudzi. ");
INSERT INTO rup_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Cãndu grãnlu criscu sh-featsi carpo s-vidzu sh-ordzul. ");
INSERT INTO rup_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Sh-huzmichearlji a nicuchirlui a casiljei s-apruchearã la nãsu sh-lji dzãsirã: ‘Doamne, nu ai siminatã simintsã bunã tu agrul a tãu? Di iu ishi ordzul?’ ");
INSERT INTO rup_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Sh-elu lã apãndisi a lor: ‘Aestã lu ari faptã neamiclu.’ Atumtsea huzmichearlji lji dzãsirã: ‘Vrei tini s-nidzem shi s-li scutem?’ ");
INSERT INTO rup_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ma elu dzãsi: ‘Nu, cã scutãnda ordzul, deadun cu nãsu va scutets sh-grãnlu. ");
INSERT INTO rup_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Alãsats s-creascã deadun pãnã la sitsirari. La chirolu a sitsirariljei va lã dzãc a sitsirãtorilor: Adunats ma nãinti ordzul, ligats-lu tu mãnuclji tra si-u ardem, sh-grãnlu bãgats-lu tu hãmbarea a mea.’” ");
INSERT INTO rup_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Elu lã pripunã a lor un parabolã altã dzãcãnda: “Amirãriljea a tserurilor lj-undzeashti a unui gãrnuts di sinapi, tsi lu ia un om sh-lu seamni tu agrul a lui. ");
INSERT INTO rup_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","El easti ma njicã di tuti simintsãli, ma dupã tsi creashti, easti ma mari dicãt tuti erghili, shi s-fatsi un pom, ahãntu cãt puljilji a tserlui yin sh-aflã streahã tu dedzãli a lui.” ");
INSERT INTO rup_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Elu lã dzãsi a lor unã parabolã altã: “Amirãriljea a tserurilor undzeashti cu mãeaua tsi u-ljea unã muljeari sh-acatsi aloatlu cu trei misuri mari di fãrinã pãnã cãndu aloatlu s-hibã etimu.” ");
INSERT INTO rup_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Isusul tuti aesti lucri lã-li dzãsi a multsãnjilor tu parabolã. Sh-nu lã zbura a lor tsiva fãrã parabolã, ");
INSERT INTO rup_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","tsi si mplinea tsi eara dzãsã di la prufitlu: “Mini va discljid gura a mea prit parabolã sh-va disvãlescu lucrili atseali ascumtili di tu adrarea a lumiljei.” ");
INSERT INTO rup_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Atumtsea Isusul, dupã tsi alãsã multsãnjili, s-turnã la casã sh-ucenitsilji a lui lji-s-apruchearã sh-lji dzãsirã: “Nã aspunã parabola a ordzului dit agru.” ");
INSERT INTO rup_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Sh-elu apãndisinda lã dzãsi a lor: “Atsel tsi seaminã simintsã bunã easti Hiljiu a omlui. ");
INSERT INTO rup_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Agrul easti lumea, simintsa atsea buna suntu hiljilji a amirãriljei sh-ordzul suntu hiljilji a arãului. ");
INSERT INTO rup_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Neamiclu tsi u-ari siminatã easti draclu, iarã sitsirarea easti bitisita a lumiljei shi sitsirãtorilji suntu anghiljilji. ");
INSERT INTO rup_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ashã cum s-adunã ordzul shi s-ardi tu foc, ashã va hibã tu bitisita a lumiljei: ");
INSERT INTO rup_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Hiljiu a omlui va pitreacã anghiljilji a lui sh-elji va s-adunã dit amirãriljea a lui tuti scandalili sh-atselji tsi facã anapudii ");
INSERT INTO rup_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","sh-va lji arucã tu cireaplu a foclui. Aclo va s-aibã plãngu sh-cãrtsãnirea a dintsãlor. ");
INSERT INTO rup_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Atumtsea ndreptsãlji va strãlutseascã ca soarili tu amirãriljea a Tatãlui a lor. Cai ari ureclji trã avdzãri, si-avdã!” ");
INSERT INTO rup_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Atumtsea, amirãriljea a tserurilor undzeashti ca unã ayishteari ascumtã tu un agru, tsi un om u-aflã sh-u ascundi. Di haraua tsi ari, s-dutsi, vindi itsi-ari sh-acumpãrã agrul atsel. ");
INSERT INTO rup_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Tutashã, amirãriljea a tserurilor undzeashti ca un prãmãteftu tsi s-dutsi caftã mãrgãritãri buni. ");
INSERT INTO rup_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Cãndu aflã un mãrgãritar cu mar tinjii, s-dutsi sh-vindi itsi ari sh-lu acumpãrã. ");
INSERT INTO rup_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Amirãriljea a tserurilor lj-undzeashti tutashã a pleasãljei arcatã tu amari, tsi adunã multi soi di peshti. ");
INSERT INTO rup_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Cãndu ea easti umplutã, piscarilji u-scoatã mardzina di amari, shed sh-adun tu coshuri atselji bunjilji, sh-lji arucã nclo atselji tsi nu suntu bunji. ");
INSERT INTO rup_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ashã va s-undzeascã tu bitisita a lumiljei. Va yinã anghiljilji sh-va li dispartã anapudzlji di ndreptsãlji ");
INSERT INTO rup_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","sh-va lji arucã tu cireaplu di foc. Aclo va-aibã plãngu sh-cãrtsãnirea a dintsãlor.” ");
INSERT INTO rup_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Isusul lã ntribã atselji: “L-aduchit tuti aesti?” Elji lji apãndisirã: “Ie.” ");
INSERT INTO rup_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Sh-elu lã dzãsi a lor: “Trã aestã cathi scrib, tsi s-fatsi un ucenic tu amirãriljea a tserurilor lj-undzeashti a unui nicuchir di casã tsi scoati nafoarã dit ayishtearea a lui lucrili atseali nali sh-atseali veclji.” ");
INSERT INTO rup_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Tora dupã tsi Isusul lji avea bitisitã aesti paraboli, fudzi di aclo. ");
INSERT INTO rup_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Dupã tsi vini tu patria a lui, lji nvitsa oamnjilji tu sinagoga a lor, sh-elji s-ciudisea shi ntriba: “Di iu lj-vinirã aishtui aestã mintimenilji sh-aestã puteari ti thavmati? ");
INSERT INTO rup_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nu easti aestu hiljiu a lemnarlui? Nu s-acljeamã muma a lui Maria, sh-fratsilji a lui Iacov, Iose, Simon sh-Iuda? ");
INSERT INTO rup_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Sh-surãrili a lui nu suntu tuti trã noi? Atumtsea di iu lji vinirã aishtui tuti aesti?” ");
INSERT INTO rup_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Shi si scandalizea cu nãsu. Ma Isusul lã dzãsi a lor: “Un prufit nu easti fãrã tinjisiri, mash dicãt tu patria a lui sh-tu casa a lui.” ");
INSERT INTO rup_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Sh-trã itia a nipistipsiriljei a lor, elu nu featsi aclo multi thavmati mãri. ");
INSERT INTO rup_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tu atsel chiro Ierodul, domnitorul a Galileiljei, avdzã ti anamea al Isus, ");
INSERT INTO rup_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","sh-lã dzãsi a huzmichearilor a lui: “Aestu easti Ioan Pãtidzãtorlu. Elu s-nye dit mortsã sh-trã atsea puterili suprãnaturali ma lucreadzã la nãsu.” ");
INSERT INTO rup_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ierodul, lu avea acãtsat Ioanul, lji avea bãgatã prãnghili sh-lu avea hãpsinit, trã itia a Irodiadãljei, muljearea al Filipu, fratili a lui. ");
INSERT INTO rup_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Cã Ioanul lji dzãtsea: “Nu easti volje s-bãneadz cu nãsã!” ");
INSERT INTO rup_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Sh-cu tutã cã vrea s-lu vãtãma, Herodul avea fricã di populu tsi lu lugursea Ioanul prufit. ");
INSERT INTO rup_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Cãndu ma si sãrbãtorea dzua a amintariljei a Ierodului, hiljea a Ierodiadãljei giucã nãintea a oaspitslor shi lj-arisi a Ierodului ahãntu multu, ");
INSERT INTO rup_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","cãt elu lji tãxi a ljei cu spigiurari cã va lji dãdea itsi va lji cãfta. ");
INSERT INTO rup_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Shi ea, pimtã sh-di muma a ljei dzãsi: “Dã-nji aoa, tu unã tãpsii, caplu al Ioan Pãtidzãtorlu.” ");
INSERT INTO rup_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Amirãlu si-nvirinã, ma trã itia a spigiurariljei nãintea a acljimatsilor tsi eara cu nãsu la measã, ordinã s-lji lu aduc. ");
INSERT INTO rup_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ashã elu pitricu un tu hapsi s-lji talji caplu al Ioan Pãtidzãtorlu. ");
INSERT INTO rup_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Sh-caplu a lui lu adusirã tu un tãpsii sh-lji-lu deadirã ali feati, shi ea lji-lu deadi ali mumi. ");
INSERT INTO rup_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Deapoea vinirã ucenitsilji al Ioan, loarã truplu a lui sh-lu ngruparã. Atumtsea, elji s-dusirã shi lj-spusirã al Isus. ");
INSERT INTO rup_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Cãndu Isusul li avdzã aesti, s-nchisi di-aclo cu unã varcã shi s-dusi singur tu un loc ermu, sh-multsãmea cãndu avdzã s-dusi dupã nãsu pri cicioari dit cãsãbadz. ");
INSERT INTO rup_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Sh-Isusul, cãndu ishi dit varcã, vidzu unã multsãmi mari, avu njilã trã elji sh-vindicã atselji tsi eara lãndzitsi. ");
INSERT INTO rup_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Deapoea cãtrã seara ucenitsilji a lui s-apruchearã di nãsu sh-lji dzãsirã: “Aestu loc easti ermu sh-oara tricu. Alasã multsãmea s-ducã prit hoari tsi s-acumpãrã trã mãcari.” ");
INSERT INTO rup_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Isusul lã dzãsi a lor: “Nu easti ananghi si s-ducã. Dats-lã voi s-mãcã!” ");
INSERT INTO rup_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Sh-elji lji dzãsirã: “Noi aoa nu avem altã tsiva dicãt tsintsi pãnji sh-doi peshti.” ");
INSERT INTO rup_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Sh-elu lã dzãsi: “Adutsets-li aoa la mini.” ");
INSERT INTO rup_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Atumtsea lã ordinã multsãnjili tsi s-sheadã mpadi pri iarbã. Deapoea lo tsintsi pãnjili sh-doi peshtili sh-dupã tsi sculã ocljilji cãtrã tser, ghinicuvãntã, li pãrtsã pãnjili sh-li deadi a ucenitsilor, sh-ucenitsilji a multsãnjilor. ");
INSERT INTO rup_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Sh-tuts mãcarã shi s-fãnãtirã. Deapoea ucenitsilji adunarã bãcãtsili tsi armasirã sh-umplurã doisprãdzatsi di coshuri mplini. ");
INSERT INTO rup_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Sh-atselji tsi mãcarã eara anvãrliga di tsintsi njilji di bãrbãts, ni misurat muljerili sh-cilimenjilji. ");
INSERT INTO rup_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Trãoarã dupã aestã Isusul lã ordinã ucenitsilji a lui s-intrã tu varcã shi s-arucã di napãrti, pãnã-cãndu elu lji alasã multsãnjili. ");
INSERT INTO rup_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Dupã tsi alãsã multsãmea s-fugã, s-alinã singur pri munti si s-roagã. Sh-cãndu tunicã elu eara aclo singur dip. ");
INSERT INTO rup_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Tu aestã oarã varca eara tu mesea di amari, shi s-plãscãnea di vãljurili cã vimtul eara contra. ");
INSERT INTO rup_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Cãtrã apiritã, Isusul s-dusi aproapi di nãshi, imnãnda pri amari. ");
INSERT INTO rup_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ucenitsilji vidzãnda elu imnãnda pri amari, ahurhirã s-aurlã di fricã sh-dzãsirã: “Easti vãrã fantamã!” ");
INSERT INTO rup_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ma trãoarã Isusul lã grãi a lor: “Arihãtipsits-vã! Mini escu, s-nu avets fricã!” ");
INSERT INTO rup_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Sh-Petrul, apãndisinda dzãsi: “Doamne, macã eshti tini, mi ursea s-yin la tini pri apã!” ");
INSERT INTO rup_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Elu lj-dzãsi: “Haidi!” Sh-Petrul dipunã dit varcã sh-imnã pri apã, s-nidzea la Isusul. ");
INSERT INTO rup_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ma, vidzãnda cã vimtul eara vãrtos, avea fricã, sh-ahurhinda s-afundã, aurlã: “Doamne, ascapã-mi!” ");
INSERT INTO rup_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Sh-Isusul lj-timsi trãoarã mãna, lu acãtsã shi lj-dzãsi: “Om putsãn-pistimen, cãtse fushi nisigur?” ");
INSERT INTO rup_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Apoea, cãndu intrarã tu varcã, vimtul pãpsi. ");
INSERT INTO rup_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Atumtsea elji tsi eara tu varcã si ncljinarã la nãsu, dzãcãnda: “Dealihea tini eshti Hiljiu a Dumnidzãlui!” ");
INSERT INTO rup_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Apoea, dupã tsi agiumsirã tu alantã partã, vinirã tu loclu a Ghenezaretlui. ");
INSERT INTO rup_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Sh-oamnjilji atsilui loc, macãt lu cunuscurã, lu arãspãndirã zborlu tu tutã loclu di anvãrliga. Sh-adusirã la elu tutsã nipututsilji. ");
INSERT INTO rup_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Shi-l pãrãcãlsirã tsi s-putea s-bãga mãna tu mardzina a stranjului a lui, shi tuts atselji tsi bãgarã mãna la stranji s-vindicarã. ");
INSERT INTO rup_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Atumtsea scriblji sh-Fariseilji vinirã di Ierusalim la Isusul sh-lu ntribarã: ");
INSERT INTO rup_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Cãtse ucenitsilji a tãlji ncalcã adetea a aushlor? Cã nu aspealã mãnjili nãinti tsi s-mãcã.” ");
INSERT INTO rup_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Iarã elu lã apãndãsi a lor: “Sh-voi trã tse ncãlcats ordinlu a Dumnidzãlui trã adetea a voastrã? ");
INSERT INTO rup_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Dumnidzãlu ari ordinatã ashã: ‘Tinjisea tatãl sh-muma,’ shi: ‘Atsel tsi va blãsteam tatãl sh-muma s-condamnã cu moarti.’ ");
INSERT INTO rup_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Iarã voi dzãtsets: Caitsido tsi lj-dzãtsi a tatãlui sh-a mumãljei: ‘Itsido tsi aveam trã tini, lji easti datã a Dumnidzãlui,’ ");
INSERT INTO rup_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","elu nu easti ma strimtu s-tinjiseascã tatãl sh-muma a lui. Ashã voi avets dispretsuit zborlu a Dumnidzãlui trã adetea a voastrã. ");
INSERT INTO rup_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ipucrits, ghini prufitipsi Isaia trã voi cãndu dzãsi: ");
INSERT INTO rup_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Populu aestu ma nji s-aproachi cu gura sh-mi tinjiseashti cu budzili, ma inima a lor easti diparti di mini. ");
INSERT INTO rup_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Sh-di geaba mi tinjiseascã, nvitsãnda nvitsãturili tsi suntu regulili a oamnjilor.’” ");
INSERT INTO rup_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Deapoea acljimã multsãmea aproapi di nãsu sh-dzãsi: “Ascultats sh-aduchits! ");
INSERT INTO rup_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Omlu nu s-lãvusheashti di atsea tsi lj-intrã n-gurã, ma di atsea tsi lj-easi dit gurã s-lãvusheashti.” ");
INSERT INTO rup_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Atumtsea ucenitsilji a lui s-apruchearã shi lj-dzãsirã: “Lu shtii cã Fariseilji, cãndu li avdzãrã aesti zboari sã scandalizarã?” ");
INSERT INTO rup_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ma elu apãndisinda lã dzãsi: “Itsi simintsã tsi Tatãl a meu tserescu nu ari siminatã, va si scoatã cu arãdãtsinã. ");
INSERT INTO rup_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Alãsats-lji atselji! Elji suntu orghi, cãlãuzlji a orghilor. Macã un orbu lj-cãlãudzãshti a un altu orbu, doilji va s-cadã tu groapã.” ");
INSERT INTO rup_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Atumtsea Petrul lj-dzãsi: “Nã aspunã sh-a noauã aestã parabolã.” ");
INSERT INTO rup_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Sh-Isusul dzãsi: “Sh-voi nu avets achicãsit ninga? ");
INSERT INTO rup_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nu aduchits cã itsi intrã tu gurã treatsi tu pãnticã sh-dutsi tu duvaleti? ");
INSERT INTO rup_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ma atseali tsi easã dit gurã, easã dit inimã, sh-atseali lãvusheascã omlu. ");
INSERT INTO rup_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Cã dit inimã easã minduirili atseali arali, vãtãmãrili, ncãlcarea a curuniljei, putãnsira, furãrili, mãrtiriili arãdioasi, blãstimãrili. ");
INSERT INTO rup_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Aesti suntu atseali tsi lãvushescu omlu. Iarã s-mãtsã cu mãnjili niaspilati nu s-lãvushãshti omlu.” ");
INSERT INTO rup_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Deapoea Isusul, dupã tsi s-dipãrtã di aclo, s-nchisi cãtrã pãrtsãli a Tirlui sh-a Sidonlui. ");
INSERT INTO rup_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Sh-ia, unã muljeari Cananeancã tsi avea vinit dit atseali pãrtsi, ahurhii s-aurlã dzãcãnda: “Njiluia-mi mini, Doamne, Hiljiu al David! Feata a mea easti multã arãu, easti demonizat!” ");
INSERT INTO rup_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ma elu nu lj-apãndisi dip. Sh-ucenitsilji a lui lji s-apruchearã sh-lji si pãrãcãlsirã dzãcãnda: “Sãlãghea-u atsea, cã ma aurlã dupã noi.” ");
INSERT INTO rup_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ma elu lã apãndisi: “Mini escu pitricut, mash di oili atseali chiruti a casiljei al Israel.” ");
INSERT INTO rup_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ma ea vini shi si ncljinã, dzãcãnda: “Doamne, agiutã-mi!” ");
INSERT INTO rup_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Isusul apãndisi: “Nu easti ghini s-ljeai pãnea a cilimenjilor shi s-lu arutsã la cãtsãlji a cãnjilor.” ");
INSERT INTO rup_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ma ea dzãsi: “Easti alihea, Doamne, cã sh-cãtsãljilji a cãnjilor mãcã sãrãmili tsi cadã di la measa a nicuchirilor a lor.” ");
INSERT INTO rup_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Atumtsea Isusul lj-apãndisi dzãcãnda: “Muljeari, mari easti pistea a ta! Si s-facã ashã cum vrei.” Sh-tu atsea oarã hiljea a ljei s-vindicã. ");
INSERT INTO rup_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Deapoea, dupã tsi s-nchisi di aclo, Isusul vini ningã amarea a Galileiljei, s-alinã pri munti shi shidzu aclo. ");
INSERT INTO rup_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Shi lji s-apruchearã multsãnji mãri tsi adutsea cu nãshi shcljiochi, orghi, sãcats, muts, sh-multsã altsã, lji bãgarã la cicioarli al Isus sh-elu lji vindicã. ");
INSERT INTO rup_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Multsãnjili s-ciudisea cãndu videa cã mutsãlji grea, sãcatsãlji s-vindica, shcljiochili imna sh-orghilji videa. Sh-mãrea Dumnidzãlu al Israel. ");
INSERT INTO rup_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Sh-Isusul lj-acljimã ucenitsilji a lui ningã nãsu sh-lã dzãsi: “Mini am njilã di multsãmea, cã s-featsirã trei dzãli tsi sta cu mini shi nu ari tsiva ti mãcari. Nu voi s-lji nchisescu aĝiunji, s-nu lishineadzã n-cali.” ");
INSERT INTO rup_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Sh-ucenitsilji a lui lji dzãsirã: “Ma iu va s-aflã tu aestã loc ermu ahãnti pãnji tra s-fãnãteascã unã multsãmi ahãntu mari?” ");
INSERT INTO rup_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Sh-Isusul lã dzãsi a lor: “Cãti pãnji avets?” Elji dzãsirã: “Shapti shi ndoi peshti njitsi.” ");
INSERT INTO rup_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Atumtsea elu ordinã multsãnjili s-sheadã mpadi. ");
INSERT INTO rup_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Deapoea lo atseali shapti pãnji sh-peshtilji, shi hãristisi Dumnidzãlu, li pãrtsã, sh-li deadi a ucenitsilor a lui sh-elji a multsãmiljei. ");
INSERT INTO rup_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Sh-tuts mãcarã shi s-fãnãtirã, sh-cu bucãtsili tsi armasirã umplurã shapti coshuri mplini. ");
INSERT INTO rup_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Sh-atselji tsi mãcarã eara patru njilji di bãrbats, ni misurat muljerili sh-cilimenjilji. ");
INSERT INTO rup_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Deapoea, dupã tsi deadi cali a multsãmiljei, s-alinã tu varcã shi s-dusi cãtrã loclu Magdala. ");
INSERT INTO rup_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Deapoea lji s-apruchearã Fariseilji sh-Saduceilji tsi s-lu cãrteascã Isus shi lj-cãftarã s-lã aspunã un semnu dit tser. ");
INSERT INTO rup_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Iarã elu lã apãndisi a lor: “La searã voi dzãtsets: ‘Va hibã chirolu bun, cã tserlu easti roshu.’ ");
INSERT INTO rup_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Sh-dimineatsa dzãtsets: ‘Azã va hibã furtunã, cã tserlu easti roshu sh-nurat.’ Voi shtits s-aduchits fatsa a tserlui, ma nu putets s-aduchits seamnili a chirolui. ");
INSERT INTO rup_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Unã gheneratã anapudã sh-cãrunã-cãlcatã cafti un semnu, ma nu va lji si da vãrã semnu dicãt mash semnul a prufitului Iona.” Sh-elu li alãsã sh-fudzi. ");
INSERT INTO rup_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Cãndu ucenitsilji a lui agiumsirã tu alantã parti a amariljei, vidzurã cã avea agãrshitã s-ljea pãni. ");
INSERT INTO rup_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Iarã Isusul lã dzãsi a lor: “Bãgats mintea sh-afirits-vã di maeaua a Fariseilor sh-a Saduceilor!” ");
INSERT INTO rup_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Sh-elji s-minduirã un cu alantu dzãcãnda: “Nu avem loatã pãni.” ");
INSERT INTO rup_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ma Isusul lji achicãsi sh-lã dzãsi a lor: “Oaminji pisti-putsãn, trã tse zburats un cu alantu cã nu avets loat pãni? ");
INSERT INTO rup_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Nu avets achicãsit ninga sh-nu adutsets aminti tsintsi pãnji ti tsintsi njilji di bãrbats sh-cãti coshuri avets umplutã? ");
INSERT INTO rup_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Sh-nitsi atseali shapti pãnji ti patru njilji di bãrbats sh-cãti coshuri avets umplut? ");
INSERT INTO rup_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Cum nu aduchits cã nu lu aveam zborlu ti pãnea cãndu vã dzãshã s-vã afirits di maeaua a Fariseilor sh-a Saduceilor?” ");
INSERT INTO rup_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Atumtsea elji aduchirã cã elu nu lã avea dzãsã s-afireascã di maeaua a pãniljei, ma di nvitsãtura a Fariseilor sh-a Saduceilor. ");
INSERT INTO rup_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Cãndu Isusul, agiumsi tu loclu a Cezariljei al Filip lã ntribã ucenitsilji a lui: “Cai dzãc oaminjilji cã easti Hiljiu a omlui?” ");
INSERT INTO rup_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Sh-elji dzãsirã: “Niscãntsã dzãc cã easti Ioan Pãtidzãtorlu, altsã Ilia, altsã Ieremia, icã un di prufitsilji.” ");
INSERT INTO rup_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Elu lji ntribã elji: “Ma voi, cai dzãtsets cã escu mini?” ");
INSERT INTO rup_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Sh-Simon Petrul apãndisi: “Tini eshti Hristolu, Hiljiu a Dumnidzãlui atsilui yiului.” ");
INSERT INTO rup_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ma Isusul lj-apãndisi a lui: “Hãrãcop eshti tini, Simon, hiljiu al Iona, cã aestã nu ts-lu dizvãli nitsi truplu nitsi sãndzili, ma Tatãl a meu tsi easti tu tseruri. ");
INSERT INTO rup_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Sh-mini ma tsã dzãc tutashã cã tini eshti Petrul, tsi va s-dzãc cheatra pri cai mini va s-adarã bisearica a mea sh-portsãli a colasiljei nu va u-azvingu. ");
INSERT INTO rup_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Sh-mini va tsã dau cljeili a amirãriljei a tserurilor. Sh-itsi ai ligat pri loc, va hibã ligat pri tseruri, sh-itsi ai dizligat pri loc, va hibã dizligat tu tseruri.” ");
INSERT INTO rup_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Atumtsea lã ursi ucenitsilji a lui tsi s-nu dzãtsea a vãrui cã elu eara Hristos. ");
INSERT INTO rup_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Di atsea oarã Isusul ahurhi s-lã aspunã a ucenitsilor a lui cã prindi s-dutsea la Ierusalim, s-munduea multã ti itia a aushilor, a mãrilor a preftsilor sh-a scribilor, cã lipseashti si s-vãtãma sh-va s-nyea a treia dzuã. ");
INSERT INTO rup_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Atumtsea Petrul lo di unã parti sh-ahurhi s-lu vãrgheascã dzãcãnda: “Doamne, s-ti afireascã Dumnidzãlu! Aestã nu va s-undzeascã pute!” ");
INSERT INTO rup_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ma elu s-turnã shi lj-dzãsi a Petrului: “Dipãrteadzã-ti di la mini, Drac! Tini eshti cicãrdisiri ti mini, cã nu ai tu minti lucrili a Dumnidzãlui, ma lucrili a oamnjilor.” ");
INSERT INTO rup_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Atumtsea Isusul lã dzãsi a ucenitsilor a lui: “Macã vãrã va yinã dupã mini, si s-aleapidã, s-u ljea crutsea a lui shi s-mi urmeadzã. ");
INSERT INTO rup_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Cã atsel tsi va ascapã bana a lui, va u-chearã, ma atsel tsi va u-chearã bana a lui trã mini, va u-aflã atsea. ");
INSERT INTO rup_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Tsi amintatic ari omlu macã amintã lumea tutã sh-deapoea u-cheari suflitlu a lui? Icã tsi poati s-da omlu trã alãxirea a suflitlui a lui? ");
INSERT INTO rup_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Cã Hiljiu a omlui va yinã tu mãrirea a Tatãlui a lui deadun cu anghiljilji a lui, sh-atumtsea elu va lji arãsplãteascã a-cathiunu dupã faptili a lui. ");
INSERT INTO rup_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Dealihea vã dzãc cã niscãntsã di atselji tsi ma sta aoa nu va moarã ni vidzutã ma nãinti Hiljiu a omlui yininda tu amirãriljea a lui.” ");
INSERT INTO rup_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Dupã shasi dzãli Isusul lo cu nãsu Petrul, Iacovul, sh-Ioanul fratili a lui, sh-lji alinã pri un munti analtu dinãparti. ");
INSERT INTO rup_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Shi s-alãxi nãintea a lor. Lji si strãlutsi fatsa ca soarili shi stranjili a lui s-featsirã albã ca lunjina. ");
INSERT INTO rup_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Sh-ia, lã si fãnirusirã a lor Moisul sh-Ilia tsi zbura cu nãsu. ");
INSERT INTO rup_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Atumtsea Petrul lji dzãsi al Isus: “Doamne, easti ghini tsi noi him aoa. Ma s-vrei, mini va fac aoa trei tendi, unã trã tini, unã trã Moisul sh-unã trã Ilia.” ");
INSERT INTO rup_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Cãndu elu zbura ninga, ia un nior lunjinos lã amvãli sh-dit nior s-avdzã unã boatsi tsi dzãtsea: “Aestu easti Hiljiu a meu vrut, di la cai escu hãrisit, ascultats-lu!” ");
INSERT INTO rup_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ucenitsilji cãndu u-avdzãrã aestã, cãdzurã pri dintsã mpadi shi s-aspãrarã multu. ");
INSERT INTO rup_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Sh-Isusul s-apruche, bãgã mãna pri nãshi sh-lã dzãsi: “Sculats-vã sh-nu vã aspãrats!” ");
INSERT INTO rup_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Sh-elji sculãnda ocljilji, nu vidzurã om, mash Isusul singur. ");
INSERT INTO rup_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Deapoea cãndu ma dipuna dit munti, Isusul lã ursi dzãcãnda: “S-nu lji grits a vãrui trã atsea viziunã pãnã cãndu Hiljilu a omlui s-nyeadzã dit mortsã.” ");
INSERT INTO rup_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Atumtsea ucenitsilji a lui lu ntribarã: “Cãtse scriblji dzãc cã prindi s-yinã ma nãinti Ilia?” ");
INSERT INTO rup_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Sh-Isusul lã apãndisi: “Dealihea cã Ilia va s-yinã ma nãinti sh-va adarã napoi itsido. ");
INSERT INTO rup_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ma mini vã dzãc, cã Ilia ari vinitã sh-elji nu lu cunuscurã, ma featsirã cu nãsu cum vrurã. Ashã cã Hiljiu a omlui va s-mundueascã di la nãshi.” ");
INSERT INTO rup_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Atumtsea ucenitsilji lu aduchirã cã lã avea sburãtã di Ioan Pãtidzãtorlu. ");
INSERT INTO rup_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Cãndu elji vinirã aproapi di multsãmea, un bãrbat s-apruche sh-dzinucljãnda nãintea a lui, ");
INSERT INTO rup_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","dzãsi: “Doamne, s-ai njilã di hiljiu a meu cã easti epileptic, tradzi multu sh-di multi ori cadi tu foc icã tu apã. ");
INSERT INTO rup_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Tora mini lu-dush la ucenitsilji a tãlji, ma elji nu puturã s-lu vindicã.” ");
INSERT INTO rup_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Sh-Isusul apãndisinda, dzãsi: “O farã fãrã pisti sh-anapudzã! Pãnã cãndu va armãnã cu voi? Pãnã cãndu va vã aravdã?” Adutsets-lu aoa la mini! ");
INSERT INTO rup_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Sh-Isusul lu vãrghi demonul sh-elu ishi di ficiorlu, sh-di atsea oarã ficiorlu s-vindicã. ");
INSERT INTO rup_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Atumtsea ucenitsilji lji s-apruchearã al Isus dinãparti, sh-lu ntribarã: “Cãtse noi nu putum s-lu aĝunim?” ");
INSERT INTO rup_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Sh-Isusul lã dzãsi a lor: “Di pistipsirea njicã a voastrã. Cã dealihea mini ma vã dzãc: ma s-avets pisti cãt un gãrnutsã di sinapi va lji dzãtsets a muntilui aishtui: ‘Mutã-ti di aoa aclo,’ sh-elu va si s-mutã. Sh-tsiva nu va hibã niputut di voi. ");
INSERT INTO rup_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Sh-aestu soi di demon nu easi di cãt mash cu pãrãcãlsiri sh-cu pãreasinj.” ");
INSERT INTO rup_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Cãndu elji s-afla tu Galilea, Isusul lã dzãsi: “Hiljilu a omlui va s-prida tu mãnjilji a oamnjilor, ");
INSERT INTO rup_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","sh-va s-lu vatãmã, sh-tu dzua a treia va s-nyeadzã.” Sh-elji s-nvirinarã multu. ");
INSERT INTO rup_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Cãndu agiumsirã tu Capernaum, taxidarlji a doauã dhrahmiilor a tempului lji s-apruchearã a Petrului, shi lji dzãsirã: “Nvitsãtorlu a vostru nu u plãteashti taxa a tempului?” ");
INSERT INTO rup_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Sh-elu dzãsi: “Ie!” Sh-cãndu intrã n-casã, Isusul lu ashtiptã prota s-lji dzãtsea: “Cum mindueshti tini Simon? Di la cai ljea taxili icã hãracili amirãrilji a loclui? Di la hiljilji a lor icã di la xenjilji?” ");
INSERT INTO rup_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petrul lji dzãsi: “Di la xenjilji.” Isusul dzãsi: “Hiljilji atumtsea nu prindi s-plãtescu. ");
INSERT INTO rup_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Cu tut atsea tsi s-nu lji cicãrdisim atselji, du-ti la amari, arucã greplu sh-ljea protlu pescu tsi va yinã nsus, ljea-lu, discljid-lji gura, sh-va s-aflji un statiru. Ljea-lu sh-plãtea taxa a lor ti tini sh-ti mini.” ");
INSERT INTO rup_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Tu atsea oarã ucenitsilji s-apruchearã a Isusului sh-lu ntribarã: “Cai easti cama marli tu amirãriljea a tserurilor?” ");
INSERT INTO rup_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Sh-Isusul dupã tsi acljimã un cilimean njic ningã nãsu, lu bãgã namisa di nãshi, ");
INSERT INTO rup_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","sh-dzãsi: “Dealihea ma vã dzãc, macã nu vã alãxits sh-nu vã fãtsets ca cilimenjili atselji njitsilji, voi nu va s-intrats pute tu amirãriljea a tserurilor. ");
INSERT INTO rup_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Cai va si s-apleacã ca aestu cilimean njic, easti cama marli tu amirãriljea a tserlui. ");
INSERT INTO rup_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Sh-caitsido tsi lu aproachi un cilimean njic ca aestu tu numa a mea, mi aproachi mini. ");
INSERT INTO rup_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ma atsel tsi va s-fac s-cadã tu amãrtii un di aeshti njitsilji, tsi pistipsescu la mini, va hibã ma ghini trã nãsu s-lji spindzirã di gushi unã cheatrã di la moarã, shi si s-neacã tu apa a amariljei. ");
INSERT INTO rup_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Cavai di dunjeaua tsi fatsi oamnjilji s-cadã tu amãrtii. Cã cicãrdisirili va s-yinã, ma cavai di atsel om, tsi trã sibepea a lui va yinã atseali cicãrdisiri! ");
INSERT INTO rup_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Tora macã mãna a ta, icã ciciorlu a tãu ti cicãrdiseashti trã amãrtii, talji-l sh-arucã-l diparti di tini. Easti ma ghini s-intsri tu banã fãrã unã mãnã icã scljiopu, di cãt s-ai doauã mãnji sh-doauã cicioari shi s-ti arucã tu foclu di totãna. ");
INSERT INTO rup_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Tutashã, macã ocljiu a tãu si cicãrdiseashti trã amãrtii, scoati-l sh-arucã-l diparti di tini. Cã easti ma ghini s-intsri cu un ocljiu tu banã, di cãt s-ai doi oclji shi s-ti arucã tu foclu a Geehenãljei. ");
INSERT INTO rup_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Afirits-vã s-nu dispretsuits vãrã di aeshti njitsilji, cã mini ma vã dzãc cã anghilji a lor tu tseruri mutrescu totãna fatsa a Tatãlui a meu tsi easti tu tseruri. ");
INSERT INTO rup_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Cã Hiljiu a omlui vini ti ascãpari atsea tsi eara chirutã. ");
INSERT INTO rup_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Cum minduits? Macã un om ari unã sutã di oi, sh-unã di nãsi cheari cala, nu va s-li alasã di noaudzãtsi nouãli pri munti, shi s-caftã atsea tsi chiru cala? ");
INSERT INTO rup_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Sh-cãndu va u aflã, dealihea vã dzãc cã elu va s-hãrseascã ma multu ti aestã dicãt di noaudzãtsi noauli, tsi nu avea chirutã cala. ");
INSERT INTO rup_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ashã easti vrearea a Tatãlui a vostru tsi easti tu tseruri, tsi vãrã di aeshti njitsilji s-nu chearã. ");
INSERT INTO rup_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Macã fratili a tãu amãrtirseashti contra tini, duti sh-vãrghea-lu cãndu hits singur voi doilji, macã ti ascultã, tini lu amintash fratili a tãu, ");
INSERT INTO rup_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","macã nu ti ascultã, ljea cu tini ninga un icã doi oaminji, tsi cathi zbor si siguripseascã pri gura a doi icã a trei martiri. ");
INSERT INTO rup_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Macã deapoea arniseashti s-ti ascultã, dzã-lji a-bisearicãljei, sh-macã arniseashti s-ascultã sh-bisearica, prilucratsts-lu ca pãngãn icã taxidar. ");
INSERT INTO rup_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Dealihea vã dzãc cã tuti lucrili tsi va avets ligat pristi locu, va s-hibã ligati sh-tu tser, sh-tsi avets dizligat pri locu, va s-hibã dizligati sh-tu tser. ");
INSERT INTO rup_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ma vã dzãc tutashã, cã macã doi di voi s-uidisescu pri loc trã itsido tsi caftã, aestã va si s-facã a lor di la Tatãl a meu tsi easti tu tseruri. ");
INSERT INTO rup_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Cã, iutsido tsi doi icã trei suntu adunatsi tu numa a mea, mini escu aclo namisa di elji.” ");
INSERT INTO rup_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Atumtsea Petrul s-apruche la Isusul sh-lji dzãsi: “Doamne, macã fratili a meu amãrtiseashti cãtrã mini, cãti ori prindi s-lu ljeartã? Pãnã di shapti ori?” ");
INSERT INTO rup_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Isusul lji-dzãsi: “Mini nu tsã dzãc pãnã di shapti ori, ma pãnã shaptidzãtsi di ori cãti shapti. ");
INSERT INTO rup_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Trã atsea, amirãriljea a tserurilor undzeashti ca un amirã tsi vrea s-fãtsea lugurili cu husmichearilji a lui. ");
INSERT INTO rup_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Dupã tsi apãrnji s-fãtsea luguri, lj-adusirã un tsi lj-mprumuta dzatsi njiljã di talentsã. ");
INSERT INTO rup_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Sh-metsi aestu nu avea tsi s-plãtea, nicuchirlu a lui ursi si s-vindea elu cu muljeara a lui, cilimenjilji a lui, sh-tuti tsi avea, shi s-plãtea mprumutlu. ");
INSERT INTO rup_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Atumtsea huzmichearlu lj-cadzu pri dzinuclji sh-lji pãrãcãlsea, dzãcãnda: ‘Doamne, s-ai arãvdari cu mini sh-mini va s-li plãtescu tuti!’ ");
INSERT INTO rup_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nicuchirlu lu njilui huzmichearlu a lui, lji lu ljirtã mprumutlu shi lu-alãsã. ");
INSERT INTO rup_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ma huzmichearlu atsel cum ishi, aflã un altã huzmichear tsi lji-avea ti dari unã sutã di denari. Dupã tsi lu acãtsã di grumadzã ma lu sgruma, dzãcãnda-lji: ‘Plãtea-nji mprumutlu tsi nj-ai.’ ");
INSERT INTO rup_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Atumtsea huzmichearlu sotslu a lui, cãdzu pri dzinuclji shi lji pãrãcãlsi, dzãcãnda-lji: ‘Ai arãvdari cu mini, sh-va li plãtescu tuti.’ ");
INSERT INTO rup_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ma elu nu vru, meti lu bãgã tu hapsi, pãnã cãndu elu s-plãtea mprumutlu. ");
INSERT INTO rup_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ma alantsã husmicheari, cãndu lu vidzurã tsi s-featsi, s-nvirinarã shi s-dusirã lji dzãsirã a nicuchirlui a lor tutã tsi s-area faptã. ");
INSERT INTO rup_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Atumtsea nicuchirlu a lui lu acljimã shi lj-dzãsi: ‘Husmichear arãu, mini ts-ljirtai tutã aestu mprumut, cã tini mi-pãrãcãlsishi. ");
INSERT INTO rup_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nu lipsea sh-tini s-aveai njilã trã sotslu a tãu, ashã cum avui mini njilã trã tini?’ ");
INSERT INTO rup_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Sh-nicuchirlu a lui, nãritã, lu prideadi atsel tu mãna a tirãnsitorilor, pãnã cãndu s-plãtea tut mprumutlu. ");
INSERT INTO rup_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ashã va s-facã cu voi sh-Tatãl a meu tserescu, macã cathi un di voi nu lu ljearti cu tutã inimã fratili a lui.” ");
INSERT INTO rup_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Dupã tsi Isusul li ascãpã ti aspuneari aesti nvitsãturi, s-nchisi di Galilea, sh-vini tu loclu a Iudeiljei, napãrti di Iordan. ");
INSERT INTO rup_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Multsãnji mãri l-urma sh-elu lji vindicã aclo. ");
INSERT INTO rup_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Atumtsea lji s-apruchearã niscãntsã Farisei s-lu cãrtea, sh-lji dzãsirã: “Easti tu lege tsi bãrbatlu s-u dispartã muljearea di itsido sibepi?” ");
INSERT INTO rup_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Sh-elu apãndisinda lã dzãsi a lor: “Nu avets cãntatã cã atsel tsi lji adrã di tu ahurhitã ‘lji adrã mascru sh-theaminã.’ ");
INSERT INTO rup_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Sh-Dumnidzãlu dzãsi: ‘Trã aestã bãrbatul va s-alasã tatãl sh-muma a lui sh-va si s-mpriuneadzã cu muljearea a lui, sh-amindoilji va hibã un trup singur’? ");
INSERT INTO rup_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Sh-ashã elji nu suntu ma doi, ma un trup. Atsea tsi Dumnidzãlu ari mpriunatã, omlu s-nu lu dispartã.” ");
INSERT INTO rup_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Elji lji dsãsirã: “Atumtsea cãtse Moisiul ursi s-lji si da cartea di dispãrtsãri shi si-u alasã.” ");
INSERT INTO rup_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Elu lã dzãsi a-lor: “Moisiul vã deadi volje s-li dispãrtsãts muljerili a voastri trã itia a chitrisiriljei a ininjilor a voastri. Ma tu ahurhitã nu eara ashã. ");
INSERT INTO rup_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ma mini vã dzãc cã caitsido tsi u-alasã muljerea a lui, mash trã sibepea a putãnsiriljei, shi si nsoari cu unã altã, ncalcã curuna. Sh-atsel tsi si nsoari cu muljeari alãsatã, ncalcã curuna.” ");
INSERT INTO rup_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ucenitsilji a lui lji dzãsirã: “Macã cunditsili a bãrbatlui cãtrã muljearea suntu ahtãri, ma ghini si nu si nsoarã dip.” ");
INSERT INTO rup_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ma elu lã dzãsi a lor: “Nu tuts lã aduchescu aesti zboari, ma singur atselji a cui lã easti datã. ");
INSERT INTO rup_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Suntu eunuchi, tsi suntu amintats ashã di pãnticlu a mumãljei, shi suntu eunuchi tsi suntu faptã di la oaminji, shi suntu eunuchi tsi au apofãsitã singur si s-faca eunuchi trã amirãriljea a tserurilor. Atsel tsi poati s-aducheascã, s-aducheascã.” ");
INSERT INTO rup_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Atumtsea adusirã cilimenji njitsi la Isusul trai s-bãga mãnjili pri nãshi, shi s-pãrãcãlsea, ma ucenitsilji a lui lji vãrghirã atselji. ");
INSERT INTO rup_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ma Isusul dzãsi: “Alãsats cilimenjilji atselji nitsilji s-yinã la mini sh-nu li nchidicats, cã a lor easti amirãriljea a tserurilor.” ");
INSERT INTO rup_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Atumtsea elu bãgã mãnjili pri elji, sh-deapoea s-nchisi di aclo. ");
INSERT INTO rup_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Sh-ia, s-apruche un la Isusul sh-lu ntribã: “Nvitsãtore, tsi buneatsã prindi s-fac tsi s-amintã bana eternã?” ");
INSERT INTO rup_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Sh-elu dzãsi: “Cãtse mi ntreghi tsi easti bun? Singur Un easti bun. Macã vrei s-intsri tu banã, veaglji dimãndãrili.” ");
INSERT INTO rup_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Elu ntribã: “Cai?” Atumtsea, Isusul lj-apãndisi: “Nu vatãmã, nu ncalcã curunea, nu furã, nu dã martirii arãdioasã, ");
INSERT INTO rup_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","tinjisea tatãl a tãu sh-muma a ta, shi s-vrei aproapilu a tãu ca cum ti vrei tini.” ");
INSERT INTO rup_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Tinirlu lj-dzãsi: “Tuti aesti lucri mini li am vigljatã. Tsi nji lipseashti altã?” ");
INSERT INTO rup_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Isusul lj-dzãsi: “Macã vrei s-hii perfectu, duti sh-vindi tsi ai, sh-dã-li a niavutsilor, shi tini va s-ai un ayishteari tu tser. Deapoea haidi sh-urmeadz-mi.” ");
INSERT INTO rup_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ma tinirlu cãndu li avdzã aesti zboari, fudzi nvirinat, cã avea multã aveari. ");
INSERT INTO rup_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Atumtsea, Isusul lã dzãsi a ucenitsilor a lui: “Dealihea vã dzãc cã un avut cu zori va s-intrã tu amirãriljea a tserurilor. ");
INSERT INTO rup_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Sh-nãpoi ma va dzãc: Easti ma lishioarã tsi s-treacã cãmila tu guva a aclui, dicãt avutlu s-intrã tu amirãriljea a Dumnidzãlui.” ");
INSERT INTO rup_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Cãndu li avdzãrã aesti zboari, ucenitsilji a lui s-ciudisirã multu shi ntribarã: “Atumtsea, cai va s-ascapã vahi?” ");
INSERT INTO rup_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Sh-Isusul mutrinda cãtrã nãshi dzãsi: “Trã ominjilji aestã easti nipututã, ma trã Dumnidzãulu itsido easti putut.” ");
INSERT INTO rup_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Atumtsea Petrul lj-apãndisi: “Ia, noi li alãsãm tuti sh-vinim dupã tini, ma tsi va s-amintãm noi?” ");
INSERT INTO rup_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Sh-Isusul lã-dzãsi a lor: “Dealihea ma vã dzãc, tu adãrãtura atsea noaua, cãndu Hiljiu a omlui va sheadã pri thronlu a mãririljei a lui, sh-voi tsi mi avets urmat va shidets pi doisprãdzatsi thronuri ti guidicari di doisprãdzatsi fãrili a Israelui. ");
INSERT INTO rup_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Sh-caitsido tsi ari alãsat trã numa a mea cãsi, fratsi, surãri, tatã, muma, muljeari, cilimenji, agri, va s-ljea unã sutã di ori ma multu, sh-va aibã banã eternã. ");
INSERT INTO rup_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ma multsã di protslji va hibã tu coadã, sh-atselji di tu coadã va hibã protslji.” ");
INSERT INTO rup_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Amirãriljea a tserurilor undzeashti cu un nicuchir di casã tsi ishi curund dimineatsa s-puituea lucrutori ti ayinjea a lui. ");
INSERT INTO rup_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Dupã tsi s-ndreapsi tu pãzari cu lucrutorilji cãti un dinar n-dzuã, lji pitricu la ayinjea a lui. ");
INSERT INTO rup_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Apoea ishi anvãrliga di oara noauã dimineatsa, sh-vidzu altsã tsi stãtea tu pãzari fãrã lucru. ");
INSERT INTO rup_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Sh-lã dzãsi a lor: ‘Dutsets-vã sh-voi la ayinjea a mea sh-mini va vã dau cãtã easti ndreptul.’ ");
INSERT INTO rup_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Sh-elji s-dusirã. Elu ishi anvãriliga di njeadzãdzuã sh-pi trei ti-mirindi, featsi unã soi. ");
INSERT INTO rup_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Cãndu ishi nãpoi cãtrã oara tsintsi ti-mirindi, aflã altsã tsi stãtea ni fãrã lucru, sh-lji ntribã: ‘Cãtse shidets aoa tutã dzua ni faptã tsiva?’ ");
INSERT INTO rup_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Elji lji dzãsirã: ‘Cã vãrã nu nã puitui.’ Sh-elu lã dzãsi a lor: ‘Dutsets-vã shi voi la ayinji.’ ");
INSERT INTO rup_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Cãndu vini seara, nicuchirlu a ayinjiljei, lji dzãsi a administratorlui a lui: ‘Acljeamã lucrutorilji shi fã plãtirea a lor, apãrnjida di la atselji di ma nãpoi sh-pãnã la atselji di prota.’ ");
INSERT INTO rup_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Sh-cãndu vinirã atselji di la oara tsintsi, loarã cãti un dinar cathiunu. ");
INSERT INTO rup_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Cãndu vinirã protslji, minduirã cã va loa ma multu, ma sh-atselji loara cãti un dinar cathiunu. ");
INSERT INTO rup_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Luãnda, murmurea contra a nicuchirlui a casiljei, ");
INSERT INTO rup_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","dzãcãnda: ‘Aeshti di ma nãpoi lucrarã mash unã oarã sh-tini lji plãtish ca noi, tsi trapsim greulu sh-cãloarea a dzuãljei.’ ");
INSERT INTO rup_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ma elu lj-apãndisi a unui di nãshi: ‘Oaspe, mini nu ma ts-fac nindriptati. Noi nu featsim pãzari ti un dinar tu dzuã? ");
INSERT INTO rup_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ljea atsea tsi easti a ta sh-imnã. Mini voi s-lji dau aishtui di ma nãpoi cãt a tsãia. ");
INSERT INTO rup_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nu am ndriptati mini s-facã cu a mea tsi s-voi? Catse ti fats oclji ni fãnãtit, cãndu mini escu giumertu?’ ");
INSERT INTO rup_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ashã atselji di ma nãpoi va hibã protslji sh-atselji protslji va hibã atselji di ma nãpoi.” ");
INSERT INTO rup_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Deapoea cãndu Isusul ma s-alina cãtrã Ierusalem, lji lo dinãparti di doisprãdzatsi ucenitsilji sh-pri cali lã dzãsi a lor: ");
INSERT INTO rup_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ia noi nã alinãm tu Ierusalem, sh-Hiljiu a omlui va s-prida la mãrilji a preftsãlor sh-a scribilor. Elji va lu condamnã cu moarti, ");
INSERT INTO rup_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","va lu prida tu mãnjili a pãngãnjilor tsi s-lu pizueascã, va s-lu zãpãleascã shi va s-lu crutsiseascã. Ma elu a treia dzuã va s-nyeadzã dit mortsã.” ");
INSERT INTO rup_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Atumtsea, muma a hiljilor a Zevedeului s-apruche la Isus deadun cu hiljilji a ljei, cãdzu pri dintsã sh-lji-cãftã tsiva. ");
INSERT INTO rup_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Sh-elu lj-dzãsi: “Tsi vrei?” Ea apãndisi: “Ursea tsi aeshti doi hiljilji a melji si apunã un di nandreapta sh-altu di nastãnga tu amirãriljea a ta.” ");
INSERT INTO rup_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Sh-Isusul apãndisi: “Voi nu shtits tsi cãftats. Putets s-bets voi cupa tsi mini va s-beu? Shi s-vã pãtidzats cu pitedzlu cu cai mini va mi pitedz?” Elji dzãsirã: “Ie, putem.” ");
INSERT INTO rup_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Elu lã dzãsi a lor: “Voi dealihea va s-bets cupa a mea. Shi va s-vã patidzats cu pitedzlu cu cai mini va mi pitedz. Ma nu easti tu mãna a mea tsi s-shãdets di nandrepta a mea icã di nastãnga a mea, cã atseli locuri suntu trã atselji tsi s-etimãsirã di la Tatãl a meu.” ");
INSERT INTO rup_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Sh-cãndu avdzãrã aesti zboari di dzatsi alantsã s-nãrãirã cu doi fratsãlji. ");
INSERT INTO rup_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Isusul lji acljimã ningã nãsu sh-lã dzãsi: “Voi lu shtits cã protslji a natsiunilor lji domneascã atselji sh-mãrilji au puteari pri nãshi, ");
INSERT INTO rup_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","ma namisa di voi nu va s-hibã ashã! Cathiun di voi tsi va hibã mari, s-hibã huzmichearlu a vostru, ");
INSERT INTO rup_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","shi caitsido di voi tsi va hibã protlu, prindi s-hibã sclavlu a vostru, ");
INSERT INTO rup_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","cã sh-Hiljiu a omlui nu vini tra s-lji huzmitipseascã, ma huzmitipseascã sh-di dari bana a lui ca arãscumpãrari trã multsã.” ");
INSERT INTO rup_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Cãndu elji ma ishea di Ierico, un multsãmi mari ma nidzea dupã Isusul. ");
INSERT INTO rup_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Sh-ia, doi orghi eara apunats ningã cali. Cãndu avdzãrã cã ma tritsea Isusul, apãrnjirã s-aurlã: “Njiluia-nã noi, Doamne, Hiljiu al David!” ");
INSERT INTO rup_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Multsãmea lji vãrghea tsi s-pãpsea, ma elji aurla ma multu: “Njiluia-nã noi, Doamne, Hiljiu al David!” ");
INSERT INTO rup_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Atumtsea Isusul chindrui lji acljimã sh-lã ntribã: “Tsi vrets s-fac trã voi?” ");
INSERT INTO rup_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Elji dzãsirã: “Doamne, s-nã si dsicljidzã ocljilji.” ");
INSERT INTO rup_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Sh-Isusul aspusi njilã trã nãshi, bãgã mãna pri ocljilji a lor, sh-tu atsea oarã loarã videarea a ocljilor a lor sh-elji lu urmarã. ");
INSERT INTO rup_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Cãndu lji s-apruchearã a Ierusalemului shi agiumsirã tu Betfagã, aproapi di Muntili a Masnjilor, Isusul pitricu doi ucenitsi, ");
INSERT INTO rup_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","dzãcãnda a lor: “Imnats tu hoara tsi easti nãintea a voastrã, sh-atsia va aflats unã gumarã ligatã sh-gumãriclu cu nãsã. Dizligats-lji sh-adutsets-lji la mini! ");
INSERT INTO rup_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Sh-macã vãrã vã dsãtsi tsiva, dzãtsets-lji cã, ‘Domnul ari ananghi trã nãshi,’ sh-atsel va li sãlãgheascã trãoarã.” ");
INSERT INTO rup_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Tora aestã s-featsi tra si mplineascã tsi eara dzãsã di la prufitlu: ");
INSERT INTO rup_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Dzãtsets-lji a hiljiljei a Sionului: ‘Ia, ma ts-yini amirãlu a tãu, inimã-moali, acãlcat pri unã gumarã, njicã ca un gumãric, fãtat di un pravdã ti ngãrcari.’” ");
INSERT INTO rup_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ucenjitsilji s-dusirã sh-featsirã ashã cum lji avea ursit Isusul. ");
INSERT INTO rup_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Adusirã gumara sh-gumãriclu, ashtirnarã pri nãsi mantelili a lor sh-Isusul s-alinã. ");
INSERT INTO rup_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Sh-unã multsãmi multu mar ashtirna mantelili a lor pri cali, iarã altsãlji frãndzea dedzi di ponji sh-li ashtirna pri cali. ");
INSERT INTO rup_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Multsãnjili tsi yinea nãinti sh-atseali tsi lu urma, aurla, dzãcãnda: “Hosanna, a Hiljilui al David! Ghinicuvãntat s-hibã atsel tsi yini tu numa a Domnului! Hosanna tu locurili multi analti!” ");
INSERT INTO rup_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Cãndu intrã Isusul tu Ierusalem, tutã cãsãbãlu si sculã pri cicioari, sh-dzãsi: “Cai easti aestu?” ");
INSERT INTO rup_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Shi multseãmea apãndisi: “Aestu easti Isusul, prufitul di Nazaretul a Galileiljei.” ");
INSERT INTO rup_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Deapoea Isusul intrã tu templu sh-lji aĝuni tuts atselji tsi vindea sh-acumpãra tu templu sh-arustunã measili a alãxitorilor di pãradz shi scamnili a vinditorilor a purunghilor. ");
INSERT INTO rup_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Sh-lã dzãsi a lor: “Easti scriatã: ‘Casa a mea va s-acljemã casã di pãrãcãlsiri,’ ma voi u avets turnatã ca un pishtireauã di furi.” ");
INSERT INTO rup_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Atumtsea vinirã la nãsu tu templu orghi shi shcljiochi sh-Isusul lji vindicã. ");
INSERT INTO rup_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ma mãrilji a preftsãlor shi scriblji s-nãrãirã cãndu vidzurã thavmatili tsi elu avea faptã shi cilimenjilji tsi dzãtsea cu harauã tu templu: “Hosanna a Hiljilui al David!” ");
INSERT INTO rup_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Sh-lji dzãsirã: “Ma avdzã tini tsi dzãc aeshti?” Isusul lã dzãsi a lor: “Ie! Nu avets cãntatã pute: ‘Dit gura a njitsilor sh-a bebilor tini ai adratã alãvdari’?” ");
INSERT INTO rup_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Sh-dupã tsi lji alãsã atselji, ishi di cãsãbã cãtrã Betania, sh-aclo tricu noaptea. ");
INSERT INTO rup_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Dimineatsa curund, cãndu ma s-turna tu cãsãbã, lu lo foama. ");
INSERT INTO rup_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Pri cali vidzu un hic sh-lji si-apruche, ma nu aflã tsiva, dicãt mash frãndzili sh-dzãsi: “S-nu s-leagã frut pute la tini di totãna!” Sh-hiclu s-uscã trãoarã. ");
INSERT INTO rup_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Sh-cãndu vidzurã aestã ucenitslji s-ciudisirã sh-dzãsirã: “Cum s-uscã hiclu trãoarã!” ");
INSERT INTO rup_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Sh-Isusul apãndisi: “Dealihea vã dzãc, ma s-avets pisti shi s-nu ndoits, va s-fãtsets nu mash atsea tsi mini lji-feciu a hiclui, ma sh-canda s-lji dzãtsets aishtui munti: ‘Scoal-ti di aclo sh-arucã-ti tu amari’, aestã va si s-facã. ");
INSERT INTO rup_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Sh-itsido tsi cãftats tu pãrãcãlsiri, pistipsinda, va u-loats.” ");
INSERT INTO rup_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Cãndu intrã tu templu, mãrilji a preftsãlor sh-aushilji a popului lji s-apruchearã candu ma lji nvitsa, sh-lu ntribarã: “Cu tsi autoritati li fatsi tini aesti lucri? Sh-cai ts-ari datã aestã autoritati?” ");
INSERT INTO rup_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Sh-Isusul apãndisi: “Sh-mini va vã fac unã ntribari, sh-macã voi va nj-apãndisits, mini tutashã va vã dzãc, cã cu tsi autoritati li fac tuti aesti lucri. ");
INSERT INTO rup_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Pitedzlu a Ioanului di iu vini? Di la tser icã di la oaminjilji?” Sh-elji minduea namisa di nãshi, dzãcãnda: “Ma s-lji dzãtsem di la tser, elu va nã dzãcã: ‘Cãtse atumtsea nu lji pistipsit?’ ");
INSERT INTO rup_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Macã va lj-dzãtsem, ‘di la oaminjilji,’ avem fricã di multsãmea, cã tuts lu acljeam Ioanul prufit.” ");
INSERT INTO rup_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Sh-lji-apãndisirã a Isusului, dzãcãnda: “Nu shtim.” Atumtsea elu lã dzãsi a lor: “Nitsi mini nu va vã dzãc cã cu tsi autoritati li fac aesti lucri.” ");
INSERT INTO rup_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Tsi minduits? Un om avea doi hilji sh-cum s-dusi cãtrã protlu, lji dzãsi: ‘Hilje, duti azã s-lucredzi tu ayinji!’ ");
INSERT INTO rup_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Elu apãndisi: ‘Nu voi,’ ma, ma nãpoi s-mitãnjusi shi s-dusi. ");
INSERT INTO rup_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Deapoea tatãl s-turnã cãtrã a doilu shi lj-dzãsi sh-a lui unã soi. Sh-elu lj-apãndisi sh-dzãsi: ‘Ie, doamne,’ ma nu s-dusi. ");
INSERT INTO rup_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Cai di dolji lu featsi vrearea a tatãlui?” Elji lj-dzãsirã: “Protlu.” Isusul lã dzãsi a lor: “Dealihea vã dzãc cã taxidarilji sh-putanili va intrã nãinti di voi tu amirãriljea a tserurilor.” ");
INSERT INTO rup_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Cã Ioanul vini la voi trã spuneari calea a ndriptatiljei, sh-voi nu lu pistipsit, iarã taxidarilji sh-putanili lji pistipsirã. Cu tut atsea, voi nitsi dupã tsi li avets vidzutã aesti lucri, nu vã mitunjãsit sh-nu pistipsit. ");
INSERT INTO rup_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Ascultats unã altã parabolã. Eara un nicuchir a casiljei, tsi siminã un ayinji, sh-u anvãrligã cu gardu shi sãpã un loc di stultsinari aua, sh-adrã un pirĝu di vigljari. Ayinjea lji u-pistipsi la niscãntsã ayinjeari sh-fudzi diparti. ");
INSERT INTO rup_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Cãndu vini chirolu di adunari, elu pitricu huzmichearlji a lui la ayinjearlji ti adunari partea a lui di fruti. ");
INSERT INTO rup_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ma ayinjearlji lji acãtsarã huzmichearilji a lui, unu lu bãturã, alantu lu vãtãmarã, sh-a treilu lu vãtãmarã cu chetri. ");
INSERT INTO rup_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nãpoi pitricu altsã huzmicheari, ma multsã di protslji, sh-ayinjearlji featsirã cu nãshi un soi. ");
INSERT INTO rup_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Tu soni, elu pitricu hiljiu a lui, dzãcãnda: ‘Di hiljiu a meu va aibã respect.’ ");
INSERT INTO rup_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ma ayinjearlji cãndu lu vidzurã hilj-su, dzãsirã un cu-alantu: ‘Aestu easti mushtinitorlu. Haidets, s-lu vãtãmãm shi s-lom mushtinirea a lui.’ ");
INSERT INTO rup_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Sh-lu acãtsarã, lu arcarã nafoarã di ayinji sh-lu vãtãmarã. ");
INSERT INTO rup_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Tora, cãndu va yinã nicuchirlu a ayinjiljei, tsi va-l fac a ayinjearilor aishtor?” ");
INSERT INTO rup_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Elji dzãsirã: “Elu va lji vatãmã di tuts arãlji, sh-va lã-u da ayinjia la altsã ayinjear, tsi va s-da frutili tu chirolu tsi prindi.” ");
INSERT INTO rup_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Isusul lã dzãsi a lor: “Nu avets cãntatã pute la Scriturili: ‘Cheatra tsi masturilji u-scoasirã ca nilipsitã, s-featsi cheatra a chioshlui. Aestu easti ciudia tsi Domnul featsi sh-easti thãvmãtisit tu ocljilji a noshtri’? ");
INSERT INTO rup_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Trã atsea mini ma vã dzãc a voauã, cã va vã si ljea amirãriljea a Dumnidzãlui, sh-va lj-si da a unui popul tsi va da fruti. ");
INSERT INTO rup_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Sh-atsel tsi va s-cadã pri aestã cheatrã, va si s-frãngã, sh-atsel pri cai va s-cadã cheatra va si sãrãmã.” ");
INSERT INTO rup_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Sh-mãrilji a preftsãlor sh-Fariseilji candu li avdzãra parabolili a lui, aduchirã cã ma grea trã nãshi. ");
INSERT INTO rup_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Sh-cãfta s-lu acãtsa, ma avea fricã di populu, cã elji lu lugursea prufit. ");
INSERT INTO rup_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Sh-Isusul lã gri nãpoi a lor cu parabolã, dzãcãndã: ");
INSERT INTO rup_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Amirãriljea a tserurilor lj-undzeashti a unui amirã, cai etimãsi numta a hiljilui. ");
INSERT INTO rup_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Sh-pitricu huzmichearlji a lui s-lã greascã a acljimatsãlor tu numtã, ma elji nu vrurã s-yinã. ");
INSERT INTO rup_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Pitricu altsã huzmicheari, dzãcãnda: ‘Dzãtsets-lã a acljimatsãlor: Ia, mini am ndreaptã uspetsea, yitsãlji sh-nãmaljili grasi suntu tãljati, sh-itsido easti etimu. Haidets pi numtã.’ ");
INSERT INTO rup_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ma elji nu vrurã s-avdã shi s-dusirã, un tu agrul a lui sh-alantu tu lucrili a lui. ");
INSERT INTO rup_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Sh-alantsãlji dupã tsi acãtsarã huzmichearilji a lui, lji ngiurarã sh-lji vãtãmarã. ");
INSERT INTO rup_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Atumtsea amirãlu cãndu avdzã aestã, s-nãrãi sh-pitricu armata a lui lji afãnisi atselji vãtãmãtori sh-arsi cãsãbãlu a lor. ");
INSERT INTO rup_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Atumtsea lã dzãsi a huzmichearilor a lui: ‘Numta easti etimã, ma acljimatsãlji nu furã axii. ");
INSERT INTO rup_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Dutsets-vã la crutsisirea a cãljiurilor sh-acljimats pi numtã caitsido tsi s-aflats.’ ");
INSERT INTO rup_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Sh-huzmichearlji ishir pri cãljiuri, adunarã tuts atselji tsi aflarã, arãi sh-bunji, sh-loclu a numtãljei s-umplu cu acljimats. ");
INSERT INTO rup_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Atumtsea amirãlu intrã s-veadã acljimatsãlji, sh-vidzu aclo un om tsi nu avea nviscut stranjili di numtã. ");
INSERT INTO rup_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Amirãlu lj-dzãsi: ‘Oaspe cum intrash aoa ni avut stranji di nuntã?’ Sh-elu ncljisi gura. ");
INSERT INTO rup_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Atumtsea amirãlu lã dzãsi a servitorilor: ‘Ligats-lu di manji sh-di cicioari, sh-arucats-lu tu scutidlu di nafoarã. Aclo va hibã plãngul sh-cãrtsinirea a dintsãlor.’” ");
INSERT INTO rup_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Isusul ncljisi zborlu a lui, dzãcãnda: “Multsã suntu acljimats, ma putsãnji suntu aleptsã.” ");
INSERT INTO rup_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Atumtsea Fariseilji s-dipãrtarã shi s-minduirã, cum s-lu acãtsa tu cãbati. ");
INSERT INTO rup_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Sh-pitricurã ucenjitsili a lor deadun cu Irodianjilji s-lji dzãtsea: “Nvitsãtore, noi shtim cã tini eshti alihios, sh-tsi nvetsi calea a Dumnidzãlui dupã alihea, sh-nu ti mealã di vãrã, cã tini nu vedz pãrearea di nafoarã a oamnjilor. ");
INSERT INTO rup_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Dzã-nã tora, cum mindueshti? Easti ndreptu si s-plãteascã taxa a Cezarului, icã nu?” ");
INSERT INTO rup_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ma Isusul cunuscãnda arãutatea a lor, lã dzãsi: “Cãtse mi cãrtits, ipucrits? ");
INSERT INTO rup_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Spunets-nji denarlu a taxãljei.” Atumtsea elji lji spusirã un denar. ");
INSERT INTO rup_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Sh-elu lã dzãsi a lor: “A cui easti aestã fatsã sh-aestã scriturã?” ");
INSERT INTO rup_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Elji lj-dzãsirã: “A Cesarului.” Atumtsea elu lã dzãsi a lor: “Dats-lã a Cesarului tsi easti a Cesarului sh-a Dumnidzãlui tsi easti a Dumnidzãlui.” ");
INSERT INTO rup_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Sh-elji cãndu avdzãra aestã, s-ciudisirã, lu alãsarã sh-fudzirã. ");
INSERT INTO rup_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Tu atsea dzuã vinirã la nãsu Saduceilji, tsi nu pistipsescu tu nyeari, sh-lu ntribarã, ");
INSERT INTO rup_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","dzãcãnda: “Nvitsãtore, Moisiul ari dzãsã: Macã vãrã moari sh-nu alasã cilimenji, fratili a lui si nsoarã cu muljearea a lui, tra s-lji alasã mushtinitori a fratiui a lui. ");
INSERT INTO rup_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Tora trã noi eara shapti frats, protlu si-nsurã sh-muri. Nu alãsã mushtinitori, sh-u alãsã muljeari-sa a fratilui a lui. ");
INSERT INTO rup_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ashã sh-a doilu, sh-a treilu, pãnã la a shaptilu. ");
INSERT INTO rup_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Tu soni, muri sh-muljearea. ");
INSERT INTO rup_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Tu nyeari, a cui di aeshti shapti va hibã muljearea? Cã tuts u avurã muljeari.” ");
INSERT INTO rup_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ma Isusul apãndisi: “Hits tu cãbati cã nu u cunushtets nitsi Scritura, nitsi putearea a Dumnidzãlui. ");
INSERT INTO rup_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Tu nyeari oaminjilji nitsi va si-nsoarã sh-nitsi va si s-mãritã, ma elji va s-hibã ca anghilji tu tseruri. ");
INSERT INTO rup_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Tora, trã nyearea a mortsãlor, nu avets cãntatã tsi vã easti dzãsã di la Dumnidzãlu: ");
INSERT INTO rup_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Mini escu Dumnidzãlu al Avraham, Dumnidzãlu al Isac sh-al Iacov’? Dumnidzãlu nu easti Dumnidzãlu a mortsãlor ma a yiilor.” ");
INSERT INTO rup_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Sh-multsãmea, cãndu li avdza aesti s-ciudisea di nvitsãtura a lui. ");
INSERT INTO rup_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Tora Fariseilji cãndu avdzãrã cã Isusul avea astupatã gura a Saduceiljilor, s-adunarã deadun. ");
INSERT INTO rup_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Sh-un di atselji, nvitsãtor di lege, ntribãnda, l-bãgã tu provã: ");
INSERT INTO rup_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Nvitsãtore, cai easti ordinlu ma mari tu Lege?” ");
INSERT INTO rup_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Sh-Isusul dzãsi: “‘S-vrei Domnul, Dumnidzãlu a tãu, cu tutã inima a ta, cu tutã suflitlu a tãu, sh-cu tutã mintea a ta.’ ");
INSERT INTO rup_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Aestã easti protlu sh-ma marli ordin. ");
INSERT INTO rup_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Sh-a doilu uni soi ca aestu easti: ‘S-vrei aproapilu a tãu uni soi ca cum ti vrei tini.’ ");
INSERT INTO rup_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Di aesti doi ordinii si aspindzurã Legea sh-Prufitsãlji.” ");
INSERT INTO rup_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Tora cãndu s-adunarã Fariseilji, Isusul lji ntribã: ");
INSERT INTO rup_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Cum minduists voi trã Hristolu? Hiljilu a cui easti?” Elji dzãsirã: “Al David.” ");
INSERT INTO rup_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Elu lã dzãsi a lor: “Ma cum, atumtsea Davidul, tu Duh, lu acljeamã ‘Domn’? Davidul dzãsi: ");
INSERT INTO rup_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Domnul lj-ari dzãsã a Domnului a meu: Apun-ti tu nandreapta a mea pãnã cãndu mini s-bagã dushmanjilji a tãlji ca scamnã sum cicioarili a tali.’ ");
INSERT INTO rup_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Macã Davidul lu acljeami ‘Domnu’, cum poati s-hibã hiljilu a lui?” ");
INSERT INTO rup_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Sh-vãrã nu putu s-lji apãndisea, sh-di atsea dzuã vãrã nu cutidzea s-lu ntriba ma. ");
INSERT INTO rup_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Atumtsea Isusul lã gri a multsãnjilor sh-a ucenitsilor a lui, ");
INSERT INTO rup_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","shi dzãsi: “Scriblji sh-Fariseilji shidzurã pri scamnul al Moisiu. ");
INSERT INTO rup_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Trã atsea, vigljeats shi fãtsets itsi vã dzãc, ma nu fãtsets cum fac elji, cãtse dzãc, ma nu fac. ");
INSERT INTO rup_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Elji leagã sartsinji greali tsi s-poarta cu zori sh-li bagã pri plãtãrili a oamnjilor, ma elji nu vor s-li minã nitsi cu dzeaditlu a lor. ");
INSERT INTO rup_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ma tuti faptili a lor li facã tra si s-veadã di oaminjilji, li lãrdzescu filacterili a lor sh-li lundzescu hirilji a stranjilor a lor. ");
INSERT INTO rup_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Arisescu protili locuri la uspetsi sh-protili locuri tu sinagodzi, ");
INSERT INTO rup_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","sh-ncljinãciunjili tu pãdzi, shi si s-acljeamã ‘Rabi’ di oaminjilji. ");
INSERT INTO rup_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ma voi, nu alãsats s-vã acljeamã ‘Rabi’, cã mash un easti Nvitsãtorlu a vostru, sh-voi tuts hits frats. ");
INSERT INTO rup_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Sh-pristi loc nu acljimats vãrã ‘tatãl’ a vostru, cã mash un easti Tatãlu a vostru. Elu easti tu tseruri. ");
INSERT INTO rup_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nu alãsats s-vã acljeamã printsu, cã un easti printsul a vostru: Hristolu. ");
INSERT INTO rup_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ma marli di voi prindi s-hibã huzmichiarlu a vostru. ");
INSERT INTO rup_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Cã cai va si s-analtsã, va si s-apleacã, sh-cai va si s-apleacã, va si s-analtsã. ");
INSERT INTO rup_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ma cavai di voi Scribi sh-Farisei ipucrits! Cã ncljidets amirãriljea a tserurilor nãintea a oamnjilor. Cã nitsi voi nu intrats, nitsi nu alãsats atselji tsi vor s-intrã. ");
INSERT INTO rup_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Cavai di voi Scribi sh-Farisei ipucrits! Cã mãcats tu cãsili a veduvilor, shi trã ocljilji a lumiljei fãtsets pãrãcãlsiri lundzi, trã atsea voi va s-hits giudicats. ");
INSERT INTO rup_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Cavai di voi Scribi sh-Farisei ipucrits! Cã tritsetsi amarea sh-loclu ti fãtseari prozelits, sh-cãndu vãrã, s-fatsi ahtar lu fãtsets hiljilu al Geehena, sh-di doauã ori ma arãu di voi. ");
INSERT INTO rup_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Cavai di voi, cãlãuzi orghi tsi dzãtsets: ‘Macã vãrã si spigiurã pi templu nu easti tsiva, macã si spiugirã pi furiia a templui prindi s-tsãnã spigiurarea.’ ");
INSERT INTO rup_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Glari sh-orghi! Cai easti ma mari: furia icã templu tsi sãmtsashti furia? ");
INSERT INTO rup_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Voi ninga dzãtsets: ‘Ma atsel tsi va si spigiurã pi altarlu, nu easti tsiva, macã si spigiurã pi doara tsi easti pi nãsu, prindi s-tsãna spigiurarea.’ ");
INSERT INTO rup_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Orghi! Cai easti ma marã: doara icã altarlu tsi sãmtsashti doara? ");
INSERT INTO rup_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ma atsel tsi va si spigiurã pi altarlu, si spigiurã pi nãsu sh-pi itsi lucri tsi suntu pisti nãsu. ");
INSERT INTO rup_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Atsel tsi si spigiurã trã templu, si spigiurã trã nãsu sh-trã Dumnidzãlu tsi bãneadzã aclo. ");
INSERT INTO rup_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ma atsel tsi va si spigiurã pri tserlu, si spigiurã pri thronlu al Dumnidzãu sh-pri atsel tsi shãdi pri nãsu. ");
INSERT INTO rup_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Cavai di voi Scribi sh-Farisei ipucritsi! Cã voi lugursits a dzatsea a mentãljei sh-a mãrariljei, a chiminãljei, shi alãsats dupã mãnã lucrili atseali ma greali a legiljei: ndriptatea, njila sh-pistea. Aesti lucri prindi s-li fãtsets ni alãsat dupã mãnã altãli. ");
INSERT INTO rup_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Cãlãuzi orghi, tsi sticurats biutura trã s-mutats cunuplu, ma ascãpitats cãmila! ");
INSERT INTO rup_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Cavai di voi Scribi sh-Farisei ipucritsi! Cã curatsã partea di nafoarã a cupãljei, sh-a piatãljei, iarã di nãuntru suntu mplini cu arãchiri sh-cu zãlumi. ");
INSERT INTO rup_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Fariseu orbu! Curã ma nãinti di nãuntru cupa sh-piata, sh-di nafoarã va s-hibã curatã. ");
INSERT INTO rup_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Cavai di voi Scribi sh-Farisei ipucritsi! Cã undzits ca murmintsã alghiti, tsi di nafoarã s-veadã mushati, ma nãuntru suntu mplini di oasili a mortsãlor sh-cu multã livushiturã. ");
INSERT INTO rup_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ashã shi voi di nafoarã vã aspunets a oaminjlor ca ndreptsã, ma di nãuntru hits mplinã di ipucrizii sh-di anapudii. ");
INSERT INTO rup_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Cavai di voi Scribi sh-Farisei ipucritsi! Cã adrats murmintsãlji a prufitsãlor shi stulsits grochili a ndreptsãlor, ");
INSERT INTO rup_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","sh-dzãtsets: ‘Ma s-aveam bãnat tu chirolu a pãpãnjilor a noshtri, nu va avem prilucrat cu nãshi, la vãtãmarea a prufitsãlor.’ ");
INSERT INTO rup_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Zburãnda ashãtsi voi mãrtirsits contra di voi, cã hits hiljilji atsilor tsi vãtãmãrã prufitsãlji. ");
INSERT INTO rup_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Voi u-tritsest misura a pãpãnjilor a voshtri. ");
INSERT INTO rup_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Sherchi, pulji di nãpãrtitsi! Cum va s-ascãpats di giudicarea a Geheniljei? ");
INSERT INTO rup_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Trã atsea, ia mini ma pitrec la voi prufitsi, shtiutsi shi srcibii. Voi niscantsã di nãshi va lji vãtãmats, sh-va lji crutsisits. Niscãntsã altsã va lji bãtets tu sinagogãli a voastri, sh-va lji avinats dit un cãsãbã tu altu, ");
INSERT INTO rup_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","tra s-cadã pri voi tutã sãndzili a ndreptsãlor, virsatã pri loc, di la sãndzili a ndreptului Abel panã la sãndzili al Zaharia, hiljilu al Barahia, tsi voi lu vãtãmat namisa di templu sh-di altar. ");
INSERT INTO rup_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Dealihea ma vã dzãc cã tuti aesti lucri va s-cadã pri aestã farã. ");
INSERT INTO rup_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ierusalem, Ierusalem, tsi li vatsãnji prufitsãlji sh-li vatsãnji cu chetri atselji pitricutsãlji la tini! Di cãti ori am vrutã s-adun hiljilji a tãlji ashãtsi cum aduni clocea puljilji a ljei sum areapti, ma voi nu vrutã! ");
INSERT INTO rup_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ia, templul a vostru ma armãni shcretã. ");
INSERT INTO rup_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Cã mini ma vã dzãc, cã di tora sh-nclo nu va mi videts ma pãnã cãndu s-dzatsets: ‘Ghinicuvãntat s-hibã atsel tsi yini tu numa a Domnului!’” ");
INSERT INTO rup_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Tora cãndu Isusul ishi dit templu sh-ma s-dipãrta, ucenitsilji a lui lji s-apruchearã tsi s-lji spunea adãrãturili a templui. ");
INSERT INTO rup_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ma Isusul lã dzãsi a lor: “Nu li videts voi tuti aesti? Dealihea ma vã dzãc, cã aoa nu va s-armãnã vãrã cheatrã pristi cheatrã, cã tuti va s-hibã surpati.” ");
INSERT INTO rup_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Deapoea cãndu elu shidzu tu Muntili a Masnjilor, lji s-apruchearã singur ucenitsilji u lui sh-lji dzãsirã: Nã-aspunã cãndu va s-undzeascã aesti lucri? Sh-cai va hibã semnu a vinitiãjei a ta sh-a bitisitãljei a etiljei? ");
INSERT INTO rup_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Sh-Isusul apãndisi: “Afirits-vã s-nu vã arãdã vãrã! ");
INSERT INTO rup_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Cã multsã va yinã tu numa a mea, sh-va dzãcã: ‘Mini escu Hristolu,’ sh-va s-arãdã multsã oaminji. ");
INSERT INTO rup_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Atumtsea va s-avdzãts di alumti sh-di hãbãri trã alumti. Afirits-vã, sh-nu vã aspãrats, cã aesti tuti prindi si s-facã, ma bitisita ninga nu va s-aibã vinitã. ");
INSERT INTO rup_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Va si scoalã natsiunea contra a natsiuniljei, amirãriljea contra a amirãriljie, va s-aibã urfanji di pãni, sh-cutremburi tu multi locuri. ");
INSERT INTO rup_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ma tuti aesti lucri va s-hibã apãrnjita a durerilor a amintariljei. ");
INSERT INTO rup_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Atumtsea va s-vã prida tu munduiri sh-va s-vã vatãma, sh-di tuti natsiunili va s-vã aurascã trã itia a numãljei a mea. ");
INSERT INTO rup_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Atumtsea multsa va s-dipãrteadzã di pisti, va vindã un-alantu, sh-va aurasca un-alantu. ");
INSERT INTO rup_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Va s-easã multsã prufits arãdioshi, sh-va arãdã multsã oaminji. ");
INSERT INTO rup_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Sh-macã va s-multseacã anapudzilji, a multsãlor va lã s-arãtseascã vrearea. ");
INSERT INTO rup_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ma atsel tsi va aravdã pãnã tu soni, atsel va s-ascapã. ");
INSERT INTO rup_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Sh-evanghelul aestu a amirãriljei va hibã predicat pri tutã lumea, ca unã mãrtiri di tuti natsiunile sh-atumtsea va hibã bitisita.” ");
INSERT INTO rup_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Cãndu s-videts lãhtarea a shcretuiriljei, tsi easti paradzãs di prufitlu Daniel, sh-ljea loc tu loclu sãmtu (cai cãntã s-lu aducheascã), ");
INSERT INTO rup_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","atumtsea atselji tsi suntu tu Iudea, s-fugã pri muntsã. ");
INSERT INTO rup_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Cai s-alfã pri tãratsa a casiljei, s-nu dipunã s-ljea tsiva di casã. ");
INSERT INTO rup_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Cai easti pri agru s-nu si s-toarnã s-ljea mantelul a lui. ");
INSERT INTO rup_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ma cavai di muljerili atseali greali sh-atseali tsi va lji da sinã a cilimeanlui tu atseali dzãli. ");
INSERT INTO rup_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ma pãrãcãlsits-vã tsi fudzirea a voastrã s-nu hibã iarna, icã Sãmbãta. ");
INSERT INTO rup_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Cã atumtsea va aibã unã munduiri ahãntu mar, cãt nu ari undzit pute di tu ahurhita a lumiljei, pãnã azã, sh-nu va aibã vãrãoarã. ");
INSERT INTO rup_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Sh-ma s-nu si shcurteadzã atseali dzãli, nu va ascapa vãrã om, ma trã itia a aleptsãlor atseali dzãli va si shcurteadzã. ");
INSERT INTO rup_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Atumtsea macã vãrã va vã dzãcã: ‘Ia, Hristolu easti aoa,’ icã: ‘Easti aclo,’ nu lu pistipsits. ");
INSERT INTO rup_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Cã va easã hristoshi arãdioshi sh-prufitsi arãdioshi, sh-va facã seamni mãri, sh-ahãnti ciudii cãt, ma s-putea s-arãdã s-putea sh-aleptsãlji. ");
INSERT INTO rup_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ia, adutsets-vã aminti cã mini vã hãbãrsii ma nãinti. ");
INSERT INTO rup_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Sh-macã vã dzãcã: ‘Ia, Hristolu easti tu irnjii,’ nu dutsets-vã aclo. ‘Ia, easti tu udãdzili atseali ascumti,’ nu pistipsits-lã. ");
INSERT INTO rup_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Cã ca ascãpirarea tsi easi di tu rãsãrit shi si aspuni pãnã tu ascãpitat, ashã va hibã sh-vinita a Hiljilui a omlui. ");
INSERT INTO rup_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Cã aclo iu suntu cufomili, aclo va s-adunã sh-vulturilji.” ");
INSERT INTO rup_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Tora dupã nvirinarea atsilor dzãli, ‘soarili va si scutidiseascã, sh-luna nu va s-da lunjina a ljei. Stealili va s-cadã dit tser, sh-puterili a tseruilor va si trunduescu.’ ");
INSERT INTO rup_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Atumtsea va si s-veadã tu tser semnul a Hiljilui a omlui. Tuti natsiunili a loclui va plãngã, cãndu s-veadã Hiljilu a omlui yininda pristi norilji a tserlui cu puteari sh-mãriri mari. ");
INSERT INTO rup_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Sh-elu va li pitreacã anghilji a lui cu boatsi vãrtoasi di trumpetã, sh-elji va adunã aleptsãlji a lui di patru vimturili, di unã mardzinã a tserlui pãnã la alantã. ");
INSERT INTO rup_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Tora di la hiclu nvitsats aestã parabolã: cãndu tora dedzili a lui s-muljeadzã, shi scoatã frãndzãli, s-u shtits cã vearea easti aproapi. ");
INSERT INTO rup_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ashãtsi sh-voi, cãndu s-videts tuti aesti lucri, si shtits cã elu easti aproapi, ningã ushã. ");
INSERT INTO rup_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Dealihea ma vã dzãc cã nu va treacã aestã gheneratã ni faptã tuti aesti. ");
INSERT INTO rup_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Tserlu shi loclu va treacã, ma zboarili a meali nu va treacã.” ");
INSERT INTO rup_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Iarã di dzua atsea sh-di oara atsea vãrã nu shtii, nitsi anghilji dit tser, nitsi Hilljilu, ma singur Tatãl. ");
INSERT INTO rup_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Shi ashã cum tu dzãlili al Noe, ashã va hibã sh-la vinita a Hiljiu a omlui. ");
INSERT INTO rup_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Cã ashã cum tu dzãlili atseali di cama nãinti a nicariljei, oaminjili mãca sh-bea, si-nsura shi s-mãrta, pãnã cãndu Noeul intrã tu varcã. ");
INSERT INTO rup_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Elji nu aduchirã tsiva, pãnã cãndu vini nicarea sh-lji lo tuts. Ashã va hibã sh-tu vinita a Hiljilui a omlui. ");
INSERT INTO rup_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Atumtsea doi va hibã la agru, un va si s-ljea, sh-alantu va si s-alasã. ");
INSERT INTO rup_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Doauã muljeri va s-matsinã la moarã, unã va si s-ljea, sh-alanta va si s-alasã. ");
INSERT INTO rup_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Stats dishtiptat, cã nu shtits tu tsi oarã va s-yinã Domnul a vostru. ");
INSERT INTO rup_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ma si shtits aestã, cã ma s-shtiea nicuchirlu a casiljei tu tsi oarã a noaptiljei va yinea furlu, va s-armãnea dishtiptat sh-nu va lu alãsa s-lji intra tu casã. ");
INSERT INTO rup_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Trã aestã voi s-hits etimãsits, cã Hiljiu a omlui va s-yinã tu atsea oarã cãndu voi nu lu ashtiptats.” ");
INSERT INTO rup_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Cai easti atsel huzmichear pistimen sh-mintimen? Easti atsel tsi nicuchirlu l-bãgã pristi huzmichearlji a lui, tra s-lã da hranã tu oara tsi prindi. ");
INSERT INTO rup_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ca hara di atsel huzmichear tsi, cãndu si s-toarnã nicuchirlu a lui, s-lu aflã fãcãnda ashã. ");
INSERT INTO rup_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Dealihea ma vã dzãc cã elu va s-lji pistipseascã atsilui huzmichear tutã ayishterea a lui. ");
INSERT INTO rup_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ma, macã aestu huzmichear arãu dzãtsi tu inima a lui: ‘Domnul a meu amãni s-yinã,’ ");
INSERT INTO rup_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","sh-ahurheashti s-batã sotsilji a lui, sh-mãcã sh-bea cu biutorlji, ");
INSERT INTO rup_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","domnulu aishtui huzmichear va yinã tu dzua atsea, cãndu elu nu lu ashteapti, sh-tu oara atsea cãndu elu nu u-shtii. ");
INSERT INTO rup_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Elu va lu condamnã greu sh-va lji da tihea a ipucritsilor. Aclo va s-hibã plãngul sh-cãrtsãnirea a dintsãlor.” ");
INSERT INTO rup_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Atumtsea amirãriljea a tserurilor va s-undzeascã cu dzatsi virgini, tsi li loarã cãndilili a lor, sh-ishirã nãintea a dzinirlui. ");
INSERT INTO rup_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Tora tsintsi di eali eara glari sh-tsintsi mintimeni. ");
INSERT INTO rup_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Glarili, cãndu loarã cãndilili a lor, nu loarã cu nãsi sh-untulemlu. ");
INSERT INTO rup_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Iarã mintimenili, deadun cu cãndilili, loarã sh-untulemlu tu vasili a lor. ");
INSERT INTO rup_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Sh-metsi dziniri ma s-amãna, lã vini somnul a tutulor sh-durnjirã. ");
INSERT INTO rup_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ma cãtrã njedzã-noapti s-avdzã un griri: ‘Ia, ma yini dzinirli, ishits s-lu adunats!’ ");
INSERT INTO rup_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Atumtsea tuti virginili s-dishtiptarã shi ndreapsirã cãndilili a lor. ");
INSERT INTO rup_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Shglarili lã dzãsirã a mintimenilor: ‘Dats-nã di untulemlu a vostru, cã cãndilili a noastri ma s-astingã.’ ");
INSERT INTO rup_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ma mintimenili apãndisirã: ‘Nu, cã nu va nã-agiungã, nitsi a noauã nitsi a voauã. Ma ghini nidzets la vinditorlji sh-acumpãrats.’ ");
INSERT INTO rup_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Sh-cãndu eali s-dusirã s-acumpãrã, yini dzinirli. Virginili tsi eara etimi, intrarã deadun cu nãsu la numtã, sh-usha si ncljisi. ");
INSERT INTO rup_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ma napoi vinirã sh-alanti virgini, dzãcãnda: ‘Doamne, doamne, discljidi usha.’ ");
INSERT INTO rup_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ma elu apãndisi: ‘Dealihea ma vã dzãc, cã nu vã cunoscu.’ ");
INSERT INTO rup_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Trã atsea stats dishtiptat, cã nu shtits nitsi dzua nitsi oara cãndu va yinã.” ");
INSERT INTO rup_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Amirãriljea a tserurilor undzeashti tutashã ca un om, tsi cãndu ma s-nchisea ti un cãlãtorii lã acljimã huzmichearlji sh-lã pistipsi a lor avearea a lui. ");
INSERT INTO rup_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","A unui lji deadi tsintsi talentsã, a altui doi sh-a altui un, a cuitsido dupã putearea a lui sh-fudzi pi cali. ");
INSERT INTO rup_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Trãoara atsel tsi avea loatã tsintsi talentsã s-dusi, sh-featsi pãzari sh-amintã tsintsi altsã. ");
INSERT INTO rup_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Tutashã sh-atsel tsi avea loatã doi talentsã amintã doi altsã. ");
INSERT INTO rup_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Iarã atsel tsi avea loatã un, s-dusi, disfeatsi unã groapã tu loc sh-ascumsi talentul a nicuchirlui a lui. ");
INSERT INTO rup_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Dupã multu chiro, s-turnã nicuchirlu a huzmichearilor sh-featsi luguriili cu elji. ");
INSERT INTO rup_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Sh-atsel tsi avea loatã tsintsi talentsã lj-ishi nãinti sh-lji adusi tsintsi altsã, dzãcãnda: ‘Doamne, tini nji ai pistipsitã tsintsi talentsã, ia cu atseali mini amintai tsintsi altsã.’ ");
INSERT INTO rup_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Sh-nicuchirlu lj-dzãsi: ‘Bravo, huzmichear bun sh-pistimen. Tini fushi pistimen ti lucri njitsi, mini va ti bag pi mãri lucri. Haidi s-hãrseshti cu nicuchirlu a tãu!’ ");
INSERT INTO rup_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Deapoea vini sh-atsel tsi avea loatã doi talentsã sh-dzãsi: ‘Doamne, tini nji ai pistipsitã doi talentsã. Ia, cu atseali mini amintai doi altsã.’ ");
INSERT INTO rup_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Sh-nicuchirlu a lui lj-dzãsi: ‘Bravo, huzmichear bun sh-pistimen. Tini fushi pistimen tu lucri njitsi, mini va ti bag pi mãri lucri. Haidi s-harseshti cu nicuchirlu a tãu!’ ");
INSERT INTO rup_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Tu bitisitã vini sh-atsel tsi avea loatã mash un talentu sh-dzãsi: ‘Doamne, mini lu shtiam cã eshti om aspru, tsi seatsiri aclo iu nu ai siminatã sh-adunji iu nu ai mpãrtsãtã, ");
INSERT INTO rup_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","trã atsea avui fricã sh-mi dush sh-lu ascumshu talentul a tãu tu loc. Ia, mini ma ts-u tornu atsel tsi easti a tãu.’ ");
INSERT INTO rup_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Sh-nicuchirlu apãndisi: ‘Huzmichear anapud sh-timbel! Tini lu shtiai cã mini seatsir aclo iu nu am siminatã sh-adun aclo iu nu am mpãrtsãtã. ");
INSERT INTO rup_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Tini prindea s-lji-aveai datã pãradzli a meali la bancã sh-ashã, tu turnarea a mea mini va lji aveam loatã cu amintatic. ");
INSERT INTO rup_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Trã atsea loats aishtui talentul shi dats-lu atsilui tsi ari dzatsi talentsã. ");
INSERT INTO rup_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Cã atsilui tsi ari va lji si artirseascã ma multã sh-va s-aibã multu. Ma atsilui tsi nu ari, va-lj si ljea sh-atsea tsi ari. ");
INSERT INTO rup_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Arcats-lu tu scutidlu di nafoarã aestu servitor arãu. Aclo va hibã plãngul sh-cãrtsãnirea a dintsãlor.’” ");
INSERT INTO rup_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Cãndu s-yinã Hiljiu a omlui tu mãrirea a lui, deadun cu tuts anghilji, atumtsea va s-apunã pri thronlu a mãririljei a lui. ");
INSERT INTO rup_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Sh-tuti natsiunili va s-adunã nãintea a lui, sh-elu va li dispartã unlu di alantu ashã cum disparti picurarlu oilili di cãprili. ");
INSERT INTO rup_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Sh-oili va li bagã nandreapta a lui sh-cãprili nastãnga. ");
INSERT INTO rup_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Atumtsea Amirãlu va l-dzãcã atsilor tsi va hibã nandreapta a lui: ‘Haidets ghinicuvãntats a Tatãlui a meu. Mushtinits-u amirãriljea tsi s-featsi etimu trã voi di la adrarea a lumiljei. ");
INSERT INTO rup_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Cã avui foami sh-nji deditã ti mãcari, avui seati sh-nji deditã ti beari, earam xen sh-mi preadunat, ");
INSERT INTO rup_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","earam dizviscut sh-mi nvisctut, earam lãndzit sh-voi mi vindicat, earam tu hapsi sh-vinitã la mini.’ ");
INSERT INTO rup_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Atumtsea ndreptsãlji va s-lji apãndiseascã: ‘Doamne, cãndu ti vidzum agiun sh-ti hrãnim, icã nsitat shi s-deadimã ti beari? ");
INSERT INTO rup_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Sh-cãndu ti vidzum xen sh-ti preadunãm, icã dizviscut sh-ti nviscum? ");
INSERT INTO rup_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Sh-cãndu ti vidzum lãndzit icã tu hapsi sh-vinimu la tini?’ ");
INSERT INTO rup_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Sh-Amirãlu apãndisi: ‘Dealihea ma vã dzãc: Di cãti ori lji-u-avets faptã aestã a vãrui di aeshti fratsi a melji ma njitsi, aestã nji-u fetsitu a njia.’ ");
INSERT INTO rup_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Deapoea elu va lã dzãcã sh-atsilor tsi va hibã nastãnga: ‘Dipãrtats-vã di mini, blãstimats, tu foc di totãna, etimãsit ti draclu sh-anghilji a lui. ");
INSERT INTO rup_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Cã aveam foami sh-nu nji deditã ti mãcari, avui seati sh-nu nji deditã ti beari, ");
INSERT INTO rup_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","earam xen shi nu mi preadunat, dizviscut shi nu mi nviscut, lãndzit sh-tu hapsi shi nu vinitã s-mi mutreat.’ ");
INSERT INTO rup_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Atumtsea elji va lji apãndiseascã: ‘Doamne, cãndu ti vidzum cu foami icã cu seati, icã xen, icã dizviscut, icã lãndzit, icã tu hapsi sh-nu ti agiutãm?’ ");
INSERT INTO rup_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Atumtsea elu va lã apãndiseascã: ‘Dealihea vã dzãc: Di cãti ori tsi nu lji-u avets faptã aestã a vãrui di aeshti ma njitsi, aestã nu nji-u avets faptã a njia.’ ");
INSERT INTO rup_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Sh-elji va s-ducã tu munduiri di totãna, ma ndreptsãlji va s-aibã bana eternã.” ");
INSERT INTO rup_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Cãndu Isusul bitisi tuti aesti zboari, lã dzãsi a ucenitsilor a lui: ");
INSERT INTO rup_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Voi shtits cã dupã doauã dzãli easti Pashtili, sh-deapoea Hiljiu a omlui va s-prida ti crutsisiri.” ");
INSERT INTO rup_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Atumtsea mãrilji a preftsãlor, sh-aushilji a popului s-adunarã tu uborlu a arhipreftului tsi s-acljima Caiafa. ");
INSERT INTO rup_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Sh-apofãsirã s-lu acãtsa Isusul cu tirtipi shi s-lu vatãmã, ");
INSERT INTO rup_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ma dzãtsea: “Nu tu sãrbãtoari, tsi s-nu s-facã vãrã mintiturã tu popul.” ");
INSERT INTO rup_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Cãndu Isusul eara tu Betania, tu casa al lebroslu Simon, ");
INSERT INTO rup_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","s-apriuche unã muljeari cu un vas di alabastru cu untulem di njir multu scumpã, shi lji-lu virsã pri caplu a lui, cãndu elu ma shidea andupirat la measã. ");
INSERT INTO rup_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Cãndu ucenitsilji a lui vidzurã aestã, s-nãrãirã shi ntribarã: “Cãtse tut aestu hãrgiuiri geaba? ");
INSERT INTO rup_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Aestu untulem, putea si s-vindea multã scumpu sh-pãradzili si s-dea a niavutsãlor.” ");
INSERT INTO rup_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ma Isusul lu achicãsi aestã sh-lã dzãsi a lor: “Cãtse u tulburatsã aestã muljeari? Ea featsi un lucru bun trã mini. ");
INSERT INTO rup_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Cã oarfãnjlji va li avetsi totãna cu voi, ma mini nu va mi avets totãna. ");
INSERT INTO rup_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Cã, virsãnda aestu untulem njirusit pri truplu a meu, ea lu ndreapsi truplu a meu trã ngrupari. ");
INSERT INTO rup_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Dealihea mini ma vã dzãc cã iutsido tsi va s-hibã predicat aestu evanghelu tu tutã lumea, va si aspunã cã tsi featsi aestã muljeari, trã amintirea a ljei.” ");
INSERT INTO rup_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Atumtsea un di atselji doisprãdzatsi, cu numa Iuda Iscariotul, s-dusi la mãrilji a preftsãlor, ");
INSERT INTO rup_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","sh-lã dzãsi a lor: “Cãti va nji dats tsi mini s-vã lu prida?” Sh-elji lj-misurarã treidzãtsi pãradzã, sicli di asimi. ");
INSERT INTO rup_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Sh-di atumtsea elu cãfta oara s-lu prida. ");
INSERT INTO rup_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Tu prota dzuã a Adzãmilor, ucenitsilji s-apruchearã a Isusului sh-lu ntribarã: “Iu vrei s-ndridzem trã mãcari Pashtili?” ");
INSERT INTO rup_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Sh-elu apãndisi: “Dutsets-vã tu cãsãbã la fileanlu sh-dzãtsets-lji: ‘Nvitsãtorlu dzãtsi: Chirolu a meu easti aproapi. Va s-facã Pashtili la casa a ta deadun cu ucenitsilji a melji.’” ");
INSERT INTO rup_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Atumtsea ucenitsilji featsirã ashã cum lã avea dimãndatã Isusul shi itimãsirã Pashtili. ");
INSERT INTO rup_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Sh-cãndu ntunicã, elu shidzu la measã deadun cu doisprãdzatslji. ");
INSERT INTO rup_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Cãndu ma mãca, dzãsi: “Dealihea mini ma vã dzãc, cã un di voi va mi prida.” ");
INSERT INTO rup_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Elji si nvirinarã multu sh-cathiun di nãshi ahurhi s-dzãcã: “Nacã escu mini, Doamne?” ");
INSERT INTO rup_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Sh-elu apãndisi: “Atsel tsi ari muljeatã deadun cu mini mãshcãtura tu cãtsãn, elu va mi prida. ");
INSERT INTO rup_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ashã cum easti scriatã trã nãsu, Hiljiu a omlui s-dutsi. Ma cavai di atsel om tsi prida Hiljiu a omlui! Trã nãsu va eara ma ghini s-nu eara amintat pute.” ");
INSERT INTO rup_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Sh-Iuda, atsel tsi va lu pridea, lu ntribã sh-lji dzãsi: “Rabbi, nacã escu mini atsel?” Elu lji dzãsi: “Tini ma dzãtsi!” ");
INSERT INTO rup_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Sh-iarã elji ma mãca, Isusul lo pãnea, u-ghinicuvãntã, u frãmsi, sh-u deadi a ucenitsilor a lui sh-dzãsi: “Loats shi mãcats, aestã easti truplu a meu.” ");
INSERT INTO rup_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Deapoea lo cupa, sh-hãrãstãsi, sh-u-deadi a lor dzãcãnda: “Bets di aestã tuts. ");
INSERT INTO rup_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Aestu easti sãndzili a meu a pistiligãturãljei, tsi easti virsatã trã multsã trã ljirtarea a amãrtiilor. ");
INSERT INTO rup_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Sh-mini ma vã dzãc, cã di tora sh-nclo mini nu va s-beau ma di aestu carpo a ayitãljei, pãnã tu atsea dzuã cãndu deadun cu voi, va s-beau di nou tu Amirãriljea a Tatãlui a meu.” ");
INSERT INTO rup_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Sh-dupã tsi cãntarã himnul, ishirã nafoarã la muntili a Masnjlilor. ");
INSERT INTO rup_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Atumtsea Isusul lã dzãsi a lor: “Aestã noapti tuts voi va s-mi apãrãsits, cã easti scriatã: ‘Va s-agudescu picurarlu sh-oili a cupiiljei va s-arãspãndeascã.’ ");
INSERT INTO rup_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ma dupã tsi s-hiu nyiatã, va mi duc nãinti di voi tu Galilea.” ");
INSERT INTO rup_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Atumtsea Petrul apãndisi: “Sh-canda tuts s-vã apãrãtseascã, mini nu va s-vã apãrãtsescu pute!” ");
INSERT INTO rup_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Isusul lj-dzãsi a lui: “Dealihea ma tsã dzãcã cã tu noaptea aestã, ma nãinti tsi s-cãntã cucotlu, tini va mi aleapidz di trei ori.” ");
INSERT INTO rup_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petrul lji dzãsi: “Sh-ca s-prindi s-mor cu tini, nu va ti aleapid pute.” Ashã dzãsirã sh-tuts ucenitsilji. ");
INSERT INTO rup_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Atumtsea Isusul s-dusi deadun cu nãshi tu un loc, tsi s-acljima Ghetsemani, sh-lã dzãsi a ucenitsilor: “Shidets aoa, iarã mini ma mi duc aclo s-mi pãrãcãlsescu.” ");
INSERT INTO rup_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Sh-lo cu nãsu Petrul sh-doi hiljilji al Zevedeu, sh-apãrnji si nvirineadzã shi s-aibã mari sicleti. ");
INSERT INTO rup_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Atumtsea elu lã dzãsi a lor: “Suflitlu a meu easti multu nvirinat, pãnã tu moarti. Armãnets aoa shi stats dishtiptat deadun cu mini.” ");
INSERT INTO rup_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Sh-cum s-dusi niheam ma nãinti, cãdzu cu fatsa pri loc shi s-pãrãcãlsi dzãcãnda: “Tatãl a meu, macã easti putut, dipãrteadz-u di la mini aestã cupã, cu tutã atsea, nu cum voi mini, ma cum vrei tini.” ");
INSERT INTO rup_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Deapoea s-turnã la ucenitsilji shi lji aflã durnjinda, sh-lji dzãsi al Petru: “Ma cum, nu putut s-vigljeats cu mini macari unã oarã? ");
INSERT INTO rup_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Stats dishtiptat sh-pãrãcãlsits-vã, s-nu cãdets tu cãrtiri, cã duhlu easti etimu, ma truplu easti niputut.” ");
INSERT INTO rup_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","S-dusi a doaua oarã shi s-pãrãcãlsi dzãcãnda: “Tatãl a meu, macã nu easti putut tsi aestã cupã s-fugã di la mini fãrã si s-bea di mini, si s-facã vrearea a ta!” ");
INSERT INTO rup_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Deapoea s-turnã sh-lji aflã nãpoi tsi durnjea, cã ocljilji a lor eara somnusiti. ");
INSERT INTO rup_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Sh-dupã tsi lã alãsã, s-dusi nãpoi shi s-pãrãcãlsi di-a treia oarã, dzãcãnda idyili zboari. ");
INSERT INTO rup_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Deapoea s-turnã la ucenitsilji a lui sh-lã dzãsi a lor: “Tora ninga durnjits sh-vã discurmats? Ia vini oara, sh-Hiljilu a omlui va s-prida tu mãnjilji a amãrtioshilor. ");
INSERT INTO rup_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Sculats-vã, s-nidzem. Ia, atsel tsi ma mi prida easti aproapi.” ");
INSERT INTO rup_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Sh-iarã Isusul ma grea, ia Iuda, un di doisprãdzatslji, vini sh-deadun cu nãsu unã multsãmi mar cu spãtsi sh-cu ciumãdzi, pitricuts di mãrilji a preftsãlor sh-di aushilji a popului. ");
INSERT INTO rup_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Tora atsel tsi lu pridea lã avea datã a lor un semnu, dzãcãnda: “Atsel tsi mini va l-bashu, elu easti, acãtsats-lu.” ");
INSERT INTO rup_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Shi trãoarã s-apruche la Isusul sh-lji dzãsi: “Salut, Nvitsãtore!”, sh-lu bãshe. ");
INSERT INTO rup_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Isusul lji dzãsi: “Oaspe, tsi ai tu minti s-fats?” Atumtsea elji s-apruchearã, bãgarã mãnjili pri Isusul sh-lu acãtsarã. ");
INSERT INTO rup_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Shi ia, un di atselji tsi eara cu Isusul, timsi mãna, scoasi spata a lui, agudi huzmichearlu a arhipreftului sh-lji tãlje ureacljea. ");
INSERT INTO rup_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Atumtsea Isusul lji dzãsi: “Toarnã spata tu loclu a ljei, cã tuts atselji tsi ljea spata, di spata va moarã. ");
INSERT INTO rup_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Minduits voi, cã mini nu pot s-mi pãrãcãlsescu a Tatãlui a meu, dinãoarã s-nji pitreacã ma multã di doisprãdzats di legiunji di anghilji? ");
INSERT INTO rup_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ma atumtsea cum va s-mplineascã Scriturili, cã dupã eali ashã prindi s-facã?” ");
INSERT INTO rup_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Tu atsea oarã Isusul lã dzãsi a multsãnjilor: “Voi ishit s-mi acãtsats mini cu spãtsi sh-cu ciumãdzi, ca un fur. Ia, cathi dzuã shideam cu voi nvitsãnda tu templu, sh-voi nu mi acãtsat. ");
INSERT INTO rup_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ma tuti aesti s-featsirã tsi si mplineascã Scriturili a prufitsilor.” Atumtsea tuts ucenitsilji lu alãsarã sh-fudzirã. ");
INSERT INTO rup_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Sh-atselji tsi lu avea acãtsatã Isusul, lu dusirã la Caiafa, arhipreftulu iu eara adunatã scriblji sh-aushlji. ");
INSERT INTO rup_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Sh-Petrul lu urmã di diparti pãnã tu uborlu a arhipreftului, shi-dupã tsi intrã atsia, s-apunã deadun cu vigljitorlji s-veadã tsi va s-undzeascã. ");
INSERT INTO rup_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Tora mãrilji a preftsãlor, sh-tut sinedriul cãfta vãrã mãrtirii arãdioasã contra al Isus, ti vãtãmari, ");
INSERT INTO rup_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ma nu aflarã tsiva, cu tutã cã vinirã multsã martiri arãdioshi. Ma napoi vinirã doi altsã martiri arãdioshi, ");
INSERT INTO rup_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","tsi dzãsirã: “Aestu ari dzãsã: ‘Mini pot s-aspargu templul a Dumnidzãlui shi s-lu adar ti trei dzãli.’” ");
INSERT INTO rup_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Atumtsea arhipreftul si s-culã sh-lji dzãsi: “Nu ma apãndiseshti dip ti atseali tsi ma mãrtirsescu aeshti contra tini?” ");
INSERT INTO rup_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Iarã Isusul tãtsea. Sh-arhipreftul grãi: “Mini ma ti spigiuru pri Dumnidzãlu atsel yiulu s-nã dzãtsi macã tini eshti Hristolu, Hiljiu a Dumnidzãlui.” ");
INSERT INTO rup_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Isusul lji dzãsi: “Tini ma dzãtsi! Sh-mini ma vã dzãc cã di tora sh-ma nclo voi va lu videts Hiljiu a omlui tsi sheadi di nandreapta a Puteariljei, sh-yininda pri niorilji a tserlui.” ");
INSERT INTO rup_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Atumtsea arhipreftul arupsi stranjili a lui, dzãcãnda: “Elu blãstimã! Trã tsi nã lipsescu tora martirilji? Ia, tora lu avdzãtã blãstemlu a lui. ");
INSERT INTO rup_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Cum vã si pari a voaua?” Sh-elji apãndisirã: “Elu easti cãbatar trã moarti!” ");
INSERT INTO rup_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Atumtsea lu scuchearã pri fatsã, lu agudirã cu shupleacã, shi niscãntsã altsã lji-l-deadirã cu bushlu, ");
INSERT INTO rup_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","dzãcãnda: “Hristose, prufitipsea! Cai ti agudi?” ");
INSERT INTO rup_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Iarã Petrul shidea nafoarã, tu ubor unã huzmichearã s-apruche dzãcãnda: “Sh-tini earai cu Isus Galileanlu.” ");
INSERT INTO rup_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ma elu lu alipidã nãinte a tutulor dzãcãnda: “Nu shtiu tsi dzãtsi!” ");
INSERT INTO rup_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Sh-cãndu elu ma ishea la poartã, vidzu unã altã huzmichearã sh-lã dzãsi atsilor tsi eara aclo: “Sh-aestu eara cu Isus Nazareanlu!” ");
INSERT INTO rup_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ma Petrul lu alipidã nãpoi spigiurãnda: “Mini nu lu cunoscu atsel om.” ");
INSERT INTO rup_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Dupã putsãn s-apruchearã sh-atselji tsi shidea aclo, sh-lji dzãsirã a Petrului: “Dealihea, sh-tini eshti un di atselji, cã grailu a tãu ti spuni!” ");
INSERT INTO rup_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Atumtsea elu ahurhi s-blastimã shi si spigiurã, dzãcãnda: “Mini nu lu cunoscu atsel om!” Sh-tu oara atsea cãntã cucotlu. ");
INSERT INTO rup_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Atumtsea Petrul adusi aminti atsea tsi lji avea dzãsã Isusul: “Ma nãinti tsi s-cãntã cucotlu, va s-mi aleapidz di trei ori.” Shi elu ishi afoarã sh-plãmsi cu amãreatsã. ");
INSERT INTO rup_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Cãndu vini dimineatsa, tuts mãrilji a preftsãlor sh-aushlji a popului featsirã plan contra al Isus tsi s-lu vãtãma. ");
INSERT INTO rup_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Sh-ashã cum lu ligarã, lu dusirã sh-lu pridarã la Pilat, guvernatorlu romac. ");
INSERT INTO rup_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Atumtsea, Iuda tsi lu avea pridatã, cãndu lu vidzu cã lu giudicarã Isusul, s-pishmãnipsi, sh-lji turnã nãpoi tredzãtsi di asimi la mãrilji a pretsãlor sh-la aushlji, ");
INSERT INTO rup_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","dzãcãnda: “Feciu amãrtii cã vindui un sãndzi fãrã cãbati.” Ma elji dzãsirã: “Tsi nã mealã a noauã? Lucru ti tini!” ");
INSERT INTO rup_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Sh-ashã Iuda, l-arcã pãradzli di asimi la templu, shi s-dusi si aspindzura. ");
INSERT INTO rup_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ma mãrilji a preftsãlor adunarã aesti pãradzi di asimi sh-dzãsirã: “Nu prindi s-lji bãgãm tu ayishtearea a tempului, cã easti pãhãlu a sãndzilui.” ");
INSERT INTO rup_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Dupã tsi featsirã plan, cu aesti pãradzi acumpãrarã agrulu a pociarlui di murminsãli a xenjilor. ");
INSERT INTO rup_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Trã atsea agrulu aestu s-acljeami pãnã tu dzua di azã: “Agrulu a sãndzilui.” ");
INSERT INTO rup_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Atumtsea si mplini atsea tsi fu dzãsã pri prufitlu Ieremia: “Sh-loarã di treidzãtsi pãradzili di asimi, pãhãlu tsi lu avea tinjisitã hiljilji al Israel, ");
INSERT INTO rup_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","sh-li deadirã trã agrul a pociarului ashã cum mi dimãndã Domnul.” ");
INSERT INTO rup_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Sh-Isusul stãtu nãintea a guvernatorului sh-elu lu ntribã: “Tini eshti amirãlu a Iudeilor?” Sh-Isusul lji dzãsi: “Tini ma dzãts.” ");
INSERT INTO rup_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Deapoea mãrilji a preftsãlor sh-aushlji lu acuzarã, ma elu nu apãndisi dip. ");
INSERT INTO rup_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Atumtsea Pilatul lu-ntribã: “Nu avdzã cãti mãrtirii s-dzãc contra tini?” ");
INSERT INTO rup_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ma elu nu apãndisi la nitsi un zbor, ashãtsi guvernatorlu s-ciudisi multu. ");
INSERT INTO rup_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Tora cu sibepea a sãrbãtoariljei guvernatorlu lu avea ca adeti tsi s-lji sãlãghea a popului un hãpsãnit, atsel tsi vrea populu. ");
INSERT INTO rup_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Avea atumtsea tu hapsi, un hãpsãnit cu anami, cu numa Baraba. ");
INSERT INTO rup_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Cãndu s-adunarã oaminjili, Pilatul lã ntribã atselji: “Cai vrets s-vã sãlãghescu, Baraba, icã Isusul, tsi s-numeashti Hristos?” ");
INSERT INTO rup_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Cã elu lu shtia ghini cã elji lu avea pridatã di inati. ");
INSERT INTO rup_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Sh-iarã elu shidea pri scamnu la giudicatã, muljearea a lui lj-pitricu zbor: “Nu ti mintea dip cu lucrul atsilui ndreptulu, cã azã am traptã multã tu yis trã itia a lui.” ");
INSERT INTO rup_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ma mãrilji a preftsãlor sh-aushlji lji umplurã mintea a multsãmiljei tsi s-cãfta Baraba, sh-Isusul si s-vãtãma. ");
INSERT INTO rup_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Sh-guvernatorlu lã ntribã: “Cai di doilji vrets s-vã sãlãghescu?” Elji dzãsira: “Baraba!” ");
INSERT INTO rup_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatlu lã dzãsi a lor: “Tsi s-fac, cu Isusul, tsi s-acljeami Hristos?” Tuts lji apãndisirã: “S-crutsiseascã!” ");
INSERT INTO rup_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ma guvernatorlu ntribã: “Cãtse, tsi arãu ari faptã?” Ma elji aurla ma multu: “S-crutsiseascã!” ");
INSERT INTO rup_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Atumtsea Pilatul, vidzãnda cã nu ma agiundzea iuva, sh-aurlarea ma s-fãtsea ma vãrtoasã, lo apã sh-aspilã mãnjili nãintea a lor, dzãcãnda: “Mini escu ni-vinovat di sãndzili a aishtui ndreptu, easti lucrul a vostru.” ");
INSERT INTO rup_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Sh-tut populu apãndisinda dzãsi: “S-hibã sãndzili a lui pristi noi sh-pristi cilimenjilji a noshtri!” ");
INSERT INTO rup_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Atumtsea elu lã sãlãghi a-lor Baraba. Dupã tsi Isusul lu bãturã, lu prideadi tsi s-lu crutsisea. ");
INSERT INTO rup_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Atumtsea suldatslji a guvernatorlui, dupã tsi dusirã Isusul tu pretorium, adunarã ningã nãsu tutã cohorta. ");
INSERT INTO rup_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Sh-cum lu disviscurã, lji arcarã pri plãtari unã mantilã roshi amirãrescu. ");
INSERT INTO rup_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Sh-lji mplãtirã unã curunã di schinji, lji-u bãgarã pri cap, sh-lji deadirã un bastun tu mãna atsea ndreapta sh-dzinucljinda nãintea a lui, arãdea dzãcãnda: “Salut, amirãlu a Iudeilor!” ");
INSERT INTO rup_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Deapoea lu ascuchiarã, lji loarã bastunlu sh-cu atsel lu agudea n-capã. ");
INSERT INTO rup_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Dupã tsi lu pizuirã, lji-lu mutarã mantelul shlu nviscurã cu stranjili a lui, sh-lu dusirã ti crutsisiri. ");
INSERT INTO rup_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Sh-cara ishirã afoarã, aflarã un om dit Cirenea, tsi s-acljima Simon, sh-lu strimsirã s-purta crutsea al Isus. ");
INSERT INTO rup_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Cãndu agiumsirã tu loclu tsi s-acljima Golgota, tsi va s-dzãcã “Loclu a Cafcãljei”, ");
INSERT INTO rup_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","lji deadirã s-bea yinã puscã misticat cu heari. Ma elu, dupã tsi u bãgã tu gurã, nu vrea s-u bea. ");
INSERT INTO rup_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Dupã tsi lu crutsisirã, mpãrtsãrã cu soarti stranjili a lui, tra si mplineascã tsi eara dzãsã di la prufitlu: “Mpãrtsãrã namisa di nãshi stranjili a meali sh-arcarã soarti di tunica a mea.” ");
INSERT INTO rup_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Deapoea shidzurã sh-lu vigljea. ");
INSERT INTO rup_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Pristi caplu a lui, bãgarã tutashã scriatã acuza ti giudicarea a lui: “Aestu easti Isusul, Amirãlu a Iudeilor.” ");
INSERT INTO rup_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Atumtsea s-crutsisirã deadun cu nãsu sh-doi ribelji, unlu tu nandreaptea sh-alantu tu nastãnga. ");
INSERT INTO rup_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Sh-atselji tsi tritsea cãtrã aclo, lu ngiura giucãnda caplu, ");
INSERT INTO rup_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","sh-dzãcãnda: “Tini tsi lu aspardzã templul sh-lu adarã trã trei dzãli, ascapã-ti! Macã eshti Hiljiu a Dumnidzãlui, dipunã-ti di crutsi!” ");
INSERT INTO rup_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Tutashã, sh-mãrilji a preftsãlor, deadun cu scriblji sh-cu aushlji, s-pizuea sh-dzãtsea: ");
INSERT INTO rup_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Elu ascãpã altsã, ma tora nu poati si s-ascapã. Macã easti amirãlu a Israelui, s-dipunã tora di crutsi sh-noi va pistipsim la nãsu. ");
INSERT INTO rup_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Elu ari pistipsitã tu Dumnidzã, sh-macã elu lu va s-lu ascapã tora, cã ari dzãsã: ‘Mini escu Hiljiu a Dumnidzãlui.’” ");
INSERT INTO rup_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Tutashã, lu ngiura sh-ribeljilji tsi eara crutsisitã cu nãsu. ");
INSERT INTO rup_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Di tu njeadzãdzuã pãnã la oara trei ti mirindi scutidu amvãli tut loclu. ");
INSERT INTO rup_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Anvãrliga di oara trei dupã prãndzu, Isusul aurlã cu boatsi analtã, dzãcãnda: “Eli, Eli, lema sabachthani?”, tsi va s-dzãcã: “Dumnidzãlu a meu, Dumnidzãlu a meu, cãtse mi ai alãsatã?” ");
INSERT INTO rup_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Sh-niscãntsã di atselji tsi shidea aclo, cãndu lu avdzrã, dzãsirã: “Aestu ma lji greashti al Ilia.” ");
INSERT INTO rup_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Sh-tu atsea oarã, un di atseji s-dusi dalaga, lo un sfungu, lu mulje tu yin acrã shi, dupã tsi lu bãgã tu mãeaua di un cãlami, lji deadi s-bea. ");
INSERT INTO rup_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ma alantsã dzãtsea: “Alãsats-lu s-videm va s-yinã Ilia s-lu ascapã.” ");
INSERT INTO rup_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Sh-Isusul aurlã ninga unã oarã cu boatsi analtã, sh-deadi suflitlu. ");
INSERT INTO rup_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Sh-ia, velul a tempului s-arupsi pi doauã pãrtsã di nsus pãnã nghios, loclu cutremburã shi shcãnghili s-disicarã, ");
INSERT INTO rup_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","murmintsãlji s-disfeatsirã, sh-multi trupuri a sãmtsãlor tsi avea murit, s-nyearã. ");
INSERT INTO rup_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Elji ishirã dit murmintsã dupã nyearea a Isusului, intrarã tu sãmtul cãsãbã shi s-aspusirã la multsã. ");
INSERT INTO rup_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Tora centurionlu sh-atselji tsi deadun cu nãsu vigljea Isusul, cãndu vidzurã cutremburarea sh-atseali tsi s-featsirã, s-aspãrarã multu, sh-dzãsirã: “Dealihea aestu eara Hiljiu a Dumnidzãlui!” ");
INSERT INTO rup_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Aclo era sh-multi muljeri tsi mutrea di diparti. Eali avea urmatã Isusul di Galilea tsi s-lji huzmitipsea. ");
INSERT INTO rup_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Namisa di nãsi eara Maria Magdalena, Maria, muma al Iacov sh-al Iosif, sh-muma a hiljilor al Zevedeu. ");
INSERT INTO rup_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Sh-cum ntunicã, vini un om avut di Arimatea, cu numa Iosif, cai eara sh-nãsu uceniclu al Isus. ");
INSERT INTO rup_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Elu s-dusi la Pilatul sh-lji cãftã truplu al Isus. Atumtsea Pilatul deadi ordin tsi s-lj dãdea truplu. ");
INSERT INTO rup_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Sh-Iosiful, dupã tsi lu lo truplu lu anvãrti cu unã pãndzã curatã ");
INSERT INTO rup_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","sh-lu bãgã tu murmintul atsel noulu, tsi elu avea disfaptã tu un cheatrã. Deapoea arucuti unã cheatrã mari tu intrata a murmintului, sh-fudzi. ");
INSERT INTO rup_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Sh-Maria Magdalena sh-alantã Marii shidea aclo, nãintea a murmintului. ");
INSERT INTO rup_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Sh-tu alantã dzuã, tsi eara dupã dzua a adãrarãljei, mãrilji a preftsãlor sh-Fariseilji s-adunarã la Pilatul, ");
INSERT INTO rup_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","dzãcãnda: “Doamne, nã adusim a minti cã atsel arãditor, cãndu eara yiu, dzãsi: ‘Dupã trei dzãli mini va mi nyedz.’ ");
INSERT INTO rup_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Trã atsea dã ordin tsi murmintul si s-veaglji ghini pãnã tu dzua a treia, s-nu yinã ucenitsilji a lui noaptea shi s-lu furã truplu sh-deapoea s-lji dzãcã a popului: ‘Si-sculã dit mortsã,’ sh-ashã arãdearea di ma napoea, va s-eara ma arãu di atsea di ma nãinti.” ");
INSERT INTO rup_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatul lji dzãsi a lor: “Vigljitorlu lu avets, dutsets-vã shi siguripsits-lu, cum s-vã si veadi ma ghini.” ");
INSERT INTO rup_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Sh-elji s-dusirã sh-lu siguripsirã murmintul, bãgarã vigljitorlu sh-vulusirã cheatra. ");
INSERT INTO rup_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Tora tu bitisita a Sãmbãtãljei, cãndu ma apirea prota dzuã a sãptãmãniljei, Maria Magdalena sh-alantã Marii s-dusirã s-videa murmintul. ");
INSERT INTO rup_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Sh-ia s-featsi un mari cutrembur, sh-un anghil a Domnului dipusi dit tser, vini sh-arucuti cheatra di la intrata a murmintului shi shidzu pri nãsã. ");
INSERT INTO rup_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Videarea a lui eara ca ascãpirarea sh-nvishtearea a lui albã ca neaua. ");
INSERT INTO rup_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Sh-di frica a lui, vigljitorlji trimurarã sh-armasirã ca mortsã, ");
INSERT INTO rup_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ma anghilu lã dzãsi a muljerilor: “S-nu avets fricã, cã mini shtiu cã voi cãftats Isusul, tsi s-crutsisi. ");
INSERT INTO rup_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Elu nu easti aoa, cã s-nyie, dupã cum vã avea dzãsã. Yinitsã, videts loclu iu eara bãgatã Domnul. ");
INSERT INTO rup_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Dutsets-vã trãoarã sh-dzãtsets a ucenitsilor a lui cã elu s-nyie dit mortsã. Sh-ia, ma neadzi nãintea a voastrã tu Galilea. Aclo va lu videts. Ia, vã-u aspush.” ");
INSERT INTO rup_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Eali, s-dipãrtarã trãoarã di la murmintul cu fricã sh-cu harauã marii, shi s-dusirã trãoarã s-dutsea hãbarea la ucenitsilji a lui. ");
INSERT INTO rup_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Niashtiptat Isusul lã ishi nãinti sh-lã dzãsi: “Sãnãtati!” Atumtsea eali s-apruchearã, lji acãtsarã cicioarili, shi si ncljinarã. ");
INSERT INTO rup_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Atumtsea Isusul lã dzãsi a lor: “S-nu avets fricã, dutsets-vã dzãtsets a fratsãlor a melji tsi s-ducã tu Galilea sh-aclo va s-mi veadã.” ");
INSERT INTO rup_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Dupã tsi elji ma s-dutsea, niscãntsã di vigljitorlji, agiumsirã tu cãsãbã sh-dzãsirã la mãrilji a preftsãlor tuti atseali tsi eara faptã. ");
INSERT INTO rup_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Atumtsea aeshti featsirã plan cu aushlji sh-apofãsirã s-lã da a suldatsilor multsã pãradzi, ");
INSERT INTO rup_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","dzãcãnda a lor: “Dzãtsets: ‘Ucenitsilji a lui vinirã noaptea sh-lu furarã truplu, cãndu noi durnjeam.’ ");
INSERT INTO rup_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Sh-macã aestã va lu avdã guvernatorlu, noi va lu cãndãrsim atsel, sh-va lu fãtsem tsi voi s-nu avets mirachi.” ");
INSERT INTO rup_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Sh-elji loarã pãradzli sh-featsirã ashã cum lji nvitsarã, sh-aestu zbor s-arãspãndi la Iudeilji pãnã tu dzua di azã. ");
INSERT INTO rup_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Deapoea di unsprãdzatsi di ucenjitsilji s-dusirã tu Galilea, tu muntili atsel iu avea dimãndatã Isusul, ");
INSERT INTO rup_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","sh-cãndu lu vidzurã, si ncljinarã, ma niscãntsã si ndoljirã. ");
INSERT INTO rup_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Deapoea Isusul s-apruche, sh-lã dzãsi a lor: “A njia nji si easti datã cathi puteari tu tser sh-pri loc. ");
INSERT INTO rup_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Dutsets-vã sh-nvitsats ucenitsi di tuti fãrili, pãtidzãnda tu numa a Tatãlui, sh-a Hiljiui sh-a Sãmtului Duh, ");
INSERT INTO rup_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","shi s-nveatsã s-facã tuti aesti tsi mini am dimãndatã. Sh-ia, mini escu cu voi tuti dzãlili, pãnã tu bitisita a etiljei.”");
INSERT INTO rup_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ahurhirea a Evanghelului al Isus Hristos, Hiljilu al Dumnidzãu. ");
INSERT INTO rup_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ashã cum easti scriatã la prufitlu Isaia: “Ia, mini Dumnidzãlu ma pitrec mandatorlu a meu dininti a fatsãljei a ta, tsi va s-ndreagã calea a ta dininti a ta, ");
INSERT INTO rup_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","boatsea atsilui tsi aurlã tu irnjii: ‘Ndridzets-lu calea a Domnului, ndreptatsã cãljurili a lui!’” ");
INSERT INTO rup_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ioanul vini tu irnjii ti pãtidzari, predicãnda un pãtidzari trã mitãnjusirea a amãrtiilor tsi Dumnidzãlu s-li ljeartã. ");
INSERT INTO rup_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Sh-tut loclu al Iudei sh-atselji di Ierusalem nidzea la elu shi s-pãtidza tuts di la nãsu la rãulu Iordan spunãnda amãrtiili a lor. ");
INSERT INTO rup_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ma Ioanul eara nviscut cu stranji di lãnã ali gãmili, tsãnea un curauã di cheali avãrliga di ilji shi mãca carcalets sh-njeari agrã. ");
INSERT INTO rup_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Elu ma predica dzãcãnda: “Dupã mini yini un tsi easti ma vãrtos di mini. Mini nu escu axiu nits s-mi apunã dininti a lui ti dizligari ligãtura a-sandalilor a lui. ");
INSERT INTO rup_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mini vã pãtidzai cu apã, ma elu va vã pãtidzeascã cu Duhlu Sãmtu.” ");
INSERT INTO rup_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Sh-tu atseali dzãli undzi tsi Isusul vini di la Nazaretul a Galileiljei shi s-pãtidzã di la Ioanul tu Iordan. ");
INSERT INTO rup_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Shi dinãoarã cãndu ma insha di apã, vidzu cã tserurili ma s-discljidea shi Duhlu ma dipuna pri nãsu ca purumbu. ");
INSERT INTO rup_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Sh-unã boatsi vini dit tseruri: “Tini eshti Hiljilu a meu vrutu cu cai escu hãrsit.” ");
INSERT INTO rup_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Sh-dinãoarã Duhlu Sãmtu lu-adusi tu irnjii. ");
INSERT INTO rup_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Elu armasi tu irnjii patrudzãtsi di dzãli, bãgati tu cãrteari di Satanlu. Sh-eara deadun cu agrimilji, shi anghilji l-huzmitipsea. ");
INSERT INTO rup_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Shi dupã tsi Ioanul u hãpsãnirã, Isus vini tu Galilei predicãnda evanghelul al Dumnidzãu. ");
INSERT INTO rup_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Sh-dzãcãnda: “Agiumsi chirolu shi s-apruche amirãriljea al Dumnidzãu. Mitãnjusits-vã sh-pistipsits evanghelul.” ");
INSERT INTO rup_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Trãcãnda pri ninga amarea a Galileiljei, vidzu Simonlu sh-Andrea, fratili a lui, arcãnda plãsile tu amari cã eara piscãrii. ");
INSERT INTO rup_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Shi Isus lã dzãsi a lor: “Urmatsmã shi mini va vã facã piscãrii a oamnjilor.” ");
INSERT INTO rup_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Sh-trãoarã atselji alãsarã plãsili shi s-dusirã dupã nãsu. ");
INSERT INTO rup_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Dupã tsi imnã ninga niheam, vidzu Iacovul, hiljilu al Zebedeu shi Ioan, fratili a lui tsi mpitica plãsili a lor tu varcã. ");
INSERT INTO rup_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Sh-trãoarã li-achljimã shi elji lu-alãsarã tatilu a lor, Zevedeul tu varcã cu lucrutorlji, shi s-dusirã dupã nãsu. ");
INSERT INTO rup_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Deapoea intrarã tu Capernaum shi dzua di Sãmbãtã trãoarã intrarã tu sinagogã shi nvitsa oaminjilji. ");
INSERT INTO rup_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Sh-oaminjilji s-ciudisirã di nvitsãtura-a lui, cã elu lji nvitsa ca un tsi ari puteari sh-nu ca scriblji. ");
INSERT INTO rup_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Atumtsea tu sinagoga-a lor eara un om putut cu un duh nicurat, tsi ahurhi s-aurlã, ");
INSERT INTO rup_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","dzãcãnda: “Tsi ari namisa di noi sh-di voi, Isus di Nazaret? Vinish tsi s-nã cherdzi? Mini lu shtiu cai eshti: Sãmtulu al Dumnidzãu.” ");
INSERT INTO rup_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Shi Isusul lu ursi dzãcãnda: “Tats sh-eshi di la elu.” ");
INSERT INTO rup_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Shi duhlu nicurat, dupã tsi lu ascuturã, aurlã cu mari sh-ishi di la nãsu. ");
INSERT INTO rup_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Sh-tuts s-ciudisirã ahtãt multu cãt ntriba un-alantu dzãcãnda: Vahi tsi easti atsea? Tsi nvitsiturã noauã easti atsea? Aestu lji urseashti cu puteari shi duhurili nicurati shi elji lu ascultã. ");
INSERT INTO rup_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Shi anamea a lui s-avdzã dinãoarã pri tutã loclu avãrliga a Galileiljei. ");
INSERT INTO rup_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Cum ishirã elji dit sinagogã, s-dusirã la casa al Simon shi al Andrei, cu Iacovul sh-cu Ioanul. ");
INSERT INTO rup_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Soacra al Simon eara bãgatã cu heavrã, shi dinãoarã elji lji-spusirã ti nãsã. ");
INSERT INTO rup_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Atumtsea elu s-apruche, lu-acãtsã di mãnã shi-u sculã. Trãoarã hevrili u-alãsarã shi ea ahurhi s-lã huzmitipseascã. ");
INSERT INTO rup_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Seara dupã ascãpitarea a-soarilui, lji adusirã tuts lãndzitslji shi dracuitslji. ");
INSERT INTO rup_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Sh-tutã cãsãbãlu eara adunat nãinti ali ushi. ");
INSERT INTO rup_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Elu vindicã mults di atselji tsi s-munduia di multi soi ti lãngoari, shi aĝiuni multsã dratsi, sh-nu alãsã dratsilji s-greascã, cã elji lu-cunushtea. ");
INSERT INTO rup_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Deapoea, dimineatsa curund cãndu ninga nu avea apirit, Isusul si-sculã, ishi shi s-dusi tu un loc ermu shi aclo s-pãrãcãlsii. ");
INSERT INTO rup_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Shi Simonlu sh-atselji tsi eara cu nãsu, lu-cãfta. ");
INSERT INTO rup_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Shi cãndu lu aflarã lji-dzãsirã: “Tuts ma ti caftã.” ");
INSERT INTO rup_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Shi elu lã dzãsi a lor: “Hai s-nidzem tu hoarili di aproapi tsi s-preadicã shi-aclo, cã ti aestã am vinitã.” ");
INSERT INTO rup_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Shi elu tricu tutã Galilea predicãnda pri sinagogãli-a lor shi aĝunea dratsilji. ");
INSERT INTO rup_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Shi vini la elu un lepros, tsi pãrãcãlsãnda lj-cãdzu pi dzinuclji sh-lji dzãsi: “Ma s-vrei tini, pots s-mi curi.” ");
INSERT INTO rup_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Shi Isusul sãmtsãnda njilã, lu timsi mãna pri nãsu sh-lji dzãsi: “Ie, voi, s-hii curat!” ");
INSERT INTO rup_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Macãt dzãsi aesti, dinãoarã lepra lu-alãsã shi s-vindicã. ");
INSERT INTO rup_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Deapoea, dupã tsi lu-ursi, trãoarã lu dipãrtã, ");
INSERT INTO rup_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","dzãcãnda: “Vedz s-nu lji spunji tsiva-a vãrui, ma imnã la preftu, shi dã tsiva trã curarea-a ta, cum easti ursit tu legile a Moisiului, ca mãrtirii trã nãshi.” ");
INSERT INTO rup_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ma elu, ishinda, apãrnji s-greascã shi sã scurpiseascã la mults faptulu, ahtãt multu cãt Isusul nu putea s-intra discljis tu cãsãbã, ma stãtea nafoarã pri locuri ermi. Sh-di tuti pãrtsili yinea la nãsu. ");
INSERT INTO rup_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Dupã ndoauã dzãli, Isus vini nãpoi tu Capernaum shi s-avdzã cã elu eara la casã. ");
INSERT INTO rup_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Dinãoarã s-adunarã ahãnts mults oaminji cãt nu aflai loc nitsi dininti ali poarti. Sh-elu lã nvitsa zborlu. ");
INSERT INTO rup_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Atumtsea vinirã niscãntsi, tsi adusirã un om paralizat tsi lu-purta patru ishi. ");
INSERT INTO rup_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ma niputãnda s-apruchia ti itia a multsãmiljei, dizvãlirã plocili a citiiljei iu eara Isusul, shi dupã tsi disfeatsirã unã guvã lu-dipusirã patlu pi cai stãtea paralizatlu. ");
INSERT INTO rup_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Isusul vidzãnda pistea a lor lji-dzãsi a paralizatlui: “Hilje, amãrtiili a tali sãntu ljirtati!” ");
INSERT INTO rup_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ma atsia shidea niscãntsã scribi tsi tu ininjli a lor minduia: ");
INSERT INTO rup_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Cãtse vahi aestu ma blastimã? Cai poati s-ljeartã amãrtiili, singur di Dumnidzãlu?” ");
INSERT INTO rup_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ma Isusul tsi trãoarã aduchi tu suflitlu a lui cã elji ma minduia aesti lucri cu mintea-a lor, lã dzãsi: “Cãtse li minduits aesti lucri tu ininjli a voastri? ");
INSERT INTO rup_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Tsi easti ma lishor s-lji dzãtsã a paralizatlui: ‘Amãrtiili a tali sãntu ljirtati’, ama s-lji dzãtsã: ‘Scoalã-ti, ljea patlu a tãu sh-imnã!’? ");
INSERT INTO rup_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ma tra si-shtits cã Hiljilu-a omlui ari puteari s-ljeartã amãrtiili pri loc, ");
INSERT INTO rup_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","mini ma ts-dzãcã: ‘Scoalã-ti, ljea patlu shi imnã la casa a ta!’” ");
INSERT INTO rup_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Shi elu si sculã dinãoarã, lo patlu a lui, shi ishi afoarã dininti a tutslor, shi ashã tuts s-ciudisirã shi alãvdarã Dumnidzãlu dzãcãnda: “Unã ahtari thavmã nu u-avem vidzut pute!” ");
INSERT INTO rup_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Isus ishi nãpoi mardzina di amari shi multsãmea yinea la nãsu shi elu lã-nvitsa. ");
INSERT INTO rup_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Trãcãnda vidzu Levilu, hiljilu al Alfeu apunat iu s-pãltea taxa, sh-lji dzãsi: “Urmeadz-mi!” Sh-elu si sculã shi s-dusi dupã nãsu. ");
INSERT INTO rup_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Sh-ma nãpoi cãndu Isusul eara la measã la casa a Levilui, multsã taxidãri sh-amãrtioshi shãdea la measã cu Isusul sh-cu ucenitsilji a lui, cã eara multsã atselji tsi nidzea dupã nãsu. ");
INSERT INTO rup_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Atumtsea scriblji shi Fariseilji, cãndu vidzurã cã ma mãca deadun cu taxidãrlji shi amãrtioshlji, lã-dzãsirã a ucenitsilor a lui: “Cum mãcã sh-bea elu deadun cu taxidãrlji shi amãrtioshlji?” ");
INSERT INTO rup_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Sh-Isusul cãndu li avdzã, lã-dzãsi a lor: “Nu sãntu sãnãtoshlji tsi au ananghi ti iatrulu, ma lãndzitslji. Mini nu vinj s-acljemã ndreptsilji, ma amãrtioshlji trã mitãnjiusiri.” ");
INSERT INTO rup_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Atumtsea ucenitsilji al Ioan shi a Fariseilor tsãnea pãreasinji. Atselji vinirã la Isusul shi lu ntribarã: “Cãtse ucenitsilji al Ioan shi atselji al Fariseilor tsãnã pãreasinji, shi ucenitsilji a tãlji nu tsãn pãreasinji?” ");
INSERT INTO rup_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Sh-Isusul rãspunsi a-lor: “Pot s-tsãnã preasinji acljimatsilji pi numtã cãndu dzinirlu easti cu elji? Di cãt chiro dzinirlu easti cu elji nu pot s-tsãnã preasinji! ");
INSERT INTO rup_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ma va s-yinã dzãlili cãndu va s-hibã loatã dzinirlu di la elji, shi atumtsea tu atseali dzãli elji va s-tsãnã pãreasinji. ");
INSERT INTO rup_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Vãrã nu bagã tu un stranji vecljiu un peticu nou, cã altã soi lu arupi stranjilu shi azmuldzearea s-fatsi ma marã. ");
INSERT INTO rup_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Tutã ashã vãrã nu bagã yinu nou tu foali veachli, altã soi yinlu atsel noulu aspardzi foalili, yinlu s-vearsi shi foalili chearã, ashã cã yinlu atselu noulu s-bagã tu foali nali.” ");
INSERT INTO rup_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Shi undzi tsi unã dzuã di Sãmbãtã elu ma tritsea namisa di agri siminati, shi trãcãnda ucenitsilji a lui arupea schipuri. ");
INSERT INTO rup_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Shi Fariseilji lji-dzãsirã: “Vedzã, cãtse lu facã aestã tsi nu prindi s-lu facã dzua di Sãmbãtã?” ");
INSERT INTO rup_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Shi elu lã dzãsi a lor: “Ma nu avets ghivãsitã tu Scriturili tsi featsi Davidul, cãndu avea ananghi shi agiuna, elu shi tuts alantsilji tsi eara cu nãsu? ");
INSERT INTO rup_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Elu intrã tu casa al Dumnidzãu tu chirolu a arhipreftului Abiatar, shi mãcã pãnjili di dininti, tsi nu prindi s-li mãca nitsiunu, ma singur preftsãlji, shi elu lã deadi sh-atsilor tsi eara cu nãsu.” ");
INSERT INTO rup_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Deapoea lã dzãsi a lor: “Sãmbãta easti fãptã ti omlu, sh-nu omlu ti Sãmbãta.” ");
INSERT INTO rup_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Trã atsea Hiljilu a omlui easti Domn a Sãmbãtãljei. ");
INSERT INTO rup_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Deapoea elu intrã tu sinagogã, shi aclo eara un om cu mãna uscatã. ");
INSERT INTO rup_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Niscãntsã lu vigljea Isusul macã va lu vindica dzua di Sãmbãtã, shi deapoea s-lu vãrghea. ");
INSERT INTO rup_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Elu lji-dzãsi a omlui cu mãna uscatã: “Scoalã-ti namisa a tutlor!” ");
INSERT INTO rup_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Deapoea lã dzãsi a lor: “Tsi easti ndreptu dzua di Sãmbãtã, s-fatsã ghini icã s-fatsã arãu, s-ascachi un suflit icã su-vatsãnjã?” Ma elji tãtsea. ");
INSERT INTO rup_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Atumtsea elu, cum lj-vidzu avãrliga cu inati, shi nvirinat cã ininjili a lor eara indiferenti, lji dzãsi a omlui: “Tindã mãna!” Elu u timsi shi mãna a lui s-featsi ca alanta sãnãtoasã. ");
INSERT INTO rup_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Sh-Fariseilji ishirã afoarã shi trãoarã apofasirã cu Herodianjilji, cum su-vatãmã. ");
INSERT INTO rup_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Isusul cu ucenitsilji a lui s-dusi cãtrã amari shi unã multsãmi mari di oaminj dit Galilea shi dit Iudea lu-urmã, ");
INSERT INTO rup_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","sh-dit Ierusalim, sh-dit Idumea, sh-di napãrti di Iordan, tutashã unã multsãmi mari di avãrliga di Tiro sh-di Sidon. Cãndu avdzãrã atseali lucri mãri tsi elu fãtsea, vinirã la nãsu. ");
INSERT INTO rup_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Sh-elu lã dzãsi a ucenitsilor a lui s-aibã totãna etimu unã varcã, tsi lumea s-nu-u pindzea. ");
INSERT INTO rup_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Elu avea vindicatã multsã oaminj, tuts tsi avea lãngoari s-aduna avãrliga di nãsu s-bãga mãna pi nãsu. ");
INSERT INTO rup_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Shi duhurili nicurati anda u-videa cãdea pi dintsi dininti a lui sh-aurla dzãcãnda: “Tini eshti Hiljilu al Dumnidzãu!” ");
INSERT INTO rup_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ma elu lji vãrghea tsi s-nu spunea cai eara elu. ");
INSERT INTO rup_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Deapoea elu s-alinã pri munti, shi acljimã aproapi di nãsu atselji tsi vrea. Shi elji vinirã la nãsu. ");
INSERT INTO rup_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Sh-elu aleapsi doisprãdzatsi (tsi s-acljima apostulji), s-hibã cu nãsu shi s-lji pitritsea s-predica, ");
INSERT INTO rup_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","shi s-avea puteari s-aĝuneascã dratsilji. ");
INSERT INTO rup_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Shi ia doisprãdzatsilji: Simonlu, a cui lj bãgã numa Petru, ");
INSERT INTO rup_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Iacovul, hiljilu al Zebedeu, shi Ioani, fratili al Iacov, tsi lã bãgã numa Boanerges, tsi va s-dzãcã hiljilji a bubunidzariljei. ");
INSERT INTO rup_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrea, Filip, Bartolomeu, Matei, Toma, Iacovul, hiljilu al Alfeu, Tadeu, shi Simon Cananeanlu, ");
INSERT INTO rup_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","shi Iuda Iscariotul, tsi ma nãpoi lu vindu. ");
INSERT INTO rup_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Apoea intrarã la unã casã. Shi s-adunã unã multsãmi marã cãt nitsi pãni nu putea s-mãca. ");
INSERT INTO rup_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Shi cãndu soia a lui lo di hãbari, s-dusi su-ljea, cã dzãtsea: “Nu easti ghini di minti.” ");
INSERT INTO rup_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Iarã scriblji tsi avea dipunatã dit Ieruzalem, dzãtsea: “Elu ari Buelzebubul sh-lji aĝuneashti dratsilji cu printsilu a dratsilor.” ");
INSERT INTO rup_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ma elu li-acljimã aproapi di nãsu shi lã gri cu parabolã: “Cum poati Satanlu su aĝuneascã Satanlu? ");
INSERT INTO rup_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ma cã unã amirãrilji di nãuntru easti mpãrtsãtã, atsea amirãrilje nu poati s-bãneadzã. ");
INSERT INTO rup_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Macã unã casã di nãuntru sã-mpartsã, atsea casã nu poati s-bãneadzã. ");
INSERT INTO rup_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ashã, macã Satanlu si-scoalã contra a vetiljei a lui, shi easti pãrtsãt, nu poati si s-tsãnã, ma s-bitiseashti icã cheari. ");
INSERT INTO rup_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Nitsiun nu-poati s-intrã tu casa a omlui vãrtos shi s-lji-u arãcheascã avearea a lui, ni lãgatã ma nãinti omlu atsel vãrtoslu, atumtsea poati s-lji-u afurã casa. ");
INSERT INTO rup_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Dealihea ma vã dzãc cã a oamnjilor va s-lã hibã ljirtati itsi amãrtii shi cathi blãstem tsi va s-dzãcã. ");
INSERT INTO rup_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ma di atselu tsi va s-blãsteamã contra a Duhlui Sãmtu nu va s-aibã ljirtari di totãna. Elu easti amãrtios ti eta tutã.” ");
INSERT INTO rup_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Isusul li dzãsi aesti cã elji dzãtsea: “Elu ari un duh nicurat!” ");
INSERT INTO rup_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tu oara atsea vinirã fratsilji a lui shi muma, shi stãnda afoarã, pitricurã sh-lji grirã. ");
INSERT INTO rup_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Multsãmea eara apunat avãrliga di nãsu, shi-lji dzãsirã: “Ia, muma shi fratsilji a tãlji, sãntu nafoarã sh-ma ti caftã.” ");
INSERT INTO rup_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ma elu apãndisi a lor: “Cai easti muma-a mea icã fratsilji a melji?” ");
INSERT INTO rup_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Daepoea, mutrinda avãrliga di atselji tsi shãdea ningã nãsu, dzãsi: “Ia, muma-a mea shi fratsilji-a melji! ");
INSERT INTO rup_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Cã, caitsido tsi fatsi vrearea al Dumnidzãu, elu easti fratili-a meu, sora-a mea shi muma.” ");
INSERT INTO rup_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Deapoea Isusul apãrnji sã-nveatsã mardzina di amari. Shi avãrliga di nãsu s-adunã un multsãmi mari di oaminj, cãt elu intrã tu varcã shi-shãdea pi nãsã, shi tutã multsãmea eara mardzina di amari. ");
INSERT INTO rup_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Sh-elu lã nvitsa a lor cu paraboli multi lucruri, shi tu nvitsãtura-a lui lã dzãsi: ");
INSERT INTO rup_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ascultats! Ia, ishi siminãtorlu s-seaminã. ");
INSERT INTO rup_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Sh-cãndu elu simina, niscãnti gãrãts a farãljei cãdzurã pi cali shi puljilji a tserlui vinirã shi l-mãcarã. ");
INSERT INTO rup_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Sh-putsãn di farã cãdzu pi loc chitros, iu nu avea multã tsarã shi deadi dinãoarã, cã nu avea tsarã hãndoasã. ");
INSERT INTO rup_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ma cãndu ishi soarili s-pãlirã sh-ti atsea, tsi nu avea rãdãtsinã s-uscã. ");
INSERT INTO rup_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Sh-unã parti a farãljei cãdzu namisa di schinji, schinjilji criscurã, lji acãtsarã anasa sh-nu deadi carpo. ");
INSERT INTO rup_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Unã altã parti cãdzu pi tsarã bunã, sh-deadi carpo tsi crishtea sh-adusi: unã treidzãtsi, alanta shaidzãtsi, sh-alanta unã sutã.” ");
INSERT INTO rup_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Deapoea elu lã dzãsi a lor: “Cai ari urechlji trã avdzãri, s-avdã.” ");
INSERT INTO rup_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Cãndu Isusul eara singur, atselji tsi eara avãrliga di nãsu deadun cu doisprãdzatsilji, lu ntribarã ti parabola. ");
INSERT INTO rup_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Elu lã dzãsi a lor: “A voauã vã easti datã s-cunushtets mistiryiul a amirãriljei al Dumnidzãu, iarã atsilor tsi sãntu afoarã tuti aesti sã si da cu paraboli: ");
INSERT INTO rup_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","‘Mutrinda, s-veadã ma s-nu bagã oarã, shi avdzãnda, s-avdã ma s-nu aducheascã, cã s-nu mitãnjuseascã shi amãrtiili s-ljeartã.’” ");
INSERT INTO rup_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Deapoea lã dzãsi a lor: “Nu u-aduchits aestã parabolã? Ma atumtsea cum va li aduchits tuti alanti paraboli? ");
INSERT INTO rup_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Siminãtorlu seaminã Zborlu. ");
INSERT INTO rup_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Atselji ningã cali sãntu atselji pri la cai si seaminã zborlu, ma dupã tsi u-avdzãrã atsea, yini trãoarã Satanlu shi lã-scoati sborlu siminatã la nãshi. ");
INSERT INTO rup_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Tutashã atselji tsi u-ljea fara pri chetri, sãntu atselji tsi cãndu lu avdzãrã zborlu, trãoarã u ljea cu harauã, ");
INSERT INTO rup_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ma tsi nu acãtsarã rãdãtsinã pri nãshi, shi sãntu ti putsãn chiro, shi cãndu yini zorea icã avinarea trã itia a-zborlui, si-scandalizescu trãoarã. ");
INSERT INTO rup_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Atselji cai u-ljea fara namisa di scinj, sãntu atselji tsi lu-ascultã zborlu, ");
INSERT INTO rup_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ma nvirinãrili-a ashtiei eti, arãderili-a averilor, shi mania ti alti lucri tsi lji intrã a omlui, astupu sborlu shi nu da carpo. ");
INSERT INTO rup_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Iarã atselji tsi u loarã fara tu tsarã bunã, sãntu atselji tsi ascultã sborlu, u ljea shi aducã carpo: un treidzãts, altu shaidzãts shi altu unã sutã.” ");
INSERT INTO rup_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Deapoea lã dzãsi a lor: “Vahi s-bagã lamba sum un gãleatã icã sum un pat? Nu si s-bagã pri purtãtorul ali lunjini? ");
INSERT INTO rup_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Cã nu ari tsiva ascumtu tsi s-nu s-dizvileascã, shi tsiva faptu pri ascumtu tsi s-nu easã tu lunjinã. ");
INSERT INTO rup_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Cai ari ureclji ti avdzãri, s-avdã!” ");
INSERT INTO rup_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Shi lã dzãsi a lor: “Bãgats oarã atsea tsi avdzãtsã. Cu atsea misurã tsi voi misurats, va vã si misurã, shi a voauã tsi avdzãts va vã si da ma multu. ");
INSERT INTO rup_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Cã atsilui tsi ari va lji si da, ma atsilui tsi nu ari va lji si ljea shi atsea tsi ari.” ");
INSERT INTO rup_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Isusul dzãsi: “Amirãriljea al Dumnidzãu easti ca un om tsi arucã simintsa pri loc. ");
INSERT INTO rup_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Noaptea shi dzua, cãndu elu doarmi shi si scoalã, simintsa fitruseashti shi creashti, fãrã si shtibã elu cum. ");
INSERT INTO rup_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Di singur loclu lu fatsi: ma nãinti curpanlu, sh-apoea schiclu, shi tu soni schiclu cu gãrnutsi. ");
INSERT INTO rup_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Iarã cãndu carpolu s-coatsi, trãoarã s-bagã seatsira, cã yini oara di sitsirari.” ");
INSERT INTO rup_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Elu dzãsi: “Cu tsi undzeashti amirãriljea al Dumnidzãu? Icã cu tsi parabolã su-aspunem? ");
INSERT INTO rup_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ea undzeashti cu simintsa di sinap tsi easti siminat tu loc. Atsea simintsã easti ma njicã pri loc. ");
INSERT INTO rup_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ma dupã tsi si seaminã, creashti shi s-fatsi ma mari di tuti zãrzãvãtsile, shi sãlgheashti alumãchi ahãti mãri cãt puljilji a tserlui poatã s-aflã streahã sum aumbra a lor.” ");
INSERT INTO rup_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Shi cu multi ahtãri paraboli lã spunea a lor sborlu, ashã cum elji putea s-lu achicãsea. ");
INSERT INTO rup_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Sh-nu lã grea a lor fãrã paraboli, iarã a ucenitsilor a lui ahoria, lã spunea itsido. ");
INSERT INTO rup_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Tu seara a aishtei dzuã, lã dzãsi a lor: “Tritsem pi alantã parti.” ");
INSERT INTO rup_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Sh-ucenitsilji, cum u nchisirã multsãmea, u loarã Isusul ashã cum eara tu varcã. Cu nãsu eara sh-niscãnti vãrtsi njitsi. ");
INSERT INTO rup_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tu oarã aestã si s-featsi unã furtunã mari shi vãljiurili s-plãscãnea pri varcã ahãt multã cãt ea ma s-umplea. ");
INSERT INTO rup_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Iarã elu durnjea tu varcã pri unã cãpitinj. Elji lu dishtiptarã shi lji dzãsirã: “Nvitsãtore nu ai mirachi trã noi cã ma ni nicãm?” ");
INSERT INTO rup_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Sh-elu cum si dishtiptã lji aurlã a vimtului sh-lji gri ali amari: “Tãtsã shi isihãsea-ti!” Shi vimtulu pãpsi shi s-featsi isihii mari. ");
INSERT INTO rup_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Sh-lã dzãsi a lor: “Cãtse hits ahãnt fricoshi? Cum nu avets pisti?” ");
INSERT INTO rup_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Sh-elji lji acãtsã unã fricã mari shi dzãtsea un cu-alantu: “Cai easti aesti tsi lu ascultã sh-vimtulu sh-amarea?” ");
INSERT INTO rup_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ashã agiumsirã tu alantã parti a amarãljei tu locurili a Gherasenjilor. ");
INSERT INTO rup_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Shi macãt Isusul dipunã dit varcã, trãoarã lji ishi nãinti dit murmintsã un om umplut cu un duh nicurat, ");
INSERT INTO rup_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","elu bãna tu murmintsã sh-vãrã nu avea putut s-lu liga cu singir. ");
INSERT INTO rup_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Di multi ori lu avea ligatã cu prãnghi shi singir, ma elu totãna frãndzea singirili sh-arupea prãnghili, sh-nitsiunu nu putea s-lu imireadzã. ");
INSERT INTO rup_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Dipriunã noaptea sh-dzua, prit murmintsã sh-prit muntsã, tritsea aurlãnda shi tãljãnda truplu a lui cu chetri. ");
INSERT INTO rup_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Cãndu elu lu vidzu Isusul di diparti, imnã shi s-ncljinã dininti a lui. ");
INSERT INTO rup_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Sh-cu unã aurlari mari dzãsi: “Tsi ari namisa di mini sh-di tini, Isus, Hiljilu al Dumnidzãu atsel multu analtu? Mini mi spigiurã pi numa al Dumnidzãu, nu mi pidipsea!” ");
INSERT INTO rup_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Cã Isusul lji-avea dzãsã: “Duh nicurat, eshi dit aestu om!” ");
INSERT INTO rup_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Atumtsea Isusul lu ntribã: “Cai easti numa a ta?” Shi elu apãndisi dzãcãnda: “Mini mi acljeamã Legion, cã him multsã.” ");
INSERT INTO rup_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Shi l-pãrãcãlsea multu tsi si nu li aĝuneascã dit loclu atselu. ");
INSERT INTO rup_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Aclo la coasta a muntilui eara unã cupii mari di portsi tsi pãshtea. ");
INSERT INTO rup_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Atumtsea tuts demonjili pãrãcãlsirã dzãcãndã: “Pitreatsi-nã la portsi tsi s-intrãm tu nãshi.” ");
INSERT INTO rup_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Sh-Isusul trãoarã lã deadi izini a lor, sh-duhurili nicurati dupã tsi ishirã, intrarã la portsilji, sh-cupia s-arucã nghios di tu ripã tu amari. Era aproapi doauã njilji di capiti tsi s-nicarã tu amari. ");
INSERT INTO rup_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Atselji tsi pãshtea portsilji fudzirã sh-u scurpisirã shtirea tu cãsãbã sh-pri hoari. Sh-oamnjili vinirã s-videa tsi avea undzitã. ");
INSERT INTO rup_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Cãndu vinirã la Isus, vidzurã drãcuitlu mpadi, nviscut sh-cu mintea ntreag, atselu tsi eara demonizat di leghionlu, shi avea fricã. ");
INSERT INTO rup_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Atselji tsi u avea vidzutã, lji spusirã a lor cã tsi lji avea undzitã a demonizatlui shi a portsilor. ");
INSERT INTO rup_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Atumsina atselji ahurhirã s-lji pãrãcãlseascã al Isus s-fugã di sinurili a lor. ");
INSERT INTO rup_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Cãndu elu ma intra tu varcã, atselu tsi eara demonizat lji pãrãcãlsea tsi s-putea s fudzea cu nãsu. ");
INSERT INTO rup_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ma Isusul nu lji deadi izini, shi lj-dzãsi: “Imnã la casa a ta, la-a tãlji shi spunã a-lor tsi lucri mãri featsi Domnul shi cum ti njilui.” ");
INSERT INTO rup_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Sh-elu fudzi shi ahurhi sã predica pri regiunea di Decapolis di tuti atseali tsi avea faptã Isusul shi tuts s-ciudisirã. ");
INSERT INTO rup_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Shi cãndu Isus tricu nãpoi tu alantã parti cu varcã, un multsãmi marã s-adunã avãrliga di nãsu, sh-elu armasi mardzina di amari. ");
INSERT INTO rup_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Deapoea vini un di ma mãrlji a sinagogãljei, cu numa Iair, tsi cãndu lu vidzu, lj-cãdzu la cicioari. ");
INSERT INTO rup_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Sh-multu lã pãrãcãlsi dzãcãnda: “Hiljea a mea ma moari, haidi shi bagã mãnjili pri nãsã, tsi s-vindicã shi s-bãneadzã.” ");
INSERT INTO rup_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Sh-elu s-dusi cu nãsu, sh-unã multsãmi mari nidzea dupã nãsu shi s-pindzea avãrliga di nãsu. ");
INSERT INTO rup_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Namisa di nãshi eara unã muljeari tsi lj-cura sãndzili di doisprãdzatsi di anji. ");
INSERT INTO rup_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Sh-avea traptã multi di partea a iatsrilor sh-avea chirutã tutã avearea a ljei fãrã ufilii, sh-ma s-fãtsea ma rãu. ");
INSERT INTO rup_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Cãndu avdzã si zbura di Isusul, intrã la multsãmea, sh-dupã nãsã timsi mãna la stranjilu al Isus. ");
INSERT INTO rup_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ea dzãtsea: “Macã va bagã mãna la stranjili a lui, va mi vindicã.” ");
INSERT INTO rup_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Sh-trãoarã curarea a sãndzilui pãpsi shi ea sãmtsã tu truplu a ljei cã s-vindicã di atsea lãngoari. ");
INSERT INTO rup_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ma trãoarã Isusul sãmtsã un puteari tsi avea ishit di la nãsu, s-turnã cãtrã multsãmea sh-dzãsi: “Cai deadi di stranjili a meali?” ");
INSERT INTO rup_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Sh-ucenitsilji a lui lji-dzãsirã: “Nu vedz cã multsãmea ma s-pingã di tuti pãrtsãli shi tini dzãtsi: ‘Cai deadi di mini?’” ");
INSERT INTO rup_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Elu mutrea avãrliga s-videa cai u featsi aestã. ");
INSERT INTO rup_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Atumtsea, muljearea mplinã di fricã sh-trimurãnda, cã shtia tsi avea pãtsãtã, vini shi lji cãdzu pi cicioari shi lj-spusi tutã alihea. ");
INSERT INTO rup_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Sh-elu lj-dzãsi: “Hilje, pistea a ta ti-vindicã, imnã tu pace cã eshti vindicatã di lãngoarea a ta!” ");
INSERT INTO rup_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Iarã Isusul ninga ma grea, vinirã niscãntsi di la casa a primarlui a sinagogãljei dzãcãndã: “Hjiljea a ta muri. Cãtse lu cãrteshti ninga nvitsãtorlu?” ");
INSERT INTO rup_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ma Isusul cãndu avdzã tsi dzãsirã, lji dzãsi a primarlui a sinagogãljei: “Nu ti asparã, mash s-ai pistusini!” ");
INSERT INTO rup_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Nu alãsã s-lu urmeadzã nitsiun altã, dicãt mash Petrul, Iacovul shi Ioanul, fratli al Iacov. ");
INSERT INTO rup_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Shi dupã cum agiumsi la casa a marlui a sinagogãljei, vidzu unã mintiturã mari shi oaminji tsi plãndzea shi vãita cu boatsi. ");
INSERT INTO rup_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Intrã sh-lã dzãsi a lor: “Cãtse aurlats shi plãndzets? Feata nu muri, ma doarmi.” ");
INSERT INTO rup_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Elji s-pizuirã, ma elu dupã tsi lji scoasi tuts afoarã, lo cu nãsu tat-su shi mã-sa-a li feati sh-atselji tsi eara cu nãsã, sh-intrã aclo iu eara feata. ");
INSERT INTO rup_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Elu u lo feata di mãnã shi lj-dzãsi: “Talitha kumi”, tsi va s-dzacã: “Featã, atsãia ma tsã-dzãc: Scoalã-ti!” ");
INSERT INTO rup_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Trãoarã feata si sculã sh-imnã singur. Ea eara di doisprãdzatsi di anji. Sh-elji s-ciudisirã multu. ");
INSERT INTO rup_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ma elu lã deadi ordin tsi vãrã s-nu shtia. Sh-lã ursi si lj-da ali feati di mãcari. ");
INSERT INTO rup_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Apoea Isusul fudzi di aclo sh-vini tu tsara a lui, shi ucenitsilji a lui u urmarã. ");
INSERT INTO rup_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Cãndu vini Sãmbãta, ahurhi sã li nvitsa tu sinagogã. Sh-multsã cãndu lu-avdza, s-ciudisea sh-dzãtsea: “Di iu lj-yinã aishtui aesti? Tsi mintiminiljii easti atsea tsi lj-easti datã? Sh-cum s-facã aesti thavmati cu mãnjili a lui? ");
INSERT INTO rup_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Nu easti aestu lemnar, hiljilu ali Marii, fratili al Iacov, sh-al Iose, al Iuda sh-al Simon? Sh-nu sãntu aoa namisa di noi surãrili a lui?” Shi si scandalizea di itia a lui. ");
INSERT INTO rup_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Isusul lã dzãsi a lor: “Nitsiunu prufit nu easti dispretsuit dicãt mash tu patria a lui, tu soia a lui sh-tu casa a lui.” ");
INSERT INTO rup_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Sh-nu pãtu s-facã atsia nitsiunã thavmã, dicãt mash s-vindicã vãrãndoi lãndzitsã bãgãnda mãna pri nãshi. ");
INSERT INTO rup_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Shi s-ciudisea ti nipistipsirea a lor. Isusul imna avãrliga pri hoarili sh-lã-nvitsa. ");
INSERT INTO rup_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Sh-lã acljimã atselji doisprãdzatsi sh-ahurhi s-lji pitreacã doi cãti doi sh-u deadi puteari pristi duhurili nicurati. ");
INSERT INTO rup_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Sh-lã dimãndã s-nu ljea tsiva altã pri cali, dicãt mash unã ciumagã, nitsi trastã, nitsi pãni, nitsi pãradzi tu brãn, ");
INSERT INTO rup_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ma s-ncalcã mash sandalili shi s-nu bagã doauã pãreaclji di tunicã. ");
INSERT INTO rup_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Deapoea lã dzãsi: “Iutsido tsi s-intrats tu unã casã, armãnets aclo pãnã s-fudzit di aclo. ");
INSERT INTO rup_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Macã niscãntsã nu vã ashteaptã sh-nu vã avdã, cãndu s-fudzits di aclo, ascuturats puhlu di cicioarili-a voastri, ca mãrtirii contra-a lor. Dealihea vã dzãc cã dzua a giudicarãljei Sodoma sh-Gomora va si s-veadã cu ma multã lishuredz dicãt atselu cãsãbã.” ");
INSERT INTO rup_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ashã atselji s-dusirã sh-predica a oamnjilor tsi s-mitãnjiuseascã ");
INSERT INTO rup_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Sh-aĝuneascã multsã demonji sh-aungã cu untulem multsã lãndzits sh-li vindica. ");
INSERT INTO rup_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Tora amirãlu Herod avdzã si sbura di Isusul cã numa a lui eara faptã cunuscut sh-elu dzãsi: “Ioan pãtidzãtorlu s-inje dit mortsã, trã atsea pri nãsu ma lucreadzã putearili cu mari ciudii.” ");
INSERT INTO rup_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Niscãntsã altsã dzãtsea: “Easti Ilia.” Sh-niscãnts altsã dzãtsea: “Easti un prufit icã un di prufitsilji.” ");
INSERT INTO rup_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ma cãndu Herodul avdzã tuti atseali, dzãsi: “A Ioanlui, a cui lji tãljai caplu, s-inje dit mortsã!” ");
INSERT INTO rup_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Cã Herodul avea datã ordin s-acãtsa Ioanul shi si s-tsãnea ligatã tu hapsi di itia a Herodiadãljei, muljearea al Filip, fratli a lui, cã lu avea loatã ti muljeari. ");
INSERT INTO rup_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ioanlu lj-dzãtsea al Herod: “Nu ai ndriptati s-ai muljearea a fratilui a tãu.” ");
INSERT INTO rup_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodiada lu aura sh-vrea s-lu vãtãma, ma nu putea. ");
INSERT INTO rup_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodul s-afirea di Ioanlu tsi lu cunushtea ca om ndrept shi sãmtã, sh-lu apãra, sh-dupã tsi avdza multi lucri di nãsu, fãtsea multi lucri, sh-lu asculta cu vreari. ");
INSERT INTO rup_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ma vini dzua tsi lipsea shi Herodul, tu dzua a amintariljei a lui adrã uspetsi ti mãrilji a lui, capitãnjilji sh-tinjisitsilji a Galileiljei. ");
INSERT INTO rup_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Intrã hiljea a Herodiadãljei, giucã sh-lji arãsi al Irod shi a lor tsi shidea deadun cu nãsu la measã, atumtsea amirãlu lji-dzãsi a featiljei: “Caftã-nji itsi vrei shi mini va ts-u dau.” ");
INSERT INTO rup_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Sh-lji si spigiurã: “Itsido tsi va nji caftsã va ts-u dau, pãn la giumitatea a amirãriljei-a mea.” ");
INSERT INTO rup_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ea ishi afoarã sh-lji dsãsi a mumãljei: “Tsi prindi s-lji caftã?” Shi ea apãndisi: “Caplu al Ioan Pãtidzãtorlu!” ");
INSERT INTO rup_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ea s-turnã trãoarã la amirãlu sh-lji-cãftã aĝonjea: “Mini voi tsi tini s-nji dai trãoarã tu tãpsii caplu al Ioan Pitidzãtorlu.” ");
INSERT INTO rup_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Sh-amirãlu cu tutã cã si nvirinã multu di aestã, nu vrea s-arnisea ti itia cã eara spigiuratã sh-ti tinjia a acljimatsilor. ");
INSERT INTO rup_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ashã trãoarã amirãlu pitricu un vigljitor s-lji aducã caplu al Iaon. ");
INSERT INTO rup_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Shi elu s-dusi tu hapsi, lj-tãlje caplu sh-lji lu-adusi pri unã tãpsii, lji lu deadi ali feati shi feata lji lu deadi a mumãljei. ");
INSERT INTO rup_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Cãndu ucenitsilji al Ioan lji avdzãrã aesti, vinirã, loarã truplu a lui shi lu bãgarã tu murmintu. ");
INSERT INTO rup_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Tora apostoljilji s-adunarã ningã Isus shi lji spusirã tuti atseali tsi avea faptã shi tsi lj-avea nvitsatã. ");
INSERT INTO rup_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Sh-elu lã dzãsi a lor: “Haidets tu un loc tu irnjii sh-discurmats-vã.” Cã oamnjilji tsi yinea shi s-dutsea eara ahãntsã multsã cãt nu avea chiro di mãcari. ");
INSERT INTO rup_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","S-nchisirã cu unã varcã cãtrã un loc ermu shi dipãrtat. ");
INSERT INTO rup_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Macãt multsãmea lã vidzu tsi s-nchisirã, multsi di atselji lu cunuscurã, sh-di tuti cãsãbadzli vinirã aclo pi cicioari shi agiumsirã dininti a lor shi s-adunarã avãrliga di nãsu. ");
INSERT INTO rup_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Cãndu Isus ishi dit varcã, vidzu unã multsãmi marã shi lj-vini rãu, cã era ca oili fãrã picurar. Shi ahurhi s-lã nveatsã multi lucri. ");
INSERT INTO rup_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Shi cum tricu multu chiro, ucenitsilji a lui s-apruchearã sh-lji-dzãsirã: “Aestu loc easti ermu sh-tora easti amãnatã. ");
INSERT INTO rup_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Dã-lã cali aishtoru oaminji si s-ducã tu cãmpurili sh-hoarili di avãrliga tsi s-acumpãrã pãni, cã nu au tsiva ti mãcari.” ");
INSERT INTO rup_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Iarã elu apãndisinda lã dzãsi a lor: “Dats-lã voi s-mãcã!” Sh-elji lji-dzãsirã: “Prindi s-nidzem noi s-acumpãrãm doauã sutã di denari pãni shi s-lã dãm ti mãcari?” ");
INSERT INTO rup_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Elu lã dzãsi a lor: “Cãti pãnji avets? Imnats sh-mutrits!” Dupã tsi vidzurã dzãsirã: “Tsintsi pãnji sh-doi peshti.” ");
INSERT INTO rup_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Atumtsea elu deadi ordin a lor tsi s-lji ndreagã tuts, apunats grupi-grupi pri yiarba veardi. ");
INSERT INTO rup_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ashã atselji s-apunarã tu grupuri cãti unã sutã sh-cãti tsindzãtsi. ");
INSERT INTO rup_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Apoea elu lo tsintsi pãnjili sh-doi peshti, sculã ochljilji cãtrã tser, ghinicuvãntãnda, pãrtsã pãnjili sh-u deadi a ucenitsilor a lui, tsi s-u pãrtsa a lor, tutashã u pãrtsã a lor sh-peshtilji. ");
INSERT INTO rup_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tuts mãcarã pãn s-fãntirã ");
INSERT INTO rup_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Sh-adunarã doisprãdzatsi di cãneastri cu sãrmi di pãnji shi cu armãnturi di peshti. ");
INSERT INTO rup_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Atselji tsi mãcarã pãnjili eara tsintsi njilji di bãrbats. ");
INSERT INTO rup_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Trãoarã Isusul lã ursi ucenitsilji a lui s-intra tu varcã shi si s-ducã tu alantã parti cãtrã Betsaida, pãnã-cãndu elu s-alãsa s-dispãrtsea mutsãmea. ");
INSERT INTO rup_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Macãt li salutã, elu s-alinã tu munti ti pãrãcãlsiri. ");
INSERT INTO rup_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Cãndu tunicã varca eara namisa di amari sh-elu singur eara tu meal. ");
INSERT INTO rup_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Cãndu lji vidzu ucenitsilji, elji ma s-pidipsea nãftãnda, cã vimtul eara contra lor. Tu a patrulu vigljitor a noaptãljei Isusul s-nchisi cãtrã nãshi imnãnda pri amari sh-elu vrea s-lji tritsea. ");
INSERT INTO rup_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ma elji, cãndu lu-vidzurã cã ma tritsea pri amari, mintuirã cã eara unã fantazmã shi ahurhirã s-aurlã. ");
INSERT INTO rup_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Tuts lu vidzurã sh-eara lãhtãrsitsã, ma elu trãoarã ahurhi s-greascã cu nãshi, sh-dsãsi: “Curaiu! Mini escu, nu vã-aspãrats!” ");
INSERT INTO rup_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Deapoea s-alinã tu varcã cu nãshi sh-vimtul pãpsi. Sh-atselji armasirã ciudisits shi si thãvmãtisirã. ");
INSERT INTO rup_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Cã nu lu-avea aduchitã thavma a pãnjilor cã inima a lor eara chitrisitã. ");
INSERT INTO rup_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Dupã tsi tricurã, agiumsirã tu loclu a Ghenezaretlui, sh-aclo u-ligarã varca. ");
INSERT INTO rup_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Sh-cãndu ishirã dit varcã, oamnjilji lu-cunuscurã dinãoarã. ");
INSERT INTO rup_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Shi trãcãnda trãoarã pisti tutã locurili di avãrligã, ahurhirã s-aducã tuts lãndzitslji pri paturi iutsido tsi avdza cã s-afla elu. ");
INSERT INTO rup_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Iutsido tsi elu intra, tu hoari, tu cãsãbadz icã tu mãhãladz oamnjilji bãga lãndzitslji tu padi, sh-lu pãrãcãlsea tsi s-bãga mãna pi stranjili a lui. Sh-tuts atselji tsi bãgarã mãna s-vindicarã. ");
INSERT INTO rup_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Atumtsea s-adunarã avãrliga di nãsu Fariseilji shi niscãntsã scribi tsi avea vinitã di Ieruzalem. ");
INSERT INTO rup_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Atselji bãgarã oarã cã niscãntsã di ucenitsilji a lui ma mãca pãni cu mãnjili lãvushiti, va s-dzãcã ni-lati. ");
INSERT INTO rup_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Fariseilji sh-tuts Iudeilji nu mãcã ni-lati ghini mãnjili ma nãinti, tsãnãnda adetsili a vecljilor. ");
INSERT INTO rup_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Sh-cãndu s-toarnã dit pãzari nu mãcã macã nu sãntu latã ma nãinti. Suntu multi alti lucri tsi atselji prindi s-li fac ti itia a adetsilor: larea a cupilor, a pocilor, a cãldãrilor shi a paturilor. ");
INSERT INTO rup_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Deapoea Fariseilji shi scriblji lu ntribarã: “Cãtse ucenitsilji a tãlji nu facã dupã adetsili a vecljilor, ma mãcã pãni ni aspãlati mãnjili?” ");
INSERT INTO rup_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ma elu apãndisinda lã dzãsi a lor: “Ghini prufitipsi Isaia trã voi, ipucrits, ashã cum easti scriatã: ‘Aestu popul cu budzili mi tinjiseashti, ma inima-a lor easti diparti di mini. ");
INSERT INTO rup_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ma di geaba mi alãvdatsã, nvitsãnda unã doctrinã tsi easti unã dimãndari umineascã.’ ");
INSERT INTO rup_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Alãsãnda di unã parti ordinlu al Dumnidzãu, ma tsãnets adetsili a oamnjilor, aspãlarea a pocilor sh-a cupilor, shi fãtsets multi alti ahtãri lucri.” ");
INSERT INTO rup_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Sh-ninga lã dzãsi a lor: “Voi hits axii ti arnisiri ordinlu al Dumnidzãu, sh-di tsãneari adetulu a vostru. ");
INSERT INTO rup_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moisiul dzãsi: ‘Tinjisea tatãlu a tãu sh-muma a ta.’ Shi: ‘Atselu tsi blastimã tatãlu sh-muma, easti giudicatã cu moarti.’ ");
INSERT INTO rup_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ma voi dzãtsets: ‘Macã vãrã lji-dzãtsi a-tatãlui a lui icã ali mumi a lui, itsi pot s-facã trã voi easti un Curban, va s-dzãcã un pisches trã Dumnidzãlu,’ ");
INSERT INTO rup_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","nu lu alãsats atselu s-facã tsiva di tatãlu a lui icã di muma a lui, ");
INSERT INTO rup_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ashi voi arnisits zborlu al Dumnidzãu cu adetulu a vostru, tsi voi lu avets clirunumsitã. Shi voi ma fãtsets multi alti ahtãri lucri.” ");
INSERT INTO rup_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Deapoea acljimã tutã lumea avãrliga di nãsu shi lji-dzãsi: “Mi ascultats tuts shi aduchits! ");
INSERT INTO rup_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nu ari tsiva di nafoarã a omlui, tsi intrãnda tu nãsu s-u lãvãshescu, aljiumtrea, sãntu atseli lucri tsi easã di la nãsu tsi u lãvãshescu.” ");
INSERT INTO rup_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Cai ari ureclji trã avdzãri, s-avdã! ");
INSERT INTO rup_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ma napoea, cãndu elu s-turnã la casã, diparti di multsãmea, ucenitsilji a lui lu-ntribarã trã achicãsirea a parabolãljei. ");
INSERT INTO rup_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Sh-elu lã-dzãsi a lor: “Sh-voi nu avets minti n-capã. Nu-u aduchitsã cã itsi intrã di nafoarã la omlu nu poati s-u lãvãsheascã? ");
INSERT INTO rup_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Cã nu lji-intrã tu inimã, ma tu pãnticã, sh-deapoea lu-scoatã tu tualet?” Zburãnda ashi, elu li declarã curati tuti mãcãrili. ");
INSERT INTO rup_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Elu dzãsi: “Atsea tsi easi di la omlu, lu fatsi lãvos. ");
INSERT INTO rup_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Cã di nãuntru, va s-dzãcã dit inima a-omlui ies minduirili arali, ncãlcarea a cãruniljei, furãrili, vãtãmãrili, ");
INSERT INTO rup_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","putãnsirili, mãniili, ruteatsili, arãdearili, rushinarea, pizma, blãstemlu, mintimãrirea, hãzãmãrili. ");
INSERT INTO rup_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tuti atseli arãli ies di nãuntru sh-u lãvãshescu omlu.” ");
INSERT INTO rup_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Deapoea s-nchisi di aclo shi s-dusi tu cãsãbãlu a Tirlui. Intrã tu unã casã sh-vrea tsi nitsiun s-nu lu shtibã, ma nu putu s-armãnã ascumtu. ");
INSERT INTO rup_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Unã muljeari, tsi hiljea a ljei avea un duh nicuratã, avdzãnda di Isusul, vini sh-cãdzu la cicioarili a lui. ");
INSERT INTO rup_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Tora atsea muljeari eara elenicã, cu rãdãtsinã Sirofenicã. Shi lji pãrãcãlsi a lui tsi s-lu aĝunea draclu di hilja a ljei. ");
INSERT INTO rup_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Iarã Isusul dzãsi: “Alasã cilimenjilji prota s-fãnteascã, cã nu easti ghini s-ljeai pãnea a-cilimenjilor shi s-u arutsã a cãtsãljilor.” ");
INSERT INTO rup_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ma ea apãndisi shi lj-dzãsi: “Ghini ma greshtã, Doamne, ma shi cãtsãljilji sum masã mãcã sãrmili a cilimenjilor!” ");
INSERT INTO rup_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Atumtsea elu lj-dzãsi: “Trã aestu sbor a tãu, fudz, draclu ishi di hiljea a-ta!” ");
INSERT INTO rup_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Sh-ea, cãndu s-turnã la casa a-ljei, u-aflã feata tu pat shi draclu avea ishitã. ");
INSERT INTO rup_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Dupã tsi s-nchisi nãpoi dit locurli a Tirlui shi s-dusi cãtrã Sidon, Isusul agiumsi la amarea a Galileiljei, namisa di loclu a Decapolei. ");
INSERT INTO rup_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Sh-lji adusirã un mut tsi cu zori grea, shi lj-pãrãcãlsirã s-bagã mãnjili pi nãsu s-lu vindica. ");
INSERT INTO rup_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Cum lu lo, diparti dit multsãmea, lj-bãgã dzeadzitli tu urecljilji a lui, shi dupã tsi scuchie dzeaditlu, lj-acãtsã limba. ");
INSERT INTO rup_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Deapoea sculã ocljilji cãtrã tser, suschirã shi-lj dzãsi: “Effatha”, tsi va s-dzãcã: “Discljidi-ti!” ");
INSERT INTO rup_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Shi trãoarã s-discljisirã urechljilji shi s-dizligã gura sh-elu gri cum prindi. ");
INSERT INTO rup_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Sh-Isusul lã-ursi atselji tsi s-nu lj-spunea a vãrui. Ma cãt ma multu lã ursea ahtãt ma multu elji lu scurpisea sborlu. ");
INSERT INTO rup_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Sh-multu ciudisits, dzãtsea: “Elu itsido lu ari faptã ghini, tsi surdzãlji s-avdã shi mutsilji s-greascã!” ");
INSERT INTO rup_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tu atseali dzãli, s-adunã unã multsãmi multu mari sh-nu avea tsi s-mãca, Isusul lã-gri a ucenitsilor sh-lã dzãsi a lor: ");
INSERT INTO rup_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nj-easti njilã di aestã multsãmi, cã s-featsirã trei dzãli tsi sta cu mini, sh-nu ari tsi s-mãcã. ");
INSERT INTO rup_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Sh-ma s-lji pitrecu la casã ni mãcat, va-s armãnã pi cali, niscãntsã di elji au vinit di diparti.” ");
INSERT INTO rup_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Sh-ucenitsilji a lui lj-apãndisirã: “Cum va s-lji fãntea vãrã cu pãni aeshti aoa tu irnjii?” ");
INSERT INTO rup_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Sh-elu lji-ntribã: “Cãti pãnji avets?” Elji dzãsirã: “Shapti.” ");
INSERT INTO rup_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Atumtsea elu lã-deadi ordin ali multsãmi s-apunã mpadi. Sh-lo shapti pãnjili, hãrãstisi, li-frãmsi shi li-deadi a ucenitsilor a-lui tsi s-li pãrtsea ali multsãmi, sh-elji li pãrtsarã. ");
INSERT INTO rup_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Avea sh-niscãnti peshti njitsi. Dupã tsi li-ghinicuvãntã, ordinã tsi sh-atselji s-lji mpãrtsa la mutsãmea. ");
INSERT INTO rup_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ashã elji mãcarã shi s-fãntirã, sh-adunarã shapti coshuri cu bãcãtsili tsi armasirã. ");
INSERT INTO rup_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Atselji tsi mãcarã eara vãrã patru njilji di oaminji, deapoea lã-alãsã. ");
INSERT INTO rup_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Elu trãoarã intrã tu varcã cu ucenitsilji a lui shi s-dusi tu locurili a-Dalmanutiljei. ");
INSERT INTO rup_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Vinirã Fariseilji shi acãtsarã si zburãscã cu nãsu, cãftãnda un semnu dit tser tsi su bãga tu provã. ");
INSERT INTO rup_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Elu suschirãnda dzãsi: “Cãtse aestã gheneratã caftã un semnu? Dealihea ma vã dzãc cã aishtei gheneratã nu-va sã si da nitsiunu semnu.” ");
INSERT INTO rup_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Sh-lji alãsã, intrã napoi tu varcã shi tricu di napãrti. ");
INSERT INTO rup_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Tora ucenitsilji avea agãrshat s-ljea pãni, sh-tu varcã nu-avea tsiva dicãt mash unã singur pãni. ");
INSERT INTO rup_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Isusul lã-urlã dzãcãnda: “S-avets cãshtiga, afirits-vã di maeaua a Fariseilor sh-di maeaua al Irodul!” ");
INSERT INTO rup_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ma atselji minduia namisa di nãshi, dzãcãnda: “Nu avem pãni.” ");
INSERT INTO rup_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Isusul bãgã oarã sh-lã-dzãsi: “Cãtse minduits cã nu avets pãni? Ninga nu avets achicãsitã sh-nu avets aduchitã? Ninga u-avets inima chitritã? ");
INSERT INTO rup_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Avets oclji sh-nu videts, avets ureclji sh-nu-avdzãts? Nu tsinets minti? ");
INSERT INTO rup_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Cãndu pãrtsãi tsintsi pãnjili ti tsintsi njilji, cãti coshuri mplini cu bãcãtsi adunat?” Elji dzãsirã: “Doisprãdzatsi.” ");
INSERT INTO rup_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Cãndu pãrtsãi shaptili pãnji ti patru njilji, cãti coshuri mplini cu pãnji adunatã?” Elji dsãsirã: “Shapti.” ");
INSERT INTO rup_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Sh-elu lã dzãsi a lor: “Ma cum ninga nu achicãsits?” ");
INSERT INTO rup_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Deapoea agiumsi tu Betsaida sh-lji adusirã un orb shi l-pãrãcãlsirã s-bagã mãna. ");
INSERT INTO rup_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Atumtsea lo di mãnã orbulu, lu scoasi afoarã dit hoarã, shi dupã tsi lji-scuche tu oclji shi bãgã mãnjili pi nãsu, lu-ntribã macã videa tsiva. ");
INSERT INTO rup_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Sh-elu, discljidzãnda ocljilji, dzãsi: “Ma vedu oaminj ca ponji tsi imnã.” ");
INSERT INTO rup_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Sh-Isusul lã bãgã mãnjili napoi pristi ochljilji a lui sh-lu featsi s-veadã cãtrã nsus, shi atsilui lji si turnã videarea sh-videa ghini itsido. ");
INSERT INTO rup_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Sh-Isusul lu-pitricu s-ducã la-casa a lui dzãcãnda: “Nu intrã tu horã sh-nu lji spunã a vãrui tsiva.” ");
INSERT INTO rup_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Deapoea Isusul s-dusi deadun cu ucenitsilji a lui pri hoarili a Cesareljei al Filip. Sh-tu cali lã-ntribã ucenitsilji a lui dzãcãndã: “Cai dzãc oamnjilji cã escu mini?” ");
INSERT INTO rup_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Elji apãndisirã: “Niscãntsã Ioan Pãtidzãtorlu, altsã Ilia, sh-altsilji un dit prufitsilji.” ");
INSERT INTO rup_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Sh-elu lã-dzãsi a lor: “Ma voi, cai dzãtsets cã escu?” Sh-Petrul apãndisinda lji-dsãsi: “Tini eshti Hristolu.” ");
INSERT INTO rup_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Atumtsea elu lã ursi s-nu spunea a nitsiunu ti nãsu. ");
INSERT INTO rup_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Deapoea Isusul apãrnji s-lã nveatsã a lor cã Hiljilu a-omlui prindi s-mundueascã di multi lucri, shi va-si s-alipideascã di aushilji, di ma mãrlji a-preftsilor sh-di scriblji, cã va si-s vatãmã shi dupã trei dzãli va s-injeadzã. ");
INSERT INTO rup_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Sh-elu lã dzãsi aesti zboari pri fatsã. Atumtsea Petrul lu lo dinãparti sh-apãrnji s-lu vãrgheascã. ");
INSERT INTO rup_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ma elu s-nturnã, vidzu ucenitsilji a lui sh-lji aurlã a Petrului dzãcãnda: “Fudz di la mini, drac, cã tini nu ai minti ti lucrili al Dumnidzãu, ma ti lucrili a-oamnjilor.” ");
INSERT INTO rup_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Sh-u acljimã ningã nãsu multsãmea cu ucenitsilji a lui, sh-lã dzãsi: “Caitsido tsi va s-yinã dupã mini, s-alipideascã bana a lui, s-ljea crutsea a lui, shi s-mi urmeadzã. ");
INSERT INTO rup_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Cã atselu tsi va s-ascapã bana a lui, va su-cheardã, ma atselu tsi va-su cheardã bana a lui ti itia a mea sh-ti evanghelul, va s-ascapã. ");
INSERT INTO rup_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Tsi buneatsã va s-aibã omlu s-amintã ntreagã lumea ma cã ma napoea va s-cheardã suflitlu a lui? ");
INSERT INTO rup_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Icã tsi poati s-da omlu tu alãxirea a suflitlui a lui? ");
INSERT INTO rup_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Cã a caitsido tsi va-lji yinã rushãni trã mini sh-trã zboarili a meali namisa di aestã gheneratã cãrunã-cãlcatã shi amãrtioasã, trã atsea va lj-yinã rushãni sh-a Hiljilu a omlui, cãndu s-agiungã la mãrirea a Tatilui a lui, cu anghilji sãmtsã.” ");
INSERT INTO rup_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Deapoea Isusul lã dzãsi a lor: “Dealihea vã-dzãc cã namisa di voi tsi hits aoa sãntu niscãntsã tsi nu-va u gusteadzã moartea ma nãinti tsi s-veadã cã va s-yinã cu puteari amirãriljea al Dumnidzãu.” ");
INSERT INTO rup_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Dupã shasi dzãli Isusul lo cu nãsu Petrul, Iacovul sh-Ioanul sh-li adusi dinãparti, singur atselji pri un munti analtu. Shi s-alãxi nãintea a lor. ");
INSERT INTO rup_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Shi stranjili a lui si strãlutsirã shi s-featsirã albi ca neaua, ashã cum nu poati s-li alãgheascã nitsiun alghitor pri loc. ");
INSERT INTO rup_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Sh-a lor lã si fãnipsi Elia cu Moisiu tsi ma zbura cu Isusul. ");
INSERT INTO rup_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Atumtsea lo zborlu Petrul sh-lji dzãsi al Isus: “Nvitsãtore, trã noi easti ghini s-him aoa, s-adrãm trei cãlivi, unã trã tini, unã trã Moisiu shi unã trã Elia!” ");
INSERT INTO rup_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Elu nu-shtia tsi s-dzãtsea, cã elji eara aspãrats. ");
INSERT INTO rup_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Deapoea vini un nior tsi lã amvãli cu aumbra a lui, sh-dit nior ishi unã boatsi tsi dzãsi: “Aestu easti Hiljilu a meu vrut! Ascultats-lu!” ");
INSERT INTO rup_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Shi trãoarã elji vidzurã avãrliga, ma nu vidzurã vãrã, dicãt singur Isusul cu nãshi. ");
INSERT INTO rup_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tora cãndu ma dipuna dit munti, Isusul lã-ordinã si nu spunã a vãrui lucrili tsi avea vidzut, pãnã-cãndu Hiljilu a-omlui s-nyeadzã dit mortsã. ");
INSERT INTO rup_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Elji lu tsãnurã zborlu shi s-ntriba un cu alantu cã tsi va s-dzãtsea s-injeadzã dit mortsã. ");
INSERT INTO rup_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Deapoea lu ntribarã dzãcãnda: “Cãtse scriblji dzãc cã ma nãinti prindi s-yinã Elia?” ");
INSERT INTO rup_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Sh-elu, apãndisinda, lã dzãsi a lor: “Elia dealihea prindi s-yinã ma nãinti shi s-adarã itsido. Ma ashã cum easti scriatã trã Hiljilu a-Omlui, elu prindi s-hibã munduit sh-s-dispretsuit. ");
INSERT INTO rup_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ma mini ma vã-dzãc cã Elia vini sh-cu nãsu featsirã tsi vrurã, ashã cum easti scriatã ti nãsu.” ");
INSERT INTO rup_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Cãndu s-turnã la ucenitsilji a lui, vidzu unã multsãmi mari avãrliga di nãshi sh-niscãnts scribi tsi ma si-ncãcea cu nãshi. ");
INSERT INTO rup_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Shi dinãoarã tutã multsãmea, cãndu lu vidzu, s-ciudisi sh-vini trãoarã la nãsu ti salutari. ");
INSERT INTO rup_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Sh-elu lã ntribã scriblji: “Trã tse ma vã ncãceats cu nãshi?” ");
INSERT INTO rup_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Sh-un dit multsãmea apãndisinda, dzãsi: “Nvitsãtore, ts-adush ficiorlu a meu tsi ari un duh mut, ");
INSERT INTO rup_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","shi u-acatsi iutsido, lu-plãscãneashti sh-elu spumeadzã, cãrtsãneashti dintsilji sh-lji ngljeatsã cicioarili. Lã dzãsh a ucenitsilor a tãlji su-aĝuneascã, ma elji nu puturã s-lu facã.” ");
INSERT INTO rup_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Sh-elu dzãsi: “Gheneratã tsi nu-pistipseshti, pãnã-cãndu va s-hiu cu voi? Pãnã-cãndu va s-vã aravdã? Adutsets-lu aoa!” ");
INSERT INTO rup_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Sh-elji lu-adusirã. Macãt duhlu lu vidzu, lu-plãscãni cu fuchii cilimeanlu tsi avea cãdzut mpadi, shi s-arucutea spumãnda. ");
INSERT INTO rup_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Sh-Isusul lu-ntribã tat-su a lui: “Cãt chiro ari tsi s-fatsi aestã?” Sh-elu dzãsi: “Di cu njic. ");
INSERT INTO rup_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Di multi ori lu ari arucatã tu foc sh-tu apã tra s-lu chearã, ma s-pots s-fats tsiva, s-ai njilã trã noi shi nã agiutã!” ");
INSERT INTO rup_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Sh-Isusul lji-dzãsi: “Macã tini pots s-pistipseshtã, itsido easti putut trã atselu tsi pistipseashti.” ");
INSERT INTO rup_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Dinãoarã tatlu a-ficiorlui, aurlãnda cu lãcri, dzãsi: “Mini pistipsescu, Doamne, agiutã ni-pistipsirea a mea!” ");
INSERT INTO rup_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Atumtsea Isusul, vidzãnda cã multsãmea ma yinea trãoarã, lã aurlã al duhlu nicurat, dzãcãnda: “Tini duh tsi l-fats mut shi surdã, mini ti ursescu, s-eshi di la nãsu sh-nu intrã pute la nãsu.” ");
INSERT INTO rup_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Sh-demonul, aurlãnda shi trunduinda, ishi di la nãsu. Sh-ficiorlu armasi ca mort, ashã cãt mults oaminj dzãtsea: “Ari murit.” ");
INSERT INTO rup_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ma Isusul lu-acãtsã di mãnã, lu-sculã sh-elu shidzu pi cicioari. ");
INSERT INTO rup_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Cãndu Isusul intrã tu casã, ucenitsilji a lui lu ntribarã dinãparti: “Cãtse noi nu putum s-lu aĝunim?” ");
INSERT INTO rup_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Sh-elu lã dzãsi a lor: “Aestã soi di duhuri nu-pots s-li aĝuneshti altã soi, dicãt mash cu pãrãcãlsiri.” ");
INSERT INTO rup_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Dupã tsi s-nchisirã di aclo, tricurã pri Galilei, sh-elu nu vrea s-lu shtibã vãrã. ");
INSERT INTO rup_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Elu lã-nvitsa ucenitsilji a lui sh-lã dzãtsea a lor: “Trãoarã Hiljilu a-omlui va si s-prida tu mãnjili a oamnjilor sh-elji va lu vatãmã, sh-dupã tsi va s-hibã vãtãmatã, elu va s-injeadzã a-treia dzuã.” ");
INSERT INTO rup_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ma elji nu li-achicãsea atseali zboari sh-avea fricã s-lu ntriba Isusul. ");
INSERT INTO rup_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Sh-agiumsirã tu Capernaum, sh-cãndu intrã n-casã, lã-ntribã: “Trã tsi vã ntribats namisa di voi pri cali?” ");
INSERT INTO rup_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ma elji pãpsirã, cã pri cali dzãtsea cu un-alantu cã cai di elji easti ma marlu. ");
INSERT INTO rup_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Atumtsea elu shidzu, lã acljimã di doisprãdzatsilji sh-lã dzãsi a lor: “Macã vãrã va s-hibã protlu, prindi s-hibã ma nãpoi di tuts shi huzmichearlu a tutulor.” ");
INSERT INTO rup_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Deapoea lo un cilimean sh-lu bãgã namisa a lor. Deapoea luãnda mbratsã lã dzãsi a lor: ");
INSERT INTO rup_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Caitsido tsi aproachi un dit aeshtã cilimenji tu numa a mea, mi aproachi mini, sh-caitsido tsi mi aproachi mini, nu mi aproachi mini, ma atselu tsi mi ari pitricut.” ");
INSERT INTO rup_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Atumtsea Ioanul lo sborlu sh-dzãsi: “Nvitsãtore, noi vidzum un om tsi nu nã-urmeadzã, tsi li aĝunea demonjili tu numa a ta, sh-noi lu chidicãm cã elu nu yinea dupã noi.” ");
INSERT INTO rup_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ma Isusul dzãsi: “Nu lu chidicatsã cã nu ari om tsi poati s-facã thavmã tu numea a mea, sh-ma napoi s-greascã arãu trã mini. ");
INSERT INTO rup_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Cã cai nu easti contra a noi, easti cu noi. ");
INSERT INTO rup_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Caitsido tsi va vã da unã cupã cu apã tu numa a mea, cã hits a Hristolu, dealihea ma vã-dzãc cu sigurantsã cã nu va s-chearã plãtirea a lui. ");
INSERT INTO rup_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Sh-cai va si scandalizeadzã un di aeshti njitsilji tsi pistipsescu la mini, va eara ma ghini ti nãsu s-lji spindzira tu zvercã unã cheatrã marã di moarã sh-si s-arucã tu amari. ");
INSERT INTO rup_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Tora, macã mãna a ta ti scandalizeadzi ti amãrtii, talji-u, easti ma ghini trã tini s-intsri tu bana eternã cu mãna tsungã, dicãt s-ai doauã manji shi s-ti duts tu Ghehena, tu foclu tsi nu s-astindzi pute. ");
INSERT INTO rup_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Aclo iu iermul a lor nu moari sh-foclu nu s-astindzi. ");
INSERT INTO rup_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Macã ciciorlu a tãu ti scandalizeadzi ti amãrtii, talji-u, easti ma ghini trã tini s-intsri tu banã shcljiop, dicãt s-ai doauã cicioari shi s-ti arucã tu Ghehena, tu foclu tsi nu s-astindzi pute. ");
INSERT INTO rup_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Aclo iu iermul a lor nu moari sh-foclu nu s-astindzi pute. ");
INSERT INTO rup_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Sh-macã ocljiul a tãu ti adutsi tu amãrtii, scoat-lu. Easti ma ghini trã tini s-intsri tu banã cu un ocljiu, dicãt s-ai doi oclji shi s-ti arucã tu Ghehena, ");
INSERT INTO rup_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","aclo iu iermul a lor nu moari sh-foclu nu s-astindzi pute. ");
INSERT INTO rup_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Cã caitsido prindi s-sãreadzã tu foc sh-itsi curban prindi s-sãreadzã cu sari. ");
INSERT INTO rup_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Sarea easti bunã, macã sarea cheari njurizma, cu tsi va lu turnats njiurizma? S-avets sari pri voi shi bãnats tu pace namisa di voi.” ");
INSERT INTO rup_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Dupã tsi fudzi di aclo, Isusul s-dusi tu locurili a Iudeiljei ningã Iordan, sh-nãpoi s-adunarã avãrliga di nãsu multsãmea. Elu nãpoi ahurhi s-lã nveatsã ashã cum eara adetea. ");
INSERT INTO rup_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Sh-Fariseilji lu bãgarã tu provã shi lu ntribarã: “Macã ari izini bãrbatlu, s-lu alasã muljearea?” ");
INSERT INTO rup_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Sh-elu, apãndisinda, lã dzãsi a lor: “Tsi vã ari ordinatã Moise?” ");
INSERT INTO rup_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Elji dzãsirã: “Moise ari datã volji si-scrii cartea a dispãrtsãriljei shi su-alasã muljearea.” ");
INSERT INTO rup_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Sh-Isusul apãndisinda lã-dzãsi a lor: “Trã itia a chitrisiriljei a inimilor a voastri elu u scriã atsea regulã. ");
INSERT INTO rup_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ma tu apãrnjita a adãrarãljei, Dumnidzãlu lã adrã mascrulu sh-theamina. ");
INSERT INTO rup_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Trã aestã bãrbatul va alasã tatul sh-muma sh-va si s-mpriuneadzã cu muljearea a lui. ");
INSERT INTO rup_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ashã amindoilji va s-hibã un trup singur. Ashã elji nu sãntu ma doi, ma un trup singur. ");
INSERT INTO rup_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Trã atsea omlu s-nu mpartsã atsea tsi Dumnidzãlu ari mpriunatã!” ");
INSERT INTO rup_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Sh-la casã ucenitsilji a lui lu-ntribarã nãpoi trã aestã cauzã. ");
INSERT INTO rup_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Atumtsea elu lã-dzãsi a lor: “Atselu tsi alasi muljearea a lui shi si nsoari cu unã altã, ncalcã cãruna cu nãsã. ");
INSERT INTO rup_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Tutashã macã muljearea alasã bãrbatlu shi s-mãriti cu un altu, ncalcã cãruna.” ");
INSERT INTO rup_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Atumtsea lji-adusirã niscãntsã cilimenji njitsi tsi elu s-bãga mãna pi nãshi. Ma ucenitsilji lji-vãrghirã atselji tsi lji adusirã. ");
INSERT INTO rup_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Cãndu Isusul lu vidzu aestã, si nvirinã sh-lã dzãsi: “Alãsats-lji nitslji cilimenji s-yinã la mini sh-nu lji chidãcatsã, cã a lor easti amirãriljea al Dumnidzãu. ");
INSERT INTO rup_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Dealihea ma vã dzãc cã caitsido tsi nu u-aproachi amirãriljea al Dumnidzãu ca un cilimean njicã, nu va s-intrã la nãsã.” ");
INSERT INTO rup_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Shi cum lji lo mbratsã, lji ghinicuvãntã bãgãnda mãnjili pi nãshi. ");
INSERT INTO rup_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Tora cãndu ma s-fãtsea etimu ti cali, ishi dininti trãoarã un om, s-dzinuclje dininti a lui, sh-lu-ntribã: “Nvitsãtore bun, tsi prindi s-facã tsi s-mushtinitescu bana di totãna?” ");
INSERT INTO rup_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Sh-Isusul lji-dzãsi: “Cãtse nji-dzãts bun? Vãrã nu easti bun, dicãt mash un singur, Dumnidzãlu. ");
INSERT INTO rup_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Tini li cunoshti ordinli: ‘Nu calcã cãruna. Nu vatãmã. Nu fur. Nu fã mãrtirii arãdioasã. Nu arãd. Tinjisea tatãlu a tãu shi muma a ta.’” ");
INSERT INTO rup_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Sh-elu apãndisinda, lji-dzãsi: “Nvitsãtore, tuti atseali mini li-am faptã di cu njic.” ");
INSERT INTO rup_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Sh-Isusul lu vidzu cu vreari sh-lji dzãsi: “Un lucru tsã lipseashti: vindã tuti tsi ai shi dã-li a niavutsilor shi va s-ai unã yishteari tu tser. Deapoea haidi, ljea crutsea sh-mi urmeadzã.” ");
INSERT INTO rup_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Sh-elu s-nvirinã trã aesti sboari sh-fudzi amãros cã avea multi averi. ");
INSERT INTO rup_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Sh-Isusul dupã tsi arucã mutrita avãrliga, lã dzãsi a ucenitsilor a lui: “Cãt greu easti trã atselji tsi au aveari s-intrã tu amirãriljea al Dumnidzãu!” ");
INSERT INTO rup_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ucenitsilji s-ciudisirã di zboarili a lui. Iarã Isusul gri nãpoi sh-lã dzãsi a lor: “Hilji, cãt greu easti tsi s-intrã tu amirãriljea al Dumnizdãlu atselji tsi s-andoapirã la avearea. ");
INSERT INTO rup_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Easti ma lishor s-treacã pri guva a-aclui unã cãmilã dicãt s-intrã un avut tu amirãriljea al Dumnidzãu.” ");
INSERT INTO rup_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Sh-elji s-ciudisirã sh-ma multu sh-dzãtsea cu un alantu: “Atumtsea cai poati si-ascapã?” ");
INSERT INTO rup_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ma Isusul lã vidzu sh-dzãsi: “Aestã trã oamnjilji easti nipututã, ma nu ti Dumnidzãlu. Cã itsido easti pututã ti Dumnidzãlu.” ");
INSERT INTO rup_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Atumtsea Petrul lo sborlu sh-dzãsi: “Noi alãsãm itsido sh-ti urmãm tini.” ");
INSERT INTO rup_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Isus apãndisinda, dzãsi: “Dealihea ma vã dzãc cã nu ari vãrã om tsi ari alãsat casa, fratsilji, surãrili, tatlu, muma, hiljilji icã agrili trã mini sh-trã evanghelul, ");
INSERT INTO rup_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","shi s-nu-ljea tora, tu aestu chiro unã sutã di ori ma mult cãsi, frats, surãri, mumi, hilji sh-agri, deadun cu avinãrili sh-tu eta alantã, tu bana eternã. ");
INSERT INTO rup_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Sh-multsã di protsilji va s-hibã atselji di ma napoi, shi atselji di ma nãpoi va s-hibã protsilji.” ");
INSERT INTO rup_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Atselji eara pri cali cãtrã Ieruzalem, shi Isus imna dininti. Sh-atselji eara trumuxits sh-lu urma cu fricã. Sh-elu lã adunã di doisprãdzatsilji nãpoi dinãparti sh-ahurhi s lã dzãcã tsi va s-lji undzeascã: ");
INSERT INTO rup_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Noi ma nidzem cãtrã Ieruzalem shi Hiljilu a omlui va s-prida a arhipreftsilor sh-a scribilor, sh-elji va lu giudica cu moarti sh-va lu prida tu mãna a pãgãnjilor. ");
INSERT INTO rup_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Aeshti va lu pizueascã, va lu scuchi, va lu zãpãleascã sh-va lu vatãmã, ma elu a treia dzuã va s-injeadzã.” ");
INSERT INTO rup_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Atumtsea Iacovul sh-Ioanul, hiljilji al Zevedeu s-apruchearã la Isus sh-lji dzãsirã: “Nvitsãtore, noi vrem tsi tini s-fats trã noi atsea tsi va-s-tsã-cãftãmu.” ");
INSERT INTO rup_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Shi elu lã-dzãsi a lor: “Tsi vrets s-fac trã voi?” ");
INSERT INTO rup_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Elji lji-dsãsirã: “Alas-nã tsi s-nã apunãm un di nandreapta a ta shi alantu di nastãnga a ta tu mãrirea a ta.” ");
INSERT INTO rup_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Sh-Isusul lã dzãsi a lor: “Voi nu-shtits tsi cãftats! Putets voi s-bets cupa a munduirilor tsi mini va s-beu shi s-vã pãtidzats cu atselu pãtigiuni tsi mini escu pãtidzat?” ");
INSERT INTO rup_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Elji dzãsirã: “Ie, putem.” Sh-Isusul lã dzãsi a lor: “Dealihea va s-bets atsea cupã tsi va su beu mini, sh-va-s-vã pãtidzats cu atsea pãtigiuni tsi mini escu pãtidzat, ");
INSERT INTO rup_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ma nu easti ndreptul a meu tsi s-apunã di nandreapta a mea icã di nastãnga a mea, ma easti trã atselji tsi easti adratã.” ");
INSERT INTO rup_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Sh-cãndu li avdzãra aesti, alantsã dzatsi ahurhirã s-nãreascã contra al Iacov sh-al Ioan. ");
INSERT INTO rup_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ma Isus lã acljimã ningã nãsu sh-lã dzãsi: “Voi lu shtits cã atselji tsi s-acljeamã domnitor a lumiljei lã chivernisescu atselji, sh-mãrilji a lor foloseascã pristi nãshi puterea a lor, ");
INSERT INTO rup_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","ma atsea nu prindi s-undzeascã namisa di voi. Macã vãrã di voi tsi va s-facã mari, va s-hibã huzmichearlu a vostru. ");
INSERT INTO rup_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Sh-caitsido di voi tsi va s-hibã protlu, va s-hibã huzmichearlu a tutulor. ");
INSERT INTO rup_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Cã sh-Hiljilu a omlui nu-vini s-lji huzmitipseascã, ma s-huzmitipseascã shi di dari bana a lui ca prets ti acumprarea a multsilor.” ");
INSERT INTO rup_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ashãtsi agiumsirã tu Ierico. Cãndu elu ma isha di Ierico cu ucenitsilji a lui sh-cu unã multsãmi mari, hiljilu al Timaeu, Bartimeul orbu, eara apunat mardzina di cali sh-cãfta. ");
INSERT INTO rup_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Cãndu elu avdzã cã atselu tsi ma tritsea eara Isus Nazareas, apãrnji s-aurlã shi s-dzãcã: “Isus, Hiljilu al David, njiliua-mi!” ");
INSERT INTO rup_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Multsã lji-aurla s-pãpsea, ma elu aurla sh-ma multã: “Hiljlu al David, njiliua-mi!” ");
INSERT INTO rup_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Sh-Isus chindrui sh-ordinã tsi s-lu acljeamã. Elji lu acljimarã orbulu, dzãcãnda: “Curaiu, scoalã-ti, elu ma ti acljeamã!” ");
INSERT INTO rup_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Atumtsea elu lu-arucã nclo mantolu a lui, si-sculã sh-vini la Isus. ");
INSERT INTO rup_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Sh-Isus lji-dzãsi: “Tsi vrei s-tsã fac mini!” Orbulu lji-dzãsi: “Rabboni, s-nji-si s-toarnã videarea!” ");
INSERT INTO rup_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Sh-Isus lji-dzãsi: “Imnã, pistipsirea a ta ti vindicã!” Sh-trãoara atsilui lji si-turnã videarea shi s-nchisi pri cali dupã Isus. ");
INSERT INTO rup_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Tora cãndu s-apruchearã di Ierusalem, cãtrã Betfaghe sh-Betania, ningã Muntili a Masnjilor, Isus pitricu doi di ucenitsilji a lui, ");
INSERT INTO rup_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","dzãcãnda: “Imnats tu hoara di dininti a-voastrã, sh-ma cãt s-intrats aclo, va s-aflats un gumãric ligat, tsi nu lji-avea ncãlicat vãrã. Dizligats-lu sh-adutsets-lu la mini. ");
INSERT INTO rup_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Sh-macã vãrã vã-dzãtsi: ‘Cãtse ma fãtsets ashã?’, apãndisits-lã: ‘L-hãrzãeashti Domnulu. Elu va u-toarnã trãoarã aoa.’” ");
INSERT INTO rup_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Elji s-dusirã shi aflarã gumãriclu ligat aproapi di unã ushã, pi cali sh-u-dizligarã. ");
INSERT INTO rup_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Niscãntsã di atselji tsi eara aclo lã dzãsirã a lor: “Tsi fãtsets? Cãtse dizligats gumãriclu?” ");
INSERT INTO rup_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Aeshtã l-apãndisirã ashã cum lã avea dzãsã Isusul sh-elji lji alãsarã s-fugã. ");
INSERT INTO rup_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Atumtsea lji-adusirã al Isus cãricilu, bãgarã pri supru mantolul a lor sh-elu s-apunã pi nãs. ");
INSERT INTO rup_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Mults oaminj ashtirna stranjili a lor pri cali sh-alantsilji tãljea dedzi di ponj sh-li aruca pri cali. ");
INSERT INTO rup_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Sh-cum atselji tsi nidzea nãinti, sh-atselji tsi yinea dupã Isus, aurla sh-dzãtsea: “Hosana! Ghinicuvãntatã easti atselu tsi yini tu numa a Domnului! ");
INSERT INTO rup_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ghinicuvãntatã easti amirãriljea al David, tatãl a nostru tsi yini tu numa a Domnului. Hosana tu locurili multi analti!” ");
INSERT INTO rup_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ashã intrã Isus tu Ieruzalem sh-tu templu. Sh-dupã tsi vidzu ghini itsido, bãgã oarã cã eara amãnat, ishi deadun cu doispridzatsilji cãtrã Betania. ");
INSERT INTO rup_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Alantã dzuã, cãndu ishirã di Betania elu avea foami. ");
INSERT INTO rup_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Sh-vidzãnda di diparti un hic tsi avea frãndzi, elu s-dusi di videari nacã putea s-afla tsiva aclo. Ma cãndu s-apruche nu aflã tsiva, dicãt frãndzi, cã nu eara chirolu a hitsilor. ");
INSERT INTO rup_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Sh-Isus lji gri a hiclui, dzãcãnda: “Vãrã s-nu mãcã pute frut di la tini.” Sh-ucenitsilji a lui lu-avdzãrã. ");
INSERT INTO rup_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ashã agiumsirã tu Ieruzalem. Isusul dupã tsi intrã tu templu, apãrnji s-lji aĝuneascã atselji tsi vindea shi acumpãra nãuntru a templui sh-li rãsturnã measili a alãxitorilor di pãradzi shi scamnili a vinditorilor di purunghi. ");
INSERT INTO rup_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Sh-nu alãsa vãrã tsi s-purta lucri prit templu. ");
INSERT INTO rup_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Sh-lã nvitsa, dzãcãnda: “Vahi nu easti scriatã: ‘Casa a mea va s-acljeamã casa a pãrãcãlsirljei di tuti natsiunili’? Voi, lu avets adratã ca unã pishtireauã di furi!” ");
INSERT INTO rup_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Tora scriblji sh-mãrilji a preftsilor cãndu li avdzãrã aesti sboari cãfta cã cum s-lu vãtãma, ma avea fricã di nãsu, cã tutã multsãmea eara ciudisit di nvitsãtura a lui. ");
INSERT INTO rup_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Cãndu s-featsi searã, Isusul ishi nafoarã di cãsãbã. ");
INSERT INTO rup_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tu alantã dzuã dimineatsa, tricãnda vidzurã cã hiclu eara uscat dit rãdãtsinã. ");
INSERT INTO rup_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Sh-Petrul adusi a-minti shi lj-dzãsi: “Nvitsãtore, ia, hiclu tsi tini blãstimash easti uscat.” ");
INSERT INTO rup_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Sh-Isusul apãndisinda lã dzãsi a lor: “Avets pistipsirea al Dumnidzãu! ");
INSERT INTO rup_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Dealihea vã-dzãc, macã vãrã va lji dzãc aishtui munti: ‘Scolã-ti shi arucã-ti tu amari’, sh-nu va s-aibã dilemã tu inima a lui, ma va s-pistipseascã cã atsea tsi ma dzãtsi va s-facã, itsido va s-lji si-adarã. ");
INSERT INTO rup_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Trã atsea ma vã dzãc cã tuti atseali tsi voi cãftats pãrãcãlsinda, pistipsits cã va li-loats sh-va-vã si da a voauã. ");
INSERT INTO rup_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Sh-cãndu ahurhits s-pãrãcãlsits, macã avets tsiva contra a vãrui, ljirtats-lu tsi sh-Tatãlu a vostru tsi easti tu tseruri, s-vã ljeartã amãrtiili a voastri. ");
INSERT INTO rup_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Macã voi nu ljirtats, nitsi Tatãlu a vostru tsi easti tu tseruri, nu va-s-vã ljeartã amãrtiili a voastri.” ");
INSERT INTO rup_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Deapoea elji vinirã nãpoi tu Ierusalem, sh-cãndu elu imna prit templu, mãrilji a preftsilor, scriblji, sh-aushilji s-apruchearã, ");
INSERT INTO rup_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","sh-lji dzãsirã: “Cu tsi puteari li fats tini aesti lucri? Cai ts-u deadi aestã puteari tsi s-li fats aesti lucri?” ");
INSERT INTO rup_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Sh-Isusul apãndisinda lã dzãsi a lor: “Sh-mini va vã fac un ntribari. Apãndisits-nji sh-mini va vã-dzãc cã cu tsi puteari li fac aesti lucri. ");
INSERT INTO rup_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Pãtidzarea a Ioanului eara dit tser icã di la oaminji? Apãndisits-nji.” ");
INSERT INTO rup_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Elji ahurhirã s-minduea namisa di nãshi: “Ma s-dzãtsem ‘dit tser’, elu va s-dzãc: ‘Atumtsea cãtse voi nu lji-pistipsitã?’ ");
INSERT INTO rup_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ma s-lji dzãtsem ‘di la oamnjili…’” (elji avea fricã di populu, cã tuts dzãtsea cã Ioanlu easti dealihea un prufit). ");
INSERT INTO rup_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Trã atsea apãndisinda, lji dzãsirã al Isus: “Nu lu-shtim.” Sh-Isusul apãndisinda, lã dzãsi a lor: “Nitsi mini nu ma vã-dzãc cã cu tsi puteari li fac aesti lucri.” ");
INSERT INTO rup_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Sh-deapoea apãrnji s-lã greascã cu parabolã: “Un om siminã unã ayinji, u avãrligã cu gardu, adrã unã loc di zdruminari aua, adãrã un pirĝu trã vigljeari sh-lã-u pistipsi a niscãnts ayinjitori sh-deapoea s-dusi diparti. ");
INSERT INTO rup_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Sh-tu chirolu a cutseariljei pitricu un sclav la ayinjitorlji di loari di nãshi unã parti di auã a-ayinjiljei. ");
INSERT INTO rup_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ma elji lu-acãtsarã, lu bãturã sh-lu turnarã cu manjili goali. ");
INSERT INTO rup_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Elu pitricu nãpoi un altã sclav, ma elji dupã tsi lu-agudirã cu chetri, lu pliguirã tu cap sh-u turnarã rushinat. ");
INSERT INTO rup_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nãpoi pitricu ninga un altã, ma elji lu vãtãmarã. Ma nãpoi pitricu mults altsã sh-di aeshti mults lji-bãturã, shi alantsilji lji-vãtãmarã. ");
INSERT INTO rup_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Lj-armasi ninga un di pitritseari: hiljilu a lui vrut. Tu soni l-pitricu sh-atselu dzãcãnda: ‘Ti hiljilu a meu va s-aibã respect.’ ");
INSERT INTO rup_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ma ayinjitorilji dzãsirã un cu alantu: ‘Aestu easti clirunomlu, hai s-lu vãtãmãm shi s-nã armãnã a noauã clirunumia.’ ");
INSERT INTO rup_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Sh-lu acãtsarã, lu-vãtãmarã, sh-lu-arucarã nafoarã di ayinji. ");
INSERT INTO rup_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Tsi va s-facã domnul a-ayinjiljei? Elu va s-yinã sh-va s-lji chearã ayinjitorlji shi ayinjea va u-da a alantsilor. ");
INSERT INTO rup_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ma nu u-avets ghivãsitã aestã scritura: ‘Cheatra tsi masturlji u-arcarã, s-featsi cheatra a cohilui? ");
INSERT INTO rup_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Atsea easti faptã di la Domnul sh-easti unã thavmã tu ocljilji a noastri.’” ");
INSERT INTO rup_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Sh-elji cãftarã s-lu acatsã, cã achicãsirã cã elu lã avea dzãsã atsea parabolã contra a lor, ma avea fricã di multsãmea, sh-lu-alãsarã sh-fudzirã. ");
INSERT INTO rup_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Dupã atsea lji-pitricurã niscãntsã Farisei sh-Ierodianji tsi s-lu acãtsa tu zboari. ");
INSERT INTO rup_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Aeshti vinirã sh-lji dzãsirã: “Nvitsãtore, noi lu shtim cã tini eshtã dealihea sh-nu ntreghi di vãrã, cã nu badzã oarã fãnipsirea a-oamnjilor, ma lji nvetsã calea a Dumnidzãlui dupã ndriptatea. Easti ndreptu s-plãteshti taxa a Cezarlui icã nu? Prindi s-u plãtim icã nu?” ");
INSERT INTO rup_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ma elu, cunuscãnda ipucrizia-a lor, lã-dzãsi: “Cãtse mi bãgats tu provã? Adutsets-nji un denar tsi s-lu ved!” ");
INSERT INTO rup_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Elji lji-adusirã. Shi elu lã dzãsi a lor: “A cui easti aestã fatsã sh-aestu priscris?” Elji lji-dzãsirã: “A Cesarului.” ");
INSERT INTO rup_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Atumtsea Isus apãndisi sh-lã dzãsi a lor: “Dats-lji a Cesarului atsea tsi easti a Cesarului, sh-a Dumnidzãlui atsea tsi easti a Dumnidzãlui.” Sh-elji s-ciudisirã cu nãsu. ");
INSERT INTO rup_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Deapoea vinirã niscãntsã Sadutsei tsi dzãc tsi nu ari injeari, sh-lu ntribarã dzãcãnda: ");
INSERT INTO rup_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Nvitsãtore, Moisul nã-alãsã scrisã tsi cãndu moari fratili a vãrui sh-alasi muljearea ni-fãrã cilimenji, fratili a lui prindi si-nsoarã cu veduva tra s-lji facã dupãyinitori a fratilui. ");
INSERT INTO rup_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tora eara shapti frats, protlu si-nsurã sh-muri ni alãsatã cilimenji. ");
INSERT INTO rup_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","U lo a doilu, ma sh-elu muri ni-alãsat cilimenji, tutashã sh-a treilu. ");
INSERT INTO rup_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Di shaptilji u loarã di muljeari sh-murirã, sh-nu alãsarã clirunonji (dupãyinitori). Sh-dupã tuts muri sh-muljearea. ");
INSERT INTO rup_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","La injeari, cãndu va-s injeadzã, muljearea a cui di nãshi va s-hibã ea? Cã di shapti u-avurã muljeari.” ");
INSERT INTO rup_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Isusul apãndisinda lã dsãsi a lor: “Trã atsea voi hits tu cãbati cã nu li-shtits nitsi scriturili nitsi putearea a Dumnidzãlui. ");
INSERT INTO rup_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Cãndu oaminjilji va s-injeadzã dit mortsã, nitsi va si-nsoarã, nitsi va si s-mãritã, ma va s-hibã ca anghilji dit tser. ");
INSERT INTO rup_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Cãt di nyearea a mortsilor, nu avets ghivãsit tu cartea a Moisiul cã cum gri Dumnidzãlu dit rudz dzãcãnda: ‘Mini escu Dumnidzãlu al Abraham, Dumnidzãlu al Isac, sh-Dumnidzãlu al Iacov.’ ");
INSERT INTO rup_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Elu nu easti Dumnidzãlu a mortsãlor, ma Dumnidzãlu a yiilor. Ashã cã voi fãtsets cãbati.” ");
INSERT INTO rup_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Sh-un di scriblji tsi avea avdzãtã zburarea a lor, achicãsinda cã elu lã avea apãndisitã ghini, s-apruche sh-lu-ntribã: “Cai easti protlu di tuti ordinãrili?” ");
INSERT INTO rup_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Sh-Isusul apãndisi: “Protlu ordin a tutulor easti: ‘Ascultã Izrael! Domnul, Dumnidzãlu a nostru easti singur Domn.’ ");
INSERT INTO rup_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Shi ‘S-vrei Domnulu, Dumnidzãlu a tãu, cu tutã inima a ta, cu tutã suflitlu a tãu, cu tutã mintea a ta, sh-cu tutã putearea a ta!’ Aestã easti protlu ordin. ");
INSERT INTO rup_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Shi a doilu lji-undzeashti aishtui: ‘S-lu vrei aproapilu a tãu ca vetea a ta.’ Nu ari altã ordin ma marã di aestu.” ");
INSERT INTO rup_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Shi scriblu lji dzãsi: “Ghini, nvitsãtore. Ai dzãsã dupã alihea, cã ari singur un Dumnidzã sh-nu ari vãrã altu dicãt elu. ");
INSERT INTO rup_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Shi s-lu vrei cu tutã inima, cu tutã mintea, cu tutã suflitlu sh-cu tutã putearea, shi s-lu vrei aproapilu ca vetea a ta, ma multu di cãt olocaustlji sh-curbãnjilji.” ");
INSERT INTO rup_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Isusul vidzãnda cã atselu eara apãndisitã cu minti, lji dsãsi: “Tini nu eshti diparti di amirãriljea a Dumnidzãlui.” Sh-vãrã altã nu cutidzea s-lu ntriba. ");
INSERT INTO rup_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Sh-Isusul nvitsãnda tu templu, dsãsi: “Cum pot s-dzãc scriblji cã Hristolu easti Hiljilu al David? ");
INSERT INTO rup_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Cã mash Davidul, prit Suflitlu Sãmtu dsãsi: ‘Domnulu lji-dsãsi a Domnului a meu: “Shedz tu nandreapta a mea, pãn-cãndu s-lji facã neamitsilji a tãlji scamnã di cicioarili a tali.”’ ");
INSERT INTO rup_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Idhiul Davidul lu acljeamã Domn, cum poati elu s-hibã hiljilu a lui?” Sh-multsãmea lu avdza cu harauã. ");
INSERT INTO rup_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Sh-elu lã dsãtsea a lor tu nvitsãtura a lui: “Afirits-vã di scriblji, tsi arãsescu s-imnã cu stranji lundzi shi s-lji saluteadzã tu padi, ");
INSERT INTO rup_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","shi s-aibã protili locuri tu sinagogã sh-protili locuri uspetsi. ");
INSERT INTO rup_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Elji mãcã cãsili a veduvilor shi tra si s-veadã, s-pãrãcãlsescu multu. Elji va s-ljea un giudicari ma greu.” ");
INSERT INTO rup_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Isusul s-apunã nãinti di cutia a aishteariljei sh-mutrea oamnjili tsi bãga nãuntru denar, avutslji bãga nãuntru ma multu. ");
INSERT INTO rup_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Vini unã veduvã niavutã sh-bãgã doi pãradz njitsi, tsi fac un cuadrant. ");
INSERT INTO rup_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Sh-Isusul lji-acljimã ucenjitsili a lui ningã nãsu sh-lã dsãsi: “Vã dzãc dealihea cã aestã veduvã niavutã ari bãgat tu cutii ma multu di tuts alantsilji. ");
INSERT INTO rup_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Cã tuts bãgarã nãuntru dit primultulu a lor, ma ea cu ni-avearea a ljei bãgã tutã tsi avea di bãnari.” ");
INSERT INTO rup_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Cãndu elu ma ishea dit templu, un di ucenitsilji a lui lj-dsãsi: “Nvitsãtore, vedz tsi chetri shi tsi adãrãturi!” ");
INSERT INTO rup_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Sh-Isusul apãndisinda lj-dsãsi: “Li vedz aesti adãrãturi mãri? Nu va s-armãnã cheatrã pisti cheatrã ni dãrãmat.” ");
INSERT INTO rup_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Sh-dupã tsi elu eara apunat pri Muntili a Masnjilor nãinti a templui, Petrul, Iacovul, Ioanul shi Andrea lu ntribarã dinãparti: ");
INSERT INTO rup_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Dzã-nã, cãndu va s-facã aesti lucri sh-cai va s-hibã semnul a chirolu tsi tuti atseali lucri va s-facã?” ");
INSERT INTO rup_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Isusul apãndisinda a lor ahurhi s-dzãcã: “Bãgats mintea s-nu vã-arãdã vãrã. ");
INSERT INTO rup_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Cã va-s yinã multsã pi numa a mea dzãcãnda: ‘Mini escu Hristolu.’ Sh-va si s-arãdã multsã oaminji. ");
INSERT INTO rup_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ma cãndu s-avdzãts si zburãscu di alumti sh-di hãbãri di alumti, nu vã cutrimburats, cã aesti lucri prindi si s-adarã, ma nu va s-hibã bitisita. ");
INSERT INTO rup_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Va sã scoalã natsiunea contra a natsiunãljei, amirãriljea contra a amirãriljei, va s-facã cutremburi pri multi locuri, va s-aibã jali di pãni sh-mintituri. Atseli lucri va s-hibã ahurihirea a durearilor di amintari. ");
INSERT INTO rup_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Cãshtigats-vã ti bana a voastrã! Cã va vã prida la giudicãtorlji sh-va vã batã tu sinagogã. Va vã scoatã nãinti a guvernatorilor shi a amiradzilor trã itia a mea tsi s-mãrtirsits nãinti a lor. ");
INSERT INTO rup_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ma nãinti prindi tsi s-hibã predicatã evanghelul la tuts oamnjili. ");
INSERT INTO rup_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Cãndu va vã aducã s-vã prida, s-nu avets gaile di ma nãinti trã atsea tsi prindi s-dzãtsets shi s-nu minduits tsiva. Dzãtsets tsi vã yini tu minti tu oara atsea, cã nu hits voi tsi grits ma easti Duhlu Sãmtu. ");
INSERT INTO rup_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Tora fratili va prida fratilu a lui la moarti shi tatãlu hiljilu, sh-hiljilji va sã scoalã contra a pãrintsilor sh-va lã facã s-moarã. ");
INSERT INTO rup_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Voi va s-hits aurats di tuts trã itia a numãljei a mea, ma atselu tsi va s-aravdã pãnã tu soni, va s-hibã ascãpat.” ");
INSERT INTO rup_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Sh-cãndu s-u videts urãtsãmea a-aspãrgãturãljei tsi easti spusã di prufitul Daniel, tsi sta aclo iu nu prindi s-eara cai ghivãseashti s-aducheascã, atumtsea atselji tsi va s-hibã tu Iudea, s-fugã pri muntsã. ");
INSERT INTO rup_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Atselu tsi easti pri citia a casãljei, s-nu dipunã, sh-nitsi s-intrã tu casã di loari tsiva di la casa-a lui. ");
INSERT INTO rup_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Atselu tsi va s-hibã tu cãmpu, s-nu s-toarnã nãpoi di loari stranjilu a lui. ");
INSERT INTO rup_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Tora cavai di muljerili sãrtsinati sh-atseali cu njitsi tu sinã, tu atseali dzãli. ");
INSERT INTO rup_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Pãrãcãlsits-vã tsi fudzirea a voastrã s-nu hibã iarna. ");
INSERT INTO rup_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Cã tu atsea dzuã va s-hibã unã munduiri mari, ma mara dit apãrnjita a adrariljei a omlui tsi featsi Dumnidzãlu pãnã azã, sh-ahtari nu va s-aibã pute. ");
INSERT INTO rup_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Macã Domnulu nu va li-avea shcurtatã atseli dzãli, nitsiunu om nu va s-ascãpa, ma Domnulu li shcurtã atseali dzãli trã itia a aleptsilor tsi elu lã aleapsi. ");
INSERT INTO rup_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Atumtsea macã vãrã va vã-dzãcã: ‘Ia, Hristolu easti aoa’, icã: ‘Easti aclo’, nu lu pistipsitsã. ");
INSERT INTO rup_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Cã va s-easã hristoshi arãdioshi sh-prufits arãdioshi tsi va s-facã semnji shi thavmati tsi s-arãdã, ma s-poatã sh-aleptsãlji. ");
INSERT INTO rup_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ma voi bãgats minti! Ia, mini vã spushã ti itsido.” ");
INSERT INTO rup_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Tu atseali dzãli, dupã munduirea atsea, soarili va sã scutidiseascã sh-luna nu va s-da lunjina a ljei. ");
INSERT INTO rup_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Stealili a tserlui va s-cadã sh-puterili di tu tseruri va s-trundueascã. ");
INSERT INTO rup_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Atumtsea va lu veadã Hiljilu a omlui yininda pri niori, cu puteari mari sh-mãriri. ");
INSERT INTO rup_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Atumtsea elu va pitreacã anghilji a lui sh-va li-adunã aleptsãlji a lui dit patruli vimturi, dit mardzina a loclui pãnã tu mardzina a tserlui.” ");
INSERT INTO rup_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Tora achicãsits nvitsãtura a hiclui: cãndu dedzili a lui s-muljeadzã shi scoatã frãndzi, voi u shtits cã veara easti aproapi. ");
INSERT INTO rup_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ashã sh-voi, cãndu va videts cã ma s-facã aesti lucri, s-lu shtits cã Hiljilu a omlui easti aproapi, ningã ushã. ");
INSERT INTO rup_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Dealihea ma vã dzãc: cã aestã gheneratã nu va s-treacã, pãnã cãndu tuti aesti va s-hibã adrati. ");
INSERT INTO rup_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Tserlu sh-loclu va s-treacã, ma zboarili a meali nu va s-treacã.” ");
INSERT INTO rup_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Cãt di atsea dzuã sh-di atsea oarã, vãrã nu u shtii, nitsi anghilji dit tser, nitsi Hiljilu, ma mash Tatãlu. ");
INSERT INTO rup_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Bãgats minti, s-hits dishtiptat shi pãrãcãlsits-vã, cã nu shtits cãndu va s-hibã oara. ");
INSERT INTO rup_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Easti ca un om tsi nchisinda ti cali, alasi casa a lui shi da puteari a huzmichearilor a lui, cathiun tu loclu a lui, sh-portarlu lu urseashti s-hibã dishtiptat. ");
INSERT INTO rup_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Trã atsea stats dishtiptat, cã nu lu shtits cãndu va s-yinã domnulu ali casi, seara ma njeadzãnoapti, cãndu cãnti cucotulu, ma dimineatsa, ");
INSERT INTO rup_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","tsi turnãnda niashtãptat, s-nu vã aflã tu somn. ");
INSERT INTO rup_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Tora, aestã tsi vã dzãcã a voauã, lã-u dzãcã a tutulor: S-hits dishtiptat!” ");
INSERT INTO rup_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Dupã doauã dzãli eara Pashtili sh-Adzãmili, sh-ma mãrilji a preftsilor shi scriblji cãfta cum s-lu acãtsa Isusul cu ilei, shi s-lu vãtãma. ");
INSERT INTO rup_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ma dzãtsea: “Nu tu chirolu a sãrbãtoarãljei, tsi s-nu aibã mintiturã tu popul.” ");
INSERT INTO rup_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Isusul eara tu Betania, tu casa al Simon tsi eara lepros, sh-cãndu eara la measã intrã unã muljiear cu un vasã di alabastru cu untulem njiurizmos cu nard curat, multu scump sh-ea lu frãmsi vaslu di alabastru sh-lji lu-vãrsã untulemlu pri cap. ");
INSERT INTO rup_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Niscãntsã s-nãrãirã sh-dzãsirã: “Cãtse tutã aestã hãrgiuiri a untulemlui?” ");
INSERT INTO rup_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Cã aestu untulem putea s-vindea ma multu di trei suti di denari shi aesti si s-da a niavutsilor. Sh-eara nevrisits cu nãsu. ");
INSERT INTO rup_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ma Isusul dzãsi: “Alãsats-lu! Cãtse u munduits? Ea featsi un lucru bunã trã mini. ");
INSERT INTO rup_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Cã niavutsilji va lji avets totãna cu voi, sh-cãndu s-vrets, putets s-lã fãtsets ghini. Ma mini nu va mi-avets totãna. ");
INSERT INTO rup_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ea featsi atsea tsi putu, aumsi di ma nãinti truplu a meu trã ngrupari. ");
INSERT INTO rup_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Dealihea ma vã dzãcã cã tu tutã dunjeaua iutsido tsi va s-hibã predicat aestu evanghelu, va sã spunea shi atsea tsi ea featsi, trã adutsearea aminti a ljei.” ");
INSERT INTO rup_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Atumtsea Iuda Iscariotul, un di doisprãdzatsilji, s-dusi la mãrilji a preftsilor tsi s-prida Isusul. ");
INSERT INTO rup_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Sh-elji cãndu lu avdzãrã, s-hãrsirã sh-lji tãxirã cã va lji da pãradzi. Ashã elu cãfta oara tsi prindi trã pridari. ");
INSERT INTO rup_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Tu prota dzuã a Adzãmilor, cãndu s-featsi curbanlu a Pashtiljei ucenitsilji a lui dzãsirã: “Iu vrei s-nidzem s-adrãm di mãcari Pashtili?” ");
INSERT INTO rup_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Sh-elu pitricu doi di ucenjitsili a lui dzãcãnda: “Imnats tu cãsãbã sh-aclo va s-adunats un om tsi tsãni un stamnã plinã cu apã, urmats-lu atselu. ");
INSERT INTO rup_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Sh-aclo iu elu va s-intrã, dzãtsets-lji a domnului ali casi: ‘Nvitsãtorlu ntreabi: Iu easti udãlu tsi putem s-mãcãm Pashtili cu ucenitsilji a melji?’ ");
INSERT INTO rup_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Sh-elu va vã spunã nsus unã udã marã uidisitã sh-gata. Aclo etimãsits trã noi.” ");
INSERT INTO rup_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ucenitsilji a lui s-dusirã, agiumsirã tu cãsãbã aflarã ashã cum dzãsi elu, sh-etimãsirã Pashtili. ");
INSERT INTO rup_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Cãndu s-featsi searã, Isusul vini cu doisprãdzatsilji. ");
INSERT INTO rup_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Cãndu ma shidea la measã sh-ma mãca, Isusul dzãsi: “Dealihea vã dzãcã cã un di voi tsi ma mãcã cu mini, va mi vindã.” ");
INSERT INTO rup_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Atumtsea elji ahurhirã sã nvirineadzã sh-dzãtsea un cu alantu: “S-nu hiu mini?” Shi un altã dzãsi: “S-nu hiu mini?” ");
INSERT INTO rup_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Sh-elu, apãndisinda lã dzãsi a lor: “Easti un di doisprãdzatsilji tsi moalji cu mini tu cãtsãn. ");
INSERT INTO rup_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ma Hiljilu a omlui ma s-dutsi cum easti scriatã trã nãsu, ma cavai di atselu om tsi vindi Hiljilu a omlui. Va eara ma ghini trã nãsu, tsi atselu om s-nu eara amintat pute!” ");
INSERT INTO rup_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Sh-cãndu elji ma mãca, Isusul lo pãnea, u ghinicuvãntã, u pãrtsã, sh-lã-u deadi a lor dzãcãnda: “Loats sh-mãcats. Aestu easti truplu a meu.” ");
INSERT INTO rup_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Deapoea lo cupa, lu hãrãstãsi, lã-u deadi a lor sh-tuts biurã di nãsã. ");
INSERT INTO rup_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Atumtsea lã dzãsi: “Aestu easti sãndzilu a meu, a pisti-ligariljei, tsi s-vearsi trã multsã. ");
INSERT INTO rup_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Dealihea vã dzãcã cã nu va beau ma dit carpolu a ayinjiljei pãnã tu atsea dzuã cãndu va s-u beau di nou tu amirãriljea al Dumnidzãu.” ");
INSERT INTO rup_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Sh-dupã tsi cãntarã un himn, ishirã shi s-dusirã cãtrã Muntsili a Masnjilor. ");
INSERT INTO rup_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Isusul lã dzãsi a lor: “Voi tuts va s-vã scandalizats cu mini aestã searã, cã easti scriatã: ‘Va lu agudescã picurarlu sh-oili va s-arãspãndeascã.’ ");
INSERT INTO rup_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ma dupã tsi va mi-injedz, mini va mi duc nãinti di voi tu Galilea.” ");
INSERT INTO rup_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Sh-Petrul lji-dzãsi: “Ca s-hibã cã tuts alantsilji si scandalizeadz cu tini, mini nu va mi scandalizescu.” ");
INSERT INTO rup_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Sh-Isusul lji-dzãsi: “Mini ma ts-dzãcã dealihea cã azã, tu aeastã noapti, nãinti tsi cucotlu s-cãntã doauã ori, tini va mi alipideshti trei ori.” ");
INSERT INTO rup_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ma elu insistãnda, dzãtsea: “Sh-ca s-hibã cã prindi s-mor cu tini, nu va ti alipidescu pute.” Unã soi dzãsirã sh-tuts alantsilji. ");
INSERT INTO rup_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Deapoea agiumsirã la un loc tsi s-acljima Ghetsemani, sh-elu lã dzãsi a ucenitsilor a lui: “Apunats-vã aoa, pãnã cãndu mini s-hiu pãrãcãlsitã.” ");
INSERT INTO rup_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Sh-lo cu nãsu Petrul, Iacovul sh-Ioanul, sh-ahurhi s-aibã fricã sh-agonii. ");
INSERT INTO rup_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Sh-lã dãsi a lor: “Suflitlu a meu easti multu nvirinat, pãnã tu moarti, armãnets aoa shi s-hits dishtiptat.” ");
INSERT INTO rup_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Sh-cum s-dusi niheam nãinti, cãdzu pi dintsi shi s-pãrãcãlsea, tsi ma s-eara putut, s-fudzea di la nãsu aestã oarã. ");
INSERT INTO rup_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Sh-dzãsi: “Abba, Tate, itsido trã tini easti putut, dipãrteadz-lu di la mini aestã cupã. Ma nu atsea tsi voi mini, ma atsea tsi vrei tini!” ");
INSERT INTO rup_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Apoia s-turnã nãpoi, sh-lji aflã durnjinda sh-lji dzãsi a Petrului: “Simon ma dornji? Nu putush s-stai dishtiptat nitsi unã oarã? ");
INSERT INTO rup_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Armãnets dishtiptat sh-pãrãcãlsits-vã tsi s-nu intrats tu cãrteari. Duhlu easti etimu, ma truplu easti niputut.” ");
INSERT INTO rup_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","S-dipãrtã nãpoi shi s-pãrãcãlsi dzãcãnda idhiili zboari. ");
INSERT INTO rup_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Cãndu s-turnã, lã aflã nãpoi tu somn, cã ocljilji a lor eara greli sh-elji nu shtia tsi s-apãndisea. ");
INSERT INTO rup_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","S-turnã di a treia oarã sh-lã dzãtsi a lor: “Ninga ma durnjits sh-vã discurmats. Agiundzi, vini oara! Ia, Hiljilu a omlui ma s-prida tu mãnjili a amãrtioshilor. ");
INSERT INTO rup_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Sculats-vã, s-ni dutsem. Ia, atselu tsi ma mi prida easti aproapi!” ");
INSERT INTO rup_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Sh-tu atsea oarã, cãndu elu ninga ma grea, vini Iuda, un di doispridzatsilji, sh-cu nãsu unã multsãmi marã cu spãts sh-cu pãlenji, pitricut di mãrlji a preftsilor, di scriblji sh-di aushlji. ");
INSERT INTO rup_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Sh-elu tsi ma lu pridea lji avea datã a-lor un semn: “Atselu tsi va s-bashu, elu easti. Acãtsats-lu shi adutsets-lu cu mari cãshtigã.” ");
INSERT INTO rup_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Sh-cum agiumsi s-apruche trãoarã la nãsu sh-lji dzãsi: “Rabbi, Rabbi!” Sh-lu bãshe. ");
INSERT INTO rup_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Atumtsea elji bãgarã mãna pri nãsu sh-lu-acãtsarã. ");
INSERT INTO rup_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Un di atselji tsi s-alfa aclo, scoasi spata, agudi sclavlu a arhipreftului sh-lji tãlje ureaclja. ");
INSERT INTO rup_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Sh-Isusul apãndisinda, lã dzãsi: “Avets vinit cu spãts sh-cu pãlenji tsi s-mi acãtsats? ");
INSERT INTO rup_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Cathi dzuã earam namisa di voi tu templu nvitsãnda sh-voi nu mi acãtsat. Ma aestã s-fatsi tra si mplineascã Scriturili.” ");
INSERT INTO rup_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Atumtsea ucenitsilji lu alãsarã sh-fudzirã tuts. ");
INSERT INTO rup_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Sh-un tinir, tsi era anvãrtit cu un pãndzã pi truplu dispuljat ma lu urma, sh-elji lu acãtsarã. ");
INSERT INTO rup_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Elu u alãsã pãndza sh-fudzi dispuljat. ");
INSERT INTO rup_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Atumtsea elji lu dusirã Isusul la arhipreftlu iu s-adunarã mãrilji a preftsilor, aushlji shi scriblji. ");
INSERT INTO rup_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petrul lu urmã di diparti pãnã nãuntru tu pãlatlu a arhipreftului shi s-apunã aclo deadun cu vigljitorlji shi s-ncãldza ningã foc. ");
INSERT INTO rup_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Sh-mãrilji a preftsilor sh-tutã sinedrul cãfta mãrtirii contra al Isus s-lu vãtãma, ma nu ma afla. ");
INSERT INTO rup_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Multsã oaminj fãtsea mãrtirii arãdioasã contra a lui, ma mãrtiriili a lor nu s-uidisea. ");
INSERT INTO rup_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Atumtsea niscãntsã si scularã sh-mãrtirsirã cu ilei contra a lui dzãcãnda: ");
INSERT INTO rup_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Noi lu avem avdzãtã cã tsi ari dzãsã: ‘Mini va lu aspargã aestu templu adratã cu mãnji, sh-di trei dzãli va s-adarã un altu tsi nu easti faptã di oamnjilji.’” ");
INSERT INTO rup_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ma nits ti aestã mãrtiria a lor nu s-uidisea. ");
INSERT INTO rup_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Atumtsea si sculã arhipreftul namisa di cunvendã sh-lu ntribã Isusul dzãcãnda: “Nu apãndiseshti dip? Tsi ma mãrtirsescu aeshtã contra di tini?” ");
INSERT INTO rup_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ma elu pãpsi sh-nu apãndisi dip. Arhipreftul nãpoi lu ntribã sh-lji dzãsi: “Tini eshti Hristolu, Hiljilu a Ghinicuvãntatlui?” ");
INSERT INTO rup_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Sh-Isusul dzãsi: “Mini escu. Sh-voi va lu videts Hiljilu a omlui apunat tu nandreapta a Puteariljei shi vininda cu norilji a tserlui.” ");
INSERT INTO rup_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Atumtsea arhipreftul, arupãnda stranjili dzãsi: “Tsi ananghi avem ti mãrtirioshilji? ");
INSERT INTO rup_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Voi lu avdzãt blãstemlu, cum lu videts?” Sh-tuts lu giudicarã cu moarti. ");
INSERT INTO rup_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Sh-niscãntsã ahurhirã s-lu scuchea, s-lji anvãlea fatsa, shi s-lu agudea cu shupleacã shi s-lji dzãtsea: “Prufitipsea!” Sh-vigljitorlji lu agudea. ");
INSERT INTO rup_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Cãndu Petrul eara nghios tu ubor, vini un di huzmichearili a arhipreftului. ");
INSERT INTO rup_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Sh-cãndu vidzu Petrul tsi ma s-ncãldza, lu vidzu cu cãshtiga sh-lji dzãsi: “Sh-tini earai cu Isus Nazareas.” ");
INSERT INTO rup_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Petrul alipidãnda dzãsi: “Nu lu cunoscu, sh-nu achicãsescu tsi dzãtsi.” Deapoea ishi nafoarã tu intrata a uborlui sh-cucotlu cãntã. ");
INSERT INTO rup_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Sh-huzmicheara vidzãnda nãpoi ahurhi s-lã greascã atsilor tsi eara aclo: “Aestu easti di nãshi.” ");
INSERT INTO rup_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ma elu nãpoi u-ari alipidat. Sh-niheamã ma nãpoi oamnjili lji dzãsirã nãpoi a Petrului: “Dealihea tini eshti un di atselji, cã tini eshti Galilean sh-grearea a ta s-cunoashti.” ");
INSERT INTO rup_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ma elu ahurhi s-blastimã shi si spigiurã: “Mini nu lu cunoscu atselu om ti cai ma grits.” ");
INSERT INTO rup_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Sh-cucotlu cãntã di a doaua oarã. Atumtsea a Petrului lj-vini tu minti zborlu tsi Isusul lji avea dzãsã: “Ma nãinti tsi cucotlu s-cãntã di doauã ori, tini va mi aleapidz trei ori.” Sh-cum mindui aestã, plãmsi. ");
INSERT INTO rup_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Curund dimineatsa mãrilji a preftsilor cu aushilji, scriblji sh-tut Sinedriul fãtsea consiliu, u ligarã Isusul, lu dusirã nafoarã sh-lji-lu-deadirã al Pilat. ");
INSERT INTO rup_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Sh-Pilatul lu ntribã: “Tini eshti amirãlu a Iudeilor?” Sh-elu apãndisinda lji dzãsi: “Tini dzãts!” ");
INSERT INTO rup_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Mãrilji a preftsilor lu acuza di multi lucri, ma elu nu apãndisea dip. ");
INSERT INTO rup_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatul lu ntribã nãpoi dzãcãnda: “Nu apãndiseshti dip? Vedz ti cãti lucri ti acuzeascã!” ");
INSERT INTO rup_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ma Isusul nu apãndisi dip, sh-Pilatul armasi ciudisitã. ");
INSERT INTO rup_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Tu cathi sãrbãtoari eara ca adet tsi sãlãghea a lor un hãpsãnit, caitsido tsi populu cãfta. ");
INSERT INTO rup_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Sh-eara tu hapsi un om acljimatã Baraba, deadun cu sotsilji a lui rebilj, tsi avea faptã un vãtãmari la un ribiljusiri. ");
INSERT INTO rup_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Sh-multsãmea, aurlãnda, ahurhi tsi s-caftã s-facã ashã cum avea faptã totãna cu nãshi. ");
INSERT INTO rup_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Iarã Pilatul lã apãndisi a lor dzãcãnda: “Vrets s-vã sãlãghescu amirãlu a Iudenjilor?” ");
INSERT INTO rup_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Cã lu shtia tsi mãrilji a preftsilor lu avea pridatã di inati. ");
INSERT INTO rup_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ma mãrilji a preftsilor deadirã curaiu a multsãmiljei s-cãfta sãlãghirea al Baraba. ");
INSERT INTO rup_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Sh-Pilatul lo zborlu nãpoi sh-lã dzãsi a lor: “Tsi vrets s-fac cu atselu tsi voi lu acljimats amirãlu a Iudeilor?” ");
INSERT INTO rup_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Elji aurlarã nãpoi: “Crutsisits-lu!” ");
INSERT INTO rup_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Sh-Pilatul lã dzãsi a lor: “Ma tsi arãu ari faptã?” Atumtsea elji aurlarã sh-ma multu: “Crutsisits-lu?” ");
INSERT INTO rup_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Trã atsea Pilatul vrãnda s-lji arãsea a multsãmiljei, lã-u sãlãghi Baraba. Sh-dupã tsi zãpãlirã Isusul, lã-u deadir a lor tsi s-lu crutsisea. ");
INSERT INTO rup_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Sh-suldatsilji lu-dusirã Isusul tu uborlu di nãuntru, tu pretorium sh-adunarã tutã cohorta. ");
INSERT INTO rup_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Lu-nviscurã cu mitashi, lji mplãtirã unã cãruni di schinji sh-lji-u bãgarã pri capã ");
INSERT INTO rup_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Deapoea ahurhirã s-lu saluteascã, dzãcãnda: “Sãnãtati amirãlu a Iudeilor!” ");
INSERT INTO rup_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Sh-lu agudea pristi capã cu un cãlam, lu scuchea sh-dzinucljinda dininti a lui, lu alãvda. ");
INSERT INTO rup_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Dupã tsi arãsirã cu nãsu, lu disviscurã mitasha, lu nviscurã cu stranjili a lui, sh-lu scoasirã afoarã s-u crutsisea. ");
INSERT INTO rup_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Elji ursirã un cãlãtor, Simonul di Cirenea tsi s-turna dit agru, tatãlu al Alexandru sh-al Rufi, tsi s-lu tsãnea crutsea a lui. ");
INSERT INTO rup_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Deapoea lu dusirã Isusul tu loclu acljimatã Golgota, tsi va s-dzãcã “Loclu a Cafcãljei.” ");
INSERT INTO rup_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Lji deadirã s-bea yinã misticat cu njirã, ma elu nu u lo. ");
INSERT INTO rup_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Sh-dupã tsi lu crutsisirã, lji pãrtsãrã stranjili a lui sh-arcarã soarti tsi s-shtia tsi va avea cathiunu. ");
INSERT INTO rup_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Eara oara a treia cãndu lu crutsisirã. ");
INSERT INTO rup_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Scritura tsi spunea itia a cãtiĝurisiriljei tsi eara bãgatã pristi nãsu dzãtsea: “Amirãlu a Iudeilor.” ");
INSERT INTO rup_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Deadun cu nãsu crutsisirã doi furi, un tu nandreapta a lui sh-alantu tu nastãnga a lui. ");
INSERT INTO rup_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ashã si mplini Scritura tsi dzãtsi: “Elu s-luguri cu urutsilji.” ");
INSERT INTO rup_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Sh-atselji tsi tritsea atsia aproapi lu ngiura sh-giucãnda caplu, dzãtsea: “Tini tsi aspãrdzeai templu sh-lu adrai di trei dzãli, ");
INSERT INTO rup_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ascapã-ti sh-dipunã di crutsi.” ");
INSERT INTO rup_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Tutashã sh-mãrilji a preftsilor shi scriblji arãdãnda dzãtsea cu un alantu: “Alantsilji lã ascãpã, ma elu nu poati s-ascapã. ");
INSERT INTO rup_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Hristolu, amirãlu a Israelui, s-dipunã tora di crutsi tsi s-lu videm shi s-lu pistipsim.” Sh-atselji tsi eara crutsisit deadun cu nãsu, lu ngiura. ");
INSERT INTO rup_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Deapoea cãndu vini a shasea oarã, ntuneariclu amvãli tut loclu pãnã la a noaua oarã. ");
INSERT INTO rup_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Sh-la oara a noaua Isusul aurlã cu boatsi analtã: “Eloi, Eloi lama sabacthani?”, tsi va s-dsãcã: “Dumnidzãlu a meu, Dumnidzãlu a meu cãtse mi ai alãsat?” ");
INSERT INTO rup_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Sh-niscãntsã di atselji di aproapi, cãndu avdzãrã, dzãsirã: “Ia, elu ma greashti al Ilia!” ");
INSERT INTO rup_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Atumtsea un di nãshi vini trãoarã mulje un sfungar tu puscã, sh-dupã tsi u bãgã tu un cãlami lji-u deadi s-bea, dzãcãnda: “Alãsats-lu, s-videm macã va yinã Ilia s-lu dipun nghios.” ");
INSERT INTO rup_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ma Isusul cum featsi un sghileari mari deadi suflitlu. ");
INSERT INTO rup_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Sh-velul tu templu s-disicã pi dau di nsus pãnã nghios. ");
INSERT INTO rup_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Centurionul tsi stãtea nãinti al Isus, cãndu vidzu cã Isusul zghili ashã, sh-deadi suflitlu, dzãsi: “Dealihea aestu om eara Hiljilu a Dumnidzãlui!” ");
INSERT INTO rup_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Atsia eara tutashã sh-muljerili tsi videa di diparti. Namisa di nãsi eara Maria Magdalena sh-Maria, muma a Iacovul atsel njiclu sh-al Iose, sh-Salomeia, ");
INSERT INTO rup_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","tsi lu avea urmat sh-lji avea huzmitipsitã di cãndu eara tu Galile, eara sh-multi alti tsi avea vinit deadun cu elu tu Ieruzalem. ");
INSERT INTO rup_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Tora s-apruche seara, sh-eara Etimãsirea, tsi va s-dzãcã apirirea di Sãmbãtã, ");
INSERT INTO rup_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Iosif dit Arimatea, un consilier respectat, cai ashtipta amirãriljea a Dumnidzãlui, cu curaiu intrã la Pilatul shi cãftã truplu al Isus. ");
INSERT INTO rup_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Sh-Pilatul s-ciudisi tsi tora elu avea murit. Acljimã centurionlu sh-lu ntribã macã avea murit di mult chiro. ");
INSERT INTO rup_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Shi cum si siguripsi di centurionlu, lji lu alãsã truplu al Iosif. ");
INSERT INTO rup_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Aestu, dupã tsi acumpãrã unã pãndzã, lu dipunã Isusul di crutsi, lu amvãrti cu pãndzã sh-lu bãgã tu un murmintu tsi erea disfapt tu cheatrã, deapoea arucuti un cheatrã dininti di usha a murmintului. ");
INSERT INTO rup_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Sh-Maria Magdalena sh-Maria, muma al Iose mutrea iu lu bãgarã. ");
INSERT INTO rup_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Cum tricu Sãmbãta, Maria Magdalena sh-Maria, muma al Iacov, sh-Salomea, acumpãrarã njurizmati s-nidzea s-aundzea Isusul. ");
INSERT INTO rup_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Dimineatsa tu prota dzuã a stãmãnãljei, multu curund, eali vinirã la murmintu cãndu ma isha soarili. ");
INSERT INTO rup_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Sh-dzãtsea namisa di nãsi: “Cai va nã-u arucuteascã cheatra di la intrarea a murmintului?” ");
INSERT INTO rup_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ma cãndu scularã ocljilji, vidzurã cã cheatra eara arucutitã cu tutã cã eara multu mari. ");
INSERT INTO rup_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Intrarã la murmintu sh-vidzurã un tinir tsi eara apunat di nandreapta, nviscut cu albi, sh-armasirã aspãrati. ");
INSERT INTO rup_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ma elu lã dzãsi a lor: “Nu vã aspãrats! Voi cãftats Isus Nazareanul tsi eara crutsisitã, elu s-nyie, nu easti aoa. Ia, loclu iu eara bãgatã. ");
INSERT INTO rup_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Tora imnats s-lã-dzãtsets a ucenitsilor a lui sh-a Petrului cã elu ma s-dutsi dininti di voi tu Galilea, aclo va lu videts ashã cum vã dzãsi.” ");
INSERT INTO rup_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Sh-eali ishirã trãoarã sh-fudzirã dit murmintu cã li acãtsã cutremburlu sh-ciudia, sh-nu lji-dzãsirã tsiva a vãrui cã avea fricã. ");
INSERT INTO rup_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Tora Isusul dupã tsi eara nyeat dimineatsa tu prota dzuã a stãmãnãljei, s-fãnipsi prota ali Marii Magdalena, di la cai avea aĝunit shapti demonji. ");
INSERT INTO rup_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ea s-dusi sh-lu spusi a lor tsi eara deadun cu nãsã tsi vãita sh-plãndzea. ");
INSERT INTO rup_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ma aeshtsã cãndu avdzãrã cã eara yiu shi s-vidzu di ea nu lu pistipsirã. ");
INSERT INTO rup_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Dupã aesti lucri, s-fãnipsi tu unã altã formã a doilor di nãshi, tsi ma nidzea tu hoarã. ");
INSERT INTO rup_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Sh-elji s-dusirã sh-lu spusirã la alantsi, ma nitsi aeshti nu lu pistipsirã. ");
INSERT INTO rup_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tu soni s-fãnipsi a unsprãdzatsilor cãndu eara la measã sh-lji vãrghi trã nipistipsirea a lor sh-trã chitrisirea a inimãljei, cã nu avea pistipsitã la nãshi tsi lu avea vidzutã nyeat. ");
INSERT INTO rup_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Deapoea lã dzãsi a lor: “Nidzets tu tutã lumea sh-predicats evanghelul a tutulor. ");
INSERT INTO rup_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Atselu tsi pistipseashti shi s-pãteadzi, va s-hibã ascãpat. Ma atselu tsi nu ari pistipsit va s-hibã giudicat. ");
INSERT INTO rup_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Aesti sãntu semnili tsi va s-urmeadzã atselji tsi va s-pistipseascã: tu numa a mea elji va li aĝuneascã demonjilji sh-va s-greascã limbi nali, ");
INSERT INTO rup_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","va li acatsã cu mãna nãpãrtsili, sh-macã va s-bea tsiva ti muriri, nu va s-facã tsiva arãu, va s-bagã mãnjili pi lãndzitslji sh-aeshti va s-vindicã.” ");
INSERT INTO rup_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Domnul Isus, dupã tsi lã gri a lor, si sculã tu tser shi s-apunã tu nandreapta a Dumnidzãlui. ");
INSERT INTO rup_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Deapoea elji fudzirã sh-predicarã iutsido, iarã Domnul lucra deadun cu nãshi sh-alihipsea zborlu cu seamnili tsi lu urma. Amin.");
INSERT INTO rup_vpl VALUES ("T11_1","084_1_1","1TI","1","1","1","Pavlul, apostul al Isus Hristos, cu dimãndãciunea al Dumnidzãu, Ascãpãtorlu a nostru, sh-al Domnu Isus Hristos, tsi easti nãdia a noastrã, ");
INSERT INTO rup_vpl VALUES ("T11_2","084_1_2","1TI","1","2","2","al Timoteu, hiljilu a meu alihios tu pisti: Har, njilã sh-pace di la Dumnidzãlu Tatãl a nostru sh-di la Isus Hristos, Domnul a nostru. ");
INSERT INTO rup_vpl VALUES ("T11_3","084_1_3","1TI","1","3","3","Ashã cum ti pãrãcãlsii cãndu mi nchisii cãtrã Machidunii, shedz tu Efes s-dimãndzã niscãntsã oaminji tsi s-nu nveatsã ma nvitsãturi arãdioasi, ");
INSERT INTO rup_vpl VALUES ("T11_4","084_1_4","1TI","1","4","4","s-nu ascultã mituluyii sh-ghenealoghii tsi nu au bitisiri, tsi facã ncãceari ma multu dicãt nãintirea a faptilor a Dumnidzãlui sh-tsi s-andoapir tu pisti. ");
INSERT INTO rup_vpl VALUES ("T11_5","084_1_5","1TI","1","5","5","Nãetea aishtei dimãndãciuni easti vrearea di-la unã inimã curatã, di-la unã conshtintsã chischinã sh-di-la unã pisti fãrã ipucrizii. ");
INSERT INTO rup_vpl VALUES ("T11_6","084_1_6","1TI","1","6","6","Niscãntsã, cara s-dipãrtarã di aesti lucri, s-turnarã la zboari goali. ");
INSERT INTO rup_vpl VALUES ("T11_7","084_1_7","1TI","1","7","7","Elji vor s-hibã nvitsãtori a legiljei, ma nu aduchescu nitsi atseali tsi dzãc, nitsi atseali tsi spun cu sigurantsã. ");
INSERT INTO rup_vpl VALUES ("T11_8","084_1_8","1TI","1","8","8","Sh-noi shtim cã legea easti bunã, macã omlu u foloseashti cum prindi. ");
INSERT INTO rup_vpl VALUES ("T11_9","084_1_9","1TI","1","9","9","Noi shtim, cã legea nu easti faptã ti ndreptul, ma ti atselji tsi ncalcã legea, trã-ribeljilji, trã atselji fãrã-dumnidzã, trã amãrtioshlji, trã nisãmtsãlji sh-lãvoshilji, trã atselji tsi vatãmã tatãl sh-muma, trã vãtãmãtorlji, ");
INSERT INTO rup_vpl VALUES ("T11_10","084_1_10","1TI","1","10","10","trã curvarilji, trã homosexualjilji, trã arãchitorilji a oamnjilor, trã arãditorilji, trã atselji tsi ncalcu spigiurarea, sh-trã caitsido altu tsi easti contra a nvitsãturãljei atsiljei sãnãtoasã. ");
INSERT INTO rup_vpl VALUES ("T11_11","084_1_11","1TI","1","11","11","Aestã nvitsãturã easti dupã Evanghelul a mãririljei a ghinicuvãntatlui Dumnidzã tsi nji si pistipsi a njia. ");
INSERT INTO rup_vpl VALUES ("T11_12","084_1_12","1TI","1","12","12","Mini hãristisescu Hristolu Isus Domnul a nostru, tsi nji deadi fuchii, cã mi aflã axiu trã pistipsiri, sh-mi bãgã tu lucru. ");
INSERT INTO rup_vpl VALUES ("T11_13","084_1_13","1TI","1","13","13","Cu tutã cã cama nãniti earam blãstimãtor, avinãtor sh-tiran, Dumnidzãlu nji deadi njilã, cã li fãtseam di nishtirea sh-nipistipsirea a mea. ");
INSERT INTO rup_vpl VALUES ("T11_14","084_1_14","1TI","1","14","14","Harea a Domnului a nostru nji si deadi cu artirsiri deadun cu pistipsirea sh-vrearea tu Isus Hristos. ");
INSERT INTO rup_vpl VALUES ("T11_15","084_1_15","1TI","1","15","15","Aestu zbor easti pistipsit sh-axiu ti aprucheari didip: Hristolu Isus vini tu lumi ti ascãpari amãrtioshlji, di la cai mini escu protlu. ");
INSERT INTO rup_vpl VALUES ("T11_16","084_1_16","1TI","1","16","16","Trã atsea mi njiluii mini ca protlu a amãrtioshilor, tsi Isus Hristolu s-aspunã ma nãinti tu mini tutã arãvdarea a lui, tsi s-earam ca urnechi trã atselji tsi va s-pistipseascã tu nãsu trã bana eternã. ");
INSERT INTO rup_vpl VALUES ("T11_17","084_1_17","1TI","1","17","17","Trã atsea a Amirãlui eternu, nimuritlu, nividzutlu, singurlu Dumnidzã, s-lji hibã tinjii sh-mãriri tu eta a etilor! Amen. ");
INSERT INTO rup_vpl VALUES ("T11_18","084_1_18","1TI","1","18","18","Ma ts-u pistipsescu aestã dimãndãciuni, hiljiu a meu Timote, dupã prufitipsirili tsi s-featsirã ma nãinti trã tini, tsi dupã atseali s-fatsã alumta atsea buna, ");
INSERT INTO rup_vpl VALUES ("T11_19","084_1_19","1TI","1","19","19","tsãnãnda pistea sh-unã conshtintsã bunã. Niscãntsã alipidãnda, cãdzurã di pistea a lor. ");
INSERT INTO rup_vpl VALUES ("T11_20","084_1_20","1TI","1","20","20","Di aeshti suntu Imeneu sh-Alexandrul, tsi mini lji pridedu tu mãnjili a Satanlui tsi s-nveatsã s-nu blastimã. ");
INSERT INTO rup_vpl VALUES ("T12_1","084_2_1","1TI","2","1","1","Tsã fac rigeai nãinti di tuti, si s-facã spigiurari, rugãciunji, interviniri sh-hãristisiri trã tuts oaminjilji, ");
INSERT INTO rup_vpl VALUES ("T12_2","084_2_2","1TI","2","2","2","trã amiradzlji sh-trã tuts atselji cai suntu tu puteari, tra s-putem s-tritsem unã banã arihãtipsitã sh-tu pace cu itsi dumnidzãsiri sh-tinjii. ");
INSERT INTO rup_vpl VALUES ("T12_3","084_2_3","1TI","2","3","3","Aestã easti bunã sh-arisitã nãintea al Dumnidzãu, Ascãpãtorlu a nostru. ");
INSERT INTO rup_vpl VALUES ("T12_4","084_2_4","1TI","2","4","4","Elu va tsi tuts oamnjilji si ascapã shi s-agiungã la cunushtearea a alihiljei. ");
INSERT INTO rup_vpl VALUES ("T12_5","084_2_5","1TI","2","5","5","Un easti Dumnidzãlu, sh-un singur easti misitlu ntrã Dumnidzãlu sh-oamnjilji: Hristolu Isus om, ");
INSERT INTO rup_vpl VALUES ("T12_6","084_2_6","1TI","2","6","6","tsi deadi bana ca arãscumpãrari trã tuts, ca mãrtirii tu chirolu tsi prindi. ");
INSERT INTO rup_vpl VALUES ("T12_7","084_2_7","1TI","2","7","7","Trã atsea mini mi bãgarã predicãtor sh-apostul – dzãc alihea, nu arãd – nvitsãtor la pãngãnjilji tu pisti sh-tu alihea. ");
INSERT INTO rup_vpl VALUES ("T12_8","084_2_8","1TI","2","8","8","Voi, tsi bãrbatslji s-pãrãcãlsescã iutsido, sculãnda mãnjili atseali curati, fãra nãriri sh-fãrã ngrãnji. ");
INSERT INTO rup_vpl VALUES ("T12_9","084_2_9","1TI","2","9","9","Tutashã, voi tsi sh-muljerili si nveascã cu simplitati, cu tãpinii sh-cu tinjii, sh-nu cu cusitsi sh-cu furii, cu mãrgãritãri sh-cu stranji scumpi, ");
INSERT INTO rup_vpl VALUES ("T12_10","084_2_10","1TI","2","10","10","ma cu fapti buni, cum lã-au hari a muljerilor tsi suntu spigiurati la Dumnidzãu. ");
INSERT INTO rup_vpl VALUES ("T12_11","084_2_11","1TI","2","11","11","Muljearea s-nveatsã tu tãtseari, sh-cu sumbãgari trã tuti. ");
INSERT INTO rup_vpl VALUES ("T12_12","084_2_12","1TI","2","12","12","Mini nu u alasã muljearea tsi s-nveatsã, sh-nitsi s-aibã autoritati pristi bãrbatlu, ma si sta tãcutã. ");
INSERT INTO rup_vpl VALUES ("T12_13","084_2_13","1TI","2","13","13","Cã ma nãinti s-featsi Adamlu, sh-deapoea Eva. ");
INSERT INTO rup_vpl VALUES ("T12_14","084_2_14","1TI","2","14","14","Sh-nu s-arãsi Adamlu, ma muljearea s-arãsi sh-cãdzu tu amãrtii. ");
INSERT INTO rup_vpl VALUES ("T12_15","084_2_15","1TI","2","15","15","Cu tutã atsea ea va si-ascapã prit amintarea a cilimenjilor, macã ea va armãnã tu pisti, tu vreari sh-tu sãmtãtsiri cu tãpinii. ");
INSERT INTO rup_vpl VALUES ("T13_1","084_3_1","1TI","3","1","1","Aestu zbor easti pistipsit: Macã vãrã va si s-facã episcop, lucru bun va. ");
INSERT INTO rup_vpl VALUES ("T13_2","084_3_2","1TI","3","2","2","Lipseashti tsi episcoplu s-hibã fãrã cusuri, bãrbat a unei singur muljeari, mintimen, misurat, respectat, oaspitor, cãdãr s-nveatsã sh-altsã, ");
INSERT INTO rup_vpl VALUES ("T13_3","084_3_3","1TI","3","3","3","s-nu hibã datã dupã yinlu, s-nu hibã violent, ma s-hibã arãvdãtor, s-nu hibã gindãvos, s-nu hibã tãmãchear a pãradzilor. ");
INSERT INTO rup_vpl VALUES ("T13_4","084_3_4","1TI","3","4","4","Elu prindi s-hibã om tsi u nicuchireashti ghini casa a lui sh-prindi s-aibã cilimenjilji ursits sh-cu multu respect. ");
INSERT INTO rup_vpl VALUES ("T13_5","084_3_5","1TI","3","5","5","Cã macã vãrã nu shtii s-nicuchireascã casa a lui, cum va s-aibã cãshtigã ti bisearica a Dumnidzãlui? ");
INSERT INTO rup_vpl VALUES ("T13_6","084_3_6","1TI","3","6","6","Episcoplu s-nu hibã macãt-turnat tu pisti, tra s-nu lji creascã mintea shi s-cadã tu pozita a cãtãdzicãsiriljei a draclui. ");
INSERT INTO rup_vpl VALUES ("T13_7","084_3_7","1TI","3","7","7","Elu prindi s-aibã mãrtirii bunã di la atselji di nafoarã, tsi s-nu cadã tu rushinari shi s-nu s-acatsã tu laclu a draclui. ");
INSERT INTO rup_vpl VALUES ("T13_8","084_3_8","1TI","3","8","8","Tutashã diaconjili prindi s-hibã cu tinjii, nu cu doauã fãts, s-nu si s-da dup multu yin, s-nu hibã tãmãchear di amintatic ni-ndreptu. ");
INSERT INTO rup_vpl VALUES ("T13_9","084_3_9","1TI","3","9","9","Elji prindi s-tsãnã cu conshtintsã curatã mistiryiul a pistiljei. ");
INSERT INTO rup_vpl VALUES ("T13_10","084_3_10","1TI","3","10","10","Aeshti si s-bãgã ma nãinti tu provã, deapoea s-facã huzmitipsirea a lor macã suntu fãrã cusuri. ");
INSERT INTO rup_vpl VALUES ("T13_11","084_3_11","1TI","3","11","11","Muljerili a lor s-hibã tinjisiti, nu munafitsi, ma misurati sh-pistimeni tu itsido. ");
INSERT INTO rup_vpl VALUES ("T13_12","084_3_12","1TI","3","12","12","Diaconjilji s-hibã bãrbatsilji a unei singur muljeari, s-lã nicuchireascã ghini cilmenjilji sh-alants oaminji ali fumelji. ");
INSERT INTO rup_vpl VALUES ("T13_13","084_3_13","1TI","3","13","13","Cã atselji tsi au faptã ghini diaconia, amintã numã bunã shi mari sigurantsã tu pistea al Isus Hristos. ");
INSERT INTO rup_vpl VALUES ("T13_14","084_3_14","1TI","3","14","14","Ma ts-li scriu aesti lucri cã am nãdii cã va yinã trãoarã la tini, ");
INSERT INTO rup_vpl VALUES ("T13_15","084_3_15","1TI","3","15","15","ma, ma mi amãnai, sã shtii cã cum oamnjilji prindi si s-poartã tu casa al Dumnidzãu, cã voi crishtinjilji hits bisearica a Dumnidzãlui atsilui yiulu, colona shi thimeljiu a alihiljei. ");
INSERT INTO rup_vpl VALUES ("T13_16","084_3_16","1TI","3","16","16","Shi fãrã shubei cã mistiryiul a pistiljei easti mari: Hristolu s-fãnirusi tu trup, s-ndriptã tu Duh, s-aspusi la anghilji, s-ghinihãbãrsi la pãngãnjilji, s-pistipsi tu lumi, s-anãltsã tu mãriri. ");
INSERT INTO rup_vpl VALUES ("T14_1","084_4_1","1TI","4","1","1","Duhlu dzãtsi curat, cã tu chirolu di soni niscãntsã va u aleapidã pistea, sh-va urmeadzã duhurili arãdioasi shi nvitsãturili a demonjilor. ");
INSERT INTO rup_vpl VALUES ("T14_2","084_4_2","1TI","4","2","2","Atselji nveatsã arãdearili cu ipucrizii, sh-au conshtintsã moartã, sh-arsã cu her ardios. ");
INSERT INTO rup_vpl VALUES ("T14_3","084_4_3","1TI","4","3","3","Elji va curmu nsurarea shi va s-vã urseascã s-nu mãcats niscãnti di mãcãrili tsi Dumnidzãlu adrã si s-ljea cu hãristisiri di atselji tsi pistipsescu shi l-cunoscu alihea. ");
INSERT INTO rup_vpl VALUES ("T14_4","084_4_4","1TI","4","4","4","Cã itsi fãpturã a Dumnidzãlui easti bunã sh-tsiva nu easti ti arucari, macã s-ljea cu hãristisiri, ");
INSERT INTO rup_vpl VALUES ("T14_5","084_4_5","1TI","4","5","5","cã easti sãmtsãsitã prit zborlu a Dumnidzãlui sh-prit pãrãcãlsirea. ");
INSERT INTO rup_vpl VALUES ("T14_6","084_4_6","1TI","4","6","6","Macã lã-li nvetsi aesti lucri a fratsilor sh-a surãrilor, tini va s-hii un huzmichear bun al Isus Hristos, hrãnit cu zboarili a pistiljei sh-a nvitsãturãljei atsiljei buni, tsi urmeshti. ");
INSERT INTO rup_vpl VALUES ("T14_7","084_4_7","1TI","4","7","7","Dipãrteadzã-ti di pãrãvuliili zurliti sh-prufani, shi nveatsã-ti tu dumnidzãsiri, ");
INSERT INTO rup_vpl VALUES ("T14_8","084_4_8","1TI","4","8","8","cã talimea a truplui easti ti putsãn chiro axiu, ma dumnidzãsirea easti axiu ti itsido, cã ari tãxirea a banãljei di tora sh-atsiljei tsi va yinã. ");
INSERT INTO rup_vpl VALUES ("T14_9","084_4_9","1TI","4","9","9","Aestu zbor easti pistipsit sh-axiu di apruchiari didip. ");
INSERT INTO rup_vpl VALUES ("T14_10","084_4_10","1TI","4","10","10","Trã-aestã, noi ma lucrãm multu shi alumtãm, cã avem nãdãit la Dumnidzãlu atsel yiulu, tsi easti Ascãpãtorlu a tuts oamnjilor, sh-ma multu a pistimenjilor. ");
INSERT INTO rup_vpl VALUES ("T14_11","084_4_11","1TI","4","11","11","Ursea aesti shi nvetsã-li aesti lucri. ");
INSERT INTO rup_vpl VALUES ("T14_12","084_4_12","1TI","4","12","12","Vãrã s-nu u atimuseascã tinireatsa a ta atsea noaua, ma fã-ti exemplu di pistimenji tu zbor, tu purtari, tu vreari, tu pisti sh-tu chischineatsã. ");
INSERT INTO rup_vpl VALUES ("T14_13","084_4_13","1TI","4","13","13","Bagã mintea la ghivãsirea discljisã a Scriturãljei, la urnipsirea shi la nvitsãturã pãnã s-yinã mini. ");
INSERT INTO rup_vpl VALUES ("T14_14","084_4_14","1TI","4","14","14","Nu lalasã dupã mãnã doara tsi ts-easti datã prit prufitipsiri, cu bãgarea a mãnjilor pri tini di-la aushlji. ");
INSERT INTO rup_vpl VALUES ("T14_15","084_4_15","1TI","4","15","15","Minduia-ti di aesti shi s-armãnji didip tu aesti, tsi nãintarea a ta s-hibã vidzut di tuts. ");
INSERT INTO rup_vpl VALUES ("T14_16","084_4_16","1TI","4","16","16","Afirea-ti tini sh-nvitsãtura a ta, veaglji aesti lucri, cã, fãcãnda ashãtsi, va s-ascachi bana a ta shi atselji tsi ti ascultã. ");
INSERT INTO rup_vpl VALUES ("T15_1","084_5_1","1TI","5","1","1","Nu vãrghea cu aspru un aush, ma urnipsea-lu ca tatãli a tãu, sh-ma tinirlji ca frats, ");
INSERT INTO rup_vpl VALUES ("T15_2","084_5_2","1TI","5","2","2","moashili ca muma, fetili ca surãri cu chischineatsã. ");
INSERT INTO rup_vpl VALUES ("T15_3","084_5_3","1TI","5","3","3","Tinjisea veduvili tsi suntu tu ananghi. ");
INSERT INTO rup_vpl VALUES ("T15_4","084_5_4","1TI","5","4","4","Macã unã veduvã ari ficiori sh-nipots, aeshti s-nveatsã ma nãinti sã spunã dumnidzãsirea cãtrã atselji di casa a lor shi s-tinjiseascã pãrintsãlji a lor, cã aestã easti arãsitã nãintea a Dumnidzãlui. ");
INSERT INTO rup_vpl VALUES ("T15_5","084_5_5","1TI","5","5","5","Shi atsea tsi easti dealihea veduvã sh-ari armasã singur, nãdãeashti la Dumnidzãlu shi armãni tu spigiurari shi tu rugãciunji noapti sh-dzuã. ");
INSERT INTO rup_vpl VALUES ("T15_6","084_5_6","1TI","5","6","6","Iarã atsea tsi bãneadzã nifrãnat, cu tutã cã bãneadzã, easti moartã. ");
INSERT INTO rup_vpl VALUES ("T15_7","084_5_7","1TI","5","7","7","Dimãndã-lã sh-aesti, tsi nitsiunã s-nu hibã cu cusuri. ");
INSERT INTO rup_vpl VALUES ("T15_8","084_5_8","1TI","5","8","8","Macã vãrã nu s-cãshtigheadzi di oamnjilji a lui, sh-ma multu di atselji a casãljei a lui, elu u ari alipidat pistea shi easti ma arãu di un nipistimen. ");
INSERT INTO rup_vpl VALUES ("T15_9","084_5_9","1TI","5","9","9","Unã veduvã si s-registreadzã tu lista a veduvilor, ma s-hibã nu ma noauã di shaidzãtsi di anji, shi s-aibã avutã un singur bãrbat. ");
INSERT INTO rup_vpl VALUES ("T15_10","084_5_10","1TI","5","10","10","Ea s-aibã mãrtirii trã fapti buni, tsi ari criscutã cilimenjilji a ljei, ari ashtiptatã xenjilji, ari aspilatã cicioarili a sãmtsãlor, ari agiutat niavutslji, shi easti puituitã dipriunã cu itsido lucru bunã. ");
INSERT INTO rup_vpl VALUES ("T15_11","084_5_11","1TI","5","11","11","Ma nu aproachi veduvili ma nali, cã, cãndu va si s-da dupã vrearili a lor, va s-arniseascã Hristolu sh-va caftã si s-mãritã. ");
INSERT INTO rup_vpl VALUES ("T15_12","084_5_12","1TI","5","12","12","Deapoea ljea pri nãsi giudicata, cã au ncãlcat pistea di prota. ");
INSERT INTO rup_vpl VALUES ("T15_13","084_5_13","1TI","5","13","13","Meti eali si nveatsã s-hibã timbeli imnãnda casã di casã, sh-nu mash timbeli, ma sh-dãrdãroasi zburãnda di geaba. ");
INSERT INTO rup_vpl VALUES ("T15_14","084_5_14","1TI","5","14","14","Trã atsea, voi tsi veduvili atseali nali si s-mãritã, s-aibã cilimenji, si s-facã nicuchiri a cãsilor shi s-nu da a contrarlui vãrã itii trã greari ti arãu, ");
INSERT INTO rup_vpl VALUES ("T15_15","084_5_15","1TI","5","15","15","cã niscãnti tora s-turnarã s-urmeadzã Satanlu. ");
INSERT INTO rup_vpl VALUES ("T15_16","084_5_16","1TI","5","16","16","Macã vãrã pistimen ari veduvi trã cãshtigari, s-li agiutã shi s-nu si facã sartsinã a bisearicãljei, tsi bisearica s-poatã s-agiutã atseli tsi suntu tu ananghi. ");
INSERT INTO rup_vpl VALUES ("T15_17","084_5_17","1TI","5","17","17","Aushilji tsi chiverniseascã ghini lucrili a bisearicãljei, si s-tinjiseascã di doauã ori, ma multu atselji tsi s-apustusescu cu predicari sh-cu nvitsari. ");
INSERT INTO rup_vpl VALUES ("T15_18","084_5_18","1TI","5","18","18","Cã Scritura dzãtsi: “Nu lji leagã gura a boului cãndu alunseashti tu grãnar,” shi: “Lucrutorlu u ari cu dhichi paga a lui.” ");
INSERT INTO rup_vpl VALUES ("T15_19","084_5_19","1TI","5","19","19","Nu aproachi nitsi unã acuzã contra un aush, mash cãndu ari doi icã trei martiri. ");
INSERT INTO rup_vpl VALUES ("T15_20","084_5_20","1TI","5","20","20","Iarã atselji tsi amãrtisescu vãrghea-lji nãintea a tutulor, tsi sh-alantsãlji s-au fricã. ");
INSERT INTO rup_vpl VALUES ("T15_21","084_5_21","1TI","5","21","21","Mini ti spigiurã nãintea a Dumnidzãlui, al Hristos Isus sh-a anghiljilor atsilor aleptsã, tsi s-li fatsã aesti dimãndãciuni fãrã pri-giudicari, shi nu fã tsiva cu hãtãri. ");
INSERT INTO rup_vpl VALUES ("T15_22","084_5_22","1TI","5","22","22","Nu aĝunjiseati s-badzã mãnjili la varã tsi su numeshti trã huzmitipsiri shi nu ti fã urtac tu amãrtiili altsilor. Veaglji-ti chischin! ");
INSERT INTO rup_vpl VALUES ("T15_23","084_5_23","1TI","5","23","23","Nu bea mash apã, ma ljea putsãn yin di stomaclu a tãu sh-di lãngoarili a tali atseli multi. ");
INSERT INTO rup_vpl VALUES ("T15_24","084_5_24","1TI","5","24","24","La niscãntsã oaminji amãrtiili s-veadã lishor sh-imnã nãintea a lor tu giudicatã, iarã la altsã s-veadã ma napoi. ");
INSERT INTO rup_vpl VALUES ("T15_25","084_5_25","1TI","5","25","25","Tutashã, sh-faptili atseali buni s-ved, ma sh-atseali tsi suntu nividzuti nu pot s-armãnã ascumti. ");
INSERT INTO rup_vpl VALUES ("T16_1","084_6_1","1TI","6","1","1","Tuts tsi sãntu sum giuglu a sclãvililjei si lji lugurseascã nicuchirlji a lor axii ti itsi tinjii, tsi numa a Dumnidzãlui sh-nvitsãtura a noastrã nu si s-ngiurã. ");
INSERT INTO rup_vpl VALUES ("T16_2","084_6_2","1TI","6","2","2","Shi atselji tsi li au nicuchirlji pistimenji, s-nu lji atimuseascã cã sãntu frats, ma s-lã servireascã sh-ma ghini, cã atselji tsi au hãiri di lucrul a lor sãntu pistimenji sh-vruts. Nveats-lã aeasti lucri sh-dimãndã-lã. ");
INSERT INTO rup_vpl VALUES ("T16_3","084_6_3","1TI","6","3","3","Macã vãrã nveatsã unã nvitsãturã altã shi nu ascultã zboarili atseali sãnãtoasi a Domnului a nostru Isus Hristos sh-nvitsãtura dupã dumnidzãsirea, ");
INSERT INTO rup_vpl VALUES ("T16_4","084_6_4","1TI","6","4","4","elu easti fudul shi nu shtii tsiva. Elji va ma multu debatsili shi ncãcearili cu zboari, di-la cai s-amintã zilia, ncãcearea, ngiurãrili, shubeili atseli arãli, ");
INSERT INTO rup_vpl VALUES ("T16_5","084_6_5","1TI","6","5","5","debatsili di geaba a oamnjilor cu minti asparti shi guliti di alihea, tsi minduescã cã dumnidzãsirea easti trã amintari. ");
INSERT INTO rup_vpl VALUES ("T16_6","084_6_6","1TI","6","6","6","Ma dumnidzãsirea adutsi un mari amintatic, macã omlu s-hãrseashti cu atsea tsi ari. ");
INSERT INTO rup_vpl VALUES ("T16_7","084_6_7","1TI","6","7","7","Cã noi nu avem adus tsiva tu aestã dunjauã, sh-nu va-lom tsiva cu noi. ");
INSERT INTO rup_vpl VALUES ("T16_8","084_6_8","1TI","6","8","8","Macã avem s-mãcãm shi s-nã nvishtem, s-himã hãrãstisitã cu aestã. ");
INSERT INTO rup_vpl VALUES ("T16_9","084_6_9","1TI","6","9","9","Ma atselji tsi vor si s-facã avuts, cad tu cãrteari, tu cearc sh-tu multi orixi ni-minduiti sh-zãrãsiti, tsi li afundusescu oaminjilji tu cãdeari sh-aspãrdzeari. ");
INSERT INTO rup_vpl VALUES ("T16_10","084_6_10","1TI","6","10","10","Cã vrearea di pãradzi easti rãdãtsina a tut arãlilor, shi avãnda orixi multã, niscãntsi s-dipãrtarã di pisti sh-pãtsãrã multi dureari. ");
INSERT INTO rup_vpl VALUES ("T16_11","084_6_11","1TI","6","11","11","Ma tini, omlu a Dumnidzãlui, dipãrteadzã-ti di aesti sh-urmeadzã ndriptatea, dumnidzãsirea, pistea, vrearea, arãvdarea shi muljeatsa-a-inimãljei. ");
INSERT INTO rup_vpl VALUES ("T16_12","084_6_12","1TI","6","12","12","Alumtã-ti trã alumta atsea buna a pistãljei. Ambratsãsea bana eternã, tu cai ti acljimarã sh-trã cai ai datã bunã mãrtirii trã pistea nãintea a mults martirii. ");
INSERT INTO rup_vpl VALUES ("T16_13","084_6_13","1TI","6","13","13","Ma ti spigiurã nãinti a Dumnidzãului, cai da banã a tutulor shi nãinti a Hristolui Isus, tsi deadi unã mãrtirii bunã nãintea al Pontius Pilat, ");
INSERT INTO rup_vpl VALUES ("T16_14","084_6_14","1TI","6","14","14","s-lu veaglji aestã dimãndãciuni fãrã damcã sh-cusuri, pãnã cãndu s-aspunã Domnul a nostru Isus Hristos. ");
INSERT INTO rup_vpl VALUES ("T16_15","084_6_15","1TI","6","15","15","Elu tu chirolu tsi lipseashti va si s-aspunã di Dumnidzãlu, ghinicuvãntatlu shi singurlu Domnitor, Amirãlu a amirãrilor shi Domnul a domnilor. ");
INSERT INTO rup_vpl VALUES ("T16_16","084_6_16","1TI","6","16","16","Elu singur u ari nimurirea shi sta tu lunjinã niaprucheatã, tsi nitsiun nu u ari vidzutã pute shi nu poati s-u veadã. Atsilui s-lji hibã tinjia shi putearea eternã! Amen. ");
INSERT INTO rup_vpl VALUES ("T16_17","084_6_17","1TI","6","17","17","Dimãndã-lã avutslji a lumiljei aishtei s-nu hibã pirifanj, shi s-nu nãdãeascã la ayishtearea tsi easti nisigur, ma tu Dumnidzãlu, tsi nã da cu multeatsã itsido s-nã hãrseascã. ");
INSERT INTO rup_vpl VALUES ("T16_18","084_6_18","1TI","6","18","18","Dimãndã s-facã ghinetsi, si s-facã avuts cu fapti buni, s-hibã giumertsã sh-etinji trã dari, ");
INSERT INTO rup_vpl VALUES ("T16_19","084_6_19","1TI","6","19","19","adunãnda ca ayishteari un bun thimeljiu trã yinitura, tsi s-agiundzemu bana alihioasã. ");
INSERT INTO rup_vpl VALUES ("T16_20","084_6_20","1TI","6","20","20","Timote, veaglji atsea tsi tsã s-ari pistipsitã, firinda di zboarili atseali di geaba sh-lumeshti sh-di cuntrãrili atsiljei tsi cu nindriptati (gabimisht) s-acljeami shtiintsã, ");
INSERT INTO rup_vpl VALUES ("T16_21","084_6_21","1TI","6","21","21","tsi lu ambrãtsisirã niscãntsi shi ishirã di pisti. Harul s-hibã cu voi!");
INSERT INTO rup_vpl VALUES ("T21_1","085_1_1","2TI","1","1","1","Pavlul, apostulu al Isus Hristos prit vrearea a Dumnidzãlui, trã bana tãxit prit pistea tu Hristolu Isus, ");
INSERT INTO rup_vpl VALUES ("T21_2","085_1_2","2TI","1","2","2","al Timoteu, hiljilu a meu vrut: Har, njilã sh-pace di la Dumnidzãu Tatãl, shi di la Hristolu Isus, Domnul a nostru. ");
INSERT INTO rup_vpl VALUES ("T21_3","085_1_3","2TI","1","3","3","Hãristisescu Dumnidzãlu, a cui lj-huzmitipsescu ashã ca ntãnjilji a melji cu conshtincã curatã, tsi fãrã pãpsiri ti aduc aminti tu pãrãcãlsirili a meali, noaptea sh-dzua. ");
INSERT INTO rup_vpl VALUES ("T21_4","085_1_4","2TI","1","4","4","Cãndu aduc aminti lãcrinjili a tali, am multu dor s-ti ved tra s-mi umplu cu harauã, ");
INSERT INTO rup_vpl VALUES ("T21_5","085_1_5","2TI","1","5","5","cã aduc aminti pistea atsea alihioasa tsi easti tu tini, cai ma nãinti eara la maia a ta Loida sh-la muma a ta Euniche sh-escu sigur cã easti sh-la tini. ");
INSERT INTO rup_vpl VALUES ("T21_6","085_1_6","2TI","1","6","6","Ti aestu motiv ma ts-u tãcãnescu, s-u dishteptsi doara al Dumnidzãu tsi easti tu tini cu bãgarea a mãnjilor a meali. ");
INSERT INTO rup_vpl VALUES ("T21_7","085_1_7","2TI","1","7","7","Cã Dumnidzãlu nu nã deadi Duhlu tsi nã da fricã, ma Duhlu tsi nã da fuchii, vreari sh-frunimeatsã. ");
INSERT INTO rup_vpl VALUES ("T21_8","085_1_8","2TI","1","8","8","S-nu ai arushãni s-mãrtirseshtã Domnul a nostru, sh-di mini, hãpsãnitlu a lui, ma munduia-ti deadun cu mini ti evanghelul dupã putearea a Dumnidzãlui. ");
INSERT INTO rup_vpl VALUES ("T21_9","085_1_9","2TI","1","9","9","Elu nã ascãpã shi nã acljimã cu unã acljimari sãmtã, nu dupã faptili a noastri, ma dupã scupolu a lui sh-dupã harlu, tsi nã si deadi tu Hristolu Isus nãinti di ahurhita a chirolui. ");
INSERT INTO rup_vpl VALUES ("T21_10","085_1_10","2TI","1","10","10","Tora s-fãnirusi prit aspunearea a Ascãpãtorlui a nostru Isus Hristos, tsi dãrãmã moartea shi scoasi tu lunjinã bana sh-nimurirea prit evanghelul, ");
INSERT INTO rup_vpl VALUES ("T21_11","085_1_11","2TI","1","11","11","trã atsel, mini mi bãgarã predicãtor, apostul shi nvitsãtor. ");
INSERT INTO rup_vpl VALUES ("T21_12","085_1_12","2TI","1","12","12","Di idyia itii mini ma mi munduescu sh-di aesti, ma nu am arushãni, cã shtiu la cai am pistipsitã sh-escu sigur cã elu poati s-u veaglji atsea tsi nj-ari pistipsitã pãnã tu atsea dzuã. ");
INSERT INTO rup_vpl VALUES ("T21_13","085_1_13","2TI","1","13","13","Tsãn-lu modelu a zboarilor atseali buni, tsi avdzãsh di la mini cu pisti sh-vreari, tsi suntu tu Hristolu Isus. ");
INSERT INTO rup_vpl VALUES ("T21_14","085_1_14","2TI","1","14","14","Veaglji ayishtearea atsea buna tsi s-pistipsi a tsãia prit Duhlu Sãmtu tsi bãneadzi tu noi. ");
INSERT INTO rup_vpl VALUES ("T21_15","085_1_15","2TI","1","15","15","Tini lu shtii cã tuts atselji tsi suntu tu Asia nji turnarã plãtãrili, sh-namisa di elji Fighelul sh-Hermogenul. ");
INSERT INTO rup_vpl VALUES ("T21_16","085_1_16","2TI","1","16","16","Domnulu s-lji da njilã a casãljei a Onesiforlui, cã di multi ori nj-deadi curaiu sh-nu avu arushãni di prãnghili a meali. ");
INSERT INTO rup_vpl VALUES ("T21_17","085_1_17","2TI","1","17","17","Shi, cãndu vini la Roma, mi cãftã multu pãnã-cãndu mi aflã. ");
INSERT INTO rup_vpl VALUES ("T21_18","085_1_18","2TI","1","18","18","Domnulu s-lji da s-aflã njilã di partea a Domnului tu dzua a lui. Tini lu shtii multu ghini cãt agiutari nji featsi tu Efes. ");
INSERT INTO rup_vpl VALUES ("T22_1","085_2_1","2TI","2","1","1","Tini, hiljilu a meu, nvãrtusheati tu harul tsi easti tu Hristolu Isus, ");
INSERT INTO rup_vpl VALUES ("T22_2","085_2_2","2TI","2","2","2","sh-atseali tsi avdzãsh di la mini nãintea a multsor martirii, dã-li la oaminji pistimenji, tsi va s-poatã s-nveatsã sh-altsã. ");
INSERT INTO rup_vpl VALUES ("T22_3","085_2_3","2TI","2","3","3","Tini mpartsã-li cu mini munduirili, ca un suldat bun al Isus Hristos. ");
INSERT INTO rup_vpl VALUES ("T22_4","085_2_4","2TI","2","4","4","Cã nitsiunu di atselji tsi s-ducã suldat nu s-minteashti cu lucrili a banãljei, tsi s-lji arãseascã atsilui tsi lu-ari loatã tu armatã. ");
INSERT INTO rup_vpl VALUES ("T22_5","085_2_5","2TI","2","5","5","Tutashã, macã vãrã ljea parti tu arenã ca dalagãtor, nu si ncuruneadzi ma s-nu aibã alãgatã dupã regulili a gioclui. ");
INSERT INTO rup_vpl VALUES ("T22_6","085_2_6","2TI","2","6","6","Agricultorlu tsi lucreadzã multu prindi s-lu ljea protlu birichetlu. ");
INSERT INTO rup_vpl VALUES ("T22_7","085_2_7","2TI","2","7","7","Minduia trã atseali tsi tsã dzãc, cã Domnul va tsã da minti trã tuti. ");
INSERT INTO rup_vpl VALUES ("T22_8","085_2_8","2TI","2","8","8","Adu aminti tsi Isus Hristolu, di fara a Davidului, s-nyie dit mortsã, dupã evanghelul a meu, ");
INSERT INTO rup_vpl VALUES ("T22_9","085_2_9","2TI","2","9","9","trã cai mini ma mi munduescu pãnã tu prãnghi ca un arãu-fãcãtor. Ma zborlu a Dumnidzãlui nu s-leagã cu prãnghi. ");
INSERT INTO rup_vpl VALUES ("T22_10","085_2_10","2TI","2","10","10","Trã atsea mini li aravdu tuti trã itia a aleptsilor, tsi elji s-aibã ascãparea tsi easti tu Hristolu Isus, deadun cu mãrirea eternã. ");
INSERT INTO rup_vpl VALUES ("T22_11","085_2_11","2TI","2","11","11","Aestu zbor easti pistipsit, cã: Macã noi murim cu nãsu, sh-va s-bãnãm cu nãsu. ");
INSERT INTO rup_vpl VALUES ("T22_12","085_2_12","2TI","2","12","12","Macã noi arãvdãm, va s-domnim deadun cu nãsu. Macã va lu alipidãm, sh-elu va nã aleapid. ");
INSERT INTO rup_vpl VALUES ("T22_13","085_2_13","2TI","2","13","13","Macã him nipistimenji, elu armãni pistimen. Cã elu nu poati s-aleapid bãnaticlu a lui. ");
INSERT INTO rup_vpl VALUES ("T22_14","085_2_14","2TI","2","14","14","Adu-lã aminti atsilor aesti lucri, spigiurãnda nãintea a Domnului s-nu sã ncaci cu zboari, cã nu axizeashti shi fatsi arãu atsilor tsi avdu. ");
INSERT INTO rup_vpl VALUES ("T22_15","085_2_15","2TI","2","15","15","Bagã mintea s-eshi nãintea a Dumnidzãlui ca om aprovat, ca lucrutor tsi nu ari cãtse si arushuneadzã, cã dzãtsi ndreptu zborlu a alihiljei. ");
INSERT INTO rup_vpl VALUES ("T22_16","085_2_16","2TI","2","16","16","Afirea-ti di zboarãli atseli goali, tsi li dipãrteadzã oamnjilji ma multu di Dumnidzãlu. ");
INSERT INTO rup_vpl VALUES ("T22_17","085_2_17","2TI","2","17","17","Nvitsãtura a lor va sã scurpiseascã ca unã cangrenã. Di aeshti suntu Himeneul sh-Filetul. ");
INSERT INTO rup_vpl VALUES ("T22_18","085_2_18","2TI","2","18","18","Elji s-dipãrtarã di alihea, dzãcãnda cã nyiearea easti faptã shi rãstoanã pistea a niscãntsãlor. ");
INSERT INTO rup_vpl VALUES ("T22_19","085_2_19","2TI","2","19","19","Cu tut atsea, thimeljilu atsel vãrtoslu a Dumnidzãlui sta niminat, sh-ari aestã vulã: “Domnul lji cunoashti atselji tsi suntu a lui,” shi: “Caitsido tsi acatsi n-gurã numa a Hristolui s-dipãrteadzã di arãutatea.” ");
INSERT INTO rup_vpl VALUES ("T22_20","085_2_20","2TI","2","20","20","Tu unã casã mari nu ari mash vasi di furii sh-di asimi, ma sh-di lemnu sh-di lut, nãscãnti trã tinjisiri, alantili nu trã tinjisiri. ");
INSERT INTO rup_vpl VALUES ("T22_21","085_2_21","2TI","2","21","21","Macã vãrã s-cãtãrseashti di aesti lucri, va hibã un vasu di tinjii, sãmtãsit sh-lipsit di Mastru, etimãsit di itsi lucru bun. ");
INSERT INTO rup_vpl VALUES ("T22_22","085_2_22","2TI","2","22","22","Dipãrteadz-ti di orixile a tinireatsãljei sh-duti dupã ndriptatea, dupã pistea, dupã vrearea sh-dupã pacea, deadun cu atselji tsi acljeamã Domnul cu inimã curatã. ");
INSERT INTO rup_vpl VALUES ("T22_23","085_2_23","2TI","2","23","23","Afireati tutashã di cuvendzãli atseali glari sh-fãrã minti, shtiinda cã atseali aducã ncãceari. ");
INSERT INTO rup_vpl VALUES ("T22_24","085_2_24","2TI","2","24","24","Cã huzmichearlu a Domnului nu prindi si s-ncaci, ma s-hibã moali cu tuts, axiu s-nveatsã oaminjilji sh-arãvdãtor. ");
INSERT INTO rup_vpl VALUES ("T22_25","085_2_25","2TI","2","25","25","S-nveatsã cu muljeatsã contrarãlji, cu nãdii cã Dumnidzãlu lã da a lor mitãnjiusirea tsi s-agiungã s-cunoascã alihea, ");
INSERT INTO rup_vpl VALUES ("T22_26","085_2_26","2TI","2","26","26","shi s-yinã tu minti, ascãpãnda di cearcul a dracului, tsi lã ari acãtsat roghi s-fac vrearea a lui. ");
INSERT INTO rup_vpl VALUES ("T23_1","085_3_1","2TI","3","1","1","Prindi s-u shtii aestã: tu dzãlili di ma nãpoi va yinã chiro greu. ");
INSERT INTO rup_vpl VALUES ("T23_2","085_3_2","2TI","3","2","2","Oaminjilji va hibã egoishtsi, tãmãcheari di pãradz, alãvdãtori, pirifanji, blãstimãtori, niascultãtori a pãrintsãlor, aharishti a buneatsãljei, nipistimenji, ");
INSERT INTO rup_vpl VALUES ("T23_3","085_3_3","2TI","3","3","3","ni-durutsi, ni-puitiutsi, zburãtori, ni-tsãnutsi, cãtilji, tsi nu l-vor buna, ");
INSERT INTO rup_vpl VALUES ("T23_4","085_3_4","2TI","3","4","4","prudotsi, cap-groshi, fudulji, cheflii ma multu di cãt dumnidzescu. ");
INSERT INTO rup_vpl VALUES ("T23_5","085_3_5","2TI","3","5","5","Atselji suntu dumnidzescu tu videari, ma alipidats a puteariljei a Dumnidzãlui. Sh-di aeshti dipãrteadz-ti. ");
INSERT INTO rup_vpl VALUES ("T23_6","085_3_6","2TI","3","6","6","Cã di la aeshti suntu atselji tsi intrã pri cãsi shi li arãdã muljerili atseli ngãrcati cu amãrtii, apucati di orixi soi di soi. ");
INSERT INTO rup_vpl VALUES ("T23_7","085_3_7","2TI","3","7","7","Elji nveatsã totãna, ma pute nu poatã s-agiungu la cunushtearea a alihiljei. ");
INSERT INTO rup_vpl VALUES ("T23_8","085_3_8","2TI","3","8","8","Shi ashã cum Iannes sh-Iambresul lu cuntrarã Moisiul, ashã shi aeshti nvitsãtori s-cuntreadzã a alihiljei, suntu oaminji mintiaspartã, sh-arnisits tu pisti. ");
INSERT INTO rup_vpl VALUES ("T23_9","085_3_9","2TI","3","9","9","Ma aeshti nu va neagã multu nãinti, ashã cum lã undzi sh-atsilor doi, cã zurleatsa-a lor va s-easã tu-padi sh-va s-veadã di tutsã. ");
INSERT INTO rup_vpl VALUES ("T23_10","085_3_10","2TI","3","10","10","Sh-tini lu urmash di-aproapi nvitsãtura a mea, purtarea, scupolu, pistea, arãvdarea, vrearea, insistarea, ");
INSERT INTO rup_vpl VALUES ("T23_11","085_3_11","2TI","3","11","11","avinãrili, munduirili tsi pãtsãi tu Antiochi, tu Iconio, sh-tu Listra. Tini shtii tsi priaĝuniri tricui, ma Dumnidzãlu mi ascãpã di tuti. ");
INSERT INTO rup_vpl VALUES ("T23_12","085_3_12","2TI","3","12","12","Sh-tuts atselji tsi vor s-bãneadzã cu dumnidzãsiri tu Hristolu Isus va s-priaĝuneascã, ");
INSERT INTO rup_vpl VALUES ("T23_13","085_3_13","2TI","3","13","13","ma oaminjilji atselji arãilji sh-arãdzãtorlji va si s-ducã arãu sh-ma arãu, arãdzãnda altsãlji sh-mintea a lor. ");
INSERT INTO rup_vpl VALUES ("T23_14","085_3_14","2TI","3","14","14","Ma tini armãnã tu atseali tsi nvitsash sh-ti cãndãrsish didip, shtiinda di la cai li nvitsashã. ");
INSERT INTO rup_vpl VALUES ("T23_15","085_3_15","2TI","3","15","15","Di cu ficiureatsã lcunoshti Sãmtili Scrituri, tsi pot s-ti facã shtiut trã ascãparea prit pistipsirea tsi easti tu Hristolu Isus. ");
INSERT INTO rup_vpl VALUES ("T23_16","085_3_16","2TI","3","16","16","Tutã Scritura easti insuflat di Dumnidzãlu sh lipsit trã nvitsari, cãndãrsiri, ndridzeari sh-educatsii ti ndriptati, ");
INSERT INTO rup_vpl VALUES ("T23_17","085_3_17","2TI","3","17","17","tsi omlu a Dumnidzãlui s-hibã perfectu, sh-itimãsit ti itsi faptu bun. ");
INSERT INTO rup_vpl VALUES ("T24_1","085_4_1","2TI","4","1","1","Ma ti spigiur, nãintea a Dumnidzãlui sh-a Hristolui Isus, tsi yini trã giudicari yiilji sh-mortsãlji, tu fãnirusirea a lui sh-tu amirãriljea a lui. ");
INSERT INTO rup_vpl VALUES ("T24_2","085_4_2","2TI","4","2","2","Preadicã zborlu, insisteadzã cu chiro sh-fãrã chiro, ndreadzã sh-vãrghea, urnipsea sh-nveatsã cu arãvdari. ");
INSERT INTO rup_vpl VALUES ("T24_3","085_4_3","2TI","4","3","3","Cã va s-yinã chirolu cãndu oaminjilji nu va u aravdã nvitsãtura atsea buna, ma, dupã capriciulu a lor, va s-adunã anvãrliga a lor buluchi di nvitsãtori trã gãdãlicari urecljili ");
INSERT INTO rup_vpl VALUES ("T24_4","085_4_4","2TI","4","4","4","sh-va li dipãrteadzã urecljili di alihea shi va li-aducã cãtrã pãrãvuliili. ");
INSERT INTO rup_vpl VALUES ("T24_5","085_4_5","2TI","4","5","5","Ma tini stãi cu minta alimtã tu itsido, aravdã munduirili, fã lucrul a evanghelistului sh-mplineadz tut huzmitipsirea a ta. ");
INSERT INTO rup_vpl VALUES ("T24_6","085_4_6","2TI","4","6","6","Iarã mini ma mi versu ca biuturã cãtrã Dumnidzãlu, sh-chirolu a nchisirãljei a mea agiumsi. ");
INSERT INTO rup_vpl VALUES ("T24_7","085_4_7","2TI","4","7","7","Alumta atsea buna u alumtai, u bitisii dalãgãtura, sh-u vigljeai pistea. ");
INSERT INTO rup_vpl VALUES ("T24_8","085_4_8","2TI","4","8","8","Dupã aestã mi ashteapti curuna a ndriptatiljei tsi Domnul, Giudicãtorlu atsel ndreptu, va nji-u da atsea dzuã, sh-nu mash a njia, ma sh-a tuts tsi ashteptu cu dor fãnirusirea a lui. ");
INSERT INTO rup_vpl VALUES ("T24_9","085_4_9","2TI","4","9","9","Aĝunjisea-ti s-yinji trãoarã la mini, ");
INSERT INTO rup_vpl VALUES ("T24_10","085_4_10","2TI","4","10","10","cã Dima mi apãrãtsi, cã vrea aestã dunjauã, sh-fudzi Sãruna. Creshentul s-dusi tu Galatia, sh-Titul tu Dalmatsia. ");
INSERT INTO rup_vpl VALUES ("T24_11","085_4_11","2TI","4","11","11","Cu mini easti mash Luca, ljea-lu Marculu sh-adu-lu cu tini, cã nj-easti multu di ofil tu huzmitipsiri. ");
INSERT INTO rup_vpl VALUES ("T24_12","085_4_12","2TI","4","12","12","Tichicul lu pitricui tu Efes. ");
INSERT INTO rup_vpl VALUES ("T24_13","085_4_13","2TI","4","13","13","Cãndu s-yinj, adu cu tini mantelul tsi lu alãsai tu Troadã tu Carpul, sh-cãrtsili, ma multu pergamenili. ");
INSERT INTO rup_vpl VALUES ("T24_14","085_4_14","2TI","4","14","14","Alexandru, cãldãrarlu, nji featsi multi arãi. Domnul s-lji-u arãsplãteascã dupã faptili a lui. ");
INSERT INTO rup_vpl VALUES ("T24_15","085_4_15","2TI","4","15","15","Afirea-ti sh-tini di nãsu, cã ncuntrã multu zboarili a noastri. ");
INSERT INTO rup_vpl VALUES ("T24_16","085_4_16","2TI","4","16","16","La apãrarea a mea atsea di prota tu giudic vãrã nu eara cu mini, ma tuts mi apãrãtsirã. Aestã s-nu si s-numirã di cãbati. ");
INSERT INTO rup_vpl VALUES ("T24_17","085_4_17","2TI","4","17","17","Ma Domnul stãtu ningã mini sh-nji deadi fuchii, tsi prit mini predicarea a evanghelui s-eara mplinitã shi s-lu avdza tuts pãngãnjilji. Mini ascãpai di gura a ljiundarlui. ");
INSERT INTO rup_vpl VALUES ("T24_18","085_4_18","2TI","4","18","18","Sh-Domnul va mi ascapã di itsi lucru arãu tra s-mi ducã tu amirãriljea a lui tsereascã. Mãriri atsilui tu eta a etilor! Amin. ");
INSERT INTO rup_vpl VALUES ("T24_19","085_4_19","2TI","4","19","19","Sãnãtati a Prishilãljei sh-al Acuila sh-a casiljei al Onesifor. ");
INSERT INTO rup_vpl VALUES ("T24_20","085_4_20","2TI","4","20","20","Erastul armasi tu Corintu, sh-Trofimul lu alãsai niputut tu Miletu. ");
INSERT INTO rup_vpl VALUES ("T24_21","085_4_21","2TI","4","21","21","Aĝunjisea-ti s-yinj nãintea a iarnãljei. Tsã pitrec sãnãtati Eubulu, Pudentu, Linu, Claudia sh-tuts fratsilji sh-surãrili. ");
INSERT INTO rup_vpl VALUES ("T24_22","085_4_22","2TI","4","22","22","Domnul s-hibã cu duhlu a tãu! Harul s-hibã cu voi!");
INSERT INTO rup_vpl VALUES ("TT1_1","086_1_1","TIT","1","1","1","Pavlul, servitorlu a Dumnidzãlui sh-apostulu al Isus Hristos. Mini escu aleptu sh-pitricut s-agiutã pistea a oamnjilor aleptsã a Dumnidzãlui sh-elji s-cunuoascã alihea tsi ti dutsi tu dumnidzãsiri. ");
INSERT INTO rup_vpl VALUES ("TT1_2","086_1_2","TIT","1","2","2","Atumtsea elji va aibã nãdia a banãljei eternã, tsi Dumnidzãlu, tsi nu arãdi, u tãxi nãinti di ahurhita a etilor, ");
INSERT INTO rup_vpl VALUES ("TT1_3","086_1_3","TIT","1","3","3","sh-tu chirolu tsi prindi lu aspusi zborlu a lui prit predicarea tsi nji si pistipsi a njia prit ordinlu a Dumnidzãlui, Ascãpãtorlu a nostru. ");
INSERT INTO rup_vpl VALUES ("TT1_4","086_1_4","TIT","1","4","4","Cãtrã Titi, hiljilu a meu alihios tu pistea a noastrã: Har, njilã sh-pace di la Dumnidzãlu, Tatãl, sh-di la Domnul Isus Hristos, Ascãpãtorlu a nostru! ");
INSERT INTO rup_vpl VALUES ("TT1_5","086_1_5","TIT","1","5","5","Trã aestã ti alãsai tu Cretã, tsi tini s-ndredzi lucrili tsi au armasã ni adrati, sh-tu cathi cãsãbã s-badzi aushi cum ti ursii. ");
INSERT INTO rup_vpl VALUES ("TT1_6","086_1_6","TIT","1","6","6","Cathiun di elji s-hibã nivãrghit, bãrbat a unei singur muljeari, s-aibã cilimenji pistimenji, shi s-nu hibã acuzatsi ti banã disfãrnatã sh-niascultatã. ");
INSERT INTO rup_vpl VALUES ("TT1_7","086_1_7","TIT","1","7","7","Cã episcoplu, ca administratorlu a casãljei a Dumnidzãlui, prindi s-hibã nivãrghit, nu fudul, nu inãtos, nu dat dupã yinlu, sh-nu om tsi imni dupã amintatic arushinos. ");
INSERT INTO rup_vpl VALUES ("TT1_8","086_1_8","TIT","1","8","8","Ma s-hibã oaspitat, ghinivoitor, dishtiptat, ndreptu, sãmtu, shi nfãrnat. ");
INSERT INTO rup_vpl VALUES ("TT1_9","086_1_9","TIT","1","9","9","Elu prindi s-tsãnã zborlu a pistiljei ashã cum lj-easti nvitsat, s-hibã ghini-pistipsit cu nvitsãtura atsea alihioasa sh-axiu s-cãndãrseascã atselji tsi grescu condra. ");
INSERT INTO rup_vpl VALUES ("TT1_10","086_1_10","TIT","1","10","10","Cã suntu multsã, sh-ma multsãlji di atselji tsi suntu turnat dit pistea a uvreilor, suntu nicãndãrsits, zburãtori sh-arãditori. ");
INSERT INTO rup_vpl VALUES ("TT1_11","086_1_11","TIT","1","11","11","Atsilor prindi s-lã si ncljidã gura cã minteascã fumealji ntredzi, nvitsãnda atseali tsi nu prindi, trã amintatic arushinos. ");
INSERT INTO rup_vpl VALUES ("TT1_12","086_1_12","TIT","1","12","12","Un di nãshi, prufitlu Cretan, dzãsi: “Cretanjilji suntu totãna arãdioshi, agrinji arãi sh-pãntic-timbel!” ");
INSERT INTO rup_vpl VALUES ("TT1_13","086_1_13","TIT","1","13","13","Aestã mãrtirii easti alihioasã. Trã atsea, vãrghea-lji cu aspru, tra s-hibã sãnãtoshi tu pisti, ");
INSERT INTO rup_vpl VALUES ("TT1_14","086_1_14","TIT","1","14","14","shi s-nu ascultã pãrãvuliili a Iudeilor sh-dimãndãrili a oamnjilor, tra si s-dipãrteadzã di alihea. ");
INSERT INTO rup_vpl VALUES ("TT1_15","086_1_15","TIT","1","15","15","Tuti suntu curati trã atselji tsi suntu curats, ma trã lãvoshlji sh-trã atselji tsi nu pistipsescu, tsiva nu easti curatã. Meti, sh-mintea sh-conshtintsa a lor suntu lãvoasi. ");
INSERT INTO rup_vpl VALUES ("TT1_16","086_1_16","TIT","1","16","16","Elji mãrtirsescu cã lu cunoscu Dumnidzãlu, ma cu faptili a lor lu arniseascã, cã suntu aĝnusitsi, nicãndãrsitsi sh-anaxii trã itsi lucru bun. ");
INSERT INTO rup_vpl VALUES ("TT2_1","086_2_1","TIT","2","1","1","Ma tini nveatsã a alantsãlor atsea tsi easti idyea cu nvitsãtura atsea sãnãtoasã: ");
INSERT INTO rup_vpl VALUES ("TT2_2","086_2_2","TIT","2","2","2","Aushilji s-hibã dishteptsã, tinjisits, froninji, sãnãtoshi tu pisti, tu vreari sh-tu arãvdari. ");
INSERT INTO rup_vpl VALUES ("TT2_3","086_2_3","TIT","2","3","3","Tutashã, nveats-lã a moashilor s-aibã purtari cum lã ari hari a sãmtsãlor, nu munafitsi, nu sclayii a multului yin, ma nvitsãtoari a ghiniljei. ");
INSERT INTO rup_vpl VALUES ("TT2_4","086_2_4","TIT","2","4","4","Eali s-nveatsã nveastili atseali nali s-vor bãrbatsãlji a lor sh-hiljilji a lor, ");
INSERT INTO rup_vpl VALUES ("TT2_5","086_2_5","TIT","2","5","5","s-hibã fronimi, curati, acãtsati cu lucrili a casãljei, buni cãtrã altsã, cãndãrsiti a bãrbãtsilor a lor, tsi zborlu a Dumnidzãlui s-nu si s-ngiurã. ");
INSERT INTO rup_vpl VALUES ("TT2_6","086_2_6","TIT","2","6","6","Urnipsea-lji tutashã tinirlji tra s-hibã misurats. ");
INSERT INTO rup_vpl VALUES ("TT2_7","086_2_7","TIT","2","7","7","Aspunã la itsido modelul a lucrilor buni: La nvitsãturã s-hits curats sh-tinjisits, ");
INSERT INTO rup_vpl VALUES ("TT2_8","086_2_8","TIT","2","8","8","s-avets unã zburari sãnãtoasã sh-fãrã cusuri, tsi contrarlu s-rushineadzã shi s-nu poatã s-greascã tsiva arãu trã voi. ");
INSERT INTO rup_vpl VALUES ("TT2_9","086_2_9","TIT","2","9","9","Nveats-lã sclayilji s-hibã sumbãgats a nicuchirilor a lor tu itsi lucru, s-lã hibã ghini-arãsit tu itsido, ni grãitã condra. ");
INSERT INTO rup_vpl VALUES ("TT2_10","086_2_10","TIT","2","10","10","Elji s-nu furã atsea tsi nu easti a lor, ma s-hibã ghini-pistipsit, tsi tu itsido s-fac arãsit nvitsãtura a Dumnidzãlui, Ascãpãtorlu a nostru. ");
INSERT INTO rup_vpl VALUES ("TT2_11","086_2_11","TIT","2","11","11","Cã harul ascãpãtor a Dumnidzãlui s-fãnirusi tsi s-aducã ascãparea trã tuts oamnjilji. ");
INSERT INTO rup_vpl VALUES ("TT2_12","086_2_12","TIT","2","12","12","Harul a lui nã nveatsi s-alipidãm nipistipsirea sh-orixili a lumiljei, cã noi bãnãm cu tãpinii, cu ndriptati sh-cu dumnidzãsiri tu aestã etã, ");
INSERT INTO rup_vpl VALUES ("TT2_13","086_2_13","TIT","2","13","13","ashtiptãnda nãdia atsea ghinicuvãntata sh-fãnirusirea multu-mãritã a marilui Dumnidzã shi a Ascãpãtorlui a nostru Isus Hristos. ");
INSERT INTO rup_vpl VALUES ("TT2_14","086_2_14","TIT","2","14","14","Elu u deadi bana a lui trã noi, s-nã arãscumpãrã di itsi lucru fãrã di lege shi s-curã trã nãsu un popul aleptu, sh-etimu tu fapti buni. ");
INSERT INTO rup_vpl VALUES ("TT2_15","086_2_15","TIT","2","15","15","Nveats-lã aesti lucri la altsã, urnipsea sh-vãrghea cu cathi puteari! Vãrã s-nu ti dispretsueascã. ");
INSERT INTO rup_vpl VALUES ("TT3_1","086_3_1","TIT","3","1","1","Adu-lã aminti atsilor tsi s-hibã sumbãgats a protsãlor sh-a autoritãtsilor, s-hibã cãndãrsits, etinji trã itsi faptã bunã, ");
INSERT INTO rup_vpl VALUES ("TT3_2","086_3_2","TIT","3","2","2","s-nu hibã munafitsi, s-hibã pacifitsi sh-imiri, spunãnda frunimeatsã cãtrã tutsã oamnjilji. ");
INSERT INTO rup_vpl VALUES ("TT3_3","086_3_3","TIT","3","3","3","Vãrãoarã sh-noi earam zurlji, nicãndãrsitsi, arãshi, sclayilji a orixilor sh-a chehilor soi di soi, bãnãnda tu arãutati sh-tu zilii, aurãts sh-aurãnda un-alantu. ");
INSERT INTO rup_vpl VALUES ("TT3_4","086_3_4","TIT","3","4","4","Ma cãndu s-aspusi bunãtatea a Dumnidzãlui, a-Ascãpãtorlui a nostru, sh-vrearea a lui trã oamnjilji, ");
INSERT INTO rup_vpl VALUES ("TT3_5","086_3_5","TIT","3","5","5","elu nã ascãpã, nu cu faptili atseali ndreapti tsi noi fãtsem, ma dupã njila a lui. Elu nã ascapã cu aspilarea a amintariljei atsea noaua sh-a rinoiriljei a Duhlui Sãmtu, ");
INSERT INTO rup_vpl VALUES ("TT3_6","086_3_6","TIT","3","6","6","tsi lu virsã fãrã mizurã pristi noi, prit Isus Hristos, Ascãpãtorlu a nostru. ");
INSERT INTO rup_vpl VALUES ("TT3_7","086_3_7","TIT","3","7","7","Trã atsea noi, ndreptãsitslji cu harul a lui, s-nã fãtsemu mushtinitori a banãljei eternã, tsi easti nãdia a noastrã. ");
INSERT INTO rup_vpl VALUES ("TT3_8","086_3_8","TIT","3","8","8","Aestu zbor easti pistipsit. Voi tsi tini s-li aspunj cu fuchii aesti lucri, tsi atselji tsi au pistipsitã la Dumnidzãlu s-aibã cãshtiga s-facã fapti buni. Aesti lucri suntu buni sh-ufilisiti trã caitsido. ");
INSERT INTO rup_vpl VALUES ("TT3_9","086_3_9","TIT","3","9","9","Ma tini afirea-ti di zburãrili glãreshti, di ghenealoghiili, di debatili sh-di ncãcearili trã legea, cã suntu anaxii sh-goali. ");
INSERT INTO rup_vpl VALUES ("TT3_10","086_3_10","TIT","3","10","10","Afirea-ti di omlu tsi easti ngrãnjaric, dupã tsi s-lu ai vãrghit unã oarã icã doauã ori, dipãrteadzã-ti di elu. ");
INSERT INTO rup_vpl VALUES ("TT3_11","086_3_11","TIT","3","11","11","Tini shtii cã un ahtari om easti cicãrdisit, amãrtiseashti, sh-easti singur-giudicatã. ");
INSERT INTO rup_vpl VALUES ("TT3_12","086_3_12","TIT","3","12","12","Cãndu s-pitrec Artemul icã Tihicul, aĝunjisea-ti s-yinji la mini tu Nicopoli, cã apofãsii s-trecu iarna aclo. ");
INSERT INTO rup_vpl VALUES ("TT3_13","086_3_13","TIT","3","13","13","Cãshtigheadz-ti di cãlãtoria al Zena, a avucatlui, sh-al Apolon, tsi s-nu lã lipseascã tsiva. ");
INSERT INTO rup_vpl VALUES ("TT3_14","086_3_14","TIT","3","14","14","Shi s-nveatsã sh-a noshtri si s-da tu fapti buni trã ananghili urghenti, tsi s-nu hibã nifructoshi. ");
INSERT INTO rup_vpl VALUES ("TT3_15","086_3_15","TIT","3","15","15","Tutsã atselji tsi suntu cu mini ts-pitrecu sãnãtati. Saluteadz-lji atselji tsi nã vor noi tu pisti. Harul s-hibã cu voi tuts.");
INSERT INTO rup_vpl VALUES ("PM1_1","087_1_1","PHM","1","1","1","Pavlu, hãpsãnitlu al Isus Hristos, sh-fratili Timoteu, a vrutlui Filemon, a colucrãtorlui a nostru, ");
INSERT INTO rup_vpl VALUES ("PM1_2","087_1_2","PHM","1","2","2","a sorãljei a noastrã Apfia, shi a coluptãtorlui a nostru Arhip, sh-a bisearicãljei tsi s-adunã tu casa a ta: ");
INSERT INTO rup_vpl VALUES ("PM1_3","087_1_3","PHM","1","3","3","Har sh-pace pri voi di la Dumnidzãlu, Tatãl a nostru, sh-di la Domnul Isus Hristos! ");
INSERT INTO rup_vpl VALUES ("PM1_4","087_1_4","PHM","1","4","4","Vrute Filemon, lu hãristisescu totãna Dumnidzãlu a meu, cãndu ti aduc aminti tu pãrãcãlsirili a meali, ");
INSERT INTO rup_vpl VALUES ("PM1_5","087_1_5","PHM","1","5","5","avdzãnda di vrearea a ta ti tuts oamnjilji a Dumnidzãlui, sh-ti pistea tsi ai tu Domnul Isus Hristos. ");
INSERT INTO rup_vpl VALUES ("PM1_6","087_1_6","PHM","1","6","6","Mini mi pãrãcãlsescu tsi pistea a noastrã unitã, s-ahãnduseasca cunushtearea tu itsi buneatsã tsi easti a voastrã trã Isus Hristos. ");
INSERT INTO rup_vpl VALUES ("PM1_7","087_1_7","PHM","1","7","7","Vrearea a ta, frate, mi ari hãrãsitã multu sh-mi ari diznjirdatã, cã iniljili a sãmtsãlor suntu nvãrtushiti. ");
INSERT INTO rup_vpl VALUES ("PM1_8","087_1_8","PHM","1","8","8","Trã atsea, cu tutã cã tu Hristolu am ndreptul s-ti ursescu s-fats atsea tsi prindi, ");
INSERT INTO rup_vpl VALUES ("PM1_9","087_1_9","PHM","1","9","9","ma multu ti pãrãcãlsescu tu numa a vreariljei, ashã cum escu mini, Pavlu, aush, ma tora sh-hãpsãnitlu al Isus Hristos, ");
INSERT INTO rup_vpl VALUES ("PM1_10","087_1_10","PHM","1","10","10","ti pãrãcãlsescu trã hiljilu a meu Onesimu, a cui mi feciu tãtal suflitescu tu prãnghili a meali. ");
INSERT INTO rup_vpl VALUES ("PM1_11","087_1_11","PHM","1","11","11","Elu ma nãinti eara anaxiu trã tini, ma tora easti hãirlãtic trã tini sh-trã mini. ");
INSERT INTO rup_vpl VALUES ("PM1_12","087_1_12","PHM","1","12","12","Mini ts-u pitricui atsel nãpoi; elu easti inima a mea. ");
INSERT INTO rup_vpl VALUES ("PM1_13","087_1_13","PHM","1","13","13","Mini vream s-lu tsãneam atsel ningã mini tsi s-nji huzmitipsea tu loclu a tãu tora tsi escu cu prãnghi trã itia a evanghelui, ");
INSERT INTO rup_vpl VALUES ("PM1_14","087_1_14","PHM","1","14","14","ma nu vream s-fãtseam tsiva ni fãrã di tini, tsi ghineatsa tsi va s-fats s-nu hibã ca cu zori, ma cu vreari. ");
INSERT INTO rup_vpl VALUES ("PM1_15","087_1_15","PHM","1","15","15","Cã vahi trã aestã fu dispãrtsãtã di tini ti putsãn chiro, tra s-hibã cu tini trã daima, ");
INSERT INTO rup_vpl VALUES ("PM1_16","087_1_16","PHM","1","16","16","ma nu ma ca sclav, ma, multu ma multu di sclav, ca frati vrut, ti mini, ma, ma multu ti tini, cum tu trup ashãtsi sh-tu Domnul. ");
INSERT INTO rup_vpl VALUES ("PM1_17","087_1_17","PHM","1","17","17","Macã tini mi lugurseshti sots, ashteaptã-lu ca cum si earam mini. ");
INSERT INTO rup_vpl VALUES ("PM1_18","087_1_18","PHM","1","18","18","Macã ts-ari faptã vãrã zãrari icã ts-ari vãrã mprumut, s-li badzã tu luguria a mea. ");
INSERT INTO rup_vpl VALUES ("PM1_19","087_1_19","PHM","1","19","19","Mini, Pavlul, ma tsã scriu cu mãna a mea cã va s-tsã plãtescu mprumutlu tra s-nu dzãc cã tini nj-ai mprumut sh-bana a ta. ");
INSERT INTO rup_vpl VALUES ("PM1_20","087_1_20","PHM","1","20","20","Ie, frate, fã-nji aestã tinjii tu Domnul! Nvãrtushea-nji inima tu Hristos! ");
INSERT INTO rup_vpl VALUES ("PM1_21","087_1_21","PHM","1","21","21","Tsã scriai cã pistipsescu cã va mi ascultsã, cã lu shtiu cã tini va s-fats ma multu dicãt ma tsã dzãc. ");
INSERT INTO rup_vpl VALUES ("PM1_22","087_1_22","PHM","1","22","22","Tu idyiul chiro, etimãsea-nji un loc trã armãneari, cã nãdãescu cã, trã hãtãrea a rugãciunilor a voastri, va s-vã mi durusescu nãpoi. ");
INSERT INTO rup_vpl VALUES ("PM1_23","087_1_23","PHM","1","23","23","Epafrul, hãpsãnitlu deadun cu mini trã itia al Isus Hristos, s-pitreatsi sãnãtati. ");
INSERT INTO rup_vpl VALUES ("PM1_24","087_1_24","PHM","1","24","24","Marcul, Aristarcul, Dema sh-Luca, colucrãtorlji a melji s-tsã pitrec sãnãtati. ");
INSERT INTO rup_vpl VALUES ("PM1_25","087_1_25","PHM","1","25","25","Harul a Domnului a nostru, Isus Hristos, s-hibã cu duhlu a vostru. Amin!");
INSERT INTO rup_vpl VALUES ("J11_1","092_1_1","1JN","1","1","1","Noi va vã u spunem atsea tsi fu dit apãrnjitã, atsea tsi avdzãmã, atsea tsi vidzumã cu ocljilji a noshtri, atsea tsi avem mutritã sh-avem pusputitã cu mãnjili a noastri trã Zborlu a banãljei, ");
INSERT INTO rup_vpl VALUES ("J11_2","092_1_2","1JN","1","2","2","cã bana s-fãnirusi shi noi u vidzumã sh-mãrtirsimã ti nãsã, shi vã u dimãndãm a voauã, bana atsea di totãna, tsi eara cu Tatãl sh-nã si aspusi a noauã, ");
INSERT INTO rup_vpl VALUES ("J11_3","092_1_3","1JN","1","3","3","atsea tsi vidzumã shi avdzãmã, tsi sh-voi s-hitsã deadun cu noi, shi comunitatea a noastrã easti cu Tatãlu shi cu Hiljilu a lui, Isus Hristos. ");
INSERT INTO rup_vpl VALUES ("J11_4","092_1_4","1JN","1","4","4","Sh-ma vã scriu aesti zboari tsi haraua a noastrã s-hibã ntreagã. ");
INSERT INTO rup_vpl VALUES ("J11_5","092_1_5","1JN","1","5","5","Sh-aestu easti mesajul tsi avdzãmã di la nãsu shi vã-u spunem a voauã: Dumnidzãlu easti lunjinã shi la nãsu nu ari dip scutidhi. ");
INSERT INTO rup_vpl VALUES ("J11_6","092_1_6","1JN","1","6","6","Ma s-dzãtsem cã avem unitate cu Elu, shi imnãm tu scutidhi, noi arãdem shi nu l-bãgãm tu practicã alihea. ");
INSERT INTO rup_vpl VALUES ("J11_7","092_1_7","1JN","1","7","7","Iarã, ma s-imnãm tu lunjinã, ashi cum elu easti tu lunjinã, avem unitate unlu cu alantu, shi sãndzãli al Isus Hristos, Hiljilu a lui, nã curã di itsi amãrtii. ");
INSERT INTO rup_vpl VALUES ("J11_8","092_1_8","1JN","1","8","8","Ma s-dzãtsem cã himã fãrã amãrtii, arãdem vetea a noastrã shi alihea nu easti tu noi. ");
INSERT INTO rup_vpl VALUES ("J11_9","092_1_9","1JN","1","9","9","Ma s-li mãrtirsim amãrtiili a noastri, elu easti pistimen shi ndreptu tra s-nã ljeartã amãrtiili shi s-nã curã di itsi arãutati. ");
INSERT INTO rup_vpl VALUES ("J11_10","092_1_10","1JN","1","10","10","Macã va dzãtsem cã nu avem amãrtisit, lu fãtsem nãsu arãditor, shi zborlu a lui nu easti cu noi. ");
INSERT INTO rup_vpl VALUES ("J12_1","092_2_1","1JN","2","1","1","Ficiorlji a melji, vã scriu aesti lucri tra s-nu amãrtisits, sh-ca s-hibã cã vãrã amãrtisi, avem un avocat ningã Tatãlu, Isus Hristos atsel ndreptu. ");
INSERT INTO rup_vpl VALUES ("J12_2","092_2_2","1JN","2","2","2","Elu easti curbanlu trã curarea a amãrtiilor a noastri, shi nu mash a noastri ma sh-trã atseali di tutã lumea. ");
INSERT INTO rup_vpl VALUES ("J12_3","092_2_3","1JN","2","3","3","Di aestã shtim cã lu-avem cunuscutã nãsu, macã vigljem dimãndãrili a lui. ");
INSERT INTO rup_vpl VALUES ("J12_4","092_2_4","1JN","2","4","4","Atselu tsi dzãtsi: “Mini lu-am cunuscutã atselu,” sh-nu li veaglji dimãndãrili a lui easti arãditor, shi alihea nu easti tu nãsu. ");
INSERT INTO rup_vpl VALUES ("J12_5","092_2_5","1JN","2","5","5","Iarã cai lu veaglji zborlu a lui, tu nãsu vrearea a Dumnidzãlui easti faptã perfectã. Sh-di aestã shtim cã noi him cu nãsu. ");
INSERT INTO rup_vpl VALUES ("J12_6","092_2_6","1JN","2","6","6","Atselu tsi dzãtsi cã sta cu nãsu, prindi s-imnã cum ari imnatã elu. ");
INSERT INTO rup_vpl VALUES ("J12_7","092_2_7","1JN","2","7","7","Multu-vruts, nu vã scriu un nou ordin, ma un ordin vecljiu, tsi lu aveatã di tu ahurhitã, ordinlu atsel vecljiulu easti zborlu tsi avdzãtã di tu ahurhitã. ");
INSERT INTO rup_vpl VALUES ("J12_8","092_2_8","1JN","2","8","8","Cu tut atsea ma vã scriu un ordin nou, tsi easti di alihea tu elu sh-tu voi, cã ntuneariclu ma treatsi sh-tora strãlutseashti lunjina alihioasã. ");
INSERT INTO rup_vpl VALUES ("J12_9","092_2_9","1JN","2","9","9","Atselu tsi dzãtsi cã easti tu lunjinã shi aurashti fratili a lui, easti ninga tu scutidhi. ");
INSERT INTO rup_vpl VALUES ("J12_10","092_2_10","1JN","2","10","10","Atselu tsi lu va fratili a lui armãni tu lunjinã shi nu ari tsiva tu nãsu tsi lu fatsi s-cadã. ");
INSERT INTO rup_vpl VALUES ("J12_11","092_2_11","1JN","2","11","11","Ma atselu tsi aurashti fratili a lui, easti tu scutidhi, imnã tu scutidhi sh-nu shtii cãtrã iu s-dutsi cã scutidhlu ari urghitã ocljilji a lui. ");
INSERT INTO rup_vpl VALUES ("J12_12","092_2_12","1JN","2","12","12","Vã scriu ficiori cã amãrtiili vã sãntu ljirtati di la numa al Hristos. ");
INSERT INTO rup_vpl VALUES ("J12_13","092_2_13","1JN","2","13","13","Pãrintsã, vã scriu cã voi lu avets cunuscutã atselu tsi easti di tu apãrnjitã. Tiniri, vã scriu cã lu avets bãtut arãulu. ");
INSERT INTO rup_vpl VALUES ("J12_14","092_2_14","1JN","2","14","14","Vã am scriatã a voauã, ficiori cã lu avets cunuscutã Tatãlu. Vã am scriatã a voauã, pãrintsã, cã avets cunuscutã atselu di tu apãrnjitã. Vã am scriatã a voauã tiniri cã hits vãrtoshi shi zborlu al Dumnidzãu armãni la voi shi cã lu avets bãtut arãulu. ");
INSERT INTO rup_vpl VALUES ("J12_15","092_2_15","1JN","2","15","15","S-nu vrets lumea, sh-nitsi atseali tsi sãntu tu lumi. Macã vãrã u va lumea, vrearea a Tatãlui nu easti tu nãsu. ");
INSERT INTO rup_vpl VALUES ("J12_16","092_2_16","1JN","2","16","16","Cã tuti atseali tsi sãntu tu lumi, orixea a truplui, orixea a ocljilor sh-pirifanjea a banãljei nu yinu di la Tatãlu ma di la lumea. ");
INSERT INTO rup_vpl VALUES ("J12_17","092_2_17","1JN","2","17","17","Sh-lumea treatsi cu orixea a ljei, ma atselu tsi fatsi vrearea a Dumnidzãlui, armãni di totãna. ");
INSERT INTO rup_vpl VALUES ("J12_18","092_2_18","1JN","2","18","18","Ficiori, easti oara dit soni. Shi cum avets avdzãtã va yinã antihristolu, shi tora multsã antihrishtsi si fãnipsirã, trã atsea noi aduchim cã easti oara dit soni. ");
INSERT INTO rup_vpl VALUES ("J12_19","092_2_19","1JN","2","19","19","Namisa di noi ishirã, ma nu eara di-a noshtri. Ma s-eara di-a noshtri, va-avea armasã cu noi, ma aestã spusi cã nu sãntu di-a noshtri. ");
INSERT INTO rup_vpl VALUES ("J12_20","092_2_20","1JN","2","20","20","Ma voi avets aundzearea di la Sãntulu shi li shtits tuti. ");
INSERT INTO rup_vpl VALUES ("J12_21","092_2_21","1JN","2","21","21","Nu vã scriai a voauã cã nu lu cunushtets alihea, ma cã voi lu cunushtets shi nitsiun arãdeari nu yini di la alihea. ");
INSERT INTO rup_vpl VALUES ("J12_22","092_2_22","1JN","2","22","22","Cai easti arãdioslu? Nu easti atselu tsi alipideashti cã Isus easti Hristolu? Antihristolu easti atselu tsi alipideashti Tatãlu shi Hiljilu. ");
INSERT INTO rup_vpl VALUES ("J12_23","092_2_23","1JN","2","23","23","Caitsido tsi alipideashti Hiljilu, nu lu ari nitsi Tatãlu. Caitsido tsi cunoashti Hiljilu, lu ari sh-Tatãlu. ");
INSERT INTO rup_vpl VALUES ("J12_24","092_2_24","1JN","2","24","24","Atsea tsi voi avdzãtã di tu apãrnjitã s-armãnã tu voi. Macã atsea tsi avdzãtã di tu apãrnjitã armãni tu voi, atumtsea shi voi va armãnets cu Hiljilu sh-cu Tatãlu. ");
INSERT INTO rup_vpl VALUES ("J12_25","092_2_25","1JN","2","25","25","Sh-aestã easti tãxirea tsi elu nã featsi: bana eternã. ");
INSERT INTO rup_vpl VALUES ("J12_26","092_2_26","1JN","2","26","26","Vã scriai aesti zboari trã atselji tsi caftã s-vã arãd. ");
INSERT INTO rup_vpl VALUES ("J12_27","092_2_27","1JN","2","27","27","Shi, cãt trã voi, aundzearea tsi avets loatã di la nãsu, armãni la voi shi nu avets ananghi tsi vãrã s-vã nveatsã. Macã aundzearea a lui vã nveatsã di tuti shi easti alihea sh-nu easti arãdeari, armãnets cu nãsu ashã cum vã nvitsã. ");
INSERT INTO rup_vpl VALUES ("J12_28","092_2_28","1JN","2","28","28","Sh-tora, ficiori, armãnets cu elu, cã atumtsea cãndu elu va si s-fãnipseascã, noi s-putem s-avem sigurantsã shi cu vinearea a lui s-nu nã rushinãm. ");
INSERT INTO rup_vpl VALUES ("J12_29","092_2_29","1JN","2","29","29","Macã shtits cã Hristolu easti ndreptu, s-lu shtits cã caitsido tsi fatsi ndriptatea s-ari amintatã di la elu. ");
INSERT INTO rup_vpl VALUES ("J13_1","092_3_1","1JN","3","1","1","Videts tsi vreari mari nã deadi Tatãl, tra s-nã numim hiljilji al Dumnidzãu, sh-dealihea noi him. Trã aestã, lumea nu nã cunoashti noi, cã nu lu ari cunuscutã atsel. ");
INSERT INTO rup_vpl VALUES ("J13_2","092_3_2","1JN","3","2","2","Multuvruts, tora him hiljilji al Dumnidzãu, ma ninga nu si-ari aspusã tsi va him. Shtim cã, cãndu si s-aspunã elu, va him un soi cu nãsu, cã va l-videm cum easti elu. ");
INSERT INTO rup_vpl VALUES ("J13_3","092_3_3","1JN","3","3","3","Sh-caitsido tsi ari aestã nãdii tu nãsu, prindi si s-curã ashã cum elu easti curat. ");
INSERT INTO rup_vpl VALUES ("J13_4","092_3_4","1JN","3","4","4","Cai fatsi amãrtii, fatsi sh-cãlcarea a legiljei, cã amãrtiia easti cãlcarea a legiljei. ");
INSERT INTO rup_vpl VALUES ("J13_5","092_3_5","1JN","3","5","5","Sh-voi lu shtits cã elu si-fãnirusi tsi s-dipãrteadzã amãrtiili a noastri, cã tu elu nu ari amãrtii. ");
INSERT INTO rup_vpl VALUES ("J13_6","092_3_6","1JN","3","6","6","Cai armãni tu elu nu amãrtiseashti, cai amãrtiseashti nu lu-ari vidzutã sh-nu lu-ari cunuscutã. ");
INSERT INTO rup_vpl VALUES ("J13_7","092_3_7","1JN","3","7","7","Ficiori, vãrã s-nu vã arãdã. Atsel tsi fatsi ndriptati easti ndreptu, ashã cum elu easti ndreptu. ");
INSERT INTO rup_vpl VALUES ("J13_8","092_3_8","1JN","3","8","8","Cai fatsi amãrtii, easti di la draclu, cã draclu amãrtisi di tu ahurhitã. Trã aestã s-fãnirusi Hiljilu al Dumnidzãu: trã asprãdzeari lucrili a dracului. ");
INSERT INTO rup_vpl VALUES ("J13_9","092_3_9","1JN","3","9","9","Cai s-amintã di la Dumnidzãlu nu fatsi amãrtii, cã simintsa al Dumnidzãu armãni la nãsu, shi nu poati s-bãneadzã amãrtisãnda, cã s-amintã di la Dumnidzãu. ");
INSERT INTO rup_vpl VALUES ("J13_10","092_3_10","1JN","3","10","10","Di la aestã s-cunoascã hiljilji al Dumnidzãu di hiljilji a dracului. Caitsido tsi nu fatsi ndriptatea, nu easti di la Dumnidzãu, ahtar nu easti nitsi atsel cai nu va fratili a lui. ");
INSERT INTO rup_vpl VALUES ("J13_11","092_3_11","1JN","3","11","11","Cã aestã easti dimãndãciunea tsi avdzãtã di tu ahurhitã: s-nã vrem cu un-alantu, ");
INSERT INTO rup_vpl VALUES ("J13_12","092_3_12","1JN","3","12","12","nu cum fu Cainul, cai eara di la slabulu shi vãtãmã fratili a lui. Sh-ti tsi lu vãtãmã? Cã faptili a lui eara uruti, iarã faptili a fratilui a lui eara ndreapti. ");
INSERT INTO rup_vpl VALUES ("J13_13","092_3_13","1JN","3","13","13","Nu vã ciudisits, fratsi a melji, macã lumea vã aurashti. ");
INSERT INTO rup_vpl VALUES ("J13_14","092_3_14","1JN","3","14","14","Noi lu shtim cã avem tricutã di la moartea tu banã, cã lji vrem fratsilji. Cai nu va fratili a lui, armãni tu moarti. ");
INSERT INTO rup_vpl VALUES ("J13_15","092_3_15","1JN","3","15","15","Caitsido tsi aurashti fratili a lui easti vãtãmãtor, sh-voi lu shtits cã nitsiun vãtãmãtor nu ari banã di totãna armas tu nãsu. ");
INSERT INTO rup_vpl VALUES ("J13_16","092_3_16","1JN","3","16","16","Di aestã lu avem cunuscut vrearea: elu deadi bana a lui trã noi, trã atsea sh-noi prindi s-dãmu bana a noastrã trã fratsilji. ");
INSERT INTO rup_vpl VALUES ("J13_17","092_3_17","1JN","3","17","17","Macã un ari bunili a lumiljei aishtei sh-veadi fratili a lui cai easti tu ananghi sh-u ncljidi inima a lui, cum va armãnã la nãsu vrearea a Dumnidzãlui? ");
INSERT INTO rup_vpl VALUES ("J13_18","092_3_18","1JN","3","18","18","Ficiori, si nu vrem cu zboari, nitsi cu limbã, ma cu fapti sh-cu alihea. ");
INSERT INTO rup_vpl VALUES ("J13_19","092_3_19","1JN","3","19","19","Sh-di aestã noi shtim cã him cu alihea sh-va cãndãrsimu ininjli a noastri nãintea a Lui. ");
INSERT INTO rup_vpl VALUES ("J13_20","092_3_20","1JN","3","20","20","Cã, ma s-nã condamnã inima a noastrã, Dumnidzãlu easti ma mari di inima a noastrã sh-li shtii tuti. ");
INSERT INTO rup_vpl VALUES ("J13_21","092_3_21","1JN","3","21","21","Multuvruts, macã inima a noastrã nu nã condamnã noi him siguri nãintea a Dumnidzãlui. ");
INSERT INTO rup_vpl VALUES ("J13_22","092_3_22","1JN","3","22","22","Sh-itsi cãftãm, u lom di la nãsu, cã fãtsem ordinli a lui sh-fãtsem atseali tsi l-arãsescu a lui. ");
INSERT INTO rup_vpl VALUES ("J13_23","092_3_23","1JN","3","23","23","Aestã easti ordinlu a lui tsi pistipsim tu numa a Hiljilui a lui Isus Hristos shi s-nã vrem cu un-alantu cum nã ordinã elu. ");
INSERT INTO rup_vpl VALUES ("J13_24","092_3_24","1JN","3","24","24","Atsel tsi veaglji ordinili a lui, armãni tu Dumnidzãlu, sh-elu tu nãsu. Di aestã noi shtim cã elu armãni cu noi: di Duhlu tsi elu nã deadi. ");
INSERT INTO rup_vpl VALUES ("J14_1","092_4_1","1JN","4","1","1","Multuvruts, nu pistipsits pri itsi duh, ma bãgats-lã tu provã duhurili, sã shtits mãcã sãntu di la Dumnidzãul, cã multsã prufits arãdioshi au ishitã tu dunjauã. ");
INSERT INTO rup_vpl VALUES ("J14_2","092_4_2","1JN","4","2","2","Di aestã putets s-cunushtets Duhlu al Dumnidzãul: itsi duh tsi mãrtirseashti cã Isus Hristos ari vinit tu trup, easti di la Dumnidzãul. ");
INSERT INTO rup_vpl VALUES ("J14_3","092_4_3","1JN","4","3","3","Shi itsi duh tsi nu mãrtirseashti cã Isus Hristos ari vinit tu trup, nu easti di la Dumnidzãul. Aestã easti duhlu a antihristolui tsi cum avets avdzãtã va yinã, shi tora easti tu lumi. ");
INSERT INTO rup_vpl VALUES ("J14_4","092_4_4","1JN","4","4","4","Voi hits di la Dumnidzãul, ficiori, shi lji avets bãtutã atselji, cã Duhlu a Dumnidzãlui cai easti tu voi, easti ma mari di atselu tsi easti tu lume. ");
INSERT INTO rup_vpl VALUES ("J14_5","092_4_5","1JN","4","5","5","Atselji sãntu di lumi, tr-atsea grescu di lucrili a lumiljei sh-lumea lji-ascultã. ");
INSERT INTO rup_vpl VALUES ("J14_6","092_4_6","1JN","4","6","6","Noi him di la Dumnidzãul, cai cunoashti Dumnidzãlu nã asculti, cai nu easti di Dumnidzãul, nu nã asculti, dit aestã cunushtem Duhlu a alihiljei shi duhlu a arãdeariljei. ");
INSERT INTO rup_vpl VALUES ("J14_7","092_4_7","1JN","4","7","7","Multuvruts, s-lu vrem un-alantu, cã vrearea easti di la Dumnidzãul shi caitsido tsi va, easti amintat di la Dumnidzãul sh-cunoashti Dumnidzãlu. ");
INSERT INTO rup_vpl VALUES ("J14_8","092_4_8","1JN","4","8","8","Atselu tsi nu ari vreari nu lu ari cunuscutã Dumnidzãlu, cã Dumnidzãlu easti vreari. ");
INSERT INTO rup_vpl VALUES ("J14_9","092_4_9","1JN","4","9","9","Tu aestã si fãnipsi vrearea a Dumnidzãlui ti noi, cã Dumnidzãlu pitricu Hiljilu a lui atsel unlu-amintat tu lumi, tsi noi s-bãnãm pri nãsu. ");
INSERT INTO rup_vpl VALUES ("J14_10","092_4_10","1JN","4","10","10","Tu aestã easti vrearea: nu cã noi lu avem vrutã Dumnidzãlu, ma elu nã ari vrutã noi, shi pitricu Hiljilu a lui tsi s-li ljeartã amãrtiili a noastri. ");
INSERT INTO rup_vpl VALUES ("J14_11","092_4_11","1JN","4","11","11","Multuvruts, macã Dumnidzãul nã vru ashãtsi, shi noi prindi s-vrem un-alantu. ");
INSERT INTO rup_vpl VALUES ("J14_12","092_4_12","1JN","4","12","12","Nitsiun nu l-vidzu vãrãoarã Dumnidzãlu, macã nã vrem unu cu alantu, Dumnidzãlu armãni tu noi sh-vrearea a lui easti perfectã la noi. ");
INSERT INTO rup_vpl VALUES ("J14_13","092_4_13","1JN","4","13","13","Di aestã noi cunushtem cã armãnem tu nãsu sh-elu tu noi, cã elu nã ari datã di Duhlu a lui. ");
INSERT INTO rup_vpl VALUES ("J14_14","092_4_14","1JN","4","14","14","Shi noi vidzum shi mãrtirsim cã Tatãlu lu pitricu Hiljilu tsi s-hiibã Ascãpãtor a lumiljei. ");
INSERT INTO rup_vpl VALUES ("J14_15","092_4_15","1JN","4","15","15","Atselu tsi mãrtirseashti cã Isusul easti Hiljilu a Dumnidzãlui, Dumnidzãlu sta tu nãsu sh-elu tu Dumnidzãlu. ");
INSERT INTO rup_vpl VALUES ("J14_16","092_4_16","1JN","4","16","16","Sh-noi cunuscum sh-pistipsim tu vrearea tsi Dumnidzãlu ari trã noi. Dumnidzãlu easti vreari, shi atselu tsi armãni tu vreari, armãni tu Dumnidzãlu sh-Dumnidzãlu tu nãsu. ");
INSERT INTO rup_vpl VALUES ("J14_17","092_4_17","1JN","4","17","17","Tu aestã vrearea easti perfectã tu noi, tsi s-avem curaiu trã dzua a giudicarãljei: cã cum easti elu, ashã him sh-noi tu aestã lume. ");
INSERT INTO rup_vpl VALUES ("J14_18","092_4_18","1JN","4","18","18","Atselu tsi vrea, nu ari fricã, shi vrearea perfectã aĝuneashti frica, cã frica ari cu nãsã cãtãdzicãsirea, shi atselu tsi ari fricã nu easti perfectã tu vreari. ");
INSERT INTO rup_vpl VALUES ("J14_19","092_4_19","1JN","4","19","19","Noi lu vrem atselu, cã elu nã vru protlu. ");
INSERT INTO rup_vpl VALUES ("J14_20","092_4_20","1JN","4","20","20","Ma s-dzãcã vãrã: “Mini lu voi Dumnidzãlu” shi aurashti fratili a lui, easti arãditor. Elu tsi nu va fratili a lui tsi lu veadi, cum poati s-aibã vreari trã Dumnidzãlu tsi nu lu-veadi? ");
INSERT INTO rup_vpl VALUES ("J14_21","092_4_21","1JN","4","21","21","Sh-aestã easti ordinlu tsi avem loatã di la elu: atselu tsi va Dumnidzãlu, s-aibã vreari sh-trã fratili a lui. ");
INSERT INTO rup_vpl VALUES ("J15_1","092_5_1","1JN","5","1","1","Caitsido tsi pistipseashti cã Isusul easti Hristolu, easti amintat di la Dumnidzãlu, shi caitsido tsi va Dumnidzãlu tsi lu ari amintat, va sh-atsel tsi easti amintat di la nãsu. ");
INSERT INTO rup_vpl VALUES ("J15_2","092_5_2","1JN","5","2","2","Di aestã noi shtim cã vrem hiljilji a Dumnidzãlui, cãndu vrem Dumnidzãlu shi vigljem dimãndãrili a lui. ");
INSERT INTO rup_vpl VALUES ("J15_3","092_5_3","1JN","5","3","3","Cã aestã easti vrearea a Dumnidzãlui: tsi noi s-vigljem dimãndãrili a lui, cã dimãndãrili a lui nu suntu greali. ");
INSERT INTO rup_vpl VALUES ("J15_4","092_5_4","1JN","5","4","4","Cã tuti tsi suntu amintat di la Dumnidzãlu anichiseascã pristi lumea, sh-nichisirea pristi lumea easti pistea a noastrã. ");
INSERT INTO rup_vpl VALUES ("J15_5","092_5_5","1JN","5","5","5","Cai easti atsel tsi nichiseashti pristi lumea, mash atsel tsi pistipseashti cã Isusul easti Hiljilu al Dumnidzãu? ");
INSERT INTO rup_vpl VALUES ("J15_6","092_5_6","1JN","5","6","6","Isus Hristos easti atsel tsi vini prit apã ti pãtidzari sh-prit sãndzili a moartãljei a lui, nu mash cu apã, ma cu apã sh-cu sãndzi. Sh-Duhlu easti atsel tsi mãrtirseashti, cã Duhlu easti alihea. ");
INSERT INTO rup_vpl VALUES ("J15_7","092_5_7","1JN","5","7","7","Cã trei suntu atselji tsi da mãrtirii tu tser: Tatili, Zborlu sh-Duhlu Sãmtu, sh-aeshti trelji suntu un. ");
INSERT INTO rup_vpl VALUES ("J15_8","092_5_8","1JN","5","8","8","Shi trei suntu atselji tsi mãrtirsescu pri loc: Duhlu, apa shi sãndzili, sh-aeshti trelji suntu pi un minti. ");
INSERT INTO rup_vpl VALUES ("J15_9","092_5_9","1JN","5","9","9","Macã noi apruchem mãrtiria a oamnjilor, mãrtiria al Dumnidzãu easti ma mari, cã aestã easti mãrtiria a Dumnidzãlui tsi elu deadi trã Hiljilu a lui. ");
INSERT INTO rup_vpl VALUES ("J15_10","092_5_10","1JN","5","10","10","Atsel tsi pistipseashti tu Hiljilu al Dumnidzãu ari aestã mãrtirii pri nãsu. Atsel tsi nu pistipseashti la Dumnidzãlu, lu ari faptã arãdios, cã nu pistipsi la mãrtiria tsi Dumnidzãlu deadi ti Hiljilu a lui. ");
INSERT INTO rup_vpl VALUES ("J15_11","092_5_11","1JN","5","11","11","Sh-mãrtiria easti aestã, Dumnidzãlu nã deadi bana eternã sh-aestã banã easti tu Hiljilu a lui. ");
INSERT INTO rup_vpl VALUES ("J15_12","092_5_12","1JN","5","12","12","Atsel tsi ari Hiljilu, ari bana. Atsel tsi nu ari Hiljilu al Dumnidzãu, nu ari bana. ");
INSERT INTO rup_vpl VALUES ("J15_13","092_5_13","1JN","5","13","13","Vã scriai aesti a voauã tsi pistipsits tu numa a Hiljilu a Dumnidzãlui, tsi s-shtits cã avets bana eternã shi s-pistipsits tu numa a Hiljilu a Dumnidzãlui. ");
INSERT INTO rup_vpl VALUES ("J15_14","092_5_14","1JN","5","14","14","Aestã easti sigurantsa tsi avem nãintea a lui: ma cãftãm tsiva dupã vrearea a lui, elu nã-u da. ");
INSERT INTO rup_vpl VALUES ("J15_15","092_5_15","1JN","5","15","15","Shi macã shtim cã elu nã-li avdi tuti atseali tsi cãftãm, noi shtim cã li avem atseali tsi lji cãftãm a lui. ");
INSERT INTO rup_vpl VALUES ("J15_16","092_5_16","1JN","5","16","16","Macã vãrã veadi fratili a lui cã fatsi unã amãrtii tsi nu dutsi tu moarti, s-pãrãcãlseascã a Domnului, sh-elu va lji da bana, atsilor tsi fac amãrtii tsi nu duc tu moarti. Ari amãrtii tsi duc tu moarti, nu dzãc tsi elu s-pãrãcãlseascã trã aestã. ");
INSERT INTO rup_vpl VALUES ("J15_17","092_5_17","1JN","5","17","17","Itsi nindriptati easti amãrtii, ma ari amãrtii tsi nu dutsi tu moarti. ");
INSERT INTO rup_vpl VALUES ("J15_18","092_5_18","1JN","5","18","18","Noi shtim cã caitsido tsi easti amintat di la Dumnidzãlu nu poati s-bãneadz amãrtisãnda cã atsel tsi easti amintat di la Dumnidzãlu s-veaglji, shi Slabulu nu lu pligueashti. ");
INSERT INTO rup_vpl VALUES ("J15_19","092_5_19","1JN","5","19","19","Noi shtim cã him di la Dumnidzãlu shi cã ntreagã lumea s-aflã sum putearea a Slabului. ");
INSERT INTO rup_vpl VALUES ("J15_20","092_5_20","1JN","5","20","20","Noi shtim cã Hiljilu al Dumnidzãu vini shi nã deadi aduchirea tsi noi s-cunushtem atsel tsi easti Alihioslu, shi noi him tu Alihioslu, tu Hiljilu a lui Isus Hristos. Aestu easti alihioslu Dumnidzã sh-bana eternã. ");
INSERT INTO rup_vpl VALUES ("J15_21","092_5_21","1JN","5","21","21","Ficiori, afirits-vã di idulji.");
INSERT INTO rup_vpl VALUES ("J21_1","093_1_1","2JN","1","1","1","Mini vechljilu, a doamnãljei aleaptã shi a hiljilor a ljei tsi lã voi tu alihea, shi nu mash mini, ma shi tutsã atselji tsi au cunuscutã alihea, ");
INSERT INTO rup_vpl VALUES ("J21_2","093_1_2","2JN","1","2","2","ti itia a alihiljei, tsi sta cu noi shi va s-hibã cu noi di tut eta: ");
INSERT INTO rup_vpl VALUES ("J21_3","093_1_3","2JN","1","3","3","harul, njila shi pacea s-hibã cu voi di la Dumnidzãul Tatãlu shi di la Domnulu Isus Hristos, Hiljilu a Tatãlui, tu alihea sh-tu vreari. ");
INSERT INTO rup_vpl VALUES ("J21_4","093_1_4","2JN","1","4","4","Mi hãrãsii multu cã aflai nãscãntsi di hiljilji a tãlji imnãnda tu alihea, dupã ordinlu tsi loarã di la Tatãlu. ");
INSERT INTO rup_vpl VALUES ("J21_5","093_1_5","2JN","1","5","5","Sh-tora ti pãrãcãlsescu, Doamnã, tsi s-lu vrem un-alantu, nu ca cum sã scriu un ordin nou, ma atsea tsi aveam avutã dit apãrnjitã. ");
INSERT INTO rup_vpl VALUES ("J21_6","093_1_6","2JN","1","6","6","Shi aestã easti vrearea, s-imnãm dupã ordinli a lui. Cum u avãdzãtã dit apãrnjitã, aestã easti ordinlu tsi lom tsi s-imnãm tu nãsu. ");
INSERT INTO rup_vpl VALUES ("J21_7","093_1_7","2JN","1","7","7","Mini vã dzãc cã tu lumi au inshitã multsã arãditori, cai nu martirsescu cã Isus Hristos ari vinit tu trup. Aestu om easti arãditorlu shi antihristolu. ");
INSERT INTO rup_vpl VALUES ("J21_8","093_1_8","2JN","1","8","8","Bãgats mintea si nu chirdets frutlu a lucrilor tsi avem faptã, ma s-loatsã unã mushtinari mplinã. ");
INSERT INTO rup_vpl VALUES ("J21_9","093_1_9","2JN","1","9","9","Caitsido tsi s-dutsi nclo shi nu armãni tu nvitsãtura a Hristolui, nu ari Dumnidzã. Cai armãni tu nvitsãtura a Hristolui, ari Tatãlu shi Hiljilu. ");
INSERT INTO rup_vpl VALUES ("J21_10","093_1_10","2JN","1","10","10","Macã vãrã yini la voi sh-nu adutsi aestã nvitsãturã, nu lu apruchiats la casã shi nu lu salutats. ");
INSERT INTO rup_vpl VALUES ("J21_11","093_1_11","2JN","1","11","11","Cã atselu tsi lji dzãtsi “Ghini vinjish”, s-fatsi parti tu faptili a lui atseali arãli. ");
INSERT INTO rup_vpl VALUES ("J21_12","093_1_12","2JN","1","12","12","Cu tuti cã aveam multi lucri ti scriari, nu vream su fãtseam cu carti sh-cu buiauã, ma nãdãescu s-yin la voi shi s-vã grescu cu gura, tsi haraua a noastrã s-hibã ntreagã. ");
INSERT INTO rup_vpl VALUES ("J21_13","093_1_13","2JN","1","13","13","Hiljilji a sorãljei a ta aleaptã ti saluteadzã. Amen.");
INSERT INTO rup_vpl VALUES ("J31_1","094_1_1","3JN","1","1","1","Mini vecljiulu, a Gailu multuvrut, tsi lu voi dealihea. ");
INSERT INTO rup_vpl VALUES ("J31_2","094_1_2","3JN","1","2","2","Multuvrute, mini voi s-ai ambãreatsã la tuti, shi s-hãrãseshtã sãnãtati bunã, ashi cum ari ambãreatsã suflitlu a tãu. ");
INSERT INTO rup_vpl VALUES ("J31_3","094_1_3","3JN","1","3","3","Cã mi hãrãsii cãndu vinirã niscãntsã fratsi sh-mãrtirsirã ti pistipsirea a ta trã alihea, cã cum imnji tini tu alihea. ");
INSERT INTO rup_vpl VALUES ("J31_4","094_1_4","3JN","1","4","4","Nu am ma mari harauã di aestã: s-avdu cã hiljilji a melji imnã tu alihea. ");
INSERT INTO rup_vpl VALUES ("J31_5","094_1_5","3JN","1","5","5","Multuvrute, tini fats cu pistipsiri itsido tsi fats trã fratsilji shi trã xenjilji. ");
INSERT INTO rup_vpl VALUES ("J31_6","094_1_6","3JN","1","6","6","Elji mãrtirsirã ti vrearea a ta nãinti a bisearcãljei, shi va s-fatsã ghini s-ai cãshtigã ti cãlãtoria a lor cu tinjii di Dumnidzãlu. ");
INSERT INTO rup_vpl VALUES ("J31_7","094_1_7","3JN","1","7","7","Cã elji inshirã trã numa a lui, fãrã s-ljea tsiva di la pãngãnji. ");
INSERT INTO rup_vpl VALUES ("J31_8","094_1_8","3JN","1","8","8","Noi u avem obligatsie, s-li ashtiptãm aeshti oaminj, tsi s-himã prilucrãtor trã alihea. ");
INSERT INTO rup_vpl VALUES ("J31_9","094_1_9","3JN","1","9","9","Lji scriai a bisearcãljei, ma Diotreful, tsi va s-hiibã protlu trã elji nu nã ashteapti. ");
INSERT INTO rup_vpl VALUES ("J31_10","094_1_10","3JN","1","10","10","Tr-atsea, ma s-yinu, va lji-aduc aminti a lui faptili tsi adari, zburãnda zboari arãi contra noi. Cum s-nu agiungu aesti, elu nu li ashteapti fratsilji shi li ncheadicã atselji tsi vor s-li ashteaptã shi li scoati di bisearicã. ");
INSERT INTO rup_vpl VALUES ("J31_11","094_1_11","3JN","1","11","11","Multuvrute, nu urmeadzã arãulu, ma bunulu. Atselu tsi fatsi bunulu easti di la Dumnidzãul, ma atselu tsi fatsi arãulu nu lu ari vidzutã Dumnidzãlu. ");
INSERT INTO rup_vpl VALUES ("J31_12","094_1_12","3JN","1","12","12","Di Dhimitrul tutsã da mãrtirii bunã, tutashã shi alihea: shi noi mãrtirsimu ti nãsu, sh-tini lu shtii cã mãrtiria a noastrã easti alihinoasã. ");
INSERT INTO rup_vpl VALUES ("J31_13","094_1_13","3JN","1","13","13","Aveam multi trã scriari, ma nu voi s-tsã scriu cu buiauã shi-peanã. ");
INSERT INTO rup_vpl VALUES ("J31_14","094_1_14","3JN","1","14","14","Ma nãdãescu s-ti ved curundã shi si zburãm di aproapi. ");
INSERT INTO rup_vpl VALUES ("J31_15","094_1_15","3JN","1","15","15","Pacea cu tini! Oaspilji tsã pitrec sãnãtati. Dã sãnãtati a oaspilor un pi unã.");
INSERT INTO rup_vpl VALUES ("JD1_1","095_1_1","JUD","1","1","1","Iuda sclavul al Isus Hristos shi fratili al Iacov, a acljimatsilor tsi sãntu vruts di la Tatãl Dumnidzãu sh-vigljeatã di Isus Hristos. ");
INSERT INTO rup_vpl VALUES ("JD1_2","095_1_2","JUD","1","2","2","Njila, pacea shi vrearea si s-avdagã la voi. ");
INSERT INTO rup_vpl VALUES ("JD1_3","095_1_3","JUD","1","3","3","Multuvruts, aveam unã vreari marã s-vã scriu ti ascãparea a noastrã comunã, avui ananghi s-vã scriu a voauã shi s-vã ursedzã s-alumtats ti pistea tsi eara datã a sãmtsãlor un oarã sh-ti totãna. ");
INSERT INTO rup_vpl VALUES ("JD1_4","095_1_4","JUD","1","4","4","Cã intrarã ascumtu namisa di voi niscãntsã oaminji tsi eara arãdhãpsits di cu chiro ti aestã condamnã, nipistipsits, tsi u toarnã harul a Dumnidzãlui a nostru tu desfrãnari sh-aleapid singurlu Mastru, sh-Domnul-a nostru Isus Hristos. ");
INSERT INTO rup_vpl VALUES ("JD1_5","095_1_5","JUD","1","5","5","Ma voi s-vã aduc aminti, cu tutã cã tora li shtits tuti aesti, tsi Domnul, dupã tsi u ascãpã populu a lui di loclu-a Eghiptului, deapoea lji dãrãmã atselji tsi nu pistipsirã. ");
INSERT INTO rup_vpl VALUES ("JD1_6","095_1_6","JUD","1","6","6","Anghilji, tsi nu l-tsãnurã pozitsili a lor di ma nãinti, ma li alãsarã locurili a lor iu bãna, elu lji apãrã tu scutidhi, ligats cu prãnghi eternã ti giudicata a Dzuãljei atsiljei mari. ");
INSERT INTO rup_vpl VALUES ("JD1_7","095_1_7","JUD","1","7","7","Ashi cum Sodoma sh-Gomora shi cãsãbadzli avãrliga s-deadirã dupã putãnlichili shi imnarã dupã desfrãnãrili sexuali. Aesti s-featsirã exemplu trã atselji tsi pãtsãrã pidipsirea a foclui ti totãna. ");
INSERT INTO rup_vpl VALUES ("JD1_8","095_1_8","JUD","1","8","8","Tut ashã sh-aeshtsã yisãnda lãvushescu truplu, arniseascã putearea a Dumnidzãlui sh-blastimã creaturili tsereshti. ");
INSERT INTO rup_vpl VALUES ("JD1_9","095_1_9","JUD","1","9","9","Ma arhanghelul Mihaili cãndu si ncãcea cu draclu zbura trã truplu a Moisiului sh-nu cutidzã s-dzãtsea un zbor ti ngiurari ma dzãsi: “Domnul s-ti vãrgheascã!” ");
INSERT INTO rup_vpl VALUES ("JD1_10","095_1_10","JUD","1","10","10","Ma aeshtsã greascã arãu ti tuti lucrili tsi nu cunoscu di la natura, ca prãvdzili fãrã minti, tsi facã arãu ti vetea a lor. ");
INSERT INTO rup_vpl VALUES ("JD1_11","095_1_11","JUD","1","11","11","Cavai di nãshi! Cã au loatã calea a Cainlui, sh-trã amintatic s-arcarã dupã cãbãtli a Balaamlui, sh-chirurã tu cundrira a Coreul. ");
INSERT INTO rup_vpl VALUES ("JD1_12","095_1_12","JUD","1","12","12","Aeshtsã sãntu lãvushituri la sãrbãtoarili a voastri di vrearea frãtseascã, cãndu mãcã sh-bea deadun cu voi fãrã rushãni, pãshtãnda vetea a lor. Atselji sãntu niori fãrã apã, pimtu nclo shi nculea di vimturi, ponji di toamna fãrã fruti, disrãdãtsinati sh-di doauã ori mortsi. ");
INSERT INTO rup_vpl VALUES ("JD1_13","095_1_13","JUD","1","13","13","Atselji sãntu vãljuri turbati a amariljei tsi spumeadzã arushãnili a lor, steali dispãrtsãti di la cai easti rezervat scutidhlu ti totãna. ");
INSERT INTO rup_vpl VALUES ("JD1_14","095_1_14","JUD","1","14","14","Shi trã aeshtsã prufitipsi shi Enocul, al shaptili dupã Adam, dzãcãnda: “Ia, ma yini Domnulu cu njiljilji a lui sãmtsã, ");
INSERT INTO rup_vpl VALUES ("JD1_15","095_1_15","JUD","1","15","15","ti fãtseari giudicarea contra a tutulor shi ti cãndãrsiri tuts nipistimenjilji namisa di nãshi trã tuti faptili a lor arãli shi trã tuti zboarili a lor arushinoasi, tsi amãrtioshilji fãrã pisti greascã contra a lui.” ");
INSERT INTO rup_vpl VALUES ("JD1_16","095_1_16","JUD","1","16","16","Aeshtsã sãntu murmurãtori tsi plãngã ti itsido tsi imnã dupã orixea a lor shi gura a lor greashti zboari alãvdati shi culãchipseascã oaminji trã amintatic. ");
INSERT INTO rup_vpl VALUES ("JD1_17","095_1_17","JUD","1","17","17","Ma voi, multuvruts, adutsets-vã aminti zboarili tsi vã au dzãsã apostoljilji a Domnului a nostru Isus Hristos. ");
INSERT INTO rup_vpl VALUES ("JD1_18","095_1_18","JUD","1","18","18","Elji vã dzãtsea tsi tu chirolu di ma napoi va s-aibã pizuitorii tsi va s-imnã dupã orixile a lor anapudzi. ");
INSERT INTO rup_vpl VALUES ("JD1_19","095_1_19","JUD","1","19","19","Aeshtsã sãntu atselji tsi fac dispãrtsãri, oaminji amãrtioshi, tsi nu au Duhlu. ");
INSERT INTO rup_vpl VALUES ("JD1_20","095_1_20","JUD","1","20","20","Ma voi, multuvruts, adrãnda bana pri pistea a voastrã multu-sãmtã, pãrãcãlsãnda tu Duhlu Sãmtu, ");
INSERT INTO rup_vpl VALUES ("JD1_21","095_1_21","JUD","1","21","21","afirits-vã tu vrearea al Dumnidzãu, ashtiptãnda njila a Domnului a nostru Isus Hristos tsi adutsi bana eternã. ");
INSERT INTO rup_vpl VALUES ("JD1_22","095_1_22","JUD","1","22","22","Shi avets njilã di omlu tsi easti turbulat. ");
INSERT INTO rup_vpl VALUES ("JD1_23","095_1_23","JUD","1","23","23","Shi ascãpats-lã alantsãlji trãgãnda di focu, shi avets njilã la alantsi deadun cu fricã, aurãnda stranjilu pangãnit di carnea. ");
INSERT INTO rup_vpl VALUES ("JD1_24","095_1_24","JUD","1","24","24","Ma atsilui tsi poati s-vã veaglji di cathi cãdeari shi s-vã scoatã nãinti a mãririljei a lui ni-lãvushit shi cu harauã, ");
INSERT INTO rup_vpl VALUES ("JD1_25","095_1_25","JUD","1","25","25","a singurlui Dumnidzã, a Ascãpãtorlui a nostru, s-lji hibã mãriri, multu-mãriri, puteari shi autoritati, tora shi tu eta a etilor. Amen.");
ALTER TABLE rup_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
