﻿USE sofia;
DROP TABLE IF EXISTS sofia.rug_vpl;
CREATE TABLE rug_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES rug_vpl WRITE;
INSERT INTO rug_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Pa pinodalaena sipu tavetia Tamasa sa maṉauru, meke sa pepeso, ");
INSERT INTO rug_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","meke loke kinehana meke loketoṉa si koa koasa kasia popoa. Na hinuporo si nobia sa lamana peava, meke sa Maqomaqona Tamasa si opo tamunia sa beru kolo. ");
INSERT INTO rug_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Meke zama sa Tamasa, “Mani vura mae sa kalalasa!” Meke ta evaṉa tugo sa kalalasa. ");
INSERT INTO rug_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Meke doṉo la ia e Tamasa sapu leana sa kalalasa, ke paqaha pania Tamasa sa kalalasa koasa huporo. ");
INSERT INTO rug_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Meke poza nia rane Tamasa sa kalalasa meke poza nia boṉi Sa sa huporo. Meke asa tugo sa rane kekenu meke hola taloa sa boṉi, meke kamo mae sa munumunu. ");
INSERT INTO rug_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Meke zama pule tugo sa Tamasa, “Sa galegalearane si mani koa pa vari korapadi rina kolo, pude paqaha ruai sari na kolo.” ");
INSERT INTO rug_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Meke tavetia sa Tamasa sa mamaṉa lavata pude paqahia sa kolo panaulu meke pa kauruna sa galegalearane, ke ta evaṉa gua tugo asa. ");
INSERT INTO rug_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Meke poza nia galegalearane Tamasa sa mamaṉa lavata; meke asa tugo sa rane vina rua. Hola taloa sa boṉi meke kamo mae sa munumunu. ");
INSERT INTO rug_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Zama pule sa Tamasa, “Madi ta kolo varigarae pa keke vasina sari na kolo pa kauruna sa galegalearane, pude va vura va bakalia sa pepeso popana!” Meke ta evaṉa tugo. ");
INSERT INTO rug_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Meke poza nia pepeso Tamasa sa popoa popana, meke sari na kolo pu ta varigarae, si poza nia lamana Sa. Meke doṉo la i Tamasa sapu leadi tugo si arini. ");
INSERT INTO rug_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Meke zama pule sa Tamasa, “Mani toqolo vura mae pa pepeso sa muqe meke sa hiqohiqo: sari na huda pu vua kiko, meke na votiki huda saripu koai kiko vuadi;” meke ta evaṉa tugo. ");
INSERT INTO rug_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ke va toqolo vurai sa pepeso sari doduru votivotiki kineha huda, meke doṉo la i Tamasa sapu leadi tugo si arini. ");
INSERT INTO rug_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Meke asa tugo sa rane vina ṉeta meke hola taloa sa boṉi, meke kamo mae sa munumunu. ");
INSERT INTO rug_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Meke zama pule sa Tamasa, “Madi podaka vura mae pa maṉauru sari na kalalasa pude paqahia sa rane koa sa boṉi, meke kaqu koa na vina gilagila si arini, pude padai sari na pinodalaedi ri na totoso, na rane meke na vuaheni. ");
INSERT INTO rug_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Madi koa na kalalasa sarini pa mamaṉana sa maṉauru, pude va kalalasia sa popoa pepeso.” Meke ta evaṉa tugo. ");
INSERT INTO rug_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Meke vizati Tamasa sari karua kalalasa nomadi, sapu nomana si pude totoli nia sa rane, meke sapu hitekena si pude totoli nia sa boṉi, meke sari na pinopino si taveti tugo Sa. ");
INSERT INTO rug_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Meke veko lani Tamasa si arini pa maṉauru pude va kalalasia sa popoa pepeso, ");
INSERT INTO rug_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","meke pude totoli nia sa rane meke sa boṉi, meke pude paqahia sa kalalasa koasa huporo. Meke doṉo la i Tamasa sapu leadi si arini. ");
INSERT INTO rug_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Meke asa tugo sa rane vina made meke hola taloa sa boṉi, meke kamo mae sa munumunu. ");
INSERT INTO rug_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Meke zama pule tugo sa Tamasa, “Madi tava siṉi sari na lamana koari na rovana igana toadi, meke sari na kurukuru pu tapuru panauluna sa popoa pepeso, koasa mamaṉana sa maṉauru.” ");
INSERT INTO rug_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ke va podaki Tamasa sari na igana nomadi hola pa lamana, meke sari doduru hopeke butubutu igana toadi pu tunuru, meke va podaki tugo Sa sari doduru votivotiki butubutu kurukuru tapuru. Meke doṉo la i Tamasa sapu leadi tugo si arini. ");
INSERT INTO rug_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Meke manani Tamasa sarini meke zama, “Mi podopodo va sokusoku. Mamu va siṉi sari na kolo lamana; madi tapuru lamae pa doduru vasidi pa pepeso sari na kurukuru tapuru.” ");
INSERT INTO rug_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Meke asa tugo sa rane vina lima, meke hola taloa sa boṉi, meke kamo mae sa munumunu. ");
INSERT INTO rug_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Meke zama sa Tamasa, “Mani va vurai sa pepeso sari na kurukuru toadi pa dia kineha soti: sari na kurukuru ṉame, meke na kurukuru gotolodi.” Meke ta evaṉa gua tugo si arini. ");
INSERT INTO rug_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Meke va podaki Tamasa sari doduru kurukuru koari doduru dia kineha soti: sari na kurukuru ṉame meke sari na kurukuru gotolo. Meke doṉo la i Tamasa sapu leadi tugo si arini. ");
INSERT INTO rug_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Meke zama pule sa Tamasa, “Mada va podaki sari na tinoni pa kinehada soti, pude madi baṉarani sari na igana pa kolo, meke sari na kurukuru pa galegalearane, meke sari na kurukuru made nenedi, meke sari doduru tiṉitoṉa pu ṉame pa pepeso.” ");
INSERT INTO rug_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ke va podaki Tamasa sari na tinoni: va podaka guni ni Sa pa kinehana soti; va podaka ni koreo na vineki Sa si arini. ");
INSERT INTO rug_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Meke manani Tamasa si arini meke zamai Sa, “Mi podopodo va sokusoku, mamu va siṉia sa pepeso, mamu tavetavete vasina. Mi ṉati hiniva ni sari na igana pa kolo, meke sari na kurukuru pa galegalearane, meke sari doduru tiṉitoṉa toadi pule pa pepeso.” ");
INSERT INTO rug_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Meke zama pule sa Tamasa, “Dotu, ele ponini gamu Rau sari doduru linetelete pu ari kikodi saripu toa pa kasia popoa, meke sari doduru vua huda pu koai kikodi korapadi. Arini sari na gemi ginani. ");
INSERT INTO rug_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Sari doduru linetelete toadi pa pepeso si ele poni Rau koari doduru tiṉitoṉa toadi pu siṉo pude na gedi ginani: koari doduru kurukuru made nene na kurukuru tapuru, meke na kurukuru hitekedi pu ṉame pa pepeso.” ");
INSERT INTO rug_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Meke doṉo la i Tamasa sari doduru tiṉitoṉa pu ele taveti Sa, meke dotu, leleadi hola si arini. Meke asa tugo sa rane vina onomo; meke hola taloa sa boṉi, meke kamo mae sa munumunu. ");
INSERT INTO rug_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ke gua asa, si tava hokoto beto sa maṉauru meke sa pepeso, meke sari doduru likakalae pu koa koarini. ");
INSERT INTO rug_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Meke beto tavetavete sa Tamasa meke pa rane vina zuapa si magogoso si Asa koari doduru Nana tinavete pu ele taveti Sa. ");
INSERT INTO rug_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Ke, mana nia Tamasa sa rane vina zuapa, meke va madia Sa si asa. Koasa totoso asa, si lopu tavetavete sa Tamasa sina ele hokoto beto sari doduru Nana tinavetavete. ");
INSERT INTO rug_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Gua hire sari na vina podakadi sa maṉauru, meke sa pepeso totoso ta tavete si arini. Pa totosona sipu kuria e Zihova Tamasa sa pepeso meke sa maṉauru, ");
INSERT INTO rug_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","si lopu ele toa pa pepeso si keke huda pa hiqohiqo, meke lopu ele toqolo sage si keke linetelete pa pepeso, ura lopu ele va hoqa nia ruku e Zihova sa pepeso, meke loke tie si koa pude uma ia si asa. ");
INSERT INTO rug_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Ba sari na kovele mo si vura sage mae koa sa pepeso, meke va bobosia sa beruna sa pepeso. ");
INSERT INTO rug_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Meke tavete nia kavuru pepeso mo e Zihova sa tie, meke siṉo nuquru nia Sa pa qoqoro isuna sa tinoa; meke tiqe toa sa tie. ");
INSERT INTO rug_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ke letea e Zihova Tamasa si keke inuma pa Idini pa kali gasa rimata, meke vasina si veko nia Sa sa tie sapu ele tavetia Sa. ");
INSERT INTO rug_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Meke va toqolo vurai e Zihova vasina sari doduru huda pu doṉo lea pa mata, pu leadi pude henai; meke sa huda tinoa, meke sa huda tinumatumae tanisa lineana meke sa kinaleana si toa pa vari korapana puta sa inuma. ");
INSERT INTO rug_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Keke ovuku si vura mae gua pa Idini sapu va masuria sa inuma, meke paqaha ka made si asa. ");
INSERT INTO rug_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Sa pozana sa ovuku kekenu si Pisoni, sapu totolo likoho la koasa sa doduruna sa popoa Havila, vasina koa sa qolo. ");
INSERT INTO rug_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Sa qolo pa popoa sana si leana, meke koa tugo vasina sa ruqa sapu humaṉa lea, meke sa patu arilaena sapu ta pozae onikisi. ");
INSERT INTO rug_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Sa pozana sa ovuku vina rua si Qihoni, sapu vari dikue nia sa popoa Kusi. ");
INSERT INTO rug_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Meke sa pozana sa ovuku vina ṉeta si Taeqarisi, sapu ene la gua pa kali gasa rimata koasa popoa Asiria. Meke sa ovuku vina made si Iuparetisi. ");
INSERT INTO rug_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Meke vagia e Zihova Tamasa sa tie meke vekoa Sa pa inuma Idini, pude mani tavetavete na kopu nia sa inuma sana, gua. ");
INSERT INTO rug_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Meke zama ia e Zihova Tamasa sa tie, “Boka henai goi vuadi sari doduru huda pa inuma, ");
INSERT INTO rug_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ba namu lopu kaqu henaia goi sa vuana sa huda tinumatumae tanisa lineana meke sa kinaleana, ura koasa rane pana henaia goi si asa, si kaqu mate si agoi.” ");
INSERT INTO rug_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Meke zama se Zihova Tamasa, “Lopu leana si pude koa telena eke sa tie, ba kaqu tavetia Rau si keke nana tie varitokae sapu kaqu garona sa.” ");
INSERT INTO rug_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Ke taveteni pepeso e Zihova Tamasa sari doduru kurukuru pa hiqohiqo, meke doduru kurukuru tapuru pa galegalearane. Meke turaṉa lani Sa sarini koa sa tie, pude hopeke pozani pozapoza sa si arini. Ke gua sapu pozani pozapoza sa tie sari doduru kurukuru toadi hire si gua tugo asa ke ari pozadi si arini. ");
INSERT INTO rug_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Ego, ke vizata poni pozapoza sa tie sari doduru kurukuru made nenedi, doduru kurukuru tapuru, meke sari doduru kurukuru pinomo pa hiqohiqo, ba lopu ta dogoro si keke sapu pada meke garo pude varitokae koasa tie. ");
INSERT INTO rug_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Gua asa, ke va puta muliuṉia e Zihova Tamasa sa tie, meke sipu puta muliuṉu sa, si hena ia Tamasa si keke susuri raqaraqana, meke tuku pule ia Sa sa masana. ");
INSERT INTO rug_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Meke sa susuri raqaraqa sapu vagia e Zihova koasa tie, si va podaka nia keke barikaleqe Sa, meke turaṉa la nia Sa koasa tie. ");
INSERT INTO rug_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Meke zama sa tie, “Kamahire tu, sina hie tugo sa susurina sa susuriqu meke sa masana sa masaqu arau. Ke kaqu ta pozae barikaleqe si asa, sina ta vagi pa korapa tiniqu rau si asa.” ");
INSERT INTO rug_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Gua asa, si luaria sa koreo sa tamana meke sa tinana, meke koa keke koa sa nana barikaleqe, meke koa keke tinidia sari karua. ");
INSERT INTO rug_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Dododohodi beto sari Adama meke Ivi, ba lopu kurekure si arini. ");
INSERT INTO rug_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Ego, sa noki si keke kurukuru sekesekeina, holani sari doduru kurukuru pule, saripu ele taveti e Zihova Tamasa. Zama la ia sa noki sa barikaleqe, “Vegua, ele zama hinokara nia Tamasa sapu lopu kaqu henai gamu vuadi sari doduru huda koasa inuma hie, gua taga?” ");
INSERT INTO rug_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Meke olaṉia sa barikaleqe sa noki, “Boka henai gami sari na vuadi rina huda koasa inuma. ");
INSERT INTO rug_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Ba zama sa Tamasa sapu lopu kaqu hena ia gami sa vuana sa huda sapu koa pa vari korapana puta sa inuma, meke namu lopu kaqu tiqua gami si asa, pude lopu gua si kaqu mate si gami kara! gua.” ");
INSERT INTO rug_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Ba zama la sa noki koasa barikaleqe, “Lokari hokara lopu kaqu mate si gamu kara! ");
INSERT INTO rug_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Ura gilania Tamasa sapu pana hena ia gamu si asa, si kaqu tava vaṉunu sari na matamia, meke kaqu gua tugo sa Tamasa si gamu, pude gilania sapu leana meke sapu kaleana.” ");
INSERT INTO rug_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Meke sipu doṉo la ia sa barikaleqe sa vuana sa huda sapu doṉo lea pa matana, meke leana pude hena ia, meke ta okorae tugo pude gilae, si paketia sa si asa meke hena ia. Meke ponia sa sa loana, meke somana hena ia sa si asa. ");
INSERT INTO rug_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Meke sipu hena ia tugo ri kara si asa si hinoqa tava vaṉunu sari na matadia meke gilania ri kara sapu dodoho si arini. Ke piti vari kapaeni ri kara sari na elo piqi d pude taveteni dia tivitivi, gua. ");
INSERT INTO rug_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Pana veluvelu ibibuna sa rane si avosia ri karua tamaloana sa halabutu nenena e Zihova Tamasa pa korapa inuma, ke tome nia ri karua tamaloana si Asa pa korapa hudahuda koasa inuma. ");
INSERT INTO rug_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Ba tioko la ia e Zihova Tamasa sa tie, meke nanasia, “Pavei koa si goi?” gua. ");
INSERT INTO rug_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Meke olaṉa sa tie, “Avosia rau sa halabutu nenemu Goi pa korapa inuma, ke matagutu qua sina na dododohoqu si rau. Ke tome qua!” ");
INSERT INTO rug_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Meke zama sa Tamasa, “Esei tozi nigo sapu dodoho si goi, gua? Vegua, ele hena ia goi sa vuana sa huda sapu heki nia Rau koa goi?” ");
INSERT INTO rug_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Meke zama sa tie, “Sa barikaleqe sapu poni nau Goi, pude koa koa rau, asa si poni nau sa vuana sa huda, ke hena ia rau si asa,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Meke zama la se Zihova Tamasa koa sa barikaleqe, “Tio, na sa sapu ele tavetia goi?” Meke olaṉa sa barikaleqe, “Na sekesekei nau sa noki si rau, ke hena ia rau sa vuana sa huda,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Meke zama la ia Zihova Tamasa sa noki, “Sina ele tavete guahe si agoi, ke kaqu ta levei si goi. Koari doduru kurukuru made nenedi meke sari doduru kurukuru pinomo, ba agoi mo si ta levei. Kaqu gotolo nia goi sa tiamu, meke kaqu hena ia goi sa kavuruna sa pepeso doduru rane pa mua tinoa. ");
INSERT INTO rug_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Kaqu vekoa Rau sa vinarikanai pa varikorapamu goi meke sa barikaleqe, meke pa vari korapana sa kikomu goi, meke sa kikona sa; kaqu sekea sa sa batumu meke agoi ba kaqu garatia tugo sa huhubakuluna sa.” ");
INSERT INTO rug_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Meke koasa barikaleqe ba zama la tugo sa Tamasa, “Kaqu va nomaia Rau sa mua tinasigiti pa mua pinodopodo; meke pa tinasigiti tu si kaqu tiqe podo koburu si goi, ba kaqu okoro pule nia tugo goi sa loamu, ba kaqu palabatu nigo sa si goi.” ");
INSERT INTO rug_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Meke zama la koe Adama si Asa, “Sina ele va tabea goi sa mua barikaleqe, meke hena ia goi sa vuana sa huda, sapu heki nia Rau, pude meke mi hena ia gamu kara, gua. Mani ta levei sa pepeso koasa ginugua sapu tavetia goi. Pana gore igo tu ṉataṉata si kaqu tiqe ari gemu ginani si goi, ninae rane pa mua tinoa. ");
INSERT INTO rug_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Meke na aroso rakihi, na nobo si kaqu toqolo vura mae, meke kaqu henai gamu sari na linetelete pa inuma. ");
INSERT INTO rug_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Pana tavetavete va ṉiṉira meke gorea tu ṉataṉata sa isumatamu, si kaqu tiqe hena ginani si goi, osolae pule la koasa pepeso si goi. Na kavuru mo si goi sina agoi si ta tavetae pa pepeso mo; ke pa kavuru tugo si kaqu kekere pule la si goi.” ");
INSERT INTO rug_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ego, poza nia Ivi sa tie, sa nana barikaleqe, sina na tinadia ri doduru tie toadi si asa. ");
INSERT INTO rug_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Meke tavete poni nia poko kapu kurukuru e Zihova Tamasa, se Adama meke sa nana barikaleqe, meke va pokopokoi Sa sari kara. ");
INSERT INTO rug_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Meke tiqe zama pule se Zihova sa Tamasa, “Dotu, ele ta evaṉae kekeṉoṉo gua tugo gita sa tie, ke gilania sa sapu leana babe kaleana. Ego, mani lopu tava malumu si asa kamahire, pude qaqama la nia sa sa limana, pude vagia sa vuana sa huda tinoa meke hena ia, meke toa hola.” ");
INSERT INTO rug_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Gua asa, si hitu pania Zihova Tamasa pa Inuma Idini si asa, pude mani uma ia sa sa pepeso vasina sapu ta tavete mae guana si asa. ");
INSERT INTO rug_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Meke sipu ele hadu vura nia Sa sa tie si vekoi Sa pa kali gasa rimata koasa inuma Idini sari na mateana, meke sa vedara huruhuruṉuna, sapu avaṉa varikali pude kopu totoko nia sa siraṉa la gua koa sa huda tinoa. ");
INSERT INTO rug_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Sipu koa turaṉia Adama se Ivi, sapu sa nana barikaleqe, si aritiana si asa, meke podoa sa se Keni. Meke zama si asa, “Ele vagia rau si keke tuqu koreo koasa tinokae te Zihova,” gua. ");
INSERT INTO rug_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Meke mudina sa si podo pulea sa sa tasina, sapu se Ebolo. Meke sipu noma sage se Keni si ta evaṉae na tie uma si asa, meke se Ebolo sina tie kopu sipi. ");
INSERT INTO rug_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Meke sipu hola kaiqa totoso si paleki e Keni si kaiqa vinariponi na vuadi sari na nana linetelete pa kenuna Zihova. ");
INSERT INTO rug_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Meke se Ebolo tugo si turaṉa lani sa sari kaiqa tuna sipi podo kenudi koasa nana rovana, va vukivukihi lani sa sari na kukurudi sapu leadi na deanadi. Meke qetu nia e Zihova se Ebolo, meke sari nana vinariponi. ");
INSERT INTO rug_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Ba lopu qetu nia Sa se Keni meke sa vinariponi tanisa, ke bugoro hola se Keni, meke kaleana sa dinoṉo pa isumatana. ");
INSERT INTO rug_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ke zama ia Zihova se Keni, “Na vegua ke doṉo bugoro tu si goi, meke kaleana sa isumatamu? ");
INSERT INTO rug_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ego, be guana tavete va toṉoto si goi, si kaqu qetu nigo Rau. Ba be tavete va sea si goi si korapa eko aqa kapae nana pa sasada sa sinea, na hiva koimata nigo sa si goi, ba mamu va kilasia si asa.” ");
INSERT INTO rug_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Meke zama la ia Keni se Ebolo sa tasina, “Aria, mada la pa inuma.” Meke sipu korapa koa ri kara pa inuma, si gasa taliri la ia Keni sa tasina meke seke va matea sa si asa. ");
INSERT INTO rug_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Meke beto hoirana zama ia e Zihova se Keni, “Avei se Ebolo sa tasimu.” Olaṉa si asa, “Lokari, lopu gilania rau. Arau si lopu na tie kopu tanisa tasiqu,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Meke zama se Zihova, “Na sa si ele tavetia goi? Avosia Rau sa mamalaiṉina sa eharana sa tasimu sapu korapa titioko mae Au koasa pepeso pude hobea. ");
INSERT INTO rug_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Ele ta levei si goi meke hitu panigo Rau koa sa pepeso vasina lelete goi, vasina titisae gore sa eharana sa tasimu sapu va matea goi. ");
INSERT INTO rug_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Pana be lelete si goi koasa pepeso, ba namu loketoṉa kaqu vagia goi. Kaqu koa na tie kokokimu si goi, meke loke mua vasina soti, ba kaqu ene vilorae hoboro mo pa popoa pepeso.” ");
INSERT INTO rug_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Meke olaṉa la se Keni koe Zihova, “Namu toleṉe gua noma hola nia, sapu gua boka palekia rau, sa Mua vina kilasa koa rau. ");
INSERT INTO rug_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Dotu, pa rane ṉinoroi si ele hituau Goi si rau, koasa pepeso masuruna hie, meke lopu kaqu boka ene tata si rau pa kenumu Goi ba kaqu govegovete, na enene hoboro mo si rau pa pepeso, meke be dogorau keke tie si kaqu va mateau mo sa.” ");
INSERT INTO rug_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Ke tiqe olaṉia e Zihova si asa, “Lokari! Be seke va matego keke tie si goi si kaqu kaleana hola sa nana vina kilasa hola nia sa vina kilasa tamugoi.” Meke vekoa e Zihova si keke vina gilagila koe Keni, pude lopu kaqu tava mate hoboro si asa koa keke tie pana tutuvia. ");
INSERT INTO rug_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Meke taluarae taloa se Keni pa kenuna e Zihova meke la koa pa popoa Nodo si asa, pa kali gasa rimata pa Idini. ");
INSERT INTO rug_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Meke hola kaiqa totoso si koa turaṉia Keni sa nana barikaleqe. Ke aritiana si asa, meke podoa sa se Inoke. Meke kuria Keni si keke vasileana, meke poza luli nia sa sa popoa asa koasa pozana sa tuna sapu se Inoke. ");
INSERT INTO rug_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Meke na tuna e Inoke se Iradi, meke na tuna e Iradi se Mehuzaeli, meke na tuna Mehuzaeli se Metusaeli, meke na tuna Metusaeli se Lemeki. ");
INSERT INTO rug_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Meke habai e Lemeki si karua barikaleqe: e Eda pozana si keke, meke sapu keke pule si e Zila. ");
INSERT INTO rug_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Podoa Eda se Zabali; meke se Zabali hie, si na tie kekenu sapu tago bulumakao meke na tiatamadia ri pu hoke kokoa pa ipi poko. ");
INSERT INTO rug_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Sa pozana sa tasina si e Zubali; asa sa tamadia ri pu hoke mikemike na ivivu. ");
INSERT INTO rug_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Podoa Zila se Tubala Keni; sa ṉati tie tavetavete tiṉitoṉa tavetavetena pa boronizi meke na aeana. Meke sa vavenena e Tubala Keni si e Neama. ");
INSERT INTO rug_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Meke zama la i Lemeki sari karu nana barikaleqe, “Eda meke Zila, mi va avoso mae au gamu kara na qua barikaleqe; avosia sa qua zinama! Ele va matea rau si keke tie vaqura sina na seke va bakorau sa. ");
INSERT INTO rug_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Be ka zuapa totoso hola nia sa vina kilasa pude hobea sa minate te Keni, ba kaqu ka zuapa ṉavulu zuapa totoso tu sa vina kilasana sa tie pu va mate au,” gua se Lemeki. ");
INSERT INTO rug_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Meke va tata pulea Adama sa nana barikaleqe, meke podoa sa barikaleqe si keke tuna koreo. Meke poza nia Seti sa sa pozana, meke zama, “Ele poni hobe nau Tamasa si keke koburu pule, sapu na hinobena e Ebolo, sapu ele seke va matea e Keni.” ");
INSERT INTO rug_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Meke ta poni nia Seti si keke tuna koreo meke poza nia Inosi sa sa pozana. Pa totoso asa si tiqe podalae varavara rina tie koasa pozana e Zihova. ");
INSERT INTO rug_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Hire sari na vivineidi ri na tie pu tuti gore mae koe Adama. Sipu taveti Tamasa sari na tinoni si va podaka gunini Sa na kinehana soti si arini. ");
INSERT INTO rug_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Meke va podaka ni koreo na vineki Sa meke mana ni Sa si arini, meke pozani tinoni Sa, sipu ta tavete si arini. ");
INSERT INTO rug_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Sipu kamoa keke gogoto toloṉavulu vuahenina se Adama, si podo mae si keke tuna koreo gugua puta tugo asa, ke poza nia Seti sa si asa. ");
INSERT INTO rug_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Pa mudina sa pinodo te Seti, si toa kamoa vesu gogoto vuahenina pule se Adama, meke koadia pule kaiqa tuna koreo na vineki si asa. ");
INSERT INTO rug_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Ego sa vinarigaraedi ri doduru vuaheni pu toai Adama, si ka sia gogoto toloṉavulu, meke tiqe mate si asa. ");
INSERT INTO rug_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Sipu keke gogoto lima vuahenina se Seti, si podo mae se Inosi. ");
INSERT INTO rug_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Pa mudina sa pinodo te Inosi, si toa kamoa vesu gogoto zuapa vuahenina pule se Seti, meke koadia pule sari kaiqa tuna koreo na vineki. ");
INSERT INTO rug_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Gua asa, ke sari doduru vuahenina pu toai Seti si ka sia gogoto manege rua, meke tiqe mate si asa. ");
INSERT INTO rug_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Sipu kamoa sia ṉavulu vuahenina se Inosi si podoa sa se Kenani. ");
INSERT INTO rug_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Pa mudina sa pinodo te Kenani si toa kamoa vesu gogoto manege lima vuahenina pule se Inosi, meke koa dia pule si kaiqa tuna koreo na vineki. ");
INSERT INTO rug_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Gua asa ke sari doduru vuahenina pu toai Inosi si ka sia gogoto lima, meke tiqe mate si asa. ");
INSERT INTO rug_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Sipu kamoa zuapa ṉavulu vuahenina se Kenani, si podoa sa se Mahalaleli. ");
INSERT INTO rug_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Pa mudina sa pinodo te Mahalaleli, si toa kamoa vesu gogoto made ṉavulu vuahenina pule se Kenani, meke koadia pule si kaiqa tuna koreo na vineki. ");
INSERT INTO rug_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Gua asa ke, sari doduru vuahenina e Kenani si ka sia gogoto manege puta, meke tiqe mate si asa. ");
INSERT INTO rug_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Sipu kamoa onomo ṉavulu lima vuahenina se Mahalaleli, si podoa sa se Zaredi. ");
INSERT INTO rug_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Pa mudina sa pinodo te Zaredi, si toa kamoa vesu gogoto toloṉavulu vuahenina pule se Mahalaleli, meke koadia pule si kaiqa tuna koreo na vineki. ");
INSERT INTO rug_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Gua asa ke, sari doduru vuahenina e Mahalaleli si ka vesu gogoto vesu ṉavulu lima, meke tiqe mate si asa. ");
INSERT INTO rug_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Sipu kamoa keke gogoto onomo ṉavulu rua vuahenina se Zaredi, si podoa sa se Inoke. ");
INSERT INTO rug_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Pa mudina sa pinodo te Inoke si toa kamoa ka vesu gogoto vuahenina pule se Zaredi, meke koadia pule si kaiqa tuna koreo na vineki. ");
INSERT INTO rug_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Gua asa ke, sari doduru vuahenina e Zaredi si ka sia gogoto onomo ṉavulu rua, meke tiqe mate si asa. ");
INSERT INTO rug_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Sipu ele kamoa onomo ṉavulu lima vuahenina se Inoke, si podo mae se Metusela. ");
INSERT INTO rug_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Koa baere koe Tamasa se Inoke meke nabulu nia ka ṉeta gogoto vuaheni pa mudina sa pinodo te Metusela, meke koadia pule si kaiqa tuna koreo na vineki. ");
INSERT INTO rug_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Gua asa ke, sari doduru vuahenina e Inoke si ka ṉeta gogoto onomo ṉavulu lima: ");
INSERT INTO rug_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Koa baere koe Tamasa se Inoke, ke lopu ta dogoro, sina ele vagia Tamasa si asa. ");
INSERT INTO rug_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Sipu ele kamoa keke gogoto vesu ṉavulu zuapa vuahenina se Metusela, si podoa sa se Lemeki. ");
INSERT INTO rug_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Meke pa mudina sa pinodo te Lemeki, si toa kamoa zuapa gogoto vesu ṉavulu rua vuahenina pule se Metusela, meke koadia pule si kaiqa tuna koreo na vineki. ");
INSERT INTO rug_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Gua asa ke sari doduru vuahenina e Metusela si ka 969, meke tiqe mate si asa. ");
INSERT INTO rug_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Sipu ele kamoa keke gogoto vesu ṉavulu rua vuahenina se Lemeki, si podo mae si keke tuna koreo. ");
INSERT INTO rug_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Meke zama si asa, “Sa koreo hie si kaqu va manoto gita pa nada tinavete koasa pepeso sapu ele leve nia Zihova, meke koasa tinupiti pa limada,” meke poza nia Noa sa si asa. ");
INSERT INTO rug_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Pa mudina sa pinodo te Noa, si toa kamoa lima gogoto sia ṉavulu lima vuahenina pule se Lemeki, meke koadia pule si kaiqa tuna koreo na vineki. ");
INSERT INTO rug_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Gua asa ke, sari doduru vuahenina e Lemeki, si ka zuapa gogoto zuapa ṉavulu zuapa, meke tiqe mate si asa. ");
INSERT INTO rug_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Sipu ele kamoa lima gogoto vuahenina se Noa, si podo sari Semi, e Hami, meke e Zapeti. ");
INSERT INTO rug_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Meke sipu soku hola lala dia sari na tinoni pa popoa pepeso, meke podoi rini sari na tudia vineki, ");
INSERT INTO rug_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","meke sipu dogori rina tuna Tamasa sapu leleadi sari na tudia vineki ri na tinoni pa popoa pepeso, si okoroni rini si arini meke habai saripu vizati rini. ");
INSERT INTO rug_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Meke zama se Zihova, “Lopu kaqu va malumi Rau sari na tinoni pude koa seunae hola, sina na ta pusie masa na ehara si arini. Ke kamahire si lopu kaqu koa kamoa rini si keke gogoto hiokona puta vuaheni,” gua. ");
INSERT INTO rug_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Ego, koa rina rane sara si koadia sari na tie Nepilimi pa popoa pepeso, meke gua tugo koari na rane pa mudidia. Meke sipu koa turaṉi rina tuna Tamasa sari na tudia vineki rina tie si va podoni koburu rini. Meke sipu noma sage rini si ta evaṉae tie nomadi hola, na tie varane meke ṉiṉira hola pa vinaripera si arini. ");
INSERT INTO rug_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Meke sipu dogoria e Zihova sapu nomana hola sa sinea tadi na tinoni pa popoa pepeso, meke kaleadi la mo sari na dia binalabala doduru totoso, ");
INSERT INTO rug_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","si talotaṉa hola se Zihova sapu ele taveti tu Sa si arini, meke balabala mamata si Asa. ");
INSERT INTO rug_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Ke zama se Zihova, “Kaqu sara pani betoni Rau pa popoa pepeso sari na tinoni hire saripu taveti Rau, meke gua tugo sari na kurukuru made nene, na kurukuru ṉame na kurukuru tapuru pa galegalearane, sina talotaṉa hola nia Rau sapu ele taveti tu Rau.” ");
INSERT INTO rug_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ba se Noa si ta qetue koe Zihova. ");
INSERT INTO rug_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Hie sa vivineina e Noa. Ka ṉeta sari na tuna koreo e Noa: ari Semi, e Hami, meke e Zapeti. Keke tie toṉotona koari na tinoni si asa pa nana totoso, ke lopu ta zutu koari na sinea si asa, meke tavetavete na ene luli pa hiniva te Tamasa. ");
INSERT INTO rug_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ego, sari na tinoni pa popoa pepeso si tavete va sea pa kenuna sa Tamasa, meke ta siṉie ṉinovaṉovala variva matedi sari doduru vasina. ");
INSERT INTO rug_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Meke doṉo la pa popoa pepeso sa Tamasa, meke dogoria Sa sapu lopu toṉoto sari na hahanana tadi doduru tie, sina va kaleana puleni sari doduru tie pa sinea. ");
INSERT INTO rug_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Ke zama la ia Tamasa se Noa, “Kaqu sara pani betoni Rau sari na tinoni pa popoa pepeso, meke kaqu va kilasa betoi Rau si arini, sina siṉia mo na dia tinavete kaleadi na variva matedi sa kasia popoa,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Ego, agoi si mamu tavete nia labete ṉiṉiradi si keke aka. Mamu taveti tugo kaiqa lose pa korapana, beto mamu titani ta goi korapadi meke sadadi si arini. ");
INSERT INTO rug_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Pana tavetia goi si asa si kaqu guahe kinehana. Ka keke gogoto toloṉavulu ṉeta mita sa gelena, hiokona rua mita sa labena meke ka manege ṉeta mita sa ululuna. ");
INSERT INTO rug_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Kaqu tavete nia vetu goi sa aka. Sa ululuna sa batu vetu koasa aka si keke ṉava, meke kaqu tavete turaṉae nia keke vuida goi, pude nuquru mae sa kalalasa, padana made ṉavulu made sentimita ulununa sa vuida. Mamu taveti tugo ka ṉeta pae voloso hatara pa korapana; mamu vekoa keke sasada pa keke kalina. ");
INSERT INTO rug_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Ura dotu, kaqu va hoqa ia Rau sa luturu lavata meke kaqu naqe sa popoa, pude va mate betoi sari doduru tinoni na kurukuru, saripu koai na siniṉo pa kauruna sa maṉauru. ");
INSERT INTO rug_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ba kaqu tavetia Rau koa goi si keke vinariva egoi nabuna, meke kaqu nuquru si gamu pa korapa aka, agoi meke sari na tumu koreo, meke sari na dia barikaleqe, meke sa mua barikaleqe. ");
INSERT INTO rug_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Meke koari na tiṉitoṉa toadi pa pepeso si kaqu vagi karukarua koa ri doduru hopehopeke kinehadi sari doduru kurukuru hitekedi na nomadi pude nuquru pa korapa aka pude va toa somanae i sarini koa goi. Kaqu kokoreo na mamaqota si arini. ");
INSERT INTO rug_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Meke kaqu va suraṉi goi pa aka sari doduru votivotiki ginani pude tamugoi meke tadirini. ");
INSERT INTO rug_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Meke tavete va gorevura betoi Noa sari doduru gua pu garununi Tamasa koasa. ");
INSERT INTO rug_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Meke zama la koe Noa se Zihova, “La mamu suraṉa pa aka, gamu kasa doduru tatamana, sina ele dogoria Rau sapu agoi mo telemu sina tie toṉoto koari doduru tie pu toa pa popoa pepeso kamahire. ");
INSERT INTO rug_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Mamu turaṉa nuquru maeni ka zuapa hopehopeke karukarua, kokoreo meke maqota koari na kurukuru viadi saripu garodi pude va vukivukihini, ba koari pu lopu viadi, keke kokoreo meke keke mamaqota. ");
INSERT INTO rug_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Meke koari votivotiki puku kurukuru tapuru pa galegalearane, mamu vagi ka zuapa hopehopeke karukarua, mamu tavete gua asa pude kaqu ta kopue pude toa, pude boka hira pule pa popoa pepeso. ");
INSERT INTO rug_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Sipu hola ka zuapa rane, si kaqu garunia Rau sa ruku, sapu kaqu hoqa gore mae koari ka made ṉavulu puta rane na boṉi, pude va mate betoi sari doduru tiṉitoṉa toadi saripu ele taveti Rau,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Meke tavete betoi Noa sari doduru tiṉitoṉa saripu garununi e Zihova. ");
INSERT INTO rug_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Ka onomo gogoto vuahenina se Noa, sipu ta evaṉa sa naqe pa popoa pepeso. ");
INSERT INTO rug_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nuquru la suraṉa se Noa meke sa nana barikaleqe, meke sari na tuna koreo, meke sari na dia barikaleqe pa korapa aka, pude ta harupu koa sa naqe. ");
INSERT INTO rug_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Keke kokoreo na mamaqota koari doduru hopehopeke karukarua kurukuru toadi saripu viadi meke lopu viadi, sari na kurukuru tapuru na ṉame, si nuquru suraṉa turaṉae koe Noa pa korapa aka. ");
INSERT INTO rug_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Hola ka zuapa rane si ta evaṉa sa naqe pa popoa pepeso. ");
INSERT INTO rug_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Meke sipu onomo gogoto vuahenina se Noa, meke koasa vina manege zuapa rane pa sidara vina rua, si pusuru vura sa kolo sapu koa pa kauru pepeso meke ta tukele sa maṉauru meke hoqa gore mae sa luturu lavata. ");
INSERT INTO rug_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Meke hoqa gore pa popoa pepeso sa ruku koari ka made ṉavulu puta rane na boṉi. ");
INSERT INTO rug_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Meke koasa rane tugo asa, se Noa, meke sa nana barikaleqe, meke sari na tuna koreo sapu sari Semi, e Hami, meke e Zapeti, meke sari ka ṉeta dia barikaleqe si suraṉa pa korapa aka. ");
INSERT INTO rug_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Meke somana suraṉa luli koe Noa pa korapa aka sari doduru hopehopeke kineha kurukuru, manavasadi meke pinomodi, nomadi meke hitekedi, meke sari doduru kineha kurukuru tapuru. ");
INSERT INTO rug_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","16","Meke mae sari doduru kurukuru toadi koe Noa, meke somana suraṉa luli pa korapa aka hopehopeke karukarua, kokoreo meke mamaqota, gua sapu garunu nia Tamasa. Meke tukua Zihova sa sasadana sa aka. ");
INSERT INTO rug_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Meke lopu makudo sa naqe koari ka made ṉavulu rane, meke sagesage nana sa kolo, meke boka ale sa Aka pa beru kolo. ");
INSERT INTO rug_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Meke noma sage sa kolo, ululu hola nia sa sa pepeso meke ale pa beru kolo sa aka. ");
INSERT INTO rug_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Meke lodu beto sari doduru toqere ululudi. ");
INSERT INTO rug_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Meke sa kolo si padana ka zuapa mita ululuna gua koari na toqere. ");
INSERT INTO rug_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Meke mate beto sari doduru tiṉitoṉa toadi: sari doduru kurukuru tapuru, na kurukuru ṉame, na made nene, meke sari doduru tinoni pa popoa pepeso. ");
INSERT INTO rug_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Sari doduru tiṉitoṉa saripu siṉo pa popoa pepeso si mate beto. ");
INSERT INTO rug_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Meke huara inete pani betoi e Zihova sari doduru tiṉitoṉa toadi pa popoa pepeso: sari doduru tinoni, na kurukuru, meke sari na kurukuru tapuru. Se Noa mo meke sarini pu koa koa sa pa korapa aka si koa hola. ");
INSERT INTO rug_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Siṉi eko mo sa kolo koasa kasia popoa koari ka keke gogoto lima ṉavulu rane. ");
INSERT INTO rug_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Ba balabala ia Tamasa se Noa, meke sari doduru kurukuru saripu koa koa sa pa korapa aka, ke va givusia Sa sa popoa pepeso, meke podalae gore sa kolo. ");
INSERT INTO rug_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ego, sa kolo sapu pusuru vura mae pa kauru pepeso, meke sa luturu lavata sapu hoqa mae pa maṉauru si va betoi Tamasa. ");
INSERT INTO rug_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Meke koari ka keke gogoto lima ṉavulu rane si hitehite gore taloa pa pepeso sa kolo. ");
INSERT INTO rug_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Meke pa rane vina manege zuapa koasa sidara vina zuapa, si hake koa keke rina toqere pa Ararati sa aka. ");
INSERT INTO rug_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Meke hitehite gore luli sa kolo, meke kamoa sa rane vina keke koasa sidara vina manege puta, meke tiqe ta dogoro sari na batu minominonodi rina toqere. ");
INSERT INTO rug_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Meke sipu hola sari ka made ṉavulu puta rane, si tukelia Noa sa vuida koasa aka. ");
INSERT INTO rug_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Meke garunu vura nia sa si keke kurukuru tapuru sapu ta pozae revini; tapuru vilovilorae mo si asa, meke lopu pule mae, osolae popa beto sa kolo pa pepeso. ");
INSERT INTO rug_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Beto asa si garunia Noa si keke kukuva, pude gilania sapu be ele popa sa popoa pepeso. ");
INSERT INTO rug_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Ba sina korapa koa nana sa kolo pa doduru vasina pa pepeso, ke lopu boka dogoria sa kukuva si keke vasina pude hake magogoso si asa. Ke tapuru pule lamo pa aka si asa, meke qaqama la nia Noa sa limana, meke va nuquria si asa pa korapa aka. ");
INSERT INTO rug_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Meke aqa pule koari ka zuapa rane si asa, meke tiqe garunu vura pule nia sa sa kukuva. ");
INSERT INTO rug_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Meke kekere pule mae koe Noa si asa pana veluvelu, meke kumuhia nana pa ṉuzuna si keke elo olive toana, ke gilania e Noa sapu ele gore taloa sa kolo pa korapa pepeso. ");
INSERT INTO rug_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Pa mudina asa, si aqa pule va hola i Noa si ka zuapa rane, meke garunu vura pule la nia tugo sa sa kukuva, ba koasa totoso hie si lopu pule hokara mae si asa. ");
INSERT INTO rug_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Meke sipu kamoa onomo gogoto keke vuahenina se Noa pa rane vina keke koasa sidara kekenu pa vuaheni, si ele popa taloa hokara sa kolo pa pepeso, meke kepuhu pania Noa sa nobina sa aka meke doṉo vari likohae, meke dogoria sa sapu ele popa sa pepeso. ");
INSERT INTO rug_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Meke pa rane vina hiokona zuapa koasa sidara vina rua, si namu popa hokara sa pepeso. ");
INSERT INTO rug_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Meke zama la koe Noa sa Tamasa, ");
INSERT INTO rug_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Mu vura koasa aka si agoi meke sa mua barikaleqe, meke sari na tumu koreo meke sari na dia barikaleqe. ");
INSERT INTO rug_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Mamu va vura luli tugo koa goi sari doduru kurukuru made nene, kurukuru tapuru na kurukuru ṉame, pude boka hira pule si arini, meke koa pa doduruna sa popoa pepeso,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ke vura turaṉia Noa sa nana barikaleqe, meke sari na tuna koreo, meke sari na dia barikaleqe. ");
INSERT INTO rug_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Meke vura taloa pa doduru hopehopeke dia puku kinehadi soti sari doduru kurukuru toadi: kurukuru made nene, kurukuru ṉame na kurukuru tapuru koasa aka. ");
INSERT INTO rug_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Beto asa, si tavetia Noa si keke hope te Zihova; meke vizati sa sari kurukuru viadi pa hahanana vina vukivukihi, kaiqa koari doduru hopehopeke kurukuru ṉame viadi na kurukuru tapuru viadi, meke sa dodurudi si va vukivukihi va uququi sa si arini pa hope. ");
INSERT INTO rug_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Meke sa hibi lea tanisa vina vukivukihi va uququ si va qetua se Zihova, ke zama guahe si Asa, “Sari na dia binalabala si kaleadi podalae mae gua tu sipu na tie vaqura si arini, ba namu lopu kaqu hite leve pule nia Rau sa popoa pepeso koa gua koari na tinoni. Ke namu lopu kaqu va mate pulei Rau sari doduru tiṉitoṉa toadi pa kasia popoa, kekeṉoṉo gua sapu ele tavetia Rau kamahire. ");
INSERT INTO rug_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Be vegugua seunaena sa tinoa tanisa kasia popoa, ba sa totoso lelete meke pakepakete, totoso rukuruku meke rimata, na maṉini meke ibu, meke rane na boṉi si lopu kaqu noso.” ");
INSERT INTO rug_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Meke mana nia Tamasa se Noa meke sari na tuna koreo, meke zama si Asa, “Podopodo va sokusoku pude sari na tutimia si kaqu koa pa doduruna sa kasia popoa. ");
INSERT INTO rug_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Kaqu matagutuni gamu ri doduru kurukuru: na kurukuru tapuru, kurukuru ṉame, igana pa kolo. Meke gamu si kaqu baṉara ni si arini. ");
INSERT INTO rug_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Ego, visoroihe si ele ponini gamu linetelete Rau, ba kamahire si vatui Rau koa gamu doduru tiṉitoṉa toadi saripu niu pude mi henai. ");
INSERT INTO rug_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Ba keketoṉa mo sapu lopu kaqu hena ia gamu: sa masa sapu korapa koa ia na ehara. Lopu va malumia Rau si asa, sina sa tinoa si koa koasa ehara. ");
INSERT INTO rug_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Be va mate tie si keke tie, si kaqu tava mate tugo si asa. Meke be keke kurukuru ṉame si va mate tie si kaqu tava mate tugo si asa. ");
INSERT INTO rug_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Ego, tavetia Tamasa sa tie pa kinehana soti, ke asa sapu va matea si keke tie, si kaqu tava mate tugo pa tie si asa. ");
INSERT INTO rug_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Mi podopodo va sokusoku, meke sari na tutimia si kaqu koa pa doduruna sa kasia popoa.” ");
INSERT INTO rug_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Meke zama la koe Noa meke koari na tuna koreo sa Tamasa, ");
INSERT INTO rug_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Kamahire si tavetia Rau koa goi meke koari na tutimu, sa Qua vina tatara, ");
INSERT INTO rug_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","meke koari doduru tiṉitoṉa toadi: sari doduru kurukuru made nene, sari doduru kurukuru tapuru, meke sari doduru kurukuru ṉame saripu vura turaṉae koa goi koasa aka. ");
INSERT INTO rug_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Hire sari na Qua zinama saripu taveti Rau koari na Qua vina tatara koa gamu: Zama tokotokoro si Rau sapu namu lopu kaqu va mate pulei Rau sari doduru tiṉitoṉa toadi koasa kolo. Namu lopu kaqu ta evaṉa pule si keke naqe sapu kaqu tavahuara beto sa doduruna sa popoa pepeso. ");
INSERT INTO rug_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Ego, koasa vina gilagila loke vinabetona hie sapu korapa tavetia Rau koa gamu meke koari doduru tiṉitoṉa toadi, ");
INSERT INTO rug_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","si vekoa Rau koari na lei sa Qua bigobigo, pude na vina gilagilana sa Qua vina tatara koasa kasia popoa. ");
INSERT INTO rug_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Pana va opoadumu nia lei Rau sa galegalearane meke vura mae sa bigobigo, ");
INSERT INTO rug_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","si kaqu balabala pulea Rau sa Qua vina tatara koa gamu, meke koari doduru tiṉitoṉa toadi, sapu lopu kaqu va mate pulei Rau koasa naqe. ");
INSERT INTO rug_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Pana vura mae sa bigobigo koari na lei, si kaqu dogoria Rau meke balabala pulea sa vina tatara, sapu loke vina betona pa vari korapaqu Rau meke sari doduru tiṉitoṉa toadi pa popoa pepeso. ");
INSERT INTO rug_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Asa sa vina gilagilana sa Qua vina tatara sapu tavetia Rau koari doduru tiṉitoṉa toadi.” ");
INSERT INTO rug_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Hire sari na pozadi ri na tuna koreo e Noa saripu vura koasa aka: Ari Semi, e Hami, meke e Zapeti. E Hami si na tamana e Kenani. ");
INSERT INTO rug_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Arini sari na tuna koreo e Noa meke na tiatamadia ri doduru tinoni pa popoa pepeso. ");
INSERT INTO rug_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Se Noa hie si keke tie uma sapu lete kekenua sa inuma vaeni. ");
INSERT INTO rug_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Meke sipu ele beto napoi sa si kaiqa vaeni, si viviri va hola si asa, meke va gore pani sa sari nana poko, meke eko dododohona si asa pa korapa nana ipi poko. ");
INSERT INTO rug_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Meke se Hami sa tamana e Kenani, si dogorona sapu dododohona sa tamana, ke la tozini sa sari karu tasina. ");
INSERT INTO rug_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Ke vagia ri Semi, e Zapeti si keke poko, meke tuqe gunia ri kara pa mudi avaradia. Meke ene togotogolo mudi la pa korapana sa ipi, pude lopu dogoria eko dododohona meke nobia sa tamadia, gua. ");
INSERT INTO rug_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Meke sipu vaṉunu se Noa meke gilae pule, si gilania sa sapu gua ele evaṉia sa tuna mudina koa sa. ");
INSERT INTO rug_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Meke zama si asa, “Ta levei se Kenani! Meke kaqu koa na dia pinausu ri na tasina si asa. ");
INSERT INTO rug_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Mani tavahesi se Zihova sapu sa Tamasa te Semi! Ura kaqu nana pinausu e Semi se Kenani. ");
INSERT INTO rug_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Meke kaqu va sokua Tamasa sa tutina Zapeti! Meke sari na tutina si kaqu koa somanae koari na tinoni te Semi! Meke sari na tutina e Kenani si kaqu na pinausu tugo te Zapeti.” ");
INSERT INTO rug_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Pa mudina sa naqe lavata, si hoda la sa tinoa te Noa padana ṉeta gogoto lima ṉavulu vuaheni pule. ");
INSERT INTO rug_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Meke tiqe mate si asa sipu sia gogoto lima ṉavulu vuahenina. ");
INSERT INTO rug_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Hire sari na tuna e Noa: ari Semi, e Hami meke e Zapeti; sari ka ṉeta hire sapu pa mudina sa naqe si tiqe ari dia koburu. ");
INSERT INTO rug_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Sari na tuna e Zapeti si ari Qoma, Maqoqi, Madai, Zavani, Tubala, Meseki meke e Tirasi. Arini sari na tiatamadia ri na tinoni saripu ta pozae luli koari na pozadi. ");
INSERT INTO rug_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Sari na tututi te Qoma si ari na tinoni pa: Asikenazi, Ripati, meke Toqarama. ");
INSERT INTO rug_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Meke sari na tuna sapu gore mae gua koe Zavani si ari na tinoni hire: Elisa, Tasisi, Kitimi, meke Rodanimi. ");
INSERT INTO rug_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Arini sari na tiatamadia ri na tinoni pu koa pa raratana masa meke koari na nunusa. Meke arini tugo sari na tutina e Zapeti saripu hopeke koa koari na dia votivotiki butubutu na popoa meke hopekedi sari na dia zinama soti pu zamani rini. ");
INSERT INTO rug_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Sari na tuna e Hami si ari Itiopia, Izipi, Libia, meke Kenani. Arini sari na tiatamadia rina tinoni saripu ta pozae luli koari na pozadi. ");
INSERT INTO rug_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Sa tutina e Kusi si gore la koari na tie pa popoa Siba, Havila, Sabita, Rama meke Sabiteka. Sa tutina e Rama si gore la koari na tie pa popoa Seaba meke pa Dedani. ");
INSERT INTO rug_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","E Nimirodi si na tuna koreo e Kusi, sapu ta evaṉae na tie varane kekenu sapu ṉiṉirana pude va kilasi sari na tinoni. ");
INSERT INTO rug_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Koasa vinaritokae te Zihova, asa si keke ṉati tie hukue, meke gua asa si zama sari na tinoni, “Mani la e Zihova tavete guni nigo e Nimirodi pude na ṉati tie hukue.” ");
INSERT INTO rug_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Pa totoso kekenu hokara si somanae pa binaṉara te Nimirodi pa popoa Babiloni sari na tie hire: Babiloni, Ereke, Akadi, meke Kalane meke sari na tudia. ");
INSERT INTO rug_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","12","Koasa popoa asa si taluarae la se Nimirodi pa Siria, meke kuri sa sari na vasileana nomadi pa Ninive, Rehoboti, Ire, Kala, meke Resene, sapu koa pa vari korapana Ninive meke sa vasileana lavata pa Kala. ");
INSERT INTO rug_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","14","Sa tututi sapu gore mae gua koe Izipi, si ari na tinoni hire: Lidia, Anami, Lehabi, Napituhi, Paturusi, Kasiluhi meke sapu pa nusa Kiriti, vasina tuti gore mae sari na tie Pilisitia d. ");
INSERT INTO rug_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Sari na tuna koreo e Kenani, si e Saedoni sa kenuna meke Hitaiti. Arini sari na tinoni saripu ta pozae luli koari na pozadi. ");
INSERT INTO rug_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","E Kenani tugo sa tiatamadia ri na tie Zebusaiti, Amoraiti, Qeqasaiti, ");
INSERT INTO rug_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hivaiti, Arakaiti, meke Sinaiti; ");
INSERT INTO rug_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Avadaiti, Zemaraiti, meke Hamataiti. Sari hopeke butubutu Kenani arini si hurakatae la pude va nomaia sa dia popoa. ");
INSERT INTO rug_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Sa voloso Kenani si podalae mae gua pa Saedoni la gua pa Qerari tata pa vasileana Qaza, meke pa kali gasa rimata la gua pa Sodomu, Qomora, Adima, meke Zeboimi sapu tata pa Lasa. ");
INSERT INTO rug_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Hire sari na tutina e Hami pu hopehopeke koa koari na dia votivotiki butubutu, na popoa meke hopeke dia zinama soti. ");
INSERT INTO rug_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Semi, sa tasina kenuna e Zapeti, si na tiatamadia ri doduru butubutu Hiburu. ");
INSERT INTO rug_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sari na tuna koreo e Semi si ari Elami, Asura, Apakisadi, Ludi meke Arami. Arini sari na tiatamadia ri na tinoni saripu ta pozae luli koari na pozadi. ");
INSERT INTO rug_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Sa tututi sapu gore mae gua koe Arami si ari na tinoni pa Uzi, Huli, Qetera meke Meseki. ");
INSERT INTO rug_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Sa tuna e Apakisadi si e Sela, meke se Sela hie sina tamana e Ebera. ");
INSERT INTO rug_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Karua tuna koreo se Ebera: keke si ta pozae Peleqi, sina pa nana totoso, si ta paqaha sari na tinoni pa kasia popoa, meke sa tasina si ta pozae Zokitani. ");
INSERT INTO rug_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Sari na tututi sapu gore mae gua koe Zokitani si ari na butubutu tie hire: Alomodadi, Selepi, Hazamaveti, Zera, ");
INSERT INTO rug_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoramu, Uzali, Dikila, ");
INSERT INTO rug_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obali, Abimaele, Siba, ");
INSERT INTO rug_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Opira, Havila, meke e Zobabi. Doduru arini si gore mae guadi koe Zokitani. ");
INSERT INTO rug_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Sa popoa sapu koa ia rini si podalae mae gua pa Mesa, meke la gua pa Separa koari na vasidi toqetoqeredi pa kali gasa rimata. ");
INSERT INTO rug_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Arini sari na tututi saripu gore mae gua koe Semi, saripu hopeke koa koari na dia butubutu na popoa, hopeke pukuna hire si zamani sari dia zinama soti. ");
INSERT INTO rug_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Sari doduru tinoni arini si tuti gore mae gua koe Noa, sari hopeke butubutu, luli gua koari dia votivotiki puku ginore. Pa mudina sa naqe sari doduru butubutu tie pa pepeso si tuti gore mae guadi koari na tudia ri na tuna koreo e Noa. ");
INSERT INTO rug_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Pa totoso pukerane hola sari na tinoni pa kasia popoa si kekeke mo sa dia vinekala meke kekeṉoṉo mo sari na dia pinozapoza. ");
INSERT INTO rug_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Sipu korapa ene vilorae si arini pa kali gasa rimata si mae kamoa rini sa pezara pa Babiloni, meke la veko kinoa vasina si arini. ");
INSERT INTO rug_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Meke vari zamai si arini, “Aria, mada tavete biriki, mada motui pude ṉiṉira si arini,” gua. Ke ari dia biriki si arini pude kurikuri meke titani ta rini pude tuqe vari napitini. ");
INSERT INTO rug_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Meke zama guahe si arini, “Aria mada tavetia si keke vasileana lavata meke keke vetu ululuna sapu sage la gua pa galegalearane, pude va lavata puleni gita meke lopu kaqu ta hurakatae lamae pa doduruna sa kasia popoa si gita.” ");
INSERT INTO rug_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Meke tiqe gore mae dogoria e Zihova sa vasileana lavata meke sa vetu ululuna sapu ele va turua ri na tinoni, ");
INSERT INTO rug_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","meke zama si Asa, “Dotu, kamahire si koa vari kekei sari na tinoni hire, meke kekeke mo sa vinekala sapu zama nia rini. Hie si tiqe na pinodalaena sapu gua hiva tavetia rini; lopu kaqu seunae meke kote boka taveti mo rini doduru gua pu hiva nia rini! ");
INSERT INTO rug_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Aria, mada gore la, mada vari henihenie ni sari dia zinama pude lopu kaqu vari gilani si arini.” ");
INSERT INTO rug_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Ke veko va hurakatae ni e Zihova si arini pa doduru vasina pa popoa pepeso, meke noso si arini pa kinurina sa vasileana lavata. ");
INSERT INTO rug_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Gua asa ke ta pozae Babele sa vasileana lavata asa, sina vasina si vari nurae nia e Zihova sa vinekala tadi doduru tinoni; meke podalae vasina tugo si va hurakatae lani Sa si arini pa doduru vasina pa popoa pepeso. ");
INSERT INTO rug_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Hire sari na tututi saripu gore mae guadi koe Semi. Karua vuaheni hola gua pa mudina sa naqe, sipu keke gogoto vuahenina se Semi, si tiqe ta podo se Apakisadi sa tuna koreo. ");
INSERT INTO rug_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Beto asa, si koa kamoa sa sa vina lima gogoto vuahenina, meke vagi pulei sa si kaiqa koburu. ");
INSERT INTO rug_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Meke sipu toloṉavulu lima vuahenina se Apakisadi si ta podo si keke tuna koreo; pozana sa si e Sela. ");
INSERT INTO rug_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Beto asa, si koa kamoa sa sa vina made gogoto ṉeta vuahenina, meke tiqe vagi pulei sa si kaiqa koburu. ");
INSERT INTO rug_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sipu kamoa toloṉavulu vuahenina se Sela, si ta podo si keke tuna koreo, pozana sa si e Ebera. ");
INSERT INTO rug_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Beto asa, si koa kamoa sa sa vina made gogoto ṉeta vuahenina meke vagi pulei sa si kaiqa koburu. ");
INSERT INTO rug_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Meke sipu ka toloṉavulu made vuahenina se Ebera, si ta podo si keke tuna koreo, pozana sa si e Peleqi. ");
INSERT INTO rug_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Beto asa si koa kamoa sa sa vina made gogoto toloṉavulu vuahenina, meke vagi pulei sa si kaiqa koburu. ");
INSERT INTO rug_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Meke sipu ka toloṉavulu vuahenina se Peleqi si ta podo si keke tuna koreo, pozana sa si e Reu. ");
INSERT INTO rug_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Beto asa, si koa kamoa sa sa vina karua gogoto sia vuahenina meke vagi pulei sa si kaiqa koburu. ");
INSERT INTO rug_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Meke sipu toloṉavulu rua vuahenina se Reu, si ta podo si keke tuna koreo, pozana sa si e Seruqi. ");
INSERT INTO rug_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Beto asa, si koa kamoa sa sa vina karua gogoto zuapa vuahenina, meke vagi pulei sa si kaiqa koburu. ");
INSERT INTO rug_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Meke sipu toloṉavulu vuahenina se Seruqi, si ta podo si keke tuna koreo, pozana sa si e Nehoa. ");
INSERT INTO rug_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Beto asa, si koa kamoa sa sa vina karua gogoto vuahenina, meke vagi pulei sa si kaiqa koburu. ");
INSERT INTO rug_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Meke sipu hiokona sia vuahenina pule se Nehoa, si ta podo si keke tuna koreo, pozana sa si e Tera. ");
INSERT INTO rug_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Beto asa, si koa kamoa sa sa vina keke gogoto manege sia vuahenina, meke vagi sa si kaiqa koburu. ");
INSERT INTO rug_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Pa mudina sipu zuapa ṉavulu vuahenina se Tera, si ta podo sari Ebarami e Nehoa meke Harani. ");
INSERT INTO rug_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Ego, hire si arini pu tututi gore mae gua koe Tera, sapu sa tamadia ri Ebarami, Nehoa, meke Harani. Se Harani si na tamana e Loti. ");
INSERT INTO rug_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Meke mate se Harani koasa nana vasileana soti, pa Ura pa popoa Babiloni, sipu korapa toa nana sa tamana. ");
INSERT INTO rug_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Meke haba ia Ebarami se Serai, meke se Nehoa si haba ia se Milika, sa tuna vineki e Harani, meke na tamana tugo e Isika. ");
INSERT INTO rug_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Ba tige se Serai, ke loke tuna. ");
INSERT INTO rug_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Meke vagia Tera sa tuna koreo, sapu se Ebarami, meke e Loti sa tuna sa tasina Ebarami sapu se Harani, meke sa barikaleqe te Ebarami, sapu se Serai, meke turaṉa taloani sa si arini koasa vasileana lavata pa Ura pa popoa Babiloni, pude la pa popoa Kenani, ba sipu kamoa rini si pa Harani si la koa vasina si arini. ");
INSERT INTO rug_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Meke vasina si mate se Tera sipu karua gogoto lima vuahenina si asa. ");
INSERT INTO rug_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Meke zama la koe Ebarami se Zihova, “Mu luaria sa mua popoa, na turaṉamu, meke sa mua tatamana nomana, mamu la koasa popoa sapu kaqu va dogoro nigo Rau. ");
INSERT INTO rug_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Meke kaqu va sokui Rau sari na tutimu, meke kaqu ta evaṉae na butubutu nomana lavata, meke kaqu mana nigo Rau si goi, meke kaqu vata gilania Rau sa pozamu, pude tamanae koa goi sari na tinoni. ");
INSERT INTO rug_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Kaqu manani Rau si arini pu mana nigo, ba kaqu leveni Rau si arini pu leve nigo, meke koa goi meke sa tutimu goi si kaqu manani Rau sari doduru butubutu pa kasia popoa.” ");
INSERT INTO rug_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Sipu ka zuapa ṉavulu lima vuahenina se Ebarami, si taluarae pa popoa Harani si asa, gua tugo sapu tozi nia e Zihova pude tavetia Sa, meke luli koasa se Loti. ");
INSERT INTO rug_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Meke turaṉia Ebarami se Serai, sa nana barikaleqe, meke se Loti, sa tuna sa tasina, meke sari doduru dia tinagotago saripu ele va qaqiri rini, meke sari doduru pinausu saripu vagini rini pa Harani; meke taluarae la pa popoa Kenani si arini. Meke sipu kamo si arini pa popoa Kenani, ");
INSERT INTO rug_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","si enea Ebarami sa korapa popoa osolae kamoa sa si keke huda hopena pa More, sa vasina hopena pa Sekemi. Pa totoso asa sari na tie Kenanaiti si korapa koadia koasa popoa asa. ");
INSERT INTO rug_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Meke vura koe Ebarami se Zihova, meke zama, “Hiera sa popoa sapu kaqu vatua Rau koasa tutimu,” gua. Beto asa si tavete vala nia Ebarami si keke hope te Zihova sapu vura koasa vasina asa. ");
INSERT INTO rug_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Beto hoi si rizu la si asa koari na popoa toqetoqere, meke la va turu nana ipi pa vari korapana Betolo pa kali lodu rimata, meke Ai pa kali gasa rimata. Meke vasina tugo si tavetia sa si keke hope meke vahesia sa se Zihova. ");
INSERT INTO rug_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Beto asa si rizu vari tetei la si asa koari na vasidi, sapu la gua pa popoa Neqevi d pa popoa Kenani. ");
INSERT INTO rug_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Ba soṉe si pa Kenani, meke kaleana sisigiti, ke rizu va seu gore la pa popoa Izipi si asa, pude koa paki vasina, gua. ");
INSERT INTO rug_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Meke sipu tata ene karovia sa sa voloso, sapu nuquru la gua pa korapa popoa Izipi, si zama ia sa sa nana barikaleqe, sapu se Serai, “Agoi si keke barikaleqe tolavaemu hola. ");
INSERT INTO rug_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Pana dogorigo rina tinoni pa popoa Izipi si goi, si kote va hinokaria rini, sapu agoi si na qua barikaleqe, meke kote va mateau rini, meke agoi si kote tava toa. ");
INSERT INTO rug_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Mu tozini sapu na tasiqu vineki si goi, meke pa ginuamu goi si kote va toa au rini meke kopu valeanau,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Meke sipu karovia sa sa voloso meke ene la pa korapa popoa Izipi, si dogoria rina tinoni pa popoa Izipi, sapu tolavaena hola sa nana barikaleqe. ");
INSERT INTO rug_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Meke kaiqa rina palabatu, si dogoria si asa, meke la tozia koasa baṉara, sapu tolavaena hola si asa, gua. Ke ta turaṉa la si asa, pa vetu tanisa baṉara. ");
INSERT INTO rug_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Ego, koasa ginuana e Serai, si ta kopue valeana se Ebarami, meke ponia rovana sipi na qoti, na bulumakao, na doṉ'ki, na kameli, meke na pinausu tie sa baṉara si asa. ");
INSERT INTO rug_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ba sina ele vagia sa baṉara se Serai, ke garunu lani e Zihova sari na minoho kaleadi hola koasa, meke koari na tinoni pa nana vetu baṉara. ");
INSERT INTO rug_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Ke tiokia sa baṉara se Ebarami meke nanasia, “Nasa si tavete mae nia goi koa rau? Na vegua ke lopu tozi nau goi, sapu na mua barikaleqe si asa? ");
INSERT INTO rug_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Na vegua ke zama nia goi sapu na tasimu vineki si asa gua, ke vagia rau pude na qua barikaleqe? Ego hie sa mua barikaleqe. Vagia! Mamu taloa!” ");
INSERT INTO rug_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Meke garuni sa baṉara sari nana tie, meke vagia rini se Ebarami, meke va vura taloa ia rini si asa pa popoa, meke gua tugo sa nana barikaleqe, meke sari doduru likakalae pu tagoi sa. ");
INSERT INTO rug_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Meke ene vura taloa gua pa popoa Izipi si asa, meke ene sage la gua pa popoa Neqevi, meke luli koasa se Serai sa nana barikaleqe meke sari doduru dia likakalae meke se Loti tugo. ");
INSERT INTO rug_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Keke tie tagotago hola se Ebarami. Soku hola nana sipi, na qoti, meke na bulumakao, meke gua tugo na poata siliva na qolo. ");
INSERT INTO rug_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","4","Beto hoi, si taluarae si asa vasina, meke ririzu vari tetei la gua pa Betolo. Meke kamoa sa sa vasina pa vari korapana Betolo meke Ai, vasina sapu ele koa ia meke kuri ia sa si keke hope tatasana, meke vahesia sa vasina se Zihova. ");
INSERT INTO rug_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","E Loti ba ari nana sipi, na qoti, meke na bulumakao tugo, meke sa nana tatamana soti, meke sari nana pinausu tie tugo. ");
INSERT INTO rug_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Meke gua asa, si lopu pada sari na duduli meke sari na ginani vasina sapu koa varigara ia ri karua, sina soku hola sari na dia kurukuru. ");
INSERT INTO rug_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Ke vura mae sa vinari kakatorai pa varikorapadia ri na tie kopu kurukuru te Ebarami, meke saripu te Loti. Pa totoso hie si korapa koadia pa popoa hie sari na tinoni Kenanaiti, meke sari na tinoni Perizaiti. ");
INSERT INTO rug_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Meke zama la koe Loti se Ebarami, “Gita kara si keke tiena mo, meke lopu leana pude varikakatorai si gita kara meke sari na nada tie tavetavete. ");
INSERT INTO rug_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Pada mo sa popoa, ke mada varipaqahi. Kaqu vizatia goi sa kukuru pepeso sapu hiva nia goi. Mamu la pa keke kalina si goi, meke arau si maqu la pa keke kalina,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Meke doṉo vari likohae kamo la gua pa doduruna Zoara se Loti, meke dogoria sa sa doduruna sa pezara pa Zodani, sapu sokua na kolo, guana inuma te Zihova, babe guana pepeso pa Izipi si asa. Sa totoso hie si lopu ele huari e Zihova sari na vasileana lavata pa Sodomu meke Qomora. ");
INSERT INTO rug_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Ke vizatia e Loti sa doduruna sa pezara pa Zodani, pude tanisa gua; meke rizu la gua si asa pa kali gasa rimata. Asa sa guguana sa vinari paqahi tadi karua tie hire. ");
INSERT INTO rug_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Meke koa pa popoa Kenani se Ebarami, meke Loti si koa koari na vasivasileana lavata koasa lolomo tata pa Sodomu, ");
INSERT INTO rug_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","vasina sapu koa sari na tie kaleadi na tie sea pu lopu lulia sa hiniva te Zihova. ");
INSERT INTO rug_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Pa mudina sipu ele taloa se Loti, si mae koe Ebarami se Zihova meke zama, “Mamu doṉo valeana la pa doduru vari kalimu. ");
INSERT INTO rug_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Sari doduru pepeso pu dogori goi sara, si kaqu poni betoni Rau koa goi, meke koarini pu tuti gore mae koa goi. Meke kaqu tamugoi si arini ninae rane. ");
INSERT INTO rug_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Sari na tutimu pu kaqu ponigo rau, si kaqu soku hola, meke loke tie si kaqu boka nae betoi si arini; kekeṉoṉo gua tugo sapu lopu kaqu boka ta nae sari na kavuru pa pepeso. ");
INSERT INTO rug_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Ego, la mamu ene dogoria sa doduruna sa pepeso kamahire, sina sa doduruna sa pepeso asa, si kaqu poni beto nia Rau koa goi.” ");
INSERT INTO rug_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Ke va rizua Ebarami sa nana ipi, meke la va turua sa, tata koasa huda hopena te Mamere, sapu koa pa Heboroni. Meke vasina si tavetia sa sa hope te Zihova. ");
INSERT INTO rug_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","2","Koadia koasa totoso asa si ka made baṉara: Aramapeli pa Babiloni, se Arioko, sa baṉara pa Elasara, se Kedoleoma, sa baṉara tadi pa Elami, meke se Tidali, sa baṉara tadi pa Qoimi. Meke somana varipera si arini koari ka lima baṉara hire: se Bera sa baṉara pa Sodomu, se Birisa sa baṉara pa Qomora, se Sinabe sa baṉara pa Adama, se Semeba sa baṉara pa Zeboimi, meke sa baṉara pa Bela sapu ta pozae Zoara kamahire. ");
INSERT INTO rug_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Ego, sari ka lima baṉara hire si varigara nia rini si keke qeto minate koasa pezara pa Sidimi, sapu kamahire ta pozae na Kolo Matena. ");
INSERT INTO rug_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Koari ka manege rua vuaheni pu ele hola, si ta kopue pa kauruna sa binaṉara te Kedoleoma si arini, ba pa vuaheni vina manege ṉeta si lopu hiva nia rini si asa. ");
INSERT INTO rug_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Pa vuaheni vina manege made, si mae se Kedoleoma, meke sari ka ṉeta baṉara pa kalina tanisa, meke sari na dia tie varipera, meke va kilasi sari na tinoni Repaimi koasa vasileana pa Asiteroti Kanaimi, meke sari na tinoni Zuzi pa Hami, meke sari na tinoni Emi koasa pezara pa Kiriataimi, ");
INSERT INTO rug_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","meke sari na tinoni Horaiti saripu koa koari na toqetoqere pa Edomu d. Meke hadu zukuru va seu lani rini pa Eliparane, koasa hukihukirina sa qega si arini. ");
INSERT INTO rug_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Beto asa, si kekere pule mae pa Enemisipati si arini sapu pa Kadesi gunia gita kamahire, meke va kilasi rini sari doduru popoa tadi na tinoni Amaleki meke Amoraiti saripu koa koasa vasileana lavata pa Hazazoni Tamara. ");
INSERT INTO rug_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Meke va namanama i ri na baṉara pa Sodomu, Qomora, Adama, Zeboimi meke Bela sari na dia tie varipera koasa pezara pa Sidimi pude varipera meke razai, ");
INSERT INTO rug_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","sari na baṉara tadi pa Elami, Qoimi, Babiloni, meke Elasara. Sari ka lima baṉara sara si razai sari ka made baṉara hire. ");
INSERT INTO rug_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ba sa pezara sana si sokua na pou sapu siṉi na ta, meke sipu podepodekae govete taloa sari na tie varipera tadi na baṉara pa Sodomu meke Qomora koasa vinaripera, si hoqa voini koari na pou si arini, ba kaiqa pule si kakalopuhu taloa dia koari na toqetoqere. ");
INSERT INTO rug_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Meke vagi betoi ri ka made baṉara sari doduru likakalae na ginani koari na vasileana pa Sodomu meke Qomora, meke taloa dia. ");
INSERT INTO rug_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Se Loti sa tuna sa tasina Ebarami, si koa nana pa Sodomu, ke vagia rini si asa meke sari doduru nana likakalae. ");
INSERT INTO rug_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Ba keke tie si govete taloa, meke la tozi sa koe Ebarami sari doduru ginugua. Ebarami sapu na tie Hiburu, si koa tata koari na huda hopedi te Mamere sa tie Amoraiti. Se Mamere meke sari na tasina, sapu ari Esikolo meke Anera si variva egoi pude varipera koa rina kana pa kalina te Ebarami. ");
INSERT INTO rug_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Meke sipu avosia Ebarami sapu ele ta raovo vagi sa buhina, si tioko varigarani sa sari na tie varipera pa korapana sa nana puku minate. Ari ka ṉeta gogoto manege vesu sari doduru pu pododi koari na ipi te Ebarahami, meke hadu luli sa sari ka made baṉara, osolae kamo la gua tu tata pa vasileana Dani. ");
INSERT INTO rug_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Meke vasina si paqahi sa sari nana tie, meke rapati sa sari na kana pana boṉi, meke va kilasi sa si arini. Hadu va seu la guni sa pa Hoba, pa kali la gua pa Damasikasi. ");
INSERT INTO rug_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Meke vagi pule ni rini sari doduru likakalae saripu vagi taloa ni rina baṉara. Gua tugo se Loti sapu sa tuna sa tasina, meke sari nana likakalae, meke sari na barikaleqe, meke sari kaiqa tie ta pusidi. ");
INSERT INTO rug_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Pa mudina sa pinule va mataqara te Ebarami koe Kedoleoma meke sari kaiqa baṉara pule, si mae tutuvia sa baṉara Sodomu si asa, koasa lolomo pa Save (sapu ta pozae kamahire, Na Lolomo tadi na Baṉara). ");
INSERT INTO rug_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Meke se Melekizadeki sa baṉara pa Salema, sapu keke hiama tugo tanisa Tamasa Ululuna Hola, si paleke mae bereti meke na kolo vaeni koe Ebarami. ");
INSERT INTO rug_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Meke mana nia sa si asa, meke zama, “Mani mana nia sa Tamasa Ululuna Hola, sapu tavetena sa maṉauru na pepeso, se Ebarami! ");
INSERT INTO rug_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Mani tavahesi sa Tamasa Ululuna Hola sapu ponigo sa minataqara koari na mua kana.” Meke ponia Ebarami koe Melekizadeki sa keke pa manege koari doduru likakalae saripu vagi puleni sa. ");
INSERT INTO rug_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Meke zama la koe Ebarami sa baṉara pa Sodomu, “Mu va naqiti sari na likakalae pu vagi goi, ba mamu va pule maei koa rau sari doduru qua tie,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Meke olaṉa se Ebarami, “Zama tokotokoro si rau pa kenuna e Zihova, sa Tamasa Ululuna Hola sapu tavetena sa maṉauru meke na pepeso, ");
INSERT INTO rug_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","sapu lopu kaqu va naqitia rau si keke vasi toṉa tamugoi, be na lozi sia babe keke sadolo, ba namu lokari tugo. Meke pa mudina si namu lopu kaqu boka zama si goi, ‘Arau mo ele va tagotagoa se Ebarami,’ gua. ");
INSERT INTO rug_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Namu loketoṉa hokara si kaqu vagia rau. Ba kaqu qetuni mo rau, sapu gua ele henai rina qua tie. Ba madi vagi rina qua baere, ari Anera, Esikolo meke e Mamere sari dia hinia, ura na somana pa qua kalina si arini,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Meke sipu hola sapu gua asa, si mae zama koe Ebarami pa keke dinogodogorae se Zihova. Meke zama guahe, “Ebarami, mu lopu koa matagutu! Ura kote lavelave hukata nigo Rau koari na tinasuna. Meke kote ponigo Rau sa pinia nomana lavata,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Ba olaṉa se Ebarami, “Ke Zihova, Baṉara, na sa laena sa Mua vinariponi koa rau, sina loke qua koburu si rau? Se Elieza mo, sa tie Damasikasi, si kaqu vagi betoi sari doduru qua likakalae. ");
INSERT INTO rug_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Na lopu poni au koburu Goi si rau, meke keke mo koari kasa qua pinausu, si kaqu vagi betoi sari qua likakalae.” ");
INSERT INTO rug_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Meke zama pule se Zihova, “Se Elieza, sa mua pinausu hie, si lopu kaqu vagi sari na mua likakalae, ba sa koreo, sa tumu soti tu si kaqu vagi betoi si arini,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Meke turaṉa la nia e Zihova pa sada si asa, meke zama, “Mu eṉa sage la pa maṉauru, mamu podekia nae i sari na pinopino. Sarini pu tuti gore mae gua koa goi, si kaqu soku holani si arini,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Meke raṉea Ebarami se Zihova, meke pa ginua asa, si poza nia na tie toṉoto e Zihova si asa. ");
INSERT INTO rug_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Meke zama se Zihova koasa, “Arau se Zihova sapu turaṉa vura nigo pa Ura, pa popoa Babiloni, meke poninigo sa popoa hie pude tamugoi soti.” ");
INSERT INTO rug_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ba nanasia Ebarami si Asa, “Ke Zihova, Baṉara, vegugua meke kaqu boka gilana valeania rau sapu kaqu taqarau soti si asa?” ");
INSERT INTO rug_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Meke olaṉa si Asa, “Mu turaṉa mae nia si keke bulumakao, keke qoti, meke keke sipi, hopehopeke ka ṉeta vuahenidi, meke keke baruku meke keke kukuva,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Meke paleke lani Ebarami koe Zihova sari na kurukuru, meke magu viqala ruai sa meke veko varivarikalini sa pa karua tokele, ba lopu magui sa sari na kurukuru tapuru. ");
INSERT INTO rug_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Meke tapuru gore mae sari na kurukuru nomadi koari na kurukuru matedi, ba hadu pani Ebarami si arini. ");
INSERT INTO rug_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Meke sipu lodu gore sa rimata, si eko meke puta muliuṉu se Ebarami; meke kamo sa huporo variva matagutuna koasa. ");
INSERT INTO rug_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Meke zama koasa se Zihova, “Kaqu ta evaṉae na tie karovodi pa votiki popoa sari na tutimu, meke kote tava pinausu vasina si arini, meke koari ka made gogoto vuaheni si kaqu ta ṉoṉovala si arini. ");
INSERT INTO rug_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ba kaqu va kilasia Rau sa butubutu sapu va pinausu i si arini, meke pana taluarae si arini koasa votiki popoa sana, si kaqu vagi dia tinagotago koa rina tie vasina si arini. ");
INSERT INTO rug_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ba agoi si kaqu barogoso va gorevura, meke tiqe mate pa binule, meke ta pomunae. ");
INSERT INTO rug_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Ba kaqu kamo pakia made gogoto vuaheni, beto tu hoi si kaqu tiqe pule mae tani sari na tutimu. Ura lopu kaqu va mate pani Rau sari na tinoni Amoraiti, osolae pada mo sa dia sinea, meke kaqu tiqe tava kilasa si arini.” ");
INSERT INTO rug_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Meke sipu lodu sa rimata meke huporo sa popoa, si hinoqa vura mae si keke vovoina tuṉaha nika, meke sa zuke huruṉuna, meke ene hola gua pa varikorapadi rina minagumagu kurukuru ṉame si arini. ");
INSERT INTO rug_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Meke koasa rane tugo asa, si tavetia Zihova si keke vinariva egoi nabuna koe Ebarami. Zama si Asa, “Va tatara nia Rau pude ponia koari na tutimu, sa doduruna sa pepeso hie, podalae mae gua koasa voloso pa popoa Izipi meke kamoa sa Ovuku Iuparetisi. ");
INSERT INTO rug_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Sa pepeso tadi na butubutu Kenaiti, Kenizaiti, Kadimonaiti, ");
INSERT INTO rug_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hitaiti, Perizaiti, Repaimi, ");
INSERT INTO rug_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amoraiti, Kenanaiti, Qeqasaiti, meke sa butubutu Zebusaiti.” ");
INSERT INTO rug_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Se Serai, sa barikaleqe te Ebarami si loke nana koburu. Ba tagoa sa si keke pinausu vineki Izipi, sa pozana si e Hega, ");
INSERT INTO rug_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","gua asa ke zama la koe Ebarami se Serai, “Se Zihova si hukatau meke lopu poni au koburu kamo kamahire. Mamu la koa turaṉia sa qua pinausu vineki. Gina asa si kote boka podo poni au keke koburu si rau.” Meke va egoa Ebarami sapu gua zama nia e Serai. ");
INSERT INTO rug_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Ke vala Serai koe Ebarami se Hega pude koa turaṉa pakia gua. Sa ginugua hie si ta evaṉa pa mudina ka manege puta vuaheni sipu koa pa Kenani se Ebarami. ");
INSERT INTO rug_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Meke koa turaṉia Ebarami se Hega, ke aritiana si asa, meke sipu gilania sa sapu aritiana si asa, si podalae vahesi pule nia meke doṉo va gorea sa sa nana barikaleqe koimata. ");
INSERT INTO rug_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Meke zama se Serai koe Ebarami, “Na mua sinea ke doṉo va gore au e Hega si rau. Arau soti vatua si asa koa goi, meke seunae gua, sipu gilania sa sapu aritiana si asa, si doṉo va gore au sa si rau. Mani vilasia e Zihova sapu esei gita si toṉoto, agoi babe arau!” gua se Serai. ");
INSERT INTO rug_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Meke olaṉa se Ebarami, “Leana hola, na mua pinausu meke koa kaurae pa mua kinopu si asa, ke mamu tavetia sapu gua hiva nia goi koasa.” Meke ṉoṉovalia Serai se Hega, ke govete taloa si asa. ");
INSERT INTO rug_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Meke dogoria sa mateana te Zihova se Hega tata koasa kolo pa korapa qega ivuluna, koasa siraṉa la gua pa Sura. ");
INSERT INTO rug_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Meke zama la ia sa si asa, “Hega, pinausu te Serai, pavei mae guamu, meke pavei si korapa la gua si goi?” Meke olaṉa se Hega, “Na korapa govete va seu nia rau sa qua barikaleqe koimata,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Meke zama sa mateana, “Mu kekere pule la, mamu koa na pinausu pule koasa.” ");
INSERT INTO rug_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Beto hoi si zama si asa, “Kaqu ponigo rau soku hola tutimu, meke loke tie si kaqu boka nae i si arini. ");
INSERT INTO rug_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Kaqu vagia goi si keke tumu koreo meke kaqu poza nia Isimeli goi sa pozana, sina ele avosia e Zihova sa mua kinabo talotaṉa. ");
INSERT INTO rug_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ba sa tumu koreo si kote koa guana doṉ'ki pinomona si asa. Meke kote kanai sa sari doduru tie, meke sari doduru tie ba kote kana ia tugo si asa. Meke kote koa vata kale koari doduru turaṉana si asa.” ");
INSERT INTO rug_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Meke poza nia e Hega se Zihova sapu ele zama koasa, sapu guahe: “Agoi sina Tamasa sapu dogorau,” gua. Ura zama pule nia se Hega, “Ele dogoro hinokaria rau sa Tamasa, sapu korapa dogorau Sa,” gua. ");
INSERT INTO rug_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Gua asa ke poza nia rina tie, sa berukehe pa vari korapana Kadesi meke Beredi, “Na berukehe tanisa Tamasa Toana sapu dogorau.” ");
INSERT INTO rug_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Meke podoa Hega si keke tuna koreo e Ebarami, meke poza nia Isimeli sa si asa. ");
INSERT INTO rug_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Pa totoso tugo asa, si ka vesu ṉavulu onomo vuahenina se Ebarami. ");
INSERT INTO rug_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Meke sipu kamoa sia ṉavulu sia vuahenina se Ebarami, si vura koasa se Zihova meke zama: “Arau sa Tamasa pu tagoi sari doduru ṉiniraṉira. Mu va tabe Au. Mamu tavetia sapu toṉoto doduru totoso. ");
INSERT INTO rug_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Kaqu tavetia Rau sa qua vinariva egoi koa goi, meke kaqu ponigo soku tutimu.” ");
INSERT INTO rug_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Meke hoqa oporapaha pa pepeso se Ebarami, meke zama sa Tamasa, ");
INSERT INTO rug_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Tavetia Rau sa Qua vinariva egoi koa goi, va tatara nia Rau sapu agoi si kaqu na tiatamadia ri soku butubutu. ");
INSERT INTO rug_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Sa pozamu si lopu kaqu e Ebarami, ba e Ebarahami tu, sina vata evaṉae nigo Arau na tamadia ri soku butubutu si goi. ");
INSERT INTO rug_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Kaqu ponigo soku tutimu Rau si goi, meke kaiqa arini si kaqu na baṉara. Kaqu soku hola sari na tutimu, meke kaqu ta evaṉae soku butubutu sokudi si arini. ");
INSERT INTO rug_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Kaqu kopu nia Rau sa Qua vina tatara koa goi meke koari na tutimu pude lulia, guana vinariva egoi sapu koa holana koari na sinage na sage vugo repere. Meke Arau si kaqu na mua Tamasa, meke na Tamasa tadirini pu tututi gore mae gua koa goi. ");
INSERT INTO rug_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Sa pepeso hie sapu korapa koa ia goi na tie karovomu kamahire, si kaqu ponia Rau koa goi, meke koarini pu tututi gore mae gua koa goi. Meke sa doduruna sa pepeso pa popoa Kenani, si kaqu tadirini ninae rane, meke Arau si kaqu na dia Tamasa.” ");
INSERT INTO rug_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Meke zama la koe Ebarahami sa Tamasa, “Agoi ba kaqu kopu nia sa vinariva egoi koa Rau. Agoi meke saripu tututi gore mae gua koa goi koari na sinage na sage vugo repere, ");
INSERT INTO rug_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","si kaqu va ego betoa pude ta magu sari doduru koreo koa gamu. ");
INSERT INTO rug_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","12","Podalae kamahire, si kaqu magui gamu sari doduru koburu haha koreo sipu ka vesu rane seunae gua ta podo si arini, meke sarini pu podo koari na pinausu pa mia vetu, meke sari na pinausu saripu ta vagi mae koari na votiki popoa. Sa minagu hie si kaqu na vina gilagilana pude vata dogoro nia sapu koa nana si keke vinariva egoi pa varikorapa mia gamu meke Arau. ");
INSERT INTO rug_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Hopeke tie si kaqu ta magu, meke asa sa vina gilagila tanisa tini, pude va dogoro nia sapu sa Qua vinariva egoi koa gamu si koa hola. ");
INSERT INTO rug_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Be keke koreo si lopu ta magu, si lopu kaqu ta balabala sapu keke koari na Qua tinoni si asa, sina lopu lulia sa sa vinariva egoi koa Rau.” ");
INSERT INTO rug_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Meke zama sa Tamasa koe Ebarahami: “Sa mua barikaleqe si lopu kaqu poza nia Serai goi; podalae kamahire sa pozana sa si e Sera d tu. ");
INSERT INTO rug_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Kaqu mana nia Rau si asa, meke kaqu ponigo Rau si keke tumu koreo koasa. Kaqu mana nia Rau meke kaqu ta evaṉae na tinadia ri na butubutu si asa, meke sari na baṉara si kaqu gore mae gua koasa tutina sa.” ");
INSERT INTO rug_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Meke hoqa oporapaha pa pepeso se Ebarahami, ba podalae hegere si asa sipu balabala ia sa sapu lopu kaqu boka vagi koburu sa tie sipu ele keke gogoto vuahenina. Se Sera ba gua tugo sapu ele sia ṉavulu vuahenina, gua. ");
INSERT INTO rug_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Meke nanasia Ebarahami sa Tamasa, “Be mate si rau, kote boka va egoa Goi se Isimeli pude tagoi sari doduru gua pu ele poni nau Goi?” ");
INSERT INTO rug_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ba zama sa Tamasa, “Lokari, sa mua barikaleqe sapu se Sera, si kote podoa si keke tumu koreo, meke kaqu poza nia goi e Aisake. Kaqu kopu nia Rau sa qua vinariva egoi koasa, meke koarini pu tututi gore mae gua koasa ninae rane. Kaqu na vinariva egoi koa holana si asa ninae rane ka rane. ");
INSERT INTO rug_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ele avosi Rau sari na mua tinepa koasa guguana e Isimeli. Ke kaqu mana nia Rau si asa, meke kaqu ponia soku koburu meke soku tutina Rau si asa, kaqu na tamadia ri ka manege rua baṉara si asa, meke kaqu vata evaṉae nia na butubutu lavata Rau sari na tutina. ");
INSERT INTO rug_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ba kaqu kopu nia Rau sa qua vinariva egoi koe Aisake sapu sa tumu koreo, pu kaqu podoa Sera pa vuaheni maehe pa totoso kekeṉoṉo kamahire.” ");
INSERT INTO rug_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Sipu beto zama koe Ebarahami sa Tamasa, si taluarae si Asa koa sa. ");
INSERT INTO rug_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Meke koasa rane tugo sana si va tabea Ebarahami sa Tamasa, meke magua sa sa tuna koreo sapu se Isimeli meke sari doduru koreo pule koasa nana puku tatamana, meke sari nana pinausu saripu ta podo pa nana vetu, meke sarini pu ele ta holudi. ");
INSERT INTO rug_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ba se Ebarahami si ka sia ṉavulu sia vuahenina meke tiqe ta magu si asa, ");
INSERT INTO rug_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","meke se Isimeli sa tuna koreo, si ka manege ṉeta vuahenina. ");
INSERT INTO rug_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Pa keke rane mo si ta magu beto si arini, ");
INSERT INTO rug_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","meke gua tugo sari doduru pinausu te Ebarahami. ");
INSERT INTO rug_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Meke vura mae koe Ebarahami se Zihova, koari na hudahuda hopedi te Mamere, sipu habotu magogoso si asa pa sasadana sa nana ipi kapu kurukuru totoso maṉini hola sa rimata pana korapa rane. ");
INSERT INTO rug_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Meke sipu doṉo sage si asa, si dogori sa sari ka ṉeta tie korapa turudia vasina. Sipu dogori tugo sa si arini si haqala vura la tutuvi sa si arini, meke todoṉo gore pa pepeso si asa, ");
INSERT INTO rug_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","meke zama, “Kasa palabatu, noso paki; lopu ene hola nia sa qua ipi. Arau si koa qua hie pude va toga gamu. ");
INSERT INTO rug_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Maqu paleke poni gamu kolo pude ṉuzapa va via i sari na nenemia; boka habotu magogoso pa kauruna sa huda hie si gamu. ");
INSERT INTO rug_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Kaqu paleke mae vasi ginani tugo si rau pude va ṉiṉira gamu, meke hoda la ia sa mia inene. Ele mae dogoria gamu sa mia nabulu pa nana vetu, ke maqu va toga gamu.” Meke olaṉa si arini, “Leana hola. Mu tavetia sapu gua hiva nia goi,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Meke tuturei nuquru la pa korapa ipi se Ebarahami, meke zama koe Sera, “Mu tuturei vagia sa palava sapu ta muzara va leanana, mamu kinai kaiqa bereti.” ");
INSERT INTO rug_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Beto asa, si haqala la koasa rovana bulumakao si asa, meke vizatia sa si keke bulumakao vaqurana meke nobonobokona, meke vala nia sa si asa koa keke nabulu, pude tuturei va kina ia gua. ");
INSERT INTO rug_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Beto sapu gua asa si paleke lani sa si kaiqa bata, na meleke meke na miti bulumakao sapu ele tava namanamadi, meke vekoi sa sari na ginani pa kenudia rina tie. Meke poni sa si arini pa kauruna sa huda, meke henahena si arini. ");
INSERT INTO rug_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Meke nanasia rini si asa, “Avei se Sera, sa mua barikaleqe?” Meke olaṉa si asa, “Korapa koa nana pa korapa ipi,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Meke zama la koasa se Zihova, “Koasa totoso guahe pa vuaheni maehe, si kote pule mae si Rau, meke sa mua barikaleqe sapu se Sera si kaqu podoa sa si keke tuna koreo.” Ba se Sera si korapa turu nana pa kapa sasada pa mudina sa, meke avavoso nana. ");
INSERT INTO rug_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ba sari Ebarahami meke Sera si ele barogoso na kaleqe sisigiti, meke se Sera, si ele hola nia nana totoso pude vagi koburu. ");
INSERT INTO rug_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Ke hegere golomo pa korapa bulona se Sera, meke zama, “Kamahire, si ele kaleqe si rau, meke ele viziri sa tiniqu; meke lopu kaqu boka va gilagilaia rau sa qinetu pa tiniqu, meke sa qua palabatu ba ele barogoso tugo,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Meke nanasia e Zihova se Ebarahami, “Na vegua ke hegere se Sera meke zama, sapu lopu kaqu boka podo koburu si asa, sina ele kaleqe sisigiti gua. ");
INSERT INTO rug_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Vegua koadia kaiqa toṉa sapu tasuna sisigiti koe Zihova? Gua sapu zama nia Rau, pa totoso guahe pa vuaheni maehe, si kote pule mae si Rau, meke kote podoa e Sera si keke tuna koreo.” ");
INSERT INTO rug_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Ba matagutu se Sera, ke oso nia sa sapu lopu hegere si asa, gua. Ba olaṉa sa tie, “Hinokara, ele hegere si goi,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Beto asa si taluarae sari na tie meke ene la koa keke vasina sapu boka doṉo gore la pa Sodomu, meke ene luli turaṉi Ebarahami si arini pude la luari pa dia siraṉa, gua. ");
INSERT INTO rug_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Meke zama se Zihova, “Maqu lopu tomea koe Ebarahami sapu gua korapa hiva tavetia Rau. ");
INSERT INTO rug_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Meke sarini pu tututi gore mae gua koa sa, si kaqu ta evaṉae keke butubutu lavata meke ṉiṉira hola, meke koasa guguana sa si kaqu manani Rau sari doduru butubutu. ");
INSERT INTO rug_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Ele vizatia Rau si asa, pude zamai sari na tuna koreo, meke sarini pu tuti gore luli mae gua koa sa pude va tabeau meke tavetia sapu gua leana meke toṉoto. Be tavetia rini sapu gua asa, si kaqu tavete vala i Rau, sari doduru gua pu ele va tatarani Rau koa sa.” ");
INSERT INTO rug_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Meke zama la koe Ebarahami se Zihova, “Sa tinazutudi ri na tinoni pa Sodomu meke Qomora si nomana hola; kaleana sisigiti sari na dia sinea. ");
INSERT INTO rug_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Kaqu gore la hata vurani Rau sari guguadi ri na tinazutu saripu ele avosi Rau, be hinokara babe lokari,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Meke taluarae sari karua tie, meke la gua pa Sodomu ba koa koe Ebarahami se Zihova. ");
INSERT INTO rug_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Meke ene tata la se Ebarahami meke nanasia sa se Zihova, “Vegua, kaqu va mate hinokara turaṉae ni Goi koari na tie seadi sari na tie toṉotodi? ");
INSERT INTO rug_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Be ari ka lima ṉavulu puta tie toṉotodi, si koa dia pa korapana sa vasileana lavata, vegua kote va mate betoi Goi sari doduru tie koasa vasileana lavata sana? Vegua, lopu kaqu veko hola ia Goi sa popoa asa, pude harupi sari ka lima ṉavulu tie toṉotodi? ");
INSERT INTO rug_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Hinokara, sapu lopu kaqu va mate turaṉae ni Goi koari pu seadi sari na tie toṉoto. Tasuna hola sapu gua asa! Pude evaṉia Goi sapu gua asa, si kote tava kilasa turaṉae koari na tie sea sari na tie toṉoto. Tasuna hola sapu gua asa. Agoi sa tie varipitui pa doduruna sa popoa pepeso si kaqu varipitui va toṉoto.” ");
INSERT INTO rug_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Ke olaṉa se Zihova, “Be dogori Rau koasa vasileana lavata pa Sodomu sari ka lima ṉavulu puta tie toṉotodi, si kaqu harupia Rau sa doduruna sa vasileana lavata koasa laedi rini,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Meke zama pule se Ebarahami, “Mu tataru nau, mamu taleoso nia sa qua vinarane sapu lopu makudo zama atu si rau koa Agoi Zihova. Na tie mo si rau meke lopu padaqu pude zama nia keke toṉa. ");
INSERT INTO rug_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ba vegua, be ari ka made ṉavulu lima tie toṉotodi si koa, lopu ari ka lima ṉavulu, kaqu huara pani betoa Goi sa doduruna sa vasileana lavata sina ari ka visavisa mo sari na tie seadi?” Meke olaṉa se Zihova, “Lokari, lopu kaqu huara pania Rau sa vasileana lavata, be dogori Rau sari ka made ṉavulu lima tie toṉotodi,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Meke zama pule se Ebarahami, “Vegua, be ari ka made ṉavulu puta tie toṉotodi si koadia vasina?” Meke olaṉa si Asa, “Be koadia vasina sari ka made ṉavulu puta tie toṉotodi si lopu kaqu huaria Rau si asa.” ");
INSERT INTO rug_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Meke zama pule se Ebarahami, “Ke Baṉara Zihova, Mu lopu bugoro nau, ba maqu zama pule atu. Vegua be ari ka toloṉavulu puta si koa?” Meke zama si Asa, “Lopu kaqu huaria Rau si asa be ari ka toloṉavulu puta si dogori Rau vasina.” ");
INSERT INTO rug_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Meke zama pule se Ebarahami, “Kei Baṉara, Mu taleosoni sari na qua hinemohemo lopu ari makudodi, saripu zama atu ni rau koa Goi. Vegua be ari ka hiokona puta tie mo si ta dogoro vasina?” Meke zama si Asa, “Be ari ka hiokona puta tie mo si dogori Rau vasina ba lopu kaqu huaria Rau sa vasileana lavata,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Meke zama pule se Ebarahami, “Mu lopu bugoro nau Zihova, maqu zama pule atu keke totoso. Vegua be ari ka manege puta mo si ta dogoro?” Meke zama si Asa, “Lopu kaqu huaria Rau si asa, be ari ka manege puta si koadia.” ");
INSERT INTO rug_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Meke sipu beto zama koe Ebarahami si Asa, si taluarae se Zihova, meke pule la pa nana ipi se Ebarahami. ");
INSERT INTO rug_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Sipu mae kamo pana veluvelu pa popoa Sodomu sari karua mateana, si korapa habotu nana pa nuqunuquruana koasa bara pa vasileana lavata se Loti. Meke sipu dogori tugo sa sari karua si gasa turu meke la tutuvi sa si arini, meke todoṉo gore pa kenudia rini. ");
INSERT INTO rug_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Meke zama la koarini, “Kasa qua baṉara, hiera si rau pude tokani gamu. Mae koa paki pa qua vetu koasa boṉi hie. Mamu ṉuzapi sari na nenemia; mamu tiqe topue vaqavaqasa na ene lulia sa mia siraṉa.” Meke olaṉa la ia rini si asa, “Lokari, mami va hola ia mo sa boṉi hie koasa pavasa pa kokorapana sa vasileana,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ba ososoni sa si arini, meke mumudi si lulia rini si asa la pa nana vetu. Meke tozini Loti sari nana nabulu pude kinai kaiqa bereti loke isitidi, meke va namanama ia si keke hinenahena tadi kasa tie enenedi. Sipu beto sari na dia vinatana si henahena si arini. ");
INSERT INTO rug_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ba sipu lopu ele puta sarini pa dia teqe si mae vari likohae nia ri doduru tie Sodomu koasa vasileana lavata sana sa dia vetu, tie vaquradi na koadi na gua. ");
INSERT INTO rug_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Meke tiokia rini se Loti meke nanasia, “Avei sari na tie pu mae veluvelu koa goi? Mu turaṉa va vura maeni, pude boka va sea i gami.” ");
INSERT INTO rug_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Meke vura la koarini pa sada se Loti, meke tuku gunia sa pa mudina sa sasada. ");
INSERT INTO rug_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Meke zama la koa rini si asa, “Kasa qua baere, tepa gamu rau pude mi lopu taveti sari na tinavete kalekaleadi gua sara! ");
INSERT INTO rug_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Dotu, koadia hire si karua tuqu vineki, saripu lopu ele eko turaṉae pa keke tie. Maqu turaṉa vura atuni koa gamu; mamu tavetia gua sapu hiva taveteni gamu. Ba mu lopu tavete la nia si keketoṉa koari na tie hire, sina na tie maedi pa qua vetu si arini, ke korapa kopuni rau si arini.” ");
INSERT INTO rug_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ba zama la koe Loti si arini, “Balau! Na tie karovomu mo si goi, ba omu hiva koa tie varipitui koa gami! Taloa! Namu kote ṉovala va kaleanigo gami, holani sapu arini sara.” Meke tupele pule nia rini se Loti meke rizu tata la pude huaria gana sa tukutuku, gua. ");
INSERT INTO rug_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ba qaqama lani ri karua tie pu koadi pa korapa vetu sari limadi meke daku nuquru nia pa korapa vetu se Loti meke tukua sa sasada. ");
INSERT INTO rug_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Meke va behui ri karua sari na tie pu turu pa sebesebe vetu, sari na tie vaqura na tie koadi, ke lopu boka dogoria rini sa sasada. ");
INSERT INTO rug_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Meke zama la koe Loti sari karua palabatu, “Be koadia kaiqa tie koa goi tani, tumu koreo babe vineki mua roroto babe kaiqa turaṉamu pu koadi pa korapa vasileana lavata hie, mamu turaṉa vurani koasa popoa hie. ");
INSERT INTO rug_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Ura korapa va namanama huaria mo gami sa vasileana hie, sina sa tinazutudi rina tinoni pa popoa hie si kaleana sisigiti, meke ele avosia tu e Zihova ke garunu gami Sa pude huaria sa popoa Sodomu.” ");
INSERT INTO rug_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Ke la zamai Loti sari nana roroto saripu kote habai sari na tuna vineki, “Tuturei! Mada luaria sa vasina hie sina kote huaria e Zihova si asa.” Ba hokara na va sisire nana mo, balabala gua sari na roroto. ");
INSERT INTO rug_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Pana vaqavaqasa hokara si va bebeno ia rina mateana se Loti, meke zama si arini, “Tuturei! Tekulu, mamu turaṉia sa mua barikaleqe meke sari karua tumu vineki, mamu rizu taloa tani, pude lopu kaqu mate pana ta huara sa vasileana lavata hie.” ");
INSERT INTO rug_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ba ruriti se Loti, ke taṉinia rini limana meke sa nana barikaleqe meke sari karua tuna vineki, meke turaṉa vurani rini si arini koasa vasileana lavata sina tataruni e Zihova si arini. ");
INSERT INTO rug_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Meke sipu ele turaṉa vurani rini sarini si zama la koarini si keke rina mateana, “Mi govete taloa! Mi lopu liṉana pule, mi lopu noso pa pezara. Mi govete sage la koari na toqere, pude mi lopu mate!” ");
INSERT INTO rug_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Meke zamai Loti sari na mateana, “Kei, lokari, kasa qua baṉara. ");
INSERT INTO rug_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Dotu ele ta qetue si rau koa gamu, meke ele harupia mo gamu sa qua tinoa. Ba namu lopu boka govete la pa seu si rau koari na toqere, na kote hoqa mate nau mo sipu lopu ele kamoi rau si arini. ");
INSERT INTO rug_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Dogoria goi sa vasileana hitekena hoi? Lopu seu si asa. Va malumau pude govete la meke kote boka ta harupu si rau vasina.” ");
INSERT INTO rug_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Meke olaṉa si asa, “Leana, va egoa rau sa mua tinepa hie, sapu lopu kaqu huaria rau sa vasileana sapu zama nia goi. ");
INSERT INTO rug_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Ego, tuturei! Haqala! Lopu kaqu tavetia rau si keke toṉa osolae kamoa goi sa vasina asa.” Na hitekena poza nia Loti sa vasileana, gua asa si ta pozae Zoara si asa. ");
INSERT INTO rug_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Ele gasa sa rimata, meke tiqe kamo pa Zoara se Loti. ");
INSERT INTO rug_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Meke hinoqa va ruku nia patu lera mae guadi pa maṉauru e Zihova sari na vasileana nomadi pa Sodomu meke Qomora, ");
INSERT INTO rug_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","meke huara inete betoi Sa si arini, meke doduru pezara, na tie pu koadi vasina, meke sari doduru likakalae pu toqolo pa pepeso. ");
INSERT INTO rug_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ba liṉana pule sa barikaleqe te Loti, ke ta evaṉae keke patu soloti si asa. ");
INSERT INTO rug_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Meke pana munumunu hokara si tuturei la se Ebarahami koasa vasina pu turu si asa pa kenuna e Zihova visoroihe. ");
INSERT INTO rug_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Meke doṉo gore la pa Sodomu, meke pa Qomora meke koasa doduruna sa pezara se Ebarahami meke dogoria sa sapu tuṉaha beto sa popoa, gua tugo na tuṉaha pa vasina sulusuluana. ");
INSERT INTO rug_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ba sipu huari Tamasa sari na vasivasileana lavata koasa pezara vasina pu koa se Loti, si balabala ia Tamasa se Ebarahami ke va govetia Sa se Loti pude di ta harupu. ");
INSERT INTO rug_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Taluarae pa Zoara se Loti meke sari karua tuna vineki, meke sage la koari na toqere. Ura na matagutu koa ia rini si pa Zoara, ke la koa ia rini si keke bae vasina. ");
INSERT INTO rug_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Meke zama la ia sa vineki kenuna sapu mudina, “Ele barogoso luli sa tamada meke loke koreona sa doduru popoa hie, pude habai gita pudeda ari tuda. ");
INSERT INTO rug_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Aria mada va napo nia vaeni sa tamada; mada eke turaṉia gita kara pude boka vagi tuda koa sa tamada pude hodaia sa nana butubutu.” ");
INSERT INTO rug_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Ke pa boṉi asa si va napo nia vaeni ri karua sa tamadia, meke nuquru la koasa sapu kenuna, meke eko turaṉia sa sa tamana. Ba sina napo va hola sa tamadia, ke lopu va nonoga ia sa sapu gua ta evaṉa koasa. ");
INSERT INTO rug_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Meke pa koivugona si zama la sa tuna kenuna koasa tasina mudina, “Ele eko turaṉia rau sa tamada. Aria, mada va napo pule nia vaeni kohite boṉi meke agoi pule, mamu la eko turaṉia si asa pude boka ari tuda si gita kara koasa tamada pude hoda ia sa nana butubutu.” ");
INSERT INTO rug_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Ke koasa boṉi asa, si va napo pule nia vaeni tugo ri karua, meke la eko turaṉia sa tuna mudina si asa. Ba lopu va nonoga ia sa sapu gua ta evaṉa koa sa. ");
INSERT INTO rug_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Pa ginugua asa si va aritiadi betoi sa sari karua vineki. ");
INSERT INTO rug_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Meke podoa sa tuna vineki kenuna sa tuna koreo, meke poza nia Moabi sa si asa. Asa sa tamadia rina tie Moabi kamoa rane ṉinoroi. ");
INSERT INTO rug_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Meke gua tugo sa tuna vineki mudina si podoa sa si keke tuna koreo, meke poza nia Benami sa si asa. Asa sa tamadia rina tie Amoni, kamoa rane ṉinoroi. ");
INSERT INTO rug_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Meke taluarae pa Mamere karovo la gua pa kali popoa Kenani se Ebarahami, meke la koa pa popoa Neqevi pa vari korapana Kadesi meke Sura si asa. Meke mumudi sipu korapa koa si asa pa Qera, ");
INSERT INTO rug_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","si zama nia sa sapu se Sera sa nana barikaleqe si na tasina vineki gua; ke garuni sa baṉara sapu se Abimeleki, pa popoa Qera sari nana tie, meke la turaṉa vala nia koa sa se Sera. ");
INSERT INTO rug_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Meke keke boṉi si vura koa sa pa pinutagita sa Tamasa, meke zama, “Tio, kote mate si goi, sina ele vagia goi sa barikaleqe sana, sapu ele varihabana,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Ba lopu ele koa turaṉia Abimeleki si asa, ke zama si asa, “Ke Baṉara, loke qua sinea si rau! Ba vegua, kote va mate au mo Goi si rau meke sari na qua tinoni? ");
INSERT INTO rug_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ura Ebarahami tu telena si zama nia sapu na tasina si asa, gua; ke zama luli nia mo sa barikaleqe si asa. Lopu tavete va sea si rau; na via si rau,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Meke olaṉa pa korapa pinutagita sa Tamasa, “Uve, gilania Rau sapu lopu gilania goi sapu gua hiva tavetia goi koasa si sea, ke lopu va malumigo Rau pude tavete va sea mae koa Rau, meke lopu tiqua goi tinina si asa. ");
INSERT INTO rug_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ba kamahire, mamu va pule la ia koasa loana sa barikaleqe. Na keke poropita si asa, meke kote varavara nigo sa, pude lopu kaqu mate si goi. Ba be lopu va pulea goi koasa si asa, si maqu va balau igo, sapu kaqu mate si goi, agoi meke sari na mua tinoni,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Meke pa koivugona pana munumunu hokara, si tioki Abimeleki sari doduru nana palabatu meke tozini sa sapu gua ele ta evaṉa, meke matagutu sisigiti si arini. ");
INSERT INTO rug_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Meke tiokia Abimeleki se Ebarahami meke nanasia sa, “Na sa si ele evaṉia goi koa gami? Na sinea sa si ele tavete atu nia rau koa goi, meke evaṉia goi sa tinasuna hie koa rau, meke koasa qua butubutu. Lopu toṉoto sapu gua tavete nau goi hie. ");
INSERT INTO rug_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Na vegua ke tavetia goi si asa?” ");
INSERT INTO rug_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Meke olaṉa se Ebarahami, “Balabala ia rau sapu gina loke tie tani si hite pamaṉa nia sa Tamasa, meke kote va mate au, meke vagia sa qua barikaleqe,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","“Ba hinokara tugo, sapu na vavenequ tugo si asa, sina na tuna vineki sa tamaqu, lopu sa tinaqu; meke haba ia rau si asa,” gua se Ebarahami. ");
INSERT INTO rug_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Ke sipu garunu taloa nau e Tamasa koasa popoa tanisa tamaqu, meke la koari na votiki popoa, si zama ia rau si asa, “Kaqu vata dogoro nia goi sa mua tataru koa rau, meke tozini sari doduru tie, sapu arau si na tasimu koreo,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Meke va pule la ia Abimeleki koe Ebarahami se Sera, meke koasa totoso tugo asa, si ponia sipi na bulumakao meke na pinausu tie sa si asa. ");
INSERT INTO rug_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Meke zama la koe Ebarahami si asa, “Hie sa doduruna sa qua pepeso; la mamu koa koasa vasina sapu hiva nia goi.” ");
INSERT INTO rug_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Meke zama la koe Sera si asa, “Ponia rau koasa tasimu si keke tina poata siliva, pude va sosodea koari doduru pu koa koa goi, sapu lopu sea si goi.” ");
INSERT INTO rug_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Koa gua sapu ele ta evaṉa koe Sera, sapu sa barikaleqe te Ebarahami, si lopu va bokai e Zihova, pude vagi koburu sari na barikaleqe pa vetu tanisa baṉara Abimeleki. Ke varavara nia Ebarahami se Abimeleki, meke salaṉia Tamasa si asa. Meke salaṉia tugo sa sa nana barikaleqe, meke sari nana barikaleqe pinausu, pude boka vagi koburu si arini, gua. ");
INSERT INTO rug_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Meke mana nia e Zihova se Sera, gua tugo sapu ele va tatara vekoa Sa koasa. ");
INSERT INTO rug_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Aritiana si asa, meke podoa sa si keke tuna koreo koe Ebarahami, sipu barogoso si asa. Ta podo sa koreo koa sa totoso sapu ele mutia Tamasa pude podoa sa. ");
INSERT INTO rug_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Meke poza nia Aisake e Ebarahami si asa, ");
INSERT INTO rug_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","meke sipu ka vesu ranena podo gua sa, si magua Ebarahami si asa, gua puta tugo sapu garunu nia Tamasa koa sa. ");
INSERT INTO rug_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ebarahami si keke gogoto vuahenina, sipu podo se Aisake. ");
INSERT INTO rug_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Meke zama se Sera, “Ele va hegere au Tamasa si rau, ke sari doduru tie pu avoso nia sapu gua asa si kaqu somana hegere turaṉau,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Meke zama pule si asa, “Loke tie hokara si ele boka tozi nia se Ebarahami sapu kaqu va susu koburu se Sera. Ba podoa mo rau sa tuna sipu barogoso si asa,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Meke noma sage sa koburu, meke koasa rane sipu luara susu si asa, si tavetia Ebarahami si keke inevaṉa nomana. ");
INSERT INTO rug_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ba pa totoso asa si dogoria e Sera sapu e Isimeli, sa tuna e Hega sa barikaleqe Izipi sapu va podo nia e Ebarahami, si va sisire nia na hegere nia sa se Aisake. ");
INSERT INTO rug_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Ke zama la koe Ebarahami si asa, “Mu hitu pania sa barikaleqe pinausu hie meke sa tuna koreo. Ura sa tuna koreo sa barikaleqe hie si lopu kaqu tagoa si keke vasi mua tinagotago, sapu kaqu tagoa e Aisake sa tuqu koreo.” ");
INSERT INTO rug_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Meke lopu qetu nia Ebarahami sa ginugua hie, sina na tuna koreo tugo sa se Isimeli. ");
INSERT INTO rug_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ba zama la koe Ebarahami sa Tamasa, “Mu lopu talotaṉa nia sa koreo, meke se Hega sa mua barikaleqe pinausu. Ba mamu tavetia mo sapu gua tozi nigo e Sera; ura koe Aisake si kaqu gore mae gua sari na tutimu, sapu ele va tatara nia Rau. ");
INSERT INTO rug_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Kaqu poni va soku nia koburu Rau, sa tuna koreo sa mua barikaleqe pinausu sana, meke kaqu ta evaṉae keke butubutu lavata. Ura na tumu koreo tugo si asa.” ");
INSERT INTO rug_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ego, pana munumunu hokara pa koivugona, si vala i Ebarahami koe Hega si kaiqa ginani meke keke bogu kapu qoti, sapu siṉia na kolo, meke va papani sa pa mudina meke garunu taloa nia. Meke taluarae si asa, meke ene vilovilorae pa korapa qega Biasiba. ");
INSERT INTO rug_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Meke sipu paho sa kolo, si veko pania sa sa koburu pa kauruna keke huda hitekena, ");
INSERT INTO rug_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","meke la habotu nana padana keke gogoto mita seuna. Meke zama pa korapa bulona, “Ke, lopu hiva dogoria rau matena sa qua koburu.” Sipu korapa habotu si asa vasina, si podalae kabo si asa. ");
INSERT INTO rug_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Meke avosia Tamasa korapa kabo sa koburu, meke zama gore mae pa maṉauru sa mateana te Tamasa koe Hega, “Na sa si talotaṉa nia goi ta Hega? Mu lopu matagutu; ele avosia Tamasa sa kabona sa koreo. ");
INSERT INTO rug_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Turu, mamu la va manotia, mamu va mokomokoa; sa tuti sapu kaqu gore mae gua koasa, si kaqu va evaṉae nia keke butubutu lavata Rau si asa.” ");
INSERT INTO rug_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Va dodogorae i Tamasa sari na matana, meke dogoria sa si keke berukehe. Ke la utuvu va siṉia sa sa bogu kapu qoti, meke va napoa sa sa koreo. ");
INSERT INTO rug_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Sipu noma sage se Isimeli si koa koasa sa Tamasa. Meke ta evaṉae keke tie hukue bokabokana, sipu koa pa korapa qega pa Parani si asa. ");
INSERT INTO rug_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Meke va haba nia keke barikaleqe Izipi sa tinana si asa. ");
INSERT INTO rug_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Meke koasa totoso sana, si la sari Abimeleki meke Pikole, sa palabatu varipera tanisa nana qeto minate, meke la zama koe Ebarahami, “Sa Tamasa si koa koa goi koari doduru mua tinavete. ");
INSERT INTO rug_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Ke mamu va tatara nia pa kenuna sa Tamasa tani, sapu lopu kaqu sekesekei nau goi, meke sari na qua koburu ba be sari na tutiqu. Ele tataru nigo rau, ke mamu va tatara nia sapu agoi ba kaqu tataru nau tugo, meke sa popoa sapu korapa koa ia goi.” ");
INSERT INTO rug_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Meke zama se Ebarahami; “Kote zama tokotokoro si rau.” ");
INSERT INTO rug_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Meke zama nia Ebarahami koe Abimeleki si keke berukehe sapu ele zau vagia ri na nabulu te Abimeleki. ");
INSERT INTO rug_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Meke zama se Abimeleki, “Lopu gilania rau sapu esei ele tavetia si asa. Meke agoi ba lopu tozi nau tugo guguana, meke hie sa totoso kekenu sapu avosia rau si asa.” ");
INSERT INTO rug_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Meke vala i Ebarahami si kaiqa sipi na bulumakao, koe Abimeleki, beto asa si tavetia ri karua si keke vinariva egoi pa varikorapadia. ");
INSERT INTO rug_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Meke paqaha vagi Ebarahami koasa nana rovana, sari ka zuapa tuna sipi mamaqota, ");
INSERT INTO rug_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","meke nanasia Abimeleki si asa, “Na vegua ke tavete gua sana si goi?” ");
INSERT INTO rug_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Meke olaṉa se Ebarahami, “Mu vagi goi sari ka zuapa tuna sipi hire. Tavetia rau si hie, pude va egoa goi, sapu arau sa tie si gelia sa berukehe hie.” ");
INSERT INTO rug_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Gua asa ke, ta pozae Biasiba sa vasina asa, sina koasa vasina asa si zama tokotokoro sari karua. ");
INSERT INTO rug_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Meke sipu beto tavetia ri karua sa vinariva egoi hie pa Biasiba, si pule la dia pa Pilisitia sari Abimeleki meke se Pikole. ");
INSERT INTO rug_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Beto asa, si letea Ebarahami si keke huda tamarisiki pa popoa Biasiba, meke vahesia sa se Zihova, sa Tamasa toa holana. ");
INSERT INTO rug_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Meke koa seunae hola tu pa popoa Pilisitia se Ebarahami. ");
INSERT INTO rug_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Meke sipu ele hola saripu gua hire, si podekia Tamasa se Ebarahami; meke tiokia Sa si asa, “Ebarahami!” Meke olaṉa se Ebarahami: “Hiera si rau!” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Meke zama sa Tamasa, “Turaṉia se Aisake, sa tumu koreo titekena, sapu tataru hola nia goi; mamu ene la pa popoa Moraia. Meke koasa toqere vasina, sapu kaqu va dogoro nigo rau, si mamu va vukivukihi mae nia koa Rau si asa.” ");
INSERT INTO rug_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ke pa koivugona, pana munumunu hokara, si va namanama i Ebarahami si kaiqa huda pude tanisa vina vukivukihi, meke va hakei sa koasa doṉ'ki meke turaṉia sa se Aisake, meke sari karua nabulu, meke topue la koasa vasina sapu ele tozi nia Tamasa koasa. ");
INSERT INTO rug_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Meke pa rane vina ṉeta si doṉo la ia Ebarahami pa seu sa vasina asa. ");
INSERT INTO rug_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Meke zama la koari nana nabulu si asa, “Mi koa turaṉia tani sa doṉ'ki, arau meke sa koreo si kote la panahoi, meke la vahesi; beto asa, si kote pule mae si gami koa gamu.” ");
INSERT INTO rug_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Meke va paleke nia Ebarahami koe Aisake sa iqoso huda tana va vukivukihi va uququ; meke asa telena palekia sa magu meke sa nika. Meke sipu korapa ene keke gua la sari karua, ");
INSERT INTO rug_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","si zama se Aisake, “Tamaqu!” Meke olaṉa se Ebarahami, “Hiera si rau, tuqu.” Meke nanasa se Aisake, “Sa nika meke sari na huda si koadia, ba avei sa lami pude va vukivukihi nia?” ");
INSERT INTO rug_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Meke olaṉa se Ebarahami, “Tamasa mo telena kote ponini gita si keke lami,” meke ene keke gua la sari karua. ");
INSERT INTO rug_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Meke sipu mae kamoa ri karua sa vasina sapu ele tozia Tamasa koa sa, si tavetia Ebarahami si keke hope, meke va hake va toṉoti sa sari na huda, meke pusia sa se Aisake, sa tuna koreo, meke va hakea sa pa hope, koa rina huda. ");
INSERT INTO rug_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Meke avaṉae nia Ebarahami sa magu pude va matea si asa gua, ");
INSERT INTO rug_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","si titioko gore mae gua pa maṉauru sa mateana te Zihova koasa, “Ebarahami, Ebarahami!” Meke olaṉa si asa, “Hiera si rau,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Meke zama si asa, “Mu lopu va sigitia sa koreo, babe tavete nia keke toṉa goi si asa. Ele gilania Rau kamahire sapu pamaṉa nia goi sa Tamasa, sina lopu ruritia goi sa tumu koreo titekena koa Rau,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Meke liṉana la mae se Ebarahami, meke dogoria sa si keke sipi kokoreo sapu soqo nia kikihona pa korapa roga. Meke la vagia sa si asa, meke hobe nia sa koasa tuna koreo, pude va vukivukihi va uququ la nia koe Zihova. ");
INSERT INTO rug_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Meke poza nia “Kaqu poni gita e Zihova” Ebarahami sa vasina asa, meke pa rane tugo hie sari na tie si zama, “Kaqu va nama poni gita e Zihova koasa Nana toqere, gua.” ");
INSERT INTO rug_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Meke titioko gore mae koe Ebarahami sa mateana te Zihova pa maṉauru pa vina rua totoso, ");
INSERT INTO rug_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","zama se Zihova, “Zama tokotokoro pa pozaqu soti si Rau, sapu kaqu mana nigo Rau si goi, sina ele tavetia goi si asa, meke lopu ruritia goi sa tumu koreo titekena koa Rau. ");
INSERT INTO rug_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Va tatara nia Rau sapu kaqu mana nigo meke poni va soku nigo tutimu Arau si goi, gua rina pinopino pa galegalearane babe na onone pa masamasa kolo. Meke kaqu va kilasi rini sari na dia kana meke vagi sari dia popoa. ");
INSERT INTO rug_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Meke sari doduru butubutu si kaqu tepa Au pude manani, gua sapu ele mana nia Rau sa tutimu, sina ele va tabei goi sari doduru Qua zinama,” gua se Zihova ");
INSERT INTO rug_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Meke kekere pule la koari nana nabulu se Ebarahami, meke keke gua la pa Biasiba si arini, meke la koa vasina se Ebarahami. ");
INSERT INTO rug_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Meke sipu hola kaiqa vuaheni, si gilania Ebarahami, sapu ari ka vesu sari na koburu te Nehoa sa tasina saripu va podoni sa koe Milika. ");
INSERT INTO rug_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Se Uzi sa tuna koreo kenuna, sa tasina koreo sa se Buzi, meke se Kemueli sa tamana e Arami, ");
INSERT INTO rug_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesedi, Hazo, Pilidasi, Zidilape meke Betueli. ");
INSERT INTO rug_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betueli sina tamana e Ribeka. Ari ka vesu sari na tuna koreo saripu va podoni e Nehoa koe Milika. ");
INSERT INTO rug_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Meke va podoni Nehoa koasa nana barikaleqe pinausu, sapu se Reuma, sari Teba, Qahami, Tahasi, meke e Ma'aka. ");
INSERT INTO rug_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Ego, sa tinoa te Sera si kamoa keke gogoto hiokona zuapa vuahenina, ");
INSERT INTO rug_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","meke mate si asa pa Heboroni pa popoa Kenani, meke kabo ia Ebarahami si asa. ");
INSERT INTO rug_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Beto asa, si taluarae si asa koasa vasina pu korapa eko sa tinina sa nana barikaleqe, meke la zama si asa koasa tie Hitaiti, ");
INSERT INTO rug_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Arau si na tie karovoqu mo sapu korapa koa koa gamu tani. Mi vata holuni kaiqa mia pepeso, pude boka pomunu nia rau sa qua barikaleqe,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Meke olaṉa sari na tinoni Hitaiti, ");
INSERT INTO rug_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Mu va avoso mae koa gami, baṉara. Gami si doṉo atu nigo keke koimata ṉiṉiramu si agoi. Mu pomunu nia sa mua barikaleqe koasa popomunuana leana hola sapu tagoa gami. Kaqu qetu nia mo gami pude ponigo si keke popomunuana, pude boka pomunia goi si asa,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Meke todoṉo pa kenudia rini se Ebarahami. ");
INSERT INTO rug_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Meke zama, “Be hiva nau gamu pude pomunu nia rau sa qua barikaleqe tani, si mamu tepa poniau koe Eporoni tuna koreo e Zoha, ");
INSERT INTO rug_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","pude va holu nau sa sa bae pa Makapela, sapu koa tata pa hukihukirina sa nana inuma. Nanasia pude va maea sa koa rau sa doduruna sa hinoluna pude boka tabaria rau pa kenumia gamu tani, pude boka tagoa rau si keke vasina popomunuana,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ba se Eporoni telena, si korapa habotu somanae nana koari kaiqa tie Hitaiti koasa vasina pu hoke vivinei rini pa nuqunuquruana koasa barana sa vasileana lavata. Ke sipu korapa avosia ri doduru tie vasina, si olaṉa si asa, ");
INSERT INTO rug_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Mu avoso mae baṉara. Kaqu ponigo rau sa doduruna sa inuma, meke sa bae sapu koa vasina. Ego, pa kenudia rina qua tinoni soti, si kaqu ponigo rau si asa, pude boka pomunu nia goi sa mua barikaleqe,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ba todoṉo pule pa kenudia ri na tinoni Hitaiti se Ebarahami, ");
INSERT INTO rug_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","meke zama la koe Eporoni, pude boka avosia ri doduru tie gua. “Mu va avoso mae. Kaqu holua rau sa doduruna sa inuma. Mamu vagia sa hinoluna, pude maqu pomunu nia sa qua barikaleqe vasina,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Meke olaṉa se Eporoni, ");
INSERT INTO rug_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Qua baṉara, sa hinoluna sa pepeso si padana mo ka made gogoto poata siliva. Vegua sapu gua asa, koa gita karua? La mamu pomunu nia sa mua barikaleqe,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Va ego ia Ebarahami si asa, meke pada vala nia sa sa garona sa poata sapu poza ia e Eporoni pu avosia ri na tie, sapu ka made gogoto poata siliva, padana gua tugo sapu hoke tavetavete nia ri na tie holuholu. ");
INSERT INTO rug_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Gua asa ke tagoa e Ebarahami sa pepeso te Eporoni pa Makapela, sapu koa pa kali gasa rimata pa Mamere. Ta vagi turaṉae beto tugo sa inuma meke sa bae, meke sari doduru hudahuda pa korapana sa inuma, kamoa sa hukihukirina sa tinago sana. ");
INSERT INTO rug_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Meke sari doduru tie Hitaiti pu habotu turaṉae koe Eporoni si variva gilana nia rini sapu holua Ebarahami sa pepeso. ");
INSERT INTO rug_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Beto asa, si tiqe pomunu nia Ebarahami se Sera, sapu sa nana barikaleqe, pa korapa bae pa popoa Kenani. ");
INSERT INTO rug_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Ke sa inuma, meke sa bae, pu koa vasina, sapu tadi na tie Hitaiti tatasana, si ta evaṉae na tinago te Ebarahami, pude nana vasina popomunuana. ");
INSERT INTO rug_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Kamahire si barogoso sisigiti se Ebarahami, meke mana nia e Zihova si asa koari doduru tiṉitoṉa saripu ele taveti sa. ");
INSERT INTO rug_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Meke zama la koasa nabulu sapu ele koa va seunae hola meke kopuni sari doduru pu ele tagoi sa, “Mamu taṉini mae ia sa nenequ, pude mamu zama tokotokoro. ");
INSERT INTO rug_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Hiva nigo rau pude zama tokotokoro si goi pa pozana e Zihova, sa Tamasa maṉauru meke pepeso, sapu lopu kaqu vizatia goi, si keke barikaleqe tanisa tuqu koreo, koari na tinoni tani pa Kenani. ");
INSERT INTO rug_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ba kaqu pule la si goi koasa popoa vasina podo rau, koari na turaṉaqu soti; mamu la vagia si keke barikaleqe tanisa tuqu koreo sapu se Aisake.” ");
INSERT INTO rug_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ba nanasa sa nabulu, “Vegua be korona luliau sa vineki meke mae pa popoa hie, kaqu turaṉa la nia rau sa tumu koreo koasa popoa vasina mae gua mu?” ");
INSERT INTO rug_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Meke olaṉa se Ebarahami, “Lokari, lopu kaqu turaṉa la nia goi sa tuqu koreo vasina! ");
INSERT INTO rug_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Se Zihova, sa Tamasa pa Maṉauru si turaṉa vura nau pa popoa tanisa tamaqu, meke pa popoa tadi na turaṉaqu, meke ele va tatara zoṉazoṉa nau Sa sapu kaqu poni nia Sa sa popoa hie koa rini pu tuti gore mae gua koa rau. Kaqu garunu va kenue atu nia Sa koa goi sa mateana, pude boka vagia goi sa barikaleqe tanisa tuqu koreo vasina. ");
INSERT INTO rug_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Be korona luli koa goi sa vineki, si kaqu ta rupaha si goi koasa vina tatara hie, ba lopu kaqu turaṉa la nia goi sa tuqu koreo hie vasina.” ");
INSERT INTO rug_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Ke veko la nia sa nabulu sa limana, pa nenena sa nana baṉara, sapu se Ebarahami, meke zama tokotokoro gua tugo sapu tepa ia Ebarahami koasa. ");
INSERT INTO rug_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Meke vagi sa nabulu pu kopuni sari na tinago te Ebarahami sari ka manege puta kameli tanisa nana palabatu, meke topue la koasa vasileana lavata, vasina pu koa se Nehoa pa kali la gua, pa popoa Mesopotemia. ");
INSERT INTO rug_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Meke sipu kamo sa vasina, si va habotu gorei sa koasa berukehe pa sadana sa vasileana lavata sari na kameli, na ele veluvelu sa popoa na totoso pude vagi kolo sari na barikaleqe. ");
INSERT INTO rug_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Meke varavara guahe si asa, “Ke Zihova, Agoi sa Tamasa tanisa qua palabatu Ebarahami, Mamu va boka au pa rane ṉinoroi, Mamu tataru nia sa qua palabatu Ebarahami. ");
INSERT INTO rug_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Dotu, hiera si rau, korapa turu aqa pa berukehe, vasina sapu kote mae utuvu kolo sari na tudia vineki rina tie koasa vasileana nomana hie. ");
INSERT INTO rug_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Pana be zama gunia he rau si keke vineki, ‘Mu va gore maea sa mua zagi kolo, maqu napo gequ,’ meke be zama si asa, ‘Ego napo gemu tu ba goi; maqu va napoi tugo sari na mua kameli’, be ta evaṉa sapu gua asa, si kaqu gilania rau sapu asa toṉoto sa barikaleqe tanisa mua nabulu Aisake. Meke kaqu gilania rau sapu tataru nia goi se Ebarahami sa qua palabatu.” ");
INSERT INTO rug_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Meke sipu lopu ele va hokotia sa sa nana vinaravara si kamo mae mo se Ribeka, kokovaria nana pa avarana sa bogu kolo. Meke se Ribeka hie si na tuna vineki e Betueli, sapu se Nehoa sa tamana, meke na tasina tugo Ebarahami si asa, meke e Milika sa nana barikaleqe. ");
INSERT INTO rug_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Na vineki tolavaena meke vaqurana hola, sapu namu loke tie hokara ele hite tiqua tinina si asa. Gore la pa kolo si asa meke va siṉia sa sa nana bogu kolo, beto asa si sage pule mae si asa. ");
INSERT INTO rug_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Meke haqala la tutuvia sa nabulu si asa, meke zama, “Mu poni au vasi kolo koasa mua bogu kolo sana.” ");
INSERT INTO rug_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Meke zama se Ribeka, “Leana, palabatu, napo tu ba goi,” meke tuture va gorea sa pa avarana sa bogu kolo, meke tuqea, sipu napo si asa. ");
INSERT INTO rug_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Meke sipu beto napo sa si zama se Ribeka, “Maqu zoropo poni kolo tugo sari na mua kameli. Madi napo beto tugo sari doduru.” ");
INSERT INTO rug_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Ke tuture zoropo beto nia sa pa naponapoana tadi na kameli sa kolo koasa nana bogu, meke haqala pilipule la si asa koasa berukehe, osolae napo va deṉa betoi sa sari doduru kameli. ");
INSERT INTO rug_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ba kopu totoko nia sa nabulu si asa, pude gilania sapu va bokaia Tamasa si asa babe lokari. ");
INSERT INTO rug_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Meke sipu beto va napoi sa vineki sari na kameli, si hena ia sa tie si keke riṉi qolo, sapu noma hola hinoluna meke va sotoa sa pa isuna e Ribeka. Meke karua pizopizo qolo nomadi si va sageni sa koari na limana. ");
INSERT INTO rug_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Meke zama si asa, “Mu tozi nau sa pozana sa tamamu. Meke vegua, pada sa nana vetu pude atu puta paki keke boṉi si rau meke sari na qua tie?” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Meke olaṉa si asa, “Sa tamaqu si e Betueli pozana, na tudia koreo ri Nehoa e Milika.” ");
INSERT INTO rug_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Meke olaṉa si asa, “Koadia soku duduli popadi meke na ginani tadi na kameli; meke koa nana tugo sa vasina pude boka mae puta si gamu,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Meke kokotuṉu gore sa tie, meke vahesia sa se Zihova, ");
INSERT INTO rug_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","meke zama, “Tamanae se Zihova, sa Tamasa tanisa qua palabatu se Ebarahami, sapu lopu hite malohoro kopu nia sa Nana vina tatara koasa qua palabatu. Meke turaṉa toṉoto mae nau sa koasa turaṉana soti sa qua palabatu!” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Meke haqala la pa vetu tanisa tinana sa vineki, meke la tozia sa sa doduruna sa vivinei. ");
INSERT INTO rug_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Ego, koa nana tugo si keke tasina koreo e Ribeka, na pozana sa si e Lebani; meke haqala vura la si asa koasa berukehe vasina korapa koa sa nabulu te Ebarahami. ");
INSERT INTO rug_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Ele dogoria tu Lebani sa riṉi pa isuna meke sari na pizopizo koari na limana sa tasina vineki, meke ele avosi tu sa koasa, sapu gua zama nia sa tie. Ke ene la koasa nabulu te Ebarahami, sapu korapa turu tata koari nana kameli koasa berukehe si asa, ");
INSERT INTO rug_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","meke zama, “Mae, mada la pa vetu. Agoi si keke tie sapu ele tamanae koe Zihova. Nasa si turu nia goi tani? Ele va namaia rau si keke vasina pa qua vetu, meke gua tugo keke vasina pude tadi na mua kameli,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Ke nuquru la pa vetu sa tie, meke va goregorei e Lebani sari na pinaleke pa mudidia rina kameli, meke poni duduli popadi na ginani sa sari na kameli. Meke paleke ponia kolo sa sa nabulu te Ebarahami, meke sari nana tie pude ṉuzapa va via i sari na nenedi. ");
INSERT INTO rug_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Meke sipu ta paleke la sari na ginani, si zama sa tie, “Lopu kaqu ture henahena si rau, osolae tozi paki rau sapu gua hiva zamani rau,” gua si asa. Meke zama se Lebani, “Ego, mamu zama tu ba goi,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Meke tiqe podalae zama si asa, “Arau si na nabulu te Ebarahami. ");
INSERT INTO rug_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Ele tamanae hola koe Zihova sa qua baṉara, meke vata evaṉae nia keke tie tagotagona sa si asa. Ele poni va soku nia rovana sipi, na qoti, na bulumakao, na siliva, na qolo, na pinausu koreo na vineki, kameli na doṉ'ki Sa si asa. ");
INSERT INTO rug_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Meke sipu ele kaleqe se Sera sa nana barikaleqe si va podo nia sa si keke tuna koreo, meke vala betoni sa qua baṉara sari doduru tiṉitoṉa pu tagoi sa koasa. ");
INSERT INTO rug_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Meke va tatara nia sa qua baṉara sa nana zinama tokotokoro koa rau pude va tabea sa nana zinama. Zama si asa, ‘Lopu kaqu vizatia goi koari na vineki pa popoa Kenani si keke barikaleqe pude tanisa tuqu koreo. ");
INSERT INTO rug_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Ba kaqu la si goi koari na tinoni tanisa tamaqu, meke koa rina turaṉaqu, mamu la vizatia si keke vineki tanisa,’ gua. ");
INSERT INTO rug_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Meke nanasia rau sa qua baṉara, ‘Vegua, be korona luli koa rau sa vineki?’ ");
INSERT INTO rug_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Meke olaṉa si asa, ‘Se Zihova sapu va tabea rau doduru totoso, si kaqu garunu luli nia koa goi sa Nana mateana pude va boka igo, meke kaqu la vagia goi si keke vineki tanisa tuqu koreo koari na turaṉaqu soti, meke na butubutu tanisa tamaqu. ");
INSERT INTO rug_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ba keke siraṉa si koa nana sapu boka vata rupahigo si goi koasa mua zinama tokotokoro! Be la si goi koari na turaṉaqu, meke lopu hiva nigo rini, si ta rupaha mua mo si goi,’ gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Ba sipu kamo si rau koasa berukehe ṉinoroi, si varavara guahe si rau, ‘Ke Zihova, Tamasa tanisa qua baṉara e Ebarahami, Mu va bokau koasa tinavete sapu korapa tavetia rau. ");
INSERT INTO rug_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Do, hiera si rau koasa berukehe. Be guana mae si keke vineki vaqurana pude mae vagi kolo, meke be tepa ia rau pude poniau kolo napo koasa nana zagi, gua; ");
INSERT INTO rug_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","meke be leana, gua si asa, meke la poni kolo tugo sa sari na qua kameli, si kaqu asa tugo si ele vizatia Goi pude na barikaleqe tanisa koreo tanisa qua baṉara, gua. ");
INSERT INTO rug_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Ba sipu lopu ele va hokotia rau sa qua vinaravara, pa korapa buloqu, si mae nana mo se Ribeka meke palekia nana pa avarana si keke bogu kolo, meke ene gore koasa berukehe pude vagi kolo,’ gua. Meke zama la koasa si rau, ‘Poni au vasi kolo napo!’ gua. ");
INSERT INTO rug_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Ke hinoqa ovulu gore nia sa sa nana bogu kolo pa avarana meke zama, ‘Ego, napo tu ba goi, maqu poni kolo tugo sari na mua kameli.’ Ke napo si rau, meke poni kolo tugo sa sari na kameli. ");
INSERT INTO rug_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Meke nanasia rau si asa, ‘Esei sa pozana sa tamamu?’ Meke olaṉa si asa, ‘Sa pozana sa tamaqu si e Betueli, na tudia ri Nehoa e Milika;’ gua asa ke va soto nia riṉi rau isuna, meke va sageni pizopizo rau sari na limana, ");
INSERT INTO rug_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","meke tiqe kokotuṉu gore si rau meke vahesia se Zihova. Vahesia rau se Zihova, sa Tamasa tanisa qua baṉara Ebarahami, sapu turaṉa toṉoto lani au koasa turaṉana sa qua baṉara, meke boka dogoria rau sa tuna vineki pude tanisa tuna koreo sa qua baṉara. ");
INSERT INTO rug_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ego, be hiva va gorevura ia goi sa mua tinavete koasa qua baṉara, si mamu tozi nau kamahire; babe lokari gua goi, si mamu tozi nau tugo, pude gilania sapu na sa si kaqu boka tavetia rau.” ");
INSERT INTO rug_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Meke olaṉa sari Lebani e Betueli, “Va hinokaria gami, sapu mae guana koe Zihova sa ginugua hie, ke lopu gita kote vizatia si asa. ");
INSERT INTO rug_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Ego, hiera se Ribeka, vagia mamu turaṉa taloa nia. Mani koa na barikaleqe tanisa tuna koreo sa mua baṉara, gua sapu ele zama nia e Zihova telena,” gua sari karua. ");
INSERT INTO rug_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Meke sipu avosi sa nabulu te Ebarahami sari na dia zinama gua hire, si kokotuṉu gore si asa, meke vahesia sa se Zihova. ");
INSERT INTO rug_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Meke vagi vurani sa nabulu sari na poko na siliva meke na qolo sapu ele tava namadi meke valani sa koe Ribeka; meke ponia vinariponi noma hinoludi tugo sa sa tasina koreo meke sa tinana. ");
INSERT INTO rug_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Beto asa si tiqe henahena na napo sa nabulu te Ebarahami, meke sari na tie pu luli koasa, meke koa vasina si arini koasa boṉi asa. Meke sipu vaṉunu si arini pana munumunu, si zama si asa, “Va malumau, maqu pule la koasa qua baṉara,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Ba zama sa tasina koreo e Ribeka meke sa tinana, “Leana pude koa paki koa gami se Ribeka pa keke vuiki, babe ka manege puta rane meke tiqe taloa si asa,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ba zama la koarini sa nabulu, “Mu lopu va koa seunae gami, ura ele va bokaia mo e Zihova sa qua inene. Maqu pule la qua mo koasa qua baṉara,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ba olaṉa si arini, “Mada tiokia sa vineki, mada gilania sapu nasa si kote zama nia sa.” ");
INSERT INTO rug_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ke tiokia rini se Ribeka meke nanasia, “Vegua, hiva luli si goi koasa tie hie?” Meke olaṉa si asa, “Uve.” ");
INSERT INTO rug_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Ke va malumia rini se Ribeka, meke sa nana nabulu pude luli koasa nabulu te Ebarahami, meke sari nana tie. ");
INSERT INTO rug_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Meke hire sari na zinama saripu zamani rini sipu ponia minana rini se Ribeka, “Agoi na vavene mami, kaqu na tinadia ri soku vurotina tie si goi! Meke kaqu raovo vagi rina tutimu sari na vasileana lavata tadi na dia kana!” gua. ");
INSERT INTO rug_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Meke tiqe va namanama sari Ribeka meke sari nana vineki vaqura, meke hake koari na kameli, pude lulia sa nabulu te Ebarahami, meke podalae ene taloa si arini. ");
INSERT INTO rug_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Meke ele mae se Aisake pa korapa qega koasa berukehe sapu ta pozae “Na berukehe tanisa Tamasa Toana sapu dogorau”, gua, meke la koa pa qega popana ta pozae Neqevi pa Kenani si asa. ");
INSERT INTO rug_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Meke sipu enene dodogoro nana gua si asa pa popoa qega pana veluvelu opokaputu, si dogori sa sari na kameli sapu korapa ene mae. ");
INSERT INTO rug_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Meke sipu dogoria Ribeka se Aisake, si gore koasa nana kameli si asa. ");
INSERT INTO rug_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Meke nanasa la ia sa sa nabulu te Ebarahami, “Esei sa tie sapu korapa ene toṉoto mae hoi koa gita?” “Asa sa qua baṉara,” olaṉa gua sa nabulu. Ke vagia sa si keke nana poko nobi, meke nobia sa sa isumatana. ");
INSERT INTO rug_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Meke vivineini sa nabulu koe Aisake sari doduru gua pu ele taveti sa. ");
INSERT INTO rug_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Meke turaṉa la nia Aisake se Ribeka pa ipi te Sera, meke ta evaṉae na nana barikaleqe si asa. Meke tataru nia Aisake se Ribeka, meke tava manoto si asa pa mudina sa minate tanisa tinana. ");
INSERT INTO rug_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Meke keke pule barikaleqe pozana si e Ketura si haba ia e Ebarahami. ");
INSERT INTO rug_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Meke va podoni sa koe Ketura sari Zimirani, Zokisani, Midiani, Isibaki meke Sua. ");
INSERT INTO rug_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Meke se Zokisani hie sina tamadia ri Siba meke e Dedani. Meke sari na tutina e Dedani si ari Asura, Letusi, meke se Liumi. ");
INSERT INTO rug_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Meke hire sari na tuna koreo e Midiani: ari Epaha, e Epera, e Hanoki, e Abida, meke e Eleda. Arini sari doduru tutina e Ketura. ");
INSERT INTO rug_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Meke vala betoi Ebarahami koe Aisake sari doduru nana likakalae saripu tagoi sa. ");
INSERT INTO rug_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Ba sipu korapa toa nana sa si poni vinariponi sa sari na tuna koreo saripu va podoni sa koari kaiqa nana barikaleqe. Beto asa si garunu taloani sa sari na tuna koreo hire pa popoa kali gasa rimata, pude koa va seu koe Aisake, gua. ");
INSERT INTO rug_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Barogoso sisigiti se Ebarahami meke mate, sipu keke gogoto zuapa ṉavulu lima vuahenina si asa. ");
INSERT INTO rug_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Meke pomunu nia ri karua koreo si asa, ari Aisake meke e Isimeli, pa korapa bae pa Makapela tata pa Mamere; koasa pepeso sapu tagoa Eporoni tuna e Zoha tatasana. ");
INSERT INTO rug_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Asa sa pepeso sapu holua Ebarahami koari na tie pa butubutu Hitaiti. Vasina si ta pomunae beto sari Ebarahami meke e Sera sa nana barikaleqe. ");
INSERT INTO rug_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Meke pa mudina sa minate te Ebarahami, si mana nia Tamasa sa tuna koreo sapu se Aisake. Meke koa tata si asa koasa berukehe sapu ta pozae “Tanisa Tamasa Toana sapu dogorau”, gua. ");
INSERT INTO rug_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Hie sa vivineina sa tuna Ebarahami, sapu se Isimeli, sapu va podo nia Ebarahami koe Hega, sa barikaleqe Izipi, sa pinausu te Sera. ");
INSERT INTO rug_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ego, hire sari na pozadi rina tuna koreo e Isimeli, meke sari na varilulidi rina dia pinodo: e Nebaioti, e Kedara, e Adibilu, e Mibisami, ");
INSERT INTO rug_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","e Misima, e Duma, e Masa, ");
INSERT INTO rug_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","e Hadadi, e Tema, e Zetura, e Napisi, meke e Kedema. ");
INSERT INTO rug_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Arini sari na tiatamadia ri ka manege rua butubutu, meke ta pozae luli tugo koari na pozadi sari na dia vasileana, meke sari na vasidi pu koa varigarae rini. ");
INSERT INTO rug_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Meke keke gogoto toloṉavulu zuapa vuahenina se Isimeli meke tiqe mate. ");
INSERT INTO rug_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Meke koa pa kali popoa pa vari korapana Havila meke Sura sari na tutina e Isimeli, meke kamo la gua tugo pa kali gasa rimata pa popoa Izipi, sapu pa siraṉa la gua pa popoa Asiria. Koa varipaqapaqahi koari kaiqa tutina pule te Ebarahami si arini. ");
INSERT INTO rug_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Hiera sa vivineina sa tuna koreo e Ebarahami, sapu se Aisake. ");
INSERT INTO rug_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Ka made ṉavulu puta vuahenina se Aisake, sipu haba ia sa se Ribeka, sa tuna vineki e Betueli. Se Betueli hie sina tie Aramea, pa popoa Mesopotemia si asa. Se Ribeka hie si na vavenena e Lebani. ");
INSERT INTO rug_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Meke varavara la nia Aisake koe Zihova sa nana barikaleqe, sina tige si asa, meke va egoa e Zihova sa nana tinepa, ke tiqe aritiana se Ribeka. ");
INSERT INTO rug_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Meke gilania Ribeka sapu kote karua sari na tuna pa korapa tinina, ba sipu lopu ele podo sari karua, si variṉazai sari karua pa korapa kokoana koburu. Ke zama si asa, “Na vegua ke ta evaṉa tu koa rau sapu guahe?” gua si asa. Ke la nanasa nia inolaṉa sa se Zihova. ");
INSERT INTO rug_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Meke zama la se Zihova koasa, “Karua koburu si kote podoi goi pa korapa tiamu, meke kote vura mae si karua butubutu lavata, meke kaqu vari pinopinoi sari karua tie arini. Sapu keke si kote ṉiṉira hola nia si keke, meke kaqu nabulu nia sa kenuna sapu mudina.” ");
INSERT INTO rug_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Meke kamo sa totoso tanisa si podoi sa sari karua tuna koreo. ");
INSERT INTO rug_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Meke sapu kenuna si bulabula, meke pulupulu sa tinina. Ke poza nia Isoa rini si asa. ");
INSERT INTO rug_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Meke taṉini va nabua sapu vina rua sa huhubakuluna e Isoa totoso podo si asa; ke poza nia Zekopi rini si asa. Ka onomo ṉavulu puta vuahenina se Aisake, sipu podo sari karua avisi hire. ");
INSERT INTO rug_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Meke sipu noma sage sari karu koreo, si ta evaṉae na tie bokabokana pa hukue se Isoa. Hoke hiva ene va seu si asa, ba se Zekopi si na tie bule, meke hoke kokoa mo tata koari na ipi si asa. ");
INSERT INTO rug_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Hoke hukue ponia Isoa se Aisake, gua asa ke tataru nia sa si asa, ba se Ribeka si tataru nia sa se Zekopi. ");
INSERT INTO rug_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Keke rane sipu korapa raro supu bini se Zekopi, si kamo pule beto hukuena se Isoa, meke ovia si asa. ");
INSERT INTO rug_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Meke zama la koe Zekopi se Isoa, “Ke ovia hola qua. Poni nau vasi supu ororana valeana sana.” Gua asa ke ta pozae Edomu si asa. ");
INSERT INTO rug_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Meke olaṉa se Zekopi, “Leana, maqu ponigo, be poni nau goi sa mua ṉiniraṉira koasa mua pinodo koreo va kenue,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Meke zama se Isoa, “Leana hola! Na tata mate ovia qua si rau; na tiṉitoṉa leana sa si kaqu evaṉia sa qua ṉiniraṉira pa qua pinodo va kenue?” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Meke olaṉa se Zekopi, “Ego, kekenu si mamu zama tokotokoto mae koa rau, sapu kaqu poni mae nia goi koa rau sa mua ṉiniraṉira pa mua pinodo va kenue.” Ke zama tokotokoro se Isoa, meke va karovo la nia sa koe Zekopi sa nana ṉiniraṉira pa nana pinodo va kenue. ");
INSERT INTO rug_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Meke ponia bereti na supu bini e Zekopi se Isoa, meke zomuzomue na hoe va isisuru si asa, meke gasa turu, meke taloa nana. Gua asa sapu hiva nia Isoa sa ginani hola nia sa nana ṉiniraṉira koasa nana pinodo va kenue. ");
INSERT INTO rug_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ego ta evaṉa si keke soṉe koa sa popoa, gua tugo sa soṉe sapu ta evaṉa pa totoso te Ebarahami. Meke topue la pa Qera se Aisake koe Abimeleki, sa baṉara tadi na tie Pilisitia. ");
INSERT INTO rug_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Meke vura koe Aisake se Zihova meke zama, “Mu lopu gore la pa Izipi; mu koa mo koa sa vasina sapu kaqu tozi nigo Rau pude koa. ");
INSERT INTO rug_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Mu koa paki koasa popoa hie, meke kaqu somana koa koa goi si Rau, meke kaqu mana nigo Rau si goi. Ura kaqu poninigo Rau meke sari na tutimu sa doduruna sa popoa hie. Kaqu va gorevura ia Rau sa vina tatara, sapu tokoro vekoa Rau koe Ebarahami, sa tamamu. ");
INSERT INTO rug_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Kaqu va sokui Rau sari na tumu, soku gua rina pinopino pa maṉauru, meke kaqu ponini Rau koari na tutimu goi sari doduru popoa hire. Meke kaqu tepa Au ri doduru butubutu si Rau pude manani si arini, gua sapu ele manani Rau sari na tutimu goi. ");
INSERT INTO rug_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Kaqu mana nigo Rau si goi, ura ele va tabe au Ebarahami si Rau, meke kopuni sari doduru Qua tinarae na ginarunu.” ");
INSERT INTO rug_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Ke koa mo pa Qera se Aisake. ");
INSERT INTO rug_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Meke nanasa nia rina tie vasina sa nana barikaleqe, sina leleana hola si asa. Meke olaṉa se Aisake, “Na vavenequ si asa,” guni sa, sina matagutu tozia sa sapu na nana barikaleqe si asa, na hako tava mate nana koari na tie vasina, meke vagia rini se Ribeka, gua. ");
INSERT INTO rug_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Meke sipu ele koa seunae vasina se Aisake, si hopikae vura nana keke rane pa vuida gua se Abimeleki, sa baṉara, si dogoro pohoa sa se Aisake, sapu korapa hapahapa nia sa se Ribeka, sa nana barikaleqe. ");
INSERT INTO rug_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Ke tiokia Abimeleki se Aisake meke zama ia, “Ai, na mua barikaleqe mo goi si asa! Na vegua ke zama si goi, ‘Na vavenequ mo si asa,’ gua?” Meke olaṉa se Aisake, “Na balabala ia rau, sapu kote tava mate si rau, be zama si rau sapu na qua barikaleqe si asa,” gua. ");
INSERT INTO rug_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Meke zama se Abimeleki, “Nasa sapu tavetia goi koa gami? Be guana ele puta turaṉia keke tie sa mua barikaleqe si kote agoi mo ṉatina sa mami sinea,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Meke zama va balau i Abimeleki sari doduru nana tie, “Be keke tie si ṉoṉovalia sa tie hie meke sa nana barikaleqe si kaqu tava mate si asa,” gua. ");
INSERT INTO rug_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Meke lelete pa popoa sana se Aisake, meke koasa vuaheni tugo sana, si keke gogoto totoso si pakepakete si asa, hola nia sapu gua ele letei sa, ura na mana nia Tamasa si asa. ");
INSERT INTO rug_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Meke ta evaṉae tie tagotago si asa osolae kamoa sapu tagotago va hola si asa. ");
INSERT INTO rug_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Koa gua sapu soku hola sari nana rovana sipi, na bulumakao, meke soku tugo sari nana nabulu, si konokono nia rina tie Pilisitia si asa. ");
INSERT INTO rug_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Ke tamunu ni pepeso rini sari doduru berukehe, saripu geli rina nabulu tanisa tamana sapu se Ebarahami, totoso toana si asa. ");
INSERT INTO rug_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Meke zama ia Abimeleki se Aisake, “Mamu taloa pa mami popoa kamahire; ura ele ṉiṉira holani gami goi si gami.” ");
INSERT INTO rug_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Ke taluarae se Aisake, meke la koa paki pa pezara pa Qera. ");
INSERT INTO rug_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Meke geli pule sa sari na berukehe saripu ta gelidi koari na totoso te Ebarahami, saripu ele va nosoi rina tie Pilisitia pa mudina sa minate te Ebarahami. Meke poza puleni sa sari na pozadi saripu pozani sa tamana koarini. ");
INSERT INTO rug_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Meke gelia rina nabulu te Aisake si keke berukehe koasa pezara meke vagi kolo vasina sarini. ");
INSERT INTO rug_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Meke sari na tie kopu sipi tadi pa popoa Qera si varitokei koari na tie kopu sipi te Aisake. Zama si arini, “Tamigami sa kolo hie,” gua. Ke poza nia “Varitokei,” Aisake sa berukehe. ");
INSERT INTO rug_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Meke geli pulea rina nabulu te Aisake, si keke berukehe, meke varitokei pule nia pule rini si asa, ke poza nia, “Varikanai,” pule sa si asa. ");
INSERT INTO rug_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Meke rizu taloa pule si arini koasa vasina asa, meke la geli pulea pule rini si keke berukehe meke loke tie vari nominomi nia si asa; ke poza nia, “Tinarupaha,” sa si asa. Meke zama si asa, “Kamahire, si ele ta rupaha koe Zihova pude koa pa popoa hie meke kaqu koa valearanei si gita tani,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Beto asa, si taluarae si asa vasina meke sage la pa Biasiba. ");
INSERT INTO rug_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Meke koasa boṉi sana si vura koasa se Zihova meke zama, “Arau tugo sa Tamasa tanisa tamamu e Ebarahami, mu lopu koa matagutu, sina koa koa goi si Rau. Kaqu mana nigo Rau meke kaqu va sokui Rau sari na tutimu, sina koa gua koasa Qua vina tatara koe Ebarahami sa Qua nabulu,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Meke kuria e Aisake vasina si keke hope, meke vahesia sa se Zihova. Meke va turua sa sa nana ipi poko vasina, meke gelia pule ri nana nabulu si keke berukehe. ");
INSERT INTO rug_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Meke taluarae pa Qera se Abimeleki, meke somana luli koasa se Ahuzati, sa nana tie totoli, meke se Pikole sa nana palabatu varipera, pude la dogoria se Aisake, gua. ");
INSERT INTO rug_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Meke nanasa la i Aisake si arini, “Na vegua ke hiva mae dogorau gamu kamahire si rau, sina ele kukiti nau gamu tatasana, meke ele hitu pani au gamu koasa mia popoa?” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Meke olaṉa si arini, “Kamahire tu gilania gami sapu koa koa goi se Zihova; ke balabala ia gami sapu kaqu ta hivae si keke vinariva egoi pa varikorapada gita. Hiva nigo gami pude zama hinokara si goi, ");
INSERT INTO rug_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","sapu lopu kaqu kana gami goi kekeṉoṉo gua tugo sapu lopu kana atu igo gami, gua sapu toka nigo gami meke garunu taloa nigo pa binule. Meke kamahire si ta gilana va bakala sapu mana nigo e Zihova si goi.” ");
INSERT INTO rug_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Meke tavetia Aisake si keke inevaṉa meke henahena na napo si arini. ");
INSERT INTO rug_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Meke pana munumunu vaqavaqasa, si taveti rini sari na dia vina tatara nabudi meke zama tokotokoro. Beto asa, si luluari Aisake meke varipaqahi koasa dia binaere si arini. ");
INSERT INTO rug_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Meke koasa rane sana si mae koe Aisake sari nana nabulu meke tozia koasa sa guguana sa berukehe sapu ele gelia rini. Zama si arini, “Ele dogoria gami sa kolo,” gua. ");
INSERT INTO rug_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Meke poza nia, “Zama tokotokoro” sa sa berukehe asa. Meke gua asa ke ta pozae, “Biasiba” sa vasileana asa. ");
INSERT INTO rug_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Sipu ele ka kamo made ṉavulu puta vuahenina se Isoa si haba i sa si karua vineki Hitaiti, ari Zuditi, sa tuna vineki e Beri, meke e Basemati, sa tuna vineki e Eloni; ");
INSERT INTO rug_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","ke lopu koa qetu sari Aisake e Ribeka. ");
INSERT INTO rug_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Ego, sipu ele barogoso sisigiti se Aisake meke ele rida sari na matana ke lopu boka dodogorae si asa, si tiokia sa se Isoa, sa tuna koreo kenuna meke zama, “Tuqu!” Meke olaṉa se Isoa, “Hiera si rau!” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Meke zama la se Aisake, “Ele barogoso si rau, meke lopu gilania rau sa rane sapu kaqu mate si rau. ");
INSERT INTO rug_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Ego, mu vagia sa mua bokala meke sari na mua tupi, mamu la hukue pa soloso, mamu va mate poni nau keke kurukuru. ");
INSERT INTO rug_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Mamu kina poniau sa ginani hena lea, gugua sapu hiva nia rau. Mamu paleke mae nia, meke pana beto hena ia rau si asa, si kaqu ponigo rau sa qua minana, sipu lopu ele mate si rau,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ego, sipu korapa zama ia Aisake se Isoa, si avavoso nana mo se Ribeka. Ke sipu topue la hukue pa soloso se Isoa, ");
INSERT INTO rug_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","si zama la koe Zekopi se Ribeka, “Vaquru avosia mo rau sapu zama ia sa tamamu se Isoa, ");
INSERT INTO rug_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘La mamu hata poni nau keke kurukuru, mamu kina poniau. Meke pana beto hena ia rau si asa, si maqu mana nigo rau pa kenuna e Zihova, sipu lopu ele mate rau,’ gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Ego tuqu, mamu va avoso mae, mamu va tabea sapu gua kaqu garunu nigo rau. ");
INSERT INTO rug_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Mu la koasa rovana qoti, mamu la vizata maeni karua qoti vaquradi na nobonobokodi. Kaqu kinai rau gua puta tugo sapu hiva hola nia sa tamamu. ");
INSERT INTO rug_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Beto asa, mamu la ponia koasa tamamu, meke kaqu mana nigo sa, sipu lopu ele mate si asa,” gua sa tinana. ");
INSERT INTO rug_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Ba zama la koe Ribeka se Zekopi, “Tinaqu, gilania goi se Isoa si pulupulu hola sa tinina, ba arau si bulebule tiniqu. ");
INSERT INTO rug_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Meke gina kote tiqu au sa tamaqu meke gilanau, sapu na sekeseke nia mo rau si asa; meke koasa ginugua asa si kote leve pule nau meke lopu kaqu vagia rau sa minana,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Meke olaṉa sa tinana, “Mani ta gore nia rau sa linevemu goi tuqu. Mamu la tavetia mo sapu gua tozi nigo rau; mamu la vagi maeni koa rau sari na qoti,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ke la vagi Zekopi si arini, meke paleke maeni sa koasa tinana, meke kina kekeṉoṉo guni tugo Ribeka sari na ginani, gua puta tugo sapu hiva nia e Aisake. ");
INSERT INTO rug_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Meke henai Ribeka sari na poko leleadi saripu te Isoa sa tuna kenuna, saripu kopuni sa pa vetu, meke va sageni sa koasa tuna mudina sapu se Zekopi. ");
INSERT INTO rug_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Meke va oponi kapu qoti sa tinana sari na limana, meke koari vasina sapu loke kaludi pa ruana pude guana na ruana meke sari na limana e Isoa. ");
INSERT INTO rug_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Meke va palekeni sa sari na ginani lomosodi koasa, meke sari na bereti saripu kinai sa. ");
INSERT INTO rug_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Meke topue la koasa tamana se Zekopi, meke zama, “Tamaqu!” gua si asa. Meke olaṉa sa tamana, “Arau. Esei si agoi ta tuqu?” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Meke olaṉa se Zekopi, “Arau Isoa, sa tumu kenuna; ele tavetia rau sapu gua tozi nau goi. Ego, tekulu, mamu hena i sari na ginani, saripu paleke maeni rau hire koa goi, pude mu poni nau sa mua minana koa rau,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ba nanasia Aisake sa tuna, “Vegugua meke lopu sana vagi si goi ta tuqu?” Meke olaṉa se Zekopi, “Ura toka nau e Zihova sa mua Tamasa,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Meke zama la koe Zekopi se Aisake, “Ego, tata mae ko, pude maqu tiqu igo. Hinokara sapu e Isoa tugo si goi?” ");
INSERT INTO rug_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Meke rizu tata la koasa tamana si asa, meke tiqua Aisake si asa, meke zama si asa, “Sa mamalaiṉimu si gua puta mamalaṉina e Zekopi, ba sari na limamu si gua rina limana e Isoa,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ba lopu gilania Aisake sapu e Zekopi si asa, sina pulupulu gua tugo rina limana e Isoa si asa, ke hiva vala nia mo sa sa nana minana. ");
INSERT INTO rug_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Ba nanasa pulea sa si asa, “Vegua, hinokara sapu e Isoa tugo si goi?” Meke olaṉa se Zekopi, “Uve, arau tugo,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Meke zama se Aisake, “Paleke maeni sari na ginani. Pana beto henahena rau, maqu mana nigo,” gua si asa. Ke paleke lani Zekopi sari na ginani, meke gua tugo sari na vaeni pude tana napo. ");
INSERT INTO rug_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Meke zama la koasa sa tamana, “Tuqu, mu rizu tata mae mamu aho au,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Meke sipu rizu tata la si asa pude ahoa gua, si va humaṉi Aisake sari na poko te Isoa, ke mana nia sa si asa. Meke zama si asa, “Sa hinumaṉa lea tanisa tuqu, si guana humaṉana sa hiqohiqo sapu ele mana nia e Zihova. ");
INSERT INTO rug_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Mani va gore ponigo Tamasa sa puni pa maṉauru, meke va masuri sari na mua inuma, meke kaqu vura va sokusoku sari na mua huiti d na huda vaeni. ");
INSERT INTO rug_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Meke kaqu nabulu nigo rina butubutu si goi, meke sari na tinoni si kaqu kokotuṉu pa kenumu goi. Meke kaqu baṉarani goi sari doduru tasimu, meke kaqu kokotuṉu si arini pa kenumu goi. Meke sarini pu leve nigo si kaqu ta levei tugo, meke sarini pu mana nigo si kaqu tamanae tugo si arini,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Meke sipu beto tugo mana nia Aisake se Zekopi meke taluarae, si lopu sana nuquru hobe mae mo se Isoa, sa tasina, beto hukuena. ");
INSERT INTO rug_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Meke kina ginani lomosona tugo se Isoa, meke paleke la koasa tamana. Meke zama, “Tamaqu, tekulu mamu henai sari na ginani sapu paleke maeni rau, pude mamu mana nau,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Meke nanasia e Aisake si asa, “Esei si goi?” Meke olaṉa se Isoa, “Arau Isoa sa tumu kenuna,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Meke podalae matagutu sisigiti na neneqara beto tinina se Aisake, ke nanasia sa, “Esei tu sapu ele va mate kurukuru meke paleke mae koa rau? Meke tiqe beto mo hena ia rau si asa, si mae si goi. Meke ele vala nia tu rau koasa sa qua minana, gua asa ke tanisa si asa, ninae rane ke rane,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Meke sipu avosia Isoa sapu gua asa, si kabo va ululae sisigiti si asa meke zama, “Ke tamaqu, mu mana nau tugo!” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ba olaṉa se Aisake, “Ele mae sekesekei nau sa tasimu, meke ele vagi taloa nia sa sa mua minana,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Meke zama se Isoa, “Hie sa totoso vina rua sapu sekesekei nau sa si rau. Ke gotogoto tugo sapu ta pozae Zekopi si asa. Ele vagia sa sa qua hinia koari na tiṉitoṉa saripu tagoi goi saripu tanisa koreo kenuna, meke kamahire si ele vagi taloa nia pule sa sa qua minana. Vegua, loke minana sapu koa hola koa goi, pude taqarau?” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Meke olaṉa se Aisake, “Do, ele vata evaṉae nia rau na baṉara ululuna koa goi si asa, meke ele vata evaṉaeni nana pinausu rau sari doduru turaṉana, meke ele ponia huiti na vaeni rau si asa. Meke kamahire si loketoṉa si boka poninigo rau si goi na tuqu,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ba lopu hite makudo tepa ososo nia Isoa sa Tamana, “Ke tamaqu kekeke mo sa minana si tagoa goi? Tamaqu, mu mana nau tugo!” Meke podalae kabo va ululae si asa. ");
INSERT INTO rug_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Ba zama la koe Isoa se Aisake, “Kaqu koa va seu pa pepeso masuruna si goi, vasina sapu loke puni pa maṉauru kaqu kamoa. ");
INSERT INTO rug_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Kaqu toa pa mua vedara si goi, ba kaqu na pinausu tanisa tasimu si goi. Meke vugorepere sipu ṉiṉira si goi, sari na tutimu si kaqu paqaha taloa koasa nana kinopu,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Meke kukiti nia Isoa se Zekopi, si na ele vala nia sa tamana koe Zekopi sa minana, meke balabala guahe pa korapa bulona se isoa, “Tata mae sa totoso mate tanisa tamaqu meke kaqu besu nia gami si asa; meke pa totoso asa si kaqu va matea rau se Zekopi, sa tasiqu,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ba sipu gilania Ribeka sa binalabala te Isoa sa tuna kenuna, si tiokia sa se Zekopi sa tasina mudina meke zama ia sa, “Sa tasimu Isoa si korapa kuhana nigo pude va mate igo. ");
INSERT INTO rug_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Ego, tuqu, mu va tabea sa qua zinama; mamu govete la koe Lebani, sa tasiqu pa Harani. ");
INSERT INTO rug_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Mamu la koa paki vasina, osolae ibu taloa sa binugoro tanisa tasimu. ");
INSERT INTO rug_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Meke pana muliṉi nia sa, sapu gua tavete la nia goi koa sa, si kaqu garunu atuni rau si kaiqa tie pude turaṉa pule nigo. Sina lopu hiva nia rau pude mate beto sari na tuqu pa keke rane,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Meke zama la koe Aisake se Ribeka, “Ele mabo mateni rau sari na barikaleqe karovodi te Isoa. Ego be habai tugo e Zekopi sari na vineki pa popoa Hitaiti hire, si be mate qua, ba leana mo!” gua se Ribeka. ");
INSERT INTO rug_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Meke tiokia Aisake se Zekopi meke mana nia, meke tozi nia sa si asa, pude lopu kaqu haba ia sa si keke vineki pa popoa Kenani, gua. ");
INSERT INTO rug_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","“Ba mamu la pa popoa Mesopotemia, pa popoa tanisa tamana sa tamamu sapu se Betueli. Mamu la haba ia si keke vineki vasina, sa tuna sa buhimu sapu e Lebani. ");
INSERT INTO rug_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Meke sa Tamasa pu tagoi sari doduru ṉiniraṉira si kaqu mana nia sa mua vinarihaba meke poni va sokusoku nigo tumu Sa, meke kaqu ta evaṉae na tamadia ri soku butubutu si goi! ");
INSERT INTO rug_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Meke kaqu mana nigo Sa meke sari na tutimu kekeṉoṉo gua sapu mana nia Sa se Ebarahami, meke kaqu tagoa goi sa popoa hie, vasina sapu koa ia goi, sapu ele ponia Tamasa koe Ebarahami,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Gua asa, ke garunu taloa nia e Aisake se Zekopi pa popoa Mesopotemia, koe Lebani, sapu sa tuna koreo e Betueli, meke na tie Aramea si asa, meke na tasina tugo e Ribeka, sa tinadia ri Zekopi e Isoa. ");
INSERT INTO rug_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Meke gilania Isoa sapu ele mana nia Aisake se Zekopi, meke garunu la nia sa pa popoa Mesopotemia pude la vagia vasina si keke barikaleqe. Meke gilania tugo sa, sipu totosona mana nia Aisake se Zekopi si zama ia sa si asa, pude lopu haba ia si keke barikaleqe pa popoa Kenani, gua. ");
INSERT INTO rug_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Meke gilania Isoa sapu ele va tabei Zekopi sari karua tiatamana, meke la pa popoa Mesopotemia si asa. ");
INSERT INTO rug_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Ke ele gilania Isoa sapu lopu qetuni Aisake sa tamana sari nana barikaleqe pa popoa Kenani, ");
INSERT INTO rug_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","ke la si asa koe Isimeli sa tuna e Ebarahami, meke la haba ia sa sa tuna vineki e Mahalata, sa tasina vineki e Nebaioti. ");
INSERT INTO rug_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Meke taluarae pa Biasiba se Zekopi meke ene la gua pa Harani. ");
INSERT INTO rug_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Meke sipu opokaputu sa popoa si kamoa sa si keke vasina, ke noso si asa vasina. Meke vagia sa si keke patu, meke tarabatu nia sa si asa, meke puta. ");
INSERT INTO rug_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Meke putagita dogoria sa si keke halehaleana sapu podalae pa pepeso meke kamo pa maṉauru, meke sari na mateana te Tamasa si korapa ene sage gore koasa halehaleana asa. ");
INSERT INTO rug_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Meke turu kapae nana pa kalina sa vasina se Zihova, meke zama, “Arau se Zihova, sa Tamasa te Ebarahami meke Aisake. Kaqu ponigo Rau meke sari na tutimu sa vasina hie sapu korapa ekoa goi. ");
INSERT INTO rug_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Meke sari na tutimu si kaqu gua ri na kavuru pa pepeso. Meke kaqu araha la pa vari kalina sa popoa si arini. Meke koa goi meke koari na tutimu si kaqu manani Rau sari doduru butubutu. ");
INSERT INTO rug_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Mamu balabala ia sapu kaqu koa koa goi si Rau, meke kaqu kopu nigo Rau be pavei vasina la goi, meke kaqu turaṉa pulenigo tugo Rau koasa popoa hie. Meke lopu kaqu luarigo Rau, osolae kaqu va gorevura i tu Rau sari doduru gua pu va tatara nigo Rau,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Meke tiqe vaṉunu se Zekopi meke zama, “Hinokara, e Zihova si koa koa sa vasina hie, ba lopu gilania rau si asa!” ");
INSERT INTO rug_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Meke matagutu sisigiti si asa meke zama, “Ke, variva matagutu hola sa vasina hie! Gina na vetu tugo te Tamasa, meke na sasadana sa maṉauru,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Meke tuturei vaṉunu pana munumunu hokara se Zekopi, meke vagia sa sa patu sapu tarabatu nia sa, meke va turua sa guana keke vina gilagila, meke tiqe zoropo nia oela sa, pude va madia koe Tamasa, gua. ");
INSERT INTO rug_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Meke poza nia Betolo sa sa vasina asa. Sa ginuana sa pozapoza Betolo si na “Vetu te Tamasa”, ba sa pozana kekenu sa vasileana asa si Luzi. ");
INSERT INTO rug_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Meke zama tokotokoro koe Zihova se Zekopi, “Be luli somanae koa rau si Goi, meke kopu nau Goi koasa qua inene sapu tavetia rau, meke poniau ginani na poko Goi, ");
INSERT INTO rug_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","meke be va lesevau Goi pa tinasuna koasa qua pinule mae pa vetu tanisa tamaqu, si kaqu na qua Tamasa tugo si Agoi. ");
INSERT INTO rug_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Ego, sa vina gilagila patu hie sapu ele va turu sagea rau si na vasina sapu kaqu tavahesi si Agoi, meke kaqu ponigo rau sa keke pa manege koari doduru mua vinariponi koa rau,” gua se Zekopi. ");
INSERT INTO rug_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Meke topue ene pule se Zekopi meke ene toṉoto la koasa popoa tadi na turaṉana pa kali gasa rimata. ");
INSERT INTO rug_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Meke mae kamo si asa koa keke berukehe koasa vasina asa, meke dogori sa sari ka ṉeta rovana sipi korapa eko vari likohae nia rini sa berukehe; meke koasa berukehe sana si hoke tava napo sari na rovana sipi. Meke koa ia na tukutuku patu lavata si asa. ");
INSERT INTO rug_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Ba pana mae varigara beto tu sari doduru rovana sipi vasina, si hoke va rizua rina sepati sa patu lavata meke va napoi sari na sipi. Beto asa si tuku pulea rini sa berukehe. ");
INSERT INTO rug_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Meke nanasi Zekopi sari na sepati, “Kasa turaṉaqu? Pavei mae gua mia si gamu?” Meke olaṉa si arini, “Gami si mae gua mami pa Harani,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Meke nanasa si asa, “Vegua, gilania tugo gamu se Lebani, sa tuna e Nehoa?” Meke olaṉa si arini, “Uve, gilania gami si asa,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Meke nanasa pule la si asa, “Vegua, korapa koa valeana si asa?” Meke olaṉa si arini, “Uve, meke hoi mo se Reseli, sa tuna vineki; korapa turaṉa mae nia sa sa rovana sipi tanisa tamana,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Meke zama se Zekopi, “Korapa nomana sa rane, meke lopu ele kamo sa totoso pude varigara beto mae sari na rovana sipi, na vegua ke lopu va napoi mo gamu si hire; mamu turaṉa taloani pude va henahenai?” ");
INSERT INTO rug_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ba olaṉa si arini, “Lopu kaqu boka tavetia gami sapu gua asa, osolae mae beto tu sari doduru rovana sipi tani, meke kaqu tava rizu sa tukutuku patu, meke kaqu boka va napoi gami sari na rovana sipi,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Sipu korapa vivinei la koa rini se Zekopi, si turaṉa kamo ni mo Reseli sari na sipi tanisa tamana. ");
INSERT INTO rug_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Meke sipu dogoria Zekopi se Reseli, sa tuna vineki e Lebani, sapu sa buhina, meke sa rovana sipi tanisa, si la pa berukehe si asa, meke topili va rizua sa sa tukutuku patu meke va napoi sari na sipi. ");
INSERT INTO rug_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Beto meke la ahoa sa si asa meke kabo pa qinetu. ");
INSERT INTO rug_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Meke tozi nia sa si asa, “Arau si na turaṉana sa tamamu, meke na tuna koreo e Ribeka si rau.” Ke haqala la tozi nia e Reseli sa tamana, ");
INSERT INTO rug_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","meke sipu avosi Lebani sari na vivineina tasina buhina hie sapu se Zekopi, si haqala la tutuvia sa si asa, meke ṉaza ia na ahoa sa si asa, meke turaṉa la nia sa si asa pa vetu. Meke sipu vivinei nia Zekopi koe Lebani sari doduru tiṉitoṉa sapu ta evaṉa, ");
INSERT INTO rug_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","si zama se Lebani, “Ke hinokara hola, sapu na masaqu meke na eharaqu soti rau si goi.” Meke koa vasina se Zekopi, pa doduruna sa sidara asa. ");
INSERT INTO rug_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Meke zama la koe Zekopi se Lebani, “Namu lopu leana pude toka hoboro nau goi si rau pa mua tinavete, sina na turaṉaqu mo rau si goi. Vegua, na tinabara sa si hiva nia goi?” ");
INSERT INTO rug_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Se Lebani hie si karua sari na tuna vineki; sa pozana sapu kenuna si e Lia, meke sapu mudina si e Reseli. ");
INSERT INTO rug_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","E Lia si lopu dogodogorae valeana sari matana, ba se Reseli si leleana meke tolavaena hola isumatana. ");
INSERT INTO rug_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Meke tataru nia e Zekopi se Reseli, ke zama guahe si asa koe Lebani, “Maqu tavetavete toka nigo ka zuapa vuaheni, pude mu va malumu mae ia koa rau se Reseli pude haba ia,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Meke olaṉa se Lebani, “Be vatua rau koa goi si leana hola nia sapu be vala nia rau koa ke votiki tie si asa. Leana, mamu koa koa rau si goi,” gua se Lebani. ");
INSERT INTO rug_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Ke koa tavetavete toka nia Zekopi se Lebani pa ka zuapa vuaheni, pude ni boka haba ia se Reseli, gua; ba sa totoso si guana ka visavisa rane mo koe Zekopi, sina tataru hola nia sa se Reseli. ");
INSERT INTO rug_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Meke sipu hola saripu gua hire, si zama la koe Lebani se Zekopi, “Ele kamo mo hie sa totoso; mamu va malumia sa tumu vineki, maqu haba ia,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ke tavetia Lebani si keke inevaṉa vinarihaba, meke ruvati sa sari doduru tie pa popoa sana. ");
INSERT INTO rug_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ba sipu kamo sa boṉi, si turaṉa la nia tu Lebani sa tuna vineki kenuna, sapu se Lia koe Zekopi, meke eko turaṉia Zekopi si asa. ");
INSERT INTO rug_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Meke vala nia tugo Lebani sa nana nabulu vineki sapu se Zilipa koe Lia, pude na nana nabulu vineki gua. ");
INSERT INTO rug_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Meke pa koivugona, pana munumunu si doṉo gilania Zekopi sapu e Lia tu si asa. Ke la koe Lebani si asa meke zama, “Na vegua ke evaṉia goi koa rau sapu guahe? Tavetavete si rau pude vagia se Reseli. Na vegua ke sekesekei nau tu goi si rau?” gua se Zekopi. ");
INSERT INTO rug_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Meke olaṉa se Lebani, “Lopu na mami hahanana gami pa popoa hie, si pude varihaba kekenu sa vineki mudina sipu lopu ele varihaba sa vineki kenuna. ");
INSERT INTO rug_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Mamu aqa paki, mada va hola pakia sa vuiki vinarihaba hie, meke kote vatua tugo rau se Reseli, be guana va egoa goi pude tavetavete poni pule au ka zuapa vuaheni,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Meke va egoa Zekopi sapu gua asa, meke sipu hola sa keke vuiki koasa nana vinarihaba, si vala nia Lebani koasa se Reseli sa tuna vineki mudina, pude na nana barikaleqe tugo, gua. ");
INSERT INTO rug_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Meke vala nia tugo Lebani sa nana nabulu vineki, sapu se Biliha koe Reseli, pude na nana nabulu vineki, gua. ");
INSERT INTO rug_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Meke eko turaṉia tugo Zekopi se Reseli, meke sa nana tataru koe Reseli si hola nia sa nana tataru koe Lia. Meke ka zuapa vuaheni pule si tavetavete toka nia sa se Lebani. ");
INSERT INTO rug_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Meke sipu dogoria e Zihova sapu e Lia si lopu ta tatarue gua e Reseli, si lopu va tasuna ia Sa se Lia pude podo koburu si asa. Ba se Reseli si koa guana lopu boka podo koburu si asa. ");
INSERT INTO rug_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Meke ari tiana se Lia, meke podoa sa si keke tuna koreo, meke poza nia Rubeni sa si asa, sina zama si asa, “Ele dogoria Zihova sa qua tinasuna, ke kamahire si kote tataru nau sa loaqu si rau,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Meke ari tiana pule si asa, meke podoa pule sa si keke tuna koreo, meke zama, “Sina ele avosia e Zihova sapu lopu ta tatarue si rau, ke poni nau pule Sa sa koburu koreo hie.” Meke poza nia Simione sa si asa. ");
INSERT INTO rug_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Meke ari tiana pule tugo si asa, meke podoa pule sa si keke tuna koreo. Meke zama, “Kamahire si kaqu koa soto va nabu koa rau sa qua palabatu, sina ele podoi rau sari ka ṉeta tuqu koreo,” ke poza nia Livae sa si asa. ");
INSERT INTO rug_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Meke ari tiana pule tugo, meke podo pulea sa si keke tuna koreo, meke zama si asa, “Kamahire si maqu vahesia se Zihova.” Gua asa ke poza nia Ziuda sa si asa, meke lopu podo pule koburu si asa. ");
INSERT INTO rug_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Ba sipu gilania Reseli sapu loke tuna koe Zekopi si asa, si kono nia sa sa tasina vineki, ke zama la koe Zekopi si asa, “Mu va podo nau tuqu, babe lopu gua si kote mate qua si rau,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Meke podalae bugoro nia Zekopi se Reseli, meke zama, “Lopu boka tavetia rau, sapu e Tamasa mo telena boka tavetia. Sina Asa tu si hukatigo pude lopu podo koburu si goi!” ");
INSERT INTO rug_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Meke zama se Reseli, “Ego, hie se Biliha, sa qua nabulu vineki. Mu va tata ia pude mani podo mae nia sa si keke koburu taqarau, meke kaqu arau sa tinana sa koburu asa,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Ke vala nia Reseli se Biliha koe Zekopi, meke va tata ia Zekopi si asa. ");
INSERT INTO rug_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Meke ari tiana se Biliha, meke podoa sa si keke tuna koreo. ");
INSERT INTO rug_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Meke zama se Reseli, “Ele pitua Tamasa sa qua inokoro, meke ele avosia Sa sa qua tinepatepa meke poni nau Sa sa tuqu koreo hie,” ke poza nia Dani sa si asa. ");
INSERT INTO rug_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Meke ari tiana pule se Biliha meke podoa sa si keke koburu koreo vina rua te Zekopi. ");
INSERT INTO rug_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Meke zama se Reseli, “Ele varipera sisigiti la si rau koasa tasiqu barikaleqe meke ele mataqara si rau,” ke poza nia Napitalai sa sa pozana sa koburu. ");
INSERT INTO rug_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Meke sipu gilania Lia sapu ele tava noso si asa pude lopu podo koburu, si turaṉa la nia sa koe Zekopi se Zilipa sa nana nabulu vineki pude na nana barikaleqe gua. ");
INSERT INTO rug_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Meke va podo nia e Zekopi koe Zilipa si keke tuna koreo. ");
INSERT INTO rug_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Meke zama se Lia, “Ele gulea qua si rau!” Ke poza nia e Qadi sa sa koburu. ");
INSERT INTO rug_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Meke keke pule tuna koreo si va podo nia Zekopi koe Zilipa, ");
INSERT INTO rug_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","meke zama se Lia, “Qetu hola qua! Meke kamahire si kote poza nau qetu rina barikaleqe si rau.” Ke poza nia Asa sa sa pozana sa koburu. ");
INSERT INTO rug_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ego, pa totoso ta pakete sari na huiti koari na inuma, si la vagi Rubeni si kaiqa karoso madariki meke paleke lani koe Lia sa tinana. Meke zama la koe Lia se Reseli, “Ke tasiqu, poniau kaiqa karoso madariki tanisa tumu koreo isara.” ");
INSERT INTO rug_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ba olaṉa se Lia, “Vegua, lopu ele garona tu sapu hena va seu ia goi sa loaqu? Meke kamahire pule si korapa hiva vagi goi sari na karoso madariki tanisa tuqu koreo?” Meke olaṉa se Reseli, “Be poniau goi sari na karoso madariki tanisa tumu koreo si kote boka vagia goi se Zekopi kohite boṉi meke va tata ia,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Meke sipu pule mae pa inuma pana veluvelu se Zekopi si la tutuvia Lia si asa, meke zama ia, “Kaqu puta turaṉau goi si rau kohite boṉi sina ele tabara nigo madariki tanisa tuqu koreo rau si goi.” Ke puta turaṉia Zekopi se Lia koasa boṉi sana. ");
INSERT INTO rug_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Meke va tabea Tamasa sa vinaravara te Lia meke ari tiana si asa, meke podoa sa sa tuna koreo vina lima te Zekopi. ");
INSERT INTO rug_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Meke zama se Lia, “Ele tabarau Tamasa si rau, sina ele vala nia rau koasa qua palabatu sa qua nabulu vineki.” Ke poza nia Isaka sa sa pozana sa koburu. ");
INSERT INTO rug_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Meke ari tiana pule se Lia, meke podoa sa sa tuna koreo vina onomo te Zekopi. ");
INSERT INTO rug_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Meke zama se Lia, “Ele poni nau Tamasa si keke vinariponi leana. Kamahire si kaqu tataru nau sa loaqu si rau, sina ele podoa pule rau sa tuqu koreo vina onomo,” meke poza nia Zeboloni sa si asa. ");
INSERT INTO rug_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Mumudi si podoa sa si keke tuna vineki, meke poza nia Daena sa si asa. ");
INSERT INTO rug_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Meke balabala pulea Tamasa se Reseli, ke avosia Sa sa nana vinaravara pude boka podo koburu si asa. ");
INSERT INTO rug_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Meke aritiana si asa, meke podoa sa si keke tuna koreo, meke zama, “Ele hena pania Tamasa sa qua kinurekure, ke poniau tuqu koreo Sa si rau.” ");
INSERT INTO rug_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Meke poza nia Zosepa sa si asa, meke zama si asa, “Keke tuqu koreo pule si mani poniau e Zihova,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Sipu ele podoa Reseli se Zosepa, si zama la koe Lebani se Zekopi, “Va malumau, maqu taloa, pude maqu pule la pa qua popoa,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","“Mamu va maei sari na qua barikaleqe, meke sari na qua koburu saripu ele nabuluni rau koa goi. Maqu taluarae. Gilania goi sapu ele tavete ponigo rau sari doduru tinavete,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Ba zama la koasa se Lebani, “Maqu zama guahe: Ele doṉo vura nia rau pa qua tinavete dogodogorae, sapu vagia rau sa tinamanae te Zihova koa goi. ");
INSERT INTO rug_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Mu poza maeni sari na tinabaramu, maqu tabarigo.” ");
INSERT INTO rug_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Meke olaṉa se Zekopi, “Ele gilania goi sapu gua meke tavetavete ponigo rau, meke gua meke boka soku sari na mua rovana sipi pa qua kinopu. ");
INSERT INTO rug_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Sari ka visavisadi pu tagoi goi sipu lopu ele mae rau, si ele soku hola kamahire, meke tamanae si goi koe Zihova koa ri doduru vasina pu la i rau. Ego, qua totoso kamahire maqu podekia pude tavetia sapu gua bokaia rau,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Meke nanasa la koe Zekopi se Lebani, “Na sa si kaqu tabara nigo rau?” Meke olaṉa se Zekopi, “Lopu na tinabara poata si hiva nia rau. Be guana va egoa goi, kaqu kopu holani mo rau sari na mua rovana sipi,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","“Va malumau, maqu ene pa korapadi ri doduru mua rovana sipi ṉinoroi, maqu paqaha vagi sari doduru tuna sipi mumuhodi meke sari doduru tuna qoti saripu kidakida tinidi. Arini sari doduru tinabaraqu pu hivani rau,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","“Meke koa ri na rane mae hiroi si kaqu va sosodea goi sapu be hinokara sa qua zinama. Totoso mae doṉo viliti goi sari na qua tinabara, meke be lopu koa koa rau sari na qoti saripu loke kidakida tinidi, ba be sari na sipi loke mumuhodi, si kote gilania goi sapu ta hikodi si arini,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Meke olaṉa se Lebani, “Leana, mada lulia gua sapu vizatia goi,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Ba koasa rane sana si va rizu vata kalei Lebani sari na qoti kokoreo saripu koai gasigasi tinidi, meke sari na qoti mamaqota saripu kidakida meke kidikodili tinidi, meke gua tugo sari na sipi mumuhodi, meke valani sa koa ri na tuna koreo si arini meke kopuni, ");
INSERT INTO rug_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","meke padana ka ṉeta rane si turaṉa va seu i sa koe Zekopi sari na rovana, ke kopuni mo e Zekopi saripu koa hola koari na rovana sipi te Lebani. ");
INSERT INTO rug_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Meke maho vagi Zekopi sari na lelaṉa huda toadi, koari na huda popola, olomodi meke pelani, meke sio pani sa sari kaiqa kapudi, pude doṉo guana gasigasi keoro sari na lelaṉadi, gua. ");
INSERT INTO rug_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Meke veko lani sa sari na lelaṉa huda hire pa kenudia ri na rovana sipi, koa ri na vasina naponapoana tadirini. Ta veko si arini vasina, sina hoke varipapai sari na kurukuru sipu mae napo si arini vasina. ");
INSERT INTO rug_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Ke sipu hira sari na qoti mamaqota pa kenudi ari na lelaṉa huda si ta evaṉae gasigasi na kidakida meke korikorizoko tinidi si arini. ");
INSERT INTO rug_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Meke paqaha vata kalei Zekopi sari na tuna sipi, meke va doṉo lani sa koari na rovana, pu gasigasi na mumuho tinidia koasa rovana te Lebani pu kopu ni sa. Gua asa ke paqahi sa saripu tanisa soti koa ri pu te Lebani. ");
INSERT INTO rug_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Sipu varipapapai saripu ṉiṉiradi si veko va tata lani Zekopi sari na huda koa ri na naponapoana pa kenudia ri na kurukuru, pude madi varipapapai koari na lelaṉa huda si arini. ");
INSERT INTO rug_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ba lopu veko lani Zekopi sari na lelaṉa huda koa ri na kurukuru malohorodi, gua asa ke malohoro sari doduru kurukuru te Lebani, sari doduru te Zekopi si ṉiṉiradi. ");
INSERT INTO rug_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Gua asa ke tagotago sisigiti se Zekopi meke soku hola sari nana rovana sipi, meke sari na nabulu vineki na koreo, na kameli, meke sari na doṉ'ki na gua. ");
INSERT INTO rug_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Ba avosia Zekopi sapu ele zama nia ri na tuna koreo e Lebani si asa, sapu “Ele vagi betoi Zekopi sari doduru tinagotago tanisa tamada, meke koa ri doduru tinagotago mo tanisa tamada arini si boka tago va soku si asa,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Meke doṉo gilania tugo Zekopi sapu lopu koa baere se Lebani koasa, kekeṉoṉo gua tatasana. ");
INSERT INTO rug_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Meke zama la koe Zekopi se Zihova, “Mu kekere pule la pa popoa tadi na tiatamamu meke na turaṉamu meke kaqu koa koa goi si Rau,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Ke garunu lani zinama e Zekopi sari Lia e Reseli, pude mae tutuvia si asa pa inuma, vasina koa sari na rovana sipi gua. ");
INSERT INTO rug_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Meke zama koa rini si asa, “Ele doṉo gilania rau sapu lopu koa baere kekeṉoṉo gua visoroi hire sa tamamia koa rau. Ba koa koa rau sa Tamasa tadi na tiatamaqu. ");
INSERT INTO rug_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Meke ele gilania gamu kara sapu nabulu mate nia rau sa tamamia pa doduru qua ṉiniraṉira. ");
INSERT INTO rug_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Ba ṉoṉovala au sa tamamia meke hobei sa sari na qua tinabara ka manege puta totoso, ba lopu va malumia Tamasa si asa pude va kaleana au. ");
INSERT INTO rug_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Sipu zama se Lebani, ‘Saripu visovisodi si kaqu na tinabaramu,’ gua, si podo visoviso beto sari doduru. Sipu zama si asa, ‘Saripu gasigasi si kaqu na tinabaramu,’ gua, si podo gasigasi beto sari doduru. ");
INSERT INTO rug_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Gua asa ke ele vagi va seui Tamasa sari na rovana sipi tanisa tamamia, meke poni nau Sa koa rau si arini. ");
INSERT INTO rug_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Pa totoso hira sari na rovana, si ele putagita ia tu rau sa pinutagita, meke ele dogori tu rau sari na qoti kokoreo pu varipapai si gasigasi na kidakida meke visoviso beto si arini. ");
INSERT INTO rug_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Meke zama mae koa rau pa korapa pinutagita sa mateana te Tamasa, ‘Zekopi!,’ gua si asa. ‘Arau!,’ gua si rau. ");
INSERT INTO rug_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Meke zama si asa, ‘Dotu, sari doduru qoti kokoreo saripu korapa varipapai si gasigasi keoro, kidakida, meke kidikodili tinidi. Arau mo vata evaṉia sapu gua asa, ura ele dogoria Rau sapu gua korapa tavete nigo e Lebani koa goi. ");
INSERT INTO rug_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Arau sa Tamasa sapu vura koa goi pa Betolo. Vasina pu zoropo nia oela goi si keke patu vinabalabala meke va madia, meke zama tokotokoro koa Rau si goi. Ego va qaqiri kamahire, mamu pule la pa popoa, vasina sapu podomu si goi,’ gua.” ");
INSERT INTO rug_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Meke olaṉa la ia ri Reseli e Lia se Zekopi, “Namu loke mami hinia si koa sapu kote ponini gami sa tamamami. ");
INSERT INTO rug_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ele evaṉa guni gami sa na tie karovo mami. Ele holuholuni gami sa, meke kamahire si guana ele okipani betoni sa sari na poata hinolumami gami karua. ");
INSERT INTO rug_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Sari doduru tinagotago saripu ele vagi sa Tamasa koasa tamamami, si tamigami meke tadi na tumami. Ego, mu tavete la ia mo sapu gua tozi nigo sa Tamasa, pude tavetia,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Ke va qaqiri se Zekopi pude pule la pa popoa tanisa tamana pa Kenani. Meke va haboti sa sari nana koburu na barikaleqe pa mudidia ri na kameli, meke va enei sa pa kenuna sari doduru kurukuru, meke gua tugo sari doduru likakalae saripu vagi sa pa Padani Arami. ");
INSERT INTO rug_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Pa mudina sipu la kotoi Lebani sari nana sipi, totoso lopu koa si asa, si la hikoi Reseli sari na tamasa beku tana tatamana saripu tagoi sa tamana. ");
INSERT INTO rug_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Sekesekei nia Zekopi se Lebani sina lopu vata gilana nia sa koasa sapu taloa si asa. ");
INSERT INTO rug_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Meke vagi betoi sa sari doduru nana likakalae meke tuture taloa, meke karovia sa sa Ovuku Iuparetisi, meke ene la gua koari na toqetoqere pa Qileadi si asa. ");
INSERT INTO rug_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Meke sipu ele hola tu ka ṉeta rane si tozi nia rini se Lebani sapu ele govete taloa tu se Zekopi gua. ");
INSERT INTO rug_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Ke turaṉi Lebani sari nana tie, meke hadu lulia rini se Zekopi ka zuapa rane, osolae kamoa rini si asa koari na toqetoqere pa Qileadi. ");
INSERT INTO rug_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Meke mae koe Lebani pa korapa pinutagita sa Tamasa, koasa boṉi asa meke zama, “Mu balau, pude lopu tavete la nia tinasuna se Zekopi,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Meke sipu ele va turu nana ipi tu se Zekopi koari na toqere, si kamoa e Lebani se Zekopi, meke e Lebani meke sari na turaṉana ba va turu dia ipi tugo koa ri na toqere pa Qileadi. ");
INSERT INTO rug_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Meke zama la ia Lebani se Zekopi, “Na vegua ke sekesekei nau tu goi meke turaṉa goveteni goi sari na tuqu kekeṉoṉo gua ri na barikaleqe ta vagidi pa vinaripera? ");
INSERT INTO rug_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Na vegua ke sekesekei nau goi, meke lopu tozi nau meke govete taloa mua? Be guana tozi nau goi, si kote luara qetuqetu nigo rau, pa minikemike kinerakera, na ivivu si goi, ");
INSERT INTO rug_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Namu lopu hite va aho nau goi sari na tudia ri na tuqu, meke luluari sari na tuqu barikaleqedi. Tio, namu duviduvili si goi sapu tavete gua asa. ");
INSERT INTO rug_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Arau si ari qua ṉiniraṉira pude tavete nigo tinasuna, ba koasa boṉi sapu ele hola sana, si va balau au sa mua Tamasa, pude lopu va tasuna igo si goi, gua. ");
INSERT INTO rug_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Gilania qua sapu hiva taloa nia goi, sina hiva pule sisigiti la pa mua popoa si goi, ba vegua ke hikoi tu goi sari na qua tamasa beku huda, tana qua tatamana,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Meke olaṉa se Zekopi, “Na matagutu si rau, sina balabala ia rau sapu kote mae saputu vagi va seui goi sari na tumu barikaleqedi, gua. ");
INSERT INTO rug_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Ego, be dogoria goi tani si keke tie, sapu vagi sari na mua tamasa beku, si mani tava mate gana sa tie sana. Hire sari nada tie va sosode, pude hatai meke vagi saripu tamugoi.” Na lopu gilania Zekopi sapu e Reseli si hikoi sari na tamasa beku te Lebani. ");
INSERT INTO rug_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Meke la hata pa korapa ipi te Zekopi se Lebani, meke pa korapa ipi te Lia, meke pa korapa ipi tadi karua barikaleqe pinausu, ba lopu boka dogori sa sari nana tamasa beku. Beto asa si tiqe nuquru la hata si asa pa korapa ipi te Reseli. ");
INSERT INTO rug_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Ba se Reseli mo vagi sari na tamasa beku, meke voi lani sa pa korapa vovoina tiṉitoṉa pa habohabotuana tie tanisa kameli, meke habotu tamuni sa si arini. Meke hata betoa Lebani sa doduruna sa korapa ipi, ba lopu dogori sa si arini. ");
INSERT INTO rug_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Meke zama la koasa tamana se Reseli, “Mu lopu bugoro nau qua baṉara, na lopu boka turu pa kenumu goi si rau na korapa kamo au na minoho tamigami barikaleqe,” gua si asa. Ke, hata ia mo Lebani sa doduru vasina, ba lopu boka dogori sa sari na tamasa beku tanisa nana tatamana. ");
INSERT INTO rug_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Meke ta ṉaziri sisigiti se Zekopi, meke nanasa va bubugorae la ia sa se Lebani, meke zama, “Na tinarae sa si va sea ia rau, ke boka mae hata luliau tu goi si rau tani? ");
INSERT INTO rug_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Dotu, ele hata beto koari doduru qua likakalae si goi. Na sa sa tiṉitoṉa tanisa mua tatamana sapu ele dogoria goi? Mu paleke vura mae nia tani, pude boka dogoria rina mua tie, meke sari na qua tie si asa, meke pude boka vizatia rini sapu esei koa gita si hinokara. ");
INSERT INTO rug_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Ele koa koa goi si rau ka hiokona puta vuaheni meke lopu hite ele hira va kaleana sari na mua sipi na qoti mamaqota, meke lopu hite ele vagia rau si keke sipi kokoreo koari na mua rovana sipi. ");
INSERT INTO rug_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Sipu tava mate si keke sipi koari na kurukuru pinomo, si arau mo hoke hobea si asa doduru totoso, meke lopu hoke paleke atunia rau si asa koa goi, pude va sosodea sapu lopu na qua sinea si asa. Ba hoke tepa nia tinabara goi koa rau, saripu ta hiko pana rane babe pana boṉi. ");
INSERT INTO rug_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Meke soku totoso si hoke maṉini sisigitau na rimata pana rane si rau, meke pana boṉi si hoke ibu sisigitau meke lopu hoke puta valeana si rau. ");
INSERT INTO rug_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Gugua mo asa, sipu koa koa goi si rau, koasa doduruna sa hiokona puta vuaheni. Koari ka manege made vuaheni si nabulu mate nigo rau, pude habai sari karua tumu vineki gua, meke ka onomo vuaheni si pude vagi sari na mua rovana sipi gua. Meke koa rina totoso arini meke kamoa kamahire, ka manege puta totoso hobei goi sari na qua tinabara. ");
INSERT INTO rug_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Be lopu sa Tamasa tadi na tiatamaqu sapu sa Tamasa te Ebarahami meke te Aisake si koa koa rau, si be ele malamalaṉaqu mo meke hitu taloa nau goi si rau. Ba dogoria Tamasa sa qua tinasuna, meke sa qua tinavete sapu ele tavetia rau, gua asa ke nore igo Sa si goi koasa boṉi sapu ele hola,” gua se Zekopi. ");
INSERT INTO rug_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Meke olaṉa la ia Lebani se Zekopi, “Sari na barikaleqe hire si na tuqu mo rau, meke sari na dia koburu ba taqarau tugo si arini, meke sari na rovana sipi hire ba taqarau tugo. Meke sari doduru likakalae saripu dogori goi tani si taqarau tugo si arini. Ba koa gua mo sapu lopu kaqu boka kopuni rau kamahire sari na tuqu barikaleqe meke sari na dia koburu, ");
INSERT INTO rug_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","ke leana, aria mada tavetia si keke vinariva egoi pa varikorapada gita kara. Mada tavetia si keke vinarigarae patu pude va balabalani gita sa nada vinariva egoi hie,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Ke vagia Zekopi si keke patu, meke va turua, guana keke vina gilagila si asa. ");
INSERT INTO rug_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Meke zamai Zekopi sari nana tie pude tavetia si keke vinarigarae patu, meke tiqe henahena tata koasa vinarigarae patu si arini. ");
INSERT INTO rug_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Meke poza nia Zeqa Sahaduta Lebani si asa, ba Zekopi si poza nia Qalidi si asa. ");
INSERT INTO rug_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Meke zama la koe Zekopi se Lebani, “Sari na vinarigarae patu hire si na vina balabalana sa nada vinariva egoi gita kara,” gua asa ke ta pozae Qalidi sa vasina asa. ");
INSERT INTO rug_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Meke zama gua tugo he se Lebani, “Mani kopu totokoni gita e Zihova si gita karua, pana koa varipaqahi si gita.” Gua asa ke ta pozae Mizipa tugo sa vasina asa. ");
INSERT INTO rug_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Meke zama pule tugo se Lebani, “Be ṉoṉovali goi sari na tuqu barikaleqe, babe habai goi si kaiqa barikaleqe pule, meke be lopu gilania rau si asa, mada balabala ia sapu korapa kopu totokoni gita Tamasa si gita karua. ");
INSERT INTO rug_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Hire sari na patu saripu ele varihakehakeni rau pa varikorapada gita karua, meke hiera tugo sa patu vina gilagila. ");
INSERT INTO rug_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Sari karua beto hire, sa vinarihakehakei patu, meke sa patu vina gilagila si na vina balabalana sa nada vinariva egoi gita karua. Lopu kaqu hola nia rau sa vinarihakehakei patu hie pude kana igo, meke agoi ba lopu kaqu hola nia sa vinarihakehakei patu meke sa patu vina gilagila hie. ");
INSERT INTO rug_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Sa Tamasa te Ebarahami meke sa Tamasa te Nehoa, si kaqu pitu gita si gita karua.” Ke pa korapa pozana sa Tamasa sapu vahesia e Aisake sa tamana, si zama tokotokoro va nabu se Zekopi pude kopu nia sa vina tatara asa. ");
INSERT INTO rug_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Meke va matea Zekopi si keke kurukuru, meke va vukivukihi nia pa batuna sa toqere, meke tioki sa sari na tie koasa hinenahena. Meke sipu beto henahena si arini, si puta si arini pana boṉi koasa toqere. ");
INSERT INTO rug_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Meke pana munumunu hokara si vaṉunu se Lebani meke ahoi sa sari na tudia rina tuna meke sari na tuna barikaleqe meke taluarae pule la si asa pa nana popoa soti. ");
INSERT INTO rug_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Meke sipu korapa ene la pa nana siraṉa se Zekopi si tutuvia ri na mateana te Tamasa si asa. ");
INSERT INTO rug_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Meke sipu dogori sa si arini si zama si asa, “Hiera sa puku vinarigara te Tamasa!” gua. Ke poza nia Mahanaimi sa sa vasina asa. ");
INSERT INTO rug_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Meke garunu va kenue lani e Zekopi koe Isoa pa popoa Edomu sari nana tie paleke inavoso. ");
INSERT INTO rug_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Meke totozini sa si arini, pude zama guahe, “Arau Zekopi sa mua nabulu si zama: ‘Ele koa va seunae hola koe Lebani si rau kamoa kamahire meke tiqe pule mae. ");
INSERT INTO rug_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Meke ele soku hola sari na rovana bulumakao, na doṉ'ki, na sipi, na qoti meke sari na pinausu koreo na vineki, saripu ele tagoi rau, ke totozi atu si rau koa goi na qua baṉara, pude qu ta qetue qua koa goi,’ mamu gunia,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Meke pule mae koe Zekopi sari na tie paleke inavoso meke zama, “Ele kamoa gami se Isoa, sa tasimu, meke kamahire si korapa mae si asa pude tutuvigo. Ka made gogoto tie si korapa luli mae koa sa,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Meke matagutu na balabala mamata sisigiti se Zekopi. Meke paqaha rua i sa sari na tinoni pu luli koa sa, meke gua tugo sari na sipi, na qoti, bulumakao na kameli. ");
INSERT INTO rug_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Balabala ia Zekopi sapu, “Be kamo rapatia Isoa sa pukuna kekenu, ba sapu keke si kote boka govete taloa nana meke ta harupu,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Meke varavara se Zekopi, “Ke Tamasa, Tamasa tanisa tamaqu Ebarahami, meke sa tamaqu Aisake; Mu avoso mae au! Ele tozi nau Goi Zihova pude pule la pa qua popoa meke koa ri na turaṉaqu soti meke kote toka nau guni nau Goi si rau. ");
INSERT INTO rug_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Arau sa Mua nabulu si namu lopu hite garoqu rau pude vagi sari doduru tinarutaru nabudi na inaque nomadi sapu ele va dogoro nau Goi, sina loketoṉa si va karovau si rau pa kolo Zodani ba na kolu hodu mo. Meke kamahire si pule mae mo pa karua pukuna tu hire si rau. ");
INSERT INTO rug_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ke tepaigo rau, Mu harupau pa limana sa tasiqu, se Isoa, sina matagutu nia rau sapu korapa mae va mate au sa meke gua tugo sari na barikaleqe na koburu. ");
INSERT INTO rug_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ba Agoi mo sapu ele zama guahe, ‘Kaqu koa valeana si goi,’ guni nau Goi, meke ‘kaqu va sokui rau sari na tutimu gua ri na onone pa masa sapu lopu boka ta nae,’ ” gua se Zekopi. ");
INSERT INTO rug_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","15","Meke sipu hola sa boṉi vasina, si va namaia sa si keke vinariponi te Isoa, sa tasina. Karua gogoto qoti mamaqota meke ka hiokona puta qoti kokoreo, meke karua gogoto sipi mamaqota meke ka hiokona puta sipi kokoreo. Ka toloṉavulu puta kameli va sususu meke sari na tudia, ka made ṉavulu puta bulumakao mamaqota meke ka manege puta bulumakao kokoreo, meke ka hiokona puta doṉ'ki mamaqota meke ka manege puta doṉ'ki kokoreo. ");
INSERT INTO rug_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Meke paqahi sa si arini koa ri hopeke pukuna, meke hopeke vekoni koimata sa sari na hopeke pukuna. Meke zama koa rini si asa, “Mi la va kenue koa rau, ba mamu veko lolomo koa ri mia pukuna, pa vari korapana sa tie kekenu meke sapu mumudi,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Meke totozi nia sa sa nabulu sapu ele kekenu, “Pana tutuvigo sa tasiqu se Isoa meke nanasigo, ‘Esei sa mua baṉara? Meke pavei si korapa la si goi? Meke tesei sari na kurukuru pa kenumu goi sara?’ gua, ");
INSERT INTO rug_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","si kaqu olaṉa guahe si goi, ‘Tanisa mua nabulu e Zekopi si arini, na garununi sa pude nana vinariponi koasa nana baṉara, e Isoa, gua. Meke korapa luli mumudi mae si asa,’ mu gunia.” ");
INSERT INTO rug_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Zama gunia tugo sa sapu vina rua meke sapu vina ṉeta, meke koa ri doduru pule saripu koimatani sari na pukuna, “Gua asa sapu kaqu zama nia gamu koe Isoa, pana tutuvia gamu si asa,” gua se Zekopi. ");
INSERT INTO rug_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","“Kaqu zama guahe si gamu, ‘Sa mua nabulu se Zekopi si korapa luli mudi mae koa gami,’ mamu gunia.” Ura balabala ia Zekopi sapu, “Kote va boka au sa si rau koa ri na vinariponi pana tutuvia rau si asa, meke gina kote taleoso nau sa,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Meke garunu va kenue lani sa koasa sari na vinariponi, meke asa si koa hola nana vasina koasa boṉi sana. ");
INSERT INTO rug_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Meke koasa boṉi tugo asa si tekulu se Zekopi, meke turaṉi sa sari karua nana barikaleqe, meke sari karua nana nabulu barikaleqe, meke sari ka manege eke koburu tanisa, meke ene karovia rini sa ovuku Zaboki. ");
INSERT INTO rug_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Pa mudina sipu va karovi sa si arini, si va karovi tugo sa sari doduru nana likakalae. ");
INSERT INTO rug_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Ba koa hola telena eke se Zekopi, meke mae si keke tie meke vari ṉazai sari karua, osolae maraqata mae sa rane. ");
INSERT INTO rug_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Meke sipu va nonoga ia sa tie sapu lopu bokaia sa se Zekopi, si seke la ia sa sa siqena e Zekopi ke varisea i sa susuri siqena. ");
INSERT INTO rug_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Meke zama ia sa tie se Zekopi, “Mu luarau, ura korapa mae sa rane.” Ba zama se Zekopi, “Lopu kaqu luara igo rau, be lopu mana nau goi,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Meke nanasa sa tie, “Esei pozamu si goi?” Meke olaṉa si asa, “Arau Zekopi,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Meke zama sa tie, “Lopu kaqu ta pozae pule Zekopi si goi, ura ele toketokea goi pa tinaṉaziri sa Tamasa meke sari na tie, meke ele mataqara si goi, ke kaqu ta pozae Izireli sa pozamu,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Meke nanasia Zekopi sa tie, “Mu tozi nau sa pozamu.” Ba olaṉa si asa, “Na vegua ke hiva gilania tu goi sa pozaqu?” Meke mana nia sa tie se Zekopi. ");
INSERT INTO rug_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Gua asa ke poza nia Penieli e Zekopi sa pozana sa vasina asa. Zama si asa, “Ele dogoro soti nia mataqu rau sa Tamasa, meke tava sare sa qua tinoa,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Meke sipu gasa sa rimata si taluarae pa Penieli se Zekopi. Meke ene soqulu kale si asa sina varisea i sa siqena. ");
INSERT INTO rug_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Meke kamo pa rane ṉinoroi, sari na tutina e Izireli si lopu gania sa masa pa varihodae susuri siqe, sina asa sa masa sapu koa pa siqena e Zekopi, gua. ");
INSERT INTO rug_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Meke doṉo la se Zekopi, meke dogoria sa se Isoa, meke sari ka made gogoto tie saripu korapa luli mae koasa. Ke paqahi sa sari nana tamatina, saripu te Lia meke te Reseli, meke gua tugo saripu tadi karua nabulu barikaleqe. ");
INSERT INTO rug_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Meke va kekenu i sa sari na nabulu barikaleqe, meke sari na tudia, beto asa si e Lia meke sari nana koburu si pa mudidia, meke ari Reseli e Zosepa si mumudi hokara. ");
INSERT INTO rug_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Meke ene va kenue se Zekopi koa ri doduru meke todoṉo gore si asa ka zuapa totoso pa pepeso, sipu tata kamoa sa sa tasina. ");
INSERT INTO rug_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ba haqala la tutuvia Isoa si asa, meke ṉaza ia meke ahoa sa si asa. Meke vari kaboi sari karua. ");
INSERT INTO rug_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Meke sipu doṉo vari likohae se Isoa meke dogori sa sari na barikaleqe na koburu, si nanasa si asa, “Ari sei si luli koa goi hire?” Meke olaṉa se Zekopi, “Arini sari na koburu saripu poni moka nau sa Tamasa koa rau,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Meke tata mae sari na nabulu barikaleqe meke sari na dia koburu meke todoṉo, ");
INSERT INTO rug_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Meke gua tugo se Lia meke sari na tuna, meke mumudi si mae tugo sari Zosepa e Reseli meke todoṉo beto sari doduru. ");
INSERT INTO rug_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Meke nanasa se Isoa, “Pude vegua sari kaiqa puku vinarigara tie na kurukuru saripu ele tutuvi rau? Na sa ginuadi sari?” Meke olaṉa se Zekopi, “Pude ta qetue qua koa goi,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ba olaṉa se Isoa, “Ele pada mo saripu tagoi rau, tasiqu, mamu kopuni mo saripu tagoi goi,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Meke zama se Zekopi, “Lokari, be qetu nau goi si mamu vagi tugo sari na qua vinariponi. Pude dogoro nigo mataqu, si kekeṉoṉo gua tugo arau sapu dogoro nia mataqu sa Tamasa. Sina ele koa baere si goi koa rau kamahire. ");
INSERT INTO rug_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ke mu vagi sari na qua vinariponi hire saripu ele paleke vatuni rau koa goi pude tamugoi, ura ele tataru nau sa Tamasa si rau, ke poni nau Sa sari doduru likakalae saripu hivani rau,” gua si asa. Meke tepa ososo nia Zekopi si asa, osolae vagi tu e Isoa si arini. ");
INSERT INTO rug_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","“Ego, mada topue! Arau si kote ene kekenu koa gita,” gua se Isoa. ");
INSERT INTO rug_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Ba zama ia Zekopi si asa, “Ele gilania goi qua baṉara sapu lopu ṉiṉira sari na koburu, meke balabala i tugo rau sari na sipi mamaqota, na bulumakao mamaqota, saripu va susui sari na tudia; meke be toleṉe gua ta hadu zukuru sisigiti si arini pa keke doduru rane, si kote mate beto sa rovana. ");
INSERT INTO rug_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Leana baṉara, mamu ene va kekenu la koa rau. Maqu ene hitehite turaṉi rau sari na rovana bulumakao, meke sari na koburu, osolae kaqu kamo gamu rau pa Edomu,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ke zama se Isoa, “Ego, maqu vekoi kaiqa qua tie koa goi.” Ba olaṉa se Zekopi, “Lopu ta hivae sapu gua asa, na hiva ta qetue qua mo koa goi si rau,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Ke koasa rane sana si podalae ene pule lamo pa Edomu se Isoa. ");
INSERT INTO rug_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Ba ene la pa Sukoti se Zekopi meke kuria sa si keke nana vetu, meke na ipi aqaqoroana tadi nana kurukuru gua asa ke ta pozae Sukoti sa vasina asa. ");
INSERT INTO rug_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Meke sipu taluarae se Zekopi pa popoa Mesopotemia, si kamo valeana si asa koasa vasileana lavata pa Sekemi pa popoa Kenani, meke noso si asa tata koa sa vasileana lavata asa. ");
INSERT INTO rug_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Meke holu nia keke gogoto poata siliva Zekopi sa kukuru pepeso asa, vasina pu va turu nia sa sa nana ipi poko, koa ri na tutina e Hamora, sa tamana e Sekemi. ");
INSERT INTO rug_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Meke tavetia sa si keke hope vasina, meke poza nia El Elohe Izireli sa, sapu sa ginuana si “Tamasa, sa Tamasa te Izireli,” gua. ");
INSERT INTO rug_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Keke rane si ene la baere nana koa ri na vineki pa popoa sana gua, sa tudia vineki ri Lia e Zekopi sapu se Daena. ");
INSERT INTO rug_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Meke sipu dogoria e Sekemi na tie Hivaiti, sapu sa tuna Hamora, na baṉara pa popoa sana si asa, si ṉaza ososo nia sa si asa meke va sea ia sa. ");
INSERT INTO rug_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Na dogoria sa sapu leleana hola sa vineki meke okoro nia sa, ke va lomolomosia sa si asa. ");
INSERT INTO rug_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Meke zama ia Sekemi sa tamana, “Hiva nia rau pude mamu la va toṉoto mae nia sa vineki hie pude na qua barikaleqe,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Meke gilania Zekopi sapu ele sea sa tuna vineki. Ba sina koa pa seu, pa inuma sari na tuna koreo, kopuni rini sari na rovana bulumakao, ke lopu kulu nia sa si asa, osolae kamo pule mae tu si arini. ");
INSERT INTO rug_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Meke la vivinei koe Zekopi se Hamora, sa tamana e Sekemi. ");
INSERT INTO rug_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Meke sipu kamo pule mae tugo pa inuma sari na tuna koreo e Zekopi, si hinoqa avoso nia rini sapu gua asa, meke hodahodaka na ta ṉaziri sisigiti nia rini sa tinavete gua asa, sapu tavetia e Sekemi, meke loke pinamaṉa koa ri na tinoni Izireli koasa tinavete kaleana, sapu tavete la nia sa koasa tuna vineki e Zekopi, gua. ");
INSERT INTO rug_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Meke zama se Hamora koe Zekopi, “Sa tuqu koreo si tataru hola nia sa sa tumu vineki, ke tepa gamu rau, mi va malumia pude mani haba ia. ");
INSERT INTO rug_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Mada variva ego nia, pude ta varihabae sari na mami tie koa gamu, meke sari na mia tie koa gami. ");
INSERT INTO rug_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Meke kaqu koa koa gami tani pa mami popoa si gamu. Meke vasina sapu hiva koa ia gamu si kaqu koa si gamu, meke hata mia poata na lelete mia, na gua,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Meke zama la koa sa tamana e Daena meke koa ri na tasina koreo se Sekemi, “Mi va malumu au, meke kaqu ponini gamu rau sapu gua hiva nia gamu. ");
INSERT INTO rug_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Meke mamu tozi nau, sapu na sa sari na vinariponi saripu hiva nia gamu; meke kaqu ponini gamu rau sapu gua tepa ia gamu, be va malumu mae nia mo gamu si asa, maqu haba ia,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Ba sina ele va sea ia tu e Sekemi sa tasidia vineki sapu se Daena, ke va tabe kokohai mo ri na tuna koreo e Zekopi sari Sekemi meke sa tamana sapu se Hamora. ");
INSERT INTO rug_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Zamaia rini si asa, “Gami lopu boka va malumia sa tasimami vineki koa ke tie, sapu lopu ele maguna d sina variva kurekure hola sapu gua asa koa gami. ");
INSERT INTO rug_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Boka va ego gamu mo gami si gamu pa keke ginugua, be hiva koa kekeṉoṉo gua gami si gamu, si kaqu magu beto sari doduru koreo koa gamu. ");
INSERT INTO rug_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Beto tu asa si kaqu tiqe va egoa gami, si pude varihaba mae si gamu meke gami si boka varihaba atu koa gamu. Meke kaqu koa koa gamu si gami meke kaqu keke tiena mo si gami koa gamu. ");
INSERT INTO rug_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ba be lopu va egoa gamu si pude magu si gamu, si kaqu vagia gami sa tasimami vineki meke taloa,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Sari na dia zinama si variva qetu koari Hamora meke sa tuna sapu se Sekemi. ");
INSERT INTO rug_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Meke lopu sana tavetia sa koreo sapu gua asa, ura tataru hola nia sa sa tuna vineki e Zekopi. Meke na tie ta pamaṉaena hola tugo si asa koasa doduruna sa nana tatamana soti. ");
INSERT INTO rug_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Ke mae pa sasadana sa vasileana nomana, pa vasina vivineina sari Hamora meke sa tuna, sapu se Sekemi, meke zama guahe koa ri na tie koasa vasileana nomana sana, ");
INSERT INTO rug_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Tie leadi sari na tie hire koa gita,” gua si arini. “Mada va koai pa nada popoa, madi holudia vasidi sina garo sari na vasidi hire koa rini meke gita si mada habai sari na tudia, meke mada vala i tugo koa rini sari na tuda vineki,” gua sari karua. ");
INSERT INTO rug_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","“Ba gua mo he si hiva nia ri na tie hire pude koa koa gita, meke ta evaṉae keke tie mo si gita koa rini, si pude ta magu mo sari doduru nada koreo, gua tugo sapu ta magu si arini, gua. ");
INSERT INTO rug_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Vegua lopu kaqu tadigita sari dia bulumakao na likakalae, meke sari doduru dia kurukuru? Leana, mada va egoi pude madi koa koa gita.” ");
INSERT INTO rug_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Ego, sari doduru tie pu varigara koa sa vasileana nomana sana si va egoa mo sapu gua hiva nia ri Hamora, meke sa tuna, sapu se Sekemi pa dia binalabala. Meke magu beto sari doduru koreo. ");
INSERT INTO rug_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Pa mudina sa rane vina ṉeta sipu korapa qaqaramana sari na dia minagu, si harupu vagi ri karu tamatasi, tuna e Zekopi, ari Simione e Livae, karua tasina e Daena sari dia vedara, meke la rapatia ri karua sa vasileana lavata, sapu lopu va nonoga ia keketoṉa, meke seke va matei ri kara sari doduru koreo. ");
INSERT INTO rug_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Meke somana tava mate tugo sari Hamora, meke sa tuna koreo, sapu se Sekemi, meke vagia rini se Daena pa vetu te Sekemi meke taloa dia. ");
INSERT INTO rug_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Meke sipu ele tava mate sari na tie, si mae sari kaiqa tuna koreo e Zekopi meke zalo vagi sari na likakalae koasa vasileana lavata, pude pahuku hobea sa sinea sapu ta evaṉa koasa tasidia vineki gua. ");
INSERT INTO rug_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Meke vagi tugo rini sari na dia rovana sipi, na bulumakao meke sari na dia doṉ'ki, meke sari dia likakalae pa korapana sa vasileana lavata, meke koari na dia inuma. ");
INSERT INTO rug_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Meke vagi betoi rini sari doduru dia tinagotago marilaedi, meke sari doduru dia koburu na barikaleqe, meke sari doduru likakalae saripu koa pa korapa dia vetu, meke taloa dia si arini. ");
INSERT INTO rug_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Meke zama la i Zekopi sari Simione e Livae, “Ele va tasuna au gamu kara si rau, sina kote kanau ri na tiena sa butubutu Kenanaiti meke Perizaiti, meke doduru tie pa popoa hie si rau. Lopu soku sari na qua tie, meke be varigara nau rini meke razau, si kote mate beto si gita doduru,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ba olaṉa sari kara, “Lopu kaqu boka va malumia gami pude gunia na maqota sa tasimami vineki,” gua sari karua. ");
INSERT INTO rug_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Beto asa si zama sa Tamasa koe Zekopi, “Mu la pa Betolo, mamu la koa vasina, mamu la kuria si keke hope vasina sapu vura koa goi si Rau totoso govete nia goi sa tasimu, sapu se Isoa,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Ke zama la koa ri nana tatamana soti meke koari doduru pu koa koasa se Zekopi, “Mi veko pani sari na tamasa kokohadi tadi pa votiki butubutu saripu tagoi gamu, mamu va via puleni gamu, mamu va sagei sari na poko viadi. ");
INSERT INTO rug_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Sina kote taluarae si gita tani meke la pa Betolo, meke vasina si kaqu kuria rau si keke hope te Tamasa. Asa tugo sa Tamasa sapu toka nau si rau pa totoso tasuna, meke gua tugo sapu koa koa rau koari doduru vasina pu ele la i rau,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Ke vala i rini koe Zekopi sari na tamasa beku saripu tagoi rini, meke gua tugo sari na vikulu saripu va sotoi rini pa taliṉadia meke geli tamunu pani sa si arini pa kauruna sa huda oaku tata koasa vasileana pa Sekemi. ");
INSERT INTO rug_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Meke sipu korapa taluarae rini, si kamo mae koa ri na tinoni pu koa tata koa ri na vasileana nomadi sa minatagutu lavata, ke lopu hadu luli rini si arini. ");
INSERT INTO rug_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Meke mae se Zekopi meke sari doduru nana tie pa Luzi, sapu kamahire si ta pozae Betolo gua, pa popoa Kenani. ");
INSERT INTO rug_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Vasina si kuria sa si keke hope meke poza nia Tamasa pa Betolo sa sa vasina asa, ura vasina si va vura pule nia sa Tamasa koasa sipu govete nia sa sa tasina. ");
INSERT INTO rug_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Meke mate se Debora, sa barikaleqe sapu kopu nia se Ribeka, meke ta pomunae pa kauruna keke huda oaku pa kali matao pa Betolo si asa. Gua asa ke ta pozae huda oaku tana kabokaboana si asa. ");
INSERT INTO rug_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Ego, sipu pule mae gua pa Mesopotemia se Zekopi, si vura pule mae koa sa sa Tamasa meke mana nia Sa si asa. ");
INSERT INTO rug_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Meke zama la koasa sa Tamasa, “E Zekopi sa pozamu agoi, ba kamahire si lopu kaqu ta pozae Zekopi si agoi, ba e Izireli,” gua asa ke ta pozae Izireli si asa. ");
INSERT INTO rug_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Meke zama sa Tamasa koasa, “Arau tugo sa Tamasa, Tamasa pu tagoi sari doduru ṉiniraṉira; mamu podopodo va soku koburu si goi, meke sari na butubutu si kaqu vura mae pa korapa tutimu goi. Meke agoi tugo sa tiatamadia rina baṉara. ");
INSERT INTO rug_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Kaqu ponigo Rau sa popoa sapu poni nia Rau koe Ebarahami meke koe Aisake. Meke kaqu vala nia tugo Rau si asa koari na tutimu pa mudina sa mua minate.” ");
INSERT INTO rug_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Beto, meke murimuri taloa sa Tamasa koasa. ");
INSERT INTO rug_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Meke va turu nia patu vina gilagila e Zekopi sa vasina sapu zama sa Tamasa koasa, meke zoropo nia vaeni na oela olive sa si asa, meke va madia. ");
INSERT INTO rug_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Meke poza nia Betolo sa sa vasina asa. ");
INSERT INTO rug_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Meke taluarae pa Betolo se Zekopi meke sa nana tatamana, meke sipu ele seu vasinahite pa popoa Eparata si arini, si kamo mo sa totoso te Reseli pude podoa sa koburu. ");
INSERT INTO rug_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Meke sipu tasigiti hola si asa, si zama ia sa barikaleqe va podopodo si asa, “Mu lopu matagutu si goi Reseli, sina na keke koburu koreo pule si podoa goi,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Ba mate se Reseli. Ba sipu lopu ele luara siṉo si asa, si poza nia Benoni sa sa tuna koreo, ba la sa tamana meke poza nia Benisimane si asa. ");
INSERT INTO rug_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Meke sipu mate se Reseli, si pomunu nia rini si asa pa kapa siraṉa pa Eparata, sapu pa Betilihema ta gilana kamahire. ");
INSERT INTO rug_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Meke va turua Zekopi si keke patu vina gilagila vasina, meke kamoa pa rane ṉinoroi, si korapa na vina gilagila lovuna e Reseli si asa. ");
INSERT INTO rug_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Meke ene hola la se Izireli meke va turua sa sa nana ipi poko pa kalina la sa vetu ululu ṉiṉirana pa Edera. ");
INSERT INTO rug_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Meke sipu koa koasa popoa sana se Izireli, si la tu e Rubeni meke koa turaṉia si keke ri kasa barikaleqe nabulu tanisa tamana, pozana e Biliha. Meke bugoro sisigiti se Zekopi sipu avoso nia sa si asa. Ari ka manege rua sari na tuna koreo e Zekopi. ");
INSERT INTO rug_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Sari na tuna e Lia si ari Rubeni sapu sa tuna koreo kenuna e Zekopi, e Simione, Livae, Ziuda, Isaka meke e Zeboloni. ");
INSERT INTO rug_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Meke saripu te Reseli si ari Zosepa meke e Benisimane. ");
INSERT INTO rug_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Meke saripu te Biliha (sa barikaleqe nabulu te Reseli) si ari, Dani meke Napitalai. ");
INSERT INTO rug_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Meke saripu te Zilipa, sapu sa nabulu barikaleqe te Lia, si ari Qadi meke e Asa. Arini sari doduru tuna koreo e Zekopi, saripu va podoni sa koa ri nana barikaleqe pa Mesopotemia. ");
INSERT INTO rug_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Meke pule la koasa tamana sapu se Aisake se Zekopi pa Mamere, tata pa Heboroni, vasina pu koa sari Ebarahami e Aisake tatasana. ");
INSERT INTO rug_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Meke kamoa ka keke gogoto vesu ṉavulu puta vuahenina se Aisake. ");
INSERT INTO rug_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Meke mate pa totoso barogoso nopele si asa, meke pomunu nia ri karua tuna, ari Isoa e Zekopi si asa. ");
INSERT INTO rug_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Hire sari na tutina e Isoa, sapu ta pozae Edomu. ");
INSERT INTO rug_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Meke hire sari na barikaleqe Kenani saripu habai e Isoa: e Eda, sa tuna vineki e Eloni, na tie Hitaiti; e Oholibama, sa tuna vineki e Anaha, sapu sa tuna koreo e Zibeoni na tie Hivaiti; ");
INSERT INTO rug_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","meke se Basemati, sa tasina vineki e Nebaioti sapu podo koe Isimeli. ");
INSERT INTO rug_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Meke Eda podoa se Elipazi, meke Basemati podoa se Reueli. ");
INSERT INTO rug_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Meke se Zeusi, e Zalama meke se Kora saripu podo koe Oholibama. Arini sari doduru koreo saripu podo pa tutina e Isoa pa popoa Kenani. ");
INSERT INTO rug_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Beto asa si turaṉi sa sari nana barikaleqe na tuna koreo na vineki, meke sari doduru tie pa nana vetu, meke sari doduru nana rovana kurukuru, meke sari doduru nana likakalae saripu ele vagi sa pa popoa Kenani, meke rizu la si asa pa keke popoa sapu seu koe Zekopi sa tasina. ");
INSERT INTO rug_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Rizu taloa si asa, sina sa vasina sapu koa ia ri karua Zekopi si lopu pada koa rini. Soku sari na dia rovana kurukuru, ke lopu kaqu boka koa varigara sari karua. ");
INSERT INTO rug_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Ke la koa pa korapa popoa toqetoqere pa popoa Edomu koari na toqetoqere saripu ta pozae Seira se Isoa. ");
INSERT INTO rug_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Meke hire sari na tutina e Isoa, sapu sa tamadia ri na tinoni pa popoa Edomu. ");
INSERT INTO rug_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Se Eda sa barikaleqe te Isoa, si podoa si keke tuna koreo pozana e Elipazi. Meke se Elipazi, hie si ari ka lima sari na tuna koreo: pozadi si ari Temani, Omara, Zepo, Qatami meke e Kenazi. Meke koasa keke nana barikaleqe pule, sapu se Timina, si va podo nia sa koasa si keke tuna koreo pule, sapu se Amaleki. Meke koe Basemati sapu keke nana barikaleqe pule, si va podo nia Isoa si keke tuna koreo, pozana e Reueli, meke se Reueli hie si ka made tuna koreo: Ari Nahati, Zera, Sama, meke e Miza. ");
INSERT INTO rug_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Meke keke pule barikaleqe te Isoa si e Oholibama. Sa tuna vineki e Anaha si asa. Anaha si na tuna koreo e Zebeoni. Meke podoi ri Isoa meke Oholibama sari ka ṉeta tudia koreo: ari Zeusi, Zalama, meke e Kora. ");
INSERT INTO rug_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Meke hire sari na butubutu saripu tuti gore mae gua koe Isoa. Se Elipazi sapu sa tuna kenuna e Isoa, si na tamadia ri na butubutu hire pukerane: ari Temani, Omara, Zepo, Kenazi, ");
INSERT INTO rug_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Qatami, meke e Amaleki. Arini sari doduru tutina e Isoa saripu va podoni sa koe Eda, sapu sa nana barikaleqe. ");
INSERT INTO rug_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Ego, se Reueli hie, si na tuna koreo e Isoa, meke asa sa tamadia ri na butubutu hire pukerane: ari Nahati, Zera, Sama, meke e Miza. Arini sari doduru tutina e Isoa saripu va podoni sa koasa nana barikaleqe, sapu se Basemati. ");
INSERT INTO rug_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Ego, hire pule sari na butubutu saripu tuti gore mae gua koe Isoa, saripu va podoni sa koe Oholibama, sapu sa nana barikaleqe meke na tuna tugo e Anaha: Ari Zeusi, Zalama meke e Kora. ");
INSERT INTO rug_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Sari doduru butubutu arini si tuti gore beto mae gua koe Isoa. ");
INSERT INTO rug_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Sari na tinoni saripu koa kekenu pa popoa Edomu saripu tozia vivineidi rina tiatamadia pukerane, si paqaha koa ri na butubutu saripu tuti gore mae gua koe Seira sapu na tie Horaiti si hire: Lotani, Sobali, Zibeoni, Anaha, Disoni, Ezera, meke e Disani. ");
INSERT INTO rug_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Se Lotani hie si na tamadia ri na butubutu Horaiti meke Hemani pukerane meke koa nana tugo keke tasina vineki pozana e Timina si asa. ");
INSERT INTO rug_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Meke se Sobali hie si na tamadia ri na butubutu pa Alavani, Manahati, Ebali, Sepo, meke e Onami. ");
INSERT INTO rug_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Se Zibeoni hie si karua tuna si asa: ari Aia, meke e Anaha. Se Anaha hie sapu dogorona sa kolo sapu maṉini, sipu kopuni sari na doṉ'ki tanisa tamana pa korapa soloso. ");
INSERT INTO rug_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","26","Se Anaha hie si na tamana e Disani, sapu sa tamadia ri na butubutu hire: ari Hemidani, Esibani, Itirani, meke Kerani. Keke Oholibama si na tuna vineki tugo e Anaha. ");
INSERT INTO rug_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Se Ezera hie si na tamadia ri na butubutu hire pukerane: ari Bilihani, Zavani, meke se Akani. ");
INSERT INTO rug_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Meke se Disani hie si na tiatamadia ri na butubutu hire pukerane: ari Uzi meke e Arani. ");
INSERT INTO rug_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Meke hire sari na butubutu Horaiti pa popoa Edomu: ari Lotani, Sobali, Zibeoni, Anaha, Disoni, Ezera, meke se Disani. ");
INSERT INTO rug_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","39","Sipu lopu ele va turu baṉara sari na tinoni pa Izireli si hire sari na baṉara saripu ele boka vari hobehobei mae meke kopu nia sa popoa Edomu: E Bela, sa tuna koreo e Beoro, sapu mae guana pa vasileana nomana pa Dinihaba. E Zobabi, sa tuna koreo e Zera, sapu mae guana pa vasileana nomana pa Bozira. E Husami, sapu mae guana pa popoa Temani. E Hadadi, sa tuna koreo e Bedadi, sapu mae guana pa Aviti; sa tie hie si va kilasi sari na tinoni pa Midiani koasa vinaripera pa popoa Moabi. E Samala, sa tie sapu mae guana pa vasileana nomana pa Masireka, E Saulu, sapu mae guana koasa ovuku nomana pa Rehoboti. E Beolo Hanani sa tuna koreo e Akabora. E Hadadi, sapu mae guana pa vasileana nomana pa Pau. Sa pozana sa nana barikaleqe si e Mehetabeli, sa tuna vineki e Materedi, meke sa tuna, sa tuna e Mezahabi. ");
INSERT INTO rug_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Meke hire sari na butubutu saripu gore mae gua koe Isoa sapu sa tamadia pukerane pa popoa Edomu: ari Timina, Aliva, Zetehi, Oholibama, Elaha, Pinoni, Kenazi, Temani, Mibiza, Maqadieli, meke e Airami. Sari na vasidi saripu hopehopeke koai ri na butubutu hire, si ta gilana pa pozana sa butubutu. ");
INSERT INTO rug_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Meke koa mo pa popoa Kenani se Zekopi, vasina sapu ele koa sa tamana. ");
INSERT INTO rug_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ego, hie sa vivineina sa tatamana te Zekopi. Sipu manege zuapa vuahenina se Zosepa si somana kopu rovana sipi na qoti koa ri na tasina si asa, koa ri pu podoi Biliha meke e Zilipa sapu sari karua nabulu barikaleqe tanisa tamana. Meke hoke la tozi va hakehakeini Zosepa koasa tamadia sari na tasina. ");
INSERT INTO rug_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Ego, tataru hola nia Zekopi se Zosepa, holani sari doduru tuna koreo pule, ura na podo pa nana totoso barogoso si asa. Meke tavete ponia keke koti gele lima meke leleana hola sa si asa. ");
INSERT INTO rug_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Meke sipu gilania rina tasina sapu tataru hola nia sa tamadia se Zosepa, hola nia sa nana tataru koa rini, si kukiti nia rini si asa, meke lopu hoke zama valeania na qetu nia rini si asa. ");
INSERT INTO rug_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Keke totoso si putagita se Zosepa, meke sipu tozia sa koa ri na tasina sa nana pinutagita, si gigiri hola latu sa dia kinukiti koasa. ");
INSERT INTO rug_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Zama si asa koa rini, “Mae mamu avosia sa pinutagita sapu ele putagitaia rau,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","“Gita doduru si koa pa inuma meke iqosi sari na huiti, meke turu toṉoto sage sapu taqarau, meke mae turu vari likohae nia ri na mia iqoso sapu taqarau, meke todoṉo nia rini si asa,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Meke zama la ia rina tasina si asa, “Vegua, balabala ia goi sapu kaqu koa baṉara meke kaqu totolini gami goi si gami, taga?” Ke namu toleṉe gua kukiti hola nia rini si asa, sina koa gua koasa nana pinutagita meke koa ri na zinama saripu zamani sa koa rini. ");
INSERT INTO rug_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Beto asa, si keke pinutagita pule si putagitaia e Zosepa, meke zama si asa koa ri na tasina, “Keke pinutagita pule si ele putagitaia rau, meke dogoria rau sa rimata meke sa sidara, meke sari ka manege eke pinopino si todoṉo nau rini si rau,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Meke mae tozia tugo sa koasa tamana sa nana pinutagita, meke norea sa tamana si asa, meke zama ia, “Na pinutagita sa sapu gua sana? Balabalaia goi sapu sa tinamu meke sari na tasimu, meke arau si kaqu mae meke todoṉo nigo?” ");
INSERT INTO rug_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Meke konokono nia ri na tasina si asa, ba balabala vekoi mo sa tamana sari doduru ginugua arini. ");
INSERT INTO rug_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Keke rane sipu la pa Sekemi sari na tasina Zosepa pude kopuni sari na rovana sipi tanisa tamadia, gua, ");
INSERT INTO rug_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","si zama la ia Zekopi se Zosepa, “Hiva nigo rau pude la pa Sekemi si goi, vasina sapu korapa kopuni ri na tasimu sari na rovana sipi.” Meke olaṉa se Zosepa, “Leana, maqu la,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Meke zama ia sa tamana si asa, “La, mamu la dogori sari na tasimu be koa valeana si arini, meke gua tugo sari na rovana sipi; mamu pule mae tozi nau.” Gua asa, ke garunu la nia sa tamana, meke taluarae pa Heboroni si asa. Sipu kamo pa Sekemi se Zosepa, ");
INSERT INTO rug_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","si dogoria keke tie si asa, korapa ene vilovilorae nana koasa pezara, ke nanasia sa tie si asa, “Na sa si hata ia goi?” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","“Na korapa hatai rau sari na tasiqu, saripu korapa kopuni sari na dia rovana sipi,” gua si asa. “Vegua, boka tozi nau goi vasina korapa koa si arini?” ");
INSERT INTO rug_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Meke zama sa tie, “Ele taloa tu si arini. Avosia rau sapu pa Dotani si kote la gua si arini,” gua si arini. Ke ene luli la i Zosepa sari na tasina, meke la kamoi sa si arini pa Dotani. ");
INSERT INTO rug_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ba sipu dogoria rini korapa ene mae gua pa seu si asa, meke lopu ele ene kamo mae koa rini, si variva ego golomo nia rini pude va matea gana, gua. ");
INSERT INTO rug_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Meke varivari zamai si arini, “Dotu, korapa maehe sa tie putaputagita,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","“Aria mae mada seke va matea gana kamahire si asa. Mada oki voi nia sa tinina koa keke berukehe popadi hire. Mada zama sapu ele gani va matea keke kurukuru pinomo si asa, gua. Beto asa mada dogoria sapu na sa si kaqu ta evaṉa koa ri nana pinutagita.” ");
INSERT INTO rug_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ba sipu avosia Rubeni sapu gua asa si podekia sa pude harupia se Zosepa, meke zama si asa, “Mada lopu va matea si asa. ");
INSERT INTO rug_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Mada oki voi nia mo pa korapa berukehe pa soloso, mada lopu va bakoraia.” Zama gua si asa, pude harupu pule nia koa rini, meke garunu pule la nia koasa tamana gua. ");
INSERT INTO rug_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Ke sipu kamo koari na tasina se Zosepa, si va gore pania rini sa nana poko gele lima. ");
INSERT INTO rug_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Meke saputu vagia rini si asa, meke oki voi la nia pa korapa berukehe, sapu loke kolona. ");
INSERT INTO rug_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Meke sipu korapa henahena rini, si lopu sana dogoria rini si keke puku tie, saripu mae guadi koasa butubutu te Isimeli saripu ene mae guadi pa Qileadi meke korapa la gua dia pa popoa Izipi. Meke va paleke ni rini koari na kameli sari na oto huda na meresena meke na oela humaṉa lea, na gua. ");
INSERT INTO rug_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Meke zama la koari na tasina se Ziuda, “Loke laena si be seke va matea gita sa tasida, meke tomea sa nana minate. ");
INSERT INTO rug_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Aria, mada holuholu nia gana si asa, koari na tie Isimeli, mada lopu va matea si asa, sina na tasida meke na eharada soti si asa.” Ke va egoa rina tasina si asa. ");
INSERT INTO rug_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Meke sipu tata kamo mae sari na tie holuholu pa butubutu Midiani, si kave vura nia rini pa korapa berukehe popana se Zosepa meke vata holu nia hiokona puta siliva rini koari na tie Isimeli si asa, meke turaṉa la nia rina tie Isimeli si asa pa popoa Izipi. ");
INSERT INTO rug_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Meke sipu la hopiki nia Rubeni sa berukehe popana si lopu dogoria sa se Zosepa, ke daku rikati sa sari nana poko pa tinalotaṉa. ");
INSERT INTO rug_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Meke kekere pule la koari na tasina si asa, meke zama, “Sa koreo si lopu koa, ke sa si kote tavetia rau,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Meke vagia rini si keke qoti kokoreo meke va matea, meke paleke vagia rini sa koti te Zosepa meke poṉa nia pa korapa eharana sa qoti. ");
INSERT INTO rug_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Meke paleke la nia rini sa koti gele lima koasa tamadia, meke zama, “Hie si dogoria gami. Mamu vilitia ko; mamu gilania sapu be tanisa tumu sia babe lokari,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Meke doṉo gilania Zekopi si asa, meke zama, “Uve, tanisa tugo si hie!” gua si asa. “Gina kaiqa kurukuru pinomo na garata va umumia meke gania se Zosepa, sa tuqu koreo,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Meke daku rikati Zekopi sari nana poko pa tinalotaṉa, meke va sagea sa sa poko baika, meke seunae hola koa besu nia sa sa tuna. ");
INSERT INTO rug_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Meke mae sari doduru tuna koreo na vineki, pude va manotia, ba korona tava manoto si asa. Zama si asa, “Kaqu kabo va gore hiteke nia tiniqu pa minate, koasa kasia popoa hie sa tuqu koreo, meke lopu kaqu hite ari makudoqu.” Gua asa ke lopu makudo besu nia sa se Zosepa, sa tuna koreo. ");
INSERT INTO rug_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ego, koasa totoso hie si la holuholu nia ri na tie Midiani si asa koa keke tie pa popoa Izipi, pozana si e Potipa. Asa si keke koa ri na koimata tanisa baṉara pa Izipi, sapu kopuni sari na tie turu varane pa vetu tanisa baṉara tugo si asa. ");
INSERT INTO rug_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Meke pa totoso asa si taluarae koari na tasina se Ziuda meke la koa nana koa keke tie pozana e Hira, sapu mae guana koasa vasileana nomana pa Adulamu. ");
INSERT INTO rug_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Meke vasina si tutuvia sa si keke vineki pa butubutu Kenani, meke sa pozana sa tamana si e Sua. Meke haba ia sa si asa, ");
INSERT INTO rug_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","meke va podo nia sa koasa barikaleqe hie si keke tuna koreo, meke poza nia Era sa si asa. ");
INSERT INTO rug_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Meke va aritiana pulea sa si asa, meke va podo nia sa si keke koreo pule, meke poza nia Onani sa si asa. ");
INSERT INTO rug_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Meke keke tuna koreo pule si podoa sa, meke poza nia Sela sa si asa. Ba koa tu pa Akezibi se Ziuda totoso podoa sa sa tuna koreo. ");
INSERT INTO rug_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Meke vagia e Ziuda si keke barikaleqe meke va haba nia sa koasa tuna koreo kenuna, sapu se Era. Meke sa pozana sa barikaleqe hie si e Tama. ");
INSERT INTO rug_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ba hoke luli hahanana kaleana se Era, sa tuna kenuna e Ziuda, ke lopu toṉoto pa dinoṉo te Zihova si asa, ke va matea Sa. ");
INSERT INTO rug_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Beto asa si zama guahe se Ziuda koe Onani, “La mamu va tata ia sa nabonaboko barikaleqe tanisa tasimu, mamu va gore vura ia sa mua tinavete pude va podo ponia koburu sa tasimu pu ele mate,” gua se Ziuda koasa. ");
INSERT INTO rug_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ba ele gilania Onani sapu lopu kaqu tanisa soti sari na koburu gua, ke koa rina totoso sipu hoke va tata ia sa si asa, si hoke va honi pani sa sari na kolona pa pepeso, pude meke ponia tuna sa tasina, gua. ");
INSERT INTO rug_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Gua asa, ke lopu qetu nia e Zihova sapu gua tavetia sa, ke va matea tugo e Zihova si asa. ");
INSERT INTO rug_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Beto asa si zama la koasa nana roroto sapu se Tama se Ziuda, “Mamu koa pule la pa vetu tanisa tamamu, mamu koa nabonaboko, osolae pana noma sage se Sela, sa tuqu koreo,” zama gua si asa, sina balabala ia sa sapu e Sela ba hokara kote mate gua tugo sari tasina gua. Ke pule la pa vetu tanisa tamana se Tama. ");
INSERT INTO rug_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Meke sipu hola kaiqa vuaheni si mate sa barikaleqe te Ziuda, sapu sa tuna e Sua. Meke sipu beto sa totoso sapu besu nia sa si asa, si ene la pa Timina si asa meke luli koasa sa nana baere sapu se Hira, sa tie pa vasileana Adulamu. Vasina si ta koto sari na sipi te Ziuda. ");
INSERT INTO rug_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Meke sipu tozi nia ri kaiqa tie se Tama, sapu “Ele sage la koto nana sipi pa Timina sa roamu,” gua, ");
INSERT INTO rug_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","si hobei sa sari nana poko nabonaboko, saripu hoke va sagei sa. Meke nobi nia poko sa sa isumatana, meke habotu nana pa sadana sa vasileana Enaimi, koasa siraṉa sapu la gua pa vasileana Timina si asa, sina ele gilana valeania sa sapu ele noma kamahire se Sela, ba lopu hite ta vala si asa koa sa pude haba ia gua. ");
INSERT INTO rug_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Meke sipu dogoria Ziuda si asa, si balabala ia sa sapu keke maqota si asa, gua, sina nobia sa sa isumatana. ");
INSERT INTO rug_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Ke kekere la ia sa pa vale siraṉa si asa, meke zama, “Ka visa kaqu tabara nigo rau?” Ba lopu gilania sa sapu na nana roroto mo si asa. Meke nanasa se Tama, “Na sa si kaqu poni nau goi?” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Meke olaṉa se Ziuda, “Kaqu ponigo rau si keke qoti tunana koasa qua rovana,” gua si asa. Meke zama se Tama, “Ego, leana, ba kaqu veko paki vina sosode si goi koa rau, osolae poni mae nau goi sa qoti,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Meke nanasa se Ziuda, “Na vina sosode sa si kaqu poni nia rau koa goi?” gua si asa. Meke olaṉa se Tama, “Sa mua riṉi vina gilagila soti meke na senina tugo, meke sa mua kolu sapu korapa taṉinia goi,” gua si asa. Beto asa si tiqe va kapae ia sa si asa, meke va aritiana nia sa si asa. ");
INSERT INTO rug_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Beto asa, si pule la pa nana vetu se Tama, meke la hobe nana poko, meke va sage pulei sa sari nana poko nabonaboko. ");
INSERT INTO rug_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Meke garunia Ziuda sa nana baere sapu se Hira pude vagia sa qoti, meke paleke la nia, pude la vagi puleni sari na tiṉitoṉa pu ele veko va sosodeni sa koasa, gua; ba lopu boka dogoria Hira sa barikaleqe. ");
INSERT INTO rug_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Meke nanasi Hira si kaiqa tie pa vasileana Enaimi, “Avei sa maqota sapu habotuna tani pa vale siraṉa visoroihe?” Meke olaṉa sari na tie, “Namu loke maqota si ele hoke mae tani,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Meke pule la koe Ziuda si asa meke zama, “Lopu boka dogoria rau sa barikaleqe, ba zamau rina tie vasina sapu namu na loke maqota si hoke koa vasina.” ");
INSERT INTO rug_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Meke zama se Ziuda, “Leana, mani kopuni mo sa sari na tiṉitoṉa. Na lopu hiva nia gita pude hegereni gita rina tie si gita. Ele podekia rau pude tabaria si asa, ba lopu boka dogoria goi si asa,”, gua se Ziuda. ");
INSERT INTO rug_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Meke sipu hola ka ṉeta sidara, si mae koe Ziuda sari kaiqa tie meke zama, “Sa mua roroto sapu se Tama si va maqomaqotae, meke kamahire si aritiana si asa,” gua si arini. Meke zama se Ziuda, “Mi la vagi vura nia pa vetu si asa, mamu sulu va matea gana,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Meke sipu korapa va namanama vagi vura nia rini si asa, si garunu la zinama si asa koasa roana, sapu se Ziuda, sapu zama guahe, “Ele va aritiana au sa tie sapu tagodi sari na tiṉitoṉa hire: sa riṉi, meke sa senina, meke sa kolu hie. Mamu dogoro viliti sapu tesei tugo sari na tiṉitoṉa arini,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Meke doṉo gilani Ziuda si arini meke zama, “Toṉoto hola nau e Tama, sina lopu tavetia rau sa qua tinavete koasa, pude kaqu vala nia rau koasa sa tuqu koreo sapu se Sela pude haba ia.” Meke lopu eko kapae pulea Ziuda si asa. ");
INSERT INTO rug_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Meke sipu kamo sa nana totoso pude podopodo, si ta gilana sapu na avisi tu si koa pa korapa tiana. ");
INSERT INTO rug_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Meke sipu podopodo si asa, si keke ri karua si va vura ia sa limana, meke tuqe vagia sa barikaleqe va podopodo si asa, meke pusi nia lozi ziṉara sa sa limana, meke zama, “Hiera si asa sapu podo kekenu,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ba va nuquru pulea sa sa limana, meke sapu keke tasina tu si podo kekenu. Meke zama sa barikaleqe va podopodo, “Gua asa, ke tukelia goi sa mua siraṉa meke vura!” Gua asa ke poza nia Perezi sa si asa. ");
INSERT INTO rug_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Beto asa si podo vura mae sa tasina sapu ta pusie lozi ziṉara limana, meke ta pozae Zera si asa. ");
INSERT INTO rug_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Ego vagi la nia ri na tie Isimeli se Zosepa pa popoa Izipi, meke la vata holu nia rini si asa koe Potipa, sapu keke koari na palabatu nomadi tanisa baṉara meke keke koimata tugo koari na tie turu varane saripu kopu nia sa vetu tanisa baṉara. ");
INSERT INTO rug_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Meke koa koe Zosepa se Zihova, meke va bokaia Sa si asa koari doduru nana tinavete, meke pa vetu tugo tanisa nana palabatu pa popoa Izipi si koa si asa. ");
INSERT INTO rug_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Meke dogoro gilania tugo sa nana palabatu, sapu koa koe Zosepa se Zihova, ke va bokaia Sa koari doduru nana tinavete. ");
INSERT INTO rug_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Meke qetu nia e Potipa si asa, meke vata evaṉae nia nana ṉati nabulu soti si asa. Meke va palabatua tugo sa pa nana vetu meke koari doduru nana likakalae saripu tagoi sa. ");
INSERT INTO rug_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Koa gua koe Zosepa pa totoso asa, si manani e Zihova sari doduru tie pa vetu tanisa tie Izipi, meke sari doduru likakalae pu tagoi sa, meke sari nana inuma. ");
INSERT INTO rug_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Ke va karovo beto lani e Potipa sari doduru likakalae pu tagoi sa pa kinopu te Zosepa, meke lopu hite balabala ia sa si keketoṉa, ba na gana ginani mo sapu hena ia sa si hoke balabala ia sa. Na koreo leleana meke vari ṉoṉoi tinina se Zosepa, ");
INSERT INTO rug_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","meke sipu hola sari kaiqa totoso si podalae okokoro nia sa barikaleqe tanisa nana palabatu se Zosepa, meke hoke tepa ia sa si asa pude la eko turaṉia si asa pa teqe, gua. ");
INSERT INTO rug_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ba korona si asa, meke zama la koasa barikaleqe, “Dotu sa qua palabatu si lopu hite balabala pule nia si asa koa keketoṉa pa korapa vetu, sina korapa koa qua si rau tani. Ele veko maeni sa pa qua kinopu sari doduru likakalae saripu tagoi sa. ");
INSERT INTO rug_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Sa ṉiniraṉira sapu tagoa rau si kekeṉoṉo gua sa ṉiniraṉira sapu tagoa sa koa sa vetu hie, meke lopu hite tuqe pulea sa si keketoṉa koa rau, ba kekeke agoi mo si lokari. Na vegua meke kaqu boka tavetia tu rau sa tinavete kaleana hie, meke va sea pa kenuna sa Tamasa?” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Tepa la ia mo sa se Zosepa koari doduru hopeke rane, ba korona la eko turaṉia sa si asa pa nana teqe. ");
INSERT INTO rug_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Ba keke rane, sipu lopu koa pa vetu sari na nabulu koreo tana vetu, si nuquru la pude taveti sari nana tinavete vasina gua se Zosepa, ");
INSERT INTO rug_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","si harupu tuqea sa barikaleqe sa nana poko meke zama, “Tio, mae eko turaṉau pa qua teqe,” gua si asa. Ba va kakalopuhia sa si asa meke haqala vura nana pa sada, meke luara pania sa sa nana poko pa limana sa barikaleqe. ");
INSERT INTO rug_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Meke sipu dogoria sa barikaleqe sapu ele veko pania sa sa nana poko pa limana, meke govete vura nana pa vetu, ");
INSERT INTO rug_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","si tioki sa sari nana nabulu koreo meke zama, “Dotu si hie! Sa tie Hiburu sapu turaṉa mae nia sa qua palabatu si va kurekure gita. Nuquru mae si asa pa qua lose, meke hiva mae ṉaza au gua, ba gagaemana va sisigiti palae si rau. ");
INSERT INTO rug_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Meke sipu gagaemana si rau si haqala vura si asa pa sada meke veko pania sa sa nana poko pa kapaqu rau,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Meke kopu nia sa barikaleqe sa nana poko osolae kamo pule mae sa koimata te Zosepa pa vetu. ");
INSERT INTO rug_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Meke tiqe vivinei nia sa barikaleqe koe Potipa sa vivinei asa, meke zama, “Sa nabulu tie Hiburu sana sapu turaṉa mae nia goi tani, si nuquru mae pa qua lose meke hiva ṉazau sa. ");
INSERT INTO rug_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ba sipu gagaemana si rau, si haqala vura pa sada si asa, meke veko pania sa sa nana poko pa kapaqu,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Meke bugoro sisigiti sa palabatu te Zosepa, ");
INSERT INTO rug_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","meke garuni sa sari kaiqa tie meke la tuqe vagia se Zosepa meke vekoa pa korapa vetu varipusi vasina sapu hoke kopuni rini sari na tie ta pusidi tanisa baṉara. ");
INSERT INTO rug_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ba koa koe Zosepa se Zihova, meke mana nia Sa si asa, ke qetu nia sa tie kopu tie varipusi si asa. ");
INSERT INTO rug_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ke va palabatua sa tie kopu se Zosepa koa ri doduru tie ta pusidi pule, meke va ṉati hiniva ia sa si asa koa ri doduru tiṉitoṉa sapu ta tavete pa korapa vetu varipusi. ");
INSERT INTO rug_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Ke lopu hite tupiti nia sa tie kopu tie varipusi si keketoṉa, sapu koa pa kinopu te Zosepa, sina koa koe Zosepa se Zihova meke va bokaia Sa si asa koari doduru nana tinavete. ");
INSERT INTO rug_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Meke sipu ele hola sari kaiqa rane, si evaṉia sa tie kopu napo vaeni, meke sa ṉati tie kinakina bereti tanisa baṉara pa popoa Izipi si keketoṉa sapu lopu qetu nia sa baṉara. ");
INSERT INTO rug_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Ke bugoroni sa baṉara sari karua ṉati tie hire, ");
INSERT INTO rug_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","meke vata pusi sa baṉara sari karua pa vetu tanisa tie kopu, tie ta pusidi, vasina tugo sapu ta kopue se Zosepa. ");
INSERT INTO rug_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Meke va kopuni sa tie kopu koe Zosepa sari karua tie, pude tokani, meke koa seunae si arini pa vetu varipusi. ");
INSERT INTO rug_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Keke boṉi si hopeke putagita sari karua tie pa korapa vetu varipusi, sa tie tavetavete kolo vaeni, meke sa ṉati tie kinakina bereti tanisa baṉara pa popoa Izipi, meke lopu vari kekeṉoṉoi tugo ginuadi sari na dia pinutagita. ");
INSERT INTO rug_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Meke sipu la dogori Zosepa si arini pana munumunu si doṉo talotaṉa si arini. ");
INSERT INTO rug_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Ke nanasi sa sari karua, “Na vegua ke guana doṉo kuliusu tu si gamu kara ṉinoroi?” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Meke olaṉa sari karua, “Hopeke putagita si gami karua, meke loke tie tani si boka va bakala ponini gami sari mami pinutagita,” gua sari karua. Meke zama se Zosepa, “E Tamasa mo boka tozi va bakali sari na pinutagita. Mi tozi nau sari na mia pinutagita,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Ke zama sa tie tavetavete kolo vaeni, “Koasa qua pinutagita si koa nana si keke huda vaeni sapu koa pa kenuqu. ");
INSERT INTO rug_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Meke ka ṉeta sari na lelaṉana sa huda vaeni asa, sipu liho si asa, si vura mae sari na havorona meke lopu sana sagana sari na vuana. ");
INSERT INTO rug_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Meke taṉinia qua pa limaqu sa kapa tanisa baṉara, meke henai rau sari na vua vaeni meke mono lani rau pa korapa kapa, meke vala nia rau koasa baṉara si asa,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Meke zama se Zosepa, “Hie sa rinupahana sa mua pinutagita: Sari ka ṉeta lelaṉa huda vaeni si sari ka ṉeta rane tugo,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","“Koasa rane vina ṉeta si kaqu vata rupahigo sa baṉara si goi, meke va turu pulego pa mua tinavete. Meke kaqu ade la nia goi pa limana sa nana kapa, gua tugo sapu hoke taveti goi visoroihe, sipu koa na tie tavetavete kolo vaeni tanisa si goi. ");
INSERT INTO rug_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ba mu tataru nau, mamu balabalau, pana koa valeana si goi. Mu toka nau mamu tozi au koasa baṉara, pude va vurau koasa vetu varipusi hie,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","“Ura ele ta holuholue taloa si rau pa popoa tadi na tie Hiburu, meke gua tugo sapu lopu hite tavetia rau si keketoṉa sapu garoqu pude ta veko nia rau pa vetu varipusi tani pa popoa Izipi,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Meke sipu avosia sa ṉati tie kinakina bereti, sapu leana sa rinupahana sa pinutagita tanisa tie tavetavete kolo vaeni si zama la koe Zosepa si asa, “Arau ba putagita tugo, meke kotui rau pa batuqu sari ka ṉeta pili bereti, gua ");
INSERT INTO rug_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Meke koasa pili sapu hake ulue, si koa dia soku votivotiki kinina ginani tanisa baṉara, ba mae sari na kurukuru tapuru meke gani i si arini,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Meke olaṉa se Zosepa, “Hie sa rinupahana sa mua pinutagita asa. Sari ka ṉeta pili si sari ka ṉeta rane tugo. ");
INSERT INTO rug_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Koari ka ṉeta si kaqu vata rupahigo sa baṉara si goi, meke kupa ia ruamu. Beto asa si kote va sigotia sa sa tinimu koa keke dedegere huda, meke kote mae sari na kurukuru tapuru meke gania ri sa tinimu,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ego, koasa rane, pa mudidi ri ka ṉeta rane si tavetia sa baṉara sa nana rane podo, pude tadi doduru nana ṉati palabatu koasa nana binaṉara gua, meke vata rupahia sa sa tie tavetavete kolo vaeni, meke sa ṉati tie kinakina bereti, meke turaṉa lani sa pa kenudia ri nana ṉati palabatu si arini, ");
INSERT INTO rug_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Meke vala pule nia sa baṉara koa sa tie tavetavete kolo vaeni sa nana tinavete koana, pude tavetavete pude kopu kolo vaeni tanisa baṉara, gua. ");
INSERT INTO rug_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Ba huqi va matea sa baṉara sa ṉati tie kinakina bereti, gua puta tugo sapu zama nia Zosepa koasa. ");
INSERT INTO rug_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ba namu muliṉi hola nia tu sa tie tavetave kolo vaeni se Zosepa, meke lopu hite balabala ia sa si asa. ");
INSERT INTO rug_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Meke sipu hola karua vuaheni seunae gua ta pusi se Zosepa, si putagita ia sa baṉara sapu turu nana pa taqele Ovuku Naelo si asa, gua. ");
INSERT INTO rug_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Meke vura mae gedi koasa Ovuku Naelo sari ka zuapa bulumakao nobonobokodi saripu via meke bulebule tinidi, meke gani gedi duduli koasa taqelena sa Ovuku Naelo si arini. ");
INSERT INTO rug_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Beto asa, si ari ka zuapa pule bulumakao peqepeqedi meke tale susuridi si vura mae, meke mae turu tata si arini koa ri kaiqa bulumakao pule pa taqelena sa Ovuku Naelo. ");
INSERT INTO rug_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Meke la rina bulumakao peqepeqedi onolo toa betoi sari na bulumakao nobonobokodi. Beto asa, si tiqe vaṉunu sa baṉara. ");
INSERT INTO rug_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Meke puta pule si asa, meke keke pinutagita pule si putagitaia sa, meke ka zuapa sari na vua huiti si vura mae pa keke ṉatina, saripu leleadi, meke noma valeana. ");
INSERT INTO rug_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Beto asa si vura mae pule sari ka zuapa vua huiti haraharadi saripu ṉovali sa givusu maṉinina sapu mae guana pa korapa soloso qega, ");
INSERT INTO rug_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","meke mae saripu haraharadi meke onolo toa betoi saripu toa valeanadi. Meke vaṉunu sa baṉara meke va nonoga ia sa sapu ele putagita si asa. ");
INSERT INTO rug_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Meke koasa munumunu asa, si kuliusu sisigiti sa baṉara, meke garuni sa si kaiqa tie pude la va maei sari na tie vakuvakutae na tie tumatumaedi pa popoa Izipi, meke tozi sa koa rini sari nana pinutagita, ba namu loke tie si boka va bakali koasa sari nana pinutagita. ");
INSERT INTO rug_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Meke zama la koasa baṉara sa tie tavetavete kolo vaeni, “Maqu helahelae nia koa goi kamahire sa qua sinea sapu ele tavetia rau, ");
INSERT INTO rug_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Visoroihe sipu bugoro sisigiti nia goi sa ṉati tie kinakina bereti meke arau, meke vata pusi gami goi pa vetu tanisa tie kopu tie ta pusidi, ");
INSERT INTO rug_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","meke keke boṉi, si hopeke putagita si gami karua, meke lopu kekeṉoṉo tugo ginuadi sari na mami pinutagita. ");
INSERT INTO rug_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Meke koa somanae nana tugo koa gami kasa si keke tie Hiburu, na tie vaqurana si asa, meke na nabulu tanisa tie kopu tie varipusi tugo si asa. Meke tozi gami karua sari na mami pinutagita koasa. Meke rupaha ponini gami sa ginuadi si rini. ");
INSERT INTO rug_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Meke gua tugo saripu zamani sa si ta evaṉa, va turu pule au goi si rau pa qua tinavete, ba vata huqia goi sa ṉati tie kinakina bereti,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Meke garunu lani sa baṉara koe Zosepa si kaiqa tie, meke sipu ta turaṉa vura mae si asa pa vetu varipusi, meke pa mudina sipu ele neri meke hobei sa sari nana poko, si mae turu pa kenuna sa baṉara si asa. ");
INSERT INTO rug_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Meke zama sa baṉara koasa, “Putagita ia rau si keke pinutagita, meke loke tie si boka tozi va bakala poni nau sa ginuana, meke tozi nau ri kaiqa tie sapu agoi si boka rupahi sari na pinutagita, gua.” ");
INSERT INTO rug_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Meke olaṉa se Zosepa, “Qua baṉara, arau si lopu kaqu boka, ba e Tamasa tu si kaqu rupaha ponigo sapu gua hiva nia goi,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Meke zama sa baṉara, “Putagita ia rau sapu korapa turu si rau pa taqelena sa Ovuku Naelo,. ");
INSERT INTO rug_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Meke vura mae gedi pa korapa ovuku sari ka zuapa bulumakao bulebule tinidi meke nobonobokodi, meke gani gedi duduli pa taqelena sa ovuku si arini. ");
INSERT INTO rug_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Beto asa si ka zuapa bulumakao pule si vura sage mae saripu peqepeqedi meke tale susuridi. Namu lopu toa valeana sari na bulumakao arini koa ri doduru pu hoke dogori rau pa ninae vasina pa popoa Izipi. ");
INSERT INTO rug_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Meke la ri ka zuapa bulumakao peqepeqedi meke gani betoi saripu nobonobokodi. ");
INSERT INTO rug_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ba loke tie gilania, sina doṉo hikare gua tugo visoroi hire si arini. Beto asa si tiqe vaṉunu si rau. ");
INSERT INTO rug_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Meke putagita dogoria pule rau si ka zuapa vua huiti saripu vura mae pa keke ṉatina, meke katakata valeana namudi meke komihadi si arini. ");
INSERT INTO rug_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Beto asa si toqolo vura mae sari ka zuapa huiti, saripu haraharadi, sapu ṉovali na givusu maṉini mae guana pa korapa qega si arini. ");
INSERT INTO rug_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Meke mae sari ka zuapa huiti haraharadi meke onolo toa betoi saripu toa valeanadi. Meke ele tozi rau koa rina tie vakuvakutae sari na pinutagita ba lopu keke arini si boka va bakali koa rau sari na pinutagita arini,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Meke zama la koasa baṉara se Zosepa, “Kekeke mo ginuadi sari karua pinutagita. Ele tozi nigo e Tamasa sapu gua kaqu tavetia Sa. ");
INSERT INTO rug_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Sari ka zuapa bulumakao nobonobokodi si sari ka zuapa vuaheni leadi, meke sari ka zuapa huiti leadi si sari ka zuapa vuaheni leadi tugo, meke kekeṉoṉo mo ginuadi si arini. ");
INSERT INTO rug_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Meke sari ka zuapa bulumakao peqepeqedi saripu sage mumudi mae, meke sari ka zuapa huiti haraharadi, saripu ṉovali na givusu mae guana pa korapa qega, si sari ka zuapa vuaheni soṉe. ");
INSERT INTO rug_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Gua puta tugo asa sapu ele tozi nigo rau. Ele va dogoro nigo e Tamasa sapu gua kaqu tavetia Sa. ");
INSERT INTO rug_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Koari ka zuapa vuaheni si kaqu toa valeana sari doduru linetelete pa doduruna sa popoa Izipi. ");
INSERT INTO rug_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Meke pana hola sari ka zuapa vuaheni sara, si kaqu hobe mae sari ka zuapa vuaheni soṉe, meke lopu kaqu ta balabalae sari doduru vuaheni leadi, ura kote ta ṉovala beto koasa soṉe sa popoa. ");
INSERT INTO rug_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Meke sa totoso sipu toa valeana sari na linetelete si lopu kaqu ta balabalae, sina sa soṉe sapu luli mudi mae si kaqu kaleana sisigiti. ");
INSERT INTO rug_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Sa zinama pilipule te Tamasa koasa pinutagita ginuana, si ele tava toṉoto koe Tamasa si asa, meke kote evaṉia Sa si asa koari na rane mae hiroi. ");
INSERT INTO rug_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Ego, kamahire kaqu vizati goi kaiqa tie gilae, tumatumae, meke lohi dia binalabala, mamu va ṉati hiniva i pa popoa Izipi. ");
INSERT INTO rug_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Beto asa si kaqu vizati tugo goi si kaiqa palabatu, pude vagi sari na ginani padana, keke pa hopeke lima koari ka zuapa vuaheni, sipu toa valeana sari doduru linetelete. ");
INSERT INTO rug_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Kaqu garuni goi si arini pude vagi sari na ginani koari na vuaheni leadi saripu korapa mae. Meke kaqu poni ṉiniraṉira goi si arini, pude varigarani rini koari na vasivasileana nomadi, meke kaqu kopuni rini si arini. ");
INSERT INTO rug_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Sari na ginani arini saripu kaqu tava nama veko, si pude kaqu ta vala koa ri na tie koari ka zuapa vuaheni sipu kaqu ta evaṉa sa soṉe pa popoa Izipi meke pa siraṉa gua asa si lopu kaqu agoso mate beto sari na tie pa popoa Izipi,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Meke variva ego nia sa baṉara, meke sari nana palabatu koasa nana qinavuna sa palani asa. ");
INSERT INTO rug_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Meke zama sa baṉara koa rini, “Namu lopu kaqu boka vagia gita si keke tie leana hola, sapu kekeṉoṉo gua e Zosepa, keke tie sapu koa ia sa maqomaqona e Tamasa pa korapa nana tinoa,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Meke zama sa baṉara koe Zosepa, “Ele va dogoro nigo Tamasa sari doduru pu gua hire, ke ta dogoro va bakala, sapu agoi mo si koa igo na ginilae nomana hola, meke na tinumatumae lohina, sapu loke tie pule tagoa. ");
INSERT INTO rug_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ke kaqu va ṉati hiniva igo rau pa qua popoa, meke sari doduru tie si kaqu va tabe igo meke kaqu vina rua si agoi koa sa qua ṉiniraṉira. ");
INSERT INTO rug_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Ego, kamahire si vizatigo rau, pude qavuna koari doduru tinoni pa popoa Izipi,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Meke va gorea sa sa riṉi pa kakarutuna sapu koa ia na kinubekubere tana binaṉara korapana, meke va sage nia sa pa kakarutuna e Zosepa. Meke va sage nia poko lineni arilaena sa si asa, meke va paku nia seni qolo sa ruana si asa. ");
INSERT INTO rug_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Meke vala nia sa koe Zosepa sa totopili vina rua tana binaṉara pude suraṉia, meke sari nana tie varipera si ene va kenue koasa. Meke velavela si arini, “Mi kokotuṉu nia si asa,” gua. Gua asa ke ta vizata se Zosepa pude na qavuna pa popoa Izipi. ");
INSERT INTO rug_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Meke zama la koe Zosepa sa baṉara, “Arau sa baṉara sapu zama atu koa goi. Namu loke tie pa doduruna sa popoa Izipi si kaqu ovulia sa limana babe nenena be guana lopu va egoa goi si asa,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","46","Meke poza nia pozapoza Izipi sa baṉara se Zosepa sapu se Zapenati Panea, meke vala nia sa koasa si keke barikaleqe sapu se Asenati, sa tuna vineki e Potipera, sa hiama koasa vasileana lavata pa popoa Heliopolisi. Meke ka toloṉavulu puta vuahenina se Zosepa, sipu podalae nabulu nia sa sa baṉara pa popoa Izipi. Meke hoke luara vekoa sa sa vetu tanisa baṉara meke ene la i sa sari doduru vasina pa popoa Izipi. ");
INSERT INTO rug_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Meke koari ka zuapa vuaheni leadi sipu masuru sa pepeso, si vua va soku sari doduru linetelete pa popoa Izipi. ");
INSERT INTO rug_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Meke veko varigarani meke kopuni koari na vasivasileana nomadi e Zosepa sari na ginani pu mae guadi koari na inuma pa vari likohaena sa popoa. ");
INSERT INTO rug_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Meke hola sisigiti sa ginani, ke noso se Zosepa meke lopu padapada pule ginani si asa. Meke soku guana onone keoro pa masamasa kolo sari na ginani. ");
INSERT INTO rug_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Meke sipu lopu ele kamo mae sari na vuaheni soṉe, si podoi e Asenati sari karua tudia koreo ri karua Zosepa. ");
INSERT INTO rug_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Meke zama se Zosepa, “Ele lopu va balabala nau sa Tamasa sari doduru qua tinasigiti, meke sari doduru tatamana tanisa tamaqu,” gua asa ke poza nia Manase sa sa tuna koreo kenuna. ");
INSERT INTO rug_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Meke zama pule tugo se Zosepa, “Ele poni nau koburu e Tamasa koasa popoa tinasuna si rau,” gua ke poza nia Iparemi sa sa tuna koreo vina rua. ");
INSERT INTO rug_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Meke sipu beto sari ka zuapa vuaheni saripu qetuni rina tie pa popoa Izipi, ");
INSERT INTO rug_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","si podalae sari ka zuapa vuaheni soṉe, gua puta tugo sapu ele zama nia e Zosepa. Meke kamoi soṉe sari doduru popoa, ba sa ginani si koa pa doduruna sa popoa Izipi. ");
INSERT INTO rug_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Meke sipu podalae ovia sari doduru tinoni pa popoa Izipi, si la tepa ginani si arini koasa baṉara, ke garunu lani sa baṉara si arini koe Zosepa, pude tavetia sapu gua kaqu tozia e Zosepa koa rini. ");
INSERT INTO rug_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Meke ṉiṉira va kaleana meke la gua koasa doduruna sa popoa sa soṉe, ke tukeli e Zosepa sari doduru vetu ginani, meke holuholuni sa koa ri na tinoni pa popoa Izipi sari na ginani. ");
INSERT INTO rug_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Meke sari doduru tie pa ninae popoa si mae koe Zosepa pa popoa Izipi, pude holu ginani, sina kaleana sisigiti sa soṉe pa ninae popoa. ");
INSERT INTO rug_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Meke sipu gilania Zekopi sapu koa nana sa ginani pa popoa Izipi, si zamai sa sari na tuna, “Na vegua ke lopu boka tavetia gamu si keke toṉa?” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","“Avoso nia rau sapu koa nana sa ginani pa popoa Izipi; mi la mamu holu ginani vasina, pude lopu kaqu ovia agoso mate si gita,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ke topue la pa popoa Izipi sari ka manege puta tasina karokarovo e Zosepa, pude la holu ginani gua. ");
INSERT INTO rug_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ba lopu garunu va lulia e Zekopi koa rini se Benisimane, sa tasina soti Zosepa, sina mala nia sa sapu, meke gua, meke tutuvu tinasuna si asa, gua. ");
INSERT INTO rug_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Meke somana luli tugo koari na tuna e Zekopi sari kaiqa tie pule, pude holu gedi ginani gua, sina kamoa tugo na soṉe sa popoa Kenani. ");
INSERT INTO rug_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Ego, se Zosepa hie si na qavuna si asa pa popoa Izipi. Meke asa tugo si holuholuni sari na ginani koari doduru tie pa ninae popoa. Ke mae sari na tasina e Zosepa meke kokotuṉu gore pa pepeso pa kenuna sa. ");
INSERT INTO rug_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Meke sipu dogori Zosepa sari na tasina si gilani sa si arini, ba evaṉa gunini sa na votiki tie si arini pude guana lopu gilani sa, gua. Meke nanasa hidahidaka la i sa si arini, “Pavei mae gua mia si gamu?” gua si asa. Meke olaṉa si arini, “Na mae gua mami pa Kenani pude holu gemami ginani, gua,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Gilani nana mo e Zosepa sapu na tasina si arini, ba arini si lopu gilania si asa. ");
INSERT INTO rug_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Meke balabala pulei Zosepa sari nana pinutagita, saripu putagita i sa si arini. Ke zamai sa si arini, “Na mae piko si gamu, na hiva mae hata vura nia gamu sa minalohoro tanisa mami popoa,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Meke olaṉa sarini, “Baṉara, mua nabulu mo si gami na mae pude holu gemami ginani gua. ");
INSERT INTO rug_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Na tamatasi mo si gami doduru, meke lopu na tie piko na tie sekesekei na kokoha.” ");
INSERT INTO rug_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Ba zama la koa rini se Zosepa, “Lokari! Sapu mae nia gamu si pude hata ia sa vasina sapu malohoro sa mami popoa,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Meke zama si arini, “Baṉara, gami ka manege rua tamatasi si gami doduru, meke na tuna keke tie pa popoa Kenani si gami. Ba keke tasimami si ele mate, meke sapu mudina hokara si korapa koa nana koasa tamamami ṉinoroi,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Meke olaṉa se Zosepa, “Gua tugo sapu ele zama nia rau, sapu na tie piko tugo si gamu. ");
INSERT INTO rug_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ego, guahe si kaqu tavetia rau pude va sosode gamu. Pa pozana sa baṉara pa Izipi si zama tokotokoro si rau, sapu namu lopu kaqu taluarae si gamu, osolae kaqu ta turaṉa mae si asa. ");
INSERT INTO rug_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Meke keke koa gamu si kaqu la turaṉa mae nia si asa, meke gamu pu koa hola si kaqu ta kopue pa vetu varipusi tani, osolae tava sosode valeana sapu hinokara sa zinama sapu zama nia gamu. Babe kokohamia si gamu pa pozana sa baṉara, si na tie piko tugo si gamu,” gua se Zosepa. ");
INSERT INTO rug_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Beto asa, si vekoi sa pa korapa vetu varipusi si arini ka ṉeta rane. ");
INSERT INTO rug_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Meke koasa vina ṉeta rane si zama se Zosepa koa rini, “Arau si keke tie sapu va hinokaria sa Tamasa, meke kote boka harupi rau sari na mia tinoa pa keke ginugua. ");
INSERT INTO rug_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Pude va sosodea sapu hinokara si gamu, si keke koa gamu si kaqu koa pa vetu varipusi, vasina tugo sapu ele ta kopue si gamu, meke gamu saripu koa hola si kaqu paleke pule lani koa ri na mia tamatina, saripu korapa koa agoso mate pa inovia, sari na ginani saripu ele holui gamu. ");
INSERT INTO rug_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Beto asa si mamu turaṉa mae nia sa tasimia mudina koa rau, pude boka va sosodea sapu gua ele zama nia gamu si hinokara, meke lopu kaqu va mate gamu rau si gamu,” gua si asa. Meke va egoa rini si asa. ");
INSERT INTO rug_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Meke vari zamai si arini, “Hinokara, kamahire si ta sigiti nia gita sa ginugua sapu ele tavete la nia gita koasa tasida, meke ele dogoria gita sa tinasuna nomana sapu ta evaṉa koasa, meke tepa ia sa sa tinokae, ba koroda avosia gita si asa. Gua asa ke ta gorei nia gita sa tinasuna hie kamahire,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ke zama se Rubeni, “Ele tozini gamu tu rau pude lopu va sigitia sa koreo ba koromia avosau gamu. Ke kamahire si vagia gita sa hinobena sa nana minate,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Ele gilani nana tu e Zosepa sapu gua zamani rini ba lopu gilania rini si asa, sina keke tie tu va karokarovo poni zinama si arini. ");
INSERT INTO rug_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Meke taluarae se Zosepa meke podalae kabo, meke sipu boka zama pule si asa si pule mae, meke vizata vagia sa se Simione, meke vata pusia sa si asa pa kenudia rini. ");
INSERT INTO rug_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Meke tozini Zosepa sari na nabulu pude va siṉini ginani sari na dia baika, meke veko vala pulei pa korapa hopeke baika sari na dia poata, meke poni vinabeo pude tanisa inene pule. Ke tavete betoi tugo rini saripu gua asa. ");
INSERT INTO rug_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ke va suraṉi ri na tamatasi sari na ginani saripu holui rini koari na dia doṉ'ki, meke topue taloa si arini. ");
INSERT INTO rug_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Meke sipu noso rini pa keke vasina meke puta pana boṉi, si keke koari kasa si tukelia sa nana baika ginani, pude ponia sa nana doṉ'ki gua, si dogoria sa sa nana poata pa korapana sa batuna sa nana baika. ");
INSERT INTO rug_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","“Kara, sa qua poata si pule mae nana tu he koa rau,” zama gua si asa koari na tasina. “Hiera koa nana pa korapa qua baika!” Meke matagutu na ta duaṉa si arini, meke koasa dia minatagutu si varinanasi si arini. “Na sa si tavetia Tamasa koa gita,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Meke sipu kamo si arini pa Kenani koasa tamadia sapu se Zekopi, si tozi rini koasa sari doduru gua pu ta evaṉa koa rini. ");
INSERT INTO rug_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Zama si arini, “Namu lopu hite zama hitehiteni gami sa qavuna pa popoa Izipi si gami, meke zutuni gami sa sapu na piko nia mo gami sa nana popoa, gua. ");
INSERT INTO rug_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ba olaṉa la ia gami si asa, ‘Lopu na tie piko meke lopu na tie sekesekei na kokoha si gami. ");
INSERT INTO rug_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Gami ka manege rua tamatasi mo si gami, meke keke mo sa tamamami, ba keke gami kasa tamatasi si ele mate, meke sapu mudina hokara si korapa koa nana koasa tamamami pa Kenani,’ gunia gami. ");
INSERT INTO rug_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Meke olaṉa gami sa tie, ‘Guahe si kaqu tavetia rau pude maqu gilania sapu be lopu na tie sekesekei na kokoha si gamu. Keke koa gamu kasa hire si kaqu koa koa rau, meke saripu koa hola si kaqu taluarae, mamu paleke ginani la koari na mia tamatina pu korapa agoso mate pa inovia. ");
INSERT INTO rug_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ego, kaqu turaṉa mae nia gamu koa rau sa tasimia mudina. Beto asa si kaqu tiqe gilania rau sapu lopu na tie piko, ba na tie hinokara na ṉoṉo mia si gamu, meke kaqu va pule atua rau sa tasimia koa gamu, meke boka koa tani si gamu meke holuholu mia,’ gua,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Beto asa, si titisini rini sari na dia baika, meke dogori rini sari doduru dia kuru poata, meke sipu dogoro betoi rini sari na dia poata, si matagutu beto si arini meke sa tamadia sapu se Zekopi. ");
INSERT INTO rug_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Meke zama la koa rini sa tamadia, “Vegua, hiva nia gamu si pude lopu dogori rau sari doduru qua koburu? E Zosepa si ele taloa, e Simione pule si ele taloa. Ego, kamahire si hiva vagi va seu ia gamu se Benisimane, meke arau mo va razai sari na tinasigiti,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Meke zama ia Rubeni sa tamana, “Be lopu turaṉa pule mae nia rau koa goi se Benisimane, si boka va matei mo goi sari karua tuqu koreo. Ke mamu vekoa koa rau sa kinopuna, osolae kaqu turaṉa pule mae nia rau koa goi si asa,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ba olaṉa se Zekopi, “Namu lopu kaqu boka va lulia rau koa gamu sa tuqu, ura ele mate sa tasina, meke asa mo telena si koa hola. Meke gua meke tutuvu tinasuna pule si asa pa siraṉa. Na barogoso si rau kamahire, meke sa tinalotaṉa sapu poni nau gamu, si kote va mateau si rau,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Meke kaleana hola sa soṉe pa popoa Kenani, ");
INSERT INTO rug_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","meke sipu ele hena betoi rina tatamana te Zekopi sari na ginani pu vagi maeni rini pa popoa Izipi, si zama la koari na tuna se Zekopi, “Mi pule la pa popoa Izipi, mamu la holu pule kaiqa ginani tadi gita,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ba zama se Ziuda, “Sa palabatu pa popoa sana si ele va balau zoṉazoṉa gami, sapu lopu tava malumu si gami pude pule la koa sa, osolae luli sa tasimami koa gami, lopu kaqu ta hivae si gami pude dogoria si asa, gua. ");
INSERT INTO rug_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Be va malumu lulia goi sa tasimami koa gami, si kote la holu ginani tamugoi si gami. ");
INSERT INTO rug_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ba be lopu va malumu lulia goi si asa, si lopu kaqu la si gami, sina ele tozini gami tu sa palabatuna sa popoa, sapu lopu kaqu tava malumu si gami pude dogoria si asa, osolae luli sa tasimami koa gami,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Meke zama se Zekopi, “Na vegua ke poniau tinasuna gamu, meke tozi nia sa palabatu sapu koa nana si keke tasimia,” gua. ");
INSERT INTO rug_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Meke olaṉa si arini, “Ura lopu makudo nanasani gami sa tie meke sari na mami tatamana, meke nanasa nia tugo sa sa tamamami, sapu korapa toa sia ba vegua? Meke vegua, korapa koa nana keke tasimia koreo? gua. Ke kaqu olaṉi tugo gami sari nana ninanasa. Lopu kaqu boka gilania gami sa nana hiniva, be lopu turaṉa la nia gami koasa sa tasimami,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Meke zama la koa sa tamana se Ziuda, “Va lulia sa koreo koa rau, pude topue keke gua si gami, meke lopu kaqu agoso mate pa inovia si gita. ");
INSERT INTO rug_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Kaqu zama tokotokoro nia rau sa qua tinoa soti, meke koa rau kaqu va gore mae nia goi si asa. Meke be lopu turaṉa pule mae nia rau koa goi si asa si kaqu koa koa rau mo sa tinazutuna doduru totoso. ");
INSERT INTO rug_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Be lopu va sasanae si gami si be ele vina rua totoso tu la vasina si gami meke pule mae kamahire,” gua. ");
INSERT INTO rug_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ke zama la koa rini sa tamadia, “Ego, be gua asa sa ginugua, si mi tavete guahe: Mi henai sari na likakalae saripu leadi hola pa nada popoa hie, mamu voi i pa korapa mia baika, pude na mia vinariponi koasa qavuna, guana, oto huda, na zipale, meke na oela humaṉa lea, meke na ginani humaṉa lea sapu hoke heni nia pa supu, meke na pisitakio sapu koa ia namuna guana okete, meke sari na vua olomodi. ");
INSERT INTO rug_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Mi tomoi tugo sari na mia poata saripu kaqu paleki gamu, ura kaqu paleke pule lani gamu sari na poata saripu va hake uluei rini koa rina mia baika. Na hokara tavete va sea hola mo si arini. ");
INSERT INTO rug_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Mamu turaṉia sa tasimia, mamu tuture pule mae. ");
INSERT INTO rug_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Mani toka nia sa Tamasa pu tagoi sari doduru ṉiniraṉira sa tie, pude mani tataruni gamu, meke va pule mae ia se Benisimane, meke sa keke tasimia pule. Ba sapu arau, si be va muliuṉi rau sari na tuqu, si kaqu va muliuṉi tugo rau si arini,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ke vagi ri na tamatasi sari na vinariponi, meke sari na poata sokudi saripu tomo rua meke topue si arini turaṉia rini se Benisimane meke la pa popoa Izipi. Meke la tutuvia rini se Zosepa vasina. ");
INSERT INTO rug_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Meke sipu dogoria Zosepa se Benisimane sapu turaṉia rini si zama la koasa nana nabulu kopu vetu si asa, “Mu turaṉa lani pa qua vetu sari na tie hire sina hivani rau pude mae henahena pa qua vetu kohite korapa rane si arini, ke la mamu va matea si keke kurukuru, mamu va namaia,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Meke tavete betoi sa nabulu saripu ta garununi sa, meke turaṉa lani sa pa vetu te Zosepa sari kasa tamatasi. ");
INSERT INTO rug_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Meke sipu ta turaṉa va kamo la si arini pa vetu, si matagutu meke balabala guahe si arini, “Koa gua mo koari na poata saripu tavapule koari nada baika pa totoso kekenu si ta turaṉa mae nia gita tani. Meke kote raza gita rini, meke vagi sari nada doṉ'ki, meke vata evaṉaeni gita nana nabulu mo sa si gita,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Meke sipu kamo rini pa sasadana sa vetu, si zama la koasa nabulu kopu vetu si arini. ");
INSERT INTO rug_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Ke Baṉara, ele mae tu si gami tani keke totoso visoroi hire meke holu ginani. ");
INSERT INTO rug_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Meke sipu korapa pule la pa mami popoa gua, si noso paki si gami pa siraṉa, meke tukeli gami sari mami baika, meke hopeke gami si dogori sari mami poata sapu hake ulue dia pa korapa hopeke mami baika, namu koa beto dia sari doduru. Meke kamahire si paleke pule maeni gami koa goi si arini. ");
INSERT INTO rug_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Kaiqa poata pule si paleke maeni gami, pude holu va soku ginani. Ba lopu gilania gami sapu esei si veko pule lani koari hopeke mami baika sari na mami poata,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Meke zama sa nabulu, “Mu lopu talotaṉa, na balabala mamata si gamu. Sa mia Tamasa, sapu sa Tamasa tanisa tamamia, si gina ele vekoi pa korapa hopeke mia baika sari na mia poata. Ba arau ele vagi mo sari na hinoludi,” gua si asa. Beto meke turaṉa la nia sa koa rini se Simione. ");
INSERT INTO rug_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Meke turaṉa nuquruni sa nabulu pa korapa vetu sari kasa tamatasi, meke poni kolo sa, pude daloi sari na nenedi, meke poni ginani tugo sa sari na dia doṉ'ki. ");
INSERT INTO rug_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Meke va namanama i rini sari na dia vinariponi pude valani koe Zosepa, sipu kamo si asa pana korapa rane, ba sina ele ta tozi nia tu rini sapu kote henahena turaṉia rini si asa, gua. ");
INSERT INTO rug_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Meke sipu kamo pa nana vetu se Zosepa, si paleke nuquru lani rini koasa sari na vinariponi, meke kokotuṉu gore pa pepeso pa kenuna sa si arini. ");
INSERT INTO rug_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Meke nanasani e Zosepa koa rini sari na dia tinoa sapu vegua si arini meke nanasa pule, “Vegua sa tamamia barogoso sapu vivinei nia gamu koa rau? Korapa toa valeana si asa?” ");
INSERT INTO rug_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Meke olaṉa si arini, “Sa mua nabulu ta pamaṉaena, sapu sa tamamami si korapa toa valeana nana,” gua si arini, meke kokotuṉu pa kenuna sa si arini. ");
INSERT INTO rug_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Meke sipu dogoria Zosepa sa tasina sapu se Benisimane, si zama si asa, “Hiera sa tasimia mudina sapu ele tozi nau gamu. Tuqu, mani mana nigo sa Tamasa,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Beto asa, si hinoqa taluarae se Zosepa koa rini, sina tataru hola nia sa bulona sa tasina, meke tata kabo vura mo si asa, ke nuquru la si asa pa korapa nana lose meke kabo. ");
INSERT INTO rug_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Meke sipu beto daloa sa sa isumatana, si vura mae si asa, meke podeke sisigitia sa pude lopu kabo, meke zamai sa si arini pude va hihia i sari na ginani koa rini. ");
INSERT INTO rug_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Ba se Zosepa si henahena koa keke tevolo meke sari kasa tasina si henahena koa keke tevolo votikaena. Meke sari na tie Izipi saripu henahena vasina si ta poni vata kale tugo koa keke tevolo, na lopu boka henahena turaṉae koa ri na tie Hiburu si arini, ura na hopena pa hahanana tadirini si pude gua asa. ");
INSERT INTO rug_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Meke sari na dia hinabotu si tava toṉoto beto koasa tevolo, pa kenuna sa tevolo te Benisimane, si podalae koasa kenuna meke kamo koasa sapu mudina hokara, meke magasa hola si arini. ");
INSERT INTO rug_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Meke tava hia la koa rini sari na ginani koasa tevolo te Zosepa, meke sa vinahia ginani la koasa tevolo te Benisimane si ka lima totoso holani saripu tadirini. Meke henahena na napo turaṉia rini se Zosepa, meke qetuqetu hola si arini. ");
INSERT INTO rug_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Meke garunia e Zosepa sa nana nabulu kopu pa korapa nana vetu, pude “Va siṉini soku ginani sari na baika tadi kasa sara, pada dia sapu boka paleki rini. Mamu va hake ulue pule lani koari hopeke dia baika sari hopeke dia poata. ");
INSERT INTO rug_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Mamu va hake ulue la nia pa korapa baika ginani tanisa koreo mudina hokara sa qua kapa siliva. Mamu veko turaṉae la nia tugo sa poata hinoludi ri na ginani.” Ke tavete betoi tugo sa sapu gua ta garunu nia sa koasa. ");
INSERT INTO rug_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Ke pana munumunu hokara si va garunu taloa ni sa si arini, koari na dia doṉ'ki, meke taluarae si arini. ");
INSERT INTO rug_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Meke sipu lopu ele taloa va seu si arini koasa vasileana lavata si zama la se Zosepa koasa nana nabulu kopu vetu, “Mu tuture haqala luli la i sari na tie hiroi. Pana kamoi goi si arini, si mamu nanasi, ‘Na vegua ke hobe nia tinavete kaleana tu gamu sa tinavete leana? ");
INSERT INTO rug_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Na vegua ke hikoa tu gamu sa kapa siliva tanisa qua baṉara? Ura asa sa kapa sapu hoke napo nia sa, meke asa tugo si hoke tavetavete nia sa koasa nana tinavete dogodogorae. Namu kaleana sisigiti sapu tavetia gamu!’ mamu guni.” ");
INSERT INTO rug_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Meke sipu kamoi sa nabulu si arini, si zama puleni tugo sa nabulu koa rini sari na zinama arini. ");
INSERT INTO rug_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Meke olaṉa la ia ri kasa tamatasi si asa, “Baṉara na vegua ke zama gua tu asa si goi. Gami si namu lopu hite tavete gua asa. ");
INSERT INTO rug_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Nake gilani mua, sapu ele paleke pule mae guni gami pa popoa Kenani sari na poata, saripu dogori gami hake uluedi pa korapa hopeke mami baika koa goi. Na vegua ke kaqu hikoi tu gami sari na siliva na qolo pa vetu tanisa mua baṉara? ");
INSERT INTO rug_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Baṉara be keke koa gami si ta poho sapu vagia si asa, si mani tava mate si asa, meke gami doduru sapu koa hola, si kaqu ta evaṉae mua nabulu mo”, gua si arini. ");
INSERT INTO rug_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Meke zama sa nabulu, “Hinokara mia, ba keke mo koa gamu sapu ele vagia sa kapa, si kaqu ta evaṉae na qua pinausu, meke sapu gamu doduru pu koa hola si boka taloa,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ke tuturei va gorei rini pa pepeso sari na dia baika ginani, meke hopehopeke tukeli rini si arini. ");
INSERT INTO rug_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Meke viliti va hiteki sa nabulu te Zosepa si arini, podalae koa sa sapu kenuna meke beto koa sa sapu mudina, meke ta dogoro sa kapa pa korapa baika te Benisimane. ");
INSERT INTO rug_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Meke daku rikati ri kasa tamatasi sari na dia poko pa tinalotaṉa, meke va suraṉa pulei rini sari na baika koari na dia doṉ'ki, meke kekere pule la si arini koasa vasileana lavata. ");
INSERT INTO rug_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Meke sipu la kamo pa vetu te Zosepa se Ziuda meke sari na tasina, si korapa koa nana vasina si asa, meke la kokotuṉu gore pa kenuna sa si arini. ");
INSERT INTO rug_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Meke zama la koa rini se Zosepa, “Na sa sapu ele tavetia gamu? Lopu gilania tu gamu sa tie sapu kekeṉoṉo gua arau, sapu boka dogori sari na tiṉitoṉa tomedi?” ");
INSERT INTO rug_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","“Baṉara, na sa si boka zama nia gami koa goi?” Olaṉa gua se Ziuda, “Vegua meke kaqu boka varitokei si gita? Meke vegua meke kaqu boka rupaha puleni gami si gami? Ura va vurai Tamasa sari na mami sinea. Ke kamahire si na mua nabulu mo si gami doduru, meke lopu asa mo telena sapu ta dogoro sa kapa koa sa,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Ba zama se Zosepa, “Ai, lokari! Namu lopu kaqu tavetia rau sapu gua asa! Asa mo telena sapu ta poho nia sa kapa si kaqu ta evaṉae na qua nabulu. Ba sapu gamu doduru pu koa hola si kaqu pule valeana beto lamo koasa tamamia,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Meke ene tata sage la koe Zosepa se Ziuda meke zama, “Ke baṉara, va malumau, maqu va bakalia koa goi. Ba meke bugoro nau, ura na kekeṉoṉo gua puta tugo sa baṉara si goi. ");
INSERT INTO rug_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Ke baṉara, ele nanasa guahe si goi koa gami, ‘Vegua, koa nana sa tamamia, babe keke tasimia?’ gua. ");
INSERT INTO rug_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Meke olaṉa atugo gami, ‘Uve, koa nana sa tamamami sapu barogoso, meke sa tasimami mudina hokara, sapu podo pa nana binarogoso, ba sa tasina sa koreo mudina hie si ele mate tu, meke telena eke mo sapu podo pa keke tinadia soti si koa hola, gua asa ke tataru hola nia sa tamana si asa.’ ");
INSERT INTO rug_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Meke ele tozini gami goi si gami, pude turaṉa mae nia tani si asa, ");
INSERT INTO rug_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Meke olaṉigo gami, sapu lopu kaqu boka luaria sa koreo sa tamana, ba be luaria sa si asa, si kote mate mo sa tamana, gua. ");
INSERT INTO rug_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Meke zama si goi, ‘Namu lopu kaqu tava malumu si gamu pude pule mae koa rau tani, osolae luli mae koa gamu sa tasimia mudina,’ gua. ");
INSERT INTO rug_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Meke sipu pule la koasa tamamami si gami, si tozi betoni gami koasa sapu gua ele zamani goi. ");
INSERT INTO rug_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Meke sipu tozi puleni gami sa pude pule mae holu vasi ginani, gua, ");
INSERT INTO rug_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","si olaṉa la ia gami si asa, ‘Lopu kaqu boka tava malumu si gami pude la koasa tie, osolae luli koa gami sa tasimami mudina meke boka la si gami,’ gua. ");
INSERT INTO rug_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Meke zama mae koa gami sa tamamami, ‘Ele gilania mia gamu, sapu karurua mo sari na koreo pu va podoni rau koe Reseli sapu sa qua barikaleqe. ");
INSERT INTO rug_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Meke keke koari karua si ele luara pani au, meke rovea rau sapu gina ele ta garata va umumu koari na kurukuru pinomo, sina lopu boka dogoro pulea rau, seunae gua taluarae si asa. ");
INSERT INTO rug_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ego, be vagi taloa nia gamu si hie kamahire koa rau, meke be ta evaṉa si kaiqa toṉa koasa, meke sa tinalotaṉa sapu tavete mae nia gamu koa rau, si kote va mate au mo koasa qua binarogoso?’ gua si asa.” ");
INSERT INTO rug_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Ba lopu makudo se Ziuda meke zama, “Baṉara, be lopu koa sa koreo hie meke pule la koasa tamaqu si rau, meke be dogoria sa sapu lopu luli koa rau sa koreo, si namu kote mate mo si asa, sina sa tinina sa koreo hie si guana tinina soti mo, meke ele barogoso hola tugo si asa meke sa tinalotaṉa sapu kaqu vata evaṉia gita koasa, si kote va matea si asa. ");
INSERT INTO rug_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Meke gua pule he, ele va tatara nia rau sa qua tinoa, koasa guguana sa koreo hie koasa tamaqu. Ele tozi nia rau sapu be lopu turaṉa pule nia rau si asa koasa tamaqu, si kaqu ta zutu nia rau sa sinea ninae rane. ");
INSERT INTO rug_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Ego, baṉara, kamahire si kaqu koa si rau tani, pude na mua pinausu koasa hinobena sa koreo hie, ba sa koreo hie si mani luli pule la koari na tasina. ");
INSERT INTO rug_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ve kote gua meke kaqu boka pule la koasa tamaqu si rau, be lopu luli koa rau sa koreo? Namu lopu hiva dogoria rau sa tinasuna sapu kaqu ta evaṉa koasa tamaqu,” gua se Ziuda. ");
INSERT INTO rug_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Lopu boka tuqe pule nia se Zosepa pa kenudia ri nana nabulu, ke garuni sa sari doduru pude vura taloa koasa lose, meke loke tie hokara si koa koasa ba sari na tasina, sipu tozini sa sari na tasina sapu asa mo se Zosepa, gua. ");
INSERT INTO rug_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Meke kabo va ululae sisigiti si asa, meke avosia ri na tinoni pa popoa Izipi, meke kamo la tu pa vetu tanisa baṉara sa inavoso asa. ");
INSERT INTO rug_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Meke zama la koa ri na tasina se Zosepa, “Arau mo se Zosepa. Vegua, sa tamaqu, korapa toa valeana?” Ba sipu avosia rina tasina sapu gua asa, si matagutu sisigiti si arini, meke lopu boka zama hobea rini si asa. ");
INSERT INTO rug_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Ke zama la koa rini se Zosepa, “Mi tata mae koa rau.” Meke rizu tata la koasa si arini, meke zama si asa, “Arau mo se Zosepa sa tasimia, sapu ele vata holu nia gamu pa popoa Izipi. ");
INSERT INTO rug_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ego, mu lopu talotaṉa na vari zutui puleni gamu kamahire, sapu ele vata holu nau gamu tani. Ura e Tamasa tu ele garunu va kenue mae nau tani, pude harupi sari na tinoa tadi na tie, gua. ");
INSERT INTO rug_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Hiera sina vina rua vuahenina sa soṉe pa popoa hie. Ka lima vuaheni pule si koa, meke namu loke tie si kaqu boka lelete babe pakepakete na gua. ");
INSERT INTO rug_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Ele garunu va kenue mae nau sa Tamasa si rau koa gamu, pa siraṉa variva magasana guahe, meke pude lopu kaqu mate palae si gamu meke sari na tumia, na gua. ");
INSERT INTO rug_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Ke hinokara sapu lopu gamu garunu mae nau tani si rau, ba e Tamasa tu. Asa tu ele vata evaṉae nau ṉati koimata arilaequ tanisa baṉara si rau, meke arau palabatu nia sa doduruna sa nana popoa, meke arau tugo sa qavuna tana doduruna sa popoa Izipi,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Ego, tuturei pule la koasa tamada, mamu tozi nia sapu guahe si zama nia sa tuna sapu se Zosepa: ‘Ele vata evaṉae nau na qavuna e Tamasa si rau pa doduruna sa popoa Izipi, ke mamu mae koa rau. Mamu lopu va sasanae,’ mamu gunia si asa. ");
INSERT INTO rug_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Kote boka la koa ia gamu sa popoa pa Qoseni, pude boka koa tata koa rau vasina si gamu: gamu doduru mo, sari na mia koburu, sari na tudia ri na tumia, sari na mia sipi na qoti, sari na mia bulumakao meke sari doduru likakalae saripu tagoi gamu. ");
INSERT INTO rug_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Be guana koa si gamu pa Qoseni, si kote boka kopuni gamu rau, ura ka lima vuaheni pule si koa, sapu kote koa ia sa soṉe, meke lopu hivani gamu rau si gamu, sari na mia tatamana, meke sari na mia rovana sipi pude agoso mate pa inovia. ");
INSERT INTO rug_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Ego, boka dogorau gamu doduru meke e Benisimane kamahire, sapu arau Zosepa hinokara tugo si rau. ");
INSERT INTO rug_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","La mamu tozia koa sa tamaqu sa ṉiniraṉira lavata sapu tagoa rau tani pa popoa Izipi, meke sari doduru tiṉitoṉa saripu ele dogori gamu. Beto mamu tuturei turaṉa mae nia tani si asa.” ");
INSERT INTO rug_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Beto asa si ṉaza ia sa se Benisimane sa tasina, meke podalae kabo, meke kabo tugo se Benisimane sipu korapa ṉaza ia sa si asa. ");
INSERT INTO rug_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Meke sipu korapa kabokabo si asa, si hopeke ṉazai sa sari na tasina meke ahoi sa si arini. Beto asa si podalae zama koa sa sari na tasina. ");
INSERT INTO rug_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Meke sipu kamo la pa vetu tanisa baṉara sa inavoso, sapu ele mae sari na tasina e Zosepa gua, si qetu sa baṉara meke sari nana ṉati palabatu koa sa nana binaṉara. ");
INSERT INTO rug_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Meke zama la koe Zosepa sa baṉara, “Mu tozini sari na tasimu pude va suraṉi koari na doṉ'ki sari na ginani meke pule la pa popoa Kenani. ");
INSERT INTO rug_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Madi la vagia sa tamadia meke sari na dia tamatina meke pule mae tani. Meke kaqu poni nia rau koa rini sa vasina sapu leana hola pa popoa Izipi, meke kaqu koa tagotago hola si arini. ");
INSERT INTO rug_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Mamu tozini tugo, pude vagi kaiqa totopili susuraṉana pa popoa Izipi, pude suraṉi sari na dia barikaleqe na koburu, meke pude turaṉia tugo sa tamadia na gua. ");
INSERT INTO rug_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Madi lopu talotaṉani rini sari na dia tinagotago saripu veko hola i rini pa popoa Kenani, sina sari doduru tiṉitoṉa saripu leadi hola koasa doduruna sa popoa Izipi, si kaqu tadirini mo,” gua sa baṉara. ");
INSERT INTO rug_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ke tavete betoi ri na tuna e Zekopi sari doduru gua pu ta tozi nia rini. Poni totopili susuraṉana na ginani vinabeo e Zosepa si arini gua puta tugo sapu ele garunu nia sa baṉara koa rini. ");
INSERT INTO rug_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Meke hopeke poni poko tugo sa si arini, ba koe Benisimane si ka ṉeta gogoto poata siliva, meke ka lima poko si vala i sa koasa. ");
INSERT INTO rug_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Meke ka manege puta doṉ'ki si garunu lani sa koasa tamana, sapu suraṉi soku tiṉitoṉa leadi hola pa popoa Izipi, meke ka manege puta doṉ'ki saripu suraṉi sari na huiti na bereti meke kaiqa ginani koasa dia inene. ");
INSERT INTO rug_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Meke vata luara taloai sa sari na tasina, meke sipu taluarae si arini, si zama la koa rini si asa, “Mu lopu varitoketokei tokele pa siraṉa si gamu,” guni sa. ");
INSERT INTO rug_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Meke taluarae pa popoa Izipi si arini, meke pule la pa dia popoa koasa tamadia, sapu e Zekopi pa popoa Kenani. ");
INSERT INTO rug_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Meke tozi nia rini se Zekopi, “Korapa toa nana se Zosepa. Meke asa tugo sa qavuna nomana pa doduruna sa popoa Izipi!” gua si arini. Meke ta duaṉa sa bulona e Zekopi meke lopu boka va hinokari sa si arini. ");
INSERT INTO rug_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ba sipu tozi rini koasa sari doduru gua pu zamani Zosepa koa rini, meke dogori sa sari na totopili saripu garunu lani Zosepa pude suraṉa la nia si asa pa Izipi gua, si ṉiṉira pule sa maqomaqona. ");
INSERT INTO rug_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Ke zama si asa, “Sa tuqu Zosepa si korapa toa nana! Asa mo sapu hiva nia rau. Maqu la dogoria sipu lopu ele mate si rau,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Meke va qaqiri betoi Zekopi sari doduru nana likakalae meke la pa Biasiba si asa, meke vasina si va vukivukihi la si asa koasa Tamasa tanisa tamana sapu se Aisake. ");
INSERT INTO rug_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Meke pana boṉi si zama la koasa sa Tamasa pa keke dinogodogorae, meke titioko, “Zekopi, Zekopi!” gua. Meke olaṉa si asa, “Baṉara, hiera si rau,” gua. ");
INSERT INTO rug_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Meke zama sa Tamasa, “Arau sa Tamasa, sapu sa Tamasa tanisa tamamu. Mu lopu matagutu la pa popoa Izipi si goi, ura kaqu va nomaia rau sa mua butubutu vasina. ");
INSERT INTO rug_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Kaqu luli turaṉigo Rau pude la pa popoa Izipi si goi, meke kaqu turaṉa pule maeni Rau pa popoa hie sari na mua butubutu. Kaqu mate pa limana e Zosepa si goi,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Meke va suraṉia ri na tuna si asa, meke gua tugo sari na dia koburu na barikaleqe koari na totopili pu valani sa baṉara pa popoa Izipi, meke taluarae pa Biasiba si arini. ");
INSERT INTO rug_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Meke turaṉa betoi rini sari doduru dia rovana sipi na bulumakao, meke sari doduru dia likakalae pu vagi rini pa popoa Kenani, meke la pa popoa Izipi si arini. Meke turaṉa betoi tugo e Zekopi sari doduru tuna: ");
INSERT INTO rug_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","sari na tuna koreo, na vineki meke sari na tudia. ");
INSERT INTO rug_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Ego, hire sari doduru tie koasa puku tatamana te Zekopi, saripu luli koasa meke la pa popoa Izipi, sapu sari Rubeni sa tuna koreo kenuna. ");
INSERT INTO rug_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ego, hire sari na tuna koreo Rubeni: Ari Hanoki, Palu, Hezironi meke Kami. ");
INSERT INTO rug_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","E Simione meke sari na tuna koreo: Ari Zemuela, Zamini, Ohadi, Zakini, Zohara, meke Saulu sapu sa tuna keke barikaleqe Kenani. ");
INSERT INTO rug_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","E Livae meke sari na tuna koreo: Ari Qerisoni, Kohati meke Merari. ");
INSERT INTO rug_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","E Ziuda meke sari na tuna koreo: Ari Era, Onani, Sela, Perezi meke Zera, (ba mate pa popoa Kenani sari Era e Onani.) Sari na tuna koreo Perezi si Hezironi meke Hamulu. ");
INSERT INTO rug_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","E Isaka meke sari na tuna koreo: Ari Tola, Pua, Zasubi, meke Simironi. ");
INSERT INTO rug_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","E Zeboloni meke sari na tuna koreo: Ari Seredi, Eloni meke Zalili. ");
INSERT INTO rug_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Hire sari na tuna Zekopi saripu va podoni sa koe Lia pa Mesopotemia, meke sa tuna vineki sapu se Daena. Sa vinarigaraedi ri doduru, si ari ka toloṉavulu ṉeta koreo na vineki. ");
INSERT INTO rug_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","E Qadi meke sari na tuna: Ari Zepone, Hagi, Suni, Eziboni, Eri, Arodi meke Areli. ");
INSERT INTO rug_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","E Asa meke sari na tuna koreo: Ari Imina, Iseva, Isivi, Beria meke se Sera sa tasidia vineki. Meke hire sari na tuna koreo e Beria: Ari Hebere meke Malakiele. ");
INSERT INTO rug_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Ego, arini sari ka manege onomo tuna e Zekopi koe Zilipa, sa nabulu vineki sapu vala nia Lebani koasa tuna vineki sapu se Lia. ");
INSERT INTO rug_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Se Reseli sa barikaleqe te Zekopi meke sari na tuna: Ari Zosepa meke Benisimane. ");
INSERT INTO rug_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Sipu koa pa popoa Izipi se Zosepa si va podoni sa koe Asenati sari karua tuna: Ari Manase meke Iparemi. Se Asenati hie si na tuna barikaleqe e Potipera, keke hiama pa Heliopolisi si asa. ");
INSERT INTO rug_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","E Benisimane meke sari na tuna koreo: Ari Bela, Bekera, Asibeli, Qera, Neamani, Ehi, Rosi, Mupimi, Hupimi meke Aradi. ");
INSERT INTO rug_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Arini sari ka manege made tuna koreo Zekopi koe Reseli. ");
INSERT INTO rug_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Sa tuna Dani si e Husimi. ");
INSERT INTO rug_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Se Napitalai meke sari na tuna koreo: Ari Zazili, Guni, Zezera meke Silemi. ");
INSERT INTO rug_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Hire sari na tuna koreo e Zekopi koe Biliha: Se Biliha hie, si na nabulu vineki, sapu vala nia Lebani koasa tuna barikaleqe, sapu se Reseli. Ari ka zuapa sari doduru. ");
INSERT INTO rug_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Sa vinarigaraedi ri doduru tuna e Zekopi saripu la pa Izipi si ari ka onomo ṉavulu onomo. Ba lopu somana ta nae sari na barikaleqe tadi na tuna. ");
INSERT INTO rug_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Karua tuna koreo e Zosepa si pododi pa popoa Izipi; ke sa vinarigaraedi ri doduru koasa nana puku tatamana, si ari ka zuapa ṉavulu lima saripu la vasina. ");
INSERT INTO rug_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Meke garunu va kenue la nia Zekopi se Ziuda koe Zosepa, meke tozi nia, pude la tutuvia si asa pa Qoseni, totoso kamo rini vasina. ");
INSERT INTO rug_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Suraṉa pa nana totopili se Zosepa meke la tutuvia sa sa tamana pa Qoseni. Totoso varitutuvi rini, si ṉazaia Zosepa sa ruana sa tamana meke lopu tuture beto kabo si asa. ");
INSERT INTO rug_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Meke zama la koe Zosepa se Zekopi: “Kamahire si maqu mate, sina ele dogoria rau sa isumatamu meke gilania sapu korapa toa mua si goi,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Meke zama la koari na tasina, meke koari na tatamana te Zekopi se Zosepa: “Kaqu la meke tozi nia rau sa baṉara Izipi, sapu sari na tasiqu meke sari doduru tatamana tanisa tamaqu pu koadi pa Kenani, si ele kamo koa rau, gua. ");
INSERT INTO rug_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Kaqu la tozi nia rau sapu na tie kopu sipi si gamu, meke ele turaṉa maeni gamu sari na mia rovana sipi na bulumakao, meke sari doduru mia likakalae pu tagoi gamu. ");
INSERT INTO rug_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Meke pana tioko gamu sa baṉara meke nanasani sari na mia tinavete, ");
INSERT INTO rug_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","si mamu olaṉa toṉoto la ia sapu na tie kopu sipi si gamu pa dodurudi rina mia tinoa, kekeṉoṉo gua tugo ri na tiatamada, mi gunia. Gua asa, si kaqu va koa gamu sa pa Qoseni si gamu.” Zama gua se Zosepa, sina sa hahanana tadi na tie Izipi si lopu hoke hiva va tata i rini sari na tie kopu sipi, gua. ");
INSERT INTO rug_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Ke turaṉi Zosepa sari ka lima tasina meke la koasa baṉara meke zama, “Sa tamaqu meke sari na tasiqu si ele kamo, mae guadi pa popoa Kenani. Paleki rini sari doduru dia likakalae pu tagoi rini, meke turaṉi tugo rini sari na dia rovana sipi na bulumakao. Meke kamahire si korapa koa pa Qoseni si arini,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Meke va turui sa pa kenuna sa baṉara sari na tasina. ");
INSERT INTO rug_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Meke nanasi sa baṉara sari kasa tamatasi, “Na tinavete sa si taveti gamu?” “Na tie kopu sipi si gami, baṉara, kekeṉoṉo gua tugo ri na tiatamamami pukerane,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","“Ele mae si gami pude koa pa popoa hie, sina sa soṉe si kaleana hola pa popoa Kenani, meke loke vasina pude ganigani sari na mami rovana sipi. Ke mamu tataruni gami, mamu va koa gami pa kali popoa pa Qoseni,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Meke zama la koe Zosepa sa baṉara, “Ego, ele kamo sa tamamu meke sari na tasimu kamahire. ");
INSERT INTO rug_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Sa popoa Izipi si boka koa ia rini kamahire. Mu va koa ia sa tamamu meke sari na tasimu koa ke vasina sapu leana hola sa pepeso. Madi la koa pa Qoseni, meke be gilani goi si kaiqa tie bokabokadi koa rini, si mamu va kopuni sari na qua rovana sipi,” gua sa baṉara. ");
INSERT INTO rug_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Meke turaṉa nuquru nia Zosepa se Zekopi sa tamana, meke va turua sa si asa pa kenuna sa baṉara, meke mana nia Zekopi sa baṉara. ");
INSERT INTO rug_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Meke nanasia sa baṉara si asa, “Ka visa vuahenimu si goi?” gunia sa. ");
INSERT INTO rug_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Meke olaṉa se Zekopi, “Na tie enene mo si rau pa doduruna sa qua tinoa, koari ka keke gogoto toloṉavulu puta vuaheni. Meke lopu soku sari na vuaheni arini, ba tasuna hola si arini. Lopu kekeṉoṉo gua ri na inene tadi na tiatamaqu pukerane,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Meke mana nia Zekopi sa baṉara meke tiqe zama luluaria sa si asa meke taloa. ");
INSERT INTO rug_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Meke va koa ia Zosepa sa tamana meke sari na tasina pa popoa Izipi, meke poni vasina na pepeso masuruna sa sapu leana hola koasa popoa, tata koasa vasileana lavata koasa pinaqaha popoa pa vasileana Ramesesi, gua puta tugo sapu garunu nia sa baṉara koa sa. ");
INSERT INTO rug_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Meke ponia ginani Zosepa sa tamana, meke sari na tasina, meke sari doduru tinoni saripu koa pa kinopu tanisa tamadia, kamo koari pu hitekedi. ");
INSERT INTO rug_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Meke ṉiṉira hola sa soṉe meke loke ginani si koa pa ninae vasina, ke ovia meke lopu ṉiṉira sari doduru tie pa popoa Izipi meke pa Kenani. ");
INSERT INTO rug_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Meke varigarani Zosepa sari doduru poatadi rina ginani saripu vata holu ni sa koari na tie pa popoa Izipi meke pa Kenani, meke paleke lani sa pa vetu tanisa baṉara. ");
INSERT INTO rug_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Meke sipu ele holuholu betoni ri na tie Izipi na tie Kenani sari na dia poata, si mae koe Zosepa sari na tie Izipi meke zama, “Mu poni gami ginani! Lopu leana pude mate pa kenumu goi si gami, sina ele upata beto sari doduru mami poata,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Meke olaṉa se Zosepa, “Mi va maei sari na mia rovana bulumakao, meke kaqu hobeni ginani rau si arini, be guana beto sari na mia poata,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Ke turaṉa vala i rini koe Zosepa sari na dia rovana bulumakao. Hobeni ginani sa sari na dia hose, na sipi, na qoti, na bulumakao meke sari na doṉ'ki. Meke koasa vuaheni sana si poni ginani sa si arini, koasa hinobedi ri doduru dia rovana kurukuru. ");
INSERT INTO rug_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Meke koasa vuaheni sapu luli la, si mae si arini koe Zosepa meke zama, “Baṉara, lopu kaqu boka tomea gami si keketoṉa sapu hinokara koa goi. Sari doduru mami poata si ele upata beto, meke sari na mami rovana kurukuru si tamugoi beto mo. Namu loketoṉa hokara sapu koa hola pude vatui koa goi, ba sari na tinimami meke sari na mami pepeso mo si koa. ");
INSERT INTO rug_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Mu lopu va mate gami, mamu hata ia sa siraṉa pude lopu kaqu ivulu sari na mami pepeso. Mamu holu hobeni ginani sari na tinimami meke sari na mami pepeso pude nana nabulu sa baṉara si gami. Meke asa kaqu tagoi sari na mami pepeso, ba mamu poni gami ginani pude toa si gami, meke na kiko pude mami lelete koari na mami pepeso,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Meke vata holu ni rina tinoni pa popoa Izipi sari doduru dia pepeso koe Zosepa, pude tanisa baṉara, ura na kaleana hola sa soṉe pa popoa sana. Ke sari doduru pepeso si tanisa baṉara mo. ");
INSERT INTO rug_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Meke vata evaṉae ni nabulu e Zosepa sari doduru tie, koari doduru vasidi pa popoa Izipi. ");
INSERT INTO rug_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Sa titeke pepeso sapu lopu holua sa si na pepeso tadi na hiama. Sari na pepeso hire si lopu holuholuni rini, sina tabari sa baṉara si arini koari na dia tinavete, ke boka holu gedi ginani si arini. ");
INSERT INTO rug_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Meke zama la koari na tinoni se Zosepa, “Gilania gamu, sapu ele holu gamu rau si gamu meke sari na mia pepeso pude tanisa baṉara kamahire. Ke hire sari na kiko tamugamu pude mamu letei koari na mia inuma. ");
INSERT INTO rug_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Ke koa rina totoso pakepakete si kaqu vala ia gamu, sa keke pa lima koasa baṉara, meke sari na kiko saripu koa hola si pude tana lelete na henahena tamugamu meke sari na mia tatamana.” ");
INSERT INTO rug_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Meke olaṉa sarini, “Ele harupi goi sari na mami tinoa, meke ele tavete valeana si goi, baṉara koa gami, ke kaqu na nabulu tanisa baṉara mo si gami,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Ke vata evaṉae nia keke tinarae tanisa popoa Izipi e Zosepa, si pude vala keke pa lima, koari na ginani saripu ele ta pakete, pude tanisa baṉara. Sa tinarae hie si korapa koa hola meke tava ṉiṉira pa rane ṉinoroi. Ba sari na pepeso tadi na hiama mo, si lopu tagoi sa baṉara. ");
INSERT INTO rug_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Meke koa pa popoa Izipi pa kali popoa pa Qoseni sari na tie Izireli, meke koa tagotago na podo va soku koburu si arini vasina. ");
INSERT INTO rug_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Meke ka manege zuapa vuaheni si koa pa popoa Izipi se Zekopi, osolae kamoa ka keke gogoto made ṉavulu zuapa vuahenina si asa. ");
INSERT INTO rug_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Meke sipu tata kamo sa totoso pude mate si asa si tiokia sa se Zosepa sa tuna, meke zama ia sa si asa, “Mu vekoa sa limamu pa varikorapadi ri karua pudapudaqu. Mamu zama tokotokoro nia, sapu lopu kaqu pomunu nau goi pa popoa Izipi, mu gua. ");
INSERT INTO rug_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Ura na hiva ta pomunae si rau vasina sapu ta pomunae sari na tamaqu. Kaqu paleke vura nau gamu si rau pa popoa Izipi, meke kaqu la pomunu nau vasina sapu ta pomunae si arini,” gua si asa. Meke olaṉa se Zosepa, “Kaqu tavetia rau sapu gua zama nia goi,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Meke zama se Zekopi, “Mu zama tokotokoro nia sapu kaqu tavetia goi si asa.” Meke zama tokotokoro se Zosepa koe Zekopi, meke zama leana se Zekopi, sipu korapa habotu pa nana teqe si asa. ");
INSERT INTO rug_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Sipu hola kaiqa rane si tozi nia rini se Zosepa sapu moho sa tamana, gua. Ke turaṉi Zosepa sari karua tuna koreo, sapu sari Manase e Iparemi pude la dogoria se Zekopi, gua. ");
INSERT INTO rug_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Meke sipu tozi nia rini se Zekopi sapu ele mae sa tuna sapu se Zosepa, pude dogoria si asa, gua, si va ṉiṉirae si asa meke habotu sage pa nana teqe. ");
INSERT INTO rug_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Meke zama la ia Zekopi se Zosepa, “Sa Tamasa sapu tagoi sari doduru ṉiniraṉira si vura koa rau pa Luzi koasa popoa Kenani meke mana nau. ");
INSERT INTO rug_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Meke zama guahe si Asa koa rau: ‘Kaqu va sokui rau sari na tumu, meke sari na tutimu goi, si kaqu ta evaṉae butubutu sokudi, meke sa pepeso hie, si kaqu poni nia rau koari na tutimu pude tagoa rini ninae rane,’ gua. ");
INSERT INTO rug_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Ego, sari karua tumu koreo goi Zosepa, saripu pododi tani pa popoa Izipi, sipu lopu ele mae rau, sapu sari Iparemi meke e Manase si taqarau, kekeṉoṉo gua puta tugo mo ari Rubeni e Simione si arini. ");
INSERT INTO rug_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Sari kaiqa tumu pule saripu podo pa mudidia, si lopu kaqu ta pozae taqarau si arini, meke sa tinago na pepeso sapu kaqu ta hia nia rini, si kaqu mae gua tu koari Iparemi meke Manase. ");
INSERT INTO rug_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Tavetia rau sapu gua asa, sina sa tinamu sapu se Reseli, sapu talotaṉa hola nia rau si ele mate pa popoa Kenani, lopu seu pa Eparata, koasa qua pinule mae pa Mesopotemia. Meke pomunu nia rau si asa pa vale siraṉa la gua pa Eparata.” (Eparata si ta pozae Betilihema pa rane ṉinoroi.) ");
INSERT INTO rug_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Sipu dogori sa sari karua tuna koreo, “Ari sei si hire?” nanasa gua se Zekopi. ");
INSERT INTO rug_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Meke olaṉa la koasa tamana se Zosepa, “Arini sari karua tuqu koreo saripu poni nau sa Tamasa tani pa popoa Izipi.” Meke zama la koasa se Zekopi, “Turaṉa maeni koa rau pude qu manani,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Ba rida sari na matana Izireli, sina ele barogoso sisigiti si asa, meke lopu boka dodogorae valeana. Ke turaṉa lani Zosepa koasa sari karua tuna koreo, meke ṉazai na ahoi sa si arini. ");
INSERT INTO rug_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Meke zama la koe Zosepa se Izireli, “Lopu hite rovea rau sapu kaqu dogoro pulea rau sa isumatamu, meke kamahire si namu va dogoro nau Tamasa sari na mua koburu.” ");
INSERT INTO rug_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Meke daku va rizui Zosepa sari kara pa varikorapa nenena e Zekopi meke hoqa todoṉo pa pepeso si asa. ");
INSERT INTO rug_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Meke rizu va tata la i Zosepa sari karua koe Izireli, Iparemi pa kali gedena meke Manase pa kali mataona Izireli. ");
INSERT INTO rug_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ba qaqama variseani Izireli sari na limana koa ri karua. Sa lima mataona si va opo la nia sa pa batuna e Iparemi sapu mudina meke sa lima gedena si va opo la nia sa pa batuna e Manase, sapu kenuna. ");
INSERT INTO rug_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Meke mana nia Izireli se Zosepa meke zama guahe: “Sa Tamasa sapu nabulu nia ri karua tiatamaqu, ari Ebarahami e Aisake, si mani manani sari koreo hire! Sa Tamasa sapu turaṉau pa rane hie si kaqu manani sarini. ");
INSERT INTO rug_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Sa mateana sapu harupau koari doduru tinasuna si kaqu manani sari karua koreo hire! Meke lopu kaqu ta muliṉae sa pozaqu meke sari na pozadia ri na tiatamaqu, sapu sari Ebarahami e Aisake pa korapa dia tinoa, meke kaqu soku hola sari na tudia, na tudia ri na tudia pa popoa pepeso.” ");
INSERT INTO rug_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Meke sipu dogoria Zosepa sapu veko la nia sa tamana sa lima mataona pa batuna Iparemi, si lopu qetu si asa, meke tuqea sa sa limana sa tamana pude va rizu pania pa batuna Iparemi, meke pude va karovo la nia koe Manase gua. ");
INSERT INTO rug_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Meke zama ia Zosepa sa tamana, “Lopu gua asa tamaqu, ura hiera tu sapu kenuna; mu veko la nia pa batuna sa lima mataomu.” ");
INSERT INTO rug_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ba korona sa tamana meke zama, “Gilania qua tuqu, gilania qua. Sari na tuna na tudia ri na tuna Manase ba kaqu na butubutu lavata tugo. Ba sa tasina mudina si kaqu arilaena hola nia si asa meke sari na tuna na tudia ri na tumu si kaqu ta evaṉae sari na butubutu ṉiṉiradi”, gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Meke manani sa koasa rane sana si arini meke zama guahe: “Pa korapa pozamu goi si kaqu ta tozi vurae koari na tinoni Izireli sa minana sapu zama guahe: ‘Mani vata evaṉae nigo Tamasa pude gua tugo Iparemi e Manase si goi,’ gua.” Gua asa ke va arilaena hola ia Izireli se Iparemi koe Manase. ");
INSERT INTO rug_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Meke zama la koe Zosepa se Zekopi, “Ele gilania mua sapu tata mate si rau, ba sa Tamasa si kaqu koa koa goi, meke kaqu turaṉa pule nigo koa sa popoa tadi na tiatamamu. ");
INSERT INTO rug_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Vatu nia rau koa goi ba lopu koari na tasimu si pa Sekemi, sapu sa popoa masuruna sapu vagia rau pa vedara na bokala koari na tie Amoraiti,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Meke tioko varigara ni Zekopi sari na tuna koreo meke zama i sa, “Varigara beto mae si gamu doduru; maqu tozini gamu gua sapu kaqu ta evaṉa koari na rane vugo na repere: ");
INSERT INTO rug_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Gamu na tuqu, mi varigara mae; mamu va avoso mae koa rau. Mi avosia sa tamamia Izireli. ");
INSERT INTO rug_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Agoi Rubeni, sa qua koburu kenuna, meke na qua ṉiniraṉira, na koburu kekenu pa pinodopodo pa qua pinalabatu, arilaemu hola pa vina noma pule nigo meke ṉiṉira hola ni goi sari na tasimu. ");
INSERT INTO rug_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Kekeṉoṉo guana naqe si goi sapu raza ia sa popoa. Gua asa si lopu kaqu boka koimata ni goi sari na tasimu koreo, sina eko turaṉia goi sa qua nabulu barikaleqe pa qua teqe meke lopu pamaṉa nau goi si rau. ");
INSERT INTO rug_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Ari Simione e Livae si karua tamatasi soti meke sari na dia vedara si variva mate. ");
INSERT INTO rug_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Koroqu va egoi rau sari dia kinuhana golomodi. Meke lopu kaqu somana ni rau sari dia vivinei. Ura koasa dia binugoro si seke va mate tie si arini. Qetu si arini pa dia binugoro pude seke kumati sari na pikupikutu makasidi rina bulumakao. ");
INSERT INTO rug_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Namu ta levei sa dia binugoro, sina ṉiṉira sisigiti si asa, meke na ṉinovaṉovala nomana koari na tie. Kaqu vari paqapaqaha ni rau pa doduru popoa Izireli si arini, meke kaqu va hihia i rau koari na tudia rina tuqu. ");
INSERT INTO rug_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Agoi Ziuda si kaqu vahesi igo rina tasimu. Kaqu neti goi ruadi sari na mua kana, meke kaqu todoṉo pa kenumu goi sari na tasimu. ");
INSERT INTO rug_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Kekeṉoṉo guana laione se Ziuda, sapu va matea sa nana boso meke kekere pule la pa nana bae; eko magogoso si asa, meke loke tie si hiva va tekulia. ");
INSERT INTO rug_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Keke tumu goi si kaqu na baṉara, meke sa tutimu si kaqu tagoa sa ṉiniraṉira pude na baṉara osolae kamo mae sa tuna pu garona pude tagona sa ṉiniraṉira, meke kaqu todoṉo na va tabea ri na butubutu si Asa. ");
INSERT INTO rug_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Pusi nia sa sa nana doṉ'ki koasa huda vaeni, meke sa tuna doṉ'ki koasa lelaṉa vaeni toa valeanana; sina kote soku hola sari na huda vaeni pa nana popoa sapu soku hola vuadi, ke leana hola pude na ginani tadi na kurukuru, meke be hiva si kote boka ṉuzapi sa sari nana poko koasa kolo vaeni ziṉara. ");
INSERT INTO rug_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Sari na matana si ziṉara koasa ninaponapo vaeni, meke sari na livona si keoro koasa ninapona sa meleke. ");
INSERT INTO rug_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","E Zeboloni si kaqu koa pa masamasa kolo; meke kaqu ta evaṉae na sigotoana vaka si asa; meke sa kokoina sa nana popoa si kaqu kamo la gua pa Saedoni. ");
INSERT INTO rug_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isaka si kekeṉoṉo guana doṉ'ki ṉiṉirana, sapu eko varikali nia na vovoina likakalae mamatadi. ");
INSERT INTO rug_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Ba sipu dogoria sa sapu sa vasina magomagogosoana si leana, meke variva qetu sa popoa tanisa, si kokopo gore nia sa avarana pude paleki sari na pinaleke mamata, meke ta evaṉae pinausu pu ta zukuru pa tinavete si asa. ");
INSERT INTO rug_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","E Dani si kaqu koimata ni na kopu ni na totoli ni sari nana tinoni meke kaqu ta evaṉae keke butubutu pa Izireli. ");
INSERT INTO rug_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Kaqu kekeṉoṉo guana noki sapu koa pa kali siraṉa sapu variva matena, meke garatia sa sa nenena sa hose, ke sa tie pu hake koasa si hoqa gore taloa pa mudina. ");
INSERT INTO rug_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Ke Zihova, aqa nia rau sa Mua tinaharupu. ");
INSERT INTO rug_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Keke puku tie varipera hikohiko si kaqu rapatia se Qadi, ba kaqu va kilasi sa meke hadu va seui sa si arini. ");
INSERT INTO rug_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Kaqu masuru valeana sa pepeso te Asa, meke kaqu va vura nia sa ginani arilaena hola gua padana keke baṉara. ");
INSERT INTO rug_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Napitalai si kekeṉoṉo guana kurukuru sapu ta pozae dia sapu ta rupahana, meke sari na tuna pu podoi sa si leleadi. ");
INSERT INTO rug_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","E Zosepa si guana huda vaeni sapu vua katakata, meke toa valeana tata koasa bukaha, meke sari na lelaṉana si haele sage hola nia sa goba. ");
INSERT INTO rug_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Meke rapata va ṉiṉira la ia ri nana kana, meke gona nia tupi rini si asa. ");
INSERT INTO rug_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ba va totoanae valeana nia sa sa nana bokala, meke tava ṉiṉira sari na limana, koasa ṉiniraṉira tanisa Tamasa Heheda te Zekopi, meke koasa Sepati sapu lavelave kopuna se Izireli guana Patu aqoroana. ");
INSERT INTO rug_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Sa Tamasa tanisa tamamu si toka nigo, meke sa Tamasa pu tagoi sari doduru ṉiniraṉira si mana nigo, meke ponigo sa ruku pa galegalearane, meke na bukaha sapu vura mae gua pa kauru pepeso, meke kaqu soku na mua kurukuru na koburu. ");
INSERT INTO rug_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Sa tinamanae tanisa tamamu si noma holani sari na toqere koadi, holani sari doduru tiṉitoṉa tolavaedi na toqere toa holadi. Sari na tinamanae hire si madi koa pa batuna e Zosepa guana toropae baṉara pa batuna sapu ta paqaha pude na koimata koari na tasina. ");
INSERT INTO rug_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","E Benisimane si kekeṉoṉo guana siki variva mate na oviana; sapu pana munumunu si gania sa sa gana boso sapu ele vagia sa, meke pana veluvelu si va hia i sa sari na vinagi pa vinaripera.” ");
INSERT INTO rug_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Arini sari ka manege rua butubutu Izireli; meke sari na zinama tinamanae gotogotodi pu hopeke zamani sa tamadia koarini. ");
INSERT INTO rug_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Meke zamai Zekopi sari na tuna, “Tata mate si rau kamahire. Meke pana mate rau si mamu la pomunu turaṉa nau koari na tamaqu koasa bae te Eporoni pa nana inuma, sapu na tie Hitaiti, ");
INSERT INTO rug_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","pa Makapela, pa kali gasa rimata pa Mamere pa popoa Kenani. Ele holua Ebarahami sa pepeso hie koe Eporoni pude na vasina popomunuana. ");
INSERT INTO rug_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Vasina si ta pomunae se Ebarahami, meke sa nana barikaleqe sapu se Sera, meke vasina tugo si ta pomunae se Aisake meke sa nana barikaleqe sapu se Ribeka, meke vasina tugo si pomunu nia rau se Lia. ");
INSERT INTO rug_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Sa pepeso meke sa bae vasina, si ele ta holudi koari na tie Hitaiti, ke mamu pomunau vasina.” ");
INSERT INTO rug_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Meke sipu beto totozini Zekopi sari na tuna koreo sari nana hiniva hire, si poloi sa sari na nenena pa teqe. Eko pule, meke tiqe mate si asa. ");
INSERT INTO rug_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Meke ṉazaia Zosepa sa tamana meke kaboa na ahoa sa si asa. ");
INSERT INTO rug_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Meke tozini Zosepa sari na tie pu va nama tomate pa pinomunaena pude veko nia meresena sa tinina sa tamana. ");
INSERT INTO rug_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Ka made ṉavulu puta rane si ta kopue koa rina tie va nama tomate sa tinina, sina asa tugo sa padana. Meke kaboa ri na tinoni pa Izipi koari ka zuapa ṉavulu rane si asa. ");
INSERT INTO rug_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Meke sipu ele hola sari na rane tana besu, si zama la i Zosepa sari kaiqa tie nomadi tanisa baṉara, “Be qetu nau gamu, si mamu la tozia koasa baṉara sa inavoso hie, ");
INSERT INTO rug_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Sipu tata mate sa tamaqu, si tozi nau sa pude zama tokotokoro koasa, sapu kaqu la pomunu nia rau si asa koasa lovu sapu horea sa telena pa popoa Kenani. Ke tepa si rau koa goi, pude mu va malumau, pude maqu la pomunia sa tamaqu, beto asa maqu pule mae.’ ” ");
INSERT INTO rug_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Meke olaṉa sa baṉara, “Ego, mu sage la, mamu pomunu nia sa tamamu gua sapu ele va tatara nia goi koasa.” ");
INSERT INTO rug_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Ke sage la pomunu nia Zosepa sa tamana. Meke sari doduru koimata tanisa baṉara, meke sari doduru ṉati palabatu pa nana qinavuna, meke sari doduru ṉati hiniva pa popoa Izipi, ");
INSERT INTO rug_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","meke sari nana tatamana, na tasina, meke sari doduru puku tatamana tanisa tamana, ari doduru si sage beto la. Sari na koburu hitehitekedi mo, na dia rovana sipi, qoti, na bulumakao, meke sa dia nabulu kopu si koa hola pa popoa Qoseni. ");
INSERT INTO rug_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Sari na tie pa totopili meke na hose ba luli tugo koasa; kapu na puku tinoni lavata si asa. ");
INSERT INTO rug_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Meke sipu kamoa rini sa vasina te Atadi tana varipaqahi ni rini sari na kiko huiti koari na qaqalotodi, pa kali gasa rimata koasa Ovuku Zodani, si koa va seunae meke kabokabo va ulululae sisigiti pa tinaruqoqo si arini. Meke ka zuapa rane besu nia Zosepa sa tamana. ");
INSERT INTO rug_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Meke sipu dogoria rina tiena soti sa popoa Kenani sa tinaruqoqo pa Atadi, si zama guahe si arini, “Ke kara, hola sa tinaruqoqo lavata sapu evaṉia ri na tie Izipi!” gua. Gua asa ke ta pozae na tinaruqoqo tadi na tie pa Izipi sa vasina asa. ");
INSERT INTO rug_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Gua asa ke tavetia ri na tuna koreo Zekopi gua sapu tozini sa, ");
INSERT INTO rug_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","meke paleke la nia rina tuna koreo sa tinina pa popoa Kenani, meke la pomunu nia pa korapa bae pa Makapela pa kalina Mamere, koa sa pepeso sapu ele holua Ebarahami koe Eporoni sa tie Hitaiti pude na vasina popomunuana, gua. ");
INSERT INTO rug_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Meke sipu beto pomunu nia Zosepa sa tamana si pule la pa Izipi turaṉi sa sari na tasina, meke sarini pu luli koasa. ");
INSERT INTO rug_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ego pa mudina sa minate tanisa tamadia, si zama guahe sari kasa tasina e Zosepa, “Vegua beka, hokara korapa kana gita Zosepa, meke kuhanani gita sa pude hobei sari doduru nada sinea saripu tavete lani gita koasa?” gua. ");
INSERT INTO rug_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ke garunu la nia zinama rini se Zosepa, sapu zama guahe, “Sipu lopu ele mate sa tamada, si zama vekoni sa, ");
INSERT INTO rug_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Mamu zama guahe koe Zosepa: Ele tozini gami sa pude tepaigo: mu tataruni, mamu taleosoni sari na sinea na tinavete kaleadi saripu tavete atuni ri na tasimu koa goi, gua.’ Ke kamahire, mu tataruni gami, mamu taleosoni sari na mami sinea. Gami si na nabulu mo te Tamasa tanisa tamamu.” Sipu vagia Zosepa sa inavoso hie si kabo si asa. ");
INSERT INTO rug_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ke la hoqa todoṉo pa kenuna sa sari na tasina meke zama, “Hire si gami kasa na mua nabulu,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Ba zama la koa rini se Zosepa, “Mi lopu matagutu si gamu. Lopu boka hobea rau sa tuturuana te Tamasa,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","“Gamu mo si ele balabala va kaleanau, ba sa Tamasa si ilirae nia lineana Sa sa kinaleana. Gua sapu ta evaṉa pa rane ṉinoroi, si pude boka harupi sari na tinoa tadi soku tie gua. ");
INSERT INTO rug_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Ego, mi lopu koa matagutu si gamu, kaqu kopuni gamu rau meke gua tugo sari na mia koburu.” Ke zama valeana pulei na va manoti sa bulodi si arini. ");
INSERT INTO rug_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Meke koa turaṉia mo Zosepa pa popoa Izipi sa butubutu tanisa tamana, meke kamoa sipu keke gogoto manege puta vuahenina si asa meke tiqe mate. ");
INSERT INTO rug_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Meke dogoro kamoi Zosepa sari na tuna Iparemi koari ka ṉeta sinage, meke sari na tuna Makiri sapu sa tuna Manase. Meke va kekeṉoṉo gunia na tuna mo sa sa tuna Makiri. ");
INSERT INTO rug_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Meke zama la koari na tasina si asa, “Tata mate si rau kamahire, ba sa Tamasa si kaqu kopu zoṉazoṉani gamu meke turaṉa vurani gamu koasa popoa hierana, meke valani gamu koasa popoa sapu ele va tatara nia Sa koe Ebarahami, Aisake, meke Zekopi.” ");
INSERT INTO rug_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Meke tepa ia Zosepa si keke vina tatara nabuna koari na tuna Izireli sapu guahe, “Pana mae turaṉa vurani gamu sa Tamasa pa Izipi, si mamu paleke taloani sari na susuriqu,” gua. ");
INSERT INTO rug_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Meke sipu keke gogoto manege puta vuahenina se Zosepa si mate si asa, meke beto asa si veko nia meresena rini sa tinina, meke tiqe voi ia rini pa kesi si asa. ");
INSERT INTO rug_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Hire sari na tuna koreo, meke sari dia hopeke puku tatamana saripu luli koe Zekopi meke la pa popoa Izipi: ");
INSERT INTO rug_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ari Rubeni, Simione, Livae, Ziuda, ");
INSERT INTO rug_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isaka, Zeboloni, Benisimane, ");
INSERT INTO rug_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dani, Napitalai, Qadi, meke Asa. ");
INSERT INTO rug_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Sa vinarigaraedi ri doduru tie saripu podo mae gua koe Zekopi, si ari ka zuapa ṉavulu puta. Keke ri kasa tuna koreo, sapu se Zosepa si ele koa va kenue nana tu pa popoa Izipi. ");
INSERT INTO rug_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Mumudi hoi si mate se Zosepa, meke sari na tasina, meke gua tugo sari doduru tie saripu koa koasa totoso asa, ");
INSERT INTO rug_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","ba sa pinodopodo tadi na tie Izireli si soku hola, meke noma sage sa butubutu, meke koa ia rini sa doduruna sa popoa Izipi. ");
INSERT INTO rug_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Beto hoi, keke baṉara vaqura sapu lopu hite gilana hokaria sa guguana e Zosepa si baṉara hobe pa popoa Izipi. ");
INSERT INTO rug_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Meke zama si asa koari nana tie, “Soku meke ṉiṉira holani gita rina tie Izireli hire si gita. ");
INSERT INTO rug_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Meke be mae sa vinaripera, si hokara kote tokani rini sari nada kana, meke raza gita rini, meke hokara kote govete taloa dia koasa popoa hie. Aria, mada hata ia sa siraṉa, mada kopuni, pude lopu soku si arini,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Ke vizati rina tie Izipi sari na tie kopu ṉiṉiradi, pude zukuru ni tinavete mamatadi, na va mataguti si arini, pude kuri sari na vasileana nomadi hola pa Pitomu meke Ramesesi, vasina vekoi sa baṉara sari doduru ginani na likakalae. ");
INSERT INTO rug_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Vatasuna hola i ri na tie Izipi sari na tie Izireli, ba omunu va soku tugo si arini, meke koa betoa mo rini sa doduruna sa popoa. Ke podalae matagutuni rina tie Izipi sari na tie Izireli. ");
INSERT INTO rug_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","14","Gua asa ke va tasunai rina tie Izipi sari na tie Izireli koari na tinavete ninabulu mamatadi hola; meke ososo sisigitini rini si arini, pude tavetavete va ṉiṉira hola, meke va tavetaveti rini si arini koari na tinavete kurikuri vetu, meke koari na dia inuma, meke lopu tataruni rini si arini. ");
INSERT INTO rug_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Meke zama la sa baṉara koari Sipara e Pua, ari karua pu hoke tokani, na va podopodoi sari na barikaleqe Izireli, ");
INSERT INTO rug_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Pana va podopodoi gamu kara sari na barikaleqe Hiburu, si mamu va matea sa haha be guana koreo si asa ba be vineki si asa si mamu va toaia,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Ba pamaṉa nia rina barikaleqe va podopodo sa Tamasa, ke lopu va tabea rini sa zinama tanisa baṉara, meke lopu va matei rini sari na koburu koreo. ");
INSERT INTO rug_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Ke tioki sa baṉara sari karua barikaleqe va podopodo meke nanasi, “Na vegua ke tavetia tu gamu kara sapu gua asa? Na vegua ke va toa i tu gamu sari na koreo?” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Meke olaṉa si arini, “Sari na barikaleqe Hiburu si lopu kekeṉoṉo rina barikaleqe Izipi. Lopu boka hoke podopodo tasuna si arini. Hoke ele podopodo dia tu, sipu lopu ele hopeke kamo la vasina si gami.” ");
INSERT INTO rug_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Sina pamaṉa nia rina barikaleqe va podopodo sa Tamasa, ke qetuni Sa si arini, meke varihaba; va noma i sa Tamasa sari na dia tatamana soti. Meke soku lala dia meke toa valeana sari na tie Izireli. ");
INSERT INTO rug_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Meke mumudi hokara si va enea sa baṉara sa nana zinama koari doduru nana tie, sapu guahe, “Kaqu ta vagi sari doduru koburu haha koreo tiqe ta pododi meke kaqu ta okie la pa korapa Ovuku Naelo, ba sari doduru haha vineki si kaqu tava toa,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Koasa totoso tugo hie, sipu tava mate sari na koburu haha koreo tadi na tie Izireli, si haba vagia keke tie pa butubutu Livae si keke barikaleqe koasa nana butubutu soti hie. ");
INSERT INTO rug_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Meke va podo nia sa koasa barikaleqe hie si keke koburu koreo. Meke sipu dogoria sa barikaleqe sapu tolavaena sa koburu hie, si tomea sa si asa pa nana vetu ka ṉeta sidara. ");
INSERT INTO rug_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Ba sipu lopu boka ta tome hola la ia sa si asa, si vagia sa si keke huneke duduli meke tita nia ta sa si asa, pude lopu boka nuquria kolo gua, meke va ekoa sa sa koburu haha hie pa korapana sa huneke, beto meke vekoa sa si asa pa korapa roga duduli ululudi pa taqelena sa ovuku. ");
INSERT INTO rug_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Meke turu nana pa seseuna vasinahite sa tasina vineki sa koburu haha hie pude dogoria sapu nasa si kote ta evaṉa koasa haha, gua. ");
INSERT INTO rug_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Meke gore huhuve nana pa ovuku sa tuna vineki sa baṉara pa popoa Izipi, meke enene dia pa taqele ovuku sari nana nabulu vineki. Meke hinoqa dogoria sa sa huneke duduli pa korapa roga duduli ululudi, ke garunia sa si keke nabulu vineki pude la vagia si asa. ");
INSERT INTO rug_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Meke tukelia sa tuna vineki sa baṉara sa huneke duduli, meke dogoria sa si keke koburu haha koreo. Meke kabo sa koburu haha, ke tataru nia sa si asa. “Ai na tudia ri na tie Hiburu sa koburu haha hie,” zama gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Meke nanasa la ia sa tasina vineki sa haha si asa, “Maqu la tiokia si keke barikaleqe Hiburu pude kopu nia si asa?” ");
INSERT INTO rug_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Meke olaṉa sa tuna vineki sa baṉara, “Ego latu,” gua si asa. Ke la sa vineki meke turaṉa mae nia sa tinana soti sa koburu haha. ");
INSERT INTO rug_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Meke zama ia sa tuna vineki sa baṉara sa barikaleqe, “Mamu vagia sa koburu haha hie, mamu kopu mae nia, taqarau si asa, meke kote tabarigo rau si goi,” gua si asa. Ke vagia sa barikaleqe sa koburu haha meke kopu nia. ");
INSERT INTO rug_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Beto asa sipu noma sage sa koburu, si turaṉa la nia sa koasa vineki tanisa baṉara si asa, meke pausu gunia mo sa na tuna koreo soti si asa. Meke balabala guahe si asa, “Na ele vagia rau pa kolo si asa, ke kaqu poza nia e Mosese rau si asa,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Meke sipu ele tie nomana se Mosese, si ene la hopikini sa sari na tie Hiburu, sapu sari na turaṉana soti, meke la dogoria sa sa dia tinasuna nomana, sapu tavete la nia ri na tie Izipi koarini. Meke dogoria tugo sa sapu korapa komitia sa tie Izipi si keke tie Hiburu, sapu keke mo ri kasa turaṉana soti e Mosese. ");
INSERT INTO rug_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Meke liṉana la mae se Mosese, meke sipu dogoria sa sapu loke tie si doṉo la koasa, si seke va matea sa sa tie Izipi, meke sara tamunia sa sa tinina pa korapa onone. ");
INSERT INTO rug_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Meke pa koivugona si ene pule la si asa, meke dogori sa sari karua tie Hiburu, korapa variperaedi meke zama la si asa koasa pu korapa komikomiti, “Na vegua ke sekea tu goi sa tie Hiburu turaṉamu?” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Meke olaṉa sa tie, “Esei va palabatu igo koa gami, pude pitu gami? Vegua hiva va mateau gua si goi, kekeṉoṉo gua sapu ele va matea tu goi sa tie Izipi?” gua. Meke matagutu se Mosese, meke zama, “Hinokara, sapu gua evaṉia rau si ele ta gilana koa ri na tie,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","16","Meke sipu avoso nia sa baṉara sapu gua ele ta evaṉa, si podekia sa pude va matea se Mosese. Ba govete taloa se Mosese meke la koa pa popoa Midiani. Meke keke rane, sipu korapa habotu kapae nana koa keke berukehe si asa, si mae gedi sari ka zuapa tuna vineki e Zetoro sapu sa hiama pa popoa Midiani, pude mae kave kolo meke toṉo va siṉi sari na vovoina kolo tadi na sipi na qoti tanisa tamadia, gua. ");
INSERT INTO rug_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Ba mae sari kaiqa sepati meke hadu va seui sari na tuna vineki e Zetoro, meke la tokani e Mosese si arini, meke va napoi sari na dia sipi. ");
INSERT INTO rug_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Meke sipu lopu sana pule la si arini koasa tamadia, si nanasi sa si arini, “Na vegua ke lopu sana, meke va napoi gamu sari nada kurukuru,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Meke olaṉa si arini, “Na tokani gami keke tie Izipi si gami, koari na tie kopu sipi pu hiva hukatani gami kolo, meke kave ponini gami kolo tugo sa, meke va napoi sari nada kurukuru,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Meke nanasi sa sari na tuna vineki, “Avei si asa? Na vegua ke veko pania tu gamu vasina si asa? La mamu va mae ia, pude mae henahena koa gita,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Ke malumu koa koarini vasina se Mosese. Meke va haba nia Zetoro koasa sa tuna vineki sapu se Zipora. ");
INSERT INTO rug_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Meke va podo nia sa koe Zipora si keke tuna koreo, meke balabala guahe se Mosese, “Na tie karovoqu si rau pa popoa hie, gua asa ke poza nia Qesomu rau sa pozana,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Meke sipu hola kaiqa vuaheni, si mate sa baṉara pa popoa Izipi, ba lopu hite makudo soliṉi lamo pa tinoa tava pinausu sari tie Izireli, meke kabo alili nia rini sa tinokae. Meke sage la koe Tamasa sa dia kinabo alili. ");
INSERT INTO rug_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Meke avosi Tamasa sari na dia tinepa tinokae pa tinasuna, meke balabala pulea Sa sa Nana vinariva egoi koe Ebarahami, Aisake, meke e Zekopi. ");
INSERT INTO rug_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Meke gilania Tamasa sa dia tinoa pinausu, meke tataruni Sa si arini. ");
INSERT INTO rug_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Keke rane, sipu korapa kopuni Mosese sari na sipi na qoti tanisa nana hopehopena, sapu se Zetoro, sa hiama pa popoa Midiani, si turaṉa karovo nia sa sa rovana sipi koasa qega, meke mae pa Saenai koasa toqere hopena si asa. ");
INSERT INTO rug_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Meke dogoria sa vasina sa mateana te Tamasa guana huruṉu nika, sapu vura mae pa korapa huda, ba lopu sulu si asa. ");
INSERT INTO rug_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Ke balabala si asa, “Ai, keketoṉa si hie. Na vegua ke lopu sulu sa huda? Maqu tata la, maqu dogoria,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Meke sipu dogoria Tamasa sapu korapa ene tata mae se Mosese, si titioko la koasa si Asa pa korapa huda meke zama, “Mosese! Mosese!” gua si Asa. Meke olaṉa se Mosese, “Hiera si rau,” gua. ");
INSERT INTO rug_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Meke zama sa Tamasa, “Mu lopu tata mae. Mamu va gorei sari na mua sadolo, sina na hopena sa pepeso vasina pu korapa turua goi,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","“Arau tugo sa Tamasa tadi na tiatamamu, sa Tamasa te Ebarahami, Aisake, meke e Zekopi.” Ke nobia Mosese sa isumatana, sina matagutu doṉo la koe Tamasa si asa. ");
INSERT INTO rug_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Beto asa si zama la koasa sa Tamasa, “Ele dogoria Rau sa tinasigiti tadi na Qua tinoni pa popoa Izipi, meke sa dia kinabokabo, na tinepa tinokae pude ta harupu dia koari na koimata pa tinavete. Gilani Rau sari doduru dia tinasuna. ");
INSERT INTO rug_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Meke gua asa ke gore mae si Rau si pude harupi si arini koari na tie Izipi, meke pude turaṉa vurani, meke turaṉa lani si arini koasa vasina sokua na pepeso nomana, na masuruna, meke toqolo valeania na linetelete, meke vasina sapu koa rina tie Kenani, na tie Hitaiti, na tie Amoraiti, na tie Perizaiti, na tie Hivaiti, meke na tie Zebusaiti kamahire. ");
INSERT INTO rug_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Namu ele avosi Rau sari na kinabokabo tadi na Qua tinoni meke ele dogori Rau sari na tinavete mamata saripu tavete lani rina tie Izipi koarini. ");
INSERT INTO rug_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Ego, kamahire si garunu lanigo Rau si goi koasa baṉara pa popoa Izipi, pude mamu turaṉa vurani koasa nana popoa sari na Qua tie,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Ba zama la koe Tamasa se Mosese, “Lopu garoqu si rau. Vegua meke boka la si rau koasa baṉara, meke turaṉa vurani pa popoa Izipi sari na tie Izireli?” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Meke olaṉa sa Tamasa, “Meke matagutu, kaqu koa koa goi si Rau, meke hie sa vina gilagila sapu garunigo Rau, pana turaṉa vurani goi sari na tinoni pa popoa Izipi si kaqu vahesiau gamu si Rau koasa toqere hie,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Ba olaṉa se Mosese, “Pana la zama guahe si rau koari na tie Izireli, ‘Sa Tamasa tadi na tiatamada si garunu mae nau koa gamu si rau,’ gua, si kote nanasau rini si rau, ‘Esei pozana sia?’ kote gua si arini. Ke nasa si kote boka tozia rau koa rini,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Meke zama sa Tamasa, “Arau si Arau tugo, gua. Meke asa sapu kaqu la tozia goi koa rini, ‘Asa sapu ta pozae Arau, si ele garunau si rau pude atu koa gamu!’ mamu guni,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","“Mu la tozini sari na tie Izireli sapu Arau se Zihova, sa Tamasa tadi rina tiatamadia, meke sa Tamasa te Ebarahami, Aisake meke Zekopi, si garunu la nigo koa rini si goi. Asa sa pozaqu ninae rane ka rane; meke asa sa pozaqu sapu kaqu poza nau rini pa doduru sinage na sage. ");
INSERT INTO rug_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Mu la, mamu varigarani sari na koimata pa Izireli, mamu tozini sapu Arau, Zihova, sa Tamasa tadi na tiatamadia meke sa Tamasa te Ebarahami, Aisake, meke e Zekopi, sapu ele vura koa gamu. Mu tozini sapu ele mae koa rini si Rau, meke ele dogori Rau sapu gua korapa taveti rina tie Izipi koa rini. ");
INSERT INTO rug_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Ele vizatia tu Rau pude kaqu turaṉa vura ni si arini pa popoa Izipi, vasina sapu korapa ta ṉoṉovala si arini, meke kaqu turaṉa lani Rau si arini koasa pepeso masuruna, vasina sapu koa ia ri na tie Kenani, tie Hitaiti, tie Amoraiti, na tie Perizaiti, na tie Hivaiti, meke na tie Zebusaiti. ");
INSERT INTO rug_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Kaqu va avosi rina Qua tinoni sari na mua zinama sapu kaqu zamani goi koa rini. Meke kaqu la turaṉi tugo goi sari na koimata tadi na tinoni Izireli, meke la koasa baṉara pa popoa Izipi meke la zama guahe koasa: ‘Se Zihova, sa Tamasa tadi na tinoni Hiburu si ele mae zama koa gami. Ego mamu va malumu gami pude mami taluarae taloa, padana ka ṉeta rane pa korapa qega, mami la vahesia se Zihova, sa mami Tamasa.’ ");
INSERT INTO rug_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Gilania Qua sapu lopu kaqu va malumu taloa gamu sa baṉara pa popoa Izipi si gamu osolae kaqu ta ososo va ṉiṉira sisigiti si asa, meke tiqe kaqu va malumu gamu sa pude taloa si gamu. ");
INSERT INTO rug_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Ba pana va kilasia Rau sa popoa Izipi pa Qua ṉiniraṉira meke va mataguti si arini vasina, si kaqu tiqe va malumu taloa gamu sa si gamu. ");
INSERT INTO rug_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Meke kaqu pamaṉani gamu rina tinoni Izipi si gamu, meke pana taluarae sari na Qua tinoni, si lopu kaqu kokobadi meke taloa si arini. ");
INSERT INTO rug_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Kaqu la i rina barikaleqe Izireli sari na tie Izipi saripu koa tata koa gamu meke koari na barikaleqe Izipi saripu koa pa dia vetu, meke la tepa poko na qolo na siliva meke kaqu va sageni rina tinoni Izireli koari na tudia koreo na vineki sari na tiṉitoṉa arini, meke kaqu paleke taloa betoni rini sari na tinagotago tadi pa popoa Izipi.” ");
INSERT INTO rug_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Meke olaṉa la ia Mosese, se Zihova, “Vegua, be lopu va hinokarau rina tie Izireli si rau meke lopu hiva avosia rini sapu gua zama nia rau. Meke nasa si kaqu boka tavetia rau, be zama si arini sapu lopu zama koa rau si Goi, gua?” ");
INSERT INTO rug_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Ke nanasia e Zihova si asa, “Nasa si korapa taṉinia goi pa limamu?” Meke olaṉa si asa, “Na kolu hodu,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Meke zama se Zihova, “Mu oki la nia pa pepeso,” gua si asa. Meke sipu oki gore la nia e Mosese pa pepeso, si ta ilirae na noki asa, meke govete nia sa si asa. ");
INSERT INTO rug_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Meke zama la koe Mosese se Zihova, “Qaqama la nia sa limamu, mamu taṉini sage nia pikutuna,” gua si asa. Ke kokopo gore se Mosese meke taṉinia sa si asa, meke ta ilirae na kolu pule. ");
INSERT INTO rug_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Meke zama se Zihova, “Mu tavete gua asa, pude va sosodea koari na tinoni Izireli, sapu se Zihova, sa Tamasa tadi na tiatamamia, sa Tamasa te Ebarahami, Aisake, meke Zekopi si zama koa goi,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Meke zama pule la tugo koe Mosese se Zihova, “Mu vekoa pa korapa mua poko sa limamu,” Meke va tabea Mosese si Asa, meke sipu va vura pulea sa sa limana, si raza ia na minoho popoqu si asa, meke keoro guana sinou sa doduru tinina. ");
INSERT INTO rug_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Meke zama se Zihova, “Mu veko pulea pa korapa poko sa limamu,” gua si Asa. Ke veko pule la nia Mosese sa limana pa korapa nana poko, meke sipu va vura pulea sa sa limana, si via pule kekeṉoṉo puta gua tugo rina tinina si asa. ");
INSERT INTO rug_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Meke zama se Zihova, “Be lopu va hinokarigo rini, ba be lopu va nonoga ia rini sa tinavete variva magasana kekenu, si hierana si keke sapu kote boka va nonoga ia rini. ");
INSERT INTO rug_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Be lopu va hinokari rini sari karua tinavete variva magasadi hire, meke be korodia avosia rini sari na mua zinama saripu zamani goi, si mamu vagi kaiqa kolo pa Ovuku Naelo, mamu titisi gore la nia pa pepeso popana, meke kote ta ilirae ehara sa kolo,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Ba zama se Mosese, “Lokari, Baṉara, Mu lopu garunu lani au koa rini. Namu lopu na tie bokaboka pa zama si rau, seunae gua tu visoroihe meke kamoa kamahire sapu zamau Goi. Mamata na mala meke lopu na tie zama si rau,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Meke zama la koasa sa Tamasa, “Esei ponia ṉuzuna sa tie? Meke esei va nulia meke va pokaia si asa? Meke esei va dodogorae ia na va behua si asa? Arau Zihova mo si Asa. ");
INSERT INTO rug_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Ego, mu la kamahire! Arau kote toka nigo pude boka zama si goi, meke Arau tugo kote tozi nigo sapu kaqu zama nia goi,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Ba olaṉa la koasa se Mosese, “Ke, lokari Baṉara, Mu garunia keke votiki tie pude tavetia sapu gua asa,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Meke tiqe va bugoria Mosese sa Tamasa, meke zama, “Vegua sa tasimu sapu se Eroni, sa tie pa butubutu Livae? Gilania Rau sapu na tie bokaboka pa zama si asa. Meke ele korapa topue mae si asa, pude tutuvigo, meke kote qetu si asa pude dogorigo. ");
INSERT INTO rug_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Boka zama koasa si goi, mamu tozi nia sapu gua kaqu zama nia sa, meke arau kaqu toka betoni gamu pude zama, meke tozini gamu sapu kaqu tavetia. ");
INSERT INTO rug_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Asa sa mua tie zamazama, sapu kaqu zama ponigo koari na tie, meke agoi si guana Tamasa, pude tozi nia sapu kaqu zama nia sa. ");
INSERT INTO rug_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Mamu vagia sa kolu hie, sina kote vata evaṉae nia tinavete variva magasadi goi si asa,” gua se Zihova. ");
INSERT INTO rug_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Meke pule la koasa nana hopehopena, sapu se Zetoro se Mosese meke la tepa guahe, “Va malumau, maqu pule la koari na turaṉaqu pa popoa Izipi, maqu la dogoria be guana korapa toa si arini.” Meke va egoa Zetoro si asa, meke zama, “Leana latu,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Sipu korapa koa nana pa Midiani se Mosese si zama la koasa sa Tamasa, “Mu pule la pa popoa Izipi, sina sari doduru tie pu hiva va mate igo vasina si ele mate beto tu,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Ke turaṉia Mosese sa nana barikaleqe meke sari na tuna koreo, meke va suraṉi sa pa doṉ'ki, meke podalae ene pule la popoa Izipi, meke palekia sa sa kolu hodu sapu tozi nia Tamasa koasa pude palekia. ");
INSERT INTO rug_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Meke zama pule la koe Mosese se Zihova, “Ego, pule la pa popoa Izipi si goi kamahire, meke lopu kaqu muliṉae si goi pude vata evaṉi sari doduru tinavete variva magasadi koasa ṉiniraṉira sapu ele poni nigo Rau pude tavetia pa kenuna sa baṉara. Ba kaqu va ṉiṉira ia Rau sa bulona sa baṉara, meke lopu kaqu va malumi sa sari na tinoni Izireli pude taloa,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","“Meke kaqu tozi nia goi si asa, sapu Arau Zihova si zama guahe: ‘Sa butubutu Izireli sina tuqu koreo sapu podo kenuna,’ mu gunia. ");
INSERT INTO rug_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","‘Meke ele tozi nigo Rau pude vata rupahia sa tuqu koreo hie pude taloa, pude vahesi Au sa si Rau, ba lopu va malumi goi si arini. Ego, kamahire si kaqu va matea Rau sa tumu koreo kenuna,’ mamu gunia,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Koasa inene la te Mosese pa popoa Izipi si noso pa keke vasina magomagogosoana si asa, meke tutuvia Zihova vasina meke tata va matea Sa si asa. ");
INSERT INTO rug_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","26","Meke hena ia sa nana barikaleqe sapu se Zipora si keke patu ṉaruna meke magu pania sa kapu totona sa tuna koreo meke va tiqu la nia sa si asa pa nenena e Mosese. Ba sina koa gua koasa vina hinokarana sa minagu si zama la koe Mosese si asa, “Agoi sina loaqu pa ehara,” gua. Gua asa ke lopu va matea e Zihova se Mosese. ");
INSERT INTO rug_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Meke zama la koe Eroni se Zihova, “Mu la pa korapa qega. Mamu la tutuvia vasina se Mosese,” gua si Asa. Ke ene la tutuvia sa koasa toqere hopena. Meke sipu tutuvia sa, si ahoa pa qinetuqetu meke pa vinarihapahapai. ");
INSERT INTO rug_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Meke tozi lani e Mosese koe Eroni sari doduru gua pu zamani e Zihova koasa sipu garunu pule la nia sa pa Izipi si asa; meke tozi tugo sa koasa sari na tinavete variva magasadi saripu garununi e Zihova pude taveti. ");
INSERT INTO rug_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Ke la varigarani Mosese e Eroni sari doduru koimata tadi na tinoni Izireli. ");
INSERT INTO rug_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Meke vivinei lani e Eroni koa rini sari doduru tiṉitoṉa saripu tozi nia Tamasa koe Mosese. Meke taveti e Mosese sari doduru tinavete variva magasadi pa kenudia ri doduru tie. ");
INSERT INTO rug_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Meke va hinokaria rini si asa. Meke sipu avoso nia rini, sapu ele mae koa rini se Zihova, meke ele dogori sari na dia tinasuna, gua, si hoqa todoṉo si arini meke vahesia rini sa Tamasa. ");
INSERT INTO rug_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Meke sipu beto zama koari na tinoni Izireli sari Mosese e Eroni, si la koasa baṉara pa popoa Izipi sari kara, meke la zama guahe: “Guahe si zamani e Zihova, sa Tamasa tadi na tie Izireli: ‘Mu va malumi goi sari na Qua tie pude taloa, pude di la tavetia si keke inevaṉa vina lavataqu pa korapa qega,’ ” gua. ");
INSERT INTO rug_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Ba zama sa baṉara pa Izipi, “Esei se Zihova? Pude vegua ke kaqu va tabea tu Rau si asa, meke va malumu taloa i sari na tie Izireli? Lopu gilania rau se Zihova, gua asa ke lopu kaqu va malumu taloa i rau si arini.” ");
INSERT INTO rug_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Meke olaṉa sari Mosese e Eroni, “Sa Tamasa tadi na tie Izireli si ele tutuvu soti gami telena. Ke va malumu gami, pude topue ene la pa qega ka ṉeta rane, pude mami vahesia se Zihova sa mami Tamasa. Ba be lopu gua asa, si kote va mate gita Sa pa minoho babe pa vinaripera,” gua sari karua. ");
INSERT INTO rug_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Ba zama la sa baṉara tadi pa Izipi koari Mosese e Eroni, “Na vegua ke hiva turaṉa taloani tu gamu kara sari na tie koari na dia tinavete? Mi pule la koari na mia tinavete. ");
INSERT INTO rug_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Ele soku hola ni gamu sari na tie Izipi, meke kamahire si hiva noso si gamu koari na mia tinavete.” ");
INSERT INTO rug_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Meke koasa rane tugo asa si garuni sa baṉara sari na palabatu Izipi, saripu totolini sari na tie Izireli pa tinavete pinausu meke sari na koimata pa Izireli, pu va enei sari na tinavete, ");
INSERT INTO rug_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","pude di lopu poni duduli popadi sari na tinoni pude tavete biriki, ba kaqu la hata teledia si arini, gua. ");
INSERT INTO rug_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Meke zama si asa, “Ta hivae tugo si arini pude kaqu tavete va soku biriki kekeṉoṉo gua tugo tatasana, meke lopu kaqu hite gore palae si keke biriki. Ba na lopu pada koa rini sa tinavete, gua asa ke korapa tepa vina malumu koa rau si arini, pude taloa dia gua, pude la vahesia sa dia Tamasa, gua. ");
INSERT INTO rug_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Mi la va tavetavete va ṉiṉira i sari na tie hire, mamu va tupiti sisigiti gedi, pude di lopu va avoso la koari na zinama kokohadi sara,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Meke topue la sari na palabatu Izipi meke na tie Izireli pu kopu tinavete, meke la zama guahe koa rini, “Zama guahe sa baṉara, ‘Lopu kaqu ta poni pule duduli popadi si gamu, gua. ");
INSERT INTO rug_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Ba kaqu la hata telemia, vasina boka vagi gamu, ba kaqu soku gua tugo rina biriki pu taveti gamu tatasana si kaqu taveti gamu,’ ” gua si arini. ");
INSERT INTO rug_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Ke la pa doduru vasina pa popoa Izipi sari na tie, meke la hata duduli popadi. ");
INSERT INTO rug_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Ke zama ososoni rina palabatu kopu tinavete sari na pinausu Izireli, pude soku gua tugo rina biriki pu taveti rini tatasana, si kaqu taveti rini doduru rane, kekeṉoṉo gua saripu taveti rini totoso poni duduli popadi rini. ");
INSERT INTO rug_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Meke sekei rina palabatu Izipi sari na tie Izireli pu ta vizatadi pude kopu pa tinavete meke zama, “Na vegua ke lopu soku gua tatasana sari na biriki saripu taveti gamu,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Meke topue la koasa baṉara sari na koimata pa Izireli pa tinavete meke zama, “Baṉara, na vegua ke tavetia tu goi koa gami na mua nabulu sapu guahe? ");
INSERT INTO rug_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Na lopu poni gami duduli popadi goi. Ba korapa ta garunu si gami pude tavete va soku biriki. Meke kamahire si korapa ta seke si gami. Sa sinea si koari na mua tie tu!” gua si arini. ");
INSERT INTO rug_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Ba olaṉa la koa rini sa baṉara, “Na hakohako meke koromia tavetavete si gamu, gua asa ke tepau gamu pude va malumu gamu, pude taloa meke pude la vahesia se Zihova, gua. ");
INSERT INTO rug_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Mi pule la pa tinavete kamahire, sina lopu kaqu ta poni pule duduli popadi si gamu, ba kaqu soku gua tugo rina biriki pu taveti gamu tatasana, si kaqu taveti gamu,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Ego, gilania rina koimata pa Izireli pa tinavete, sapu ele koa pa tinasuna si arini, totoso ta tozi nia rini, sapu kaqu soku gua tugo tatasana sari na biriki saripu kaqu taveti rini koari hopeke rane, gua. ");
INSERT INTO rug_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Meke sipu taluarae koasa baṉara si arini, si la dogori rini sari Mosese e Eroni, korapa turu aqani pa siraṉa. ");
INSERT INTO rug_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Meke la zama guahe koari Mosese e Eroni si arini, “Ele dogoria e Zihova sapu gua ele tavetia gamu kara, meke kaqu va kilasa gamu Sa, sina ele va kukitini gami gamu koasa baṉara meke sari nana palabatu si gami, meke kote tava mate si gita koasa ginugua hie,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Meke zama pule la pule koe Zihova se Mosese, “Ke Tamasa, na vegua ke va tasunai tu Goi sari na tie hire? Meke na vegua ke garunu mae nau Goi tani si rau? ");
INSERT INTO rug_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Seunae gua la zama koasa baṉara si rau, pude zama ponigo, si va tasuna sisigiti sa baṉara sari na tie meke loke tinokae hokara si tavete la nia Goi koari na tie hire,” gua se Mosese. ");
INSERT INTO rug_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Beto asa si zama la koe Mosese se Zihova, “Ego, kamahire si kaqu dogoria goi sapu kaqu tavete la nia Rau koasa baṉara. Kaqu ososo nia Rau pa Qua ṉiniraṉira si asa, pude va malumi sa sari na Qua tinoni pude taloa. Sina koasa ṉiniraṉira mo asa si kaqu va rizu taloa i sa pa nana popoa,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Meke zama gua tugo he sa Tamasa koe Mosese, “Arau se Zihova. ");
INSERT INTO rug_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Arau, sapu zama koe Ebarahami, koe Aisake, meke koe Zekopi sapu Arau sa Tamasa sapu tagoi sari doduru ṉiniraṉira, ba lopu vata gilana nia Rau koa rini sa pozaqu madina, sapu se Zihova. ");
INSERT INTO rug_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Meke Arau tugo tavetia sa Qua vinariva egoi koarini, meke sapu va tatara nia koa rini sa popoa Kenani, sa popoa sapu ele koa ia rini guana tie karovodi. ");
INSERT INTO rug_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Ego, kamahire si ele avosi Rau sari na Qua tinoni Izireli sipu siṉo maṉini pa tinasigiti si arini, saripu ele va pinausi rina tie Izipi, meke ele balabala pulea Rau sa Qua vinariva egoi koarini. ");
INSERT INTO rug_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Ke la mamu tozia koari na tie Izireli, sapu Arau si zama koa rini, meke Arau Zihova si kaqu harupu gamu, meke vata rupaha gamu koasa tinava pinausu koari na tinoni pa popoa Izipi. Kaqu va sagea Rau sa limaqu sapu ṉiṉira hola, pude va kilasa va kaleana hola i si arini, meke kaqu vata rupaha gamu Rau si gamu. ");
INSERT INTO rug_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Meke kaqu vata evaṉaeni gamu na Qua tie soti Rau si gamu. Meke kaqu na mia Tamasa, pana vata rupaha gamu Rau koa sa tinava pinausu pa popoa Izipi. ");
INSERT INTO rug_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Meke kaqu turaṉa lani gamu Rau koasa popoa sapu ele va tatara zoṉazoṉa nia Rau pude vala nia koe Ebarahami, Aisake, meke Zekopi. Meke Arau, sa Tamasa Zihova si kaqu vatua si asa koa gamu, pude na mia tinago soti,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Ke la tozia Mosese koari na tie Izireli saripu gua asa, ba korodia avosia rini si asa, sina ele tava malohoro sari na maqomaqodi koasa dia tinava pinausu kaleana hola. ");
INSERT INTO rug_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Beto asa si zama la koe Mosese se Zihova, ");
INSERT INTO rug_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“La, mamu tozi nia sa baṉara pa Izipi, pude kaqu va malumi sari na tinoni Izireli pude taluarae koasa nana popoa.” ");
INSERT INTO rug_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Ba zama la koe Zihova se Mosese, “Pude la tozini sari na tinoni Izireli ba kote korodia avosau rini, ke pude vegua sa baṉara Izipi, sina na lopu na tie bokaboka pa zinama si rau,” gua se Mosese. ");
INSERT INTO rug_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Ba zamai e Zihova sari Mosese e Eroni, pude la tozini sari na tinoni Izireli meke sa baṉara pa popoa Izipi, sapu “Arau garunu gamu si gamu pude turaṉa vurani sari na tinoni Izireli pa popoa Izipi.” ");
INSERT INTO rug_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Se Rubeni, sa tuna kenuna e Zekopi, si ka made tuna koreo, sapu ari Hanoki, e Palu, e Hezironi meke e Kami; arini sari na tiatamadia rina butubutu sapu ta pozae koari na pozadia. ");
INSERT INTO rug_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Se Simione si ka onomo tuna koreo: Ari Zemuela, e Zamini, e Ohadi, e Zakini, e Zohara meke Saulu. E Saulu si va podo nia sa koa keke barikaleqe Kenani. Arini sari na tiatamadia rina butubutu sapu ta pozae luli koari na pozadia. ");
INSERT INTO rug_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Se Livae si ka ṉeta tuna koreo: Ari Qerisoni, e Kohati, meke Merari. Arini sari na tiatamadia rina butubutu sapu ta pozae luli koari na pozadia. Meke se Livae si keke gogoto toloṉavulu zuapa vuahenina meke mate si asa. ");
INSERT INTO rug_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Se Qerisoni si karua tuna koreo: Ari Libini meke Simei, meke sokudi tugo sari na tudia rini. ");
INSERT INTO rug_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Se Kohati si ka made tuna: Ari Amaramu, e Izihara, e Heboroni, meke Uzieli. Meke se Kohati si koa keke gogoto toloṉavulu ṉeta vuahenina. ");
INSERT INTO rug_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Se Merari si karua tuna koreo: Ari Mahili, meke Musi. Arini sari na butubutu Livae meke sari na tudia rini. ");
INSERT INTO rug_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Ego, haba ia Amaramu sa tasina barikaleqe sa tamana, sapu se Zokebedi. Meke va podo nia sa koasa se Eroni meke se Mosese. Meke se Amaramu si toa keke gogoto toloṉavulu zuapa vuahenina meke mate. ");
INSERT INTO rug_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Se Izihara si ka ṉeta tuna koreo: Ari Kora, e Nepeqi meke Zikiri. ");
INSERT INTO rug_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Se Uzieli ba ka ṉeta tuna koreo: Ari Misaelo, e Elozapani meke e Sitiri. ");
INSERT INTO rug_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Haba ia Eroni se Eliseba, sa tuna vineki e Aminadabi sapu sa vavenena e Nasoni; meke va podo nia sa koasa se Nadabi, e Abihu, e Eleaza meke e Itamara. ");
INSERT INTO rug_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Se Kora si ka ṉeta tuna koreo: Ari Asire, Elikana, meke Abiasapi. Arini sari na tiatamadia koari na pinaqaha butubutu te Kora. ");
INSERT INTO rug_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Ego se Eleaza, sa tuna koreo e Eroni, si haba ia sa si keke tuna vineki e Putiela, meke va podo nia sa koasa se Pinehasi. Arini sari na ṉati palabatu koari na puku tatamana meke sari na butubutu te Livae. ");
INSERT INTO rug_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Meke koari Eroni e Mosese si zama guahe se Zihova, “Mi turaṉa vurani sari na butubutu Izireli pa popoa Izipi,” gua. ");
INSERT INTO rug_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Meke arini tugo sari na tie sapu tozi nia sa baṉara pa popoa Izipi, pude vata rupahi sari na tinoni Izireli, gua. ");
INSERT INTO rug_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Meke sipu zama se Zihova koe Mosese pa popoa Izipi, ");
INSERT INTO rug_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","si zama guahe si Asa, “Arau se Zihova. Mu la tozi koasa baṉara pa popoa Izipi sari doduru tiṉitoṉa saripu tozi nigo Rau,” gua. ");
INSERT INTO rug_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Ba olaṉa la koasa se Mosese, “Ele gilanau Mua mo, sapu lopu na tie bokaboka pa zama si rau, ke lopu boka avosau sa baṉara si rau,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Meke zama la koe Mosese se Zihova, “Kaqu vata evaṉae gunigo Rau e Tamasa koasa baṉara si goi, meke se Eroni sa tasimu, si kaqu zama ponigo koasa baṉara guana mua poropita si asa. ");
INSERT INTO rug_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Mamu tozi koe Eroni sari doduru tiṉitoṉa saripu zamani Rau koa goi meke kaqu tozi sa koasa baṉara, pude va malumu taloai sari na tie Izireli pa nana popoa. ");
INSERT INTO rug_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","4","Kote sokudi sari na tinavete variva matagutudi saripu taveti Rau pa popoa Izipi, ba kote va luli nia Rau nana hiniva sa baṉara, meke lopu kaqu hiva avoso gamu sa. Ba kaqu va kilasa sisigitia Rau sa popoa Izipi, beto asa meke kaqu turaṉa vurani Rau sari na Qua tinoni koasa popoa asa. ");
INSERT INTO rug_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Meke kaqu gilania rina tinoni pa popoa Izipi sapu Arau se Zihova, sapu tubehi si arini sipu va sagea Rau sa limaqu meke turaṉa vurani sari na tinoni Izireli pa popoa Izipi.” ");
INSERT INTO rug_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Meke vata evaṉa betoi Mosese, e Eroni sapu gua zamani e Zihova. ");
INSERT INTO rug_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Ka vesu ṉavulu puta vuahenina se Mosese, meke ka vesu ṉavulu ṉeta vuahenina se Eroni pa totoso sipu zama koe Pero sa baṉara si arini. ");
INSERT INTO rug_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Meke zama la koari Mosese e Eroni se Zihova, ");
INSERT INTO rug_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Be hiva vina sosode sa baṉara pude tavetia si keke tinavete variva magasana, si mamu zama ia se Eroni, pude vagia sa nana kolu hodu. Mani oki gore nia pa kenuna sa baṉara, meke kaqu ta ilirae noki si asa.” ");
INSERT INTO rug_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Ke topue la koasa baṉara sari Mosese e Eroni, meke taveti saripu gua garununi e Zihova. Gona gore nia Eroni sa nana kolu hodu pa kenuna sa baṉara meke sari nana palabatu, meke ta ilirae noki si asa. ");
INSERT INTO rug_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Meke tioki tugo sa baṉara sari nana tie tumatumaedi na tie vakuvakutae, meke koasa dia tinavete sekesekei si tavete kekeṉoṉo puta gua tugo asa si arini. ");
INSERT INTO rug_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Oki goreni rini sari na dia kolu hodu, meke ta ilirae noki si arini. Ba la sa kolu hodu te Eroni meke onolo betoi sapu tadirini. ");
INSERT INTO rug_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Ba namu lulia sa baṉara sa nana hiniva soti, gua puta tugo sapu zama nia e Zihova, meke korona avosi sa sari Mosese e Eroni. ");
INSERT INTO rug_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Meke zama la koe Mosese se Zihova, “Namu lulia nana hiniva sa baṉara meke korona va taloai sa sari na tinoni Izireli. ");
INSERT INTO rug_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Ke mamu la munumunu, pude tutuvia si asa, pana ene gore la si asa koasa Ovuku Naelo. Mamu palekia sa kolu hodu sapu ilirae noki, mamu la aqa nia si asa pa taqelena sa ovuku. ");
INSERT INTO rug_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Mamu zama guahe koasa baṉara, ‘Se Zihova, sa Tamasa tadi na tinoni Hiburu, si garunau si rau pude tozi nigo, pude va taloa i sari Nana tie, pude la vahesia rini si Asa pa korapa qega. Ba kamoa kamahire si lopu ele va malumi goi si arini. ");
INSERT INTO rug_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Ego, guahe si zama nia e Zihova: Kaqu gilania goi kamahire esei si Arau koasa tinavete hie sapu kaqu tavetia Rau. Kaqu seke nia kolu hodu Rau sa beruna sa kolo, meke kaqu ta ilirae ehara si asa. ");
INSERT INTO rug_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Meke kaqu mate beto sari na igana, meke kaqu humaṉa hikare sisigiti sa kolo, meke lopu kaqu boka napoa rina tinoni pa popoa Izipi si asa.’ ” ");
INSERT INTO rug_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Meke zama la koe Mosese se Zihova, “Mu tozi nia se Eroni pude taṉini va ululia sa nana kolu hodu koari doduru leana, na kolo pa gineli kolo tototolo pepeso, meke sari na kopi pa popoa Izipi. Meke sari na vovoina saripu ta tavetae huda, meke sari na zagi patu tugo, ba kaqu ta ilirae ehara sa kolo, meke kaqu tale eharana mo sa doduruna sa popoa,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Meke tavetia ri Mosese e Eroni sapu gua garunu nia e Zihova koari kara. Ovulu sage nia Eroni sa nana kolu hodu pa kenuna sa baṉara, meke sari nana palabatu, meke sekea sa sa beru kolo koasa ovuku, meke ta ilirae ehara beto sari doduru kolo. ");
INSERT INTO rug_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Meke mate beto sari doduru igana pa kolo meke humaṉa hikare sisigiti, meke lopu boka napoa rina tinoni pa popoa Izipi sa kolo, meke doduru vasina pa popoa Izipi, si tale eharana mo. ");
INSERT INTO rug_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Beto asa, si tavete kekeṉoṉo puta gua tugo asa sari na tie vakuvakutae koari na dia tinavete sekesekei, ke luli nana hiniva mo sa baṉara. Kekeṉoṉo gua puta tugo sapu ele zama nia e Zihova, si korona avosi sa baṉara sari Mosese meke se Eroni. ");
INSERT INTO rug_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Ba pule la nana pa nana vetu baṉara, meke lopu hiva va gunagunana nia sa gua sapu ta evaṉa. ");
INSERT INTO rug_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Meke gelia ri doduru tinoni pa popoa Izipi sa taqelena sa ovuku, pude napo gua, sina lopu boka napoa rini sa kolo koasa ovuku. ");
INSERT INTO rug_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Ka zuapa rane si ele hola gua sipu sekea e Zihova sa kolo. ");
INSERT INTO rug_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Meke zama la koe Mosese se Zihova, “Mu la koasa baṉara, mamu tozi nia, sapu zama guahe se Zihova, ‘Mu va malumi sari na Qua tinoni pude taloa, pude boka vahesiau rini si Rau. ");
INSERT INTO rug_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Be koromu va malumi goi si arini, si kote va siṉi nia bakarao Rau sa doduruna sa mua popoa pude va kilasigo. ");
INSERT INTO rug_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Kaqu siṉia na bakarao sa Ovuku Naelo, meke kaqu taluarae si arini vasina, meke atu pa korapa mua vetu baṉara pa korapa mua lose putaputana, pa korapa mua teqe, meke koari na vetu tadi na mua palabatu meke sari na mua tinoni, meke koari na mua kinakinana bereti, meke koari na vovoina bereti. ");
INSERT INTO rug_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Meke kaqu horu sagego rini si goi, meke sari na mua tinoni, meke sari doduru mua palabatu pa qinavuna.’ ” ");
INSERT INTO rug_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Meke zama la koe Mosese se Zihova, “Mu tozi nia se Eroni pude taṉini va ululu sage nia sa nana kolu, koari na ovuku na kolo tototolo, meke sari na kopi, pude mae va siṉia rina bakarao sa doduruna sa popoa Izipi.” ");
INSERT INTO rug_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Ke taṉini va ululu sage nia Eroni sa nana kolu koari doduru kolo, meke vura mae sari na bakarao meke siṉia rini sa popoa Izipi. ");
INSERT INTO rug_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Ba sari na tie vakuvakutae si tavete sekesekei, meke arini ba va vura maei tugo pa popoa sari na bakarao. ");
INSERT INTO rug_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Meke tioki sa baṉara sari Mosese e Eroni meke zama, “Mi tepa la ia se Zihova pude vagi va seui sari na bakarao hire, meke kote va malumu taloai rau sari na mia tie, pude boka vahesia se Zihova,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Meke olaṉa se Mosese, “Kote qetu si rau pude varavara toka nigo. Ba kote tozi nau goi sa totoso pude maqu varavara toka nigo meke sari na mua palabatu na tinoni. Meke kote tava beto sari na bakarao, meke namu loketoṉa hokara si kaqu koa hola, ba pa Ovuku Naelo mo.” ");
INSERT INTO rug_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Meke olaṉa sa baṉara, “Vugo, mamu varavara toka nau,” gua si asa. Meke zama se Mosese, “Ego leana, kote tavetia rau sapu gua tepa ia goi, meke kaqu gilania goi sapu loke Tamasa pule sapu kekeṉoṉo gua e Zihova, sa mami Tamasa. ");
INSERT INTO rug_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Kaqu loke bakarao si kaqu koa koa goi, meke koari na mua palabatu na tinoni. Meke namu loketoṉa hokara si kaqu koa hola, ba pa Ovuku Naelo mo,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Beto sapu gua asa, si taluarae koasa baṉara sari Mosese e Eroni, meke varavara la koe Zihova se Mosese pude vagi pani sari na bakarao saripu garunu lani Sa koasa baṉara. ");
INSERT INTO rug_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Meke va tabea e Zihova sa tinepa te Mosese, meke mate beto sari doduru bakarao koari na vetu, na vasivasileana, meke koari doduru inuma. ");
INSERT INTO rug_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Meke sara varigarani rina tie Izipi sari na bakarao koari na kobi nomadi, osolae humaṉa hikare sa popoa. ");
INSERT INTO rug_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Meke sipu dogoria sa baṉara sapu ele mate beto sari doduru bakarao, si luli pule nana hiniva si asa, gua puta tugo sapu ele zama nia Zihova, sapu lopu kaqu hiva avosi sa sari Mosese e Eroni, gua. ");
INSERT INTO rug_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Meke zama la koe Mosese se Zihova, “Mu tozi nia se Eroni pude seke va kavuru nia kolu sa sa pepeso, meke kaqu ta ilirae nikuniku sari na kavuru pa doduruna sa popoa Izipi,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","18","Ke vagia Eroni sa nana kolu hodu, meke seke va kavuria sa sa pepeso, meke ta evaṉae nikuniku sari na kavuru pa popoa Izipi, meke tale nikunikudi sari na tie meke sari na kurukuru ṉame, na gua, pa doduru vasina. Meke podepodeki rina tie vakuvakutae sari na dia tinavete sekesekeidi, pude va vura maei sari na nikuniku gua, ba lopu boka si arini. ");
INSERT INTO rug_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Meke zama la koasa baṉara sari na tie vakuvakutae, “E Tamasa mo tavetia sapu guahe.” Ba lulia nana hiniva sa baṉara, meke kekeṉoṉo gua tugo sapu ele zama nia e Zihova. Meke lopu hiva avosi sa baṉara sari Mosese e Eroni. ");
INSERT INTO rug_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Meke zama la koe Mosese se Zihova, “Vugo munumunu hokara si mamu la tutuvia sa baṉara, sipu la si asa pa ovuku. Mamu la tozi nia si asa sapu zama guahe se Zihova, ‘Mu va malumu taloai sari na Qua tie, pude boka vahesiau rini. ");
INSERT INTO rug_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Be koromu va malumi goi, si kaqu garunu atuni Rau koa goi sari na dodoa meke va kilasigo si agoi, meke sari na mua palabatu na mua tinoni. Kaqu siṉi i na dodoa sari na vetu tamugamu pa popoa Izipi, meke sa doduruna sa pepeso tugo. ");
INSERT INTO rug_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Ba kaqu veko hola ia Rau sa kali popoa pa Qoseni, vasina sapu koa sari na Qua tinoni, ke lopu kaqu koa vasina sari na dodoa. Gua asa si kaqu tavetia Rau, pude kaqu gilania gamu na tie Izipi sapu Arau, e Zihova, sapu korapa tavetavete pa popoa Izipi. ");
INSERT INTO rug_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Sapu gua kaqu tavetia Rau si kote votikaena, pa varikorapadi ri na Qua tinoni, meke sari na mua tinoni. Sa tiṉitoṉa variva magasana hie si kaqu ta evaṉa vugo.’ ” ");
INSERT INTO rug_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Meke garunu va nuquria e Zihova sa rovana dodoa lavata pa korapa vetu lavata tanisa baṉara meke sari na vetu tadi nana palabatu. Meke sa doduruna sa popoa tadi na tie Izipi si ta ṉovala koari na dodoa. ");
INSERT INTO rug_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Meke tioki sa baṉara sari Mosese, e Eroni, meke zama, “Mi la mamu vahesia sa mia Tamasa pa popoa hie,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Meke olaṉa se Mosese, “Lopu toṉoto pude tavetia gami sapu gua asa, sina lopu kaqu hiva nia rina tinoni pa popoa Izipi si pude va vukivukihi lani gami koe Zihova sa mami Tamasa sari na kurukuru. Meke be dogoro gami rina tinoni pa popoa Izipi sapu va vukivukihi ni gami sari na kurukuru, si kote gona va mateni gami patu rini si gami. ");
INSERT INTO rug_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Ba kaqu ka ṉeta rane si kaqu enea gami pa korapa qega pude vahesia se Zihova sa mami Tamasa, gua puta tugo sapu ele zama nia Sa koa gami,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Meke zama sa baṉara, “Leana, kaqu va malumu gamu rau si gamu, pude la vahesia se Zihova, sa mua Tamasa pa korapa qega, be guana lopu ene va seu sisigiti la si gamu, mamu varavara toka nau,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Meke olaṉa se Mosese, “Pana taluarae si rau, si kaqu varavara la koe Zihova si rau, pude pa rane vugo si kaqu va taloai Sa koa goi sari na dodoa, meke koari mua palabatu na mua tinoni, ba mamu lopu kokoha pule gami, meke va nosoi sari na tinoni pude la vahesia se Zihova,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Beto asa si taluarae koasa baṉara se Mosese, meke varavara la koe Zihova. ");
INSERT INTO rug_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Meke va tabea Zihova sapu gua tepa ia Mosese koa Sa, meke taluarae koasa baṉara meke koari nana palabatu na tinoni sari na dodoa. Meke namu lopu hite keke dodoa si koa hola. ");
INSERT INTO rug_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Ba koasa totoso hie, si luli nana hiniva tugo sa baṉara, meke lopu va malumu pulei sa sari na tinoni pude taloa. ");
INSERT INTO rug_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Beto asa, si zama la koe Mosese se Zihova, “Mu la koasa baṉara, mamu zama gua he: ‘Se Zihova sa Tamasa tadi na tie Hiburu si zama: Mu va malumi sari na Qua tie pude taloa, pude la vahesi Au rini,’ mu gunia. ");
INSERT INTO rug_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","‘Ego, be koromu va malumu taloa pulei tugo goi si arini, ");
INSERT INTO rug_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","si kaqu garunu atunia Rau si keke minoho kaleana sisigiti koari doduru mia kurukuru, koari na hose na doṉ'ki, na kameli, na bulumakao, na sipi, meke na qoti pude va kilasigo. ");
INSERT INTO rug_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Kaqu paqaha vata kalei Rau sari na kurukuru tadi na tinoni Izireli, koari pu tadi na tinoni pa popoa Izipi, meke loketoṉa kurukuru tadi na tinoni Izireli si kaqu mate. ");
INSERT INTO rug_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Meke Arau Zihova, ele muti vekoa pa rane vugo sa totoso sapu kaqu tavetia Rau sapu gua asa.’ ” ");
INSERT INTO rug_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Meke pa koivugona asa, si tavetia e Zihova sapu gua ele zama nia Sa, meke mate beto sari doduru kurukuru tadi na tinoni pa popoa Izipi, lopu keke koari na kurukuru tadi na tinoni Izireli si mate. ");
INSERT INTO rug_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Meke nanasa nia sa baṉara sapu ta evaṉa, meke tozi nia rina tie sapu loke kurukuru tadi na tinoni Izireli si mate, gua. Ba lulia nana hiniva sa baṉara meke lopu va malumi sa sari na tinoni Izireli pude taloa. ");
INSERT INTO rug_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Meke zama la koari Mosese e Eroni se Zihova, “Sara vagi eba pa vasina susuluana, meke kaqu taburu sageni e Mosese si arini pa galegalearane pa kenuna sa baṉara. ");
INSERT INTO rug_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Meke kaqu tale kavuruna sa doduru popoa Izipi, meke kaqu razai na moqo na tubu leradi sari na tinoni meke sari na kurukuru.” ");
INSERT INTO rug_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Ke vagi eba sari karua meke la turu pa kenuna sa baṉara, meke taburuni e Mosese pa galegalearane si arini, meke razai na moqo na tubu leradi sari na tinoni meke sari na kurukuru. ");
INSERT INTO rug_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Meke lopu vura la turu pa kenuna e Mosese sari na tie vakuvakutae, sina raza betoi na moqo, kekeṉoṉo puta gua tugo rina tinoni pa popoa Izipi si arini. ");
INSERT INTO rug_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Ba va luli nia nana hiniva Zihova sa baṉara, gua tugo sapu ele zama nia Sa tatasana, meke lopu hiva avosi sa baṉara sari Mosese e Eroni. ");
INSERT INTO rug_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Beto asa, si zama la koe Mosese se Zihova, “Mu la munumunu hokara, mamu tutuvia sa baṉara, mamu tozi nia sapu se Zihova, sa Tamasa tadi na tinoni Hiburu si zama guahe: ‘Mu va malumu taloa i sari na Qua tinoni, pude la vahesi Au rini si Arau,’ mamu gunia. ");
INSERT INTO rug_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","‘Ego, kamahire si lopu tale sari na mua palabatu, meke sari na mua tinoni, si kaqu va kilasi Rau, ba agoi tugo si kaqu va kilasigo Rau, pude mamu gilania sapu loke Tamasa pa doduruna sa kasia popoa si kekeṉoṉo gua Arau. ");
INSERT INTO rug_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Be va sagea Rau sa limaqu meke va raza nigo minoho Rau, meke sari na mua tie, si kote ele mate beto tu si gamu doduru! ");
INSERT INTO rug_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Ba pude va dogoroni gamu sa Qua ṉiniraṉira gua, ke va baṉarigo Rau si goi, pude tavetavete nigo na vata dogoro nia Qua ṉiniraṉira, meke vata gilana nia sa Pozaqu koasa doduruna sa kasia popoa, gua. ");
INSERT INTO rug_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Ba sina korapa vahesi pulenigo si goi meke koromu va malumu taloai sari na Qua tinoni. ");
INSERT INTO rug_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Ego kamahire pa rane vugo, si kaqu va gorea Rau, guana ruku lavata pa galegalearane, sari na kabukabue aesi sapu lopu ele hite ta gilana koari na tie pa popoa Izipi. ");
INSERT INTO rug_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Ego, mamu vatanai sari na mia rovana kurukuru, meke sari doduru mia likakalae, saripu koa pa ninae sada. Mamu vekoi pa aqoro. Ura sari na tinoni na kurukuru pu koa pa sada meke lopu ta kopue si kaqu hoqa va mate betoi na kabukabue aesi pu hoqa mae guana ruku pa galegalearane.’ ” ");
INSERT INTO rug_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Meke kaiqa ri na palabatu tanisa baṉara, si matagutu nia sa zinama te Zihova ke va aqori rini pa dia vetu sari na dia pinausu tie, na kurukuru, na gua. ");
INSERT INTO rug_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Ba kaiqa arini, si lopu hiva va gunagunana nia sa vina balau te Zihova, meke veko pani mo rini pa sada sari na dia pinausu tie meke sari na kurukuru. ");
INSERT INTO rug_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Meke zama la koe Mosese se Zihova, “Mu huhuku sage la nia pa galegalearane sa limamu, meke kaqu hoqa gore mae guana ruku pa popoa Izipi, meke koari na tie na kurukuru, meke koari doduru linetelete koari na inuma sari na kabukabue aesi,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Ke huhuku sage la nia Mosese pa galegalearane sa nana kolu hodu, meke garunia e Zihova sa paka maṉauru meke hoqa gore sari na kabukabue aesi meke hidaia na kapi sa pepeso meke gore mae, ");
INSERT INTO rug_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","guana ruku lavata sari na kabukabue aesi, saripu garununi e Zihova, meke hida lamae sari na kapi. Keke raneboṉi kaleana hola si asa hola ni sari doduru raneboṉi sapu ta gilana pa popoa Izipi. ");
INSERT INTO rug_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Meke zalo va kaleana i na ruku aesi sari doduru likakalae koari doduru vasina pa popoa Izipi, meke gua tugo sari doduru tinoni na kurukuru, meke hoqa beto sari doduru linetelete koari na inuma, meke sari doduru elelo huda si hoqa beto pa pepeso. ");
INSERT INTO rug_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Sa kali popoa Qoseni mo telena sapu koa ia rina tinoni Izireli, si lopu raza ia na raneboṉi aesi. ");
INSERT INTO rug_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Meke garunu lani zinama sa baṉara sari Mosese e Eroni, meke zama, “Kamahire si ele gilania rau sapu sea si rau, meke e Zihova mo si toṉoto. Arau meke sari na qua tinoni si sea. ");
INSERT INTO rug_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Ele pada mo koa gami sa raneboṉi aesi na paka maṉauru, ke mamu varavara la koe Zihova! Kaqu zama va hinokara si rau, pude taloa si gamu, meke lopu kaqu koa seunae tani si gamu,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Meke zama la koasa baṉara se Mosese, “Pana taloa tugo si rau koasa vasileana lavata, si kaqu huhuku sage la nia rau koe Zihova sa limaqu pa vinaravara, meke kaqu noso sa paka maṉauru, meke kote bule sa raneboṉi aesi, pude kaqu gilania gamu sapu te Zihova sa popoa pepeso. ");
INSERT INTO rug_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Ba gilania rau sapu agoi meke sari na mua palabatu, si lopu ele matagutu nia se Zihova, sa Tamasa.” ");
INSERT INTO rug_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Sari na linetelete sapu hoke taveteni poko lineni, meke sari na bale si ta ṉovala beto, ura na komiha sari na bale, meke sari na linetelete sapu hoke ta tavete ni poko lineni si lopu ele poraka havorodi. ");
INSERT INTO rug_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Ba loketoṉa huiti d si ta ṉovala, sina lopu tuture komiha si asa. ");
INSERT INTO rug_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Meke taluarae koasa baṉara se Mosese, meke vura taloa koasa vasileana lavata. Meke tiqe va sagei sa sari na limana meke varavara la koe Zihova. Meke noso sa paka maṉauru, meke sa hoqadi rina kabukabue aesi, meke sa ruku si noso beto. ");
INSERT INTO rug_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Meke sipu dogoria sa baṉara sapu gua ta evaṉa, si va sea pule si asa. Meke luli dia hiniva, gua tugo doduru totoso. ");
INSERT INTO rug_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Kekeṉoṉo gua tugo sapu ele zama nia e Zihova koe Mosese, sapu lopu kaqu va malumu taloa i sa baṉara sari na tinoni Izireli, gua. ");
INSERT INTO rug_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Beto asa, si zama la koe Mosese se Zihova, “La mamu dogoria sa baṉara, ura ele va luli nia nana hiniva Rau si asa, meke gua tugo sari nana palabatu pude maqu taveti koa rini sari na tiṉitoṉa variva magasadi hire. ");
INSERT INTO rug_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Pude boka vivineini gamu koari na tumia, na tudia rina tumia, gua meke va duviduvili Rau sari na tie pa popoa Izipi, totoso taveti Rau sari na tiṉitoṉa variva magasadi. Meke kaqu gilania gamu doduru sapu Arau se Zihova.” ");
INSERT INTO rug_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Ke topue la koasa baṉara sari Mosese e Eroni, meke zama, “Se Zihova, sa Tamasa tadi na tie Hiburu si zama guahe: ‘Ve kote seunae gua meke kaqu koromu pude va tabe Au goi? Mu va malumu taloai sari na Qua tie, pude kaqu vahesi Au rini, gua. ");
INSERT INTO rug_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Ego, be korapa koromu va malumi tugo goi si arini, pude va taloai gua, si kaqu va atui Rau vugo pa korapa mua popoa sari na kupokupo. ");
INSERT INTO rug_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Kaqu soku hola si arini, meke kaqu opo tamunia sa pepeso, meke gani betoi rini sari na huda saripu koa hola, meke sari doduru tiṉitoṉa saripu lopu va matei rina kabukabue aesi saripu hoqa gore mae guana ruku pa galegalearane. ");
INSERT INTO rug_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Meke kaqu siṉi rini sari na vetu tadi na tie nomadi, meke sari doduru vetu tadi na mua tinoni. Kaqu kaleana hola nia rini sa tiṉitoṉa sapu ele hoke dogoria ri na tiatamamia pukerane,’ ” gua si asa. Meke taliri vura taloa se Mosese. ");
INSERT INTO rug_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Meke zama la koasa baṉara sari nana palabatu, “Ve seunae gua si kaqu poni gita tinasuna sa tie hie si gita? Va taloai mo sari na tie, pude boka vahesia rini se Zihova sa dia Tamasa. Vegua lopu gilania goi sapu ele ta ṉovala sisigiti sa popoa Izipi,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Ke ta turaṉa pule la koasa baṉara sari Mosese e Eroni, meke zama la koa rini si asa, “Boka taloa si gamu, mamu vahesia se Zihova sa mia Tamasa. Mamu tozi nau sapu ari sei si boka taloa?” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Meke olaṉa se Mosese, “Gami doduru si kaqu taloa, sari mami koburu, meke sari na mami barogoso na kaleqe. Kaqu turaṉi tugo gami sari na mami bulumakao, sina kote tavetia gami si keke inevaṉa pude va lavatia se Zihova,” gua se Mosese. ");
INSERT INTO rug_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Meke zama sa baṉara, “Zama hinokara si arau koe Zihova, sapu namu lopu kaqu va malumigo rau, pude turaṉi sari na mia barikaleqe na koburu! Ele ta gilana valeana, sapu korapa kuhana nia gamu si keke hiniva kaleana pude vura taloa beto pa popoa Izipi. ");
INSERT INTO rug_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Namu lokari hokara! Gamu na tie mo si kaqu taloa, meke vahesia se Zihova,” gua. Meke tupele vurani rini pa kenuna sa baṉara sari Mosese e Eroni. ");
INSERT INTO rug_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Beto sapu gua asa, si zama la koe Mosese se Zihova, “Ego, mu ovulu va sage nia sa limamu pa popoa Izipi, pude va maei sari na kupokupo. Kaqu mae gani betoi rini sari doduru likakalae saripu toqolodi, meke sari doduru likakalae saripu veko hola i rina kabukabue aesi saripu hoqa gore mae guana ruku pa galegalearane,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Ke ovulu va sagea e Mosese sa nana kolu hodu, meke va givusu maea e Zihova sa givusu gevasa, meke raza koasa popoa koasa doduruna sa rane meke boṉi. Meke pana munumunu si tava mae sari na kupokupo. ");
INSERT INTO rug_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Meke mae koari na rovana si arini, meke koa koasa doduruna sa popoa. Meke nomana lavata sa rovana kupokupo asa, sapu lopu ele hite ta dogoro, babe sapu lopu kaqu hite ta dogoro pule kaiqa rane. ");
INSERT INTO rug_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Meke opo betoa mo rini sa doduru pepeso, osolae muho toa nana sa popoa. Meke gani betoi rini sari doduru likakalae, meke sari doduru vuadi ri na huda, saripu veko hola i rina kabukabue aesi, saripu hoqa gore mae guana ruku lavata pa galegalearane. Meke namu loke elelo buma hokara si hite koa koa keke huda babe linetelete pa doduru vasina pa popoa Izipi. ");
INSERT INTO rug_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Meke tuture tioki sa baṉara sari Mosese e Eroni meke zama, “Ele tavete va sea si rau koe Zihova sa mia Tamasa, meke koa gamu. ");
INSERT INTO rug_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Ego, mamu taleoso nia sa qua sinea kamahire, mamu varavara la koe Zihova sa mia Tamasa, pude vagi va seu ia sa vina kilasa lavata hie koa rau,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Meke taluarae koasa baṉara se Mosese, meke varavara la koe Zihova. ");
INSERT INTO rug_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Meke hobe la nia givusu togarauru, sapu ṉiṉira hola e Zihova sa givusu gevasa, sapu vagi taloa ni meke paleke lani koasa koqu lavata Suezi sari na kupokupo, meke lopu keke kupokupo si koa hola pa doduruna sa popoa Izipi. ");
INSERT INTO rug_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Ba va luli nia nana hiniva e Zihova sa baṉara, meke lopu va malumi sa sari na tinoni Izireli pude taloa. ");
INSERT INTO rug_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Beto asa, si zama la koe Mosese se Zihova, “Mamu ovulu sage la nia pa galegalearane sa limamu, meke kaqu opo tamunia na hinuporo sa doduruna sa popoa Izipi sa moatana gua sa huporo asa si variva matagutu na huporo sisigiti,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Meke ovulu sage nia e Mosese pa galegalearane sa limana, meke huporo toa nana koari ka ṉeta rane sa doduru vasina pa popoa Izipi. ");
INSERT INTO rug_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Meke lopu boka varidogori sari na tinoni pa popoa Izipi, ke lopu boka vura pa dia vetu koasa totoso asa. Ba sa kalalasa si koa nana, vasina sapu koa ri na tinoni Izireli. ");
INSERT INTO rug_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Meke tiokia sa baṉara se Mosese meke zama, “Kaqu taloa beto si gamu doduru; mamu la vahesia se Zihova. Kaqu turaṉa betoi gamu sari na mia barikaleqe na koburu. Ba sari na mia sipi, na qoti meke sari na mia bulumakao si kaqu veko hola i gamu tani,” gua sa baṉara. ");
INSERT INTO rug_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Meke olaṉa se Mosese, “Ego, be gua asa si kaqu poni gami kurukuru goi, si gami pude mami va vukivukihi va uququ la koe Zihova, sa mami Tamasa. ");
INSERT INTO rug_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Namu lokari, kaqu turaṉa betoi gami sari na mami kurukuru, meke loketoṉa si kaqu ta veko palae. Sina gami telemami si kaqu vizati sari na kurukuru pude tana mami vinahesi koe Zihova, sa mami Tamasa. Lopu kaqu gilania gami, sapu na kurukuru sa si kaqu vahesi la nia gami koa Sa, osolae kamo si gami vasina,” gua se Mosese. ");
INSERT INTO rug_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Meke va luli nia nana hiniva e Zihova sa baṉara, meke lopu va malumu taloai sa si arini. ");
INSERT INTO rug_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Meke zama la koe Mosese si asa, “Mu vura taloa! Lopu hiva dogoro puleigo rau! Koasa rane dogorigo rau, si kaqu mate si goi!” gua sa baṉara. ");
INSERT INTO rug_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Meke olaṉa se Mosese, “Toṉoto mate si gunia goi. Lopu kaqu dogoro puleau goi,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Beto asa, si zama la koe Mosese se Zihova, “Keke pule mo vina kilasa si kaqu garunu atu nia Rau koasa baṉara, meke koari nana tie pa popoa Izipi. Meke pa mudina asa si kaqu va malumu gamu sa, pude taloa. Kaqu hitu taloa zoṉazoṉani gamu sa si gamu doduru pude taloa tani. ");
INSERT INTO rug_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Ego, mamu zamai sari na tinoni Izireli, mamu tozini sari doduru pude tepa dia qolo na siliva koari na tie Izipi pu koa tata koa rini,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Meke va lavalavata poni lani e Zihova koari na tinoni Izireli, sari na tinoni pa popoa Izipi. Meke balabala ia rina palabatu meke sari doduru tie, sapu hinokara na tie nomana hola, meke arilaena hola tugo se Mosese, gua. ");
INSERT INTO rug_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Beto asa si zama la koasa baṉara se Mosese, “Guahe si zama nia e Zihova, ‘Pana korapa boṉi si kaqu ene karovia Rau sa korapana sa doduru popoa pa Izipi, ");
INSERT INTO rug_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","meke sari doduru koburu podo kenudi pa popoa Izipi si kaqu mate, podalae koasa tuna koreo sa baṉara, sapu kote sogo hobe ia si asa, meke kamoa sa tuna koreo sa barikaleqe pinausu, sapu hoke munamunala huiti. Meke sari doduru tudia ri na bulumakao saripu podo kenudi si kaqu mate tugo. ");
INSERT INTO rug_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Kaqu ta evaṉa sa tinaruqoqo lavata pa doduru vasina pa popoa Izipi, gua sapu lopu hite ele ta evaṉa pukerane, meke lopu kaqu ta evaṉa pule sapu gua asa. ");
INSERT INTO rug_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Namu lopu keke siki hokara si kaqu hohouni sari na tinoni Izireli babe sari na dia kurukuru. Pana hola sapu gua asa, si kaqu gilania gamu, sapu gua vata evaṉia Rau si kote votikaena, pa varikorapadi ri na Qua tinoni, meke ri na tinoni pa popoa Izipi.’ ” ");
INSERT INTO rug_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Meke koasa nana zinama vina betobeto, si zama guahe se Mosese, “Sari doduru mua palabatu si kaqu mae, meke kokotuṉu gore pa kenuqu rau, meke kaqu tepa au rini, pude kaqu turaṉi sari doduru qua tinoni meke taloa. Pa mudina sapu gua asa, si kaqu taluarae si rau” Meke ta ṉaziri sisigiti se Mosese, meke taluarae koasa baṉara. ");
INSERT INTO rug_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Ba ele zama nia tu e Zihova koe Mosese sapu guahe, “Sa baṉara si lopu kaqu beto korona avoso gamu, pude soku tinavete variva magasadi si kaqu taveti Rau pa popoa Izipi,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Meke hire sari doduru tinavete variva magasadi, si taveti ri Mosese e Eroni pa kenuna sa baṉara, ba va luli nia nana hiniva e Zihova sa baṉara, meke lopu va malumi sa sari na tinoni Izireli, pude taluarae koasa nana popoa. ");
INSERT INTO rug_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Meke zama la koari Mosese e Eroni pa popoa Izipi se Zihova, ");
INSERT INTO rug_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Sa sidara hie si kaqu na sidara kekenu tamugamu koasa vuaheni hie. ");
INSERT INTO rug_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Mi la tozi sari na vina tumatumae hire koasa doduru butubutu Izireli: Pa rane vina manege puta koasa sidara hie, si kaqu hopeke vizatia ri na tie, si keke tuna sipi babe keke tuna qoti, pude tanisa nana tatamana soti. ");
INSERT INTO rug_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Ego, be guana sa tatamana tanisa tie si hiteke hola, pude hena betoa si keke doduru kurukuru, si leana, be sa tatamana sapu koa tata koasa nana tatamana, si kaqu varihena nia si keke kurukuru koasa padana gua sa sinoku tie, pu boka hena betoa si asa. ");
INSERT INTO rug_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Kaqu vizatia sa tie si keke sipi babe keke qoti kokoreo, ba kaqu keke vuahenina meke loke ari kisakisana si asa. ");
INSERT INTO rug_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Meke pana veluveluna sa rane vina manege made, koasa sidara asa, si kaqu va matei rina butubutu Izireli, sari na kurukuru. ");
INSERT INTO rug_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Meke kaqu vagi rina tinoni sari kaiqa ehara meke vekoi pa dedegere sasada, meke pa batudi rina sasada vetu, vasina sapu kaqu ta hena sari na kurukuru. ");
INSERT INTO rug_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Meke koasa boṉi sana, si kaqu ta kina sa masa kurukuru, meke kaqu ta hena turaṉae kinupi pasana meke na palava lopu ta henie isitina si asa. ");
INSERT INTO rug_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Loke tie si kaqu hena makata babe rarona, ba kaqu kinaia sa sa doduruna, sa batuna meke sari na nenena tugo, meke sari doduru kukuru tini pa korapa tinina. ");
INSERT INTO rug_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Namu loketoṉa si kaqu veko hola ia gamu, osolae vurae munumunu. Be kaiqa toṉa si koa hola, si kaqu ta sulu beto palae. ");
INSERT INTO rug_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Kaqu va namanama va sage poko, na sadolo, meke taṉini kolu si gamu, beto asa mi tuturei hena betoa si asa. Na Inevaṉa Pasova tana vina lavataqu Arau, e Zihova si asa. ");
INSERT INTO rug_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Koasa boṉi sana, si kaqu ene si Rau pa korapa popoa Izipi, meke kaqu va matei Rau sari doduru koburu koreo podo kenudi tadi na tie, na kurukuru, meke kaqu va kilasi Arau Zihova sari doduru tamasa tadi na tinoni pa popoa Izipi. ");
INSERT INTO rug_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Sari na ehara koari na dedegere sasada, si kaqu na vina gilagiladi ri na vetu vasina koai gamu. Pana dogori Rau sari na ehara, si kaqu ene holani gamu Rau, meke lopu kaqu va tasuna gamu Rau, pana va kilasi Rau sari na tinoni pa popoa Izipi. ");
INSERT INTO rug_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Kaqu balabala nia keke rane nomana gamu sa rane asa, guana keke vinarigara nomana lavata pa mia linotu koari hopeke vuaheni na sinage na sage, pude va balabalani gamu sa tinavete sapu Arau Zihova ele tavetia koa gamu.” ");
INSERT INTO rug_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Meke zama se Zihova, “Koari ka zuapa rane, si namu lopu kaqu hite hena bereti sapu ta henie isiti d si gamu, ba mamu henai mo sari na bereti saripu lopu ta henie isiti. Koasa rane kekenu, si mamu okipani betoni sari doduru isiti koari na mia vetu, sina be keke tie si hena bereti sapu ta henie isiti koari ka zuapa rane arini, si namu lopu kaqu koa hola koari na puku tie Izireli, gua. ");
INSERT INTO rug_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Koasa rane kekenu, meke koasa rane vina zuapa pule, si kaqu varigara si gamu meke vahesia sa Tamasa. Lopu kaqu tavetavete si gamu koari na rane arini. Ba na ginani mo si kaqu va namani gamu. ");
INSERT INTO rug_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Mi kopu nia sa rane nomana asa, sina koasa rane asa, si turaṉa vurani Rau pa popoa Izipi sari na mia butubutu. Sina koari doduru totoso mae hiroi si kaqu tavetia gamu sa vinarigara koasa rane asa. ");
INSERT INTO rug_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Podalae pana veluvelu, pa rane vina manege made, koasa sidara kekenu meke kamoa sa veluvelu vina hiokona eke rane, si namu lopu kaqu hena gamu sa bereti sapu ta henie isiti. ");
INSERT INTO rug_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","20","Ura koari ka zuapa rane arini, si namu loke isiti si kaqu ta dogoro koari na mia vetu. Sina be keke tie, sapu ta podo tie Izireli, babe keke tie karovona, si hena ia sa bereti sapu ta henie isiti, si namu lopu kaqu koa hola koari na puku tie Izireli,” gua. ");
INSERT INTO rug_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Meke tioki Mosese sari doduru koimata tadi na tie Izireli, meke zamai sa si arini, “Hopeke gamu si kaqu vizatia si keke tuna sipi ba be keke tuna qoti. Mamu va matea, pude boka tavetia sa mua tatamana sana sa Inevaṉa Pasova. ");
INSERT INTO rug_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Mamu vagia si keke lelaṉa huda hisope, mamu poṉa la nia pa besini koa ia na ehara kurukuru, beto mamu siburu la nia koari na dedegere sasada, meke koasa huda pilivarata, pa batuna sa mua sasada vetu. Beto asa, si namu loke tie koa gamu, si kaqu luaria sa nana vetu, osolae kamoa sa munumunu. ");
INSERT INTO rug_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Pana ene karovia e Zihova sa korapa popoa Izipi, pude va matei sari na tie Izipi, gua, si kaqu dogoria Sa sa ehara koari na huda pilivarata pa batuna sa sasada, meke koari na dedegere sasada, meke lopu kaqu va malumia Sa sa mateana variva mate, pude nuquri sari na mia vetu, meke va mate gamu si gamu. ");
INSERT INTO rug_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Gamu meke sari na mia koburu si kaqu luli sari na tinarae hire ninae rane. ");
INSERT INTO rug_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Pana nuquria gamu sa popoa, sapu ele va tatara nia e Zihova pude vatua koa gamu, si kaqu tavetia gami sa tinavete vinahesi hie. ");
INSERT INTO rug_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Meke pana nanasa guni gamu he rina mia koburu si gamu: ‘Nasa sa ginuana sa tinavete vinahesi asa?’ gua, ");
INSERT INTO rug_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","si kaqu olaṉa guahe si gamu, ‘Sa vina vukivukihi Pasova hie, si na vina lavatana e Zihova, sina ele ene hola ni Sa sari na vetu tadi na tinoni Izireli pa korapa popoa Izipi. Meke va matei Sa sari na tinoni tadi pa popoa Izipi, ba lopu va mate gita Sa si gita,’ mu guni,” gua si asa. Meke kokotuṉu gore sari na tinoni Izireli, meke vahesia rini si asa. ");
INSERT INTO rug_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Beto asa, si la taveti rini, sapu gua garununi e Zihova koari Mosese e Eroni, pude taveti. ");
INSERT INTO rug_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Meke pana korapa boṉi, si va mate betoi e Zihova sari doduru koburu koreo podo kenudi pa popoa Izipi, podalae koasa tuna koreo sa baṉara, sapu kaqu sogo hobea sa baṉara Izipi, meke kamo koasa tie ta pusina pa vetu varipusi. Meke gua tugo koari na kurukuru ta podo kenudi, si mate beto tugo. ");
INSERT INTO rug_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Meke vaṉunu koasa boṉi sana sa baṉara, meke sari nana palabatu meke sari doduru tinoni pule pa popoa Izipi. Meke avosia rini sa taruqoqo lavata pa doduruna sa popoa Izipi, sina lopu hola nia keke vetu tadi na tie Izipi sa vina matedi rina koreo kenudi. ");
INSERT INTO rug_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Meke koasa boṉi tugo asa, si tioki sa baṉara sari Mosese e Eroni, meke zama guahe, “La, mi taloa, gamu kara meke sari na mia tinoni Izireli. Mi luaria sa qua popoa. Mamu la vahesia se Zihova, gua sapu tepa ia gamu koa rau. ");
INSERT INTO rug_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Mamu turaṉi sari na mia sipi, na qoti meke sari na bulumakao; mamu taloa. Ba mamu varavara mana nau tugo,” gua sa baṉara. ");
INSERT INTO rug_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Meke hitu nonoi ri na tinoni pa popoa Izipi sari na tie Izireli, pude tuturei taloa koasa popoa. Meke zama si arini, “Kote mate beto si gami doduru be lopu taloa si gamu,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Ke hadeni poko rina tinoni sari na palava ta henidi, saripu loke isitidi, meke voi i rini koari na dia kinakinana, meke paleki rini. ");
INSERT INTO rug_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Meke evaṉi tugo ri na tinoni Izireli gua sapu ele zamani e Mosese koa rini. Ke la tepa dia qolo, na siliva ṉedaladi, meke na poko koari na tie Izipi si arini. ");
INSERT INTO rug_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Meke va lavalavata poni lani e Zihova koari na tinoni Izireli sari na tinoni pa popoa Izipi. Ke poni rini gua sapu tepa ia ri na tie Izireli koarini. Gua asa, ke paleke taloani rini sari na tinagotago tadi na tie pa popoa Izipi. ");
INSERT INTO rug_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Meke podalae taluarae ene pa vasileana Ramesesi, meke la gua pa Sukoti sari na tie Izireli. Ari ka onomo gogoto tina tie, ba lopu ta nae somanae sari na barikaleqe na koburu. ");
INSERT INTO rug_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Meke soku hola tugo sari na votiki tie meke sari na sipi, na qoti meke sari na bulumakao, si somana luli tugo koa rini. ");
INSERT INTO rug_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Meke kinai rini sari na palava saripu paleke vura ni rini pa popoa Izipi, saripu ele ta henie kolo, ba lopu ta henie isiti, sina tuturei hitu vurani rini si arini pa popoa Izipi. Ke loke dia totoso pude va namai sari na gedi ginani babe kinai sari na bereti saripu ele ta henie isiti. ");
INSERT INTO rug_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Ka made gogoto toloṉavulu puta vuaheni si koa pa popoa Izipi sari na tie Izireli. ");
INSERT INTO rug_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Ego, koasa rane sipu hokoto puta sari ka made gogoto toloṉavulu puta vuaheni, si taluarae pa popoa Izipi sari doduru butubutu te Zihova. ");
INSERT INTO rug_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Asa sa boṉi, sapu kopu totokoni e Zihova, pude turaṉa vurani si arini pa popoa Izipi. Meke asa tugo sa boṉi sapu ele va madia e Zihova, pude tana doduru totoso mae hiroi. Meke asa sa boṉi pana kaqu koa kopu sari na tinoni Izireli. ");
INSERT INTO rug_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Meke zama la koe Mosese meke Eroni se Zihova: “Hire sari na tinarae koasa guguana sa Pasova. Loke tie karovona si kaqu hena ia sa Hinenahena Pasova. ");
INSERT INTO rug_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Be keke pinausu sapu ele holua gamu, si boka hena ia si asa, ba kekenu si kaqu ta magu paki si asa. ");
INSERT INTO rug_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Loke tie karovodi, babe na tie ta tabaradi, si kaqu hena ia sa Hinenahena Pasova. ");
INSERT INTO rug_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Sa doduruna sa hinenahena si kaqu ta hena pa korapa vetu, vasina pu ele tava nama si asa; meke loke hinenahena si kaqu ta hena pa sada. Meke lopu kaqu hite ta moku palae si keke susuridi ri na kurukuru. ");
INSERT INTO rug_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Sa doduruna sa butubutu Izireli, si kaqu somana nia sa Hinenahena Pasova hie. ");
INSERT INTO rug_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Ba loke tie, sapu lopu ele ta maguna si kaqu hena. Be keke tie karovona si koa turaṉae koa gamu, meke hiva somana nia sa sa Inevaṉa Pasova, pude va lavatia se Zihova, gua, si leana, ba kekenu si kaqu ta magu beto sari doduru tie pu koa pa nana vetu. Beto asa, si kaqu tiqe ta evaṉae guana keke tie ta podoe tie Izireli soti si asa meke tiqe kaqu somana nia sa sa Inevaṉa Pasova. ");
INSERT INTO rug_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Kekeṉoṉo mo sari na tinarae, saripu la gua koari na tie Izireli soti meke gua tugo koari na tie karovodi saripu koa koa gamu” ");
INSERT INTO rug_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Ke va tabei na taveti ri doduru tie Izireli gua sapu garununi e Zihova koari Mosese e Eroni. ");
INSERT INTO rug_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Meke koasa rane sana si turaṉa vurani e Zihova pa popoa Izipi, sari na butubutu Izireli. ");
INSERT INTO rug_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Meke zama la koe Mosese se Zihova, ");
INSERT INTO rug_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Mi va madi koa Rau sari doduru koburu koreo pu podo kekenudi, sina taqarau beto sari doduru koburu koreo Izireli. Meke sari doduru kurukuru kokoreo saripu ta hira kenudi,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Beto asa, si zama la koari na tinoni se Mosese, “Mi balabala ia sa rane hie sa rane sapu taluarae ia gamu pa popoa Izipi, vasina sapu tava pinausu si gamu. Koasa rane hie, si ta turaṉa vura taloa si gamu, koasa ṉiniraṉira lavata te Zihova. Meke loke tie si kaqu hena ia sa bereti sapu ta henie Isiti. ");
INSERT INTO rug_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Pa rane hie, koasa sidara Abibi sapu sa sidara kekenu pa vuaheni, si taluarae si gamu pa popoa Izipi. ");
INSERT INTO rug_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Ele va tatara nia tu e Zihova koa rina tiatamamia, si pude vatui koa gamu sari na popoa tadi na tinoni Kenani, Hitaiti, Amoraiti, Hivaiti meke Zebusaiti. Pana turaṉa lani gamu Sa koasa popoa masuruna sana si gamu, si kaqu tavetia gamu sa Inevaṉa Pasova koasa sidara kekenu, pa doduru hopeke vuaheni. ");
INSERT INTO rug_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Ura koari ka zuapa rane, si kaqu henai gamu sari na bereti saripu lopu ta henie isiti, meke koasa rane vina zuapa, si kaqu tavetia gamu si keke inevaṉa pude va lavatia se Zihova. ");
INSERT INTO rug_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Meke koari ka zuapa rane tugo arini, si lopu kaqu hite henai gamu sari na bereti saripu ta henie isiti. Namu loke isiti babe na bereti sapu ta henie isiti, si kaqu koa pa doduruna sa mia popoa. ");
INSERT INTO rug_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Koasa rane sapu podalae sa inevaṉa, si guahe si kaqu tozia goi koasa tumu koreo, ‘Taveti rau si hire, ura e Zihova ele tavete maeni koa rau si arini, sipu taluarae pa popoa Izipi si rau,’ mu gunia. ");
INSERT INTO rug_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Sa tinavete hie, si kaqu na vina balabala pule, guana keke vina gilagila sapu ta pusi veko pa limamu babe pa raemu. Asa kaqu va balabala pule nigo, pude lopu makudo, tozi vura nia meke va nonoga ni goi koari na tie sa tinarae te Zihova. Ura e Zihova turaṉa vurani gamu pa nana ṉiniraṉira pa popoa Izipi, gua. ");
INSERT INTO rug_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Mamu balabala ia sa rane asa, koari hopeke vuaheni, koasa totoso ta vizatana.” ");
INSERT INTO rug_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“E Zihova kaqu turaṉa lani gamu si gamu koasa popoa tadi na tie pa Kenani, sapu ele va tatara zoṉazoṉa nia Sa koa gamu, meke koari na tiatamamia pukerane. Ego, pana vatu nia Sa si asa koa gamu, ");
INSERT INTO rug_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","si kaqu vala betoi gamu koe Zihova sari doduru koreo podo kenudi. Meke sari doduru kokoreo pu hira kekenu koari na mia kurukuru si te Zihova tugo. ");
INSERT INTO rug_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Ba kaqu holu vagi puleni gamu koa Sa sari doduru kokoreo pu ta hirae kenudi koari na doṉ'ki, pude hobeni keke tuna sipi si arini. Be koromia holu pule nia gamu sa doṉ'ki, si mamu moku i sari na susuri pa ruana pude va matea. Ba kaqu hobeni gamu sari doduru tumia koreo podo kenudi. ");
INSERT INTO rug_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Ego, koari na rane vugorepere, pana nanasa gamu rina tumia koreo si gamu, ‘Na sa sa ginuana sa rane sapu kopu nia gita?’ gua, si kaqu olaṉia gamu si asa, ‘Koasa ṉiniraṉira lavata sapu tavetavete nia e Zihova, si ta turaṉa vura si gita na tie Izireli pa popoa Izipi, sa vasina sapu tava pinausu si gita. ");
INSERT INTO rug_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Totoso va luli nia nana hiniva e Zihova sa baṉara, meke korona va malumu gita sa pude taloa, si va matei e Zihova sari doduru koreo podo kenudi pa popoa Izipi, sari na tie meke na kurukuru. Gua asa ke va vukivukihi lani gita koe Zihova sari doduru kurukuru kokoreo pu ta hirae kekenudi, ba hobe vagi puleni gita kasa sari na tuda koreo podo kenudi. ");
INSERT INTO rug_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Ke sa rane hie si na vinabalabala pule, guana vina gilagila sapu ta pusie pa limada babe pa raeda, meke kaqu va balabalani gita, sapu turaṉa vurani gita e Zihova si gita pa popoa Izipi, koasa Nana ṉiniraṉira lavata.’ ” ");
INSERT INTO rug_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Meke sipu va malumi sa baṉara pa popoa Izipi sari na tinoni pude taloa, si lopu turaṉa lani e Tamasa si arini, koasa siraṉa sapu sage la gua pa raratana Pilisitia d, na siraṉa papaka si asa. Balabala ia sa Tamasa, sapu lopu leana pude hobe binalabala sari na tie, meke pule la pa popoa Izipi, pana gilania rini sapu kote la varipera si arini, gua. ");
INSERT INTO rug_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Ba turaṉa lani Sa si arini, meke va ene viloviloraei Sa pa korapa popoa qega, sapu la gua koasa Kolo Ziṉara. Meke va sage poko varipera sari na tie Izireli. ");
INSERT INTO rug_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Meke palekia Mosese sari na susuri tinina e Zosepa, ura ele va tatara zoṉazoṉa nia tu e Zosepa koari na tinoni Izireli, sapu pude gua asa. Guahe si zama nia e Zosepa, “Pana harupu gamu e Tamasa si gamu, si kaqu paleke taloani gamu sari na susuri tiniqu koasa popoa hie,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Meke taluarae si arini koa ke vasina pozana Sukoti, meke la va turu dia ipi si arini pa Etami, koasa hukihukirina sa popoa qega. ");
INSERT INTO rug_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Pana rane si hoke ene va kenue koarini se Zihova koa keke lei, pude va dogoro nia koa rini sa siraṉa, meke pana boṉi si ene va kenue si asa koa rini koa keke nika, pude va kalalasi si arini pude boka ene si arini pana boṉi meke pana rane. ");
INSERT INTO rug_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Doduru totoso sa lei si hoke turu va kenue koari na tie pana rane, meke sa nika pana boṉi. ");
INSERT INTO rug_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Meke zama la koe Mosese se Zihova, ");
INSERT INTO rug_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Mu tozini sari na tinoni Izireli pude kekere la pa Pi Hahiroti, mi la va turu ipi, pa vari korapana sa vasileana Miqidoli meke sa Kolo Ziṉara, tata pa Beolo Zepone. ");
INSERT INTO rug_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Meke kote balabala ia sa baṉara, sapu korapa ene vilorae mo pa korapa popoa si gamu tata pa qega, gua. ");
INSERT INTO rug_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Kaqu va luli nia nana hiniva Rau sa baṉara, meke kote hadu luli gamu sa si gamu, meke koasa Qua minataqara sapu lopu boka ṉana kamoa sa baṉara meke sari nana ṉiha na varane, si kaqu va lavatau rini si Rau. Meke vasina si kaqu gilania rina tinoni pa popoa Izipi, sapu Arau se Zihova.” Meke va tabea ri na tie Izireli sapu gua ele ta tozi nia rini. ");
INSERT INTO rug_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Meke sipu ele tozi nia rina tie sa baṉara pa popoa Izipi sapu ele govete taloa tu sari na tinoni Izireli, gua, si hobe binalabala si asa meke sari nana palabatu nomadi meke zama: “Lopu leana sapu tavetia gita. Ele va malumi gita meke va govete taloai si arini. Meke kamahire si ele siana ni gita sari nada pinausu arini!” gua si arini. ");
INSERT INTO rug_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Meke va namanama i sa baṉara sa nana totopili varipera meke sari nana ṉiha na varane. ");
INSERT INTO rug_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Meke topue la si asa meke sari doduru nana totopili varipera, turaṉae tugo sari ka onomo gogoto tie totopili ṉiṉiradi pa vinaripera pu koai sari na dia palabatu varipera bokabokadi. ");
INSERT INTO rug_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Meke va luli nia nana hiniva e Zihova sa baṉara, meke hadu luli sa sari na tinoni Izireli, saripu ele taluarae va mataqara pa kinopu te Zihova. ");
INSERT INTO rug_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Meke hadu luli ni hose, na totopili varipera rini sari na tie Izireli, meke la kamoi rini si arini pa Kolo Ziṉara, tata pa Pi Hahiroti meke vasina sapu tia la pa Beolo Zepone. ");
INSERT INTO rug_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Meke sipu dogoria rina tie Izireli sa baṉara Izipi meke sari na tie varipera saripu korapa ene nono la koa rini, si matagutu sisigiti, meke kabo velavela va ululae na hata tinokae koe Zihova si arini. ");
INSERT INTO rug_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Meke zama la koe Mosese si arini, “Nake soku vasina popomunuana pa popoa Izipi. Ba turaṉa hoboro maeni gami goi tani pa korapa qega, pude va mate gami. Dotu, sapu tavetia goi meke turaṉa vurani gami pa popoa Izipi! ");
INSERT INTO rug_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ele tozi nigo tu gami, sipu lopu ele taluarae si gita tatasana, sapu kaqu ta evaṉa sapu guahe. Ele tozi nigo tu gami pude lopu voritini gami, ba mami koa tava pinausu nono la mami mo koari na tinoni pa popoa Izipi. Sina leana hola nia si pude koa tava pinausu vasina si gami, meke pude tava mate hoboro tani pa korapa popoa qega,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Ba olaṉa se Mosese, “Mi lopu matagutu! Mi turu va ṉiṉira, mamu dogoria sa tinaharupu, sapu kaqu evaṉia e Zihova koa gamu pa rane ṉinoroi, ura lopu kaqu dogoro pulei gamu sari na tie Izipi hire. ");
INSERT INTO rug_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","E Zihova si kaqu varipera poni gita, meke loketoṉa si kaqu ta hivae koa gamu pude tavetia,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Meke zama la koe Mosese se Zihova, “Na vegua ke kabo vura na hata tinokae si goi? Mu tozini sari na tinoni pude ene la. ");
INSERT INTO rug_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Mu ovulu sage nia sa mua kolu hodu, mamu taṉini va ululia koasa kolo. Meke kaqu boka ene pa pepeso popana, pa vari korapana sa kolo sari na tinoni Izireli. ");
INSERT INTO rug_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Ba kaqu va lulini dia hiniva Rau sari na tinoni pa popoa Izipi, meke kaqu hadu luli gamu rini si gamu, meke kaqu vagia Rau sa Qua vina lavata nomana, koasa Qua minataqara koasa baṉara, meke koari na hose na totopili, meke sari doduru tie varipera. ");
INSERT INTO rug_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Pana va kilasi Rau si arini, si kaqu gilania ri na tinoni pa popoa Izipi sapu Arau mo se Zihova.” ");
INSERT INTO rug_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Ego, sa mateana te Tamasa sapu turu pa kenuna sa puku tie varipera tadi pa Izireli, si rizu la meke turu pa mudidia ri na tie varipera tadi pa Izireli. Sa lei ba rizu tugo, osolae la koa, ");
INSERT INTO rug_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","pa varikorapa dia ri na tie Izipi meke sari na tie Izireli. La sa lei meke va hupori sari na tie Izipi, ba poni kalalasa sa sari na tie Izireli, gua asa ke lopu boka ene varikamoi sari na tie varipera koasa doduruna sa boṉi sana. ");
INSERT INTO rug_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Meke huhuku sage nia Mosese sa limana koasa kolo, meke va tupele pule nia givusu gevasa ṉiburuna e Zihova sa kolo. Meke raza lamo sa givusu koasa doduruna sa boṉi, meke ta evaṉae na pepeso popana sa kolo, sipu paqaha rua si asa. ");
INSERT INTO rug_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Meke ene pa vari korapana sa kolo koasa pepeso sari na tie Izireli. Meke koa varikali, guana goba pa karu kalina sa kolo. ");
INSERT INTO rug_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Meke hadu lulini hose na totopili, rina tie Izipi si arini, meke kamo la gua pa varikorapadi sari karu goba kolo. ");
INSERT INTO rug_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Meke sipu lopu ele kamo sa vaqavaqasa, si koa pa nika meke pa lei se Zihova meke doṉo gore mae koasa qeto minate tadi na tie Izipi, meke va tarazuzui Sa si arini. ");
INSERT INTO rug_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Meke va soqoi mo e Zihova pa pepeso malohorona na napiti sari na totopili varipera, ke rizu mamata la si arini. Meke zama sari na tie Izipi, “Ai, e Zihova si varipera tokani sari na tie Izireli. Mada luara pania sa vasina hie!” gua si arini. ");
INSERT INTO rug_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Meke zama se Zihova koe Mosese, “Huhuku la nia sa limamu koasa kolo, pude kaqu varikamoi pule sa kolo, meke va lodu betoi sari na tie Izipi, meke sari na totopili varipera, na tie koari na dia hose.” ");
INSERT INTO rug_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Ke huhuku sage nia Mosese sa limana koasa kolo, meke pule mae meke vari kamoi pule sa kolo pana vaqavaqasa. Meke podekia rina tie Izipi pude govete nia si asa, ba va lodu betoi e Zihova pa korapa kolo lamana si arini. ");
INSERT INTO rug_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Meke lodu pa korapa kolo lamana sari na totopili varipera, na tie koari na hose, meke sari doduru tie varipera tadi pa Izipi saripu luli maei sari na tie Izireli koasa kolo, meke lopu hite keke koa rini si koa hola. ");
INSERT INTO rug_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Ba ene pa pepeso popana sari na tie Izireli, pa varikorapadi karua goba kolo. ");
INSERT INTO rug_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Koasa rane sapu harupi e Zihova sari na tie Izireli koari na tie Izipi, si dogori ri na tie Izireli sari na tinidia ri na tie Izipi eko matedi pa raratana masamasa. ");
INSERT INTO rug_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Meke sipu dogoria rina tie Izireli sa ṉiniraṉira lavata te Zihova sapu va kilasadi sari na tie Izipi, si magasa na pamaṉa nia rini se Zihova, meke raṉea rini si Asa, meke se Mosese sapu sa Nana nabulu. ");
INSERT INTO rug_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Beto asa, si kera vahesi la nia e Mosese meke sari na tinoni Izireli sa kinera hie koe Zihova: “Kaqu kera vahesia rau se Zihova, sina mataqara si Asa koasa Nana ṉiniraṉira lavata. Ele va lodui Sa pa korapa lamana sari na tie meke sari dia hose. ");
INSERT INTO rug_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","E Zihova si va ṉiṉirau meke harupau. Asa tugo sa qua Tamasa sapu kaqu vahesia rau, meke Asa tugo sa Tamasa tadi na tiatamaqu, sapu kaqu kera vahesia rau guguana sa Nana ṉiniraṉira. ");
INSERT INTO rug_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","E Zihova si na tie varipera; meke e Zihova tugo sa pozana. ");
INSERT INTO rug_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Meke ipa lani Sa pa kolo sa qeto minate tadi pa Izipi meke sari dia totopili varipera. Meke lodu pa Kolo Ziṉara sari na ṉati palabatu varipera tadirini. ");
INSERT INTO rug_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Meke lodu guana patu pa hubi lamana, meke kuzu beto pa korapana sa kolo si arini. ");
INSERT INTO rug_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Sa lima mataomu Goi Zihova si ṉiṉira hola meke variva magasa, sapu muzara va umumia sa kana. ");
INSERT INTO rug_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Meke koasa Mua vinariva magasa Baṉara, si va kilasi Goi sari na Mua kana; meke sa Mua binugoro si huruṉu vura guana nika sapu sulu betoi si arini guana remoremo popadi. ");
INSERT INTO rug_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Va givusia Goi sa lamana, meke varitomotomoi sage sari na kolo; meke turu toṉoto sage guana goba; sa pepeso pa lamana lavata si ta evaṉae guana patu ṉiṉira. ");
INSERT INTO rug_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Meke zama sa kana, ‘Kaqu hadu luli rau, meke saputu vagi si arini; meke kaqu lobusu vagia rau sa qua magu, meke vagi betoi sari doduru pu tagoi rini; meke kaqu variva hia ni rau sari doduru dia likakalae, meke vagi sari doduru pu hivani rau,’ gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Keke siṉo lavata mo Goi Zihova, si lodu beto mo sari na tie Izipi; meke lodu guana aeana pa korapa lamana si arini. ");
INSERT INTO rug_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Ke Zihova, esei koari na tamasa sapu kekeṉoṉo gua Agoi! Esei si kekeṉoṉo gua Agoi sapu hopemu meke variva magasa hola? Esei si boka taveti sari na tinavete variva magasadi meke ṉiṉiradi gugua Tamugoi? ");
INSERT INTO rug_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Ovulu sage nia Goi sa lima mataomu, meke ta onolo toa pa korapa pepeso sari nada kana. ");
INSERT INTO rug_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Koasa Mua tataru lopu ta ṉana kamona, si turaṉi Goi sari na Mua tie saripu ele vata rupahi Goi; meke koasa Mua ṉiniraṉira si turaṉa lani Goi koasa Mua popoa madina si arini. ");
INSERT INTO rug_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Soku butubutu si avoso nia, meke holoqoru na matagutu si arini, meke tarazuzu sari na tie Pilisitia. ");
INSERT INTO rug_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Matagutu sisigiti sari na koimata tadi pa Edomu d; meke sari na tie ṉiṉiradi pa popoa Moabi si neneqara; meke malohoro sari na tinoni pa Kenani. ");
INSERT INTO rug_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Meke matagutu sisigiti si arini, sapu dogoria rini sa ṉiniraṉira tamugoi Zihova. Meke turu nunala pa minatagutu si arini, osolae ene hola sari na mua tie saripu vata rupahi Goi pa tinoa pinausu. ");
INSERT INTO rug_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Turaṉi Goi sari na Mua tinoni, meke la vekoi Goi koasa Mua toqere soti, sa vasina sapu kuria Goi telemu, pude na Mua vasina kokoana, sapu sa vasina hopena sapu kuria Goi Zihova pa limamu soti. ");
INSERT INTO rug_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Kaqu koa Baṉara si Goi Zihova ninae rane ka rane.” ");
INSERT INTO rug_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Ene pa varikorapa kolo koasa pepeso popana sari na tie Izireli. Ba sipu ene luli la sari na totopili varipera, meke sari na tie Izipi koari na dia hose pa vari korapana sa kolo koa sa pepeso popana, si varikamo pule nia e Zihova sa kolo meke kuzu beto pa korapa kolo si arini. ");
INSERT INTO rug_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Beto asa si taṉini vagia poropita Miriami sapu sa tasina barikaleqe e Eroni sa tabarini, meke lulia ri doduru barikaleqe si asa, peka lopilopi turaṉi rini sari na tabarini. ");
INSERT INTO rug_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Meke kera se Miriami: “Mi kera vahesia se Zihova, tava lavata si Asa sina mataqara si Asa pa vinaripera; ele ipani Sa pa kolo sari na tie varipera koari na dia hose!” ");
INSERT INTO rug_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Meke turaṉa va seu i e Mosese pa Kolo Ziṉara meke la gua pa korapa qega sapu ta pozae Sura sari na tie Izireli. Ka ṉeta rane si enea rini sa korapa qega, ba loke kolo si dogoria rini. ");
INSERT INTO rug_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Meke sipu kamoa rini si keke vasina pozana Mara, ba sa kolo vasina si pasa sisigiti, ke lopu boka napoa rini si asa. Gua asa ke ta pozae Mara sa pozana. ");
INSERT INTO rug_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Meke qumiqumi na nanasia rini se Mosese, “Nasa si kote napoa gita?” gua si arini ");
INSERT INTO rug_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Meke varavara va ṉiṉirae la koe Zihova se Mosese, meke va dogoro nia e Zihova koasa si keke kukuru huda, meke oki la nia sa si asa pa kolo, pude va lomoso ia meke boka ta napo sa kolo. Meke ponini tinarae tugo e Zihova vasina si arini, pude luli. Podeki tugo Sa vasina si arini, ");
INSERT INTO rug_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","meke zama si Asa, “Arau tugo se Zihova sapu salaṉa gamu si gamu. Be va tabe va hinokara si gamu koari na tinavete sapu gua toṉoto pa Qua hiniva, meke kopuni gamu sari na Qua zinama, si lopu kaqu va kilasa gamu Rau si gamu koari na minoho saripu vata razae lani Rau koari na tinoni pa popoa Izipi.” ");
INSERT INTO rug_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Beto asa si mae pa vasileana Elimi si arini, meke vasina si dogori rini sari ka manege rua bukaha kolo meke sari ka zuapa ṉavulu huda pamu, ke va turu dia ipi tata koasa kolo vasina si arini. ");
INSERT INTO rug_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Meke taluarae pa Elimi sa doduruna sa butubutu Izireli, meke mae koasa soloso qega sapu ta pozae Sini si arini, sapu pa vari korapana Elimi meke Saenai. Meke kamo vasina pa rane vina manege lima koasa sidara vina rua si arini seunae gua taluarae pa popoa Izipi si arini. ");
INSERT INTO rug_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Meke pa korapana sa qega vasina, si nominomi la koari Mosese e Eroni sari doduru tinoni, ");
INSERT INTO rug_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","meke zama guahe koari karua si arini, “Leana hola si be ele va mate gami e Zihova pa popoa Izipi si gami vasina sapu ele boka koa meke hena gemami miti, meke soku pule ginani gua pu hivani gami, ba turaṉa maeni gami gamu kara tani si gami doduru meke va agoso mate gami,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Meke zama la koe Mosese se Zihova, “Ego, kamahire si kaqu va gore gunia na ruku Rau pa galegalearane koa gamu doduru sa ginani. Koari doduru rane si kaqu vura la sari doduru tie meke pudiki varigarani gua sapu garo koasa rane asa. Pa siraṉa hie si hiva podeki Rau si arini, be va tabei rini sari na Qua vina tumatumae. ");
INSERT INTO rug_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Koasa rane vina onomo si kaqu vagi va soku si gamu, hola nia doduru totoso, mamu va namanama i sari na ginani padana karua rane,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Ke zama la koari doduru tie Izireli sari Mosese e Eroni, “Koasa veluvelu hie si kaqu gilania gamu sapu e Zihova si turaṉa vurani gamu pa popoa Izipi si gamu. ");
INSERT INTO rug_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Pana munumunu si kaqu dogoria gamu sa ṉedalana sa kalalasa te Zihova. Ura ele avosi Sa sari na mia qinumiqumi saripu lopu qetuni Sa. Uve, qumiqumi nia gamu si Asa, sina gami karua si tozi vurani mo sari Nana vina tumatumae.” ");
INSERT INTO rug_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Meke zama se Mosese, “Pana veluvelu hie si kote poni gamu miti e Zihova si gamu pude henai, meke sokudi hola bereti sapu gua hivani gamu, si kote poni gamu Sa doduru munumunu, sina ele avosi Sa sari doduru mia qinumiqumi, sapu lopu qetu nia gamu si Asa. Totoso qumiqumini gami gamu, si namu e Zihova mo si qumiqumi nia na lopu qetu nia gamu.” ");
INSERT INTO rug_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Meke zama la koe Eroni se Mosese, “Mu tozini sari doduru tie pude mae turu pa kenuna e Zihova, sina ele avosi Sa sari na dia qinumiqumi,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Meke sipu zama la i tugo Eroni sari doduru tie Izireli, si doṉo la pa qega si arini, meke hinoqa ṉedala vura mae koa ke lei sa kalalasa te Zihova. ");
INSERT INTO rug_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","12","Meke zama la koe Mosese se Zihova, “Ele avosi Rau sari na qinumiqumi tadi na tie Izireli. Ego, mamu tozini sapu pana veluveluna sa popoa si kaqu henai rini sari na miti, meke pana munumunu si ve soku gua sari na bereti saripu hivani rini si kaqu henai rini. Beto asa si kaqu gilania rini, sapu Arau si e Zihova sa dia Tamasa,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Beto asa si tapuru mae gana si keke rovana kurukuru lavata, meke siṉia rini sa vasina pu koa ia rini, meke sa vasina tugo asa si hoqaia na puni pana munumunu. ");
INSERT INTO rug_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Meke sipu murimuri taloa sa kolo, si koa hola pa beru pepeso qega si keke tiṉitoṉa kekeoro hitekena. ");
INSERT INTO rug_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Meke sipu dogoria ri na tie Izireli, si varinanasa nia rini si asa, “Nasa sa tiṉitoṉa hie?” gua si arini, sina lopu gilania rini si asa. Meke zama la se Mosese koa rini, “Asa sa ginani sapu ponini gamu e Zihova pude hena ia,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Meke tozini e Zihova si arini, pude hopeke pudiki varigarani sokudi gua sapu hivani rini, padana karua lita hopeke tie pa nana vetu soti. ");
INSERT INTO rug_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Meke tavetia rina tie Izireli sapu gua asa. Kaiqa si vagi va soku meke kaiqa si va visavisae mo. ");
INSERT INTO rug_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Meke sipu padai rini si arini, arini sapu vagi va soku si lopu tago va soku sisigiti, meke arini sapu vagi va visavisa, si lopu papaka tugo sapu vagia rini, ba hopeke vagia rini sapu gua garona koasa nana pada. ");
INSERT INTO rug_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Meke zama la koa rini se Mosese, “Namu loke tie si kaqu va naqiti hola ia si keketoṉa, pude tana vugo,” gua si asa ");
INSERT INTO rug_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Ba kaiqa arini si lopu hiva avosia se Mosese, meke va naqiti vekoi rini si kaiqa meke kamoa munumunu si siṉi na nokinoki meke humaṉa hikare si arini, meke bugoroni e Mosese si arini. ");
INSERT INTO rug_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Meke doduru munumunu si pudiki varigarani rini, sapu gua boka hena betoi rini. Meke sipu maṉini sage sa rimata, si kolo taloa dia saripu koa hola pa pepeso. ");
INSERT INTO rug_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Meke koasa rane vina onomo si padana karua totoso hola gua sa ginani sapu varigara nia rini hopeke tie si ka made lita padana. Meke tozia ri doduru koimata tanisa butubutu sa guguana koe Mosese. ");
INSERT INTO rug_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Meke zama la koa rini se Mosese, “Guahe si zama nia e Zihova, ‘Vugo si na rane Sabati, meke na rane magogoso si asa, sapu ele tava madi koe Zihova. Kaqu kinai ṉinoroi sapu gua hivani gamu pude kinai, meke kaqu raroi gamu sapu gua hiva raroi gamu. Meke sapu koa hola si kaqu veko vata kalei gamu pude tana vugo,’ ” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Ke veko hola i rini sari na ginani koa holadi osolae kamoa munumunu gua sapu zama nia Mosese koa rini, ba lopu muzi babe koai nokinoki si arini. ");
INSERT INTO rug_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Meke zama se Mosese, “Mi henai si hire ṉinoroi, sina na rane Sabati si ṉinoroi, na rane magogoso sapu ele tava madina koe Zihova, meke lopu boka vagi ginani si gamu pa valena sa vasina sapu koa ia gamu hie, sina lopu koa vasina si asa. ");
INSERT INTO rug_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Ka onomo rane si kaqu hata ginani si gamu, ba koasa rane vina zuapa, sa rane magogoso, si lopu kaqu hoqa sa ginani.” ");
INSERT INTO rug_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Ba kaiqa rina tie si la hata ginani koasa rane vina zuapa, ba loketoṉa si dogoria rini. ");
INSERT INTO rug_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Meke zama la koe Mosese se Zihova, “Ve seunae gua si kaqu koromia va tabei gamu na tie Izireli sari na Qua zinama? ");
INSERT INTO rug_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Dotu, sapu Arau Zihova, si ele poni gamu sa rane magogoso; gua asa ke, kaqu garomia sa ginani sapu kaqu ponini gamu doduru totoso, meke koasa rane vina onomo pude tana karua rane. Meke doduru tie si kaqu koa vasina sapu koa si asa, koasa rane vina zuapa, si lopu kaqu luaria sa sa nana vetu.” ");
INSERT INTO rug_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Ke gua asa si lopu tavetavete sari na tie koasa rane vina zuapa. ");
INSERT INTO rug_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Meke poza nia mana ri na tie Izireli sapu kekeṉoṉo keke kiko keoro hitekena, meke liṉiliṉi gua ri na bisikiti hitekedi saripu ta henie zipale. ");
INSERT INTO rug_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Meke zama se Mosese, “Ele zama gita e Zihova si gita, pude va naqiti vekoi kaiqa mana, pude tadi tudia rina tuda; meke pude boka dogoria rini sa ginani, sapu ponini gita Sa meke hena ia gita pa korapa qega, sipu turaṉa vurani gita e Zihova pa popoa Izipi.” ");
INSERT INTO rug_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Meke tiqe zama la koe Eroni se Mosese, “Vagia keke zagi mamu voi nia mana karua lita padana, mamu vekoa pa vetu te Zihova, pude ta kopue tana tudia ri na tuda,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Ke tavetia Eroni sapu gua zamani e Mosese, meke vekoa Eroni sa zagi sapu koa ia na mana pa kenuna sa Bokese Vinariva Egoi d, pude ta kopue. ");
INSERT INTO rug_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Ego na mana si hena ia ri na tinoni Izireli koari ka made ṉavulu puta vuaheni pule, osolae kamoa arini sa popoa Kenani, vasina sapu koa si arini. ");
INSERT INTO rug_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Sa padana sa mana si karua kilo pa keke tie. ");
INSERT INTO rug_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Meke taluarae koasa soloso qega sapu ta pozae Sini sa doduruna sa butubutu Izireli, meke ririzu la koari ninae vasina pa zinama te Zihova si arini. Meke mae va turu ipi si arini pa Repidimi, ba namu loke kolo napo si koa vasina. ");
INSERT INTO rug_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Meke podalae nominomi nia rini se Mosese, meke zama guahe, “Kei poni gami kolo napo,” gua si arini. Meke olaṉa se Mosese, “Na vegua ke nominomi nau gamu? Na vegua ke hiva podepodekia gamu se Zihova?” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Ba memeha mate sari na tinoni, ke lopu makudo qumiqumi nia mo rini se Mosese. Meke zama guahe si arini, “Na vegua ke turaṉa va seu pani gami goi pa popoa Izipi si gami? Na pude va memeha mate gami meke sari na mami koburu na mami rovana kurukuru gua si goi?” gua si arini. ");
INSERT INTO rug_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Meke varavara va ṉiṉira la koe Zihova se Mosese meke zama, “Nasa si boka tavetia rau koari na tie hire? Na korapa hiva gona nau patu mo rini si rau,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Meke zama la koe Mosese se Zihova, “Mamu vagi atuni koa goi sari kaiqa koimata tadi na tie Izireli. Mamu ene la va kenue koa rina tinoni; mamu vagia sa kolu hodu sapu seke nia goi koasa Ovuku Naelo. ");
INSERT INTO rug_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Kaqu turu si Rau pa kenuna keke patu koasa toqere Saenai, kaqu sekea goi sa patu asa, meke kaqu vura mae koasa sa kolo, pude napo sari na tie.” Meke tavetia tugo Mosese pa kenudia rina koimata tadi na tie Izireli sapu gua asa. ");
INSERT INTO rug_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Ke ta pozae Ma'asa, meke Meriba sa vasina asa, sina nominomi na podepodekia rina tinoni Izireli se Zihova, meke nanasa guahe: “Vegua koa Nana koa gita se Zihova babe lokari?” gua. ");
INSERT INTO rug_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Meke mae razai rina tie Amaleki d sari na tie Izireli pa Repidimi. ");
INSERT INTO rug_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Ke zama koe Zosua se Mosese, “Mamu vizata vagi kaiqa tie pude la razai sari na tie Amaleki vugo. Arau si kote turu pa batuna sa toqere meke taṉinia sa kolu hodu sapu tozi nau e Zihova pude palekia,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Meke tavetia tugo Zosua sapu gua garunu nia Mosese koasa meke la razai rini sari na tie Amaleki, sipu sage la pa batu toqere sari Mosese, Eroni meke Huri. ");
INSERT INTO rug_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Totoso va sage seunae i e Mosese sari limana si mataqara sari na tie Izireli pa vinaripera, ba sipu gore sari limana si podalae tava kilasa sari na tie Izireli koari na tie Amaleki. ");
INSERT INTO rug_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Meke sipu mabo sa limana e Mosese, si vagi vala nia ri Eroni e Huri si keke patu, pude habotu si asa vasina. Meke turu kapae koasa si arini meke ovulu sageni sari limana, meke tuqe va nosoi osolae lodu sa rimata. ");
INSERT INTO rug_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Gua asa ke va kilasa betoi Zosua sari na tie Amaleki. ");
INSERT INTO rug_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Beto asa si zama la koe Mosese se Zihova, “Mu kuberia vivineina sa minataqara hie, pude ta balabalae si asa. Mamu tozi nia se Zosua sapu kaqu va kilasa betoi Rau sari na tie Amaleki pude loke tie pa kasia popoa si boka balabala la i,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Meke tavetia Mosese si keke hope meke poza nia sa, “E Zihova sa qua Pitipiti pude turaṉi sari na tie pa minataqara,” gua. ");
INSERT INTO rug_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Meke zama si Asa, “Mu ovulu sage nia sa pitipiti te Zihova. Meke lopu kaqu makudo razai e Zihova sari na tie Amaleki koari doduru sinage na sage,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Ego, avoso nia e Zetoro, sapu sa roana e Mosese, meke na hiama pa Midiani, sari doduru ginugua saripu taveti e Tamasa koe Mosese, meke koari na tinoni Izireli, sipu turaṉa vurani Sa si arini pa popoa Izipi. ");
INSERT INTO rug_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Ke turaṉa mae nia sa koe Mosese se Zipora sapu sa barikaleqe te Mosese, sapu koa hola koasa. ");
INSERT INTO rug_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Meke se Qesomu, meke se Elieza, sapu sari karua tuna koreo. Ura ele zama nia tu e Mosese sapu na tie karovona si asa pa votiki popoa gua, ke poza nia Qesomu sa sa tuna koreo asa. ");
INSERT INTO rug_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Meke zama nia tugo sa sapu guahe, “Sa Tamasa tanisa tamaqu si ele toka nau meke harupau, meke lopu tava mate si rau koasa baṉara pa popoa Izipi” gua, ke poza nia Elieza pule sa si keke tuna koreo. ");
INSERT INTO rug_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Ego, turaṉa mae nia e Zetoro, sa barikaleqe te Mosese, meke sari karua koreo pa korapa qega, vasina sapu korapa koa se Mosese koasa toqere hopena. ");
INSERT INTO rug_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Meke garunu va kenue la inavoso tu si asa koe Mosese sapu korapa mae si arini, gua. ");
INSERT INTO rug_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Ke la tutuvia Mosese si asa, meke todoṉo pa kenuna, meke ahoa sa si asa, meke nanasani ri karua sari na dia tinoa, meke tiqe la pa ipi te Mosese si arini. ");
INSERT INTO rug_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Meke vivineini e Mosese koe Zetoro sari doduru ginugua, saripu evaṉi e Zihova koasa baṉara meke koari na tinoni pa popoa Izipi, pude harupi sari na tinoni Izireli. Meke vivineini tugo Mosese koasa sari na guguadi rina tinasuna saripu tutuvi rini pa inene, meke gua meke ele harupi e Zihova si arini. ");
INSERT INTO rug_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Meke sipu avosi Zetoro sari doduru vivinei arini si qetu hola si asa. ");
INSERT INTO rug_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Meke zama, “Mani tavahesi se Zihova sapu harupu puleni gamu koasa baṉara, meke koari na tie pa popoa Izipi! Mani tavahesi se Zihova sapu harupu puleni sari Nana tie koasa tina pausudia. ");
INSERT INTO rug_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Ego, kamahire si gilania rau sapu e Zihova si ululu holani sari doduru tamasa pule, sina ele evaṉia Sa sapu gua asa, totoso doṉo goreni na ṉoṉovali ri na tie Izipi si arini.” ");
INSERT INTO rug_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Beto hoi si paleke la nia e Zetoro si keke kurukuru doduruna pude va vukivukihi va uququa, meke kaiqa pule, pude vala ni koe Tamasa. Ari Eroni meke sari doduru koimata tadi na tie Izireli si luli koasa, pude henai sari na ginani madidi tana vinahesi. ");
INSERT INTO rug_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Pa koivugona, si pitu va toṉoti e Mosese sari na ninominomi tadi na tinoni Izireli; meke tupiti mate si asa, podalae munumunu meke kamoa pana boṉi. ");
INSERT INTO rug_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Meke sipu dogori e Zetoro sari doduru tinavete saripu taveti e Mosese, si nanasa guahe si asa, “Nasa sari doduru tinavete hire, saripu korapa taveti goi tadi na tie? Na vegua ke tavete eke betoi goi telemu sari doduru, meke sari na tie si korapa turu tani, meke tepa nigo tinokae, podalae munumunu meke kamoa boṉi?” ");
INSERT INTO rug_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Meke olaṉa se Mosese, “Ura mae koa rau sari na tie pude hata ia sa vinatoṉoto te Tamasa. Ke kaqu tavetia rau si asa. ");
INSERT INTO rug_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Pana varitokei sari karua tie, si mae koa rau si arini, meke arau si vizatia sapu esei ri karua si toṉoto, meke kaqu tozini rau sari na zinama na vina tumatumae te Tamasa.” ");
INSERT INTO rug_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Meke zama se Zetoro, “Sa siraṉa sapu tavetia goi sana si lopu toṉoto. ");
INSERT INTO rug_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Agoi meke sari doduru tie hire si kote mabo sisigiti sina mamata sisigiti sa tinavete hie koa goi meke lopu boka tavete ekea goi si asa. ");
INSERT INTO rug_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Ego, maqu ponigo kamahire kaiqa vinaritokae leadi, meke mani koa koa goi sa Tamasa. Meke kaqu na tie varikarovae si agoi koa rina tie pa kenuna sa Tamasa meke paleke maeni sari na dia tinasuna. ");
INSERT INTO rug_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Kaqu va tumatumae nia goi koa rini sa tinarae te Tamasa, meke va dogoro nia koa rini sa siraṉana sa tinoa, meke sa tinavete sapu kaqu tavetia rini. ");
INSERT INTO rug_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Ba guahe si kaqu tomo la nia goi koari na mua tinavete. Kaqu vizati goi si kaiqa tie bokabokadi, meke kaqu na koimata koari na tinoni si arini. Kaiqa si kaqu koimatani si kaiqa tina, kaiqa si kaiqa gogoto, kaiqa si ari ka lima ṉavulu meke kaiqa si ari ka manege puta. Kaqu na tie te Tamasa meke ta ronuedi saripu lopu boka ta tabara golomo pude ta sekesekei koari na dia tinavete. ");
INSERT INTO rug_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Madi koa varitokae pa tinavete varipitui si arini doduru totoso koari na tie, ba sari na tinasuna nomadi si kaqu paleke mae ni rini koa goi. Meke sari na tinasuna hitekedi si kaqu pitui mo rini teledia, gua asa si lopu kaqu tasuna koa goi si arini, pude paleke toka nigo rini sa pinaleke mamata. ");
INSERT INTO rug_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ego, be lulia goi sa zinama te Tamasa sapu gua asa, si lopu kaqu va mabo pule nigo si goi, meke sari doduru tie hire si kote ele tava toṉoto dia tinasuna, meke pule la pa dia vetu,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Ke avosia Mosese sa roana sapu se Zetoro, meke taveti sa sari doduru ginugua saripu zama ni sa koasa. ");
INSERT INTO rug_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Meke vizati Mosese sari na tie bokabokadi koari doduru tie Izireli, meke va koimata i sa koari na tina tie, koari na keke gogoto tie, na lima ṉavulu tie, meke manege puta tie. ");
INSERT INTO rug_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Meke koa varitokae pa tinavete varipitui koari na tie si arini doduru totoso, meke paleke lani rini koe Mosese sari na tinasuna nomadi, ba pitui mo rini sari na tinasuna hitekedi. ");
INSERT INTO rug_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Beto asa, si zama luluaria e Mosese se Zetoro meke pule la pa nana popoa si asa. ");
INSERT INTO rug_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Meke taluarae sari na tie Izireli pa Repidimi. Meke pa rane kekenu koasa sidara vina ṉeta, pa mudina sipu taluarae rini pa popoa Izipi, si mae koasa qega pa Saenai si arini. Meke mae koa varigara vasina pa hubina sa toqere Saenai. ");
INSERT INTO rug_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Meke sage la pa toqere se Mosese, pude la tutuvia sa Tamasa, gua. Meke zama sa Tamasa koa sa pa toqere meke tozi nia Sa si asa, pude kaqu zama guahe koari na tie Izireli, ");
INSERT INTO rug_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","“Ele dogoria gamu, sapu gua ele tavetia Arau Zihova koari na tie pa popoa Izipi, meke turaṉa gamu, kekeṉoṉo guana atata sapu palekia sa tuna, meke turaṉa maeni gamu tani koa Rau. ");
INSERT INTO rug_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Ego, be va tabei na kopuni gamu kamahire sari na Qua vinariva egoi koa gamu, si kaqu na Qua tie soti si gamu. Ura sa doduruna sa kasia popoa si Taqarau mo, ba gamu sari na Qua tie ta vizatamia. ");
INSERT INTO rug_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Gua ri na butubutu hiama pu va madi Rau telequ pude na butubutu tava madi mia.” ");
INSERT INTO rug_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Ke gore la se Mosese meke tioko varigarani sari doduru koimata na tinoni, meke tozi koarini sari doduru ginugua pu ele zama ni e Zihova koasa. ");
INSERT INTO rug_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Beto asa, si olaṉa keke gua sari doduru tie, “Kaqu va tabei gami sari doduru gua pu zamani e Zihova,” gua si arini, meke pule la tozi e Mosese koe Zihova sari doduru gua pu zama ni ri na tie koasa. ");
INSERT INTO rug_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Meke zama koe Mosese se Zihova, “Kaqu mae si Rau koa goi pa korapa lei moatana, pude kaqu avosia rina tie, sapu zama si Rau meke kaqu va hinokarigo rini podalae kamahire.” Meke la tozia e Mosese koe Zihova sa inolaṉa tadi na tinoni Izireli. ");
INSERT INTO rug_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Meke zama koasa se Zihova, “Mu la tozini sari na tinoni pude va via i dia tinoa podalae pa rane ṉinoroi meke vugo pude vahesi Au si Arau. Kaqu sopu va via i rini sari na dia poko, ");
INSERT INTO rug_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","pude madi va namanama nia sa rane pana repere. Meke koasa rane sana si kaqu gore mae si Rau koasa toqere pa Saenai meke kaqu dogoro Au rini vasina. ");
INSERT INTO rug_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Mamu voloso hukatia tugo sa vari likohaena sa toqere, pude lopu kaqu ene karovia rina tie si asa. Meke kaqu tozini tugo goi sari na tie, pude lopu kaqu ene sage la pa toqere, babe ene tata la koasa hubina. Ego, be keke tie si ene la netia si asa, si kaqu tava mate tugo si asa. ");
INSERT INTO rug_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Namu loke tie kaqu tiqua si asa, ba kaqu ta gona patu babe na tupi si asa. Be na tie sia babe na kurukuru ba kaqu tava mate si arini! Ba pana ta ivu va gelenae sa buki, si kaqu ene tata la koasa voloso pa toqere sari na tie,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Meke taluarae gore mae pa toqere se Mosese, meke tozini sa sari na tie pude va namanama, pude vahesia sa Tamasa. Ke sopu va via i rini sari na dia poko. ");
INSERT INTO rug_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Meke zama la koa rini se Mosese, “Mi va namanama nia sa rane pana repere, mamu lopu va tata i sari na mia barikaleqe,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Ego, koasa munumununa sa rane vina ṉeta, si kapi na paka sa popoa, meke hakea na lei sa batuna sa toqere. Meke ta avoso sa kabona sa buki, meke matagutu na neneqara hola sari na tinoni. ");
INSERT INTO rug_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Meke turaṉa vurani Mosese koari na dia ipi sari na tinoni Izireli, meke turu pa hubina sa toqere si arini, pude tutuvia sa Tamasa. ");
INSERT INTO rug_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Meke opo tamunia na tuṉaha sa doduruna sa toqere Saenai, sina mae turaṉae koasa se Zihova pa korapa nika. Meke sage sa tuṉaha, guana tuṉaha tana nika lerana, meke matagutu na neneqara sisigiti sari doduru tinoni Izireli. ");
INSERT INTO rug_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Meke ṉiṉira lalanana sa mamalaiṉina sa buki, meke olaṉia e Tamasa sa zinama te Mosese pa korapana sa paka maṉauru. ");
INSERT INTO rug_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Meke gore mae pa batuna sa toqere Saenai sa Tamasa, meke tioko sage nia Sa se Mosese pa batuna sa toqere. Ke sage la se Mosese, ");
INSERT INTO rug_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","meke zama koasa se Zihova, “Mu gore la, mamu va balau i sari na tinoni pude lopu karovia rini sa voloso, pude mae dogorau. Be karovia rini si asa, si kaqu soku arini si tava mate. ");
INSERT INTO rug_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Meke gua tugo sari na hiama saripu tata mae koa Rau, si kaqu va via puleni. Ba be lopu gua asa, si kaqu tava mate si arini.” ");
INSERT INTO rug_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Meke zama la koe Zihova se Mosese, “Sari na tie si lopu kaqu boka sage atu pa toqere Saenai, sina ele tozini gami Goi pude va hopea sa toqere, meke ta voloso vari likohae si asa.” ");
INSERT INTO rug_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Meke olaṉa la ia Zihova si asa, “Mu gore la, mamu turaṉa sage mae nia se Eroni. Ba sari na hiama meke sari na tie si lopu kaqu karovia sa voloso pude sage mae koa Rau. Ba be karovia rini si asa, si kaqu tava mate si arini,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Ke tiqe gore la koari na tinoni se Mosese, meke tozini sa koarini saripu gua zamani e Zihova. ");
INSERT INTO rug_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Hire sari na zinama te Tamasa, saripu zama ni Sa: ");
INSERT INTO rug_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Arau tugo se Zihova sa mia Tamasa, sapu turaṉa vurani gamu pa popoa Izipi, vasina pu koa tava pinausu si gamu. ");
INSERT INTO rug_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Loke Tamasa si kaqu vahesia gamu ba Arau mo. ");
INSERT INTO rug_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Lopu kaqu taveti gamu kinehadi sari na tiṉitoṉa pa maṉauru meke pa pepeso babe pa korapa kolo. ");
INSERT INTO rug_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Lopu kaqu todoṉo nia na vahesia gamu si keke beku, ura Arau se Zihova sa mia Tamasa sina Tamasa kono si Rau, meke lopu va malumu gamu Rau pude vahesi sari kaiqa tamasa pule. Kaqu va kilasi Rau si arini pu kana Au meke sari na dia pinodopodo kamoa ka ṉeta meke made sinage. ");
INSERT INTO rug_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Ba kaqu tataru ni Rau sari na tina sinage na sage saripu tataru Nau na va tabei sari na Qua tinarae. ");
INSERT INTO rug_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Meke mu poza kokoha nia pa tinokotokoro sa pozaqu, ura kaqu va kilasia Arau Zihova, sa mua Tamasa, sa tie sapu poza hoboro nia ginugua seana sa pozaqu. ");
INSERT INTO rug_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Mu kopu nia na va madia goi sa rane Sabati. ");
INSERT INTO rug_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Koari ka onomo rane si kaqu taveti gamu sari na mia tinavete, ");
INSERT INTO rug_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","ba sa rane vina zuapa, si na rane magogoso sapu ele va madia Rau. Koasa rane asa si loke tie si kaqu tavetavete: agoi, sari na tumu, sari na mua kurukuru, babe sari na tie karovodi saripu koa pa mua popoa. ");
INSERT INTO rug_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Ura koari ka onomo rane si tavetia Arau e Zihova sa pepeso, sa maṉauru, sa lamana, meke sari doduru likakalae koa rini, ba pa rane vina zuapa si magogoso si Rau. Gua asa si va hopea Rau sa rane Sabati meke va madia Rau si asa. ");
INSERT INTO rug_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Mu va lavatia sa tamamu meke sa tinamu, gua asa si kote koa va gelenae si goi pa popoa sapu kaqu poninigo Rau. ");
INSERT INTO rug_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Meke mu variva mate. ");
INSERT INTO rug_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Meke mu barabarata. ");
INSERT INTO rug_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Meke mu hiko. ");
INSERT INTO rug_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Meke mu zutu kokoha ia si keke tie. ");
INSERT INTO rug_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Meke mu okoro nia goi sa vetu tanisa keke tie, sa nana barikaleqe, sari nana pinausu koreo na vineki, sari nana kurukuru, meke sari nana doṉ'ki, babe kaiqa toṉa pule saripu tagoi sa tie.” ");
INSERT INTO rug_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Ego, sipu avosia ri na tinoni sa paka na avoloṉanana sa buki, meke dogoria rini sa malakapina sa kapi, meke sa tuṉahana sa toqere, si matagutu na neneqara sisigiti, meke turu pa seu si arini. ");
INSERT INTO rug_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Meke zama la koe Mosese si arini, “Mamu zama koa gami meke kote va avoso si gami, ba mani lopu zama toṉoto mae koa gami sa Tamasa, sina kote mate si gami,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Meke olaṉa se Mosese, “Mi lopu matagutu. Na hiva va sosodea mo Tamasa sapu pude pamaṉa nia gamu si Asa, meke lopu makudo va tabea gamu si Asa, meke lopu kaqu tavete va sea si gamu,” gua. ");
INSERT INTO rug_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Ba turu va seu dia tugo sari na tie, meke e Mosese mo telena si ene tata la koasa lei muho, vasina koa sa Tamasa. ");
INSERT INTO rug_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Meke tozi nia Zihova se Mosese, pude zamani koari na tie Izireli si hire, “Ele dogoria gamu sapu Arau, Zihova si ele zama gore mae guahe pa maṉauru, koa gamu. ");
INSERT INTO rug_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Mi lopu taveti sari na tamasa siliva babe qolo, ba Arau mo si mi vahesi eke Au. ");
INSERT INTO rug_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Mamu tavete poni Nau si keke hope pepeso, mamu va vukivukihi ni vasina sari na mia sipi, qoti, na bulumakao, pude na vina vukivukihi tava uqudi, meke vina vukivukihi pa hinenahena binaere. Kaqu mae si Rau meke manani gamu, pa doduru vasina sapu ele va madi poni gamu Rau, pude vahesi Au. ");
INSERT INTO rug_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Ego, be guana tavete poni Nau gamu si keke hope patu, si mamu lopu peqoi sari na patu, ura be guana peqoni tiṉitoṉa tavetaveteana gamu sari na patu, si lopu kaqu qetu nia Rau si asa, na lopu garo pa vinahesi si arini. ");
INSERT INTO rug_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Mi lopu tavete nia halehaleana sage sa hope. Ba be tavetia gamu si asa si kote ta dogoro dodoho mia sipu haele sagea gamu sa halehaleana.” ");
INSERT INTO rug_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Beto asa si zama la koe Mosese sa Tamasa, “Hire sari na tinaraedi rina pinausu sapu kaqu valani goi koari na tie Izireli: ");
INSERT INTO rug_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Be guana holua goi si keke pinausu Hiburu, si kaqu tavetavete ponigo sa ka onomo vuaheni. Meke koasa vuaheni vina zuapa si kaqu ta rupaha, meke loke nana lipulipu si asa. ");
INSERT INTO rug_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Be na pinausu lelekena meke mae si asa, si kaqu lelekena tugo meke ta rupaha taloa si asa. Ba be na pinausu varihabana si asa, si mani turaṉa taloa nia sa sa nana barikaleqe. ");
INSERT INTO rug_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Ba be va haba nia sa palabatu pu tagona si keke barikaleqe koasa tie, meke va podo nia koburu koreo babe vineki sa si asa, si kaqu koa hola guana pinausu tugo tanisa sa barikaleqe meke sari nana koburu, meke sa tie mo si kaqu ta rupaha taloa nana mo. ");
INSERT INTO rug_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Ba be zama guahe sa pinausu, ‘Tataru nia rau sa qua palabatu, meke sa qua barikaleqe meke sari na tuqu,’ gua, meke lopu hiva ta rupaha taloa si asa, ");
INSERT INTO rug_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","si kaqu turaṉa la nia sa nana palabatu si asa koari na tie varipitui pa kenuna sa Tamasa. Meke kaqu va turu kapae ia sa pa tukutukuna sa sasada babe koasa dedegere sasada meke tiqe lopaia sa sa taliṉana. Beto asa si kaqu na nana pinausu si asa pa doduruna sa nana tinoa. ");
INSERT INTO rug_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Be keke tie si holuholu nia sa sa tuna vineki pude na pinausu gua, ba lopu kaqu ta rupaha taloa kekeṉoṉo gua ri na pinausu tie. ");
INSERT INTO rug_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Ego, be ta holuholue si asa koa ke tie, pude na barikaleqe pinausu tanisa gua, ba lopu hiva nia sa tie si asa, si kaqu vata holu pule la nia sa tie koasa tamana sa barikaleqe si asa. Lopu kaqu holuholu nia sa koari na tie karovodi, sina lopu ronua sa si asa. Kumatia sa sa nana vina tatara koasa. ");
INSERT INTO rug_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Ba be keke tie si holua si keke pinausu vineki pude va haba nia koasa tuna koreo gua, si kaqu tataru gunia na tuna vineki soti sa si asa. ");
INSERT INTO rug_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Be keke tie si vagi pulea si keke barikaleqe pude na nana barikaleqe vina rua, gua, si mani lopu makudo tugo pude tataru nia sa sa barikaleqe kekenu. Kaqu gunia tugo sa sa nana barikaleqe kekenu pa ginani, poko, na koa turaṉia sa, gua tugo pa pinodalaena sa dia kinoa keke pa vinarihaba. ");
INSERT INTO rug_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Ego, be lopu tavete lani sa tie hie sari nana tinavete koasa barikaleqe kekenu, si kaqu vata rupahia sa si asa, meke loke nana gale sa barikaleqe koasa. ");
INSERT INTO rug_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Asa sapu sekea si keke tie meke va matea, si kaqu tava mate tugo si asa. ");
INSERT INTO rug_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Ba be lopu pa nana hiniva pude va matea sa tie, gua, ba na ta evaṉa hola nana mo, gua, si kote boka govete la nana koa ke vasina sapu Arau kote vizatia pude la ia sa; meke vasina si kaqu tava sare si asa. ");
INSERT INTO rug_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Ba pana bugoro sisigiti si keke tie meke kuhana nia sa sa tie meke va matea sa, si kaqu tava mate tugo sa tie asa. Be guana haqala la si asa koasa Qua hope pude tava sare, ba kaqu tava mate tugo sa tie asa. ");
INSERT INTO rug_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Asa sapu sekea sa tamana babe tinana, si kaqu tava mate tugo si asa. ");
INSERT INTO rug_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Asa sapu ososo tuqe taloa nia si keke turaṉana, pude holuholu nia, babe korapa kopu nia pude nana pinausu gua, si kaqu tava mate tugo si asa. ");
INSERT INTO rug_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Asa sapu zama ṉoṉovalia sa tamana babe sa tinana, si kaqu tava mate tugo si asa. ");
INSERT INTO rug_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","19","Be ta evaṉa si keke vinariperai, meke la si keke tie meke gona nia patu sapu keke babe tupaia, ba lopu va matea sa si asa, si lopu kaqu tava mate si asa pu gonana ba be tupana si asa. Ba be eko pa nana teqe sa tie bakorana hie, meke mumudi si tekulu si asa meke hodu vura la pa sada; sa tie sapu va bakoraia sa tie hie si kaqu here nia sa sa nana totoso sapu ta okipalae hoboro, meke kaqu kopu nia sa si asa osolae ibu sa bakorana. ");
INSERT INTO rug_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Be keke tie si hena vagia si keke huda meke seke va matea pa totoso tugo asa sa nana pinausu koreo babe pinausu vineki, sa tie asa si kaqu tava kilasa tugo. ");
INSERT INTO rug_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Ba be hola keke be karua rane si leana pule nana sa pinausu, si lopu kaqu tava kilasa sa tie, sina nana tinago sa tie sa pinausu asa. ");
INSERT INTO rug_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Be kaiqa tie si variperai meke sekea si keke barikaleqe aritiana, ke ta podo mokoe sa nana koburu, ba loketoṉa bakora nomana pule si ta evaṉa koasa; ke sa tie pu va huarana sa si kaqu here nia si asa, padana gua, sapu tepa ia sa palabatu tanisa barikaleqe, meke va egoa rina tie varipitui. ");
INSERT INTO rug_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Ba be na tinasuna si kamo koasa barikaleqe; ke sa vina kilasa sapu kaqu vagia sa, si hobe nia tinoa sa tinoa. ");
INSERT INTO rug_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Hobe nia mata sa mata, hobe nia livo sa livo, hobe nia lima sa lima, hobe nia nene sa nene, ");
INSERT INTO rug_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","hobe nia sinulu sa sulu, hobe nia bakora sa binakora, hobe nia tebotebo ehara sa tebo ehara. ");
INSERT INTO rug_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Be sekea keke tie sa matana sa nana pinausu koreo babe vineki meke va behua sa si keke kali matana si asa, si kaqu vata rupahia sa si asa, pude na hinobena sa matana. ");
INSERT INTO rug_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Be tupa pakoa sa sa livona, si kaqu vata rupahia sa sa pinausu asa, pude na hinobena sa livona. ");
INSERT INTO rug_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Be hoata va matea keke bulumakao kokoreo si keke tie, si kaqu ta gona patu sa bulumakao kokoreo, meke sa masana si lopu kaqu ta gani; ba sa tie sapu tagona sa bulumakao kokoreo hie si lopu kaqu tava kilasa. ");
INSERT INTO rug_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Ba be asa mo sa hahanana sapu hoke tavetia sa bulumakao kokoreo, hoke tava balau tugo, ba lopu ta veko pa bara si asa. Ego, mumudi si hoata va matea sa si keke tie, ke kaqu ta gona patu sa bulumakao kokoreo, meke sa tie sapu tagona sa bulumakao kokoreo hie si kaqu tava mate tugo. ");
INSERT INTO rug_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Ba be tava malumu pude veko hinere sa tie pu tagona sa bulumakao kokoreo, pude va sarea sa nana tinoa, gua, si mani here va hokotia sa sa doduruna sapu gua ta hivae. ");
INSERT INTO rug_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Be va matea sa bulumakao kokoreo si keke koreo babe vineki, si sa tinarae tugo asa si kaqu ta tavetavetae vasina. ");
INSERT INTO rug_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Be va matea sa bulumakao kokoreo si keke pinausu koreo babe pinausu vineki. Sa tie sapu tagona sa bulumakao kokoreo hie, si kaqu here nia ka toloṉavulu puta poata siliva sa tie sapu tagona sa pinausu. Beto asa si kaqu ta gona va mate sa bulumakao kokoreo asa. ");
INSERT INTO rug_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Be keke tie si tukelia si keke pou, babe gelia sa si keke meke lopu tukua sa, meke hoqa voi vasina si keke bulumakao kokoreo, babe keke doṉ'ki, ");
INSERT INTO rug_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","si kaqu here nia sa tie pu tagona sa pou asa, sa tie pu tagona sa kurukuru ṉame sapu mate. Meke kaqu vagia sa tie herehere hie sa kurukuru sapu matena. ");
INSERT INTO rug_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Be va matea sa bulumakao kokoreo, tanisa keke tie, si keke bulumakao kokoreo tanisa keke. Sari karua tie hire si kaqu holuholu nia sa bulumakao kokoreo toana, meke variva hiani ri karua sari na poatana, meke gua tugo sa bulumakao kokoreo matena, kaqu vari va hiani ri karua sari na masana. ");
INSERT INTO rug_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Ba be ta gilana sapu hoke raraza nia kikihona sa bulumakao kokoreo hie, meke lopu ta kopue pa korapa bara koasa tie pu tagona sa, si kaqu varihobei bulumakao kokoreo sari kara, sapu matena si kaqu ta vala koasa pu tagona sa bulumakao toana meke kaqu hobea tugo sa sapu matena. ");
INSERT INTO rug_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Be keke tie si hikoa si keke bulumakao kokoreo ba be keke sipi meke va matea babe holuholu nia, si kaqu hobe nia ka lima bulumakao kokoreo sa sa bulumakao kokoreo sapu hikoa sa. Meke sa sipi si kaqu hobe nia ka made sipi sa si asa. ");
INSERT INTO rug_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Ego, be ta tuqe si keke tie hikohiko pana boṉi, meke ta seke va mate, si lopu sea nia sa tie sapu tuqena sa vina matena sa; ");
INSERT INTO rug_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Ba be ele rane seunae tu ta evaṉa gua sa hiko, si sea nia sa sa vina matena sa tie. Kaqu here nia sa tie hikohiko sa laena sa nana hinikohiko, babe lopu gua asa, si kaqu ta holuholue si asa pa tinavete pinausu, pude na hinerena sa nana hinikohiko. ");
INSERT INTO rug_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Be ta dogoro sa kurukuru ṉame sapu ta hikona koari nana tinago saripu tagoi sa, be na bulumakao babe doṉ'ki babe sipi sia, si kaqu tomo rua sa nana hinere sa tie hikohiko sana. ");
INSERT INTO rug_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Be keke tie si va ganigani pa nana inuma babe pa keke nana inuma vaeni sari nana bulumakao; beto hoi si karovo sea latu pa keke inuma tanisa keke tie sari na bulumakao, meke la ganigani. Kaqu hereni sa tie pu ari nana bulumakao, sari na ginani leadi, saripu gani ri na nana bulumakao, koasa inuma tanisa tie, babe koasa nana inuma vaeni. ");
INSERT INTO rug_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Be va katua sa tie si keke nika meke sulu sa hiqohiqo, meke karovo la ia sa inuma tanisa keke tie meke ta sulu sari na linetelete saripu tiqe toqolodi, babe sari na linetelete saripu turu varigaraedi, ba be sa doduruna mo sa nana inuma sa tie si ta sulu beto; ego, sa tie pu va katuna sa nika, si kaqu hereni sari na linetelete pu ta sulu koasa inuma tanisa tie sana. ");
INSERT INTO rug_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Be keke tie si valani koasa turaṉana si kaiqa poata siliva babe kaiqa tiṉitoṉa pude kopu ponia gua; meke ta hiko si arini koasa vetu tanisa turaṉana. Meke be ta vagi sa tie hikohiko, si kaqu tomo rua sa hinerehere tanisa tie hikohiko sana. ");
INSERT INTO rug_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Ba be lopu ta dogoro sa tie hikohiko, ego, sa tie sapu kopu nia sa tiṉitoṉa marilaena si kaqu ta turaṉa la pa vasina tadi na tie varipitui, meke kaqu zama tokotokoro nia sa sapu lopu hikoa sa sa tinago tanisa sa tie sana, gua. ");
INSERT INTO rug_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Ba be sari karua si lopu variva ego nia sapu tesei nana si keketoṉa. Be na bulumakao, na doṉ'ki, sipi, poko sia, ba be kaiqa toṉa pule, si ego, sari karua tie hire sapu hopeke zama, ‘Na qua rau’ gua, si kaqu ta turaṉa la pa vasina vinaripitui. Vasina tu kaqu tozi vura nia sa tie varipitui sapu esei si sea, meke kaqu tomo rua sa nana hinerehere koasa tie toṉoto. ");
INSERT INTO rug_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Be keke tie si tepa ia sa turaṉana pude kopu vala nia sa nana kurukuru ṉame, be na doṉ'ki, babe na bulumakao, babe na sipi, babe kaiqa kurukuru ṉame pule, meke be mate, babe bakora, babe ta hiko taloa sa kurukuru ṉame asa; meke namu loke tie gilania sapu gua ta evaṉa koasa kurukuru ṉame asa; ");
INSERT INTO rug_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","sa tie sapu kopuna sa kurukuru sana, si kaqu la pa vasina vinaripitui, meke zama tokotokoro nia, sapu lopu hikoa sa sa kurukuru ṉame tanisa turaṉana. Be va hinokaria sa turaṉana pu ari nana, sapu lopu hikoa sa tie kopuna sa nana kurukuru ṉame, ba na muliuṉu mo, gua, si lopu ta hivae pude here nia sa tie kopuna sa tie pu ari nana. ");
INSERT INTO rug_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Ba be ta hiko sa kurukuru ṉame koasa tie sapu kopuna si asa, si kaqu ta herei sa tie sapu ari nana kurukuru ṉame. ");
INSERT INTO rug_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Babe tava mate si asa koari na kurukuru pinomo. Sa tie pu kopuna sa kurukuru, si kaqu paleke la nia koasa tie sapu ari nana kurukuru, sa kurukuru asa pude na vina sosode; meke lopu ta hivae pude here nia sapu tava mate koari na kurukuru pinomo si asa. ");
INSERT INTO rug_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Be keke tie si vagi pakia mo sa si keke kurukuru ṉame koa keke tie, meke bakora babe mate si asa, totoso lopu koa sa tie sapu ari nana, ke kaqu holua sa tie pu vagi pakina si asa, koasa tie pu ari nana. ");
INSERT INTO rug_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Ba be ta evaṉa si asa totoso koa nana sa tie sapu ari nana kurukuru ṉame si lopu kaqu tabaria sa tie si asa. Be ta tabara poata sa tie sapu ari nana kurukuru ṉame koari hopehopeke totoso pa tinavete, sa binakora babe minate tanisa kurukuru ṉame sana, si ele ta tabara koasa poata asa. ");
INSERT INTO rug_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Be keke tie si ṉoṉovalia si keke vineki vaqurana toa, sapu lopu ele ta pinirovetu vekona, kaqu veko nia poata sa si asa meke haba ia. ");
INSERT INTO rug_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Ba be lopu va malumia sa tamana pude haba ia sa sa tuna vineki, si kaqu here nia kaiqa poata sa sa tamana, padana gua sa inivasana sa vineki vaqurana toa, sapu lopu ele hite ta ṉoṉovala koa ke tie. ");
INSERT INTO rug_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Kaqu tava mate sa barikaleqe sapu na tie vakuvakutae. ");
INSERT INTO rug_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Kaqu tava mate sa tie sapu tavete va sea ia si keke kurukuru ṉame. ");
INSERT INTO rug_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Kaqu tava kilasa pa minate si keke tie, sapu va vukivukihi la koa keke tamasa, sapu lopu e Zihova, sa Tamasa hinokara. ");
INSERT INTO rug_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Mi lopu ṉoṉovalia babe vata sigitia gamu si keke tie karovona. Mi balabala ia sapu gamu, ba na tie karovomia tugo pa Izipi. ");
INSERT INTO rug_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Mi lopu ṉoṉovalia gamu si keke nabonaboko babe keke tie eapana. ");
INSERT INTO rug_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Be ṉoṉovalia gamu si asa, si Arau, sapu e Zihova, si kaqu avosia pana kabo alili mae ia rini sa Qua tinokae, ");
INSERT INTO rug_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Meke kaqu bugoroni gamu Rau, meke va mate gamu pa vinaripera. Meke kaqu koa nabonaboko sari na mia barikaleqe meke sari na tumia si kaqu loke tamadia. ");
INSERT INTO rug_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Be vala paki poata si gamu koari na Qua tinoni saripu habahualadi; meke tavetavete kekeṉoṉo sari na tie pu hoke va malumu lipulipu, lopu tepa tomo nia gamu gua sapu ele ta poni nia sa koa gamu. ");
INSERT INTO rug_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Be vagia goi koa ke tie si keke koti pude na vina sosodena sapu kaqu tabarigo sa, gua. Kaqu va pule vala nia goi si asa koasa, sipu lopu ele lodu sa rimata, ");
INSERT INTO rug_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","sina asa mo sa titeke koti maṉini sapu tagoia sa. Loketoṉa pule si boka puta nia sa. Pana kabo alilia sa sa Qua tinokae, si kaqu avosia Rau si asa, sina tataru ni Rau sari na tie tasunadi. ");
INSERT INTO rug_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Mi lopu zama ṉoṉovala ia gamu sa Tamasa, meke lopu zama va kaleania goi sa koimata tadi na tinoni. ");
INSERT INTO rug_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Mi lopu hekini koa Rau sari na mia vinariponi, sari na vua kenudi ri na mia pinakepakete, sari na huiti, vaeni, na oela olive, na gua. Mi poni Nau tugo sari na tumia koreo kenudi. ");
INSERT INTO rug_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Mi poni Nau tugo sari na mia bulumakao na sipi podo kenudi. Ba madi koa paki ka zuapa ranedi sari na tudia kokoreo koa ri na tinadia, meke pa rane vina vesu, si kaqu ta poni mae koa Rau si arini. ");
INSERT INTO rug_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Gamu si na Qua tie tava madimia. Ke mi lopu henai sari na masadi rina kurukuru ṉame saripu tava mate koari na kurukuru pinomodi; ba mi poni lani koari na siki. ");
INSERT INTO rug_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Mu lopu va ene hoboro inavoso kokohadi, meke lopu toka nia sa tie seana, pude helahelae vurani sari na zinama kokohadi. ");
INSERT INTO rug_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Mu lopu somana luli koasa vinarigara tie totoso lulia rini sapu seana babe tozi vura nia sapu seana pude huaria sa vinilasa toṉotona. ");
INSERT INTO rug_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Be koa pa vinaripitui si keke tie, si mamu lopu toka kale nia, sina na tie habahualana si asa. ");
INSERT INTO rug_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Be ta evaṉa sapu dogoria goi sa bulumakao babe doṉ'ki tanisa mua kana sapu ene hoboro, si mamu turaṉa pule la nia koasa pu tagona. ");
INSERT INTO rug_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Be hoqa turaṉia sa nana doṉ'ki sa nana pinaleke si mamu lopu va talevara hola, ba mamu toka nia sa mua kana pude va turu pulea sa doṉ'ki. ");
INSERT INTO rug_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Mu lopu oso nia goi koa ke tie habahualana sa tinoṉoto, pana ta pitu si asa. ");
INSERT INTO rug_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Mu lopu zutu kokoha ia goi si keke tie meke lopu va mate hoboria goi si keke tie toṉoto, ura kote zutua Rau sa tie gua asa, sapu tavete va sea. ");
INSERT INTO rug_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Mu lopu ade vagia goi sa poata tanisa tie pu hiva nigo, pude tavete ponia sa kinaleana koasa, ura sa poata gua asa si va behui sari na tie koasa tinoṉoto, meke ṉovali sari na tie hokara pu loke dia ginugua. ");
INSERT INTO rug_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Mi lopu ṉoṉovalia gamu si keke tie karovona; na ele gilania mia mo gamu si pude na tie karovona, ura gamu ba na tie karovo mia mo pa popoa Izipi. ");
INSERT INTO rug_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Ura koari ka onomo vuaheni si kaqu lelete na pakepakete si gamu koa ri na mia inuma, ");
INSERT INTO rug_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","ba koasa vuaheni vina zuapa, si mani tava magogoso meke lopu ta lete pule sa pepeso. Meke sari na tie malamalaṉadi saripu koadi koa gamu, si madi vagi gedi ginani vasina, meke sari na kurukuru pinomodi si madi gani saripu veko hola i rini. Meke gua tugo sari na mia inuma vaeni na linetelete olive. ");
INSERT INTO rug_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Ka onomo rane koari hopeke vuiki si kaqu tavetavete si gamu, ba loke tie si kaqu tavetavete koasa rane vina zuapa koari hopeke vuiki. Sari na mia pinausu na tie karovodi saripu tavetavete poni gamu meke sari na mia kurukuru ṉame ba kaqu magogoso beto tugo. ");
INSERT INTO rug_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Kaqu avosi na kopu valeani gamu sari na doduru zinama saripu zamani Arau Zihova koa gamu. Mu lopu varavara la koari kaiqa tamasa pule; namu lopu hivani Rau pude pozai gamu pozadi si arini. ");
INSERT INTO rug_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Ka ṉeta totoso koari hopeke vuaheni si kaqu tavete inevaṉa si gamu, pude va lavatau. ");
INSERT INTO rug_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Koasa sidara Abibi, sapu taluarae ia gamu pa popoa Izipi, si kaqu tavetia gamu sa Inevaṉa Bereti Loke Isitina d . Koari ka zuapa rane tanisa inevaṉa, mi hena ia gamu sa bereti loke isitina, gua sapu ele tozini gamu Rau. Mu lopu mae somana pa vinahesi pana lopu paleke maeni gamu sari na mia vinariponi gua. ");
INSERT INTO rug_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Mi tavetia sa inevaṉa pakepakete, totoso podalae paketi gamu sari na mia vuvua, mi vala i koe Tamasa saripu vua kenudi pa mia inuma. Mi tavetia sa Inevaṉa vina balabaladi rina dia ipi pa qega pa totoso paketi gamu sari na vua huda na vaeni. ");
INSERT INTO rug_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Gamu doduru palabatu si kaqu mae vahesi Au si Arau, Zihova, sa mia Tamasa, koari ka ṉeta inevaṉa, koari hopeke vuaheni. ");
INSERT INTO rug_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Totoso va vukivukihi nia ehara kurukuru ṉame koa Rau, si mi lopu tavete turaṉia si keke vinariponi sapu henia na isiti, meke lopu kaqu va malumia goi si keke vasi deana koa holana koasa vina vukivukihi, pude tanisa rane vugo. ");
INSERT INTO rug_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Hopeke vuaheni si mi paleke va maei sari na mia pinakepakete huiti kekenu pa inuma koa rau pa vetu te Zihova sa mia Tamasa. Keke tuna qoti babe na tuna sipi sapu korapa susu pa tinana, si mi lopu raroia gamu koasa meleke tanisa tinana. ");
INSERT INTO rug_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Kaqu garunu va kenue atu nia Rau si keke mateana pude kopuni gamu koasa mia inene, meke pude turaṉa lani gamu koasa vasina sapu ele va nama veko nia Rau, gua. ");
INSERT INTO rug_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Kaqu avosia na va tabea gamu si asa. Mu lopu toketokea gamu si asa. Na lopu kaqu taleosoni sa sari na mia tinoketoke la koasa, sina pozaqu Rau si koa koasa. ");
INSERT INTO rug_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Ba be va tabei na taveti gamu sari doduru gua pu tozini gamu Rau, si kaqu varipera poni gamu Rau koari na mia kana. ");
INSERT INTO rug_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Sa Qua mateana si kaqu la va kenue koa gamu meke va kilasa beto pani sari doduru mia kana sapu sari na butubutu Amoraiti, Hitaiti, Perizaiti, Kenanaiti, Hivaiti meke Zebusaiti, meke turaṉa lani gamu koari na popoa arini. ");
INSERT INTO rug_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Mi lopu todoṉoni na vahesi gamu sari na dia tamasa, meke lopu vagi va karovi sari na dia hahanana vinahesi beku. Huari gedi sari na dia tamasa, mamu seke huhuari gedi sari na dedegere, saripu va hopei rini koari na dia vinahesi. ");
INSERT INTO rug_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Mi vahesi Au si Arau Zihova, sa mia Tamasa. Pana vahesi Au gamu, si kaqu qetuni gamu Rau meke poni gamu ginani na kolo, meke lopu kaqu raza gamu minoho. ");
INSERT INTO rug_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Namu loke barikaleqe pa mia popoa si kaqu mate tudia, sipu lopu ele kamo sa nana totoso podo, babe tige. Kaqu va toa gelenae i Rau sari na mia tinoa. ");
INSERT INTO rug_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Kaqu va tarazuzu kenui Rau sari na tinoni pu kana gamu, meke kaqu va pupuhi Rau sarini pu razai gamu, meke kaqu va goveti Rau koa gamu sari doduru mia kana. ");
INSERT INTO rug_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Kaqu va tarazuzu kenui Rau sari na mia kana, meke kaqu hadu taloani Rau sari na tie Hivaiti, na tie Kenani, meke sari na tie Hitaiti pa seu. ");
INSERT INTO rug_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Ba lopu kaqu hadu taloani Rau sari doduru tie pa keke vuaheni, be gua asa si kote ivulu sa popoa, meke kote ta soku holani gamu sari na kurukuru pinomodi. ");
INSERT INTO rug_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Gua asa ke kaqu kaiqa paki, osolae pada pude vagia gamu doduruna sa popoa. ");
INSERT INTO rug_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Kaqu taveti Rau sari na volosodi sari na mia popoa pude na kokoina sa pepeso, sapu kamo mae gua koasa koqu lavata pa Aqaba, meke kamo la gua pa kolo Meditareniani, meke topue koasa soloso qega tata pa Izipi, meke kamo la gua koasa Ovuku Iuparetisi. Kaqu poni gamu Rau sa ṉiniraṉira sapu holani koari pu koadi koasa popoa, meke kaqu hadu la ni gamu pa seu si arini. ");
INSERT INTO rug_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Mi lopu taveti gamu si kaiqa vinariva egoi koari na tie sara, babe koari na dia tamasa. ");
INSERT INTO rug_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Lopu kaqu va koai gamu pa mia popoa sari na tie arini, be va koai gamu, si kote turaṉa va sea gamu rini, meke kana Au si Arau. Meke be vahesi gamu sari na dia tamasa, si kote gua tugo sa tie sapu ele soto pa sipata si gamu.” ");
INSERT INTO rug_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Meke zama la koe Mosese se Zihova, “Agoi meke Eroni, Nadabi, Abihu, meke ari ka zuapa ṉavulu puta koimata tadi na tie Izireli, si kaqu ene sage mae koa Rau pa toqere; meke pana lopu ele tata mae gamu, si mi todoṉo na vahesi Au. ");
INSERT INTO rug_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Loke tie pule, ba agoi mo telemu, si kaqu tata mae koa Rau. Sari na Koimata si kaqu ene sage meke vahesi Au pa seu, ba sari na tinoni Izireli ba namu lopu kaqu ene sage mae pa toqere,” gua. ");
INSERT INTO rug_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Meke la koari doduru tinoni Izireli se Mosese, meke tozi betoni koari doduru sari na zinama na tinarae te Zihova, si olaṉa beto sari doduru tinoni, “Kaqu va tabei gami sari doduru ginugua saripu zamani e Zihova,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Meke kubere gore betoni e Mosese sari doduru zinama te Zihova. Meke pa koivugona sa munumunu asa, si tavetia e Mosese si keke hope pa hubina sa toqere, meke varihakehake ni sa sari ka manege rua patu, keke patu koari hopeke butubutu Izireli. ");
INSERT INTO rug_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Beto meke tiqe garuni sa sari na tie vaqura pude va vukivukihi va uququ la koe Zihova, meke kaiqa bulumakao si tava vukivukihi pa hinenahena binaere koe Zihova, pude tanisa henahena varigara koari na tinoni Izireli, gua. ");
INSERT INTO rug_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Meke vagia Mosese sa padana sa kukuruna sa eharadi ri na kurukuru meke zoropo lani sa koari na besini, meke sapu keke kukuruna pule si siburu la nia sa koasa hope. ");
INSERT INTO rug_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Beto meke tiqe vagia Mosese sa buka, vasina ta kubere sa vinariva egoi te Zihova, meke tiro va ululae ia koari na tie. Meke olaṉa sari na tie, “Kaqu va tabei na taveti gami sari doduru ginugua pu tozini gami e Zihova,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Beto meke vagia Mosese sa ehara sapu voi koari na besini, siburu la nia sa koari na tinoni, meke zama, “Sa ehara hie si na vina gilagilana koasa mia vinariva egoi va nabu hie sapu kaqu kopu nia gamu, sapu variva ego nia gamu meke e Zihova, totoso vatui Sa sari Nana zinama,” gua. ");
INSERT INTO rug_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Meke sage la pa toqere sari Mosese, Eroni, Abihu, Nadabi, meke sari ka zuapa ṉavulu puta koimata tadi na tie Izireli, ");
INSERT INTO rug_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","meke dogoria rini sa Tamasa Izireli. Sa kaurudi ri nenena si doṉo guana keketoṉa sapu leleana hola, sapu balairi guana galegalearane meke bakala hola. ");
INSERT INTO rug_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Meke lopu va matei sa Tamasa sari na koimata tadi pa Izireli, ba dogoria mo rini si Asa, meke beto asa si napo na henahena varigara mo si arini. ");
INSERT INTO rug_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Meke zama la koe Mosese se Zihova, “Mu sage mae koa Rau pa toqere, mamu aqa vasina, meke kote ponigo Rau sari karua patu labelabe, vasina ta kubere sari doduru tinarae pude va tumatumae i sari na tie Izireli.” ");
INSERT INTO rug_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Meke va namanama se Mosese meke Zosua, sa nana tie vatukana meke podalae ene sage la pa toqere hopena se Mosese. ");
INSERT INTO rug_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Meke zamai Mosese sari na koimata, “Gamu si mamu aqani gami tani, osolae kamo pule mae si gami. Ari Eroni e Huri si koa turaṉa gamu meke esei sapu ari nana vinaritokei koa ke tie, si mani paleke mae nia koari kara,” gua. ");
INSERT INTO rug_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Meke sipu ene sage la pa toqere Saenai se Mosese, si nobi tamunia na lei si asa. ");
INSERT INTO rug_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","17","Meke sa ṉinedala te Zihova si gore mae pa batuna sa toqere. Meke dogoria rina tie Izireli sa kalalasa sapu doṉo guana nika huruṉuna pa batuna sa toqere. Meke ka onomo rane si nobi tamunia na lei sa toqere, meke koasa rane vina zuapa si titioko vura pa lei koe Mosese se Zihova. ");
INSERT INTO rug_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Meke sage hola latu pa batuna sa toqere koasa lei se Mosese. Meke vasina koa ka made ṉavulu puta rane na boṉi si asa. ");
INSERT INTO rug_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Meke zama la koe Mosese se Zihova, ");
INSERT INTO rug_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Tozini sari na tie Izireli pude va mae i koa Rau sari na vinariponi. Vagia gua sapu boka poni nia sa tie pa nana hiniva soti. ");
INSERT INTO rug_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Gua hire sari na vinariponi saripu kaqu ta vagi: qolo, siliva, boronizi; ");
INSERT INTO rug_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","poko lineni memelesina; meke vulu bulu, pepolo, meke ziṉara; poko sapu ta tavetae kalu qoti; ");
INSERT INTO rug_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","kapuna keke sipi kokoreo sapu tava ziṉara; kapu rumu tava popana; huda akesia; ");
INSERT INTO rug_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","oela tana zuke; oto huda humaṉa lea tana vina uququ, sari na votiki oto huda oela na pauda humaṉa lea tana oela olive tana va madi tie; ");
INSERT INTO rug_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","sari na patu ṉedala na vinasari doṉo lea, saripu soto koasa poko hiama hopena meke sa poko raqaraqa tanisa hiama kenukenue. ");
INSERT INTO rug_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Ego, kaqu tavete poni Au ri na tinoni si keke Ipi Hopena, pude kaqu somana koa koa rini si Rau. ");
INSERT INTO rug_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Meke sa tinavetena, meke sari doduru likakalae pa korapana, si kaqu gua puta tugo saripu va dogoro nigo Rau. ");
INSERT INTO rug_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Mi tavete nia huda akesia gamu sa Bokese Vinariva Egoi, keke gogoto manege puta sentimita sa ginelena, ka onomo ṉavulu onomo sentimita labena, onomo ṉavulu onomo sentimita ululuna. ");
INSERT INTO rug_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Mamu poko nia qolo pa korapana meke mudina, meke gua tugo doduru vari likohaena. ");
INSERT INTO rug_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Taveti ka made riṉi qolo palepalekeana; mamu va soto lani koari ka made nenena; karua riṉi koari karua kalina. ");
INSERT INTO rug_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Mamu tavete nia palepalekeana huda akesia; mamu va pokoni qolo si arini, ");
INSERT INTO rug_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","mamu va lopoto lani koari na riṉi, pa karua kalina sa bokese sari na huda. ");
INSERT INTO rug_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Meke lopu kaqu ta unusu vagi pule sari na huda palepalekeana koari na riṉi. ");
INSERT INTO rug_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Mamu tiqe vekoi pa korapa bokese hopena sari karua patu labelabe vasina ta kubere sari na tinarae, saripu kote vatui Rau. ");
INSERT INTO rug_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Mamu tavetia pa qolo viana si keke tukutuku, sapu keke gogoto manege puta sentimita gelena, meke onomo ṉavulu onomo sentimita labena. ");
INSERT INTO rug_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","19","Mamu sekeseke va vurai karua serubimi koasa tukutuku qolo keke pa hopeke kalina. Mamu sekesekei pude kaqu ta evaṉae keke tini sari karua mateana meke sa tukutukuna sa bokese. ");
INSERT INTO rug_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Sari karua serubimi si kaqu vari doṉo totoi meke sari na tatapurudi si kaqu nobia sa tukutuku. ");
INSERT INTO rug_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Mamu voi i pa korapa bokese sari karua patu labelabe, mamu tukua. ");
INSERT INTO rug_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Beto meke kaqu tutuvu gamu Rau panauluna sa tukutuku bokese hopena, pa varikorapadi ri karua mateana serubimi; meke kaqu zama vatuni Rau koa gamu na tie Izireli sari doduru Qua tinarae. ");
INSERT INTO rug_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Mamu tavete nia huda akesia si keke tevolo, vesu ṉavulu vesu sentimita gelena, made ṉavulu made sentimita labena, meke onomo ṉavulu onomo sentimita ululuna. ");
INSERT INTO rug_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Mamu tavetia keke poko sekesekeana sapu ta tavetae qolo viana, meke pa hukihukirina si ta napitae qolo. ");
INSERT INTO rug_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Mamu tavetia keke tokatoka sage pa hukihukirina sa tevolo. Sa ululuna si kaqu zuapa ṉavulu lima milimita ululuna meke sa hukihukirina panaulu si kaqu ta pokoe qolo. ");
INSERT INTO rug_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Mamu taveti ka made qolo riṉi palepalekeana, mamu hopeke va sotoi koari ka made iiona sa tevolo, vasina koa sari hopeke nenena. ");
INSERT INTO rug_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Sari na riṉi si kaqu ta soto kapae koasa tokatoka sage pude tuqei sari na huda palepalekeana tanisa tevolo. ");
INSERT INTO rug_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Mamu tavete nia karua palepalekeana huda akesia, mamu pokoni qolo. ");
INSERT INTO rug_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Mamu taveti sari na peleta, kapa, zagi, na besini, pude tana naponapoana vaeni; kaqu na qolo viana tavete betoni sari doduru hire. ");
INSERT INTO rug_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Kaqu ta veko pa kenuna sa Bokese Vinariva Egoi, sa tevolo, meke doduru totoso sa bereti madina sapu koa koasa tevolo, si kaqu ta poni mae koa Rau. ");
INSERT INTO rug_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Mamu tavete nia qolo viana si keke tuturuana zuke: sekeseke hitehite vura nia koasa sa hubina meke dedegerena; mamu tavete vurani kaiqa kineha kapa havohavoro, guana vina sari, sari na havoro lopu ele pelaradi, meke na elodi. Kote keke tini doduruna si arini. ");
INSERT INTO rug_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Kaqu ka onomo limana sa tuturuana zuke; ka ṉeta pa karua kalina. ");
INSERT INTO rug_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Hopeke koari ka onomo limana hire, si koadia sari ka ṉeta vinasari havoro, sapu doṉo gua kineha havoro olomodi, sapu koai elodi na havoro lopu ele pelaradi. ");
INSERT INTO rug_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Meke koasa dedegerena sa tuturuana zuke, si kaqu koadia sari ka made kapa, sapu doṉo guari na havoro huda olomodi kinehadi, sapu koai na havoro lopu ele pelaradi, meke na elodi. ");
INSERT INTO rug_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Kaqu koa nana si keke havoro lopu pelarana, panapeka koari ka ṉeta hopeke limadia. ");
INSERT INTO rug_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Sari na limana, meke sari na havoro lopu ele pelaradi, meke sa tuturuana zuke si kaqu ta sekeseke meke ta tavete vura pa qolo viana. ");
INSERT INTO rug_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Beto mamu taveti ka zuapa zuke oela hitekedi, mamu vekoi koasa tuturuana zuke, pude va kalalasia sa kenuna, sa vasina sapu koa sa tuturuana zuke. ");
INSERT INTO rug_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Mamu taveteni qolo sari na nepihina meke sari na vovoina. ");
INSERT INTO rug_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Kaqu tavetia gamu sa tuturuana zuke meke sari na tiṉitoṉa tanisa koari ka toloṉavulu lima kilo qolo viana. ");
INSERT INTO rug_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Mi tavete valeani, gua puta tugo sa kineha sapu va dogoroni gamu Rau pa toqere. ");
INSERT INTO rug_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Ego, kaqu tavete poni nau ri na tinoni si keke Ipi Hopena. Ka manege puta kukuru poko lineni arilaedi, sapu ta tigisi vulu bulu, pepolo, meke ziṉara si kaqu tavete nia rini sa ipi, mamu tigisi ni mateana serubimi sari na poko. ");
INSERT INTO rug_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Sari na gineledi ri na hopeke kukuru poko si ka manege rua mita geledi, meke karua mita labedi. ");
INSERT INTO rug_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Piti varihodaeni sari ka lima poko, meke gua tugo sari ka lima pule. ");
INSERT INTO rug_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Mamu piti va sotoni kukuru poko bulu bobolokuhae sapu koai lopa pa huhukiridi sari na poko goba, pude boka sopele la nia sa labete sisigotoana. ");
INSERT INTO rug_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Mamu piti va sotoi sari ka lima ṉavulu puta poko bulu bobolokuhae sapu koai lopa koari hopeke karua poko goba. ");
INSERT INTO rug_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Beto mamu taveti ka lima ṉavulu puta qaqahere pude guana lozo, meke doṉo guana keke mo sari karua goba. ");
INSERT INTO rug_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Beto mamu vagi ka manege eke kukuru poko kalu qoti, mamu tavetia keke ipi poko. ");
INSERT INTO rug_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Sari padadi ri doduru si ka manege ṉeta mita geledi meke karua mita labedi. ");
INSERT INTO rug_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Mamu piti varihodaeni sari ka lima, meke gua tugo sari ka onomo pule; mamu tomo rua ia, sapu vina onomo kukuruna panaulu, pude nobia kenuna sa Ipi Hopena. ");
INSERT INTO rug_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Beto mamu va soto i pule sari ka lima ṉavulu puta kukuru poko bulu bobolokuhae sapu koai lopa, pa hukihukiridi sari karua poko hire. ");
INSERT INTO rug_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Beto mamu taveti pule ka lima ṉavulu puta qaqahere boronizi, mamu va sopele lani koari na kukuru poko bulu bobolokuhae sapu koai lopa, pude ta varihodae sari karua kukurudi, meke doṉo guana keke nobinobiana mo. ");
INSERT INTO rug_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Totosona va turua gamu sa Ipi Hopena si va sigoto gorea sa kukuruna sa poko tomo rua meke nobia mudina sa Ipi Hopena. ");
INSERT INTO rug_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Kaiqa lima ṉavulu sentimita pule saripu sigoto gore pa hopeke vari kalina hola nia sa poko lineni arilaena, si pude va paeria sa ipi. ");
INSERT INTO rug_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Mamu taveti pule karua nobinobiana tanisa Ipi Hopena. Keke si na kapu sipi kokoreo, sapu tava ziṉarana, meke keke pule si na kapu rumu, pude tana sada. ");
INSERT INTO rug_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Mamu va turu varibarani kaiqa huda barabara akesia pude tanisa Ipi Hopena. ");
INSERT INTO rug_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Kaqu ka made mita geledi meke onomo ṉavulu onomo sentimita labedi. ");
INSERT INTO rug_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Hopeke karua barabara hire si kaqu turu koasa vovoina siliva. ");
INSERT INTO rug_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Mamu taveti ka hiokona puta hopeke karua huda barabara tana kali mataona. ");
INSERT INTO rug_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Meke ka made ṉavulu puta vovoina siliva vasina tava turu sari na barabara; hopeke karua vovoina pa keke huda barabara, pude tuqe va nabui sari karua. ");
INSERT INTO rug_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Mamu taveti pule ka hiokona puta hopeke karua huda barabara pude tana kali gede sa Ipi Hopena, ");
INSERT INTO rug_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","meke ka made ṉavulu vovoina siliva, hopeke karua vovoina pa hubina keke barabara huda. ");
INSERT INTO rug_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Meke pa mudina sa ipi pa kali lodu rimata, si mamu taveti ka onomo hopeke karua huda barabara; ");
INSERT INTO rug_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","mamu taveti pule karua hopeke barabara huda, koari na iio pa mumudi. ");
INSERT INTO rug_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Sari karua barabara huda koari hopeke iiona sa Ipi Hopena, si kaqu ta varihodae varigara meke ta tuqe varigarae koa ke riṉi boronizi, panapeka meke kamo panaulu. ");
INSERT INTO rug_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Gua asa, ke kaqu ka vesu sari doduru hopeke karua barabara huda pa mudina sa Ipi Hopena, meke kaqu ka manege onomo sari doduru voivoina siliva, karua vovoina pa kaurudi ri hopeke karua barabara huda. ");
INSERT INTO rug_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Ego, mamu taveti sari na huda akesia, pude tana gaso pilipilivarata, pude va ṉiṉirai sari na huda tuturu koari na barabara tana Ipi Hopena. Ka lima gaso si pude tuqe varigarani sari na barabara pa keke kalina. ");
INSERT INTO rug_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","Meke ka lima pule si pude tuqe varigarani sari na barabara pa keke kalina. Meke ka lima pule pilipilivarata, pude tuqe varigarani sari na barabara pa mudina sa Ipi Hopena. ");
INSERT INTO rug_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Sa huda gaso pa kokorapadi rina barabara, si kaqu kamo la gua koari karua vina betobeto barabara. ");
INSERT INTO rug_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Vekoni riṉi qolo sari na barabara huda, mamu va lopoto la i sari na gaso koari na riṉi, mamu pokoni qolo sari na barabara, meke sari na huda gaso. ");
INSERT INTO rug_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Mamu podalae tavetia meke kuri va hokotia sa Ipi Hopena koasa kineha, sapu va dogoro nigo Rau pa batu toqere Saenai. ");
INSERT INTO rug_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Mamu tavete nia poko lineni arilaena si keke goba poko, mamu piti nia lozi bulu, pepolo meke ziṉara. Beto mamu piti la nia kineha mateana serubimi si asa. ");
INSERT INTO rug_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Beto mamu va sigotia sa poko goba koari na qaqahereana qolo saripu sotodi koari ka made dedegere huda akesia saripu turudi koari ka made vovoina meke ta pokoe qolo. ");
INSERT INTO rug_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Va sigotia sa poko goba pa kaurudi ri na qaqahereana qolo; mamu vekoa sa bokese tanisa vinariva egoi, sapu koa ia ri karua patu labelabe pa mudina sa poko goba pa lose hopena pa hopena. Sa poko goba hie si kaqu varipaqaha nia sa lose hopena koasa hopena pa hopena. ");
INSERT INTO rug_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Mamu tukua sa Bokese Vinariva Egoi koasa tukutukuna, vasina pu koa ia tinaleosae na vinulasadi sari na sinea. ");
INSERT INTO rug_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Mamu vekoa sa tevolo pa sadana sa poko goba pa kali gede koasa Ipi Hopena, meke sa tuturuana zuke pa kali matao. ");
INSERT INTO rug_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Ego, koasa nuqunuquruana tanisa Ipi Hopena, si kaqu va sigoto nia poko goba ta tavetena pa poko lineni arilaena, sapu ta pitie lozi bulu, pepolo, meke ziṉara; meke kaqu piti nia vinasari tugo gamu si asa. ");
INSERT INTO rug_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Meke kaqu taveti gamu sari ka lima dedegere huda akesia sapu ta pokoe qolo, pude tanisa poko goba asa, mamu va sotoi pa qaqahere si arini; mamu taveti tugo ka lima vovoina boronizi, pude tadi na dedegere arini. ");
INSERT INTO rug_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Mamu tavete nia huda akesia si keke hope vina vukivukihi uququana. Kaqu kekeṉoṉo puta sari ginelena meke linabena. Kaqu karua gogoto hiokona sentimita gelena meke labena, meke keke gogoto toloṉavulu sentimita ululuna. ");
INSERT INTO rug_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Mamu taveti ka made kikiho koari ka made iiona sa hope. Sari na kikiho meke sa hope si kaqu ta tavetae keke tini meke pokoni boronizi. ");
INSERT INTO rug_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Mamu taveteni boronizi sari doduru tiṉitoṉa pu tavetavete ni pa tinavete vina vukivukihi, sapu sari na raro boronizi pude oki pani sari na eba, sari na besini boronizi pude tana sisiruana ehara, sari na poka ililiriana masa, meke sari na raro boronizi pude tana nika. ");
INSERT INTO rug_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Mamu tavetia keke hatara boronizi lopalopana, mamu va soto nia ka made riṉi boronizi, koari hopeke iiona sa hatara. ");
INSERT INTO rug_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Mamu veko la nia sa tiṉitoṉa lopalopa pa korapana sa hope uququana, pude koa pa kokorapana sa hope. ");
INSERT INTO rug_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Mamu taveti sari na palepalekeana huda akesia, mamu pokoni boronizi. ");
INSERT INTO rug_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Meke kaqu tava lopoto koari na riṉi sari na palepalekeana, pude koa varikali koari karu kalina sa hope, totoso ta paleke si asa. ");
INSERT INTO rug_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Mamu tavete nia labete labedi sa hope, mamu va kokoba vekoa sa korapana; gua tugo sa kineha sapu ele va dogoro nigo Rau pa toqere. ");
INSERT INTO rug_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Mamu tavete nia gobagoba poko lineni arilaena sa vari likohaena sa Qua Ipi Hopena. Sa kali mataona si kaqu made ṉavulu made mita gelena. ");
INSERT INTO rug_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Meke ka hiokona puta sari na barabara boronizi, saripu tava turu meke sari na hubidi si rokomo koari ka hiokona puta vovoina boronizi, meke sari na qaqaheredi pa hopeke barabara meke sa gaso vasina tava sigoto sa goba si ta tavetae siliva. ");
INSERT INTO rug_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Kote tavete gunia tugo sa gobagoba poko pa kali gede. ");
INSERT INTO rug_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Pa kali lodu rimata si kaqu veko nia gobagoba poko, ka hiokona rua mita labena, meke ka manege puta sari na barabara, saripu tava turu meke sari na hubidi si rokomo koari ka hiokona puta vovoina boronizi. ");
INSERT INTO rug_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Sa gobagoba poko koasa nuqunuquruana pa kali gasa rimata, si kaqu ka hiokona rua mita labena. ");
INSERT INTO rug_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","15","Sa gobagoba poko koari hopeke kalina sa nuqunuquruana, si kaqu onomo mita meke onomo ṉavulu sentimita; meke kaqu ka ṉeta sari barabara boronizi meke hopeke dia vovoina boronizi. ");
INSERT INTO rug_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Ka sia mita sa gobagoba poko koasa nuqunuquruana, sapu na vina sari si ta pitie lozi bulu, pepolo, meke ziṉara, meke ta tavetae koasa poko lineni arilaena. Meke kaqu tava sigoto va nabu si arini koari ka made barabara boronizi pu tava turudi koari na hopeke vovoina boronizi. ");
INSERT INTO rug_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Sari doduru barabara pa vari likohaena sa gobagoba poko, si kaqu ta vari hodae koari na gaso siliva, meke sari na qaqahere si kaqu ta tavetae siliva, meke sari na hubidi ri na barabara si tava turu koari na hopeke vovoina boronizi. ");
INSERT INTO rug_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Sa korapana si kaqu made ṉavulu made mita gelena meke hiokona mita labena, meke karua mita kukuruna ululuna; sa poko goba si kaqu ta tavetae na poko lineni arilaena, meke sari na hubi barabara si kaqu tava turu koari na vovoina boronizi. ");
INSERT INTO rug_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Sari doduru likakalae saripu kaqu tavetaveteni rini koasa ipi, meke sari doduru tupili pude tuqe va ṉiṉira ia sa ipi poko, si kaqu ta tavetae na boronizi. ");
INSERT INTO rug_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Mamu tozini sari na tie Izireli, pude paleke ponigo sa oela olive, sapu via hola, pude tanisa zuke, pude va katui doduru veluvelu. ");
INSERT INTO rug_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Eroni meke sari na tuna koreo, si kaqu kopu nia sa vina katuna sa zuke sapu koa pa sadana sa poko goba sapu pa kenuna sa Bokese Vinariva Egoi. Sa tinavete kopuna si podalae veluvelu meke kamoa munumunu. Sa tinarae hie si kaqu ta kopue koari na tie Izireli meke sari na dia sinage na sage, ninae rane ka rane. ");
INSERT INTO rug_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Mu turaṉa vata kale mae nia se Eroni, meke sari na tuna koreo koa goi: Ari Nadabi, Abihu, Eleaza, meke se Itamara, pude madi nabulu Nau rini, pude na hiama. ");
INSERT INTO rug_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Mamu tavete ponia poko madidi goi sa tasimu, sapu se Eroni, pude doṉo leana na tava lavata koari na tie. ");
INSERT INTO rug_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Mamu zamai sari doduru tie, saripu ele poni binokaboka tana piti poko Rau. Mu tozini pude piti sari na poko te Eroni pude va madia pa tinavete hiama, sapu nabulu nia sa Qua tinavete. ");
INSERT INTO rug_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Ego, hire sari na poko saripu kaqu piti rini: keke poko raqaraqa, keke poko tana hiama, keke poko gele tana hiama, keke poko keoro doduru, keke toropae batu tana hiama, meke keke poko dokoho. Kaqu piti gamu sari na poko madidi hire, pude tanisa tasimia sapu se Eroni, meke sari na tuna koreo, pude di nabulu Nau rini, guari na hiama. ");
INSERT INTO rug_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Kaqu pitipitini ri na tie sari na lozi qolo, bulu, pepolo, ziṉara, koasa lineni arilaena. ");
INSERT INTO rug_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Sa poko tanisa hiama, si kaqu ta pitie lozi bulu, pepolo, ziṉara, na qolo, meke kaqu ta pitie vinasari si asa. ");
INSERT INTO rug_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Karua sari na soqosoqoana pa avarana si kaqu ta vari sotoi sari na hukihukiridi. ");
INSERT INTO rug_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Keke poko dokoho arilaena sapu kekeṉoṉo gua tugo sari na tinavetena, si kaqu tava soto la koasa poko tana hiama hie, pude dikuru va nabua sa kenuna meke mudina sa poko koasa tinina sa hiama. ");
INSERT INTO rug_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Mamu vagi karua patu arilaedi sapu ta pozae onikisi, mamu kuberi pa korapana sari na pozadi ri ka manege rua tuna koreo e Zekopi. ");
INSERT INTO rug_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Meke sari na pozadi si kaqu luli sari na vinarilulina sa pinodopodo; ari ka onomo kenudi pa keke patu meke ari ka onomo mudidi koa keke patu. ");
INSERT INTO rug_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Mamu va kubereni koari na tie bokabokadi, sari na pozadi ri na tuna koreo Zekopi, koari karua patu gua tugo hoke tavetia ari na tie bokabokadi koari na patu arilaedi; mamu vekoni qolo vari likohaedi sari na patu arini. ");
INSERT INTO rug_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Mamu vekoi pa avarana, koari karua sosotoanana sa poko hiama pude na vina balabaladi ri ka manege rua butubutu Izireli. Meke kaqu paleki Eroni pa avarana sari na pozadi rini, meke lopu kaqu ta muliṉae koa Arau Zihova sari na Qua tinoni, gua. ");
INSERT INTO rug_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Taveti karua sosotoana qolo, pude tuqei sari na patu. ");
INSERT INTO rug_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Meke karua seni qolo hinokara, sapu nokinokie guana aroso, mamu vari sotoini sari karua seni, koari karua sosotoana qolo, sapu tuqedi rina patu. ");
INSERT INTO rug_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Mamu tavetia keke poko raqaraqa tanisa hiama, pude tana vinulasa te Tamasa. Kaqu kekeṉoṉo gua tugo sa pinitina sa vinasari koasa poko lineni arilaena tanisa poko hiama sapu ta piti pa lozi qolo, bulu, pepolo, meke ziṉara. Kaqu tava sigoto pa raqaraqana sa hiama si asa. ");
INSERT INTO rug_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Kaqu kekeṉoṉo mo padadi meke tomo rua, keke pidoko gelena, meke keke pidoko tugo labena. ");
INSERT INTO rug_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Mamu vekoni ka made tokele patu arileadi sa poko raqaraqa. Koasa tokele kekenu si kaqu vekoa goi si keke patu sapu ziṉara guana qelasi sapu ta pozae rubi, keke patu sapu meava guana hakua saganana sapu ta pozae topazi, meke keke patu sapu guana pepeso ziṉara sapu ta pozae qaraneti; ");
INSERT INTO rug_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","meke koasa tokele vina rua si na patu sapu buma guana elo huda sapu ta pozae emerolo, keke patu sapu buma guana lamana peava sapu ta pozae sapira, meke keke patu sapu ta pozae daemani. ");
INSERT INTO rug_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Koasa tokele vina ṉeta si na patu buma gua sa kopi pa sagauru pa rane sapu gona rimata sapu ta pozae turakoisi, meke keke patu pepolo sapu ta pozae aqate, meke keke patu pepolo guana vua leqata sapu ta pozae ametiseti; ");
INSERT INTO rug_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","meke koasa tokele vina made, si keke patu buma guana elo kinu sapu ta pozae beriolo, keke patu ziṉara sapu ta pozae karaneliani, meke keke patu ṉedala guana qelasi viana sapu ta pozae Zasipa. Mamu vekoni qolo vari likohaedi sari na patu arini. ");
INSERT INTO rug_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Meke koari hopeke patu hire, si kaqu ta kubere keke pozadi koari hopeke tuna koreo e Zekopi, pude keke pozapoza butubutu Izireli pa hopeke patu. ");
INSERT INTO rug_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Meke koasa poko raqaraqa, si mamu taveti karua seni qolo hinokara, sapu nokinokie guana aroso pude sigotia. ");
INSERT INTO rug_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Beto mamu tavete pulei karua riṉi qolo, mamu vari sotoni pa hukihukiri avara panaulu koasa poko tana raqaraqa. ");
INSERT INTO rug_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Beto mamu vari soto va ṉirani sari karua seni qolo koari karua riṉi; ");
INSERT INTO rug_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","beto mamu vari sotoni sari karua seni qolo hire koari karua sosotoanana sa poko hiama vasina soto sari karua patu onikisi pa avarana. ");
INSERT INTO rug_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Beto mamu taveti pule karua riṉi qolo, pude soto la koasa hukihukirina gore sa poko raqaraqa. ");
INSERT INTO rug_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Meke taveti pule karua riṉi qolo, mamu va soto la i pa kenuna sa poko hiama tata koasa poko dokoho. ");
INSERT INTO rug_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Sari na riṉi tanisa poko raqaraqa si kaqu ta pusie va nabu koari na riṉi tata koasa poko dokoho pa kenuna sa poko tana hiama koari karua aroso bulu, pude kapae va leana koasa raqaraqa meke lopu kepuhu taloa koasa poko hiama. ");
INSERT INTO rug_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Meke pa totoso nuquru la koasa lose hopena se Eroni, si kaqu va sagea sa sa poko raqaraqa, vasina pu ta kubere sari na pozadi ri na butubutu Izireli, pude doduru totoso si kaqu balabala i Arau, Zihova sari na Qua butubutu Izireli. ");
INSERT INTO rug_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Beto mamu vekoi pa korapa poko raqaraqa sari karu tiṉitoṉa hire, sa Urimi meke Tumimi; pude boka paleke maeni e Eroni totoso nuquru mae pa kenuqu Rau. Koari na totoso gua arini si kaqu va sagea Eroni doduru totoso sa poko raqaraqa hie, pude boka vizata valeana si asa pa hiniva te Tamasa, koari na tie Izireli. ");
INSERT INTO rug_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Sa poko gele sapu koa kaurae koasa poko kukuru, si kaqu ta tavetae zoṉazoṉa poko bulu. ");
INSERT INTO rug_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Kaqu koa ia keke lopa, pude tanisa batu si asa, meke sa lopa hie, si piti vari likohae nia, pude va ṉiṉira ia meke lopu kaqu boka rikata si asa. ");
INSERT INTO rug_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","34","Koasa doduru vari likohaena sa hubina sa poko, si mamu veko nia guana vua huda pomeqaraneti, sapu bulu, pepolo, meke ziṉara meke hopeke belo qolo pa varikorapadi. ");
INSERT INTO rug_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Kaqu va sagea Eroni sa poko hie pa nana totoso tavetavete pa tinavete hiama. Pana nuquru mae si asa pa kenuqu Rau koasa lose hopena babe taluarae si asa, si kaqu ta avoso sari na mamalaiṉidi rina belo, pude lopu kaqu tava mate si asa. ");
INSERT INTO rug_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Beto mamu tavetia si keke tiṉitoṉa qolo sapu doṉo lea, mamu kuberia pa korapana sa zinama hie, ‘Ele tava madi koe Zihova,’ gua. ");
INSERT INTO rug_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Mamu vagia keke aroso bulu, mamu pusi nia pa kenuna sa toropae batu tanisa hiama. ");
INSERT INTO rug_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Meke kaqu va sagea Eroni si asa pa raena, pude kaqu ta qetue koa Arau Zihova, sari doduru vinariponi na vina vukivukihi, saripu va madi i ri na tie Izireli koa Rau. Be va sea i ri na tie Izireli sari kaiqa toṉa koari na dia vinariponi, ba kaqu ta zutu se Eroni koari na dia tinavete sea. ");
INSERT INTO rug_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Mamu piti nia poko lineni arilaena sa poko gele te Eroni, meke sa toropae batu. Mamu piti nia vinasari tugo sa poko dokoho. ");
INSERT INTO rug_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Mamu taveti sari na poko keoro doduru, na poko dokoho, meke na toropae hiama tugo tadi na tuna koreo e Eroni pude boka doṉo lea na tava lavata si arini. ");
INSERT INTO rug_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Mamu va sageni koasa tasimia se Eroni meke koari na tuna koreo sari na poko arini. Beto mamu tiqe zoroponi oela olive pa batudi pude va madi, pude boka nabulu Nau rini pa tinavete hiama. ");
INSERT INTO rug_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Mamu taveti sari na dia poko korapae, kokoi pa siqe meke kamo la pa pudapuda. ");
INSERT INTO rug_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Eroni meke sari na tuna koreo si kaqu va sagei sari na poko arini, totoso nuquru mae pa korapana sa Ipi Hopena pa kenuqu Rau, babe tata mae koasa hope, pude nabulu Nau pa tinavete hiama pa lose hopena pude lopu ta zutu meke mate. Hie si keke tinarae tadi na hiama koe Eroni, meke koari na tudia ri na tuna, sapu kaqu koa hola ninae rane ka rane. ");
INSERT INTO rug_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Guahe si kaqu tavetia gamu koe Eroni, meke sari na tuna koreo pana va madi gamu, pude nabulu Nau: kaqu hena ia gamu si keke bulumakao kokoreo vaqurana, meke karua sipi kokoreo loke ari kisakisadi. ");
INSERT INTO rug_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Mamu tavetavete nia sa palava huiti sapu viana, ba lopu heni nia isiti; mamu kinai kaiqa bereti, na keki saripu ta henie oela olive, meke kaiqa bisikiti manivisidi, mamu ṉuzapa ni oela. ");
INSERT INTO rug_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Beto mamu voi i pa keke huneke, mamu paleke maeni koa Rau, mamu va vukivukihi nia gamu sa bulumakao kokoreo meke sari karua sipi kokoreo. ");
INSERT INTO rug_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Beto, mamu turaṉa mae nia se Eroni, meke sari na tuna koreo pa sasadana sa Ipi Hopena pa kenuqu Rau; mamu huveni kolo. ");
INSERT INTO rug_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Beto mamu vagi sari na poko hiama, mamu va sage nia koe Eroni, sa keoro doduru, sa poko gele, sa poko hiama, poko raqaraqa, meke sa poko dokoho. ");
INSERT INTO rug_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Mamu va sage nia toropae batu tanisa hiama si asa; mamu pusi nia koasa sa vina gilagila madina sapu ta kubere guahe pa korapana: ‘Ele tava madi koe Zihova,’ gua. ");
INSERT INTO rug_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Beto mamu vagia sa oela tana vina madi, mamu zoropo nia pa batuna, mamu va madia si asa. ");
INSERT INTO rug_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Mamu turaṉa maeni sari na tuna koreo, mamu va sageni poko keoro doduru. ");
INSERT INTO rug_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Mamu va hakeni toropae batudi, beto mamu va sage ni sari na poko dokoho koari kasa. Gua asa meke kaqu va madia gamu se Eroni, meke sari na tuna koreo. Meke kaqu nabulu Nau ri na tudia rina tudia pa tinavete hiama si Rau, ninae rane ka rane. ");
INSERT INTO rug_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Mamu turaṉa la nia pa kenuna sa Ipi Hopena koe Zihova sa bulumakao kokoreo, mamu zama ia se Eroni meke sari na tuna koreo, pude va opoi limadia pa batuna. ");
INSERT INTO rug_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Mamu va matea sa bulumakao kokoreo pa kenuna e Zihova, tata koasa sasadana sa Ipi Hopena. ");
INSERT INTO rug_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Mamu paleke lani koasa hope sari kaiqa eharana sa bulumakao kokoreo; mamu va boboso ni ehara sari na kakarutumu, mamu honi lani koari ka made kikihona koari na iiona sa hope. Mamu zoropo la nia sa ehara koa holana pa hubina sa hope. ");
INSERT INTO rug_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Keke pule, mamu vagi sari doduru deana pa korapana, sa kukuruna sa bero leanana, meke vagi turaṉaeni tugo sari karua leleqata meke sa deana koarini; mamu va uqu betoi koasa hope, pude na mia vina vukivukihi mae koa Rau. ");
INSERT INTO rug_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Ba sului sari na masana sa bulumakao kokoreo, meke sari na kapuna, meke sari na laguna pa sadana sa vasileana. Sa vina vukivukihi asa, si pude vulasa pani sari na sinea tadi na hiama. ");
INSERT INTO rug_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Beto mamu vagia keke sipi kokoreo, mamu tozi nia se Eroni, meke sari na tuna koreo, pude va opoi limadia pa batuna. ");
INSERT INTO rug_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Mamu va matea, mamu vagia sa eharana, mamu siburu beto lani koari ka made kalikalina sa hope. ");
INSERT INTO rug_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Mamu magumagu va hitekia sa sipi kokoreo, mamu ṉuzapa va via ia sa korapana, meke sari na nenena, mamu veko turaṉae ni koasa batuna, meke na masana. ");
INSERT INTO rug_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Mamu va uququa sa doduruna sa sipi pa hope. Na vina vukivukihi va uququ koa Arau Zihova. Meke sa hibi lea tanisa si variva qetu koa Rau. ");
INSERT INTO rug_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Mamu vagi pulea sa sipi kokoreo vina rua, pude tana vina madi. Mamu tozi nia se Eroni meke sari na tuna koreo, pude va opoi limadi pa batuna. ");
INSERT INTO rug_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Mamu va matea, mamu vagi kaiqa eharana, mamu vekoi pa kali boboa taliṉa mataodi, meke koari na gugulavata lima mataodi, meke koari na gugulavata nene mataodi, ari Eroni meke sari na tuna koreo. Meke sari na ehara koa holadi si mamu siburu lani koari ka made kalina sa hope. ");
INSERT INTO rug_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Beto mamu vagi kaiqa ehara koasa hope, meke kaiqa oela tana va madi hiama, mamu siburu la nia koe Eroni meke sari nana poko, meke koari na tuna koreo meke sari na dia poko, pude vata dogoro nia sapu Eroni, meke sari na tuna koreo, meke sari dia poko, si tava madi koasa ninabuluqu Rau. ");
INSERT INTO rug_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Beto mamu magu pani sari na deanana sa sipi kokoreo vina rua hie, sa pikutuna sapu moatia deana, doduru deana pa korapana, sa kukuruna sa bero leanana, meke vagi turaṉaeni tugo sari karua leleqata meke sa deana koarini meke sa pudapuda kali mataona. ");
INSERT INTO rug_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Beto asa, mamu hena vagia keke bereti sapu lopu ta henie isiti, keke keki sapu ta henie oela, meke keke bisikiti manivisina koasa huneke pa kenuna e Zihova. ");
INSERT INTO rug_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Mamu va adeni pa limadia ri Eroni, meke ri na tuna koreo sari doduru ginani arini, pude ovulu sageni pude va madi koa Rau, guana vinariponi arilaedi. ");
INSERT INTO rug_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Beto mamu vagi koa rini, mamu veko lani pa batuna sa vina vukivukihi va uququ koasa hope, meke sa hibi lea tanisa si variva qetu koa Rau. ");
INSERT INTO rug_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Beto mamu hena ia sa masa pa raqaraqana sa sipi kokoreo hie, mamu va madia koe Zihova guana vinariponi arilaena. Sa kukuruna asa si kaqu tamugoi. ");
INSERT INTO rug_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Sipu tava madi se Eroni meke sari na tuna, sa masa raqaraqana meke sa pudapudana sa sipi kokoreo tanisa vina madidi ri kasa, si kaqu tavamadi koa Rau guana vinariponi koa Rau, meke ta veko vata kale pude tadi na hiama pude ta hena. ");
INSERT INTO rug_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Sa siraṉa asa si kaqu ta luli tugo pa doduru vina vukivukihi binaere tadi na tie Izireli vugo na repere. Keke tinarae si asa pude ta luli doduru totoso sapu va vukivukihi ni rini sari na dia vina vukivukihi hinenahena binaere. Kaqu henahena pa binaere koe Zihova meke sa susuna meke sa pudapuda si kaqu tavamadi koe Zihova pude Tanisa, ba sari na hiama si kaqu hena ia. ");
INSERT INTO rug_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Sari na poko hiama te Eroni si kaqu ta vala koari na tuna koreo pa mudina sa nana minate, pude kaqu va sagei, pana tava madi si arini. ");
INSERT INTO rug_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Sa tuna koreo sapu hobena se Eroni, pude na hiama kenukenue, meke nuquru la pa korapa ipi pa kenuqu Rau pa lose hopena si kaqu pokoni sari na poko arini koari ka zuapa rane. ");
INSERT INTO rug_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Kaqu vagi gamu sa masana sa sipi kokoreo tanisa vina madidi rina hiama; mamu raro va qototia pa vasina madina. ");
INSERT INTO rug_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Beto asa, meke kaqu hena ia ri Eroni meke sari na tuna koreo, sa masana sa sipi kokoreo, pa sasadana sa Ipi Hopena; meke kaqu hena turaṉae nia bereti madina sapu koa holana pa huneke rini si asa. ");
INSERT INTO rug_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Kaqu henai rini, sari na ginani arini saripu tana vinavia, tana vinariva taleosae koasa dia vina madi. Sari na hiama mo tava madidi arini si boka hena ia sari na ginani arini, si na hopedi si arini. ");
INSERT INTO rug_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Ego, be kaiqa masa babe kaiqa bereti si lopu ta hena koari na hiama meke kamoa munumunu, si lopu kaqu henai rini si arini, ba kaqu ta sulu palae, si na hopedi si arini. ");
INSERT INTO rug_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Mamu taveti sari doduru tiṉitoṉa saripu tozini gamu Rau hire koe Eroni meke sari na tuna koreo, kaqu ka zuapa rane seunae gua sa dia totoso tinava madi. ");
INSERT INTO rug_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Koari hopeke rane, si kaqu vala nia gamu si keke bulumakao kokoreo, pude na vina vukivukihi vinulasa sinea, meke pude va via ia sa hope. Beto mamu zoropo nia oela, pude va madia si asa koa Rau. ");
INSERT INTO rug_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Ka zuapa rane si kaqu tavetia gamu sapu gua asa. Beto meke kaqu ta va madi sisigiti si asa. Meke be tiqua ke tie babe keketoṉa si asa, si kaqu tava madi tugo si asa. ");
INSERT INTO rug_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Koari hopeke rane podalae kamahire, si mamu va vukivukihini koasa hope si karua tuna sipi sapu keke vuahenidi. ");
INSERT INTO rug_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Mamu va vukivukihi nia si keke pana munumunu, meke keke pule pana veluvelu. ");
INSERT INTO rug_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Kaqu vala turaṉa nia gamu koasa tuna sipi kekenu, si keke kilo palava huiti, sapu ta muzara va leanana; mamu heni nia sa palava koa keke lita oela olive sapu via valeanana, beto mamu valani pa hope pude na vina vukivukihi va uququ. Beto mamu zoropo nia keke lita vaeni, pude na vinariponi tana napo. ");
INSERT INTO rug_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Mamu va vukivukihi nia pule sa tuna sipi vina rua pana veluvelu; kekeṉoṉo gua tugo sa padana sa palava, oela olive meke sa vaeni, sapu ta vala pana munumunu. Asa sa mia vinariponi ginani koa Rau Zihova, meke sa hibi lea tanisa si variva qetu koa Rau. ");
INSERT INTO rug_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Koari na sinage mae hiroi, sa vina uququ hie, si kaqu ta tavete doduru totoso koasa hope tata koasa sasadana sa Ipi Hopena pa kenuna e Zihova, meke vasina si kaqu tutuvu gamu na zama gamu Rau si gamu. ");
INSERT INTO rug_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Meke vasina si kaqu tutuvi Rau sari na tie Izireli, meke kaqu tava madi sa vasina asa, pa ṉinedalana sa Qua sinomana. ");
INSERT INTO rug_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Meke kaqu va madia Rau sa Ipi Hopena, meke sa hope, meke kaqu va madia Rau se Eroni meke sari na tuna koreo, pude di nabulu Nau pa tinavete hiama. ");
INSERT INTO rug_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Meke kaqu koa koari na tie Izireli si Rau, meke kaqu na dia Tamasa. ");
INSERT INTO rug_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Meke kaqu gilania rini sapu Arau si e Zihova, sa dia Tamasa, sapu turaṉa vurani si arini pa popoa Izipi, pude boka koa koa rini si Rau. Arau si e Zihova sa dia Tamasa. ");
INSERT INTO rug_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Mamu tavete nia huda akesia si keke hope tana vina uququ humaṉa lea. ");
INSERT INTO rug_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Kaqu kekeṉoṉo puta gelena, meke labena, sapu made ṉavulu lima sentimita labena meke gelena, meke sia ṉavulu sentimita ululuna. Meke sari na kikihona pa hopeke iiona si kaqu keke mo koasa tinina. ");
INSERT INTO rug_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Beto mamu poko nia qolo sa batuna, sari ka made kalina beto, meke sari ka made kikihona sa hope. Beto meke sa hukihukirina si kaqu ta pokoe qolo. ");
INSERT INTO rug_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Mamu taveti karua palepalekeana riṉi qolo, mamu va sotoi pa kaurudi ri karua kalina sapu ta pokoe qolo, pude tuqei sari na huda palepalekeana. ");
INSERT INTO rug_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Mamu taveteni huda akesia sari na palepalekeana hire, beto mamu pokoni qolo tugo. ");
INSERT INTO rug_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Beto mamu vekoa sa hope hie pa sadana sa poko goba, sapu sigoto pa kenuna sa Bokese Vinariva Egoi. Vasina si kaqu tutuvu gamu Rau si gamu. ");
INSERT INTO rug_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Doduru munumunu pana mae puripuri Eroni sari na zuke, si kaqu va uqua sa sa oto huda humaṉa lea koasa hope hie. ");
INSERT INTO rug_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Kaqu va uququa tugo sa si asa pana mae va katui sa sari na zuke pana veluvelu pude lopu kaqu makudo sa vina uququ doduru rane na boṉi ninae rane ka rane. ");
INSERT INTO rug_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Lopu kaqu tava uqu koasa hope hie, si keke votiki vina uququ humaṉa lea. Lopu na vina uququ kurukuru, babe na huiti, meke lopu zoropo nia keke napo vaeni koasa. ");
INSERT INTO rug_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Keke totoso pa vuaheni, si kaqu va madia Eroni sa hope vina vukivukihiana. Kaqu vekoni ehara sa ka made kikiho koari ka made iiona sa hope, pude va madia sa hope koe Zihova. Kaqu va madia sa koasa eharana sa bulumakao kokoreo sapu sa vinulasadi ri na mia sinea. Kaqu tavetia sa sapu gua asa keke totoso pa hopeke vuaheni podalae kamahire, meke sa hope hie si kaqu tavamadi sisigiti si asa koe Zihova.” ");
INSERT INTO rug_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Meke zama la koe Mosese se Zihova, ");
INSERT INTO rug_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Totoso naei gamu sari na tie Izireli, pa totoso asa, si kaqu here puleni sari doduru hopeke tie koari na dia tinoa koe Zihova, pude loke oza, si kaqu ta evaṉa koari na tie pana ta nae si arini. ");
INSERT INTO rug_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Kaqu tata onomo qaramu poata siliva mamatana gua sapu hoke pada nia pa keke sekeli mamatana pa tinavete koasa Ipi Hopena, si kaqu here nia sa tie pu ta nae. Meke kaqu poni mae nia koa Rau si asa. ");
INSERT INTO rug_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Doduru tie pu somana ta nae, saripu hiokona puta vuaheni meke sage la vuahenidi si kaqu tabaria sa poata asa. ");
INSERT INTO rug_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Sa tie tagotagona si lopu kaqu tabara va sage sisigiti meke sa tie habahuala si lopu kaqu tabara va gore sisigiti padana sapu tagoa rini, totoso tabaria rini sa hinerena sa dia tinoa. ");
INSERT INTO rug_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Kaqu vagi varigarani goi sari na poata arini koari na tinoni Izireli, pude na vina enena sa tinavete koasa Qua Ipi Hopena. Sa takisi asa, si na hineredi na dia tinoa, meke kaqu balabala i na kopuni Rau si arini.” ");
INSERT INTO rug_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Meke zama la koe Mosese se Zihova: ");
INSERT INTO rug_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Mu tavetia keke besini boronizi nomana meke gua tugo sa nana tuturuana, mamu la vekoa pa vari korapana sa Ipi Hopena meke sa hope va uququana; mamu va siṉi nia kolo. ");
INSERT INTO rug_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Vasina kote ṉuzapa lima na nene se Eroni, meke sari na tuna koreo. ");
INSERT INTO rug_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","21","Sipu lopu ele nuquru la si arini koasa ipi, babe ene tata la koasa hope pude va vukivukihi ni sari na kurukuru pa nika, si kaqu ṉuzapa paki lima na nene si arini pude lopu kaqu mate. Asa sa tinarae sapu kaqu kopu nia rini, meke sari na tudia ri na tuna ninae rane ka rane.” ");
INSERT INTO rug_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Meke zama la koe Mosese se Zihova, ");
INSERT INTO rug_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Mu vagi sari hopeke pukudi gua hire: Ka onomo kilo kolo oto huda sapu ta pozae moa, ṉeta kilo sinamoni humaṉa lea hola, ṉeta kilo keini humaṉa lea, ");
INSERT INTO rug_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","meke ka onomo kilo kasia sapu humaṉa lea hola. Ta pada sari doduru hire koasa mamata sapu hoke pada nia pa keke sekeli mamatana pa tinavete koasa Ipi Hopena, meke varigara la ka made lita oela olive pule. ");
INSERT INTO rug_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Mamu tavetia keke oela hopena tana vina madi, sapu ta varihenie guana seda humaṉa lea. ");
INSERT INTO rug_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Vagia mamu va madi nia sa Qua Ipi Hopena, meke sa Bokese Vinariva Egoi, ");
INSERT INTO rug_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","sa tevolo, sa tuturuana zuke meke sari doduru dia tiṉitoṉa tavetaveteana tanisa zuke, meke sa hope tana vina uququ humaṉa lea, ");
INSERT INTO rug_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","sa hope vina vukivukihi va uququana, meke sari na tiṉitoṉa tavetaveteana tanisa, meke sa besini boronizi nomana meke sa nana tuturuana. ");
INSERT INTO rug_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Mamu va madi guni arini sari na tiṉitoṉa hire, pude kaqu tava hope hola, meke nasa sapu tiqudi ri, si kaqu evaṉae hopedi si arini. ");
INSERT INTO rug_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Beto mamu zoropo nia oela se Eroni meke sari na tuna koreo, pude nabulu Nau pa tinavete hiama si arini. ");
INSERT INTO rug_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Mamu zama koari na tie Izireli guahe, ‘Hie sa oela hopena pude tavetavete nia koasa ninabuluqu Rau, doduru totoso koari na rane mae hiroi. ");
INSERT INTO rug_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Lopu kaqu zoropo nia pa tinidia ri na tie hokara pa vasileana, meke lopu kaqu tavete va kekeṉoṉo gunia gamu koasa si keke oela. Hopena si asa, meke kaqu tavetavete nia gamu pa siraṉa sapu gua hopena si asa. ");
INSERT INTO rug_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Ba be guana tavetia keke tie si keke nana oela sapu kekeṉoṉo gugua asa sapu sa oela hopena hie, ba be zoropo nia koa keke tie, sapu lopu keke hiama, si namu lopu kaqu koa hola koari na puku tie Izireli si asa,’ gua.” ");
INSERT INTO rug_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Meke zama la koe Mosese se Zihova, “Mu vagi sari na oto huda humaṉa lea hire: Oto huda moa, qalabanamu, meke parakinisenisi, meke sa onika, pude kaqu kekeṉoṉo sa padadi sapu ta henie pude tana va uququ. ");
INSERT INTO rug_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Mamu taveteni vina uququ, sapu ta varihenie guana tiṉitoṉa humaṉa lea, mamu heni nia soloti, pude viana meke hopena. ");
INSERT INTO rug_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Mamu muzara va umumu valeania si keke kukuruna, mamu paleke la nia koasa Ipi Hopena pa kenuna sa Bokese tanisa Vinariva Egoi vasina kaqu tutuvu gamu Rau si gamu. Hopena si asa, ke mamu va hope sisigitia si asa. ");
INSERT INTO rug_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Mi lopu tavetia gamu si keke vina uququ, sapu kekeṉoṉo gua asa tinavetena, pude mia mo telemia, ba mamu va hopea koe Zihova si asa. ");
INSERT INTO rug_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Be keke tie si tavetia sapu gua puta asa, pude tana vina uququ humaṉa lea, si kaqu paqaha koari na tie Izireli si asa.” ");
INSERT INTO rug_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Meke zama la koe Mosese se Zihova, ");
INSERT INTO rug_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Ele vizatia Rau se Bezaleli, sa tuna e Uri, sapu na tuna e Huri, koasa butubutu pa Ziuda. ");
INSERT INTO rug_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Meke ele va siṉi nia Rau sa Maqomaqoqu koa sa, meke ele poni nia Rau koasa sa ginilagilana, tinumatumae, na binokaboka, koari doduru votivotiki tinavete. ");
INSERT INTO rug_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Boka taveti sa sari doduru tiṉitoṉa tolavaedi na leleadi pa tinavete, pude tavetavete nia sa qolo, siliva, meke na boronizi. ");
INSERT INTO rug_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Boka taveti sa sari na patu arileadi meke boka vekoi sa pa korapa qolo. Boka peqopeqo na magumagu huda, meke doduru votivotiki tinavete si boka taveti sa. ");
INSERT INTO rug_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Ele vizatia tugo Rau se Oholiabi, sa tuna koreo e Ahisamaka, koasa butubutu te Dani, pude tavetavete somanae koasa. Ele ponini binokaboka nomadi tugo Rau sari doduru tie bokabokadi pa tinavete, pude boka taveti rini sari doduru tiṉitoṉa saripu garununi Rau koarini pude kaqu taveti sapu gua hire: ");
INSERT INTO rug_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","sa Ipi Hopena, vasina tutuvu gamu Rau si gamu, sa Bokese Vinariva Egoi meke sa tukutukuna, vasina pu koa ia tinaleosae na vinulasadi sari na sinea, meke sari doduru likakalae tanisa Ipi Hopena; ");
INSERT INTO rug_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","meke sa tevolo bereti meke sari na tiṉitoṉa tanisa; sa tuturuana zuke qolo, meke sari doduru nana likakalae; sa hope tana vina uququ humaṉa lea; ");
INSERT INTO rug_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","sa hope vukivukihi uququana, meke sari doduru nana likakalae; sa besini boronizi nomana meke sa nana tuturuana; ");
INSERT INTO rug_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","meke sari na poko hiama hopedi hola te Eroni, meke sari na tuna koreo, pude pokoni totoso somana tavetavete pa tinavete hiama si arini; ");
INSERT INTO rug_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","meke sa oela tana vina madi, meke sa oto huda humaṉa lea tana vina uququ koasa lose hopena. Kaqu taveti ri sari doduru hire gua puta tugo sapu ele garunu nigo Rau pude taveti.” ");
INSERT INTO rug_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Beto asa si garunia e Zihova se Mosese, ");
INSERT INTO rug_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","pude tozia koari na tinoni Izireli sa Nana zinama, sapu zama guahe: “Mi kopuni sari na rane Sabati. Kaqu na vina gilagila pa varikorapada, gamu meke Arau, ṉinoroi, meke doduru totoso sapu korapa mae, pude boka gilania gamu, sapu Arau si e Zihova sapu va madi gamu, pude na Qua tie soti si gamu. ");
INSERT INTO rug_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Kaqu kopu nia gamu sa rane Sabati asa, sina madina si asa. Meke asa, sapu lopu kopu nia, ba tavetavete nana koasa rane asa, si kaqu tava mate si asa. ");
INSERT INTO rug_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Ka onomo rane si kaqu tavetaveti gamu sari na mia tinavete, ba sa rane vina zuapa si na rane magogoso, sapu tava madi koe Zihova. Meke asa sapu tavetavete koasa rane sana sapu koari na tie Izireli, si kaqu tava mate si asa. ");
INSERT INTO rug_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Kaqu kopu nia ri na tie Izireli sa rane Sabati, guana keke vina gilagila tanisa vinariva egoi koe Zihova, meke koari na tie Izireli. ");
INSERT INTO rug_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Keke vina gilagila koa hola si asa pa varikorapada, gamu na tie Izireli meke Arau ninae rane, sina Arau Zihova ele tavetia sa maṉauru meke na pepeso koari ka onomo rane, meke koasa rane vina zuapa, si noso si Rau pa tinavete, meke magogoso.” ");
INSERT INTO rug_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Meke sipu beto zama koe Mosese se Zihova pa batu Toqere Saenai, si valani Sa koe Mosese sari karua patu labelabe, vasina pu kuberi sa Tamasa telena sari na tinarae. ");
INSERT INTO rug_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Meke sipu dogoria rina tie Izireli, sapu lopu gore pule mae pa toqere se Mosese, ba koa seunae nana vasina, si mae varigara, meke zama guahe koe Eroni si arini, “Lopu gilania gami sapu ta evaṉa koasa tie hie, sapu se Mosese, sapu turaṉa vurani gita pa popoa Izipi; ke hiva nia gami pude tavete poni gami keke tamasa, pude turaṉa gami,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Meke olaṉa la koa rini se Eroni, “Ego, mamu unusu va gorei sari na vikulu qolo saripu va sagei rina mia barikaleqe, na tumia koreo, meke ri na tumia vineki pa taliṉadia. Mamu paleke maeni koa rau si arini.” ");
INSERT INTO rug_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Ke unusu va gorei ri doduru tie sari na dia vikulu qolo pa taliṉadia, meke paleke lani rini koe Eroni. ");
INSERT INTO rug_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Meke vagi Eroni sari na dia vikulu qolo, saripu va sotoi rini pa taliṉadia, meke va koloi, meke zoropo la nia sa koa keke tiṉitoṉa tavetaveteana, meke tavetia sa si keke beku tuna bulumakao kokoreo qolo. Meke zama sarini, “Ke Izireli, hie sa nada tamasa sapu turaṉa vurani gita pa popoa Izipi,” gua. ");
INSERT INTO rug_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Beto hoi, si kuria Eroni si keke hope pa kenuna sa beku bulumakao qolo meke zama va ululae guahe: “Vugo si kaqu tavetia gita si keke inevaṉa pude va lavatia se Zihova,” gua. ");
INSERT INTO rug_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Meke vaṉunu munumunu hokara sari na tie, meke paleke maeni rini si kaiqa kurukuru, pude tana vina vukivukihi va uququ, meke na vina vukivukihi hinenahena binaere. Meke mumudi si habotu henahena na napo pa keke inevaṉa si arini, meke ta evaṉae naponapo va hola meke hoqa pa sinea koasa hahanana vinari riqihi si arini. ");
INSERT INTO rug_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Meke zama la koe Mosese se Zihova, “Mu tuturei gore pule; ura sari na mua tie saripu turaṉa vurani goi pa popoa Izipi, si ele tavete va sea, meke vahesi beku si arini. ");
INSERT INTO rug_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Ele luaria rini sa siraṉa sapu tozini Rau pude lulia; meke ele tavetia rini si keke beku bulumakao, sapu tavete nia qolo tava kolona rini, meke va vukivukihi la ia na vahesia rini. Meke zama nia rini, sapu asa sa dia tamasa, sapu turaṉa vurani si arini pa popoa Izipi, gua.” ");
INSERT INTO rug_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Meke zama se Zihova koe Mosese, “Na dogoria Rau sapu na tie tasunadi sari na tie hire,” gua. ");
INSERT INTO rug_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","“Ego, mamu lopu podekia pude hukatau. Ele bugoroni Rau, meke hiva va kilasa va matei Rau si arini. Beto asa si kaqu vata evaṉae nigo keke butubutu lavata Rau si goi.” ");
INSERT INTO rug_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Ba tepa ososo nia tugo e Mosese se Zihova, sa nana Tamasa, meke zama, “Ke Zihova, na vegua ke kaqu bugoro sisigitini tu Goi sari na Mua tie, saripu ele harupi Goi pa popoa Izipi koasa Mua ṉiniraṉira lavata? ");
INSERT INTO rug_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Kote sa gua si zama nia rina tie Izipi sapu Agoi turaṉa vurani vasina sari na Mua tie, pude va kilasa va mate betoi tu Goi si arini koari na toqere? Mu lopu bugoro si Goi, hobea sa Mua binalabala. Mamu lopu va tasunai sari na Mua tie? ");
INSERT INTO rug_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Mu balabala pulei sari na Mua nabulu, Ebarahami, Aisake, meke se Zekopi. Mamu balabala pulea sa Mua vina tatara soti sapu zama nia Goi koarini pa pozamu soti, sapu guahe: Kaqu va soku kekeṉoṉo guni gamu rina pinopino pa galegalearane Rau sari na tudia ri na tumia, meke kaqu vala i Rau koari doduru tudia rina tumia sari doduru pepeso, saripu ele va tatarani Rau, pude kaqu tamugamu ninae rane ka rane,” gua. ");
INSERT INTO rug_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Ke hobea e Zihova sa Nana binalabala, gua sapu zama kekenu nia Asa, meke lopu va matei Sa sari Nana tie Izireli. ");
INSERT INTO rug_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Meke gore pule pa toqere se Mosese, meke paleki nana sari na tinarae te Tamasa, saripu ta kubere pa varikalidi ri karua patu labelabe. ");
INSERT INTO rug_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","E Tamasa mo telena taveti sari na patu labelabe arini. Meke e Tamasa tugo telena kuberi sari na tinarae, koari na patu labelabe arini. ");
INSERT INTO rug_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Meke sipu avosi Zosua kukilidi sari na tinoni Izireli, si zama la koe Mosese si asa, “Guana mamalaiṉi varipera si avosia rau koari na tie Izireli.” ");
INSERT INTO rug_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Meke olaṉa se Mosese, “Lokari, lopu guana mamalaiṉi vinarane babe vina kilasa koari na kana, ba guana na mamalaiṉi kinera tu.” ");
INSERT INTO rug_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Meke sipu ene tata mae koari na tinoni se Mosese, si dogoria sa sa beku bulumakao, meke sa pineka tadi na tinoni Izireli, ke bugoro sisigiti si asa. Meke gona goreni sa pa hubi toqere sari na patu labelabe saripu paleki sa, meke ta huara si arini. ");
INSERT INTO rug_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Meke vagia sa sa kineha beku bulumakao sapu tavetia rini, meke va koloa pa nika meke huara va umumu pani sa, gua na kavuru si asa, meke heni nia kolo lomoso sa. Beto asa, si va naponi sa koari na tie Izireli sa kolo asa. ");
INSERT INTO rug_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Meke zama la koe Eroni si asa, “Nasa si evaṉia ri na tinoni koa goi, meke va taveteni sinea kaleana sisigiti goi si arini.” ");
INSERT INTO rug_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Meke olaṉa se Eroni, “Mu lopu bugoro nau; gilania mua sapu sari na tie hire, si hoke hiva tavete va sea doduru totoso. ");
INSERT INTO rug_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Mae zama guahe si arini koa rau, ‘Ele seunae meke lopu gilania gami sapu ta evaṉa koasa tie hie, sapu se Mosese, sa tie sapu turaṉa vurani gita pa popoa Izipi, ke mamu tavete poni gami keke tamasa pude koimatani gita,’ gua si arini. ");
INSERT INTO rug_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Ke tozini rau, pude va gore maeni sari na dia vinasari qolo pa taliṉadi, meke arini pu ari dia si va gorei tugo meke paleke maeni rini koa rau. Meke va koloi rau pa nika sari na vinasari, meke ta evaṉae kineha bulumakao beku si asa!” ");
INSERT INTO rug_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Meke tiqe gilania Mosese sapu hiva tavete va sea sari na tinoni, meke lopu boka kopu totokoni e Eroni si arini; ke va duviduvilae pa kenudi rina dia kana. ");
INSERT INTO rug_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Ke turu pa siraṉa nuquru la gua pa vasina koa rina ipi poko tadi na tie Izireli se Mosese, meke velavela guahe, “Esei koa gamu hiva lulia sa hiniva te Zihova si mae koa rau.” Ke la turu koasa sari doduru tie pa butubutu Livae. ");
INSERT INTO rug_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Meke zama la koa rini si asa, “Se Zihova, sa Tamasa tadi na tie Izireli si zama guahe: ‘Kaqu la si gamu meke vagi sari na mia vedara, mamu la koasa vinarigara tie, podalae pa kalina hie, meke kamo la pa kalina latu; mamu va matei sari na tasimia koreo, sari na mia baere, meke sari na turaṉa mia gamu.’ ” ");
INSERT INTO rug_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Meke va tabea ri na tie Livae si asa, meke ka ṉeta tina tie si seke va matei rini. ");
INSERT INTO rug_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Meke zama la koari na tie pa butubutu Livae se Mosese, “Pa rane ṉinoroi si va madi puleni gamu si gamu, sina va matei gamu sari na tumia koreo, meke sari na tasimia koreo, ke tamanae koe Tamasa si gamu.” ");
INSERT INTO rug_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Meke pa koivugona sa rane sana, si zama la koari na tie se Mosese, “Keke sinea kaleana sisigiti si tavetia gamu. Ba kamahire si kote sage pule la koe Zihova pa toqere si rau; be boka si gina maqu va taleosaeni koe Tamasa sari na mia sinea.” ");
INSERT INTO rug_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Meke sage pule la koe Zihova pa toqere se Mosese meke zama, “Ele tavetia rina tie Izireli si keke sinea sapu kaleana sisigiti. Ele tavetia meke vahesia rini si keke tamasa qolo. ");
INSERT INTO rug_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Leana tataruni, Mamu taleoso nia sa dia sinea; ba be koromu, si Mamu huaria sa pozaqu koasa buka, vasina pu kuberi Goi sari na pozadi ri na Mua tie.” ");
INSERT INTO rug_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Meke olaṉa se Zihova, “Arini mo saripu tavete va sea pa kenuqu Rau, si kaqu huara pani Rau pozadi pa Qua buka. ");
INSERT INTO rug_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ke mamu la kamahire, mamu turaṉa lani sari na tie koasa popoa sapu ele tozi nigo Rau. Mamu balabala pulea sapu sa Qua mateana si kaqu turaṉa gamu, ba koa nana sa totoso sapu korapa mae, pana kaqu va kilasi Rau sari na tie hire koari na dia sinea,” gua. ");
INSERT INTO rug_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Ke garunu la nia e Zihova koari na tie Izireli si keke oza, sina ososo nia rini se Eroni, pude tavetia sa beku bulumakao qolo meke vahesia. ");
INSERT INTO rug_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Meke zama la koe Mosese se Zihova, “Luaria sa vasina hie, agoi meke sari na tie Izireli, saripu turaṉa vurani goi pa popoa Izipi. Mamu la koasa popoa sapu ele va tatara nia Rau koari Ebarahami, Aisake, meke e Zekopi, meke koari na tudia rina tudia. ");
INSERT INTO rug_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Kaqu garunia Rau si keke mateana pude va dogoroni gamu sa siraṉa, meke kaqu hadu va seu i Rau sari na tie Kenani, tie Amoraiti, tie Hitaiti, tie Perizaiti, tie Hivaiti meke sari na tie Zebusaiti. ");
INSERT INTO rug_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Mi la koasa popoa masuruna sapu sokua na ginani na zipale. Ba lopu kaqu somana turaṉa gamu Rau si gamu, sina na tie tasuna mia si gamu, meke kote va kilasa gamu Rau koasa mia inene la.” ");
INSERT INTO rug_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Meke sipu avosia rina tie Izireli sa inavoso variva talotaṉana gua asa; si podalae talotaṉa na kabo meke lopu va sage pulei rini sari na dia vinasari. ");
INSERT INTO rug_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Ura tozi nia e Zihova se Mosese pude zama guahe koarini, “Na tie tasuna mia si gamu, meke be somana luli koa gamu si Rau kamahire, si kote va mate beto gamu Rau koasa mia inene la. Ego, mi va gore betoi sari na mia vinasari, meke Arau mo kaqu vizatia sapu kaqu taveteni gamu,” gua. ");
INSERT INTO rug_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Ke sipu taluarae rini koasa Toqere Saenai, si lopu va sagei ri na tie Izireli sari na dia vinasari. ");
INSERT INTO rug_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Ego, hoke va turua Mosese si keke ipi, pa seseuna vasina hite koari na ipi poko tanisa vinarigara tie, meke poza nia na “ipi varivarigarana” sa si asa. Be keke tie si hiva nanasa nia si keke ginugua koe Tamasa, si kaqu la koasa ipi asa. ");
INSERT INTO rug_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Doduru totoso pana la se Mosese koasa ipi, si hoke turu pa sasadadi rina dia ipi sari na tie Izireli, meke kopu nia rini se Mosese, osolae nuquru la si asa pa korapana sa ipi. ");
INSERT INTO rug_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Meke sipu ele nuquru hola la sa, si hoke gore mae sa lei, sapu doṉodoṉo guana dedegere lavata, meke turu pa sasadana sa ipi, meke hoke zama vura mae koasa lei asa se Zihova. ");
INSERT INTO rug_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Meke sipu dogoria ri na tie Izireli sa lei, sapu doṉodoṉo guana dedegere lavata, pa sasadana sa ipi varivarigarana, si hoke todoṉo si arini pa sasadadi ri na dia ipi. ");
INSERT INTO rug_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Pa totosona asa si hoke vivinei va tia ia Mosese se Zihova, guana keke tamabaerena mo. Beto meke hoke pule la koasa vasina koa sari na ipi tadi na tie Izireli se Mosese, ba sa koreo vaqura sapu se Zosua sa nana tie varitokae, sapu sa tuna e Nani, si lopu taluarae koasa ipi. ");
INSERT INTO rug_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Meke zama la koe Zihova se Mosese, “Ele tozi nau tu Goi pude turaṉa lani koasa popoa sana sari na tie hire, ba lopu ele va gilana nau Goi sapu esei si kaqu garunu va luli maea Goi koa Rau. Ele zama nia Goi sapu gilana valeanau Goi meke qetu nau Goi, gua. ");
INSERT INTO rug_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ego, be gua asa si Agoi, si mamu tozi nau sa Mua hiniva, na binalabala, pude qu gilana valeanigo na nabulu nigo meke lopu makudo va qetu igo. Mamu balabala pulea tugo sapu sa butubutu tie hie si Mua mo telemu,” gua. ");
INSERT INTO rug_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Meke olaṉa la koe Mosese se Zihova, “Kaqu somana luli turaṉigo Rau meke kaqu somana magogoso turaṉau goi,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Meke olaṉa la ia e Mosese se Zihova, “Be lopu somana luli koa gami si Goi si mu lopu vata luarae gami koasa vasina hie. ");
INSERT INTO rug_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Namu loke tie kaqu gilania, sapu qetuni Goi sari na Mua tie meke arau, be lopu somana luli koa gami si Goi. Sa Mua sinomana koa gami, si kaqu va votikaena gami koari na tie pa popoa pepeso.” ");
INSERT INTO rug_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Meke zama la koe Mosese se Zihova, “Kaqu tavetia Rau sapu gua hiva nia goi, sina ele gilana valeana nigo meke qetu nigo Rau si goi.” ");
INSERT INTO rug_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Beto asa, si tepa ia Mosese se Zihova, pude va dogoro nia koasa sa ṉinedalana sa nana sinomana koa rini. ");
INSERT INTO rug_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Meke olaṉa se Zihova, “Kaqu vata dogoroni Rau sari doduru Qua hahanana leleadi pa kenumu goi. Meke kaqu tozi vura nia Rau sa pozaqu koa goi: Arau si e Zihova. Arini pu hiva ni Rau si kaqu tataru ni meke toka ni Rau. ");
INSERT INTO rug_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Ba lopu kaqu va dogoro nia Rau koa goi sa Isumataqu, sina be dogorau goi si lopu kaqu toa si goi. ");
INSERT INTO rug_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Ba koa nana he si keke patu pa kaliqu; vasina si kote boka turu si goi. ");
INSERT INTO rug_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Meke sipu ene hola sa ṉinedalaqu, si kaqu veko igo Rau koasa ta viqalana sa patu, meke kaqu nobi nigo limaqu, osolae hola taloa si Rau. ");
INSERT INTO rug_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Beto asa, si kaqu va seu ia Rau sa limaqu, meke sa mudiqu mo si kaqu dogoria goi; ba lopu sa Isumataqu.” ");
INSERT INTO rug_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Meke zama la koe Mosese se Zihova, “Mu peqoi karua patu labelabe vaquaradi, kekeṉoṉo gua puta tugo rina patu labelabe kekenu. Meke kaqu kuberi Rau sari na zinama saripu kuberi Rau koari karua patu kekenu saripu ele va hoqa huari goi. ");
INSERT INTO rug_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Mu va namanama vugo munumunu, mamu sage mae pa batuna sa Toqere Saenai, mamu tutuvu Au vasina. ");
INSERT INTO rug_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Namu loke tie si kaqu somana luli sage mae koa goi. Meke namu loke tie si kaqu ta dogoro pa keke vasina koasa toqere, meke namu loke sipi na bulumakao si kaqu ganigani pa hubina sa toqere.” ");
INSERT INTO rug_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Ke peqoi Mosese si karua patu labelabe sapu kekeṉoṉo gua ri karua pu koa kekenu, meke pana munumunu hokara si paleke sage lani sa pa Toqere Saenai, gua puta tugo sapu ele zama nia e Zihova. ");
INSERT INTO rug_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Beto asa, si gore mae pa korapa lei se Zihova, meke turu turaṉia Sa se Mosese, meke tozi vura nia Sa sa pozana hopena, sapu e Zihova. ");
INSERT INTO rug_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Meke ene pa kenuna e Mosese se Zihova meke zama va ululae, “Arau se Zihova, sa Tamasa sapu ta siṉie tataru meke tokani na taleosoni Rau sari na tie. Meke lopu hoke tuturei bugoro. Meke sa Qua tataru lavata si koa hola doduru totoso, meke kopu ni Rau sari na Qua zinama. ");
INSERT INTO rug_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Korapa tataruni Rau sari na Qua tie na kopuni Rau sari na Qua vina tatara koari soku tina sinage na sage meke taleosoni Rau sari na tie koari na dia sinea, meke kinaleana, totoso kilu Au rina tie si Arau; ba lopu kaqu va sasanae si Arau pude va kilasi sari na tie koari na dia sinea, kamo tu koari na tudia rina tudia koasa vina ṉeta meke vina made sinage.” ");
INSERT INTO rug_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Meke hinoqa todoṉo gore pa pepeso se Mosese meke vahesia sa sa Tamasa. ");
INSERT INTO rug_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Meke zama, “Baṉara, be qetu va hinokara nau Goi, si mamu tataruni gami, mamu luli turaṉa gami. Tie tasunadi sari na tie hire, ba mamu taleosoni sari na mami sinea saripu taveti gami, mamu kopuni gami guana Mua tie soti mo.” ");
INSERT INTO rug_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Meke zama la koe Mosese se Zihova, “Kamahire si tavetia Rau sa vinariva egoi hie koari na tie Izireli. Koarini si kaqu evaṉi Rau sari na ginugua variva magasadi saripu lopu ele hite evaṉi Rau pa doduru vasina pa popoa pepeso, koari na butubutu tie. Meke kaqu dogori doduru tie sari na tiṉitoṉa variva magasadi, saripu boka taveti Arau, Zihova, sina kote taveti Rau sari tiṉitoṉa variva magasadi koa gamu. ");
INSERT INTO rug_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Mamu va tabei sari na tinarae saripu vatui Rau koa gamu pa rane hie, meke kaqu hadu pani Rau sari na tie Amoraiti, Kenani, Hitaiti, Perizaiti, Hivaiti, meke na Zebusaiti pa kenumia gamu pa vinaripera. ");
INSERT INTO rug_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Mu lopu tavete vinariva egoi koari kaiqa tie pa popoa vasina la ia gamu sina kote va tasuna gamu rini. ");
INSERT INTO rug_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Ba mamu huari mo sari na dia hope meke sari na dia vina tigono; mamu huara gore nia sa kineha beku tamasa barikaleqe, sapu e Asera d. ");
INSERT INTO rug_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Mu lopu vahesia gamu si keke tamasa votikaena, sina Arau, Zihova si kote bugoro guana tie konokono koari na tie pu luara pani dia vinahesi koa Rau. ");
INSERT INTO rug_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Mu lopu tavete vinariva egoi koari kaiqa tie pa popoa, ura pana la va vukivukihi na vahesi rini sari na dia tamasa huporodi, si kote ruvata gamu rini pude la somana, meke kote podeke va henani gamu ginani ta poni la koari na dia tamasa si gamu. ");
INSERT INTO rug_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Meke sari na tumia koreo si kote habai sari na barikaleqe karovodi, meke kote turaṉi rini sari na mia koreo pude vata luari pa dia vina hinokara koa Rau, meke somana vahesi rini sari dia tamasa huporodi. ");
INSERT INTO rug_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Mu lopu taveti na vahesi sari na tamasa beku. ");
INSERT INTO rug_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Kaqu kopu nia na tavetia gamu sa Inevaṉa Bereti Loke Isitina. Kekeṉoṉo gua sapu ele tozini gamu Rau, si mi hena ia sa bereti loke isitina koari ka zuapa rane, koasa sidara kekenu pa vuaheni sapu ta pozae Abibi. Ura koasa sidara asa tu si taluarae si gamu pa popoa Izipi. ");
INSERT INTO rug_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Sari doduru tumia koreo kenudi, meke sari doduru kurukuru pu kopuni gamu saripu podo kenudi si Taqarau beto. ");
INSERT INTO rug_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Ba boka holu vagi pule nia gamu si keke doṉ'ki podo kenuna, koa keke tuna sipi. Ba be lopu holu vagi pule nia gamu si asa, si mamu mokua sa susuri ruana pude va matea. Mi holu vagi puleni sari doduru koreo podo kenudi. Be loke vina vukivukihi, si namu loke tie si kaqu mae koa Rau. ");
INSERT INTO rug_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Ka onomo rane si kaqu tavetavete si gamu, ba pa rane vina zuapa si kaqu magogoso si gamu, ba mi tavete gua tugo asa koari na mia totoso letelete na pakepakete. ");
INSERT INTO rug_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Mamu tavetia sa inevaṉa pakepakete totoso podalae paketi gamu sari na vua kenudi ri na mia huiti, meke sa inevaṉa vinabalabaladi rina dia Ipi pa qega pa vinabetona sa vuaheni. ");
INSERT INTO rug_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Sari doduru mia tie si kaqu mae vahesi Au si Arau Zihova, sa Tamasa tadi na tie Izireli, ka ṉeta totoso pa keke vuaheni. ");
INSERT INTO rug_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Kaqu hadu taloani Rau koa gamu sari doduru butubutu tie, meke kaqu poni va nomani gamu popoa Rau. Meke loke tie hokara si kaqu podekia pude va kilasia sa mia popoa, totoso taveti gamu sari ka ṉeta inevaṉa. ");
INSERT INTO rug_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Totosona va vukivukihi mae nia gamu koa Rau sa ehara tana vina vukivukihi, mi lopu tavetia na vinariponi sapu koa ia sa isiti. Mamu lopu veko hola ia gamu si keke kukuru masa kurukuru sapu tava mate pa totoso Inevaṉa Pasova, osolae kamoa munumunu. ");
INSERT INTO rug_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Koari hopeke vuaheni, si mi paleke maeni koasa vetu te Zihova, sari na vua kekenu arilaedi saripu paketi gamu. Keke tuna qoti babe na tuna sipi sapu korapa susu pa tinana, si mi lopu raro ia gamu koasa meleke tanisa tinana.” ");
INSERT INTO rug_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Beto asa, si zama la koe Mosese se Zihova, “Mu kubere goreni sari na zinama hire. Sina koari na ṉati zinama hire, si vata evaṉia Rau sa vinariva egoi koa goi, meke koari na tie Izireli.” ");
INSERT INTO rug_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Meke koa turaṉia Mosese vasina se Zihova ka made ṉavulu puta rane na boṉi, meke lopu hite hena na napo si asa. Meke kubere goreni sa koari na patu labelabe sari na zinama vinariva egoi, sapu sari ka manege puta tinarae. ");
INSERT INTO rug_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Meke sipu paleke goreni Mosese pa toqere Saenai sari ka manege puta tinarae, si ṉedala guana kalalasa sa isumatana, sina ele vivinei turaṉia sa se Zihova, ba lopu va nonoga ia sa si asa. ");
INSERT INTO rug_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Ari Eroni meke sari doduru tie Izireli si doṉo la nia koe Mosese, sapu ṉedala guana kalalasa sa isumatana, meke matagutu ene tata la ia rini si asa. ");
INSERT INTO rug_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Ba titioko la i Mosese si arini, ke ene la koasa se Eroni, meke sari doduru koimata tadi na tie Izireli; meke vivinei koa rini se Mosese. ");
INSERT INTO rug_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Beto sapu gua asa, si tiqe varigara la koasa sari doduru tie Izireli, meke valani Mosese koarini sari doduru tinarae saripu valani e Zihova koasa pa Toqere Saenai. ");
INSERT INTO rug_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Meke sipu beto vivinei koa rini se Mosese, si nobi va paere nia poko sa sa isumatana. ");
INSERT INTO rug_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Totoso nuquru la koe Zihova pa korapa ipi varivarigarana, se Mosese pude vivinei koe Zihova, si hoke va gore pania sa sa poko va paerena sa isumatana. Meke totoso vura si asa koasa ipi, si hoke tozi ni Mosese koari na tie Izireli, sari doduru pu ta tozi ni sa pude zama ni. ");
INSERT INTO rug_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Meke hoke dogoria rini sapu ṉedala sa isumatana, ke hoke nobi va paere pulea sa sa isumatana, osolae mae vivinei pule koe Zihova si asa. ");
INSERT INTO rug_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Meke tioko varigarani Mosese sari doduru butubutu tinoni Izireli, meke zama la koa rini si asa, “Guahe sapu tozini gamu e Zihova pude tavetia: ");
INSERT INTO rug_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Ka onomo rane si kaqu tavetavete si gamu, ba sa rane vina zuapa si madina, na rane magogoso sapu ele tava madina koa Rau, Zihova. Be keke tie si tavetavete koasa rane asa, si kaqu tava mate si asa. ");
INSERT INTO rug_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Namu loke nika si kaqu tava katu koari na mia popoa koasa rane Sabati.” ");
INSERT INTO rug_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Meke zama la koari doduru tinoni Izireli se Mosese: “Guahe si zama nia e Zihova: ");
INSERT INTO rug_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Mi tavetia sa vinariponi te Zihova; doduru tie sapu hiva si kaqu paleke maeni sari na qolo, siliva, babe na boronizi; ");
INSERT INTO rug_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","na poko lineni memelesina; meke vulu bulu, pepolo, meke ziṉara; poko sapu ta tavetae kalu qoti; ");
INSERT INTO rug_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","na kapuna sa sipi kokoreo sapu tava ziṉara; kapu rumu tava popana; huda akesia; ");
INSERT INTO rug_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","oela olive tana zuke; oto huda humaṉa lea tana vina uququ, sari na votiki oto huda oela na pauda humaṉa lea tana oela olive tana va madi tie; ");
INSERT INTO rug_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","meke sari na patu ṉedala na vinasari doṉo lea, saripu soto koasa poko hiama hopena meke sa poko raqaraqa tanisa hiama kenukenue. ");
INSERT INTO rug_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Gamu doduru tie bokaboka mia si kaqu mae, mamu taveti sari doduru tiṉitoṉa sapu zamani e Zihova: ");
INSERT INTO rug_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","sa Ipi Hopena, sari karua nobinobi tanisa, sari na qaqahere, sari na huda barabara, sari na huda tana pilipilivarata, sari na dedegere huda, sari na dia vovoina siliva; ");
INSERT INTO rug_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","sa Bokese Tanisa Vinariva Egoi, meke sari na palepalekeana, sa tukutukuna, vasina pu koa ia tinaleosae na vinulasadi sari na sinea, meke sa poko goba pa vari korapana sa Lose Hopena pa Hopena, meke sa Lose Hopena; ");
INSERT INTO rug_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","sa tevolo bereti meke sari na palepalekeana meke sari doduru nana tiṉitoṉa; sa bereti ta valana koe Tamasa; ");
INSERT INTO rug_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","sa tuturuana zuke meke sari nana tiṉitoṉa, sari na zuke meke sari na dia oela; ");
INSERT INTO rug_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","sa hope tana vina uququ humaṉa lea, meke sari na palepalekeana, sa oela tana vina madi, meke sa oto huda humaṉa lea tana vina uququ koasa lose hopena, sa gobagoba poko koasa nuqunuquruana; ");
INSERT INTO rug_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","sa hope vina vukivukihi va uququana, hatara lopalopa boronizi tanisa hope, sari na palepalekeana meke sari na tiṉitoṉa tavetavete tanisa, meke sa besini boronizi nomana meke sa nana tuturuana; ");
INSERT INTO rug_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","sa gobagoba poko lineni arilaena pu vari likohae nia sa Ipi Hopena, sari na barabara boronizi, meke sari na dia vovoina boronizi, meke sa gobagoba poko koasa nuqunuquruana; ");
INSERT INTO rug_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","meke sari na tupili, meke sari na aroso pusipusiana tana ipi, meke sa gobagoba poko vari likohae; ");
INSERT INTO rug_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","meke sari na poko arileadi saripu va sagei rina hiama, meke tavetavete ni rini pa korapa Ipi Hopena. Arini sari na poko hopedi te Eroni meke sari na tuna koreo.” ");
INSERT INTO rug_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Beto asa, si taluarae koe Mosese sari na tie, ");
INSERT INTO rug_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","meke sari doduru tie pu hiva, si paleke maeni sari na dia vinariponi koe Zihova, pude kuria sa Ipi Hopena te Zihova. Meke paleke maeni rini sari doduru likakalae pu ta hivaedi pude tavetaveteni koasa ipi, meke sari na poko arilaedi tadi na hiama. ");
INSERT INTO rug_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Meke sari doduru tie na barikaleqe pu hiva si paleke mae vinasari: patu arilaedi, na vikulu, na riṉi, na pakupaku, meke doduru votivotiki vinasari ta tavetedi pa qolo, meke tava madi koe Zihova. ");
INSERT INTO rug_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Meke sari doduru pu tago poko lineni memelesidi, poko bulu, poko pepolo, lozi vulu ziṉara, poko kalu qoti; na kapu sipi kokoreo tava ziṉara; na kapu rumu tava popana. ");
INSERT INTO rug_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Meke sari doduru pu boka variponi siliva, babe boronizi, si paleke maeni dia vinariponi koe Zihova; meke ari doduru pu tago huda akesia, pude boka ta tavetavetae si ta paleke mae tugo. ");
INSERT INTO rug_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Sari doduru barikaleqe bokabokadi si paleke mae lozi vulu keoro, bulu, meke ziṉara, saripu taveti rini. ");
INSERT INTO rug_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Meke na kalu qoti tugo si tavete nia lozi rini. ");
INSERT INTO rug_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Meke paleke maeni ri na koimata sari na patu onikisi, meke sari votiki patu arilaedi pule, pude tava soto koasa poko hiama hopena meke sa poko raqaraqa tanisa ṉati hiama kenukenue. ");
INSERT INTO rug_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Meke paleke maeni rini sari na tiṉitoṉa humaṉa lea, na oela tana zuke, meke na oela tana vina madi meke oto huda humaṉa lea tana vina uququ. ");
INSERT INTO rug_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Sari doduru tinoni Izireli saripu hiva varitokae, si paleke maeni rini koe Zihova sari dia vinariponi pude tavetaveteni pa tinavete koasa Ipi Hopena, saripu tozini Sa koe Mosese pude taveti. ");
INSERT INTO rug_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Meke zama la koari na tinoni Izireli se Mosese, “Ele vizatia e Zihova se Bezaleli, sa tuna e Uri sapu sa tuna Huri koasa butubutu Ziuda. ");
INSERT INTO rug_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Ele tava siṉi nia Sa sa Maqomaqona Tamasa, meke ele poni nia Sa koasa sa ginilagilana, tinumatumae, na binokaboka pude taveti sari doduru votivotiki tinavete, ");
INSERT INTO rug_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","pude taveti sa sari doduru tiṉitoṉa tolavaedi na leleadi pa tinavete, pude tavetavete nia sa qolo, siliva, meke na boronizi. ");
INSERT INTO rug_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Bokabokana hola koari na tinavete patu arilaedi na huda si asa; meke koari doduru pule tinavetavete pude taveteni sari na tiṉitoṉa tolavaedi na arilaedi. ");
INSERT INTO rug_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Ponia Zihova koasa, meke koe Oholiabi sa tuna koreo e Ahisamaka, sapu sa tie pa butubutu te Dani, sa binokaboka, pude va tumatumaei sari na tie tavetavete pude boka somana pa tinavete si arini. ");
INSERT INTO rug_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Poni e Zihova koa rini sa binokaboka arilaena pude taveti sari doduru votivotiki tinavete: pude boka peqo kineha pa huda, taveteni sari na kineha pa poko pude tavetavete ni lozi keoro, bulu, pepolo, meke ziṉara, meke boka tigitigisi tugo si arini. ");
INSERT INTO rug_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Ke se Bezaleli meke se Oholiabi, meke sari doduru tie bokabokadi pa tinavete lima, saripu ele poni ginilagilana na tinumatumae e Zihova meke gilani gua pude taveti sari doduru likakalae, meke na tiṉitoṉa tana kinurina sa Ipi Hopena, si kaqu taveti rini sari doduru gua pu ele garununi e Zihova.” ");
INSERT INTO rug_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Meke tioki Mosese sari Bezaleli e Oholiabi, meke sari doduru tie bokabokadi pule, saripu poni binokaboka e Zihova meke sarini pu hiva varitokae, meke tozini Mosese pude podalae tavetavete. ");
INSERT INTO rug_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Meke vagi rini koasa sari doduru vinariponi, saripu paleke maeni ri na tie Izireli, pude kuria sa Ipi Hopena. Ba lopu beto paleke lani ri na tie Izireli koe Mosese sari na dia vinariponi doduru munumunu. ");
INSERT INTO rug_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Ke luara vekoa ri na tie bokabokadi sa dia tinavete, sapu korapa tavetia rini koasa Ipi Hopena, ");
INSERT INTO rug_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","meke la zama koe Mosese, “Sari na tie si korapa paleke va soku sisigiti mae, hola nia sapu ta hivae koasa tinavete, sapu ele garunu nia sa Tamasa pude tavetia.” ");
INSERT INTO rug_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Ke garunu lani zinama e Mosese sari doduru tinoni, pude loke tie si kaqu vala pule vinariponi koasa Ipi Hopena; ke lopu paleke pule la sari na tie. ");
INSERT INTO rug_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Sapu gua ele ta vala, si soku hola nia sa padana, pude va hokotia sa doduruna sa tinavete. ");
INSERT INTO rug_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Sari na tie bokabokadi hola pa tinavete koari doduru tie si tavetia sa Ipi Hopena te Tamasa d. Ka manege puta kukuru poko lineni arilaedi, sapu ta tigisi lozi bulu, pepolo, meke ziṉara si taveti rini; meke tigisi ni mateana serubimi rini sari na poko. ");
INSERT INTO rug_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Sari na gineledi ri na hopeke kukuru poko si ka manege rua mita geledi, meke karua mita labedi. ");
INSERT INTO rug_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Meke piti varihodaeni rini sari ka lima poko pa keke kalina, meke gua tugo sari ka lima pule pa keke kalina. ");
INSERT INTO rug_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Beto asa si va sotoni kukuru poko bulu bobolokuhae sapu koai na lopa rini hukihukiridi sari na poko pude boka lopoti na labete sisigotoana. ");
INSERT INTO rug_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Meke piti va sotoi rini sari ka lima ṉavulu puta kukuru poko bulu bobolokuhae sapu koai na lopa koari hopeke karua kalina sa poko. ");
INSERT INTO rug_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Beto asa si taveti rini si ka lima ṉavulu puta qaqahere pude lozo, meke doṉo guana keke mo sari karua poko. ");
INSERT INTO rug_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Beto asa si vagi rini sari ka manege eke kukuru poko sapu ta tavete pa kalu qoti, meke tavetia keke ipi poko pude nobia sa Ipi Hopena. ");
INSERT INTO rug_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Sari padadi ri doduru si ka manege ṉeta mita geledi meke karua mita labedi. ");
INSERT INTO rug_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Piti varihodaeni rini sari ka lima poko pude tavetia si keke, meke gua tugo sari ka onomo pule. ");
INSERT INTO rug_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Meke va sotoi pule rini sari ka lima ṉavulu puta kukuru poko bulu bobolokuhae sapu koai na lopa, pa hukihukiridi sari karua poko hire. ");
INSERT INTO rug_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Beto asa si taveti pule rini sari ka lima ṉavulu puta qaqahere boronizi, pude ta varihodae sari karua kukurudi, meke doṉo guana keke nobinobi mo. ");
INSERT INTO rug_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Beto asa si tavete pulei rini si karua nobinobi tanisa Ipi Hopena. Keke si na kapu sipi kokoreo, sapu tava ziṉara, meke keke pule si na kapu rumu, pude tana sada. ");
INSERT INTO rug_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Beto asa, si va turu varibarani rini sari kaiqa huda barabara akesia pude tanisa Ipi Hopena. ");
INSERT INTO rug_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Hopeke ri na barabara si ka made mita ululuna, meke onomo ṉavulu onomo sentimita labena, ");
INSERT INTO rug_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","meke hopeke karua barabara hire si turu koari na vovoina siliva. ");
INSERT INTO rug_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Taveti rini si ka hiokona puta hopeke karua huda barabara tana kali mataona. ");
INSERT INTO rug_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Meke ka made ṉavulu puta vovoina siliva si koa pa kaurudi ri hopeke karua huda barabara. Karua huda barabara si varihodae meke sa hubidi si turu pa karua vovoina siliva. ");
INSERT INTO rug_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Meke taveti pule rini si ka hiokona puta hopeke karua huda barabara pude tana kali gedenasa Ipi Hopena. ");
INSERT INTO rug_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","Meke ka made ṉavulu puta vovoina siliva, si koa pa kaurudi ri hopeke karua barabara. ");
INSERT INTO rug_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Meke pa mudina sa ipi pa kali lodu rimata, si taveti rini si ka onomo hopeke karua huda barabara. ");
INSERT INTO rug_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Tavete pulei rini karua hopeke barabara huda, koari karua iiona pa mumudi. ");
INSERT INTO rug_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Sari karua barabara huda koari hopeke iiona sa Ipi Hopena, si ta varihodae varigara si arini meke ta tuqe varigarae koa keke riṉi boronizi, panapeka meke kamo panaulu. ");
INSERT INTO rug_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Gua asa, ke taveti rini si ka vesu sari doduru hopeke karua barabara huda pa mudina sa Ipi Hopena, meke kaqu ka manege onomo sari doduru vovoina siliva, karua vovoina pa kaurudi ri hopeke karua barabara huda. ");
INSERT INTO rug_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Taveti rini sari na huda akesia, pude tana gaso, pude va ṉiṉirai sari na huda tuturu koari na barabara tana Ipi Hopena. Ka lima gaso si pude tuqe varigarani sari na barabara pa keke kalina, ");
INSERT INTO rug_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","meke ka lima pule si pude tuqe varigarani sari na barabara pa keke kalina. Meke ka lima pule gaso, pude tuqe varigarani sari na barabara pa mudina sa Ipi Hopena. ");
INSERT INTO rug_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Sa huda gaso pa kokorapadi rina barabara, si kamo la gua koari karua vina betobeto barabara. ");
INSERT INTO rug_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Vekoni riṉi qolo rini sari na barabara huda, meke va lopoto lani sari na gaso koari na riṉi, meke pokoni kapu qolo sari na barabara, meke sari na huda gaso. ");
INSERT INTO rug_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Meke tavete nia poko lineni arilaena rini si keke goba poko, meke pitini lozi bulu, pepolo meke ziṉara. Beto meke piti valani rini sari na kineha mateana serubimi si asa. ");
INSERT INTO rug_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Beto asa si va sigotia rini sa poko goba koari na qaqahereana qolo saripu sotodi koari ka made dedegere huda akesia sapu ta pokoe qolo meke saripu turudi koari ka made vovoina siliva. ");
INSERT INTO rug_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Ego, koasa nuqunuquruana tanisa Ipi Hopena, si va sigoto nia poko goba ta tavetena pa poko lineni arilaena, sapu ta pitie lozi bulu, pepolo, meke ziṉara; meke piti nia vinasari tugo rini si asa. ");
INSERT INTO rug_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Meke taveti tugo rini si ka lima dedegere huda akesia sapu ta pokoe qolo, pude tanisa poko goba asa, meke va sotoni qaqahere rini; meke taveti tugo ka lima vovoina boronizi, pude tadi na dedegere arini. ");
INSERT INTO rug_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Tavete nia huda akesia e Bezaleli sa Bokese Vinariva Egoi, ka keke gogoto manege puta sentimita sa ginelena, ka onomo ṉavulu onomo sentimita labena, onomo ṉavulu onomo sentimita ululuna. ");
INSERT INTO rug_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Meke va poko nia qolo sa pa korapana meke mudina, meke gua tugo doduru vari likohaena. ");
INSERT INTO rug_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Meke taveti sa ka made riṉi qolo palepalekeana; meke va soto lani koari ka made nenena; karua riṉi koari karua kalina. ");
INSERT INTO rug_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Meke taveti sa sari na palepalekeana huda akesia, meke va pokoni qolo sa si arini. ");
INSERT INTO rug_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Meke va lopoto lani sa koari na riṉi, pa karua kalina sa bokese sari na huda. ");
INSERT INTO rug_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Meke tavetia pa qolo viana si keke tukutuku qolo viana, sapu keke gogoto manege puta sentimita gelena, meke onomo ṉavulu onomo sentimita labena. ");
INSERT INTO rug_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","8","Meke sekeseke va vurai sa sari karua serubimi koasa tukutuku qolo, keke pa hopeke kalina; keke tini mo sa tukutuku meke sari karua serubimi. ");
INSERT INTO rug_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Meke sari karua serubimi si vari doṉo totoi meke sari na tatapurudi si nobia sa tukutuku. ");
INSERT INTO rug_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Meke tavete nia huda akesia e Bezaleli si keke tevolo, vesu ṉavulu vesu sentimita gelena, made ṉavulu made sentimita labena, meke onomo ṉavulu onomo sentimita ululuna. ");
INSERT INTO rug_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Meke poko nia qolo viana sa sa tevolo meke va moata nia qolo viana sa sa hukihukirina sapu pa vari likohaena sa tevolo. ");
INSERT INTO rug_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Meke tavetia sa si keke tokatoka sage pa hukihukirina sa tevolo. Sa ululuna sa tokatoka sage si ka zuapa ṉavulu lima milimita, meke sa hukihukirina panaulu koasa tokatoka sage si va moata nia qolo. ");
INSERT INTO rug_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Meke taveti sa ka made qolo riṉi palepalekeana, meke hopeke va sotoi sa koari ka made iiona sa tevolo, vasina koa sari hopeke nenena. ");
INSERT INTO rug_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Sari na riṉi si va sotoi sa kapae koasa tokatoka sage pude tuqei sari na huda palepalekeana tanisa tevolo. ");
INSERT INTO rug_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Meke tavete ni sa sari karua palepalekeana huda akesia, meke va poko ni qolo sekesekeana. ");
INSERT INTO rug_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Beto asa si taveti sa sari na peleta, kapa, zagi, na besini, pude tana naponapoana vaeni; tavete betoni sa pa qolo viana sari doduru hire. ");
INSERT INTO rug_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Beto asa si tavete nia qolo viana sa si keke tuturuana zuke. Sekeseke hitehitea sa hubina meke dedegerena, meke tavete vurani sa si kaiqa kineha kapa havohavoro, guana vina sari, sari na havoro lopu ele pelaradi, meke na elodi, meke keke tini doduruna mo si arini. ");
INSERT INTO rug_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Kaqu ka onomo limana sa tuturuana zuke; ka ṉeta pa karu kalina. ");
INSERT INTO rug_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Hopeke koari ka onomo limana hire, si koadia sari ka ṉeta vinasari havoro, sapu doṉo guana kineha havoro olomodi, sapu koai elodi na havoro lopu ele pelaradi. ");
INSERT INTO rug_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Meke koasa dedegerena sa tuturuana zuke, si koadia tugo sari ka made kapa, sapu doṉo guari na havoro huda olomodi kinehadi, sapu koai na havoro lopu ele pelaradi, meke na elodi. ");
INSERT INTO rug_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Koanana si keke havoro lopu pelarana, panapeka koari ka ṉeta hopeke limadia. ");
INSERT INTO rug_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Sari na limana, meke sari na havoro lopu ele pelaradi, meke sa tuturuana zuke si ta sekeseke meke ta tavete vura pa qolo viana. ");
INSERT INTO rug_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Beto taveti sa ka zuapa zuke oela hitekedi, meke vekoi koasa tuturuana zuke, meke taveteni qolo viana sa sari na nepihina meke sari na vovoina. ");
INSERT INTO rug_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Tavetia sa sa tuturuana zuke meke sari na tiṉitoṉa tanisa koari ka toloṉavulu lima kilo qolo viana. ");
INSERT INTO rug_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Meke tavete nia huda akesia e Bezaleli si keke hope tana vina uququ humaṉa lea. Meke kekeṉoṉo puta gelena, meke labena, sapu made ṉavulu lima sentimita labena meke gelena, meke sia ṉavulu sentimita ululuna. Meke taveti sa sari na kikihona pa hopeke iiona sapu keke mo koasa tinina. ");
INSERT INTO rug_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Beto poko nia qolo sa batuna, sari ka made kalina, meke sari ka made kikihona sa hope. Beto asa si tavetia sa sa hukihukirina sapu ta pokoe qolo. ");
INSERT INTO rug_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Meke taveti sa karua palepalekeana riṉi qolo, meke va sotoi pa kaurudi ri karua kalina sapu ta pokoe qolo, pude tuqei sari na huda palepalekeana. ");
INSERT INTO rug_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Beto asa si taveteni huda akesia sa sari na palepalekeana, meke pokoni qolo tugo sa. ");
INSERT INTO rug_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Beto asa si tavetia sa sa oela tana vina madi, meke sa oto huda humaṉa lea. ");
INSERT INTO rug_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Meke beto asa si tavete nia huda akesia e Bezaleli si keke hope vukivukihi uququana sapu kekeṉoṉo puta sari ginelena meke linabena. Meke karua gogoto hiokona puta sentimita gelena meke labena, meke keke gogoto toloṉavulu puta sentimita ululuna. ");
INSERT INTO rug_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Meke taveti sa si ka made kikiho koari ka made iiona sa hope. Sari na kikiho meke sa hope si ta tavetae keke tini meke pokoni boronizi sa. ");
INSERT INTO rug_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Meke taveteni boronizi sa sari doduru tiṉitoṉa pu kaqu ta tavete ni pa tinavete vina vukivukihi: sapu sari na raro boronizi pude oki pani sari na eba, sari na besini boronizi pude tana sisiruana ehara, sari na poka ililiriana masa, meke sari na raro boronizi pude tana nika. ");
INSERT INTO rug_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Beto asa si tavetia sa si keke hatara lopalopa boronizi voivoina eba suludi, meke veko la nia sa tiṉitoṉa lopalopa pa korapana sa hope uququana, pude koa pa kokorapana sa hope, ");
INSERT INTO rug_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","meke va soto nia sa ka made riṉi boronizi, koari hopeke iiona sa hatara. ");
INSERT INTO rug_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Beto si taveti sa sari na palepalekeana huda akesia, meke pokoni boronizi. ");
INSERT INTO rug_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Meke tava lopoto koari na riṉi sari na palepalekeana, pude koa varikali koari karu kalina sa hope, totoso ta paleke si asa. Meke taveteni labete labedi sa sa hope, meke kokobana sa korapana sa hope. ");
INSERT INTO rug_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Meke tavetia sa si keke besini boronizi nomana meke gua tugo sa tuturuanana koari na tiroana ta tavetae boronizi tadi na barikaleqe saripu tavetavetedi koasa nuqunuquruana la koasa Ipi Hopena. ");
INSERT INTO rug_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Beto asa si tavetia sa si keke gobagoba poko lineni arilaena pu vari likohaena sa Ipi Hopena te Zihova. Sa kali matao si made ṉavulu made mita gelena, ");
INSERT INTO rug_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","meke ka hiokona puta sari na barabara boronizi, saripu turudi koari ka hiokona puta vovoina boronizi, meke sari na qaqahereana pa hopeke barabara meke sa gaso vasina tava sigoto sa goba si ta tavetae siliva. ");
INSERT INTO rug_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Meke tavete kekeṉoṉo puta gua nia tugo sa sa gobagoba poko pa kali gede. ");
INSERT INTO rug_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Pa kali lodu rimata si koa nana sa gobagoba poko sapu ka hiokona rua mita labena, meke ka manege puta sari na barabara, pa hopeke dia vovoina boronizi, meke sari na qaqahereana pa hopeke barabara meke sa gaso vasina tava sigoto sa goba si ta tavetae siliva. ");
INSERT INTO rug_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Sa gobagoba poko koasa nuqunuquruana pa kali gasa rimata, si ka hiokona rua mita labena. ");
INSERT INTO rug_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","Sa gobagoba poko koari hopeke kalina sa nuqunuquruana, si onomo mita meke onomo ṉavulu sentimita; meke ka ṉeta sari barabara boronizi meke hopeke dia vovoina boronizi. ");
INSERT INTO rug_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Sari doduru gobagoba poko saripu vari likohae nia sa vasina tanisa Ipi Hopena, si ta tavetae na poko lineni arilaena beto. ");
INSERT INTO rug_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Sari doduru vovoina barabara pa vari likohaena sa gobagoba poko, si ta tavetae boronizi, meke sari na qaqahereana pa hopeke barabara meke sa gaso vasina tava sigoto sa goba meke sari na nobidi ri na batudi ri na barabara, si ta tavetae siliva. Meke vari hodae sari na barabara koari na gaso siliva. ");
INSERT INTO rug_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Meke sa gobagoba poko koasa nuqunuquruana si ta tavetae poko lineni arilaena, sapu ta pitie lozi vulu bulu, pepolo, meke ziṉara; meke piti nia vinasari tugo sa si asa. Meke ka sia mita gelena meke karua mita ululuna, kekeṉoṉo gua sari doduru poko goba. ");
INSERT INTO rug_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Meke sari na qaqahereana pa hopeke barabara meke sa gaso vasina tava sigoto sa goba meke sari na nobidi ri na batudi ri na barabara si ta tavetae siliva. ");
INSERT INTO rug_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Meke sari na tupili tanisa Ipi Hopena meke sa gobagoba poko pa vari likohaena si ta tavetae pa boronizi. ");
INSERT INTO rug_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Hire sari na likakalae arilaedi saripu tavetaveteni rini koasa Ipi Hopena, vasina pu ta kopue sari ka manege puta tinarae saripu ta kubere koari karua patu labelabe. Garununi Mosese koarini, pude kubere goreni sari na tiṉitoṉa arilaedi, ke kubere goreni ri na tie pa butubutu Livae, saripu ta totolie pa tinuraṉa te Itamara, tuna Eroni sapu sa hiama. ");
INSERT INTO rug_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Doduru tiṉitoṉa saripu garununi e Zihova koe Mosese si tavete betoi e Bezaleli, sa tuna koreo e Uri sapu sa tuna e Huri sapu keke tie pa butubutu Ziuda. ");
INSERT INTO rug_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Se Oholiabi sa nana tie varitokae, sapu na tuna koreo e Ahisamaka, koasa butubutu te Dani, si na tie bokabokana pa tinavete patu arilaedi, na tinavete pitipiti poko lineni arilaedi, meke pitipiti lozi vulu bulu, pepolo, meke ziṉara si asa. ");
INSERT INTO rug_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Sari doduru qolo saripu ele tava madidi koe Zihova, pude tana Ipi Hopena, si keke tina kilo mamatadi. Asa sa pada koasa padapadana hopena tadi na hiama. ");
INSERT INTO rug_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Sari na siliva saripu ta vala koe Zihova totoso ta nae sari na tie, si ṉeta tina made gogoto toloṉavulu puta kilo mamatana. Asa sa pada koasa padapadana hopena tadi na hiama. ");
INSERT INTO rug_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Asa sa padana, sa sinokuna, sapu ta tabara koari doduru tie pu somana koasa ninae. Hopeke arini si tabaria, sapu gua ta hivae pude tabaria rini sa hinerena sa dia tinoa. Sa padana pa doduruna koasa padapadana hopena tadi na hiama. Ari ka onomo gogoto ṉeta tina meke lima gogoto lima ṉavulu puta tie, saripu ka hiokona vuahenidi babe hola, si somana koasa ninae. ");
INSERT INTO rug_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Koari na siliva, ka ṉeta tina made gogoto kilo, si tavetavete ni rini koari ka keke gogoto vovoina barabara meke koasa poko goba tanisa Ipi Hopena; ka toloṉavulu made kilo pa hopeke vovoina barabara. ");
INSERT INTO rug_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Meke toloṉavulu puta kilo siliva, si tavete nia rini koari na gaso siliva, sari na qaqahereana, meke sari na nobidi ri na batudi ri na barabara. ");
INSERT INTO rug_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Sa boronizi sapu ta vala koe Zihova si ka karua tina made gogoto hiokona lima kilo mamatana. ");
INSERT INTO rug_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Sa boronizi hie si taveteni vovoina tana nuqunuquruana koasa Ipi Hopena te Zihova, meke sa hope boronizi tana vina vukivukihi, meke sa hatara lopalopa boronizi meke sari doduru tiṉitoṉa saripu ta tavetae koasa hope, ");
INSERT INTO rug_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","meke sari na vovoidi rina barabara boronizi na tupili tanisa Ipi Hopena, meke tanisa gobagoba poko vari likohaena sa meke sa nuqunuquruana kekenu koa sa gobagoba poko asa. ");
INSERT INTO rug_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Pitini lozi vulu bulu, pepolo, na ziṉara rini sari na poko tadi na hiama. Ta pokoe sari na poko hire totoso taveti rini sari na dia tinavete pa korapa Ipi Hopena. Gua puta tugo sapu tozia e Zihova koe Mosese, si tavete guni tugo rini sari na poko hiama te Eroni. ");
INSERT INTO rug_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Pitipitini ri na tie sari na lozi qolo, bulu, pepolo, ziṉara, koasa lineni arilaena sapu sa poko tanisa hiama. ");
INSERT INTO rug_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Beto asa si muzara va manivisi gunia na poko rini sa qolo; meke resi va gelegele, meke tavete gunia na lozi sa qolo pa vari korapana sari na lozi vulu bulu, pepolo, meke ziṉara rini. ");
INSERT INTO rug_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Meke taveti rini si karua soqosoqoana pa avarana sa poko, meke va sotoi koari karua hukihukirina, pude tana va nabunabuana. ");
INSERT INTO rug_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Sa poko dokoho arilaena sapu ta pitie vina sari kekeṉoṉo gua tugo asa koasa poko hiama, si tava soto la koasa poko tana hiama hie, gua tugo sapu ele tozi nia e Zihova koe Mosese pude tavetia. ");
INSERT INTO rug_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Meke va namani karua patu arilaedi sapu ta pozae onikisi si arini, meke va sotoi koari karua sosotoana qolo, pude tuqei sari na patu; meke kuberi rini sari na pozadi ri ka manege rua tuna koreo Zekopi. ");
INSERT INTO rug_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Meke vekoi rini pa avarana, koari karua sosotoanana sa poko hiama pude na vina balabaladi ri ka manege rua butubutu Izireli, gua puta tugo asa sapu tozia e Zihova koe Mosese pude tavetia. ");
INSERT INTO rug_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Meke tavetia rini sa poko raqaraqa tanisa hiama sapu kekeṉoṉo gua tugo sa pinitina sa vinasari koasa poko lineni arilaena tanisa poko hiama sapu ta piti pa lozi qolo, bulu, pepolo, meke ziṉara. ");
INSERT INTO rug_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Tomorua, keke pidoko gelena, meke keke pidoko tugo labena si asa. ");
INSERT INTO rug_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Meke veko nia ka made tokele patu marilaedi sa poko raqaraqa. Koasa tokele kekenu si vekoa rini si keke patu sapu ziṉara guana qelasi sapu ta pozae rubi, keke patu sapu meava guana hakua saganana sapu ta pozae topazi, meke keke patu sapu guana pepeso ziṉara sapu ta pozae qaraneti. ");
INSERT INTO rug_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Meke koasa tokele vina rua si na patu sapu buma guana elo huda sapu ta pozae emerolo, keke patu sapu buma guana lamana peava sapu ta pozae sapira, meke keke patu sapu ta pozae daemani. ");
INSERT INTO rug_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Koasa tokele vina ṉeta si na patu buma gua sa kopi pa sagauru pa rane sapu gona rimata sapu ta pozae turakoisi, meke keke patu pepolo sapu ta pozae aqate, meke keke patu pepolo guana vua leqata sapu ta pozae ametiseti; ");
INSERT INTO rug_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","meke koasa tokele vina made, si keke patu buma guana elo kinu sapu ta pozae beriolo, keke patu ziṉara sapu ta pozae karaneliani, meke keke patu ṉedala guana qelasi viana sapu ta pozae Zasipa. Meke vekoni rini koari na sosotoana qolo sari na patu arini. ");
INSERT INTO rug_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Koari hopeke patu hire, si ta kubere keke pozadi koari hopeke tuna koreo e Zekopi, pude keke pozapoza butubutu Izireli pa hopeke patu. ");
INSERT INTO rug_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Meke koasa poko raqaraqa, si taveti rini karua seni qolo hinokara, sapu nokinokie guana aroso pude sigoto. ");
INSERT INTO rug_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Beto meke taveti pule rini karua riṉi qolo, meke vari sotoni pa hukihukiri avara panaulu koasa poko tana raqaraqa, ");
INSERT INTO rug_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Beto asa si vari soto va ṉirani sari karua seni qolo koari karua riṉi, ");
INSERT INTO rug_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","meke vari sotoni sari karua seni qolo hire koari karua sosotoanana sa poko hiama vasina tava soto sari karua patu onikisi pa avarana. ");
INSERT INTO rug_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Beto meke taveti rini karua riṉi qolo, meke soto lani koasa hukihukirina gore sa poko raqaraqa. ");
INSERT INTO rug_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Meke taveti pule rini si karua riṉi qolo, meke va soto la ni pa kenuna sa poko hiama tata koasa poko dokoho. ");
INSERT INTO rug_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Sari na riṉi tanisa poko raqaraqa si ta pusie va nabu koari na riṉi tata koasa poko dokoho pa kenuna sa poko tana hiama koari karua aroso bulu, pude kapae va leana koasa raqaraqa meke lopu kepuhu taloa koasa poko hiama, kekeṉoṉo gua sapu ele tozi nia Zihova se Mosese. ");
INSERT INTO rug_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Sa poko gele sapu koa kaurae koasa poko kukuru, si ta tavetae poko bulu mo. ");
INSERT INTO rug_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Koaia keke lopa, pude tanisa ruana si asa, meke sa lopa tanisa rua hie si ta piti vari likohae, pude va ṉiṉira ia meke lopu kaqu boka rikata si asa. ");
INSERT INTO rug_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","26","Koasa doduru vari likohaena sa hubina sa poko, si veko nia rini guana vua huda pomeqaraneti, sapu bulu, pepolo, meke ziṉara meke hopeke belo qolo pa varikorapadi, kekeṉoṉo gua sapu tozi nia Zihova se Mosese. ");
INSERT INTO rug_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Meke taveti rini sari na poko keoro doduru, te Eroni meke sari na tuna koreo, ");
INSERT INTO rug_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","meke sari na toropae hiama, meke sa pusi batu tadi na tuna koreo e Eroni meke te Eroni, meke taveti rini sari na dia poko korapae, meke pitini vinasari koasa poko lineni arilaena. ");
INSERT INTO rug_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Meke piti nia vinasari tugo rini sa poko dokoho koasa poko lineni arilaena koari na lozi vulu bulu, pepolo, meke ziṉara, gua tugo sapu ele tozi nia Zihova koe Mosese. ");
INSERT INTO rug_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Meke tavetia rini si keke tiṉitoṉa qolo viana sapu doṉo lea, meke kuberia rini pa korapana sa zinama hie, “Ele Tava madi koe Zihova,” gua. ");
INSERT INTO rug_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Meke pusi nia rini pa kenuna sa toropae batu tanisa hiama koasa keke aroso bulu, gua sapu ele tozi nia Zihova koe Mosese. ");
INSERT INTO rug_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Beto asa sari doduru tinavete koasa Ipi Hopena te Zihova si hokoto beto. Ele tavete betoi ri na tie Izireli sari doduru gua pu tozi e Zihova koe Mosese pude taveti. ");
INSERT INTO rug_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Meke paleke la nia rini koe Mosese sa Ipi Hopena, meke sari doduru tiṉitoṉa tanisa: sari na qaqahere, sari na huda barabara, sari na huda tana pilipilivarata, sari na dedegere huda, sari na dia vovoina dedegere, ");
INSERT INTO rug_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","sari karua nobinobi tanisa Ipi Hopena, sapu sa kapu sipi kokoreo, sapu tava ziṉara, meke sa kapu rumu, meke sa poko goba pa vari korapana sa lose hopena pa hopena meke sa lose hopena; ");
INSERT INTO rug_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","sa Bokese Vinariva Egoi, sapu koa ia rina patu labelabe, sari na huda palepalekeana, meke sa tukutukuna; ");
INSERT INTO rug_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","sa tevolo meke sari doduru tiṉitoṉa tanisa, meke sa bereti madina sapu ta valana koe Tamasa; ");
INSERT INTO rug_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","sa tuturuana zuke sapu ta tavetae qolo viana, sari na zukena, meke sari doduru tiṉitoṉa pude tavetavete ni, meke sari na oela tadi na zuke; ");
INSERT INTO rug_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","sa hope sapu ta tavetae qolo, meke sa oela tana vina madi, sa oto huda humaṉa lea tana vina uququ, sa poko goba tana nuqunuquruana la koasa Ipi Hopena; ");
INSERT INTO rug_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","sa hope boronizi meke sa hatarana, sari na huda palepalekeana, meke sari doduru tiṉitoṉa pude tavetavete ni koasa; sa besini boronizi nomana meke sa nana tuturuana; ");
INSERT INTO rug_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","sari na gobagoba poko lineni pu vari likohae nia sa vasina tanisa Ipi Hopena, sari na barabara boronizi, meke sari na vovoina boronizi; sa gobagoba poko koasa nuqunuquruana koasa sa gobagoba poko lineni, meke sari na aroso pusipusiana; sari na tupili tanisa Ipi Hopena meke sari doduru tiṉitoṉa tavetaveteana tanisa Ipi Hopena; ");
INSERT INTO rug_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","meke sari na poko arileadi tadi na hiama pude va sagei rini totoso nuquru rini pa Lose Hopena; meke sari na poko madidi tadi Eroni meke sari na tuna koreo. ");
INSERT INTO rug_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Meke va hokoto betoi ri na tie Izireli sari doduru tinavete, gua puta tugo sapu tozi nia e Zihova koe Mosese pude taveti. ");
INSERT INTO rug_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Meke la doṉo viliti betoi Mosese sari doduru tinavete, meke dogori sa sapu gua puta tugo asa sapu tozi nia e Zihova koasa pude taveti. Ke va madi Mosese si arini. ");
INSERT INTO rug_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Meke zama la koe Mosese se Zihova, ");
INSERT INTO rug_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Koasa rane vinakeke koasa sidara kekenu, si mamu va turua sa Ipi Hopena sapu koa ia e Zihova vasina sapu kaqu tutuvu gamu Sa. ");
INSERT INTO rug_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Mamu vekoa pa korapana sa Ipi Hopena sa Bokese Vinariva Egoi, sapu koa ia ri ka manege puta tinarae, mamu vekoa si keke poko goba pa kenuna sa. ");
INSERT INTO rug_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Mamu paleke nuquru nia sa tevolo bereti meke sari na likakalae tana vinariponi napo na bereti, meke mamu paleke nuquru nia tugo sa tuturuana zuke, mamu va turui koasa sari na zuke. ");
INSERT INTO rug_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Mamu vekoa sa hope qolo tana vina uququ humaṉa lea pa kenuna sa Bokese Vinariva Egoi, beto mamu va sigotia sa poko goba pa vasina nuqunuquruana tanisa Ipi Hopena. ");
INSERT INTO rug_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Mamu la vekoa pa kenuna sa Ipi Hopena sa hope vina vukivukihi va uququana. ");
INSERT INTO rug_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Mamu la vekoa sa besini boronizi nomana pa vari korapana sa Ipi Hopena meke sa hope, mamu va siṉi nia kolo. ");
INSERT INTO rug_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Va turu sagea sa gobagoba poko lineni arilaena pa vari likohaena sa Ipi Hopena, mamu va sigotia sa poko goba pa nuqunuquruana sa gobagoba poko. ");
INSERT INTO rug_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Beto mamu va madi nia oela hopena tana vina madi sa ipi, meke sari doduru tiṉitoṉa tanisa, pude kaqu hopedi. ");
INSERT INTO rug_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Beto asa, si mamu va madi nia oela tana vina madi sa hope vina vukivukihi va uququana meke sari doduru tiṉitoṉana pude kaqu tava hope sisigiti si asa. ");
INSERT INTO rug_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Meke gua tugo, mamu va madia sa besini boronizi nomana meke sa tuturuanana. ");
INSERT INTO rug_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Beto asa mamu turaṉa mae nia se Eroni meke sari na tuna koreo pa sasadana sa Ipi Hopena, mamu huve va via i pude va madi. ");
INSERT INTO rug_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Mamu va sageni koe Eroni sari na poko hiama, mamu va madi nia oela batuna, pude mani nabulu Nau pa tinavete tana hiama. ");
INSERT INTO rug_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Mamu turaṉa maeni sari na tuna koreo, meke va sageni poko hiama. ");
INSERT INTO rug_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Beto, mamu va madi ni oela tana vina madi batudi, kekeṉoṉo gua tugo sapu va madi nia oela goi sa tamadia pude madi nabulu Nau pa tinavete tana hiama. Sa vina madidi oela pa batu hie si pude vata evaṉae ni na tuti hiama koari na sinage ninae rane ka rane.” ");
INSERT INTO rug_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Meke tavete betoi Mosese sari doduru tiṉitoṉa saripu tozi nia Zihova pude taveti. ");
INSERT INTO rug_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Ke pa rane vina keke koasa sidara kekenu, pa vuaheni vina rua, pa mudina sipu taluarae rini pa popoa Izipi, si tava turu sa Ipi Hopena te Zihova. ");
INSERT INTO rug_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Va haboti Mosese sari na vovoina, meke va turui sari na barabara, meke varihodaeni koari na huda pilipilivarata, meke tava turu sage sari na dedegere pude tavetia. ");
INSERT INTO rug_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Meke repahia sa sa poko lineni arilaedi koasa Ipi Hopena meke repahia tugo sa nobinobiana pa batuna sa Ipi Hopena gua puta tugo sapu ele tozi nia e Zihova koasa pude tavetia. ");
INSERT INTO rug_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Meke tiqe vagi sa sari karua patu labelabe, meke voi lani sa pa korapa Bokese Vinariva Egoi. Meke va lopoto lani sa sari na huda palepalekeana koari na riṉina sa bokese, meke vekoa sa sa tukutukuna koasa. ");
INSERT INTO rug_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Beto asa, si vekoa sa sa Bokese Vinariva Egoi pa korapa Ipi Hopena, meke va sigotia sa sa poko goba, pude va paeria sa bokese hopena, gua puta tugo sapu ele tozi nia e Zihova koasa. ");
INSERT INTO rug_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Beto meke va turua sa sa tevolo pa korapa Ipi Hopena pa kali gede, pa sadana sa poko goba pa korapana sa ipi. ");
INSERT INTO rug_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Meke vekoi sa sari na bereti sapu poni nia rini koe Zihova vasina, gua puta tugo sapu tozi nia e Zihova koasa. ");
INSERT INTO rug_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Meke la vekoa sa pa korapa Ipi Hopena sa tuturuana zuke pa kali mataona. Sa zuke meke sa tevolo pa karu kalina. ");
INSERT INTO rug_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Meke va katui sa vasina pa kenuna e Zihova sari na zuke gua puta tugo sapu tozi nia e Zihova koasa. ");
INSERT INTO rug_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Beto asa si la vekoa sa pa korapa Ipi sa hope qolo, pa kenuna sa poko goba, ");
INSERT INTO rug_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","meke va uqua sa sa oto huda humaṉa lea koasa, gua puta tugo sapu tozi nia e Zihova koasa. ");
INSERT INTO rug_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Meke va sigotia sa sa poko goba pa sasada nuqunuquruana tana Ipi Hopena. ");
INSERT INTO rug_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Meke pa kenuna sa poko goba vasina, si vekoa sa sa hope vina vukivukihi va uququana, meke va vukivukihini sa koasa sari na kurukuru meke va uqui sa sari na vinariponi huiti, gua puta tugo sapu tozi nia e Zihova koasa. ");
INSERT INTO rug_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Meke sa besini boronizi nomana si vekoa sa pa vari korapana sa ipi meke sa hope, meke va siṉi nia kolo sa. ");
INSERT INTO rug_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Mosese, Eroni meke sari na tuna Eroni si ṉuzapi sari limadi na nenedi vasina, ");
INSERT INTO rug_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","totoso nuquru la ri pa korapa Ipi Hopena, babe ene tata koasa hope gua puta tugo sapu tozi nia e Zihova koe Mosese pude taveti. ");
INSERT INTO rug_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Beto asa si va turu sagea Mosese sa gobagoba poko pa vari likohaena sa Ipi Hopena meke sa hope, meke va sigotia sa sa poko goba pa sasada nuqunuquruana tana gobagoba poko. Meke hokoto beto sari doduru tinavete. ");
INSERT INTO rug_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Beto asa si nobi tamunia na lei sa Ipi Hopena meke ṉedala vura mae se Zihova pa korapana sa Ipi, ");
INSERT INTO rug_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","ke lopu boka nuquru la koasa Ipi Hopena se Mosese. ");
INSERT INTO rug_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Meke sipu sage taloa sa lei koasa Ipi Hopena si boka rizu taloa sari na tie Izireli pa keke vasina. ");
INSERT INTO rug_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Ba pa totoso sapu koa sa lei vasina, si lopu boka rizu si arini. ");
INSERT INTO rug_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Koari doduru vuaheni saripu ta turaṉa sari na tie Izireli pa korapa qega si dogoria rini sa lei te Zihova pa batuna sa Ipi Hopena pana rane, meke na nika toana pa batuna sa ipi pana boṉi. ");
INSERT INTO rug_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Titiokia e Zihova se Mosese, meke zama ia Sa pa Ipi Hopena te Zihova, meke valani Sa koasa sari na vinarilulidi ri na tinarae, ");
INSERT INTO rug_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","pude kopuni ri na tinoni Izireli, totoso taveti rini sari na dia vina vukivukihi. Pana paleke la nia sa tie si keke kurukuru ṉame pude tana vina vukivukihi, si mani vizatia keke koari nana bulumakao, babe keke koari nana sipi, babe na qoti. ");
INSERT INTO rug_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Be keke koari nana bulumakao si vala nia sa pude tana va uququ, si kaqu vala nia sa si keke bulumakao kokoreo sapu loke ari kisakisana pa tinina; kaqu la vekoa sa si asa pa sasadana sa ipi pa kenuna e Zihova, pude qetu nia e Zihova si asa. ");
INSERT INTO rug_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Kaqu va opoa sa tie pa batuna sa kurukuru ṉame sa limana, meke kaqu ta qetue si asa, guana vina vukivukihi pude vulasa pani sari nana sinea. ");
INSERT INTO rug_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Sa bulumakao kokoreo si kaqu va matea sa vasina, meke sari na hiama tanisa butubutu te Eroni si kaqu paleke la nia sa ehara koe Zihova meke kaqu siburu la nia koari ka made kalikalina sa hope vina vukivukihiana sapu koa tata pa sasadana sa ipi. ");
INSERT INTO rug_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Beto hoi si kaqu kapua sa sa kurukuru, meke tiqe magumagua, ");
INSERT INTO rug_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","meke kaqu vekoveko va toṉoti ri na hiama sari na huda pa hope meke va katua sa nika. ");
INSERT INTO rug_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Meke kaqu va hakei rini pa nika sari na minagumagu kurukuru, sa batu, meke sa deana. ");
INSERT INTO rug_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Kaqu ṉuzapa va via ia sa korapana, meke sari na nenena, meke sa hiama si kaqu va uqu betoa sa vina vukivukihi pa hope. Na vina vukivukihi uququ si asa. Sa hibina sa vina vukivukihi hie si ta qetue koe Zihova. ");
INSERT INTO rug_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Pana vala nia keke tie si keke nana sipi babe na qoti, si kaqu na kokoreo sapu loke ari kisakisana pa tinina si asa. ");
INSERT INTO rug_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Pa kali gede koasa hope pa kenuna e Zihova si kaqu va matea sa si asa, meke kaqu siburu nia ri na hiama sa eharana koari ka made kalina sa hope. ");
INSERT INTO rug_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Sipu beto magumagua sa tie si asa, si kaqu va hakei sa hiama pa nika sari doduru kukurudi pu ele ta magudi, gua tugo sa batu meke sa deana. ");
INSERT INTO rug_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Meke kaqu ṉuzapa va viaia sa korapana, meke sari na nenena, meke kaqu la va vukivukihi nia sa hiama koe Zihova, meke kaqu va uqu betoi sa sari doduru pa hope. Na vina vukivukihi uququ si asa meke sa hibina sa vina vukivukihi hie si ta qetue koe Zihova. ");
INSERT INTO rug_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Be guana vala kurukuru tapuru si keke tie pude na nana vina vukivukihi va uququ si kaqu keke kukuva babe na baruku. ");
INSERT INTO rug_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Kaqu paleke la nia sa hiama pa hope si asa, liloho dopasia sa ruana, meke sulua sa batuna pa hope. Meke sari na eharana si kaqu va totolo vura lani sa pa kalina sa hope. ");
INSERT INTO rug_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Kaqu magu pania sa sa epepatana sapu koa pa ruana meke oki pania pa kali gasa rimata koasa hope, vasina koa sari na eba. ");
INSERT INTO rug_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Kaqu taṉinia sa tatapuruna meke daku ravaṉia sa tinina, ba lopu daku dopasi sari na tatapuruna, beto meke tiqe va uququa pa hope. Na vina vukivukihi va uququ si asa, meke sa hibina sa vina vukivukihi hie si ta qetue koe Zihova. ");
INSERT INTO rug_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Pana vala vinariponi huiti d koe Zihova si keke tie, kekenu si kaqu muzara va memehia sa sa huiti pude ta evaṉae na palava. Kaqu titisi vala nia oela olive meke taburu la nia sa oto huda humaṉa lea, ");
INSERT INTO rug_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","meke kaqu paleke la nia si keke sinara lima siṉina koari na hiama tanisa butubutu te Eroni, meke kaqu va uqui rini pa hope pude na vina gilagilana sapu ele ta vala beto si arini koe Zihova. Sa tivusuna sa vinariponi huiti hie si ta qetue koe Zihova. ");
INSERT INTO rug_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Sa kukuruna sa vinariponi huiti koa holana si tadi na hiama, tava hope hola si asa sina ta vagina koari na vinariponi ginani pu ta vala koe Zihova pa nika. ");
INSERT INTO rug_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Be na bereti ta kinana pa keke motumotuana, si kaqu loke isitina si asa. Kaqu na palava ta muzara va memehena sapu ta henie oela olive, babe bisikiti manivisidi pu ta ṉuzapae oela olive si arini. ");
INSERT INTO rug_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Be na vinariponi palava si ta kina koa keke peleta aeana labelabe, si kaqu ta tavete koasa palava memehena sapu henia oela olive si asa, meke loke isitina. ");
INSERT INTO rug_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Mamu va umumia sa bereti asa, mamu zoropo nia oela pana vala nia goi sa vinariponi asa. ");
INSERT INTO rug_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Be na bereti ta kinana koa keke vovoina bobolokuhae, sa vinariponi asa, si kaqu ta tavete pa palava memehena meke na oela olive si asa. ");
INSERT INTO rug_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Mu paleke la nia sa vinariponi hie koe Zihova, mamu la vala nia koasa hiama, meke asa kaqu paleke la nia pa hope si asa. ");
INSERT INTO rug_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Sa kukuruna si kaqu ta hena koasa hiama pude na vina balabalana sa vinariponi sapu ta vala beto koe Zihova, meke kaqu va uqua sa koasa hope. Sa hibina sa vinariponi ginani asa si ta qetue koe Zihova. ");
INSERT INTO rug_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Sari na vinariponi bereti sapu koa hola si tadi na hiama, tava hope hola si arini, sina ele ta vagi koasa ginani sapu ta vala koe Zihova. ");
INSERT INTO rug_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Loke vinariponi palava sapu ta vala koe Zihova si kaqu ta henie isiti; namu loke isiti d na zipale si kaqu heni nia gamu koasa ginani sapu kaqu vala nia gamu koe Zihova. ");
INSERT INTO rug_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Sa vinariponi tana vua kekenu sapu paketia gamu koari hopeke vuaheni si kaqu heni nia isiti na zipale, meke ta paleke la koe Zihova, ba lopu kaqu tava uqu si asa koasa hope pude humaṉa lea variva qetu koe Zihova. ");
INSERT INTO rug_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Veko ni soloti sari doduru vinariponi huiti sina sa soloti si na vina gilagilana sa vinariva egoi pa vari korapamu goi meke sa Tamasa. ");
INSERT INTO rug_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Totoso ta paleke la koe Zihova sari na huiti tana vua kekenu, si kaqu valani goi sari na kiko huiti ta kinadi meke tava umumudi. ");
INSERT INTO rug_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Mamu vala nia sa oela olive meke oto huda humaṉa lea koa Sa. Keke vinariponi huiti si asa. ");
INSERT INTO rug_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Sa hiama si kaqu va uqua, kukuruna sa huiti asa, pu koa ia na oela meke na oto huda humaṉa lea, pude guana keke vina balabalana sa vinariponi huiti sapu ta vala koe Zihova. ");
INSERT INTO rug_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Be keke tie vala nia si keke nana bulumakao pude na vina vukivukihi hinenahena binaere, be kokoreo babe na mamaqota ba namu loke ari kisakisana si asa. ");
INSERT INTO rug_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Kaqu va opo nia limana sa tie sa batuna sa kurukuru meke va matea pa sasadana sa Ipi Hopena pa kenuna Zihova. Meke sari na hiama pa butubutu te Eroni si kaqu siburu ni eharana sa vina vukivukihi koari ka made kalina sa hope. ");
INSERT INTO rug_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Meke kaqu va uququ i rini sari doduru deana pa korapana sa vina vukivukihi koasa hope, ");
INSERT INTO rug_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","sari karua leleqatana meke sari na deana pu koa koarini, meke sa kukuruna sa bero sapu leanana hola. ");
INSERT INTO rug_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Kaqu va uqu betoi ri na hiama pa hope sari doduru kukuru tini arini, meke va hake ulu lani koasa vina vukivukihi va uququ sapu koa pa hope, meke sa hibina sa vinariponi ginani si qetu nia e Zihova. ");
INSERT INTO rug_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Be hiva vala keke tie si keke sipi babe keke qoti pude na vina vukivukihi henahena binaere, be kokoreo ba be mamaqota si asa, ba kaqu loke ari kisakisana si asa. ");
INSERT INTO rug_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Be vala nia keke tie si keke sipi, si kaqu turaṉa la nia sa pa kenuna e Zihova, ");
INSERT INTO rug_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","meke kaqu va opo nia limana sa sa batuna, meke va matea sa pa kenuna sa Ipi Hopena. Meke sari na hiama si kaqu siburu ni sari na eharana koari ka made kalina sa hope. ");
INSERT INTO rug_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Meke kaqu va vukivukihi va uququ ni sa sari na kukurudi sari na kurukuru sara pude na ginani tana vinariponi koe Zihova saripu gua hire: sa deana, sa doduruna sa deana pa pikutuna sapu ta moku vagi taloa tata koasa suri mudi, meke sari doduru deana pa korapana sa, ");
INSERT INTO rug_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","sari karua leleqatana meke sari na deana pu koa koarini, meke sa kukuruna sa bero sapu leanana hola. ");
INSERT INTO rug_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Meke kaqu va uqui sa hiama pa hope sari doduru masa arini, pude na vinari poni ginani koe Zihova. ");
INSERT INTO rug_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Be vala nia keke tie si keke qoti koe Zihova, ");
INSERT INTO rug_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","si kaqu va opo nia limana sa sa batuna meke va matea pa kenuna sa Ipi Hopena. Sari na hiama si kaqu siburu ni sari na eharana koari ka made kalina sa hope. ");
INSERT INTO rug_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Meke kaqu va vukivukihi va uququ ni sa sari na tiṉitoṉa hire koe Zihova: sari doduru deana pa korapana sa vina vukivukihi, ");
INSERT INTO rug_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","sari karua leleqatana meke sari na deana pu koa koarini, meke sa kukuruna sa bero sapu leanana hola. ");
INSERT INTO rug_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Kaqu va uqui sa hiama sari doduru ginani arini pa hope, guana ginani pude va qetua se Zihova. Sari hibidi si va qetua se Zihova, meke sari doduru deana si Tanisa. ");
INSERT INTO rug_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Namu loke tie Izireli si kaqu hena deana babe na ehara; asa sa tinarae sapu kaqu ta kopue ninae rane ka rane koari doduru tie Izireli pa doduru vasina. ");
INSERT INTO rug_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Garunia Zihova se Mosese, ");
INSERT INTO rug_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","pude tozini sari na tinoni Izireli, be keke tie si lopu gilania sapu sea si asa ba tavete va sea tugo meke lopu va tabea si keke rina tinarae te Zihova, si kaqu luli sari na tinarae hire: ");
INSERT INTO rug_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Be sa ṉati hiama kenukenue si tavete va sea, meke ta goregorei nia rina tinoni, si kaqu vagia sa si keke bulumakao vaqurana sapu loke ari kisakisana pude na vina vukivukihi tana sinea, meke kaqu va vukivukihi la nia sa si asa koe Zihova pude taleosae sari nana sinea. ");
INSERT INTO rug_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Kaqu turaṉa la nia sa sa bulumakao pa sasadana sa Ipi Hopena pa kenuna e Zihova. Meke kaqu va opo nia limana sa sa batuna, meke va matea sa pa kenuna e Zihova. ");
INSERT INTO rug_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Meke kaqu vagi sa ṉati hiama kenukenue si kaiqa eharana sa bulumakao meke paleke nuquruni pa korapa Ipi Hopena. ");
INSERT INTO rug_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Kaqu poṉa la nia sa si keke kakarutuna pa ehara meke siburu la nia sa pa kenuna sa poko goba tukua sa lose hopena pa hopena ka zuapa totoso. ");
INSERT INTO rug_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Meke kaqu vekoi sa si kaiqa ehara koari na kikihona sa hope tana vina uququ humaṉa lea pa kenuna e Zihova. Kaqu titisi betoni sa sari na ehara, koa holadi pa hubina sa hope tana vina vukivukihi va uququ pa sasadana sa Ipi Hopena. ");
INSERT INTO rug_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Kaqu vagi sa koasa bulumakao hie sari doduru deana pa korapana sa vina vukivukihi tana sinea, ");
INSERT INTO rug_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","sari karua leleqatana meke sari na deana pu koa koarini, meke sa kukuruna sa bero sapu leanana hola. ");
INSERT INTO rug_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Kaqu vagia sa hiama sa deana meke va uqua koasa hope vina vukivukihi, pude tana vina vukivukihi va uququ, kekeṉoṉo gua sapu evaṉia sa koasa deana sapu ta vagi koasa kurukuru pu tava mate pude tana vina vukivukihi binaere koe Zihova. ");
INSERT INTO rug_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Ba kaqu vagia sa sa kapuna, doduru masana, na batuna, sari nenena, meke sa boguna na laguna, ");
INSERT INTO rug_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","meke kaqu paleke lani pa sadana sa vasina koa sari na tie koasa vasina viana pa dinoṉo te Zihova, vasina ta zoropae sari na eba tana vina vukivukihi. Meke vasina si kaqu va uqui sa si arini koasa nika koai na huda katudi. ");
INSERT INTO rug_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Be guana pada pude tava kilasa koe Zihova sa doduruna sa butubutu Izireli koasa keke sinea sipu sekea sa si keke koa ri na tinarae te Zihova meke lopu va nonoga ia rini, ");
INSERT INTO rug_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","be lopu sana ta gilana sa sinea, si kaqu paleke mae nia sa butubutu si keke bulumakao vaqurana pude na vina vukivukihina sa sinea meke kaqu turaṉa mae nia rini pa kenuna e Zihova koasa Ipi Hopena. ");
INSERT INTO rug_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Kaqu va opo nia limadi ri na koimata sa batuna, meke kaqu va matea rini vasina si asa. ");
INSERT INTO rug_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Sa ṉati hiama kenukenue si kaqu vagia sa eharana sa bulumakao, meke paleke nuquru la nia pa korapana sa Ipi Hopena. ");
INSERT INTO rug_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Meke noti la nia pa ehara sa kakarutuna meke siburu la nia sa pa kenuna sa gobagoba poko ka zuapa totoso. ");
INSERT INTO rug_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Kaqu vekoi sa si kaiqa ehara koari na kikihona sa hope tana vina uququ humaṉa lea pa kenuna e Zihova pa korapana sa Ipi, meke kaqu titisini sa saripu koa hola pa hubina sa hope tana vina vukivukihi va uququ sapu koa pa sadana sa Ipi Hopena. ");
INSERT INTO rug_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Meke kaqu vagi sa sari doduru deanana meke va uqui koasa hope vina vukivukihi. ");
INSERT INTO rug_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Kaqu tavete va kekeṉoṉo gunia sa sa bulumakao hie, gua sapu tavetia sa koasa bulumakao sapu sa vina vukivukihi tana tinaleosaedi rina sinea, meke koasa siraṉa gua asa si kaqu va vukivukihi ni sa sari na sinea tadi na tinoni meke kaqu taleosae si arini. ");
INSERT INTO rug_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Meke kaqu paleke la nia sa hiama sa bulumakao pa sadana sa vasina koa rina tie meke va uqua gua puta tugo sapu va uqua sa sa kukuru bulumakao sapu na vina vukivukihina sa nana sinea soti. Sa bulumakao hie si na vina vukivukihi pude taleoso nia sa sinea tanisa butubutu. ");
INSERT INTO rug_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Be keke koimata si lopu gilania sa sapu sea si asa, ba tavete va sea meke sekea sa si keke koari na tinarae te Zihova sa nana Tamasa, si pada tugo si asa pude tava kilasa koe Zihova. ");
INSERT INTO rug_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Totoso sapu gilania sa sa nana sinea, si kaqu paleke mae nia sa si keke qoti kokoreo sapu loke ari kisakisana. ");
INSERT INTO rug_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Kaqu va opoa sa sa limana pa batuna meke va matea pa kenuna e Zihova vasina pu hoke va matematei rini sari na vina vukivukihi vina uququ. Asa sa hinere pude vagi pania sa sinea. ");
INSERT INTO rug_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Kaqu noti lania sa hiama sa kakarutuna pa eharana sa kurukuru, meke veko lani koari na kikihona sa hope vina vukivukihi, meke saripu koa holadi si titisi lani sa pa hubina sa hope. ");
INSERT INTO rug_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Meke kaqu va uqui sa sari doduru deana pa hope, kekeṉoṉo gua tugo sari na kurukuru pu ele tava mate meke tava uqu deanadi pude na vina vukivukihi binaere koe Zihova. Pa siraṉa gua tugo asa si kaqu va vukivukihi nia sa hiama sa sinea tanisa koimata, meke kaqu taleosae si asa. ");
INSERT INTO rug_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Be keke koari na tie hokara si lopu gilania sa sapu tavete va sea si asa meke sekea sa si keke koari na tinarae te Zihova, ");
INSERT INTO rug_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","ba lopu sana si gilania sa sa nana sinea, si kaqu turaṉa mae nia sa si keke nana vina vukivukihi qoti mamaqota sapu loke ari kisakisana. ");
INSERT INTO rug_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Kaqu va opo nia limana sa sa batuna, meke kaqu va matea sa si asa pa vasina hoke tava mate sa vina vukivukihi va uququ. ");
INSERT INTO rug_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Kaqu poṉa ia sa hiama sa kakarutuna pa eharana sa kurukuru, meke vekoa sa sa eharana koari na kikihona sa hope, meke saripu koa holadi si titisi lani sa pa hubina sa hope. ");
INSERT INTO rug_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Meke kaqu va rizu pulei sa hiama sari doduru deanana, kekeṉoṉo gua sapu tava rizu pule koari na kurukuru pu tava mate pude na vinukivukihi tana binaere koe Zihova, meke kaqu va uqua sa pa hope meke sa hibina si variva qetu koe Zihova. Pa siraṉa gua asa si kaqu va vukivukihi nia sa hiama sa sinea tanisa tie, meke kaqu taleosae si asa. ");
INSERT INTO rug_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Be paleke mae nia sa tie si keke sipi pude na hinerena sa sinea, si kaqu na mamaqota sapu loke ari kisakisana si asa. ");
INSERT INTO rug_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Kaqu va opo nia limana sa sa batuna meke va matea sa koasa vasina hoke tava mate sa vina vukivukihi va uququna. ");
INSERT INTO rug_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Kaqu poṉa ia sa hiama pa eharana sa kurukuru sari kakarutuna, meke vekoa sa koari na kikihona sa hope, meke titisini sa saripu koa hola pa hubina sa hope. ");
INSERT INTO rug_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Meke kaqu va rizu pulei sa sari doduru deanana, kekeṉoṉo gua sapu tavetia sa koasa vina vukivukihi binaere sapu ta vala koe Zihova, meke kaqu va uqui sa, turaṉae koasa vina vukivukihi ginani sapu ta vala koe Zihova. Pa siraṉa gua asa si kaqu va vukivukihi nia sa hiama sa sinea tanisa tie, meke kaqu ta taleosae si asa. ");
INSERT INTO rug_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Ta hivae sari na vinukivukihi tana sinea pude luli sari na ginugua hire: Be keke tie si avosia sa tinioko pude tozi vura nia sa vina sosode pa vinaripitui, meke lopu boka tozi vura ni sa sari kaiqa ginugua saripu ele dogori sa babe avosi sa, si sea mo si asa. ");
INSERT INTO rug_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Be keke tie si tiqu hola ia si keke tiṉitoṉa sapu boni pa tinarae, guana keke kurukuru matena manavasadi babe pinomodi, meke na kurukuru ṉame matena, si boni meke sea tugo si asa. Ba be lopu gilania sa sapu gua tavetia sa sapu tiqua sa sa kurukuru matena, ba boni tugo si asa pa kenuna Zihova. ");
INSERT INTO rug_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Be keke tie si tiqu hola ia si keke tie babe na tiṉitoṉa bonina pa vina hinokara, si sea si asa. Sipu lopu sana gilania sa sapu gua ele tavetia sa si boni si asa. ");
INSERT INTO rug_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Be keke tie si tavete hoboria si keke zinama tokotokoro pa pozana Zihova, be pa ginugua leana babe lopu leana gua sapu zama nia sa, si sea mo si asa. Totoso hinoqa gilania sa sapu gua ele tavetia sa si pada tugo pude tava kilasa koe Zihova. ");
INSERT INTO rug_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Pana gilania keke tie sapu sea si asa pa keke siraṉa gua arini, si kaqu helahelae nia sa sa nana sinea, ");
INSERT INTO rug_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","meke pude taleosae nana meke loke vina kilasana sa nana sinea, si kaqu paleke mae nia sa koe Zihova si keke sipi mamaqota babe na qoti, pude na vina vukivukihi tana sinea. Sa hiama si kaqu tavetia sa vina vukivukihi tana sinea. ");
INSERT INTO rug_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Be keke tie habahuala si lopu boka holu vagia si keke sipi babe keke qoti pude na vina vukivukihi pa nana sinea, si kaqu paleke lani sa koe Zihova karua kukuva babe karua baruku. Keke si pude na vina vukivukihi tana sinea, meke keke si na vina vukivukihi va uququ. ");
INSERT INTO rug_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Kaqu paleke lani sa koasa hiama si arini, meke kaqu vala kenua sa sa kurukuru pude na vina vukivukihi tana sinea. Kaqu mokua sa hiama sa ruana ba lopu kaqu daku dopasia sa sa batuna. ");
INSERT INTO rug_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Meke kaqu vagi sa si kaiqa ehara meke siburu lani pa kalina sa hope, meke sari na ehara koa hola si kaqu tava totolo vura la pa hubina sa hope. ");
INSERT INTO rug_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Beto asa si kaqu ta vala sa kurukuru vina rua pude na vina vukivukihi va uququ, gua sapu ta zamae pa tinarae. Meke pa siraṉa gua asa, sa hiama si kaqu va vukivukihi nia sa sinea tanisa tie, meke kaqu taleosae si asa. ");
INSERT INTO rug_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Be guana lopu boka holui sa tie sari karua kukuva babe karua baruku, si kaqu paleke la nia sa palava memehena sapu keke kilo mamatana pude na vina vukivukihi tana sinea. Ba lopu kaqu heni nia oela olive babe na vina uququ humaṉa lea sina na vina vukivukihi tana sinea si asa. ");
INSERT INTO rug_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Kaqu paleke la nia sa koasa hiama, meke kaqu vagia sa hiama si keke sinara lima siṉina pude na vina gilagilana sapu ele ta vala beto koe Zihova si asa. Meke kaqu va uqua sa koasa hope si asa koari na vina vukivukihi vasina. Na vina vukivukihi tana sinea si asa. ");
INSERT INTO rug_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Pa siraṉa gua asa si kaqu tavetia sa hiama sa vina vukivukihina sa sinea tanisa tie meke kaqu ta taleosae si asa. Meke sari na palava koa holadi si tanisa hiama, kekeṉoṉo gua tugo sari na vinariponi huiti. ");
INSERT INTO rug_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Meke zama pule la se Zihova koe Mosese, ");
INSERT INTO rug_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Be keke koari na tie si lopu gilania sa sapu sea si keke tinavete ba tavete va sea meke sekea sa si keke koari na tinarae te Zihova, si kaqu turaṉa la nia sa si keke sipi kokoreo babe na qoti, sapu loke ari kisakisana. Sa laena si kaqu gua puta tugo sapu gotogoto pa vinizata tadi na hiama pa Ipi Hope. ");
INSERT INTO rug_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Kaqu lipua sa sa gale sapu lopu ele ade vala nia sa, meke kaqu tomo la nia sa ka hiokona puta paseniti sa laena sa sipi meke tabaria pa siliva si asa. Kaqu vala ni sa sari na poata meke sa kurukuru asa koasa hiama, meke kaqu va vukivukihi nia sa hiama sa kurukuru pude tana sinea tanisa tie, meke kaqu taleosae si asa. ");
INSERT INTO rug_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Be keke tie si lopu rovea meke vata evaṉia sa sa sinea, meke sekea sa si keke koari na tinarae te Zihova, si sea tugo si asa. Kaqu here nia sa sa nana sinea. ");
INSERT INTO rug_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Kaqu paleke mae nia sa tie koasa hiama si keke sipi kokoreo babe na qoti sapu loke ari vasi kisakisana pude na vina vukivukihi tinaleosaedi ri nana sinea, meke sa laena si kaqu gua puta tugo sapu gotogoto pa vinizata tadi na hiama pa Ipi Hope. Kaqu tavetia sa hiama sa vina vukivukihi tana sinea. Be guana lopu rovea meke vata evaṉia sa tie sa sinea, ba kaqu tava vukivukihi nia tugo sa meke kaqu tiqe ta taleosae si asa. ");
INSERT INTO rug_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Asa sa hinerena sa sinea sapu evaṉia sa tie meke lopu qetu nia e Zihova.” ");
INSERT INTO rug_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Zama koe Mosese se Zihova, ");
INSERT INTO rug_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Keke hinerehere si kaqu ta tavete, be keke tie si va karia se Zihova meke korona va pulea sa si keke tiṉitoṉa tanisa turaṉana, sapu kopu vala nia sa, babe hikoa sa si keke tiṉitoṉa koasa, babe sekesekei nia sa si asa, ");
INSERT INTO rug_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","babe zama kokoha nia sa tie si keketoṉa sapu ele va muliuṉia sa, meke zama tokotokoro nia sa sapu lopu dogoria sa si asa, gua. ");
INSERT INTO rug_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","5","Pana tavete va sea sa tie koari na siraṉa gua arini, si kaqu lipua sa sapu gua ele vagia sa pa nana hahanana kokoha. Koasa rane sapu ta dogoro vura sa nana sinea, si kaqu lipu pulea sa sa doduruna sa nana gale koasa tie pu ari nana, meke kaqu tomo nia ka hiokona puta paseniti sa. ");
INSERT INTO rug_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Meke kaqu paleke la nia sa koasa hiama si keke sipi kokoreo babe na qoti sapu loke hite ari kisakisana pude na nana vina vukivukihi koe Zihova. Sa laena si kaqu gua puta tugo sapu gotogoto pa vinizata tadi na hiama pa Ipi Hope. ");
INSERT INTO rug_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Kaqu va vukivukihi nia sa hiama sa sinea tanisa tie, meke kaqu tiqe taleosae si asa. ");
INSERT INTO rug_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Tozi nia Zihova se Mosese, ");
INSERT INTO rug_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","pude valani koe Eroni meke sari na tuna koreo sari na tinarae hire tana vina uququ. Sa vina uququ si kaqu ta veko pa hope koasa doduruna sa boṉi, meke lopu kaqu tava makudo toa sa nika. ");
INSERT INTO rug_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Sa hiama sapu va sagena sa nana poko lineni doduruna meke sari na poko lineni korapae, si kaqu va rizu pulei sari na eba tanisa vina vukivukihi uququna pu koa koasa hope, meke la vekoi pa kalina sa hope. ");
INSERT INTO rug_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Beto asa si kaqu hobei sa sari nana poko, meke la vagi sa sari na eba meke paleke lani pa sadana sa vasina sapu koa ia rina tie sapu ele tava madina. ");
INSERT INTO rug_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Sa nika pa hope si lopu kaqu hite ari makudo toana, meke lopu kaqu tava mate si asa. Doduru munumunu si kaqu vala nia huda sa hiama si asa, meke veko valeani sari na vina vukivukihi uququ vasina, meke va uqui sari na deana tadi na vina vukivukihi binaere vasina. ");
INSERT INTO rug_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Sa nika si lopu kaqu makudo toa koasa hope, meke lopu kaqu tava mate. ");
INSERT INTO rug_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Sari na tinarae hire si tadi na vinariponi huiti. Sa hiama sapu tuti gore mae koe Eroni si kaqu vala nia sa vinariponi huiti koe Zihova pa kenuna sa hope. ");
INSERT INTO rug_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Kaqu taṉini va siṉi nia palava memehena na oela sa sa limana, sapu koa ia na oto huda vina uququ humaṉa lea, meke kaqu va uqua sa pa hope; pude na vina gilagilana sapu doduruna sa palava asa si ta vala koe Zihova. Sa hibina sa vinariponi hie si qetu nia e Zihova. ");
INSERT INTO rug_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","17","Sa palava lopu ta suluna sapu koa hola si kaqu henai rina hiama. Sa bereti loke isitina asa si kaqu ta kina meke ta hena pa lose hopena koasa pavasa tana Ipi Hopena pa kenuna e Zihova. Sa ginani asa si ta poni nia rina hiama koe Zihova, kukuruna sa dia vinariponi ginani si asa. Hopena hola si asa, gua tugo rina vina vukivukihi tana sinea, meke hinerena sa sinea. ");
INSERT INTO rug_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Koari doduru totoso mae hiroi, be keke rina koreo pu tuti gore mae gua koe Eroni si boka hena ia si asa, guana gedi ginani mo sapu ta poni nia rini koe Zihova doduru rane. Be keke tie pule sapu tiqua sa ginani pu ta poni nia rini si kaqu hopena tugo si asa. ");
INSERT INTO rug_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Sari na tinarae hire si valani e Zihova koe Mosese, ");
INSERT INTO rug_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","pude tana vina madina sa hiama Eroni meke sari na tuna pu tuti gore mae gua koasa. Koasa rane sapu tava madi si arini, si kaqu vekoa si keke kilo mamata palava memehena sapu kekeṉoṉo gua sapu na vinariponi huiti hopeke rane koe Zihova; kukuruna tana munumunu meke kukuruna tana veluvelu. ");
INSERT INTO rug_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Kaqu ta qaliri henie oela meke ta kina koa keke peleta aeana labelabe, meke tiqe umumu va hitehiteki, meke la vekoa pude sa hibina sa vinariponi hie si qetu nia e Zihova. ");
INSERT INTO rug_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Koari doduru totoso mae hiroi, sa vinari poni hie si kaqu ta tavete koari doduru pu tuti gore mae gua koe Eroni, sarini pu tavetia sa tinavete tana ṉati hiama kenukenue. ");
INSERT INTO rug_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Loke vasi vinariponi sapu tavetia sa hiama si kaqu ta hena; sari doduru si kaqu tava uqu upata beto. ");
INSERT INTO rug_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Zama ia Zihova se Mosese, ");
INSERT INTO rug_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","pude valani koe Eroni meke sari na tuna koreo sari na tinaraedi rina vina vukivukihi tadi na sinea hire: Sa vina vukivukihi tana sinea si kaqu tava mate pa kali gedena sa hope, vasina hoke va matei rini sari vina vukivukihi va uququ. Na vina vukivukihi hopena hola si asa. ");
INSERT INTO rug_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Kaqu hena ia sa hiama sa vina vukivukihi uququ asa pa keke vasina hopena koasa pavasa tana Ipi Hopena pa kenuna e Zihova. ");
INSERT INTO rug_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Be keke tie babe keketoṉa sapu lopu hopena si tiqua sa masana sa kurukuru, si kaqu hopena tugo si asa. Be kasuria ehara kurukuru si keke poko si kaqu ta popaha va via pa keke vasina hopena si asa. ");
INSERT INTO rug_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Be ta raro va qototo sa masana koa keke raro patu, si kaqu ta poraka si asa, babe keke raro aeana si ta rararoe, si kaqu ta ṉuzapa meke va via nia kolo si asa, ");
INSERT INTO rug_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Doduru koreo koari na tatamana hiama si boka hena ia sa masa sana sina hopena si asa. ");
INSERT INTO rug_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Ba be ta paleke nuquru la pa korapa Ipi Hopena sa eharana sa vina vukivukihi tana sinea pude ta taleosae sa sinea, si loke tie si boka hena ia sa masana sa kurukuru sana ba kaqu tava uqu palae. ");
INSERT INTO rug_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Hire sari na tinarae tanisa vina vukivukihi vina toṉoto gale tana sinea, sapu hopena hola. ");
INSERT INTO rug_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Sa kurukuru pude tanisa vina vukivukihi vinatoṉoto gale si kaqu tava mate pa kali gede koasa hope, vasina hoke tava mate sa kurukuru tanisa vina vukivukihi va uququ. Sari na eharana sa kurukuru tanisa vina vukivukihi vina toṉoto gale si kaqu ta siburu la koari ka made kalina sa hope. ");
INSERT INTO rug_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Sari doduru deana si kaqu tava uqu beto koasa hope: sari na deana pa pikutuna meke sari doduru deana pa korapana, ");
INSERT INTO rug_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","sari karua leleqatana meke sari na deana pu koa koarini, meke sa kukuruna sa bero sapu leanana hola. ");
INSERT INTO rug_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Kaqu va uqui sa hiama sari doduru deana koasa hope pude na vina vukivukihi la koe Zihova. Na vina vukivukihi vina toṉoto gale tana sinea si asa. ");
INSERT INTO rug_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Doduru koreo pa butubutu hiama si boka hena ia si asa, ba kaqu ta hena koa keke vasina hopena, sina hopena hola si asa. ");
INSERT INTO rug_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Keke tinarae si soto beto la gua koasa vina vukivukihi tana sinea meke sa vina vukivukihi tana vina toṉoto gale: Sa masa si tanisa hiama sapu tavetena sa vina vukivukihi. ");
INSERT INTO rug_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Sa kapuna sa kurukuru sapu ta vala koasa vina vukivukihi va uququ si tanisa hiama tugo sapu tavetena sa vina vukivukihi. ");
INSERT INTO rug_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Sari doduru vinariponi huiti saripu ta kina koasa kinakinana, babe keke peleta aeana labelabe, si tanisa hiama pu palekena si asa, meke la vala nia koe Tamasa. ");
INSERT INTO rug_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Ba sari doduru vinariponi huiti lopu kinadi, be ta henie oela babe popa si kaqu tadi doduru hiama pu tuti gore mae gua koe Eroni. Kaqu tava hia vari ṉoṉoi koarini si arini. ");
INSERT INTO rug_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Sari na tinarae hire si tana vina vukivukihi binaere pu ta veko koe Zihova. ");
INSERT INTO rug_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Be keke tie si tavetia sa vina vukivukihi hie pude na zinama valeana koe Tamasa, si kaqu veko turaṉa nia bereti loke isitina; kaqu na bereti moatana sapu ta henie oela olive, babe na bisikiti manivisidi pu ta ṉuzapae oela olive, babe na bereti sapu ta tavete pa palava sapu ta muzara valeana, henia oela olive. ");
INSERT INTO rug_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Meke sipu tavetia sa sa nana vina vukivukihi binaere pude zama leana koe Zihova si kaqu veko turaṉae lani sa sari na bereti pu ta kina henie isiti. ");
INSERT INTO rug_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Keke koari hopehopeke ka made bereti arini si kaqu vekoa sa pude na ṉati vinari poni te Zihova, meke tanisa hiama pu siburu la nia sa eharana sa vina vukivukihi binaere pa hope. ");
INSERT INTO rug_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Sa masana sa kurukuru si kaqu ta hena koasa rane pu ta tavete sa vina vukivukihi binaere, meke loketoṉa si kaqu koa hola osolae kamoa munumunu. ");
INSERT INTO rug_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Be paleke mae nia keke tie si keke vina vukivukihi binaere, pude na vina gorevurana sa zinama tokotokoro koe Zihova, babe sa nana vinariponi moka telena, si kaqu ta hena koasa rane sapu ta veko si asa; ba be kaiqa mo si koa hola si boka ta hena tugo koasa rane sapu luli mudi mae. ");
INSERT INTO rug_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Be guana kaiqa masa si koa hola koasa rane vina ṉeta si kaqu ta sulu palae. ");
INSERT INTO rug_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Be kaiqa masa tanisa vina vukivukihi binaere asa si ta hena koasa rane vina ṉeta si lopu kaqu ta qetue koe Tamasa sa vinariponi tanisa tie. Sa laena sa nana vinariponi si lopu kaqu ta balabalae, ba kote ta pozae lopu viana, meke asa sapu hena ia, si kaqu tava kilasa koe Zihova. ");
INSERT INTO rug_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Be ta tiqu sa masa koa keke tiṉitoṉa sapu bonina pa dinoṉo te Zihova si lopu kaqu ta hena si asa, ba kaqu ta sulu palae. Ba asa sapu via pa vina madi tana tinarae te Zihova si kaqu somana henahena si asa. ");
INSERT INTO rug_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Ba be lopu via sa tie meke hena ia sa sa masa tanisa vina vukivukihi binaere si namu lopu kaqu koa hola koari na puku tie Izireli si asa. ");
INSERT INTO rug_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Be keke tie ele tiqua sa si keke tiṉitoṉa bonina pa dinoṉo te Zihova, be keke tie babe keke kurukuru; meke mudina sa si hena ia tugo sa sa masa vina vukivukihi binaere koe Zihova, si namu lopu kaqu koa hola koari na puku tie Izireli si asa.” ");
INSERT INTO rug_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Meke zama pulea Zihova se Mosese, ");
INSERT INTO rug_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Loke deana bulumakao na sipi babe na qoti si kaqu ta hena. ");
INSERT INTO rug_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Sa deanana sa kurukuru sapu ele matena, babe tava mate koa keke kurukuru pinomo, si lopu kaqu ta hena, ba kaqu ta tavetavetae pa kaiqa ginugua pule. ");
INSERT INTO rug_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Be keke tie si hena ia sa deanana sa keke kurukuru, sapu hoke ta veko pude na vina vukivukihi koe Zihova, si namu lopu kaqu koa hola koari na tie Izireli si asa. ");
INSERT INTO rug_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Pa doduru vasina pu koa gamu na tie Izireli vugo na repere si lopu kaqu hena ia gamu sa ehara kurukuru. ");
INSERT INTO rug_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Be keke ri na tie si sekea sa tinarae hie, si namu lopu kaqu koa hola koari na tie Izireli si asa.” ");
INSERT INTO rug_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Meke zama guahe se Zihova koe Mosese, ");
INSERT INTO rug_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Mamu tozini sari na tie Izireli, ‘Asa sapu vekoa sa kurukuru vina vukivukihi binaere, si kaqu paleke mae nia sa sa kukuruna pude keke ṉati vinariponi arilaena koe Zihova. ");
INSERT INTO rug_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Kaqu palekia sa pa limana soti sa vinariponi asa. Kaqu palekia sa sa deanana, meke sa masa raqaraqana sa kurukuru ṉame meke la sipusipu lania sa masa raqaraqana sa kurukuru pude na ṉati vinariponi arilaena koe Zihova. ");
INSERT INTO rug_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Kaqu va uqua sa hiama sa deana koasa hope, ba sa masa raqaraqana si kaqu tadi na hiama. ");
INSERT INTO rug_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Sa pudapuda nene mataona sa kurukuru ṉame si kaqu ta veko pude keke ṉati vinariponi arilaena ");
INSERT INTO rug_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","koasa hiama sapu vekona sa ehara meke sa deana tana vina vukivukihi. ");
INSERT INTO rug_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Sa masa raqaraqana meke sa pudapuda nene mataona sa kurukuru ṉame, si na ṉati vinariponi arilaedi, sapu vagi e Zihova koari na tinoni Izireli pude tadi na hiama. Kaqu ta vala koari na hiama doduru totoso koari na rane mae hiroi.’ ” ");
INSERT INTO rug_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Asa sa kukuruna sa ginani tadi Eroni meke sari tuna koreo saripu ta vala koe Zihova koasa rane sipu tava madi sari na hiama. ");
INSERT INTO rug_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Koasa rane sana si tozini e Zihova sari na tinoni Izireli pude vala nia koarini sa kukuru hinia asa. Asa sa tinarae sapu kaqu va tabea ri na tinoni Izireli doduru totoso koari na rane mae hiroi. ");
INSERT INTO rug_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Arini sari na tinarae tadi na vina vukivukihi va uququ, na vinariponi huiti, na vina vukivukihi tana sinea, na vina vukivukihi vina toṉoto gale, na vina vukivukihi tana vina madi, na vina vukivukihi binaere. ");
INSERT INTO rug_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Koasa rane sipu tozini Mosese sari na tinoni Izireli pude taveti sari na dia vinariponi na vina vukivukihi, si valani e Zihova koe Mosese pa toqere Saenai pa korapa popoa qega sari na tinarae arini. ");
INSERT INTO rug_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Zama koe Mosese se Zihova, ");
INSERT INTO rug_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Mu turaṉa la nia pa sasadana sa Ipi Hopena pa kenuqu Rau se Eroni meke sari na tuna koreo; paleki sari na poko hiama na oela vina madi, meke sa bulumakao kokoreo pude na vina vukivukihi tana sinea, karua sipi kokoreo meke sa huneke bereti sapu loke isitina; ");
INSERT INTO rug_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","mamu tioko varigara nia vasina sa doduru butubutu Izireli.” ");
INSERT INTO rug_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Tavetia Mosese sapu zama nia e Zihova koasa, meke sipu varigara sa butubutu, ");
INSERT INTO rug_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","si zama koarini si asa, “Kaqu tavetia rau kamahire gua sapu ele tozi nau e Zihova.” ");
INSERT INTO rug_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Turaṉa lani e Mosese pa kenudia sari Eroni meke sari na tuna koreo meke huvei sa. ");
INSERT INTO rug_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Va sage nia na poko keoro doduru meke keke poko gele sa se Eroni meke dokoho pule nia pule keke poko dokoho, meke keke poko tana hiama sapu ta pitie vinasari meke pusi nia pa kopetena. ");
INSERT INTO rug_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Va sage nia sa sa poko raqaraqa, meke vekoi sa sari karua tiṉitoṉa hitekedi sapu ta pozae Urimi meke Tumimi pa korapana sa. ");
INSERT INTO rug_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Va sage nia sa sa toropae batu tana hiama pa batuna meke pa kenuna si pusi nia sa sa vina gilagila qolo madina, gua puta tugo sapu tozi nia e Zihova koasa. ");
INSERT INTO rug_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Beto asa si vagia Mosese sa oela vina madi, meke la va madia sa Ipi Hopena meke sari doduru tiṉitoṉa pu ele koa pa korapana; meke pa siraṉa gua asa si va madi sa koe Zihova sari doduru. ");
INSERT INTO rug_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Vagi sa sari kaiqa oela meke siburu lani sa ka zuapa totoso koasa hope vina vukivukihi, meke sari na tiṉitoṉa tavetaveteana meke koasa besini boronizi nomana meke sa hubina sa hope ka zuapa totoso. Pa siraṉa gua asa si va madi lani sa koe Zihova si arini. ");
INSERT INTO rug_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Kaiqa oela si zoroponi sa pa batuna e Eroni meke va madia sa si asa. ");
INSERT INTO rug_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Beto asa si turaṉa lani Mosese sari na tuna koreo e Eroni meke va sageni poko keoro doduru sa si arini, dokohoni poko lineni sa, meke va sage ni toropae batu tana hiama sa, gua puta tugo sapu zama nia e Zihova. ");
INSERT INTO rug_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Beto asa si paleke mae nia e Mosese sa bulumakao vaqurana pude na vina vukivukihi tana sinea. Se Eroni meke sari na tuna koreo si va opoi limadi koasa batuna. ");
INSERT INTO rug_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Va matea Mosese si asa meke vagi sa si kaiqa eharana meke va boboso nia ehara sa sa kakarutuna meke va honi lania sa koari ka made kikihona sa hope pude va madia. Sari na ehara koa holadi si zoropo ni sa pa hubina sa hope. ");
INSERT INTO rug_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Vagi Mosese sari doduru deana pa korapa tinina, sa kukuruna sa bero sapu leanana hola, sari na leleqata meke sari na deana pu koa koa rini, meke va uqu betoi pa hope. ");
INSERT INTO rug_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Vagi sa sari kaiqa toṉana sa bulumakao kokoreo koa holadi meke na kapuna, na masana, meke sari na laguna, meke va uqui sa pa valena sa vasina pu koa sari na tie, gua puta tugo sapu zama nia e Zihova. ");
INSERT INTO rug_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Beto asa si turaṉia Mosese sa sipi kokoreo tana vina vukivukihi va uququ la koe Eroni, meke va opoi Eroni meke sari na tuna koreo sari na limadia pa batuna. ");
INSERT INTO rug_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Va matea Mosese si asa meke siburu beto la nia sa sa eharana koari ka made kalina sa hope vina vukivukihi. ");
INSERT INTO rug_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","21","Magumagu va hitehitekia sa sa sipi kokoreo, ṉuzapa va via i sa sari na tiṉitoṉa pa korapana meke sari na nenena, meke va uqua sa sa batuna, na deanana meke sari doduru tinina pa hope, gua puta tugo sapu zama nia e Zihova. Sa vina vukivukihi va uququ hie sina vinariponi koe Zihova, meke sa hibi lea tanisa si variva qetu koa Sa. ");
INSERT INTO rug_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Beto asa, si turaṉa mae nia e Mosese sa sipi kokoreo vina rua pude va madi sari na hiama; sapu se Eroni, meke sari na tuna koreo si va opoi pa batuna sari na limadia. ");
INSERT INTO rug_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Va matea Mosese si asa meke vagi sa si kaiqa eharana meke vekoi sa koasa hubi taliṉa mataona e Eroni, meke koasa gugulavata pa kali lima mataona, meke koasa gugulavata pa kali nene mataona. ");
INSERT INTO rug_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Beto asa, si turaṉa maeni sa sari na tuna koreo e Eroni meke vekoi sa si kaiqa ehara koari na boboa taliṉa mataodi, meke koari na gugu lima mataodi, meke gua tugo koari na gugulavata pa kali nene mataodi. Beto asa, si siburu beto lani e Mosese sari na ehara koa holadi koari ka made kalina sa hope. ");
INSERT INTO rug_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Vagia sa sa deana, deana pa pikutuna, meke sari doduru deana saripu nobi tamuni sari na laguna, meke sa kukuruna sa bero leanana hola, meke sari na leleqata meke sari na deana pu koa koarini, meke sa pudapuda nene mataona, ");
INSERT INTO rug_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","beto hoi si vagia sa si keke bereti sapu loke isitina koasa huneke sapu ele tava madina koe Zihova, keke keki sapu ta henie oela, meke keke bisikiti manivisina, meke va hakei sa koasa pudapuda nene mataona, meke koari na deanana. ");
INSERT INTO rug_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Beto asa si va taṉini ni sa koa rina limana Eroni meke koari na tuna koreo sari doduru ginani hire, beto asa si ovulu sage ni rini pude na ṉati vinariponi sapu kaqu vala nia rini koe Zihova. ");
INSERT INTO rug_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Beto asa, si vagi Mosese sari na ginani koa rini, meke va uqui sa koasa vina vukivukihi va uququ pa batuna sa hope, na vina madidi ri Eroni meke sari na tuna koreo. Meke sa hibi lea tanisa si qetu nia e Zihova. ");
INSERT INTO rug_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Beto asa, si vagia Mosese sa masa raqaraqana meke vala nia pude na vinariponi koe Zihova. Asa tugo sa kukuruna sa vinariponi sipi kokoreo sapu te Mosese. Tavete va gorevura betoi Mosese sari doduru gua pu zamani e Zihova koasa. ");
INSERT INTO rug_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Vagi Mosese sari kaiqa oela meke kaiqa ehara sapu koa pa hope, meke siburu lani koe Eroni meke sari na tuna koreo, meke koari na dia poko tugo. Pa siraṉa gua asa si va madi sa si arini koe Zihova. ");
INSERT INTO rug_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Zama la koe Eroni meke sari na tuna koreo se Mosese, “Mi vagia sa masa meke paleke la nia pa sasadana sa Ipi Hopena pa kenuna e Zihova, mamu raro va qototia, mi hena turaṉae nia sa bereti, sapu koana pa huneke, sapu na vinariponi tana vina madi, gua puta tugo sapu zama nia e Zihova. ");
INSERT INTO rug_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Beto asa si mi va uqu pani sari na masa babe na bereti saripu koa hola. ");
INSERT INTO rug_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Lopu kaqu luaria gamu sa sasadana sa Ipi Hopena koari ka zuapa rane, osolae hokoto sa mia vina madi koe Zihova. ");
INSERT INTO rug_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Gua sapu tavetia gita pa rane ṉinoroi, si gua puta tugo sapu ele zama nia e Zihova koa gita pude tavetia, pude boka taleosae sari na mia sinea. ");
INSERT INTO rug_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Kaqu koa mo si gamu pa sasadana sa Ipi Hope, pana rane meke boṉi koari ka zuapa rane, meke taveti mo sapu gua zamani e Zihova. Be lopu tavete gua asa si gamu, si kaqu mate si gamu. Ura arini tu si zamani e Zihova koa rau.” ");
INSERT INTO rug_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Gua asa ke taveti Eroni meke sari na tuna koreo sari doduru ginugua pu zamani e Zihova koe Mosese. ");
INSERT INTO rug_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Koasa rane vina vesu pa mudina sa vina madi hiama, si tiokia Mosese se Eroni, meke sari na tuna koreo, meke sari na koimata tadi na tinoni Izireli. ");
INSERT INTO rug_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Zama si asa koe Eroni, “Mu vagia si keke bulumakao kokoreo vaqurana meke keke sipi kokoreo sapu loke ari kisakisadi; mamu va vukivukihi ni koe Zihova. Sa vina vukivukihi bulumakao kokoreo vaqurana si tana sinea, meke sa sipi kokoreo si tana vina vukivukihi va uququ. ");
INSERT INTO rug_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Beto asa si mamu tozini sari na tinoni Izireli pude vagia si keke vina vukivukihi qoti kokoreo pude tana sinea, keke bulumakao keke vuahenina, meke keke tuna sipi keke vuahenina, saripu loke ari kisakisadi, pude na vina vukivukihi va uququ, ");
INSERT INTO rug_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","meke keke bulumakao kokoreo meke keke sipi kokoreo si pude na vina vukivukihi binaere. Kaqu va vukivukihi lani rini koe Zihova si arini; turaṉae koasa vinariponi huiti sapu henia na oela. Kaqu tavetia rini sapu gua asa, sina kote vura koa rini se Zihova pa rane ṉinoroi.” ");
INSERT INTO rug_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Paleke lani rini pa kenuna sa Ipi Hopena sari doduru pu tozi e Mosese, meke varigara vasina sari doduru tinoni pude vahesia se Zihova. ");
INSERT INTO rug_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Zama se Mosese, “Se Zihova tozini gamu pude taveti sari doduru pu gua hire, pude kaqu ṉedala vura mae si Asa koa gamu.” ");
INSERT INTO rug_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Beto asa si zama koe Eroni si asa, “Mamu la koasa hope, mamu va vukivukihi nia sa vina vukivukihi tana sinea, meke sa vina vukivukihi vina uququ, pude taleosae sari na mia sinea, meke sari na sinea tadi doduru tie. Mi tavetia sa vina vukivukihi hie pude vagi taloa sari na sinea tadi na tinoni, gua puta tugo sapu zama nia e Zihova.” ");
INSERT INTO rug_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","La pa hope se Eroni, meke va matea sa sa bulumakao kokoreo vaqurana, pude na vina vukivukihi tanisa nana sinea soti. ");
INSERT INTO rug_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Paleke lani ri na tuna koreo sari na eharana koe Eroni, poṉa ia sa sa kakarutuna pa ehara, meke vekoi sa sari na ehara koari na kikihona sa hope, meke zoroponi sa saripu koa hola pa hubina sa hope. ");
INSERT INTO rug_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Beto asa si va uqua sa pa hope sa deanana, sari leleqatana, meke sa kukuruna sa bero leanana hola, gua puta tugo sapu tozia e Zihova koe Mosese. ");
INSERT INTO rug_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Ba va uqua sa sa masa koa holana, meke sa kapuna si va uqui sa pa valena sa vasina pu koa sari na tie. ");
INSERT INTO rug_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Beto asa si va matea e Eroni sa kurukuru pude tanisa nana vina vukivukihi va uququ soti. Sari na tuna koreo si paleke mae nia koasa sa eharana meke siburu lani sa koari ka made kalina sa hope. ");
INSERT INTO rug_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Vala nia rini koasa sa batuna, meke sari kaiqa pule kukukuruna sa kurukuru ṉame, meke va uqui sa si arini pa hope. ");
INSERT INTO rug_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Beto asa si ṉuzapa va via i sa sari na tiṉitoṉa pa korapa tinina meke sari na nenena meke va uqui sa pa hope, va hake ulue i sa si arini koasa vina vukivukihi va uququ pa hope. ");
INSERT INTO rug_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Beto sana si valani sa sari na vina vukivukihi tadi na tinoni. Vagia sa sa qoti pude na vina vukivukihi, va matea sa, meke vala nia sa si asa, gua puta tugo sapu tavetia sa koasa vina vukivukihi tanisa nana sinea soti. ");
INSERT INTO rug_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Turaṉa mae nia tugo sa sa kurukuru ṉame, pude na vina vukivukihi va uququ, meke vala nia sa sa vina vukivukihi gua sapu ta tozi pa tinarae. ");
INSERT INTO rug_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Vagi sa sari na vinariponi huiti, taṉini va siṉi nia palava sa sa kali limana, vekoi sa, meke va uqui pa hope. Na tomona sa vina vukivukihi va uququ pa hopeke rane sapu ele koa pa hope. ");
INSERT INTO rug_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Va matea sa sa bulumakao kokoreo meke sa sipi kokoreo, pude na vina vukivukihi binaere koe Zihova tadi na tinoni. Sari na tuna koreo si paleke mae nia koasa sa ehara meke siburu lani sa koari ka made kalina sa hope. ");
INSERT INTO rug_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Ba sari na deanana sa bulumakao kokoreo meke sa sipi kokoreo: sa deana pa pikutuna, deana saripu nobi sari na lagudi, sari na leleqatadi, meke sa kukuruna sa bero leanana, ");
INSERT INTO rug_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","si ta veko hake ulue, koari na masa raqaraqadi rina kurukuru ṉame, meke paleke beto lani sa koasa hope. Va uqu betoi sa sari na deana koasa hope, ");
INSERT INTO rug_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","meke ovulu sage ni sa sari na masa raqaraqadi meke sa pudapuda nene kali mataona, pude na ṉati vinariponi arilaedi te Zihova koari na hiama, gua puta tugo sapu tozia e Mosese. ");
INSERT INTO rug_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Sipu va hokoti Eroni sari doduru vina vukivukihi tana sinea, vina uququ, meke tana binaere koe Zihova, si va sagei sa sari na limana panaulu koari na tinoni meke manani sa si arini. Beto asa si gore mae gua koasa hope si asa. ");
INSERT INTO rug_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Mosese meke Eroni si nuquru la pa korapa Ipi Hopena pa kenuna e Zihova; meke sipu vura si arini, si manani rini sari na tinoni, meke sa ṉinedalana sa kalalasana e Zihova si vura mae koari doduru tie. ");
INSERT INTO rug_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Hinoqa garunia Zihova sa nika meke sulu betoa Sa sa vina vukivukihi va uququ, meke sari na kukukuru deana koasa hope. Sipu dogoria ri na tinoni sapu gua asa, si velavela beto sari doduru, meke hoqa oporapaha rini pa pepeso. ");
INSERT INTO rug_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Hopeke vagi rina tuna koreo e Eroni, ari Nadabi meke Abihu, sari karua vovoina nika meke vekoni motete toadi, tomo lani oto huda humaṉa lea, meke valani koe Zihova. Ba sa nika hie si lopu madina, sina lopu tozia e Zihova koarini pude valani. ");
INSERT INTO rug_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Hinoqa garunia e Zihova sa nika, meke sulu va matei vasina pa kenuna e Zihova si arini. ");
INSERT INTO rug_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Beto sapu gua asa, si zama koe Eroni se Mosese, “Asa sa guguana sapu ele zama nia e Zihova, ‘Koarini pu nabulu Nau si kaqu vata dogoro nia sapu Hopequ si Rau; kaqu tava lavata si Rau koari Qua tinoni!’ gua.” Ba lopu zama nia Eroni si keketoṉa. ");
INSERT INTO rug_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Tiokia Mosese se Misaelo meke se Elozapani; sari na tuna koreo e Uzieli, sapu sa buhina e Eroni, meke zamai sa si arini, “Mae tani mamu paleke va seui sari na tinidia ri na tasimia karokarovo koasa Ipi Hopena, mamu la vekoi pa valena sa vasina koa sari na tie.” ");
INSERT INTO rug_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Ke mae si arini meke paleki sari na tie matedi; paleke turaṉae ni dia poko rini, meke paleke lani pa valena sa vasina koa sari na tie, gua puta tugo sapu zama nia e Mosese. ");
INSERT INTO rug_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Beto asa, si zama la koe Eroni meke sari karua tuna koreo, ari Eleaza meke Itamara se Mosese, “Suti valeani sari na kalumia, mamu lopu sira rikati sari na mia poko pude lopu va dogoro nia sa mia tinalotaṉa. Be tavete gua asa si gamu, si kaqu mate si gamu, meke kaqu bugoro nia e Zihova sa doduruna sa butubutu. Ba sari doduru tinoni Izireli pule si tava malumu pude kaboa sa minate sapu evaṉia sa nika, sapu garunia e Zihova. ");
INSERT INTO rug_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Lopu kaqu luara pania gamu sa sasadana sa Ipi Hope. Be luaria gamu si asa, si kaqu mate si gamu, sina ele tava madi mia si gamu koasa oela te Zihova.” Ke tavetia rini sapu gua zama nia e Mosese. ");
INSERT INTO rug_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Zama se Zihova koe Eroni, ");
INSERT INTO rug_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Agoi meke sari na tumu koreo si lopu kaqu nuquru mae pa kenuqu Rau pa korapa Ipi Hopena pana beto naponapo si gamu; be tavetia gamu sapu gua asa, si kaqu mate si gamu. Sa tinarae asa si kaqu ta kopue koari doduru mia sinage na sage. ");
INSERT INTO rug_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Kaqu gilana valeania gamu sa vinotikaena sapu te Tamasa, meke sapu boka tavetavete nia doduru totoso, saripu ele tava via pa kenuqu Rau, meke saripu lopu tava viadi. ");
INSERT INTO rug_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Kaqu va tumatumae ni gamu koari doduru tinoni Izireli sari doduru tinarae saripu ponini gamu Rau koe Mosese.” ");
INSERT INTO rug_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Zama la koe Eroni meke koari karua tuna koreo pu koa hola, ari Eleaza meke Itamara se Mosese, “Vagi sari na vinariponi huiti koari na ginani saripu ta vala koe Zihova, mamu kinaia sa bereti sapu lopu ta henie isiti, mamu henaia pa kapana sa hope, sina na hopena hola sa vinariponi hie. ");
INSERT INTO rug_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Mamu hena ia koasa vasina hopena; sa kukuruna asa si tamugamu meke sari na tumia koreo, koasa ginani sapu ta vala koe Zihova, gua sapu ele tozia e Zihova koa rau. ");
INSERT INTO rug_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Ba gamu meke sari na mia tatamana si boka henai sari na masa raqaraqa meke sa pudapuda nene kali mataona, sapu ta vala pude na ṉati vinariponi, meke na ṉati vina hia koe Zihova, pude tadi na hiama. Kaqu henai gamu si arini koa keke vasina viana tava madina. Sari na vinariponi arini si ta vatu koa gamu meke koari na mia koburu pude tamugamu sapu mae guana koasa vina vukivukihi binaere tadi na tinoni Izireli. ");
INSERT INTO rug_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Kaqu paleke mae nia rini sa nene kali mataona meke sa masa raqaraqa pa totoso sapu ta vala sa deana pude va uququa, guana vinariponi ginani la koe Zihova. Hire sari na mia ginani meke tadi na mia koburu ninae rane, gua puta tugo sapu tozia e Zihova.” ");
INSERT INTO rug_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Nanasa nia Mosese sa vina vukivukihi qoti tana sinea asa, meke tozi nia rini, sapu ele tava uqu beto si asa. Bugoroni sa sari Eleaza meke Itamara koasa ginugua asa meke nanasi sa si arini, ");
INSERT INTO rug_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Na vegua ke lopu hena ia gamu sa vina vukivukihi tana sinea koa keke vasina hopena? Hopena hola si asa, meke ele poni nia e Zihova koa gamu si asa, pude taleosae sa sinea tanisa butubutu. ");
INSERT INTO rug_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Sina lopu paleke nuquru mae nia gamu sa ehara pa korapana sa Ipi Hopena, ba kaqu hena ia gamu sa vina vukivukihi asa pa keke vasina hopena, gua puta tugo sapu tozia rau.” ");
INSERT INTO rug_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Olaṉa se Eroni, “Be guana hena ia rau sa vina vukivukihi tana sinea ṉinoroi, ba kote qetu nia e Zihova? Pa rane ṉinoroi tu si paleke maeni tugo rini sari na dia vina vukivukihi va uququ, ba sari na tiṉitoṉa kaleadi hola hire si ta evaṉa tugo koa rau.” ");
INSERT INTO rug_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Sipu avosia tugo Mosese sapu gua asa, si valeania mo sa si asa. ");
INSERT INTO rug_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Zama se Zihova koari Mosese e Eroni, ");
INSERT INTO rug_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Mi zama la koari na tinoni Izireli: Boka henai gamu sari doduru kurukuru ṉame ");
INSERT INTO rug_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","saripu paqaha rua kakarutu nenedi, meke hamu va memehe sari ginani pa totoso vina rua. ");
INSERT INTO rug_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","7","Ba gamu si lopu kaqu henai sari na kurukuru ṉame pu hamu va memehi sari na ginani pa totoso vina rua, ba lopu paqaha rua kakarutu nenedi kekeṉoṉo guana kameli na rabiti, meke lopu kaqu henai gamu sari na kurukuru pu paqaha rua kakarutu nenedi ba lopu hamu va memehi sari na ginani pa totoso vina rua, kekeṉoṉo gua na boko na kurezu. Lopu via si arini pa dinoṉo te Zihova. ");
INSERT INTO rug_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Mu lopu henai sari na kurukuru ṉame arini, babe tiqui mo tomatedi, na bonidi si arini. ");
INSERT INTO rug_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Kaqu henai gamu sari na igana pu ari nebenebedi na kapudi, ");
INSERT INTO rug_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","ba sarini pu koa pa korapa kolo loke nebenebedi na kapudi si lopu kaqu henai. ");
INSERT INTO rug_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Sari na tiṉitoṉa toadi hire si kaqu ta pozae bonidi. Namu lopu kaqu henai gamu si arini, babe tiqui mo saripu matedi. ");
INSERT INTO rug_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Namu lopu kaqu henai gamu si keketoṉa sapu koa pa korapa kolo, saripu loke nebenebedi na kapudi. Kote kaleadi si arini koa gamu. ");
INSERT INTO rug_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","19","Hire sari na kurukuru tapuru saripu lopu leadi sisigiti meke namu lopu kaqu henai gamu: Sari na atata, duduru, nae, manuvu, nao, seṉeṉe, soa, meke na veke. ");
INSERT INTO rug_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Doduru nokinoki hitehitekedi saripu ari tatapurudi si bonidi, ");
INSERT INTO rug_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","ba lopu sarini pu hoke horuhoru. ");
INSERT INTO rug_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Sari na kupokupo si kote boka henai mo gamu. ");
INSERT INTO rug_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Ba sari doduru pule pu hitehitekedi pu ene pa pepeso pu soku nenedi meke ari tatapurudi meke lopu horu si ta pozae bonidi. ");
INSERT INTO rug_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","28","Esei sa tie sapu tiqui sari na nokinoki matedi hire si kaqu boni osolae kamo totoso lodu sa rimata: Doduru kurukuru ṉame saripu lopu paqaha rua kakarutu nenedi meke lopu hamu va memehe sari na ginani pa totoso vina rua, meke sari doduru kurukuru ṉame pu ka made nenedi meke ari visuvisudi si bonidi. Sa tie sapu paleki saripu matedi, si kaqu ṉuzapa va via i sari nana poko, ba lopu kaqu ture via tugo si asa osolae kamo totoso lodu sa rimata. ");
INSERT INTO rug_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","30","Sari kurukuru ṉame guana kurezu. Meke sari na kurukuru pu doṉo guana na kilikozo, na varilazu, na kive, regu, si ta pozae bonidi. ");
INSERT INTO rug_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Be esei sa tie sapu tiqui si arini babe saripu matedi si kaqu ta pozae bonidi osolae kamo totoso lodu sa rimata. ");
INSERT INTO rug_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Meke be hoqa koa keketoṉa saripu matedi, sa tiṉitoṉa kaqu ta pozae boni si asa, gua tugo na tiṉitoṉa guana huda, poko, na kapu kurukuru ele tava popana, na baika, babe sa sa tiṉitoṉa sapu tavetavete nia koasa. Kaqu tava lodu pa korapa kolo, meke kaqu ta pozae boni si asa, osolae kamo totoso lodu sa rimata. ");
INSERT INTO rug_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Meke be hoqa voi pa korapa raro patu sari na tinidi, sari doduru tiṉitoṉa saripu koa pa korapana si boni beto mo, meke kaqu porakia goi sa raro patu sana. ");
INSERT INTO rug_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Kaiqa ginani saripu hoke boka henai, ba tava boboso koasa kolo sapu koa pa korapa raro patu sana sapu bonina, si kaqu ta pozae boni tugo. Ba be kaiqa toṉa saripu hoke ta napo si koa pa korapa raro, ba boni tugo si asa. ");
INSERT INTO rug_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Be sa saripu hoqai ri pu matedi si boni tugo. Be na kinakinana sapu ta tavete patu ba kaqu ta poraka tugo. ");
INSERT INTO rug_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Ba na bukaha babe na berukehe popana si lopu kaqu hite ta pozae boni, ba be na tie meke kaiqa toṉa pule tu si tiqui saripu matedi, si boni si arini. ");
INSERT INTO rug_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Be keke toṉa matena si hoqa koasa kiko sapu tava namanama pude ta lete, sa kiko asa si korapa viana. ");
INSERT INTO rug_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Ba be ta poṉa pa korapa kolo sa kiko, meke be keke toṉa bonina si hoqa gore koasa, si boni sa kiko. ");
INSERT INTO rug_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Be keke kurukuru ṉame sapu boka ta hena si mate, sa tie sapu tiqua si asa, si kaqu boni osolae kamo totoso lodu sa rimata. ");
INSERT INTO rug_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Be henaia keke tie sa vasi kukuru tinina sa kurukuru ṉame asa, si kaqu ṉuzapa va via i sa sari nana poko, meke kaqu boni tugo si asa osolae lodu sa rimata. Be keke tie palekia sa sa kurukuru matena, si kaqu ṉuzapi sa sari nana poko; meke lopu kaqu tuture via si asa, osolae kamo totoso lodu sa rimata. ");
INSERT INTO rug_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Namu lopu kaqu henai gamu sari na kurukuru ṉame hitehitekedi saripu ene pa pepeso: ");
INSERT INTO rug_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","saripu ṉameṉame, babe eneneni ka made nenedi, babe arini pu soku nenedi. ");
INSERT INTO rug_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Mu lopu va boni puleni gamu koari na hinenadi rini. ");
INSERT INTO rug_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Arau tugo se Zihova sa mia Tamasa, mamu va madi sari na mia tinoa, sina na Hopequ si Rau. ");
INSERT INTO rug_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Arau tugo se Zihova sapu turaṉa vurani gamu pa popoa Izireli. Ke Arau tugo sa mia Tamasa, meke gamu si kaqu va madi sari na mia tinoa, sina na Hopequ si Arau. ");
INSERT INTO rug_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Arini tugo sari na tinaraedi rina kurukuru ṉame na kurukuru tapuru, meke saripu koa pa korapa kolo, meke sari doduru pu ene pa pepeso. ");
INSERT INTO rug_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Kaqu kopu sisigiti si gamu, pude gilani saripu tava via pa dinoṉo te Zihova, meke saripu boni. Mamu gilani sari na kurukuru toadi saripu boka ta hena, meke saripu bonidi pu lopu boka ta hena.” ");
INSERT INTO rug_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Zama se Zihova koe Mosese, ");
INSERT INTO rug_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Mu tozini sari na tinoni Izireli: ‘Sipu koa ta holae nia keke barikaleqe si keke tuna koreo, si boni si asa osolae kamo sa rane vina zuapa, kekeṉoṉo gua tugo sapu boni si asa koasa nana minoho tana barikaleqe. ");
INSERT INTO rug_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Koasa rane vina vesu si kaqu ta magu d sa koburu haha, ");
INSERT INTO rug_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","meke kaqu boni sa barikaleqe osolae kamo pa mudina asa koari ka toloṉavulu ṉeta rane hola gua. Koasa rane asa si kaqu via si asa. Koari na rane tanisa nana binoni mani kopu pule nia pude lopu nuquru la koasa Ipi Hopena, babe tiqui sari na tiṉitoṉa hopedi osolae tava hokoto beto sa nana totoso vina via. ");
INSERT INTO rug_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Sa barikaleqe sapu koa ta holae nia si keke tuna vineki si kaqu boni si asa osolae kamo pa mudina ka manege made rane, kekeṉoṉo gua tugo sapu boni si asa koasa nana totoso tanisa nana minoho tana barikaleqe. Pa mudina sa manege made rane, si kaqu aqa ka onomo ṉavulu onomo rane pule, pude boka via pa hahanana vinavia pa dinoṉo te Zihova. ");
INSERT INTO rug_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Be na tuna koreo ba be tuna vineki si asa sapu ta holae nia sa barikaleqe, pana hokoto sa nana totoso vina via, si kaqu paleke la nia sa koasa hiama pa sasadana sa Ipi Hopena, si keke lami kokoreo sapu keke vuahenina pude na vina vukivukihi va uququ meke keke baruku babe na kukuva pude na vina vukivukihi tana sinea. ");
INSERT INTO rug_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Kaqu va vukivukihi lani sa hiama koe Zihova sari nana vina vukivukihi pude taleosae si asa, meke pude via si asa koasa nana totoso va taloa ehara. Asa sa ginugua koasa kinoa ta holae sapu kaqu tavetia sa barikaleqe. ");
INSERT INTO rug_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Be habahuala meke loke nana tuna sipi sa barikaleqe, si kaqu paleki sa si karua kukuva babe karua baruku. Keke si pude tana vina vukivukihi va uququ, meke keke si pude na vina vukivukihi tana sinea. Meke sa hiama si kaqu tavetia sa hahanana vina madi pude taleosae sari nana sinea, meke pude via si asa pa kenuna e Zihova. Asa sa ginugua pa mudina sa pinodopodo sapu kaqu tavetia sa barikaleqe.’ ” ");
INSERT INTO rug_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Meke zama se Zihova koari Mosese e Eroni, ");
INSERT INTO rug_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Be tubu kapuna sa tie, ba be moqo ba be kina sapu boka ta evaṉae minoho kaleana hola pa kapu, si kaqu ta turaṉa la koasa hiama sapu se Eroni babe tuna pa tutina sa. ");
INSERT INTO rug_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Kaqu vilitia sa hiama sa tubu meke be ta ilirae keoro sari na pulupulu pa korapana sa tubuna, meke ta dogoro sapu lohi hola nia sa tubu sa kapuna, si ta gilana sapu na minoho kaleana hola si asa. Kaqu tozi vura nia sa hiama sapu boni sa tie pa dinoṉo te Zihova. ");
INSERT INTO rug_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Ba be keoro sa tubu, meke lopu doṉo guana lohi hola nia sa sa kapuna pa vari likohaena, meke sari na pulupuluna si lopu doṉo guana keoro, si kote veko va ilolae ia sa hiama sa tie koari ka zuapa rane. ");
INSERT INTO rug_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Sa hiama si kote viliti pulea si asa koasa rane vina zuapa, meke be dogoria sa sapu doṉo kekeṉoṉo mo sa tubuna, lopu toa, si kote veko vata kale pulea sa ka zuapa rane pule. ");
INSERT INTO rug_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Kaqu viliti pulea sa hiama si asa koasa rane vina zuapa, meke be ibu sa tubu, meke lopu toa, si kote tozi vura nia sa sapu via si asa, sapu na tubu mo si asa. Kaqu ṉuzapa va via i sa tie sari nana poko meke kaqu tiqe via si asa pa dinoṉo te Zihova. ");
INSERT INTO rug_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Ba be toa sa tubu pa mudina sapu vilitia sa hiama, meke ta tozi vurae sapu via si asa gua, si kaqu ta viliti pule koasa hiama si asa. ");
INSERT INTO rug_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Kaqu viliti pulea sa hiama si asa, meke be toa tugo si asa, si kaqu tozi vura nia sa sapu boni si asa; na minoho pa kapu sapu kaleana hola. ");
INSERT INTO rug_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Be keke tie si koa ia na minoho kaleana hola pa kapuna, si kaqu ta turaṉa la koasa hiama si asa, ");
INSERT INTO rug_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","meke kaqu vilitia sa hiama si asa. Be doṉo keoro sa moqo sapu va keori sari na pulupulu meke siṉia na muzi, si ");
INSERT INTO rug_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","na minoho pa kapu sapu ele koa seunaena hola si asa. Sa hiama si kaqu tozi vura nia sapu boni si asa, meke lopu ta hivae pude veko va ilolae ia telena, sina ele bakala mo sapu boni si asa. ");
INSERT INTO rug_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Be hola la sa minoho kapu hie pa doduru tinina sa tie, podalae pa batuna kamoa nenena, ");
INSERT INTO rug_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","kaqu viliti pulea sa hiama si asa. Be dogoria sa sapu hinokara ene betoa sa sa doduruna sa tinina, si kaqu tozi vura nia sa sapu via si asa. Be ta ilirae keoro sa doduru tinina meke beto sa minoho kapu si via si asa pa dinoṉo te Zihova. ");
INSERT INTO rug_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Ba be koasa totoso tugo asa si lera vura mae sa tubu, si boni si asa. ");
INSERT INTO rug_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Kaqu viliti pulea sa si asa, meke be dogoria sa hiama sapu lera sa tubu, si kaqu tozi vura nia sa sapu boni si asa. Na tubu lerana ginuana si na minoho kaleana hola pa kapu meke boni sa tie. ");
INSERT INTO rug_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Ba sipu ibu sa tubu meke keoro pule, si kaqu la koasa hiama sa tie, ");
INSERT INTO rug_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","meke kaqu viliti pulea sa si asa. Be ta ilirae keoro sa tubu, si via si asa pa dinoṉo te Zihova, meke kaqu tozi vura nia sa hiama sapu via si asa. ");
INSERT INTO rug_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Be keke tie si moqo meke ta salaṉa, ");
INSERT INTO rug_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","meke pa mudina asa si vura mae sapu keoro sa moqo, ba be kidakida ziṉara keoro sa moqo, kaqu la koasa hiama si asa. ");
INSERT INTO rug_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Kaqu vilitia sa hiama si asa, meke be guana lohi hola nia sa tubu sa kapu pa vari likohaena, meke sari na pulupuluna si keoro, si kaqu ta tozi vurae sapu boni si asa. Na minoho kapu kaleana hola si asa, sapu podalae nia sa moqo. ");
INSERT INTO rug_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Ba be vilitia sa hiama si asa meke sari na pulupulu pa korapana si lopu keoro, meke lopu lohi hola nia sa kapuna pa vari likohaena, ba doṉo guana kaka si asa, si kaqu veko va seu ia sa hiama si asa koari ka zuapa rane. ");
INSERT INTO rug_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Be vari karovi sa kidakida, si kaqu tozi vura nia sa hiama sapu boni si asa; na ele seunaena sa nana minoho. ");
INSERT INTO rug_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Ba be loketoṉa si ta evaṉa meke lopu varikarovi sa minoho; ba na kira mo si koa hola koasa pinodalaena sa moqo, si kaqu tozi vura nia sa hiama sapu via si asa. ");
INSERT INTO rug_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Koasa tie sapu kina, be sa olarana si doṉo keoro babe ziṉara, ");
INSERT INTO rug_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","sa hiama si kaqu vilitia si asa, be keoro sari na pulupuluna pa olarana, meke ta dogoro sapu lohi hola nia sa sa kapuna pa vari likohaena, na minoho kaleana hola pa kapu si asa, sapu ta podalae koasa kina. Kaqu tozi vura nia sa hiama sapu boni si asa. ");
INSERT INTO rug_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Ba be sari na pulupulu pa olarana si lopu keoro, meke lopu lohi hola nia sa sa kapuna pa vari likohaena, ba doṉo guana kaka mo si asa, si kaqu veko va seu ia sa hiama si asa ka zuapa rane. ");
INSERT INTO rug_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Kaqu viliti pulea sa hiama si asa koasa vina zuapa rane, meke be toa si asa, na minoho kaleana hola pa kapu si asa. Kaqu tozi vura nia sa hiama sapu boni si asa. ");
INSERT INTO rug_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Ba be lopu hobe sa dinoṉona, meke lopu toa tugo, ba doṉo guana kaka mo si lopu na minoho kaleana hola si asa. Kaqu tozi vura nia sa hiama sapu via si asa pa dinoṉo te Zihova, sina na kirana mo si asa. ");
INSERT INTO rug_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Pana tubu batuna ba be asena si keke tie, ba be keke barikaleqe, ");
INSERT INTO rug_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","si kaqu vilitia sa hiama si asa. Be guana lohi hola nia sa sa kapu pa vari likohaena, meke sari na pulupulu pa olarana si doṉo guana meava meke karakara; si na minoho kaleana hola si asa. Kaqu tozi vura nia sa sapu boni si asa. ");
INSERT INTO rug_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Ba pana vilitia sa hiama meke doṉo guana lopu lohi hola nia sa tubu sa kapu pa vari likohaena, meke lopu karakara sari na pulupulu koasa olarana, si kaqu va koa vata kale ia sa si asa koari ka zuapa rane. ");
INSERT INTO rug_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Kaqu viliti pulea sa hiama sa tubuna koasa rane vina zuapa meke be lopu toa si asa, meke loke pulupulu meavadi pa olarana, meke lopu doṉo guana lohi hola nia sa sa kapu vari likohaena, ");
INSERT INTO rug_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","si kaqu neria sa tie sa batuna, ba lopu koasa vari likohaena sa tubu. Kaqu veko vata kale ia sa hiama si asa koari ka zuapa rane. ");
INSERT INTO rug_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Koasa rane vina zuapa si kaqu viliti pulea sa hiama sa tubuna, meke be lopu toa si asa, meke lopu doṉo guana lohi hola nia sa kapu pa vari likohaena, si kaqu tozi vura nia sa sapu via si asa. Kaqu ṉuzapi sa tie sari nana poko meke kaqu via si asa. ");
INSERT INTO rug_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Ba be toa pa mudina sipu ele ta tozi vurae sapu via si asa gua, ");
INSERT INTO rug_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","si kaqu viliti pulea sa hiama si asa. Be toa tugo si asa, si lopu garona pude doṉo hatai sari na pulupulu meavadi, sina bakala mo sapu lopu via sa tie. ");
INSERT INTO rug_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Ba be ibu sa tubu pa vinizata tanisa hiama, meke sari na pulupuluna si toa valeana pa olarana, meke ta salaṉa sa tubu, si kaqu tozi vura nia sa hiama sapu via si asa. ");
INSERT INTO rug_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Pana kamoa na kidakida si keke tie babe keke barikaleqe pa tinina, ");
INSERT INTO rug_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","kaqu vilitia sa hiama sa tie sana. Be doṉo guana rida keoro sa kidakidana, si lopu kaleana sisigiti sa minoho, ke via sa tie. ");
INSERT INTO rug_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","41","Be keke tie si vuvusu taloa kaluna pa kizuna ba be raena, si lopu boni si asa. ");
INSERT INTO rug_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Ba be keke tubu si vura mae pa pakana sapu ziṉara keoro si kaleana hola sa minoho asa. ");
INSERT INTO rug_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Kaqu vilitia sa hiama si asa, meke be ziṉara keoro si asa, ");
INSERT INTO rug_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","si kaqu tozi vura nia sa hiama sapu boni si asa, sina na minoho kaleana hola si koa pa batuna. ");
INSERT INTO rug_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Sa tie sapu koa ia na minoho kaleana hola pa kapuna si kaqu va sagea sa poko rikarikatana, lopu kaqu sutia sa sa kaluna, kaqu nobia sa sa isumatana, meke zama velavela guahe: ‘Boni, boni si rau!’ gua, pude va balau i sari na tie. ");
INSERT INTO rug_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Sa binoni tanisa tie si kaqu lulia sapu ve seunaena gua koa sa tie sa minoho. Kaqu koa vata kale pa kinoa tie si asa, pude lopu koa tata pa tie. ");
INSERT INTO rug_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Pana karovia sa nokonoko kaleana hola meke toa koasa poko, be na vulu sia, ba be na poko lineni sia, ");
INSERT INTO rug_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","be ta tigisina, babe ta hokena, babe koa pa keke kapu sapu tava popana sapu tavete nia rina likakalae, ");
INSERT INTO rug_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","be doṉo guana buma sia, babe ziṉara, na binoni kaleana hola sapu vari karovi, meke ta hivae pude kaqu va dogoro nia koasa hiama. ");
INSERT INTO rug_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Kaqu vilitia sa hiama si asa, meke kaqu veko va seu ia sa hiama sa tiṉitoṉa asa koari ka zuapa rane. ");
INSERT INTO rug_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Kaqu viliti pulea sa hiama si asa koasa vina zuapa rane, meke be toa sa binoni kaleana asa, si kaqu ta pozae boni sa tiṉitoṉa asa. ");
INSERT INTO rug_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Kaqu sulu pania sa hiama si asa, sina vari karovi sa nokonoko asa, meke ta hivae pude kaqu tava murimuri palae pa nika si asa. ");
INSERT INTO rug_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Ba be pana vilitia sa si asa, meke dogoria sa hiama sapu lopu toa sa nokonoko kaleana asa koasa tiṉitoṉa asa, ");
INSERT INTO rug_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","si kaqu garunu nia sa sa tie pude ṉuzapa va via ia, meke veko va seu ia ka zuapa rane. ");
INSERT INTO rug_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Beto asa, si kaqu viliti pulea sa, meke be korapa toa si asa ba lopu hobe sa dinoṉona sa minoho kaleana; meke be lopu vari karovi si asa; ba kaqu ta pozae boni tugo si asa. Kaqu sulu pania tugo goi si asa, be pa kenuna babe pa mudina si koa sa kinaleana. ");
INSERT INTO rug_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Ba be pana viliti pulea sa hiama si asa, meke murimuri palae sa nokonoko kaleana, si kaqu rikata pania sa sa kukuruna sa poko babe na kapu sapu bonina tatasana. ");
INSERT INTO rug_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Ba be vura pule mae sa nokonoko kaleana koasa poko, si toa halala pule si asa; sa tie pu tagona si kaqu sulu pania sa tiṉitoṉa asa. ");
INSERT INTO rug_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Be ele ṉuzapa va viaia sa sa poko babe na kapu asa, meke lopu ta dogoro sa nokonoko sapu koa koasa poko, si kaqu ṉuzapa va via pulea sa si asa, meke kaqu tiqe via si asa pa dinoṉo te Zihova.” ");
INSERT INTO rug_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Arini sari na tinarae tanisa nokonoko sapu koa pa poko; be na vulu sia, babe na poko lineni, babe keke tiṉitoṉa ta tavetae pa kapu kurukuru. Gua asa sa hahanana vinizata pude tozia be via babe boni si asa pa dinoṉo te Zihova. ");
INSERT INTO rug_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Zama se Zihova koe Mosese, ");
INSERT INTO rug_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Sa tinarae hie si koasa guguana sa vina via, pana ta salaṉa sa tie, koasa nana minoho kaleana pa kapuna. Koasa rane sana, si kaqu ta turaṉa la koa sa hiama pude tozi vura nia sapu via si asa. ");
INSERT INTO rug_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Kaqu ene la sa hiama pa vasina sapu koa sa tie bonina pa valena sa vasina koa sari na tie meke vilitia. Be ta salaṉa sa minoho, ");
INSERT INTO rug_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","si kaqu garunia sa hiama, pude paleke maeni rina turaṉana sa tie si karua kurukuru tapuru viadi pa dinoṉo te Zihova, meke keke kukuru huda sida, keke kukuru lozi ziṉara, keke lelaṉa huda hisope. ");
INSERT INTO rug_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Beto asa, si kaqu zama sa hiama koasa tie, pude va matea si keke koari karua kurukuru tapuru pa besini patu, sapu koa ia na kolo lomoso. ");
INSERT INTO rug_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Kaqu vagia sa sa kurukuru toana, sa huda sida, sa kukuru lozi ziṉara meke sa hisope, meke poṉa lani pa kolo pa korapa eharana sa kurukuru, sapu ele matena. ");
INSERT INTO rug_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Ka zuapa totoso si kaqu siburu nia sa sa ehara koasa tie, sapu kaqu tava via koasa nana minoho pa kapuna, beto si kaqu tozi vura nia sa, sapu via si asa. Kaqu va tapuru taloa ia sa sa kurukuru toana koasa vasina asa. ");
INSERT INTO rug_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Kaqu ṉuzapa va via i sa tie sari nana poko, meke neri pani sari doduru kaluna, huhuve, beto asa, si kaqu tiqe via si asa pa dinoṉo te Zihova. Boka somana pule koari na tie si asa, ba pa sadana mo sa nana ipi, si kaqu koa si asa, koari ka zuapa rane. ");
INSERT INTO rug_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Koasa rane vina zuapa, si kaqu neri pulea sa sa batuna, gumina, sari na pupudere matana, meke doduru pulupulu pa tinina; kaqu ṉuzapa va via i sari nana poko, huhuve, beto asa, si kaqu tiqe via si asa. ");
INSERT INTO rug_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Koasa rane vina vesu si kaqu paleke maeni sa si hire: Karua tuna sipi kokoreo, keke tuna sipi mamaqota, saripu tiqe keke vuahenidi pu loke ari kisakisadi, meke na palava memehena ka ṉeta kilo mamatana, sapu ta henie oela olive, meke kukuru lita oela olive. ");
INSERT INTO rug_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Kaqu veko lani sa hiama koe Zihova sari na vinariponi arini meke sa tie, koasa sasadana sa Ipi Hopena pa kenuna e Zihova. ");
INSERT INTO rug_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Beto asa, si keke koari karua sipi kokoreo, meke sa kapa oela olive si kaqu vagia sa hiama, pude na vina vukivukihi vina toṉoto gale. Kaqu ovulu ululu la nia sa si asa, pude na vinariponi arilaena koe Zihova. ");
INSERT INTO rug_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Kaqu va matea sa sa tuna sipi, koasa vasina hopena, vasina pu hoke tava mate sari na kurukuru tadi na vina vukivukihi tana sinea, meke na vina vukivukihi vina uququ. Kaqu tavetia sa sapu gua asa, sina sa vina vukivukihi vina toṉoto gale, meke sa vina vukivukihi tana sinea, si tanisa hiama, meke madidi hola si arini. ");
INSERT INTO rug_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Kaqu vagi sa hiama sari kaiqa eharana sa tuna sipi sapu sa vina vukivukihi vina toṉoto gale, meke kaqu vekoi sa pa boboa taliṉa mataona, koasa gugulavata pa kali lima mataona, meke koasa gugulavata pa kali nene mataona, sa tie sapu ta salaṉa pa nana minoho kaleana pa kapuna. ");
INSERT INTO rug_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Kaqu vagia sa hiama sa oela olive, meke zoropo la nia sa pa ola lima gedena soti, ");
INSERT INTO rug_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","noti la nia keke kakarutu lima mataona, meke siburu nia sa ka zuapa totoso pa kenuna e Zihova vasina. ");
INSERT INTO rug_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Kaqu vagi sa si kaiqa oela pa ola limana, meke vekoa koasa eharana sa tuna sipi, sapu ele vekoi sa pa boboa taliṉa mataona, meke pa gugulavata pa kali lima mataona, meke pa gugulavata pa kali nene mataona sa tie pu ta tozi vurae sapu via si asa pa nana minoho kaleana pa kapuna. ");
INSERT INTO rug_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Sari na oela pu koa hola pa ola limana si kaqu vekoi sa pa batuna sa tie. Pa siraṉa gua asa si kaqu va via ia sa sa tie pa kenuna e Zihova. ");
INSERT INTO rug_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Beto asa si kaqu va vukivukihi la nia sa hiama sa vina vukivukihi tana sinea, pude taleosae sa tie. Pa mudina asa si kaqu va matea sa sa kurukuru pude na vina vukivukihi va uququ, ");
INSERT INTO rug_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","meke va uqu turaṉae nia sa vinariponi huiti koasa hope. Koasa siraṉa gua asa, si kaqu ta tavete sa vina via meke kaqu via sa tie pa kenuna e Zihova. ");
INSERT INTO rug_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Be guana habahualana sa tie, meke lopu boka kamoa sa sapu ta hivae, si kaqu turaṉa la nia mo sa si keke tuna sipi kokoreo, pude na vina vukivukihi vina toṉoto gale la koe Zihova si asa, meke keke kilo palava memehena mo sapu henia na oela olive pude na vinariponi huiti, meke kukuru lita oela olive. ");
INSERT INTO rug_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Kaqu paleke lani tugo sa karua kukuva babe karua baruku. Keke si pude na vina vukivukihi tana sinea, meke keke pule si pude na vina vukivukihi va uququ. ");
INSERT INTO rug_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Koasa rane vina vesu pa nana vina via, si kaqu paleke lani sa si arini koasa hiama pa sasadana sa Ipi Hopena pa kenuna e Zihova. ");
INSERT INTO rug_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Kaqu vagia sa hiama sa tuna sipi kokoreo tanisa vina vukivukihi vina toṉoto gale meke sa oela olive, meke kaqu ovulu va ululu lani sa si arini, pude na vinariponi arilaedi koe Zihova. ");
INSERT INTO rug_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Kaqu va matea sa hiama sa tuna sipi kokoreo meke vagi sari kaiqa eharana, meke veko lani pa boboa taliṉa mataona, pa gugulavata kali lima mataona, meke pa gugulavata kali nene mataona sa tie. ");
INSERT INTO rug_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Kaqu zoropo lani sa hiama si kaiqa oela pa kali ola lima gedena soti, ");
INSERT INTO rug_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","meke sa kakarutu lima mataona si kaqu siburu ni sa si kaiqa ka zuapa totoso pa kenuna e Zihova vasina. ");
INSERT INTO rug_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Kaqu vagia sa si kaiqa oela pa ola limana, meke vekoa koasa eharana sa tuna sipi, sapu ele vekoi pa boboa taliṉa mataona, meke pa gugulavata pa kali lima mataona, meke pa gugulavata pa kali nene mataona sa tie. ");
INSERT INTO rug_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Sari na oela saripu koa hola pa ola lima mataona soti, si kaqu vekoi sa pa batuna sa tie. Pa siraṉa gua asa si kaqu va via ia sa sa tie pa kenuna e Zihova. ");
INSERT INTO rug_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Beto asa, si kaqu va vukivukihi nia sa si keke koari karua kukuva, babe na baruku, ");
INSERT INTO rug_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","pude na vina vukivukihi tana sinea, meke sapu keke si na vina vukivukihi tana vina uququ, turaṉae nia sa vinariponi huiti. Pa siraṉa gua asa si kaqu va via ia sa sa tie pa kenuna e Zihova.” ");
INSERT INTO rug_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Arini sari na tinaraena sa minoho kaleana hola pa tinina sa tie, pu lopu boka ṉana kamoa sa padana sa vinariponi sapu ta hivae koasa vina vukivukihi vina via. ");
INSERT INTO rug_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Tozi ni e Zihova koari Mosese e Eroni si hire, ");
INSERT INTO rug_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Pana nuquria gamu sa popoa Kenani, sa popoa sapu hiva ponia Rau koa gamu pude tamugamu, sari na tinarae hire si tamugamu totoso keke nokonoko kaleana si hoke vari karovi koari na vetu meke toa si asa. ");
INSERT INTO rug_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","Be keke tie dogoria sa nokonoko kaleana hola pa nana vetu, si kaqu la tozia sa guguana koasa hiama. ");
INSERT INTO rug_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Kaqu garunia sa hiama si asa, sipu lopu ele la vilitia sa sa minoho pude va vura betoi sari doduru likakalae koasa vetu; kote gua meke lopu ta tozi vurae sapu na boni beto sa doduruna sa vetu meke sari na tiṉitoṉa. Pa mudina asa, si kaqu tiqe la si asa koasa vetu, ");
INSERT INTO rug_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","meke la vilitia sa sa nokonoko kaleana. Be guana koadia sa nokonoko buma, babe ziṉara, meke doṉo guana korapa gani va korapa la koasa goba, ");
INSERT INTO rug_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","si kaqu luaria sa sa vetu, meke loka vekoa koari ka zuapa rane. ");
INSERT INTO rug_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Pa rane vina zuapa, si kaqu pule mae viliti pulea sa sa vetu. Be toa sa nokonoko kaleana hie, ");
INSERT INTO rug_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","si kaqu garunu ni tie sa sari na patu vasina ta dogoro sa minoho asa, pude tava rizu pule, meke oki lani koari kaiqa vasina bonidi pa sadana sa vasileana lavata. ");
INSERT INTO rug_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Beto asa, si kaqu ta rausu beto sari doduru goba pa korapana sa vetu, meke sari na palasita si kaqu ta okie la pa korapana keke vasina bonina pa sadana sa vasileana lavata. ");
INSERT INTO rug_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Beto asa, si kaqu ta vagi si kaiqa patu, meke hobe lani koari na patu pu ele tava rizu taloa, meke kaqu ta tita keoro vaqura sari goba. ");
INSERT INTO rug_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Be guana toa pule sa nokonoko kaleana koasa vetu pa mudina sipu tava rizu pule sari na patu, meke ele ta rausu va via, meke ele ta tita va keoro beto, ");
INSERT INTO rug_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","si kaqu la vilitia sa hiama si asa. Be toa tugo sa nokonoko asa, si lopu via sa vetu. ");
INSERT INTO rug_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Kaqu ta huara gore sa vetu, meke sari na huda na patu, si kaqu ta paleke vura koasa vasileana lavata, meke la vekoi koasa vasina bonina. ");
INSERT INTO rug_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Sa tie sapu nuquru koasa vetu asa, totoso ta tuku va nabu sa vetu, si lopu kaqu via si asa, osolae kamo totoso lodu sa rimata. ");
INSERT INTO rug_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Asa sapu eko babe henahena koasa vetu asa, si kaqu va via i sa sari na nana poko. ");
INSERT INTO rug_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Pa mudina sipu ta tita keoro pule si keke vetu, meke mae vilitia sa hiama, meke lopu vura pule mae sa nokonoko kaleana, si kaqu tozi vura nia sa, sapu via sa vetu, sina ele ta salaṉa pule beto hokara sa nokonoko kaleana. ");
INSERT INTO rug_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Pude va via hokaria sa vetu pa kenuna Zihova, si kaqu vagi sa hiama si karua kurukuru tapuru, kaiqa huda sida, meke keke lozi ziṉara meke keke linetelete hisope, ");
INSERT INTO rug_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","meke kaqu va matea sa si keke koari karua kurukuru tapuru koasa baolo patu, sapu koa ia na kolo lomoso. ");
INSERT INTO rug_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Beto asa, si kaqu vagia sa sa huda sida, sa hisope meke sa lozi ziṉara, meke sa kurukuru toana, meke poṉa lani koasa eharana sa kurukuru tapuru, sapu tava mate pa kolo. Meke ka zuapa totoso, si kaqu siburu la nia sa koasa vetu sa ehara. ");
INSERT INTO rug_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Pa siraṉa gua asa, si kaqu tava via sa vetu, koasa kolo lomoso, sa kurukuru toana, sa huda sida, sa hisope, meke sa lozi ziṉara, meke sa eharana sa kurukuru tapuru. ");
INSERT INTO rug_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Beto asa, si kaqu va tapuru taloa ia sa sa kurukuru tapuru toana pa sadana sa vasileana lavata pa hiqohiqo. Koasa siraṉa gua asa, si va via ia sa hiama sa vetu pa dinoṉo te Zihova.” ");
INSERT INTO rug_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Arini sari na tinaraedi ri na minoho kaleadi pa kapu, ");
INSERT INTO rug_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","56","sari na tubu, moqo, meke sari na nokonokodi rina poko na vetu. ");
INSERT INTO rug_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Sari na tinarae hire, si va dogoroni gita, totoso via babe lopu via sari na tiṉitoṉa. ");
INSERT INTO rug_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Zama se Zihova koari Mosese e Eroni, ");
INSERT INTO rug_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Mamu tozini sari na tinoni Izireli: Pana moho sa tie muzi laguna, sa kolo asa si lopu viana, ");
INSERT INTO rug_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","be sa kolo asa si vura pa tinina ba be tava noso pa tinina. ");
INSERT INTO rug_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Sa teqe sapu habotia sa babe ekoa sa si lopu via. ");
INSERT INTO rug_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Sa tie sapu tiqua sa nana teqe ");
INSERT INTO rug_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","babe habotia si keketoṉa sapu habotia sa tie, si kaqu va via i sa sari nana poko meke kaqu huhuve tugo si asa, ba lopu kaqu turei via tugo osolae kamo totoso lodu sa rimata. ");
INSERT INTO rug_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Sa tie sapu tiqua sa tie sapu muzi laguna si kaqu va via i sari nana poko, meke kaqu huhuve tugo si asa, ba lopu kaqu tuturei via tugo si asa osolae kamo totoso lodu sa rimata. ");
INSERT INTO rug_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Be loroa sa tie muzi laguna si keke tie sapu viana pa dinoṉo te Zihova, si kaqu va via i sa tie sana sari nana poko, meke kaqu huhuve tugo si asa, ba lopu kaqu via tugo si asa osolae kamo totoso lodu sa rimata. ");
INSERT INTO rug_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Be habotia sa tie muzi laguna, si keke kurukuru babe keke habohabotuana, si boni sa kurukuru babe sa habohabotuana. ");
INSERT INTO rug_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Be tiqua keke tie, si keketoṉa sapu habotia sa tie muzi laguna, si boni si asa, osolae kamo totoso lodu sa rimata. Be keke tie si palekia si keke toṉa sapu habotia sa tie, si kaqu va via i sa sari nana poko meke kaqu huhuve tugo si asa, ba lopu kaqu tuturei via tugo si asa, osolae kamo totoso lodu sa rimata. ");
INSERT INTO rug_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Be keke tie muzi laguna, si lopu pezaku kekenu meke tiqua sa si keke tie, si kaqu va via i sa sari nana poko meke kaqu huhuve si asa, ba lopu kaqu tuturei via si asa, osolae kamo totoso lodu sa rimata. ");
INSERT INTO rug_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Be tiqua sa tie muzi laguna si keke raro, kaqu ta poraka si asa; ba be keke baolo huda si tiqua sa tie, si kaqu tava via pa kolo si asa. ");
INSERT INTO rug_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Beto hoi sipu ta salaṉa sa tie koasa nana minoho, si kaqu nae ka zuapa rane si asa, meke kaqu tiqe va via i sa sari nana poko, meke kaqu huhuve tugo pa kolo bukaha, meke tiqe via si asa. ");
INSERT INTO rug_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Pa rane vina vesu si kaqu paleke lani sa sari karua kukuva, babe karua baruku pa sasadana sa Ipi Hopena pa kenuna e Zihova meke valani sa koasa hiama. ");
INSERT INTO rug_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Kaqu va vukivukihi ni sa hiama si arini; keke si pude na vina vukivukihi tana sinea; meke keke pule si tana vina vukivukihi va uququ. Pa siraṉa gua asa, si kaqu tava via sa tie muzi laguna pa dinoṉo te Zihova. ");
INSERT INTO rug_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Pana lulua haru sa tie, si kaqu huvea sa sa doduru tinina pa kolo, ba kote via si asa pana kamo totoso lodu sa rimata. ");
INSERT INTO rug_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Be karovia boboso kolo tanisa palabatu si keke poko babe kapu kurukuru si kaqu tava via si asa pa kolo, ba kaqu boni si asa osolae kamo totoso lodu sa rimata. ");
INSERT INTO rug_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Sipu beto tugo vari eko turaṉi sari karua, sa barikaleqe meke sa palabatu, si kaqu huve beto sari karua, ba kaqu boni sari karua osolae kamo totoso lodu sa rimata. ");
INSERT INTO rug_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Pana kamoa nana minoho barikaleqe sa barikaleqe, si lopu kaqu via si asa pa dinoṉo te Zihova koari ka zuapa rane. Asa sapu tiqua si asa, si kaqu boni si asa osolae kamo totoso lodu sa rimata. ");
INSERT INTO rug_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Kaqu boni sa tiṉitoṉa, sapu habotia ba be ekoa sa barikaleqe pu kamoa nana minoho. ");
INSERT INTO rug_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","23","Be keke tie si tiqua sa nana poko ba be habotia sa tiṉitoṉa sapu habotia sa, si kaqu va via i sa sari nana poko, meke kaqu huhuve tugo si asa, ba kaqu boni tugo si asa osolae kamo totoso lodu sa rimata. ");
INSERT INTO rug_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Be keke tie, si eko turaṉia sa barikaleqe pa totoso sipu kamoa nana minoho barikaleqe si asa, si kaqu koa boni koari ka zuapa rane si asa, meke sa teqe sapu ekoa sa si kaqu boni tugo pa dinoṉo te Zihova. ");
INSERT INTO rug_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Be keke barikaleqe si kamoa na minoho barikaleqe koari kaiqa rane, ba lopu pa totoso tanisa minoho barikaleqe, meke lopu boka makudo si asa, si kaqu koa boni la mo si asa osolae beto sa minoho, gua puta tugo sapu boni si asa koasa totoso kamoa minoho barikaleqe. ");
INSERT INTO rug_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Na teqe babe keketoṉa, sapu ekoa sa babe habotia sa koasa totoso sipu ta kamoe nia sa sa minoho asa, si kaqu boni tugo. ");
INSERT INTO rug_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Sa tie pu tiqudi si kaqu boni tugo; meke kaqu va via i sa sari nana poko, meke kaqu huhuve tugo si asa; ba kaqu boni si asa osolae kamo totoso lodu sa rimata. ");
INSERT INTO rug_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Sipu noso sa nana minoho barikaleqe, si kaqu aqa paki si asa koari ka zuapa rane, meke kaqu tiqe via si asa pa dinoṉo te Zihova. ");
INSERT INTO rug_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Meke koasa rane vina vesu, si kaqu vagi sa si karua kukuva babe karua baruku, meke paleke lani koasa hiama pa sasadana sa Ipi Hopena pa kenuna e Zihova. ");
INSERT INTO rug_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Kaqu va vukivukihi nia sa hiama si keke koa rini, pude na vina vukivukihi tana sinea, meke sapu keke sina vina vukivukihi va uququ; pa siraṉa gua asa si kaqu ta tavete sa vina via madina koasa. ");
INSERT INTO rug_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Kaqu va balau i gamu sari na tinoni Izireli koari na tiṉitoṉa bonidi pude lopu kaqu va bonia rini sa Ipi Hopena meke mate pa kenuna e Zihova, sapu turu pa vari korapana sa kinoa tie.” ");
INSERT INTO rug_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Arini sari na tinarae koasa guguana sa tie muzi laguna meke sa lulua haru, ");
INSERT INTO rug_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","meke sa barikaleqe pa nana totoso minoho barikaleqe, meke sa tie meke sa barikaleqe pu boni sina sa kolo bonina si vura pa tinidia, meke sa tie sapu boni sina eko turaṉia sa sa nana barikaleqe totoso kamo sa minoho barikaleqe. ");
INSERT INTO rug_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Pa mudina sa minate tadi karua tuna koreo e Eroni, sipu tata la ia rini se Zihova meke mate, si zama la koe Mosese se Zihova: ");
INSERT INTO rug_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","“Mu tozi nia sa tasimu se Eroni pude lopu kaqu nuquru hoboro mae pa kenuqu Rau koasa Lose Hopena pa Hopena pa mudina sa poko goba pa nana hiniva soti si asa pude lopu mate si asa. Ura vasina si vura pa korapa lei si Rau pa batuna sa tukutukuna, vasina pu koa ia tinaleosae na vinulasadi sari na sinea koasa Bokese Vinariva Egoi d. ");
INSERT INTO rug_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Guahe si kaqu tavetia e Eroni pana nuquria sa sa lose hopena pa hopena: Kaqu va vukivukihi nia sa si keke bulumakao kokoreo vaqurana pude ta taleosae sari nana sinea, meke keke sipi kokoreo tana vina vukivukihi va uququ. ");
INSERT INTO rug_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Kaqu huhuve va via si asa, beto meke va sagea sa nana poko hopedi sapu sa poko lineni doduruna meke sa poko lineni korapae, sa poko dokoho, meke sa toropae batu tanisa hiama. ");
INSERT INTO rug_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Meke karua sari na qoti kokoreo si kaqu vagi Eroni koari na butubutu Izireli pude na vina vukivukihi tana sinea, meke keke sipi kokoreo pude na vina vukivukihi va uququ. ");
INSERT INTO rug_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Meke kaqu va vukivukihi nia Eroni sa bulumakao kokoreo pude na tinaleosaena sa nana sinea soti telena meke sari na sinea tanisa nana tatamana soti. ");
INSERT INTO rug_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Beto asa si kaqu vagi sa sari karua qoti kokoreo meke kaqu la turaṉi sa pa kenuna e Zihova pa sasadana sa Ipi Hope. ");
INSERT INTO rug_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Meke kaqu mudumudukeda ni karua qoti kokoreo si pude te Zihova meke keke pule pude paleke taloa nia sa sinea. ");
INSERT INTO rug_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Kaqu vagia sa qoti sapu la gua koe Zihova meke va vukivukihi nia sa si asa pude na vinulasana sa sinea. ");
INSERT INTO rug_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Meke sa qoti sapu ele ta vizata koasa mudumudukeda pude paleke taloa nia sa sinea, si kaqu toana, meke ta turaṉa la pa kenuna e Zihova pude na vinulasana sa sinea, meke ta garunu taloa si asa pa korapa qega, pude paleke taloa nia sa sinea tadirini. ");
INSERT INTO rug_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Pana va vukivukihi nia Eroni sa bulumakao pude na tinaleosaena sa nana sinea soti, meke tadi na tie pu koa pa nana tatamana soti, ");
INSERT INTO rug_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","si kaqu vagia sa si keke palepalekeana nika sapu siṉia motete toadi koasa hope vina vukivukihi meke padana karua siniovo lima sapu siṉia na vina uququ oto huda humaṉa lea, meke paleke nuquru lani pa korapa Lose sapu Hopena pa Hopena. ");
INSERT INTO rug_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Meke pa kenuna e Zihova vasina, si kote ta veko sa vina uququ oto humaṉa lea pa nika, meke sa tuṉahana si kote va paeria sa sa tukutukuna sa Bokese Vinariva Egoi, ke lopu kaqu boka mate si asa. ");
INSERT INTO rug_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Meke sari na kakarutuna si kote va boboso nia ehara bulumakao sa sapu va matea sa, meke siburu nia sa koasa tukutukuna sa bokese, meke kaiqa pule si kote siburu lani sa ka zuapa totoso, pa kenuna sa Bokese Vinariva Egoi. ");
INSERT INTO rug_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Meke sipu beto saripu gua arini si kaqu tiqe va matea sa sa qoti tana tinaleosaedi ri na sinea tadi na tie, meke kaqu siburu la nia sa eharana koasa tukutukuna sa Bokese Vinariva Egoi, meke gua tugo pa kenuna bokese kekeṉoṉo gua tugo sapu evaṉia sa koasa eharana sa bulumakao. ");
INSERT INTO rug_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Koasa ginugua asa si kaqu tava hope sa Lose Hopena pa Hopena, koa gua koari doduru binoni na sinea tadi na tinoni Izireli, kaqu tavetia sa sapu gua tugo asa koasa Ipi Hopena, sina koa pa vari korapana sa kinoa tie meke sa binoni tadirini. ");
INSERT INTO rug_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Kaqu loke tie si koa pa korapa Ipi Hope, totoso nuquru la pa korapana sa Lose Hopena pa Hopena se Eroni, pude tavetia sa vina via osolae vura pule si asa, sipu beto tavetia sa sa vinulasana sa nana sinea soti, sa nana tatamana soti, meke sa butubutu Izireli. ");
INSERT INTO rug_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Beto asa si kaqu vura la koasa hope vina vukivukihi se Eroni pa kenuna e Zihova meke tavetia sa vina via tanisa. Kaqu vagi sa si kaiqa ehara bulumakao, meke kaiqa ehara qoti, meke vekoi koari ka made kikiho koari ka made iiona sa hope. ");
INSERT INTO rug_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Meke kaqu va boboso ni ehara Eroni sari na kakarutuna, meke siburu lani sa koasa hope ka zuapa totoso. Meke pa siraṉa gua asa si kaqu va via ia Eroni sa hope koari na sinea tadi na tie Izireli meke va madia sa koe Zihova. ");
INSERT INTO rug_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Pana beto tavetia Eroni sa tinavete vina via tanisa Lose Hopena pa Hopena, sa Ipi Hopena, meke sa hope vina vukivukihi, si kaqu turaṉa mae nia sa sa qoti toana. ");
INSERT INTO rug_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Meke kaqu va oponi limana sa sa qoti toana, meke kaqu helahelae beto ni sa sari doduru tinavete kaleadi na sinea tadi na tinoni Izireli, totoso kilua rini se Zihova, meke veko lani pa batuna sa qoti. Meke kaqu ta garunu taloa sa qoti pa korapa qega, koasa tie ta vizatana pude tavetia sapu gua asa. ");
INSERT INTO rug_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Meke kaqu paleke la nia sa qoti koari na vasidi ivuluna sari doduru dia sinea. ");
INSERT INTO rug_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Beto asa si kaqu nuquru la pa korapa Ipi Hopena se Eroni meke va gorei sa sari na poko hiama saripu va sagei sa tatasana sipu lopu ele nuquru la koa sa Lose Hopena pa Hopena si asa, meke vekoi sa vasina. ");
INSERT INTO rug_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Meke kaqu huve va via si asa pa vasina madina meke tiqe va sagei sari votiki poko hiama, beto asa si kaqu vura la si asa meke tavetia sa vina vukivukihi va uququ pude tanisa meke keke vina vukivukihi va uququ tadi na tinoni Izireli pude taleosae sari nana sinea soti, meke tadi na tinoni Izireli. ");
INSERT INTO rug_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Kaqu va uqua Eroni pa hope sa deanana sa vina vukivukihi tana sinea. ");
INSERT INTO rug_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Sa tie sapu garunu taloa nia sa qoti pa korapa qega koasa toqere Azazela si kaqu popaha va via valeani sari nana poko, meke huve va via, meke tiqe pule la vasina koa sa butubutu tie. ");
INSERT INTO rug_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Sa ehara koa holadi tanisa bulumakao meke sa qoti pude na vina vukivukihi tana sinea, saripu ta paleke nuquru eharadi pude na vina viana sa Lose Hopena pa Hopena, si kaqu ta paleke vura turaṉae koari na kapudi, na masadi meke sari na lagudi pa valena sa popoa pu koa rina tie meke kaqu ta sulu palae vasina. ");
INSERT INTO rug_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Sa tie sapu evaṉia sa vina uququ si kaqu popaha va via i sari nana poko meke huve va via tugo meke tiqe pule la koari na tie. ");
INSERT INTO rug_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Sa tinarae hie si kaqu tamugamu na tinoni Izireli doduru totoso meke sari na votiki tie pu karovodi mae pu koa koa gamu. Doduru vuaheni koasa rane vina manege puta koasa sidara vina zuapa si kaqu koa madi pa ginani si gamu meke lopu tavetavete. ");
INSERT INTO rug_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Koasa rane sana si kaqu taleosae sari na mia sinea koasa tinavete hiama pa vina vukivukihi meke tinavete vina via, meke kaqu taleosae meke via si gamu pa kenuna Zihova. ");
INSERT INTO rug_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Meke pa doduru vuaheni sa rane asa si kaqu na rane hopena hola, meke asa sa rane sapu kaqu va madia gamu pude lopu henahena meke lopu kaqu hite tavetia gamu si keke tinavete hokara. ");
INSERT INTO rug_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Sa ṉati hiama kenukenue sapu ta zoropo oela hopena pa batuna, meke tava madi si asa, sapu kaqu sogo hobea sa tamana si kaqu tavetia sa vina vukivukihi tana sinea. Asa tugo si kaqu va sagei sari na poko lineni meke sari na poko hopedi, ");
INSERT INTO rug_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","meke kaqu tavetia sa sa tinavete tana tinaleosaena sa sinea koa sa Lose Hopena pa Hopena, koa sa Ipi Hopena, koasa hope vina vukivukihi, koari na butubutu hiama, meke tadi doduru tinoni koasa butubutu Izireli. ");
INSERT INTO rug_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Sari na tinarae hire si kaqu ta kopue koari doduru vuaheni mae hiroi. Keke totoso pa vuaheni si kaqu ta tavete sa tinaleosaedi ri na tinoni Izireli koa ri na dia sinea.” Ke kekeṉoṉo gua arini si taveti e Mosese koasa ginarunu te Zihova. ");
INSERT INTO rug_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Tozi nia Zihova se Mosese, ");
INSERT INTO rug_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Mamu tozi nia koe Eroni meke koari na tuna koreo, meke koari doduru tinoni Izireli sari na tinarae hire: ");
INSERT INTO rug_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","4","Lopu boka va matea keke tie Izireli si keke bulumakao, keke sipi, babe keke qoti koari doduru vasina, pude vina vukivukihi la koe Zihova, ba mamu la koasa sasadana sa Ipi Hopena pa kenuna e Zihova. Be va matea keke tie si keke kurukuru pa vasileana babe pa hiqohiqo ba sekea sa sa tinarae te Zihova, meke sa tinavete asa si kekeṉoṉo gua tugo sapu va mate tie si asa. Ele zoloro sa eharana, meke namu lopu kaqu koa hola koari na tie Izireli si asa. ");
INSERT INTO rug_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Sa ginuana sa tinarae hie si pude sari na tinoni Izireli si madi paleke maeni kamahire koe Zihova sari na kurukuru saripu hoke va matei rini pa korapa hiqohiqo. Kaqu paleke maeni rini si arini kamahire koasa hiama pa sasadana sa Ipi Hopena meke va vukivukihi ni pude na vina vukivukihi binaere koe Zihova. ");
INSERT INTO rug_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Sa hiama si kaqu siburu nia sa ehara koasa Hope pa sasadana sa Ipi Hopena meke va uqua sa deanana, pude sa hibina si ta qetue koa Zihova. ");
INSERT INTO rug_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Sari na tinoni Izireli si lopu kaqu va karia se Zihova meke mate hobori sari na dia kurukuru pa korapa soloso meke va vukivukihi lani koasa tomate qoti pa vinahesi beku. Kaqu kopu nia ri na tinoni Izireli sa tinarae hie koari doduru totoso mae hiroi. ");
INSERT INTO rug_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Mamu zama nia koari na tinoni Izireli sapu gua hie: Be keke tie Izireli babe keke tie karovona saripu korapa koa pa korapa mia gamu, si va vukivukihi va uququ babe keke votiki vina vukivukihi, ");
INSERT INTO rug_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","meke lopu va vukivukihi la koe Zihova pa sasadana sa Ipi Hopena pa kenuna e Zihova, si namu lopu kaqu koa hola koari na tie Izireli si asa. ");
INSERT INTO rug_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Be keke tie Izireli babe keke tie karovona saripu korapa koa pa korapa butubutu, si henai masa pu koai eharadi, si kaqu kanai e Zihova si arini, meke kaqu hitu taloani Sa koari Nana tinoni si arini. ");
INSERT INTO rug_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Ura sa tinoa tadi doduru tiṉitoṉa toadi si koa koasa eharana sa. Meke sa ehara si ta poni koa gamu pude vulasa pani sari na mia sinea koasa hope te Zihova. Sari doduru ehara si kaqu zoloro vura koasa hope pude taleosae sari na mia sinea meke lopu mate si gamu. ");
INSERT INTO rug_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Gua asa ke zama si Rau koari na tinoni pa Izireli sapu loke tie koa gamu: sari na tie Izireli babe sari na tie karovodi si kaqu gania sa masa sapu koa ia na ehara. ");
INSERT INTO rug_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Be na tie Izireli babe na tie karovona sapu koa pa korapana sa butubutu, si vagia si keke kurukuru ṉame babe keke kurukuru tapuru sapu viana pa dinoṉo te Zihova, si kaqu va zoloro pania sa sa eharana pa pepeso meke tamunu nia pepeso. ");
INSERT INTO rug_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Sa tinoa tadi doduru tiṉitoṉa toadi si koa koasa ehara, gua asa ke zamai e Zihova sari na tinoni Izireli, pude lopu hena ia rini sa masa sapu korapa koa ia ehara; babe gania rini si asa, si kaqu ta hitu palae koasa butubutu Izireli. ");
INSERT INTO rug_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Be keke tie Izireli babe tie karovona, si dogoria si keke kurukuru matena babe sapu tava mate koari na kurukuru pinomodi meke hena ia sa sa masana, si kaqu sopu i sa sari nana poko, meke huhuve, meke koa aqa osolae kamo sa totoso lodu sa rimata meke tiqe kaqu via pa dinoṉo te Zihova si asa meke boka somana pule koari na tie Izireli. ");
INSERT INTO rug_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Be lopu sopu i sa sari nana poko meke lopu huhuve si asa, si kaqu ta goreini tugo sa sari nana sinea.” ");
INSERT INTO rug_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Zama la ia e Zihova se Mosese, ");
INSERT INTO rug_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Mamu tozini sari na tinoni Izireli: Arau se Zihova sa mia Tamasa. ");
INSERT INTO rug_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Mi lopu tavete luli gamu sari na tinavete kaleadi pu taveti ri na tinoni pa popoa Izipi, vasina pu ele koa ia gamu, babe sari na tinoni pu koadi pa popoa Kenani, vasina pu korapa turaṉa lani gamu Rau kamahire. ");
INSERT INTO rug_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Mi va tabei sari na Qua tinarae, mamu taveti gua sapu garununi gamu Rau. Arau se Zihova sa mia Tamasa. ");
INSERT INTO rug_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Mi luli na taveti sari na Qua tinarae saripu ponini gamu Rau; ura sa tie pu va tabei sari na Qua tinarae si kaqu toa. Arau se Zihova. ");
INSERT INTO rug_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Loke tie koa gamu si kaqu eko turaṉia pa tinavete vinari riqihi si keke turaṉana soti pa pinodo. Arau se Zihova. ");
INSERT INTO rug_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Mu lopu va kurekurea goi sa tamamu pude eko turaṉia sa tinamu. Mu lopu va kurekurea goi sa tinamu soti. ");
INSERT INTO rug_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Mu lopu va kurekurea goi sa tamamu pude eko turaṉia sa nana barikaleqe sapu sa tinamu karokarovo. ");
INSERT INTO rug_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Mu lopu eko turaṉia goi sa vavenemu babe sa tasimu vinatakele tanisa tamamu babe tanisa tinamu, be podona koasa mua vetu soti ba be pa votiki vasina. ");
INSERT INTO rug_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Mu lopu eko turaṉia goi sa tuna sa tumu koreo babe sa tuna sa tumu barikaleqe, ura kote kurekure si goi. ");
INSERT INTO rug_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Mu lopu eko turaṉia goi sa tasimu karokarovo sapu sa tuna sa tinamu karokarovo, ura asa ba na tasimu vineki tugo. ");
INSERT INTO rug_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","13","Mu lopu eko turaṉia goi sa tasina barikaleqe sa tamamu babe tinamu. Ura na turaṉamia soti pa pinodo si asa. ");
INSERT INTO rug_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Mu lopu eko turaṉia goi sa barikaleqe tanisa tasina koreo sa tamamu, ura asa ba na buhimu goi. ");
INSERT INTO rug_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Mu lopu eko turaṉia goi sa mua roroto. Asa sa barikaleqe sina tumu, ");
INSERT INTO rug_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","babe sa barikaleqe tanisa tasimu koreo. ");
INSERT INTO rug_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Mu lopu eko turaṉia goi sa tuna vineki sa mua barikaleqe. Meke lopu kaqu eko turaṉia tugo goi sa tuna sa tuna vineki sa mua barikaleqe, babe na tuna vineki sa tuna koreo sa mua barikaleqe. Ura na turaṉamu soti mo goi si arini, meke lopu leana sapu gua asa. ");
INSERT INTO rug_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Mu lopu haba ia goi sa tasina barikaleqe sa mua barikaleqe, sipu korapa toana sa mua barikaleqe soti. ");
INSERT INTO rug_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Mu lopu eko turaṉia goi pa totoso kamoa na minoho barikaleqe sa barikaleqe. Ura na lopu via si asa pa kenuqu Rau. ");
INSERT INTO rug_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Mu lopu eko turaṉia goi, si keke barikaleqe tanisa turaṉamu, sina lopu kaqu via si goi pa kenuqu Rau. ");
INSERT INTO rug_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Mu lopu va vukivukihi lani pa vinahesina sa tamasa Moleki sari kaiqa mia koburu, ura kote ṉoṉovalia goi sa pozaqu Rau e Zihova sa mia Tamasa pa siraṉa gua asa. ");
INSERT INTO rug_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Mu lopu eko turaṉia goi si keke tie pa tinavete vinari riqihi, guana keke barikaleqe, namu kaleana hola koe Tamasa sapu gua asa. ");
INSERT INTO rug_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Loke tie babe keke barikaleqe si kaqu papa ia si keke kurukuru ṉame. Ura sa sinea gua asa si boni hola pa kenuqu Rau. ");
INSERT INTO rug_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Mi lopu va boni sari na mia tinoa koari na tinavete gua arini. Ura gugua arini sari na tinavete bonidi pu taveti ri na tie huporo, saripu koadi tatasana sipu lopu ele mae si gamu pa popoa Kenani, meke Arau e Zihova si kaqu hadu vurani, pude boka nuquru la si gamu vasina. ");
INSERT INTO rug_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Sari na tinavete kaleadi tadirini si va bonia sa pepeso, gua asa ke tava kilasa si asa koe Zihova. Kote ta hitu sari na tinoni pa popoa Kenani kekeṉoṉo gua sapu sa tie si lua vura nia sa ginani kaleana. ");
INSERT INTO rug_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","27","Sari na tie hire si taveti sari na tinavete kaleadi gugua arini meke va bonia rini sa popoa; ba gamu si lopu kaqu taveti sari na tinavete gugua arini. Gamu doduru mo, be na tie Izireli si gamu, babe na tie karovodi pu koa somanae koa gamu, si kaqu va tabei sari na tinarae na zinama te Zihova. ");
INSERT INTO rug_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Be guana taveti gamu sari na tinavete kaleadi sara, si kaqu va bonia gamu sa popoa meke kaqu ta hitu vura si gamu koasa popoa kekeṉoṉo gua sapu lua vurani sa tie sa ginani kaleana, meke kekeṉoṉo gua sapu ta hadu vura sari na tinoni pu koadi vasina tatasana, sipu lopu ele mae si gamu. ");
INSERT INTO rug_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Gilania, mia gamu sapu be taveti gamu sari na tinavete kaleadi gugua arini, si kaqu ta hitu palae koasa butubutu Izireli si arini. ");
INSERT INTO rug_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Mi va tabei gamu sari na tinarae saripu ponini gamu Rau; mamu lopu luli sari na tinavete pu tavetaveti ri na tinoni pu ele koadi koasa popoa sana tatasana, sipu lopu ele mae gamu. Mamu lopu va boni sari na mia tinoa koari na tinavete kaleadi gugua arini. Arau se Zihova sa mia Tamasa.” ");
INSERT INTO rug_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Meke tozi nia e Zihova se Mosese, ");
INSERT INTO rug_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“mamu tozini sari na tinoni Izireli, ‘Mi koa madi, via, meke toṉoto si gamu, ura Arau Zihova, sa mia Tamasa sina Tamasa madiqu, viaqu, meke toṉoto, gua. ");
INSERT INTO rug_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Hopeke gamu doduru si kaqu pamaṉa nia sa tinamu meke tamamu, meke kopu nia sa rane Sabati, gua puta tugo sapu garununi Rau koa gamu, ura Arau tugo se Zihova sa mia Tamasa. ");
INSERT INTO rug_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Mu lopu kekere la na vahesi sari na beku; babe taveti pa aeana na qolo na siliva na gua sari na tamasa beku pude tamugamu, ura Arau tugo se Zihova sa mia Tamasa. ");
INSERT INTO rug_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Totosona pu tavetia gamu sa vina vukivukihi tana binaere la koe Zihova si mi tavete la nia koa Sa pa siraṉa gua sapu kaqu ta qetue koa Sa. ");
INSERT INTO rug_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Sa masana sa kurukuru sapu tava mate si kaqu ta hena tugo koasa rane asa, babe pa koivugona. Meke be koa hola meke kamoa sa vina ṉeta rane si kaqu ta sulu va murimuri beto si arini. ");
INSERT INTO rug_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Be ta hena koa keke tie si asa koasa rane vina ṉeta si lopu via si asa, meke lopu kaqu ta qetue si asa koe Zihova. ");
INSERT INTO rug_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Ba be hena ia keke tie si asa si sea mo si asa, sina ele tavetavete hoboro nia sa sapu ele tava madina koe Zihova, meke namu lopu kaqu koa hola koari na tie Izireli si asa. ");
INSERT INTO rug_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Pana pakepakete si gamu koari na mia inuma, si mamu lopu pakepakete kamo la gua pa hukihukiridi ri na inuma, meke lopu kaqu pule la si gamu meke seke vagi gamu batudi sari na huiti saripu koa holadi vasina. ");
INSERT INTO rug_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Mu lopu pule la pa korapana sa mua inuma vaeni pude pudiki luli vagi sari na vua qurepi d saripu lopu vagi goi babe tava hoqa palae; mamu veko vala i koari na tie malaṉadi babe na tie karovodi. Ura Arau tugo se Zihova sa mia Tamasa. ");
INSERT INTO rug_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Mu lopu hiko na sekesekei na kokoha. ");
INSERT INTO rug_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Mu lopu zama kokoha pa tinokotokoro koasa pozaqu Rau, ura kote ta ṉoṉovala sa pozaqu Rau. Ura Arau se Zihova sa mia Tamasa. ");
INSERT INTO rug_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Mu lopu sekesekei nia na ṉoṉovalia goi sa turaṉamu babe hikoi sari na likakalae tanisa. Mamu lopu tuqe va seunae nia keke boṉi goi sa tinabarana keke tie tavetavete. ");
INSERT INTO rug_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Mu lopu zama va kaleania goi sa tie nulina babe veko nia keketoṉa goi sa kenuna sa tie behuna pude vata tubarae nia. Ba mu va tabe Au, ura Arau se Zihova sa mia Tamasa. ");
INSERT INTO rug_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Mamu zama va hinokara na balabala va toṉoto, pana vizavizata si gamu koari na binalabala tana tinarae pa vinaripitui. Mu lopu toka kaleania sa tie habahuala babe sa tie tagotagona, ba pa tinoṉoto si kaqu pitua goi sa tie. ");
INSERT INTO rug_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Mu lopu ene varikarovae na zama ṉoṉovala koari na tie, babe ele ta zutu si keke tie, si mamu zama hinokara pude lopu kaqu mate si asa pa zinutu kokoha. Ura Arau se Zihova sa Mia Tamasa. ");
INSERT INTO rug_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Mu lopu kuhana nia pa korapa bulomu sa turaṉamu. Ba mamu nore va toṉotia si asa, pude lopu kaqu somana nia goi sa nana sinea. ");
INSERT INTO rug_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Mu lopu tubehia goi si keke tie babe kana la ia mo goi si asa doduru totoso, ba mu tataru nia si asa gua puta tugo sapu tataru pule nigo telemu si agoi, ura Arau se Zihova. ");
INSERT INTO rug_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Mu va tabei sari na qua tinarae hire: Mu lopu varivari papani sari na votiki kurukuru. Mu lopu letei sari karua votiki kiko pa keke ilaka. Mu lopu va sagea sa poko sapu ta piti varisotoi koari karua poko votikaedi. ");
INSERT INTO rug_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Be keke vineki sina pinausu tana keke tie pu pausuna, meke ta vizata vekona si asa, ba lopu ele ta veko pinirovetuna si asa, meke va sea ia keke tie si asa sipu lopu ele ta rupahana si asa koasa tie pu pausuna, si kaqu tava kilasa si arini; ba lopu kaqu tava mate sari karua hire, sa vineki meke sa tie pu va sea ia, sina lopu ele ta rupahana sa vineki hie. ");
INSERT INTO rug_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Kaqu paleke mae nia sa tie si keke sipi kokoreo pa sasadana sa Ipi Hope, pude na vina vukivukihi tinaleosae koe Zihova. ");
INSERT INTO rug_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Kaqu vagia sa hiama sa sipi kokoreo meke tavetia sa sa vina vukivukihi tinaleosae pa kenuna e Zihova pude na vinulasana sa nana sinea sapu ele tavetia sa, si kaqu tiqe taleosae koe Zihova. ");
INSERT INTO rug_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Pana kamoa gamu sa popoa Kenani meke letei sari na vua huda, si kaqu balabala ni bonidi gamu sari na vua huda koari ka ṉeta vuaheni kekenu. Koari vuaheni arini si lopu kaqu henai gamu sari na vuadi rini. ");
INSERT INTO rug_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Meke koasa vuaheni vina made si kaqu tava madi sari doduru vua huda pude na vinariponi vinahesina e Zihova si arini. ");
INSERT INTO rug_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Ba koasa vuaheni vina lima si boka henai gamu sari na vuadi. Be lulia gamu sapu gua asa, si kote vua va sokusoku sari na mia huda. Arau se Zihova sa mia Tamasa. ");
INSERT INTO rug_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Mu lopu henai sari na masa saripu koai eharadi. Mu lopu tavetavete potana, babe hata tinokae koari na tomate. ");
INSERT INTO rug_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Mu lopu koto va kaleani sari na kalu pa karua kalina sa batumu meke sari na gumi pa asemu, ");
INSERT INTO rug_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","meke lopu kubekubere ia sa tinimu babe magumagua pude vata dogoro nia sa tinalotaṉana sa tie pu matena, ura Arau se Zihova. ");
INSERT INTO rug_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Mu lopu vata evaṉae nia zelepade maqota goi sa tumu vineki. Be ta evaṉa sapu gua asa si kote siṉia na maqota meke na kinaleana pa vinahesi beku sa doduru popoa. ");
INSERT INTO rug_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Kaqu kopu nia gamu sa rane Sabati, mamu pamaṉa nia sa Qua Zelepade, vasina tavahesi si Rau, arau se Zihova. ");
INSERT INTO rug_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Mu lopu la tepa tinokae koari na tie vakuvakutaedi na tie matemateana. Be tavete gua asa si goi si kote na tie nerumu si goi. Ura Arau se Zihova sa mia Tamasa. ");
INSERT INTO rug_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Mu pamaṉani na va lavati sari na barogoso na kaleqe. Mu pamaṉa Nau si Arau sa mua Tamasa; ura Arau se Zihova. ");
INSERT INTO rug_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Mu lopu ṉoṉovali sari na tie karovodi pu koadi pa mua popoa. ");
INSERT INTO rug_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Ba mu kopu guni mo na turaṉamu soti pa mua popoa pa Izireli. Mu tataru kekeṉoṉo guni gua pu tataru pulenigo. Mu balabala ia sapu gamu ba gua tugo, na tie karovomia mo totoso koa pa Izipi si gamu. Ura Arau se Zihova sa mia Tamasa. ");
INSERT INTO rug_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Mu lopu sekesekei pa pinadapada pa ginele, na minamata meke sinoku. ");
INSERT INTO rug_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Kaqu gotogoto meke hinokara sari na mia pinadapada pa ginele, na minamata, na sinoku, meke na pada kolo. Ura Arau se Zihova sa mia Tamasa. ");
INSERT INTO rug_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Mamu va tabei gamu sari doduru Qua tinarae na zinama. Ura Arau se Zihova.’ ” ");
INSERT INTO rug_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Zama la koe Mosese se Zihova, ");
INSERT INTO rug_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Mamu tozini sari na tinoni Izireli: be keke koa gamu babe keke tie karovona pu va malumu valani sari kaiqa nana koburu pude va vukivukihi lani koe tamasa Moleki pa vinahesina, si kaqu ta gona va mate patu koari doduru tinoni Izireli si asa. ");
INSERT INTO rug_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Be keke tie si vala nia koe tamasa Moleki si keke koari nana koburu meke tava boni sa Qua Ipi Hope, meke lopu ta pamaṉae sa Pozaqu, si kaqu kanaia Rau si asa, meke kilu pania Rau koari na tie Izireli si asa. ");
INSERT INTO rug_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Ba be sa butubutu lopu va matea si asa, ");
INSERT INTO rug_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","si Arau mo kote kanaia sa tie sana meke sa doduruna sa nana tatamana, meke arini tugo pu somana koasa, saripu lopu kalavarae koa Rau, meke vahesia tu rini se tamasa Moleki. Kaqu kilu pani Rau si arini koari na tie Izireli. ");
INSERT INTO rug_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Be keke tie si la tepa tinokae koari na tie pu tago potana kaleadi, pude tepani tinokae sari na tomate pu ele matedi gua. Asa tugo kaqu kanaia Rau, meke kote kilu pania Rau koari na tie Izireli si asa. ");
INSERT INTO rug_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Mi koa madi, via, na toṉoto si gamu doduru totoso pa mia tinoa sina Arau tugo se Zihova sa mia Tamasa. ");
INSERT INTO rug_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Mi va tabei sari na Qua tinarae sina Arau tugo se Zihova si ele va madi gamu, va via gamu, meke va toṉoto gamu si gamu. ");
INSERT INTO rug_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Asa sapu zama ṉoṉovali sari na tiatamadia si kaqu tava mate tugo; sa minate asa si nana tugo telena. ");
INSERT INTO rug_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Be keke tie si baratia sa barikaleqe tanisa keke turaṉana, sari karua, sa tie meke sa barikaleqe, si kaqu tava mate beto; meke sa minate si dia mo ri kara teledia. ");
INSERT INTO rug_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Be keke tie si koa turaṉia sa barikaleqe tanisa tamana, na lopu pamaṉa nia sa sa tamana. Sari karua, sa tie meke sa barikaleqe, si kaqu tava mate beto. Sa minate asa si dia mo ri karua teledia. ");
INSERT INTO rug_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Be keke tie si koa turaṉia sa barikaleqe tanisa nana roroto, si kaqu tava mate beto sari karua, sina na kaleana hola sa tinavete asa, meke sa dia minate si dia soti mo teledia. ");
INSERT INTO rug_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Be karua tie si vari koa turaṉi pa tinavete vinari riqihi, si kaleana hola sapu gua tavetia ri karua; sari karua si kaqu tava mate beto, meke sa minate asa si dia mo teledia. ");
INSERT INTO rug_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Be keke tie si haba varigarani si karua tamatina, sa tuna vineki meke sa tinana, sari ka ṉeta si kaqu ta sulu va mate beto pa nika, sina kaleana hola gua sapu tavetia rini. Mamu lopu taveti sapu gua asa pude lopu ta evaṉa pule sa sinea asa pa korapa mia gamu. ");
INSERT INTO rug_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Be keke tie si papa ia si keke kurukuru ṉame, sa tie meke sa kurukuru ṉame si kaqu tava mate beto. ");
INSERT INTO rug_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Be keke barikaleqe babe vineki si podekia pude papa ia si keke kurukuru si kaqu tava mate beto si arini. Sa minate asa si dia mo ri karua teledia. ");
INSERT INTO rug_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Be haba ia keke tie sa vavenena soti babe sa tasina vinatakele, si kaqu tava kurekure pa kenudi ri na tinoni meke kaqu ta hitu palae koasa butubutu si arini. Na ele koa turaṉia sa sa tasina ke garodi tugo pude kaqu tava kilasa beto sari kara. ");
INSERT INTO rug_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Be keke tie si koa turaṉia si keke barikaleqe sapu kamoa minoho tadi barikaleqe, sari karua arini si kaqu ta hitu vura beto koasa butubutu Izireli, sina va dogoro nia rini sa ehara. ");
INSERT INTO rug_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Mu lopu koa turaṉia sa buhimu barikaleqe sina pude gua asa si va kurekurei goi sari na turaṉamu soti, meke kaqu tava kilasa sisigiti beto si gamu kara. ");
INSERT INTO rug_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Be keke tie si koa turaṉia sa barikaleqe tanisa buhina si va kurekurea sa sa buhina. Sa tie meke sa barikaleqe si kaqu tava kilasa. Lopu kaqu vagi koburu sari karua. ");
INSERT INTO rug_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Be keke tie si vagia sa sa barikaleqe tanisa tasina, si lopu kaqu vagi koburu sari karua osolae mate, sina na tinavete bonina sapu gua tavetia ri karua, meke va kurekurea sa sa tasina.” ");
INSERT INTO rug_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Zama se Zihova, “Mi kopuni na va tabei sari doduru Qua zinama na tinarae, pude lopu kaqu ta hitu taloa si gamu koasa popoa Kenani, vasina pu turaṉa va kamoni gamu Rau. ");
INSERT INTO rug_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Mi lopu luli sari na hahanana tadi na tinoni pu koadi vasina pu kaqu hadu taloani Rau pude mi koa ia sa popoa. Etulu pani Rau si arini sina ele va bugoro sisigiti Au rini koari na dia tinavete kaleadi. ");
INSERT INTO rug_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Ba koa gamu si ele va tatara nia Rau sa popoa sana vasina sokua na pepeso masuruna, meke toqolo valeania na linetelete pude maqu ponini gamu. Arau se Zihova sa mia Tamasa sapu ele vizata vata kale gamu si gamu koari butubutu huporo. ");
INSERT INTO rug_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Ke kaqu vizavizata valeana si gamu koari na vinotikaedi rina kurukuru ṉame na kurukuru tapuru bonidi na viadi. Mi lopu henai sari na kurukuru ṉame na kurukuru tapuru saripu lopu viadi. Na ele tozi vurani Rau saripu bonidi si arini, meke be henai si kote boni si gamu. ");
INSERT INTO rug_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Kaqu koa na tie va madi mia, via, na toṉoto si gamu, sina Arau se Zihova si madiqu, via, na toṉoto tugo si Rau. Ele vizata vata kale gamu tu Rau koari kaiqa butubutu, pude taqarau mo telequ si gamu. ");
INSERT INTO rug_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Be keke tie babe barikaleqe sina tie vakuvakutae, na tie matemateana, meke tepatepa tinokae la koari na maqomaqodi ri pu ele matedi, si kaqu ta gona va mate patu, meke sa nana minate si nana telena soti.” ");
INSERT INTO rug_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Zamaia e Zihova se Mosese, “Mu tozini sari na hiama, sari doduru tuna koreo Eroni: Pana mate si keke turaṉamu, loke tie koa gamu na hiama si kaqu ene tata koa keke tie matena babe va boni puleni gamu telemia. ");
INSERT INTO rug_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Be guana lopu na turaṉamu soti mo pa nana pinodo, na tinamu soti, tamamu, tumu koreo, tumu vineki, meke na tasimu koreo soti, ");
INSERT INTO rug_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","babe keke tasimu vineki vaqurana pu koa pa mua kinopu pu lopu ele varihabana, arini pu tata sisigiti koari na dia pinodo, si boka tiqui goi, pude boka va boni puleni gamu telemia koasa hahanana minate. ");
INSERT INTO rug_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Ba lopu boka va boni puleni gamu koa rina tie matedi pu na turaṉamia pa vinarihaba. ");
INSERT INTO rug_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Loke hiama si kaqu neri va pakaia sa batuna, babe neria sa hukihukiri gumina babe magu va bakoria tinina pude vata dogoro nia sa nana tinalotaṉana sa tie matena. ");
INSERT INTO rug_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Kaqu koa via na madi si asa pa dinoṉo te Zihova, meke lopu kaqu va kaleania sa sa pozana sa Tamasa; kaqu koa madi na via si asa, sina va vukivukihi nia sa koe Zihova sari na vinariponi pa nika pude na ginani te Tamasa. ");
INSERT INTO rug_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Sa hiama si lopu kaqu haba ia si keke maqota, babe sa tie ta luluarana pa nana palabatu, sina kaqu koa via na madi koasa dia Tamasa si asa. ");
INSERT INTO rug_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Kaqu doṉo gilania ri na tie sapu na tie madina sa hiama, sina va vukivukihi nia sa koa Rau Zihova, sa vinariponi ginani. Madiqu na viaqu si Arau, ke kaqu va madi na va via i tugo Rau sari na Qua tie. ");
INSERT INTO rug_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Be ta evaṉae guana maqota sa tuna vineki sa hiama, si va kurekurea sa sa tamana; kaqu ta sulu va mate pa nika si asa. ");
INSERT INTO rug_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Sa ṉati hiama kenukenue sapu ele ta vizatana koari na tasina meke ele ta zoropae oela vina madi sa batuna, meke va sagei sari na poko tana hiama si lopu kaqu besu nia sa sa tie matena babe rikati sa sari nana poko, ba kaqu suti sa sari na kaluna pude va dogoro nia sapu via si asa. ");
INSERT INTO rug_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","12","Be mate si keke tie gugua tugo na tamana babe na tinana soti, ba lopu kaqu nuquria sa sa vetu vasina pu koa sa tie matena, sina ele tava madina si asa koasa oela hopena te Tamasa. Lopu kaqu vura si asa koasa Ipi Hopena te Zihova pude va boni pule nia koasa hahanana minate. ");
INSERT INTO rug_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","14","Lopu kaqu haba ia sa sa vineki pu koa turaṉa tie, babe keke nabonaboko, babe keke barikaleqe ta luluarana, babe keke maqota. Kaqu haba ia mo sa sa vineki sapu lopu hite koa turaṉa tie sapu mae guana koasa nana butubutu soti. ");
INSERT INTO rug_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Pude lopu kaqu tava boni pa dinoṉo te Zihova sari na tuna koari na tinavete kaleadi gugua arini. Ura Arau se Zihova sapu ele va madia si asa pude na ṉati hiama kenukenue.” ");
INSERT INTO rug_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Zamaia e Zihova se Mosese, ");
INSERT INTO rug_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Mu tozi nia se Eroni, ‘Namu loke tie pa tutimu koari na sinage vugo na repere sapu koa ia binoni si kaqu paleke mae nia sa vinariponi ginani koa Rau. ");
INSERT INTO rug_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Namu loke tie sapu koa ia boni si kaqu somana pa tinavete hiama, be na tie behuna, na ike, na tie koele, ");
INSERT INTO rug_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","babe bakora limana babe nenena, ");
INSERT INTO rug_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","babe na tie polosuri, na tie mamagoria, na tie kiqo matana, na minoho kaleana pa kapuna, babe na tie puzalana. ");
INSERT INTO rug_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Namu loke tie pa tutina Eroni, sa hiama sapu koa ia na binoni si kaqu va vukivukihi mae nia koa Rau sa vinariponi ginani. ");
INSERT INTO rug_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Sa tie gua asa si boka hena ia sa sa ginani sapu tava vukivukihi mae koa Rau, sari doduru ginani hopedi meke saripu hopedi hola pu va vukivukihi maeni rini, ");
INSERT INTO rug_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","ba koa gua sapu koa ia na boni si asa, ke lopu kaqu tata mae koasa poko goba pa Lose Hopena si asa, babe tata la ia mo sa sa hope vina vukivukihi. Namu lopu kaqu va boni sa sari na tiṉitoṉa hire. Arau se Zihova sapu va madi gamu pude na hiama.’ ” ");
INSERT INTO rug_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Ke tozini e Mosese sari na zinama arini koe Eroni, sari na tuna koreo, meke koari doduru tinoni pa popoa Izireli. ");
INSERT INTO rug_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Zama se Zihova koe Mosese, ");
INSERT INTO rug_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Mu tozini sari Eroni meke sari na tuna koreo, ‘Kaqu va lavatia gamu sa Pozaqu Hopena. Kaqu pamaṉani gamu sari na vinariponi hopedi pu va madini rina tinoni Izireli koa Rau. Ura Arau se Zihova. ");
INSERT INTO rug_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Be keke tie koasa tutimu goi vugo na repere sapu bonina pa dinoṉo te Zihova si ene tata maei sari na vinariponi na vina vukivukihi pu va madini ri na tinoni Izireli koa Rau, sa tie sana si mani lopu somana pule pa tinavete hiama pa kenuqu Rau, sina Arau se Zihova. ");
INSERT INTO rug_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Be keke tie koasa tutina Eroni pu koa ia na minoho kaleana pa kapuna, babe muzi laguna si lopu boka henai sari na vinariponi hopedi, osolae via si asa meke ta salaṉa koasa nana minoho. Sa hiama si boka tava boni be tiqua sa si keke tiṉitoṉa sapu tiqua na tiṉitoṉa bonina, be na tini matena, babe sa tie lulua haruna, ");
INSERT INTO rug_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","babe tiqua sa si keke votiki tiṉitoṉa bonina babe keke kurukuru bonina, babe keke tie sapu bonina. ");
INSERT INTO rug_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","7","Sa hiama sapu va bonibonie si kaqu boni hola nana tugo, osolae kamo totoso lodu sa rimata. Lopu boka henai sa sari na ginani hopedi osolae lodu sa rimata meke huhuve si asa, beto asa si kaqu tiqe henai sa sari na vinariponi ginani madidi. ");
INSERT INTO rug_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Lopu kaqu hena ia sa sa masana sa kurukuru sapu mate hoboro, babe sapu tava mate koa ri na kurukuru pinomodi. Ura kote tava boni si asa koarini. Arau se Zihova. ");
INSERT INTO rug_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Gua asa ke kaqu kopuni ri na hiama sari na tinarae saripu ponini Rau koa rini, pude lopu kaqu tava kilasa si arini koa rina dia sinea meke mate, sipu va kari rini sari na tinarae madidi. Ura Arau se Zihova pu va madidi rini. ");
INSERT INTO rug_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Sa tie sapu podo vura maena mo pa korapana sa tatamana hiama si boka henai sari na vinariponi ginani hopedi; loke tie pule si kaqu henai si arini. Namu loke tie enene pu somana koa koasa hiama babe na tie ta tabaradi koasa hiama si kaqu somana henai si arini. ");
INSERT INTO rug_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Ba sari na pinausu mo tanisa hiama pu holuni sa koasa nana poata soti babe podona pa nana vetu si boka hena ia sa ginani sapu vagia sa hiama. ");
INSERT INTO rug_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Sa tuna vineki sa hiama sapu haba ia si keke tie, sapu lopu na hiama si lopu kaqu henai sa sari na vinariponi ginani hopedi. ");
INSERT INTO rug_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Ba be naboko sa barikaleqe sana, babe sa barikaleqe ta luluarana sapu loke tuna, meke pule la koa pule pa vetu tanisa tamana telena eke, si boka hena ia sa sa ginani tanisa tamana sapu sa hiama sapu ta vagi koari na vinariponi ginani hopedi tadi na tie. ");
INSERT INTO rug_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Be keke votiki tie pu lopu koa koasa tatamana si lopu va nonoga ia meke hena hola ia sa si keke koa ri na ginani hopedi sapu ta poni koari na hiama, si kaqu hobe pulea sa sa doduruna sa laena meke tomo la nia koa sa si ka hiokona puta paseniti padana meke vala nia koasa hiama. ");
INSERT INTO rug_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Ke sari na ginani hopedi saripu valani ri na tinoni Izireli koe Zihova si lopu kaqu sasuru nia ri na hiama, ");
INSERT INTO rug_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","meke va malumu lani koari na tie pu lopu na hiama pude hena hobori, na kote va sea meke tava kilasa sa tie gua asa. Ura Arau se Zihova sapu va madidi si arini.’ ” ");
INSERT INTO rug_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Zama se Zihova koe Mosese, ");
INSERT INTO rug_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Mu la, mamu tozi sari na tinarae hire koe Eroni, koari na tuna koreo meke koari doduru tinoni Izireli: ‘Be keke tie pa butubutu Izireli, babe keke tie karovona sapu koa pa Izireli, si hiva ponia si keke vinariponi vina vukivukihi va uququ pude va gorevura ia gua sapu va tatara nia sa babe na dia vinariponi pa nana hiniva soti koe Zihova, ");
INSERT INTO rug_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","si kaqu na kokoreo sa kurukuru asa, meke loke ari kisakisana pa tinina. Be lopu gua asa Arau Zihova si lopu kaqu qetu nia. ");
INSERT INTO rug_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Be keke tie si ponia si keke kurukuru kaleana si lopu kaqu ta qetue koe Zihova si asa. ");
INSERT INTO rug_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Be keke tie si ponia sa nana vina vukivukihi binaere koe Zihova, pudena vina gorevurana sa nana vina tatara, babe sa nana vina vukivukihi pa nana hiniva soti, ba sa kurukuru si kaqu toa va leanana, loke ari kisakisana pude boka ta qetue koe Zihova si asa. ");
INSERT INTO rug_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Mi lopu ponia koe Zihova si keke kurukuru sapu behuna, babe moku nenena, na bakorana, tubutubuna, babe votiki minoho pa kapuna. Namu lopu kaqu poni nia gamu si keke vinariponi ginani gua arini koasa hope pude te Zihova. ");
INSERT INTO rug_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Boka ponia pa mua hiniva soti si keke bulumakao, babe keke sipi sapu lopu noma vari ṉoṉoi tinina, ba lopu kaqu ta qetue tugo, pude na vina gorevurana mo sa vina tatara si asa. ");
INSERT INTO rug_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Mu lopu ponia koe Zihova si keke kurukuru sapu ele ta puzalana, bakorana, munalana, babe poṉo sa kikikolona. Na lopu tava malumuna pa mua popoa soti si asa. ");
INSERT INTO rug_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Mu lopu vari poni nia si keke kurukuru koe Zihova pude na vinariponi ginani, sapu ta poni mae guana koasa tie karovona pa votiki popoa. Sari na kurukuru gua arini si ele boni, loke laedi meke lopu kaqu ta qetue si arini koe Zihova. ");
INSERT INTO rug_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","27","Pana podo si keke tuna bulumakao babe keke lami babe keke tuna qoti si kaqu koa hola koasa tinana si asa koari ka zuapa rane. Ba pa mudina asa, podalae koasa rane vina vesu meke hola la si kote boka tava ego si asa pude poni la nia koe Zihova sa vinariponi ginani asa. ");
INSERT INTO rug_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Mu lopu va matea si keke bulumakao meke sa tuna, babe keke sipi meke na tuna pa keke rane mo. ");
INSERT INTO rug_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Pana va vukivukihi nia goi sa vina vukivukihi pude zama valeana koe Zihova, si mamu luli sari na tinarae pude boka ta qetue si asa koe Zihova; ");
INSERT INTO rug_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","mamu hena betoa koasa rane tugo asa, osolae lopu ele kamoa munumunu.’ ” ");
INSERT INTO rug_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Zama se Zihova, “Mu va tabei sari na Qua tinarae; ura Arau se Zihova. ");
INSERT INTO rug_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Mu pamaṉa nia sa Pozaqu hopena; kaqu gilania ri doduru tinoni Izireli sapu Arau si kaqu tava hope. Ura Arau se Zihova, meke Arau tugo si va via i na va madi gamu si gamu; ");
INSERT INTO rug_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","meke turaṉa vurani gamu si gamu pa popoa Izipi pude ta evaṉae na mia Tamasa. Ura Arau tugo se Zihova.” ");
INSERT INTO rug_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Meke zama la koe Mosese se Zihova, ");
INSERT INTO rug_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Mamu zama guahe koari tinoni Izireli: ‘Hire sari na inevaṉa saripu ele vizati Rau. Arini sari na inevaṉa te Zihova saripu kaqu tozi vurani goi koari na tinoni Izireli pude na rane vinarigara hopedi. ");
INSERT INTO rug_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Koari ka onomo rane si kaqu taveti gamu sari na mia tinavete, ba koasa rane vina zuapa, sapu sa rane Sabati, si na rane magogoso. Kaqu loke tinavete koasa rane sana, ba kaqu varigara mo pa vinahesi si gamu. Be pavei vasina koa gamu ba sa Rane Sabati si te Zihova. ");
INSERT INTO rug_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Mu zama vurani koari na totoso ta vizatadi sari na inevaṉa hire koari na tinoni pa popoa Izireli. ");
INSERT INTO rug_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Sa Inevaṉa Pasova te Zihova si ta tavete pa rane vina manege made koasa sidara kekenu, podalae pa totoso lodu sa rimata, ");
INSERT INTO rug_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","meke koasa rane vina manege lima si podalae sa Inevaṉa Bereti Loke Isitina d. Koari ka zuapa rane dodurudi si lopu kaqu hena ia gamu si keke bereti sapu ta tavetae isiti. ");
INSERT INTO rug_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Koasa rane kekenu koari na rane hire si kaqu varigara pa vinahesi si gamu meke lopu kaqu taveti gamu sari na mia tinavete soti. ");
INSERT INTO rug_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Mi valani sari gemi ginani na mia vina vukivukihi koe Zihova koari ka zuapa rane. Meke koasa rane vina zuapa si kaqu varigara pule pa mia vinahesi si gamu, ba lopu kaqu tavetia gamu si keke tinavete soti. ");
INSERT INTO rug_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","10","Pana mae kamoa gamu sa popoa sapu ponini gamu e Zihova, meke paketi gamu sari na mia vuvua, si mamu paleke la nia koasa hiama sa iqoso huiti kekenu pa mua vinagi. ");
INSERT INTO rug_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Kaqu paleke la nia sa hiama sa iqoso kekenu meke ovulu sage nia sa pa kenuna e Zihova, meke kote qetu nia Sa sa mua vinariponi. Kaqu vekoa sa hiama si asa koa sa rane pa mudina sa Rane Sabati. ");
INSERT INTO rug_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Koasa ranena asa sapu vekoa goi sa mua vinariponi si kaqu va vukivukihi nia goi si keke tuna sipi kokoreo keke vuahenina sapu loke ari kisakisana. ");
INSERT INTO rug_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Kaqu veko turaṉae nia tugo goi si karua kilo mamata palava sapu ta henie oela olive, pude na vinariponi si asa. Meke sa humaṉa lea tanisa vinariponi asa si variva qetu koe Zihova. Meke kaqu veko turaṉae nia tugo goi si keke vinariponi sapu keke lita vaeni. ");
INSERT INTO rug_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Lopu kaqu hena ia gamu si keke vasi ginani koasa vinua kekenu, be ginani makatana, babe ta kinana pa nika, babe na ginani motuna, osolae vala nia goi sa vinariponi hie koe Tamasa. Sa tinarae hie si kaqu ta kopue koari doduru sinage na sage koari doduru totoso mae hiroi. ");
INSERT INTO rug_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Mu naei sari ka zuapa vuiki dodurudi podalae koasa rane pa mudina sa rane Sabati, sa rane kekenu pa vuiki sapu paleke la nia goi sa iqoso huiti kekenu pa mua vinagi pa inuma sapu vala nia goi koe Zihova. ");
INSERT INTO rug_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Koasa vina lima ṉavulu puta rane, sapu pa mudina sa Sabati vina zuapa si mamu vala nia koe Zihova si keke vinariponi huiti vaqurana pule koasa mua vinagi pa inuma. ");
INSERT INTO rug_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Karua botubotu bereti si kaqu paleke lani ri na hopeke tatamana koe Zihova. Karua kilo mamata palava memehedi si kaqu ta tavete koa ri hopeke bereti sapu henia isiti, beto asa si kaqu ta vala koe Zihova pude na vinariponi tana vua kenuna sapu ta pakete pa inuma. ");
INSERT INTO rug_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Kaqu ta veko turaṉae koari na bereti sari ka zuapa tuna sipi kokoreo, sapu hopeke keke vuahenidi meke loke ari kisakisadi, keke bulumakao kokoreo vaqurana meke karua sipi kokoreo. Kaqu na vina vukivukihi va uququ koe Zihova si arini, turaṉae koari na dia vinariponi huiti, na vinariponi kolo vaeni. Sa vinariponi asa si kaqu tava uqu pa nika meke sa hinumaṉa lea tanisa si kaqu ta qetue koe Zihova. ");
INSERT INTO rug_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Beto hoi si mamu va vukivukihi nia si keke qoti kokoreo pude na vina vukivukihi tana sinea, meke karua tuna sipi kokoreo sapu keke vuahenidi, pude na vina vukivukihi tana binaere koe Zihova. ");
INSERT INTO rug_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Kaqu ovulu sage nia sa hiama sa bereti turaṉae koari karua sipi kokoreo pa kenuna Zihova, pude na vinariponi arilaedi koa Sa pude na ginani tadi na hiama. ");
INSERT INTO rug_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Koasa rane sana si lopu kaqu taveti gamu sari na mia tinavete soti, ba kaqu varigara meke vahesia gamu sa Tamasa. Sa tinarae hie si kaqu ta kopue koari na mia sinage na sage be pavei vasina koa si gamu doduru totoso mae hiroi. ");
INSERT INTO rug_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Pa totoso pakepakete si gamu koari na mia inuma, si lopu kaqu koto va kamo la i gamu sari na huiti pa hukihukiridi rina mia inuma, meke lopu kaqu pule la si gamu meke seke vagi sari na batudi sari na huiti saripu koa holadi vasina; mi veko hola i si arini pude tadi na tie habahualadi na tie karovodi pude henai. Ura Arau se Zihova sa Mia Tamasa.’ ” ");
INSERT INTO rug_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Meke zama la koe Mosese se Zihova, “Mu zama guahe koari na tinoni pa Izireli, ");
INSERT INTO rug_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","‘Kaqu kopu nia gamu sa rane kekenu koasa sidara vina zuapa pude magogoso koasa ṉati rane asa, meke kaqu mae varigara pa vinahesi si gamu, pana avosia gamu nodolo va gelenaedi sari na buki. ");
INSERT INTO rug_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Lopu kaqu taveti gamu sari na mia tinavete soti, ba kaqu va vukivukihi la koe Zihova si gamu.’ ” ");
INSERT INTO rug_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Meke zama la koe Mosese se Zihova, ");
INSERT INTO rug_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Sa rane vina manege puta koasa sidara vina zuapa si na rane pude kaqu ta taleosae sari na sinea tadi na tinoni Izireli. Koasa rane asa si loke tie si kaqu hite hena ginani, ba kaqu varigara mo meke vahesia sa Tamasa meke va vukivukihi la koa Sa. ");
INSERT INTO rug_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Loke tie si kaqu tavetavete koasa rane sana, sina asa sa rane sapu tava vulasa na taleosae sari na sinea tadi na tinoni Izireli. ");
INSERT INTO rug_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Be hena ginani si keke tie koasa rane sana, si namu lopu kaqu tava mate palae koari na tie Izireli si asa. ");
INSERT INTO rug_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Meke be keke tie si tavetavete koasa rane sana, sa Tamasa telena si kaqu kilasa va matea si asa. ");
INSERT INTO rug_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Sa tinarae hie si kaqu soto la gua tugo koari na mia sinage na sage, be pavei vasina koa rini. ");
INSERT INTO rug_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Pa rane vina sia koasa sidara vina zuapa podalae totoso lodu rimata meke kamo lodu rimata pa rane vina manege puta si na rane magogoso sapu ta vizatana pude tava madi si gamu, meke koasa rane asa si lopu kaqu hena ia gamu si keketoṉa.” ");
INSERT INTO rug_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Meke zama la koe Mosese se Zihova, ");
INSERT INTO rug_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Mu zama guahe koari na tinoni pa Izireli: ‘Pa rane vina manege lima koasa sidara vina zuapa si kaqu podalae sa Inevaṉa Vina Balabaladi rina Ipi pa Qega d, meke ka zuapa rane si kaqu ta evaṉa si asa. ");
INSERT INTO rug_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Koasa rane kekenu si kaqu varigara si gamu meke vahesia gamu sa Tamasa, meke lopu kaqu hite taveti gamu sari na mia tinavete soti. ");
INSERT INTO rug_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Koari hopeke rane koari ka zuapa rane si kaqu turaṉa maeni gamu sari na mia vina vukivukihi na vinariponi ginani pude na mia vinariponi tana va uququ. Meke koasa rane vina vesu si mamu mae varigara pule pa vinahesi; mamu paleke maeni tugo sari na mia vinariponi ginani na vina vukivukihi pude tana va uququ. ");
INSERT INTO rug_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Arini sari na rane tava hope pude kopuni gamu pude va lavatia se Zihova koari na vinarigara vinahesi. Kaqu valani sari na vinariponi na vina vukivukihi va uququ pa hope, na vinariponi huiti, na kolo vaeni pa hopeke rane. ");
INSERT INTO rug_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Kaqu kopuni gamu sari na inevaṉa arini pa dia totoso meke gua tugo sari na rane Sabati te Zihova meke kaqu valani tugo sari na mia vinariponi saripu ele va tatarani gamu meke gua tugo sari doduru mia vinariponi saripu valani gamu pa mia hiniva soti koe Zihova. ");
INSERT INTO rug_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Pana beto sa pinakepakete koari na mia inuma, si mi kopu nia sa Inevaṉa Vina Balabaladi rina mia Ipi pa Qega koari ka zuapa rane, podalae pa rane vina manege lima koasa sidara vina zuapa. Meke sa rane kekenu meke sa rane vina vesu si kaqu na rane arilaedi pude magogoso si gamu. ");
INSERT INTO rug_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Meke koasa rane kekenu si kaqu henai gamu si kaiqa vua huda leadi saripu ele ta vizatadi koari na mia vuvua, meke vagi tugo kaiqa kava huda pamu na lelaṉa huda saripu koai na elelodi. Mamu tavetia sa inevaṉa hope pude va lavatia se Zihova sa mia Tamasa. ");
INSERT INTO rug_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Mi tavetia sa inevaṉa asa pa ka zuapa rane hopeke vuaheni koasa sidara vina zuapa. Sa tinarae hie si kaqu ta kopue koari na mia sinage na sage doduru totoso mae hiroi. ");
INSERT INTO rug_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Meke sari doduru tinoni Izireli si kaqu koa koari na ipi ka zuapa rane, ");
INSERT INTO rug_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","pude kaqu tumae nia ri na tumia koari na sinage mae hiroi sapu tavete guni he e Zihova sari na tinoni Izireli pude koa koari na ipi totoso turaṉa vurani Rau si arini pa popoa Izipi. Arau tugo se Zihova sa mia Tamasa.’ ” ");
INSERT INTO rug_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Koasa siraṉa gua asa si poni nia Mosese koari na tinoni Izireli sa tinarae pude kaqu kopuni rini sari na inevaṉa hope. ");
INSERT INTO rug_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Zama se Zihova koe Mosese, ");
INSERT INTO rug_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Mu garuni sari na tinoni Izireli, pude paleke maeni sari na oela olive viadi, pude tadi na zuke pa korapa Ipi Hopena, pude lopu kaqu makudo huruṉu lamo sari na zuke. ");
INSERT INTO rug_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Doduru boṉi si kaqu va katui Eroni si arini pude toa lamo pa kenuna e Zihova osolae kamoa munumunu. Sa tuturuana zuke si koa koasa lose hopena pa sadana sa poko goba pa vari korapana sa Lose Hopena meke sa Lose Hopena pa Hopena vasina koa sa Bokese Vinariva Egoi. Sa tinarae hie si kaqu ta kopue ninae rane ka rane. ");
INSERT INTO rug_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Kaqu kopuni Eroni sari na zuke hire koari na dia tuturuana qolo, meke dogori sapu kaqu toa si arini doduru totoso pa kenuna e Zihova. ");
INSERT INTO rug_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Mu henai kaiqa palava memehedi, sapu ka manege rua kilo mamata padana, mamu kinai ka manege rua bereti. ");
INSERT INTO rug_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Vekoi pa karua tokele ka onomo pa hopeke tokele koasa tevolo qolo pa kenuna e Zihova. ");
INSERT INTO rug_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Mamu vekoi kaiqa oto huda humaṉa lea pa batudi ri hopeke tokele, pude va uqua guana vina balabalana sa vinariponi la koe Zihova pude na hinobedi ri na bereti. ");
INSERT INTO rug_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Koari doduru rane Sabati, sa bereti si kaqu ta veko pa kenuna e Zihova. Sa tinarae te Zihova hie koari na tinoni Izireli, si lopu kaqu makudo ninae rane ka rane. ");
INSERT INTO rug_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Sa bereti hie si te Eroni meke sari na tuna koreo. Kaqu hena ia rini si asa pa vasina hopena, sina sa ginani hie si hopena hola sapu ta vala koe Zihova pude tadi na hiama.” ");
INSERT INTO rug_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","11","Koanana si keke tie sapu na tie Izipi sa tamana, meke na barikaleqe Izireli sa tinana. Pozana sa tinana si e Selomiti, na tuna vineki e Dibiri si asa, sapu gore mae guana koasa butubutu te Dani. Sa koreo hie si varivaritokei koa keke tie pa korapana sa kinoa tie Izireli, meke koasa totoso varitokei asa, si zama va kaleania sa sa pozana e Zihova, ke turaṉa la nia rini si asa koe Mosese, ");
INSERT INTO rug_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","pude va kopu nia tie, meke aqania sapu nasa si kaqu tozini e Zihova, pude tavete la nia koasa. ");
INSERT INTO rug_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Zama la koe Mosese se Zihova, ");
INSERT INTO rug_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Mu turaṉa vura nia sa tie sana pa sadana sa vasina koa tie. Sari doduru pu avosona sapu zama va kaleana si asa, si madi va opo nia limadia sa batuna, pude va sosodea sapu sea si asa. Beto asa, si kaqu gona va mate nia patu ri doduru tinoni pa butubutu si asa. ");
INSERT INTO rug_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Beto asa si mamu tozini sari na tinoni Izireli, sapu be keke tie si zama va kaleania sa pozana e Zihova, si kaqu ta goregore nia sa, ");
INSERT INTO rug_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","meke tava mate nia tugo sa sa nana sinea. Be keke tie Izireli babe keke tie karovona sapu koa pa popoa Izireli sapu zama va kaleania sa pozana e Zihova, si kaqu ta gona va mate patu koari doduru butubutu tie pa Izireli. ");
INSERT INTO rug_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Be va mate tie si keke tie si kaqu tava mate tugo si asa. ");
INSERT INTO rug_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Be va matea keke tie sa kurukuru tanisa votiki tie, si kaqu hobe nia kurukuru tugo sa tie pu va matena si asa. Kote hobe nia tinoa sa tinoa. ");
INSERT INTO rug_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Be keke tie seke va bakora ia si keke tie, be vegugua sa tinavete sapu tavete la nia sa tie koasa, si kaqu gua tugo asa si kaqu ta tavete la koasa pu sekena si asa. ");
INSERT INTO rug_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Be va mokua sa si keke susurina sa tie, si kaqu tava moku tugo si keke koari na susurina, be lobiti pania sa si keke kali matana sa tie, si keke koari karua matana si kaqu ta lobiti palae tugo; be keke tie tupa va pakoa livona si keke tie, keke koari na livona sa tie sana si kaqu ta tupa va pako tugo. Be veguguana sa tinasuna sapu vata evaṉia sa tie koasa keke votiki tie, si kaqu ta tavete hobe pule la tugo koasa tie sana si asa. ");
INSERT INTO rug_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Be keke tie va matea si keke kurukuru tanisa keke votiki tie, si kaqu hobe nia kurukuru tugo sa tie sana si asa; ba be va matea sa tie si keke votiki tie, si kaqu tava mate sa tie pu va matena sa tie asa. ");
INSERT INTO rug_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Sari na tinarae hire si tamugamu doduru tinoni Izireli meke sari na tie karovodi pu koa somanae koa gamu, sina Arau se Zihova sa Mia Tamasa.” ");
INSERT INTO rug_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Sipu beto zamani e Mosese koari na tinoni Izireli saripu gua hire, si vagia ri na tinoni Izireli sa tie meke turaṉa vura nia pa sadana sa kinoa tie meke gona va mate nia patu rini. Tavetia ri na tie Izireli gua pu zamani e Zihova koe Mosese. ");
INSERT INTO rug_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Zama la koe Mosese se Zihova pa toqere Saenai, ");
INSERT INTO rug_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Mu tozini sari na tinoni Izireli sari na tinarae hire: Pana nuquria gamu sa popoa sapu kaqu ponini gamu e Zihova, si lopu kaqu lelete si gamu koari doduru hopeke vina zuapa vuaheni. Kaqu tavete gua asa si gamu pude pamaṉa nia se Zihova. ");
INSERT INTO rug_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Koari ka onomo vuaheni si boka lelete na kopu totoko ni meke paketi gamu sari na vuadi ri na huda vaeni koari na mia inuma. ");
INSERT INTO rug_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Ba koasa vuaheni vina zuapa si kaqu va magogoso valeania gamu sa pepeso. Na vuaheni tava madina koe Zihova meke lopu kaqu lelete babe kopu totokoni gamu sari na mia inuma. ");
INSERT INTO rug_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Doduru ginani sapu toa teledia meke lopu ta letedi koasa emata koana tamugamu si lopu tava malumu pude vagi gamu meke holuholuni. Meke lopu tava malumu tugo si gamu pude paketi sari na vuadi sari na qurepi pa inuma, babe la pa mia inuma pude kopu totoko ni vasina meke holuholuni. Sina kaqu tavamadi sa pepeso asa pa keke vuaheni pude na vina balabalaqu Rau, ");
INSERT INTO rug_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Be guana lopu tavete inuma si gamu koasa vuaheni asa, ba sa pepeso si kote ponini gamu ginani si gamu doduru pa Izireli. Sari na ginani sapu toqolo teledia, si arini si tamugamu, meke tadi na pinausu, na tie tavetavete, meke tadi na tie karovodi mae sapu koa turaṉae koa gamu. ");
INSERT INTO rug_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Sari na kurukuru ta pausudi meke sari na kurukuru pinomodi pu koa koari na mia inuma, ba kaqu henai mo gua sapu ta vagi koasa vuaheni asa. ");
INSERT INTO rug_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Be ka zuapa totoso ka zuapa si varigarani gita koari ka zuapa vuaheni, si ka made ṉavulu sia vuaheni si vura mae. ");
INSERT INTO rug_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Ego, koasa Rane Tinaleosae tana Sinea si kaqu ta ivu sa buki pa doduruna sa popoa pa rane vina manege puta koasa sidara vina zuapa. ");
INSERT INTO rug_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Sa vuaheni vina lima ṉavulu puta si kaqu vata evaṉae nia na vuaheni arilaena gamu si asa. Kaqu urahae nia gamu sa tinarupaha koari doduru popoa Izireli pu koai ri na tinoni. Koasa vuaheni asa, sari doduru pepeso saripu ele ta holuholue si kaqu tava pule koari pu tagodi si arini pa pinodalaena, meke sarini pu ele ta holuholue guana pinausu si kaqu tava pule koari na dia butubutu na tatamana soti. ");
INSERT INTO rug_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Sa vuaheni vina lima ṉavulu puta si kaqu na vuaheni ziubili. Lopu kaqu lelete si gamu koa rina inuma vaquradi, babe pakepakete pa doduruna sa inuma. Meke lopu kaqu pakepakete si gamu pa doduruna sa inuma vaeni. Meke lopu kaqu ta koto sari na lelaṉadi. Boka vagi tugo gamu sa ginani sapu toqolo hoborodi. ");
INSERT INTO rug_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Kaqu va madia gamu sa doduruna sa vuaheni meke kaqu henai mo gamu gua saripu ele toa koari na mia inuma. ");
INSERT INTO rug_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Koasa vuaheni asa sari doduru pepeso pu ele ta holuholue, si kaqu tava pule la koasa pu tagona pa pinodalaena. ");
INSERT INTO rug_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Ke pana vari holuholue ni gamu na tie Izireli pa varikorapa mia sari na mia pepeso, si mi lopu sekesekei. ");
INSERT INTO rug_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Kaqu ta pada sa hinolu pepeso koari na vuahenina sapu boka ta vagi sa vuadi pa pepeso, sipu lopu ele tava pule sa tinago koasa butubutu tagona pa pinodalaena. ");
INSERT INTO rug_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Be guana soku vuaheni sipu lopu ele kamo sa ziubili meke boka vagi va soku vua, sa padana sa hinolu si kote sage tugo; ba be sari na vuaheni si lopu soku pude vagi sa vuadi si kote ka visavisa mo, sa padana sa hinolu, sina kote hitekena tugo vinagidi sari na vuadi. Sina gua sapu ele ta holu si koa gua mo koasa sinokuna sa vuadi sapu ta vagi koasa pepeso. ");
INSERT INTO rug_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Mu lopu sekesekei nia goi sa tie Izireli turaṉamu, ba mu va tabea se Zihova sa mua Tamasa. ");
INSERT INTO rug_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Mu va tabei sari doduru tinarae na ginarunu te Zihova, pude boka tava sare sa mua tinoa pa pepeso. ");
INSERT INTO rug_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Kaqu koa ia na vuana sa pepeso, meke lopu kaqu qagania goi si keketoṉa pude gania meke kaqu koa learane sa mua tinoa. ");
INSERT INTO rug_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Ba be koadia si kaiqa tie sapu kote nanasa gua hie: ‘Na sa si kote hena ia gita pa korapana sa vuaheni vina zuapa, pana loke linetelete na pinakepakete si ta evaṉa koasa vuaheni asa?’ ");
INSERT INTO rug_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Kaqu mana nia e Zihova sa pepeso koasa vina onomo vuaheni, pude lopu kaqu qagani gita na ginani koari ka ṉeta vuaheni. ");
INSERT INTO rug_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Pana lelete pule si gamu koasa vuaheni vina vesu, si kote boka henai mo gamu sari na vua kenudi ta vagi pa vuaheni vina onomo, osolae kamo sa vuaheni vina sia, sipu komiha mae sari na linetelete vaqura. ");
INSERT INTO rug_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Gamu si lopu kaqu holuholu taloani sari na pepeso, sina lopu tamugamu sa pepeso asa, ba Nana tu e Tamasa; gamu si guana tie karovo mia mo, pu tava malumu mia mo pude tavetavete nia meke koa paki mo koa Rau. ");
INSERT INTO rug_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Pa doduru ia ka ia koasa pepeso pana ta holu si keke vasi pepeso, si kaqu tava malumu sa tie pu tagona pa pinodalaena sa pepeso pude ta holu vagi pule sipu lopu ele mae sari votiki tie pude holua. ");
INSERT INTO rug_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Be malaṉa sa tasimu meke holuholu nia sa sa kukuruna sa pepeso sapu tagoa sa, si kaqu mae sa turaṉana soti meke holu vagi pulea sa pepeso sana sapu holuholu nia sa tasina. ");
INSERT INTO rug_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Be keke tie si loke turaṉana pude holu vagi pulea sa pepeso asa, ba mumudi si bokaboka si asa, si mani holu vagi pulea mo telena. ");
INSERT INTO rug_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Koasa ginugua asa, si kaqu nae varigara ni sa sari na sinokudi rina vuaheni koa holadi, podalae sipu ta holuholue koa sa tie sa nana tinago meke kamo pa vuaheni ziubili, meke kaqu va pulea sa padana sa poata meke tabaria tugo sa holana meke kaqu tiqe vagi pulea sa sa nana tinago. ");
INSERT INTO rug_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Ba be lopu pada sa nana poata pude holu pule nia sa pepeso, si korapa koa hola nana mo sa pepeso pa kinopu tanisa tie pu holuna si asa, osolae kamo pule si keke vuaheni ziubili koasa vuaheni asa si kaqu tiqe tava pule la koasa pu tagona pa pinodalaena si asa. ");
INSERT INTO rug_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Be keke tie si holuholu nia, si keke vetu kinoa pa korapana sa bara vasileana nomana, si boka holu vagi pulea sa si asa pa korapana sa vuaheni podalae koasa totoso sapu holua sa. ");
INSERT INTO rug_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Ba be lopu holu vagi pulea sa si asa koasa vuaheni kekenu, si siana nia sa sa totoso pude holu pule nia, ke sa vetu si ta evaṉae na nana tinago soti sa tie pu holuna meke sari na tutina. Namu lopu kaqu tava pule si asa koasa vuaheni ziubili. ");
INSERT INTO rug_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Ba sari na vetu pu lopu koa pa korapa bara vasileana nomana, si kaqu ta holuholue pule pa siraṉa gua pu taveti gami koari na inuma. Sa tie pu tagona pa pinodalaena si boka holu vagi puleni si arini, meke kaqu boka tava pule si arini pa korapana sa vuaheni ziubili. ");
INSERT INTO rug_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Ba sari na tie pa butubutu te Livae si boka holu vagi pulei sari na dia vetu koari na vasileana tadirini doduru totoso. ");
INSERT INTO rug_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Be keke vetu koari na vasileana lavata hire si ta holuholue koa keke tie pa butubutu te Livae, meke lopu ta holu vagi pule si asa, si kaqu tava pule si asa koasa vuaheni ziubili, sina sari na vetu pu tago soti ri na tie pa butubutu te Livae saripu koa koari pa vasileana lavata tadi na tinoni Izireli, si na dia soti rini ninae rane. ");
INSERT INTO rug_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Ba sari na vasidi duduli tadi na rovana kurukuru ṉame, saripu koa vari likohae koari na vasileana lavata tadi na tinoni pa butubutu te Livae, si namu lopu kaqu ta holuholue. Na dia tinago ninae rane si arini. ");
INSERT INTO rug_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Be keke tie Izireli turaṉamia sina tie malaṉana meke koa tata koa gamu, meke lopu boka toka pule nia si asa; ego mamu toka nia gamu si asa. Kekeṉoṉo gua tugo sapu hoke toka nia gamu si keke tie karovona, pude lopu kaqu rizu taloa koa gamu si asa. ");
INSERT INTO rug_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Mu lopu tepa tomo nia goi kaiqa toṉa koasa lipulipu sapu vala nia goi koasa tie malaṉa, ba mu va tabea sa Tamasa, mamu qetu nia mo sa tie Izireli turaṉamu hie pude koa valeana tata koa goi. ");
INSERT INTO rug_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Mu lopu tepa nia poata pude tomoa sa poata sapu poni nia goi koasa, meke lopu tomo nia poata koasa ginani sapu poni nia gamu koasa. ");
INSERT INTO rug_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Hie sa tinarae te Zihova sa mia Tamasa. Arau mo sapu turaṉa vurani gamu pa popoa Izipi meke ponini gamu sa popoa pa Kenani. Arau tugo sa mia Tamasa. ");
INSERT INTO rug_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Be keke tie Izireli turaṉamu sapu koa tata koa goi, si malaṉa hola meke holuholu pule nia si asa koa goi, pude na pinausu tamugoi, mu lopu va tavetavete guni nia goi na pinausu si asa pu tavetavete ba loke tinabara. ");
INSERT INTO rug_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Kaqu koa koa goi gua mo na tie tavetavete ta tabarana si asa pude toka nigo, osolae kamo pule si keke vuaheni ziubili. ");
INSERT INTO rug_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Koasa totoso tugo asa, si kaqu taluarae koa goi si asa meke sari na nana koburu, meke pule la koasa nana tatamana soti, meke koasa pepeso tadi na tiatamana, ");
INSERT INTO rug_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Sari na tinoni Izireli hire si na Qua pinausu; turaṉa vurani Rau pa popoa Izipi; meke lopu kaqu ta holuholue pude na pinausu si arini. ");
INSERT INTO rug_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Mu lopu toleṉe gua ṉoṉovali, ba mamu va tabea sa mua Tamasa. ");
INSERT INTO rug_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Be guana hivani gamu si kaiqa pinausu, si mamu holui si arini koasa votiki butubutu saripu koa pa vari likohae mia. ");
INSERT INTO rug_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Kote boka holui tugo gamu sari na koburu tadi na tie karovodi, saripu koa pa korapa mia popoa. Sari na koburu gua hire; saripu podo pa mia popoa, si boka gunini mo na mia tinago si arini, ");
INSERT INTO rug_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","meke kaqu veko hola i gamu pude na tinago tadi na tumia koreo, pude kaqu nabuluni gamu rini ninae rane pa dia tinoa. Ba mi lopu toleṉe gua ṉoṉovalia si keke tie Izireli turaṉamu. ");
INSERT INTO rug_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Be keke tie karovona sapu koa pa korapa mia popoa, si tagotagona, meke keke tie Izireli si malamalaṉana, meke holuholu pule nia sa tie Izireli hie, koasa tie karovona, ba be pude vata evaṉae pule nia keke tie soti koasa tatamana tanisa tie karovona gua; ");
INSERT INTO rug_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","pa mudina sipu holuholu pule nia si asa, si toṉoto tugo si asa, pude boka holu vagi pule nia si asa. Keke koari na tasina, ");
INSERT INTO rug_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","ba be buhina ba be tasina karokarovo, ba be kaiqa ri na turaṉana saripu tata sisigiti koasa, si boka holu vagi pule nia si asa; ba be asa telena si ari nana poata, si boka holua sa sa nana tinarupaha soti. ");
INSERT INTO rug_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Kaqu la vivinei va toṉotia sa sa tie pu holuna si asa; meke kaqu naei rini sari na vuaheni, podalae koasa totoso sipu holuholu pule nia si asa, osolae kamoa sa vuaheni tanisa ziubili, meke kaqu tiqe ta tabara sa hinoluna sa nana rinupaha koasa laena sa tinabara, sapu ele ta tabara nia sa tie tavetavete koari na vuaheni arini. ");
INSERT INTO rug_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","52","Kaqu va gore pania sa sa kukuruna sa poata tinabara, koasa padana sa sinoku vuaheni koa holadi. ");
INSERT INTO rug_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Sa tie karovo tagotagona si kaqu tavetavete guni nia sa tie pu holuholu pule nia si asa guana na tie tavetavete pu ta tabara hopeke totoso pa vuaheni. Mi lopu va malumia sa tie karovona sapu sa nana palabatu pude toleṉe gua ṉoṉovalia si asa. ");
INSERT INTO rug_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Be lopu ta rupaha sa tie hie koa ke siraṉa gua arini, ba kaqu ta rupaha si asa meke sari na tuna koasa vuaheni pule tanisa ziubili. ");
INSERT INTO rug_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Sari na tie Izireli si lopu kaqu koa pinausu ninae rane, sina na pinausu te Zihova sarini. Ele ta holu vagi vura pa popoa Izipi si arini, sina Arau si e Zihova sa dia Tamasa.” ");
INSERT INTO rug_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Zama se Zihova, “Mu lopu tavete beku, babe va turui sari na vina tigono, dedegere patu, babe sari na patu ta peqopeqo kinehadi pude tana vahesihesi, sina Arau se Zihova sa mia Tamasa. ");
INSERT INTO rug_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Mi kopuni sari na rane sabati, mi pamaṉa nia sa Qua vasina hopena, vasina tavahesi si Arau, ura Arau se Zihova. ");
INSERT INTO rug_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Be luli gamu sari na Qua tinarae meke va tabei gamu sari na Qua ginarunu, ");
INSERT INTO rug_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","si kaqu garunu atunia Rau koa gamu sa ruku pa totoso garona, pude kaqu toa valeana pa pepeso sari na linetelete, meke sari na linetelete huda si kaqu vua katakata. ");
INSERT INTO rug_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Kote pakepakete va sokusoku ginani si gamu. Sipu lopu ele hokoto sa tinavete paqaha pania sa kapuna sa kiko huiti, si kamo mo sa pinakepakete tanisa vua qurepi. Meke sipu lopu ele makudo sa pinakepakete tana vua qurepi, si kamo mo sa totoso lelete pule, ke kote deṉa valeana si gamu doduru totoso, meke sa mia tinoa si kote ta kopue va leana pa mia popoa. ");
INSERT INTO rug_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Kaqu vatu nia Rau sa binule pa mia popoa, meke totoso puta gamu pana boṉi, lopu kaqu matagutu nia gamu si keke tie. Kaqu hadu va seui Rau sari na kurukuru variva mate pa mia popoa, meke namu loke vinaripera nomana si kaqu raza mae koa gamu. ");
INSERT INTO rug_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Kaqu va kilasi gamu sari na mia kana; meke kaqu va matei gamu si arini. ");
INSERT INTO rug_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Ari ka lima mo koa gamu, si boka va kilasi si keke gogoto tie; meke ari ka keke gogoto mo koa gamu, si boka va kilasi sari ka manege puta tina tie. ");
INSERT INTO rug_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Kaqu manani gamu Rau si gamu, meke kaqu va sokui Rau sari na tumia. Kaqu kopu nia Rau sa nada vinariva egoi sapu tavetia Rau koa gamu. ");
INSERT INTO rug_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Kaqu omunu turaṉa gamu na pinakepakete, meke lopu kaqu boka tava beto pa keke vuaheni osolae kaqu ta okipalae sari na pinakepakete koadi pude poni lolomo sari na pinakepakete vaqura. ");
INSERT INTO rug_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Kaqu koa turaṉa gamu Rau koasa Qua Ipi Hopena, meke namu lopu hite kaqu etulu pani gamu Rau. ");
INSERT INTO rug_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Kaqu koa turaṉa gamu Rau; Arau si kaqu na mia Tamasa, meke gamu si kaqu na Qua tinoni. ");
INSERT INTO rug_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Arau Zihova sina na mia Tamasa, pu turaṉa vurani gamu pa popoa Izipi, pude lopu kaqu na pinausu pule si gamu. Ele mokua Rau sa ṉiniraṉira sapu va opo gore gamu pa tinavete mamata, meke vata rupaha gamu Rau pude va turu toṉoto gamu koasa mia inene.” ");
INSERT INTO rug_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Zama se Zihova, “Be koromia avosau gamu, meke lopu hiva luli gamu sari na Qua zinama, si kaqu va kilasa gamu Rau. ");
INSERT INTO rug_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","Be koromia avosi gamu sari na Qua tinarae meke sari na Qua zinama, meke sa nada vinariva egoi sapu tavetia Rau koa gamu, ");
INSERT INTO rug_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","si kaqu va kilasa gamu Rau, koari na tinasuna gua hire: kaqu va razani gamu tinarazuzu variva hodahodakana Rau si gamu, na minoho korokoro na nunuare, sapu boka va ridai sari na matamia meke va malohori sari na tinimia. Kaqu lete hobori mo gamu sari na mia linetelete, ba lopu kaqu leadi sina sari na mia kana pu kaqu va kilasa gamu, si kote gani si arini. ");
INSERT INTO rug_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Kote tokani Rau sari na mia kana, pude kaqu tava kilasa si gamu, meke sari na mia kana, si kote koimatani gamu; meke kote matagutu tarazuzu va kaleana si gamu meke kote govete hoboro, pana loke tie hadu gamu. ");
INSERT INTO rug_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Pana be hola sari doduru pu gua hire, meke be lopu avoso Au tugo gamu si Arau si kaqu ka zuapa totoso va noma hola la ia Rau sa mia vina kilasa. ");
INSERT INTO rug_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Kaqu mokui Rau sari na ṉiniraṉiradi ri na mia vinahesi pule, loke vasi ruku si kaqu hoqa mae, kaqu dada sari na mia popoa, meke kaqu ṉiṉira guana aeana sa pepeso. ");
INSERT INTO rug_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Sari doduru mia minabo pa tinavete si kote loke laedi, sina kote loke ari ginanidi sari na mia linetelete pa pepeso, sari na mia linetelete huda ba kote loke vuadi. ");
INSERT INTO rug_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Be lopu makudo kana Au tugo gamu, meke koromia avoso au gamu, si kaqu va noma la ia Rau sa mia vina kilasa ka zuapa totoso pule. ");
INSERT INTO rug_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Kaqu garunu atuni Rau koa gamu sari na kurukuru variva mate, meke kaqu va matei rini sari na tumia, meke sari na mia rovana kurukuru ṉame; sari na mia siraṉa si kote ivulu beto, sina lopu soku sari na tie si koa hola. ");
INSERT INTO rug_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Be lopu va nonogai tugo gamu sari doduru vina kilasa gua hire, meke lopu avoso Au tugo gamu, meke koromia luli Au gamu, ");
INSERT INTO rug_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","si ego, kaqu duta atu gamu Rau, meke va kilasa gamu ka zuapa totoso, ṉiṉira hola nia sapu pa kekenu. ");
INSERT INTO rug_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Kaqu turaṉa atu nia Rau sa qeto minate, pude va kilasa gamu, ura na va karia gamu sa nada vinariva egoi; meke be la si gamu, meke la varigara koari na mia vasileana lavata, pude tava sare mia gua; ba kaqu garunu atuni gamu minoho loke sinalaṉadi Rau si gamu, meke kaqu valani gamu Rau koari na limadi ri na mia kana. ");
INSERT INTO rug_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Kaqu va gore hitekia Rau sa mia vinagi ginani, ke sari ka manege puta barikaleqe si kaqu motui mo rini pa keke motu sari doduru gedi ginani pu vagi rini. Pana variva hiani rini, meke hena betoi, si lopu kaqu deṉa si arini. ");
INSERT INTO rug_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Be loke totoso si boka avoso Au gamu, meke koromia luli Au, meke pa mudidi ri doduru pu gua arini, meke korapa lopu va avoso Au na koromia va tabe Au tugo gamu, ");
INSERT INTO rug_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","si kaqu bugoro puleni gamu tugo Rau, meke sa Qua binugoro asa si kaqu ka zuapa totoso ka zuapa kaleana hola nia sa vina kilasa visoroi hire. ");
INSERT INTO rug_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Sa mia inovia si kaqu kaleana hola, meke kaqu henai gamu sari na tumia soti. ");
INSERT INTO rug_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Sari na mia vasidi va hesihesiana beku koari na toqere si kaqu huara pani Rau, meke kaqu huara ilasi tugo Rau sari na mia hope tana oto huda humaṉa lea, meke kaqu oki varigara lani Rau koari na mia beku hoqadi sari na tinimia saripu mate pa Qua tinaṉaziri, ");
INSERT INTO rug_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","si kaqu ta huara inete va umumu sari na mia vasileana lavata meke sari na mia vasidi va hesihesiana beku meke lopu kaqu qetuni Rau sari na mia vina vukivukihi va uququ. ");
INSERT INTO rug_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Kaqu huara va inete betoa Rau sa mia popoa meke sari na mia kana pu mae koa ia si kaqu hodahodaka nia sa tinahuara asa. ");
INSERT INTO rug_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Kaqu turaṉa atunia Rau koa gamu sa vinaripera, meke kaqu ta raovo vagi pude la pa votiki popoa si gamu. Sa mia popoa si kote ta inapaha beto, meke sari na mia vasileana lavata si kote ta veko palae pa tinahuara. ");
INSERT INTO rug_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","35","Meke kaqu qetu beto nia sa popoa pepeso sa minagogoso koari na vuaheni sapu koa ta raovo vagi si gamu koari na popoa tadi na mia kana. Kaqu vagia sa pepeso sa minagogoso sapu lopu kopu nia gamu totoso koa koasa pepeso asa. ");
INSERT INTO rug_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Gamu sapu koa pa tinaraovo si kaqu va matagutu na tarazuzu gamu Rau, meke sa ovaṉana sa elelo sapu givusia si kaqu va govete gamu si gamu. Kaqu govete si gamu, gua tugo sapu ta hadu nono si gamu pa vinaripera meke kaqu hoqa hoboroni gamu, ba loke kana si hadu gamu. ");
INSERT INTO rug_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Kaqu vari duta pulei telemia pa mia ginovete totoso loke tie hadu gamu, meke lopu kaqu boka varipera la ia gamu si keke kana. ");
INSERT INTO rug_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Pa tinaraovo si kaqu mate gamu, meke kaqu ta pomunae si gamu koari na pepeso tadi na mia kana. ");
INSERT INTO rug_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Ka visavisa gamu saripu korapa toa pa popoa tadi na mia kana si kaqu koa hola pa mia minatagutu na tinalotaṉa, koa gua koari na mia sinea meke sinea tadi na tiatamamia. ");
INSERT INTO rug_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Ba sari na tudia ri na tumia si kaqu helahelae ni sari na dia sinea, meke sari na sinea tadi na tiatamadia, sarini pu lopu kopuni sari na Qua zinama, meke kana Au meke va sea mae koa Rau, ");
INSERT INTO rug_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","meke va bugoro Au meke garunu lani Rau si arini pa tinaraovo pa popoa tadi na dia kana. Ba mumudi pana pulepaho meke va pepekae puleni sari na tudia rina tumia meke hokoto sa vina kilasadi rina dia sinea na vinagugue, ");
INSERT INTO rug_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","si kaqu balabala pulea Rau sa Qua vinariva egoi koe Zekopi meke koe Aisake meke Ebarahami, meke kaqu balabala pulea Rau sa Qua vina tatara pude ponia sa popoa koari na tutidia. ");
INSERT INTO rug_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Ba kekenu, si kaqu luaria ri na tinoni pu koadi vasina koasa popoa, meke kaqu qetu nia sa pepeso sa nana minagogoso sipu ivulu si asa; meke kaqu tava hokoto sa vina kilasa tugo tadirini koari na dia sinea, sina va kari rini sari na Qua tinarae na Qua zinama. ");
INSERT INTO rug_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Ba sipu korapa koa si arini koari na popoa tadi na dia kana si lopu kaqu luara pani betoni Rau si arini, babe va mate betoi; sina lopu kaqu veko pania Rau sa Qua vinariva egoi koa rini. Arau mo se Zihova sa dia Tamasa si kopu totoko ni sari na Qua zinama. ");
INSERT INTO rug_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Kaqu balabala pulea mo Rau sa Qua vinariva egoi sapu ele tavetia Rau koari na tiatamadia, sipu va dogoroni Rau koari doduru butubutu sa Qua ṉiniraṉira totoso turaṉa vurani Rau pa popoa Izipi pude arini sina Qua tinoni, meke Arau se Zihova sina dia Tamasa.” ");
INSERT INTO rug_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Arini sari doduru tinarae na zinama saripu tozi lani e Zihova koe Mosese pa toqere Saenai, pude tadi na tinoni Izireli. ");
INSERT INTO rug_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Zama la koe Mosese se Zihova, ");
INSERT INTO rug_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","pude tozi lani koari na tinoni Izireli sari na tinarae hire: Pana tava madi la koe Zihova si keke tie pa zinama tokotokoro, sa tie si boka ta holu pule koe Zihova koari na padadi ri na poata hire. ");
INSERT INTO rug_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","7","Koasa padapadana sa siliva sapu tavetia sa hiama koasa padapadana hopena tadi na hiama, sa palabatu sapu ka hiokona puta meke kamoa onomo ṉavulu puta vuahenina, si kaqu ka lima ṉavulu puta poata siliva. Sa barikaleqe na vineki hola hiokona vuahenina si kaqu ka toloṉavulu poata siliva. Sa koreo vaqura podalae ka lima meke kamoa ka hiokona puta vuahenina, si kaqu ka hiokona puta poata siliva. Sa vineki vaqura si ka manege puta poata siliva. Sa koburu koreo sapu lopu ele ka lima vuahenina, si ka lima poata siliva hinoluna. Sa koburu vineki si ka ṉeta poata siliva hinoluna. Sa barogoso hola nia onomo ṉavulu vuahenina si manege lima poata siliva, meke sa kaleqe sapu hola nia onomo ṉavulu vuahenina si manege puta poata siliva. ");
INSERT INTO rug_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Be keke tie malamalaṉana si lopu boka tabaria sa sa padana sa tie sapu tava madina pa zinama tokotokoro, si kaqu ta turaṉa la koasa hiama sa tie madina, meke kaqu va gorea sa hiama sa padana sa hinoluna, padana gua sa binokaboka sapu boka tabaria sa si asa. ");
INSERT INTO rug_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Be na kurukuru sapu garo pude na vina vukivukihi, si mani tokotokoro nia sa tie koe Zihova; tava madi tugo si asa, lopu boka holu pule nia koe Zihova. ");
INSERT INTO rug_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Lopu kaqu hobe nia keke votiki kurukuru sa tie sa kurukuru madina. Be podeke evaṉia sa sapu gua asa, si kaqu te Zihova beto mo sari karua kurukuru. ");
INSERT INTO rug_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Be keke tie pa nana zinama tokotokoro si vala nia sa si keke kurukuru lopu viana sapu lopu qetu nia sa Tamasa, pude va vukivukihi la nia koa Sa, si kaqu turaṉa la nia sa pa kenuna sa hiama. ");
INSERT INTO rug_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Kaqu pada ia sa hiama sa hinoluna gua sapu padana sa laena sa kurukuru, meke asa tugo sa hinoluna. ");
INSERT INTO rug_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Be hiva holu vagi pule nia sa tie sa kurukuru, si kaqu holu vagi pule nia sa si asa, koasa padana ta tozi koasa hiama meke tomo pule la nia pule ka hiokona puta paseniti. ");
INSERT INTO rug_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Be keke tie koa gamu si hiva va madia koe Zihova sa nana vetu; kaqu tavete vura nia sa hiama sa hinoluna koasa padana sa laena sa vetu, meke asa tugo sa padana. ");
INSERT INTO rug_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Be sa tie sapu va madi la nia koe Zihova sa vetu si hiva holu vagi pule nia sa si asa, si kaqu holua sa si asa koasa hinoluna, meke tomo la nia pule ka hiokona puta paseniti koasa hinoluna. ");
INSERT INTO rug_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Be keke tie si hiva va madi la nia koe Zihova, sa kukuruna sa nana pepeso, sa hinoluna si kaqu ta pada koasa sinokudi ri na kiko linetelete, pu kaqu ta lete koasa pepeso. Sa hinoluna si kote padana ka manege puta poata siliva pa hopeke hiokona kilo kiko bale. ");
INSERT INTO rug_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Be lopu sana va madia sa sa pepeso pa mudina sa vuaheni ziubili, sa doduruna sa hinoluna sa pepeso si ta hivae. ");
INSERT INTO rug_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Ba be va madia sa tie si asa hola kaiqa vuaheni mumudi, si kaqu tavete vura nia sa hiama sa laena sa hinoluna koari na vuaheni saripu koa hola osolae kamoa sa vuaheni ziubili meke kaqu tava gore sa hinoluna koasa ninaedi rina vuaheni meke kamoa sa vuaheni ziubili. ");
INSERT INTO rug_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Be hiva holu vagi pule nia sa tie sa inuma sapu va madi la nia sa, si kaqu holua sa koasa hinoluna, meke tomo la nia pule ka hiokona puta paseniti koasa padana. ");
INSERT INTO rug_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Be vata holu nia sa sa inuma koa keke tie, ba kekenu si lopu holu vagi pule nia sa telena koe Zihova, si kote siana nia sa sa ṉiniraṉira, pude holu vagi pule nia si asa. ");
INSERT INTO rug_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Koasa vuaheni ziubili pule sapu korapa mae hoi, si kaqu Nana soti e Zihova sa tinago asa, gua asa ke kaqu tadi na hiama si asa. ");
INSERT INTO rug_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Be keke tie si va madi la nia koe Zihova, si keke inuma sapu ele holua sa, ");
INSERT INTO rug_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","sa hiama si kaqu tavete vura nia sa laena padadi ri na vuaheni osolae kamoa sa vuaheni ziubili, meke kaqu tabaria sa tie sa hinoluna koasa rane tugo asa, meke sa poata si kaqu Nana e Zihova. ");
INSERT INTO rug_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Koasa vuaheni ziubili sa inuma si kaqu tava pule la koasa pu tagona pa pinodalaena babe pa tutina. ");
INSERT INTO rug_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Sari doduru laedi si kaqu ta tabara hinoludi koasa padapadana hopena tadi na hiama. ");
INSERT INTO rug_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Sa tuna kenuna sa kurukuru si ele Nana tu e Zihova; ke loke tie si kaqu va madi pule la nia koe Zihova, guana nana vinariponi pa nana hiniva soti. Be guana sa tuna kenuna sina tuna bulumakao babe na tuna sipi babe na tuna qoti si asa si ele nana tu e Zihova si asa, ");
INSERT INTO rug_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","ba sa tuna kenuna sa kurukuru sapu lopu viana pa dinogodogorae te Zihova pude na vina vukivukihi, si boka ta holu vagi pule koasa laena meke tomo la nia ka hiokona puta paseniti koasa hinoluna. Be lopu ta holu vagi pule si asa, sari na hiama si boka holua koa keke tie koasa padana sa hinoluna. ");
INSERT INTO rug_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Loke tie si boka holuholu nia babe holu vagi pulea, sa vinariponi sapu ele ta poni meke tava madi koe Zihova, be na tie, babe na kurukuru, babe na pepeso. Nana mo e Zihova si asa ninae rane. ");
INSERT INTO rug_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Sa tie sapu pada pude kaqu tava mate sina sekea sa sa tinarae te Zihova, sa nana tinoa si lopu kaqu tava malumu pude ta holu vagi pule, ba kaqu tava mate tugo si asa. ");
INSERT INTO rug_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Keke pa manege koari doduru vinagi pa pepeso be na huiti babe na vua huda si asa, si te Zihova si arini. ");
INSERT INTO rug_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Be keke tie si hiva holu vagi pulea si keke toṉa, kaqu holua sa sa padana sa hinolu meke tomo la nia ka hiokona puta paseniti si asa. ");
INSERT INTO rug_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Keke koari doduru vina manege puta kurukuru, ta pausudi koa gamu si te Zihova. Pana ta nae sari na kurukuru, sari doduru vina manege puta si te Zihova. ");
INSERT INTO rug_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Lopu kaqu tavete valeania sa tie pu ari nana kurukuru, pude ta vizata si kaiqa kurukuru kaleadi, meke lopu boka hobei tugo sa sari keke pa manege. Ba be varihobei ni sa sari na kurukuru, kaqu te Zihova beto sari karua kurukuru meke lopu kaqu tava malumu pude ta holu vagi pule si arini koa Sa. ");
INSERT INTO rug_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Arini sari na tinarae saripu tozi lani e Zihova koe Mosese pa toqere Saenai, pude tadi na tinoni Izireli. ");
INSERT INTO rug_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Pa rane kekenuna sa sidara vina rua koasa vuaheni vina rua sipu taluarae pa popoa Izipi meke korapa koa pa soloso qega pa popoa Saenai si arini, si zama la koe Mosese se Zihova pa korapa Ipi Hopena, ");
INSERT INTO rug_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Agoi meke Eroni si kaqu naei sari na tie nomadi pa korapana sa butubutu Izireli, koari na dia butubutu meke na dia tatamana. Kaqu kubere goreni gamu pozadi sari doduru tie, ");
INSERT INTO rug_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","sarini pu ka hiokona puta vuahenidi kamo koari na tie komihadi saripu pada pude somana pa vinaripera. ");
INSERT INTO rug_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Mi tepai, sari na baṉara pude keke koari hopeke butubutu si tokani gamu. ");
INSERT INTO rug_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Hire sari na pozadi: Koasa butubutu Rubeni, si e Elizua, sa tuna e Sedeu; ");
INSERT INTO rug_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","koasa butubutu Simione, si e Selumieli, sa tuna e Zurisadai; ");
INSERT INTO rug_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","koasa butubutu Ziuda, si e Nasoni, sa tuna e Aminadabi; ");
INSERT INTO rug_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","koasa butubutu Isaka, si e Netanela, sa tuna e Zua; ");
INSERT INTO rug_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","koasa butubutu Zeboloni, si e Eliabi, sa tuna e Heloni; ");
INSERT INTO rug_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","koasa butubutu Iparemi, si e Elisama, sa tuna e Amihudi; koasa butubutu Manase, si e Qamalieli, sa tuna e Pedazu; ");
INSERT INTO rug_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","koasa butubutu Benisimane, si e Abidani, sa tuna e Qitione; ");
INSERT INTO rug_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","koasa butubutu Dani, si e Ahieza, sa tuna e Amisadai; ");
INSERT INTO rug_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","koasa butubutu Asa, si e Paqieli, sa tuna e Okarani; ");
INSERT INTO rug_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","koasa butubutu Qadi, si e Eliasapi, sa tuna e Dueli; ");
INSERT INTO rug_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","koasa butubutu Napitalai, si e Ahira, sa tuna e Enani.” ");
INSERT INTO rug_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Arini sari na tie ta vizatadi koari hopeke butubutu, na koimata koari na hopeke dia butubutu soti. ");
INSERT INTO rug_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","18","Pa rane kekenuna sa sidara vina rua, koasa tinokae tadi ka manege rua baṉara sara, si tioko varigarani e Mosese meke Eroni sari doduru butubutu, meke kubere goreni sari doduru tie, koari na butubutu na dia tatamana. Pozadi sari doduru tie saripu ka hiokona puta vuahenidi, meke kamo koari na tie komihadi, si ta kubere gore meke ta nae, ");
INSERT INTO rug_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","gua puta tugo sapu tozia Zihova. Pa korapa soloso qega, pa popoa Saenai, si kubere goreni Mosese pozadi sari doduru tie. ");
INSERT INTO rug_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","46","Sari na tie saripu ka hiokona puta vuahenidi, kamo koari na tie komihadi, arini pu garo pa vinaripera, si ta kubere gore pozadi, koari na dia butubutu na tatamana, podalae koasa butubutu te Rubeni, sa tuna kenuna e Zekopi. Sari na ninaedi ri doduru tie si gua hire: koasa butubutu Rubeni, sa sinokudi ri na tie varipera si ari ka made ṉavulu onomo tina lima gogoto; koasa butubutu Simione, sa sinokudi ri na tie varipera si ari ka lima ṉavulu sia tina ṉeta gogoto; koasa butubutu Qadi, sa sinokudi ri na tie varipera si ari ka made ṉavulu lima tina onomo gogoto lima ṉavulu puta; koasa butubutu Ziuda, sa sinokudi ri na tie varipera si ari ka zuapa ṉavulu made tina onomo gogoto; koasa butubutu Isaka, sa sinokudi ri na tie varipera si ari ka lima ṉavulu made tina made gogoto; koasa butubutu Zeboloni, sa sinokudi ri na tie varipera si ari ka lima ṉavulu zuapa tina made gogoto; koasa butubutu Iparemi, sa sinokudi ri na tie varipera si ari ka made ṉavulu tina lima gogoto; koasa butubutu Manase, sa sinokudi ri na tie varipera si ari ka toloṉavulu rua tina karua gogoto; koasa butubutu Benisimane, sa sinokudi ri na tie varipera si ari ka toloṉavulu lima tina made gogoto; koasa butubutu Dani, sa sinokudi ri na tie varipera si ari ka onomo ṉavulu rua tina zuapa gogoto; koasa butubutu Asa, sa sinokudi ri na tie varipera si ari ka made ṉavulu eke tina lima gogoto; koasa butubutu Napitalai, sa sinokudi ri na tie varipera si ari ka lima ṉavulu ṉeta tina made gogoto; Sa vinarigaraedi ri doduru tie varipera si ari ka onomo gogoto ṉeta tina lima gogoto lima ṉavulu puta: ");
INSERT INTO rug_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Sari na tie pa butubutu Livae mo si lopu ta kubere gore pozadi gua rina votiki butubutu, ");
INSERT INTO rug_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","sina zama se Zihova koe Mosese, ");
INSERT INTO rug_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Totoso kubere goreni gamu sari na pozadi ri na tie pu garodi pude varipera, si lopu kaqu va somanae ia gamu sa butubutu Livae. ");
INSERT INTO rug_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Ba kote va kopuni mo gamu koasa Qua Ipi Hopena meke sari doduru likakalae tanisa tinavete vasina, meke arini si kaqu kopu nia na palekia totoso rizu gamu, meke koa vari likohae nia pa korapana sa kinoa tie. ");
INSERT INTO rug_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Totoso rizu gamu koasa mia kinoa varigara, si kaqu pazu goreni ri na tie Livae sari na ipi meke kaqu va turu pulei koari na vasidi vaquradi. Be esei sa votiki tie sapu tata mae koasa Ipi Hopena, si kaqu tava mate tugo si asa. ");
INSERT INTO rug_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Sari na tinoni Izireli si kaqu va turui sari na dia ipi, koari hopeke dia pukuna. Hopeke tie si kaqu koa koasa nana pukuna, pa kauruna sa nana pitipiti soti. ");
INSERT INTO rug_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Ba sari na tie pa butubutu te Livae si kaqu koa kopu vari likohae nia sa Ipi Hope, pude loke tie Izireli si kaqu ene tata mae meke tava kilasa koasa binugoro te Zihova.” ");
INSERT INTO rug_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Gua asa ke tavete betoi ri na tie Izireli sari doduru gua pu zamani e Zihova koe Mosese. ");
INSERT INTO rug_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Zama la se Zihova koa ri Mosese meke Eroni: ");
INSERT INTO rug_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Pana va turui rina tinoni Izireli sari na dia ipi, hopeke rini si kaqu koa varigara koasa dia puku butubutu pa kauruna sa pitipiti tanisa butubutu meke sari na pitipiti tadi hopeke tutidia soti. Meke sari doduru hopehopeke pukudi si kaqu koa va seu hite vari likohae nia sa Ipi Hopena.” ");
INSERT INTO rug_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Sa butubutu te Ziuda, si kaqu va turui sari na dia ipi pa kali gasa rimata koasa Ipi Hopena, pa kauruna sa dia pitipiti. Hopeke puku tatamana si kaqu koa varigara pa tutidia. Sa koimata tanisa butubutu te Ziuda si e Nasoni, sa tuna e Aminadabi. ");
INSERT INTO rug_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Sa ninae tanisa puku tie varipera te Ziuda si ari ka zuapa ṉavulu made tina onomo gogoto. ");
INSERT INTO rug_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Sa butubutu te Isaka si kaqu va turui sari na dia ipi kapae koe Ziuda pa kali gasa rimata. Sa koimata tanisa butubutu te Isaka si e Netanela, sa tuna e Zua, ");
INSERT INTO rug_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","meke sa ninae tanisa puku tie varipera te Isaka si ari ka lima ṉavulu made tina made gogoto. ");
INSERT INTO rug_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Sa butubutu te Zeboloni si kaqu va turui sari na dia ipi kapae koe Isaka pa kali gasa rimata. Sa koimata tanisa butubutu te Zeboloni si e Eliabi, na tuna e Heloni, ");
INSERT INTO rug_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","meke sa ninae tanisa puku tie varipera te Zeboloni si ari ka lima ṉavulu zuapa tina made gogoto. ");
INSERT INTO rug_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Sa vinarigaradi ri doduru pu koa pa kali gasa rimata si ari ka keke gogoto vesu ṉavulu onomo tina made gogoto tie. Sa butubutu te Ziuda si kote ene va kenue koa rini totoso taluarae la pa votiki vasina si arini. ");
INSERT INTO rug_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Sa butubutu te Rubeni, si kaqu va turui sari na dia ipi pa kali mataonasa Ipi Hopena, pa kauruna sa dia pitipiti. Hopeke puku tatamana si kaqu koa varigara pa tutidia. Sa koimata tanisa butubutu te Rubeni si e Elizua, tuna e Sedeu. ");
INSERT INTO rug_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Sa ninae tanisa puku tie varipera te Rubeni si ari ka made ṉavulu onomo tina lima gogoto. ");
INSERT INTO rug_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Sa butubutu te Simione si kaqu va turui sari na dia ipi kapae koe Rubeni pa kali mataona sa Ipi Hopena. Sa koimata tanisa butubutu te Simione si e Selumieli, tuna e Zurisadai, ");
INSERT INTO rug_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","meke sa ninae tanisa puku tie varipera te Simione si ari ka lima ṉavulu sia tina ṉeta gogoto. ");
INSERT INTO rug_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Sa butubutu te Qadi si kaqu va turui sari na dia ipi kapae koe Simione pa kali mataona sa Ipi Hopena. Sa koimata tanisa butubutu te Qadi si Eliasapi, tuna e Dueli, ");
INSERT INTO rug_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","meke sa ninae tanisa puku tie varipera te Qadi si ari ka made ṉavulu tina onomo gogoto lima ṉavulu. ");
INSERT INTO rug_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Sa vinarigaraedi ri doduru pu koa pa kali mataona sa Ipi Hopena si ari ka keke gogoto lima ṉavulu eke tina made gogoto lima ṉavulu. Sari ka ṉeta butubutu pa kali mataona si kaqu ene luli koa ri ka ṉeta butubutu saripu ta turaṉa koe Ziuda, totoso taluarae la pa votiki vasina si arini. ");
INSERT INTO rug_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Sari na tie pa butubutu te Livae si kaqu ene pa varikorapadi ri doduru tie Izireli. Kote luli rini sari ka onomo butubutu kekenu meke palekia rini sa Ipi Hopena. Hopeke butubutu si kaqu ene luli koari hopeke dia pitipiti pa dia inene la. ");
INSERT INTO rug_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Sa butubutu te Iparemi si kaqu va turui sari na dia ipi pa kali lodu rimata koasa Ipi Hopena pa kauruna sa dia pitipiti. Sa koimata tanisa butubutu te Iparemi si e Elisama, tuna e Amihudi, ");
INSERT INTO rug_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","meke sa ninae tanisa puku tie varipera te Iparemi si ari ka made ṉavulu tina lima gogoto. ");
INSERT INTO rug_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Sa butubutu te Manase si kaqu va turui sari na dia ipi kapae koe Iparemi pa kali lodu rimata koasa Ipi Hopena. Sa koimata tanisa butubutu te Manase si e Qamalieli, tuna e Pedazu, ");
INSERT INTO rug_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","meke sa ninae tanisa puku tie varipera te Manase si ari ka toloṉavulu rua tina karua gogoto. ");
INSERT INTO rug_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Sa butubutu te Benisimane si kaqu va turui sari na dia ipi kapae koe Manase pa kali lodu rimata koasa Ipi Hopena. Sa koimata tanisa butubutu te Benisimane si e Abidani, tuna e Qitione, ");
INSERT INTO rug_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","meke sa ninae tanisa puku tie varipera te Benisimane si ari ka toloṉavulu lima tina made gogoto. ");
INSERT INTO rug_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Sa vinarigaraedi ri doduru pu koa pa kali lodu rimatana sa Ipi Hopena si ari ka keke gogoto vesu tina keke gogoto. Sari ka ṉeta butubutu pa kali lodu rimata si kaqu ene luli koa sa butubutu te Livae, totoso taluarae la pa votiki vasina si arini. ");
INSERT INTO rug_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Sa butubutu te Dani si kaqu va turui sari na dia ipi pa kali gede sa Ipi Hopena pa kauruna sa dia pitipiti. Sa koimata tanisa butubutu te Dani si e Ahieza, tuna e Amisadai, ");
INSERT INTO rug_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","meke sa ninae tanisa puku tie varipera te Dani si ari ka onomo ṉavulu rua tina zuapa gogoto. ");
INSERT INTO rug_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Sa butubutu te Asa si kaqu va turui sari na dia ipi kapae koe Dani pa kali gede koasa Ipi Hopena. Sa koimata tanisa butubutu te Asa si e Paqieli, tuna e Okarani, ");
INSERT INTO rug_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","meke sa ninae tanisa puku tie varipera te Asa si ari ka made ṉavulu eke tina lima gogoto. ");
INSERT INTO rug_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Sa butubutu te Napitalai si kaqu va turui sari na dia ipi kapae koe Asa pa kali gede koasa Ipi Hopena. Sa koimata tanisa butubutu te Napitalai si e Ahira, tuna e Enani, ");
INSERT INTO rug_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","meke sa ninae tanisa puku tie varipera te Napitalai si ari ka lima ṉavulu ṉeta tina made gogoto. ");
INSERT INTO rug_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Sa vinarigaraedi ri doduru pu koa pa kali gede koasa Ipi Hopena si ari ka keke gogoto lima ṉavulu zuapa tina onomo gogoto. Sari ka ṉeta butubutu pa kali gede koasa Ipi Hopena si kaqu ene luli koa sa butubutu te Benisimane, totoso taluarae la pa votiki vasina si arini. ");
INSERT INTO rug_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Sari na vinarigaraedi ri doduru tinoni Izireli koari na dia pinaqaha na pukudi si ari ka onomo gogoto ṉeta tina lima gogoto lima ṉavulu tie. ");
INSERT INTO rug_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Gua tugo sapu tozi nia e Zihova koe Mosese, si lopu ta kubere gore turaṉae tugo koari na tinoni Izireli, sari na tie koasa butubutu te Livae. ");
INSERT INTO rug_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Gua asa, ke taveti ri doduru tinoni Izireli, sari doduru gua pu tozi nia e Zihova koe Mosese. Hopeke va turu ipi varigara pa kauruna sa dia pitipiti soti koari hopeke dia butubutu, meke koari dia butubutu soti tugo si ene luli varigara tugo si arini. ");
INSERT INTO rug_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Hire sari na tatamana tadi Eroni meke Mosese pa totoso sipu zama la se Zihova koe Mosese pa toqere Saenai. ");
INSERT INTO rug_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Ari ka made sari na tuna koreo e Eroni: e Nadabi sa kenuna, e Abihu, e Eleaza meke e Itamara. ");
INSERT INTO rug_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Na hiama ta vizatadi meke tava madidi si arini, ");
INSERT INTO rug_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","ba se Nadabi meke Abihu si tava mate sipu evaṉia ri karua sa sinea pa kenuna e Zihova; na veko turaṉae motete na oto huda humaṉa lea sapu lopu madina pa siraṉa sapu tozia e Zihova pa korapa popoa qega pa Saenai. Loke tudia sari karua, ke ari Eleaza meke Itamara mo si tavetia sa tinavete hiama pa totoso te Eroni. ");
INSERT INTO rug_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Zama la koe Mosese se Zihova, ");
INSERT INTO rug_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Mu turaṉa mae nia koe Eroni sa butubutu te Livae; mamu va madi si arini pude tavetavete toka nia se Eroni koasa tinavete hiama. ");
INSERT INTO rug_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Kaqu toka nia rini si asa meke sari na tinoni Izireli pude taveti sari na tinavete hiama, pu ta hivae koasa Ipi Hopena pa kenuna e Zihova. ");
INSERT INTO rug_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Kaqu kopuni rini sari doduru likakalae tanisa Ipi Hopena, meke kaqu tavetaveteni rini pude tokani sari doduru tinoni Izireli koari na dia vinatabena sa tinarae te Zihova. ");
INSERT INTO rug_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Sa tinavete tadi na tinoni pa butubutu te Livae, si pude toka nia mo se Eroni meke sari na tuna koreo. ");
INSERT INTO rug_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Kaqu vizatia goi se Eroni meke sari na tuna koreo, pude taveti sari na tinavete tana hiama, ba sa votiki tie sapu hiva tavete luli sari na tinavete gua arini si kaqu tava mate.” ");
INSERT INTO rug_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Zama koe Mosese se Zihova, ");
INSERT INTO rug_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","13","“Sari na tie pa butubutu te Livae si Taqarau kamahire. Totosona va matei Rau sari doduru tudia koreo kenudi ri na tinoni Izipi, si va madi Rau, pude Taqarau soti, sari hopehopeke tudia koreo kenudi ri doduru tatamana Izireli, meke sari doduru tudia kenudi ri na kurukuru. Ego, sari na tuna koreo e Livae si hobei sari na tuna koreo kenudi rina tie Izireli. Ba kaqu Taqarau tugo si arini. Ura, Arau se Zihova.” ");
INSERT INTO rug_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Pa korapa qega pa popoa Saenai, si tozi nia e Zihova se Mosese, ");
INSERT INTO rug_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","pude kubere goreni pozadi sari na tuna koreo e Livae, koari hopeke dia butubutu na tatamana. Naei sari doduru tudia koreo keke sidaradi podo gua babe hola nia, ");
INSERT INTO rug_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","meke tavetia tugo e Mosese sapu gua asa. ");
INSERT INTO rug_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","20","E Livae si ka ṉeta tuna koreo. Ari Qerisoni, Kohati meke Merari. Arini sari na tiatamadia rina butubutu saripu gore mae koari na pozadia si hire: Se Qerisoni si karua tuna koreo: Ari Libini meke e Simei. E Kohati si, ari ka made sari tuna koreo: Ari Amaramu, Izihara, Heboroni, meke Uzieli; se Merari si karua tuna koreo: Ari Mahili meke e Musi. Arini si tuti gore maedi koe Merari pa butubutu Livae. ");
INSERT INTO rug_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Sa butubutu te Qerisoni, si podalae ni sari na tatamana te Libini meke Simei. ");
INSERT INTO rug_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Sari vinarigaraedi ri na tuna koreo pu keke sidaradi podo gua meke hola, saripu somana ta kubere gore, si ari ka zuapa tina lima gogoto. ");
INSERT INTO rug_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Sa butubutu hie si kaqu koa varigara pa kali lodu rimata, pa mudina sa Ipi Hopena, ");
INSERT INTO rug_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","meke se Eliasapi sa tuna e Laela, si na koimata koasa butubutu hie. ");
INSERT INTO rug_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Sari na tie hire, si kaqu kopu nia sa Ipi Hopena, sari na poko nobina pa korapana meke pa sadana, sa goba poko nuqunuquruana, ");
INSERT INTO rug_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","sari na goba poko pa vari likohaena sa pavasa tanisa Ipi Hopena meke sa hope, meke kaqu kopu nia rini sa goba poko koasa nuqunuquruana tanisa pavasa meke sari na aroso pusipusiana tana ipi meke sari doduru tinavete la gua koasa kinopudi rina tiṉitoṉa arini. ");
INSERT INTO rug_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Sa butubutu te Kohati si podalaeni sari na tatamana te Amaramu, Izihara, Heboroni, meke Uzieli. ");
INSERT INTO rug_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Sa vinarigaraedi rina tuna koreo pu keke sidaradi podo gua meke hola, saripu somana ta kubere gore, si ari ka zuapa tina lima gogoto. Sa tinavete tadirini si pude kopuni sari doduru tiṉitoṉa tanisa Ipi Hopena. ");
INSERT INTO rug_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Sa butubutu hie si kaqu koa varigara pa kali mataona sa Ipi Hopena, ");
INSERT INTO rug_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","meke se Elizapani, sa tuna e Uzieli, si na koimata koasa butubutu hie. ");
INSERT INTO rug_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Sari na tie hire si kaqu kopu nia sa Bokese tanisa Vinariva Egoi, sa tevolo, sa tuturuana zuke, sari na hope, sari doduru likakalae saripu tavetaveteni rini koasa ipi, meke sa poko goba pa Lose Hopena pa Hopena meke sari doduru tinavete la gua pude tavetaveteni meke kopuni rini. ");
INSERT INTO rug_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Sa koimata tadi na tie pa butubutu te Livae, si e Eleaza, na tuna koreo e Eroni sa hiama. Sa tinavete tanisa, si pude kopuni sarini pu somana pa tinavete pa korapana sa vasina Hopena. ");
INSERT INTO rug_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Sa butubutu te Merari, si podalaeni sari na tatamana tadi Mahili meke Musi. ");
INSERT INTO rug_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Sa vinarigaraedi rina tuna koreo pu keke sidaradi podo gua meke hola, saripu somana ta kubere gore pozadi, si ari ka onomo tina karua gogoto. ");
INSERT INTO rug_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Se Zurieli, sa tuna koreo e Abihaili, si na koimata koasa butubutu asa. Sa butubutu hie si kaqu koa varigara pa dia ipi pa kali gede koasa Ipi Hopena. ");
INSERT INTO rug_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Meke sa tinavete tadirini, si pude kopuni sari na hopeke kukuruna sa Ipi Hope, sari na huda barabara, sari na gaso pilipilivaratana, sari na dedegerena, sari na vovoina siliva, meke sari doduru tinavete la gua pude tavetaveteni meke kopuni rini. ");
INSERT INTO rug_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Meke kopuni tugo rini sari na dedegerena, sari na vovoina, sari na tupili, meke sari na aroso pusipusiana tanisa gobagoba poko vari likohaena sa Ipi Hopena. ");
INSERT INTO rug_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Mosese, Eroni meke sari na tudia koreo si kaqu va turui sari na dia ipi pa kenuna sa Ipi Hopena pa kali gasa rimata. Sa dia tinavete rini si pude va enea sa tinavete, sapu ta tozi nia rini koasa vasina hopena, pude tokani sari na tinoni Izireli. Be esei sapu mae ene tata ia sa vasina hopena asa si kaqu tava mate. ");
INSERT INTO rug_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Sa vinarigaraedi rina tuna koreo pu keke sidaradi podo gua meke hola, saripu somana ta kubere gore pozadi koe Mosese meke Eroni pa hopeke dia puku tatamana gua sapu ele garunu nia se Zihova, si ari ka hiokona rua tina. ");
INSERT INTO rug_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","41","Zama koe Mosese se Zihova, “Sari doduru tumia koreo podo kenudi pa butubutu Izireli si Taqarau beto. Ke mamu kubere gore betoi pozadi sari doduru koreo Izireli saripu podo kenudi, saripu keke sidaradi podo gua meke hola. Ba sa hinobedi rini, si hivani Rau sari na tie pa butubutu te Livae si pude Taqarau. Meke gua tugo sari na rovana bulumakao tadi na tie pa butubutu te Livae si kaqu hobeni koari na rovana bulumakao tudia kokoreo podo kenudi tadi tie Izireli. Sina Arau se Zihova!” ");
INSERT INTO rug_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Va tabe se Mosese, meke kubere gore betoni sa sari doduru tudia koreo kenudi ");
INSERT INTO rug_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","saripu keke sidara pododi gua meke hola; sa vinarigaraedi si ari ka hiokona rua tina karua gogoto zuapa ṉavulu ṉeta. ");
INSERT INTO rug_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Zama la koe Mosese se Zihova, ");
INSERT INTO rug_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Ego, kamahire mamu va madi sari na tie pa butubutu te Livae, pude Taqarau na hinobedi ri doduru koburu haha koreo kenudi pa butubutu Izireli; mamu va madi tugo sari na rovana bulumakao tadi na tie pa butubutu te Livae, na hinobedi ri pu podo kenudi koari na rovana bulumakao tadi pa Izireli. ");
INSERT INTO rug_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","47","Ari karua gogoto zuapa ṉavulu ṉeta sinokudi sari na koburu koreo haha podo kenudi tadi na tinoni pa butubutu Izireli, si soku holani rini sarini pa butubutu te Livae, gua asa ke, mamu holu hobei gamu si arini. Mamu vagi ka lima poata siliva padana sa hinoluna pa keke. Kaqu ta pada mamatana sa poata siliva sapu hoke pada nia pa keke sekeli mamatana pa tinavete koasa Ipi Hopena. ");
INSERT INTO rug_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Mamu vala nia sa poata hie koe Eroni meke sari na tuna koreo.” ");
INSERT INTO rug_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Tavete betoi Mosese si hire ");
INSERT INTO rug_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","meke vagi sa sari ka keke tina ṉeta gogoto onomo ṉavulu lima poata siliva ");
INSERT INTO rug_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","meke vala i koe Eroni meke sari na tuna koreo. ");
INSERT INTO rug_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Zama la koe Mosese se Zihova, ");
INSERT INTO rug_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Mu naei sari na tie pa butubutu te Livae sari na tuna koreo Kohati. Paqahi pa butubutu na tatatamana, ");
INSERT INTO rug_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","mamu kubere goreni sari doduru pozadi ri na tie, pu ka toloṉavulu meke kamoa lima ṉavulu vuahenidi, saripu bokabokadi pude tavetavete pa korapa Ipi Hopena pa kenuna e Zihova. ");
INSERT INTO rug_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Kaqu tavetavete ni rini sari na likakalae hopedi pa hopedi. ");
INSERT INTO rug_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Pana va namanama sa butubutu te Izireli pude taluarae la pa votiki popoa, se Eroni meke sari na tuna koreo si kaqu nuquru la pa korapa Ipi Hopena, meke kaqu vagi va gorei rini sari na poko goba pa kenuna sa Bokese Vinariva Egoi meke nobi nia koasa Bokese. ");
INSERT INTO rug_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Kaqu va hake ulue la nia rini sa nobinobi kapu rumu, meke kaqu ivara la nia rini si keke poko bulu ṉiṉirana pa batuna meke kaqu va nuquru lani rini sari na huda palepalekeana. ");
INSERT INTO rug_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Koasa tevolo pa kenuna e Zihova, si kaqu ivara nia rini sa poko bulu, meke kaqu vekoi rini vasina sari na peleta, meke kaiqa vovoina, na baolo, meke sari na zagi tana napo vaeni; sari na bereti si lopu kaqu makudo hake dia mo koasa tevolo. ");
INSERT INTO rug_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Kaqu repahia rini sa poko ziṉara, meke va hake ulue ia koari doduru tiṉitoṉa hire, meke kaqu nobi nia kapu rumu, meke tiqe zukuru nuquru lani sari karua huda palepalekeana. ");
INSERT INTO rug_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Kaqu vagia rini si keke poko bulu, meke nobia sa tuturuana zuke meke sari na zukena, turaṉae ni sari na nopihi na palepalekeana tiṉitoṉa meke sari doduru vovoina oela olive. ");
INSERT INTO rug_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Kaqu hadei rini sari doduru likakalae arini koa keke kapu rumu meke vekoi rini koa keke tiṉitoṉa palepalekeana, pude paleki. ");
INSERT INTO rug_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Beto asa, si kaqu ivara nia rini si keke poko bulu pa batuna sa hope qolo, meke nobi nia keke kapu rumu meke tiqe zukuru nuquru lani sari na huda palepalekeana. ");
INSERT INTO rug_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Kaqu vagi rini sari doduru likakalae saripu tavetavete ni rini pa korapa Ipi Hopena, meke hadei koa keke poko bulu si arini, meke nobi koa keke kapu rumu si arini, meke la vekoi koa keke tiṉitoṉa palepalekeana. ");
INSERT INTO rug_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Kaqu va vura pani rini sari na eba koasa hope boronizi tana vina vukivukihi, meke kaqu nobi nia rini sa poko pepolo pa batuna sa hope. ");
INSERT INTO rug_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Kaqu va hakei rini koasa hope sari doduru likakalae, saripu tavetaveteni rini pa vinahesi koasa hope, sapu sari na raro boronizi pude oki pani sari na eba, sari na poka ililiriana masa, sari na raro boronizi pude tana nika, meke sari na besini boronizi pude tana sisiruana ehara, meke kaqu nobi ni koa keke kapu rumu si arini, meke va hakei koa keke tiṉitoṉa palepalekeana. ");
INSERT INTO rug_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Meke sipu ele nobi ri Eroni meke sari na tuna koreo sari doduru likakalae arini, meke pana kamoa sa totoso pude taluarae sa butubutu te Izireli, si kaqu mae sa butubutu te Kohati meke paleki sari na tiṉitoṉa madidi. Sari na tie pa butubutu te Kohati, si lopu kaqu taṉini sari na tiṉitoṉa hopedi arini, be lopu gua si kote mate si arini. Arini sari na tinavete tadi na tie pa butubutu te Kohati, pana tava rizu sa Ipi Hopena. ");
INSERT INTO rug_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Sa tinavete te Eleaza, sa tuna koreo e Eroni sa hiama, si pude kopu nia sa Ipi Hopena meke sari na tiṉitoṉa tanisa meke sa doduruna sa tinavetavete koasa Ipi Hopena sapu na oela tadi na zuke, na oto huda humaṉa lea, meke na vinariponi huiti sapu kaqu ta vala doduru totoso, na oela hopena tana vina madi, meke sari doduru tiṉitoṉa pa korapa Ipi Hopena saripu ele tava madidi koe Zihova.” ");
INSERT INTO rug_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Meke Zama la koe Mosese meke Eroni se Zihova, ");
INSERT INTO rug_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Mi kopuni sari na tie pa butubutu te Kohati, ");
INSERT INTO rug_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","pude lopu tava mate, pude lopu tata mae koari na tiṉitoṉa hope pa hopedi hire si arini. Pude lopu vata evaṉia sapu gua asa, si lopu kaqu dogori rini sari na tiṉitoṉa hopedi. Se Eroni meke sari na tuna koreo si kaqu nuquru la, meke hopeke tozia koari na tie, sa tinavete sapu kote tavetia sa. ");
INSERT INTO rug_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Ba sari na tuna Kohati si lopu kaqu nuquru la pa korapa Ipi Hope, meke dogori rini sari na hiama sipu korapa va namanama i rini sari na tiṉitoṉa madidi pude ta paleke va rizu,” gua. ");
INSERT INTO rug_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Zama la koe Mosese se Zihova, ");
INSERT INTO rug_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Mu naei sari na tuna Qerisoni pa butubutu te Livae, pa hopeke dia butubutu na tatamana. ");
INSERT INTO rug_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Mamu kubere goreni sari doduru pozadi ri na tie, pu ka toloṉavulu puta vuahenidi meke kamoa lima ṉavulu vuahenidi, saripu bokabokadi pude tavetavete pa korapa Ipi Hopena pa kenuna e Zihova. ");
INSERT INTO rug_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Sari na dia tinavete si pude paleki sari na tiṉitoṉa hire: ");
INSERT INTO rug_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Sa Ipi Hope, sari na poko pa korapana, sari na poko pa sadana, sa poko nobi kapu rumu ṉiṉirana pa batuna, sa poko goba pa sasadana, ");
INSERT INTO rug_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","sari na gobagoba poko, meke sari na aroso pusipusiana vari likohaena sa Ipi Hopena meke sa hope, sari na poko goba pa sasadana sa pavasa, meke sari doduru tiṉitoṉa saripu kaqu tavetaveteni rini koari na gobagoba poko. Kaqu taveti rini sari doduru tinavete saripu ta hivae koari na tiṉitoṉa arini. ");
INSERT INTO rug_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Kaqu kopuni ri Mosese meke Eroni sapu taveti ri na tuna Qerisoni sari doduru dia tinavete meke paleke betoi rini sari doduru likakalae pu va kopuni ri Eroni meke sari na tuna koreo koa rini. ");
INSERT INTO rug_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Arini sari na tinavete koasa butubutu te Qerisoni pa Ipi Hopena. Kaqu paleki rini sari na tiṉitoṉa tanisa Ipi Hopena koasa vina toṉoto te Itamara sa tuna koreo e Eroni sa hiama.” ");
INSERT INTO rug_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Zama se Zihova koe Mosese pude naei sari na tuna Merari pa butubutu te Livae, podalae koari na dia butubutu hitekedi na tatatamana te Merari, ");
INSERT INTO rug_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","meke kaqu kubere goreni rini pozadi sari doduru tie nomadi sapu toloṉavulu vuahenidi meke kamoa lima ṉavulu vuahenidi, sarini pu bokabokadi pa tinavete pa korapa Ipi Hopena pa kenuna e Zihova. ");
INSERT INTO rug_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Sa dia tinavete si pude paleki sari na huda barabarana sa Ipi, sari na gaso pilipilivarata, na dedegere, meke sari na vovoina vasina turu sari na barabara tanisa Ipi Hope, ");
INSERT INTO rug_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","meke gua tugo sari na dedegeredi rina gobagoba poko vari likohaena sa pavasa, sari na dedegerena, sari na vovoina, meke sari na aroso pusipusiana, meke sari na tupili, meke sari doduru vinari hodahodaena pude tana vinaturuna. Hopeke tie si kaqu palekia gua sapu tozi nia Eroni koasa. ");
INSERT INTO rug_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Arini sari na tinavete saripu kaqu taveti rina tuna Merari pa butubutu Livae koasa Ipi Hopena; kaqu paleki rini si arini pa vina toṉoto te Itamara, sa tuna koreo Eroni sa hiama. ");
INSERT INTO rug_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","48","Lulia Mosese meke Eroni meke sari na koimata pa butubutu Livae sa zinama te Zihova, meke naei rini sari ka ṉeta butubutu te Livae, ari Kohati, Qerisoni meke Merari. Meke nae va hiteke gorei rini koari hopeke dia butubutu na tatatamana meke tiqe kubere goreni rini pozadi sari doduru tie nomadi podalae toloṉavulu vuahenidi meke kamoa lima ṉavulu vuahenidi saripu bokabokadi pa tinavete koasa Ipi Hopena pa kenuna e Zihova, meke hire sari na sinokudi rini: Koasa butubutu Kohati si ari ka karua tina zuapa gogoto lima ṉavulu tie. Koasa butubutu Qerisoni si ari ka karua tina onomo gogoto toloṉavulu tie. Koasa butubutu Merari si ari ka ṉeta tina karua gogoto tie. Sa vinarigaraedi ri doduru tie si ari ka vesu tina lima gogoto vesu ṉavulu. ");
INSERT INTO rug_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Hopeke tie si ta nae pa ginarunu te Zihova koe Mosese, meke pa ginarunu tugo te Zihova koe Mosese si ta poni tinavete sari hopeke tie pude paleki sari na tiṉitoṉa tanisa Ipi Hopena. ");
INSERT INTO rug_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Zama se Zihova koe Mosese, ");
INSERT INTO rug_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Mu tozini sari na tinoni Izireli pude va rizu ilolae i sari doduru tie pa korapa kinoa tie saripu koai na minoho kaleadi kapudi, babe na minoho malea, na vura muzi kukuru tinidi, meke sarini pu tiqui sari na tie matedi. ");
INSERT INTO rug_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Mu va rizu ilolae i sari na tinoni bonidi koasa hahanana vina madi, pude lopu kaqu va bonia rini sa kinoa tie, vasina koa ia Rau.” ");
INSERT INTO rug_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Va tabe sari na tinoni Izireli meke va rizu ilolae i rini sari na tie bonidi pa kinoa tie. ");
INSERT INTO rug_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Zama se Zihova koe Mosese, ");
INSERT INTO rug_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Sari na vina tumatumae hire, si pude tadi na tinoni Izireli. Pana lopu va tabea sa tie se Zihova meke lopu tavete va leana la koa ke tie, ");
INSERT INTO rug_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","si kaqu helahelae nia sa sa nana sinea, meke vala nia sa sa doduruna sa hinerehere, meke tomo pule la nia pule ka hiokona puta paseniti la koasa tie pu va kaleana la ia sa. ");
INSERT INTO rug_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Ba be mate sa tie sana meke loke turaṉana soti si toa pude boka vagi sapu gua here nia sa tie pu tavete va kaleana, si kaqu ta vala koe Zihova sa hinere asa pude tanisa hiama. Sa hinere asa meke sa sipi kokoreo pude na vina vukivukihi hinerehere, si ta vala beto koasa hiama. ");
INSERT INTO rug_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Sari doduru vinariponi madidi, saripu poni lani ri na tinoni Izireli koe Zihova, si tanisa hiama pu ade vagidi si arini. ");
INSERT INTO rug_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Sari na vinariponi saripu ta vala koasa hiama si tanisa hiama mo.” ");
INSERT INTO rug_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Zama se Zihova koe Mosese, ");
INSERT INTO rug_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","14","“Tozi koari na tinoni Izireli sari na tinarae hire: ‘Be ta evaṉa sapu va potupotu nia keke palabatu sa nana barikaleqe, na lopu kokoa noso koasa si asa, meke rovea sa palabatu sapu ele baratia sa si keke votiki tie, meke va boni pule nia si asa, gua. Ba lopu gilana valeania sa palabatu, sina hokara tomea sa nana barikaleqe sapu gua asa, sina loke tie boka va sosodea, meke lopu ele ta poho sapu tavetia sa si asa. Babe ta evaṉa sapu va potupotu nia sa palabatu sa nana barikaleqe, ba lopu tavetia sa barikaleqe sapu gua asa. ");
INSERT INTO rug_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","Koari ginugua arini si kaqu turaṉa la nia sa palabatu sa nana barikaleqe koasa hiama. Kaqu paleki tugo sa sari na vinariponi kaqu ta hivaedi, keke kilo palava bale, ba lopu kaqu zoropo nia oela olive sa si asa, ba be veko turaṉia oto huda humaṉa lea si asa, sina na vinariponi mae guana pa pinotupotu tanisa palabatu si asa, pude va vura va bakalia sapu hinokarana ba lokari si asa. ");
INSERT INTO rug_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Kaqu turaṉia sa hiama sa barikaleqe, meke va turua pa kenuna sa hope pa kenuna Zihova. ");
INSERT INTO rug_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Kaqu zoropo lani sa si kaiqa kolo hopena, pa korapana keke baolo patu, meke kaqu pudiki vagi sa si kaiqa kavuru, saripu koa pa pepeso koasa Ipi Hopena, meke vekoi pa kolo, pude va pasa ia si asa. ");
INSERT INTO rug_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Beto asa si kaqu rupahia sa sa kaluna sa, barikaleqe, meke kaqu va taṉini nia sa sa vinariponi palava pa limana sa barikaleqe. Kaqu taṉinia nana sa hiama pa limana sa baolo, sapu koa ia na kolo pasana tana lineveleve. ");
INSERT INTO rug_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Kaqu tozi nia sa hiama sa barikaleqe pude va ego ia sa sa zinama tokotokoro sapu zama nia sa. “Be lopu barabarata si goi, si lopu kaqu ṉovaligo sa lineveleve, sapu kaqu vatua sa kolo pasana hie. ");
INSERT INTO rug_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Ba be ele barabarata si goi, ");
INSERT INTO rug_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","si mani ta levei koe Zihova sa pozamu koari na tie, meke kaqu va viziria sa sa kokoana koburu tamugoi meke kaqu moqo sa bogumu. ");
INSERT INTO rug_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Kaqu nuquru sa kolo pasana pa korapa tiamu meke kaqu moqo sa bogumu, meke sa kokoana tana koburu si kaqu viziri.” Kaqu olaṉa sa barikaleqe, “Va egoa rau, mani evaṉia e Zihova sapu gua asa.” ");
INSERT INTO rug_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Meke kaqu kubere gore nia sa hiama sa lineveleve meke kaqu ṉuzapa pania kolo pasana sa pa korapa baolo sa kinubekubere. ");
INSERT INTO rug_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Ba sipu lopu ele va napo nia sa koasa barikaleqe sa kolo, sapu kote va sigiti hola ia si asa, ");
INSERT INTO rug_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","si kaqu ade vagia sa hiama pa limana sa barikaleqe sa vinariponi palava, meke kaqu ovulu sage nia sa pa kenuna Zihova pude va madia koe Zihova, meke tiqe paleke la nia koasa hope. ");
INSERT INTO rug_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Kaqu taṉini va siṉi nia palava sa sa limana, pude va balabala nia sa vinariponi koe Zihova, meke tiqe kaqu la sulua sa pa hope. Beto asa, si kaqu va napo nia sa koasa barikaleqe sa kolo pasana. ");
INSERT INTO rug_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Be ele barabarata si asa, sa kolo si kaqu va sigiti hola ia si asa, meke kaqu moqo sa boguna meke sa kokoana tana koburu si kaqu viziri. Meke sa pozana si kaqu ta levei koari nana tinoni. ");
INSERT INTO rug_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Ba be lopu sea si asa, si lopu kaqu ta sigiti nia sa sa tinalevei, kote boka podo nana koburu mo si asa. ");
INSERT INTO rug_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","30","Asa sa tinaraena sa palabatu sapu konokono meke va potupotu nia sa nana barikaleqe sapu be ele barabarata gua. Kaqu tava turu pa kenuna e Zihova sa barikaleqe, meke sa hiama si kaqu lulia sa tinaraena sa vinapotupotu hie. ");
INSERT INTO rug_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Sa palabatu si lopu ta pusi nia sa sa sinea, ba sa barikaleqe tu, be guana ele sea si asa, si kaqu ta sigiti nia sa sa nana sinea.’ ” ");
INSERT INTO rug_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Tozi nia e Zihova se Mosese, ");
INSERT INTO rug_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Mamu tozini sari na tinoni Izireli sari na tinarae hire: ‘Be keke tie babe keke barikaleqe, si tavetia si keke ṉati vina tatara madina, pude ta evaṉae keke Naziraiti, meke va madi pule nia si asa koe Zihova, ");
INSERT INTO rug_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","si lopu kaqu napo ia sa sa napo vaeni meke na bia. Lopu kaqu napoi sa sari na votivotiki napo pu ta tavete mae guadi koari na vua qurepi d babe henai sari na vua qurepi, babe sari na vua qurepi pu ele tava popadi. ");
INSERT INTO rug_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Sipu korapa koa na tie Naziraiti si asa, si lopu kaqu hena ia sa si keke toṉa sapu mae guana koasa vuana sa huda vaeni, babe na kikona na kapuna sa qurepi. ");
INSERT INTO rug_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Koari na totoso sipu lulia sa sa vina tatara tanisa Naziraiti, si lopu kaqu kotoi sa sari na kaluna babe neri pani sari na gumina. Kaqu lulia sa sa vina tatara doduru totoso, sipu va madia sa sa nana tinoa koe Zihova, meke kaqu toqolo va nomai sa sari na kaluna na gumina. ");
INSERT INTO rug_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","7","Sari na kaluna, si na vina gilagilana sa vina madina koe Zihova, meke lopu kaqu tata la ia tugo sa sa tie matena; be guana sa tamana, tinana, tasina koreo, babe tasina vineki soti si asa, ba lopu kaqu tata la ia sa sa tie matena. ");
INSERT INTO rug_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Sipu koa na tie Naziraiti si asa, si tava madina si asa koe Zihova. ");
INSERT INTO rug_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Be tata la ia sa tie Naziraiti si keke tie sapu mate va hodaka, si ele tava boni sa kaluna; ka zuapa rane si kaqu aqa si asa, meke kaqu tiqe neri pani sa sari na kaluna na gumina. ");
INSERT INTO rug_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Koasa rane vina vesu, si kaqu paleke maeni sa si karua kukuva, meke karua baruku koasa hiama, pa sasadana sa Ipi Hopena pa kenuna e Zihova. ");
INSERT INTO rug_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Sa hiama si kaqu va vukivukihi nia si keke koari karua, pude na vina vukivukihi tana sinea, meke sa vina rua si tana vina vukivukihi va uququ. Ta tavete sa nana vina via madina asa, sina tata la ia sa sa tie matena. Pa rane tugo asa, si kaqu va madi pulei sa tie sari na kaluna; ");
INSERT INTO rug_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","meke sa nana totoso, sipu koa na tie Naziraiti si asa si kaqu tava madi pule koe Zihova si asa. Sari na totoso ele holadi, si lopu kaqu ta balabalae sina sari na kaluna pu tava madidi, si ele tava boni. Kaqu paleke mae nia sa si keke tuna sipi keke vuahenina pude na vina vukivukihi vinatoṉoto gale koasa vina tatara kekenu sapu lopu va hokotia sa. ");
INSERT INTO rug_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Pana ele hokoto beto sa totoso tanisa vina tatara tanisa tie Naziraiti, si kaqu tavetia sa sa vina madi. Kaqu la si asa koasa sasadana sa Ipi Hopena, ");
INSERT INTO rug_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","meke kaqu ponia sa koe Zihova ka ṉeta kurukuru loke ari kisakisadi: keke tuna sipi kokoreo, keke vuahenina, pude tana vina vukivukihi va uququ, keke tuna sipi mamaqota, keke vuahenina, pude na vina vukivukihini tana sinea, meke keke sipi kokoreo, pude tana vina vukivukihi binaere, ");
INSERT INTO rug_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","turaṉae koari na dia vinariponi huiti na vinariponi kolo vaeni, meke keke epata bereti sapu loke isitina. Sa bereti asa si kaqu ta tavete pa palava memehena sapu henia oela olive, meke bisikiti manivisidi sapu ta ṉuzapae oela olive, meke tomo la sari na huiti na vaeni, pu ta hivae pude tana vina vukivukihi. ");
INSERT INTO rug_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Doduru hire si kaqu ponia sa hiama koe Zihova: na vina vukivukihi tana sinea meke na vina vukivukihi va uququ; ");
INSERT INTO rug_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","beto asa si kaqu va vukivukihi la nia sa koe Zihova sa sipi kokoreo, pude na vina vukivukihi binaere koe Zihova, turaṉae nia sa epata bereti sapu loke isitina meke na vinariponi huiti na napo vaeni. ");
INSERT INTO rug_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Meke beto asa sa tie Naziraiti si kaqu ene la koasa sasadana sa Ipi Hopena, meke kaqu neri pani sa tie Naziraiti sari na kaluna, meke veko lani pa korapa nika tanisa vina vukivukihi binaere. ");
INSERT INTO rug_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Pa mudina, sipu ta raro sa avarana sa sipi kokoreo, si kaqu vagia sa hiama sa avarana sapu ta rarona, meke ponia koasa tie Naziraiti, turaṉae nia keke bereti nomana, meke keke bisikiti manivisina, sapu koa pa korapana sa epata. ");
INSERT INTO rug_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Beto asa, sa hiama si kote ovulu sageni pude va madi koa Rau Zihova; na vinariponi tava madidi si arini tanisa hiama, turaṉae nia sa raqaraqana meke sa pudapudana sa sipi kokoreo. Beto tu hoi, si kote boka napo vaeni sa tie Naziraiti. ");
INSERT INTO rug_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Arini tu sari na tinarae tadi na tie Naziraiti totoso va tatara nia rini keke ṉati vina tatara madina, pude ta evaṉae na tie Naziraiti. Kaqu tavete betoi rini sari na tinarae arini turaṉae ni sari na vinariponi na vina vukivukihi gua sapu ele ta tozi ni rini totoso va tatara nia rini sa dia vina tatara koe Zihova.’ ” ");
INSERT INTO rug_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Zama la koe Mosese se Zihova, ");
INSERT INTO rug_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Tozi nia se Eroni meke sari kasa tuna koreo pude zamani sari na zinama gua hire totoso mana ni gamu sari na tinoni Izireli: ");
INSERT INTO rug_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‘Mani manani gamu na kopuni gamu e Zihova. ");
INSERT INTO rug_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Mani va ṉedala maea e Zihova sa isumatana koa gamu meke vatukana gamu. ");
INSERT INTO rug_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Mani ponini gamu Sa sa tataru lopu ta ṉana kamona pude koa valeana pa binule.’ ” ");
INSERT INTO rug_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Meke zama se Zihova, “Be manani rini sari na tie Izireli pa pozaqu Rau, si kaqu manani Rau si arini,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Koasa rane sipu va hokotia e Mosese sa kinurina sa Ipi Hopena te Zihova, si va madia sa si asa, meke sari doduru tiṉitoṉa pa korapana, meke sa hope meke sari doduru tiṉitoṉa tavetaveteana tanisa. ");
INSERT INTO rug_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Meke sari na palabatu pu koimatani sari na butubutu Izireli, arini tugo sari na tie saripu kopuni ninaedi sari na tie, ");
INSERT INTO rug_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","si paleke maeni sari na dia vinariponi koe Zihova: Ka onomo tiṉitoṉa susuraṉana saripu koai hopeke made totopilidi, meke ka manege rua bulumakao nomadi, karua koimata pa keke totopili susuraṉana, meke hopeke koimata koari hopeke bulumakao nomadi. Sipu beto la vekoi rini pa kenuna sa Ipi Hopena, ");
INSERT INTO rug_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","si zama koe Mosese se Zihova, ");
INSERT INTO rug_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Mu ade vagi sari na vinariponi pude tana tinavete koasa Ipi Hope; mamu valani koari na tie Livae; madi tavetaveteni koari na dia tinavete.” ");
INSERT INTO rug_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Ke valani Mosese koari na tie Livae sari na totopili susuraṉana meke sari na bulumakao nomadi koari na tie Livae. ");
INSERT INTO rug_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Poni sa koari na tuna Qerisoni si karua totopili susuraṉana meke ka made bulumakao nomadi, ");
INSERT INTO rug_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","ka made totopili susuraṉana meke ka vesu bulumakao nomadi si valani sa koari na tuna Merari. Sari doduru dia tinavete si kote ta totolie koe Itamara sa tuna koreo e Eroni. ");
INSERT INTO rug_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Ba loke totopili susuraṉana babe bulumakao nomadi, si valani Mosese koari na tuna Kohati, sina sari na tiṉitoṉa madidi pu koa pa dia kinopu, si kaqu paleki rini pa avaradia. ");
INSERT INTO rug_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Sari na koimata si paleke la vinariponi tugo koasa vina madina sa hope. Totoso va namanama poni rini sari na vinariponi koasa hope, ");
INSERT INTO rug_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","si zama la koe Mosese se Zihova, “Hopeke rane koari ka manege rua rane, si keke koari na koimata si kaqu la vekoa sa nana vinariponi pude tana vina madina sa hope.” ");
INSERT INTO rug_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","83","Guahe sari na vinarilulidi rina dia vinariponi: Koasa rane vina keke e Nasoni, sa tuna koreo e Aminadabi, sapu na koimata pa butubutu Ziuda, si paleke la nia sa nana vinariponi. Koasa rane vina rua e Netanela, sa tuna koreo e Zua, sapu na koimata pa butubutu Isaka, si paleke la nia sa nana vinariponi. Koasa rane vina ṉeta e Eliabi, sa tuna koreo e Heloni, sapu sa koimata pa butubutu Zeboloni, si paleke la nia sa nana vinariponi. Koasa rane vina made e Elizua, sa tuna koreo e Sedeu, sapu sa koimata pa butubutu Rubeni, si paleke la nia sa nana vinariponi. Koasa rane vina lima e Selumieli, sa tuna koreo e Zurisadai, sapu sa koimata pa butubutu Simione, si paleke la nia sa nana vinariponi. Koasa rane Vina onomo e Eliasapi, sa tuna koreo e Dueli, sapu sa koimata pa butubutu Qadi, si paleke la nia sa nana vinariponi. Koasa rane vina zuapa e Elisama sa tuna koreo e Amihudi, sapu sa koimata pa butubutu Iparemi, si paleke la nia sa nana vinariponi. Koasa rane vina vesu e Qamalieli, sa tuna koreo e Pedazu, sapu sa koimata pa butubutu Manase, si paleke la nia sa nana vinariponi. Koasa rane vina sia e Abidani, sa tuna koreo e Qitione, sapu sa koimata pa butubutu Benisimane, si paleke la nia sa nana vinariponi. Koasa rane vina manege puta e Ahieza, sa tuna koreo e Amisadai, sapu sa koimata pa butubutu Dani, si paleke la nia sa nana vinariponi. Koasa rane vina manege eke e Paqieli, sa tuna koreo e Okarani, sapu sa koimata pa butubutu Asa, si paleke la nia sa nana vinariponi. Koasa rane vina manege rua e Ahira, sa tuna koreo e Enani, sapu sa koimata pa butubutu Napitalai, si paleke la nia sa nana vinariponi. Sari na vinariponi saripu hopeke vekoi ri na koimata tadi na tie Izireli: Keke vovoina baolo siliva sapu keke meke kukuru kilo mamatana, meke keke besini siliva sapu vesu gogoto qarami mamatana. Tava toṉoto koasa Ipi Hopena sari na pada hire, ta siṉie palava sapu ta henie oela sari doduru, pude na vinariponi huiti si asa; keke vovoina qolo sapu padana keke gogoto manege puta qarami sapu siṉia na oto huda humaṉa lea; keke bulumakao kokoreo vaqura, keke sipi kokoreo, meke keke tuna sipi keke vuahenina saripu tana vina vukivukihi va uququ; keke qoti na vina vukivukihi tana sinea; meke karua bulumakao kokoreo, ka lima sipi kokoreo, ka lima qoti, meke ka lima tuna sipi keke vuahenidi, pude na vina vukivukihi binaere. ");
INSERT INTO rug_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","88","Sa vinarigaraedi ri doduru vinariponi saripu ta paleke mae koari ka manege rua koimata pude tana vina madina sa hope si hire: Ka manege rua vovoina siliva meke manege rua baolo siliva, doduruna si padana hiokona zuapa kilo meke onomo qaramu mamatadi. Ka manege rua vovoina qolo sapu doduruna si padana keke kilo toloṉavulu rua qaramu mamatadi, siṉi na oto huda humaṉa lea. Ka manege rua bulumakao kokoreo, ka manege rua sipi kokoreo, meke ka manege rua tuna sipi keke vuahenidi, meke na vinariponi huiti, pude tana vina vukivukihi va uququ. Ka manege rua qoti tana sinea. Ka hiokona made bulumakao kokoreo, onomo ṉavulu sipi kokoreo, onomo ṉavulu qoti, meke onomo ṉavulu tuna sipi keke vuahenidi pude tana vina vukivukihi binaere. ");
INSERT INTO rug_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Totoso nuquru la pa korapa Ipi Hopena se Mosese pude zama la koe Zihova, si avosia sa se Zihova zama la koa sa pana uluna sa tukutuku Bokese Vinariva Egoi, pa varikorapadi ri karua tatapuru serubimi. ");
INSERT INTO rug_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Zama se Zihova koe Mosese, ");
INSERT INTO rug_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Mu tozi nia se Eroni, pana vekoi sa sari ka zuapa zuke koasa tuturuana zuke, si kaqu vekoi sa vasina pude sa gonana sa kalalasa si kaqu ṉedala la pa kenuna sa tuturuana zuke.” ");
INSERT INTO rug_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Va tabea Eroni si asa, meke vekoi sa sari na zuke koasa tuturuana zuke pude ṉedala la pa kenuna. ");
INSERT INTO rug_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Ta sekeseke vurae pa qolo podalae pa batuna meke kamoa hubina sa tuturuana zuke, lulia sa kineha sapu va dogoro nia e Zihova koe Mosese. ");
INSERT INTO rug_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Zama se Zihova koe Mosese, ");
INSERT INTO rug_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Mu veko vata kalei sari na tuna Livae koari doduru tie Izireli. Mamu va via i si arini ");
INSERT INTO rug_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","koasa siraṉa sapu guahe: Siburu va viani kolo, mamu tozi ni pude neri doduru tinidi, meke mamu tozini pude va via i dia poko. Meke kaqu via si arini pa dinoṉo te Zihova. ");
INSERT INTO rug_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Beto asa si kaqu vagia rini si keke bulumakao kokoreo vaqura, meke sa palava huiti sapu ele ta henie oela olive; meke keke pule bulumakao kokoreo pude na vina vukivukihi tana sinea. ");
INSERT INTO rug_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Beto asa, mamu varigara nia sa doduru butubutu Izireli, mamu va turui sari na tuna koreo Livae pa kenuna sa Ipi Hopena. ");
INSERT INTO rug_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Kaqu va opoi rina tie Izireli sari na limadi pa batudi rina tie Livae, ");
INSERT INTO rug_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","meke kaqu va madi Eroni sari na tie Livae pa pozaqu Rau, guana vinariponi mae guana koari na tie Izireli si arini, pude boka tavetia rini sa tinavete ninabulu koe Zihova. ");
INSERT INTO rug_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Beto sapu gua asa, si kaqu va opoi ri na tie Livae sari na limadia pa batudia ri karua bulumakao kokoreo; keke sina vina vukivukihi tana sinea, meke keke pule si tana vina vukivukihi va uququ, pude na vina viadi rina tie Livae. ");
INSERT INTO rug_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Mu va madi sari na tie Livae, guana ṉati vinariponi sapu ta poni mae koa Rau; mamu va palabatua se Eroni meke sari na tuna koreo koa rini. ");
INSERT INTO rug_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Pa siraṉa gua asa si, mamu veko vata kalei sari na tuna koreo Livae koari na tie Izireli, pude na Qua tie soti si arini. ");
INSERT INTO rug_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Pana hokoto sa vina via na vina madidi rina tie Livae, si kaqu boka ene tata mae meke somana tavetia rini sa tinavete koasa Ipi Hopena. ");
INSERT INTO rug_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Sipu va matei Rau sari doduru koburu koreo podo kenudi tadi na tie Izipi si ele zamani tu Rau sapu Taqarau sari doduru koburu koreo podo kenudi tadi na tie Izireli. ");
INSERT INTO rug_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Va madi Rau sari doduru koburu koreo podo kenudi tadi na tie Izireli guana tuqu soti, meke saripu podo kenudi koari doduru kurukuru, ba va matei Rau sari doduru koburu koreo podo kenudi tadi na tie Izipi. ");
INSERT INTO rug_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Kamahire si vagi Rau sari na tie Livae, pude hobeni sari doduru pu podo kenudi tadi na tie Izireli. ");
INSERT INTO rug_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Vizati mo Rau sari na tudia koreo koasa butubutu te Livae, guana vinariponi tadi na tie Izireli koa Rau, pude tavetavete toka nia se Eroni meke sari na tuna koreo pa korapa Ipi Hopena, pude kopuni sari na vina vukivukihi tinaleosae pude lopu kaqu raza mae koa ri na tie Izireli sari na oza na minoho, be tata mae si arini koasa Vasina Hopena.” ");
INSERT INTO rug_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Ke va madi ri Mosese e Eroni, meke sari doduru tie Izireli sari na tie Livae, gua tugo sapu garunu nia e Zihova koe Mosese. ");
INSERT INTO rug_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Va via puleni meke sari na dia poko sari na tie Livae; va madi Eroni si arini guana ṉati vinariponi tadi na tie Izireli pa kenuna e Zihova, meke tavetia sa sa vina vukivukihi meke tava via na tava madi tugo si arini koe Zihova. ");
INSERT INTO rug_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Taveti rini sari doduru gua pu garununi e Zihova koe Mosese, pa guguadi rina tie Livae. Gua asa ke somana tavetavete sari na tie Livae koasa tinavete pa korapana sa Ipi Hopena, koasa kinopu tadi Eroni meke sari na tuna koreo. ");
INSERT INTO rug_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Zama se Zihova koe Mosese, ");
INSERT INTO rug_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Pana kamo hiokona lima vuahenina sa tie Livae, si kaqu boka somana tavetavete pa korapa Ipi Hopena pa kenuna e Zihova, ");
INSERT INTO rug_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","osolae kamoa sa ka lima ṉavulu vuahenina, meke tiqe kaqu magogoso si asa koasa tinavete. ");
INSERT INTO rug_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Pa mudina asa si boka somana mo koari na tie kopu sasada ba lopu boka somana tokani sa sari na tie Livae turaṉana koari na tinavetavete pa korapa Ipi Hopena babe tokani pa dia tinavete palepaleke. Pa siraṉa gua asa si kaqu ta luli sari na tinavete tadi na tie Livae.” ");
INSERT INTO rug_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Zama guahe se Zihova koe Mosese pa soloso qega pa Saenai pa sidara kekenu koasa vina rua vuaheni totosona sapu taluarae sari na tie Izireli pa Izipi. Zama si Asa, ");
INSERT INTO rug_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","3","“Pa vina manege made rane koasa sidara hie sipu podalae lodu sa rimata, sari na tie Izireli si kaqu tavetia sa Inevaṉa Pasova d. Kaqu luli rini sari doduru tinarae koasa guguana sa Inevaṉa Pasova.” ");
INSERT INTO rug_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Ke tozini Mosese sari na tinoni pude tavetia sa Inevaṉa Pasova, ");
INSERT INTO rug_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","meke pana veluveluna sa rane vina manege made koasa sidara kekenu pa soloso qega pa Saenai, si tavete luli betoi rina tie gua sapu tozi nia e Zihova se Mosese. ");
INSERT INTO rug_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Ba kaiqa tie pa varikorapadi rini saripu boni pa dia tinoa sina tiqua rini sa hadehade tomate meke lopu boka somana kopu nia rini sa Inevaṉa Pasova pa rane asa. La si arini koe Mosese meke Eroni ");
INSERT INTO rug_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","meke zama, “Ele boni mami si gami sina tiqua gami sa hadehade tomate, ba vegua ke ta paqaha taloa si gami koasa vinariponi te Zihova somanae koari na tie Izireli?” ");
INSERT INTO rug_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Olaṉa se Mosese, “Aqa si gamu, kote hata ia rau sa guguana asa koe Zihova.” ");
INSERT INTO rug_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Tozi nia Zihova se Mosese, ");
INSERT INTO rug_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","pude zama la koari na tie Izireli, “Be keke gamu, babe sa mia tututi gore mae si lopu via pa ginuguana sapu tiqua rini sa hadehade tomate babe ene va gelenae pa inene, ba korapa okoro hola pude kopu nia sa Pasova, ");
INSERT INTO rug_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","si tava malumu si gamu pude kopu nia pa keke sidara hola, pana veluveluna sa vina manege made pa sidara vina rua. Hena ia gamu sa lami meke sa bereti sapu lopu ta henie isiti d meke na elelo pasadi koasa inevaṉa. ");
INSERT INTO rug_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Lopu veko hola ia kaiqa masa kamoa munumunu koivugona, meke lopu mokua keke susuri kurukuru. Tavetia sa Inevaṉa Pasova gua sapu koa pa tinarae. ");
INSERT INTO rug_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Be keke tie sapu lopu boni si asa pa dinoṉo te Zihova meke lopu somana pa inene meke lopu lulia sa tinaraena sa Pasova si kaqu ta gilana sapu lopu na Qua tie si asa, sina lopu hite tavetia sa sa vinariponi mae koa Rau pa totoso ta huhukuna. Kaqu tava kilasa sa tie asa pa nana sinea. ");
INSERT INTO rug_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Be keke tie karovona pa votiki butubutu si hiva somana luli koa gamu meke kopu nia sa inevaṉa Pasova, si kaqu lulia sa gua sapu koa pa tinarae. Sa tinarae hie si tadi doduru tie, be tie soti pa popoa ba be na tie karovodi pa votiki butubutu.” ");
INSERT INTO rug_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","16","Koasa rane sipu tava turu sa Ipi Hopena, si nobi tamunia na lei si asa. Ba podalae pana veluvelu meke kamoa munumunu, si doṉo guana nika sa lei pa batuna sa Ipi Hopena. ");
INSERT INTO rug_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Pa totoso ta ovulae sage sa lei koasa Ipi Hopena si rizu luli tugo sari na tinoni Izireli, meke koasa vasina sapu gore sa lei si noso tugo vasina sari na tinoni Izireli. ");
INSERT INTO rug_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Lalae koasa ginarunu te Zihova si rizu taloa sari na tinoni Izireli, meke koasa ginarunu tugo te Zihova si hoke noso si arini. Totoso koa pa batuna sa Ipi Hopena sa lei, si koa noso tugo si arini meke koa hola pa vasina asa. ");
INSERT INTO rug_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Totoso koa va seunae sa lei pa batuna sa Ipi Hopena, ba va tabea mo rini se Zihova, meke lopu rizu taloa si arini. ");
INSERT INTO rug_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Kaiqa totoso si hoke ka visavisa rane mo si koa hola ia sa lei pa batuna sa Ipi Hopena, pa kaiqa ginugua si hoke koa noso babe rizu taloa si arini, koa gua mo koasa ginarunu te Zihova. ");
INSERT INTO rug_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Kaiqa totoso si koa noso sa lei podalae veluvelu meke kamoa munumunu. Ba sipu ta ovulu sage sa lei, si lopu sana rizu taloa si arini. ");
INSERT INTO rug_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Be karua rane babe keke sidara, babe keke vuaheni, koa hola gua sa lei pa batuna sa Ipi Hopena, ba koa hola tugo vasina sari na tinoni Izireli, meke lopu hite rizu taloa si arini. Ba sipu ta ovulae sage tu sa lei si rizu luli taloa si arini. ");
INSERT INTO rug_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Koasa vina tabena mo sa ginarunu te Zihova sapu tozia Sa koe Mosese si boka noso babe rizu taloa si arini. ");
INSERT INTO rug_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Zama koe Mosese se Zihova, ");
INSERT INTO rug_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Mu taveti karua buki, mamu seke lani siliva, pude tioko varigarani sari na tinoni Izireli, meke pude ene vura. ");
INSERT INTO rug_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Pana ta ivu beto sari buki meke va nodolo va gelenae sari na mamalaiṉidi, sa butubutu lavata si kaqu mae varigara pa kenumu goi koasa sasadana sa Ipi Hope. ");
INSERT INTO rug_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Ba pana keke mo sa buki si ta avoso mamalaiṉina, si kaqu mae varigara vari likohae nigo rina koimata tadi na butubutu. ");
INSERT INTO rug_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Pana keke totoso papakana mo ta ivu sari na buki, sari na butubutu saripu koa varigara pa kali gasa rimata, si kaqu rizu taloa. ");
INSERT INTO rug_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Pana ta ivu pule keke totoso papakana si arini, sari na butubutu saripu koa varigara pa kali mataona, si kaqu rizu taloa. Sa mamalaiṉi si kaqu tozini hopeke puku tie koari ka made kalina pude rizu taloa. ");
INSERT INTO rug_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Ba pana ta tioko varigara sa butubutu lavata, si kaqu ta ivu nodolo va gelenae sari na buki. ");
INSERT INTO rug_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Sari na hiama tuna koreo e Eroni, si kaqu ivui sari na buki. Asa sa tinarae sapu kaqu lulia gamu koari doduru sinage na sage. ");
INSERT INTO rug_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Pana ta evaṉa sa vinaripera pa mia popoa, meke hiva va kilasi gamu sari na kana pu mae rapatani gamu, si mamu ivui sari na buki mamalaiṉi tanisa vinaripera. Arau Zihova sa mia Tamasa si kaqu tokani gamu, meke harupu gamu pa limadia ri na mia kana. ");
INSERT INTO rug_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Gua tugo koari na mia totoso qetuqetu sapu koa gua koari na mia inevaṉa pa Sidara Vaqura meke kaiqa inevaṉa pa mia vinahesi, si kaqu ivui gamu sari na buki. Meke kaqu ivui gamu sari na buki totoso poni lani gamu sari na mia vina vukivukihi binaere, na vina vukivukihi uququ. Sari na buki si kaqu va balabalani gamu koe Tamasa. Arau Zihova sa mia Tamasa si kaqu tokani gamu, si gamu.” ");
INSERT INTO rug_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Pa rane vina hiokona puta, koasa sidara vina rua koasa vuaheni vina rua, pa mudina sipu taluarae sari na tinoni Izireli pa popoa Izipi, si ta ovulae sage sa lei sapu opo tamunia sa Ipi Hopena te Zihova, ");
INSERT INTO rug_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","meke podalae topue ene vura la pa soloso qega, pa Saenai sari na tinoni Izireli, meke mae noso pa korapa qega pa popoa Parani sa lei. ");
INSERT INTO rug_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Hie tugo sa dia rinizu kekenu koasa dia inene pa ginarunu te Zihova koe Mosese. ");
INSERT INTO rug_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Doduru totoso rizu rini, si kekeṉoṉo mo sa vinariluli tadi na butubutu Izireli. Arini sapu lulia sa pitipiti pa pinaqaha sapu koimata nia sa butubutu te Ziuda si ene kekenu, hopehopeke pukuna, meke se Nasoni, sa tuna koreo e Aminadabi sa dia koimata. ");
INSERT INTO rug_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Se Netanela, sa tuna koreo e Zua, si na koimata tanisa butubutu te Isaka, ");
INSERT INTO rug_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","meke se Eliabi sapu sa tuna koreo e Heloni, si na koimata tanisa butubutu te Zeboloni. ");
INSERT INTO rug_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Beto asa, si tava gore sa Ipi Hopena, meke sari na butubutu tadi Qerisoni meke Merari, pu palekena si asa, si rizu taloa. ");
INSERT INTO rug_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Sa butubutu te Rubeni si hobe mae, palekia sa sa nana pitipiti, meke ene pa hopehopeke pukuna meke se Elizua sapu sa tuna koreo e Sedeu sa dia koimata. ");
INSERT INTO rug_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Se Selumieli, sapu sa tuna koreo e Zurisadai, si na koimata tanisa butubutu te Simione, ");
INSERT INTO rug_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","meke se Elisapi, sapu sa tuna koreo e Dueli si na koimata tanisa butubutu te Qadi. ");
INSERT INTO rug_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Beto asa, si podalae ene sari na tie Livae pa butubutu te Kohati, paleki rini sari na tiṉitoṉa hopedi. Pana kamoa rini sa vasina sapu kaqu koa pakia rini, si kaqu tiqe tava turu pule sa Ipi Hopena. ");
INSERT INTO rug_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Ego, sa pinaqaha butubutu te Iparemi si hobe mae, koari hopehopeke dia pukuna, meke se Elisama, sapu sa tuna koreo e Amihudi, si na dia koimata. ");
INSERT INTO rug_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Se Qamalieli, sapu sa tuna koreo e Pedazu, si na koimata tanisa butubutu te Manase, ");
INSERT INTO rug_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","meke se Abidani, sapu sa tuna koreo e Qitione, si na koimata tanisa butubutu te Benisimane. ");
INSERT INTO rug_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Meke vina betobeto, si ene luli si arini pu koa koasa pinaqaha sapu koimata nia sa butubutu te Dani saripu luli pa nana pitipiti. Kopu ni rini sari doduru pinaqapaqaha butubutu Izireli koari na kana sapu hiva raza mumudi mae. Meke se Ahieza, sapu sa tuna koreo e Amisadai, si na dia koimata. ");
INSERT INTO rug_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Se Paqieli, sapu sa tuna koreo e Okarani si na koimata koasa butubutu te Asa. ");
INSERT INTO rug_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Meke se Ahira, sapu sa tuna koreo e Enani, si na koimata tanisa butubutu te Napitalai. ");
INSERT INTO rug_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Asa sa vinari lulina sa inene tadi na tinoni Izireli, koari hopehopeke pukuna, sipu rizu meke ene taloa si arini. ");
INSERT INTO rug_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Hobabi si na tuna koreo e Zetoro sa tie pa butubutu Midiani si asa. Hobabi si na ivana e Mosese, meke zama la koe Hobabi se Mosese, “Tata topue la si gami koasa popoa, sapu ele zama nia Zihova pude ponini gami, gua. Mae luli gami. Ele va tatara nia Sa sapu kaqu ponini gami Sa sari na tiṉitoṉa leadi, ke mae pude mami ponigo hinia.” ");
INSERT INTO rug_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Meke olaṉa se Hobabi, “Lokari, maqu pule la pa qua popoa soti si rau meke koari na turaṉaqu soti.” ");
INSERT INTO rug_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Ba zama se Mosese, “Hiva hola nigo, pude mu lopu luara pani gami. Agoi gilania sa vasina, sapu kaqu la noso paki si gami, meke agoi mo sa mami tie tuturaṉa. ");
INSERT INTO rug_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Be luli somana mae koa gami si goi, si kaqu somana vagia goi koa gami, sari doduru minana pu kaqu ponini gami e Zihova.” ");
INSERT INTO rug_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Sipu taluarae sari na tinoni pa Saenai, sa toqere hope te Zihova, si ka ṉeta rane doduruna si enea rini. Sa Bokese Vinariva Egoi te Zihova si ta paleke va kenue koa rini doduru totoso, pude hata ia sa vasina sapu kaqu noso si arini. ");
INSERT INTO rug_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Pana rane totoso taluarae rini koari hopeke vasidi pu koai rini, si koa panaulu koa rini sa lei te Zihova. ");
INSERT INTO rug_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Sipu va namanama taluarae sa Bokese Vinariva Egoi te Zihova doduru totoso, si hoke zama guahe se Mosese, “Zihova, Mu la pa kenu mami, pude di ta hurakatae sari na Mua kana, meke madi govete pa kenumu Goi si arini pu kukiti nigo.” ");
INSERT INTO rug_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Sipu noso sa Bokese Vinariva Egoi te Zihova si hoke zama guahe se Mosese, “Kei Zihova, Mu pule mae koari vuro tina tinoni pa Izireli,” gua. ");
INSERT INTO rug_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Meke podalae vari qumiqumi ni rina tinoni Izireli sari na dia tinasuna pa kenuna e Zihova, meke sipu avosi e Zihova saripu gua arini, si ta ṉaziri si Asa, meke garunu ni nika Sa sari na tinoni. Ke sului nika si arini meke ta huara ilasa sari na dia ipi pa hukihukirina sa popoa vasina koa ia rini. ");
INSERT INTO rug_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Tepa tinokae la koe Mosese sari na tinoni Izireli, ke varavara sage la koe Zihova si asa, meke mate gore sa nika. ");
INSERT INTO rug_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Ke poza nia Tabera rini sa vasina asa, sina sului nika vasina si arini. ");
INSERT INTO rug_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Sari na tie huporodi pu luli somanae koari na tinoni Izireli si hiva sisigiti pude hena miti, ke podalae va qumiqumi pulei pule sari na tinoni Izireli meke zama guahe: “Kei kasa, nake piriṉana nada hire! ");
INSERT INTO rug_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Pa popoa Izipi si hoke hena mokai mo gami sari na igana sapu loke hinoludi, gua tugo na kiukaba, na deri napo, na likisi, na siloti, meke na pasapasa. ");
INSERT INTO rug_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Ba kamahire si namuna tasuna sari na mami tinoa, meke namu loketoṉa si koa, ba rane ka rane si koba mana mo,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Sa mana si kekeṉoṉo gua rina kiko hitekedi, saripu keoro na meava dinoṉona. ");
INSERT INTO rug_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","9","Hoke hoqa turaṉae koa rina puni pana boṉi si arini koasa vasina sapu koa ia rini. Meke hoke ene la varigarani rina tinoni Izireli si arini koari doduru munumunu meke munamunali babe nuqari rini koari na tiṉitoṉa nuqanuqarana, beto meke raroi, meke kina va labelabe guni na keki. Sa liṉiliṉina sa si guana bereti sapu ta kina henie oela olive. ");
INSERT INTO rug_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Sipu turu varivarigarae pa sadadi ri dia hopeke ipi si arini, si avosi Mosese dia vinari qumiqumi koari hopeke dia pukuna, meke talotaṉa hola se Mosese, sina bugoro sisigiti ni e Zihova si arini. ");
INSERT INTO rug_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Meke zama la koe Zihova se Mosese, “Na vegua ke tavete gunia tu Goi sa Mua nabulu? Nake ele va mamata nau tu Goi sa pinalekedi rina tinoni hire, ba na vegua tu ke lopu ta qetue tu koa Goi si rau? ");
INSERT INTO rug_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Na lopu arau va podaki na podoi si arini, meke garunu guni nau tu Goi na tie kopu koburu, pude kukai kekeṉoṉo na barikaleqe pu va sususu tokeli pa siraṉa meke paleke enene la koasa popoa sapu va tatara nia Goi koari na tiatamadia. ");
INSERT INTO rug_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Pavei beka si kaqu boka vagi baso si rau pude boka poni sari doduru tinoni gua hire? Sina korapa kabo na tepa ososo, ‘Poni gami baso,’ guni nau rini. ");
INSERT INTO rug_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Lopu boka va tana ekei rau telequ sari doduru tinoni hire sina ta mamata holani rau pinalekedi si arini! ");
INSERT INTO rug_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Be tavete guni nau Goi asa, si mamu tataru nau, mamu va mate au mo, pude lopu kaqu koa va seunae koa rau sa kinaleana hie.” ");
INSERT INTO rug_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Meke zama la koe Mosese se Zihova, “Mu vizata maeni ka zuapa ṉavulu puta koimata ta pamaṉaedi koasa butubutu Izireli arini pu na koimata ele ta gilanadi koari na tinoni. Mamu turaṉa mae ni koasa Ipi Hope, mamu somana va turui koa goi vasina. ");
INSERT INTO rug_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Meke kaqu gore atu si Rau meke vivinei koa goi vasina, meke kaqu vagia Rau koasa Maqomaqo sapu koa koa goi meke poni gunia tugo koa rini, meke kaqu somana paleke toka nigo rini, sa vina tanadi rina tinoni, meke lopu kaqu va tana ekei goi si arini. ");
INSERT INTO rug_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Ego, mu zama guahe koari na tinoni Izireli, ‘Mi va via puleni gamu, sina kaqu hena baso si gamu vugo. Ura ele avosi e Zihova sari na mia kinabo alili, meke zama, “Hiva baso si gami. Ura, ele koa valeana mami si gami pa Izipi,” gua. Gua asa ke kaqu poni gamu baso e Zihova si gamu, pude henahena. ");
INSERT INTO rug_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Lopu kaqu keke babe karua babe ka lima babe ka manege puta babe ka hiokona puta rane mo si kaqu henahena si gamu, ");
INSERT INTO rug_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","ba pa keke doduru sidara tu, osolae kaqu eṉeṉo meke maledere hena pulei gamu. Ura ele kilu ia gamu sapu somanae se Zihova koa gamu meke nominomi la ia mo gamu si Asa, sapu leana be lopu taluarae mia mo pa popoa Izipi si gamu,’ ” gua. ");
INSERT INTO rug_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Meke zama la koe Zihova se Mosese, “Ka onomo gogoto tina tie varipera Izireli si korapa turaṉi rau, meke zama guahe si goi, ‘Kaqu poni baso rau sari na tinoni Izireli pude madi henahena pa keke doduru sidara?’ gua. ");
INSERT INTO rug_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Be guana tava mate vala beto koa rini sari na rovana bulumakao na sipi ba lopu kaqu garodi ri doduru! Ba be soku gua ri na igana pa kolo, ba lopu kaqu pada tugo koa rini!” ");
INSERT INTO rug_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Meke olaṉa la koe Mosese se Zihova, “Vegua, lopu garo sa Qua ṉiniraṉira? Ego, kamahire maqu va dogoro nigo, sapu gua zama nia Rau koa gamu, si be ta evaṉa babe lokari,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Meke vura la se Mosese koari na tinoni Izireli meke la tozi sa sari na zinama te Zihova, meke tioko varigara ni sa sari ka zuapa ṉavulu puta koimata tadi na tinoni Izireli meke va turu vari likohae ni sa koasa Ipi Hopena te Zihova. ");
INSERT INTO rug_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Beto asa si tiqe gore mae pa korapa lei se Zihova meke zama la koe Mosese. Meke vagia e Zihova sa Maqomaqo te Tamasa sapu koa koe Mosese meke poni la nia tugo Sa koa ri ka zuapa ṉavulu puta koimata. Meke sipu kamo koa rini sa Maqomaqo, si podalae korokorotae gua rina poropita si arini, ba lopu seunae sisigiti. ");
INSERT INTO rug_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Ba ari karua koa ri ka zuapa ṉavulu puta koimata, sapu ari Elidadi e Medadi pu ta kubere somanae, si koa hola dia koari na dia ipi, meke lopu somana luli la gua koasa Ipi Hopena te Zihova. Ba ta gore nia tugo ri kara sa Maqomaqo te Tamasa, meke korokorotae gua tugo rina poropita pa korapa dia ipi sari karua. ");
INSERT INTO rug_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Meke haqala vura la koe Mosese si keke tie vaqura meke la tozia sa koasa sapu gua ta evaṉa koa ri Elidadi e Medadi. ");
INSERT INTO rug_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Meke zama la koe Mosese se Zosua, sa tuna e Nani sapu toka nia se Mosese seunae gua tu podalae tie vaqurana si asa, “Qua baṉara, va nosoi gedi,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Ba olaṉa la koasa se Mosese, “Vegua hiva vata evaṉae nau tie konokonoqu goi si rau, taga? Qetu nia rau sipu vekoa e Zihova sa Maqomaqona koa rini, meke korokorotae beto sari doduru tinoni te Zihova.” ");
INSERT INTO rug_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Beto asa, si pule la koari na dia ipi sari Mosese, meke sari ka zuapa ṉavulu puta koimata tadi na tinoni Izireli. ");
INSERT INTO rug_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Ego, lopu seunae hoi si va givusia e Zihova sa popoa, meke paleke mae guni na givusu pa lamana sari na kurukuru tapuru ta pozae kueli, meke va tapuru pepeka sisigiti Sa padana keke mita ululudi gua pa pepeso, meke va hoqa nosoi Sa koasa vasina lavata sapu koa ia rina tie Izireli padana soku ṉavulu maelo seuna gua pa doduru vasina podalae gua koari na dia ipi. ");
INSERT INTO rug_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Ke koasa doduruna sa rane na boṉi asa meke koasa doduruna sa rane koivugona, si tuqe kurukuru lamo si arini, meke hopeke arini si varigara ni meke va siṉi rini padana hola nia lima ṉavulu puta vovoina. Meke va rimata popai rini koasa doduruna sa vasina lavata pa vari likohaedi rina dia ipi si arini. ");
INSERT INTO rug_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Meke sipu korapa zomuzomue masa kurukuru meke lopu ele hena betoi rini, si ta ṉaziri sisigiti ni e Zihova, meke va raza ni minoho kaleana Sa si arini. ");
INSERT INTO rug_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Gua asa ke poza nia Kibirote Hatava rini sa popoa sana. Sa ginuana si na lovudi ri na tinoni pu ṉaṉaluta miti. ");
INSERT INTO rug_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Meke tiqe taluarae vasina si arini, meke la gua pa Hazeroti, meke la noso si arini vasina. ");
INSERT INTO rug_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Haba ia Mosese si keke barikaleqe Itiopia, meke zamazama nia na lopu qetu nia ri Miriami e Eroni se Mosese. ");
INSERT INTO rug_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Meke vari nanasa pulei teledia sari karua, “Vegua, koe Mosese eke mo si zama mae se Zihova, ba lopu boka zama mae tugo koa gita kara si Asa?” Avosia e Zihova sapu gua zama nia ri karua. ");
INSERT INTO rug_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Ba se Mosese si keke tie va pepekae hola, holani sa sari doduru tie pa popoa pepeso. ");
INSERT INTO rug_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Meke hinoqa zama la koari Mosese e Eroni meke e Miriami se Zihova, “Hiva betoni gamu Rau si gamu ka ṉeta pude vura mae koa Rau koasa Ipi Hopena,” ke topue la sari ka ṉeta. ");
INSERT INTO rug_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Meke gore mae pa korapa lei se Zihova meke turu Nana pa sasadana sa Ipi Hopena meke titioko la koari Eroni e Miriami, ke ene sage la sari karua. ");
INSERT INTO rug_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Meke zama la koari karua se Zihova, “Ego, mi va avoso maei kamahire sari na Qua zinama. Totoso koa koa gamu sari na poropita si vata gilana pule Nau koa rina dinogodogorae tadirini si Rau, meke zama koarini pa pinutagita. ");
INSERT INTO rug_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Ba koe Mosese sa Qua nabulu si votikaena hola totoso zama koa sa si Rau. Ura ele vizatia Rau si asa pude koimata ni sari doduru Qua tinoni Izireli. ");
INSERT INTO rug_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Pa ginugua mo asa si hoke turu variva tia i meke vari vivinei va bakali si gami karua, ba lopu koari na zinama vapae. Meke dogoria tugo sa sa kinehaqu Rau. Ba na vegua tu ke zama panipania tu gamu kara se Mosese sa Qua nabulu?” ");
INSERT INTO rug_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Bugoro ni e Zihova si arini, ke taluarae si Asa, ");
INSERT INTO rug_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","meke sipu taluarae sa lei koasa Ipi Hopena, si hinoqa raza ia keke minoho kaleana se Miriami, keoro toa guana sinou sa tinina. Sipu doṉo la se Eroni koasa, si dogoria sa sapu raza ia na minoho sa doduru tinina, ");
INSERT INTO rug_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","ke zama la koe Mosese si asa, “Kei baṉara, tataruni gami, mamu taleosoni sari na mami dinuviduvili. ");
INSERT INTO rug_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Mu lopu gunia keke haha podo va kaleana sapu ta ṉovala kukuru tinina si asa.” ");
INSERT INTO rug_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Ke zama la koe Zihova se Mosese, “Ke Zihova, Mu salaṉia si asa!” gua. ");
INSERT INTO rug_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Olaṉa se Zihova, “Be guana loroa sa tamana sa isumatana, si kote koa kurekure ka zuapa rane si asa. Ke va vura taloa ia mo koasa butubutu; beto asa, si kote boka tava nuquru pule pa korapa butubutu si asa.” ");
INSERT INTO rug_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Ke ta hitu vura paki koasa butubutu si asa ka zuapa rane, meke koa noso sari doduru tie, osolae ta vagi nuquru pule pa korapa butubutu si asa. ");
INSERT INTO rug_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Pa mudina asa, si taluarae pa Hazeroti sari na tinoni meke la koa pa korapa qega pa Parani. ");
INSERT INTO rug_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Meke zama la koe Mosese se Zihova, ");
INSERT INTO rug_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Mu garunu lani kaiqa tie pa Kenani pude piko nia sa popoa, sapu korapa vala nia gunia Rau koari na tinoni Izireli. Mu garuni ka manege rua koimata, hopeke keke koari ka manege rua butubutu Izireli.” ");
INSERT INTO rug_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","4","Va tabe se Mosese, meke sipu korapa koa pa soloso pa popoa Parani, si garuni sa sari na koimata hire: Koasa butubutu Rubeni, sa koimata si e Samua, sa tuna koreo e Zakura. ");
INSERT INTO rug_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Koasa butubutu Simione, sa koimata si e Sapati, sa tuna koreo e Hori. ");
INSERT INTO rug_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Koasa butubutu Ziuda, sa koimata si e Kelebi, sa tuna koreo e Zepune. ");
INSERT INTO rug_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Koasa butubutu Isaka, sa koimata si e Iqala, sa tuna koreo e Zosepa. ");
INSERT INTO rug_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Koasa butubutu Iparemi, sa koimata si e Hosea, sa tuna koreo e Nani. ");
INSERT INTO rug_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Koasa butubutu Benisimane, sa koimata si e Paleti, sa tuna koreo e Rapu. ");
INSERT INTO rug_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Koasa butubutu Zeboloni, sa koimata si e Qadieli, sa tuna koreo e Sodi. ");
INSERT INTO rug_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Koasa butubutu Manase, sa koimata si e Qadi, sa tuna koreo e Susi. ");
INSERT INTO rug_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Koasa butubutu Dani, sa koimata si e Amieli, sa tuna koreo e Qemali. ");
INSERT INTO rug_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Koasa butubutu Asa, sa koimata si e Setura, sa tuna koreo e Mikueli. ");
INSERT INTO rug_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Koasa butubutu Napitalai, sa koimata si e Nabi, sa tuna koreo e Vopesi. ");
INSERT INTO rug_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Koasa butubutu Qadi, sa koimata si e Qeueli, sa tuna koreo Maki. ");
INSERT INTO rug_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Arini sari na koimata, saripu garuni e Mosese pude la dogoria sa popoa. Sa pozapoza Hosea, sa tuna koreo e Nani, si hobe nia pozapoza Zosua e Mosese. ");
INSERT INTO rug_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Sipu garunu taloani Mosese, si tozini sa si arini, “Mi taluarae tani, mamu ene hola la gua pa korapana sa popoa qega meke ene hola la tu pa kali la koari na vasina toqetoqeredi. ");
INSERT INTO rug_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Mamu la vilitia sapu veguguana sa popoa asa, ve sokudi gua sari na tinoni pu koa vasina, meke vea ṉiṉira gua si arini. ");
INSERT INTO rug_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Mamu la dogoria be leana babe kaleana sa popoa, koa pa bara patu ululudi sari na tinoni pa vasileana babe lokari? ");
INSERT INTO rug_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Mamu la vilitia be guana masuruna sa pepeso, babe koa ia na hudahuda sa popoa. Lopu muliṉi nia, mamu paleke pule maeni kaiqa vua huda saripu toqolo vasina.” Koasa totoso asa si podalae komiha sari na vua qurepi. ");
INSERT INTO rug_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Ke podalae ene sage la vilitia rini sa popoa, meke la gua koasa soloso qega ta pozae Zini pa kalina mae, meke kamo la gua pa Rehobi, sapu tata koasa karovoana pa toqere sapu ta pozae Hamati. ");
INSERT INTO rug_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Kekenu si la paki si arini, koasa kukuruna sa popoa qega kalina mae ta pozae Neqevi d, meke kamo la pa vasileana Heboroni, vasina pu koa sari na butubutu tadi Ahimani, e Sesai meke se Talamai, saripu tuti malivi, pu ta pozae Anaki. Ka zuapa vuahenina sipu lopu ele ta kuri gua sa vasileana lavata Zoani pa popoa Izipi, si ta kuri sa vasileana Heboroni. ");
INSERT INTO rug_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Sipu mae kamoa rini sa lolomo pa Esikolo, si maho vagia rini si keke kata qurepi, sapu mamata hola, ke sopele nia huda rini, meke vari paleke nia ri karua tie. Kaiqa pomeqaraneti na piqi tugo, si paleki rini. ");
INSERT INTO rug_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Poza nia Esikolo rini sa lolomo asa, sina sa kata qurepi si maho vagia ri na tie Izireli vasina. ");
INSERT INTO rug_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Sipu hola ka made ṉavulu puta rane piko nia rini sa popoa Kenani, si pule sari ka manege rua tie piko. ");
INSERT INTO rug_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Kamo pule mae koe Mosese e Eroni meke koasa butubutu Izireli pa popoa Kadesi pa korapa qega pa Parani si arini. Meke vasina si tozi vurani rini koari karua meke koari na butubutu Izireli sa inavosona sa popoa, meke va dogoroni tugo rini koarini sari na vuadi rina linetelete koasa popoa sana. ");
INSERT INTO rug_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Meke zama guahe si arini koe Mosese: “Ele kamoa gami sa popoa sapu garununi gami goi, meke masuru hola sa pepeso, meke hire sari na vua huda koasa popoa. ");
INSERT INTO rug_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Ba sari na tiena sa popoa si ṉiṉira hola, meke noma hola sa popoa meke sari na vasileana si ta bara valeana tugo si arini. Ba sapu kaleana hola si dogori gami sari kaiqa tie saripu tututi gore mae guadi koari na tie Anaki si koadia tugo vasina. ");
INSERT INTO rug_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Sari na tie Amaleki si koa koasa popoa Neqevi, meke sari na tinoni pa Hitaiti, Zebusaiti, meke Amoraiti, si koa koari na vasidi toqetoqeredi, meke sa butubutu Kenani si koa pa raratana meke taqelena tugo sa Ovuku Zodani,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Ba zama va mokomokoi e Kelebi sari na tie saripu zamazama sisigiti la koe Mosese, meke zama guahe si asa, “Aria mada la vagia sa popoa, kote boka va kilasi mo gita si arini,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Ba zama sari na tie piko saripu luli koasa, “Lopu kaqu boka va kilasi gita sari na tie arini, sina ṉiṉira holani gita rini si gita,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Meke ene betoa sa inavoso kokohana sa doduruna sa butubutu Izireli, koasa guguana sa popoa sapu ele piko nia rini. Meke zama si arini, “Sa popoa si va mate betoi saripu hiva koa vasina, meke sari na tinoni pu koadi vasina si ululudi hola. ");
INSERT INTO rug_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Na kobi malivi lavata si dogori gami vasina, saripu tuti gore mae guadi koe Anaki, meke sapu gita hire si kote hiteke gua mo ri na kupokupo doṉo guni gita rini,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Koasa doduruna sa boṉi sana si kabo va ululae sisigiti sari na tinoni Izireli. ");
INSERT INTO rug_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Meke zamazama va gugue sisigiti la koari Mosese e Eroni sari doduru tie Izireli, meke zama guahe si arini: “Be pa Izipi babe pa popoa qega hie, si mate gami ba leana mo! ");
INSERT INTO rug_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Ba na vegua ke turaṉa maeni gami tu e Zihova pa popoa Kenani, meke va mate gami magu varipera? Sari na mami barikaleqe na koburu si kote ta vagi gua mo ri na tiṉitoṉa koari na tie. Vegua lopu leana be kekere pule la mo pa popoa Izipi si gami?” ");
INSERT INTO rug_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Ke vari zamai si arini, “Aria, mada vizatia keke nada koimata, pude turaṉa pule lani gita pa popoa Izipi!” gua si arini. ");
INSERT INTO rug_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Meke hoqa oporapaha pa pepeso sari Mosese e Eroni pa kenuna sa vinarigara tie Izireli pu varigara vasina. ");
INSERT INTO rug_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Meke sari karua pu somana piko nia sa popoa Kenani, ari Zosua tuna e Nani meke se Kelebi sa tuna e Zepune si daku rikati sari na dia poko pa tinalotaṉa, ");
INSERT INTO rug_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","meke zama la koari na tinoni Izireli, “Sa popoa Kenani, sapu la dogoria gami si na popoa leana hola. ");
INSERT INTO rug_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Be qetuni gita e Zihova si gita, si kaqu turaṉa nuquruni gita Sa koasa popoa sana, na popoa masuruna, sapu sokua na ginani na vua huda, meke kaqu ponini gita Sa si asa. ");
INSERT INTO rug_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Ba mamu lopu zama toketoke la ia se Zihova, meke lopu matagutu ni sari na tinoni pu koadi vasina, sina lopu kaqu tasuna hokara vina kilasadi si arini. Se Zihova si koa koa gita meke ele va kilasi tu Sa sari na tamasa pu kopuni si arini, ke mi lopu matagutu ni si arini,” gua sari karua. ");
INSERT INTO rug_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Ba zama beto sa vinarigara lavata, “Mada gona va mateni patu gedi,” gua si arini. Meke hinoqa vura mae pa ipi varivarigarana koari tinoni Izireli sa malakapina sa kalalasana e Zihova. ");
INSERT INTO rug_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Meke zama la koe Mosese se Zihova, “Ve seunae gua si kaqu va karikari Au ri na tinoni hire si Rau. Meke vea seunae gua si lopu kaqu va hinokara Au rini si Rau, ba koadia tugo sari doduru vina gilagila saripu ele taveti Rau pa varikorapadia rini. ");
INSERT INTO rug_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Kaqu va raza ni oza meke kaqu va kilasi Rau si arini, ba kaqu vata evaṉae nigo Arau na tamana sa butubutu lavata sapu noma hola meke ṉiṉira hola ni si arini,” gua se Zihova. ");
INSERT INTO rug_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Ba zama la koe Zihova se Mosese, “Kote avoso nia ri na tie pa popoa Izipi sapu ele turaṉa vurani Goi koa rini pa Mua ṉiniraṉira sari na tinoni hire. Meke pana avosia ri doduru tie pa popoa Izipi sapu gua evaṉia Goi koari na Mua tie hire, ");
INSERT INTO rug_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","si kote vivinei nia rini koari na tie pu koa koasa popoa hie. Ura ele avoso nia tu ri na tinoni arini sapu Agoi Zihova si somana koa koa gami. Meke ta dogoro vura pa matamami, totoso noso panaulu koa gami sa Mua lei, meke turaṉa gami sa lei pana rane, meke gua tugo pana boṉi sapu doṉo gua na nika si asa. ");
INSERT INTO rug_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Ego, be va mate betoi Goi sari na Mua tinoni hire, si kote zama sari na butubutu tie pu ele avoso nigo sapu, ");
INSERT INTO rug_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","na lopu boka turaṉa va kamo lani Goi koasa popoa sapu ele zama tokotokoro veko nia Goi koarini, gua. Ke va mate betoi Goi pa popoa qega si arini, kote gua si arini. ");
INSERT INTO rug_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Ego, Zihova, tepa atu Igo rau kamahire, Mu va dogoroni gami sa Mua ṉiniraṉira. Mamu tavete va gorevura ia sapu gua ele va tatara nia Goi, sapu zama guahe si Goi, ");
INSERT INTO rug_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Arau, sapu se Zihova si lopu hoke tuturei bugoro. Meke hoke tataru ni na taleoso ni Rau sari na sinea na sineke tinarae tadi na tinoni. Ba lopu kaqu galapani Rau saripu tavete va sea koasa Qua ginegese na vina kilasa; kaqu nore va kilasi Rau sari na koburu tadi pu tavete va sea kamo tu koari na vina ṉeta meke vina made sinage na sage,’ gua. ");
INSERT INTO rug_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Ego, Zihova, koasa Mua tataru lavata sapu lopu ta ṉana kamona si tepa Igo rau, Mamu taleosoni sari na sinea tadi na tinoni hire, kekeṉoṉo gua puta tugo, sapu taleosoni Goi seunae gua luaria rini sa popoa Izipi.” ");
INSERT INTO rug_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Meke olaṉa la koasa se Zihova, “Leana, kote taleoso ni Rau gua tugo sapu tepa ia goi koa Rau,” gua si Asa. ");
INSERT INTO rug_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","“Ele gilania goi sapu Arau si na Tamasa toaqu, meke siṉia na Qua ṉiniraṉira lavata sa doduru kasia popoa. ");
INSERT INTO rug_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Ego, namu lopu keke ri kasa tie hire saripu ele dogoria sa Qua ṉiniraṉira lavata, meke sari na tinavete variva magasadi, saripu ele taveti Rau pa popoa Izipi, meke pa korapa popoa qega, ba va kari Au na podepodekau rini ka manege puta totoso meke korodia va tabe Au, ");
INSERT INTO rug_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","si kaqu nuquria sa popoa Kenani. Ele va tatara nia na zama tokotokoro nia Rau koari tiatamadia si asa. Namu lopu keke ri kasa arini pu ele kilu Au si kaqu nuquria si asa. ");
INSERT INTO rug_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Ba sapu se Kelebi sa Qua nabulu si ele tagoa sa binalabala votikaena, meke luli zoṉazoṉa Au sa. Kaqu turaṉa nuquru nia Rau koasa popoa sapu ele dogoria sa, meke sari na tudia ri na tuna koari na sinage na sage si kaqu koa koasa popoa sana. ");
INSERT INTO rug_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Ego, vugo si mi kekere pule lamo pa korapa qega, koasa siraṉa sapu pule la gua pa Kolo Ziṉara, ke mi lopu nuquru la koasa popoa vasina korapa koa dia sari na tie Amaleki meke Kenani.” ");
INSERT INTO rug_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Zama la koe Mosese meke Eroni se Zihova, ");
INSERT INTO rug_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Vea seunae gua si kaqu zamazama Nau na va kari Au ri na tinoni kaleadi hire si Rau? Ele hola pa pada sari na zinamazama pu avosi Rau hire. ");
INSERT INTO rug_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Ego, Arau Zihova sa Tamasa toaqu si zama tokotokoro atu koa gamu, ke mamu la koarini kamahire meke tozia sa Qua zinama sapu guahe: ‘Kaqu tavete va hinokara vatu nia Rau koa gamu sapu gua tepa ia gamu koa Rau, mamu guni. ");
INSERT INTO rug_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Kaqu mate si gamu meke sari na tinimia si kaqu ta pomunae pa korapa popoa qega. Ura va kari Au gamu koari doduru mia zinamazama, ke loke tie gamu pu hiokona puta vuahenina meke sage si kaqu nuquria sa popoa Kenani. ");
INSERT INTO rug_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Namu loke tie gamu si kaqu nuquria sa popoa sapu ele va tatara veko nia Rau koa gamu pude koa ia, ba ari Kelebi meke Zosua mo. ");
INSERT INTO rug_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Zama si gamu, sari na mia koburu si kote ta vagi guana likakalae pa totoso vinaripera gua. Ba kaqu turaṉa nuquru lani Rau si arini koasa popoa sapu kilu ia gamu, meke kaqu na dia popoa si asa. ");
INSERT INTO rug_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Ba sapu gamu si kaqu mate tani pa korapa popoa qega. ");
INSERT INTO rug_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Meke sari na mia koburu si kaqu ene lamae meke kopu sipi mo pa korapa popoa qega koari ka made ṉavulu puta vuaheni meke kaqu koa ta sigiti si arini, sina lopu ronu Au gamu si Rau, osolae kaqu eko meke mate palae pa popoa qega sari na tinimia. ");
INSERT INTO rug_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Ka made ṉavulu puta vuaheni si kaqu koa ta sigitini gamu sari na mia sinea. Keke rane koari hopeke vuaheni koari ka made ṉavulu puta rane sipu piko nia gamu sa popoa Kenani. Meke kaqu gilanau gamu sapu koa guana mia kana si Rau. ");
INSERT INTO rug_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Zama tokotokoro atu si Rau koa gamu, na tinoni kaleamia pu ele mae varigara, meke va kari Au. Kaqu mate beto si gamu doduru pa korapa popoa qega hie,’ gua si zama nia Arau Zihova.” ");
INSERT INTO rug_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","37","Ego, sari kasa tie saripu garunu lani e Mosese pude la piko nia sa popoa Kenani, si paleke pule mae inavoso kokohadi koari na tinoni Izireli meke va zamazamai na va karia rini se Zihova, gua, asa ke va razani minoho Zihova si arini meke mate. ");
INSERT INTO rug_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Ba koari ka manege rua tie piko, si ari Zosua meke Kelebi mo si toa hola. ");
INSERT INTO rug_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Sipu tozini Mosese koari na tinoni Izireli sapu gua zamani e Zihova, si kabo sisigiti si arini. ");
INSERT INTO rug_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Meke pana munumunu vaqavaqasa si topue ene sage la koari na toqere ululudi si arini, meke zama, “Ele tavete va sea si gami, ke kaqu sage la si gami koasa popoa sapu ele va tatarani gami e Zihova,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Ba zama la koa rini se Mosese, “Na vegua ke va karia tu gamu sa zinama te Zihova kamahire. Lopu kaqu boka va kilasi gamu sari na mia kana,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Mi lopu sage la. Lopu koa koa gamu se Zihova. Kote va kilasa gamu ri na mia kana si gamu. ");
INSERT INTO rug_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Ura pana dogoro gamu ri na tinoni Amaleki meke Kenani si kote va mate gamu rini pa vinaripera meke lopu kaqu tokani gamu e Zihova, sina lopu lulia gamu sa Nana hiniva. ");
INSERT INTO rug_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Ba ene nono sage la dia tu koari na toqere si arini, ba se Mosese si lopu somana luli sage la, meke gua tugo sa Bokese Vinariva Egoi te Zihova si lopu ta paleke luli la tugo, ba koa hola dia koasa vasina sapu koa ia rini. ");
INSERT INTO rug_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Meke gore mae gedi sari na tie Amaleki meke sari na tie Kenani saripu koadi pa toqere meke seke va matei na hadu zukuri rini meke va kamo la i tu pa Homa. ");
INSERT INTO rug_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","2","Meke zama se Zihova koe Mosese, “Mu tozini sari na tie Izireli sari na tinarae hire: ‘Pana nuquru la koasa popoa sapu ponini gamu Rau pude koa vasina, ");
INSERT INTO rug_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","meke pana ta vala koe Zihova si keke bulumakao kokoreo, keke sipi kokoreo nomana, keke sipi kokoreo hitekena, babe keke qoti kokoreo, pude na vina vukivukihi va uququ, babe tana vina vukivukihi vina gorevurana sa vina tatara, babe na vina vukivukihi ta poni mokana, babe na vina vukivukihi koari na rane na totoso hopedi, sa hibina sa vinariponi hie si qetu nia e Zihova. ");
INSERT INTO rug_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","5","Asa sapu paleke la nia si keke sipi, ba be keke qoti kokoreo, pude na vina vukivukihi va uququ la koe Zihova, si kaqu veko turaṉae nia tugo si keke kilo palava ta muzara va memehena sapu ta henie keke lita oela olive, pude na vinariponi huiti si asa. Beto mamu zoropo nia keke lita vaeni, pude na vinariponi tana napo. ");
INSERT INTO rug_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Pana ta vala si keke sipi kokoreo nomana, vala turaṉae nia karua kilo palava ta muzara va memehena sapu ta henie keke lita meke kukuru lita oela olive pude na vinariponi huiti si asa, ");
INSERT INTO rug_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","meke poni turaṉae nia keke lita meke kukuru lita kolo vaeni. Sa hibidi rina vina vukivukihi hire, si qetuni e Zihova. ");
INSERT INTO rug_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Pana ta vala sa vina vukivukihi bulumakao kokoreo koe Zihova, pude na vina vukivukihi va uququ, babe na vina vukivukihi vina gorevurana sa vina tatara, babe na vina vukivukihi binaere koe Zihova, ");
INSERT INTO rug_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","si kaqu ta vala sa vinariponi huiti sapu ka ṉeta kilo palava sapu ta henie karua lita oela olive, ");
INSERT INTO rug_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","turaṉae nia karua lita kolo vaeni tugo. Sa hibina sa vina vukivukihi hie si qetu nia e Zihova. ");
INSERT INTO rug_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Arini sari na hopehopeke vinariponi, saripu kaqu ta vala turaṉae koari na bulumakao kokoreo, sipi kokoreo nomana, na sipi kokoreo hitekena, babe na qoti kokoreo. ");
INSERT INTO rug_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Pana soku sari na kurukuru saripu ta vala, si kaqu soku tugo sari na vinariponi huiti na napo padadi sari na vina vukivukihi saripu ta vala. ");
INSERT INTO rug_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Sari doduru tie soti pa butubutu Izireli, si kaqu tavetia sapu gua asa, pana valani rini sari na dia vinariponi, sari na hibidi rina vinariponi arini, si qetuni e Zihova. ");
INSERT INTO rug_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Meke koari doduru totoso mae hiroi be hiva tavetia sa tie karovona, sapu koa paki babe koa va seunae koa gamu, sa vina vukivukihi va uququ, si kaqu lulia sa sa tinarae kekeṉoṉo gua sapu lulia tugo gamu. Sa hibina sa si kaqu qetu nia e Zihova. ");
INSERT INTO rug_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Koari doduru rane vugo repere si kaqu kekeṉoṉo mo sa tinarae koa gamu meke koari na tie karovodi saripu koa koa gamu. Gamu meke arini si kekeṉoṉo mo pa dinoṉo te Zihova; ");
INSERT INTO rug_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","sari na vina tumatumae na tinarae si tamugamu beto mo.’ ” ");
INSERT INTO rug_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","18","Meke zama se Zihova koe Mosese, “Mu tozini sari na tinoni Izireli, ‘Pana nuquru la gamu koasa popoa sapu ponini gamu Rau, ");
INSERT INTO rug_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","meke pana henai gamu sari na ginani vasina, kaiqa rina ginani arini si kaqu ta veko vata kale, na hopedi pude na vinariponi koe Zihova. ");
INSERT INTO rug_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Pana kina bereti si gamu koasa palava vaqura sapu vagi gamu pa totoso pakepakete, sa bereti kekenu sapu kina ia gamu, si hopena, kaqu ta veko pude te Zihova. ");
INSERT INTO rug_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Doduru totoso koari na vuaheni vugo repere, si kaqu valani gamu koe Zihova sa bereti kekenu sapu kina ia gamu koasa palava vaqura pa totoso pakepakete. ");
INSERT INTO rug_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Be keke koa gamu si lopu gilania sapu sea si keke tinavete ba tavete va sea ia sa, meke sekea sa si keke koari na tinarae te Zihova, ");
INSERT INTO rug_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","meke be guana koari na vuaheni vugo na repere, muliṉi ni tugo gamu na butubutu Izireli pude kopu ni sari doduru tinarae saripu ponini gamu Mosese, ");
INSERT INTO rug_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","be guana lopu gilania sa tie sapu sea sa nana tinavete si kaqu vukivukihi va uququ nia sa butubutu si keke bulumakao kokoreo; sa hibina sa vinariponi hie si qetu nia e Zihova. Kaqu va vukivukihi turaṉae nia sa sa vinariponi huiti meke na vinariponi kolo vaeni. Meke kaqu va vukivukihi turaṉae nia tugo sa butubutu si keke qoti kokoreo pude na vina vukivukihi tana sinea. ");
INSERT INTO rug_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Sa hiama si kaqu tavetia sa vina vukivukihi tinaleosae tanisa butubutu, meke kaqu taleosae si arini, sina lopu gilania rini sa sinea sapu tavetia rini. Kaqu taleosae si arini sina vala nia rini sa dia vina vukivukihi va uququ, meke sa vina vukivukihi tana sinea koe Zihova. ");
INSERT INTO rug_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Kaqu taleosae sa doduruna sa butubutu Izireli meke sari na tie karovodi pu koa koa rini, sina doduru mo arini si ele sea beto pa dinoṉo te Zihova. ");
INSERT INTO rug_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Be keke tie mo si lopu gilania sa sapu sea si keke tinavete ba tavete va sea meke sekea sa si keke koari na tinarae te Zihova, si kaqu paleke mae nia sa si keke qoti mamaqota sapu keke vuahenina pude nana vina vukivukihi tana sinea. ");
INSERT INTO rug_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Kaqu tavetia sa hiama sa vina vukivukihi tinaleosae pa kenuna e Zihova tanisa tie pu lopu gilania ba tavete va sea, meke kaqu taleosae si asa. ");
INSERT INTO rug_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Kekeṉoṉo mo sa tinarae sapu kaqu ta vala koari doduru tie pu lopu gilania sa nana sinea meke tavetia sa, be na tie Izireli soti sia babe na tie karovona. ");
INSERT INTO rug_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Ba be tavetia sa tie sa sinea pa nana hiniva soti, be na tie Izireli si asa babe keke tie karovona, si ṉoṉovalia sa se Zihova, ke kaqu tava mate tugo si asa. ");
INSERT INTO rug_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Ura va karia sa sapu gua zama nia e Zihova, meke sekea sa si keke koari Nana tinarae. Telena soti mo evaṉia sa nana minate,’ ” gua se Zihova. ");
INSERT INTO rug_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Sipu korapa koa pa soloso qega sari na tinoni Izireli, si dogoria rini si keke tie korapa vagi nana huda rararo pa Rane Sabati. ");
INSERT INTO rug_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Turaṉa la nia rini pu dogorona si asa koa sa doduruna sa butubutu tie meke koari Mosese e Eroni. ");
INSERT INTO rug_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Kopu totoko nia rini si asa, sina lopu bakala sapu na sa beka si kaqu tavete nia rini si asa, gua. ");
INSERT INTO rug_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Meke zama la koe Mosese se Zihova, “Kaqu tava mate sa tie; sa doduruna sa butubutu tie si kaqu gona va mate nia patu si asa pa sadana vasina koa sari na tie pa ipi.” ");
INSERT INTO rug_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Ke turaṉia sa doduruna sa butubutu tie si asa, pa sadana sa kinoa tie meke gona va mate nia patu rini si asa, gua tugo sapu zama nia e Zihova. ");
INSERT INTO rug_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Zama la koe Mosese se Zihova ");
INSERT INTO rug_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","pude tozini sari na tinoni Izireli: “Mamu va sigoto hola i kaiqa lozi pa hukihukiridi ri na mia poko doduru, mamu vekoa sa lozi bulu koari hopeke pukupuku lozi. Kaqu tavetia gamu sapu gua asa koari doduru totoso mae hiroi. ");
INSERT INTO rug_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Sari na pukupuku lozi arini si kaqu va balabalani gamu pude kopu ni sari doduru tinarae te Zihova meke kaqu va tabei gamu si arini, meke lopu kaqu va ilolae puleni gamu koa Rau si gamu, meke luli mia hiniva na inokoro soti. ");
INSERT INTO rug_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Sari na pukupuku lozi arini si kaqu va balabalani gamu sari doduru Qua tinarae, meke kaqu tava madi si gamu koe Zihova. ");
INSERT INTO rug_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Arau se Zihova sa mia Tamasa; Arau sapu turaṉa vurani gamu pa popoa Izipi, pude na mia Tamasa. Arau se Zihova sa mia Tamasa.” ");
INSERT INTO rug_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","2","Kora si na tuna koreo e Izihara, keke koari pu tuti gore mae koe Kohati pa butubutu Livae, si lopu qetu nia sa sa pinalabatu te Mosese. Ka ṉeta sari na tie si somanae koasa pa butubutu te Rubeni. Ari Datani meke Abirami, si karua tuna e Eliabi, meke se Oni si tuna koreo e Peleti, meke ari ka karua gogoto lima ṉavulu tie Izireli saripu na koimata ta gilanadi meke ta vizatadi koasa butubutu. ");
INSERT INTO rug_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","La vivinei si arini koe Mosese meke Eroni meke zama, “Ele hola sisigiti si gamu kara! Koa beto mo koa gita doduru se Zihova! Te Zihova beto mo sari doduru tie pa butubutu. Ba na vegua si goi Mosese ke va ululae pulenigo koasa butubutu te Zihova?” ");
INSERT INTO rug_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Sipu avosia Mosese sapu gua asa, si hoqa oporapaha pa pepeso si asa, ");
INSERT INTO rug_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","meke zama la koe Kora meke sarini pu lulia si asa, “Vugo munumunu si kaqu va dogoroni gita e Zihova sapu esei gita si Tanisa soti; meke esei si tavamadi. Asa mo sa tie pu vizatia Sa pude ene tata koa Sa pa hope. ");
INSERT INTO rug_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","7","Vugo munumunu agoi Kora meke sari na mua tie si kaqu hopeke paleke vovoina nika, mamu vekoni motete nika toadi na vina uququ humaṉa lea, mamu paleke lani koa sa hope. Meke vasina kaqu dogoria gita, sapu esei si ele vizatia e Zihova. Gamu na tie Livae tu si ele hola sisigiti!” ");
INSERT INTO rug_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Zama la tugo koe Kora se Mosese, “Mi va avoso mae gamu na tie Livae! ");
INSERT INTO rug_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Balabala ia gamu sapu na tiṉitoṉa hite si hie. Gamu si ele tava ilolae koari doduru tie pa butubutu, pude gamu si kaqu ene tata koa Sa, meke taveti sari na tinavete pa korapa Ipi Hopena te Zihova, meke kopuni na tokani sari na butubutu tie. ");
INSERT INTO rug_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Ele vekoa Sa koa gamu meke koari doduru tie Livae pule sa vina lavata hie, meke kamahire si hiva vagia tugo gamu sa tinavete tadi na hiama! ");
INSERT INTO rug_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Totoso zamazama nia gamu se Eroni, gamu meke sarini pu luli koa gamu si va karia se Zihova.” ");
INSERT INTO rug_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Ke garunu la nia tie Mosese se Datani meke Abirami pude va maei, ba zama si arini, “Lopu kaqu atu si gami! ");
INSERT INTO rug_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Vegua lopu leana koa goi pude turaṉa vurani gami koasa pepeso leana pa popoa Izipi, pude va mate gami tani pa korapa popoa qega gua? Na hiva va baṉabaṉarae mo koa gami si goi. ");
INSERT INTO rug_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Hinokara sapu lopu turaṉa maeni gami goi koasa pepeso masuruna sapu sokua na ginani na zipale, meke lopu poni gami vasidi na inuma vaeni, meke kamahire si sekesekeini gami mo goi. Lopu kaqu atu si gami!” gua si arini. ");
INSERT INTO rug_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Bugoro sisigiti se Mosese meke zama la koe Zihova, “Mu lopu malumu vagi sari na vinariponi pu paleke atuni ri na tie hire. Loke qua sinea si tavete la nia rau koa rini. Namu lopu keke koari na dia doṉ'ki si hite vagia rau koa rini.” ");
INSERT INTO rug_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Zama la koe Kora se Mosese, “Vugo munumunu agoi meke sari ka karua gogoto lima ṉavulu tie saripu luli koa gamu si kaqu mae koe Zihova, koasa Ipi Hopena; Eroni ba kaqu mae tugo vasina. ");
INSERT INTO rug_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Hopeke gamu si kaqu palekia nana vovoina nika toana, meke veko nia vina uququ humaṉa lea, meke kaqu la vekoa koasa hope.” ");
INSERT INTO rug_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Ke hopeke paleke raro boronizi vovoina nika sari doduru tie; vekoni nika toadi na vina uququ humaṉa lea rini, meke la turu koe Mosese e Eroni si arini koasa sasadana sa Ipi Hopena. ");
INSERT INTO rug_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Meke sipu ta varigarae koe Kora doduruna sa puku tie pu luli koasa, meke turu pa kenudia ri Mosese e Eroni pa sasadana sa Ipi Hopena, si hinoqa malakapi vura mae se Zihova koari doduru koasa butubutu. ");
INSERT INTO rug_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Meke zama la koe Mosese e Eroni se Zihova, ");
INSERT INTO rug_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Togolo pule koari na tie hire, Maqu va mate betoi gedi kamahire si arini,” gua. ");
INSERT INTO rug_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Ba hoqa oporapaha pa pepeso sari Mosese meke e Eroni meke zama, “Kei Tamasa, Agoi mo ṉatidi sari doduru tinoa. Pana tavete va sea si keke tie, vegua kote bugoro nia goi sa doduru butubutu?” ");
INSERT INTO rug_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Olaṉa se Zihova, ");
INSERT INTO rug_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Tozini sari na tie pude rizu va seu koari na ipi tadi Kora, Datani, meke Abirami.” ");
INSERT INTO rug_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Meke ene la se Mosese somanae koari na koimata pa Izireli koe Datani meke Abirami. ");
INSERT INTO rug_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Zama la koari na tie se Mosese, “Mi rizu va seu koari na ipi tadi na tie kaleadi hire, Lopu tiqua keke toṉa tadirini. Be lopu va tabe gua asa si kaqu tava mate turaṉae beto si gamu koari doduru dia sinea.” ");
INSERT INTO rug_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Ke rizu va seu si arini, koari na ipi tadi Kora, Datani, meke Abirami; ele vura pa dia ipi sari Datani meke Abirami somanae tugo sari dia barikaleqe na koburu. ");
INSERT INTO rug_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Zama se Mosese koari na tinoni, “Kamahire kaqu gilania gamu sapu ta garunu koe Zihova si rau, pude taveti sari doduru tiṉitoṉa gua hire, meke lopu pa qua hiniva soti meke taveti rau si arini. ");
INSERT INTO rug_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Be mate gua mo ri na tie sapu hoke mate sari na tie hire, meke loke vina kilasa koe Zihova, si ta gilana sapu lopu hinokara sapu ta garunuqu koe Zihova si rau. ");
INSERT INTO rug_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Ba be tavetia Tamasa si keke tiṉitoṉa vaqura, meke viqala sa pepeso, ta onolo toa beto sari doduru tie meke sari doduru dia likakalae; toadi meke tava gore la koasa popoa tadi na tie matedi, si kaqu tiqe gilania gamu sapu sari na tie hire si va dogoro nia rini sa tinavete kaleana gua hie koe Zihova.” ");
INSERT INTO rug_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Sipu beto tugo zama se Mosese si ta viqala rua sa pepeso pa kauruna Datani meke e Abirami. ");
INSERT INTO rug_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Meke ta onolo toa beto sari na dia tatamana, meke sari doduru tie te Kora meke sari doduru dia likakalae. ");
INSERT INTO rug_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Toadi meke tava gore la koasa popoa tadi na tie matedi si arini meke sari na dia likakalae tugo; kumuhu sa pepeso meke lopu ta dogoro pule si arini. ");
INSERT INTO rug_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Doduru tie Izireli saripu koa vasina si govete taloa beto, sipu avosi ri gagaemanadi. Kukili sarini, “Haqala! Kote onolo toa gita tugo na pepeso!” gua si arini. ");
INSERT INTO rug_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Hinoqa garunia e Zihova sa nika, meke sulu va matei sari ka karua gogoto lima ṉavulu tie pu paleke vina uququ oto huda humaṉa lea. ");
INSERT INTO rug_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Zama koe Mosese se Zihova, ");
INSERT INTO rug_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Tozi nia se Eleaza, sa tuna Eroni sa hiama, pude vagi va seui sari na vovoina nika koari na tie saripu ele ta sulu va mate pa nika. Mamu paqaha lani pa kaiqa vasina seu sa motete nika koari na vovoina nika, sina na hopedi sari na vovoina nika. ");
INSERT INTO rug_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Tava hope si arini totoso ta vala koe Zihova, ke mamu vagi va seui sari na vovoina nika koari na tie pu ele tava mate koari na dia sinea, mamu sekeseke va hitehite guni na peleta hitekedi; mamu va napiti lani gunia na kapu koasa hope. Kaqu na vina balau tadi na tinoni Izireli si arini.” ");
INSERT INTO rug_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Ke vagi Eleaza, sa hiama, sari na vovoina nika meke ta sekeseke va labelabe meke veko lani koasa hope. ");
INSERT INTO rug_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Na vina balau si hie koari na tinoni Izireli sapu loke tie hoborodi si kaqu mae vala nia sa vina uququ humaṉa lea koe Zihova, meke be keke tie hoborona si mae si kaqu tava mate guari Kora meke sari nana tie. Sari doduru pu garunu ni e Zihova koe Mosese si ta tavete beto koe Elieza. ");
INSERT INTO rug_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","42","Pa koivugona si varigara sa butubutu Izireli meke nominomi la i ri doduru tinoni sari Mosese e Eroni, zama si arini, “Ele va matei gamu si kaiqa tie te Zihova,” gua. Meke doṉo la sarini koasa lei sapu opo tamunia sa Ipi Hope, meke sa malakapina sa kalalasana e Zihova si vura mae. ");
INSERT INTO rug_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Meke la turu pa kenuna sa Ipi Hopena sari Mosese e Eroni, ");
INSERT INTO rug_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","meke zama koe Mosese se Zihova, ");
INSERT INTO rug_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Rizu va seu koari na tie hire, Maqu va matei gedi kamahire!” Ke hoqa oporapaha pa pepeso sari karua, ");
INSERT INTO rug_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","meke zama la koe Eroni se Mosese, “Vagia sa mua vovoina nika, mamu vagi sari na motete toadi koasa hope, mamu voi i na vekoni vina uququ humaṉa lea, mamu tuturei la i sari na tinoni Izireli pude na vina vukivukihi tinaleosae. Ura sa binugoro te Zihova si vura mae meke na oza si ele raza koa rini.” ");
INSERT INTO rug_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Va tabe se Eroni, meke vagia sa sa nana vovoina nika meke haqala la pa vari korapana sa vinarigara tie. Dogoria sa sapu ele podalae tu sa minoho, ke vala nia sa sa vina uququ humaṉa lea koe Zihova meke tavetia sa sa vina vukivukihi tinaleosae tadi na tinoni. ");
INSERT INTO rug_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Turu nana pa varikorapadi ri pu toadi meke na tie matedi si asa meke beto sa oza. ");
INSERT INTO rug_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Sa vinarigaraedi ri na tie pu mate si ari ka manege made tina zuapa gogoto tie, ba lopu somana ta nae varigarae saripu mate pa totoso te Kora. ");
INSERT INTO rug_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Sipu beto sa oza, si pule la koe Mosese pa sasadana sa Ipi Hopena se Eroni. ");
INSERT INTO rug_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Zama sa Tamasa koe Mosese, ");
INSERT INTO rug_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Tozi ni sari na tinoni Izireli pude poni nigo ka manege rua kolu hodu, keke koari hopeke ṉati koimata koari ka manege rua butubutu. Kuberi pozadi pa hopeke dia kolu hodu, ");
INSERT INTO rug_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","beto asa, mamu kuberia sa pozana e Eroni koasa kolu hodu tanisa butubutu Livae. Kaqu keke kolu hodu koari na hopeke koimata koari hopeke manege rua butubutu. ");
INSERT INTO rug_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Paleke lani pa Ipi Hopena, mamu la vekoi pa kenuna sa Bokese Vinariva Egoi vasina sapu hoke tutuvu nigo Rau. ");
INSERT INTO rug_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Sa kolu hodu tanisa tie sapu vizatia Rau si kaqu toqolo vura. Koasa siraṉa hie si kote va nosoi Rau sari na ninominomi tadi na tie Izireli sapu atu gua koa goi.” ");
INSERT INTO rug_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Ke zama la se Mosese koari na tie Izireli, ke hopeke koimata pa hopeke manege rua butubutu si valani dia kolu hodu koasa, meke sa kolu hodu te Eroni ba somanae tugo. ");
INSERT INTO rug_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Meke veko lani Mosese sari doduru kolu hodu pa korapana sa Ipi Hopena pa kenuna sa Bokese Vinariva Egoi te Zihova. ");
INSERT INTO rug_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Pa koivugona, sipu nuquru pa korapana sa Ipi Hopena si asa, si dogoria Mosese sa kolu hodu te Eroni, sapu pa kalina sa butubutu Livae, si ele liho, meke havoro, meke ari vuana, sapu ta pozae olomodi! ");
INSERT INTO rug_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Vagi e Mosese sari doduru kolu hodu meke va dogoro ni sa koari na tie Izireli. Dogori rini gua sapu ta evaṉa, meke vagi pulei ri hopeke koimata sari na dia kolu hodu. ");
INSERT INTO rug_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Zama sa Tamasa koe Mosese, “Veko pule la nia sa kolu hodu te Eroni pa kenuna sa Bokese Vinariva Egoi. Ta veko si asa pude na vina balau koari na tie Izireli va gugue sapu kote mate be lopu va nosoi rini sari na dia ninominomi.” ");
INSERT INTO rug_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Tavetia e Mosese gua sapu garunu nia e Zihova. ");
INSERT INTO rug_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Zama sari na tie Izireli koe Mosese, “Kote mate si gami,” gua, “Na tie mate mami si gami doduru! ");
INSERT INTO rug_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Be keke tie si tata la koasa Ipi Hopena si kote mate si asa; ke gami doduru si kote mate beto.” ");
INSERT INTO rug_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Zama la koe Eroni se Zihova, “Agoi, meke sari na tumu koreo, meke sari na tie Livae, si kaqu tava kilasa nia sa sinea, koari na tinavetavete pa kenuqu Rau pa korapa Ipi Hope; ba agoi mo meke sari na tumu koreo, si kaqu tava kilasa nia sa sinea koasa tinavete tana hiama. ");
INSERT INTO rug_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Kaqu va somani goi pa tinavete sari na mua butubutu Livae, pude toka nigo meke sari na tumu pa tinavete pa korapa Ipi Hopena te Zihova. ");
INSERT INTO rug_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Kaqu totolini goi si arini meke kaqu taveti rini sari na dia tinavete pude toka nigo pa korapa Ipi Hopena te Zihova, ba lopu kaqu tata la i rini sari na tiṉitoṉa madidi pa korapana sa vasina hope ba be koasa hope. Be lopu gua, si agoi meke arini si kaqu tava mate beto. ");
INSERT INTO rug_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Kaqu somana tavetavete toka nigo rini, pude kopu nia na va tanai sari doduru dia tinavete ninabulu koasa Ipi Hopena te Zihova, ba loke votiki tie si kaqu tata mae vasina. ");
INSERT INTO rug_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Agoi meke sari na tumu koreo mo, si kaqu taveti sari na tinavete tana vasina hopena meke sa tinavete koasa hope, pude lopu kaqu bugoro puleni Rau sari na tinoni Izireli. ");
INSERT INTO rug_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Arau mo ele vizati sari na tie Livae turaṉamu koari na butubutu Izireli, guana keke vinariponi koa gamu. Ele tava madi koa Rau si arini, pude madi taveti rini sari na dia tinavete pa korapana sa Ipi Hopena te Zihova. ");
INSERT INTO rug_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Ba agoi mo meke sari na tumu koreo, si kaqu taveti sari doduru tinavete tana hiama koasa hope, meke pa korapana tugo sa Lose Hopena pa Hopena. Ura sari na tinavete tana hiama si ele ponini gamu Rau. Ari na tie hoborodi saripu tata mae koari na tiṉitoṉa hopedi, si kaqu tava mate.” ");
INSERT INTO rug_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Zama koe Eroni se Zihova, “Ele va madi gamu Rau pude kopuni sari doduru vina vukivukihi na vinariponi koa Rau. Meke sari doduru vina vukivukihi na vinariponi saripu lopu tava uqudi pa nika si ponigamu Rau meke sari na tumia. Kaqu na hinia tamugamu meke sari na tudia ri na tumu ninae rane ka rane. ");
INSERT INTO rug_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Sari na vinariponi na vina vukivukihi hopedi hola si tamugamu, sari kukurudi sapu lopu tava uqu koasa hope: sari na vinariponi huiti, sari na vina vukivukihi tana sinea na vukivukihi tinaleosae. Doduru vinariponi hopedi arini saripu ta poni mae koa Rau si tamugamu meke tadi na tumia koreo. ");
INSERT INTO rug_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Kaqu hopedi si arini, meke kaqu henai gamu meke sari na tumia koreo si arini koasa vasina hopena. ");
INSERT INTO rug_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Meke gua pule he: kaiqa vinariponi arilaedi saripu vekoi ri na tinoni Izireli pude ovulu sageni pude Taqarau, si kaqu tamugamu. Kaqu tamugamu meke sari na tumia koreo na vineki doduru totoso vugo repere. Doduru gamu koasa mia tatamana saripu ele via koasa hahanana vina via, si kaqu henai si arini. ");
INSERT INTO rug_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Doduru vua kenudi sapu sari na vinariponi arilaedi hola saripu poni Nau ri na tinoni Izireli koari hopeke vuaheni, si ponini gamu Rau: na oela olive, vaeni, meke na huiti. ");
INSERT INTO rug_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Doduru arini si tamugamu, meke sari doduru tudia rina mia tatamana, saripu ele via koasa hahanana vina via si kaqu henai si arini. ");
INSERT INTO rug_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Doduru tiṉitoṉa saripu ele tava madidi koe Zihova si tamugamu. ");
INSERT INTO rug_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Doduru koburu podo kenudi babe na kurukuru ṉame podo kenudi, sina vinariponi tadi na tinoni Izireli koa Rau. Arini si tamugamu, ba kaqu vagi gamu tinabaradi, pude holu puleni ri na tie sari doduru koburu podo kenudi, meke kaqu gua tugo sari na tinabaradi ri na kurukuru ṉame bonidi saripu podo kenudi. ");
INSERT INTO rug_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Sari na koburu keke sidaradi pododi gua, si kaqu ta holu pule koari ka lima poata siliva padana sa hinoluna pa keke. Kaqu ta pada sa poata siliva koasa mamatana sapu hoke pada nia pa keke poata sapu ta pozae sekeli mamatana pa tinavete koasa Ipi Hopena. ");
INSERT INTO rug_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Ba saripu podo kenudi koari na bulumakao, sipi, na qoti, si lopu kaqu ta holu vagi pule; na Taqarau mo si arini meke kaqu tava madi si arini pude va vukivukihini. Sa eharadi si kaqu ta siburu la koasa hope meke sari na deanadi si kaqu tava uqu koasa hope, meke sari na hibidi si qetu nia Rau. ");
INSERT INTO rug_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Sari na masadi si tamugamu gua tugo sa raqaraqa meke sa pudapuda nene kali matao sapu ta veko koasa vinariponi arilaena. ");
INSERT INTO rug_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Sari na vinariponi madidi saripu ta veko koari na tie Izireli, si Arau Zihova poni atuni koa gamu meke koari na tumia koreo na vineki pude na mia hinia, meke lopu kaqu makudo doduru totoso vugo na repere. Asa sa vina tatara nabuna sapu tavetia Rau koa gamu meke koari na tudia ri na tumia.” ");
INSERT INTO rug_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Zama la koe Eroni se Zihova, “Loke tinago si kaqu tagoa gamu, meke loke pepeso pa Izireli si kaqu tagoa gamu. Arau Zihova mo si tamugamu. Loketoṉa pule.” ");
INSERT INTO rug_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Zama se Zihova, “Ele poni nia Rau koari na tie Livae sari doduru keke pa manege. Saripu vekoi ri na tie Izireli koa Rau. Arini si na tinabaradi ri na dia tinavete ninabulu pa kenuqu Rau koasa Ipi Hopena. ");
INSERT INTO rug_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Kaiqa tie Izireli pule si lopu kaqu tata la koasa Ipi Hope; be ene tata si arini si va tasuna puleni meke garo pude mate si arini. ");
INSERT INTO rug_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Sari na tie Livae mo si kaqu kopu nia sa Ipi Hopena te Zihova meke taveti sari doduru tinavete, podalae kamahire meke kaqu ta kopue tugo sa tinarae hie koari na tudia ri na tudia. Sari na tie Livae si kaqu loke dia tinago soti pa popoa Izireli, ");
INSERT INTO rug_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","sina Arau ele poni sa keke pa manege koa rini. Arini sari na vinariponi madidi pu vekoi ri na tie Izireli koa Rau. Asa gua, ke zama si Rau sapu lopu kaqu tago sotia rini si keke vasi tinago pa popoa Izireli.” ");
INSERT INTO rug_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Zamaia Zihova se Mosese, ");
INSERT INTO rug_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","pude tozini sari na tie Livae, “Totoso vagia gamu sa keke pa manege koari na tie, sa vinariponi asa si na vinariponi te Zihova koa gamu, pude toania. Kaqu ponia gamu sa keke pa manege koari na vinariponi arilaedi arini, pude na mia vinariponi pule la koe Zihova. ");
INSERT INTO rug_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Kaqu qetu ni Rau sari na vinariponi arini, gua puta tugo saripu vekoi rina tie sari na vua kenudi gua puta tugo sari na huiti na vaeni vaqura pu vekoi ri na tie uma. ");
INSERT INTO rug_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Gua puta tugo asa si kaqu ponia gamu koe Zihova sa vinariponi madina, sapu gua vagi gamu koari na keke pa manege koari na tie Izireli. Kaqu vala i gamu sari na vinariponi madidi te Zihova hire koe Eroni sa hiama. ");
INSERT INTO rug_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Mu ponia sapu arilaena hola koari na mua vinagi. ");
INSERT INTO rug_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Pana ponia gamu sapu arilaena hola, mamu kopuni saripu koa hola tamugoi, gua puta tugo sari na tie uma pu kopuni saripu koa hola pa mudina sa dia vinariponi vua kenudi na keke pa manege. ");
INSERT INTO rug_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Boka hena ia gamu meke sa mua tatamana pa keke vasina sapu hiva nia gamu pa sadadi rina vasidi hopena, sina asa sa tinabaradi rina mia tinavete ninabulu koasa Ipi Hopena te Zihova. ");
INSERT INTO rug_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Lopu kaqu garo pude tava kilasa koe Zihova si gamu pana henai gamu si arini, sina ele valani koe Zihova sari na mia vinariponi arilaedi mae guadi koasa vinagi koe Zihova. Ba mi balau nia pude lopu henai sari na ginani arini sipu lopu ele valani gamu sari na mia vinariponi arilaedi; be lopu gua, si kaqu tava mate si gamu.” ");
INSERT INTO rug_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Zamai e Zihova sari Mosese meke Eroni, ");
INSERT INTO rug_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","pude poni koa ri na tie Izireli sari na tinarae hire: “Mamu turaṉa mae nia gamu na tie Izireli koari Mosese e Eroni si keke bulumakao mamaqota ziṉarana loke ari kisakisana, sapu lopu ele va tavetavetia rini pa inuma. ");
INSERT INTO rug_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Meke kaqu la ponia rini koe Eleaza sa hiama si asa. Kaqu ta turaṉa la pa valena sa vasina koa sari na tie pa dia ipi, meke kaqu tava mate pa kenuna sa si asa. ");
INSERT INTO rug_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Beto asa, si kaqu noti lania Eleaza, sa kakarutu limana pa ehara meke siburu nia sa sa ehara koasa Ipi Hopena te Zihova ka zuapa totoso. ");
INSERT INTO rug_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Doduruna sa kurukuru meke sa kapuna, masana, eharana, meke sari na laguna si kaqu tava uqu palae beto pa kenuna sa hiama. ");
INSERT INTO rug_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Beto asa si kaqu vagia sa hiama si keke kukuru huda sida, keke lelaṉa huda hisope, meke keke kukuru lozi ziṉara, meke kaqu oki lani sa pa nika. ");
INSERT INTO rug_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Mudina sapu gua asa, si kaqu va via i sa sari nana poko, meke kaqu zoropo nia kolo sa sa tinina soti, meke tiqe kaqu somana pule pa vinarigara tie si asa, ba lopu kaqu via tugo si asa osolae kamo totoso lodu sa rimata. ");
INSERT INTO rug_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Sa tie sapu suluna sa bulumakao si kaqu va via i tugo sari nana poko, meke zoropo nia kolo tugo sa sa tinina soti, ba lopu kaqu via tugo si asa osolae kamo totoso lodu sa rimata. ");
INSERT INTO rug_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Beto asa, si keke tie sapu via pa dinoṉo te Zihova, si kaqu vagi sari na ebana sa bulumakao, meke kaqu vekoi koasa vasina viana, pa valena sa vasina koa rina tie, vasina si kaqu ta kopue sa eba pude tadi na butubutu Izireli pude tanisa tinavete vina via pa kolo. Sa vina via hie si pude tana vinulasana sa sinea. ");
INSERT INTO rug_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Sa tie vagi varigarani sari na eba si kaqu va via sari nana poko, ba lopu kaqu via tugo si asa osolae kamo totoso lodu sa rimata. Sa tinarae hie si kaqu koa hola doduru totoso koari na rane vugo repere koari na tie Izireli meke sarini pu lopu na tie Izireli saripu koa koa rini. ");
INSERT INTO rug_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Sa tie sapu tiqui sari na tie matedi si lopu kaqu via ka zuapa rane. ");
INSERT INTO rug_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Koasa rane vina ṉeta meke vina zuapa si kaqu va via pule nia tinina pa kolo tana vinavia meke kaqu tiqe via si asa. Ba be lopu va via pule nia si asa, koasa vina ṉeta meke vina zuapa rane si lopu kaqu via si asa. ");
INSERT INTO rug_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Asa sapu tiqua sa tie matena, meke lopu va via pule nia pa kolo vina via, ura lopu zoropo nia kolo sa sa tinina, si lopu kaqu via tugo si asa, ba kaqu koa hola sa bonina, sina lopu ta zoropo kolo vina via si asa. Be ene tata si asa pa Ipi Hopena si va bonia sa sa Ipi Hopena te Zihova; namu lopu kaqu hite koa hola koari na tie te Tamasa si asa. ");
INSERT INTO rug_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Be guana keke tie si mate pa korapa ipi poko sapu koa ia gamu, sari doduru tie pu koa pa korapana sa ipi pa totoso asa si kaqu boni beto si arini. Be keke votiki tie si nuquru pa ipi asa si boni tugo si asa, meke kaqu ta evaṉae boni si arini ka zuapa rane. ");
INSERT INTO rug_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Doduru vovoina kolo na raro saripu loke tukutukudi pa korapana sa ipi vasina mate sa tie, si kaqu boni beto tugo si arini. ");
INSERT INTO rug_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Be tiqua keke tie sa tie matena, sapu tava mate koa keke tie babe keke tie sapu mate hokara nana mo, babe na susuri tie matena si tiqua sa, babe keke lovu, si kaqu boni tugo si asa ka zuapa rane. ");
INSERT INTO rug_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Pude tava via pule sari na boni, kaiqa ebana sa bulumakao ziṉara, sapu tava uqu pude va via i sari na binoni, si kaqu ta vagi meke ta voi pa keke raro, meke zoropo tomo nia kolo. ");
INSERT INTO rug_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Beto asa keke tie sapu viana pa dinoṉo te Zihova, si kaqu vagia sa lelaṉa huda hisope, poṉa ia pa korapa kolo tana vina via, meke siburu la nia koasa ipi meke koari doduru likakalae pa korapana, meke koari na tie saripu koa vasina saripu tava boni sina mate vasina sa tie. Ta hivae tugo pude siburu lani sarini pu tiqua sa susuri tie matena, sa lovu, sa tini matena pu tava mate pa tie babe mate hokara nana mo. ");
INSERT INTO rug_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Koasa rane vina ṉeta, meke koasa rane vina zuapa, sa tie sapu viana, si kaqu siburu la nia sa sa kolo madina koasa tie sapu lopu viana. Koasa rane vina zuapa, si kaqu via sa tie, pa mudina sipu va via i sa sari nana poko meke zoropo pule nia kolo telena, meke kaqu tiqe via si asa pana lodu sa rimata. ");
INSERT INTO rug_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Sa tie sapu boni meke lopu va via pule nia, si koa boni si asa, sina sa kolo tana vina via si lopu ta siburu la koasa, meke kaqu tava boni sa Ipi Hopena te Zihova, be ene tata si asa ke lopu kaqu koa hola sa tie koari na tie te Tamasa. ");
INSERT INTO rug_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Kaqu kopuni gamu sari na tinarae arini doduru totoso vugo na repere. Sa tie sapu siburu nia sa kolo tana vina via, si kaqu va via i tugo sa sari nana poko, be guana tiqua keke tie sa kolo sapu tavetavete nia sa tie, si kaqu boni tugo sa tie asa, osolae kamo totoso lodu sa rimata. ");
INSERT INTO rug_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Sa pule sapu tiqua sa tie sapu lopu viana, si boni tugo, meke esei pule sapu tiqua sa tiṉitoṉa bonina, si lopu via osolae kamo totoso lodu sa rimata.” ");
INSERT INTO rug_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Pa sidara kekenu si mae kamo koasa popoa qega pozana Zini sa doduruna sa butubutu Izireli, meke la koa si arini koa ke vasina pozana Kadesi. Meke vasina si mate se Miriami meke ta pomunae tugo vasina si asa. ");
INSERT INTO rug_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Meke namu loke kolona sa vasina sapu koa ia rini, ke mae varigara koari Mosese e Eroni si arini. ");
INSERT INTO rug_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Meke la tokea rini se Mosese, meke zama guahe: “Kei, leana hola si be mate gua rina tasimami pa kenuna e Zihova si gami,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","“Na pude vegua ke turaṉa maeni gami tu goi tani pa korapa popoa qega si gami na tinoni te Zihova, meke kote mate turaṉi mo gami sari mami kurukuru pa korapa popoa qega hie? ");
INSERT INTO rug_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Meke na vegua ke turaṉa vurani gami tu goi pa popoa Izipi meke mae koa pa popoa kaleana hola hie, vasina sapu loke linetelete boka toqolia. Namu loke huiti, na piqi, na vaeni, meke na pomeqaraneti. Meke namu loke kolo napo na gua,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Meke taluarae koari na tinoni sari Mosese e Eroni, meke la turu pa sasadana sa Ipi Hopena, meke hoqa oporapaha pa pepeso, meke malara mae koarini sa kalalasana e Zihova. ");
INSERT INTO rug_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Meke zama la koe Mosese se Zihova, ");
INSERT INTO rug_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Mu vagia sa kolu sapu koa pa kenuna sa Bokese Vinariva Egoi, mamu tiqe tioko varigarani gamu kara Eroni sa doduruna sa butubutu Izireli. Mamu zama ia sa patu lavata pa kenudia rina tinoni pana hoi, meke kaqu titisi vura mae sa kolo koasa patu lavata, meke kaqu napo sari na tinoni Izireli meke sari na dia kurukuru.” ");
INSERT INTO rug_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Meke ene la vagia Mosese sa kolu koasa Bokese Vinariva Egoi sapu tozi nia e Zihova pude la vagia. ");
INSERT INTO rug_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Varigarani Mosese meke Eroni sa doduruna sa butubutu pa kenuna sa patu lavata, meke zama se Mosese, “Mi va avoso mae ba gamu na tie va gugue. Vegua, hivani gami gamu pude va vura poni gamu kolo koasa patu hie?” ");
INSERT INTO rug_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Meke ovulu sage nia Mosese sa limana meke seke nia kolu sa sa patu lavata sana karua totoso. Meke titisi vura va ṉiṉira mae sa kolo koasa patu lavata, meke tiqe napo sari doduru tinoni meke sari na kurukuru. ");
INSERT INTO rug_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Ba zama la koe Mosese meke e Eroni se Zihova, “Sina lopu ronu Au gamu kara pude va dogoro nia pa matadi ri na tinoni Izireli sa Qua ṉiniraṉira madina, gua asa si lopu kaqu boka va kamoi gamu kara sari na tinoni koasa popoa sapu ele va tatara nia Rau pude ponini koa rini.” ");
INSERT INTO rug_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Gua asa sapu ta evaṉa pa Meriba, vasina sapu zama va gugue nia ri na tinoni Izireli se Zihova, meke vasina tugo si va dogoro nia Sa sapu hopena si Asa koa ri na tie Izireli. ");
INSERT INTO rug_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Koasa dia kinoa ri na tinoni Izireli pa Kadesi si garunu la tie paleke inavoso koasa baṉara pa Edomu d se Mosese, meke zama guahe si arini: “Guahe si zama nia rina tinoni Izireli tasimu: Ele gilani mua tu goi sari na tinasuna saripu ta evaṉa koa gami, ");
INSERT INTO rug_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","sipu gore la pa popoa Izipi sari na tiatamamami, meke koa vasina pa soku vuaheni. Meke ta ṉoṉovala koari na tinoni Izipi si gami meke sari na tiatamamami. ");
INSERT INTO rug_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Ba sipu varavara la koe Zihova si gami, si avosi Sa sari na mami tinepatepa, meke garunia Sa si keke mateana, meke turaṉa vurani gami Sa pa popoa Izipi. Kamahire si korapa koa pa Kadesi si gami tata koasa volosona sa mua popoa lavata. ");
INSERT INTO rug_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Tataruni gami, mamu va malumu gami pude ene hola la gua pa korapa mua popoa. Gami meke sari na mami bulumakao na sipi si lopu kaqu ene taluarae koasa siraṉa nomana. Lopu la pa keke inuma, babe na linetelete vaeni, meke lopu kaqu napo kolo koari na mua berukehe si gami. Ba kote ene gua mo koasa siraṉa nomana tanisa baṉara si gami, meke lopu kaqu kekere la gua pa kali matao babe pa kali gede, osolae ene hola nia tu gami sa mua kali popoa,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Ba olaṉa sa baṉara pa Edomu, “Namu, lopu kaqu ene gua tani si gamu, ba be lopu va avoso gamu, si kote vura atu mo si gami meke kote raza gamu,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Meke olaṉa sari na tinoni Izireli, “Kote koa mo pa siraṉa panaulu si gami, meke be napoi gami meke sari na mami kurukuru sari na mia kolo, si kote vatu poata mo si gami. Lopu hiva nia gami keke ginugua pule ba pude va malumu gami mo pude ene hola,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Ba olaṉa pule la tugo si arini, “Namu, lopu kaqu ene gua tugo tani si gamu.” Beto hoi si vura mae mo se Edomu meke sari nana kobi tie varipera ṉiṉiradi pude razai sari na tinoni Izireli. ");
INSERT INTO rug_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Koa gua sapu lopu hivani tugo rina tie Edomu pude ene gua pa korapana sa dia popoa, gua, si kekere pule meke ene gua pa votiki siraṉa si arini. ");
INSERT INTO rug_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Taluarae pa Kadesi sari doduru tinoni Izireli meke mae pa Toqere Horo ");
INSERT INTO rug_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","koasa volosona sa popoa Edomu, meke zama guahe koari Mosese e Eroni se Zihova, ");
INSERT INTO rug_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Se Eroni si lopu kaqu nuquria sa popoa sapu ele va tatara nia Rau pude vala nia koari na tinoni Izireli, ba kote mate si asa, sina gamu kara beto mo va karia sa Qua zinama pa Meriba. ");
INSERT INTO rug_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Mu turaṉa sage lani koasa Toqere Horo sari Eroni meke sa tuna sapu se Eleaza. ");
INSERT INTO rug_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Mamu va gorei vasina sari nana poko hiama, mamu va sage lani koe Eleaza. Se Eroni si kote mate vasina.” ");
INSERT INTO rug_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Meke taveti tugo Mosese sapu gua garunu ni e Zihova koasa pude taveti. Sage la si arini pa Toqere Horo sipu korapa doṉo toto la dia mo sari na tinoni Izireli. ");
INSERT INTO rug_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Meke va gorei Mosese sari na poko hiama te Eroni, meke va sage lani sa koe Eleaza. Meke mate vasina pa batuna sa toqere asa se Eroni, meke gore pule dia mo koasa toqere asa sari Mosese e Eleaza. ");
INSERT INTO rug_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Meke sipu gilania sa butubutu lavata sapu ele mate se Eroni gua, si kaboia rini si asa ka toloṉavulu puta rane. ");
INSERT INTO rug_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Meke sipu avoso nia sa baṉara Aradi, na tie Kenani, sapu koa koasa kalina mae pa popoa qega pa Kenani, sapu korapa la gua pa siraṉa Atarima sari na tinoni Izireli gua, si rapata la i rini, meke vata pusi rini sari kaiqa tie Izireli. ");
INSERT INTO rug_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Ke zama tokotokoro la guahe koe Zihova sari na tinoni Izireli: “Be va malumia Goi koa gami sa vina kilasadi rina tinoni hire, si kaqu huara upata betoi gami sari na dia vasileana lavata,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Meke avosi e Zihova sari na dia tinepa, meke va malumu la nia Sa koa rini sa vina kilasadi rina tinoni Kenani, meke huara upata betoi rini sari na dia vasileana lavata, gua asa ke poza nia Homa rini sa vasina asa. ");
INSERT INTO rug_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Topue luaria rini sa Toqere Horo meke ene gua pa siraṉa la gua koasa Kolo Ziṉara, pude likohae nia sa popoa Edomu gua. Ba lopu koa va ṉoṉo sari na tinoni koasa dia inene. ");
INSERT INTO rug_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Meke zama va karikaria rini se Zihova meke se Mosese. Zama guahe si arini, “Na vegua ke turaṉa vurani gami tu gamu pa popoa Izipi, pude va mate gami pa popoa qega vasina sapu loke ginani na kolo, gua? Ele mabo hena ia gami sa mana hie,” gua si arini. ");
INSERT INTO rug_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Meke garunu ni noki variva mate e Zihova sari na tinoni Izireli meke garati si arini, meke soku rina tinoni Izireli si mate. ");
INSERT INTO rug_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Meke mae zama guahe koe Mosese sari na tinoni Izireli: “Ele tavete va sea si gami sipu zama va karia gami se Zihova, meke zama va karigo tugo gami si agoi. Ke mamu tepa la koe Zihova kamahire pude va rizu seui sari na noki koa gami.” Meke varavara tokani e Mosese sari na tinoni. ");
INSERT INTO rug_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Meke zama la koe Mosese se Zihova, “Mu tavetia keke noki boronizi, mamu va sigotia koa keke dedegere turuna, meke sari doduru pu ta garata si kaqu doṉo sage la koasa meke toa.” ");
INSERT INTO rug_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Ke tavetia Mosese si keke noki boronizi, meke va sigotia sa pa batuna keke dedegere huda, meke be garatia noki si keke tie si kaqu doṉo sage la koasa noki boronizi meke toa si asa. ");
INSERT INTO rug_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Sari na tinoni Izireli si ene la meke koa paki pa Obati. ");
INSERT INTO rug_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Topue rini pa Obati si la koa pule pa Lae Abarimi, koasa soloso qega, sapu koa pa kali gasa rimata, pa popoa Moabi. ");
INSERT INTO rug_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Beto asa si la koa paki pa lolomo Zeredi. ");
INSERT INTO rug_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Topue vasina, si ene pule meke la koa paki pa kali latu koasa ovuku Anoni, pa korapa qega, sapu hola la pa kali popoa Amoraiti. Anoni si koasa volosona, pa varikorapa Moabi meke sari na tie Amoraiti. ");
INSERT INTO rug_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Gua asa, ke ta Zamae koari na vinaripera koasa buka te Zihova “Sa vasileana nomana pa Vahebi, pa korapa popoa Supa meke sari na lolomo, koasa ovuku Anoni, ");
INSERT INTO rug_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","meke koari na lolomo saripu gore la gua koasa vasileana nomana pa Are, meke kenuna sa volosona Moabi.” ");
INSERT INTO rug_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Taluarae si arini vasina meke ene la pa Bia. Koa nana si keke berukehe, vasina zama se Zihova koe Mosese, “Mu varigarani sari na tinoni, maqu poni kolo,” gua. ");
INSERT INTO rug_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Koasa totoso hie, si kera nia ri na tinoni Izireli sa kinera hie: “Bukaha vura, agoi na berukehe Kaqu kera qetu nia gami pa kinerakera. ");
INSERT INTO rug_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Ta geli koari na baṉara sa berukehe, meke koari na koimata tadi na tinoni. Gelinia kolu qolo tana baṉara rini, meke koari na dia kolu hodu.” Topue koasa soloso qega meke ene la pa vasileana Matana si arini ");
INSERT INTO rug_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","taluarae vasina, si ene la pa Nahalieli meke Bamoti si arini. ");
INSERT INTO rug_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Topue pa Bamoti si arini meke ene la koasa lolomo pa Moabi, pa batuna sa toqere Pisiqa meke doṉo gore la gua koasa qega. ");
INSERT INTO rug_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Va garunu la tie paleke inavoso sari na tinoni Izireli koe Sihoni sa baṉara tadi na tie Amoraiti, sapu zama guahe: ");
INSERT INTO rug_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Mu va malumu gami pude ene hola gua pa mua popoa lopu kaqu taluarae si gami meke sari na mami rovana bulumakao koasa siraṉa, meke la koari na mia inuma huiti ba be inuma vaeni; lopu kaqu napoi gami sari na kolo koari na mia berukehe; kote pa siraṉa mo si koa gami osolae hola taloa koasa mua kali popoa.” ");
INSERT INTO rug_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Ba lopu va egoi Sihoni sari na tinoni Izireli, pude ene hola gua koasa nana kali popoa. Varigara ni sa sari nana qeto minate, meke ene la si arini pa Zahazi pa korapa qega meke la varipera koari na tinoni Izireli. ");
INSERT INTO rug_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Ba sokudi ri na kana si va matei rina tinoni Izireli. Vagia rini sa dia popoa, podalae pa Ovuku Anoni pa kali mae meke kamo la pa Ovuku Zaboki, duta kamoa volosona sa popoa Amoni d. Sa volosona sa popoa Amoni si ta lavelavei va ṉiṉira sisigiti. ");
INSERT INTO rug_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Gua asa, ke vagi betoi ri na tinoni Izireli sari doduru vasileana lavata pa popoa tadi na tie Amoraiti, Hesiboni meke sari doduru vasileana nomadi pa vari likohaena, meke koa vasina si arini. ");
INSERT INTO rug_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Hesiboni si na ṉati vasileana lavata te Sihoni pa popoa tadi na tie Amoraiti, sapu varipera koasa baṉara pa popoa Moabi pukerane meke vagi sa sari doduru nana popoa, kamo la gua tu koasa ovuku Anoni. ");
INSERT INTO rug_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Gua asa ke ta kerae pa kinubekubere; “Mae pa Hesiboni, koasa vasileana lavata te Sihoni sa baṉara! Hiva nia gami pude kuri pulea na va vaqura pulea. ");
INSERT INTO rug_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Keke totoso koasa vasileana lavata pa Hesiboni si topue ene la guana nika sari na tie varipera te Sihoni; Huara va inetia sa sa vasileana lavata pa Ara pa popoa Moabi Va inapahi sa sari doduru toqere pa kali sagena sa Ovuku Anoni. ");
INSERT INTO rug_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Malaṉa hola si gamu, tinoni pa popoa Moabi! Gamu na tie pu vahesia se Kemosi si ele tava kilasa! Vata raovi sa mia tamasa sari na tie, La ta pusi koe Sihoni sa baṉara tadi na tie Amoraiti sari na barikaleqe. ");
INSERT INTO rug_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Ba kamahire sari na tutidia si ele tava inapaha beto. Doduruna podalae pa Hesiboni kamoa Diboni, Taluarae pa Nasimi kamoa Nopa, tata pa Medeba.” ");
INSERT INTO rug_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Gua asa ke koa ia ri na tinoni Izireli sa kali popoa tadi na tie Amoraiti, ");
INSERT INTO rug_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","garuni Mosese sari na tie pude hata ia sa siraṉa sapu leana hola, pude rapatia sa vasileana lavata pa Zazera. Vagi turaṉae nia ri na tinoni Izireli si asa, meke sari na vasivasileana nomadi pa vari likohaena, meke hadu va seu i rini sari na tie Amoraiti pu koa vasina. ");
INSERT INTO rug_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Ene sage la gua koasa siraṉa la gua pa Basani sari na tinoni Izireli, ene mae se Oqo sa baṉara pa Basani, meke sari nana tie varipera, pude varipera koa rini pa Ederei gua. ");
INSERT INTO rug_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Zama koe Mosese se Zihova “Mu lopu matagutu nia si asa sina ele luara vatua Rau koa gamu sa baṉara, meke sari doduru nana tie, meke sa nana popoa. Mamu tavetia koasa gua sapu tavetia gamu koe Sihoni sa baṉara tadi na tie Amoraiti. Sapu sa baṉara pa popoa Hesiboni.” ");
INSERT INTO rug_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Ke va matea ri na tinoni Izireli se Oqo, sari na tuna koreo, meke sari doduru nana tie, loke tie si toa. Beto asa, si koa ia rini sa nana popoa. ");
INSERT INTO rug_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Meke topue ene la sari na tinoni Izireli, meke la noso koari na pezara pa popoa Moabi pa kali gasa rimata pa Ovuku Zodani sapu doṉo karovo la gua pa Zeriko. ");
INSERT INTO rug_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Sipu avoso nia sa baṉara Moabi sapu se Balaki, tuna koreo e Zipora, sa sinokudi rina tinoni Izireli, meke gua sapu tavetia rini koari na tinoni Amoraiti, ");
INSERT INTO rug_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","si matagutu sisigiti si asa, meke gua tugo sari na tinoni pa Moabi. ");
INSERT INTO rug_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Ke zama la koari na koimata tadi na tinoni Midiani sari na tinoni Moabi, “Sa kobi tinoni hie si kote ṉovala betoi sari doduru tiṉitoṉa pa vari likohaena kekeṉoṉo sa bulumakao kokoreo sapu gani va upati sari na duduli pa inuma.” Ke garuni sa baṉara Balaki ");
INSERT INTO rug_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","sari na tie paleke inavoso pude tioko mae nia se Belami, sa tuna koreo e Beoro, sapu koa pa Petoro, tata pa Ovuku Iuparetisi pa popoa Amau. Guahe sa inavoso sapu paleke mae nia rini koe Balaki: “Hiva va gilana nigo rau sa butubutu lavata sapu mae guana pa popoa Izipi, sari na tinoni arini si koa betoa mo rini sa doduru vasina, meke variva mala pude vagi hobea rini sa nada popoa. ");
INSERT INTO rug_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Soku holani gamu rini, ke mae mamu leve maeni si arini. Meke gina kote boka va kilasi mo gami, meke hadu va seui pa mami popoa. Ura gilania rau sapu sarini pu manani goi si hoke ta manae tugo, meke sarini pu leveni goi si hoke ta gorei tugo,” gua si asa. ");
INSERT INTO rug_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Meke topue la sari na palabatu Moabi meke Midiani, palekia rini sa tinabarana sa lineveleve, meke la kamo koe Belami, meke la tozia rini koasa sa zinama te Balaki. ");
INSERT INTO rug_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Meke zama la koa rini se Belami, “Koa paki tani kohite boṉi, pude qu 