﻿USE sofia;
DROP TABLE IF EXISTS sofia.ruf_vpl;
CREATE TABLE ruf_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ruf_vpl WRITE;
INSERT INTO ruf_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Chitabu cha lukolo lwa Yesu Kiristu, mtsukulu wa Daudi, iyakalile mtsukulu wa Abrahamu. ");
INSERT INTO ruf_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahamu tsakamweleka Isaka, Isaka kamweleka Yakobu, Yakobu kamweleka Yuda na ndughu tsake, ");
INSERT INTO ruf_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda kaweleka Peresi na Sela, mai wawo tsakakala Tamari, Peresi kamweleka Hesironi, Esironi kamweleka Aramu, ");
INSERT INTO ruf_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aramu kamweleka Aminadabu, Aminadabu kamweleka Nasoni, Nasoni kamweleka Salimoni, ");
INSERT INTO ruf_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salimoni kamweleka Boasi, mai wake Boasi tsakakala Rahabu, Boasi kamweleka Obedi kwa Rutu, Obedi kamweleka Yese, ");
INSERT INTO ruf_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yese kamweleka Mndewa Daudi, naye Daudi kamweleka Selemani, mai wake Selemani tsakakala mwehe wa Uriya. ");
INSERT INTO ruf_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Selemani kamweleka Rehoboamu, Rehoboamu kamweleka Abiya, Abiya kamweleka Asa, ");
INSERT INTO ruf_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa kamweleka Yehoshafati, Yehoshafati kamweleka Yoramu, Yoramu kamweleka Uzia, ");
INSERT INTO ruf_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzia kamweleka Yosamu, Yosamu kamweleka Ahasi, Ahasi kamweleka Hesekiya, ");
INSERT INTO ruf_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekiya kamweleka Manase, Manase kamweleka Amoni, Amoni kamweleka Yosiya, ");
INSERT INTO ruf_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosiya kamweleka Yekoniya na ndughu tsake mne ghamatsuwa ghala Wayahudi ghawaghalighwe Babeli. ");
INSERT INTO ruf_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Wayahudi hawakalile Babeli, Yekoniya kamweleka Setieli, Setieli kamweleka Serubabeli, ");
INSERT INTO ruf_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabeli kamweleka Abihudi, Abihudi kamweleka Eliyakimu, Eliyakimu kamweleka Asori, ");
INSERT INTO ruf_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asori kamweleka Sadoki, Sadoki kamweleka Akimu, Akimu kamweleka Eliudi, ");
INSERT INTO ruf_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudi kamweleka Eliasali, Eliasali kamweleka Matani, Matani kamweleka Yakobu, ");
INSERT INTO ruf_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakobu kamweleka Yosefu, mmale wake Mariya, mai wake Yesu iyokemighwa Kiristu Mkombotsi. ");
INSERT INTO ruf_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Apfo tsakukala na pfeleko kumi na nne kulawa Abrahamu mbaka Daudi, na pfeleko kumi na nne kulawa Daudi mbaka Wayahudi hawaghalighwe akula Babeli, na pfeleko kumi na nne kulawa Wayahudi hawaghalighwe Babeli mbaka kwelekighwa kwa Kiristu Mkombotsi. ");
INSERT INTO ruf_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ukwelekighwa kwa Yesu Kiristu tsakukala pfino, Mariya mai wake Yesu tsakalapfighwa tsengele na Yosefu, lekeni ng'ana wawase hamwe bae, Mariya tsakoneka kana inda kwa uwetso wa Ghumuhe Mwenzeluka. ");
INSERT INTO ruf_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Kwaapfila Yosefu tsakakala imunu yanoghile, ng'abamile bae kumghela ichinyala Mariya, apfo kabama yamleke chinyelenyele. ");
INSERT INTO ruf_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Hang'ali yakwalangula chinu acho, Malaika kamlawila mndoto kamlongela, “Yosefu mwana wa Daudi, uleke kupfuka kumsola Mariya yawe mwehe wako, kwaapfila inda yake ilawa kwe Ghumuhe Mwenzeluka. ");
INSERT INTO ruf_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Katsakwelekela imwana mmale, naghwe kutsomwing'a taghwa Yesu. Kwaapfila katsowakombola iwanu wake kulawa mne nzambi tsawo.” ");
INSERT INTO ruf_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ghose ghano ghalawila kutimilitsa aghala ghayalongile Imtwatsa kubitila nabii, ");
INSERT INTO ruf_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Mwali ng'ana yawase na mmale katsokinda inda, katsomweleka imwana, nawo watsomkema Imanweli! Mana yake, Imulungu kahamwe na twetwe.” ");
INSERT INTO ruf_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Apfo Yosefu hayalamke katenda ka malaika pfayamlongele, kamsola Mariya, mwehe wake. ");
INSERT INTO ruf_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Lekeni ng'awasile naye bae mbaka hayeleke imwana. Yosefu kamwing'a litaghwa imwana ayo Yesu. ");
INSERT INTO ruf_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu tsakoneka mne ghumji ghwa Betilehemu mne isi ya Yudeya, ghamatsuwa ghala Herodi hakalile Imndewa. Iwanu iwomanya igholawila kwa kulola tsinondo iwalawile ubali wa kwalilawila litsua tsawatsa Yerusalemu, ");
INSERT INTO ruf_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","waghutsa, “Yalikwani imndewa wa Wayahudi yelekighwe? Tuyona inondo yake kulawa ubali wa kwalilawila litsua, kuya tutsa kumtamanila.” ");
INSERT INTO ruf_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Imndewa Herodi na iwanu wose iwali Yerusalemu hawahulike apfo, tsawaghanzika. ");
INSERT INTO ruf_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herodi kawakema hamwe iwatambika wakulu na iwolangulitsa Ghamalaghitso, kawaghutsa, “Kiristu Mkombotsi yatsakonekela kwani?” ");
INSERT INTO ruf_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Wamwidika, “Katsakonekela Betilehemu mne isi ya Yudeya, kwaapfila yandikighwa na nabii, ");
INSERT INTO ruf_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Naghwe Betilehemu yuli mne isi ya Yuda, ng'auli mdodo bae mne ipfilongotsi wa Yudeya, kwaapfila kuna ghweghwe katsolawila chilongotsi, naye katsokuwa imdimi we iwanu wangu we Isiraeli.’ ” ");
INSERT INTO ruf_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Kuya Herodi kawakema chinyelenyele awala iwanu iwomanya igholawila kwa kulola tsinondo ili wamlongele inondo tsailawile tsuwachi. ");
INSERT INTO ruf_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Kuya kawatuma Betilehemu, kawalongela, “Mghende mkabame pfinoghile kwayali imwana. Baho hamtsomwona muye mnilongele ili na nene nighende nikamtamanile.” ");
INSERT INTO ruf_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Nawo hawamalitse kumhulikitsa imndewa tsawoka, na inondo iyawonile kulawa ubali wa kwalilawila litsuwa iwalongotsa na ukwima hanu kwayakalile imwana. ");
INSERT INTO ruf_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Hawayonile inondo ayo, wadeng'elela sideke. ");
INSERT INTO ruf_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Apfo wengila mng'anda, wamwona imwana hamwe na Mariya mai wake, nawo wenama hambele hake, wamtamanila. Kuya wapfughula imikoba yawo, wamwing'a nzawadi, nzahabu, upfumba na dawa inoghile iikemighwa manemane. ");
INSERT INTO ruf_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kuya woya ukaye yawo kwa inzila ingi, kwaapfila Imulungu tsakawakanya mndoto waleke kumuyila Herodi. ");
INSERT INTO ruf_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Iwanu awo hawokile, malaika kamlawila Yosefu mndoto kamlongela, “Winuke, umsole imwana na mai wake, mtsumile Misiri. Mkale ako mbaka hanitsokulongela, kwaapfila Herodi kobama yamkome imwana.” ");
INSERT INTO ruf_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Apfo Yosefu kalamka, kamsola imwana na mai wake ichilo chicho, waghenda Misiri. ");
INSERT INTO ruf_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Tsakakala ako mbaka Herodi hayafile. Chinu acho chitendeka ili imbuli yalongile Imtwatsa kubitila nabii itimile, “Tsanimkema mwanangu kulawa Misiri.” ");
INSERT INTO ruf_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herodi hayatangile ka iwanu iwomanya igholawila kwa kulola tsinondo wamghutsukila, tsakona maya ng'ani. Kalapfa laghitso iwana wose iwamale iwali Betilehemu na awala iwali habehi wakomighwe, iwana iwakalile na miyaka mili na awala ing'awapfikile miyaka mili kulawa litsuwa lila iwanu wala hawayonile inondo. ");
INSERT INTO ruf_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Kuya achila ichilongighwe na nabii Yeremiya chitimila, ");
INSERT INTO ruf_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Listi lyohulikighwa ako Rama, chililo cha usungu mkulu, Raheli kowalilila iwanaghe naye kolema kukanzighwa, kwaapfila wose wafa.” ");
INSERT INTO ruf_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herodi hayafile, malaika we Imtwatsa kamlawila Yosefu mndoto mne isi ya Misiri, ");
INSERT INTO ruf_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","kamlongela, “Winuke, umsole imwana na mai wake muye Isiraeli, kwaapfila awala iwabamile kumkoma imwana, wose ma wafa.” ");
INSERT INTO ruf_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Apfo Yosefu kenuka, kamsola imwana na mai wake woya Isiraeli. ");
INSERT INTO ruf_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Lekeni Yosefu hayahulike Akelao kawa mndewa hanu ha Herodi, aba wake ako Yudeya, tsakapfuka kughenda ako, naye kwaapfila kakanyighwa mndoto, tsakaghenda Galilaya, ");
INSERT INTO ruf_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","kuya kakala mne ghumji ghwa Natsareti. Apfo chitimila achila ichilongighwe na manabii, “Katsokemighwa Mnasaleti.” ");
INSERT INTO ruf_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Imiyaka mingi hambele Yohane Mbatitsa tsakaghenda mne inyika ya Yudeya, kandusa kuwapetela iwanu. ");
INSERT INTO ruf_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Kalonga, “Mtsileke nzambi tsenu kwaapfila Undewa wa kulanga wa habehi!” ");
INSERT INTO ruf_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yohane iyo imunu iyalongighwe ne nabii Isaya, “Litsi lye imunu lyokema kunyika, ‘Muiyandae inzila ye Imtwatsa, mgholoseleni inzila yake.’ ” ");
INSERT INTO ruf_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohane tsakapfala ghamaghwanda ighatendighwe kwe imighala ye ngamiya, na ghumsipi ghwe ingotsi mchuno, chijo chake tsachikala iwanzighe ne uki ye kwibagho. ");
INSERT INTO ruf_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Iwanu wamghendela kulawa Yerusalemu, Yudeya yose na kulawa mne isi tsose itsili habehi ne ghumto Yoridani. ");
INSERT INTO ruf_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Watsitoghola nzambi tsawo na kutsileka, naye kawabatitsa mne ghumto Yoridani. ");
INSERT INTO ruf_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yohane hawonile Mafarisayo na Masadukayo wengi womtsila yawabatitse, kawalongela, “Mwemwe iwana we nzoka! Yuhi yawalongele mwodaha kuhepa ukuhighighwa ne Imulungu ikukutsa? ");
INSERT INTO ruf_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mtende aghala igholangusa ka mtsileka nzambi tsenu. ");
INSERT INTO ruf_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Mleke kwipfikitsa ka mwodaha kuhepa ukuhighighwa ne Imulungu kwa kulonga mwinaye aba wenu Abrahamu. Nomlongelani ghendo, Imulungu kodaha kumtendela Abrahamu iwana kulawa mne ghamabwe ghano. ");
INSERT INTO ruf_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Hoya ma ikighwa mmasina mwe imibiki, apfo chila mbiki ing'aukweleka ghamatunda ghanoghile woghanighwa na kwasighwa mmoto. ");
INSERT INTO ruf_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nene nowabatitsa kwa ghamatsi kulangusa ka mtsileka nzambi tsenu. Lekeni ayo iyakutsa kuchughu kwangu kana ingupfu kubita nene, nene sibamighwa bae hata kughala imikwabatsa yake. Ayo katsowabatitsa kwa Ghumuhe Mwenzeluka na kwa ghumoto. ");
INSERT INTO ruf_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Lungo lwake lwe ukubetela lwa mmoko mwake. Naye katsokunga uhemba na kuwika mkano, na katsolakatsa mikumvi mne ghumoto ing'aghutsimika bae.” ");
INSERT INTO ruf_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Kuya Yesu kalawa Galilaya, kaghenda ghumto Yoridani kubatisighwa na Yohane. ");
INSERT INTO ruf_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Lekeni Yohane tsakabama yamghome, kalonga, “Nene nobamighwa nibatitsighwe naghwe, naghwe konitsila nene?” ");
INSERT INTO ruf_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yesu kamwidika, “Uleke sambi iwe pfipfo. Kwaapfila twobamighwa kughatenda aghala ghose ghobama Imulungu.” Kuya Yohane katoghola. ");
INSERT INTO ruf_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesu hayamalitse kubatisighwa, bahala kalawa mmatsi. Baho lilanga lipfughuka, kamwona Ghumuhe ghwe Imulungu kohulumka ka njiwa na kumtsila mchanya mwake. ");
INSERT INTO ruf_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kuya litsi kulawa kulanga lilonga, “Ayuno Imwanangu iyoninoghela, noghelighwa naye.” ");
INSERT INTO ruf_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kuya Yesu kalongotsighwa na Ghumuhe we Imulungu mbaka kunyika yaghetsighwe na Yehile. ");
INSERT INTO ruf_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Tsakafunga ukuja ghamatsuwa alubaini chilo na misi, kuya tsakona nzala. ");
INSERT INTO ruf_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Baho Setani kamghendela, kamlongela, “Ka ghweghwe kwa Imwana we Imulungu, ghalongele ghamabwe ghano ghawe pfighate.” ");
INSERT INTO ruf_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesu kamwidika, “Yandikighwa mne Ghamaandiko Mahenzeluka. ‘Imunu ng'odaha bae kuwa mghima kwa chijo chiliyeka, ila kwa chila imbuli iyolonga Imulungu.’ ” ");
INSERT INTO ruf_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kuya Setani kamsola Yesu mbaka Yerusalemu, ghumji ghwenzeluke, kamwika mchiswili ghendo mwe Ing'anda ye Imulungu. ");
INSERT INTO ruf_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Kuya kamlongela, “Ka ghweghwe kwa Imwana we Imulungu, wilaghatse hasi, kwaapfila yandikighwa, ‘Imulungu katsowalaghitsa wamalaika wake, nawo watsokukinda kwa ghamoko ghawo, uleke kwilagha mne ghamabwe.’ ” ");
INSERT INTO ruf_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu kamwidika, “Pfipfila yandikighwa, ‘Uleke kumghetsa Imtwatsa Imulungu wako.’ ” ");
INSERT INTO ruf_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kuya Setani kamsola keli mbaka mne chidando chitali ng'ani, kamlangusa undewa wose we isi na ukulu wose we isi. ");
INSERT INTO ruf_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Kuya kamlongela, “Ung'enama hambele hangu na kunitamanila, nitsokwing'a ghano ghose.” ");
INSERT INTO ruf_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yesu kamlongela, “Ghenda Setani! Kwaapfila yandikighwa, ‘Umtamanile Imtwatsa Imulungu wako, umtumikile yeye yaliyeka!’ ” ");
INSERT INTO ruf_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Kuya Setani kamleka Yesu, na wamalaika watsa wamtumikila. ");
INSERT INTO ruf_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesu hayahulike Yohane wamwika mchifungo, koka Galilaya. ");
INSERT INTO ruf_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Kalawa Natsareti, kaghenda kukala Kaperinaumu, isi iili habehi ne tsimbu lya Galilaya, na iibakane ne isi ya Sabuloni na ya Nafutali. ");
INSERT INTO ruf_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Achino chitendeka ili achila chayalongile nabii Isaya chitimile, ");
INSERT INTO ruf_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Isi ya Sabuloni na isi ya Nafutali, inzila ya kughendela mna bahali, kumwambu mwe Yoridani. Galilaya, isi ye iwanu iwali si Wayahudi! ");
INSERT INTO ruf_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","“Iwanu iwokala mchisi watsakona ghumwanga. Awala iwokala mne isi ye chimbeho che lifwa ghumwanga ghutsowamwemwesela.” ");
INSERT INTO ruf_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kulawa matsuwa agho Yesu kanza kuwapetela usenga wake, “Mleke kutenda nzambi, kwaapfila undewa wa kulanga wa habehi.” ");
INSERT INTO ruf_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu hayang'ali yoghenda mmbalimbali mwe tsimbu lya Galilaya, kawona iwandughu weli, Simoni iyakemighwe Petiri na ndughu yake Andereya. Tsawang'ali wolowa iwasomba kwa nyapfu mne tsimbu lya. ");
INSERT INTO ruf_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu kawalongela, “Mniwinze, nani nitsowatenda muwe iwalowa we iwanu.” ");
INSERT INTO ruf_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Bahala watsileka nyapfu tsawo, wamuwinza. ");
INSERT INTO ruf_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Haghendile hambele chidogho, kawona iwandughu wangi weli, Jakobu imwana we Sebedayo na ndughu yake Yohane. Tsawakala mne mnumbwi hamwe na aba wawo Sebedayo, wotenda nyapfu tsawo. Yesu kawakema, ");
INSERT INTO ruf_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","bahala waghuleka mnumbwi na aba wawo, wamuwinza. ");
INSERT INTO ruf_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu tsakanga Galilaya yose, kalangulitsa mne tsing'anda tse ukulombela, kawapetela iwanu Imbuli Inoghile ye Undewa we Imulungu na kawahonetsa iwanu wane matamu ghose. ");
INSERT INTO ruf_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Mbuli tsake tsenela mne isi yose ya Siriya, apfo iwanu wamghalila iwatamu wose, iwoghula utamu wowose, awala iwodununzika, wane pfinyamkela, iwakughwa chisala na awala iwaholole, naye kawahonetsa. ");
INSERT INTO ruf_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Na iwanu wengi wamuwinza kulawa Galilaya, isi tsa Dekapoli, Yerusalemu, Yudeya ne isi ili kumwambu mwa ghumto Yoridani. ");
INSERT INTO ruf_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu hawonile mtingano ghwe iwanu, kagheluka mchidunda, kuya kakala hasi. Iwanang'ina wake wamghendela, ");
INSERT INTO ruf_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","naye kandusa kuwalangulitsa, ");
INSERT INTO ruf_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Wabweda iwanu wala iwomuhuwila Imulungu, kwaapfila Undewa we kulanga wawo. ");
INSERT INTO ruf_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Wabweda awala wane usungu, kwaapfila watsokanzighwa. ");
INSERT INTO ruf_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Wabweda awala iwahole, kwaapfila watsoihala iisi. ");
INSERT INTO ruf_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Wabweda awala wane inzala ne ing'ilu ya kutenda ghayobama Imulungu, kwaapfila Imulungu katsowaghutitsa. ");
INSERT INTO ruf_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Wabweda awala wane libatsi, kwaapfila Imulungu katsowonela libatsi. ");
INSERT INTO ruf_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Wabweda awala wane imimoyo inoghile, kwaapfila watsomwona Imulungu. ");
INSERT INTO ruf_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Wabweda awala iwalamulitsi, kwaapfila watsokemighwa iwana we Imulungu. ");
INSERT INTO ruf_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Wabweda awala iwodununzika kwa kutenda aghala ghayobama Imulungu, kwaapfila undewa wa kulanga wawo. ");
INSERT INTO ruf_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Mbweda iwanu hawatsomlighani na kumdununzani na kumlongani pfihile kwa ughutsu, kwaapfila mwemwe mwoniwinza nene. ");
INSERT INTO ruf_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mdeng'e na kudeng'elela kwaapfila ghweko lyenu kulu likighwa kulanga, apfi pfipfo manabii wa ghumwande we Imulungu pfawadununzike hala ng'ana mwemwe mwelekighwe. ");
INSERT INTO ruf_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Mwemwe mwa imunyu ye isi. Lekeni imunyu ing'ahinyika, angu mtsoghuma choni mbaka ikole keli? Yahela sang'ano bae, apfo yakwasighwa kunze na iwanu woibayugha. ");
INSERT INTO ruf_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Mwemwe mwa ghumwanga ghwe iisi. Kaye ing'awa mchidando ng'aidaha bae kwipfisa. ");
INSERT INTO ruf_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Iwanu ng'awotuwa bae chitasa na kuchighubika ne iseghe, ila wochika hanu ha kwikila chitasa, nacho chowamulikila iwanu wose iwali mng'anda. ");
INSERT INTO ruf_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Pfipfila namwe ghumwanga ghwenu ghumulike hambele he iwanu, nawo waghone ghala ighanoghile ighamtenda, wamtunitse Aba wenu iyali kulanga. ");
INSERT INTO ruf_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Mleke kupfikitsa ka nene nitsa kuleghusa Ghamalaghitso gha Musa au pfitabu pfe manabii we Imulungu. Sitsile bae kuleghusa, ila nitsa kutimilitsa. ");
INSERT INTO ruf_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nowalongelani ghendo, mbaka lilanga ne isi hapfitsohupa, kuduhu imbuli ndodo mne Ghamalaghitso iitsoleghusighwa mbaka ghose ghatimile. ");
INSERT INTO ruf_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Imunu wowose iyolema kukinda laghitso dodo kulawa mne Ghamalaghitso ghano na kuwalangulitsa iwanu wangi watende pfipfo, ayo katsokuwa mdodo mne undewa wa kulanga. Lekeni ayula iyokinda Ghamalaghitso na kuwalangulitsa iwanu watende pfipfo, ayo katsokemighwa mkulu mne undewa wa kulanga. ");
INSERT INTO ruf_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nowalongelani ghendo, ka ng'amtenda bae ghobama Imulungu kubita pfawotenda Mafarisayo na iwolangulitsa Ghamalaghitso, ng'amtsokwingila bae mne undewa wa kulanga. ");
INSERT INTO ruf_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Muhulika iwanu wa ghumwande pfawalongelighwe, ‘Mleke kukoma, na imunu wowose ang'akoma katsohighighwa.’ ");
INSERT INTO ruf_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Lekeni nene nowalongelani ghendo, imunu wowose iyomwonela maya ndughu yake, katsohighighwa. Na ayula iyombetsa ndughu yake katsoghalighwa kune libaratsa, na ayula iyomkema ndughu yake, ‘Mbotsi!’ ayo kahabehi ukwingila mne ghumoto ghwa jehanamu. ");
INSERT INTO ruf_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ka komlapfila Imulungu wako nambiko hanu ha kutambikila, na kwokumbuka tsakwisonga na ndughu yako, ");
INSERT INTO ruf_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tanu uileke nambiko yako hanu aho, ughende wikelamlitse na ndughu yako, kuya uye uilapfe nambiko yako. ");
INSERT INTO ruf_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Wilamle ne imunu iyakughalile kune libaratsa. Utende apfo mng'ali mnzila, hela katsokughala kwe imlamulitsi na imlamulitsi katsokughala kwe asikali mkulu, naye katsokwika mchifungo. ");
INSERT INTO ruf_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nokungela ghendo, ng'utsolawa bae mbaka ulihe sendi yose. ");
INSERT INTO ruf_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Muhulika tsailongighwa, ‘Mleke ughoni.’ ");
INSERT INTO ruf_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Lekeni nene nowalongelani, imunu wowose iyomlolesa ipinga kwa kumbama, ayo ma katenda naye ughoni mmoyo mwake. ");
INSERT INTO ruf_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ka inenge yako ya kujilo yokuhonza utende ghehile, uing'ole uyase kutali naghwe. Ng'apfu kwaghisa chilungo chako chimwe, kubita kululeka lukuli lwako lwose lwasighwe mne ghumoto ghwa jehanamu. ");
INSERT INTO ruf_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Na ghumoko ghwako ghwa kujilo ka wokuhonza utende ghehile, ughane, ughwase kutali naghwe. Ng'apfu kwaghisa chilungo chimwe, kubita kululeka lukuli lwako lwose lwasighwe mne ghumoto ghwa Jehanamu. ");
INSERT INTO ruf_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Tsailongighwa, ‘Imunu wowose iyomleka mwehe wake kobamighwa yamwing'e talaka.’ ");
INSERT INTO ruf_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Lekeni nene nomlongelani, imunu wowose iyomleka mwehe wake, ila kwaapfila katenda ughoni, komtenda yawe mghoni, na imunu wowose iyomkwela ipinga yalekighwe, naye kotenda utsinzi. ");
INSERT INTO ruf_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Kuya muhulika iwanu wa ghumwande pfawalongelighwe, ‘Uleke kubena lilaghano, ila ukindilise lilaghano lyako kwe Imtwatsa.’ ");
INSERT INTO ruf_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Lekeni nene nomlongelani, mleke kwilaha, wala kwa kulanga, kwaapfila acho chighoda che undewa we Imulungu, ");
INSERT INTO ruf_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","au kwilaha kwe isi, kwaapfila aho hanu he ukwikila ghamaghulu ghake, wala kwa Yerusalemu, kwaapfila agho ghumji ghwe Imndewa Mkulu. ");
INSERT INTO ruf_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Wala mleke kwilaha kwa litwi, kwaapfila ng'amdaha bae kulutenda lupfili lumwe luwe lutselu au lutitu. ");
INSERT INTO ruf_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mng'alonga ‘Ona,’ iwe ‘Ona,’ na mng'alonga ‘Bae,’ iwe ‘Bae.’ Ichinu chochose kubita agha, cholawa kwa Yehile. ");
INSERT INTO ruf_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Muhulika tsailongighwa, ‘Inenge kwa inenge, na tsino kwa tsino.’ ");
INSERT INTO ruf_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Lekeni nene nowalongelani, mleke kwihisanya ne imunu yehile. Imunu ang'akutowa kanza lya kujilo, pfipfila umleke yakutowe kanza lya kumoso. ");
INSERT INTO ruf_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Na imunu ang'abama kukughala kune libaratsa ili asole lighwanda lyako, mleke asole na likoti lyako pfipfila. ");
INSERT INTO ruf_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ka imunu kokubama umghalile mtsigho ghwake kwa utali wa chilomita imwe, umghalile kwa chilomita mbili. ");
INSERT INTO ruf_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Umwing'e ayula iyokulomba, na ayula iyobama kukukopa uleke kumwima. ");
INSERT INTO ruf_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Muhulika tsailongighwa, ‘Mnoghele miyagho, na umhile mwihile wako.’ ");
INSERT INTO ruf_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Lekeni nene nowalongelani, muwanoghele iwehile wenu na muwalombele awala iwomdununzani, ");
INSERT INTO ruf_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ili muwe iwana wa Aba wenu iyali kulanga. Kwaapfila litsuwa lyake lyowamwemwesela iwanu iwehile na iwanu iwanoghile, naye kowatowela imvula iwanu iwanoghile na iwanu iwehile. ");
INSERT INTO ruf_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ka mwowanoghela iwanu wala iwomnoghelani mwemwe waliheka, mtsopata ghweko lyachi? Apfi iwasola kodi ng'awotenda pfipfo bae? ");
INSERT INTO ruf_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Na ka mwowalamsa ndughu tsenu waliyeka, mtenda choni chikulu kubita iwanu wangi? Angu iwanu ing'awommanya Imulungu ng'awotenda pfipfo bae? ");
INSERT INTO ruf_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Muwe watimilifu, ka Aba wenu iyali kulanga pfayali mtimilifu. ");
INSERT INTO ruf_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Mwalangitse, mleke kutenda ghanoghile hambele he iwanu ili wamwoneni. Mng'atenda apfo, ng'amtsopata ghweko bae kulawa kwa Aba wenu iyali kulanga. ");
INSERT INTO ruf_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Apfo hauweng'a iwahingwa chinu chochose, uleke kwilangusa kwe iwanu. Uleke kutenda ka wang'enye pfawotenda mne tsing'anda tse ukulombela na mne tsinzila, ili iwanu wawatoghole. Nowalongelani ghendo, ma wabokela ghweko lyawo lyose. ");
INSERT INTO ruf_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Lekeni ghweghwe haumwapfila mhingwa, ghumoko ghwako ghwa kumoso ghuleke kumanya achila ichitenda ghumoko ghwako ghwa kujilo. ");
INSERT INTO ruf_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ulapfe chinyelenyele. Na Aba wako iyakona ighafisike, katsokughweka. ");
INSERT INTO ruf_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Na hamlomba, mleke kwighala ne iwang'enye! Kwaapfila wawo wonoghela kwima mne tsing'anda tse ukulombela na mnzila ili iwanu wawone. Nowalongelani ghendo, ma wabokela ghweko lyawo lyose. ");
INSERT INTO ruf_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Lekeni haulomba, wingile mne chiheleto chako, uhinde libani lyako, umlombe Aba wako yang'akoneka. Kuya Aba wako iyakona aghala ighapfisike, katsokughweka. ");
INSERT INTO ruf_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Hamlomba, mleke kulonga chaka ka iwanu ing'awommanya Imulungu pfowotenda. Kwaapfila wopfikitsa imilungu yawo itsowahulika kwa mbuli tsawo nyingi. ");
INSERT INTO ruf_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Apfo mleke kwighala nawo. Kwaapfila Aba wenu komanya achila chambama ng'ana mumlombe bae. ");
INSERT INTO ruf_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Lekeni mwemwe mlombe apfi, ‘Aba wetu yuli kulanga, Taghwa lyako litunyighwe, ");
INSERT INTO ruf_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Undewa wako utse ghaubama ghatendeke mne isi ka kulanga. ");
INSERT INTO ruf_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Utwing'e leloli ichijo chetu cha chila litsuwa, ");
INSERT INTO ruf_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Utuleghusile ghamatotso ghetu, ka twetwe pfatuwaleghusila awala iwatutendile ghamatotso. ");
INSERT INTO ruf_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Uleke kutwingitsa mne ghamaghetso, ila utukombole na ayula Yehile. Kwaapfila ghamatsuwa ghose, ukulu una ghweghwe na ingupfu na utunitso. Amina.’ ");
INSERT INTO ruf_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Mng'awaleghusila iwanu ghamatotso ghawo, na Aba wenu iyali kulanga pfipfila katsowaleghusila ghamatotso ghenu. ");
INSERT INTO ruf_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Lekeni ka ng'amuwaleghusila bae iwanu ghamatotso ghawo, naye Aba wenu iyali kulanga ng'atsowaleghusila bae ghamatotso ghenu. ");
INSERT INTO ruf_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Hamfunga ukuja, mleke kwighala ne iwang'enye iwotenda pfihanga pfawo ka wana usungu ili woneke wafunga ukuja. Nowalongelani ghendo, ma wabokela ghweko lyawo. ");
INSERT INTO ruf_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Lekeni haufunga ukuja, ubake ghamafuta mwitwi mwako na uchihopfughe chihanga chako, ");
INSERT INTO ruf_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ili iwanu waleke kumanya ka kufunga, ila yamanye Aba wako yaliyeka yang'akoneka. Na Aba wako iyakona ighapfisike katsokughweka. ");
INSERT INTO ruf_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Mleke ukwika tsimali tsenu muisi, amwo iwang'onyo ne ing'angagha pfotsihinya, na iwabapfi wobomola ne ukwiba. ");
INSERT INTO ruf_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Lekeni mwike tsimali tsenu kulanga, ako ing'angagha ne iwang'onyo ng'awotsihinya bae, ne iwabapfi ng'awodaha bae kubomola ne ukwiba. ");
INSERT INTO ruf_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kwaapfila hala hane tsimali tsako, ghumoyo ghwako ghutsokala baho. ");
INSERT INTO ruf_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Tsinenge tsitso ichitasa cha lukuli. Ka nenge tsako tsinogha, lukuli lwako lwose lutsakuwa mne ghumwanga. ");
INSERT INTO ruf_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Lekeni ka tsinenge tsako tsiha, lukuli lwako lwose lutsakuwa mchisi. Apfo ka ghumwanga ighuli mghati mwako ghwa ichisi, acho ambe chisi chikulu! ");
INSERT INTO ruf_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Haduhu imunu iyodaha kuwatumikila iwatwatsa weli, kwaapfila katsomhila yumwe na kumnoghela yungi, au katsomuwinza yumwe na kumbetsa yungi. Ng'amdaha bae kumtumikila Imulungu na tsimali. ");
INSERT INTO ruf_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Apfo nowalongelani, mleke kusumbukila ipfijo au pfokunwa pfambama ili mkale waghima. Wala ng'uli tsenu tsitsopfala choni. Angu ughima ng'aunoghile bae kubita ichijo? Na lukuli ng'alunoghile bae kubita lighwanda? ");
INSERT INTO ruf_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mlole wapfideghe iwali kulanga, ng'awohanda bae, wala ng'awopfuna bae, wala kwika mkano na Aba wenu iyali kulanga kowaghutitsa! Angu mwemwe ng'amnoghile bae kubita wapfideghe? ");
INSERT INTO ruf_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Yuhi mna mwemwe kwa kwisumbula imwenyegho kodaha ukwongetsa utali wake? ");
INSERT INTO ruf_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ule lelo mwosumbukila ghamaghwanda? Mghalole ghamaluwa ighali kumghunda pfaghokula. Ng'aghosang'ana bae wala ukwitendela ghamaghwanda. ");
INSERT INTO ruf_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Na nene nomlongelani, hata Selemani imwenyegho mne tsimali tsake tsose, ng'apfasighwe bae pfinoghile ka luwa limwe mna ghamaluwa ghano. ");
INSERT INTO ruf_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Lelo ka Imulungu koipfatsa apfo imitsani ye kwibagho, leloli yabaha, na ilupfi yakwasighwa mmoto, angu Imulungu ng'atsompfatsani mwemwe bae? Pfii mwemwe yamtoghola chidogho! ");
INSERT INTO ruf_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Apfo mleke kwisumbula, mwolonga, ‘Tutsakuja choni?’ au ‘Tutsakunwa choni?’ au ‘Tutsopfala choni?’ ");
INSERT INTO ruf_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kwaapfila iwanu ing'awammanyile Imulungu woghasumbukila agho ghose, na Aba wenu iyali kulanga komanya ka mwoghabama agho ghose. ");
INSERT INTO ruf_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Lekeni tanu muubame undewa we Imulungu, na mtende aghala ghobama Imulungu, naye katsomwing'ani agho ghose. ");
INSERT INTO ruf_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Apfo mleke kughasumbukila gha ilupfi, kwaapfila gha ilupfi ghatsesumbukila ghenyegho. Chila litsuwa lyesumbukila lyenyegho. ");
INSERT INTO ruf_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Mleke kuwahigha iwanu wangi, hela namwe mtsohighighwa ne Imulungu, ");
INSERT INTO ruf_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","kwaapfila pfamuwahigha iwanu wangi, namwe pfipfila mtsohighighwa pfipfo, na chamuwahighila iwanu wangi, Imulungu katsotumila chicho kuwahighani mwemwe. ");
INSERT INTO ruf_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Ule ulola chibanzi ichili mnenge mwa ndughu yako, na baho ng'ulyona bae libiki ilili mnenge mwako? ");
INSERT INTO ruf_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Apfi udahatse kumlongela ndughu yako, ‘Uleke nikulapfe chibanzi ichili mnenge mwako,’ aku mnenge mwako mwenyegho mna libiki? ");
INSERT INTO ruf_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kwa mng'enye ghweghwe! Tanu ulapfe libiki ilili mnenge mwako, kuya kutsodaha kulola pfinoghile na kulapfa chibanzi ichili mnenge mwa ndughu yako. ");
INSERT INTO ruf_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Mleke kuweng'a iwambwa achila ichideghete hela watsomhundukilani na kuwaluma. Mleke kuwasila iwangubi lulu tsenu hela watsosibayugha kwa maghulu ghawo. ");
INSERT INTO ruf_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Mlombe, namwe mtsakwing'ighwa, mbame namwe mtsopata, mgong'onde libani, namwe mtsopfughulilighwa. ");
INSERT INTO ruf_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kwaapfila imunu wowose iyolomba katsobokela, na imunu wowose iyobama katsopata na ayula iyoghong'onda katsopfughulilighwa libani. ");
INSERT INTO ruf_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Angu aba wachi kuna mwemwe, imwanaghe ang'amlomba chighate, komwing'a libwe? ");
INSERT INTO ruf_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Au ang'amlomba isomba, komwing'a inzoka? ");
INSERT INTO ruf_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ka mwemwe yamwihile mwomanya kuweng'a iwanenu aghala ighanoghile, angu Aba wenu iyali kulanga ng'atsakongetsa bae kuweng'a aghala ighanoghile awala iwomlomba! ");
INSERT INTO ruf_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Muwatendele iwanu wangi aghala ghambama mwemwe wamtendeleni, kwaapfila Ghamalaghitso gha Musa ne pfitabu pfa manabii pfolonga pfipfo. ");
INSERT INTO ruf_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Mwingile kwa kubitila libani sisili. Kwaapfila libani lye ukwingilila kutsimu ghatsi na iwanu iwobitila inzila ayo wa wengi. ");
INSERT INTO ruf_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Lekeni libani lya ughima dodo na inzila iilongotsa ako ya sisili, ne iwanu iwoyona nzila ayo wadodo. ");
INSERT INTO ruf_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Mwalangitse na manabii we ughutsu. Womtsilani aku wakoneka kwa kunze ka iwang'olo, lekeni mghati mwawo weghala ne wambwa wa kumuhulo. ");
INSERT INTO ruf_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mtsowamanya kwa ghamatunda ghawo. Angu iwanu wobawa fulu mne tsimiwa, au wobawa ng'owo mne mbighili? ");
INSERT INTO ruf_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Pfipfila chila mbiki ighunoghile ghwakweleka ghamatunda ghanoghile, na mbiki ghwihile ghwakweleka ghamatunda ghehile. ");
INSERT INTO ruf_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Na mbiki ighunoghile ng'aghukweleka bae ghamatunda ghehile, na mbiki ghwihile ng'aghukweleka bae ghamatunda ghanoghile. ");
INSERT INTO ruf_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Chila mbiki ing'aghukweleka ghamatunda ghanoghile ghwoghanighwa na kwasighwa mmoto. ");
INSERT INTO ruf_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Apfo mtsowamanya manabii wa ughutsu kwa ghamatunda ghawo. ");
INSERT INTO ruf_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Si chila imunu iyonikema ‘Mtwatsa, Mtwatsa,’ katsokwingila mne undewa wa kulanga, ila awala waliyeka iwotenda aghala ghayobama Aba wangu iyali kulanga. ");
INSERT INTO ruf_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Mne litsuwa alyo, iwanu wengi watsonongela ‘Mndewa, Mndewa! Kwa taghwa lyako tsatuwapetela iwanu usenga we Imulungu, kwa taghwa lyako tsatuwalapfa iwanu pfinyamkela na kutenda ipfinzonza!’ ");
INSERT INTO ruf_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Kuya nitsowalongela, ‘Mbe, mwemwe simmanyileni bae. Mlawe kuna nene, mwemwe iwanu mwihile!’ ");
INSERT INTO ruf_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Apfo imunu wowose iyotegheletsa mbuli tsangu na kutsitenda, ayo keghala ne imunu iyakengele, yatsengile ing'anda yake mne bambalawe. ");
INSERT INTO ruf_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Imvula itowa, ghamatsi ghamema, libeho liduma, liitowa ing'anda ila. Lekeni ng'aighwile bae kwaapfila lukwambatsa lwake tsalutsengighwa mne bambalawe. ");
INSERT INTO ruf_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Lekeni imunu wowose iyotegheletsa mbuli tsangu aku kolema kutsitenda, ayo keghala ne imunu mbotsi, iyatsengile ing'anda yake mne msanga. ");
INSERT INTO ruf_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Imvula itowa, ghamatsi ghamema, libeho liduma liitowa ing'anda ila, nayo ighwa kwa ngupfu.” ");
INSERT INTO ruf_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu hayamalitse kulonga agho ghose, mtingano ghwose tsaghukangawala kwa ghamalangulitso ghake, ");
INSERT INTO ruf_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","kwaapfila tsayang'ali yowalangulitsa ka imunu yane ukulu, na si ka iwalangulitsi wawo wa Ghamalaghitso. ");
INSERT INTO ruf_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu hayahulumke mchidando, mtingano mkulu we iwanu tsaghumuwinza. ");
INSERT INTO ruf_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Imunu yumwe yane ukoma kamghendela, katowa ghamaghoti hambele hake, kamlongela, “Imtwatsa ung'abama, kwodaha kunenda nideghete.” ");
INSERT INTO ruf_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu kagholosa ghumoko ghwake, kamkinda imunu ayo. Kalonga, “Nobama, udeghete!” Bahala imunu ayo kahona. ");
INSERT INTO ruf_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kuya Yesu kamlongela, “Tegheletsa! Uleke kumlongela imunu wowose, ila ughende wikelanguse kwa mlapfa nambiko, kuya ulapfe inambiko iyalaghitse Musa, ka ukalangama kwe iwanu wose ka ghweghwe kuhona.” ");
INSERT INTO ruf_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu hayengile Kaperinaumu, imkulu yumwe we asikali wa Roma kamghendela, kamlomba yamwapfile. ");
INSERT INTO ruf_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Kamlongela, “Imtwatsa, imtumwa wangu kawasa ukae, kaholola kuya koghula sideke.” ");
INSERT INTO ruf_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu kamlongela, “Nitsoghenda kumhonetsa.” ");
INSERT INTO ruf_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Imkulu ayo kamwidika, “Imtwatsa nene sinoghile bae ghweghwe kwingila mng'anda mwangu, ila ulonge imbuli iliheka, imtumwa wangu katsohona. ");
INSERT INTO ruf_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kwaapfila hata nene yanilongotsighwa ne iwakulu wangi, nina asikali yaniwalongotsa. Nomlaghitsa yuno, ‘Ghenda!’ naye koghenda, nomlaghitsa ayula, ‘Utse!’ naye kakutsa. Nomlongela imtumwa wangu, ‘Tenda chinu achi!’ naye kotenda pfipfo.” ");
INSERT INTO ruf_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu hayahulike apfo kakangawala ghendo, kawalongela awala iwamuwinzile, “Nowalongelani, sina mbone bae imunu wowose mne isi ya Isiraeli iyotoghola pfino. ");
INSERT INTO ruf_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nowalongelani ghendo, iwanu wangi watsakutsa kulawa ubali wa kwalilawila litsua na ubali wa kwalikuswela litsua, nawo watsokala mne chihungo hamwe na Abrahamu, Isaka na Yakobu mne undewa wa kulanga. ");
INSERT INTO ruf_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Lekeni awala iwabamighwe wawe mne undewa we Imulungu watsakwasighwa kunze, mne ichisi, ako watsolila na kughegheda ghamatsino.” ");
INSERT INTO ruf_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kuya Yesu kamlongela imkulu yula, “Ghenda ukaye, na achila chautoghole chitsotendeka.” Kuya saa iila imtumwa wake kahona. ");
INSERT INTO ruf_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu hayapfikile ukaye kwa Petiri, kampfika mai wake mkwe Petiri kawasa mlusatsi, koghula lihoma. ");
INSERT INTO ruf_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Kamkinda ghumoko ghwake na lihoma limlawa, naye kenuka kandusa kumtumikila. ");
INSERT INTO ruf_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nemihe haipfikile, iwanu wamghalila Yesu wanu wengi wane pfinyamkela, Yesu kawalapfa pfinyamkela kwa kulonga imbuli iliheka, kuya kawahonetsa iwatamu wose, ");
INSERT INTO ruf_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ili imbuli iyailongile nabii Isaya itimile, “Tsakasola maghayo ghetu na kabapa matamu ghetu.” ");
INSERT INTO ruf_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu hawonile mtingano mkulu ghwe iwanu ghumtsunguluka, kawalaghitsa wanang'ina wake waloke kumwambu kwe tsimbu lya. ");
INSERT INTO ruf_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Kuya imlangulitsi yumwe wa Ghamalaghitso kamghendela, kalonga, “Mlangulitsi, nitsokuwinza kokose kwaughenda.” ");
INSERT INTO ruf_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu kamwidika, “Iwambwa wa kumuhulo wana tsimango, na pfideghe iwali mlanga wana pfibali, lekeni imwana we imunu kahela hanu ha ukuwasitsa litwi lyake.” ");
INSERT INTO ruf_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Imwanang'ina wake yumwe kamlongela, “Mndewa, undeke tanu mbuke ukaye ng'amtsike aba wangu.” ");
INSERT INTO ruf_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Lekeni Yesu kamlongela, “Uniwinze, waleke iwanu iwafile wawatsike iwanu wawo iwafile.” ");
INSERT INTO ruf_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Kuya Yesu kengila mne mnumbwi, na iwanang'ina wake wamuwinza. ");
INSERT INTO ruf_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Bahala ilawila inyahemu ng'ulu mne tsimbu na ghamatsi ghang'ali ghakwingila mne mnumbwi, lekeni Yesu tsakawasa. ");
INSERT INTO ruf_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Iwanang'ina wake wamghendela wamlamsa, walonga, “Imtwatsa, utukombole twotsama!” ");
INSERT INTO ruf_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Kawedika, “Mwemwe yamtoghola chidogho, ule mpfuka?” Kuya kenuka, kaikembela inyahemu na ghamawimbi, baho tsimbu linyamala tulu ghendo. ");
INSERT INTO ruf_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Iwanu wose tsawakangawala, weghutsa, “Angu ayu munu wachi? Hata libeho na ghamawimbi pfose pfomuhulikitsa!” ");
INSERT INTO ruf_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu hayapfikile kumwambu, mne isi ya Gerasi ketingana ne iwanu weli wane pfinyamkela wolawa mne tsikabuli. Iwanu awo tsawakala wakali sideke, kuduhu imunu iyadahile kubita inzila ayo. ");
INSERT INTO ruf_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Bahala wakemelela, “Angu utubamila choni, ghwee Imwana we Imulungu. Pfii kutsa kutudununza ng'ana ichipindi chetu chipfike?” ");
INSERT INTO ruf_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Habehi ne hanu aho, tsakukala ne iwangubi wengi wakuja. ");
INSERT INTO ruf_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Pfinyamkela awo wamlomba Yesu, “Ung'atulapfa, utuleke twingile mne iwangubi wala.” ");
INSERT INTO ruf_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Kawalongela, “Haya laweni!” Baho wawalawa iwanu awo, wawengila iwangubi, na iwangubi wose watsumila mne muhulumko mkulu, wengila mne tsimbu na wose wafila mmatsi. ");
INSERT INTO ruf_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Iwadimi we iwangubi awo tsawatsuma mne ghumji. Hako wawalongela aghala ghose na achila ichiwalawilile iwanu wane pfinyamkela. ");
INSERT INTO ruf_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kuya iwanu wose waghenda kwitingana na Yesu. Na hawamwonile, wamlomba yoke mne isi yawo. ");
INSERT INTO ruf_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu kengila mne mnumbwi, kaloka kumwambu koya mne ghumji ghwake. ");
INSERT INTO ruf_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Iwanu wangi wamghalila imunu iyaholole iyawasile mne chilagho. Yesu honile ukutoghola kwawo, kamlongela imunu yula iyaholole, “Ughumighwe ghumoyo mwanangu, nzambi tsako tsileghusighwa.” ");
INSERT INTO ruf_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Bahala iwalangulitsi wangi wa Ghamalaghitso tsawelongela. “Imunu yuno komligha Imulungu.” ");
INSERT INTO ruf_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu tsakamanya achila chawang'ali wakwalangula. Apfo kawaghutsa, “Ebali mkwalangula ghehile mne imimoyo yenu? ");
INSERT INTO ruf_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Chihi chibewe, kulonga, ‘Nzambi tsako tsileghusighwa,’ au kulonga, ‘Winuke ughende’? ");
INSERT INTO ruf_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Lelo nobama mmanye ka Imwana we Imunu kana uwetso muisi wa kuwaleghusila wanu nzambi.” Kuya kamlongela imunu iyaholole, “Winuke, usole chilagho chako, uke ukaye!” ");
INSERT INTO ruf_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Baho imunu yula kenuka, koka ukaye. ");
INSERT INTO ruf_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Iwanu hawonile pfino tsawapfuka, wamtunya Imulungu, iyaweng'ile iwanu uwetso awo. ");
INSERT INTO ruf_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu tsakoka hanu aho, na hayang'ali yoghenda, kamwona imsola kodi, iyakemighwe Matei. Kakala hanu ha ukulihila kodi, Yesu kamlongela, “Niwinze,” Matei kenuka kamuwinza. ");
INSERT INTO ruf_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesu hayang'ali yakuja ichijo cha nemihe mng'anda, iwasola kodi wengi na iwanu wehile watsa na ukuja naye hamwe na iwanang'ina wake. ");
INSERT INTO ruf_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mafarisayo hawonile apfo, wawaghutsa iwanang'ina wake, “Ule mlangulitsi wenu kakuja ne iwanu wano?” ");
INSERT INTO ruf_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu hayahulike apfo, kawalongela, “Si iwanu waghima bae iwobama mghanga, ila iwatamu iwo iwobama mghanga. ");
INSERT INTO ruf_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Lekeni mghende mkelangulitse mana ye imbuli ino, ‘Nobama libatsi, wala si inambiko bae.’ Kwaapfila sitsile bae kuwakema iwanu wanoghile, ila iwanu wehile.” ");
INSERT INTO ruf_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Iwanu iwamuwinzile Yohane Mbatitsa tsawamghendela Yesu, wamghutsa, “Ule twetwe na Mafarisayo twofunga, lekeni iwanang'ina wako ng'awofunga bae?” ");
INSERT INTO ruf_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu kawedika, “Apfi yodahika iwahenza iwakemighwe mne chihungo che ukukwela walile aku imunu iyokwela yang'ali nawo? Mbe! Ng'aidahika bae, litsuwa litsakutsa imunu iyokwela katsosolighwa kulawa mna wawo, baho watsofunga. ");
INSERT INTO ruf_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Iwanu ng'awochika bae ichalaka che lighwanda lya sambi mne lighwanda lya ghumwande, kwaapfila ichilaka acho chitsolidegha lighwanda lya ghumwande, na hala ihadegheke hatsakongetseka. ");
INSERT INTO ruf_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Pfipfila kuduhu imunu yoghuma dipfai ya sambi mne pfibuyu pfe ghumwande, ang'atenda apfo, pfibuyu apfo pfitsotulika na dipfai itsakwitika. Ila dipfai ya sambi yoghumighwa mne pfibuyu pfa sambi, kuya pfose pfibili pfokala ghoya.” ");
INSERT INTO ruf_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Hayang'ali yolonga apfi, imkulu wa Wayahudi kamghendela, kamtowela ghamaghoti, kalonga, “Mwanangu kafa sambisambi, lekeni utse umwikile ghumoko katsohona.” ");
INSERT INTO ruf_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesu kenuka, koka naye, na iwanang'ina wake woka hamwe naye. ");
INSERT INTO ruf_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ipinga yumwe iyang'ali yoghula utamu wa ukulawa idamu kwe imiyaka kumi na mili kamtsila Yesu kuchughu, kakinda imindo ye ghwanda lyake. ");
INSERT INTO ruf_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Tsakelongela mwenyegho, “Ning'akinda lighwanda lyake, nitsohona.” ");
INSERT INTO ruf_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu kahunduka kamwona ipinga ayo, kamlongela, “Mwanangu, ughumighwe ghumoyo! Ukutoghola kwako kukuhonetsa.” Bahala ipinga hayo kahona. ");
INSERT INTO ruf_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kuya Yesu tsakapfika mng'anda mwa imkulu ayo. Na hayawonile awala iwotowa pfimbeta na mtingano we iwanu iwolila, ");
INSERT INTO ruf_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","kawalongela, “Mlawe kunze, imwana ng'afile bae, ila kawasa!” Lekeni wawo tsawamseka. ");
INSERT INTO ruf_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Mtingano ghwe iwanu haghulawile kunze, Yesu kengila mghati, kamkinda ghumoko, bahala kenuka. ");
INSERT INTO ruf_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Mbuli ino yenela mne isi tsose. ");
INSERT INTO ruf_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu tsakoka hanu hala, hayang'ali mzila pfifita weli wamuwinza, aku wokemelela, “Utwonele libatsi, Imwana wa Daudi!” ");
INSERT INTO ruf_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu hayengile mng'anda, pfifita wala weli wamghendela, Yesu kawaghutsa, “Apfi mwotoghola ka nene nodaha kuwahonetsa?” Wedika, “Ona, Imtwatsa!” ");
INSERT INTO ruf_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kuya katsikinda nenge tsawo, kalonga, “Iwe ka pfamtoghola!” ");
INSERT INTO ruf_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Nenge tsawo tsidaha kwona, Yesu kawakanya ghendo, “Mwalangitse, imunu wowose yaleke kumanya agha ghose.” ");
INSERT INTO ruf_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Lekeni woka, watsipwililisa mbuli tsake mne isi ila yose. ");
INSERT INTO ruf_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Hawang'ali wakuka, iwanu wamghalila Yesu imunu chibubu yane ichinyamkela. ");
INSERT INTO ruf_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Bahala ichinyamkela hayalapfighwe, Imunu yula chibubu kandusa kulonga. Iwanu wose tsawakangawala walonga, “Ng'ana chilawile bae chinu ka chino mne isi ya Isiraeli!” ");
INSERT INTO ruf_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Lekeni Mafarisayo walonga, “Imkulu we pfinyamkela iye iyomwing'a Yesu uwetso wa kulapfa pfinyamkela.” ");
INSERT INTO ruf_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu tsakaghenda mne tsiisi na kaye tsose, kalangulitsa mne tsing'anda tsawo tse ukulombela, kawapetela Imbuli Inoghile ya Undewa we Imulungu na kuwahonetsa iwanu chila utamu na maghayo ghose. ");
INSERT INTO ruf_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yesu haghwonile mtingano ghwe iwanu, kawonela libatsi kwaapfila tsawakala wepfa na wapwililika ka iwang'olo iwalihela imdimi. ");
INSERT INTO ruf_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kuya kawalongela iwanang'ina wake, “Ghamapfuno mengi, lekeni iwatenda sang'ano wadodo. ");
INSERT INTO ruf_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Apfo mumlombe Imtwatsa we ghamapfuno, yawaghale iwatenda sang'ano mne mghunda ghwake.” ");
INSERT INTO ruf_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu tsakawakema hamwe iwanang'ina wake kumi na weli, kaweng'a uwetso wa ukulapfa pfinyamkela na kuhonetsa utamu na maghayo ghose. ");
INSERT INTO ruf_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Aghano igho ghamataghwa ghe iwatumighwa kumi na weli, wa mwanduso; Simoni iyakemighwe Petiri na ndughu yake Andereya, Jakobu na ndughu yake Yohane, iwana wa Sebedayo. ");
INSERT INTO ruf_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipi na Batalomeyo, Tomasi na Matei iyakalile imsola kodi; na Jakobu imwana wa Alifayo, na Tadei, ");
INSERT INTO ruf_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simoni Mkananayo na Yuda Isikarioti iyamsaliti Yesu. ");
INSERT INTO ruf_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu tsakawatuma Iwatumighwa awo, kawalaghitsa, “Mleke kughenda kwe iwanu ing'awammanyile Imulungu bae, au mne isi tse Wasamariya. ");
INSERT INTO ruf_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ila mghende kwe iwanu we isi ya Isiraeli yawaghile ka iwang'olo. ");
INSERT INTO ruf_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Hamghenda, muwapetele mbuli ino, ‘Undewa we Imulungu wa habehi.’ ");
INSERT INTO ruf_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Muwahonetse iwatamu, muwatsilihule iwafile, muwahonetse wakoma, mlapfe pfinyamkela. Mwemwe mbokela hela, apfo lapfeni hela. ");
INSERT INTO ruf_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mleke kusola nzahabu, pfetsa, shaba mne pfibindo pfenu. ");
INSERT INTO ruf_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mleke kusola mkoba we ghumwanza, wala ghamaghwanda meli, wala imikwabatsa, wala ing'weku. Kwaapfila mtenda isang'ano kobamighwa yeng'ighwe maliho ghake. ");
INSERT INTO ruf_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Hamkwingila mne isi au kaye yoyose, mbame imunu yanoghile, mkale mng'anda amwo mbaka hamkuka. ");
INSERT INTO ruf_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Hamkwingila mng'anda, mlonge, ‘Mkale tseghamba.’ ");
INSERT INTO ruf_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Wenye kaye wang'ambokelani, nawo watsokala tseghamba, lekeni ka ng'awombokelani bae, mwemwe mtsokala tseghamba. ");
INSERT INTO ruf_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Imunu wowose ang'alema kuwabokela, au kutegheletsa mbuli tsenu, hamkuka mkung'use litimbwisi ilili mmaghulu mwenu. ");
INSERT INTO ruf_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nowalongela ghendo mne litsuwa lya kuhigha, itsakuwa ng'apfu kwa Sodoma na Gomola, kubita kwe isi ayo. ");
INSERT INTO ruf_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Nowatuma ka iwang'olo iwali mghati mwe wambwa wa kumuhulo. Apfo mwobamighwa mkengele ka nzoka na muhole ka njiwa. ");
INSERT INTO ruf_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mwalangitse ne iwanu, kwaapfila wasowaghala mne mabalatsa, kuya watsowafapula mne tsing'anda tse ukulombela. ");
INSERT INTO ruf_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Mtsoghalighwa hambele he iwakulu ne iwandewa kwaajili ya nene, mpete Imbuli Inoghile kuna wawo na kwe iwanu ing'awammanyile Imulungu. ");
INSERT INTO ruf_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Hamtsoghalighwa mne libalatsa, mleke kwalangula mtsolonga choni, kwaapfila mtsakwing'ighwa gha ukulonga mne chipindi chicho, ");
INSERT INTO ruf_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","kwaapfila si mwemwe bae yamlonga, ila Ghumuhe wa Aba wenu katsolonga kubitila mwemwe. ");
INSERT INTO ruf_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ndughu katsomsaliti ndughu yake yakomighwe, na aba katsomsaliti imwanaghe, nawo iwana watsowasaliti aba tsawo na kuwakoma. ");
INSERT INTO ruf_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Iwanu wose watsowahila kwaajili ya taghwa lyangu, lekeni ayula iyodudumila mbaka utsighilo katsokombolighwa. ");
INSERT INTO ruf_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Hamdununzighwa mne isi imwe, mtsumile isi ingi, nowalongelani ghendo ng'amtsomalitsa bae isang'ano yenu mne isi tsose tsa Isiraeli ng'ana Imwana we Imunu yatse. ");
INSERT INTO ruf_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Mwanang'ina ng'ombita bae imlangulitsi wake, wala imtumwa ng'ombita bae imtwatsa wake. ");
INSERT INTO ruf_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Yotosha imwanang'ina kwighala ne imlangulitsi wake, na mtumwa kwighala ne imtwatsa wake. Ka imbala we ing'anda kokemighwa Belisebuli, angu iwanu iwali mng'anda mwake ng'awatsokemighwa mataghwa ghehile ng'ani? ");
INSERT INTO ruf_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Apfo mleke kupfuka iwanu. Chochose ichighubikighwe, chitsoghubulighwa na chochose ichipfisighwe chitsakoneka. ");
INSERT INTO ruf_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Achila choniwalongelani mchisi, mwemwe mchilonge mne ghumwanga. Achila chamuhulika chinyelenyele, mwemwe mchikemelele kwa kwima mchiswili. ");
INSERT INTO ruf_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mleke kuwapfuka awala iwokoma lukuli ila ng'awodaha bae kuukoma muhe, ila mumpfuke ayula iyodaha kuhinya lukuli na muhe mne ghumoto wa jehanamu. ");
INSERT INTO ruf_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Apfi iwasolwe weli ng'awoghulighwa kwa sendi imwe bae? Lekeni kuduhu yumwe iyolaghala hasi ka Aba wenu ng'abamile bae. ");
INSERT INTO ruf_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Hata tsimvili itsili mwitwi mwenu tsipetighwa. ");
INSERT INTO ruf_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Apfo mleke kupfuka, mwemwe mnogha kubita iwasolwe awo! ");
INSERT INTO ruf_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Imunu wowose iyonitoghola nene hambele he iwanu, nene pfipfila nitsomtoghola hambele ha Aba wangu yali kulanga. ");
INSERT INTO ruf_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Lekeni imunu wowose iyonibela nene hambele he iwanu, na nene nitsombela hambele ha Aba wangu yali kulanga. ");
INSERT INTO ruf_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Mleke kupfikitsa ka nene nitsa kuwatenda iwanu wakale tseghamba muisi. Mbe! Sitsile bae kuwatenda iwanu wakale tseghamba, ila nighala lipanga. ");
INSERT INTO ruf_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Kwaapfila nitsa kuwatenda mwisonge, imunu na aba wake, imwana na mai wake, mwalipfala na mwalipfala wake. ");
INSERT INTO ruf_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Na iwehile we imunu watsokuwa iwanu wa mkaye mwake. ");
INSERT INTO ruf_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Imunu wowose iyomnoghela aba na mai wake kubita nene, ayo ng'oninoghela bae. Na imunu iyowanoghela iwanaghe kubita nene, ayo ng'oninoghela bae. ");
INSERT INTO ruf_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Na imunu wowose yang'osola ghumsalaba ghwake na kuniwinza, ayo ng'oninoghela bae. ");
INSERT INTO ruf_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Imunu wowose iyobama ughima wake katsowaghisa, na wowose iyowaghisa ughima wake kwaajili ya nene, katsowona. ");
INSERT INTO ruf_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ayula iyowabokelani mwemwe, konibokela nene, na ayula yonibokela nene, kombokela ayula iyanitumile. ");
INSERT INTO ruf_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Imunu wowose iyombokela nabii kwaapfila yeye nabii, ayo katsobokela ghweko lya nabii, na imunu wowose iyombokela imunu iyanoghile kwaapfila yeye kanogha, katsobokela ghweko lya imunu iyanoghile. ");
INSERT INTO ruf_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nowalongelani ghendo, imunu wowose iyomwing'a chikombe che ghamatsi ighopfegha imunu yumwe we iwadodo wano kwaapfila yeye ka yumwe we iwanang'ina wangu, katsopata ghweko lyake.” ");
INSERT INTO ruf_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu hayamalitse kuwalangulitsa iwanang'ina wake kumi na weli, koka hanu aho kaghenda kulangulitsa na kuwapetela iwanu mne imiji ya Galilaya. ");
INSERT INTO ruf_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yohane iyakalile mchifungo hayahulike aghala ghayatendile Kiristu, kawatuma iwanang'ina wake wamghutse, ");
INSERT INTO ruf_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Apfi ghweghwe kwa ayula iyalongile Yohane kwakutsa, au tumlolele yungi?” ");
INSERT INTO ruf_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu kawedika, “Muye na mumlongele Yohane agha ghamuhulika na ghamghona, ");
INSERT INTO ruf_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ipfifita wakona, ipfimbete woghenda, na wane ukoma wodeghetetsighwa, ipfitsiwi wohulika, iwafile wotsilihuka, na iwahighwa wopetelighwa Imbuli Inoghile. ");
INSERT INTO ruf_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kabweda imunu yula yang'ombonela nene mashaka!” ");
INSERT INTO ruf_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Iwanu iwamuwinzile Yohane hawang'ali wakuka, Yesu kandusa kuwalongela iwanu mbuli tsa Yohane, “Hamghendile kunyika, mghendile kulola choni? Lutsani pfaluhighisighwa na libeho? ");
INSERT INTO ruf_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ka si pfipfo bae, mghendile kulola choni? Imunu iyapfalile ghamaghwanda ghanoghile? Bae, awala iwopfala ghamaghwanda ghanoghile wokala mne tsing'anda tse iwandewa. ");
INSERT INTO ruf_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Kuya tsamghendile kulola choni? Inabii? Ona, nowalongelani, mmwona mkulu kubita nabii. ");
INSERT INTO ruf_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ayuno iyo yuyo iwamwandike mne Ghamaandiko Mahenzeluka. ‘Nitsomtuma msenga wangu akulongolele, katsokwandalila inzila yako.’ ");
INSERT INTO ruf_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nowalongelani ghendo, mne iwanu wose iwelekighwe ne iwapinga, kuduhu wowose iyali mkulu kubita Yohane Mbatitsa, pfipfila ayula iyali mdodo ghendo mne undewa wa kulanga, ka mkulu kubita yeye. ");
INSERT INTO ruf_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kulawa ghamatsuwa gha Yohane Mbatitsa mbaka sambi undewa wa kulanga wosolighwa kwa ingupfu, na iwanu wane ingupfu wouboka. ");
INSERT INTO ruf_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kwaapfila Ghamalaghitso gha Musa na manabii wose tsawalonga mbuli ya undewa mbaka ghamatsuwa gha Yohane. ");
INSERT INTO ruf_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Na ka mwobama kutoghola, Yohane iyo Eliya iyatsile. ");
INSERT INTO ruf_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Yane ghamaghutwi na yahulike! ");
INSERT INTO ruf_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Apfi iwanu wa ghamatsuwa ghano weghala na choni? Weghala ne iwana wadodo iwakalile kusoko, wowakema wayawo wolonga, ");
INSERT INTO ruf_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Tuwatowela pfimbeta, lekeni ng'ambighile bae! Tuwembila wila wa usungu, lekeni ng'amlilile bae!’ ");
INSERT INTO ruf_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Kwaapfila Yohane tsakatsa, ng'ajile bae wala ng'anwele, nawo tsawalonga, ‘Kana chinyamkela!’ ");
INSERT INTO ruf_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Imwana we imunu tsakatsa, kakuja na kakunwa, nawo walonga, ‘Mumlole imunu yuno, yane batsu na mpatika, sale tsake iwasola kodi na iwotenda ghehile.’ Lekeni ihekima ye Imulungu yoneka inogha kwa sang'ano tsake.” ");
INSERT INTO ruf_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Kuya Yesu kandusa kutsikembela isi tsila tsayatendile pfinzonza pfingi, kwaapfila ng'atsilekile nzambi bae. ");
INSERT INTO ruf_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Ghweghwe Kolasini kutsoghaya! Ghweghwe Betisaida kutsoghaya! Ka pfinzonza ipfitendeke kuna mwemwe, tsapfitendeka Tiro na Sidoni, iwanu wang'alekile nzambi tsawo kwa kupfala ghamaghunila na kwibaka lipfu. ");
INSERT INTO ruf_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nowalongeleni ghendo itsakuwa ng'apfu mne litsuwa lye ukuhigha kwe iwanu wa Tiro na Sidoni kubita kuna mwemwe! ");
INSERT INTO ruf_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Naghwe Kaperinaumu! Apfi kwobama winulighwe mbaka mlanga? Kutsohulumsighwa mbaka kutsimu. Ka pfinzonza ipfitendeke kuna mwemwe, pfitendeka Sodoma, isi ayo ing'akalile mbaka leloli! ");
INSERT INTO ruf_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Lekeni nowalongelani, mne litsuwa lya kuhigha, Imulungu katsoyonela libatsi isi ya Sodoma kubita mwemwe!” ");
INSERT INTO ruf_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Chipindi chicho Yesu tsakalonga, “Nokutunya ghwee Aba, Imtwatsa wa kulanga na isi kwaapfila kuwapfisa pfinu pfino iwanu wane ihekima na iwakengele, kuwaghubulila iwana wadodo. ");
INSERT INTO ruf_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ona, Aba wangu, apfi pfipfo pfaunoghelighwe. ");
INSERT INTO ruf_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Aba wangu kangaya pfinu pfose. Kuduhu iyommanya Imwana, ila Aba, na kuduhu iyommanya Aba, ila Imwana, na wowose yula Imwana iyobama kumghubulila. ");
INSERT INTO ruf_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Mtse kuna nene, mwemwe wose imdununzighwa ne imitsigho mitito, na nene nitsowatenda mbwihile. ");
INSERT INTO ruf_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Msole nira yangu, mwilangulitse kulawa kuna nene, kwaapfila nene nihola kuya na mwenyepfale we ghumoyo, namwe imimoyo yenu itsobwihila. ");
INSERT INTO ruf_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kwaapfila nira yangu ndeke, na mtsigho ghwangu mbewe.” ");
INSERT INTO ruf_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ghamatsuwa agho, Yesu tsayang'ali yobita mne imighunda ya uhemba mne litsuwa lya Sabato, iwanang'ina wake nzala tsaiwaluma, apfo wandusa kuhulula imikungwi ya uhemba, kuya waija. ");
INSERT INTO ruf_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mafarisayo hawonile apfo, wamlongela Yesu, “Lola, iwanang'ina wako wotenda chinu ichighomighwe mne litsuwa lya Sabato.” ");
INSERT INTO ruf_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesu kawedika, “Apfi ng'amsomile bae achila chayatendile Daudi, yeye na weyaghe hawakalile ne inzala? ");
INSERT INTO ruf_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Tsakengila mne ing'anda ye Imulungu. Yeye na weyaghe, kuya waja pfighate ipfilapfighwe kwe Imulungu, hata ka tsamwiko yeye na weyaghe kupfija, ila iwabamighwe kupfija iwo iwatambika wakulu waliyeka. ");
INSERT INTO ruf_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Angu ng'amsomile bae mne Ghamalaghitso gha Musa, watambika wakulu wolibetsa litsuwa lya Sabato mne ing'anda ye Imulungu, lekeni ng'awakwoneka ka watotsa? ");
INSERT INTO ruf_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Lelo, nomlongelani, hano hana iyali imkulu kubita lng'anda ye Imulungu. ");
INSERT INTO ruf_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ghamaandiko gholonga, ‘Nobama libatsi, na si nambiko bae.’ Mng'amanyile mbuli tsino tsolonga choni, mng'alekile kuwahigha iwanu iwalihela matotso. ");
INSERT INTO ruf_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kwaapfila Imwana we Imunu iyo Imtwatsa we litsuwa lya Sabato.” ");
INSERT INTO ruf_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu koka hanu aho, kengila mne ing'anda yawo ya ukulombela, ");
INSERT INTO ruf_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","baho tsakukala na imunu yumwe yane ghumoko ighuholole. Iwanu wangi wamghutsa Yesu, “Apfi ng'aighomighwa kumhonetsa imunu mne litsuwa lya Sabato?” Wamghutsa apfo ili wapate imbuli ya ukumghoghela. ");
INSERT INTO ruf_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Kawalongela, “Apfi imunu yuhi kuna mwemwe ing'olo wake ang'engila mwikolongo mne Litsuwa lya Sabato, ng'atsomkwegha yamlapfe kunze?” ");
INSERT INTO ruf_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Imunu kanogha kubita ing'olo! Apfo ng'atughomighwa bae kutenda ghanoghile mne litsuwa lya Sabato. ");
INSERT INTO ruf_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Kuya kamlongela imunu yula, “Gholosa ghumoko ghwako.” Kaghugholosa, nagho ghuhona ka ghumoko ghwake ghungi. ");
INSERT INTO ruf_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Apfo Mafarisayo wala tsawalawa kunze, kuya wabama inzila pfawatsomkoma Yesu. ");
INSERT INTO ruf_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesu hayaimanyile imbuli ayo, koka hanu hala, na iwanu wengi wamuwinza. Naye kawahonetsa iwatamu wawo, ");
INSERT INTO ruf_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","kuya kawaghoma waleke kuwalongela iwanu wangi mbuli tsake. ");
INSERT INTO ruf_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Tsakatenda apfo ili achila chayalongile nabii Isaya chitimile, ");
INSERT INTO ruf_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ayuno mtumighwa wangu iyanimsaghule, iyoninoghela, na iyonideng'elesa. Nitsoghuma Ghumuhe ghwangu mchanya mwake, katsotsipetela isi tsose ukuhigha kwangu. ");
INSERT INTO ruf_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ng'atsesonga wala ukukemela, kuduhu imunu iyatsohulika litsi lyake mnzila. ");
INSERT INTO ruf_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ghumlanzi ighuhondeke ng'atsoghubena bae, wala ichitasa ichilapfa lihosi ng'atsochitsima bae, mbaka aitende haki itawale. ");
INSERT INTO ruf_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Iwanu we isi tsose watsolilolela taghwa lyake.” ");
INSERT INTO ruf_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Kuya wamghalila Yesu imunu yumwe chifita iyakalile chibubu kwaapfila tsakakala na chinyamkela, Yesu tsakamhonetsa mbaka kadaha ukulonga ne ukwona. ");
INSERT INTO ruf_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Iwanu wose tsawakangawala, walonga, “Ayuno kodaha kuwa imwana we Daudi?” ");
INSERT INTO ruf_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Lekeni Mafarisayo hawahulike apfo, walonga, “Imunu yuno kolapfa pfinyamkela kwa ukwapfilighwa na Belisebuli, mkulu we pfinyamkela.” ");
INSERT INTO ruf_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu tsakamanya chawang'ali wokwalangula, kawalongela, “Undewa wowose iwighola wenyegho kwa wenyegho utsohinyika. Isi au kaye yoyose iighola yenyegho kwa yenyegho ng'aitsokwima bae. ");
INSERT INTO ruf_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Setani ang'amlapfa Setani, ayo keghola imwenyegho. Lelo undewa wake utsakwimatse? ");
INSERT INTO ruf_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mwemwe mwolonga nolapfa pfinyamkela kwaapfila Belisebuli konyapfila kutenda apfo. Lelo yuhi iyoweng'a iwanu wenu ingupfu ye kulapfa pfinyamkela? Iwanu wenu iwenyegho watsowahighani mwemwe. ");
INSERT INTO ruf_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Lekeni ka nolapfa pfinyamkela kwa Ghumuhe we Imulungu, mmanye ka undewa we Imulungu ma uwatsila. ");
INSERT INTO ruf_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Kuduhu imunu yodaha kwingila mne ing'anda ye imunu yane ngupfu na kusola pfinu pfake, mbaka tanu yamwohe imunu ayo? Baho lelo katsodaha kumboka ipfinu pfake. ");
INSERT INTO ruf_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Imunu ka ng'ali hamwe na nene bae, ayo konibela, na imunu ing'ayokunga na nene, ayo kopwililisa. ");
INSERT INTO ruf_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Apfo nowalongelani, chila matotso na maligho ghawotenda iwanu, watsoleghusighwa nzambi atso, lekeni ayula iyomligha Ghumuhe Mwenzeluka ng'atsoleghusighwa nzambi ayo. ");
INSERT INTO ruf_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Imunu wowose iyomlonga pfihile Imwana we Imunu katsoleghusighwa nzambi, ila ayula iyomlonga pfihile Ghumuhe Mwenzeluka ng'atsoleghusighwa nzambi mne ghamatsuwa ghano au ighakutsa. ");
INSERT INTO ruf_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Mghutende ghumbiki ghunoghe na ghamatunda ghake ghanoghe au mghutende ghumbiki ghwihe na ghamatunda ghake ghehe. Kwaapfila ghumbiki ghomanyika kwa ghamatunda ghake. ");
INSERT INTO ruf_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mwemwe iwana we nzoka, apfi mdahatse kulonga ghanoghile na mwemwe iwenyegho mwiha? Kwaapfila imunu kolonga achila ichimemile mne ghumoyo. ");
INSERT INTO ruf_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Imunu yanoghile kolapfa ipfinu ipfinoghile kulawa mne atsina ye ipfinu ipfinoghile, na imunu yehile kolapfa ipfinu pfihile kulawa mne atsina ye ipfinu pfihile. ");
INSERT INTO ruf_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Apfo nowalongelani ghendo, mne litsuwa lya kuhigha iwanu watsobamighwa wedike kwaajili ya chila imbuli ihile yawolonga. ");
INSERT INTO ruf_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Mana kwa ghaulonga kutsohighighwa ka kwahela ghamatotso au kuna ghamatotso.” ");
INSERT INTO ruf_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kuya iwalangulitsi wangi wa Ghamalaghitso na Mafarisayo wangi wamlongela, “Mlangulitsi, twobama twone chitango kulawa kuna ghweghwe.” ");
INSERT INTO ruf_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Kawedika, “Mweleko ghwihile na wa ughoni wobama chitango! Lekeni ng'amtsakwing'ighwa chitango ila chitango cha nabii Yona. ");
INSERT INTO ruf_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ka Yona pfayakalile munda mwe isomba mkulu ghamatsuwa madatu chilo ne imisi. Pfipfo Imwana we Imunu pfayatsokala ghamatsuwa madatu chilo ne imisi mne ghumoyo ghwe isi. ");
INSERT INTO ruf_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Iwanu wa Ninawi watsakwima na mweleko ghuno mne litsuwa lya kuhigha, kuya watsowahighani, kwaapfila tsawaghaleka ghamatotso ghawo hawapetelighwe na Yona. Na hano hana mkulu kubita Yona. ");
INSERT INTO ruf_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Mne litsuwa lye ukuhigha Malikiya wa Sheba katsakwima ne iwanu wa mweleko ghuno, naye katsowahighani kwaapfila tsakatsa kulawa mne isi yake, kutegheletsa ghamalangulitso gha ihekima ya Selemani, na sambi hano hana mkulu kubita Selemani. ");
INSERT INTO ruf_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Chinyamkela hayomlawa imunu, kakwangakwanga mne isi isakale kobama hanu ha ukubwihila, na ka ng'opata bae hanu, ");
INSERT INTO ruf_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","kelongela imwenyegho, ‘Mbuye ukaye yangu,’ na hayatsakuya na kuyona ing'anda yahela ichinu, iseghighwa na ikighwa ghoya, ");
INSERT INTO ruf_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","kakuka na kusola pfinyamkela wangi saba wehile kubita yeye, nawo wakwingila na kukala amo. Na ughima wa imunu ayo utsokuwa wiha kubita wa mwanduso. Apfo pfipfo pfaitsakuwa kwa mweleko ghuno ghwihile.” ");
INSERT INTO ruf_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu hayang'ali yolonga ne mtingano, mai wake na ndughu tsake hawapfikile wema kunze, tsawabama walonge naye. ");
INSERT INTO ruf_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Apfo imunu yumwe kamlongela, “Mai wako na ndughu tsako wakunze, wobama walonge naghwe.” ");
INSERT INTO ruf_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesu kamwidika, “Yuhi mai wangu? Wahi ndughu tsangu?” ");
INSERT INTO ruf_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Kuya kawagholosela ghumoko iwanang'ina wake kalonga, “Hawano iwo mai wangu na ndughu tsangu! ");
INSERT INTO ruf_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kwaapfila imunu wowose iyosang'ana achila choyobama Aba wangu wa kulanga, hayo ka mai wangu, na ndughu yangu.” ");
INSERT INTO ruf_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Litsuwa lilila Yesu kalawa mne ing'anda ila kaghenda mmbalimbali mwe tsimbu, ako kakala hasi, kalangulitsa. ");
INSERT INTO ruf_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Mtingano mkulu tsaghumtsunguluka mbaka kengila mne mnumbwi na kukala amo, na iwanu wose wema mmbambali mwe tsimbu. ");
INSERT INTO ruf_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Kawalongela mbuli nyingi kwa imifano, kalonga, “Tsakukala ne imunu yumwe iyaghendile kuhanda tsimbeghu tsake. ");
INSERT INTO ruf_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Hayang'ali yopwililisa tsimbeghu, tsingi tsilaghalila habehi ne inzila, iwapfideghe watsa watsija. ");
INSERT INTO ruf_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Tsingi tsilaghalila mne ghamabwe hanu hane lidongo chidogho. Tsota himahima na kukula kwaapfila lidongo ng'alighendese hasi bae. ");
INSERT INTO ruf_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Lekeni litsua halilawile, imimeya inyala, na kwaapfila imitsisi ng'aighendese hasi bae imimeya isakala. ");
INSERT INTO ruf_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Tsimbeghu tsingi tsilaghalila mne tsimiwa, tsimiwa tsikula, tsipfingilila imimeya. ");
INSERT INTO ruf_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Lekeni tsingi tsilaghalila mne lidongo linoghile, tseleka, imwe mia imwe, imwe sitini, na ingi selathini. ");
INSERT INTO ruf_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yane ghamaghutwi na yahulike!” ");
INSERT INTO ruf_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Iwanang'ina wake wamghendela wamghutsa, “Ule ulonga ne iwanu kwa imifano?” ");
INSERT INTO ruf_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Kawedika, “Mwemwe mtendighwa mdahe kutsimanya mbuli tsa undewa we Imulungu, lekeni wawo ng'awatendighwe apfo bae. ");
INSERT INTO ruf_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kwaapfila imunu wowose yane ichinu, katsakongetsighwa ghendo, na ayula iyalihela ichinu, katsobokighwa hata achila chidodo chayalinacho. ");
INSERT INTO ruf_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Achino ichinu ichinitenda nilonge nawo kwa mifano. Wolola lekeni ng'awakona bae, wotegheletsa lekeni ng'awohulika wala ng'awomanya bae. ");
INSERT INTO ruf_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Na aghala ghalongile nabii Isaya ghatimila kuna wawo, ‘Mtsotegheletsa na ukutegheletsa, lekeni ng'amtsomanya bae. Mtsolola na ukulola, lekeni ng'amtsakona bae. ");
INSERT INTO ruf_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Mana imimoyo ye iwanu iwa mitito, kwa ghamaghutwi ghawo ng'awohulika pfinoghile bae, na tsinenge tsawo wafinyilitsa, hela wang'onile kwa tsinenge tsawo, wang'ahulike kwa ghamaghutwi ghawo, wang'amanyile kwa imimoyo yawo, wang'anihundukile, nani ning'awahonetse.’ ");
INSERT INTO ruf_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Lekeni mwemwe mbweda! Kwaapfila tsinenge tsenu tsakona na ghamaghutwi ghenu ghohulika. ");
INSERT INTO ruf_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nowalongela ghendo, manabii wengi ne iwanu we Imulungu tsawabama ng'ani wone achila chamkona mwemwe, na ukuhulika achila chamuhulika, lekeni ng'awonile bae wala ng'awahulike. ");
INSERT INTO ruf_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Lelo mtegheletse mana ya ghumfano ghwe imunu iyohanda. ");
INSERT INTO ruf_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Imunu wowose iyohulika imbuli ya undewa lekeni ng'oielewa bae, ayo keghala na tsimbeghu itsilaghalile mnzila. Yehile kakutsa koboka achila ichihandighwe mghati mwake. ");
INSERT INTO ruf_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Tsimbeghu tsila itsilaghalile mna ghamabwe tseghala ne imunu yohulika imbuli na bahala koibokela kwa ndeng'elelo. ");
INSERT INTO ruf_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Lekeni kwaapfila kahela imitsitsi, kodudumila chidogho. Ghamaghayo na kudununzika pfing'atsa kwaajili ye imbuli, baho kakughwa. ");
INSERT INTO ruf_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Tsimbeghu itsilaghalile mne tsimiwa tseghala ne imunu yula iyohulika imbuli, lekeni sang'ano tse ughima uno, na kunoghela sideke utajili woihinya imbuli ayo, nae ng'akweleka bae ghamatunda. ");
INSERT INTO ruf_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Na tsimbeghu itsilaghalile mne lidongo linoghile tseghala ne imunu yula iyohulika imbuli ayo na kuielewa. Hayo kakweleka ghamatunda, yungi mia imwe, hayu sitini na yungi selathini.” ");
INSERT INTO ruf_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu kawalongela keli ghumfano ghungi, “Undewa wa kulanga weghala ne imunu yahandile mbeghu inoghile mne mghunda wake. ");
INSERT INTO ruf_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Lekeni iwanu hawawasile, mwihile wake katsa, kuya kahanda imighughu mghati mwe uhemba kuya koka. ");
INSERT INTO ruf_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Uhemba hawotile na kwandusa ukweleka, imighughu nayo yoneka mne uhemba. ");
INSERT INTO ruf_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Watumwa wake wamghendela, wamlongela ‘Imndewa, apfi ng'uhandile mbeghu inoghile mne mghunda wako. Lelo imighughu ilawile kwani?’ ");
INSERT INTO ruf_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Kawedika, ‘Mwihile iyo iyatendile apfo.’ Iwatumwa wake wamghutsa ‘Pfii kobama tughende tukaing'ole?’ ");
INSERT INTO ruf_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Kawedika, ‘Bae, kwaapfila hamng'ola imighughu, mwodaha kung'ola imighughu hamwe ne uhemba. ");
INSERT INTO ruf_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mleke pfose pfikule hamwe mbaka ghumsimu ghwa ukusenga. Baho nitsowalongela awala iwosenga, tanu mkunge imighughu, myowe makinzamakinza mkaghalakatse. Kuya mkunge uhemba mkeke mkano mwangu.’ ” ");
INSERT INTO ruf_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu kawalongela ghumfano ghungi, “Undewa we Imulungu weghala ne imbeghu ndodo ya haladali. Imunu yumwe tsakaisola kaihanda mumghunda mwake. ");
INSERT INTO ruf_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Yenyegho ndodo kubita mbeghu tsose, na haikula, yakuwa ng'ulu kubita imimeya yose ye kumghunda. Yakuwa mbiki, apfo iwapfideghe iwali mlanga wakutsa, wotsenga ipfibali mne ghamaputila ghake.” ");
INSERT INTO ruf_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu kawalongela keli ghumfano ghungi, “Undewa wa kulanga weghala ne hamila iisolighwe ne pinga yumwe na kuhanganya mne utimbo mwingi, nawo wose usasa.” ");
INSERT INTO ruf_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu tsakaghulongela mtingano agha ghose kwa imifano, ng'alongile nawo bae chinu chochose chila bila ya ghumfano. ");
INSERT INTO ruf_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Tsakatenda apfo ghatimile ighalongingwe na nabii. “Nitsolonga nawo kwa imifano, Nitsoghalonga aghala ighapfisighwe kulawa isi hailumbighwe.” ");
INSERT INTO ruf_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Kuya Yesu kaghuleka mtingano ghwe iwanu kaghenda mng'anda, iwanang'ina wake wamghendela, wamlongela, “Utulongele ghumfano ghwe imighughu ghutulangulitsa choni?” ");
INSERT INTO ruf_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Kawedika, “Imunu iyahandile imbeghu inoghile iyo Imwana we Imunu. ");
INSERT INTO ruf_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Mghunda iyo iisi, na imbeghu inoghile iwo iwana wa undewa we Imulungu, imighughu iwo iwana we ayula Yehile. ");
INSERT INTO ruf_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Na mwihile iyahandile imighughu iyo Setani. Ghamapfuno iwo utsighilo we iisi, na awala iwosenga iwo malaika. ");
INSERT INTO ruf_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ka imighughu pfaikungighwa na kulakatsighwa mmoto, itsakuwa pfipfo mne utsighilo we iisi. ");
INSERT INTO ruf_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Imwana we Imunu katsowatuma malaika wake, wapfikunge kulawa mne undewa wake apfila pfose ipfiwahonza iwanu watende nzambi na awala wose iwotenda ghehile. ");
INSERT INTO ruf_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Nawo watsowasa mne ghumoto, ako watsolila na kughegheda ghamatsino. ");
INSERT INTO ruf_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kuya iwanu wanoghile watsong'ala ka litsua mne undewa wa Aba wawo. Yane ghamaghutwi gha kuhulika, na yahulike. ");
INSERT INTO ruf_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Undewa wa kulanga weghala na hatsina iipfisighwe mne mghunda. Imunu hayoyona, koipfisa keli. Kwa ndeng'elelo ng'ulu iyali nayo koghenda kuutsa pfose pfayali napfo, kuya kakuya na kughughula mghunda ghula. ");
INSERT INTO ruf_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Pfipfila undewa wa kulanga weghala ne mchulutsi iyobama lulu inoghile, ");
INSERT INTO ruf_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","hayoyona lulu inoghile sideke, koghenda kuutsa pfinu pfose pfayali napfo, kuya koighula lulu ayo. ");
INSERT INTO ruf_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Pfipfila undewa wa kulanga weghala ne nyapfu yasighwe mne ibahali, yokunga iwasomba iwanoghile na iwehile. ");
INSERT INTO ruf_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Haimema, iwanu woikwegha mbaka mmbalimbali mwe ibahali, wokala hasi na kusaghula iwasomba, iwanoghile woweka mseghe, awala iwehile wowasa. ");
INSERT INTO ruf_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Itsakuwa pfipfo mne utsighilo we iisi, malaika watsakutsa na kuwabaghula iwanu awala wehile kulawa kwe iwanu iwanoghile, ");
INSERT INTO ruf_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","na kuwasa mne ghumoto, ako watsolila na kughegheda ghamatsino.” ");
INSERT INTO ruf_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu kawaghutsa, “Apfi mwoghamanya aghano ghose?” Wamwidika, “Ona.” ");
INSERT INTO ruf_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Naye kawalongela, “Apfo chila mlangulitsi we Ghamalaghitso iyalangusighwe imbuli ye undewa wa kulanga keghala ne imunu yane ing'anda, iyolapfa ipfinu pfa sambi na pfa ghumwande kulawa mne hatsina yake.” ");
INSERT INTO ruf_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu hayamalitse kuwalongela imifano ino, koka hanu aho, ");
INSERT INTO ruf_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","koya ukaye yake. Kalangulitsa mne tsing'anda tse ukulombela, na awala iwamuhulike wakangawala, weghutsa, “Apfi aipatile kwani ihekima ino na pfinzonza pfino? ");
INSERT INTO ruf_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ayuno si imwana wa msongola mibiki bae? Angu mai wake si Mariya bae? Na ndughu tsake si tsina Jakobu, Yosefu, Simoni na Yuda bae? ");
INSERT INTO ruf_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Na lumbu tsake ng'awalibaha na twetwe bae? Lelo aghapatile kwani agha ghose?” ");
INSERT INTO ruf_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Apfo wamhila. Lekeni Yesu kawalongela. “Nabii koteghelesighwa chila hanu, ila ng'oteghelesighwa bae ukaye yake na mng'anda mwake imwenyegho.” ");
INSERT INTO ruf_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Apfo ng'atendile bae pfinu pfingi pfa kukangawatsa ako, kwaapfila tsang'awamtoghole bae. ");
INSERT INTO ruf_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Mne ghamatsuwa agho, mndewa Herodi tsakahulika mbuli tsa Yesu. ");
INSERT INTO ruf_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Apfo kawalongela iwatumwa wake, “Imunu yuno iyo Yohane Mbatitsa, katsilihuka. Apfo ingupfu ye pfinzonza yosang'ana mghati mwake.” ");
INSERT INTO ruf_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Kwaapfila Herodi tsakamghogha Yohane, kamowa na kumwika mchifungo, kwaajili ya Herodiya, mwehe wa Filipi, ndughu yake, ");
INSERT INTO ruf_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","kwaapfila Yohane tsakamlongela Herodi, “Ng'apfinoghile bae ghweghwe kumkwela Herodiya!” ");
INSERT INTO ruf_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodi tsakabama kumkoma Yohane, lekeni tsakapfuka iwanu, kwaapfila tsawamwona ka nabii. ");
INSERT INTO ruf_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Mne chihungo cha ukwelekighwa kwa Herodi, neghe Herodiya tsakabigha hambele he iwanu, Herodi tsakanoghelesighwa, ");
INSERT INTO ruf_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","mbaka kamlongela, “Nelaha nitsokwing'a chochose choubama!” ");
INSERT INTO ruf_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Kwa kuwinza ghamalaghitso gha mai wake mwana ayo kalonga. “Ungaye bahano litwi lya Yohane Mbatitsa mlungo.” ");
INSERT INTO ruf_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Imndewa Herodi tsakona usungu sideke, lekeni kwaapfila tsakelaha hambele he iwahenza wake, kalaghitsa yeng'ighwe. ");
INSERT INTO ruf_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Apfo Herodi kamtuma imunu yamghane litwi Yohane akula mchifungo. ");
INSERT INTO ruf_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Litwi lyake lighalighwa likighwa mlungo, keng'ighwa imwana ayo, naye kamghalila mai wake. ");
INSERT INTO ruf_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Iwanang'ina wa Yohane tsawaghenda walusola lukuli lwake, walutsika, kuya wamlongela Yesu. ");
INSERT INTO ruf_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu hayahulike achila ichilawile, koka hanu aho kwa ghumnumbwi kaghenda hanu halihela iwanu. Na ghumtingano ghwe iwanu hawahulike, wamuwinza kwa ghamaghulu kulawa mne isi tsawo. ");
INSERT INTO ruf_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu hayahulumke mne mnumbwi, kawona ghumtingano mkulu ghwe iwanu, kawonela libatsi, kawahonetsa iwatamu wawo. ");
INSERT INTO ruf_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nemihe haipfikile, iwanang'ina wake wamghendela, wamlongela, “Hanu hano hose nyika, na litsua liswa, uwaleke iwanu woke waghende mne ipfijiji wakeghulile ipfijo.” ");
INSERT INTO ruf_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu kawedika, “Ng'awobamighwa bae woke, mwemwe muwenyegho muweng'e ichijo.” ");
INSERT INTO ruf_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Wamwidika, “Tuna pfighate pfitano pfiliyeka ne iwasomba weli.” ");
INSERT INTO ruf_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu kawalongela, “Ngalileni hano.” ");
INSERT INTO ruf_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kawalongela iwanu wakale hasi mne imitsani. Kasola pfighate pfila pfitano ne iwasomba weli, kalola kulanga, kapfibaliki kapfibena pfighate pfila. Kuya kaweng'a iwanang'ina wake, nawo waweng'a iwanu. ");
INSERT INTO ruf_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Iwanu wose waja, weghuta. Na iwanang'ina wake wadondola pfighate ipfisighale, wamemesa pfiseghe kumi na pfili. ");
INSERT INTO ruf_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Iwamale iwajile tsawang'ali wopfika elufu tano, iwapinga ne iwana ng'awapetighwe bae. ");
INSERT INTO ruf_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Yesu hayang'ali yowaagha iwanu, kawalongela iwanang'ina wake wadine mne mnumbwi wamlongole kuloka kumwambu. ");
INSERT INTO ruf_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Hayamalitse kuwaagha iwanu, kagheluka mchidunda kulomba. Nemihe haipfikile, kakala ako yaliyeka, ");
INSERT INTO ruf_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","na mnumbwi tsa ghwa kutali na kumwani ghwotowighwa na ghamawimbi, kwaapfila inyahemu tsaikala yoghukunughitsa. ");
INSERT INTO ruf_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Habehi na ukucha, Yesu kawaghendela, aku koghenda mchanya mwe ghamatsi. ");
INSERT INTO ruf_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Iwanang'ina wake hawamwonile koghenda mchanya mwe ghamatsi, tsawapfuka. Walonga, “Ghumtsimu!” Wakemelela kwa kupfuka. ");
INSERT INTO ruf_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Lekeni bahala Yesu kawalongela, “Mwinyamale! Na nene. Mleke kupfuka!” ");
INSERT INTO ruf_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petiri kamwidika, “Imtwatsa, ka ghweghwe, unongele nitse kuna ghweghwe kwa kughenda mchanya mwe ghamatsi.” ");
INSERT INTO ruf_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Kuya Yesu kamlongela, “Haya utse!” Petiri kahulumka mne ghumnumbwi, kaghenda mchanya mwe ghamatsi kumghendela Yesu. ");
INSERT INTO ruf_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Lekeni hayonile inyahemu, kapfuka kandusa kutsama, kalila, “Imtwatsa, nikombole.” ");
INSERT INTO ruf_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Bahala Yesu kagholosa ghumoko ghwake kamkinda. Kamlongela, “Ghweghwe yutoghola chidogho, ebali upfuka?” ");
INSERT INTO ruf_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Nawo hawadinile mne mnumbwi, inyahemu nayo inyamala. ");
INSERT INTO ruf_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Na awala iwakalile mne ghumnumbwi, wamtamanila, walonga, “Ghweghwe kwa Imwana we Imulungu ghendo.” ");
INSERT INTO ruf_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Hawalokile tsimbu na kupfika isi ya Genesareti. ");
INSERT INTO ruf_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Na iwanu iwali mne isi ila hawamtangile Yesu, watsenetsa mbuli tsake mne isi tsose, apfo wamuhilikila iwatamu wawo wose. ");
INSERT INTO ruf_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Wamlomba yawalekele iwatamu wakinde mindo ye lighwanda lyake. Na wose iwalikindile tsawahona. ");
INSERT INTO ruf_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Kuya Mafarisayo ne iwalangulitsi wa Ghamalaghitso iwalawile Yerusalemu wamghendela Yesu, wamghutsa, ");
INSERT INTO ruf_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ebali iwanang'ina wako ng'awokinda bae ipfihendo pfe iwabala wetu? Hawakuja ng'awohopfugha bae pfinoghile ghamoko ghawo!” ");
INSERT INTO ruf_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu kawedika, “Ebali mwemwe ng'amkinda bae malaghitso ghe Imulungu ila mwopfiwinza ipfihendo pfenu? ");
INSERT INTO ruf_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kwaapfila Imulungu kalonga, ‘Umtegheletse aba wako na mai wako,’ na ‘Imunu wowose iyomligha aba wake au mai wake ayo yakomighwe.’ ");
INSERT INTO ruf_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Lekeni mwemwe mwolonga, ka imunu kana ichinu chochose ichidaha kumwapfila aba wake au mai wake, lekeni kolonga, ‘Ichinu chino nimlapfila Imulungu,’ ");
INSERT INTO ruf_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","imunu ayo ng'obamighwa bae kumtegheletsa aba wake. Apfo pfipfo pfamuibetsa imbuli ye Imulungu kwa kuwinza ipfihendo pfenu. ");
INSERT INTO ruf_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mwemwe mwa wang'enye! Nabii Isaya tsakatabili ghoya, hayalongile, ");
INSERT INTO ruf_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Iwanu wano wonipfuka kwa kulonga, lekeni imimoyo yawo yakutali na nene. ");
INSERT INTO ruf_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Wonitamanila hela, kwaapfila wolangulitsa ghamalaghitso ghe iwanu ka ghamalaghitso ghangu.’ ” ");
INSERT INTO ruf_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesu kaghukema ghumtingano ghwe iwanu, kawalongela, “Mtegheletse mpfimanye! ");
INSERT INTO ruf_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Achila ichikwingila mumlomo mwe imunu ng'achidaha bae kumtenda ‘yehe.’ Lekeni achila ichilawa kunze mwe mlomo we imunu, acho chomtenda ‘yehe.’ ” ");
INSERT INTO ruf_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Kuya iwanang'ina wake wamghendela wamghutsa, “Apfi komanya ka Mafarisayo hawahulike imbuli ino tsawona maya?” ");
INSERT INTO ruf_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Kawedika, “Chila mbiki ing'aghuhandighwe ne Aba wangu iyali kulanga ghutsong'olighwa. ");
INSERT INTO ruf_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Muwaleke awo, iwalongotsa pfifita. Ichifita ang'amlongotsa ichifita miyaghe, ambe wose weli watsakughwila mpondo.” ");
INSERT INTO ruf_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petiri kamlongela, “Utulongele mana ye ghumfano ghuno.” ");
INSERT INTO ruf_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu kawaghutsa, “Apfi namwe mwose mng'ali ng'ammanyile bae? ");
INSERT INTO ruf_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Angu ng'ammanyile bae ka ichinu chochose ichikwingila mumlomo mwe imunu chobitila munda, kuya choghenda kucholo? ");
INSERT INTO ruf_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Lekeni aghala igholawa mumlomo, gholawa mghati mwe ghumoyo, agho ghagho ighomtenda imunu yehe. ");
INSERT INTO ruf_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kwaapfila mne ghumoyo gholawa ghamawatso ghehile na ukukoma na ughoni, ughutsu, ukulonga ung'enye na ubapfi na maligho. ");
INSERT INTO ruf_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Aghano ghomtenda imunu yehe, lekeni ukuja na ghamoko ghang'ahopfughighwe pfinoghile ng'akumtenda bae imunu yehe.” ");
INSERT INTO ruf_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu koka hanu hala, kaghenda mne isi ya Tiro na Sidoni. ");
INSERT INTO ruf_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ipinga yumwe Mkananayo tsayang'ali yokala habehi na isi atso kamghendela Yesu aku kokemelela, “Imtwatsa, Imwana wa Daudi, umbonele libatsi! Mwanangu kana chinyamkela, koghaya ng'ani.” ");
INSERT INTO ruf_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yesu ng'edike chochose bae. Iwanang'ina wake wamghendela, wamlomba, “Mlongele yoke kwaapfila kotuwinza na kokemelela kuchughu kwetu.” ");
INSERT INTO ruf_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu kedika, “Tsanitumighwa kwe iwanu wa Isiraeli waliheka iwaghile ka iwang'olo.” ");
INSERT INTO ruf_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ipinga ayo kamghendela kamtowela ghamaghoti, kalonga, “Imtwatsa, unyapfile!” ");
INSERT INTO ruf_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu kedika, “Ng'apfinoghile bae kusola ichijo che iwana na kuwasila wambwa.” ");
INSERT INTO ruf_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ipinga ayo kalonga, “Ona, Imtwatsa, lekeni hata iwambwa wakuja ipfijo ipfilaghala mmetsa mwe iwatwatsa wawo.” ");
INSERT INTO ruf_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Kuya Yesu kamwidika, “Ghweghwe kwa mai yutoghola ghendo! Kutsotendelighwa chaubamile.” Bahala imwanaghe kahona. ");
INSERT INTO ruf_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu tsakoka hanu hala, kaghenda mmbalimbali mwe tsimbu Galilaya. Kuya kagheluka kuchidando, kakala hasi. ");
INSERT INTO ruf_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ghumtingano mkulu ghwe iwanu ghumghendela na kumuhilikila ipfimbete na ipfifita na ipfibubu na iwanu iwaholole, ne iwanu wengi iwoghula, wamwikila hambele hake. Naye kawahonetsa. ");
INSERT INTO ruf_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Iwanu tsawakangawala hawonile ipfibubu wolonga, iwaholole wahona, ipfimbete woghenda na ipfifita wakona. Nawo wamtunitsa Imulungu wa Isiraeli. ");
INSERT INTO ruf_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu kawakema iwanang'ina wake, kawalongela, “Nowonela libatsi iwanu wano, kwaapfila wakala na nene kwa ghamatsuwa madatu na wahela chokuja. Kuya sibama bae niwaleke woke ne inzala, kwaapfila watsotsilika mnzila.” ");
INSERT INTO ruf_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Iwanang'ina wake wamghutsa, “Akuno kunyika twodaha kupata kwani ichijo cha ukuwaghutitsa iwanu wose wano?” ");
INSERT INTO ruf_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu kawaghutsa, “Mna pfighate pfingapi?” Wamwidika, “Saba na iwasomba wadowado chidogho.” ");
INSERT INTO ruf_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yesu kawalongela iwanu wakale hasi. ");
INSERT INTO ruf_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kapfisola pfighate pfila saba na iwasomba, kapfibaliki, kapfibena kaweng'a iwanang'ina wake, nawo wawagholela iwanu. ");
INSERT INTO ruf_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Wose tsawaja na kwighuta. Kuya iwanang'ina wake wadondola ipfiseghe saba ipfimemile pfighate ipfisighale. ");
INSERT INTO ruf_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Iwamale iwajile tsawapetighwa, tsawakala elufu nne, iwapinga ne iwana ng'awapetighwe bae. ");
INSERT INTO ruf_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Kuya kawaleka iwanu woke, kadina mne mnumbwi, kaghenda mne isi ya Magadani. ");
INSERT INTO ruf_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mafarisayo na Masadukayo wamghendela Yesu, wamghetsa kwa kumghutsa yawalanguse chitango kulawa kulanga. ");
INSERT INTO ruf_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yesu kawedika, “Litsuwa halikuswa, mwolonga, ‘Kutsonogha, kwaapfila mlanga kudung'u.’ ");
INSERT INTO ruf_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Na nemitondo mwolonga, ‘Leloli imvula yotowa, kwaapfila mlanga kudung'u na libingu litegha.’ Mwodaha kutanga mlanga pfakuli, lekeni ng'amdaha bae kutanga ipfitango pfe ghamatsuwa agha. ");
INSERT INTO ruf_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mweleko ghwihile na ing'aghutoghola ghobama ipfitango! Lekeni ng'amtsakwing'ighwa ichitango kubita achila cha Yona.” Kuya Yesu kawaleka, koka. ");
INSERT INTO ruf_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Hawalokile tsimbu, iwanang'ina wake tsawatanga ka wesemwa kusola pfighate. ");
INSERT INTO ruf_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu kawalongela, “Mwalangitse, mwilolese ne hamila ya Mafarisayo na Masadukayo.” ");
INSERT INTO ruf_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Wandusa ukwighutsa iwenyegho kwa iwenyegho, “Kolonga apfi kwaapfila ng'atughalile chighate chochose bae.” ");
INSERT INTO ruf_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu tsakamanya achila chawang'ali wolonga, apfo kawaghutsa, “Mwemwe yamtoghola chidogho, ule mwighutsa iwenyegho kwa iwenyegho kwaapfila mwahela pfighate? ");
INSERT INTO ruf_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Angu mng'ali ng'ammanyile bae? Pfii mwisemwa hala hanibenile pfighate pfitano kwe iwanu elufu tano? Tsammemetse ipfiseghe pfingapi ipfisighale? ");
INSERT INTO ruf_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Na apfila pfighate saba kwe iwanu elufu nne? Tsammemetse pfiseghe pfingapi ipfisighale? ");
INSERT INTO ruf_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Angu ng'ammanyile bae ka sing'ali nilonga tsimbuli tse pfighate? Mwalangitse ne hamila ya Mafarisayo na Masadukayo!” ");
INSERT INTO ruf_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kuya iwanang'ina wamanya ghendo ka Yesu ng'awalongele bae walangitse ne hamila ye pfighate, ila walangitse na ghamalangulitso gha Mafarisayo na Masadukayo. ");
INSERT INTO ruf_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu hayapfikile mne isi ye Kaisariya Filipi, kawaghutsa iwanang'ina wake “Angu iwanu wolonga Imwana we Imunu nani?” ");
INSERT INTO ruf_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Wamwidika, “Iwanu wangi wolonga Yohane Mbatitsa, wangi wolonga Eliya, wangi wolonga Yeremiya au yumwe wa nabii.” ");
INSERT INTO ruf_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Kawaghutsa, “Namwe mlongatse, mwolonga nene nani?” ");
INSERT INTO ruf_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simoni Petiri kamwidika, “Ghweghwe kwa Kiristu Imkombotsi, Imwana we Imulungu iyali mghima!” ");
INSERT INTO ruf_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu kamwidika, “Kubweda ghweghwe Simoni, imwana wa Yohane, kwaapfila achino chaulongile ng'ulangusighwe ne imunu bae, ila chilawila kwa Aba wangu iyali kulanga. ");
INSERT INTO ruf_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Na nene nokulongela, Petiri, ghweghwe kwa bambalawe na mchanya mwe bambalawe lino nitsotsenga kanisa lyangu, na hata lifwa ng'alitsodaha bae kulihinya. ");
INSERT INTO ruf_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nitsokwing'a tsifughulo tsa undewa wa kulanga. Chinu chochose chauhinda muisi chitsohindighwa kulanga, na chochose chaufughula muisi, chitsofughulighwa kulanga.” ");
INSERT INTO ruf_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Kuya Yesu kawaghoma iwanang'ina wake waleke kuwalongela iwanu ka yeye tsakakala Kiristu Imkombotsi. ");
INSERT INTO ruf_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kulawa baho Yesu kandusa kuwalongela iwanang'ina wake mwatsimwatsi, “Nobamighwa ng'ende Yerusalemu na kudununzika ng'ani mne ghamoko ghe iwakulu, watambika wakulu ne iwolangulitsa Ghamalaghitso. Kuya nitsokomighwa, lekeni mne litsuwa lya kadatu nitsotsilihuka.” ");
INSERT INTO ruf_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Petiri kamsola Yesu hambalimbali kandusa kumkembela, “Bae, Imtwatsa! Aghano ghaleke kukulawila.” ");
INSERT INTO ruf_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesu kahunduka, kamlongela Petiri, “Uke kuchughu kwangu, Setani! Ghweghwe kwa ng'walo kuna nene, kwaapfila ghamawatso ghako ng'agholawa bae kwe Imulungu, ila gha chimunu.” ");
INSERT INTO ruf_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kuya Yesu kawalongela iwanang'ina wake, “Imunu wowose iyobama kuniwinza, yeleme imwenyegho, yasole ghumsalaba ghwake yaniwinze. ");
INSERT INTO ruf_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Imunu wowose iyobama kuukombola ughima wake, katsowaghitsa, lekeni munu wowose iyowaghitsa ughima kwaajili yangu katsowona. ");
INSERT INTO ruf_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Apfi imunu katsobweda choni ang'apata isi yose, lekeni kowaghitsa ughima wake? Au imunu katsolapfa choni yapate keli ughima wake? ");
INSERT INTO ruf_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kwaapfila Imwana we Imunu katsakutsa mne utunitso wa Aba wake hamwe ne malaika wake, kuya katsomghweka chila imunu kwa achila chayatendile. ");
INSERT INTO ruf_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nowalongelani ghendo, iwanu wangi iwemile hano, ng'awatsokufa bae mbaka wamwone Imwana we Imunu kakutsa mne undewa wake.” ");
INSERT INTO ruf_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Haghabitile matsuwa sita, Yesu kamsola Petiri, Jakobu na Yohane ndughu yake Jakobu, kaghenda nawo waliyeka mchidando mwe chidunda chitali. ");
INSERT INTO ruf_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Hawang'ali wolola, bahala Yesu kaghaluka. Chihanga chake tsaching'ala ka litsua, na ghamaghwanda ghake ghawa matselu chwee ka ghumwanga! ");
INSERT INTO ruf_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kuya Musa na Eliya walawila, walonga naye. ");
INSERT INTO ruf_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Petiri kamlongela Yesu, “Mndewa, pfinogha twetwe kukala hano! Ung'abama nene nitsosenga pfibumbulika pfidatu, chimwe chako, chimwe cha Musa na chimwe cha Eliya.” ");
INSERT INTO ruf_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Hayang'ali yolonga, libingu iling'alile liwaghubika, na litsi kulawa mne libingu lila lilonga, “Ayuno Mwanangu iyoninoghela, nonoghelighwa naye. Mumtegheletse!” ");
INSERT INTO ruf_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Iwanang'ina hawahulike apfo, wapfuka ng'ani, watowa maghoti wenama mbaka pfihanga pfawo pfidonza hasi. ");
INSERT INTO ruf_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yesu kawaghendela kawaghutsa, kawalongela, “Mwinuke, mleke kupfuka!” ");
INSERT INTO ruf_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Hawalolile kuchanya, ng'awonile imunu bae ila Yesu yaliheka. ");
INSERT INTO ruf_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Hawang'ali wohulumka mchidando, Yesu kawalaghitsa, “Mleke kumlongela imunu wowose achila chamwonile mbaka Imwana we Imunu hayatsotsilihuka.” ");
INSERT INTO ruf_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Kuya iwanang'ina wamghutsa, “Lelo ule iwalangulitsi wa Ghamalaghitso wolonga Eliya kobamighwa tanu yatse?” ");
INSERT INTO ruf_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu kawedika, “Tanu Eliya kakutsa ghendo. Naye katsokwika ghoya ipfinu pfose. ");
INSERT INTO ruf_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nowalongelani, Eliya ma katsa, ila ng'awamtangile bae. Nawo wamtendela ghose ghawabamile. Pfipfila watsomdununza Imwana we Imunu.” ");
INSERT INTO ruf_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Kuya iwanang'ina tsawamanya ka Yesu yang'ali yowalongela mbuli tsa Yohane Mbatitsa. ");
INSERT INTO ruf_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Hawapfikile mne mtingano we iwanu, imunu yumwe kamghendela Yesu, kamtowela ghamaghoti, ");
INSERT INTO ruf_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","kalonga, “Imtwatsa, umwonele libatsi mwanangu, kana chisala na kodununzighwa ng'ani. Kwaapfila kakughwagha mne ghumoto au mne ghamatsi. ");
INSERT INTO ruf_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nimghala kuna iwanang'ina wako, lekeni ng'awadahile bae kumhonetsa.” ");
INSERT INTO ruf_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu kedika, “Mwemwe mweleko ing'aghutoghola, na ighwihile! Nitsokala na mwemwe mbaka tsuwachi? Nitsowadudumila mwemwe mbaka tsuwachi? Mngalile hano imsongolo ayo!” ");
INSERT INTO ruf_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesu kamkembela chinyamkela, na chinyamkela kamlawa imsongolo ayo. Bahala imsongolo ayo kahona. ");
INSERT INTO ruf_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kuya iwanang'ina wamghendela Yesu chinyelenyele, wamghutsa, “Ule ng'atudahile bae kumlapfa chinyamkela yula?” ");
INSERT INTO ruf_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu kawedika, “Kwaapfila mwotoghola chidogho. Nowalongelani ghendo, ka ukutoghola kwenu kung'awile kudodo ka imbeghu ya haladali, mng'adahile kuchilongela chidunda chino, ‘Ulawe hano, ughende kula,’ nacho ching'aghendile. Wala ng'akutsokuwa ne ichinu chochose ing'achidahika kuna mwemwe.” ");
INSERT INTO ruf_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Lekeni ichinyamkela ka yuno ng'odaha bae kulawa kwa inzila yoyose, ila kwa ukulomba na ukufunga ukuja. ");
INSERT INTO ruf_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Iwanang'ina wose hawapfikile Galilaya, Yesu kawalongela, “Imwana we Imunu katsoghoghighwa ne iwanu, ");
INSERT INTO ruf_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","nawo watsomkoma, ila mne litsuwa lya kadatu katsotsilihuka.” Iwanang'ina wake wona usungu sideke. ");
INSERT INTO ruf_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesu ne iwanang'ina wake hawapfikile Kaperinaumu, iwasola kodi ye ing'anda ye Imulungu wamghendela Petiri wamghutsa, “Apfi imlangulitsi wako koliha kodi ye ing'anda ye Imulungu?” ");
INSERT INTO ruf_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petiri kawedika, “Ona.” Petiri hayengile mng'anda, Yesu kandusa kulonga, “Simoni ukonatse? Iwandewa we isi wosola kodi au maliho kwe iwanu wachi, kwe iwana wawo au kwe iwahenza?” ");
INSERT INTO ruf_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petiri kamwidika, “Kwe iwahenza.” Yesu kedika, “Pfinogha, apfo iwanu wawo ng'awobamighwa kuliha bae. ");
INSERT INTO ruf_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Lekeni, ng'atubama bae kuwadesa iwanu wano, ghenda kune tsimbu, wase ludodi lwako. Umsole isomba yula yulongole kumlowa, umwasame mlomo ghwake kuya kutsakona isendi. Isole ukaweng'e kwaajili ya kodi yangu na yako.” ");
INSERT INTO ruf_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Bahala iwanang'ina wamghendela Yesu, wamghutsa, “Yuhi iyali mkulu mne undewa wa kulanga?” ");
INSERT INTO ruf_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu kamkema imwana mdodo, kamwika haghati hawo. ");
INSERT INTO ruf_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Kawalongela, “Nowalongelani ghendo, ka ng'amghaluka bae na kwighala ne iwana wadodo, ng'amtsakwingila mbe mne undewa wa kulanga. ");
INSERT INTO ruf_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Apfo imunu wowose yehulumsa mwenyegho ka imwana yuno, hayo iyo imkulu mne undewa wa kulanga. ");
INSERT INTO ruf_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Na imunu wowose iyombokela imwana mdodo ka yuno kwa taghwa lyangu, ayo kombokela nene. ");
INSERT INTO ruf_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Lekeni imunu wowose yomhonza yumwe we iwana wano iwonitoghola nene yatende nzambi, ng'apfu yohighwe libwe lya kusaghila msingo na yasighwe mwibahali mne ghamatsi ighaghendese. ");
INSERT INTO ruf_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Iisi yose itsoghaya kwaajili ya aghala ighowahonza iwanu waghitse ukutoghola kwawo! Agho ghatsolawila, lekeni katsoghaya imunu yula iyoghatenda ghalawile! ");
INSERT INTO ruf_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Ka ghumoko ghwako au mghulu ghwako ghwokuhonza utende ghehile, ughane ughwase kutali naghwe. Ng'apfu wingile mne ughima wa ghamatsuwa ghose aku kuhungukighwa na ghumoko au mghulu, kubita ukwasighwa mne ghumoto ghwa ghamatsuwa ghose aku kuna ghamoko meli na maghulu ghako meli. ");
INSERT INTO ruf_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Inenge yako ing'akuhonza utende ghehile, uing'ole uyase kutali naghwe! Ng'apfu wingile mne ughima wa ghamatsuwa ghose aku kuna inenge imwe kubita kwasighwa mne ghumoto aku kuna nenge mbili. ");
INSERT INTO ruf_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Mwalangitse mleke kumbetsa yumwe we iwana wano wadodo. Kwaapfila, nowalongelani wamalaika wawo ako kulanga ghamatsuwa ghose wa hambele ha Aba wangu iyali kulanga. ");
INSERT INTO ruf_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Kwaapfila Imwana we Imunu katsa kuwakombola awala iwaghile. ");
INSERT INTO ruf_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Mkonatse? Ka imunu kana iwang'olo mia imwe, kuya yumwe kagha, apfi ng'atsowaleka bae awala tisini na tisa kulughongo na kughenda kumbama ayula iyaghile? ");
INSERT INTO ruf_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nowalongelani ghendo, ang'amwona, katsomdeng'elela ng'ani kubita awala tisini na tisa yang'awaghile. ");
INSERT INTO ruf_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Pfipfila Aba wenu iyali kulanga ng'obama bae yumwe we iwadodo wano yaghe. ");
INSERT INTO ruf_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ndughu yako ang'akutendela ghehile, ughende ukamkanye totso lyake, ghweghwe na yeye mliyeka. Ang'akutegheletsa, katsakuwa ndughu yako keli. ");
INSERT INTO ruf_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Lekeni ang'alema kukutegheletsa, umsole imunu yumwe au weli hamwe naghwe, ili ‘kwa iwakalangama weli au wadatu ghomba lilamlighwe,’ ka Ghamaandiko Mahenzeluka pfagholonga. ");
INSERT INTO ruf_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ang'alema kuwategheletsa ulilongele kanisa, na ka kolema kuwategheletsa iwanu we Imulungu, kuna ghweghwe mleke yawe ka imunu ing'ammanyile Imulungu au imsola kodi. ");
INSERT INTO ruf_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Nowalongelani ghendo, ghoghose ghamuhinda muisi ghatsohindighwa kulanga, na ghoghose ghampfughula muisi, ghatsopfughulighwa kulanga. ");
INSERT INTO ruf_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Nowalongelani keli, ka weli wenu wetoghola muisi kulomba ichinu chochose, Aba wangu iyali kulanga katsowatendela. ");
INSERT INTO ruf_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kwaapfila hanu hohose hawetingana iwanu weli au wadatu kwa taghwa lyangu, Nene nahamwe nawo.” ");
INSERT INTO ruf_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kuya Petiri kamghendela Yesu, kamghutsa, “Imtwatsa, apfi ndughu yangu ang'anitendela ghamatotso, nitsomlekelela mala ngapi? Hata mala saba?” ");
INSERT INTO ruf_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu kamwidika, “Nokulongela si mala saba bae, ila saba mala sabini, ");
INSERT INTO ruf_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","kwaapfila undewa we Imulungu weghala na Imndewa yumwe iyabamile kukaghula tsisendi tsake tsawalinatso iwatumwa wake. ");
INSERT INTO ruf_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Hayanduse kupeta, kaghalighwa imunu yumwe iyang'ali yomdahi sendi milioni nyingi. ");
INSERT INTO ruf_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Naye kwaapfila tsakahela chinu che ukuliha, imndewa kalaghitsa yahutsighwe, yeye, mwehe wake ne iwanaghe na pfose pfayalinapfo, ili yalihe deni. ");
INSERT INTO ruf_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Apfo imtumwa ayo katowa ghamaghoti hambele hake, kalonga, ‘Unidudumile, nitsokuliha chila chinu.’ ");
INSERT INTO ruf_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Imndewa yula kamwonela libatsi, kamleghusila deni lila, kamleka yoke. ");
INSERT INTO ruf_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Lekeni imunu ayo koka, kuya ketingana ne imtumwa miyaghe iyang'ali yomdahi sendi chidogho. Kamghogha kamkinda halumelo. Kalonga, ‘Unilihe sendi tsangu!’ ");
INSERT INTO ruf_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Imtumwa miyaghe kamtowela ghamaghoti, kamlomba, ‘Unidudumile, nitsokuliha.’ ");
INSERT INTO ruf_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Lekeni yeye kalema, kaghenda kumwika miyaghe mchifungo, mbaka hayatsoliha deni lila. ");
INSERT INTO ruf_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Iwatumwa wangi hawonile achila ichilawile, wasing'inika sideke, waghenda kumlongela imndewa chila chinu ichilawile. ");
INSERT INTO ruf_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Kuya imndewa kamkema mng'anda imtumwa ayo, kamlongela, ‘Ghweghwe imtumwa wihile. Nikuleghusila deni lyose kwaapfila tsakunilomba nitende apfo. ");
INSERT INTO ruf_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Tsakubamighwa umwonele libatsi imtumwa miyagho ka nene pfanikwonele libatsi.’ ");
INSERT INTO ruf_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Apfo imndewa ayo kona maya sideke, kamwika mchifungo yadununzighwe mbaka hayatsoliha deni lyose.” ");
INSERT INTO ruf_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Kuya Yesu kaghendelela kulonga, “Apfi pfifo Aba wangu iyali kulanga pfayatsowatendelani mng'aleka kuwaleghusila wandughu tsenu ghamatotso ghawo kulawa mne mimoyo yenu.” ");
INSERT INTO ruf_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu hayamalitse kulonga mbuli atso, kalawa isi ya Galilaya kaghenda mne isi ya Yudeya, kumwambu kwe ghumto Yoridani. ");
INSERT INTO ruf_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Iwanu wengi wamuwinza, naye kawahonetsa. ");
INSERT INTO ruf_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mafarisayo wangi wamghendela Yesu wamghetse. Wamghutsa, “Angu pfinogha immale kumleka mwehe wake kwa totso lyolyose?” ");
INSERT INTO ruf_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu kawedika, “Ng'amsomile bae mne Ghamaandiko Mahenzeluka, ka kulawa mwanduso Imulungu tsakalumba immale ne ipinga? ");
INSERT INTO ruf_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Apfo Imulungu kalonga, ‘Kwa ichinu chino, mmale katsomleka aba wake na mai wake, katselunga na mwehe wake, nawo weli watsokuwa lukuli lumwe?’ ");
INSERT INTO ruf_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Apfo si weli keli, ila lukuli lumwe. Apfo chayalungile Imulungu, imunu yaleke kuchibaghula.” ");
INSERT INTO ruf_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Mafarisayo wamghutsa, “Ebali lelo Musa tsakalaghitsa immale yamwing'e mwehe wake talaka na kumleka?” ");
INSERT INTO ruf_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu kawedika, “Musa tsakawalekelela muwaleke wehe tsenu kwaapfila imimoyo yenu mikomu. Lekeni ng'aiwile pfino bae kulawa mwanduso. ");
INSERT INTO ruf_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nowalongelani, imunu wowose iyomleka mwehe wake, ila kwa ughoni, na ukukwela ipinga yungi, ayo kotenda ughoni.” ");
INSERT INTO ruf_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Iwanang'ina wake wamlongela, “Ka apfo pfipfo pfaili kwe immale na mwehe wake. Ng'apfu kuleka ukukwelela.” ");
INSERT INTO ruf_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu kawedika, “Si chila imunu bae iyodaha kuitoghola mbuli ino, ila awala iweng'ighwe ne Imulungu. ");
INSERT INTO ruf_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kuna ipfinu pfingi ipfiwatenda iwamale waleke kukwela, kwaapfila wamwenga welekighwa pfipfo, na wamwenga watendighwa apfo ne iwanu. Wamwenga ng'awokwela bae kwaajili ye undewa wa kulanga. Imunu iyodaha kuitoghola imbuli ino, leka yaitoghole.” ");
INSERT INTO ruf_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Kuya iwanu wangi wamghalila Yesu iwana wadowado awekile ghamoko na kuwalombela, lekeni iwanang'ina wake wawakembela iwanu awo iwawaghalile iwana. ");
INSERT INTO ruf_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesu kalonga, “Muwaleke iwana wadowado watse kuna nene, mleke kuwaghoma kwaapfila undewa wa kulanga wa iwanu iwali ka iwana wano.” ");
INSERT INTO ruf_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Kawekila ghamoko, kuya koka hanu aho. ");
INSERT INTO ruf_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Imunu yumwe kamghendela Yesu kamghutsa, “Mlangulitsi, angu nende choni chinoghile ili niubokele ughima wa ghamatsuwa ghose?” ");
INSERT INTO ruf_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu kamwidika, “Ebali kwonighutsa imbuli ye ichinu chinoghile? Hana yumwe yaliyeka iyanoghile. Ung'abama kwingila mne ughima wa ghamatsuwa ghose, ughakinde ghamalaghitso ghe Imulungu.” ");
INSERT INTO ruf_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Imunu yula kamghutsa, “Ghamalaghitso ghachi?” Yesu kamwidika, “Aghano, uleke kukoma, uleke ughoni, uleke ubapfi na uleke kulonga ughutsu, ");
INSERT INTO ruf_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","uwategheletse aba wako na mai wako, umnoghele miyagho ka pfawinoghela ghumwenyegho.” ");
INSERT INTO ruf_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Imsongolo yula kamlongela, “Agha ghose nighakinda. Lelo nitende choni keli?” ");
INSERT INTO ruf_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu kamwidika, “Ung'abama kuwa imunu yatimilike, ughende ukautse ipfinu pfako pfose, uweng'e tsisendi iwahingwa, naghwe kutsakuwa na hatsina kulanga. Kuya utse uniwinze.” ");
INSERT INTO ruf_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Imsongolo yula hayahulike apfo, koka kwa usungu, kwaapfila tsakana mali nyingi. ");
INSERT INTO ruf_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Kuya Yesu kawalongela iwanang'ina wake, “Nowalongela ghendo, itsakuwa pfikomu kwa tajiri kwingila mne undewa wa kulanga. ");
INSERT INTO ruf_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kuya nowalongelani, pfibewe kwe ingamiya kwingila mchonzo mwe sindano, kubita tajiri kwingila mne undewa we Imulungu.” ");
INSERT INTO ruf_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Iwanang'ina wake hawahulike apfo, wakangawala ghendo, wamghutsa, “Lelo yuhi iyodaha kukombolighwa?” ");
INSERT INTO ruf_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu kawalola kuya kawalongela, “Kwe imunu chinu chino ng'achidahika bae, lekeni kwe Imulungu ghose ghodahika.” ");
INSERT INTO ruf_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Petiri kamwidika, “Tuleka chila chinu twokuwinza ghweghwe. Lelo tutsopata choni?” ");
INSERT INTO ruf_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu kawalongela, “Nowalongelani ghendo, mne isi iikutsa, Imwana we Imunu hayatsokala hane chighoda chake cha utunitso, mwemwe imniwinzile nene pfipfila mtsokala mne pfighoda kumi na pfili, kughahigha makabila kumi na meli gha Isiraeli. ");
INSERT INTO ruf_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Na imunu wowose iyalekile tsing'anda, au kaka tsake, au lumbu tsake, au aba wake, au mai wake, au iwanaghe, au imighunda yake kwaajili yangu, ayo katsobokela mala kumi, na katsohala ughima wa ghamatsuwa ghose. ");
INSERT INTO ruf_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Lekeni awala wa mwanduso watsakuwa wa utsighilo, na wautsighilo watsakuwa wamwanduso. ");
INSERT INTO ruf_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Undewa we Imulungu weghala ne imunu yane mghunda, iyalawile lupfilipfili kaghenda kubama iwanu wakasang'ane mne mghunda ghwake. ");
INSERT INTO ruf_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Katoghola kuwaliha sendi tsa litsuwa limwe, kuya kawaghala mne mghunda ghwake. ");
INSERT INTO ruf_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Masaa madatu hambele koka keli, kawona iwanu wangi wema mne ghulilo wahela sang'ano. ");
INSERT INTO ruf_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Kawalongela, ‘Mwemwe mwose mghende mne mghunda ghwangu mkasang'ane, nitsowaliha pfinoghile.’ ");
INSERT INTO ruf_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Nawo waghenda. Kuya kaghenda keli saa sita na saa tisa, katenda pfipfila. ");
INSERT INTO ruf_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Haipfikile saa kumi na imwe koka keli, kawona iwanu wangi wema hane ghulilo, kawaghutsa, ‘Ebali mwimile hano misi yose bila sang'ano?’ ");
INSERT INTO ruf_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Iwanu awo wamwidika, ‘Kwaapfila haduhu imunu iyatwing'ile sang'ano.’ Kawalongela, ‘Namwe pfipfila mghende mkasang'ane mne mghunda ghwangu.’ ");
INSERT INTO ruf_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Nemihe haipfikile, imunu yane mghunda kamlongela mwimilitsi wake, ‘Uwakeme iwanu iwasang'ane, uwalihe sendi tsawo, wanduse na wautsighilo kuya awala iwalongole.’ ");
INSERT INTO ruf_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Iwanu iwasang'ane kwandusila saa kumi na imwe hawatsile, chila munu kabokela malilho gha litsuwa limwe. ");
INSERT INTO ruf_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Apfo awala iwalongole kusang'ana hawatsile, tsawalolela kubokela sendi nyingi, lekeni chila munu kabokela dinali imwe. ");
INSERT INTO ruf_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Hawabokele maliho ghawo, wandusa kumsing'inikila ayula yane mghunda. ");
INSERT INTO ruf_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Walonga, ‘Iwanu wano iwatsile kusang'ana nemihe, wasang'ana kwa saa limwe liliheka, lekeni kuwaliha ka pfautulihe twetwe itusang'ane misi yose mlutsua.’ ");
INSERT INTO ruf_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Naye kamwidika yumwe wawo, ‘Sale yangu, sikubunzile bae. Apfi ghweghwe ng'utoghole kusang'ana kwa malilho gha litsuwa limwe? ");
INSERT INTO ruf_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Lelo usole ichili chako uke. Nene nobama kumwing'a ayula wa utsighilo ka pfanikwing'ile ghweghwe. ");
INSERT INTO ruf_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Angu ng'apfinoghile bae nene kutenda achila chanibama kwa sendi tsangu mwenyegho? Au kwakona chepfu kwaapfila nene namluso?’ ” ");
INSERT INTO ruf_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Kuya Yesu kamalitsa kwa ukulonga, “Apfo, wa utsighilo katsakuwa wa mwanduso, na ayula wamwanduso katsakuwa wautsighilo.” ");
INSERT INTO ruf_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu hayang'ali yoghenda Yerusalemu kawasola iwanang'ina kumi na weli waliyeka, kawalongela, ");
INSERT INTO ruf_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Mlole, twogheluka Yerusalemu, ako Imwana we Imunu katsakwing'ighwa mne ghamoko ghe iwatambika wakulu ne iwalangulitsi we ghamalaghitso. Nawo watsomhigha yakomighwe. ");
INSERT INTO ruf_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Kuya watsomghala kwe iwanu iwali si Wayahudi, nawo watsombetsa, watsomtsipula na watsomkoma kwa kumuwamba mna msalaba, lekeni ghamatsuwa madatu hambele katsotsilihuka!” ");
INSERT INTO ruf_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Kuya mai we iwana wa Sebedayo kamghendela Yesu hamwe ne iwanaghe, katowa ghamaghoti, kamlomba amtendele choyobama. ");
INSERT INTO ruf_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu kamghutsa, “Ubama choni.” Ipinga ayo kamwidika, “Chondechonde, ulaghitse wanangu wano weli wakale ubali wako wa kujilo na wa kumoso mne undewa wako.” ");
INSERT INTO ruf_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu kawalongela, “Ng'ammanyile bae achila chamlomba. Angu mwodaha kunwela ichikombe chanitsonwela nene?” Wamwidika, “Twodaha.” ");
INSERT INTO ruf_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu kawalongela, “Mtsonwela ghendo ichikombe changu, lekeni kukala kumoso au kukala kujilo, si sang'ano yangu bae. Lekeni chinu acho watsakwing'ighwa awala iwasaghulighwe na Aba wangu.” ");
INSERT INTO ruf_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Iwanang'ina kumi hawahulike apfo, tsawawonela maya awala wandughu weli. ");
INSERT INTO ruf_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Lekeni Yesu kawakema, kawalongela, “Mwomanya ka iwabala we iwanu iwali si Wayahudi wowalongotsa iwanu wawo kwa ingupfu, na pfilongotsi wawo wana ukulu kuna wawo. ");
INSERT INTO ruf_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Lekeni ileke kuwa apfo kuna mwemwe, ila imunu wowose iyobama kuwa imkulu mghati mwenu, yawe mtumwa wenu, ");
INSERT INTO ruf_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","na imunu wowose iyobama kuwa wa mwanduso kobamighwa yawe mtumwa. ");
INSERT INTO ruf_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Pfipfo ka Imwana we Imunu, ng'atsile bae kutumikighwa, ila kutumikila na kulapfa ughima wake kuwakombola iwanu wengi.” ");
INSERT INTO ruf_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu ne iwanang'ina wake hawang'ali wakuka Yeriko, iwanu wengi tsawamuwinza. ");
INSERT INTO ruf_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Pfifita weli iwang'ali wokala mmbalimbali mwe inzila hawahulike Yesu kobita, wandusa kukemelela, “Imtwatsa, Mwana wa Daudi, utwonele libatsi!” ");
INSERT INTO ruf_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Iwanu wawakembela wawalongela wanyamale, lekeni waghendelela kukemelela, “Imtwatsa, Mwana wa Daudi utwonele libatsi!” ");
INSERT INTO ruf_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu kema, kawakema kawaghutsa, “Mwobama niwatendele choni?” ");
INSERT INTO ruf_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Wamwidika, “Imtwatsa, twobama twone!” ");
INSERT INTO ruf_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesu kawonela libatsi, katsikinda nenge tsawo, bahala wadaha ukwona, nawo wamuwinza. ");
INSERT INTO ruf_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu ne iwanang'ina wake hawang'ali habehi na Yerusalemu na kupfika Betifage mne Chidunda cha Mitseituni, kawatuma iwanang'ina wake weli, ");
INSERT INTO ruf_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","kawalongela, “Mghende mbaka mne kaye ili hambele henu, baho mtsomwona ipunda kohighwa hamwe ne imwanaghe, muwadohole mngalile hano. ");
INSERT INTO ruf_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Imunu wowose ang'awalongela chochose, mumlongele, ‘Imtwatsa kowabama,’ naye katsowaleka mke.” ");
INSERT INTO ruf_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Achino chilawila ili aghala ighalongighwe na manabii ghatimile. ");
INSERT INTO ruf_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Umlongele neghe Sayuni, Lola, Mndewa wako kokutsila, Kahola na kadina ipunda, imwanapunda, imwana we ipunda.” ");
INSERT INTO ruf_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Apfo iwanang'ina waghenda watenda ka Yesu pfayawalongele. ");
INSERT INTO ruf_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Wamghala ipunda ne imwana we ipunda, weka ghamaghwanda ghawo mchanya mwe punda awo, na Yesu kakala mchanya mwake. ");
INSERT INTO ruf_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Iwanu wengi wagheka ghamaghwanda ghawo mnzila na wangi waghana milala wanzasa mnzila. ");
INSERT INTO ruf_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Na iwanu iwamlongole na awala iwamuwinzile wose wandusa kukemelela, walonga, “Yatogholighwe, Imwana wa Daudi! Imulungu kambaliki ayula iyakutsa kwa taghwa lye Imtwatsa! Yatogholighwe Imulungu yali kuchanya kulanga!” ");
INSERT INTO ruf_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu hayengile Yerusalemu, iwanu wose wakangawala, weghutsa, “Ayu nani?” ");
INSERT INTO ruf_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Iwanu wawedika, “Ayuno nabii, Yesu wa Natsareti ya Galilaya.” ");
INSERT INTO ruf_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu kengila mne Ing'anda ye Imulungu kawawinga wose awala iwang'ali woghula na iwang'ali wohutsa. Katsibindula tsimetsa tsawo tsa ukubenela tsisendi na ipfighoda pfa awala iwang'ali woutsa iwanjiwa. ");
INSERT INTO ruf_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Kawalongela, “Yandikighwa, ‘Ing'anda yangu itsokemighwa ing'anda ya ukulombela.’ Lekeni mwemwe mwoitenda iwe mango ye iwabapfi!” ");
INSERT INTO ruf_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ipfifita na ipfimbete wamghendela Yesu mne Ing'anda ye Imulungu, naye kawahonetsa. ");
INSERT INTO ruf_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Lekeni iwatambika wakulu na iwolangulitsa ghamalaghitso tsawona maya hawonile pfinu pfa kukangawatsa pfayatendile Yesu, ne iwana pfawakemelele mne ing'anda ye Imulungu, “Yatogholighwe Imwana wa Daudi!” ");
INSERT INTO ruf_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Apfo wamghutsa Yesu, “Apfi kohulika chawolonga iwana wano?” Kawedika, “Ona, ng'amsomile bae? ‘Kwa milomo ye iwana wadowado ne iwana iwakong'a kwotogholighwa ghendo.’ ” ");
INSERT INTO ruf_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yesu kawaleka kaghenda Betaniya, kunze kwe ghumji, kawasa kuko. ");
INSERT INTO ruf_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Nemitondo lupfilipfili, Yesu hayang'ali kakuya mne ghumji, tsakona inzala. ");
INSERT INTO ruf_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Kaghwona mbiki mmbalimbali mwe inzila, kaghughendela lekeni ng'onile chochose bae ila imitsani iliyeka. Apfo kaghulongela, “Uleke ukweleka keli ghamatunda!” Bahala mbiki ghula ghunyala. ");
INSERT INTO ruf_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Iwanang'ina wake hawonile apfo wakangawala, wamghutsa, “Ule mbiki ghuno ghusumka kunyala?” ");
INSERT INTO ruf_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu kawedika, “Nowalongelani ghendo mng'atoghola na kuleka kwalangula, mwodaha kutenda si achila chiliyeka ichanendile mne mbiki, ila mwodaha kuchilongela chidunda chino, ‘Wibule, wikeyase mwibahali,’ kuya itsakuwa pfipfo. ");
INSERT INTO ruf_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Mng'atoghola, chochose chamlomba mtsobokela.” ");
INSERT INTO ruf_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu kengila mne ing'anda ye Imulungu, na hayang'ali yolangulitsa, iwatambika wakulu na iwakulu we iwanu wamghendela, wamghutsa, “Kwa ukulu wachi kotenda ghano ghose? Yuhi yakwing'ile ukulu uno?” ");
INSERT INTO ruf_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu kawedika, “Na nene nitsowaghutsa imbuli imwe, mng'anyidika, nitsowalongela notenda ghano kwa ukulu wachi. ");
INSERT INTO ruf_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Apfi ubatitso wa Yohane ulawile kwani? Tsaulawa kulanga au kwe iwanu?” Wandusa kwighutsa iwenyegho kwe iwenyegho walonga, “Tung'alonga, ‘Ulawa kulanga,’ katsotughutsa, ‘Ule lelo ng'amumtoghole Yohane?’ ");
INSERT INTO ruf_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Lekeni tung'alonga, ‘Ulawa kwe iwanu,’ twopfuka iwanu, kwaapfila wose tsawatoghola Yohane kakala nabii.” ");
INSERT INTO ruf_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Apfo wamwidika Yesu, “Ng'atumanyile bae.” Naye kawedika, “Na nene siwalongela bae kwa ukulu wachi notenda ipfinu apfi. ");
INSERT INTO ruf_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Mkonatse? Imunu yumwe tsakana iwana weli, kaghenda kwa ayula mwana mkulu kamlongela, ‘Mwanangu, leloli ughende ukasang'ane mne mghunda.’ ");
INSERT INTO ruf_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Naye kamwidika, ‘Sighenda bae,’ lekeni hambele chidogho kaghaluka kaghenda. ");
INSERT INTO ruf_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Kuya aba ayo kamghendela imwana wa keli, kamlongela ichinu chichila. Naye kamwidika, ‘Ona aba,’ lekeni ng'aghendile bae. ");
INSERT INTO ruf_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Lelo yuhi mna iwana wano weli iyatendile achila chayabamile aba wake?” Wamwidika, “Imwana imkulu.” Yesu kawalongela, “Nowalongelani ghendo, iwasola kodi na iwaghoni watsowalongola kwingila mne undewa we Imulungu. ");
INSERT INTO ruf_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kwaapfila Yohane tsakatsa kuwalangusa inzila inoghile, namwe ng'amumtoghole bae, lekeni iwasola kodi na iwaghoni wamtoghola. Namwe hata hamwonile apfo, ng'amghaluke bae na kumtoghola.” ");
INSERT INTO ruf_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesu kalonga, “Mtegheletse imbuli ingi, imunu yumwe yane ing'anda kahanda tsabibu mne mghunda. Kaghuteghela luwa mghunda agho, kahimba lipondo lya ukukamila tsabibu, katsenga ghumnala, kawakodishila iwanu iwolima, kuya koka ghumwanza. ");
INSERT INTO ruf_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ghamatsuwa gha ukupfuna haghapfikile, kawatuma iwatumwa wake wakasole tsabibu. ");
INSERT INTO ruf_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Hawala iwanu iwolima wawaghogha iwatumwa wake, yumwe wamtowa, yungi wamkoma, na yungi wamtowa na ghamabwe. ");
INSERT INTO ruf_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kuya tsakawatuma keli watumwa wangi, tsawengi kubita awala wamwanduso, na iwanu wala iwolima wawatendela pfipfila. ");
INSERT INTO ruf_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Hawamalile wose ghendo, kamtuma imwanaghe kuna wawo, kalonga, ‘Watsomtegheletsa mwanangu.’ ");
INSERT INTO ruf_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Lekeni iwanu iwolima hawamwonile, welongela iwenyegho, ‘Ayuno iye muhala, mtse tumkome tusole uhala wake!’ ");
INSERT INTO ruf_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Apfo wamghogha, wamwasa kunze kwe mghunda ghwe imitsabibu, wamkoma. ");
INSERT INTO ruf_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Lelo, imunu yane mghunda hayatsakutsa, yatsowatenda choni awala iwanu iwolima?” ");
INSERT INTO ruf_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Wamwidika, “Katsowakoma ghendo iwanu awo wehile, katsoweka iwanu wangi mne mghunda aghwo, nawo watsomgholela tsitsabibu mne ghamatsuwa ghe kupfuna.” ");
INSERT INTO ruf_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesu kawalongela, “Ng'amsomile bae Ghamaandiko Mahenzeluka, ‘Libwe ililemighwe na iwatsengagha liwa libwe kulu lye lukwalambatsa. Imbuli ino ilawa kwe Imulungu, nayo yotukangawatsa.’ ");
INSERT INTO ruf_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Apfo nowalongelani ghendo, undewa we Imulungu utsobokighwa kuna mwemwe na kwing'ighwa iwanu iwakweleka ghamatunda ghake, awala iwotenda aghala ghobama Imulungu. ");
INSERT INTO ruf_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Na ayula iyakughwa mchanya mwe libwe lino katsobeneka beneka, na wowose ilitsomghwila litsomhonda.” ");
INSERT INTO ruf_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Watambika wakulu na Mafarisayo hawahulike apfo, tsawamanya Yesu tsaang'ali yowalonga wawo. ");
INSERT INTO ruf_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Apfo wabama inzila ya kumghoghela, lekeni wapfuka iwanu, kwaapfila iwanu tsawamona Yesu tsakakala nabii. ");
INSERT INTO ruf_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu kawalongela keli iwanu kwa imbuli. ");
INSERT INTO ruf_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Undewa we Imulungu weghala ne Imndewa iyamtendele mwanaghe chihungo cha ukukwela. ");
INSERT INTO ruf_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Kawatuma iwatumwa wake wawalongele awala iwakemighwe watse kune chihungo, lekeni walema ukutsa. ");
INSERT INTO ruf_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Kuya kawatuma iwatumwa wangi, kalonga, ‘Muwalongele pfino awala iwakemighwe kune chihungo, nyambika ipfijo. Wang'ombe wangu iwanenehe wachinjighwa, na chila chinu chaghoya. Mtse kuchihungo.’ ");
INSERT INTO ruf_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Lekeni iwanu awo ng'awalangitse bae, woka, yumwe kune mghunda wake na yungi kune sang'ano tsake. ");
INSERT INTO ruf_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Nawo iwanu iwakalile wawaghogha iwatumwa wake, wawatendela pfihile na wawakoma. ");
INSERT INTO ruf_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Imndewa ayo tsakona maya. Apfo kawatuma asikali wake wawakome awala iwawakomile iwatumwa wake, na wailakatsa isi yawo. ");
INSERT INTO ruf_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Kuya kawakema iwatumwa wake kawalongela, chihungo cha ukukwela ma cha tiyali, lekeni awala iwakemighwe watse kune ichihungo ng'awatsile bae. ");
INSERT INTO ruf_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Apfo, mghende kunzila, ako wowose wamuwona muwakeme watse kune ichihungo. ");
INSERT INTO ruf_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Iwatumwa wala woka, waghenda mne tsinzila wawaghala wanu wose yawawonile, iwehile na iwanoghile, na chihungo tsachimema iwahenza. ");
INSERT INTO ruf_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Imndewa hayengile mng'anda kuwalolesa iwahenza wake, kamwona imunu yumwe, ng'apfalile bae lighwanda lye ichihungo. ");
INSERT INTO ruf_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kamghutsa, ‘Sale yangu, angu wingiletse hano naghwe kwahela lighwanda lye ichihungo?’ Lekeni imunu ayo ng'alongile chinu bae. ");
INSERT INTO ruf_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Kuya imndewa kawalongela iwatumwa, ‘Mmwowe ghamoko na ghamaghulu mmwase kunze kune chisi. Ako kutsakuwa ne ichililo ne ukughegheda ghamatsino.’ ” ");
INSERT INTO ruf_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Kuya Yesu kalonga, “Kwaapfila iwakemighwe wengi, lekeni iwasaghulighwe wadodo.” ");
INSERT INTO ruf_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Apfo Mafarisayo woka na wabama inzila ye ukumtegha Yesu kwa mbuli tsake. ");
INSERT INTO ruf_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Kuya wawatuma iwanang'ina wawo hamwe ne iwanu wangi wa kingili lya Herodi. Walonga, “Mlangulitsi, twomanya ghendo ghweghwe kolongesa. Naghwe koilangulitsa pfinoghile inzila ye Imulungu, ng'upfuka bae ukulu we imunu wowose, kwaapfila ng'ulola bae ipfihanga pfe iwanu. ");
INSERT INTO ruf_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Utulongele lelo, ukonatse? Apfi pfinogha kuliha kodi kwa Kaisari, au ng'apfinoghile bae.” ");
INSERT INTO ruf_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Lekeni Yesu tsakamanya ukwiha kwawo, apfo kawalongela, “Mwawang'enye, ule mwobama kunitegha? ");
INSERT INTO ruf_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Nanguseni sendi yamlihila kodi!” Wamghalila isendi, ");
INSERT INTO ruf_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Naye kawaghutsa, “Angu chihanga na taghwa lino pfa nani?” ");
INSERT INTO ruf_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Wamwidika, “Pfa Kaisari mndewa wa Roma.” Apfo Yesu kawalongela, “Lelo, mwing'eni Kaisari aghala gha Kaisari na mwing'eni Imulungu aghala ghe Imulungu.” ");
INSERT INTO ruf_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Hawahulike apfo, wakangawala, apfo wamleka, woka tsawo. ");
INSERT INTO ruf_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Litsuwa lilyo, Masadukayo wamwenga, iwanu iwolonga kuduhu kutsilihuka, wamghendela Yesu. ");
INSERT INTO ruf_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Wamghutsa walonga, “Mlangulitsi, Musa katulongela immale ang'afa bila kweleka iwana, ndughu yake kobamighwa amkwele chitsuka ayo, ili amwelekele indughu yake iwana. ");
INSERT INTO ruf_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Lelo, hakaye hetu hano tsahana iwandughu saba. Wamwanduso kakwela, kuya kafa, na kwaapfila tsakahela iwana, mwehe wake kamlekela ndughu yake. ");
INSERT INTO ruf_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Chinu chichila chimlawila ndughu yake wa keli, wa kadatu, mbaka ndughu yake wa saba. ");
INSERT INTO ruf_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kuya mwehe ayo naye kafa. ");
INSERT INTO ruf_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Lelo iwanu hawotsotsilihuka mne litsuwa lya kutsilihuka, mwehe ayo katsokuwa wa yuhi mna iwandughu wano saba? Kwaapfila wose tsawamkwela.” ");
INSERT INTO ruf_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu kawedika, “Mwakwagha, kwaapfila ng'amanyile bae Ghamaandiko Mahenzeluka au ngupfu ye Imulungu. ");
INSERT INTO ruf_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kwaapfila iwanu hawatsotsilihuka, kuduhu ukukwela wala ukukwelighwa, watsokuwa ka malaika iwali kulanga. ");
INSERT INTO ruf_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Lekeni, imbuli yo ukutsilihuka kwe iwanu, ng'amsomile bae achila chayamlongeleni Imulungu? Kawalongela, ");
INSERT INTO ruf_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Nene na Imulungu wa Abrahamu, na Imulungu wa Isaka, na Imulungu wa Yakobu.’ Yeye si Imulungu wa iwanu iwafile bae, ila Imulungu we iwanu waghima.” ");
INSERT INTO ruf_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Iwanu hawahulike apfi, wakangawala kwa ghamalangulitso ghake. ");
INSERT INTO ruf_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Mafarisayo hawahulike ka Yesu kawatenda Masadukayo wenyamale, wetingana hamwe, ");
INSERT INTO ruf_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","yumwe wawo, imlangulitsi we Ghamalaghitso, kamghutsa Yesu kwa kumtegha. ");
INSERT INTO ruf_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Kamghutsa, “Mlangulitsi, ihi indaghitso ng'ulu kubita tsose mne Ghamaandiko Mahenzeluka?” ");
INSERT INTO ruf_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu kedika, “ ‘Mnoghele Imtwatsa Imulungu wako kwa ghumoyo ghwako ghose, kwa muhe wako wose, na kwa tsimbutsi tsako tsose.’ ");
INSERT INTO ruf_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Aino iyo indaghitso ng'ulu na ya mwanduso. ");
INSERT INTO ruf_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Na ya keli ighala na ino, umnoghele miyagho ka pfawinoghela imwenyegho. ");
INSERT INTO ruf_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ghamalaghitso ghose gha Musa na ghamalangulitso ghe manabii ghohuwila Ghamalaghitso ghano meli.” ");
INSERT INTO ruf_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mafarisayo hawetingane hamwe, Yesu kawaghutsa, ");
INSERT INTO ruf_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Mwemwe mmwonatse Kiristu. Angu imwana wa nani?” Wamwidika, “Imwana wa Daudi.” ");
INSERT INTO ruf_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu kawaghutsa, “Ule lelo Daudi kwa kulongotsighwa na ghumuhe kamkema ‘Imtwatsa?’ Kwaapfila tsakalonga, ");
INSERT INTO ruf_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Imtwatsa kamlongela Imtwatsa wangu, ukale hano hane ghumoko ghwangu ghwa kujilo mbaka niweke iwokuhila hasi he ghamaghulu ghako.’ ");
INSERT INTO ruf_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ka Daudi komkema, ‘Imtwatsa,’ lelo ikuwatse awe imwanaghe?” ");
INSERT INTO ruf_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kuduhu imunu yamwidike, na kulawa litsuwa alyo na kughendela kuduhu imunu yadahile kumghutsa Yesu imbuli yoyose. ");
INSERT INTO ruf_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Kuya Yesu kawalongela iwanu na iwanang'ina wake. ");
INSERT INTO ruf_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Iwolangulitsa Ghamalaghitso na Mafarisayo wana ukulu wa kulangulitsa Malaghitso gha Musa. ");
INSERT INTO ruf_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Apfo mghakinde na mtende aghala ghose ghawowalongela, lekeni mleke kutenda aghala ghawotenda wawo, kwaapfila ng'awotenda bae aghala ghawolonga. ");
INSERT INTO ruf_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Wakowa imitsigho mitito na kuwatwika iwanu mmahegha mwawo. Lekeni wawo iwenyegho ng'awobama bae hata kugholosa chidole na kuinula. ");
INSERT INTO ruf_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ghose ghawotenda, wotenda ili iwanu wawone, kwaapfila wopfala ipfinu ipfandikighwe Ghamalaghitso mne pfihanga pfawo na mne ghamoko ghawo, na wakongetsa utali we ghamaghwanda ghawo. ");
INSERT INTO ruf_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Wonoghela kukala hanu hanoghile mne chihungo na kukala mne pfighoda ipfili hambele mne tsing'anda tsa ukulombela. ");
INSERT INTO ruf_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Wonoghela kulamsighwa mmasoko na kukemighwa ne iwanu, ‘Mlangulitsi.’ ");
INSERT INTO ruf_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Lekeni mwemwe mleke kukemighwa ‘Mlangulitsi,’ kwaapfila mna Mlangulitsi yumwe yaliyeka, na mwemwe mwose mwawandughu. ");
INSERT INTO ruf_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Wala mleke kumkema imunu ‘aba’ hano muisi, kwaapfila mna ‘Aba’ yumwe yaliyeka, naye ka kulanga. ");
INSERT INTO ruf_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Na mleke kukemighwa ‘Ipfilongotsi’ kwaapfila mna ichilongotsi yumwe yaliyeka, naye Kiristu. ");
INSERT INTO ruf_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Na imkulu mghati mwenu kobamighwa yawe mtumwa wenu. ");
INSERT INTO ruf_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Na imunu wowose yetenda mkulu, katsotendighwa mdodo, na wowose yetenda mdodo, katsotendighwa mkulu. ");
INSERT INTO ruf_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Mtsoghaya mwemwe yamlangulitsa Ghamalaghitso na Mafarisayo! Mwawang'enye! Kwaapfila mowahindila iwanu libani lya undewa wa kulanga, na mwemwe iwenyegho ng'amkwingila bae, wala ng'amuwalekelela awala iwobama kwingila. ");
INSERT INTO ruf_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Mtsoghaya mwemwe yamlangulitsa Ghamalaghitso na Mafarisayo! Mwawang'enye! Mwemwe mwakuja mne tsing'anda tse pfitsuka na kwa ung'enye hamlomba mwolonga mbuli nyingi! Apfo mtsohighighwa ng'ani! ");
INSERT INTO ruf_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Mtsoghaya, yamlangulitsa Ghamalaghitso na Mafarisayo! Mwawang'enye mwemwe! Mwoloka ibahali na mwakwanga mne isi yose kumtenda imunu yumwe iyaiwinze dini yenu, na ang'aghaluka, mwomtenda yawe na uwetso mala mbili wa ukwingila Jehanamu kubita mwemwe wenyegho ");
INSERT INTO ruf_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Mtsoghaya mwemwe pfilongotsi pfifita. Mwolonga, ‘Imunu ang'elaha kwe ing'anda ye Imulungu si chinu bae, ila ang'elaha kwe inzahabu ye ing'anda ye Imulungu keyowa.’ ");
INSERT INTO ruf_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mwemwe mwawabotsi na pfifita! Chihi ichinoghile, inzahabu au ing'anda ye Imulungu iitenda inzahabu ideghete? ");
INSERT INTO ruf_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Pfipfila mwolonga, imunu ang'elaha kwa hanu hakutambikila si chinu bae, ila ang'elaha kwa nambiko iili hanu ha kutambikila, ayo keyowa. ");
INSERT INTO ruf_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mwapfifita mwemwe! Chini chikulu nambiko au hanu ha kutambikila hakutenda nambiko ideghete? ");
INSERT INTO ruf_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Apfo ayula yelaha kwa hanu ha kutambikila, kelaha kwa chila chinu ichili mchanya mwake, ");
INSERT INTO ruf_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","na ayula yelaha kwe ing'anda ye Imulungu, kelaha kwe ing'anda ayo, na kwa Imulungu iyokala mghati mwake. ");
INSERT INTO ruf_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Na ayula yelaha kwa kulanga kelaha kwa chighoda che undewa che Imulungu na kwa Imulungu iyochikalila. ");
INSERT INTO ruf_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Mtsoghaya mwemwe imlangulitsa Ghamalaghitso, na Mafarisayo! Wang'enye! Kwaapfila mwolapfa tsaka ya pfinu pfidodo ka imitsani iinung'ila ghoya, binzali na kalafuu, lekeni mwoleka kutsikinda mbuli ng'ulu tsa Ghamalaghitso ka pfila haki, libatsi ne ukutoghola. Mghatende agha, na mleke kughaleka aghala ghangi. ");
INSERT INTO ruf_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Pfilongotsi pfifita! Mwolapfa ng'onzi mne ghamatsi, lekeni mwometsa ingamiya! ");
INSERT INTO ruf_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Mtsoghaya, mwemwe yamlangulitsa Ghamalaghitso na Mafarisayo! Mwawang'enye, mwohopfugha chikombe na chiha kwa kunze, lekeni mwoleka mghati mmema ipfinu pfampatile kwa kuboka na ubwa. ");
INSERT INTO ruf_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ghwe Mfarisayo chipfita! Tanu wopfughe mghati mwe ichikombe ne ichiha, kuya kunze kutsodegheta. ");
INSERT INTO ruf_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Mtsoghaya, mwemwe yamlangulitsa Ghamalaghitso na Mafarisayo, mwawang'enye, mwighala ne tsikabuli itsibakigwe ichokaa, kunze tsakwoneka tsinogha, lekeni mghati tsimema imipate ye iwanu iwafile na chila chinu chihile. ");
INSERT INTO ruf_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Namwe pfipfila, kunze mwakoneka kwe iwanu ka mnogha lekeni mghati mwenu, mmema ung'enye na ghehile. ");
INSERT INTO ruf_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Mtsoghaya, mwemwe yamlangulitsa Ghamalaghitso, na Mafarisayo, mwawang'enye! Mowatsengela tsikabuli manabii na kutsighela unzolingo tsikabuli tse iwanu iwanoghile. ");
INSERT INTO ruf_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Namwe mwolonga, ‘Tung'akalile mne ghamatsuwa gha iwabala wetu, tung'alekile kwilunga nawo kuwakoma manabii!’ ");
INSERT INTO ruf_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Apfo mwelangusa iwenyegho ka mwa watsukulu wa awala yawawakomile manabii, ");
INSERT INTO ruf_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","lelo mghendeletse achila chawatendile iwabala wenu. ");
INSERT INTO ruf_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Mwemwe iwanzoka na iwana we iwanzoka! Mtsohepatse ukuhighighwa Jehanamu? ");
INSERT INTO ruf_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Apfo nowaghalilani manabii, ne iwanu wane nzewele, na iwalangulitsi. Wangi wawo mtsowakoma na wangi mtsowawamba mna misalaba, wangi mtsowatowa pfiboko mne tsing'anda tsenu tse ukulombela na kuwawinga kulawa ghumji ghuno kughenda ghumji ghungi. ");
INSERT INTO ruf_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Na idamu ye iwanu iwanoghile ikwitike muisi itsodaighwa kuna mwemwe, kulawa idamu ya Abeli ayula yanoghile, mbaka idamu ya Sakariya imwana wa Balakiya yamumkomile haghati he ing'anda ye Imulungu na hanu he ukulapfila inambiko. ");
INSERT INTO ruf_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nowalongelani ghendo, mweleko ghuno ghutsohighighwa kwaajili ya agho. ");
INSERT INTO ruf_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Ghwe Yerusalemu, Yerusalemu! Ghweghwe yuwakomile manabii na kuwatowa ghamabwe awala iwatumighwe kuna ghweghwe, mala nyingi tsambama kuweka hamwe iwana wako, ka ing'uku pfowafunamila pfitsiya wake kwa ghamabawa ghake, lekeni ghweghwe, ng'aubamile bae. ");
INSERT INTO ruf_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Mlole, ing'anda yenu ye Imulungu ilekighwa uchuwa. ");
INSERT INTO ruf_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kwaapfila nowalongelani, ng'amtsombona keli bae mbaka mlonge, ‘Kabalikighwa ayula iyakutsa kwa taghwa lye Imtwatsa.’ ” ");
INSERT INTO ruf_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu kalawa mne ing'anda ye Imulungu, na hayang'ali yakuka, iwanang'ina wake wamghendela wamlanguse matsengo ghe ing'anda ye Imulungu, ");
INSERT INTO ruf_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yesu kawaghutsa, “Angu mwoghona agha ghose? Nowalongelani ghendo, kuduhu libwe ilitsolekighwa mchanya mwa liyaghe, chila libwe litsokwasighwa hasi.” ");
INSERT INTO ruf_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu hayang'ali kakala mne Chidunda cha Mitseituni, iwanang'ina wake wamghendela waliyeka wamghutsa, “Utulongele, agha ghose ghatsolawila tsuwachi? Na chihi chitsakuwa chitango cha ukutsa kwako na ukumala kwe iisi?” ");
INSERT INTO ruf_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu kawedika, “Mwalangitse, imunu yaleke kuwaghutsukila. ");
INSERT INTO ruf_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kwaapfila iwanu wengi watsakutsa kwa taghwa lyangu na ukulonga wawo iwo Kiristu Imkombotsi, na watsowaghutsukila iwanu wengi. ");
INSERT INTO ruf_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mtsohulika tsing'ondo na mbuli tsake, lekeni mleke kupfuka. Agho ghose ghobamighwa ghalawile, lekeni ukumala kwe iisi ng'ana kupfike bae. ");
INSERT INTO ruf_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Isi ingi itsetowa na isi ingi, undewa ungi witsetowa na undewa ungi. Kutsolawila inzala ng'ulu na mdedemo we isi chila hanu. ");
INSERT INTO ruf_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Agha ghose ka mwanduso wa usungu wa ukweleka imwana. ");
INSERT INTO ruf_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Kuya mtsoghoghighwa na kudunuzighwa na kukomighwa. Na isi tsose tsitsowahila kwaajili ya nene. ");
INSERT INTO ruf_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ghamatsuwa agho iwanu wengi watsoleka ukutoghola kwawo, na watsehunduka na wetsehila, ");
INSERT INTO ruf_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","na manabii wengi wa ughutsu watsolawila na kuwaghutsukila iwanu wengi. ");
INSERT INTO ruf_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kwaajili ye ukongetseka ghehile, unoghelo we iwanu utsohunguka, ");
INSERT INTO ruf_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","lekeni ayula iyodudumila mbaka utsighilo katsokombolighwa. ");
INSERT INTO ruf_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Na Imbuli ino Inoghile ya undewa itsopetighwa mne isi yose ka ukalangama kwe isi tsose, kuya ukumala kwe iisi kutsakutsa. ");
INSERT INTO ruf_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Mtsakona, ‘lideso lya ukuhinya’ lyalongile nabii Danyeli, litsakwima hanu haenzeluke, ayula iyosoma amanye. ");
INSERT INTO ruf_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Kuya iwanu iwali mne isi ya Yudeya watsumile mpfidunda. ");
INSERT INTO ruf_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Na iyali mchiswili mwe ing'anda yake, aleke kuhulumka kusola chinu chochose. ");
INSERT INTO ruf_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Yali kumghunda aleke kuya kusola lighwanda lyake. ");
INSERT INTO ruf_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Watsoghaya iwapinga wane tsiinda na awala iwakong'etsa mne ghamatsuwa agho. ");
INSERT INTO ruf_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mlombe ili kutsuma kwenu kuleke kuwa mne msimu wa chipfeghetsi au mne litsuwa lya Sabato. ");
INSERT INTO ruf_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kwaapfila kutsolawila maghayo ng'ana ghalawile bae kulawa isi hailumbighwe mbaka leloli, na ng'aghatsolawila keli bae. ");
INSERT INTO ruf_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ka ghamatsuwa agho ng'aghahungusighwe bae kuduhu imunu yang'akomboke. Lekeni kwaajili ye iwanu wala iwasaghulighwe, ghamatsuwa agho ghatsohungutsighwa. ");
INSERT INTO ruf_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Imunu ang'awalongela, ‘Ulole, Kiristu Imkombotsi kahano!’ au ‘Kahala!’ mleke kutoghola. ");
INSERT INTO ruf_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kwaapfila tsina Kiristu wa ughutsu na manabii wa ughutsu watsolawila na kutenda pfitango pfingi na pfinu pfa kukangawatsa ili kuwaghutsukila iwanu, ka yodahika hata awala iwasaghulighwe ne Imulungu. ");
INSERT INTO ruf_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Muhulikitse! Nongola kuwalongelani imbuli ino ng'ana chipindi chipfike. ");
INSERT INTO ruf_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Apfo, Imunu wowose ang'akulongela, ‘Ulole, kakunyika!’ mleke kughenda, au ‘Kahano, mne chiheleto cha mghati,’ mleke kutoghola. ");
INSERT INTO ruf_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kwaapfila Imwana we Imunu katsakutsa ka lumwesa pfalumwemwesa mlanga mwose, kulawa ubali wa kwalilawila litsua mbaka ubali wa kwalikuswela litsua. ");
INSERT INTO ruf_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Hohose hane mtsogha, pfimanga watsetingana. ");
INSERT INTO ruf_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Bahala ghamatsuwa agho gha ghamaghayo aghatsomala, litsua litsoghumighwa ichisi, na lwetsi ng'alutsolapfa bae ghumwanga, tsinondo tsisolaghala kulawa mlanga na tsingupfu itsili kulanga tsitsohighisighwa. ");
INSERT INTO ruf_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Chipindi acho, chitango che Imwana we Imunu chitsolawila mlanga na isi tsose tsitsolila, iwanu watsomwona Imwana we Imunu kakutsa mna ghamawingu mlanga, hamwe ne ingupfu na utunitso mkulu. ");
INSERT INTO ruf_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Naye katsowatuma wamalaika wake wane malati ilikemela sideke, nawo watsoweka hamwe awala iwasaghulighwe kulawa chila ubali we iisi, kulawa utsighilo uno we lilanga mbaka utsighilo ungi. ");
INSERT INTO ruf_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Mwilangulitse imbuli ino kulawa mne mbiki ghwa mkuyu, ghamaputila ghake haghakuwa madeke na kwandusa kutsuka, mwomanya mvula tsahabehi. ");
INSERT INTO ruf_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Pfipfila, hamkona agha ghose mmanye chipindi cha habehi ghendo. ");
INSERT INTO ruf_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nowalongelani ghendo, iwanu wa mweleko ghuno ng'awatsoluta bae mbaka agha ghose ghalawile, ");
INSERT INTO ruf_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","lilanga ne isi pfitsoluta lekeni mbuli tsangu ng'atsitsoluta mbe. ");
INSERT INTO ruf_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Kuduhu imunu iyomanya litsuwa wala isaa ayo, hata wamalaika wa kulanga, wala Imwana, ila Aba yaliyeka iyomanya. ");
INSERT INTO ruf_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ka pfailawile mne ghamatsuwa gha Nuhu, itsakuwa pfipfo hayatsakutsa Imwana we Imunu. ");
INSERT INTO ruf_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kwaapfila ghamatsuwa agho ng'ana ghamafuliko ghalawile, iwanu tsawang'ali wakuja na ukunwa, wokwela na kukwelighwa mbaka litsuwa lya Nuhu hengile mne safina. ");
INSERT INTO ruf_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ng'awamanyile bae choni ching'alawile mbaka ghamafuliko ghatsa na kuwasola wose. Apfi pfipfo pfaitsolawila hayatsakutsa Imwana we Imunu. ");
INSERT INTO ruf_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Iwanu weli watsakuwa kumghunda, yumwe katsosolighwa na yungi katsolekighwa. ");
INSERT INTO ruf_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Iwapinga weli watsotwanga hamwe, yumwe katsosolighwa na yungi katsolekighwa. ");
INSERT INTO ruf_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Apfo, mwalangitse, kwaapfila ng'ammanya bae litsuwa lyachi Imtwatsa wenu hayatsakutsa. ");
INSERT INTO ruf_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Lekeni mmanye apfi, ka mwenye kaye ang'amanyile imbapfi kakutsa tsuwachi, ang'akalile meso, na tsang'oileka bae ing'anda yake ibenighwe. ");
INSERT INTO ruf_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Pfipfila namwe mwiyandae, kwaapfila Imwana we Imunu katsakutsa mne isaa ng'amuilolele bae yatse.” ");
INSERT INTO ruf_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yesu kaghendelela kulonga, “Kuya yuhi imtumwa yotogholighwa na yane ihekima? Ayula imtwatsa wake yamwikile yawemile iwatumwa wangi mne ing'anda yake na kuweng'a ichijo chawo chipindi chinoghile. ");
INSERT INTO ruf_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kabweda imtumwa yula imtwatsa wake hayatsakuya na kumpfika kotenda apfo, ");
INSERT INTO ruf_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nowalongelani ghendo, imtwatsa ayo katsomwika kwimilitsa ipfinu pfake pfose. ");
INSERT INTO ruf_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Lekeni ka mtumwa keha, na ang'elongela imwenyegho, ‘Imtwatsa wangu katsokawa kuya,’ ");
INSERT INTO ruf_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","kuya kakwandusa ukuwatowa iwatumwa weyaghe na ukuja na ukunwa hamwe ne iwanu iwopatika. ");
INSERT INTO ruf_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Imtwatsa we imtumwa ayo katsakutsa mne litsuwa lyang'omlolela bae na mne isaa yang'aimanyile bae. ");
INSERT INTO ruf_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Imtwatsa ayo katsomghana pfihindi pfihindi na katsomwika hamwe ne iwang'enye, ako kutsakuwa na chililo na kughegheda ghamatsino. ");
INSERT INTO ruf_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Chipindi acho undewa wa kulanga witseghala ne wali kumi, iwasolile pfitasa pfawo na waghenda kumbokela imunu yokwela. ");
INSERT INTO ruf_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Watano mna wawo tsawabotsi, na watano wangi tsawana ihekima. ");
INSERT INTO ruf_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Awala wali wabotsi wosola pfitasa pfawo, lekeni ng'awasolile bae ghamafuta ghoghose. ");
INSERT INTO ruf_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Awala wane ihekima, wasola tsisupa itsimemile ghamafuta hamwe na pfitasa pfawo. ");
INSERT INTO ruf_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Imunu yokwela tsakakawa kutsa, apfo wali wose wapata nongo, wawasa. ");
INSERT INTO ruf_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Chilo chikulu, kulawila litsi, ‘Imunu yokwela kapfika! Mlawe mkambokele!’ ");
INSERT INTO ruf_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Kuya wali wose walamka, watuwa pfitasa pfawo. ");
INSERT INTO ruf_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Awala iwabotsi wawalongela awala wane ihekima, ‘Mtugholele ghamafuta ghenu chidogho kwaapfila pfitasa pfetu pfotsimika.’ ");
INSERT INTO ruf_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Lekeni awala wane ihekima wawedika, ‘Mbe, ng'aghotwenela bae twetwe na mwemwe, ghendani kwe iwanu iwohutsa ghamafuta mkaghule.’ ");
INSERT INTO ruf_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Lekeni hawang'ali woghenda kughula ghamafuta, imunu yokwela tsakapfika. Wali awala iweyandaye, wengila naye mng'anda mne chihungo cha ukukwela. Na libani lihindighwa. ");
INSERT INTO ruf_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Hambele chidogho wali wabotsi woya, walonga, ‘Imtwatsa! Imtwatsa! Utupfughulile libani!’ ");
INSERT INTO ruf_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Lekeni kawedika, ‘Nowalongelani ghendo, siwamanyile bae.’ ” ");
INSERT INTO ruf_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Kuya Yesu kalonga, “Apfo mkale meso, kwaapfila ng'ammanyile bae litsuwa au isaa. ");
INSERT INTO ruf_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Pfipfila undewa wa kulanga witseghala ne imunu iyoghenda ghumwanza, iyawakemile iwatumwa wake na kuweka wemilitse tsimali tsake. ");
INSERT INTO ruf_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Kamwing'a chila yumwe kwa kulola uwetso wake, yumwe kamwing'a mikoba mitano, yungi mikoba mili, na yungi mkoba ghumwe. Kuya koka ghumwanza. ");
INSERT INTO ruf_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Bahala imtumwa iyabokele mikoba mitano kaghenda kutsitendela sang'ano, kapata mikoba mingi mitano. ");
INSERT INTO ruf_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Pfipfila, ayula iyabokele talanta mbili tsongetseka keli talanta mbili. ");
INSERT INTO ruf_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Lekeni ayula iyabokele talanta imwe, koka kahimba hasi, kaipfisa isendi ye imtwatsa wake. ");
INSERT INTO ruf_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ghamatsuwa pfaghalutile, imtwatsa we iwatumwa awo koya na kwandusa kupeta tsisendi hamwe nawo. ");
INSERT INTO ruf_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Imtumwa iyabokele talanta tano kamghalila talanta tano tsingi, kalonga, ‘Imtwatsa, tsakungaya talanta tano, ulole tsongetseka talanta tsingi tano.’ ");
INSERT INTO ruf_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Imtwatsa wake kamwidika, ‘Kutenda ghoya, mtumwa yunoghile na mtogholighwa! Tsakutogholighwa kwa ipfinu pfidodo, nitsokwika wimilitse pfinu pfingi. Utse udeng'elele na mtwatsa wako!’ ");
INSERT INTO ruf_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Kuya imtumwa iyeng'ighwe talanta mbili naye katsa, kalonga, ‘Imtwatsa tsakungaya talanta mbili, ulole, tsongetseka tsingi mbili.’ ");
INSERT INTO ruf_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Imtwatsa wake kamwidika, ‘Kutenda ghoya, imtumwa yunoghile na yutogholighwa! Tsakutogholighwa kwa pfinu pfidodo, nitsokwika wimilitse pfinu pfingi, utse na udeng'elele hamwe na mtwatsa wako!’ ");
INSERT INTO ruf_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Kuya imtumwa iyabokele mkoba umwe katsa, kalonga, ‘Imtwatsa, nokumanya ghweghwe kwa imunu mkomu, kopfuna hanu ng'auhandile bae, na kokunga hanu ng'aupwililise bae tsimbeghu. ");
INSERT INTO ruf_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Apfo tsanipfuka, mbuka kupfisa isendi yako mne lidongo. Ulole, aino iyo isendi yako.’ ");
INSERT INTO ruf_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Mtwatsa wake kamwidika, ‘Ghweghwe kwa imtumwa wihile na imdebwe! Tsakumanya ka nene nopfuna hanu sihandile na kukunga hanu sipwililise bae tsimbeghu. ");
INSERT INTO ruf_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Apfo tsakubamighwa kuika bengi isendi yangu, ili hambuile na nene nyambulile ifaida. ");
INSERT INTO ruf_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“ ‘Mumboke sendi ayo mmwing'e ayu yane mikoba kumi. ");
INSERT INTO ruf_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kwaapfila wowose iyalinacho, katsokongetsighwa, na wowose iyalihela chinu hata achila chayalinacho katsobokighwa. ");
INSERT INTO ruf_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Na mmwase imtumwa yuno yehile kunze mne ichisi, ako kutsakuwa na chililo na kughegheda ghamatsino.’ ” ");
INSERT INTO ruf_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Imwana we Imunu hayatsakutsa mne utunitso wake, hamwe na wamalaika, katsokala mne chighoda chake che undewa mne utunitso wa kulanga. ");
INSERT INTO ruf_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Iwanu wa kolo tsose watsetingana hambele hake, naye katsowabaghula ka iwadimi pfawowabaghula iwang'olo na iwamene. ");
INSERT INTO ruf_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Katsoweka iwanu iwanoghile kune ghumoko ghwake ghwa kujilo na iwanu wehile ghumoko ghwake ghwa kumoso. ");
INSERT INTO ruf_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Kuya Imndewa katsowalongela awala iwakalile ghumoko ghwake ghwa kujilo, ‘Mtse, mwemwe imbalikighwe na Aba wangu, mhale undewa wamwikilighwe mwemwe kulawa iisi hailumbighwe. ");
INSERT INTO ruf_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kwaapfila tsanikala ne inzala, namwe mngaya ichijo, tsanikala ne ing'ilu, namwe mngaya ghamatsi, tsanamhenza namwe mnibokela. ");
INSERT INTO ruf_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Tsanahela lighwanda namwe mnipfetsa, tsanamtamu namwe mutsa kundola, tsanamchifungo, namwe mnyangila.’ ");
INSERT INTO ruf_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Baho iwanu iwanoghile watsomwidika, ‘Imtwatsa wetu tsuwachi hatukwonile kuna inzala na tukwing'a ichijo, au kuna ing'ilu na twetwe tukwing'a ghamatsi? ");
INSERT INTO ruf_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kuya tsuwachi hatukwonile kwa mhenza na twetwe tukubokela, au kwahela lighwanda na twetwe tukupfetsa? ");
INSERT INTO ruf_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Tsuwachi hatukwonile kwa mtamu au kwa mchifungo na twetwe tukwangila?’ ");
INSERT INTO ruf_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Imndewa katsowedika, ‘Nowalongelani ghendo, chochose chamumtendele yumwe wa wano wandughu tsangu, mnendela nene.’ ");
INSERT INTO ruf_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Kuya katsowalongela awala iwali kune ghumoko ghwake ghwa kumoso, ‘Lawani hana nene, yamlighitighwe, mghende kune ghumoto ghwa ghamatsuwa ghose, ighwikighwe kwaajili ya Yehile ne malaika wake! ");
INSERT INTO ruf_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kwaapfila tsanikala ne inzala ng'amngaile bae ichijo, tsanina ing'ilu ng'amngaile bae ghamatsi, ");
INSERT INTO ruf_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Tsanamhenza, ng'amnibokele bae, tsanahela lighwanda, ng'amnipfetse bae. Tsanamtamu na tsanamchifungo, ng'amtsile bae kumbona.’ ");
INSERT INTO ruf_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Kuya nawo watsamwidika, ‘Imtwatsa, tsuwachi hatukwonile kuna inzala au kuna ing'ilu, au kwamhenza au kwahela lighwanda au kwamtamu au kwa mne chifungo, na twetwe ng'atukwapfile bae?’ ");
INSERT INTO ruf_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Imndewa naye katsowedika, ‘Nowalongelani ghendo, ka tsamlema kumwapfila yumwe we iwadodo wano, tsamlema kunyapfila nene.’ ");
INSERT INTO ruf_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Kuya watsoghenda kune ukughaya kwa ghamatsuwa ghose, lekeni iwanu iwanoghile watsoghenda kune ughima wa ghamatsuwa ghose. ");
INSERT INTO ruf_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu hayamalitse kulonga mbuli atso, kawalongela iwanang'ina wake, ");
INSERT INTO ruf_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ka pfammanya ghatsuwa meli hambele itsakuwa Pasaka, na Imwana we Imunu katsoghoghighwa ili awambighwe mna msalaba.” ");
INSERT INTO ruf_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Kuya iwatambika wakulu na iwakulu watingana mne ing'anda ye imlapfa inambiko mkulu, taghwa lyake Kayafa, ");
INSERT INTO ruf_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","tsawabama inzila ya kumghogha Yesu chinyelenyele wamkome. ");
INSERT INTO ruf_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Walonga, “Lekeni ileke kutendeka mne chihungo, hela kutsolawila hengele.” ");
INSERT INTO ruf_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu hayang'ali Betaniya mne ing'anda ya Simoni mkoma, ");
INSERT INTO ruf_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","pinga yumwe kamghendela ne isupa ya alabasta iimemile ghamafuta ighonung'ila gha bei ng'ulu, kamghela mwitwi hayang'ali yakuja mmetsa. ");
INSERT INTO ruf_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Iwanang'ina hawonile apfo wona maya, waghutsa, “Angu choni kwaghitsa ghamafuta pfino?” ");
INSERT INTO ruf_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","“Ghamafuta ghano ghang'autsighwe kwa bei ng'ulu, tsisendi weng'ighwe iwahingwa.” ");
INSERT INTO ruf_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu tsakamanya chawang'ali wolonga, kawalongela, “Ule mwomdesa ipinga ayu? Kanendela chinu chinoghile. ");
INSERT INTO ruf_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Iwahingwa mtsokala nawo ghamatsuwa ghose, lekeni ng'amtsokala bae na nene ghamatsuwa ghose. ");
INSERT INTO ruf_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Hayanighele ghamafuta ighonung'ila mlukuli mwangu, katenda apfo kuniyandaa kwa ukutsikighwa kwangu. ");
INSERT INTO ruf_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nowalongelani ghendo, kokose imbuli inoghile haitsopetighwa mne iisi yose, chayatendile ipinga yuno chitsopetighwa kwa kumkumbuka yeye.” ");
INSERT INTO ruf_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kuya Yuda Isikarioti yumwe we awala iwanang'ina kumi na weli, kawaghendela iwatambika wakulu, ");
INSERT INTO ruf_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","kawaghutsa, “Ning'awapfila ukumhunduka Yesu, mtsongaya choni?” Wampetela tsisendi selasini, wamwing'a. ");
INSERT INTO ruf_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kulawa baho, Yuda yang'ali yobama inzila ya kumuhunduka Yesu. ");
INSERT INTO ruf_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Mne litsuwa lye mwanduso lye Chihungo che Ipfighate ipfihela hamila, iwanang'ina wake wamghendela Yesu, wamghutsa, “Kobama tukutandile kwani ichijo che Pasaka?” ");
INSERT INTO ruf_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Kawedika, “Mghende mne ghumji kwa imunu yumwe mumlongele, ‘Imlangulitsi kolonga chipindi changu chahabehi. Nene na iwanang'ina wangu tutsakuja Pasaka mng'anda mwako.’ ” ");
INSERT INTO ruf_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Apfo iwanang'ina watenda ka Yesu pfayawalongele, na waitanda Pasaka. ");
INSERT INTO ruf_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nemihe haipfikile, Yesu ne iwanang'ina wake kumi na weli wakala mmetsa wakuja. ");
INSERT INTO ruf_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Hawang'ali wakuja, kawalongela, “Nowalongelani ghendo, yumwe wenu katsonihunduka.” ");
INSERT INTO ruf_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Iwanang'ina tsawona usungu, chila yumwe kandusa kumlongela Yesu, “Apfi nene Imtwatsa?” ");
INSERT INTO ruf_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu kawalongela, “Imunu iyopfabika chighate chake hamwe na nene mne ibakuli, katsonihunduka. ");
INSERT INTO ruf_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Imwana we imunu katsokufa ka Ghamaandiko Mahenzeluka pfagholonga. Lekeni katsoghaya imunu yula iyomhunduka Imwana we Imunu. Ing'awile ng'apfu kwe imunu ka ayo ka ng'elekighwe bae.” ");
INSERT INTO ruf_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yuda, ayula iyabamile kumhunduka Yesu, kalonga, “Mlangulitsi, si nene bae.” Yesu kamwidika, “Ghweghwe kulonga.” ");
INSERT INTO ruf_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Hawang'ali wakuja, Yesu kasola ichighate, kachibaliki, kachibena kaweng'a iwanang'ina wake, kalonga, “Msole mje, aluno lukuli Iwangu.” ");
INSERT INTO ruf_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kuya kasola chikombe, kachibaliki, kaweng'a iwanang'ina wake, kalonga, “Wose mnwele chikombe achi.” ");
INSERT INTO ruf_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","“Aino iyo idamu yangu ye lilaghano, iikwitike kwaajili ya wengi kuleghusighwa nzambi. ");
INSERT INTO ruf_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nowalongelani, sitsakunwa keli bae idipfai mbaka litsuwa lila hanitsoinwa idipfai ya sambi na mwemwe mne undewa wa Aba wangu.” ");
INSERT INTO ruf_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Hawamalitse kwimba wila, woka, waghenda kune Chidunda cha Mitseituni. ");
INSERT INTO ruf_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Kuya Yesu kawalongela, “Chilo chino mtsotsuma na kundeka, ka pfayandikighwe. Nitsomtowa imdimi, na iwang'olo we likingili watsopwililika, ");
INSERT INTO ruf_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Lekeni hanitsotsilihuka, nitsowalongolani Galilaya.” ");
INSERT INTO ruf_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petiri kamwidika, “Hata wose wang'akuleka, nene sikuleka bae.” ");
INSERT INTO ruf_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu kamlongelela Petiri, “Nokulongela ghendo, chilo chino ng'ana ijogholo yeke, kutsombela mala ndatu.” ");
INSERT INTO ruf_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petiri kamwidika, “Sikubela bae, hata ka nobamighwa nife naghwe.” Na iwanang'ina wose walonga pfipfo. ");
INSERT INTO ruf_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Kuya Yesu kaghenda ne iwanang'ina wake hanu hakemighwe Getisemane, kawalongela, “Mkale hano, nene noghenda hala kulomba.” ");
INSERT INTO ruf_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Kamsola Petiri na iwana weli wa Sebedayo, kuya kandusa kwona usungu, na kughanzika. ");
INSERT INTO ruf_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Kawalongela, “Ghumoyo ghwangu ghuna usungu mwingi, mbaka nobama nife. Mkale hano na mkale meso na nene.” ");
INSERT INTO ruf_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Kaghenda hambele chidogho, katowa maghoti, kenama mbaka chihanga chake chighusa hasi, kalomba, “Aba wangu, ka yodahika, uchileghuse chikombe chino che maghayo kuna nene. Lekeni si ka nene pfanibama, ila ka pfaubama ghweghwe.” ");
INSERT INTO ruf_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Kuya kawoyila iwanang'ina wake, kawapfika wawasa. Kamghutsa Petiri, “Angu ng'amdahile bae kukala meso na nene hata kwa isaa imwe?” ");
INSERT INTO ruf_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","“Mkale meso, mlombe ili mleke kwingila mne maghetso, ghumoyo ghwobama, lekeni lukuli lwahela ingupfu.” ");
INSERT INTO ruf_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Kaghenda lwakeli, kalomba, “Aba wangu, ka ng'aidahika bae kuchileghusa ichikombe chino che maghayo mbaka nichinwe, ghoubama ghweghwe ghatendeke.” ");
INSERT INTO ruf_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Hayohile lwa keli, kawapfika keli wawasa kwaapfila nenge tsawo ng'atsidahile bae kukala meso. ");
INSERT INTO ruf_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Kawaleka koka keli, na kalomba lwa kadatu, kalonga chinu chichila. ");
INSERT INTO ruf_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kuya kawoyila iwanang'ina wake kawalongela, “Angu mng'ali mwowasa na kubwihila? Mlole, isaa ya habehi, na Imwana we Imunu kakwing'ighwa kwe iwanu wane nzambi. ");
INSERT INTO ruf_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mwinuke, tukeni! Hayo kakutsa iyonihunduka!” ");
INSERT INTO ruf_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Hayang'ali yolonga apfo, Yuda yumwe we iwanang'ina kumi na weli, kapfika ne iwanu wengi iwakindile imimaghe ne ipfilungu, tsawatumighwa na iwatambika wakulu na iwakulu we iwanu. ");
INSERT INTO ruf_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yuda tsakaweng'a chitango. “Imunu yanimnonela iyo yuyo yamumbama, mghogheni.” ");
INSERT INTO ruf_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Bahala Yuda kamghendela Yesu, kalonga, “Mlangulitsi, nokulamsa!” Kuya kamnonela. ");
INSERT INTO ruf_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu kamlongela, “Sale yangu, utende achila chautsile.” Kuya iwanu awo wamghendela Yesu, wamkinda, wamghogha. ");
INSERT INTO ruf_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Yumwe we awala iwakalile na Yesu kagholosa ghumoko ghwake, kasomola limaghe lyake, kamtowa imtumwa we imtambika mkulu, kamghana lighutwi. ");
INSERT INTO ruf_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesu kamlongela, “Uyitse limaghe hanu hake, kwaapfila awala wose iwokinda limaghe watsakufa kwa limaghe. ");
INSERT INTO ruf_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Angu ng'ammanyile bae ka ning'adahile kumlomba Aba wangu, naye ang'anighalile makingili ghe asikali kubita kumi na meli ghe wamalaika watse kunyapfila. ");
INSERT INTO ruf_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Lekeni lelo ghatsotimilatse Ghamaandiko Mahenzeluka igholonga, yobamighwa ilawile pfino?” ");
INSERT INTO ruf_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Bahala Yesu kawalongela iwanu wala, “Angu mutsa na mimaghe na pfilungu kungogha, ka nene na mbapfi? Chila litsuwa tsanikala namwe na nilangulitsa mne Ing'anda ye Imulungu, ng'amnighoghile bae. ");
INSERT INTO ruf_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Lekeni agha ghose ghalawila ili ghawandikile manabii ghatimile.” Kuya iwanang'ina wake wamleka, watsuma. ");
INSERT INTO ruf_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Awala iwamghoghile Yesu wamghala kwa Kayafa, imtambika mkulu, kwawatinganile iwolangulitsa ghamalaghitso ne iwakulu. ");
INSERT INTO ruf_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Lekeni, Petiri kamuwinza kwa kutali mbaka hachitala he mtambika mkulu. Kengila mghati, kakala hasi na iwabetetsi, yalole choni chitsolawila. ");
INSERT INTO ruf_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Iwabala we inambiko na Libalatsa lyose wang'ali wobama ukalangama we ughutsu kwaajili ya Yesu, ili wadahe kumkoma. ");
INSERT INTO ruf_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Lekeni ng'awapatile ukalangama wowose bae, hata ka iwakalangama wengi we ughutsu watsa hambele. Kuya iwanu weli watsa hambele, ");
INSERT INTO ruf_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","walonga, “Imunu yuno kalonga apfi, ‘Nodaha kuimwagha Ing'anda ye Imulungu na kuitsenga keli mne ghamatsuwa madatu.’ ” ");
INSERT INTO ruf_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kuya mtambika mkulu kenuka kamlongela Yesu, “Kwahela che ukwidika? Agha ighawolonga iwanu wano gholongesa?” ");
INSERT INTO ruf_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Lekeni Yesu kanyamala. Mtambika mkulu, kamlongela, “Wilahe kwe Imulungu iyali mghima. Utulongele ka ghweghwe kwa Kiristu, Imwana we Imulungu.” ");
INSERT INTO ruf_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu kamwidika, “Ghweghwe kwolonga. Lekeni nowalongelani wose, kulawa sambi na kughendelela mtsomwona Imwana we Imunu kakala ubali wa kujilo we Imulungu Yane ingupfu, kakutsa mne ghamawingu gha kulanga.” ");
INSERT INTO ruf_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Bahala Mtambika mkulu kadegha ghamaghwanda ghake kalonga, “Kaligha! Ule lelo twobama keli wakalangama? Mwemwe wenyegho mmuhulika pfayalighile. ");
INSERT INTO ruf_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Mwemwe mkonatse?” Wamwidika, “Katotsa, yakomighwe.” ");
INSERT INTO ruf_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Wambwalulila ghamate mchihanga na wamtowa. Wamwenga wamtowa makofi. ");
INSERT INTO ruf_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Walonga, “Ghwe Kiristu, utange yuhi yakutowile?” ");
INSERT INTO ruf_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Petiri tsakakala kunze mwe chikuta, na imtumwa yumwe pinga kamghendela, kamlongela, “Naghwe pfipfila tsakwahamwe na Yesu wa Galilaya.” ");
INSERT INTO ruf_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Lekeni Petiri kabela hambele ha wose, kalonga, “Simanyile bae chaulonga?” ");
INSERT INTO ruf_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Kuya kalawa kunze, ako imtumwa yungi pinga kamwona, kuya kawalongela iwanu, “Hayuno naye tsakahamwe na Yesu wa Natsareti.” ");
INSERT INTO ruf_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petiri kabela keli, kwa kwilaha, “Simmanyile bae imunu ayo!” ");
INSERT INTO ruf_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Hambele chidogho, awala iwemile hala wamghendela Petiri walonga, “Naghwe kwa yumwe wawo ghendo, kwaapfila hata kulonga kwako kolangusa ghweghwe kwa Mgalilaya.” ");
INSERT INTO ruf_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Kuya Petiri kandusa kwilighita na kwilaha, kalonga, “Mbe, simmanyile bae imunu ayo!” Bahala ijogholo keka, ");
INSERT INTO ruf_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","na Petiri kakumbuka imbuli iyailongile Yesu. “Ijogholo ng'ana yeke, kutsombela mala ndatu.” Kalawa kunze, kalila kwa usungu. ");
INSERT INTO ruf_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nemitondotondo, iwatambika wakulu ne iwakulu we iwanu wose tsawalamla kumkoma Yesu. ");
INSERT INTO ruf_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Wamwoha, wamlongotsa wamghala kwa Pilato, mkulu wa isi iyasaghulighwe ne mkulu Roma. ");
INSERT INTO ruf_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yuda, iyamhunduke Yesu, hayonile Yesu kahighighwa, kona usungu katsuyitsa sendi tsila selasini tsayasolile kwe iwatambika wakulu. ");
INSERT INTO ruf_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Kawalongela, “Nitotsa, kwaapfila nimhunduka imunu iyalihela totso yakomighwe.” Lekeni wawo wamwidika, “Twetwe ng'atukwalangula bae, alyo lyako.” ");
INSERT INTO ruf_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Apfo Yuda kasa sendi atso mne Ing'anda ye Imulungu, kuya kaghenda kwikoma kwa kwibota imwenyegho. ");
INSERT INTO ruf_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Iwatambika wakulu wadondola sendi tsila, walonga, “Ng'apfinoghile bae kwika sendi tsino mne hatsina ye Ing'anda ye Imulungu. Kwaapfila atsino sendi tsa idamu.” ");
INSERT INTO ruf_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Apfo walamla sendi atso waghulile mghunda wa wafina pfiha uwe hanu he kutsikila iwahenza. ");
INSERT INTO ruf_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ndo mana mbaka leloli mghunda awo wokemighwa, “Mghunda wa Damu.” ");
INSERT INTO ruf_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Kuya achila chayalongile nabii Yeremiya chitimila, “Watsosola sendi selasini, tsawatoghole iwanu wa Isiraeli kumlihila, ");
INSERT INTO ruf_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","watsitumila kughulila mghunda we wafina pfiha, ka Imtwatsa pfayanilaghitse.” ");
INSERT INTO ruf_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu tsakema hambele ha imkulu wa Roma, na imkulu ayo kamghutsa, “Angu ghweghwe kwa Imndewa wa Wayahudi?” Yesu kamwidika, “Ghweghwe kolonga.” ");
INSERT INTO ruf_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Iwabala we inambiko ne iwakulu hawang'ali womwing'a ghamaghomba, ng'edike chochose bae. ");
INSERT INTO ruf_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kuya Pilato kamghutsa, “Angu ng'uhulika bae ghamaghomba ghano ghowokulonga?” ");
INSERT INTO ruf_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Lekeni Yesu ng'edike imbuli yoyose bae, mkulu ayo kakangawala ghendo. ");
INSERT INTO ruf_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Chila chihungo che Paska imkulu wa Roma katsowela kumlekelela imwohingwa yumwe, iyawambamile iwanu. ");
INSERT INTO ruf_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Tsahana mwohighwa yumwe, iyamanyike ng'ani yakemighwe Baraba. ");
INSERT INTO ruf_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Apfo iwanu hawetingane, Pilato kawaghutsa, “Mwobama nimlekelele yuhi? Baraba au Yesu yokemighwa Kiristu?” ");
INSERT INTO ruf_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Kwaapfila Pilato tsakamanya ghendo ka wamghala Yesu kuna yeye, kwaapfila tsawamwonela chepfu. ");
INSERT INTO ruf_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato hayang'ali kakala mne chighoda cha kuhighila, mwehe wake kamtumila usenga, “Uleke kumtendela chochose imunu ayo yalihela totso. Kwaapfila leloli nechilo tsanidununzika ng'ani mndoto kwaajili yake.” ");
INSERT INTO ruf_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Lekeni iwabala we inambiko na iwakulu, waghusongesa mtingano we iwanu wamlombe Pilato amlekelele Baraba na Yesu yakomighwe. ");
INSERT INTO ruf_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilato kawaghutsa keli, “Yuhi mna wano weli mwombama nimlekelele?” Wamwidika, “Baraba.” ");
INSERT INTO ruf_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato kawaghutsa, “Lelo nimtende choni ayu Yesu yokemighwa Kiristu?” Wose wamwidika, “Umuwambe mna msalaba!” ");
INSERT INTO ruf_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilato kawaghutsa, “Ule? Choni chihile chayatendile?” Lekeni wose wakemelela hamwe, “Umuwambe mna msalaba!” ");
INSERT INTO ruf_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilato hayonile ng'odaha bae chochose, ne hengele tsalyakwandusa kulawila, kasola ghamatsi, kahopfugha ghamoko ghake hambele he iwanu, kalonga, “Nene nahela litotso kwa ukufa kwe imunu ayu, alyo lyenu iwenyegho!” ");
INSERT INTO ruf_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Iwanu wose walonga, “Totso lye ukufa kwake liwe mchanya mwetu na mchanya mwe iwanetu!” ");
INSERT INTO ruf_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kuya kamlekelela Baraba kuna wawo. Lekeni kalonga wampfapule Yesu na mijeledi, kamlapfa yawambighwe mna msalaba. ");
INSERT INTO ruf_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kuya asikali wa Pilato wamghala Yesu mne ing'anda ye imndewa, na kingili lyose lye asikali limmemela. ");
INSERT INTO ruf_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Wamtsula ghamaghwanda ghake, wampfatsa lighwanda dung'u, ");
INSERT INTO ruf_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Kuya wabota fiya ya tsimiwa walika mwitwi mwake, kuya weka ing'weku mne ghumoko ghwake wa kujilo, watowa ghamaghoti hambele hake. Wambetsa, walonga, “Mbukwa, Imndewa wa Wayahudi.” ");
INSERT INTO ruf_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Wambwalulila ghamate, wasola ing'weku wamtowa mwitwi. ");
INSERT INTO ruf_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Hawamalitse kumbetsa, wamtsula lighwanda alyo, wampfatsa ghamaghwanda ghake. Wamghala yawambighwe mna msalaba. ");
INSERT INTO ruf_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Hawang'ali wakuka, watingana ne imunu yumwe iyolawila Kirene, iyakemighwe Simoni, wamnanahitsa yaughale msalaba. ");
INSERT INTO ruf_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Wapfika hanu hokemighwa Goligota, mana yake Chibombwe che Litwi. ");
INSERT INTO ruf_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Wamwing'a Yesu idipfai iitifighwe ne ichinu che usungu, lekeni hayailanzile, kalema ukunwa. ");
INSERT INTO ruf_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Wamuwamba mna msalaba, kuya wegholela ghamaghwanda ghake kwa kutowa simbi. ");
INSERT INTO ruf_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Wakala hasi wamlolesa. ");
INSERT INTO ruf_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Na hachanya he litwi lyake, wandika lighomba lyake, “Ayuno Yesu, Imndewa wa Wayahudi.” ");
INSERT INTO ruf_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Iwabapfi weli nawo tsawawambighwa hamwe naye, yumwe ghumoko ghwake ghwa kujilo na yungi ghumoko ghwake ghwa kumoso. ");
INSERT INTO ruf_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Iwanu iwalutile hala, wahighitsa ghamatwi ghawo kwa kumbetsa, wamligha, ");
INSERT INTO ruf_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","walonga, “Ambe ghweghwe ung'aimwaghile Ing'anda ye Imulungu na kuitsenga keli mne ghamatsuwa madatu! Lelo wikombole imwenyeng'o. Ka ghweghwe kwa Imwana we Imulungu hulumka mna msalaba.” ");
INSERT INTO ruf_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Pfipfila iwatambika wakulu na iwolangulitsa ghamalaghitso, na iwabala wose wambesa. ");
INSERT INTO ruf_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Walonga, “Kawakombola iwanu wangi, lekeni ng'odaha bae kwikombola imwenyegho, ambe yeye ka Imndewa we Isiraeli, tumlole lelo yahulumke mna msalaba, na twetwe tutsomtoghola. ");
INSERT INTO ruf_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Tsakamuhuwila Imulungu na kalonga ‘Nene na Imwana we Imulungu.’ Lekani lelo tulole Imulungu yamkombole ka kombama.” ");
INSERT INTO ruf_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Pfipfila iwabapfi weli iwawambighwe hamwe naye, wamligha. ");
INSERT INTO ruf_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kulawa saa sita mbaka saa tisa ichisi tsachighubika isi yose. ");
INSERT INTO ruf_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Haipfikile saa tisa, Yesu kakemelela, “Eloi, Eloi, lama sabakitani?” Mana yake, “Imulungu wangu, Imulungu wangu, ebali kondeka?” ");
INSERT INTO ruf_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Iwanu iwemile hala hawahulike apfo, walonga, “Komkema Eliya.” ");
INSERT INTO ruf_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Bahala yumwe wawo katsuma kasola dodoki, kalika mne dipfai iing'ang'a, kuya kalika mne ing'weku kamwing'a Yesu yainwe. ");
INSERT INTO ruf_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Awala iwanu wangi walonga, “Lelo mleke tulole ka Eliya kakutsa kumkombola.” ");
INSERT INTO ruf_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesu kakemelela keli kwa litsi likulu, kuya kafa. ");
INSERT INTO ruf_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Bahala lipatsiya ililimghati mwe Ing'anda ye Imulungu lidegheka pfihindi pfibili kulawa uchang'a mbaka hasi. Isi tsaidedema na ghamabambalawe ghatulika. ");
INSERT INTO ruf_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","tsikabuli tsighubuka ne iwanu wengi we Imulungu iwafile tsawatsilihuka. ");
INSERT INTO ruf_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Walawa kunze mwe tsikabuli, na Yesu hayatsilihuke waghenda mne ghumji mwenzeluka, na iwanu wengi wawona. ");
INSERT INTO ruf_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ayula imkulu we asikali na awala iwakalile naye womkalitsa Yesu, hawonile isi ihighisika na ghose ighalawile, tsawapfuka, walonga, “Ayuno tsa Imwana we Imulungu ghendo!” ");
INSERT INTO ruf_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Tsakukala na iwapinga wengi, wololesa kwa kutali, awo iwo iwamuwinzile Yesu kulawa Galilaya na iwamwapfile. ");
INSERT INTO ruf_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mna wawo, tsakukala na Mariya Magidalena, Mariya mai wawo tsina Jakobu na Yosefu na mai we iwana wa Sebedayo. ");
INSERT INTO ruf_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nemihe haipfikile, imunu yumwe tajiri kulawa Arimataya iyakemighwe Yosefu kapfika, naye imwenyegho tsakakala mwanang'ina wa Yesu. ");
INSERT INTO ruf_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Kamghendela Pilato kamlomba yamwing'e lukuli lwa Yesu, na Pilato kalaghitsa yeng'ighwe. ");
INSERT INTO ruf_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yosefu kalusola lukuli, kalupfatsa isanda inoghile, ");
INSERT INTO ruf_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","kalwika hanu hake imwenyegho ha sambi ha kutsikila. Kuya kabingilisa libwe kulu hambele he libani lye likabuli, kuya koka. ");
INSERT INTO ruf_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mariya Magidalena na Mariya yungi tsawakala baho, welolesa ne likabuli. ");
INSERT INTO ruf_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Litsuwa lya keli, ilili litsuwa lya Sabato, iwatambika wakulu na Mafarisayo waghenda kwa Pilato. ");
INSERT INTO ruf_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Walonga, “Imndewa, twokumbuka mghutsu yula, hayang'ali mghima tsakalonga, ‘Ghang'abita ghamatsuwa madatu, nitsotsilihuka keli.’ ");
INSERT INTO ruf_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Apfo, ulaghitse kabuli lyake walikalitse ghoya mbaka mne litsuwa lya kadatu. Hela iwanang'ina wake wodaha kutsa na kulwiba lukuli lwake na kuwalongela iwanu kuwa katsilihuka. Ughutsu uno wa utsighilo utsakuwa wiha kubita ula wa mwanduso.” ");
INSERT INTO ruf_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato kawedika, “Mnawo asikali, mghende mkakalitse likabuli ka pfamdaha.” ");
INSERT INTO ruf_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Apfo woka na wakalitsa ghoya likabuli kwa kwika chitango mne libwe na wawaleka asikali wokalitsa. ");
INSERT INTO ruf_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Litsuwa lya Sabato halimalile, lupfilipfili litsuwa lye mwanduso lye lijuma, Mariya Magidalena na Mariya yungi waghenda kulola likabuli. ");
INSERT INTO ruf_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tsakulawila mdedemo mkulu we isi, kwaapfila malaika we Imtwatsa tsakahulumka kulawa kulanga, kaghenda mne likabuli kalibingilisa libwe hambali, kalikalila. ");
INSERT INTO ruf_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Chihanga chake tsachikala ka lumwesa, na lighwanda lyake tsalitselu chwee! ");
INSERT INTO ruf_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Iwanu iwang'ali wokalitsa wapfuka ghendo, wadedema na woneka ka wafa. ");
INSERT INTO ruf_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Malaika ayo kawalongela iwapinga, “Mleke kupfuka, kwaapfila nomanya mwombama Yesu iyawambighwe mna msalaba. ");
INSERT INTO ruf_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ng'alibaha bae, katsilihuka ka pfayalongile. Mtse mlole hanu hayawasile. ");
INSERT INTO ruf_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Lelo msumke mghende, muwalongelele pfino iwanang'ina wake. ‘Yesu katsilihuka, naye katsowalongola kughenda Galilaya. Baho mtsomwona.’ Haya lelo, ma niwalongela.” ");
INSERT INTO ruf_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Apfo iwapinga awo wasumka kuka kulawa hane likabuli, kwa kupfuka na ndeng'elelo ng'ulu, watsuma waghenda kuwalongela iwanang'ina wake. ");
INSERT INTO ruf_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Bahala Yesu ketingana nawo, kawalongela, “Nowalamsani.” Wamghendela, wakinda ghamaghulu ghake, wamtamanila. ");
INSERT INTO ruf_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Kuya Yesu kawalongela, “Mleke kupfuka. Mghende mkawalongele wandughu tsangu waghende Galilaya, ako watsombona.” ");
INSERT INTO ruf_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Iwapinga hawang'ali wamnzila, asikali wangi mna awala iwakalitse likabuli waghenda kune ghumji wawalongela watambika wakulu chila chinu ichilawile. ");
INSERT INTO ruf_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Iwakulu we inambiko hawetingane ne iwabala wapanga imbuli yawo, waweng'a sendi nyingi awala iwakalitse likabuli, ");
INSERT INTO ruf_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","kuya wawalongela, “Walongeleni pfino iwanu, ‘Iwanang'ina wake watsa nechilo, wamwiba hatuwasile.’ ");
INSERT INTO ruf_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Na imkulu we isi ang'ahulika mbuli ino, twetwe tutsolonga naye, namwe ng'amtsokwingila mne maghayo.” ");
INSERT INTO ruf_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Apfo awala asikali wasola sendi, na watenda ka pfawalongelighwe. Na mbuli ayo yenela kwe Wayahudi mbaka leloli. ");
INSERT INTO ruf_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Kuya iwanang'ina kumi na yumwe waghenda Galilaya kune chidunda, ako Yesu kwayawalongele waghende. ");
INSERT INTO ruf_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Hawamwonile, wamtamanila lekeni wangi wapfuka. ");
INSERT INTO ruf_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu kawaghendela, kawalongela, “Ukulu wose uli kulanga na uli muisi ning'ighwa nene. ");
INSERT INTO ruf_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Apfo, mghende mkawatende iwanu we isi tsose wawe wanang'ina wangu, muwabatitse kwa taghwa lya Aba na Imwana na Ghumuhe Mwenzeluka, ");
INSERT INTO ruf_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","na muwalangulitse kughakinda aghala ghose ghaniwalaghitse. Na nene na hamwe namwe ghamatsuwa ghose mbaka iisi haitsomala.”");
INSERT INTO ruf_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Haino Imbuli Inoghile ya Yesu Kiristu, Imwana we Imulungu. ");
INSERT INTO ruf_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Yakwandusa ka pfayandikighwe mne chitabu cha nabii Isaya. “Imulungu kalonga, ‘Nitsomtuma imtumighwa wangu yakulongole, ayo katsoyandaa inzila yako.’ ");
INSERT INTO ruf_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Litsi lye imunu lyokema kunyika, ‘Muyandae inzila ye Imtwatsa, muigholose inzila yake.’ ” ");
INSERT INTO ruf_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yohane tsakalawila kunyika, kowapetela iwanu na kowabatitsa. Kawalongela iwanu, “Mtsileke nzambi tsenu namwe mbatitsighwe, na Imulungu katsowaleghusila nzambi tsenu.” ");
INSERT INTO ruf_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Iwanu wengi walawa mne isi ya Yudeya na mne ghumji ghwa Yerusalemu waghenda kumuhulikitsa Yohane. Watsitoghola nzambi tsawo, naye kawabatitsa mne ghumto Yoridani. ");
INSERT INTO ruf_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohane tsakapfala lighwanda ilitendighwe kwa ngotsi ya ingamiya, na ghumsipi ghwe ngotsi mchuno, na chijo chake chayang'ali yakuja tsachikala iwanzighe na uki. ");
INSERT INTO ruf_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Kawalongela iwanu, “Kuchughu kwangu kakutsa yane ingupfu kubita nene. Nene sibamighwa bae hata kwinama na kudohola mitsabi ye imikwabatsa yake. ");
INSERT INTO ruf_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nene nowabatitsa mwemwe kwa ghamatsi, lekeni ayo katsowabatitseni kwa Ghumuhe ghwe Imulungu.” ");
INSERT INTO ruf_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ghamatsuwa agho, Yesu tsakatsa kulawa ghumji ghwa Natsareti, mne isi ya Galilaya, kabatitsighwa na Yohane mne ghumto Yoridani. ");
INSERT INTO ruf_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesu hayang'ali yolawa mne ghamatsi, tsakona ililanga lopfughuka na Ghumuhe Mwenzeluka komhulumkila ka injiwa. ");
INSERT INTO ruf_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kuya Iitsi lilawa kulanga, “Ghweghwe kwa imwanangu yanikunoghele, ninoghelighwa naghwe.” ");
INSERT INTO ruf_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Bahala Ghumuhe Mwenzeluka kamlongotsa yaghende kunyika, ");
INSERT INTO ruf_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","kuya kakala ako ghamatsuwa arubaini koghetsighwa na Setani. Iwanyama wa kwibagho nawo tsawabahala, na iwamalaika wamtumikila. ");
INSERT INTO ruf_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yohane hekighwe mchifungo, Yesu kaghenda Galilaya kuwapetela iwanu Imbuli Inoghile ye Imulungu. ");
INSERT INTO ruf_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Kalonga, “Ichipindi chitsa, Undewa we Imulungu wa habehi. Mtsileke nzambi tsenu muitoghole Imbuli Inoghile.” ");
INSERT INTO ruf_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesu hayang'ali yoghenda mmbalimbali mwe tsimbu Galilaya, kawona iwalowa wasomba weli, Simoni na Andereya, ndughu yake. Tsawang'ali wolowa iwasomba. ");
INSERT INTO ruf_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu kawalongela, “Mniwinze, nani nitsowatenda mwemwe muwe iwalowa iwanu.” ");
INSERT INTO ruf_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Bahala watsileka nyapfu tsawo, wamuwinza. ");
INSERT INTO ruf_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Kaghenda hatali chidogho, kawona Jakobu na Yohane, iwana wa Sebedayo, wamne mnumbwi ghwawo, wotenda ghoya nyapfu tsawo. ");
INSERT INTO ruf_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Bahala Yesu hayawonile, kawakema. Nawo wamleka Sebedayo, aba wawo mne mnumbwi hamwe ne iwatenda isang'ano, wamuwinza. ");
INSERT INTO ruf_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu ne iwanang'ina wake wapfika mne ghumji ghwa Kaperinaumu. Litsuwa lya Sabato, Yesu kengila mne ing'anda ye ukulombela, kandusa kulangulitsa. ");
INSERT INTO ruf_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Iwanu iwamhulikitse wakangawala kwa ghamalangulitso ghake, kwaapfila yeye ng'alangulitse bae ka iwolangulitsa Ghamalaghitso gha Musa, ila kalangulitsa ka imunu yane ukulu. ");
INSERT INTO ruf_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Bahala imunu yane ichinyamkela kengila mne ing'anda ye ukulombela kakemelela kwa litsi likulu, ");
INSERT INTO ruf_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Ubama kutenda choni, Yesu wa Natsareti? Kutsa kutukoma? Nokumanya ghweghwe kwa Mwenzeluka we Imulungu!” ");
INSERT INTO ruf_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu kamkembela ichinyamkela, “Nyamale! Umlawe imunu yuno!” ");
INSERT INTO ruf_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ichinyamkela ayo tsakamhighitsa kwe ingupfu imunu ayo, kuya kakemelela, kamlawa. ");
INSERT INTO ruf_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Apfo iwanu wose wakangawala ghendo, weghutsa, “Apfino pfinu pfachi? Agha malangulitso gha sambi? Imunu yuno kana uwetso wa kulapfa ipfinyamkela, nawo womtegheletsa.” ");
INSERT INTO ruf_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Apfo mbuli tsa Yesu tsenela himahima mne isi yose ya Galilaya. ");
INSERT INTO ruf_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesu ne iwanang'ina wake, hamwe na Jakobu na Yohane walawa mne ing'anda ye ukulombela waghenda ukaye kwa Simoni na Andereya. ");
INSERT INTO ruf_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Mai mkwe wa Simoni tsakakala kawasa mlusatsi koghula lihoma. Yesu hayapfikile, wamlongela mbuli tse ipinga ayo. ");
INSERT INTO ruf_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Kamghendela, kamkinda ghumoko kamwinula. Utamu umlawa, kandusa kuwatumikila. ");
INSERT INTO ruf_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Mihe haipfikile na litsua kuswa, iwanu wamghalila Yesu iwatamu wose ne iwanu wane ipfinyamkela. ");
INSERT INTO ruf_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Iwanu wose wa ghumji wetingana hachibwalu he ing'anda. ");
INSERT INTO ruf_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu kawahonetsa iwanu wane matamu ghoghose na kalapfa ipfinyamkela wengi. Ng'aweng'ile bae ipfinyamkela nyafwasi ye ukulonga chochose kwaapfila tsawammanya yeye nani. ");
INSERT INTO ruf_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Lupfilipfili, litsua ng'ana lilawe, Yesu kenuka, kalawa aho hakaye, kaghenda kunze kwe ghumji, hanu halihela imunu, kamlomba Imulungu. ");
INSERT INTO ruf_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simoni na weyaghe waghenda kumbama. ");
INSERT INTO ruf_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Hawamwonile, wamlongela, “Iwanu wose wokubama ghweghwe.” ");
INSERT INTO ruf_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesu kawedika, “Twobamighwa tughende kune ipfijiji pfingi ipfili habehi. Amo nobamighwa niwapetele iwanu Imbuli Inoghile, kwaapfila acho chicho chanitsilile.” ");
INSERT INTO ruf_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Apfo Yesu kanga isi yose ya Galilaya, aku kowapetela iwanu mne tsing'anda tsawo tse ukulombela na kulapfa ipfinyamkela. ");
INSERT INTO ruf_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Imunu yumwe iyoghula ukoma tsakamghendela Yesu. Kamtowela ghamaghoti kamlomba, kalonga, “Ung'abama, kwodaha kunideghetesa.” ");
INSERT INTO ruf_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu kamwonela libatsi imunu ayo, kagholosa ghumoko ghwake, kamkinda. Kuya kalonga, “Nobama, degheta!” ");
INSERT INTO ruf_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Bahala utamu umlawa, kahona. ");
INSERT INTO ruf_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Bahala Yesu kamleka yoke aku komkomangitsa ghendo, kamlongela, ");
INSERT INTO ruf_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Uleke kumlongela imunu wowose imbuli ino, ila ughende wikelanguse kwe mtambika, ulapfe nambiko ka pfayalaghitse Musa. Kuya yakulanguse kwe iwanu ka kuhona.” ");
INSERT INTO ruf_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Lekeni imunu ayo koka, kandusa kwenetsa mbuli atso chila hanu, mbaka Yesu ng'adahile bae kughenda mwatsimwatsi mne ghumji. Ila kakala kunze hanu halihela imunu. Lekeni iwanu tsawang'ali womghendela kulawa chila hanu. ");
INSERT INTO ruf_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ghamatsuwa chidogho hambele, Yesu koya keli Kaperinaumu, na mbuli tsenela kwe iwanu ka tsaka ukaye. ");
INSERT INTO ruf_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Iwanu wengi wetingana hamwe mbaka kukala kuduhu hokukala, wamema mbaka mne chibwalu. Yesu yang'ali yowapetela imbuli yake. ");
INSERT INTO ruf_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Baho iwanu wane wapfika, wambapa imunu iyaholole wamghalila Yesu. ");
INSERT INTO ruf_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kwaapfila iwanu tsa wengi, ng'awadahile bae kumghala habehi na Yesu. Apfo watobola mchiswili, kuchanya mwe hanu hayakalile Yesu. Baho, wamhulumsa imunu ayo iyawasile mchilagho. ");
INSERT INTO ruf_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu honile ukutoghola kwawo, kamlongela imunu ayo iyaholole, “Mwanangu, nzambi tsako tsileghusighwa.” ");
INSERT INTO ruf_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Wangi we iwolangulitsa Ghamalaghitso gha Musa iwakalile baho weghutsa mne imimoyo yawo, ");
INSERT INTO ruf_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Angu ichinu chachi ichimtenda alonge pfino? Komligha Imulungu. Imulungu yaliyeka iyo iyodaha kuleghusa nzambi!” ");
INSERT INTO ruf_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Bahala Yesu kamanya achila chawang'ali wokwalangula mne imimoyo yawo, kawalongela, “Ebali mwakwalangula ipfinu pfino? ");
INSERT INTO ruf_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Chihi chibewe, kumlongela imunu iyaholole, ‘Nzambi tsako tsileghusighwa,’ au kumlongela, ‘Winuke, usole chilagho chako ughende’? ");
INSERT INTO ruf_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nobama mmanye ka Imwana we Imunu kana uwetso wa kuleghusa nzambi muisi.” Baho kamlongela imunu yaholole, ");
INSERT INTO ruf_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nokulongela, winuke, usole chilagho chako uke ukaye!” ");
INSERT INTO ruf_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Naye kenuka, kasola chilagho chake kaghenda aku iwanu wose womlola. Iwanu wose tsawakangawala, wamtunya Imulungu, walonga, “Ng'ana twone ghendo ichinu ka chino!” ");
INSERT INTO ruf_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu kaghenda keli mmbalimbali mwe tsimbu. Iwanu wamghendela, naye kandusa kuwalangulitsa. ");
INSERT INTO ruf_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Hang'ali yoluta, kamwona Lawi imwana we Alifayo kakala mne ing'anda ya kulihila kodi. Yesu kamlongela, “Niwinze.” Lawi kenuka, kamuwinza. ");
INSERT INTO ruf_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yesu hayang'ali yakuja ichijo cha nemihe mne ing'anda ya Lawi, iwasola kodi wengi na “wane nzambi” tsawakala hasi wang'ali wakuja naye ne wanang'ina wake, kwaapfila tsakukala ne iwanu wengi iwomuwinza. ");
INSERT INTO ruf_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Iwolangulitsa Ghamalaghitso wamwenga iwakalile Mafarisayo, hawamwonile Yesu kakuja ne “Wane nzambi” ne iwasola kodi, wawaghutsa iwanang'ina wake, “Ebali kakuja ne iwasola kodi na ‘wane nzambi’?” ");
INSERT INTO ruf_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu kawahulika, kawalongela, “Iwanu iwaghima ng'awombama bae imghanga, ila iwatamu iwo iwombama mghanga. Sitsile bae kuwakema iwanu iwanoghile, ila wane nzambi.” ");
INSERT INTO ruf_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Iwanafunzi wa Yohane ne iwanang'ina wa Mafarisayo wang'ali wofunga ukuja. Iwanu wangi wamtsila Yesu wamghutsa, “Ebali iwanang'ina wa Yohane ne iwanang'ina wa Mafarisayo wofunga ukuja, lekeni iwanang'ina wako ng'awofunga ukuja bae?” ");
INSERT INTO ruf_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu kawedika, “Apfi, iwanu iwakemighwe kune ichihungo cha kukwela wodaha kufunga ukuja aku mmale yokwela kabaho hamwe nawo? Ng'awodaha bae kufunga ukuja. ");
INSERT INTO ruf_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Lekeni ichipindi chakutsa mmale iyokwela katsosolighwa kulawa kuna wawo, na baho watsofunga ukuja. ");
INSERT INTO ruf_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Kuduhu imunu iyoghana chilaka mne lighwanda lya sambi na kuchidapfalitsa mne lighwanda lya ghumwande, ang'atenda apfo, chilaka cha sambi chitsolihinya lighwanda lya ghumwande na hanu hadegheke hatsakongetseka. ");
INSERT INTO ruf_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Na kuduhu imunu iyoghuma idipfai ya sambi mne imikoba ye ngotsi ya ghumwande. Ka kotenda apfo, dipfai ya sambi itsoitula imikoba ayo, dipfai itsokwitika ne imikoba itsohinyika. Ila koghuma dipfai ya sambi mne imikoba ya sambi!” ");
INSERT INTO ruf_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Litsuwa limwe lya sabato, Yesu na wanafunzi wake wang'ali wobita mne imighunda ye uhemba. Hawang'ali woghenda, iwanang'ina wake wandusa kukwanyula imikungwi ye uhemba. ");
INSERT INTO ruf_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Mafarisayo wamlongela Yesu, “Lola! Ebali wotenda ichinu ichighomighwe mne litsuwa lya Sabato?” ");
INSERT INTO ruf_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu kawedika, “Pfii ng'amsomile bae pfatendile Daudi na wayaghe hawakalile ne nzala? ");
INSERT INTO ruf_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Mne ghamatsuwa ghe Imtambika mkulu Abiyatari, Daudi tsakengila mne ing'anda ye Imulungu, kaja pfighate ipfilapfighwe kwe Imulungu, pfighate apfo tsapfibamighwa pfijighwe ne iwapfilongotsi we inambiko waliyeka. Pfipfila kaweng'a wayaghe.” ");
INSERT INTO ruf_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Kuya Yesu kawalongela, “Litsuwa lya Sabato likighwa kwaajili ye iwanu, na si iwanu bae kwaajili ye Litsuwa lya Sabato.” ");
INSERT INTO ruf_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Imwana we Imunu ka Imtwatsa wa Litsuwa lya Sabato. ");
INSERT INTO ruf_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Kuya Yesu kaghenda keli mne ing'anda ye ukulombela. Aho kukala ne imunu yane ghumoko ighuholole. ");
INSERT INTO ruf_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Iwanu wamwenga wang'ali wobama imbuli ya kumghoghela Yesu. Apfo wamlolesa ka ang'amhonetse imunu ayo mne Litsuwa lya Sabato. ");
INSERT INTO ruf_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu kamlongela imunu ayo, “Utse hano hambele.” ");
INSERT INTO ruf_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Kuya kawaghutsa iwanu, “Apfi chihi chinoghile cha kutenda mna litsuwa lya Sabato, kutenda ghanoghile au ghehile? Kuukombola ughima au kuukoma?” Lekeni wawo ng'awalongile chinu chochose bae. ");
INSERT INTO ruf_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Kawalolesa iwanu kwa maya, baho kona usungu mmoyo mwake, kwa usughu we imimoyo yawo. Kuya kamlongela imunu yula, “Ugholose ghumoko ghwako.” Naye kaghugholosa, na ghumoko ghwake ghuhona. ");
INSERT INTO ruf_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Apfo Mafarisayo walawa kunze mwe ing'anda ye Imulungu, wetingana ne iwanu wa Herodi wandusa kubama inzila ya kumkoma Yesu. ");
INSERT INTO ruf_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu ne iwanang'ina wake waghenda kune ghumto Galilaya na iwanu wengi tsawamuwinza, walawila Galilaya na Yudeya. ");
INSERT INTO ruf_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Hawahulike ghose ghatendile, iwanu wengi wamtsila kulawa Yudeya, Yerusalemu, Idumeya ne ipfijiji ipfili kumwambu mwa ghumto Yoridani ne imiji ya Tiro na Sidoni. ");
INSERT INTO ruf_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Kwaapfila iwanu wakala wengi, Yesu kawalongela iwanang'ina wake wamwikile ghoya mnumbwi, ili iwanu waleke kumsoghelela. ");
INSERT INTO ruf_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kwaapfila tsakawahonetsa iwanu wengi, iwatamu wose wang'ali womsoghelela habehi wamkinde. ");
INSERT INTO ruf_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ne iwanu wane ipfinyamkela chila hawamwonile, waghwa hasi hambele hake, wakemelela, “Ghweghwe kwa Imwana we Imulungu.” ");
INSERT INTO ruf_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Yesu kawaghoma ipfinyamkela waleke kumlongela imunu wowose ka yeye tsanani. ");
INSERT INTO ruf_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu kagheluka kuchidunda, kawakema awala iyawabamile mwenyegho, nawo wamghendela. ");
INSERT INTO ruf_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Naye kawasaghula iwanu kumi na weli, kawakema watumighwa. Kawalongela, “Niwasaghula mwemwe mkale na nene. Kuya nitsowatuma mghende mkawapetele iwanu. ");
INSERT INTO ruf_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Namwe mtsakuwa na ukulu wa kulapfa ipfinyamkela.” ");
INSERT INTO ruf_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Awano iwo iwanu kumi na weli iyawasaghule. Simoni, yakemighwe na Yesu taghwa lingi Petiri, ");
INSERT INTO ruf_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jakobu na ndughu yake Yohane, iwana wa Sebedayo Yesu tsakaweng'a taghwa Boanerige, mana yake iwana wa mdumo, ");
INSERT INTO ruf_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andereya na Filipi, na Batalomeyo, na Matei, na Tomasi, na Jakobu imwana wa Alifayo, na Tadei, na Simoni Mkananayo, ");
INSERT INTO ruf_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","na Yuda Isikarioti, iyamhunduke Yesu. ");
INSERT INTO ruf_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Kuya Yesu kaghenda ukaye, iwanu wengi wetingana keli mbaka Yesu ne iwanang'ina wake ng'awadahile bae ukuja. ");
INSERT INTO ruf_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Wandughu tsake hawahulike agho, waghenda kumsola kwaapfila tsawalonga, “Kana lukwale.” ");
INSERT INTO ruf_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Na iwolangulitsa Ghamalaghitso gha Musa iwalawile Yerusalemu walonga, “Kana Belisebuli! Imkulu we ipfinyamkela iyo iyomwing'a ingupfu ya kulapfa ipfinyamkela.” ");
INSERT INTO ruf_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesu kawakema, kawalongela kwa imifano, “Apfi Setani kodahatse kumlapfa Setani? ");
INSERT INTO ruf_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Undewa wowose ung'eghola wenyegho, ambe wakughwa. ");
INSERT INTO ruf_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ka ing'anda yeghola yenyegho, ing'anda ayo itsakughwa. ");
INSERT INTO ruf_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Apfo ka undewa wa Setani weghola iwenyegho, utsakughwa na kutsigha. ");
INSERT INTO ruf_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Kuduhu imunu iyodaha kwingila mng'anda mwe imunu yane ingupfu na kusola ipfinu pfake, mbaka tanu amwohe imunu ayo. Baho katsodaha kupfisola ipfinu pfake. ");
INSERT INTO ruf_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Nowalongela ghendo, iwanu watsoleghusighwa nzambi tsawo na ghamaligho ghawo ghose kwe Imulungu. ");
INSERT INTO ruf_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Lekeni imunu wowose iyomligha Ghumuhe ghwe Imulungu ng'odaha bae kuleghusighwa nzambi ayo, kwaapfila katenda nzambi ya ghamatsuwa ghose.” ");
INSERT INTO ruf_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu tsakalonga apfi kwaapfila iwanu wang'ali wolonga, “Kana chinyamkela.” ");
INSERT INTO ruf_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Kuya mai wake Yesu ne iwandughu tsake wapfika. Wema kunze, wamtuma imunu mng'anda amkeme. ");
INSERT INTO ruf_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Iwanu tsawamtsunguluka Yesu. Nawo wamlongela, “Mai wako na ndughu tsako wakunze, wokubama ghweghwe.” ");
INSERT INTO ruf_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu kawedika, “Apfi mai wangu nani na ndughu tsangu tsina nani?” ");
INSERT INTO ruf_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Kuya kawalola iwanu iwamtsunguluke, kalonga “Awano hano iwo mai wangu na ndughu tsangu! ");
INSERT INTO ruf_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Imunu wowose iyotenda aghala ghobama Imulungu, ayo iyo ndughu yangu na lumbu wangu na mai wangu.” ");
INSERT INTO ruf_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu kandusa keli kulangulitsa mmbalimbali mwa tsimbu lya Galilaya. Iwanu wengi iwetingane wamtsunguluka mbaka kengila mne mnumbwi na kukala amo. Ne iwanu wose wakala mmbalimbali mwe tsimbu. ");
INSERT INTO ruf_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Tsakawalangulitsa ipfinu pfingi kwe imifano, na mne ghamalangulitso ghake kawalongela. ");
INSERT INTO ruf_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Mtegheletse, Imunu iyohanda tsimbeghu tsakaghenda kumitsa tsimbeghu. ");
INSERT INTO ruf_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Hang'ali yomitsa, tsimbeghu tsimwenga tsilaghalila mnzila, pfideghe watsa, watsija. ");
INSERT INTO ruf_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Tsingi tsilaghalila mne ghamabwe ghane lidongo chidogho. Tsimbeghu tsota himahima, kwaapfila lidongo tsachidogho. ");
INSERT INTO ruf_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Litsua halilawile, liilakatsa imimeya kwaapfila imitsisi ng'aighendese hasi bae. ");
INSERT INTO ruf_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Tsimbeghu tsingi tsilaghalila mne tsimiwa, tsikula na tsihinyighwa na tsimiwa, apfo ng'atseleke bae. ");
INSERT INTO ruf_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Lekeni tsimbeghu tsingi tsilaghalila mne lidongo linoghile. Imimeya yota, ikula na yeleka tsimbeghu, ingi makumi madatu, ingi makumi sita ne ingi miya imwe.” ");
INSERT INTO ruf_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Kuya Yesu kalonga, “Imunu yane ghamaghutwi gha kuhulika, yahulike.” ");
INSERT INTO ruf_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yesu hayakalile aliyeka, iwanang'ina kumi na weli ne iwanu wangi wamghutsa imbuli ayo ilonga choni. ");
INSERT INTO ruf_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yesu kawalongela, “Mwemwe mwing'ighwa imbuli ifisighwe ya Undewa we Imulungu. Lekeni awala iwali kunze, wohulika ipfinu kwe imifano ");
INSERT INTO ruf_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ili, ‘Walole, lekeni waleke kwona, wahulike, lekeni waleke kumanya. wang'amanyile, wang'oyile kwe Imulungu, naye yang'awaleghusila nzambi tsawo.’ ” ");
INSERT INTO ruf_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Kuya Yesu kawaghutsa, “Apfi mwemwe ng'ammanyile bae mbuli ino? Lelo mtsomanyatse imbuli yoyose? ");
INSERT INTO ruf_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Imunu iyohanda kohanda Imbuli ye Imulungu. ");
INSERT INTO ruf_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Iwanu wangi weghala na tsimbeghu itsilaghalile mnzila. Hawohulika Imbuli ye Imulungu, Setani kakutsa na kuisola imbuli ihandighwe mghati mwawo. ");
INSERT INTO ruf_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Iwanu wangi weghala na tsimbeghu itsilaghalile mne ghamabwe. Baho hawohulika imbuli ye Imulungu, woibokela kwa kudeng'elela. ");
INSERT INTO ruf_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Lekeni kwaapfila wahela imitsitsi, wodudumila chidogho. Ukughaya au ukughanzika kung'alawila kwaajili ye imbuli ye Imulungu, baho woileka. ");
INSERT INTO ruf_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Iwanu wangi weghala na tsimbeghu itsilaghalile mne tsimiwa. Wohulika imbuli, ");
INSERT INTO ruf_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","lekeni Sang'ano tse isi ino na kubama tsimali na kusulukila ipfinu pfingi, pfakwingila mghati mwawo na kuihinya imbuli ye Imulungu, ng'aikweleka bae. ");
INSERT INTO ruf_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Lekeni iwanu wangi weghala na tsimbeghu itsilaghalile mne lidongo linoghile. Wohulika imbuli ye Imulungu, woitoghola na wakweleka, wangi selasini, wangi sitini, na wangi miya imwe.” ");
INSERT INTO ruf_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu kaghendelela kulonga, “Apfi kuna imunu iyoghala chitasa mng'anda na kuchighubika ne ichiha au kuchika kumpfungu mwe lusatsi? Apfi ng'ochika hanu ha kwikila chitasa, bae? ");
INSERT INTO ruf_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kwaapfila ichinu chochose ichipfisighwe chitsakoneka, ne ichinu chochose ichighubikighwe chitsoghubulighwa. ");
INSERT INTO ruf_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Yane ghamaghutwi gha kuhulika, yahulike.” ");
INSERT INTO ruf_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Pfipfila kawalongela, “Mtegheletse ghoya chamuhulika! Ghamalaghitso ghamuwahighila iwanu wangi, Imulungu katsowahighila ghamalaghitso ghagho, kuya mtsakongetsighwa. ");
INSERT INTO ruf_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kwaapfila imunu yane ichinu katsakongetsighwa ne imunu yalihela ichinu, katsobokighwa hata ichinu chidodo chayenacho.” ");
INSERT INTO ruf_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu kaghendelela kulonga, “Undewa we Imulungu weghala pfino. Imunu kopwililisa tsimbeghu kumghunda. ");
INSERT INTO ruf_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Nechilo kowasa, nemisi kameso. Tsimbeghu tsakota na kukula, naye ng'omanya bae ichitendeka. ");
INSERT INTO ruf_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Lidongo lyenyegho lyotenda imimeya ikule na kweleka, tanu yotula, yolapfa imbelewele, kuya yakweleka. ");
INSERT INTO ruf_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Uhemba hauwela, imunu ayo kosenga kwa sengo yake, kwaapfila ichipindi cha kupfuna chipfika.” ");
INSERT INTO ruf_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu kalonga keli, “Apfi Undewa we Imulungu weghala ne ichinu chachi? Apfi tutsolonga kwe imbuli yachi? ");
INSERT INTO ruf_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Weghala ne imbeghu ya haladali, imbeghu ndodo kubita tsimbeghu tsose itsihandighwa mne isi. ");
INSERT INTO ruf_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Lekeni ing'ahandighwa, yokula na yakuwa mmeya mkulu kubita imimeya yose mne mghunda, nayo yakuwa na ghamaputila makulu ng'ani mbaka wapfideghe wodaha kutsenga ipfibali mne ghamaputila ghake.” ");
INSERT INTO ruf_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu kawapetela iwanu imbuli yake kwa mbuli nyingi itsighalile na tsino, kawalongela ka pfawadahile kuhulika. ");
INSERT INTO ruf_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ng'alongile nawo bae ichinu chochose bila ye imbuli. Lekeni hawakalile ne iwanang'ina wake waliyeka, kawalongela chila ichinu. ");
INSERT INTO ruf_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Litsuwa alyo nemihe, Yesu kawalongela iwanang'ina wake, “Tuloke kumwambu kwa tsimbu.” ");
INSERT INTO ruf_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Tsawawaleka iwanu, iwanang'ina wengila mne mnumbwi mwakalile Yesu, wamsola woka naye. Pfipfila tsakukala na minumbwi ingi. ");
INSERT INTO ruf_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Inyahemu ilawila na ghamawimbi ghautowa mnumbwi mbaka ghwandusa kumema ghamatsi. ");
INSERT INTO ruf_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu tsakakala kuchughu kwa mnumbwi kawasila ghumto. Iwanang'ina wake wamlamsa, wamlongela, “Mlangulitsi, apfi ng'aukona usungu bae, ka twetwe twotsama?” ");
INSERT INTO ruf_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesu kalamka, kalikembela libeho na kaghalongela ghamawimbi, “Nyamala!”, kuya libeho linyamala na kukala kutindiwala. ");
INSERT INTO ruf_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kuya kawalongela iwanang'ina wake, “Ule mpfuka? Pfii, mng'ali ng'amtoghola bae?” ");
INSERT INTO ruf_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nawo wapfuka ghendo, weghutsa, “Ayu munu wachi, libeho na ghamawimbi ghose ghomhulikitsa?” ");
INSERT INTO ruf_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu ne iwanang'ina wake wapfika kumwambu kwa tsimbu Galilaya mne isi ya Gerasi. ");
INSERT INTO ruf_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Baho Yesu hayalawile mne mnumbwi, ketingana ne imunu yane ichinyamkela yalawile kune tsikaburi. ");
INSERT INTO ruf_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Imunu ayo tsakakala kune tsikaburi na kuduhu imunu yadahile kumwoha keli hata kwe iminyororo. ");
INSERT INTO ruf_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Kwaapfila tsakohighwa ghamoko na ghamaghulu ghake, lekeni tsakadumla iminyororo na kubena tsimingu itsili mmaghulu mwake. Na kuduhu imunu yane ingupfu yadahile kumghogha. ");
INSERT INTO ruf_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Imisi ne ichilo tsayang'ali yakwanga mne tsikaburi na mpfidunda, aku kokemelela na kwighanaghana kwa ghamabwe. ");
INSERT INTO ruf_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Hayamwonile Yesu kwa kutali, kamtsumila, kamtowela maghoti hambele hake. ");
INSERT INTO ruf_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Kalila kwa litsi likulu, kalonga, “Yesu Imwana we Imulungu iyali kuchanya ng'ani ubama choni kuna nene? Kwa taghwa lye Imulungu, nokulomba uleke kunidununza!” ");
INSERT INTO ruf_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Kalonga apfo kwaapfila Yesu tsakamlongela, “Chinyamkela, lawa mne imunu yuno!” ");
INSERT INTO ruf_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Kuya Yesu kamghutsa, “Taghwa lyako nani?” Naye kamwidika “Taghwa lyangu Kingili, mana twawengi.” ");
INSERT INTO ruf_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Kuya kamlomba Yesu aleke kuwawinga kunze kwe isi ila pfinyamkela awo. ");
INSERT INTO ruf_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Tsakukala na kingili kulu lye iwangubi wakuja habehi na chidunda. ");
INSERT INTO ruf_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Apfo ipfinyamkela wamlomba Yesu, “Utughale kune iwangubi, utulekelele twingile mna wawo.” ");
INSERT INTO ruf_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesu kawalekelela, ne ipfinyamkela awo wamlawa imunu ayo na kwingila mne iwangubi. Likingili lyose lye iwangubi 2,000 watsumila kune tsimbu na kutsama mne ghamatsi. ");
INSERT INTO ruf_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Iwadimi we iwangubi watsuma na kuwalongela iwanu mne ghumji na mne imighunda. Ne iwanu waghenda kulola achila ichilawile. ");
INSERT INTO ruf_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Hawapfikile kwa Yesu, wamwona imunu yula yakalile na likingili lye ipfinyamkela kakala hasi, kapfala ghamaghwanda ghake na tsimbutsi tsake tsimuyila, iwanu wose wapfuka. ");
INSERT INTO ruf_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ne iwanu iwonile ichinu acho wawalongela iwanu ichinu ichimlawile imunu ayo ne iwangubi. ");
INSERT INTO ruf_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Kuya iwanu wamlomba Yesu yoke mne ghumji ghwawo. ");
INSERT INTO ruf_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu hayakalile kodina mne mnumbwi, imunu iyakalile ne ipfinyamkela kamlomba Yesu woke wose. ");
INSERT INTO ruf_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Lekeni Yesu kalema, kamlongela, “Ghenda ukaye kune iwandughu tsako na uwalongele pfakutendele Imtwatsa na pfakwonele libatsi.” ");
INSERT INTO ruf_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Apfo imunu ayo koka Dekapoli kuwalongela achila Yesu chamtendele. Ne iwanu wose iwahulike tsawakangawala. ");
INSERT INTO ruf_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu hayalokile keli kumwambu kwe tsimbu, likingili lye iwanu litingana na limtsunguluka aho hambalimbali ha tsimbu. ");
INSERT INTO ruf_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Kuya imkulu yumwe we ing'anda ya ukulombela iyakemighwe Yairo tsakatsa, hayamwonile Yesu, keghwisa mmaghulu mwake, ");
INSERT INTO ruf_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","kamlomba “Imwanangu mdodo pinga koghula ng'ani. Nokulomba utse, umwikile ghamoko ghako ahone na yawe mghima.” ");
INSERT INTO ruf_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Apfo Yesu kaghenda naye. Na likingili lye iwanu limuwinza na kumkunughitsa kunughitsa. ");
INSERT INTO ruf_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Baho tsakukala ne ipinga yumwe yane utamu we kulawa idamu kwa miyaka kumi na mili. ");
INSERT INTO ruf_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ipinga ayo tsakadununzika ghendo kughenda kwe iwaghanga na kaghisa ipfinu pfake pfose, lekeni ng'apatile ng'apfu bae na kaghendelela kughula. ");
INSERT INTO ruf_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ipinga ayo hayahulike mbuli tsa Yesu, kabita mne likingili, kamghendela Yesu kwa kuchughu na kukinda ghwanda lyake, ");
INSERT INTO ruf_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","na kelongela imwenyegho “Ning'akinda ghwanda lyake nitsohona.” ");
INSERT INTO ruf_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Hayakindile lighwanda lyake, bahala idamu ileka kumlawa, naye kamanya mne lukuli lwake ka utamu wake uhona. ");
INSERT INTO ruf_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Bahala Yesu kamanya ingupfu imlawa, apfo kahunduka mne kingili na kughutsa, “Apfi imunu wachi yakindile lighwanda lyangu?” ");
INSERT INTO ruf_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Iwanang'ina wake wamwidika “Kwakona iwanu pfawokukunughitsa kunughitsa, kuya kwotughutsa ‘Apfi imunu wachi yanikindile?’ ” ");
INSERT INTO ruf_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Lekeni Yesu kaghendelela kulolesa yamwone imunu wachi iyatendile ichinu acho. ");
INSERT INTO ruf_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ipinga ayo kamanya ichinu ichimlawile, apfo kamghendela, kodedema kwa kupfuka na kamghwila mmaghulu mwake, kuya kamlongela ghose. ");
INSERT INTO ruf_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu kamlongela “Imwanangu, ukutoghola kwako kukuhonetsa. Ughende tseghamba na utamu wako uhone.” ");
INSERT INTO ruf_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu hayang'ali yolonga apfo, iwanu wangi watsa kulawa mne ing'anda ya Yairo, imkulu we ing'anda ya ukulombela wamlongela, “Imwanagho ma kafa, ebali kwoghendela kumdesa imlangulitsi?” ");
INSERT INTO ruf_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu hayahulike ichinu chawalongile, kabetsa, kamlongela imkulu we ing'anda ya ukulombela, “Leka kupfuka, ghweghwe toghola.” ");
INSERT INTO ruf_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Kuya Yesu ng'abamile bae imunu wowose amuwinze, ila kaghenda na Petiri, Jakobu na Yohane, ndughu yake Jakobu. ");
INSERT INTO ruf_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Hawapfikile mne ing'anda ya Yairo, Yesu tsakona tsogho na kahulika iwanu wolila. ");
INSERT INTO ruf_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yesu kengila mng'anda kawalongela, “Ebali mwotenda tsogho na kulila? Imwana ng'afile bae ila kawasa.” ");
INSERT INTO ruf_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Lekeni wamseka, apfo kawalapfa kunze, kawasola aba na mai wa imwana ayo ne iwanang'ina wake iyakalile nawo, wengila mne chiheleto chawasile imwana. ");
INSERT INTO ruf_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Kamkinda ghumoko kamlongela “Talita kumi!” mana yake, “Mwana mdodo pinga, nokulongela lamka!” ");
INSERT INTO ruf_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Bahala imwana kenuka na kandusa kughenda (imwana ayo tsakakala na miyaka kumi na mili). Ichinu achi hachilawile, iwanu wakangawala ghendo. ");
INSERT INTO ruf_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesu kawakanya ghendo waleke kumlongela imunu wowose ichinu ichilawile, kuya kawalongela wamwing'e imwana yula ichijo yaje. ");
INSERT INTO ruf_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu kalawa hanu aho kaghenda kune ghumji ghwake ne iwanang'ina wake wamuwinza. ");
INSERT INTO ruf_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Mne litsuwa lya Sabato, kandusa kulangulitsa mne Ing'anda ye ukulombela, iwanu wengi iwamhulikitse wakangawala. Waghutsa, “Angu aghapatile kwani agha ghose? Ne ihekima yachi yeng'ighwe yuno mbaka atende ipfinu pfa kukangawatsa?” ");
INSERT INTO ruf_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ayuno si yula msongola mibiki bae imwanaghe Mariya, ne iwandughu tsake tsina Jakobu, Yosefu, Yuda na Simoni, na lumbu tsake ng'awalibaha bae na twetwe? Apfo wamlema. ");
INSERT INTO ruf_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu kawalongela, “Manabii wohulikitsighwa chila hanu, ila ng'awohulikitsighwa bae mne imiji yawo na mghati mwa iwandughu tsawo, na mkaye mwawo iwenyegho.” ");
INSERT INTO ruf_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yesu ng'adahile bae kutenda pfinu pfa kukangawatsa ako, ila kawekila ghamoko iwatamu chidogho, kawahonetsa. ");
INSERT INTO ruf_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yesu tsakakangawala ng'ani kwa ukulema kwawo kutoghola. ");
INSERT INTO ruf_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Kuya Yesu kanga mne ipfijiji apfila kuwalangulitsa iwanu. Kawakema hamwe iwanang'ina wake kumi na weli, kawatuma weliweli na kaweng'a ukulu wa kuwalapfa ipfinyamkela. ");
INSERT INTO ruf_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Kuya kawalongela, “Mleke kusola ichinu chochose kwaajili ya ghumwanza, ila ing'weku iliyeka. Mleke kusola pfighate, imikoba ya ghamaghwanda wala sendi. ");
INSERT INTO ruf_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mpfale imikwabatsa, mleke kughala lighwanda lingi. ");
INSERT INTO ruf_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ing'anda yoyose yamtsakwingila, mkale baho mbaka hamtsakuka. ");
INSERT INTO ruf_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Na hanu hohose iwanu hawolema kuwabokela au kuwategheletsa, mlawe hanu aho na mkung'use litimbwisi mmaghulu mwenu ka ukalangama kuna wawo.” ");
INSERT INTO ruf_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Apfo tsawoka na kuwapetela iwanu watsileke nzambi tsawo. ");
INSERT INTO ruf_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Tsawalapfa ipfinyamkela wengi na kuwabaka ghamafuta iwatamu wengi, wawahonetsa. ");
INSERT INTO ruf_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Imndewa Herodi kahulika mbuli atso, kwaapfila taghwa lya Yesu tsalimanyika chila hanu. Iwanu wangi walonga, “Yohane Mbatitsa katsilihuka. Ndo mana kana ngupfu tsa ukutenda ipfinu pfa kukangawatsa.” ");
INSERT INTO ruf_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Lekeni wangi walonga, “Ayuno Eliya.” Na wangi walonga, “Ayuno nabii ka wala manabii wa ghumwande.” ");
INSERT INTO ruf_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herodi hayahulike apfo, kalonga, “Yohane iyanimghanile litwi katsilihuka!” ");
INSERT INTO ruf_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Kwaapfila Herodi imwenyegho tsakalaghitsa Yohane yaghoghighwe, yekighwe mne chifungo. Tsakatenda apfo kwaajili ya Herodiya mwehe wake, ipinga ayo tsakakala mwehe wa ndughu yake Filipi. ");
INSERT INTO ruf_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yohane Mbatitsa tsakaghendelela kumlongela Herodi, “Ng'apfinoghile bae ghweghwe kumkwela mwehe wa ndughu yako.” ");
INSERT INTO ruf_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Naye Herodiya tsakamhila Yohane na kabama amkome. Lekeni ng'adahile bae kwaajili ya Herodi. ");
INSERT INTO ruf_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodi tsakampfuka Yohane kwaapfila kamanya Yohane kakala imunu yanoghile na yenzeluke, apfo yang'ali yomlolesa. Tsayang'ali yonoghela kumhulikitsa, hata ka tsayang'ali yoghanzika ng'ani hayomalitsa kumhulikitsa. ");
INSERT INTO ruf_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Litsuwa limwe, Herodiya tsakapata nafasi mne ichihungo cha kwelekighwa kwa Herodi. Herodi tsakawatendela ichihungo iwatawala, iwakulu we asikali na ipfilongotsi we isi ya Galilaya. ");
INSERT INTO ruf_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Neghe Herodiya hayengile tsakapfina, kamdeng'elesa Herodi ne iwahenza wake. Apfo imndewa kamlongela imwana ayo, “Unilombe ichinu chochose chaubama, nitsokwing'a.” ");
INSERT INTO ruf_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Kelaha, “Nitsokwing'a chochose chaubama, hata ka inusu ya undewa wangu!” ");
INSERT INTO ruf_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Kuya imwana ayo kaghenda kumghutsa mai wake, “Nilombe choni?” Naye kamwidika, “Lomba litwi lya Yohane Mbatitsa.” ");
INSERT INTO ruf_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Imwana ayo katsuma mbaka kwa imndewa kamlomba, “Nobama ungaye litwi lya Yohane Mbatitsa mne lungo!” ");
INSERT INTO ruf_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Imndewa kona usungu ng'ani, lekeni ng'adahile bae kulema, kwaapfila tsakelaha hambele he iwahenza wake. ");
INSERT INTO ruf_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Bahala imndewa kamlaghitsa asikali, kamlongela aghale litwi lya Yohane. Asikali kaghenda mne chifungo, kamghana litwi Yohane. ");
INSERT INTO ruf_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Kuya kaghala litwi alyo mne lungo, kamwing'a imwana ayo. Naye kamwing'a mai wake. ");
INSERT INTO ruf_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Iwanang'ina wa Yohane hawahulike apfi, waghenda kulusola lukuli lwake, walutsika. ");
INSERT INTO ruf_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Iwatumighwa woya na wetingana kwa Yesu, wamlongela aghala ghose ghawatendile na kulangulitsa. ");
INSERT INTO ruf_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Yesu kawalongela, “Leka tughende tuliyeka hanu halihela imunu tukabwihile.” Kalonga apfo kwaapfila tsakukala ne iwanu wengi iwang'ali wakutsa na ukuka, mbaka Yesu ne iwanang'ina wake ng'awadahile bae kupata nafasi ya ukuja ichijo. ");
INSERT INTO ruf_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Apfo woka waliyeka mne mnumbwi, waghenda hanu halihela imunu. ");
INSERT INTO ruf_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Lekeni iwanu iwawonile hawang'ali wakuka, tsawamanya. Apfo watsuma kwa mghulu kulawa mne imiji yose, kuya walongola kupfika. ");
INSERT INTO ruf_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesu hayalawile mne mnumbwi, kona mtingano mkulu ghwe iwanu, kawonela libatsi kwaapfila tsawoneka ka iwang'olo iwalihela mdimi. Apfo kandusa kuwalangulitsa ipfinu pfingi. ");
INSERT INTO ruf_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Mihe haipfikile, iwanang'ina wake wamghendela wamlongela, “Hanu hano hana nyika iliyeka, na litsua liswa. ");
INSERT INTO ruf_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Waleke woke kune imighunda ne ipfijiji, ili wakeghulile ichijo iwenyegho.” ");
INSERT INTO ruf_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Lekeni kawedika, “Mwemwe muweng'e ichijo waje.” Wamghutsa, “Apfi kwotubama tughende tukawaghulile pfighate pfa sendi miya mbili tuweng'e waje?” ");
INSERT INTO ruf_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Kawaghutsa, “Mna pfighate pfingapi? Mghende mkalole.” Hawamanyile, wamlongela “Kuna pfighate pfitano ne iwasomba weli.” ");
INSERT INTO ruf_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Kuya Yesu kawalongela iwanang'ina wake, wawalongele iwanu wose weghole mne makingili, wakale hasi mne mitsani imibisi. ");
INSERT INTO ruf_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Apfo wakala mne makingili ghe iwanu, hano miya, hano hamsini. ");
INSERT INTO ruf_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Kuya Yesu kasola pfighate pfila pfitano ne iwasomba weli, kalola kulanga, kapfibaliki kuya kapfibena pfighate pfila. Kaweng'a iwanang'ina wake waweng'e iwanu. Pfipfila kawagholela iwanu wose iwasomba wala weli. ");
INSERT INTO ruf_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Iwanu wose waja weghuta, ");
INSERT INTO ruf_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ne iwanang'ina wake wadondola pfighate ne iwasomba yawakalile wamemetsa pfiseghe kumi na pfili. ");
INSERT INTO ruf_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Iwamale iwajile wakala 5000. ");
INSERT INTO ruf_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Bahala Yesu kawalongela iwanang'ina wake wengile mne mnumbwi wamlongolele kughenda Betisaida. Yeye tsayang'ali kowaagha iwanu woke. ");
INSERT INTO ruf_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Hayamalitse kuwaagha iwanu, kaghenda mlughongo kulomba. ");
INSERT INTO ruf_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Mihe haipfikile, mnumbwi ghukala mghati mwe tsimbu naye kakala aliyeka kunze kwe tsimbu. ");
INSERT INTO ruf_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Tsakawona iwanang'ina wake woghaya mne mnumbwi, kwaapfila libeho ling'ali lyowatowa kwa ingupfu. Habehi na kucha, kawaghendela, yang'ali yoghenda mchanya mwe ghamatsi. Kabama awalute, ");
INSERT INTO ruf_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","nawo hawamwonile koghenda mchanya mwe ghamatsi, tsawepfikitsa tsakakala mtsimu. Walila kwa litsi likulu, ");
INSERT INTO ruf_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","kwaapfila wose tsawamwona na wang'ali wopfuka. Bahala Yesu kawalongela, “Nene! Mleke kupfuka.” ");
INSERT INTO ruf_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Kuya kengila mne mnumbwi hamwe nawo, na libeho linyamala, iwanang'ina wake wakangawala ghendo. ");
INSERT INTO ruf_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Kwaapfila ng'awamanyile bae mbuli tsa pfighate, imimoyo yawo tsaikala mikomu. ");
INSERT INTO ruf_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Waloka tsimbu, wapfika mne isi ya Genesareti, baho wemitsa imnumbwi ghwawo. ");
INSERT INTO ruf_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Hawalawile mne mnumbwi, bahala iwanu wamtanga Yesu. ");
INSERT INTO ruf_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Apfo watsuma mne isi yose, wandusa kuwasola iwatamu mne ghamasatsi na kuwaghala hanu hohose kuwahulike Yesu kabaho. ");
INSERT INTO ruf_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Na chila hanu kwayaghendile, mne ipfijiji, imiji au kumighunda, waweka iwatamu mne ghamasoko. Wamlomba awaleke wakinde hata mindo ya lighwanda lyake, na wose iwamkindile tsawahona. ");
INSERT INTO ruf_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Mafarisayo wangi na iwolangulitsa Ghamalaghitso iwalawile Yerusalemu, wetingana hambele ha Yesu. ");
INSERT INTO ruf_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Wawona iwanang'ina wake wamwenga wakuja ichijo bila kwohopfugha ghamoko ghawo. ");
INSERT INTO ruf_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Mafarisayo na Wayahudi wose ng'awakuja bae ichijo mbaka wahopfughe ghamoko ghawo mbaka mne pfipfughumu, tsawakinda ichihendo cha iwabala wawo. ");
INSERT INTO ruf_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Hawolawa kusoko ng'awakuja ichinu chochose mbaka wachihopfughe. Pfipfila tsawakinda ipfihendo pfingi ka kuhopfugha ipfikombe, ghamabigha na pfiha. ");
INSERT INTO ruf_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Apfo awala Mafarisayo na iwolangulitsa Ghamalaghitso wamghutsa Yesu, “Ebali iwanang'ina wako ng'awokinda bae ipfihendo pfa iwabala, ila wakuja kwa ghamoko ghehile?” ");
INSERT INTO ruf_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu kawedika, “Isaya tsakatabili pfinoghile kuna mwemwe, mwemwe iwang'enye, ka pfandike. ‘Iwanu wano wonihulikitsa kwa imilomo yawo, lekeni imimoyo yawo yakutali na nene. ");
INSERT INTO ruf_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Wonitamanila hela, wolangulitsa ghamalaghitso ghe iwanu, ka ghamalaghitso ghe Imulungu!’ ");
INSERT INTO ruf_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Mleka ghamalaghitso ghe Imulungu, mwokinda ipfihendo pfe iwanu.” ");
INSERT INTO ruf_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Kuya kawalongela, “Pfinogha! Mna inzila inoghile ya kulema ghamalaghitso ghe Imulungu ili mkinde ipfihendo pfenu. ");
INSERT INTO ruf_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Musa tsakalonga, ‘Uwahulike aba wako na mai wako,’ na ‘Imunu wowose iyomligha aba wake au mai wake katsokufa.’ ");
INSERT INTO ruf_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Lekeni mwemwe mwolangulitsa, ka imunu kana ichinu cha kumwapfila aba wake au mai wake lekeni kolonga, ‘Ichinu achi Koribani’ mana yake, nzawadi kwe Imulungu, ");
INSERT INTO ruf_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","apfo ng'obamighwa keli kumwapfila aba wake au mai wake. ");
INSERT INTO ruf_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Apfo mwoibetsa imbuli ye Imulungu kwe ipfihendo pfenu pfambokele. Na mwotenda ipfinu pfingi ka apfo.” ");
INSERT INTO ruf_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Kuya Yesu kalikema keli kingili lila lye iwanu, kawalongela, “Mnitegheletse mwemwe wose, mmanye. ");
INSERT INTO ruf_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kuduhu ichinu ichikwingila mghati mwe imunu kulawa kunze ichidaha kumtenda yehe. Lekeni ichilawa mghati mwe imunu, acho chomtenda imunu yehe. ");
INSERT INTO ruf_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Imunu yane ghamaghutwi gha kuhulika na yahulike.” ");
INSERT INTO ruf_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Halilekile kingili lye iwanu na kwingila mng'anda, iwanang'ina wake wamghutsa mana ye imbuli ayo. ");
INSERT INTO ruf_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yesu kawalongela, “Apfi namwe mwahela tsimbutsi? Angu ng'ammanya bae ka kuduhu ichinu ichimwingila imunu kulawa kunze chimtende yehe? ");
INSERT INTO ruf_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kwaapfila ng'achimwingila bae mne ghumoyo ila chakwingila munda, kuya cholawa kunze kwe lukuli lwake.” Kwa ukulonga apfi, Yesu kapfitenda ipfijo pfose “pfinogha.” ");
INSERT INTO ruf_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kaghendelela kulonga, “Ichinu ichimlawa imunu, acho chomtenda yehe. ");
INSERT INTO ruf_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kwaapfila mne ghumoyo ghwe imunu, gholawa mawatso ghehile, utsinzi, ubapfi, ukukoma, dong'o, ");
INSERT INTO ruf_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ughoni, ughutsu, ufisadi, chepfu, maligho, kwighoda, chidandali ne ubotsi. ");
INSERT INTO ruf_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Agho ghose ghehile gholawa mghati mwe imunu, nagho ghomtenda imunu yehe.” ");
INSERT INTO ruf_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu kalawa hanu aho, kaghenda mne ghumji ghwa Tiro. Ako kengila mne ing'anda na ng'abamile bae imunu wowose amanye, lekeni ng'adahile bae kwipfisa. ");
INSERT INTO ruf_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ipinga yumwe iyakalile ne imwana pinga yane ichinyamkela, kahulika mbuli tsa Yesu. Apfo kamghendela, kamghwila mmaghulu mwake. ");
INSERT INTO ruf_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ipinga ayo tsakakala Mgiriki, iyelekighwe mne ghumji ghwa Sirofoinike. Kamlomba Yesu amlapfe mwanaghe ichinyamkela. ");
INSERT INTO ruf_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Lekeni Yesu kamwidika, “Tanu waleke iwana weghute. Ng'apfinoghile bae kusola ichijo che iwana na kuwasila wambwa.” ");
INSERT INTO ruf_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ipinga ayo kamwidika, “Imtwatsa, lekeni hata wambwa iwali hasi mwe imetsa wakuja ipfijo pfawalekile iwana.” ");
INSERT INTO ruf_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesu kamlongela ipinga yula, “Kwa apfo pfawidike, uke ukaye, ichinyamkela kamlawa imwanagho.” ");
INSERT INTO ruf_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Apfo ipinga yula koka ukaye, kampfika imwanaghe kawasa mne lusatsi na ichinyamkela kamlawa. ");
INSERT INTO ruf_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Kuya Yesu koka mne ghumji ghwa Tiro, kaghenda Galilaya kwa kubitila Sidoni na mne ghumji ghwa Dekapoli. ");
INSERT INTO ruf_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Iwanu wangi wamghalila imunu chitsiwi na iyang'adahile bae ukulonga pfinoghile, wamlomba Yesu amwikile ghamoko imunu ayo. ");
INSERT INTO ruf_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Apfo Yesu kamseghetsa imunu ayo hambali ne iwanu. Keka pfidole pfake mne ghamaghutwi ghe imunu ayo. Kuya kabwalula ghamate na kaludonza lulimi lwake. ");
INSERT INTO ruf_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Yesu kalola kulanga, kahumula kwe ingupfu, kamlongela imunu ayo, “Epfata!” (mana yake, “Ghubuka!”). ");
INSERT INTO ruf_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Bahala ghamaghutwi ghe imunu yula ghaghubuka, lulimi lwake luleghela, kandusa kulonga pfinoghile. ");
INSERT INTO ruf_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Kuya Yesu kawalaghitsa waleke kumlongela imunu wowose. Lekeni ka pfayaghendelele kuwaghoma, waghendelela kulalatsa mbuli ayo. ");
INSERT INTO ruf_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Iwanu wakangawala ghendo. Walonga, “Katenda ghoya chila ichinu. Hata pfitsiwi kowatenda wahulike, na pfibubu walonge!” ");
INSERT INTO ruf_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mne ghamatsuwa agho, kingili lingi likulu litingana. Kwaapfila tsawakala wahela ichijo, Yesu kawakema iwanang'ina wake, kawalongela, ");
INSERT INTO ruf_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nowonela libatsi iwanu wano, kwaapfila wakala na nene kwa ghamatsuwa madatu bila ukuja. ");
INSERT INTO ruf_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ning'awalongela woke mmakaye mwawo ne inzala, wodaha kutsilika mnzila, kwaapfila wangi wolawa kutali.” ");
INSERT INTO ruf_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Iwanang'ina wake wamghutsa, “Apfi hano kunyika imunu kodaha kupata kwani ichijo chokuweng'a iwanu wose wano waghute?” ");
INSERT INTO ruf_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu kawaghutsa, “Mna pfighate pfingapi?” Wamwidika, “Saba.” ");
INSERT INTO ruf_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yesu kawalongela iwanu wakale hasi. Kasola pfighate pfila saba, kapfibaliki, kapfibena na kuweng'a iwanang'ina wake waweng'e iwanu, nawo watenda pfipfo. ");
INSERT INTO ruf_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Pfipfila tsawakala ne iwasomba wadowado chidogho. Yesu kawabaliki pfipfila na kuwalongela iwanang'ina wake waweng'e iwanu. ");
INSERT INTO ruf_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Iwanu waja na kwighuta. Kuya iwanang'ina wake wadondola pfiseghe saba ipfimemile ipfijo ipfisighale. ");
INSERT INTO ruf_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Iwanu iwajile tsawakala elufu nne. Kuya Yesu kawaagha, ");
INSERT INTO ruf_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","bahala kengila mne mnumbwi ne iwanang'ina wake, kaghenda mne ghumji ghwa Dalamanuta. ");
INSERT INTO ruf_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Mafarisayo wangi wamghendela na wandusa kumghutsa. Wamghetsa, wabama chitango kulawa kulanga. ");
INSERT INTO ruf_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Tsakwona usungu mne ghumoyo ghwake, kalonga, “Ebali mweleko ghuno ghwobama ichitango? Nowalongela ghendo, ng'awatsakwing'ighwa ichitango chochose.” ");
INSERT INTO ruf_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Kuya kawaleka, kengila mne mnumbwi, kaloka kaghenda kumwambu. ");
INSERT INTO ruf_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Iwanang'ina tsawesemwa kughala pfighate, wakala na chighate chimwe chiliyeka mne mnumbwi. ");
INSERT INTO ruf_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu kawakanya, kawalongela, “Mwalangitse ne hamila ya Mafarisayo na ya Herodi!” ");
INSERT INTO ruf_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Wandusa kwilongela iwenyegho, “Kalonga apfi kwaapfila twahela chighate.” ");
INSERT INTO ruf_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu tsakamanya chawang'ali wolonga. Kawaghutsa, “Ebali mwelongela iwenyegho, kwaapfila mwahela chighate? Mng'ali ng'ammanya au kutanga? Apfi imimoyo yenu mikomu? ");
INSERT INTO ruf_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mna tsinenge ng'amkwona bae, na mna ghamaghutwi ng'amhulika bae? Na ng'amkumbuka bae ");
INSERT INTO ruf_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","hanibenile pfighate pfila pfitano na kuweng'a wala iwanu elufu tano? Apfi tsamdondole pfiseghe pfingapi ipfimemile pfihande ipfisighale?” Wamlongela, “Kumi na pfili.” ");
INSERT INTO ruf_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Na hanibenile pfighate pfila saba na kuweng'a iwanu elufu nne, apfi mdondole pfiseghe pfingapi ipfimemile pfihande ipfisighale?” Wamwidika “Saba.” ");
INSERT INTO ruf_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Kawaghutsa, “Pfii ng'ana mmanye bae?” ");
INSERT INTO ruf_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Tsawapfika Betisaida, iwanu wangi wamghalila Yesu ichifita, wamlomba amkinde. ");
INSERT INTO ruf_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Kamkinda ghumoko ichifita yula, kamlapfa kunze kwe chijiji. Kuya kambwalulila ghamate mnenge, kamwikila ghamoko ghake, kamghutsa, “Kwodaha kwona ichinu chochose?” ");
INSERT INTO ruf_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Imunu ayo kalola kuya kalonga, “Nakwona iwanu, wakoneka ka imibiki itsunguluka.” ");
INSERT INTO ruf_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesu keka keli ghamoko mne tsinenge tse imunu ayo. Kuya tsinenge tsake tsifughuka, naye kona pfinoghile ipfinu pfose. ");
INSERT INTO ruf_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu kamlongela aghende ukaye yake na kamghoma kwingila mne ipfijiji na kuwalongela iwanu. ");
INSERT INTO ruf_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu ne iwanang'ina wake waghenda mne ipfijiji pfa Kaisariya Filipi. Mnzila Yesu kawaghutsa, “Apfi iwanu wolonga nene nili nani?” ");
INSERT INTO ruf_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Wamwidika, “Wangi wolonga ghweghwe kwa Yohane Mbatitsa, wangi wolonga kwa Eliya na wangi wolonga kwa yumwe wa manabii.” ");
INSERT INTO ruf_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Kuya Yesu kawaghutsa, “Namwe mwolonga nene nili nani?” Petiri kamwidika “Ghweghwe kwa Kiristu.” ");
INSERT INTO ruf_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yesu kawakanya “Mleke kumlongela imunu wowose mbuli tsangu.” ");
INSERT INTO ruf_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Kuya kandusa kuwalangulitsa iwanang'ina wake. “Imwana we Imunu kobamighwa adununzike ng'ani na kulemighwa ne iwabala, watambika wakulu, ne iwolangulitsa Ghamalaghitso. Na kobamighwa akomighwe ne atsilihuke mne litsuwa lya kadatu.” ");
INSERT INTO ruf_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Tsakawalongela imbuli ayo bila kupfisa, apfo Petiri kamsola Yesu mmbalimbali, kandusa kumkembela. ");
INSERT INTO ruf_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Lekeni Yesu kahunduka, kawalolesa iwanang'ina wake na kumkembela Petiri, “Soghela hano Setani! Kwaapfila ng'aukwalangula bae mbuli tse Imulungu, ila kokwalangula mbuli tse iwanu.” ");
INSERT INTO ruf_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Kuya Yesu kawakema iwanang'ina wake na kingili lye iwanu kawalongela, “Imunu wowose iyobama kuniwinza, yeleme imwenyegho, asole msalaba ghwake aniwinze.” ");
INSERT INTO ruf_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kwaapfila imunu wowose iyobama kuukombola ughima wake, katsowaghisa, ila imunu wowose iyowaghisa ughima wake kwaajili ya nene na kwaajili ye Imbuli Inoghile katsoukombola. ");
INSERT INTO ruf_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Apfi iwanu wobweda choni ka wopata isi yose lekeni wakwaghisa ughima wawo? ");
INSERT INTO ruf_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Kuduhu ichinu chawodaha kulapfa waupate keli ughima wawo. ");
INSERT INTO ruf_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Imunu ang'ambonela chinyala nene na mbuli tsangu mne iwanu wa mweleko ghuno ghwa nzambi na utsinzi, Imwana we Imunu katsomwonela chinyala hatsakutsa mne utunitso wa Aba wake hamwe ne wamalaika wahenzeluka wa kulanga. ");
INSERT INTO ruf_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Kaghendelela kulonga, “Nowalongela ghendo, iwanu wamwenga iwemile hano ng'awatsakufa bae mbaka wawone Undewa we Imulungu iukutsa kwe ingupfu.” ");
INSERT INTO ruf_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Matsuwa sita hambele, Yesu kawasola Petiri, Jakobu na Yohane, kaghenda nawo mchidando hanu halihela imunu. Baho Yesu kaghaluka chihanga, hambele hawo. ");
INSERT INTO ruf_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Na ghamaghwanda ghake ghawa matselu ng'ani, kuduhu imunu wowose mne isi iyodaha kughatsapfa ghamaghwanda ghawe matselu apfo. ");
INSERT INTO ruf_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Kuya Eliya na Musa walawila hambele hawo, walonga na Yesu. ");
INSERT INTO ruf_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petiri kamlongela Yesu, “Mlangulitsi, pfinogha twetwe tukale hano. Leka tutsenge pfibumbulika pfidatu, chimwe cha kwako, chimwe cha Musa na chimwe che Eliya.” ");
INSERT INTO ruf_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ng'amanyile bae cha kulonga, kwaapfila wose tsawang'ali wopfuka ng'ani. ");
INSERT INTO ruf_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kuya liwingu lilawila, liwaghubika, na litsi lilawila mne liwingu. “Ayuno imwanangu yanoghele, mumtegheletse!” ");
INSERT INTO ruf_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Bahala hawalolese mmbalimbali ng'awamwonile imunu wowose hamwe nawo, ila Yesu yaliyeka. ");
INSERT INTO ruf_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Hawakalile wohulumka kulawa mchidando, Yesu kawalaghitsa waleke kumlongela imunu wowose ghawonile, mbaka Imwana we Imunu hatsotsilihuka kulawa mne lifwa. ");
INSERT INTO ruf_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Watoghola chayalongile, lekeni weghutsa, “Kutsilihuka kulawa mne lifwa mana yake choni?” ");
INSERT INTO ruf_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Kuya wamghutsa Yesu, “Ebali iwolangulitsa Ghamalaghitso wolonga Eliya kobamighwa tanu yatse?” ");
INSERT INTO ruf_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesu kawedika, “Ona, tanu Eliya kakutsa kwika chila ichinu pfinoghile. Ebali lelo yandikighwa Imwana we Imunu kobamighwa yadununzike na kulemighwa? ");
INSERT INTO ruf_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Lekeni nowalongela, Eliya katsa na wamtendela ghose ghawabamile, ka mbuli tsake pfatsandikighwe.” ");
INSERT INTO ruf_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Hawawapfikile iwanang'ina wangi, wona mtingano mkulu we iwanu liwatsunguluka ne iwolangulitsa Ghamalaghitso wehisanya nawo. ");
INSERT INTO ruf_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Bahala iwanu wose hawamwonile Yesu wakangawala ng'ani, wamtsumila kumlamsa. ");
INSERT INTO ruf_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesu kawaghutsa iwanang'ina wake, “Apfi mwehisanya nawo choni?” ");
INSERT INTO ruf_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Imunu yumwe mne kingili lye iwanu kamwidika, “Mlangulitsi, nikughalila imwanangu kana ichinyamkela iyamtedile awe chibubu. ");
INSERT INTO ruf_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Na chila hayomnighula, komghwisa hasi, na imwana kolawa lihofu mne mlomo, koghegheda ghamatsino ghake kuya koghoghodala. Niwalomba iwanang'ina wako wamlapfe ichinyamkela, lekeni ng'awadahile bae.” ");
INSERT INTO ruf_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu kawedika, “Mwemwe lukolo ing'alutoghola! Nikale namwe mbaka tsuwachi? Mnighalile imwana ayo!” ");
INSERT INTO ruf_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Wamghalila imwana ayo. Ichinyamkela hamwonile Yesu, bahala kamghwisa imwana ayo chisala, imwana kaghwa hasi na kwibulughitsa, kalapfa lihopfu mne mlomo. ");
INSERT INTO ruf_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu kamghutsa aba we imwana ayo, “Angu imwana yuno kapfino kulawa tsuwachi?” Kamwidika, “Kulawa udodo wake. ");
INSERT INTO ruf_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Komghwisagha mne ghumoto au mne ghamatsi ili yamkome. Lekeni ka kwodaha kutenda ichinu, utwonele libatsi ne utwapfile.” ");
INSERT INTO ruf_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu kalonga, “Ka kwodaha! Ghose ghodahika kwe imunu iyotoghola.” ");
INSERT INTO ruf_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Bahala aba we imwana yula kakemelela kalonga, “Notoghola, ila unyapfile nitoghole ghendo!” ");
INSERT INTO ruf_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu halyonile kingili lye iwanu lyakongetseka hambele hake, kamkembela ichinyamkela ayo, “Ghwe ichinyamkela we ububu ne utsiwi, nokulongela ulawe mne imwana yuno na uleke kumwingila keli!” ");
INSERT INTO ruf_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ichinyamkela kakemelela, kamghwisa chisala imwana ayo, kamlawa. Na imwana tsakoneka ka kafa, na iwanu wengi walonga, “Kafa!” ");
INSERT INTO ruf_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Lekeni Yesu kamkinda ghumoko imwana ayo, kamwapfila kwinuka, naye kenuka. ");
INSERT INTO ruf_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesu hayengile mng'anda, iwanang'ina wake wamghutsa hawakalile naye waliyeka, “Ebali twetwe ng'atudahile bae kumlapfa ichinyamkela yula?” ");
INSERT INTO ruf_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesu kawedika, “Ichinyamkela ka yuno ng'odaha bae kulawa kwa inzila yoyose, ila kwa kulomba kuliyeka.” ");
INSERT INTO ruf_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesu na iwanang'ina wake woka hanu hala waghenda Galilaya. Yesu ng'abamile bae imunu wowose amanye kwayali, ");
INSERT INTO ruf_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kwaapfila yang'ali yowalangulitsa iwanang'ina wake. Kawalongela, “Imwana we imunu katsoghelighwa mne ghamoko ghe iwanu, nawo watsomkoma. Ghamatsuwa madatu hambele, katsotsilihuka.” ");
INSERT INTO ruf_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Lekeni ng'awaimanyile bae imbuli ayo na wapfuka kumghutsa. ");
INSERT INTO ruf_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Hawafikile Kaperinaumu, wengila mng'anda na Yesu kawaghutsa iwanang'ina wake, “Ichinu chachi chamng'ali mwisongela mnzila?” ");
INSERT INTO ruf_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Lekeni ng'awamwidike bae, kwaapfila wang'ali wesongela yuhi yali mkulu. ");
INSERT INTO ruf_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu kakala hasi, kawakema iwanang'ina wake kumi na weli, kalonga, “Imunu wowose yobama kuwa wa mwanduso, kobamighwa yawe wa utsighilo, na yawe imtumwa wa wose.” ");
INSERT INTO ruf_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Kuya kamsola imwana mdodo, kamwika mghati mwawo, kawalongela, ");
INSERT INTO ruf_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Imunu wowose iyombokela imwana mdodo ka yuno kwa taghwa lyangu, kombokela nene. Ne imunu iyombokela nene, kombokela yula iyanitumile.” ");
INSERT INTO ruf_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohane kamlongela Yesu, “Mlangulitsi, tumwona imunu kolapfa ipfinyamkela kwa taghwa lyako. Tumghoma kwaapfila ng'olawila bae mne kingili lyetu.” ");
INSERT INTO ruf_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesu kawalongela, “Mleke kumghoma. Haduhu imunu iyodaha kutenda ipfinzonza kwa taghwa lyangu na baho kulonga mbuli tsangu pfihile. ");
INSERT INTO ruf_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kwaapfila imunu wowose yali ubali wetu, ayo kamiyetu. ");
INSERT INTO ruf_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nowalongela ghendo, imunu wowose iyoweng'a ichikombe cha ghamatsi kwaapfila mwemwe mwa iwanu wa Kiristu, katsobokela ghweko lyake. ");
INSERT INTO ruf_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Imunu wowose iyowahonza wadodo wano iwonitoghola watende ghehile, ng'apfu imunu ayo yohighwe libwe lya kusaghila msingo mwake na kwasighwa mne ibahali. ");
INSERT INTO ruf_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ka ghumoko ghwako ghwokuhonza utende ghehile, ghughane. Ng'apfu kwingila kune ughima na ghumoko ghumwe, kubita kwingila jehanamu na ghamoko meli. ");
INSERT INTO ruf_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ako membele iwowaja ng'awakufa bae, na ghumoto ighuwalakatsa ng'aghutsimika bae. ");
INSERT INTO ruf_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ka mghulu ghwako wokuhonza utende ghehile, ghughane. Ng'apfu kwingila kune ughima na mghulu ghumwe, kubita kuwa na ghamaghulu meli na kwasighwa jehanamu. ");
INSERT INTO ruf_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ako membele iwowaja ng'awakufa bae, na ghumoto ighuwalakatsa ng'aghutsimika bae. ");
INSERT INTO ruf_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Na ka inenge yako yokuhonza utende ghehile, ing'ole. Ng'apfu kwingila kune Undewa we Imulungu na inenge imwe, kubita kuwa na tsinenge mbili na kwasighwa jehanamu. ");
INSERT INTO ruf_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ako membele wake ng'awakufa bae, na ghumoto ghwake ng'aghutsimika bae. ");
INSERT INTO ruf_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Chila imunu katsodeghetetsighwa kwa ghumoto ka inyama pfaighumighwa imunyu. ");
INSERT INTO ruf_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Imunyu inogha, lekeni ka ihinyika, itsoghumighwa choni mbaka ikolele keli? “Muwe ne imunyu mghati mwenu, na mkale tseghamba.” ");
INSERT INTO ruf_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Kuya Yesu koka hanu hala kaghenda kune chijiji cha Yudeya na kuloka ghumto Yoridani. Kuya kingili lye iwanu limtsila, naye kawalangulitsa ka pfatsowele. ");
INSERT INTO ruf_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Mafarisayo wangi wamghendela, wamghetsa kwa kumghutsa, “Apfi pfinogha imunu kumleka mwehe wake?” ");
INSERT INTO ruf_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu kawedika, “Apfi Musa yalaghitse choni?” ");
INSERT INTO ruf_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Wedika, “Musa kalonga, twodaha kwandika talaka na kuwaleka.” ");
INSERT INTO ruf_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu kawalongela, “Musa kandika apfo kwaapfila imimoyo yenu misughu. ");
INSERT INTO ruf_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Lekeni kulawa mwanduso, ‘Imulungu kalumba mmale ne ipinga.’ ");
INSERT INTO ruf_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Apfo, immale katsomleka mai wake na aba wake, naye katselunga na mwehe wake, ");
INSERT INTO ruf_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","nawo watsokuwa lukuli lumwe na si weli keli bae, ila lukuli lumwe.’ ");
INSERT INTO ruf_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Apfo chayalungile Imulungu, imunu yaleke kuchibaghula.” ");
INSERT INTO ruf_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Hawoyile keli mng'anda, iwanang'ina wake wamghutsa Yesu imbuli ayo. ");
INSERT INTO ruf_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Kawedika, “Imunu wowose iyomleka mwehe wake na kukwela ipinga yungi komtendela utsinzi mwehe wake. ");
INSERT INTO ruf_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Pfipfila, ipinga yomleka immale wake na kukwelighwa ne immale yungi komtendela utsinzi immale wake.” ");
INSERT INTO ruf_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Iwanu wamwenga wamghalila Yesu iwana wadowado yawekile ghamoko, lekeni iwanang'ina wake wawakembela. ");
INSERT INTO ruf_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu honile apfi tsakona usungu, kawalongela, “Muwaleke iwana wadowado watse kuna nene, mleke kuwaghoma kwaapfila Undewa wa Imulungu wa iwana ka wano. ");
INSERT INTO ruf_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nowalongela ghendo, imunu wowose yolema kuubokela Undewa we Imulungu ka imwana mdodo, ng'atsowingila bae.” ");
INSERT INTO ruf_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Kawasola iwana awo, kawekila ghamoko, kawabaliki. ");
INSERT INTO ruf_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu hayang'ali yakuka, imunu yumwe kamtsumila, kamtowela maghoti, kamghutsa. “Mlangulitsi yunoghile, nitende ichinu chachi niubokele ughima wa ghamatsuwa ghose?” ");
INSERT INTO ruf_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu kamghutsa, “Ebali unikema nene ninogha? Kuduhu imunu yanoghile ila Imulungu yaliyeka. ");
INSERT INTO ruf_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kwoghamanya ghamalaghitso. ‘Uleke kukoma, Uleke utsinzi, Uleke ubapfi, Uleke kulonga ughutsu, Uleke ung'enye, Uwahulikitse aba wako na mai wako.’ ” ");
INSERT INTO ruf_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Imunu ayo kamwidika, “Mlangulitsi, agho ghose nighakinda kulawa udodo wangu.” ");
INSERT INTO ruf_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu kamlola, kamnoghela, kamlongela, “Kuhungukighwa na ichinu chimwe, ghenda ukautse pfose pfaulinapfo uweng'e sendi iwahingwa, naghwe kutsakuwa ne utajiri kulanga. Kuya utse uniwinze.” ");
INSERT INTO ruf_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Hayahulike apfo, kaghudubuka koka kwa usungu kwaapfila tsakakala na mali nyingi. ");
INSERT INTO ruf_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu kalola mmbalimbali, kawalongela iwanang'ina wake, “Itsakuwa pfikomu kwe imunu tajiri kwingila mne Undewa we Imulungu.” ");
INSERT INTO ruf_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Iwanang'ina wake wakangawala hawahulike mbuli atso. Lekeni Yesu kalonga keli, “Iwanangu, itsakuwa pfikomu kwingila mne Undewa wa Imulungu! ");
INSERT INTO ruf_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Pfikomu kwa imunu tajiri kwingila mne undewa wa Imulungu kubita imnyama yokemighwa ngamiya kwingila mne litobo lya sindano.” ");
INSERT INTO ruf_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Iwanang'ina wakangawala ghendo, weghutsa, “Lelo yuhi iyodaha kukombolighwa?” ");
INSERT INTO ruf_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu kawalola, kalonga, “Kwe imunu ng'aidahika bae, lekeni kwe Imulungu si pfipfo bae, ghose ghodahika kwe Imulungu.” ");
INSERT INTO ruf_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Petiri kamlongela, “Tuleka chila chinu tukuwinza ghweghwe!” ");
INSERT INTO ruf_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu kawedika, “Nowalongela ghendo, imunu wowose yalekile kaye yake au iwandughu tsake au lumbu tsake, aba wake au mai wake au iwanaghe au imighunda kwaajili ya nene ne Imbuli Inoghile, ");
INSERT INTO ruf_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","katsobokela ketseketse mne ghamatsuwa ghano. Katsobokela kaye, iwandughu, lumbu, mai, iwana, ne imighunda na kudununzika na mne ghamatsuwa ighakutsa katsobokela ughima wa ghamatsuwa ghose. ");
INSERT INTO ruf_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Lekeni awala iwalongole watsakuwa kuchughu ne iwali kuchughu watsolongola.” ");
INSERT INTO ruf_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu ne iwanang'ina wake wang'ali wogheluka woghenda Yerusalemu, Yesu kawalongola, iwanang'ina wake wakangawala ne iwanu iwakalile womuwinza wose wapfuka. Yesu kawasola keli iwanang'ina wake kumi na weli mmbalimbali, kawalongela aghala ighatsomlawila. ");
INSERT INTO ruf_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Kawalongela, “Mtegheletse, twoghenda Yerusalemu, ako Imwana we Imunu katsakwing'ighwa kwa pfilongotsi we inambiko na iwolangulitsa Ghamalaghitso. Nawo watsomuhigha yafe na kwing'ighwa kwa Iwanu si Wayahudi bae. ");
INSERT INTO ruf_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Watsombetsa, watsombwalulila ghamate, watsomfapula ne ipfiboko, na ghamatsuwa madatu hambele, katsotsilihuka.” ");
INSERT INTO ruf_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Kuya Jakobu na Yohane, iwana wa Sebedayo wamghendela Yesu, wamlongela, “Mlangulitsi kuna ichinu twobama ututendele twetwe.” ");
INSERT INTO ruf_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Kawaghutsa, “Chinu chachi?” ");
INSERT INTO ruf_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Wamwidika, hautsokala mne chighoda chako che Undewa mne utunitso wako, twobama tukale naghwe, yumwe ubali wako wa kujilo na yungi ubali wako wa kumoso. ");
INSERT INTO ruf_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu kawedika, “Ng'ammanyile bae chamlomba. Apfi mwodaha kunwela ichikombe chanikunwela nene au kubatitsighwa ubatitso wanibatitsighwa nene?” ");
INSERT INTO ruf_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Wamwidika, “Twodaha.” Yesu kawalongela, “Mtsochinwela ichikombe chanikunwela nene na kubatitsighwa ubatitso wanibatitsighwa. ");
INSERT INTO ruf_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Lekeni imbuli ya kukala ubali wangu wa kujilo au wa kumoso si yangu bae kuweng'a. Hanu aho watsokala awala iwasaghulighwe ne Imulungu.” ");
INSERT INTO ruf_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Iwanang'ina wala kumi hawahulike achila chawalombile Jakobu na Yohane wawonela maya. ");
INSERT INTO ruf_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesu kawakema wose hamwe, kawalongela, “Mwomanya awala iwakwoneka iwakulu we iwanu iwali si Wayahudi bae wowatawala kwe ingupfu. Na iwakulu awo wana ukulu kune iwanu. ");
INSERT INTO ruf_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Lekeni kuna mwemwe ileke kuwa apfo, imunu wowose iyobama kuwa mkulu kuna mwemwe kobamighwa yawe imtumwa, ");
INSERT INTO ruf_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","imunu wowose iyobama kuwa mkulu kobamighwa yawe imtumwa wa wose. ");
INSERT INTO ruf_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kwaapfila Imwana we Imunu, ng'atsile bae kutumikighwa, ila katsa kutumikila na kulapfa ughima wake kwa kuwakombola iwanu wengi.” ");
INSERT INTO ruf_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Kuya wapfika Yeriko, Yesu ne iwanang'ina wake hamwe na kingili lye iwanu hawang'ali wakuka mne ghumji, ichifita yumwe iyakemighwe Batimayo imwana wa Timayo kakala mmbalimbali mwe inzila kolomba. ");
INSERT INTO ruf_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Naye hayahulike Yesu Mnatsareti kobita, kandusa kukemelela, “Yesu, Imwana wa Daudi! Mbonele libatsi.” ");
INSERT INTO ruf_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Iwanu wengi wamkembela, wamlongela yenyamale, lekeni kaghendelela kukema, “Imwana wa Daudi, mbonele libatsi!” ");
INSERT INTO ruf_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu kema, kalonga, “Mlongeleni yatse.” Apfo wamkema, wamlongela, “Wighangamitse! Winuke kokukema.” ");
INSERT INTO ruf_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Kalyasa lighwanda lyake, kadaluka kamghendela Yesu. ");
INSERT INTO ruf_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu kamghutsa, “Kwobama nikutendele choni?” Ichifita ayo kamwidika, “Mlangulitsi, nobama kwona.” ");
INSERT INTO ruf_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu kamlongela, “Ghenda, ukutoghola kwako kukuhonetsa.” Bahala kadaha kwona, kuya kamuwinza Yesu mnzila. ");
INSERT INTO ruf_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Hawapfikile habehi na Yerusalemu, habehi ne imiji ya Betifage na Betaniya, kune Chidunda cha Mitseituni, Yesu kawatuma iwanang'ina wake weli walongole. ");
INSERT INTO ruf_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Kawalongela, “Mghende mne ichijiji ichili hambele henu, hamtsokwingila, mtsomwona imwana we ipunda kohighwa, naye yang'ali kudinighwa ne imunu. Mumdohole, mumghale hano. ");
INSERT INTO ruf_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Imunu wowose ang'awaghutsa, ‘Ebali mtenda apfo?’ mumlongele, ‘Imtwatsa kombama, kuya katsomuyitsa sambi.’ ” ");
INSERT INTO ruf_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Iwanang'ina wala woka, wamwona imwana we ipunda kohighwa hane libani. Hawang'ali womdohola, ");
INSERT INTO ruf_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","iwanu wangi iwemile hala wawaghutsa, “Mtenda choni? Mwomdohola imwana we ipunda?” ");
INSERT INTO ruf_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Wawedika ka Yesu pfayawalongele ne iwanu awo wawaleka woke naye. ");
INSERT INTO ruf_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Wamghala imwana we ipunda ayo kwa Yesu, kuya weka ghamaghwanda ghawo mchanya mwake, Yesu kakala mchanya mwake. ");
INSERT INTO ruf_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Iwanu wengi wanzasa ghamaghwanda ghawo mnzila, ne iwanu wangi wabena imiputila mne imighunda, wainzasa mnzila. ");
INSERT INTO ruf_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ne iwanu iwamlongolele na awala iwamuwinzile wakemelela walonga, “Mumtunitse Imulungu! Yabalikiighwe iyakutsa kwa taghwa lye Imtwatsa! ");
INSERT INTO ruf_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Imulungu ubaliki Undewa iukutsa wa mndewa wetu Daudi. Mumtunye Imulungu yali kuchanya ng'ani!” ");
INSERT INTO ruf_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu kengila Yerusalemu, kaghenda mne Ing'anda ye Imulungu. Kalola mmbalimbali chila hanu, lekeni kwaapfila litsua tsaliswa, kaghenda Betaniya ne iwanang'ina wake kumi na weli. ");
INSERT INTO ruf_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Nemitondo yake hawang'ali wolawa Betaniya, Yesu tsakakala na nzala. ");
INSERT INTO ruf_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Kaghwona ghumbiki ghwa mtini kwa kutali ghune imitsani mingi. Kaghenda kulola ka kodaha kupata tini. Lekeni hayapfikile ng'apatile bae tini ila imitsani iliyeka, kwaapfila msimu wa tini tsaghung'ali. ");
INSERT INTO ruf_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Kuya Yesu kaghulongela ghumbiki, “Kulawa lelo na kughendelela, kuduhu imunu iyatsokuja keli ghamatunda ghako.” Ne iwanang'ina wake wamuhulika hayalongile apfo. ");
INSERT INTO ruf_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Hawapfikile Yerusalemu, Yesu kengila mne Ing'anda ye Imulungu, kandusa kuwawinga awala iwang'ali wohutsa na kughula mghati mwe Ing'anda ye Imulungu. Katsibidula tsimetsa tse iwanu iwotsibena tsisendi na pfighoda pfe iwanu iwohutsa iwanjiwa, ");
INSERT INTO ruf_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","kawaghoma kusola ichinu chochose mghati mwe Ing'anda ye Imulungu. ");
INSERT INTO ruf_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Kuya kawalangulitsa, “Apfi ng'ayandikighwe bae, ‘Ing'anda yangu itsokemighwa ing'anda ya ukulombela ye iwanu we isi tsose?’ Lekeni mwemwe mwoitenda mango ye iwabapfi!” ");
INSERT INTO ruf_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Wapfilongotsi we inambiko na iwolangulitsa Ghamalaghitso hawahulike apfi, wandusa kubama inzila ya kumkoma Yesu. Lekeni wang'ali wompfuka, kwaapfila iwanu wose wang'ali wokangawala kwa ghamalangulitso ghake. ");
INSERT INTO ruf_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Mihe haipfikile, Yesu ne iwanang'ina wake woka mne ghumji agho. ");
INSERT INTO ruf_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Nemitondo yake, hawang'ali woghenda waghwona ghumtini ghula ghunyala kulawa msina. ");
INSERT INTO ruf_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petiri kakumbuka chayalongile Yesu, kamlongela, “Mlangulitsi, ulole! Imbiki ghughulighite ghunyala!” ");
INSERT INTO ruf_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu kedika, “Mumtoghole Imulungu. ");
INSERT INTO ruf_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nowalongela ghendo, imunu wowose ang'achilongela chidunda chino, ‘Ghenda wiyase mwibahali’ na ka ng'akwalangula mne ghumoyo ghwake na kutoghola chayalongile chitsolawila, chitsotendeka kwaajili yake. ");
INSERT INTO ruf_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Apfo nowalongela, hamlomba na kulomba ghoghose, mtoghole ka mwoghabokela, nagho ghatsokuwa ghenu. ");
INSERT INTO ruf_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Na hamlomba, ka kuna imunu kakutendela pfihile, umleghusile ghamatotso ghake, naye Aba wenu yali kulanga katsowaleghusila nzambi tsenu.” ");
INSERT INTO ruf_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Lekeni ka ng'amuwaleghusila ghamatotso ghawo, naye Aba wenu yali kulanga ng'atsowaleghusila nzambi tsenu bae. ");
INSERT INTO ruf_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Wapfika keli Yerusalemu, na Yesu hayang'ali koghenda ghenda mne Ing'anda ye Imulungu, pfilongotsi we inambiko, iwolangulitsa Ghamalaghitso ne iwabala wamghendela. ");
INSERT INTO ruf_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Wamghutsa, “Kwa ukulu wachi kotenda ipfinu pfino? Na yuhi iyakwing'ile ukulu uno wa kutenda ghano?” ");
INSERT INTO ruf_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu kawedika, “Na nene nowaghutsa imbuli imwe, mnyidike, nani nitsowalongela kwa ukulu wachi notenda ghano ghose. ");
INSERT INTO ruf_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Mnilongele, ubatitso wa Yohane ulawa kulanga au kwe iwanu?” ");
INSERT INTO ruf_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Weghutsa, walonga, “Tung'alonga ‘Ulawa kulanga’ katsotughutsa, ‘Ebali lelo ng'amtoghole?’ ");
INSERT INTO ruf_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","lekeni tung'alonga, ‘Ulawa kwe iwanu.’ ” Wawapfuka iwanu, kwaapfila iwanu wose tsawamanya Yohane tsakakala nabii. ");
INSERT INTO ruf_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Apfo wamwidika, “Ng'atumanyile bae.” Yesu kawalongela, “Na nene siwalongela bae yuhi iyangaile ukulu wa kutenda ghano.” ");
INSERT INTO ruf_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesu kandusa kulonga nawo kwa imbuli, “Imunu yumwe tsakahanda mitsabibu mne mghunda. Kuya kaghutsengela luwa, kahimba hanu ha ukukamila na kutsenga chilingilo. Keka wemilitsi, kuya koka isi ya kutali. ");
INSERT INTO ruf_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ghumsimu ghwa kupfuna tsabibu haghupfikile, kamtuma imtumwa wake akasole tsabibu. ");
INSERT INTO ruf_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Lekeni wemilitsi wamghogha, wamtowa, wamuwinga bila kumwing'a chinu. ");
INSERT INTO ruf_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kuya imunu ayo kamtuma imtumwa yungi. Ayo wamtowa mwitwi na kumtendela pfihile. ");
INSERT INTO ruf_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Kamtuma yungi, ayo naye wamkoma. Kawatuma iwatumwa wangi wengi, wangi wawatowa na wangi wawakoma. ");
INSERT INTO ruf_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Yakalile imunu yumwe yaliheka wa kumtuma, naye iye imwanaghe iyamnoghele ng'ani. Kalonga, ‘Ayu wa ukumambulitsa nakwona watsomhulikitsa, kwaapfila ka mwanangu.’ ");
INSERT INTO ruf_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Lekeni wemilitsi wala welongela, ‘Ayu ambe mhala mghunda ghuno. Leka tumkome ili mghunda ghuno ghuwe ghwetu!’ ");
INSERT INTO ruf_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Wamghogha, wamkoma, wamwasa kunze kwe mghunda.” ");
INSERT INTO ruf_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yesu kaghutsa, “Imunu yane mghunda yatsotendatse? Katsakutsa kuwakoma wemilitsi wose na kuweng'a iwanu wangi mghunda aghwo. ");
INSERT INTO ruf_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ng'amsomile bae liandiko ililonga. ‘Libwe lyawalilemile iwotsenga, Alyo liwa libwe kulu lya haghati. ");
INSERT INTO ruf_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Imbuli ino ilawa kwe Imtwatsa, nayo yotukangawatsa!’ ” ");
INSERT INTO ruf_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Tsawabama kumghogha kwaapfila tsawamanya ka imbuli yailongile kawalonga wawo, ila wawapfuka iwanu. Apfo wamleka yaliyeka, woka. ");
INSERT INTO ruf_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Hambele, wawatuma Mafarisayo wangi ne iwanu wa kingili lya Herodi kuna Yesu ili wamteghe ghayolonga. ");
INSERT INTO ruf_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Wamghendela, walonga, “Imlangulitsi, twokumanya ghweghwe kwa imunu yulongesa ghendo, na ng'aupfuka bae ukulu we imunu, wala ng'aulola ipfihanga pfe iwanu. Lekeni kwoilangulitsa ghendo inzila ye Imulungu. Utulongele, apfi pfinogha au ng'apfinoghile bae kuliha kodi kwa Kaisari? Tumlihe au tuleke kumliha?” ");
INSERT INTO ruf_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Lekeni Yesu kamanya ung'enye wawo. Kawaghutsa, “Ule mwobama kunitegha? Ngalileni sendi ayo niyone.” ");
INSERT INTO ruf_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Wamghalila sendi ayo. Naye kawaghutsa, “Angu ichihanga chino na taghwa lino lya nani?” Wamwidika, “Pfa Kaisari.” ");
INSERT INTO ruf_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Kuya Yesu kawalongela, “Mmwing'e Kaisari pfa Kaisari na mmwing'e Imulungu pfe Imulungu.” ");
INSERT INTO ruf_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Kuya Masadukayo, iwanu iwolonga kuduhu ukutsilihuka kulawa mne lifwa wamghendela Yesu wamghutsa, ");
INSERT INTO ruf_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Mlangulitsi, Musa tsakatwandikila pfino, ka imunu indughu yake kafa, naye kamleka mwehe iyalihela iwana, ndughu we imunu ayo kobamighwa amkwele chitsuka ayo ili amwelekele ndughu yake iwana. ");
INSERT INTO ruf_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tsakukala ne iwandughu saba. Imkulu wawo kakwela, naye kafa bila kuleka imwana wowose. ");
INSERT INTO ruf_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ndughu wa keli kamkwela chitsuka ayo, naye kafa bila kweleka imwana. Ilawila pfipfo kwa ndughu wa kadatu. ");
INSERT INTO ruf_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Iwandughu wose saba wafa na ng'awalekile imwana bae. Kuya mwehe yula naye kafa. ");
INSERT INTO ruf_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Lelo iwanu hawatsotsilihuka kulawa mne lifwa, angu mwehe ayo yakuwa wa nani kwaapfila wose saba tsawamkwela?” ");
INSERT INTO ruf_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu kawedika, “Mwemwe mwakwagha kwaapfila ng'ammanya bae Ghamaandiko Mahenzeluka wala ngupfu ye Imulungu. ");
INSERT INTO ruf_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Iwanu iwafile hawatsotsilihuka, ng'awatsokwela wala kukwelighwa bae, watsakuwa ka wamalaika wa kulanga. ");
INSERT INTO ruf_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kwe imbuli ya ukutsilihuka kwe iwanu iwafile, apfi ng'amsomile bae imbuli ya libagho ilikwaka mne ichitabu cha Musa, Imulungu pfayalongile na Abrahamu, ‘Nene na Imulungu wa Abrahamu, na Imulungu we Isaka na Imulungu wa Yakobu.’ ");
INSERT INTO ruf_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yeye si Imulungu we iwanu iwafile bae, ila we iwanu waghima. Apfo mwagha ghendo!” ");
INSERT INTO ruf_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Imlangulitsi yumwe wa ghamalaghitso katsa kawahulika wodawala. Hayonile Yesu kawedika ghoya kamghutsa, “Mne ghamalaghitso ghose, lihi laghitso kulu kubita ghose?” ");
INSERT INTO ruf_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu kedika, “Laghitso kulu alino. ‘Mtegheletse mwemwe Waisiraeli! Imtwatsa Imulungu wetu ka Imtwatsa yumwe yaliyeka. ");
INSERT INTO ruf_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Mnoghele Imulungu wako kwa ghumoyo ghwako ghwose na kwa muhe wako wose na kwa tsimbutsi tsako tsose na kwa ngupfu tsako tsose.’ ");
INSERT INTO ruf_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Na laghitso lya keli, ‘Mnoghele imunu wa habehi yako, ka pfawinoghela imwenyegho.’ Kuduhu laghitso kulu kubita agha meli.” ");
INSERT INTO ruf_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Imlangulitsi ayo wa ghamalaghitso kamlongela Yesu, “Mlangulitsi, kwidika ghoya. Kulongesa ghendo, Imulungu ka yumwe na kuduhu imulungu yungi ila yeye. ");
INSERT INTO ruf_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Na kumnoghela Imulungu kwa ghumoyo ghwako ghwose na kwa tsimbutsi tsako tsose na kwa ngupfu tsako tsose, na kumnoghela imunu wa habehi yako ka pfawinoghela ghwe imwenyegho pfinogha ghendo kubita kumlapfila Imulungu inambiko.” ");
INSERT INTO ruf_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu hayonile kedika kwa ihekima, kamlongela, “Ng'uli kutali bae na Undewa we Imulungu.” Kulawa baho, kuduhu imunu iyaghetsile kumghutsa Yesu imbuli yoyose. ");
INSERT INTO ruf_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu hayang'ali yolangulitsa mne ing'anda ye Imulungu, kawaghutsa, “Ebali iwolangulitsa Ghamalaghitso wolonga Kiristu kaimwana wa Daudi? ");
INSERT INTO ruf_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ghumuhe Mwenzeluka tsakamlongotsa Daudi, naye kalonga, ‘Imtwatsa kamlongela Imtwatsa wangu, Ukale ghumoko ghwangu ghwa kujilo mbaka niweke iwehile wako hasi ha ghamaghulu ghako.’ ");
INSERT INTO ruf_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Daudi imwenyegho tsakamkema ‘Imtwatsa.’ Apfi Kiristu yodahatse kuwa imwanaghe?” Iwanu wengi wamhulikitsa kwa kudeng'elela. ");
INSERT INTO ruf_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesu hayang'ali yolangulitsa kalonga, “Mwalangitse na iwolangulitsa Ghamalaghitso. Wonoghela kupfala ghamaghwanda matali na kulamsighwa mmasoko. ");
INSERT INTO ruf_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Na wosaghula ipfighoda ipfili hambele mne tsing'anda tsa ukulombela na kukala hanu hanoghile mne ipfihungo. ");
INSERT INTO ruf_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Wakuja mne tsing'anda tse pfitsuka, kwa kwilangusa wanogha, wolomba bila kwipfa. Awo watsohighighwa ng'ani.” ");
INSERT INTO ruf_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu tsakakala habehi na chinu cha kwikila sadaka, kalola iwanu pfawoghela tsisendi. Matajiri wengi walapfa sendi nyingi. ");
INSERT INTO ruf_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Kuya katsa chitsuka yumwe mhingwa kaghela sendi mbili. ");
INSERT INTO ruf_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesu kawakema iwanang'ina wake kalonga, “Nowalongela ghendo, chitsuka yuno keka nyingi kubita wose. ");
INSERT INTO ruf_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Wose walapfa tsimali tsawo itsiswelele, lekeni chitsuka yuno kalapfa pfose pfalinapfo.” ");
INSERT INTO ruf_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu hayang'ali yolawa kunze kwe ing'anda ye Imulungu, yumwe wa imwanang'ina wake kamlongela, “Mlangulitsi, ulole ghamabwe na tsing'anda pfatsinoghile!” ");
INSERT INTO ruf_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu kamwidika, “Apfi kwotsona tsing'anda tsino ng'ulu? Ng'alitsolekighwa libwe mchanya mwe libwe lingi, chila limwe litsakwasighwa hasi.” ");
INSERT INTO ruf_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu tsakakala mchidando mwa Chidunda cha Mitseituni, kumwambu kwe ing'anda ye Imulungu. Petiri, Jakobu, Yohane ne Andereya wamghutsa hawakalile waliyeka. ");
INSERT INTO ruf_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Utulongele, agha ghose ghatsolawila tsuwachi? Na kutsakuwa na chitango chachi agha ghose haghatsolawila?” ");
INSERT INTO ruf_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu kawalongela, “Mwalangitse, imunu aleke kuwaghutsukila. ");
INSERT INTO ruf_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Iwanu wengi watsakutsa kwa taghwa lyangu, watsolonga, ‘Nene nayeye!’ na watsowaghutsukila iwanu wengi. ");
INSERT INTO ruf_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Namwe hamtsohulika ng'ondo na mbuli tsa ng'ondo, mleke kupfuka. Ipfinu apfo pfobamighwa pfilawile, ila utsighilo ung'ali kutsa. ");
INSERT INTO ruf_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Iwanu we isi watsetowa ne iwanu wa isi ingi, undewa utsetowa ne undewa ungi, ne isi itsoking'isika chila hanu, na kutsolawila nzala ng'ulu. Agha ghose ghatsakuwa ka mwanduso wa usungu we kweleka. ");
INSERT INTO ruf_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Namwe mwalangitse! Mtsoghoghighwa na kughalighwa mne libaratsa. Mtsotowighwa mne tsing'anda tsa ukulombela. Mtsakwima hambele he iwabala na iwandewa kwaajili yangu kuwalongela mbuli tsinoghile. ");
INSERT INTO ruf_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Na Imbuli Inoghile ye Imulungu yobamighwa kupetighwa mne tsiisi tsose. ");
INSERT INTO ruf_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Hawatsowaghogha na kuwaghala kune libaratsa, mleke ukwalangula cha ukulonga. Mlonge chochose chila chamtsakwing'ighwa, kwaapfila si mwemwe bae yamlonga, ila Ghumuhe Mwenzeluka. ");
INSERT INTO ruf_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ndughu katsomlapfa ndughu yake yakomighwe, na aba katsomlapfa imwanaghe yakomighwe. Iwana watsowalema na kuwakoma aba na mai tsawo. ");
INSERT INTO ruf_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Iwanu wose watsowahila kwa taghwa lyangu, ila ayula yoghendelela mbaka usighilo katsokombolighwa. ");
INSERT INTO ruf_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Hamtsakwona lideso lima hanu hang'alibamighwa kwima bae. (Imunu iyosoma amanye) Awala iwali mne isi ya Yudeya watsumile mpfidunda. ");
INSERT INTO ruf_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Imunu wowose iyali mkano aleke kuhulumka hasi, au kwingila mng'anda kulapfa ichinu chochose kunze. ");
INSERT INTO ruf_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Na yula iyali kumghunda aleke kuya ukaye kusola ghamaghwanda ghake. ");
INSERT INTO ruf_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Watsoghaya ng'ani iwapinga wane tsiinda ne iwapinga iwakong'etsa mne ghamatsuwa agho! ");
INSERT INTO ruf_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mlombe agho ghaleke kulawila msimu wa chipfeghetsi! ");
INSERT INTO ruf_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kwaapfila ghamatsuwa agho kutsakuwa na maghayo ighang'ali ghalawile kulawa mwanduso, Imulungu hayalumbile isi yose, mbaka sambi, na ng'aghatsolawila keli! ");
INSERT INTO ruf_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Na ka Imtwatsa ng'ahungutse bae ghamatsuwa agho, kuduhu imunu ang'adahile kukombolighwa. Lekeni kwaajili ye iwanu wake iyawasaghule, kahungutsa ghamatsuwa agho. ");
INSERT INTO ruf_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Mne ghamatsuwa agho, imunu wowose ang'awalongela, ‘Lola, Kiristu kahano!’ au ‘Kakula!’ Mleke kumtoghola. ");
INSERT INTO ruf_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kwaapfila watsolawila tsina Kiristu wa ughutsu na manabii wa ughutsu. Watsotenda ipfinzonza ne ipfitango na kuwaghutsukila hata wala iwasaghulighwe ne Imulungu, ka yodahika. ");
INSERT INTO ruf_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mwalangitse! Niwalongela chila ichinu ichitsolawila. ");
INSERT INTO ruf_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Lekeni mna ghamatsuwa agho ahala maghayo aghatsomala, litsua litsakuwa ne ichisi, lwetsi ng'alutsolapfa ghumwanga bae, ");
INSERT INTO ruf_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","tsinondo tsitsolaghala kulawa mlanga, na ngupfu tsa kulanga tsitsohighitsighwa. ");
INSERT INTO ruf_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Baho iwanu watsomwona Imwana we Imunu kakutsa mne ghamawingu kwe ingupfu ng'ulu na utunitso. ");
INSERT INTO ruf_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Naye katsowatuma wamalaika wake kuwasola awala iyawasaghule mne isi yose, kulawa ubali umwe mbaka ubali ungi! ");
INSERT INTO ruf_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Mwilangulitse imbuli ino kulawa mne mbiki ghwa mtini. Ghamaputila ghake haghakuwa madeke na kwandusa kutula, mwomanya chihangatsi cha habehi. ");
INSERT INTO ruf_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Pfipfila hamtsakona agha ghose gholawila, mmanye Imwana we Imunu kahabehi ghendo. ");
INSERT INTO ruf_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nowalongela ghendo, iwanu wa mweleko ghuno ng'awatsoluta bae mbaka agha ghose ghalawile. ");
INSERT INTO ruf_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kulanga ne isi pfitsoluta, ila mbuli tsangu ng'atsitsoluta bae. ");
INSERT INTO ruf_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Kuduhu iyomanya litsuwa lila wala saa ila. Hata wamalaika wa kulanga wala Imwana ng'awomanya, ila Imulungu yaliyeka iyomanya. ");
INSERT INTO ruf_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mwalangitse, mkale meso kwaapfila ng'ammanya bae itskughwa tsuwachi. ");
INSERT INTO ruf_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Yeghala ne imunu yokile na kuwaleka iwatumwa wake, chila yumwe ne isang'ano yake. Kuya kamlaghitsa imkalitsi wa libani akale meso. ");
INSERT INTO ruf_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Apfo mkale meso, kwaapfila ng'ammanya bae yane ing'anda yatsakuya tsuwachi, kakuya nemihe, nechilo, ijogholo hayatsakwika, au nemitondotondo. ");
INSERT INTO ruf_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ka kakuya kwa kwidukitsa, aleke kuwapfika muwasa. ");
INSERT INTO ruf_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Achino chaniwalongela, niwalongela iwanu wose. ‘Mwalangitse!’ ” ");
INSERT INTO ruf_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Tsaghakalile matsuwa meli ng'ana ichihungo che Ipasaka na pfighate ipfilihela hamila chipfike. Iwakulu we inambiko na iwolangulitsa Ghamalaghitso wabama inzila ya kumghogha Yesu chinyelenyele na kumkoma. ");
INSERT INTO ruf_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Walonga, “Tuleke kumghogha mne ichihungo che Ipasaka, hela iwanu watsotenda tsogho.” ");
INSERT INTO ruf_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu tsakakala Betaniya mng'anda mwa Simoni, imunu iyang'ali yoghula ukoma. Hawakalile mmetsa wakuja ichijo cha nemihe, ipinga yumwe iyaghalile ichupa ya ghamafuta ighonung'ila gha bei ng'ulu katsa. Kaipfughula na kamwitila Yesu mwitwi. ");
INSERT INTO ruf_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Iwanu iwakalile aho tsawona maya, welongela, “Ule kakwaghitsa ghamafuta gha bei ng'ulu? ");
INSERT INTO ruf_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ghamafuta ghano ghang'autsighwe kwa bei ng'ulu na sendi weng'ighwe iwahingwa!” Kuya wamkembela ipinga ayo. ");
INSERT INTO ruf_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Yesu kalonga, “Mlekeni! Ule mumdesa? Yeye kanitendela ichinu chinoghile. ");
INSERT INTO ruf_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Iwahingwa mwinawo ghamatsuwa ghose, na mwodaha kuwapfila pfopfose pfambama. Lekeni ng'amtsakuwa na nene bae ghamatsuwa ghose. ");
INSERT INTO ruf_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ipinga ayu katenda achila chayadahile. Kalongola kulubaka lukuli lwangu, lukale ghoya kwa kutsikighwa. ");
INSERT INTO ruf_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nowalongela ghendo, hanu hohose imbuli inoghile haitsopetighwa mne isi, chayatendile ipinga ayu chitsolongighwa kwa kumkumbuka yeye.” ");
INSERT INTO ruf_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yuda Isikarioti, yumwe wa wala iwanang'ina kumi na weli, kaghenda kwe ipfilongotsi we inambiko ili amhunduke Yesu kuna wawo. ");
INSERT INTO ruf_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Nawo hawahulike wadeng'elela kwa achila chayalongile, wamlongela watsomwing'a sendi. Apfo kabama nzila ya ukumhunduka Yesu. ");
INSERT INTO ruf_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Mne litsuwa lya mwanduso lye Ichihungo cha Pfighate ipfilihela hamila na litsuwa lya kumkoma imwana we ing'olo we Ipasaka, iwanang'ina wake wamghutsa, “Apfi ubama tughende kwani tukakwikile ichijo cha Ipasaka?” ");
INSERT INTO ruf_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yesu kawatuma iwanang'ina wake weli, kawalongela, “Mghende kune ghumji, mtsetingana ne imunu iyaghalile chiya cha ghamatsi. Mmuwinze ");
INSERT INTO ruf_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","mbaka kune ing'anda iyatsakwingila, kuya mumlongele imunu yane ing'anda, Imlangulitsi koghutsa, ‘Chilikwani chiheleto cha iwahenza, ili ndiye Ipasaka ne iwanang'ina wangu?’ ");
INSERT INTO ruf_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Kuya katsowalangusa chiheleto chikulu cha uchanya ichikighwe ghoya. Mtwikile amo.” ");
INSERT INTO ruf_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Iwanang'ina tsawoka, waghenda kune ghumji, kuya tsawona ka Yesu pfawalongele. Apfo wachitenga ichijo che Ipasaka. ");
INSERT INTO ruf_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kuya haipfikile nemihe, Yesu kapfika ne iwanang'ina wake kumi na weli. ");
INSERT INTO ruf_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Bahala hawang'ali wakuja mmetsa, Yesu kalonga, “Nowalongela ghendo, imunu yumwe kulawa kuna mwemwe iyakuja na nene, katsonihunduka.” ");
INSERT INTO ruf_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Iwanang'ina waghanzika, chila yumwe kamghutsa, “Angu nene?” ");
INSERT INTO ruf_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu kawedika, “Yumwe kulawa mna mwemwe kumi na weli, iyopfabika chighate chake mne bakuli na nene. ");
INSERT INTO ruf_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Imwana we Imunu katsakufa ka pfayandikighwe. Lekeni katsoghaya imunu yula yomhunduka Imwana we Imunu. Ing'awile ng'apfu kwa imunu yula ka ng'elekighwe bae!” ");
INSERT INTO ruf_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Hawang'ali wakuja, Yesu kasola chighate, kachibaliki, kachimegha, kaweng'a iwanang'ina wake kawalongela, “Msole, aluno lukuli lwangu.” ");
INSERT INTO ruf_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Kuya kasola chikombe, kachibaliki, kaweng'a, wose wachinwela. ");
INSERT INTO ruf_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kawalongela, “Aino idamu yangu ya lilaghano iikwitika kwaajili ye iwanu wengi. ");
INSERT INTO ruf_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nowalongela ghendo, sitsakunwa keli bae dipfai ya mitsabibu mbaka litsuwa lila lyanitsakunwa ingi mne Undewa we Imulungu.” ");
INSERT INTO ruf_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Hawamalitse kwimba wila, waghenda kune Chidunda cha Mitseituni. ");
INSERT INTO ruf_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu kawalongela, “Mwemwe wose mtsotsuma na kundeka, ka pfayandikighwe, ‘Nitsomtowa mdimi, ne iwang'olo watsopwililika.’ ");
INSERT INTO ruf_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Lekeni hanitsotsilihuka kulawa mne lifwa, nitsowalongola Galilaya.” ");
INSERT INTO ruf_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petiri kamlongela, “Hata wose wang'akuleka, nene sikuleka bae!” ");
INSERT INTO ruf_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Lekeni Yesu kamwidika, “Nokulongela ghendo, leloli nechilo, ijogholo ng'ana yeke lwa keli, kutsonibela mala ndatu.” ");
INSERT INTO ruf_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Lekeni Petiri kaghendelela kulonga, “Hata ka nobamighwa nife naghwe, mbe, sikubela bae!” Ne iwanang'ina wangi wose walonga pfipfo. ");
INSERT INTO ruf_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tsawapfika hanu hokemighwa Getisemane, Yesu kawalongela iwanang'ina wake, “Hanighenda kulomba, mwemwe mkale hano.” ");
INSERT INTO ruf_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Kawasola Petiri, Jakobu na Yohane, naye kandusa kughanzika na kwona usungu ng'ani mne ghumoyo ghwake. ");
INSERT INTO ruf_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Kawalongela, “Usungu uli mne ghumoyo ghwangu mkulu ng'ani, wodaha kunikoma. Mkale hano na mkale meso.” ");
INSERT INTO ruf_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Kaghenda hambele chidogho, keghwisa hasi, kalomba, ka yodahika aleke kubitila mne ichipindi chila cha kudununzika. ");
INSERT INTO ruf_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Kalomba, “Aba wangu, ipfinu pfose pfodahika kuna ghweghwe. Uchilapfe chikombe cha kudununzika kuna nene, lekeni si ka pfanibama nene bae, ila pfaubama ghweghwe.” ");
INSERT INTO ruf_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Kuya koya keli kawapfika iwanang'ina wake wadatu wawasa. Naye kamlongela Petiri, “Simoni, kuwasa? Ng'udahile bae kukala meso hata kwa saa imwe?” ");
INSERT INTO ruf_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kuya kawalongela iwanang'ina wose, “Mkale meso, mlombe mleke kughetsighwa na ghehile. Ghumoyo ghwobama kutenda ghanoghile, lekeni lukuli lwahela ingupfu.” ");
INSERT INTO ruf_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Kaghenda keli kulomba akuno kolonga ghaghala. ");
INSERT INTO ruf_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Kuya koya keli kawapfika iwanang'ina wake wawasa, ng'awadahile bae kufumbula tsinenge tsawo. Nawo ng'awamanyile bae chakumlongela Yesu. ");
INSERT INTO ruf_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Hayoile lwakadatu, kawalongela, “Mng'ali mwowasa na kubwihila? Lamkeni lelo! Ichipindi chipfika, Imwana we Imunu sambi kakwing'ighwa mne ghamoko ghe iwanu wane nzambi. ");
INSERT INTO ruf_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mwinuke! Tughende! Mlole, ayuno hano imunu yonihunduka nene!” ");
INSERT INTO ruf_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu hayang'ali yolonga, Yuda, yumwe we iwanang'ina wake kumi na weli, tsakapfika. Katsa na kingili lye iwanu iwakindile imimaghe ne ipfilungu. Tsawatumighwa na ipfilongotsi we inambiko, iwolangulitsa Ghamalaghitso ne iwabala. ");
INSERT INTO ruf_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yuda kaling'a ichitango kingili alyo. “Imunu yanitsomnonela iyo yamumbama. Mumghoghe, mumghale na mumlolese aleke kutsuma.” ");
INSERT INTO ruf_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Bahala Yuda hayapfikile, kamghendela Yesu kalonga, “Mlangulitsi!” kuya kamnonela. ");
INSERT INTO ruf_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Apfo, wamkinda, wamghogha Yesu. ");
INSERT INTO ruf_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Lekeni imunu yumwe mne iwanu iwemile hala, kalapfa limaghe lyake kamtowa imtumwa we Ichilongotsi we Inambiko, kamghana ghutwi lyake. ");
INSERT INTO ruf_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesu kawalongela, “Pfii mtsa hano ne imimaghe ne ipfilungu kunighogha ka nene nambapfi? ");
INSERT INTO ruf_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Chila litsuwa tsanahamwe namwe, nolangulitsa mne Ing'anda ye Imulungu, ng'amnighoghile bae. Lekeni leka Ghamaandiko Mahenzeluka ghatimilike.” ");
INSERT INTO ruf_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kuya iwanang'ina wose wamleka, watsuma. ");
INSERT INTO ruf_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Na imsongolo yumwe iyeghubike ligholole yang'ali yomuwinza Yesu. Hawabamile kumghogha, ");
INSERT INTO ruf_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","kalileka ligholole lyake, katsuma chidako. ");
INSERT INTO ruf_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Kuya wamghala Yesu mne ing'anda ye Ichilongotsi we Inambiko, baho ipfilongotsi we inambiko, iwabala ne iwolangulitsa Ghamalaghitso wose wetingana hamwe. ");
INSERT INTO ruf_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petiri yang'ali yomuinzilitsa Yesu kwa kutali, kengila mne luwa lya Ichilongotsi we Inambiko, kakala ne iwakalitsi, na yang'ali yakota ghumoto. ");
INSERT INTO ruf_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Iwakulu we inambiko ne iwanu wose mne libaratsa wabama ukalangama wamwing'e maghomba Yesu ili wadahe kumkoma, lekeni ng'awadahile bae kuupata. ");
INSERT INTO ruf_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Iwanu wengi walonga ughutsu kuna Yesu, lekeni ukalangama wawo ng'awighalile bae. ");
INSERT INTO ruf_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Iwanu wamwenga wenuka, walonga ukalangama wa ughutsu, ");
INSERT INTO ruf_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Tsatumhulika kolonga, ‘Nitsoihinya Ing'anda ino ye Imulungu iitsengighwe kwa ghamoko na litsuwa lya kadatu nitsotsenga ingi ing'aitsengighwe kwa ghamoko ghe iwanu.’ ” ");
INSERT INTO ruf_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Hata apfo, ukalangama wawo ng'awighalile bae. ");
INSERT INTO ruf_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ichilongotsi we Inambiko kenuka hambele he iwanu kamghutsa Yesu, “Pfii kwahela chakwidika mne ukalangama uno iwaulapfile hano?” ");
INSERT INTO ruf_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Lekeni Yesu kenyamala, ng'alongile bae. Ichilongotsi we Inambiko kamghutsa keli, “Apfi ghweghwe kwa Kiristu, Imwana we Imulungu Yetunyighwe?” ");
INSERT INTO ruf_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu kalonga, “Ona nene. Wose mtsomwona Imwana we Imunu kakala mne ghumoko ghwa kujilo ghwe Imulungu yane Ingupfu, kakutsa mne ghamawingu gha kulanga.” ");
INSERT INTO ruf_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Baho Ichilongotsi we Inambiko kadegha lighwanda lyake, kaghutsa, “Lelo twobama wakalangama wangi wachi? ");
INSERT INTO ruf_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ambe mumhulika pfayamlighile Imulungu! Mwemwe mkwonatse?” Wose wamhigha yakomighwe. ");
INSERT INTO ruf_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Iwanu wangi wandusa kumbwalulila Yesu ghamate, wamghubika tsinenge tsake, wamtowa, wamlongela, “Utange, yuhi yakutowile!” Pfipfila iwakalitsi wamsola, wamtowa. ");
INSERT INTO ruf_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Petiri hayang'ali kamne luwa, ipinga yumwe imtumwa we Imtambika mkulu katsa. ");
INSERT INTO ruf_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Hayamwonile Petiri kakota ghumoto, kamtsodolela tsinenge, kalonga, “Pfipfila naghwe tsa kwahamwe na Yesu Mnatsareti.” ");
INSERT INTO ruf_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Lekeni Petiri kabela, “Simmanyile bae, wala sichimanyile bae chaulonga.” Kuya kalawa kunze mbaka hachikuta, ijogholo keka. ");
INSERT INTO ruf_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Imtumwa yula hayamwonile keli hala, kawalongela iwanu iwemile hala. Ayuno naye yumwe wawo. ");
INSERT INTO ruf_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Petiri kabela keli. Hambele chidogho, awala iwemile hala wamghendela. Wamlongela, “Ghweghwe kwa yumwe wawo ghendo, kwaapfila ghweghwe kwa Mgalilaya.” ");
INSERT INTO ruf_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Petiri kandusa kwilighita na kwilaha kuna wawo, “Simmanyile bae imunu yamlonga mbuli tsake.” ");
INSERT INTO ruf_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Bahala ijogholo keka lwakeli, kuya Petiri kakumbuka imbuli ila Yesu iyamlongele, “Ijogholo ng'ana yeke lwa keli, kutsonibela mala ndatu.” Kandusa kulila. ");
INSERT INTO ruf_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Nemitondotondo, ipfilongotsi we inambiko wetingana hamwe ne iwabala, iwolangulitsa Ghamalaghitso na libaratsa lyose, walamla kumghala Yesu kwa Pilato. Apfo wamwoha, wamghala na wamwing'a Pilato. ");
INSERT INTO ruf_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato kamghutsa Yesu, “Apfi ghweghwe kwaimndewa wa Wayahudi?” Yesu kamwidika, “Ona, ka ghweghwe pfaulonga.” ");
INSERT INTO ruf_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Iwakulu we inambiko wamghutsukila Yesu maghomba mengi. ");
INSERT INTO ruf_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Apfo, Pilato kamghutsa Yesu keli, “Ng'ukwidika chochose bae? Tegheletsa ghamaghomba ghawo ghose kuna ghweghwe.” ");
INSERT INTO ruf_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Lekeni Yesu kalema kwidika keli, Pilato kakangawala. ");
INSERT INTO ruf_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Chila Ichihungo che Ipasaka, Pilato tsakatsowela kumlekelela imunu yumwe yohighwe yobamighwa ne iwanu. ");
INSERT INTO ruf_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ichipindi acho kukala ne imunu yumwe yakemighwe Baraba, wamwika mne chifungo hamwe ne iwanu iwatendile hengele na iwakomile iwanu mna tsogho kulu. ");
INSERT INTO ruf_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Na kingili lye iwanu limghendela Pilato na limlomba awatendele ka pfayatendagha. ");
INSERT INTO ruf_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Naye Pilato kawaghutsa, “Apfi, mwobama nimlekelele Imndewa wa Wayahudi?” ");
INSERT INTO ruf_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilato kamanya ghendo ka pfilongotsi we inambiko wamghala Yesu kuna yeye kwaapfila wamwonela chepfu. ");
INSERT INTO ruf_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Lekeni ipfilongotsi we inambiko wawaswangitsa iwanu wamlombe Pilato amlekelele Baraba ihanu ha Yesu. ");
INSERT INTO ruf_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato kawaghutsa iwanu awo, “Kuya mwobama nimtende choni imunu yamumkema Imndewa wa Wayahudi?” ");
INSERT INTO ruf_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Iwanu wose wakemelela walonga, “Mkondeke mna msalaba!” ");
INSERT INTO ruf_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato kawaghutsa, “Apfi atendile choni chihile?” Walonga keli kwa kukemelela, “Mkondeke mna msalaba!” ");
INSERT INTO ruf_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato kabama kuwadeng'eletsa iwanu, apfo kamlekelela Baraba. Kuya kalaghitsa Yesu yafapulighwe ipfiboko, kuya wamkondeke mna msalaba. ");
INSERT INTO ruf_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Asikali wamghala Yesu mghati mwe ing'anda ye imkulu we isi ya Yudeya, wawakema hamwe wayawo wose. ");
INSERT INTO ruf_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Wampfatsa Yesu lighwanda lya langi ya tsambarau, wabota litaji lya mihonga, walika mwitwi mwake. ");
INSERT INTO ruf_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Kuya wandusa kumlamsa, “Mbukwa Imndewa wa Wayahudi!” ");
INSERT INTO ruf_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Waghendelela kumtowa ne ng'weku mwitwi mwake na kumbwalulila ghamate. Watowa ghamaghoti, wamwinamila. ");
INSERT INTO ruf_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kuya hawamalitse kumbetsa, wamtsula lighwanda lya langi ya tsambarau wampfatsa ghamaghwanda ghake. Kuya wamlapfa kunze wamkondeka mne msalaba. ");
INSERT INTO ruf_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Hawakalile mnzila, wetingana ne imunu iyakemighwe Simoni, imunu wa Kirene, aba wawo Alekisanda na Lufo. Imunu ayo tsayang'ali yolawa kumghunda koghenda mne ghumji. Asikali wambama aghughale msalaba ghwa Yesu. ");
INSERT INTO ruf_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Kuya wamghala Yesu hanu hokemighwa Goligota, mana yake, “Hanu ha Pala lya Litwi.” ");
INSERT INTO ruf_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Wamwing'a idipfai ihanganyighwe na manemane, lekeni Yesu kalema kuinwa. ");
INSERT INTO ruf_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Kuya wamkondeka mna msalaba, wegholela ghamaghwanda ghake kwa ukwasa hasi tsisimbi walole yuhi yapate lighwanda. ");
INSERT INTO ruf_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ikala saa ndatu nemitondo hawamkondeke Yesu mna msalaba. ");
INSERT INTO ruf_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Wandika lighomba lyake apfino. “IMNDEWA WA WAYAHUDI.” ");
INSERT INTO ruf_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Kuya wamkondeka Yesu hamwe na wabapfi weli mne misalaba, yumwe kune ghumoko ghwake ghwa kujilo na yungi kune ghumoko ghwake ghwa kumoso. ");
INSERT INTO ruf_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Apfo ghatimila Ghamaandiko igholonga, “Tsakekighwa hamwe iwanu wehile.” ");
INSERT INTO ruf_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Iwanu iwang'ali woluta hanu hala wahighitsa ghamatwi ghawo, wamligha Yesu, walonga, “Ambe ghweghwe kudaha kuimwagha Ing'anda ye Imulungu na kuitsenga kwa ghamatsuwa madatu! ");
INSERT INTO ruf_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Hulumka lelo mna msalaba, wihonetse mwenyegho!” ");
INSERT INTO ruf_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Pfipfila ipfilongotsi we inambiko na iwolangulitsa Ghamalaghitso wamligha Yesu, walonga, “Kawahonetsa iwanu wengi lekeni ng'odaha bae kwihonetsa imwenyegho! ");
INSERT INTO ruf_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Leka tumlole ayu Kiristu, Imndewa wa Isiraeli, sambi ahulumke mna msalaba, na twetwe tutsomtoghola!” Kuya, iwanu wala weli iwakondekighwe mne misalaba hamwe na Yesu pfipfila wamligha. ");
INSERT INTO ruf_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Haipfikile saa sita nemisi, isi yose ighubikighwa ne ichisi ichikalile kwa masaa madatu. ");
INSERT INTO ruf_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Saa tisa nemisi, Yesu kakemelela, “Eloi, Eloi, lama Sabakitani” mana yake, “Imulungu wangu, Imulungu wangu, mbona kundeka?” ");
INSERT INTO ruf_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Iwanu wangi iwemile hala hawahulike apfo walonga, “Tegheletsa, komkema Eliya!” ");
INSERT INTO ruf_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Imunu yumwe katsuma, keka isiki mne lidodoki, kalika mne lubiki, kamwing'a Yesu yainwe. Kuya kalonga, “Tubete tulole ka Eliya kakutsa kumhulumsa mna msalaba.” ");
INSERT INTO ruf_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesu kalila kwa kukemelela, kuya kafa. ");
INSERT INTO ruf_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Lipanziya likalile mne Ing'anda ye Imulungu lidegheka mabwende meli kulawa kuchanya mbaka hasi. ");
INSERT INTO ruf_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Imbala yumwe wa asikali iyemile hambele ha msalaba kona Yesu pfayafile, kalonga, “Imunu yuno tsakakala Imwana we Imulungu ghendo!” ");
INSERT INTO ruf_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Iwapinga wamwenga tsawalola kwa kutali. Wamwenga wawo tsa Mariya Magidalena, Mariya iyali mai wawo tsina Jakobu mdodo na Yose, na Salome. ");
INSERT INTO ruf_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Yesu hayang'ali Galilaya, iwapinga awo tsawamuwinza wamtumikila. Iwapinga wamwenga iwalawile naye Yerusalemu pfipfila tsawabahala. ");
INSERT INTO ruf_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ipfika nemihe ya litsuwa lya kwiyandaa, (tsa tsuwa limwe likalile kupfika tsuwa lya sabato). ");
INSERT INTO ruf_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Yosefu iyolawila mne ghumji ghwa Arimataya, imunu wa libaratsa iyahulikitsighwe ng'ani kapfika. Imunu ayo yang'ali yokalitsa ukutsa kwa undewa we Imulungu. Yosefu kamghendela Pilato bila kumpfuka, kamlomba amwing'e lukuli lwa Yesu. ");
INSERT INTO ruf_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato tsakakangawala hayahulike ma Yesu kafa. Kamkema imbala wa asikali kamghutsa ka Yesu kafa mwande. ");
INSERT INTO ruf_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Baho hayahulike apfo kulawa kwe imbalayo, Pilato kamlongela Yosefu alusole lukuli lwa Yesu. ");
INSERT INTO ruf_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yosefu kaghula isanda, kahulumsa lukuli lwa Yesu, kalupfatsa isanda na kulwika mne likabuli ilihimbighwe mne libambalawe. Kuya, kabimbilisa libwe kulu hambele ha libani. ");
INSERT INTO ruf_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mariya Magidalena na Mariya mai wake Yose wona hanu halwikighwe lukuli lwa Yesu. ");
INSERT INTO ruf_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Litsuwa lya Sabato halimalile, Mariya Magidalena, Mariya mai wake Jakobu na Salome waghula ghamafuta, waghenda kulubaka lukuli lwa Yesu. ");
INSERT INTO ruf_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Nemitondo Jumapili litsua halilawile, waghenda kune likabuli. ");
INSERT INTO ruf_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Hawang'ali wamnzila weghutsa, “Yuhi yatsolibimbilisa libwe lili mne libani lye likabuli?” ");
INSERT INTO ruf_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Lekeni hawalolile, walyona libwe lila likulu libimbilisighwa. ");
INSERT INTO ruf_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Apfo wengila mne likabuli, wamwona imunu yapfalile lighwanda tselu, nawo wakangawala. ");
INSERT INTO ruf_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Imunu yula kawalongela, “Mleke kukangawala, mwombama Yesu Mnatsareti yawambighwe. Ng'alibaha bae, katsilihuka! Mlole hanu hawamwikile. ");
INSERT INTO ruf_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Lelo mghende mkawalongele iwanang'ina wake na Petiri, ‘Yesu kowalongola Galilaya, baho mtsomwona ka pfawalongele.’ ” ");
INSERT INTO ruf_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Apfo walawa kunze mwe likabuli, watsuma aku wodedema na kukangawala. Ng'awamlongele imunu wowose bae imbuli ayo kwaapfila tsawapfuka. ");
INSERT INTO ruf_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesu hayatsilihuke kulawa mne lifwa lupfilipfili mne litsuwa lya Jumapili, kamlawila Mariya Magidalena iyamlapfile ipfinyamkela saba. ");
INSERT INTO ruf_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Naye kaghenda kuwalongela wayaghe awala iwakalile na Yesu, iwang'ali wakona usungu na kulila. ");
INSERT INTO ruf_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Hawahulike Yesu katsilihuka na ipinga ayo kamwona, ng'awatoghole bae. ");
INSERT INTO ruf_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Hambele Yesu kawalawila iwanang'ina wake weli aku kana chihanga chingi, hawang'ali woghenda kumghunda. ");
INSERT INTO ruf_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nawo woya wawalongela wayawo. Lekeni nawo ng'awatoghole bae. ");
INSERT INTO ruf_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Hambele chidogho Yesu kawalawila iwanang'ina kumi na yumwe hawang'ali wakuja. Kawakembela kwaapfila ng'awang'ali wotoghola bae na wasughu kuwatoghola awala iwamwonile kamghima. ");
INSERT INTO ruf_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Apfo kawalongela, “Mghende mne isi yose muwapetele Imbuli Inoghile wapfilumbe wose. ");
INSERT INTO ruf_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Imunu wowose iyotoghola na kubatitsighwa, katsokombolighwa, ila imunu wowose iyolema kutoghola katsohighighwa. ");
INSERT INTO ruf_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Na ipfitango pfino pfoghenda hamwe na awala iwotoghola, Kwa taghwa lyangu watsolapfa ipfinyamkela, na watsolonga kwa lugha ya sambi. ");
INSERT INTO ruf_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Hata wang'akinda iwanzoka na kunwa sumu ng'awatsolaghighwa bae. Watsowekila ghamoko ghawo iwatamu, nawo watsohona.” ");
INSERT INTO ruf_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Yesu hayamalitse kulonga ne iwanang'ina wake, kasolighwa kulanga, kakala ghumoko ghwa kujilo ghwe Imulungu. ");
INSERT INTO ruf_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Kuya iwanang'ina wala waghenda chila hanu kupeta Imbuli Inoghile. Ne Imtwatsa kasang'ana nawo, kalangusa ka kahamwe nawo kwe ipfitango ipfighalile ne Imbuli ayo.");
INSERT INTO ruf_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Imkulu Teofili, Iwanu wengi tsawandusa ukwandika pfawadahile tsimbuli tse ipfinu ipfitendeke mghati mwetu. ");
INSERT INTO ruf_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Tsawandika ipfinu pfatulongelighwe ne iwanu iwonile ipfinu pfino kulawa mwanduso, ne iwanu wawala iwalongile tsimbuli tsinoghile. ");
INSERT INTO ruf_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Aghweye Imkulu, kwaapfila imwenyegho nipfibama ipfinu pfino pfose kulawa mwanduso, tsambona pfinogha ukukwandikila ghoya ipfinu pfilawile. ");
INSERT INTO ruf_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Notenda pfino naghwe umanye ukweli wose we ipfinu pfaulangusilighwe. ");
INSERT INTO ruf_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Mna matsuwa ghala Herodi hayakalile imndewa wa Yudeya, tsakukala na mlapfa nambiko yumwe yakemighwe Sakariya, kolawila mna walapfa nambiko wa Abiya. Mwehe wake kakemighwa Elisabeti naye kolawa mne lukolo lwe Aruni, mlapfa nambiko. ");
INSERT INTO ruf_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Wose weli wakala wanogha kwe Imulungu, aku wakinda ghendo ghamalaghitso ghose ghe Imtwa. ");
INSERT INTO ruf_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Wose tsawahela iwana kwaapfila Elisabeti yang'ali ng'akweleka bae, na wose tsawalala ghendo. ");
INSERT INTO ruf_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Litsuwa limwe Zakariya kakala mne Ing'anda ye Imulungu kotenda isang'ano yake ya kutambika, tsaikala nzamu yake. ");
INSERT INTO ruf_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Zakariya tsakasaghulighwa kwa kwasa simbi, ka watambika pfawang'ali wotendagha. Apfo kengila mng'anda mwe Imtwatsa akadusule ubani. ");
INSERT INTO ruf_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ne ichipindi che kupfukitsa ubani pfachitsile, iwanu wose wakala wolomba kunze. ");
INSERT INTO ruf_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Kuya malaika we Imtwatsa, kamlawila, kema ubali wa kujilo wa hanu hala kupfukitsila ubani. ");
INSERT INTO ruf_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sakariya hamwonile, keduka kuya kapfuka. ");
INSERT INTO ruf_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Imalaika kamlongela, “Uleke kupfuka, Sakariya! Imulungu kahulika chaumlombile. Mwehe wako katsokwelekela imwana immale naghwe kutsomkema Yohane. ");
INSERT INTO ruf_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kutsosekelela ng'ani na kudeng'elela, ne iwanu wengi watsodeng'elela kwa ukwelekighwa kwake! ");
INSERT INTO ruf_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Katsakuwa imunu imkulu hambele he Imtwatsa. Ng'atsakunwa bae idipfai wala mbwali. Ghumuhe ghwe Imulungu katsommemetsa kulawa litsuwa lya ukwelekighwa kwake. ");
INSERT INTO ruf_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Katsowoyitsa iwanu wengi we Isiraeli woye kwe Imtwatsa Imulungu wawo. ");
INSERT INTO ruf_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Katsolongola hambele he Imtwatsa, katsakuwa ne ingupfu na ghumuhe ka nabii Eliya. Tsina aba watsowanoghela keli iwana wao, katsowoyitsa iwanu ing'awohulika woye mne ukwalangula kunoghile ka iwanu iwomuhulika Imulungu, katsowatenda iwanu weyandae kumbokela Imtwatsa.” ");
INSERT INTO ruf_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakariya kamghutsa imalaika, “Nitsomanyatse ka ichinu chino chakuwa apfo? Nene nilala na mwehe wangu pfipfila kalala” ");
INSERT INTO ruf_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Imalaika kamwidika, “Nene na Gaburieli. Nakwima hanu he Imulungu, iyanitumile nonge naghwe, na nikulongele imbuli ino inoghile. ");
INSERT INTO ruf_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Kwitsenyamala tulu kwaapfila ng'ughatoghola bae aghano ighatsolawila mna msimu wake, ng'utsodaha bae ukulonga mbaka aghano ghanikulongele haghotsolawila.” ");
INSERT INTO ruf_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Iwanu iwang'ali wombeta Sakariya wetsina hayang'ali yokawa mne Ing'anda ye Imulungu. ");
INSERT INTO ruf_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Baho halawile kunze, ng'adahile bae ukulonga nawo, apfo wamanya kona ghamaono mne Ing'anda ye Imulungu. Kalonga nawo kwa ghamoko ghake, kwaapfila ng'adahile bae ukulonga. ");
INSERT INTO ruf_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Matsuwa ghake gha kusang'ana aghamalile, Sakariya koya ukaye. ");
INSERT INTO ruf_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Aghabitile matsuwa mengi mwehe wake kakinda inda. Tsakepfisa mng'anda kwa miyetsi mitano. ");
INSERT INTO ruf_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Tsakalonga, “Apfi pfipfo pfanendele Imulungu mna matsuwa ghala hambonele libatsi kunenda ndeke kona keli ichinyala mne iwanu!” ");
INSERT INTO ruf_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Mna ghumwetsi ghwa sita ghwe inda ya Elizabeti Imulungu kamtuma malaika yokemighwa Gaburieli aghende mne ghumji ghwa Natsareti mne isi ya Galilaya, ");
INSERT INTO ruf_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","kwe imwali iyalapfighwe tsengele ne immale yakemighwe Yosefu, yalawile mne lukolo lwa Mndewa Daudi. Imwaliyo tsakakemighwa Mariya. ");
INSERT INTO ruf_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Malaika tsakamtsila imwaliyo kamlongela, “Haulamke! Imtwatsa kahamwe naghwe, naye kakubaliki!” ");
INSERT INTO ruf_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mariya hayahulike mbuli ayo, tsakalangula mne ghumoyo ghwake, naye kakangawala imbuli ino ina mana yachi. ");
INSERT INTO ruf_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Malaika kamlongela, “Mariya, uleke kupfuka! Imulungu kakutendela uluso. ");
INSERT INTO ruf_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Kutsokinda inda na kutsakweleka imwana immale, kutsomwing'a taghwa Yesu. ");
INSERT INTO ruf_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Katsakuwa mkulu na katsokemighwa Imwana we Imulungu yali Kuchanya Ng'ani. Imtwatsa Imulungu katsomwing'a chighoda cha undewa che imbala wake Daudi. ");
INSERT INTO ruf_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Katsokuwa imndewa we iwana wa Yakobu ghamatsuwa ghose, ne undewa wake ng'autsomala bae!” ");
INSERT INTO ruf_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mariya kalonga ne malaika, “Nene na-mwali sina niwase bae ne immale. Kuya lelo itsakuwatse?” ");
INSERT INTO ruf_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Malaika kamwidika, “Ghumuhe Mwenzeka katsokutsila, na ngupfu tse Imulungu tsitsokughubika. Apfo imwana mwenzeluka katsakwelekighwa, katsokemighwa Imwana we Imulungu. ");
INSERT INTO ruf_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Kwomkumbuka ndughu yako Elizabeti. Tsailongighwa ng'atsokweleka bae iwana, lekeni sambi kana inda ya miyetsi sita, pfipfo pfayali mnzehe. ");
INSERT INTO ruf_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kwaapfila kuduhu ichinu Imulungu ng'ochidaha bae kuchitenda.” ");
INSERT INTO ruf_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mariya kalonga; “Nene na imtumwa we Imtwatsa, nendelighwe ka pfaulongile.” Kuya malaika ayo koka. ");
INSERT INTO ruf_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Matsuwa ghaghala Mariya katsumka kaghenda mne ghumji ighuli mne pfidunda pfa isi ya Yudeya. ");
INSERT INTO ruf_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ako kengila mne ing'anda ya Sakariya, kamlamsa Elisabeti. ");
INSERT INTO ruf_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabeti hayahulike Mariya komlamsa, imwana kadaluka munda mwake. Elisabeti kamemetsighwa na Ghumuhe ghwe Imulungu, ");
INSERT INTO ruf_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","kalonga kwa kukemelela, “Kubweda kubita iwapinga wose, ne imwana yutsomweleka kabalikiighwa! ");
INSERT INTO ruf_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ebali chinu chino chindawila nene, mbaka mai we Imtwatsa wangu yanyangile nene? ");
INSERT INTO ruf_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Hanihulike kwondamsa, imwana kadaluka munda mwangu kwa ndeng'elelo. ");
INSERT INTO ruf_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ng'apfu ghweghwe yutoghole ka ghatsolawila aghala ghayakulongele Imtwatsa” ");
INSERT INTO ruf_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mariya kalonga, “Ghumoyo ghwangu ghomtoghola Imtwatsa; ");
INSERT INTO ruf_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ghumoyo ghwangu ghwomdeng'elela Imulungu iyali Mkombotsi wangu, ");
INSERT INTO ruf_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","kwaapfila kaukumbuka udodo we imtumwa wake! Kulawa sambi na kughendelela iwanu wose watsong'ema na imunu iyebwedile ");
INSERT INTO ruf_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","kwaapfila Imulungu yane Ngupfu kanendela makulu. Taghwa lye Imulungu lyenzeluka. ");
INSERT INTO ruf_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Kowonela libatsi iwanu wala iwompfuka. libatsi lyake lyokala lweleko mbaka lweleko lungi ");
INSERT INTO ruf_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Tsakatenda ipfinu pfikulu kwa ghumoko ghwake. Kawapwililisa iwanu iweghodile mne imimoyo yawo. ");
INSERT INTO ruf_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kawahulumsa iwandewa kulawa kune ipfighoda pfawo pfa undewa, na kawenula iwali mbughilambughila. ");
INSERT INTO ruf_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Kawaghutisa wane inzala kwa pfinu pfinoghile, na kawawinga matajiri ghamoko ghaliyeka. ");
INSERT INTO ruf_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Kamwapfila imtumwa wake Isiraeli, na ng'esemwile bae kumlangusa libatsi lyake. ");
INSERT INTO ruf_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Kakumbuka kumwonela libatsi Abrahamu na lukolo lwake ghamatsuwa ghose!” ");
INSERT INTO ruf_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariya kakala na Elizabeti kwa miyetsi midatu, kuya koya ukaye yake. ");
INSERT INTO ruf_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Matsuwa gha Elisabeti tsaghapfika ukweleka imwana, naye keleka imwana immale. ");
INSERT INTO ruf_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Iwanu wali habehi yake ne iwandughu tsake hawahulike Imulungu pfamwonele libatsi sideke, wose wadeng'elela naye. ");
INSERT INTO ruf_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Imwana hapfikile matsuwa manane, watsa kumwingitsa ngoma. Wabama kumwing'a taghwa Sakariya, taghwa lya aba wake. ");
INSERT INTO ruf_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Kuya mai wake kalonga, “Bae! Taghwa lyake katsokemighwa Yohane!” ");
INSERT INTO ruf_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Walonga, “Pfii mbona kwahela ndughu iyokemighwa taghwa lino mlukolo lwako!” ");
INSERT INTO ruf_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Kuya walonga kwa ghamoko na aba wake wamghutsa taghwa lyachi kobama imwanaghe yakemighwe. ");
INSERT INTO ruf_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sakariya kalomba chibao cho kwandikila, kuya kandika, “Taghwa lyake Yohane.” Wose wakangawala! ");
INSERT INTO ruf_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Bahala Zakariya kadaha ukulonga keli, kandusa ukumtunya Imulungu. ");
INSERT INTO ruf_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Iwanu wali habehi yake wapfuka, na mbuli tse ipfinu pfino tsenela kwose kune ipfidunda pfe isi ya Yudeya. ");
INSERT INTO ruf_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Chila imunu yahulike imbuli ino kalangula, keghutsa, “Pfii imwana yuno atsakuwa mwana wachi?” Kwaapfila ingupfu ye Imtwatsa yakwoneka ghendo ikala naye. ");
INSERT INTO ruf_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Sakariya aba wake Yohane kamemesighwa na Ghumuhe ghwe Imulungu, naye katabili imbuli kulawa kwe Imulungu. ");
INSERT INTO ruf_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Lekani tumtunye Imtwatsa, Imulungu wa Isiraeli! Kwaapfila kawatsila iwanu wake na kuwakombola. ");
INSERT INTO ruf_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Katwing'a twetwe Mkombotsi yane ngupfu, mtsukulu wa imtumwa wake Daudi. ");
INSERT INTO ruf_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ka pfalongile kulawa ghumwande kubitila manabii wake wahenzeluka. ");
INSERT INTO ruf_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","kutukombola kulawa kwe iwehile wetu, na kulawa kune ingupfu ya wose iwotwihila. ");
INSERT INTO ruf_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Tsakalonga katsowonela libatsi iwabala wetu na katsokumbuka lilaghano lyake lyenzeluke. ");
INSERT INTO ruf_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Kelighita ghendo kwa Abrahamu imbala wetu ");
INSERT INTO ruf_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","katsotukombola kulawa kwe iwanu iwotwihila. Na katwapfila tudahe kumsang'anila bila kupfuka, ");
INSERT INTO ruf_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","tuwe wenzeluka na tuwe iwanu wanoghile hambele hake, matsuwa ghose gha ughima wetu. ");
INSERT INTO ruf_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ghweghwe imwanangu, kutsokemighwa nabii we Imulungu yali Uchanya ng'ani. Kutsomlongolela Imtwatsa umgholosele inzila yake. ");
INSERT INTO ruf_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Kuwalongela iwanu wake watsokombolighwa kwa kuleghusighwa nzambi tsawo. ");
INSERT INTO ruf_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Imulungu wetu kana libatsi na ghumoyo ghunoghile. Katsowamwemwesela ghumwanga ghwa ukombotsi kulawa kulanga. ");
INSERT INTO ruf_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ghutsowamwemwesela iwanu wose iwali mne ichisi na sisila lya ifwa aghalongotse maghulu ghetu mne nzila iili tseghamba.” ");
INSERT INTO ruf_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Imwana kakula na kongetseka ingupfu mmuhe. Kakala kunyika mbaka litsuwa hawalawilile iwanu wa Isiraeli. ");
INSERT INTO ruf_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ghamatsuwa ghala Agusto, Imndewa wa Roma, tsakalaghitsa iwanu wose wa undewa wa Roma wapetighwe. ");
INSERT INTO ruf_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Aluno lwa mwanduso kwe iwanu kupetighwa, Kurenio hawile mkulu we isi ya Siriya. ");
INSERT INTO ruf_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kuya, chila imunu kaghenda kune ghumji ghwake kwandikighwa taghwa lyake. ");
INSERT INTO ruf_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yosefu kalawa ghumji ghwa Natsareti ighuli mna isi ya Galilaya, kaghenda ghumji ghwa Betilehemu ighuli mna isi ya Yudeya, hanu helekighwe mndewa Daudi. Yosefu kaghenda ako kwaapfila kalawila mne lukolo lwa Daudi. ");
INSERT INTO ruf_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Kaghenda na Mariya kupetighwa, ipinga yamlapfile tsengele, yakalile ne inda. ");
INSERT INTO ruf_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Hawang'ali wa Betilehemu, litsuwa lyake lya ukweleka lipfika, ");
INSERT INTO ruf_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","keleka imwanaghe chaudele, kampfatsa pfibwende. Kuya kamuwasitsa mne ichibumbulika hanu hawajilagha iwanyama, kwaapfila ng'awapatile bae hanu ho kukala mne ing'anda ya iwahenza. ");
INSERT INTO ruf_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mna isi iila tsakukala na wadimi iwang'ali wokalitsa imipfugho yawo nechilo. ");
INSERT INTO ruf_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Imalaika we Imtwatsa kawalawila, ne utunitso we Imtwatsa uwamwemwesela, nawo wapfuka ghendo. ");
INSERT INTO ruf_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Lekeni malaika ayo kawalongela, “Mleke ukupfuka! Niwaghalila imbuli inoghile, iitsowadeng'eletsa iwanu wose. ");
INSERT INTO ruf_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Leloli kune ghumji ghwa Daudi kelekighwa Mkombotsi wenu; yeye iyo Kiristu, Imtwatsa! ");
INSERT INTO ruf_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Achino chitsakuwa chitango kuna mwemwe. Mtsomwona imwana mdodo, wampfatsa ipfibwende, wamuwatsisa hanu ho kujila iwanyama.” ");
INSERT INTO ruf_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Bahala, kingili kulu lye iwamalaika litingana ne malaika ayo, wamtunya Imulungu, walonga, ");
INSERT INTO ruf_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Utunitso kwe Imulungu yali uchanya ng'ani kulanga, na tseghamba kwe iwanu iwali mne isi yose iwanoghelighwe naye” ");
INSERT INTO ruf_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Iwamalaika awo hawoyile kulanga, wadimi welongela, “Tukeni Betilehemu tukalole acho ichilawile, chatulongele Imtwatsa.” ");
INSERT INTO ruf_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Apfo watsuma, wawapfika Mariya na Yosefu, na ayula imwana mdodo kawasitsighwa hanu ho ukujila iwanyama. ");
INSERT INTO ruf_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Wadimi awo hawamwonile imwana yula, wawalongela mbuli tse imwana tsawalongile malaika. ");
INSERT INTO ruf_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Wose iwahulike agho, wakangawala na mbuli tsawalongile wadimi. ");
INSERT INTO ruf_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Lekeni Mariya kagheka agha ghose mna ghumoyo ghwake na kaghatonga ng'ani. ");
INSERT INTO ruf_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Awala iwadimi woya kunyika, wamtunya Imulungu na kumwimbila kwa ghose ghawahulike na ghawonile, ghose ghalawila ka malaika pfawalongele. ");
INSERT INTO ruf_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Mne litsuwa lya nane, litsuwa lya kumwingitsa ngoma imwana halipfikile, kakemighwa taghwa lyake Yesu. Taghwa alyo tsakeng'ighwa na malaika ahala mai wake ng'ana ame inda. ");
INSERT INTO ruf_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ghamatsuwa tsaghapfika gha Yosefu na Mariya kutenda ichihendo cha kudeghetetsighwa ka Ghamalaghitso gha Musa pfagholaghitsa. Apfo wamsola imwana, waghenda naye kune ghumji ghwa Yerusalemu kumwika hambele he Imtwatsa, ");
INSERT INTO ruf_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ka pfayandikighwe mne Ghamalaghitso ghe Imtwatsa Imulungu; “Chila imwana immale chaudele alapfighwe kwe Imtwatsa.” ");
INSERT INTO ruf_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kuya tsawaghenda ili watambike, walapfe njiwa weli au makinda meli ka Ghamalaghitso ghe Imtwatsa pfagholaghitsa. ");
INSERT INTO ruf_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ako Yerusalemu tsakukala na imunu yumwe taghwa lyake Simoni. Imunu ayo tsakakala kanogha na kompfuka Imulungu. Ayo yang'ali yobetetsa ukutsa kwa ukombotsi wa Isiraeli, naye tsakakala na Ghumuhe ghwe Imulungu. ");
INSERT INTO ruf_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ghumuhe ghwe Imulungu kamlongela ng'atsakufa bae mbaka amwone Kiristu yasaghulighwe ne Imtwatsa. ");
INSERT INTO ruf_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kuya Ghumuhe ghwe Imulungu kamlongotsa Simoni kaghenda kune Ing'anda ye Imulungu. Kuya aba na mai wake Yesu wamghala imwana wawo mne Ing'anda ye Imulungu wamtendele ka pfaibamighwe mne ichihendo cha Ghamalaghitso gha Musa. ");
INSERT INTO ruf_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simoni kamsola imwana Yesu mna ghamoko ghake, kuya kamtunya Imulungu, kalonga, ");
INSERT INTO ruf_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Sambi Imtwatsa, mlekelele imtumwa wako, yoke tseghamba, ka pfulongile. ");
INSERT INTO ruf_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kwa tsinenge tsangu niwona ukombotsi wako, ");
INSERT INTO ruf_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","uutendile woneke kuna iwanu wose, ");
INSERT INTO ruf_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ghumwanga ighutsowamwemwesela iwanu wose iwali si Wayahudi bae, na litsoghala utunitso kwe iwanu wako wa Isiraeli.” ");
INSERT INTO ruf_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Aba wake na mai wake Yesu wang'ali wokangawala na mbuli tse imwana tsayalongile Simoni. ");
INSERT INTO ruf_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simoni kawabaliki, kamlongela Mariya, mai wake Yesu, “Imwana yuno kasaghulighwa ne Imulungu kwa ukwagha na ukukombolighwa kwe iwanu wengi mne isi ya Isiraeli. Kuya katsakuwa chitango kulawa kwe Imulungu, ichitsolemighwa ne iwanu wengi. ");
INSERT INTO ruf_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Kuya ukwalangula mne imimoyo ye iwanu wengi kutsoghubulighwa mwatsi. Naghwe imwenyegho, usungu ka lipanga ilitema utsouhoma ghumoyo ghwako.” ");
INSERT INTO ruf_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Tsakukala na nabii yumwe pinga, kakala mnzehe ghendo, tagwa lyake Ana, neghe Fanuweli, wa lukolo lwa Aseri. Ipinga ayo tsakakala na immale wake kwa miyaka saba kulawa kukwelighwa kwake. ");
INSERT INTO ruf_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Kuya tsakakala chitsuka mbaka matsuwa ghala ghawile mnzehe wa miyaka semanini na mine. Na matsuwa agho ghose kakala mne ing'anda ye Imulungu, ang'ali yofunga ukuja na ukulomba chilo na misi. ");
INSERT INTO ruf_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Saa iila ipinga ayo kalawila, kamlongela Imulungu mighede, kawalongela imbuli ye imwana yula kwe iwanu wose yawang'ali woubetela ukombotsi wa Yerusalemu. ");
INSERT INTO ruf_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yosefu na Mariya hawaghamalitse ghose ighobamighwa na Ghamalaghitso ghe Imtwatsa Imulungu, tsawoya ukaye yawo Natsareti, mne ghumji ghwa Galilaya. ");
INSERT INTO ruf_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Imwana kakula, kongetseka ngupfu, kamema ihekima, na uluso we Imulungu ukala hamwe naye. ");
INSERT INTO ruf_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Chila mwaka mne chihungo cha pasaka, welesi wake wang'ali woghendagha Yerusalemu. ");
INSERT INTO ruf_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesu hapfikile miyaka kumi na mili, tsawaghenda naye kune ichihungo ka pfawatendagha. ");
INSERT INTO ruf_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Hawamalitse ichihungo, na hawang'ali wakuya ukaye yawo, Yesu tsakakala kuchugho Yerusalemu, aku welesi wake ng'awamanyile bae. ");
INSERT INTO ruf_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Tsawepfikitsa ka tsawawose mne ghumwanza, waghenda ghumwanza ghwa tsuwa limwe. Kuya wandusa kumbama mna iwandughu tsawo na sale tsawo. ");
INSERT INTO ruf_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ng'awamwonile bae, apfo woya Yerusalemu kumbama. ");
INSERT INTO ruf_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Mna litsuwa lya kadatu, wampfika mne Ing'anda ye Imulungu mghati mwe iwalangulitsi wa Chiyahudi, ang'ali yowategheletsa na ukuwaghutsa. ");
INSERT INTO ruf_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Wose watsihulike mbuli tsake wakangawala na tsimbutsi tsake na apfila pfawedike. ");
INSERT INTO ruf_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Weletsi wake hawamwonile wakangawala ng'ani. Mai wake kamghutsa, “Mwanangu, ebali ututenda apfi? Nene na aba wako tung'ali tukubama kwa usungu.” ");
INSERT INTO ruf_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yesu kawedika, “Angu mnibamila choni? Ng'ammanyile bae nene nibamighwa nikale mne ing'anda ya Aba wangu?” ");
INSERT INTO ruf_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Lekeni wao ng'awamanyile bae imbuli yawalongele ina mana yachi. ");
INSERT INTO ruf_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kuya, koya nawo mbaka Natsareti ako ang'ali yowahulikitsa. Mai wake keka ipfinu pfose mne ghumoyo ghwake. ");
INSERT INTO ruf_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Na Yesu kakula na kongetseka ihekima na utali, na kumnoghelesa Imulungu ne iwanu. ");
INSERT INTO ruf_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ghumwaka ghwa kumi na tano ghwa undewa wa Mndewa Tiberi, Pontiyo Pilato tsakakala mkulu wa isi ya Yudeya, Herodi tsakakala mkulu wa Galilaya, na ndughu yake Filipi tsakakala mkulu wa Ituleya na isi ya Tilakoniti, na Lusaniya tsakakala mkulu wa Abilene. ");
INSERT INTO ruf_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anasi na Kayafa tsawakala iwakulu we inambiko. Mna matsuwa agho, imbuli ye Imulungu tsaimtsila Yohane, imwana wa Sakariya akula kunyika. ");
INSERT INTO ruf_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Apfo, Yohane kanga isi yose iibakane na ghumto Yoridani. Kawapetela iwanu watsileke nzambi tsawo na wabatitsighwe, ili Imulungu awaleghusile nzambi tsawo. ");
INSERT INTO ruf_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ka pfayandikighwe mne ichitabu cha nabii Isaya, “Litsi lye imunu lyokema kulawa kunyika, ‘Mmwikile ghoya Imtwatsa nzila yake, mgholose nzila yake. ");
INSERT INTO ruf_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Chila lwanda lutsomemetsighwa, chila chidunda na sughulu pfitsomwaghaluka, hanu hapfeduke hatsogholosighwa nzila itsihile tsitsogholosighwa na kukala ghoya. ");
INSERT INTO ruf_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Na iwanu wose watsowona ukombotsi we Imulungu!’ ” ");
INSERT INTO ruf_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Kuya iwanu wamghendela Yohane ili awabatitse, naye kawalongela, “Mwemwe iwana we nzoka! Yuhi yawalongele mwodaha kuhepa ukuhighighwa ne Imulungu? ");
INSERT INTO ruf_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mtende aghala igholangusa ka mtsileka nzambi tsenu. Mleke kwilongela, ‘Abrahamu aba wetu!’ Nowalongela, kulawa mne ghamabwe ghano Imulungu kodaha kumlapfila Abrahamu iwana. ");
INSERT INTO ruf_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Kuya, hoya ikighwa ghoya msina mwe mibiki, apfo chila mbiki yang'aghukweleka ghamatunda ghanoghile ghutsoghanighwa na kwasighwa mna ghumoto.” ");
INSERT INTO ruf_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Kingili lye iwanu limghutsa, “Lelo tutandetse?” ");
INSERT INTO ruf_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yohane kawedika, “Imunu yane ghamaghwanda meli yamwing'e yula yalihela lighwanda, na yane ichijo yatende pfipfo.” ");
INSERT INTO ruf_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Nawo iwasola kodi watsa wabatitsighwe, wamghutsa, “Imlangulitsi, twetwe tutende choni?” ");
INSERT INTO ruf_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Nae kawalongela, “Mleke kusola kodi kubita pfamlaghitsighwe.” ");
INSERT INTO ruf_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Nawo asikali wamghutsa, “Na twetwe tutende choni?” Naye kawedika, “Mleke kuboka ipfinu pfe imunu wowose na mleke kumbangitsila imunu wowose. Mwenele na achila chamulihighwa.” ");
INSERT INTO ruf_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Iwanu wang'ali wololela ipfinu ipfitsolawila, wandusa kwalangula mna imimoyo yawo mbuli tsa Yohane, pfii ayu ka Kiristu? ");
INSERT INTO ruf_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Baho Yohane kawalongela wose, “Nene nowabatitsa mwemwe kwa ghamatsi, lekeni kakutsa yane ngupfu kubita nene, nene sidaha bae kumdoholela mitsabi ye imikwabatsa yake. Ayo katsowabatitsa kwa Ghumuhe ghwe Imulungu na kwa ghumoto ghwa kuhigha. ");
INSERT INTO ruf_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ayo kana lungo mne ghamoko ghake, abetele uhemba wake, awike hamwe mne ikano yake na katsolakatsa mikumvi mne ghumoto ing'aghutsimika bae.” ");
INSERT INTO ruf_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Apfo kwa mbuli tsingi, Yohane tsayang'ali yowapetela iwanu Imbuli Inoghile. ");
INSERT INTO ruf_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Lekeni Yohane tsakamkembela Herodi, mkulu wa Galilaya, kwaapfila kamkwela Herodiya, mwehe wa ndughu yake, ne ipfinu pfingi pfihile pfatendile Herodi. ");
INSERT INTO ruf_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Kuya Herodi kongetsa ichinu chingi chihile kwa kumwika Yohane mne ligheretsa. ");
INSERT INTO ruf_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Iwanu wose hawamalile kubatitsighwa, kuya Yesu kabatitsighwa. Na hang'ali yolomba, ililanga lighubuka, ");
INSERT INTO ruf_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","na Ghumuhe ghwe Imulungu ghumuhulumkila mne lukuli ka lwe injiwa. Litsi kulawa kulanga lilonga, “Ghweghwe kwa Imwanangu yuninoghela, nonoghelighwa naghwe.” ");
INSERT INTO ruf_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu handuse isang'ano yake tsakana miyaka ka selasini. Iwanu tsawepfikitsa yeye kakala imwana wa Yosefu, imwana wa Heli. ");
INSERT INTO ruf_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli tsakakala imwana wa Matati, iyakalile imwana wa Lawi, imwana wa Meliki, imwana wa Yani, imwana wa Yosefu, ");
INSERT INTO ruf_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","iyakalile imwana wa Matatia, imwana wa Amosi, imwana wa Nahumu, imwana wa Hesili, imwana wa Nagai, ");
INSERT INTO ruf_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","iyakalile imwana wa Mahati, imwana wa Matatia, imwana wa Semeyi, imwana wa Yoseki, imwana wa Yuda, ");
INSERT INTO ruf_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","iyakalile imwana wa Yohaneni, imwana wa Resa, imwana wa Serubabeli, imwana wa Setieli, imwana wa Neri, ");
INSERT INTO ruf_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","imwana wa Meliki, imwana we Adi, imwana wa Kosamu, iyakalile imwana we Elimadamu, imwana we Eri, ");
INSERT INTO ruf_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","iyakalile imwana wa Yoshua, imwana wa Eliyetseri, imwana wa Yorimu, imwana wa Matati, imwana wa Lawi, ");
INSERT INTO ruf_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","iyakalile imwana wa Simoni, imwana wa Yuda, imwana wa Yosefu, imwana wa Yonamu, imwana we Eliyakimu, ");
INSERT INTO ruf_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","iyakalile imwana wa Maleya, imwana wa Mena, imwana wa Matata, imwana wa Natani, imwana wa Daudi, ");
INSERT INTO ruf_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","iyakalile imwana wa Yese, imwana wa Obedi, imwana wa Boasi, imwana wa Salimoni, imwana wa Nasoni, ");
INSERT INTO ruf_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","iyakalile imwana wa Aminadabu, imwana we Adimini, imwana we Arini, imwana wa Hesironi, imwana wa Peresi, imwana wa Yuda, ");
INSERT INTO ruf_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","iyakalile imwana wa Yakobu, imwana we Isaka, imwana we Abrahamu, imwana wa Tera, imwana wa Nahori, ");
INSERT INTO ruf_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","iyakalile imwana wa Serugi, imwana wa Reyu, imwana wa Pelegi, imwana wa Eberi, imwana wa Sala, ");
INSERT INTO ruf_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","iyakalile imwana wa Kainamu, imwana wa Arifakisadi, imwana wa Shemu, imwana wa Nuhu, imwana wa Lameki, ");
INSERT INTO ruf_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","iyakalile imwana wa Metusela, imwana wa Enoki, imwana wa Yaredi, imwana wa Mahalaleli, imwana wa Kainamu, ");
INSERT INTO ruf_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","iyakalile imwana wa Enosi, imwana wa Seti, imwana wa Adamu, iyakalile imwana we Imulungu. ");
INSERT INTO ruf_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu kalawa mne ghumto Yoridani kamema Ghumuhe ghwe Imulungu, na Ghumuhe haghwo ghumlongotsa mbaka kunyika. ");
INSERT INTO ruf_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ako kaghetsighwa na Setani kwa matsuwa alubaini. Mne agho, ng'ajile bae chinu chochose, na matsuwa agho haghamalile tsakona nzala. ");
INSERT INTO ruf_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Setani kamlongela; “Ka ghweghwe kwe Imwana wa Imulungu, ulilongele libwe lino liwe chighate.” ");
INSERT INTO ruf_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Lekeni Yesu kamwidika, “Yandikighwa, ‘Imunu ng'odaha bae kuwa mghima kwa kuja chighate chiliyeka.’ ” ");
INSERT INTO ruf_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Bahala Setani kamlongotsa Yesu mbaka kuchanya, kamlangusa undewa wose uli mne isi yose. ");
INSERT INTO ruf_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Setani kamlongela, “Nitsokwing'a undewa na ukulu mne pfinu pfose pfino, kwaapfila pfose pfamne ghamoko ghangu, na nene nodaha kumwing'a imunu wowose yanimbama.” ");
INSERT INTO ruf_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","“Nitsokwing'a ipfinu pfose pfino ka kutsonitambikila.” ");
INSERT INTO ruf_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu kamwidika, “Yandikighwa, ‘Umtambikile Imtwatsa Imulungu wako, ne umsang'anile yeye yaliyeka!’ ” ");
INSERT INTO ruf_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kuya Setani kamlongotsa mbaka kune ghumji ghwa Yerusalemu, mchiswili mwe Ing'anda ye Imulungu. Kamlongela, “Ka ghweghwe kwa Imwana we Imulungu, wilaghatse kulawa hano mbaka hasi. ");
INSERT INTO ruf_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kwaapfila yandikighwa, ‘Imulungu katsowalaghitsa wamalaika wake wakulolese. ");
INSERT INTO ruf_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Nawo watsokukinda mne ghamoko ghao, uleke kwikwala ghumghulu ghwako mne libwe.’ ” ");
INSERT INTO ruf_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Lekeni Yesu kamwidika, “Ilongighwa, ‘Uleke kumghetsa Imtwatsa Imulungu wako.’ ” ");
INSERT INTO ruf_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Setani hayamalitse kumghetsa Yesu kwa chila chinu, kamleka chidogho. ");
INSERT INTO ruf_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Kuya Yesu koya mne isi ya Galilaya kamema ingupfu ya Ghumuhe ghwe Imulungu. Mbuli tsake tsenela Galilaya na mne tsiisi itsili habehi. ");
INSERT INTO ruf_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yang'ali yolangulitsa mne tsing'anda tsawo tsa ukulombela na iwanu wose wamtunya. ");
INSERT INTO ruf_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Kuya Yesu koya Natsareti hanu hayalelighwe. Mne Litsuwa lya Sabato, kaghenda mne ing'anda ye ukulombela ka pfayatsowele. Kema na kusoma Ghamaandiko Mahenzeluka. ");
INSERT INTO ruf_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Keng'ighwa ichitabu cha nabii Isaya. Kachipfughula, kahona hanu handikighwe, ");
INSERT INTO ruf_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ghumuhe ghwe Imtwatsa ghwa hachanya hangu, kwaapfila kanisaghula nene niwaghalile wahingwa imbuli inoghile. Kanituma niwapetele iwohighwe ka watsolekelighwa, ne ipfifita watsokona. Na kuwalekelela iwanu iwoghaya. ");
INSERT INTO ruf_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Na kuwalongela ka matsuwa ghapfika ghe Imtwatsa kuwakombola iwanu wake.” ");
INSERT INTO ruf_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesu kachighubika ichitabu, kamwing'a imtumwa, kuya kakala hasi. Iwanu wose mne ing'anda ye ukulombela wamtsodolela tsinenge. ");
INSERT INTO ruf_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Naye kawalongela, “Ighandikighwe leloli ghatimila mne ghamaghutwi ghenu.” ");
INSERT INTO ruf_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Wose wamtoghola, wakangawala na mbuli tsinoghile tsalongile. Walonga, “Angu ayu si imwana wa Yosefu bae?” ");
INSERT INTO ruf_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesu kawalongela, “Nomanya mwodaha kunilongela imbuli ino, ‘Imghanga, wihonetse imwenyegho! Ghose ghatuhulike ghutendile akula Kaperinaumu, pfipfila ghatende hano ukaye yako’ ” ");
INSERT INTO ruf_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Kaghendelela kulonga, “Nowalongela ghendo, nabii ng'otogholighwa bae ukaye yake. ");
INSERT INTO ruf_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Mnitegheletse! Nowalongelani ghendo tsakukala na pfitsuka wengi mne isi ya Isiraeli mna matsuwa gha nabii Eliya. matsuwa agho imvula ng'aitowile bae kwa miyaka midatu na miyetsi sita, apfo tsakukala ne inzala ng'ulu mne isi yose. ");
INSERT INTO ruf_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Eliya ng'atumighwe bae kwe chitsuka wowose, lekeni katumighwa kwe chitsuka yumwe iyakalile Sarefati mne isi ya Sidoni. ");
INSERT INTO ruf_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Mna matsuwa gha nabii Elisha tsakukala ne iwanu wengi mne isi ya Isiraeli iwoghula ukoma. Kuduhu imunu wowose yahonile, lekeni Naamani yaliyeka, imunu wa isi ya Siria.” ");
INSERT INTO ruf_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Iwanu wose mne Ing'anda ye ukulombela hawahulike apfi wona maya ng'ani. ");
INSERT INTO ruf_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Wenuka, wamghala Yesu kunze kwa ghumji, na wamghala mchidando mwe chidunda, hanu ihatsengighwe kaye tsawo. Wabama wamwase kulwanda, ");
INSERT INTO ruf_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","lekeni kabita mghati mwe kingili, koka. ");
INSERT INTO ruf_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Kuya Yesu kahulumka Kaperinaumu, ghumji ghwa Galilaya. Na mne litsuwa lya Sabato kandusa kuwalangulitsa iwanu. ");
INSERT INTO ruf_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Tsawakangawala kwa malangulitso ghake, kwaapfila ghalangulitse tsa ghana ngupfu. ");
INSERT INTO ruf_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Mne ing'anda ye ukulombela tsa kuna imunu yane ichinyamkela yehile, kakemelela kalonga, ");
INSERT INTO ruf_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ubama kututenda choni, Yesu wa Natsareti? Kutsa kutukoma? Nokumanya ghweghwe kwa Imtumighwa Mwenzeluka we Imulungu!” ");
INSERT INTO ruf_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu kamkembela ichinyamkela, “Winyamale, umlawe imunu yuno!” Kuya ichinyamkela kamghwisa hasi imunu ayo hambele hawo, kamlawa bila kumlagha. ");
INSERT INTO ruf_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Iwanu wose wakangawala ng'ani, welongela, “Ahino mbuli yachi lelo? Imunu yuno kodaha na kana ngupfu tsa kuwakembela ipfinyamkela, nawo womuhulika!” ");
INSERT INTO ruf_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Apfo mbuli tsa Yesu tsenela mne isi yose ya Galilaya. ");
INSERT INTO ruf_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu kalawa mne ing'anda ye ukulombela, kaghenda mne ing'anda ya Simoni. Mai wake mwehe wa Simoni yang'ali yoghula homa kali ng'ani, wamlomba Yesu amuhonetse mai ayo. ");
INSERT INTO ruf_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Apfo kaghenda kema habehi na mai ayo, kaukembela utamu. Nawo utamu umlawa, bahala kenuka, kandusa kuwatumikila. ");
INSERT INTO ruf_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Litsuwa haling'ali lyotsama, iwanu wamghalila Yesu iwanu iwang'ali woghula chila utamu, naye keka ghamoko ghake mwa chila mtamu, kawahonetsa wose. ");
INSERT INTO ruf_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ipfinyamkela tsawawalawa iwanu wengi na kudama, “Ghweghwe kwe Imwana wa Imulungu!” Yesu kawakembela na kuwaghoma kulonga, kwaapfila tsawammanya yeye kakala Kiristu. ");
INSERT INTO ruf_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Lupfilipfili Yesu kaghenda kunze kwe ghumji hanu halihela imunu. Iwanu wandusa kumbama, na hawamwonile wabama kumghoma aleke kuka. ");
INSERT INTO ruf_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Lekeni kawalongela, “Pfipfila nobamighwa kuwapetela iwanu Mbuli Inoghile ye Undewa we Imulungu kune imiji ingi, kwaapfila acho chicho Imulungu chanitumile kuchitenda.” ");
INSERT INTO ruf_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Apfo kaghendelela ukuwapetela iwanu mne tsing'anda tse ukulombela mne isi yose ya Yudeya. ");
INSERT INTO ruf_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Litsuwa limwe Yesu tsakema mmbalimbali mwa tsiwa Genesareti, baho iwanu wammemela na kumkunughitsa kunughitsa, wategheletsa Imbuli ye Imulungu. ");
INSERT INTO ruf_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Kayona minumbwi mili mmbalimbali mwe tsimbu, ilekighwe na iwalowa somba iwang'ali wohopfugha nyapfu tsao. ");
INSERT INTO ruf_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu kengila mne mnumbwi ghumwe ghwa Simoni, kamlongela aghusoghetse mnumbwi chidogho kulawa mmbalimbali mwe tsimbu mbaka mne ghamatsi. Kuya kakala hasi na kalangulitsa mtingano ghwe iwanu aku kamne mnumbwi. ");
INSERT INTO ruf_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Hayamalitse kulonga, kamlongela Simoni, “Usoghetse mnumbwi ghupfike haghatighati, kuya utsase nyapfu tsako mne ghamatsi upfule iwasomba.” ");
INSERT INTO ruf_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simoni kamwidika, “Imtwatsa! Tusang'ana ichilo chose ng'atupatile ichinu bae. Lekeni kwaapfila kulonga apfo, notsasa!” ");
INSERT INTO ruf_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Watsasa nyapfu tsao na wapfula iwasomba wengi ng'ani mbaka nyapfu tsao tsandusa kudegheka. ");
INSERT INTO ruf_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Apfo wawabengutsa wayawo iwakalile mne mnumbwi ghungi watse wawapfile. Wapfika, waweka iwasomba mne minumbwi yose mili mbaka ibama kutsama. ");
INSERT INTO ruf_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simoni Petiri hayonile achila ichilawile, kamtowela Yesu maghoti kalonga, “Ughende Imtwatsa! Nene ne imunu yane nzambi!” ");
INSERT INTO ruf_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simoni na weyaghe wakangawala kwe iwasomba wengi wawalowile. ");
INSERT INTO ruf_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Pfipfila weyaghe Simoni, Jakobu na Yohane, iwanaghe Sebedayo nawo wakangawala. Yesu kamlongela Simoni, “Uleke kupfuka, kulawa sambi na kughendelela kutsowapfula iwanu.” ");
INSERT INTO ruf_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Waikwegha minumbwi yawo mbaka mmbalimbali mwe tsimbu, waleka chila ichinu, wamuwinza Yesu. ");
INSERT INTO ruf_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesu hang'ali mne ghumji ghumwe, tsakatsa imunu yane ukoma lukuli lwose. Imtamu ayo hamwonile Yesu, keghwisa hasi, kalomba “Imtwatsa, ka kwobama, kwodaha kunitenda nihone!” ");
INSERT INTO ruf_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu kagholosa ghumoko, kamkinda, kalonga, “Nobama; Uhone!” Bahala ukoma umlawa. ");
INSERT INTO ruf_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesu kamlongela, “Uleke kumlongela imunu wowose. Lekeni ughende, wilanguse kwe imbala we inambiko ne ulapfe inambiko ka Musa pfawalongele, iwanu wose wamanye ka ghweghwe kuhona.” ");
INSERT INTO ruf_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Lekeni mbuli tsa Yesu tsongetseka kwenela mne isi yose, na iwanu wengi wapfika kumtegheletsa na wambama awahonetse utamu wawo. ");
INSERT INTO ruf_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Lekeni Yesu tsakaghenda hanu halihela imunu, ako kalomba. ");
INSERT INTO ruf_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Litsuwa limwe Yesu yang'ali yolangulitsa. Mafarisayo wangi na iwolangulitsa Ghamalaghitso iwalawile mne imiji ya Galilaya, Yudeya na Yerusalemu tsawakala bahala. Ngupfu ye Imtwatsa tsaikala naye kwa kuwahonetsa iwatamu. ");
INSERT INTO ruf_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Iwanu wangi wapfika, wamduta machela mne lutsatsi imunu yaholole, wabama wamghale mng'anda, hambele ha Yesu. ");
INSERT INTO ruf_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Lekeni ng'awadahile bae, kwaapfila tsahana iwanu wengi sideke. Apfo wamghala, wamwika mchiswili, wafumla kuya wahulumsa machela mbaka haghatighati he iwanu awo, hayali Yesu. ");
INSERT INTO ruf_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu honile ukutoghola kwawo, kamlongela imunu yaholole, “Sale yangu, nzambi tsako tsileghusighwa.” ");
INSERT INTO ruf_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Iwolangulitsa Ghamalaghitso na Mafarisayo wandusa kwighutsa, “Ayuno imunu wachi iyomligha Imulungu? Yuhi iyodaha kuleghusa nzambi? Angu si Imulungu yaliyeka iyodaha kuleghusa nzambi!” ");
INSERT INTO ruf_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu kamanya chawang'ali wakwalangula, kawaghutsa, “Mkwalangula choni mne imimoyo yenu? ");
INSERT INTO ruf_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Chihi chibewe; kulonga ‘Nzambi tsako tsileghusighwa’ au kulonga ‘Winuke ughende?’ ");
INSERT INTO ruf_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Nobama mmanye, Imwana we Imunu kana uwetso wa kuleghusa nzambi mne iisi.” Apfo kamlongela imunu yaholole, “Nokulongela, winuke usole chilagho chako uye ukaye!” ");
INSERT INTO ruf_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Bahala imunu ayo kenuka hambele hawo, kasola chilagho chake. Koka ukaye yake aku komtunya Imulungu. ");
INSERT INTO ruf_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Iwanu wose wakangawala ghendo! Wapfuka na wamtunya Imulungu, walonga, “Leloli tupfona ipfinu pfa kukangawatsa!” ");
INSERT INTO ruf_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Haghamalile agho, Yesu kalawa kunze kamwona imunu iyosola kodi yakemighwe Lawi kakala mne ing'anda ya kulihila kodi. Yesu kamlongela, “Uniwinze.” ");
INSERT INTO ruf_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lawi kenuka, kaleka chila chinu kamuwinza. ");
INSERT INTO ruf_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Kuya Lawi kamtendela Yesu chihungo chikulu mne ing'anda yake, na kingili kulu lye iwanu iwasola kodi ne iwanu wangi tsawabahala. ");
INSERT INTO ruf_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Lekeni Mafarisayo wangi na iwolangulitsa Ghamalaghitso wangi iwalawile mne kingili lyawo wawanung'unikila iwanang'ina wa Yesu, “Ebali mwakuja na kunwa hamwe ne iwanu iwasola kodi na wane nzambi?” ");
INSERT INTO ruf_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu kawedika, “Iwanu iwaghima ng'awombama bae imghanga, ila awala iwatamu iwo iwombama imghanga. ");
INSERT INTO ruf_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Sitsile bae kuwakema iwanu iwanoghile, ila wane nzambi wadahe kutsileka.” ");
INSERT INTO ruf_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Iwanu wangi wamlongela Yesu, “Iwanang'ina wa Yohane wafungagha ukuja na kulomba, na iwatumighwa wa Mafarisayo wotenda pfipfo. Lekeni iwanang'ina wako wakuja na kunwa!” ");
INSERT INTO ruf_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu kedika, “Apfi mwodaha kuwaghoma iwanu iwakemighwe kune chihungo cha kukwela waleke ukuja ahala imunu yokwela ang'ali nawo? ");
INSERT INTO ruf_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Lekeni litsuwa lyakutsa imunu yokwela hatsosolighwa kulawa mna wawo, na baho watsofunga ukuja.” ");
INSERT INTO ruf_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Kuya Yesu kawalongela imbuli ino, “Kuduhu imunu iyodegha ichiraka kulawa mne lighwanda lya sambi na kuchika mne lighwanda lya ghumwande. Ka kotenda apfo, katsolidegha lighwanda lya sambi, na ichiraka kulawa mne lighwanda lya sambi ng'achitsolingana bae na lighwanda lya ghumwande. ");
INSERT INTO ruf_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Na kuduhu imunu iyoghuma dipfai ya sambi mne imikoba ye ingotsi ya ghumwande. Kwaapfila ka kotenda apfo, dipfai ya sambi itsoitula imikoba hayo, dipfai itsakwitika na imikoba itsohinyika. ");
INSERT INTO ruf_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Lekeni dipfai ya sambi yobamighwa ighumighwe mne imikoba ya sambi! ");
INSERT INTO ruf_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kuduhu imunu iyakunwa dipfai ya ghumwande na kuya abame dipfai ya sambi, kwaapfila kolonga, ‘Ya ghumwande inogha.’ ” ");
INSERT INTO ruf_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Litsuwa limwe lya sabato Yesu ang'ali yobita mne imighunda ya uhemba. Iwanang'ina wake wandusa kukwanyula mikungwi ya uhemba, waifighisa mne ghamoko ghawo waja. ");
INSERT INTO ruf_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mafarisayo wangi waghutsa, “Ebali mwotenda ichinu ichighomighwe mne litsuwa lya Sabato?” ");
INSERT INTO ruf_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu kawedika, “Apfi ng'amsomile bae achila chatendile Daudi na wayaghe hawakalile ne inzala? ");
INSERT INTO ruf_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Daudi tsakengila mne ing'anda ye Imulungu, kasola pfighate ipfilapfighwe kwe Imulungu kapfija. Pfipfila kaweng'a wayaghe. Ghamalaghitso ghomghoma imunu wowose kupfija pfighate apfo, ila ipfilongotsi we inambiko waliyeka iwabamighwe kupfija.” ");
INSERT INTO ruf_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Kuya Yesu kawalongela, “Imwana we Imunu kana ukulu mne Litsuwa lya Sabato.” ");
INSERT INTO ruf_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Mne Litsuwa lingi lya Sabato, Yesu tsakaghenda kulangulitsa mne ing'anda ya ukulombela. Mne ing'anda ila ye ukulombela tsakukala ne imunu yaholole ghumoko ghwa ukujila. ");
INSERT INTO ruf_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Iwolangulitsa Ghamalaghitso wangi na Mafarisayo tsawabama imbuli ya kumghoghela Yesu. Apfo wamlolesa ka ang'amuhonetse imunu mne Litsuwa lya Sabato. ");
INSERT INTO ruf_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Lekeni Yesu kamanya chawang'ali wakwalangula, kamlongela imunu ayo yaholole ghumoko, “Utse wime hano.” Imunu ayo kenuka, kema hala. ");
INSERT INTO ruf_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Kuya Yesu kawalongela, “Nowaghutseni mwemwe, apfi mna Litsuwa lya Sabato pfinogha kutenda ghanoghile au kutenda ghehile? Kuukombola ughima we imunu au kuukoma?” ");
INSERT INTO ruf_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Kawalolesa iwanu wose iwali hala, kuya kamlongela imunu ayo, “Ugholose ghumoko ghwako.” Katenda ka Yesu pfamlongele, na ghumoko ghwake ghuhonetsighwa. ");
INSERT INTO ruf_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Lekeni iwanu wona maya wandusa kwilongela iwenyegho ichinu chachi wamtendele Yesu. ");
INSERT INTO ruf_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Mna matsuwa agho Yesu kagheluka kuchidunda, kakala meso chilo chose komlomba Imulungu. ");
INSERT INTO ruf_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Nemitondo haipfikile, Yesu kawakema iwanang'ina wake. Kawasaghula iwanang'ina kumi na weli kulawa mumula mne kingili lyawo, kaweng'a taghwa iwatumighwa. ");
INSERT INTO ruf_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simoni, Yesu kamwing'a taghwa lya keli Petiri, na ndughu yake Andereya, Jakobu, Yohane, Filipi, Batalomeyo. ");
INSERT INTO ruf_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matei na Tomasi na Jakobu imwana we Alifayo na Simoni iyakemighwe Zelote, ");
INSERT INTO ruf_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yuda imwana wa Jakobu na Yuda Isikarioti, yamhunduke Yesu. ");
INSERT INTO ruf_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesu hayahulumke kuchidunda na iwatumighwa wake, kema mlwanda na kingili kulu lye iwanang'ina wake. Iwanu wengi tsawabahala iwalawile tsiisi tsose tsa Yudeya, Yerusalemu na walawile mne tsiisi tsa kumwani tsa Tiro na Sidoni. ");
INSERT INTO ruf_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Iwanu awo watsa kumtegheletsa Yesu na kuhonetsighwa matamu ghawo. Pfipfila iwanu wala iwadununzighwe ne ipfinyamkela watsa wahonetsighwa. ");
INSERT INTO ruf_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Iwanu wose tsawabama kumkinda Yesu, kwaapfila ingupfu ing'ali imlawa na iwahonetsa wose. ");
INSERT INTO ruf_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu kawalola iwanang'ina wake kalonga, “Mbweda mwemwe wahingwa, kwaapfila Undewa we Imulungu iwo wenu! ");
INSERT INTO ruf_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mbweda mwemwe yamne nzala sambi, kwaapfila mwitseghuta! Mbweda mwemwe yamlila sambi, kwaapfila mtsosekelela! ");
INSERT INTO ruf_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Mbweda ka iwanu watsowahila, watsowabaghula na watsowaligha na watsolonga mwemwe mwiha, kwaajili ye Imwana we Imunu! ");
INSERT INTO ruf_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Deng'eleleni na kubigha agho haghotsolawila kwaapfila ghweko lyenu kulu likighwa kulanga. Apfo pfipfo iwabala wawo pfawawatendele manabii. ");
INSERT INTO ruf_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Lekeni mtsoghaya mwemwe matajili, kwaapfila mwemwe ma tsambokela ughima unoghile! ");
INSERT INTO ruf_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Mtsoghaya mwemwe yamwighutile sambi, kwaapfila hambele mtsakona inzala! Mtsoghaya mwemwe yamsekelela sambi, kwaapfila hambele mtsoghanzika no kulila! ");
INSERT INTO ruf_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Mtsoghaya ka iwanu wose watsowatogholani mwemwe! Kwaapfila apfo pfipfo iwabala wawo pfawawatendele manabii wa ughutsu. ");
INSERT INTO ruf_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Lekeni nowalongela mwemwe yamnihulika, muwanoghele iwehile wenu, muwatendele ghanoghile iwanu wala iwowehila. ");
INSERT INTO ruf_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Muwabaliki iwanu wala iwowalighita, na muwalombele kwe Imulungu iwanu wala iwowatendela ghehile. ");
INSERT INTO ruf_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ka imunu wowose kakutowa mna likanza limwe, pfipfila mleke akutowe likanza liyaghe, ka imunu kolisola likoti lyako, pfipfila mleke asole lighwanda lyako. ");
INSERT INTO ruf_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mwing'eni chila imunu cholomba, ka imunu wowose kakuboka ichinu chako, uleke kumlongela akuyitsile. ");
INSERT INTO ruf_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Muwatendele iwanu wangi achila chambama mwemwe wawatendele. ");
INSERT INTO ruf_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Mng'awanoghela iwanu wala iwomnoghelani mwemwe, apfi uluso wachi wamlangusa? Hata ‘iwanu wane nzambi’ pfipfila wowanoghela iwanu wala iwowanoghela! ");
INSERT INTO ruf_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Mng'awatendela ghanoghile iwanu wala iwowatendela ghanoghile, apfi uluso wachi wamlangusa? Pfipfila ‘iwanu wane nzambi’ wotenda pfipfo! ");
INSERT INTO ruf_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Mng'awakopesha iwanu wala yamuwalolela watsomuyitsilani, apfi uluso wachi wamlangusa? Pfipfila ‘iwanu wane nzambi’ wowakopesha wayawo, na kuwalolela wawoyitsile. ");
INSERT INTO ruf_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Lekeni wanogheleni iwowahila mwemwe na muwatendele ghanoghile, muwakopeshe iwanu na mleke kulolela ka watsowoyitsila. Kuya ghweko lyenu litsakuwa kulu, na mtsakuwa iwana we Imulungu iyali Kuchanya Ng'ani. Kwaapfila yeye kanogha kwe iwanu yang'awolonga mighede ne iwanu wehile. ");
INSERT INTO ruf_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Muwe na libatsi, ka Aba wenu pfali na libatsi. ");
INSERT INTO ruf_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Mleke kuwahigha wayenu, ne Imulungu ng'atsowahighani bae. Mleke kuwadununza wayenu, ne Imulungu ng'atsowadununzani bae. Muwalekele wayenu, ne Imulungu katsowalekeleni. ");
INSERT INTO ruf_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Muweng'e iwanu wangi, ne Imulungu katsomwing'ani. Namwe mtsobokela ichipimo chimemile mbaka chakwitika. Kwaapfila ichipimo chamtumila kwe iwanu wangi, Imulungu katsochitumila chicho kuna mwemwe.” ");
INSERT INTO ruf_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Kuya Yesu kawalongela imbuli ino, “Imunu chifita ng'odaha bae kumlongotsa chifita miyaghe, ka katsotenda apfo, wose weli watsakughwila mwikolongo. ");
INSERT INTO ruf_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Kuduhu mwanang'ina mkulu kubita mlangulitsi wake. Lekeni chila mwanang'ina iyamalitse ghamalangulitso ghake, kakuwa ka imlangulitsi wake. ");
INSERT INTO ruf_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ebali kwochona chibanzi ichili mnenge mwa miyagho, lekeni ng'aulyona bae biki ili mnenge mwako? ");
INSERT INTO ruf_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Apfi kwodaha kumlongela ndughu yako, ‘Ndughu yangu, leka nikulapfe chibanzi chili mnenge mwako,’ naghwe ghumwenyegho ng'ulyona bae biki ilili mnenge mwako? Ghweghwe kwa mng'enye! Tanu ulilapfe libiki lili mnenge mwako, kuya kutsolola ghoya na kuchilapfa chibanzi chili mnenge mwa ndughu yako.” ");
INSERT INTO ruf_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Mbiki ghunoghile ng'aghukweleka bae ghamatunda ghehile, pfipfila kuduhu mbiki ghuhile ighwukweleka ghamatunda ghanoghile. ");
INSERT INTO ruf_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Chila mbiki ghwomanyika kwa ghamatunda ighukweleka, iwanu ng'awobawa bae mapela mne tsimiwa au ukubawa fifi mne miyonga. ");
INSERT INTO ruf_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Imunu yanoghile kolapfa ipfinu pfinoghile kulawa hanu hanoghile ipfikighwe mne ghumoyo ghwake, imunu yehile kolapfa ipfinu pfihile kulawa hanu hehile ipfikighwe mne ghumoyo ghwake. Kwaapfila imunu kolonga achila ichimemile mne ghumoyo ghwake.” ");
INSERT INTO ruf_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ebali mwonikema ‘Mtwatsa, Mtwatsa’ aku ng'amtenda bae achila chaniwalongele mchitende? ");
INSERT INTO ruf_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nitsowalangusa kakonekatse imunu wowose yula iyonitsila nene na kutsitegheletsa mbuli tsangu na kutenda ka pfobamighwa. ");
INSERT INTO ruf_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ayu keghala ne imunu yatsengile ing'anda kwa kuhimba ng'ani mne libambalawe, na kutsenga ing'anda ayo mchanya mwake. Imvula ng'ulu haitowile ghamatsi ng'aghadahile bae kuyughitsa ing'anda, kwaapfila itsengighwa ghoya. ");
INSERT INTO ruf_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Lekeni imunu iyotegheletsa mbuli tsangu na ng'otenda ka pfobamighwa, ayu keghala ne imunu yatsengile ing'anda mne msanga, bila ukuhimba ng'ani. Imvula ng'ulu haitowile, ghamatsi ghayughitsa ing'anda na kuighwisa, ne ing'anda yose ibomoka.” ");
INSERT INTO ruf_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu hayamalitse ukulonga ipfinu pfino kwe iwanu, kaghenda Kaperinaumu. ");
INSERT INTO ruf_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ako tsakukala ne imkulu yumwe we asikali miya imwe wa Roma, naye kakala ne imtumwa wake iyamnoghele ng'ani. Na imtumwa ayo ang'ali yoghula chidogho yafe. ");
INSERT INTO ruf_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Imkulu ayo hayahulike mbuli tsa Yesu, kawatuma iwabala wangi wa Wayahudi wamlombe Yesu atse amhonetse imtumwa wake. ");
INSERT INTO ruf_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Wamghendela Yesu, wamlomba ng'ani, walonga, “Umwapfile imunu yuno, ");
INSERT INTO ruf_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","kwaapfila kowanoghela iwanu wetu, naye iyo iyatutsengele ing'anda ye ukulombela.” ");
INSERT INTO ruf_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Apfo Yesu kaghenda nawo. Hapfikile habehi ne ing'anda ye imkulu ayo, imkulu ayo kawatuma sale tsake wamlongele Yesu, “Imtwatsa, uleke kwitsupfa kutsa kuno. Nene sinoghile bae ghweghwe kwingila mng'anda mwangu. ");
INSERT INTO ruf_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ndo mana tsambona nene sinoghile bae kukutsila ghweghwe. Lekeni ulonge imbuli iliyeka, imtumwa wangu katsohona. ");
INSERT INTO ruf_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kwaapfila nene imwenyegho na imunu yane ukulu, nina asikali iwali hasi hangu. Ning'amlongela yumwe, ‘Ghenda!’ naye koghenda, na ning'amlongela yungi, ‘Itsa!’ naye kakutsa, na ning'amlongela imtumwa wangu, ‘Tenda achino!’ naye kochitenda.” ");
INSERT INTO ruf_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu hahulike apfo, kakangawala, kawahundukila iwanu iwelongotse naye, kawalongela, “Nowalongela ghendo, sina mbone bae imunu iyotoghola ka imunu yuno, hata mne isi ya Isiraeli!” ");
INSERT INTO ruf_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Kuya iwanu wala hawoyile ukaye kwe imkulu wa asikali wa Roma wampfika imtumwa yula kahona. ");
INSERT INTO ruf_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Hambele chidogho, Yesu kaghenda mne ghumji ighukemighwe Naini na iwanang'ina wake, aku kelongotsa na iwanu wengi. ");
INSERT INTO ruf_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Kuya hapfikile habehi na libani kulu lye ghumji, kulawila iwanu waghala lukuli lwa msongolo iyapfile, yeye tsamwana nyalimwe wa ipinga iyali chitsuka. Iwanu wengi iwalawile ghumji ghula tsawakala hamwe na ipinga ayo. ");
INSERT INTO ruf_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Imtwatsa hayamwonile ipinga ayo, kamwonela libatsi, kamlongela, “Uleke kulila.” ");
INSERT INTO ruf_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kuya kaghenda kakinda machela, ne iwanu iwaghalile machela tsawema. Yesu kalonga, “Imsongolo, nokulongela, winuke!” ");
INSERT INTO ruf_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Imsongolo yula iyafile kenuka kandusa ukulonga. Kuya Yesu kamwing'a mai we imsongolo yula. ");
INSERT INTO ruf_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Iwanu wose wapfuka na wamtunya Imulungu. Walonga, “Nabii mkulu katulawila mghati mwetu. Imulungu katsa kuwapfila iwanu wake.” ");
INSERT INTO ruf_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Mbuli atsino tsa Yesu tsenela mne isi yose ya Yudeya na tsiisi tsose itsili habehi. ");
INSERT INTO ruf_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Iwanang'ina wa Yohane wamlongela Yohane agha ghose. Naye kawakema iwanang'ina wake weli ");
INSERT INTO ruf_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","kawatuma waghende kwe Imtwatsa wamghutse, “Apfi ghweghwe kwa yuyula yulongighwe na Yohane katsakutsa au tumbete imunu yungi?” ");
INSERT INTO ruf_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Hawapfikile kwa Yesu, walonga, “Yohane Mbatitsa katutuma tukughutse, ‘Apfi ghweghwe kwa yuyula yulongighwe na Yohane katsakutsa au tumbete munu yungi?’ ” ");
INSERT INTO ruf_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ichipindi chichila, Yesu kawahonetsa iwatamu wengi ng'ani, kawalapfa ipfinyamkela na kawatenda ipfifita wengi wone. ");
INSERT INTO ruf_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yesu kawedika iwanang'ina wa Yohane, “Mghende mkamlongele Yohane aghala ghamwonile na kughahulika; ipfifita sambi wakwona, ipfimbete woghenda, wane ukoma wohona, ipfitsiwi wohulika, iwanu iwafile wotsilihulighwa na mbuli tsinoghile tsopetighwa kwe wahingwa. ");
INSERT INTO ruf_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kabweda imunu yula yang'onyihila nene.” ");
INSERT INTO ruf_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Hambele iwasenga wa Yohane hawokile, Yesu kandusa kuwalongela iwanu mbuli tsa Yohane, “Hamghendile kunyika, apfi mghendile kulola choni? Kululola lusinde ppfaluyughisighwa na libeho? ");
INSERT INTO ruf_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Apfi tsamghendile kulola choni? Imunu yapfalile lighwanda linoghile? Iwanu iwopfala ghamaghwanda ghanoghile na wane ughima unoghile wokala mne tsing'anda tse iwandewa! ");
INSERT INTO ruf_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Mnongele, apfi tsamghendile kulola choni? Nabii? Ona, lekeni tsamwona pfinu pfingi kubita nabii. ");
INSERT INTO ruf_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Kwaapfila Yohane iyo yuyo iyandikighwe mna Ghamaandiko Mahenzeluka, ‘Imulungu tsakalonga, nitsomtuma imtumighwa wangu akulongole, katsoigholosa nzila yako.’ ” ");
INSERT INTO ruf_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Kuya Yesu kawalongela, “Yohane kambala kubita imunu wowose, lekeni imunu wowose yali mdodo mne Undewa wa Imulungu kambala kumbita Yohane.” ");
INSERT INTO ruf_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Iwanu wose, na iwasola kodi, hawahulike agho wamtoghola Imulungu, kwaapfila tsawabatitsighwa na Yohane. ");
INSERT INTO ruf_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Lekeni Mafarisayo na iwolangulitsa Ghamalaghitso tsawalema aghala ghayawalaghitse Imulungu watende, kwaapfila ng'awabatitsighwe na Yohane bae. ");
INSERT INTO ruf_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu kaghendelela kulonga, “Apfi iwanu wa mweleko ghuno weghala ne chinu chachi? Weghala na choni? ");
INSERT INTO ruf_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Weghala ne iwana iwakalile kusoko. Wekema wenyegho kwa wenyegho, ‘Tuwatowela chimbeta, ng'ampfinile bae, tuwembila uwila we usungu, ng'amlilile bae!’ ");
INSERT INTO ruf_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yohane Mbatitsa tsakatsa, ng'ajile bae ichijo na ng'anwile bae imbwali, mwemwe mlonga, ‘Yohane kana chinyamkela!’ ");
INSERT INTO ruf_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Imwana we imunu katsa, kakuja na kakunwa, namwe mlonga, ‘Imunu yuno kakujisa na kopatika sideke, sale wa iwasola kodi na wane nzambi!’ ");
INSERT INTO ruf_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Lekeni ihekima yoneka inogha kwe iwanu wose yawaitoghole.” ");
INSERT INTO ruf_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mfarisayo yumwe tsakamkema Yesu atse kuja naye ichijo cha nemihe. Yesu kaghenda mne ing'anda ya Mfarisayo ayo, kakala hasi yaje ichijo. ");
INSERT INTO ruf_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Mne ghumji ghula, tsakukala ne ipinga yane nzambi. Hayahulike Yesu kakuja mne ing'anda ya Mfarisayo ayo, ipinga ayo katsa na ichupa inoghile imemile ghamafuta ighonung'ila ghoya. ");
INSERT INTO ruf_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Kema habehi na ghamaghulu gha Yesu, kolila na ghamasotsi ghake ghamlaghalila Yesu. Kuya kabaghusa ghamaghulu gha Yesu kwa tsimvili tsake, kaghanonela na kabaka ghamafuta aghala, mmaghulu mwa Yesu. ");
INSERT INTO ruf_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Mfarisayo ayo honile pfino, kelongela imwenyegho, “Imunu yuno ang'awile nabii, ang'amtangile ipinga yuno iyamkindile ka imunu wachi, ang'ammanyile kana nzambi!” ");
INSERT INTO ruf_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu kamlongela, “Simoni, nina chinu nobama nikulongele” Simoni kedika, “Ona mlangulitsi, nongele.” ");
INSERT INTO ruf_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesu kandusa kulonga, “Tsahana wanu weli iwatsime sendi kwe imunu iyakwatsima iwanu tsisendi. Yumwe katsima elufu tano na yungi katsima hamsini. ");
INSERT INTO ruf_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Mna wose weli, kuduhu yalihile sendi, apfo imunu iyakwatsima wanu tsisendi kawalekela wose. Apfi mne wano weli yuhi yatsomnoghela ng'ani imunu iyakwatsima iwanu tsisendi?” ");
INSERT INTO ruf_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoni kamwidika, “Nopfikitsa imunu yula yalekelighwe tsisendi nyingi.” Yesu kalonga, “Kulonga ghoya.” ");
INSERT INTO ruf_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kuya Yesu kamhundukila ipinga ayo, kamlongela Simoni, “Apfi kwomwona ipinga hayu? Nitsa mng'anda mwako, ng'ungaile bae ghamatsi gha kuhopfugha ghamaghulu ghangu, lekeni ipinga ayu kahopfugha ghamaghulu ghangu kwa ghamasotsi ghake na kaghabaghusa kwa tsimvili tsake. ");
INSERT INTO ruf_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ng'uninonele bae, lekeni kulawa hayengile ipinga ayu kaghendelela kughanonela ghamaghulu ghangu. ");
INSERT INTO ruf_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ng'ubakile bae litwi lyangu ghamafuta, lekeni ipinga ayu kaghabakatsa ghamaghulu ghangu kwa ghamafuta ighonung'ila ghoya. ");
INSERT INTO ruf_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nokulongela, kwaapfila nzambi tsake nyingi tsileghusighwa, apfo kaninoghela ng'ani. Lekeni imunu yalekelighwe chidogho konoghela chidogho.” ");
INSERT INTO ruf_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Kuya Yesu kamlongela ipinga ayo, “Nzambi tsako tsileghusighwa.” ");
INSERT INTO ruf_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Iwanu wangi iwakalile hala wandusa kwilongela, “Ayu imunu wachi mbaka yaleghuse nzambi?” ");
INSERT INTO ruf_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yesu kamlongela ipinga hayo, “Ukutoghola kwako kukukombola. Ughende tseghamba.” ");
INSERT INTO ruf_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Matsuwa ghaghala, Yesu tsakanga mne tsikaye na mna imiji, kuno kowapetela iwanu imbuli inoghile ye undewa we Imulungu. Na wala Iwanang'ina kumi na weli waghenda na Yesu, ");
INSERT INTO ruf_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","naye tsakelongotsa ne iwapinga wangi iwalapfighwe ipfinyamkela na kuhonetsighwa matamu. Iwapinga awo tsawakala Mariya iyakemighwe Magidalena, yalapfighwe ipfinyamkela saba, ");
INSERT INTO ruf_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","na Yoana, mwehe wake Kusa, imkulu mne libaratsa lya Herodi, na Susana, na iwapinga wangi wengi. Wawo tsawalapfa pfinu pfawo wamwapfile Yesu ne iwanang'ina wake. ");
INSERT INTO ruf_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Iwanu wamghendela Yesu kulawa chila kaye, iwanu hawatingane hamwe, Yesu kawalongela imbuli ino, ");
INSERT INTO ruf_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Imunu tsakaghenda kuhanda tsimbeghu. Hang'ali yomitsa tsimbeghu mne mghunda, tsingi tsilaghalila mnzila. Iwanu watsibayugha na pfideghe watsija. ");
INSERT INTO ruf_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Tsingi tsilaghalila mne lidongo lili mbambalawe, hatsotile, tsinyala kwaapfila tsakuduhu ghamatsi mne lidongo. ");
INSERT INTO ruf_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Tsingi tsilaghalila mwibagho, tsikula hamwe, na libagho litsikoma tsimbeghu hatso. ");
INSERT INTO ruf_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Na tsingi tsilaghalila mne lidongo linoghile, tsikula na kweleka imitama, chila imwe ghana limwe.” Yesu hayalongile apfi, kakemelela, “Imunu yane ghamaghutwi gha kuhulika, yahulike!” ");
INSERT INTO ruf_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Iwanang'ina wake wamghutsa Yesu imbuli ino ina mana yachi? ");
INSERT INTO ruf_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yesu kawedika, “Mwemwe mtendighwa mmanye mbuli tse undewa we Imulungu. Lekeni kwe iwanu wangi, nolonga kwe tsimbuli, walole lekeni waleke kwona, wategheletse lekeni waleke kumanya.” ");
INSERT INTO ruf_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Aino mana ye imbuli ino. Mbeghu yolangusa imbuli ye Imulungu. ");
INSERT INTO ruf_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Tsimbeghu itsilaghalile mnzila tsolangusa iwanu iwohulika imbuli ye Imulungu, lekeni Setani kakutsa na kuisola imbuli kulawa mne imimoyo yawo, ili waleke kutoghola na kukombolighwa. ");
INSERT INTO ruf_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Tsimbeghu itsilaghalile mne lidongo lili mbambalawe tsolangusa iwanu iwohulika imbuli ye Imulungu na kuibokela kwa kudeng'elela, lekeni ng'aitsama bae mghati mwe imimoyo yawo. Woitoghola kwe ichipindi chidodo, lekeni mne ichipindi cha kughetsighwa na Setani, webaghula. ");
INSERT INTO ruf_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Tsimbeghu itsilaghalile mwibagho tsolangusa iwanu iwohulika imbuli ye Imulungu lekeni pfawoghendelela, imbuli ye Imulungu yohinyighwa na maghayo, ndeng'elelo, na tsimali tse isi. Iwanu awo ng'awokweleka ghamatunda ghakomale bae. ");
INSERT INTO ruf_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Lekeni tsimbeghu itsilaghalile mne lidongo linoghile tsolangusa iwanu iwohulika imbuli ye Imulungu, woibokela na woitoghola kwe imimoyo yawo na wodudumila mbaka wokweleka ghamatunda.” ");
INSERT INTO ruf_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Iwanu ng'awotuwitsa bae ichitasa na kuchighubika na chiha au kuchika kumpfungu mwe lutsatsi. Lekeni iwanu wochika hanu ha kwikila chitasa ili iwanu iwakwingila wadahe kughona ghumwanga. ");
INSERT INTO ruf_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Kwaapfila ichinu chochose ichipfisighwe chitsakuwa mwatsi, na ichinu chochose ichighubikighwe chitsomanyika na kughalighwa mne ghumwanga. ");
INSERT INTO ruf_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Apfo mwalangitse pfamuhulikitsa, kwaapfila imunu yenacho katsakongetsighwa, ne imunu yalihela ichinu katsobokighwa hata achila chopfikitsa kenacho.” ");
INSERT INTO ruf_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Mai wake ne iwandughu tsake Yesu wamtsila, lekeni ng'awadahile bae kupfika habehi naye, kwaapfila iwanu tsawengi sideke. ");
INSERT INTO ruf_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Imunu yumwe kamlongela Yesu, “Mai wako na ndughu tsako wema kunze, wobama wakwone.” ");
INSERT INTO ruf_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yesu kedika, “Mai wangu na ndughu tsangu, iwo wala iwohulika imbuli ye Imulungu na kuitoghola.” ");
INSERT INTO ruf_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Litsuwa limwe Yesu kengila mne mnumbwi ne iwanang'ina wake, kawalongela, “Tuloke kumwambu mwe tsimbu.” Apfo wandusa ghumwanza. ");
INSERT INTO ruf_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Hawang'ali mne ghumwanza, Yesu kawasa. Bahala, nyahemu ng'ulu ng'ani tsailawila mne tsimbu na mnumbwi wandusa kumema ghamatsi, apfo wose tsawabama watsame. ");
INSERT INTO ruf_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Iwanang'ina wake wamghendela wamlamsa, “Mtwatsa, Mtwatsa! Twotsama!” Yesu kalamka, kalikembela libeho ne inyahemu, napfo pfinyamala. Litsimbu linyamala tulu. ");
INSERT INTO ruf_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Kuya Yesu kawaghutsa iwanang'ina wake, “Kulikwani ukutoghola kwenu?” Lekeni wakangawala, wapfuka, welongela, “Ayu imunu wachi? Kokembela libeho ne inyahemu, napfo pfomhulikitsa?” ");
INSERT INTO ruf_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesu ne iwanang'ina wake waghendelela na ghumwanza, wapfika mne isi ya Gerasi, ili kumwambu mwe tsimbu Galilaya. ");
INSERT INTO ruf_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu hayang'ali yohulumka mne mnumbwi, kaghenda mmbalimbali mwe tsimbu, ketingana ne imunu yane ipfinyamkela. Imunu ayo ng'apfalile bae ghamaghwanda kwa ghamatsuwa mengi, na ng'akalile bae mng'anda, lekeni ang'ali yokala kune tsikaburi. ");
INSERT INTO ruf_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Hamwonile Yesu, tsakalila na kamghwila mmaghulu, kuya kakemela, “Yesu, Imwana we Imulungu Iyali Kuchanya Ng'ani! Apfi kwobama unitende choni? Nokulomba uleke kunidununza!” ");
INSERT INTO ruf_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Imunu yuno kalonga apfino kwaapfila Yesu tsakawakembela ipfinyamkela wamlawe. Chinyamkela ayo ang'ali yomghoghagha. Hata ka iwanu tsawamwoha ghamoko na ghamaghulu ghake ne minyololo, yeye kaibema minyololo ayo, na ipfinyamkela wamghalagha mbaka kunyika. ");
INSERT INTO ruf_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu kamghutsa, “Taghwa lyako nani?” Naye kamwidika, “Taghwa lyangu ‘Likingili’,” kwaapfila tsakana ipfinyamkela wengi. ");
INSERT INTO ruf_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ipfinyamkela wamlomba Yesu aleke kuwaghala mne lipondo lyang'alitsigha. ");
INSERT INTO ruf_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Habehi na hanu hala tsahana kingili lye iwangubi iwang'ali wakuja mlughongo. Apfo pfinyamkela wamlomba Yesu awalekelele wawengile iwangubi awo, naye Yesu kawaleka wawengile. ");
INSERT INTO ruf_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ipfinyamkela wamlawa imunu ayo wengila mne iwangubi. Likingili lyose lye iwangubi litsumila kulwanda mwe tsimbu Galilaya, wafa mne ghamatsi. ");
INSERT INTO ruf_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Wadimi we iwangubi hawonile achila ichilawile, watsuma na kutsilonga mbuli atso mne ghumji na mne ipfijiji. ");
INSERT INTO ruf_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Iwanu waghenda kulola achila ichilawile, hawapfikile kwa Yesu, wampfika imunu yahonetsighwe ipfinyamkela kakala mmaghulu mwa Yesu, kapfala ghamaghwanda, na tsimbutsi tsake tsimuyila keli. Iwanu wose tsawapfuka. ");
INSERT INTO ruf_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Iwanu wala iwonile chinu chino wawalongela iwanu apfila imunu yane ipfinyamkela pfayahonetsighwe. ");
INSERT INTO ruf_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kuya iwanu wose we isi ya Gerasi wamlomba Yesu yoke kwaapfila tsawapfuka ghendo. Apfo Yesu kengila mne mnumbwi yoke. ");
INSERT INTO ruf_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Imunu yahonetsighwe ipfinyamkela kamlomba Yesu, “Leka nighende na ghweghwe.” Lekeni Yesu ng'atoghole bae kughenda naye, kamlongela, ");
INSERT INTO ruf_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Uye ukaye ukawalongele iwanu achila chayakutendele Imulungu.” Apfo kaghenda muisi mwose, kawalongela iwanu achila Yesu chayamtendele. ");
INSERT INTO ruf_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu hayoile ubali ungi wa tsimbu, iwanu wambokela kwa kudeng'elela kwaapfila wose tsawang'ali wombeta. ");
INSERT INTO ruf_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Kuya katsa imunu yumwe yakemighwe Yairo, iyakalile mkulu we Ing'anda ya ukulombela. Keghwisa mmaghulu mwa Yesu, kamlomba aghende ukaye yake, ");
INSERT INTO ruf_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kwaapfila imwanaghe ipinga nyalimwe yane miyaka kumi na mili yang'ali yobama yafe. Yesu hayang'ali yoghenda, iwanu wammemela chila hanu. ");
INSERT INTO ruf_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Pinga yumwe yadununzike kwa utamu wa kulawa idamu kwa miyaka kumi na mili, hata ka tsakaghisa mali tsake tsose kwa waghanga, tsakuduhu imunu yadahile kumhonetsa, tsakakala mne iwanu awo. ");
INSERT INTO ruf_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Pinga ayo tsakatsa kuchisogho kwa Yesu kakinda pindo lya ghwanda lyake. Bahala idamu ileka kumlawa. ");
INSERT INTO ruf_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesu kaghutsa, “Angu yuhi yanikindile?” Iwanu wose wabela. Petiri kalonga, “Imtwatsa, iwanu wakutsunguluka na wakumemela!” ");
INSERT INTO ruf_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Lekeni Yesu kalonga, “Kuna imunu kang'inda, nimanya kwaapfila ngupfu tsangu tsindawa.” ");
INSERT INTO ruf_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ipinga hayonile ng'odaha bae kwipfisa, tsakatsa aku koghudema, keghwisa mmaghulu mwa Yesu. Kamlongela Yesu hambele he iwanu iwali hala ichinu ichimtendile amkinde na bahala pfayahonetsighwe. ");
INSERT INTO ruf_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesu kamlongela ipinga ayo, “Mwanangu, ukutoghola kwako kukuhonetsa. Ughende tseghamba.” ");
INSERT INTO ruf_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu hang'ali yolonga, tsakatsa imunu kulawa mne ing'anda ya Yairo. Kamlongela Yairo, “Uleke kumtsupfa Imlangulitsi.” ");
INSERT INTO ruf_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Lekeni Yesu haulike apfo kamlongela Yairo, “Uleke kupfuka, ghwe toghola na imwanagho katsohonetsighwa.” ");
INSERT INTO ruf_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Hapfikile ukaye kwa Yairo, kawaghoma iwanu waleke kwingila naye mng'anda, lekeni Petiri, Yohane, Jakobu, aba wa imwana yula iyafile na mai wake. ");
INSERT INTO ruf_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Wanu wose wang'ali womlila imwana iyafile akuno weyayana. Yesu kawalongela, “Mleke kulila, imwana ng'afile bae, ila kawasa!” ");
INSERT INTO ruf_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Iwanu wose wamseka Yesu kwaapfila tsawamanya imwana kafa. ");
INSERT INTO ruf_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yesu kaghukinda ghumoko ghwe imwana iyafile, kamlongela, “Mwanangu, lamka!” ");
INSERT INTO ruf_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Imwana iyafile ughima wake umuyila, na bahala kalamka. Kuya Yesu kawalongela wamwing'e imwana yula ichijo. ");
INSERT INTO ruf_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Aba wake na mai wake tsawakangawala, lekeni Yesu kawaghoma kumlongela imunu wowose achila ichilawile. ");
INSERT INTO ruf_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu tsakawakema hamwe iwanang'ina wake kumi na weli, kaweng'a ingupfu na uwetso wa kulapfa ipfinyamkela na kuhonetsa watamu. ");
INSERT INTO ruf_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Kuya kawatuma kuwapetela iwanu mbuli tsa Undewa we Imulungu na kuwahonetsa iwatamu. ");
INSERT INTO ruf_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Kawalongela, “Mne ghumwanza mleke kusola ichinu chochose, mleke kusola ng'weku wala ghumkoba wala ichijo wala sendi wala maghwanda meli. ");
INSERT INTO ruf_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ing'anda yoyose yamkwingila, mkale mmo mbaka hamkuka mne ghumji aghwo. ");
INSERT INTO ruf_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Iwanu wang'alema kuwabokela, hamlawa mne ghumji aghwo, mkung'use litimbwisi mmaghulu mwenu, chiwe ichitango ka walema kumuhulikitsani.” ");
INSERT INTO ruf_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Iwanang'ina wake waghenda mne ipfijiji pfose, aku wopeta Imbuli Inoghile na wowahonetsa iwanu chila hanu. ");
INSERT INTO ruf_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herodi hakalile mndewa wa Galilaya, kahulika ipfinu pfose ipfitendighwe na Yesu. Naye kapfuka kwaapfila iwanu wangi tsawang'ali wolonga Yohane mbatitsa katsilihuka, ");
INSERT INTO ruf_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","wangi walonga Eliya kalawila, na wangi walonga nabii yumwe wa ghumwande katsilihuka. ");
INSERT INTO ruf_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodi kalonga, “Yohane tsanimghana litwi, apfi ayu nani iyanihulika mbuli tsake?” Naye tsakabama amwone. ");
INSERT INTO ruf_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Iwatumighwa wake hawoyile wamlongela Yesu chila ichinu chawatendile. Naye kawasola iwanang'ina wake waliyeka, kaghenda nawo mne ghumji ighukemighwe Betisaida. ");
INSERT INTO ruf_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Iwanu hawamanyile kwaghendile, tsawamuwinza. Yesu kawabokela, kalonga nawo mbuli tse Undewa we Imulungu na kawahonetsa iwanu iwabamile kuhonetsighwa. ");
INSERT INTO ruf_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Litsua haling'ali lyikuswa, iwanang'ina kumi na weli wamghendela Yesu wamlongela, “Walongele iwanu waghende mne ipfijiji na kaye itsili mne imighunda tsa habehi kubama ichijo na hanu ha kuwasa, kwaapfila twakunyika.” ");
INSERT INTO ruf_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Lekeni Yesu kawedika, “Mwemwe iwenyegho muweng'e ichijo waje.” Wamwidika, “Twetwe tuna pfighate pfitano ne iwasomba weli waliheka. Pfii kwobama tughende tukawaghulile iwanu wose wano?” ");
INSERT INTO ruf_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Hanu hala hana wamale elufu tano. Yesu kawalongela iwanang'ina wake, “Muwalongele iwanu wakale mne makingili, na chila kingili wanu hamsini.” ");
INSERT INTO ruf_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Kuya iwanang'ina watenda apfo, iwanu wose wakala hasi. ");
INSERT INTO ruf_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesu kasola pfighate pfitano ne iwasomba weli, kalola kulanga, kapfibaliki. Kuya kamegha pfighate ne iwasomba, kaweng'a iwanang'ina wake waweng'e iwanu. ");
INSERT INTO ruf_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Iwanu wose tsawaja weghuta. Ne iwanang'ina wadondola pfihindi pfe pfighate ne iwasomba ipfimemile Pfiseghe kumi na pfili. ");
INSERT INTO ruf_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Litsuwa limwe Yesu ang'ali yolomba aliyeka. Iwanang'ina wake wamtsila, naye kawaghutsa, “Apfi iwanu wolonga nene nani?” ");
INSERT INTO ruf_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Nawo wamwidika, “Iwanu wamwenga wolonga ghweghwe kwa Yohane Mbatitsa, wangi wolonga kwa Eliya, wangi wolonga kwa-yumwe wa manabii wa ghumwande yoyile mne ughima.” ");
INSERT INTO ruf_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Naye kawaghutsa, “Namwe mwolonga nene nani?” Petiri kamwidika, “Ghweghwe kwa Kiristu yulawile kwe Imulungu.” ");
INSERT INTO ruf_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Kuya Yesu kawakanya waleke kumlongela imunu wowose ichinu chino. ");
INSERT INTO ruf_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Pfipfila tsakawalongela, “Imwana we Imunu kobamighwa yadununzike ng'ani na kulemighwa ne iwabala, ipfilongotsi we inambiko ne iwolangulitsa Ghamalaghitso. Katsokomighwa, kuya mne litsuwa lya kadatu katsotsilihuka.” ");
INSERT INTO ruf_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Kuya kawalongela wose, “Imunu wowose iyobama kuniwinza nene yeleme imwenyegho na yaghale msalaba ghwake, aniwinze. ");
INSERT INTO ruf_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Imunu wowose iyobama kuukombola ughima wake katsowaghitsa, lekeni wowose iyowaghisa ughima wake kwa kuniwinza nene katsoukombola. ");
INSERT INTO ruf_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Apfi imunu yobweda choni ka ang'apata chila chinu ichili muisi mwose, aku kowaghisa ughima wake? ");
INSERT INTO ruf_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Imunu wowose iyombonela chinyala nene na ghamalangulitso ghangu, Imwana we Imunu katsomwonela chinyala hatsakutsa mne utunitso wake, na mne utunitso wa aba wake, na we malaika wahenzeluka. ");
INSERT INTO ruf_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nowalongela ghendo, wangi iwemile hano ng'awatsakufa bae mbaka wawone Undewa we Imulungu.” ");
INSERT INTO ruf_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Aghabitile matsuwa manane kulawa halongile ipfinu pfino, Yesu kawasola Petiri, Yohane, na Jakobu, wagheluka kuchidunda kulomba. ");
INSERT INTO ruf_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yesu hang'ali yolomba, uhanga wake ughalamka na ghwanda lyake liwa tselu chwee. ");
INSERT INTO ruf_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Bahala iwanu weli wang'ali wolonga naye. Iwanu awo tsawakala Musa na Eliya, ");
INSERT INTO ruf_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","woneka mne utunitso wa kulanga na walonga na Yesu mbuli tsa lifwa lyake ilitsolawila Yerusalemu. ");
INSERT INTO ruf_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petiri na wayaghe tsawawasa ghendo, na hawalamke wona utunitso wa Yesu ne iwanu weli wema naye. ");
INSERT INTO ruf_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Iwanu awo hawang'ali wakuka, Petiri kamlongela Yesu, “Mtwatsa, pfinogha twetwe tukale hano. Leka tutsenge pfibumbulika pfidatu, chimwe chako, chimwe cha Musa na chimwe cha Eliya.” Petiri ng'amanyile bae yang'ali yolonga choni. ");
INSERT INTO ruf_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Petiri hang'ali yolonga apfo, liwingu lilawila liwaghubika, ne iwanang'ina wapfuka liwingu pfaliwaghubike. ");
INSERT INTO ruf_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Litsi lilonga kulawa mne liwingu, “Ayuno mwanangu yanimsaghule, mtegheletseni yeye!” ");
INSERT INTO ruf_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Litsi halinyamale, Yesu tsakakala aliyeka. Iwanang'ina wenyamala na ng'awamlongele imunu wowose bae ichinu chawonile ghamatsuwa agho. ");
INSERT INTO ruf_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Haipfikile nemitondo, Yesu na iwanang'ina wadatu wahulumka kuchidunda, na iwanu wengi wetingana naye. ");
INSERT INTO ruf_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Imunu yumwe iyakalile mna mtingano ghula ghwe iwanu kakemelela, “Mlangulitsi! Nokulomba umlole imwanangu, imwanangu nyalimwe! ");
INSERT INTO ruf_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ichinyamkela komghogha na komtenda adamilile, komtenda yaghwe chisala na lihofu lomlawa mne mlomo, na ng'omlekelela bae himahima! ");
INSERT INTO ruf_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Niwalomba iwanang'ina wako wamlapfe ichinyamkela, lekeni ng'awadahile bae.” ");
INSERT INTO ruf_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu kamwidika, “Ka! Pfii mwemwe mweleko ing'aghutoghola na iwaghile! Apfi ng'ale namwe na kuwadudumila mbaka tsuwachi?” Kuya kamlongela imunu ayo, “Nighalile hano imwanagho.” ");
INSERT INTO ruf_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Imsongolo hang'ali yomghendela Yesu, ichinyamkela kamghwisa hasi chisala. Yesu kamkembela ichinyamkela, kamhonetsa imsongolo ayo na kamuhitsa imsongolo ayo kwa aba wake. ");
INSERT INTO ruf_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Iwanu wose wakangawala kwa uwetso mkulu we Imulungu. Iwanu hawang'ali wokangawala kwa ghose ghayatendile Yesu, kawalongela iwanang'ina wake, ");
INSERT INTO ruf_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Mleke kwisemwa achino chaniwalongela! Imwana we Imunu katsoghalighwa mna ghamoko ghe iwanu.” ");
INSERT INTO ruf_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Lekeni iwanang'ina wake ng'awamanyile bae mana ye imbuli ino, kwaapfila ipfisighwa waleke kuimanya; nawo wapfuka kumghutsa Yesu imbuli ino. ");
INSERT INTO ruf_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Iwanang'ina wa Yesu wandusa kwihisanya yuhi yatsakuwa imkulu mna wawo. ");
INSERT INTO ruf_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu hamanyile ukwalangula kwawo, kamsola imwana mdodo kamwika habehi naye. ");
INSERT INTO ruf_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Kuya kawalongela iwanang'ina wake, “Imunu wowose iyombokela imwana yuno kwa taghwa lyangu kombokela nene. Ne imunu wowose iyombokela nene, pfipfila kombokela iyanitumile. Kwaapfila imunu wowose yali mdodo mna mwemwe katsakughwa mkulu mna mwemwe.” ");
INSERT INTO ruf_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohane kamlongela Yesu, “Mtwatsa, tumwona imunu kolapfa ipfinyamkela kwa taghwa lyako na tumghoma kutenda apfo, kwaapfila ng'elongotsagha na twetwe bae” ");
INSERT INTO ruf_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesu kamlongela Yohane ne iwanang'ina wangi, “Mleke kumghoma, kwaapfila imunu wowose iyowatoghola mwemwe kahamwe namwe.” ");
INSERT INTO ruf_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ghamatsuwa gha Yesu gha kuya kulanga aghapfikile habehi, Yesu kabama aghende Yerusalemu. ");
INSERT INTO ruf_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Kawalongotsa iwatumighwa iwaghendile mne tsikaye tsa Samariya kumwikila ghoya chila ichinu. ");
INSERT INTO ruf_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Lekeni iwanu wa Samariya ng'awambokele bae, kwaapfila tsawamanya koghenda Yerusalemu. ");
INSERT INTO ruf_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Iwanang'ina wake, Jakobu na Yohane hawonile apfo, wamghutsa Yesu, “Mtwatsa, apfi kwobama twetwe tukeme ghumoto ghuhulumke kulawa kulanga ghuwalakatse wose, ka Eliya pfayatendile?” ");
INSERT INTO ruf_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yesu kawahundukila kawakembela. ");
INSERT INTO ruf_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kuya Yesu ne iwanang'ina wake waghenda kuna kaye tsingi. ");
INSERT INTO ruf_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Hawang'ali mnzila, imunu yumwe kamlongela Yesu, “Nitsokuwinza hanu hohose utsoghenda.” ");
INSERT INTO ruf_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu kamlongela, “Wambwa wa kumuhulo wana tsimango ne iwapfideghe wana pfibali, lekeni Imwana we Imunu kahela hanu ha kuwasitsa litwi lyake na kubwihila.” ");
INSERT INTO ruf_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yesu kamlongela imunu yungi, “Niwinze!” Lekeni imunu yula kalonga, “Imtwatsa, leka tanu mbuye ukaye nikamtsike aba wangu.” ");
INSERT INTO ruf_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu kamwidika, “Leka iwanu iwafile wawatsike wayawo, ila ghweghwe ghenda upete Undewa we Imulungu.” ");
INSERT INTO ruf_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Imunu yungi kalonga, “Imtwatsa, nitsokuwinza lekeni leka tanu nikawalongele iwandughu tsangu nakuka.” ");
INSERT INTO ruf_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu kamlongela, “Imunu wowose iyokwaluka kulima na kuya kolola kuchisogho ng'obamighwa mne Undewa we Imulungu.” ");
INSERT INTO ruf_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kuya Imtwatsa kawasaghula iwanu wangi sabini na weli na kawatuma weliweli wamlongolele chila kaye na chila hanu abamile kughenda. ");
INSERT INTO ruf_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kawalongela, “Ghamapfuno mengi, lekeni iwosang'ana wadodo. Mumlombe Imtwatsa wa ghamahuno awatume watenda isang'ano mne mghunda ghwake. ");
INSERT INTO ruf_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Mghende! Nowatuma mwemwe ka iwang'olo mghati mwe wambwa wa kumuhulo. ");
INSERT INTO ruf_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mleke kusola ghumfuko au ghumkoba au imikwabatsa. Na mleke kulamsa imunu wowose mnzila. ");
INSERT INTO ruf_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Na ing'anda yoyose yamtsakwingila, tanu mlonge, ‘Mkale tseghamba mne ing'anda ino.’ ");
INSERT INTO ruf_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ka imunu yobama kukala tseghamba kabaho, katsakuwa tseghamba. Ka kuduhu imunu yobama kukala tseghamba, mwemwe mtsokala tseghamba. ");
INSERT INTO ruf_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mkale mne ing'anda hayo, mje na mnwe chochose chamkwing'ighwa; kwaapfila mtenda isang'ano kobamighwa yeng'ighwe sendi tsake. Mkale mne ing'anda iyampfikile na mleke kulawa mne ing'anda ayo na kughenda ing'anda ingi. ");
INSERT INTO ruf_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ka mwakwingila mne ghumji ne iwanu wowabokela, diyeni achila chamtsakwing'ighwa. ");
INSERT INTO ruf_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Muwahonetse iwatamu iwali hao muwalongele, ‘Undewa we Imulungu wa habehi yenu.’ ");
INSERT INTO ruf_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Lekeni ka mwakwingila mne ghumji ne iwanu wolema kuwabokela, biteni mna nzila tsawo mlonge, ");
INSERT INTO ruf_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Hata litimbwisi lya ghumji ghwenu ilinanahile mmaghulu mwetu twowakung'usilani mwemwe, chiwe chitango ka mlighitighwa, Lekeni mmanye pfino, Undewa wa Imulungu wa habehi ghendo’ ");
INSERT INTO ruf_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nowalongela ghendo, mne litsuwa lya kuhigha Imulungu katsoghuhigha ng'ani ghumji agho kubita ghumji ghwa Sodoma!” ");
INSERT INTO ruf_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Ghweghwe Kolasini kutsoghaya! Ghweghwe Betisaida kutsoghaya! Kwaapfila ka ipfinu pfa kukangawatsa ipfitendeke hano pfing'atendeke Tiro na Sidoni, iwanu iwali hala wang'apfalile maghwanda gha ghamaghuniya na wang'abakale lipfu kulangusa waleka nzambi tsawo. ");
INSERT INTO ruf_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Mne litsuwa lya kuhigha Imulungu katsoyonela libatsi imiji ya Tiro na Sidoni kubita mwemwe. ");
INSERT INTO ruf_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Naghwe Kaperinaumu! Apfi kutsakwinulighwa mbaka kulanga? Bae! Kutsakwasighwa mbaka kutsimu!” ");
INSERT INTO ruf_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesu kawalongela iwanang'ina wake, “Imunu iyowategheletsa mwemwe, konitegheletsa nene; ne imunu iyowalema mwemwe, kondema nene. Ne imunu iyondema nene, komlema yula iyanitumile!” ");
INSERT INTO ruf_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Hambele iwanu wala sabini na weli woya wodeng'elela ng'ani, walonga, “Mtwatsa, kwa taghwa lyako tuwakembela ipfinyamkela nawo watenda ka pfatubamile kutenda!” ");
INSERT INTO ruf_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesu kawedika, “Nimwona Setani kaghwa ka lumwesa kulawa kulanga. ");
INSERT INTO ruf_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mtegheletse! Niweng'ani ukulu mwemwe, apfo mwodaha kuwabajugha wanzoka ne iwainge; mtsakuwa na ukulu kwa iwehile wenu wose. Kuduhu ichinu chitsowalagha. ");
INSERT INTO ruf_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Lekeni mleke kudeng'elela kwaapfila ipfinyamkela wowapfukani, ila mdeng'elele kwaapfila mataghwa ghenu ghandikighwa kulanga.” ");
INSERT INTO ruf_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Isaa iila Yesu kadeng'elela ng'ani na Ghumuhe ghwe Imulungu. Kuya kalonga, “Aba, Imtwatsa wa kulanga ne iisi, nolonga mighede kwaapfila kupfipfisa ipfinu pfino kwe iwanu wane ihekima na iwomanya; na kupfilangusa kwe iwana wadodo! Ona, Aba, apfi pfipfo pfaubamile.” ");
INSERT INTO ruf_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Kaghendelela kuwalongela iwanu, “Aba wangu kangaya nene ipfinu pfose. Kuduhu imunu iyommanya Imwana ila Aba, na kuduhu imunu iyommanya Aba ila Imwana, ne iwanu wala iwasaghulighwe kulangusighwa ne Imwana.” ");
INSERT INTO ruf_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Kuya Yesu kawahundukila iwanang'ina wake kalonga nawo waliyeka, “Wabalikiighwa iwanu wala iwakona ipfinu pfamkwona mwemwe! ");
INSERT INTO ruf_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Kwaapfila nowalongela, manabii ne iwandewa wengi tsawabama wone achino chamkona mwemwe, lekeni ng'awadahile bae kwona; na kutegheletsa achino chamtegheletsa, lekeni ng'awadahile bae kutegheletsa.” ");
INSERT INTO ruf_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Mlangulitsi wa Ghamalaghitso kema amghetse Yesu, kamghutsa, “Mlangulitsi, apfi nobamighwa nitende choni ili niubokele ughima wa matsuwa ghose?” ");
INSERT INTO ruf_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu kamwidika, “Apfi Ghamalaghitso gholongatse? Apfi kwoghamanyatse?” ");
INSERT INTO ruf_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Imunu ayo kamwidika, “Mnoghele Imtwatsa Imulungu wako kwa ghumoyo ghwako ghwose, kwa muhe wako ghwose, kwa ngupfu tsako tsose na kwa tsimbutsi tsako tsose; na mnoghele miyagho ka pfawinoghela imwenyegho.” ");
INSERT INTO ruf_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu kamwidika, “Kwidika ghoya. Tenda apfo naghwe kutsakuwa na ughima.” ");
INSERT INTO ruf_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Lekeni imunu ayo kabama kwilangusa kanogha, apfo kamghutsa Yesu, “Yuhi imunu wa habehi yangu?” ");
INSERT INTO ruf_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu kamwidika, “Tsahana imunu yumwe yalawile Yerusalemu koghenda Yeriko. Wabapfi wamghogha, wamwibila ipfinu pfake, wamtowa chidogho yafe. ");
INSERT INTO ruf_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Baho kalawila mtambika kohulumka mna inzila iila, lekeni hamwonile imunu yula yatowighwe, kabita mmbalimbali. ");
INSERT INTO ruf_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Pfipfila Mlawi hapfikile na kumwona imunu yatowighwe, naye kabita mmbalimbali. ");
INSERT INTO ruf_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Lekeni Msamariya yumwe ang'ali yobita inzila iila kampfika imunu yula. Hamwonile, kamwonela libatsi. ");
INSERT INTO ruf_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Kamghendela, kambakatsa ghamafuta ne idipfai mne ipfilonda pfake kuya kapfoha kwa pfibwende. Kuya kamwika mne ipunda wake, kamghala mne ing'anda ya kuwasa iwahenza, kamng'otsola. ");
INSERT INTO ruf_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Litsuwa liwinzile Msamariya yula kamwing'a sendi imunu yane ing'anda, kamlongela, ‘Mlolese imunu yuno. Hanikuya, nitsokuyitsila chochose chutumile.’ ” ");
INSERT INTO ruf_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesu kamghutsa, “Mkwonatse, apfi mne iwanu awo wadatu, yuhi imunu wa habehi ne imunu iyatowighwe na wabapfi?” ");
INSERT INTO ruf_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Imlangulitsi wa Ghamalaghitso kamwidika, “Imunu yula yamwonele libatsi.” Yesu kamwidika, “Naghwe ghenda ukatende ka pfatendile Msamariya.” ");
INSERT INTO ruf_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu ne iwanang'ina wake hawang'ali woghenda, kengila mne ichijiji chimwe. Ipinga yumwe yakemighwe Marita kambokela ukaye yake. ");
INSERT INTO ruf_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ipinga ayo tsakana ndughu yake iyakemighwe Mariya, iyakalile hasi habehi na ghamaghulu ghe Imtwatsa. Naye ang'ali yotegheletsa malangulitso ghake. ");
INSERT INTO ruf_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marita ang'ali yoghaya na tsing'onde nyingi. Apfo, kamghendela Yesu, kamghutsa, “Imtwatsa, apfi ng'ukwona bae ndughu yangu kandekela ng'onde tsose nisang'ane nene niliyeka? Mlongele yatse yanyapfile!” ");
INSERT INTO ruf_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Imtwatsa kamwidika, “Marita! Kwokwalangula no ukughaya kwa ipfinu pfingi, ");
INSERT INTO ruf_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","lekeni ichinu chimwe chiliheka ichibamighwa, na Mariya kasaghula ichinu ichinoghile, na ng'atsobokighwa bae.” ");
INSERT INTO ruf_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Litsuwa limwe Yesu tsakakala hanu hamwe kolomba. Hayamalitse kulomba, imwanang'ina wake yumwe kamlongela, “Imtwatsa, utulangulitse kulomba ka Yohane pfayawalangulitse iwanang'ina wake.” ");
INSERT INTO ruf_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu kawalongela, “Hamlomba, mlonge apfi, ‘Aba wetu, taghwa lyako lienzeluka litogholighwe, Undewa wako utse. ");
INSERT INTO ruf_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Utwing'e ichijo chetu cha chila litsuwa. ");
INSERT INTO ruf_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Utuleghusile nzambi tsetu, ka pfatumleghusila chila yumwe yatutendele ghehile. Na uleke kutwingitsa mne kughetsighwa.’ ” ");
INSERT INTO ruf_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Kuya Yesu kawalongela iwanang'ina wake, “Tulonge yumwe wenu kaghenda mne ing'anda ya sale yake nechilo ne ukulonga, ‘Sale yangu, nokulomba ungaye ichijo, ");
INSERT INTO ruf_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","kwaapfila sale yangu yali mne ghumwanza katsa ukaye yangu, na nene nahela ichijo cha kumwing'a!’ ");
INSERT INTO ruf_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Na tulonge sale yako yali mng'anda kokwidika, ‘Leka nibwihile! Libani lihindighwa, nene ne iwanangu tuwasa. Sidaha bae kulamka na kukwing'a ichinu chochose!’ ");
INSERT INTO ruf_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nowalongela hata ka ng'atsolamka bae na kukwing'a ichijo kwaapfila ghweghwe kwa sale yake, hambele katsolamka na kukwing'a chila ichinu ichaubamile kwaapfila ng'awonile bae chinyala kughendelela kumlomba.” ");
INSERT INTO ruf_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Apfo nowalongela, mlombe namwe mtsakwing'ighwa, mbame namwe mtsopata, mghong'onde libani namwe mtsofughulighwa. ");
INSERT INTO ruf_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kwaapfila imunu wowose iyolomba katsobokela, ne imunu wowose iyobama katsopata, ne imunu wowose iyoghonga libani katsofughulighwa. ");
INSERT INTO ruf_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Aba wachi mna mwemwe iyomwing'a imwanaghe inzoka, ka imwanaghe kamlomba isomba? ");
INSERT INTO ruf_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Au ang'amlomba lifinga, katsomwing'a inge? ");
INSERT INTO ruf_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ka mwemwe imwihile, mwomanya kuweng'a ipfinu pfinonoghile iwanenu, apfi Aba wenu yali kulanga ng'atsoweng'a bae Ghumuhe Mwenzeluka iwanu wala iwomlomba?” ");
INSERT INTO ruf_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yesu ang'ali yomlapfa ichinyamkela chibubu, na ichinyamkela hayalawile, imunu yula kandusa ukulonga, iwanu wakangawala. ");
INSERT INTO ruf_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Lekeni iwanu wangi walonga, “Ambe Belisebuli, imkulu we ipfinyamkela iyo iyomwing'a yeye ngupfu tsa kuwalapfa ipfinyamkela!” ");
INSERT INTO ruf_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Iwanu wangi wabama kumghetsa Yesu, apfo wamlomba Yesu atende chitango kulangusa ka kana ingupfu kulawa kulanga. ");
INSERT INTO ruf_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Lekeni Yesu kamanya chawang'ali wakwalangula, apfo kawalongela, “Undewa wowose iwighola wenyegho kwa wenyegho ng'autsakwima bae. Na ing'anda ing'awa na maghomba itsakughwa. ");
INSERT INTO ruf_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ka Setani keghola imwenyegho, apfi undewa wake utsakwimatse? Nolonga pfino kwaapfila mwemwe mwolonga nolapfa ipfinyamkela kwa tsingupfu tsa Belisebuli. ");
INSERT INTO ruf_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ka nene nowalapfa ipfinyamkela kwa ngupfu tsa Belisebuli, apfi iwanu wenu wowalapfa ipfinyamkela kwa ngupfu tsa nani? Iwanu wenu wenyegho watsowahigha mwemwe mtotsa. ");
INSERT INTO ruf_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Lekeni ka nolapfa ipfinyamkela kwa ngupfu tse Imulungu, lelo undewa we Imulungu uwatsila. ");
INSERT INTO ruf_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Imunu yane ngupfu hayoikalitsa ing'anda yake kwa mghowa, ipfinu pfake ng'apfisolighwa bae. ");
INSERT INTO ruf_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Lekeni imunu yungi yane ngupfu kumbita yeye hatsomghendela na kumuhuma, katsomboka mghowa ghwehuwile na kupfighola ipfinu pfambokile. ");
INSERT INTO ruf_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Imunu wowose ka ng'ali hamwe na nene bae, ayo konibela. Ne imunu wowose yang'onyapfila nene ukukunga, ayo kopwililisa.” ");
INSERT INTO ruf_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Ichinyamkela hayomlawa imunu, koghenda mne isi isakale kubama hanu ho kubwihila. Ka ng'apatile bae hanu ho kubwihila, kelongela imwenyegho, ‘Nitsakuya keli mne ing'anda yangu yaniilekile.’ ");
INSERT INTO ruf_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Apfo kakuya keli na kuipfika ing'anda yake itsengighwa pfinoghile. ");
INSERT INTO ruf_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kuya koghenda kuwasola ipfinyamkela wangi saba wane ngupfu kubita yeye. Nawo wakutsa kukala mghati mwe imunu ayo. Na ughima we imunu ayo wakuwa wiha kubita aho mwanduso.” ");
INSERT INTO ruf_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesu hang'ali yolonga ipfinu pfino, ipinga yumwe kulawa mne kingili kamlongela Yesu, “Kabweda ipinga iyakweleke na iyakwong'etse.” ");
INSERT INTO ruf_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Lekeni Yesu kamwidika, “Wabweda ghendo iwanu wala iwoitegheletsa Imbuli ye Imulungu na kuikinda.” ");
INSERT INTO ruf_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Iwanu hawang'ali wakwongetseka, Yesu kaghendelela kulonga, “Aghuno mweleko ghwihile, ghwobama ichitango. Ng'amtsakwing'ighwa bae ichitango chochose, ila ichitango chila cha Yona. ");
INSERT INTO ruf_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kwaapfila ka Yona pfayawile ichitango kwe iwanu wa Ninawi, pfipfila Imwana we Imunu katsakuwa ichitango kwe iwanu wa mweleko ghuno. ");
INSERT INTO ruf_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Mne litsuwa lya kuhigha, Malikiya wa Seba katsakwima na kuwahigha iwanu wa mweleko uno, kwaapfila yeye tsakalawa mne isi yake kaghenda kutegheletsa ghamahala gha ihekima ghe Mndewa Selemani, na hano hana mkulu kubita Imndewa Selemani. ");
INSERT INTO ruf_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Mne litsuwa lya kuhigha, iwanu wa Ninawi watsakwima na kuwahigha iwanu wa mweleko ghuno, kwaapfila wawo tsawatsileka nzambi tsawo hawamhulike Yona. Nowalongela ghendo, imunu mkulu kubita Yona kabaha!” ");
INSERT INTO ruf_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Kuduhu imunu iyotuwa ichitasa na kuchipfisa au kuchighubika kwa chiha. Lekeni kochika hanu ha kwikila chitasa, ili iwanu iwakwingila mghati wadahe kwona ghumwanga. ");
INSERT INTO ruf_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Tsinenge tsako tsaichitasa cha lukuli lwako. Ka tsinenge tsako tsakona, lukuli lwako lwose lwenela ghumwanga. Lekeni ka ng'atsikona bae, pfipfila lukuli lwako lwose lwenela chisi. ");
INSERT INTO ruf_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Walangitse ghumwanga ighuli mlukuli mwako, ghuleke kuwa ichisi. ");
INSERT INTO ruf_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Apfo, ka lukuli lwako lwose lwenela ghumwanga, na kuduhu ichisi, lukuli lwose lutsong'ala ghendo ka ichitasa pfachikumwemwesela kwa ghumwanga ghwake.” ");
INSERT INTO ruf_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu hayamalitse kulonga, Mfarisayo yumwe kamlomba Yesu aghende naye ukuja. Apfo Yesu kengila mng'anda, kakala hasi kaja. ");
INSERT INTO ruf_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mfarisayo ayo kakangawala hayamwonile Yesu kakuja bila kuhopfugha ghamoko ghake. ");
INSERT INTO ruf_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kuya Imtwatsa kamlongela, “Mwemwe Mafarisayo mwohopfugha ichikombe ne isahani kwa kunze, lekeni mghati mwenu mmema ukuboka na ukwiha. ");
INSERT INTO ruf_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mwawabotsi! Apfi ayula iyalumbile kunze, si yuyula bae iyalumbile mghati? ");
INSERT INTO ruf_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Lekeni muweng'e wahingwa ipfinu ipfili mghati mwe ipfikombe na tsisahani tsenu, na chila chinu chitsonogha kuna mwemwe. ");
INSERT INTO ruf_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Mtsoghaya mwemwe Mafarisayo! Kwaapfila mwomlapfila Imulungu tsaka tse bwasi ne itsimbogha tsose ka mnapfu ne imitsani ingi, lekeni mwoleka kutenda ghanoghile kwe iwanu na mwoleka kumnoghela Imulungu. Mwobamighwa tanu muwe iwanu we haki na iwomnoghela Imulungu, bila kughaleka agho ghangi. ");
INSERT INTO ruf_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Mtsoghaya mwemwe Mafarisayo! Kwaapfila mwonoghela kukala mne ipfighoda pfili hambele mne tsing'anda tsa ukulombela, na kulamsighwa kusoko. ");
INSERT INTO ruf_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Mtsoghoya, kwaapfila mweghala ne tsikabuli ing'atsikonekagha bae, na iwanu wobita mchanya akuno ng'awomanya bae” ");
INSERT INTO ruf_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mlangulitsi yumwe wa Ghamalaghitso kalonga, “Mlangulitsi, pfulonga pfino pfipfila kwotuligha na twetwe!” ");
INSERT INTO ruf_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu kamwidika, “Pfipfila mwemwe yamlangulitsa Ghamalaghitso mtsoghaya! Kwaapfila mwowatwika iwanu imitsigho mitito ng'ani, nayo ng'aidutika bae. Na mwemwe wenyegho ng'amuikinda bae hata kwa kugholosa chidole chimwe cha pfidole pfenu. ");
INSERT INTO ruf_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Mtsoghaya kwaapfila mwowatsengela tsikabuli manabii wala iwakomighwe ne iwabala wenu. ");
INSERT INTO ruf_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Mwemwe wenyegho mwotoghola aghala ghawatendile iwabala wenu, tsawawakoma manabii, namwe mwowatsengela tsikabuli tsawo. ");
INSERT INTO ruf_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Apfo, Hekima ye Imulungu tsailonga, ‘Nitsowatuma manabii ne iwatumighwa, wangi watsokomighwa na wangi watsowingighwa.’ ");
INSERT INTO ruf_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Apfo mweleko ghuno ghutsohighighwa kwa kuwakoma manabii wose kulawa isi hailumbighwe, ");
INSERT INTO ruf_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","kulawa kukomighwa kwa Abeli mbaka kukomighwa kwa Sakariya, iyakomighwe mghati mwe hanu he ukulapfila inambiko na hanu henzeluke. Ona, nowalongela lukolo luno lutsohighighwa kwa kuwakoma awo wose!” ");
INSERT INTO ruf_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Mtsoghoya mwemwe yamlangulitsa Ghamalaghitso! Kwaapfila mpfisa ufughulo wa libani lye ing'anda ya kumanyila. Namwe iwenyegho ng'amwingile bae, na mwowakima iwanu wala iwang'ali wakwingila!” ");
INSERT INTO ruf_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesu hayokile hanu hala, Mafarisayo na iwolangulitsa Ghamalaghitso wandusa kumghobola kwa kumghutsa ipfinu pfingi, ");
INSERT INTO ruf_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","wabama wamghoghe kwa ichinu chochose chatsolonga. ");
INSERT INTO ruf_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Iwanu wengi tsawetingana mbaka wang'ali webajugha, tanu Yesu kandusa kulonga ne iwanang'ina wake, “Mwalangitse ne hamila ya Mafarisayo ya ung'enye. ");
INSERT INTO ruf_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Chochose ichighubikighwe chitsoghubulighwa, na chochose ichifisighwe chitsomanyika. ");
INSERT INTO ruf_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Chochose chamlongile mchisi chitsohulikighwa mne ghumwanga, na chochose chamwinong'onetse mng'anda, chitsolongighwa mwatsimwatsi mchiswili.” ");
INSERT INTO ruf_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Nowalongela sale tsangu, mleke kuwapfuka iwanu wala iwolukoma lukuli, lekeni ng'awodaha bae kutenda ichinu chochose chihile. ");
INSERT INTO ruf_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nitsowalangusa yuhi wa kumpfuka. Mumpfuke Imulungu, hayomalitsa kukoma kodaha kumwasa imunu jehanamu. Nowalongela, mumpfuke yeye!” ");
INSERT INTO ruf_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Apfi pfideghe watano ng'awoghulighwa bae kwa sendi mbili? Lekeni kuduhu yumwe wao yosemwighwa ne Imulungu. ");
INSERT INTO ruf_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Hata tsimvili tsili mne mwitwi mwenu tsipetighwa. Mleke kupfuka kwaapfila mwemwe mnogha ng'ani kubita iwapfideghe wengi!” ");
INSERT INTO ruf_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Nowalongela ghendo, imunu wowose iyonitoghola nene hambele he wanu, Imwana we Imunu naye katsomtoghola hambele he malaika we Imulungu. ");
INSERT INTO ruf_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Lekeni imunu iyondema nene hambele he iwanu, naye Imwana we Imunu katsomlema hambele he malaika we Imulungu.” ");
INSERT INTO ruf_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Imunu wowose iyomlonga pfihile Imwana we Imunu katsolekelelighwa, lekeni imunu wowose iyomligha Ghumuhe ghwe Imulungu ng'atsolekelelighwa bae. ");
INSERT INTO ruf_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Hamtsoghalighwa mne tsing'anda tsa ukulombela, kwe iwatawala ne kwe iwakulu, mleke kupfuka chokulonga na chakwidika. ");
INSERT INTO ruf_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kwaapfila Ghumuhe ghwe Imulungu katsowalangulitsa chambamighwa kulonga.” ");
INSERT INTO ruf_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Imunu yumwe kulawa mne iwanu iwemile hala kamlongela Yesu, “Mlangulitsi, mlongele ndughu yangu twigholele ipfinu pfatuleke aba wetu.” ");
INSERT INTO ruf_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu kamwidika, “Sale yangu, angu yuhi yanyikile nene niwe mlamutsi au niwe mghola pfinu pfenu?” ");
INSERT INTO ruf_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Yesu kaghendelela kuwalongela wose, “Mwalangitse ne ubwa! Kwaapfila ughima we imunu ng'aulawa bae mna pfinu pfingi pfali napfo!” ");
INSERT INTO ruf_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Kuya Yesu kawalongela imbuli ino; “Tsahana imunu yumwe tajiri tsa yane na mghunda ghunoghile ghumwelekele pfijo pfingi. ");
INSERT INTO ruf_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Apfo kefikitsa mmoyo mwake, ‘Nahela hanu ha kwikila pfijo pfangu. Lelo nitendatse?’ ");
INSERT INTO ruf_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Kalonga, ‘Nitsotenda apfino; nitsotsimwagha kano tsangu na kutsenga tsingi ng'ulu ng'ani. Amo nitsakwika imitama yangu ne ipfinu pfangu pfingi. ");
INSERT INTO ruf_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Kuya nitselongela mwenyegho; 'Ghwe ghumoyo ghwangu! Kwinapfo ipfinu pfingi kwa miyaka mingi. Bwihila ghwe; uje, unwe na udeng'elele!’ ");
INSERT INTO ruf_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Lekeni Imulungu kamlongela imunu tajiri, ‘Kwambotsi ghweghwe! Chilo chichino ughima wako utsobamighwa! Pfinu pfawikile pfitsakuwa pfa nani?’ ” ");
INSERT INTO ruf_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yesu kalonga, “Apfi pfipfo pfapfitsakuwa kwe imunu wowose yeikile utajiri imwenyegho, lekeni ng'akwika bae utajiri kwe Imulungu.” ");
INSERT INTO ruf_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kuya Yesu kawalongela iwanang'ina wake, “Mleke kughaya na ukwalangula kwe ichijo chambama ili mkale waghima, au ghamaghwanda ghambama kwa ng'uli tsenu. ");
INSERT INTO ruf_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kwaapfila ughima unogha kubita ichijo na lukuli lunogha kubita maghwanda. ");
INSERT INTO ruf_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mlole iwabondwa; ng'awahanda bae wala, ng'awopfuna bae, wala wahela kano, lekeni Imulungu kowang'itsa! Mwemwe mnogha ng'ani kubita wapfideghe! ");
INSERT INTO ruf_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Apfi yuhi mna mwemwe kwa kwidununza kodaha kwongetsa litsuwa limwe mne ughima wake? ");
INSERT INTO ruf_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ka ng'amdaha bae kutenda chinu chidodo ka chino, ebali mwopfidununzikila pfinu pfingi? ");
INSERT INTO ruf_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Mlole ghamaluwa pfaghokula; ng'aghosang'ana bae wala ng'aghefoghosa bae. Lekeni nowalongela hata mndewa Selemani na tsimali tsake tsose ng'apfalile bae pfinoghile ka luwa limwe mne ghamaluwa ghano. ");
INSERT INTO ruf_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ka Imulungu koipfatsa imitsani ya kumghunda leloli lya baha, na ilupfi lyakwasighwa mmoto, apfi ng'atsowatendela mengi bae? Pfii mwemwe yamtoghola chidogho! ");
INSERT INTO ruf_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Mleke ukwalangula mtsakuja choni au mtsakunwa choni. ");
INSERT INTO ruf_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kwaapfila iwanu yang'awammanyile Imulungu wopfihamela ipfinu apfo. Na Aba wenu iyali kulanga komanya ipfinu pfambama. ");
INSERT INTO ruf_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Lekeni muubame undewa wake ne ipfinu pfino mtsakwing'ighwa. ");
INSERT INTO ruf_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Mwemwe wanang'ina wangu, mleke kupfuka, kwaapfila Aba wenu kanoghelwa kuweng'ani undewa. ");
INSERT INTO ruf_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Muutse ipfinu pfenu muweng'e tsisendi iwahingwa. Mwitendele imikoba yang'ailalagha bae, na mwike utajiri wenu kulanga, hanu hang'autsohunguka bae. Aho haduhu mbapfi iyodaha kwiba na haduhu mswa iyodaha kuuhinya. ");
INSERT INTO ruf_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kwaapfila hane utajiri wako, ghumoyo ghwako ghutsakuwa baho.” ");
INSERT INTO ruf_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Mwohe misipi mne pfuno pfenu, ne ipfitasa pfenu pfiwe pfakwaka. ");
INSERT INTO ruf_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Muwe ka watumwa iwombeta imkulu wawo iyakuya kulawa kune ichihungo cha kukwela. Hakuya na kugong'onda libani, baho wompfughulila. ");
INSERT INTO ruf_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Wabweda iwatumwa wala imkulu wawo hakuya kowapfika wameso. Nowalongela ghendo, imkulu ayo katseyoha msipi mchuno, katsokala nawo mchijo na kuwasang'anila. ");
INSERT INTO ruf_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Itsakuwa ghoya kwe iwatumwa wala imtwatsa wawo ka katsowapfika weyandaa, hata ang'oya nechilo ng'ani. ");
INSERT INTO ruf_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Lekeni mmanye apfino; Ka imunu yane ing'anda ang'amanyile lisaa atsakutsa mbapfi, ang'akalile meso. Wala tsang'oileka bae ing'anda yake ibenighwe ne mbapfi. ");
INSERT INTO ruf_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Pfipfila namwe mwobamighwa mwiyandae, kwaapfila Imwana we Imunu katsakutsa lisaa mwemwe ng'amumbetela.” ");
INSERT INTO ruf_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petiri kamghutsa, “Imtwatsa, apfi kwotulongela twetwe tuliyeka imbuli ino au kowalongela iwanu wose?” ");
INSERT INTO ruf_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Imtwatsa kamwidika, “Apfi yuhi imtumwa mwenyepfale na yane ihekima? Imtumwa yula imtwatsa wake yamwikile kuwatawala iwatumwa wangi, na kuweng'a ichijo chawo mne ichipindi chinoghile. ");
INSERT INTO ruf_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Itsakuwa ghoya kwe imtumwa yula imtwatsa wake hayatsokuya katsompfika kotenda apfo. ");
INSERT INTO ruf_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nowalongela ghendo, imkulu ayo katsomwika imtumwa yula kupfitawala ipfinu pfake pfose. ");
INSERT INTO ruf_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Lekeni imtumwa yula ang'elongela imwenyegho, ‘Imtwatsa wangu ng'atsakuya sambi bae’ kuya kakwandusa kuwatowa iwatumwa wose iwamale ne iwapinga, naye kakuja na ukunwa mbaka kopatika. ");
INSERT INTO ruf_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Imtwatsa we imtumwa yula katsakutsa mne litsuwa lila imtumwa ayo ng'olimanya bae na mne saa lila ng'alilolele bae, na mkulu ayo katsomghana imtumwa wake mne pfihindi pfili na kumwika hane iwanu iwalemile kutoghola. ");
INSERT INTO ruf_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Na imtumwa yula iyomanya aghala ghayobama imtwatsa wake aghatende, lekeni ng'okala ghoya bae wala ng'oghatenda bae, imtumwa ayo katsotohighwa ng'ani. ");
INSERT INTO ruf_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Lekeni imtumwa yula ng'amanyile bae ipfinu pfayabamighwe ne imkulu wake apfitende, naye katenda pfihile, imtumwa ayo katsotowighwa chidogho. Imunu wowose iyeng'ighwe pfingi, kuna yeye pfitsobamighwa pfingi. Na kwe imunu wowose iyeng'ighwe pfingi ng'ani pfitsobamighwa pfingi ng'ani kuna yeye. ");
INSERT INTO ruf_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Nitsa ukwasa ghumoto muisi, na tsanibama ma ghuwe ghutuwitsighwa! ");
INSERT INTO ruf_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ninawo ubatitso wa maghayo nobamighwa niubokele, na nene noghaya ng'ani mbaka umale! ");
INSERT INTO ruf_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Apfi mwopfikitsa nitsa kuitenda iisi ikale tseghamba? Bae! Sitsile kuwatenda iwanu wakale tseghamba, ila kuwaghola iwanu. ");
INSERT INTO ruf_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kulawa sambi iwanu watano wali mne kaye imwe watsesonga, wadatu kwa weli na weli kwa wadatu. ");
INSERT INTO ruf_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tsina tate watsesonga ne iwana wawo, ne iwana watsesonga na aba tsawo. Tsina mai watsesonga ne iwana wawo ne iwana watsesonga na mai tsawo. Mai wakwe watsesonga na wakamwana wawo, na wakamwana watsesonga na wakwe tsawo.” ");
INSERT INTO ruf_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu kawalongela iwanu, “Hamkwona liwingu lyakutsa ubali ukuswela litsuwa, baho mwolonga, imvula itsotowa, na kuya imvula yotowa. ");
INSERT INTO ruf_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Na hamkwona libeho kulawa ubali wa kuhisi, mwolonga, ‘Kutsakuwa na lijoto,’ na yakuwa pfipfo. ");
INSERT INTO ruf_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mwawang'enye! Mwodaha kulola muisi na mlanga na kulonga imvula itsotowa au litsuwa litsakwalika. Pfii ng'amdaha bae kughamanya matsuwa ghano gha sambi? ");
INSERT INTO ruf_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ebali mwemwe iwenyegho ng'amdaha bae kwilamlila chinu chihi ichinoghile? ");
INSERT INTO ruf_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ka imunu yane lighomba naghwe kokughala mne ing'anda ya kuhighila. Mnzila utende pfaudaha wighongole naye ng'ana wingile mne libalatsa. Ka si pfipfo bae, mlamutsi katsokughala kwa asikali, na asikali watsokwika mchifungo. ");
INSERT INTO ruf_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nokulongela, ng'autsolawa bae mbaka ulapfe sendi yako ya mwisho!” ");
INSERT INTO ruf_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ichipindi chichila tsahana iwanu iwampetele Yesu mbuli tsa Wagalilaya iwakomighwe na Pilato hawang'ali womlapfila Imulungu inambiko. ");
INSERT INTO ruf_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu kawedika, “Apfi mwemwe mwopfikitsa Wagalilaya wala tsawana nzambi kubita Wagalilaya wangi kwaapfila tsawadununzika pfino? ");
INSERT INTO ruf_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Bae! Nowalongela ka ng'amtsileka nzambi tsenu, pfipfila namwe mwose mtsakufa ka pfawapfile wao. ");
INSERT INTO ruf_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Kuya pfii iwanu wala kumi na wanane iwafile kwa chilingilo ichiwaghwile ako Siloamu? Apfi mwopfikitsa iwanu wala wakala na nzambi kubita iwanu wangi iwokala Yerusalemu? ");
INSERT INTO ruf_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Bae! Nowalongela ka ng'amtsileka nzambi tsenu, pfipfila namwe wose mtsakufa.” ");
INSERT INTO ruf_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Kuya Yesu kawalongela imbuli ino, “Tsakukala ne imunu yumwe yane mbiki wa matunda mne mghunda wake wa mitsabibu. Kaghenda kubama litunda mne mbiki awo, lekeni ng'apatile bae. ");
INSERT INTO ruf_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Apfo kamlongela mkalitsi wa mghunda aghwo, ‘Lola, kwa miyaka midatu tsaning'ali nikutsa hano kubama matunda mne mbiki ghuno, sipatile chinu bae. Ghughane! Ebali ghughendelele kulihinya lidongo?’ ");
INSERT INTO ruf_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Lekeni mkalitsi wa mghunda kamwidika, ‘Imtwatsa, ghuleke kwa ghumwaka ghuno ghumwe, na nene nitsoghuhimbila na kughwikila imboleya. ");
INSERT INTO ruf_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kuya ghung'eleka ghamatunda itsakuwa ghoya! Lekeni ka ng'aghutsakweleka, kutsoghughana.’ ” ");
INSERT INTO ruf_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Mna Litsuwa lya Sabato Yesu ang'ali yolangulitsa mne ing'anda ya ukulombela. ");
INSERT INTO ruf_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Baho tsahana ipinga yumwe yane ichinyamkela iyamtendile yaghule kwa miyaka kumi na nane. Tsakapfeduka na ng'adahile bae kwigholosa. ");
INSERT INTO ruf_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu hamwonile, kamkema, kamlongela, “Mai kuhonetsighwa utamu wako!” ");
INSERT INTO ruf_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Kuya Yesu kamwikila ghamoko ipinga ayo, bahala kagholoka na kamtunya Imulungu. ");
INSERT INTO ruf_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Imkulu we ing'anda ya ukulombela tsakona maya kwaapfila Yesu kamhonetsa mai ayo mne Litsuwa lya Sabato, apfo kawalongela iwanu, “Mwinagho ghamatsuwa sita gha kusang'ana. Mtse mna ghamatsuwa agho mhonetsighwe, mleke kutsa mne Litsuwa lya Sabato!” ");
INSERT INTO ruf_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Imtwatsa kedika, “Mwa wang'enye! Apfi yumwe wenu ng'odaha bae kumdohola ing'ombe au ipunda wake kulawa hanu ha ukujila mne Litsuwa lya Sabato na kumlongotsa aghende kunwa ghamatsi? ");
INSERT INTO ruf_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ipinga yuno kaimwana wa Abrahamu, iyaghoghighwe na Setani kwa miyaka kumi na nane. Lelo pfii ng'apfinoghile bae kumdohola mne Litsuwa lya Sabato?” ");
INSERT INTO ruf_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesu halongile apfi, iwehile wake tsawona chinyala, lekeni iwanu tsawang'ali wodeng'elela kwa ipfinu pfa kukangawatsa ipfitendighwe na Yesu. ");
INSERT INTO ruf_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Kuya Yesu kawaghutsa, “Apfi Undewa we Imulungu wighala na choni? Apfi nitumile imbuli yachi? ");
INSERT INTO ruf_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Wighala ne imbeghu ndodo ya haladali iyaisolile imunu yumwe na kuihanda kumghunda. Imbeghu ila ikula na kuwa mbiki mkulu, na iwapfideghe watsenga ipfibali mna ghamaputila ghake.” ");
INSERT INTO ruf_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesu kawaghutsa keli, “Apfi nitumile imbuli yachi mmanye Undewa we Imulungu? Wighalile na choni? ");
INSERT INTO ruf_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Wighala ne hamila iyaisolile ipinga yumwe na kaitipfa ne usaghe mwingi na usaghe wose usasuka.” ");
INSERT INTO ruf_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Kuya Yesu kaghendelela na ghumwanza ghwake kughenda Yerusalemu. Hayang'ali mnzila, kabitila mne imiji ne ipfijiji, kawalangulitsa iwanu ako. ");
INSERT INTO ruf_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Imunu yumwe kamghutsa Yesu, “Mtwatsa, apfi watsokombolighwa iwanu chidodo waliyeka?” Yesu kawedika, ");
INSERT INTO ruf_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Mtende pfamdaha kwingila mng'anda kubitila mne libani lisisili, kwaapfila iwanu wengi watsobama kwingila mng'anda lekeni ng'awatsodaha bae. ");
INSERT INTO ruf_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Imunu yane ing'anda katsakwima na kulihinda libani. Namwe mtsakwima kunze na ukwandusa kughong'onda libani na ukulonga, ‘Imtwatsa tupfughulile.’ Lekeni yeye katsowedika, ‘Siwamanyile bae kwamlawa kwani!’ ");
INSERT INTO ruf_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Kuya mtsomwidika, ‘Twetwe twa awala yatujile na ukunwa naghwe, na tsakutulangulitsa mne isi yetu!’ ");
INSERT INTO ruf_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Lekeni katsolonga keli, ‘Siwamanyile bae kwamlawa kwani. Laweni hano, mwemwe mwose yamtendile ghehile!’ ");
INSERT INTO ruf_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Mtsolila na kugheghedula ghamatsino hamtsomwona Abrahamu, Isaka, Yakobu ne manabii wose wamne undewa we Imulungu, lekeni mwemwe mwasighwa kunze! ");
INSERT INTO ruf_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Iwanu watsakutsa kulawa ubali wa kwalilawila litsua ne ubali wa kwalikuswela litsuwa, na kulawa ubali wa kuchanya na kuhisi, watsokala mne chihungo wakuja mne undewa we Imulungu. ");
INSERT INTO ruf_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Kuya iwanu iwawile wa usighilo watsakuwa wa mwanduso, ne iwanu iwawile wa mwanduso watsakuwa wa usighilo.” ");
INSERT INTO ruf_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Matsuwa ghaghala Mafarisayo wangi wamghendela Yesu, wamlongela, “Ughende hanu hangi kwaapfila Herodi kobama akukome.” ");
INSERT INTO ruf_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesu kawedika, “Mghende mumlongele ayu yumbwa wa kumuhulo, ‘Leloli na ilupfi nolapfa ipfinyamkela na kuwahonetsa iwanu, na mne litsuwa lya kadatu nitsomalitsa isang'ano yangu.’ ");
INSERT INTO ruf_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Hata apfo, nobamighwa leloli na ilupfi na ikacha nighendelele na ghumwanza ghwangu kwaapfila ng'apfinoghile bae nabii kukomighwa kunze kwa Yerusalemu! ");
INSERT INTO ruf_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Ghwe Yerusalemu! Ghwe Yerusalemu! Kwowakoma manabii na kuwatowa kwa ghamabwe iwatumwa we Imulungu iwatumighwe kuna ghweghwe! Mara nyingi tsambama kuwakunga iwanagho ka ng'uku pfowaghubika pfitsiya wake kwa ghamabawa ghake, lekeni ghweghwe ng'aubamile bae! ");
INSERT INTO ruf_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Mlole, mlekelighwa ing'anda yenu. Nowalongela, ng'amtsombona keli bae mbaka mlonge, ‘Kabalikiighwa ayula iyakutsa kwa taghwa lye Imtwatsa.’ ” ");
INSERT INTO ruf_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Litsuwa limwe lya Sabato, Yesu tsakaghenda kuja mne ing'anda ye imkulu wa Mafarisayo. Iwanu wang'ali wamlolesa ng'ani Yesu. ");
INSERT INTO ruf_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Imunu yapfimbile lukuli kaghenda hambele ha Yesu. ");
INSERT INTO ruf_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu kawaghutsa iwolangulitsa Ghamalaghitso na Mafarisayo, “Apfi pfinogha kumhonetsa imunu mne Litsuwa lya Sabato au ng'apfinoghile bae?” ");
INSERT INTO ruf_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Lekeni ng'awalongile chinu bae. Apfo Yesu kamkinda imtamu ayo, kamhonetsa, kamleka yoke. ");
INSERT INTO ruf_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Kuya Yesu kawaghutsa, “Ka yumwe wenu kana imwana au ing'ombe kaghwila mchisima mne Litsuwa lya Sabato, apfi ng'odaha bae kumkwegha alawe kunze?” ");
INSERT INTO ruf_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Lekeni ng'awadahile bae kumwidika. ");
INSERT INTO ruf_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu halolile iwahenza wangi pfawang'ali wosaghula ipfighoda ipfili hambele, kawalongelela wose imbuli ino, ");
INSERT INTO ruf_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ka imunu kakulongela utse mne ichihungo cha kukwela, uleke kukala mne ipfighoda pfa hambele. Kwaapfila imunu yungi mkulu kubita ghweghwe kodaha kutsa, ");
INSERT INTO ruf_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ne imunu iyawakemile wose mtse katsokutsila na kukulongela, ‘Winuke akale yuno.’ Kuya kutsakona ichinyala na kughenda kukala mne ipfighoda ipfili kuchughu. ");
INSERT INTO ruf_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Lekeni ghweghwe utende apfi, haupfika mne chihungo, ughende kukala mne ipfighoda ipfili kuchughu, ili mwenyekaye hatsakutsa yakulongele, ‘Sale yangu, winuke, utse ukale mne ipfighoda ipfili hambele.’ Kuya kutsotogholighwa ne iwanu wose iwakalile naghwe. ");
INSERT INTO ruf_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kwaapfila imunu wowose yetenda imwenyegho mkulu katsotendighwa mdodo, ne imunu wowose yetenda imwenyegho mdodo katsotendighwa mkulu.” ");
INSERT INTO ruf_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kuya Yesu kamlongela imunu yula iyamlongele atse, “Ka kwowatendela iwanu ichihungo, uleke kuwakema sale tsako au iwandughu tsako au iwanu matajiri iwali habehi naghwe. Ung'atenda apfi, nawo watsokukema ughende mmakaye mwawo, apfo watsokuliha ka ghweghwe pfauwatendele. ");
INSERT INTO ruf_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Lekeni ka kwotenda ichihungo, uwakeme wahingwa, pfimbete, iwanu waholole, na pfifita, ");
INSERT INTO ruf_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","naghwe kutsobalikiighwa, kwaapfila ng'awatsodaha bae kukuliha. Imulungu katsokuliha mne litsuwa lya kutsilihulighwa iwanu iwanoghile.” ");
INSERT INTO ruf_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Imunu yumwe iyakalile na Yesu haulike apfi, kamlongela Yesu, “Kabweda ghendo imunu yula yatsakuja ichijo che chihungo mne Undewa we Imulungu!” ");
INSERT INTO ruf_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesu kamwidika, “Imunu yumwe tsayang'ali yotenda chihungo chikulu, kawakema iwahenza wengi watse. ");
INSERT INTO ruf_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ichihungo hachipfikile, imunu yula kamtuma imtumwa wake kuwalongela iwanu iyawakemile watse, ‘Mtse, kwaapfila sambi chila ichinu chitandighwa.’ ");
INSERT INTO ruf_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Lekeni wose walema kupfika kwaapfila chila imunu tsakakala ne isang'ano yake. Imunu wa mwanduso kamlongela imtumwa ayo, ‘Nighula mghunda nobama nighende nikaghukaghule, Sikutsa bae.’ ");
INSERT INTO ruf_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Imunu yungi kalonga, ‘Nighula iwang'ombe kumi, sambi noghenda kuwaghetsa. Sikutsa bae.’ ");
INSERT INTO ruf_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Pfipfila imunu yungi naye kalonga, ‘Nikwela sambi, apfo sidaha kutsa bae.’ ");
INSERT INTO ruf_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Imtumwa yula koya ukaye kamlongela imtwatsa wake mbuli tsose. Hahulike apfo, yane kaye kaghudubuka kamlongela imtumwa wake, ‘Ghenda himahima mne ipfijiji ne kaye uwalongele wahingwa, iwanu iwaholole, pfifita na pfimbete watse.’ ");
INSERT INTO ruf_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Imtumwa ayo kalonga, ‘Mtwatsa, tsanenda ka pfaulaghitse, lekeni hanu ha kukala iwanu hang'ali habaho.’ ");
INSERT INTO ruf_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Apfo imtwatsa kamlongela imtumwa wake, ‘Ghenda mne tsinzila na mne ipfijiji uwalongele iwanu watse, ng'anda yangu imeme. ");
INSERT INTO ruf_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nowalongela, mne iwanu wose yaniwakemile watse, kuduhu hata yumwe yatsolanza ichijo che ichihungo changu!’ ” ");
INSERT INTO ruf_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Baho iwanu wengi tawelongotsa na Yesu, naye Yesu kawahundukila kawalongela, ");
INSERT INTO ruf_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ka imunu wowose konitsila na ng'omhila bae aba wake na mai wake, mwehe wake ne iwanaghe, iwandughu tsake na lumbu tsake na ng'ouhila bae ughima ghwake, ng'odaha bae kuwa mwanang'ina wangu. ");
INSERT INTO ruf_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Na imunu wowose yang'oduta msalaba ghwake na kuniwinza nene, ayo ng'odaha bae kuwa mwanang'ina wangu.” ");
INSERT INTO ruf_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Ka yumwe wenu kobama atsenge chilingilo, tanu kokala hasi kopeta sendi tsenatso, kulola kana sendi tsa kumalitsila isang'ano. ");
INSERT INTO ruf_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kwaapfila ka kandusa kutsenga ghumsingi, na ng'odaha bae kughumalitsila, iwanu wose iwolola chatendile watsomseka. ");
INSERT INTO ruf_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Kuya watsolonga, ‘Imunu yuno kandusa kutsenga lekeni ng'adahile bae kumalitsa isang'ano.’ ");
INSERT INTO ruf_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Ka mndewa koghenda ne iwanu miya imwe kwitowa na mndewa yungi yane iwanu elufu ishirini tanu katsokala hasi na ukwalangula ka kodaha kwitowa ne mndewa ayo. ");
INSERT INTO ruf_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ka ng'odaha bae, katsowatuma iwatumwa wake waghende kwa mndewa ayo hang'ali kutali wamlombe waleke kwitowa. ");
INSERT INTO ruf_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Pfipfila ka imunu ng'odaha bae kuleka chila chinu chenacho ng'odaha bae kuwa mwanang'ina wangu. ");
INSERT INTO ruf_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Imunyu inogha, lekeni ka ihinyika, apfi utsoitendatse inoghe keli? ");
INSERT INTO ruf_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ng'ainogha bae kuika mne mghunda wala kuitipfa ne imboleya, itsakwasighwa. Imunu yane ghamaghutwi gho kuhulika, yahulike!” ");
INSERT INTO ruf_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Litsuwa limwe iwasola kodi na wane nzambi wamghendela Yesu kumhulikitsa. ");
INSERT INTO ruf_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Lekeni Mafarisayo na iwolangulitsa Ghamalaghitso wandusa kwilongela, “Imunu yuno kawabokelagha iwanu wane nzambi na kuja nawo!” ");
INSERT INTO ruf_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Kuya Yesu kawalongela imbuli ino. ");
INSERT INTO ruf_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Imunu wachi mna mwemwe yane iwang'olo miya imwe na ng'olo wake yumwe ang'agha, apfi ng'atsowaleka bae wala tisini na tisa akula koyodimila na kughenda kumbama yula yaghile mbaka amwone? ");
INSERT INTO ruf_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Na hayomwona katsodeng'elela na kumwika mmahegha mwake, ");
INSERT INTO ruf_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","na kumghala ukaye. Kuya katsowakema sale tsake ne iwanu iwali habehi naye na kulonga, ‘Mdeng'e na nene, kwaapfila nimwona ing'olo wangu yaghile.’ ");
INSERT INTO ruf_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Pfipfila nowalongela kutsakuwa na ndeng'elo ng'ulu kulanga kwe imunu yumwe yane nzambi kutsileka nzambi tsake kubita iwanu wala tisini na tisa iwebona wanogha aku ng'awobama bae kutsileka nzambi tsawo.” ");
INSERT INTO ruf_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Au ka ipinga kana sendi kumi, na sendi imwe yagha. Apfi ng'atsotuwa bae ichitasa, na kusegha ing'anda yake na kuibama chila hanu mbaka ayone? ");
INSERT INTO ruf_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Na hayatsoyona sendi ila, katsowakema sale tsake ne iwanu iwali habehi naye na kuwalongela, ‘Mdeng'e na nene kwaapfila niyona sendi yangu yaghile!’ ");
INSERT INTO ruf_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Pfipfila nowalongela, malaika we Imulungu watsodeng'elela kwe imunu yumwe yane nzambi kutsileka nzambi tsake.” ");
INSERT INTO ruf_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu kaghendelela kuwalongela, “Tsakukala ne imunu yumwe yawile ne iwana weli. ");
INSERT INTO ruf_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Imwana mdodo kamlongela aba wake, ‘Aba, ungolele pfinu pfutsongaya.’ Apfo aba kawagholela ipfinu pfake. ");
INSERT INTO ruf_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ghamatsuwa chidogho hambele, imwana mdodo kautsa ipfinu pfake. Kuya koka ukaye yawo, kaghenda isi ya kutali, ako katsipwilisa sendi tsake kwa pfinu pfihile. ");
INSERT INTO ruf_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Sendi tsake hatsimalile, inzala ng'ulu ilawila mna isi ila yose, naye kakala kahela ichinu. ");
INSERT INTO ruf_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Apfo kaghenda kulomba isang'ano kwe imunu we isi ila, imunu yula kamlaghitsa aghende mne mghunda ghwake akadime wangubi. ");
INSERT INTO ruf_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Tsakasulukila kuja imibangu yawajile iwangubi, lekeni kuduhu imunu yamwing'ile ichijo. ");
INSERT INTO ruf_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Tsimbutsi tsake hatsimuyile, keghutsa imwenyegho, ‘Aba wangu kana iwanu wengi we isang'ano iwakuja na kuleka ichijo, na nene nahano noghanzika kwe inzala! ");
INSERT INTO ruf_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nitsakwinuka na kuya kwa aba wangu na kumlongela, Aba, nimtendela Imulungu nzambi, na pfipfila nikutendela ghweghwe nzambi.’ ");
INSERT INTO ruf_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Sibamighwa bae kukemighwa imwanagho, unende niwe ka yumwe we iwanu wako we isang'ano.” ");
INSERT INTO ruf_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Apfo kenuka koya kwa aba wake. “Lekeni hang'ali kakutali, aba wake kamwona kamwonela libatsi; kamtsumila imwanaghe, kamkumbatila, na kamnonela. ");
INSERT INTO ruf_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Imwana kamlongela aba wake, ‘Aba wangu, nimtendela nzambi Imulungu na ghweghwe pfipfila. Sibamighwa bae kukemighwa mwanagho.’ ");
INSERT INTO ruf_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Lekeni aba wake kawakema iwatumwa wake kawalongela, ‘Himahima! Mghalileni gholole linoghile mumpfatse. Na ipete mna ichidole chake ne imikwabatsa mmaghulu mwake. ");
INSERT INTO ruf_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Mumghale imwana we ing'ombe yanenehe. Leka tutende ichihungo na tudeng'elele. ");
INSERT INTO ruf_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kwaapfila imwanangu tsakafa, lekeni sambi kamghima, tsakagha, lekeni sambi koneka.’ Apfo wandusa kudeng'elela. ");
INSERT INTO ruf_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ichihungo haching'ali chighendelela, imwanaghe mbala tsaka kumghunda. Hapfikile habehi ne ing'anda, kahulika tsingoma ne iwanu wobigha. ");
INSERT INTO ruf_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Apfo kamkema imtumwa yumwe, kamghutsa, ‘Angu hano hana choni?’ ");
INSERT INTO ruf_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Imtumwa ayo kamwidika, ‘Mdodo wako koya ukaye aba wako kamkomela imwana we ing'ombe yanenehe kwaapfila koya mghima!’ ");
INSERT INTO ruf_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Imwana imbala kaghudubuka, kalema kwingila mng'anda. Apfo Aba wake kalawa kunze kamlomba engile mng'anda. ");
INSERT INTO ruf_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Lekeni kamwidika aba wake, ‘Lola, nikusang'anila miyaka yose ino na silemile bae aghala ghaundaghitse nitenda. Lekeni ng'ungaile bae hata imwana we imene nideng'elele sale tsangu! ");
INSERT INTO ruf_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Lekeni imwanagho ayu kahondola mali tsako na mapinga pfiweghe, na hoile ghweghwe kumkomela imwana we ing'ombe yanenehe!’ ");
INSERT INTO ruf_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Aba wake kamwidika, ‘Mwanangu, matsuwa ghose ghweghwe kwa hamwe na nene, ne ipfinu pfose pfaninapfo pfako. ");
INSERT INTO ruf_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Lekeni twobamighwa tudeng'elele na kusekelela, kwaapfila mdodo wako tsakafa, lekeni sambi kamghima; tsakagha, lekeni sambi koneka’ ” ");
INSERT INTO ruf_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu kawalongela iwanang'ina wake, “Tsahana imunu yumwe yane mali nyingi, naye tsakana mtunza mali wake. Imunu ayo tsakahulika ka mtunza mali wake kapwililitsa mali tsake hela. ");
INSERT INTO ruf_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Apfo kamkema mng'anda kamghutsa, ‘Angu mbuli tsachi tsanihulike tsikulonga ghweghwe? Nipetele ipfinu pfose pfubokele na pfulapfile, kwaapfila ng'udaha bae kuwa keli mtunza mali wangu.’ ");
INSERT INTO ruf_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Mtunza mali kelongela mmoyo, ‘Mtwatsa wangu katsoniwinga mne isang'ano. Apfi nitsotendatse? Nahela ingupfu ya kulima, na nakwona chinyala kulomba. ");
INSERT INTO ruf_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Sambi nomanya chinu chachi chanitsotenda ili hanitsowingighwa mne isang'ano yangu, iwanu wanibokele mmakaye mwawo.’ ");
INSERT INTO ruf_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Apfo kawakema iwanu wose iwodahighwa na imtwatsa wake. Kamghutsa ayula yalongole kutsa, ‘Apfi, mtwatsa wangu yokudahi sendi ngapi?’ ");
INSERT INTO ruf_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Kamwidika, ‘Pfiya miya imwe pfa ghamafuta gha tsaituni.’ Mtunza mali ayo kamlongela, ‘Sola cheti chako, kala hasi, wandike pfiya miya tano.’ ");
INSERT INTO ruf_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Kuya kamghutsa imunu wa keli, ‘Naghwe, udahighwa choni?’ Kamwidika, ‘Maghuniya elufu imwe gha ngano.’ Mwimilitsi kamlongela, ‘Sola cheti chako wandike maghuniya miya nane.’ ");
INSERT INTO ruf_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Imtwatsa kamtunya mtunza mali yula yehile kwaapfila katenda ipfinu kwa kukengela. Kwaapfila iwanu iwali mne isi ino wakengela mna kutenda ipfinu pfawo kubita iwanu iwali mne ghumwanga.” ");
INSERT INTO ruf_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Nowalongela, mtsitendele tsimali itsili muisi kwipatila sale tsenu wenyegho, ili hatsitsomala, mbokelighwe nawo mne chibumbulika cha ghamatsuwa ghose. ");
INSERT INTO ruf_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Imunu wowose iyotogholighwa mne ichinu chidodo katsotogholighwa mne ichinu chikulu, ne imunu wowose yang'atogholighwa mne ichinu chidodo pfipfila ng'atsotogholighwa bae mne ichinu ichikulu. ");
INSERT INTO ruf_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kuya ka ng'amtogholighwe bae kwika tsimali tsili mne isi, apfi yuhi iyatsowatoghola kwika tsimali tsa kweli? ");
INSERT INTO ruf_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ka ng'amtogholighwe bae mna tsimali tse imunu yungi, yuhi yatsoweng'a mwemwe tsimali tsenu iwenyegho? ");
INSERT INTO ruf_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Kuduhu imtumwa iyodaha kuwasang'anila iwatwa weli. Kwaapfila katsomwihila yumwe na kumnoghela yungi; katsolunga na yumwe na kumbetsa yungi. Ng'amdaha bae kumtumikila Imulungu na sendi.” ");
INSERT INTO ruf_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Mafarisayo iwonoghela tsisendi hawahulike apfo, tsawambetsa Yesu. ");
INSERT INTO ruf_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesu kawalongela, “Mwemwe mwelangusa kwe iwanu mnogha, lekeni Imulungu koimanya imimoyo yenu. Kwaapfila ichinu ichikwoneka chinogha kwe iwanu, kwe Imulungu chakoneka chiha. ");
INSERT INTO ruf_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Ghamalaghitso gha Musa na mbuli tsa manabii tsipetighwa mbaka mne ichipindi cha Yohane Mbatitsa. Kulawa ichipindi acho, mbuli tsinoghile tse Undewa we Imulungu tsipetighwa, na chila imunu kakwingila kwe ingupfu. ");
INSERT INTO ruf_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Pfibewe kwe ililanga ne isi ukwagha, kubita kuhunguka ichinu chidodo mne Ghamalaghitso. ");
INSERT INTO ruf_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Immale wowose iyomleka mwehe wake na kumkwela ipinga yungi kotenda utsinzi, ne immale iyomkwela ipinga iyalekighwe kotenda utsinzi.” ");
INSERT INTO ruf_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Tsahana imunu yumwe tajiri yang'ali yopfala maghwanda gha tsambalau ighaghulighwe kwa sendi nyingi, chila litsuwa yeye yang'ali yohondola pfijo pfinoghile. ");
INSERT INTO ruf_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Hane ha libani lyake likulu, tsakekighwa imunu yumwe mhingwa yakemighwe Lazali yane ipfilonda pfingi, ");
INSERT INTO ruf_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","yabamile kuja ipfijo ipfilaghale kulawa mmetsa mwe tajiri. Na iwambwa wamghendela wamlambita ipfilonda pfake. ");
INSERT INTO ruf_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Hambele, Lazali kafa kuya kasolighwa ne wamalaika mbaka mmambagha mwa Abrahamu. Imunu tajiri pfipfila naye kafa kuya katsikighwa. ");
INSERT INTO ruf_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Akula kutsimu, ang'ali yodununzika ng'ani, kalola kuchanya, kamwona Abrahamu kwa kutali hamwe na Lazali iyakalile mmambagha mwake. ");
INSERT INTO ruf_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Apfo kamkema kwa ukukemelela, ‘Aba Abrahamu, mbonele libatsi! Umtume Lazali achike ichidole chake mne ghamatsi aluhotse lulimi lwangu, kwaapfila nene namne usungu mkulu mne ghumoto ghuno!’ ” ");
INSERT INTO ruf_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Lekeni Abrahamu kamwidika, ‘Wikumbuke mwanangu, mne ughima wako tsakubokela apfila ipfinoghile na Lazali tsakabokela ipfihile. Lekeni sambi Lazali kabahano kodeng'elela, naghwe kwodununzika. ");
INSERT INTO ruf_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Hata apfo, mghati mwetu na mwemwe kwikighwa kolongo kulu, ili imunu iyobama kuloka kulawa kuno kutsa kuna mwemwe aleke kudaha, pfipfila kuduhu imunu iyodaha kuloka kulawa kuna mwemwe kutsa kuna twetwe!’ ");
INSERT INTO ruf_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Imunu tajiri kalonga, ‘Kuya nokulomba aba wangu, umtume Lazali aghende mne kaye ya aba wangu, ");
INSERT INTO ruf_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","amo mna ndughu tsangu watano. Mlekelele aghende akawalongele waleke kutenda ka pfanitendile, ili waleke kutsa hanu hano ha kudununzika.’ ” ");
INSERT INTO ruf_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Abrahamu kamwidika, ‘Ndughu tsako wenao Musa na manabii, leka wawategheletse wawo.’ ");
INSERT INTO ruf_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Tajiri kalonga, ‘Bae aba wangu. Lekeni ka imunu yatsilihuke kowaghendela, watsotsileka nzambi.’ ");
INSERT INTO ruf_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abrahamu kamlongela, ‘Ka ng'awowategheletsa Musa na manabii, ng'awatsotegheletsa hata ang'atsilihuka imunu.’ ” ");
INSERT INTO ruf_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Kuya, Yesu kawalongela iwanang'ina wake, “Pfitsolawila ghendo ipfinu ipfimuhonza imunu atende nzambi, lekeni katsoghaya imunu yula yatsotenda pfilawile. ");
INSERT INTO ruf_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ing'awile ng'apfu kwe imunu ayo yohighwe libwe lya kusaghila msingo na yasighwe mne ibahali, kubita kumtenda yumwe we iwadodo wano atende nzambi. ");
INSERT INTO ruf_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Mwalangitse! Ka ndughu yako kakutendela ghehile, umlonge, ang'atoghola totso lyake, umlekelele. ");
INSERT INTO ruf_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ang'akutendela ghehile mala saba kwa tsuwa limwe, na ang'akutsila mala saba na kukulongela, ‘Nileka,’ naghwe mlekelele.” ");
INSERT INTO ruf_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Iwatumighwa wamlongela Imtwatsa, “Utwongetsele ukutoghola.” ");
INSERT INTO ruf_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Imtwatsa kalonga, “Ukutoghola kwenu kung'awile kudodo ka imbeghu ya haladali, mng'adahile kughulongela mbiki ghuno ghwa mkuyu; ‘Ng'oka, wikehande mwibahali!’ naghwo ghung'awahulikitse.” ");
INSERT INTO ruf_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Tulonge yumwe wenu kana imtumwa iyolima kumghunda au iyodima iwang'olo. Apfi hayakuya kulawa kumghunda, katsomlongela imtumwa ayo, ‘Utse tanu, ukale hasi, uje ichijo?’ ");
INSERT INTO ruf_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Bae! Katsomlongela, ‘Nyambikile ichijo, na wanduse kunisang'anila mbaka hanitsomalitsa kuja na kunwa, kuya naghwe uje na unwe!’ ");
INSERT INTO ruf_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Apfi kutsomlongela mighede imtumwa ayo kwaapfila katenda aghala ghalaghitsighwe? ");
INSERT INTO ruf_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Pfipfila namwe mng'amalitsa kutenda chila chinu chambamighwe kutenda, mwobamighwa kulonga, ‘Twetwe twa iwatumwa iwali si chinu bae. Tutenda pfatubamighwa kutenda.’ ” ");
INSERT INTO ruf_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu hang'ali kamnzila koghenda Yerusalemu, kabitila mghati mwa Samariya na Galilaya. ");
INSERT INTO ruf_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Hang'ali yakwingila mne ichijiji chimwe, tsaketingana ne iwakoma kumi, wema kutali. ");
INSERT INTO ruf_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Wakemelela, “Yesu, Imtwatsa, twonele libatsi!” ");
INSERT INTO ruf_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Hawonile kawalongela, “Mghende mkelanguse kwa wakulu we inambiko.” Hawang'ali woghenda, tsawahona. ");
INSERT INTO ruf_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Yumwe mna wawo honile kahona, koya kuchughu, aku komtunya Imulungu kwa kukemelela. ");
INSERT INTO ruf_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Keghwisa hasi hane maghulu gha Yesu kamlongela mighede. Ayo tsakakala Msamariya. ");
INSERT INTO ruf_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu kalonga, “Apfi si iwanu kumi bae iwahonile? Lelo awala tisa walikwani? ");
INSERT INTO ruf_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ng'oneke yungi iyoyile na kumtunya Imulungu ila imhenza ayu aliyeka?” ");
INSERT INTO ruf_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Kuya Yesu kamlongela imunu ayo, “Winuke uke, Ukutoghola kwako kukuhonetsa!” ");
INSERT INTO ruf_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Mafarisayo hawamghutsile Yesu, Undewa we Imulungu utsakutsa tsuwachi, kawedika, “Undewa we Imulungu ng'aukutsa kwa kwoneka kwa tsinenge bae. ");
INSERT INTO ruf_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kuduhu imunu iyatsodaha kulonga, ‘Wa hano au wa hala.’ Kwaapfila Undewa we Imulungu wa mghati mwenu.” ");
INSERT INTO ruf_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Kuya kawalongela iwanang'ina wake, “Ghamatsuwa ghakutsa mtsobama kwona litsuwa limwe lya ghamatsuwa ghe Imwana we Imunu, lekeni ng'amtsolyona bae. ");
INSERT INTO ruf_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Na iwanu watsowalongela, ‘Mlole, kahala!’ Au ‘Mlole kahano!’ Lekeni mwemwe mleke kuwawinza. ");
INSERT INTO ruf_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kwaapfila ka lumwesa pfalulawila kulanga na kumwemwesa ubali umwe mbaka ubali ungi, apfo pfipfo Imwana we Imunu pfatsakuwa mne litsuwa lyake. ");
INSERT INTO ruf_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Lekeni tanu yadununzike ng'ani na kulemighwa ne iwanu wa mweleko ghuno. ");
INSERT INTO ruf_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Na ka pfaiwile mne ghamatsuwa gha Nuhu, pfipfila itsakuwa pfipfo mne ghamatsuwa ghe Imwana we Imunu. ");
INSERT INTO ruf_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Iwanu tsawaghendelela kuja na kunwa, kukwela na kukwelighwa mbaka Nuhu hengile mne safina. Kuya mafuriko ghatsa na kuwakoma wose. ");
INSERT INTO ruf_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Itsakuwa pfipfo ka pfailawile mne ghamatsuwa gha Lutu. Iwanu tsawaghendelela kuja na kunwa, kughula na kuutsa, kuhanda tsimbeghu na kutsenga. ");
INSERT INTO ruf_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lekeni litsuwa lila Lutu hokile Sodoma, ghumoto na ghamabwe igholakatsa ghalaghala hasi kulawa kulanga na kuwalakatsa wose. ");
INSERT INTO ruf_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Itsakuwa pfipfo mne litsuwa lila Imwana we Imunu hatsoghubulighwa.” ");
INSERT INTO ruf_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Mna litsuwa alyo, imunu iyali mchiswili aku ipfinu pfake pfa mng'anda, aleke kuhulumka kupfisola, pfipfila iyali kumghunda aleke kuya kuchughu. ");
INSERT INTO ruf_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mkumbuke ighampatile mwehe wa Lutu. ");
INSERT INTO ruf_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Imunu wowose iyobama kuukombola ughima wake katsowaghisa, na wowose iyowaghisa ughima wake, katsoukombola. ");
INSERT INTO ruf_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nowalongela, litsuwa alyo nechilo iwanu weli watsowasa hamwe, yumwe katsosolighwa na yungi katsolekighwa.” ");
INSERT INTO ruf_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Iwapinga weli watsotwanga hamwe, yumwe katsosolighwa na yungi katsolekighwa. ");
INSERT INTO ruf_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Iwanu weli watsakuwa kumghunda, yumwe katsosolighwa, na yungi katsolekighwa. ");
INSERT INTO ruf_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Baho iwanang'ina wake wamghutsa, “Kwani Mtwatsa?” Naye kawedika, “Hane ghumtsogha, maghengele watsetinganila baho.” ");
INSERT INTO ruf_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Kuya Yesu kawapetela iwanang'ina wake imbuli kuwalangulitsa ka wobamighwa kulomba matsuwa ghose, waleke kwipfa. ");
INSERT INTO ruf_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Kalonga, “Mne ghumji ghumwe tsakukala na mlamutsi, ayo ng'ampfukile bae Imulungu wala ng'awanoghele iwanu bae. ");
INSERT INTO ruf_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Pfipfila tsakukala ne chitsuka yumwe mne ghumji agho iyang'ali yomghendelagha kumlomba bila kwipfa mlamutsi ayo, ‘Utulamle nene na mwihile wangu.’ ");
INSERT INTO ruf_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Kwa matsuwa mengi mlamutsi ayo kalema kumwapfila chitsuka ayo. Lekeni hambele kalonga, ‘Hata ka nene simpfuka bae Imulungu wala siwanoghela iwanu bae, ");
INSERT INTO ruf_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","lekeni kwaapfila chitsuka ayu konitsupfa, nitsomlamulila, hela koghendelela kunitsila na kunenda nyipfe!’ ” ");
INSERT INTO ruf_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Kuya Imtwatsa kaghendelela kulonga, “Muhulikitse pfalongile mlamutsi ayu yehile. ");
INSERT INTO ruf_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Pfii lelo Imulungu ng'atsowalamulila bae iwanu wala iyawasaghule, iwomlilila chilo na misi? Apfi katsokawa kuwapfila? ");
INSERT INTO ruf_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nowalongela katsowapfila hima! Hata apfo Imwana we Imunu hatsakutsa, apfi katsopfika iwanu wotoghola mne iisi?” ");
INSERT INTO ruf_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Kuya Yesu kawalongela imbuli ino iwanu wala iweghoda na kuwabetsa wangi. ");
INSERT INTO ruf_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Iwanu weli waghenda kune ing'anda ye Imulungu kulomba. Yumwe Mfarisayo na yungi imunu iyosola kodi. ");
INSERT INTO ruf_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ayo Mfarisayo kema, kalomba mne ghumoyo ghwake, ‘Mighede, Ghwe Imulungu, kwaapfila nene si ka iwanu wangi bae, iwoboka, iwotenda ghehile, watsinzi, wala si ka ayu msola kodi. ");
INSERT INTO ruf_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nene noleka ukuja ghamatsuwa meli mne ghamatsuwa saba, nolapfa tsaka ye ipfinu pfose pfanipata!’ ");
INSERT INTO ruf_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Lekeni ayula msola kodi kema kutali, wala ng'alolile bae kulanga. Lekeni ketowa mmambagha mwake kwa usungu, kalonga, ‘Ghwe Imulungu, umbonele libatsi, nene mtenda ghehile.’ ” ");
INSERT INTO ruf_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nowalongela, “Ayu msola kodi koka ukaye yake akuno katogholighwa ne Imulungu kubita ayula yungi. Kwaapfila imunu wowose yetenda imwenyegho mkulu katsotendighwa mdodo, na imunu wowose yetenda imwenyegho mdodo katsotendighwa mkulu.” ");
INSERT INTO ruf_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Iwanu tsawamghalila Yesu iwana wadodo awekile ghamoko. Iwanang'ina wake hawonile apfi, wawakembela. ");
INSERT INTO ruf_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Lekeni Yesu kawakema iwana wamghendele, kalonga, “Muwaleke iwana wadodo wanitsile, mleke kuwaghoma. Kwaapfila undewa we Imulungu wa iwanu ka wano. ");
INSERT INTO ruf_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nowalongela ghendo, imunu wowose yang'aubokela undewa we Imulungu ka imwana mdodo, ng'atsakwingila bae mne undewa awo.” ");
INSERT INTO ruf_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Na mkulu yumwe wa Chiyahudi kamghutsa Yesu, “Mlangulitsi yunoghile, nitende choni ili nidahe kupata ughima wa matsuwa ghose?” ");
INSERT INTO ruf_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu kamghutsa, “Mbona kwonikema ninogha? Kuduhu yanoghile lekeni Imulungu aliyeka. ");
INSERT INTO ruf_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Kwoghamanya ghamalaghitso. ‘Uleke utsinzi, uleke kukoma, uleke kulonga ughutsu, wategheletse aba wako na mai wako.’ ” ");
INSERT INTO ruf_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Kamwidika, “Agho ghose nighakinda kulawa udodo wangu.” ");
INSERT INTO ruf_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu haulike apfo kamlongela, “Kuhungukighwa na ichinu chimwe. Utsa pfose pfawinapfo na sendi uwagholele wahingwa, naghwe kutsakuwa na utajiri kulanga. Kuya utse uniwinze.” ");
INSERT INTO ruf_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Lekeni imunu ayo haulike apfi, kwona usungu ng'ani kwaapfila tsakakala tajiri ng'ani. ");
INSERT INTO ruf_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu hamwonile kakona usungu, kalonga, “Pfikomu ng'ani kwa matajiri kwingila mne undewa we Imulungu! ");
INSERT INTO ruf_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kwaapfila pfibewe kwa ngamiya kwingila mne litobo lye isindano kubita tajiri kwingila mne undewa we Imulungu!” ");
INSERT INTO ruf_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Awala iwahulike apfo waghutsa, “Lelo yuhi yodaha kukombolighwa?” ");
INSERT INTO ruf_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu kedika, “Ichinu ing'achidahika kwe iwanu, kwe Imulungu chodahika.” ");
INSERT INTO ruf_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Kuya Petiri kalonga, “Lola! Twetwe tupfileka ipfinu pfetu pfose twokuwinza ghweghwe.” ");
INSERT INTO ruf_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu kawalongela, “Nowalongela ghendo, imunu wowose iyalekile ing'anda yake au mwehe wake au iwandughu tsake au iwamweleke au iwanaghe kwaajili ya undewa we Imulungu, ");
INSERT INTO ruf_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","katsobokela pfingi mna matsuwa agha, na ughima wa matsuwa ghose mne chipindi ichikutsa.” ");
INSERT INTO ruf_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu tsakawasola awala kumi na weli kawalongela, “Mlole! Twoghenda Yerusalemu, na chila chinu chandikighwe na manabii che Imwana we Imunu chitsolawila. ");
INSERT INTO ruf_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kwaapfila katsakwikighwa mne ghamoko ghe iwanu iwali si Wayahudi bae. Nawo watsombetsa, watsomligha, watsombwalulila ghamate, ");
INSERT INTO ruf_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","watsomfapula pfiboko, kuya watsomkoma. Mne litsuwa lya kadatu katsotsilihuka.” ");
INSERT INTO ruf_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Lekeni iwanang'ina ng'awamanyile bae ichinu acho. Tsawapfisighwa mana ye imbuli ayo, na ng'awatangile ighalongighwe. ");
INSERT INTO ruf_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu hapfikile habehi na Yeriko, imunu yumwe ichifita tsakakala mmbalimbali mwe inzila kolomba. ");
INSERT INTO ruf_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Haulike iwanu wobita, kaghutsa, “kuna choni?” ");
INSERT INTO ruf_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Wamlongela, “Yesu wa Natsareti kobita.” ");
INSERT INTO ruf_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Naye kakemelela, “Yesu, Mtsukulu wa Daudi, mbonele libatsi!” ");
INSERT INTO ruf_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Wanu wala iwalongole wamkembela wamlongela anyamale, lekeni yeye kaghendelela kukemelela, “Mtsukulu wa Daudi, mbonele libatsi!” ");
INSERT INTO ruf_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesu kema kalaghitsa wamghale imunu ayo hana yeye. Hapfikile habehi, Yesu kamghutsa, ");
INSERT INTO ruf_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Kwobama nikutendele choni?” Kedika, “Imtwatsa, nobama mbone.” ");
INSERT INTO ruf_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu kamlongela, “Wone! Kutoghola kwako kukuhonetsa!” ");
INSERT INTO ruf_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Bahala ichifita ayo kadaha kona, kamuwinza Yesu, aku komtunya Imulungu. Iwanu wose hawonile apfo, nawo pfipfila wamtunya Imulungu. ");
INSERT INTO ruf_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu tsakengila mne ghumji ghwa Yeriko na yang'ali yobita mghati mwa ghumji agho. ");
INSERT INTO ruf_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Na ako kukala ne imunu yumwe taghwa lyake Sakayo, imkulu we iwasola kodi, naye tsakakala tajiri. ");
INSERT INTO ruf_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Tsakabama amwone Yesu yalitse, lekeni ng'adahile bae kwaapfila tsahana iwanu wengi, naye tsakakala mghuyi. ");
INSERT INTO ruf_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Apfo katsuma, kawalongolela iwanu, kadina mchanya mwe mkuyu ili amwone Yesu, kwaapfila katsobitila inzila iila. ");
INSERT INTO ruf_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesu hapfikile hanu hala, kalola mchanya, kamlongela Sakayo, “Sakayo, hima uhulumke, kwaapfila leloli nobamighwa nisinde mng'anda mwako.” ");
INSERT INTO ruf_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Apfo Sakayo kuhulumka himahima kambokela kwa kudeng'elela. ");
INSERT INTO ruf_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Iwanu wose hawonile apfo, wandusa kunung'unika na ukulonga, “Kaghenda kukala kwa ‘imunu yane nzambi.’ ” ");
INSERT INTO ruf_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Lekeni Sakayo kema, kamlongela Yesu, “Lola Imtwatsa, nene nitsoweng'a wahingwa inusu ye ipfinu pfangu, na ka nimboka imunu wowose ichinu, nitsomuyitsila mala nne.” ");
INSERT INTO ruf_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu kamlongela, “Leloli ukombotsi upfika mne ing'anda ino, kwaapfila ayu naye kamtsukulu wa Abrahamu. ");
INSERT INTO ruf_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Mana Imwana wa Imunu katsa kubama na kukombola iwanu iwaghile.” ");
INSERT INTO ruf_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Hawahulike agho, Yesu kaghendelela kuwalongela imbuli, kwaapfila tsakakala habehi na Yerusalemu, nawo tsawapfikitsa ka undewa we Imulungu wahabehi kulawila. ");
INSERT INTO ruf_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Apfo kalonga, “Imunu yumwe wa lukolo lwa chindewa tsakaghenda mne isi ya kutali akabokele undewa kuya yoye ukaye. ");
INSERT INTO ruf_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Apfo kawakema iwanu kumi kulawa mne iwatumwa wake, kaweng'a tsisendi kawalongela, ‘Mtsitendele ng'onde ya kuchuutsa pfinu mbaka hanitsakuya.’ ");
INSERT INTO ruf_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Lekeni iwanu wa ghumji ghwake wamuhila, wawatuma iwanu wamghendele wakalonge, ‘Ng'atumbama bae imunu yuno atutawale.’ ” ");
INSERT INTO ruf_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Haubokele undewa, tsakoya kalaghitsa iwatumwa yaweng'ile sendi wakemighwe ili amanye chawapatile. ");
INSERT INTO ruf_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Wamwanduso katsa, kalonga, ‘Mtwatsa sendi yako yungayile yeleka pfibughulu kumi.’ ");
INSERT INTO ruf_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Kamlongela, ‘Ghoya, mtumwa yunoghile. Kwaapfila kutogholighwa mna chinu chidodo, kwakuwa mkulu mne imiji kumi!’ ");
INSERT INTO ruf_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Na wa keli katsa, kalonga, ‘Mndewa, sendi yako tsungayile tseleka pfibughulu pfitano!’ ");
INSERT INTO ruf_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Naye kamlongela, ‘Naghwe kutsakuwa mkulu mne imiji mitano.’ ");
INSERT INTO ruf_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Kuya mtumwa yungi kalonga, ‘Mtwatsa, sendi yako ino tsaniifidika mne chitambala. ");
INSERT INTO ruf_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mana tsanikupfuka kwaapfila ghweghwe kwa imunu mkali. Kosola ipfinu pfang'upfikile, na kupfuna achila ng'auchihandile bae.’ ");
INSERT INTO ruf_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Mtwatsa wake kamlongela, ‘Nitsokuhigha kwa achila chulongile, ghwe imtumwa wihile! Tsakumanya nene ne imunu mkali, nosola apfila si pfikile bae na nopfuna apfila sipfihandile bae, ");
INSERT INTO ruf_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ebali ng'awikile bae sendi yangu kubengi, na hanikuya niibokele kuno yongetseka.’ ");
INSERT INTO ruf_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Kuya kawalongela iwemile habehi, ‘Mbokeni sendi ayo, mkamwing'e yula yane kumi.’ ");
INSERT INTO ruf_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Nawo wamlongela, ‘Mtwatsa, ma kenatso kumi!’ ");
INSERT INTO ruf_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Naye kawedika, ‘Nowalongela chila yane chinu katsakongetsighwa, lekeni ayula yalihela chinu, hata chila chenacho katsobokighwa. ");
INSERT INTO ruf_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Sambi awala iwehile wangu iwolema nene ndeke kuwa mndewa wawo, waghaleni hano na muwakome aku nene nolola.’ ” ");
INSERT INTO ruf_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu hamalitse kulonga apfo, kawalongolela kaghenda Yerusalemu. ");
INSERT INTO ruf_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Hapfikile habehi na Betifage na Betaniya, kune chidunda ichikemighwa Mitseituni, kawatuma iwanang'ina wake weli, ");
INSERT INTO ruf_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","kawalongela, “Mghende mne tsikaye tsila tsamtsilola. Hamkwingila mna tsikaye atso, mtsomwona imwana we ipunda kohighwa, ng'ana yadinighwe ne imunu bae. Mumdohole mumghale hano. ");
INSERT INTO ruf_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Imunu wowose ang'awaghutsa, ‘Ebali mwumdohola?’ Mumlongele, ‘Mtwatsa kombama.’ ” ");
INSERT INTO ruf_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Na awala iwatumighwe waghenda wapfika ka Yesu pfawalongele. ");
INSERT INTO ruf_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Hawang'ali womdohola imwana we ipunda, iwenyegho wawaghutsa, “Ebali mwomdohola imwana we ipunda?” ");
INSERT INTO ruf_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nawo wedika, “Mtwatsa kombama.” ");
INSERT INTO ruf_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Kuya wamghala kwa Yesu, watandika maghwanda ghao mmughongo mwa imwana we ipunda wamdinitsa Yesu mchanya mwake. ");
INSERT INTO ruf_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Na hang'ali yoghenda, iwanu watandika maghwanda ghawo mnzila. ");
INSERT INTO ruf_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Hapfikile habehi na mhulumko ghwa chidunda cha Mitseituni, mtingano mkulu ghwe iwanang'ina wake wandusa kudeng'elela na kumtunya Imulungu kwa kukemelela, kwa aghala makulu ghawonile. ");
INSERT INTO ruf_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Walonga, “Kebweda Imndewa iyakutsa kwa taghwa lye Imtwatsa! Kulanga kukale tseghamba, ne utunitso kuchanya kulanga!” ");
INSERT INTO ruf_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Mafarisayo wamwenga iwakalile mna mtingano ghula wamlongela Yesu, “Mlangulitsi, uwalonge iwanang'ina wako wenyamale!” ");
INSERT INTO ruf_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu kawedika, “Nowalongela, hawano wang'enyamala, ghamabwe ghano ghatsolapfa litsi.” ");
INSERT INTO ruf_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Hapfikile habehi na Yerusalemu na kughwona ghumji, kaghulilila, ");
INSERT INTO ruf_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","kalonga, “Ung'amanyile leloli ipfinu ipfighala tseghamba! Lekeni sambi pfifisighwa mnenge mwako. ");
INSERT INTO ruf_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kwaapfila ghamatsuwa ghatsokutsila, iwehile wako hawatsotsenga maboma, watsokupfingilila na kukubanyabanya chila ubali. ");
INSERT INTO ruf_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Watsokuhonda ghweghwe ne iwanagho mghati mwa mibanda yako. Ng'awatsokulekela libwe limwe mchanya mwe libwe, kwaapfila ng'umanyile bae ichipindi cha ukutsa kwe Imulungu.” ");
INSERT INTO ruf_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Kuya Yesu kengila kune ing'anda ye Imulungu, kandusa kuwawinga kunze iwanu iwang'ali woutsa ipfinu. ");
INSERT INTO ruf_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Kawalongela, “Yandikighwa, ‘Ing'anda yangu itsakuwa ng'anda ya ukulombela.’ Lekeni mwemwe muitenda iwe mango ya wabapfi.” ");
INSERT INTO ruf_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Chila litsuwa Yesu tsakalangulitsa mne Ing'anda ye Imulungu. Iwakulu we inambiko, iwolangulitsa Ghamalaghitso ne iwakulu we iwanu tsawabama wamkome, ");
INSERT INTO ruf_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","lekeni ng'awapatile bae nzila ya kumkomela, kwaapfila iwanu wose wang'ali womuhulikitsa. ");
INSERT INTO ruf_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Litsuwa limwe Yesu hayang'ali yolangulitsa mne ing'anda ye Imulungu, na kuwapetela imbuli inoghile. Iwakulu we inambiko ne iwolangulitsa Ghamalaghitso ne iwabala wamtsila ");
INSERT INTO ruf_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","wamghutsa, “Utulongele, kwe ukulu wachi kwotenda ipfinu pfino? Kuya yuhi yakwing'ile ukulu uno?” ");
INSERT INTO ruf_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Kawedika, “Na nene nitsowaghutsa imbuli imwe; nilongeleni, ");
INSERT INTO ruf_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ubatitso wa Yohane ulawa kulanga au kwe iwanu?” ");
INSERT INTO ruf_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Lekeni wawo welongetsa iwenyegho, na walonga, “Tung'alonga ulawa kulanga, katsotughutsa, ‘Ebali ng'amumtoghole bae Yohane?’ ");
INSERT INTO ruf_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Na tung'alonga ulawa kwe iwanu, iwanu wose watsotutowa kwa ghamabwe, kwaapfila wose wamtoghola Yohane kughwa kakala nabii.” ");
INSERT INTO ruf_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Apfo wedika, “Ng'atumanyile bae ulawile kwani.” ");
INSERT INTO ruf_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesu kawalongela, “Na nene siwalongela bae kwe ukulu wachi notenda ipfinu pfino.” ");
INSERT INTO ruf_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yesu kaghendelela kuwalongela iwanu imbuli ino. “Imunu yumwe tsakahanda sabibu mne mghunda wake. Keka iwakulima, kuya koka kukala mne isi ingi kwa matsuwa mengi. ");
INSERT INTO ruf_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Msimu wa kuhuna haghupfikile, kamtuma imtumwa kwe iwakulima ili wamgholele ghamatunda gha mitsabibu. Lekeni iwakulima wala wamtowa na wamuwinga ghamoko ghaliyeka. ");
INSERT INTO ruf_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Kamtuma imtumwa yungi. Ayo naye wamtowa na wamtendela pfinu pfa chinyala na kumuyitsa ghamoko ghaliyeka. ");
INSERT INTO ruf_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Kamtuma na wa kadatu. Ayu naye wamlagha na kumuwinga. ");
INSERT INTO ruf_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Kuya, yula yane mghunda kalonga, ‘Nitende choni? Nitsomtuma imwanangu iyanimnoghele. Ayu watsompfuka ghendo.’ ");
INSERT INTO ruf_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Lekeni awala iwakulima hawamwonile, welongetsa iwenyegho, ‘Hayuno iyo muhala mghunda, leka tumkome na uhala wake uwe wetu!’ ");
INSERT INTO ruf_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Apfo wamlapfa kunze mwa mghunda wa mitsabibu, wamkoma.” Kuya Yesu kawaghutsa, “Apfi imunu yane mghunda katsowatenda choni iwakulima wala? ");
INSERT INTO ruf_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Katsakutsa kuwakoma iwakulima awo, na kuweng'a iwanu wangi mghunda awo.” Iwanu hawahulike imbuliyo walonga, “Mbe! Agho ghaleke kulawila!” ");
INSERT INTO ruf_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Lekeni Yesu kawatsodolela tsinenge, kalonga, “Kuya Ghamaandiko Mahenzeluka ghano choni? ‘Libwe iwalilemile iwotsenga, Alyo liwa libwe kulu lya haghatighati?’ ");
INSERT INTO ruf_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Imunu wowose iyokughwa mna libwe awo katsobeneka-beneka, ne imunu wowose litsomghwila litsomhonda ghendo.” ");
INSERT INTO ruf_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Iwolangulitsa Ghamalaghitso ne Watambika wakulu tsawabama wamghoghe Yesu bahala, kwaapfila wamanya ka imbuli ila walongighwa wawo. Lekeni tsawawapfuka iwanu. ");
INSERT INTO ruf_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Apfo wakala wobama ichipindi chinoghile. Wawatuma iwanu iwetendile wanogha, wamghoghe Yesu kwa kumghutsa mbuli, ili wadahe kumghala kwe imkulu we undewa wa Roma. ");
INSERT INTO ruf_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Iwanu awo wamghutsa, “Imlangulitsi, twomanya ghweghwe kwolonga na kwolangulitsa ipfinu pfinoghile, ng'aulola bae ukulu we imunu, lekeni kwolangulitsa inzila ye Imulungu kwe ukweli. ");
INSERT INTO ruf_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Apfi pfinogha kumwing'a kodi Kaisari au ng'apfinoghile bae?” ");
INSERT INTO ruf_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Lekeni Yesu kamanya ukwiha kwawo, kawalongela, ");
INSERT INTO ruf_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Nilanguseni isendi. Ina uhanga wa nani na taghwa lya nani?” Wamwidika, “Wa imndewa Kaisari.” ");
INSERT INTO ruf_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Apfo Yesu kawalongela, “Ipfinu pfa Kaisari mmwing'e Kaisari, ne ipfinu pfe Imulungu mwing'eni Imulungu.” ");
INSERT INTO ruf_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ng'awadahile bae kumghogha kwe achila chialongile hambele he iwanu. Na wakangawala pfaawedike, wanyamala. ");
INSERT INTO ruf_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Masadukayo iwalongagha kuduhu kutsilihuka. Wamwenga wamtsila Yesu na kumghutsa, ");
INSERT INTO ruf_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Imlangulitsi, Musa tsakatwandikila. ‘Imunu ang'afiwa na ndughu yake yane mwehe, lekeni kahela imwana, imunu ayo yamkwele ipinga ayo, ili yamwelekele ndughu yake iwana.’ ");
INSERT INTO ruf_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Tsakukala ne iwandughu saba. Wa mwanduso kakwela mwehe, naye kafa ng'alekile iwana bae. ");
INSERT INTO ruf_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Na wa keli kamsola ipingayo, naye kafa ng'alekile iwana. ");
INSERT INTO ruf_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Kuya wa kadatu kamkwela, na pfipfila wose saba, wafa ng'awalekile iwana bae. ");
INSERT INTO ruf_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Mwiso ipinga yula naye kafa. ");
INSERT INTO ruf_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Lelo mne litsuwa lya kutsilihuka kakuwa mwehe wa yuhi? Kwaapfila tsakakwelighwa na wose saba.” ");
INSERT INTO ruf_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu kawalongela, “Iwanu wa ghamatsuwa ghano wokwela na kukwelighwa. ");
INSERT INTO ruf_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","lekeni awala iwasaghulighwe watsilihuke kulawa mne lifwa na wawe ne ugima, ng'awatsokwela bae wala kukwelighwa. ");
INSERT INTO ruf_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ng'awatsakufa keli bae, kwaapfila watsokuwa ka wamalaika. Nawo wa iwana we Imulungu kwaapfila watsilihuka kulawa mne lifwa. ");
INSERT INTO ruf_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Lekeni, kulonga iwanu iwafile watsotsilihuka, hata Musa tsakalangusa apfo mne imbuli ya chibagho ichikwaka, baho hayalongile Imtwatsa ka Imulungu we Abrahamu, ne Imulungu we Isaka ne Imulungu wa Yakobu. ");
INSERT INTO ruf_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Naye si Imulungu wa iwanu iwafile bae, lekeni yeye ka Imulungu wa wene ughima. Kwaapfila wose wokala waghima kuna yeye.” ");
INSERT INTO ruf_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Wangi we iwolangulitsa Ghamalaghitso walonga, “Imlangulitsi kulonga ghoya!” ");
INSERT INTO ruf_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Nawo ng'awadahile bae kumghutsa keli imbuli. ");
INSERT INTO ruf_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Kuya Yesu kawalongela, “Angu pfii iwanu wolonga Kiristu ka Imwana we Daudi? ");
INSERT INTO ruf_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kwaapfila Daudi imwenyegho kolonga mne ichitabu cha Tsaburi, ‘Imtwatsa tsakamlongela Imtwatsa wangu, Ukale mne ubali wangu wa kujilo. ");
INSERT INTO ruf_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Mbaka niwatende iwanebe wako wawe hasi ha ghamaghulu ghako. ka chighoda cha kwikila maghulu’ ");
INSERT INTO ruf_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Daudi kamkema ‘Imtwatsa,’ Pfii lelo yadahe kuwa imwanaghe?” ");
INSERT INTO ruf_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ne iwanu wose hawakalile wamtegheletsa, Yesu kawalongela iwanang'ina wake, ");
INSERT INTO ruf_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mkale meso ne iwolangulitsa Ghamalaghitso, iwonoghelwa ukwanga kuno wapfala ghamaghwanda matali na kulamutsighwa mmasoko, na kukala mne ipfighoda pfili ambele mne tsing'anda tse ukulombela na mne ipfihungo. ");
INSERT INTO ruf_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Iwebagha mna tsing'anda tse pfitsuka na kwe ung'enye wolomba kwe ichipindi chitali. Awano watsohighighwa ng'ani.” ");
INSERT INTO ruf_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu kenula meso, kawona wane tsimali pfowoghela sadaka tsawo mne chinu cha kwikila sadaka. ");
INSERT INTO ruf_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Pfipfila kamwona chitsuka yumwe mhingwa koghela sendi mbili. ");
INSERT INTO ruf_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Kawalongela, “Nowalongela ghendo, chitsuka ayu kalapfa kubita wose. ");
INSERT INTO ruf_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kwaapfila wose walapfa sadaka itsisidile mna tsimali tsawo, lekeni chitsuka ayu mne uhingwa wake kalapfa pfose pfakalile napfo.” ");
INSERT INTO ruf_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ne iwanang'ina wangi wakala wolonga imbuli ye ing'anda ye Imulungu, pfaitsengighwe kwa ghamabwe ghanoghile na nosa itsilapfighwe ne iwanu kumwing'a Imulungu. Lekeni Yesu kalonga, ");
INSERT INTO ruf_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Agha ghose ghamkona, ghamatsuwa ghatsakutsa, ghatsobomolighwa libwe mchanya mwe libwe lingi, chila limwe litsakwatsighwa hasi.” ");
INSERT INTO ruf_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Iwanu wamghutsa Yesu, “Mlangulitsi, ipfinu apfo pfitsolawila tsuwachi? Ne ichitango chitsokughwa choni ichipindi ipfinu apfo pfa habehi kutsa?” ");
INSERT INTO ruf_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Kedika, “Mwalangitse, mleke kughutsukighwa. Kwaapfila wengi watsakutsa kwa taghwa lyangu, wolonga, ‘Nene iyo imwenyegho,’ ne, ‘Ichipindi cha habehi.’ Mwemwe mleke kuwawinza. ");
INSERT INTO ruf_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Na mng'ahulika imbuli ye ing'ondo na kughaya, mleke kupfuka, kwaapfila ipfinu apfo pfobamighwa tanu pfilawile, lekeni umwisho ng'aukukutsa hima bae.” ");
INSERT INTO ruf_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kuya Yesu kawalongela, “Iwanu wa isi ino wetsotowa ne iwanu wa isi ila, ne undewa utsotowa ne undewa. ");
INSERT INTO ruf_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kutsolawila imidedemo mikulu ye isi, ne inzala ne utamu chila hanu. Na kutsolawila ipfinu pfa kupfukighwa, ne ipfitango pfikulu kulawa kulanga. ");
INSERT INTO ruf_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Lekeni agho ghose ng'ana ghalawile, watsowaghogha na kuwadununza. Watsowaghala mna tsing'anda tse ukulombela, na mne pfifungo, na watsowaghala kwe wandewa na kwe iwatawala kwaajili ya taghwa lyangu. ");
INSERT INTO ruf_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Kubitila agho mtsowapetela Imbuli Inoghile. ");
INSERT INTO ruf_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Lekeni mne imimoyo yenu, mleke ukwalangula pfamtsowedika. ");
INSERT INTO ruf_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Kwaapfila nene nitsoweng'a imbuli ye ukulonga na nzewele. Kuduhu iwanebe wenu watsodaha kuilema wala kwisonga agho ghamlongile. ");
INSERT INTO ruf_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Namwe mtsohundukighwa hata na welesi wenu, iwandughu tsenu ne iwanu wa habehi namwe na sale tsenu. Nawo watsowakoma wangi wenu. ");
INSERT INTO ruf_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Iwanu wose watsowahila kwaajili ya taghwa lyangu. ");
INSERT INTO ruf_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Lekeni ng'aitsokwagha hata imvili imwe ya ghamatwi ghenu. ");
INSERT INTO ruf_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kwa kududumila kwenu mtsobokela ughima. ");
INSERT INTO ruf_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Hamtsolyona ghumji ghwa Yerusalemu litsungulukighwa ne asikali, baho mmanye kughwa ukuhinyighwa kwake kwa habehi. ");
INSERT INTO ruf_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Baho wali mne isi ye Yudeya watsumile kupfidunda, ne iwali mghati mwe ghumji watsumile kunze, na wose iwali mne imighunda waleke kwingila mna ghumji. ");
INSERT INTO ruf_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kwaapfila hagho ghatsokughwa ghamatsuwa gha kuhighighwa ili ghose ighandikighwe ghalawile. ");
INSERT INTO ruf_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Watsoghaya ng'ani iwapinga wane inda ne iwoghwaghwisa mne ghamatsuwa hagho! Kwaapfila kutsokughwa na kughaya ng'ani mne isi, ne Imulungu katsowahigha iwanu we isi ino. ");
INSERT INTO ruf_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Watsokomighwa kwa limaghe, na watsosolighwa mateka ne isi tsose. ghumji ghwa Yerusalemu ghutsobajughighwa ne iwanu iwali si Wayahudi bae, mbaka ichipindi che iwanu iwali si Wayahudi bae hachitsotimila. ");
INSERT INTO ruf_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Kuya kutsokughwa ne ipfitango mne litsua, mne ghumwetsi na mne tsinondo. Mne isi kutsokughwa na kughaya kwaajili ya kupfuka litsi lye ibahali na ghamawimbi ghake. ");
INSERT INTO ruf_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Iwanu watsotsilika kwa kupfuka, kwa kubetetsa ighakutsa mne isi yose, kwaapfila ipfinu pfa kulanga pfitsohighisika. ");
INSERT INTO ruf_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Baho watsomwone Imwana we Imunu kakutsa mne libingu ne ingupfu ne utunitso mkulu. ");
INSERT INTO ruf_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Na baho ipfinu apfo hapfitsokwandusa kulawila, msangalale. Mwinule ghamatwi ghenu kwaapfila ukombotsi wenu wahabehi.” ");
INSERT INTO ruf_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Kuya Yesu kawalongela imbuli. “Loleni ghumtini ne imibiki yose. ");
INSERT INTO ruf_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Hamkwona imitsani yake yochipula, mwomanya kughwa chiangatsi chahabehi. ");
INSERT INTO ruf_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Namwe pfipfila hamkwona ipfinu apfo pfolawila, mmanye undewa we Imulungu wahabehi. ");
INSERT INTO ruf_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Nowalongela ghendo, iwanu wa mweleko uno ng'awatsoluta bae mbaka ipfinu apfo pfilawile. ");
INSERT INTO ruf_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Lilanga ne isi tsitsoluta, lekeni mbuli tsangu ng'atsitsoluta mbe. ");
INSERT INTO ruf_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Mwalangitse! Imimoyo yenu ileke kughoghighwa ne kuja ng'ani, kupatika na kughaya kwaajili ye ughima uno, na litsuwa lila liwatsile kwa kuwadukitsa ka ghumtegho pfaughogha. ");
INSERT INTO ruf_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kwaapfila litsowatsila iwanu wose iwokala mne uhanga we isi yose. ");
INSERT INTO ruf_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Apfo mkale meso ghamatsuwa ghose, mlombe mdahe ukukomboka mne hagho ghose ghatsolawila, na kwima hambele he Imwana we Imunu.” ");
INSERT INTO ruf_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Chila litsuwa Yesu kakala kolangulitsa mne ing'anda ye Imulungu na nechilo koghenda kune chidunda cha Mitseituni na kukala ako. ");
INSERT INTO ruf_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ne iwanu wose wakala wolamka nemitondotondo na kughenda mne ing'anda ye Imulungu kumtegheletsa. ");
INSERT INTO ruf_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ichihungo cha pfighate pfilihela hamila, ichikemighwe Ichihungo che Ipasaka chikala chahabehi. ");
INSERT INTO ruf_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Na ipfilongotsi we inambiko na iwolangulitsa Ghamalaghitso wang'ali wobama inzila ya kumkoma Yesu, lekeni wang'ali wowapfuka iwanu. ");
INSERT INTO ruf_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kuya Setani kamwingila Yuda yakemighwe Isikarioti, yumwe wa wala iwanang'ina kumi na weli. ");
INSERT INTO ruf_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Naye kaghenda kwa ipfilongotsi we inambiko ne iwakulu wa iwanu iwokalitsa ing'anda ye Imulungu, kalonga nawo pfatsodaha kumhunduka Yesu. ");
INSERT INTO ruf_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nawo wadeng'elela na watoghola kumwing'a sendi. ");
INSERT INTO ruf_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yuda katoghola na kandusa kubama uleghelo wa ukumhunduka Yesu ichipindi kuduhu kingili lye iwanu. ");
INSERT INTO ruf_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Litsuwa tsalipfika lye Ichihungo cha Pfighate ipfilihela hamila. Pfipfila likala litsuwa lya kukomighwa kwe iwang'olo we Ichihungo che Ipasaka. ");
INSERT INTO ruf_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Apfo Yesu kawatuma Petiri na Yohane, kawalongela, “Mghende mkatutengele ichijo ili tuje Ipasaka.” ");
INSERT INTO ruf_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Nawo wamghutsa, “Kobama tukakutengele kwani?” ");
INSERT INTO ruf_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Kawedika, “Baho hamkwingila mne ghumji, mtsetingana ne immale yaghalile libigha lya ghamatsi. Mmuwinze mbaka mne ing'anda yatsakwingila. ");
INSERT INTO ruf_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Na mtsomlongela yane ing'anda, ‘Imlangulitsi koghutsa, chilikwani chiheleto che iwahenza, ndiye Ipasaka hamwe ne iwanang'ina wangu?’ ");
INSERT INTO ruf_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Naye katsowalangusa chiheleto chikulu cha uchanya, ichikwighwe ghoya. Namwe mtenge ichijo amo.” ");
INSERT INTO ruf_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Waghenda wachipfika chila ichinu ka Yesu pfawalongele, nawo watenga ichijo cha Ipasaka. ");
INSERT INTO ruf_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Isaa haipfikile, Yesu kawasola iwatumighwa wake kakala nawo mchijo. ");
INSERT INTO ruf_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kawalongela, “Nosulukila kuja ichijo chino che Ipasaka na mwemwe ng'ana nidununzike! ");
INSERT INTO ruf_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nowalongela ghendo, sitsakuja keli bae mbaka Pasaka haitsolawila mne Undewa we Imulungu.” ");
INSERT INTO ruf_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Yesu kasola ichikombe che dipfai, kalonga, “Mighede ghwe Imulungu.” Kuya kawalongela, “Mchisole mwose mchisole. ");
INSERT INTO ruf_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nowalongela kulawa sambi sitsoinwa bae idipfai ino mbaka Undewa we Imulungu utse.” ");
INSERT INTO ruf_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Kuya kasola chighate, kalonga, “Mighede Imulungu.” Kachibena, kaweng'a, kalonga, “Aluno lukuli lwangu lwamwing'ighwe mwemwe. Mtende pfino kwa kung'umbuka nene.” ");
INSERT INTO ruf_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Pfipfila, hawamalitse kuja ichijo cha nemihe, kaweng'a ichikombe kalonga, “Achi ichikombe cha lilaghano lya sambi lye Imulungu ilili mne idamu yangu, iimwitikilani mwemwe. ");
INSERT INTO ruf_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Lekeni ghumoko ghwa ayula yatsonihunduka ghwa hamwe na nene mmetsa! ");
INSERT INTO ruf_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Imwana we Imunu katsakufa ka pfailamlighwe, lekeni katsoghaya ng'ani imunu yula iyomhunduka!” ");
INSERT INTO ruf_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Wandusa kwighutsa iwenyegho, yuhi mna wawo yatsotenda ichinu acho. ");
INSERT INTO ruf_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Pfipfila wandusa kwihisanya yuhi mna wawo yatsakuwa mkulu kubita wose. ");
INSERT INTO ruf_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesu kawalongela, “Iwandewa wa iwanu iwali si Wayahudi bae wowatawala iwanu kwe ingupfu, na wala wane ukulu mna wawo wokemighwa ‘Sale tse iwanu.’ ");
INSERT INTO ruf_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Lekeni kuna mwemwe si pfipfo bae. Yali mkulu na yawe ka mdodo kubita wose, na chilongotsi yawe ka imunu iyotumikila. ");
INSERT INTO ruf_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kwaapfila yuhi yali mkulu? Yula iyokala mmetsa, au yula iyakwika ichijo? Ambe yula iyokala mmetsa? Lekeni nene namghati mwenu ka imunu iyosang'ana.” ");
INSERT INTO ruf_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Namwe mkala na nene mne ukughetsighwa kwangu. ");
INSERT INTO ruf_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Na nene nomwing'ani undewa, ka apfila aba wangu pfangahile nene. ");
INSERT INTO ruf_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Mdahe ukuja ne ukunwa mmetsa mwangu mne undewa wangu, na kukala mne ipfighoda pfa undewa na kughahigha ghamakabila kumi na meli gha Isiraeli.” ");
INSERT INTO ruf_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesu kalonga, “Simoni, Simoni, ukale meso! Setani tsakabama kuwabeta mwemwe ka uhunga. ");
INSERT INTO ruf_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Lekeni nikulombela ghweghwe Simoni, ukutoghola kwako kuleke kuhunguka, naghwe hautsombuyila keli uwapfile iwandughu tsako.” ");
INSERT INTO ruf_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Petiri kamlongela, “Imtwatsa, nene nitoghola kughenda na ghweghwe mchifungo na hata ukukomighwa.” ");
INSERT INTO ruf_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu kamlongela, “Nokulongela Petiri, leloli jogholo ng'ana yeke ghweghwe kutsonibela mala ndatu, ka ng'unimanyile bae!” ");
INSERT INTO ruf_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Kuya Yesu kawaghutsa, “Pfii hala haniwatumile aku mwahela ghumfuko au mkoba au pfilatu, tsamuhungukighwa na chinu?” Walonga, “Bae! Ng'atuhungukighwe na chinu bae.” ");
INSERT INTO ruf_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Kawalongela, “Lekeni sambi yane ghumfuko aghusole, na yane mkoba pfipfila aghusole. Naye yalihela lipanga autse lighwanda lyake ne aghule limwe. ");
INSERT INTO ruf_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kwaapfila Ghamaandiko Mahenzeluka aghala igholonga. ‘Naye katsopetighwa ne iwanu wehile’ ghotimila. Nowalongela, hagho ghose ighandikighwe kwaajili ya nene ghobamighwa ghatimile.” ");
INSERT INTO ruf_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Iwanang'ina walonga, “Mtwatsa, lola, hano hana mimaghe mili.” Kawalongela, “Ona.” ");
INSERT INTO ruf_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu kaghenda kune Chidunda cha Mitseituni ka pfatsowele, na wanang'ina wake wamuwinza. ");
INSERT INTO ruf_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Hawapfikile ako, kawalongela, “Mlombe mleke kwingila mne ukughetsighwa.” ");
INSERT INTO ruf_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Kuya kawaleka, kaghenda utali wa imunu kudaha ukwasa libwe. Katowa ghamaghoti, kalomba, ");
INSERT INTO ruf_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Ghwe Aba, ung'abama uchilapfe ichikombe chino kuna nene. Lekeni si ka pfanibama nene bae, lekeni ka pfubama ghweghwe.” ");
INSERT INTO ruf_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Baho malaika kamlawila, kamwing'a ingupfu. ");
INSERT INTO ruf_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Naye kwaapfila pfakalile mne usungu, tsakalomba ng'ani. Lijasho lyake tsalikala ka ghamadondwe gha idamu gholaghala hasi. ");
INSERT INTO ruf_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Hamalitse kulomba, kawaghendela iwanang'ina wake. Kawapfika wawasa, kwaapfila tsawana usungu. ");
INSERT INTO ruf_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Kawalongela, “Pfii mbona muwasa? Mlamke mlombe, mleke kwingila mne ukughetsighwa.” ");
INSERT INTO ruf_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu hang'ali yolonga, kingili lye iwanu litsa aku lyongotsighwa na Yuda, yakalile yumwe mna iwanang'ina wake kumi na weli. Kamghendela Yesu, kamnonela. ");
INSERT INTO ruf_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Lekeni Yesu kamghutsa, “Yuda, kwomhunduka Imwana we Imunu kwa kumnonela?” ");
INSERT INTO ruf_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Na wala iwakalile habehi naye hawonile ighatsolawila, walonga, “Mtwatsa, tuwateme na ghamapanga?” ");
INSERT INTO ruf_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Na yumwe mna wawo kamtowa imtumwa we Mtambika mkulu, kamsepula ghutwi lyake lya kujilo. ");
INSERT INTO ruf_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Lekeni Yesu kalonga, “Mleke kutenda keli!” Kamkinda ghutwi lyake, kamhonetsa. ");
INSERT INTO ruf_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kuya Yesu kawalongela ipfilongotsi we inambiko, iwakulu we iwanu, iwokalitsa ing'anda ye Imulungu, ne iwabala iwamtsile yeye, “Pfii mtsa na ghamapanga ne ipfilungu ka nene na mbapfi? ");
INSERT INTO ruf_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ghamatsuwa ghose tsanikala na mwemwe mne ing'anda ye Imulungu ng'amnighoghile bae. Lekeni aino iyo isaa yenu, na utawala wa chisi.” ");
INSERT INTO ruf_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Kuya wamghogha Yesu, waghenda naye mne ing'anda ye Imtambika mkulu. Petiri kamuwinza kwa kutali. ");
INSERT INTO ruf_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Na hawabwinile ghumoto haghati he chibwalu cha libaratsa, wakala hamwe. Petiri naye kakala nawo. ");
INSERT INTO ruf_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Na imtumwa yumwe ipinga kamwona Petiri kakala mne ghumwanga. Kamlola ghoya, kalonga, “Imunu yuno naye tsakakala na Yesu!” ");
INSERT INTO ruf_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Lekeni Petiri kabela, kalonga, “Ghwe ipinga ghwe, nene simmanyile bae.” ");
INSERT INTO ruf_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Hambele chidogho, imunu yungi kamwona Petiri, naye kalonga, “Ghweghwe naghwe kwa yumwe wawo.” Lekeni Petiri kalonga, “Aka, si nene bae!” ");
INSERT INTO ruf_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Kuya ibita isaa imwe, imunu yungi kalonga, “Ayu tsakakala naye ghendo, kwaapfila naye Mgalilaya!” ");
INSERT INTO ruf_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Petiri kalonga, “Ghwe imunu ghwe, chulonga sichimanyile bae!” Baho hang'ali yolonga, jogholo keka. ");
INSERT INTO ruf_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Imtwatsa kahunduka, kamlola Petiri. Naye Petiri kakumbuka imbuli iyamlongele Imtwatsa, “Leloli jogholo ng'ana yeke ghweghwe kutsonibela mala ndatu, ka ng'unimanyile bae!” ");
INSERT INTO ruf_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Petiri kalawa kunze, kalila kwa usungu. ");
INSERT INTO ruf_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Iwanu iwang'ali womkalitsa Yesu wandusa kumbetsa na kumtowa. ");
INSERT INTO ruf_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Wamtowa aku wamghubika tsinenge, wamghutsa, “Utange! Yuhi yakutowile?” ");
INSERT INTO ruf_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Kuya walonga mbuli nyingi tsa ukumligha. ");
INSERT INTO ruf_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nemitondo haipfikile, iwabala, ipfilongotsi we inambiko na iwolangulitsa Ghamalaghitso tsawetingana hamwe, wamghala Yesu kune libalatsa lyawo. ");
INSERT INTO ruf_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Walonga, “Tulongele ka ghweghwe kwa Kiristu.” Yesu kawalongela, “Ning'awalongela, mwemwe ng'amtsotoghola bae, ");
INSERT INTO ruf_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","na ning'awaghutsa, ng'amtsakwidika. ");
INSERT INTO ruf_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Lekeni kulawa sambi na kughendelela, Imwana we Imunu katsokala ubali wa kujilo we Imulungu yane Ingupfu.” ");
INSERT INTO ruf_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Kuya wose wamghutsa, “Apfi ghweghwe kwa Imwana we Imulungu?” Naye kawedika, “Mwemwe mwolonga nene iyo yuyo.” ");
INSERT INTO ruf_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Walonga, “Lelo twobama ukalangama ungi? Twetwe tuwenyegho tuhulika chalongile!” ");
INSERT INTO ruf_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kuya wose wenuka wamghala Yesu kwa Pilato. ");
INSERT INTO ruf_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Wandusa kumlapfila maghomba, walonga, “Tumwona imunu yuno kowaghisa iwanu wetu. Kawaghoma kuliha kodi kwa mndewa wa Roma, kuya kolonga yeye iyo Kiristu, imndewa.” ");
INSERT INTO ruf_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilato kamghutsa, “Ghweghwe kwa mndewa wa Wayahudi?” Yesu kamwidika, “Ona, ka ghweghwe pfulonga.” ");
INSERT INTO ruf_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Kuya Pilato kawalongela Wakulu we Inambiko na mtingano we iwanu, “Sonile bae totso lye imunu yuno.” ");
INSERT INTO ruf_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Lekeni wawo wakomangitsa ghendo, “Kwa ghamalangulitso ghake kowasongetsa iwanu iwali Yudeya yose wehisanye na undewa wa Roma. Kandusila Galilaya mbaka akuno.” ");
INSERT INTO ruf_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilato hahulike agho, kaghutsa ka Yesu imunu wa Galilaya. ");
INSERT INTO ruf_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Hamanyile ka Yesu kolawila isi iyoitawala Herodi, kamghala kwa Herodi, iyakalile Yerusalemu ghamatsuwa agho. ");
INSERT INTO ruf_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodi hamwonile Yesu, kadeng'elela ng'ani kwaapfila kwa ghamatsuwa mengi tsaang'ali yobama amwone. Kwaapfila tsakahulika mbuli tsake, na ang'ali yomlolela Yesu yatende pfinu pfa kukangawatsa. ");
INSERT INTO ruf_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Apfo Herodi kamghutsa mbuli nyingi, lekeni Yesu ng'amwidike bae. ");
INSERT INTO ruf_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Wakulu we inambiko na Walangulitsi wa Ghamalaghitso tsawema hala, wamlapfila Yesu maghomba kwe ingupfu. ");
INSERT INTO ruf_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodi ne asikali wake wamtendela Yesu pfihile na wambetsa. Kuya wampfatsa lighwanda linoghile wamuyitsa kwa Pilato. ");
INSERT INTO ruf_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Kulawa baho Herodi tsakawa sale wa Pilato. Kwaapfila ghumwande tsawang'ali wehila. ");
INSERT INTO ruf_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato kawakema hamwe Iwakulu we Inambiko, iwabala, ne iwanu, ");
INSERT INTO ruf_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","kuya kawalongela, “Mumghala imunu yuno kuna nene ka imunu iyowaghitsa iwanu wehisanye na undewa wa Roma. Nene nilamla mbuli tsake akuno mwemwe mwolola, lekeni sonile bae chochose chihile mne maghomba ghamlongile kuna yeye. ");
INSERT INTO ruf_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Naye Herodi pfipfila katuyitsila twetwe munu yuno, kwaapfila ng'onile bae totso lyake. Apfo, imunu ayu ng'atendile chochose bae ichimtenda akomighwe. ");
INSERT INTO ruf_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Apfo nitsomtowa kuya nitsomlekelela.” ");
INSERT INTO ruf_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Kwaapfila Herodi tsakabamighwa amlekelele mwohighwa yumwe mne chihungo. ");
INSERT INTO ruf_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Iwanu wose wakemelela lumwe, “Umkome imunu ayu! Utulekelele Baraba!” ");
INSERT INTO ruf_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Baraba tsakakala imunu yekighwe mchifungo kwa kutenda hengele na ukukoma mne ghumji. ");
INSERT INTO ruf_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato tsakabama kumlekelela Yesu, apfo kalonga nawo keli. ");
INSERT INTO ruf_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Lekeni wakemelela, “Muwambe mna msalaba! Muwambe mna msalaba!” ");
INSERT INTO ruf_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Kawalongela lwakadatu, “Ebali? Atendile choni chihile? Sonile bae totso lyolyose lihile ilimtenda yakomighwe. Apfo nitsompfapula, kuya nomlekelela.” ");
INSERT INTO ruf_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Lekeni wakemelela ng'ani, wabama Yesu yawambighwe mna msalaba. Na kwa kukemelela kwawo wamtenda Pilato atoghole. ");
INSERT INTO ruf_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Apfo Pilato kalamla chawabamile chitendeke. ");
INSERT INTO ruf_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Kamlekelela ayula yawambamile, ayula yekighwe mchifungo kwa hengele na ukukoma, kamlapfa Yesu yakomighwe ka pfawabamile. ");
INSERT INTO ruf_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Hawang'ali womghala, watingana ne imunu yumwe yakemighwe Simoni, imunu wa Kirene, iyang'ali iyolawa kumghunda. Wamghogha wamtwika msalaba yaughale kuchughu kwa Yesu. ");
INSERT INTO ruf_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Iwanu wengi wamuwinza, hamwe ne iwapinga iwang'ali womlilila na ukunyanyana. ");
INSERT INTO ruf_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Lekeni Yesu kawahundukila kawalongela, “Iwapinga wa Yerusalemu, mleke kundilila nene, ila mwililile iwenyegho na iwanenu. ");
INSERT INTO ruf_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kwaapfila ghamatsuwa ghakutsa hawatsolonga, ‘Wabweda iwapinga iwalihela iwana, ing'aweleke iwana na yang'awakong'ese bae.’ ");
INSERT INTO ruf_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Kuya watsopfilongela pfidunda, ‘Tughwileni!’ na pfidunda, ‘Tughubikeni!’ ");
INSERT INTO ruf_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kwaapfila ka iwanu wotenda pfinu pfino kwa mbiki mbisi, itsokuwatse kwa mbiki iusakale?” ");
INSERT INTO ruf_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Iwanu wangi iwabapfi pfipfila waghalighwa wakomighwe hamwe na Yesu. ");
INSERT INTO ruf_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Hawapfikile hanu hakemighwe “Bombwe lya Litwi,” baho wamuwamba Yesu na awala iwanu wehile mne misalaba, yumwe ubali wake wa kujilo na yungi ubali wake wa kumoso. ");
INSERT INTO ruf_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesu kalonga, “Aba, wonele libatsi kwaapfila ng'awamanyile bae chawotenda.” Nawo wegholela ghamaghwanda ghake kwa kutowa simbi. ");
INSERT INTO ruf_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Iwanu tsawema baho wolola, iwakulu wa Wayahudi hawang'ali wombetsa. Walonga, “Tsakawakombola iwanu wangi, leka yekombole imwenyegho, ka yeye Kiristu, Imkombotsi iyasaghulighwe ne Imulungu!” ");
INSERT INTO ruf_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Asikali pfipfila wambetsa. Wamghendela wamwing'a isiki, ");
INSERT INTO ruf_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","wamlongela, “Ka ghweghwe kwa imndewa wa Wayahudi, wikombole umwenyegho!” ");
INSERT INTO ruf_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Mchanya mwa msalaba wake tsakukala ne ichitango chino. “Ayuno iyo Imndewa wa Wayahudi.” ");
INSERT INTO ruf_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Mbapfi yumwe mna awala iwabapfi iwawambighwe kamligha Yesu, kalonga, “Pfii ghweghwe si Kiristu bae? Wikombole imwenyegho kuya utukombole na twetwe!” ");
INSERT INTO ruf_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Lekeni ayula mbapfi yungi kamkembela miyaghe kalonga, “Ghweghwe! Ng'umpfuka Imulungu bae, naghwe kuhighighwa ka yeye? ");
INSERT INTO ruf_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nene na ghweghwe tuhighighwa kwa haki, apfo twobokela maliho gha aghala ghatutendile. Lekeni imunu ayu ng'atendile bae chochose chihile.” ");
INSERT INTO ruf_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Kuya kalonga, “Ghwe Yesu ghwe, hautsakutsa mne undewa wako, uleke kunisemwa.” ");
INSERT INTO ruf_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu kamlongela, “Nokulongela ghendo, leloli kutsokala na nene kulanga.” ");
INSERT INTO ruf_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Tsaikala saa sita, kung'ali ne ichisi muisi mwose mbaka saa tisa ");
INSERT INTO ruf_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Kuya lipatsiya lye ing'anda ye Imulungu lidegheka pfihindi pfili. ");
INSERT INTO ruf_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Baho Yesu kakemelela, kalonga, “Aba, mne ghamoko ghako nakwika muhe wangu!” Hayalongile apfo, kafa. ");
INSERT INTO ruf_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Yula imkulu we asikali ghana limwe wa chilumi honile ighalawile, kamtunya Imulungu, kalonga, “Kweli imunu ayu tsakanogha!” ");
INSERT INTO ruf_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Iwanu wose iwetingane kulola ipfinu apfo, hawonile ighalawile, waghenda mmakaye mwawo, wetowatowa mmambagha mwawo kwa usungu. ");
INSERT INTO ruf_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Lekeni awala wose iwammanyile wema kwa kutali, wolola ipfinu apfo. Mghati mwawo tsawakala iwapinga iwamuwinzile Yesu kulawa Galilaya. ");
INSERT INTO ruf_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Tsakukala ne imunu yumwe, taghwa lyake Yosefu yolawila Arimataya mne ghumji ghwa Yudeya. Imunu yuno tsakanogha, na mtenda ghanoghile naye yang'ali yobetetsa Undewa we Imulungu. Hata ka tsakakala yumwe mne iwakulu we libalatsa lya Wayahudi, ng'atoghole bae chawatendile weyaghe. ");
INSERT INTO ruf_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Imunu ayo kaghenda kwa Pilato, kalomba lukuli lwa Yesu. ");
INSERT INTO ruf_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Kaluhulumsa, kalupfatsa sanda, kalwika mne likabuli ilisongolighwe mbambalawe, nalyo ng'ana litsikighwe imunu bae. ");
INSERT INTO ruf_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Tsaikala Ijumaa, litsuwa lya ukwiyandaa, na litsuwa lya Sabato tsalyahabehi kwandusa. ");
INSERT INTO ruf_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Na awala iwapinga iwatsile na Yesu kulawa Galilaya wamuwinza Yosefu na walyona likabuli na lukuli lwa Yesu halwikighwe. ");
INSERT INTO ruf_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Kuya woya akaye watanda ghamafuta ighonung'ila ghoya. Mne litsuwa lya Sabato wabwihila ka pfailaghitsighwe. ");
INSERT INTO ruf_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","12Litsuwa lya Jumapili lupfilipfili, iwapinga wasola ghamanukato ighawatandile na waghenda kune likabuli. ");
INSERT INTO ruf_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Walifika libwe lya kughubikila likabuli libingilisighwa hambalimbali mwe likabuli. ");
INSERT INTO ruf_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Wengila mne likabuli, lekeni ng'awonile bae lukuli lwe Imtwatsa Yesu. ");
INSERT INTO ruf_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Hawang'ali wokangawala kwa chinu acho, bahala iwanu weli iwapfalile ghamaghwanda ghang'alile ng'ani wema habehi nawo. ");
INSERT INTO ruf_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Wapinga wala wapfuka ng'ani na kwinamila hasi. Baho iwanu wala wawalongela, “Ule mumbama imunu mghima mne iwanu iwafile? ");
INSERT INTO ruf_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yesu ng'alibaha bae, katsilihuka! Mkumbuke chayawalongele hayakalile mne isi ya Galilaya. ");
INSERT INTO ruf_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Imwana we Imunu kobamighwa aghoghighwe ne iwanu wane nzambi, nawo watsomuwamba mna msalaba, na litsuwa lya kadatu katsotsilihuka.’ ” ");
INSERT INTO ruf_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Kuya iwapinga wala wakumbuka imbuli haila yawalongele. ");
INSERT INTO ruf_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Hawoyile kulawa mne likabuli, wawalongela mbuli atso iwanang'ina wala kumi na yumwe wa Yesu ne iwanu wangi. ");
INSERT INTO ruf_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Iwapinga iwalongile mbuli atso kwe iwatumighwa wa Yesu tsawakala Mariya Magidalena, Yoana, na Mariya mai wake Jakobu, ne iwapinga wangi welongotse nawo. ");
INSERT INTO ruf_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Lekeni iwatumighwa wa Yesu wayona imbuli ilongighwe ne iwapinga wala yahela mana, apfo ng'awatoghole bae. ");
INSERT INTO ruf_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Lekeni Petiri kalawa na kutsuma mbaka mne likabuli. Hayafikile, kenama na kusungulila mghati, baho kayona isanda iliyeka. Kuya koya ukaye aku kakangawala kwa aghala ighalawile. ");
INSERT INTO ruf_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Mne litsuwa lilila, iwanu weli iwamwinzile Yesu wakala woghenda mne ichitobogha ichikemighwe Emau, utali wa maili saba kulawa Yerusalemu. ");
INSERT INTO ruf_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Wakala welongetsa wao kwa wao kwa aghala ghose ighalawile. ");
INSERT INTO ruf_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Baho hawakalile welongetsa na kwighutsa, Yesu imwenyegho kalawila na kelongotsa nawo. ");
INSERT INTO ruf_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Wamwona, lekeni ng'awammanyile bae. ");
INSERT INTO ruf_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Kawaghutsa, “Mwoghenda mwelongetsa choni?” Nawo wema na wanyamala, pfihanga pfawo pfonesa usungu. ");
INSERT INTO ruf_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Imunu yumwe mne iwanu awo, yakemighwe Kileopa, kamwidika, “Pfii, ghweghwe kwa mhenza uliyeka mne ghumji ghwa Yerusalemu, ng'una umanye bae ipfinu pfilawile ako mne ghamatsuwa agha?” ");
INSERT INTO ruf_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Kawaghutsa, “Ipfinu pfachi?” Nawo wedika, “Ipfinu ipfimlawile Yesu wa Natsareti. Imunu ayo kakala nabii iyodaha kutenda na kulangulitsa hambele he Imulungu ne iwanu wose. ");
INSERT INTO ruf_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Iwakulu we inambiko ne iwakulu wetu tsawamghala kwe iwakulu wa Chirumi yahighighwe ukufa, nawo wamuwamba mna msalaba; ");
INSERT INTO ruf_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","tsatulolela yeye iyo iyatsowakombola Waisiraeli. Lekeni leloli litsuwa lya kadatu kulawa ipfilawile ipfinu apfo. ");
INSERT INTO ruf_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Pfipfila, iwapinga wangi kulawa mne kingili lyetu tsawatutenda tukangawale. Lupfilipfili tsawaghenda mne likabuli, ");
INSERT INTO ruf_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","lekeni ng'awalufikile bae lukuli lwake. Woya na kutulongela walawilighwa ne wamalaika iwawalongele Yesu kakala mghima. ");
INSERT INTO ruf_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Kuya iwanu wamwenga iwalongotsagha na twetwe tsawaghenda mne likabuli, nawo wapfika ka iwapinga pfawalongile, ng'awamwonile bae.” ");
INSERT INTO ruf_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yesu kawalongela, “Mbona, mwawabotsi pfino! Na imimoyo yenu mikomu kutoghola ghose ighalongighwe ne manabii! ");
INSERT INTO ruf_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Pfii, ng'aibamighwe bae Kiristu kudununzika apfi, na hambele kwingila mne utunitso wake?” ");
INSERT INTO ruf_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Kuya kawalongela ghoya ipfinu pfose ipfimlangusa yeye imwenyegho mne Ghamaandiko Mahenzeluka, kwandusila mne ipfitabu ipfiandikighwe na Musa na kughendelela mne ipfitabu pfe manabii wose. ");
INSERT INTO ruf_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Baho hawatsifikile tsikaye tsiwang'alii wotsighendela, Yesu katenda ka kolumbilila. ");
INSERT INTO ruf_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Lekeni wamlomba ghendo, “Ukale na twetwe, kwaapfila litsuwa liswa, na chilo chakwingila.” Apfo kaghenda, kakala nawo. ");
INSERT INTO ruf_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Hayakalile hasi na kuja ichijo hamwe nawo, kasola chighate, kalonga mighede kwe Imulungu, kachibena, kaweng'a. ");
INSERT INTO ruf_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Bahala, tsinenge tsawo tsipfumbuka nawo wammanya, naye kagha mnenge mwawo. ");
INSERT INTO ruf_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Tsaweghutsa, “Apfi imimoyo yetu ng'aili yakwaka bae hayakalile kotulongela mnzila na kutulongela ghoya Ghamaandiko Mahenzeluka?” ");
INSERT INTO ruf_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Bahala woka na kuya Yerusalemu. Wawafika iwanang'ina kumi na yumwe wa Yesu, ne iwanu wangi iwakalile, nawo wetingana hamwe ");
INSERT INTO ruf_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","wolonga, “Imtwatsa katsilihuka ghendo! Kamlawila Simoni!” ");
INSERT INTO ruf_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Kuya iwanu wala weli wawalongela achila ichiwalawile mnzila, na pfawamtangile Yesu hayachimeghile chighate. ");
INSERT INTO ruf_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Hawang'ali wowalongela apfo, Yesu imwenyegho kema hamwe nawo, kawalongela, “Mkale tseghamba!” ");
INSERT INTO ruf_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Weduka na kupfuka, wapfikitsa waghwona ghumtsimu! ");
INSERT INTO ruf_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Lekeni kawalongela, “Mbona mwoghaya? Ebali mwoghanzika mne imimoyo yenu? ");
INSERT INTO ruf_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Mlole ghamoko na ghamaghulu ghangu na mmanye nene na-mwenyegho! Mnikinde mwone; kwaapfila ghumtsimu ghwahela lukuli ne imipate ka pfimmbona.” ");
INSERT INTO ruf_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Hayakalile kolonga apfo, kawalangusa ghamoko na ghamaghulu ghake. ");
INSERT INTO ruf_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Hawang'ali ng'awodaha bae kutoghola kwa kudeng'elela na kukangawala ng'ani, Yesu kawaghutsa, “Mna ichijo chochose hano?” ");
INSERT INTO ruf_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Wamwing'a chihindi cha isomba yokighwe. ");
INSERT INTO ruf_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Kachisola, kachija wose womlolesa. ");
INSERT INTO ruf_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Kuya kawalongela, “Aghano ghagho malonga ghangu ghaniwalongele, ahala hanikalile hamwe na namwe. Tsaibamighwa ghatendeke aghala ghose ghanyandikighwe nene mne Ghamalaghitso gha Musa na mne ipfitabu pfa manabii na Tsaburi.” ");
INSERT INTO ruf_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kuya katsimwemwesela tsimbutsi tsawo wadahe kughamanya Ghamaandiko Mahenzeluka. ");
INSERT INTO ruf_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Kawalongela, “Yandikighwa apfi, Kiristu katsodununzika na litsuwa lya kadatu katsotsilihuka. ");
INSERT INTO ruf_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Iwanu wose watsopetelighwa kwa taghwa lyake watsileke nzambi tsawo, naye Imulungu katsowaleghusila nzambi tsawo, kwandusila Yerusalemu. ");
INSERT INTO ruf_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Namwe mwa-wakalangama we ipfinu pfino. ");
INSERT INTO ruf_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Na nene imwenyegho nitsowaghalila ayula Aba wangu yalongile katsomtuma. Lekeni mwemwe mbete mne bululu mbaka mtsokwing'ighwa ila ingupfu kulawa uchanya.” ");
INSERT INTO ruf_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Kuya kawalongotsa kunze mwe ghumji ghwa Yerusalemu mbaka Betaniya, naye kenula uchanya ghamoko ghake, kawabaliki. ");
INSERT INTO ruf_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Hayang'ali yowabaliki, kawaleka, kasolighwa kughenda kulanga. ");
INSERT INTO ruf_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Nawo wamtowela ghamaghoti, kuya woya Yerusalemu kuno wodeng'elela ");
INSERT INTO ruf_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Waghendelela kukala hane Ing'anda ye Imulungu na kumtunya Imulungu.");
INSERT INTO ruf_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Aho mwanduso ng'ana pfinu pfose pfilumbighwe yumwe yakemighwe Imbuli tsakabaho. Imbuli ayo tsakakala ne Imulungu, naye tsakakala Imulungu. ");
INSERT INTO ruf_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Yeye tsakakala ne Imulungu kulawa mwanduso. ");
INSERT INTO ruf_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Kubitila yeye pfinu pfose tsapfilumbighwa, kuduhu ichinu ichilumbighwe bila yeye. ");
INSERT INTO ruf_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Yeye tsakakala mwanduso wa ughima, na ughima awo tsaukala ghumwanga kwe iwanu. ");
INSERT INTO ruf_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ghumwanga ghomwemwesela ichisi, na ichisi ng'achidaha bae kughutsima. ");
INSERT INTO ruf_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Tsakulawila imunu yumwe iyatumighwe ne Imulungu, taghwa lyake Yohane. ");
INSERT INTO ruf_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Yohane tsakatsa kuwalongela iwanu mbuli tse ghumwanga, ili iwanu wose wahulike, waghutoghole. ");
INSERT INTO ruf_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yeye imwenyegho ng'awile bae ghumwanga, ila katsa kuwalongela iwanu imbuli ye ghumwanga. ");
INSERT INTO ruf_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Aghuno ghukala ghumwanga ghwa kweli, ghumwanga ighung'ali ghukutsa muisi kumwemwesela iwanu wose. ");
INSERT INTO ruf_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Imbuli tsakakala muisi, na hata ka Imulungu tsakalumba isi kubitila yeye, iwanu ng'awamtangile bae. ");
INSERT INTO ruf_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Tsakatsa ukaye yake, lekeni iwanu wake ng'awambokele bae. ");
INSERT INTO ruf_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Bali iwanu wose iwambokele, awala iwamtoghole, kawatenda wadahe kuwa iwana we Imulungu. ");
INSERT INTO ruf_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Iwana ing'awelekighwe bae kwa uwetso we iwanu, wala kwe ngupfu tsa lukuli au unoghelo we iwanu, ila kwa uwetso we Imulungu. ");
INSERT INTO ruf_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Na Imbuli ayo kawa imunu, naye kakala hamwe na twetwe. Na twetwe tuwona utunitso wake, utunitso we Imwana nyalimwe, iyatsile kulawa kwa Aba, kamema uluso na ukweli. ");
INSERT INTO ruf_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohane tsakalonga mbuli tsake. Tsakakemelela, “Ayuno iyo iyaniwalongele, ‘Ayo iyakutsa kuchughu kwangu mkulu kubita nene kwaapfila tsakabaha ng'ana nene nyelekighwe.’ ” ");
INSERT INTO ruf_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kwa ukutimila kwa uluso wake twetwe twose tubokela ng'ani. ");
INSERT INTO ruf_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Imulungu tsakatwing'a Ghamalaghitso kubitila Musa, lekeni uluso na ukweli pfakutsa kubitila Yesu Kiristu. ");
INSERT INTO ruf_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Kuduhu imunu wowose iyamwonile Imulungu. Ila Imwana yaliyeka, yeghalile ne Imulungu iyelungile na Aba, iyo iyatulongele mbuli tse Imulungu. ");
INSERT INTO ruf_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Auno iwo ukalangama wa Yohane, iwakulu wa Wayahudi wa Yerusalemu hawawatumile iwatambika wakulu na Walawi waghende kwa Yohane, kumghutsa yeye tsakakala nani. ");
INSERT INTO ruf_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yohane tsakatoghola na ng'alemile bae kuwedika mwatsimwatsi, tsakalonga, “Nene sili Kiristu bae, iyokombola iwanu.” ");
INSERT INTO ruf_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Wamghutsa, “Lelo ghweghwe uli nani? Pfii ghweghwe kwa Eliya?” Yohane kawedika, “Mbe, si nene bae.” Wamghutsa keli, “Lelo ghweghwe kwa ayula Nabii iyalongighwe katsakutsa?” Kawedika, “Bae.” ");
INSERT INTO ruf_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Kuya wamghutsa, “Lelo ghweghwe uli nani? Ghweghwe mwenyegho ulongatse? Tulongele lelo, na twetwe tukawalongele yawatutumile tukughutse.” ");
INSERT INTO ruf_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yohane kawedika ka pfayalongile nabii Isaya, “Nene na ‘litsi lye imunu iyokema kunyika, Muigholose inzila ye Imtwatsa!’ ” ");
INSERT INTO ruf_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Kuya Mafarisayo wangi iwatumighwe ");
INSERT INTO ruf_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","wamghutsa Yohane, “Ka ghweghwe si Kiristu, wala Eliya, wala ayula Nabii, ule kwobatitsa?” ");
INSERT INTO ruf_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohane kawedika, “Nene nobatitsa kwa ghamatsi, lekeni mghati mwenu kuna yumwe yang'amummanyile. ");
INSERT INTO ruf_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ayo iyo yuyo iyakutsa kuchughu kwangu. Nene sibamighwa bae hata kudohola imitsabi ya imikwabatsa yake.” ");
INSERT INTO ruf_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Agha ghose ghalawila Betaniya, kumwambu kwa ghumto Yoridani, Yohane kwang'ali yobatitsa. ");
INSERT INTO ruf_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Litsuwa lya keli Yohane kamwona Yesu komtsila, kalonga, “Mlole! Imwana Ing'olo we Imulungu iyosola nzambi tse isi yose! ");
INSERT INTO ruf_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ayuno iyo yuyo yanilongile mbuli tsake, haniwalongele pfino, ‘Imunu iyakutsa kuchughu kwangu mkulu kubita nene kwaapfila tsakabaha nene ng'ana nyelekighwe.’ ");
INSERT INTO ruf_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nene imwenyegho tsasimmanyile bae, ila nitsa kubatitsa kwa ghamatsi, ili iwanu wa Isiraeli wammanye.” ");
INSERT INTO ruf_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Kuya Yohane kalapfa ukalangama, “Nimwona Ghumuhe Mwenzeluka kohulumka kulawa kulanga ka injiwa, kakala mchanya mwake. ");
INSERT INTO ruf_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nene tsasimmanyile bae, lekeni ayula iyanitumile kubatitsa kwa ghamatsi kanongela, ‘Imunu yutsomwona Ghumuhe Mwenzeluka komhulumkila na kukala mchanya mwake, ayo katsobatitsa kwa Ghumuhe Mwenzeluka.’ ” ");
INSERT INTO ruf_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Kuya Yohane kalonga, “Nichona chinu acho, na nene nowalongela ghendo, ayuno iyo yuyo Imwana we Imulungu.” ");
INSERT INTO ruf_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Litsuwa iliwinzile, Yohane tsakabahala keli ne iwanang'ina wake weli. ");
INSERT INTO ruf_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Hayamwonile Yesu koluta, kalonga, “Mlole! Imwana Ng'olo we Imulungu!” ");
INSERT INTO ruf_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Iwanang'ina weli hawamuhulike Yohane kolonga apfi, wamuwinza Yesu. ");
INSERT INTO ruf_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu kahunduka, kawona womuwinza, kawaghutsa, “Angu mbama choni?” Wedika, “Rabi, angu ukala kwani?” Rabi mana yake Mlangulitsi. ");
INSERT INTO ruf_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Kawedika, “Mtse mwone.” Waghenda, wona hanu hang'ali yokala Yesu. Tsaikala ka saa kumi nemihe. Nawo wakala na Yesu nemihe yose ila. ");
INSERT INTO ruf_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andereya, ndughu yake Simoni Petiri, kakala yumwe mna iwanu iwahulike achila chayalongile Yohane, na iwamuwinzile Yesu. ");
INSERT INTO ruf_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Bahala, Andereya kambama ndughu yake Simoni, kamlongela, “Tumwona Mkombotsi iyasaghulighwe ne Imulungu!” Ayo iyo Kiristu. ");
INSERT INTO ruf_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Kuya Andereya kamsola Simoni kamghala kwa Yesu. Yesu kamlola kalonga, “Ghweghwe kwa Simoni imwana wa Yohane. Kutsokemighwa Kefa.” Kefa kwa Chigiriki Petiri, Petiri mana yake bambalawe. ");
INSERT INTO ruf_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","L itsuwa liwinzile Yesu kalamla kughenda Galilaya. Kamwona Filipi, kamlongela, “Niwinze!” ");
INSERT INTO ruf_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipi, tsakakala imunu wa isi ya Betisaida, isi yawang'ali wokala Andereya na Petiri. ");
INSERT INTO ruf_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipi kamwona Nasanaeli, kamlongela, “Tumwona imunu yula iyandikighwe mbuli tsake na Musa mne chitabu cha Ghamalaghitso, pfipfila manabii wandika mbuli tsake. Ayo iyo Yesu wa Natsareti, imwana wa Yosefu.” ");
INSERT INTO ruf_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nasanaeli kaghutsa, “Apfi yodahika ichinu chochose chinoghile chilawile Natsareti?” Filipi kamwidika, “Utse wone.” ");
INSERT INTO ruf_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu hamwonile Nasanaeli komtsila, kalonga, “Ayuno ka Muisiraeli ghendo, mghati mwake mduhu ughutsu.” ");
INSERT INTO ruf_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nasanaeli kamghutsa, “Angu unimanyiletse?” Yesu kamwidika, “Ng'ana Filipi yakukeme, tsanikwona haukalile hasi mwe mkuyu.” ");
INSERT INTO ruf_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Kuya Nasanaeli kalonga, “Mlangulitsi, ghweghwe kwa Imwana we Imulungu! Ghweghwe kwa Imndewa wa Isiraeli!” ");
INSERT INTO ruf_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu kalonga, “Kwotoghola kwaapfila tsanikulongela nikwona kukala hasi he mkuyu? Kutsakwona makulu kubita agho.” ");
INSERT INTO ruf_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Kuya kaghendelela kuwalongela, “Nolongesa ghendo, mtsakona lilanga lyopfughuka ne wamalaika we Imulungu wogheluka na kuhulumka mchanya mwe Imwana we Imunu.” ");
INSERT INTO ruf_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Litsuwa lya kadatu hambele, tsakukala ne ichihungo cha ukukwela ako Kana mne isi ya Galilaya. Na mai wake Yesu tsakabaho. ");
INSERT INTO ruf_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesu ne iwanang'ina wake pfipfila tsawakemighwa mne ichihungo acho. ");
INSERT INTO ruf_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Idipfai haimalile, mai wake kamlongela, “Wahela idipfai.” ");
INSERT INTO ruf_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu kamwidika, “Mai, uleke kunongela cho kutenda isaa yangu ng'ana ipfike bae.” ");
INSERT INTO ruf_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Mai wake Yesu kawalongela iwatumwa, “Mtende chochose chowalongelani.” ");
INSERT INTO ruf_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Baho tsahana mabigha sita gha ghamatsi, ighekighwe kwaajili ye ichihendo cha Wayahudi cha ukwihopfugha. Chila bigha lyodaha kumema pfiya ishilini mbaka selasini. ");
INSERT INTO ruf_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu kawalongela iwatumwa, “Mghamemetse ghamabigha ghamatsi.” Nawo waghamemetsa. ");
INSERT INTO ruf_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Kuya kawalongela, “Mdeghe, mmwing'e imkulu we ichihungo.” Nawo watenda ka pfawalongele, ");
INSERT INTO ruf_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","nae imkulu we ichihungo kalanza ghamatsi ighaghaluke idipfai. Ng'amanyile bae kwailawile, lekeni iwatumwa iwadeghile ghamatsi tsawamanya. Kuya imkulu ayo kamkema imunu iyokwela hambalimbali, ");
INSERT INTO ruf_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","kamlongela, “Chila imunu tanu kolapfa idipfai inoghile. Kuya wahenza hawomalitsa kunwa ng'ani, kolapfa idipfai ihile. Lekeni ghweghwe kuika idipfai inoghile mbaka sambi!” ");
INSERT INTO ruf_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesu katenda chinu chino cha kukangawatsa cha mwanduso ako Kana, mne isi ya Galilaya. Ako kalangusa utunitso wake, ne iwanang'ina wake wamtoghola. ");
INSERT INTO ruf_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Hambele Yesu na mai wake, hamwe na ndughu tsake ne iwanang'ina wake wahulumka Kaperinaumu. Wakala ako matsuwa chidogho. ");
INSERT INTO ruf_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ipasaka ya Wayahudi haikalile habehi, Yesu kagheluka Yerusalemu. ");
INSERT INTO ruf_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Mne Ing'anda ye Imulungu, Yesu kawapfika iwanu woutsa wang'ombe, iwang'olo ne iwanjiwa, ne iwanu wangi wakala hane tsimetsa wobena tsisendi. ");
INSERT INTO ruf_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yesu kabota ichiboko che lutsabi, kawawinga iwanu wose mne Ing'anda ye Imulungu, hamwe ne iwang'olo ne wang'ombe. Pfipfila katsibidula tsimetsa tse iwobena tsisendi na kutsipwililisa sendi tsawo. ");
INSERT INTO ruf_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Kuya kawalongela iwanu iwang'ali woutsa iwanjiwa, “Pfilapfeni hano pfinu pfino! Ule ing'anda ye Aba wangu mwoitenda ghulilo?” ");
INSERT INTO ruf_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Iwanang'ina wake wakumbuka ichandikighwe, “Imulungu, unoghelo wangu kwe ing'anda yako wakwaka mghati mwangu ka ghumoto.” ");
INSERT INTO ruf_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Kuya iwakulu wa Wayahudi wamghutsa Yesu, “Apfi kwodaha kutenda chinu chachi cha kukangawatsa kutulangusa ka kuna uwetso wa ukutenda agha ghose?” ");
INSERT INTO ruf_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu kawedika, “Muimwaghe Ing'anda ino ye Imulungu, nene nitsoitsenga keli kwa ghamatsuwa madatu!” ");
INSERT INTO ruf_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Wayahudi wamwidika, “Ing'anda ino ye Imulungu itsengighwa kwa miyaka alubaini na sita, naghwe utsoitsengatse kwa matsuwa madatu?” ");
INSERT INTO ruf_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Lekeni Ing'anda ye Imulungu iyang'ali yoilonga Yesu tsaikala ulukuli lwake. ");
INSERT INTO ruf_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Apfo, hayatsilihuke, iwanang'ina wake wakumbuka achila chayalongile. Kuya waghatoghola Ghamaandiko Mahenzeluka na watoghola mbuli tsila tsayalongile Yesu. ");
INSERT INTO ruf_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesu hayang'ali Yerusalemu mne Ichihungo che Ipasaka, iwanu wangi wona pfinu pfa kukangawatsa pfayang'ali yotenda, wamtoghola. ");
INSERT INTO ruf_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Lekeni Yesu tsang'awatoghole bae, kwaapfila tsakawamanya iwanu wose. ");
INSERT INTO ruf_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ng'abamile bae imunu wowose amlongele mbuli tse iwanu, kwaapfila Yesu tsakamanya ighali mghati mwe imimoyo yawo. ");
INSERT INTO ruf_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Tsakukala ne imkulu yumwe wa Mafarisayo, imunu we libalatsa lya Wayahudi iyakemighwe Nikodemu. ");
INSERT INTO ruf_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Chilo chimwe, kamghendela Yesu, kamlongela, “Mlangulitsi, twokumanya ghweghwe kwa mlangulitsi yulawile kwe Imulungu. Kwaapfila kuduhu imunu wowose iyodaha kutenda pfinu pfa kukangawatsa pfautenda ka Imulungu ng'ali hamwe naye bae.” ");
INSERT INTO ruf_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu kamwidika, “Nokulongela ghendo, kuduhu imunu iyodaha kuwona undewa we Imulungu ka ng'elekighwe lwa keli.” ");
INSERT INTO ruf_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemu kamghutsa, “Apfi imunu imbala yodahatse kwelekighwa keli? Ng'aidahika ghendo imunu kwingila munda mwa mai wake na kwelekighwa keli!” ");
INSERT INTO ruf_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu kamwidika, “Nokulongela ghendo, kuduhu imunu iyodaha kwingila mne undewa we Imulungu ka ng'elekighwe bae kwa ghamatsi na kwa Ghumuhe Mwenzeluka. ");
INSERT INTO ruf_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Imunu kakwelekighwa kwa lukuli kulawa kwa aba wake na mai wake, ila kakwelekighwa kwa muhe kulawa kwa Ghumuhe. ");
INSERT INTO ruf_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Uleke kukangawala kwaapfila nokulongela wose mwobamighwa mwelekighwe keli. ");
INSERT INTO ruf_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Libeho lyoduma kokose kwalibama, kohulika litsi lyake. Lekeni ng'umanya bae kwalilawile kwani wala kwalighenda kwani. Apfi pfipfo pfaili kwa chila imunu yelekighwe na Ghumuhe.” ");
INSERT INTO ruf_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemu kamghutsa, “Angu ghano ghodahatse kulawila?” ");
INSERT INTO ruf_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu kamwidika, “Ghweghwe kwa mlangulitsi mkulu wa Waisiraeli, angu naghwe ng'utsimanyile bae mbuli tsino? ");
INSERT INTO ruf_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nokulongela ghendo, twolonga ipfinu pfatumanya na twowalongela ipfinu pfatwonile, lekeni mng'ali mwolema usenga wetu. ");
INSERT INTO ruf_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ng'amtoghole bae haniwalongele mbuli tse ipfinu ipfili muisi, apfi mtsotogholatse ning'awalongela mbuli tse ipfinu ipfili kulanga?” ");
INSERT INTO ruf_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Kuduhu imunu iyaghendile kulanga ila Imwana we Imunu, iyatsile kulawa kulanga. ");
INSERT INTO ruf_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ka Musa pfayachinule ichinyagho chila che inzoka kwa lubiki kunyika, pfipfila Imwana we Imunu kobamighwa yenulighwe, ");
INSERT INTO ruf_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ili chila imunu iyomtoghola awe ne ughima wa ghamatsuwa ghose. ");
INSERT INTO ruf_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kwaapfila Imulungu tsakainoghela isi yose mbaka kamlapfa Imwanaghe nyalimwe, ili chila imunu iyomtoghola aleke kwagha ila yawe na ughima wa ghamatsuwa ghose. ");
INSERT INTO ruf_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kwaapfila Imulungu ng'amtumile bae Imwanaghe muisi, yaihighe, ila yaikombole kubitila yeye. ");
INSERT INTO ruf_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Imunu wowose iyomtoghola ng'atsohighighwa bae, lekeni imunu wowose iyolema kumtoghola ayo ma kahighighwa, kwaapfila ng'amtoghole bae Imwana nyalimwe we Imulungu. ");
INSERT INTO ruf_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Apfi pfipfo pfamtsohighighwa, Ghumwanga ghutsa muisi, lekeni iwanu wanoghela ichisi kubita ghumwanga, kwaapfila ghawotenda gheha. ");
INSERT INTO ruf_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Iwanu wose iwotenda ghehile woghuhila ghumwanga, ng'awakutsa bae mne ghumwanga, kwaapfila wopfuka aghala ghehile ghawotenda ghatsakoneka. ");
INSERT INTO ruf_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Lekeni awala iwotenda ghanoghile wakutsa mne ghumwanga, ili aghala ghawotenda ghoneke mwatsi ka ghatendighwa kwa kumuhulikitsa Imulungu. ");
INSERT INTO ruf_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Hambele Yesu ne iwanang'ina wake waghenda mne isi ya Yudeya, ako kakala nawo, na tsakawabatitsa iwanu. ");
INSERT INTO ruf_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Pfipfila Yohane yang'ali yobatitsa Ainoni habehi ne Salemu, kwaapfila hanu aho tsahana ghamatsi mengi. Iwanu wang'ali womghendela, naye yang'ali yowabatitsa. ");
INSERT INTO ruf_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ghamatsuwa agho Yohane tsakakala ng'ana yohighwe mchifungo. ");
INSERT INTO ruf_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Iwanang'ina wangi wa Yohane na Myahudi yumwe wang'ali weghutsaghutsa kwa mbuli ya ukuhopfugha ghamaghulu na ghamoko. ");
INSERT INTO ruf_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Apfo wamghendela Yohane, wamlongela, “Mlangulitsi, imunu yula iyakalile naghwe kumwambu kwe tsiwa Yoridani, ayula yutulongele mbuli tsake, sambi kobatitsa na iwanu wose womghendela.” ");
INSERT INTO ruf_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohane kawedika, “Kuduhu imunu iyodaha kubokela ichinu ka ng'eng'ighwe bae ne Imulungu iyali kulanga. ");
INSERT INTO ruf_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mwemwe iwenyegho mwa iwakalangama haniwalongele, ‘Nene si Kiristu Mkombotsi bae, ila nene nitumighwa nimlongole.’ ");
INSERT INTO ruf_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Iyali na pinga iyokwelighwa, ayo iyo immale iyomkwela. Sale wake immale iyokwela kombeta na komtegheletsa, kodeng'elela hayohulika litsi lyake. Sambi ndeng'elo yangu itimila. ");
INSERT INTO ruf_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yeye kobamighwa awe mkulu, nene nobamighwa niwe mdodo.” ");
INSERT INTO ruf_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ayula iyolawila kulanga ka mkulu kubita wose. Imunu wa iisi kolawa muisi, na kolonga mbuli tse isi, ila iyolawila kulanga ka mkulu kubita wose. ");
INSERT INTO ruf_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Yeye kolonga chayonile na chayahulike, lekeni kuduhu imunu iyotoghola mbuli tsalongile. ");
INSERT INTO ruf_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Lekeni imunu wowose iyotoghola usenga wake, katsolonga Imulungu kolongesa. ");
INSERT INTO ruf_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Iyatumighwe ne Imulungu kolonga mbuli tse Imulungu, kwaapfila Imulungu kommemesa Ghumuhe ghwake Mwenzeluka. ");
INSERT INTO ruf_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Aba komnoghela Imwanaghe na kagheka ghose mmoko mwake. ");
INSERT INTO ruf_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Imunu wowose iyomtoghola Imwana kakuwa ne ughima wa matsuwa ghose, lekeni imunu wowose iyomlema Imwana ng'atsakuwa ne ughima bae, ila katsokala mne maya ye Imulungu. ");
INSERT INTO ruf_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Mafarisayo tsawahulika ka Yesu yang'ali yowatenda iwanu wengi wawe iwanang'ina na kuwabatitsa kubita Yohane, ");
INSERT INTO ruf_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","lekeni Yesu ng'abatitse bae iwanu, ila iwanang'ina wake iwo iwabatitse. ");
INSERT INTO ruf_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yesu hayahulike apfi, kalawa Yudeya koya Galilaya, ");
INSERT INTO ruf_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","mne ghumwanza ghwake tsakabamighwa kubitila Samariya. ");
INSERT INTO ruf_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Tsakapfika Samariya hanu hakemighwe Sikari, habehi na mghunda ghula Yakobu ghwamwing'ile Yosefu, imwanaghe. ");
INSERT INTO ruf_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Baho tsakukala na chisima cha Yakobu, kwaapfila Yesu tsakepfa kwa ghumwanza ghwake, apfo kakala hasi habehi ne chisima. Tsaikala nemisi. ");
INSERT INTO ruf_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ipinga yumwe Msamariya tsakatsa kudegha ghamatsi, Yesu kamlongela, “Ungaye ghamatsi nuwe.” ");
INSERT INTO ruf_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Iwanang'ina wake tsawaghenda mkaye kughula ichijo. ");
INSERT INTO ruf_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ipinga ayo kamwidika, “Ghweghwe kwa Myahudi, nene na Msamariya. Ule kwonomba ghamatsi?” Tsakalonga apfi kwaapfila Wayahudi na Wasamariya ng'awajagha hamwe bae. ");
INSERT INTO ruf_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu kamwidika, “Ung'amanyile ichinu chayolapfa Imulungu na nani iyokulomba ghamatsi gho ukunwa, ung'amlombile, naye ang'akwing'ile ghamatsi ighoghala ughima.” ");
INSERT INTO ruf_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ipinga ayo kalonga, “Imtwatsa, kwahela chinu cha kudeghela ghamatsi, ne chisima chighendesa. Lelo utsoghapata kwani ghamatsi ghe ughima? ");
INSERT INTO ruf_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Apfi ghweghwe kwa mbala kubita aba wetu Yakobu iyatwing'ile chisima chino, yeye mwenyegho ne iwanaghe ne iwanyama wake tsawanwa ghamatsi ghe chisima chino?” ");
INSERT INTO ruf_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu kamwidika, “Imunu wowose iyakunwa ghamatsi ghano, katsakona ng'ilu keli, ");
INSERT INTO ruf_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","lekeni imunu wowose iyakunwa ghamatsi ghanimwing'a nene, ng'atsakona ng'ilu keli. Ghamatsi ghanimwing'a nene ghatsakuwa mbwibwi iilapfa ghamatsi gha ughima mghati mwake na ghatsomwing'a ughima wa ghamatsuwa ghose.” ");
INSERT INTO ruf_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ipinga ayo kamlongela, “Mtwatsa ngaya ghamatsi agho ndeke kwona ng'ilu keli, kuya ndeke kutsa hano keli kudegha ghamatsi.” ");
INSERT INTO ruf_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu kamlongela, “Ghenda ukamkeme mmale wako, utse naye.” ");
INSERT INTO ruf_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ipinga ayo kamwidika, “Nahela mmale.” Yesu kamlongela, “Kolonga ghoya haulonga kwahela mmale. ");
INSERT INTO ruf_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Kwaapfila tsakukwelighwa ne iwamale watano, na mmale yauli naye sambi si mmale wako bae. Chaulongile kulongesa ghendo.” ");
INSERT INTO ruf_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ipinga ayo kalonga, “Imtwatsa, nakwona ghweghwe kwa nabii. ");
INSERT INTO ruf_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Iwabala wetu tsawamtamanila Imulungu hane lughongo luno, lekeni mwemwe Wayahudi mwolonga twobamighwa tumtamanile Imulungu ako Yerusalemu.” ");
INSERT INTO ruf_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu kamlongela, “Mai utoghole, ghamatsuwa ghakutsa iwanu ng'awatsomtamanila bae Aba hane lughongo luno wala ako Yerusalemu. ");
INSERT INTO ruf_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mwemwe Wasamariya ng'amummanyile bae yamumtamanila, lekeni twetwe Wayahudi twommanya yatumtamanila, kwaapfila ukombotsi wolawa kwa Wayahudi. ");
INSERT INTO ruf_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Lekeni matsuwa ghakutsa na sambi ghabaha iwanu iwotamanila kweli watsomtamanila Aba kwa kulongotsighwa na Ghumuhe na kweli, kwaapfila womtamanila ka Aba pfayobama. ");
INSERT INTO ruf_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Imulungu ka Ghumuhe, apfo iwanu wake iwomtamanila wamtamanile kwa Ghumuhe na ukweli.” ");
INSERT INTO ruf_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ipinga ayo kamlongela, “Nomanya Masiya iyokemighwa Kiristu kakutsa, na hatsakutsa katsotulongela ghoya chila chinu.” ");
INSERT INTO ruf_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu kamwidika, “Nene yanilonga naghwe, iyo yuyo.” ");
INSERT INTO ruf_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Iwanang'ina wake Yesu tsawoya, wakangawala kumpfika Yesu kolonga ne ipinga ayo. Lekeni kuduhu imunu yamghutsile, “Apfi ubama choni?” au “Ule ulonga ne ipinga?” ");
INSERT INTO ruf_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Kuya ipinga ayo kachileka chiha chake cha ghamatsi, koya ukaye, kawalongela iwanu, ");
INSERT INTO ruf_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Mtse mmwone imunu iyanongele ipfinu pfose pfanendile. Apfi ayu kodaha kuwa Kiristu?” ");
INSERT INTO ruf_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Apfo iwanu walawa mkaye mwao wamghendela Yesu. ");
INSERT INTO ruf_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ichipindi chichila iwanang'ina wake wang'ali womlomba Yesu, “Mlangulitsi tanu diya!” ");
INSERT INTO ruf_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Lekeni Yesu kawedika, “Nene nina ichijo ing'amchimanyile bae.” ");
INSERT INTO ruf_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Kuya iwanang'ina wake wandusa kwighutsa, “Pfii hana munu iyamghalile chijo?” ");
INSERT INTO ruf_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu kawalongela, “Ichijo changu chicho chino, kusang'ana aghala ghayobama iyanitumile na kuimalitsa ing'onde yangaile niisang'ane. ");
INSERT INTO ruf_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Mwemwe mwolonga, ‘Ing'ali miyetsi mine, kuya ghamatsuwa gha mapfuno ghopfika.’ Nowalongela, mwinule tsinenge mlole imighunda! Ghamatsawo ghakomala, ghobamighwa ghapfunighwe! ");
INSERT INTO ruf_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Imunu iyopfuna kobokela maliho na kolunda hamwe ghamatsawo kwaajili ya ughima wa matsuwa ghose, ili imunu iyohanda na imunu iyopfuna wadeng'elele hamwe. ");
INSERT INTO ruf_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Iwanu hawolonga, ‘Yumwe kohanda, yungi kopfuna’ wolongesa. ");
INSERT INTO ruf_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nimtumani kupfuna mne imighunda yang'amlimile bae, iwanu wangi wasang'ana namwe mwobweda kwa isang'ano yawo.” ");
INSERT INTO ruf_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Wasamariya wengi wa kaye ila wamtoghola Yesu kwa achila chalongile ipinga ayo, “Kanongela ipfinu pfose pfanendile.” ");
INSERT INTO ruf_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Apfo Wasamariya wamghendela Yesu, wamlomba akale nawo, Yesu kakala nawo matsuwa meli. ");
INSERT INTO ruf_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Iwanu wengi tsawatoghola kwa mbuli tsa Yesu. ");
INSERT INTO ruf_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Wamlongela ipinga ayo, “Sambi tutoghola, si kwa achila chulongile bae, ila kwaapfila twetwe iwenyegho tumuhulika, twomanya imunu yuno kweli ka Mkombotsi we iisi yose.” ");
INSERT INTO ruf_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Haghamalile matsuwa meli Yesu kaghenda Galilaya. ");
INSERT INTO ruf_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Kwaapfila Yesu imwenyegho tsakalonga, “Nabii ng'otogholighwa bae mne isi yake.” ");
INSERT INTO ruf_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Yesu hapfikile Galilaya, iwanu wambokela kwaapfila nawo tsawaghenda mne Ichihungo cha Ipasaka ako Yerusalemu, na waghona ghose ghatendile Yesu mne ichihungo acho. ");
INSERT INTO ruf_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Kuya Yesu kengila keli mne ghumji ghwa Kana ako Galilaya, hanu haghaluse ghamatsi kuwa idipfai. Baho tsakukala ne chilongotsi yane imwana iyoghula ako Kaperinaumu. ");
INSERT INTO ruf_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Chilongotsi ayo hayahulike Yesu kapfika ako Galilaya kulawa Yudeya, kamghendela kamlomba aghende akamhonetse imwanaghe, iyang'ali habehi ukufa. ");
INSERT INTO ruf_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu kamlongela, “Mwemwe ng'amtoghola mbaka mwone ipfitango na pfihulo.” ");
INSERT INTO ruf_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Chilongotsi ayo kamwidika, “Mtwatsa tuke ng'ana mwanangu yafe.” ");
INSERT INTO ruf_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu kamwidika, “Ghweghwe ghenda, imwanagho katsohona.” Chilongotsi ayo katoghola chalongile Yesu, koka ukaye. ");
INSERT INTO ruf_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Hang'ali mnzila, ketingana ne iwatumwa wake, wamlongela imwanaghe kahona. ");
INSERT INTO ruf_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Kawaghutsa, “Imwana handuse kuhona saa ngapi?” wamwidika, “Ligholo saa saba nemisi.” ");
INSERT INTO ruf_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Kuya aba ayo tsakamanya ka isaa iila Yesu yamlongele, “Imwanagho katsohona.” Apfo yeye na kaye yake wamtoghola Yesu. ");
INSERT INTO ruf_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Apfino tsapfikala pfihulo pfa keli pfatendile Yesu halawile Yudeya kughenda Galilaya. ");
INSERT INTO ruf_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Hambele, Yesu kagheluka Yerusalemu kune ichihungo cha Wayahudi. ");
INSERT INTO ruf_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ako Yerusalemu, habehi na libani likulu ilikemighwe Libani lye Iwang'olo tsahana tsimbu ilikemighwe Betisada kwa Chihebulaniya, tsimbu alyo tsa lya habehi na pfibwalu pfitano. ");
INSERT INTO ruf_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Iwanu wengi iwatamu tsawakala mne pfibwalu apfo, pfifita, pfimbete, ne iwanu iwaholole. Tsawang'ali wobeta ghamatsi ghatibuke, ");
INSERT INTO ruf_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","kwaapfila malaika we Imtwatsa ang'ali yohulumkagha mne ghamatsi na kughatibula. Imtamu iyakwandusa kwingila mne ghamatsi ighatibulighwe, tsakahonetsighwa utamu wowose iyali nawo. ");
INSERT INTO ruf_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Imunu yumwe iyakalile hala, tsakakala mtamu kwa miyaka selasini na nane. ");
INSERT INTO ruf_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu hamwonile mtamu ayo kawasa hala, tsakamanya ka yang'ali yoghula kwa matsuwa mengi, apfo kamghutsa mtamu ayo, “Pfii kwobama uhone?” ");
INSERT INTO ruf_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Mtamu yula kamwidika, “Mtwatsa, nahela imunu wa kunyingitsa mne litsimbu ghamatsi haghotibulighwa. Hanibama kwingila, imunu yungi konongolela.” ");
INSERT INTO ruf_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Kuya Yesu kamlongela, “Winuke! Sola chilagho chako uke.” ");
INSERT INTO ruf_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Bahala imunu yula kahona, kasola chilagho chake, koka. Ichinu chino tsachilawila mne Litsuwa lye Sabato, ");
INSERT INTO ruf_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","apfo Iwakulu wa Wayahudi wamlongela imunu yahonile, “Leloli Litsuwa lya Sabato, ghamalaghitso ghoghoma kuchighala chilagho chako.” ");
INSERT INTO ruf_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Lekeni imunu ayo kawedika, “Imunu iyanihonetse kanongela, ‘Sola chilagho chako uke.’ ” ");
INSERT INTO ruf_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Wamghutsa, “Angu munu wachi iyakulongele usole chilagho chako uke?” ");
INSERT INTO ruf_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Lekeni ng'ammanyile bae imunu iyamuhonetse kwaapfila iwanu tsawengi na Yesu ma tsakoka. ");
INSERT INTO ruf_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Hambele Yesu kampfika imunu yula mne Ing'anda ya Ukulombela, kamlongela, “Tegheletsa, sambi kuhona. Uleke kutenda nzambi, ung'atenda nzambi, ichinu chihile chitsokulawila.” ");
INSERT INTO ruf_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Kuya imunu yula koka, kawalongela iwakulu wa Wayahudi ka yamuhonetse Yesu. ");
INSERT INTO ruf_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Kwaapfila Yesu yang'ali yotenda ipfinu pfino mne Litsuwa lya Sabato, Wayahudi wandusa kumhila. ");
INSERT INTO ruf_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesu kawalongela, “Aba wangu kosang'ana ghamatsuwa ghose, na nene pfipfila nobamighwa nisang'ane.” ");
INSERT INTO ruf_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Apfo Wayahudi wabama wamkome Yesu. Tsawabama wamkome Yesu si kwaapfila kalibetsa Litsuwa lya Sabato liliheka, ila tsakamkema Imulungu Aba wake, apfo ketenda keghala ne Imulungu. ");
INSERT INTO ruf_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesu kawedika, “Nowalongela ghendo, Imwana ng'odaha bae kutenda chinu chochose yaliyeka, Imwana kodaha kutenda aghala ghomwona Aba wake koghatenda, kwaapfila ghoghose ghotenda Aba, Imwana naye koghatenda. ");
INSERT INTO ruf_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Kwaapfila Aba komnoghela Imwana na komlangusa ghose ghayotenda. Kuya katsomlangusa ipfinu pfikulu pfa kusang'ana kubita pfino, namwe mtsokangawala. ");
INSERT INTO ruf_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ka Aba pfayowatsilihula iwanu iwafile na kuweng'a ughima, pfipfila Imwana kolapfa ughima kwe iwanu iyowabama. ");
INSERT INTO ruf_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Aba ng'omuhigha bae imunu wowose, lekeni kamwing'a Imwanaghe uwetso wa kuhigha, ");
INSERT INTO ruf_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ili iwanu wose wamuhulikitse Imwana ka pfawomuhulikitsa Aba. Imunu wowose iyolema kumuhulikitsa Imwana komlema Aba iyamtumile. ");
INSERT INTO ruf_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Nowalongela ghendo, imunu wowose iyohulika mbuli yangu na kumtoghola ayula iyanitumile kana ughima wa ghamatsuwa ghose, ng'atsohighighwa kwaapfila kaloka lifwa kengila mne ughima. ");
INSERT INTO ruf_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nowalongela ghendo, litsuwa lyakutsa na sambi ma lipfika iwanu iwafile hawatsohulika litsi lye Imwana we Imulungu, na awala iwahulike watsakuwa waghima. ");
INSERT INTO ruf_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ka Aba imwenyegho pfayali mwanduso we ighima, pfipfila kamtenda Imwanaghe kuwa mwanduso we ughima. ");
INSERT INTO ruf_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Kamwing'a imwana uwetso wa kuhigha, kwaapfila ka Imwana we Imunu. ");
INSERT INTO ruf_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mleke kukangawala mbuli ino, litsuwa lyakutsa iwanu iwafile hawatsohulika litsi lyake, ");
INSERT INTO ruf_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","watsolawa mne tsikabuli tsawo, awala iwatendile ghanoghile watsotsilihulighwa wawe waghima, na iwatendile ghehile watsotsilihulighwa wahighighwe. ");
INSERT INTO ruf_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nene sidaha bae kutenda ichinu imwenyegho, nohigha ka Imulungu pfonongela, nohigha kwa haki, kwaapfila sitenda bae chanibama, ila notenda achila chobama ayula iyanitumile. ");
INSERT INTO ruf_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Ning'alonga mbuli tsangu imwenyegho, ukalangama wangu wa ughutsu. ");
INSERT INTO ruf_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Lekeni kuna yungi iyolonga mbuli tsangu, nomanya chila chinu chalongile kalongesa. ");
INSERT INTO ruf_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mwemwe tsamuwatuma iwanu kwa Yohane, na mbuli tsangu tsalongile tsolongesa. ");
INSERT INTO ruf_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Sibama bae ukalangama we imunu, ila nolonga apfi ili mwemwe mkombolighwe. ");
INSERT INTO ruf_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohane tsakakala ka ichitasa, iching'ali chikwaka na chomwemwesa, namwe msaghula ghamatsuwa chidogho kudeng'elela ghumwanga ghwake. ");
INSERT INTO ruf_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nina ukalangama mkulu kubita wa Yohane. Kwaapfila ing'onde iyangaile Aba niimalitsa, isang'ano yanisang'ana, yolangusa Aba kanituma. ");
INSERT INTO ruf_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Aba imwenyegho iyanitumile kalonga mbuli tsangu. Ng'amuhulike bae litsi lyake wala kuchona chihanga chake, ");
INSERT INTO ruf_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","na mbuli yake ng'aikala bae mghati mwenu, kwaapfila ng'amumtoghole yula iyamtumile. ");
INSERT INTO ruf_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mwosoma Ghamaandiko Mahenzeluka, kwaapfila mwopfikitsa mne Ghamaandiko Mahenzeluka mtsopata ughima wa ghamatsuwa ghose. Ghamaandiko ghagho Mahenzeluka gholonga mbuli tsangu! ");
INSERT INTO ruf_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Lekeni mng'ali mwolema kunitsila muwe na ughima. ");
INSERT INTO ruf_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Sibama bae iwanu wanitunye. ");
INSERT INTO ruf_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Lekeni nommanyani ka mwahela unoghelo we Imulungu mne imimoyo yenu. ");
INSERT INTO ruf_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nitsa kwa taghwa lya Aba wangu, ng'amnitoghole bae, lekeni imunu yungi ang'atsa kwa taghwa lyake, mtsombokela. ");
INSERT INTO ruf_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Apfi mtsodahatse kunitoghola, ka mwemwe mwobama kubokela utunitso kulawa kuna mwemwe iwenyegho, lekeni mwolema kubokela utunitso iulawa kwe Imulungu yaliyeka? ");
INSERT INTO ruf_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Mleke kupfikitsa nitsowalongeletsa kwa Aba. Musa iyammwikile lolelo lyenu, ayo yuyo iyatsomuhighani. ");
INSERT INTO ruf_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mng'amtoghole Musa, mng'anitoghole na nene, kwaapfila tsakandika mbuli tsangu. ");
INSERT INTO ruf_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Lekeni ka ng'amchitoghola achila chandikile, apfi mtsotogholatse chanilonga?” ");
INSERT INTO ruf_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Hambele Yesu kaloka kumwambu mwa tsimbu Galilaya au tsimbu Tiberiya. ");
INSERT INTO ruf_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Likingili lye iwanu limuwinza Yesu kwaapfila tsawona pfihulo pfayatendile pfa kuwahonetsa iwatamu. ");
INSERT INTO ruf_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Kuya Yesu ne iwanang'ina wake wagheluka mchidunda, wakala hasi. ");
INSERT INTO ruf_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ichihungo che Ipasaka ya Wayahudi tsachikala chahabehi. ");
INSERT INTO ruf_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesu hayalolile mmbalimbali kona mtingano mkulu ghwe iwanu womtsila, kamghutsa Filipi, “Kwani twodaha kughula ichijo tuweng'e iwanu wano waje?” ");
INSERT INTO ruf_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesu kaghutsa pfino kumghetsa Filipi, kwaapfila tsakamanya katsotenda choni. ");
INSERT INTO ruf_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipi kamwidika, “Sendi miya mbili ng'atsidaha bae kumghulila chighate chila imunu!” ");
INSERT INTO ruf_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Imwanang'ina yungi wa Yesu, Andereya, ndughu yake Simoni Petiri, kamlongela Yesu, ");
INSERT INTO ruf_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Hano hana imsongolo yumwe, yane ipfihindi pfitano pfe pfighate ne iwasomba weli. Lekeni watsoghutatse kwe ipfijo pfino chidogho?” ");
INSERT INTO ruf_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu kawalongela iwanang'ina wake, “Muwalongele iwanu wakale hasi.” Hanu hala tsahana imitsani, iwanu wakala hasi, tsakukala ne iwamale elufu tano. ");
INSERT INTO ruf_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Kuya Yesu kasola ipfihande pfe pfighate, kalonga, “Mighede Imulungu,” kaweng'a iwanu iwakalile hasi. Katenda pfipfo kwa iwasomba ka iwanu pfawabamile. ");
INSERT INTO ruf_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Iwanu wose hawaghutile, Yesu kawalongela iwanang'ina wake, “Mdondole ipfihande ipfikalile. Chochose chileke ukwagha.” ");
INSERT INTO ruf_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Apfo iwanang'ina wadondola, wamemesa ipfiseghe kumi na pfili pfe ipfihande pfe pfighate ipfikalile. ");
INSERT INTO ruf_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Iwanu hawonile pfihulo ipfitendighwe na Yesu, wandusa kulonga, “Kweli ayuno ka nabii iyakutsa muisi.” ");
INSERT INTO ruf_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu tsakamanya iwanu wambama ghendo wamtende yawe imndewa, apfo kagheluka keli mchidunda yaliyeka. ");
INSERT INTO ruf_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Litsua haliswele, iwanang'ina wake Yesu wahulumka mbaka mne tsimbu, ");
INSERT INTO ruf_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","wadina mnumbwi waloka tsimbu waghenda Kaperinaumu. Tsakukala ne ichisi, na Yesu tsakakala ng'ana yawapfikile bae. ");
INSERT INTO ruf_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Libeho kulu ling'ali lyoduma na ghamatsi ghatibuka. ");
INSERT INTO ruf_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Iwanang'ina hawaghendile utali we maili ndatu au maili nne, tsawamwona Yesu koghenda mchanya mwe ghamatsi, kakutsa habehi na mnumbwi, iwanang'ina wapfuka. ");
INSERT INTO ruf_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Lekeni Yesu kawalongela, “Na nene, mleke kupfuka!” ");
INSERT INTO ruf_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Kuya wabama wamsole Yesu mne mnumbwi, bahala mnumbwi tsaghupfika hanu hawabamile kupfika. ");
INSERT INTO ruf_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Litsuwa lya keli kingili lye iwanu ilikalile kumwambu mwe tsimbu wamanya kukala na mnumbwi umwe uliyeka, Yesu ng'engile bae mne mnumbwi ne iwanang'ina wake, ila iwanang'ina tsawoka waliyeka. ");
INSERT INTO ruf_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kuya iminumbwi mingi ilawile Tiberiya tsaipfika habehi ne hanu iwanu hawajile pfighate Imtwatsa hayamalitse kupfibaliki. ");
INSERT INTO ruf_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Iwanu hawamanyile Yesu ne iwanang'ina wake ng'awalibaho bae hanu hala, wengila mne iminumbwi waghenda Kaperinaumu kumbama. ");
INSERT INTO ruf_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Iwanu hawamwonile Yesu ubali ungi we tsimbu, wamghutsa, “Mlangulitsi, apfi hano upfikile tsuwachi?” ");
INSERT INTO ruf_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu kawedika, “Nowalongelani ghendo, mwonibama kwaapfila mja pfighate mghuta, si kwaapfila mwona pfihulo pfangu. ");
INSERT INTO ruf_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mleke kuchisulukila ichijo ichikola, mchisulukile ichijo ichikala ghamatsuwa ghose. Ichijo chino chicho Imwana we Imunu yatsomwing'ani, kwaapfila Imulungu, Aba kamsaghula na kamtoghola.” ");
INSERT INTO ruf_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Kuya wamghutsa Yesu, “Apfi tutende choni ili tughatende aghala ghobama Imulungu tughatende?” ");
INSERT INTO ruf_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu kawedika, “Achino ichinu chayobama Imulungu mtende, mumtoghole ayula iyamtumile.” ");
INSERT INTO ruf_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Apfo wamghutsa, “Angu pfihulo pfachi pfausang'ana ili tupfone tukutoghole? Kutsotenda choni? ");
INSERT INTO ruf_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Iwabala wetu waja mana kunyika, ka pfayandikighwe mne Ghamaandiko Mahenzeluka, ‘Kaweng'a chighate ichihulumke kulanga waje.’ ” ");
INSERT INTO ruf_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesu kawalongela, “Nowalongela ghendo, si Musa bae iyaweng'ile chighate ichihulumke kulanga, ila Aba wangu iyo iyaweng'ile chighate che ukweli kulawa kulanga. ");
INSERT INTO ruf_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kwaapfila chighate chayotwing'a Imulungu iyo ayula iyakutsa kulawa kulanga na iyolapfa ughima kwe iwanu iwali muisi.” ");
INSERT INTO ruf_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Wamlongela, “Imtwatsa, utwing'e chighate chino ghamatsuwa ghose.” ");
INSERT INTO ruf_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Kuya Yesu kawalongela, “Nene na ichijo ichighala ughima, awala iwakutsa kuna nene ng'awatsokwona nzala bae, na awala iwonitoghola ng'awatsakwona ng'ilu bae. ");
INSERT INTO ruf_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ka pfaniwalongele, mmbona lekeni mng'ali ng'amnitoghola bae. ");
INSERT INTO ruf_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Wose iyongaya Aba watsakutsa kuna nene, imunu wowose iyonitsila, simuwinga bae. ");
INSERT INTO ruf_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kwaapfila nihulumka kulawa kulanga si kutenda pfanibama bae, ila kutenda pfayobama ayula iyanitumile. ");
INSERT INTO ruf_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ayula iyanitumile kobama apfi, ndeke kumwaghitsa imunu wowose mna iwanu wala iyangaile, ila niwatsilihule wose mna litsuwa lya usighilo. ");
INSERT INTO ruf_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kwaapfila Aba wangu kobama chila imunu iyomlola Imwana na kumtoghola yawe na ughima wa ghamatsuwa ghose. Nitsomtsilihula litsuwa lya usighilo.” ");
INSERT INTO ruf_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Wayahudi wandusa kumnung'unikila Yesu kwaapfila tsakalonga, “Nene na chighate ichihulumke kulawa kulanga.” ");
INSERT INTO ruf_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Walonga, “Apfi ayu si Yesu bae imwana wa Yosefu, aba wake ne mai wake twowamanya. Lelo kodahatse kulonga, ‘Nihulumka kulawa kulanga?’ ” ");
INSERT INTO ruf_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesu kawalongela, “Mleke kunung'unika. ");
INSERT INTO ruf_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Kuduhu imunu iyodaha kunitsila ka Aba iyanitumile ng'amkweghile bae, na nene nitsomtsilihula litsuwa lya usighilo. ");
INSERT INTO ruf_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Wanabii tsawandika, ‘Iwanu wose watsolangulitsighwa ne Imulungu.’ Chila imunu iyomtegheletsa Aba na kwilangulitsa kuna yeye katsokutsa kuna nene. ");
INSERT INTO ruf_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Chanilonga chicho chino, kuduhu imunu iyamwonile Aba ila yula iyalawile kwe Imulungu, ayo yuyo yaliyeka iyamwonile Aba. ");
INSERT INTO ruf_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nowalongela ghendo, imunu wowose iyotoghola kana ughima wa ghamatsuwa ghose. ");
INSERT INTO ruf_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nene na chijo ichighala ughima. ");
INSERT INTO ruf_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Iwabala wenu tsawaja mana kunyika lekeni wafa. ");
INSERT INTO ruf_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Lekeni achino ichighate ichihulumka kulawa kulanga, imunu iyochija ng'atsokufa bae. ");
INSERT INTO ruf_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nene na ichijo che ughima ichihulumke kulawa kulanga. Imunu ang'aja chijo chino, katsokala ghamatsuwa ghose. Chijo chino lukuli lwangu, nolulapfa ili iwanu we isi yose wawe ne ughima.” ");
INSERT INTO ruf_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Kuya Wayahudi wandusa kwighutsa kwa maya, “Apfi imunu yuno kodahatse kutwing'a lukuli lwake tuluje?” ");
INSERT INTO ruf_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesu kawalongela, “Nowalongela ghendo, ka ng'amkuja lukuli lwe Imwana we Imunu na kunwa idamu yake, ng'amtsokuwa ne ughima mghati mwenu. ");
INSERT INTO ruf_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Imunu wowose iyoluja lukuli lwangu na kunwa idamu yangu kana ughima wa ghamatsuwa ghose, nitsomtsilihula mne litsuwa lya usighilo. ");
INSERT INTO ruf_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kwaapfila lukuli lwangu ichijo cha kweli na idamu yangu chokunwa cha kweli. ");
INSERT INTO ruf_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Imunu wowose iyoluja lukuli lwangu na kunwa idamu yangu, ayo kokala mghati mwangu, na nene nokala mghati mwake. ");
INSERT INTO ruf_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Aba iyali mghima kanituma, na kwaajili ya Aba nene nokala, apfo imunu iyoluja lukuli lwangu katsokala kwaajili ya nene. ");
INSERT INTO ruf_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Achino chicho ichijo ichihulumke kulawa kulanga, si ka mana iwajile iwabala wenu, na ukufa. Lekeni imunu iyakuja chijo chino katsokuwa mghima ghamatsuwa ghose.” ");
INSERT INTO ruf_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu kaghalonga agho hayang'ali yolangulitsa mne ing'anda ye ukulombela ako Kaperinaumu. ");
INSERT INTO ruf_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Iwanu wengi iwamuwinzile Yesu hawahulike apfo, walonga, “Ghamalangulitso ghano makomu. Apfi yuhi iyodaha kughatoghola?” ");
INSERT INTO ruf_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Kuduhu imunu iyamlongele Yesu ichinu chawang'ali wonung'unika iwanang'ina wake, lekeni yeye tsakamanya, apfo kawaghutsa, “Ule ghamalangulitso ghano ghoghetsa ukutoghola kwenu? ");
INSERT INTO ruf_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Itsakuwatse ka mtsomwona Imwana we Imunu kakuya kulanga hanu hayakalile mwanduso? ");
INSERT INTO ruf_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ghumuhe we Imulungu kolapfa ughima, ngupfu tsa imunu ng'atsidaha chinu. Mbuli tsaniwalongele tsowaghalila muhe na ughima. ");
INSERT INTO ruf_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Hata apfo, wangi wenu mng'ali ng'amtoghola.” Kwaapfila Yesu tsakamanya kulawa mwanduso tsina nani ing'awotoghola na tsakamanya nani iyatsomhunduka. ");
INSERT INTO ruf_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Kuya Yesu kalonga keli, “Kwaajili ayo tsaniwalongela kuduhu imunu iyodaha kunitsila mbaka Aba yamtoghole.” ");
INSERT INTO ruf_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kulawa litsuwa lino iwanang'ina wake wengi woya kuchughu, ng'awamuwinzile keli. ");
INSERT INTO ruf_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yesu kawaghutsa iwanang'ina wake kumi na weli, “Pfii, namwe pfipfila mwobama kuka?” ");
INSERT INTO ruf_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simoni Petiri kamwidika, “Imtwatsa, tughende kwa nani? Ghweghwe kuna mbuli itsighala ughima wa ghamatsuwa ghose. ");
INSERT INTO ruf_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Twotoghola na twomanya ghweghwe kwa Mwenzeluka we Imulungu.” ");
INSERT INTO ruf_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Kuya Yesu kawedika, “Apfi siwasaghuleni mwemwe kumi na weli bae? Lekeni yumwe wenu ka Setani.” ");
INSERT INTO ruf_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yesu tsayang'ali yolonga mbuli tsa Yuda, imwana wa Simoni Isikarioti, yumwe we iwanang'ina wala kumi na weli, iyomhunduka Yesu hambele. ");
INSERT INTO ruf_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Hambele, Yesu kaghenda Galilaya, ng'abamile bae kughenda Yudeya, kwaapfila iwakulu we Wayahudi tsawabama wamkome. ");
INSERT INTO ruf_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Lekeni chihungo cha Wayahudi cha Ipfibumbulika haching'ali habehi, ");
INSERT INTO ruf_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ndughu tsake Yesu wamlongela, “Ulawe hano ughende Yudeya, ili iwanang'ina wako wone pfihulo pfausang'ana. ");
INSERT INTO ruf_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kuduhu imunu iyofisa aghala ghayotenda ka kobama yamanyike ne iwanu wangi. Kwaapfila ghweghwe kwotenda ipfinu pfino, wilanguse kwe iwanu we iisi yose.” ");
INSERT INTO ruf_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Mana hata iwandughu tsake ng'awamtoghole. ");
INSERT INTO ruf_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesu kawalongela, “Litsuwa lyangu linoghile ng'ana lipfike bae, ila kuna mwemwe chila litsuwa linogha. ");
INSERT INTO ruf_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Iwanu we isi ng'awodaha kuwahilani mwemwe, ila wonihila nene kwaapfila nolonga ka aghala ghawotenda gheha. ");
INSERT INTO ruf_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mghende mne Ichihungo. Nene sighenda bae mne Ichihungo acho, kwaapfila litsuwa lyangu ng'ana lipfike bae.” ");
INSERT INTO ruf_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Tsakalonga apfi, kuya kakala ako Galilaya. ");
INSERT INTO ruf_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Iwandughu tsake hawaghendile mne ichihungo, naye Yesu pfipfila kaghenda, lekeni ng'aghendile bae mwatsimwatsi, ila kaghenda chinyelenyele. ");
INSERT INTO ruf_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Mne ichihungo acho, iwakulu we Wayahudi wang'ali wombama Yesu, waghutsa, “Apfi yalikwani imunu yula?” ");
INSERT INTO ruf_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Mne likingili, iwanu wang'ali wenong'onetsa mbuli tsa Yesu. Iwanu wangi walonga, “Imunu yuno kanogha.” Wangi wedika, “Mbe, kowaghitsa iwanu.” ");
INSERT INTO ruf_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Lekeni kuduhu imunu iyadahile kulonga mbuli yoyose ya Yesu mwatsimwatsi, kwaapfila wawapfuka iwakulu wa Wayahudi. ");
INSERT INTO ruf_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ichihungo haching'ali habehi kumala Yesu kaghenda mne Ing'anda ye Imulungu, kandusa kulangulitsa. ");
INSERT INTO ruf_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Iwakulu we Wayahudi wakangawala, walonga, “Apfi imunu yuno aghapatiletse ghamalangulitso ghano, naye ng'asomile bae?” ");
INSERT INTO ruf_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesu kawedika, “Ghamalangulitso ghanilangulitsa si ghangu bae, ila gholawa kwa yula iyanitumile. ");
INSERT INTO ruf_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Imunu wowose ang'asaghula kutenda pfayobama Imulungu, katsomanya ka ghamalangulitso ghangu gholawa kwe Imulungu au nolonga kwa uwetso wangu imwenyegho. ");
INSERT INTO ruf_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Imunu iyolonga mbuli tsake kobama utunitso wake, lekeni imunu iyobama utunitso kwa yula iyamtumile ayo mwenyepfale, kuduhu ughutsu mna yeye. ");
INSERT INTO ruf_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Apfi Musa ng'aweng'ile bae Ghamalaghitso? Lekeni kuduhu imunu iyokinda Ghamalaghitso mna mwemwe. Ebali mwobama mng'ome?” ");
INSERT INTO ruf_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Likingili lye iwanu limwidika, “Ghweghwe kuna chinyamkela. Yuhi iyobama yakukome?” ");
INSERT INTO ruf_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu kawedika, “Tsanenda chihulo chimwe, namwe wose mkangawala. ");
INSERT INTO ruf_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Musa tsakamlaghitseni muwengitse ngoma iwanenu, hata ka si Musa bae ila iwabala wenu iwanduse ichinu acho, namwe mwomwingitsa ngoma imwana Litsuwa lya Sabato. ");
INSERT INTO ruf_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ka mwomwingitsa ngoma imwana Litsuwa lya Sabato ili kukindilisa Ghamalaghitso gha Musa, ebali mwakwona maya kwaapfila nimhonetsa imunu mne Litsuwa lya Sabato? ");
INSERT INTO ruf_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mleke kuhigha kwa kulola kuliheka, ila muhighe kwa haki.” ");
INSERT INTO ruf_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Iwanu wangi wa Yerusalemu wandusa kwighutsa, “Apfi si imunu yuno bae iwombama wamkome? ");
INSERT INTO ruf_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Lola hayuno! Kolonga mwatsimwatsi na iwanu ng'awomlongela ichinu bae. Pfii iwakulu wetu womanya ghendo ayu ka Kiristu? ");
INSERT INTO ruf_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kiristu hayatsakutsa kuduhu imunu iyatsomanya kolawila kwani, lekeni twetwe twomanya koyolawila imunu yuno.” ");
INSERT INTO ruf_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesu hayang'ali yolangulitsa mne Ing'anda ye Imulungu, kalonga kwa kukemelela, “Ona, mwonimanya na mwomanya kwonilawila. Sitsile bae kwa kubama imwenyegho, lekeni iyanitumile ka ukweli. Mwemwe ng'amummanyile bae, ");
INSERT INTO ruf_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","lekeni nene nommanya kwaapfila nolawila kuna yeye, naye kanituma.” ");
INSERT INTO ruf_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Kuya wabama kumghogha, lekeni kuduhu imunu iyagholose ghamoko ghake kumghogha, kwaapfila litsuwa lyake tsang'ana lipfike. ");
INSERT INTO ruf_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Lekeni iwanu wengi kulawa mne likingili wamtoghola walonga, “Kiristu hayatsakutsa, apfi katsotenda pfihulo pfingi kubita imunu yuno?” ");
INSERT INTO ruf_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Mafarisayo wahulika iwanu wonong'ona mbuli tsa Yesu. Apfo iwatambika wakulu na Mafarisayo wawatuma iwabetetsi we Ing'anda ye Imulungu kumghogha Yesu. ");
INSERT INTO ruf_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesu kawalongela, “Nokala namwe kwa matsuwa chidogho, kuya nitsoghenda kwa ayula iyanitumile. ");
INSERT INTO ruf_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mtsombama, lekeni ng'amtsombona bae, kwaapfila ng'amdaha bae kutsa hanu hanili.” ");
INSERT INTO ruf_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Wayahudi welongela, “Apfi imunu yuno katsoghenda kwani mbaka tuleke kumwona? Pfii katsoghenda mne kaye tsa Wagiriki iwokala iwanu wetu na kuwalangulitsa Wagiriki? ");
INSERT INTO ruf_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Apfi kana mana yachi hayalongile ‘Mtsonibama, lekeni ng'amtsombona’ na ‘ng'amdaha bae kutsa hanu hanili’?” ");
INSERT INTO ruf_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Litsuwa lya usighilo na litsuwa kulu lya ichihungo, Yesu kema, kakemelela, “Imunu wowose yane ng'ilu, yatse kuna nene yanwe. ");
INSERT INTO ruf_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Imunu wowose iyonitoghola nene, ka Ghamaandiko Mahenzeluka pfagholonga, ‘Imito ye ghamatsi iighala ughima itsokwitika kulawa mghati mwake.’ ” ");
INSERT INTO ruf_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu tsayang'ali yolonga mbuli tse Ghumuhe, yawatsombokela iwanu awala iwomtoghola. Mbaka litsuwa lila iwanu tsawang'ali ng'aweng'ighwe bae Ghumuhe, kwaapfila Yesu tsakakala ng'ana yatunitsighwe ne Imulungu. ");
INSERT INTO ruf_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Hawahulike mbuli tsake, iwanu wangi walonga, “Kweli imunu yuno ka ayula Nabii.” ");
INSERT INTO ruf_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Iwanu wangi walonga, “Ayuno ka Kiristu Mkombotsi.” Lekeni iwanu wangi wang'ali weghutsa, “Apfi Kiristu kodahatse kulawa Galilaya? ");
INSERT INTO ruf_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Apfi Ghamaandiko Maenzeluka ng'aghalongile bae Kiristu katsolawila mlukolo lwa imndewa Daudi na kwelekighwa Betilehemu, kaye yakalile Daudi?” ");
INSERT INTO ruf_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Apfo iwanu tsawebaghula kwaajili ya Yesu. ");
INSERT INTO ruf_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Iwanu wangi wabama kumghogha, lekeni kuduhu imunu iyamgholosele ghumoko. ");
INSERT INTO ruf_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Wakalitsi we Ing'anda ye Imulungu hawoyile, iwatambika wakulu na Mafarisayo wawaghutsa, “Ule ng'amtsile naye bae?” ");
INSERT INTO ruf_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Wakalitsi wawedika, “Kuduhu imunu yadahile kulonga ka imunu yuno!” ");
INSERT INTO ruf_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Mafarisayo wawaghutsa, “Pfii namwe pfipfila kawabugha?” ");
INSERT INTO ruf_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","“Angu kuna imkulu au Mfarisayo iyamtoghole? ");
INSERT INTO ruf_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Bali iwanu wano ng'awomanya bae Ghamalaghitso gha Musa, apfo walighitighwa ne Imulungu.” ");
INSERT INTO ruf_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodemu, Mfarisayo yumwe, iyamghendele Yesu aho mwanduso, kawalongela, ");
INSERT INTO ruf_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Apfi Ghamalaghitso ghetu ghomhigha imunu wowose ka ng'atumhulikitse na kumanya chayatendile?” ");
INSERT INTO ruf_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Wamwidika, “Pfii naghwe kwolawa Galilaya? Lola Ghamaandiko Mahenzeluka, kutsomanya ka kuduhu nabii iyolawila Galilaya.” ");
INSERT INTO ruf_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Kuya chila imunu koka ukaye yake. ");
INSERT INTO ruf_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Lekeni Yesu kaghenda kune chidunda che Mitseituni. ");
INSERT INTO ruf_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Nemitondotondo litsuwa lya keli Yesu kaghenda keli mne Ing'anda ye Imulungu. Iwanu wose wamtsunguluka, naye kakala hasi, kandusa kuwalangulitsa. ");
INSERT INTO ruf_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Iwalangulitsi wa Ghamalangulitso na Mafarisayo wamghala ipinga iyaghoghighwe ughoni. Wamwika ipinga ayo hambele hawo. ");
INSERT INTO ruf_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Wamlongela Yesu, “Mlangulitsi, ipinga yuno kaghoghighwa ughoni. ");
INSERT INTO ruf_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mne Ghamalaghitso, Musa katulaghitsa apfi, ipinga ka ayu kobamighwa yatowighwe na ghamabwe mbaka yafe. Lelo ghweghwe ulongatse?” ");
INSERT INTO ruf_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Tsawaghutsa pfino wamwonze Yesu ili wapate ghomba lya kumghoghela. Lekeni Yesu kenamila hasi, kandusa kwandika hasi kwa chidole chake. ");
INSERT INTO ruf_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Hawaghendelele kumghutsa, Yesu kenuka kawalongela, “Imunu wowose mna mwemwe iyalihela nzambi, yalongole kumwasila libwe.” ");
INSERT INTO ruf_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Kuya Yesu kenama keli, kandika hasi. ");
INSERT INTO ruf_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Iwanu wala hawahulike apfi, wandusa kuka yumweyumwe, wandusa iwabala. Yesu kasighala ne ipinga ayula yemile hala. ");
INSERT INTO ruf_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu kenuka kamghutsa, “Walikwani iwanu iwakughoghile? Pfii kuduhu imunu iyakuhighile?” ");
INSERT INTO ruf_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ipinga ayo kamwidika, “Imtwatsa, kuduhu imunu iyanihighile.” Yesu kamlongela, “Na nene sikuhigha bae. Ghenda na uleke kutenda keli nzambi.” ");
INSERT INTO ruf_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu hayalongile keli ne iwanu, kalonga, “Nene na ghumwanga ghwe iisi. Imunu wowose iyoniwinza ng'atsokwanga mchisi bae, ila katsokuwa na ghumwanga ghwe ughima.” ");
INSERT INTO ruf_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Mafarisayo wamwidika, “Ghweghwe kwelapfila imwenyegho ukalangama, na ukalangama wako wa ughutsu.” ");
INSERT INTO ruf_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu kawalongela, “Hata ning'elapfila ukalangama imwenyegho, ukalangama wangu wolongesa, kwaapfila nomanya kwani kwanilawila na kwani konighenda. Lekeni mwemwe ng'ammanyile bae kwani kwanilawila au kwanighenda. ");
INSERT INTO ruf_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mwemwe mwohigha ka iwanu pfawohigha. Nene simuhigha imunu bae. ");
INSERT INTO ruf_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Lekeni ka nohigha, nohigha ghoya, kwaapfila sisang'ana bae niliyeka, Aba iyanitumile kahamwe na nene. ");
INSERT INTO ruf_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Yandikighwa mne Ghamalaghitso ghenu ukalangama we iwanu weli wotogholighwa. ");
INSERT INTO ruf_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nene nelapfila imwenyegho ukalangama, na mkalangama wangu yungi, Aba iyanitumile.” ");
INSERT INTO ruf_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Kuya wamghutsa, “Aba wako yalikwani?” Yesu kawedika, “Ng'amnimanyile nene wala ng'amummanyile Aba wangu, mng'animanyile, pfipfila mng'ammanyile Aba wangu.” ");
INSERT INTO ruf_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu kalonga mbuli tsino hayang'ali yolangulitsa mne Ing'anda ye Imulungu, hanu hane chinu cha kwikila sadaka. Kuya kuduhu imunu iyamghoghile kwaapfila chipindi chake tsa ng'ana chipfike bae. ");
INSERT INTO ruf_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu kalonga nawo keli, “Nakuka, mtsombama lekeni mtsakufa mne nzambi tsenu. Ng'amdaha bae kutsa hanu hanighenda.” ");
INSERT INTO ruf_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Iwakulu wa Wayahudi waghutsa, “Kolonga ng'atudaha bae kughenda hanu hoyoghenda. Pfii kobama yekome imwenyegho?” ");
INSERT INTO ruf_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Lekeni Yesu kawedika, “Mwemwe mwa wa iisi ino ili hasi, lekeni nene na wa kulanga. Mwemwe mwa iwanu wa muisi amu, lekeni nene si wa muisi amu. ");
INSERT INTO ruf_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Tsaniwalongela mtsakufa mne nzambi tsenu. Kwaapfila ng'amtoghola bae ‘Nene na Yuyula’ mtsakufa mne nzambi tsenu.” ");
INSERT INTO ruf_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Wamghutsa Yesu, “Lelo ghweghwe uli nani?” Yesu kawedika, “Nene na Yuyula kulawa mwanduso.” ");
INSERT INTO ruf_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","“Nina mbuli nyingi tsa kulonga mna mwemwe na kuwahigha. Lekeni iyanitumile yeye kotogholighwa, na chanihulike kuna yeye, chicho chaniwalongela iwanu wose.” ");
INSERT INTO ruf_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ng'awamanyile bae ka Yesu yang'ali yowalongela mbuli tse Aba wake. ");
INSERT INTO ruf_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yesu kawalongela, “Hamtsomwinula Imwana we Imunu mna msalaba, mtsomanya nene na Yuyula, kuya mtsomanya ka nene sitenda ichinu chochose niliyeka, ila nolonga chayanilangulitse Aba wangu. ");
INSERT INTO ruf_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Yula iyanitumile kahamwe na nene, ng'anilekile niliyeka bae, kwaapfila ghamatsuwa ghose notenda ighomnoghela.” ");
INSERT INTO ruf_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Iwanu wengi iwamhulikitse Yesu hayang'ali yolonga pfinu pfino wamtoghola. ");
INSERT INTO ruf_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Kuya Yesu kawalongela awala Wayahudi iwamtoghole, “Mng'aghakinda ghamalaghitso ghangu, mwemwe mtsakuwa iwanang'ina wangu ghendo. ");
INSERT INTO ruf_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Kuya mtsomanya ukweli, na ukweli utsowakombola.” ");
INSERT INTO ruf_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Wamwidika Yesu, “Twetwe twa watsukulu wa Abrahamu, ng'atuwile bae iwatumwa we imunu wowose. Pfii kuya kwolonga tutsokombolighwa?” ");
INSERT INTO ruf_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu kawedika, “Nowalongela ghendo, imunu wowose iyotenda nzambi ka imtumwa wa nzambi. ");
INSERT INTO ruf_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Imtumwa ng'okala bae ukaye ghamatsuwa ghose, ila imwana kokala ukaye ghamatsuwa ghose. ");
INSERT INTO ruf_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Imwana ang'amkombolani, mtsokombolighwa ghendo. ");
INSERT INTO ruf_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nomanya mwemwe mwa watsukulu we Abrahamu. Lekeni mwobama mnikome kwaapfila ng'amtoghola ghamalangulitso ghangu. ");
INSERT INTO ruf_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nowalongela achila Aba wangu chayanilanguse, lekeni mwemwe mwotenda achila chayawalongele aba wenu.” ");
INSERT INTO ruf_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Wamwidika, “Aba wetu Abrahamu.” Yesu kawedika, “Mng'awile iwana we Abrahamu, mng'atendile aghala ghayatendile Abrahamu. ");
INSERT INTO ruf_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Niwalongela ukweli yaniuhulike kwe Imulungu. Lekeni mwemwe mng'ali mwobama mnikome. Abrahamu ng'atendile pfino bae! ");
INSERT INTO ruf_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mwemwe mwotenda ipfinu ipfitendighwe na aba wenu.” Wamwidika, “Imulungu yaliyeka iyo Aba wetu yatulinaye. Twetwe twa iwanaghe ghendo.” ");
INSERT INTO ruf_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu kawalongela, “Ka Imulungu ang'awile Aba wenu, mng'amnoghele, kwaapfila ndawa kwe Imulungu na sambi nahano. Sitsile bae kwa uwetso wangu imwenyegho, ila yeye kanituma. ");
INSERT INTO ruf_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ebali ng'amchimanya bae chanilonga? Kwaapfila mwemwe ng'amdaha bae kuhulikitsa chanilonga. ");
INSERT INTO ruf_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mwolawa kwa aba wenu Yehile, na mwotenda ka aba wenu pfayobama. Kulawa mwanduso tsakawakoma iwanu, kwaapfila kuduhu ukweli kuna yeye. Hayolonga ughutsu, kolonga chihendo chake, kwaapfila ka mghutsu na aba we ughutsu. ");
INSERT INTO ruf_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Na nene kwaapfila nolongesa, ng'amnitoghola bae. ");
INSERT INTO ruf_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Apfi mna mwemwe kuna imunu iyodaha kulapfa ukalangama ka nene nina nzambi? Ka nolongesa, ebali ng'amnitoghola bae? ");
INSERT INTO ruf_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Imunu we Imulungu kohulikitsa mbuli tse Imulungu. Mwemwe ng'amuhulikitsa kwaapfila mwemwe si iwanu we Imulungu bae.” ");
INSERT INTO ruf_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Wayahudi wamligha Yesu kwa kumghutsa, “Apfi ng'atulongile ghoya bae ka ghweghwe kwa Msamariya na kuna chinyamkela?” ");
INSERT INTO ruf_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu kawedika, “Nene nahela chinyamkela, nene nomuhulikitsa Aba wangu lekeni mwemwe ng'amnihulikitsa bae. ");
INSERT INTO ruf_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nene sibamila utunitso imwenyegho bae, ila kabaho iyoubama, ayo ka mlamutsi. ");
INSERT INTO ruf_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nowalongela ghendo, imunu wowose iyokinda ghamalaghitso ghangu ng'atsokufa bae.” ");
INSERT INTO ruf_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Wayahudi wamlongela Yesu, “Sambi twomanya kuna chinyamkela! Abrahamu na manabii wafa, lekeni ghweghwe kwolonga imunu wowose iyokinda ghamalangulitso ghako ng'atsakufa bae. ");
INSERT INTO ruf_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Angu ghweghwe kwa mbala kubita aba wetu Abrahamu iyafile? Pfipfila manabii nawo wafa. Apfi ghweghwe kwolonga uli nani?” ");
INSERT INTO ruf_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu kawedika, “Ning'etunya imwenyegho, utunitso wangu si chinu. Aba wangu yamumkema Imulungu wenu, yeye iyo yonitunya. ");
INSERT INTO ruf_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Mwemwe ng'amummanya bae, lekeni nene nommanya. Ning'alonga simmanyile bae, nitsakuwa mghutsu ka mwemwe. Lekeni nommanya na nokinda imbuli yake. ");
INSERT INTO ruf_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Aba wenu Abrahamu kadeng'elela kwaajili ya kulyona litsuwa lya kutsa kwangu, naye kalyona, kalideng'elela.” ");
INSERT INTO ruf_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Wayahudi wamlongela Yesu, “Ghweghwe ng'una upfike imiyaka hamsini, naghwe kumwona Abrahamu!” ");
INSERT INTO ruf_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu kawedika, “Nowalongela ghendo, Abrahamu ng'ana yelekighwe nene nabaho.” ");
INSERT INTO ruf_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Kuya wadondola ghamabwe wabama wamtowe Yesu, lekeni Yesu kalawa mne Ing'anda ye Imulungu. ");
INSERT INTO ruf_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu hayang'ali yoghenda mmbalimbali, kamwona imunu chifita kulawa kwelekighwa kwake. ");
INSERT INTO ruf_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Iwanang'ina wake wamghutsa, “Mlangulitsi, yuhi iyatendile nzambi, mbaka imunu yuno yelekighwe chifita, imunu yuno au iwamweleke?” ");
INSERT INTO ruf_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu kawedika, “Si imunu yuno wala iwamweleke bae iwatendile nzambi, lekeni ilawila pfino ili ngupfu ye Imulungu yoneke mne ughima wake. ");
INSERT INTO ruf_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kwaapfila kung'ali misi, twobamighwa kusang'ana ing'onde ya ayula iyanitumile. Chilo hachikutsa kuduhu imunu iyodaha kusang'ana. ");
INSERT INTO ruf_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Haning'ali muisi, nene na ghumwanga ghwe isi.” ");
INSERT INTO ruf_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Hayamalitse kulonga apfi, kabwalula ghamate mne lidongo, kapfulugha likododo kwa ghamate kambaka chifita mnenge. ");
INSERT INTO ruf_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Yesu kamlongela, “Ghenda ukahopfughe chihanga chako mne tsimbu Siloamu.” Siloamu mana yake “Iyatumighwe.” Apfo imunu yula koka kaghenda kuhopfugha chihanga chake, kuya koka ukaye aku kakona. ");
INSERT INTO ruf_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Iwanu iwang'ali wokala naye habehi ne iwanu iwamwonile hayang'ali yolomba weghutsa, “Apfi ayu si imunu yula iyang'ali yolomba?” ");
INSERT INTO ruf_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Iwanu wamwenga walonga, “Ayuno yeye,” lekeni wangi walonga, “Ayu si yeye bae, keghala naye.” Lekeni imunu yula kalonga, “Nene na yuyula iyaning'ali nilomba.” ");
INSERT INTO ruf_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Wamghutsa, “Apfi kudahatse kona?” ");
INSERT INTO ruf_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Imunu ayo kawedika, “Imunu iwomkema Yesu kapfulugha likododo kanibaka mnenge mwangu. Kanongela ng'ende Siloamu nikahopfughe chihanga changu. Apfo ng'enda, bahala haning'ali nohupfugha chihanga, nidaha kwona.” ");
INSERT INTO ruf_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Wamghutsa, “Alikwani imunu hayo?” Kawedika, “Imane.” ");
INSERT INTO ruf_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Kuya iwanu wamghala imunu yula yakalile chifita kwa Mafarisayo. ");
INSERT INTO ruf_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Litsuwa Yesu lyapfulughe likododo na kumhonetsa imunu chifita tsalikala Litsuwa lya Sabato. ");
INSERT INTO ruf_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Kuya Mafarisayo wamghutsa keli imunu ayo pfayadahile kona. Kawedika, “Kanibaka likododo mnenge mwangu, nihopfugha chihanga changu, sambi nakona.” ");
INSERT INTO ruf_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Mafarisayo wamwenga walonga, “Imunu yuno yatendile pfino ng'olawa bae kwe Imulungu, kwaapfila kolibetsa Litsuwa lya Sabato.” Lekeni iwanu wangi waghutsa, “Apfi imunu yane nzambi kodahatse kutenda pfihulo ka pfino?” Apfo weghola. ");
INSERT INTO ruf_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Kuya Mafarisayo wamghutsa imunu ayo, “Kulonga kakuhonetsa tsinenge tsako. Ghweghwe ulongatse kwa imunu ayo?” Naye kawedika, “Imunu ayo ka nabii.” ");
INSERT INTO ruf_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Kuya iwakulu wa Wayahudi ng'awatoghole bae ka imunu ayo tsachifita na kadaha kona, mbaka wawakema aba na mai we imunu hayo. ");
INSERT INTO ruf_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Wayahudi wawaghutsa, “Apfi ayu mwanenu? Yumlonga kelekighwa chifita, lelo kodahatse ukona?” ");
INSERT INTO ruf_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Aba wake na mai wake wawedika, “Twomanya ayu mwanetu, twomanya tsakelekighwa chifita. ");
INSERT INTO ruf_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Lekeni ng'atumanyile bae pfayadahile kona na ng'atummanyile imunu iyamhonetse nenge tsake. Mumghutse, yeye ka imbala kodaha kwidika imwenyegho!” ");
INSERT INTO ruf_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Aba wake na mai wake walonga apfi kwaapfila wang'ali wowapfuka iwakulu wa Wayahudi, kwaapfila tsawalonga imunu wowose iyolonga Yesu ka Kiristu katsowingighwa mne Ing'anda ye Kulombela. ");
INSERT INTO ruf_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Kwaajili ayo aba na mai wake tsawalonga apfi, “Imwenyegho ka imbala, mghutseni.” ");
INSERT INTO ruf_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Wayahudi wamkema keli imunu ayo, wamlongela, “Wilahe kwe Imulungu ka kolongesa! Twomanya imunu iyakuhonetse kana nzambi.” ");
INSERT INTO ruf_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Imunu ayo kawedika, “Imane ka imunu ayu kana nzambi au kahela nzambi. Ichinu chimwe chanimanya; tsang'ala chifita lekeni sambi nakona!” ");
INSERT INTO ruf_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Kuya wamghutsa imunu ayo, “Angu akutendele choni? Yatendiletse kukuhonetsa tsinenge tsako?” ");
INSERT INTO ruf_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Imunu ayo kawedika, “Tsaniwalongela lekeni ng'ambamile bae kutegheletsa. Ule mwobama kuhulika imbuli ino keli? Pfii namwe mwobama kuwa iwanang'ina wake?” ");
INSERT INTO ruf_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Kuya wamligha wamlongela, “Ghweghwe kwa mwanang'ina wake! Twetwe twa iwanang'ina wa Musa! ");
INSERT INTO ruf_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Twomanya Imulungu tsakalonga na Musa, lekeni imunu yuno, ng'atumanyile bae kolawila kwani!” ");
INSERT INTO ruf_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Imunu yula kawedika, “Mwonikangawatsa! Mwemwe ng'ammanyile kwani koyolawila, lekeni katsihonetsa nenge tsangu. ");
INSERT INTO ruf_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Twomanya Imulungu ng'omhulikitsa bae imunu yane nzambi. Imulungu komhulikitsa imunu iyomtoghola na iyotenda chayambamile kutenda. ");
INSERT INTO ruf_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kulawa iisi pfailumbighwe kuduhu imunu yahulike ka imunu wowose kamhonetsa imunu iyelekighwe chifita. ");
INSERT INTO ruf_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ka imunu yuno ng'olawa bae kwa Imulungu, tsayang'alekile kudaha kusang'ana chochose!” ");
INSERT INTO ruf_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Wamwidika, “Ghweghwe kwelekighwa na kukulila mnzambi. Apfi udahatse kutulangulitsa?” Apfo Wayahudi wamuwinga imunu ayo mne Ing'anda ya Kulombela. ");
INSERT INTO ruf_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu tsakahulika imunu iyamuhonetse kawingighwa, hayamwonile kamghutsa, “Pfii kwomtoghola Imwana we Imunu?” ");
INSERT INTO ruf_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Imunu ayo kamghutsa, “Imtwatsa, apfi imunu ayo nani? Nongele nimtoghole!” ");
INSERT INTO ruf_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu kamwidika, “Sambi kumwona, yulonga naye iyo yuyo.” ");
INSERT INTO ruf_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Kuya imunu ayo kamwidika, “Imtwatsa, notoghola,” kampfughamila Yesu ghamaghoti. ");
INSERT INTO ruf_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesu kalonga, “Nitsa muisi amu kuhigha, pfifita wone na iwanu iwakona wawe pfifita.” ");
INSERT INTO ruf_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Mafarisayo wangi iwakalile na Yesu wamhulika hayalongile pfino, wamghutsa, “Apfi kwolonga twetwe twa pfifita?” ");
INSERT INTO ruf_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu kawedika, “Mng'awile pfifita, mng'akalile mwahela nzambi, lekeni kwaapfila mwolonga mwakona, mwemwe mng'ali mna nzambi.” ");
INSERT INTO ruf_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu kawalongela, “Nowalongela ghendo, imunu wowose ka ng'akwingila bae mne libanda lya wang'olo kubitila halibani, ila kakwingila kwa nzila ingi ayo ka mbapfi na mbokaji. ");
INSERT INTO ruf_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Imunu iyakwingila kubitila libani ayo ka mdimi we wang'olo. ");
INSERT INTO ruf_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mbetetsi kompfughulila libani, na wang'olo wohulikitsa litsi lya mdimi. Kowakema wang'olo wake kwa mataghwa, kowalongotsa kunze. ");
INSERT INTO ruf_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Hayowalapfa kunze wang'olo wake kowalongola, na wang'olo wake womuwinza kwaapfila womanya litsi lyake. ");
INSERT INTO ruf_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Lekeni ng'awomuwinza bae imunu yungi, watsomlema kwaapfila ng'awomanya bae litsi lye imunu yungi.” ");
INSERT INTO ruf_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu kawalongela imbuli ino, lekeni ng'awamanyile bae chayawalongele. ");
INSERT INTO ruf_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Kuya Yesu kalonga keli, “Nowalongela ghendo, nene nalibani lya wang'olo. ");
INSERT INTO ruf_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Iwanu wose iwanongole tsawabapfi na wabokaji, lekeni wang'olo ng'awawahulikitse bae. ");
INSERT INTO ruf_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nene nalibani. Imunu wowose iyakwingila kubitila nene katsokombolighwa. Katsakwingila na kulawa, naye katsopata ipfijo. ");
INSERT INTO ruf_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Wabapfi wakutsa kwiba, kukoma na kuhinya, nene nitsa wawe ne ughima bwelele, na watsokala ghamatsuwa ghose. ");
INSERT INTO ruf_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Nene namdimi yaninoghile. Mdimi yanoghile kolapfa ughima wake kwa wang'olo. ");
INSERT INTO ruf_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Imunu yodima kwa kulihighwa na si mdimi yane iwang'olo bae. Hayomwona yumbwa wa kumuhulo kakutsa, kowaleka iwang'olo kotsuma. Apfo yumbwa wa kumuhulo kowaghogha iwang'olo na kowapwililisa. ");
INSERT INTO ruf_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Imunu ayo kotsuma kwaapfila yeye ka imunu wa kulihighwa na ng'owalolesa bae wang'olo. ");
INSERT INTO ruf_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Nene namdimi yaninoghile, nowamanya wang'olo wangu na wang'olo wangu wonimanya, ");
INSERT INTO ruf_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ka Aba pfayonimanya na nene nommanya Aba, na nowalapfila wang'olo ughima wangu. ");
INSERT INTO ruf_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nina wang'olo wangi, awo si wa banda lino. Pfipfila nobamighwa niwaghale. Pfipfila nawo watsohulika litsi lyangu, na kutsakuwa na kingili limwe na mdimi yumwe. ");
INSERT INTO ruf_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Nomnoghela Aba wangu kwaapfila nolapfa ughima wangu ili niubokele keli. ");
INSERT INTO ruf_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Kuduhu imunu iyoniboka ughima wangu. Noulapfa imwenyegho ughima wangu kwaapfila nodaha kughulapfa na kughusola keli. Nibokela laghitso lino kulawa kwa Aba wangu.” ");
INSERT INTO ruf_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Mbuli tsino tsa Yesu tsiwatenda Wayahudi weghole keli. ");
INSERT INTO ruf_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Iwanu wemwenga walonga, “Kana chinyamkela na kamkwalukwale. Ule mwomtegheletsa?” ");
INSERT INTO ruf_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Lekeni wangi walonga, “Imunu yane chinyamkela ng'odaha bae kulonga pfino. Apfi chinyamkela kodaha kumhonetsa imunu chifita?” ");
INSERT INTO ruf_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Hako Yerusalemu tsakukala na Chihungo cha Kuika wakifu Ing'anda ye Imulungu, tsaghukala msimu ghwa chipfeghetsi. ");
INSERT INTO ruf_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesu yang'ali yakwanga mne Ing'anda ye Imulungu hane chitala cha Selemani. ");
INSERT INTO ruf_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Wayahudi wamtsunguluka wamghutsa, “Kutsotuleka tuleke kumanya mbaka tsuwachi? Tulongele mwatsimwatsi ka ghweghwe kwa Kiristu Mkombotsi.” ");
INSERT INTO ruf_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu kawedika, “Tsaniwalongela, lekeni ng'amnitoghole bae. Pfihulo ipfanitenda kwa taghwa lya Aba wangu pfonilangusa, ");
INSERT INTO ruf_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","lekeni mwemwe ng'amtoghola kwaapfila mwemwe si wang'olo wangu. ");
INSERT INTO ruf_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Wang'olo wangu wohulika litsi lyangu, nowamanya, nawo woniwinza. ");
INSERT INTO ruf_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Noweng'a ughima wa ghamatsuwa ghose, nawo ng'awatsakufa bae. Kuduhu imunu iyodaha kuwaboka mna ghamoko ghangu. ");
INSERT INTO ruf_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Aba wangu, iyangaile, ka mkulu kubita wose, kuduhu imunu iyodaha kuwaboka kulawa mna ghamoko gha Aba wangu. ");
INSERT INTO ruf_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nene na Aba twa chinu chimwe.” ");
INSERT INTO ruf_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Wayahudi wadondola keli ghamabwe wamtowe Yesu, ");
INSERT INTO ruf_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","lekeni Yesu kawalongela, “Niwalangusa pfihulo pfingi ipfilawile kwa Aba. Apfi chihulo chachi ichiwatenda mnitowe ne ghamabwe?” ");
INSERT INTO ruf_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Wamwidika, “Ng'atukwasila ghamabwe kwaapfila kutenda pfihulo, ila kwaapfila kumligha Imulungu! Ghweghwe kwa imunu, lekeni kwolonga ghweghwe kwa Imulungu.” ");
INSERT INTO ruf_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu kawedika, “Apfi ng'ayandikighwe mne Ghamalaghitso ghenu Imulungu tsakalonga, ‘Mwemwe mwa walungu?’ ");
INSERT INTO ruf_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Imulungu tsakawakema walungu awala yaweng'ile usenga wake, na Ghamaandiko Mahenzeluka gholongesa ghamatsuwa ghose. ");
INSERT INTO ruf_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Aba kanisaghula na kanituma nene muisi. Ule mwolonga nimligha Imulungu kwaapfila nilonga ‘Nene na lmwana we Imulungu?’ ");
INSERT INTO ruf_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ka sisang'ana bae sang'ano tsa Aba wangu yanibamile nitsisang'ane mleke kunitoghola. ");
INSERT INTO ruf_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Lekeni ka notsisang'ana sang'ano tsake na mng'ali mwolema kunitoghola, togholeni pfihulo pfangu, ili mmanye na mtange ka Aba ka mghati mwangu, na nene na mghati mwe Aba.” ");
INSERT INTO ruf_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Kuya wabama wamghoghe keli, lekeni Yesu kaswekuka kawaleka. ");
INSERT INTO ruf_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Kuya Yesu koya keli kumwambu mwe Ghumto Yoridani hanu Yohane hayakalile yobatitsa iwanu, kakala kuko. ");
INSERT INTO ruf_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Iwanu wengi wamghendela Yesu. Walonga, “Yohane ng'atendile pfihulo, ila chila imbuli ye imunu yuno iyalongile Yohane ilongesa.” ");
INSERT INTO ruf_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Baho iwanu wengi wamtoghola Yesu. ");
INSERT INTO ruf_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Imunu yumwe iyakemighwe Lazali tsamtamu. Lazali yang'ali yokala Betaniya, kaye yake Mariya ne ndughu yake Marita. ");
INSERT INTO ruf_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mariya yuno tsakakala yuyula iyambakile Imtwatsa Yesu ghamafuta ighonung'ila mmaghulu na kughabaghusa kwa mvili tsake, lumbu wake Lazali tsakakala mtamu. ");
INSERT INTO ruf_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Apfo lumbu tsake Lazali wamtumila Yesu usenga, “Imtwatsa, sale yako yumnoghele koghula.” ");
INSERT INTO ruf_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu hayahulike apfi, kalonga, “Utamu uno ng'autsomkoma bae Lazali, utamu uno ulawila kwa utunitso we Imulungu ili Imwana we Imulungu yatunitsighwe kubitila utamu uno.” ");
INSERT INTO ruf_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu tsakawanoghela Marita na lumbu wake na Lazali. ");
INSERT INTO ruf_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Yesu hayahulike Lazali koghula, kongetsa ghamatsuwa meli gha kukala hala hayakalile. ");
INSERT INTO ruf_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Kuya Yesu kawalongela iwanang'ina wake, “Tuye keli Yudeya.” ");
INSERT INTO ruf_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Iwanang'ina wake wamlongela, “Mlangulitsi, ghamatsuwa chidogho ighalutile Wayahudi tsawabama wakutowe ne ghamabwe, ule kwobama ughende keli hanu hala?” ");
INSERT INTO ruf_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu kawedika, “Apfi misi yahela masaa kumi ne meli bae? Imunu iyokwanga nemisi ng'ekwala bae kwaapfila koghwona ghumwanga ghwe isi ino. ");
INSERT INTO ruf_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Lekeni imunu ang'anga nechilo kekwala, kwaapfila kahela ghumwanga.” ");
INSERT INTO ruf_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesu hayalongile apfi, kaghendelela kuwalongela, “Sale yetu Lazali kawasa, lekeni noghenda kumlamsa.” ");
INSERT INTO ruf_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Iwanang'ina wake wamwidika, “Mtwatsa, ka kawasa, katsohona.” ");
INSERT INTO ruf_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesu tsayang'ali yolonga Lazali tsakafa lekeni iwanang'ina wake wapfikitsa Lazali tsakawasa. ");
INSERT INTO ruf_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Apfo Yesu kawalongela mwatsimwatsi, “Lazali kafa, ");
INSERT INTO ruf_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","lekeni kwaajili yenu nodeng'elela kwaapfila sikalile naye bae, ili mtoghole. Leka tumghendele.” ");
INSERT INTO ruf_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Kuya Tomasi, iyakemighwe Basa kawalongela iwanang'ina wayaghe, “Leka tughende ne Mlangulitsi ili tufe naye.” ");
INSERT INTO ruf_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesu hayapfikile, tsakapfika lukuli lwa Lazali lwikighwa mne likabuli ghamatsuwa mane ighalutile. ");
INSERT INTO ruf_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Kaye ya Betaniya tsaikala habehi ne Yerusalemu, utali wa maili mbili, ");
INSERT INTO ruf_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","na Wayahudi wengi watsa kuwakanza Marita ne Mariya kwa ukufa kwa ndughu yawo. ");
INSERT INTO ruf_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marita hayahulike Yesu kakutsa, kaghenda kunze kwitingana na Yesu, lekeni Mariya tsakasighala mng'anda. ");
INSERT INTO ruf_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marita kamlongela Yesu, “Mtwatsa, ka ung'awile hano, lumbu wangu tsa yang'alekile kufa! ");
INSERT INTO ruf_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Lekeni nomanya hata sambi Imulungu katsokwing'a chochose chaumlomba.” ");
INSERT INTO ruf_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu kamlongela, “Lumbu wako katsotsilihuka.” ");
INSERT INTO ruf_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marita kamwidika, “Nomanya katsotsilihuka keli mne litsuwa lya ukutsigha.” ");
INSERT INTO ruf_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu kamlongela, “Nene nautsilihuko ne ughima. Imunu iyonitoghola nene, ang'afa katsakuwa mghima, ");
INSERT INTO ruf_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","na imunu wowose iyokala na kunitoghola nene ng'atsakufa bae. Pfii kwotoghola?” ");
INSERT INTO ruf_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marita kamwidika, “Ona, Mtwatsa! Nokutoghola ghweghwe kwa Kiristu, Imwana wa Imulungu, iyatsile mne isi.” ");
INSERT INTO ruf_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marita hayalongile pfino, kaghenda mng'anda kamkema Mariya chinyelenyele. Kamlongela, “Mlangulitsi kabaha, kokukema.” ");
INSERT INTO ruf_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mariya hayahulike pfino, kenuka himahima kamghendela Yesu. ");
INSERT INTO ruf_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Na Yesu tsakakala ng'ana yapfike mkaye, ila kakala hanu hala hayetingane ne Marita. ");
INSERT INTO ruf_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Wayahudi iwakalile mng'anda womkanza Mariya, hawamwonile Mariya kenuka himahima na kulawa kunze wamuwinza, wapfikitsa yang'ali yoghenda kulila mne likabuli. ");
INSERT INTO ruf_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mariya hayapfikile hanu hayali Yesu na hayamwonile, kamtowela ghamaghoti, kamlongela, “Mtwatsa, ka ung'awile hano, lumbu wangu tsa yang'alekile kufa!” ");
INSERT INTO ruf_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu hayamwonile Mariya kolila, na Wayahudi iwatsile na Mariya nawo wolila, Yesu kaghanzika mne ghumoyo ghwake, kona usungu. ");
INSERT INTO ruf_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Yesu kawaghutsa, “Angu mumtsikile kwani?” Wamwidika, “Mtwatsa, itsa wone.” ");
INSERT INTO ruf_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu kalila. ");
INSERT INTO ruf_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Kuya Wayahudi walonga, “Mlole pfayamnoghele!” ");
INSERT INTO ruf_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Lekeni iwanu wangi welongela, “Ka kamhonetsa imunu chifita, ule ng'adahile kumtenda Lazali aleke kufa?” ");
INSERT INTO ruf_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesu yang'ali yoghanzika keli mne ghumoyo ghwake, kaghenda mbaka mne likabuli, likabuli tsalikala imango iighubikighwe ne libwe. ");
INSERT INTO ruf_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesu kawalaghitsa, “Mlibimbilise libwe!” Marita lumbu wa imunu iyafile kamwidika, “Mtwatsa, lekeni katsonung'a, ghamatsuwa mane ghabita kulawa yatsikighwe!” ");
INSERT INTO ruf_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Kuya Yesu kamlongela, “Apfi sikulongele bae ka ung'atoghola, kutsakona utunitso we Imulungu?” ");
INSERT INTO ruf_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Apfo wabimbilisa libwe. Kuya Yesu kalola kulanga kalonga, “Aba, nolonga mighede kwaapfila kwonihulika. ");
INSERT INTO ruf_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nomanya ghamatsuwa ghose kwonihulika, lekeni nolonga pfino kwaajili ya iwanu iwemile hano, ili watoghole ghweghwe kunituma.” ");
INSERT INTO ruf_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yesu hayamalitse kulonga apfi, kakemelela, “Lazali, lawa kunze!” ");
INSERT INTO ruf_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Naye Lazali kalawa kunze, ghamoko na maghulu ghake ghoighwa isanda na ichihanga chake chighubikighwa chitambala. Yesu kawalongela, “Mdoholeni mumleke yoke.” ");
INSERT INTO ruf_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Apfo Wayahudi wengi iwaghendile kumwangila Mariya, waghona ghayatendile Yesu, na wamtoghola. ");
INSERT INTO ruf_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Lekeni iwanu wangi woya kwa Mafarisayo wawalongela aghala ghayatendile Yesu. ");
INSERT INTO ruf_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Apfo Mafarisayo na iwatambika wakulu wetingana ne iwanu we Libalatsa lye Wayahudi, weghutsa, “Tutende choni? Imunu yuno kotenda pfihulo pfingi. ");
INSERT INTO ruf_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Tung'amleka aghendelele, iwanu wose watsomtoghola, kuya iwakulu wa Waroma watsakutsa kusola Ing'anda yetu ya ukulombela na isi yetu.” ");
INSERT INTO ruf_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Kuya yumwe wawo, iyakemighwe Kayafa, iyakalile Mtambika mkulu wa ghumwaka ghula, kalonga, “Mwawabotsi! ");
INSERT INTO ruf_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Apfi ng'ammanyile bae ka pfinogha kuna mwemwe imunu yumwe yafe kwaajili ya iwanu wose kubita isi yose ihinyighwe?” ");
INSERT INTO ruf_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ng'alongile bae kwa kubama imwenyegho, lekeni kwaapfila tsakakala mtambika mkulu wa ghumwaka ghula, tsakatabili Yesu katsakufa kwaajili ya isi ya Wayahudi, ");
INSERT INTO ruf_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","kuya si kwaajili ya isi ila iliyeka, ila pfipfila kuweka hamwe iwana we Imulungu iwapwililike wawe wamwe. ");
INSERT INTO ruf_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Apfo kulawa litsuwa lila iwakulu wa Wayahudi wabama inzila ya kumkoma Yesu. ");
INSERT INTO ruf_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Apfo Yesu ng'aghendile bae mwatsimwatsi muisi ya Yudeya, ila kalawa ako kaghenda habehi na kunyika, kune kaye iikemighwe Efuremu, hao kakala ne iwanang'ina wake. ");
INSERT INTO ruf_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ichihungo che Ipasaka cha Wayahudi hachipfikile habehi, iwanu wengi wagheluka Yerusalemu ili wadeghesighwe ng'ana Ipasaka ipfike. ");
INSERT INTO ruf_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Wang'ali wombama Yesu, na hawetingane mne Ing'anda ye Imulungu weghutsa, “Mkwonatse? Apfi ng'atsakutsa bae mne lchihungo?” ");
INSERT INTO ruf_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Lekeni iwatambika wakulu na Mafarisayo walapfa laghitso imunu wowose iyomanya kwayali Yesu, yalonge, ili wamghoghe. ");
INSERT INTO ruf_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ghamatsuwa sita ng'ana ichihungo che Ipasaka chipfike, Yesu kapfika Betaniya, ukaye kwa Lazali, imunu iyamtsilihule. ");
INSERT INTO ruf_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Iwanu wamwikila Yesu ichijo cha nemihe, Marita angali yowasang'anila. Lazali tsakakala yumwe we iwanu iwang'ali wakuja na Yesu. ");
INSERT INTO ruf_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Kuya Mariya kasola isupa ye ghamafuta ighonung'ila ghoya ighalawile mne ghummeya ighukemighwe narido, kambaka Yesu ghamaghulu na kumbaghusa kwa mvili tsake. Ing'anda yose tsainung'ila ghoya. ");
INSERT INTO ruf_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yuda Isikarioti, yumwe wa iwanang'ina wake, iyatsomhunduka Yesu kaghutsa, ");
INSERT INTO ruf_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Ule ghamafuta ghano ghang'autsighwe dinari miya ndatu na sendi weng'ighwe iwahingwa?” ");
INSERT INTO ruf_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yuda tsakalonga pfino, si kwakuwonela libatsi iwahingwa, ila kalonga pfino kwaapfila tsakakala mbapfi, yeye yang'ali yokindagha ghumkoba ghwo ukwikila tsisendi na yang'ali yakwibagha tsisendi. ");
INSERT INTO ruf_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yesu kamwidika, “Mleke! Katenda pfino kulyandaa litsuwa lya kutsikighwa kwangu. ");
INSERT INTO ruf_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ghamatsuwa ghose mtsokala ne iwahingwa, lekeni ng'amtsokala na nene bae ghamatsuwa ghose.” ");
INSERT INTO ruf_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Wayahudi wengi hawahulike Yesu kakala Betaniya waghenda, ng'awaghendile bae kumwona Yesu aliheka, pfipfila waghenda kumwona Lazali, imunu yula Yesu iyamtsilihule. ");
INSERT INTO ruf_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Apfo iwatambika wakulu wabama inzila ye kumkoma Lazali, ");
INSERT INTO ruf_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","kwa achila ichimlawile Lazali Wayahudi wengi wamghendela Yesu na kumtoghola. ");
INSERT INTO ruf_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Litsuwa liwinzile iwanu wengi watsa mne Ichihungo che Ipasaka, tsawahulika Yesu ang'ali yakutsa Yerusalemu. ");
INSERT INTO ruf_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Apfo wasola ghamaputila ghe mibiki, waghenda kumbokela, wakemelela, “Mtunitse Imulungu! Imulungu kambaliki iyakutsa kwa taghwa lya Imtwatsa, Imulungu kambaliki Imndewa wa Isiraeli!” ");
INSERT INTO ruf_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu kamwona imwana punda, kamdina, ka pfayandikighwe mne Ghamaandiko Mahenzeluka ");
INSERT INTO ruf_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Mleke kupfuka, iwanu we Sayuni, Imndewa wenu kakutsa, kadina imwana punda.” ");
INSERT INTO ruf_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Mwanduso iwanang'ina wake ng'awamanyile bae mbuli tsino. Lekeni Yesu hayatsilihuke na kutunitsighwa, iwanang'ina wakumbuka Ghamaandiko Mahenzeluka ighalongile mbuli tsake na ka wanu wamtendela pfinu apfo. ");
INSERT INTO ruf_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Iwanu iwakalile na Yesu hayamkemile Lazali kulawa mne likabuli na kumtsilihula, walonga aghala ighalawile. ");
INSERT INTO ruf_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Iwanu wengi waghenda kutingana na Yesu kwaapfila tsawahulika Yesu katenda chihulo. ");
INSERT INTO ruf_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Apfo Mafarisayo welongela, “Mlole, ng'atudaha kutenda chochose. Iwanu wose womuwinza!” ");
INSERT INTO ruf_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Kukala na Wagiriki wengi mne iwanu iwatsile Yerusalemu kutamanila mne ichihungo cha Ipasaka. ");
INSERT INTO ruf_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Wamghendela Filipi, iyalawile Betisaida mne isi ya Galilaya wamlongela, “Mkulu, twobama tumwone Yesu.” ");
INSERT INTO ruf_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipi kaghenda, kamlongela Andereya, kuya wose weli waghenda kumlongela Yesu. ");
INSERT INTO ruf_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu kawedika, “Chipindi chipfika che Imwana we Imunu kutunyighwa! ");
INSERT INTO ruf_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nowalongela ghendo, ka mbeghu ye uhemba ng'ailaghale mdongo na ukufa, yokala pfipfo imwe iliyeka. Lekeni ing'afa na ukota, itsokweleka mbeghu bwelele. ");
INSERT INTO ruf_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Imunu iyounoghela ughima wake katsowaghitsa, ila imunu iyouhila ughima wake katsokwing'ighwa ughima we ghamatsuwa ghose. ");
INSERT INTO ruf_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Imunu wowose iyobama kunitumikila yaniwinze, hohose hanikala imtumwa wangu akale baho. Aba wangu katsomtoghola imunu iyonitumikila. ");
INSERT INTO ruf_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Sambi ghumoyo ghwangu ghwoghanzika, na nene nonge choni? ‘Aba unikombole mne chipindi chino?’ Bae, acho chicho chanitsile, nibite chipindi chino cha maghayo. ");
INSERT INTO ruf_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Aba, litunye taghwa lyako!” Kuya litsi kulawa kulanga lilonga, “Nilitunya na nitsolitunya keli.” ");
INSERT INTO ruf_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Iwanu wengi iwemile hala wahulika litsi lila, iwanu wangi walonga kukala na mdumo, lekeni iwanu wangi walonga, “Malaika kalonga naye!” ");
INSERT INTO ruf_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Bali Yesu kawalongela, “Litsi lino ng'alinitsile nene bae lekeni liwatsilani mwemwe. ");
INSERT INTO ruf_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Chipindi cha kuhighighwa isi ino chipfika, mkulu we isi ino katsowingighwa. ");
INSERT INTO ruf_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Hanitsokwinulighwa muisi, nitsowakwegha iwanu wose kuna nene.” ");
INSERT INTO ruf_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesu kalonga pfino kulangusa pfayatsokufa. ");
INSERT INTO ruf_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Mtingano we iwanu wamghutsa, “Ghamalaghitso ghetu tsaghalonga Kiristu katsokala ghamatsuwa ghose. Ule lelo kwolonga ‘Imwana we Imunu kobamighwa yenulighwe?’ Apfi Imwana yuno we Imunu nani?” ");
INSERT INTO ruf_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Kuya Yesu kawalongela, “Mtsokala ne ghumwanga kwa chipindi chidodo. Mwange hamng'ali nawo ghumwanga, ng'ana ichisi chiwatsile. Imunu iyokwanga mchisi ng'omanya bae koyoghenda. ");
INSERT INTO ruf_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Mtoghole ghumwanga hamng'ali nawo, ili muwe iwana we ghumwanga.” Hayamalitse kulonga apfi, Yesu koka, kepfisa waleke kumwona. ");
INSERT INTO ruf_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Hata ka Yesu tsakasang'ana pfihulo hambele hawo, lekeni ng'awamtoghole bae. ");
INSERT INTO ruf_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Agha ghose ghalawila ghatimile aghala ghayalongile Nabii Isaya. “Imtwatsa, nani iyautoghole usenga wetu? Na ghumoko ghwa Imtwatsa ughubulighwa kwa nani?” ");
INSERT INTO ruf_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Apfo ng'awadahile bae kutoghola, kwaapfila Isaya pfipfila tsakalonga keli. ");
INSERT INTO ruf_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Imulungu kalonga, “Nitsowabopfula nenge tsawo, nitsotsibumbuwatsa mbutsi tsawo, waleke kwona kwa tsinenge tsawo, waleke kumanya kwa mbutsi tsawo, waleke kunihundukila, na kuwahonetsa.” ");
INSERT INTO ruf_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaya tsakalonga apfi kwaapfila tsakawona utunitso wa Yesu na kulonga mbuli tsake. ");
INSERT INTO ruf_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Hata iwakulu wangi wa Wayahudi tsawamtoghola Yesu. Lekeni ng'awadahile bae kulonga mwatsimwatsi kwaapfila wapfuka Mafarisayo watsowawinga mne Ing'anda ye Imulungu. ");
INSERT INTO ruf_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Kwaapfila tsawanoghelighwa sideke kutunyighwa ne iwanu kubita kutunyighwa ne Imulungu. ");
INSERT INTO ruf_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesu kakemelela, “Imunu wowose iyonitoghola nene, ng'onitoghola nene niliyeka bae ila pfipfila komtoghola ayula iyanitumile. ");
INSERT INTO ruf_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Imunu wowose iyombona nene komwona yula iyanitumile. ");
INSERT INTO ruf_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nitsa muisi niwe ghumwanga, ili iwanu wose iwonitoghola waleke kukala mchisi. ");
INSERT INTO ruf_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ka imunu kotegheletsa mbuli tsangu na ng'otsikinda bae, sitsomuhigha bae. Kwaapfila sitsile bae kuhigha iisi lekeni nitsa kuikombola. ");
INSERT INTO ruf_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Yeye iyondema nene na kulema mbuli tsangu, ayo kenaye wa kumhigha. Mbuli tsila tsanongile tsitsomhigha mna litsuwa lya ukutsigha. ");
INSERT INTO ruf_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Kwaapfila silonga bae kwa ukulu wangu, ila Aba wangu iyanitumile kandaghitsa chokulonga, na nilongetse. ");
INSERT INTO ruf_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nomanya laghitso lyake lyoghala ughima wa ghamatsuwa ghose. Apfo nolonga aghala Aba wangu ghayandaghitse nighalonge.” ");
INSERT INTO ruf_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Tsaikala ichihungo che Ipasaka ng'ana chipfike. Yesu tsakamanya saa yake ya ukuka kulawa iisi ino na kughenda kwa Aba wake ipfika. Tsakawanoghela ng'ani iwanu wake iwali muisi, kawalangusa unoghelo wake ing'autsigha bae. ");
INSERT INTO ruf_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yesu ne iwanang'ina wake wang'ali wakuja ichijo cha nemihe, yehile ma tsakamwingila Yuda, imwana wa Simoni Isikarioti, mne ghumoyo ghwake, kumhunduka Yesu. ");
INSERT INTO ruf_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu tsakamanya Aba kamwing'a ghose mna ghamoko ghake, tsakamanya kalawila kwa Imulungu na kakuya kwe Imulungu. ");
INSERT INTO ruf_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Apfo kenuka mmetsa, keka mmbalimbali gholole lyake, keyoha lighwanda lingi mchuno. ");
INSERT INTO ruf_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Kuya keka ghamatsi mchiya, kandusa kuwahopfugha ghamaghulu iwanang'ina wake na kuwabaghusa kwa lighwanda ilili mchuno mwake. ");
INSERT INTO ruf_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Yesu kapfika hayali Simoni Petiri, iyamghutsile Yesu, “Imtwatsa, ghweghwe uhopfughe ghamaghulu ghangu?” ");
INSERT INTO ruf_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu kamwidika, “Chanisang'ana sambi ghweghwe ng'uchimanyile bae, lekeni kutsochimanya hambele.” ");
INSERT INTO ruf_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petiri kalonga, “Bae, ng'utsoghahopfugha bae ghamaghulu ghangu!” Yesu kamwidika, “Ka sighahopfugha bae ghamaghulu ghako, ng'utsakuwa keli bae imwanang'ina wangu.” ");
INSERT INTO ruf_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simoni Petiri kamwidika, “Imtwatsa, uleke kughahopfugha ghamaghulu ghangu ghaliyeka, ila pfipfila uhopfughe na ghamoko ghangu na litwi lyangu!” ");
INSERT INTO ruf_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu kedika, “Imunu yoghile kela lukuli lwose na kobamighwa yofughe ghamaghulu ghaliyeka. Mwemwe mwela ila si wose bae.” ");
INSERT INTO ruf_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu tsakalonga si wose bae iwelile kwaapfila tsakamanya imunu iyoghenda kumhunduka. ");
INSERT INTO ruf_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yesu hayamalitse kuwahopfugha ghamaghulu ghawo, kapfala keli gholole lyake kakala hanu hake. Kawaghutsa, “Apfi mghamanya ghaniwatendele?” ");
INSERT INTO ruf_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“Mwonikema Mlangulitsi na Imtwatsa, mwotenda ghoya kwaapfila apfo pfipfo pfanili. ");
INSERT INTO ruf_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nene na Imtwatsa na Mlangulitsi wenu, niwahopfugha mwemwe ghamaghulu ghenu, namwe pfipfila mwihopfughe ghamaghulu ghenu. ");
INSERT INTO ruf_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nimlangutsani nzila ya kutenda, namwe mtende ka pfaniwatendele. ");
INSERT INTO ruf_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nowalongela ghendo, kuduhu mtumwa imkulu kubita imtwatsa wake, na kuduhu mtumwa imkulu kubita yula iyamtumile. ");
INSERT INTO ruf_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Lelo mwopfimanya pfinu pfino, mng'atenda mtsobweda. ");
INSERT INTO ruf_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Siwalonga bae mwemwe wose, nowamanya awala yaniwasaghule. Lekeni leka Ghamaandiko Mahenzeluka ghatimile igholonga, ‘Imunu yanikuja naye kanihunduka.’ ");
INSERT INTO ruf_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Sambi nowalongela ng'ana chilawile, ili hachitsolawila mtsotoghola ‘Nene iyo Yeye.’ ");
INSERT INTO ruf_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nowalongelani ghendo, imunu wowose iyombokela imunu yanimtumile kombokela nene, na imunu wowose iyonitoghola nene kombokela ayula iyanitumile.” ");
INSERT INTO ruf_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesu hayamalitse kulonga apfi, kona usungu ng'ani mne ghumoyo ghwake, kalonga, “Nowalongela ghendo, yumwe wenu katsonihunduka!” ");
INSERT INTO ruf_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Iwanang'ina wake tsawelolesa na ng'awamanyile bae yang'ali yomlonga nani. ");
INSERT INTO ruf_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Imwanang'ina yumwe, iyanoghelighwe na Yesu, tsakakala habehi naye. ");
INSERT INTO ruf_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simoni Petiri kampfinyighitsa na kulonga, “Mghutse yomlonga nani.” ");
INSERT INTO ruf_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Imwanang'ina ayo kasoghela habehi na Yesu, kamghutsa, “Imtwatsa, umlonga nani?” ");
INSERT INTO ruf_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu kamwidika, “Imunu yula iyanimwing'a chihande che chighate chanipfabika mwibakuli, ayo iyo yeye.” Kuya kasola chihande che chighate, kachipfabika, kamwing'a Yuda, imwana wa Simoni Isikarioti. ");
INSERT INTO ruf_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Bahala Yuda hayasolile chighate, Setani kamwingila. Kuya Yesu kamlongela, “Tenda himahima chaubama kutenda!” ");
INSERT INTO ruf_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Lekeni mna iwanu wala iwang'ali wakuja tsahaduhu imunu iyamanyile ule Yesu tsakamlongela pfino. ");
INSERT INTO ruf_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Kwaapfila Yuda tsakakala mkinda mkoba ghwa sendi, iwanang'ina wangi wapfikitsa Yesu yang'ali yomlongela Yuda yaghende kughula ipfinu ipfibamighwa mne Ichihungo, au kuweng'a chinu iwahingwa. ");
INSERT INTO ruf_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Bahala Yuda hayasolile chighate, kalawa kunze. Tsaikala nechilo. ");
INSERT INTO ruf_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yuda hayokile, Yesu kalonga, “Lelo utunitso we Imwana we Imunu woneka, na utunitso we Imulungu woneka kubitila yeye. ");
INSERT INTO ruf_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ka utunitso we Imulungu ughubulighwa kubitila yeye, kuya Imulungu imwenyegho katsoughubula utunitso we Imwana we Imunu, na baho katsomtunya. ");
INSERT INTO ruf_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Wanangu, nitsokala namwe chidodo. Mtsombama, lekeni sambi nowalongela achila chaniwalongele Wayahudi, ‘Kwanighenda ng'amdaha kutsa bae.’ ");
INSERT INTO ruf_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Lelo noweng'a laghitso lya sambi. Mwinoghele. Ka pfaniwanoghele, namwe mwinoghele pfipfo. ");
INSERT INTO ruf_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Mng'enoghela, iwanu wose watsomanya mwemwe mwa iwanang'ina wangu.” ");
INSERT INTO ruf_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simoni Petiri kamghutsa, “Imtwatsa, ughenda kwani?” Yesu kamwidika, “Ng'udaha bae sambi kuniwinza hanu hanighenda, lekeni hambele kutsoniwinza.” ");
INSERT INTO ruf_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petiri kamghutsa, “Imtwatsa ule sidaha kukuwinza sambi? Nene nitsokulapfila ughima wangu.” ");
INSERT INTO ruf_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Kuya Yesu kamwidika, “Ghweghwe kodaha kundapfila nene ughima wako? Nokulongela ghendo, jogholo ng'ana yeke bae kutsonibela mala ndatu! ");
INSERT INTO ruf_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Mleke kughanzika mne mimoyo yenu, mtogholeni Imulungu, pfipfila mnitoghole nene. ");
INSERT INTO ruf_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mng'anda kwa Aba wangu kuna pfiheleto pfingi, ka si pfipfo bae, ning'awalongele. Lelo noghenda kuwaandalila hanu henu. ");
INSERT INTO ruf_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ning'aghenda, noghenda kuwaandalila hanu henu, nitsowoyila na kuwasola ili mkale hala nene hanikala. ");
INSERT INTO ruf_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mwoimanya inzila ya hanu hanighenda.” ");
INSERT INTO ruf_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomasi kamghutsa, “Imtwatsa, ng'atumanyile bae kwani kwaughenda, lelo tuimanyetse inzila ayo?” ");
INSERT INTO ruf_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu kamwidika, “Nene na inzila, kweli na ughima. Haduhu imunu iyodaha kughenda kuna Aba ka ng'abitile bae kuna nene. ");
INSERT INTO ruf_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Mng'animanyile nene, pfipfila mng'ammanyile Aba wangu na kulawa sambi mwommanya na mumwona.” ");
INSERT INTO ruf_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipi kamlongela, “Imtwatsa, tulanguse Aba ayo, ayo iyo yuyo yatumbama.” ");
INSERT INTO ruf_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu kamlongela, “Filipi nikala namwe matsuwa mengi, ung'ali ng'unimanyile bae? Imunu wowose iyambonile nene kamwona Aba. ‘Ule kwolonga tulanguse Aba?’ ");
INSERT INTO ruf_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Apfi ng'autoghola bae ka nene namghati mwa Aba, naye kamghati mwangu? Mbuli tsanilonga si tsangu bae, ila Aba iyokala mghati mwangu kosang'ana ng'onde yake. ");
INSERT INTO ruf_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mnoghole haniwalongela nene namghati mwa Aba naye Aba kamghati mwangu. Ka ng'utoghola imbuli yangu, toghola pfinu pfanitendile. ");
INSERT INTO ruf_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nowalongela ghendo, imunu iyonitoghola nene katsotenda apfila pfanendile, katsotenda ipfinu pfikulu kubita pfino, kwaapfila nene noghenda kwa Aba wangu. ");
INSERT INTO ruf_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nitsowatendelani chochose chamlomba kwa taghwa lyangu, ili utunitso wa Aba woneke kubitila Imwana. ");
INSERT INTO ruf_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Mng'anilomba ichinu chochose kwa taghwa lyangu, nitsowatendelani. ");
INSERT INTO ruf_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Ka mwoninoghela, mtsoghakinda ghamalaghitso ghangu. ");
INSERT INTO ruf_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nitsomlomba Aba, naye katsomwing'ani Mwapfitsi yungi, katsokala namwe ghamatsuwa ghose. ");
INSERT INTO ruf_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ayo Ghumuhe ghwe Imulungu iyoighubula kweli. Iwanu wa isi ng'awodaha bae kumbokela kwaapfila ng'awodaha bae kumwona na kummanya. Lekeni mwemwe mwommanya, kwaapfila kokala namwe na katsokuwa mghati mwenu. ");
INSERT INTO ruf_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Hanitsakuka, siwaleka bae mliyeka ka wachuwa, nitsowoyila. ");
INSERT INTO ruf_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Mne ichipindi chidodo ichikutsa iwanu wa iisi ng'awatsombona keli bae, lekeni mwemwe mtsombona, kwaapfila namghima, pfipfila namwe mtsakuwa waghima. ");
INSERT INTO ruf_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Mne litsuwa alyo mtsomanya nene namghati mwa Aba wangu, namwe mwamghati mwangu, na nene namghati mwenu. ");
INSERT INTO ruf_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Iwanu wala iwobokela ghamalaghitso ghangu na kughakinda, iwanuwo woninoghela. Aba wangu katsowanoghela iwanu wala iwonoghela nene, pfipfila nene nitsowanoghela na nitselangusa kuna wawo.” ");
INSERT INTO ruf_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yuda, si Yuda Isikarioti bae kalonga, “Imtwatsa, ebali kobama kwilangusa kuna twetwe tuliyeka na si kwe iwanu we isi yose bae?” ");
INSERT INTO ruf_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu kamwidika, “Imunu wowose iyonoghela nene katsoghakinda ghamalaghitso ghangu. Aba wangu katsomnoghela, nene na Aba wangu tutsomtsila na kukala naye. ");
INSERT INTO ruf_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Imunu wowose ing'ayoninoghela ng'oghakinda bae ghamalangulitso ghangu. Ghamalangulitso ighamuhulike si ghangu bae, gholawa kwa Aba iyanitumile. ");
INSERT INTO ruf_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Niwalongela ghano haning'ali namwe. ");
INSERT INTO ruf_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Aba wangu katsowatumila Mwapfitsi, Ghumuhe Mwenzeluka kwa taghwa lyangu, katsowalangulitsa mmanye ipfinu pfose na kuwatenda mkumbuke chila ichinu chaniwalongele. ");
INSERT INTO ruf_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Nowalekela iamani, noweng'a iamani yangu. Siweng'a bae ka isi pfaitendagha. Mleke kughanzika. Mleke kupfuka. ");
INSERT INTO ruf_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Tsamuhulika haniwalongele, ‘Noghenda, kuya nitsowoyila.’ Ka tsamninoghela mng'adeng'elele nene kughenda kwa Aba, kwaapfila Aba kamkulu kubita nene. ");
INSERT INTO ruf_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Niwalongela ng'ana ghalawile, ili haghatsolawila mtoghole. ");
INSERT INTO ruf_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Sitsolonga keli bae namwe mbuli nyingi, kwaapfila imkulu wa iisi ino kakutsa. Hayo kahela ngupfu kuna nene, ");
INSERT INTO ruf_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","lekeni iwanu we iisi wamanye ka nene nomnoghela Aba, nosang'ana chichila Aba wangu chayanilaghitse. “Mwinuke tukeni. ");
INSERT INTO ruf_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Nene na mtsabibu wa kweli, na Aba wangu iyo iyolima. ");
INSERT INTO ruf_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Koghana ghamaputila ghose ghang'aghakweleka, kohalilila ghamaputila ghose ighakweleka ghamatunda, ili gheleke ng'ani. ");
INSERT INTO ruf_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Mwemwe ma mdegheta kwa imbuli ila yaniwalongeleni. ");
INSERT INTO ruf_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Mkale mghati mwangu, na nene nitsokala mghati mwenu. Haduhu putila ilidaha kweleka lyenyegho, lyobamighwa likale mne mbiki. Pfipfila namwe ng'amdaha bae kweleka ghamatunda mbaka mkale mghati mwangu. ");
INSERT INTO ruf_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Nene na mtsabibu, mwemwe mwa ghamaputila. Imunu ang'akala mghati mwangu na nene ng'ale mghati mwake, ayo katsakweleka ghamatunda mengi, kwaapfila mwemwe mliyeka ng'amdaha bae kutenda chochose. ");
INSERT INTO ruf_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Imunu wowose ka ng'okala bae mghati mwangu, keghala ne putila ilikwasighwa kutali na kunyala. Ghamaputila agho ghokungighwa, ghokwasighwa mmoto, gholakatsighwa. ");
INSERT INTO ruf_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Mng'akala mghati mwangu na mbuli tsangu tsing'akala mghati mwenu, mlombe chinu chochose chambama, mtsokwing'ighwa. ");
INSERT INTO ruf_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Aba wangu kotunyighwa mwemwe mng'eleka ghamatunda mengi, namwe mtsakuwa iwanang'ina wangu. ");
INSERT INTO ruf_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nowanoghela mwemwe ka Aba pfayanoghele nene. Lelo mkale aku mwomanya ka nomnoghelani. ");
INSERT INTO ruf_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Mng'aghakinda malaghitso ghangu, mtsokala mne unoghelo wangu, ka nene pfanighakindile ghamalaghitso gha Aba na nikala mne unoghelo wake. ");
INSERT INTO ruf_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Tsaniwalongela agha ghose ili ndeng'elelo yangu ikale mghati mwenu na ndeng'elelo yenu ileke kumala. ");
INSERT INTO ruf_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Alino laghitso lyangu, mwinoghele ka pfaniwanoghele mwemwe. ");
INSERT INTO ruf_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kuduhu unoghelo mkulu kubita unoghelo wa imunu iyoulapfa ughima wake kwaajili ya sale tsake. ");
INSERT INTO ruf_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Mwemwe mwa sale tsangu mng'atenda achila chaniwalaghitse. ");
INSERT INTO ruf_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Sitsowakema keli mwemwe watumwa bae, kwaapfila mtumwa ng'omanya sang'ano tse mtwatsa wake. Lekeni nowakema mwemwe sale tsangu, kwaapfila niwalongela ghose ghanihulike kwa Aba wangu. ");
INSERT INTO ruf_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Si mwemwe bae yamnisaghule, ila nene yanimsaghuleni mghende na mweleke ghamatunda, ghamatunda ing'aghoupa bae. Kuya Aba katsomwing'ani chochose ichamlomba kwa taghwa lyangu. ");
INSERT INTO ruf_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Alino laghitso lyangu kuna mwemwe, Mwinoghele. ");
INSERT INTO ruf_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Iwanu we iisi wang'awahilani, mmanye ka tsawalongola kunihila nene. ");
INSERT INTO ruf_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Mng'awile we iisi ino, iwanu wa iisi wang'amnogheleni ka iwanu wake. Lekeni kwaapfila mwemwe si wa isi ino, ila nene nimsaghulani mghati mwe iwanu we isi ino. Kwaajili ayo iwanu wa isi womuhilani. ");
INSERT INTO ruf_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Mkumbuke chaniwalongele, ‘Imtumwa si mkulu bae kubita imtwatsa wake.’ Ka iwanu wandununza nene, namwe pfipfila watsowadununzani. Wang'aghakinda ghamalangulitso ghangu, pfipfila watsoghakinda ghamalangulitso ghenu. ");
INSERT INTO ruf_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Watsowatendela agha ghose kwaapfila mwemwe mwa iwanu wangu, kwaapfila ng'awammanyile bae yula iyanitumile. ");
INSERT INTO ruf_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ka sitsile bae na kulonga nawo, wang'alongile wahela nzambi, lekeni sambi ng'awodaha bae kwiyamila ka wahela nzambi. ");
INSERT INTO ruf_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Imunu iyonihila nene, pfipfila komhila Aba wangu. ");
INSERT INTO ruf_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ka sighatendile bae kuna wawo aghala ng'ana ghatendighwe ne imunu yungi, sambi wang'akalile wahela nzambi. Lekeni sambi wapfona pfihulo pfanendile, nawo wang'ali wotuhila wose nene na Aba wangu. ");
INSERT INTO ruf_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Lekeni ilawila pfino kutimitsa imbuli iyandikighwe mne Ghamalaghitso ghawo. ‘Wanihila hela.’ ");
INSERT INTO ruf_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Nitsomtuma Mwapfitsi kulawa kwa Aba, ayo Ghumuhe Mwenzeluka. Ayo katsoghubula ukweli we Imulungu, na katsowalongela mbuli tsangu. ");
INSERT INTO ruf_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Pfipfila namwe mwobamighwa kulonga mbuli tsangu, kwaapfila mkala na nene kulawa mwanduso. ");
INSERT INTO ruf_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Yesu kaghendelela kulonga, “Niwalongela ghano ghose ili mleke ukwaghitsa ukutoghola kwenu. ");
INSERT INTO ruf_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Iwanu watsowawinga mne Ing'anda ya Ukulombela, na chipindi chakutsa chila yatsowakoma katsopfikitsa komlapfila Imulungu inambiko. ");
INSERT INTO ruf_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Iwanu watsowatendelani ghano kwaapfila ng'awommanya Aba, wala ng'awonimanya nene. ");
INSERT INTO ruf_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nimlongelani ghano, ili chipindi hachitsakutsa mkumbuke aghala ghaniwalongele. “Siwalongele ghano kulawa mwanduso kwaapfila tsanahamwe namwe. ");
INSERT INTO ruf_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Sambi noghenda kwa ayula iyanitumile, haduhu imunu iyonighutsa, ‘Ughenda kwani?’ ");
INSERT INTO ruf_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Kwaapfila niwalongela agha ghose, mimoyo yenu imema usungu. ");
INSERT INTO ruf_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Lekeni nowalongela ghendo, pfinogha kuna mwemwe nene mbuke, kwaapfila ka sikuka bae, Mwapfitsi ng'atsowatsilani. Lekeni ning'aghenda, nitsomghalilani. ");
INSERT INTO ruf_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Naye hayatsakutsa, katsolangusa iwanu wa iisi ka wakwalangula pfihile mne mbuli tsa nzambi, na mne mbuli tsa kutenda haki na Imulungu pfayohigha. ");
INSERT INTO ruf_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Tsawatotsa mne mbuli tsa nzambi, kwaapfila ng'awanitoghole, ");
INSERT INTO ruf_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Tsawatotsa mne mbuli tsa haki, kwaapfila noghenda kwa Aba, wala ng'amtsombona keli, ");
INSERT INTO ruf_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","na watotsa mne mbuli tsa kuhigha, kwaapfila Setani ma kahighighwa. ");
INSERT INTO ruf_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Nina mbuli nyingi tsa kumlongelani, ila sambi ng'amdaha bae kutsidudumila. ");
INSERT INTO ruf_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ghumuhe ghwe Imulungu hayatsokutsa, katsowalongotsa mmanye ukweli wose. Ng'atsolonga kwa uwetso wake bae, katsolonga aghala ghayahulike na katsowalongela aghala ighakutsa. ");
INSERT INTO ruf_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Hayo katsonitunya nene, kwaapfila katsowalangulitsa ghose ghayapatile kuna nene. ");
INSERT INTO ruf_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Pfinu pfose iyali napfo Aba pfa kwangu. Ndo mana tsaniwalongela Ghumuhe Mwenzeluka katsowalangulitsa aghala ghayapatile kuna nene. ");
INSERT INTO ruf_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Mne ichipindi chidodo ng'amtsombona keli, kuya ichipindi chidodo hambele mtsombona.” ");
INSERT INTO ruf_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Iwanang'ina wake wangi weghutsa, “Angu mbuli yachi ino hayalongile, ‘Mne ichipindi chidodo ng'amtsombona keli, kuya ichipindi chidodo hambele mtsombona?’ Kuya kolonga ‘Kwaapfila noghenda kwa Aba?’ ");
INSERT INTO ruf_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Waghendelela kwighutsa, ‘Ichipindi chidodo’ choni? Ng'atumanyile kolonga imbuli yachi.” ");
INSERT INTO ruf_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu kamanya chawabamile kumghutsa, apfo kawalongela, “Pfii mweghutsa tsanongile choni hanilongile, ‘Mne ichipindi chidodo ng'amtsombona keli, kuya ichipindi chidodo hambele mtsombona’? ");
INSERT INTO ruf_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nowalongela ghendo, mtsolila na kwona usungu mne mimoyo, lekeni isi itsodeng'elela. Mtsakuwa na usungu, ila usungu wenu utsoghaluka ndeng'elelo. ");
INSERT INTO ruf_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ipinga hayakweleka, kana usungu kwaapfila ichipindi chake cha kudununzika chipfika, lekeni imwana ang'oneka kosemwa usungu wake, kodeng'elela kwaapfila imwana koneka muisi. ");
INSERT INTO ruf_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Namwe pfipfila, sambi mna usungu, lekeni nitsomwonani keli, namwe mtsodeng'elela, kuduhu imunu iyodaha kuwaboka ndeng'elelo yenu. ");
INSERT INTO ruf_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Mne litsuwa lila ng'amtsonilomba chinu chochose. Nowalongela ghendo, Aba wangu katsomwing'ani chinu chochose chamlomba kwa taghwa lyangu. ");
INSERT INTO ruf_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Mbaka sambi ng'amlombile chinu chochose kwa taghwa lyangu. Mlombe, mtsobokela, na ndeng'elo yenu itsotimila. ");
INSERT INTO ruf_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Niwalongelani agha ghose kwa tsimbuli. Ichipindi chitsakutsa sitsolonga namwe kwa tsimbuli bae, ila nitsolonga mwatsimwatsi mbuli tsa Aba wangu. ");
INSERT INTO ruf_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Mne litsuwa lila mtsolomba kwa taghwa lyangu. Siwalongela ka nitsowalombela kwa Aba, ");
INSERT INTO ruf_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Aba imwenyegho kowanoghelani. Kowanoghelani kwaapfila tsamninoghela nene na mtoghola ka ndawa kwe Imulungu. ");
INSERT INTO ruf_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ndawa kwa Aba, nitsa muisi, lelo noileka iisi nakuya kwa Aba.” ");
INSERT INTO ruf_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Kuya iwanang'ina wake wamlongela, “Sambi kwolonga mwatsimwatsi bila ya tsimbuli. ");
INSERT INTO ruf_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Lelo twomanya kwomanya ghose, apfo ng'atubama bae kukughutsa keli. Chinu achi chotutenda tutoghole ka kulawa kwe Imulungu.” ");
INSERT INTO ruf_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu kawedika, “Pfii sambi mtoghola?” ");
INSERT INTO ruf_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ichipindi chakutsa, kuya ma chipfika, mwemwe wose mtsopwililika, chila imunu na ukaye yake. Mwemwe wose mtsondeka niliyeka. Lekeni siliyeka bae, kwaapfila na hamwe na Aba wangu. ");
INSERT INTO ruf_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Niwalongela agha ghose, ili mwilunge na nene na mkale tseghamba. Mne iisi ino mtsodununzika. Lekeni mwighangamitse! Niihuma iisi ino.” ");
INSERT INTO ruf_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu hayamalitse kulonga ghano, kalola kulanga kalonga, “Aba, chipindi chipfika. Watende iwanu wawone utunitso wa Imwanagho ili wawone utunitso wako kubitila Imwanagho. ");
INSERT INTO ruf_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kwaapfila kumwing'a Imwanagho uwetso kwe iwanu wose, ili yaweng'e ughima wa ghamatsuwa ghose wose waumwing'ile. ");
INSERT INTO ruf_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Auno iwo ughima wa ghamatsuwa ghose, iwanu wakumanye ghweghwe Imulungu uliyeka wa kweli, na wammanye Yesu Kiristu yaumtumile. ");
INSERT INTO ruf_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Niulangusa utunitso wako mne isi kwa kuimalitsa ng'onde yungaile niisang'ane. ");
INSERT INTO ruf_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Aba! Lelo unitunye, utunitso uhula yaning'ali nawo hamwe naghwe hala ng'ana iisi ilumbighwe. ");
INSERT INTO ruf_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Nilitenda taghwa lyako limanyike kwa iwanu wala yungaile muisi. Tsawakala wako, naghwe kungaya nene nawo waikinda imbuli yako. ");
INSERT INTO ruf_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Sambi womanya ipfinu pfose pfaungaile pfolawa kuna ghweghwe. ");
INSERT INTO ruf_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Kwaapfila niweng'a mbuli tsaungaile nawo watsitoghola, na wamanya ghendo ndawa kuna ghweghwe, watoghola ghweghwe kunituma. ");
INSERT INTO ruf_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Nowalombela. Siwalombela bae iwanu we iisi, ila nowalombela iwanu wala yungaile, kwaapfila awano iwo wako. ");
INSERT INTO ruf_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Iwanu wose wanilinawo wako, na wose yaulinawo wangu. Na utunitso woneka kubitila wawo. ");
INSERT INTO ruf_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Sambi nakutsa kuna ghweghwe, sili muisi keli bae, lekeni wawo wang'ali muisi. Aba Mwenzeluka! Walolese kwa ngupfu ya taghwa lyaungaile, ili wawe wamwe ka ghweghwe na nene pfatuli wamwe. ");
INSERT INTO ruf_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Haning'ali nawo, niwalolesa kwa ingupfu ya taghwa lyako lyaungaile. Kuduhu imunu yaghile ila yula iyasaghulighwe kwagha, ili Ghamaandiko Mahenzeluka ghatimile. ");
INSERT INTO ruf_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Sambi nakutsa kuna ghweghwe, tsanonga ghano ghose haning'ali muisi, ili wameme ndeng'elo yangu mne mimoyo yawo. ");
INSERT INTO ruf_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Niweng'a imbuli yako na iwanu wa iisi wawahila, kwaapfila wawo si wa iisi ino bae, na nene si wa iisi ino bae. ");
INSERT INTO ruf_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Sikulomba bae uwalapfe muisi, ila nokulomba uwalolese na ayula Yehile. ");
INSERT INTO ruf_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nene si wa iisi ino, nawo pfipfila si wa iisi ino bae. ");
INSERT INTO ruf_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Uwatende wawe wako kwa kweli yako, imbuli yako iyo kweli. ");
INSERT INTO ruf_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Niwatuma muisi, ka ghweghwe pfaunitumile muisi. ");
INSERT INTO ruf_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nelapfa imwenyegho kwaajili yawo, ili nawo welapfe ghendo kuna ghweghwe. ");
INSERT INTO ruf_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Siwalombela wawo waliyeka bae, ila pfipfila nowalombela iwanu wala iwatsonitoghola kwa usenga wawo. ");
INSERT INTO ruf_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nolomba wose wawe wamwe. Aba, nolomba wakale mghati mwetu, ka ghweghwe pfaukala mghati mwangu na nene pfanikala mghati mwako, ili iwanu we isi watoghole ka ghweghwe kunituma. ");
INSERT INTO ruf_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Niweng'a utunitso uhula yungaile, ili wawe wamwe ka twetwe pfatuli wamwe. ");
INSERT INTO ruf_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nene niwe mghati mwawo, naghwe uwe mghati mwangu, nolomba wawe wamwe ghendo, ili iwanu we iisi wamanye ghweghwe kunituma, na nene niwanoghela ka ghweghwe pfaunoghele nene. ");
INSERT INTO ruf_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Aba, nobama iwanu wala yungaile wakale na nene hanu hanili, ili wawone utunitso wangu. Utunitso yungaile, kwaapfila tsakuninoghela ng'ana iisi ilumbighwe. ");
INSERT INTO ruf_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Aba unoghile! Iwanu we iisi ng'awakumanyile bae, lekeni nene nokumanya, na wano womanya ka kunituma. ");
INSERT INTO ruf_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nikutenda wakumanye, na nitsoghendelela kutenda apfo, ili unoghelo wako kuna nene ukale mghati mwawo, na nene nikale mghati mwawo.” ");
INSERT INTO ruf_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu hayamalitse kulomba, yeye ne iwanang'ina wake waloka kumwambu mwa lwanda Kidironi. Hanu hala tsahana mghunda we mibiki, Yesu na iwanang'ina wake wengila amwo. ");
INSERT INTO ruf_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yuda, iyamhunduke Yesu, tsakahamanya hanu hala kwaapfila Yesu tsakaghendagha ne iwanang'ina wake. ");
INSERT INTO ruf_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Apfo Yuda kaghenda mne mghunda aghwo, hamwe ne kingili lya asikali na iwabetetsi wangi iwatumighwe na iwatambika wakulu na Mafarisayo. Tsawatsa ne pfitasa, pfiwenge na tsisilaha. ");
INSERT INTO ruf_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu tsakamanya ghose ighatsomlawila, kawaghendela kawaghutsa, “Mumbama nani?” ");
INSERT INTO ruf_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Wamwidika, “Yesu wa Natsareti,” Yesu kawalongela, “Nene iyo yuyo.” Yuda iyamhunduke tsakakala kema baho hamwe nawo. ");
INSERT INTO ruf_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesu hayawalongele, “Nene iyo yuyo,” woya kuchughu waghwa hasi. ");
INSERT INTO ruf_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yesu kawaghutsa keli, “Mumbama nani?” Wamwidika, “Yesu wa Natsareti.” ");
INSERT INTO ruf_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu kawalongela, “Tsaniwalongela nene iyo yuyo, ka mwombama nene, walekeni wano wangi woke.” ");
INSERT INTO ruf_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Kalonga apfi ili aghala ghayalongile ghatimile, “Iwanu awala yungaile simwaghitse bae hata yumwe.” ");
INSERT INTO ruf_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Kuya Simoni Petiri, tsakakala ne limaghe, kalisomola, kamsepula ghutwi lye kujilo imtumwa we Imtambika mkulu. Imtumwa ayo tsakakemighwa Malikusi. ");
INSERT INTO ruf_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesu kamlaghitsa Petiri, “Yuitsa limaghe lyako. Pfii ndeke kuchinwa ichikombe cha maghayo chayangaile Aba?” ");
INSERT INTO ruf_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Kuya asikali na imbala wawo na iwabetetsi we Ing'anda ye Imulungu ya Wayahudi wamghogha Yesu, wamwoha, ");
INSERT INTO ruf_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","tanu wamghala kwa Anasi. Anasi tsakakala mkwe yake Kayafa, Kayafa tsakakala Imtambika mkulu mwaka ghula. ");
INSERT INTO ruf_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafa iyo yuyula iyawalongele iwakulu we Wayahudi, ng'apfu imunu yumwe yafe kwaajili ye iwanu wose. ");
INSERT INTO ruf_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simoni Petiri ne imwanang'ina yungi wamuwinza Yesu. Kwaapfila imwanang'ina yula yungi tsakamanyika ne Imtambika mkulu, apfo kengila hamwe na Yesu hachikuta che Iwatambika wakulu, ");
INSERT INTO ruf_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","lekeni Petiri kema kunze mwa libani. Kuya imwanang'ina yula yungi koya, kalonga na ipinga mbetetsi wa libani, kuya ipinga ayo kamlongela Petiri yengile. ");
INSERT INTO ruf_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ipinga iyobetetsa libani kalonga na Petiri, “Apfi naghwe si imwanang'ina wa imunu yuno?” Petiri kamwidika, “Bae, nene si mwanang'ina wake.” ");
INSERT INTO ruf_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Kwaapfila tsakukala na chipfeghetsi, iwatumwa na iwabetetsi wabwina ghumoto, wang'ali wakota. Naye Petiri kema hamwe nawo, kota ghumoto. ");
INSERT INTO ruf_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Imtambika mkulu kamghutsa Yesu mbuli tsa iwanang'ina wake ne ghamalangulitso ghake. ");
INSERT INTO ruf_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu kamwidika, “Nilonga mwatsimwatsi ne iwanu wose, ghamatsuwa ghose tsanilangulitsa mne tsing'anda tsa ukulombela na mne tsing'anda tse Imulungu, hawetinganila hamwe Wayahudi wose. Silongile bae ichinu chochose chinyelenyele. ");
INSERT INTO ruf_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ule kwonighutsa nene? Waghutse yawanihulike. Waghutse chaniwalongele, womanya chanilongile.” ");
INSERT INTO ruf_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesu hayalongile ghano, imbetetsi yumwe yemile habehi kamtsaba Yesu chibawo kalonga, “Ule umwidika apfi Imtambika mkulu?” ");
INSERT INTO ruf_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu kamwidika, “Ka nilonga ichinu chihile, uchilonge hambele he iwanu. Lekeni ka nongesa, ule kwonitowa?” ");
INSERT INTO ruf_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Kuya Anasi kamghala Yesu kwa Kayafa Imtambika mkulu aku yang'ali kohighwa. ");
INSERT INTO ruf_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simoni Petiri tsayang'ali kema baho kakota ghumoto, iwanu wangi wamghutsa, “Ambe naghwe pfipfila kwa imwanang'ina wa imunu yuno?” Petiri kabela kalonga, “Si nene bae.” ");
INSERT INTO ruf_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Imtumwa yumwe wa Imtambika mkulu, ndughu yake imunu yula iyasepulighwe lighutwi na Petiri kamghutsa, “Angu sikwonile naye mne mghunda we imibiki?” ");
INSERT INTO ruf_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Petiri kabela keli, kalonga, “Bae.” Bahala jogholo keka. ");
INSERT INTO ruf_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Nemitondotondo Yesu tsakasolighwa mne ing'anda ya Kayafa kaghalighwa mne ing'anda ye imkulu wa Roma. Iwakulu we Wayahudi ng'awengile mng'anda, kwaapfila ng'awabamile wehe, ili wadahe kuchija ichijo che Ipasaka. ");
INSERT INTO ruf_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pilato kalawa kunze kawaghutsa, “Apfi imunu yuno kana ghomba lyachi?” ");
INSERT INTO ruf_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Wamwidika, “Ka ng'atendile totso tung'alekile kukughalila.” ");
INSERT INTO ruf_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato kawedika, “Msoleni mkamuhighe kwa ghamalaghitso ghenu.” Wayahudi wamwidika, “Ng'atubamighwa bae kumkoma imunu wowose.” ");
INSERT INTO ruf_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ilawila pfino ili tsitimile mbuli tsayalongile Yesu kulangusa katsokufatse. ");
INSERT INTO ruf_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Kuya Pilato kengila keli mng'anda, kamghutsa Yesu, “Apfi ghweghwe kwa Imndewa wa Wayahudi?” ");
INSERT INTO ruf_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu kamghutsa, “Agha ghaunighutsa ghalawa mghati mwako au iwanu wangi wakulongela mbuli tsangu?” ");
INSERT INTO ruf_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato kamwidika, “Apfi kwopfikitsa nene na Myahudi? Iwanu wako na iwatambika wako wakulu wakughala kuna nene. Angu utendile choni?” ");
INSERT INTO ruf_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu kalonga, “Undewa wangu si wa iisi ino bae, undewa wangu ung'awile wa iisi ino, iwatumighwa wangu wang'etowile na Wayahudi waleke kungogha. Bali undewa wangu si wa iisi ino!” ");
INSERT INTO ruf_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilato kamghutsa, “Apfi ghweghwe kwa mndewa?” Yesu kamwidika, “Ghweghwe kwolonga nene namndewa. Nyelekighwa na nitsa muisi kwaajili ayo, kulonga mbuli tsa ukweli. Iwanu wose iwonoghela ukweli wonitegheletsa.” ");
INSERT INTO ruf_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato kamghutsa, “Ukweli chinu chachi?” Kuya Pilato kalawa keli kunze kawalongela Wayahudi, “Sonile bae ghomba lya kumhigha imunu yuno. ");
INSERT INTO ruf_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Lekeni mne ichihendo chenu, nomlekelagha mwohighwa yumwe mne ghamatsuwa gha Ipasaka. Mwobama niwalekeleleni Imndewa wa Wayahudi?” ");
INSERT INTO ruf_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Wakemelela, “Bae, si yuno bae! Twombama Baraba! Baraba tsaang'ali yoboka iwanu.” ");
INSERT INTO ruf_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Kuya Pilato kalaghitsa Yesu yasolighwe, yapfapulighwe pfiboko. ");
INSERT INTO ruf_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Asikali wabota fiya ya tsimiwa walika mwitwi mwake. Kuya wampfatsa lighwanda lye chindewa. ");
INSERT INTO ruf_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Wamghendela wamlongela, “Mbukwa, imndewa wa Wayahudi!” Wamtowa makofi. ");
INSERT INTO ruf_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato kalawa keli kunze kawalongela Wayahudi, “Mlole, nomlapfa kunze na mmanye sipatile ghomba lya kumhigha.” ");
INSERT INTO ruf_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Apfo Yesu kalawa kunze kapfala fiya ya tsimiwa na lighwanda lye chindewa. Pilato kawalongela, “Mlole! Hayuno ano!” ");
INSERT INTO ruf_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Iwatambika wakulu na iwabetetsi we Ing'anda ye Imulungu hawamwonile Yesu, wakemelela, “Muwambe! Muwambe!” Pilato kawalongela, “Msoleni mkamuwambe mna msalaba mwemwe muwenyegho. Sonile bae ghomba lya kumhigha.” ");
INSERT INTO ruf_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Wayahudi wamwidika, “Twetwe tuna Laghitso, na kwa Laghitso alyo kobamighwa yafe, kwaapfila tsakalonga yeye ka Imwana we Imulungu.” ");
INSERT INTO ruf_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilato haulike apfi, kapfuka ghendo. ");
INSERT INTO ruf_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Kengila keli mng'anda kamghutsa Yesu, “Angu ulawila kwani?” Lekeni Yesu ng'edike bae. ");
INSERT INTO ruf_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilato kamlongela, “Kwolema kulonga na nene? Ng'umanyile bae ka nina uwetso wa kukulekelela au kukuwamba mna msalaba?” ");
INSERT INTO ruf_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu kamwidika, “Ghweghwe kuna uwetso wa kunihigha kwaapfila kwing'ighwa uwetso awo ne Imulungu. Apfo ayula iyangalile kuna ghweghwe kana nzambi ng'ulu ng'ani.” ");
INSERT INTO ruf_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilato hayahulike apfi, kabama nzila ya kumlekelela Yesu. Lekeni Wayahudi wadama, “Ung'amlekelela, ghweghwe si sale wa mndewa wa Roma bae! Imunu wowose iyolonga ka imndewa komlema mndewa wa Roma!” ");
INSERT INTO ruf_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilato hayahulike apfi, kamghala Yesu kunze, kakala mne ichighoda cha mlamutsi hanu hamanyike ka “Chibwalu che Ghamabwe.” Kwa Chihebulaniya “Gabatsa.” ");
INSERT INTO ruf_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ikala saa sita nemisi, litsuwa lya kuiyandaa Ipasaka. Pilato kawalongela Wayahudi, “Ayuno ano imndewa wenu!” ");
INSERT INTO ruf_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Lekeni Wayahudi wakemelela, “Mkome! Mkome! Mumuwambe mna msalaba!” Pilato kawaghutsa, “Mwombama nimuwambe imndewa wenu?” Iwatambika wakulu wamwidika, “Twetwe twahela imndewa yungi ila imndewa wa Roma yaliheka!” ");
INSERT INTO ruf_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Kuya Pilato kamlapfa Yesu, kaweng'a wakamuwambe. Kuya asikali wamsola Yesu. ");
INSERT INTO ruf_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Naye kalawa aku kaughala msalaba wake, kughenda hanu hakemighwe Bombwe lya Litwi. Kwa Chihebulaniya hokemighwa Goligota. ");
INSERT INTO ruf_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Baho wamuwamba Yesu mna msalaba, pfipfila tsawawawamba iwanu weli, yumwe ubali ungi na yungi ubali ungi, Yesu haghatighati. ");
INSERT INTO ruf_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato kandika chitango kachika mna msalaba. Kandika, “Yesu wa Natsareti, Imndewa wa Wayahudi.” ");
INSERT INTO ruf_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Wayahudi wengi wachisoma chitango chino, kwaapfila hanu hayawambighwe Yesu kukala habehi na ghumji, na chitango chandikighwa kwa Chihebulaniya, Chilatini na Chigiriki. ");
INSERT INTO ruf_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Iwatambika wakulu wamlongela Pilato, “Leka kwandika ‘Imndewa wa Wayahudi,’ ila imunu yuno tsakalonga yeye ka imndewa wa Wayahudi.” ");
INSERT INTO ruf_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilato kawedika, “Chanyandike, nyandika.” ");
INSERT INTO ruf_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Asikali hawamuwambile Yesu, wasola ghamaghwanda ghake, waghaghola mabughulu mane, chila bughulu kwa asikali yumwe. Pfipfila wasola na lighwanda lyake ing'alisonighwe bae, ilifumighwe kwandusila mchanya mbaka hasi. ");
INSERT INTO ruf_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Asikali welongetsa, “Tuleke kulidegha, leka tutowe simbi tulole yuhi yatsolipata.” Ilawila pfino ili ghatimile Ghamaandiko Maenzeluka igholonga, “Wegholela ghamaghwanda ghangu lighwanda lyangu walitowela simbi.” Apfi pfipfo pfawatendile asikali awo. ");
INSERT INTO ruf_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Habehi na msalaba wa Yesu tsawema mai wake, lumbu wa mai wake na Mariya mwehe wa Kileopa, na Mariya Magidalena. ");
INSERT INTO ruf_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesu hawonile mai wake ne imwanang'ina wake iyamnoghele wema hala, kamlongela mai wake, “Mai, ayuno iyo imwanagho.” ");
INSERT INTO ruf_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Kuya Yesu kamlongela imwanang'ina wake, “Ayuno ano iyo mai wako.” Kulawa baho, imwanang'ina ayo kamsola Mariya, kakala naye ukaye yake. ");
INSERT INTO ruf_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesu tsakamanya ka ghose ghatimila, ili Ghamaandiko Maenzeluka ghatimile, Yesu kalonga, “Nakwona ng'ilu.” ");
INSERT INTO ruf_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Hanu hala tsahakala na siki, apfo wapfabika lidodoki mne siki, walika mne lubiki lwa msopo, wamwikila mumlomo. ");
INSERT INTO ruf_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesu hayafonzile siki ayo kalonga, “Ghatimila.” Kenamisa litwi lyake, kafa. ");
INSERT INTO ruf_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Tsalikala Litsuwa lya Kwiyandaa, na litsuwa liwinzile likala Litsuwa lya Sabato. Iwakulu we Wayahudi ng'awabamile bae ng'uli tsisighale mna misalaba mne Litsuwa lya Sabato. Kwaapfila Litsuwa lya Sabato tsalikala litsuwa kulu. Wayahudi wamlomba Pilato ghamaghulu ghe iwanu iwawambighwe ghabenighwe, kuya mitufi yawo ihulumsighwe. ");
INSERT INTO ruf_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Apfo asikali waghenda, waghabena ghamaghulu gha imunu wa mwanduso iyawambighwe na Yesu, kuya waghabena ghamaghulu gha ayula yungi. ");
INSERT INTO ruf_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Lekeni hawapfikile kwa Yesu wampfika ma kafa, ng'awabenile bae ghamaghulu ghake. ");
INSERT INTO ruf_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Asikali yumwe kamuhoma Yesu mlubapfu kwa mghowa, bahala ilawa idamu na ghamatsi. ");
INSERT INTO ruf_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Imunu iyonile ichilawile katulongela ukalangama tutoghole. Na acho chayalongile kalongesa, kuya yeye komanya ka kolongesa. ");
INSERT INTO ruf_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ilawila pfino Ghamaandiko Mahenzeluka ghatimile, igholonga, “Kuduhu mpate wake yautsobenighwa.” ");
INSERT INTO ruf_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Kuya Ghamaandiko Mahenzeluka gholonga keli, “Watsomlola imunu yula iwamuhomile.” ");
INSERT INTO ruf_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Hambele, Yosefu imunu iyolawila ghumji ghwa Arimataya, kamlomba Pilato amwing'e lukuli lwa Yesu. Yosefu tsakakala imwanang'ina wa Yesu kwa chinyelenyele kwaapfila tsakawapfuka iwakulu wa Wayahudi. Pilato kamlongela Yosefu alusole lukuli lwa Yesu, apfo Yosefu kaghenda kalusola lukuli lwa Yesu. ");
INSERT INTO ruf_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Yosefu tsakelongotsa na Nikodemu, imunu yula iyaghendile kwa Yesu chilochilo aho mwanduso. Nikodemu tsakaghala pishi tano tse upfumba iunung'ila iutifighwe ne ubani. ");
INSERT INTO ruf_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Iwanu weli walusola lukuli lwa Yesu, walupfatsa sanda hamwe ne upfumba iunung'ila kwa ichihendo cha Wayahudi cha kutsika. ");
INSERT INTO ruf_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Hanu hayawambighwe Yesu tsakukala na mghunda we mibiki, mumghunda amwo tsakukala na mango lya kutsikila lya sambi, kuduhu imunu iyatsikighwe mmango amwo. ");
INSERT INTO ruf_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Kwaapfila likala Litsuwa lya Wayahudi kwitanda, na kwaapfila mango ikala habehi, walwika amwo lukuli lwa Yesu. ");
INSERT INTO ruf_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Nemitondotondo litsuwa lya mwanduso lya juma, kung'ali ne ichisi, Mariya Magidalena tsakaghenda mne imango, kona libwe lilapfighwa kulawa mne libani lya imango. ");
INSERT INTO ruf_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Katsuma kaghenda kwa Simoni Petiri ne imwanang'ina yungi, yula iyanoghelighwe na Yesu, kawalongela, “Walusola lukuli lwa Imtwatsa mmango, ng'atumanyile bae wamwikile kwani!” ");
INSERT INTO ruf_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Kuya Petiri ne imwanang'ina yungi waghenda mmango. ");
INSERT INTO ruf_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Wose weli tsawatsuma, lekeni yula imwanang'ina yungi katsuma kubita Petiri, kalongola kupfika mmango. ");
INSERT INTO ruf_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Kenama kasungulila mghati, tsakona sanda, lekeni ng'engile bae mghati. ");
INSERT INTO ruf_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Kuya Simoni Petiri, iyakalile kuchughu kwake, kapfika kengila mmango. Kona isanda, ");
INSERT INTO ruf_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","na chighwanda ichohighwe mwitwi mwa Yesu, ng'achikalile bae hamwe ne isanda ila chipfingilisa na chikala chiliyeka. ");
INSERT INTO ruf_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Kuya imwanang'ina yula yungi iyandusile kupfika mmango, pfipfila kengila mghati, kona, katoghola. ");
INSERT INTO ruf_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Tsawang'ali ng'awoghamanya bae Ghamaandiko Maenzeluka ighalongile Yesu kobamighwa yatsilihuke. ");
INSERT INTO ruf_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Kuya iwanang'ina woya ukaye. ");
INSERT INTO ruf_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mariya tsakema kunze mwa imango kolila. Hayang'ali yolila, kenama kasungulila mghati mwe imango, ");
INSERT INTO ruf_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","kawona malaika weli iwapfalile ghamaghwanda matselu, wakala hanu halukalile lukuli lwa Yesu, yumwe tsakakala halikalile litwi, yungi kakala haghakalile ghamaghulu. ");
INSERT INTO ruf_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Wamghutsa, “Mai, angu choulila choni?” Mariya kawedika, “Wamsola Imtwatsa wangu, na simanyile bae wamwikile kwani!” ");
INSERT INTO ruf_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Kuya Mariya kahunduka kamwona Yesu kema hala, lekeni ng'amanyile ka tsakakala Yesu. ");
INSERT INTO ruf_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu kamghutsa, “Mai, angu choulila choni? Umbama nani?” Mariya kapfikitsa kolonga ne imbetetsi wa imghunda we imibiki, apfo kamlongela, “Imtwatsa, ka kumsola, nongele umwikile kwani, ng'ende nikamsole.” ");
INSERT INTO ruf_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu kamlongela, “Mariya!” Mariya kamuhundukila kamlongela kwa Chihebulaniya “Raboni!” Mana yake Imlangulitsi. ");
INSERT INTO ruf_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu kamlongela, “Leka kunikinda, kwaapfila sina ng'ende bae kwa Aba. Ghenda ukawalongele ndughu tsangu nene nakuya kwa Aba wangu na Aba wenu pfipfila, Imulungu wangu na Imulungu wenu.” ");
INSERT INTO ruf_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mariya Magidalena kaghenda kawalongela iwanang'ina ka kamwona Imtwatsa, kawalongela achila Yesu chayamlongele. ");
INSERT INTO ruf_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Mihe ila mne litsuwa lya mwanduso lya juma, iwanang'ina hawetingane hamwe aku imibani ihindighwa kwa kuwapfuka iwakulu we Wayahudi, Yesu katsa, kema mghati mwawo, kawalongela, “Mkale tseghamba.” ");
INSERT INTO ruf_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Hayamalitse kulonga ghano, Yesu kawalangusa ghamoko ghake na lubapfu lwake. Iwanang'ina tsawadeng'elela hawamwonile Imtwatsa. ");
INSERT INTO ruf_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesu kawalongela keli, “Mkale tseghamba. Ka Aba pfayanitumile nene, na nene nomtumani mwemwe.” ");
INSERT INTO ruf_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Kuya kawahumulila, kawalongela, “Bokeleni Ghumuhe Mwenzeluka. ");
INSERT INTO ruf_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Mng'awaleghusila nzambi iwanu, iwanu awo woleghusighwa nzambi, ka ng'amuwaleghusila nzambi, iwanu awo ng'awoleghusighwa nzambi bae.” ");
INSERT INTO ruf_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Mwanang'ina yumwe mne iwanang'ina kumi na weli, Tomasi, iyakemighwe Basa, ng'awile baho hayatsile Yesu. ");
INSERT INTO ruf_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Apfo iwanang'ina wangi wamlongela, “Tumwona Imtwatsa!” Lekeni Tomasi kawalongela, “Ka sitsona bae ng'opfu tsa misumari mne ghamoko ghake na kwika chidole changu mne ng'opfu atso, na kwika ghumoko ghwangu mlubapfu mwake, sitoghola bae.” ");
INSERT INTO ruf_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Haghabitile matsuwa manane iwanang'ina wetingana keli mng'anda, na Tomasi tsakakala nawo. Imibani tsaihindighwa, lekeni Yesu katsa, kema mghati mwawo, kawalongela, “Mkale tseghamba.” ");
INSERT INTO ruf_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Kuya Yesu kamlongela Tomasi, “Wike chidole chako hano, ulole ghamoko ghangu, kuya gholosa ghumoko ghwako ughwike mlubapfu mwangu. Leka kulema kutoghola, utoghole!” ");
INSERT INTO ruf_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomasi kamwidika, “Imtwatsa wangu na Imulungu wangu!” ");
INSERT INTO ruf_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesu kamlongela, “Kwotoghola kwaapfila kumbona? Wabweda awala iwotoghola bila kumbona!” ");
INSERT INTO ruf_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu tsakatenda pfihulo pfingi hayakalile ne iwanang'ina wake, ila ng'apfandikighwe bae mne ichitabu chino. ");
INSERT INTO ruf_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Lekeni mbuli tsino tsandikighwa ili mghendelele kutoghola Yesu ka Kiristu Mkombotsi, Imwana we Imulungu na kwa kumtoghola muwe ne ughima kwa ngupfu ya taghwa lyake. ");
INSERT INTO ruf_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Hambele Yesu kawalawila keli iwanang'ina wake mmbalimbali mwa tsimbu Tiberiya. Tsakawalawila pfino, ");
INSERT INTO ruf_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simoni Petiri, Tomasi iyakemighwe Basa, Nasanaeli iyalawile Kana ghumji ghwa Galilaya, iwana wa Sebedayo, ne iwanang'ina wangi weli wa Yesu wose tsawakala hamwe. ");
INSERT INTO ruf_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simoni Petiri kawalongela, “Noghenda kulowa iwasomba.” Wamlongela, “Twoghenda naghwe.” Apfo wengila mumnumbwi, lekeni chilo chila chose ng'awapatile chinu bae. ");
INSERT INTO ruf_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Nemitondotondo, Yesu tsakema mmbalimbali mwa tsimbu, lekeni iwanang'ina ng'awamtangile bae ka tsa Yesu. ");
INSERT INTO ruf_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Kuya Yesu kawaghutsa, “Sale tsangu, ng'ampatile chinu bae?” Wamwidika, “Ona, ng'atupatile chinu.” ");
INSERT INTO ruf_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Kuya Yesu kawalongela, “Mwase ichelo lubali lwa kumoso lwe imnumbwi, mtsolowa iwasomba.” Apfo wasa ichelo mmatsi na ng'awadahile bae kukwegha kwaapfila tsawapata iwasomba wengi ng'ani. ");
INSERT INTO ruf_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Kuya imwanang'ina yumwe, iyanoghelighwe na Yesu kamlongela Petiri, “Ayuno ka Imtwatsa.” Bahala Simoni Petiri ayahulike yula tsakakala Imtwatsa, keyoha lighwanda lyake kwaapfila tsakalitsula. Kuya kadalukila mmatsi. ");
INSERT INTO ruf_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Iwanang'ina wangi watsa mne mnumbwi, kwaapfila ng'awakalile hatali ne isi, ila tsawakala utali wa ghamaghulu miya imwe, tsawakwegha ichelo ichimemile iwasomba. ");
INSERT INTO ruf_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Hawapfikile mmbalimbali mwa tsimbu, wona ghumoto na iwasomba wekighwa mchanya mwake, na chighate. ");
INSERT INTO ruf_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesu kawalongela, “Mngaye iwasomba wangi wamlowile.” ");
INSERT INTO ruf_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Kuya Simoni Petiri kadina mne mnumbwi, kakwegha ichelo mmbalimbali mwe tsimbu, ichimemile iwasomba wakulu miya imwe na hamsini na tatu. Hata ka tsakukala ne iwasomba wengi, ichelo ng'achidegheke bae. ");
INSERT INTO ruf_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu kawalongela, “Mtse mje.” Kuduhu imwanang'ina iyaghetsile kumghutsa, “Ghweghwe uli nani?” Kwaapfila wammanya tsakakala Imtwatsa. ");
INSERT INTO ruf_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesu katsa, kasola pfighate ne iwasomba wala, kaweng'a. ");
INSERT INTO ruf_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Aluno lukala lwakadatu Yesu kuwalawila iwanang'ina wake kulawa hayatsilihuke. ");
INSERT INTO ruf_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Hawamalitse ukuja, Yesu kamghutsa Simoni Petiri, “Simoni imwana wa Yohane, apfi kwoninoghela kubita wano?” Simoni Petiri kamwidika, “Ona, Imtwatsa ghweghwe kwomanya ka nene nokunoghela.” Yesu kamlongela, “Wadime iwanang'olo wangu.” ");
INSERT INTO ruf_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Kuya Yesu kamghutsa lwa keli, “Simoni imwana wa Yohane, apfi kwoninoghela.” Petiri kamwidika, “Ona, Imtwatsa ghweghwe kwomanya ka nene nokunoghela.” Yesu kamlongela, “Wadime iwang'olo wangu.” ");
INSERT INTO ruf_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yesu kamghutsa keli lwa kadatu, “Simoni mwana wa Yohane, kwoninoghela?” Simoni Petiri kona usungu kwaapfila Yesu kamghutsa lwa kadatu, “Apfi kwonoghela?” Kamwidika, “Imtwatsa, kwomanya pfinu pfose, kwomanya ka nokunoghela.” Yesu kamlongela, “Wadime iwang'olo wangu. ");
INSERT INTO ruf_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nokulongela ghendo, haung'ali msongolo, tsakutsowela kupfala msipi imwenyegho na kughenda hanu haubamile, lekeni hautsolala kutsogholosa ghamoko ghako, imunu yungi katsokwoha na kukughala hanu ng'aubamile bae kughenda.” ");
INSERT INTO ruf_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesu kalonga pfino, kulangusa Petiri pfayatsokufa na kumtunitsa Imulungu. Kuya Yesu kamlongela, “Niwinze!” ");
INSERT INTO ruf_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petiri kahunduka, kamwona imwanang'ina yula iyanoghelighwe na Yesu kowawinza. Imwanang'ina yuno tsakakala yula iyakalile na Yesu mne ichijo cha Ipasaka na iyamghutsile, “Mtwatsa, yuhi iyatsokuhunduka?” ");
INSERT INTO ruf_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Petiri hamwonile, kamghutsa Yesu, “Imtwatsa, ayuno naye?” ");
INSERT INTO ruf_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu kamwidika, “Ka nombama akale mghima mbaka hanikuya, ghweghwe ubama choni? Ghwe niwinze!” ");
INSERT INTO ruf_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Apfo mbuli tsenela kwa wandughu kuwa imwanang'ina yula ng'atsakufa bae. Lekeni Yesu ng'alongile ka imwanang'ina yuno ng'atsakufa. Bali kalonga, “Ka nombama akale mghima mbaka hanikuya, ghweghwe ubama choni?” ");
INSERT INTO ruf_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ayuno iyo imwanang'ina iyalongile agha ghose na kughandika, na twetwe twomanya ghano ghayalongile gholongesa. ");
INSERT INTO ruf_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesu tsakatenda pfinu pfingi. Pfinu pfose pfing'andikighwe chimwechimwe, isi yose ing'akalile yahela hanu he ukwika ipfitabu ipfandikighwe.");
INSERT INTO ruf_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Kuna imkulu Teofili, Mne ichitabu changu chanongole ukwandika, tsanyandika ipfinu pfose Yesu pfatendile na pfayalangulitse, kulawa handuse isang'ano yake ");
INSERT INTO ruf_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","mbaka litsuwa lila hayasolighwe kughenda kulanga. Ichipindi ng'ana yasolighwe, tsakaweng'a malaghitso kwa uwetso wa Ghumuhe Mwenzeluka iwatumighwa wala iyawasaghule. ");
INSERT INTO ruf_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Matsuwa alubaini kulawa hafile, Yesu kawalawila mala nyingi na kwilangusa ghendo ka tsakakala mghima. Wamwona, naye kalonga nawo mbuli tse Undewa we Imulungu. ");
INSERT INTO ruf_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Na litsuwa limwe, hayang'ali yakuja nawo kawalaghitsa pfino, “Mleke kulawa Yerusalemu, ila mwemwe mbete achila chayalongile Aba, iyo Ghumuhe yamnihulike nomlonga. ");
INSERT INTO ruf_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yohane tsakabatitsa kwa ghamatsi, lekeni matsuwa chidogho ighakutsa, mtsobatitsighwa kwa Ghumuhe Mwenzeluka.” ");
INSERT INTO ruf_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Iwatumighwa hawetingane na Yesu, wamghutsa, “Imtwatsa, pfii matsuwa ghano kutsowoyitsila Waisiraeli Undewa?” ");
INSERT INTO ruf_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yesu kawalongela, “Matsuwa na msimu pfamne uwetso wa Aba wangu, mwemwe ng'ambamighwa bae kumanya itsakuwa tsuwachi. ");
INSERT INTO ruf_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Lekeni Ghumuhe Mwenzeluka hatsowahulumkila, mtsobokela ingupfu, namwe mtsakuwa iwakalangama wangu ako Yerusalemu, mne tsiisi tsa Yudeya na Samariya, na muisi mwose.” ");
INSERT INTO ruf_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Hayamalitse kulonga apfo kasolighwa kulanga, aku wose womlola, kuya liwingu limghubika nawo ng'awamwonile keli bae. ");
INSERT INTO ruf_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Hawang'ali wotsodola tsinenge kulanga Yesu hang'ali yakuka, bahala iwanu weli iwapfalile maghwanda matselu wema habehi yawo, ");
INSERT INTO ruf_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","walonga, “Mwemwe iwanu wa Galilaya! Ebali mwima hano mwolola kulanga? Yesu yuyuno, iyasolighwe kuna mwemwe kughenda kulanga, katsakuya keli ka pfipfo pfammwonile kakuka kulanga.” ");
INSERT INTO ruf_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Kuya iwatumighwa woya Yerusalemu kulawa mne Chidunda cha Mitseituni, utali wa chilomita ka imwe kulawa mkaye. ");
INSERT INTO ruf_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Hawapfikile mkaye, wengila mne chiheleto cha kuchanya chawang'ali wokalagha. Nawo tsawakala Petiri, Yohane, Yakobu, Andereya, Filipi, Tomasi, Batalomeyo, Matei, Jakobu imwana we Alifayo, Simoni Mkanani na Yuda mwanaghe Jakobu. ");
INSERT INTO ruf_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Awo wose tsawaghendelela kwitingana hamwe ukulomba, hamwe ne iwapinga wangi, na Mariya mai wake Yesu, na ndughu tsake Yesu. ");
INSERT INTO ruf_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Litsuwa limwe mne matsuwa agho, Petiri kema haghati he iwanu iwetingane. Tsawakala iwanu miya imwe na ishilini. ");
INSERT INTO ruf_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Petiri kalonga, “Ndughu tsangu, tsaibamighwa Ghamaandiko Mahenzeluka ghatimile. Ghumwande Ghumuhe Mwenzeluka tsakalonga kubitila Daudi, Daudi tsakatabili mbuli tsa Yuda, iyawalongotse iwanu wala iwamghoghile Yesu. ");
INSERT INTO ruf_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yuda tsakakala miyetu kwaapfila tsakasaghulighwa na Yesu tusang'ane naye.” ");
INSERT INTO ruf_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Yeye tsakaghula mghunda kwa sendi tsapatile kwa sang'ano yake ila ihile, kaghwa hamo, katulika na usapi wake wose ulawa kunze. ");
INSERT INTO ruf_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Iwanu wose wa Yerusalemu tsawahulika mbuli atso, apfo mne chilugha chawo waghukema mghunda aghwo Akelidama, mana yake “Mghunda ghwe Idamu.” ");
INSERT INTO ruf_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Petiri kalonga, “Kwaapfila yandikighwa mne Tsaburi, ‘Ing'anda yake ikale uchuwa, imunu wowose aleke kukala mng'anda amwo.’ Pfipfila yandikighwa, ‘Imunu yungi yeng'ighwe isang'ano yake ya kulongotsa.’ ");
INSERT INTO ruf_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Apfo yobamighwa kumsaghula imunu yumwe kulawa mne iwanu iwelongotse na twetwe matsuwa ghose Imtwatsa Yesu hayang'ali na twetwe, ");
INSERT INTO ruf_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","kulawa Yohane hayang'ali yobatitsa mbaka litsuwa lila Yesu hayasolighwe kulawa kuna twetwe kughenda kulanga. Imunu ayo kobamighwa yawe mkalangama miyetu wa kutsilihuka kwa Yesu.” ");
INSERT INTO ruf_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Apfo wasaghula mataghwa meli, Yosefu iyakemighwe Barisaba, pfipfila tsakakemighwa Yusti, na wa keli Matiasi. ");
INSERT INTO ruf_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Kuya walomba, “Imtwatsa, ghweghwe kwoimanya imimoyo ye iwanu wose. Lelo utulanguse, imunu yuhi yumsaghule mne iwanu wano weli ");
INSERT INTO ruf_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ili asole isang'ano ye utumighwa yailekile Yuda na kughenda hanu hake imwenyegho.” ");
INSERT INTO ruf_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Kuya watowa simbi, na simbi imghwila Matiasi, naye kongetsighwa mne iwatumighwa wala kumi na yumwe. ");
INSERT INTO ruf_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Litsuwa lya Pentekoste halipfikile, wose iwamtoghole Yesu tsawetingana hanu hamwe. ");
INSERT INTO ruf_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Bahala, iwanu wahulika chinu choduma kulawa kulanga ka beho liduma kwe ingupfu, limemesa ing'anda yose iwakalile iwanu awo. ");
INSERT INTO ruf_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Kuya, pfilawila ipfinu ipfikoneka ka milambi ya ghumoto, napfo pfipwililika na kukala mchanya mwa chila imunu. ");
INSERT INTO ruf_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Wose tsawamemesighwa Ghumuhe Mwenzeluka, wandusa kulonga lugha tsingi ka Ghumuhe Mwenzeluka pfayawatendile wadahe kulonga. ");
INSERT INTO ruf_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ako Yerusalemu tsakukala na Wayahudi iwompfuka Imulungu iwalawile chila isi. ");
INSERT INTO ruf_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Hawahulike litsi alyo, iwanu wetingana hamwe. Wose wakangawala kwaapfila chila imunu kawahulika wolonga kwa chilugha chake imwenyegho. ");
INSERT INTO ruf_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Wakangawala ng'ani, walonga, “Pfii, iwanu wano wose watuwahulika wolonga pfino, si Wagalilaya bae? ");
INSERT INTO ruf_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ebali lelo, chila imunu mna twetwe kowahulika wolonga chokaye? ");
INSERT INTO ruf_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Wamwenga twolawila Paritiya, Midiya na Elamu, wamwenga wolawila Mesopotamiya, Yudeya, Kapadokiya, Ponto na isi ya Asiya, ");
INSERT INTO ruf_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Na wamwenga wolawa Firigiya, Pamfiliya, Misiri na kaye tsa Libiya tsili habehi na Kirene, wamwenga wetu wolawila Roma, ");
INSERT INTO ruf_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","na Wayahudi ne iwanu iwengile mne dini ya Chiyahudi, wamwenga wolawila Kirete ne Arabiya. Twetwe wose twowahulika wolonga ipfinu pfikulu pfayatendile Imulungu kwa lugha tsetu iwenyegho.” ");
INSERT INTO ruf_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Wose wakangawala, wapfuka, weghutsa, “Achi nacho choni?” ");
INSERT INTO ruf_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Lekeni iwanu wangi wawabetsa, walonga, “Iwanu wano wapatika!” ");
INSERT INTO ruf_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Kuya Petiri kema nawo iwatumighwa wala kumi na yumwe, kandusa kuwalongela iwanu awo kwa kukemelela, “Wayahudi weyangu, na mwemwe mwose yamkala hano Yerusalemu, mleke niwalongele, namwe mtegheletse ghoya chanilonga. ");
INSERT INTO ruf_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Iwanu wano ng'awapatike bae ka pfamlonga. Sambi saa tatu nemitondo! ");
INSERT INTO ruf_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Achino ichilawile chicho chayalongile Yoeli, nabii we Imulungu, ");
INSERT INTO ruf_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Imulungu kolonga, mne matsuwa gha utsighilo nitsowamwaghila iwanu wose Ghumuhe ghwangu. Iwana wenu na neghe tsenu watsopeta mbuli yangu, iwasongolo wenu watsakona ghamaono, ne iwabala wenu watsolota tsindoto. ");
INSERT INTO ruf_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Hata iwatumwa wangu pfipfila, wose iwamale ne iwapinga nitsowamwaghila Ghumuhe ghwangu mne matsuwa agho, nawo watsopeta mbuli yangu. ");
INSERT INTO ruf_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nitsotenda pfihulo uchanya kulanga, ne ipfinu pfa ukukangawatsa muisi, kutsakuwa na idamu, ghumoto na hosi tito. ");
INSERT INTO ruf_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Litsua litsoghaluka kuwa chisi, na lwetsi lutsakuwa ludung'u ka idamu, aho ng'ana lipfike litsuwa lila likulu lye utunitso we Imtwatsa. ");
INSERT INTO ruf_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ne imunu wowose iyatsolomba kwa taghwa lye Imtwatsa katsokombolighwa.’ ");
INSERT INTO ruf_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Iwanu we Isiraeli, mtegheletse imbuli ino! Yesu wa Natsareti tsakakala imunu yane uwetso iyalangusighwe kuna mwemwe kwe pfihulo, pfinu pfa kukangawatsa ne ipfitango pfatendile Imulungu kuna mwemwe kubitila yeye, ka mwemwe iwenyegho pfammanya. ");
INSERT INTO ruf_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Kulawa mwanduso Imulungu imwenyegho tsakabama Yesu aghoghighwe na mwemwe, namwe mumkoma kwa kuwaleka iwanu wehile wamuwambe mna msalaba. ");
INSERT INTO ruf_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Lekeni Imulungu kamtsiliula Yesu, kamkombola kulawa mne usungu we lifwa kwaapfila ng'aidahike bae lifwa limwohe. ");
INSERT INTO ruf_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Mana Daudi tsakalonga pfino mbuli tsa Yesu, ‘Tsanimwona Imtwatsa hambele hangu matsuwa ghose Kwaapfila yeye ka habehi hangu Sitsohighisika bae. ");
INSERT INTO ruf_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Apfo, ghumoyo ghwangu ghwodeng'elela, lulimi lwangu lolonga kwa kudeng'elela, na lukuli lwangu lutsokala kwa lolelo, ");
INSERT INTO ruf_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","kwaapfila ng'utsondeka kutsimu bae, ng'utsomleka bae Mwenzeluka wako yole mne likabuli. ");
INSERT INTO ruf_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Kunilangusa inzila ye ughima, kutsonimemesa ndeng'elo kwaapfila kwa hamwe na nene.’ ");
INSERT INTO ruf_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Wandughu, ndekeni nonge mwatsimwatsi mbuli tsa aba wetu mkulu Daudi. Yeye kafa, katsikighwa na likabuli lyake lyabahano mbaka leloli. ");
INSERT INTO ruf_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Lekeni kwaapfila Daudi tsakakala nabii we Imulungu, kamanya ka Imulungu kelaha kuna yeye ka ang'amtendile mtsukulu wake yumwe yawe imndewa ka pfayakalile Daudi. ");
INSERT INTO ruf_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Daudi tsakalongola kughona agho ighatsotendighwa ne Imulungu, apfo kalonga mbuli tse ukutsilihuka kwa Kiristu Mkombotsi, hala hayalongile, ‘Ng'alekighwe kutsimu bae, wala lukuli lwake ng'alolile bae.’ ");
INSERT INTO ruf_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“Imulungu iyo yamtsilihule ayo Yesu, na twetwe twa iwakalangama we chinu acho. ");
INSERT INTO ruf_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Naye Yesu henulighwe na kwikighwa lubali lwa kujilo lwe Imulungu, kabokela Ghumuhe Mwenzeluka kulawa kwa Aba wake ka pfayatulongele. Kuya katughalila Ghumuhe ayo, na acho chicho chamchona sambi na kuchihulika. ");
INSERT INTO ruf_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Kwaapfila si Daudi bae iyasolighwe kughenda kulanga, ila yeye kalonga, ‘Imtwatsa kamlongela Imtwatsa wangu, ukale hano hane ubali wangu wa kujilo ");
INSERT INTO ruf_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","mbaka niwatende wehile wako wawe hasi ha ghamaghulu ghako.’ ");
INSERT INTO ruf_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Apfo iwanu wose wa Isiraeli wobamighwa wamanye ghendo, Imulungu kamtenda ayu Yesu imumuwambile mna msalaba yawe Imtwatsa na Kiristu Mkombotsi.” ");
INSERT INTO ruf_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Iwanu hawahulike agho, ghawahoma ghendo mmoyo, wawaghutsa Petiri na iwatumighwa wangi, “Ndughu tsetu, lelo tutendatse?” ");
INSERT INTO ruf_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petiri kawedika, “Chila imunu yatsileke nzambi tsake, mbatitsighwe kwa taghwa lya Yesu Kiristu, na Imulungu katsomleghusilani nzambi tsenu. Namwe mtsobokela laghano lye Imulungu, iyo Ghumuhe Mwenzeluka. ");
INSERT INTO ruf_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kwaapfila laghano lila tsamwikilighwa mwemwe, na iwana wenu, na iwanu wose iwali kutali na awala wose iwatsokemighwa ne Imtwatsa Imulungu wetu.” ");
INSERT INTO ruf_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Kwa mbuli nyingi Petiri kawakomangitsa iwanu, kalonga, “Mwikombole kulawa mweleko ghuno ghuhile.” ");
INSERT INTO ruf_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Iwanu wengi watsitoghola mbuli tsake, wabatitsighwa. Mne litsuwa lila, iwanu ka 3,000 wongetseka. ");
INSERT INTO ruf_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Awo wose waghendelela kulangulitsighwa ne iwatumighwa wa Yesu, wakala hamwe ka iwandughu, wamegha ichighate na walomba hamwe. ");
INSERT INTO ruf_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Iwatumighwa tsawatenda pfihulo na pfinu pfa kukangawatsa pfingi, chila imunu ang'ali yopfuka. ");
INSERT INTO ruf_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Iwatoghole wose waghendelela kukala hamwe na kwigholela ipfinu pfawo. ");
INSERT INTO ruf_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Tsawang'ali wohutsa mali tsawo ne ipfinu pfawo na kwigholela sendi ka chila imunu pfayabamile. ");
INSERT INTO ruf_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Waghendelela kwitingana mne ing'anda ye Imulungu chila litsuwa. Lekeni hawang'ali womegha chighate, tsawetingana mne tsing'anda tsawo na ukuja ichijo acho kwa ndeng'elo na ghumoyo mtselu. ");
INSERT INTO ruf_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Tsawamtunitsa Imulungu ne iwanu wose wanoghelesighwa nawo. Na chila litsuwa Imtwatsa yang'ali yowongetsela iwanu iwang'ali wokombolighwa. ");
INSERT INTO ruf_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Litsuwa limwe, Petiri na Yohane wang'ali woghenda mne ing'anda ye Imulungu saa tisa nemisi, iwanu hawoghendagha kulomba. ");
INSERT INTO ruf_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Iwanu tsawang'ali womghalagha imunu yumwe iyakalile chimbete kulawa kwelekighwa kwake. Chila litsuwa iwanu wang'ali womwika imunu ayo mne libani lye ing'anda ye Imulungu ilikemighwe “Libani linoghile” ili yalombe chochose kwe iwanu iwang'ali wakwingila mne Ing'anda ye Imulungu. ");
INSERT INTO ruf_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Hayawonile Petiri na Yohane wakwingila mng'anda, kawalomba wamwing'e chochose. ");
INSERT INTO ruf_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Nawo wamtsodolela tsinenge. Kuya Petiri kamlongela, “Tulolese!” ");
INSERT INTO ruf_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Naye kawalola, kalolela kupata ichinu chochose kulawa kuna wawo. ");
INSERT INTO ruf_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Lekeni Petiri kamlongela, “Nahela sendi, ila nokwing'a achila chanili nacho, kwa taghwa lya Yesu Kiristu wa Natsareti, winuke ughende!” ");
INSERT INTO ruf_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Kuya kamkinda ghumoko ghwake ghwa kujilo, kamwapfila ukwinuka, bahala ghamaghulu, na mbweghele tse imunu ayo tsiwa na ngupfu. ");
INSERT INTO ruf_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Kadaluka kwa ghamaghulu ghake na kwandusa ukughenda. Kuya kengila nawo mne Ing'anda ye Imulungu, koghenda kodaluka daluka aku komtunya Imulungu. ");
INSERT INTO ruf_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Iwanu wose hawamwonile koghenda na komtunya Imulungu, ");
INSERT INTO ruf_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","wamtanga yeye kayuyula iyang'ali yolomba habehi na “Libani linoghile” lye Ing'anda ye Imulungu, weduka, wakangawala kwa achila ichimlawile. ");
INSERT INTO ruf_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Imunu ayo hang'ali yoghenda na Petiri na Yohane, iwanu wose wang'ali wokangawala na wandusa kutsumila hanu ha kwitinganila hakemighwe “Ukumbi wa Selemani.” ");
INSERT INTO ruf_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Petiri honile apfi, kawalongela, “Iwanu wa Isiraeli, ebali mwokangawala kwe ichinu chino? Mbona mwotutsodolela tsinenge ka twetwe itumtendile imunu yuno yadahe kughenda kwa ngupfu tsetu iwenyegho au kwaapfila tunogha hambele he Imulungu? ");
INSERT INTO ruf_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Imulungu wa Abrahamu, Isaka na Yakobu, Imulungu we iwabala wetu, tsakamtunya Yesu imtumighwa wake, ila mwemwe mumghogha ili yakomighwe, namwe mumlema hambele ha Pilato, lekeni Pilato tsakabama yamlekelele yoke. ");
INSERT INTO ruf_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Tsakakala Mwenzeluka na imunu yanoghile, lekeni mwemwe mumlema, mumlomba Pilato yamlekelele imunu iyakomile. ");
INSERT INTO ruf_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Mwemwe mumkoma yeye yali mwanduso wa ughima, lekeni Imulungu kamtsilihula kulawa mne lifwa, na twetwe twa wakalangama we ichinu acho. ");
INSERT INTO ruf_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Kwa kutoghola taghwa lya Yesu, imunu ayu immwona na imummanya keng'ighwa ingupfu. Ukutoghola na taghwa lya Yesu pfimhonetsa ghendo imunu ayu ka wose pfammwona. ");
INSERT INTO ruf_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Lelo ndughu tsangu, nomanya ka mwemwe ne iwakulu wenu mghatenda agho kwaapfila ng'ammanyile bae. ");
INSERT INTO ruf_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Lekeni Imulungu katimitsa achila chayalongile ghumwande kubitila manabii wose we Imulungu, ka ibamighwa Kiristu wake yadununzike. ");
INSERT INTO ruf_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Lelo mtsileke nzambi tsenu mmuyile Imulungu, ili yawaleghusile nzambi tsenu. Mng'atenda apfo, ");
INSERT INTO ruf_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","mtsakongetsighwa ngupfu tsa muhe kulawa kwe Imtwatsa, naye katsomtuma Yesu Kiristu, iyamsaghulileni. ");
INSERT INTO ruf_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Kobamighwa akale kulanga mbaka ichipindi che Imulungu kutenda ipfinu pfose pfiwe pfa sambi chipfike, ka pfayalongile ghumwande kubitila manabii wake wahenzeluka. ");
INSERT INTO ruf_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Kwaapfila Musa tsakalonga, ‘Imtwatsa Imulungu wenu katsomghalileni nabii wake ka pfanighalile nene, ayo katsolawila mghati mwenu mwenyegho, mwobamighwa muhulikitse chila ichinu chayowalongela. ");
INSERT INTO ruf_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Imunu wowose iyolema kumuhulikitsa nabii ayo, katsobaghulighwa kulawa kwe iwanu we Imulungu na katsokomighwa.’ ");
INSERT INTO ruf_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Wanabii wose we Imulungu, kwanzila Samweli na awala iwatsile hambele, tsawalonga mbuli tse ipfinu ipfilawila mne matsuwa ghano. ");
INSERT INTO ruf_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Imulungu tsakawalapfila mwemwe laghano kubitila wanabii we Imulungu, namwe mwamghati mwa laghano lila lyatendile Imulungu ne iwabala wenu, ka pfayamlongele Abrahamu, ‘Kubitila mweleko ghwako, nitsowabaliki iwanu wose muisi mwose.’ ");
INSERT INTO ruf_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Imulungu hayamtsilihule imtumighwa wake, tanu kamtumilani mwemwe, yawabaliki na yamtende chila yumwe wenu aleke kutenda ghehile.” ");
INSERT INTO ruf_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petiri na Yohane hawang'ali wowalongela iwanu, iwatambika wakulu ne iwakulu wa wakalitsa Ing'anda ye Imulungu hamwe na Masadukayo tsawapfika. ");
INSERT INTO ruf_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Tsawona maya ng'ani kwaapfila iwatumighwa awo wang'ali wolangulitsa iwanu ka Yesu katsilihuka, ichinu ichikonesa ghendo ka iwanu iwafile watsotsilihuka. ");
INSERT INTO ruf_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Apfo wawaghogha Petiri na Yohane, waweka mwigheletsa mbaka ilupfi yake, kwaapfila tsaikala nemihe. ");
INSERT INTO ruf_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Lekeni iwanu wengi iwahulike imbuli yawailongile Petiri na Yohane watoghola, na iwanu iwatoghole tsawongetseka na kuwa ka iwanu elufu tano. ");
INSERT INTO ruf_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Litsuwa liwinzile, iwakulu wa Wayahudi, iwabala ne iwolangulitsa Ghamalaghitso wetingana hamwe ako Yerusalemu. ");
INSERT INTO ruf_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Tsawetingana ne Imtambika mkulu Anasi, Kayafa, Yohane, Alekisanda na iwanu wangi wa lukolo lwa Imtambika mkulu. ");
INSERT INTO ruf_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Tsawaweka hambele hawo, wawaghutsa, “Mwemwe mtenda ichinu chino kwa ingupfu yachi na kwa taghwa lya nani?” ");
INSERT INTO ruf_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Kuya Petiri, aku kamema Ghumuhe Mwenzeluka, kawedika, “Mwemwe iwakulu ne iwabala we iwanu! ");
INSERT INTO ruf_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Mng'atughutsa leloli kwa chinu chila chinoghile chayatendelighwe imunu yula chimbete, na pfahonile, ");
INSERT INTO ruf_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","iwanu wose wa Isiraeli mwobamighwa mmanye ka imunu ayu iyemile hano hambele henu, kamghima ghendo kwe ingupfu ya taghwa lya Yesu Kiristu wa Natsareti, yula imumuwambile mna msalaba na Imulungu iyamtsilihule kulawa mne lifwa. ");
INSERT INTO ruf_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesu iyo ‘Libwe lyamlemile mwemwe iwatsenga ng'anda, sambi liwa libwe kulu lya ukwalambatsa.’ ");
INSERT INTO ruf_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Yeye yaliyeka iyodaha kuwakombola iwanu, kwaapfila mne isi yose kuduhu taghwa lyatwing'ighwe twetwe tukombolighwe nalyo.” ");
INSERT INTO ruf_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Iwabala awo wa libalatsa tsawamanya ka Petiri na Yohane tsawakala iwanu mbughilambughila ing'awasomile bae, apfo wakangawala kuwona pfawalongile pfinoghile, wamanya kuwa wahamwe na Yesu. ");
INSERT INTO ruf_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Lekeni kwaapfila wamwona imunu yahonetsighwe kema hamwe na Petiri na Yohane, ng'awadahile bae kulonga ichinu chochose. ");
INSERT INTO ruf_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Apfo wawalaghitsa walawe kunze kwe libalatsa, kuya wandusa kwilongetsa iwenyegho. ");
INSERT INTO ruf_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Weghutsa, “Tuwatende choni iwanu wano? Chila imunu iyokala Yerusalemu komanya kuwa watenda chihulo chikulu, na twetwe ng'atudaha bae kubela. ");
INSERT INTO ruf_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Lekeni ili imbuli ino ileke kwenela ng'ani kwe iwanu, tuwakanye waleke kulonga keli ne imunu wowose kwa taghwa lya Yesu.” ");
INSERT INTO ruf_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Kuya wawakema keli mng'anda, wawalaghitsa waleke kulonga keli na kulangulitsa kwa taghwa lya Yesu. ");
INSERT INTO ruf_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Lekeni Petiri na Yohane wawedika, “Mlamle mwemwe muwenyegho, chihi ichinoghile kwe Imulungu, kuwahulikitsa mwemwe au kumuhulikitsa Imulungu. ");
INSERT INTO ruf_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kwaapfila ng'atudaha bae kuleka kulonga aghala ghatwonile na ghatuhulike.” ");
INSERT INTO ruf_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Kuya iwabala awo wa libaratsa wawakanya ghendo na kuwalekelela. Ng'awadahile bae kuweng'a atsabu kwaapfila iwanu wose wakala womtunitsa Imulungu kwa achila ichilawile. ");
INSERT INTO ruf_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Imunu ayo iyahonetsighwe tsakakala imbala wa kubita miyaka alubaini. ");
INSERT INTO ruf_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Bahala Petiri na Yohane hawalekilighwe, woya kwa weyawo, wawalongela achila chawalongelighwe ne iwatambika wakulu ne iwabala. ");
INSERT INTO ruf_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nawo hawahulike imbuli ayo wamlomba Imulungu kwa ghumoyo ghumwe. “Imtwatsa, ghweghwe kwa Maumba yulumbile kulanga na iisi, ne ibahali na pfose ipfili mumo! ");
INSERT INTO ruf_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Tsakulonga kwa Ghumuhe Mwenzeluka kubitila kwa imtumighwa wako, aba wetu Daudi, ‘Ebali wanu wali muisi waghudubuka? Mbona iwanu wokwalangula ipfinu ipfilihela mana? ");
INSERT INTO ruf_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Iwandewa we iisi weyandaa, ne iwatawala watingana hamwe, kumpinga Imtwatsa na Kiristu wake.’ ");
INSERT INTO ruf_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Kwaapfila Herodi, Pontiyo Pilato, iwanu we Isiraeli ne iwanu iwali si Wayahudi watingana mne ghumji ghuno kumpinga Yesu, Imtumighwa wako Mwenzeluka, yumsaghule yawe Kiristu. ");
INSERT INTO ruf_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Tsawatingana watenda aghala ghubamile kulawa ghumwande kwa uwetso wako ghalawile. ");
INSERT INTO ruf_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Lelo ghwe Imtwatsa, ulole pfawatutenda tupfuke, utwapfile twetwe iwatumwa wako tudahe kulonga imbuli yako bila kupfuka. ");
INSERT INTO ruf_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Gholosa ghumoko ghwako kuhonetsa iwanu, utende ipfitango na pfihulo kwa taghwa lya Yesu Imtumighwa wako Mwenzeluka.” ");
INSERT INTO ruf_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Hawamalitse kulomba, hanu hala hawatinganile tsahahighisighwa. Wose wamemesighwa Ghumuhe Mwenzeluka, na waghendelela kulonga imbuli ye Imulungu bila kupfuka. ");
INSERT INTO ruf_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Iwanu wose iwatoghole tsawakala na ghumoyo ghumwe na tsawalangula chinu chimwe. Kuduhu imunu wowose iyalongile ka ichinu iyalinacho chake aliyeka, ila wegholela ipfinu pfose pfawakalile napfo. ");
INSERT INTO ruf_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Iwatumighwa waghendelela kulonga kwa ngupfu Imbuli ya ukutsilihuka kwa Yesu, na Imulungu kawabaliki ghendo. ");
INSERT INTO ruf_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Tsahaduhu imunu wowose iyakalile kahela ichinu. Iwanu iwakalile ne imighunda au tsing'anda tsawang'ali wohutsa, na waghala sendi ");
INSERT INTO ruf_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","kwe iwatumighwa, nawo tsawatsighola kwa chila imunu ka pfayabamile. ");
INSERT INTO ruf_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Tsakukala na Mlawi yumwe iyolawila Kupulo, iyakemighwe Yosefu. Iwatumighwa tsawamwing'a taghwa Balinaba, mana yake “Mghuma ghumoyo iwanu” ");
INSERT INTO ruf_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ayu tsakakala na mghunda, kauhutsa, kasola sendi atso katsighala kwe iwatumighwa. ");
INSERT INTO ruf_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Tsakukala ne imunu yumwe iyakemighwe Ananiya na mwehe wake Safila. Nawo pfipfila tsawahutsa mghunda ghwawo. ");
INSERT INTO ruf_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Lekeni Ananiya kabaghula sendi tsingi katsifisa, aku mwehe wake kapfimanya. Sendi itsisighale katsighala kwe iwatumighwa. ");
INSERT INTO ruf_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Petiri kamghutsa, “Ananiya, ebali kumleka Setani yengile mmoyo mwako, na kukutenda umghutsukile Ghumuhe Mwenzeluka, kwa kupfisa sendi tsingi tsupatile kwa kuhutsa mghunda? ");
INSERT INTO ruf_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Pfii mghunda ng'aghukalile ghwako bae hala ng'ana ghuhutsighwe? Na hauutsile sendi atso ambe tsikala tsako, utsitendele chochose choubama. Ebali lelo kulamla kutenda ichinu chino? Ng'umghutsukile imunu bae, ila kumghutsukila Imulungu!” ");
INSERT INTO ruf_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Bahala Ananiya hayahulike apfo, kaghwa hasi, kafa. Iwanu wose iwahulike imbuli ayo wapfuka ng'ani. ");
INSERT INTO ruf_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Kuya iwasongolo watsa, walupfatsa sanda lukuli lwake, wamlapfa kunze, wamtsika. ");
INSERT INTO ruf_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Masaa madatu haghabitile, mwehe wake naye kengila, ng'amanyile bae aghala ighalawile. ");
INSERT INTO ruf_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petiri kamghutsa, “Unongele, atsino tsitso sendi tsose tsampatile ghweghwe na mmale wako kwa kuhutsa mghunda ghwenu?” Naye kedika, “Ona, tsitso.” ");
INSERT INTO ruf_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Petiri kamlongela, “Ebali ghweghwe na mmale wako mlamula kumghetsa Ghumuhe Mwenzeluka ghwe Imtwatsa? Tegheletsa, iwanu iwamtsikile mmale wako, sambi wa hane libani, nawo pfipfila watsokusola ghweghwe!” ");
INSERT INTO ruf_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Bahala ipinga ayo kaghwa mmaghulu mwa Petiri, kafa. Kuya iwasongolo wala wengila, wampfika ma kafa. Apfo wamlapfa naye kunze, wamtsika habehi na mmale wake. ");
INSERT INTO ruf_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Iwanu wose iwamtoghole Yesu ne iwanu wangi iwahulike mbuli atso wapfuka ng'ani. ");
INSERT INTO ruf_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Iwatumighwa tsawatenda pfihulo na pfinu pfingi pfa kukangawatsa mghati mwe iwanu. Na iwanu wose iwatoghole wang'ali wotingana hamwe mne chitala cha mtingano cha Selemani. ");
INSERT INTO ruf_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Kuduhu imunu wowose ing'ayamtoghole Yesu iyaghetsile kwilunga nawo. Hata apfo, iwanu wangi tsawang'ali wowatunya. ");
INSERT INTO ruf_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Iwanu iwamtoghole Imtwatsa wang'ali wakongetseka ng'ani, iwamale ne iwapinga. ");
INSERT INTO ruf_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Mbaka iwanu wang'ali wowaghala iwatamu mne tsinzila na kuwawasisa mlutsatsi na mne ghamatemvu ili Petiri ang'abita sisila lyake liwabitile wangi wawo. ");
INSERT INTO ruf_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Iwanu wengi, iwalawile mne miwambo ya habehi na Yerusalemu watsa, wawaghala iwatamu na iwanu wane ipfinyamkela, nawo wose wahonetsighwa. ");
INSERT INTO ruf_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Kuya Imtambika mkulu na weyaghe, iwanu we chikingili cha Masadukayo wa hanu hala, wawonela chepfu iwatumighwa. ");
INSERT INTO ruf_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Wawaghogha Iwatumighwa, wawoha mwigheletsa. ");
INSERT INTO ruf_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Lekeni nechilo malaika we Imtwatsa kapfughula imibani ya ligheletsa, kawalapfa kunze, kawalongela, ");
INSERT INTO ruf_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Mghende, mkeme mne Ing'anda ye Imulungu, muwalongele iwanu imbuli yose ye ughima uno wa sambi.” ");
INSERT INTO ruf_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Iwatumighwa wahulikitsa, kuya nemitondotondo wengila mne Ing'anda ye Imulungu, wandusa kulangulitsa. Imtambika mkulu na weyaghe hawapfikile, wawakema hamwe iwanu we libaratsa kulu lye iwabala we Isiraeli, kuya wawatuma iwanu mchifungo wawaghalile iwatumighwa wala. ");
INSERT INTO ruf_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","lekeni iwanu wala hawapfikile ako, ng'awawapfikile bae iwatumighwa wa Yesu mwigheletsa. Apfo woya mne libaratsa na kuwalongela imbuli ayo, ");
INSERT INTO ruf_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","walonga, “Tupfika ligheletsa lihindighwa pfipfila, na iwakalitsi wokalitsa imibani. Lekeni hatufughule imibani, ng'atumpfikile imunu wowose mng'anda.” ");
INSERT INTO ruf_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Imkulu we iwokalitsa ing'anda ye Imulungu ne iwatambika wakulu hawahulike imbuli ayo, wakangawala ichinu chachi ichiwapatile iwatumighwa wa Yesu. ");
INSERT INTO ruf_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Kuya imunu yumwe katsa, kawalongela, “Iwanu wala yamuwekile mwigheletsa, sambi wamne Ing'anda ye Imulungu, wowalangulitsa iwanu!” ");
INSERT INTO ruf_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Baho imbala we iwokalitsa ing'anda ye Imulungu hamwe ne iwanu wake waghenda mne ing'anda ye Imulungu, wawasola na kuwaghala mne libaratsa. Lekeni ng'awawaghoghile bae kwe ingupfu, kwaapfila wawapfuka iwanu wang'awatowile na ghamabwe. ");
INSERT INTO ruf_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Kuya wawaghala iwatumighwa wa Yesu na kuwemisa hambele ha libaratsa. Imtambika mkulu kawaghutsa, ");
INSERT INTO ruf_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Ambe tuwaghoma mwemwe ukulangulitsa kwa taghwa lye imunu ayu, lelo mlole achi chamtendile! Mghenetsa ghamalangulitso ghenu Yerusalemu yose na mwobama kulonga twetwe iwo itumtendile yafe!” ");
INSERT INTO ruf_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Petiri na iwatumighwa wala wangi wedika, “Twobamighwa tumhulikitse Imulungu, si iwanu bae! ");
INSERT INTO ruf_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Imulungu we iwabala wetu kamtsilihula Yesu, imumkomile kwa kumuwamba mna msalaba. ");
INSERT INTO ruf_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Imulungu kamwinula mbaka lubali lwake lwe kujilo, kawa Chilongotsi ne Mkombotsi, awatende iwanu we Isiraeli watsileke nzambi ili Imulungu awaleghusile nzambi tsawo. ");
INSERT INTO ruf_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Twetwe twa iwakalangama we ipfinu pfino, na Ghumuhe Mwenzeluka Imulungu iyaweng'ile iwanu wose iwomhulikitsa, naye ka mkalangama wa chinu chino.” ");
INSERT INTO ruf_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Iwanu wose wa libaratsa hawahulike apfo, wona maya ghendo, wabama wawakome iwatumighwa awo wa Yesu. ");
INSERT INTO ruf_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Lekeni Mfarisayo yumwe taghwa lyake Gamalieli, mlangulitsa ghamalaghitso yahulikitsighwe ne iwanu wose, kema hambele he libaratsa, kabama iwatumighwa wala walapfighwe kunze chidogho. ");
INSERT INTO ruf_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Kuya kawalongela iwanu wa libaratsa, “Waisiraeli weyangu mwalangitse ichinu ichimbama kuwatendela iwanu wano! ");
INSERT INTO ruf_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ghumwande chidogho tsakalawila imunu yumwe taghwa lyake Teuda, tsakalonga yeye ka imunu mkulu, ne iwanu ka miya nne tsawamuwinza. Lekeni kakomighwa, ne iwanu wake wose wapwililika na imbuli yake imalila baho. ");
INSERT INTO ruf_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Kuya matsuwa ghala gha kupetighwa iwanu, tsakalawila Yuda wa Galilaya. Ayo naye tsakalongotsa iwanu wengi, lekeni naye pfipfila kakomighwa, ne iwanu wake wose iwamuwinzile wapwililika. ");
INSERT INTO ruf_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Lelo nowalongela mleke kuwatendela ichinu chochose chihile, muwalekele woke! Kwaapfila ka ichinu chino ne isang'ano ino ilawa kwe iwanu, itsomala. ");
INSERT INTO ruf_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Lekeni ka ilawa kwe Imulungu, mwemwe ng'amdaha bae kuwatenda iwanu wano waileke mbuli yawo, pfipfila mtsokuwa mwesonga ne Imulungu.” Iwanu wose we libaratsa watoghola chayalongile Gamalieli. ");
INSERT INTO ruf_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Wawakema iwatumighwa wala mng'anda, walamla watowighwe ipfiboko na wawaghoma waleke ukulangulitsa keli kwa taghwa lya Yesu, kuya wawalekelela woke. ");
INSERT INTO ruf_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Iwatumighwa wala walawa kunze mwa libaratsa wodeng'elela kwaapfila ibamighwa wapate chinyala kwaajili ya taghwa lya Yesu. ");
INSERT INTO ruf_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Tsawaghendelela chila litsuwa ukulangulitsa ne ukupeta Imbuli Inoghile mne ing'anda ye Imulungu na mmakaye mwe iwanu ka Yesu iye Kiristu Mkombola. ");
INSERT INTO ruf_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Hambele, iwanu iwamtoghole Yesu hawang'ali wakongetseka, tsakulawila manung'uniko mghati mwe iwomtoghola Yesu iwolonga Chigiriki, na awala iwolonga Chihebulaniya. Awala iwolonga Chigiriki tsawanung'unika ka iwasaka wawo wang'ali wosemighwa mne ukugholelighwa ipfijo pfa chila litsuwa. ");
INSERT INTO ruf_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Apfo iwatumighwa wala kumi na weli wawakema iwanu wose iwamtoghole Yesu, walonga, “Ng'apfinoghile bae twetwe kuleka kupeta imbuli ye Imulungu ili kutenda isang'ano ya kughola ipfijo. ");
INSERT INTO ruf_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Apfo ndughu tsetu, msaghule iwanu saba mghati mwenu iwomanyika wamema Ghumuhe Mwenzeluka na wane ihekima, na twetwe tutsoweng'a isang'ano ino. ");
INSERT INTO ruf_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Kuya twetwe tutsolomba na kutenda isang'ano ya kupeta Imbuli ye Imulungu.” ");
INSERT INTO ruf_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Imbuli ayo iwadeng'eletsa iwanu wose iwomtoghola Yesu. Wawasaghula Stefani, imunu iyotoghola ghendo na yamemile Ghumuhe Mwenzeluka, Filipi na Porokoro na Nikanori na Timona na Parimena na Nikolayo iyolawila Antiyokiya, iyengile mne dini ya Chiyahudi hao mwanduso. ");
INSERT INTO ruf_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Waweka hambele he iwatumighwa, nawo wawalombela na kuwekila ghamoko. ");
INSERT INTO ruf_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Imbuli ye Imulungu ighendelela kwenela na iwanu iwatoghole tsawongetseka ng'ani ako Yerusalemu, na iwatambika wengi nawo watoghola. ");
INSERT INTO ruf_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stefani imunu iyabalikighwe ng'ani na kwing'ighwa ingupfu ne Imulungu, tsakatenda pfihulo na pfinu pfa kukangawatsa mghati mwe iwanu. ");
INSERT INTO ruf_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Lekeni iwanu wangi we ing'anda ye ukulombela iikemighwe Ing'anda ye iwanu iwalekelighwe, iwalawile Kirene, Alekisandiliya na wangi iwalawile Kilikiya na Asiya, wandusa kwihisanya na Stefani. ");
INSERT INTO ruf_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ghumuhe Mwenzeluka kamwing'a Stefani inzewele, hayang'ali yolonga ng'awadahile bae kumuhuma. ");
INSERT INTO ruf_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Apfo wawasongetsa iwanu wangi walonge, “Tumuhulika Stefani kolonga mbuli tsa kuwaligha Musa ne Imulungu.” ");
INSERT INTO ruf_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Kwa kutenda apfi, wawasongesa iwanu, iwabala ne iwolangulitsa Ghamalaghitso. Apfo wamghogha Stefani wamghala mwibaratsa. ");
INSERT INTO ruf_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Kuya wawaghala iwakalangama we ughutsu iwalongile, “Imunu yuno ng'oleka bae kuhalonga pfihile hanu hano haenzeluke na kughalonga pfihile Ghamalaghitso gha Musa. ");
INSERT INTO ruf_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Kwaapfila tsatumuhulika kolonga ayo Yesu wa Natsareti katsohahinya hanu hano na kuchighelusa ichihendo ichatubokele kwa Musa.” ");
INSERT INTO ruf_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Wose iwakalile mne libaratsa lila wamtsodolela tsinenge Stefani, wawona uhanga wake wakoneka ka uhanga wa malaika. ");
INSERT INTO ruf_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Kuya Imtambika mkulu kamghutsa Stefani, “Pfii mbuli tsino tsolongesa?” ");
INSERT INTO ruf_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Naye Stefani kedika, “Ndughu tsangu ne aba tsangu mnitegheletse! Aba wetu Abrahamu hayang'ali ng'ana yaghende kukala Harani, Imulungu we utunitso tsakamlawila akula Mesopotamiya. ");
INSERT INTO ruf_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Imulungu kamlongela, ‘Ileke isi yako, waleke iwanu wa lukolo lwako, ughende kune isi yanitsokulangusa.’ ");
INSERT INTO ruf_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Baho Abrahamu kaileka isi ya Kalidayo, kaghenda kukala Harani. Aba wake hayafile, Imulungu kamlapfa Harani katsa kukala mne isi ino yamkala sambi. ");
INSERT INTO ruf_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Imulungu ng'amwing'ile bae hata hanu hadoghodogho he isi ino hawe hanu hake, hata apfo tsakamlongela katsomwing'a isi ino iwe yake na iwe ye iwanaghe, hata ka matsuwa agho ng'akalile ne imwana bae. ");
INSERT INTO ruf_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Imulungu kamlongela pfino, ‘Iwana wako watsoghalighwa kune isi iitawalighwa ne iwanu wangi, ako watsotendighwa iwatumwa, na kutendighwa ghehile kwa miyaka maghana mane. ");
INSERT INTO ruf_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Lekeni nene nitsowahigha iwanu we isi ayo iitsowatenda mwemwe iwatumwa. Kuya nitsowalapfa mne isi ayo watse hanu ano wanitamanile.’ ");
INSERT INTO ruf_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Kuya Imulungu kamwing'a Abrahamu chihendo cha kwingitsa ngoma chiwe chitango che laghano lyake. Apfo Abrahamu kamwingitsa ngoma imwanaghe Isaka litsuwa lya nane kulawa hayoneke. Na Isaka pfipfila kamwingitsa ngoma imwanaghe Yakobu. Naye Yakobu kawatendela pfipfo awala iwabala wetu kumi na weli. ");
INSERT INTO ruf_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Kwaapfila awala iwabala wetu tsawamwonela chepfu Yosefu, wamhutsa yawe mtumwa mne isi ya Misiri. Lekeni Imulungu tsakakala hamwe naye, ");
INSERT INTO ruf_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","kamlapfa mne maghayo ghake ghose. Imulungu kamwing'a ihekima, kamtenda amnoghele Farao imndewa wa Misiri, na imndewa ayo kamwika Yosefu yawe imbala we isi na ing'anda yake ya undewa. ");
INSERT INTO ruf_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Kuya kulawila nzala ng'ulu mne isi yose ya Misiri na Kanani, nzala ayo itenda iwanu wadununzike ng'ani. Iwabala wetu ng'awadahile bae kupata ichijo chochose. ");
INSERT INTO ruf_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yakobu hayahulike ka ako Misiri tsakukala ne ichijo, kawatuma iwanaghe, iwabala wetu, waghende ako Misiri kwa ghumwanza ghwa mwanduso. ");
INSERT INTO ruf_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Mne ghumwanza ghwa kabili, Yosefu tsakawalongela ndughu tsake yeye tsakakala nani, na mndewa wa Misiri kawamanya iwandughu wa Yosefu. ");
INSERT INTO ruf_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yosefu tsakatuma iwanu wamkeme Yakobu, aba wake ne iwandughu tsake watse Misiri, iwanu wose tsawakala sabini na watano. ");
INSERT INTO ruf_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Apfo Yakobu tsakaghenda Misiri, yeye ne iwabala wetu wangi tsawafila kuko. ");
INSERT INTO ruf_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Imitufi yawo ighalighwa mbaka Shekemu, itsikighwa mne likabuli lyaghulile Abrahamu kwa sendi kulawa kwa kabila lya Hamori. ");
INSERT INTO ruf_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Ghamatsuwa haghapfikile Imulungu kutimitsa laghano lyamwing'ile Abrahamu, iwanu tsawongetseka na kuwa wengi ng'ani akula Misiri. ");
INSERT INTO ruf_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Kuya imndewa yungi, yang'ammanyile bae Yosefu kanza kutawala ako Misiri. ");
INSERT INTO ruf_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Tsakawatendela iwanu wetu pfihile, na kawonela iwabala wetu kwa kuwalaghitsa wawase kunze iwana wawo pfing'ele wafe. ");
INSERT INTO ruf_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Musa tsakelekighwa mna ghamatsuwa agho. Tsakakala imwana yanoghile ng'ani. Tsakalelighwa mkaye kwa miyetsi midatu, ");
INSERT INTO ruf_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","na hayalapfighwe kunze, neghe Farao kamsola, kamlela ka imwanaghe. ");
INSERT INTO ruf_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Musa tsakalangulitsighwa ipfinu pfose na ihekima yose ya Wamisiri na yang'ali yomanyika kwa kulonga na kwa kusang'ana. ");
INSERT INTO ruf_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Hayakalile ne imiyaka alubaini, kalamla kughenda kuwona ndughu tsake Waisiraeli. ");
INSERT INTO ruf_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ako kamwona ndughu yake yumwe kotendighwa pfihile na Mmisiri, kaghenda kumwapfila na kwa kuliha chisasi, kamkoma Mmisiri yula. ");
INSERT INTO ruf_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Tsakapfikitsa Waisiraeli weyaghe wang'amanyile ka Imulungu tsakakala komtumila yeye kuwakombola, lekeni ng'awamanyile bae. ");
INSERT INTO ruf_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Litsuwa liwinzile kawona Waisiraeli weli wetowa, kabama kuwalamlitsa, kawalongela, ‘Wayangu, mwemwe mwa wandughu, ebali lelo mwobama kwilagha?’ ");
INSERT INTO ruf_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Lekeni imunu yula iyang'ali yomlagha myaghe kamkunughitsa Musa kalonga, ‘Angu nani yakwikile ghweghwe uwe ichilongotsi na mlamutsi wetu? ");
INSERT INTO ruf_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Pfii lelo kwobama ung'ome ka pfumkomile Mmisiri yula ligholo?’ ");
INSERT INTO ruf_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Musa hahulike apfo, katsuma kaghenda kukala mne isi ya Midiyani. Ako tsakapata iwana weli. ");
INSERT INTO ruf_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Haibitile imiyaka alubaini, malaika we Imtwatsa kamlawila Musa mne chibagho iching'ali chakwaka ghumoto akula kunyika, habehi na chidunda cha Sinai. ");
INSERT INTO ruf_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Musa tsakakangawala ukona ichinu acho, kasoghela habehi alolese ghoya, lekeni kahulika litsi lye Imtwatsa. ");
INSERT INTO ruf_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Nene na Imulungu wa aba tsako, Nene na Imulungu we Abrahamu, Isaka na Yakobu.’ Musa kadedema kwa ukupfuka, kuya ng'aghendelele kulola keli. ");
INSERT INTO ruf_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Imtwatsa kamlongela, ‘Tsula imikwabatsa yako kwaapfila hanu ano hawimile haenzeluka. ");
INSERT INTO ruf_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nighona ghendo ghehile ghawotendighwa iwanu wangu akula Misiri. Nihulika chililo chawo, na nene nitsa kuwakombola. Lelo nitsokutuma uye Misiri.’ ");
INSERT INTO ruf_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Ayuno Musa yuyula yawamlemile iwanu we Isiraeli, hawamlongele, ‘Angu nani yakwikile ghweghwe uwe ichilongotsi na mlamutsi wetu?’ Kubitila malaika yuyula iyamlawile Musa mne chibagho iching'ali chakwaka ghumoto, Imulungu kamtuma Musa yuyo yawe ichilongotsi na mkombotsi. ");
INSERT INTO ruf_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Yeye iyawalongotse iwanu wala walawe Misiri kwa kutenda pfihulo na pfinu pfa kukangawatsa mne isi ya Misiri, mne ibahali ya Shamu, na kwa miyaka alubaini kunyika. ");
INSERT INTO ruf_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Musa yuyo iyawalongele iwanu we Isiraeli, ‘Imulungu katsowaghalilani nabii wake ka nene kulawa mghati mwe iwandughu tsenu.’ ");
INSERT INTO ruf_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Yeye iyo iyakalile ne mtingano akula kunyika, na ayula malaika iyalongile naye akula kune chidunda cha Sinai, kuya hamwe ne iwabala tsetu, yuyo iyabokele mbuli tse ughima yatwing'e twetwe. ");
INSERT INTO ruf_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Lekeni iwabala wetu tsawalema kumuhulikitsa, wamkunughitsila kutali, mmoyo mwawo wabama kuya Misiri. ");
INSERT INTO ruf_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Wamlongela Aruni, ‘Ututendele milungu iidaha kutulongosa mnzila, kwaapfila ng'atumanyile bae ghayampatile Musa iyatulongotse kulawa Misiri.’ ");
INSERT INTO ruf_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Baho watenda ichinyagho che imwana wa ng'ombe, wachilapfila nambiko na kuchitendela ichihungo ichinu chawatendile kwa ghamoko ghawo wenyegho. ");
INSERT INTO ruf_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Lekeni Imulungu kahunduka koka mghati mwawo, kawaleka watsitamanile tsinondo tsa kulanga ka pfayandikighwe mne ichitabu che manabii we Imulungu. ‘Mwemwe iwanu we Isiraeli! Si nene bae iyamnichinjile iwanyama na kunitambikila kwa imiyaka alubaini akula kunyika? ");
INSERT INTO ruf_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Mwemwe tsa mchighala ichibumbulika cha mlungu Moleki, na ichinyagho che inondo ye mlungu wenu Refani, tsapfikala pfinyagho pfamtendile ili mpfitamanile. Apfo nitsowaghala kune utumwa kutali kubita Babeli.’, ");
INSERT INTO ruf_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Hakula kunyika iwabala wetu wakala na ichibumbulika chila che ukalangama. Tsachitsengighwa ka Imulungu pfayamlongele Musa achitsenge, chighale na achila chayalangusighwe Musa ");
INSERT INTO ruf_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Kuya iwabala wetu webokela chibumbulika acho, iwenyegho kwe iwenyegho mbaka ichipindi cha Yoshua, hawaisolile isi ila kulawa kune isi tsila Imulungu iyatsiwingile hambele hawo. Chikala baho mbaka ghamatsuwa gha Daudi. ");
INSERT INTO ruf_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Daudi tsakanoghelighwa ne Imulungu, naye Daudi kamlomba Imulungu amleke amtsengele ing'anda yeye Imulungu wa Yakobu. ");
INSERT INTO ruf_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Lekeni iyamtsengele ing'anda Imulungu tsakakala Selemani. ");
INSERT INTO ruf_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Lekeni Imulungu Yali Mkulu ng'okala bae mne tsing'anda itsitsengighwe ne iwanu, ka nabii wake pfayalongile, ");
INSERT INTO ruf_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Imtwatsa kalonga, Kulanga kwa chighoda changu che undewa, na iisi iyo hanu hakwikila ghamaghulu ghangu. Ing'anda yachi imdaha kunitsengela? Na hanu he ukubwihila nene halikwani? ");
INSERT INTO ruf_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Si nene imwenyegho bae nitendile ghano ghose?’ ” ");
INSERT INTO ruf_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Stefani tsakaghendelela kulonga, “Mwemwe mwa wasughu! Maghutwi ne imimoyo yenu pfighala ne iwanu ing'awammanyile Imulungu, mwemwe ka iwabala tsenu. Ghamatsuwa ghose mwotsilema mbuli tse Ghumuhe Mwenzeluka. ");
INSERT INTO ruf_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Angu kuna nabii wowose we Imulungu iwabala tsenu yang'awamdununze bae? Tsawawakoma awala Mulungu yawatumile umwande walonge ukutsa kwa yula yane haki, yamumuhunduke na kumkoma. ");
INSERT INTO ruf_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Mwemwe iwo imbokele laghitso lye Imulungu imghalilighwe ne wamalaika lekeni ng'amtenda ka pfalilonga.” ");
INSERT INTO ruf_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Iwabala wala wa libaratsa hawahulike agho, ghawahoma mmoyo, waghudubuka wadafuna matsino kwa kona maya. ");
INSERT INTO ruf_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Lekeni Stefani aku kamema Ghumuhe Mwenzeluka, kalola kulanga kawona utunitso we Imulungu na Yesu kema lubali lwe kujilo lwe Imulungu. ");
INSERT INTO ruf_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Kalonga, “Loleni! Nakona kulanga kupfughuka, ne imwana we Imunu kema lubali lwa kujilo lwe Imulungu!” ");
INSERT INTO ruf_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Baho, iwanu wose iwakalile mne libaratsa lila waghadiwa maghutwi ghawo na kukemelela. Kuya wose wamghendela hamwe, ");
INSERT INTO ruf_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","wamlapfa kunze mwe ghumji wandusa kumtowa na ghamabwe. Iwakalangama tsaweka ghamaghwanda ghawo mne ghamaghulu ghe imsongolo yumwe iyakemighwe Sauli aghalolese. ");
INSERT INTO ruf_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Hawang'ali womtowa na ghamabwe, Stefani kalomba, “Imtwatsa Yesu, ubokele muhe wangu.” ");
INSERT INTO ruf_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Tsakatowa ghamaghoti, kakemelela, “Imtwatsa! Uwaleghusile nzambi ino.” Hayamalitse kulonga apfo, kafa. ");
INSERT INTO ruf_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Naye Sauli tsakona pfinogha kukomighwa kwa Stefani. Litsuwa lilila iwanu iwomtoghola Kiristu wa Yerusalemu wandusa kudununzika ng'ani, iwanu iwamtoghole Yesu wose wapwililikila isi ya Yudeya na Samariya, ila iwatumighwa waliheka iwasighale. ");
INSERT INTO ruf_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Iwanu iwomnoghela Imulungu wamtsika Stefani, kuya wamlilila ng'ani. ");
INSERT INTO ruf_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Lekeni Sauli kandusa kuwadununza iwanu iwamtoghole Yesu. Kengila chila ing'anda, kawalapfa kunze iwanu iwamtoghole Yesu iwamale ne iwapinga, kaweka mwigheletsa. ");
INSERT INTO ruf_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Awala iwapwililike, tsawapeta Imbuli Inoghile chila hanu hawaghendile. ");
INSERT INTO ruf_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipi kaghenda mne isi ya Samariya, kawapetela iwanu imbuli ya Kiristu. ");
INSERT INTO ruf_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Iwanu hawahulike na kwona aghala ghakukangawatsa ghayatendile Filipi, wose wahulikitsa ghoya chayang'ali yochilonga. ");
INSERT INTO ruf_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ipfinyamkela wawalawa iwanu wengi kwa kukemelela, na iwanu wengi iwaholole na ipfimbete tsawahona. ");
INSERT INTO ruf_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Apfo tsa kukala na ndeng'elelo ng'ulu mne isi ayo. ");
INSERT INTO ruf_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Kuya tsahana imunu yumwe yakemighwe Simoni, iyatendile uhawi mne isi ayo, na kuwakangawatsa Wasamariya. Tsakalonga yeye ka imunu mkulu. ");
INSERT INTO ruf_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Na iwanu wose, iwabala na iwadodo wang'ali womuhulikitsa ghendo, walonga, “Imunu yuno ka ingupfu ye Imulungu iimanyika ‘Ingupfu Ng'ulu’.” ");
INSERT INTO ruf_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Wamuhulikitsa kwaapfila ang'ali yowakangawatsa kwa uhawi wake kwa matsuwa mengi. ");
INSERT INTO ruf_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Lekeni hawatoghole imbuli inoghile ya undewa we Imulungu na imbuli ya Yesu Kiristu iyawapetele Filipi, wose wabatitsighwa, iwamale ne iwapinga. ");
INSERT INTO ruf_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Hata Simoni imwenyegho tsakatoghola na ukubatitsighwa na tsayang'ali yomuwinza Filipi chila hanu na kukangawala kwa pfihulo ipfing'ali pfitendeka. ");
INSERT INTO ruf_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Iwatumighwa wala iwakalile Yerusalemu hawahulike ka iwanu wa Samariya waitoghola imbuli ye Imulungu, wawatuma ako Petiri na Yohane. ");
INSERT INTO ruf_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Hawapfikile wawalombela iwanu awo wambokele Ghumuhe Mwenzeluka, ");
INSERT INTO ruf_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","kwaapfila Ghumuhe Mwenzeluka tsakakala ng'ana yamhulumkile imunu wowose mghati mwawo, ila tsawabatitsighwa kwa taghwa lye Imtwatsa Yesu liliyeka. ");
INSERT INTO ruf_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Kuya Petiri na Yohane wawekela ghamoko iwanu awo, nawo wambokela Ghumuhe Mwenzeluka. ");
INSERT INTO ruf_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simoni honile iwanu weng'ighwa Ghumuhe Mwenzeluka kwa kwikighwa ghamoko ne iwatumighwa, kabama yaweng'e sendi Petiri na Yohane, ");
INSERT INTO ruf_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","kawalongela, “Mngaye na nene uwetso awo ili imunu wowose yanimwikila ghamoko yambokele Ghumuhe Mwenzeluka.” ");
INSERT INTO ruf_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Lekeni Petiri kamwidika, “Waghile kutali na sendi tsako kwaapfila kwopfikitsa kodaha kughula nzawadi ye Imulungu kwa sendi! ");
INSERT INTO ruf_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Kwahela chinu chochose mna ing'onde hino, kwaapfila ghumoyo ghwako ng'aghunoghile bae kwe Imulungu. ");
INSERT INTO ruf_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Lelo, utoghole kuleka ghehile, umlombe Imtwatsa, naye kodaha kukuleghusila nzambi ya ukwalangula ghano mmoyo mwako. ");
INSERT INTO ruf_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kwaapfila nokwona kuna usungu sideke na kwohighwa na nzambi.” ");
INSERT INTO ruf_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Kuya Simoni kawalongela Petiri na Yohane, “Mnilombele kwe Imtwatsa aghano ghamlongile ghaleke kundawila.” ");
INSERT INTO ruf_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Hawamalitse kuwalongela pfawommanya Yesu na kupeta imbuli ye Imtwatsa, Petiri na Yohane woya Yerusalemu. Hawang'ali wakuya, tsawapeta Imbuli Inoghile mne tsikaye tsa Samariya. ");
INSERT INTO ruf_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Malaika we Imtwatsa kamlongela Filipi, “Ughende lubali lwa hasi kune inzila ye kunyika iihulumka kulawa Yerusalemu kughenda Gatsa” ");
INSERT INTO ruf_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filipi kandusa ukuka na mnzila ketingana ne imunu yumwe mwika tsimali mne undewa wa Kandake, imtawala pinga we isi ya Esiopiya. Imunu ayo tsakaghenda Yerusalemu kutamanila. ");
INSERT INTO ruf_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Hayang'ali yakuya ukaye, tsakakala mne mtuka wake kosoma ichitabu cha Isaya, nabii we Imulungu. ");
INSERT INTO ruf_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ghumuhe Mwenzeluka kamlongela Filipi, “Ghenda habehi ne mtuka ghula, wilongotse nawo.” ");
INSERT INTO ruf_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Kuya Filipi katsumila kune mtuka ula, kamuhulika imunu ayo kosoma ichitabu che nabii Isaya. Baho Filipi kamghutsa, “Pfii koghamanya agho ghausoma?” ");
INSERT INTO ruf_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Naye kalonga, “Angu nidahatse kughamanya bila imunu wa kunilongotsa?” Kamlomba Filipi adine mne mtuka ghula, kakala naye. ");
INSERT INTO ruf_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Imunu ayo tsayang'ali yosoma hanu hano he Ghamaandiko Mahenzeluka, “Tsakakala ka ing'olo iyoghalighwa kuchinjighwa, ka imwana we ing'olo pfayonyamala hayoghanighwa imighala, naye ng'alongile imbuli. ");
INSERT INTO ruf_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Kaghelighwa chinyala na ukwonelighwa. Haduhu imunu yodaha kulonga mbuli tsa ghumweleko ghwake. Kwaapfila ughima wake uleghusighwa mne isi yose.” ");
INSERT INTO ruf_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Imunu ayo wa Esiopiya kamlongela Filipi, “Unongele lelo, nabii we Imulungu yolonga mbuli tsa nani? Tsake imwenyegho au tse imunu yungi?” ");
INSERT INTO ruf_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Kuya Filipi kanzila hanu aho ha Ghamaandiko Mahenzeluka, kamlongela Imbuli Inoghile ya Yesu. ");
INSERT INTO ruf_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Hawang'ali woghendelela na ghumwanza, tsawapfika hanu hane ghamatsi, imunu yula kalonga, “Hanu hano hana ghamatsi, lelo chinu chachi ichingoma ndeke kubatitsighwa?” ");
INSERT INTO ruf_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipi kalonga, “Ung'atoghola kwa ghumoyo ghwako ghose kodaha kubatitsighwa.” Naye kalonga, “Notoghola Yesu Kiristu iyo Imwana we Imulungu.” ");
INSERT INTO ruf_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Imunu yula kalaghitsa mtuka ghula ghwime. Kuya wose weli wengila mne ghamatsi, naye Filipi kambatitsa. ");
INSERT INTO ruf_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Hawalawile mne ghamatsi, bahala Ghumuhe ghwe Imtwatsa kamsola Filipi, imunu yula wa Esiopiya ng'amwonile keli bae, lekeni kaghendelela na ghumwanza ghwake aku kodeng'elela. ");
INSERT INTO ruf_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Hambele Filipi tsakoneka Asoto, na hayang'ali yobita, kapeta Imbuli Inoghile mne tsiisi tsose mbaka kapfika Kaisariya. ");
INSERT INTO ruf_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Matsuwa ghagho Sauli tsakaghendelela kuwatenda iwanu iwamtoghole Imtwatsa wapfuke ghendo kwa kulonga katsowakoma. Kaghenda kwa mtambika mkulu, ");
INSERT INTO ruf_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","kalomba yeng'ighwe tsibaluwa itsimwapfila kumanyika mne tsing'anda tse ukulombela itsili Damasko, ili ang'awapfika ako awaghoghe iwamale ne iwapinga iwoiwinza Imbuli ye Imtwatsa na kuya nawo Yerusalemu. ");
INSERT INTO ruf_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Lekeni hayang'ali mnzila habehi na kupfika Damasko, bahala lumwesa kulawa kulanga lummulika kosekose. ");
INSERT INTO ruf_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Kaghwa, kahulika litsi lyomlongela, “Sauli, Sauli! Ebali kwondesa?” ");
INSERT INTO ruf_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sauli kaghutsa, “Imtwatsa, ghweghwe uli nani?” Naye kamwidika, “Nene na Yesu, yumdununza! ");
INSERT INTO ruf_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Lelo winuke, wingile mne ghumji, ako kuna imunu katsokulongela chokutenda.” ");
INSERT INTO ruf_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Iwanu iwelongotse na Sauli mne ghumwanza wema baho aku wahela chakulonga, wahulika litsi ila ng'awamwonile munu bae. ");
INSERT INTO ruf_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sauli kenuka, hayafumbule tsinenge, ng'adahile bae ukwona chochose. Apfo wamlongotsa kwa kumkinda ghumoko mbaka Damasko. ");
INSERT INTO ruf_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Kwa matsuwa madatu Sauli ng'adahile bae ukona, na ng'ajile wala ng'anwile ichinu chochose. ");
INSERT INTO ruf_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ako Damasko tsahana imunu yumwe iyamuwinzile Yesu, taghwa lyake Ananiya. Imtwatsa tsakamlongela mne ghamaono, “Ananiya!” Ananiya kedika, “Ona Mtwatsa.” ");
INSERT INTO ruf_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Imtwatsa kamlongela, “Winuke, ughende kune inzila iikimeghwa inzila iigholoke, ukambame imunu yumwe wa Taso iyokemighwa Sauli, kamne ing'anda ya Yuda, sambi kolomba, ");
INSERT INTO ruf_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","naye mne ghamaono kamwona imunu iyokemighwa Ananiya kakwingila mng'anda na kumwikila ghamoko ili yadahe ukwona keli.” ");
INSERT INTO ruf_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Lekeni Ananiya kedika, “Imtwatsa nihulika mbuli tse imunu ayu kulawa kwe iwanu wengi. Nihulika mengi ghehile ghayawatendele iwanu wako ako Yerusalemu. ");
INSERT INTO ruf_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Naye katsa hano ne uwetso kulawa kwe iwatambika wakulu awaghoghe wose iwokutamanila ghweghwe.” ");
INSERT INTO ruf_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Lekeni Imtwatsa kamlongela, “Ghenda, kwaapfila nimsaghula imunu yuno yanisang'anile, yapete taghwa lyangu kwa iwanu iwali si Wayahudi na kwe iwandewa wawo na kwe iwanu we Isiraeli. ");
INSERT INTO ruf_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nene imwenyegho nitsomlangusa mengi ighatsombama yadununzike kwaajili ya taghwa lyangu.” ");
INSERT INTO ruf_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Apfo Ananiya kaghenda, kengila mng'anda amwo. Kuya kamwikila ghamoko Sauli, kalonga, “Ndughu yangu Sauli, Imtwatsa Yesu iyakulawile mnzila haung'ali kwakutsa hano, kanituma ili udahe ukwona keli na umemesighwe Ghumuhe Mwenzeluka.” ");
INSERT INTO ruf_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Bahala ipfinu ka maghamba pfilaghala kulawa mnenge mwake, naye kadaha ukwona keli. Kuya kenuka, kabatitsighwa. ");
INSERT INTO ruf_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Na hayamalitse ukuja ngupfu tsake tsimuyila. Sauli tsakakala ghamatsuwa chidogho ne iwanu iwamtoghole Yesu ako Damasko. ");
INSERT INTO ruf_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Baho kandusa kupeta mne tsing'anda tse ukulombela ka Yesu ka Imwana we Imulungu. ");
INSERT INTO ruf_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Iwanu wose iwamuhulike wakangawala, walonga, “Imunu yuno si yuyula bae iyawakomile iwanu iwamtamanile Yesu akula Yerusalemu? Ambe tsakatsa hano yawaghoghe iwanu awo kuya yawaghale kwe iwatambika wakulu!” ");
INSERT INTO ruf_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Lekeni Sauli kaghendelela kupata ingupfu na kuwakangawatsa Wayahudi iwokala Damasko kwa kulangusa ka Yesu iyo Kiristu. ");
INSERT INTO ruf_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Haghabitile ghamatsuwa mengi, Wayahudi tsawelaghana wamkome Sauli. ");
INSERT INTO ruf_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Lekeni Sauli tsakalongelighwa imbuli ayo. Chilo na misi tsawamlolesa hane imibani ya kwingilila mkaye ili wamkome. ");
INSERT INTO ruf_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Lekeni nechilo wanang'ina wake wamsola, wamuhulumsa mliseghe kubitila mne litundu ilikalile mne libanda lye ghumji. ");
INSERT INTO ruf_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sauli hapfikile Yerusalemu, tsakabama yelunge ne iwanang'ina, lekeni wawo wang'ali wompfuka, kwaapfila ng'awatoghole bae ka naye tsakakala imwanang'ina. ");
INSERT INTO ruf_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Lekeni Balinaba kamsola Sauli kamghala kwe iwatumighwa. Kawalongela Sauli pfayamwonile Imtwatsa mne ghumwanza ghwake na Imtwatsa tsakalonga naye, na pfayapetile taghwa lya Yesu bila kupfuka akula Damasko. ");
INSERT INTO ruf_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Apfo Sauli kakala nawo na ukwanga Yerusalemu yose aku kopeta imbuli ye Imtwatsa bila kupfuka. ");
INSERT INTO ruf_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Kalonga nawo na kwighutsa na Wayahudi iwolonga Chigiriki, lekeni nawo wabama kumkoma. ");
INSERT INTO ruf_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ndughu hawamanyile imbuli ayo wamsola Sauli mbaka Kaisariya, wamghala Taso. ");
INSERT INTO ruf_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Apfo iwanu iwomtoghola Kiristu tsawakala tseghamba mne isi ya Yudeya na Galilaya na Samariya, waghumighwa ghumoyo na Ghumuhe Mwenzeluka na wongetseka na kukala kwa kumpfuka Imtwatsa. ");
INSERT INTO ruf_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petiri hayang'ali yobita chila hanu, kawangila iwanu we Imulungu iwokala Luda. ");
INSERT INTO ruf_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ako kampfika imunu yumwe iyakemighwe Eneya, yawasile mlusatsi kwa miyaka kumi na minane kwa utamu wa kuholola. ");
INSERT INTO ruf_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petiri kamlongela, “Eneya, Yesu Kiristu kokuhonetsa. Winuke, utandike lusatsi lwako.” Bahala Eneya kenuka. ");
INSERT INTO ruf_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Iwanu wose iwokala Luda na Sharoni wamwona Eneya, nawo wamuyila Imtwatsa. ");
INSERT INTO ruf_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ako Yopa tsakukala ne imwanang'ina yumwe pinga iyakemighwe Tabita kwa Chigiriki Dorika, mana yake mbawala. Ipinga ayo tsayang'ali yotenda ghanoghile matsuwa ghose na kuwapfila iwahingwa. ");
INSERT INTO ruf_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Mna matsuwa agho kaghula, kafa, waghwopfugha lukuli wake na waghwika mchiheleto cha kuchanya. ");
INSERT INTO ruf_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Luda si hatali ng'ani na Yopa, apfo iwanang'ina hawahulike Petiri ka ako, wawatuma iwanu weli kuna yeye, na wamlomba, “Utse kuna twetwe sambi baha.” ");
INSERT INTO ruf_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Petiri kaghenda nawo, na hayapfikile, wamghala mchiheleto cha uchanya. Ipfitsuka wose wamtsunguluka Petiri aku wolila na kumlangusa maghwanda na maghwanda ghayatendile Dorika hayang'ali mghima. ");
INSERT INTO ruf_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petiri kawalapfa wose kunze, kuya katowa ghamaghoti, kalomba. Kamhundukila ipinga yula iyafile, kalonga, “Tabita, winuke.” Naye kafumbula tsinenge na hayamwonile Petiri, kenuka kakala. ");
INSERT INTO ruf_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Petiri kamkinda ghumoko kamwapfila ukwimwinula. Kuya kawakema iwanu we Imulungu na wala ipfitsuka, kamleka mghamoko mwawo ka mghima. ");
INSERT INTO ruf_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Imbuli ayo imanyika mne isi yose ya Yopa, na iwanu wengi wamtoghola Imtwatsa. ");
INSERT INTO ruf_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petiri kakala ako Yopa matsuwa mengi, tsakakala ne imunu iyotenda tsingotsi yakemighwe Simoni. ");
INSERT INTO ruf_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ako Kaisariya tsakukala ne imunu yumwe taghwa lyake Korineli, chilongotsi wa chikosi chimwe cha asikali kumi ichikemighwe “Chikosi cha Italiya.” ");
INSERT INTO ruf_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Yeye ne iwanu wa ukaye yake tsawang'ali wompfuka Imulungu. Tsaang'ali yowapfila wahingwa na komlomba Imulungu matsuwa ghose. ");
INSERT INTO ruf_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Litsuwa limwe saa tisa nemisi kona ghamaono mwatsimwatsi, malaika we Imulungu kamtsila, kalonga, “Korineli!” ");
INSERT INTO ruf_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Korineli kamtsodolela tsinenge kwa kupfuka, kaghutsa, “Kuna choni Imtwatsa?” Malaika ayo kedika, “Imulungu kahulika ukulomba kwako na sadaka tsako kwa iwahingwa, kuya ng'atsotsisemwa bae. ");
INSERT INTO ruf_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Sambi watume iwanu ako Yopa wakamkeme imunu iyokemighwa Simoni, taghwa lyake lingi Petiri. ");
INSERT INTO ruf_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Kokala mne ing'anda ya Simoni mtenda tsingotsi, ing'anda yake yahabehi ne ibahali.” ");
INSERT INTO ruf_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Malaika yula iyalongile naye hayokile, Korineli kawakema iwatumwa wake weli hamwe na asikali wake yumwe iyompfuka Imulungu. ");
INSERT INTO ruf_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Kawalongela ghose ighalawile, kuya kawatuma Yopa. ");
INSERT INTO ruf_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Litsuwa liwinzile, saa sita nemisi iwanu wala hawang'ali wamne ghumwanza, habehi na kupfika Yopa, Petiri kadina mchiswili ili yalombe. ");
INSERT INTO ruf_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Inzala imtama, kabama ichijo yaje, na ichijo haching'ali chikwambikighwa, kona ghamaono. ");
INSERT INTO ruf_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Kona kulanga kughubulighwa ne ichinu ka gholole kulu lyohulumsighwa muisi kwa membe tsake nne. ");
INSERT INTO ruf_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Mghati mwake mna wanyama wose iwali na ghamaghulu mane, na iwotambala hasi na wapfideghe wa kulanga. ");
INSERT INTO ruf_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Kuya kahulika litsi lyomlongela, “Petiri, winuke uchinje uje!” ");
INSERT INTO ruf_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Petiri kalonga, “Mbe, Imtwatsa, sina ndiye bae chinu chochose ichighomighwe au ichihile.” ");
INSERT INTO ruf_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Litsi limlongela keli, “Uleke kupfikema pfiha ipfinu ipfideghetighwe ne Imulungu.” ");
INSERT INTO ruf_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Imbuli ayo ilawila mala ndatu, kuya gholole liyutsighwa kulanga. ");
INSERT INTO ruf_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Petiri hayang'ali yokangawala ghamaono ghala gholonga choni, iwanu wala iwatumighwe na Korineli wapfika kune ing'anda ya Simoni, wema mlibani. ");
INSERT INTO ruf_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Wakemelela, waghutsa ka Simoni yokemighwa Petiri kokala hamo. ");
INSERT INTO ruf_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Simoni Petiri hayang'ali yokangawala ghamaono agho, baho Ghumuhe ghwe Imulungu kamlongela, “Simoni, hano hana iwanu wadatu wokubama ghweghwe. ");
INSERT INTO ruf_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Apfo winuke uhulumke ughende nawo, uleke kupfuka, kwaapfila yaniwatumile nene.” ");
INSERT INTO ruf_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Petiri kahulumka hasi, kawalongela iwanu awo, “Nene iyo yamumbama. Mtsilile choni hano?” ");
INSERT INTO ruf_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Wamwidika, “Twolawa kwa Korineli, imkulu we asikali, imunu yanoghile, mpfuka Imulungu na youlikitsighwa na Wayahudi wose. Malaika mwenzeluka kamlongela yakukeme ghweghwe ukaye yake ili yahulike chochose chautsomlongela.” ");
INSERT INTO ruf_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Kuya Petiri kawalongela iwanu awo wengile mng'anda, wawe wahenza wake. Litsuwa lya kabili Petiri kandusa ukuka nawo, ne iwanu wangi wa Yopa iwamtoghole Yesu waghenda naye. ");
INSERT INTO ruf_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Litsuwa liwinzile Petiri kapfika Kaisariya. Korineli tsaang'ali yowabeta hamwe na iwandughu tsake na sale tsake iyawakemile. ");
INSERT INTO ruf_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Petiri hayang'ali yakwingila mng'anda, Korineli kaghenda kumbokela, kamtowela ghamaghoti, kenama mbaka hasi ghendo. ");
INSERT INTO ruf_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Lekeni Petiri kamwinula, kalonga, “Winuke, nene imwenyegho na imunu ka ghweghwe.” ");
INSERT INTO ruf_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Na hang'ali yolonga naye, Petiri kengila mng'anda, kawapfika iwanu wengi wetingana. ");
INSERT INTO ruf_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Kawalongela, “Mwemwe mwomanya ka Myahudi kaghomighwa na malaghitso ghe dini yake kukala ne imunu wa isi ingi, au kumwangila. Lekeni Imulungu kanilangusa ndeke kumwona imunu wowose ng'adeghete au keha. ");
INSERT INTO ruf_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Apfo hamnikemile, silemile bae kutsa. Lelo nowaghutsa, mnikemile choni?” ");
INSERT INTO ruf_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Korineli kedika, “Matsuwa madatu ghabitile saa ka ino, tsanikala mng'anda mwangu nolomba. Bahala imunu yane maghwanda matselu ng'ani tsakema hambele hangu, ");
INSERT INTO ruf_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","kalonga, ‘Korineli, Imulungu kabokela malombi ghako na ng'aghasemwile aghala ghauweng'ile iwahingwa. ");
INSERT INTO ruf_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Lelo, watume iwanu waghende Yopa kumkema Simoni yokemighwa Petiri, kokala mne ing'anda ya Simoni mtenda tsingotsi, iyokala habehi ne ibahali.’ ");
INSERT INTO ruf_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Apfo bahala niwatuma iwanu kuna ghweghwe, naghwe kutenda ghoya ukutsa. Sambi twetwe twa hambele he Imulungu, kuhulikitsa chochose Imulungu chayakulaghitse kutulongela.” ");
INSERT INTO ruf_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Kuya Petiri kandusa ukulonga, “Lelo nomanya ka Imulungu ng'obaghula bae, ");
INSERT INTO ruf_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ila kowatoghola iwanu iwompfuka na kutenda ghanoghile kulawa chila isi. ");
INSERT INTO ruf_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Mwemwe mwomanya imbuli yaitumile Imulungu kuna iwanu wa Isiraeli, kalonga imbuli inoghile iitenda iwanu wakale tseghamba kubitila Yesu Kiristu, Imtwatsa wa wose. ");
INSERT INTO ruf_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Mwemwe mwomanya ichilawile mne isi yose ya Yudeya, kwandusila Galilaya haumalile ubatitso yaupetile Yohane, ");
INSERT INTO ruf_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Imulungu pfayamsaghule Yesu wa Natsareti kwa kumwing'a Ghumuhe Mwenzeluka ne ingupfu, na pfayaghendile chila hanu aku kotenda ghanoghile na kuhonetsa iwanu wose iwonelighwe na Setani, kwaapfila Imulungu tsakakala naye. ");
INSERT INTO ruf_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Twetwe twa iwakalangama we ipfinu pfose pfatendile mne isi ya Wayahudi na Yerusalemu. Tsawamkoma kwa kumuwamba mna msalaba. ");
INSERT INTO ruf_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Lekeni Imulungu kamtsilihula mne litsuwa lya kadatu, kuya kamtenda yoneke ne iwanu. ");
INSERT INTO ruf_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ng'oneke ne iwanu wose, ila na iwakalangama iwasaghulighwe ne Imulungu, twetwe iyatujile na ukunwa naye hayatsilihuke. ");
INSERT INTO ruf_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Katulaghitsa tuwapetele iwanu na kuwalongela ka Yesu iyo iyasaghulighwe ne Imulungu yawe imlamutsi we iwaghima na iwafile. ");
INSERT INTO ruf_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Wanabii wose we Imulungu tsawalonga mbuli tsake ka chila imunu iyomtoghola katsoleghusighwa nzambi tsake kwa taghwa lyake.” ");
INSERT INTO ruf_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Petiri hayang'ali yolonga mbuli atso, Ghumuhe Mwenzeluka kawahulumkila wose iwang'ali wotegheletsa mbuli atso. ");
INSERT INTO ruf_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Awala Wayahudi iwatoghole iwatsile na Petiri wakangawala kwaapfila nzawadi ya Ghumuhe Mwenzeluka pfipfila ighumighwa kwe iwanu iwali si Wayahudi bae. ");
INSERT INTO ruf_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Kwaapfila wawahulika wolonga kwa lugha ingi, na kumtunya Imulungu. Kuya Petiri kalonga, ");
INSERT INTO ruf_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Iwanu wano wambokela Ghumuhe Mwenzeluka ka twetwe pfatumbokele. Angu nani lelo iyodaha kuwaghoma iwanu wano waleke kubatitsighwa kwa ghamatsi?” ");
INSERT INTO ruf_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Apfo kalaghitsa wabatitsighwe kwa taghwa lya Yesu Kiristu. Kuya wamlomba Petiri akale nawo kwa ghamatsuwa chidogho. ");
INSERT INTO ruf_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Kuya iwatumighwa ne iwamtoghole Yesu akula Yudeya wahulika ka iwanu iwali si Wayahudi nawo waibokela imbuli ye Imulungu. ");
INSERT INTO ruf_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Apfo Petiri hayoile Yerusalemu, Wayahudi iwamtoghole Yesu wamlonga, ");
INSERT INTO ruf_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","walonga, “Ghweghwe kughenda mne tsing'anda tse iwanu ing'awengile ngoma bae na ukuja nawo.” ");
INSERT INTO ruf_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Petiri kandusa kuwalongela lughalugha chila ichinu pfachilawile. ");
INSERT INTO ruf_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Tsanikala mne isi ya Yopa nolomba, baho mbona ghamaono, mbona ichinu ka gholole kulu lyohulumsighwa hasi kulawa kulanga kwa membe tsake nne, kuya litsa bahala hanikalile. ");
INSERT INTO ruf_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nilola mghati, mbona iwanyama wane ghamaghulu mane iwali muisi, iwanyama wa kubagho, iwotambala, ne iwapfideghe wa kulanga. ");
INSERT INTO ruf_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Kuya nihulika litsi lyonilongela, ‘Petiri, winuke uchinje uje.’ ");
INSERT INTO ruf_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Nyidika, ‘Bae, Imtwatsa! Kuduhu ichinu chochose chihile au ichighomighwe ichingile mumlomo mwangu.’ ");
INSERT INTO ruf_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Litsi lilonga keli kulawa kulanga, ‘Uleke kuchikema chiha ichinu chayadeghete Imulungu.’ ");
INSERT INTO ruf_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Imbuli ayo tsailawila mala ndatu, kuya ligholole liyutsighwa keli kulanga. ");
INSERT INTO ruf_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Baho iwanu wadatu iwatumighwe kuna nene kulawa Kaisariya wapfika mne ing'anda yaning'ali nikala. ");
INSERT INTO ruf_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ghumuhe ghwe Imulungu kanongela ndeke kupfuka, ng'ende nawo. Iwandughu wano sita pfipfila waghenda na nene, twingila mng'anda mwa Korineli. ");
INSERT INTO ruf_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Katulongela pfamwonile malaika yemile mng'anda mwake iyamlongele, ‘Utume iwanu isi ya Yopa wamkeme Simoni iyokemighwa Petiri. ");
INSERT INTO ruf_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Katsomghalilani imbuli iitsokukombola ghweghwe ne iwanu wose iwali mng'anda mwako.’ ");
INSERT INTO ruf_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Hanyanduse ukulonga, Ghumuhe Mwenzeluka kawahulumkila ka pfayatuhulumkile twetwe aho mwanduso. ");
INSERT INTO ruf_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Baho ng'umbuka chayalongile Imtwatsa. ‘Yohane tsakabatitsa kwa ghamatsi, lekeni mwemwe mtsobatitsa kwa Ghumuhe Mwenzeluka.’ ");
INSERT INTO ruf_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Apfo ka Imulungu kaweng'a iwanu iwali si Wayahudi nzawadi iila iyatwing'ile twetwe yatumtoghola Imtwatsa Yesu Kiristu, lelo nene nani nimpinge Imulungu?” ");
INSERT INTO ruf_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Hawahulike apfo, wenyamala. Wamtunya Imulungu, walonga, “Lelo, Imulungu kaweng'a iwanu iwali si Wayahudi toba iighala ughima.” ");
INSERT INTO ruf_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Kwa maghayo ighalawile Stefani hayakomighwe, iwanu iwamtoghole Yesu tsawapwililika. Wangi waghenda mbaka Foinike, Kupulo na Antiyokiya wapeta imbuli ila kwa Wayahudi waliyeka. ");
INSERT INTO ruf_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Wangi iwalawile Kupulo na Kirene waghenda Antiyokiya, pfipfila wandusa kulonga ne iwanu iwali si Wayahudi bae, wawapetela imbuli inoghile ye Imtwatsa Yesu. ");
INSERT INTO ruf_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ngupfu ye Imtwatsa tsaikala nawo, na iwanu wengi watoghola na kumuyila Imtwatsa. ");
INSERT INTO ruf_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Mbuli atso tsihulikighwa na iwanu iwamtoghole Yesu wa Yerusalemu, nawo wamtuma Balinaba aghende Antiyokiya. ");
INSERT INTO ruf_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Naye hapfikile na kuwona uluso we Imulungu kwe iwanu wala, kadeng'elela na kawalomba waghendelele kumtoghola Imtwatsa kwa mimoyo yawo yose. ");
INSERT INTO ruf_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Balinaba tsakakala imunu yanoghile na yamemile Ghumuhe Mwenzeluka na iyotoghola ghendo, na iwanu wengi tsawongetseka kwe Imtwatsa. ");
INSERT INTO ruf_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Kuya Balinaba kaghenda Taso kumbama Sauli. ");
INSERT INTO ruf_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Hamwonile, kamghala Antiyokiya. Nawo wose weli kwa ghumwaka mghima tsawetingana na iwanu iwamtoghole Yesu na kuwalangulitsa iwanu wengi. Iwanang'ina tsawandusa ukukemighwa Wakiristu ako Antiyokiya. ");
INSERT INTO ruf_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ghamatsuwa ghaghala manabii wangi we Imulungu iwalawile Yerusalemu wapfika Antiyokiya. ");
INSERT INTO ruf_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Yumwe wao iyakemighwe Agabo kema, na kwa uwetso wa Ghumuhe Mwenzeluka kalonga ka itsolawila inzala ng'ulu muisi mwose. Na inzala ayo ilawila mne ghamatsuwa gha mndewa Kilaudi. ");
INSERT INTO ruf_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Wakiristu wala walamula chila imunu ka pfayodaha aghale chochose ili kuwapfila iwanu iwamtoghole Yesu iwokala Yudeya. ");
INSERT INTO ruf_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Tsawatenda apfo, wawatuma Balinaba na Sauli wawaghalile iwabala we iwanu iwomtoghola Kiristu. ");
INSERT INTO ruf_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ghamatsuwa ghaghala mndewa Herodi kawaghogha iwanu wangi iwomtoghola Kiristu na kuwadununza. ");
INSERT INTO ruf_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Kamkoma kwa limaghe Jakobu ndughu yake Yohane. ");
INSERT INTO ruf_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Honile Wayahudi wanoghelesighwa na achila chayatendile, kaghendelela, kamghogha Petiri. Agha ghatendeka mne chihungo che ghamatsuwa ghe Pfighate ipfilihela hamila. ");
INSERT INTO ruf_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Hamghoghile, kamwika mchifungo, mne ghamoko gha makingili mane gha asikali wane wane, wamlolese. Herodi tsakabama Pasaka ing'amala amlapfe hambele he iwanu. ");
INSERT INTO ruf_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Petiri hayang'ali mchifungo, iwamtoghole Yesu wamlombela kwe Imulungu kwa ghumoyo. ");
INSERT INTO ruf_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Chilo chila Herodi ng'ana yamlapfe kunze hambele he iwanu, Petiri tsakawasa haghati ghati ha asikali weli, kohighwa minyororo mili, ne iwakalitsi tsawang'ali wololesa libani lya chifungo. ");
INSERT INTO ruf_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Bahala, malaika we Imtwatsa kalawila na ghumwanga ghumulika mne chiheleto chila. Malaika ayo kamtowa Petiri mlubapfu, kamlamsa. Kalonga, “Hima, winuke.” Bahala minyororo imwohile ghamoko ilaghala hasi. ");
INSERT INTO ruf_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Kuya malaika ayo kamlongela, “Pfala msipi ghwako na pfilatu pfako.” Petiri katenda apfo. Kuya kamlongela, “Pfala ghwanda lyako uniwinze.” ");
INSERT INTO ruf_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Petiri kamkoleletsa kunze mwa gheletsa, lekeni ng'amanyile bae ighatendighwe ne malaika we Imulungu ghang'ali gholawila kweli, ila kapfikitsa kakona ghamaono. ");
INSERT INTO ruf_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Wabita chituwo cha wakalitsi cha mwanduso na cha keli, kuya wapfika mne libani lye chuma ililongosa mne ghumji. Libani liwapfughukila lyenyegho, nawo walawa kunze. Hawang'ali woghenda mne inzila imwe, bahala malaika ayo kamleka Petiri. ");
INSERT INTO ruf_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Petiri hayatangile ichimlawile, kalonga, “Sambi nomanya ghendo ka Imtwatsa kamtuma malaika wake yandapfe mne ghamoko gha Herodi na kulawa mna chila chinu chawalolele Wayahudi.” ");
INSERT INTO ruf_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Hayatangile apfo, kaghenda kune ing'anda ya Mariya, mai wake Yohane, taghwa lyake lya keli Maliki ne iwanu wengi tsawetingana amo wolomba. ");
INSERT INTO ruf_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Petiri hayagong'onde libani lya kunze, imtumwa yumwe ipinga, taghwa lyake Roda katsa kuhulikitsa. ");
INSERT INTO ruf_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Naye hayamanyile litsi lya Petiri, kadeng'elela ng'ani mbaka kaleka kupfughula libani katsumila mng'anda, kawalongela, “Petiri kema kunze halibani.” ");
INSERT INTO ruf_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Wamlongela, “Kuna lukwale.” Lekeni yeye kakomangitsa ka pfipfo pfaili. Walonga, “Ayo malaika wake.” ");
INSERT INTO ruf_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Petiri kaghendelela kughong'onda libani, na hawapfughule hawamwone yeye, wakangawala. ");
INSERT INTO ruf_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Petiri kawapungila ghumoko wenyamale, kawalongela Imtwatsa pfayamlapfile mne ligheletsa. Kuya kawalongela wakamlongele Jakobu imbuli ayo, na awala wangi iwamtoghole Yesu, kuya yeye kaghenda hanu hangi. ");
INSERT INTO ruf_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Nemitondo haipfikile, asikali tsawapfuka ghendo kwa achila ichimlawile Petiri. ");
INSERT INTO ruf_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Kuya Herodi kalaghitsa wambame Petiri, lekeni ng'awamwonile bae. Kawaghutsa iwakalitsi wala, kuya kalaghitsa wakomighwe. Kuya Herodi kalawa Yudeya kaghenda Kaisariya, kakala ako matsuwa chidogho. ");
INSERT INTO ruf_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Naye Herodi tsakawonela maya iwanu wa Tiro na Sidoni. Apfo iwanu awo wamghendela hamwe. Hawamalitse kumtenda Balasto yawe sale yawo, imunu iyatogholighwe sideke ne imndewa. Walomba Herodi wakale nae tseghamba, kwaapfila isi tsawo tsatsing'ali tsihemela ichijo kulawa mne isi ye imndewa. ");
INSERT INTO ruf_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Litsuwa limwe ilisaghulighwe, Herodi kapfala maghwanda ghake gha chindewa, kakala mne chighoda chake che undewa, kalonga ne iwanu. ");
INSERT INTO ruf_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Iwanu wakemelela, “Alino litsi lya yumwe we milungu, si litsi lye imunu bae!” ");
INSERT INTO ruf_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Bahala malaika we Imtwatsa kamghwisa hasi Herodi, kwaapfila ng'amwing'ile bae Imulungu utunitso, kakindighwa na sango, kafa. ");
INSERT INTO ruf_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Imbuli ye Imulungu ighendelela kukula na ukwenela. ");
INSERT INTO ruf_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Balinaba na Sauli hawamalitse ing'onde ye Imulungu, woya kulawa Yerusalemu, wamsola na Yohane, iyakemighwe Maliki. ");
INSERT INTO ruf_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Mna awala iwamtoghole Yesu ako Antiyokiya tsakukala na manabii we Imulungu ne iwalangulitsi, nawo tsawakala Balinaba na Simoni iyakemighwe Mtitu na Lukiyo iyolawila Kirene na Sauli na Manaeni iyalelighwe hamwe na Herodi. ");
INSERT INTO ruf_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Hawang'ali womtamanila Imulungu na kufunga kuja, Ghumuhe Mwenzeluka kalonga, “Nibaghulileni Balinaba na Sauli, wasang'ane ing'onde yaniwakemele.” ");
INSERT INTO ruf_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Kuya hawamalitse kufunga ukuja na ukulomba, wawekila ghamoko wawaleka waghende. ");
INSERT INTO ruf_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Kuya Balinaba na Sauli aku waghalighwa na Ghumuhe Mwenzeluka, wahulumkila Seleukiya, na kulawa ako wadina mnumbwi mbaka Kupulo. ");
INSERT INTO ruf_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Hawapfikile ghumji ghwa Salami, wapeta imbuli ye Imulungu mne tsing'anda tsa ukulombela tse Wayahudi, Yohane Maliki tsayang'ali yowapfila mne sang'ano ayo. ");
INSERT INTO ruf_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Tsawanga mne chisiwa chose mbaka wapfika Pafo, ako wampfika Myahudi yumwe mhawi na nabii wa ughutsu iyakemighwe Bariyesu. ");
INSERT INTO ruf_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Imunu ayu tsakakala sale wa Serigiyo Pauli, imkulu we isi, imunu yane tsimbutsi ng'ani. Serigiyo Pauli tsakawakema Balinaba na Sauli waghende kuna yeye, tsakabama yahulike imbuli ye Imulungu. ");
INSERT INTO ruf_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Lekeni ayo mhawi Elima, kwaapfila ayo mana ya taghwa lyake tsakahisanya nawo, kabama amtende imkulu yula we ichisiwa aleke kutoghola Ukiristu. ");
INSERT INTO ruf_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Lekeni Sauli, pfipfila iyakemighwe Pauli, aku kamema Ghumuhe Mwenzeluka, kamtsodolela tsinenge Elima, ");
INSERT INTO ruf_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","kalonga, “Ghweghwe kwa imwana wa Setani! Ghweghwe kwa mwihile wa chila chinu chinoghile! Kumema ughutsu na ung'enye wose. Ghamatsuwa ghose ng'uleka bae kutsihinya nzila itsigholoke tse Imtwatsa! ");
INSERT INTO ruf_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Lelo ghumoko ghwe Imtwatsa ghutsokuhigha, naghwe kutsakuwa chimbughumbughu, ng'utsakwona bae litsua kwa ichipindi chino.” Bahala ukungu ne ichisi pfimtsila mnenge, kaghenda kuno na kuno, kabama imunu wa kumkinda ghumoko yamlongotse. ");
INSERT INTO ruf_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ayula imkulu we ichisiwa haghonile ighalawile, kamtoghola Yesu, kakangawala kwa malangulitso ghe Imtwatsa ");
INSERT INTO ruf_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Kuya Pauli na weyaghe wadina mnumbwi kulawa Pafo wapfika Periga, ghumji ighuli Pamfiliya, baho Yohane Maliki kawaleka, koya Yerusalemu. ");
INSERT INTO ruf_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Lekeni wawo waghendelela na ghumwanza kulawa Periga mbaka Antiyokiya ako Pisidiya. Litsuwa lya Sabato wengila mne ing'anda ye ukulombela, wakala hasi. ");
INSERT INTO ruf_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ichitabu cha malaghitso gha Musa ne ichitabu cha manabii we Imulungu hapfisomighwe, iwakulu we ing'anda ya ukulombela watuma imbuli kwa tsina Pauli, wawalongela, “Wandughu, ka mna imbuli yo ukuwalongela iwanu wano, walongeleni.” ");
INSERT INTO ruf_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pauli kenuka, kawapungila ghumoko kalonga, “Mwemwe Waisiraeli weyangu, na mwemwe iwanu wangi yamumpfuka Imulungu mnitegheletse! ");
INSERT INTO ruf_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Imulungu we iwanu wano wa Isiraeli tsakawasaghula aba tsetu, kawabaliki iwanu awo hala hawang'ali wahenza mne isi ya Misiri, kuya kwa uwetso wake mkulu kawalapfa mne isi ayo. ");
INSERT INTO ruf_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Kwa miyaka ka alubaini kawadudumila akula kunyika. ");
INSERT INTO ruf_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Naye tsakaghahinya makabila saba mne isi ya Kanani, na kuweng'a iwanu wake isi ila iwe yawo. ");
INSERT INTO ruf_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Agha ghose ghakala kwa miyaka miya nne hamsini. “Hambele, Imulungu kaweng'a walamutsi iwanu wake mbaka mne matsuwa gha Samweli, nabii we Imulungu. ");
INSERT INTO ruf_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Kuya iwanu walomba wawe ne imndewa, Imulungu kaweng'a Sauli, imwana wa Kishi wa kabila lya Benjamini yawe mndewa wawo kwa chipindi cha miyaka alubaini. ");
INSERT INTO ruf_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Imulungu hamlapfile Sauli, kamsaghula Daudi yawe mndewa wawo. Imulungu kamlonga pfino Daudi, ‘Nimwona Daudi imwana wa Yese, ka imunu yaghunoghele ghumoyo ghwangu. Yeye katsotenda aghala ghose ghanibama yaghatende.’ ");
INSERT INTO ruf_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Kulawa mne lukolo lwa Daudi, Imulungu kawaghalila iwanu wa Isiraeli Mkombotsi Yesu, ka pfalongile. ");
INSERT INTO ruf_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Hala Yesu ng'ana yanduse isang'ano yake, Yohane tsakawapetela iwanu wose wa Isiraeli watsileke nzambi na wabatitsighwe. ");
INSERT INTO ruf_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Naye Yohane hang'ali yomalitsa isang'ano yake, kalonga, ‘Mwemwe mwolonga nene mkombotsi? Nene si yula bae yamumbeta. Ila ayo kakutsa kuchughu kwangu na nene sibamighwa bae kudohola imitsabi ye imikwabatsa yake.’ ");
INSERT INTO ruf_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Ndughu tsangu, watsukulu wa Abrahamu, namwe iwanu iwali si Wayahudi yamumpfuka Imulungu, imbuli ino ya ukombotsi ighalighwa kuna twetwe. ");
INSERT INTO ruf_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Iwanu wa Yerusalemu na iwakulu wawo ng'awamtangile bae Yesu ka iyo imkombotsi, apfo watimilitsa mbuli tse manabii we Imulungu itsisomighwa chila litsuwa lya Sabato kwa kumuwamba mna msalaba. ");
INSERT INTO ruf_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Hata ka ng'awonile bae imbuli iimtenda yakomighwe, wamlomba Pilato yamuhighe yamkome. ");
INSERT INTO ruf_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Hawamalitse kughatenda ghose ghandikilighwe yeye mne Ghamaandiko, wamhulumsa kulawa mna msalaba, wamwika mne likabuli. ");
INSERT INTO ruf_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Lekeni Imulungu kamtsilihula, ");
INSERT INTO ruf_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","na kwa ghamatsuwa mengi ang'ali yakoneka na awala iwang'ali wakwanga naye kulawa Galilaya kughenda Yerusalemu. Hawo sambi wa iwakalangama wake kwa iwanu wa Isiraeli. ");
INSERT INTO ruf_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Na twetwe twompetelani mwemwe imbuli inoghile, mbuli ila Imulungu yelaghane ne iwabala wetu. ");
INSERT INTO ruf_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Kaitimilitsa kuna twetwe watsukulu wawo kwa kumtsilihula Yesu ka pfayandikighwe mne Tsaburi ya kabili, “Ghweghwe kwa imwanangu, leloli niwa Aba wako.” ");
INSERT INTO ruf_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Kuya mne imbuli ya ukumtsilihula aleke kwola, Imulungu kalonga apfi, “Nitsomwing'ani mwemwe tsibalaka tsa kweli itsideghete, tsanilaghane na Daudi.” ");
INSERT INTO ruf_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Na hanu hangi mne Tsaburi holonga, “Ng'utsomleka bae Mwenzeluka wako yole.” ");
INSERT INTO ruf_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Lekeni kwa Daudi ng'aiwile apfo bae, kwaapfila Daudi tsakamalitsa kumtumikila Imulungu mne ughima wake, kuya kafa, katsikighwa hamwe na aba tsake na lukuli lwake lwola. ");
INSERT INTO ruf_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Lekeni ayula iyatsilihulighwe ne Imulungu, ng'olile bae. ");
INSERT INTO ruf_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Apfo wandughu tsangu nobama mmanye ka kubitila Yesu, imbuli ya kuleghusighwa nzambi yopetighwa kuna mwemwe, ");
INSERT INTO ruf_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","na chila imunu iyomtoghola Yesu koleghusighwa nzambi tsake, chinu ing'achidahika bae kwa ghamalaghitso gha Musa. ");
INSERT INTO ruf_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Mwalangitse lelo ileke kuwalawila imbuli yawalongile manabii we Imulungu, ");
INSERT INTO ruf_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Mtegheletse mwemwe imbetsa, mkangawale mwaghe. Kwaapfila nene nitsotenda ichinu mne ghamatsuwa ghenu, ichinu yang'amtsochitoghola ghendo hata imunu ang'awalongela!’ ” ");
INSERT INTO ruf_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pauli na Balinaba hawang'ali wolawa mne ing'anda ya ukulombela, iwanu wawalomba watse walonge ipfinu pfino mne litsuwa lya Sabato ilikutsa. ");
INSERT INTO ruf_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Mtingano haghumalile, Wayahudi wengi ne iwanu wengi iwali si Wayahudi bae iwompfuka Imulungu wawawinza. Pauli na Balinaba walomba nawo, wawaghela ghumoyo waghendelele mne uluso we Imulungu. ");
INSERT INTO ruf_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Mne litsuwa lya Sabato liwinzile, iwanu wa ghumji ghose wetingana kuhulikitsa imbuli ye Imulungu. ");
INSERT INTO ruf_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Lekeni Wayahudi hawonile mtingano aghwo, wona chepfu, wabela aghala ghayang'ali yolonga Pauli, kuya wamligha. ");
INSERT INTO ruf_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Lekeni Pauli na Balinaba wawedika bila kupfuka, “Tsatubamighwa tanu tuwalongele mwemwe imbuli ye Imulungu, lekeni kwaapfila mwoilema na kwibona ka ng'ambamighwa bae kuwa na ughima wa ghamatsuwa ghose. Lelo twowaghendela iwanu iwali si Wayahudi bae. ");
INSERT INTO ruf_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Kwaapfila Imtwatsa tsakatulaghitsa apfi, ‘Nikwika uwe ghumwanga kwe iwanu iwali si Wayahudi bae, uwaghalile ukombotsi mbaka utsighilo we isi.’ ” ");
INSERT INTO ruf_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Iwanu iwali si Wayahudi bae hawahulike apfo, wadeng'elela na waitunya imbuli ye Imtwatsa, na wose iwasaghulighwe kwa ughima wa ghamatsuwa ghose watoghola. ");
INSERT INTO ruf_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Imbuli ye Imtwatsa yenela mne isi yose ila. ");
INSERT INTO ruf_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Lekeni Wayahudi wawasongesa iwapinga iwohulikitsighwa, iwampfukile Imulungu, ne iwakulu we isi ila. Wandusa kuwadununza Pauli na Balinaba, kuya wawawinga mna isi yawo. ");
INSERT INTO ruf_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Nawo iwatumighwa wawakung'usila timbwisi lya ghamaghulu ghawo, kuya waghenda mne isi ya Ikoniya. ");
INSERT INTO ruf_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Na iwanang'ina tsawadeng'elela na wamema Ghumuhe Mwenzeluka. ");
INSERT INTO ruf_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ako Ikoniya Pauli na Balinaba tsawaghenda mne ing'anda ya ukulombela ya Wayahudi ka pfawaghendagha. Na kwaapfila pfawalongile, Wayahudi ne iwanu iwali si Wayahudi wengi wamtoghola Yesu. ");
INSERT INTO ruf_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Lekeni Wayahudi ing'awotoghola wawasongesa iwanu iwali si Wayahudi bae wawahile iwanu iwamtoghole Yesu. ");
INSERT INTO ruf_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pauli na Balinaba waghendelela kukala ako matsuwa mengi, walonga mbuli tse Imtwatsa bila kupfuka, iyalanguse usenga wa uluso wake ka wa kweli kwa kuweng'a uwetso wa kutenda pfihulo ne ipfinu pfa ukukangawatsa. ");
INSERT INTO ruf_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Iwanu wa isi ila tsaweghola, wangi wawawinza Wayahudi na wangi wawawinza iwatumighwa. ");
INSERT INTO ruf_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Kuya iwanu iwali si Wayahudi na Wayahudi ne iwakulu wawo walamla wawatendele pfihile iwatumighwa awo, na wawatowe ne ghamabwe. ");
INSERT INTO ruf_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Lekeni iwatumighwa hawahulike imbuli ayo watsumila Lisitira na Deribe, isi ya Likaniya na mne isi itsili habehi, ");
INSERT INTO ruf_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ako waghendelela kupeta Imbuli Inoghile. ");
INSERT INTO ruf_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ako Lisitira tsakukala ne imunu yaholole ghamaghulu, tsakakala chimbete kulawa kwelekighwa kwake na ng'aghendile bae. ");
INSERT INTO ruf_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Imunu ayo kamhulikitsa Pauli hayang'ali yolonga, na Pauli hayamtsodolele tsinenge, kamwona imunu ayo kotoghola ka kodaha kuhonetsighwa, ");
INSERT INTO ruf_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","kakemelela, “Wime wima kwa ghamaghulu ghako!” Bahala imunu ayo kadaluka, kandusa kughenda. ");
INSERT INTO ruf_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Na mtingano hawonile chatendile Pauli wakemelela kwa Chilukoniya, “Milungu iwa ka wanu, nayo ituhulumkila twetwe.” ");
INSERT INTO ruf_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Wamwing'a taghwa Balinaba Seyu, na Pauli wamkema Heme kwaapfila yeye tsakakala mlonga mkulu. ");
INSERT INTO ruf_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Mlapfa inambiko wa Seyu, ing'anda yake ye ukulombela iikalile aho kunze kwe ghumji, kaghala ng'ombe na maluwa mna imibani ya ghumji kwaapfila yeye na mtingano ghula ghwe iwanu tsawabama wawalapfile nambiko iwatumighwa. ");
INSERT INTO ruf_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Lekeni Pauli na Balinaba hawahulike apfi, waghadegha maghwanda ghawo, watsumila mne mtingano ghwe iwanu, wakemelela. ");
INSERT INTO ruf_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Amweye, ebali mwotenda apfi? Twetwe pfipfila twa iwanu ka mwemwe. Twowaghalila Imbuli Inoghile ili mpfileke ipfinyagho, na mumuhindukile Imulungu yane ughima, iyalumbile kulanga ne isi ne ibahali ne ipfinu pfose ipfili mumo. ");
INSERT INTO ruf_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ghumwande, tsakawaleka iwanu wose watende ka pfawobama. ");
INSERT INTO ruf_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Lekeni ng'alekile bae kwilangusa kwa kuwatendela ghanoghile, kaweng'a imvula kulawa kulanga na ghamapfuno kwa imisimu, kawagholela ipfijo pfingi na kuwamemesa deng'elelo mne mimoyo yenu.” ");
INSERT INTO ruf_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Hata ka tsawalonga apfo, ikala pfikomu kuwaghoma waleke kuwatambikila. ");
INSERT INTO ruf_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Lekeni Wayahudi wamwenga iwalawile Antiyokiya ne Ikoniya tsawatsa, wawatenda iwanu wawe chinu chimwe nawo. Wamtowa Pauli ne ghamabwe, wamkwegha mbaka kunze kwe ghumji, tsawapfikitsa kafa. ");
INSERT INTO ruf_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Lekeni iwanang'ina hawamtsunguluke, Pauli kenuka koya ukaye. Litsuwa liwinzile yeye na Balinaba waghenda Deribe. ");
INSERT INTO ruf_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Tsawapeta Imbuli Inoghile mne isi ayo na iwanu wengi wamtoghola Yesu. Kuya woya Lisitira na Ikoniya na Antiyokiya. ");
INSERT INTO ruf_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Wawaghuma ghumoyo iwanang'ina, wawalomba wakale mne ukutoghola kula. Wawalongela, “Twobamighwa tubitile mne maghayo mengi ukwingila mne undewa we Imulungu.” ");
INSERT INTO ruf_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Pauli na Balinaba hawamalitse kuwasaghula iwakulu mna chila kingili lye iwanu iwomtoghola Kiristu, walomba na wafunga ukuja, kuya waweka mna ghamoko ghe Imtwatsa iwamtoghole. ");
INSERT INTO ruf_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Kuya Pauli na Balinaba woka Pamfiliya kubitila Pisidiya. ");
INSERT INTO ruf_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Hawamalitse kupeta imbuli ako Periga, wahulumka mbaka Ataliya. ");
INSERT INTO ruf_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Kulawa Ataliya, wadina mne mnumbwi, woya Antiyokiya, hanu hala hawawalombele iwanu uluso we Imulungu kwa isang'ano ila yawaitimitse. ");
INSERT INTO ruf_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Hawapfikile hala, tsawetingana na iwanu iwamtoghole Yesu, wawalongela ipfinu pfose pfayatendile Imulungu hamwe nawo, na pfayawapfughulile libani lye ukutoghola iwanu iwali si Wayahudi bae. ");
INSERT INTO ruf_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Na wakala ako kwa matsuwa mengi, hamwe ne iwanu iwamtoghole Yesu. ");
INSERT INTO ruf_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Tsakukala ne wanu iwalawile Yudeya wapfika Antokiya, na wandusa kuwalangulitsa iwanu iwamtoghole Yesu, wawalongela, “Ka ng'amkwingila ngoma ka pfalaghitse Musa ng'amdaha kukombolighwa.” ");
INSERT INTO ruf_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Imbuli ino iwatenda Pauli na Balinaba wesonge nawo. Apfo Pauli na Balinaba wasaghulighwa hamwe ne iwanu wangi wa Antiyokiya iwamtoghole Yesu waghende Yerusalemu kuwona iwatumighwa ne iwabala kwaajili ye imbuli ayo. ");
INSERT INTO ruf_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Tsawaghalighwa na Wakiristu, na hawang'ali woghenda wabitila Foinike na Samariya, wawalongela iwanu iwali si Wayahudi bae pfawamtoghole Imulungu. Imbuli ino iwadeng'elesa ng'ani iwanu wose iwamtoghole Yesu. ");
INSERT INTO ruf_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Hawapfikile Yerusalemu wabokelighwa na iwanu iwamtoghole Yesu ne iwatumighwa ne iwabala, nawo wawalongela ipfinu pfose Imulungu pfayatendile kubitila wawo. ");
INSERT INTO ruf_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Lekeni iwanu wangi iwamtoghole Yesu kulawa kingili lya Mafarisayo wema, walonga, “Yobamighwa iwanu iwali si Wayahudi bae wengile ngoma na waghakinde malaghitso gha Musa.” ");
INSERT INTO ruf_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Iwatumighwa ne iwabala wetingana ili walangule imbuli ayo. ");
INSERT INTO ruf_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Hawamalitse mdawalo, Petiri kenuka, kawalongela, “Ndughu tsangu, mwomanya ka ghumwande Imulungu tsakanisaghula kulawa mna mwemwe niwapetele Imbuli Inoghile iwanu iwali si Wayahudi bae, wahulike na kuitoghola. ");
INSERT INTO ruf_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Imulungu iyomanya imimoyo ye iwanu kalangusa ka kawatoghola kwa kuweng'a Ghumuhe Mwenzeluka, ka pfayatendile kuna twetwe. ");
INSERT INTO ruf_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ng'atendile bae ubaghutsi wowose kuna twetwe na kuna wawo, kaideghetesa imimoyo yawo kwa ukutoghola. ");
INSERT INTO ruf_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Lelo ebali, mwomghetsa Imulungu kwa kuwatwika imtsigho mtito iwamtoghole Yesu, imtsigho yang'atudahile twetwe kuwinula wala iwabala wetu? ");
INSERT INTO ruf_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Lekeni twotoghola kuwa twokombolighwa kwa uluso we Imtwatsa Yesu, ka wawo pfawotoghola.” ");
INSERT INTO ruf_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Apfo mtingano wose we iwanu tsaghunyamala wawategheletsa Balinaba na Pauli wowalongela pfihulo na pfinu pfa kukangawatsa pfayatendile Imulungu kubitila wawo kwe iwanu iwali si Wayahudi. ");
INSERT INTO ruf_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Hawamalitse kulonga, Jakobu kalonga, “Ndughu tsangu mnitegheletse. ");
INSERT INTO ruf_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simoni tsakatulongela Imulungu pfayawatendele iwanu iwali si Wayahudi aho mwanduso, tsakawasaghula wangi wawo wawe iwanu wake. ");
INSERT INTO ruf_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Imbuli tse manabii we Imulungu tseghala ghendo ne imbuli ino, ka Ghamaandiko pfagholonga, ");
INSERT INTO ruf_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Imulungu kolonga, ‘Hambele he ipfinu pfino nitsakuya, na nene nitsochitsenga keli chibumbulika cha Daudi ichighwile. Nitsotsenga mahame ghake na kuchimitsa keli. ");
INSERT INTO ruf_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ili iwanu iwasighale wambame Imtwatsa, ne iwanu iwali si Wayahudi bae wose yaniwakemile wawe wangu. ");
INSERT INTO ruf_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Apfi pfipfo pfayolonga Imtwatsa, iyatendile imbuli ino imanyike kulawa ghumwande.’ ");
INSERT INTO ruf_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Yakobu kaghendelela kulonga, “Lelo nene nolamla pfino, tuleke kuwadununza iwanu iwali si Wayahudi bae iwamuhundukile Imulungu, ");
INSERT INTO ruf_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ila tuwandikile ibaluwa ya kuwalongela waleke ukuja ipfijo ipfihinyighwe kwa kutambikighwa kwe ipfinyagho, waleke utsinzi, waleke ukuja imnyama yabotighwe na waleke ukunwa idamu. ");
INSERT INTO ruf_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Kwaapfila kulawa ghumwande Malaghitso gha Musa tsaghapetighwa chila kaye mne tsing'anda tse Imulungu chila litsuwa lya Sabato.” ");
INSERT INTO ruf_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Kuya iwatumighwa ne iwabala hamwe ne kingili lye iwanu wose iwomtoghola Kiristu walamla kuwasaghula iwanu mghati mwawo na kuwaghala Antiyokiya hamwe na Pauli na Balinaba. Apfo wawasaghula Yuda iyakemighwe Barisaba, na Sila. Awo tsawakala pfilongotsi we iwanu iwamtoghole Yesu. ");
INSERT INTO ruf_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Waweng'a ibaluwa ino, “Twetwe iwatumighwa ne iwabala ne iwandughu tsenu twowalamsani mwemwe iwanu iwali si Wayahudi bae imumtoghola Imulungu yamli ako Antiyokiya, Siriya na Kilikiya. ");
INSERT INTO ruf_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Kwaapfila tuhulika ka iwanu wangi iwalawile kuna twetwe wawahanganya na waitsufa mimoyo yenu kwa chawalongile, lekeni ng'awatumighwe na twetwe bae. ");
INSERT INTO ruf_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Apfo twitingana hamwe, tulamla kusaghula iwanu na kuwaghala kuna mwemwe hamwe na sale tsetu tsina Balinaba na Pauli, ");
INSERT INTO ruf_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","iwanu iwalapfile ughima wawo kwa taghwa lye Imtwatsa Yesu Kiristu. ");
INSERT INTO ruf_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Apfo twowatuma Yuda na Sila kuna mwemwe. Awo watsowalongela iwenyegho acho chatumwandikileni. ");
INSERT INTO ruf_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ghumuhe Mwenzeluka katulangusa tuleke kuwatwika mtsigho kubita aghano ghambamighwa mghamanye, ");
INSERT INTO ruf_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","mleke ukuja ipfijo ipfitambikighwe kwe ipfinyagho, mleke ukunwa idamu, na mleke ukuja chibudu, na mleke utsinzi. Mtsotenda ghoya mng'aghaleka agho. Mkale tseghamba.” ");
INSERT INTO ruf_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Iwanu awo walawa Yerusalemu wahulumkila Antiyokiya, baho wawakema iwanu wose iwomtoghola Kiristu, waweng'a ibaluwa ila. ");
INSERT INTO ruf_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Nawo hawamalitse kuisoma, mbuli tsake tsiwaghuma ghumoyo, tsawadeng'elela sideke. ");
INSERT INTO ruf_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Kuya Yuda na Sila kwaapfila wawo iwenyegho tsawakala manabii we Imulungu, walonga mengi kuwaghuma ghumoyo na kuwaghela ngupfu iwanu iwamtoghole Yesu. ");
INSERT INTO ruf_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Na hawamalitse kukala ako, iwanu iwamtoghole Yesu wawalekela waghende tseghamba kwa awo iwawatumile. ");
INSERT INTO ruf_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Lekeni Sila kalamla kusighala. ");
INSERT INTO ruf_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pauli na Balinaba wakala ako Antiyokiya, ako walangulitsa na kupeta Imbuli ye Imtwatsa hamwe ne iwanu wamwenga wengi. ");
INSERT INTO ruf_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Haghabitile matsuwa mengi, Pauli kamlongela Balinaba, “Leka tuye kuchughu tukawalole wayetu iwamtoghole Yesu mne kaye tsose tsatuwapetele imbuli ye Imtwatsa na kuwona pfawoghendelela.” ");
INSERT INTO ruf_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Balinaba tsakabama yamsole Yohane iyakemighwe Maliki waghende naye. ");
INSERT INTO ruf_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Lekeni Pauli ng'abamile bae waghende na Maliki, kwaapfila tsakawaleka akula Pamfiliya na ng'aghendelele ne isang'ano hamwe nawo. ");
INSERT INTO ruf_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Kuya wesonga ng'ani mbaka weghola. Balinaba kamsola Maliki, wadina mne mnumbwi waghenda Kupulo. ");
INSERT INTO ruf_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Naye Pauli kamsaghula Sila, ne iwanu iwamtoghole Kiristu wa hanu hala hawamalitse kuwalombela uluso we Imtwatsa, woka. ");
INSERT INTO ruf_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Tsakabita Siriya na Kilikiya kughaghuma ghumoyo makanisa. ");
INSERT INTO ruf_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pauli kapfika Deribe, kuya kapfika Lisitira. Baho tsakukala ne imunu yumwe iyomtoghola Yesu, taghwa lyake Timoteo. Mai wake tsakala Myahudi iyamtoghole Imtwatsa, lekeni aba wake tsakakala Mgiriki. ");
INSERT INTO ruf_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Timoteo tsayang'ali yotogholighwa ne iwanu iwamtoghole Yesu iwakalile Lisitira na Ikoniya. ");
INSERT INTO ruf_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pauli tsakabama yelongotse naye, apfo kamwingitsa ngoma kwaajili ya Wayahudi iwakalile isi ila, kwaapfila wose tsawamanya aba wake kakala Mgiriki. ");
INSERT INTO ruf_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Na hawang'ali wakwanga mne kaye tsila, waweng'a iwanu iwamtoghole Imtwatsa malaghitso ighalamlighwe ne iwatumighwa ne iwabala ako Yerusalemu na kuwalongela waghakinde. ");
INSERT INTO ruf_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Apfo makanisa ghongetseka mne ukutoghola, ne iwanu iwomtoghola Imtwatsa wang'ali wakongetseka chila litsuwa. ");
INSERT INTO ruf_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pauli na wayaghe waghenda mne isi ya Firigiya na Galatiya, kwaapfila waghomighwa na Ghumuhe Mwenzeluka waleke kulonga imbuli ila mne isi ye Asiya. ");
INSERT INTO ruf_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Hawapfikile habehi na Misiya, tsawabama waghende Bisiniya, lekeni Ghumuhe ghwa Yesu kawaghoma. ");
INSERT INTO ruf_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Apfo wabita Misiya, wahulumkila Tirowa. ");
INSERT INTO ruf_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Chilo chila Pauli tsakona ghamaono ghe imunu wa Makedoniya kema, komlomba, kalonga, “Loka utse Makedoniya utwapfile!” ");
INSERT INTO ruf_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pauli hayamalitse kwona ghamaono, baho twiyandaa tughende Makedoniya, kwaapfila twona ka Imulungu katukema kuwalongela Imbuli Inoghile. ");
INSERT INTO ruf_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Kulawa Tirowa, tudina mnumbwi mbaka Samotirake, litsuwa liwinzile tupfika Napoli. ");
INSERT INTO ruf_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Kulawa ako tughenda Filipi, kaye ng'ulu mne isi ya Makedoniya, hane undewa wa Chirumi. Tukala ako kwa ghamatsuwa mengi. ");
INSERT INTO ruf_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Mne litsuwa lya Sabato tsatughenda kune ghumto kunze mwa libani lya ghumji, baho tsatupfikitsa kung'akalile na hanu he ukulombela. Tukala hasi, tulonga ne iwapinga iwatingane hanu hala. ");
INSERT INTO ruf_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Mna awala iwatutegheletse tsakukala ne ipinga yumwe iyompfuka Imulungu. Tsakakemighwa Lidiya, ipinga ayo kolawila mne ghumji ghwa Tiyatira. Yeye tsaang'ali youtsa maghwanda gha bei ng'ulu. Imulungu tsakapfughula ghumoyo ghwake kubokela aghala ghayalongile Pauli. ");
INSERT INTO ruf_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Hayamalitse kubatitsighwa yeye ne iwanu wa kaye yake, katulomba tughende ukaye yake, kalonga, “Ka mmbona nene nomtoghola Imtwatsa, mtse mkale ukaye yangu.” Katulomba ghendo tughende. ");
INSERT INTO ruf_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Litsuwa limwe hatung'ali twoghenda hanu he ukulombela tutingana ne imtumwa yumwe mwali iyakalile ne ichinyamkela wa kulaghula. Mwali ayo tsayang'ali yowapatila sendi nyingi ng'ani iwatwatsa wake kwa ukulaghula kwake. ");
INSERT INTO ruf_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Mwali ayo tsakamkoleletsa Pauli na twetwe, aku kokemelela, “Iwanu wano wa iwatumighwa we Imulungu iyali kuchanya ng'ani. Womlongelani pfamdaha ukukombolighwa!” ");
INSERT INTO ruf_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Tsakatenda apfo chila litsuwa, mbaka Pauli tsakona maya, kamghalukila ichinyamkela yula kamlongela, “Nokulaghitsa kwa taghwa lya Yesu Kiristu, lawa kuna mwali yuno!” Bahala ichinyamkela kamlawa. ");
INSERT INTO ruf_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Iwatwatsa wake hawamanyile ka lolelo lyawo lya kupata sendi lyuka, wawaghogha Pauli na Sila, wawakwegha mbaka kuna ghulilo hambele he iwakulu we isi. ");
INSERT INTO ruf_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Wawaghala kwe iwalamutsi, walonga, “Iwanu wano Wayahudi, nawo wotenda hengele muisi mwetu, ");
INSERT INTO ruf_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","kuya wolangulitsa mbuli tse ipfihendo ipfatughomighwe twetwe Waroma kupfibokela au kupfiwinza.” ");
INSERT INTO ruf_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Iwanu wose welunga kuwatowa Pauli na Sila. Kuya iwalamutsi waghadegha maghwanda gha Pauli na Sila, walaghitsa watowighwe pfiboko. ");
INSERT INTO ruf_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Hawamalitse kuwatowa ng'ani, waweka mwigheletsa, wamlaghitsa mkalitsi wa chifungo yawalolese ghendo. ");
INSERT INTO ruf_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Naye hayabokele ghamalaghitso agho, kaweka mne ichiheleto cha mghati, kawoha ghamaghulu ghawo kwa libao. ");
INSERT INTO ruf_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Lekeni chilo chikulu Pauli na Sila tsawang'ali womlomba Imulungu na kumwimbila na ukumtunya, ne iwanu wangi iwohighwe wang'ali wowategheletsa. ");
INSERT INTO ruf_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Bahala tsaghulawila mdedemo mkulu ghwe iisi mbaka lukwambatsa lwa chifungo luhighisika. Baho imibani ipfughuka na tsimingu tsa chila imunu tsileghela. ");
INSERT INTO ruf_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Mkalitsi yula wa ligheletsa kalamka, na honile imibani ya ligheletsa ipfughuka, kasola limaghe kabama yekome imwenyegho kwaapfila tsakapfikitsa iwohighwa watsuma. ");
INSERT INTO ruf_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Lekeni Pauli kakemelela, “Uleke kwilagha umwenyegho! Wose twabaha!” ");
INSERT INTO ruf_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Imkalitsi ayo wa ligheletsa kalomba chitasa chighalighwe, katsumila mng'anda, keghwisa mmaghulu mwa Pauli na Sila aku kodedema. ");
INSERT INTO ruf_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Kuya kawalapfa kunze kawaghutsa, “Watwatsa wangu, nendetse ili ng'ombolighwe?” ");
INSERT INTO ruf_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Wamwidika, “Umtoghole Imtwatsa Yesu, naghwe kutsokombolighwa hamwe ne kaye yako.” ");
INSERT INTO ruf_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Wampetela imbuli ye Imtwatsa, yeye ne iwanu wose iwali mkaye mwake. ");
INSERT INTO ruf_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ichilo chichila yula imkalitsi wa ligheletsa kawasola, kawopfugha ipfilonda pfawo, kuya yeye ne iwanu wa kaye yake wabatitsighwa. ");
INSERT INTO ruf_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Kawasola Pauli na Sila kawaghala ukaye yake, kawekila ichijo, naye na iwanu wa kaye yake yose wadeng'elela kwaapfila sambi tsawang'ali womtoghola Imulungu. ");
INSERT INTO ruf_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Lupfilipfili iwalamutsi wawatuma iwakulu we asikali kwe imkalitsi wa ligheletsa walonga, “Walekeni iwanu wala woke.” ");
INSERT INTO ruf_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ayula imkalitsi wa chifungo kamlongela Pauli. “Iwalamutsi walaghitsa ghweghwe na Sila mlekelighwe. Lelo mwodaha kuka, mghende tseghamba.” ");
INSERT INTO ruf_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Lekeni Pauli kawalongela iwakulu we asikali, “Watutowa hambele he iwanu hata ka ng'atutendile totso, na twetwe twa Waroma, kuya watwika mwigheletsa. Lelo wobama watulapfe chinyelenyele. Bae! Leka watse watulapfe iwenyegho.” ");
INSERT INTO ruf_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Iwakulu we asikali wawalongela iwalamutsi, na hawahulike kuwa Pauli na Sila tsawakala iwanu wa Roma, wapfuka. ");
INSERT INTO ruf_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Apfo watsa, wawalomba wawasamehe, kuya wawalapfa mne ligheletsa na kuwalomba walawe mne ghumji ghula. ");
INSERT INTO ruf_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pauli na Sila hawalawile mchifungo waghenda mne ing'anda ya Lidiya, baho wetingana ne iwanu iwamtoghole Yesu, wawaghela ghumoyo. Kuya woka. ");
INSERT INTO ruf_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pauli na Sila waghenda mbaka Tesalonike, wabitila Amfipoli na Apoloniya, ako tsakukala ne ing'anda ya ukulombela ya Wayahudi. ");
INSERT INTO ruf_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pauli ka pfatsowele, kengila mne ing'anda ye ukulombela ne ukulonga nawo kwa matsuwa gha sabato madatu, kwa Ghamaandiko Mahenzeluka kawalongela na ");
INSERT INTO ruf_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","kuwalangusa ka ibamighwa Kiristu yadununzike na kutsilihuka. Pauli kalonga, “Ayu Yesu yaniwapetela mbuli tsake, iyo Kiristu Mkombotsi.” ");
INSERT INTO ruf_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Wayahudi wangi watoghola na welunga na Pauli na Sila, pfipfila na Wagiriki iwampfukile Imulungu ne iwapinga wengi pfilongotsi watoghola. ");
INSERT INTO ruf_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Lekeni Wayahudi wona chepfu, wawasola iwanu wehile kulawa mne ghulilo, wandusa kutenda hengele mne kaye yose. Wengila mng'anda mwa Yasoni kuwabama tsina Pauli na Sila ili wawaghale kunze kune iwanu. ");
INSERT INTO ruf_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Lekeni ng'awawapfikile bae, apfo wamkwegha Yasoni ne iwanu wangi iwamtoghole Yesu mbaka kwe iwakulu wa ghumji, wakemelela, walonga, “Iwanu wano iwaihinyile iisi yose lelo watsa hano, ");
INSERT INTO ruf_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","na Yasoni kawabokela ukaye yake. Wawo wose wolema kutenda malaghitso gha Mkulu wa Roma, wolonga kuna imndewa yungi, taghwa lyake Yesu.” ");
INSERT INTO ruf_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Iwakulu we isi ne iwanu hawahulike apfo tsawaghanzika. ");
INSERT INTO ruf_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Iwakulu awo wawatotsa faini Yasoni na wayaghe, kuya wawalekelela woke. ");
INSERT INTO ruf_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Chilo hachingile iwanu iwamtoghole Yesu wawaghala Pauli na Sila ako Bereya. Hawapfikile ako, waghenda mne ing'anda ye ukulombela ya Wayahudi. ");
INSERT INTO ruf_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Iwanu wa Bereya wang'ali wotegheletsa pfinoghile kubita iwanu wa Tesalonike. Kwaapfila waibokela imbuli kwa kusulukila, na chila litsuwa wang'ali woghalola ghoya Ghamaandiko Mahenzeluka, wone ka Pauli ang'ali yolongesa. ");
INSERT INTO ruf_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Wayahudi wengi watoghola ka pfawatoghole iwapinga wengi wa Chigiriki wane ukulu ne iwamale wengi wa Chigiriki. ");
INSERT INTO ruf_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Wayahudi wa Tesalonike hawamanyile Pauli yang'ali yopeta imbuli ye Imulungu ako Bereya, pfipfila nawo waghenda ako, wandusa kulisongesa kingili lye iwanu. ");
INSERT INTO ruf_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Bahala iwanu iwamtoghole Yesu wamghala Pauli kumwani. Lekeni Sila na Timoteo wasighala ako Bereya. ");
INSERT INTO ruf_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Awala iwanu iwamghalile Pauli, waghenda naye mbaka Asene. Kuya wamleka, woya na malaghitso gha tsina Sila na Timoteo ka waleke kukawa kumuwinza Pauli. ");
INSERT INTO ruf_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pauli hayang'ali yowabeta ako Asene, honile isi ila imema pfinyagho pfingi pfe milungu, kehilwa mmoyo mwake. ");
INSERT INTO ruf_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Apfo ang'ali yolonga na Wayahudi na Wagiriki iwompfuka Imulungu mne ing'anda ye ukulombela. Pfipfila chila litsuwa yang'ali yolonga ne iwanu iyatingane nawo mne ghulilo. ");
INSERT INTO ruf_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Iwanu wa Epikuro na Stoiki iwang'ali welangulitsa falisafa wandusa kwisonga naye. Wangi walonga, “Angu mbotsi yuno yolonga choni?” Wangi walonga, “Kakoneka kopeta mbuli tse milungu migheni.” Walonga apfo kwaapfila Pauli yang'ali yopeta imbuli ya Yesu na ukutsilihuka. ");
INSERT INTO ruf_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Kuya wamsola, wamghala hanu he ukutinganila ha Areopagho, wamlongela, “Utulongele malangulitso ghachi ghano gha sambi ghweghwe ghaulonga? ");
INSERT INTO ruf_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Kwaapfila kutughalila ipfinu pfihenza, na twetwe twobama tumanye mbuli atso tsina mana yachi.” ");
INSERT INTO ruf_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Iwanu wa Asene na iwagheni iwang'ali wokala ako tsawang'ali wotumila matsuwa ghawo ghose kulonga na kuhulikitsa mbuli tse sambi. ");
INSERT INTO ruf_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Apfo Pauli kema hambele ha mtingano wa Areopagho, kalonga, “Amweye iwanu wa Asene nene nakona mwemwe mwa iwanu yamuwinza dini ghendo. ");
INSERT INTO ruf_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Kwaapfila haning'ali nibita na kulola ghoya hanu hamlombela, mbona hanu hakulapfila inambiko handikighwe. Kwe Imulungu ing'ayomanyika. Lelo nene nowapetela mbuli tsake yuyo yamumtambikila bila kummanya. ");
INSERT INTO ruf_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Imulungu iyalumbile isi na pfinu pfose ipfili mumo, ka Imtwatsa wa kulanga na iisi, ng'okala bae mne ng'anda tse Imulungu itsitsengighwe kwa ghamoko ghe iwanu. ");
INSERT INTO ruf_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Wala ng'otumikighwa kwa ghamoko ghe iwanu, ka yeye kobama ichinu chochose, kwaapfila yeye imwenyegho koweng'a iwanu wose ughima na muhe na ipfinu pfose. ");
INSERT INTO ruf_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Kulawa kwe imunu yumwe, katenda ghamataifa ghose ghe iwanu ghakale mne iisi yose. Tsakalamla kulawa ghumwande, tsuwachi na kwani ghamataifa agho ghang'akalile. ");
INSERT INTO ruf_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Imulungu katenda apfo ili iwanu wambame na wamwone hata kwa kubumbulitsa bumbulitsa, hata apfo Imulungu ng'ali kutali bae ne iwanu wose. ");
INSERT INTO ruf_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","‘Kwaapfila kuna yeye twetwe twokala, twoghenda na kuwa na ughima wetu.’ Ka yumwe wenu imtunga wila pfalongile, ‘Twetwe wose twa mweleko wake’ ");
INSERT INTO ruf_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Apfo kwaapfila twetwe twa mweleko ghwe Imulungu, ng'atubamighwa bae kwalangula ka Imulungu keghala na nzahabu au fetsa au libwe, ipfinu ipfisongolighwe ghoya kwe tsimbutsi tse iwanu. ");
INSERT INTO ruf_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ghumwande Imulungu tsakatenda ka ng'akona bae ghamatsuwa ghala iwanu hawakalile wabotsi, lekeni lelo kowalaghitsa iwanu wose chila hanu watsileke nzambi tsawo. ");
INSERT INTO ruf_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Kwaapfila Imulungu keka litsuwa hayatsoihinya iisi kwa haki kwa imunu yula iyamsaghule. Kawatenda iwanu wose wamtoghole kwa kumtsilihula imunu ayo.” ");
INSERT INTO ruf_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Hawamhulike Pauli kolonga imbuli ya ukutsilihuka, wangi wamseka, lekeni wangi walonga, “Twobama tuhulikitse keli imbuli ino.” ");
INSERT INTO ruf_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Baho Pauli kawaleka, koka. ");
INSERT INTO ruf_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Iwanu wangi wamuwinza Pauli na wamtoghola Yesu. Mna wawo tsakakala Diyonesiyo, imunu wa Areopago. Pfipfila kukala ne ipinga yumwe iyakemighwe Damari na iwanu wangi. ");
INSERT INTO ruf_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Kuya Pauli kalawa Asene kaghenda Kolinto. ");
INSERT INTO ruf_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ako ketingana na Myahudi yumwe yakemighwe Akila, yelekighwe Ponto, iyatsile na mwehe wake Pilisila kulawa Italiya matsuwa ghaghala, kwaapfila mndewa Kilaudi tsakawalaghitsa Wayahudi wose walawe Roma. Pauli kaghenda kuwona, ");
INSERT INTO ruf_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","na kwaapfila isang'ano yake tsaikala kutenda pfibumbughitsa ka wawo, kakala nawo na kusang'ana nawo. ");
INSERT INTO ruf_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Chila Litsuwa lya Sabato Pauli tsakakala kolonga na iwanu mne ing'anda ye ukulombela, kaghetsa kuwakwegha Wayahudi na Wagiriki. ");
INSERT INTO ruf_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sila na Timoteo hawatsile kulawa Makedoniya, Pauli katumila chipindi chake chose kuwapetela Wayahudi na kuwalangusa ka Yesu kakala Kiristu Mkombotsi. ");
INSERT INTO ruf_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Lekeni hawambelile Pauli ne ukumligha, kakung'usa maghwanda ghake, kawalongela “Mng'agha, lwenu! Nene nahela litotso mne imbuli ino. Kulawa sambi na kughendelela noghenda kuna iwanu iwali si Wayahudi bae.” ");
INSERT INTO ruf_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Kuya Pauli kalawa mne Ing'anda ye ukulombela, kaghenda mne ing'anda ili habehi, ing'anda ya Tito Yusti, imunu iyomtamanila Imulungu. ");
INSERT INTO ruf_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kirispo imkulu we ing'anda ye ukulombela na iwanu wa ukaye yake wamtoghola Imtwatsa. Na Wakolinto wengi hawahulike, watoghola na kubatitsighwa. ");
INSERT INTO ruf_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Litsuwa limwe nechilo, Imtwatsa kamlongela Pauli mne ghamaono, “Uleke kupfuka, ghendelela kulonga, uleke kwinyamala. ");
INSERT INTO ruf_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Kwaapfila nene na hamwe naghwe, kuduhu imunu iyodaha kukulagha, kwaapfila nina iwanu wengi mne isi ino.” ");
INSERT INTO ruf_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Apfo Pauli kakala ako mwaka ghumwe na miyetsi sita, kowalangulitsa iwanu imbuli ye Imulungu. ");
INSERT INTO ruf_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Galiyo hayang'ali imkulu we isi ya Akaya, Wayahudi wetingana hamwe, wamghogha Pauli, wamghala mne ichitala. ");
INSERT INTO ruf_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Walonga, “Imunu yuno kowatenda iwanu wamtamanile Imulungu bila kughawinza malaghitso gha Musa.” ");
INSERT INTO ruf_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Na Pauli hayabamile kulonga, Galiyo kawalongela Wayahudi, “Ka mng'aghalile lighomba lye imunu kutenda ghehile au kutotsa, ning'adahile kuwahulikitsa. ");
INSERT INTO ruf_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Lekeni kwaapfila lighomba lino lya mchanya mwe mbuli na mataghwa na malaghitso ghenu, mlamle iwenyegho. Nene sibama bae kuwa mlamutsi wa lighomba lino!” ");
INSERT INTO ruf_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Kuya kawawinga walawe mne ichitala. ");
INSERT INTO ruf_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Nawo wose wamghogha Sostene imkulu we ing'anda ya ukulombela, wamtowa hambele he ichitala. Lekeni Galiyo ng'onile bae imbuli ayo ka chinu. ");
INSERT INTO ruf_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pauli kakala Korinto kwa matsuwa mengi. Kuya kawaleka iwanu iwamtoghole Yesu, kadina mnumbwi Pilisila na Akila waghenda Siriya. Ako Kenkeliya, tsakagheta mvili tsake kwaapfila tsakeka laghano. ");
INSERT INTO ruf_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Wapfika Efeso, baho Pauli kawaleka Pilisila na Akila, kengila mne ing'anda ya ukulombela, kalonga na Wayahudi. ");
INSERT INTO ruf_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Iwanu wamlomba wakale naye kwa matsuwa mengi, lekeni Pauli kalema. ");
INSERT INTO ruf_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Lekeni hayang'ali yakuka, kawalongela, “Imulungu ang'abama nakuya keli kuna mwemwe.” Kuya kadina mnumbwi kalawa Efeso. ");
INSERT INTO ruf_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Hapfikile Kaisariya, kaghenda Yerusalemu kwilamsa na iwanu iwamtoghole Yesu, kuya kahulumkila Antiyokiya. ");
INSERT INTO ruf_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Pauli kakala ako kwa matsuwa chidogho, kuya koka kabitila isi ya Galatiya na Firigiya, kuwaghuma ghumoyo iwanang'ina wa Yesu. ");
INSERT INTO ruf_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Mne matsuwa agho Myahudi yumwe iyakemighwe Apolo, iyelekighwe Alekisandiliya, katsa Efeso. Tsakakala imunu yadahile kulonga pfinoghile na yamanyile Ghamaandiko Mahenzeluka. ");
INSERT INTO ruf_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Imunu ayo tsakakala kalangulitsighwa Imbuli ye Imtwatsa, na kwaapfila ghumoyo ghwake tsaghukala ghwakwaka, kalangulitsa mbuli tsa Yesu pfinoghile, hata ka tsakamanya ubatitso wa Yohane uliyeka. ");
INSERT INTO ruf_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Kandusa kulonga bila kupfuka mne ing'anda ya ukulombela. Pilisila na Akila hawamuhulike, wamkema ukaye yawo, wamlongela Imbuli ye Imulungu pfinoghile ghendo. ");
INSERT INTO ruf_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apolo hayabamile kughenda Akaya, iwanu wa Efeso iwamtoghole Yesu wawaghuma ghumoyo na wawandikila ibaluwa iwanu iwamtoghole Yesu wa Akaya wambokele. Naye hayapfikile ako, kawapfila ng'ani awala iwatoghole kwa uluso we Imulungu. ");
INSERT INTO ruf_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Kwaapfila tsakawahuma ghendo Wayahudi hambele he iwanu wose, kalangusa kulawa mne Ghamaandiko Mahenzeluka ka Yesu iyo Kiristu Mkombotsi. ");
INSERT INTO ruf_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolo hayang'ali Kolinto, Pauli kabitila isi itsili mpfidunda, kuya kapfika Efeso. Baho kawapfika iwanu wangi iwomtoghola Yesu, ");
INSERT INTO ruf_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","kawaghutsa, “Angu tsamumbokela Muhe Mwenzeluka hala hamtoghole?” Wamwidika, “Mbe, hata kuhulika ka kuna Ghumuhe Mwenzeluka ng'ana tuhulike bae.” ");
INSERT INTO ruf_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pauli kawaghutsa, “Kuya tsambatitsighwa ubatitso wachi?” Wamwidika, “Ubatitso iyang'ali yobatitsa Yohane.” ");
INSERT INTO ruf_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pauli kalonga, “Ubatitso wang'ali yobatitsa Yohane tsaukala kwa awala iwatoghole kutsileka nzambi tsawo. Naye tsakawalongela iwanu wamtoghole ayula iyakutsa kuchughu kwake, ayo iyo Yesu.” ");
INSERT INTO ruf_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Hawahulike pfino, wabatitsighwa kwa taghwa lya Yesu. ");
INSERT INTO ruf_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pauli hayamalitse kuwekila ghamoko, Ghumuhe Mwenzeluka kawahulumkila, nawo wandusa ukulonga lugha ingi, pfipfila walonga mbuli ye Imtwatsa. ");
INSERT INTO ruf_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Tsawakala iwanu ka kumi na weli. ");
INSERT INTO ruf_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pauli kengila mne ing'anda ye ukulombela, kwa miyetsi midatu kalonga ne iwanu bila kupfuka, tsakaghetsa kuwakwegha watse mne Undewa we Imulungu. ");
INSERT INTO ruf_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Lekeni wamwenga tsawana mimoyo mikomu na ng'awatoghole bae, na wailonga pfihile Imbuli ye Imtwatsa. Apfo Pauli kawaleka, kawasola iwatoghole, kalonga nawo chila litsuwa mne ing'anda ya ukulangulitsila ya imunu yumwe iyakemighwe Tirano. ");
INSERT INTO ruf_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Pfinu pfino pfighendelela kwa miyaka mili, ili iwanu wose iwokala mne kaye tse isi ya Asiya, Wayahudi na iwanu iwali si Wayahudi bae wahulike imbuli ye Imtwatsa. ");
INSERT INTO ruf_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Imulungu tsayang'ali yotenda pfihulo pfikulu kubitila Pauli. ");
INSERT INTO ruf_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Hata pfitambala na maghwanda ghayakindile ghaghalighwa kwe iwatamu, utamu wawo uwalawa, na ipfinyamkela pfiwalawa. ");
INSERT INTO ruf_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Wayahudi wamwenga iwakwangakwanga na kulapfa ipfinyamkela tsawaghetsa kutumila taghwa lya Imtwatsa. Wawalongela ipfinyamkela, “Nomlaghitsani mlawe kwa taghwa lya Yesu, iyopetighwa na Pauli.” ");
INSERT INTO ruf_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Iwatendile apfo, tsawakala iwana saba wa imunu yumwe Myahudi iyakemighwe Sikewa, iyakalile Imtambika mkulu. ");
INSERT INTO ruf_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Lekeni ichinyamkela kawalongela, “Yesu nommanya, Pauli nommanya, lekeni mwemwe tsina nani?” ");
INSERT INTO ruf_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Kuya imunu yane ichinyamkela kawadalukila, kawatowa mbaka watsumila kunze mwe ing'anda wachidako aku wana pfilonda. ");
INSERT INTO ruf_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Imbuli ayo haimanyike na Wayahudi na Wagiriki iwokala ako Efeso, wose tsawapfuka, na taghwa lya Imtwatsa Yesu litunyighwa. ");
INSERT INTO ruf_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Iwanu wengi iwamtoghole Yesu watsa hambele he iwanu, watoghola kuleka kutenda ghehile. ");
INSERT INTO ruf_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Iwanu wamwenga iwang'ali wotenda uhawi wapfighala pfitabu pfawo na kupfilakatsa hambele he iwanu. Pfawapetile bei ye ipfitabu apfo, wona yodahika kupfika elufu hamsini. ");
INSERT INTO ruf_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Apfo imbuli ye Imtwatsa yenela na kuwa ne ingupfu ghendo. ");
INSERT INTO ruf_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Pfinu pfino hapfimalile, Pauli tsakalamla aghende Yerusalemu kwa kubitila Makedoniya na Akaya, kalonga, “Ning'apfika ako, pfipfila nobamighwa ng'ende Roma.” ");
INSERT INTO ruf_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Apfo kawatuma ako Makedoniya iwanu wake weli iwomwapfilagha, Timoteo na Elasto, yeye mwenyegho tsakakala chidogho ako Asiya. ");
INSERT INTO ruf_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ghamatsuwa ghala tsakulawila hengele kulu ako Efeso kwaajili ya mbuli tsa Yesu. ");
INSERT INTO ruf_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Tsahana imunu yumwe taghwa lyake Demetiriyo iyang'ali yotenda ipfinyagho pfa fetsa pfe imulungu Atemi. Isang'ano ayo iwatenda Demetiriyo ne iwanu wake wabwede ghendo. ");
INSERT INTO ruf_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Apfo Demeteriyo kawakema iwanu wake, na iwanu wangi iwosang'ana isang'ano ka yake, kalonga, “Mweye wayangu, mwomanya twopata sendi nyingi kwa isang'ano ino. ");
INSERT INTO ruf_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Mwemwe muwenyegho tsamuhulika na mwona ka si hano Efeso haliyeka bae, ila Asiya yose, Pauli kawakwegha iwanu na kughalusa ghamawatso ghawo, kalonga milungu itendighwe ne iwanu si milungu bae. ");
INSERT INTO ruf_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Apfo isang'ano yetu itsobetsighwa, na si isang'ano yetu iliyeka bae, ila hata ing'anda ye imulungu wetu mamo Atemi nayo itsobetsighwa na mlungu wetu imwenyegho katsobetsighwa, imulungu yotambikighwa mne kaye tsa Asiya na mne isi yose, katsobokighwa utunitso wake!” ");
INSERT INTO ruf_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Hawahulike apfo, wona maya wandusa kukemelela, “Atemi wa Efeso ka Mkulu!” ");
INSERT INTO ruf_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Tsakulawila hengele mne isi yose. Iwanu wawaghogha Gayo ne Aristariko, iwanu iwelongotse na Pauli kulawa Makedoniya, watsuma nawo mbaka hane chibugha che midawalo. ");
INSERT INTO ruf_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pauli imwenyegho tsakabama aghende hambele he iwanu, lekeni iwanang'ina wake wamghoma. ");
INSERT INTO ruf_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Hata iwakulu wangi we Asiya, sale tsake Pauli, wamtumila imunu wamlomba aleke kughenda hane chibugha che imidawalo. ");
INSERT INTO ruf_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Imtingano ukala uhinyika, iwanu wamwenga wang'ali wolonga achi na wamwenga wolonga chila, kwaapfila iwanu wengi ng'awamanyile tsawetinganile choni. ");
INSERT INTO ruf_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Wayahudi wangi wamghala Alekisanda hambele he iwanu, na iwanu wangi wamkemelela. Naye kawapungila ghumoko iwanu wanyamale, ili yeyamile kwe iwanu. ");
INSERT INTO ruf_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Lekeni hawamanyile yeye ka Myahudi, wose wakemelela hamwe kwa masaa meli, “Atemi wa Efeso ka mkulu!” ");
INSERT INTO ruf_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Na kalani wa isi hayamalitse kuwalongela iwanu wanyamale, kalonga, “Mwemwe iwanu wa Efeso, angu yuhi ng'amanyile bae ka isi ya Efeso iyo mkalitsi wa ing'anda ye imulungu mkulu Atemi na mkalitsi wa chinyagho chake ichilaghale kulawa kulanga? ");
INSERT INTO ruf_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Kwaapfila kuduhu imunu yodaha kubela agho, apfo mnyamale na mleke kutenda chinu chochose himahima. ");
INSERT INTO ruf_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Muwaghala hano iwanu wano, nawo ng'awebile ipfinu pfe ing'anda ye imulungu wala ng'awamlighile bae mlungu wetu. ");
INSERT INTO ruf_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Apfo, ka Demetiriyo na weyaghe wana lighomba na imunu wowose, ghamabalatsa na iwalamutsi wabaho. Wodaha kughala ako lighomba alyo. ");
INSERT INTO ruf_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Lekeni ka mna ghomba lingi, mwobamighwa mlighale kune libalatsa ilibamighwa. ");
INSERT INTO ruf_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Kwaapfila tung'aghalighwa mne libalatsa kwaajili ya hengele lya leloli, ng'atudaha kwiyamila bae kwaapfila hengele lino lyahela mana.” ");
INSERT INTO ruf_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Hayamalitse ukulonga apfi, kawalongela iwanu woke. ");
INSERT INTO ruf_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Hengele lila lya Efeso halimalile Pauli kawakema iwomtoghola Yesu, kawaghuma ghumoyo, kawaagha kuya kaghenda Makedoniya. ");
INSERT INTO ruf_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Hayang'ali yobita kaye tsila, kawaghuma ghumoyo iwanu, kuya kapfika Ugiriki, ");
INSERT INTO ruf_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","kakala ako kwa miyetsi midatu. ");
INSERT INTO ruf_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Tsaang'ali yelongotsa na Sopato imwana we Pilo iyolawila Bereya, Aristariko na Sekundo iwanu wa Tesalonike, Gayo imunu wa Deribe, Timoteo, Tukiko na Tirofimo iwolawa Asiya. ");
INSERT INTO ruf_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Iwanu awo tsawalongola na watubeta ako Tirowa. ");
INSERT INTO ruf_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ichihungo che Pfighate ipfilihela hamila hachimalile, tudina mnumbwi kulawa Filipi, na ghamatsuwa matano hambele tutingana nawo ako Tirowa, tukala ako kwa ghamatsuwa saba. ");
INSERT INTO ruf_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Mne litsuwa lya mwanduso lya juma, tsatutingana hamwe na ukuja chijo. Pauli tsakalonga ne iwanu, na kwaapfila kabama yoke litsuwa lya keli kaghendelela kulonga nawo mbaka nechilo ng'ani. ");
INSERT INTO ruf_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Tsahana ipfitasa pfingi ipfing'ali pfakwaka mne ichiheleto ichili kuchanya, hanu hatwitinganile. ");
INSERT INTO ruf_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Msongolo yumwe yakemighwe Yutiko tsakala hane lidilisha. Pauli hayang'ali yoghendelela kulonga, Yutiko ang'ali yodongila, kadongila mbaka kalaghala, kulawa mne igholofa ya kadatu mbaka hasi. Hawaghendile kumwinula wampfika ma kafa. ");
INSERT INTO ruf_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Lekeni Pauli kahulumka hasi, kamwinamila, kamkumbatila msongolo ayo. Kalonga, “Mleke kupfuka, kamghima!” ");
INSERT INTO ruf_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Kuya kadina keli mchanya, kasola chijo kaja, kaghendelela kulonga nawo mbaka habehi na kucha, kuya koka. ");
INSERT INTO ruf_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Iwanu wamghala imsongolo yula ukaye kamghima, nawo waghumighwa ghumoyo. ");
INSERT INTO ruf_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Twetwe tudina imeli tulongola kughenda Aso ili twitingane na Pauli. Tsakatulongela tutende apfo, kwaapfila yeye ang'ali yoghenda ako kwa mghulu. ");
INSERT INTO ruf_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Hatupfikile Aso, Pauli kengila mne ghumnumbwi, tughenda naye Mitileni. ");
INSERT INTO ruf_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Litsuwa lya keli twandusa ghumwanza kulawa ako kuya tupfika Kiyo. Litsuwa lya kadatu tupfika Samo, na litsuwa lya kane tupfika Mileto. ");
INSERT INTO ruf_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pauli kalamla aghendelele na ghumwanza bila kubitila Efeso ili aleke kukawa mne isi ya Asiya. Tsakabama yasumke kupfika Yerusalemu kwaajili ya ichihungo cha Pentekoste ka ing'adahike. ");
INSERT INTO ruf_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Kulawa Mileto, Pauli kawatuma iwanu waghende Efeso kuwakema iwabala we iwanu iwomtoghola Kiristu wetingane naye. ");
INSERT INTO ruf_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Hawatsile, kawalongela, “Mwemwe mwomanya pfanikalile ghamatsuwa ghose, hanikalile namwe kulawa litsuwa lya mwanduso lyanitsile mne isi ya Asiya. ");
INSERT INTO ruf_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Tsanimsang'anila Imtwatsa bila kwighoda na kwa masotsi, hata ka tsanigetsighwa ng'ani na aghala ghehile ghawanendele Wayahudi. ");
INSERT INTO ruf_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Mwomanya silekile bae kuwalongela chila ichinu ichidaha kumwapfilani mwemwe, ila niwalangulitsa hambele he iwanu na kulawa ing'anda mbaka ing'anda. ");
INSERT INTO ruf_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Niwalongela wose Wayahudi na iwanu iwali si Wayahudi wamuyile Imulungu na wamtoghole Imtwatsa wetu Yesu. ");
INSERT INTO ruf_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Na lelo, kwaapfila nimuhulika Ghumuhe Mwenzeluka, noghenda Yerusalemu aku simanyile bae choni chitsonilawila ako. ");
INSERT INTO ruf_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Chinu chimwe chanimanya, Ghumuhe Mwenzeluka konongela ka mna chila ghumji, ukwohighwa na ukughaya pfonibeta. ");
INSERT INTO ruf_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Lekeni siwona bae ughima wangu ka chinu chikulu, ila chanibama kumalitsa isang'ano yangaile Imtwatsa Yesu, isang'ano ye ukupeta Imbuli Inoghile ya uluso we Imulungu. ");
INSERT INTO ruf_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Nibita mna mwemwe wose kuwapetela Undewa we Imulungu, lekeni sambi nomanya ka kuduhu imunu mna mwemwe iyatsombona keli. ");
INSERT INTO ruf_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Apfo leloli nowalongela ghendo, imunu wowose mna mwemwe ang'agha, alwo lwenu, nene nahela totso. ");
INSERT INTO ruf_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Kwaapfila silekile bae kuwalongela ghose ghayobama Imulungu. ");
INSERT INTO ruf_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Mwalangitse iwenyegho, na muwalolese iwanu wose awala Ghumuhe Mwenzeluka iyamwikeni muwalongotse, muwadime awala iwomtoghola Imulungu iyawaghulile kwa idamu yake imwenyegho. ");
INSERT INTO ruf_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Nomanya nene hanikuka, wambwa wakali wa kumuhulo watsowatsilani na ng'awatsowonelani libatsi bae. ");
INSERT INTO ruf_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Hata mna mwemwe muwenyegho watsolawila iwanu iwolonga ughutsu ili wawakweghe kuna wawo awala iwomtoghola Yesu. ");
INSERT INTO ruf_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Apfo mwalangitse! Mkumbuke, kwa miyaka midatu chilo na misi, silekile bae kumlangulitsa chila imunu iyali kuna mwemwe kwa masotsi. ");
INSERT INTO ruf_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Lelo nomwikani mne ghamoko ghe Imulungu na mne imbuli ya uluso wake iudaha kuwatsenga na kuwatenda muhale hamwe na iwanu wake. ");
INSERT INTO ruf_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Sibamile bae nzahabu au fetsa au lighwanda lya imunu wowose. ");
INSERT INTO ruf_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Mwemwe muwenyegho mwomanya ka tsanisang'ana kwa ghamoko ghangu ili kupata aghala ghanibamile na aghala ghawabamile weyangu. ");
INSERT INTO ruf_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Mne chila chinu chanendile, tsaniwalangusa ka kwa kusang'ana ka pfino, twobamighwa kuwapfila iwanu walihela ingupfu, mkumbuke chayalongile Imtwatsa Yesu imwenyegho, ‘Kabweda ayula iyoghola kubita ayula iyobokela.’ ” ");
INSERT INTO ruf_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Hayamalitse kulonga agho, katowa ghamaghoti hamwe nawo, kamlomba Imulungu. ");
INSERT INTO ruf_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Wose walila hawang'ali womuagha Pauli kuno wamkumbatila na wamnonela. ");
INSERT INTO ruf_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Tsawona usungu ng'ani kwaapfila kawalongela ng'awatsomwona keli bae. Kuya waghenda naye mbaka kune imeli. ");
INSERT INTO ruf_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Tsatuwaagha, kuya tudina imeli tughenda mbaka Kosi. Litsuwa liwinzile tupfika Rode, na kulawa ako tupfika Patara. ");
INSERT INTO ruf_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ako tuipfika imeli iighenda Foinike, apfo tudina, tuka. ");
INSERT INTO ruf_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Na hatuyonile Kupulo, tubita lubali lwake lwe kuisi, tughenda mbaka Siriya. Tuhulumkila Tiro kwaapfila ako mnumbwi wetu ghung'ali ghwohulumsa imitsigho. ");
INSERT INTO ruf_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ako tuwapfika iwanu iwamtoghole Yesu, tukala nawo ghamatsuwa saba. Kwa ingupfu ya Ghumuhe Mwenzeluka wamghoma Pauli aleke kughenda Yerusalemu. ");
INSERT INTO ruf_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Lekeni ghamatsuwa ghetu haghamalile, tughendelela na ghumwanza ghwetu. Iwanu wose iwamtoghole Yesu na wehe tsawo ne iwana wawo watuhilika mbaka kunze kwe ghumji, na baho tutowa maghoti, tulomba. ");
INSERT INTO ruf_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Hatumalitse kuwaagha, tudina imeli, nawo woya mmakaye mwawo. ");
INSERT INTO ruf_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tughendelela na ghumwanza kulawa Tiro, tupfika Tolemayi, baho tuwalamsa iwanu iwamtoghole Yesu na kukala nawo kwa litsuwa limwe. ");
INSERT INTO ruf_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Nemitondo tuka, tupfika Kaisariya. Ako tsatukala mne ing'anda ya Filipi, mpetela wanu imbuli inoghile, iyakalile yumwe wa awala saba iwasaghulighwe Yerusalemu. ");
INSERT INTO ruf_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Imunu yuno tsakakala ne iwanaghe wapinga wane, awo ng'ana wakwelighwe bae, wang'ali wolonga usenga we Imulungu. ");
INSERT INTO ruf_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Hatukalile baho kwa ghamatsuwa mengi, nabii yumwe we Imulungu iyakemighwe Agabo katsa kulawa Yudeya. ");
INSERT INTO ruf_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Katutsila, kasola ghumsipi ghwa Pauli, keyoha ghamoko na ghamaghulu ghake imwenyegho, kalonga, “Ghumuhe Mwenzeluka kolonga, Wayahudi wa Yerusalemu watsomwoha apfino imunu yane ghumsipi ghuno na watsomwika mne ghamoko ghe awanu iwali si Wayahudi bae.” ");
INSERT INTO ruf_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Hatuhulike apfi, twetwe na iwanu iwakalile hala tumlomba Pauli aleke kughenda Yerusalemu. ");
INSERT INTO ruf_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Lekeni Pauli kedika, “Ebali mwolila na mwoghutenda ghumoyo ghwangu ghutenyuke? Nene niyandaa si kwohighwa kuliyeka bae, ila hata ukufila Yerusalemu kwaajili ya taghwa lya Imtwatsa Yesu.” ");
INSERT INTO ruf_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Halemile kututegheletsa, tumleka, tulonga, “Ghayobama Imulungu ghatendeke.” ");
INSERT INTO ruf_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Hatumalitse kukala hala, twoha pfinu pfetu tugheluka tughenda Yerusalemu. ");
INSERT INTO ruf_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Iwanu wangi iwomtoghola Yesu kulawa Kaisariya welongotsa na twetwe, watughala tukakale ukaye kwa Mnasoni. Yeye tsakakala imunu wa Kupulo, naye yang'ali yomtoghola Yesu kwa ghamatsuwa mengi. ");
INSERT INTO ruf_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Hatupfikile Yerusalemu, iwanu iwamtoghole Yesu watubokela kwa kudeng'elela. ");
INSERT INTO ruf_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Litsuwa liwinzile Pauli na twetwe tsatughenda kumwona Jakobu, na iwabala wose we iwanu iwomtoghola Kiristu tsawabaho. ");
INSERT INTO ruf_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pauli kawalamsa na kuwalongela ghose ghayatendile Imulungu kubitila isang'ano yake kwe iwanu iwali si Wayahudi. ");
INSERT INTO ruf_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Hawahulike apfi, wamtunya Imulungu. Kuya wamlongela Pauli, “Ndughu yetu, kwakona Wayahudi iwatoghole pfawali wengi ng'ani, nawo wose wosulukila ng'ani kutenda malaghitso gha Musa. ");
INSERT INTO ruf_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Tsawalongelighwa ka ghweghwe kowalangulitsa Wayahudi wose iwokala mghati mwa iwanu iwali si Wayahudi waghaleke malaghitso gha Musa, tsakuwalongela waleke kuwengitsa ngoma iwana wawo wala kuchiwinza ichihendo chetu. ");
INSERT INTO ruf_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Lelo tutendetse? Kwaapfila watsohulika ka ghweghwe kwa baha, ");
INSERT INTO ruf_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","apfo tenda achi chatukulongela. Ahano hana iwanu wane iwekile laghano. ");
INSERT INTO ruf_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Uwasole iwanu wano, wideghetese nawo, uwalihile sendi, ili waghetighwe mvili tsawo. Kuya chila imunu katsomanya ka mbuli tsako tsawahulike ng'atsilongesa bae, ila ghweghwe imwenyegho koghawinza ghamalaghitso gha Musa. ");
INSERT INTO ruf_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ka pfatuwaandikile iwanu iwali si Wayahudi iwamtoghole Yesu, wobamighwa waleke ukuja ipfijo ipfitambikighwe kwa ipfinyagho, waleke ukuja idamu, waleke ukuja imnyama iyabotighwe na waleke utsinzi.” ");
INSERT INTO ruf_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Litsuwa liwinzile Pauli kawasola iwanu awo na kwideghetesa nawo. Kuya kengila mne Ing'anda ye Imulungu kuwalongela litsuwa lye ukumalitsa ukwideghesa na litsuwa lye kulapfa nambiko kwaajili ya chila yumwe mna wawo. ");
INSERT INTO ruf_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Ghamatsuwa ghala saba haghakalile habehi kumala, Wayahudi iwalawile Asiya wamwona Pauli mne Ing'anda ye Imulungu. Wawasongetsa iwanu wose wamuhile Pauli, wamghogha, ");
INSERT INTO ruf_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","wakemela, “Amweye wamale wa Isiraeli, mtwapfile! Hayuno iyo imunu iyakwanga chila hanu, na kuwalangulitsa iwanu wose waleke kuwawinza Waisiraeli na ghamalaghitso gha Musa na hanu hano hanoghile. Kuya kawaghala iwanu iwali si Wayahudi mne Ing'anda ye Imulungu, na kuhahinya hanu hano hahenzeluke.” ");
INSERT INTO ruf_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Wamwenga tsawapfikitsa Pauli kamghala Tirofimo imunu wa Efeso mne Ing'anda ye Imulungu, kwaapfila tsawamwona naye mkaye. ");
INSERT INTO ruf_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Ghumji ghose ghukala na hengele, na iwanu wang'ali wotsuma kulawa chila hanu. Wamghogha Pauli, wamkwegha kulawa mne Ing'anda ye Imulungu, na bahala imibani ye Ing'anda ye Imulungu ihindighwa. ");
INSERT INTO ruf_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Na hawang'ali wobama inzila ye ukumkoma Pauli, imbuli impfikila imkulu we asikali wa Roma ka ghumji ghose ghwa Yerusalemu ghukala na hengele. ");
INSERT INTO ruf_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Bahala imkulu hayo kawasola iwakulu wangi hamwe na asikali katsuma kuhulumkila mne kingili. Nawo hawamwonile imkulu ayo ne asikali wake, waleka kumtowa Pauli. ");
INSERT INTO ruf_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Imkulu ayo kamghendela Pauli, kamghogha, kalaghitsa yohighwe minyororo mili. Kuya kaghutsa, “Angu ayuno imunu wachi? Kuya atendile choni?” ");
INSERT INTO ruf_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Iwanu wangi mne mtingano agho walonga pfino na wamwenga walonga apfino, imkulu hayo ng'adahile kuhulika ghoya kwaapfila tsahana tsogho, apfo kalaghitsa Pauli yaghalighwe mne liboma. ");
INSERT INTO ruf_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Pauli hayapfikile mna ingatsi, asikali wamsola kwaapfila iwanu wang'ali wotenda hengele ng'ani. ");
INSERT INTO ruf_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Likingili limuwinza na iwanu waghendelela kukemelela, “Mkomeni ayo!” ");
INSERT INTO ruf_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Pauli hayang'ali yoghalighwa mng'anda, kamlomba imkulu we asikali, “Uleke tanu nikulongele ichinu.” Naye kamghutsa, “Kumbe kodaha kulonga Chigiriki!” ");
INSERT INTO ruf_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","“Pfii ghweghwe si yula Mmisiri yandusile uasi ghamatsuwa ghabitile na kuwalongotsa kunyika iwanu wala wehile elufu nne?” ");
INSERT INTO ruf_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pauli kedika, “Bae, nene na Myahudi wa Taso, ako Kilikiya, isi imanyika ng'ani. Nolomba undeke nonge ne iwanu wano.” ");
INSERT INTO ruf_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Imbala ayo hayamlekile alonge, Pauli kema mngatsi, kawapungila ghumoko iwanu wanyamale. Kuya wose hawanyamale, Pauli kalonga nawo kwa Chihebraniya. ");
INSERT INTO ruf_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Ndughu tsangu na aba tsangu, mnihulikitse ghoya pfaniyamila hambele henu.” ");
INSERT INTO ruf_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Hawahulike kolonga nawo Chihebraniya, wenyamala tulu, naye Pauli kaghendelela kulonga, ");
INSERT INTO ruf_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Nene na Myahudi, nyelekighwa Taso, isi ya Kilikiya, lekeni nikulila mne ghumji ghuno. Tsanikala imwanang'ina wa Gamalieli, tsanilangulitsighwa kughakinda ghamalaghitso ghe iwabala wetu. Na ng'ala nosulukila kumuhulikitsa Imulungu ka mwemwe mwose pfamli leloli. ");
INSERT INTO ruf_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Tsaniwadununza iwanu iwoiwinza inzila ino mbaka kuwakoma, tsaniwaghogha wose iwamale ne iwapinga na kuwasa mwigheletsa. ");
INSERT INTO ruf_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Imtambika mkulu ne libalatsa lyose lyodaha kulapfa ukalangama. Wawo iwo iwangaile ibaluwa niighale kwa Wayahudi wa Damasko, ili niwaghoghe iwanu awo ako Damasko niwaghale Yerusalemu wahighighwe. ");
INSERT INTO ruf_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Nemisi haning'ali mnzila, hamvikile habehi na Damasko, bahala lumwesa lukulu kulawa kulanga lunimwemwesela chila hanu. ");
INSERT INTO ruf_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Nyighwa hasi, kuya nihulika litsi lyonilongela, ‘Sauli, Sauli! Ebali konidununza?’ ");
INSERT INTO ruf_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Nimghutsa, ‘Imtwatsa ghweghwe uli nani?’ Kanongela, ‘Nene na Yesu wa Natsareti, yunidununza.’ ");
INSERT INTO ruf_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Wayangu wawona lumwesa, lekeni ng'awahulike bae litsi lya ayula iyalongile na nene. ");
INSERT INTO ruf_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Nimghutsa, ‘Imtwatsa lelo nendetse?’ Imtwatsa kanongela. ‘Winuke ughende Damasko, ako kutsolongelighwa ghose ghaubamighwa kutenda.’ ");
INSERT INTO ruf_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Weyangu wang'inda ghumoko, wanongotsa mbaka Damasko, kwaapfila sidahile bae ukwona kwaajili ya ukulu wa lumwesa lula. ");
INSERT INTO ruf_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Imunu yumwe yakemighwe Ananiya tsakatsa kumbona, imunu ayo tsakakala kompfuka Imulungu na koghakinda ghamalaghitso gha Musa na kotegheletsighwa na Wayahudi wose iwokala ako. ");
INSERT INTO ruf_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Kema habehi yangu, kalonga, ‘Ndughu yangu Sauli, wone keli!’ Na bahala nidaha kumwona. ");
INSERT INTO ruf_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Kuya Ananiya kalonga, ‘Imulungu we iwabala wetu kakusaghula ghweghwe umanye chayobama na umwone ayula Mwenzeluka wake na uhulike litsi lyake. ");
INSERT INTO ruf_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Kwaapfila ghweghwe kutsakuwa mkalangama wake kwa kuwalongela iwanu wose aghala ghawonile na ghauhulike. ");
INSERT INTO ruf_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Lelo ubeta choni? Winuke, ubatitsighwe, uleghusighwe nzambi tsako kwa kulitoghola taghwa lyake.’ ");
INSERT INTO ruf_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Hambuyile Yerusalemu na haning'ali nilomba mne Ing'anda ye Imulungu, ng'ala ka nitsilika. ");
INSERT INTO ruf_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Nimwona Imtwatsa konongela, ‘Sambi baha ulawe Yerusalemu! Kwaapfila ng'awatsotoghola ukalangama wako mne mbuli tsangu.’ ");
INSERT INTO ruf_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Nimwidika, “Imtwatsa, iwanu womanya ka nene tsang'enda mne tsing'anda tse Imulungu kuwaghogha na kuwatowa iwanu wose iwakutoghole. ");
INSERT INTO ruf_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Na imkalangama wako Stefani hayakomighwe, nene tsanabaho, nitoghola kukomighwa kwake, na tsang'ala noghalolesa maghwanda ghe awala iwamkomile. ");
INSERT INTO ruf_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Kuya Imtwatsa kanongela, ‘Ghenda, nokutuma kutali kwe iwanu iwali si Wayahudi.’ ” ");
INSERT INTO ruf_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Iwanu wamtegheletsa Pauli mbaka hayalongile apfi. Kuya wandusa kukemelela, “Mkomeni hayo! Munu ka ayo ng'obamighwa bae kukala muisi!” ");
INSERT INTO ruf_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Hawang'ali wokemelela na ukwasa ghamaghwanda ghawo na ukupwililisa litimbwisi uchanya, ");
INSERT INTO ruf_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","imkulu we asikali kalaghitsa Pauli yaghalighwe mne liboma, kuya kalaghitsa wamghutse kwa kumtowa pfiboko, ili amanye ule iwanu womkemelela pfila. ");
INSERT INTO ruf_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Lekeni hawang'ali womwoha wamtowe, Pauli kamlongela imkulu yumwe we asikali yemile habehi, “Apfi pfinogha mwemwe kumpfapula Mroma ng'ana yahighighwe bae?” ");
INSERT INTO ruf_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Imkulu ayo hahulike apfi, kaghenda kumlongela imkulu we asikali imbuli ayo, kalonga “Angu ubama kutenda choni? Imunu ayu Mroma.” ");
INSERT INTO ruf_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Apfo imkulu we asikali kamghendela Pauli, kamghutsa, “Nongele, ghweghwe kwa Mroma?” Pauli kamwidika, “Ona.” ");
INSERT INTO ruf_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Imkulu ayo kalonga, “Tsaniliha sendi nyingi ili niwe Mroma.” Pauli kamwidika, “Nene na mwenye kaye wa Roma kwa kwelekighwa.” ");
INSERT INTO ruf_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Bahala awala iwabamile kumghutsa Pauli wandusa kuka. Na imkulu we asikali hayamanyile Pauli tsakakala Mroma kapfuka, kwaapfila tsakamwoha. ");
INSERT INTO ruf_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Litsuwa lya keli, imkulu we asikali tsakabama amanye ghendo ule Wayahudi wamwing'a lighomba Pauli, kampfughula na kawalaghitsa iwakulu we inambiko na libaratsa lyose wetingane. Kuya kamghala Pauli, kamwika hambele hawo. ");
INSERT INTO ruf_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pauli kawatsodelela tsinenge iwanu wa libaratsa, kuya kalonga, “Ndughu tsangu, tsanimtumikila Imulungu kwa ghumoyo ghunoghile mbaka leloli.” ");
INSERT INTO ruf_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Imtambika mkulu Ananiya kawalaghitsa awala iwakalile habehi na Pauli wamtowe mlomo wake. ");
INSERT INTO ruf_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Kuya Pauli kamlongela, “Imulungu katsokutowa ghweghwe mng'enye. Ghweghwe kwa hano kunihigha kwa ghamalaghitso, lekeni ghweghwe imwenyegho koghahinya ghamalaghitso kwa kuwalongela iwanu wanitowe!” ");
INSERT INTO ruf_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Awala iwemile habehi na Pauli walonga, “Ghweghwe, komligha mtambika mkulu we Imulungu!” ");
INSERT INTO ruf_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pauli kedika, “Ndughu tsangu, simanyile bae ka yeye ka mtambika mkulu, kwaapfila yandikighwa, ‘uleke kumlonga pfihile imtawala we iwanu wako.’ ” ");
INSERT INTO ruf_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Kuya Pauli hayamanyile ka iwanu iwakalile hala, wamwenga tsawakala Masadukayo na wangi tsawakala Mafarisayo, kakemelela mne libaratsa lila, “Ndughu tsangu, nene na Mfarisayo, mwana wa Mfarisayo. Nene nohighighwa kwaapfila notoghola ka iwanu iwafile watsotsilihuka!” ");
INSERT INTO ruf_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Baha hayalongile apfo, Masadukayo na Mafarisayo wandusa kwisonga, baho mtingano ghwighola. ");
INSERT INTO ruf_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Kwaapfila Masadukayo wolonga kuduhu ukutsilihuka kwe iwanu, kuduhu wamalaika wala muhe, ila Mafarisayo wotoghola ghose agho. ");
INSERT INTO ruf_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Tsakulawila hengele kulu, na iwalangulitsi wa ghamalaghitso iwakalile Mafarisayo wema, walonga kwa ingupfu, “Ng'atukona bae ichinu chochose ichihile kwa imunu ayu. Lamda malaika we Imulungu au muhe kalonga naye.” ");
INSERT INTO ruf_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Hengele tsalikala kulu ng'ani, na ayula imkulu we asikali kapfuka iwanu wang'amghanile Pauli pfihindipfihindi. Apfo kalaghitsa iwanwele wahulumke, wamsole kwa ingupfu kulawa mne ghamoko ghawo, kuya wamghale mne liboma. ");
INSERT INTO ruf_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Chilo chila Imtwatsa tsakema habehi na Pauli, kamlongela, “Uleke kupfuka! Ka pfauwalongele mbuli tsangu iwanu wa hano Yerusalemu, pfipfila kobamighwa uwalongele iwanu Roma.” ");
INSERT INTO ruf_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Nemitondo yake Wayahudi watingana, welaghana waleke ukuja wala ukunwa ichinu chochose mbaka hawatsomkoma Pauli. ");
INSERT INTO ruf_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Na iwanu iwatendile apfo tsawakala wabita iwanu alubaini. ");
INSERT INTO ruf_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Kuya waghenda kwe iwatambika wakulu ne iwabala, wawalongela, “Twilaha kuleka ukuja na ukunwa mbaka hatutsomkoma Pauli. ");
INSERT INTO ruf_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Lelo mwemwe ne iwabala wa libaratsa mumlombe imkulu we asikali amghale Pauli kuna mwemwe, mtende ka mwobama kumanya pfinoghile mbuli tsake. Na twetwe twombeta mnzila tumkome ng'ana yapfike hano.” ");
INSERT INTO ruf_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Lekeni mwighwaghe Pauli tsakahulika imbuli ayo, apfo kaghenda mne liboma, kamlongela Pauli mbuli ayo. ");
INSERT INTO ruf_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Kuya Pauli kamkema mkulu yumwe we asikali kamlongela, “Umghale imsongolo yuno kwa imkulu we asikali, kana chinu kobama yamlongele.” ");
INSERT INTO ruf_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Imkulu ayo kamsola imsongolo yula kamghala kwa imkulu we asikali, kamlongela, “Pauli, ayula mwohighwa tsakang'ema, kanilomba nikughalile imsongolo yuno kwaapfila kana chinu kobama yakulongele.” ");
INSERT INTO ruf_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Imkulu we asikali kamkinda ghumoko imsongolo yula, kaghenda naye hambalimbali, kamghutsa, “Kobama unongele choni?” ");
INSERT INTO ruf_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Kamwidika, “Wayahudi wobama wakulombe ilupfi umghale Pauli kuna libaratsa, wotenda ka wobama wamanye pfinoghile mbuli tsake. ");
INSERT INTO ruf_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Lekeni uleke kutoghola kwaapfila Wayahudi kubita wanu alubaini wombeta. Tsawelaha waleke ukuja wala ukunwa mbaka wamkome. Sambi wobeta, wololesa pfautsolamla.” ");
INSERT INTO ruf_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Imkulu ayo kamlongela imsongolo ayo, “Uleke kumlongela imunu wowose ka kunongela imbuli ino.” Kuya kamleka yoke. ");
INSERT INTO ruf_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Kuya kawakema iwakulu weli we asikali, kawalaghitsa, “Muwandae asikali miya mbili na iwadina farasi sabini na asikali iwokinda imighoha miya mbili, waghende Kaisariya saa tatu nechilo. ");
INSERT INTO ruf_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Mumwikile Pauli iwafalasi, mumghale tseghamba kwa Felikisi imtawala wa Chiroma mne isi ya Yudeya.” ");
INSERT INTO ruf_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Kuya kandika pfino ibaluwa, ");
INSERT INTO ruf_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Mbukwa ghwe imbala Felikisi. Nene Kilaudi Lisiya nokwandikila ghweghwe mtawala, ");
INSERT INTO ruf_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","“Imunu yuno tsakaghoghighwa na Wayahudi na wabama wamkome, lekeni tsang'enda ne asikali kumkombola, kwaapfila tsanihulika yeye ka Mroma. ");
INSERT INTO ruf_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Tsanibama nimanye womwing'a lighomba lyachi, apfo nimghala mne libaratsa lyawo. ");
INSERT INTO ruf_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Tsambona wamwing'a lighomba kwaajili ya ghamalaghitso ghawo, lekeni tsakukala kuduhu totso ilimtenda yakomighwe au yohighwe. ");
INSERT INTO ruf_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Kuya hanongelighwe Wayahudi wobama inzila ye kumkoma imunu yuno, bahala nimghala kuna ghweghwe. Pfipfila niwalaghitsa iwamwing'ile lighomba walonge mbuli tsake kuna ghweghwe.” ");
INSERT INTO ruf_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Apfo asikali wamsola Pauli ka pfawalaghitsighwe. Ichilo chichila wamghala Pauli mbaka Antipatiri. ");
INSERT INTO ruf_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Litsuwa liwinzile wawaleka awala iwadina farasi waghende naye, na asikali iwoghenda kwa imighulu woya mne liboma. ");
INSERT INTO ruf_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Iwadina farasi hawapfikile Kaisariya, wamwing'a ibaluwa ila imkulu ayo we isi, kuya wamwika Pauli hambele hake. ");
INSERT INTO ruf_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Hayamalitse kuisoma, kawaghutsa imunu yuno kalawila isi yachi? Hawamlongele kolawa Kilikiya, ");
INSERT INTO ruf_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","kalonga, “Nitsokutegheletsa baho iwakwing'ile lighomba hawatsokutsa hano.” Kuya kalaghitsa Pauli alolesighwe mne ing'anda ye undewa ya Herodi. ");
INSERT INTO ruf_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Ghamatsuwa matano hambele, Imtambika mkulu Ananiya kahulumka Kaisariya hamwe ne iwabala ne imunu yumwe we ghamalaghitso yakemighwe Tetulo. Wamlongela imkulu ayo mbuli tsa Pauli. ");
INSERT INTO ruf_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Pauli hakemighwe, Tetulo kandusa kulonga hambele he Feliksi. “Ghwe mbala, tsatudeng'elela kukala tseghamba kwa ghamatsuwa mengi mne utawala wako, na ipfinu pfingi ipfibamighwa pfitendighwa kwaajili ye isi yetu. ");
INSERT INTO ruf_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Agho ghose twoghabokela na kukutoghola chila hanu ghamatsuwa ghose. ");
INSERT INTO ruf_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Sibama bae kukutenda wipfe, lekeni nolomba utududumile na ututegheletse chidogho. ");
INSERT INTO ruf_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Tumwona imunu yuno ka mghobo, kandusa hengele mghati mwa Wayahudi wose muisi mwose. Naye ka chilongotsi wa Wanatsareti. ");
INSERT INTO ruf_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Yeye pfipfila tsakabama aihinye Ing'anda ye Imulungu, apfo tumghogha na tubama tumuhighe kwa ghamalaghitso ghetu. ");
INSERT INTO ruf_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Lekeni Lisiya, imkulu we iwang'ewele katsa, kumsola kwe ingupfu, kuya kawalaghitsa awala iwamwing'ile lighomba watse kuna ghweghwe. ");
INSERT INTO ruf_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Naghwe ung'amghutsa imunu yuno, kwodaha kughamanya ghose ighatutendile tumwing'e ghamaghomba.” ");
INSERT INTO ruf_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Wayahudi nawo waghatoghola ghamaghomba agho, walonga apfo pfipfo pfaili. ");
INSERT INTO ruf_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Imkulu we ghumkoa kamgholosela chidole Pauli ili alonge, Pauli kalonga, “Kwaapfila nomanya ghweghwe kwa imlamutsi we isi ino kwa imiyaka pilikichi, lelo neyamila kwa kudeng'elela. ");
INSERT INTO ruf_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Kodaha kumanya imwenyegho, ng'aghabitile bae ghamatsuwa kumi na meli kulawa hanighendile Yerusalemu kutamanila. ");
INSERT INTO ruf_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Iwanu wano ng'awambonile mne Ing'anda ye Imulungu nesonga ne imunu wowose, wala ukutenda hengele mne tsing'anda tse kulombela au hanu hohose mne ghumji. ");
INSERT INTO ruf_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Nawo ng'awodaha bae kukulangusa maghomba ghawo kuna nene ka gholongesa. ");
INSERT INTO ruf_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Bali nene notoghola ka nomtamanila Imulungu wa aba tsetu kwa nzila ila yawoikema wawo nzila ye ughutsu. Notoghola ghose ighandikighwe mne ipfitabu pfe ghamalaghitso na pfe manabii we Imulungu, ");
INSERT INTO ruf_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","na nene nomlolela Imulungu ka wawo pfawomlolela, ka kuna ukutsilihuka kwe iwanu iwafile, wose iwanoghile ne iwehile. ");
INSERT INTO ruf_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Apfo ghamatsuwa ghose nekatsa niwe na ghumoyo ghunoghile kwe Imulungu na kwe iwanu. ");
INSERT INTO ruf_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Tsanikala kutali kwa imiyaka mingi, lelo mbuya Yerusalemu kuwaghalila nzawadi iwahingwa we isi yangu na kulapfa nambiko. ");
INSERT INTO ruf_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Tsawambona mne Ing'anda ye Imulungu haning'ali notenda pfinu apfo, tsawanipfika nimalitsa ukudeghetetsighwa. Tsakukala haduhu iwanu wengi hamwe na nene, kuya tsahaduhu hengele lyolyose. ");
INSERT INTO ruf_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Lekeni tsakukala na Wayahudi wangi iwalawile isi ya Asiya, hawo tsawabamighwa wawe hano hambele hako kughala lighomba ka wana imbuli yoyose kuna nene. ");
INSERT INTO ruf_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Au iwanu wano iwenyegho walonge totso lyachi lyawonile kuna nene hanyimile hambele ha libalatsa, ");
INSERT INTO ruf_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","ila tsanonga chinu chino kwa kukemelela hambele hawo, ‘Nohighighwa kwaapfila notoghola iwanu watsotsilihuka.’ ” ");
INSERT INTO ruf_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Kuya Felikisi, iyamanyile ghoya mbuli tse Inzila ila, kemitsa lighomba alyo, kawalongela, “Nitsolamla lighomba lyenu hayatsokutsa Lisiya, imkulu we asikali.” ");
INSERT INTO ruf_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Kuya kamlaghitsa imkulu we asikali yamlolese Pauli, lekeni yamlekele chidogho, na yawaleke sale tsake wamwapfile. ");
INSERT INTO ruf_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Haghabitile ghamatsuwa mengi Felikisi katsa na mwehe wake Dulisila, iyakalile Myahudi. Kalaghitsa Pauli yakemighwe na kamtegheletsa hayang'ali yolonga mbuli tse ukumtoghola Yesu Kiristu. ");
INSERT INTO ruf_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Lekeni Pauli hayang'ali yoghendelela ukulonga mbuli iimtenda imunu yanoghe hambele he Imulungu, na mbuli tsa kuwa na kiyasi, na mbuli tse litsuwa lya ukuhighighwa ilikutsa, Felikisi ang'ali yopfuka, kalonga, “Uleke tanu, sambi kodaha kughenda, hanitsopata nyafasi nitsokukema.” ");
INSERT INTO ruf_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Kuya Feliksi tsayang'ali yololela ka Pauli ang'amwing'ile sendi, apfo chila mala tsakamkema na kulonga naye. ");
INSERT INTO ruf_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Imiyaka mili haimalile, Polikiyo Festo tsakambokela Felikisi kutawala, kawa imkulu we isi. Lekeni kwaapfila Felikisi tsakabama awadeng'elese Wayahudi, kamleka Pauli mwigheletsa. ");
INSERT INTO ruf_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Ghamatsuwa madatu kulawa hapfikile Kaisariya, Festo kagheluka Yerusalemu, ");
INSERT INTO ruf_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","ako iwatambika wakulu na iwabala wa Wayahudi wamlongela maghomba gha Pauli. ");
INSERT INTO ruf_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Wamlomba yawanoghese kwa kumghala Pauli Yerusalemu ili wamkome hayang'ali mnzila. ");
INSERT INTO ruf_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Festo kawedika, “Pauli kamwigheletsa ako Kaisariya, na nene nobama mbuye ako matsuwa chidogho ighakutsa. ");
INSERT INTO ruf_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Mleke pfilongotsi wenu wamwenga waghende na nene, waghale maghomba ghake, ka katenda ichinu chochose chihile.” ");
INSERT INTO ruf_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festo hayamalitse kukala nawo ghamatsuwa manane au kumi, kahulumka Kaisariya, litsuwa liwinzile kaghenda kune libalatsa, kalaghitsa Pauli yaghalighwe amo. ");
INSERT INTO ruf_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Pauli hapfikile awala Wayahudi iwatsile kulawa Yerusalemu wema habehi naye, wamlapfila maghomba makulu, ghang'awadahile kulangusa ka ghana ukweli. ");
INSERT INTO ruf_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Baho Pauli kabela kalonga, “Nene sitendile chochose chihile mna malaghitso gha Wayahudi, wala mne Ing'anda ye Imulungu, wala kwa imndewa wa Roma.” ");
INSERT INTO ruf_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Lekeni Festo kabama awadeng'elese Wayahudi, kamlongela Pauli, “Pfii kobama kughenda Yerusalemu ukahighighwe ako hambele hangu kwa maghomba ghano?” ");
INSERT INTO ruf_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pauli kedika, “Nene nakwima hano mne libalatsa lya mndewa wa Roma, nobamighwa nihighighwe hano. ka ghweghwe imwenyegho pfumanya ghoya, sitendile bae ichinu chochose chihile kwa Wayahudi. ");
INSERT INTO ruf_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Lelo ka kuna ichinu chochose chihile chanendile ichitenda nikomighwe, silema kufa bae. Lekeni maghomba ghawangaile Wayahudi ng'agholongesa bae, haduhu imunu iyodaha kunyika mne ghamoko ghawo. Ngaleni kwa imndewa wa Roma!” ");
INSERT INTO ruf_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Kuya Festo hamalitse kulonga ne iwanu wake wa libalatsa, kalonga, “Kobama ughende kwa imndewa wa Roma, haya kutsoghenda kwa imndewa wa Roma!” ");
INSERT INTO ruf_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Ghamatsuwa chidogho haghabitile, mndewa Agiripa na Benike wapfika Kaisariya kumlamsa Festo. ");
INSERT INTO ruf_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Hawakalile ako kwa ghamatsuwa chidogho, Festo kamlongela imndewa mbuli tsa Pauli. Kalonga, “Ahano hana imunu, Felikisi tsakamleka mwigheletsa. ");
INSERT INTO ruf_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Hang'endile Yerusalemu, iwatambika wakulu na iwabala wa Wayahudi wanongela ghamaghomba ghake, kuya wabama yahighighwe. ");
INSERT INTO ruf_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Na nene niwalongela si pfipfo bae pfawotendagha Waroma, kumkoma imunu wowose ng'ana yetingane ne iwanu iwamwing'ile ghamaghomba na kumleka yeyamile. ");
INSERT INTO ruf_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Hawatsile hano, na nene sikawile bae, litsuwa liwinzile tsanikala mne libalatsa, nilaghitsa imunu yuno yaghalighwe. ");
INSERT INTO ruf_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Iwanu wala iwaghalile lighomba, hawemile ng'awalongile ichinu chihile kuna yeye ka pfandolele. ");
INSERT INTO ruf_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Bali tsawang'ali wesonga naye mna mbuli tsawo tsa kutamanila na mbuli tse imunu yumwe iyafile, iyakemighwe Yesu, lekeni Pauli ang'ali yolonga imunu ayo ka mghima. ");
INSERT INTO ruf_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Kwaapfila tsasimanyile bae nendetse kwa ghamaghomba ghano, apfo nimghutsa Pauli ka tsakabama yaghende Yerusalemu yahighighwe ako. ");
INSERT INTO ruf_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Lekeni Pauli kabama yahighighwe na Mkulu wa Roma. Apfo nilaghitsa akale hano mbaka hanitsoghenda kwa mndewa wa Roma.” ");
INSERT INTO ruf_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Kuya Agiripa kamlongela Festo, “Na nene nobama nimuhulike imunu yuno.” Festo kedika, “Kutsomuhulika ilupfi.” ");
INSERT INTO ruf_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Litsuwa liwinzile Agiripa na Benike watsa aku wapfala maghwanda ghanoghile gha undewa, wengila hane libalatsa kwa ndeng'elelo hamwe na iwakulu we asikali na iwakulu wa kaye. Festo kalaghitsa Pauli yaghalighwe mghati. ");
INSERT INTO ruf_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festo kalonga, “Imndewa Agiripa ne iwanu wose yamli hano, momwona imunu yuno! Wayahudi wose ako Yerusalemu na hano Kaisariya wanilomba nimlapfe yakomighwe. ");
INSERT INTO ruf_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Lekeni nene sonile bae ichinu chochose ichimtenda yakomighwe, naye kwaapfila tsakabama yahighighwe na Mkulu wa Roma, ndamla kumghala Roma. ");
INSERT INTO ruf_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Lekeni nene nahela imbuli ya ukumwandikila Imtawala mkulu. Apfo nimghala hano hambele henu, ghendoghendo hambele hako ghweghwe Imndewa Agiripa, mng'amalitsa kumghutsa nipate ichinu cha ukwandika. ");
INSERT INTO ruf_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Kwaapfila nakona ng'apfinoghile bae kumghala mwohighwa bila kulangusa ghomba lyake.” ");
INSERT INTO ruf_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Kuya Agiripa kamlongela Pauli, “Sambi kodaha kwiyamila.” Baho Pauli kenula ghumoko, kandusa kwiyamila. ");
INSERT INTO ruf_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Mndewa Agiripa, leloli nebona nina ndondokela ukwima hambele hako kwiyamila ghamaghomba ghose gha Wayahudi.” ");
INSERT INTO ruf_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Kwaapfila ghweghwe komanya pfihendo pfose pfa Wayahudi na aghala ghose ghawehisanyila. Apfo nolomba ufunye ghumoyo unitegheletse. ");
INSERT INTO ruf_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Wayahudi wose womanya pfanikalile kulawa udodo wangu, pfanikalile muisi mwangu kulawa mwanduso, na pfipfila ako Yerusalemu. ");
INSERT INTO ruf_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Wanimanya kulawa ghumwande, nawo ka wobama wodaha kukulongela ka tsanikala mne kingili lya Mafarisayo iwamtamanila ng'ani Imulungu kubita wanu wangi. ");
INSERT INTO ruf_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Lelo nyima hano nyihighighwe kwaapfila notoghola laghano lyekile Imulungu ne iwabala wetu. ");
INSERT INTO ruf_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Ghamakabila ghetu kumi na meli ghobetetsa laghano alyo litimile, ka pfaghomtumikila ghoya Imulungu ichilo ne imisi. Lelo kwaajili ayo, ghwe Mndewa, Wayahudi wanighala mwigheletsa. ");
INSERT INTO ruf_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ebali mwakona ng'aidahika bae Imulungu kuwatsilihula iwanu iwafile? ");
INSERT INTO ruf_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Nene imwenyegho tsambona nobamighwa nende ghose ighodahika ili kupinga taghwa lya Yesu wa Natsareti. ");
INSERT INTO ruf_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Tsanenda apfo ako Yerusalemu, kwa ghamalaghitso ghe iwatambika wakulu tsaniwaghela mwigheletsa wahenzeluka wengi, na hawang'ali wokomighwa na nene tsaning'ali notoghola wakomighwe. ");
INSERT INTO ruf_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Ghamatsuwa mengi tsaning'ali nighendagha mne tsing'anda tse ukulombela na kuwatowa, kuya tsaniwananaitsa waleke kumtoghola Imulungu. Tsaning'ali niwehila ghendo, mbaka tsang'enda imiji ya kutali kuwadununza. ");
INSERT INTO ruf_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Litsuwa limwe tsaning'ali nighenda Damasko aku ning'ighwa uwetso na malaghitso ghe iwatambika wakulu. ");
INSERT INTO ruf_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Mndewa wangu, nemisi haning'ali mnzila, mbona lumwesa kulawa kulanga lwong'ala kubita litsua, lunimwemwesela nene na wayangu chila ubali. ");
INSERT INTO ruf_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Wose tsatughwa hasi, nene nihulika litsi lyonongela kwa Chihebraniya, ‘Sauli, Sauli! Ebali konidununza? Kwelagha hela ka ng'ombe yoitowa teke ng'weku ye imtwatsa wake.’ ");
INSERT INTO ruf_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Kuya nimghutsa, ‘Mtwatsa, ghweghwe nani?’ Mtwatsa kanyidika, ‘Nene na Yesu yumdununza. ");
INSERT INTO ruf_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Sambi winuke wime. Nikulawila kwaapfila nikusaghula uwe imtumighwa na imkalangama wa agha ghaughonile, na ghanitsokulangusa. ");
INSERT INTO ruf_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Nitsokukombola mne iwanu wako na iwanu iwali si Wayahudi ako kwanikutuma, ");
INSERT INTO ruf_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","uwafumbule nenge tsawo na kuwalapfa mchisi wengile hatselu, walawe mne ingupfu ya Setani, wamghalukile Imulungu, kwa kunitoghola nene, waleghusighwe nzambi na wahale hamwe na wose iwasaghulighwe ne Imulungu.’ ");
INSERT INTO ruf_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Apfo Mndewa Agiripa, sighalemile bae maono agho gha kulanga. ");
INSERT INTO ruf_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ila nyandusa kwa iwanu wa Damasko, kuya kwa awala iwali Yerusalemu na Yudeya yose, na kwa iwanu si Wayahudi bae. Niwapetela watsileke nzambi tsawo wamuyile Imulungu na walanguse kwa ghamatendo ghawo ka watsileka nzambi. ");
INSERT INTO ruf_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Kwaapfila nenda apfi, Wayahudi wanighogha mne Ing'anda ye Imulungu, na tsawabama wang'ome. ");
INSERT INTO ruf_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Lekeni Imulungu kanyapfila, mbaka leloli nene nakwima hano kulapfa ukalangama kwe iwadodo ne iwabala. Silonga ichinu chingi bae, ila nowalongela aghala ghawalongile manabii we Imulungu na Musa ka ghang'alawile. ");
INSERT INTO ruf_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Ka Kiristu Mkombotsi tsakabamighwa yadununzike na ang'awile wa mwanduso kutsilihuka, apfo ang'adahile kughala ghumwanga kwa Wayahudi na kwa Iwanu si Wayahudi bae.” ");
INSERT INTO ruf_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pauli hang'ali keyamila apfo, Festo kakemelela, “Pauli! Kuna lukwale! Kusoma ng'ani kwausomile kukughela lukwale.” ");
INSERT INTO ruf_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Pauli kedika, “Mkulu Festo, nene si mkalukwale bae, nolonga mbuli itsilongesa na tsa ihekima. ");
INSERT INTO ruf_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Mndewa Agiripa komanya ipfinu pfino pfose, na nene nodaha kulonga nae bila kupfuka kwaapfila nomanya kuduhu ichinu ichitendeke chinyelenyele. ");
INSERT INTO ruf_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Mndewa Agiripa, apfi kowatoghola manabii we Imulungu? Nomanya kowatoghola.” ");
INSERT INTO ruf_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Kuya Agiripa kamghutsa Pauli, “Apfi kopfikitsa kodaha kunenda niwe mkiristu kwa ichipindi chino chidodo?” ");
INSERT INTO ruf_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pauli kamwidika, “Nomlomba Imulungu mne ichipindi chidodo au chikulu, si ghweghwe uliyeka bae, ila wose yamnitegheletsa leloli, mdahe kuwa ka pfanili nene, lekeni bila iminyororo ino.” ");
INSERT INTO ruf_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Kuya imndewa, imkulu we ghumkowa na Benike, hamwe na awala iwakalile nawo wose tsawenuka. ");
INSERT INTO ruf_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Na hawang'ali wakuka welongela, “Imunu yuno ng'atendile ichinu ichimtenda yakomighwe wala ukwikighwa mwigheletsa.” ");
INSERT INTO ruf_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agiripa kamlongela Festo, “Imunu yuno ang'alekelelighwe ka ng'abamile bae kuhighighwa na imndewa wa Roma.” ");
INSERT INTO ruf_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Hailamlighwe tughende Italiya, Pauli na iwohighwa wangi wekighwa mne ghamoko gha imkulu yumwe wa asikali iyakemighwe Juliasi, wa chikosi ichikemighwe cha Agusti. ");
INSERT INTO ruf_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Tudina mne imeli iilawile Adiramito iibamile kuka kubitila mne mwani tsa isi ye Asiya, kuya tuka. Aristariko imunu wa Makedoniya iyolawila Tesalonike tsakakala mmeli na twetwe. ");
INSERT INTO ruf_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Litsuwa liwinzile tupfika ako Sidoni, Juliasi tsaang'ali yomtendela pfinoghile Pauli, tsakamleka aghende kuna sale tsake ili wamwing'e aghala ghayobama. ");
INSERT INTO ruf_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Kulawa ako tughendelela na ghumwanza, tubita habehi ne ichisiwa cha Kupulo kwaapfila libeho tsaling'ali likupa ng'ani. ");
INSERT INTO ruf_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Tsatuloka ibahali ya Kilikiya na Pamfiliya, tupfika Mira ako Likiya. ");
INSERT INTO ruf_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Ako imkulu yula wa asikali kaipfika imeli ya Alekisandiliya iighenda Italiya, apfo katulongela tudine amwo. ");
INSERT INTO ruf_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Tughendelela na ghumwanza lughalugha kwa ghamatsuwa mengi, kwa ukughaya tsatupfika habehi na Nido. Kwaapfila libeho tsaling'ali lyotughoma, tubita lubali lwe kuisi lwe Kirete habehi na Salimone. ");
INSERT INTO ruf_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Kuya tubita kumwani kwa kughaya, kuya tupfika hanu hakemighwe Bandari Inoghile, habehi na kaye ya Leseya. ");
INSERT INTO ruf_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Ghamatsuwa mengi tsaghabita, na litsuwa lya ukufunga ukuja tsalibita. Ghumwanza tsaghukala ghwa mne ihatari ng'ani. Apfo Pauli kawakanya, ");
INSERT INTO ruf_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Walume weyangu, nakona ghumwanza ghwetu ghutsakuwa na maghayo tutsakwaghitsa imitsigho, imeli na ughima wetu pfipfila.” ");
INSERT INTO ruf_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Lekeni imkulu wa asikali kaleka kuhulikitsa ghayalongile Pauli, kawahulikitsa imkulu we imeli na imunu yane imeli ayo. ");
INSERT INTO ruf_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Kwaapfila bandari ila ng'ainoghile bae kukala mne ghamatsuwa gha chipfeghetsi, iwanu wangi walamla tulawe ako tughende Foinike ka ing'adahike, na kukala ako ghamatsuwa ghose gha ichipfeghetsi. Foinike tsaikala ibandari ya Kirete iilolese lubali lwa kuchanya na lubali lwa kuisi kwa liswela litsuwa. ");
INSERT INTO ruf_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Na libeho lya lubali lwa kuhisi halyanduse kuduma chidoghochidogho, tsawapfikitsa wapata chawabamile, apfo wandusa ghumwanza na kubita kumwani kwa kumwani habehi na Kirete. ");
INSERT INTO ruf_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Hambele chidogho, libeho kali ng'ani liduma kulawa kuchanya kughenda kwalilawila litsuwa. Tsaliduma kulawa mne ichisiwa. ");
INSERT INTO ruf_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Imeli tsaing'ali itowighwa na libeho na ng'ahidaile bae kuliking'a libeho. Apfo tuileka imeli isolighwe na libeho. ");
INSERT INTO ruf_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Hatung'ali twobita habehi ne ichisiwa chidogho ichikemighwe Kauda, tsatudaha ukwika ghoya ghumnumbwi ghwe imeli, lekeni kwa kughaya. ");
INSERT INTO ruf_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Iwanu tsawaghukwegha ghumnumbwi mghati, wayowa imeli kwa imitsabi. Tsawapfuka ka wang'adahile ukukwama mne lundo lya msanga lya Libiya, apfo wahulumsa matanga na kuileka isolighwe na libeho. ");
INSERT INTO ruf_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Kwaapfila wang'ali wotowighwa ng'ani ne nyahemu, litsuwa lya keli wandusa ukwasa imitsigho mne ibahali. ");
INSERT INTO ruf_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Litsuwa lya kadatu, wasa ipfinu pfe imeli mne ibahali kwa ghamoko ghawo iwenyegho. ");
INSERT INTO ruf_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Kwa ghamatsuwa mengi ng'atudahile bae ukwona lilangi wala tsinondo, na nyahemu ng'ulu tsaing'ali ighendelela. Tsakukala kuduhu imunu iyalolele kuhona. ");
INSERT INTO ruf_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Hawakalile ghamtsuwa mengi bila ukuja, Pauli kema mghati mwawo, kalonga, “Tsambamighwa mnihulikitse nene na mng'alekile kulawa Kirete, namwe mng'alekile kwingila mne ghamaghayo ghano na ukwaghisa pfinu. ");
INSERT INTO ruf_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Lelo nowalomba muwe na ghumoyo, kwaapfila kuduhu imunu kuna mwemwe iyatsokwagha, ila imeli iliyeka itsohinyika. ");
INSERT INTO ruf_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ichilo chibitile malaika we Imulungu yula nene yanili munu wake, na yanimtumikila, kema habehi yangu, ");
INSERT INTO ruf_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","kanongela, ‘Pauli uleke kupfuka, kobamighwa wime hambele ha mndewa wa Roma. Kwaajili yako Imulungu katsokombola ughima wa chila imunu mne imeli.’ ");
INSERT INTO ruf_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Apfo msangalale! Kwaapfila nomtoghola Imulungu itsolawila ka pfanongele. ");
INSERT INTO ruf_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Lekeni tutsoghalighwa mbaka mne chisiwa chingi.” ");
INSERT INTO ruf_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Mne chilo cha litsuwa lya kumi na nne, tsatung'ali tusolighwa akuno na akuno mne ibahali ya Mediteraniya. Nechilo ng'ani iwanu we imeli tsawapfikitsa twa habehi ne isi. ");
INSERT INTO ruf_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Apfo wabama wamanye utali we ichilindi che ibahali kwa kuhulumsa lutsabi lwohighwe chinu chitito, wapata utali wa mita alubaini, hambele chidogho watenda apfo keli, wapata utali wa mita selasini. ");
INSERT INTO ruf_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Kwaapfila wapfuka kukwama mne ghamabambalawe, wahulumsa nanga nne kuchughu mwe imeli, walomba uche. ");
INSERT INTO ruf_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Iwanu iwolongotsa imeli tsawabama watsume waileke imeli. Apfo wahulumsa ghumnumbwi ghula mdodo mne ghamatsi, watenda ka woghenda kuhulumsa nanga kulawa hambele he imeli. ");
INSERT INTO ruf_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Lekeni Pauli kamlongela imkulu yula wa asikali na asikali wake, “Awano ka ng'awatsokala mne imeli, ng'amdaha bae kukomboka.” ");
INSERT INTO ruf_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Apfo asikali waighana imitsabi ikindile ghumnumbwi ghula mdodo, waghuleka usolighwe ne ghamatsi. ");
INSERT INTO ruf_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Na hakung'ali kwakucha Pauli kawalomba wose waje ichijo, kalonga, “Kwa ghamatsuwa kumi na mane, tsamng'ali mwoghanzika, ng'amjile ichinu chochose bae. ");
INSERT INTO ruf_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Lelo nowalomba msole ichijo mje, kwaapfila ichijo chobamighwa kwaajili ya ughima wenu. Kuduhu hata imvili imwe iitsokwagha mne ghamatwi ghenu.” ");
INSERT INTO ruf_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Hayamalitse kulonga apfi, kasola chighate, kalonga mighede kwe Imulungu hambele hawo wose. Kuya kachibena, kandusa kuchija. ");
INSERT INTO ruf_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Wose waghumighwa ghumoyo, na chila imunu kaja ichijo. ");
INSERT INTO ruf_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Iwanu wose yatukalile mne imeli tsatukala iwanu miya mbili, sabini na sita. ");
INSERT INTO ruf_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Haweghutile, wahungutsa utito we imeli kwa ukwasa ingano mne ibahali. ");
INSERT INTO ruf_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Hakuchele, ng'awaimanyile bae isi ila, lekeni wona msanga kumwani, apfo walamla kuighala imeli ako ka wang'adahile. ");
INSERT INTO ruf_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Waghana mitsabi ye tsinanga, watsileka mne ibahali, waidohola imitsabi iikindile msukani, kuya wenula litanga lya hambele he imeli ili likinde libeho na kutughala kumwani. ");
INSERT INTO ruf_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Lekeni imeli tsaipfika hanu hane nzila mbili tsa ghamatsi ghe ibahali, na imeli ikwama. Hambele he imeli hakala hatsama mne ghumsanga na ng'aidahile kuseghela bae, na kuchughu kwandusa ukubeneka kwaajili ye ingupfu ya ghamawimbi. ");
INSERT INTO ruf_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Asikali tsawabama wawakome wohighwa, hela waleke koghelela na kutsuma. ");
INSERT INTO ruf_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Lekeni imkulu wa asikali tsakabama Pauli yakomboke, apfo kawaghoma asikali wake waleke ukutenda apfo. Kawalaghitsa awala iwodaha ukoghelela wadaluke kulawa mne imeli, woghelele mbaka kumwani. ");
INSERT INTO ruf_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Na iwanu wangi iwasighale, waghoghe tsimbao au mne ipfihindi pfe imeli. Apfo iwanu wose wapfika tseghamba kumwani. ");
INSERT INTO ruf_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Hatupfikile tseghamba kumwani, tsatumanya ichisiwa chila chokemighwa Melita. ");
INSERT INTO ruf_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Wenye kaye watutendela uluso ghendo, watubwinila ghumoto twote kwaapfila imvula tsaing'ali itowa na tsakukala ne ichipfeghetsi. ");
INSERT INTO ruf_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pauli tsakadondola tsingodi, na hayang'ali yotsika mmoto, ghumoto ghula ghumtenda nzoka yalawe mne tsingodi na kumluma Pauli na kwikindilitsa mna ghumoko ghwake. ");
INSERT INTO ruf_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Wenye kaye hawamwonile inzoka ayo kolebela mmoko mwake, welongela, “Imunu yuno kakoma imunu ghendo, hata ka kahona mne ibahali, chisasi che milungu ng'achimlekelela bae yakale mghima.” ");
INSERT INTO ruf_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Lekeni Pauli kamkung'usila inzoka ayo mmoto na kuduhu chihile ichimpatile. ");
INSERT INTO ruf_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Tsawapfikitsa katsopfimba au bahala katsakughwa hasi na ukufa, lekeni hawabetile kwa ichipindi chitali, na ng'awonile bae ichinu chihile ichimlawile, waghalusa mawatso ghawo, walonga Pauli tsakakala yumwe we milungu. ");
INSERT INTO ruf_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Habehi na hanu hala tsakukala na imighunda ye imkulu we chisiwa iyakemighwe Pabiliyo. Imunu ayu tsakatubokela ghoya na tukala iwahenza wake kwa ghamatsuwa madatu. ");
INSERT INTO ruf_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Aba wake tsakakala kawasa mlutsatsi, koghula lihoma na kupweleta idamu. Pauli kaghenda ukumlola na hayamalitse kulomba, kamwikila ghamoko, kamuhonetsa. ");
INSERT INTO ruf_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Haghalawile agho, iwanu wengi iwang'ali woghula mne ichisiwa chila, nawo watsa wahonetsighwa. ");
INSERT INTO ruf_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Watwing'a nzawadi ketseketse, na hatung'ali tweyandaa ukuka, tsaweka mne imeli chila ichinu chatubamile mne ghumwanza. ");
INSERT INTO ruf_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Imiyetsi midatu haimalile tughendelela na ghumwanza kwa imeli imwe ya Alekisandiliya iikemighwe “Milungu Basa,” imeli ayo tsaikala hala Melita ghamatsuwa ghe ichipfeghetsi. ");
INSERT INTO ruf_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Tupfika Sirakusa na ukukala aho ghamatsuwa madatu. ");
INSERT INTO ruf_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Kulawa ako tughenda ghumji ghwa Regiyo. Litsuwa liwinzile libeho lyandusa kuduma kulawa lubali lwa kuhisi, na litsuwa lya kabili tupfika Potioli. ");
INSERT INTO ruf_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Ako tuwapfika iwanu iwamtoghole Yesu, watulomba tukale nawo ghamatsuwa saba. Kuya tupfika Roma. ");
INSERT INTO ruf_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Iwanu iwamtoghole Yesu ako Roma tsawahulika ka tsatung'ali tukutsa, apfo watsa kutubokela mne ghulilo lya Apiyo na ng'anda ndatu tsa kuwasila wagheni. Pauli hawonile kamtunya Imulungu, tsakaghumighwa ghumoyo ng'ani. ");
INSERT INTO ruf_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Hatupfikile Roma, Pauli tsakalekelighwa kukala yaliyeka hamwe ne asikali iyang'ali yombetetsa. ");
INSERT INTO ruf_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Ghamatsuwa madatu hambele kawakema hamwe pfilongotsi wa Wayahudi. Hawetingane Pauli kawalongela, “Ndughu tsangu, nene sitendile chinu chochose bae chihile kwe iwanu wangu, wala silemile ipfihendo pfe iwabala wetu. Lekeni tsanighoghighwa ako Yerusalemu na kwikighwa mne ghamoko ghe Waroma. ");
INSERT INTO ruf_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Waroma hawamalitse kunighutsa wabama wandekelele, kwaapfila nahela totso ilinitenda nikomighwe ");
INSERT INTO ruf_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Lekeni pfilongotsi wa Wayahudi hawalemile, chinu acho chinitenda nibame nihighighwe ne mndewa wa Roma. Lekeni nene nahela ghomba lyolyose ne iwanu wangu. ");
INSERT INTO ruf_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Kwaajili ayo niwakema niwone na nonge namwe, kwaapfila nyohighwa minyororo ino kwaajili ya mkombotsi iwomlolela iwanu wa Isiraeli.” ");
INSERT INTO ruf_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Nawo wamlongela, “Twetwe ng'ana tubokele bae ibaluwa yoyose ilawile Yudeya, kuya kuduhu iwanu iwatsile kulawa ako kutulongela mbuli tsako tsihile. ");
INSERT INTO ruf_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Lekeni twobama tukuhulike ghweghwe ghumwenyegho ulongatse, kwaapfila chatumanya twetwe chila hanu iwanu wolilonga pfihile kingili lyako lino.” ");
INSERT INTO ruf_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Apfo welaghana wetingane na Pauli mne litsuwa lingi, na iwanu wengi wamtsila ukaye yake. Kulawa nemitondo mbaka nemihe Pauli tsakawalongela mbuli tse undewa we Imulungu, na kwa Ghamalaghitso gha Musa na ghamaandiko ghe wanabii we Imulungu, kaghetsa kuwakwegha wamtoghole Yesu. ");
INSERT INTO ruf_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Iwanu wamwenga waghatoghola ghayalongighwe na Pauli, lekeni wamwenga ng'awatoghole bae. ");
INSERT INTO ruf_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Hawang'ali wesonga wawo kwa wawo na kwandusa ukuka, Pauli kalonga imbuli ino, “Ghumuhe Mwenzeluka tsakalonga ghoya kuna iwabala wenu kubitila Isaya, nabii we Imulungu. ");
INSERT INTO ruf_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","tsakalonga ‘Ghenda uwalongele iwanu wano, mtsohulika na kuhulika lekeni ng'amtsomanya bae, mtsolola na kulola lekeni ng'amtsakona bae, ");
INSERT INTO ruf_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","kwaapfila imimoyo ye iwanu wano mikomu, maghutwi ghawo waghadiwa, tsinenge tsawo watsifing'ilisa. Waleke ukwona kwa tsinenge tsawo, na kuhulika kwa maghutwi ghawo, na kumanya kwa imimoyo yawo, watsileke nzila tsawo tsihile, kuya niwahonetse.’ ” ");
INSERT INTO ruf_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Kuya Pauli kalonga, “Apfo nobama mmanye imbuli ye ukombotsi wa Imulungu ighalighwa kuna Iwanu si Wayahudi, wawo watsoihulikitsa!” ");
INSERT INTO ruf_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Pauli hamalitse kulonga apfo, Wayahudi woka aku wesonga ng'ani iwenyegho kwa iwenyegho. ");
INSERT INTO ruf_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Kwa miyaka mili Pauli tsakakala baho mne ing'anda iyoilihila kodi, na kawabokela iwanu wose iwabamile kumwona. ");
INSERT INTO ruf_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Kawapetela iwanu mbuli tse Undewa we Imulungu, kuya kalangulitsa mbuli tse Imtwatsa Yesu Kiristu bila kupfuka, na kuduhu imunu yamghomile.");
INSERT INTO ruf_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Nene Pauli, mtumwa wa Kiristu Yesu. Imulungu tsakang'ema niwe mtumighwa na kambaghula niwapetele iwanu Imbuli yake Inoghile. ");
INSERT INTO ruf_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Aho ghumwande Imulungu tsakawalongela iwanu Imbuli ino Inoghile kubitila manabii wake mne Ghamaandiko Mahenzeluka. ");
INSERT INTO ruf_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","4","Mbuli ino Inoghile yolonga mbuli tse Imwana we Imulungu, Imtwatsa wetu Yesu Kiristu, yeye kwa lukuli tsakelekighwa mne lukolo lwa Daudi. Kwa muhe wake wa uhenzeluka, na kwa ngupfu yake ya kutsilihuka yeye tsakalangusighwa yawe Imwana we Imulungu. ");
INSERT INTO ruf_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Yeye iyo yatutendele twetwe uluso na kutwing'a utumighwa wa kuwalongotsa iwanu wa makabila ghose mne ukutoghola ikughala ukuhulika. ");
INSERT INTO ruf_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Mwemwe mwa iwanu ka wawo, yamkemighwe muwe iwanu wa Yesu Kiristu. ");
INSERT INTO ruf_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Lelo nomwandikilani mwemwe wose yamkala Roma yamnoghelighwa ne Imulungu, yamkemighwe muwe wanu wake wahenzeluka. Imulungu aba wetu na Imtwatsa wetu Yesu Kiristu wamtendeleni uluso na wamtendeni mkale tseghamba. ");
INSERT INTO ruf_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Tanu nonge mighede kwe Imulungu wangu kubitila Yesu Kiristu kwaajili ya mwemwe mwose, kwaapfila ukutoghola kwenu kopetighwa muisi mwose. ");
INSERT INTO ruf_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Nomsang'anila Imulungu kwa ghumoyo ghwangu ghose kwa kupeta Imbuli Inoghile ye Imwanaghe. Na yeye ka mkalangama wangu pfanimkumbukani ");
INSERT INTO ruf_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ghamatsuwa ghose hanilomba. Nomlomba ka Imulungu ang'abama yanende nidahe kumwangilani. ");
INSERT INTO ruf_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Kwaapfila tsanisulukila ghendo kumwonani na kwihangila namwe balaka tsayomwing'ani Ghumuhe Mwenzeluka ili kuwatenda mkomale. ");
INSERT INTO ruf_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Chanilonga hano, wose twikanze, mwemwe mnitoghole nene na nene nimtogholeni mwemwe. ");
INSERT INTO ruf_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Mwemwe ndughu tsangu, nobama mmanye pfino, tsaning'ali nibamagha kumwangilani ili iwanu wamtoghole Imulungu kuna mwemwe ka iwanu pfawamtoghole Imulungu kwe iwanu si Wayahudi bae, lekeni mbaka sambi nighomighwa kumwangilani. ");
INSERT INTO ruf_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Nilaghitsighwa sang'ano ya kuwapetela Wagiriki na awala si Wagiriki bae, na kuwapetela awala iwakengele na iwabotsi. ");
INSERT INTO ruf_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Apfo, nene nosulukila sideke kuwapetelani Imbuli Inoghile mwemwe pfipfila yamkala Roma. ");
INSERT INTO ruf_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Siyonela chinyala bae Imbuli Inoghile, kwaapfila ina ngupfu ye Imulungu ya kumkombola chila munu iyoitoghola, tanu kwe Wayahudi, kuya kwe iwanu iwali si Wayahudi bae. ");
INSERT INTO ruf_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Mana Imbuli Inoghile yolangusa mwatsi Imulungu pfayowatenda iwanu wanoghe kuna yeye kwa ukutoghola, kulawa mwanduso mbaka utsighilo. Ka pfayandikighwe mne Ghamaandiko Maenzeluka; “Imunu iyanoghile kwe Imulungu katsokala kwa ukutoghola.” ");
INSERT INTO ruf_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Kulawa kulanga Imulungu kaghubula maya yake kwa nzambi tsose na kwa ghose ghehile gha iwanu wala iwoutenda ukweli uleke kumanyika kwa ghehile ghawo. ");
INSERT INTO ruf_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Kwaapfila aghala ighomtenda Imulungu yamanyike kuna wawo ghamwatsi ghendo. Na Imulungu mwenyegho kaghatenda ghawe mwatsi. ");
INSERT INTO ruf_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Kulawa ghamatsuwa Imulungu hayalumbile isi, uwetso wake wa ghamatsuwa ghose na ulungu wake pfomanyika mwatsi, hata ka ng'apfikoneka kwa tsinenge bae. Iwanu wodaha kuumanya kwa pfinu pfayalumbile. Apfo wahela chinu che ukwiyamila. ");
INSERT INTO ruf_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Wammanya Imulungu, lekeni ng'awamtunitse bae ka Imulungu wawo wala ng'awalongile mighede kuna yeye, ila chawalangule tsachiwa cha ubotsi na imimoyo yawo tsaighumighwa chisi. ");
INSERT INTO ruf_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Tsawalonga wawo wakengela, lekeni wawa wabotsi. ");
INSERT INTO ruf_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Waleka kumtunitsa Imulungu yang'akufa bae, lekeni wapfitunitsa ipfinyagho ipfighala ne iwanu iwakufa, na iwapfideghe ne iwanyama na awala iwotambala. ");
INSERT INTO ruf_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Apfo Imulungu kawaleka wasulukile pfihile mne imimoyo yawo na wetendele pfinu pfe chinyala mne ng'uli tsawo. ");
INSERT INTO ruf_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Waughalusa ukweli we Imulungu kwa ughutsu, wapfitamanila na wapfitumikila ipfinu ipfilumbighwe ne Imulungu, ila ng'awamtunitse bae mwenyegho Mulumba iyobamighwa kutunyighwa ghamatsuwa ghose. Ona. ");
INSERT INTO ruf_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Kwaapfila wotenda pfino, Imulungu kawaleka wengilighwe na tsitamaa tse chinyala. Hata wapinga wawo waleka kuwasa na iwamale tsawo ka Imulungu pfawalumbile, tsawesulukila iwenyegho. ");
INSERT INTO ruf_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Iwamale pfipfila waleka kuwasa ne wapinga tsawo ka Imulungu pfawalumbile, wesulukila iwenyegho. Wetendela pfinu pfa chinyala iwamale kwa iwamale. Apfo weghalila wenyegho maghayo kwa ghehile ghawo ghawatendile. ");
INSERT INTO ruf_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Kwaapfila iwanu awo tsawalema kumtanga Imulungu kwa mbutsi tsawo, Imulungu kawaleka wawinze mbutsi tsawo tsihile, waghatenda aghala ghawaghomighwe kughatenda. ");
INSERT INTO ruf_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Iwanu wano wamemesighwa ghehile ghose, kwiha na ukubunza na chepfu na ukukoma na ughobo na ughutsu na ukudesa na ung'enye, ");
INSERT INTO ruf_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","iwowabangitsila wayawo, iwomuhila Imulungu, iwoligha, iwetunya, iweghoda, iwobama kutenda ghehile na iwolema kuwategheletsa awala iwaweleke. ");
INSERT INTO ruf_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Wahela tsimbutsi na ng'awokinda bae laghano na ng'awowanoghela bae au kuwonela libatsi iwanu wangi. ");
INSERT INTO ruf_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Womanya ka ghamalaghitso ghe Imulungu gholonga iwanu iwotenda pfinu ka pfino wobamighwa wafe, lekeni wotenda pfinu apfo na si pfipfo pfiliheka bae, ila pfipfila wowatoghola awala iwotenda pfinu apfo. ");
INSERT INTO ruf_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Apfo ghwe miyangu, ka kwowahigha iwanu wangi, ng'udaha bae kwiyamila hata ka uli nani. Kwaapfila hauwahigha wanu wangi aku naghwe koghatenda aghala ghawotenda wawo, kwehigha imwenyegho. ");
INSERT INTO ruf_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Na twetwe twomanya ka ukuhigha kwe Imulungu kwolongesa kwa awala iwotenda pfinu ka apfo. ");
INSERT INTO ruf_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Lekeni ghweghwe yauwahigha awala iwotenda agho, naghwe mwenyegho koghatenda ghagho, angu kopfikitsa kutsohepa ukuhighighwa ne Imulungu? ");
INSERT INTO ruf_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Au koubetsa unoghelo mkulu we Imulungu na ukududumila kwake na kufinya kwake ghumoyo, angu ng'utanga bae ka unoghelo we Imulungu wokulongotsa ili uleke nzambi? ");
INSERT INTO ruf_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Lekeni ghweghwe kuna ghumoyo mkomu na kwa msughu kuleka ghehile, apfo kwiikila imwenyegho maya ng'ulu ye Imulungu mne litsuwa lila lya ukuhigha kwe Imulungu kwa haki hakutsoghubulighwa. ");
INSERT INTO ruf_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Imulungu katsomliha chila munu kwa achila chayasang'ane. ");
INSERT INTO ruf_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Iwanu wala iwoghendelela kutenda ghanoghile aku wobama utunitso na ukutogholighwa na kuleka kuhinyika, iwanu wano Imulungu katsoweng'a ughima wa matsuwa ghose. ");
INSERT INTO ruf_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Lekeni awala iwelangula iwenyegho, awala iwolema ukweli, ili waghawinze ghehile, Imulungu katsowahigha ghendo kwa maya yake. ");
INSERT INTO ruf_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Maghayo na usungu utsompata chila munu iyotenda ghehile, tanu kwa Wayahudi kuya kwa iwanu iwali si Wayahudi bae. ");
INSERT INTO ruf_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Lekeni Imulungu katsowatunya, katsowatoghola, na katsoweka tseghamba iwanu wala iwotenda ghanoghile, tanu Wayahudi kuya awala iwali si Wayahudi bae. ");
INSERT INTO ruf_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Kwaapfila Imulungu ng'ololagha bae chihanga che imunu. ");
INSERT INTO ruf_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Awala iwotenda ghehile akuno wahela Ghamalaghitso gha Musa, watsakwagha bila Ghamalaghitso, na awala iwotenda ghehile akuno wana Ghamalaghitso gha Musa, watsohighighwa kwa Ghamalaghitso. ");
INSERT INTO ruf_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Kwaapfila si awala iwohulika Ghamalaghitso iwo iwanoghile kwe Imulungu, ila awala iwokinda Ghamalaghitso iwo iwotsopetighwa wanogha hambele he Imulungu. ");
INSERT INTO ruf_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Iwanu iwali si Wayahudi bae wahela Ghamalaghitso gha Musa. Lekeni hawotenda kulawa mne imimoyo yawo ka Ghamalaghitso pfoghobama, wawo wenyegho wakuwa na ghamalaghitso mghati mwawo hata ka wahela Ghamalaghitso gha Musa. ");
INSERT INTO ruf_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Kwaapfila wolangusa ka ighobamighwa na Ghamalaghitso ghandikighwa mne mimoyo yawo. Mimoyo yawo yolangusa ka aino kweli, kwaapfila ghamawatso ghawo gholangusa ka wotenda ghanoghile au ghehile. ");
INSERT INTO ruf_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Agha ghatsolawila mne litsuwa lya ukuhigha hala Imulungu kubitila Yesu Kiristu hayatsohigha mbuli tse chinyelenyele tse iwanu, ka Imbuli Inoghile yaniipetile pfailonga. ");
INSERT INTO ruf_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Lelo ghweghwe, iwikema imwenyegho Myahudi; kohuwila Ghamalaghitso, kweghodela kuwa imunu we Imulungu. ");
INSERT INTO ruf_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Kwomanya aghala ghobama Imulungu utende na kwodaha kusaghula ighanoghile kwaapfila Ghamalaghitso ghakulangulitsa. ");
INSERT INTO ruf_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Kwopfikitsa ghendo ghweghwe kwa imunu yowalongotsa pfifita na kwa chimuli kwe iwanu wala iwali mchisi, ");
INSERT INTO ruf_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","kwa mlangulitsi wa wabotsi na mlangulitsi wa awala ng'ana wakomale, kwaapfila kwopfikitsa mne Ghamalaghitso kunagho ukumanya kose na ukweli. ");
INSERT INTO ruf_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Lelo ghweghwe yuwalangulitsa weyagho, ule ng'awilangulitsa mwenyegho bae? Kwowapetela weyagho waleke kwiba, pfii ghweghwe mwenyegho ng'ukwiba bae? ");
INSERT INTO ruf_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Ghweghwe yaulonga iwanu waleke ughoni, pfii ghweghwe mwenyegho ng'utenda ughoni bae? Kwoihila pfinyagho pfe imilungu, pfii ghweghwe ng'ukwiba bae mne tsing'anda tse imilungu? ");
INSERT INTO ruf_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Kweghodela Ghamalaghitso ghe Imulungu, pfii ghweghwe mwenyegho ng'umbetsa Imulungu kwa kuleka kughakinda Ghamalaghitso ghake? ");
INSERT INTO ruf_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Ka pfayandikighwe mne Ghamaandiko Maenzeluka, “Iwanu si Wayahudi waliligha taghwa lye Imulungu kwaajili ya mwemwe Wayahudi.” ");
INSERT INTO ruf_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Ukwingila ngoma kunogha ka kokinda Ghamalaghitso, lekeni ka ng'aughakinda bae Ghamalaghitso, kweghala ne imunu yula ng'ana yengile ngoma bae. ");
INSERT INTO ruf_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Iwanu iwali si Wayahudi, awala ng'ana wengile ngoma bae wang'atenda ka Ghamalaghitso pfoghobama, angu ng'awatsopetighwa ka wengila ngoma bae? ");
INSERT INTO ruf_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Iwanu iwali si Wayahudi, awala ng'ana wengile ngoma bae kwa lukuli, lekeni woghakinda Ghamalaghitso watsowahighani mwemwe Wayahudi kwaapfila ng'amghakinda bae Ghamalaghitso, hata ka mnagho Ghamalaghitso ighandikighwe. ");
INSERT INTO ruf_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Myahudi ghendo si yula Myahudi wa kunze bae, wala ukwingila ngoma si chinu hela cha kunze bae wala cha lukuli. ");
INSERT INTO ruf_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Lekeni Myahudi ghendo iyo yula iyali Myahudi kwa mghati, ayula yengile ngoma mne ghumoyo ghwake. Aino isang'ano ye Ghumuhe we Imulungu, si chinu cha ghamalaghitso ighandikighwe. Imunu iyali apfi kotogholighwa ne Imulungu, si ne iwanu bae. ");
INSERT INTO ruf_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Angu lelo Myahudi kana chinu chachi ichongetseke kubita wanu wangi? Apfi ukwingila ngoma chinu chikulu? ");
INSERT INTO ruf_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Ona, kuna pfinu pfikulu pfingi. Chamwanduso, Wayahudi tsaweng'ighwa imbuli ye Imulungu. ");
INSERT INTO ruf_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Ka wamwenga wawo ng'awomtoghola Imulungu bae, pfii chinu acho chitsomtenda Imulungu aleke kutogholighwa? ");
INSERT INTO ruf_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Mbe, si pfipfo bae! Leka Imulungu yoneke kolongesa, na chila imunu kamghutsu. Ka pfayandikighwe mne Ghamaandiko Maenzeluka, “Chila haulonga mbuli tsako chila munu kakona tsolongesa na hauhigha ghweghwe kwohuma.” ");
INSERT INTO ruf_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Lekeni ka ukwiha kwetu kwolangusa Imulungu kotenda pfinoghile, lelo tulonge choni? Tulonge Imulungu kototsa hayotuhigha? Ahano nolonga ka imunu. ");
INSERT INTO ruf_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Si pfipfo bae! Ing'awile apfo, Imulungu ang'adahiletse kuihigha isi? ");
INSERT INTO ruf_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Imunu yumwe kodaha kulonga, “Ka ughutsu wangu wakongetsa ukulongesa kwe Imulungu na wakongetsa utunitso wake, lelo ule nohighighwa ka nina nzambi?” ");
INSERT INTO ruf_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Ule ng'atulonga, “Leka tutende ghehile ili ighanoghile ghatse?” Iwanu wangi wandigha, walonga ka nene nolangulitsa apfo. Watsohighighwa ka pfawobamighwa. ");
INSERT INTO ruf_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Tulonge choni lelo? Twetwe Wayahudi tunogha kubita iwanu wangi? Mbe! Ka pfaniwalongele aho mwanduso ka Wayahudi na iwanu wangi wose wana nzambi. ");
INSERT INTO ruf_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Ka pfayandikighwe mne Ghamaandiko Mahenzeluka; “Kuduhu hata yumwe iyanoghile, ");
INSERT INTO ruf_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","kuduhu hata yumwe iyotanga, kuduhu hata yumwe iyombama Imulungu. ");
INSERT INTO ruf_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Wose wamleka Imulungu, wose wawa ka wola, kuduhu yotenda ghanoghile, kuduhu hata yumwe. ");
INSERT INTO ruf_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Mimelo yawo iwa ka tsikabuli itsili mwatsi milimi yawo yolonga ughutsu. Mmilomo mwawo wana tsimbuli tsine sumu ka ya nzoka. ");
INSERT INTO ruf_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Milomo yawo imema ukulighita na usungu mkulu. ");
INSERT INTO ruf_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Ghamaghulu ghawo ghotsumilila ukukoma. ");
INSERT INTO ruf_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Hohose hawoghenda wohinya na woleka maghayo. ");
INSERT INTO ruf_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Ng'awamanyile bae kukala tseghamba. ");
INSERT INTO ruf_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Ng'awompfuka Imulungu bae.” ");
INSERT INTO ruf_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Lelo twomanya ka Ghamalaghitso gha Musa hagholonga, gholonga ne iwanu wala iwobamighwa kulongotsighwa na Ghamalaghitso ili chila munu yaleke kudaha kwiyamila, na wanu wose wahighighwe ne Imulungu. ");
INSERT INTO ruf_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Apfo kuduhu imunu wowose yatsopetighwa kanogha hambele he Imulungu kwa kutenda pfaghobama Ghamalaghitso, ila Ghamalaghitso ghotutenda twalangitse kutenda nzambi. ");
INSERT INTO ruf_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Lekeni sambi, Imulungu kaitenda inzila yake ya kuwatenda iwanu kuwa wanogha hambele hake imwenyegho imanyike. Inzila ino ng'aihuwila ghamalaghitso bae. Hata ipfitabu pfa Ghamalaghitso ipfiandikighwe na Musa na pfa manabii pfolangusa chinu chino. ");
INSERT INTO ruf_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Imulungu kowatenda iwanu kuwa wanogha hambele hake kwa kumtoghola Yesu Kiristu. Imulungu kotenda apfo kwe iwanu wose iwomtoghola Kiristu, kuduhu ubaghutsi wowose kwa Wayahudi ne iwanu wangi, ");
INSERT INTO ruf_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","kwaapfila chila imunu katenda nzambi na kuhungukighwa ne utunitso we Imulungu. ");
INSERT INTO ruf_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Lekeni kwa uluso wa hela we Imulungu, iwanu wose watsotendighwa wanogha hambele he Imulungu kubitila Yesu Kiristu iyowaghombola. ");
INSERT INTO ruf_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Imulungu kamlapfa Yesu ili kwa lifwa lyake yawe nzila ya kuwaleghusila iwanu nzambi tsawo kwa ukutoghola idamu yake. Katenda apfi ili kulangusa ukunogha kwake hambele he iwanu kwaapfila mne ukududumila kwake yeye ng'atsihighile bae tsinzambi itsilongole kutendighwa. ");
INSERT INTO ruf_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Katenda apfo ili kulangusa haki yake kwe iwanu, ili yawe yane haki na yadahe kumtenda yawe na haki imunu wowose iyomtoghola Yesu. ");
INSERT INTO ruf_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Lelo twodaha kwighodela choni? Haduhu! Pfii imunu kodaha kwighoda kwa kukinda Ghamalaghitso? Bae, ila kwa ukutoghola. ");
INSERT INTO ruf_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Kwaapfila imunu kotendighwa kanogha kwe Imulungu kwa ukutoghola, na si kwa ukukinda Ghamalaghitso bae. ");
INSERT INTO ruf_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Angu Imulungu ka Imulungu wa Wayahudi waliheka? Angu naye si Imulungu wa iwanu wangi? Ona yeye ka Imulungu wa iwanu wangi, ");
INSERT INTO ruf_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","kwaapfila Imulungu ka yumwe, na yeye katsowatenda wanoghe kuna yeye kwa ukutoghola kwawo Wayahudi iwekema wengila ngoma, pfipfila katsowatenda wanoghe kuna yeye kwa ukutoghola kwawo iwanu iwali si Wayahudi, iwokemighwa ng'awengile ngoma. ");
INSERT INTO ruf_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Pfii lelo twogheka hambali Ghamalaghitso kwa ukutoghola kuno? Mbe, si pfipfo bae, ila twoghawinza Ghamalaghitso agho. ");
INSERT INTO ruf_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Lelo tulongetse mbuli tse mbala wetu Abrahamu, pfayatangile chinu chino? ");
INSERT INTO ruf_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Mana ka Abrahamu tsakapetighwa kanogha kwa aghala ghayatendile, ang'awile na chinu cha kwighodela, lekeni si hambele he Imulungu bae. ");
INSERT INTO ruf_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Angu Ghamaandiko gholongatse? Gholonga, “Abrahamu tsakamtoghola Imulungu, apfo koneka kanogha hambele he Imulungu.” ");
INSERT INTO ruf_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Imunu hayosang'ana, ng'olihighwa bae ka ghweko, ila kolihighwa ka maliho. ");
INSERT INTO ruf_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Lekeni awala ing'awohuwila ghamatendo ghawo ghanoghile, ila womtoghola Imulungu, kwa ukutoghola kwawo Imulungu kowapeta wanogha kuna yeye. Imulungu yowatenda iwanu wehile woneke wahela nzambi. ");
INSERT INTO ruf_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Daudi tsakalonga chinu chichino, hayalongile ukubweda kwe imunu yula iyopetighwa kanogha kwe Imulungu bila kulola chatendile. ");
INSERT INTO ruf_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Wabweda awala iwaleghusighwe matotso ghawo, na nzambi tsawo itsileghusighwe. ");
INSERT INTO ruf_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Kabweda imunu yula nzambi tsake ing'atsipetighwa bae ne Imtwatsa!” ");
INSERT INTO ruf_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Pfii ukubweda kuno, wobweda awala Wayahudi iwekema iwengile ngoma waliyeka au pfipfila na awala iwanu iwali si Wayahudi iwokemighwa ing'awengile ngoma bae? Ka pfanongole kulonga, Abrahamu tsakamtoghola Imulungu na kwa ukutoghola kwake kapetighwa kana haki. ");
INSERT INTO ruf_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Lelo apetelighwe tsuwachi ka kana haki? Hala hang'ali ng'ana yengile ngoma au hengile ngoma? Tsakapetighwa kana haki hang'ali ng'ana yengile ngoma na si hengile ngoma bae! ");
INSERT INTO ruf_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Abrahamu tsakengila ngoma hambele, na kwingila ngoma kwake tsakukala chitango cha ukulangusa ka Imulungu kamtenda kana haki kwaajili ya ukutoghola kwake hala ng'ana yengile ngoma. Apfo Abrahamu kawa aba we iwanu iwomtoghola Imulungu hata ka ng'awengile ngoma bae ili Imulungu yawapete wana haki. ");
INSERT INTO ruf_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Pfipfila Abrahamu ka aba wa awala iwengile ngoma, lekeni si kwa kwingila ngoma kuliheka bae, ila kwaapfila woiwinza nzila ila ya ukutoghola yakalile nayo aba wetu Abrahamu yaiwinzile ahala ng'ana yengile ngoma. ");
INSERT INTO ruf_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Imulungu tsakamlongela Abrahamu ne iwatsukulu wake ka isi yose ing'awile yawo. Watsoibokela isi yose si kwaapfila Abrahamu tsakatenda ka ghamalaghitso pfaghalongile, ila kwaapfila kamtoghola Imulungu, Imulungu kamtenda kana haki. ");
INSERT INTO ruf_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Kwaapfila ka aghala ghayalongile Imulungu wakwing'ighwa iwanu wala iwoghakinda Ghamalaghitso waliheka, lelo ukutoghola kutsakuwa kwahela sang'ano, na pfipfila chayalongile Imulungu chitsakuwa chahela sang'ano. ");
INSERT INTO ruf_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Ghamalaghitso ghoghala maya ye Imulungu, lekeni ka kuduhu Ghamalaghitso, kung'akalile kuduhu matotso. ");
INSERT INTO ruf_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Apfo, laghano lyehuwila ukutoghola, ili laghano lila lyoneke ghweko lye Imulungu kwa kolo tsose tsa Abrahamu, si kwa awala iwoghakinda Ghamalaghitso waliyeka, ila pfipfila kwa awala iwotoghola ka pfayatendile Abrahamu, iyali aba wetu wose. ");
INSERT INTO ruf_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Ka Ghamaandiko Mahenzeluka pfagholonga, “Nikusaghula uwe aba wa makabila mengi.” Yeye ka aba wetu hambele he Imulungu iyamtoghole. Imulungu iyoweng'a ughima iwanu iwafile na kwa laghitso lyake, ipfinu ing'apfili baho pfakuwa baho. ");
INSERT INTO ruf_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Hata hakukalile haduhu ichinu ichimtendile Abrahamu alolele laghano, Abrahamu kamtoghola Imulungu na kulilolela laghano, apfo kawa aba wa ghamakabila ghose. Ka Ghamaandiko Mahenzeluka pfagholonga, “Mweleko ghwako ghutsakuwa ketseketse ka tsinondo!” ");
INSERT INTO ruf_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Abrahamu tsakalala, na miyaka yake tsaikala ka miya imwe, lekeni yeye tsakatoghola ghendo, hata ka tsakamanya ng'odaha bae kupata imwana, na mwehe wake Sara ng'adahile bae kweleka. ");
INSERT INTO ruf_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Abrahamu ng'alekile bae kulitoghola laghano lye Imulungu, ila kapata ingupfu kwa ukutoghola kwake, apfo kamtunitsa Imulungu. ");
INSERT INTO ruf_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Tsakamanya ghendo ka Imulungu kodaha kughatenda aghala ghalaghane naye. ");
INSERT INTO ruf_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Apfo kwa ukutoghola kwake, “Imulungu kampeta Abrahamu ka imunu yanoghile kuna yeye.” ");
INSERT INTO ruf_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Mbuli ino “tsakapetighwa kanogha kwe Imulungu,” tsang'ayandikighwe kwaajili ya Abrahamu yaliheka bae, ");
INSERT INTO ruf_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","ila na twetwe pfipfila yatupetighwa tunogha kwe Imulungu yatumtoghola, iyamtsilihule Imtwatsa wetu Yesu. ");
INSERT INTO ruf_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Yeye tsakalapfighwa yafe kwaajili ya nzambi tsetu, kuya katsilihuka ili tupetighwe tunogha kwe Imulungu. ");
INSERT INTO ruf_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Apfo kwa ukutoghola tutendighwa twahela matotso hambele he Imulungu, lelo twokala tseghamba ne Imulungu kubitila Imtwatsa wetu Yesu Kiristu. ");
INSERT INTO ruf_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Kwa ukutoghola kwetu, Yesu katughala kune uluso we Imulungu, na bila kupfuka twololela utunitso we Imulungu. ");
INSERT INTO ruf_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Si chinu acho chiliheka bae, pfipfila toghadeng'elela maghayo ghetu, kwaapfila twomanya maghayo ghoghala ukududumila, ");
INSERT INTO ruf_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ukududumila kwoghala ukutogholighwa ne Imulungu, na ukutogholighwa ne Imulungu koghala lolelo. ");
INSERT INTO ruf_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Lolelo ng'alimghela imunu chinyala bae, kwaapfila Imulungu kawika unoghelo wake mmimoyo mwetu kubitila Ghumuhe Mwenzeluka iyatwing'ile twetwe. ");
INSERT INTO ruf_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Mana hatung'ali twahela ngupfu, Kiristu tsakafa kwaajili ya iwanu wehile. ");
INSERT INTO ruf_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Pfikomu kwe imunu wowose ukufa kwaajili ya imunu yane haki, lekeni yodahika imunu ukufa kwaajili ya imunu yanoghile. ");
INSERT INTO ruf_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Lekeni Imulungu katulangusa pfotunoghela. Hatung'ali twawanzambi, Kiristu tsakafa kwaajili ya twetwe. ");
INSERT INTO ruf_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Kwaapfila kwa idamu yake tupetighwa twahela nzambi, tutsokombolighwa ghendo na yeye mne maya ye Imulungu! ");
INSERT INTO ruf_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Kwaapfila hatukalile wehile we Imulungu, tsakatulamlitsa naye kubitila lifwa lye Imwanaghe. Kwaapfila sambi tulamlitsighwa naye, tutsokombolighwa ghendo kubitila ughima wake! ");
INSERT INTO ruf_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Lekeni si agho ghaliyeka bae, ila wose twodeng'elela kwa aghala ghatendile Imulungu kubitila Imtwatsa wetu Yesu Kiristu iyatulamlitse ne Imulungu. ");
INSERT INTO ruf_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Nzambi tsaingila muisi kubitila imunu yumwe na lifwa lingila kubitila nzambi. Apfo lifwa liwatsila iwanu wose, kwaapfila wose tsawatenda nzambi. ");
INSERT INTO ruf_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Hala ng'ana Ghamalaghitso gha Musa ghalapfighwe bae, nzambi tsayamuisi. Lekeni nzambi ng'aipetighwe bae ka nzambi hala hakukalile kuduhu Ghamalaghitso. ");
INSERT INTO ruf_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Lekeni Iifwa tsalitawala kulawa ghamatsuwa gha Adamu mbaka ghamatsuwa gha Musa, na hata kwa awala ing'awatendile nzambi ka nzambi iyatendile Adamu. Adamu tsakakala chitango cha Kiristu iyatsile hambele. ");
INSERT INTO ruf_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Lekeni ghweko lye Imulungu ng'alighala bae na totso lya Adamu. Mana hata ka iwanu wengi tsawafa kwa totso lya imunu yumwe, Imulungu katsakongetsa uluso wake na ghweko ilikwenela kwa iwanu wengi, kulawa kwa imunu yumwe, iyo Yesu Kiristu. ");
INSERT INTO ruf_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Ghweko lya Imulungu ng'alighala bae na totso lye imunu yumwe. Kwaapfila imunu yumwe hayatotsile, Imulungu tsakahigha, lekeni hala hawatotsile iwanu wengi, Imulungu kaghala ghweko lya ukuwapeta iwanu wanogha. ");
INSERT INTO ruf_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Kwa nzambi ya imunu yumwe, lifwa tsalitawala kubitila imunu ayo yumwe. Lekeni yolangusa ghendo, chayatendile imunu yula yumwe, Yesu Kiristu, chikulu sideke. Wose iwobokela uluso mkulu we Imulungu na ghweko kulu lye kupetighwa wanogha kwe Imulungu, watsotawala mne ughima kubitila Yesu Kiristu. ");
INSERT INTO ruf_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Lelo ka totso limwe litenda iwanu wose wahighighwe, pfipfila chinu chimwe chinoghile chowakombola iwanu wose na choweng'a ughima. ");
INSERT INTO ruf_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Kwaapfila kwa ukuleka kuhulikitsa kwa imunu yumwe, iwanu wengi tsawengila mnzambi, apfo pfipfila kwa ukuhulikitsa kwa imunu yumwe, iwanu wengi tsawatendighwa wanogha kwe Imulungu. ");
INSERT INTO ruf_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Ghamalaghitso tsaghalawila ili ghamatotso ghongetseke, lekeni nzambi hayongetseke, uluso we Imulungu nawo tsawongetseka ghendo. ");
INSERT INTO ruf_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Ka nzambi pfaitawale mne lifwa, pfipfila uluso we Imulungu utsotawala kubitila ukunogha kwe Imulungu, na kughala ughima wa ghamatsuwa ghose kubitila Yesu Kiristu Imtwatsa wetu. ");
INSERT INTO ruf_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Lelo tulonge choni? Apfi tughendelele kukala mnzambi ili uluso we Imulungu wongetseke? ");
INSERT INTO ruf_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Mbe! Twetwe tufa mne nzambi, lelo tudahatse kukala keli mne nzambi? ");
INSERT INTO ruf_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Angu ng'ammanyile bae ka hatubatitsighwe tsatwilunga na Kiristu Yesu? Twetwe tsatwilunga mne lifwa lyake kwa kubatitsighwa. ");
INSERT INTO ruf_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Kuya hatubatitsighwe tsatutsikighwa hamwe naye na twilunga mne lifwa lyake, ili ka Kiristu pfayasilihuke kulawa mne lifwa kwa utunitso wa Aba, pfipfila na twetwe tudahe kukala mne ughima wa sambi. ");
INSERT INTO ruf_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Kwaapfila ka twilunga naye mne ukufa, pfipfila twitselunga naye mne ukutsilihuka. ");
INSERT INTO ruf_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Kwaapfila twomanya unu wetu wa ghumwande uwambighwa hamwe na Kiristu mne msalaba ili ngupfu ye nzambi mlukuli mwetu ihinyighwe, ili tuleke kuwa watumwa we nzambi keli. ");
INSERT INTO ruf_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Kwaapfila hatukufa mne nzambi, twokombolighwa kulawa mne nzambi. ");
INSERT INTO ruf_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Lelo ka tufa naye Kiristu, twotoghola ka tutsokala naye. ");
INSERT INTO ruf_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Kwaapfila twomanya Kiristu tsakasilihuka, naye ng'akufa keli bae, lifwa ng'alimtawala keli bae. ");
INSERT INTO ruf_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Apfo kwaapfila tsakafa mala lumwe, nzambi yahela ngupfu keli kuna yeye, na ughima woyokala, kokala hamwe ne Imulungu. ");
INSERT INTO ruf_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Pfipfila namwe mwipete muwenyegho ka mfa mne nzambi, lekeni mwa waghima kwe Imulungu kubitila Yesu Kiristu. ");
INSERT INTO ruf_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Apfo nzambi ileke kutawala mne ng'uli tsenu itsikufa, ili mleke kutsiwinza dong'o tsa lukuli. ");
INSERT INTO ruf_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Mleke kulapfa pfilungo pfe ng'uli tsenu pfitende ghehile, ila mwilapfe iwenyegho kwe Imulungu, ka iwanu imtsihulighwe kulawa mne lifwa, pfilapfeni pfilungo pfenu kwe Imulungu pfisang'ane aghala ighanoghile ka pfayobama Imulungu. ");
INSERT INTO ruf_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Nzambi ng'aitsowatawala keli bae, kwaapfila mwemwe ng'amlongosighwa na ghamalaghitso, ila mwolongosighwa na uluso. ");
INSERT INTO ruf_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Lelo tulonge choni? Angu tutende ghehile kwaapfila ng'atulongotsighwa na ghamalaghitso bae, ila twolongotsighwa na uluso? Si pfipfo bae! ");
INSERT INTO ruf_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Mwemwe mwomanya ghendo ka hamwilapfa muwenyegho ka watumwa kumtegheletsa imunu yungi, mwemwe mwakuwa watumwa wa ayula yamumtegheletsa. Mng'awa watumwa we nzambi mtsomalila mlifwa, mng'awa watumwa we ukutegheletsa mtsakoneka mnogha kwe Imulungu. ");
INSERT INTO ruf_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Lekeni mighede kwe Imulungu, kwaapfila hata ka tsamwawatumwa wa nzambi, lekeni sambi mwoghakinda kwa ghumoyo ghwenu ghwose aghala ghose ighali mne malangulitso ighambokele. ");
INSERT INTO ruf_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Mwemwe tsamkombolighwa kulawa mne nzambi, na muwa watumwa we aghala ghobama Imulungu mghatende. ");
INSERT INTO ruf_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Hano silonga bae mbuli ng'omu kwaapfila mwemwe ng'amdaha kumanya chanilonga. Ka ghumwande pfamtoghole kuwa watumwa wa ghehile na matotso, pfipfila sambi mtoghole kuwa watumwa wa aghala ghobama Imulungu ili mwenzelusighwe. ");
INSERT INTO ruf_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Kwaapfila hamuwile watumwa we nzambi, tsamkala ng'amlongotsighwa na aghala ghobama Imulungu. ");
INSERT INTO ruf_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Angu chambwedile choni ghamatsuwa ghala hamtendile aghala sambi ighakoneka chinyala kuna mwemwe? Kwaapfila aghala ghamtendile ghoghala lifwa. ");
INSERT INTO ruf_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Lekeni sambi mkombolighwa mne nzambi, na muwa watumwa we Imulungu. Chambweda sambi iwo uhenzeluka, nawo woghala ughima wa ghamatsuwa ghose. ");
INSERT INTO ruf_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Kwaapfila maliho ghe nzambi lifwa, lekeni ghweko lye Imulungu iwo ughima wa ghamatsuwa ghose kwa kwilunga na Yesu Kiristu, Imtwatsa wetu. ");
INSERT INTO ruf_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Ndughu tsangu, mwoghamanya ghendo agho ghanilonga, kwaapfila nolonga ne iwanu iwomanya ghamalaghitso. Ghamalaghitso ghomtawala imunu hayakuwa mghima. ");
INSERT INTO ruf_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Tulonge, ipinga hayokwelighwa, kohighwa na ghamalaghitso hala immale ayo ang'awa mghima, lekeni mmale wake ang'afa, ipinga ayo ng'ohighwa bae na ghamalaghitso. ");
INSERT INTO ruf_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Lelo ipinga ang'akala na mmale yungi aku mmale wake yang'ali mghima, ipinga ayo katsokemighwa mghoni. Lekeni mmale wake ang'afa, ng'ohighwa keli bae ne ghamalaghitso, si mghoni bae hata ang'akwelighwa na mmale yungi. ");
INSERT INTO ruf_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Pfipfila namwe ndughu tsangu, ng'amlongotsighwa bae na ghamalaghitso kwaapfila mwilunga na lukuli lwa Kiristu, ili muwe wanu wa imunu yungi, yuyo iyatsilihuke, ili tumsang'anile pfinoghile Imulungu. ");
INSERT INTO ruf_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Hatung'ali twokala kuno twolongotsighwa na lukuli, dong'o tsa lukuli tsatsisongesighwa ne ghamalaghitso, tsisang'ana mne ng'uli tsetu, na ghose ghatutendile ghamalila mne lifwa. ");
INSERT INTO ruf_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Lekeni sambi ng'atwohighwa bae na ghamalaghitso, kwaapfila tufa kwa mbuli ila itutendile watumwa, ili tutumikile kwa ughima wa sambi we Ghumuhe Mwenzeluka, na si kwa nzila ila ye ghumwande ye ghamalaghitso ighandikighwe. ");
INSERT INTO ruf_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Lelo tulonge choni? Angu Ghamalaghitso nzambi? Bae! Lekeni kubitila Ghamalaghitso tsanimanya nzambi chinu chachi. Ka ghamalaghitso ng'aghalongile bae, “Uleke kusulukila chinu cha miyagho,” tsaning'alekile kumanya ka kusulukila chinu chachi. ");
INSERT INTO ruf_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Kwa ndaghitso ayo, nzambi tsaipata uleghelo wa kulamsa chila ukusulukila kwihile ikuli mghati mwangu. Kwaapfila bila ghamalaghitso nzambi ifa. ");
INSERT INTO ruf_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Ghumwande tsaning'ali namghima bila ya ghamalaghitso, lekeni ndaghitso haitsile, nzambi tsayenela mne ughima wangu na nene tsang'ala ka nyifa. ");
INSERT INTO ruf_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Tsambona ndaghitso ayo iibamighwe ighale ughima, lekeni kuna nene inighalila lifwa. ");
INSERT INTO ruf_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Mana nzambi tsaipata nyafwasi kubitila ndaghitso ila, ingutsukila, inikoma. ");
INSERT INTO ruf_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Apfo lelo, Ghamalaghitso ghahenzeluka na ndaghitso ihenzeluka, ghomnoghelesa Imulungu na ghanogha. ");
INSERT INTO ruf_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Lelo achila ichinoghile chingalila lifwa? Si pfipfo bae! Itendeka apfo ili nzambi itangike ka nzambi ghendo. ichitumila achila ichinoghile na kung'alila lifwa lyangu. Apfo nzambi kubitila ndaghitso, ilangusa ghendo pfaihile ng'ani. ");
INSERT INTO ruf_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Twomanya ka Ghamalaghitso gholawa mghati mwe Muhe, lekeni nene si wa Muhe bae, nihutsighwa niwe mtumwa wa nzambi. ");
INSERT INTO ruf_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Simanyile bae chonitenda, kwaapfila aghala ighanibama sighatenda bae, lekeni aghala inighahila noghatenda. ");
INSERT INTO ruf_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Lekeni ning'atenda aghala sighabama bae kughatenda, notoghola ghendo ka Ghamalaghitso ghanogha. ");
INSERT INTO ruf_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Lelo si nene bae nimwenyegho yanitenda ghano, ila nzambi iikala mghati mwangu. ");
INSERT INTO ruf_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Nomanya ghendo ka kuduhu ilinoghile lyolyose ilikala mghati mwangu, mne lukuli lwangu lwa nzambi. Kwaapfila nobama kutenda ghanoghile, lekeni sidaha bae. ");
INSERT INTO ruf_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Kwaapfila sighatenda bae ghanoghile ghanibama kughatenda, lekeni noghatenda ghehile aghala sighabama bae kughatenda. ");
INSERT INTO ruf_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Ka notenda aghala sighabama bae kughatenda, si nene bae yanitenda, ila nzambi iikala mghati mwangu iyo iitenda agho. ");
INSERT INTO ruf_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Apfo nitanga chinu chino, hanibama kutenda ghanoghile, ghehile nagho ghabaho. ");
INSERT INTO ruf_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Lekeni mghati mwangu ghendo noghadeng'elela ghamalaghitso gha Imulungu. ");
INSERT INTO ruf_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Lekeni nakona mbuli ingi iisang'ana mlukuli mwangu. Mbuli ayo yesonga na mbuli iitogholighwa ne mbutsi tsangu. Mbuli ayo yonenda niwe mtumwa wa mbuli tsa nzambi itsisang'ana mlukuli mwangu. ");
INSERT INTO ruf_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Nene miyenu! Yuhi iyodaha kung'ombola mne lukuli luno ilunighala mne lifwa? ");
INSERT INTO ruf_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Mighede kwe Imulungu iyonikombola kubitila Yesu Kiristu Imtwatsa wetu! Lelo apfi pfipfo pfanili, nene mwenyegho mne mbutsi tsangu namtumwa we mbuli tse Imulungu, lekeni mna lukuli nene namtumwa wa mbuli tsa nzambi. ");
INSERT INTO ruf_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Apfo kuduhu ukuhighighwa kwa awala iwali mghati mwa Kiristu Yesu. ");
INSERT INTO ruf_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Kwaapfila kubitila Kiristu Yesu, mbuli ye Ghumuhe we ughima inikombola kulawa mna mbuli ya nzambi na lifwa. ");
INSERT INTO ruf_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Imulungu katenda achila ing'achidahika bae kutendeka na Malaghitso gha Musa mana lukuli lune nzambi lwahela ingupfu. Imulungu kamtuma Imwanaghe nyalimwe yane lukuli ka ng'uli tsetu twetwe tune nzambi ili awe nambiko ya nzambi, apfo kahigha nzambi kwa lukuli alwo. ");
INSERT INTO ruf_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Imulungu katenda apfo ili ukuhighighwa ikubamighwa na Malaghitso kutimile mghati mwetu, twetwe itukala kwa ngupfu tsa Ghumuhe Mwenzeluka, na si kwa ngupfu tsa lukuli lune nzambi. ");
INSERT INTO ruf_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Awala iwokala kwa kuwinza ulukuli, mbutsi tsawo tsolongotsighwa na aghala gholubama lukuli. Lekeni awala iwokala kwa kumuwinza Ghumuhe Mwenzeluka, mbutsi tsawo tsolongotsighwa na aghala ghoyobama Ghumuhe. ");
INSERT INTO ruf_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Kwaapfila mbutsi itsilongotsighwa na lukuli lune nzambi tsoghala lifwa, lekeni mbutsi itsilongotsighwa na Ghumuhe tsoghala ughima na tindiwalo. ");
INSERT INTO ruf_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Imunu ang'apfikitsa mbuli itsibama lukuli lwake luliheka, ayo kakuwa mwihile we Imulungu, kwaapfila ng'okinda bae mbuli ye Imulungu, na ng'odaha bae kuikinda. ");
INSERT INTO ruf_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Awala iwolongotsighwa na lukuli lune nzambi ng'awodaha bae kumnogheletsa Imulungu. ");
INSERT INTO ruf_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Lekeni mwemwe, Ghumuhe we Imulungu ang'akala mghati mwenu, ng'amlongotsighwa bae na lukuli, ila mwolongotsighwa ne Ghumuhe. Ka imunu wowose kahela Ghumuhe wa Kiristu, ayo si munu wa Kiristu bae. ");
INSERT INTO ruf_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Lekeni ka Kiristu ka mghati mwenu, Ghumuhe komwing'ani ughima, kwaapfila mwemwe mpetighwa ne Imulungu mnogha hata ka ng'uli tsenu tsitsakufa kwaajili ya nzambi. ");
INSERT INTO ruf_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Na ka Ghumuhe wa ayula iyamtsilihule Yesu kulawa mlifwa kokala mghati mwenu, yuyo iyamtsilihule Yesu pfipfila katsotsing'a ughima ng'uli tsenu itsikufa. Katsotenda apfo kwa Ghumuhe wake, iyokala mghati mwenu. ");
INSERT INTO ruf_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Apfo ndughu tsangu, tuna sang'ano, ng'atubamighwa bae kukala ka ng'uli tsetu tsine nzambi pfatsibama tukale. ");
INSERT INTO ruf_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Kwaapfila mng'akala ka ng'uli pfatsibama, mtsakufa ghendo. Lekeni ka kubitila Ghumuhe mwoghakoma aghala ghehile ighatendighwe na lukuli, mtsokala waghima. ");
INSERT INTO ruf_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Mana awala wose iwolongotsighwa na Ghumuhe we Imulungu awo iwo iwana wa Imulungu. ");
INSERT INTO ruf_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Kwaapfila ng'ambokele bae Ghumuhe iyowatenda muwe watumwa keli wa kupfuka, lekeni mbokela Ghumuhe iyowatenda muwe iwana wa Imulungu. Apfo twokemelela, “Aba, Aba!” ");
INSERT INTO ruf_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Ghumuhe we Imulungu mwenyegho kolongesa hamwe na muhe tsetu ka twetwe twa iwana we Imulungu. ");
INSERT INTO ruf_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Lelo ka twawanaghe, apfo twawahatsi we Imulungu, twohatsi hamwe na Kiristu, mana ka tughanzika hamwe naye, pfipfila tutsokala naye mne utunitso wake. ");
INSERT INTO ruf_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Kwaapfila nomanya maghayo ghatughanzika sambi si chinu bae na ng'agheghala bae na utunitso ula iutsoghubulighwa kuna twetwe. ");
INSERT INTO ruf_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Pfilumbe pfose pfobetetsa kwa kusulukila ng'ani kughubulighwa kwe iwana we Imulungu. ");
INSERT INTO ruf_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Kwaapfila pfilumbe pfose pfitendighwa pfiwe si chinu bae, si ka tsapfibama pfenyegho, ila kwaapfila Imulungu tsakabama iwe apfo, hata apfo lolelo lyabaho, ");
INSERT INTO ruf_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","kwaapfila pfilumbe apfo napfo pfitsolekelighwa kulawa mne utumwa wa ukuhinyika, pfingile mne utunitso wa ukukombolighwa kwe iwana we Imulungu. ");
INSERT INTO ruf_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Kwaapfila twomanya mbaka sambi hano ka pfilumbe pfose pfoghutilila kwa usungu, ka usungu wokweleka imwana. ");
INSERT INTO ruf_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Si pfilumbe pfiliheka bae, ila na twetwe wenyegho yatuli na Ghumuhe, iyali ghweko lya Imulungu lya mwanduso, pfipfila twoghutilila kwa mghati aku twobeta kutendighwa kuwa iwana we Imulungu ghendo na kukombolighwa ng'uli tsetu. ");
INSERT INTO ruf_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Kwaapfila tsatukombolighwa mne lolelo alyo, lekeni ka chinu ichilolelighwa chakoneka, aho kuduhu keli lolelo. Angu munu wachi iyololela ichinu chayalinacho? ");
INSERT INTO ruf_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Lekeni tung'alolela chinu chila ing'atuchona bae, twobetetsa kwa kududumila. ");
INSERT INTO ruf_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Pfipfila, Ghumuhe kotwapfila twetwe mna ukuhungukighwa kwetu. Ng'atumanyile bae ukulomba ka pfaibamighwa, lekeni Ghumuhe imwenyegho kotulombela twetwe kwa kughutilila ing'akudaha kulongighwa. ");
INSERT INTO ruf_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Naye iyakona mmoyo mwetu, komanya Ghumuhe chayakwalangula, kwaapfila Ghumuhe kowalombela wahenzeluka ka pfoyobama Imulungu. ");
INSERT INTO ruf_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Twomanya ghendo ka mne pfinu pfose Imulungu kotenda ghose ghanoghe kwe iwanu wala iwomnoghela, awala iwakemighwe ka yeye pfayabamile. ");
INSERT INTO ruf_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Awala Imulungu yawamanyile kulawa ghumwande, tsakalamula kulawa ghumwande weghale ne Imwanaghe, ili Imwana ayo yawe chaudele mna ndughu wengi. ");
INSERT INTO ruf_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Na awala iyawasaghule, tsakawakema, na awala iyawakemile, kawapeta wanogha, na awala iyawapetile wanogha tsakahangila nawo utunitso wake. ");
INSERT INTO ruf_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Kuya lelo tulonge choni mna ghano ghose? Ka Imulungu ka lubali lwetu, yuhi iyodaha kutubelela? ");
INSERT INTO ruf_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Imulungu ng'amwonele bae libatsi hata Imwanaghe imwenyegho, ila kamlapfa kwaajili ya twetwe twose! Katwing'a imwanaghe, angu ng'atsotwing'a bae pfinu pfose hamwe naye? ");
INSERT INTO ruf_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Yuhi yatsoweng'a lighomba iwanu iyawasaghule Imulungu? Imulungu mwenyegho kolonga wahela matotso. ");
INSERT INTO ruf_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Lelo yuhi yatsowahigha? Kuduhu! Kwaapfila Yesu Kiristu tsakafa, kuya katsilihulighwa! Na kokala ghumoko ghwa kujilo ghwe Imulungu, naye yuyo iyotulombela. ");
INSERT INTO ruf_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Yuhi lelo yatsotubaghula kulawa mna unoghelo wa Kiristu? Pfii maghayo, ukughanzika, ukudununzika, nzala, ukukala chidako, ukuhonzeka au ukukomighwa? ");
INSERT INTO ruf_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Ka Ghamaandiko Mahenzeluka pfogholonga, “Kwaajili yako twokala mlifwa chilo ne imisi. Tweghala ne iwang'olo iwoghenda kuchinjighwa.” ");
INSERT INTO ruf_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Bae, mna ghano ghose twetwe tuhuma ghendo kubitila yeye iyotunoghela. ");
INSERT INTO ruf_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Kwaapfila tsanimanya ghendo kuduhu ichinu ichidaha kutubaghula na unoghelo wake, si lifwa bae wala ughima, si wamalaika wala pfinyamkela wane ingupfu, si pfinu pfa sambi wala ipfikutsa, ");
INSERT INTO ruf_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","si ighali hasi, wala ighali kuchanya, wala chochose ichilumbighwe, kuduhu ichidaha kutubaghula na unoghelo we Imulungu iuli mghati mwa Kiristu Yesu Imtwatsa wetu. ");
INSERT INTO ruf_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Nolongesa ghendo, nene na imunu wa Kiristu, silonga ughutsu bae. Ghumoyo ghwangu ghwetoghola hamwe ne Ghumuhe Mwenzelukaka ka nene sighutsuka bae, ");
INSERT INTO ruf_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","ka noghanzika sideke na nina usungu ing'aumalagha bae mna ghumoyo ghwangu. ");
INSERT INTO ruf_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Mana ning'adahile kulomba nilighitwe na mbaghulighwe na Kiristu kwaajili ye Wayahudi, iwanu wa kabila lyangu. ");
INSERT INTO ruf_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Awo iwo iwanu wa Isiraeli Imulungu iyawatendile wawe iwanaghe, iyawalanguse utunitso wake, iyalaghane nawo, iyaweng'ile Ghamalaghitso ghake, nzila ya ukumtamanila yeye na malaghano ghake. ");
INSERT INTO ruf_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Wawo wa watsukulu wa iwabala wa Wahebraniya, naye Kiristu, mne unu wake, kalawila mne kabila lyawo. Imulungu iyotawala mna ghose, na yatunyighwe ghamatsuwa ghose! Ona. ");
INSERT INTO ruf_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Chalaghane Imulungu ng'achilekile bae kutimila, kwaapfila si Waisiraeli wose iwo wanu we Imulungu. ");
INSERT INTO ruf_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Na si watsukulu wose wa Abrahamu wa iwana we Imulungu. Lekeni Imulungu tsakamlongela Abrahamu, “Watsukulu wako watsolawila kwa Isaka.” ");
INSERT INTO ruf_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Mana iwana wala iwelekighwe kwa lukuli, awo si iwana we Imulungu bae, ila iwana wala iwelekighwe kwa laghano lya Imulungu awo iwo iwopetighwa iwana wa Abrahamu. ");
INSERT INTO ruf_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Kwaapfila Imulungu tsakeka laghano lyake pfino, “Mne chipindi ichanisaghule nitsakuya na Sara katsakweleka imwana.” ");
INSERT INTO ruf_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Si pfipfo pfiliheka bae, ila Rebeka naye tsakakala na iwana weli kwa aba yumwe, ayo iyo imbala wetu Isaka. ");
INSERT INTO ruf_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","Hata ng'ana iwana awo weli welekighwe bae, na ng'ana watende ichinu chochose chinoghile au chihile, Imulungu kakoneka kana uwetso wa kusaghula. ");
INSERT INTO ruf_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","Yeye hayosaghula kosaghula ka pfobama mwenyegho, ng'olola bae chayotenda imunu. Imulungu tsakamlongela Rebeka, “Imwana mbala katsomsang'anila imdodo wake.” ");
INSERT INTO ruf_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Ka pfayandikighwe mne Ghamaandiko Mahenzeluka, “Yakobu kaninoghela lekeni Esau nimuhila.” ");
INSERT INTO ruf_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Lelo tulonge choni? Pfii Imulungu kana ubaghutsi? Aka si pfipfo bae! ");
INSERT INTO ruf_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Kwaapfila tsakamlongela Musa, “Nitsomwonela libatsi imunu yula iyanibama kumwonela libatsi, nitsomdudumila imunu yula iyanibama kumdudumila.” ");
INSERT INTO ruf_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Apfo, ghose ghouhila libatsi lye Imulungu na si choyobama imunu bae au choyosang'ana imunu. ");
INSERT INTO ruf_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Kwaapfila Ghamaandiko Mahenzeluka gholonga pfino kwa Farao mndewa wa Misiri, “Tsanikutenda uwe mndewa ili nilanguse ngupfu tsangu kubitila ghweghwe na taghwa lyangu limanyike muisi mwose.” ");
INSERT INTO ruf_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Apfo, Imulungu komonela libatsi imunu yula iyobama kumonela libatsi, na iyobama kumtenda yawe msughu komtenda yawe msughu. ");
INSERT INTO ruf_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Yumwe wenu kodaha kunongela, “Lelo ule Imulungu ang'ali yotulaumu? Yuhi yodaha kughaghoma aghala ghoyobama Imulungu?” ");
INSERT INTO ruf_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Lekeni ghweghwe uli nani, yumwidika Imulungu apfo? Chiha ng'achidaha bae kumghutsa mfina pfiha, “Ule kunenda pfino?” ");
INSERT INTO ruf_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Mfina pfiha kodaha kufina pfiha pfibili kwa lidongo limwe ka pfayobama, chimwe kwa sang'ano ng'ulu ngulu na chingi kwa sang'ano ndodo ndodo. ");
INSERT INTO ruf_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Apfi pfipfo pfaili kwa Imulungu. Tsakabama kulangusa maya yake na ingupfu yake, lekeni tsakawadudumila iwanu wala iwabamighwe wahighighwe na maya yake, awo iwobamighwa kuhinyighwa. ");
INSERT INTO ruf_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Naye imwenyegho tsakabama kuulangusa utunitso wake mkulu, iyaughighidile kuna twetwe itubamighwe kubokela libatsi lyake, twetwe iyatwikile kulawa ghumwande tubokele utunitso wake. ");
INSERT INTO ruf_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Twetwe iwo iyatukemile, si kulawa kwa Wayahudi waliheka bae, ila kulawa kwa iwanu wa isi tsingi pfipfila. ");
INSERT INTO ruf_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Ka Imtwatsa pfayalongile mna chitabu cha nabii Hosea, “Awala iwali ‘si iwanu wangu bae,’ nitsowakema ‘iwanu wangu.’ Nitsolangusa unoghelo wangu kune isi tsila ng'ana nitsinoghele bae.” ");
INSERT INTO ruf_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Kuya, “Hanu hala hawalongelighwe, ‘Mwemwe si iwanu wangu bae,’ baho watsokemighwa iwana we Imulungu iyali mghima.” ");
INSERT INTO ruf_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Pfipfila nabii Isaya kowamanila Waisiraeli hala hayalongile, “Hata ka iwanu wa Isiraeli wa wengi ka msanga ghuli kumwani, lekeni wanu wadodo waliheka iwatsokombolighwa. ");
INSERT INTO ruf_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Kwaapfila Imulungu ng'atsokawa bae kuihigha ghendo isi yose.” ");
INSERT INTO ruf_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Ka nabii Isaya pfayalongole kulonga, “Ka Imtwatsa yane ngupfu ng'atulekele bae mweleko wa Waisiraeli, wose tung'afile ka iwanu Sodoma, tung'eghalile na iwanu wa Gomola.” ");
INSERT INTO ruf_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Lelo tulonge choni? Iwanu iwali si Wayahudi bae, ng'awasang'ane chinu ili woneke ne Imulungu wanogha, tsawoneka ne Imulungu wanogha kwa ukutoghola kwawo, ");
INSERT INTO ruf_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","lekeni Waisiraeli, iwabamile ukutogholighwa ne Imulungu kubitila ghamalaghitso, ng'awoneke wanogha kwe Imulungu. ");
INSERT INTO ruf_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Ule ng'awoneke wanogha kwe Imulungu? Kwaapfila tsawehuwila aghala ghawatendile, ng'awehuwile bae ukutoghola. Apfo tsawekwala mne “libwe lya kwikwalila.” ");
INSERT INTO ruf_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Ka pfayandikighwe, “Nyika libwe ako Sayuni, nalyo litsowatenda iwanu wekwale, nyika libwe iliwatenda iwanu waghwe. Lekeni imunu wowose iyomtoghola ng'atsoghelighwa chinyala bae.” ");
INSERT INTO ruf_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Ndughu tsangu, ghumoyo ghwangu ghwobama ghendo na nomlomba Imulungu Waisiraeli weyangu wakombolighwe. ");
INSERT INTO ruf_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Mana nowalongelani ghendo, wawo welapfa ghendo kumsang'anila Imulungu, lekeni si kwa kumanya pfinoghile bae. ");
INSERT INTO ruf_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Kwaapfila ng'awamanyile bae Imulungu pfayowatenda iwanu wanogha hambele hake, nawo wandusa inzila yawo iwenyegho, ng'awoiwinza bae inzila ye Imulungu ya kuwatenda iwanu wanogha hambele hake. ");
INSERT INTO ruf_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Kwaapfila Kiristu hayatsile, ghamalaghitso ghatimila, ili chila munu iyotoghola yapetighwe kanogha kwe Imulungu. ");
INSERT INTO ruf_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Mne mbuli ye ukutogholighwa ne Imulungu kubitila ukukinda Ghamalaghitso Musa kandika pfino, “Imunu wowose iyoghakinda Ghamalaghitso katsakuwa mghima kubitila Ghamalaghitso agho.” ");
INSERT INTO ruf_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Lekeni imbuli ya ukutogholighwa ne Imulungu kubitila ukutoghola ya pfino, “Uleke kulonga mmoyo mwako, yuhi yatsogheluka mbaka kulanga yamghale Kiristu hasi yatse kutukombola?” ");
INSERT INTO ruf_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","au ukulonga, “Yuhi yatsohulumka kutsimu yamwinule Kiristu kulawa mlifwa yatse kutukombola?” ");
INSERT INTO ruf_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Lekeni Ghamaandiko Mahenzeluka gholonga pfino. “Imbuli ye Imulungu yahabehi naghwe, ya mumlomo mwako na ya mmoyo mwako.” Ayo iyo imbuli ya ukutoghola yatuwapetela iwanu. ");
INSERT INTO ruf_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Ung'atoghola kwa ukulonga kwa mlomo wako, Yesu kamndewa, na ung'atoghola mmoyo mwako ka Imulungu kamtsilihula kulawa mlifwa, kutsokombolighwa. ");
INSERT INTO ruf_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Kwaapfila kwa ghumoyo imunu kotoghola na kakoneka kanogha kwe Imulungu, na kwa mlomo imunu kolonga na kokombolighwa. ");
INSERT INTO ruf_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Ka Ghamaandiko Mahenzeluka pfagholonga, “Imunu wowose iyomtoghola ng'atsoghelighwa chinyala bae.” ");
INSERT INTO ruf_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Mana kuduhu ubaghutsi kwa Myahudi wala kwa imunu iyali si Myahudi bae, kwaapfila Imulungu ka Imtwatsa we iwanu wose na kamluso kwe iwanu wose iwomlomba, ");
INSERT INTO ruf_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Mana ghamaandiko Mahenzeluka gholonga, “Chila imunu iyolomba kwa taghwa lya Imtwatsa, katsokombolighwa.” ");
INSERT INTO ruf_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Lelo watsomlombatse ayula ng'ana wamtoghole bae? Kuya watsomtogholatse ayula ng'ana wahulike bae mbuli tsake? Na watsohulikatse ka kuduhu bae imunu wa kuwapetela? ");
INSERT INTO ruf_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Na iwanu watsopetatse Imbuli Inoghile ka ng'awaghalighwe bae? Ka pfayandighwe, “Kunogha ghendo ukutsa kwa iwanu wala iwopeta Imbuli Inoghile!” ");
INSERT INTO ruf_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Lekeni si Waisiraeli wose bae iwatoghole Imbuli Inoghile ye Imulungu. Ka Isaya pfayalongile, “Imtwatsa, yuhi iyatoghole usenga wetu?” ");
INSERT INTO ruf_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Lekeni ukutoghola kwakutsa kubitila ukuhulika usenga, na usenga awo wakutsa kwa mbuli ya Kiristu. ");
INSERT INTO ruf_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Lekeni noghutsa, pfii ng'awahulike bae? Ona kuhulika wahulika, ka Ghamaandiko Mahenzeluka pfagholonga, “Litsi lyawo lyenela muisi mwose mbuli tsawo tsipfika muisi mwose.” ");
INSERT INTO ruf_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Noghutsa keli, pfii Waisiraeli ng'awamanyile bae? Imulungu tsakalongola kulonga kubitila Musa, “Nitsowatenda mwone chepfu kubitila iwanu wa isi tsingi. Nitsowatenda mwone maya kubitila iwanu ing'awamanyile.” ");
INSERT INTO ruf_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Imulungu tsakalonga kubitila Isaya bila kupfuka, “Tsamboneka kwe iwanu wala ng'ana wambame bae. Tsaniwalawila awala ing'awaghutsile bae mbuli tsangu.” ");
INSERT INTO ruf_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Lekeni kwa Waisiraeli, Imulungu kolonga, “Misi yose tsaniwagholosela ghumoko ghwangu kuwakema iwanu iwolema kutoghola na wasughu.” ");
INSERT INTO ruf_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Lelo noghutsa, Angu Imulungu kawalema iwanu wake? Mbe, ng'awalemile bae! Nene mwenyegho na Muisiraeli, mtsukulu wa Abrahamu, nolawila mne kabila lya Benjamini. ");
INSERT INTO ruf_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Imulungu ng'awalemile bae iwanu wake iyawamanyile kulawa mwanduso. Angu ng'ammanyile bae Ghamaandiko Mahenzeluka pfagholonga hala Eliya pfayamlilile Imulungu kwa nzambi tsa Waisiraeli? ");
INSERT INTO ruf_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“Imtwatsa, wawakoma manabii wako na wahahinya hanu hako hakulapfila nambiko. Yanisighale nene niliheka, nawo wobama wang'ome!” ");
INSERT INTO ruf_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Angu Imulungu tsakamwidikatse? Tsakamlongela, “Nyikila mwenyegho iwanu 7000, awo ng'awamtamanile bae mulungu Baali.” ");
INSERT INTO ruf_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Apfo pfipfo pfaili sambi, kuna iwanu chidogho iwasaghulighwe kwa uluso we Imulungu. ");
INSERT INTO ruf_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Wasaghulighwa kwa uluso wake, si kwa aghala ghawatendile bae. Kwaapfila ka Imulungu kosaghula kwa kulola chawotenda iwanu, apfo uluso wake ung'awile si chinu bae. ");
INSERT INTO ruf_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Lelo choni? Iwanu we Isiraeli ng'awachonile bae achila chawang'ali wochibama, lekeni awala iwasaghulighwe wachona. Wamwenga tsawatendighwa wasughu. ");
INSERT INTO ruf_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Ka pfagholonga Ghamaandiko Mahenzeluka, Imulungu kaweng'a imimoyo mikomu, kaweng'a tsinenge lekeni ng'awakona bae, kaweng'a maghutwi lekeni ng'awohulika bae mbaka leloli. ");
INSERT INTO ruf_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Naye Daudi kalonga, “Pfihungo pfawo pfiwe mtegho we kuwaghogha, waghwe na wahighighwe. ");
INSERT INTO ruf_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Nenge tsawo tsighelighwe chisi waleke kona. Mighongo yawo ipfeduke ghamatsuwa ghose.” ");
INSERT INTO ruf_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Noghutsa keli, pfii Wayahudi tsawekwala mbaka waghwa ghendo? Mbe, si pfipfo bae! Lekeni kwa ghamatotso ghawo ukukombolighwa kutsa kwe iwanu wangi ili Wayahudi wone chepfu. ");
INSERT INTO ruf_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Lekeni ka ghamatotso gha Wayahudi ghaighalila isi yose ukubweda, na ukuhungukighwa kwawo ukutoghola kuwatenda iwanu iwali si Wayahudi webwede. Lelo pfii Wayahudi wose wang'amuyila Imulungu, ambe ukubweda kutsakongetseka ghendo! ");
INSERT INTO ruf_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Nowalongelani mwemwe imli si Wayahudi bae, kwaapfila nene namtumighwa kwe iwanu iwali si Wayahudi bae, neghodela isang'ano yangu. ");
INSERT INTO ruf_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Nobama niwatende iwanu wangu Wayahudi wone chepfu, ili nidahe kuwakombola wamwenga mghati mwawo. ");
INSERT INTO ruf_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Mana ka ukulemighwa kwawo kuwatenda iwanu wose walamlitsighwe ne Imulungu, pfii itsakuwatse hawatsotogholighwa ne Imulungu? Iwanu watsotsilihuka! ");
INSERT INTO ruf_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Chihindi chamwanduso che chighate ang'eng'ighwa Imulungu, chighate chose chakuwa chake. Imitsitsi ing'awa ye Imulungu, ghamaputila ghose nagho ghakuwa ghake. ");
INSERT INTO ruf_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Tulonge, ghamaputila ghangi gha mtseituni ghaghanighwa na ghamaputila gha mtseituni wa kwibagho ghekighwa hanu haho. Mwemwe imli si Wayahudi mweghala ne mtseituni wa kwibagho, sambi mwehangila ughima wa chimuhe wa Wayahudi. ");
INSERT INTO ruf_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Apfo mleke kuwabetsa awala iwaghanighwe ka ghamaputila! Lelo mdahatse kwighoda? Mkumbuke si mwemwe bae imkindilitsa imitsitsi, ila imtsitsi yomkindilitsani mwemwe. ");
INSERT INTO ruf_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Lekeni mwodaha kulonga, “Ghamaputila ghaghanighwa ili twetwe twikighwe hanu hala.” ");
INSERT INTO ruf_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Pfinogha! Tsaghaghanighwa kwaapfila ng'aghatoghole bae, lekeni mwemwe mwakwima kwaapfila mtoghola. Lelo mleke kwighoda ila mpfuke. ");
INSERT INTO ruf_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Kwaapfila ka Imulungu ng'awalekile Wayahudi iweghalile ne ghamaputila ighaghanighwe, pfii lelo Imulungu katsomlekani mwemwe? ");
INSERT INTO ruf_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Lelo mlole libatsi na ukali we Imulungu. Yeye kamkali kwa awala iwaghwile, lekeni kana libatsi kuna mwemwe ka mwoghendelela kukala mna libatsi lyake, lekeni ka si pfipfo bae, mwemwe namwe mtsoghanighwa. ");
INSERT INTO ruf_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Na Wayahudi pfipfila wang'atoghola, watsokwikighwa keli hanu hala hawaghanighwe, kwaapfila Imulungu kodaha kutenda apfo. ");
INSERT INTO ruf_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Mwemwe iwanu imli si Wayahudi mweghala na putila la mtseituni wa kwibagho. Mlapfighwa ako mwikighwa mne mtseituni wa kumghunda, mne sina si lyenu bae. Lekeni Wayahudi weghala na mtseituni wa kumghunda. Lelo kuna ukomu wachi Imulungu kuwoyitsa keli msina mwawo iwenyegho? ");
INSERT INTO ruf_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Ndughu tsangu sibama bae mleke kumanya mbuli ino, nobama mmanye ili mleke kwibona mna mbutsi ng'ani. Usughu wa Waisiraeli tsaukala wa chipindi chidogho, mbaka iwanu wa isi tsingi hawatsomuyila Imulungu. ");
INSERT INTO ruf_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Baho Waisiraeli wose watsokombolighwa, ka pfayandikighwe, Mkombotsi katsakutsa kulawa Sayuni, Katsoghalapfa ghehile ghose mna lukolo lwa Yakobu, ");
INSERT INTO ruf_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Na alino laghano lyangu kuna wawo, hanitsoghaleghusa ghehile ghawo. ");
INSERT INTO ruf_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Kwaapfila Wayahudi woilema Imbuli Inoghile, wawo wawa wanebe we Imulungu kwaajili ya mwemwe. Lekeni kwaapfila Imulungu kawasaghula, wang'ali wonoghelighwa ne Imulungu kwaajili ya iwabala wawo. ");
INSERT INTO ruf_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Mana Imulungu ang'awasaghula iwanu na kuwatenda webwede, ng'oghalusa bae acho chayatendile. ");
INSERT INTO ruf_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Ka mwemwe pfamlemile kumtegheletsa Imulungu aho ghumwande, lekeni sambi mbokela libatsi lyake kwa kulema kwawo Wayahudi kumtegheletsa Imulungu. ");
INSERT INTO ruf_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Pfipfila ka mwemwe pfambokele libatsi, Wayahudi sambi nawo wolema kumtegheletsa Imulungu, ili nawo sambi wabokele libatsi lye Imulungu. ");
INSERT INTO ruf_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Kwaapfila Imulungu kawatenda iwanu wose waleke kutegheletsa, ili yawonele libatsi iwanu wose. ");
INSERT INTO ruf_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Utajili we Imulungu mkulu sideke na ihekima yake ng'ulu na ukumanya kwake kukulu. Yuhi iyomanya pfayolamla? Yuhi iyomanya nzila tsake? ");
INSERT INTO ruf_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","“Yuhi yomanya chayopfikitsa Imulungu, yuhi iyodaha kumlongotsa mna ukulamla kwake, ");
INSERT INTO ruf_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Yuhi iyalongol e kumwing'a chinu, kuya Imulungu yamlihe?” ");
INSERT INTO ruf_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Kwaapfila pfinu pfose pfolawa kuna yeye, na pfabaha kubitila yeye na kwaajili ya yeye. Imulungu yatunitsighwe ghamatsuwa ghose. Ona. ");
INSERT INTO ruf_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Apfo ndughu tsangu, kwaapfila Imulungu kana libatsi sideke, nomlombani ghendo mlapfe ughima wenu ka nambiko iili ngima, muwe wahenzeluka na mtende aghala ighamnoghela yeye. Ako kuko ukumtamanila Imulungu kunoghile. ");
INSERT INTO ruf_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Mleke kughawinza keli aghala ighali muisi mno, Imulungu na yaghaluse mbutsi tsenu, ili mdahe kughamanya aghala ghoyobama Imulungu. Mtange chihi chinoghile na chihi ichimnoghela yeye na ichitimilike. ");
INSERT INTO ruf_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Kwa uluso wangaile Imulungu, nomlongelani mwemwe wose, chila munu yaleke kwibona kamkulu kubita pfayabamighwa yawe, lekeni mwilolese iwenyegho ka Imulungu pfayamgholele chila imunu ukutoghola kwake. ");
INSERT INTO ruf_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Kwaapfila mne lukuli lumwe kuna pfilungo pfingi, lekeni pfose ng'apfisang'ana ng'onde imwe bae. ");
INSERT INTO ruf_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Pfipfila twetwe hata ka twawengi, twa lukuli lumwe kwa kwilunga na Kiristu, na chila munu ka chilungo cha miyaghe. ");
INSERT INTO ruf_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Mana chila imunu kana gholelo lyake kwa uluso watwing'ile Imulungu. Imunu ka keng'ighwa gholelo lye ukulonga usenga we Imulungu, yalonge kwa ukutoghola kwake. ");
INSERT INTO ruf_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Imunu iyeng'ighwe ukuwasang'anila weyaghe, leka yawasang'anile, ka ukulangulitsa leka yalangulitse. ");
INSERT INTO ruf_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Ka kuwakanza wamwenga, leka yatende pfipfo, munu iyolapfa, yalapfe kwa ghumoyo ghumwe. Imunu iyolongotsa, yalongotse pfinoghile, naye iyotenda chinu cha libatsi yatende kwa ukudeng'elela. ");
INSERT INTO ruf_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Unoghelo wenu uleke kuwa wa ung'enye. Mghahile ghose ghehile, mghakindilitse aghala ighanoghile. ");
INSERT INTO ruf_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Mwinoghele ka mwa wandughu, mwihulikitse wenyegho kwa wenyegho. ");
INSERT INTO ruf_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Mleke kuleghela hamumsang'anila Imtwatsa, msang'anileni kwa ghumoyo wenu wose. ");
INSERT INTO ruf_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Lolelo lyenu liwatende mdeng'elele, hane maghayo mdudumile na mleke kwipfa ukulomba. ");
INSERT INTO ruf_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Muwagholele iwanu we Imulungu pfinu pfenu, muwe waluso kwa wahenza. ");
INSERT INTO ruf_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Muwabaliki awala iwomdununzani, muwabaliki, mleke kuwalighita. ");
INSERT INTO ruf_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Mdeng'e na awala iwodeng'a, lileni na awala iwolila. ");
INSERT INTO ruf_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Mkale pfinoghile chila imunu na miyaghe. Mleke kwighoda, ila mtoghole kukala ne iwanu mbughilambughila. Mleke kwibona mna ihekima ng'ani. ");
INSERT INTO ruf_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Imunu ang'amtendelani ghehile, mwemwe mleke kumliha ghehile, mtende ghanoghile kwe iwanu wose. ");
INSERT INTO ruf_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Mtende pfamdaha mkale tseghamba ne iwanu wose. ");
INSERT INTO ruf_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Sale tsangu, mleke kuliha ghehile, ila mbuli ayo mlekeleni Imulungu, kwaapfila yandikighwa, Imtwatsa kolonga, “Maliho igho ghangu nene, nene nitsoliha.” ");
INSERT INTO ruf_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Kuya Ghamaandiko gholonga, “Imunu iyokuhila ang'awa na nzala, umwing'e ichijo ang'awa na ng'ilu, umwing'e ghamatsi yanwe. Ung'atenda apfo, kutsomghela chinyala.” ");
INSERT INTO ruf_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Uleke kutoghola ghehile ghakuhume, ila ughahume ghehile kwa ghanoghile. ");
INSERT INTO ruf_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Chila imunu awahulikitse watawala iwolongotsa, kwaapfila kuduhu imunu iyodaha kutawala ka Imulungu ng'amlekele yatawale, Imulungu yaliheka iyo iyoweng'a iwatawala ngupfu ya kutawala. ");
INSERT INTO ruf_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Lekeni ayula iyoulema utawala, ayo kolema laghitso lye Imulungu, nawo iwotenda apfo watsohighighwa. ");
INSERT INTO ruf_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Mana iwotawala ng'awopfukighwa bae ne iwanu iwotenda ghanoghile, ila wopfukighwa na iwotenda ghehile. Naghwe ka ng'ubama bae kumpfuka ayula iyokulongosa, utende ghanoghile, naye katsokutunya. ");
INSERT INTO ruf_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Kwaapfila yeye komsang'anila Imulungu kwaajili yako. Lekeni ung'atenda ghehile, umpfuke, mana kodaha ghendo kukuhigha. Yeye komsang'anila Imulungu, kowalangusa maya ye Imulungu awala iwotenda ghehile. ");
INSERT INTO ruf_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Apfo kwobamighwa kuwategheletsa iwatawala, si kwaapfila kwopfuka kuhighighwa ne Imulungu, ila kwaapfila ghumoyo wako womanya chaubamighwa kutenda. ");
INSERT INTO ruf_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Kwaajili ayo mwemwe mwoliha kodi, kwaapfila wawo womsang'anila Imulungu na welapfa kwaajili ya sang'ano ayo. ");
INSERT INTO ruf_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Apfo weng'eni chochose chowomdahini, imunu wa kodi, mwing'eni kodi yake, iyobama kupfukighwa, mpfukeni. ");
INSERT INTO ruf_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Mleke kudaighwa chinu chochose ne imunu, ila mdaighwe ukwinoghela kuliheka. Mana ayula iyomnoghela myaghe kaghatimilitsa Ghamalaghitso gha Musa. ");
INSERT INTO ruf_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Kwaapfila malaghitso ghano, “Uleke ughoni, uleke kukoma, uleke kwiba, uleke kutsulukila pfinu pfe iwanu,” na malaghitso ghangi ghose, ghamna laghitso lino limwe, “Umnoghele miyagho ka pfawinoghela ghumwenyegho.” ");
INSERT INTO ruf_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Ung'amnoghela myagho, ng'utsomtendela ghehile bae, apfo ukunoghela kokindilitsa Ghamalaghitso ghose. ");
INSERT INTO ruf_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Mtende pfino, kwaapfila mwomanya ka chipindi cha mwemwe kulamka kulawa mnongo chitsa, kwaapfila sambi ukukombolighwa kwetu kwahabehi kubita hala hatwanzile kutoghola. ");
INSERT INTO ruf_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Ichilo chahabehi kumala na imisi yahabehi kwingila. Apfo tuleke kutenda ghehile ghe chisi, tutende ghanoghile ghe ghumwanga. ");
INSERT INTO ruf_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Mleke tukale pfinoghile ka iwanu itukala mne ghumwanga we imisi, si kwa soyoka au kupatika, si kwa kwiha na ughoni wala ughobo na chepfu. ");
INSERT INTO ruf_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Ila mpfaleni Imtwatsa Yesu Kiristu, kuya mleke kuwinza ng'uli tsenu na kutenda dongo tsake tsa nzambi. ");
INSERT INTO ruf_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Watogholeni awala iwane noghola ndodo, na mleke kughabela ghamawatso ghawo. ");
INSERT INTO ruf_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Ukutoghola kwe iwanu wamwenga kowatenda waje chinu chochose, lekeni imunu yungi yotoghola chidogho kakuja mbogha ye imitsani iliheka. ");
INSERT INTO ruf_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Imunu iyakuja chila chinu aleke kumbetsa ayula ing'akuja chila chinu. Ayula iyakuja mbogha ya imitsani iliheka naye aleke kumhigha ayula iyakuja pfinu pfose, kwaapfila Imulungu kamtoghola. ");
INSERT INTO ruf_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Ghweghwe uli nani yumuhigha imtumwa wa munu yungi? Ang'ema au ang'aghwa alyo lya imtwatsa wake. Na katsakwima kwaapfila Imtwatsa kodaha ukumwimitsa. ");
INSERT INTO ruf_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Imunu yumwe kodaha kona litsuwa limwe lidegheta kubita litsuwa lingi, na yumwenga kodaha kona ghamatsuwa ghose gheghala. Chila imunu na yalole ka chayopfikitsa chinogha. ");
INSERT INTO ruf_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Ayula iyakona litsuwa limwe lidegheta, ayo kotenda apfo kwa kumtunya Imtwatsa. Ayula iyakuja chochose chila, naye kotenda apfo kwa kumtunya Imtwatsa, kwaapfila wolonga mighede kwe Imulungu kwa chijo chayaweng'ile. Ayula iyolema kuja pfijo pfimwenga, ayo kotenda apfo kwa kumtunya Imtwatsa, naye kolonga mighede kwe Imulungu. ");
INSERT INTO ruf_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Mana haduhu imunu wowose mna twetwe iyokala mghima kwaajili yake imwenyegho aliheka au iyakufa kwaajili yake mwenyegho aliheka. ");
INSERT INTO ruf_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Kwaapfila tung'awa waghima, twawaghima kwaajili ya Imtwatsa, na tung'afa, twakufa kwaajili ya Imtwatsa. Apfo, tung'awa waghima au tung'afa, twetwe twa iwanu we Imtwatsa. ");
INSERT INTO ruf_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Mana Kiristu tsakafa na koya muughima ili yawe Imtwatsa we i