﻿USE sofia;
DROP TABLE IF EXISTS sofia.rub_vpl;
CREATE TABLE rub_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES rub_vpl WRITE;
INSERT INTO rub_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Mu kutandika, Ruhanga yaahangi̱ri̱ iguru na nsi. ");
INSERT INTO rub_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Nsi gyali gitali na kugikwisana kandi gitalimwo kantu, nti̱ti̱ gyali gi̱bbu̱mbi̱ri̱ itaka, Mwozo wa Ruhanga naakulibatira hakyendi̱ wa meezi̱. ");
INSERT INTO rub_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Mwomwo Ruhanga yaabaza naakoba yati, “Leka habbeho kyererezi̱,” kyererezi̱ kyabbaho. ");
INSERT INTO rub_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ruhanga yaaweeni̱ kyererezi̱ nikili kirungi, yaahu̱kani̱a kyererezi̱ na nti̱ti̱. ");
INSERT INTO rub_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Kyererezi̱, yaakyeta “mwinsi” kandi nti̱ti̱, yaagyeta “i̱jolo.” B̯wi̱re b̯wasweki̱ri̱ b̯wei̱ra b̯wakya, kyabba kiro kyakubanza. ");
INSERT INTO rub_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Mwomwo Ruhanga yaabaza naakoba yati, “Leka habbeho mwanya hakati̱ wa meezi̱ ga hansi na hakyendi̱.” ");
INSERT INTO rub_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Kandi Ruhanga yaahangi̱ri̱ mwanya, yaahu̱kani̱a meezi̱ gaanyakubba hansi wa mwanya gu̱gwo, yaagabagani̱amwo ga hakyendi̱ na ga hansi. Kandi kwokwo kyabbeeri̱. ");
INSERT INTO rub_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Kandi mwanya gu̱gwo Ruhanga yaagweti̱ri̱ iguru. B̯wi̱re b̯wasweki̱ri̱ b̯wi̱ra b̯wakya, kyabba kiro kyakabiri. ");
INSERT INTO rub_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Mwomwo Ruhanga yaabaza naakoba yati, “Leka meezi̱ gali hansi weiguru geecooke hamwei̱, leka itehe lizooke.” Kandi kwokwo kyabbeeri̱. ");
INSERT INTO rub_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Itehe, Ruhanga yaalyeti̱ri̱ nsi kandi meezi̱ gaanyakwecooka hamwei̱ yaageeta itaka. Kandi Ruhanga yaawona nikili kirungi. ");
INSERT INTO rub_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Ruhanga yaabaza naakoba yati, “Leka nsi gi̱merye bimera bikwana nsigo na misaali mikwana byana bilimwo nsigo, b̯uli kintu mu mu̱li̱ngo gwakyo nka kukili.” Kandi kwokwo kyabbeeri̱. ");
INSERT INTO rub_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Nsi gyamereerye bimera bili na nsigo mu mi̱li̱ngo myazo, na misaali mikwana byana bilimwo nsigo, b̯uli gu̱mwei̱ mu mu̱li̱ngo gwagwo nka kuguli. Kandi Ruhanga yaawona nikili kirungi. ");
INSERT INTO rub_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","B̯wi̱re b̯wasweki̱ri̱ b̯wei̱ra b̯wakya, kyabba kiro kyakasatu. ");
INSERT INTO rub_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Mwomwo Ruhanga yaabaza naakoba yati, “Leka habbeho byererezi̱ mu mwanya heiguru, byahu̱kani̱e mwinsi nei̱jolo, byolokyenge bantu b̯usumi, biro na myaka, ");
INSERT INTO rub_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","byakirenge mu mwanya heiguru nibimulikira nsi.” Kandi kwokwo kyabbeeri̱. ");
INSERT INTO rub_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Kasi mwomwo Ruhanga yaahanga byererezi̱ bikooto bibiri, kikooto kyakenge b̯wi̱re b̯wa mwinsi, kandi ki̱dooli̱ kyakenge i̱jolo kandi yaakora na nzota. ");
INSERT INTO rub_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Byererezi̱ bi̱byo Ruhanga yaabi̱teeri̱ mu mwanya heiguru bimulikire nsi, ");
INSERT INTO rub_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","lyoba lyakenge b̯wi̱re b̯wa mwinsi, mweri̱ gwakenge i̱jolo, kandi byahu̱kani̱a kyererezi̱ na nti̱ti̱. Kandi Ruhanga yaawona nikili kirungi. ");
INSERT INTO rub_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","B̯wi̱re b̯wasweki̱ri̱ b̯wei̱ra b̯wakya, kyabba kiro kyakanei. ");
INSERT INTO rub_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Mwomwo Ruhanga yaabaza naakoba yati, “Leka meezi̱ gabbemwo myalu mya bihangwa byomi bya b̯uli mu̱li̱ngo kandi leka bi̱nyoni̱ bibbeho, bi̱du̱ndu̱u̱ke mu mwanya hakyendi̱ wa nsi.” ");
INSERT INTO rub_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Kasi mwomwo Ruhanga yaahanga bisolo bikooto bya mwitaka na bihangwa byensei̱ byomi bilibata, b̯uli ki̱mwei̱ mu mu̱li̱ngo gwakyo, na bi̱nyoni̱ byensei̱ bili na bimpaha b̯uli ki̱mwei̱ mu mu̱li̱ngo gwakyo. Kandi Ruhanga yaawona nikili kirungi. ");
INSERT INTO rub_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Nahab̯waki̱kyo, Ruhanga yaabiha mu̱gi̱sa naakoba yati, “Mu̱byale mukanye, mwizuule mu meezi̱ ga mu mataka, kandi leka bi̱nyoni̱ bikanye mu nsi.” ");
INSERT INTO rub_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","B̯wi̱re b̯wasweki̱ri̱ b̯wei̱ra b̯wakya, kyabba kiro kyakataanu. ");
INSERT INTO rub_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Mwomwo Ruhanga yaabaza naakoba yati, “Leka nsi gibyale bihangwa byomi mu mu̱li̱ngo gwabyo: bisolo byensei̱ bikooto na bi̱dooli̱, byakwamu̱gi̱ na byamwirungu.” Kandi kwokwo kyabbeeri̱. ");
INSERT INTO rub_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Kwokwo yatyo Ruhanga yaahangi̱ri̱ bisolo byensei̱ mu mu̱li̱ngo gwabyo. Kandi Ruhanga yaawona nikili kirungi. ");
INSERT INTO rub_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Mwomwo Ruhanga yaabaza naakoba yati, “Leka tukore muntu mu kwisana kwetu̱, abbe naakutwisana afugenge nsu̱, bi̱nyoni̱, bisolo byensei̱ bikooto na bi̱dooli̱, byakwamu̱gi̱ na byamwirungu.” ");
INSERT INTO rub_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ruhanga kwokwo yaahangi̱ri̱ yati muntu mu kwisana kwamwe, mu kwisana kwa Ruhanga, yaamu̱hangi̱ri̱. Yaabahangi̱ri̱ mudulu na mu̱kali̱. ");
INSERT INTO rub_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Kandi Ruhanga yaabaha mu̱gi̱sa. Yaabaza naakoba yati, “Mu̱byale mukanye, mwi̱zu̱u̱lye nsi, mugifuge, mufuge nsu̱ za mwitaka, bi̱nyoni̱ bya mu mwanya, na bihangwa byensei̱ bili mu nsi bikalibata.” ");
INSERT INTO rub_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Mwomwo Ruhanga yaabaza naakoba yati, “Wona, mbaheeri̱ bimera byensei̱ bili mu nsi bikwana nsigo na misaali myensei̱ mikwana byana, bi̱byo byensei̱ mubidyenge. ");
INSERT INTO rub_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Bisolo byensei̱ bya mu nsi, bi̱nyoni̱ byensei̱ bya mu mwanya na bintu byensei̱ bikwesikiira heitehe na byensei̱ bili byomi, mbaheeri̱ bimera byensei̱ bya kisubi kibisi, byobyo mudyenge.” Kandi kwokwo kyabbeeri̱. ");
INSERT INTO rub_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Kandi Ruhanga yaawona byensei̱ bi̱yaakoori̱ nibili birungi, kandi birungi kwo. B̯wi̱re b̯wasweki̱ri̱ b̯wei̱ra b̯wakya, kyabba kiro kyamukaaga. ");
INSERT INTO rub_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Iguru na nsi na byensei̱ bigilimwo kwokwo yatyo byahangi̱i̱rwe. ");
INSERT INTO rub_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ha kiro kyamusanju, Ruhanga yaali amaari̱ milimo myamwe, yaahumula milimo myamwe myensei̱ mi̱yaakoori̱ ha kiro kyamusanju. ");
INSERT INTO rub_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Kiro ki̱kyo kyamusanju Ruhanga yaaki̱heeri̱ mu̱gi̱sa, yaaki̱syani̱a hab̯wakubba kyokyo kiro ki̱yaahu̱mwi̱ri̱ milimo myamwe mi̱yaakoori̱. ");
INSERT INTO rub_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Gugu gwogwo mu̱li̱ngo gweiguru na nsi ku̱byahangi̱i̱rwemwo. Mukama Ruhanga b̯u̱yaahangi̱ri̱ iguru na nsi, ");
INSERT INTO rub_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","hatakabbeho kimera kyensei̱ mu nsi, libbe isubi lyali li̱takameeri̱ hab̯wakubba Mukama Ruhanga yaali atakagu̱mi̱ri̱ ndagali̱ mu nsi, kandi haali hatakabbeeri̱ho muntu akugilima, ");
INSERT INTO rub_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","bei̱tu̱ kiho kyabyokengi̱ nikitemba hakyendi̱, b̯utuntu ni̱b̯u̱lu̱bya nsi gyensei̱, ");
INSERT INTO rub_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","kasi mwomwo Mukama Ruhanga yaakora muntu kuruga mwitehe lya mu nsi, yaamuhuuha rwoya lwa b̯womi mu nni̱ndo, muntu yaabba kihangwa kyomi. ");
INSERT INTO rub_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Hei̱nyu̱ma, Mukama Ruhanga yaasi̱mbi̱ri̱ musiri mu nsi gyʼEdeni̱, ha rubaju lwa b̯uhulukalyoba, ku̱kwo hooho yaateeri̱ muntu gi̱yaahangi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Mukama Ruhanga yaamereerye misaali mya b̯uli mi̱li̱ngo myensei̱ mikusemeera mei̱so ga bantu, mibakusemeera kudya, kandi hakati̱ wa gu̱gwo musiri, yaateeri̱yo musaali gwa b̯womi, na musaali gukuha kwetegereza kirungi na kibiibi. ");
INSERT INTO rub_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Haalingiho mugira gunyakuhetanga nigurugira Edeni̱, niguleeta meezi̱ mu musiri, kuruga hahwo ni̱gwezahu̱kani̱amwo migira minei. ");
INSERT INTO rub_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Ibara lya mugira gukubanza bagweta Pi̱soni̱, gwogwo gunyakuhetanga ni̱gwelogoleerya nsi gyensei̱ gya Havi̱la, hooho heicala zaabbu. ");
INSERT INTO rub_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Zaabbu gya mu nsi gi̱gyo gibba girungi, kandi hali̱yo mahi̱ga gabakweta bedoli̱u̱mu̱ na oni̱ki̱si̱. ");
INSERT INTO rub_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Mugira gwakabiri gwogwo Gi̱hooni̱, gwogwo gunyakuhetanga ni̱gwelogoleerya nsi gyensei̱ gyʼI̱syopi̱ya. ");
INSERT INTO rub_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Mugira gwakasatu gwogwo Ti̱gi̱ri̱i̱si̱, guheta nigugyenda b̯uhulukalyoba b̯wʼAsi̱ri̱ya. Kandi mugira gwakanei gwogwo Efu̱raati̱. ");
INSERT INTO rub_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Mukama Ruhanga yaasengi̱ri̱ muntu, yaamuta mu musiri gwʼEdeni̱ agulime kandi agulinde. ");
INSERT INTO rub_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Mukama Ruhanga yaamuragira naakoba yati, “Misaali myensei̱ mya mu musiri gugu okwikirizib̯wa kumidyaho byana nka kwokwendya. ");
INSERT INTO rub_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Bei̱tu̱ ha musaali gukukuha kwetegereza kirungi na kibiibi, otalidya byana byagwo, kubba kiro olibidya, oli̱kwa.” ");
INSERT INTO rub_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Mwomwo Mukama Ruhanga yaabaza naakoba yati, “Tikili kirungi muntu kwicala yankei, kammukoore mu̱mu̱sagi̱ki̱ amu̱semereeri̱.” ");
INSERT INTO rub_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Kuruga mwitehe Mukama Ruhanga yaali amaari̱ kuhanga bisolo byensei̱ bya mu mwirungu na bi̱nyoni̱ byensei̱ bya mu mwanya, yaabileetera muntu awone nka kuyabiha mabara. Ibara lyensei̱ muntu li̱i̱yaaheeri̱ b̯uli ki̱mwei̱, lyolyo lyabbeeri̱ ibara lyakyo. ");
INSERT INTO rub_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Muntu yaaha mabara bisolo byensei̱ bitungwa, bi̱nyoni̱ byensei̱ bya mu mwanya na bisolo byensei̱ bya mwirungu, bei̱tu̱ mu bi̱byo byensei̱, muntu atakabbe na mu̱mu̱sagi̱ki̱ amu̱semereeri̱. ");
INSERT INTO rub_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Kasi mwomwo Mukama Ruhanga yaaleetera muntu b̯ulo, yeebbaka, yaamutoolamwo rubaju lu̱mwei̱ ha mbaju zaamwe, mu kiikaru kyalwo yaameryamwo nyama gyebbumba, ");
INSERT INTO rub_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","lu̱lwo rubaju lwa Mukama Ruhanga lu̱yaatoori̱ mu muntu, lwolwo yaakoori̱mwo mu̱kali̱, yaamuleetera mudulu, yooyo Adamu. ");
INSERT INTO rub_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Kasi mudulu yaakoba yati, “Lili lyolyo i̱ku̱ha li̱ru̱gi̱ri̱ mu maku̱ha gange, kandi gyogyo nyama gi̱ru̱gi̱ri̱ mu nyama gyange, bamwetanga mu̱kali̱, hab̯wakubba yaaru̱gi̱ri̱ mu mudulu.” ");
INSERT INTO rub_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Nahab̯waki̱kyo mudulu yaalekanga bbaawe na mmaawe niyeekwata na mu̱kali̱ waamwe, bab̯wo bantu babiri nibafooka mubiri gu̱mwei̱. ");
INSERT INTO rub_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Mudulu na mu̱kali̱ waamwe baalingi b̯usa, kandi ki̱kyo ki̱takabakwati̱sye nsoni̱. ");
INSERT INTO rub_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Mu bisolo byensei̱ byamwirungu Mukama Ruhanga bi̱yaahangi̱ri̱, mpiri gyali gi̱gezi̱gezi̱ hoi̱. Kandi mpiri gyab̯u̱u̱li̱i̱rye mu̱kali̱ nigikoba yati, “Mu mananu Ruhanga yaabageeni̱ kudya byana bya misaali myensei̱ mya mu musiri gugu?” ");
INSERT INTO rub_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Mu̱kali̱ yei̱ri̱ri̱mwo mpiri naakoba yati, “Tukwikirizib̯wa kudya byana bya misaali mya mu musiri gugu, ");
INSERT INTO rub_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","bei̱tu̱ Ruhanga yaakobi̱ri̱ yati, ‘Mutalidya byana bya musaali guli hakati̱ wa musiri, nab̯ukilibba kubikwataho b̯u̱kwati̱, ki̱tali̱ki̱kyo mu̱li̱kwa.’ ” ");
INSERT INTO rub_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Mpiri gyaweereeri̱ mu̱kali̱ nigikoba yati, “Haahi, mu mananu ti̱mu̱li̱kwa. ");
INSERT INTO rub_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Bei̱tu̱ Ruhanga akyegi̱ri̱, b̯umulidyaho byana byagwo mei̱so geenyu̱ gaalib̯uluka, mwisane Ruhanga, mwege b̯urungi na b̯ubiibi!” ");
INSERT INTO rub_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Mu̱kali̱ b̯u̱yaaweeni̱ byana bya musaali nibili birungi kubidya, byasemeera mei̱so gaamwe kandi musaali gu̱gwo gukugyenda kwi̱rya muntu wamagezi̱, yaanokola byana byagwo, yaadya. Bindi yaabihaho i̱baawe gibaalinayo, yoodede yaadyaho. ");
INSERT INTO rub_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Hei̱nyu̱ma gya kudya, mei̱so gaab̯u gaab̯u̱lu̱ki̱ri̱, beetegereza nka kubaalingi b̯usa. Baasu̱ngi̱ri̱ nkaahi kuruga ha musaali mu̱ti̱i̱ni̱ beekoora byakulwala. ");
INSERT INTO rub_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Adamu na mu̱kali̱ waamwe b̯u̱beegwi̱ri̱ iraka lya Mukama Ruhanga naakulibata mu musiri na mahehu ga joojolo, beebi̱sa mu misaali mya mu musiri gu̱gwo, aleke Mukama Ruhanga atabawona. ");
INSERT INTO rub_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Mukama Ruhanga yeeta Adamu, yaamu̱b̯u̱u̱lya naakoba yati, “Oli hanya?” ");
INSERT INTO rub_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Adamu yei̱ri̱ri̱mwo naakoba yati, “B̯u̱nyeegwi̱ri̱ nookulibata mu musiri nyaati̱i̱ni̱ri̱, nyeebi̱sa, hab̯wakubba ndi b̯usa.” ");
INSERT INTO rub_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ruhanga yaamu̱b̯u̱u̱lya naakoba yati, “Naani yaaku̱weereeri̱ nka kwoli b̯usa? Odi̱i̱ri̱ ku byana bya musaali gu̱nyaku̱geeni̱ otadya?” ");
INSERT INTO rub_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Mudulu yei̱ri̱ri̱mwo naakoba yati, “Mu̱kali̱ gi̱i̱wampeeri̱ kwicala nagya, yooyo yampeeri̱ kyana kya musaali gu̱gwo, gyedede nyadyaho.” ");
INSERT INTO rub_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Hei̱nyu̱ma, Mukama Ruhanga yaab̯u̱u̱li̱i̱rye mu̱kali̱ naakoba yati, “Kyani ki̱kyo kyokoori̱?” Mu̱kali̱ yei̱ri̱ri̱mwo yati, “Mpiri gyogyo gyangobeerye, nyaadya.” ");
INSERT INTO rub_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Hei̱nyu̱ma Mukama Ruhanga yaaweereeri̱ mpiri naakoba yati, “Ofu̱bi̱i̱rwe hab̯wa ki̱kyo kyokoori̱, mu bisolo byensei̱ weewe okyeneerwe kukiraho. Mu kulibata kwamu okwi̱za ku̱li̱bati̱syanga nda, kandi cuucu gyogyo waadyanga biro bya b̯womi b̯wamu b̯wensei̱! ");
INSERT INTO rub_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Kandi nteeri̱ho b̯unyanzigwa hakati̱ gyamu na mu̱kali̱, hakati̱ wa beizukulu baamu na beizukulu baamwe, mwizukulu waamwe, alikukuuta mu̱twe, kandi we olimuluma kigulu ku nkolokoojo.” ");
INSERT INTO rub_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Kandi Ruhanga yaaweera mu̱kali̱ naakoba yati, “Mu kubyala baana wababyaliranga mu b̯u̱ru̱mi̱ b̯unene, oliicalanga ni̱wendya hoi̱ i̱baawu̱ kandi yooyo yakufuganga.” ");
INSERT INTO rub_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Kandi Ruhanga yaaweereeri̱ Adamu naakoba yati, “Hab̯wakubba weegwi̱ri̱ bigambu bya mu̱kali̱ waamu, waadya byana bya musaali bi̱nyaku̱geeni̱ kudya, nsi gi̱kyeneerwe hab̯wamu, biro bya b̯womi b̯wamu byensei̱, olidyanga bikuruga mu kwekamba kwamu. ");
INSERT INTO rub_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Itehe lyaku̱mereeryanga mahwa na mutala, kandi olidyanga bimera bya mwirungu. ");
INSERT INTO rub_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Olidyanga bidyo bya mu ntu̱u̱yo zaamu ku̱doosya b̯woliku̱bayo mwitehe hab̯wakubba lyolyo li̱waru̱gi̱ri̱mwo, oli itehe kandi mwitehe lyolyo olikubamwo.” ");
INSERT INTO rub_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Mudulu yaaheeri̱ mu̱kali̱ waamwe ibara Haawa hab̯wakubba yooyo maa bantu bensei̱. ");
INSERT INTO rub_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Mukama Ruhanga yaakoleeri̱ Adamu na Haawa bilwalu kuruga mu bikuta, yaabalwalya. ");
INSERT INTO rub_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Mwomwo Mukama Ruhanga yaakoba yati, “Hab̯wakubba muntu abbeeri̱ nkoomwei̱ hali twe, yeegi̱ri̱ kirungi na kibiibi, leka tumugaane atanokola ha byana bya musaali gwa b̯womi akabidya akoomeera biro byensei̱.” ");
INSERT INTO rub_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Nahab̯waki̱kyo Mukama Ruhanga yaamu̱bi̱ngi̱ri̱ mu musiri gwʼEdeni̱ agyende alime nsi gi̱bamu̱toori̱mwo. ");
INSERT INTO rub_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Yaabi̱ngi̱ri̱mwo mudulu yogwo, ha b̯uhulukalyoba b̯wa musiri gwʼEdeni̱, yaatayo bakeru̱u̱bbi̱ na mpirima gi̱kwakab̯waki̱ ginyaakwicalanga nigyelogoolya hensei̱ kulinda muhanda gukugyenda ha musaali gwa b̯womi. ");
INSERT INTO rub_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adamu yaateerei̱ni̱ na mu̱kali̱ waamwe Haawa, yeemeta yaabyala Kai̱ni̱. Haawa yaabazi̱ri̱ naakoba yati, “Mukama ampeeri̱ kubyala mwana wa b̯udulu.” ");
INSERT INTO rub_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Hei̱nyu̱ma yaamu̱honderyeho mwana wa b̯udulu wondi yaamweta Abberi̱. Abberi̱ yaali mu̱li̱i̱sya wa ntaama kandi Kai̱ni̱ yaabba mu̱li̱mi̱. ");
INSERT INTO rub_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Kasu̱mi̱ b̯u̱karabi̱ri̱ho, Kai̱ni̱ yaaleeteeri̱ Mukama kihongwa kya makesa kuruga mwitehe li̱yaali̱mengi̱, ");
INSERT INTO rub_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","na Abberi̱ yaaleeta mi̱zegei̱zo myeigana lyamwe na bisajwa byazo. Mukama yaasi̱i̱mi̱ri̱ Abberi̱ na kihongwa kyamwe, ");
INSERT INTO rub_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","bei̱tu̱ atakasi̱i̱me Kai̱ni̱ na kihongwa kyamwe. Kai̱ni̱ yaasali̱i̱rwe hoi̱ yaazingalira ki̱mwei̱, yaazu̱bya b̯u̱syo. ");
INSERT INTO rub_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Mukama yaab̯u̱u̱lya Kai̱ni̱ naakoba yati, “Hab̯waki osali̱i̱rwe kandi hab̯waki ozi̱ngeeri̱ yatyo waazu̱bya na b̯u̱syo? ");
INSERT INTO rub_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Obbenge okoori̱ kurungi, ti̱wakasi̱i̱mwa? Bei̱tu̱ okoori̱ kibii, kibii ki̱ku̱li̱ndi̱ri̱i̱ri̱ ha mulyangu ku̱ku̱si̱ngu̱ra, bei̱tu̱ osemereeri̱ okifuge.” ");
INSERT INTO rub_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Hei̱nyu̱ma, Kai̱ni̱ yaaweereeri̱ waab̯u Abberi̱ naakoba yati, “I̱za tugyende mwirungu tulibatelibate.” B̯ubaalingi ku̱kwo, Kai̱ni̱ yaagwera waab̯u, yaamwi̱ta. ");
INSERT INTO rub_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Kasi Mukama yaab̯u̱u̱lya Kai̱ni̱ naakoba yati, “Weenyu̱, Abberi̱, ali hanya?” Kai̱ni̱ yei̱ri̱ri̱mwo naakoba yati, “Tinyegi̱ri̱, gyagya ncala mu̱li̱ndi̱ wa weetu̱?” ");
INSERT INTO rub_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Mukama amu̱b̯u̱u̱lya naakoba yati, “Kikyani kyokoori̱? Weegwa! Ibbanga lya weenyu̱ li̱bbwomoki̱ri̱ likundiriira hansi. ");
INSERT INTO rub_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Nahab̯waki̱kyo okyeneerwe kandi obi̱ngi̱i̱rwe, tokwi̱za kwicala mu nsi gi̱nyweri̱ ibbanga lya weenyu̱ gi̱wei̱ti̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","B̯wolilimanga musiri, ti̱gu̱li̱kwereerya bidyo, oliicala noozengeera kandi nooli mu̱goonyi̱.” ");
INSERT INTO rub_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kai̱ni̱ yei̱ramwo Mukama naakoba yati, “Kifubiro kyompeeri̱ kili kikooto maani, tinkusobora kukilindira. ");
INSERT INTO rub_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Wona, hataati̱ ombi̱ngi̱ri̱ ndugeho mu mei̱so gaamu na mu gigi nsi. Nyabbanga mu̱zengeeri̱, yogwo yensei̱ alimbona ali̱nzi̱ta.” ");
INSERT INTO rub_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Bei̱tu̱ Mukama yaaweera Kai̱ni̱ naakoba yati, “Kwahi, tikili yatyo, yogwo yensei̱ ali̱i̱ta Kai̱ni̱, ali̱hoorwa nzi̱go mirundi musanju.” Mukama yaateeri̱ho Kai̱ni̱ kawoneru kakwolokya nti, yensei̱ yaamu̱rombanga atali̱mwi̱ta. ");
INSERT INTO rub_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kasi Kai̱ni̱ yaaruga mu mei̱so ga Mukama, yaagyenda yeicala mu nsi gibakweta Noodi̱, b̯uhulukalyoba b̯wʼEdeni̱. ");
INSERT INTO rub_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kai̱ni̱ yaateerei̱ni̱ na mu̱kali̱ waamwe, mu̱kali̱ yeemeta yaabyala Enoka. Kasi Kai̱ni̱ yaabi̱mba rub̯uga, rub̯uga yaaluha ibara lya mu̱tabani̱ waamwe Enoka. ");
INSERT INTO rub_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enoka yaabyeri̱ I̱radi̱, I̱radi̱ yooyo Bba Meku̱yai̱ri̱, Meku̱yai̱ri̱ yooyo bba Metu̱saheeri̱, Metu̱saheeri̱ yaabyeri̱ Lameki̱. ");
INSERT INTO rub_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lameki̱ yaatu̱ngi̱ri̱ bakali̱ babiri, ibara lya mu̱kali̱ omwei̱ yooyo Aada, lya wondi yooyo Zi̱i̱la. ");
INSERT INTO rub_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Aada yaabyeri̱ Yabbaali̱, yooyo haaha bab̯wo balaala mu heema kandi bali̱i̱sya. ");
INSERT INTO rub_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Ibara lya waab̯u yooyo Yu̱bali̱, yogwo yooyo haaha bab̯wo bakuuta ndi̱ngi̱di̱ na ndere. ");
INSERT INTO rub_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zi̱i̱la yaabyeri̱ Tu̱bali̱-kai̱ni̱, yogwo yooyo yaali mu̱heesi̱ wa byoma bya mi̱li̱nga. Nyaakaab̯u Tu̱bali̱-kai̱ni̱, ibara lyamwe baamwetengi̱ Naama. ");
INSERT INTO rub_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lameki̱ yaaweereeri̱ bakali̱ baamwe naakoba yati, “Nywe bakali̱ bange, Aada na Zi̱i̱la, mu̱nzegwe, mwetegeerye kinkukoba, Nzi̱ti̱ri̱ muntu hab̯wa kumputaaza, musigazi muto hab̯wa kunkuuta. ");
INSERT INTO rub_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Kai̱ni̱ b̯uyaakabba naakuhoorwa nzi̱go mirundi musanju, Lameki̱ asemereeri̱ ahoorwe mirundi nsanju na musanju.” ");
INSERT INTO rub_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adamu yei̱ra yaatunga mu̱kali̱ waamwe, mu̱kali̱ yaabyala mwana wa b̯udulu, yaamweta ibara Seezi̱, yaakoba yati, “Ruhanga ampeeri̱ mwana wondi mu kiikaru kyʼAbberi̱, Kai̱ni̱ gi̱yei̱ti̱ri̱.” ");
INSERT INTO rub_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seezi̱ nayo yaabyeri̱ mwana wa b̯udulu yaamweta Enosi̱. Mu kasu̱mi̱ kakwo, bantu hooho baatandi̱ki̱i̱ri̱ ku̱ramya Mukama. ");
INSERT INTO rub_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Kiki kyokyo kitabbu ki̱kwolokya beizukulu bʼAdamu. Ruhanga b̯u̱yaahangi̱ri̱ muntu, yaamu̱hangi̱ri̱ nakumwisana. ");
INSERT INTO rub_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Yaabahangi̱ri̱ mudulu na mu̱kali̱, b̯u̱yaamaari̱ kubahanga, yaabaha mu̱gi̱sa, yaabeeta bantu. ");
INSERT INTO rub_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adamu b̯u̱yaadooseerye myaka ki̱ku̱mi̱ na maku̱mi̱ gasatu (130), yaabyeri̱ mwana wa b̯udulu akumwisanira ki̱mwei̱, wa ki̱si̱sani̱ kyamwe kyonyi̱ni̱, yaamweta Seezi̱. ");
INSERT INTO rub_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Myaka myʼAdamu mi̱yamaari̱ hei̱nyu̱ma gya kubyala Seezi̱ myadoori̱ runaanei (800), yaabyala baana bandi, ba b̯udulu na ba b̯uhala. ");
INSERT INTO rub_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Myaka myensei̱ Adamu mi̱yaamaari̱ myali rwenda na maku̱mi̱ gasatu (930), yaakwa. ");
INSERT INTO rub_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seezi̱ b̯u̱yaadooseerye myaka ki̱ku̱mi̱ na mitaanu (105), yaabyala Enosi̱. ");
INSERT INTO rub_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Seezi̱ b̯u̱yaamaari̱ kubyala Enosi̱, yaamaari̱ myaka mindi runaanei na musanju (807), yaabyala baana bandi ba b̯udulu na ba b̯uhala. ");
INSERT INTO rub_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Myaka myensei̱ Seezi̱ mi̱yaamaari̱ myali rwenda nei̱ku̱mi̱ na mibiri (912), yaakwa. ");
INSERT INTO rub_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enosi̱ b̯u̱yaadooseerye myaka kyenda (90), yaabyala Kenani. ");
INSERT INTO rub_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Enosi̱ b̯u̱yaamaari̱ kubyala Kenani, yaamaari̱ myaka mindi runaanei nei̱ku̱mi̱ na mitaanu (815), yaabyala baana bandi ba b̯udulu na ba b̯uhala. ");
INSERT INTO rub_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Myaka myensei̱ Enosi̱ mi̱yaamaari̱ myali rwenda na mitaanu (905), yaakwa. ");
INSERT INTO rub_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenani b̯u̱yaadooseerye myaka nsanju (70), yaabyala Maharaleeri̱. ");
INSERT INTO rub_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Kenani b̯u̱yaamaari̱ kubyala Maharaleeri̱, yaamaari̱ myaka mindi runaanei na maku̱mi̱ ganei (840), yaabyala baana bandi ba b̯udulu na ba b̯uhala. ");
INSERT INTO rub_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Myaka myensei̱ Kenani mi̱yaamaari̱ myali rwenda nei̱ku̱mi̱ (910), yaakwa. ");
INSERT INTO rub_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Maharaleeri̱ b̯u̱yaadooseerye myaka nkaaga na mitaanu (65), yaabyala Yaleedi̱. ");
INSERT INTO rub_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Maharaleeri̱ b̯u̱yaamaari̱ kubyala Yaleedi̱, yaamaari̱ myaka mindi runaanei na maku̱mi̱ gasatu (830), yaabyala baana bandi ba b̯udulu na bahala. ");
INSERT INTO rub_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Myaka myensei̱ Maharaleeri̱ mi̱yaamaari̱ myali runaanei na kyenda na mitaanu (895), yaakwa. ");
INSERT INTO rub_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yaleedi̱ b̯u̱yaadooseerye myaka ki̱ku̱mi̱ na nkaaga na mibiri (162), yaabyala Enoka. ");
INSERT INTO rub_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Yaleedi̱ b̯u̱yaamaari̱ kubyala Enoka, yaamaari̱ myaka mindi runaanei (800), yaabyala baana bandi ba b̯udulu na ba b̯uhala. ");
INSERT INTO rub_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Myaka myensei̱ Yaleedi̱ mi̱yaamaari̱ myali rwenda mu nkaaga na mibiri (962), yaakwa. ");
INSERT INTO rub_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enoka b̯u̱yaadooseerye myaka nkaaga na mitaanu (65), yaabyala Metu̱seera. ");
INSERT INTO rub_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Enoka b̯u̱yaamaari̱ kubyala Metu̱seera, yaahereeze Ruhanga kumala myaka bi̱ku̱mi̱ bisatu (300), yaabyala baana bandi ba b̯udulu na ba b̯uhala. ");
INSERT INTO rub_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Myaka myensei̱ Enoka mi̱yamaari̱ mu nsi myali bi̱ku̱mi̱ bisatu na nkaaga na mitaanu (365). ");
INSERT INTO rub_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enoka yaahereeze Ruhanga, kandi Ruhanga yaamu̱tweri̱ atakei̱re kuzooka. ");
INSERT INTO rub_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metu̱seera b̯u̱yaadooseerye myaka ki̱ku̱mi̱ na kinaanei na musanju (187), yaabyala Lameki̱. ");
INSERT INTO rub_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Metu̱seera b̯u̱yaamaari̱ kubyala Lameki̱, yaamaari̱ myaka mindi rusanju na kinaanei na mibiri (782), yaabyala baana bandi ba b̯udulu na ba b̯uhala. ");
INSERT INTO rub_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Myaka myensei̱ Metu̱seera mi̱yaamaari̱ myali rwenda mu nkaaga na mwenda (969), yaakwa. ");
INSERT INTO rub_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lameki̱ b̯u̱yaadooseerye myaka ki̱ku̱mi̱ na kinaanei na mibiri (182), yaabyala mwana wa b̯udulu, ");
INSERT INTO rub_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","yaamweta Nu̱u̱ha yaakoba yati, “Kuruga mwitehe lya Mukama li̱yaakyeni̱ri̱, mwana yogo ali̱tu̱hu̱mu̱u̱lya kutalibana kwa mikono myetu̱ mu nsi.” ");
INSERT INTO rub_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Lameki̱ b̯u̱yaamaari̱ kubyala Nu̱u̱ha, yaamaari̱ myaka mindi bi̱ku̱mi̱ bitaanu mu kyenda na mitaanu (595), yaabyala baana bandi ba b̯udulu na ba b̯uhala. ");
INSERT INTO rub_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Myaka myensei̱ Lameki̱ mi̱yaamaari̱ myali rusanju mu nsanju na musanju (777), yaakwa. ");
INSERT INTO rub_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nu̱u̱ha b̯u̱yaamaari̱ myaka bi̱ku̱mi̱ bitaanu (500), yaabyala Seemu̱, Haamu na Yafeesi̱. ");
INSERT INTO rub_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Bantu b̯u̱bakatandi̱ki̱ri̱ kukanya mu nsi, baabyala baana ba b̯uhala, ");
INSERT INTO rub_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","baana ba Ruhanga baawona bab̯wo bahala nibali barungi, baaswera bamwe hali bahala babaakomi̱ri̱mwo. ");
INSERT INTO rub_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Mwomwo Mukama yaakoba yati, “Mwozo gwange tiguliicala mu muntu biro byensei̱, kubba muntu ali mubiri b̯ubiri, biro byamwe bilibba myaka ki̱ku̱mi̱ na maku̱mi̱ gabiri (120).” ");
INSERT INTO rub_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Mu biro bi̱byo na mu biro byenyu̱ma, Banefu̱li̱i̱mu̱ baaloho. Baana ba Ruhanga b̯u̱bateerei̱ni̱ na bahara ba bantu, baabyala na bo baana mu nsi baabba bantu banyamaani hoi̱. Bab̯wo boobo bantu ba kadei banyaku̱ku̱ma hoi̱. ");
INSERT INTO rub_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Mukama b̯u̱yaaweeni̱ b̯ubiibi b̯wa muntu nib̯uli b̯unene mu nsi, na biteekerezu bya muntu nibili ha b̯ubiibi b̯usa, ");
INSERT INTO rub_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Kandi Mukama yaasali̱i̱rwe hoi̱, yeezi̱zu̱kya hab̯waki yaahangi̱ri̱ muntu mu nsi. ");
INSERT INTO rub_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Nahab̯waki̱kyo, Mukama yaabaza naakoba yati, “Nkugyenda ku̱hwerekereerya muntu gi̱nyahangi̱ri̱ mutoole mu nsi, bisolo, bi̱nyoni̱, na bi̱nyoni̱ bi̱du̱ndu̱u̱ka, hab̯wakubba nsali̱i̱rwe hab̯wa kubihanga.” ");
INSERT INTO rub_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Bei̱tu̱ Mukama yaakwati̱i̱rwe Nu̱u̱ha mbabazi̱. ");
INSERT INTO rub_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Baba boobo beizukulu ba Nu̱u̱ha. Nu̱u̱ha yaali muntu wa mananu, mu̱terekereru̱ mu bantu ba mu̱hi̱hi̱ gwamwe, kandi yaaheerezengi̱ Ruhanga. ");
INSERT INTO rub_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Yaali na batabani̱ baamwe basatu, Seemu̱, Haamu na Yafeesi̱. ");
INSERT INTO rub_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Mu kasu̱mi̱ kakwo, Ruhanga yaaweeni̱ nsi gyensei̱ nka kugyali gi̱tab̯u̱ku̱ kandi gi̱i̱zwi̱ri̱ b̯ubiibi. ");
INSERT INTO rub_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Nsi nka kugyali gi̱heneki̱ri̱ mu mei̱so ga Ruhanga, bantu bensei̱ baali baheneeri̱. ");
INSERT INTO rub_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Ruhanga yaaweereeri̱ Nu̱u̱ha naakoba yati, “Mmali̱ri̱i̱ri̱ ku̱zi̱kya bantu bensei̱, hab̯wakubba nsi gyensei̱ gili gi̱tab̯u̱ku̱, nkwi̱za ku̱gi̱hwerekereerya hamwei̱ na bintu byensei̱. ");
INSERT INTO rub_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Kora b̯wati̱ b̯ukooto b̯wa mbaahu zirungi zitatiro. B̯wati̱ b̯u̱b̯wo, ob̯usalemwo bi̱si̱i̱ka, ob̯u̱si̱i̱ge, ob̯ususuhe mu nda na hanzei. ");
INSERT INTO rub_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ob̯ukore yati, b̯ulei b̯wab̯wo b̯ubbe mita ki̱ku̱mi̱ na maku̱mi̱ gasatu neisatu (133), b̯ugali b̯wab̯wo mita maku̱mi̱ gabiri neibiri (22), hakyendi̱ zibbe mita i̱ku̱mi̱ neisatu (13). ");
INSERT INTO rub_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","B̯wati̱ b̯u̱b̯wo, ob̯uteho kasolya ketu̱lu̱ke senti̱mi̱ta maku̱mi̱ ganei neine (44), mulyangu gwa b̯wati̱, ogute ha rubaju lwa b̯wati̱ ob̯usalemwo mwaliiro gu̱ku̱tandi̱ki̱sya, mwaliiro gwakabiri na mwaliiro gwakasatu. ");
INSERT INTO rub_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Hab̯wakubba nkwi̱za kuleeta mwizulo gwa meezi̱ mu nsi ku̱hwerekereerya bantu bensei̱, bintu byomi byensei̱ mbimale hansi weiguru, kintu kyensei̱ kili mu nsi ki̱li̱kwa. ");
INSERT INTO rub_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Bei̱tu̱ nkwi̱za kukora nawe ndagaanu, olingira mu b̯wati̱, we na batabani̱ baamu, mu̱kali̱ waamu, na bamukaabaana baamu. ");
INSERT INTO rub_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Kandi oli̱ngi̱i̱rya mu b̯wati̱ ha b̯uli kintu kyensei̱ kyomi, bibiri bibiri bya b̯uli mu̱li̱ngo kidulu na ki̱kali̱, biicale hamwei̱ nawe nibili byomi. ");
INSERT INTO rub_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Bi̱nyoni̱ mu mu̱li̱ngo myensei̱ myabyo, na bisolo mu nganda zaabyo, byensei̱ bikwesikiira hansi mu mu̱li̱ngo gwabyo, bibiri bibiri bya b̯uli mu̱li̱ngo bilingira mu b̯wati̱ cali oli, obilinde bi̱tali̱kwa. ");
INSERT INTO rub_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Kandi olitwala bidyo bya b̯uli mu̱li̱ngo obibiike, nywe na byomi byensei̱ byobyo mulidyangaho.” ");
INSERT INTO rub_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nu̱u̱ha kwokwo yaakoori̱, yaakora byensei̱ Ruhanga bi̱yaamu̱ragi̱i̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Hei̱nyu̱ma, Mukama yaaweera Nu̱u̱ha naakoba yati, “Ingira mu b̯wati̱, we na makaa gaamu, hab̯wakubba weewe wankei ginkuwona oli wamananu mu bantu ba mu̱hi̱hi̱ gugu. ");
INSERT INTO rub_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Otwale ha b̯uli bisolo bidiib̯wa musanju bidulu na musanju bi̱kali̱ kandi otwale kidulu na ki̱kali̱ ha b̯uli bisolo bitadiib̯wa. ");
INSERT INTO rub_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Kandi otwale hali b̯uli bi̱nyoni̱ bya mu mwanya musanju bidulu na musanju bi̱kali̱. Kwokwo luganda lwabyo lutahwerekeera ki̱mwei̱ mu nsi. ");
INSERT INTO rub_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Hab̯wakubba hei̱nyu̱ma gya biro musanju, nkwi̱za kuguma ndagali̱ mu nsi, gi̱gwe kumala biro maku̱mi̱ ganei, mwinsi nei̱jolo, b̯uli kihangwa kyensei̱ ki̱nyahangi̱ri̱ nkwi̱za ku̱ki̱hwerekereerya nkimaleho mu nsi.” ");
INSERT INTO rub_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nu̱u̱ha yaakoori̱ bintu byensei̱ Mukama bi̱yaamu̱ragi̱i̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Mwizulo hagwezi̱i̱ri̱ mu nsi, Nu̱u̱ha yaali na myaka rukaaga. ");
INSERT INTO rub_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Ndagali̱ b̯ugyali nicaali kutandika, yo na batabani̱ baamwe, na mu̱kali̱ waamwe, na bamukabaana baamwe, bengi̱i̱ri̱ mu b̯wati̱, aleke meezi̱ ga mwizulo gatabei̱ta. ");
INSERT INTO rub_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Ha bisolo bidiib̯wa na ha bisolo bitadiib̯wa, ha bi̱nyoni̱ na ha b̯uli kintu kyesikiira ha nsi, ");
INSERT INTO rub_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","bibiri bibiri kidulu na ki̱kali̱ byengi̱i̱ri̱ mu b̯wati̱ hamwei̱ na Nu̱u̱ha nka Ruhanga ku̱yamu̱weereeri̱. ");
INSERT INTO rub_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Hei̱nyu̱ma wa biro musanju meezi̱ ga mwizulo gei̱za ha nsi. ");
INSERT INTO rub_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Mu mwaka gwa rukaaga (600) gwa b̯u̱handu̱ b̯wa Nu̱u̱ha, ha kiro kyei̱ku̱mi̱ na musanju kya mweri̱ gwakabiri, misu myensei̱ mya hansi myaki̱ngu̱ki̱ri̱, nzi̱je za mwizulo za mwiguru zeijuluka. ");
INSERT INTO rub_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Ndagali̱ gyagwi̱ri̱ mu nsi kumala biro maku̱mi̱ ganei, mwinsi nei̱jolo. ");
INSERT INTO rub_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ha kiro ki̱kyo kyonyi̱ni̱, Nu̱u̱ha na batabani̱ baamwe: Seemu̱, Haamu na Yafeesi̱, mukaa Nu̱u̱ha na bamukaabaana baamwe, bengi̱i̱ri̱ mu b̯wati̱. ");
INSERT INTO rub_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Bei̱ngi̱i̱ri̱ na bisolo bya b̯uli mu̱li̱ngo, nte, bi̱nyoni̱, na bisolo bikwesikiira hansi bya b̯uli mu̱li̱ngo, bi̱nyoni̱ bya b̯uli mu̱li̱ngo nabyo byengi̱i̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Bintu byensei̱ byomi bikuhumula byengi̱i̱ri̱ mu b̯wati̱ bibiri bibiri hamwei̱ na Nu̱u̱ha. ");
INSERT INTO rub_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Ha bi̱byo byensei̱ bili na mubiri binyakwingira mu b̯wati̱ kidulu na ki̱kali̱, byengi̱i̱ri̱ nka Ruhanga ku̱yaaragi̱i̱ri̱ Nu̱u̱ha. Kasi Mukama yaamukingirana mu b̯wati̱. ");
INSERT INTO rub_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Mwizulo gwei̱ceeri̱ho mu nsi kumala biro maku̱mi̱ ganei. Meezi̱ gaakanyi̱ri̱ b̯wati̱ b̯wabyoka hakyendi̱ b̯wadengeeta. ");
INSERT INTO rub_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Meezi̱ gagyendengi̱ nigahuuka gaabbeera ki̱mwei̱ galei, b̯wati̱ b̯wadengeeta hakyendi̱. ");
INSERT INTO rub_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Meezi̱ gaaleeheeri̱ ki̱mwei̱, gaamera nsahu zensei̱ zilei. ");
INSERT INTO rub_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Gei̱ceeri̱ nigeyongeranga kuleeha gaamera nsahu mita nka musanju kwakyendi̱ waazo. ");
INSERT INTO rub_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Bintu byensei̱ byomi binyaakulibatanga mu nsi byakwi̱ri̱, nnyoni̱ zensei̱, bisolo byensei̱, bihangwa bya mu meezi̱ na bantu bensei̱. ");
INSERT INTO rub_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Bintu byensei̱ binyakubba ku nsi gyomu bili na rwoya lwa b̯womi, bi̱ku̱hu̱u̱mu̱li̱sya nni̱ndo byakwi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Ruhanga yaahwerekereerya b̯uli kintu kyensei̱ kyomi kinyakubba nikili mu nsi, bantu, bisolo na bi̱nyoni̱ bya mu mwanya byahwerekeera, byamalika mu nsi. Nu̱u̱ha yooyo yaasi̱geeri̱ho na bab̯wo baayaali nabo mu b̯wati̱. ");
INSERT INTO rub_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Meezi̱ gaatakakeehe mu nsi mpaka biro ki̱ku̱mi̱ na maku̱mi̱ gataanu (150). ");
INSERT INTO rub_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Kandi Ruhanga atakeeb̯we Nu̱u̱ha na bisolo byensei̱ biyaali nabyo mu b̯wati̱. Ruhanga yaaleeti̱ri̱ mpehu gyahunga ku nsi, meezi̱ gaakeeha, ");
INSERT INTO rub_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","misu mya hansi na nzi̱je za mwizulo za mwiguru zeekinga, ndagali̱ gi̱nyaku̱gwanga gyamuka. ");
INSERT INTO rub_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Meezi̱ gaagyendi̱ri̱ nigakeeha ku nsi mpula mpula hab̯wa biro ki̱ku̱mi̱ na maku̱mi̱ gataanu (150). ");
INSERT INTO rub_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ha kiro kyei̱ku̱mi̱ na musanju kya mweri̱ gwamusanju, b̯wati̱ b̯wajami̱ri̱ ha nsahu zʼArarati̱. ");
INSERT INTO rub_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Meezi̱ gaagyendengi̱ nigakeeha mpula mpula ku̱doosya kiro kyakubanza kya mweri̱ gwei̱ku̱mi̱, nsahu zaahu̱lu̱kya mi̱twe. ");
INSERT INTO rub_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Biro maku̱mi̱ ganei b̯u̱byamaki̱ri̱ho, Nu̱u̱ha yeijula di̱ri̱sa gya b̯wati̱ b̯u̱yaakoori̱. ");
INSERT INTO rub_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Yaatuma nnyoni̱. Nnyoni̱ gyei̱ceeri̱ ni̱gi̱du̱ndu̱u̱kanga kandi ni̱gi̱ranga ha b̯wati̱ ku̱doosya meezi̱ b̯u̱goomeeri̱ ki̱mwei̱ mu nsi. ");
INSERT INTO rub_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Hei̱nyu̱ma, yaatu̱mi̱ri̱ kolome gi̱yaali nayo mu b̯wati̱, kwetegereza meezi̱ b̯u̱gakabba gakeehi̱ri̱ mu nsi. ");
INSERT INTO rub_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Bei̱tu̱ kolome b̯u̱yaalemeerwe ha kwemeera, yei̱rayo, hab̯wakubba meezi̱ gaali niigacaali mu nsi gyensei̱. Nu̱u̱ha yaahu̱lu̱ki̱i̱rye mukono hanzei yaamukwata, yaamwi̱ngi̱i̱rya mu b̯wati̱ cali yaali. ");
INSERT INTO rub_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Yaali̱ndi̱ri̱ biro bindi musanju, yaab̯u̱ni̱a yaatuma kolome, ");
INSERT INTO rub_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","kolome yei̱ri̱ri̱ joojolo naali na kikoora kya kasonga ka musaali mu̱zayi̱tu̱u̱ni̱ mu mu̱nwa. Nu̱u̱ha yeega meezi̱ nka ku̱gakeehi̱ri̱ mu nsi. ");
INSERT INTO rub_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Yaali̱ndi̱ri̱ biro bindi musanju, yaab̯u̱ni̱a yaatuma kolome, ha murundi gugu kolome atakei̱reyo hali yo. ");
INSERT INTO rub_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Ha kiro kyakubanza kya mweri̱ gwakubanza, Nu̱u̱ha ha yaadooseerye myaka rukaaga na gu̱mwei̱, meezi̱ gaali goomi̱ri̱ ku nsi. Nu̱u̱ha yaaku̱u̱nyu̱u̱kwi̱ri̱ b̯wati̱ hakyendi̱, yaawona hanzei, yaawona nsi gyensei̱ gyomi̱ri̱ ");
INSERT INTO rub_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Kiro kya maku̱mi̱ gabiri na musanju kya mweri̱ gwakabiri nsi gyali gyomi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Mwomwo Ruhanga yaaweera Nu̱u̱ha naakoba yati, ");
INSERT INTO rub_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Huluka mu b̯wati̱, we, mu̱kali̱ waamu, batabani̱ baamu na bamukaabaana baamu. ");
INSERT INTO rub_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Hu̱lu̱kya b̯uli kihangwa kyomi kili na mubiri kyoli nakyo, bi̱nyoni̱, bisolo na bihangwa byensei̱ bilibatira hansi kandi bi̱byale bikanye mu nsi.” ");
INSERT INTO rub_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Nu̱u̱ha yaahu̱lu̱ki̱ri̱ mu b̯wati̱ na batabani̱ baamwe, na mu̱kali̱ waamwe, na bamukaabaana baamwe. ");
INSERT INTO rub_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Bisolo byensei̱ na bihangwa byensei̱ bilibatira heitehe kandi na bi̱nyoni̱ byensei̱, na b̯uli kintu kyensei̱ kilibata, byahu̱lu̱ki̱ri̱ mu b̯wati̱, b̯uli ki̱mwei̱ mu luganda lwakyo. ");
INSERT INTO rub_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Nu̱u̱ha yaabi̱mbi̱i̱ri̱ Mukama kyoto kyeihongo, yaakwata ha bisolo bidiib̯wa, na ha bi̱nyoni̱ bidiib̯wa yaabihonga, yaabyokeerya ha kyoto kyeihongo. ");
INSERT INTO rub_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Mukama b̯u̱yeegwi̱ri̱ kawu̱nyo karungi ka kihongwa yaakoba yati, “Ti̱ndi̱i̱ri̱ra kukyena nsi hab̯wa muntu, mutima gwamwe nab̯ugwabba gwicala gubiibi kuruga mu b̯uto b̯wamwe. Ti̱ndi̱i̱ra ku̱hwerekereerya bihangwa byensei̱ byomi nka ku̱nyaakoori̱. ");
INSERT INTO rub_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Nsi b̯ugilibba nigicaaliho, kusiga na kukesa, b̯wi̱nyamu̱ na b̯uhyo, kyanda na kibbaga, mwinsi nei̱jolo, tibilimalikaho.” ");
INSERT INTO rub_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Kandi Ruhanga yaaha Nu̱u̱ha na baana baamwe mu̱gi̱sa naakoba yati, “Mu̱byale, mukanye, mwi̱zu̱u̱lye nsi. ");
INSERT INTO rub_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Bisolo byensei̱ bya mu nsi, bi̱nyoni̱ byensei̱ bya mu mwanya, b̯uli kintu kyensei̱ kyesikiira heitehe, na nsu̱ zensei̱ za mwitaka, b̯yabati̱i̱nanga kandi byabekenganga, mu̱bi̱lemenge. ");
INSERT INTO rub_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Kintu kyensei̱ kyomi kandi kilibata mwakidyanga. Nka ku̱nyaabaheeri̱ bimera bya kisubi kibisi bibbenge byakudya byenyu̱, mbaheeri̱ bintu byensei̱ bibbe byakudya byenyu̱. ");
INSERT INTO rub_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Kyonkei mutalidya nyama na b̯womi b̯wagyo, lyolyo ibbanga. ");
INSERT INTO rub_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Kandi mu mananu, alibbwoma ibbanga lya muntu yensei̱ ndimufubira. Kakubba kisolo kya mwirungu ki̱i̱ta muntu ki̱semereeri̱ nakyo ki̱kwe. ");
INSERT INTO rub_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Yogwo yensei̱ abbwomi̱ri̱ ibbanga lya muntu, na lyamwe lilibbwomoka hab̯wakubba Ruhanga yaahangi̱ri̱ muntu mu kusisana kwamwe. ");
INSERT INTO rub_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Bei̱tu̱ nywe, mu̱byale, mukanye, mwi̱zu̱u̱lye nsi kandi mugileme.” ");
INSERT INTO rub_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Mwomwo Ruhanga yaaweera Nu̱u̱ha na batabani̱ baamwe naakoba yati, ");
INSERT INTO rub_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Hataati̱ mwegwenu, ndimu kukora ndagaanu na nywe kandi na beizukulu beenyu̱ gilibakwataho, ");
INSERT INTO rub_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","kandi na b̯uli kihangwa kyensei̱ kyoli nakyo, bi̱nyoni̱, bisolo bya bitungwa na bya mwirungu na bintu byensei̱ binyakuruga mu b̯wati̱. ");
INSERT INTO rub_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Nkoori̱ ndagaanu gyange nanywe gikukoba nti, bintu byensei̱ byomi ti̱ndi̱i̱ra ku̱bi̱zi̱kya na mwizulo gwa meezi̱, kandi mwizulo ti̱gu̱li̱i̱ra ku̱zi̱kya nsi.” ");
INSERT INTO rub_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Mwomwo Ruhanga yaakoba yati, “Kaka kooko kawoneru ka ndagaanu gya biro na biro ginkukora na nywe na b̯uli kihangwa kyensei̱ kimuli nakyo, kandi kalibba kawonero na ku bantu ba mu kasu̱mi̱ ka mu mei̱so. ");
INSERT INTO rub_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Nteeri̱ mu bikaka mu̱hengezi̱ma gwange, gu̱kwi̱za kubbanga kawoneru ka ndagaanu gi̱nkoori̱ nanywe na nsi gyensei̱. ");
INSERT INTO rub_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","B̯unyakabbumbanga iguru na bikaka kandi mu̱hengezi̱ma ni̱gu̱kezoolokyaho, ");
INSERT INTO rub_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","nyei̱zu̱kanga ndagaanu gyange nawe na bihangwa byensei̱ byomi, meezi̱ ti̱gali̱i̱ra kwizula ku̱hwerekereerya nywe na bihangwa byensei̱ byomi. ");
INSERT INTO rub_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Mu̱hengezi̱ma b̯u̱gwakezoolokyanga mu bikaka, nyakaguwonaga ni̱nyi̱zu̱ka ndagaanu gya biro na biro gi̱nyarageeni̱ hakati̱ waagya na bintu byensei̱ byomi bili mu nsi.” ");
INSERT INTO rub_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Ruhanga yaab̯u̱ni̱i̱rye yaaweera Nu̱u̱ha naakoba yati, “Gugu mu̱hengei̱zi̱ma kooko kawoneru ka ndagaanu gyange nawe na bihangwa byensei̱ bili mu nsi.” ");
INSERT INTO rub_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Batabani̱ ba Nu̱u̱ha banyakuruga mu b̯wati̱ baali, Seemu̱, Haamu na Yafeesi̱. Haamu yooyo munyakubyala Kanani̱. ");
INSERT INTO rub_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Mu batabani̱ ba Nu̱u̱ha bab̯wo basatu, hooho bantu bensei̱ ba mu nsi baaru̱gi̱i̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nu̱u̱ha yaatandi̱ki̱ri̱ kulima, yaasimba musiri gwa mi̱zabbi̱bbu̱. ");
INSERT INTO rub_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","B̯u̱yaakanyweri̱ho gi̱gyo vi̱i̱no, yaataamiira yaalaala mu heema gyamwei munyinghinyi, yeebbaka. ");
INSERT INTO rub_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Haamu Bba Kanani̱ b̯u̱yaaweeni̱ bbaawe naali munyinyi, yaagyendi̱ri̱ hanzei yaaweera baab̯u babiri. ");
INSERT INTO rub_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Seemu̱ na Yafeesi̱ baakwata kilwalu, bakita ha mabega, baagyenda ki̱nyenyu̱ma, babbumba Bbaawaab̯u batakamuwone b̯unyinghinyi. ");
INSERT INTO rub_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nu̱u̱ha maaci ga vi̱i̱no b̯u̱gakamu̱mali̱ki̱ri̱mwo, yaakenga mu̱tabani̱ waamwe muto ki̱yaamu̱koori̱, ");
INSERT INTO rub_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","yaamukyena naakoba yati, “Kanani̱ akyeneerwe! Yaabbanga mwiru akusembayo ki̱mwei̱ muli beiru bensei̱, kwokwo yatyo alibba mu baana bei̱ra baamwe.” ");
INSERT INTO rub_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Nu̱u̱ha yaab̯u̱ni̱i̱rye yaakoba yati, “ahaariizwe Mukama Ruhanga wa Seemu̱, Kanani̱ yaabbanga mwiru hali Seemu̱. ");
INSERT INTO rub_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Ruhanga akanyi̱sye Yafeesi̱, leka Yafeesi̱ ei̱calenge mu heema za Seemu̱, Kanani̱ yaabbanga mwiru hali Yafeesi̱.” ");
INSERT INTO rub_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Hei̱nyu̱ma gya mwizulo, Nu̱u̱ha yaamaari̱ myaka mindi bi̱ku̱mi̱ bisatu na maku̱mi̱ gataanu. ");
INSERT INTO rub_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Myaka myensei̱ Nu̱u̱ha mi̱yaamaari̱ myali rwenda na mitaanu (905), yaakwa. ");
INSERT INTO rub_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Baba boobo beizukulu ba Nu̱u̱ha ba batabani̱ baamwe, Seemu̱, Haamu na Yafeesi̱, baababyeri̱ hei̱nyu̱ma gya mwizulo gwa meezi̱. ");
INSERT INTO rub_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Gaga googo mabara ga batabani̱ ba Yafeesi̱: Gomeri̱, Magogi̱, Madaayi̱, Yavaani̱, Tu̱bali̱, Meseki̱ na Ti̱raasi̱. ");
INSERT INTO rub_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gaga googo mabara ga batabani̱ ba Gomeri̱: Asekenazi̱, Ri̱i̱faati̱ na Togarama. ");
INSERT INTO rub_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Batabani̱ ba Yavaani̱: Eri̱sa, Tarasi̱i̱si̱, bantu ba Ki̱ti̱mo na bantu ba Dodani̱. ");
INSERT INTO rub_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Muli bab̯wo hooho haaru̱gi̱ri̱ bantu banyakusaasaana mu nsi b̯uli luganda na lukobo lwaho, mahanga gaab̯u. ");
INSERT INTO rub_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Gaga googo mabara ga batabani̱ ba Haamu: Ku̱u̱si̱, Mi̱si̱ri̱, Pu̱u̱ti̱ na Kanani̱. ");
INSERT INTO rub_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Gaga googo mabara ga batabani̱ ba Ku̱u̱si̱: Sebba, Havi̱la, Sabi̱ta, Raama na Sabi̱teka. Mabara ga batabani̱ ba Raama googo gaga: Sebba na Dedani̱. ");
INSERT INTO rub_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Ku̱u̱si̱ yooyo munyakubyala Ni̱mu̱rodi̱, Ni̱mu̱rodi̱ yogwo yooyo yaali mu̱lwani̱ wa maani wakubanza mu nsi. ");
INSERT INTO rub_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Mukama yaamu̱wonengi̱ nali mu̱hi̱i̱gi̱ wamaani, hooho baatooleeri̱ kukoba nti, “Nka Ni̱mu̱rodi̱ Mukama yakufoora mu̱hi̱i̱gi̱ wamaani.” ");
INSERT INTO rub_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Mbuga zi̱i̱yalemi̱ri̱ kubanza zaali, Bbabbeeri̱, Ereki̱ Akadi̱ na Kalu̱ne, mbuga zi̱zo zensei̱ zili mu nsi gya Si̱naara. ");
INSERT INTO rub_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Ni̱mu̱rodi̱ b̯u̱yaaru̱gi̱ri̱ Si̱naara, yaagyenda Asi̱ri̱ya, yaabi̱mba mbuga zizi: Ni̱neeva, Rehobboosi̱, Kala, ");
INSERT INTO rub_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","na Reseni̱ luli hakati̱ gya Ni̱neeva na Kala. Reseni̱ lwolwo lwali rub̯uga lu̱handu̱. ");
INSERT INTO rub_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mi̱si̱ri̱ yaabyeri̱, bantu ba Lu̱u̱di̱mu̱, Anami̱mu̱, Lehabi̱mu̱, Nafu̱tu̱mu̱, ");
INSERT INTO rub_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Pasi̱ru̱si̱mu̱, Kasi̱ru̱hi̱mu̱, (yogo yooyo yaaru̱gi̱rwemwo Bafi̱ri̱si̱i̱ti̱) na Kafu̱toli̱mu̱. ");
INSERT INTO rub_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanani̱ yaabyeri̱ Si̱dooni̱, yooyo mwana waamwe mu̱zegei̱zo, yaateeryaho Heeti̱, ");
INSERT INTO rub_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Bayeb̯u̱si̱, Bamooli̱, Bagi̱ri̱gasi̱, ");
INSERT INTO rub_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Bahi̱i̱vi̱, Baali̱ki̱, Basi̱i̱ni̱, ");
INSERT INTO rub_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Bali̱vaadi̱, Bazeemali̱ na Bahamaati̱. Nganda za Bakanani̱ zasaaseeni̱ zaadwa hadei. ");
INSERT INTO rub_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Nsi ginyaakulemwanga Bakanani̱, gyatandi̱ki̱i̱rengi̱ Si̱dooni̱ mu matemba, kudwa masi̱ri̱mu̱ka ga Geraali̱, ku̱doosya Gaza, nigikwata b̯uhulukalyoba b̯wa Sodomu̱, Gomora, Adama na Zebboyi̱i̱mu̱, kudwa Laasa. ");
INSERT INTO rub_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Bab̯wo boobo beizukulu ba Haamu mu nganda zaab̯u, nkobo zaab̯u, nsi gyab̯u na mahanga gaab̯u. ");
INSERT INTO rub_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Seemu̱ yaali waab̯u Yafeesi̱ mu̱handu̱, kandi nayo Seemu̱ yaali na baana. Baana bensei̱ bʼEbberi̱ baali beizukulu ba Seemu̱. ");
INSERT INTO rub_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Batabani̱ ba Seemu̱, boobo: Eramu, Asu̱li̱, Ari̱paki̱saadi̱, Lu̱u̱di̱ nʼAramu. ");
INSERT INTO rub_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Batabani̱ bʼAramu boobo: U̱zi̱, Hu̱u̱li̱, Geteeri̱ na Maasi̱. ");
INSERT INTO rub_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Ari̱paki̱saadi̱, yooyo munyakubyala Seera, kandi Seeri̱ yaabyeri̱ Ebberi̱. ");
INSERT INTO rub_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ebberi̱ yogwo yaabyeri̱ batabani̱ babiri, ibara lyomwei̱ yooyo Peregi̱, hab̯wakubba mu biro byamwe nganda hooho zebagani̱i̱ryemwo. Kandi ibara lya waab̯u lyolyo Yoki̱taani̱. ");
INSERT INTO rub_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoki̱taani̱ yogwo yaabyeri̱ Ali̱modaadi̱, Serefu̱, Hazali̱maveeti̱, Yeera, ");
INSERT INTO rub_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoramu, U̱zali̱, Di̱ki̱ra, ");
INSERT INTO rub_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obali̱, Abi̱meeri̱, Sebba, ");
INSERT INTO rub_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofi̱ri̱, Havi̱la na Yobbabbu̱, bab̯wo bensei̱ baalingi nibali batabani̱ ba Yoki̱taani̱. ");
INSERT INTO rub_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Nsi gibaalingimwo gyatandi̱ki̱i̱rengi̱ Meesa kudwa kwansi b̯wa Sefara, na kwansi wa nsahu za b̯uhulukalyoba. ");
INSERT INTO rub_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Baba boobo beizukulu ba Seemu̱, nka ku̱si̱gi̱ki̱ra mu nganda zaab̯u, nkobo zaab̯u, mu mahanga gaab̯u na nsi zaab̯u. ");
INSERT INTO rub_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Zi̱zo zoozo nganda za beizukulu ba Nu̱u̱ha, ku̱si̱gi̱ki̱ra mu b̯ubyalisanwa waab̯u, mu mahanga gaab̯u na mu̱li̱ngo gaasaaseeni̱ mu nsi gyensei̱ hei̱nyu̱ma gya mwizulo gwa meezi̱. ");
INSERT INTO rub_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Mu biro bi̱byo, nsi gyensei̱ gyali na lukobo lu̱mwei̱ na bigambu bikwisana. ");
INSERT INTO rub_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Bantu b̯u̱baafu̱ru̱ki̱ri̱ kuruga b̯uhulukalyoba, baagya kyeya kinyakubba mu nsi gya Si̱naara. ");
INSERT INTO rub_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Baaweeragana nibakoba yati, “Mwi̱ze tub̯umbe matafaali tu̱gookye kurungi.” Mu kiikaru kya mahi̱ga, baakoreseerye matafaali; kandi mu kiikaru kya b̯u̱dongo, baakoresya kolasi̱. ");
INSERT INTO rub_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Hei̱nyu̱ma, baakoba yati, “Tu̱bi̱mbe rub̯uga lulimwo munaara gukudwa mwiguru, aleke tu̱ku̱me, tutasaasaana mu nsi gyensei̱.” ");
INSERT INTO rub_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Nahab̯waki̱kyo, Mukama yaasi̱ri̱mu̱ki̱ri̱, yei̱za kuwona rub̯uga na munaara gwa baana ba bantu gu̱baku̱bi̱mba. ");
INSERT INTO rub_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Mukama yaabazi̱ri̱ naakoba yati, “Muwone baba bantu bali bamwei̱, kandi bensei̱ bakubaza lukobo lu̱mwei̱, kandi kiki kyokyo kya ha ntandiko ha bintu bi̱bakwi̱za kukora, kandi tihaloho kibaliteekereza kukora nikikabalema. ");
INSERT INTO rub_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Mwi̱ze tu̱si̱ri̱mu̱ke, tutabatab̯ure lukobo lwab̯u, aleke bategwagana.” ");
INSERT INTO rub_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Nahab̯waki̱kyo, Mukama yaabasaasaani̱a mu nsi gyensei̱, beemeera ku̱bi̱mba lu̱lwo rub̯uga. ");
INSERT INTO rub_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Kyokyo rub̯uga lu̱lwo baalweti̱ri̱ Bbabbeeri̱, hab̯wakubba hahwo, hooho Mukama yaatab̯u̱tab̯u̱li̱i̱ri̱ lukobo lunyaakubazwanga mu nsi gyensei̱, kuruga hahwo Ruhanga yaabasasaasaani̱a mu nsi gyensei̱. ");
INSERT INTO rub_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Baba boobo beizukulu ba Seemu̱: Seemu̱ b̯uyaali na myaka ki̱ku̱mi̱ (100) mya b̯u̱handu̱, yaabyeri̱ Ari̱paki̱saadi̱, b̯u̱b̯wo haali harabi̱ri̱ho myaka mibiri mwizulo gwa meezi̱ gu̱mali̱ki̱ri̱ mu nsi. ");
INSERT INTO rub_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Hei̱nyu̱ma gya Seemu̱ kubyala Ari̱paki̱saadi̱, yaamaari̱ myaka mindi bi̱ku̱mi̱ bitaanu (500) mya b̯u̱handu̱, yaabyala baana bandi ba b̯udulu na ba b̯uhala. ");
INSERT INTO rub_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Ari̱paki̱saadi̱ b̯uyaali na myaka maku̱mi̱ gasatu na mitaanu (35) mya b̯u̱handu̱, yaabyala Seera. ");
INSERT INTO rub_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Hei̱nyu̱ma gya Ari̱paki̱saadi̱ kubyala Seera, yaamaari̱ myaka mindi bi̱ku̱mi̱ binei na misatu (403) mya b̯u̱handu̱, yaabyala baana bandi ba b̯udulu na ba b̯uhala. ");
INSERT INTO rub_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Seera b̯u̱yaadooseerye myaka maku̱mi̱ gasatu (30) mya b̯u̱handu̱, yaabyala Ebberi̱. ");
INSERT INTO rub_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Seera b̯u̱yaamaari̱ kubyala Ebberi̱, yaamaari̱ myaka mindi bi̱ku̱mi̱ binei na misatu (403) mya b̯u̱handu̱, yaabyala baana bandi, ba b̯udulu na ba b̯uhala. ");
INSERT INTO rub_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ebberi̱ b̯u̱yaadooseerye myaka maku̱mi̱ gasatu na minei (34) mya b̯u̱handu̱, yaabyala Peregi̱. ");
INSERT INTO rub_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Ebberi̱ b̯u̱yaamaari̱ kubyala Peregi̱, yaamaari̱ myaka mindi bi̱ku̱mi̱ binei na maku̱mi̱ gasatu (430) mya b̯u̱handu̱, yaabyala baana bandi ba b̯udulu na ba b̯uhala. ");
INSERT INTO rub_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peregi̱ b̯u̱yaadooseerye myaka maku̱mi̱ gasatu (30) mya b̯u̱handu̱, yaabyala Lehu̱. ");
INSERT INTO rub_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Peregi̱ b̯u̱yaamaari̱ kubyala Lehu̱, yaamaari̱ myaka mindi bi̱ku̱mi̱ bibiri na mwenda (209) mya b̯u̱handu̱, yaabyala baana bandi ba b̯udulu na ba b̯uhala. ");
INSERT INTO rub_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Lehu̱ b̯u̱yaadooseerye myaka maku̱mi̱ gasatu na mibiri (32) mya b̯u̱handu̱, yaabyala Seru̱gi̱, ");
INSERT INTO rub_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Lehu̱ b̯u̱yaamaari̱ kubyala Seru̱gi̱, yaamaari̱ myaka mindi bi̱ku̱mi̱ bibiri na musanju (207) mya b̯u̱handu̱, yaabyala baana bandi ba b̯udulu na ba b̯uhala. ");
INSERT INTO rub_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Seru̱gi̱ b̯u̱yaadooseerye myaka maku̱mi̱ gasatu (30) mya b̯u̱handu̱, yaabyala Nahoori̱. ");
INSERT INTO rub_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Seru̱gi̱ b̯u̱yaamaari̱ kubyala Nahoori̱, yaamaari̱ myaka mindi bi̱ku̱mi̱ bibiri (200) mya b̯u̱handu̱, yaabyala baana bandi ba b̯udulu na ba b̯uhala. ");
INSERT INTO rub_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahoori̱ b̯u̱yaadooseerye myaka maku̱mi̱ gabiri na mwenda (29) mya b̯u̱handu̱, yaabyala Teera, ");
INSERT INTO rub_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","hei̱nyu̱ma gya Nahoori̱ kubyala Teera, yaamaari̱ myaka mindi ki̱ku̱mi̱ nei̱ku̱mi̱ na mwenda (119) mya b̯u̱handu̱,, yaabyala baana bandi ba b̯udulu na ba b̯uhala. ");
INSERT INTO rub_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Teera b̯u̱yaadooseerye myaka nsanju (70) mya b̯u̱handu̱, yaabyala I̱bbu̱ramu̱, Nahoori̱ na Harani̱. ");
INSERT INTO rub_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Baba boobo beizukulu ba Teera. Teera yaabyeri̱ I̱bbu̱ramu̱, Nahoori̱ na Harani̱. Harani̱ yaabyeri̱ Looti̱. ");
INSERT INTO rub_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Harani̱ yaakwi̱ri̱ bbaawe Teera atakakwi̱ri̱. Yaakwereeri̱ mu rub̯uga lwa U̱la mu nsi gya Bakalidaaya hali yaabyali̱i̱rwe. ");
INSERT INTO rub_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","I̱bbu̱ramu̱ na Nahoori̱, baatu̱ngi̱ri̱ bakali̱. Ibara lya mukaa I̱bbu̱ramu̱ lyali Saraayi̱, kandi lya mukaa Nahoori̱, lyali Mi̱ri̱ka. Mi̱ri̱ka yaali muhara wa Harani̱ munyakubba de bbaa I̱si̱ka. ");
INSERT INTO rub_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Saraayi̱ yaali ngumba, atakabbe na mwana. ");
INSERT INTO rub_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Teera yaasengi̱ri̱ mu̱tabani̱ I̱bbu̱ramu̱ na mwizukulu Looti̱, mwana wa Harani̱, na Saraayi̱ mukaamwana, mukaa I̱bbu̱ramu̱, baagyenda hamwei̱, baaruga mu nsi U̱la gya Bakalidaaya, baagyenda mu nsi gya Kanani̱, bei̱tu̱ b̯u̱baadoori̱ Harani̱, babi̱mba beicala. ");
INSERT INTO rub_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Teera yaamaari̱ myaka bi̱ku̱mi̱ bibiri na mitaanu (205) mya b̯u̱handu̱, yaakwera mu nsi gya Harani̱. ");
INSERT INTO rub_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Kasi Mukama yaaweera I̱bbu̱ramu̱ naakoba yati, “Demuka oruge mu nsi gyamu, oruge hali bantu baamu, oruge mu nnyu̱mba gya Bbaawu, ogyende mu nsi gi̱nkwi̱za ku̱kwolokya. ");
INSERT INTO rub_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Ndikufoora ihanga likooto, ndikuha mu̱gi̱sa, ibara lyamu ndilifoora lya ki̱ti̱i̱ni̱sa aleke obbe mu̱gi̱sa hali bandi. ");
INSERT INTO rub_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Bab̯wo baakusabiranga mu̱gi̱sa, nyaabahanga mu̱gi̱sa, kandi yogwo yaakukyenanga nagya nyaamukyenanga, mahanga gensei̱ galitunga mu̱gi̱sa kuraba muli we.” ");
INSERT INTO rub_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Nahab̯waki̱kyo I̱bbu̱ramu̱ yaagyendi̱ri̱ nka Mukama ku̱yaamu̱ragi̱i̱ri̱, yaatwalegeeni̱ Looti̱. I̱bbu̱ramu̱ kuruga Harani̱ yaali adooseerye myaka nsanju na mitaanu mya b̯u̱handu̱. ");
INSERT INTO rub_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Yaatweri̱ Saraayi̱ mu̱kali̱ waamwe, Looti̱ mwana wa waab̯u, bintu byab̯u byensei̱ bibaalingi batu̱ngi̱ri̱, na bantu babaalingi baatu̱ngi̱ri̱ mu nsi gya Harani̱, baasetuka baagyenda Kanani̱. ");
INSERT INTO rub_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Yaadoori̱ mu kiikaru kibakweta Sekemu̱, cali haali musaali mu̱si̱sye mu nsi gya Moore. Mu kasu̱mi̱ kakwo, Bakanani̱ boobo baalingi nibali mu nsi gi̱gyo. ");
INSERT INTO rub_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Mwomwo, Mukama yaawonekeera I̱bbu̱ramu̱, yaamuweera naakoba yati, “Gigi nsi gyogyo nkwi̱za kuha beizukulu baamu.” Nahab̯waki̱kyo, I̱bbu̱ramu̱ yaabi̱mbi̱ri̱ kyoto kyeihongo hahwo, yaaki̱bi̱mbi̱i̱ri̱ Mukama munyakumuwonekera. ");
INSERT INTO rub_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","B̯u̱yaaru̱gi̱ri̱ hahwo yaagyendi̱ri̱ ha nsahu zinyakubba b̯uhulukalyoba b̯wa Bbeseeri̱, yaabamba heema gyamwe, Bbeseeri̱ gyabba b̯ugwalyoba kandi Ai̱ gyabba b̯uhulukalyoba. Mu ki̱kyo kiikaru yaabi̱mbi̱ri̱ho kyoto kyeihongo yaaramya Mukama. ");
INSERT INTO rub_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","I̱bbu̱ramu̱ yaagyendi̱ri̱ mu mei̱so na lugyendu lwamwe, yaakwata muhanda gukugyenda Negeb̯u̱. ");
INSERT INTO rub_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Mu kasu̱mi̱ kakwo, nzala gyagwi̱ri̱ mu ki̱kyo kicweka, I̱bbu̱ramu̱ yaafuruka yaagyenda kwicala Mi̱si̱ri̱, hab̯wa nzala ginene. ");
INSERT INTO rub_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Bei̱tu̱ b̯uyaali heehi̱ kwingira Mi̱si̱ri̱, yaaweera Saraayi̱ mu̱kali̱ waamwe naakoba yati, “Nkyegi̱ri̱ nka kwoli mu̱kali̱ nyarurungi, ");
INSERT INTO rub_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Banyami̱si̱ri̱ b̯ubakakuwona bakwi̱za kukoba yati, ‘Yogo ali mu̱kali̱ waamwe.’ Hei̱nyu̱ma bakwi̱za ku̱nzi̱ta, bei̱tu̱ we bakwi̱za kukuleka obbe mwomi. ");
INSERT INTO rub_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Nahab̯waki̱kyo we obaweere yati oli nyakeetu̱ aleke bankwate kurungi hab̯wamu.” ");
INSERT INTO rub_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","I̱bbu̱ramu̱ b̯u̱yaadoori̱ Mi̱si̱ri̱, Banyami̱si̱ri̱ baaweeni̱ mu̱kali̱ waamwe naali nyab̯urungi kwo. ");
INSERT INTO rub_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Kandi bayolo ba Faraaho nabo baamu̱haari̱i̱ze hali Faraaho, Saraayi̱ baamutwala mu kikaali kya Faraaho. ");
INSERT INTO rub_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Faraaho yaaheeri̱ I̱bbu̱ramu̱ ki̱ti̱i̱ni̱sa hab̯wa Saraayi̱, yaaha I̱bbu̱ramu̱ ntaama na nte, ndogoyi̱ zidulu, baheereza badulu, baheereza bakali̱, ndogoyi̱ gi̱kali̱ na ngamira. ");
INSERT INTO rub_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Bei̱tu̱ Mukama yaasi̱ndi̱ki̱i̱ri̱ Faraaho na ba makaa gaamwe ki̱i̱zo kya nseeri̱ ginyamaani hab̯wa Saraayi̱ mukaa I̱bbu̱ramu̱. ");
INSERT INTO rub_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Faraaho yeeti̱ri̱ I̱bbu̱ramu̱ yaamu̱b̯u̱u̱lya naakoba yati, “Kikyani kiki kyonkoori̱? Hab̯waki otambwereeri̱ Saraayi̱ nka kwali mu̱kali̱ waamu? ");
INSERT INTO rub_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Hab̯waki waabazi̱ri̱ nookoba yati, ‘Yogwo ali nyaakeetu̱?’ Ki̱kyo kyokyo kinyakumpa kumutwala kubba mu̱kali̱ wange. Hataati̱ mu̱kali̱ waamu ngogo yo mukwate Weegyendera!” ");
INSERT INTO rub_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Mwomwo Faraaho yaaragira badulu baamwe baherekeere I̱bbu̱ramu̱ hamwei̱ na mu̱kali̱ waamwe na bintu byab̯u baamutwala ha mutaanu. ");
INSERT INTO rub_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Nahab̯waki̱kyo I̱bbu̱ramu̱ yaaru̱gi̱ri̱ Mi̱si̱ri̱, yo I̱bbu̱ramu̱ na mu̱kali̱ waamwe na byensei̱ biyaali nabyo, na Looti̱ yaagyendi̱ri̱ nayo, baadwa Negeb̯u̱. ");
INSERT INTO rub_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Ha kasu̱mi̱ kaka I̱bbu̱ramu̱ yaali atu̱ngi̱ri̱ itungu linene hoi̱, nte, feeza na zaabbu. ");
INSERT INTO rub_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Yaaru̱gi̱ri̱ Negeb̯u̱ yaakuba yeicala hakati̱ wa Bbeseeri̱ na Ai̱ hali yaabanzi̱ri̱ kwicala. ");
INSERT INTO rub_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Mu kiikaru ha yaabanzi̱ri̱ ku̱bi̱mba kyoto kyeihongo hooho de yaarami̱i̱rye Mukama. ");
INSERT INTO rub_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Looti̱ yogwo munyakugyenda nʼI̱bbu̱ramu̱, nayo yaali na magana ga ntaama, mbu̱li̱, magana ga nte, na heema zinene. ");
INSERT INTO rub_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Nahab̯waki̱kyo, itehe lyali litakubamala babiri kwicala hamwei̱, hab̯wakubba itungu lyab̯u lyali linene hoi̱, batakusobora kwicala hamwei̱. ");
INSERT INTO rub_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Kandi bali̱i̱sya ba nte zʼI̱bbu̱ramu̱ na ba za Looti̱, bei̱calengi̱ nibazongoba. Mu kasu̱mi̱ kakwo, Bakanani̱ nʼAbaperezi̱ boobo baali mu nsi gi̱gyo. ");
INSERT INTO rub_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","I̱bbu̱ramu̱ yaaweera Looti̱ naakoba yati, “Tikili kirungi gya nawe kwicala nitusikagana kandi tikili kirungi bali̱i̱sya bange na baamu kwicala nibakuuta mpaka kubba tuli baluganda lu̱mwei̱. ");
INSERT INTO rub_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Nsi gi̱gyo gili mu mei̱so gaamu ogi̱weeni̱? Twahukane, wakabba nookwendya ogyende ha mukono gwab̯umoso, gya ngyende ha mukono gwab̯udyo, rundi we okwate ha mukono gwab̯udyo, gya nkwate ha mukono gwab̯umoso.” ");
INSERT INTO rub_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Looti̱ yaabyokeerye mei̱so yaawona kyeya kya Yorodaani nka ku̱kyazokengi̱ kurungi. Meezi̱ gaali hensei̱ nka musiri gwa Mukama na nsi gya Mi̱si̱ri̱ kugyali, magyenda ga Zowali̱. (Kiki kyabbeeri̱ho Mukama atakahwerekereerye Sodomu̱ na Gomora.) ");
INSERT INTO rub_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Nahab̯waki̱kyo, Looti̱ yeekomeeri̱ kyeya kyensei̱ kya Yorodaani, yaakwata gwa b̯uhulukalyoba, kwokwo baahu̱keeni̱ yati. ");
INSERT INTO rub_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","I̱bbu̱ramu̱ yei̱ceeri̱ mu nsi gya Kanani̱ kandi Looti̱ yeicala hakati̱ wa mbuga za mu kyeya, yaabambi̱ri̱ heema gyamwe, heehi̱ na Sodomu̱. ");
INSERT INTO rub_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Mu kasu̱mi̱ kakwo bantu ba Sodomu̱ baalingi babiibi, baheneeri̱ hoi̱ hali Mukama. ");
INSERT INTO rub_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Looti̱ b̯u̱yaamaari̱ kwahukana nʼI̱bbu̱ramu̱, Mukama yaaweera I̱bbu̱ramu̱ naakoba yati, “Byokya mei̱so gaamu owone hooli ha matemba na masi̱ri̱mu̱ka, mukono gwa b̯uhulukalyoba na b̯ugwalyoba, ");
INSERT INTO rub_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","hab̯wakubba nsi gi̱gyo gyensei̱ gyokuwona, ndigikuha, ngihe na beizukulu baamu biro byensei̱. ");
INSERT INTO rub_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ndi̱kanyi̱sya beizukulu baamu nkeicuucu lya mu nsi. B̯ukyakabba nikikusoboka kubala cuucu lya mu nsi. B̯u̱di̱ na beizukulu baamu balisobora kubabala. ");
INSERT INTO rub_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Byoka olibate orabe mu gigi nsi, weetegereza b̯ulei na b̯ugali waagyo, hab̯wakubba ndigikuha.” ");
INSERT INTO rub_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Nahab̯waki̱kyo I̱bbu̱ramu̱ yei̱hi̱ri̱ heema gyamwe, yaagyenda yeicala heehi̱ na misaali mi̱si̱sye mya Mamu̱le mu Hebbu̱rooni̱ ku̱kwo hooho yaabi̱mbi̱i̱ri̱ Mukama kyoto kyeihongo. ");
INSERT INTO rub_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Mu biro bya Amu̱rafeeri̱ mukama wa Si̱naara, nʼAlyoki̱ mukama wʼErasaali̱, Kedolahomeeri̱ mukama wʼEremu̱, na Ti̱dali̱ mukama wa Goi̱mi̱, ");
INSERT INTO rub_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","bakama bab̯wo baalwani̱si̱i̱rye Bbeera mukama wa Sodomu̱, Bbi̱ri̱i̱sa mukama wa Gomora, Si̱nabi̱ mukama wʼAdama, Semeeberi̱ mukama wa Zebboyi̱i̱mu̱, na mukama wa Bbela (hataati̱ gyegebeerwe nka Zowali̱). ");
INSERT INTO rub_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Bakama bab̯wo bensei̱ bababazi̱ri̱ho baacooki̱ri̱ mahe gaab̯u mu kihanga kya Si̱di̱mi̱ (hataati̱ kyegebeerwe nka kihanga kyʼItaka lya Mu̱kwa). ");
INSERT INTO rub_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Baalingi bamaari̱ myaka i̱ku̱mi̱ na mibiri nibakufugwa Kedolahomeeri̱, bei̱tu̱ mu mwaka gwei̱ku̱mi̱ na misatu, baamu̱jeemera. ");
INSERT INTO rub_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Mu mwaka gwei̱ku̱mi̱ na minei, Kedolahomeeri̱ na bakama bandi banyakubba nibali nayo, bei̱zi̱ri̱ baalwani̱sya baasi̱ngu̱ra Balefai̱mu̱ banyakwicalanga mu nsi gyʼAsi̱tarooti̱-karu̱nayi̱mu̱, na Bazu̱u̱zi̱ mu Haamu̱, Bami̱i̱mu̱ mu nsi gya Saave-ki̱ri̱yati̱mu̱, ");
INSERT INTO rub_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","baasi̱ngu̱ra na Bahooli̱ banyakubba nibali mu nsi gya mu nsahu za Sei̱ri̱, kudwera ki̱mwei̱ Eri̱parani̱ ha mitaanu mya irungu. ");
INSERT INTO rub_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Nahahwo, baali̱beeti̱ baadwa Eni̱mi̱si̱pate (hataati̱ gyegebeerwe nka Kadesi̱) baalwani̱sya nsi gyensei̱ gya Bamaleki̱, na Bamooli̱, banyakwicalanga Haazazoni̱-tamara, baasi̱ngu̱ra. ");
INSERT INTO rub_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Hei̱nyu̱ma, mukama wa Sodomu̱, mukama wa Gomora, mukama wʼAdama, mukama wa Zebboyi̱i̱mu̱ na mukama wa Bbela (hataati̱ gyegebeerwe nka Zowali̱) baaru̱mbi̱ri̱, baagyenda kulwana mu kyeya kya Si̱di̱i̱mu̱. ");
INSERT INTO rub_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Baalweni̱ na Kedolahomeeri̱ mukama wʼEremu̱, Ti̱dali̱ mukama wa Goyi̱mu̱, Amu̱rafeeri̱ mukama wa Si̱naara, nʼAlyoki̱ mukama wʼErasaali̱, baali bakama banei ni̱baku̱lwani̱sya bakama bataanu. ");
INSERT INTO rub_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Mu kasu̱mi̱ kakwo, kihanga kya Si̱di̱i̱mu̱ kyalingimwo bi̱i̱na binene. Mukama wa Sodomu̱ na wa Gomora b̯ubaalingi ni̱bakwi̱ru̱ka na mahe gaab̯u, bamwei̱ baagwi̱ri̱ mu bi̱byo bi̱i̱na, bandi bei̱ru̱ka mu nsahu. ");
INSERT INTO rub_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Kasi banyanzigwa baatwala bintu byensei̱ bya Sodomu̱ na Gomora na bidyo beegyendera. ");
INSERT INTO rub_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Baanyagi̱ri̱ Looti̱ mu̱tabani̱ wa waab̯u I̱bbu̱ramu̱, munyakwicalanga Sodomu̱, baanyaga na bintu byamwe, baagyenda. ");
INSERT INTO rub_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Muntu omwei̱ munyakukena mu b̯ulemu yei̱zi̱ri̱ yaaweera I̱bbu̱ramu̱ Muhebburaniya munyakwicalanga heehi̱ na misaali mi̱si̱sye mya muntu gibakweta Mamu̱le Mu̱mooli̱, waab̯u Esi̱kooli̱ nʼAneri̱, baba baalingi barageeni̱ nʼI̱bbu̱ramu̱. ");
INSERT INTO rub_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","I̱bbu̱ramu̱ b̯u̱yeegwi̱ri̱ munyaruganda waamwe bamu̱nyagi̱ri̱, yaaramaga hamwei̱ na badulu baamwe balwani̱ kuruga mu nnyu̱mba gyamwe bakudwa bi̱ku̱mi̱ bisatu nei̱ku̱mi̱ na munaanei (318), baamuhondeera kudwa mpaka Daani̱. ");
INSERT INTO rub_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Yaabagani̱i̱ryemwo i̱he lyamwe yaabatwala kulwana mu b̯wi̱re b̯wei̱jolo, yo na baheereza baamwe baakweti̱ bamwei̱, bandi baababinga baabadoosya Hoba, matemba ga rub̯uga lwa Damasi̱ko. ");
INSERT INTO rub_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Hahwo yei̱ri̱i̱rye Looti̱ munyakubba wa luganda lwamwe na bintu byamwe, bakali̱ na bantu banyakubba baanyaagi̱i̱rwe. ");
INSERT INTO rub_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","I̱bbu̱ramu̱ b̯u̱yei̱ri̱ri̱, amaari̱ ku̱si̱ngu̱ra Kedolahomeeri̱ na bakama bandi banyakubba nibali nayo, mukama wa Sodomu̱ yaagyenda ku̱mu̱romba mu kihanga kya Saave (hataati̱ kyegebeerwe nka kihanga kya Mukama). ");
INSERT INTO rub_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Meleki̱zedeki̱ mukama wa Salemu̱, yaaleeti̱ri̱ mugaati na vi̱i̱no, Meleki̱zedeki̱ yogwo, yaali mu̱laami̱ wa Ruhanga Waahakyendi̱ Hoi̱. ");
INSERT INTO rub_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Yaasabi̱i̱ri̱ I̱bbu̱ramu̱ mu̱gi̱sa naakoba yati, “Ruhanga Waahakyendi̱ Hoi̱, mu̱hangi̱ weiguru na nsi, ahe I̱bbu̱ramu̱ mu̱gi̱sa. ");
INSERT INTO rub_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ruhanga Waahakyendi̱ Hoi̱, aku̱si̱ngu̱ri̱i̱si̱i̱rye banyanzigwa baamu ahaariizwe!” I̱bbu̱ramu̱ yaaha Meleki̱zedeki̱ ki̱mwei̱ kyei̱ku̱mi̱ kya byensei̱ bi̱yaagu̱mi̱si̱i̱rye ");
INSERT INTO rub_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Mukama wa Sodomu̱ yaaweereeri̱ I̱bbu̱ramu̱ naakoba yati, “Gya mpa bantu, bei̱tu̱ we, otwale bintu.” ");
INSERT INTO rub_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Bei̱tu̱ I̱bbu̱ramu̱ yei̱ri̱ri̱mwo mukama wa Sodomu̱ naakoba yati, “Ndahi̱i̱ri̱ Mukama Ruhanga Waahakyendi̱ Hoi̱, mu̱hangi̱ weiguru na nsi, ");
INSERT INTO rub_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","tinsobora kutwala kahu̱u̱zi̱ rundi lukobba lwa nkei̱to, rundi kintu kyamu kwokwo oteicalanga nookoba yati, ‘Gyagya nyaatu̱ngi̱si̱i̱rye I̱bbu̱ramu̱ itungu.’ ");
INSERT INTO rub_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Ti̱nkwi̱za kutwala kintu kyensei̱, bibalimbalira byobyo bidyo binyakudiiwa basigazi, na mugab̯u gwa bantu banyakugyenda nagya. Leka Aneri̱, Esi̱kooli̱ na Mamu̱le batwale mugab̯u gwab̯u.” ");
INSERT INTO rub_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Bi̱byo b̯u̱byamali̱ki̱ri̱, Mukama yaabazi̱ri̱ nʼI̱bbu̱ramu̱ na mu kilooto yaamuweera naakoba yati, “I̱bbu̱ramu̱ leka ku̱ti̱i̱na, nyakulindanga, mpeera gyamu gilibba gikooto hoi̱.” ");
INSERT INTO rub_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","I̱bbu̱ramu̱ yaakoba yati, “Ai̱ Mukama Ruhanga, olimpa kyani? Wona tinkabyalanga mwana. Mu̱damasi̱ko Eryeza yooyo mugwete wange. ");
INSERT INTO rub_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Gya otakampe lubyalu, nahab̯waki̱kyo muheereza munyakubyalwa mu makaa gange yooyo alibba mugwete wange.” ");
INSERT INTO rub_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Nahahwo yeegwi̱ri̱ Mukama naakukoba yati, “Mudulu yogwo talibba mugwete waamu, mwana gi̱webyali̱i̱ri̱ yooyo alibba mugwete waamu.” ");
INSERT INTO rub_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Ruhanga yaahu̱lu̱kya I̱bbu̱ramu̱ hanzei, yaamuweera naakoba yati, “Lingiira heiguru owone nzota zi̱zo wakabba nokusobora kuzibala.” Yaab̯u̱ni̱i̱rye yaakoba yati, “Beizukulu baamu kwokwo balibba banene yatyo!” ");
INSERT INTO rub_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","I̱bbu̱ramu̱ yei̱ki̱ri̱ri̱i̱ze mu Mukama, Mukama yaamutwala kubba asemeeri̱. ");
INSERT INTO rub_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Mukama yaaweereeri̱ I̱bbu̱ramu̱ naakoba yati, “Gyagya Mukama munyakukutoola mu nsi gya U̱la gya Bakalidaaya, nkuhe gigi nsi ogitwale.” ");
INSERT INTO rub_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Bei̱tu̱ I̱bbu̱ramu̱ yaamwi̱ri̱mwo naakoba yati, “Ai̱ Mukama Ruhanga, nyeega teetei̱ nka kunditunga gigi nsi?” ");
INSERT INTO rub_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Mukama yaamwi̱ri̱ri̱mwo naakoba yati, “Ndetera nyana gi̱dooseerye myaka misatu, b̯uguma gya mbu̱li̱ gya myaka misatu, na mpaya gya ntaama gya myaka misatu, kolome wa mwirungu na kolome muto wa kwamu̱gi̱.” ");
INSERT INTO rub_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","I̱bbu̱ramu̱ bi̱byo byensei̱ yaabi̱leteeri̱ Mukama, yaabyatyamwo hakati̱ b̯uli kipacu yaakita ha rubaju lundi, bei̱tu̱ makolome atakagaatyemwo. ");
INSERT INTO rub_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Masega b̯u̱gei̱ci̱i̱rye ha nnyama zi̱zo, I̱bbu̱ramu̱ yaagabinga. ");
INSERT INTO rub_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Lyoba b̯ulyali nilikugwa, I̱bbu̱ramu̱ b̯ulo waamaani waamukwata, nti̱ti̱ gya zigizigi gi̱ku̱ti̱ni̱i̱sya gyamubbumba. ");
INSERT INTO rub_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Mwomwo Mukama Ruhanga yaakoba yati, “Nyegeeri̱ ki̱mwei̱ beizukulu baamu nka kubalibba banyamahanga mu nsi gitali gya kwamwab̯u, balibba beiru mu gi̱gyo nsi, balibakora kubiibi kumala myaka bi̱ku̱mi̱ binei. ");
INSERT INTO rub_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Bei̱tu̱ ihanga likubafuga ndilifubira, hei̱nyu̱ma baruge mu gi̱gyo nsi nibali na bintu binene. ");
INSERT INTO rub_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Bei̱tu̱ we oli̱kwa ogu̱lu̱u̱si̱ri̱ hoi̱, oli̱zi̱i̱kwa mu b̯u̱si̱nge. ");
INSERT INTO rub_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Beizukulu baamu baali̱i̱ra mu gigi nsi ha mu̱hi̱hi̱ gwakanei. Ha kasu̱mi̱ kakwo hooho ndifubira Bamooli̱ hab̯wa bibiibi byab̯u. Bei̱tu̱ hataati̱ kasu̱mi̱ kakubafubira kacaali kudwa.” ");
INSERT INTO rub_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Lyoba b̯u̱lyamaari̱ ku̱gwa nti̱ti̱, gi̱kweti̱ haazooki̱ri̱ bintu bibiri, si̱gi̱ri̱ ni̱ki̱ku̱tu̱u̱ka mwi̱ca, na lumule lukwaka, byarabi̱ri̱ hakati̱ wa bicweka bya nnyama zi̱zo. ");
INSERT INTO rub_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Kiro ki̱kyo, Mukama yaakoori̱ ndagaanu nʼI̱bbu̱ramu̱ naakoba yati, “Nsi gigi ndigiha beizukulu baamu, kuruga ha mugira gwa Mi̱si̱ri̱ ku̱doosya ha mugira gukooto Efu̱raati̱, ");
INSERT INTO rub_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","nsi gya Bakeeni̱, Bakenezi̱, Bakademooni̱, ");
INSERT INTO rub_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Bahi̱i̱ti̱, Baperezi̱, Balefai̱mu̱, ");
INSERT INTO rub_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Bamooli̱, Bakanani̱, Bagi̱ri̱gasi̱, na Bayeb̯u̱si̱.” ");
INSERT INTO rub_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Saraayi̱ mukaa I̱bbu̱ramu̱ yaali atamu̱byali̱i̱ri̱ baana. Saraayi̱ yaali na muzaana Mu̱nyami̱si̱ri̱, gibakweta Hagara, ");
INSERT INTO rub_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Saraayi̱ yaaweereeri̱ I̱bbu̱ramu̱ naakoba yati, “Gya Mukama yantangi̱ri̱ kubyala baana, temba ntabbu gya muzaana wange, ambyalireyo baana.” I̱bbu̱ramu̱ yeegwi̱ri̱ Saraayi̱ ki̱yaamu̱weereeri̱. ");
INSERT INTO rub_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","I̱bbu̱ramu̱ yogwo, yaali amaari̱ myaka i̱ku̱mi̱ naali mu nsi gya Kanani̱, Saraayi̱ mu̱kali̱ waamwe kumuha Hagara Mu̱nyami̱si̱ri̱ muzaana waamwe amutunge. ");
INSERT INTO rub_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","I̱bbu̱ramu̱ yaagyendi̱ri̱ hali Hagara, Hagara yeemeti̱ri̱. Kandi b̯u̱yaaweeni̱ atweri̱ nda, yaatandika kugaya mu̱go waamwe. ");
INSERT INTO rub_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Saraayi̱ yaaweereeri̱ I̱bbu̱ramu̱ naakoba yati, “Nsobi̱ gili gyamu! Nyaaku̱heeri̱ muzaana wange omuswere, b̯u̱yaaweeni̱ yeemeti̱ri̱, yaatandika kungaya. Onkoori̱ kubii, Mukama ali̱ku̱tongonesya hab̯wa ki̱kyo kyokoori̱.” ");
INSERT INTO rub_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Bei̱tu̱ I̱bbu̱ramu̱ yaamwi̱ri̱ri̱mwo naakoba yati, “Nkoba muzaana yogwo abba waamu, weewe omulema, mukore kyokwendya.” Nahaahwo Saraayi̱ yaatandika kumutuntuza, kasi Hagara yaamwi̱ru̱ka. ");
INSERT INTO rub_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Malayika wa Mukama yaagi̱i̱rye Hagara hei̱zu̱ba linyakubba mwirungu, ha muhanda gunyakutwalanga Su̱u̱ru̱. ");
INSERT INTO rub_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Malayika yaamu̱b̯u̱u̱lya naakoba yati, “Hagara muzaana wa Saraayi̱, okuruga hanya kandi okugyenda hanya?” Hagara yei̱ri̱ri̱mwo naakoba yati, “Ndimu kwi̱ru̱ka Saraayi̱ mu̱go wange.” ");
INSERT INTO rub_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Mwomwo malayika wa Mukama yaamuweera naakoba yati, “I̱rayo hali mugole waamu omub̯undalire.” ");
INSERT INTO rub_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Yaab̯u̱ni̱i̱rye yaakoba yati, “Beizukulu baamu ndi̱bakanyi̱sya balibba banene hoi̱, tibalisobora kubabala.” ");
INSERT INTO rub_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Malayika yaakoba yati, “Wone oli na nda, okwi̱za kubyala mwana wa b̯udulu, olimweta I̱si̱mai̱ri̱, hab̯wakubba Mukama aweeni̱ b̯ujune waamu. ");
INSERT INTO rub_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Alibba nka kisolo kya mwirungu ali̱lwani̱syanga b̯uli muntu, kandi b̯uli muntu ali̱mu̱lwani̱syanga, aliicala mu b̯wemi̱ na baluganda lwamwe bensei̱.” ");
INSERT INTO rub_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Nahab̯waki̱kyo, Hagara yeeti̱ri̱ Mukama munyakubaza nayo, “Ruhanga awona.” Kandi yaakoba yati, “Mu mananu mbweni̱ yogwo andinda.” ");
INSERT INTO rub_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Nahab̯waki̱kyo kyokyo i̱zu̱ba baalyeti̱ri̱, “Bbeeri̱-lahayi̱-rohi̱” ki̱ku̱manyi̱sya i̱zu̱ba lya yogwo mwomi ambona. Kandi liicala hakati̱ wa Kadesi̱ na Beredi̱. ");
INSERT INTO rub_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hagara yaabyali̱i̱ri̱ I̱bbu̱ramu̱ mwana wa b̯udulu kandi mwana wa Hagare yaabyeri̱, I̱bbu̱ramu̱ yaamweti̱ri̱ I̱si̱mai̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","I̱bbu̱ramu̱ kubyala hali Hagara mwana, yaali adooseerye myaka kinaanei na mukaaga (86) mya b̯u̱handu̱. ");
INSERT INTO rub_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","I̱bbu̱ramu̱ b̯uyaali adooseerye myaka kyenda na mwenda mya b̯u̱handu̱, Mukama yaamu̱wonekeeri̱ yaakoba yati, “Gyagya Ruhanga Waamaani Gensei̱, okorenge bi̱byo bi̱nkwendya kwokwo obbe wamananu. ");
INSERT INTO rub_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Nsobore kukora ndagaanu hakati̱ waamu nagya, kandi nku̱kanyei̱ hoi̱.” ");
INSERT INTO rub_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Kasi I̱bbu̱ramu̱ yaaku̱nda b̯u̱syo hansi, Ruhanga yaakoba yati, ");
INSERT INTO rub_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Hataati̱ weega ndageeni̱ nawe, olibba bba mahanga ganene. ");
INSERT INTO rub_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Kuruga hataati̱ tibakyakakweta I̱bbu̱ramu̱, bei̱tu̱ baakwetanga I̱bbu̱rahi̱mu̱, hab̯wakubba nku̱foori̱ri̱ bba mahanga ganene. ");
INSERT INTO rub_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ndi̱kanyi̱sya hoi̱ beizukulu baamu, nkutoolemwo mahanga ganene, kandi olibyala bakama. ");
INSERT INTO rub_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Ndilinda ndagaanu gyange gi̱ndageeni̱ nawe, kandi ngilinde na hali beizukulu baamu biro byensei̱, gibbe ndagaanu gya biro na biro, aleke mbe Ruhanga waamu kandi wa beizukulu baamu. ");
INSERT INTO rub_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Gigi nsi gyensei̱ Kanani̱ gyokwicalamwo nka munyamahanga, ndigikuha kandi ndigiha na beizukulu baamu gibbe nsi gyenyu̱ gya biro na biro, kandi nagya nyabbanga Ruhanga waab̯u.” ");
INSERT INTO rub_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Ruhanga yaaweereeri̱ I̱bbu̱rahi̱mu̱ naakoba yati, “Walindanga ndagaanu gyange kandi na beizukulu baamu bagilindenge biro byab̯u byensei̱, ");
INSERT INTO rub_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Gigi gyogyo ndagaanu gyange ginkuragana nawe na beizukulu baamu, gimwadosereeryanga. B̯uli mudulu yensei̱ muli nywe asalwenge. ");
INSERT INTO rub_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Mwasalwanga kapapa ka mibiri myenyu̱, kakwo kooko kalibba kawoneru ka ndagaanu gyange gi̱ndageeni̱ na nywe. ");
INSERT INTO rub_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Mu biro byenyu̱ byensei̱ mwana wa b̯udulu yensei̱ gimwabyalanga, asalwenge kapapa ka mubiri gwamwe amaari̱ ku̱doosya biro munaanei. B̯uli mudulu yensei̱ asalwenge b̯u̱yaabbanga naali wa mu luganda lwenyu̱, rundi gi̱mu̱gu̱u̱ri̱ na sente zeenyu̱ hali munyamahanga atali wa luganda lwenyu̱, yogwo abyali̱i̱rwe mu nnyu̱mba gyenyu̱, ");
INSERT INTO rub_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","banyakubyalirwa mu nnyu̱mba gyamu na bawagu̱u̱ri̱ na sente bali na kusalwa kapapa kaab̯u. Ndagaanu gyange kwokwo yatyo gilibba gya biro na biro ha mibiri myenyu̱. ");
INSERT INTO rub_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Mudulu yensei̱ atasali̱i̱rweho kapapa ka mubiri gwamwe, alitoolwanga mu bantu ba luganda lwamwe, hab̯wakubba abi̱nyi̱ri̱ ndagaanu gyange.” ");
INSERT INTO rub_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Kandi Ruhanga yaaweereeri̱ I̱bbu̱rahi̱mu̱ naakoba yati, “Mu̱kali̱ waamu otali̱i̱ra kumweta Saraayi̱ bei̱tu̱ omwetenge Saara. ");
INSERT INTO rub_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ndimuha mu̱gi̱sa, kandi, kindi alikubyalira mwana wa b̯udulu. Ndimuha mu̱gi̱sa alibba maa mahanga ganene, kandi bakama baliruga muli yo.” ");
INSERT INTO rub_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Hahwo I̱bbu̱rahi̱mu̱ yaaku̱nda b̯u̱syo hansi, yaaseka yankei naakoba yati, “B̯u̱b̯wo, gya mudulu ndooseerye myaka ki̱ku̱mi̱, na Saara mu̱kali̱ wange wa myaka kyenda, twetwe tukubyala mwana?” ");
INSERT INTO rub_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","I̱bbu̱rahi̱mu̱ yaaweereeri̱ Ruhanga naakoba yati, “Ndisemererwa kakubba oha mwana wanga I̱si̱mai̱ri̱ mu̱gi̱sa.” ");
INSERT INTO rub_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ruhanga yaakoba yati, “Kwahi Saara mu̱kali̱ waamu akwi̱za kukubyalira mwana wa b̯udulu, olimweta ibara I̱saka. Ndiragana nayo ndagaanu gya biro na biro, gilikwata na beizukulu baamwe. ");
INSERT INTO rub_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Kandi I̱si̱mai̱ri̱ gyokumbwera, kyokumubazaho nkyegwi̱ri̱, nkumuha mu̱gi̱sa abyale, beizukulu baamwe bakanye, alibba bba balemi̱ i̱ku̱mi̱ na babiri, ndimutolamwo ihanga likooto. ");
INSERT INTO rub_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Kandi ndilinda ndagaanu gyange nʼI̱saka. Saara yogwo alikubyalira mwaka gu̱kwi̱za mu kasu̱mi̱ nka kaka.” ");
INSERT INTO rub_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Ruhanga b̯u̱yaamaari̱ kubaza nʼI̱bbu̱rahi̱mu̱, yaamurugaho yaagyenda. ");
INSERT INTO rub_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","I̱bbu̱rahi̱mu̱ yaatweri̱ I̱si̱mai̱ri̱ mu̱tabani̱ waamwe na bensei̱ banyakubyalwa mu makaa gaamwe, nabayaagu̱u̱ri̱ na sente zaamwe yaabasala kapapa ka mibiri myab̯u kiro kyonyi̱ni̱, nka Ruhanga ku̱yamu̱weereeri̱. ");
INSERT INTO rub_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","I̱bbu̱rahi̱mu̱ kusalwa kapapa ka mubiri gwamwe, yaali adooseerye myaka kyenda na mwenda mya b̯u̱handu̱. ");
INSERT INTO rub_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Kandi mu̱tabani̱ waamwe I̱si̱mai̱ri̱ kusalwa kapapa ka mubiri gwamwe yaali adooseerye myaka i̱ku̱mi̱ na misatu. ");
INSERT INTO rub_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Kiro ki̱kyo kyonyi̱ni̱, I̱bbu̱rahi̱mu̱ na mu̱tabani̱ I̱si̱mai̱ri̱ mwomwo baasali̱i̱rwe. ");
INSERT INTO rub_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Badulu bensei̱ ba mu makaa gaamwe banyakubyalwa mu luganda lwamwe na bab̯wo baanyaakugulwab̯ugulwa na sente hali munyamahanga yensei̱, bensei̱ baabasaari kapapa ka mibiri myab̯u hamwei̱ nayo. ");
INSERT INTO rub_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Mukama yeezolokeerye hali I̱bbu̱rahi̱mu̱ naali heehi̱ na misaali mi̱si̱sye mya Mamu̱le, b̯uyaali ei̱cali̱i̱ri̱ heehi̱ na mulyangu gwa heema gyamwe mwihangwe. ");
INSERT INTO rub_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","I̱bbu̱rahi̱mu̱ yaabyokeerye mei̱so yaawona badulu basatu, bamwemereeri̱ mu mei̱so. Yaaru̱gi̱ri̱ ha mulyangu gwa heema na mbiro yaagyenda kubatangiira, yaaku̱nda b̯u̱syo hansi, ");
INSERT INTO rub_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","yaabaza naakoba yati, “Mukama wange nka kwoi̱zi̱ri̱ hali gya muheereza waamu, b̯uwakabba nookunkwatirwa mbabazi̱, otandabaho otadoori̱ kwamwange. ");
INSERT INTO rub_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Leka baaleete meezi̱ munaabe magulu, mubanze muhumuleho ha mu̱tu̱ntu̱u̱lu̱ gwa musaali gugu, ");
INSERT INTO rub_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","gya kandeete kyakudya, mudye mutunge maani, b̯umwakamala kudya kasi mugyende lugyendu lwenyu̱.” Badulu bab̯wo bei̱ri̱ri̱mwo nibakoba yati, “Kora nka kwokobi̱ri̱.” ");
INSERT INTO rub_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","I̱bbu̱rahi̱mu̱ yaagyendi̱ri̱ yeingira mu heema gyamwe yaaweera Saara naakoba yati, “Pi̱ma b̯wangu debe isatu za b̯u̱kooro b̯urungi, ob̯ukande oti̱mbe migaati.” ");
INSERT INTO rub_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","I̱bbu̱rahi̱mu̱ yei̱ru̱ki̱ri̱ yaagyenda mwigana, yaatoolayo nyana girungi gi̱heheeru̱ yaagiha muheereza, muheereza yaagisala b̯wangu. ");
INSERT INTO rub_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Yaakwata maku̱ta, mate na nnyama bibaali bategeki̱ri̱ yaabasegeerya. B̯ubaalingi nibakudya I̱bbu̱rahi̱mu̱ yei̱ceeri̱ heehi̱ nabo ha musaali. ");
INSERT INTO rub_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Baamu̱b̯u̱u̱lya nibakoba yati, “Saara mu̱kali̱ waamu ali hanya?” I̱bbu̱rahi̱mu̱ yei̱ri̱ri̱mwo naakoba yati, “Ali mu heema.” ");
INSERT INTO rub_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Mukama yaakoba yati, “Ndi̱i̱ra haha ha b̯wi̱re nka b̯ub̯u, mu̱kali̱ waamu Saara alibba akubyali̱i̱ri̱ mwana wa b̯udulu.” Mu b̯wi̱re b̯u̱b̯wo, Saara yaali naakwetegeerya yeemereeri̱ i̱nyu̱ma lyʼI̱bbu̱rahi̱mu̱ heehi̱ na mulyangu gwa heema. ");
INSERT INTO rub_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Mu kasu̱mi̱ kakwo, I̱bbu̱rahi̱mu̱ na Saara baali bagu̱lu̱u̱si̱ri̱, b̯u̱b̯wo Saara yaali aleki̱ri̱ kugyenda mu nsonga za bakali̱. ");
INSERT INTO rub_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Saara yaaseki̱ri̱ naakoba yati, “Hataati̱ nka ku̱ngu̱lu̱u̱si̱ri̱ na mukama wange agu̱lu̱u̱si̱ri̱, ntakegonzambe?” ");
INSERT INTO rub_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Mukama yaab̯u̱u̱li̱i̱rye I̱bbu̱rahi̱mu̱ naakoba yati, “Saara akuseka ki, akadwa ha kukoba nti, ‘Mwana ndibba nimubyala mu b̯u̱gu̱lu̱u̱su̱?’ ");
INSERT INTO rub_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Haloho kilema Mukama? Mu kasu̱mi̱ kangu̱mi̱i̱rye ha b̯wi̱re nka b̯ub̯u, mwaka gu̱kwi̱za ndi̱i̱ra haha, kandi b̯u̱b̯wo Saara alibba abyeri̱ mwana wa b̯udulu.” ");
INSERT INTO rub_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Bei̱tu̱ Saara yaageene naakoba yati, “Ti̱nseki̱ri̱.” Hab̯wakubba yaali naaku̱ti̱i̱na Mukama kyokyo kyamu̱bazi̱si̱i̱rye yati. Mukama yaakoba yati, “Kwahi oseki̱ri̱.” ");
INSERT INTO rub_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Mwomwo badulu babyokeerye, baagyenda. Baabyokya mei̱so baawona kwansi b̯wa Sodomu̱, I̱bbu̱rahi̱mu̱ yaagyenda nabo kuboolokya muhanda. ");
INSERT INTO rub_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Mukama yaakoba yati, “Ncale mbi̱si̱ri̱i̱ri̱ I̱bbu̱rahi̱mu̱ ki̱nkwendya kukora, ");
INSERT INTO rub_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","kandi naali yooyo alifooka ihanga likooto lya b̯u̱sobozi̱, kandi mahanga gensei̱ galitunga mu̱gi̱sa kuraba mu yo? ");
INSERT INTO rub_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Kubba nyamu̱komi̱ri̱ aragire baana baamwe na beizukulu baamwe kulibatiranga mu muhanda gwa Mukama beicalenge nibakora birungi kandi byab̯winganiza, aleke Mukama adoosereerye ki̱iyaaragani̱si̱i̱rye I̱bbu̱rahi̱mu̱.” ");
INSERT INTO rub_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Kasi Mukama yaaweera I̱bbu̱rahi̱mu̱ naakoba yati, “Nyegwi̱ri̱ kujumiira kwa Sodomu̱ na Gomora kuli kunene hab̯wa bibii byab̯u binene bi̱bakoori̱. ");
INSERT INTO rub_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Kangyende mbone b̯ubaakabba bakoori̱ bi̱leti̱ri̱ho kujumiira ku̱nyeegwi̱ri̱, b̯ubaakabba batabi̱koori̱ nab̯wo nkwi̱za kukyega.” ");
INSERT INTO rub_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Kasi badulu baaruga mu makaa, baakwata gwa b̯u̱ki̱i̱zi̱ b̯wa Sodomu̱, bei̱tu̱ I̱bbu̱rahi̱mu̱ yei̱ceeri̱ yeemereeri̱ mu mei̱so ga Mukama. ");
INSERT INTO rub_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","I̱bbu̱rahi̱mu̱ yei̱su̱ma hali Mukama yaakoba yati, “Mu mananu, barungi wabahwerekereerya hamwei̱ na babiibi? ");
INSERT INTO rub_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Kakubba mu rub̯uga habbamwo barungi maku̱mi̱ gataanu nab̯wo rub̯uga okwi̱za ku̱lu̱zi̱kya? ");
INSERT INTO rub_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ki̱kyo kya kwi̱ta barungi na babiibi aleke barungi beijanjane na babiibi, kitabba yatyo! Mu̱cwi̱ wa misangu wa mu nsi gyensei̱ ti̱yakwendeerye kukukora b̯winganiza?” ");
INSERT INTO rub_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Mukama yaakoba yati, “B̯u̱ndyagya mu Sodomu̱ barungi maku̱mi̱ gataanu nibali mu rub̯uga, kicweka kyensei̱ ndikiganyira hab̯wab̯u.” ");
INSERT INTO rub_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","I̱bbu̱rahi̱mu̱ yei̱ri̱ri̱mwo naakoba yati, “Nyeheeri̱yo kubaza na Mukama gya ndi cuucu kandi i̱syanu̱. ");
INSERT INTO rub_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Kandi barungi b̯ubaabba nibali nka maku̱mi̱ ganei na bataanu? Rub̯uga oli̱lu̱zi̱kya hab̯wakulemwaho bataanu?” Mukama yei̱ramwo naakoba yati, “Ti̱ndi̱lu̱zi̱kya b̯undyagyayo maku̱mi̱ ganei na bataanu.” ");
INSERT INTO rub_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","I̱bbu̱rahi̱mu̱ yaab̯u̱ni̱i̱rye yaab̯u̱u̱lya Mukama naakoba yati, “Kandi kakubba habbamwo maku̱mi̱ ganei?” Mukama yei̱ri̱ri̱mwo naakoba yati, “Hab̯wa maku̱mi̱ ganei gagwo, rub̯uga ti̱ndu̱lu̱hwerekereerya.” ");
INSERT INTO rub_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","I̱bbu̱rahi̱mu̱ yaakoba yati, “Mukama otambihiriirwa, nzikiriza mbaze. Kandi Kakubba habbayo maku̱mi̱ gasatu?” Mukama yaakoba yati, “Ti̱ndu̱lu̱hwerekereerya b̯undyagyamwo maku̱mi̱ gasatu.” ");
INSERT INTO rub_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","I̱bbu̱rahi̱mu̱ yaakoba yati, “Ncwi̱ri̱mwo kubaza na Mukama, Kakubba waagyayo maku̱mi̱ gabiri?” Mukama yei̱ri̱ri̱mwo yati, “Hab̯wa maku̱mi̱ gabiri, rub̯uga ti̱ndu̱lu̱hwerekereerya.” ");
INSERT INTO rub_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Kasi I̱bbu̱rahi̱mu̱ yaakoba yati, “Mukama otambihirwa, kambaze murundi gu̱mwei̱ gusa, kakubba waagyayo barungi i̱ku̱mi̱ basa?” Mukama yei̱ri̱ri̱mwo yati, “Hab̯wei̱ku̱mi̱ bab̯wo rub̯uga ti̱ndu̱lu̱hwerekereerya.” ");
INSERT INTO rub_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Mukama b̯u̱yaamaari̱ kubaza nʼI̱bbu̱rahi̱mu̱, yaagyenda kandi nʼI̱bbu̱rahi̱mu̱ yeemuka kwamwab̯u. ");
INSERT INTO rub_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Bamalayika babiri baadoori̱ joojolo mu Sodomu̱, Looti̱ yaali ei̱cali̱i̱ri̱ heirembu lya rub̯uga. B̯u̱yaabaweeni̱, yaabyoki̱ri̱ yaagyenda kubatangiira yaaku̱nda b̯u̱syo hansi, ");
INSERT INTO rub_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","yaakoba yati, “Bakama bange, mwi̱ze mu nnyu̱mba gya muheereza weenyu̱ munaabe magulu mulaale. Mwakya mwakeera nimugyenda lugyenda lwenyu̱.” Bamalayika baamwi̱ri̱mwo nibakoba yati, “Kwahi tukulaala mu rub̯uga hakati̱.” ");
INSERT INTO rub_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Bei̱tu̱ yo yaabesengereerye hoi̱, kasi bahunguuka kwamwamwe bengi̱i̱ri̱ mu nnyu̱mba gyamwe, yaabakolera B̯u̱genyi̱ kandi yaati̱mba migaati mitalimwo b̯u̱mya baadya. ");
INSERT INTO rub_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Bei̱tu̱ b̯ubaalingi batakaleeri̱, bantu bamu rub̯uga lu̱lwo, badulu, bahandu̱ na bato, bantu bensei̱ kudwera ki̱mwei̱ ku mudulu akusembayo, baagoti̱ri̱ nnyu̱mba. ");
INSERT INTO rub_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Beeta Looti̱, baamu̱b̯u̱u̱lya nibakoba yati, “Badulu bei̱zi̱ri̱ haha b̯wi̱re b̯wa joojolo bali hanya? Bahu̱lu̱kye obatuletere tulaale nabo.” ");
INSERT INTO rub_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Looti̱ yaahuluka yaakinga mulyangu, yaagyenda cali baalingi, ");
INSERT INTO rub_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","yaakoba yati, “Baana beetu̱ nku̱besengereerya mutakora kintu kyensei̱ kibiibi. ");
INSERT INTO rub_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Mu̱kyegi̱ri̱ nka kundi na bahara bange babiri batakendyanga badulu, kambahu̱lu̱kye mbabaleetere, mubakore kyensei̱ ki̱mu̱kwendya kisa badulu baba mutabakora kintu kyensei̱, hab̯wakubba bagenyi̱ bange.” ");
INSERT INTO rub_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Bo baakoba yati, “Rugaho ku̱di̱!” Bei̱ri̱ri̱ baakoba yati, “Muntu yogo yei̱zi̱ri̱ haha naali munyamahanga, hataati̱ akwendya kwefoora mu̱cwi̱ wa misangu! Hataati̱ tukugyenda kukukora kubiibi kukira nka kutwakali nitubakora.” Hahwo baasi̱ndi̱ki̱ri̱ ku̱di̱ na maani Looti̱, kadooli̱ babi̱nye mulyangu. ");
INSERT INTO rub_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Bei̱tu̱ badulu banyakubba mu nnyu̱mba baahu̱lu̱ki̱i̱rye mikono baasika Looti̱ baamwi̱ngi̱i̱rya mu nnyu̱mba bakinga mulyangu. ");
INSERT INTO rub_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Bamalayika bei̱jeeri̱ mei̱so ga badulu na basigazi banyakubba ha mulyangu, bei̱ceeri̱ ni̱bapu̱mpu̱u̱ta ha mulyangu mpaka b̯u̱bajwahi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Mwomwo bamalayika baab̯u̱u̱lya Looti̱ nibakoba yati, “Mu kiki kiikaru olinamwo bantu baamu bandi: bageni̱, batabani̱ baamu, bahara baamu rundi muntu waamu yensei̱ ali mu rub̯uga? Batoole mu kiki kiikaru, ");
INSERT INTO rub_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","hab̯wakubba kujumiira kuli ha kiki kiikaru kuli kunene mu mei̱so ga Mukama kandi Mukama atu̱tu̱mi̱ri̱ ku̱ki̱hwerekereerya.” ");
INSERT INTO rub_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Nahab̯waki̱kyo, Looti̱ yaabyoki̱ri̱ yaagyenda hali bageni̱ baamwe banyakubba berangi̱i̱ri̱ bahara baamwe yaabaweera naakoba yati, “Mu̱byoke, mu̱ru̱ge mu kiki kiikaru, hab̯wakubba Mukama ali heehi̱ ku̱zi̱kya rub̯uga lulu.” Bei̱tu̱ bageni̱ baamwe baatekerezengi̱ akusandaara. ");
INSERT INTO rub_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","B̯wi̱re b̯ub̯wali heehi̱ kukya, bamalayika baaweereeri̱ Looti̱ nibakoba yati, “Byoka otwale mu̱kali̱ waamu na bahara baamu babiri bali haha, mutahwerekeera mu rub̯uga lulu b̯ulwakabba nilukufubirwa.” ");
INSERT INTO rub_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Looti̱ yaalikwesitasita, kasi bab̯wo bamalayika baamukwata ha mukono, baakwata na mukono gwa mu̱kali̱ waamwe, na mya bahara baamwe babiri. Hab̯wakubba Mukama yaali na mbabazi̱ nabo, bamalayika baatoori̱ Looti̱ na bantu baamwe mu nnyu̱mba, baabahu̱lu̱kya mu rub̯uga. ");
INSERT INTO rub_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","B̯u̱baamaari̱ ku̱bahu̱lu̱kya, babaweera nibakoba yati, “Mwi̱ru̱ke, mu̱takwa. Mutawona i̱nyu̱ma, kandi mutemeera mu kyeya. Mwi̱ru̱ke mwebi̱se mu nsahu mutahwerekeera.” ");
INSERT INTO rub_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Looti̱ yaakoba yati, “Kwahi mukama wange, ");
INSERT INTO rub_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","muheereza waamu mbweni̱ kwongonzi̱ri̱, wankwatirwa mbabazi̱ zinene ku̱honi̱a b̯womi b̯wange, bei̱tu̱ tinsobora kwi̱ru̱ka nkadwa ha nsahu zi̱di̱ kabii katakandoori̱ho nkakwa. ");
INSERT INTO rub_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Wona, rub̯uga lwa ntadiiko, luli heehi̱ kandi lu̱dooli̱. Leka hooho nyi̱ru̱ki̱re aleke mpone.” ");
INSERT INTO rub_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Malayika yaamuweera naakoba yati, “Kiki kyosabi̱ri̱ nkyegwi̱ri̱ na rub̯uga lwobazi̱ri̱ho ti̱ndu̱lu̱hwerekereerya. ");
INSERT INTO rub_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Wanguha b̯wangu oi̱ru̱ke, ti̱nkwi̱za kukora kintu kyensei̱ otakadoori̱yo.” (Kyokyo rub̯uga lu̱lwo baalweti̱ri̱ Zowali̱, makuru gaakyo nti, “kiikaru ki̱dooli̱.”) ");
INSERT INTO rub_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Looti̱ kudwa Zowali̱ lyoba lyali li̱hu̱lu̱ki̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","KasiMukama yaasi̱ndi̱ka na mwiguru b̯uganga b̯wa mworo gukwaka nka ndagali̱ hali mbuga za Sodomu̱ na Gomora. ");
INSERT INTO rub_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Yaahwerekereerya mbuga zi̱zo na kyeya kyensei̱, bantu banyakwicalanga mu mbuga zi̱zo, na b̯uli kintu kyensei̱ kinyakubba ki̱meeri̱ heitehe. ");
INSERT INTO rub_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Bei̱tu̱ mukaa Looti̱ yaali naakumuhondeeranga, yaamagi̱ri̱ i̱nyu̱ma, yaafooka nkondo gya mu̱kwa. ");
INSERT INTO rub_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","I̱bbu̱rahi̱mu̱ yaabyoki̱ri̱ mwakya karei, yaagyenda yaadwa ha kiikaru ki̱kyo kiyaali arombeeri̱ho na Mukama, ");
INSERT INTO rub_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","yaabyokya mei̱so yaalingiira Sodomu̱ na Gomora na nsi gyensei̱ gya kyeya, yaawona mwi̱ca mu nsi gi̱gyo ni̱gu̱ku̱tu̱u̱ka nka mwi̱ca gwa kikoomi. ");
INSERT INTO rub_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Bi̱byo byobyo byabbeeri̱ho Ruhanga b̯u̱yaahwerekereerye mbuga za mu kyeya, yei̱zu̱ki̱ri̱ ki̱yaaragani̱si̱i̱rye I̱bbu̱rahi̱mu̱, yaatoola Looti̱ mu kabii ka kuhwerekeera, b̯u̱yaahwerekereerye mbuga Looti̱ zi̱i̱yei̱calengi̱mwo. ");
INSERT INTO rub_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Looti̱ yaaru̱gi̱ri̱ Zohara yeicala mu nsi gya nsahu hamwei̱ na bahara baamwe babiri hab̯wakubba yaati̱i̱nengi̱ kwicala Zowali̱. Nahab̯waki̱kyo yei̱calengi̱ mu b̯wingira na bahara baamwe babiri. ");
INSERT INTO rub_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Muhara waamwe mu̱zegei̱zo yaaweereeri̱ nyakaab̯u muto naakoba yati, “Bbaaweetu̱ agu̱lu̱u̱si̱ri̱, kandi tihaloho mudulu mu nsi gigi akwi̱za kutuswera nka bantu bensei̱ kubakora. ");
INSERT INTO rub_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Hati̱, tu̱he Bbaaweetu̱ maaci anywe atamiire, tulaale nayo, aleke tubyale baana beetu̱ kurugira hali bbaaweetu̱.” ");
INSERT INTO rub_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Nahab̯waki̱kyo kiro ki̱kyo baatami̱i̱rya bbaawaab̯u, muhara mu̱zegei̱zo yaagyenda yaalaala nayo, Looti̱ atekeege muhara waamwe haayaaleeri̱ rundi ha yaabyokeeri̱. ");
INSERT INTO rub_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Kiro kinyakuhonderaho muhara mu̱handu̱ yaaweereeri̱ nyaakaab̯u muto naakoba yati, “I̱jolo nyaaleeri̱ na bbaaweetu̱ kyadeeru twongere tu̱mu̱tami̱i̱rye, nawe ogyende olaale nayo aleke tulinde lubyalu lwetu̱ nitulutolira hali bbaaweetu̱.” ");
INSERT INTO rub_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Nahab̯waki̱kyo, i̱jolo li̱lyo baataami̱i̱rye bbaawaab̯u muhara muto yaagyenda yaalaala nayo, bbaawaab̯u atakeege muhara waamwe haayaaleeri̱ rundi ha yaabyokeeri̱. ");
INSERT INTO rub_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Bahara ba Looti̱ kwokwo beemeti̱ri̱ nibaatwekwa bbaawaab̯u. ");
INSERT INTO rub_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Muhara mu̱zegei̱zo yaabyeri̱ mwana wa b̯udulu, yaamweta Mowaabbu. Yooyo bba Bamowaabbu na hataati̱. ");
INSERT INTO rub_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Muhara muto nayo yaabyala mwana wa b̯udulu, yaamweta ibara Benami̱. Yooyo bba Bamooni̱ na hataati̱. ");
INSERT INTO rub_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","I̱bbu̱rahi̱mu̱ b̯u̱yaaru̱gi̱ri̱ ku̱kwo, yaakwata muhanda gukugyenda mu nsi gya Negeb̯u̱ yeicala hakati̱ wa Kadesi̱ na Su̱u̱ru̱ kandi yeicala mu Geraali̱ hab̯wa kasu̱mi̱ kadooli̱. ");
INSERT INTO rub_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","I̱bbu̱rahi̱mu̱ yaaweereeri̱ bantu nti, mu̱kali̱ waamwe Saara, ali nyaakaab̯u. Nahab̯waki̱kyo, Abbi̱mereki̱ mukama wa Geraali̱ yaatu̱mi̱ri̱ baamutwalire Saara. ");
INSERT INTO rub_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Bei̱tu̱ i̱jolo, Ruhanga yei̱zi̱i̱ri̱ Abbi̱mereki̱ mu kilooto, yaamuweera naakoba yati, “Weegi̱ri̱ nka kwoli mu̱ku̱u̱, mu̱kali̱ gyotweri̱ okugyenda ku̱mu̱gwaho, hab̯wakubba mukaa mudulu.” ");
INSERT INTO rub_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abbi̱mereki̱ yaali atakesu̱mi̱i̱ranga Saara. Nahab̯waki̱kyo, yaabazi̱ri̱ naakoba yati, “Mukama okwi̱za kwi̱ta ihanga litali na musangu? ");
INSERT INTO rub_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","I̱bbu̱rahi̱mu̱ yooyo yambwereeri̱ nti, ‘Mu̱kali̱ yogo ali nyakeetu̱.’ Kandi na mu̱kali̱ yankei yambwereeri̱ naakoba nti, ‘Ali weetu̱.’ Kiki nyaaki̱koori̱ nyetegeri̱i̱ze ki̱mwei̱ kandi ntali na kabii kankwendya kukora mudulu yogwo.” ");
INSERT INTO rub_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Hei̱nyu̱ma Ruhanga yaaweereeri̱ Abbi̱mereki̱ na mu kilooto naakoba yati, “Nkyegeeri̱ ki̱mwei̱ nka kuwaali mu̱nanu̱ku̱ toli na nsobi̱. Nahab̯waki̱kyo, nyaaku̱geeni̱ kukora kibii, kyokyo ntakwi̱ki̱ri̱i̱ze kumukwataho. ");
INSERT INTO rub_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Hataati̱ nu mu̱kali̱ mu̱ku̱bi̱i̱rye mudulu waamwe, hab̯wakubba ali mu̱ragu̱ri̱ wa Ruhanga kandi akwi̱za kukusabira womeere. Bei̱tu̱ Kakubba otamwi̱ri̱ri̱i̱rya mu̱kali̱ waamwe, weege nka kwokwi̱za ku̱kwa na bantu baamu bensei̱.” ");
INSERT INTO rub_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Abbi̱mereki̱ yaabyoki̱ri̱ mwakya karei, yeeta baheereza baamwe bensei̱, yaabasoboora bintu byensei̱. Badulu baba b̯u̱ti̱i̱ni̱ b̯wabakweti̱ hoi̱ ");
INSERT INTO rub_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Kasi Abbi̱mereki̱ yeeta I̱bbu̱rahi̱mu̱ yaamu̱b̯u̱u̱lya naakoba yati, “Kyani ki̱waatu̱koori̱? Nyaaku̱sobeereerye kyani ki̱kyo kinyakukuha kundeetera kibii kikwijana hahwo hamwei̱ na b̯ukama b̯wange? Onkoori̱ bintu bi̱tasemereeri̱ kunkora.” ");
INSERT INTO rub_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abbi̱mereki̱ yaab̯u̱u̱lya I̱bbu̱rahi̱mu̱ naakoba yati, “Waagyendereeri̱ kyani kukora kintu nka ki̱kyo?” ");
INSERT INTO rub_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","I̱bbu̱rahi̱mu̱ yei̱ri̱ri̱mwo naakoba yati, “Ki̱nyaaku̱nkoserya ki̱kyo nyaateekerezengi̱ nti, ‘Bantu bamu kiikaru kiki ti̱bati̱i̱na Ruhanga na kadooli̱ kandi nti bakwi̱za ku̱nzi̱ta ni̱banzi̱ndi̱ra mu̱kali̱ wange.’ ");
INSERT INTO rub_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Kwongera ha ki̱kyo mu̱kali̱ yogwo ali nyaakeetu̱ kwo, tubyalwa bbaaweetu̱ omwei̱, twahukanwa bamaaweetu̱, yooyo gi̱nyaatu̱ngi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Kandi Ruhanga b̯u̱yandagi̱i̱ri̱ kuruga mu makaa ga bbaabba, nyawereeri̱ mu̱kali̱ yogwo ninkoba yati, ‘Kiki kyokyo kikorwa kya mbabazi̱ kyosemereeri̱ kunkoora: hensei̱ ha twakadwanga okobenge yati, “Mudulu yogwo weetu̱.” ’ ” ");
INSERT INTO rub_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Hei̱nyu̱ma Abbi̱mereki̱ yaakweti̱ ntaama, nte, baheereza na bazaana yaabiha I̱bbu̱rahi̱mu̱ kandi yaamwi̱ri̱ri̱i̱rya mu̱kali̱ waamwe Saara. ");
INSERT INTO rub_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abbi̱mereki̱ yaakoba yati, “Wona itehe lyange, ndi̱lyo, gyenda oicale cali hookwendya.” ");
INSERT INTO rub_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Yaaweera na Saara naakoba yati, “Weenyu̱ mu̱heeri̱ bicweka bya feeza ru̱ku̱mi̱, ku̱kwo kwokwo kukutoolaho kihemu mu mei̱so ga bantu bensei̱ boicala nabo kandi b̯u̱kei̱so mu mei̱so ga bensei̱ nka kwotali na kabii.” ");
INSERT INTO rub_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Kasi I̱bbu̱rahi̱mu̱ yaasaba Ruhanga, Ruhanga yajumuura Abbi̱mereki̱ kandi yajumuura na mu̱kali̱ waamwe na bazaana baamwe, aleke babyale baana. ");
INSERT INTO rub_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Hab̯wakubba nnyu̱mba gya Abbi̱mereki̱ gyensei̱ Mukama yaali agi̱i̱mi̱ri̱ lubyalu hab̯wa Saara mukaa I̱bbu̱rahi̱mu̱. ");
INSERT INTO rub_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Mukama yaaheeri̱ Saara mu̱gi̱sa nka kuyaali yeeragi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Saara yeemeti̱ri̱ yaabyalira I̱bbu̱rahi̱mu̱ mwana wa b̯udulu. I̱bbu̱rahi̱mu̱ yaali agu̱lu̱u̱si̱ri̱. Kiki kyabbeeri̱ho mu kasu̱mi̱ ka Ruhanga yaabazi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","I̱bbu̱rahi̱mu̱ yeeti̱ri̱ mwana wa Saara gi̱yamu̱byali̱i̱ri̱ I̱saka. ");
INSERT INTO rub_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","I̱saka b̯u̱yaadooseerye biro munaanei, bbaawe I̱bbu̱rahi̱mu̱ yaamusala kapapa nka Ruhanga kuyaali amu̱ragi̱i̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","I̱bbu̱rahi̱mu̱ yaali adooseerye myaka ki̱ku̱mi̱, I̱saka hayaabyali̱i̱rwe. ");
INSERT INTO rub_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Saara yaakoba yati, “Ruhanga andeeteeri̱ nseku. Muntu yensei̱ yaakeegwa nti mbyeri̱ mwana akwi̱za kuseka.” ");
INSERT INTO rub_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Kandi yei̱ra yaakoba yati, “Atali Ruhanga naani wondi yaaku̱weereeri̱ I̱bbu̱rahi̱mu̱ Saara alyonkya baana? Bei̱tu̱ nyamubyalira mwana wa b̯udulu naali agu̱lu̱u̱si̱ri̱.” ");
INSERT INTO rub_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Mwana yaahandi̱ri̱ yaacuuka. Kandi I̱bbu̱rahi̱mu̱ yaakoori̱ B̯u̱genyi̱ b̯ukooto ha ki̱kyo kiro. ");
INSERT INTO rub_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Bei̱tu̱ Saara b̯u̱yaaweeni̱ mwana wa Hagara Mu̱nyami̱si̱ri̱ gi̱yaali abyali̱i̱ri̱ I̱bbu̱rahi̱mu̱, naaku̱jooga mwana waamwe I̱saka, ");
INSERT INTO rub_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Saara yaaweera I̱bbu̱rahi̱mu̱ naakoba yati, “Binga muzaana yogo aruge haha na mwana waamwe hab̯wakubba mwana wa muzaana taligwetwa hamwei̱ na mwana wange I̱saka.” ");
INSERT INTO rub_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ki̱kyo kyabi̱hi̱i̱ze I̱bbu̱rahi̱mu̱ hab̯wa kumuragira kubinga mwana waamwe. ");
INSERT INTO rub_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Bei̱tu̱ Ruhanga yaaweereeri̱ I̱bbu̱rahi̱mu̱ naakoba yati, “Ki̱kyo kitakubihiiza kubinga mwana waamu na mu̱kali̱ waamu muzaana. Kyensei̱ Saara kiyaakakuragira okikore nka kwaku̱ragi̱i̱ri̱ hab̯wakubba I̱saka yooyo alikubyalira beizukulu banyaaku̱ragani̱si̱i̱rye. ");
INSERT INTO rub_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Kandi mwana wa muzaana nayo ndimutolamwo ihanga hab̯wakubba waamu̱byeri̱.” ");
INSERT INTO rub_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","I̱bbu̱rahi̱mu̱ yaabyoki̱ri̱ mwakya karei, yaatwala mugaati na kisahu kya meezi̱, yaakiha Hagara yaaki̱mu̱tweka. Yaamuweera agyende na mwana waamwe. Hagara yaagyendi̱ri̱ yeicala naazengeera mwirungu lya Bbeeri̱-sebba. ");
INSERT INTO rub_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Meezi̱ gayaali nago mu kisahu b̯u̱gaamali̱ki̱ri̱, yei̱ci̱ya mwana hansi ha kisaka. ");
INSERT INTO rub_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Kasi yaagyenda hadeiho yeicaara mwanya gwa mita ki̱ku̱mi̱ yaakoba yati, “Ti̱nkwendya kuwona mwana wange naalimwo ku̱kwa.” Hagara yei̱caali̱i̱ri̱ yaatandika kulira. ");
INSERT INTO rub_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Ruhanga yeegwi̱ri̱ mwana naakulira, malayika wa Ruhanga yeeta Hagara na mwiguru yaamuweera naakoba yati, “Kyani kotu̱ntwi̱ri̱? Leka ku̱ti̱i̱na, Ruhanga yeegwi̱ri̱ kulira kwa mwana waamu cali ali. ");
INSERT INTO rub_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Byoka osenge mwana waamu omukwate omu̱tati̱i̱rye, hab̯wakubba ndimutolamwo ihanga likooto.” ");
INSERT INTO rub_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Kasi Ruhanga yeijula mei̱so ga Hagara yaawona i̱zu̱ba lya meezi̱, yaagyenda yaataha meezi̱ yei̱zu̱u̱lya kisahu kyamwe, yaaha mwana waamwe yaanywa. ");
INSERT INTO rub_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Ruhanga yaali̱ndi̱ri̱ mwana yogwo, yaahanda. Mwana yei̱ceeri̱ mwirungu yeega hoi̱ kulasa b̯uta. ");
INSERT INTO rub_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Yei̱calengi̱ mwirungu lya Parani̱. Mmaawe yaamutungira mu̱kali̱ Mu̱nyami̱si̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Mu kasu̱mi̱ kakwo Abbi̱mereki̱ na Fi̱koli̱ mu̱handu̱ wei̱he lyamwe baaweereeri̱ I̱bbu̱rahi̱mu̱ nibakoba yati, “Ruhanga eicale nawe mu byensei̱ byokora. ");
INSERT INTO rub_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Hataati̱ nu, rahira mu mei̱so ga Ruhanga nka kwotalinkora kubiibi, nka kwotalikora kubiibi beizukulu bange, gya nka ku̱nku̱gi̱ri̱i̱ri̱ mbabazi̱ nawe kwokwo olinkoora kandi kwokwo olikoora gigi nsi gyokwicalamwo.” ");
INSERT INTO rub_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","I̱bbu̱rahi̱mu̱ yaakoba yati, “Ndahi̱i̱ri̱.” ");
INSERT INTO rub_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","I̱bbu̱rahi̱mu̱ b̯u̱yeeŋu̱ru̱ŋu̱u̱ti̱i̱rye hab̯wei̱zu̱ba lya meezi̱ lya baheereza ba Abbi̱mereki̱ libaalingi banyagi̱ri̱, ");
INSERT INTO rub_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abbi̱mereki̱ yaakoba yati, “Ti̱nyeegi̱ri̱ munyakukora ki̱kyo atambwereeri̱, ki̱kyo tinkakyegwanga, mwomwo gwakubanza ku̱kyegwa.” ");
INSERT INTO rub_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","I̱bbu̱rahi̱mu̱ yaakwata ntaama na nnumi yabiha Abbi̱mereki̱, bantu bab̯wo babiri baakora ndagaanu. ");
INSERT INTO rub_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","I̱bbu̱rahi̱mu̱ yaahu̱kani̱i̱ryemwo mwigana lyamwe ruusi musanju za ntaama. ");
INSERT INTO rub_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abbi̱mereki̱ yaab̯u̱u̱lya I̱bbu̱rahi̱mu̱ naakoba yati, “B̯uguma za ntaama musanju zosooroozi̱ri̱ zi̱ku̱manyi̱sya kyani?” ");
INSERT INTO rub_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","I̱bbu̱rahi̱mu̱ yei̱ri̱ri̱mwo naakoba yati, “B̯uguma za ntaama zizi musanju zitwale noozitoolera mu ngalu zange aleke obbe kei̱so aku̱gu̱mya nka kundi gyagya munyakulima i̱zu̱ba lili.” ");
INSERT INTO rub_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Kicweka ki̱kyo kyokyo baakyeti̱ri̱ Bbeeri̱-sebba hab̯wakubba haha hooho babiri baarahi̱ri̱i̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Kwokwo baakoori̱ yati ndagaanu nibali Bbeeri̱-sebba. Hei̱nyu̱ma, Abbi̱mereki̱ na Fi̱koli̱ mu̱handu̱ wei̱he lyamwe, baasetu̱ki̱ri̱ beemuka mu nsi gya Bafi̱ri̱si̱i̱ti̱. ");
INSERT INTO rub_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","I̱bbu̱rahi̱mu̱ yaasi̱mbi̱ri̱ musaali mu̱nonde mu nsi gya Bbeeri̱-sebba kandi yaaramya Mukama Ruhanga wa biro byensei̱. ");
INSERT INTO rub_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","I̱bbu̱rahi̱mu̱ yaamaari̱ biro binene mu nsi gya Bafi̱ri̱si̱i̱ti̱. ");
INSERT INTO rub_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Bi̱byo b̯u̱byamali̱ki̱ri̱, Ruhanga yaapi̱mi̱ri̱ I̱bbu̱rahi̱mu̱ yaamweta naakoba yati, “I̱bbu̱rahi̱mu̱.” I̱bbu̱rahi̱mu̱, yeetab̯uka yati, “Ndi haha.” ");
INSERT INTO rub_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ruhanga yaamuweera naakoba yati, “Twala I̱saka mu̱tabani̱ waamu musa, mu̱tabani̱ waamu gi̱wendya, ogyende mu nsi Mori̱ya omumpongire, nka kihongwa kyokye ha lusahu lunyakuweera.” ");
INSERT INTO rub_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","I̱bbu̱rahi̱mu̱ yaabyoki̱ri̱ mwakya karei, yaani̱i̱na ndogoyi̱, yaatwalegeeni̱ badulu babiri na mu̱tabani̱ waamwe I̱saka. Yaateenyi̱ri̱ nkwi̱ za kwokya kihongwa. Yaabyoki̱ri̱ yaagyenda mu kicweka kya Ruhanga ki̱yamu̱weereeri̱. ");
INSERT INTO rub_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Kiro kyakasatu, I̱bbu̱rahi̱mu̱ yaabyokeerye mei̱so yaawona kiikaru ki̱kyo nikili hadeiho. ");
INSERT INTO rub_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Nahab̯waki̱kyo I̱bbu̱rahi̱mu̱ yaaweereeri̱ badulu baamwe naakoba yati, “Nywe mwi̱calenge haha na ndogoyi̱, gya na musigazi yogo, katugyende ntadiiko ku̱di̱ tu̱ramye tu̱kwi̱ra tu̱baagye haha.” ");
INSERT INTO rub_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","I̱bbu̱rahi̱mu̱ yaasengi̱ri̱ nkwi̱ za kwokya kihongwa, yaazi̱tweka I̱saka mu̱tabani̱ waamwe. Yo I̱bbu̱rahi̱mu̱ yaakweti̱ mworo na nsone, baagyenda. ");
INSERT INTO rub_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","I̱saka yeeti̱ri̱ bbaawe I̱bbu̱rahi̱mu̱, yaamu̱b̯u̱u̱lya naakoba yati, “Bbaabba!,” Bbaawe yeeteb̯uka naakoba yati, “Ee, kyani mwana wange?” I̱saka yaab̯u̱u̱lya bbaawe naakoba yati, “Mworo na nkwi̱ mbibibyo, bei̱tu̱ mwana gwa ntaama gya kihongwa kya kwokya gili hanya?” ");
INSERT INTO rub_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","I̱bbu̱rahi̱mu̱ yei̱ri̱ri̱mwo naakoba yati, “Mwana wange, Ruhanga yankei yooyo yewonira mwana gwa ntaama gya kihongwa kya kwokya.” Babiri baba beeyongeeri̱ na lugyendu lwab̯u. ");
INSERT INTO rub_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","B̯u̱baadoori̱ ha kiikaru kya Ruhanga ki̱yaaweereeri̱ I̱bbu̱rahi̱mu̱ yaatara kyoto, yaapanga nkwi̱, yaabboha I̱saka mu̱tabani̱ waamwe, yaamu̱garami̱ri̱i̱rya ha kyoto ha nkwi̱. ");
INSERT INTO rub_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Kasi, I̱bbu̱rahi̱mu̱ yaasenga nsone kusala mwana waamwe nka kihongwa. ");
INSERT INTO rub_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Bei̱tu̱ malayika wa Mukama yaamweti̱ri̱ na mwiguru naakoba yati, “I̱bbu̱rahi̱mu̱, I̱bbu̱rahi̱mu̱.” I̱bbu̱rahi̱mu̱ yeeteb̯uka yati, “Ndi haha.” ");
INSERT INTO rub_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Yamuweera naakoba yati, “Otahutaaza mwana waamu, nyetegeri̱i̱ze nka kwoku̱ti̱i̱na Ruhanga, ti̱wanzi̱ma mwana waamu omwei̱ musa.” ");
INSERT INTO rub_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","I̱bbu̱rahi̱mu̱ yaabyokeerye mei̱so yaamagamaga, i̱nyu̱ma lyamwe, yaaweeni̱ mpaya gya ntaama, mahembe gaayo gakwati̱i̱rwe mu kisaka. Yaagyendi̱ri̱ yaagitolayo, gyogyo yaahonga. Kyabba kihongwa kyokye mu kiikaru kya mwana waamwe. ");
INSERT INTO rub_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Kiikaru ki̱kyo, I̱bbu̱rahi̱mu̱ yaakyeti̱ri̱, “Mukama yooyo agaba.” Na hataati̱ kwokwo bakoba yati, “Ha lusahu lwa Mukama yooyo akwi̱za kugaba.” ");
INSERT INTO rub_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Malayika wa Mukama yeezolokeerye mwiguru yeeta I̱bbu̱rahi̱mu̱ gwakabiri, ");
INSERT INTO rub_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","yaamuweera yati, “Mukama akukoba yati, ‘Gya nyankei ndahi̱i̱ri̱ hab̯wakubba okoori̱ kintu kiki, ti̱wanzi̱ma mwana waamu omwei̱ yankei, ");
INSERT INTO rub_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","mananu kwo ndikuha mu̱gi̱sa, ndi̱kanyi̱sya beizukulu baamu beijane nzota za mu mwanya kandi beijane musinyi gwa ha mutanda. Beizukulu baamu balitwala mbuga za banyanzigwa baab̯u, ");
INSERT INTO rub_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","kandi mu beizukulu baamu mahanga gensei̱ ga hansi hooho galitungira mu̱gi̱sa, hab̯wakubba waab̯u̱ndali̱i̱ri̱ iraka lyange.’” ");
INSERT INTO rub_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Nahab̯waki̱kyo, I̱bbu̱rahi̱mu̱ yei̱ri̱ri̱ hayaati̱gi̱ri̱ badulu baamwe beemuka Bbeeri̱-sebba, hooho I̱bbu̱rahi̱mu̱ yeicala. ");
INSERT INTO rub_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Bi̱byo b̯u̱byamali̱ki̱ri̱, bantu baaweera I̱bbu̱rahi̱mu̱ nibakoba yati, “Mi̱ri̱ka abyali̱i̱ri̱ weenyu̱ Nahoori̱ baana baba: ");
INSERT INTO rub_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","U̱zi̱ yooyo mu̱zegei̱zo, B̯u̱u̱zi̱, yooyo akumugwera, hakuhonderaho Kemweri̱ bba Aramu, ");
INSERT INTO rub_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","baateeryaho Kesedi̱, Hazo, Fi̱ri̱dasi̱, Ji̱di̱raafi̱ na Bbeesweri̱.” ");
INSERT INTO rub_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","(Bbeesweri̱ yooyo yaabyeri̱ Rebbeeka.) Baana munaanei baba boobo Mi̱ri̱ka yaabyeri̱ hali Nahoori̱ waab̯u I̱bbu̱rahi̱mu̱. ");
INSERT INTO rub_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Kandi mu̱kali̱ waamwe wakabiri gi̱beetengi̱ Rehuma, yaabyeri̱, Teebba, Gahamu, Tahasi na Maaka. ");
INSERT INTO rub_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Saara yaadooseerye myaka ki̱ku̱mi̱ na maku̱mi̱ gabiri na musanju. ");
INSERT INTO rub_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Yaakwereeri̱ mu kyaru kya Ki̱ryasi̱-araba (hataati̱ gyegebeerwe nka Hebbu̱rooni̱) mu nsi gya Kanani̱. I̱bbu̱rahi̱mu̱ yaasaali̱i̱rwe hoi̱ kandi yaalira Saara mu̱kali̱ waamwe. ");
INSERT INTO rub_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","I̱bbu̱rahi̱mu̱ yaati̱gi̱ri̱ hahwo mu̱ku̱u̱ waamwe, yaagyenda yaaweera Bahi̱i̱ti̱ naakoba yati, ");
INSERT INTO rub_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Ndi munyamahanga muli nywe, kandi mu̱goonyi̱. Mu̱ngu̱li̱sye kibanja haha, kibbe kyange. Nki̱koresye kuziika mu̱kali̱ wange kurungi.” ");
INSERT INTO rub_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Bahi̱i̱ti̱ baamwi̱ri̱ri̱mwo nibakoba yati, ");
INSERT INTO rub_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Mukama wange weegwa kitukukoba, oli Ruhanga muli twe wab̯u̱sobozi̱. Ziika mu̱ku̱u̱ waamu mu kituuru ki̱weesi̱i̱mi̱ra mu bituuru byetu̱, tihaloho muntu yensei̱ muli twe aku̱kwi̱ma rundi akukugaana kituuru hab̯waziikira mu̱ku̱u̱ waamu.” ");
INSERT INTO rub_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","I̱bbu̱rahi̱mu̱ yaabyoki̱ri̱ yeetu̱lu̱ki̱ri̱i̱ri̱ yaasi̱i̱ma Abahi̱i̱ti̱ banyansi. ");
INSERT INTO rub_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Yaabaweera naakoba yati, “B̯umwakabba ni̱mu̱kwendya nziike mu̱ku̱u̱ wange, mwetegeerye kinkukoba, kandi mutagire Efu̱rooni̱ mu̱tabani̱ wa Zohara, ");
INSERT INTO rub_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","aleke ampe b̯wingira b̯wamwe b̯uli Makipera ha nsaru gya kibanja kyamwe. Muhendu gwakyo gwensei̱ guyakancwa nkugumusasula nywensei̱ nimukuwona libbe i̱ri̱mbo lyange.” ");
INSERT INTO rub_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Mu kasu̱mi̱ kakwo Efu̱rooni̱ yaali na Bahi̱i̱ti̱ bei̱ra, yei̱ri̱ri̱mwo I̱bbu̱rahi̱mu̱, Abahi̱i̱ti̱ bensei̱ nibali beecooki̱ri̱ mu rub̯uga kwetegeerya, yaakoba yati, ");
INSERT INTO rub_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Kwahi, mukama wange nyeetegeerya, kibanja ki̱kyo nkukikuha hamwei̱ na b̯wingira. Nkukuraganisya mu mei̱so ga bantu beihanga lyange kibanja nkukikuha, oziike mu̱ku̱u̱ waamu.” ");
INSERT INTO rub_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Nahab̯waki̱kyo, I̱bbu̱rahi̱mu̱ yeetu̱lu̱ki̱ri̱ hansi yaasi̱i̱mi̱ri̱ Bahi̱i̱ti̱. ");
INSERT INTO rub_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Yaaweera Efu̱rooni̱ bantu bensei̱ nibakwetegeerya, naakoba yati, “Nku̱taagi̱i̱ri̱ nzegwa, kansasule muhendu gwa kibanja kiki. Ikiriza ngukuhe, aleke nziikemwo mu̱ku̱u̱ wange.” ");
INSERT INTO rub_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efu̱rooni̱ yaaweereeri̱ I̱bbu̱rahi̱mu̱ naakoba yati, ");
INSERT INTO rub_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Mukama wange nzegwa, kicweka kyeitehe kikugula sente zikwijana sekeeri̱ bi̱ku̱mi̱ binei, kikyani hali we nagya? Ziika mu̱ku̱u̱ waamu.” ");
INSERT INTO rub_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","I̱bbu̱rahi̱mu̱ yeikiraniza nʼEfu̱rooni̱, yaamu̱pi̱mi̱ra ku̱si̱gi̱ki̱ra ha muhendu gu̱yabazi̱ri̱, Abahi̱i̱ti̱ nibakwegwa, zoozo sekeeri̱ bi̱ku̱mi̱ binei za feeza, nibahondera muhendu gwa basu̱u̱b̯u̱zi̱ gunyakubba niguloho mu kasu̱mi̱ kakwo. ");
INSERT INTO rub_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Nahab̯waki̱kyo, kibanja kyʼEfu̱rooni̱, kinyakubba nikili Makipera gili Mu b̯uhulukalyoba b̯wa Mamu̱le, kibanja na b̯wingira b̯unyakubba nib̯ulimwo, misaali myensei̱ minyakubba nimili mu kibanja, kumalayo nsaru zensei̱, ");
INSERT INTO rub_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","byensei̱ baabi̱heeri̱ I̱bbu̱rahi̱mu̱ mu mei̱so gʼAbahi̱i̱ti̱, bibbe bintu byamwe hab̯we bantu bensei̱ banyakubba bei̱zi̱ri̱ heirembu lya rub̯uga nibakuwona. ");
INSERT INTO rub_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Ki̱kyo b̯u̱kyamali̱ki̱ri̱, I̱bbu̱rahi̱mu̱ yaaziika Saara mu̱kali̱ waamwe mu b̯wingira b̯unyakubba mu kibanja kinyakubba nikili Makipera ha b̯uhulukalyoba b̯wa Mamu̱le (hataati̱ gyegebeerwe nka Hebbu̱rooni̱) mu nsi gya Kanani̱. ");
INSERT INTO rub_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Musiri na b̯wingira b̯unyakubba nib̯ugulimwo binyakubba bya Bahi̱i̱ti̱, baabi̱tu̱ndi̱si̱i̱rye I̱bbu̱rahi̱mu̱, lyabba i̱ri̱mbo lyamwe. ");
INSERT INTO rub_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Mu kakwo kasu̱mi̱, I̱bbu̱rahi̱mu̱ yaali agu̱lu̱u̱si̱ri̱ hoi̱ kandi Mukama yaali amu̱heeri̱ mu̱gi̱sa mu bintu byensei̱. ");
INSERT INTO rub_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","I̱bbu̱rahi̱mu̱ yaaweereeri̱ muheereza waamwe mu̱handu̱ wa bintu bya mu nnyu̱mba gyamwe byensei̱ naakoba yati, “Taa mukono gwamu hansi wa kiberu kyange, ");
INSERT INTO rub_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Nkwendya orahire mu mei̱so ga Mukama Ruhanga wa mwiguru na nsi nti, toli̱tooleerya mu̱tabani̱ wange mu̱kali̱ mu bahara ba Bakanani̱ bankwicala nabo, ");
INSERT INTO rub_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","bei̱tu̱ gyenda mwihanga lyange, mu bantu ba luganda lwange hooho otooleerye mu̱tabani̱ wange I̱saka mu̱kali̱.” ");
INSERT INTO rub_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Muheereza yaamwi̱ri̱ri̱mwo naakoba yati, “Mu̱kali̱ Kakubba asuula kwi̱za nagya mu nsi gigi b̯u mu̱tabani̱ waamu, ndimutwala mu gi̱gyo nsi gi̱waaru̱gi̱i̱ri̱mwo?” ");
INSERT INTO rub_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","I̱bbu̱rahi̱mu̱ yei̱ri̱ri̱mwo muheereza naakoba yati, “Ki̱kyo otali̱ki̱geryaho okatwala ku̱kwo mwana wange. ");
INSERT INTO rub_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Mukama, Ruhanga wa mwiguru yantoori̱ mu nnyu̱mba gya bbaabba. Yantoola mu nsi gya kwamwetu̱. Ruhanga yaakoori̱ ndagaanu ginyamaani nagya naakoba yati, ‘Nsi gigi ndigiha beizukulu baamu,’ alituma malayika waamwe akubanzeyo. We wolidwayo okwi̱za kwagya mu̱kali̱ gyolitungira mu̱tabani̱ wange. ");
INSERT INTO rub_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Kakubba mu̱kali̱ yogwo asuula kwi̱ra nawe, kirahiro kyorahi̱i̱ri̱ kilibba kitakukukwata kyonkei otalitwala ku̱kwo mwana wange.” ");
INSERT INTO rub_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Nahab̯waki̱kyo muheereza yaahu̱lu̱ki̱i̱rye mukono gwamwe hansi gya kiberu kya I̱bbu̱rahi̱mu̱ mukama waamwe, yaamurahiira nka kwali̱dosereerya ki̱kyo kyamu̱ragi̱i̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Kasi mwomwo muheereza yaatoolamwo ngamira i̱ku̱mi̱ mu ngamira za mukama waamwe, yaasi̱mbu̱ra yaagyenda. Mu kugyenda, yaatwalegeeni̱ na bisembu bindi byensei̱ bya mukama waamwe yaakomoreeri̱mwo. Yaakwata gwa Mesopotami̱ya, yaadwa mu rub̯uga lwa kwamwab̯u Nahoori̱. ");
INSERT INTO rub_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Joojolo mu b̯wi̱re b̯wa bakali̱ bagyenderemwo kutaha meezi̱, muheereza yogwo yaatweri̱ zi̱zo ngamira heehi̱ nei̱zu̱ba lya meezi̱ kuzagira, hanzei wa rub̯uga. ");
INSERT INTO rub_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Muheereza yaasabi̱ri̱ naakoba yati, “Ai̱ Mukama Ruhanga wa mukama wange I̱bbu̱rahi̱mu̱, nkwesengereerye ompe mu̱gi̱sa kiro kiki, woolokye mukama wange I̱bbu̱rahi̱mu̱ ngonzi zinene. ");
INSERT INTO rub_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Wona nyemereeri̱ hei̱zu̱ba lya meezi̱, kandi bahara ba bantu bamu rub̯uga bakwi̱za kutaha meezi̱. ");
INSERT INTO rub_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Muhala ginyasaba nti, ‘Nku̱tagi̱i̱ri̱, weetukula kyese kyamu nywe meezi̱,’ yaakei̱ramwo naakoba yati, ‘Nywa, kandi ngamira zaamu nazo kanzihe meezi̱ zinywe,’ yogwo yooyo okubba okomeeri̱ muheereza waamu I̱saka. Ki̱kyo kyokyo nyegeraho nka ku̱wolokereerye mukama wange ngonzi zaamu zinene.” ");
INSERT INTO rub_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","B̯uyaali atakamaari kusaba, hei̱zaho Rebbeeka muhara wa Bbeesweri̱ mu̱tabani̱ wa Mi̱ri̱ka, muka Nahoori̱ waab̯u I̱bbu̱rahi̱mu̱, yei̱zi̱ri̱ yeetweki̱ri̱ kyese kyamwe kwibega. ");
INSERT INTO rub_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Yaali muhala nyab̯urungi atakawonangaho mudulu, yaasi̱ri̱mu̱ki̱ri̱ hei̱zu̱ba yaataha meezi̱ yaagyenda. ");
INSERT INTO rub_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Nahab̯waki̱kyo, muheereza wʼI̱bbu̱rahi̱mu̱ yei̱ru̱ka ku̱mu̱romba, yaamusaba naakoba yati, “Nku̱tagi̱i̱ri̱, mpahoona meezi̱ gaamu kyese kyamu nywe.” ");
INSERT INTO rub_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Muhala yeetu̱ku̱u̱ri̱ kyese kyamwe, yaakikwata na mikono, yaakoba yati, “Nywa mukama wange.” ");
INSERT INTO rub_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","B̯u̱yaamaari̱ kumuha meezi̱ yaakoba yati, “Ngamira zaamu nazo kanzitahire zinywe meezi̱ mpaka b̯ugakazidwa.” ");
INSERT INTO rub_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Nahab̯waki̱kyo, meezi̱ ganyakubba nigali mu kyese yaagaku̱su̱mu̱la mu kyoho, b̯wangu b̯wangu yei̱ra hei̱zu̱ba yatahira ngamira zaamwe zensei̱ zaanywa kudwa b̯u̱gaazi̱doori̱. ");
INSERT INTO rub_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Mudulu yei̱ceeri̱ amu̱li̱ngi̱ri̱i̱ri̱ yeetekereeri̱, yeetegereze lugyendu lwamwe Mukama b̯uyaabba alu̱heeri̱ mu̱gi̱sa rundi kwahi. ");
INSERT INTO rub_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ngamira b̯uzamaari kunywa, mudulu yaakwata mpi̱ta gya zaabbu gibalwala ku nni̱ndo gi̱ku̱doosya b̯wozoho b̯wa guraamu mukaaga (6), na bikomo bibiri bya zaabbu byakulwala ha mikono bi̱ku̱doosya b̯wozoho b̯wa guraamu ki̱ku̱mi̱ na gabiri (120), ");
INSERT INTO rub_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","yaamu̱b̯u̱u̱lya naakoba yati, “We, oli muhara wa naani? Muli na mwanya mu nnyu̱mba gya bbaawu hatukusobora kulaala?” ");
INSERT INTO rub_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Muhala yei̱ri̱ri̱mwo naakoba yati, “Gya, ndi muhara wa Bbeesweri̱, mu̱tabani̱ wa Mi̱ri̱ka gi̱yaabyeri̱ hali Nahoori̱.” ");
INSERT INTO rub_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Yaab̯u̱ni̱i̱rye yaakoba yati, “Tuli neisubi na bidyo binene, na mwanya gwakulaalamwo.” ");
INSERT INTO rub_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Mudulu yeetu̱lu̱ki̱ri̱i̱ri̱ yaaramya Mukama, ");
INSERT INTO rub_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","yaakoba yati, “Mukama ahaariizwe, Ruhanga wa mukama wange I̱bbu̱rahi̱mu̱, yoolokeerye mukama wange ngonzi zaamwe zinene na b̯wesigwa b̯wamwe. Mukama yanzebembeeri̱ mu muhanda, yandoosya ha nnyu̱mba gya ba luganda lwa mukama wange.” ");
INSERT INTO rub_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Muhala yei̱ru̱ki̱ri̱ yaasoboora baakwamwab̯u bintu bi̱bbeeri̱ho. ");
INSERT INTO rub_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebbeeka yaali na waab̯u gibakweta Labbani̱. Labbani̱ yei̱ru̱ki̱ri̱ naagyenda hei̱zu̱ba, hali mudulu yaali. ");
INSERT INTO rub_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","B̯u̱yakadoori̱ akawona mpi̱ta na kikomo nibili ha mikono mya nyaakaab̯u, kandi na ku̱yeegwi̱ri̱ bigambu bya Rebbeeka nyaakaab̯u bi̱yaabazi̱ri̱ naakoba yati, “Mudulu kwokwo ambwereeri̱ yati.” Labbani̱ yaagyendi̱ri̱ yaatoolayo mudulu, yaamwagi̱i̱rye hei̱zu̱ba yeemereeri̱ heehi̱ na ngamira zaamwe. ");
INSERT INTO rub_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Yaamuweera naakoba yati, “I̱za, oingire mu nnyu̱mba, we wa Mukama gi̱yaaheeri̱ mu̱gi̱sa kyani ki̱kwemereeseerye hanzei? Nnyu̱mba ngi̱tegeki̱ri̱, na kiikaru kya ngamira ha zalaala.” ");
INSERT INTO rub_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Nahab̯waki̱kyo, mudulu yeingira mu nnyu̱mba, Labbani̱ yaatoola mbohero ha ngamira yaaziha isubi, yaamuha meezi̱ ga kunaaba magulu, na gandi ga badulu bayaali nabo, baanaabe magulu. ");
INSERT INTO rub_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Baamu̱segereerye bidyo adye, bei̱tu̱ yo yaakoba yati, “Ti̱nkwi̱za kudya ntakabazi̱ri̱ ki̱nyezi̱ri̱i̱ri̱.” Labbani̱ yaakoba yati, “Kibaze.” ");
INSERT INTO rub_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Naahahwo, muheereza yaakoba yati, “Gya, ndi muheereza wʼI̱bbu̱rahi̱mu̱, ");
INSERT INTO rub_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Mukama yaaheeri̱ mukama wange mi̱gi̱sa minene, ali muntu wa ki̱ti̱i̱ni̱sa, amu̱heeri̱ magana ga nte, ga mbu̱li̱ na ga ntaama, feeza na zaabbu, baheereza na bazaana, ngamira na ndogoyi̱. ");
INSERT INTO rub_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Saara mukaa mukama wange, yaabyali̱i̱ri̱ mukama wange mwana wa b̯udulu, kandi de agu̱lu̱u̱si̱ri̱, bei̱tu̱ mwana yogwo, I̱bbu̱rahi̱mu̱ amu̱heeri̱ byensei̱ byali nabyo. ");
INSERT INTO rub_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Mukama wange yaandahi̱si̱i̱rye naakoba yati, ‘Otalitungira mwana wange mu̱kali̱, mu bahara ba Bakanani̱, banyansi gindimu, ");
INSERT INTO rub_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","bei̱tu̱ ogyende mu nnyu̱mba gya bbaabba, mu luganda lwange, hooho otungire mwana wange mu̱kali̱.’ ");
INSERT INTO rub_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Nyeri̱ri̱mwo mukama wange nti, ‘B̯undi mu̱kali̱ akusobora kusuula kwi̱za nagya.’ ");
INSERT INTO rub_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Bei̱tu̱ yaakoba yati, ‘Mukama gimpereza alituma malayika waamwe agyende nawe, kandi aterekereerye lugyendu lwamu, kwokwo otungire mu̱tabani̱ wange mu̱kali̱ akuruga mu ba luganda lwange na mu nnyu̱mba gya bbaabba. ");
INSERT INTO rub_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","B̯wolidwa mu baluganda lwange, b̯uli kirahiro kiki, kilibba kitakukukwata. Kakubba mu̱kali̱ batamukuha, nab̯wo kirahiro kiki, kilibba kitakukukwata.’ ");
INSERT INTO rub_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Kiro kiki b̯u̱nyadoori̱ hei̱zu̱ba nyasaba ninkoba yati, ‘Ai̱ Mukama Ruhanga wa mukama wange I̱bbu̱rahi̱mu̱, b̯u̱waakabba nooku̱si̱i̱ma kuha mu̱gi̱sa lugyendu lwange lulu, ");
INSERT INTO rub_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","hataati̱ nyemereeri̱ hei̱zu̱ba lya meezi̱ muhala akwi̱za kutaha meezi̱, ginyasaba nti, “Nku̱tagi̱i̱ri̱, mpa meezi̱ ga mu kyese kyamu nnywaho,” ");
INSERT INTO rub_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","yaakeeramwo naakoba yati, “Nywa, kandi na ngamira zaamu nazo kanzihe meezi̱ zinywe,” b̯u̱b̯wo yogwo yooyo mu̱kali̱, Mukama gi̱yaakomi̱i̱ri̱ mwana wa mukama wange.’ ");
INSERT INTO rub_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“B̯unyakali ninkusaba, Rebbeeka yei̱za yeetweki̱ri̱ kyese kwibega, yaasi̱ri̱mu̱ki̱ri̱ hei̱zu̱ba, yaataha meezi̱. Nyamusaba ninkoba yati, ‘Nku̱tagi̱i̱ri̱, mpahoona meezi̱ nywe.’ ");
INSERT INTO rub_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","B̯ulohob̯uloho yeetu̱ku̱u̱ri̱ kyese yaakoba yati, ‘Nywa, na ngamira zaamu nazo nku̱zi̱nywesya.’ Naahahwo nyaanywa, na ngamira zange nazo zaanywa. ");
INSERT INTO rub_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Mwomwo nyaamu̱b̯u̱u̱lya ninkoba yati, ‘We oli muhara wa naani?’ Yei̱ri̱ri̱mwo naakoba yati, ‘Ndi muhara wa Bbeesweri̱, mu̱tabani̱ wa Mi̱ri̱ka gi̱yaabyeri̱ hali Nahoori̱.’ Nyamu̱lwalya mpi̱ta ha nni̱ndo, na bikomo ha mikono myamwe. ");
INSERT INTO rub_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Nyaatu̱lu̱ki̱ri̱ mu̱twe, nyaaramya kandi nyaasi̱i̱ma Mukama Ruhanga wa mukama wange I̱bbu̱rahi̱mu̱, nka ku̱yaanyebembeeri̱ kurungi ntungire mwana wa mukama wange mu̱kali̱ mu bantu ba luganda lwamwe. ");
INSERT INTO rub_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Hataati̱, b̯umwakabba nimuli bakwolokya mukama wange ngonzi zinene na mananu, mu̱mbwere, b̯ukyabba kitali kwokwo nab̯wo mumbwere ngyende handi.” ");
INSERT INTO rub_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Hahwo Labbani̱ na Bbeesweri̱ bei̱ri̱ri̱mwo nibakoba yati, “Ki̱kyo kigambu kya Mukama, twe titwakuweere kibiibi rundi kirungi. ");
INSERT INTO rub_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebbeeka ngogwo akuli mu mei̱so mutwale, mu̱tabani̱ wa mukama waamu amutunge nka Mukama kwakobi̱ri̱.” ");
INSERT INTO rub_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Muheereza wʼI̱bbu̱rahi̱mu̱ b̯u̱yeegwi̱ri̱ bigambu byab̯u, yaagwa hansi yaaramya Mukama. ");
INSERT INTO rub_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Yaahu̱u̱ri̱ nsahu, yaatoolayo bya kwedoli̱ga bya feeza na bya zaabbu, na byakulwala yaabiha Rebbeeka, kandi yaaha waab̯u muhala na mmaawe bisembu bya muhendu. ");
INSERT INTO rub_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Hei̱nyu̱ma yo na badulu banyakubba nibali nayo, baadi̱i̱ri̱, banywa, kandi baalaala hahwo i̱jolo li̱lyo. Mwakya b̯u̱b̯wakeeri̱, muheereza yaakoba yati, “Hataati̱, ka nkubeyo b̯u mukama wange.” ");
INSERT INTO rub_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Waab̯u muhala na mmaawe bei̱ri̱ri̱mwo nibakoba yati, “Leka muhala abbe natwe b̯wi̱re b̯u̱dooli̱, hakiri biro i̱ku̱mi̱ bisa, biro bi̱byo b̯u̱byakarabaho, agyende.” ");
INSERT INTO rub_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Bei̱tu̱ muheereza yaabaweera naakoba yati, “Mu̱leke kunkerereerya, hab̯wakubba ki̱kyo ki̱nyei̱zi̱ri̱i̱ri̱, Mukama aki̱maari̱, mundeke nkubeyo b̯u mukama wange.” ");
INSERT INTO rub_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Baamwi̱ri̱ri̱mwo nibakoba yati, “Katwete muhala, tuwone kiyacwamwo.” ");
INSERT INTO rub_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Beeta Rebbeeka, baamu̱b̯u̱u̱lya nibakoba yati, “Okwendya kugyenda na mudulu yogwo hataati̱?” Yaabei̱ri̱ri̱mwo naakoba yati, “Kwokwo nkugyenda.” ");
INSERT INTO rub_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Kasi beikiriza Rebbeeka nyaakaab̯u na muheereza waamwe bagyende na muheereza wʼI̱bbu̱rahi̱mu̱, hamwei̱ na bantu bayaali nabo. ");
INSERT INTO rub_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Baasabi̱i̱ri̱ Rebbeeka mu̱gi̱sa nibakoba yati, “Nyaakeetu̱, obbe maa bantu nku̱mi̱ na nku̱mi̱, beizukulu baamu, basi̱ngu̱renge banyanzigwa baab̯u.” ");
INSERT INTO rub_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Nahab̯waki̱kyo Rebbeeka na baheereza baamwe, baatembi̱ri̱ ngamira, baahondera mudulu. Kwokwo yatyo Muheereza wʼI̱bbu̱rahi̱mu̱ yaatweri̱ Rebbeeka baagyenda. ");
INSERT INTO rub_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Mu kasu̱mi̱ kakwo, I̱saka yaali afu̱ru̱ki̱ri̱ kuruga Bbeeri̱-lahayi̱-rohi̱ ei̱ri̱ri̱ Negeb̯u̱. ");
INSERT INTO rub_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Kiro ki̱mwei̱, mu b̯wi̱re b̯wa joojolo, I̱saka yaagyendi̱ri̱ mu musiri kulibatalibata, yaaweeni̱ ngamira nizicaali hadeiho, ni̱zi̱kwi̱za. ");
INSERT INTO rub_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebbeeka b̯u̱yaaweeni̱ I̱saka, yaani̱i̱nu̱ka kuruga ha ngamira, ");
INSERT INTO rub_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","yaab̯u̱u̱lya muheereza wʼI̱bbu̱rahi̱mu̱ naakoba yati, “Mudulu yodi̱, akulibata naatwesu̱mi̱i̱ra, ali naani?” Muheereza yei̱ri̱ri̱mwo naakoba yati, “Yogwo yooyo mukama wange.” Rebbeeka yaakwata biheru yeebbumba mei̱so. ");
INSERT INTO rub_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Muheereza yaasoboora I̱saka byensei̱ binyakubbaho. ");
INSERT INTO rub_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Nahab̯waki̱kyo, I̱saka yengi̱i̱rye Rebbeeka mu heema gya mmaawe Saara. Rebbeeka yaafooka mu̱kali̱ waamwe. Kandi I̱saka yaamwendeerye hoi̱. Rebbeeka yaahu̱u̱mu̱li̱i̱rye I̱saka, yaamwebeseerye b̯ujune b̯wa kurugwaho mmaawe. ");
INSERT INTO rub_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","I̱bbu̱rahi̱mu̱ yaatu̱ngi̱ri̱ mu̱kali̱ wondi gibakweta Ketura. ");
INSERT INTO rub_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Yaamubyalira baana, gaga googo mabara gaab̯u: Zimurani, Yokosani̱, Medyani̱, Mi̱dyani̱, I̱si̱baki̱, na Su̱u̱ha. ");
INSERT INTO rub_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yokosani̱ yaabyeri̱ Sebba na Dedani̱. Kandi batabani̱ ba Dedani̱, mabara gaab̯u googo gaga: Asu̱ru̱ma, Lehu̱mi̱na. ");
INSERT INTO rub_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Batabani̱ ba Mi̱dyani̱, mabara gaab̯u googo gaga: Efa, Eferi̱, Hanoki̱, Abi̱da na Eri̱da. Bab̯wo bensei̱ baali beizukulu ba Ketura. ");
INSERT INTO rub_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","I̱bbu̱rahi̱mu̱ byensei̱ biyaali nabyo yaabi̱heeri̱ I̱saka. ");
INSERT INTO rub_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Bei̱tu̱ baana ba bakali̱ bandi yaabaheeri̱ bisembu, bei̱tu̱ b̯uyaali atakakwi̱ri̱ yaababi̱ngi̱ri̱ yaabahu̱kani̱a na mu̱tabani̱ waamwe I̱saka baagyenda mu b̯uhulukalyoba hadeiho na mu̱tabani̱ I̱saka. ");
INSERT INTO rub_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","I̱bbu̱rahi̱mu̱ yaakwi̱ri̱ adooseerye myaka ki̱ku̱mi̱ na nsanju na mitaanu mya b̯u̱handu̱, ");
INSERT INTO rub_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","yaakwi̱ri̱ agu̱lu̱u̱si̱ri̱, kandi ahandi̱ri̱ hoi̱, yaahondera babbaawe. ");
INSERT INTO rub_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Batabani̱ baamwe, I̱saka nʼI̱si̱mai̱ri̱, baamu̱zi̱ki̱ri̱ mu b̯wingira b̯wa Makipera mu kibanja kyʼEfu̱rooni̱ mu̱tabani̱ wa Zohara Mu̱hi̱i̱ti̱ kinyakubba mu b̯uhulukalyoba b̯wa Mamu̱le. ");
INSERT INTO rub_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Kibanja ki̱kyo I̱bbu̱rahi̱mu̱ ki̱yaagu̱u̱ri̱ hali Abahi̱i̱ti̱, yo na mu̱kali̱ waamwe Saara hooho baabazi̱ki̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","I̱bbu̱rahi̱mu̱ b̯u̱yaamaari̱ ku̱kwa, Ruhanga yaaheeri̱ mu̱gi̱sa I̱saka mu̱tabani̱ waamwe. I̱saka yei̱calengi̱ heehi̱ na Bbeeri̱-lahayi̱-rohi̱. ");
INSERT INTO rub_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Gaga googo mabara ga beizukulu bʼI̱si̱mai̱ri̱, mu̱tabani̱ wʼI̱bbu̱rahi̱mu̱ gi̱yaabyeri̱ hali Hagara Mu̱nyami̱si̱ri̱, muzaana wa mu̱kali̱ waamwe Saara. ");
INSERT INTO rub_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Mabara gagwo gahonderegeeni̱ nka kubyalwa kwab̯u kukuli: Nebayoosi̱, yooyo mu̱zegei̱zo, hahonderaho Kedali̱, Adi̱beeri̱, Mi̱bi̱samu̱. ");
INSERT INTO rub_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mi̱i̱si̱ma, Du̱ma, Masa, ");
INSERT INTO rub_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadadi̱, Tema, Yetu̱li̱, Nafi̱si̱, na Kedema. ");
INSERT INTO rub_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Bab̯wo boobo beizukulu bʼI̱si̱mai̱ri̱, kandi gagwo googo mabara gaabaaheeri̱ kika kyab̯u na kicweka ha baabambi̱ri̱ heema zaab̯u, ku̱si̱gi̱ki̱ra ku balemi̱ ba nganda za beebemberi̱ baab̯u i̱ku̱mi̱ na babiri. ");
INSERT INTO rub_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","I̱si̱mai̱ri̱ yaakwi̱ri̱ adooseerye myaka ki̱ku̱mi̱ na maku̱mi̱ gasatu na musanju mya b̯u̱handu̱, yaakwa yaahondera babbaawe. ");
INSERT INTO rub_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Batabani̱ baamwe bei̱ceeri̱ kuruga Havi̱la ku̱doosya Su̱u̱ru̱ gi̱li̱ngi̱ri̱i̱ri̱ Mi̱si̱ri̱, b̯u̱ki̱i̱zi̱ b̯wʼAsi̱ri̱ya, yei̱ceeri̱ mu b̯uhulukalyoba, ahereeri̱ banyaruganda baamwe. ");
INSERT INTO rub_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Gaga googo mabara ga beizukulu bʼI̱saka, mu̱tabani̱ wʼI̱bbu̱rahi̱mu̱. I̱bbu̱rahi̱mu̱ yaabyeri̱ I̱saka, ");
INSERT INTO rub_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","I̱saka yaali adooseerye myaka maku̱mi̱ ganei mya b̯u̱handu̱, hayaatu̱ngi̱i̱ri̱ Rebbeeka, muhara wa Bbeesweri̱ Mu̱raami̱i̱ni̱, wa mu rub̯uga lwa Padanaramu. Rebbeeka yogwo yaali nyaakaab̯u Labbani̱ Mu̱raami̱i̱ni̱. ");
INSERT INTO rub_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","I̱saka yaasabira mu̱kali̱ waamwe hali Mukama hab̯wakubba Rebbeeka yaali naali ngumba, kandi Mukama yaaheeri̱ I̱saka ki̱yaasabi̱ri̱, Rebbeeka yeemeta. ");
INSERT INTO rub_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Baana baalwani̱i̱ri̱ mu nda. Rebbeeka yaakoba yati, “Hab̯waki kiki ki̱mbeeri̱ho?” Nahab̯waki̱kyo yaab̯u̱u̱li̱i̱rye Mukama. ");
INSERT INTO rub_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Mukama yaamwi̱ri̱ri̱mwo naakoba yati, “Baana babiri bali mu nda gyamu balifooka mahanga gabiri ga bantu besoroori̱. Ihanga li̱mwei̱ lilibba linyamaani kukira li̱i̱ra. Mwana mu̱handu̱ aliheereza muto.” ");
INSERT INTO rub_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Kasu̱mi̱ kaamwe ka kubyala b̯u̱kaadoori̱, yaabyeri̱ barongo, ");
INSERT INTO rub_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Mwana munyakubanza kubyalwa yaali mwengu̱. Kandi byozo bi̱mu̱bbu̱mbi̱ri̱ mubiri gwensei̱, baamweta Esau̱. ");
INSERT INTO rub_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","B̯ulohob̯uloho mwi̱ra waamwe yaahuluka, yei̱zi̱ri̱ akweti̱ kigulu kyʼEsau̱ ku nkolokoojo, baamweta Yakobbo. I̱saka yaali adooseerye myaka nkaaga mya b̯u̱handu̱, mu̱kali̱ waamwe kubyala baana bab̯wo. ");
INSERT INTO rub_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Basigazi b̯u̱baahandi̱ri̱, Esau̱ yaabba mu̱hi̱i̱gi̱ nyakabara, mudulu munyakwendyanga irungu nka ki̱mwei̱, bei̱tu̱ Yakobbo yaali mu̱cu̱leeru̱, yei̱calengi̱ mu heema. ");
INSERT INTO rub_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","I̱saka yendyengi̱ Esau̱, hab̯wa ku̱mu̱hi̱i̱gi̱ra nyama gya bisolo naadya, bei̱tu̱ Rebbeeka yo yendyengi̱ Yakobbo. ");
INSERT INTO rub_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Kiro ki̱mwei̱, Yakobbo b̯uyaali naaku̱ti̱mba mu̱gu̱u̱de, Esau̱ yaaru̱gi̱ri̱ mwirungu ku̱hi̱i̱ga nzala nigikumudya hoi̱. ");
INSERT INTO rub_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Yaasabi̱ri̱ Yakobbo naaakoba yati, “Mpahoona mu̱gu̱u̱de gu̱gwo gwengu̱ ndyeho, nzala gi̱kwendya ku̱nzi̱ta!” (Kyokyo baamweti̱ri̱ Edomu̱.) ");
INSERT INTO rub_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yakobbo yei̱ri̱ri̱mwo naakoba yati, “Tu̱hi̱ngi̱sye, obanze ompe mugab̯u gwamu gwa b̯ugwete nka mu̱zegei̱zo.” ");
INSERT INTO rub_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau̱ yaakoba yati, “Ndi heehi̱ ku̱kwa, b̯ugwete b̯wange b̯ukungasira kyani?” ");
INSERT INTO rub_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yakobbo yaamuweera naakoba yati, “Ndahiira.” Esau̱ yaarahiira Yakobbo, yaamu̱tu̱ndi̱sya b̯ugwete b̯wamwe. ");
INSERT INTO rub_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Hei̱nyu̱ma, Yakobbo yaaha Esau̱ mugaati na mu̱gu̱u̱de gwa bi̱hi̱mba. Esau̱ yaadya kandi yaanywa, yaabyoki̱ri̱ yeegyendera. Kwokwo yati Esau̱ yaagayi̱ri̱ b̯ugwete b̯wamwe. ");
INSERT INTO rub_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Mu biro bi̱byo, nzala gyagwi̱ri̱ mu nsi, otabaari̱ ginyakubanza kubbaho mu b̯wi̱re b̯wa I̱bbu̱rahi̱mu̱. Mwomwo I̱saka yaagyenda Geraali̱ hali Abbi̱mereki̱ Mukama wa Bafi̱ri̱si̱i̱ti̱. ");
INSERT INTO rub_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Mukama yaawonekeeri̱ I̱saka yaamuweera naakoba yati, “Otagyenda Mi̱si̱ri̱, icala mu nsi gi̱nku̱kwolokya. ");
INSERT INTO rub_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Icala mu gigi nsi, nyabbanga nawe, ndikuha mu̱gi̱sa. Ndikuha gigi nsi, ngihe beizukulu baamu. Ndi̱tati̱i̱rya ndagaanu gi̱nyaakoori̱ na Bbaawu I̱bbu̱rahi̱mu̱. ");
INSERT INTO rub_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ndi̱kanyi̱sya beizukulu baamu nka nzota za hakyendi̱, ndibaha gigi nsi gyensei̱, kandi muli bo mahanga gensei̱ hooho galitungira mu̱gi̱sa. ");
INSERT INTO rub_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Nkukora yati, hab̯wakubba I̱bbu̱rahi̱mu̱ yaanzegwi̱ri̱, yaakwata biragiro na mateeka gange gensei̱.” ");
INSERT INTO rub_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Nahab̯waki̱kyo, I̱saka yei̱ceeri̱ Geraali̱. ");
INSERT INTO rub_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Bantu ba mu nsi gi̱gyo, b̯u̱baamu̱b̯u̱u̱li̱i̱rye bikukwatagana hali mu̱kalwe, yaabei̱ri̱ri̱mwo yati, “Yogwo ali nyakeetu̱,” hab̯wakubba yaati̱i̱nengi̱ kukoba yati, “Yogo ali mu̱kali̱ wange,” naateekereza nti, “Badulu ba kicweka kiki basobora ku̱nzi̱ta hab̯wa Rebbeeka,” kubba yaali mu̱kali̱ nyab̯urungi. ");
INSERT INTO rub_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","I̱saka amaari̱ kubba mu gi̱gyo nsi hab̯wa kasu̱mi̱ kalei, Abbi̱mereki̱ Mukama wa Bafi̱ri̱si̱i̱ti̱ yeemereeri̱ yaalingiira na mu di̱ri̱sa, yaawona I̱saka na Rebbeeka ni̱baku̱nywegerangana. ");
INSERT INTO rub_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Nahab̯waki̱kyo, Abbi̱mereki̱ yeeta I̱saka naakoba yati, “Hataati̱ Nnanu̱ki̱ri̱ kwo yogwo ali mu̱kali̱ waamu, hab̯waki noomweta nti, ‘Ali nyakeetu̱’?” I̱saka yaamwi̱ri̱ri̱mwo naakoba, “Hab̯wakubba nyati̱i̱nengi̱ nintekereza, nsobora ku̱kwa ha waamwe.” ");
INSERT INTO rub_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abbi̱mereki̱ yaamu̱b̯u̱u̱lya naakoba yati, “Kyani kyotu̱koori̱? Muntu wondi yensei̱ yaaku̱soboori̱ kulaala nayo, nootuletera musangu.” ");
INSERT INTO rub_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Nahab̯waki̱kyo, Abbi̱mereki̱ yaagyendi̱ri̱ mu mei̱so na kulamba bantu bensei̱ naakoba yati, “Yensei̱ alikwata hali yogo mudulu rundi mu̱kalwe, bali̱mwi̱ta.” ");
INSERT INTO rub_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Kasi I̱saka yaasimba nsigo mu gi̱gyo nsi, yaakesa mirundi ki̱ku̱mi̱ mu gwogwo mwaka gu̱mwei̱ gusa. Mukama yaamuha mu̱gi̱sa. ");
INSERT INTO rub_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Mudulu yogwo yaatu̱ngi̱ri̱ b̯u̱gu̱u̱da, itungu lyamwe lyeyongeera ki̱mwei̱. ");
INSERT INTO rub_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Yaali na magana ga ntaama, nte, na baheereza banene, Bafi̱ri̱si̱i̱ti̱ bamukwatirwa i̱hali̱. ");
INSERT INTO rub_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","(Mu kasu̱mi̱ kakwo, hooho Bafi̱ri̱si̱i̱ti̱ baalingi babbu̱mbi̱ri̱ mazi̱ba ga baheereza ba bbaawe I̱bbu̱rahi̱mu̱ gabaali batemi̱ri̱, mu biro bya bbaawe I̱bbu̱rahi̱mu̱.) ");
INSERT INTO rub_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Mmaali̱i̱ro gyaho, Abbi̱mereki̱ yaaweera I̱saka naakoba yati, “Tu̱ru̱gi̱zeho, hab̯wakubba oli na b̯u̱sobozi̱ kutukira.” ");
INSERT INTO rub_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Nahab̯waki̱kyo, I̱saka yaasetu̱ki̱ri̱, yaagyenda kwicala mu kihanga kya Geraali̱. ");
INSERT INTO rub_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Yei̱ra yemba mazi̱ba gʼI̱bbu̱rahi̱mu̱ yaalingi yembi̱ri̱, hab̯wakubba Bafi̱ri̱si̱i̱ti̱ baalingi bagabbu̱mbi̱ri̱ hei̱nyu̱ma gya ku̱kwa kwʼI̱bbu̱rahi̱mu̱, yaagaha mabara ga bbaawe I̱bbu̱rahi̱mu̱ yaali agaheeri̱. ");
INSERT INTO rub_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Baheereza bʼI̱saka b̯u̱bembi̱ri̱ i̱zu̱ba mu ki̱kyo kihanga, baagi̱i̱rye mu̱di̱mo gwa meezi̱ garungi. ");
INSERT INTO rub_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Bei̱tu̱ bali̱i̱sya ba Geraali̱ baazongobi̱ri̱ na bali̱i̱sya bʼI̱saka, b̯uli muntu naakoba yati, “I̱zu̱ba lili lyetu̱.” Kyokyo I̱saka yaalyeteeri̱ Eseeki̱, hab̯wakubba baazongobi̱ri̱ nayo nahahwo. ");
INSERT INTO rub_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Kasi hei̱nyu̱ma, bemba i̱zu̱ba lindi, nalyo baali̱zongobeeri̱ho, yaalyeta Si̱ti̱na. ");
INSERT INTO rub_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","B̯u̱yaaru̱gi̱ri̱ hahwo, yembi̱ri̱ I̱zu̱ba lindi, li̱lyo litakabazongobesye, kasi alyete Rehobboosi̱ naakoba yati, “Hataati̱ Mukama atu̱heeri̱ mwanya gukumala, tukugyenda kukanya mu nsi.” ");
INSERT INTO rub_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Yaaru̱gi̱ri̱ hahwo yaagyenda Bbeeri̱-sebba. ");
INSERT INTO rub_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","I̱jolo lyolyo Mukama yaamu̱wonekeeri̱ naamuweera, “Gyagya Ruhanga wa Bbaab̯u I̱bbu̱rahi̱mu̱, otati̱i̱na, ndi hamwei̱ nawe, nkwi̱za kukuha mu̱gi̱sa nyongere lubyalu lwamu hab̯wa muzaana wange I̱bbu̱rahi̱mu̱.” ");
INSERT INTO rub_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Hahwo, I̱saka yaabi̱mbi̱ri̱ho kyoto yaaramya Mukama, yaabambaho heema gyamwe, baheereza bʼI̱saka hooho de bembi̱ri̱ I̱zu̱ba lindi. ");
INSERT INTO rub_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Kiro ki̱mwei̱, Abbi̱mereki̱ yaaru̱gi̱ri̱ Geraali̱, yaagyenda kuwona I̱saka hamwei̱ na bahab̯u̱ri̱ baamwe, Ahu̱zaati̱ na Fi̱koli̱ nali mu̱handu̱ wa mahe gaamwe. ");
INSERT INTO rub_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","I̱saka yaabab̯u̱u̱li̱i̱rye naakoba yati, “Kyani ki̱baleti̱ri̱ hali gya, mwegi̱ri̱ kwahi nka ku̱mwannobi̱ri̱ mwambi̱nga mu nsi gyenyu̱?” ");
INSERT INTO rub_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Baamwi̱ri̱ri̱mwo nibakoba yati, “Tu̱nanu̱ki̱i̱ri̱ ki̱mwei̱ nti, Mukama ali hamwei̱ nawe. Leka tukore ndagaanu nawe, ");
INSERT INTO rub_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","kiragirize nka kwotalituhuutaaza, kubba tutakakukwateho rundi kukukoraho kabii kensei̱ bei̱tu̱ birungi bisa, twakulekera b̯u̱si̱nge. Oli weewe wa Mukama aheeri̱ mu̱gi̱sa.” ");
INSERT INTO rub_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Nahab̯waki̱kyo, I̱saka yaabakoleeri̱ B̯u̱genyi̱, baadya kandi banywa. ");
INSERT INTO rub_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","B̯wi̱re b̯u̱b̯wakeeri̱ mwakya karei, baabyoki̱ri̱ barahirangana kasi I̱saka yaabaraga baamurugaho, baagyenda na b̯u̱si̱nge. ");
INSERT INTO rub_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Kiro ki̱kyo ki̱mwei̱, baheereza bʼI̱saka bei̱zi̱ri̱ baamuweera bigambu bikukwatagana nei̱zu̱ba libaali bembi̱ri̱, nibakoba yati, “Meezi̱ tu̱gagi̱i̱rye.” ");
INSERT INTO rub_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Kyokyo I̱saka yaalyeti̱ri̱ Si̱bba: kyokyo de rub̯uga lu̱lwo balweta Bbeeri̱-sebba kudwa na deeru. ");
INSERT INTO rub_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esau̱ b̯u̱yaadooseerye myaka maku̱mi̱ ganei mya b̯u̱handu̱, yaatunga mu̱kali̱ gibakweta Yu̱di̱ta akubyalwa Bbeeri̱ Mu̱hi̱i̱ti̱, kasi yei̱ra yaatunga wondi gibakweta Bbasemaasi̱, akubyalwa Eroni̱ Mu̱hi̱i̱ti̱. ");
INSERT INTO rub_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ki̱kyo kyasaali̱i̱ze I̱saka na Rebbeeka. ");
INSERT INTO rub_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","I̱saka b̯u̱yaagu̱lu̱u̱si̱ri̱, yaahwi̱sa yaalekaho kuwona. Kasi yeeta Esau̱ mu̱tabani̱ waamwe mu̱handu̱ naakoba yati, “Esau̱.” Esau̱ yeeteb̯u̱ki̱ri̱ naakoba yati, “Bbaabba.” ");
INSERT INTO rub_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","I̱saka yaamuweera naakoba yati, “Mwana wange ngu̱lu̱u̱si̱ri̱, ti̱nyeegi̱ri̱ kiro kindikweramwo. ");
INSERT INTO rub_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Kwata byaku̱hi̱i̱gi̱sya, byaku̱lwani̱sya, nsahu na b̯uta b̯wamu, gyenda ompigireyo kisolo. ");
INSERT INTO rub_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Onti̱mbi̱re bidyo bi̱nolu̱, bi̱nyendya, onseegeerye ndye, aleke nkuhe mu̱gi̱sa ntakakwi̱ri̱.” ");
INSERT INTO rub_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Mu kasu̱mi̱ kakwo, I̱saka b̯uyaali nakubaza na mu̱tabani̱ waamwe Esau̱, Rebbeeka yaali naakwetegeerya. Esau̱ b̯u̱yaagyendi̱ri̱ ku̱hi̱i̱ga mwirungu aleke aleete nnyama, ");
INSERT INTO rub_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebbeeka yaasi̱geeri̱ yaaweera mu̱tabani̱ waamwe Yakobbo naakoba yati, “Nyeegwi̱ri̱ Bbaawu nakuweera weenyu̱ Esau̱ naakoba yati, ");
INSERT INTO rub_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Ndeterayo nnyama onti̱mbi̱re bidyo bi̱nolu̱ ndye, aleke nkusabire mu̱gi̱sa kuruga hali Mukama ntakakwi̱ri̱.’ ");
INSERT INTO rub_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Hati̱ nu mwana wange nzegwa, kandi okore kinkukuweera. ");
INSERT INTO rub_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Gyenda mwigana lya mbu̱li̱ ondetereyo mbu̱li̱ ibiri zito zirungi nzi̱ti̱mbi̱re bbaawu adye, nka kwakwendya. ");
INSERT INTO rub_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Omu̱segereerye adye, aleke akusabire mu̱gi̱sa atakakwi̱ri̱.” ");
INSERT INTO rub_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Bei̱tu̱ Yakobbo yei̱ri̱ri̱mwo mmaawe naakoba yati, “Weetu̱ Esau̱ kaali na byoza ku mubiri, gya gwange gwicala gu̱tereeru̱. ");
INSERT INTO rub_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Bbaabba yaakangazagaza akanzagya ntali na byoza akwi̱za kwega mmu̱gobeerye, nkubba nyeeleteeri̱ mukyeno mu kiikaru kya mu̱gi̱sa.” ");
INSERT INTO rub_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Mmaawe yaamwi̱ri̱ri̱mwo naakoba yati, “Mwana wange, leka mukyenu gwamu gubbe hali gya. Ki̱handu̱ kora ki̱nku̱wereeri̱, ondetereyo mbu̱li̱.” ");
INSERT INTO rub_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Nahab̯waki̱kyo, Yakobbo yaagyendi̱ri̱ yaaleetera mmaawe nyama, yaati̱mbi̱ri̱ yaasegeerya I̱saka yaadya bidyo bi̱ku̱nola, nka ku̱yendyengi̱. ");
INSERT INTO rub_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Nahab̯waki̱kyo, Rebbeeka yaagyendi̱ri̱ yaaleeta bilwalu bikukirayo b̯urungi bya mu̱tabani̱ waamwe mu̱handu̱ Esau̱ biyaali abi̱i̱ki̱ri̱, yaabi̱lwalya Yakobbo mu̱tabani̱ waamwe muto. ");
INSERT INTO rub_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Yaamu̱lwali̱i̱rye kikuta kya mbu̱li̱ mu mikono na mwi̱coti̱ ha byoza bitali. ");
INSERT INTO rub_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Yaamu̱kwatya bidyo birungi na migati biyaali ati̱mbi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yakobbo yaagyendi̱ri̱ hali bbaawe yaamweta naakoba yati, “Bbaabba” Bbaawe yei̱ri̱ri̱mwo naakoba yati, “Ndi haha mwanange, weewe naani?” ");
INSERT INTO rub_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakobbo yei̱ri̱ri̱mwo bbaawe naakoba yati, “Gyagya Esau̱ mu̱zegei̱zo waamu, nkoori̱ ki̱wandagi̱i̱ri̱ nkore, icaara odye nyama gi̱mpi̱gi̱ri̱, aleke onsabi̱re mu̱gi̱sa.” ");
INSERT INTO rub_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Bei̱tu̱ I̱saka yaab̯u̱u̱li̱i̱rye mu̱tabani̱ naakoba yati, “Mwanange, kisolo okyagi̱i̱rye teetei̱ wangu wangu yatyo?” Yakobbo yaamwi̱ramwo naakoba yati, “Hab̯wakubba Mukama Ruhanga waamu ampeeri̱ mu̱gi̱sa.” ");
INSERT INTO rub_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Kasi I̱saka yaaweera Yakobbo naakoba yati, “Banza weesegya heehi̱ nkukwateho aleke nkwetegereze nka kwoli weewe mwana wange Esau̱.” ");
INSERT INTO rub_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yakobbo yeesegeerye heehi̱ na bbaawe, I̱saka, yaamu̱kwatakwata, naakoba yati, “Iraka lya Yakobbo, bei̱tu̱ kandi mikono myʼEsau̱.” ");
INSERT INTO rub_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Nahaahwo, atakamulengere kubba mikono myamwe myaliho kikuta nkʼEsau̱ waab̯u, kasi yaamuha mu̱gi̱sa. ");
INSERT INTO rub_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","I̱saka yaamu̱b̯u̱u̱li̱i̱rye naakoba yati, “Kwo mali̱ oli weewe mu̱tabani̱ wange Esau̱?” Yakobbo yaamwi̱ri̱ri̱mwo naakoba yati, “Ndi gyagya.” ");
INSERT INTO rub_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Bbaawe yaagyendi̱ri̱ mu mei̱so yaamuweera naakoba yati. “Nsegeerya heehi̱ aleke ndye ha mu̱hi̱i̱go gwamu, kwokwo nkuhe mu̱gi̱sa.” Yakobbo yaagu̱mu̱leteeri̱, yaadya yaamuha na maaci yanywa. ");
INSERT INTO rub_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Kasi mwomwo bbaawe I̱saka yaamuweera naakoba yati, “Weesegya heehi̱, mwana wange, onywegere.” ");
INSERT INTO rub_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Nahab̯waki̱kyo Yakobbo yeesegeerye hali bbaawe yaamu̱nywegera, I̱saka yeegwi̱ri̱ ku̱hu̱nya kwa bilwalu bya mwana waamwe, yaamusabira mu̱gi̱sa naakoba yati, “Ku̱hu̱nya kwa mwana wange, kuli nka kwa musiri gwa Mukama aheeri̱ mu̱gi̱sa! ");
INSERT INTO rub_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Leka Ruhanga akugumire ndagali̱ na lu̱me kuruga mwiguru, kandi akuhe na b̯u̱gu̱u̱da, bidyo na byakunywa binene biruga mu nsi. ");
INSERT INTO rub_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Leka mahanga gakuheerezenge, bantu nibakutamwo ki̱ti̱i̱ni̱sa, waalemanga beenyu̱ bensei̱, kandi na baana ba mmaawu bali̱ku̱ku̱ndi̱ra malu̱ nibakutamwo ki̱ti̱i̱ni̱sa. Mukyenu gu̱bbenge hali yogwo yensei̱ yaakukyenanga, na mu̱gi̱sa hali yogwo yensei̱ yaakuhanga mu̱gi̱sa!” ");
INSERT INTO rub_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","I̱saka b̯u̱yaamaari̱ kuha Yakobbo mu̱gi̱sa, Yakobbo naacakarugaho mu mei̱so ga bbaawe, hooho Esau̱ yaadwereeri̱ kuruga mu mu̱hi̱i̱go gwamwe. ");
INSERT INTO rub_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Esau̱ de yaati̱mbi̱ri̱ bidyo bi̱nolu̱, yaabi̱segereerya bbaawe yaakoba yati, “Bbaabba, byoka odye ha mu̱hi̱i̱go gwange aleke ompe mu̱gi̱sa.” ");
INSERT INTO rub_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Bbaawe I̱saka yaamu̱b̯u̱u̱li̱i̱rye naakoba yati, “We oli naani?” Esau̱ yaamwi̱ri̱ri̱mwo naakoba “Ndi gyagya Esau̱, mu̱tabani̱ waamu mu̱zeegeezo.” ");
INSERT INTO rub_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Nahab̯waki̱kyo, I̱saka yei̱ru̱ndu̱kiri̱ yaab̯u̱u̱lya naakoba yati, “Naani kandi mu̱nyaku̱hi̱i̱ga kisolo akandetera nyama nyaadya uwe otakei̱zi̱ri̱ nyamu̱ha mu̱gi̱sa, kandi kwo agu̱tu̱ngi̱ri̱.” ");
INSERT INTO rub_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esau̱ b̯u̱yeegwi̱ri̱ bigambu bya bbaawe yaamu̱weereeri̱, yaataagi̱ri̱ neiraka lya hakyendi̱ yaalira naakoba yati, “Beiraba bbaabba nagya hakiri mpaho mu̱gi̱sa!” ");
INSERT INTO rub_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Bei̱tu̱ bbaawe yaamwi̱ri̱ri̱mwo naakoba yati, “Weenyu̱ ei̱zi̱ri̱ haha yangobyagobya, mu̱gi̱sa gwamu agu̱tweri̱.” ");
INSERT INTO rub_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esau̱ yei̱ri̱ri̱mwo naakoba yati, “Weetu̱ akusemeera kweteb̯wa Yakobbo, kubba yaakanziba mirundi mibiri, yaatweri̱ mugab̯u gwange gwa b̯ugwete nka mu̱zegei̱zo kandi hataati̱ antoori̱ho mu̱gi̱sa gwange.” Esau̱ yei̱ri̱ri̱ yaab̯u̱u̱lya bbaawe yati, “Toli na mu̱gi̱sa gundi gwensei̱ gwonti̱gi̱i̱ri̱ho mali̱?” ");
INSERT INTO rub_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","I̱saka yei̱ri̱ri̱mwo Esau̱ naakoba yati, “Nyamu̱teeri̱ kadei abbe mukama waamu, na banyaruganda bensei̱ bamuheerezenge, mmu̱heeri̱ byakudya na byakunywa. Mwana wange hataati̱ nkukolere kyani?” ");
INSERT INTO rub_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau̱ yei̱ri̱ri̱mwo naakoba yati, “Bbaabba, olina mu̱gi̱sa gwogwo gu̱mwei̱ gusa mali̱? Beiraba bbaabba nagya mpaho mu̱gi̱sa.” Nahahwo Esau̱ yaatamwo kizabiro. ");
INSERT INTO rub_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Nahab̯waki̱kyo, bbaawe I̱saka yaamwi̱ri̱ri̱mwo naakoba yati, “Okwi̱zanga kwicala mu nsi gi̱teerya bidyo kandi gitagira ndagali̱ na lu̱me biruga mwiguru. ");
INSERT INTO rub_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Oliicala nolindwanga mpirima gyamu, nooheerezanga weenyu̱, woolilwana okasi̱ngu̱ra mwomwo olyetolaho kijumo kya b̯wiru.” ");
INSERT INTO rub_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau̱ yaanobi̱ri̱ Yakobbo hab̯wa kumutoolaho mu̱gi̱sa gunyakubba niguli gwamwe. Yaabazi̱ri̱ yankei naakoba yati, “Bbaabba ali heehi̱ ku̱kwa. B̯utwakamala kumuziika ni̱nzi̱ta weetu̱.” ");
INSERT INTO rub_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Muntu wondi yaaweereeri̱ Rebbeeka bigambu bya mu̱tabani̱ waamwe mu̱handu̱ Esau̱ yaabazi̱ri̱. Nahab̯waki̱kyo yaatu̱mi̱si̱i̱rye bamwetere Yakobbo mu̱tabani̱ waamwe muto. Yaamuweera naakoba yati, “Weenyu̱ Esau̱ akutegeka ku̱kwi̱ta, hab̯wa ki̱kyo ki̱wamu̱koori̱. ");
INSERT INTO rub_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Weegwa hati̱ kinkukuweera mu̱tabani̱ wange, byoka oi̱ru̱ke ogyenda hali weetu̱ Labbani̱ mu Harani̱. ");
INSERT INTO rub_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Oicale nayo hab̯wa kei̱re ku̱doosya ki̱ni̱ga kya weenyu̱ Esau̱ b̯ukilimalika. ");
INSERT INTO rub_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Asobore kwebeera ki̱wamu̱koori̱. Hei̱nyu̱ma, nkwi̱za kukutumira baku̱syomeyo kuruga Harani̱, kubba nkwendya kwahi kufeerwa batabani̱ bange babiri mu kiro ki̱mwei̱.” ");
INSERT INTO rub_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Mwomwo Rebbeeka yaaweera I̱saka naakoba yati, “Ntami̱i̱rwe ki̱mwei̱ kwicala na bakali̱ Bahi̱i̱ti̱, hakiri nkwa Yakobbo kutunga mu̱kali̱ Mu̱hi̱i̱ti̱ nka yogwo.” ");
INSERT INTO rub_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","I̱saka yeeti̱ri̱ Yakobbo yaamuha mu̱gi̱sa, yaamu̱terereeri̱ yaakoba yati, “Otali̱geryaho kutunga mu̱kali̱ Mu̱kanani̱. ");
INSERT INTO rub_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Byoka ogyende Padanaramu kumwangweteb̯u, mu nnyu̱mba gya Bbeesweri̱ hahaahu̱, hooho otunge mu̱kali̱, omwei̱ hali bahara ba ngweteeu̱ Labbani̱. ");
INSERT INTO rub_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Leka Ruhanga Waamaani Gensei̱ akuhe mu̱gi̱sa, kandi aku̱kanyi̱sye aleke ofooke bbaa mahanga ganene. ");
INSERT INTO rub_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Leka abahe mu̱gi̱sa, we na beizukulu baamu, nka ku̱yaagu̱heeri̱ I̱bbu̱rahi̱mu̱. Leka mutunge nsi gya kwicalamwo gya Ruhanga yeeragi̱ri̱ kuha I̱bbu̱rahi̱mu̱!” ");
INSERT INTO rub_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","I̱saka kwokwo yatyo yaasi̱ndi̱ki̱ri̱ Yakobbo, agyende Padanaramu wu Labbani̱ mu̱tabani̱ wa Bbeesweri̱, Mu̱raami̱i̱ni̱. Labbani̱ yaali waab̯u Rebbeeka, maa Yakobbo na Esau̱. ");
INSERT INTO rub_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esau̱ yeetegeri̱i̱ze nti I̱saka yaaheeri̱ Yakobbo mu̱gi̱sa, kandi yaamu̱tu̱ma Padanaramu aswereyo mu̱kali̱, yaamuragira naakoba yati, “Otalitunga mu̱kali̱ Mu̱nyakanani̱.” ");
INSERT INTO rub_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Esau̱ yeetegeri̱i̱ze Yakobbo nka ku̱yeegwi̱ri̱ bigambu bya bbaawe na mmaawe, yaagyenda Padanaramu. ");
INSERT INTO rub_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Esau̱ b̯u̱yeetegeri̱i̱ze bbaawe nka kwatakwendya bakali̱ Bakanani̱, ");
INSERT INTO rub_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","nahab̯waki̱kyo yaagyendi̱ri̱ yaatunga mu̱kali̱ gibakweta Maharaati̱, nyaakaab̯u Nebayoosi̱. Maharaati̱ yaali muhara wʼI̱si̱mai̱ri̱, mu̱tabani̱ wʼI̱bbu̱rahi̱mu̱. Esau̱ b̯u̱yaatu̱ngi̱ri̱ Maharaati̱, bakali̱ baamwe Bakanani̱ nabo yaabasi̱gali̱i̱sya. ");
INSERT INTO rub_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yakobbo yaaru̱gi̱ri̱ Bbeeri̱-sebba yaagyenda Harani̱. ");
INSERT INTO rub_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Yaadwa mu kiikaru ki̱mwei̱, hooho yaaleeri̱ kiro ki̱kyo, kubba b̯wi̱re b̯walingi b̯u̱sweki̱ri̱, yaagi̱i̱rye i̱hi̱ga yaalyesagu̱ra, yeebbaka. ");
INSERT INTO rub_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Yaaloota, mu kilooto, yaaweeni̱ madaara gasimbe hansi kudwa mwiguru. Bamalayika ba Ruhanga baatembengi̱ hakyendi̱ wa madaara nibeera ni̱bagasi̱ri̱mu̱ki̱raho. ");
INSERT INTO rub_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Yaawona Mukama yeemereeri̱ hakyendi̱ wa madaara, yaakoba yati, “Gyagya Mukama Ruhanga wʼI̱bbu̱rahi̱mu̱ hahaahu̱ kandi Ruhanga wa I̱saka, nkwi̱za kukuha nsi gi̱gyo cali oleeri̱, ngihe na beizukulu baamu. ");
INSERT INTO rub_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Beizukulu baamu, balijana nka musinyi mu̱li̱kanya kudwa B̯ugwalyoba na b̯uhulukalyoba, matemba na masi̱ri̱mu̱ka, muli we na beizukulu baamu, nganda zensei̱ za mu nsi, hooho zilitungira mu̱gi̱sa. ");
INSERT INTO rub_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Weege nka nkundi hamwei̱ nawe kandi nyakulindanga hawakagyendanga hensei̱, ndi̱kwi̱rya mu nsi gigi, hab̯wakubba tindikuleka ntakadosereerye ki̱nku̱ragani̱si̱i̱rye.” ");
INSERT INTO rub_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yakobbo yaasi̱si̱mu̱ki̱ri̱, yaakoba yati, “Mananu kwo, Mukama hali mu kiki kiikaru, ki̱kyo nceeri̱ ntakyegi̱ri̱.” ");
INSERT INTO rub_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Yaati̱i̱ni̱ri̱ kandi yaakoba yati, “Kiikaru kiki, ka ki̱ku̱ti̱i̱ni̱sya! Tikili nka kya b̯ukyeb̯ukye, gyogyo nnyu̱mba gya Ruhanga, kandi gugu gwogwo mulyangu gwa iguru.” ");
INSERT INTO rub_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Yakobbo b̯u̱yaabyoki̱ri̱ mwakya karei, yaakweti̱ i̱hi̱ga linyakubba ha mu̱twe gwamwe yaalifoora nkondo, yali̱bbwomi̱ri̱ho maku̱ta aleke kibbe ki̱zu̱kyo. ");
INSERT INTO rub_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Kiikaru ki̱kyo, yaakyeti̱ri̱ ibara lyakyo Bbeseeri̱, bei̱tu̱ mu kutandika lu̱lwo rub̯uga lwetebwengi̱ Lu̱u̱zi̱. ");
INSERT INTO rub_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Nahahwo Yakobbo yeeragani̱si̱i̱rye naakoba yati, “Mu lugyendu lundimwo, kakubba Ruhanga abba nagya kandi akandinda, akampa byakudya na byakulwala, ");
INSERT INTO rub_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","nkei̱ra kwamu̱gi̱ na b̯u̱si̱nge, kasi mwomwo Mukama alibba Ruhanga wange. ");
INSERT INTO rub_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Kandi i̱hi̱ga nyali̱si̱mbi̱ri̱ kubba ki̱zu̱kyo, lyabbanga nnyu̱mba gya Ruhanga, kandi hali b̯uli kya Ruhanga ompeeri̱ nyakuhangaho ki̱mwei̱ kyei̱ku̱mi̱.” ");
INSERT INTO rub_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Nahahwo Yakobbo yeeyongeeri̱ mu mei̱so na lub̯ungo, yaadwa mu nsi gya bantu ba mu b̯uhulukalyoba. ");
INSERT INTO rub_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","B̯u̱yaamagamagi̱ri̱, yaawona i̱zu̱ba mu ki̱kyo kiikaru na magana gasatu ga ntaama galeeri̱ heehi̱ nei̱zu̱ba li̱lyo, hab̯wakubba, hei̱zu̱ba li̱lyo, hooho magana ga ntaama ganywerengi meezi̱. Ha mu̱nwa gwei̱zu̱ba li̱lyo, haalingiho i̱hi̱ga likooto. ");
INSERT INTO rub_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","B̯uli magana gaakecookanga, bali̱i̱sya baateekwengi̱ kubanza kubiringitya i̱hi̱ga nibalitoola ha mu̱nwa gwei̱zu̱ba, aleke magana gasobore kunywa meezi̱, hei̱nyu̱ma kasi ni̱bali̱i̱ryaho. ");
INSERT INTO rub_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakobbo yaab̯u̱u̱li̱i̱rye bali̱i̱sya naakoba yati, “Banywani bange, mukuruga hanya?” Baamwi̱ri̱ri̱mwo nibakoba, “Natwedede tuli bei̱cali̱ ba Harani̱.” ");
INSERT INTO rub_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Yei̱ri̱ri̱ yaabab̯u̱u̱lya yati, “Labbani̱ mwizukulu wa Nahoori̱ mukumwega?” Baamwi̱ri̱ri̱mwo nibakoba yati, “Ee tu̱mwegi̱ri̱.” ");
INSERT INTO rub_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Yakobbo yaabab̯u̱u̱lya naakoba yati, “Yo ali̱yo teetei̱?” Baamwi̱ri̱ri̱mwo nibakoba nti, “Ali̱yo kurungi, na muhara waamwe Lakeeri̱ ngogwo ali̱mu̱kwi̱za na ntaama!” ");
INSERT INTO rub_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yaakoba yaabaweera, “B̯wi̱re kab̯ucaali b̯wa karei kwi̱rya magana kwamu̱gi̱, mu̱zi̱he meezi̱ zinywe aleke zi̱i̱reyo kudya.” ");
INSERT INTO rub_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Baamwi̱ri̱ri̱mwo nibakoba yati, “Ki̱kyo tikikusoboka ku̱doosya magana ga ntaama gensei̱ gaakei̱za haha, nitutoolaho i̱hi̱ga ku mu̱nwa gwei̱zu̱ba, aleke zensei̱ zinywe.” ");
INSERT INTO rub_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","B̯uyaali naacakabaza nabo, Lakeeri̱ yei̱zi̱ri̱ na ntaama za bbaawe, kubba yaali mu̱li̱i̱sya waazo. ");
INSERT INTO rub_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yakobbo b̯u̱yaaweeni̱ Lakeeri̱ naali na ntaama za ngweteeb̯we Labbani̱, yaagyenda yaabi̱ri̱ngi̱tya i̱hi̱ga, yaalitoola ha mu̱nwa gwei̱zu̱ba, yaaha ntaama za ngweteeb̯we Labbani̱ meezi̱ gakunywa. ");
INSERT INTO rub_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Kasi Yakobbo yanywegera Lakeeri̱ kandi yaalira hab̯wa kusemererwa kunene. ");
INSERT INTO rub_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Nahaahwo, Yakobbo yaali aweereeri̱ Lakeeri̱, nka kwali na b̯ubyalisanwa na bbaawe, kandi nka kwali mu̱tabani̱ wa Rebbeeka. Kasi Lakeeri̱ yei̱ru̱ka yaaweera bbaawe. ");
INSERT INTO rub_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Labbani̱ b̯u̱yeegwi̱ri̱ bigambo bikukwatagana na Yakobbo nka mwi̱b̯wa waamwe, yei̱ru̱ki̱ri̱ yaamu̱tangi̱i̱ra, yaamugwa mu salaka yaamu̱nywegera, yaamutwala kwamu̱gi̱. Yakobbo yaasoboora Labbani̱ binyakubbaho byensei̱. ");
INSERT INTO rub_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Mwomwo Labbani̱ yaamuweera naakoba yati, “Mu mananu oli mwana wange kwo wa mulula.” Nahab̯waki̱kyo, Labbani̱ yei̱ceeri̱ na Yakobbo kumala mweri̱ gu̱mwei̱. ");
INSERT INTO rub_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Kasi Labbani̱ yaaweera Yakobbo naakoba yati, “Tosemereeri̱ kukolera b̯usa, kubba nti, oli munyaruganda wange. Mbwera okwendya nkusasule mpeera gikwijana hanya?” ");
INSERT INTO rub_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Mu kasu̱mi̱ kakwo, Labbani̱ yaalingi na bahara baamwe babiri, ibara lya mu̱handu̱, yooyo Leeya, kandi muto, yooyo Lakeeri̱. ");
INSERT INTO rub_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leeya yaali atali murungi ha mei̱so, bei̱tu̱ Lakeeri̱ yaali naali murungi kandi akuzooka. ");
INSERT INTO rub_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakobbo yendeerye Lakeeri̱, yaaweera Labbani̱ naakoba yati, “Nkwi̱za kukuheereza kumala myaka musanju, aleke ntunge muhara waamu Lakeeri̱.” ");
INSERT INTO rub_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Labbani̱ yaakoba yati, “Kirungi, we kumutunga kukira kumuha muntu wondi yooyo amutunge. Icala haha onkolere.” ");
INSERT INTO rub_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Nahahwo Yakobbo yaaheereza Labbani̱ kumala myaka musanju aleke atunge Lakeeri̱, myaka mi̱myo myamu̱hwani̱i̱ri̱ nka biro bi̱dooli̱, kubba yendyengi̱ hoi̱ Lakeeri̱. ");
INSERT INTO rub_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Kasi Yakobbo yaaweera Labbani̱ naakoba yati, “Mu̱kali̱ wange mu̱mpe. Kasu̱mi̱ ka twarageeni̱ kukukolera kamali̱ki̱ri̱.” ");
INSERT INTO rub_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Nahab̯waki̱kyo, Labbani̱ yeeti̱ri̱ bantu bensei̱ baamu̱ki̱kyo kicweka, nyaabakoora B̯u̱genyi̱ b̯ukooto. ");
INSERT INTO rub_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Bei̱tu̱ mu b̯wi̱re b̯wei̱jolo, Labbani̱ yaaleeti̱ri̱ muhara waamwe Leeya na mu nsita, yaamuha Yakobbo. Yakobbo yaamutunga nka mu̱kalwe. ");
INSERT INTO rub_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(Labbani̱ yaaheeri̱yo Zi̱ri̱pa hali muhara waamwe Leeya aleke amuheerezenge.) ");
INSERT INTO rub_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Mu b̯wi̱re b̯wa mwakya karei, Yakobbo yaagyendi̱ri̱ kuwona mu̱kali̱ gi̱yaagab̯wiri yeezagi̱i̱rye nali Leeya, kasi yaab̯u̱u̱lya Labbani̱ naakoba yati, “Onkoori̱ bya teetei̱? Nyaaku̱kolerengi̱ hab̯wa kutunga Lakeeri̱? Hab̯waki wangobeerye?” ");
INSERT INTO rub_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Labbani̱ yei̱ri̱ri̱mwo naakoba yati, “Mwihanga lyetu̱, muhara mu̱handu̱ yooyo abanza kutungwa. ");
INSERT INTO rub_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Bei̱tu̱ wakamala biro musanju hamwei̱ na Leeya, na Lakeeri̱ tukumukuha omutunge. Bei̱tu̱ olinakwongera kunkoora hab̯wa myaka mindi musanju.” ");
INSERT INTO rub_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakobbo kwokwo yaakakoori̱, yaamala na Leeya sabbi̱i̱ti̱ gi̱mwei̱, Labbani̱ yeikiriza Yakobbo kutunga Lakeeri̱. ");
INSERT INTO rub_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(Labbani̱ yaaheeri̱yo Bbi̱li̱ha hali muhara waamwe Lakeeri̱ aleke amuheerezenge.) ");
INSERT INTO rub_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Nahaahwo, Yakobbo yaatu̱ngi̱ri̱ Lakeeri̱, yaamwendya kukiraho Leeya, yaakoleeri̱ Labbani̱ hab̯wa myaka mindi musanju. ");
INSERT INTO rub_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Mukama b̯u̱yaaweeni̱ Leeya naali kinobe, yaamuha lubyalu, bei̱tu̱ Lakeeri̱, yeicala naali ngumba. ");
INSERT INTO rub_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leeya yeemeti̱ri̱, yaabyala mwana wa b̯udulu, yaamweta ibara Lu̱bbeeni̱. Yaakoba yati, “Mukama antoori̱ho b̯ujune. Hataati̱ ibange akugyenda kungonza.” ");
INSERT INTO rub_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Yei̱ri̱ri̱ yeemeta, yaabyala mwana, kandi yaakoba yati, “Mukama yeegi̱ri̱ nka ku̱bannobi̱ri̱, ampeeri̱ mwana yogo de.” Kasi yaamweta Si̱myoni̱. ");
INSERT INTO rub_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Yeeri̱ri̱ yeemeta, yaabyala mwana wa b̯udulu, yaakoba yati, “Hataati̱ ibange akugyenda kubba heehi̱ nagya, hab̯wakubba nyakamubyalira baana ba b̯udulu basatu.” Kasi yaamweta ibara Leevi̱. ");
INSERT INTO rub_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Yei̱ri̱ri̱ yeemeta nda gindi, yaabyala mwana wa mudulu, yaakoba yati, “Deeru na lulu nkugyenda kuhaariiza Mukama.” Kasi yaamweta ibara Yu̱da. Leeya lubyalu lwabanza lwekinga. ");
INSERT INTO rub_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Lakeeri̱ b̯u̱yaaweeni̱ alemeerwe kubyalira Yakobbo mwana, yaakwati̱i̱rwe nyaakaab̯u i̱hali̱, yaaweera Yakobbo naakoba yati, “Mbyalira baana, kitali ki̱kyo nsobora ku̱kwa.” ");
INSERT INTO rub_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yakobbo yaabi̱hi̱ri̱i̱rwe Lakeeri̱, Yakobbo yaamwi̱ramwo naakoba yati, “Gya ndi Ruhanga agaba lubyalu?” ");
INSERT INTO rub_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Kasi Lakeeri̱ yaakoba yati, “Muzaana wange Bbi̱li̱ha ngogwoyo, mutunge, ambyalire, aleke nagya nyakubbagana na baana.” ");
INSERT INTO rub_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Nahaahwo, Lakeeri̱ yaaheeri̱ Yakobbo muzaana waamwe Bbi̱li̱ha, Yakobbo yaani̱i̱na ntabbu gyamwe. ");
INSERT INTO rub_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bbi̱li̱ha yeemeta nda, yaabyalira Yakobbo mwana wa mudulu. ");
INSERT INTO rub_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Kasi Lakeeri̱ yaakoba yati, “Ruhanga aweeni̱ mananu gange, kandi yanzegwa ampeeri̱ mwana.” Kasi yaamweta ibara Daani̱. ");
INSERT INTO rub_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bbi̱li̱ha yeemeti̱ri̱ nda gindi, yaabyalira Yakobbo mwana wakabiri wa b̯udulu. ");
INSERT INTO rub_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Lakeeri̱ yaakoba yati, “Ncwi̱ri̱ magezi̱ gensei̱ gaku̱lwani̱sya nyakeetu̱ kandi mu̱si̱ngwi̱ri̱.” Mwana yogwo, yaamweta ibara Nafutaali. ");
INSERT INTO rub_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Leeya b̯u̱yaaweeni̱ nka kwakangi̱i̱ri̱ haahwo kubyala, na yo yaakwata muheereza waamwe Zi̱ri̱pa, yaamuha Yakobbo amutunge. ");
INSERT INTO rub_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Zi̱ri̱pa yaabyala Yakobbo mwana wa b̯udulu. ");
INSERT INTO rub_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Leeya yaakoba yati, “Kakya mu̱gi̱sa.” Kasi yaamweta ibara Gaadi̱. ");
INSERT INTO rub_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Zi̱ri̱pa yaabyalira Yakobbo mwana wa b̯udulu wa kabiri, ");
INSERT INTO rub_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","kandi Leeya yaakoba yati, “Kansemereerwe! Bakali̱ banzetanga kusemererwa.” Kasi yaamweta ibara Aseeri̱. ");
INSERT INTO rub_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Kaali kasu̱mi̱ ka kukesa kwa nganu, Lu̱bbeeni̱ yaatura mu musiri, yaagyayo bimera bibakweta mandu̱reeki̱, yaabileetera mmaawe, Leeya. Lakeeri̱ yaasaba Leeya naakoba yati, “Nku̱kwesengereerya, mpaho mandu̱reeki̱ za mu̱tabani̱ waamu yaaku̱leteeri̱.” ");
INSERT INTO rub_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Bei̱tu̱ Leeya yei̱ri̱ri̱mwo Lakeeri̱ naakoba yati, “Ontoori̱ho ibange, ki̱kyo kyabba kibiibi hoi̱. Hataati̱ okwendya na kutwala mandu̱reeki̱ za mu̱tabani̱ wange?” Lakeeri̱ yaamwi̱ramwo naakoba yati, “Kale, mpa mandu̱reeki̱ mukulekere alaale nawe i̱jolo lya deeru.” ");
INSERT INTO rub_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Yakobbo b̯u̱yaaru̱gi̱ri̱ mu musiri joojolo, Leeya yaabyoka kumutangiira, yaakoba yati, “Kiro kiki olina kulaala nagya, hab̯wakubba nku̱gu̱u̱ri̱ na mandu̱reeki̱ za mu̱tabani̱ wange.” Kiro ki̱kyo, Yakobbo yaaleeri̱ na Leeya. ");
INSERT INTO rub_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Ruhanga yeegwi̱ri̱ kusaba kwa Leeya, yeemeta, yaabyalira Yakobbo mwana wakataanu. ");
INSERT INTO rub_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Kasi Leeya yaakoba yati, “Ruhanga ansasu̱u̱ri̱ hab̯wa kuhayo muheereza wange hali ibange amutunge.” Kasi yaamweta ibara I̱saakaari̱. ");
INSERT INTO rub_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Leeya yaab̯u̱ni̱i̱rye yeemeta, yaabyalira Yakobbo mwana wamukaaga. ");
INSERT INTO rub_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Kasi mwomwo Leeya yaakoba yati, “Ruhanga ampeeri̱ kisembu kirungi, hataati̱ ibange, akumpa ki̱ti̱i̱ni̱sa, hab̯wakubba mmu̱byali̱i̱ri̱ baana mukaaga.” Kasi yaamweta ibara Zabbu̱looni̱. ");
INSERT INTO rub_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Hei̱nyu̱ma yaabyala wondi wa b̯uhala, yaamweta ibara Di̱na. ");
INSERT INTO rub_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Kasi Ruhanga yei̱zu̱ka kandi yeegwa Lakeeri̱, yaakingula nda gyamwe. ");
INSERT INTO rub_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Yeemeta yaabyala mwana kandi yaakoba yati, “Ruhanga antoori̱ho nsoni̱.” ");
INSERT INTO rub_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Mwana yogwo yaamweta ibara Yozefu̱, naakoba yati, “Kakubba Mukama ampa mwana wondi!” ");
INSERT INTO rub_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Lakeeri̱ b̯u̱yaamaari̱ kubyala Yozefu̱, Yakobbo yaasabi̱ri̱ Labbani̱ naakoba yati, “Mundeke nkubeyo kwamwetu̱ cali nyaaru̱gi̱ri̱, ");
INSERT INTO rub_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Mpa bakali̱ na baana bange banyakolereeri̱, aleke ngyende, hab̯wakubba, okwega kurungi milimo mi̱nku̱koleeri̱.” ");
INSERT INTO rub_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Bei̱tu̱ Labbani̱ yaamuweera naakoba yati, “Kambanze nkuweere kigambu ki̱mwei̱, ntu̱ngi̱ri̱ bintu binene, kandi Mukama ampeeri̱ mu̱gi̱sa hab̯wamu. ");
INSERT INTO rub_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Hataati̱ ncwera mpeera gyamu nkusasule.” ");
INSERT INTO rub_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakobbo yaamwi̱ri̱ri̱mwo naakoba yati, “Nawe wankei, okwega nka kunkukoleeri̱, nyalinda na magana gaamu kurungi. ");
INSERT INTO rub_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Hanyei̱zi̱i̱ri̱, itungu lyamu lyali li̱dooli̱, bei̱tu̱ hataati̱ li̱kanyi̱i̱ri̱ ki̱mwei̱. B̯uli b̯unkukolera, Mukama akuha mu̱gi̱sa. Bei̱tu̱ hataati̱ kali kei̱re kange kakukolera makaa gange.” ");
INSERT INTO rub_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Labbani̱ yaamu̱b̯u̱u̱li̱i̱rye naakoba yati, “Kyani kyokwendya nkuhe?” Yakobbo yaamwi̱ri̱ri̱mwo yati, “Ti̱nkwendya kintu kindi kyensei̱, bei̱tu̱ nkoora kintu ki̱mwei̱, gya nku̱li̱si̱i̱rye magana gaamu. ");
INSERT INTO rub_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Kandaberabemwo mu magana gaamu gensei̱, kandi ntoolemwo mwana gwa ntaama zensei̱ zi̱i̱ragu̱ru̱ na mbu̱li̱ zensei̱ kitanga zito. Gyogyo mpeera gi̱nkwendya gisa. ");
INSERT INTO rub_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Kasu̱mi̱ kakusasulwa b̯ukalidwa, mwomwo olyetegereza b̯wesigwa b̯wange. Okusobora kukebera ha bisolo byange henseenya ha waakendya. Nkwi̱za kubba na ntaama rundi mbu̱li̱ kitanga ku mibiri myazo, rundi b̯utaama b̯wi̱ragu̱ru̱. Kakubba onzagya na bisolo bindi byenseenya, onzete mwi̱bi̱.” ");
INSERT INTO rub_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Labbani̱ yei̱ri̱ri̱mwo naakoba yati, “Nzi̱ki̱ri̱i̱ze, leka kibbe nka kwokakobi̱ri̱.” ");
INSERT INTO rub_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Kiro ki̱kyo, Labbani̱ yaatoori̱mwo igana lya mbu̱li̱ zensei̱ kitanga, zi̱kali̱ na zidulu, hamwei̱ na b̯uli mwana gwa ntaama gi̱i̱ragu̱ru̱, yaazi̱kwatya batabani̱ baamwe bazi̱li̱i̱syenge. ");
INSERT INTO rub_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Labbani̱ yaasi̱ndi̱ki̱ri̱ magana gaamwe hadei. Kyakatwali̱i̱ri̱ Yakobbo biro bisatu kubadwereera. Ki̱kyo nikikukorwa, Yakobbo yaali kulinda bisolo bya Labbani̱ bindi. ");
INSERT INTO rub_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Yakobbo yaabi̱nyi̱ri̱ bi̱jangi̱ bya misaali mibakweta popu̱le, ali̱monda na Pu̱leeni̱, yaabihohonyola naati̱ganga nkaara zi̱syanu̱. ");
INSERT INTO rub_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Bi̱jangi̱ bi̱yaahohonyoori̱, yaabi̱si̱mbi̱ri̱ mu mei̱so ga kyoho ki̱zaanywerengi̱mwo meezi̱. Hooho magana geemeeryengi̱. ");
INSERT INTO rub_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Nahab̯waki̱kyo mbu̱li̱ na ntaama b̯u̱zaakemyanga zeemereeri̱ mu mei̱so ga bi̱jangi̱ bi̱byo, zaabyalengi̱ kitanga. ");
INSERT INTO rub_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yakobbo yaahu̱kani̱angi̱ ntaama na mbu̱li̱ kitanga zito neigana lya Labbani̱. Yaatwalengi̱ mbu̱li̱ na ntaama zi̱kali̱ za Labbani̱ zi̱si̱geeri̱ho zeeru̱u̱bye na kitanga rundi mu zi̱i̱ragu̱ru̱. Kwokwo yatyo yaakanyi̱i̱rye magana ge hab̯we. Yaahu̱kani̱a magana gaamwe na ga Labbani̱. ");
INSERT INTO rub_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Yakobbo yaakawonanga ntaama na mbu̱li̱ zaamwe zinyamaani zi̱haki̱ri̱, kasi naasimba bi̱byo bi̱jangi̱ mu mei̱so gaazo, heehi̱ na kyoho kikooto kya meezi̱ aleke zeeme zi̱li̱ngi̱ri̱i̱ri̱ bi̱byo bi̱jangi̱. ");
INSERT INTO rub_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Bei̱tu̱ haakabbangamwona ziceke, atakaziterengeho. Nahab̯waki̱kyo, ziceke mu zo zaagyendi̱ri̱ hali Labbani̱, ekandi zinyamaani zei̱rengi̱ hali Yakobbo. ");
INSERT INTO rub_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Mu mu̱li̱ngo nka gu̱gwo, kwokwo Yakobbo yaagu̱daheeri̱ yatyo, yaatunga magana ganene, baheereza, badulu na bakali̱, ngamira na ndogoyi̱. ");
INSERT INTO rub_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yakobbo yeegwi̱ri̱ batabani̱ ba Labbani̱ nibakubaza nibakoba yati, “Yakobbo agu̱daheeri̱ yaatyo hab̯wa itungu lya bbaabba li̱yaatweri̱.” ");
INSERT INTO rub_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Kindi Yakobbo yeetegeri̱i̱ze Labbani̱ nka kwataalinayo mukagu nka b̯u̱di̱. ");
INSERT INTO rub_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Kasi Mukama yaaweera Yakobbo naakoba yati, “Weemuka mu nsi gya kwamwenyu̱, mu banyaruganda baamu nyeicalanga hamwei̱ nawe.” ");
INSERT INTO rub_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Nahaahwo, Yakobbo yaatu̱mi̱ri̱ bamwetere Lakeeri̱ na Leeya, aleke barombere mwi̱li̱si̱i̱ryo hali magana gaamwe gaali. ");
INSERT INTO rub_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Kasi yaakoba yati, “Nkuwona bbaaweenyu̱ takyakangiira maku̱ni̱ nka b̯u̱di̱, bei̱tu̱ Ruhanga wa bbaabba tandu̱gi̱ri̱ho. ");
INSERT INTO rub_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Kandi mu̱kyegi̱ri̱ nka ku̱nkoleeri̱ bbaaweenyu̱ na maani gange gensei̱. ");
INSERT INTO rub_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Bbaaweenyu̱ anzi̱bi̱ri̱ mirundi minene. Mpeera gyange yaakagihindula mirundi i̱ku̱mi̱. Bei̱tu̱ Ruhanga atakamwikirize kumputaaza. ");
INSERT INTO rub_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Labbani̱ b̯u̱yaakakobanga yati, ‘Ndikusasula na magana ga rangi̱ zikwahukana ha mibiri.’ Magana gensei̱ gaabyalengi̱ b̯wana wa rangi̱ zikwahukana ha mibiri. B̯undi yaakakobanga yati, ‘Ndikusasula na zi̱byali̱i̱rwe nizili kitanga.’ Magana gensei̱ nigabyala b̯wana nib̯uli kitanga. ");
INSERT INTO rub_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Kwokwo yatyo Ruhanga yaatoori̱ho bbaaweenyu̱ magana gaamwe, yaaganzi̱ri̱i̱rya. ");
INSERT INTO rub_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","I̱jolo li̱mwei̱ nyaalooti̱ri̱. B̯wali b̯u̱su̱mi̱ b̯wa magana kwema. Mu kilooto, nyaaweeni̱ mbu̱li̱ zidulu nizili kitanga na za marangi̱ gakwahukana. ");
INSERT INTO rub_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Nahaahwo, malayika wa Ruhanga yambwereeri̱ na mu kilooto naakoba yati, ‘Yakobbo,’ nyei̱ramwo ninkoba yati, ‘Ndi haha!’ ");
INSERT INTO rub_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Malayika yaakoba yati, ‘Byokya mei̱so gaamu owone mbu̱li̱ zidulu zi̱kwemya, zili kitanga na za marangi̱ gakwahukana. Nkukusagika hab̯wakubba mbweni̱ bibiibi bya Labbani̱ aku̱koori̱. ");
INSERT INTO rub_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Gyagya Ruhanga wa Bbeseeri̱, cali waabbwomeri̱ nkondo gyei̱hi̱ga gya kwi̱zu̱kya maku̱ta kandi wandahirira. Nahab̯waki̱kyo byoka oruge mu gigi nsi, weemuke kwamwenyu̱.’ ” ");
INSERT INTO rub_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Kasi Lakeeri̱ na Leeya baaweera Yakobbo nibakoba yati, “Bbaaweetu̱ tali na kyalituha ku̱dooosya b̯wali̱kwa ");
INSERT INTO rub_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Hataati̱ akutuwona nka banyamahanga. Waamu̱kooleeri̱ na maani aleke otutunge nka bakalwo. Yaatwi̱bi̱ri̱ nawe yaakwi̱ba. ");
INSERT INTO rub_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Bintu byensei̱ Ruhanga bi̱yaatoori̱ho bbaaweetu̱, bi̱i̱ri̱ri̱ byetu̱ hamwei̱ na baana beetu̱, kyensei̱ kya Ruhanga ki̱yaaku̱ragi̱i̱ri̱ oki̱kole.” ");
INSERT INTO rub_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Nahaahwo, Yakobbo yaateeri̱ mu̱kalwe na baana baamwe ha ngamira, baasetuka. ");
INSERT INTO rub_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Yaatweri̱ igana lyamwei̱ neitungo lyamwe lyensei̱ liyaali nalyo mu Padanaramu, yaagyenda mu nsi gya Kanani̱ b̯u bbaawe I̱saka. ");
INSERT INTO rub_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Batakasetu̱ki̱ri̱ Labbani̱ yaagyendi̱ri̱ kusala byoza bya ntaama zaamwe. B̯uyaali ataloho Lakeeri̱ yeebi̱ri̱ baruhanga ba Labbani̱ yaaramyengi̱. ");
INSERT INTO rub_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yakobbo yaagobeerye Labbani̱, Mu̱raami̱i̱ni̱ atakamuhwetulire nka kwalimwo kwemuka. ");
INSERT INTO rub_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Yei̱ru̱ka na bintu byamwe byensei̱ biyaali nabyo, yambu̱ki̱ri̱ mugira Efu̱raati̱, yaagyenda ali̱ngi̱ri̱i̱ri̱ mu nsi za mu nsahu za Gi̱ryadi̱. ");
INSERT INTO rub_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Kiro kyakasatu Labbani̱ b̯u̱baamu̱weereeri̱ Yakobbo nka kwagyendi̱ri̱, ");
INSERT INTO rub_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Yaatweri̱ banyaruganda baamwe, baamuhondera hab̯wa biro musanju, batakamu̱kweti̱ mu nsi gya nsahu za Gi̱ryadi̱. ");
INSERT INTO rub_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Bei̱tu̱ mu b̯wi̱re b̯wei̱jolo, Ruhanga yeezolokeerye hali Labbani̱ Mu̱raami̱i̱ni̱ mu kilooto, yaamuweera naakoba yati, “Weerinda hoi̱ otaweera Yakobbo kintu kindi kyensei̱ kibiibi rundi kirungi.” ");
INSERT INTO rub_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Labbani̱ yaadwerereeri̱ Yakobbo. Mu kasu̱mi̱ kakwo, Yakobbo yaali abi̱mbi̱ri̱ heema mu nsi gya nsahu, Labbani̱ na banyaruganda baamwe na yo yaabi̱mbi̱ri̱ gyab̯u mu nsi gya nsahu za Gi̱ryadi̱. ");
INSERT INTO rub_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Kasi Labbani̱ yaab̯u̱u̱lya Yakobbo naakoba yati, “Hab̯waki waakoori̱ ki̱kyo? Ongobeerye waatwala bahara bange nka bantu bawanyagi̱ri̱ mu b̯ulemu? ");
INSERT INTO rub_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Kyani kinyaakukuha kwezi̱ba, nyaku̱bbeeri̱ ntaku̱ragi̱ri̱ na byembu na kusemererwa, na ndi̱ngi̱di̱ na ndongo? ");
INSERT INTO rub_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Hab̯waki otanzi̱ki̱ri̱i̱ze nkaraga bahara bange na beizukulu bange? Okoori̱ ki̱tadoori̱. ");
INSERT INTO rub_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ndi na b̯u̱sobozi̱ kukukoraho kabii, bei̱tu̱ Ruhanga wa bbaawu yambwereeri̱ naakoba yati, ‘Weerinda hoi̱ otaweera Yakobbo kintu kindi kyensei̱ kibiibi rundi kirungi.’ ");
INSERT INTO rub_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Hataati̱ kandi ondu̱gi̱ri̱ho waagyenda, oi̱ceeri̱ niwendyanga hoi̱ kwemuka kwamwenyu̱, bei̱tu̱ hab̯waki wei̱bi̱ri̱ baruhanga bange?” ");
INSERT INTO rub_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakobbo yei̱ri̱ri̱mwo Labbani̱ naakoba yati, “Nyati̱i̱nengi̱, nintekerezanga nti osobora ku̱ndwani̱sya ontooleho bahara baamu byampaka. ");
INSERT INTO rub_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Kakubba waagya muntu wondi yensei̱ ali na baruhanga baamu, yogwo muntu akwi̱za ku̱kwa b̯u̱kwi̱. Mu mei̱so ga batabani̱ beetu̱, nahab̯waki̱kyo, weewonira b̯uli kikweteb̯wa kyamu, ki̱wagi̱i̱rye mu bintu byetu̱ osenge otwale.” Bei̱tu̱ Yakobbo yaali ateegi̱ri̱ Lakeeri̱ nka kwei̱bi̱ri̱ baruhanga ba bbaawe. ");
INSERT INTO rub_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Nahab̯waki̱yo, Labbani̱ yaagyendi̱ri̱ yaatolereerya mu heema gya Yakobbo, gya Leeya, na mu heema gya bazaana babiri, bei̱tu̱ atakazaagye. Kasi yaaruga mu heema gya Leeya yeingira mu gya Lakeeri̱. ");
INSERT INTO rub_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Lakeeri̱ yaali amaari̱ ku̱bi̱sa bi̱si̱sani̱ bya baruhanga ba kwamwab̯u, ku musagu gwa ngamira, abi̱i̱cali̱i̱ri̱, Labbani̱ yaatolerereerye bei̱tu̱ atakabaagye. ");
INSERT INTO rub_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Lakeeri̱ yaaweereeri̱ bbaawe naakoba yati, “Bbaabba otankwatirwa ki̱ni̱ga, b̯utemeera mu mei̱so gaamu, hab̯wakubba ndi mu nsonga.” Bei̱tu̱ Labbani̱ yaatoleerye baruhanga baamwe ataku̱baagya. ");
INSERT INTO rub_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Nahaahwo, Yakobbo yaakwati̱i̱rwe ki̱ni̱ga, yaajumbutukira Labbani̱ naakoba yati, “Ki̱nyasobeerye kyokyo kilahi, nyagu̱mi̱ri̱ musangu ki, oleke ompondere? ");
INSERT INTO rub_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Otoolereerye b̯uli ki̱mwei̱, mu bintu byange byensei̱, bi̱kyani̱ bi̱wagi̱i̱ryemwo bya mu nnyu̱mba gyamu, bite hasyanu̱ mu mei̱so ga baluganda beetu̱ aleke baturamure? ");
INSERT INTO rub_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Mmaari̱ nawe myaka maku̱mi̱ gabiri, tihakabbangaho ntaama, rundi mbu̱li̱ gyamu gyensei̱ ginyaakutorooga, kandi tinkadyanga mpaya gya ntaama mwigana lyamu. ");
INSERT INTO rub_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","B̯uli ntaama, rundi mbu̱li̱ gyensei̱ gi̱nyakwi̱twa kisolo, rundi gi̱bei̱bi̱ri̱, habbe mwinsi rundi i̱jolo nyaagi̱ku̱saswi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Kwokwo yatyo nyei̱ceeri̱ mu kingeere ni̱ki̱nzokya kandi ni̱nsu̱u̱twa mpehu gyei̱jolo, b̯ulo ni̱b̯u̱nsyerekeera mu mei̱so. ");
INSERT INTO rub_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Mu myaka maku̱mi̱ gabiri, ganyaamaari̱ mu nnyu̱mba gyamu, nyaaku̱koleeri̱ milimo kumala myaka i̱ku̱mi̱ na minei, kwokwo ntunge bahara baamu babiri, kandi myaka mukaaga, nyami̱maari̱ ni̱nku̱li̱i̱sya magana gaamu, mu kasu̱mi̱ kakwo kensei̱, mpeera gyange waagi̱hi̱ngi̱si̱i̱rye mirundi i̱ku̱mi̱ ");
INSERT INTO rub_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Kabbenge Ruhanga wa bbaabba I̱bbu̱rahi̱mu̱, Ruhanga wʼI̱saka, atambereeri̱ho, mananu kwo waaku̱bbeeri̱ ombi̱ngi̱ri̱ ntali na kantu kensei̱, Ruhanga yaaweeni̱ mutima gwange, na milimo mi̱nyakoori̱, kyokyo yaaku̱hani̱ri̱ i̱jolo.” ");
INSERT INTO rub_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Labbani̱ yei̱ri̱ri̱mwo Yakobbo naakoba yati, “Bahala bab̯wo bahara bange, baana bab̯wo bange, gagwo magana ga ntaama na mbu̱li̱ gensei̱ gange, na byensei̱ bi̱byo byokuwona byange, hataati̱ bahara bange rundi baana baab̯u banyakubabyala mbakoore kyani? ");
INSERT INTO rub_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Hataati̱ gya nawe, leka tukore ndagaanu, gibbe b̯u̱kei̱so hakati̱ gyetu̱.” ");
INSERT INTO rub_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Yakobbo yaakweti̱ i̱hi̱ga, yaalisimba aleke libbe kyakwi̱zu̱ki̱raho. ");
INSERT INTO rub_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Yakobbo yaaweereeri̱ banyaruganda baamwe naakoba yati, “Mu̱soorooze mahi̱ga.” Bu̱bagasooroozi̱ri̱, gaatu̱u̱ma, baadi̱i̱ri̱ bidyo bei̱cali̱i̱ri̱ ku gi̱gyo ntuumo. ");
INSERT INTO rub_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Gi̱gyo ntuumo gya mahi̱ga, Labbani̱ yaagyeti̱ri̱ ibara Yegera-sahadu̱sa, bei̱tu̱ kandi yo Yakobbo yaagyeta Galeedi̱. ");
INSERT INTO rub_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Labbani̱ yaakobi̱ri̱ yati, “Kuruga na hataati̱, ntuumo gya mahi̱ga gi̱gyo, gyogyo gyabbanga b̯u̱kei̱so b̯wetu̱.” Nahahwo yaagyeti̱ri̱ ibara Galeedi̱, ");
INSERT INTO rub_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","kandi i̱hi̱ga yaalyeta Mizipa, hab̯wakubba yaakobi̱ri̱ yati, “Mukama atulinde b̯utwakahukana haha. ");
INSERT INTO rub_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","B̯woli̱wonawonesya bahara bange, rundi okabagerekaho bakali̱ bandi, nab̯uhakabba hataloho muntu wondi yensei̱, oi̱zu̱ke Ruhanga yooyo mu̱kei̱so weetu̱.” ");
INSERT INTO rub_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Kasi Labbani̱ yaaweera Yakobbo naakoba yati, “Wona gi̱gyo ntuumo gya mahi̱ga, gi̱nteeri̱ hakati̱ waagya nawe nka ki̱zu̱kyo. ");
INSERT INTO rub_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Gi̱gyo ntuumo gya mahi̱ga b̯uli b̯u̱kei̱so kwolokya tindigyakaalya nkei̱za rubaju lwamu kukuhuutaaza. Nawe otaligyakaalya okei̱za rubaju lwange kumputaaza. ");
INSERT INTO rub_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ruhanga wʼI̱bbu̱rahi̱mu̱, Ruhanga wa Nahoori̱ kandi Ruhanga wa bahaaha baab̯u, tu̱ramu̱re.” Nahaahwo, Yakobbo yaarahi̱i̱ri̱ mwibara lya Ruhanga wa bbaawe I̱saka yaaramyengi̱. ");
INSERT INTO rub_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Yakobbo yeeti̱ri̱ kisolo, yaakihonga ha lu̱lwo lusahu, yeeta banyaruganda baamwe kwi̱za kudya hamwei̱ nayo, baadi̱i̱ri̱ kandi baalaalayoona. ");
INSERT INTO rub_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","B̯wi̱re b̯u̱b̯wakeeri̱, Labbani̱ yaabyoki̱ri̱ yanywegera bahara na beizukulu baamwe yaabaha mu̱gi̱sa yeemuka. ");
INSERT INTO rub_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yakobbo b̯uyaali naakwemuka wu bbaawe, yaarombi̱ri̱ bamalayika ba Ruhanga. ");
INSERT INTO rub_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","B̯u̱yaabaweeni̱, yaakoba yati, “Gigi gyogyo kampu gya Ruhanga.” Kasi kiikaru ki̱kyo yaakyeta Mahai̱nai̱mu̱. ");
INSERT INTO rub_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yakobbo yaatu̱mi̱ri̱ bakwenda bamwebembere kugyenda hali waab̯u Esau̱. Esau̱ yei̱calenge mu nsi gya Sei̱ri̱, mwihanga lya Edomu̱. ");
INSERT INTO rub_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Yaabaragi̱ri̱i̱ri̱ nabaweera bakobe yati: “Mukama wange Esau̱, gyagya Yakobbo mwiru waamu, nceeri̱ ninyicala na Labbani̱ ku̱doosya na hataati̱. ");
INSERT INTO rub_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Hataati̱ ndi neitungu lyange nka nte, ndogoyi̱, ntaama, mbu̱li̱ na baheereza badulu na bakali̱. Ntu̱mi̱ri̱ bakuweere we mukama wange, aleke ongiire mbabazi̱.” ");
INSERT INTO rub_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Bakwenda baaku̱bi̱ri̱ hali Yakobbo baamuweera nibakoba yati, “Twadwerereeri̱ weenyu̱ Esau̱, ali na badulu nku̱mi̱ inei, ali̱mu̱kwi̱za aleke mu̱rombe nayo.” ");
INSERT INTO rub_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yakobbo yaati̱i̱ni̱ri̱ kandi yeelalikiira hoi̱. Yaabagani̱i̱ryemwo mirundi mibiri mu bantu bayaali nabo, magana ga ntaama, mbu̱li̱ hamwei̱ na ngamira. ");
INSERT INTO rub_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Yaateekerezengi̱ nti, “Kakubba Esau̱ aru̱mba kicweka ki̱mwei̱, kikusigalaho kyakusobora kukena.” ");
INSERT INTO rub_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Yakobbo yaasabi̱ri̱ naakoba yati, “Ai̱ Ruhanga wa bbaabba I̱bbu̱rahi̱mu̱, Ruhanga wa bbaabba I̱saka, Mukama, we munyakumbwera yati, ‘Weemuka kwamwenyu̱, mu banyaruganda baamu. Nkwi̱za kukukoora bintu birungi,’ ");
INSERT INTO rub_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","ti̱nsemereeri̱ ku̱nzolokya ngonzi zinene na b̯wesigwa b̯wensei̱ b̯u̱wolokeerye muheereza waamu, kubba nyaali na mubbeere gusa b̯unyaali ninkwambuka Yorodaani, bei̱tu̱ hataati̱ ndi na ncungu ibiri za bantu hamwei̱ na bisolo. ");
INSERT INTO rub_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Beiraba nkwesengereze onjune, kuruga mu mikono mya mwi̱ra wange Esau̱, kubba nku̱ti̱i̱na asobora kwi̱za ku̱ndu̱mba hamwei̱ nei̱ka lyange. ");
INSERT INTO rub_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Bei̱tu̱ kandi i̱zu̱ka, wandaganisiirye nokaba nti, ‘Bezu̱ku̱lu̱ bange olibakora kurungi, bakanye nka musinyi gwa ku mutanda gutakusobora kubalwa hab̯wa b̯unene b̯wagwo.’ ” ");
INSERT INTO rub_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","I̱jolo lyolyo Yakobbo, yaakwati̱i̱rye Esau̱ waab̯u kisembu ku bintu biyaali nabyo. ");
INSERT INTO rub_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Mu bi̱byo bintu hooho haalingi b̯uguma za mbu̱li̱ bi̱ku̱mi̱ bibiri, na mpaya maku̱mi̱ gabiri, ntaama zi̱kali̱ bi̱ku̱mi̱ bibiri na ntaama zidulu maku̱mi̱ gabiri. ");
INSERT INTO rub_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Haabbamwo ngamira zi̱kwonkya maku̱mi̱ gasatu hamwei̱ na b̯wana b̯wazo, nte zi̱kali̱ maku̱mi̱ ganei, na nnumi i̱ku̱mi̱, ndogoyi̱ zi̱kali̱ maku̱mi̱ gabiri hamwei̱ na zidulu i̱ku̱mi̱. ");
INSERT INTO rub_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Gaga magana gensei̱, Yakobbo yaagakwati̱i̱rye baheereza baamwe. B̯uli igana yaalyahu̱kani̱a hab̯walyo. Yakobbo yaaweera baheereza baamwe naakoba yati, “Munyebembere mu̱bagani̱emwo magana nimweha mwanya.” ");
INSERT INTO rub_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Yakobbo yaaragi̱i̱ri̱ baheereza banyaakwebembera naakoba yati, “Kakubba mu̱romba Esau̱, akabab̯u̱ulya yati, ‘Muli bantu ba naani? Mukugyenda hanya? Mu̱ku̱li̱i̱sya magana ga naani?’ ");
INSERT INTO rub_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Mumuweere nimukoba yati, ‘Bya mwiru waamu Yakobbo. Bili bisembu byatwekeeri̱ mukama waamwe Esau̱. Yo yankei ali̱mu̱kwi̱za i̱nyu̱ma lyetu̱.’ ” ");
INSERT INTO rub_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Yakobbo yei̱ri̱ri̱ yaaweera baheereza banyaaku̱li̱batyanga igana lindi na banyakuhonderanga i̱nyu̱ma naakoba yati, “Kwokwo nanywe muweere Esau̱, b̯u̱mwakamu̱romba.” ");
INSERT INTO rub_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Kandi Yakobbo yaabaweereeri̱ kwo, yo nka kwali mu kwi̱za hei̱nyu̱ma lyab̯u hab̯wakubba Yakobbo yaatekerezenge ki̱doori̱ b̯u̱dwe kutwekera Esau̱ bisembu bimusemeze. B̯u̱bali̱romba asobore kumuganyira bafooke banywani. ");
INSERT INTO rub_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Nahab̯waki̱kyo Yakobbo yaatu̱mi̱ri̱ badulu hamwei̱ na bisembu byamwe bigyende mu̱mei̱so ku̱romba Esau̱. Bei̱tu̱ yo yaaleeri̱ mu heema mu kicweka ki̱kyo. ");
INSERT INTO rub_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","I̱jolo lyolyo Yakobbo yaabyokeerye lugyendu, yaagyenda na bakalwe babiri, baheereza bakali̱ babiri na baana baamwe i̱ku̱mi̱ noomwei̱, yambuka mugira gubakweta Yabboki̱. ");
INSERT INTO rub_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","B̯u̱yaambu̱ki̱i̱rye makaa gaamwe, yambu̱ki̱i̱rye na bintu byensei̱ biyaali nabyo. ");
INSERT INTO rub_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Kasi Yakobbo yaasigala yankei. Mudulu yaamu̱lwani̱sya hab̯wa kasu̱mi̱ kalei mpaka na mambya. ");
INSERT INTO rub_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Mudulu b̯u̱yaaweeni̱ takusobora ku̱si̱ngu̱ra Yakobbo, mudulu yaamukuuta ha nyuŋunyu i̱ku̱ha lya Yakobbo lyahyotoka. ");
INSERT INTO rub_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Bei̱ceeri̱ nibalwana kasi mudulu yaaweera Yakobbo yati, “Ndeka ngyende, hab̯wakubba b̯wi̱re b̯u̱keeri̱.” Bei̱tu̱ Yakobbo yaamwi̱ri̱ri̱mwo naakoba yati, “Nkukuleka kwahi, ku̱doosya ompeeri̱ mu̱gi̱sa.” ");
INSERT INTO rub_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Kasi mudulu yaamu̱b̯u̱u̱lya naakoba yati, “Ibara lyamu weewe naani?” Yakobbo yei̱ri̱ri̱mwo yati, “Gyagya Yakobbo.” ");
INSERT INTO rub_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Mudulu yaamuweera naakoba yati, “Tibakyakakweta Yakobbo, bei̱tu̱ baakwetanga I̱saleeri̱, hab̯wakubba olweni̱ na Ruhanga kandi waalwana na bantu, bei̱tu̱ osi̱ngu̱u̱ri̱.” ");
INSERT INTO rub_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Mwomwo Yakobbo yaamuweera yati, “Beiraba, mbwera ibara lyamu.” Mudulu yaakoba yati, “Hab̯waki okwendya hoi̱ kwega ibara lyange?” Nahaahwo yaamuha mu̱gi̱sa. ");
INSERT INTO rub_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Nahab̯waki̱kyo, Yakobbo yeeta ki̱kyo kiikaru ibara Peni̱eri̱, naakoba yati, “Mbweni̱ Ruhanga mei̱so na mei̱so kandi nyaakena ku̱kwa.” ");
INSERT INTO rub_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Ha yaaru̱gi̱ri̱ Peni̱eri̱, lyoba lyali litakahuluka b̯u̱hu̱lu̱ki̱, yaali naaku̱ci̱nki̱bba, hab̯wakubba nyuŋunyu gyamu̱dyengi̱. ");
INSERT INTO rub_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ku̱doosya hataati̱, Bei̱saleeri̱, tibadya nnyama gya kisolo gya ha nyuŋunyu. ");
INSERT INTO rub_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yakobbo yaabyokeerye mei̱so gaamwe, yaawona Esau̱ naakwi̱za hamwei̱ na badulu bi̱ku̱mi̱ binei. Nahaahwo yaabagani̱i̱ryemwona baana mirundi mibiri, hakati̱ wa Leeya na Lakeeri̱ na baana ba baheereza bakali̱ babiri. ");
INSERT INTO rub_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Baheereza bakali̱ na baana baab̯u, yaabateeri̱ mu mei̱so, yaahondeeryaho Leeya na baana baamwe, kasi Lakeeri̱ na Yozefu̱ basembeyo i̱nyu̱ma. ");
INSERT INTO rub_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Yo yankei yaabebembeeri̱ yaagyenda yaaku̱nda b̯u̱syo hansi mirundi musanju, ku̱doosya b̯u̱yaadoori̱ b̯u̱waab̯u. ");
INSERT INTO rub_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Bei̱tu̱ Esau̱ yei̱ru̱ki̱ri̱ yaaromba Yakobbo, b̯u̱baarombi̱ri̱ baagwagana mu salaka, bensei̱ hamwei̱ baatandika kulira. ");
INSERT INTO rub_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Esau̱ b̯u̱yaakabyokeerye mei̱so gaamwe, yaawona bakali̱ hamwei̱ na baana baawu, yaab̯u̱u̱li̱i̱rye naakoba yati, “Bab̯wo booli nabo bali banaani?” Yakobbo yei̱ri̱ri̱mwo naakoba yati, “Bab̯wo boobo baana Ruhanga bayampeeri̱ gya muheereza waamu, hab̯wa mbabazi̱ zaamwe.” ");
INSERT INTO rub_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Mwomwo baheereza bakali̱ na baana baab̯u bei̱za hali Esau̱ beetu̱lu̱ka hansi. ");
INSERT INTO rub_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Leeya na baana baamwe nabo bei̱za beetu̱lu̱ka hansi mu mei̱so ga Esau̱. Ha kumaliira, Lakeeri̱ na Yozefu̱ nabo bei̱zi̱ri̱ hali Esau̱ beetu̱lu̱ka hansi. ");
INSERT INTO rub_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esau̱ yaab̯u̱u̱li̱i̱rye Yakobbo naakoba yati, “Kyani kyomanyi̱si̱i̱rye, kuleeta gaga magana gensei̱ kwi̱za ku̱romba nagya?” Yakobbo yei̱ri̱ri̱mwo naakoba yati, “Ngaleeti̱ri̱ aleke we mukama wange ongiire mbabazi̱.” ");
INSERT INTO rub_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Esau̱ yei̱ri̱ri̱mwona waabu̱ naakoba yati, “Mwana weetu̱, magana gandi nago gakummala, magana gaamu icala nago.” ");
INSERT INTO rub_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yakobbo yaakoba yati, “Kwahi, nkwesengereze, waakabba wangiira mbabazi̱, ikiriza kisembu ki̱nku̱heeri̱ hab̯wakubba mbweni̱ mei̱so gaamu, ndi nka muntu aweeni̱ Ruhanga, kubba ontangiri̱iri̱ na mbabazi̱ zitamalikaho. ");
INSERT INTO rub_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Nkwesengereerye, ikiriza kiki kisembu ki̱nku̱leteeri̱, hab̯wakubba Ruhanga yangi̱ri̱i̱ri̱ mbabazi̱, kandi ntu̱ngi̱ri̱ bintu binene.” Yaamu̱taagi̱i̱ri̱, yeeki̱ri̱za. ");
INSERT INTO rub_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Esau̱ yaakoba yati, “Tweyongereyo mu mei̱so na lugyendu lwetu̱, nkwi̱za gya kukwebembera.” ");
INSERT INTO rub_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Bei̱tu̱ Yakobbo yaakoba yati, “Mukama wange okyegi̱ri̱ baana baba nka kubacaali bato, magana ga nte na ntaama zi̱kwonkya, gali mu mikono myange, kandi gakalibata maani gensei̱ gakwi̱za ku̱kwa. ");
INSERT INTO rub_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Mukama wange, we nyebembera, gya nyei̱zanga hamwei̱ na magana na baana, ku̱doosya b̯u̱nyakakwagya mu kiikaru Sei̱ri̱.” ");
INSERT INTO rub_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esau̱ yaamwi̱ri̱mwo naakoba yati, “Kankulekere bamwei̱ ha badulu bandinabo.” Yakobbo yaab̯u̱u̱lya, “Kyani kikwetagisib̯wayona? Aleke ntunge mbabazi̱ mu mei̱so ga mukama wange.” ");
INSERT INTO rub_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Kiro ki̱kyo, Esau̱ yaakweti̱ muhanda yaakuba Sei̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Bei̱tu̱ Yakobbo yaagyendi̱ri̱ Su̱koosi̱, yaabi̱mbi̱ri̱ nnyu̱mba gyamwe hamwei̱ na bi̱nyu̱mba bya bisolo. ");
INSERT INTO rub_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yakobbo yaaru̱gi̱ri̱ Padanaramu, yaadwa kurungi mu rub̯uga Sekemu̱, luli mu nsi gya Kanani̱, yaabamba heema gyamwe heehi̱ na rub̯uga. ");
INSERT INTO rub_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Yaagu̱u̱ri̱ kicweka kyeitehe hali baana ba Hamora, bba Sekemu̱ kiyaali abi̱mbi̱riho heema gyamwe, yaakisasulira bicweka kya si̱li̱va ki̱ku̱mi̱. ");
INSERT INTO rub_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ku̱kwo hooho yaabi̱mbi̱ri̱ kyoto kyeihongo, yaakyeta Eli̱-Elohei̱-I̱saleeri̱. ");
INSERT INTO rub_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Di̱na yaali muhara wa Leeya gi̱yabyeri̱ hali Yakobbo. Kiro ki̱mwei̱ yaagyendi̱ri̱ kub̯ungira bakali̱ banyakwicalanga heehi̱ na rub̯uga lwa Sekemu̱. ");
INSERT INTO rub_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Sekemu̱ mu̱tabani̱ wa Hamora Mu̱hi̱i̱vi̱, mu̱lemi̱ wa gi̱gyo nsi, b̯u̱yaaweeni̱ Di̱na, yaamukwata, yaamuhamba. ");
INSERT INTO rub_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Mutima gwa Sekemu̱ gwegombengi̱ hoi̱ Di̱na. Yamwendyengi̱ kandi namuweera bigambu byangonzi aleke nayo amwendye. ");
INSERT INTO rub_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Sekemu̱ yaaweereeri̱ bbaawe Hamora naakoba yati, “Nkwendya muhala yogo Di̱na omunswereere abbe mu̱kali̱ wange.” ");
INSERT INTO rub_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Mu kasu̱mi̱ kakwo, Yakobbo yaali amaari̱ kwetegereza Sekemu̱ nka kuyaali amaari̱ kuhemura muhara waamwe Di̱na, bei̱tu̱ batabani̱ ba Yakobbo baalingi baagyendi̱ri̱ ku̱li̱i̱sya nte. Yakobbo atakabaze kintu kyensei̱ ku̱doosya batabani̱ b̯u̱beeri̱ri̱ kwamu̱gi̱. ");
INSERT INTO rub_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hamora bbaa Sekemu̱, yaagyenda kubaza na Yakobbo ha bikukwatagana na Di̱na. ");
INSERT INTO rub_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Batabani̱ ba Yakobbo b̯u̱bakyegwi̱ri̱, baaru̱gayo mwirungu ku̱li̱i̱sya. Baasali̱i̱rwe hoi̱ kubba Sekemu̱ yaakoori̱ kintu kibiibi. Kuhamba Di̱na muhara wa Yakobbo akalaala nayo, yaaleeti̱ri̱ muswaru hali mu̱gi̱ gwa Yakobbo. Kiki kyali kikorwa kibiibi kya muntu yensei̱ atasemereeri̱ kukora mwʼI̱saleeri̱ gyensei̱. ");
INSERT INTO rub_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Bei̱tu̱ Hamora yaaweereeri̱ Yakobbo na batabani̱ baamwe naakoba yati, “Mu̱tabani̱ wange Sekemu̱ yeegombi̱ri̱ muhara weenyu̱, nkusaba, mumwikirize amutunge. ");
INSERT INTO rub_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Leka tutunge bakali̱ mu nganda zeenyu̱. Mu̱tu̱he bahara beenyu̱ tubatunge, nanywe mutwale bahara beetu̱ mubatunge. ");
INSERT INTO rub_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Mwicala natwe, nsi gigi, gibbe gyenyu̱ mu̱gi̱calemwo, mu̱gi̱su̱b̯uliremwo, mu̱gu̱du̱hare.” ");
INSERT INTO rub_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Sekemu̱ yaaweereeri̱ bbaa muhala na baawu muhala naakoba yati, “Mu̱ngi̱i̱re mbabazi̱, kyensei̱ kimwakacwa, nkukibaha. ");
INSERT INTO rub_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Mucwe mukaaga na bisembu nka ku̱mu̱kwendya, nkubibaha, gya ki̱kyo ki̱nkwendya, kili ki̱mwei̱ kisa, mu̱mpe muhala yogwo mmuswere.” ");
INSERT INTO rub_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Batabani̱ ba Yakobbo baagobyagobya Sekemu̱ na Hamora bbaawe, hab̯wakubba Sekemu̱ yaali ahemu̱u̱ri̱ Di̱na nyaakaab̯u. ");
INSERT INTO rub_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Babaweera nibakoba yati, “Kintu ki̱kyo, titusobora kukikora, nyaakeetu̱ kumuha mudulu atasali̱i̱rwe. Ki̱kyo kyabba kihemu hali twe. ");
INSERT INTO rub_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Tukugyenda kubekiriza, kakubba nanywe mwikiriza kwisana na twe, b̯uli mudulu yensei̱ muli nywe b̯u̱yakasalwa. ");
INSERT INTO rub_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Mwomwo twabaha bahara beetu̱, natwe tutunge bahara beenyu̱, tufooke bantu bamwe kandi tubbe ihanga li̱mwei̱. ");
INSERT INTO rub_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Bei̱tu̱ b̯umuteikirize ki̱tu̱kobi̱ri̱ mukasalwa, muhara weetu̱ tukubamutoolaho nitugyenda nayo.” ");
INSERT INTO rub_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Hamora na mu̱tabani̱ waamwe Sekemu̱, baasi̱i̱mi̱ri̱ bigambu byab̯u. ");
INSERT INTO rub_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Musigazi atakakerereerwe, yaakora ki̱kyo ki̱baamu̱weereeri̱, hab̯wakubba yaali kwendya muhara wa Yakobbo, kandi mu makaa ga bbaawe Hamora, Sekemu̱ yooyo baaki̱rengi̱ kuha ki̱ti̱i̱ni̱sa. ");
INSERT INTO rub_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Nahahwo Hamora na mu̱tabani̱ waamwe Sekemu̱, baagyenda heirembu lya rub̯uga lwab̯u, baaweera bantu bamu lu̱lwo rub̯uga nibakoba yati, ");
INSERT INTO rub_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Badulu baba, banywani beetu̱, mubaleke beicale mu nsi mumu, basub̯uliremwo, hab̯wakubba nsi gili gikooto, leka tuswere bahara baab̯u, na twe tubahe bahara bei̱tu̱ babatunge. ");
INSERT INTO rub_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Bantu ki̱kyo kibakekiriza kwicala natwe, ntukabba bantu bamwei̱, kili ki̱mwei̱ kisa kwokwo b̯uli mudulu yensei̱ muli twe kusalwa nka bo ku̱basali̱i̱rwe. ");
INSERT INTO rub_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Nte zaab̯u, bintu byab̯u, na bisolo byab̯u byensei̱ tibyabbe byetu̱? Ki̱mwei̱ kisa, tukwikiraniza nabo, bakwi̱za kwicala na twe.” ");
INSERT INTO rub_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Bensei̱ banyakuruga mu rub̯uga bei̱ki̱ri̱i̱ze, baakora bintu byensei̱ bya Hamora na mu̱tabani̱ waamwe Sekemu̱ bi̱babaweereeri̱. Badulu bensei̱ banyakuraba mwirembu lya rub̯uga lwamwe, baabasaari kapapa. ");
INSERT INTO rub_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Ha kiro kyakasatu bantu nibacaali na b̯u̱ru̱mi̱ b̯wa kusalwa kapapa, batabani̱ ba Yakobbo babiri, Si̱myoni̱ na Leevi̱ baab̯u Di̱na, baakweti̱ byogi byab̯u, baaru̱mba rub̯uga bantu batakabetegekeeri̱, bei̱ta badulu bensei̱ ba mu rub̯uga. ");
INSERT INTO rub_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Bei̱ti̱ri̱ Hamora na mu̱tabani̱ waamwe Sekemu̱, baatoola Di̱na wu Sekemu̱ baagyenda. ");
INSERT INTO rub_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Batabani̱ ba Yakobbo bandi baadwa ha mitumbi, baanyagi̱ri̱ rub̯uga, hab̯wakubba Sekemu̱ yaali ahemwi̱ri̱ nyaakaab̯u. ");
INSERT INTO rub_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Baatweri̱ magana gaab̯u ga nte na ga mbu̱li̱, ndogoyi̱ zaab̯u, na byensei̱ binyakubba mu rub̯uga na mu misiri. ");
INSERT INTO rub_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Itungu lyab̯u lyensei̱, baana baab̯u bato, na bakali̱ baab̯u, byensei̱ binyakubba mu manyu̱mba, baabinyaga. ");
INSERT INTO rub_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Nahaahwo, Yakobbo yaaweereeri̱ Si̱myoni̱ na Leevi̱ naakoba yati, “Mu̱ndeeteeri̱ kabii, mu̱kwi̱za ku̱nnobesya banyansi, Bakanani̱ na Baperezi̱. Twe tuli badooli̱ kakubba babyoka ku̱ndwani̱sya, bakwi̱za kumpwerekereerya, gya na ba mu makaa gange bensei̱.” ");
INSERT INTO rub_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Bei̱tu̱ bo baamuweera nibakoba yati, “Kyadoori̱ Sekemu̱ kufoora nyaakeetu̱ mwenzi̱?” ");
INSERT INTO rub_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Ruhanga yaaweereeri̱ Yakobbo naakoba yati, “Byokya ogyende Bbeseeri̱, oi̱caleyo, obi̱mbi̱re Ruhanga kyoto, yogwo munyakukwezolokyaho mu b̯wi̱re b̯u̱weru̱ki̱i̱ri̱mwo weenyu̱ Esau̱.” ");
INSERT INTO rub_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Mwomwo Yakobbo yaaweera ba makaa gaamwe na bantu bensei̱ bayaali nabo naakoba yati, “Mu̱ru̱ge mu baruhanga bandi ba banyamahanga bamuli nabo, mwecume kandi mu̱hi̱ndu̱le bilwalu byenyu̱. ");
INSERT INTO rub_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Katubyoke tugyende Bbeseeri̱ nkwi̱za ku̱bi̱mbi̱rayo Ruhanga kyoto kyeihongo, yogwo mu̱nyaku̱nzi̱ramwo b̯unyaali mu b̯ujune, yeicala nagya hensei̱ hanyakagyendanga.” ");
INSERT INTO rub_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Nahahwo baaheeri̱ Yakobbo baruhanga babaali nabo na mpi̱ta zi̱baalwalengi̱ ha mapokopo gaab̯u. Yaazi̱bi̱sa hansi wa musaali mu̱vu̱le, gunyakubba heehi̱ na kicweka kya Sekemu̱. ");
INSERT INTO rub_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","B̯ubaalingi nibakugyenda, bantu ba mu mbuga zinyakubba zi̱bahereeri̱, Ruhanga yaabaleteeri̱ b̯u̱ti̱i̱ni̱ nahab̯waki̱kyo, batakasobore kuramagira Yakobbo na bantu baamwe. ");
INSERT INTO rub_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yakobbo na bantu bensei̱ bayaali nabo, baadwa Lu̱u̱zi̱ (hataati̱ gyegebeerwe nka Bbeseeri̱) mu nsi gya Kanani̱. ");
INSERT INTO rub_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Yakobbo yaabi̱mbi̱ri̱ kyoto kyeihongo mu kicweka ki̱kyo, yaakyeta Eli̱-bbeseeri̱, hab̯wakubba hooho Ruhanga yaamwezolekeeryeho, naakwi̱ru̱ka waab̯u Esau̱. ");
INSERT INTO rub_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Kandi Debora munyakuwoneera Rebbeeka mu b̯uto yaakwi̱ri̱, Yakobbo yaamuziika ha musaali mu̱vu̱le heehi̱ na Bbeseeri̱. Kyokyo ki̱kyo kicweka baakyeti̱ri̱ Alooni̱-baku̱u̱si̱ makuru gaakyo, “Musaali guha bantu kulira mali̱ga.” ");
INSERT INTO rub_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yakobbo b̯uyaali naakuruga Padanaramu, Ruhanga yaab̯u̱ni̱a yaamu̱wonekera, kandi yaamuha mu̱gi̱sa ");
INSERT INTO rub_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","naakoba yati, “Oi̱ceeri̱ ni̱weetwa Yakobbo, kuruga na hataati̱ tocaali Yakobbo, bei̱tu̱ ibara lyamu lyabbanga I̱saleeri̱.” Kyokyo Ruhanga yaamweteeri̱ I̱saleeri̱. ");
INSERT INTO rub_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Ruhanga yaamuweera naakoba yati, “Gyagya Ruhanga Waamaani Gensei̱. Byala baana banene aleke beizukulu baamu bakanye, obyale na bakama. ");
INSERT INTO rub_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Nsi gi̱nyaaheeri̱ I̱bbu̱rahi̱mu̱ na I̱saka, nkwi̱za kugikuha we na beizukulu baamu ba hei̱nyu̱ma.” ");
INSERT INTO rub_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Ruhanga yaaru̱gi̱ri̱ho Yakobbo yaagyenda, ");
INSERT INTO rub_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yakobbo yaasi̱mbi̱ri̱ nkondo mu kicweka cali Ruhanga yaabazi̱ri̱ nayo, gyali nkondo gyei̱hi̱ga. Yaagibbwomera kihongwa kyakunywa na maku̱ta ga mu̱zayi̱tu̱u̱ni̱. ");
INSERT INTO rub_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Kicweka ki̱kyo Yakobbo yaakyeti̱ri̱ Bbeseeri̱. ");
INSERT INTO rub_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Mwomwo baasetuka baaruga mu nsi gya Bbeseeri̱. B̯ubaalingi nibali heehi̱ kudwa Efu̱raati̱, Lakeeri̱ yaatandika kudiib̯wa bisa. Yaadi̱b̯wengi̱ hoi̱. ");
INSERT INTO rub_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Bisa b̯u̱byakamu̱di̱ri̱i̱ri̱ ki̱mwei̱, mu̱kali̱ munyakubba naaku̱mu̱byali̱sya yaamuweera naakoba yati, “Leka ku̱ti̱i̱na obyeri̱ mwana wondi wa b̯udulu.” ");
INSERT INTO rub_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Lakeeri̱ b̯uyaali naali heehi̱ ku̱kwa, yaru̱ki̱ri̱ mwana waamwe ibara Bbenoni, bei̱tu̱ bbaawe yaamweta Bbenyami̱i̱ni̱. ");
INSERT INTO rub_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Lakeeri̱ kwokwo yaakwi̱ri̱ yatyo, yaaziikwa ha muhanda gukutwala Efu̱raati̱ (hataati̱ gyegebeerwe nka Bbeterehemu̱). ");
INSERT INTO rub_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Ha nyanga gyamwe, Yakobbo yaasi̱mbi̱ri̱ho nkondo gyei̱hi̱ga gibbe ki̱zu̱kyo. Li̱lyo i̱hi̱ga na hataati̱ liicaloho. ");
INSERT INTO rub_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","I̱saleeri̱ yeeyongeeri̱yo na lugyendu lwamwe, yaabamba heema gyamwe mu mei̱so ga munaara gwʼEdeeri̱. ");
INSERT INTO rub_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","I̱saleeri̱ b̯uyaali naatakeicala mu gi̱gyo nsi, Lu̱bbeeni̱ yaatu̱ngi̱ri̱ Bbi̱li̱ha mukaabbaawe, I̱saleeri̱ yaakyetegereza. ");
INSERT INTO rub_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Gaga googo mabara ga baana bayaabyeri̱ hali Leeya: Lu̱bbeeni̱ (gwogwo mu̱zegei̱zo gwa Yakobbo), Si̱myoni̱, Leevi̱, Yu̱da, I̱saakaari̱, na Zabbu̱looni̱. ");
INSERT INTO rub_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Mabara ga baana bayaabyeri̱ hali Lakeeri̱ googo gaga: Yozefu̱ na Bbenyami̱i̱ni̱. ");
INSERT INTO rub_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Mabara ga batabani̱ ba Bbi̱li̱ha muzaana wa Lakeeri̱ googo gaga: Daani̱ na Nafutaali. ");
INSERT INTO rub_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Mabara ga batabani̱ ba Zi̱ri̱pa muzaana wa Leeya, googo gaga: Gaadi̱ na Aseeri̱. Gagwo googo mabara ga batabani̱ ba Yakobbo, bayabyali̱i̱ri̱ Padanaramu. ");
INSERT INTO rub_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yakobbo yaadwereeri̱ I̱saka bbaawe, yaamwagi̱i̱rye mu kiikaru Mamu̱le, kinyakubba heehi̱ na Ki̱ryasi̱-araba (hataati̱ gyegebeerwe nka Hebbu̱rooni̱), I̱bbu̱rahi̱mu̱ na I̱saka ha bei̱calengi̱. ");
INSERT INTO rub_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","I̱saka yaadooseerye myaka ki̱ku̱mi̱ na kinaanei (180). ");
INSERT INTO rub_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Yaakwi̱ri̱ agu̱lu̱u̱si̱ri̱, yaahondera bahaahaawe, batabani̱ baamwe Esau̱ na Yakobbo baamuziika. ");
INSERT INTO rub_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Gaga googo mabara ga baana na beizukulu bʼEsau̱ (Esau̱ yeegebeerwe de nkʼEdomu̱). ");
INSERT INTO rub_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau̱ yaatu̱ngi̱ri̱ bakali̱ Banyakanani̱. Gaga googo mabara gaab̯u: Aada, muhara wa Eroni̱ Mu̱hi̱i̱ti̱, Oholibbama mukaa Esau̱ yaali muhara wa Aana, kandi mwizukulu wa Zi̱bbi̱yooni̱ Mu̱hi̱i̱vi̱, ");
INSERT INTO rub_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","na Bbasemaasi̱ muhara wʼI̱si̱mai̱ri̱ kandi nyaakaab̯u Nebayoosi̱. ");
INSERT INTO rub_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Gaga googo mabara ga batabani̱ bʼEsau̱: Eri̱faazi̱, yaabyali̱i̱rwe mu̱kali̱ akwetwa Aada, Rehu̱li̱ yaabyali̱i̱rwe mu̱kali̱ akwetwa Bbasemaasi̱, ");
INSERT INTO rub_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Yewu̱si̱, Yalaamu̱ na Koora baabyali̱i̱rwe mu̱kali̱ akwetwa Oholibbama. Gagwo googo mabara ga batabani̱ ba Esau̱ bayaabyeri̱ mu nsi Kanani̱. ");
INSERT INTO rub_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Nahahwo Esau̱ yaatweri̱ bakali̱ baamwe, batabani̱, bahara na bantu bensei̱ bamu makaa gaamwe, nte zaamwe, bisolo byamwe byensei̱, na bikwatu byamwe byensei̱ bi̱yaatu̱ngi̱ri̱ mu nsi gya Kanani̱, yaagyenda mu nsi gindi hadeiho na waab̯u Yakobbo. ");
INSERT INTO rub_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Esau̱ na Yakobbo bensei̱ baalingi na magana ganene. Hab̯wakubba nsi gyali gi̱dooli̱, baali batakusobora kwicala mu kiikaru ki̱mwei̱ ku̱li̱i̱si̱i̱rya hamwei̱ magana gaab̯u gensei̱. ");
INSERT INTO rub_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Nahab̯waki̱kyo, Esau̱ yaagyendi̱ri̱ kwicala mu nsi gya mu nsahu za Sei̱ri̱. (Esau̱ de yooyo yeegebeerwe nka Edomu̱.) ");
INSERT INTO rub_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Lulu lwolwo lubyalu lwa Esau̱ haaha ba Edomu̱, bantu banyakwicalanga mu nsi gya nsahu za Sei̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Gaga googo mabara ga batabani̱ ba Esau̱: Eri̱faazi̱ ali mu̱tabani̱ wʼAada mukaa Esau̱ kandi Rehu̱li̱ naabba mu̱tabani̱ wa Bbasemaasi̱ mukaa Esau̱. ");
INSERT INTO rub_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Gaga googo mabara ga batabani̱ ba Eri̱faazi̱: Temaani̱, Omara, Zeefo, Gataamu, na Kenazi̱. ");
INSERT INTO rub_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Ti̱mu̱na yaali mu̱kali̱ wondi wʼEri̱faazi̱ mu̱tabani̱ wa Esau̱. Ti̱mu̱na yaabyeri̱ mu̱tabani̱ gibakweta Amaleki̱. Bab̯wo boobo baalingi beizukulu bʼAada mukaa Esau̱. ");
INSERT INTO rub_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Gaga googo mabara ga batabani̱ ba Rehu̱li̱: Nahati̱, Zeera, Saama na Mi̱i̱za. Bab̯wo boobo beizukulu ba Bbasemaasi̱ mukaa Esau̱. ");
INSERT INTO rub_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Oholibbama mukaa Esau̱ yaali muhara wʼAana, kandi mwizukulu wa Zi̱bbi̱yooni̱. Baana baamwe baalingi: Yewu̱si̱, Yalaamu̱ na Koora. ");
INSERT INTO rub_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Gaga googo mabara ga beizukulu bʼEsau̱ banyaakufooka balemi̱ ba nganda zaab̯u. Baali batabani̱ bʼEri̱faazi̱ mu̱zegei̱zo wʼEsau̱ boobo baba: Temaani̱, Omara, Zeefo, Kenazi̱, ");
INSERT INTO rub_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Koora, Gataamu nʼAmaleki̱, baba baali balemi̱ nibali beizukulu bʼEri̱faazi̱ banyakwicalanga mu nsi. De boobo beizukulu ba Aada, mukaa Esau̱. ");
INSERT INTO rub_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Mabara ga batabani̱ ba Rehu̱li̱ mu̱tabani̱ wʼEsau̱, banyaakufooka balemi̱ googo: Nahati̱, Zeera, Saama, na Mi̱i̱za. Baba baali beizukulu ba Bbasemaasi̱ mukaa Esau̱. ");
INSERT INTO rub_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Mabara ga batabani̱ ba Olibbama mukaa Esau̱, banyaakufooka balemi̱ ba nganda googo gaga: Yewu̱si̱, Yalaamu̱, na Koora. Oholibbama yogwo yaali muhara wʼAana. ");
INSERT INTO rub_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Bab̯wo bensei̱ baalingi batabani̱ bʼEsau̱ (Esau̱ yeegebeerwe de nkʼEdomu̱) kandi googo mabara ga balemi̱ baab̯u. ");
INSERT INTO rub_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Baba boobo batabani̱ ba Sei̱ri̱ Mu̱hooli̱, bei̱cali̱ ba mu nsi gya Edomu̱: Lotani̱, Sobbaali̱, Zi̱bbi̱yooni̱, Aana, ");
INSERT INTO rub_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Di̱soni̱, Ezeri̱ na Di̱sani̱. Baba boobo balemi̱ ba nganda za Bahooli̱ batabani̱ ba Sei̱ri̱ bei̱cali̱ ba mu kicweka kyʼEdomu̱. ");
INSERT INTO rub_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Mabara ga batabani̱ ba Lotani̱ googo gaga: Hoori̱ na Hemaami̱, kandi ibara lya nyaakaab̯u Lotani̱ lyali Ti̱mu̱na. ");
INSERT INTO rub_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Mabara ga batabani̱ ba Sobbaali̱ googo gaga: Ali̱vaani̱, Manahaasi, Ebbali̱, Seefo, na Onamu. ");
INSERT INTO rub_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Mabara ga baana ba Zi̱bbi̱yooni̱ googo gaga: Aaya na Aana. Aana yooyo munyakwagya mazi̱ba gaku̱lwa meezi̱ gahyo mu nsi gya mwirungu b̯uyaali ku̱li̱i̱sya ndogoyi̱ za Zi̱bbi̱yooni̱ bbaawe. ");
INSERT INTO rub_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Mabara ga baana bʼAana googo gaga: Di̱soni̱ nʼOholibbama muhara wʼAana. ");
INSERT INTO rub_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Mabara ga baana ba Di̱soni̱ googo gaga: Hemu̱daani̱, Esu̱bbaani̱, I̱tu̱raani̱, na Kerani̱. ");
INSERT INTO rub_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Mabara ga baana bʼEzeri̱ googo gaga: Bi̱ri̱haani̱, Zavaani̱, na Akani̱. ");
INSERT INTO rub_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Mabara ga baana ba Di̱sani̱ googo gaga: U̱zi̱ na Arani̱. ");
INSERT INTO rub_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Gagwo googo mabara ga balemi̱ ba Bahooli̱: Lotani̱, Sobbaali̱, Zi̱bbi̱yooni̱, Aana, ");
INSERT INTO rub_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Di̱soni̱, Ezeri̱ na Di̱sani̱. Gagwo googo mabara ga balemi̱ ba Bahooli̱ nka nganda zaab̯u zaali zili mu nsi Sei̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Baba boobo bakama banyakulemanga Edomu̱, I̱saleeri̱ gi̱takabbeeri̱ kubba na mukama. ");
INSERT INTO rub_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bbeera mu̱tabani̱ wa Bbeyoora yaalemi̱ri̱ Edomu̱, ibara lya rub̯uga lwamwe lyolyo Dinahaba. ");
INSERT INTO rub_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bbeera b̯u̱yaakwi̱ri̱, Yobbabbu̱ mu̱tabani̱ wa Zeera mwi̱cali̱ wa mu rub̯uga lubakweta Bbozi̱ra yaadya b̯ukama. ");
INSERT INTO rub_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobbabbu̱ b̯u̱yaakwi̱ri̱, Husaamu mwi̱cali̱ wa mu nsi gya Batemani̱ yaadya b̯ukama. ");
INSERT INTO rub_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husaamu b̯u̱yaakwi̱ri̱, Hadaadi̱ mu̱tabani̱ wa Bbedaadi̱ munyakubinga Bami̱dyani̱ mu nsi Mowaabbu yaadya b̯ukama, ibara lya rub̯uga lwamwe lwolwo Avi̱i̱ti̱. ");
INSERT INTO rub_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadaadi̱ b̯u̱yaakwi̱ri̱, Samura mwi̱cali̱ wa mu rub̯uga lwa Masi̱reka yaadya b̯ukama. ");
INSERT INTO rub_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samura b̯u̱yaakwi̱ri̱, Sawu̱u̱li̱ mwi̱cali̱ wa mu nsi gya Rehobboosi̱ gili heehi̱ na mugira Efu̱raati̱ yaadya b̯ukama. ");
INSERT INTO rub_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Sawu̱u̱li̱ b̯u̱yaakwi̱ri̱, Bbaali̱-hanani̱ mu̱tabani̱ wa Aki̱bbora yaadya b̯ukama. ");
INSERT INTO rub_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Bbaali̱-hanani̱ mu̱tabani̱ wa Aki̱bbora b̯u̱yaakwi̱ri̱, Hadara yaadya b̯ukama, ibara lya rub̯uga lwamwe lwolwo Pau̱, ibara lya mu̱kali̱ waamwe lyolyo Mahetabbeeri̱, muhara wa Mati̱reedi̱, Mati̱reedi̱ yaali muhara wa Mezeehaabbu̱. ");
INSERT INTO rub_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Gaga googo mabara ga balemi̱ ba luganda lwa Esau̱, nka nganda zaab̯u kuzaali mu gi̱gyo nsi gi̱becalengi̱mwo: Ti̱mu̱na, Alu̱va, Yeteeti̱, ");
INSERT INTO rub_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibbama, Ela, Pi̱nooni̱, ");
INSERT INTO rub_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenazi̱, Temaani̱, Mi̱b̯u̱zaara, ");
INSERT INTO rub_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magi̱deeri̱ nʼI̱ramu̱, gagwo googo mabara ga balemi̱ bʼEdomu̱ (Esau̱ yooyo bba bʼEdomu̱), nka kubaalingi mu nsi gi̱batu̱ngi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakobbo yei̱ceeri̱ mu nsi gya Kanani̱ ha bbaawe I̱saka yei̱calengi̱. ");
INSERT INTO rub_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Bibi byobyo binyakubbaho ha mu̱gi̱ gwa Yakobbo. Yozefu̱ mu̱tabani̱ waamwe wa myaka i̱ku̱mi̱ na musanju mya b̯u̱handu̱, b̯u̱yaali̱i̱syengi̱ ntaama na mbu̱li̱ za bbaawe, naazi̱li̱i̱si̱i̱rya hamwei̱ na baab̯u nibali batabani̱ ba Bbi̱li̱ha na Zi̱ri̱pa bamukaabbaawe. Yozefu̱ yaalegi̱ri̱ baab̯u hali bbaawaab̯u hab̯wa nsobi̱ zi̱baakorengi̱. ");
INSERT INTO rub_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","I̱saleeri̱ yendyengi̱ Yozefu̱ kukira baana baamwe bandi bensei̱, hab̯wakubba yooyo yaali mwana waamwe wa mu b̯u̱gu̱lu̱u̱su̱. Yaamu̱su̱ngi̱i̱ri̱ kilwalu kirungi. ");
INSERT INTO rub_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Bei̱tu̱ baab̯u b̯u̱baaweeni̱ nti bbaawaab̯u akwendya hoi̱ Yozefu̱ kukira bo, baanoba Yozefu̱ batakei̱re ku̱mu̱bazi̱ri̱i̱rya kurungi. ");
INSERT INTO rub_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Kiro ki̱mwei̱, Yozefu̱ yaalooti̱ri̱ kilooto, b̯u̱yaaki̱soboleeri̱ baab̯u, baamunobera ki̱mwei̱. ");
INSERT INTO rub_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Yozefu̱ yaakoba yati, “Mwetegeerye mbaweere kilooto kinyalooti̱ri̱: ");
INSERT INTO rub_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Twakali mu musiri nitukubboha biza bya nganu, kikuhuniriza kiza kyange kyamaari̱ gabyoka nikyemeera tengerete, kandi biza byenyu̱ byakyelogoleerya ni̱byetu̱lu̱ka hansi kuntamwo ki̱ti̱i̱ni̱sa.” ");
INSERT INTO rub_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Mwomwo baab̯u baamu̱b̯u̱u̱lya nibakoba yati, “Okutekereza olibba mukama weetu̱, otuleme?” Nahab̯waki̱kyo, baamu̱nobeeri̱ ki̱mwei̱ na kukirahoona makadei, hab̯wa bilooto na bigambu byamwe. ");
INSERT INTO rub_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Hei̱nyu̱ma, yei̱ra yaaloota kilooto kindi, nakyo yaakisoboora baab̯u naakoba yati, “Nyab̯u̱u̱ni̱i̱rye nyaaloota kilooto kindi, ha murundi gugu, lyoba, mweri̱ na nzota i̱ku̱mi̱ na gi̱mwei̱, ni̱byetu̱lu̱ka hansi kuntamwo ki̱ti̱i̱ni̱sa.” ");
INSERT INTO rub_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Bei̱tu̱ b̯u̱yaaki̱soboleeri̱ bbaawe, I̱saleeri̱ yeegebeerwe de nka Yakobbo, na baab̯u, bbaawe yaamucomera naakoba yati, “Ki̱kyo kilooto, oloti̱ri̱ kya mu̱li̱ngo kyani? Okutekereza gya, mmaawu na beenyu̱ tukugyenda kwetu̱lu̱ka hansi kukutamwo ki̱ti̱i̱ni̱sa?” ");
INSERT INTO rub_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Baab̯u baamu̱kwati̱i̱rwe i̱hali̱, bei̱tu̱ bbaawe yei̱ceeri̱ naatekerezanga hoi̱ ha ki̱kyo kilooto. ");
INSERT INTO rub_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Kiro ki̱mwei̱, baab̯u Yozefu̱ baagyendi̱ri̱ ku̱li̱i̱sya ntaama za bbaawaab̯u mu nsi gya Sekemu̱. ");
INSERT INTO rub_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","I̱saleeri̱ yeeti̱ri̱ Yozefu̱ yaamuweera naakoba yati, “Beenyu̱ bali̱mu̱ku̱li̱i̱sya ntaama mu Sekemu̱, i̱za nkutumeyo.” Yozefu̱ yei̱ri̱ri̱mwo I̱saleeri̱ naakoba yati, “Ee, bbaabba.” ");
INSERT INTO rub_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Bbaawe yaamwi̱ri̱ri̱mwo naakoba yati, “Gyenda owone beenyu̱ nka kubali, na ntaama nka kuzili, oi̱re ombwere.” Nahahwo bbaawe yaamu̱tu̱mi̱ri̱ yaaruga mu kihanga kya Hebbu̱rooni̱, yaagyenda Sekemu̱. ");
INSERT INTO rub_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Yozefu̱ b̯u̱yaadoori̱ Sekemu̱ mu mali̱i̱si̱i̱ryo, yaarombayo mudulu wondi. Yogwo mudulu yaagi̱i̱rye Yozefu̱ naaku̱pu̱mpu̱u̱ta yaamu̱b̯u̱u̱lya naakoba yati, “Oku̱toolya kyani?” ");
INSERT INTO rub_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yozefu̱ yaamwi̱ri̱ri̱mwo naakoba yati, “Nku̱toolya beetu̱. Nku̱kwesengereerya, mbwera cali baku̱li̱i̱si̱i̱rya ntaama.” ");
INSERT INTO rub_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Mudulu yaamwi̱ri̱ri̱mwo naakoba yati, “Haha baaru̱gi̱ri̱ho, nyaabeegwi̱ri̱ nibakukoba yati, ‘Tugyende Dosani̱.’ ” Nahaahwo, Yozefu̱ yaahondeeri̱ baab̯u yaabaagya Dosani̱. ");
INSERT INTO rub_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","B̯u̱baamu̱weeni̱ naacaali hadei, atakabadwerereeri̱, bakora rukwe ku̱mwi̱ta. ");
INSERT INTO rub_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Baaweeragana nibakoba yati, “Muloota bilooto ngogwo ei̱zi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Kaka kooko kasu̱mi̱ ka ku̱mwi̱ta tumugume mu ki̱i̱na, hei̱nyu̱ma twakoba kisolo kya mwirungu kyamu̱di̱i̱ri̱. Kasi tuwone mugasu gwa bilooto byamwe.” ");
INSERT INTO rub_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Bei̱tu̱ Lu̱bbeeni̱ b̯u̱yeegwi̱ri̱ rukwe lwa baab̯u kwi̱ta Yozefu̱, yaalwani̱sya kumujuna. Yaaweera baab̯u naakoba yati, “Tu̱tamwi̱ta.” ");
INSERT INTO rub_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Lu̱bbeeni̱ yei̱ri̱ri̱ yaabaweera naakoba yati, “Mutakisura kubbwoma ibbanga lyamwe, hakiri mumugume mu ki̱i̱na kya mwirungu, bei̱tu̱ mutamukora kabii kensei̱ ha mubiri gwamwe.” Kinyakumuha kubaza ki̱kyo, yendyengi̱ amu̱honi̱e lu̱ku̱u̱, amwemu̱kye hali bbaawe nali mwomi. ");
INSERT INTO rub_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Yozefu̱ b̯u̱yaadoori̱ hali baab̯u, bamusomolamwo kilwalu kyamwe kirungi kiyaali alweri̱. ");
INSERT INTO rub_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Baamutwala bamuguma mwi̱zu̱ba litalimwo meezi̱. ");
INSERT INTO rub_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","B̯ubaali nibakudya, baabyokeerye mei̱so baawona lugologombo lwa Bei̱si̱mai̱ri̱, nibakuruga Gi̱ryadi̱ nibali na ngamira zeetweki̱ri̱ b̯ubbaani, b̯u̱ku̱wu̱nya na mugaaju nibali mu muhanda gwab̯u, nibakubitwala Mi̱si̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yu̱da yaab̯u̱u̱li̱i̱rye baab̯u naakoba yati, “Kyamugasu ki kwi̱ta weetu̱, ntukabisa nsita? ");
INSERT INTO rub_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Hakiri tu̱mu̱tu̱ndi̱sye Bei̱si̱mai̱ri̱, tutamukoraho kabii, kubba nayo ali weetu̱, ali mubiri neibbanga lyetu̱.” Kandi de, baab̯u bei̱ki̱ri̱i̱ze. ");
INSERT INTO rub_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Basu̱u̱b̯u̱zi̱ Bami̱dyani̱ b̯ubaalingi nibakurabaho, baab̯u Yozefu̱ baamutoola mu ki̱i̱na, baamutunda hali Bei̱si̱mai̱ri̱ ha muhendu gwa bicweka bya feeza maku̱mi̱ gabiri, Bei̱si̱mai̱ri̱ baatwala Yozefu̱ mu Mi̱si̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Lu̱bbeeni̱ b̯u̱yei̱ri̱ri̱ ha ki̱i̱na akaagya Yozefu̱ atalimwo, yaatemwi̱ri̱ ngoye zaamwe. ");
INSERT INTO rub_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Yeeri̱ri̱ hali baab̯u yaabaweera naakoba yati, “Musigazi katali mu ki̱i̱na, gya hataati̱ nkwate gwa hanya?” ");
INSERT INTO rub_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Nahahwo baasaari̱ mbu̱li̱, baasenga kilwalu kirungi kya Yozefu̱ baakijub̯uka mwibbanga. ");
INSERT INTO rub_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Kilwalu kiki baaki̱tweri̱ hali bbaawaab̯u nibakoba yati, “Tu̱komi̱ri̱ kilwalu kiki, banza oki̱li̱ngani̱e owone kyakabba nikili kya mu̱tabani̱ waamu.” ");
INSERT INTO rub_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Yakobbo yaaki̱lengeeri̱ yaakoba yati, “Kilwalu kiki kwo kya mwana wange. Mu mananu Yozefu̱ kisolo kili na kubba kyamu̱di̱i̱ri̱, kandi kyamusabbasabbula mu bipacu!” ");
INSERT INTO rub_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Nahab̯waki̱kyo, Yakobbo yaatemwi̱ri̱ bilwalu byamwe, yaalwala bi̱goye bikuhala, yaamaari̱ biro binene naacakalira mwana waamwe. ");
INSERT INTO rub_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Batabani̱ na bahara baamwe bensei̱, baagereeryeho ku̱mu̱tati̱i̱rya, bei̱tu̱ atakatatiire, mwomwo yaakoba yati, “Haahi, nkulira ku̱doosya b̯undihondera mwana wange kuzumu.” Bbaawe yei̱ceeri̱ naaliranga mu̱tabani̱ waamwe. ");
INSERT INTO rub_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Mu kasu̱mi̱ kakwo Bami̱dyani̱ baalingi bamaari̱ kutunda Yozefu̱ mu nsi gya Mi̱si̱ri̱, baamu̱tu̱ndi̱ri̱ hali Poti̱fa mu̱handu̱ wa bali̱ndi̱ ba Faraaho. ");
INSERT INTO rub_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Mu kasu̱mi̱ kakwo, Yu̱da yaaru̱gi̱ri̱ hali baab̯u, yaagyenda mu kicweka kindi yaabi̱mba heema gyamwe, yeicala na mudulu wa mu rub̯uga lwʼAdu̱ramu̱ gi̱beetengi̱ Hi̱i̱ra. ");
INSERT INTO rub_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Ku̱kwo hooho Yu̱da yaawoneeri̱ muhala Mu̱kanani̱, muhara wa Su̱u̱ha, yaamuswera. ");
INSERT INTO rub_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Yeemeti̱ri̱ yaabyala mwana wa b̯udulu gibakweta Eeri̱. ");
INSERT INTO rub_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Yei̱ri̱ri̱ yaabyala mwana wondi, yaamweta ibara Onani̱. ");
INSERT INTO rub_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Mu̱tabani̱ waamwe wondi wakasatu, yaamweti̱ri̱ ibara Seera. Seera baamu̱byeri̱ nibakwicala mu kicweka ki̱beetengi̱ Kezi̱i̱bbu̱. ");
INSERT INTO rub_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yu̱da yaaswerereeri̱ mu̱tabani̱ waamwe mu̱handu̱ Eeri̱, mu̱kali̱ gi̱beetengi̱ Tamali̱. ");
INSERT INTO rub_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Bei̱tu̱ Eeri̱, mu̱zegei̱zo wa Yu̱da, yaakoori̱ bibiibi binene mu mei̱so ga Mukama, kasi Mukama yaamwi̱ta. ");
INSERT INTO rub_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Nahaahwo, Yu̱da yaaweereeri̱ mu̱tabani̱ waamwe Onani̱ naakoba yati, “Gyenda otunge mukaa weenyu̱, omubyalire baana.” ");
INSERT INTO rub_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Bei̱tu̱ Onani̱ b̯u̱yeetegeri̱i̱ze baana baakubyala kubatalibba baamwe, b̯uli b̯uyaakalaalanga na mukaawaab̯u, meezi̱ ga lubyalu yaagabbwomengi̱ hansi, aleke atalibyalira waab̯u baana. ");
INSERT INTO rub_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ki̱kyo kikorwa ki̱yaakorengi̱, kyali kibiibi hali Mukama, nayo Mukama yaamwi̱ta. ");
INSERT INTO rub_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Kasi mwomwo Yu̱da yaaweera Tamali̱ mukaamwana waamwe naakoba yati, “Weemuka kwamwenyu̱, oicale nooli mu̱kaamu̱kwere, ku̱doosya mu̱tabani̱ wange Seera walihanda.” Hab̯wakubba Yu̱da yaateekeri̱i̱ze nti, mu̱tabani̱ waamwe Seera nayo asobora ku̱kwa nka baab̯u ku bakwi̱ri̱. Mwomwo Tamali̱ yaagyenda kwicala kwamwawu̱. ");
INSERT INTO rub_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Kasu̱mi̱ b̯u̱karabi̱ri̱ho, mukaa Yu̱da muhara wa Su̱u̱ha, yaakwa. Yu̱da b̯u̱yaaru̱gi̱ri̱ mu kiseege kya kufeerwa mu̱kali̱ waamwe, yaagyenda Ti̱mu̱na mu bantu banyakusalanga byoza bya ntaama zaamwe, yaagyendi̱ri̱ na munywanwe Hi̱i̱ra Mu̱du̱ramu̱. ");
INSERT INTO rub_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tamali̱ b̯u̱baamu̱weereeri̱ nti, mu̱geni̱ waamwe alimukugyenda wu Ti̱mu̱na kusala byoza bya ntaama zaamwe, ");
INSERT INTO rub_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Tamali̱ yaaku̱u̱su̱u̱ri̱mwo kilwalu kyamwe ki̱kwolokya nka kwali mu̱kaamu̱kwere, yeebbumba kilwalu kindi aleke batamulengera. Yei̱caali̱i̱ri̱ heirembu lya rub̯uga lubakweta Enayi̱mu̱ lunyakubbanga ha muhanda gukutwala Ti̱mu̱na. Kiki yaaki̱koori̱ hab̯wakubba Seera nab̯u̱yaahandi̱ri̱ batakamumuhe amutunge. ");
INSERT INTO rub_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Yu̱da b̯u̱yaamu̱weeni̱ yaateekerezengi̱ ali malaaya, kubba yaali yeebbu̱mbi̱ri̱ b̯u̱syo. ");
INSERT INTO rub_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Yu̱da atakakyetegereze mu̱kali̱ yogwo nka kuyaali mukaamwana, yaagyenda haliyo pembeeni̱ wa ru̱gu̱u̱do cali yaali ei̱caali̱i̱ri̱, yaamuweera naakoba yati, “I̱za hataati̱, ndaale nawe.” Mu̱kali̱ yaamu̱b̯u̱u̱lya naakoba yati, “Kyani kyokwi̱za kumpa, nyaakalaala nawe?” ");
INSERT INTO rub_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Yu̱da yaamwi̱ri̱ri̱mwo naakoba yati, “Nkwi̱za kukuha ruusi gya mbu̱li̱ kuruga mwigana lyange.” Mu̱kali̱ yei̱ri̱ri̱mwo naakoba yati, “Nzi̱ki̱ri̱i̱ze, kyonkei okwi̱za kumpa musimbo gundicala nagwo, ku̱doosya b̯wolileeta gi̱gyo ruusi gya mbu̱li̱.” ");
INSERT INTO rub_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Yu̱da yaab̯u̱u̱lya mu̱kali̱ naakoba yati, “Nkuhe musimbo kyani?” Mu̱kali̱ yei̱ri̱ri̱mwo naakoba yati, “Mpa mpi̱ta giloho ibara lyamu, kaguha ka mwi̱coti̱ kaagyo na mubbeere gwamu gwokweti̱.” Bi̱byo bintu yaabi̱mu̱heeri̱, kasi yaalaala nayo, yaamali̱ri̱i̱ri̱ yeemeti̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Mu̱kali̱ yogwo yaabyoki̱ri̱, yeeb̯uula kilwalu kiyaali yeebbu̱mbi̱ri̱i̱ri̱, yei̱ra yaalwala kilwalu kyamwe ki̱kwolokya nka kuyaali mu̱kaamu̱kwere. ");
INSERT INTO rub_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yu̱da b̯u̱yaatu̱mi̱ri̱ munywanwe Mu̱du̱ramu̱ kutwala gi̱gyo ruusi gya mbu̱li̱ hali mu̱kali̱ aleke asyomeyo musimbo, atakagyeyo yogwo mu̱kali̱. ");
INSERT INTO rub_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Yaab̯u̱u̱lya bantu ba mu ki̱kyo kiikaru naakoba yati, “Malaaya wa mu mbandwa munyakubba ei̱cali̱i̱ri̱ ha rubaju lwa gugu muhanda, ali hanya?” Baamwi̱ri̱ri̱mwo nibakoba yati, “Haha tihakabbangaho malaaya wa mu mbandwa wondi yensei̱.” ");
INSERT INTO rub_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Mwomwo Hi̱i̱ra yaakuba hali Yu̱da, yaamuweera naakoba yati, “Mu̱kali̱ waahi̱yo, kandi na bantu bambwereeri̱ mu ki̱kyo kiikaru, tihakabbangayo malaaya wa mu mbandwa wondi yensei̱.” ");
INSERT INTO rub_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yu̱da yei̱ri̱ri̱mwo naakoba yati, “Leka abiike bi̱byo bintu yankei, ti̱tu̱kwendya kuswara, nyaakali ndwani̱si̱i̱rye kumusasula ruusi gya mbu̱li̱, bei̱tu̱ otakamwagyeyo.” ");
INSERT INTO rub_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","B̯u̱harabi̱ri̱ho myeri̱ nka misatu, bantu baaweera Yu̱da nibakoba yati “Tamali̱ mukaamwana waamu, yaafooki̱ri̱ malaaya, kandi nahab̯waki̱kyo yaamali̱ri̱i̱ri̱ yeemeti̱ri̱.” Yu̱da yaabazi̱ri̱ naakoba yati, “Mumuleete haha aleke bamwokye, akwe.” ");
INSERT INTO rub_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","B̯ubaali nibakumuleeta, yaatu̱mi̱i̱ri̱ mu̱geni̱ waamwe yaamuweera naakoba yati, “Mukama bintu bibi, yooyo mudulu munyakuntweka nda.” Yei̱ri̱ri̱ yaabaza naakoba yati, “Nkwesengereerye, lengera mpi̱ta giloho ibara, kaguha ka mwi̱coti̱ kaagyo na gu̱gwo mubbeere, bili bya naani?” ");
INSERT INTO rub_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yu̱da yei̱ki̱ri̱i̱ze bi̱byo bintu nka kubili byamwe, kandi yaakoba yati, “Yogo mu̱kali̱ ali wamananu kunkira, hab̯wakubba ntakamuhe mu̱tabani̱ wange Seera kumutunga.” Kuruga nab̯u̱b̯wo, atakei̱re kulaala nayo. ");
INSERT INTO rub_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Kasu̱mi̱ kaamwe ka kubyala b̯u̱kaadoori̱, kyazooki̱ri̱ akugyenda kubyala barongo. ");
INSERT INTO rub_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","B̯uyaali nakubyala, mwana omwei̱ mu bo ahu̱lu̱kya ngalu, mu̱byali̱sya yaakweti̱ kahu̱u̱zi̱ kengu̱ yaakamubboha ha ngalu naakoba yati, “Yogo yooyo mwana abanzi̱ri̱ kuhuluka.” ");
INSERT INTO rub_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Bei̱tu̱ yogwo mwana yei̱ri̱ryeyo ngalu gyamwe mu nda, kasi waab̯u yooyo kandi yaahuluka. Nahab̯waki̱kyo, mu̱byali̱sya yaabazi̱ri̱ naakoba yati, “Ee kandi we, obanzi̱ri̱ teetei̱ kuhuluka!” Kyokyo baamweteeri̱ ibara Pereezi̱. ");
INSERT INTO rub_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Kasi hei̱nyu̱ma, waab̯u yaahuluka mubbohe kahu̱u̱zi̱ kengu̱ ha ngalu, baamweta ibara Zeera. ");
INSERT INTO rub_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Bei̱si̱mai̱ri̱ baatweri̱ Yozefu̱ mu nsi gya Mi̱si̱ri̱. Baamutunda hali Poti̱fa, omwei̱ hali balemi̱ bahandu̱ ba Faraaho, naali Mu̱nyami̱si̱ri̱ kandi mu̱du̱mi̱ri̱ wa bali̱ndi̱ ba Faraaho. ");
INSERT INTO rub_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Mukama yaali na Yozefu̱ kandi Yozefu̱ yaabba mu̱zi̱ngu̱zi̱ mu b̯uli kiyakakoranga. Yei̱calengi̱ mu nnyu̱mba gya Poti̱fa, mukama waamwe Mu̱nyami̱si̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Poti̱fa yaaweeni̱ Mukama nka ku̱yaakonyeerengi̱ Yozefu̱ kukora bintu birungi. ");
INSERT INTO rub_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Nahab̯waki̱kyo, Poti̱fa yaasi̱i̱mi̱ri̱ Yozefu̱ kandi yaamufoora muheereza waamwe akujunanizib̯wa na kuwoneera nnyu̱mba gyamwe na bintu byensei̱ biyaali nabyo. ");
INSERT INTO rub_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Kuruga b̯u̱yaamu̱heeri̱ b̯u̱handu̱ b̯wa kuwoneera nnyu̱mba gyamwe, hamwei̱ na bintu byensei̱ biyaali nabyo, Mukama yaaheeri̱ mu̱gi̱sa mannyu̱mba ga Banyami̱si̱ri̱, hab̯wa Yozefu̱, mu̱gi̱sa gwa Mukama gwadoori̱ ha b̯uli kintu kya Poti̱fa kyensei̱, binyakubba mu nnyu̱mba na mu misiri. ");
INSERT INTO rub_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Nahab̯waki̱kyo, Poti̱fa yaakwati̱i̱rye b̯uli kintu kyamwe kyensei̱ Yozefu̱ yooyo akilingirire. Poti̱fa atakekengerenge kintu kyensei̱ kya mu nnyu̱mba gyamwe, otoori̱ho bidyo bi̱yaadyengi̱ bisa. Yozefu̱ yaali njuruute gya mudulu kandi aku̱nyi̱ri̱ra. ");
INSERT INTO rub_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Hei̱nyu̱ma wa kasu̱mi̱ kadooli̱, mukaa Poti̱fa yaaweeni̱ Yozefu̱ nka kwali mu̱semeru̱, yaakoba yati, “I̱za tulaale hamwei̱ mu ntabbu.” ");
INSERT INTO rub_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Bei̱tu̱ Yozefu̱ yaaswi̱ri̱ kukikora. Yozefu̱ yaamuweera naakoba yati, “Wona, mukama wange tali na kintu kyensei̱ kyanyeekengera mu gigi nnyu̱mba, kandi yampeeri̱ b̯ujunanizib̯wa kulinda b̯uli kintu kyamwe kyensei̱. ");
INSERT INTO rub_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Mu gigi nnyu̱mba, yampeeri̱ b̯u̱sobozi̱ b̯wensei̱, takangananga ku̱koresya kintu kyensei̱, kutoolaho we, kubba oli mu̱kali̱ waamwe. Nsobora teetei̱ kukora kibii kikooto nka ki̱kyo nkaheneera Ruhanga?” ");
INSERT INTO rub_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Mukaa Poti̱fa yogwo naab̯uyakamunwenwekanga b̯uli kiro alaale nayo, bei̱tu̱ Yozefu̱, atakamwikirizenge. Atakekirizenge na ku̱mwesegereerya. ");
INSERT INTO rub_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Kiro ki̱mwei̱, Yozefu̱ yei̱ngi̱i̱ri̱ mu nnyu̱mba kukora milimo myamwe mya b̯uli kiro. Mu nnyu̱mba gi̱gyo hatakabbemwo muheereza wondi yensei̱. ");
INSERT INTO rub_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Mu̱kali̱ yaakweti̱ ha kilwalu kya Yozefu̱ yaakoba yati, “Hataati̱ olina kulaala nagya.” Bei̱tu̱ Yozefu̱ yei̱ru̱ki̱ri̱ hanzei, yaamu̱ti̱ga akweti̱ kilwalu mu ngalu. ");
INSERT INTO rub_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Mu̱kali̱ b̯u̱yaaweeni̱ Yozefu̱ ei̱ru̱ki̱ri̱ kandi amu̱ti̱gi̱i̱ri̱ kilwalu mu ngalu zaamwe, ");
INSERT INTO rub_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","yeeta baheereza baamwe yaabaweera naakoba yati, “Muwone mudulu Muhebburaniya weibange gi̱yaatu̱leteeri̱ alimwo ku̱tu̱jooga. Yanzi̱ngi̱ri̱i̱ri̱ mu ki̱si̱i̱ka kyange kumpamba, bei̱tu̱ nyaaluka neiraka lya hakyendi̱ hoi̱. ");
INSERT INTO rub_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Mudulu b̯u̱yeegwi̱ri̱ nyaalu̱ki̱ri̱ na maani hoi̱, yanti̱gi̱ra kyakulwala kyamwe, yei̱ru̱ka hanzei.” ");
INSERT INTO rub_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Nahaahwo, mukaa Poti̱fa yaabi̱i̱ki̱ri̱ kilwalu kya Yozefu̱ ku̱doosya i̱baawe b̯uyeeri̱ri̱ kwamu̱gi̱. ");
INSERT INTO rub_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Kasi yaamuweera bigambo byonyini bi̱yaaweereeri̱ baheereza baamwe, naakoba yati, “Muhebburaniya waamu gi̱waaleti̱ri̱ yei̱zi̱ri̱ yanzingiira mu ki̱si̱i̱ka kyange naakwendya kumpamba. ");
INSERT INTO rub_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Bei̱tu̱ b̯u̱nyaalu̱ki̱ri̱ ni̱nkwendya banjune, kasi yeeru̱ka hanzei yanti̱gi̱ra kyakulwala kyamwe.” ");
INSERT INTO rub_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Poti̱fa b̯uyaali naacakamala b̯u̱mali̱ kwegwa bigambo bya mu̱kalwe yaamu̱weereeri̱ naakoba yati, “Kwokwo yatyo mwiru waamu yankoori̱,” Poti̱fa yaakwatwa ki̱ni̱ga kinene. ");
INSERT INTO rub_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Poti̱fa yaakweti̱ Yozefu̱ yaamuta mu nkomo cali yaabboherengi̱ banyankomo ba Faraaho, mukama wa Mi̱si̱ri̱. Bei̱tu̱ Yozefu̱ b̯uyaali mu nkomo, ");
INSERT INTO rub_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Mukama yaali na Yozefu̱ kandi yaamwolokya ngonzi zinene, yaamuha kuganja hali mu̱handu̱ wa nkomo. ");
INSERT INTO rub_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Kasi mu̱handu̱ wa nkomo, yaata Yozefu̱ kubba yooyo naakujunanizib̯wa na banyankomo na byensei̱ binyakukorwanga mu nkomo. ");
INSERT INTO rub_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Mu̱handu̱ wa nkomo atakei̱re kwelalikiira kintu kyensei̱ mu nkomo kya Yozefu̱ yaaju̱nani̱zi̱b̯wengi̱, kubba Mukama yaabbengi̱ na Yozefu̱ kandi kyensei̱ kya Yozefu̱ yaakakoranga, Mukama yaamu̱konyerengi̱ kukikora kurungi. ");
INSERT INTO rub_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Hei̱nyu̱ma, muheereza mu̱handu̱ wa byakunywa wa mukama na muheereza mu̱handu̱ wa bati̱mba migaati, baasali̱i̱ze mukama waab̯u, yooyo mukama wa Mi̱si̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Faraaho, mukama wa Mi̱si̱ri̱, yaabi̱hi̱ri̱i̱rwe bab̯wo baheereza baamwe babiri, ");
INSERT INTO rub_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","yaabata mu nkomo cali Yozefu̱ yaali abboheerwe. ");
INSERT INTO rub_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Mu̱handu̱ wa nkomo yaabakwati̱i̱rye Yozefu̱ abawoneere. Kasu̱mi̱ kabaali mu nkomo, ");
INSERT INTO rub_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","i̱jolo li̱mwei̱, bensei̱ babiri baalooti̱ri̱ bilooto, b̯uli kilooto kyali na makuru gaakyo. ");
INSERT INTO rub_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Yozefu̱ b̯u̱yaabadwerereeri̱ mwakya karei, yaawona ku̱beelali̱ki̱ri̱i̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Nahab̯waki̱kyo, yaab̯u̱u̱lya baheereza ba Faraaho banyaakubba mu nkomo nayo mu nnyu̱mba gya Poti̱fa, mukama waamwe, naakoba yati, “Kyani ki̱mwelali̱ki̱ri̱i̱ri̱ deeru?” ");
INSERT INTO rub_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Baamwi̱ri̱ri̱mwo nibakoba yati, “Tu̱looti̱ri̱ bilooto, bei̱tu̱ tulemeerwe yaabitusoboora makuru gaabyo.” Yozefu̱ yaabei̱ri̱ri̱mwo naakoba yati, “Kusoboora makuru ga bilooto, kuruga hali Ruhanga. Mu̱mbwere bilooto byenyu̱.” ");
INSERT INTO rub_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Nahaahwo, muheereza mu̱handu̱ wa byakunywa yaasoboora Yozefu̱ kilooto kyamwe naakoba yati, “Nyakali kulootanga nimbona musaali gwa mu̱zabbi̱bbu̱ niguli mu mei̱so gange. ");
INSERT INTO rub_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Kandi mu̱zabbi̱bbu̱ gu̱gwo, niguli na bi̱jangi̱ bisatu, gu̱sogi̱ri̱ kandi gwaki̱i̱rye byakyo, gwata byana, byahangiira. ");
INSERT INTO rub_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Nyakali nkweti̱ ki̱kopo kya Faraaho mu ngalu zange, nyaanokola bijuma bya mi̱zabbi̱bbu̱, nyabikamula mu ki̱kyo ki̱kopo nyaaki̱mu̱kwatya mu ngalu.” ");
INSERT INTO rub_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yozefu̱ yaamu̱sobooleeri̱ makuru ga kilooto naakoba yati, “Makuru ga kilooto ki̱kyo googo gaga: bi̱jangi̱ bisatu byobyo biro bisatu. ");
INSERT INTO rub_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Mu biro bisatu bi̱byo, Faraaho hooho akwi̱za kukutoola mu nkomo, we akwi̱rye ha mulimo gwamu, omuhereze nka kuwamuhereezengi makadei. ");
INSERT INTO rub_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Bei̱tu̱ byamu b̯ubilibba bi̱seemeeri̱ onzi̱zu̱ke kandi ongiire mbabazi̱, ontonganiire hali Faraaho, aleke nagya nsobore kuruga mu nkomo. ");
INSERT INTO rub_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Hab̯wakubba nyanyagi̱i̱rwe nyatoolwa mu nsi gya Bahebburaniya, kandi ntalinaho musangu gu̱nkoori̱ gukumpa kwicala mu nkomo.” ");
INSERT INTO rub_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Mu̱handu̱ wa bati̱mbi̱ b̯u̱yaaweeni̱ Yozefu̱ nka kuyaasobooleeri̱ kurungi makuru ga kilooto kya mwi̱ra waamwe, yaamuweera naakoba yati, “Nagya ndi na kilooto. Nyaalooti̱ri̱ nyeetweki̱ri̱ nkimba isatu nizilimwo migaati. ");
INSERT INTO rub_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Mu lu̱lwo lukimba lwa hakyendi̱, halimwo bidyo bi̱ti̱mbe bya b̯uli mu̱li̱ngo bibaali baati̱mbi̱i̱ri̱ Faraaho, bei̱tu̱ nnyoni̱ nizikubisoma mu lukimba ha mu̱twe gwange.” ");
INSERT INTO rub_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yozefu̱ yaamwi̱ri̱ri̱mwo naakoba yati, “Makuru ga kilooto ki̱kyo googo gaga: nkimba isatu, byobyo biro bisatu. ");
INSERT INTO rub_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Mu biro bisatu, Faraaho akwi̱za kukutemaho mu̱twe, akubbanike ha musaali, aleke bi̱nyoni̱ bidye mubiri gwamu.” ");
INSERT INTO rub_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ha kiro kyakasatu, kinyakubba nikili kiro kya kwi̱zu̱ka kubyalwa kwa Faraaho, Faraaho yaakoori̱ b̯u̱genyi̱ b̯wa baheereza baamwe bensei̱, yaatoori̱ mu nkomo muheereza mu̱handu̱ wa byakunywa na mu̱handu̱ wa bati̱mbi̱, aleke bantu bensei̱ babawone. ");
INSERT INTO rub_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Nahaahwo, yeeri̱i̱ryehoona muheereza mu̱handu̱ wa byakunywa ku mulimo gwamwe gukadei. ");
INSERT INTO rub_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Bei̱tu̱ muheereza mu̱handu̱ wa bati̱mbi̱ yaamwi̱ta na kumubbanika ha musaali nka Yozefu̱ ku̱yaabasoboleeri̱. ");
INSERT INTO rub_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Bei̱tu̱ nab̯wo, muheereza mu̱handu̱ wa byakunywa atakei̱zu̱ke Yozefu̱, yaamaaliira amwebereeri̱. ");
INSERT INTO rub_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Hei̱nyu̱ma gya myaka mibiri, Faraaho yaalooti̱ri̱ kilooto. Mu ki̱kyo kilooto, yaali yeemereeri̱ heehi̱ na mugira gwa Nai̱ro. ");
INSERT INTO rub_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Yaawona nte musanju zirungi kandi zi̱gomoku̱ kuruga mu gu̱gwo mugira nizikudya ntoogo. ");
INSERT INTO rub_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Nahaahwo, zindi musanju zibiibi kandi zaanu̱ku̱, nazo zaaru̱gi̱ri̱ ha mugira gwa Nai̱ro, zeemeera heehi̱ na zi̱i̱ra. ");
INSERT INTO rub_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Kandi nte zinyakubba zibiibi kandi zaanu̱ku̱, zaadi̱i̱ri̱ nte musanju zirungi zaamalikaho, kasi Faraaho yaasi̱si̱mu̱ka. ");
INSERT INTO rub_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Yaab̯u̱ni̱i̱rye yeebbaka yaaloota murundi gwakabiri, mu kilooto ki̱kyo yaaweeni̱ ntwe musanju za nganu zeeri̱ri̱ heikolo li̱mwei̱. Gi̱gyo nganu gyali gi̱nyi̱ri̱ru̱ kandi girungi. ");
INSERT INTO rub_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Hei̱nyu̱ma haateeri̱ho ntwe zindi musanju za nganu nizili na nsigo zibbeebbeebbe, zinyakwoma hab̯wa b̯uhyo b̯wa mpehu gya b̯uhulukalyoba. ");
INSERT INTO rub_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Nahaahwo, ntwe zibbeebbeebbe zaadi̱i̱ri̱ zaameera ntwe musanju zi̱nyi̱ri̱ru̱ kandi zirungi. Faraaho b̯u̱yaasi̱si̱mu̱ki̱ri̱ yeetegereza nka kukyali nikili kilooto. ");
INSERT INTO rub_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Mwakya lyaho yeelali̱ki̱ri̱i̱ri̱ hoi̱, kasi yaatuma bantu bamwetere bafu̱mu̱ na bakali̱magezi̱ kuruga mu nsi gya Mi̱si̱ri̱, yaabasoboora bilooto byamwe, bei̱tu̱ hatakabbeho muntu yensei̱ munyakumusoboora makuru gaabyo. ");
INSERT INTO rub_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Nahaahwo, muheereza mu̱handu̱ wa byakunywa yaaweereeri̱ Faraaho naakoba yati, “Kiro kyadeeru nyi̱zu̱ki̱ri̱ nsobi̱ gyange. ");
INSERT INTO rub_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Faraaho b̯u̱yaakwati̱i̱rwe ki̱ni̱ga hab̯wa baheereza baamwe, yambohi̱ri̱ hamwei̱ na mu̱handu̱ wa bati̱mbi̱ mu nnyu̱mba hali mu̱handu̱ wa bali̱ndi̱ yei̱calengi̱. ");
INSERT INTO rub_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","I̱jolo li̱mwei̱ twensei̱ twalooti̱ri̱, bei̱tu̱ twalooti̱ri̱ bilooto bikwahukana makuru. ");
INSERT INTO rub_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Mu nnyu̱mba gi̱gyo, twalimwo na mudulu Muhebburaniya, muheereza mu̱handu̱ wa bali̱ndi̱, b̯u̱twamu̱wereeri̱ yaatusoboora makuru gaabyo, ku̱si̱gi̱ki̱ra b̯uli muntu nka kilooto kyamwe kukyalingi. ");
INSERT INTO rub_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Kwokwo de kyakabbeeri̱ nka ku̱yaatu̱soboleeri̱, gya banzi̱ri̱i̱ryeho ha mulimo gwange, kasi muheereza mu̱handu̱ wa bati̱mbi̱ baamwi̱ta na kubbanika ha musaali.” ");
INSERT INTO rub_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Nahab̯waki̱kyo, Faraaho yaatu̱mi̱ri̱ bamuletere Yozefu̱. Yozefu̱ baamu̱toori̱ wangu mu nkomo. B̯u̱yaamaari̱ kumwa ntumbu akahindula na bilwalu, kasi yaagyenda hali Faraaho. ");
INSERT INTO rub_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Faraaho yaaweereeri̱ Yozefu̱ naakoba yati, “Nyaalooti̱ri̱ kilooto, bei̱tu̱ tihaloho muntu akusobora kukinsoboora makuru gaakyo, bei̱tu̱ bambwereeri̱ weewe wegi̱ri̱ kusoboora makuru ga bilooto.” ");
INSERT INTO rub_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yozefu̱ yei̱ri̱ri̱mwo Faraaho naakoba yati, “Tindi gyagya akikora nyankei bei̱tu̱ Ruhanga akusobora kwolokya makuru ga kilooto kyamu.” ");
INSERT INTO rub_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Faraaho yaaweera Yozefu̱ naakoba yati, “Nyaalooti̱ri̱ nyemereeri̱ ha mutanda gwa Nai̱ro. ");
INSERT INTO rub_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Nyaawona nte musanju zi̱gomoku̱ kandi zirungi, zaahu̱lu̱ki̱ri̱ kuruga mu mugira zaatandika kudya ntoogo. ");
INSERT INTO rub_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Harugayo nte zindi musanju zibiibi kandi zaanu̱ku̱ zintakawonangaho mu nsi gyensei̱ gya Mi̱si̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Kandi nte zinyakubba zaanu̱ku̱ zaadi̱i̱ri̱ nte musanju za kubanza, zinyakubba zi̱gomoku̱. ");
INSERT INTO rub_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Naab̯uzamaari kuzidya, hatakabbeho munyakukyetegereza nka ku̱zazi̱di̱i̱ri̱, kubba nte zaanu̱ku̱ zaasi̱geeri̱ nizili zibiibi nka kuzaali mu kubanza, kasi nyaabyoka. ");
INSERT INTO rub_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Kandi nyei̱ri̱ri̱ nyaaloota ninkuwona ikolo li̱mwei̱ lya nganu li̱meeri̱ho ntwe musanju, nigili gi̱nyi̱ri̱ru̱ kandi girungi. ");
INSERT INTO rub_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Kasi mwomwo de nyaawona ntwe zindi musanju zi̱ku̱nku̱mu̱ki̱ri̱ kandi zi̱tolu̱ zi̱ku̱u̱ti̱i̱rwe mpehu gya b̯uhulukalyoba nazo zi̱hu̱lu̱ki̱ri̱i̱rye heikolo lyolyo li̱mwei̱. ");
INSERT INTO rub_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Kandi ntwe zinyakubba zi̱tolu̱ zaadi̱i̱ri̱ zaameera ntwe zinyakubba zirungi. B̯u̱nyasoboreeri̱ bafu̱mu̱ ki̱kyo kilooto, hatakabbeho noomwei̱ akusobora kumbwera makuru gaakyo.” ");
INSERT INTO rub_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Mwomwo Yozefu̱ yaaweera Faraaho naakoba yati, “Bilooto byamu bibiri byensei̱ bi̱ku̱manyi̱sya kintu ki̱mwei̱. Ruhanga akwolokeerye kyakugyenda kukora. ");
INSERT INTO rub_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Nte musanju zirungi, zi̱ku̱manyi̱sya myaka musanju, na ntwe musanju zirungi za nganu, nazo zi̱ku̱manyi̱sya myaka musanju, bilooto bi̱byo bibiri bi̱ku̱manyi̱sya kintu kyokyo ki̱mwei̱. ");
INSERT INTO rub_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Nte musanju zaanu̱ku̱ zinyakuhondera zi̱i̱ra, zi̱ku̱manyi̱sya myaka musanju, kandi ntwe musanju za nganu zinyakukunkumuka na mpehu gya b̯uhulukalyoba, zi̱ku̱manyi̱sya myaka musanju mya nzala. ");
INSERT INTO rub_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Nka ku̱nkakobi̱ri̱ Ruhanga kyakugyenda kukora aki̱kwolokeerye. ");
INSERT INTO rub_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Mu myaka musanju, hakwi̱za kubbaho mweru gwa bidyo gunene hoi̱ mu nsi gyensei̱ gya Mi̱si̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Hei̱nyu̱ma wa bi̱byo byensei̱, hakwi̱za kubbaho nzala gyakalasanu̱ hab̯wa myaka musanju, kandi gu̱gwo mweru bantu baligwebeera kubba nzala giliswaswana nsi gyensei̱ gya Mi̱si̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Kwerya kwa bidyo ku̱kwo tikulyegeb̯wa mu gi̱gyo nsi gya Mi̱si̱ri̱ hab̯wa nzala gi̱kwi̱za kwi̱ra kubbaho, kubba gilibba gya kabii hoi̱. ");
INSERT INTO rub_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Kilooto kyamu kubbaho mirundi mibiri, ki̱ku̱manyi̱sya nti, Ruhanga agu̱mi̱i̱rye ki̱mwei̱, nka kwali heehi̱ ku̱ki̱doosereerya. ");
INSERT INTO rub_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Nahab̯waki̱kyo, hataati̱ osemereeri̱ okomemwo muntu wa magezi̱ kandi akwetegereza, aleke omuhe b̯u̱sobozi̱ b̯wa kulema nsi gya Mi̱si̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Oi̱re okome bantu baawoneera nsi, batooleho ki̱mwei̱ kyakataanu kya b̯uli kilimwa kyensei̱ kya Mi̱si̱ri̱ mu myaka musanju mya mweru. ");
INSERT INTO rub_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Leke basoorooze bidyo bya myaka mi̱myo mirungi mya mweru kandi nganu gi̱bi̱i̱kwe mu mbuga mu b̯u̱sobozi̱ b̯wa Faraaho. ");
INSERT INTO rub_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Bidyo bi̱byo, byobyo bantu bali̱dya aleke bi̱bamali̱sye myaka musanju mya ku̱gwa kwa gi̱gyo nzala mu nsi gya Mi̱si̱ri̱, kwokwo bantu batalihwerekeera hab̯wa gi̱gyo nzala.” ");
INSERT INTO rub_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Kiteekerezu ki̱kyo, Faraaho hamwei̱ na bayolo baamwe baaki̱si̱i̱mi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Faraaho yaab̯u̱u̱lya bayolo baamwe naakoba yati, “Tusobora mali̱ kwagya muntu ali na Mwozo wa Ruhanga nka yogo?” ");
INSERT INTO rub_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Kasi Faraaho yaaweera Yozefu̱ naakoba yati, “Bi̱byo Ruhanga byakwolokeerye, tihaloho muntu noomwei̱ wa magezi̱ kandi akwetegereza nka we. ");
INSERT INTO rub_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Weewe okugyenda kutandika kulemanga kikaali kyange, kandi bantu bensei̱ bakwi̱za kuhonderanga kiwaakabaragiranga. Gyagya musa nyaakusinganga b̯u̱sobozi̱ kubba ndi mukama.” ");
INSERT INTO rub_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Faraaho yaab̯u̱ni̱i̱rye yaaweera Yozefu̱ naakoba yati, “Kuruga na deeru nku̱heeri̱ b̯u̱sobozi̱ b̯wa kuwoneera nsi gya Mi̱si̱ri̱ gyensei̱.” ");
INSERT INTO rub_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Nahaahwo, Faraaho yaaku̱su̱u̱ri̱ mpi̱ta giwa kilengeru, yaagi̱lwalya Yozefu̱, yaamu̱lwali̱i̱rye bilwalu bya rangi̱ gi̱syanu̱ girungi hoi̱, yei̱ra yaamu̱lwalya lu̱kwanzi̱ lwa zaabbu mwi̱coti̱. ");
INSERT INTO rub_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Yaaragira bamu̱si̱ndi̱ki̱re mu kigaali kyamwe kyakabiri, bantu batokenge mu mei̱so gaamwe nibakoba yati, “Ku̱nde malu̱!” Kwokwo yatyo Faraaho yaaheeri̱ Yozefu̱ b̯u̱sobozi̱ kulema nsi gya Mi̱si̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Mwomwo Faraaho yaaweera Yozefu̱ naakoba yati, “Gyagya Faraaho, tihaloho muntu wondi yensei̱ mu nsi gya Mi̱si̱ri̱ alikora kintu kindi kyensei̱ kutoolaho we obazi̱ri̱.” ");
INSERT INTO rub_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Kasi Faraaho yaaha Yozefu̱ ibara libakweta Zafenaasi̱-paneeya, yaamuha Asenaasi̱ muhara wa Poti̱feera, mu̱laami̱ wa mu kicweka kyʼOni̱, amuswere. B̯u̱sobozi̱ b̯wa Yozefu̱ waadoori̱ mu nsi gyensei̱ gya Mi̱si̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yozefu̱ yaadooseerye myaka maku̱mi̱ gasatu mya b̯u̱handu̱, yaatandika kuheereza Faraaho mukama wa Mi̱si̱ri̱. Yozefu̱ yaaru̱gi̱ri̱ mu zi̱gati̱ gya kikaali kya mukama, yaagyenda mu nsi gyensei̱ gya Mi̱si̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Mu myaka musanju mya mweru, nsi gyereerye bidyo binene. ");
INSERT INTO rub_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yozefu̱ yaasooroozi̱ri̱ bidyo byensei̱ binyakubba byeri̱ri̱ mu b̯unene mu mi̱myo myaka musanju mu nsi gya Mi̱si̱ri̱, yaabibiika mu mbuga. B̯uli rub̯uga yaabi̱kengi̱yo bidyo byasoreezi̱ri̱ mu misiri mya mu ki̱kyo kicweka. ");
INSERT INTO rub_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yozefu̱ yaabi̱i̱ki̱ri̱ nganu mu b̯unene, heehi̱ kwijana musinyi gwa ku mutanda. Baalekaho ku̱gi̱pi̱ma hab̯wakubba gyali mu b̯unene. ");
INSERT INTO rub_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Nzala gi̱takagwi̱ri̱, Yozefu̱ yaabyeri̱ baana ba b̯udulu babiri, naababyala na Asenaasi̱ muhara wa Poti̱feera, mu̱laami̱ wa mu kicweka kyʼOni̱. ");
INSERT INTO rub_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yozefu̱ yaaheeri̱ mu̱zegei̱zo ibara Manaase, kubba yaabazi̱ri̱ naakoba yati, “Ruhanga anzebereeseerye b̯ujune b̯wange b̯wensei̱ hamwei̱ na b̯ujune b̯wa mu̱gi̱ gwa bbaabba.” ");
INSERT INTO rub_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Kasi mwana wakabiri yaamweta Efu̱rayi̱mu̱, yaabaza naakoba yati, “Ruhanga ampeeri̱ lubyalu mu nsi gya b̯ujune.” ");
INSERT INTO rub_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Myaka musanju mya mweru minyakubbaho mu nsi gya Mi̱si̱ri̱ b̯u̱myamali̱ki̱ri̱, ");
INSERT INTO rub_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","hei̱zi̱ri̱ho myaka musanju mya nzala, Yozefu̱ nka kuyaali abazi̱ri̱. Nzala gyaagwi̱ri̱ mu nsi gyensei̱ bei̱tu̱ kandi Mi̱si̱ri̱ haali hei̱zwi̱ri̱mwo bidyo. ");
INSERT INTO rub_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Nzala b̯u̱gyagwi̱ri̱ mu nsi gyensei̱ gya Mi̱si̱ri̱, bantu baataagira Faraaho aleke abahe byakudya. Kasi Faraaho yaaweera Banyami̱si̱ri̱ naakoba yati, “Mu̱gyende hali Yozefu̱ mukore nka kuyakabaweera.” ");
INSERT INTO rub_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Nzala b̯u̱gyakalaseeni̱ mu nsi gyensei̱, Yozefu̱ yaaku̱ngu̱u̱ri̱ bideeru byensei̱ bya bidyo yaatu̱ndi̱sya Banyami̱si̱ri̱ bidyo, kubba nzala gyali ginene maani mu gi̱gyo nsi gya Mi̱si̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Bantu ba mu nsi gyensei̱ bei̱zi̱ri̱ Mi̱si̱ri̱ kugula nganu hali Yozefu̱, kubba nzala gyali ginene mu b̯uli kiikaru kyensei̱ kya mu nsi. ");
INSERT INTO rub_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yakobbo b̯u̱yeegwi̱ri̱ nti Mi̱si̱ri̱ hali̱yo bidyo, yaab̯u̱u̱lya batabani̱ baamwe naakoba yati, “Hab̯waki mukulingiragana?” ");
INSERT INTO rub_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Yongeeri̱ kubaweera naakoba yati. “Kanyeegwi̱ri̱ nti, hali̱yo bidyo mu nsi gya Mi̱si̱ri̱. Mu̱gyende mutugulireyo bidyo, aleke tu̱takwa nzala.” ");
INSERT INTO rub_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Kasi baab̯u Yozefu̱ i̱ku̱mi̱ baasetu̱ki̱ri̱ baagyenda Mi̱si̱ri̱ kugula bidyo. ");
INSERT INTO rub_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Bei̱tu̱ Yakobbo atakeikirize mu̱tabani̱ waamwe Bbenyami̱i̱ni̱, mwamaa Yozefu̱ kugyenda na baab̯u, hab̯wakubba yaati̱i̱nengi̱ kabii katamugwaho. ");
INSERT INTO rub_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Kasi batabani̱ ba Yakobbo yeegebeerwe de nkʼI̱saleeri̱, baagyenda Mi̱si̱ri̱ na bantu bandi kugula bidyo, hab̯wakubba nzala gyali gi̱gwi̱ri̱ mu nsi gya Kanani̱. ");
INSERT INTO rub_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Mu kasu̱mi̱ kakwo, Yozefu̱ yaali mu̱lemi̱ mu̱handu̱ mu nsi gya Mi̱si̱ri̱, kandi yooyo yaatu̱ndi̱syengi̱ bantu bensei̱ ba mu nsi gi̱gyo bidyo. Baab̯u Yozefu̱ bei̱zi̱ri̱ beetu̱lu̱ka hansi mu mei̱so gaamwe kumutamwo ki̱ti̱i̱ni̱sa. ");
INSERT INTO rub_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yozefu̱ b̯u̱yaaweeni̱ baab̯u yaabetegereza, kyonkei atakabezolokyeho nka kwabeegi̱ri̱ kandi yaababazi̱ri̱i̱rya na nkabbu. Mwomwo yaabab̯u̱u̱lya naakoba yati, “Muru̱gi̱ri̱ mu nsi kyani?” Baamwi̱ri̱ri̱mwo nibakoba yati, “Tu̱ru̱gi̱ri̱ mu nsi gya Kanani̱, twi̱zi̱ri̱ kugula bidyo.” ");
INSERT INTO rub_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yozefu̱ nab̯u̱yaaweeni̱ baana baab̯u akabetegereza, bei̱tu̱ bo batakamwetegereze. ");
INSERT INTO rub_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Kasi mwomwo Yozefu̱ yei̱zu̱ka bilooto byamwe bi̱yaalootengi̱, yaabaweera naakoba yati, “Nywe timuli ntati̱? Mwi̱zi̱ri̱ kubega b̯uceke b̯wa lili ihanga.” ");
INSERT INTO rub_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Baamwi̱ri̱ri̱mwo nibakoba yati, “Kwahi mukama wange, twe beiru baamu twi̱zi̱ri̱ kugula bidyo. ");
INSERT INTO rub_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Twensei̱ tuli baana ba mudulu omwei̱, kandi tuli beesigwa, tituli ntati̱.” ");
INSERT INTO rub_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Yaabei̱ri̱ri̱mwo naakoba yati, “Kwahi! Mwi̱zi̱ri̱ kubega b̯uceke b̯weihanga lyetu̱.” ");
INSERT INTO rub_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Baamwi̱ri̱ri̱mwo nibakoba yati, “Twalingi baab̯u na baab̯u i̱ku̱mi̱ na babiri, kandi batabani̱ ba bbaaweetu̱ omwei̱ wa mu nsi gya Kanani̱. Weetu̱ muto yaasi̱geeri̱ na bbaaweetu̱ mu Kanani̱, kandi wondi yaakwi̱ri̱.” ");
INSERT INTO rub_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Bei̱tu̱ Yozefu̱ yaabei̱ri̱ri̱mwo naakoba yati, “Kwokwo kili nka ku̱nyaabaweereeri̱ nti, muli ntati̱. ");
INSERT INTO rub_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Nkugyenda ku̱tolereerya nyeetegereze nywe muli bantu ki. Nkubarahirira mwibara lya Faraaho mwomi ti̱mu̱kwi̱za kuruga haha kutoolahoona mu̱leeti̱ri̱ mwana weenyu̱ muto akusembayo haha. ");
INSERT INTO rub_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Mu̱kome omwei̱ muli nywe, agyende aleete yogwo muto weenyu̱, nywe bandi bensei̱ mwicale haha mu nkomo. Ki̱kwi̱za ku̱nanu̱ki̱sya mwakabba nimukubaza mananu. Mwakabba ni̱mu̱ku̱gobya, nkubarahirira mwibara lya Faraaho mwomi, mukubba nimuli ntati̱.” ");
INSERT INTO rub_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Kandi yaabateeri̱ bensei̱ hamwei̱ mu nkomo hab̯wa biro bisatu. ");
INSERT INTO rub_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ha kiro kyakasatu, Yozefu̱ yaabaweereeri̱ naakoba yati, “Gya ndi mudulu atamwo Ruhanga ki̱ti̱i̱ni̱sa, mu̱kore kinkubaweera aleke kibajune. ");
INSERT INTO rub_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","B̯umwakabba nimuli beesigwa, mu̱leke weenyu̱ omwei̱ asigale mu nkomo, bandi mugyende mwetweke nganu gi̱mu̱gu̱u̱ri̱, mutwalire bidyo ba makaa geenyu̱ bakwegama na nzala. ");
INSERT INTO rub_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Mulinakuleeta weenyu̱ akusembayo b̯uto, kasi mwomwo nyeege nka kumukubaza mananu, aleke ntabacwera musangu gwa ku̱kwa.” Beikiriza kukora nka ku̱yaabaweereeri̱. ");
INSERT INTO rub_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Mwomwo baaweerangana nibakoba yati, “Mu mananu tukufubirwa hab̯wa weetu̱, hab̯wakubba mu b̯ujune b̯unene yaatwesengereerye tu̱mu̱teesye agyende, bei̱tu̱ tu̱takamwegwe. Kyokyo natwe tuli mu b̯ujune b̯unene.” ");
INSERT INTO rub_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Lu̱bbeeni̱ yaaberi̱ri̱mwo naakoba yati, “Ntakabaweere mwana mutamukora kibiibi kyensei̱? Bei̱tu̱ mu̱takeegwe! Hati̱ nu tulinakusasulira ibbanga lyamwe.” ");
INSERT INTO rub_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Batakakyege Yozefu̱ nka ku̱yaabeegwengi̱, kubba haabbengi̱ho mu̱hi̱ndu̱li̱ mu̱nyakwi̱rangamwo bigambu byab̯u na bya Yozefu̱. ");
INSERT INTO rub_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Hab̯wi̱re b̯u̱b̯wo Yozefu̱ yaabaru̱gi̱ri̱ho, yei̱ra ha rubaju yaatandika kulira, kasi yaab̯u̱ni̱a yei̱ra hali bo, yaabaza nabo. Yaatwala Si̱myoni̱, yaamubboha baab̯u bali̱ngi̱ri̱i̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Hei̱nyu̱ma, Yozefu̱ yaaragi̱i̱ri̱ baheereza baamwe kwi̱zu̱u̱lya nsau za bab̯wo baana baab̯u na nganu, na kwi̱rya sente za b̯uli muntu mu nsau gyamwe, na kindi yaabaragi̱i̱ri̱ bababbohere ntanda. ");
INSERT INTO rub_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Kasi mwomwo baatweka nganu gyab̯u ha ndogoyi̱ zaab̯u, baasi̱mb̯u̱ra. ");
INSERT INTO rub_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","B̯u̱baali̱beeti̱, bakadwa cali baagonyeeri̱ mwa kulaala i̱jolo li̱lyo, omwei̱ mubo yaahwi̱ri̱ nsawu gyamwe kuha ndogoyi̱ bidyo, yaaweeni̱ sente zaamwe nizili ha mu̱nwa gwa nsawu gyamwe. ");
INSERT INTO rub_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Mwomwo yaaweera baana baab̯u naakoba yati, “Sente zange baazi̱nzi̱ri̱ri̱i̱rye, nzizizo ha mu̱nwa gwa nsawu!” Ki̱kyo kintu kyabaleeteeri̱ b̯u̱ti̱i̱ni̱, baakankana, beeb̯u̱u̱lya nibakoba yati, “Kikyani kiki kya Ruhanga atu̱koori̱?” ");
INSERT INTO rub_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","B̯u̱baakadoori̱ hali bbaawaab̯u Yakobbo mu nsi gya Kanani̱, baamuweera byensei̱ binyakubabbaho nibakoba yati, ");
INSERT INTO rub_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Mudulu mu̱lemi̱ wa mu gi̱gyo nsi gya Mi̱si̱ri̱, atakabaze natwe kurungi, yaatu̱weereeri̱ naatujunaana nti, twagyendi̱ri̱yo kutata nsi gyab̯u. ");
INSERT INTO rub_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Bei̱tu̱ twe twamuweera nitukoba yati, ‘Twe tuli badulu beesigwa, titukabbangaho ntati̱. ");
INSERT INTO rub_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Twalingi baab̯u na baab̯u i̱ku̱mi̱ na babiri nituli batabani̱ ba bbaaweetu̱ omwei̱. Omwei̱ yaakwi̱ri̱, muto weetu̱ ali na bbaaweetu̱ mu Kanani̱.’ ");
INSERT INTO rub_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Kasi yogwo mudulu mu̱lemi̱ yaatuweera naakoba yati, ‘Gya kubananukira, mu̱ti̱ge omwei̱ mu beenyu̱ nagya, mugyende mutwalire bidyo ba makaa geenyu̱ bakwegama na nzala. ");
INSERT INTO rub_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Mu̱gyende muleete mwana weenyu̱ muto akusembayo, mwomwo nkwi̱za kwega byabiribiri nti, timuli ntati̱, nkwi̱za kubatesulira weenyu̱ aleke musub̯ure mu gigi nsi.’ ” ");
INSERT INTO rub_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","B̯u̱bakatandi̱ki̱ri̱ kupakuura bidyo kuruga mu nsau zaab̯u, b̯uli muntu yaagi̱i̱ryemwo ki̱bboli̱bbo kya sente mu nsau gyamwe, kandi bo na bbaawaab̯u b̯u̱bazi̱weeni̱ b̯u̱ti̱i̱ni̱ b̯wabakwata. ");
INSERT INTO rub_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Bbaawaab̯u Yakobbo yaabaweera naakoba yati, “Kamwamalaho baana bange, Yozefu̱ tacaaliho na Si̱myoni̱ taloho, hataati̱ mu̱kwendya kutwala Bbenyami̱i̱ni̱. B̯uli kintu ki̱mbyokeereeri̱!” ");
INSERT INTO rub_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Mwomwo Lu̱bbeeni̱ yaaweera bbaawe naakoba yati, “B̯u̱ntakwi̱ri̱i̱rye haha Bbenyami̱i̱ni̱, hakiri oi̱te batabani̱ bange babiri. Nyeesiga nkugyenda ku̱mu̱kwi̱ri̱i̱rya.” ");
INSERT INTO rub_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Yakobbo yaamwi̱ri̱ri̱mwo naakoba yati, “Mwana wange tokumutwala, kubba mwana waab̯u yaakwi̱ri̱. Yooyo musa asi̱geeri̱ho, kakubba kabii kamudwaho ngu̱lu̱u̱si̱ri̱ nyaaku̱kwa hab̯wa b̯ujune.” ");
INSERT INTO rub_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Hab̯wi̱re b̯u̱b̯wo, nzala gyeteeryenge b̯weteerya mu nsi. ");
INSERT INTO rub_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Hei̱nyu̱ma, b̯u̱baamaari̱ kudya nganu gibaali baleeti̱ri̱ kuruga mu Mi̱si̱ri̱, bbaawaab̯u yaabaweera naakoba yati, “Mu̱ku̱beyo, mutugulireyo bidyo bindi.” ");
INSERT INTO rub_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Bei̱tu̱ Yu̱da yaamu̱weereeri̱ naakoba yati, “Yodi̱ mudulu yaatu̱pompogereerye ki̱mwei̱ naatuweera nti, ‘B̯u̱mu̱tali̱i̱ra haha na weenyu̱ muto, ti̱mu̱kwi̱za kumbonaho.’ ");
INSERT INTO rub_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","B̯uwaakatwikiriza kugyenda hamwei̱ na yogwo weetu̱, tu̱kwi̱za ku̱si̱ri̱mu̱ka tugyende tu̱bagu̱li̱reyo bidyo. ");
INSERT INTO rub_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","B̯wotamwikirize nitukagyenda nayo, b̯u̱b̯wo tukubba tutakugyenda, hab̯wakubba yogwo mudulu yaatu̱weereeri̱ naakoba yati, ‘Timulimbonaho, b̯umutalibba na weenyu̱ muto.’ ” ");
INSERT INTO rub_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","I̱saleeri̱ yaabazi̱ri̱ naakoba yati, “Hab̯waki mu̱ndeeteeri̱ b̯ujune, kuweera yogwo mudulu nti, mulinayo weenyu̱ wondi muto?” ");
INSERT INTO rub_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Bei̱ri̱ri̱mwo nibakoba yati, “Yodi̱ mudulu, yaatu̱b̯u̱li̱ri̱i̱rye kamwei̱ na kamwei̱ kub̯ubyalasanwa b̯wetu̱, naakoba yati, ‘Bbaaweenyu̱ acaaliho mwomi? Mulinaho weenyu̱ wondi?’ Twei̱rengemwo bigambu bi̱yaab̯u̱u̱lyengi̱. Twakakyegi̱ri̱ teetei̱ nka kwakwi̱za kutusaba tutwaleyo weetu̱?” ");
INSERT INTO rub_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Yu̱da yaaweereeri̱ bbaawe I̱saleeri̱, naakoba yati, “Leka tugyende na yogo musigazi, aleke we na baana beetu̱ bensei̱, twomeere tu̱takwa. ");
INSERT INTO rub_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Gya nyeeheeri̱i̱yo kumulinda, onjunaane, kakubba ntamwi̱rya nkamuhemba mu mei̱so gaamu. Gyagya gyolijunaana mu b̯womi b̯wange bwensei̱. ");
INSERT INTO rub_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Kabbenge tu̱takereeri̱i̱rwe, twakabba tu̱ku̱bi̱ri̱yo murundi gwakabiri.” ");
INSERT INTO rub_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Bbaawaab̯u I̱saleeri̱ yaabaweereeri̱ naakoba yati, “Kyakabba nikili yatyo, mukore kiki, mutwale mu nsahu zeenyu̱ bisembu bimwaha yogwo mudulu, kandi mumutwalire ku bintu birungi bya mu nsi gigi. Mumutwalire kisembu kya maku̱ta gaku̱wonya kurungi, gakuruga mu misaali nigatamba b̯u̱ru̱mi̱, na mugaaju gu̱ku̱wonya kurungi. Mumutwalire manyondo, b̯ubbaani, binyoowa na majereeru. ");
INSERT INTO rub_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Mutwale mirundi mibiri ha muhendu gwa sente. Mwi̱ryeyo sente zi̱mwagi̱i̱rye mu mi̱nwa mya nsawu zeenyu̱, rundi gyalingi nsobi̱. ");
INSERT INTO rub_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Mutwalegane weenyu̱ Bbenyami̱i̱ni̱. Mu̱byokye mugyenda hali yogwo mudulu. ");
INSERT INTO rub_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Ruhanga Waamaani Gensei̱ abagiire kisa mu mei̱so ga yogwo mudulu. Akwi̱za ku̱teesya weenyu̱ mu̱handu̱. Mu̱kwi̱za kwi̱ra nayo na Bbenyami̱i̱ni̱, bei̱tu̱ gya nab̯unyaabba nanganye hab̯wa baana bange, kanferwe.” ");
INSERT INTO rub_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Kasi mwomwo badulu baatwala bisembu, baatwala mirundi mibiri ha muhendu gwa sente. Baatweri̱ Bbenyami̱i̱ni̱, baabyokya lugyendu kugyenda Mi̱si̱ri̱. B̯u̱baadoori̱yo, baagyenda ku̱romba na Yozefu̱. ");
INSERT INTO rub_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Yozefu̱ b̯u̱yaaweeni̱ Bbenyami̱i̱ni̱ naali hamwei̱ na baab̯u, yaaweera mu̱li̱ndi̱ wa nnyu̱mba gyamwe naakoba yati, “Badulu bab̯wo bengi̱i̱rye mu nnyu̱mba gyange, obasalire kisolo hab̯wakubba bakudya nagya kyamwinsi.” ");
INSERT INTO rub_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Mudulu yaakoori̱ Yozefu̱ nka ku̱yaamu̱ragi̱i̱ri̱, yaabengi̱i̱rya mu nnyu̱mba gyamwe. ");
INSERT INTO rub_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Baab̯u Yozefu̱ baati̱i̱ni̱ri̱ hab̯wa ku̱bengi̱i̱rya mu nnyu̱mba gya Yozefu̱, kasi babaza nibakoba yati, “Sente zi̱twagi̱i̱rye mu nsawu zeetu̱ ha murundi gwakubanza, zoozo zi̱tu̱letereeri̱ kwi̱za haha. Bakugyenda kutukwata, batunyage ndogoyi̱ zeetu̱, kandi batufoore beiru baamwe.” ");
INSERT INTO rub_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Nahaahwo, baagyendi̱ri̱ hali muheereza wa nnyu̱mba gya Yozefu̱ baabaza nayo beemereeri̱ ha mulyangu gwa nnyu̱mba. ");
INSERT INTO rub_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Baamuweera nibakoba yati, “Mukama weetu̱, ha murundi gwakubanza twezi̱ri̱ haha kugula bidyo. ");
INSERT INTO rub_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","B̯u̱twadoori̱ ha b̯wicalu b̯wetu̱ twahu̱u̱ri̱ nsawu gya b̯uli muntu twagyamwo sente zaamwe zensei̱ nka kuzaalingi kandi zo nzizi tu̱zi̱i̱ri̱i̱rye. ");
INSERT INTO rub_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Kandi tu̱leeti̱ri̱ sente zindi zaku̱gu̱li̱sya bidyo, ti̱twegi̱ri̱ munyakuta zizi sente mu nsawu zeetu̱.” ");
INSERT INTO rub_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Mu̱li̱ndi̱ yaabei̱ri̱ri̱mwo naakoba yati, “Mu̱hu̱u̱mu̱le, mu̱leke kwelalikiira, Ruhanga weenyu̱ kandi Ruhanga wa bbaaweenyu̱, yooyo yaabateereeri̱ sente mu nsawu zeenyu̱, sente zeenyu̱ nyaazi̱tu̱ngi̱ri̱.” Kasi yaahu̱lu̱kya Si̱myoni̱ yaamuleeta mu bo. ");
INSERT INTO rub_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Mu̱li̱ndi̱ b̯u̱yaaleeti̱ri̱ baab̯u Yozefu̱ mu nnyu̱mba, yaabaheeri̱ meezi̱ ga kunaaba magulu, yaabaha na bidyo bya ndogoyi̱ zaab̯u. ");
INSERT INTO rub_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Bab̯wo baab̯u baategeka kisembu kyakuha Yozefu̱, b̯u̱yaakei̱za kwamu̱gi̱, kubba baalingi babaweereeri̱ nka kubakugyenda kudya nayo. ");
INSERT INTO rub_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Yozefu̱ b̯u̱yaadoori̱ kwamu̱gi̱, baamu̱heeri̱ bisembu bibaalingi baleeti̱ri̱, beetu̱lu̱ka hansi mu mei̱so gaamwe kumuha ki̱ti̱i̱ni̱sa. ");
INSERT INTO rub_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Yaabaramu̱ki̱i̱rye naakoba yati, “Muli teetei̱? Bbaaweenyu̱ mu̱gu̱lu̱u̱su̱ gi̱mwambwereeri̱ ali̱yo kurungi? Acaali mwomi?” ");
INSERT INTO rub_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Baamwi̱ri̱ri̱mwo nibakoba yati “Mwiru waamu kandi bbaaweetu̱, ali̱yo kurungi, akyaloho.” Beetu̱lu̱ki̱ri̱ hansi nibamutamwo ki̱ti̱i̱ni̱sa. ");
INSERT INTO rub_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Yozefu̱ b̯u̱yaabyokeerye mei̱so, yaawona Bbenyami̱i̱ni̱ waab̯u mwa mmaawe, yaab̯u̱u̱lya naakoba yati, “Yogo, yooyo weenyu̱ akusembayo b̯uto, gi̱mwambwereeri̱?” Yaaweereeri̱ Bbenyami̱i̱ni̱ yati, “Ruhanga aku̱gi̱i̱re mbabazi̱, mwana wange!” ");
INSERT INTO rub_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yozefu̱ b̯u̱yaaweeni̱ waab̯u, yaakwatwa kisa, yaabyoka b̯wangu yaaruga cali yaali ei̱cali̱i̱ri̱, yaatoolya cali yaaliriira. Yei̱ngi̱i̱ri̱ mu ki̱si̱i̱ka kyamwe, yaatandika kulira. ");
INSERT INTO rub_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Hei̱nyu̱ma yaanaabi̱ri̱ mei̱so, yaahuluka cali baalingi yeegu̱mya. Yaaragi̱i̱ri̱ baheereza baamwe naakoba yati, “Mu̱basegeerye bidyo.” ");
INSERT INTO rub_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Bei̱tu̱ kandi yo baamu̱segereerye hab̯wamwe, baab̯u de hab̯wab̯u, na Banyami̱si̱ri̱ banyakudya nayo de hab̯wab̯u, kubba Banyami̱si̱ri̱ batakadyenge na Bahebburaniya, kyali kyamuziro. ");
INSERT INTO rub_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Yozefu̱ yoolokeerye baab̯u b̯uli omwei̱ haakwicaara, b̯uli muntu yaamwi̱cali̱i̱rye naahonderanga b̯u̱handu̱ b̯wamwei, kinyakuhuuniiza baab̯u. ");
INSERT INTO rub_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Nahaahwo, Yozefu̱ yaabatoneeri̱ bidyo kuruga habyamwe, bei̱tu̱ Bbenyami̱i̱ni̱ baamu̱heeri̱ bidyo binene, mirundi mitaanu kukira bi̱baaheeri̱ baab̯u. Baadi̱i̱ri̱ kandi baanywa nibali banzu̱ru̱ku̱ nayo. ");
INSERT INTO rub_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Hei̱nyu̱ma, Yozefu̱ yaaragi̱i̱ri̱ muheereza wa nnyu̱mba gyamwe naakoba yati, “I̱zu̱u̱lya nsawu za bab̯wo badulu na bidyo binene bya b̯uli muntu akusobora kwetweka, kandi ote sente za b̯uli muntu ha mu̱nwa gwa nsawu gyamwe gya bidyo. ");
INSERT INTO rub_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Kandi de, ote ki̱kopo kyange kya feeza ha mu̱nwa gwa nsawu gya mwana waab̯u akusembayo b̯uto hamwei̱ na sente zaamwe zi̱yaaleeti̱ri̱ ku̱gu̱li̱sya bidyo.” Yogwo muheereza kwokwo yaakoori̱ nka Yozefu̱ ku̱yaamu̱ragi̱i̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Mwakya karei mambya asaari̱ bab̯wo badulu baaragi̱ri̱, baasetuka kwemuka na ndogoyi̱ zaab̯u. ");
INSERT INTO rub_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","B̯ubaali batakadahi̱i̱ri̱ na rub̯uga, Yozefu̱ yaaweera muheereza waamwe naakoba yati, “Byoka ohondere bab̯wo badulu, wakabadwereera obab̯u̱u̱lye nookoba yati, ‘Mukama wange, yaabolokeerye mbabazi̱, hab̯waki mu̱mu̱saswi̱ri̱ na kibiibi? ");
INSERT INTO rub_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Hab̯waki mwei̱bi̱ri̱ ki̱kopo kya mukama wange, tikyokyo ki̱kopo kyanyweramwo, kandi kimuha kwetegereza bikugyenda kubbaho mu mei̱so? Mu̱koori̱ kubiibi hoi̱ kukora kintu nka ki̱kyo!’ ” ");
INSERT INTO rub_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Yogwo muheereza b̯u̱yaadwereeri̱ baana baab̯u Yozefu̱, yaabaweereeri̱ bigambu bya Yozefu̱ bi̱yaamu̱tu̱mi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Bei̱tu̱ bo baamwi̱ri̱ri̱mwo nibakoba yati, “Kintu kyani ki̱heeri̱ mukama weetu̱ kubaza yatyo? Kikafuuhe, twe kukora kintu nka ki̱kyo. ");
INSERT INTO rub_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Wona na sente zi̱twagi̱i̱rye mu nsawu zeetu̱, twazi̱kwi̱ri̱ri̱i̱rye kuruga Kanani̱, kandi twaku̱soboori̱ teetei̱ kwi̱ba zaabbu rundi feeza mu nnyu̱mba gya mukama waamu? ");
INSERT INTO rub_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Yogwo yensei̱ gibakaagya na ki̱kopo muli twe, bamwi̱te, bakusigalaho tufooke beiru baamu we mukama wange.” ");
INSERT INTO rub_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Yogwo mudulu yei̱ri̱ri̱mwo naakoba yati, “Nka ku̱mu̱kakobi̱ri̱, leka kwokwo kibbe. Yogwo gibakaagya na ki̱kopo, yooyo yaafooka mwiru wange, basi̱geeri̱ho timuli na musangu gwensei̱.” ");
INSERT INTO rub_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","B̯ulohob̯uloho bensei̱ bei̱ci̱i̱rye nsawu zaab̯u hansi baazahula. ");
INSERT INTO rub_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Muheereza wa Yozefu̱ yaatandi̱ki̱si̱i̱rye na kwaza nsawu gya mu̱handu̱ naamaliira na nsawu gya muto, kandi ki̱kopo kyamaliri̱i̱ri̱ ki̱zookeeri̱ mu nsawu gya Bbenyami̱i̱ni̱. ");
INSERT INTO rub_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Kikorwa ki̱kyo kyabatu̱ntu̱u̱ze hoi̱ baatandika kutemula bilwalu byab̯u, kasi b̯uli muntu yei̱rya nsawu gyamwe ha ndogoyi̱ gyamwe, baaku̱bayo mu rub̯uga. ");
INSERT INTO rub_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yu̱da na baab̯u b̯u̱baadoori̱, Yozefu̱ yaali nacaali mu nnyu̱mba. B̯u̱baamu̱weeni̱, baagwi̱ri̱ hansi mu mei̱so gaamwe. ");
INSERT INTO rub_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yozefu̱ yaabab̯u̱u̱lya naakoba yati, “Kiki mu̱koori̱ kintu kyani? Ti̱mu̱kyegi̱ri̱ nti, muntu nka gya akusobora kwega bi̱kwi̱za kubbaho mu mei̱so?” ");
INSERT INTO rub_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yu̱da yei̱ri̱ri̱mwo naakoba yati, “Mukama wange, twakuweera kyani? Kibii twakyetoolaho teetei̱? Ruhanga yooyo yoolokeerye kibii kya beiru baamu hataati̱ mukama weetu̱ tuli beiru baamu, twe hamwei̱ na yogwo gi̱baagi̱i̱rye na ki̱kopo.” ");
INSERT INTO rub_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Bei̱tu̱ Yozefu̱ yei̱ri̱ri̱mwo naakoba yati, “Ki̱kyo gya tinsobora kukikora! Yogwo gi̱baagi̱i̱rye na ki̱kopo yooyo musa yaabba mwiru wange, bei̱tu̱ nywe bandi mu̱gyende na b̯u̱si̱nge mukube hali bbaaweenyu̱.” ");
INSERT INTO rub_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Mwomwo Yu̱da yaagyenda hali Yozefu̱ yaabaza naakoba yati, “Mukama wange, nzikiriza nkuweere kigambu. Otazingalira mwiru waamu, nab̯uwakabba nookwijana Faraaho woonyi̱ni̱. ");
INSERT INTO rub_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Mukama wange yaab̯u̱u̱li̱i̱rye beiru baamwe naakoba yati, ‘Bbaaweenyu̱ ali mwomi? Rundi weenyu̱ wondi yensei̱?’ ");
INSERT INTO rub_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Twamwi̱ri̱ri̱mwo nitukoba yati, ‘Tulina bbaaweetu̱ mu̱gu̱lu̱u̱su̱ na weetu̱ muto, munyakubyalwa mu b̯u̱gu̱lu̱u̱su̱. Waab̯u mwana yogwo mu̱handu̱ yaakwi̱ri̱, yooyo yankei asi̱geeri̱ho ha baana ba mmaawe yooyo kigonze hali bbaaweetu̱.’ ");
INSERT INTO rub_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Kasi waaweera beiru baamu nookoba yati, ‘Gyende mumundeetere haha muwone.’ ");
INSERT INTO rub_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Twawereeri̱ mukama wange Yozefu̱ nitukoba yati, ‘Musigazi tasobora ku̱ti̱ga bbaawe, kakubba amu̱ti̱ga, bbaawe akwi̱za ku̱kwa.’ ");
INSERT INTO rub_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Nahaahwo, waatu̱weereeri̱ twe beiru baamu nookoba yati, ‘B̯u̱mu̱tali̱i̱za na weenyu̱ muto, ti̱mu̱li̱i̱ra kumbonaho.’ ");
INSERT INTO rub_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","B̯u̱twemu̱ki̱ri̱ hali bbaaweetu̱, twamuweera bi̱byo bigambu bi̱waabazi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Kasi bbaaweetu̱ yaatuweera naakoba yati, ‘Mu̱ku̱beyo aleke muguleyo nganu gindi.’ ");
INSERT INTO rub_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Tweri̱ri̱mwo nitukoba yati, ‘Titukusobora ku̱ku̱bayo hataloho weetu̱ akusembayo b̯uto, kubba titusobora kuwona yogwo mudulu kutoolaho weetu̱ naaloho.’ ");
INSERT INTO rub_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Kasi bbaaweetu̱ yaatuweera naakoba yati, ‘Mu̱kyegi̱ri̱ mu̱kali̱ wange Lakeeri̱ nka ku̱yambyali̱i̱ri̱ baana ba b̯udulu babiri. ");
INSERT INTO rub_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Omwei̱ yandu̱gi̱ri̱ho nyaakoba yati, “Bisolo bya mwirungu biteekwa kubba bi̱mu̱temu̱temu̱u̱ri̱.” Kuruga b̯u̱b̯wo tinkamuwoonangaho. ");
INSERT INTO rub_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Kakubba ontoolaho Bbenyami̱i̱ni̱, akatunga b̯uzib̯u, nkwi̱za kuziikwa ntakadoori̱ hab̯wa b̯ujune.’” ");
INSERT INTO rub_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Kasi Yu̱da yaabaza naakoba yati, “Mukama wange, tinkusobora kukuba hali bbaabba ntali na mwana waamwe akusembayo b̯uto. Bbaabba akusobora kwahi kwomeera kakubba amu̱feerwa. ");
INSERT INTO rub_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Waalituwona tutali hamwei̱ nayo, ali̱gu̱mya gakwa. ");
INSERT INTO rub_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Nyeeragi̱ri̱ kwi̱rya yogwo musigazi mu b̯urungi, ki̱tali̱ki̱kyo, ndijunaanwa biro bya b̯womi b̯wange b̯wensei̱. ");
INSERT INTO rub_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Hati̱ nu, mukama wange nkwesengereze, leka gya nsigale haha nikuheereza mu kiikaru kya musigazi. Leka musigazi akubeyo na baab̯u. ");
INSERT INTO rub_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Gya nsobora teetei̱ kwemuka hali bbaabba ntali na musigazi yogwo? Ti̱nkwendya kuwona kabii nikakudwa hali bbaabba.” ");
INSERT INTO rub_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yozefu̱ yaali atakusobora kwetati̱ri̱i̱rya mu mei̱so ga baheereza baamwe, yaabazi̱ri̱ naakoba yati, “B̯uli muntu ahuluke hanzei.” Nahab̯waki̱kyo, hatakabbeho muntu yensei̱ mu nnyu̱mba Yozefu̱ b̯uyaali naakwezolokya hali baab̯u. ");
INSERT INTO rub_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Yaali̱i̱ri̱ kizabiro kinyamaani Banyami̱si̱ri̱ baakyegwa kandi baakiweeraho na ba mu kikaali kya Faraaho. ");
INSERT INTO rub_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yozefu̱ yaaweereeri̱ baab̯u naakoba yati, “Gyagya Yozefu̱! Bbaabba acaaliho mwomi?” B̯u̱beegwi̱ri̱ ki̱kyo, batakamwi̱ramwo hab̯wakubba baali ku̱mu̱ti̱i̱na. ");
INSERT INTO rub_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Kasi Yozefu̱ yaaweera baab̯u naakoba yati, “Mwesegye heehi̱ nagya,” b̯u̱beesegeerye yaabaweera naakoba yati, “Gyagya Yozefu̱, ndi weenyu̱ gi̱mwatu̱ndi̱ri̱ Mi̱si̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Mu̱tati̱i̱na kandi muteelalikiira hab̯wa kuntunda haha, kubba Ruhanga yooyo yaantu̱mi̱ri̱ ngyende mu mei̱so geenyu̱, aleke njune b̯womi weenyu̱. ");
INSERT INTO rub_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Nzala gi̱gwi̱ri̱ mu nsi, hataati̱ mili myaka mibiri, kandi hasi̱geeri̱yo myaka mindi mitaanu, mu myaka mi̱myo, tihalibbaho kulima rundi kukesa. ");
INSERT INTO rub_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Kandi Ruhanga yaantu̱mi̱ri̱ ngyende mu mei̱so geenyu̱ kubategekera b̯wicalu na ba makaa geenyu̱ haha mu nsi, kandi kujuna b̯womi b̯wenyu̱ mu mu̱li̱ngo gwa byamageru nka gugu. ");
INSERT INTO rub_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“Nahab̯waki̱kyo, mutakabbe nywenywe banyakuntuma haha, bei̱tu̱ Ruhanga yooyo yantu̱mi̱ri̱ haha. Yanfoora bba Faraaho, ndi mukama wa makaa gaamwe kandi mu̱lemi̱ mu̱handu̱ akukirayo mu nsi gyensei̱ gya Mi̱si̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Mwangu̱he wangu, mugyende hali bbaabba mumuweere yati, ‘Mu̱tabani̱ waamu Yozefu̱ akukoba yati, Ruhanga anteeri̱ kubba mu̱lemi̱ wa mu nsi gya Mi̱si̱ri̱ gyensei̱, wanguha oi̱ze otakereerwa. ");
INSERT INTO rub_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Oicale mu nsi gya Goseni̱, obbe heehi̱ nagya, we, baana baamu, beizukulu baamu, magana gaamu na bikwatu byamu byensei̱ byoli nabyo. ");
INSERT INTO rub_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Wakabba nokwicala mu Goseni̱ ki̱kwi̱za kunzanguhiranga kukuha bidyo na bintu bindi byokwetaaga, kubba nzala gi̱cakeeteerya b̯weteerya hab̯wa myaka mindi mitaanu mu mei̱so, ti̱nkwendya we, ba mu makaa gaamu na magana gaamu mwegame.’ ” ");
INSERT INTO rub_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Yozefu̱ yongeeri̱ kubaza naakoba yati, “Hataati̱ nywensei̱ mu̱weeni̱ na mei̱so geenyu̱, nawe Bbenyami̱i̱ni̱ mwa mmaama, de oweeni̱ nka kundi gyagya Yozefu̱ akubaza nanywe. ");
INSERT INTO rub_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Muweere bbaabba ha ki̱ti̱i̱ni̱sa kindi nakyo mu gigi nsi gya Mi̱si̱ri̱ kandi de mumuweere ha bintu byensei̱ bi̱mu̱weeni̱, mwanguhe wangu mumuleete haha.” ");
INSERT INTO rub_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Kasi Yozefu̱ na waab̯u Bbenyami̱i̱ni̱ baagwagana mu salaka, baalira. ");
INSERT INTO rub_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Kandi Yozefu̱ yaagwi̱ri̱ baab̯u bensei̱ mu salaka, yaalira. Hei̱nyu̱ma, baab̯u baabaza nayo. ");
INSERT INTO rub_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Makuru b̯u̱gadooori̱ mu kikaali kya Faraaho, nti baab̯u Yozefu̱ bei̱zi̱ri̱, Faraaho na balemi̱ baamwe baasemereerwe hoi̱. ");
INSERT INTO rub_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Faraaho yaaweera Yozefu̱ naakoba yati, “Weera beenyu̱ yati, ‘Mubbohe migugu myenyu̱ ha ndogoyi̱ mwi̱reyo mu nsi gya Kanani̱, ");
INSERT INTO rub_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","mutooleyo bbaaweenyu̱ na bantu beenyu̱, mwi̱ze kunu hali gya, nkwi̱za kubaha kicweka kirungi kikukira byensei̱ mu nsi gya Mi̱si̱ri̱, mwadyanga birungi biruga mu nsi gi̱gyo.’ ");
INSERT INTO rub_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“Kandi obaragire nookoba yati, ‘Mutwale bigaali kuruga haha Mi̱si̱ri̱. Bakali̱ na baana beenyu̱, byobyo baavuga kwi̱za kunu. Mu̱syome bbaaweenyu̱ aleke mwi̱ze wangu. ");
INSERT INTO rub_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Muteelalikiira bintu byenyu̱ bya mu Kanani̱, hab̯wakubba bintu bikukira b̯urungi mu nsi gya Mi̱si̱ri̱ bili byenyu̱.’ ” ");
INSERT INTO rub_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Baana bʼI̱saleeri̱, baakoori̱ nka ku̱babawereeri̱. Yozefu̱ yaabaha bigaali, Faraaho nka ku̱yaaragi̱i̱ri̱, yaabaha na ntanda gya kudiira mu muhanda. ");
INSERT INTO rub_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Yozefu̱ yaaheeri̱ baab̯u bensei̱, b̯uli muntu kilwalu kihyaka, bei̱tu̱ Bbenyami̱i̱ni̱ yaamuha bicweka bya feeza bi̱ku̱mi̱ bisatu, na bilwalu bihyaka bitaanu. ");
INSERT INTO rub_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Bibi byobyo bintu bi̱yaatwekeeri̱ bbaawe, ndogoyi̱ i̱ku̱mi̱ zeetweki̱ri̱ bintu birungi bya mu nsi gya Mi̱si̱ri̱, ndogoyi̱ zi̱kali̱ i̱ku̱mi̱ zeetweki̱ri̱ nganu, migaati hamwei̱ na ntanda gya lugyendu lwa bbaawe. ");
INSERT INTO rub_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Yozefu̱ yaaherekereeri̱ baab̯u, baagyenda. B̯ubaalingi nibakwahukana nayo, yaabaweera naakoba yati, “Mutazongoba mu muhanda.” ");
INSERT INTO rub_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Baaru̱gi̱ri Mi̱si̱ri̱, baagyenda mu nsi gya kwamwab̯u Kanani̱, hali bbaawaab̯u Yakobbo. ");
INSERT INTO rub_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Baamu̱weereeri̱ nibakoba yati, “Yozefu̱ acaali mwomi, kandi yooyo mu̱lemi̱ wa nsi gyensei̱ gya Mi̱si̱ri̱.” Yakobbo b̯u̱yeegwi̱ri̱ yatyo, mutima gwamukuuta atakeki̱ri̱ze ki̱baamu̱weereeri̱. ");
INSERT INTO rub_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Bei̱tu̱ b̯u̱baamu̱weereeri̱ bigambu byensei̱ bya Yozefu̱ bi̱yaabazi̱ri̱, amaari̱ kuwona bigaali bi̱yaasi̱ndi̱ki̱ri̱ ku̱mu̱twali̱ramwo, mutima gwa Bbaawaawu̱ Yakobbo gwateeka. ");
INSERT INTO rub_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Mwomwo I̱saleeri̱ yaakoba yati, “Ndimunanuku mwana wange Yozefu̱ acaali mwomi, nkwi̱za kugyenda muwoneho ntakakwi̱ri̱.” ");
INSERT INTO rub_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Nahaahwo, I̱saleeri̱ yaabyokeerye lugyendu yaatwala bintu byamwe byensei̱, b̯u̱yaadoori̱ Bbeeri̱-sebba, yaahonga bihongwa bya Ruhanga wa bbaawe I̱saka. ");
INSERT INTO rub_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","I̱jolo lyolyo, Ruhanga yaabazi̱ri̱ nʼI̱saleeri̱ mu kilooto naakoba yati, “Yakobbo, Yakobbo.” Yakobbo yeetab̯u̱ki̱ri̱ naakoba yati, “Ndi haha.” ");
INSERT INTO rub_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Kasi Ruhanga yaamwi̱ramwo naakoba yati, “Gyagya Ruhanga, Ruhanga wa bbaawu gi̱yaaramyengi̱. Otati̱i̱na kugyenda Mi̱si̱ri̱, ku̱kwo hooho ndikufoora kubba ihanga likooto. ");
INSERT INTO rub_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Nkwi̱za kugyenda hamwei̱ nawe mu nsi gya Mi̱si̱ri̱, nzi̱re nkwemu̱kye. Yozefu̱ alibba nawe mu kasu̱mi̱ kaamu ka ku̱kwa.” ");
INSERT INTO rub_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Kasi mwomwo Yakobbo yaasetuka kuruga Bbeeri̱-sebba, batabani̱ baamwe baatwala bbaawaab̯u Yakobbo, baana baab̯u, na bakali̱ baab̯u, babatembya mu bigaali Faraaho bi̱yaatu̱mi̱ri̱ babatwaliremwo. ");
INSERT INTO rub_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Baatweri̱ bisolo na bintu bindi bibaali batu̱ngi̱ri̱ mu Kanani̱, mu mu̱li̱ngo gwogwo, Yakobbo na ba mu̱gi̱ gwamwe gwensei̱ baagyenda Mi̱si̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Yakobbo yaagyendi̱ri̱ Mi̱si̱ri̱ na batabani̱, bahara, na beizukulu baamwe. ");
INSERT INTO rub_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Gaga googo mabara ga baana na beizukulu bʼI̱saleeri̱, yooyo de yeegebeerwe nka Yakobbo, banyakugyenda mu nsi gya Mi̱si̱ri̱. Lu̱bbeeni̱ yooyo yaali mu̱zegei̱zo wa Yakobbo. ");
INSERT INTO rub_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Batabani̱ ba Lu̱bbeeni̱ boobo baba: Hanoki̱, Paru, Hezi̱rooni̱, Karumi. ");
INSERT INTO rub_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Baba boobo batabani̱ ba Si̱myoni̱: Yemweri̱, Yami̱i̱ni̱, Ohaadi̱, Yaki̱i̱ni̱, Zohali̱ na Sau̱lo, munyakubyalwa mu̱kali̱ Mu̱kanani̱. ");
INSERT INTO rub_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Baba boobo batabani̱ ba Leevi̱: Geresoni̱, Kohati̱, na Merali̱. ");
INSERT INTO rub_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Baba boobo batabani̱ ba Yu̱da: Eeri̱, Onani̱, Seera, Pereezi̱ na Zeera, (bei̱tu̱ Eeri̱ nʼOnani̱, baakwereeri̱ mu nsi gya Kanani̱). Baba boobo batabani̱ ba Pereezi̱: Hezi̱rooni̱, na Hamu̱li̱. ");
INSERT INTO rub_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Baba boobo batabani̱ ba I̱saakaari̱: Toora, Pu̱u̱va, Yobbu̱ na Si̱mi̱rooni̱. ");
INSERT INTO rub_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Baba boobo batabani̱ ba Zabbu̱looni̱: Sereedi̱, Elooni̱, Yahaleeri̱. ");
INSERT INTO rub_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Baba boobo batabani̱ ba Leeya baayaabyeri̱ na Yakobbo mu Padanaramu. Leeya de yaabyali̱i̱ri̱ Yakobbo muhara gibakweta Di̱na. Bensei̱ baali maku̱mi̱ gasatu na basatu. ");
INSERT INTO rub_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Baba boobo batabani̱ ba Gaadi̱: Zi̱fi̱yooni̱, Haagi̱, Su̱u̱ni̱, Ezi̱bbooni̱, Eli̱, Arodi̱, nʼAleeri̱. ");
INSERT INTO rub_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Baba boobo batabani̱ bʼAseeri̱: I̱mu̱na, I̱su̱va, I̱si̱vi̱, hamwei̱ na Bberi̱i̱ya. Nyaakaab̯u yaali Seera. Baba boobo batabani̱ ba Bberi̱i̱ya: Hebbeeri̱ na Maleki̱yeeri̱. ");
INSERT INTO rub_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Baba boobo baana na beizukulu ba Yakobbo na Zi̱ri̱pa, muheereza Labbani̱ gi̱yaaheeri̱ muhara waamwe Leeya kwicala nayo. Bensei̱ baali i̱ku̱mi̱ na mukaaga. ");
INSERT INTO rub_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Baba boobo batabani̱ ba Lakeeri̱ mukaa Yakobbo: Yozefu̱ na Bbenyami̱i̱ni̱. ");
INSERT INTO rub_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Kandi Yozefu̱ b̯uyaali naali Mi̱si̱ri̱, Asenaasi̱ muhara wa Poti̱feera, mu̱laami̱ mu kicweka kyʼOni̱, yaamu̱byali̱i̱ri̱ baana babiri, Manaase nʼEfu̱rayi̱mu̱. ");
INSERT INTO rub_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Baba boobo baana ba Bbenyami̱i̱ni̱: Bbeera, Bbekeeri̱, Asu̱bbeeri̱, Geera, Namani̱, Ehi̱, Rosi̱, Mu̱pi̱i̱mu̱, Hu̱pi̱i̱mu̱ nʼAli̱di̱. ");
INSERT INTO rub_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Baba boobo baana na beizukulu ba Yakobbo na Lakeeri̱. Bensei̱ baali i̱ku̱mi̱ na banei. ");
INSERT INTO rub_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Mwana wa Daani̱ yooyo Hu̱si̱i̱mu̱. ");
INSERT INTO rub_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Baba boobo baana ba Nafutaali: Yahazeeli̱, Gu̱u̱ni̱, Yezeeri̱, na Si̱leemu̱. ");
INSERT INTO rub_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Baba boobo baana na beizukulu ba Yakobbo na Bbi̱li̱ha, muheereza Labbani̱ gi̱yaaheeri̱ muhara waamwe Lakeeri̱ kwicala nayo. Bensei̱ baali musanju. ");
INSERT INTO rub_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Baana bensei̱ ba Yakobbo, banyakwi̱za Mi̱si̱ri̱, otoori̱mwo bamukamwana baamwe, baadwengi̱ nkaaga na mukaaga. ");
INSERT INTO rub_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Batabani̱ ba Yozefu̱ baayaabyeri̱ naali Mi̱si̱ri̱, baalingi babiri, muhendu gwa bantu ba Yakobbo bensei̱ banyakugyenda Mi̱si̱ri̱ baali nsanju. ");
INSERT INTO rub_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yakobbo yaatu̱mi̱ri̱ Yu̱da amwebembere, asabe Yozefu̱ barombere mu Goseni̱. ");
INSERT INTO rub_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yozefu̱ yaateekani̱i̱ze kigaali kyamwe, yaagyenda ku̱romba bbaawe Yakobbo mu Goseni̱, b̯u̱yaamu̱weeni̱, yaamugwa mu salaka, yaalira hab̯wa kei̱re. ");
INSERT INTO rub_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Yakobbo yaaweereeri̱ Yozefu̱ naakoba yati, “Hataati̱ nyetegeki̱ri̱ ku̱kwa, hab̯wakubba nyetegeri̱i̱ze nka kwocaali mwomi.” ");
INSERT INTO rub_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Yozefu̱ yaaweereeri̱ baab̯u na ba makaa ga bbaawe naakoba yati, “Nkwi̱za kugyenda mbwere Faraaho yati, ‘Beetu̱ hamwei̱ na ba mu̱gi̱ gwa bbaabba, banyakubba mu nsi gya Kanani̱, bei̱zi̱ri̱ hali gya. ");
INSERT INTO rub_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Mmu̱weere nka kumwicala bali̱i̱sya, kandi mu̱letegeeni̱ magana geenyu̱, hamwei̱ na bikwatu bya mu nnyu̱mba zeenyu̱.’ ");
INSERT INTO rub_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Faraaho b̯u̱yaakabeeta akabab̯u̱ulya naakoba yati, ‘Mukora mulimo kyani?’ ");
INSERT INTO rub_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Mu̱mwi̱remwo nimukoba yati, ‘Beiru baamu beicala bali̱i̱sya kuruga mu b̯uto b̯wab̯u na ku̱doosya hataati̱ nka babbaweetu̱ kubaali,’ aleke musobore kwicala mu gi̱gyo nsi gya Goseni̱, hab̯wakubba Banyami̱si̱ri̱ banuga bali̱i̱sya bensei̱.” ");
INSERT INTO rub_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Hei̱nyu̱ma Yozefu̱ yaagyendi̱ri̱ yaaweera Faraaho naakoba yati, “Bbaabba na beetu̱ baru̱gi̱ri̱ mu nsi gya Kanani̱, bei̱zi̱ri̱ na magana na bintu byab̯u byensei̱. Hataati̱ bali mu nsi gya Goseni̱.” ");
INSERT INTO rub_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Yozefu̱ yaatweri̱ bamwei̱ ha baana baab̯u bataanu, baagyenda ku̱romba Faraaho. ");
INSERT INTO rub_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Faraaho yaab̯u̱u̱li̱i̱rye baab̯u Yozefu̱ naakoba yati, “Mukora mulimo ki?” Baamwi̱ri̱ri̱mwo nibakoba yati, “Tubba bali̱i̱sya, nka bahaaha beetu̱ kubaalingi.” ");
INSERT INTO rub_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Baaweereeri̱ Faraaho nibakoba yati, “Hali̱yo nzala ginene mu nsi gya Kanani̱ kandi magana geetu̱ tigali neisubi lya kudya. Hakiri leka twe beiru baamu tugonyere mu Goseni̱.” ");
INSERT INTO rub_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Kasi Faraaho yaaweera Yozefu̱ naakoba yati, “Bbaawu na beenyu̱ bei̱zi̱ri̱ hali we. ");
INSERT INTO rub_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Nsi gya Mi̱si̱ri̱ gili mu ngalu zaamu. Leka bbaawu na beenyu̱ babbeere mu kicweka kikukirayo b̯urungi. Leka beicala mu Goseni̱. Koma mu bo muntu ali na b̯u̱ku̱gu̱ wa ku̱li̱i̱sya ali̱i̱syenge magana gange.” ");
INSERT INTO rub_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Kasi mwomwo Yozefu̱ yaaleeta bbaawe Yakobbo ku̱romba na Faraaho. Yakobbo yaaha Faraaho mu̱gi̱sa. ");
INSERT INTO rub_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Kasi Faraaho yaab̯u̱u̱lya Yakobbo naakoba yati, “Olina myaka mingahi mya b̯u̱handu̱?” ");
INSERT INTO rub_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakobbo yei̱ri̱ri̱mwo Faraaho naakoba yati, “Ndi na myaka ki̱ku̱mi̱ na maku̱mi̱ gasatu mya b̯u̱handu̱ (130). Ncaali na myaka mi̱dooli̱ kandi myakutalibana kunene. Ncaali kwicala nka bahaaha bange.” ");
INSERT INTO rub_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Kasi Yakobbo yaab̯u̱ni̱a yaaha Faraaho mu̱gi̱sa, Yakobbo yaamurugaho, yaagyenda. ");
INSERT INTO rub_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Mwomwo Yozefu̱ yaatungira bbaawe na baab̯u b̯wicalu kandi yaabaha itehe likukira b̯urungi mu nsi gya Mi̱si̱ri̱. Yaabaheeri̱ mu kicweka ki̱beegi̱ri̱ hataati̱ nka Ramaseesi̱, yaakora byensei̱ nka Faraaho ku̱yaaragi̱i̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Kandi Yozefu̱ yaaheeri̱ bbaawe hamwei̱ na baab̯u, na bantu bensei̱ ba mu̱gi̱ gwa bbaawe bidyo, oteeri̱mwo na akusembayo b̯uto. ");
INSERT INTO rub_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Mu kasu̱mi̱ kakwo, nzala gyali gi̱gwi̱ri̱ hatakabbeho bidyo hantu hensei̱, nahab̯waki̱kyo bantu ba Mi̱si̱ri̱ na Kanani̱ baaceka hab̯wa nzala. ");
INSERT INTO rub_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","B̯u̱baagu̱u̱ri̱ nganu, Yozefu̱ yaasoorooza sente zensei̱, yaazitwala mu kikaali kya Faraaho. ");
INSERT INTO rub_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Sente zensei̱ za Banyami̱si̱ri̱ na Bakanani̱ b̯u̱zaakamali̱ki̱ri̱, Banyami̱si̱ri̱ bei̱zi̱ri̱ hali Yozefu̱ baamuweera nibakoba yati, “Tu̱he bidyo otatuleka ku̱kwa. Bbaho na kyokutukolera kubba sente zeetu̱ zi̱mali̱ki̱ri̱.” ");
INSERT INTO rub_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yozefu̱ yaabei̱ri̱ri̱mwo naakoba yati, “Mu̱ndetere bisolo byenyu̱, mbahemwo byakudya mwakabba mutali na sente.” ");
INSERT INTO rub_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Kasi baaleeta magana gaab̯u hali Yozefu̱, baaleeti̱ri̱ mbaraasi, ntaama, mbu̱li̱ hamwei̱ na ndogoyi̱, yo naabahi̱ngi̱syangamwo bidyo. Mu mwaka gu̱gwo, yaabagabi̱i̱ri̱ bidyo nahi̱ngi̱syanga na bisolo byab̯u byensei̱. ");
INSERT INTO rub_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Mu mwaka gunyakuhonderaho bei̱zi̱ri̱ haliyo baamuweera nibakoba yati, “Tukukuweresya mananu, sente zensei̱ zi̱tu̱mali̱ki̱ri̱ho, hati̱ bisolo byetu̱ byensei̱ bili byamu. Tituli na kitwakuha mukama wange otoori̱ho mibiri myetu̱ na matehe geetu̱. ");
INSERT INTO rub_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Otatuleka ni̱tu̱kakwa itehe lyetu̱ ndikafooka makandi. Wakatuha bidyo na mbibo za kusiga, twe neitehe lyetu̱ tukubba tu̱gu̱li̱i̱rwe Faraaho, tu̱foki̱ri̱ beiru baamwe kandi yeezi̱ri̱i̱rye nsi gyetu̱. Tu̱he nganu aleke twomeere kandi otuhe na nsigo tusimbe misiri myetu̱.” ");
INSERT INTO rub_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Yozefu̱ yaagu̱u̱ri̱ itehe lyensei̱ lya mu nsi gya Mi̱si̱ri̱, yaalikwatya Faraaho, b̯uli Mu̱nyami̱si̱ri̱ yensei̱ yaahambi̱ri̱zi̱i̱b̯we kutunda itehe lyamwe, kubba nzala gyali ginene, kandi itehe lyensei̱ lyei̱ra mu mikono mya Faraaho. ");
INSERT INTO rub_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Yozefu̱ yaafoora bantu bensei̱ beiru ba Faraaho, ");
INSERT INTO rub_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","otoori̱ho itehe lya balaami̱ basa lyolyo ataagu̱u̱ri̱, hab̯wakubba baatu̱ngengi̱ b̯u̱sagi̱ki̱ kuruga hali Faraaho. ");
INSERT INTO rub_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Nahaahwo, Yozefu̱ yaaweereeri̱ bantu naakoba yati, “Hataati̱ nywe na matehe geenyu̱ deeru mbagu̱u̱ri̱ muli ba Faraaho, nkugyenda kubaha nsigo mu̱si̱mbe. ");
INSERT INTO rub_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","B̯ubilyera, kicweka ki̱mwei̱ ku bitaanu mukihe Faraaho. Binei bya kataanu mubyebikire nka bidyo rundi nsigo hab̯wa makaa geenyu̱ na baana beenyu̱.” ");
INSERT INTO rub_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Baamwi̱ri̱ri̱mwo nibakoba yati, “Mukama weetu̱, otu̱ju̱ni̱ri̱ kwo. Tu̱semereerwe hoi̱ kubba beiru ba Faraaho.” ");
INSERT INTO rub_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Yozefu̱ yaateeri̱ho kiragiro kikukoba nti, ki̱mwei̱ kyakataanu, ku makesa gensei̱ ki̱kwi̱za kubbanga kya Faraaho. Balaami̱ basa boobo batafebeerwe matehe gaab̯u. ");
INSERT INTO rub_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Bei̱saleeri̱ kwokwo bei̱ceeri̱ yatyo Mi̱si̱ri̱, mu kicweka kya Goseni̱ baatungayo bintu binene, baabyala baakanya. ");
INSERT INTO rub_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakobbo yei̱ceeri̱ Mi̱si̱ri̱ hab̯wa myaka i̱ku̱mi̱ na musanju (17) nahab̯waki̱kyo myaka myensei̱ Yakobbo mi̱yaamaari̱, myali ki̱ku̱mi̱ na maku̱mi̱ ganei na musanju (147). ");
INSERT INTO rub_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Kasu̱mi̱ ka ku̱kwa kwʼI̱saleeri̱, yeegebeerwe de nka Yakobbo, b̯u̱keesegeerye, yeeti̱ri̱ mu̱tabani̱ waamwe Yozefu̱ yaamuweera naakoba yati, “Kwega nka kwonzendya kandi kwonzegwa, Taa mukono gwamu hansi wa kiberu kyange, orahire byamananu nka kwoli̱doosereerya kinkukuweera, otalinziika Mi̱si̱ri̱, ");
INSERT INTO rub_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","b̯u̱ndi̱kwa nkahondera bahaaha bange, olintoola Mi̱si̱ri̱, onziike mwi̱ri̱mbo hali bahaaha babazi̱ki̱ri̱.” Yozefu̱ yaamwi̱ri̱ri̱mwo naakoba yati, “Ndikora nka kwokobi̱ri̱.” ");
INSERT INTO rub_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yakobbo yaaweereeri̱ Yozefu̱ naakoba yati, “Rahira.” Yozefu̱ yaarahira, kasi Yakobbo yeetu̱lu̱ka ha ntabbu gyamwe, yaaramya Ruhanga. ");
INSERT INTO rub_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Hei̱nyu̱ma wa kasu̱mi̱ kadooli̱, Yozefu̱ baamu̱weereeri̱ nibakoba yati, “Bbaawu ali mu̱seeri̱.” Nahaahwo Yozefu̱ yaabyokeerye lugyendu, hamwei̱ na batabani̱ baamwe babiri, Manaase nʼEfu̱rayi̱mu̱. ");
INSERT INTO rub_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Yakobbo baamu̱weereeri̱ nibakoba yati, “Mu̱tabani̱ waamu Yozefu̱ ei̱zi̱ri̱ hali we.” Yakobbo yeegebeerwe de nkʼI̱saleeri̱, yeetati̱ri̱i̱rye yeicaara ha ntabbu gyamwe. ");
INSERT INTO rub_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Mwomwo Yakobbo yaaweera Yozefu̱ naakoba yati, “Ruhanga Waamaani Gensei̱ yambonekeeri̱ nindi mu kiikaru kya Lu̱u̱zi̱ mu nsi gya Kanani̱, yampa mu̱gi̱sa, ");
INSERT INTO rub_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","yambwera naakoba yati, ‘Ndikuha lubyalu obyale baana banene kandi ndikufoora ihanga likooto, ndikuha gigi nsi nka b̯ugwetwa b̯wa biro na biro we omaari̱ ku̱kwa.’ ");
INSERT INTO rub_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“Kuruga na deeru, batabani̱ baamu babiri bawaabyali̱i̱ri̱ mu nsi gya Mi̱si̱ri̱ ntakei̱zi̱ri̱ bali bange. Efu̱rayi̱mu̱ na Manaase balibba bange nka Lu̱bbeeni̱ na Si̱myoni̱ kubali bange. ");
INSERT INTO rub_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Kandi bab̯wo boolibyala hei̱nyu̱ma, balibba baamu, kandi balitunga b̯ugwetwa kuraba mu mabara ga bei̱ra baab̯u. ");
INSERT INTO rub_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","B̯unyaali ninkuruga Padanaramu, kya mu̱gi̱sa gubiibi, Lakeeri̱ yaakwera mu nsi gya Kanani̱ nitucaali mu muhanda, nituli heehi̱ kudwa Efu̱raati̱. Nyaamu̱zi̱ki̱ri̱ pembeeni̱ wa muhanda gukutwala Efu̱raati̱” (gyogyo gyegebeerwe nka Bbeterehemu̱). ");
INSERT INTO rub_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","I̱saleeri̱ b̯u̱yaaweeni̱ batabani̱ ba Yozefu̱, yaab̯u̱u̱lya naakoba yati, “Baba boobo banaani?” ");
INSERT INTO rub_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yozefu̱ yei̱ri̱ri̱mwo bbaawe naakoba yati, “Bali batabani̱ bange, ba Ruhanga ampeeri̱ haha Mi̱si̱ri̱.” I̱saleeri̱ yaakoba yati, “Bandeetere haha, aleke nsobore kubaha mu̱gi̱sa.” ");
INSERT INTO rub_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Mu kasu̱mi̱ kakwo I̱saleeri̱ yaali ahwi̱si̱ri̱, agu̱lu̱u̱si̱ri̱ ki̱mwei̱ atakuhweza kurungi. Nahaahwo, Yozefu̱ yaaleeti̱ri̱ batabani̱ baamwe heehi̱ na bbaawe, I̱saleeri̱ yaabanywegeera kandi yaabab̯umbatira. ");
INSERT INTO rub_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","I̱saleeri̱ yaaweereeri̱ Yozefu̱ naakoba yati, “Nyaali ntaku̱ni̱hi̱ra kwi̱ra kukuwonaho, bei̱tu̱ hataati̱ Ruhanga ansoboreseerye na kuwonaho baana baamu de.” ");
INSERT INTO rub_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Kasi Yozefu̱ yaatoola baana baamwe ha biberu bya haaha waab̯u, yeetu̱lu̱ka hansi. ");
INSERT INTO rub_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Yozefu̱ yaateeri̱ Efu̱rayi̱mu̱ ha mukono gwab̯umoso b̯wa Yakobbo, Manaase ha mukono gwab̯udyo. ");
INSERT INTO rub_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","I̱saleeri̱ yaabyokeerye mukono gwamwe gwab̯udyo yaaguta ha mu̱twe gwʼEfu̱rayi̱mu̱ munyakubba nakusembayo b̯uto, na mukono gumoso yaaguta ha mu̱twe gwa Manaase mu̱zegei̱zo wa Yozefu̱. ");
INSERT INTO rub_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Yaaheeri̱ Yozefu̱ mu̱gi̱sa naakoba yati, “Ruhanga wa haaha I̱bbu̱rahi̱mu̱ na bbaabba I̱saka gi̱baaramyengi̱, yooyo eicala mu̱li̱i̱sya wange ku̱dooosya na hataati̱, ");
INSERT INTO rub_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","kandi de, na malayika yogwo munyakunjuna hali b̯ubiibi b̯wensei̱, nkusaba ahe baba baana mu̱gi̱sa kandi kuraba muli bo ibara lyange na mabara ga haaha I̱bbu̱rahi̱mu̱ na bbaabba I̱saka, gomeere kandi bafooke ihanga likooto ku nsi haha.” ");
INSERT INTO rub_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yozefu̱ b̯u̱yaaweeni̱ bbaawe ateeri̱ mukono gwamwe gwab̯udyo ha mu̱twe gwʼEfu̱rayi̱mu̱ kyamu̱di̱i̱ri̱, yaakweti̱ mukono gwa bbaawe, naageryaho kugutoola ha mu̱twe gwʼEfu̱rayi̱mu̱, agute ha mu̱twe gwa Manaase. ");
INSERT INTO rub_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Yozefu̱ yaaweera bbaawe naakoba yati, “Bbaabba, yatyo kwahi, yogo yooyo mu̱zegei̱zo, gyokusemeera kutaho mukono gwamu gwab̯udyo.” ");
INSERT INTO rub_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Bei̱tu̱ bbaawe yaaswi̱ri̱ yaakoba yati, “Mwana wange, nkyegi̱ri̱, yogo nayo ali̱ru̱gwamwo ihanga, kandi alibba waki̱ti̱i̱ni̱sa, bei̱tu̱ b̯wab̯u muto alimukira b̯u̱sobozi̱, kandi beizukulu baamwe balibba ihanga likooto.” ");
INSERT INTO rub_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Kiro ki̱kyo yaabaheeri̱ mu̱gi̱sa naakoba yati, “Bantu ba mwʼI̱saleeri̱ b̯ubaalibbanga nibakusaba mu̱gi̱sa, bakwi̱za kwatulanga nibakoba yati, ‘Ruhanga abakolenge kurungi nka ku̱yaakoori̱ Efu̱rayi̱mu̱ na Manaase.’ ” Kwokwo yatyo Yakobbo yaaheeri̱ Efu̱rayi̱mu̱ b̯u̱handu̱ yeebembere Manaase. ");
INSERT INTO rub_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Kandi I̱saleeri̱ yaaweereeri̱ Yozefu̱ naakoba yati, “Wona hataati̱ ndi heehi̱ ku̱kwa, bei̱tu̱ Ruhanga akwi̱za kubba nawe, kandi akwi̱rye mu nsi gya bahaaha baamu. ");
INSERT INTO rub_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Nku̱heeri̱ rubaju lu̱mwei̱ lwa lusahu kukiraho beenyu̱, ku nsi gi̱nyahambi̱ri̱ na mpirima na b̯uta kuruga hali Bamooli̱.” ");
INSERT INTO rub_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Hei̱nyu̱ma Yakobbo yeeti̱ri̱ batabani̱ baamwe naakoba yati, “Mwecooke nywensei̱ hamwei̱, mbaweere bilibbaho mu biro bya mu mei̱so. ");
INSERT INTO rub_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Mwecooke kandi mwetegeerye nywe batabani̱ ba Yakobbo, Mwegwenge bbaaweenyu̱ kyakubaweera nywe I̱saleeri̱. ");
INSERT INTO rub_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“We Lu̱bbeeni̱, weewe mu̱zegei̱zo wange, maani gange, lubyalu lwa b̯usigazi b̯wange, murungi waki̱ti̱i̱ni̱sa kandi wamaani. ");
INSERT INTO rub_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Mutatekana nka meezi̱ ga mwizulo, tolibba waahakyendi̱, hab̯wakubba wani̱i̱ni̱ri̱ ntabbu gya bbaawu, wagihenera waalaala na mukaa bbaawu. ");
INSERT INTO rub_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Si̱myoni̱ na Leevi̱, beicala na bikorwa bikwisana, mpirima zaab̯u ziicala bikwatu bya b̯wemi̱. ");
INSERT INTO rub_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Mwozo gwange, otaligyenda mu kuhanuura kwab̯u. Mwozo gwange, otaliterana nabo, hab̯wakubba bei̱ta bantu hab̯wa ki̱ni̱ga kinene, nibatematema biteega bya nte batali na ki̱bagyendereeri̱. ");
INSERT INTO rub_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Ki̱ni̱ga kyab̯u kikakyenwe! Kubba ki̱ti̱i̱ni̱sya bantu, kandi tibagira mbabazi̱. Nkwi̱za ku̱basasaani̱a mu beizukulu ba Yakobbo, mbagumegume mwihanga lyʼI̱saleeri̱. ");
INSERT INTO rub_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“We Yu̱da, beenyu̱ baalikuhaariiza, beenyu̱ balyetu̱lu̱ka hansi kukuha ki̱ti̱i̱ni̱sa, wooli̱si̱ngu̱ra banyanzigwa baamu. ");
INSERT INTO rub_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ai̱ Yu̱da mwana gwa ntali, oru̱gi̱ri̱yo ha mu̱hi̱i̱go, mwana wange. Weedi̱ri̱i̱ri̱, ohu̱u̱mwi̱ri̱, nka ntali gi̱kali̱, alihayo yo akusobora ku̱ku̱si̱si̱mu̱la? ");
INSERT INTO rub_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Mubbeere gwa b̯ukama, we Yu̱da, tigulikurugaho, b̯ubbe b̯u̱lemi̱ b̯wa mateeka ku̱ku̱ti̱ga, ku̱doosya yogwo munyakukomwa b̯wali̱i̱za, yooyo alibba na ki̱ti̱i̱ni̱sa mu mahanga gensei̱. ");
INSERT INTO rub_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Alibboha ndogoyi̱ gyamwe ha mu̱zabbi̱bbu̱, mwana gwa ndogoyi̱ agu̱bbohe ha mu̱zabbi̱bbu̱ gurungi. Kyakulwala kyamwe ali̱ki̱nabi̱sya vi̱i̱no; na kanzu gyamwe mu maaci ga mi̱zabbi̱bbu̱. ");
INSERT INTO rub_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Mei̱so gaamwe geicalanga gengi̱ri̱ hab̯wa kunywa maaci, meino gaamwe gasyanu̱ kukira mate. ");
INSERT INTO rub_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Zabbu̱looni̱ yeicaalanga ha mutanda gweitaka, mutanda gwamwe gwabbanga musoma gwa maati̱, kandi mubaga gwamwe gulisambiira Si̱dooni̱. ");
INSERT INTO rub_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“I̱saakaari̱ ali ndogoyi̱ gyamaani, gi̱leeri̱ hansi, gyetweki̱ri̱ migugu rubaju na rubaju. ");
INSERT INTO rub_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Yaaweeni̱ kiikaru kyab̯uhuumulo b̯wamwe nikili kirungi, na gi̱gyo nsi gyamusemeera, yeehayo kwetweka myetweko myayo, yaabba mwiru akukora milimo mya maani. ");
INSERT INTO rub_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Daani̱ alibba mu̱lemi̱ wa bantu baamwe. Beizukulu baamwe balijana na nganda zindi zensei̱ zʼI̱saleeri̱. ");
INSERT INTO rub_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Yaabbanga mpiri giicala ha muhanda, giwa b̯umala gikeicala kwantandu wa nzira giluma magulu ga mbaraasi, aleke mu̱vu̱gi̱ waagyo yeekuute hansi. ");
INSERT INTO rub_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“Ai̱ Mukama, nku̱li̱ndi̱ri̱i̱ri̱ onjune. ");
INSERT INTO rub_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gaadi̱ ali̱ru̱mbwa banyagi̱, nayo alibahondera abaru̱mbe. ");
INSERT INTO rub_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Itehe lyʼAseeri̱ lyeryanga bidyo birungi, yooyo yaagabiranga mukama bidyo bi̱nolu̱. ");
INSERT INTO rub_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Nafutaali oli nka mparaaki gi̱bateeswi̱ri̱, b̯uguma gikabyala b̯wana b̯urungi. ");
INSERT INTO rub_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Yozefu̱ ali musaali gukaana byana birungi, musaali gukereera heehi̱ nei̱zu̱ba, gwa mataagi̱ gakahandira ha ki̱si̱i̱ka. ");
INSERT INTO rub_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Aru̱mbi̱i̱rwe banyanzigwa baamwe na mbasi, baamulasa mu ki̱ni̱ga kinene. ");
INSERT INTO rub_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Bei̱tu̱ b̯uta b̯wamwe b̯wi̱ceeri̱ b̯uciike, abalwani̱si̱i̱rye mu maani ga Ruhanga wa Yakobbo, yogwo Waamaani Gensei̱, kandi yooyo Mu̱li̱i̱sya, Lubbaali lwʼI̱saleeri̱, ");
INSERT INTO rub_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","kubba yooyo Ruhanga wa bbaawu akujuna, kubba yooyo Waamaani Gensei̱ akuha mu̱gi̱sa. Akuha mi̱gi̱sa mya ndagali̱ kuruga hakyendi̱, akuha mi̱gi̱sa mya meezi̱ garuga mu misu mya hansi, akuhe mi̱gi̱sa mya kubba na beizukulu banene. ");
INSERT INTO rub_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Mi̱gi̱sa, mya gya bbaawu, mingaba mya maani kukira mya nsahu za kadei, minene kukiraho nsahu za woodi̱ kadei na kadei. Mi̱myo mi̱gi̱sa myecalanga ha mu̱twe gwa Yozefu̱, kandi miicalenge ha mu̱twe gwa yogwo munyakukomwa mu baab̯u. ");
INSERT INTO rub_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Bbenyami̱i̱ni̱ ali nka musege gu̱tu̱u̱bi̱ri̱, mwakya na joojolo ei̱ta naataagura banyanzigwa baamwe.” ");
INSERT INTO rub_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Zi̱zo zoozo nganda i̱ku̱mi̱ neibiri zʼI̱saleeri̱, kandi bi̱byo byobyo bigambu bya bbaawaab̯u Yakobbo bi̱yaabaweereeri̱ b̯uyaali nakubaha mi̱gi̱sa. B̯uli muntu yaamu̱heeri̱ mu̱gi̱sa gu̱mu̱semereeri̱. ");
INSERT INTO rub_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Nahaahwo, Yakobbo yaabaheeri̱ gaga mateeka naakoba yati, “Ndi heehi̱ ku̱kwa mpondere bahaaha bange. Mwanziikanga hamwei̱ na bbaabba na haaha mu bwingira mu kibanja kyʼEfu̱rooni̱ Mu̱hi̱i̱ti̱. ");
INSERT INTO rub_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","B̯u̱b̯wo b̯wob̯wo b̯wingira b̯wa mu kibanja kya Makipera, ki̱hereeri̱ b̯uhulukalyoba b̯wa Mamu̱le, mu nsi gya Kanani̱. Kibanja ki̱kyo, I̱bbu̱rahi̱mu̱ yaaki̱gu̱u̱ri̱ kuruga hali Efu̱rooni̱ Mu̱hi̱i̱ti̱, kibbe kibanja kyamwe kya kuzikirangamwo bantu baamwe. ");
INSERT INTO rub_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ku̱kwo hooho baazi̱i̱ki̱ri̱ I̱bbu̱rahi̱mu̱ na mu̱kali̱ waamwe Saara, I̱saka na mu̱kali̱ waamwe Rebbeeka, kandi de hooho nyaazi̱i̱ki̱ri̱ Leeya. ");
INSERT INTO rub_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Kibanja ki̱kyo na b̯wingira b̯unyakubbamwona, I̱bbu̱rahi̱mu̱ yaabi̱gu̱u̱ri̱ kuruga hali Bahi̱i̱ti̱.” ");
INSERT INTO rub_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yakobbo b̯u̱yaamaari̱ kuragira batabani̱ baamwe, yaalaala ha ntabbu gyamwe, yaakwa. ");
INSERT INTO rub_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yozefu̱ yeetu̱lu̱ki̱ri̱ mu mei̱so ga bbaawe yaatandika kulira, yaamugwa mu salaka. ");
INSERT INTO rub_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Yozefu̱ yaaragira bakori̱ ba byab̯womi bajanjabe mutumbi gwa bbaawe, kwokwo de baakakoori̱. ");
INSERT INTO rub_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Baajanjaba mutumbi hab̯wa biro maku̱mi̱ ganei, kaka kooko kasu̱mi̱ kanyakwetagi̱syanga kwomya mutumbi. Banyami̱si̱ri̱ baamu̱li̱i̱ri̱ kumala biro nsanju. ");
INSERT INTO rub_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Biro bya kuganya b̯u̱byakamali̱ki̱ri̱, Yozefu̱ yaaweera balemi̱ ba Faraaho naakoba yati, “Mwakabba mu̱ngonzi̱ri̱, muweere Faraaho nimukoba yati, ");
INSERT INTO rub_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Bbaabba atakakwi̱ri̱, yankoreseerye ndagaanu naakoba yati, “Nyanga gi̱nyeeli̱mi̱i̱ri̱ mu nsi gya Kanani̱ hooho olinziikira.” Nahab̯waki̱kyo, leka ngyende nziike bbaabba, nkwi̱za kwi̱ra.’ ” ");
INSERT INTO rub_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Faraaho yei̱ri̱ri̱mwo naakoba yati, “Gyenda oziike bbaawu nka ku̱weeragi̱ri̱.” ");
INSERT INTO rub_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Nahaahwo, Yozefu̱ yaagyenda hamwei̱ na baheereza ba Faraaho, bahandu̱ ba mu nnyu̱mba gyamwe hamwei̱ na ba mu nsi gya Mi̱si̱ri̱ gyensei̱ kuziika bbaawe. ");
INSERT INTO rub_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Yozefu̱ yaatwalegeeni̱ bantu ba mu̱gi̱ gwamwe bensei̱ na gwa bbaawe. Baana bato hamwei̱ na magana gaab̯u byobyo byasi̱geeri̱ mu nsi gya Goseni̱. ");
INSERT INTO rub_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Yaagyendi̱ri̱ na lugologombo lwa bantu, batembi̱ri̱ bigaali na mbaraasi. ");
INSERT INTO rub_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","B̯u̱baadoori̱ mu rub̯uga Ataadi̱ lu̱basu̱ku̱si̱rengi̱ho bilimwa, ntaadu̱ko gya mugira gwa Yorodaani, baali̱i̱ri̱ hoi̱ hab̯wa Yakobbo. Yozefu̱ yaali̱i̱ri̱ bbaawe kumala biro musanju. ");
INSERT INTO rub_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Banyakanani̱ banyakwicalanga hahwo b̯u̱baaweeni̱ bantu nka kubaali kuganya ha rub̯uga Ataadi̱ lu̱basu̱ku̱si̱rengi̱ho bilimwa, baakoba yati, “Ku̱kwa kwʼI̱saleeri̱, kyasaali̱i̱ze hoi̱ Banyami̱si̱ri̱.” Kiikaru ki̱kyo, baakyeta Abberi̱-mi̱si̱rayi̱mu̱, kili heehi̱ na Yorodaani. ");
INSERT INTO rub_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Nahab̯waki̱kyo, kwokwo yatyo batabani̱ ba Yakobbo baazi̱i̱ki̱ri̱ Bbaawaawu̱ nka kuyaali abaragi̱i̱ri̱. ");
INSERT INTO rub_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Baamu̱tweri̱ mu nsi gya Kanani̱, baamuziika mu b̯wingira b̯wa mu kibanja kya Makipera, ki̱hereeri̱ b̯uhulukalyoba b̯wa Mamu̱le, kyʼI̱bbu̱rahi̱mu̱ kiyaali agu̱u̱ri̱ kuruga hali Efu̱rooni̱ Mu̱hi̱i̱ti̱, aleke kikorenge nkei̱ri̱mbo. ");
INSERT INTO rub_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yozefu̱ b̯u̱yaamaari̱ kuziika bbaawe, yei̱ra Mi̱si̱ri̱ na baab̯u, hamwei̱ na bantu benseenya banyakubba bagyendi̱ri̱ ku̱mu̱zi̱ki̱sya bbaawe. ");
INSERT INTO rub_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Baab̯u Yozefu̱ b̯u̱baaweeni̱ bbaawaab̯u akwi̱ri̱, baabazi̱ri̱ nibakoba yati, “Kale nu hataati̱ Yozefu̱ akwi̱za kuhoora nzi̱go gya bibiibi byensei̱ bi̱twamu̱koori̱.” ");
INSERT INTO rub_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Kasi baamutumira b̯ukwenda b̯ukukoba yati, “Bbaawu b̯uyaali atakakwi̱ri̱ yaateeri̱ho kiragiro kikukoba yati, ");
INSERT INTO rub_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Muweere Yozefu̱ nimukoba yati, “Beiraba ganyira bibii na nsobi̱ za baana beenyu̱, bi̱baakoori̱.” ’ Kandi oi̱re oganyire bibii bya twe baheereza ba Ruhanga wa bbaawe.” B̯u̱baamu̱weereeri̱ bi̱byo bigambu Yozefu̱ yaalira. ");
INSERT INTO rub_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Kasi baab̯u bei̱za baagwa mu mei̱so gaamwe nibakoba yati, “Hataati̱ tuli baheereza baamu.” ");
INSERT INTO rub_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Yozefu̱ yaabei̱ri̱ri̱mwo naakoba yati, “Mu̱tati̱i̱na, Ruhanga yooyo agira b̯u̱sobozi̱ b̯wa kufubira bantu. Gya tindi Ruhanga. ");
INSERT INTO rub_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Nywe mwendeerye kunkora kubiibi, bei̱tu̱ Ruhanga yaakifoora kirungi mwa kujuna bantu banene, nka kukili hataati̱. ");
INSERT INTO rub_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Nahab̯waki̱kyo mu̱leke ku̱ti̱i̱na, nkwi̱za kubaheereza kurungi hamwei̱ na baana beenyu̱.” Kwokwo yatyo yaabatati̱i̱rye na bigambu bya mbabazi̱. ");
INSERT INTO rub_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Nahab̯waki̱kyo Yozefu̱ yei̱ceeri̱ Mi̱si̱ri̱ na bantu ba mu̱gi̱ gwa bbaawe benseenya, yaakwi̱ri̱ adooseerye myaka ki̱ku̱mi̱ nei̱ku̱mi̱ (110) mya b̯u̱handu̱. ");
INSERT INTO rub_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Yozefu̱ yaasoboori̱ kuwonaho baana bʼEfu̱rayi̱mu̱ na beizukulu baamwe. Yaatangiira baana ba Maki̱i̱ri̱, mu̱tabani̱ wa Manaase, mu mu̱gi̱ gwamwe. ");
INSERT INTO rub_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Yozefu̱ yaaweereeri̱ baab̯u naakoba yati, “Gya ndi heehi̱ ku̱kwa, bei̱tu̱ Ruhanga alijuna beizukulu beenyu̱ abatoole mu gigi nsi, abatwale mu nsi gi̱yaaragani̱si̱i̱rye I̱bbu̱rahi̱mu̱, I̱saka na Yakobbo.” ");
INSERT INTO rub_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Yozefu̱ yaasabi̱ri̱ baana bʼI̱saleeri̱ kurahira. Yaabaweera naakoba yati, “Mu mananu Ruhanga b̯walikabajuna kuruga Mi̱si̱ri̱, mulinakutwala maku̱ha gange kuruga haha.” ");
INSERT INTO rub_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Yozefu̱ yaakwi̱ri̱ adooseerye myaka ki̱ku̱mi̱ nei̱ku̱mi̱ (110) mya b̯u̱handu̱. Baamwomeerye mubiri gwamwe, baamuta mu sandu̱u̱ko mu Mi̱si̱ri̱.");
INSERT INTO rub_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","Mu biro bya kadei, hali balemi̱ bʼI̱saleeri̱ baali basali ba misangu, haagwi̱ri̱ho nzala gya maani hoi̱ mu nsi gi̱gyo gyʼI̱saleeri̱. Kandi haaloho mudulu gi̱beetengi̱ Eri̱mereki̱ wa mu luganda lwʼEfu̱raati̱, munyakwicalanga mu rub̯uga lwa Bbeterehemu̱ mu Yu̱da. Yogwo mudulu yaaru̱gi̱ri̱ mu gi̱gyo nsi hamwei̱ na mu̱kali̱ waamwe gi̱beetengi̱ Nahu̱me na batabani̱ babiri babeetengi̱ Mahalooni̱ na Ki̱ryoni̱, baagyenda kwicala mu nsi gya Mowaabbu. ");
INSERT INTO rub_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","B̯ubaali nibacaali mu nsi gya Mowaabbu, Eri̱mereki̱ yaakwa, Nahu̱me yaasigala na batabani̱ baamwe babiri. ");
INSERT INTO rub_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Hei̱nyu̱ma bab̯wo batabani̱ ba Nahu̱me baatu̱ngi̱ri̱ bakali̱ bakuswera kuruga mu bantu ba Mowaabbu. Omwei̱ hali bab̯wo bakali̱ baamwetengi̱ Oru̱pa na wondi Ru̱u̱si̱. Bei̱tu̱ hei̱nyu̱ma gya myaka nkei̱ku̱mi̱, ");
INSERT INTO rub_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","na batabani̱ ba Nahu̱me nabo baakwa. Ku̱kwa kwab̯u kwamu̱ti̱gi̱ri̱ yankei, atali nei̱ba na batabani̱. ");
INSERT INTO rub_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Bei̱tu̱ Nahu̱me b̯uyaali nacaali mu Mowaabbu, yeegwi̱ri̱ho makuru gakukoba Mukama nka ku̱yaaju̱ni̱ri̱ bab̯wo bantu bʼI̱saleeri̱ yaabaha kwerya bidyo binene. Nahab̯waki̱kyo yeetegeka na bamukaabaana baamwe kwemuka kwamwab̯u. ");
INSERT INTO rub_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Mu kuruga hahwo cali yei̱calengi̱ yaasetu̱ki̱ri̱ na bamukaabaana baamwe babiri, baatandika kulibata kwi̱rayo mu nsi gya Yu̱da. ");
INSERT INTO rub_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Bei̱tu̱ hei̱nyu̱ma Nahu̱me yaaweera bamukaabaana baamwe yati, “Mwemu̱ke, b̯uli muntu agyende kwamwab̯u hali mmaawe. Nka kumwali na mbabazi̱ hali bei̱ba beenyu̱ na hali gya, nanywe nkubasabira, Mukama abagiire mbabazi̱. ");
INSERT INTO rub_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Mukama abahe b̯uli omwei̱ kuswerwa. Abahe b̯u̱si̱nge mu maka geenyu̱ gahyaka.” Kasi kandi yaabagwa mu salaka yaabaraga, bei̱tu̱ bo baatamwo kizabiro, baalira. ");
INSERT INTO rub_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Baamwi̱ri̱ri̱mwo nibamuweera, “Twe tukugyenda kwicala nawe mu bantu baamu.” ");
INSERT INTO rub_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Bei̱tu̱ yaabei̱ri̱ri̱mwo naabaweera, “Baana bange, mwemu̱ke kwamwenyu̱. Kikyani kikubaha kugyenda nagya? B̯u̱b̯wo nagya de mu̱ku̱nni̱hi̱ra kubba nimbyalayo baana bandi ba b̯udulu balibba bei̱ba beenyu̱? ");
INSERT INTO rub_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Baana bange, mwemu̱ke hali babyeru̱ beenyu̱, hab̯wakubba ngu̱lu̱u̱si̱ri̱ tincakasobora kutunga mudulu akunswera. Kadi nab̯wo, mbenge nincali na kyeni̱hi̱zo kya kubyala mu biteekerezu byange, rundi, mbenge nindi na mudulu deeru lili, nkabyala baana ba b̯udulu, ");
INSERT INTO rub_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","mwakeicala mu̱bali̱ndi̱ri̱ri̱ ku̱doosya babbeeri̱ basigazi bahandu̱? Mwakali nimwicala mutasweberwe hab̯wab̯u? Tikikusoboka, bamukaabaana bange. Gya b̯ujune b̯undinab̯wo b̯ukukira b̯wenyu̱ b̯umuli nab̯wo, hab̯wakubba Mukama yooyo ankoori̱ yati.” ");
INSERT INTO rub_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","B̯u̱beegwi̱ri̱ yatyo baatamwo kizabiro kindi. Kasi mwomwo Oru̱pa yaagwa mubyala gyamwe mu salaka yaamuraga, bei̱tu̱ Ru̱u̱si̱ yaamwehomereeri̱. ");
INSERT INTO rub_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Nahu̱me yaamuweera, “Wona, mukaamuramwo alimukwemuka hali bantu baamwe na hali baruhanga baamwe. Gyenda nayo.” ");
INSERT INTO rub_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Ru̱u̱si̱ yei̱ri̱ri̱mwo mubyala gyamwe naamuweera yati, “Leka kumpambiriza kwemuka. Cali okugyenda hooho nkwi̱za kugyenda, cali okwicala hooho nkwi̱za kwicala. Bantu baamu baabbanga bantu bange, na Ruhanga waamu yaabbanga Ruhanga wange. ");
INSERT INTO rub_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Cali oligwa hooho ndigwa, kandi hooho ndiziikwa. Nku̱rahi̱ri̱i̱ri̱, gya nawe lu̱ku̱u̱ lwolwo luli twahu̱kani̱a, bei̱tu̱ kakubba nkurugaho mu mu̱li̱ngo gwensei̱, Mukama yanfubiranga na kifubiro kinyamaani.” ");
INSERT INTO rub_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Nahu̱me b̯u̱yaakakyetegeri̱i̱ze nka Ru̱u̱si̱ kuyaalingi amali̱ri̱i̱ri̱ ki̱mwei̱ kugyenda nayo, atakab̯u̱u̱ni̱e kumuweera kintu kya kwemuka kwamwab̯u. ");
INSERT INTO rub_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Nahab̯waki̱kyo kwokwo yatyo bab̯wo bakali̱ babiri baagyendi̱ri̱ hamwei̱ ku̱doosya b̯u̱baadoori̱ Bbeterehemu̱. B̯u̱baadoori̱ Bbeterehemu̱ rub̯uga lwensei̱ lwajagaara hab̯wa bab̯wo bantu babiri. Mwomwo bakali̱ ba mu̱mwo mu rub̯uga beeb̯u̱u̱lya, “Yogwo mu̱kali̱ yaakubba Nahu̱me kwo?” ");
INSERT INTO rub_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Nahu̱me yaabei̱ri̱ri̱mwo naakoba, “Mu̱leke kunzeta Nahu̱me, mu̱nzete Maara, hab̯wakubba Ruhanga Wab̯u̱sobozi̱ B̯wensei̱ andeeteeri̱ b̯ujune mu b̯womi b̯wange. ");
INSERT INTO rub_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","B̯u̱nyaaru̱gi̱ri̱ haha nyaagyendi̱ri̱ nindi na mu̱gi̱ na bintu bikumala, bei̱tu̱ Mukama anzi̱ri̱i̱rye ntali na kintu. Haloho nsonga gyensei̱ gikubaha kunzeta Nahu̱me? Mukama Wab̯u̱sobozi̱ B̯wensei̱ yooyo andeeteeri̱ kuwonawona, kandi yooyo andeeteeri̱ b̯ub̯u b̯ujune.” ");
INSERT INTO rub_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Kwokwo yatyo Nahu̱me yei̱ri̱ri̱ kuruga mu nsi gya Mowaabbu na mukaamwana waamwe, Ru̱u̱si̱, Nyakamowaabbu. Hali baadwereeri̱ Bbeterehemu̱, b̯u̱su̱mi̱ b̯u̱b̯wo b̯wali b̯wa bantu kutandika kukesa nganu. ");
INSERT INTO rub_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Haalingiho mudulu omwei̱ wa mu Bbeterehemu̱ gi̱beetengi̱ Bbowaazi. Bbowaazi yaalingi mudulu mu̱gu̱u̱da yeegebeerwe, kandi wa mu luganda lwʼEri̱mereki̱, i̱ba Nahu̱me. ");
INSERT INTO rub_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Kiro ki̱mwei̱, Ru̱u̱si̱, Nyakamowaabbu, yaaweereeri̱ Nahu̱me naakoba, “Nzikiriza ngyende mu misiri mya bantu aleke nkomakomereerye nganu gi̱si̱gali̱i̱ri̱ mu musiri gwa muntu yensei̱ akwi̱za kungiriira mbabazi̱.” Nahu̱me yaamwi̱ri̱ri̱mwo naamuweera, “Mwana wange, gyenda.” ");
INSERT INTO rub_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Nahab̯waki̱kyo Ru̱u̱si̱ yaagyendi̱ri̱ mu misiri kwokwo yaatandika ku̱komakomereerya nsigalira za nganu, i̱nyu̱ma lya bantu banyakubba nibakukesa. Kya mu̱gi̱sa gurungi yeezagi̱i̱rye naaku̱komakomereerya nsigalira zi̱zo mu musiri gwa Bbowaazi munyakubba nali munyaruganda wʼEri̱mereki̱, mu̱geni̱ wa Ru̱u̱si̱. ");
INSERT INTO rub_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Nahaahwo hooho Bbowaazi yei̱zi̱i̱ri̱ kuruga Bbeterehemu̱, yaadwa yaaramu̱kya bab̯wo bakesi̱, “Mbaramu̱ki̱i̱rye, Mukama abbe nanywe!” Baamwi̱ri̱ri̱mwo nibakoba, “Tu̱ku̱ramu̱ki̱i̱rye natwe, Mukama akuhe mu̱gi̱sa!” ");
INSERT INTO rub_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Kasi mwomwo Bbowaazi yaab̯u̱u̱lya mu̱handu̱ wa bakesi̱, “Yogwo muhala ali muhara wa naani?” ");
INSERT INTO rub_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Mu̱handu̱ wa bakesi̱ yaamwi̱ri̱ri̱mwo naakoba, “Yogwo muhala ali Nyakamowaabbu mu̱nyakwi̱za na Nahu̱me kuruga mu nsi gya Mowaabbu. ");
INSERT INTO rub_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Ansabi̱ri̱ naakoba, ‘Beiraba, ndeka nkomakomereeryemwo, nsorooze nsigalira za ha bibbambu bya bab̯wo bakesi̱.’ Kale nu, kuruga mwakya, ei̱ceeri̱ mu musiri naakora na maani ku̱doosya hataati̱, kutoolahoona hab̯wa b̯wi̱re b̯u̱dooli̱ b̯ub̯u b̯wahu̱mwi̱ri̱ho mu katu̱ntu̱lu̱.” ");
INSERT INTO rub_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Nahab̯waki̱kyo Bbowaazi yaagyendi̱ri̱ hali Ru̱u̱si̱ yaamuweera, “Muhara wange, weegwa bigambu binkukuweera. Otagyenda ku̱komakomereerya nganu mu musiri gundi, otalirugahoona haha. Icala haha na bahala bakori̱ bange ");
INSERT INTO rub_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Oicalenge nookora na bahala bakori̱, bahondera badulu bakesi̱. Ndagi̱i̱ri̱ bab̯wo badulu batakugadagadya. B̯uwaakakwatwanga nyoota, gyendanga noonywa meezi̱ hali bi̱byo byese bya badulu bateeri̱mwo meezi̱.” ");
INSERT INTO rub_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Nahab̯waki̱kyo Ru̱u̱si̱ yaaku̱ndi̱ri̱ malu̱ hansi yaasi̱i̱ma, kandi yaab̯u̱u̱lya Bbowaazi, “Nsonga kyani gi̱ku̱heeri̱ kubba na mbabazi̱ zi̱jeeni̱ hahwo hali gya munyamahanga?” ");
INSERT INTO rub_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Bbowaazi yaamwi̱ri̱ri̱mwo naamuweera, “Bintu byensei̱ byobbanga nookoora mubyala gyamu kuruga i̱baawu̱ b̯u̱yaakwi̱ri̱, babi̱mbwereeri̱, nka ku̱waaru̱gi̱ri̱ kwamwenyu̱ hali bbaawu na maawu wei̱za kwicala na bantu bawaali otakawonangaho. ");
INSERT INTO rub_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Nkusaba Mukama akusasule bintu bi̱waakoleeri̱ Nahu̱me. Mukama Ruhanga wʼI̱saleeri̱ hali oi̱ru̱ki̱i̱ri̱ akujune, akuhe mu̱gi̱sa otunge binene.” ");
INSERT INTO rub_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Mwomwo Ru̱u̱si̱ yaaweera Bbowaazi, “Mukama wange, onzolokeerye mbabazi̱ kwo, hab̯wakubba bigambu bya mbabazi̱ byombwereeri̱ bi̱mpu̱mu̱li̱i̱rye mutima, nab̯unyakabba ntali omwei̱ hali bazaana baamu.” ");
INSERT INTO rub_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","B̯wi̱re b̯wa kudya b̯u̱b̯wadoori̱ Bbowaazi yaaweera Ru̱u̱si̱, “I̱za haha kudya. Weetonera bidyo, obi̱di̱i̱sye li̱lyo nnyeni̱ lya vi̱i̱no.” Ru̱u̱si̱ b̯u̱yei̱cali̱i̱ri̱ kudya hamwei̱ na bakesi̱, Bbowaazi yaamuhaho nganu gi̱syeke. Ru̱u̱si̱ yaadi̱i̱ri̱ b̯uli kidyo ki̱yendeerye yeicuta, yaati̱ga na bindi. ");
INSERT INTO rub_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Ru̱u̱si̱ b̯u̱yaaku̱bi̱ri̱yo mu musiri ku̱komakomereerya nganu, Bbowaazi yaaragi̱ri̱ bab̯wo bakori̱ baamwe naabaweera, “Ru̱u̱si̱ nab̯u̱yaakakomereeryanga nganu mu gi̱gyo nganu gi̱bboheerwe, mutamugaananga. ");
INSERT INTO rub_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Na kindi, mulinakutoolanga nganu gindi ha gi̱gyo gi̱mu̱bbohi̱ri̱ nimumulekeraho aleke nayo atungeho nganu gi̱yaakomakomereerya, mutamugaananga.” ");
INSERT INTO rub_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Nahab̯waki̱kyo Ru̱u̱si̱ yaakomakomereerye nganu mu musiri gwa Bbowaazi kudwereera ki̱mwei̱ joojolo. Kasi mwomwo yaasukusa gi̱gyo nganu yei̱zu̱u̱lya lukimba lwa mpuule lukwijanjana ki̱logu̱raamu̱ i̱ku̱mi̱. ");
INSERT INTO rub_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Yeetweki̱ri̱ lukimba lwamwe yeemuka mu rub̯uga, Bbeterehemu̱. B̯u̱yeemu̱ki̱ri̱, mubyala gyamwe yaadoori̱ yaawona b̯unene b̯wa nganu giyaalingi akomakomereerye. Kindi, Ru̱u̱si̱ yaaleeteeri̱ mubyala gyamwe bidyo bi̱yaabboheeri̱ ha bidyo binyakumulema kudya. ");
INSERT INTO rub_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Mubyala gyamwe amu̱b̯u̱u̱lya, “Musiri kyani gu̱gwo gwokomakomereeryemwo gigi nganu? Musiri gwa naani gu̱gwo gwoi̱ceeri̱ nookoleeramwo? Mudulu yogwo aku̱gi̱ri̱i̱ri̱ mbabazi̱, Mukama amuhe mu̱gi̱sa.” Mwomwo Ru̱u̱si̱ yaaweera mubyala gyamwe bintu bikukwatagana na yogwo mudulu cali yaali akoleeri̱. Yaamu̱weereeri̱ naakoba, “Yogwo mudulu cali nyaakoleeri̱ deeru, ibara lyamwe Bbowaazi.” ");
INSERT INTO rub_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Nahu̱me yei̱ri̱ri̱mwo mukaamwana waamwe, “Nkusaba Mukama yogwo eicala wa mbabazi̱ hali boomi na hali baku̱u̱, ahe yogwo mudulu mu̱gi̱sa.” Yaagyendi̱ri̱ mu mei̱so naaweera Ru̱u̱si̱, “Yogwo mudulu abba mwijwa ibange, kandi muramu wange akusemeera kubba naatulinda.” ");
INSERT INTO rub_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Mwomwo Ru̱u̱si̱, Nyakamowaabbu, yaabaza naakoba, “Kindi yogwo mudulu yaambwereeri̱ yati, ‘Icalanga na bab̯wo bakori̱ bange ku̱doosya b̯ubalikamala kukesa nganu gyange gyensei̱.’ ” ");
INSERT INTO rub_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Nahu̱me yaaweera mukaamwana naakoba, “Mwana wange, ki̱kwi̱za kubba kirungi oicalenge heehi̱ na bahala bakori̱ baamwe, hab̯wakubba kakubba ogyenda mu musiri gwa wondi bakusobora ku̱ku̱gadagadi̱i̱rya yo.” ");
INSERT INTO rub_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Kuruga na b̯u̱b̯wo Ru̱u̱si̱ yaabbengi̱ heehi̱ na bahala bakori̱ ba Bbowaazi, b̯uyaakabanga naakomakomereerye nganu mu musiri, ku̱doosya b̯u̱baakakesi̱ri̱ kumala nganu gyensei̱. Bei̱tu̱ yaagyendi̱ri̱ mu mei̱so nakwicala na mubyala gyamwe. ");
INSERT INTO rub_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Kiro ki̱mwei̱, Nahu̱me yaab̯u̱u̱li̱i̱rye Ru̱u̱si̱ naakoba, “Mukaamwana wange, okuteekereza tikikudwa b̯u̱dwi̱ nkutungire maka galimwo b̯u̱si̱nge cali okwi̱za kubba na mudulu akukuwoneera kurungi? ");
INSERT INTO rub_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Oicale okyegi̱ri̱ nti, Bbowaazi wa bazaana bokwicalanga nabo, abba mu̱ramu̱weetu̱. Deeru joojolo lyoli akwi̱za kubba naakusukusa nganu. ");
INSERT INTO rub_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Nahab̯waki̱kyo, naaba mubiri, weesi̱i̱ge maku̱ta gakub̯unya kurungi kandi olwale lu̱goye lwamu lukukirayo b̯urungi. Kasi mwomwo ogyende heisukusuro lya nganu, bei̱tu̱ oteezoolokya hali Bbowaazi ku̱doosya b̯uyaakamala kudya na kunywa. ");
INSERT INTO rub_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","B̯uyaakalaala, weetegereze kiikaru kyani cali aleeri̱. Hei̱nyu̱ma ogyende omub̯ukule magulu, olaale hahwo hali yo. Akwi̱za kubba nakyakukuweera kukora.” ");
INSERT INTO rub_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Ru̱u̱si̱ yei̱ri̱ri̱mwo mubyala gyamwe naakoba, “Nkugyenda kukora ki̱kyo kiwakambwera.” ");
INSERT INTO rub_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Nahab̯waki̱kyo Ru̱u̱si̱ yaagyendi̱ri̱ heisukusuro lya nganu yaakora b̯uli kintu kya mubyala gyamwe ki̱yaamu̱weereeri̱. ");
INSERT INTO rub_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Bbowaazi b̯u̱yaamaari̱ kudya na kunywa, yeezegwa nali kurungi, yaagyenda kulaalaho b̯ulo hahwo ha ntuumo za nganu. Ru̱u̱si̱ yaasobasoobi̱ri̱ mpula mpula, yaab̯ukula magulu ga Bbowaazi, yaalaala hahwo hali yo. ");
INSERT INTO rub_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","I̱jolo mwitumbi, Bbowaazi yeeru̱ndu̱ki̱ri̱ kintu, yeehindulahindula, yaagi̱i̱rye mu̱kali̱ aleeri̱ kwansi wa magulu gaamwe! ");
INSERT INTO rub_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Yaab̯u̱u̱lya, “Weewe naani?” Ru̱u̱si̱ yei̱ri̱ri̱mwo naamuweera, “Gyagya Ru̱u̱si̱ muzaana waamu. Nkukusaba ombeeke, hab̯wakubba weewe oli mwijwa ibange akusemeera kundinda.” ");
INSERT INTO rub_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Bbowaazi yaamwi̱ri̱ri̱mwo naamuweera, “Muramu wange, Mukama akuhe mu̱gi̱sa. Mbabazi̱ zizi zonzolokeerye zikukira zi̱zo zi̱woolokeerye mubyala gyamu. Hab̯wakubba weegombi̱ri̱ kwahi kutungwa basigazi, babbe nibali bagu̱u̱da rundi banaku. ");
INSERT INTO rub_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Kale nu hataati̱ muramu wange, leka ku̱ti̱i̱na. Nkwi̱za kukukoora ki̱kyo kyensei̱ kyosabi̱ri̱ nkukoore. Kandi bantu bensei̱ ba mu lulu rub̯uga bakyegi̱ri̱ nka kwoli mu̱kali̱ wa ngesu zirungi. ");
INSERT INTO rub_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Nab̯unyakabba nindi muramwo mu luganda lwetu̱, bei̱tu̱ haloho munyaruganda akusemeera kukulinda kukira gya. ");
INSERT INTO rub_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Laala haha i̱jolo lya deeru, b̯wi̱re b̯wa mwakya yogwo muramwo yaabba yendeerye kukulinda, yooyo akwi̱za kubba naakulinda. Bei̱tu̱ yaakasuula, nku̱rahi̱ri̱i̱ri̱ hali Mukama, nkwi̱za kukulinda. Laala haha ku̱doosya b̯wi̱re b̯wa mwakya.” ");
INSERT INTO rub_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Nahab̯waki̱kyo Ru̱u̱si̱ yaaleeri̱ hahwo mu magulu ga Bbowaazi ku̱doosya b̯wi̱re b̯ub̯wakei̱ri̱, yaabyoka mwakya karei mu kati̱ti̱ aleke hatabbaho muntu yensei̱ akumulengera. Kandi Bbowaazi yaateekereezi̱ mu mutima gwamwe naakoba, “Haatei̱za kubba muntu yenseenya akukyega nti haloho mu̱kali̱ yaaleeri̱ haha heisukusuro lya nganu.” ");
INSERT INTO rub_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Kindi Bbowaazi yaamu̱weereeri̱ naakoba, “Leeta kakwo kasuuka kawebbohi̱ri̱, okakwate nkuteeremwo nganu.” Ru̱u̱si̱ b̯u̱yaategi̱ri̱ kasuuka kamwei, Bbowaazi yaamu̱tereeri̱mwo nganu gikwijanjana ki̱logu̱raamu̱ maku̱mi̱ gabiri, yaamu̱tweka. Mwomwo Bbowaazi yeemuka mu rub̯uga. ");
INSERT INTO rub_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Ru̱u̱si̱ b̯u̱yeemu̱ki̱ri̱, mubyala gyamwe yaamu̱b̯u̱u̱lya, “Muhara wange, bintu byakali teetei̱?” Mwomwo Ru̱u̱si̱ yaamuweera bintu byensei̱ bya Bbowaazi bi̱yaamu̱koleeri̱, ");
INSERT INTO rub_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","yaagyenda mu mei̱so naakumuweera, “Yampeeri̱ ki̱logu̱raamu̱ maku̱mi̱ gasatu ga nganu, yambwera, ‘Oteemuka ngalu zisa hali mubyala gyamu.’ ” ");
INSERT INTO rub_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Kasi mwomwo Nahu̱me yaaweera mukaamwana, “Muhara wange, lindiira ku̱doosya b̯woliketegereza kintu ki̱bbeeri̱ho. Hab̯wakubba yogwo mudulu akwi̱za kwahi kuteekana ku̱doosya yaakamala zizi nsonga deeru.” ");
INSERT INTO rub_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","B̯u̱b̯wo Bbowaazi yaagyendi̱ri̱ yeicaara ha mulyangu gweirembu lya rub̯uga. Hei̱nyu̱ma munyaruganda yogwo wa Bbowaazi giyaali yaatu̱li̱i̱ri̱ Ru̱u̱si̱, munyakubba nakusemeera kumulinda, b̯u̱yei̱zi̱ri̱, Bbowaazi yaamweta yaamuweera, “Mwi̱ra wange, i̱za oicaare haha.” Mwomwo yogwo munyaruganda yaagyenda yeicaara. ");
INSERT INTO rub_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Bbowaazi yeeti̱ri̱ho na bahandu̱ bandi ba lu̱lwo rub̯uga yaabaweera, “I̱caare haha.” Nabo de, beicaara. ");
INSERT INTO rub_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Kasi mwomwo yaaweera yogwo munyaruganda waamwe naakoba, “Nahu̱me, muramu weetu̱ mu̱nyakwi̱ra kuruga mu Mowaabbu alimukutunda musiri gunyakubba gwa mwana weetu̱, Eri̱mereki̱. ");
INSERT INTO rub_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Ntekereeze nti ndinakuleeta zizi nsonga mu mei̱so gaamu aleke waakabba nookugula gu̱gwo musiri, ogugule mu mei̱so ga baba bahandu̱ ba bantu beetu̱. Bei̱tu̱ kandi waakabba otakugucungura, ombwere aleke nkyege. Hab̯wakubba tihaloho muntu yensei̱ akusemeera kugucungura, kutoolahoona weewe, rundi b̯u̱b̯wo gyagya nkubba ni̱nkwi̱ra mu magulu gaamu.” Munyaruganda yogwo yei̱ri̱ri̱mwo naakoba, “Nkwi̱za kugucungura.” ");
INSERT INTO rub_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Kindi Bbowaazi yaabazi̱ri̱ naakoba, “Kiro kiwaakagula gu̱gwo musiri hali Nahu̱me, b̯u̱b̯wo na Nyakamowaabbu, Ru̱u̱si̱, mukaa muziro Mahalooni̱ akwi̱za kubba mu̱kali̱wo mwa kulinda ibara lya muziro neitungo lyamwe.” ");
INSERT INTO rub_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Munyaruganda yogwo b̯u̱yeegwi̱ri̱ yatyo, yaabazi̱ri̱ naakoba, “Kyabba nikili yatyo, b̯u̱b̯wo nkubba ntakusobora kugucungura. Hab̯wakubba mukugucungura nkusobora kuleetera bantu bange b̯ujune. Kale, we gucungure, gya tincakasobora kugucungura.” ");
INSERT INTO rub_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","(Mu b̯u̱su̱mi̱ b̯wa kadei mu ngesu za Bei̱saleeri̱, muntu yaakacunguranga rundi yaakagulanga kintu, haabbengi̱ho kaboneru ka b̯u̱gu̱li̱ kakwolokya ki̱kyo kintu nka ku̱ki̱hi̱ngi̱ri̱ mikono. Omwei̱ mu bab̯wo bantu yaaku̱su̱lengi̱ nkei̱to gyamwe naagiha wondi. Gi̱gyo gyogyo gyali nkora ginyakwikirizib̯wanga mu b̯utongole mu nsi gyʼI̱saleeri̱.) ");
INSERT INTO rub_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Nahab̯waki̱kyo yogwo munyaruganda wʼEri̱meri̱ki̱ yaaweereeri̱ Bbowaazi naakoba, “Okusobora kugwegulira.” Kasi mwomwo yaakusula nkei̱to gyamwe. ");
INSERT INTO rub_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Mwomwo Bbowaazi yaaweera bab̯wo bahandu̱ na bantu bensei̱ banyakubbaho naakoba, “Kiro kiki muli bakei̱so bange ba byenseenya bi̱ngu̱u̱ri̱ hali Nahu̱me bya muziro Eri̱mereki̱, na batabani̱ Ki̱ryoni̱ na Mahalooni̱. ");
INSERT INTO rub_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Kandi na Ru̱u̱si̱ Nyakamowaabbu mukaa munyaruganda weetu̱, Mahalooni̱, mu̱twali̱reeni̱mwo nka mu̱kali̱ wange, aleke ibara lya Mahalooni̱ li̱tasyera kuruga mu mu̱gi̱ gwab̯u, rundi mu bitabbu bya rub̯uga. Kiro kiki muli bakei̱so bange.” ");
INSERT INTO rub_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Kasi mwomwo bahandu̱ na bantu bensei̱ banyakubbaho hahwo mwirembu lya rub̯uga babaza nibakoba, “Kwokwo, tuli bakei̱so baamu. Yogwo mu̱kali̱, Mukama amuhe kubba nka Lakeeri̱ na Leeya mu maka gaamu, bakali̱ babiri bab̯wo banyaku̱bi̱mba nnyu̱mba gyʼI̱saleeri̱. Mukama akuhe kubba wa maani mu nsi gyʼEfu̱raati̱ na Bbeterehemu̱. ");
INSERT INTO rub_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Kuruga mu lula lwa yogwo muhala wa Mukama aku̱heeri̱, mu̱gi̱ gwamu gwabbanga nka gwa Pereezi̱, mu̱tabani̱ wa Yu̱da gi̱yaabyeri̱ na Tamali̱.” ");
INSERT INTO rub_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Kuruga na b̯u̱b̯wo Bbowaazi yaaswera Ru̱u̱si̱ nka mu̱kali̱ waamwe. Bbowaazi b̯u̱yaakatu̱ngi̱ri̱ Ru̱u̱si̱, Mukama yaamuha mu̱gi̱sa yaatwala nda yaabyala mwana wa b̯udulu. ");
INSERT INTO rub_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Mwomwo bakali̱ ba mu lu̱lwo rub̯uga baaweera Nahu̱me nibakoba, “Mukama ahaariizib̯we kiro kiki hab̯wa kukuha mwizukulu yogwo alikulinda. Mukama amuhe kubba wa maani mu nsi gigi gyensei̱ gyʼI̱saleeri̱! ");
INSERT INTO rub_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Yogwo mwizukulu waamu yooyo alikuha kubba na ku̱ni̱hi̱ra kandi alikulinda, hab̯wakubba mukaamwana waamu Ru̱u̱si̱, yogwo akwendya kandi akukira kadi baana ba b̯udulu musanju, amu̱byeri̱ mwizukulu waamu.” ");
INSERT INTO rub_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Mwomwo Nahu̱me yaasenga mwana, yaamukiika kandi yei̱ceeri̱ naamuwoneera. ");
INSERT INTO rub_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Haaloho bakali̱ bataahi̱ banyakubaza nibakoba, “Nahu̱me atu̱ngi̱ri̱ mwizukulu.” Baamu̱heeri̱ ibara Obbeedi̱. Yooyo munyakubba bba Yese, Yese bba Dau̱di̱. ");
INSERT INTO rub_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Gugu gwogwo mu̱gi̱ gwa lula lwa Pereezi̱: Pereezi̱ yaabyeri̱ Hezi̱rooni̱, ");
INSERT INTO rub_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Hezi̱rooni̱ yaabyala Raamu̱, Raamu̱ yaabyala Aminadaabbu, ");
INSERT INTO rub_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Aminadaabbu yaabyala Nasooni̱, Nasooni̱ yaabyala Salu̱mooni̱, ");
INSERT INTO rub_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salu̱mooni̱ yaabyala Bbowaazi, Bbowaazi yaabyala Obbeedi̱, ");
INSERT INTO rub_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Obbeedi̱ yaabyala Yese, kandi Yese yaabyala Dau̱di̱.");
INSERT INTO rub_vpl VALUES ("ET1_1","018_1_1","EST","1","1","2","Mu biro byei̱nyu̱ma, haloho binyakubbaho Mukama Ahaswero naakwicala mu rub̯uga lu̱handu̱ lwa Su̱u̱sa, naakulema masaza ki̱ku̱mi̱ mu gabiri na musanju, kuruga B̯u̱hi̱ndi̱ kudwera ki̱mwei̱ I̱syopi̱ya. ");
INSERT INTO rub_vpl VALUES ("ET1_3","018_1_3","EST","1","3","3","Mu mwaka gwakasatu gwa b̯u̱lemi̱ b̯wamwe, Mukama Ahaswero yaati̱mbi̱i̱ri̱ bayolo baamwe bensei̱ na baheereza B̯u̱genyi̱. B̯u̱b̯wo B̯u̱genyi̱ b̯waleeti̱ri̱ bahandu̱ ba mahe na bamasaza ga Paasa na Medi̱ya, bakungu na bantu ba bi̱ti̱i̱ni̱sa ba mu masaza. ");
INSERT INTO rub_vpl VALUES ("ET1_4","018_1_4","EST","1","4","4","Ha b̯wi̱re b̯u̱b̯wo, mukama yaakoori̱ mwolokyo gwa byab̯u̱gu̱u̱da na ki̱ti̱i̱ni̱sa kya b̯ukama b̯wamwe gunyakumala biro ki̱ku̱mi̱ na kinaanei. ");
INSERT INTO rub_vpl VALUES ("ET1_5","018_1_5","EST","1","5","5","Hei̱nyu̱ma gyaho, mukama yei̱ri̱ri̱ yaasegeerya bagenyi̱ baamwe bensei̱ banyakubbaho mu rub̯uga lu̱handu̱ lwa Su̱u̱sa, babi̱ti̱i̱ni̱sa na batali mu zi̱gati̱ gya kikaali kumala biro musanju. ");
INSERT INTO rub_vpl VALUES ("ET1_6","018_1_6","EST","1","6","6","Zi̱gati̱ gya mukama gyati̱mbati̱mbi̱rwe mu nti̱mbe za rangi̱ gya kitaani na gya bbu̱ru̱ru̱ zinyakubba zi̱bboheerwe miguha mya rangi̱ gya bbafuta, byoma bya feeza bi̱zi̱ngi̱i̱rwe ku nkondo za mahi̱ga ga muhendu. Kandi de, haalimwo bisagu bya zaabbu na feeza binyakubba ha kikungu ki̱doli̱ge na mahi̱ga ga ku̱seraserya ga muhendu. ");
INSERT INTO rub_vpl VALUES ("ET1_7","018_1_7","EST","1","7","7","Byakunywa bi̱baaheeri̱ bagenyi̱, baabi̱basegereerye mu bi̱kopo bikwahukana bya zaabbu. Maaci ga muhendu gaali mu b̯unene, nka ki̱ti̱i̱ni̱sa kya b̯u̱b̯wo b̯ukama kukyali. ");
INSERT INTO rub_vpl VALUES ("ET1_8","018_1_8","EST","1","8","8","Hatakabbeho ki̱pi̱myo kya byakunywa, hab̯wakubba mukama yaalingi aragi̱i̱ri̱ baheereza baamwe bagabe byakunywa ku̱si̱gi̱ki̱ra ha kwendya kwa b̯uli omwei̱. ");
INSERT INTO rub_vpl VALUES ("ET1_9","018_1_9","EST","1","9","9","Mu kasu̱mi̱ kakwo koonyi̱ni̱, Mu̱go Vasi̱ti̱ nayo yaali asegereerye bakali̱ kiihuru mu kikaali kya Mukama Ahaswero. ");
INSERT INTO rub_vpl VALUES ("ET1_10","018_1_10","EST","1","10","10","Ha kiro kyamusanju kya B̯u̱genyi̱, Mukama Ahaswero b̯u̱yaakanywi̱ri̱ maaci ganene acamuka, aragira baheereza baamwe musanju, Mehumaani, Bi̱zu̱sa, Harabona, Bbi̱gaasa, Abbagu̱ta, Zetaari̱ na Karu̱kasi̱, ");
INSERT INTO rub_vpl VALUES ("ET1_11","018_1_11","EST","1","11","11","bamwetere Mu̱go Vasi̱ti̱. Mukama yendeerye mu̱kali̱ waamwe ei̱ze alweri̱ kondo gya b̯u̱go aleke yoolokye bagenyi̱ baamwe na bayolo bawone Vasi̱ti̱ nka kuyaali nyarurungi. ");
INSERT INTO rub_vpl VALUES ("ET1_12","018_1_12","EST","1","12","12","Bei̱tu̱ baheereza b̯u̱baadooseerye b̯u̱b̯wo b̯ukwenda, Mu̱go Vasi̱ti̱ asuula kwi̱za. Nahab̯waki̱kyo, mukama yaasali̱i̱rwe hoi̱, yaakwatwa ki̱ni̱ga. ");
INSERT INTO rub_vpl VALUES ("ET1_13","018_1_13","EST","1","13","13","Kasi mwomwo mukama yeeta baku̱gu̱ ku bya biragiro nab̯winganiza ku̱beeb̯u̱u̱lyaho, nka kugyalingi ngesu gya mukama, yaabaza nabo ku bintu binyakubba bi̱bbeeri̱ho mu b̯u̱su̱mi̱ b̯wei̱nyu̱ma. ");
INSERT INTO rub_vpl VALUES ("ET1_14","018_1_14","EST","1","14","14","Bab̯wo bayeesi̱gengi̱ hoi̱ baali: Kari̱seena, Sesaali̱, Adimaasa, Taru̱si̱i̱si̱, Meresi̱, Mari̱seena na Memu̱kaani̱, bayolo musanju ba mu masaza ga Paasa na Medi̱ya, nibali na biikaru bya maani hoi̱ mu b̯ukama kandi nibakwikirizib̯wa kuwona mukama b̯wi̱re b̯wensei̱ ku nsonga za maani. ");
INSERT INTO rub_vpl VALUES ("ET1_15","018_1_15","EST","1","15","15","Mwomwo mukama yaabaweera yati, “Mu̱go Vasi̱ti̱ aswi̱ri̱ kwi̱za hali gya b̯u̱mu̱tu̱mi̱i̱ri̱ beiru bange. Ku̱si̱gi̱ki̱ra ha biragiro, kikyani kindinakukora mu mbeera nka gigi? Aswi̱ri̱ bigambu bya mukama aragi̱i̱ri̱ beiru bamuweere.” ");
INSERT INTO rub_vpl VALUES ("ET1_16","018_1_16","EST","1","16","16","Mwomwo Memu̱kaani̱ yaabaza mu mei̱so ga mukama na bayolo baamwe yati, “Ajeemeeri̱ kwahi mukama musa, bei̱tu̱ Mu̱go Vasi̱ti̱ ajeemeeri̱ bayolo na bantu bensei̱ ba mu masaza gensei̱ ga b̯ukama b̯wa Mukama Ahaswero. ");
INSERT INTO rub_vpl VALUES ("ET1_17","018_1_17","EST","1","17","17","Bakali̱ bensei̱ bakwi̱za kutandika kugaya bei̱ba baab̯u b̯ubaketegereza Mu̱go Vasi̱ti̱ kyakoori̱. Bakwi̱za kubazanga nibakoba yati, ‘Mukama Ahaswero yaaragi̱i̱ri̱ bamwetere Vasi̱ti̱, Vasi̱ti̱ yaamusulukiira.’ ");
INSERT INTO rub_vpl VALUES ("ET1_18","018_1_18","EST","1","18","18","Kiro kyadeeru ki̱takamali̱ki̱ri̱, bamukaa bayolo bensei̱ ba b̯ukama mu Paasa na Medi̱ya baakeegwa bi̱byo bigambu bikukwatagana na kiki kikorwa kya Mu̱go Vasi̱ti̱, bakwi̱za kukora bei̱ba baab̯u bintu byobyo bi̱mwei̱, bibatab̯ure. ");
INSERT INTO rub_vpl VALUES ("ET1_19","018_1_19","EST","1","19","19","“Nahab̯waki̱kyo kwakabba nikuli ku̱si̱i̱ma kwamwe, mukama atehoona kiragiro, kihandiikwe mu biragiro bya Paasa na Medi̱ya, kandi kitalihindulwa. Kiragiro ki̱kyo ki̱kwi̱za kubba nikikugaana Vasi̱ti̱ kwi̱ra kuwonaho Mukama Ahaswero. Na kindi ki̱kyo kiikaru kya Mu̱go Vasi̱ti̱ kiheeb̯we mu̱kali̱ wondi akumukira. ");
INSERT INTO rub_vpl VALUES ("ET1_20","018_1_20","EST","1","20","20","Ki̱kyo kiragiro kihyaka b̯ukyakarangiirwa mu b̯ukama b̯wamu b̯wensei̱ nka kub̯wicala, bakali̱ bensei̱ bakwi̱za kugonderanga bei̱ba baab̯u, kababbe banaku rundi bagu̱u̱da.” ");
INSERT INTO rub_vpl VALUES ("ET1_21","018_1_21","EST","1","21","21","Mukama na bayolo baamwe baasi̱i̱mi̱ri̱ ki̱kyo kiteekerezu, kandi mukama yaakora nka Memu̱kaani̱ ku̱yaahanwi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("ET1_22","018_1_22","EST","1","22","22","Mukama yaasi̱ndi̱ki̱ri̱ mu b̯uli isaza lya b̯ukama b̯wamwe kihandiiko, kinyakuhandiikwa mu ndimi za b̯uli luganda nikikukoba nti, b̯uli nyineeka akusemeeranga kufuga maka gaamwe kandi na kubazanga na b̯u̱sobozi̱. ");
INSERT INTO rub_vpl VALUES ("ET2_1","018_2_1","EST","2","1","1","Hei̱nyu̱ma gya bi̱byo byenseenya, ki̱ni̱ga kya Mukama Ahaswero b̯u̱kyakagwi̱ri̱, yei̱zu̱ki̱ri̱ bintu bya Vasi̱ti̱ biyaali akoori̱ na kiragiro kibaali bamu̱teeri̱ho. ");
INSERT INTO rub_vpl VALUES ("ET2_2","018_2_2","EST","2","2","2","Mwomwo baheereza ba mukama baamuhanulira yati, “Ai̱ mukama, leka baku̱tooleerye mu b̯utaka b̯wamu b̯wensei̱ bahala bato banyarurungi batakawonangaho badulu. ");
INSERT INTO rub_vpl VALUES ("ET2_3","018_2_3","EST","2","3","3","Tuma bayolo baamu mu b̯uli isaza batoolye ndengeeti̱ zinyab̯urungi zitakawonangaho badulu babate mu nnyu̱mba gya bakali̱ baamu mu rub̯uga lu̱handu̱ lwa Su̱u̱sa. Hegaayi̱ muheereza waamu aheeb̯we b̯ujunaanizib̯wa b̯wa kubawoneera, babasi̱i̱ge maku̱ta gaku̱banyi̱ri̱i̱rya hoi̱. ");
INSERT INTO rub_vpl VALUES ("ET2_4","018_2_4","EST","2","4","4","Kasi mwomwo nu, oliwonamwo muhala alibba aku̱semereeri̱ hoi̱, bamuteho kubba mu̱go mu kiikaru kya Vasi̱ti̱.” Ki̱kyo kiteekerezu kyasemereeri̱ mukama hoi̱, yaakita mu nkora. ");
INSERT INTO rub_vpl VALUES ("ET2_5","018_2_5","EST","2","5","5","B̯u̱b̯wo nu haalingiho Muyudaaya omwei̱ mu rub̯uga lu̱handu̱ lwa Su̱u̱sa gi̱beetengi̱ Morodokaayi̱. Morodokaayi̱ yaali mu̱tabani̱ wa Yayi̱ri̱, Yayi̱ri̱ mu̱tabani̱ wa Si̱meeyi̱, Si̱meeyi̱ mu̱tabani̱ wa Ki̱i̱si̱, Ki̱i̱si̱ wa mu luganda lwa Bbenyami̱i̱ni̱, ");
INSERT INTO rub_vpl VALUES ("ET2_6","018_2_6","EST","2","6","6","munyakubba mu banyagwa hamwei̱ na mukama wa Yu̱da, Yekoni̱ya, kuruga Yeru̱salemu̱, banyakuhambwa Neb̯u̱kadeneeza mukama wa Bbabbu̱looni̱. ");
INSERT INTO rub_vpl VALUES ("ET2_7","018_2_7","EST","2","7","7","Morodokaayi̱ yaali na mwa mwijwabbaawe gi̱beetengi̱ Hadaasa, giyaali ahandi̱i̱rye hab̯wakubba atakabbe na mmaawe na bbaawe. Yogwo muhala yaali de yeegebeerwe nkʼEsi̱teeri̱. Esi̱teeri̱ yaali muhala nyarurungi atali na kamogo. Mmaawe na bbaawe b̯u̱baakwi̱ri̱, Morodokaayi̱ yaamu̱tweri̱ yaamu̱handya nka muhara waamwe kwebyalira. ");
INSERT INTO rub_vpl VALUES ("ET2_8","018_2_8","EST","2","8","8","Hei̱nyu̱ma gya kiragiro kya mukama kurangwa, baaleeti̱ri̱ bahala banene mu rub̯uga lu̱handu̱ lwa Su̱u̱sa, babakwatya Hegaayi̱, mu̱handu̱ wa nnyu̱mba gya bakali̱. Mu bab̯wo bahala hooho nʼEsi̱teeri̱ yaaleeteerwe mu kikaali, baamuta mu nnyu̱mba gya bakali̱ mu ngalu za Hegaayi̱. ");
INSERT INTO rub_vpl VALUES ("ET2_9","018_2_9","EST","2","9","9","Esi̱teeri̱ yaasi̱i̱mi̱i̱rwe Hegaayi̱. Hegaayi̱ yaamwolokeerye mbabazi̱, yaamuheeraho maku̱ta ga kwesi̱i̱ga na bidyo birungi bya ku̱mu̱nyi̱ri̱i̱rya. Kindi yaamu̱teereeri̱ho bazaana musanju kuruga mu kikaali, yaamutwala na bab̯wo bazaana mu kiikaru ki̱ku̱ki̱i̱rayo ki̱mwei̱ mu nnyu̱mba gya bakali̱. ");
INSERT INTO rub_vpl VALUES ("ET2_10","018_2_10","EST","2","10","10","B̯u̱b̯wo Esi̱teeri̱ yaali ataatwi̱ri̱ b̯ubyalisanwa b̯wamwe, hab̯wakubba Morodokaayi̱ yaali amu̱geeni̱ kweranga. ");
INSERT INTO rub_vpl VALUES ("ET2_11","018_2_11","EST","2","11","11","Hab̯wa kwendya kwetegereza nkʼEsi̱teeri̱ kuyaali kandi na kwendya kwega bikumubbaho, Morodokaayi̱ yei̱calengi̱ ni̱yeeli̱bali̱bati̱sya mu zi̱gati̱ gya nnyu̱mba gya bakali̱. ");
INSERT INTO rub_vpl VALUES ("ET2_12","018_2_12","EST","2","12","12","Kiro ki̱takadoori̱ kya b̯uli muhala kugyenda mu mei̱so ga Mukama Ahaswero, b̯uli muhala yaali waakumala myeri̱ i̱ku̱mi̱ na mibiri ni̱baku̱mu̱nyi̱ri̱i̱rya ku̱si̱gi̱ki̱ra ha mikoore mya bakali̱. Myeri̱ mukaaga mya kubanza baami̱malengi̱ ni̱baku̱mu̱si̱i̱ga maku̱ta ga mugaaju, na mindi mukaaga ni̱baku̱mu̱si̱i̱ga maku̱ta gaku̱wu̱nya ku̱ni̱hi̱ na byakwesi̱i̱ga bindi bya bakali̱. ");
INSERT INTO rub_vpl VALUES ("ET2_13","018_2_13","EST","2","13","13","Kandi b̯uli muhala wa kiro kyamwe kyakabbanga ki̱doori̱ kya kugyenda mu kikaali hali mukama, baamu̱hengi̱ b̯uli ki̱mwei̱ kyensei̱ kiyaakasabanga kugyenda nakyo kuruga mu nnyu̱mba gya bakali̱. ");
INSERT INTO rub_vpl VALUES ("ET2_14","018_2_14","EST","2","14","14","Yaagyendengi̱ joojolo hali mukama, naarugayo mwakya nei̱ra mu nnyu̱mba gindi gyakabiri gya bakali̱ ginyakujunaanwanga Saasi̱gazi̱, mu̱handu̱ wa bazaana ba mukama munyakulindanga bab̯wo bakali̱. Muhala aru̱gi̱ri̱ hali mukama atakakubengeyo hali mukama, kutoolahoona wa mukama giyaakabbanga asi̱i̱mi̱ri̱, naamweta neibara bamu̱ku̱byeyo. ");
INSERT INTO rub_vpl VALUES ("ET2_15","018_2_15","EST","2","15","15","Kiro kyʼEsi̱teeri̱ (muhara wʼAbi̱hai̱ri̱ mwijwabba Morodokaayi̱, wa Morodokaayi̱ gi̱yaatwalengi̱ nka mwana waamwe) b̯u̱kyadoori̱, atakasabe kintu kyensei̱ kutoolahoona bi̱byo bya Hegaayi̱ muheereza wa mukama munyakulindanga nnyu̱mba gya bakali̱ biyaali amu̱ragi̱i̱ri̱. B̯uli muntu yensei̱ munyakuwonahoona Esi̱teeri̱, yaamwegombi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("ET2_16","018_2_16","EST","2","16","16","Esi̱teeri̱ b̯u̱bakamu̱tweri̱ mu kikaali hali Mukama Ahaswero, mu mweri̱ gwei̱ku̱mi̱, mweri̱ gwa Tebi̱sa, mu mwaka gwamusanju gwa b̯u̱lemi̱ b̯wamwe, ");
INSERT INTO rub_vpl VALUES ("ET2_17","018_2_17","EST","2","17","17","mukama yendeerye hoi̱ Esi̱teeri̱ kukira bakali̱ bensei̱, yaamwolokeerye maku̱ne yaamu̱si̱i̱ma kukira bab̯wo bakali̱ bensei̱. Nahab̯waki̱kyo mukama yaamu̱teeri̱ho kondo ku mu̱twe, yaamufoora mu̱go yaatoolaho Vasi̱ti̱. ");
INSERT INTO rub_vpl VALUES ("ET2_18","018_2_18","EST","2","18","18","Mwomwo mukama yaati̱mbi̱ra bayolo na baheereza baamwe bensei̱ kiihuru kikooto, ki̱kyo kiihuru kyali kya B̯u̱genyi̱ b̯wʼEsi̱teeri̱. Kindi mukama yaatoori̱ho misolo mu masaza gensei̱, yaagabira bantu bisembu ku̱si̱gi̱ki̱ra ha ki̱ti̱i̱ni̱sa kyamwe nka mukama. ");
INSERT INTO rub_vpl VALUES ("ET2_19","018_2_19","EST","2","19","19","B̯u̱bakacooki̱ri̱ bab̯wo bahala gwakabiri, Morodokaayi̱ yaalingi ei̱cali̱i̱ri̱ heirembu lya mukama. ");
INSERT INTO rub_vpl VALUES ("ET2_20","018_2_20","EST","2","20","20","Bei̱tu̱ Esi̱teeri̱ yaali abi̱si̱ri̱ nsita gya b̯ubyalwa b̯wamwe nka Morodokaayi̱ kuyaalingi amu̱weereeri̱. ");
INSERT INTO rub_vpl VALUES ("ET2_21","018_2_21","EST","2","21","21","Mu biro bi̱byo, Morodokaayi̱ b̯uyaali ha mulimo heirembu lya mukama, haloho badulu babiri Bbi̱gi̱saani̱ na Teresi̱, banyakulindanga b̯ulaalu b̯wa mukama, bei̱tu̱ bab̯wo badulu baakwati̱i̱rwe ki̱ni̱ga bacwamwo kwi̱ta Mukama Ahaswero. ");
INSERT INTO rub_vpl VALUES ("ET2_22","018_2_22","EST","2","22","22","Morodokaayi̱ b̯u̱yaakeetegeri̱i̱ze rukwe lwab̯u, yaahwi̱tu̱li̱raho Mu̱go Esi̱teeri̱, aweere mukama ku lu̱lwo rukwe. ");
INSERT INTO rub_vpl VALUES ("ET2_23","018_2_23","EST","2","23","23","B̯u̱baatoolereerye ku lu̱lwo rukwe, baagi̱i̱rye bi̱byo bigambu nibili bya mananu, bab̯wo badulu babiri baabei̱ti̱ri̱ na kubabbanika ha madaara. Bi̱byo bintu byahandi̱i̱ki̱i̱rwe mu mei̱so ga mukama, mu kitabbu kya bintu bi̱handu̱ bibbaho mu b̯ukama. ");
INSERT INTO rub_vpl VALUES ("ET3_1","018_3_1","EST","3","1","1","Hei̱nyu̱ma gya bi̱byo binyakubbaho, Mukama Ahaswero yaahandi̱i̱rye muheereza waamwe, Hamani wa mu luganda lwa Bagagi̱, mu̱tabani̱ wa Hamadasa, ha kiikaru kikooto kukira bayolo bei̱ra bensei̱. ");
INSERT INTO rub_vpl VALUES ("ET3_2","018_3_2","EST","3","2","2","Baheereza ba mukama bensei̱ ba heirembu lya mukama baaku̱ndi̱rengi̱ Hamani malu̱, kubba kwokwo mukama yaali aragi̱i̱ri̱ bamutengemwo ki̱ti̱i̱ni̱sa. Bei̱tu̱ Morodokaayi̱ atakagamu̱ku̱ndi̱renge. ");
INSERT INTO rub_vpl VALUES ("ET3_3","018_3_3","EST","3","3","3","Mwomwo baheereza ba mukama ba heirembu lya mukama baab̯u̱u̱lya Morodokaayi̱, “Hab̯waki otakuhondera kiragiro kya mukama?” ");
INSERT INTO rub_vpl VALUES ("ET3_4","018_3_4","EST","3","4","4","Nab̯u̱bamu̱weerenge b̯ukyeb̯ukye ha kintu kya kutamwo Hamani ki̱ti̱i̱ni̱sa, atakabeegwe. Nahab̯waki̱kyo baamu̱legi̱ri̱ hali Hamani, mwa kuwona bigambu bya Morodokaayi̱ byabba nibili na mugasu. Hab̯wakubba Morodokaayi̱ yaali abaweereeri̱ yo kwali Muyudaaya. ");
INSERT INTO rub_vpl VALUES ("ET3_5","018_3_5","EST","3","5","5","Hamani b̯u̱yaakyetegereze nti, Morodokaayi̱ yaali atakumutamwo ki̱ti̱i̱ni̱sa rundi ku̱mu̱ku̱ndi̱ra malu̱, yaakwati̱i̱rwe b̯usungu. ");
INSERT INTO rub_vpl VALUES ("ET3_6","018_3_6","EST","3","6","6","Ku̱si̱gi̱ki̱ra ha bigambu bya Hamani yaalingi yeegi̱ri̱ ha bantu beihanga lya Morodokaayi̱, atakajwahukire kiteekerezu kya kwi̱ta Morodokaayi̱ yankei. Hamani yaacwi̱ri̱ magezi̱ ga ku̱zi̱ki̱i̱rya ki̱mwei̱ Bayudaaya bensei̱, bantu ba Morodokaayi̱, mu b̯ukama b̯wʼAhaswero b̯wensei̱. ");
INSERT INTO rub_vpl VALUES ("ET3_7","018_3_7","EST","3","7","7","Ha mwaka gwei̱ku̱mi̱ na mibiri gwa b̯u̱lemi̱ b̯wa Mukama Ahaswero, mu mweri̱ gukubanza gwegebeerwe nka Nisani, Hamani yaateeri̱ho kukoma kwa karu̱ru̱, karu̱ru̱ kabeetengi̱ Pu̱ri̱. Karu̱ru̱ kakwo kaakomwenge b̯uli kiro, na mweri̱ ha mweri̱ kudwereera ki̱mwei̱ ha mweri̱ gwei̱ku̱mi̱ na mibiri, gwegebeerwe nka Adaari̱. ");
INSERT INTO rub_vpl VALUES ("ET3_8","018_3_8","EST","3","8","8","Mwomwo Hamani yaaweera Mukama Ahaswero yati, “Haloho bantu basaaseeni̱ hensei̱ mu masaza gensei̱ mu b̯ukama b̯wamu, baali na ngesu zitakwisana za bantu bandi bensei̱, basuula kuhondera biragiro bya mukama. Nahab̯waki̱kyo ti̱basemereeri̱ kuganyirwa. ");
INSERT INTO rub_vpl VALUES ("ET3_9","018_3_9","EST","3","9","9","B̯ukyabba ki̱ku̱semereeri̱ mukama, ikiriza kiragiro kiteeb̯weho kyaku̱bazi̱kya, nkwi̱za kuta talanta 10,000 za feeza mwibiikiro lya sente lya b̯ukama hab̯wa kusasula bantu baakora gu̱gwo mulimo.” ");
INSERT INTO rub_vpl VALUES ("ET3_10","018_3_10","EST","3","10","10","Nahab̯waki̱kyo mukama yaasomoori̱mwo mpi̱ta gyamwe mu ngalu, yaagiha Hamani wa mu luganda lwa Bagagi̱, mu̱tabani̱ wa Hamadasa, munywanzigwa wa Bayudaaya. ");
INSERT INTO rub_vpl VALUES ("ET3_11","018_3_11","EST","3","11","11","Mukama yaaweera Hamani yati, “Sente zaamu weebikira, kandi na bab̯wo bantu obakore nka ku̱waakendya.” ");
INSERT INTO rub_vpl VALUES ("ET3_12","018_3_12","EST","3","12","12","Kasi mwomwo beeta bahandi̱i̱ki̱ bensei̱ ba mukama ha kiro kyei̱ku̱mi̱ na bisatu kya mweri̱ gwakubanza. Baahandi̱i̱ki̱ri̱ kihandiiko nibahondera bigambu bya Hamani bi̱yaaragi̱i̱ri̱, baaki̱si̱ndi̱ki̱ra banyamasaza ba mukama, bamasaza bensei̱ na bayolo ba bantu bensei̱ mu ndimi za nganda zensei̱ za b̯uli masaza. Kihandiiko ki̱kyo kyahandi̱i̱ki̱i̱rwe mwibara lya Mukama Ahaswero bakitaho kilengeeru kya mpi̱ta. ");
INSERT INTO rub_vpl VALUES ("ET3_13","018_3_13","EST","3","13","13","Kihandiiko ki̱kyo kyatwali̱i̱rwe batumwa mu masaza ga b̯u̱b̯wo b̯ukama b̯wensei̱, nikikuragira nti Bayudaaya bensei̱, bato na bahandu̱, bakali̱ na baana, bakusemeera kwi̱twa, babasale kandi babazi̱kye mu kiro ki̱mwei̱. Mu kiro kyokyo ki̱mwei̱, kyei̱ku̱mi̱ na bisatu mweri̱ gwei̱ku̱mi̱ na mibiri gwʼAdaara, banyagwe neitungu lyab̯u. ");
INSERT INTO rub_vpl VALUES ("ET3_14","018_3_14","EST","3","14","14","Kihandiiko ki̱kyo baali baakukirangiira nikili nka kiragiro mu masaza gensei̱, bantu bensei̱ ba mahanga gensei̱ bakyege mwa kwetegekera ki̱kyo kiro. ");
INSERT INTO rub_vpl VALUES ("ET3_15","018_3_15","EST","3","15","15","Batumwa bab̯wo baarangu̱hi̱ri̱ baatwala ki̱kyo kihandiiko nka mukama kuyaali aragi̱i̱ri̱, kyadumirwa mu rub̯uga lu̱handu̱ lwa Su̱u̱sa. Hei̱nyu̱ma Hamani na mukama b̯ubaali bei̱cali̱i̱ri̱ nibakunywa, rub̯uga lwa Su̱u̱sa lwagu̱gu̱mu̱ka. ");
INSERT INTO rub_vpl VALUES ("ET4_1","018_4_1","EST","4","1","1","Morodokaayi̱ b̯u̱yaakeetegeri̱i̱ze byensei̱ binyakubba bi̱koleerwe, yaatemu̱u̱ri̱ ngoye ziyaali alweri̱, yaalwala nsensede kandi yeesi̱i̱ga i̱syanu̱, yaagyenda hakati̱ wa rub̯uga na kizabiro kinyamaani. ");
INSERT INTO rub_vpl VALUES ("ET4_2","018_4_2","EST","4","2","2","Yaagyendi̱ri̱ ha mulyangu gwa irembu gwa kikaali kya mukama bei̱tu̱ atakeingire mu̱kati̱, kubba batakeikirizenge muntu yensei̱ alweri̱ nsensede kwingira mwirembu lya mukama. ");
INSERT INTO rub_vpl VALUES ("ET4_3","018_4_3","EST","4","3","3","Kandi mu b̯uli isaza cali kihandiiko na kiragiro kya mukama kyali ki̱doori̱, Bayudaaya bensei̱ baali mu nganye, nibakusiiba kandi nibakulira kizabiro kinyamaani. Bayudaaya banene baali mu nsensede kandi baaleeri̱ mwi̱syanu̱. ");
INSERT INTO rub_vpl VALUES ("ET4_4","018_4_4","EST","4","4","4","Bazaana na baheereza bʼEsi̱teeri̱ bei̱zi̱ri̱ baamuweera Morodokaayi̱ nka kuyaalingi, Mu̱go Esi̱teeri̱ yaasaalirwa hoi̱. Yaatwekeeri̱ Morodokaayi̱ ngoye za kulwala, ni̱yendya Morodokaayi̱ akusulemwo nsensede, bei̱tu̱ Morodokaayi̱ yaaswi̱ri̱ kukusulamwo nsensede. ");
INSERT INTO rub_vpl VALUES ("ET4_5","018_4_5","EST","4","5","5","Kasi mwomwo Esi̱teeri̱ yaatuma baamwetere muheereza waamwe, Hasaki̱, omwei̱ ha baheereza ba mukama bayaali ateeri̱hoona kumuwoneera. Yaamutuma yati, “Gyenda hali Morodokaayi̱ weetegereze kintu kiloho, na hab̯waki ki̱bbeeri̱ho.” ");
INSERT INTO rub_vpl VALUES ("ET4_6","018_4_6","EST","4","6","6","Nahab̯waki̱kyo, Hasaki̱ yaagyendi̱ri̱ hanzei hali Morodokaayi̱ hakati̱ wa rub̯uga mu zi̱gati̱ gyeirembu lya mukama. ");
INSERT INTO rub_vpl VALUES ("ET4_7","018_4_7","EST","4","7","7","Morodokaayi̱ yaaweereeri̱ Hasaki̱ bintu byensei̱ binyakubba bi̱bbeeri̱ho, oteeri̱hoona na kya muhendu gwa sente Hamani ziyaali yeeragi̱ri̱ kuta mu nsahu gya b̯ukama hab̯wa ku̱zi̱kya Bayudaaya. ");
INSERT INTO rub_vpl VALUES ("ET4_8","018_4_8","EST","4","8","8","Morodokaayi̱ yaaheeri̱ Hasaki̱ na kihandiiko kinyakuhandiikwa kya ku̱bazi̱kya, kinyakubba ki̱ti̱mbi̱rwe mu rub̯uga Su̱u̱sa, akyolokye Esi̱teeri̱ kandi amusoboore. Kindi, Morodokaayi̱ yaaweereeri̱ Hasaki̱ asabe Esi̱teeri̱ arombe na mukama, atongoneere bantu baamwe bayudaaya aleke mukama abaganyire. ");
INSERT INTO rub_vpl VALUES ("ET4_9","018_4_9","EST","4","9","9","Hasaki̱ yaaku̱bi̱ri̱yo yaasoboora Esi̱teeri̱ bya Morodokaayi̱ yaabazi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("ET4_10","018_4_10","EST","4","10","10","Mwomwo Esi̱teeri̱ yaatuma Hasaki̱ naamuragira aweere Morodokaayi̱ yati, ");
INSERT INTO rub_vpl VALUES ("ET4_11","018_4_11","EST","4","11","11","“Heicalaho kiragiro kikukwatagana na ku̱romba mukama, babbe bakungu na bantu ba b̯ukama bensei̱ na ba mu masaza bakyegi̱ri̱. Muntu yensei̱ akagyendanga kuwona mukama, kutoolahoona mukama yooyo nali amweti̱ri̱, yogwo muntu akwi̱zanga kwi̱twa. Kintu ki̱mwei̱ kisa kikusobora kujuna yogwo muntu kili kakubba mukama amwolokeerya mubbeere gwamwe gwa zaabbu. Harabi̱ri̱ho biro maku̱mi̱ gasatu kuruga mukama nanzeta kumuwona.” ");
INSERT INTO rub_vpl VALUES ("ET4_12","018_4_12","EST","4","12","12","Morodokaayi̱ b̯u̱baamu̱weereeri̱ bigambu byʼEsi̱teeri̱ bi̱yaabazi̱ri̱, ");
INSERT INTO rub_vpl VALUES ("ET4_13","018_4_13","EST","4","13","13","yei̱ri̱ri̱mwo Esi̱teeri̱ naamuweera yati, “Otateekereza nti, mu Bayudaaya bensei̱ weewe okwi̱za kukena, hab̯wakubba oli mu nnyu̱mba gya mukama. ");
INSERT INTO rub_vpl VALUES ("ET4_14","018_4_14","EST","4","14","14","Kakubba weeteekeera hataati̱, kucungurwa kwa Bayudaaya ku̱kwi̱za kurugira handi, bei̱tu̱ we na mu̱gi̱ gwa bbaawu gulihwerekeera. Naani akyegi̱ri̱, b̯undi hab̯wa mbeera giloho hataati̱, kyokyo waateebeerweho kubba mu̱go?” ");
INSERT INTO rub_vpl VALUES ("ET4_15","018_4_15","EST","4","15","15","Mwomwo Esi̱teeri̱ yaatumira Morodokaayi̱ naakoba yati, ");
INSERT INTO rub_vpl VALUES ("ET4_16","018_4_16","EST","4","16","16","“Gyenda ocooke Bayudaaya bensei̱ ba mu Su̱u̱sa, musiibe hab̯wange. Mutadya kandi mutanywa kumala biro bisatu, i̱jolo na mwinsi. Kandi gya hamwei̱ na bazaana bange nkwi̱za kusiiba nka nywe. Hei̱nyu̱ma gya kusiiba nkwi̱za kugyenda hali mukama nab̯ukyakabba nikikubinya kiragiro, nyakakwa hab̯wa kukikora nkankwe.” ");
INSERT INTO rub_vpl VALUES ("ET4_17","018_4_17","EST","4","17","17","Nahab̯waki̱kyo Morodokaayi̱ yaagyendi̱ri̱ yaakora nkʼEsi̱teeri̱ kuyaali amu̱ragi̱i̱ri̱. ");
INSERT INTO rub_vpl VALUES ("ET5_1","018_5_1","EST","5","1","1","Ha kiro kya kasatu kya kisiibo, Esi̱teeri̱ yaalweri̱ kilwalu kya ki̱ti̱i̱ni̱sa kyamwe kya b̯u̱go, kwokwo agyende kuzookera mu mei̱so ga mukama. Yei̱ngi̱i̱ri̱ mu kikaali, yeemeera ha mulyangu gwa ki̱si̱i̱ka kya mukama kiyaalingimwo. Ha b̯wi̱re b̯u̱b̯wo, mukama yaali ei̱cali̱i̱ri̱ ha kitebe kyamwe kya b̯ukama. ");
INSERT INTO rub_vpl VALUES ("ET5_2","018_5_2","EST","5","2","2","Mukama b̯u̱yaaweeni̱ Mu̱go Esi̱teeri̱ yeemereeri̱ hahwo ha mulyangu, yaamu̱sanyu̱ki̱i̱ri̱, yaamwolokeerya mubbeere gwa zaabbu guyaali akweti̱. Kasi mwomwo Esi̱teeri̱ yei̱za hali yo, yaakwata ha mu̱twe gwa mubbeere gwa zaabbu gwa mukama. ");
INSERT INTO rub_vpl VALUES ("ET5_3","018_5_3","EST","5","3","3","Mwomwo mukama amu̱b̯u̱u̱lya, “Mu̱go Esi̱teeri̱, kikyani ki̱bbeeri̱ho? Kyani kyokwendya? Mbwera nkikuhe, nab̯ukyabba ki̱mwei̱ kya kabiri kya b̯ukama b̯wange.” ");
INSERT INTO rub_vpl VALUES ("ET5_4","018_5_4","EST","5","4","4","Esi̱teeri̱ yaamwi̱ri̱mwo yati, “Mukama wange, waabba oki̱si̱i̱mi̱ri̱, nkukusaba, we na Hamani, mwi̱ze mubbe bagenyi̱ bange ha B̯u̱genyi̱ b̯u̱nku̱kooleeri̱.” ");
INSERT INTO rub_vpl VALUES ("ET5_5","018_5_5","EST","5","5","5","Mwomwo mukama yaaragira, “Mu̱nzetere Hamani b̯wangu, aleke tukore kyʼEsi̱teeri̱ kyakwendya.” Nahab̯waki̱kyo mukama na Hamani baagyendi̱ri̱ ha B̯u̱genyi̱ b̯wʼEsi̱teeri̱ b̯uyaalingi akoori̱. ");
INSERT INTO rub_vpl VALUES ("ET5_6","018_5_6","EST","5","6","6","B̯ubaali nibakunywa vi̱i̱no, mukama yaab̯u̱u̱lya Esi̱teeri̱ murundi gundi, “Kikyani kyokwendya hataati̱? Nkwi̱za kukikuha. Kikyani kili mu kusaba kwamu? Nab̯ukyabba nikili ki̱mwei̱ kya kabiri kya b̯ukama, nkwi̱za kukikuha.” ");
INSERT INTO rub_vpl VALUES ("ET5_7","018_5_7","EST","5","7","7","Esi̱teeri̱ yei̱ri̱ri̱mwo yati, “Ki̱nkwendya kandi kinkusaba kyokyo kiki: ");
INSERT INTO rub_vpl VALUES ("ET5_8","018_5_8","EST","5","8","8","Mukama b̯uyaakabba aweeni̱ mu mbabazi̱ zaamwe kandi akasi̱i̱ma kwendya kwange na kusaba kwange, leka mukama wange na Hamani bei̱ze mwakya ha B̯u̱genyi̱ b̯u̱nkwi̱za kubakoora. B̯u̱b̯wo mwomwo nkwi̱za kwi̱ramwona bi̱b̯u̱u̱lyo bya mukama wange.” ");
INSERT INTO rub_vpl VALUES ("ET5_9","018_5_9","EST","5","9","9","Kiro ki̱kyo Hamani yeemu̱ki̱ri̱ asemereerwe hoi̱, bei̱tu̱ mwirembu lya mukama, Hamani yaali aweeni̱yoona Morodokaayi̱. Morodokaayi̱ atakemeere rundi atakatemwo Hamani ki̱ti̱i̱ni̱sa. Ki̱kyo kikorwa kyasaali̱i̱ze hoi̱ Hamani. ");
INSERT INTO rub_vpl VALUES ("ET5_10","018_5_10","EST","5","10","10","Bei̱tu̱ atakabaze kigambu kyensei̱, yeemuka mu maka gaamwe. Hei̱nyu̱ma, Hamani yeeti̱ri̱ banywani baamwe na mu̱kali̱ waamwe Zeresi̱, ");
INSERT INTO rub_vpl VALUES ("ET5_11","018_5_11","EST","5","11","11","yeehaariiza mu mei̱so gaab̯u nka kwali na ki̱ti̱i̱ni̱sa na b̯u̱gu̱u̱da b̯unene, batabani̱ banene, kandi nka mukama kwamu̱handi̱i̱rye. Kindi nka mukama kwamu̱handi̱i̱ryemwo kukira bayolo na baheereza bandi. ");
INSERT INTO rub_vpl VALUES ("ET5_12","018_5_12","EST","5","12","12","Hamani ab̯u̱ni̱a akoba yati, “Ndi gyagya musa wa Mu̱go Esi̱teeri̱ asi̱i̱mi̱ri̱ kubba na mukama mu B̯u̱genyi̱ b̯watu̱kooleeri̱. Kandi anzeti̱ri̱ hamwei̱ na mukama mwakya. ");
INSERT INTO rub_vpl VALUES ("ET5_13","018_5_13","EST","5","13","13","Bei̱tu̱ kandi, bi̱byo byensei̱ tibikungasa, nyaabba nincakawona yogwo Muyudaaya Morodokaayi̱ naacakeicaara heirembu lya mukama.” ");
INSERT INTO rub_vpl VALUES ("ET5_14","018_5_14","EST","5","14","14","Mu̱kali̱ waamwe Zeresi̱ na banywanwe baamu̱weereeri̱ yati, “Leka bakore madaara gababbanikaho bantu ga b̯ulei b̯wa ngarama i̱ku̱mi̱ neibiri, hei̱nyu̱ma osabe mukama babbanikeho Morodokaayi̱ akwe. B̯u̱b̯wo mwomwo okwi̱za kugyenda ha B̯u̱genyi̱ na mukama osemereerwe.” Ki̱kyo kiteekerezu kyamu̱semereeri̱ hoi̱, Hamani yaaragira bakore madaara. ");
INSERT INTO rub_vpl VALUES ("ET6_1","018_6_1","EST","6","1","1","I̱jolo li̱lyo mukama atakebbake, kasi yaaragira baaleeta mu mei̱so gaamwe kitabbu kya byei̱nyu̱ma, ki̱kwolokya miremere myamwe, bakimusomere. ");
INSERT INTO rub_vpl VALUES ("ET6_2","018_6_2","EST","6","2","2","Mu ki̱kyo kitabbu haazooki̱ri̱mwo bi̱kwolokya nka Morodokaayi̱ ku̱yaahwi̱tu̱u̱ri̱ rukwe lwa kwi̱ta mukama Ahaswero, rukwe lu̱lwo lwakoleerwe baheereza ba mukama babiri, Bbi̱gi̱saani̱ na Teresi̱, banyakulindanga irembu lya kikaali. ");
INSERT INTO rub_vpl VALUES ("ET6_3","018_6_3","EST","6","3","3","Mwomwo mukama yaab̯u̱u̱lya, “Kikyani kya ki̱ti̱i̱ni̱sa kandi kyakwi̱zu̱ki̱raho ki̱baaheeri̱ Morodokaayi̱ hab̯wa ki̱kyo kintu?” Baheereza ba mukama bei̱ramwo, “Tihaloho ki̱baamu̱heeri̱.” ");
INSERT INTO rub_vpl VALUES ("ET6_4","018_6_4","EST","6","4","4","Mukama ab̯u̱ni̱a ab̯u̱u̱lya, “Naani ali mu zi̱gati̱?” Ha b̯wi̱re b̯wob̯wo Hamani yaali naacakengira b̯wi̱ngi̱ri̱ mu zi̱gati̱ gya kikaali kya mukama, mwa kubaza nayo ha kyakwi̱ta Morodokaayi̱ na kumubbanika ha madaara gayaali akoori̱. ");
INSERT INTO rub_vpl VALUES ("ET6_5","018_6_5","EST","6","5","5","Baheereza baamwe baamuweera, “Hamani yo ngodi̱ yeemereeri̱ mu zi̱gati̱ akwendya kukuwonaho.” Mukama yaaragi̱i̱ri̱ naakoba, “Mu̱mwete ei̱ze.” ");
INSERT INTO rub_vpl VALUES ("ET6_6","018_6_6","EST","6","6","6","Hamani b̯u̱yaadoori̱ mukama amu̱b̯u̱u̱lya, “Kyani ki̱nyaku̱soboori̱ kukora na kutamu ki̱ti̱i̱ni̱sa ku yogwo muntu akweti̱ ku mutima gwange?” Hamani yeeb̯u̱u̱li̱i̱rye mu mutima gwamwe naakoba, “Naani yogwo hatali gya, wa mukama gyakwendya ku̱si̱i̱ma?” ");
INSERT INTO rub_vpl VALUES ("ET6_7","018_6_7","EST","6","7","7","Nahab̯waki̱kyo Hamani yaamwi̱ri̱ri̱mwo naakoba, “Yogwo wa mukama akwendeerya ki̱ti̱i̱ni̱sa, ");
INSERT INTO rub_vpl VALUES ("ET6_8","018_6_8","EST","6","8","8","leka bamuhe kilwalu kya mukama ki̱yaalweri̱ho na mbaraasi gya mukama gi̱yaani̱i̱ni̱ri̱ho, giwa kondo gya b̯ukama ha mu̱twe gwagyo. ");
INSERT INTO rub_vpl VALUES ("ET6_9","018_6_9","EST","6","9","9","Kandi leka ki̱kyo kilwalu na mbaraasi babi̱kwatye muheereza omwei̱ mwesigwa hoi̱ mu bayolo ba mukama, alwalye yogwo muntu wa mukama akwendeerya ki̱kyo ki̱ti̱i̱ni̱sa ki̱kyo kilwalu, kandi amwekulembere amu̱rabye mu rub̯uga ha mbaraasi, naamuragiiranga naakoba, ‘Mukama waasi̱i̱ma muntu kwokwo amukora yatyo!’ ” ");
INSERT INTO rub_vpl VALUES ("ET6_10","018_6_10","EST","6","10","10","Mukama yaadu̱u̱mi̱i̱ri̱ Hamani naakoba, “Gyenda b̯wanguha oleete kilwalu na mbaraasi, okore nka kwokobi̱ri̱, obihe Morodokaayi̱ Muyudaaya yogwo eicaara heirembu lya mukama. Otati̱gayo na ki̱mwei̱ ha bintu bi̱waakakobi̱ri̱.” ");
INSERT INTO rub_vpl VALUES ("ET6_11","018_6_11","EST","6","11","11","Nahab̯waki̱kyo Hamani yaakweti̱ bilwalu, yaabi̱lwalya Morodokaayi̱ kandi yaamwekulembera ha mbaraasi, yaamu̱rabya mu rub̯uga naarangiiranga naakoba, “Mukama waasi̱i̱ma muntu kwokwo amukora yatyo.” ");
INSERT INTO rub_vpl VALUES ("ET6_12","018_6_12","EST","6","12","12","Hei̱nyu̱ma Morodokaayi̱ yaaku̱bi̱ri̱yo heirembu. Bei̱tu̱ Hamani yangu̱hi̱ri̱ yeemuka kwamu̱gi̱ atu̱li̱ki̱ri̱ mu̱twe naakuswara, ");
INSERT INTO rub_vpl VALUES ("ET6_13","018_6_13","EST","6","13","13","yaaweera banywanwe na mu̱kalwe Zeresi̱ bintu byensei̱ binyakumubbaho. Balambi̱ baamwe na mu̱kali̱ waamwe Zeresi̱ baamwi̱ri̱ri̱mwo nibakoba, “Morodokaayi̱ nka kwali Muyudaaya, b̯u̱b̯wo ku̱gwa kwamu ku̱tandi̱ki̱ri̱, tosobora ku̱mu̱si̱ngu̱ra, mu mananu akwi̱za ku̱ku̱si̱ngu̱ra!” ");
INSERT INTO rub_vpl VALUES ("ET6_14","018_6_14","EST","6","14","14","B̯ubaali nibacakabaza nayo, hei̱za baheereza ba mukama baatwala Hamani b̯wangu ha B̯u̱genyi̱ wʼEsi̱teeri̱ yaali akoori̱. ");
INSERT INTO rub_vpl VALUES ("ET7_1","018_7_1","EST","7","1","1","Nahab̯waki̱kyo mukama na Hamani baagyendi̱ri̱ mu B̯u̱genyi̱ na Mu̱go Esi̱teeri̱. ");
INSERT INTO rub_vpl VALUES ("ET7_2","018_7_2","EST","7","2","2","Bei̱tu̱ b̯ubaali nibakunywa vi̱i̱no ha kiro kya kabiri kya B̯u̱genyi̱ mukama ab̯u̱ni̱a ab̯u̱u̱lya, “Mu̱go Esi̱teeri̱, kikyani kyokwendya nkukolere? Nkwi̱za kukikuha. Kikyani kili ha mutima gwamu? Nab̯ukyakabba ki̱mwei̱ kya kabiri kya b̯ukama b̯ub̯u, nkwi̱za kukikuha.” ");
INSERT INTO rub_vpl VALUES ("ET7_3","018_7_3","EST","7","3","3","Mwomwo Mu̱go Esi̱teeri̱ yaamwi̱ramwo naakoba yati, “Mukama wange, b̯uwaabba oki̱si̱i̱mi̱ri̱ kandi nikikakusemeera, ndekera b̯womi b̯wange, na bantu bange de, obalekere b̯womi b̯wab̯u, ki̱kyo kyokyo nkukusaba kandi nkwendya hoi̱. ");
INSERT INTO rub_vpl VALUES ("ET7_4","018_7_4","EST","7","4","4","Hab̯wakubba gya na bantu bange tu̱gu̱li̱i̱rwe kwi̱twa, kusalwa na kumalwaho ki̱mwei̱. Hakiri kibbenge kyakutundwa mu b̯wiru nyakali ninyeetekeera, hab̯wakubba b̯ujune b̯wakyo b̯wali b̯utakusobora kumpa ku̱gadya mukama.” ");
INSERT INTO rub_vpl VALUES ("ET7_5","018_7_5","EST","7","5","5","Mukama Ahaswero ab̯u̱u̱lya Mu̱go Esi̱teeri̱, “Naani yogwo? Ali hanya akwendya kukora kintu ki̱kyo?” ");
INSERT INTO rub_vpl VALUES ("ET7_6","018_7_6","EST","7","6","6","Esi̱teeri̱ yei̱ri̱ri̱mwo naakoba yati, “Munyanzigwa kandi mwi̱ti̱ yooyo yogwo mudulu mubiibi, Hamani.” Hamani yaakankei̱ni̱ na b̯u̱ti̱i̱ni̱ mu mei̱so ga mukama na ga mu̱go. ");
INSERT INTO rub_vpl VALUES ("ET7_7","018_7_7","EST","7","7","7","Mukama yaabyoki̱ri̱ na ki̱ni̱ga kinene hoi̱, yaati̱ga maaci gaamwe, yaalibata yaagyenda mu zi̱gati̱ gya kikaali. Hamani b̯u̱yaakaweeni̱ mukama asaari̱mwona ku̱mwi̱ta, yaasi̱geeri̱ hahwo yeesengereerya Mu̱go Esi̱teeri̱ amujune. ");
INSERT INTO rub_vpl VALUES ("ET7_8","018_7_8","EST","7","8","8","Mukama b̯uyaali nacakarugayo mu zi̱gati̱ gya kikaali naakwi̱ra cali yaanywerengi̱ maaci, yaagi̱i̱rye Hamani naakugwagwa mu magulu gʼEsi̱teeri̱ cali Esi̱teeri̱ yaali ei̱cali̱i̱ri̱. Mukama amuweera yati, “We, okwendya na kuhamba mu̱go mu mei̱so gange, mu kikaali kyange!” Mukama b̯uyaali naacakakibaza b̯u̱bazi̱, baheereza ba mukama nibabbumba Hamani mu̱twe. ");
INSERT INTO rub_vpl VALUES ("ET7_9","018_7_9","EST","7","9","9","Mwomwo Harabona, omwei̱ hali baheereza munyakubba naakuheereza mukama, yaabaza naakoba yati, “Haloho madaara gemereeri̱ ha nnyu̱mba gya Hamani ga b̯ulei, ngarama i̱ku̱mi̱ neibiri. Hamani yaagabi̱mbi̱si̱i̱rye kubbanika kwi̱ti̱raho Morodokaayi̱, Morodokaayi̱ munyakuranga rukwe lwa ku̱kwi̱ta we mukama.” Mukama yaaragi̱i̱ri̱ naakoba yati, “Mu̱bbani̱keho Hamani, akwe!” ");
INSERT INTO rub_vpl VALUES ("ET7_10","018_7_10","EST","7","10","10","Kwokwo yatyo bei̱ti̱ri̱ Hamani ha madaara gayaali akoori̱ kubbanikaho Morodokaayi̱. Mwomwo ki̱ni̱ga kya mukama kyagwa. ");
INSERT INTO rub_vpl VALUES ("ET8_1","018_8_1","EST","8","1","1","Ha kiro ki̱kyo kyonyi̱ni̱ Mukama Ahaswero yaaheeri̱ Mu̱go Esi̱teeri̱ itungu lyensei̱ lya Hamani, munyanzigwa wa Bayudaaya. Morodokaayi̱ yei̱zi̱ri̱ mu mei̱so ga mukama, hab̯wakubba Esi̱teeri̱ yaali aweereeri̱ mukama nka Morodokaayi̱ kuyaali mwijwe. ");
INSERT INTO rub_vpl VALUES ("ET8_2","018_8_2","EST","8","2","2","Mukama yaasomoori̱ mpi̱ta gyamwe gya ki̱ti̱i̱ni̱sa kya b̯ukama giyaali aheeri̱ Hamani, agiha Morodokaayi̱. Kandi Esi̱teeri̱ ataho Morodokaayi̱ abbe naawoneera itungu lyensei̱ lya Hamani. ");
INSERT INTO rub_vpl VALUES ("ET8_3","018_8_3","EST","8","3","3","Esi̱teeri̱ ab̯u̱ni̱a aweera mukama amu̱gwi̱ri̱ mu magulu naakulira b̯u̱li̱ri̱, amwesengereerya kusalamwona ntegeka gya Hamani Mu̱gagi̱ giyaali akoori̱ ku̱zi̱kya Bayudaaya. ");
INSERT INTO rub_vpl VALUES ("ET8_4","018_8_4","EST","8","4","4","Mwomwo mukama yoolokya Esi̱teeri̱ mubbeere gwamwe gwa ki̱ti̱i̱ni̱sa gwa zaabbu, Esi̱teeri̱ abyoka yeemeera mu mei̱so gaamwe. ");
INSERT INTO rub_vpl VALUES ("ET8_5","018_8_5","EST","8","5","5","Esi̱teeri̱ yaabazi̱ri̱ naakoba yati, “Waki̱ti̱i̱ni̱sa mukama wange, waabba oki̱si̱i̱mi̱ri̱ kandi waabba noli na mbabazi̱ kandi nikikudwa b̯u̱dwi̱ mukuteekereza kwamu, nkukusaba ohandiike kihandiiko kikusalamwona bi̱byo bya Hamani, mu̱tabani̱ wa Hamadasa Mu̱gagi̱, bi̱yaakoori̱ mu kihandiiko kya ku̱zi̱kya Bayudaaya mu masaza gensei̱. ");
INSERT INTO rub_vpl VALUES ("ET8_6","018_8_6","EST","8","6","6","Nsobora teetei̱ kulingira b̯u̱li̱ngi̱i̱ri̱ kabii ni̱kakwi̱zi̱ra bantu bange? Rundi nsobora teetei̱ kulingira b̯u̱li̱ngi̱i̱ri̱ beiju bange ni̱baku̱zi̱ka?” ");
INSERT INTO rub_vpl VALUES ("ET8_7","018_8_7","EST","8","7","7","Mukama Ahaswero yei̱ri̱ri̱mwo Mu̱go Esi̱teeri̱ na Morodokaayi̱ Muyudaaya yati, “Bamaari kadei kubbanika Hamani ha madaara, akwi̱ri̱, neitungu lwamwe ndi̱heeri̱ Esi̱teeri̱ hab̯wa rukwe lwa Hamani lwa ku̱hwerekereerya Bayudaaya. ");
INSERT INTO rub_vpl VALUES ("ET8_8","018_8_8","EST","8","8","8","Hati̱ nu handiika kiragiro kindi mwibara lya mukama hab̯wa Bayudaaya nka kwokwendya okiteho kalengeeru ka mpi̱ta gya mukama. Hab̯wakubba tibasobora ku̱di̱bya kihandiiko kyensei̱ ki̱teebeerweho kalengeeru ka mpi̱ta gya mukama.” ");
INSERT INTO rub_vpl VALUES ("ET8_9","018_8_9","EST","8","9","9","Nahaahwo b̯ulob̯ulo beeti̱ri̱ bahandi̱i̱ki̱ ba mukama ha kiro ki̱kyo kyagabiri na bisatu, mweri̱ gwakasatu gwegebeerwe nka Si̱vaani̱. Bahandi̱i̱ki̱ bab̯wo baahandi̱i̱ki̱ri̱ b̯utumwa b̯wa Morodokaayi̱ hali Bayudaaya, banyamasaza, bamasaza na bayolo ba mukama mu masaza ki̱ku̱mi̱ mu gabiri na musanju (127), kurugira ki̱mwei̱ B̯u̱hi̱ndi̱ kudwa mwʼI̱syopi̱ya. B̯u̱b̯wo b̯utumwa b̯wahandi̱ki̱i̱rwe mu ndimi zikwahukana nka nganda kuzaali mu b̯uli isaza, na b̯utumwa b̯wa Bayudaaya b̯wahandi̱ki̱i̱rwe mu lulimi lwab̯u. ");
INSERT INTO rub_vpl VALUES ("ET8_10","018_8_10","EST","8","10","10","Bbaruha zi̱zo zaahandi̱ki̱i̱rwe Morodokaayi̱ mwibara lya Mukama Ahaswero, zaateeb̯waho kilengeeru kya mpi̱ta gya mukama. Bbaruha zi̱zo zaatwali̱i̱rwe batumwa banyakuvuga mbaraasi, mbaraasi za mu kikaali kya mukama zi̱kwi̱ru̱ki̱ra ki̱mwei̱ na maani. ");
INSERT INTO rub_vpl VALUES ("ET8_11","018_8_11","EST","8","11","11","Kihandiiko kya mukama ki̱kyo kyaheeri̱ Bayudaaya ba mu mbuga zensei̱ b̯u̱sobozi̱ b̯wa kwecooka na kwelwanaho hali banyanzigwa baab̯u, kwi̱ta na ku̱zi̱kya i̱he lyeihanga lwensei̱ rundi isaza lyensei̱ likusobora ku̱baru̱mba bo na bakali̱ na baana baab̯u. Kindi kyabei̱ki̱ri̱i̱ze kunyaga itungu lya banyanzigwa baab̯u. ");
INSERT INTO rub_vpl VALUES ("ET8_12","018_8_12","EST","8","12","12","Kiro ki̱mwei̱ kinyakuteeb̯waho mu masaza gensei̱ ga Mukama Ahaswero kyali kiro kyei̱ku̱mi̱ na bisatu mu mweri̱ gwa i̱ku̱mi̱ na mibiri niguli mweri̱ gwʼAdara. ");
INSERT INTO rub_vpl VALUES ("ET8_13","018_8_13","EST","8","13","13","Kihandiiko kya b̯u̱b̯wo b̯utumwa kyali kyakurangwa nka kiragiro mu masaza gensei̱ na bantu ba b̯uli ihanga bakyege, mwa kuha Bayudaaya kwelwanaho bakabba baru̱mbi̱i̱rwe banyanzigwa baab̯u. ");
INSERT INTO rub_vpl VALUES ("ET8_14","018_8_14","EST","8","14","14","Nahab̯waki̱kyo batumwa ba ki̱kyo kiragiro baakoleeri̱ho, baagu̱su̱ki̱i̱ri̱ mbaraasi za mukama bei̱ru̱ka na maani hoi̱, kandi kiragiro kyarangiirwa mu rub̯uga lu̱handu̱ lwa Su̱u̱sa. ");
INSERT INTO rub_vpl VALUES ("ET8_15","018_8_15","EST","8","15","15","Kasi mwomwo Morodokaayi̱ yaaruga mu mei̱so ga mukama alweri̱ bilwalu bya bbu̱ru̱ru̱, bi̱syanu̱, na kondo gya zaabbu kandi yeegu̱mi̱i̱ri̱ lu̱goye lu̱heheeru̱ lwa rangi̱ gya papo. Rub̯uga lwa Su̱u̱sa lwali mu kujaagaana na kusemererwa hoi̱. ");
INSERT INTO rub_vpl VALUES ("ET8_16","018_8_16","EST","8","16","16","B̯wi̱re b̯u̱b̯wo hali Bayudaaya kaali kasu̱mi̱ ka kusemererwa, kusanyuka, na kubba na ki̱ti̱i̱ni̱sa. ");
INSERT INTO rub_vpl VALUES ("ET8_17","018_8_17","EST","8","17","17","B̯uli isaza na rub̯uga cali kiragiro kya mukama kyagyendi̱ri̱, haali̱yo kusemererwa na masanyu mu Bayudaaya, bateeri̱ho kudya na kunywa na kujaagaana. Bantu banene ba mahanga gandi beefoori̱ri̱ kubba Bayudaaya hab̯wakubba baati̱i̱nenge Bayudaaya. ");
INSERT INTO rub_vpl VALUES ("ET9_1","018_9_1","EST","9","1","1","Ha kiro kyei̱ku̱mi̱ na bisatu, mweri̱ gwei̱ku̱mi̱ na mibiri (gu̱beetengi̱ mweri̱ gwʼAdara), ki̱kyo kiragiro kya mukama kyali kyakuteeb̯wa mu nkora. Banyanzigwa ba Bayudaaya baani̱hi̱rengi̱ ha kiro kyokyo kubba nibamalaho Bayudaaya. Bei̱tu̱ bintu byahi̱ndu̱ki̱ri̱ Bayudaaya baasi̱ngu̱ra banyanzigwa baab̯u. ");
INSERT INTO rub_vpl VALUES ("ET9_2","018_9_2","EST","9","2","2","Bayudaaya ba mu masaza gensei̱ ga mu b̯ukama wʼAhaswero, beecookeeri̱ mu mbuga zaab̯u mwa ku̱ru̱mba bantu banyakubba ni̱bakwenda ku̱bei̱ta. Hatakabbeho muntu yensei̱ munyakubyoka ku̱balwani̱sya, hab̯wakubba bantu bensei̱ b̯u̱ti̱i̱ni̱ b̯wabakweti̱. ");
INSERT INTO rub_vpl VALUES ("ET9_3","018_9_3","EST","9","3","3","Bayolo bensei̱ ba masaza, banyamasaza na bamasaza, na batumwa ba mu kikaali baacwi̱ri̱mwo kusagika Bayudaaya, hab̯wakubba baati̱nengi̱ Morodokaayi̱. ");
INSERT INTO rub_vpl VALUES ("ET9_4","018_9_4","EST","9","4","4","Bantu ba mu masaza gensei̱ baali bakyegi̱ri̱ nka mukama kuyaali aheeri̱ Morodokaayi̱ b̯u̱handu̱ kandi yaali wa maani. B̯u̱sobozi̱ b̯wamwe b̯wagyendengi̱ ni̱b̯weteerya. ");
INSERT INTO rub_vpl VALUES ("ET9_5","018_9_5","EST","9","5","5","Bayudaaya baatemi̱temi̱ri̱ banyanzigwa baab̯u na mpirima baabei̱ta, baabazi̱ki̱i̱rya ki̱mwei̱. Baakoori̱ho bab̯wo banyakubba babanobi̱ri̱ nka kubendyengi̱. ");
INSERT INTO rub_vpl VALUES ("ET9_6","018_9_6","EST","9","6","6","Mu rub̯uga lu̱handu̱ lwa Su̱u̱sa, Bayudaaya bei̱ti̱ri̱ bantu bi̱ku̱mi̱ bitaanu (500). ");
INSERT INTO rub_vpl VALUES ("ET9_7","018_9_7","EST","9","7","7","Mu bab̯wo bantu bei̱ti̱i̱ri̱mwo de, Pari̱sani̱daasa, Dali̱fooni̱, Asi̱paata, ");
INSERT INTO rub_vpl VALUES ("ET9_8","018_9_8","EST","9","8","8","Poraasa, Adaali̱ya, Ari̱daasa, ");
INSERT INTO rub_vpl VALUES ("ET9_9","018_9_9","EST","9","9","9","Pari̱masi̱ta, Ari̱saayi̱, Ari̱daayi̱ na Vayi̱saaza, ");
INSERT INTO rub_vpl VALUES ("ET9_10","018_9_10","EST","9","10","10","batabani̱ ba Hamani i̱ku̱mi̱, mu̱tabani̱ wa Hamadasa munyanzigwa wa Bayudaaya, bei̱tu̱ baatakakwateho itungu lyab̯u. ");
INSERT INTO rub_vpl VALUES ("ET9_11","018_9_11","EST","9","11","11","Muhendu gwa bantu banyakwi̱ti̱b̯wa mu rub̯uga lu̱handu̱ lwa Su̱u̱sa baagu̱rangi̱i̱ri̱ mukama ha kiro kyokyo kyonyi̱ni̱. ");
INSERT INTO rub_vpl VALUES ("ET9_12","018_9_12","EST","9","12","12","Mukama yaaweera Mu̱go Esi̱teeri̱ yati, “Bayudaaya bei̱ti̱ri̱, baazi̱kya bantu bi̱ku̱mi̱ bitaanu, na batabani̱ ba Hamani i̱ku̱mi̱ mu rub̯uga lu̱handu̱ lwa Su̱u̱sa. Baabba bei̱ti̱ri̱ haha bab̯wo bensei̱, bengahi bakoolerweho mu masaza ga b̯ukama b̯wensei̱? Oli na kyokusaba hataati̱? Ki̱kwi̱za kukuheeb̯wa. Kyani kyokwendya? Nakyo okwi̱za kukitunga.” ");
INSERT INTO rub_vpl VALUES ("ET9_13","018_9_13","EST","9","13","13","Esi̱teeri̱ yei̱ri̱ri̱mwo naakoba yati, “Mukama waabba oki̱si̱i̱mi̱ri̱, ikiriza Bayudaaya baamu Su̱u̱sa baru̱mbe banyanzigwa baab̯u mwakya mwa kwelwanaho, nka kukyakali kiro kya deeru. Kandi leka babbanike mitumbi i̱ku̱mi̱ mya batabani̱ ba Hamani midengeete ha madaara.” ");
INSERT INTO rub_vpl VALUES ("ET9_14","018_9_14","EST","9","14","14","Nahab̯waki̱kyo mukama yaakoori̱ kyʼEsi̱teeri̱ ki̱yaasabi̱ri̱. Baahu̱lu̱kya kihandiiko mu Su̱u̱sa, na mitumbi i̱ku̱mu̱ mya batabani̱ ba Hamani baamibbanika. ");
INSERT INTO rub_vpl VALUES ("ET9_15","018_9_15","EST","9","15","15","Ha kiro kyei̱ku̱mi̱ na binei bya mweri̱ gwʼAdara, Bayudaaya beecooki̱ri̱ murundi gundi, bei̱ta bantu bandi bi̱ku̱mi̱ bisatu (300) mu Su̱u̱sa, bei̱tu̱ baatakabatooleho itungu lyab̯u lyensei̱. ");
INSERT INTO rub_vpl VALUES ("ET9_16","018_9_16","EST","9","16","16","Ha b̯wi̱re b̯u̱b̯wo Bayudaaya banyakubba nibali mu masaza gandi ga b̯ukama beecooki̱ri̱ nibakugyendeera kwelwanaho. Bei̱ti̱ri̱ banyanzigwa baab̯u mitwaru musanju na nku̱mi̱ itaanu (75,000), bei̱tu̱ Bayudaaya baatakakwateho kintu kyensei̱ kya banyanzigwa baab̯u. ");
INSERT INTO rub_vpl VALUES ("ET9_17","018_9_17","EST","9","17","17","Bi̱byo byensei̱ byabbeeri̱ho ha kiro kyei̱ku̱mi̱ na bisatu kya mweri̱ gwʼAdara, kasi baahuumulaho ha kiro kyei̱ku̱mi̱ na binei, baki̱foora kiro kya B̯u̱genyi̱ na kusemererwa. ");
INSERT INTO rub_vpl VALUES ("ET9_18","018_9_18","EST","9","18","18","Bei̱tu̱ kandi, Bayudaaya banyakubba nibali mu rub̯uga Su̱u̱sa beecooki̱ri̱ ku̱lwani̱sya banyanzigwa baab̯u ha kiro kyei̱ku̱mi̱ na bisatu na kyei̱ku̱mi̱ na binei. Baahuumula ha kiro kyei̱ku̱mi̱ na bitaanu. Ki̱kyo kiro baakifoora kiro kya B̯u̱genyi̱ na kusemererwa. ");
INSERT INTO rub_vpl VALUES ("ET9_19","018_9_19","EST","9","19","19","Kyokyo b̯uli kiro kyei̱ku̱mi̱ na binei kya mweri̱ gwʼAdara, Bayudaaya banyakwicalanga mu byaru baaki̱twalengi̱ kubba kiro ki̱handu̱ kya kusemererwa na kujaguza. Baahenganengi̱ bisembu bya bidyo. ");
INSERT INTO rub_vpl VALUES ("ET9_20","018_9_20","EST","9","20","20","Morodokaayi̱ yaahandi̱i̱ki̱ri̱ ha b̯uli kyensei̱ kinyakubbaho, yaabi̱si̱ndi̱ki̱ra Bayudaaya bensei̱ ba mu masaza gensei̱ ga hadei na heehi̱ mu b̯ukama b̯wʼAhaswero, ");
INSERT INTO rub_vpl VALUES ("ET9_21","018_9_21","EST","9","21","21","naakubaweera batengemwona ki̱ti̱i̱ni̱sa kiro kyei̱ku̱mi̱ na binei kya mweri̱ gwʼAdara na kyei̱ku̱mi̱ na bitaanu kya mweri̱ gwogwo gu̱mwei̱, b̯uli mwaka. ");
INSERT INTO rub_vpl VALUES ("ET9_22","018_9_22","EST","9","22","22","Hab̯wakubba bi̱byo byobyo biro na mweri̱ gwa Bayudaaya baakeni̱ri̱ banyanzigwa baab̯u b̯u̱byafooki̱ri̱ biro bya kujaguza na kusemererwa kuruga mu b̯ujune. Morodokaayi̱ yaabaragi̱i̱ri̱ kujaguzanga bi̱byo biro na kusemererwa, babaganenge bidyo kandi bahenge baseege bisembu. ");
INSERT INTO rub_vpl VALUES ("ET9_23","018_9_23","EST","9","23","23","Nahab̯waki̱kyo Bayudaaya baasembi̱ri̱ ki̱kyo kikorwa kya kujaguza kibaali batandi̱ki̱ri̱, na bi̱byo bya Morodokaayi̱ yaahandi̱i̱ki̱ri̱ naabaragira. ");
INSERT INTO rub_vpl VALUES ("ET9_24","018_9_24","EST","9","24","24","Hab̯wakubba Hamani mu̱tabani̱ wa Hamadasa, Mu̱gagi̱, munyanzigwa wa Bayudaaya benseenya yaali na rukwe lwa ku̱bazi̱kya, naaku̱toolya nka kuyaakikora kurungi, yaaki̱rabi̱i̱rye mu karu̱ru̱. ");
INSERT INTO rub_vpl VALUES ("ET9_25","018_9_25","EST","9","25","25","Bei̱tu̱ Esi̱teeri̱ b̯u̱yaadoori̱ mu mei̱so ga mukama, mukama yaahandi̱i̱ki̱ri̱ kihandiiko naakoba nti, kibii kya Hamani kwi̱ta Bayudaaya kibbe ha mu̱twe gwamwe. Yo na batabani̱ baamwe boobo babaabbani̱ki̱ri̱ ha madaara. ");
INSERT INTO rub_vpl VALUES ("ET9_26","018_9_26","EST","9","26","26","Nahab̯waki̱kyo, Bayudaaya beetengi̱ bi̱byo biro Pu̱li̱mu̱, kuruga mu kigambu Pu̱ri̱ kya Luhebburaniya kya kadei ki̱ku̱manyi̱sya ku̱cu̱hya. Nahab̯waki̱kyo, hab̯wa bintu binyakubba bi̱handi̱i̱ki̱i̱rwe mu gi̱gyo bbaruha, na hab̯wa b̯ujune b̯ubaali barabi̱ri̱mwo na bi̱byo binyakubagwaho, ");
INSERT INTO rub_vpl VALUES ("ET9_27","018_9_27","EST","9","27","27","baasembi̱ri̱ na maani kintu kya kujaguzanga bi̱byo biro bibiri b̯uli mwaka hamwei̱ na baana baab̯u na bab̯wo baku̱beju̱byamwo nka bbaruha ku̱gyakobengi̱. ");
INSERT INTO rub_vpl VALUES ("ET9_28","018_9_28","EST","9","28","28","Kyateebeerweho nti, bi̱byo biro bi̱zu̱kwenge kandi Bayudaaya babitengemwo ki̱ti̱i̱ni̱sa myaka myensei̱, nganda zensei̱ mu masaza na mu rub̯uga, kandi nti, bi̱byo biro bya Pu̱li̱mu̱ bitalirugaho, habbe beizukulu baab̯u batalilekaho kubijaguza. ");
INSERT INTO rub_vpl VALUES ("ET9_29","018_9_29","EST","9","29","29","Mwomwo Mu̱go Esi̱teeri̱, muhara wʼAbi̱hai̱ri̱, na Morodokaayi̱ Muyudaaya, baakora kihandiiko kindi ki̱ku̱gu̱mya bbaruha gya Morodokaayi̱ ha bi̱byo biro bya Pu̱li̱mu̱. ");
INSERT INTO rub_vpl VALUES ("ET9_30","018_9_30","EST","9","30","30","Bbaruha baazi̱handi̱i̱ki̱i̱ri̱ Bayudaaya bensei̱, bazi̱sasaani̱a mu masaza ki̱ku̱mi̱ gabiri na musanju (127) mu b̯ukama wʼAhaswero, hab̯wa kwerinda na b̯u̱si̱nge, ");
INSERT INTO rub_vpl VALUES ("ET9_31","018_9_31","EST","9","31","31","nizikukoba nti, bi̱byo biro bya Pu̱li̱mu̱ bakusemeera ku̱bi̱zu̱kanga b̯uli mwaka, nka Morodokaayi̱ Muyudaaya na Mu̱go Esi̱teeri̱ kubaali babaragi̱i̱ri̱, na bantu banyakubba beeheeri̱yo na baana baab̯u, hab̯wa kusibanga na kwesengereeryanga. ");
INSERT INTO rub_vpl VALUES ("ET9_32","018_9_32","EST","9","32","32","Ki̱kyo kiragiro kyʼEsi̱teeri̱ kyateeri̱ho maani hoi̱ ha kujaguzanga bi̱byo biro bya Pu̱li̱mu̱, kyahandiikwa mu kitabbu mu b̯utongole. ");
INSERT INTO rub_vpl VALUES ("ET10_1","018_10_1","EST","10","1","1","Mukama Ahaswero yaahu̱lu̱ki̱i̱rye kiragiro kinyakutaho musolo ha bantu bensei̱ mu b̯ukama, na bab̯wo ba ha mitanda mya b̯ukama. ");
INSERT INTO rub_vpl VALUES ("ET10_2","018_10_2","EST","10","2","2","Bikorwa byensei̱ bya maani na b̯u̱sobozi̱ b̯wa Morodokaayi̱ na ki̱ti̱i̱ni̱sa kyensei̱ kya mukama yaamu̱heeri̱, byahandi̱i̱ki̱i̱rwe mu bitabbu byakwi̱zu̱ka bya bakama ba Medi̱ya na Paasa. ");
INSERT INTO rub_vpl VALUES ("ET10_3","018_10_3","EST","10","3","3","Hab̯wakubba Morodokaayi̱ Muyudaaya yooyo yaali wa kabiri mu b̯u̱sobozi̱ hali Mukama Ahaswero na mu ki̱ti̱i̱ni̱sa, naali wa maani hoi̱ mu Bayudaaya. Kandi Bayudaaya bakukira b̯unene baamu̱tengemwo ki̱ti̱i̱ni̱sa, hab̯wakubba yaakorengi̱ hab̯wa kuheereza bantu baamwe na hab̯wa kutonganira b̯urungi wa Bayudaaya bensei̱.");
INSERT INTO rub_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Kaali na mu̱gi̱sa ateegwa kulamba kwa nkori̱ za bibii, habbe kukwata muhanda gwa babiibi, habbe ku̱di̱da na bagayi̱, ");
INSERT INTO rub_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","bei̱tu̱ asanyurikira mu biragiro bya Mukama, abiteekerezaho i̱jolo na mwinsi. ");
INSERT INTO rub_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Eisana musaali gusimbe heehi̱ na meezi̱, gwana byana mu b̯u̱su̱mi̱ b̯wagwo, bikoora byagwo tibihotoka. Mu bintu byensei̱ byakora abba na mu̱gi̱sa. ");
INSERT INTO rub_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Bei̱tu̱ babiibi tibabba yatyo, beisana bisusunga bitwalwa mpehu. ");
INSERT INTO rub_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Kyokyo babiibi batalyemeera kutongana musangu, habbe kwicaara hamwei̱ na barungi, ");
INSERT INTO rub_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","hab̯wakubba barungi beebembeerya Mukama, bei̱tu̱ mihanda mya babiibi mibatwala mu ku̱zi̱ka. ");
INSERT INTO rub_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","Hab̯waki mahanga geegu̱ngwi̱ze na bantu bategeki̱ri̱ kukora bintu bitalimwo? ");
INSERT INTO rub_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Bakama ba mu nsi beekobi̱ri̱, beetara hamwei̱ na balemi̱ ku̱lwani̱sya Mukama na Mutongoole waamwe. ");
INSERT INTO rub_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","Babaza nibakoba, “Tu̱kadu̱le njegere zaab̯u, tukasuke na mpi̱ngo zaab̯u.” ");
INSERT INTO rub_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","Yogwo ei̱cali̱i̱ri̱ mwiguru abaseka b̯u̱seki̱, Mukama agaya b̯u̱gayi̱ ntegeka zaab̯u. ");
INSERT INTO rub_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","Mwomwo mu ki̱ni̱ga kinene alibacoomera, atab̯u̱ki̱ri̱ kandi bati̱i̱ni̱re ki̱mwei̱ naabaweera yati, ");
INSERT INTO rub_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","“Ku lusahu lwange lutongoole, Sayu̱u̱ni̱, nteeri̱hoona mukama wange.” ");
INSERT INTO rub_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","Mukama yaabazi̱ri̱ naakoba yati, “Nkwi̱za kuranga kiragiro kya Mukama. Mukama ki̱yambwereeri̱ nti, ‘Oli mwana wange, nku̱byeri̱, ndi bbaawu na deeru lili. ");
INSERT INTO rub_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","Nsaba, nkwi̱za kukuha mahanga ogagweterwe, nsi gyensei̱ ndigikuha nka itungu lyamu. ");
INSERT INTO rub_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Oligalema na mubbeere gwa kyoma, oligacwacwana nka byese byeib̯umba!’ ” ");
INSERT INTO rub_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Nahab̯waki̱kyo, nywe bakama, mu̱bbe na magezi̱, nywe balemi̱ ba mu nsi, mwegyendereze. ");
INSERT INTO rub_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Mu̱heerezenge Mukama na ki̱ti̱i̱ni̱sa, mu̱semererwe mu̱ki̱ti̱ke. ");
INSERT INTO rub_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Mu̱mu̱ramye aleke atasaalirwa, akabagu̱mi̱ri̱i̱rya mu muhanda, hab̯wakubba akwatwa ki̱ni̱ga b̯wangu. Bali na mu̱gi̱sa bensei̱ bamwesiga ");
INSERT INTO rub_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","Zabbu̱li̱ gya Dau̱di̱ b̯uyaali naakwi̱ru̱ka Abbu̱solomu̱, mu̱tabani̱ waamwe. Banyanzigwa bange, ai̱ Mukama, kabakanyi̱ri̱? Bantu bakumparana kabanene! ");
INSERT INTO rub_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","Banene bakumbazaho nibakoba yati, “Ruhanga takwi̱za kumujuna.” ");
INSERT INTO rub_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","Bei̱tu̱, ai̱ Mukama, weewe ngab̯u gyange gindinda, weewe ki̱ti̱i̱ni̱sa kyange, ompa ku̱byokya mu̱twe gwange. ");
INSERT INTO rub_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","Nnyaku̱ngi̱ri̱ Mukama, yanzi̱ramwo yeeraga kuruga ha lusahu lwamwe lurungi. ");
INSERT INTO rub_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","Nndaala ninyeebbaka, ni̱nzi̱ra ni̱nsi̱si̱mu̱ka hab̯wakubba ondi̱ndi̱ri̱, Mukama. ");
INSERT INTO rub_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Nku̱mi̱ na nku̱mi̱ za bantu b̯uzingota, ti̱ndi̱zi̱ti̱i̱na. ");
INSERT INTO rub_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","Ai̱ Mukama, byoka! Njuna, Ruhanga wange! Kuuta ndahi matama ga banyanzigwa bange bensei̱, ocwacwana meino ga babiibi. ");
INSERT INTO rub_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","Mukama, weewe ojuna, nooha bantu baamu mu̱gi̱sa. ");
INSERT INTO rub_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱: Bikukwata ha kyembu kilimwo ki̱dongo. Zabbu̱li̱ gya Dau̱di̱. Ai̱ Ruhanga wange antonganiira, wanyeetegeryanga b̯unyakakwetanga. Onjunenge mu b̯ujune b̯wange, mu mbabazi̱ zaamu weegwanga kusaba kwange. ");
INSERT INTO rub_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","Nywe bantu, muliicala nimumpemura kudwa di̱i̱? Mu̱li̱doosya hanya kwicala ni̱mwendya bintu bitalimwo naakuhondera byab̯u̱gobya? ");
INSERT INTO rub_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","Bei̱tu̱ mukyege nti, Mukama ba mananu abasorooramwo babbe baamwe, Mukama anzi̱ramwona b̯umukunga. ");
INSERT INTO rub_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","B̯umwakabbanga na ki̱ni̱ga, mutakoranga kibii, mwetekerenge nimubiteekerezaho mu̱leeri̱ mu bitabbu byenyu̱. ");
INSERT INTO rub_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","Mu̱henge Mukama, bihongwa birungi, kandi mu̱mwesi̱genge. ");
INSERT INTO rub_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","Banene bakoba, “Naani alituha birungi? Ai̱ Mukama, leka kyererezi̱ kya mei̱so gaamu kitumulukire!” ");
INSERT INTO rub_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","Ompeeri̱ kusemererwa kunene mu mutima, kukukira kwa bab̯wo bereerye nganu na bahi̱i̱si̱i̱rye maaci. ");
INSERT INTO rub_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","Hati̱ nu, kandaale mu b̯u̱si̱nge nyeebbake, kubba, ai̱ Mukama, weewe wankei ompa kwicala kurungi. ");
INSERT INTO rub_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱, bya kikwatu kya ndere: Zabbu̱li̱ gya Dau̱di̱. Ai̱ Mukama, weetegeeryanga bigambu byange, oteekerezenge ha kuwonawona kwange. ");
INSERT INTO rub_vpl VALUES ("PS5_2","020_5_2","PSA","5","2","2","Weegwanga iraka lya b̯ujune b̯wange, Mukama kandi Ruhanga wange, hab̯wakubba ndiriira weewe. ");
INSERT INTO rub_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","B̯uli mwakya, ai̱ Mukama, weegwa iraka lyange, b̯uli mwakya nndeeta kihongwa, nindindiira onzi̱remwo. ");
INSERT INTO rub_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","Kubba oli Ruhanga atasi̱i̱ma bikorwa bibiibi, nkori̱ za bibii tiziicala nawe. ");
INSERT INTO rub_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","Banyamyehembu tibalyemeera mu mei̱so gaamu, onoba nkori̱ za bibii zensei̱. ");
INSERT INTO rub_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","Ohwerekererya bab̯wo babaza b̯u̱gobya, Mukama anoba bantu batu̱u̱bi̱ri̱ kubbwoma ibbanga na ku̱gobya. ");
INSERT INTO rub_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","Bei̱tu̱ hab̯wa ngonzi zaamu zinene, nyei̱zanga mu nnyu̱mba gyamu gi̱syanu̱, nyaaku̱ndanga malu̱ ni̱nku̱ramya mu ki̱ti̱i̱ni̱sa kinene. ");
INSERT INTO rub_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","Ai̱ Mukama, nyeebemberanga mu mananu gaamu hab̯wa banyanzigwa bange, onterekereeryenge mu muhanda gwamu. ");
INSERT INTO rub_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","Hab̯wakubba tibabaza mananu, bateekerereza mu kukora bibiibi. Mimiro myab̯u mili nka bituuru bib̯uule, mi̱nwa myab̯u mibaza b̯u̱gobya. ");
INSERT INTO rub_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","Ai̱ Ruhanga, bahe kifubiro, leka bagwenge mu mitegu myab̯u bankei. Babinge mu mei̱so gaamu hab̯wa bibii byab̯u binene, hab̯wakubba baku̱jeemeeri̱. ");
INSERT INTO rub_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","Bei̱tu̱ bensei̱ bakwesiga leka basemererwe, leka baku̱hi̱i̱mi̱re mu kusemererwa kunene biro byensei̱. Obatengeho b̯u̱li̱ndi̱ b̯wamu, aleke bab̯wo bendya ibara lyamu bakutendenge. ");
INSERT INTO rub_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","Kubba weewe, ai̱ Mukama, oha muntu mwesigwa mu̱gi̱sa, mbabazi̱ zaamu nizimubbumba nka ngab̯u. ");
INSERT INTO rub_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱. Bikukwata ha kyembu kilimwo ki̱dongo kya mahu̱u̱zi̱ munaanei. Zabbu̱li̱ gya Dau̱di̱. Ai̱ Mukama, otampab̯uranga na ki̱ni̱ga, habbe kunfubira na b̯usungu. ");
INSERT INTO rub_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","Nsaasira ai̱ Mukama, kubba ndimuceke, mmponia ai̱ Mukama, kubba maku̱ha gange gakunseenya. ");
INSERT INTO rub_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","Na kindi ntu̱ntwi̱ri̱ hoi̱. Bei̱tu̱ ai̱ Mukama, oli̱doosya di̱i̱? ");
INSERT INTO rub_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","Ai̱ Mukama, ncungura, onjune hab̯wa ngonzi zaamu zinene. ");
INSERT INTO rub_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","Hab̯wakubba tihaloho akwi̱zu̱ka mu nsi gya baku̱u̱, naani yaakuhaariiza kuzumu? ");
INSERT INTO rub_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Njwahi̱ri̱ kulira, mali̱ga ga b̯uli kiro galu̱bi̱i̱rye kitabbu kyange, musagu gwange gu̱tobi̱ri̱ na mali̱ga. ");
INSERT INTO rub_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Mei̱so gange tigacahweza hab̯wa b̯ujune, gakwi̱ri̱ hab̯wa banyanzigwa bange. ");
INSERT INTO rub_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Mu̱ndu̱gehoona, nywe nkori̱ za bibii, hab̯wakubba Mukama yeegwi̱ri̱ kizabiro kyange. ");
INSERT INTO rub_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","Mukama yeegwi̱ri̱ kwesengereerya kwange, Mukama ei̱ki̱ri̱i̱ze kusaba kwange. ");
INSERT INTO rub_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","Banyanzigwa bange bensei̱ baakwatwanga nsoni̱, nibakankanira ki̱mwei̱, mu kuswaraswara baajumbutukanga ni̱bei̱ru̱ka. ");
INSERT INTO rub_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","Zabbu̱li̱ gya Dau̱di̱ gi̱yaahi̱i̱mi̱i̱ri̱ Mukama hab̯wa Ku̱u̱si̱ wa mu luganda lwa Bbenyami̱i̱ni̱. Ai̱ Mukama, Ruhanga wange, weewe gi̱nyeru̱ki̱i̱ranga, njuna hali banyanzigwa bange bensei̱, oncungure. ");
INSERT INTO rub_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","Kitali ki̱kyo bei̱za kuntaagura nka ntali, bancenkencenke, ndemwe muntu yanjuna. ");
INSERT INTO rub_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","3","Ai̱ Mukama Ruhanga wange, nyaabba nyaakoori̱ kintu nka kiki, ngalu zange zaabba zaaheneeri̱, ");
INSERT INTO rub_vpl VALUES ("PS7_4","020_7_4","PSA","7","4","4","nyaabba nyaadi̱i̱ri̱mwo rukwe munywani wange, kadi habbe kunyaga banyanzigwa bange hataloho nsonga, ");
INSERT INTO rub_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","ikiriza munyanzigwa wange andonze ankwate, mu̱leke angume hansi anjurunge mu cuucu. ");
INSERT INTO rub_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","Ai̱ Mukama, mu ki̱ni̱ga kyamu ru̱mba, byokira b̯ubiibi b̯wa banyanzigwa bange, si̱si̱mu̱ka onjune, weewe ocwa gwab̯ulyo. ");
INSERT INTO rub_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","Leka mahanga geecooke mu mei̱so gaamu, ogafugire hakyendi̱ mwiguru. ");
INSERT INTO rub_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","Mukama yooyo acwere bantu misangu, ai̱ Mukama ncwera ku̱si̱gi̱ki̱ra ha b̯urungi b̯wange, na mananu gange. ");
INSERT INTO rub_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","Leka bibii bya babiibi bibbe na ha bikusambiira, kandi olindenge bab̯wo bakora bya mananu, weewe ai̱ Ruhanga wa mananu, olenga biteekerezu bya mitima myetu̱. ");
INSERT INTO rub_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","Ruhanga Aki̱i̱rayo Ki̱mwei̱, weewe ngab̯u gyange, mu̱li̱ndi̱ wa bab̯wo barungi mitima. ");
INSERT INTO rub_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","Ruhanga acwa misangu mya b̯ulyo, afubira babiibi b̯uli kiro. ");
INSERT INTO rub_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","Kakubba muntu ateezi̱ramwo, Ruhanga ahyolya nsone gyamwe, naakora b̯uta na mbasi ze naazitegeka. ");
INSERT INTO rub_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","Ategeka byaku̱lwani̱sya binyamaani, naataho mbasi zikwaka mworo. ");
INSERT INTO rub_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","Wona, mubiibi b̯uyeemeta kibii, akabba na nda gya b̯ubiibi, abyala b̯u̱gobya. ");
INSERT INTO rub_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","Atega bandi b̯u̱hya, bei̱tu̱ yooyo ab̯ugwamwo. ");
INSERT INTO rub_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","Itima lye li̱i̱ra ha mu̱twe gwamwe, ki̱ni̱ga kye ki̱ru̱mya yooyo yankei. ");
INSERT INTO rub_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","Nyaaku̱si̱i̱manga Mukama, hab̯wa mananu gaamwe, nyaahi̱i̱manga bikuhaariiza ibara lya Mukama, Waahakyendi̱ Hoi̱. ");
INSERT INTO rub_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","Hali Mu̱handu̱ wa Bahi̱i̱mi̱. Zabbu̱li̱ gya Dau̱di̱. Ai̱ Mukama, Mukama weetu̱, ibara lyamu kali̱ti̱i̱nwa mu nsi gyensei̱! Ki̱ti̱i̱ni̱sa kyamu kibba hakyendi̱ weiguru. ");
INSERT INTO rub_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Mu mi̱nwa mya baana bato na nkerembe oteeri̱mwo ki̱ti̱i̱ni̱sa, oteeri̱ho ki̱si̱i̱ka kyamaani ku banyanzigwa baamu, naakumaliraho ki̱mwei̱ bahoora nzi̱go. ");
INSERT INTO rub_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","B̯undingiira iguru li̱waahangi̱ri̱ na ngalu zaamu, nkawona mweri̱ na nzota bi̱waarambi̱ki̱ri̱ mu mwanya, ");
INSERT INTO rub_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","nnyeeb̯u̱u̱lya, “Muntu yooyo naani, we, kumuteekerezaho, na mwana wa muntu hab̯waki omufaaho?” ");
INSERT INTO rub_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Kandi b̯u̱b̯wo, waamu̱hangi̱ri̱ yaabba hansiho kadooli̱ hali bamalayika, waamutaho ki̱ti̱i̱ni̱sa nka kondo. ");
INSERT INTO rub_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Waamu̱heeri̱ b̯u̱sobozi̱ hali bintu bi̱waakoori̱ na ngalu zaamu, waata bintu byensei̱ hansi wa magulu gaamwe: ");
INSERT INTO rub_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","ntaama na nte zensei̱, na bisolo bya mwirungu, ");
INSERT INTO rub_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","bi̱nyoni̱ bya mu mwanya, na nsu̱ za mu mataka gakooto, na bihangwa byensei̱ bya mu meezi̱. ");
INSERT INTO rub_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","Ai̱ Mukama, Mukama weetu̱, ibara lyamu kali̱ti̱i̱nwa mu nsi gyensei̱! ");
INSERT INTO rub_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","Hali Mu̱handu̱ wa Bahi̱i̱mi̱. Zabbu̱li̱ gya Dau̱di̱. Ai̱ Mukama, nyaaku̱si̱i̱manga na mutima gwange gwensei̱, nyaatebyanga byamahanu byamu byensei̱ bi̱waakoori̱. ");
INSERT INTO rub_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","Nyaasemererwanga ni̱nku̱ramya, nyaaku̱hi̱i̱mi̱ranga ninkuhaariiza we Ruhanga, Waahakyendi̱ Hoi̱. ");
INSERT INTO rub_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","Banyanzigwa bange b̯ubaakuwona bakubayo i̱nyu̱ma, nibagwa ni̱bakwa. ");
INSERT INTO rub_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","Hab̯wakubba weewe ondwaniira kandi ontonganiira, oi̱cali̱i̱ri̱ kitebe kyamu kya b̯ukama kucwa gwab̯ulyo. ");
INSERT INTO rub_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","Waamira mahanga, noozi̱kya bantu babiibi, obasusura ni̱basyera biro na biro. ");
INSERT INTO rub_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","Ki̱kazi̱kya banyanzigwa beetu̱ cekeceke tikili na ki̱ki̱ti̱gi̱ri̱, oku̱pwi̱ri̱ mbuga zaab̯u, titucakabateekerezaho. ");
INSERT INTO rub_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","Bei̱tu̱ Mukama alema biro byensei̱, ha kitebe kya b̯ukama b̯wamwe akora byab̯winganiza, ");
INSERT INTO rub_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","acwera nsi gyensei̱ ku̱si̱gi̱ki̱ra ha mananu, naacwera bantu mu b̯winganiza. ");
INSERT INTO rub_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","Mukama abba mpagi̱ gya banaku, yooyo b̯wi̱ru̱ki̱ro b̯wab̯u mu b̯wi̱re b̯wa b̯ujune. ");
INSERT INTO rub_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","Bab̯wo bakutamwo ki̱ti̱i̱ni̱sa baakwesiganga, hab̯wakubba we, ai̱ Mukama, bab̯wo baakwesengereerya tobaleeka. ");
INSERT INTO rub_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","Mu̱hi̱i̱me muhaariiza Mukama, yogwo alema Sayu̱u̱ni̱! Mu̱tebye bikorwa byamwe hali bantu. ");
INSERT INTO rub_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","Kubba yogwo muhoora nzi̱go abeegi̱ri̱ bakuwonawona, ti̱yeebeera kizabiro kya bakuwonawona. ");
INSERT INTO rub_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","Ai̱ Mukama, nngiira mbabazi̱! Lingiira bab̯wo banyakunnoba nka ku̱baku̱mbonawonesya, ai̱ Mukama, njuna hali maani ga lu̱ku̱u̱, ");
INSERT INTO rub_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","aleke nsobore kukuhaariiza, hahwo mwirembu lya bantu ba Sayu̱u̱ni̱ nsobore kusemererwa hab̯wa kujunwa kwamu. ");
INSERT INTO rub_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","Mahanga kagagwi̱ri̱ mu b̯u̱hya b̯u̱baali̱mi̱ri̱, mu kitimba ki̱baategi̱ri̱ kabakwatu̱rwemwo. ");
INSERT INTO rub_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","Mukama yeegebeerwe hab̯wa misangu myamwe mya b̯ulyo myasala, babiibi bakwatwa bikorwa bya ngalu zaab̯u. ");
INSERT INTO rub_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","Babiibi basi̱ri̱mu̱ka kuzumu, na bab̯wo bensei̱ beeb̯wa Ruhanga. ");
INSERT INTO rub_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","Bei̱tu̱ baseege, Ruhanga talibebeera, kandi ku̱ni̱hi̱ra kwa banaku tikulimalikaho. ");
INSERT INTO rub_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","Weemeera, ai̱ Mukama! Hatabbaho muntu aku̱si̱ngu̱ra, ocwere mahanga musangu. ");
INSERT INTO rub_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","Ai̱ Mukama, baru̱mbe baku̱ti̱i̱nenge aleke beege bali bantu b̯untu. ");
INSERT INTO rub_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","Ai̱ Mukama, hab̯waki ondahi̱i̱ri̱ho? Hab̯waki onyeebi̱si̱ri̱ho mu b̯wi̱re b̯wa b̯ujune? ");
INSERT INTO rub_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","Mu kwetembatembya babiibi bawonawonesya banaku, nikileetera banaku ku̱gwa mu mitegu mya babiibi. ");
INSERT INTO rub_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","Kwegomba kubiibi kubaha kwehaariiza, batu̱mbya byab̯u̱nyagi̱ naaku̱lu̱ma Mukama. ");
INSERT INTO rub_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","Myehembu myab̯u mibaha kugaya Ruhanga, bateekereza yati, “Ruhanga takabbangaho.” ");
INSERT INTO rub_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","B̯uli kibakakora kitunga mu̱gi̱sa, beetegereza kwahi micwere mya Ruhanga, bagaya b̯u̱gayi̱ banyanzigwa baab̯u. ");
INSERT INTO rub_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","Mu mitima myab̯u bateekereza nibakoba yati, “Tihaloho kikusobora kungwaho! Biro byensei̱ ndibbanga mu kusemererwa, nntali na b̯ujune.” ");
INSERT INTO rub_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","Babiibi beicala mu kukyena, kubaza b̯u̱gobya na ku̱zi̱ndi̱ri̱za bandi, mi̱nwa myab̯u mibaza bigambu bi̱ku̱habya na kunyaga. ");
INSERT INTO rub_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","Balindiira nibatega bantu mu byaru, nibalaliira kwi̱ta batali na musangu, naakutata batali na maani babakwate. ");
INSERT INTO rub_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","Nka mutali alaali̱ri̱i̱ri̱, batega nibalindiira mu bisaka, beebi̱sa aleke bagwere batali na maani, babakwatire mu mitegu myab̯u. ");
INSERT INTO rub_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","Bacwacwana batali na maani ni̱badi̱ki̱ra hansi, nibagundamira baceke hansi na maani gaab̯u gensei̱. ");
INSERT INTO rub_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","Babiibi baateekereza nibakoba yati, “Ruhanga tabafaaho, abaru̱gi̱ri̱ho, takwi̱za kutuwona.” ");
INSERT INTO rub_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","Ai̱ Mukama, ai̱ Ruhanga, weemeera na banaku, otabeebeera mu b̯ujune b̯wab̯u. ");
INSERT INTO rub_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","Hab̯waki mubiibi agayanga Ruhanga naakoba na mu mitima gwamwe yati, “Ruhanga takwi̱za kunjunaana!” ");
INSERT INTO rub_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","Bei̱tu̱ we, Ruhanga, b̯ujune na kuwonawona ku̱koleerwe, okwegi̱ri̱, bikwate, obajune, bakwesi̱gi̱ri̱, bajune, weewe ojuna nfu̱u̱zi̱. ");
INSERT INTO rub_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","Ocwacwana mikono mya babiibi, obajunaane bibiibi bibakora, hatasigalaho noomwei̱. ");
INSERT INTO rub_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","Mukama yooyo mu̱lemi̱ wa biro byensei̱, mahanga ga mu nsi gyamwe gali̱zi̱ka. ");
INSERT INTO rub_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","Ai̱ Mukama, weegwanga kulira kwa banaku, obatati̱i̱ryenge mitima myab̯u, ");
INSERT INTO rub_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","olwaniirenge nfu̱u̱zi̱ na baceke, aleke hatalibbaho mubiibi ku nsi aku̱bati̱i̱ni̱si̱ri̱i̱rya. ");
INSERT INTO rub_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","Hali Mu̱handu̱ wa Bahi̱i̱mi̱. Zabbu̱li̱ gya Dau̱di̱. Mukama, yooyo nyeesiga, musobora teetei̱ kumbwera, “I̱ru̱ka nka nnyoni̱ ha lusahu, ");
INSERT INTO rub_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","kubba na mu kyebi̱si̱i̱re babiibi bakweti̱ b̯uta na mbasi, zakulasa ba mitima mirungi, ");
INSERT INTO rub_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","Tihalohoona kya murungi akusobora akore, biragiro b̯ubilemereerwa.” ");
INSERT INTO rub_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","Mukama abba mu Yeekaru gyamwe gi̱syanu̱, kitebe kya Mukama kibba mwiguru, awona bali hansi na mei̱so gaamwe, naalenga bya baana ba bantu bibakora. ");
INSERT INTO rub_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","Mukama yooyo alenga barungi, bei̱tu̱ mutima gwamwe gunoba babiibi na bazongobi̱. ");
INSERT INTO rub_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","Leka mworo gu̱talu̱ma gu̱tokomokye babiibi, leka mworo guwa b̯uganga, ki̱bbi̱ri̱i̱ti̱ na mpehu kajuguta kingeere kibbenge kifubiro kyab̯u. ");
INSERT INTO rub_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","Kubba Mukama abba wa mananu, yendya bikorwa byamananu, barungi balimuwona. ");
INSERT INTO rub_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","Hali Mu̱handu̱ wa Bahi̱i̱mi̱. Zabbu̱li̱ gya Dau̱di̱. Ai̱ Mukama, tu̱ju̱ne, hab̯wakubba tihaloho noomwei̱ akutamwo ki̱ti̱i̱ni̱sa, munanu waahimwo mu bantu. ");
INSERT INTO rub_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","Bagobyangana bankei na bankei, nibehaariizangana na bigambu bitalimwo. ");
INSERT INTO rub_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","3","Ai̱ Mukama, ijala mi̱nwa mikwehaariiza, weetekereerye bensei̱ bakwepankapanka, ");
INSERT INTO rub_vpl VALUES ("PS12_4","020_12_4","PSA","12","4","4","nibakoba, “Tu̱kwi̱za ku̱bagobya ni̱tu̱basi̱ngu̱ra, byakubaza tuli nabyo, naani akusobora kuturagira?” ");
INSERT INTO rub_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","Mukama akoba yati, “Hab̯wa kuwonawona kwa museege, na b̯ujune b̯wa munaku, nkwi̱za kwi̱za mujune. Nkwi̱za kumuta mu kiikaru kya b̯u̱si̱nge ki̱yendyenge.” ");
INSERT INTO rub_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","Mukama b̯uyeeraga, yeeraga byabiribiri, kiragaanu kye kiisana feeza gi̱sengeeje ha kyoto mirundi musanju. ");
INSERT INTO rub_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","7","Ai̱ Mukama, otulindenge biro byensei̱, otujune bantu ba mu̱hi̱hi̱ gugu. ");
INSERT INTO rub_vpl VALUES ("PS12_8","020_12_8","PSA","12","8","8","Babiibi basaaseeni̱ hensei̱, ki̱heeri̱ bantu kuhaariiza b̯ubiibi. ");
INSERT INTO rub_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱. Zabbu̱li̱ gya Dau̱di̱. Ai̱ Mukama, olinzebeera ku̱doosya di̱i̱? Oli̱nyeebi̱saho kudwa di̱i̱? ");
INSERT INTO rub_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","Ndi̱doosya di̱i̱ kwicala ni̱mpu̱mpu̱u̱ta naakwicala na b̯ujune mu mutima gwange? Munyanzigwa wange ali̱doosya di̱i̱ kwicala naanyeb̯ugiraho? ");
INSERT INTO rub_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","Ai̱ Mukama Ruhanga wange, nteekerezaho onjune, omulikire aleke ntalaaliranga ki̱mwei̱ nkakwa, ");
INSERT INTO rub_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","nikikaha munyanzigwa wange kukoba, “Mmu̱si̱ngwi̱ri̱,” na banyakunnoba nibakasemererwa hab̯wa kulemererwa kwange. ");
INSERT INTO rub_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","Bei̱tu̱ nyeesiga mbabazi̱ zaamu, ncala nsemereerwe mu mutima hab̯wakubba wanju̱ni̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","Nkwi̱za ku̱hi̱i̱mi̱ra Mukama, hab̯wakubba onkoleeri̱ birungi binene. ");
INSERT INTO rub_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","Hali Mu̱handu̱ wa Bahi̱i̱mi̱. Zabbu̱li̱ gya Dau̱di̱. Mudoma ateekereza naakoba yati, “Ruhanga eicala waahi.” Bantu ba yatyo babba bagwagwa, bakora bikorwa bibiibi, tihalohoona noomwei̱ akora birungi. ");
INSERT INTO rub_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","Mukama wa mwiguru waalingiira bantu ba mu nsi, kuwona b̯uhakabbahoona akwetegereza, b̯uhakabbahoona aramya Ruhanga. ");
INSERT INTO rub_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","Bensei̱ bahabi̱ri̱, baabba bensei̱ hamwei̱ bagwagwa, tihalohoona noomwei̱ akora kirungi, waahi kadi noomwei̱. ");
INSERT INTO rub_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","Zi̱zo nkori̱ za bibii tizigira kwetegereza, bamalaho bantu bange nka bakudya bidyo, tibafaaho kusaba Mukama. ");
INSERT INTO rub_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","Bakukankana na b̯u̱ti̱i̱ni̱, kubba Ruhanga atonganiira mu̱hi̱hi̱ gwa beesigwa. ");
INSERT INTO rub_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Musobora ku̱b̯u̱ru̱ngu̱tani̱a ntegeka za banaku, bei̱tu̱ Mukama abba kujunwa kwab̯u. ");
INSERT INTO rub_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","Ee, nyaakwendeerye kujunwa kwʼI̱saleeri̱ kuruge mu Sayu̱u̱ni̱! Mukama aha bantu baamwe mu̱gi̱sa, leka Yakobbo asemererwe, leka I̱saleeri̱ gijaguze. ");
INSERT INTO rub_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","Zabbu̱li̱ gya Dau̱di̱. Ai̱ Mukama, naani yogwo ali̱goonya mu heema gyamu? Naani aliicala ha lusahu lwamu lu̱syanu̱? ");
INSERT INTO rub_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Yooyo yogwo akora birungi, atali na kakuu, abaza mananu ga ha mutima gwamwe, ");
INSERT INTO rub_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","atasi̱i̱ga bei̱ra nzi̱ro kandi atakora bataahi̱ baamwe kubiibi, habbe kuhesa banywani baamwe, ");
INSERT INTO rub_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","yooyo yogwo agaya nkori̱ za bibii kandi atamwo ki̱ti̱i̱ni̱sa bab̯wo baramya Mukama, yeemeera ku kigambu kyamwe, nab̯ukyabba ni̱ki̱ku̱ru̱mya. ");
INSERT INTO rub_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","Yooyo ahora sente zitaloho magoba, atagulwa ku̱zi̱ndi̱ri̱za atali na musangu. Yogwo akora bi̱byo tali na kyati̱i̱na. ");
INSERT INTO rub_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","Zabbu̱li̱ gya Dau̱di̱. Ai̱ Ruhanga, ondinde, hab̯wakubba nyeesiga weewe. ");
INSERT INTO rub_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","Nyaaku̱ngi̱ri̱ Mukama ninkoba yati, “Weewe Mukama wange, hali otali tindi na karungi kensei̱.” ");
INSERT INTO rub_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","Hab̯wa bantu ba Ruhanga ba mu nsi bali na bi̱ti̱i̱ni̱sa, ndi̱basi̱i̱ma, ");
INSERT INTO rub_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","bei̱tu̱ b̯ujune ku b̯ujune b̯ulibba hali bakuramya ruhanga wondi, kyonzira kyeibbanga kyab̯u tindi kihonga, habbe kwatula mabara gaab̯u na kanwa kange, tindigeeta. ");
INSERT INTO rub_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","Ai̱ Mukama, weewe mutongoole wange, ampa byensei̱ binkwetaaga, weewe oli na byensei̱. ");
INSERT INTO rub_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","Nsaru gyeitehe lyange gi̱ndeetera kusemererwa, mu mananu mugab̯u gwange gurungi. ");
INSERT INTO rub_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","Nku̱ku̱si̱i̱ma Mukama hab̯wa ku̱zeegesya, kadi habbe i̱jolo mutima gwange gumpa magezi̱. ");
INSERT INTO rub_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Nkyegi̱ri̱, Mukama abba na gya biro byenseenya, hab̯wakubba amba ha mukono gwange gwab̯udyo, ti̱ndi̱ti̱i̱na. ");
INSERT INTO rub_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","Nahab̯waki̱kyo, mutima gwange gu̱semereerwe hoi̱ kandi nyaaku̱hi̱i̱mi̱ranga, na mubiri gwange gweicalanga mu b̯u̱si̱nge, ");
INSERT INTO rub_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","hab̯wakubba tolindeka kwicala kuzumu, habbe kuleka mutongoole waamu kubbola. ");
INSERT INTO rub_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","Ompeeri̱ kwega muhanda gwa b̯womi, kyandeetera kusemererwa mu mei̱so gaamu, na kwesi̱i̱ma biro byensei̱. ");
INSERT INTO rub_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","Kusaba kwa Dau̱di̱. Ai̱ Mukama, weegwa kusaba kwange kwa mananu, otege ipokopo weetegeerye kukunga kwange, kutalimwo b̯u̱gobya. ");
INSERT INTO rub_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","Oncweremwona, aleke mei̱so gaamu gaawone mananu! ");
INSERT INTO rub_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","Mutima gwange ogwegi̱ri̱, nab̯u̱wei̱zanga i̱jolo, okandenga, tolinzagya na nsobi̱, nyeeheeri̱yo b̯utabaza b̯u̱gobya. ");
INSERT INTO rub_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","Nka ngesu za bantu kuzibba, ku̱si̱gi̱ki̱ra ha bigambu byamu, tinkanyaganga muntu wondi. ");
INSERT INTO rub_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","Biro byenseenya mpondera biragiro byamu, tinkahugukanga. ");
INSERT INTO rub_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","Nkunga weewe, ai̱ Ruhanga, hab̯wakubba weewe onzi̱ramwo, tega ipokopo weegwe bigambu byange. ");
INSERT INTO rub_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","Ndagiira mahanu ga mbabazi̱ zaamu, we ajuna bei̱ru̱ka hali we kwejuna banyanzigwa baab̯u. ");
INSERT INTO rub_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","8","Ondindenge nka mboni̱ gya li̱i̱so lyamu, ombumbenge mu ki̱tu̱ntu̱lu̱ kya bimpaha byo, ");
INSERT INTO rub_vpl VALUES ("PS17_9","020_17_9","PSA","17","9","9","onjune babiibi bandu̱mba, hali banyanzigwa bangoti̱ri̱ ku̱nzi̱ta. ");
INSERT INTO rub_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","Tibagira kisa mu mitima myab̯u, babaza bigambu bya kwehemba. ");
INSERT INTO rub_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","Baronzi̱ri̱ lugere lwange, hataati̱ bangoti̱ri̱, mei̱so gaab̯u gali ha kunguma hansi. ");
INSERT INTO rub_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","Akwisana ntali gikuraka b̯u̱raki̱ kutaagura, nka mwana gwa ntali gu̱laali̱ri̱i̱ri̱ mu kisaka. ");
INSERT INTO rub_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","Ai̱ Mukama, byoka! Omu̱ru̱mbe, omukwate! Oncungure na mpirima gyamu hali mubiibi, ");
INSERT INTO rub_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","ai̱ Mukama, onjune na ngalu gyamu hali babiibi, hali babiibi ba mu nsi bateekerereza mu b̯womi b̯wa gigi nsi. Nda zaab̯u zaahukanga na mukyenu gu̱bababi̱ki̱i̱ri̱, baana baab̯u baazi̱mbanga nda, kifubiro ki̱kyo baakilekeranga beezukulu baab̯u. ");
INSERT INTO rub_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","Bei̱tu̱ gya, atali na musangu mu mei̱so gaamu, ndikuwonaho, b̯u̱ndi̱kasi̱si̱mu̱ka nkakuwonaho ndisemererwa. ");
INSERT INTO rub_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","Hali Mu̱handu̱ wa Bahi̱i̱mi̱. Zabbu̱li̱ gya Dau̱di̱, muheereza wa Mukama, gili na bigambu bya kyembu kya Dau̱di̱ nka ku̱yaabi̱weereeri̱ Mukama ha kiro kya Mukama b̯u̱yaamu̱cu̱ngwi̱ri̱ kuruga mu ngalu za banyanzigwa baamwe bensei̱ na mu ngalu gya Sau̱lo. Dau̱di̱ abaza naakoba yati. Ai̱ Mukama, ka nnkwendya! Weewe maani gange. ");
INSERT INTO rub_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","Mukama weewe lubbaali lwange, lugo lwange, kandi Mu̱ju̱ni̱ wange, Ruhanga wange yooyo b̯wingira b̯wange hali nzi̱ru̱ki̱ra, ngab̯u gyange kandi b̯wi̱ru̱ki̱ro b̯wange, andwaniira. ");
INSERT INTO rub_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","Nkunga weewe Mukama, asemereeri̱ kuhaariizwa, anjuna banyanzigwa bange. ");
INSERT INTO rub_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","4","Nyaali mbohaboheerye miguha mya lu̱ku̱u̱, nku̱taku̱ti̱i̱rwe bijanga byaku̱nzi̱kya b̯u̱zi̱kya, ");
INSERT INTO rub_vpl VALUES ("PS18_5","020_18_5","PSA","18","5","5","miguha mya kuzumu mi̱nzi̱ngazi̱ngi̱ri̱, mitegu mya lu̱ku̱u̱ mi̱nkweti̱. ");
INSERT INTO rub_vpl VALUES ("PS18_6","020_18_6","PSA","18","6","6","Mu kuwonawona kwange, nyaaku̱ngi̱ri̱ Mukama, nyeesengereerya Ruhanga wange anjuna. Yeegwi̱ri̱ iraka lyange mu Yeekaru gyamwe, yeegwa kusaba kwange. ");
INSERT INTO rub_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","Mwomwo nsi gyakankana kandi gyazi̱ngi̱zi̱ka, na mi̱si̱nge mya nsahu myakaruka kandi myatengeeta hab̯wa ki̱ni̱ga kyamwe. ");
INSERT INTO rub_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","Mwi̱ca gwatu̱u̱ki̱ri̱ kuruga mu nni̱ndo gyamwe, na mworo gu̱kwokya gwaruga mu mu̱nwa gwamwe, makala gagegeeri̱ b̯u̱gegeeri̱ gaacuumuuka kuruga hali yo. ");
INSERT INTO rub_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","Yaani̱i̱nu̱ki̱ri̱ iguru yei̱za hansi, nti̱ti̱ gi̱kwati̱i̱ri̱ ki̱mwei̱ hansi wa magulu gaamwe. ");
INSERT INTO rub_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","Yaani̱i̱ni̱ri̱ malayika keru̱bbi̱ yaadu̱du̱u̱ka, yei̱za b̯wangu ha bimpaha bya mpehu. ");
INSERT INTO rub_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","Yaakora nti̱ti̱ gyamubbumba, yeeweeka hensei̱ bikaka biguma ndagali̱. ");
INSERT INTO rub_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","Kuruga mu kyererezi̱ kinyakubba mu mei̱so gaamwe, hei̱zi̱ri̱ho bikaka byamwe biwa makala ga mworo na ndagali̱ giwa mahi̱ga. ");
INSERT INTO rub_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","Mukama yaabbwatu̱ki̱ri̱ mwiguru, Waahakyendi̱ Hoi̱ yaahu̱lu̱kya iraka lye, lyaguma ndagali̱ giwa mahi̱ga na makala ga mworo. ");
INSERT INTO rub_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","Yaalasa mbasi zaamwe, yaasaasaani̱a banyanzigwa baamwe, yaabbwatula nkuba gyabasaraani̱a. ");
INSERT INTO rub_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","Mwomwo bi̱longi̱ro byeitaka byab̯u̱ku̱li̱i̱rwe, na mi̱si̱nge mya nsi myasigala hasyanu̱, ai̱ Mukama hab̯wa rwami̱ryo lwamu, na hab̯wa ki̱ni̱ga kya rwoya lwamu. ");
INSERT INTO rub_vpl VALUES ("PS18_16","020_18_16","PSA","18","16","16","Mukama, wa heiguru, yei̱zi̱ri̱ hansi yanjuna, yansika mu meezi̱ galei. ");
INSERT INTO rub_vpl VALUES ("PS18_17","020_18_17","PSA","18","17","17","Yanju̱ni̱ri̱ munyanzigwa wange munyamaani na bab̯wo banyakunnoba, hab̯wakubba baali nibakunkira maani. ");
INSERT INTO rub_vpl VALUES ("PS18_18","020_18_18","PSA","18","18","18","Bandu̱mbi̱ri̱ mu kasu̱mi̱ ka b̯ujune, bei̱tu̱ Mukama yandwani̱ri̱i̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS18_19","020_18_19","PSA","18","19","19","Yanju̱ni̱ri̱ yantwala hagali, yaancungura nikuli ku̱nsi̱i̱ma. ");
INSERT INTO rub_vpl VALUES ("PS18_20","020_18_20","PSA","18","20","20","Mukama yampeeri̱ mpeera gya mananu gange, yampa mu̱gi̱sa hab̯wa b̯utabba na musangu. ");
INSERT INTO rub_vpl VALUES ("PS18_21","020_18_21","PSA","18","21","21","Hab̯wakubba mpondera mihanda mya Mukama, timpuguka kuruga hali Ruhanga wange. ");
INSERT INTO rub_vpl VALUES ("PS18_22","020_18_22","PSA","18","22","22","Hab̯wakubba biragiro byamwe byensei̱ mbyegi̱ri̱, na mateeka gaamwe tinkagasuulanga. ");
INSERT INTO rub_vpl VALUES ("PS18_23","020_18_23","PSA","18","23","23","Tingira kakuu kensei̱ mu mei̱so gaamwe, nyeerinda kubba na musangu mu mutima gwange. ");
INSERT INTO rub_vpl VALUES ("PS18_24","020_18_24","PSA","18","24","24","Nahab̯waki̱kyo Mukama ampeeri̱ mpeera hab̯wa mananu gange, hab̯wakubba ngalu zange zi̱syanu̱ mu mei̱so gaamwe. ");
INSERT INTO rub_vpl VALUES ("PS18_25","020_18_25","PSA","18","25","25","Obba wambabazi̱ hali ali na mbabazi̱, obba mu̱terekereru̱ hali ali mu̱terekereru̱, ");
INSERT INTO rub_vpl VALUES ("PS18_26","020_18_26","PSA","18","26","26","hali ali na mitima gu̱syanu̱, b̯wolokya mutima gu̱syanu̱, bei̱tu̱ obba munyanzigwa wa nkori̱ gya bibii. ");
INSERT INTO rub_vpl VALUES ("PS18_27","020_18_27","PSA","18","27","27","Hab̯wakubba ojuna batali na myehembu, bei̱tu̱ banyamyepanku obeerya hansi. ");
INSERT INTO rub_vpl VALUES ("PS18_28","020_18_28","PSA","18","28","28","Hab̯wakubba weewe kyererezi̱ kya taara kyange, Mukama Ruhanga wange oleeta kyererezi̱ kumalaho nti̱ti̱. ");
INSERT INTO rub_vpl VALUES ("PS18_29","020_18_29","PSA","18","29","29","Hab̯wa maani gaamu nkusobora ku̱ru̱mba i̱he, na hab̯wa Ruhanga wange nkusobora ku̱gu̱su̱ka ki̱si̱i̱ka kya banyanzigwa. ");
INSERT INTO rub_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","Bei̱tu̱ yo Ruhanga, abba wa mihanda mi̱terekereru̱, kigambu kya Mukama kiicala kyesigwa. Yooyo ngab̯u gya bab̯wo bensei̱ bamwesiga. ");
INSERT INTO rub_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","Mukama yooyo Ruhanga yankei, kandi Ruhanga yankei, yooyo atulwaniira. ");
INSERT INTO rub_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","Yooyo Ruhanga antamwo maani, aterekereerya mihanda myange. ");
INSERT INTO rub_vpl VALUES ("PS18_33","020_18_33","PSA","18","33","33","Yaahangi̱ri̱ magulu gange nka ga mparaaki, yampa kwemeera hakyendi̱ wa lusahu. ");
INSERT INTO rub_vpl VALUES ("PS18_34","020_18_34","PSA","18","34","34","Atendeka ngalu zange kulwana, na mikono myange kureega b̯uta b̯wa kyoma. ");
INSERT INTO rub_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","Ompa ngab̯u gya kujunwa kwamu, onsagika na mukono gwamu gwab̯udyo, nompa kubba wa maani. ");
INSERT INTO rub_vpl VALUES ("PS18_36","020_18_36","PSA","18","36","36","Ongali̱hi̱ri̱i̱rye muhanda hanyaaraba, aleke magulu gange gatatereb̯uka. ");
INSERT INTO rub_vpl VALUES ("PS18_37","020_18_37","PSA","18","37","37","Nzi̱ru̱u̱kya banyanzigwa bange nimbakwata, ti̱nzi̱ra i̱nyu̱ma ku̱doosya b̯umbamaliraho ki̱mwei̱. ");
INSERT INTO rub_vpl VALUES ("PS18_38","020_18_38","PSA","18","38","38","Mbakuutira ki̱mwei̱ aleke batabyoka, bagwa nibalaala hansi mu magulu gange. ");
INSERT INTO rub_vpl VALUES ("PS18_39","020_18_39","PSA","18","39","39","Ompa maani ga kulwana, okuutira ki̱mwei̱ bandu̱mba noobamalaho. ");
INSERT INTO rub_vpl VALUES ("PS18_40","020_18_40","PSA","18","40","40","Oha banyanzigwa bange ku̱nzi̱ru̱ka, na bannoba mbakuuta ni̱mbazi̱kya. ");
INSERT INTO rub_vpl VALUES ("PS18_41","020_18_41","PSA","18","41","41","Beesengereerye babajune, bei̱tu̱ hatakabbeho aku̱bei̱ramwo, baateeri̱ho na kusaba Mukama abacungure, bei̱tu̱ atakabajune. ");
INSERT INTO rub_vpl VALUES ("PS18_42","020_18_42","PSA","18","42","42","Mbakuuta nimbafoora icuucu litwalwa mpehu, nimbazigazigina nka bitogodo mu muhanda. ");
INSERT INTO rub_vpl VALUES ("PS18_43","020_18_43","PSA","18","43","43","Oncu̱ngwi̱ri̱ hali bantu bandu̱mba, wanfoora mwebemberi̱ wa mahanga, bantu banteegi̱ri̱ bampeerezanga. ");
INSERT INTO rub_vpl VALUES ("PS18_44","020_18_44","PSA","18","44","44","B̯u̱baakanzegwanga baaku̱ndanga malu̱ nibantamwo ki̱ti̱i̱ni̱sa, Banyamahanga bangonderanga. ");
INSERT INTO rub_vpl VALUES ("PS18_45","020_18_45","PSA","18","45","45","Bakwatwa b̯u̱ti̱i̱ni̱, nibaruga mu bigo byab̯u nibakukankana. ");
INSERT INTO rub_vpl VALUES ("PS18_46","020_18_46","PSA","18","46","46","Mukama mwomi! Asi̱i̱mwe lubbaali lwange! Ahaariizwe Ruhanga Mu̱ju̱ni̱ wange! ");
INSERT INTO rub_vpl VALUES ("PS18_47","020_18_47","PSA","18","47","47","Yooyo Ruhanga ahoora nzi̱go hab̯wange, ampa kufuga mahanga, ");
INSERT INTO rub_vpl VALUES ("PS18_48","020_18_48","PSA","18","48","48","anjuna hali banyanzigwa bange. Kwokwo ontu̱mbwi̱ri̱ hali banyaku̱ndwani̱sya, oju̱ni̱ri̱ kuruga hali bantu beetagu̱. ");
INSERT INTO rub_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","Nahab̯waki̱kyo, ai̱ Mukama, nyaaku̱si̱i̱manga mu mahanga, nyaahi̱i̱manga nimpaariiza ibara lyamu. ");
INSERT INTO rub_vpl VALUES ("PS18_50","020_18_50","PSA","18","50","50","Ruhanga aha mukama mutongoole waamwe ku̱si̱ngu̱ra ntaru zinene, abba wa ngonzi zinene hali yo, hali Dau̱di̱, na ba mu lula lwamwe, biro na biro. ");
INSERT INTO rub_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱. Zabbu̱li̱ gya Dau̱di̱. Iguru kalitenda ki̱ti̱i̱ni̱sa kya Ruhanga! Bya mu mwanya kabi̱tebya byakora. ");
INSERT INTO rub_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","B̯uli kiro ki̱tebeerya kiro ki̱i̱ra ha ki̱ti̱i̱ni̱sa kya Ruhanga, kandi i̱jolo li̱mwei̱ lyegesya i̱jolo lindi kubba na magezi̱. ");
INSERT INTO rub_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","Tihaloho lubazu habbe lulimi, hali iraka lyab̯u li̱tadoori̱. ");
INSERT INTO rub_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","Iraka lyab̯u li̱rarangi̱ri̱ hensei̱, bigambu byab̯u bi̱doori̱ ha nsaru za nsi. Heema gya lyoba Ruhanga yaagi̱teeri̱ mwiguru, ");
INSERT INTO rub_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","nka mugole kwahuluka mu ki̱si̱i̱ka kyamwe, nka mu̱ku̱gu̱ wa mbiro akugyenda ha mpaka. ");
INSERT INTO rub_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Lyoba lihuluka mwiguru ha rubaju lu̱mwei̱ nilirabayo niligwa ha rubaju lundi. Tihaloho kitadweb̯wa kingeere kya lyo. ");
INSERT INTO rub_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","Biragiro bya Mukama biicala bi̱terekereru̱, bi̱hu̱u̱mu̱u̱lya mutima, bigambu bya Mukama bibba bya mananu, bileetera mpwi̱se magezi̱, ");
INSERT INTO rub_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","ndagiiro za Mukama zibba zirungi, zileetera mutima kusemererwa, biragiro bya Mukama byabiribiri, bimulikira mei̱so, ");
INSERT INTO rub_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","ku̱ti̱i̱na Mukama ki̱doori̱, kyakwicalaho biro na biro, micwere mya Mukama mibba mya mananu, kandi myenseenya myab̯winganiza. ");
INSERT INTO rub_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","Byakwegomba kukira na zaabbu, na kukira zaabbu gi̱sengeeje ginene, binuliira kukira na b̯uhooki na kukiraho manyondo gaab̯wo. ");
INSERT INTO rub_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Kukira maani byobyo bihab̯ura muheereza waamu, mu kubihondera halimwo mpeera ginyamaani. ");
INSERT INTO rub_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","Naani yaakusobora kwetegereza nsobi̱ za mutima gwamwe? Nganyira bibii bi̱nyaakoori̱ mub̯uteega. ");
INSERT INTO rub_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","Otandeka, gya muheereza waamu kukora bibii mbi̱gyendereeri̱. Oteikiriza nibikanfuga. B̯u̱b̯wo mwomwo ndibba ntakujunaanwa kandi ntali na musangu gunyamaani hoi̱. ");
INSERT INTO rub_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","Ikirizanga bigambu byange na biteekerezu byange, ai̱ Mukama, Lubbaali lwange kandi Mu̱cu̱ngu̱ri̱ wange. ");
INSERT INTO rub_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱. Zabbu̱li̱ gya Dau̱di̱. Mukama yei̱rangamwo kusaba kwamu mu biro bya b̯ujune! Ibara lya Ruhanga wa Yakobbo likulindenge! ");
INSERT INTO rub_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","Yaakutumiranga kujunwa kuruga mu kiikaru kyamwe ki̱syanu̱ na b̯u̱sagi̱ki̱ kuruga Sayu̱u̱ni̱. ");
INSERT INTO rub_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","Yei̱zu̱kanga bisembu byamu byensei̱ byomuhongera kandi yeikirizanga byonzira byamu byokye. ");
INSERT INTO rub_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","Yaakuhanga bya mutima gwamu gu̱byendya naakuteeraho ku̱si̱ngu̱ra mu ntegeka zaamu zensei̱. ");
INSERT INTO rub_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","B̯u̱wakasi̱ngu̱ranga twasemererwanga nitubyokya bbendera zikuhaariiza ibara lya Ruhanga weetu̱. Mukama yei̱rangamwo kusaba kwamu kwensei̱. ");
INSERT INTO rub_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","Hataati̱ nkyegi̱ri̱ nti Mukama ajuna mutongoole waamwe, ei̱ramwo kusaba kwamwe na mwiguru lyamwe li̱syanu̱, naamujuna na mukono gwamwe gwab̯udyo gwa maani. ");
INSERT INTO rub_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","Bamwei̱ beesiga ku̱lwani̱sya bigaali na bandi beesiga mbaraasi, bei̱tu̱ twe twesiga ibara lya Mukama Ruhanga weetu̱. ");
INSERT INTO rub_vpl VALUES ("PS20_8","020_20_8","PSA","20","8","8","Baagwanga nibahwerekeera, bei̱tu̱ twe twasi̱ngu̱ranga nitwemeera nituli beesi̱mbu̱. ");
INSERT INTO rub_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","Ai̱ Mukama, ikiriza mukama asi̱nge! B̯utwakakusabanga otwi̱rengemwo. ");
INSERT INTO rub_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱. Zabbu̱li̱ gya Dau̱di̱. Ai̱ Mukama, mu maani gaamu hooho mu̱lemi̱ yeegondezeeremwo kandi asi̱i̱mi̱ra ki̱mwei̱ kujunwa kwamu! ");
INSERT INTO rub_vpl VALUES ("PS21_2","020_21_2","PSA","21","2","2","Omu̱heeri̱ kya mutima gwamwe gwendya na kusaba kwamwe okwi̱ri̱ri̱mwo. ");
INSERT INTO rub_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","Omutangiira na mi̱gi̱sa minene noomutaho kondo girungi gya zaabbu ha mu̱twe. ");
INSERT INTO rub_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","Yaaku̱sabi̱ri̱ b̯womi, waab̯umuha, waataho yoomeere biro binene. ");
INSERT INTO rub_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","Hab̯wa ku̱si̱ngu̱ra kwamu, abbeeri̱ na ki̱ti̱i̱ni̱sa kinene hoi̱, omu̱heeri̱ kutumbuka na b̯u̱handu̱. ");
INSERT INTO rub_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","Mu mananu omu̱heeri̱ mi̱gi̱sa mitamalika na kusemererwa mu mei̱so gaamu. ");
INSERT INTO rub_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","Hab̯wakubba yogwo mu̱lemi̱ yeesiga Mukama, kandi ku̱si̱gi̱ki̱ra ha mbabazi̱ zinene za yogwo Waahakyendi̱ Hoi̱ talibba na kyali̱ti̱i̱na. ");
INSERT INTO rub_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","Ohamba banyanzigwa baamu bensei̱, mukono gwamu gwab̯udyo gukwata bab̯wo bakunoba. ");
INSERT INTO rub_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","Mu kwi̱za kwamu, balihya nibagegeera nka kikoomi. Mu ki̱ni̱ga kyamwe Mukama akwi̱za ku̱bazi̱kya, kandi mworo gwamwe gu̱kwi̱za ku̱basi̱dya. ");
INSERT INTO rub_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","10","Okwi̱za kumalaho mu̱gi̱ gwab̯u gwensei̱ ku nsi, na beizukulu bazi̱ki̱re ki̱mwei̱ mu bantu. ");
INSERT INTO rub_vpl VALUES ("PS21_11","020_21_11","PSA","21","11","11","Nab̯u̱baku̱zi̱di̱ri̱zanga na kukutega mitegu, tibali ku̱si̱ngu̱ra, ");
INSERT INTO rub_vpl VALUES ("PS21_12","020_21_12","PSA","21","12","12","hab̯wakubba balihinduka ni̱bei̱ru̱ka b̯woli̱kabali̱ngi̱ri̱i̱rya mbasi zaamu. ");
INSERT INTO rub_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","Ohaariizib̯wenge, ai̱ Mukama, hab̯wa maani gaamu, twaku̱hi̱i̱mi̱ranga nitutenda b̯u̱sobozi̱ b̯wamu. ");
INSERT INTO rub_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱. Ku̱hi̱i̱mi̱ra mumaliriire ga “B̯uguma gya Mparaaki ha mambya.” Zabbu̱li̱ gya Dau̱di̱. Ruhanga wange, Ruhanga wange, hab̯waki ondekereeri̱? Hab̯waki ondi hadei mwa kunjuna, hadei kwo hali kulira kwange? ");
INSERT INTO rub_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","Ai̱ Ruhanga wange, ka nnkusaba mwihangwe, bei̱tu̱ tonzi̱ramwo, nei̱jolo, bei̱tu̱ nyeezegwa ntali na b̯u̱si̱nge. ");
INSERT INTO rub_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","Bei̱tu̱ nab̯wo oicala mu̱syanu̱ mutima, oi̱cali̱i̱ri̱ mu ntebe gyamu I̱saleeri̱ nigikukutenda. ");
INSERT INTO rub_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","Weewe bahaaha beetu̱ gi̱beesi̱gengi̱, baakwesi̱gengi̱, kandi noobacungura. ");
INSERT INTO rub_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","Baakwesengereryenge kandi noobajuna, weewe gi̱beesi̱gengi̱ batakuswara. ");
INSERT INTO rub_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","Nagya ndi muntu kyani? Ndi nka muniongooro! Gyagya alu̱mwa b̯uli muntu kandi agaywa bantu bensei̱. ");
INSERT INTO rub_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","Bantu bensei̱ bambona, bansekereerya b̯u̱sekereerya, banuga b̯u̱nu̱gi̱, ni̱bazi̱gi̱i̱zya mi̱twe myab̯u nibakoba yati, ");
INSERT INTO rub_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","“Yeesiga Mukama, kale nu Mukama ei̱ze amucungure, ei̱ze amujune, hab̯wakubba yooyo giyeegondezeeramwo.” ");
INSERT INTO rub_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","B̯u̱b̯wo nu wantoori̱ mu nda gya mmaama, wandinda na heibiiri lya mmaama. ");
INSERT INTO rub_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","Nyeesiga weewe kuruga nimbyalwa, kuruga ninduga mu nda gya mmaama weewe oli Ruhanga wange. ");
INSERT INTO rub_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","Otandugaho, hab̯wakubba hali̱yo b̯ujune b̯u̱kwi̱za, kandi tihalohoona alib̯unjuna. ");
INSERT INTO rub_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Banyanzigwa bange banene banyeelogoleerye, nka nnumi zinyamaani za Bbasaani̱ bangoti̱ri̱ hensei̱, ");
INSERT INTO rub_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","bab̯u̱u̱li̱ri̱ mi̱nwa, nka ntali zikuruutaruuta kandi zikuhuruguma. ");
INSERT INTO rub_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Nnekaneki̱ri̱ nkaaku̱u̱ti̱rwe, na maku̱ha gange gateesu̱ki̱ri̱, mutima gwange nka bisasala, nkwegwa nigukwaga mu salaka, ");
INSERT INTO rub_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","mimiro myange myomi̱ri̱ nka lutaana, kandi lulimi lwange lwomi̱ri̱ mu b̯unkudankuda, ondeki̱ri̱ nkwere mu cuucu. ");
INSERT INTO rub_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","Kubba kitebe kya nkori̱ za bibii ki̱ngoti̱ri̱, nka mbwene zi̱nyeelogoleerye, bantu̱u̱ti̱ri̱ magulu na ngalu. ");
INSERT INTO rub_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","Maku̱ha gange gensei̱ gakwebala, bakumbona nibeeb̯uga. ");
INSERT INTO rub_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","Babageeni̱ bilwalu byange na ngoye zange bazikuutira karu̱ru̱. ");
INSERT INTO rub_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","Bei̱tu̱ we, ai̱ Mukama, otandugahoona! Ai̱ weewe onjuna, i̱za b̯wangu onjune! ");
INSERT INTO rub_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","Njuna hali mpirima, ocungure b̯womi b̯wange hali maani ga zi̱zo mbwene! ");
INSERT INTO rub_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","Njuna ontoole mu mu̱nwa gwa ntali! Kwokwo onsi̱ki̱ri̱ kuruga mu mahembe ga mpeta! ");
INSERT INTO rub_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","Nyaaweeranga bei̱ra bange byeibara lyamu, nyaakuhaariizanga mu bab̯wo beecooki̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","Nywe batamwo Mukama ki̱ti̱i̱ni̱sa, mu̱mu̱haari̱i̱ze! Nywe baana bensei̱ ba Yakobbo mu̱mu̱tende, mu̱mu̱ti̱i̱ne, baana Bei̱saleeri̱ nywensei̱! ");
INSERT INTO rub_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","Hab̯wakubba Mukama tagaya kandi tanuga b̯ujune b̯wa yogwo akuwonawona, kandi tamuhemukira, bei̱tu̱ ei̱ramwona kusaba kwamwe. ");
INSERT INTO rub_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","Nyaakuhaariizanga Mukama, mu kitebe kya banene, mu mei̱so ga bab̯wo baku̱ti̱i̱na nyaadoosereeryanga kwehayo kwange. ");
INSERT INTO rub_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","Banaku baadyanga nibeicuta, bab̯wo bamu̱toolya baahaariizanga Mukama! Mitima myenyu̱ myasemererwanga biro na biro. ");
INSERT INTO rub_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","Bantu ba nsonda zensei̱ za nsi bei̱zu̱kanga nibahondera Mukama, na maka gensei̱ mu mahanga gaali̱i̱za mu mei̱so gaamu ku̱ramya. ");
INSERT INTO rub_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","Hab̯wakubba Mukama yooyo alema, kandi yooyo afuga mahanga gensei̱. ");
INSERT INTO rub_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","Bagu̱u̱da bensei̱ ba mu nsi badyenge kandi baramyenge Mukama, bensei̱ ba hansi baliinama, bensei̱ batakusobora kwejuna ku̱kwa mmaliiro gyab̯u gilibba nka cuucu. ");
INSERT INTO rub_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","Baana balikabyalwa balimuheereza, baliguweera mu̱hi̱hi̱ gwa mei̱so bya Mukama. ");
INSERT INTO rub_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","Mananu gaamwe bali̱gatebereerya bab̯wo batakabyali̱i̱rwe, nti “Mukama yooyo yaaju̱ni̱ri̱ bantu baamwe.” ");
INSERT INTO rub_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Zabbu̱li̱ gya Dau̱di̱. Mukama yooyo mu̱li̱i̱sya wange, tindiseega. ");
INSERT INTO rub_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Antwala mwi̱li̱si̱i̱ryo lirungi, anyeebembera ha meezi̱ gateeku̱. ");
INSERT INTO rub_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Ampu̱mu̱u̱lya mutima, anterekereerya mu mihanda mya mananu, hab̯wa ki̱ti̱i̱ni̱sa kyeibara lyamwe. ");
INSERT INTO rub_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Nab̯undiraba mu kihanga kya lu̱ku̱u̱, ti̱ndi̱ti̱i̱na kabii kensei̱, hab̯wakubba oli hamwei̱ nagya, mubbeere gwamu na mpalu gyamu, byobyo bi̱mpu̱mu̱u̱lya. ");
INSERT INTO rub_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Onsegeerya kiihuru mu mei̱so ga banyanzigwa bange, onsi̱i̱ga maku̱ta ku mu̱twe, ki̱kopo kyange tikikalemwanga kyakunywa. ");
INSERT INTO rub_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Mu mananu b̯urungi na mbabazi̱ zaamu byamponderanga biro byange byensei̱, kandi nyeicalanga mu nnyu̱mba gya Mukama biro na biro. ");
INSERT INTO rub_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","Zabbu̱li̱ gya Dau̱di̱. Nsi na bilimwo byensei̱ bya Mukama, nsi na bantu bensei̱ bagicalamwo byamwe, ");
INSERT INTO rub_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","hab̯wakubba yaagi̱teeri̱ ku meezi̱ yaagi̱bi̱mba ha mi̱si̱nge mya mataka gakooto. ");
INSERT INTO rub_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","Naani alitemba hakyendi̱ ku lusahu lwa Mukama? Kandi naani alyemeera mu kiikaru kyamwe ki̱syanu̱? ");
INSERT INTO rub_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","Yooyo yogwo ali na ngalu zi̱syanu̱ na mutima gu̱syanu̱, wa mutima gutalimwo b̯u̱gobya kandi atarahira bitalimwo. ");
INSERT INTO rub_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","Yooyo wa Mukama aliha mu̱gi̱sa kandi atalijunaanwa Ruhanga Mu̱ju̱ni̱ waamwe. ");
INSERT INTO rub_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","Kwokwo balibba ba mu̱hi̱hi̱ gu̱gwo bamu̱toolya, bendya kuwona ku Ruhanga wa Yakobbo. ");
INSERT INTO rub_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","Nywe malembo, mu̱ki̱ngu̱ke! Kandi nywe nzi̱je za kadei i̱ju̱lu̱ke, aleke mukama wa ki̱ti̱i̱ni̱sa eingire. ");
INSERT INTO rub_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","Naani yogo ali mukama wa ki̱ti̱i̱ni̱sa? Yooyo Mukama ali na maani na b̯u̱sobozi̱, Mukama wa b̯u̱sobozi̱ mu kulwana ntaru. ");
INSERT INTO rub_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","Nywe malembo, mu̱ki̱ngu̱ke! Kandi nywe nzi̱je za kadei i̱ju̱lu̱ke, aleke mukama wa ki̱ti̱i̱ni̱sa eingire. ");
INSERT INTO rub_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","Mukama wa ki̱ti̱i̱ni̱sa yogwo yooyo naani? Mukama wa mahe, yooyo Mukama wa ki̱ti̱i̱ni̱sa. ");
INSERT INTO rub_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","1","Zabbu̱li̱ gya Dau̱di̱. Hali weewe, Ai̱ Mukama, nku̱hayo mutima gwange. ");
INSERT INTO rub_vpl VALUES ("PS25_2","020_25_2","PSA","25","2","2","Ai̱ Ruhanga wange, weewe ginyeesiga, otandekanga kubba kyamuswaru, oteikiriza banyanzigwa bange kunyeeb̯ugiraho. ");
INSERT INTO rub_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","Mu mananu tihaloho akwesiga alikwatwa nsoni̱, bei̱tu̱ baliswara bab̯wo bendya kukora bibiibi. ");
INSERT INTO rub_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","Ai̱ Mukama, ndagiira makuute gaamu, onzegesya kwetegereza mihanda myamu. ");
INSERT INTO rub_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","Nzegesye, onyeetegeresesye mananu gaamu, hab̯wakubba weewe Ruhanga anjuna, weewe ginyeesiga biro byensei̱. ");
INSERT INTO rub_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","6","Ai̱ Mukama, i̱zu̱ka kisa kyamu na ngonzi zaamu zinene, hab̯wakubba za biro bya kadei. ");
INSERT INTO rub_vpl VALUES ("PS25_7","020_25_7","PSA","25","7","7","B̯webeera bibii bya b̯usigazi b̯wange na ngesu zange za b̯u̱jeemu̱, onzi̱zu̱kenge, ai̱ Mukama, hab̯wa ngonzi zaamu zinene na b̯urungi b̯wamu! ");
INSERT INTO rub_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","Mukama murungi kandi wa mananu, kyokyo yeebembera babiibi mu muhanda gwamwe. ");
INSERT INTO rub_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","Aterekereerya bakweb̯undaza mu kukora birungi, naabeegesya kuhondera mihanda myamwe. ");
INSERT INTO rub_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","Mihanda myensei̱ mya Mukama mibbamwona ngonzi zinene na mananu, hali bab̯wo bahondere ndagaanu gyamwe na bigambu byamwe. ");
INSERT INTO rub_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","Ai̱ Mukama, ku̱si̱gi̱ki̱ra heibara lyamu, nganyira bibii byange, hab̯wakubba binene. ");
INSERT INTO rub_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","Yogwo atamwona Mukama ki̱ti̱i̱ni̱sa yo alahi yo? Yooyo wa Mukama giyaahab̯uranga muhanda gwakuhondera. ");
INSERT INTO rub_vpl VALUES ("PS25_13","020_25_13","PSA","25","13","13","Yooyo wa mwozo gwamwe guliicala mu b̯u̱si̱nge, kandi baana baamwe baligweterwa nsi. ");
INSERT INTO rub_vpl VALUES ("PS25_14","020_25_14","PSA","25","14","14","Mukama anywana bab̯wo bamutamwo ki̱ti̱i̱ni̱sa, kandi abaha kwega bya mu ndagaanu gyamwe. ");
INSERT INTO rub_vpl VALUES ("PS25_15","020_25_15","PSA","25","15","15","Mei̱so gange geicalanga hali Mukama, hab̯wakubba anjuna ku̱gwa mu mutegu. ");
INSERT INTO rub_vpl VALUES ("PS25_16","020_25_16","PSA","25","16","16","Nnzi̱raho, ai̱ Mukama, ongiire mbabazi̱, hab̯wakubba ndi mu b̯u̱ru̱mi̱ kandi ndi hahwo nyankei. ");
INSERT INTO rub_vpl VALUES ("PS25_17","020_25_17","PSA","25","17","17","Bizib̯u byange bi̱kanyi̱ri̱, njuna bi̱byo bintuntwi̱ze mutima. ");
INSERT INTO rub_vpl VALUES ("PS25_18","020_25_18","PSA","25","18","18","Taho mutima ku b̯u̱ru̱mi̱ b̯wange na bizib̯u byange, onganyire bibii byange byensei̱. ");
INSERT INTO rub_vpl VALUES ("PS25_19","020_25_19","PSA","25","19","19","Wona banyanzigwa bange nka kubali banene, kandi nka ku̱bannobi̱ri̱ hoi̱. ");
INSERT INTO rub_vpl VALUES ("PS25_20","020_25_20","PSA","25","20","20","Ndinda kandi oncungure, otampa kuswara, hab̯wakubba nyeesiga weewe. ");
INSERT INTO rub_vpl VALUES ("PS25_21","020_25_21","PSA","25","21","21","Leka b̯urungi na mananu bindindenge, hab̯wakubba nyeesiga weewe. ");
INSERT INTO rub_vpl VALUES ("PS25_22","020_25_22","PSA","25","22","22","Ai̱ Ruhanga, cungura I̱saleeri̱ hali bizib̯u byamwe byensei̱! ");
INSERT INTO rub_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","Zabbu̱li̱ gya Dau̱di̱. Ai̱ Mukama, ntonganiira, hab̯wakubba nkora bi̱doori̱, nnyeesiga Mukama, ntali na bicwocwo. ");
INSERT INTO rub_vpl VALUES ("PS26_2","020_26_2","PSA","26","2","2","Ai̱ Mukama, mbona, ondenge, ogezesye mutima na biteekerezu byange. ");
INSERT INTO rub_vpl VALUES ("PS26_3","020_26_3","PSA","26","3","3","Hab̯wakubba ngonzi zaamu zinene ziicala na gya, kandi ndibatira mu b̯wesigwa b̯wamu. ");
INSERT INTO rub_vpl VALUES ("PS26_4","020_26_4","PSA","26","4","4","Ncaara kwahi na bantu ba nkwe, rundi kukoragana na ngobya. ");
INSERT INTO rub_vpl VALUES ("PS26_5","020_26_5","PSA","26","5","5","Nnoba byecooka bya nkori̱ za bibii, kandi tindicaara na babiibi. ");
INSERT INTO rub_vpl VALUES ("PS26_6","020_26_6","PSA","26","6","6","Ai̱ Mukama, nnaaba ngalu zange kwolokya kuntali na musangu, kandi ndami̱i̱rya heihongo lyamu, ");
INSERT INTO rub_vpl VALUES ("PS26_7","020_26_7","PSA","26","7","7","mpi̱i̱ma na maani kyembu kyaku̱ku̱si̱i̱ma, ninyaatula byamahanu byokoori̱. ");
INSERT INTO rub_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","Ai̱ Mukama, nyeegomba nnyu̱mba gyoicalamu, cali ki̱ti̱i̱ni̱sa kyamu kiicalira. ");
INSERT INTO rub_vpl VALUES ("PS26_9","020_26_9","PSA","26","9","9","Otampwerekereerya na babiibi, b̯womi b̯wange okab̯utwalirana na badulu bali na nnyoota gyeibbanga, ");
INSERT INTO rub_vpl VALUES ("PS26_10","020_26_10","PSA","26","10","10","bantu beicala nibakora bibii kandi bakwata bya ngu̱zi̱. ");
INSERT INTO rub_vpl VALUES ("PS26_11","020_26_11","PSA","26","11","11","Bei̱tu̱ gya, nnkora bi̱nyeegi̱ri̱ kubba birungi, oncungure kandi onkwatirwa kisa. ");
INSERT INTO rub_vpl VALUES ("PS26_12","020_26_12","PSA","26","12","12","Magulu gange gemereeri̱ heetendeku̱, mu kitebe kya bantu baamu nyaahaariizanga Mukama. ");
INSERT INTO rub_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","Zabbu̱li̱ gya Dau̱di̱. Mukama yooyo kyererezi̱ na kujunwa kwange, naani yogwo gi̱ndi̱ti̱i̱na? Mukama yooyo maani ga b̯womi b̯wange, naani ali̱nkankani̱a? ");
INSERT INTO rub_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Babiibi b̯u̱bali̱ndu̱mba, kuntaagura, banyanzigwa bange na bannoba, balikibbala nibagwa. ");
INSERT INTO rub_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Kadi i̱he b̯ulilingota, mutima gwange ti̱gu̱li̱ti̱i̱na, kadi b̯ulibba b̯wemi̱, nab̯wo ndibba mutatiro. ");
INSERT INTO rub_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Kintu ki̱mwei̱ kinsaba Mukama, kinyaatoolyanga, ncaare mu nnyu̱mba gya Mukama, biro bya b̯womi b̯wange b̯wensei̱, mbone b̯urungi b̯wamwe, mpumulire mu Yeekaru nnyu̱mba gyamwe. ");
INSERT INTO rub_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Mu biro bya b̯ujune, alimbumba na mu̱tu̱ntu̱lu̱ gwa heema gyamwe, ali̱mbi̱sa mu heema gyamwe, kandi antembye ha lubbaali. ");
INSERT INTO rub_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Mwomwo ndyeb̯ugira banyanzigwa bangoti̱ri̱, kandi mu heema gyamwe nyaahongangamwo kihongwa na kusemererwa kunene, nkwi̱za ku̱hi̱i̱ma nimpaariiza Mukama. ");
INSERT INTO rub_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","Nzegwa, ai̱ Mukama b̯unkukunga na maani, Mmbeera wa kisa, onzi̱remwo. ");
INSERT INTO rub_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Okobi̱ri̱ yati, “Toolya mei̱so gange.” Mutima gwange gukuteekereza yati, “Mei̱so gaamu, Mukama, googo nyatoolyanga.” ");
INSERT INTO rub_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Otambumbira mei̱so gaamu, otabinga muheereza waamu hab̯wa ki̱ni̱ga, oi̱ceeri̱ nonjuna. Otansuula, otandekeera, Ruhanga Mu̱ju̱ni̱ wange. ");
INSERT INTO rub_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Bbaabba na mmaama nab̯ubakabbanga bandeki̱ri̱, Mukama akwi̱za kuntangiira. ");
INSERT INTO rub_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","Ai̱ Mukama, Nzegesya mihanda myamu, ai̱ Mukama, ondi̱batyenge nterekereeri̱ hab̯wa bampi̱gani̱a. ");
INSERT INTO rub_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Otaleka banyanzigwa bange kunkora ku̱bakwendya, kubba bakei̱so ba b̯u̱gobya bambyokeeri̱, bali na b̯wemi̱ b̯unene. ");
INSERT INTO rub_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","Nkwikiriza nti nkwi̱za kuwona b̯urungi b̯wa Mukama mu nsi gya boomi. ");
INSERT INTO rub_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Lindiira Mukama, bba wa maani otatiire, olindiire Mukama. ");
INSERT INTO rub_vpl VALUES ("PS28_1","020_28_1","PSA","28","1","1","Zabbu̱li̱ gya Dau̱di̱. Ai̱ Mukama, weewe ginkunga, lubbaali lwange nzengwa! Waketeekeera, nkubba nka bab̯wo bagwi̱ri̱ mu b̯u̱hya. ");
INSERT INTO rub_vpl VALUES ("PS28_2","020_28_2","PSA","28","2","2","Weegwa, nkukusaba na mbabazi̱, nkukweta onjune, mbyokeerye mikono myange mu Kiikaru kyamu ki̱syanu̱. ");
INSERT INTO rub_vpl VALUES ("PS28_3","020_28_3","PSA","28","3","3","Otancwera musangu hamwei̱ na babiibi, na nkori̱ za bibii, babaza kurungi na bataahi̱ baab̯u bei̱tu̱ mu mitima myab̯u nibabatekerezaho b̯ubiibi. ");
INSERT INTO rub_vpl VALUES ("PS28_4","020_28_4","PSA","28","4","4","Bahe mpeera gya bikorwa byab̯u, obahe na mpeera gya bibii byab̯u, obahe bya mikono myab̯u mi̱koori̱ obasasule bi̱basemereeri̱. ");
INSERT INTO rub_vpl VALUES ("PS28_5","020_28_5","PSA","28","5","5","Hab̯wakubba tibatamwo ki̱ti̱i̱ni̱sa milimo mya Mukama na bya mikono myamwe mi̱koori̱, akwi̱za kubaswaswana, kandi abamalireho ki̱mwei̱. ");
INSERT INTO rub_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","Mukama ahaariizwe, kubba yeegwa kusaba kwange kwa mbabazi̱. ");
INSERT INTO rub_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","Mukama googo maani na ngab̯u gyange, mutima gwange gwesiga yooyo, kandi anju̱ni̱ri̱, mutima gwange gu̱semereerwe, nkwi̱za ku̱mu̱si̱i̱ma kandi mu̱hi̱i̱mi̱re kyembu. ");
INSERT INTO rub_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","Mukama yooyo maani ga bantu baamwe, b̯wi̱ru̱ki̱ro b̯wa kujuna mutongoole waamwe. ");
INSERT INTO rub_vpl VALUES ("PS28_9","020_28_9","PSA","28","9","9","Ai̱ Mukama, juna bantu baamu kandi obahe mu̱gi̱sa, bba mu̱li̱i̱sya waab̯u obawoneere biro byensei̱. ");
INSERT INTO rub_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","Zabbu̱li̱ gya Dau̱di̱. Mu̱haari̱i̱ze Mukama bihangwa bili mwiguru, mu̱haari̱i̱ze Mukama hab̯wa ki̱ti̱i̱ni̱sa na b̯u̱sobozi̱ b̯wamwe. ");
INSERT INTO rub_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","Mu̱haari̱i̱ze ibara lya Mukama lya ki̱ti̱i̱ni̱sa, mu̱ramye Mukama mu kiikaru kyamwe ki̱syanu̱. ");
INSERT INTO rub_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","Iraka lya Mukama likwatukira mwitaka, Ruhanga wa ki̱ti̱i̱ni̱sa abbwatu̱ki̱ri̱, Mukama, yooyo afuga mataka ganene. ");
INSERT INTO rub_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","Iraka lya Mukama lya maani, iraka lya Mukama lya ki̱ti̱i̱ni̱sa kinene. ");
INSERT INTO rub_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","Iraka lya Mukama, libinya mi̱poi̱, Mukama abinya misaali mya Lebbanooni̱. ");
INSERT INTO rub_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","Aragira nsahu za Lebbanooni̱ ni̱zi̱gu̱su̱ka nka kusemererwa kwa nnyana na lusahu lwa Si̱ryoni̱ ku̱gu̱su̱ka nka nnumi gito. ");
INSERT INTO rub_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","7","Iraka lya Mukama li̱hu̱lu̱kya mworo. ");
INSERT INTO rub_vpl VALUES ("PS29_8","020_29_8","PSA","29","8","8","Iraka lya, Mukama li̱zi̱ngi̱i̱zya ihamba, Mukama azi̱ngi̱i̱zya nsi gya ihamba lya Kadesi̱. ");
INSERT INTO rub_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","Iraka lya Mukama li̱byali̱sya bbwoya, li̱halangu̱li̱i̱rya bibira, kandi mu Yeekaaru̱ gyamwe bintu byensei̱ bilira yati, “Ki̱ti̱i̱ni̱sa kibbe hali Mukama!” ");
INSERT INTO rub_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","Mukama eicaara ha kitebe kyamwe hakyendi̱ kulema meezi̱ ga mwizulo, Mukama ei̱cali̱i̱ri̱ ha kitebe kyamwe kulema biro na biro. ");
INSERT INTO rub_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","Mukama yaahanga bantu baamwe maani, Mukama yaabahanga mu̱gi̱sa na b̯u̱si̱nge! ");
INSERT INTO rub_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","Zabbu̱li̱ gya Dau̱di̱. Kyembu kya kuhemba Yeekaru. Ai̱ Mukama, nkwi̱za kukuhaariiza kubba wantoori̱ mu ki̱i̱na kilei, otakeikirize banyanzigwa bange kunyeeb̯ugiraho. ");
INSERT INTO rub_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","Ai̱ Mukama Ruhanga wange, nyaaku̱li̱ri̱i̱ri̱ onjune kandi wamponeerye. ");
INSERT INTO rub_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","Ai̱ Mukama, wantoori̱ kuzumu, wanjuna ku̱gwa mu ki̱i̱na. ");
INSERT INTO rub_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","Mu̱hi̱i̱mi̱re Mukama nywe bantu ba Ruhanga, mu̱si̱i̱me ibara lyamwe li̱syanu̱. ");
INSERT INTO rub_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","Kubba akwatwa ki̱ni̱ga hab̯wa b̯wi̱re b̯u̱dooli̱, kisa kyamwe kiicalaho biro byensei̱, kulira b̯u̱kwi̱za i̱jolo, mwakya ni̱hei̱zaho kusemererwa. ");
INSERT INTO rub_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","B̯u̱nyeezegwi̱ri̱ nindi na b̯u̱li̱ndi̱, nyaakoba yati, “Ti̱nkwi̱za kutengeeta.” ");
INSERT INTO rub_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","7","Ai̱ Mukama, hab̯wa kisa kyamu, wantati̱i̱rye nka lusahu lunyamaani, hei̱nyu̱ma weebi̱sa, nyaatuntura. ");
INSERT INTO rub_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","Weewe Mukama, gi̱nyaali̱ri̱ri̱i̱ri̱, kandi hali Mukama nyaasabi̱ri̱ kisa, ");
INSERT INTO rub_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","“Kyamugasu ki b̯u̱ndi̱kakwa nkagyenda kuzumu? Icuucu lyakusobora kukuhaariiza? Lyakusobora kurangiira b̯wesigwa b̯wamu? ");
INSERT INTO rub_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","Ai̱ Mukama, weegwa kandi ongiire kisa! Ai̱ Mukama, bbanga Mu̱ju̱ni̱ wange!” ");
INSERT INTO rub_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","Kizabiro kyange waaki̱fori̱ri̱ mbi̱nya, wankusula bisensede, wandwalya kusemererwa, ");
INSERT INTO rub_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","aleke mutima gwange gukuhaariizenge, gu̱talyeti̱keera, ai̱ Mukama Ruhanga wange, nyaku̱si̱i̱manga biro byensei̱. ");
INSERT INTO rub_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱. Zabbu̱li̱ gya Dau̱di̱. Ai̱ Mukama mu weewe, hooho nzi̱ru̱ki̱i̱ri̱, otandeka nkaswara, onjune hab̯wa mananu gaamu. ");
INSERT INTO rub_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","Ntegera mapokopo gaamu, onjune b̯wangu! Mbeera lubbaali lwa kwebi̱si̱ramwo, obbe lugo lunyamaani lwa kunjuna. ");
INSERT INTO rub_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","Bba lubbaali lwange kandi lugo lwange, kandi hab̯wa ibara lyamu onyeebembera nonterekereerya. ");
INSERT INTO rub_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","Nzahuura mitegu mi̱bantegi̱ri̱, kubba weewe b̯wi̱ru̱ki̱ro b̯wange. ");
INSERT INTO rub_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","Mwozo gwange ngu̱teeri̱ mu ngalu gyamu, ai̱ Mukama, Ruhanga mwesigwa, oncu̱ngwi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","Nnoba baramya bi̱si̱sani̱ bitali na mugasu, bei̱tu̱ nyeesiga Mukama. ");
INSERT INTO rub_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","Nkwi̱za kusemererwa kandi nyeesi̱i̱mi̱re mu ngonzi zaamu zinene, hab̯wakubba oweeni̱ kuwonawona kwange, weeteegereza b̯u̱ru̱mi̱ b̯wa mutima gwange. ");
INSERT INTO rub_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","Ompeeri̱yo kwahi mu mikono mya banyanzigwa bange, bei̱tu̱ oteeri̱ magulu gange mu kiikaru kigali. ");
INSERT INTO rub_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","9","Ai̱ Mukama, nkwatira kisa, hab̯wakubba ndi mu b̯u̱ru̱mi̱ b̯unene, mei̱so gange gampohi̱ri̱ hab̯wa b̯ujune, mutima gwange na mubiri gwange bili na b̯u̱ru̱mi̱. ");
INSERT INTO rub_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","10","B̯womi b̯wange b̯wicala mu b̯ujune, myaka myange mya kuwonawona, maani gammali̱ki̱i̱ri̱ hab̯wa kibii kyange, na maku̱ha gange gaceki̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","Mbeeri̱ kya kugaywa hali bataahi̱ bange, hab̯wa banyanzigwa bange bensei̱, hali banywani bange nyaabba kihemu, bambona mu ngu̱u̱do banzi̱ru̱ka b̯wi̱ru̱ki̱. ");
INSERT INTO rub_vpl VALUES ("PS31_12","020_31_12","PSA","31","12","12","Banzebereeri̱ nka muntu nyaakwi̱ri̱, ndi nka lutaana. ");
INSERT INTO rub_vpl VALUES ("PS31_13","020_31_13","PSA","31","13","13","Nkwegwa banene bakumpangiira, nihaloho ntaru b̯uli nsonda, zi̱bategeki̱ri̱ kunkoraho na rukwe lwa ku̱nzi̱ta. ");
INSERT INTO rub_vpl VALUES ("PS31_14","020_31_14","PSA","31","14","14","Bei̱tu̱ gya nkwesi̱gi̱ri̱ ai̱ Mukama, ndimu kukoba, “Weewe Ruhanga wange.” ");
INSERT INTO rub_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","15","B̯womi wange b̯uli mu mikono myamu, njuna banyanzigwa bange na bab̯wo baku̱mpi̱i̱ga. ");
INSERT INTO rub_vpl VALUES ("PS31_16","020_31_16","PSA","31","16","16","Ngiira kisa gya muheereza waamu, onjune hab̯wa ngonzi zaamu zinene! ");
INSERT INTO rub_vpl VALUES ("PS31_17","020_31_17","PSA","31","17","17","Ai̱ Mukama, otandeka nkaswara, kubba nkukunga weewe, leka babiibi boobo basware, bagoromoke kuzumu mu nsita. ");
INSERT INTO rub_vpl VALUES ("PS31_18","020_31_18","PSA","31","18","18","Leka mi̱nwa mi̱gobya mijale, mikabaza b̯ubiibi hali bamananu, mu̱kwetembya na nkwe. ");
INSERT INTO rub_vpl VALUES ("PS31_19","020_31_19","PSA","31","19","19","Ee, b̯urungi b̯wamu ka b̯unene, b̯wobi̱ki̱i̱ri̱ baku̱ti̱i̱na, kandi bei̱ru̱ki̱ra muli we, baana ba bantu bakyegi̱ri̱ nka kwolinda bab̯wo bakwesiga! ");
INSERT INTO rub_vpl VALUES ("PS31_20","020_31_20","PSA","31","20","20","Weewe mu̱tu̱ntu̱lu̱ gu̱babi̱sa, baataru̱mbwa nkwe za bantu noobeecaalya mu nnyu̱mba gyamu aleke bataterana na ba ngambu. ");
INSERT INTO rub_vpl VALUES ("PS31_21","020_31_21","PSA","31","21","21","Mukama ahaariizwe hab̯wakubba yanzolokeerye mu ngonzi zaamwe zinene bya mahanu b̯u̱nyaaru̱mbi̱i̱rwe mu rub̯uga. ");
INSERT INTO rub_vpl VALUES ("PS31_22","020_31_22","PSA","31","22","22","Nyaaku̱u̱ti̱ri̱ nduulu nyakoba yati, “Ndi hadei nawe ndu̱gi̱ri̱ mu̱mei̱so gaamu.” Bei̱tu̱ weegweri̱ iraka lya kutaaga kwange kwa kisa, b̯u̱nyaku̱li̱ri̱i̱ri̱ ni̱nkwendya onjune. ");
INSERT INTO rub_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","Mwendye Mukama, nywensei̱ bantu baamwe! Mukama alinda beesigwa, bei̱tu̱ naahoora bab̯wo beetembya. ");
INSERT INTO rub_vpl VALUES ("PS31_24","020_31_24","PSA","31","24","24","Mu̱bbe bamaani, mu̱tati̱i̱re mitima, nywensei̱ bali̱ndi̱ri̱i̱ri̱ Mukama! ");
INSERT INTO rub_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","Masikili gya Dau̱di̱. Ali na mu̱gi̱sa aganyirwa nsobi̱ zaamwe, wa Ruhanga asu̱swi̱ri̱ bibii byamwe. ");
INSERT INTO rub_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Ali na mu̱gi̱sa yogwo wa Mukama atajunaana kibii, wa mwozo gwamwe gutali na b̯u̱gobya. ");
INSERT INTO rub_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Kubba b̯u̱nyaswi̱ri̱ kwatula bibii byange, mubiri gwange gwensei̱ gwamali̱ki̱ri̱mwo maani, hab̯wa kwicala nindira kiro kyensei̱. ");
INSERT INTO rub_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","Wanfu̱bi̱renge i̱jolo na mwinsi, maani gammali̱ki̱ri̱i̱ri̱ nka lu̱me lwomi̱ri̱ na kyanda. ");
INSERT INTO rub_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Nyaaku̱wereeri̱ kibii kyange, ntakaku̱bi̱se b̯ubiibi b̯wange, nyaakoba nti, “Nkwatu̱li̱i̱ri̱ nsobi̱ zange, Mukama,” kandi wanganyira musangu gwa kibii kyange. ");
INSERT INTO rub_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Nahab̯waki̱kyo b̯uli ali na b̯waruhanga, akusabenge nookyakazooka, mananu nab̯uhalibbaho mwizulo gunene, tigulimudwereera. ");
INSERT INTO rub_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Kubba weewe b̯webi̱si̱ro b̯wange, ondinda mu bizub̯u, nonyelogoolya na byembu bya b̯u̱si̱ngu̱zi̱. ");
INSERT INTO rub_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","Nkwi̱za kukuragiira na kukwegesya mu̱li̱ngo gwokusemeera kwicaliramwo, nkulambe kandi nkuwoneere. ");
INSERT INTO rub_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Otabba nka mbaraasi rundi ndogoyi̱, tibibba na kwetegereza, zivugwa zi̱bboheerwe byoma na miguha ku mi̱nwa kitali ki̱kyo tizisobora kuhondera kuragira kwamu. ");
INSERT INTO rub_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Babiibi bali na kuwonawona hoi̱, bei̱tu̱ bab̯wo beesiga Mukama, abalinda na ngonzi zinene. ");
INSERT INTO rub_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","Nahab̯waki̱kyo mwegonze mu Mukama kandi mu̱semererwe, nywe bamananu! Toke na kusemererwa nywensei̱ ba mitima mi̱syanu̱. ");
INSERT INTO rub_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","Mu̱hi̱i̱mi̱re Mukama mu̱semererwe, nywe bamananu! Bantu barungi basemereeri̱ kumuhaariiza. ");
INSERT INTO rub_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","Mu̱si̱i̱me Mukama na ndi̱ngi̱di̱, mu̱mu̱hi̱i̱mi̱re byembu na ki̱dongo kya mahu̱u̱zi̱ i̱ku̱mi̱! ");
INSERT INTO rub_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","Mu̱mu̱hi̱i̱mi̱re kyembu kihyaka, ku̱u̱te ki̱dongo nab̯wegyendereza, ki̱hu̱lu̱kye iraka likooto. ");
INSERT INTO rub_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","Kubba kigambu kya Mukama kiicala kyamananu, kandi na milimo myamwe myensei̱ mikorwa mu b̯wesigwa. ");
INSERT INTO rub_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","Yeegomba mananu na b̯winganiza, nsi gi̱i̱zwi̱ri̱ ngonzi za Mukama zinene. ");
INSERT INTO rub_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","Iguru yaali̱hangi̱ri̱ na kigambu kyamwe, rwoya lwamwe lwahanga byenseenya bilimwo ");
INSERT INTO rub_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","Yooyo acooka meezi̱ ga mwitaka nka mutuumo, ga mu ndi̱ha nagabikira mu bideeru. ");
INSERT INTO rub_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","8","Nsi gyensei̱ gi̱ti̱i̱nenge Mukama, bantu bensei̱ ba mu nsi bamutemwo ki̱ti̱i̱ni̱sa. ");
INSERT INTO rub_vpl VALUES ("PS33_9","020_33_9","PSA","33","9","9","Kubba yaabazi̱ri̱, kandi kwokwo kyabba, yaaragi̱i̱ri̱ kyemeera kiterekereeri̱. ");
INSERT INTO rub_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","Mukama amalaho rukwe lwa mahanga, alemesya bigyendeerwa bya bantu. ");
INSERT INTO rub_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","Bei̱tu̱ ntegeka za Mukama zemeeraho biro byensei̱, bigyendeerwa bya mutima gwamwe nibidwereera mi̱hi̱hi̱ myensei̱. ");
INSERT INTO rub_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","Lili na mu̱gi̱sa ihanga lya Mukama Ruhanga afuga, na bantu bayaakomi̱ri̱ nka b̯ugwetwa b̯wamwe. ");
INSERT INTO rub_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","13","Mukama eicala mwiguru naawona hansi, alingiira bantu bensei̱, ");
INSERT INTO rub_vpl VALUES ("PS33_14","020_33_14","PSA","33","14","14","ei̱cali̱i̱ri̱ ha kitebe kya b̯u̱lemi̱ b̯wamwe, awona bensei̱ beicala ha nsi, ");
INSERT INTO rub_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","yogwo ahanga mitima mya bensei̱, kandi ali̱ngani̱a byensei̱ bibakora. ");
INSERT INTO rub_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","16","Tihaloho mukama ajunwa b̯unene wei̱he lyamwe, na mu̱lwani̱ akusobora kukena hab̯wa maani gaamwe. ");
INSERT INTO rub_vpl VALUES ("PS33_17","020_33_17","PSA","33","17","17","Mbaraasi gya b̯ulemu tigisobora kuleeta ku̱ni̱hi̱ra kwa b̯u̱si̱ngu̱zi̱, kandi de tigikusobora kujuna hab̯wa maani gaagyo gadi̱ ganene. ");
INSERT INTO rub_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","Bei̱tu̱ mei̱so ga Mukama geicala hali bab̯wo bamu̱ti̱i̱na, hali bab̯wo bani̱hi̱ra mu ngonzi zaamwe zinene, ");
INSERT INTO rub_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","kwokwo asobore kubacungura mu lu̱ku̱u̱, na kubalinda mu nzala. ");
INSERT INTO rub_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","Tuli na ku̱ni̱hi̱ra mu Mukama, Mu̱ju̱ni̱ weetu̱ kandi ngab̯u gyei̱tu̱. ");
INSERT INTO rub_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","Mitima myetu̱ misemererwa mu yooyo, kubba twesiga ibara lyamwe li̱ti̱i̱nwa. ");
INSERT INTO rub_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","Ai̱ Mukama, leka ngonzi zaamu zinene zitwicaleho, tulimwo ku̱ni̱hi̱ra muli weewe. ");
INSERT INTO rub_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","Zabbu̱li̱ Gya Dau̱di̱, ni̱gi̱kwolokya b̯wi̱re b̯u̱yeefori̱ri̱ mugweraru, Abbi̱mereki̱ akamubinga. Nyasi̱i̱manga Mukama b̯wi̱re b̯wensei̱, kanwa kange keicalanga nikamuhaariiza. ");
INSERT INTO rub_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Nyehaariizanga mu Mukama, leka bab̯u̱ndaaru̱ beegwe kandi basemererwe. ");
INSERT INTO rub_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Haari̱i̱ze Mukama nagya, twensei̱ hamwei̱ tutende ibara lyamwe! ");
INSERT INTO rub_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Nyaatooleerye Mukama yanzi̱ramwo, yanjuna b̯u̱ti̱i̱ni̱ b̯wensei̱. ");
INSERT INTO rub_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Bensei̱ bamulingiira beicala basemereerwe, b̯u̱syo b̯wab̯u tib̯ulibba na nsoni̱. ");
INSERT INTO rub_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Yogo mudulu munaku yaali̱i̱ri̱, Mukama yaamwegwa, kandi yaamujuna yaamutoolaho kabii kensei̱. ");
INSERT INTO rub_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Malayika wa Mukama yeelogooleerya bati̱i̱na Mukama naabajuna. ");
INSERT INTO rub_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Mu̱bbi̱leho muwone Mukama nka kwali murungi, ali na mu̱gi̱sa ei̱ru̱ki̱ra muli yo. ");
INSERT INTO rub_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","Mu̱ti̱i̱ne Mukama nywe bantu ba Ruhanga, bamu̱ti̱i̱na abagabirira byensei̱ bibetaaga. ");
INSERT INTO rub_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Ntali zisobora kwegama, bei̱tu̱ batoolya Mukama tibeetaaga kintu kyensei̱. ");
INSERT INTO rub_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Mwi̱ze nywe baana bange, mu̱nzegwe, nkugyenda ku̱beegesya ku̱ti̱i̱na Mukama. ");
INSERT INTO rub_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Naani ali hahwo akwendya b̯womi, kandi akwendya biro binene, aleke awone birungi? ");
INSERT INTO rub_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","Otangenge kalimi kaamu kubaza kubiibi, na mu̱nwa gwamu kuhanuura byab̯u̱gobya. ");
INSERT INTO rub_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Olekenge kukora bibii, okore birungi, otoolyenge b̯u̱si̱nge kandi ob̯ulindenge. ");
INSERT INTO rub_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","Mei̱so ga Mukama geicala hali bamananu, mapokopo gaamwe geetegeerya kukunga kwab̯u. ");
INSERT INTO rub_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","Mukama asuula bakora bibiibi, ali̱bahwerekereerya bensei̱ ku nsi bantu babeebeere ki̱mwei̱. ");
INSERT INTO rub_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Bantu baamwe b̯ubaakamweta abajune, Mukama yeegwa naabajuna bizub̯u byab̯u byensei̱. ");
INSERT INTO rub_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Mukama ali heehi̱ na ba mitima mi̱b̯u̱ndeeri̱, kandi ajuna ba myozo mitali na ku̱ni̱hi̱ra. ");
INSERT INTO rub_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Wamananu abba na bizub̯u binene, bei̱tu̱ Mukama byensei̱ abimujunambe. ");
INSERT INTO rub_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","Mukama amulinda nab̯wegyendereza, nagaana kabii kensei̱ kumudwereera. ");
INSERT INTO rub_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Babiibi baalyeletera kuhwerekeera, bab̯wo banoba bantu bamananu balijunaanwa. ");
INSERT INTO rub_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","Mukama acungura b̯womi b̯wa bantu baamwe, tihaloho ei̱ru̱ki̱ra muli yo alijunaanwa. ");
INSERT INTO rub_vpl VALUES ("PS35_1","020_35_1","PSA","35","1","1","Zabbu̱li̱ gya Dau̱di̱. Ai̱ Mukama, kuutangana na bakukuutangana nagya, Lwana na bandwani̱sya. ");
INSERT INTO rub_vpl VALUES ("PS35_2","020_35_2","PSA","35","2","2","Kwata kilwalu na ngab̯u gyamu, obyoke onjune! ");
INSERT INTO rub_vpl VALUES ("PS35_3","020_35_3","PSA","35","3","3","Kwata isumu na mpasa gya b̯ulemu, lwani̱sya baku̱mpi̱i̱gani̱a! Weera mwozo gwange, “Ndi gyagya kujunwa kwamu!” ");
INSERT INTO rub_vpl VALUES ("PS35_4","020_35_4","PSA","35","4","4","Leka bab̯wo bakwendya ku̱nzi̱ta basware kandi batabba na ki̱ti̱i̱ni̱sa. Babinge kandi ohu̱gu̱tani̱e bab̯wo bensei̱ bendya kumputaaza. ");
INSERT INTO rub_vpl VALUES ("PS35_5","020_35_5","PSA","35","5","5","Bafoore nka bisusunga mu mpehu, malayika wa Mukama naalimwo ku̱beru̱kya ");
INSERT INTO rub_vpl VALUES ("PS35_6","020_35_6","PSA","35","6","6","Leka muhanda gwab̯u gwi̱zwemwo nti̱ti̱ na b̯unterente, malayika wa Mukama naalimwo ku̱beru̱kya! ");
INSERT INTO rub_vpl VALUES ("PS35_7","020_35_7","PSA","35","7","7","Kubba bantega batali na kigyendeerwa, b̯womi b̯wange nibab̯ulimira b̯u̱hya batali na nsonga. ");
INSERT INTO rub_vpl VALUES ("PS35_8","020_35_8","PSA","35","8","8","Leka azi̱ke atakwega, mutegu gwabbanga antegi̱ri̱ gumwekwatire, agu̱gwemwo mpaka ha kuhwerekeera kwamwe! ");
INSERT INTO rub_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","Kasi mwomwo mwozo gwange gulisemererwa mu Mukama, ni̱gu̱nyu̱mi̱rwa mu kujuna kwamwe. ");
INSERT INTO rub_vpl VALUES ("PS35_10","020_35_10","PSA","35","10","10","Maku̱ha gange gensei̱ gakwi̱za kukoba yati, “Ai̱ Mukama, naani akukwisana, akucungura banaku, hali akubakira maani, baseege na bali mu b̯wetaagu hali akubanyaga?” ");
INSERT INTO rub_vpl VALUES ("PS35_11","020_35_11","PSA","35","11","11","Babiibi babyoka kundumiriza, ni̱bambu̱u̱lya bintu bi̱nteegi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS35_12","020_35_12","PSA","35","12","12","Mu kiikaru kya birungi, bansasulamwo bibiibi, nibammalamwo maani. ");
INSERT INTO rub_vpl VALUES ("PS35_13","020_35_13","PSA","35","13","13","Bei̱tu̱ bo b̯u̱baahi̱mbi̱ri̱, nyaalweri̱ nsensede, nyeeru̱mya na kusaba na kusiiba, nyaasabenge ntu̱lu̱ki̱ri̱ mu̱twe. ");
INSERT INTO rub_vpl VALUES ("PS35_14","020_35_14","PSA","35","14","14","Nyei̱seeni̱ nka akulira munywani wange rundi weetu̱, nka muntu akulira mmaawe, nyeetu̱lu̱ki̱ri̱ nindi mu maaru. ");
INSERT INTO rub_vpl VALUES ("PS35_15","020_35_15","PSA","35","15","15","Bei̱tu̱ gya b̯unyaali mu kabii baasemereerwe beesorooza, bei̱sorooze ku̱nsekereerya, ndu̱mbi̱i̱rwe bantu banteegi̱ri̱, banku̱u̱ti̱ri̱ batakulekeera. ");
INSERT INTO rub_vpl VALUES ("PS35_16","020_35_16","PSA","35","16","16","Nka bagwagwa bali ha ki̱genyi̱, bantegeeri̱ meino. ");
INSERT INTO rub_vpl VALUES ("PS35_17","020_35_17","PSA","35","17","17","Ai̱ Mukama, oli̱doosya di̱i̱ kubalingiira b̯u̱li̱ngi̱i̱ri̱? Nnjuna bibakumpoora nabyo, ojune b̯womi b̯wange b̯wa muhendu kuruga mu zizi ntali. ");
INSERT INTO rub_vpl VALUES ("PS35_18","020_35_18","PSA","35","18","18","Nyaaku̱si̱i̱manga mu lwecooko lwa bantu, mu bantu banene nyaakuhaariizanga. ");
INSERT INTO rub_vpl VALUES ("PS35_19","020_35_19","PSA","35","19","19","Banyanzigwa bange baleke kunyeb̯ugira bannobira b̯usa baleke kwesi̱i̱ma, ");
INSERT INTO rub_vpl VALUES ("PS35_20","020_35_20","PSA","35","20","20","Tibambaza kurungi, bei̱tu̱ bacwa makuru bantu batali na kabii, bab̯wo beicala bei̱tekereeri̱. ");
INSERT INTO rub_vpl VALUES ("PS35_21","020_35_21","PSA","35","21","21","Bangu̱hi̱ri̱i̱rya kunnyegeera, nibakoba, “Otyo, Otyo! Kasita mei̱so gaaki̱weeni̱!” ");
INSERT INTO rub_vpl VALUES ("PS35_22","020_35_22","PSA","35","22","22","Ai̱ Mukama, oweeni̱ byensei̱ leka kwetekeera, ai̱ Mukama, otamba hadei. ");
INSERT INTO rub_vpl VALUES ("PS35_23","020_35_23","PSA","35","23","23","Ruhanga wange kandi Mukama wange, nsagika, byoka ondwaniire. ");
INSERT INTO rub_vpl VALUES ("PS35_24","020_35_24","PSA","35","24","24","Ai̱ Mukama, Ruhanga wange, ntonganiira nka mananu gaamu kugali, otaleka nibakanyeb̯ugira. ");
INSERT INTO rub_vpl VALUES ("PS35_25","020_35_25","PSA","35","25","25","Otabaleka kuteekereza nti, “Tu̱tu̱ngi̱ri̱ kitubbanga ni̱tu̱toolya! Tukugyenda kumudya yemereeri̱!” ");
INSERT INTO rub_vpl VALUES ("PS35_26","020_35_26","PSA","35","26","26","Bensei̱ beb̯uga hab̯wa b̯uceke b̯wange, baswaze kandi obasi̱ngu̱re, beetembya hab̯wange, obalwalye muswaru. ");
INSERT INTO rub_vpl VALUES ("PS35_27","020_35_27","PSA","35","27","27","Banzendeerya b̯u̱si̱ngu̱zi̱, batoke hab̯wa kusemererwa na ngonzi, babaze yati, “Mukama ahaariizwe, anyu̱mi̱rwa mu kubba kurungi kwa muheereza waamwe.” ");
INSERT INTO rub_vpl VALUES ("PS35_28","020_35_28","PSA","35","28","28","Kalimi kange kaabazanga ha b̯winganiza b̯wamu, kandi nkwi̱za kukuhaariiza biro byensei̱. ");
INSERT INTO rub_vpl VALUES ("PS36_1","020_36_1","PSA","36","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱. Zabbu̱li̱ gya Dau̱di̱, muheereza wa Mukama. Kibii kihwehwetira mubiibi, mu mutima gwamwe, nikimugaana ku̱ti̱i̱na Ruhanga. ");
INSERT INTO rub_vpl VALUES ("PS36_2","020_36_2","PSA","36","2","2","Yeetembya yankei, naateekereza Ruhanga talyega bibii byamwe akamujunaana. ");
INSERT INTO rub_vpl VALUES ("PS36_3","020_36_3","PSA","36","3","3","Bigambu bya kanwa kaamwe bibba kabii na b̯u̱gobya, aleki̱ri̱ho kwetegereza na kukora birungi. ");
INSERT INTO rub_vpl VALUES ("PS36_4","020_36_4","PSA","36","4","4","Ateekereza b̯ubiibi naali mu ntabbu gyamwe, yeeteereeri̱ho mihanda mitali mirungi, tasuula kibii. ");
INSERT INTO rub_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","Ngonzi zaamu zinene, ai̱ Mukama, zidwa mwiguru, b̯wesigwa b̯wamu mu byalu. ");
INSERT INTO rub_vpl VALUES ("PS36_6","020_36_6","PSA","36","6","6","Mananu gaamu gali nka nsahu za maani, b̯winganiza b̯wamu nka ndi̱ha gilei. Ai̱ Mukama, ojuna bantu na bisolo. ");
INSERT INTO rub_vpl VALUES ("PS36_7","020_36_7","PSA","36","7","7","Ai̱ Ruhanga, ngonzi zaamu zinene zili za muhendu! Nahab̯waki̱kyo baana ba bantu b̯wesigwa b̯wab̯u baab̯uta mu̱tu̱ntu̱lu̱ gwa bimpaha byamu. ");
INSERT INTO rub_vpl VALUES ("PS36_8","020_36_8","PSA","36","8","8","Nibadya ha binene bya mu nnyu̱mba gyamu, obaha kyakunywa kuruga ha mugira gwa kusemererwa kwamwo. ");
INSERT INTO rub_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","Kubba muli we hooho hali musu gwa b̯womi, mu kyererezi̱ kyamu tuwonamwo kyererezi̱. ");
INSERT INTO rub_vpl VALUES ("PS36_10","020_36_10","PSA","36","10","10","Oteeryeho ngonzi zinene hali bab̯wo bakukwega, obahe b̯winganiza baterekereru̱ mitima. ");
INSERT INTO rub_vpl VALUES ("PS36_11","020_36_11","PSA","36","11","11","Kitasoboka magulu ga bamyehembu kumpondeera, nab̯ugwakabba mukono gwa mubiibi kumbinga. ");
INSERT INTO rub_vpl VALUES ("PS36_12","020_36_12","PSA","36","12","12","Wona bankora bibii ku̱bagwi̱ri̱, babatitiniri̱ tibakusobora kubyoka! ");
INSERT INTO rub_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","Gya Dau̱di̱. Leka kwetuntuza hab̯wa babiibi rundi okakwatirwa i̱hali̱ bakukora kubii, ");
INSERT INTO rub_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","Bakwi̱za ku̱syeraho nkeisubi kulyoma, bakwe nka bimera bi̱hotoku̱. ");
INSERT INTO rub_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","Weesiga Mukama kandi okore birungi, mwomwo oicale munsi kurungi. ");
INSERT INTO rub_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","Semererwa mu Mukama, kandi alikuha bya mutima gwamu gu̱kwendya. ");
INSERT INTO rub_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","Ngesu zaamu zoolokye Mukama, mumwesige yooyo akwi̱za kukoora. ");
INSERT INTO rub_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","Aliha b̯urungi b̯wamu kwaka nka kyererezi̱, b̯winganiza b̯wamu b̯umuluke nka lyoba lya mwinsi. ");
INSERT INTO rub_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","Gumisiriza kandi wesige Mukama, Leka kutuntuura babiibi hab̯wa ku̱gu̱du̱hara, na ku̱si̱ngu̱ra mu ntegeka zaab̯u zibiibi. ");
INSERT INTO rub_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","Weehala ki̱ni̱ga kandi oleke b̯u̱kabbu̱ru̱. Leka kutuntura, kileeta kibii. ");
INSERT INTO rub_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","Kubba babiibi bakwi̱za kuhwerekeera, bei̱tu̱ balindiira Mukama baligweterwa nsi. ");
INSERT INTO rub_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","Mu kasu̱mi̱ katali ka hadei, mubiibi talizookaho, nab̯wolilingiira ha kiikaru kyamwe nab̯wegyendereza talibbaho ");
INSERT INTO rub_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","Bei̱tu̱ banaku baligweterwa nsi nibeicala na b̯u̱si̱nge b̯unene. ");
INSERT INTO rub_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","Babiibi bahi̱gani̱za barungi, nibabanenera na magegu, ");
INSERT INTO rub_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","Mukama abaseka b̯u̱seki̱, kubba awona kabii ni̱kaku̱bei̱zi̱ra. ");
INSERT INTO rub_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","Babiibi basomolayo mpirima nibareega b̯uta, mwaku̱hwerekereerya banaku na bali mu b̯wetaagu, na kusala balibatira mu mihanda mi̱terekereru̱. ");
INSERT INTO rub_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","Bei̱tu̱ byogi byab̯u bi̱kwi̱za kubeteemuura mitima, b̯uta b̯wab̯u b̯ubinyeke. ");
INSERT INTO rub_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","Hakiri oicala nooli murungi kandi munaku, kukira kubba mubiibi kandi mu̱gu̱u̱da, ");
INSERT INTO rub_vpl VALUES ("PS37_17","020_37_17","PSA","37","17","17","kubba mikono mya babiibi mi̱kwi̱za kubinyeka, bei̱tu̱ Mukama asagika barungi. ");
INSERT INTO rub_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","Mukama yeegi̱ri̱ biro bya bab̯wo batagira kakuu, kandi b̯ugwetwa b̯wab̯u b̯ulibbaho biro na biro. ");
INSERT INTO rub_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","Mu b̯wi̱re b̯wa kabii tibalitalibana, balibba na binene mu b̯wi̱re b̯wa nzala. ");
INSERT INTO rub_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","Bei̱tu̱ babiibi bakwi̱za kuhwerekeera, banyanzigwa ba Mukama beisana nka ki̱ti̱i̱ni̱sa kyeisubi bakwi̱za ku̱tu̱u̱ka nka mwi̱ca, batu̱u̱ke bamalikeho. ");
INSERT INTO rub_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","Mubiibi yeehora tasasula ibanza, bei̱tu̱ murungi abba mwenda eicala naagaba, ");
INSERT INTO rub_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","kubba ba Mukama aheeri̱ mu̱gi̱sa bakwi̱za kugweterwa nsi, bei̱tu̱ baakyeni̱ri̱ baalimalikaho. ");
INSERT INTO rub_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","Mukama yooyo yoolokya muntu muhanda gwa akusemeera kukweta, kandi alinda bab̯wo bamusemeza, ");
INSERT INTO rub_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","nab̯walikibbala, tali̱gwa, kubba Mukama amukwatiira na mukono gwamwe. ");
INSERT INTO rub_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","Nyaali muto hataati̱ mpandi̱ri̱, tinkawonanga muntu murungi wa Mukama ahemu̱ki̱i̱ri̱, rundi kuwona baana baamwe ni̱baku̱sabi̱ri̱i̱rya bidyo. ");
INSERT INTO rub_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","Beicala benda kandi bahora bataku̱bali̱ri̱i̱rya, baana baab̯u baliheeb̯wa mu̱gi̱sa. ");
INSERT INTO rub_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","Leka bibiibi okore birungi, mwomwo oliicala mu nsi biro na biro. ");
INSERT INTO rub_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","Kubba Mukama yendya b̯winganiza, kandi talilekeera beesigwa be. Bakwi̱za kulindwa biro na biro, bei̱tu̱ beizukulu ba babiibi bakwi̱za kuhwerekeera, ");
INSERT INTO rub_vpl VALUES ("PS37_29","020_37_29","PSA","37","29","29","Bamananu baligweterwa nsi, kandi beicalemwo biro byensei̱. ");
INSERT INTO rub_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","30","Kanwa ka wa mananu kaatula magezi̱, kalimi kaamwe kabaza bya b̯winganiza. ");
INSERT INTO rub_vpl VALUES ("PS37_31","020_37_31","PSA","37","31","31","Mutima gwamwe gwi̱zwi̱ri̱ biragiro bya Mukama, magulu gaamwe tigasoba. ");
INSERT INTO rub_vpl VALUES ("PS37_32","020_37_32","PSA","37","32","32","Babiibi beicala bali̱ndi̱ri̱i̱ri̱ bamananu, ni̱batoolereerya kumalaho b̯womi b̯wab̯u, ");
INSERT INTO rub_vpl VALUES ("PS37_33","020_37_33","PSA","37","33","33","bei̱tu̱ Mukama talibaleka kubba mu mikono myab̯u, rundi akabaleka babacwere musangu nibali babaju̱neeni̱. ");
INSERT INTO rub_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","34","Lindiira Mukama weekwate mihanda myamwe, akwi̱za ku̱ku̱byokya ogweterwe nsi, babiibi b̯ubalimalwaho, okwi̱za kukyewonira. ");
INSERT INTO rub_vpl VALUES ("PS37_35","020_37_35","PSA","37","35","35","Mbweni̱ muntu mubiibi kandi atagira kisa, naakunyengetera nka musaali guli heitehe lirungi, ");
INSERT INTO rub_vpl VALUES ("PS37_36","020_37_36","PSA","37","36","36","bei̱tu̱ b̯wangu b̯wangu naasyeraho atakei̱re kuzookaho, nab̯u̱nyalwani̱si̱i̱rye ku̱mu̱toolya gwakabiri atakazookeho. ");
INSERT INTO rub_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","Lingiira bantu bamananu kandi barungi, muntu b̯wa b̯u̱si̱nge abba na beizukulu. ");
INSERT INTO rub_vpl VALUES ("PS37_38","020_37_38","PSA","37","38","38","Bei̱tu̱ babiibi bensei̱ balihwerekeera, bya mu̱mei̱so bya babiibi byensei̱ bilihwerekeera. ");
INSERT INTO rub_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","Kujunwa kwa bamananu kuruga hali Mukama yooyo b̯wi̱ru̱ki̱ro b̯wab̯u mu b̯wi̱re b̯wa kabii. ");
INSERT INTO rub_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","Mukama abajuna naabacungura kuruga mu mikono mya babiibi, naabajuna, kubba bei̱ru̱ki̱ra muli yooyo. ");
INSERT INTO rub_vpl VALUES ("PS38_1","020_38_1","PSA","38","1","1","Zabbu̱li̱ gya Dau̱di̱, naakusaba Ruhanga amwi̱zu̱ke. Ai̱ Mukama, otanfubira nooli na ki̱ni̱ga rundi kundamba nooli na b̯usungu. ");
INSERT INTO rub_vpl VALUES ("PS38_2","020_38_2","PSA","38","2","2","Kubba mbasi zaamu zi̱njagareeri̱ mu mubiri, kandi mukono gwamu gu̱mmi̱gi̱ri̱ hansi. ");
INSERT INTO rub_vpl VALUES ("PS38_3","020_38_3","PSA","38","3","3","Hab̯wa b̯usungu b̯wamu mpi̱mbi̱ri̱. Hab̯wa kibii kyange, maku̱ha gange gaceki̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS38_4","020_38_4","PSA","38","4","4","Kuhenera kwange ku̱nsagi̱ri̱, nka mugugu guntakusobora kwetweka. ");
INSERT INTO rub_vpl VALUES ("PS38_5","020_38_5","PSA","38","5","5","Bihote byange bi̱tamu̱ki̱ri̱ bi̱ku̱nu̱nka, hab̯wa b̯udoma b̯wange. ");
INSERT INTO rub_vpl VALUES ("PS38_6","020_38_6","PSA","38","6","6","Nnyeehi̱nyi̱ri̱ ndi hansi, kiro kyensei̱ nkimalira mu maaru. ");
INSERT INTO rub_vpl VALUES ("PS38_7","020_38_7","PSA","38","7","7","Mu̱twe gwange gu̱hyohi̱ri̱ hab̯wa mu̱swi̱ja gwamaani, ndi heehi̱ ku̱kwa. ");
INSERT INTO rub_vpl VALUES ("PS38_8","020_38_8","PSA","38","8","8","Njwahi̱ri̱ ntematemeerwe ki̱mwei̱, nkulira hab̯wa nganye za mu mutima gwange. ");
INSERT INTO rub_vpl VALUES ("PS38_9","020_38_9","PSA","38","9","9","Mukama bi̱nku̱rombya byensei̱, na kutaaga kwange obyegi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS38_10","020_38_10","PSA","38","10","10","Mutima gulimu kunkuuta, maani gammali̱ki̱ri̱i̱ri̱, Mei̱so gange gebbu̱mbi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS38_11","020_38_11","PSA","38","11","11","Banywani na banywi̱ bamukagu bali mu kunyehala hab̯wa bihote, banyaruganda nabo bandahi̱ri̱ho. ");
INSERT INTO rub_vpl VALUES ("PS38_12","020_38_12","PSA","38","12","12","Bendya ku̱nzi̱ta bantega mitegu, bampu̱tei̱ze nibandyamwo rukwe lwa ku̱mpwerekereerya. ");
INSERT INTO rub_vpl VALUES ("PS38_13","020_38_13","PSA","38","13","13","Ndi nka mwi̱jalu̱ mapokopo, atakwegwa, nka kibbubbu atakubaza, ");
INSERT INTO rub_vpl VALUES ("PS38_14","020_38_14","PSA","38","14","14","Ndi nka atakwegwa, wa mu̱nwa gutakusobora kwi̱ramwo. ");
INSERT INTO rub_vpl VALUES ("PS38_15","020_38_15","PSA","38","15","15","Ai̱ Mukama, nku̱ni̱hi̱ra muli we, okwi̱za ku̱nzi̱ramwo, ai̱ Mukama Ruhanga wange. ");
INSERT INTO rub_vpl VALUES ("PS38_16","020_38_16","PSA","38","16","16","Nyaaku̱wereeri̱ nti, “Otabekiriza kunyehaariiziraho, hab̯wakubba nki̱bbeeri̱.” ");
INSERT INTO rub_vpl VALUES ("PS38_17","020_38_17","PSA","38","17","17","Hab̯wakubba ndi heehi̱ ku̱gwa, ncala na b̯u̱ru̱mi̱ b̯wi̱re b̯wensei̱. ");
INSERT INTO rub_vpl VALUES ("PS38_18","020_38_18","PSA","38","18","18","Nkwatula bibiibi byange, mb̯i̱hi̱ri̱i̱rwe hab̯wa kuhenera kwange. ");
INSERT INTO rub_vpl VALUES ("PS38_19","020_38_19","PSA","38","19","19","Banyanzigwa bange banku̱mpi̱gi̱ra b̯usa bannobi̱ri̱ batali na nsonga bali banene. ");
INSERT INTO rub_vpl VALUES ("PS38_20","020_38_20","PSA","38","20","20","Bansasula bibiibi hab̯wa birungi binkora, boobo bampi̱i̱gani̱sya kubba nkwendya kukora birungi. ");
INSERT INTO rub_vpl VALUES ("PS38_21","020_38_21","PSA","38","21","21","Ai̱ Mukama, otandekeera, ai̱ Ruhanga wange, otamba hadei. ");
INSERT INTO rub_vpl VALUES ("PS38_22","020_38_22","PSA","38","22","22","Ranguha onjune, Ai̱ Mukama Mu̱ju̱ni̱ wange. ");
INSERT INTO rub_vpl VALUES ("PS39_1","020_39_1","PSA","39","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱. Hali Jedu̱sani̱. Zabbu̱li̱ gya Dau̱di̱. Nyaakobi̱ri̱, “Nkwi̱za kwegyendereza ntakora kibii mu bintu bimbaza, nyaakoba tindizootera kintu kyensei̱, babiibi nibaloho baatanzegwa.” ");
INSERT INTO rub_vpl VALUES ("PS39_2","020_39_2","PSA","39","2","2","Nyaali nka kibbubbu ntakubaza, kitakangasire, hab̯wakubba kyateereerye b̯u̱teerya kuwonawona kwange. ");
INSERT INTO rub_vpl VALUES ("PS39_3","020_39_3","PSA","39","3","3","Mutima gwasali̱ki̱ri̱, b̯u̱nyatekeri̱i̱ze hoi̱ gwahyengi̱ nka mworo, mwomwo nyabazi̱ri̱ na kalimi kange nti, ");
INSERT INTO rub_vpl VALUES ("PS39_4","020_39_4","PSA","39","4","4","“Ai̱ Mukama, leka nyeetegereze nkangu gyange, na ndengu gya biro byange, ommanyi̱sye b̯womi b̯wange nka kub̯uli mu kumalikaho.” ");
INSERT INTO rub_vpl VALUES ("PS39_5","020_39_5","PSA","39","5","5","Biro byange waabi̱fori̱ri̱ nka ntambu b̯utambu, b̯womi b̯wange ob̯uwona nka kitali kintu. B̯womi b̯wa b̯uli muntu b̯wicala rwoya lusa. ");
INSERT INTO rub_vpl VALUES ("PS39_6","020_39_6","PSA","39","6","6","Mananakwo muntu ali nka mu̱tu̱ntu̱lu̱ eicala nalibatalibata, atalibanira b̯usa, asoroza itungu ateegi̱ri̱ akulitwala, ");
INSERT INTO rub_vpl VALUES ("PS39_7","020_39_7","PSA","39","7","7","“Hataati̱ Mukama kyani ki̱nku̱toolya? Ku̱ni̱hi̱ra kwange kuli muli weewe. ");
INSERT INTO rub_vpl VALUES ("PS39_8","020_39_8","PSA","39","8","8","Njuna byakuhenara byange byensei̱, ntafooka kyakusungwa badoma. ");
INSERT INTO rub_vpl VALUES ("PS39_9","020_39_9","PSA","39","9","9","Nyaali nyetekereeri̱, ntakub̯uula mu̱nwa, kubba weewe waaki̱koori̱. ");
INSERT INTO rub_vpl VALUES ("PS39_10","020_39_10","PSA","39","10","10","Tokulekaho kunfubira, njwahi̱ri̱ kukuutwa kwa mukono gwamu. ");
INSERT INTO rub_vpl VALUES ("PS39_11","020_39_11","PSA","39","11","11","Owonawonesya bantu hab̯wa bibii byab̯u, itungu lyab̯u olidya nka nnyenze, mananu b̯uli muntu abba rwoya lusa! ");
INSERT INTO rub_vpl VALUES ("PS39_12","020_39_12","PSA","39","12","12","“Ai̱ Mukama, weegwa kusaba kwange otegere mapokopo kizabiro kyange onkonyere, kubba ndi mu̱genyi̱, mu̱goonyi̱ nka bahaaha bensei̱ kubaali. ");
INSERT INTO rub_vpl VALUES ("PS39_13","020_39_13","PSA","39","13","13","Leka kumbihiriirwa kwokwo nsemererweho, ntakabbeeri̱ ku̱kwa nkei̱ra kintu kwankei.” ");
INSERT INTO rub_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱. Zabbu̱li̱ gya Dau̱di̱. Nyaali̱ndi̱ri̱i̱ri̱ Mukama na kugumisiriza yeetegereza yeegwa kukunga kwange. ");
INSERT INTO rub_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","Yantoori̱ mu ki̱i̱na kilei baku̱u̱ ha bagyenda, mu bicokodo bya lu̱ku̱u̱, magulu gange yaagei̱cya ha lubbaali, yansoboresya kulibata ntanti̱i̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","Mu kanwa kange yaahangi̱ri̱mwo kyembu kihyaka, kyembu kya kuhaariiza Ruhanga weetu̱. Banene b̯ubalibiwona bali̱ti̱i̱na, kandi ku̱ni̱hi̱ra kwab̯u bakute hali Mukama. ");
INSERT INTO rub_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","Ali na mu̱gi̱sa muntu, yeesiga Mukama, ateekwata na bamyehembu, na kweju̱u̱bya na baramya baruhanga bandi. ");
INSERT INTO rub_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","Onzongeeri̱ binene ai̱ Mukama Ruhanga wange, gaga gali mahanu gookoori̱. Bintu bi̱watu̱tegekeeri̱, tihaloho akusobora kubikubalira, kadi gya nkakoba kubibaza, tosobora kubibala okabimalayo. ");
INSERT INTO rub_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","Bihongwa na byonzira tobyendya, wampeeri̱ mapokopo nkwetegeerye, bihongwa bya kwokya na bya kuganyira bibii tobyetaaga. ");
INSERT INTO rub_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","Mwomwo nyaabazi̱ri̱ ninkoba yati, “Wona ndi haha, nzi̱ri̱, bibampandi̱ki̱ri̱ho mu binyakuhandiikwa bikoba: ");
INSERT INTO rub_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","Nyendya kukora bi̱wendya, ai̱ Ruhanga wange, biragiro byamu bili mu mutima gwange.” ");
INSERT INTO rub_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","9","Ntebeerye mananu gaamu mu kitebe kya bantu banene, okyegi̱ri̱ nka ku̱nteteekeera kubaza, ai̱ Mukama. ");
INSERT INTO rub_vpl VALUES ("PS40_10","020_40_10","PSA","40","10","10","Kujuna kwamu ti̱nku̱bi̱si̱ri̱ mu mutima gwange, ntebeerye b̯wesigwa na kujunwa kwamu, ngonzi zaamu zinene na b̯unanu mbibbumbiira kwahi mu kitebe kya bantu banene. ");
INSERT INTO rub_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","Hab̯wamu, ai̱ Mukama, otalemwa kungirira kisa, ngonzi zaamu zinene na b̯wesigwa b̯wamu bindindenge. ");
INSERT INTO rub_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","Kubba bizub̯u bi̱nyelogoleerye, bibii byange byakaleseeni̱ tinkusobora kuwona, binene na kukira ntumbu za ha mu̱twe gwange, mutima gwicala ni̱gu̱gwa. ");
INSERT INTO rub_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","Ai̱ Mukama, bba na mbabazi̱, oncungure, ai̱ Mukama, wanguha onjune. ");
INSERT INTO rub_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","Leka bakwatwe nsoni̱ kandi basware, bab̯wo baku̱toolereerya ku̱nzi̱ta, bakwendya mpwerekeere bemuke na muswaru. ");
INSERT INTO rub_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","15","Leka beicala nibamponereerya nibambweranga nti, “Ee, koowonewone,” bemuke na muswaru! ");
INSERT INTO rub_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","Bensei̱ baku̱toolya, bajaguze kandi basemererwe muli weewe, leka bab̯wo bendya kujunwa kwamu, beicalenge nibakoba yati, “Mukama wamaani!” ");
INSERT INTO rub_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","Gya ndi munaku kandi mu b̯wetaagu, Mukama ancweramwo. Weewe Mu̱ju̱ni̱ kandi mu̱cu̱ngu̱ri̱ wange, ai̱ Ruhanga wange, otakereerwa. ");
INSERT INTO rub_vpl VALUES ("PS41_1","020_41_1","PSA","41","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱. Zabbu̱li̱ gya Dau̱di̱. Ali na mu̱gi̱sa abba mwenda hali baseege, Mukama amujuna mu b̯wi̱re b̯wa bizub̯u. ");
INSERT INTO rub_vpl VALUES ("PS41_2","020_41_2","PSA","41","2","2","Mukama alimulinda kandi amwi̱caalye naali mwomi, Mukama alimuha mu̱gi̱sa mu nsi kandi talimuleka akakwatwa kwetaaga kwa banyanzigwa baamwe. ");
INSERT INTO rub_vpl VALUES ("PS41_3","020_41_3","PSA","41","3","3","Mukama alimukwatiira ha ntabbu gyamwe amu̱honi̱e nseeri̱ zaamwe ");
INSERT INTO rub_vpl VALUES ("PS41_4","020_41_4","PSA","41","4","4","Nyakobi̱ri̱ yati, “Ai̱ Mukama, ngiira mbabazi̱, mponi̱a, kubba nkoori̱ kibii mu mei̱so gaamu.” ");
INSERT INTO rub_vpl VALUES ("PS41_5","020_41_5","PSA","41","5","5","Banyanzigwa bambazaho nei̱hali̱ nibakoba yati, “Ali̱kwa di, yogwo ibara lyamwe ni̱li̱kasyeraho?” ");
INSERT INTO rub_vpl VALUES ("PS41_6","020_41_6","PSA","41","6","6","Bab̯wo bambungira nka banywani, bei̱tu̱ nibasorooza rugambu, b̯ubabba nibakwemuka, nibalurarangya hensei̱. ");
INSERT INTO rub_vpl VALUES ("PS41_7","020_41_7","PSA","41","7","7","Banyanzigwa bange bensei̱ bahwehwetira hamwei̱ nibakumbazaho, banzendeerya bibiibi bisa. ");
INSERT INTO rub_vpl VALUES ("PS41_8","020_41_8","PSA","41","8","8","Baakobenge “Akwati̱i̱rwe nseeri̱ gibiibi, tasobora kubyoka ha aleeri̱.” ");
INSERT INTO rub_vpl VALUES ("PS41_9","020_41_9","PSA","41","9","9","Na munywani wange gi̱i̱nyesi̱gengi̱, adyanga hamwei̱ nagya, yoodede anfookeeri̱ munyanzigwa. ");
INSERT INTO rub_vpl VALUES ("PS41_10","020_41_10","PSA","41","10","10","Ai̱ Mukama, ngiira mbabazi̱, mbyokya, aleke mbahoore. ");
INSERT INTO rub_vpl VALUES ("PS41_11","020_41_11","PSA","41","11","11","Nkyegi̱ri̱ nka kwoku̱nzendya, kubba oleki̱ri̱ kwahi banyanzigwa ku̱nsi̱ngu̱ra. ");
INSERT INTO rub_vpl VALUES ("PS41_12","020_41_12","PSA","41","12","12","Wankwati̱ri̱i̱ri̱ hab̯wa mananu gange, wanzi̱cya mu̱mei̱so gaamu biro na biro. ");
INSERT INTO rub_vpl VALUES ("PS41_13","020_41_13","PSA","41","13","13","Mukama ahaariizwe, Ruhanga wʼI̱saleeri̱, biro na biro. ");
INSERT INTO rub_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱. Masikili kinyakuhandiikwa baana ba Koora. Ai̱ Ruhanga, nka mparaaki kuhyahyanira meezi̱ ga kunywa, kwokwo na mwozo gwange gukukuhyahyanira. ");
INSERT INTO rub_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","Mwozo gwange gukukuhyahyanira Ruhanga mwomi. Ndigyenda di̱i̱ mu mei̱so ga Ruhanga? ");
INSERT INTO rub_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Mali̱ga gange googo geicala bidyo byange, mwinsi nei̱jolo, bantu b̯ubabba ni̱baku̱mbu̱u̱lya b̯wi̱re b̯wensei̱, “Ruhanga waamu ali hanya?” ");
INSERT INTO rub_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","Nki̱zi̱ gindabamwo b̯u̱nyi̱zu̱ka byenyu̱ma, nka ku̱nyebemberengi̱ bantu banene, nitukumba kugyenda mu nnyu̱mba gya Ruhanga, ni̱tu̱kwami̱i̱rya byembu bya kuhaariiza na kusemererwa kunene, bantu banene ni̱bei̱za kujaguza. ");
INSERT INTO rub_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","Ai̱ mwozo gwange, hab̯waki otu̱ntwi̱ri̱, kandi hab̯waki otateekeeni̱? Weesiganga Ruhanga, hab̯wakubba ndimuhaariiza gwakandi, Mu̱ju̱ni̱ wange kandi Ruhanga wange. ");
INSERT INTO rub_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","6","Nsali̱i̱rwe nu mu mutima gwange, bei̱tu̱ ndi̱kwi̱zu̱ka, nab̯undibba nindi hadei na Yorodaani, na nsi gya lusahu Hamoni̱ kandi na lwa Mi̱zi̱ra. ");
INSERT INTO rub_vpl VALUES ("PS42_7","020_42_7","PSA","42","7","7","Nkwegwa ndi̱ha nigyeta gi̱i̱ra gyagyo nka meezi̱ gakuhuura kugagwa hansi, gei̱zwi̱ri̱ gaammeeri̱. ");
INSERT INTO rub_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","Mukama yolokyanga ngonzi zaamwe zinene b̯wi̱re b̯wa mwinsi, kandi kyembu kyamwe kyokyo nyahi̱i̱manga i̱jolo, ninkusaba Ruhanga yogwo ampa b̯womi. ");
INSERT INTO rub_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","Ndiriira Ruhanga, lubbaali lwange nimuweera, “Hab̯waki onzebereeri̱? Hab̯waki ncala nimbonawona hab̯wa ku̱wonawonesya kwa banyanzigwa bange?” ");
INSERT INTO rub_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","Banyanzigwa bange beicala nibanjooga nibakobanga yati, “Ruhanga waamu ali hanya?” Baheeri̱ b̯womi b̯wanga kubba nka muntu ali na kihote kinyamapo. ");
INSERT INTO rub_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","Ai̱ mwozo gwange, hab̯waki otu̱ntwi̱ri̱, kandi hab̯waki otateekeeni̱? Weesiganga Ruhanga, hab̯wakubba ndimuhaariiza gwakandi, Mu̱ju̱ni̱ wange kandi Ruhanga wange. ");
INSERT INTO rub_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","Ai̱ Ruhanga, ntoolaho musangu kandi ontonganiire hali bantu babiibi, onjune hali yogwo mudulu mu̱gobya kandi atagira b̯winganiza. ");
INSERT INTO rub_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","Kubba weewe Ruhanga ginyeesiga hab̯waki ondekereeri̱? Hab̯waki ncala nimbonawona, hab̯wa ku̱wonawonesya kwa banyanzigwa bange? ");
INSERT INTO rub_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","Ntumira kyererezi̱ na mananu gaamu bimulukire binyebembere bindeete ha lusahu lwamu lu̱syanu̱ hali oicala. ");
INSERT INTO rub_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","B̯u̱b̯wo mwomwo ndigyenda ha kyoto kyeihongo lya Ruhanga, hali we Ruhanga ampa kusemererwa kunene, aleke nkuhaariize na ndi̱ngi̱di̱, ai̱ Ruhanga, we Ruhanga wange. ");
INSERT INTO rub_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","Ai̱ mwozo gwange, hab̯waki otu̱ntwi̱ri̱, kandi hab̯waki otateekeeni̱? Weesiganga Ruhanga, hab̯wakubba ndimuhaariiza gwakandi, Mu̱ju̱ni̱ wange kandi Ruhanga wange! ");
INSERT INTO rub_vpl VALUES ("PS44_1","020_44_1","PSA","44","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱. Masikili gya baana ba Koora. Ai̱ Ruhanga, twegwi̱ri̱ na mapokopo geetu̱, bya bahaaha beetu̱ bi̱batu̱weereeri̱, bi̱waakoori̱ mu biro byab̯u bya kadei. ");
INSERT INTO rub_vpl VALUES ("PS44_2","020_44_2","PSA","44","2","2","Weewe wankei na mukono gwamu waabi̱ngi̱ri̱ waasi̱gu̱ra banyamahanga, waatamwo babbaabeetu̱, waabonawonesya banyamahanga, bei̱tu̱ babbaabeetu̱ waabacungura. ");
INSERT INTO rub_vpl VALUES ("PS44_3","020_44_3","PSA","44","3","3","Babbaabeetu̱ batakasi̱ngu̱re gi̱gyo nsi hab̯wa mpirima zaab̯u, rundi hab̯wa maani gaab̯u, bei̱tu̱ basi̱ngwi̱ri̱ hab̯wa mukono gwamu gwab̯udyo na maani gaamu, na kyererezi̱ kya mei̱so gaamu, hab̯wakubba waabendeerye. ");
INSERT INTO rub_vpl VALUES ("PS44_4","020_44_4","PSA","44","4","4","Ai̱ Ruhanga, weewe oli mukama wange, oha Yakobbo b̯u̱si̱ngu̱zi̱. ");
INSERT INTO rub_vpl VALUES ("PS44_5","020_44_5","PSA","44","5","5","Banyanzigwa beetu̱ tu̱basi̱ngu̱ra hab̯wa b̯u̱sobozi̱ b̯wamu, batu̱ru̱mba nitubaziginiira. ");
INSERT INTO rub_vpl VALUES ("PS44_6","020_44_6","PSA","44","6","6","Tinsobora kwesiga b̯uta b̯wange, kadi gibbe mpirima gyange, tigisobora kunjuna. ");
INSERT INTO rub_vpl VALUES ("PS44_7","020_44_7","PSA","44","7","7","Bei̱tu̱ weewe otujuna hali banyanzigwa beetu̱, batunoba noobaswaza. ");
INSERT INTO rub_vpl VALUES ("PS44_8","020_44_8","PSA","44","8","8","Twesu̱gu̱syanga weewe Ruhanga, kandi weewe twahaariizanga biro byensei̱. ");
INSERT INTO rub_vpl VALUES ("PS44_9","020_44_9","PSA","44","9","9","Bei̱tu̱ hataati̱ otu̱swi̱ri̱ kandi watub̯undaaza, tokyakebembera mahe geetu̱. ");
INSERT INTO rub_vpl VALUES ("PS44_10","020_44_10","PSA","44","10","10","Oleki̱ri̱ banyanzigwa batwi̱ru̱kya, kandi bintu byetu̱ bab̯wo banyagi̱ babitwala. ");
INSERT INTO rub_vpl VALUES ("PS44_11","020_44_11","PSA","44","11","11","Otu̱heeri̱yo batwi̱te nka ntaama gibakugyenda kusala, otu̱sarani̱i̱rye mu mahanga. ");
INSERT INTO rub_vpl VALUES ("PS44_12","020_44_12","PSA","44","12","12","Waatu̱ndi̱ri̱ bantu baamu b̯usa, nka rundi si batakabbe na mugasu. ");
INSERT INTO rub_vpl VALUES ("PS44_13","020_44_13","PSA","44","13","13","Otu̱heeri̱ kubba ki̱joogo mu bataahi̱, twei̱ra kyaku̱lu̱mwa kandi kyakugaywa mu batu̱heereeri̱. ");
INSERT INTO rub_vpl VALUES ("PS44_14","020_44_14","PSA","44","14","14","Otu̱leeteeri̱ kubba binugwa mu mahanga, otwi̱ri̱i̱rye kyaku̱joogwa. ");
INSERT INTO rub_vpl VALUES ("PS44_15","020_44_15","PSA","44","15","15","Biro byense ndibata ninswaraswara, nindi na nsoni̱ mu mei̱so gange, ");
INSERT INTO rub_vpl VALUES ("PS44_16","020_44_16","PSA","44","16","16","hab̯wa bigambu bya bab̯wo banjooga, kandi bansekereerya mu mei̱so ga banyanzigwa na bendya kuhoora nzi̱go. ");
INSERT INTO rub_vpl VALUES ("PS44_17","020_44_17","PSA","44","17","17","Bibi byensei̱ bi̱twi̱zi̱ri̱ho, nab̯utwakabba tu̱takwebereeri̱, rundi tu̱tabi̱nyi̱ri̱ ndagaanu gyamu. ");
INSERT INTO rub_vpl VALUES ("PS44_18","020_44_18","PSA","44","18","18","Mitima myetu̱ timikakurugangaho, magulu geetu̱ tigakahugukanga kuruga mu muhanda gwamu. ");
INSERT INTO rub_vpl VALUES ("PS44_19","020_44_19","PSA","44","19","19","Bei̱tu̱ nab̯wo otu̱tweri̱ watuguma mu misege, watubbutukira na nti̱ti̱ gya zigizigi. ");
INSERT INTO rub_vpl VALUES ("PS44_20","020_44_20","PSA","44","20","20","Kakubba twali twebeereeri̱ Ruhanga weetu̱, rundi twalingi tweheeri̱yo ku̱ramya ruhanga wondi, ");
INSERT INTO rub_vpl VALUES ("PS44_21","020_44_21","PSA","44","21","21","Ruhanga yaaku̱lemeerwe kwahi kukyega? Hab̯wakubba eicala yeegi̱ri̱ nsita zeetu̱ za ha mutima? ");
INSERT INTO rub_vpl VALUES ("PS44_22","020_44_22","PSA","44","22","22","Bei̱tu̱ hab̯wamu, biro byensei̱ twicala ni̱twi̱twa, batutwala kubiibi nka ntaama gibakugyenda kusala. ");
INSERT INTO rub_vpl VALUES ("PS44_23","020_44_23","PSA","44","23","23","Ai̱ Mukama, byoka! Hab̯waki otu̱lekereeri̱? Byokiramwo otatubingira ki̱mwei̱. ");
INSERT INTO rub_vpl VALUES ("PS44_24","020_44_24","PSA","44","24","24","Hab̯waki otwebi̱si̱ri̱ho? Oteebeera kuwonawona na b̯ujune b̯wetu̱! ");
INSERT INTO rub_vpl VALUES ("PS44_25","020_44_25","PSA","44","25","25","Kubba myozo myetu̱ myehi̱nyi̱ri̱ hansi mwicuucu, nda zeetu̱ zeekweti̱ kwitehe. ");
INSERT INTO rub_vpl VALUES ("PS44_26","020_44_26","PSA","44","26","26","Byoka oi̱ze otujune, otucungure hab̯wa ngonzi zaamu zinene. ");
INSERT INTO rub_vpl VALUES ("PS45_1","020_45_1","PSA","45","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱. Bikukwata ha byakyo birungi. Masikili gya baana ba Koora. Kyembu kya ngonzi. Mutima gwange gwi̱zwi̱ri̱ bigambu birungi binene byakutonda, nkaara zange nkwi̱za kuziweera mukama nzimuganire b̯u̱gani̱ mu kyembu, nka mu̱handi̱i̱ki̱ mutendeke kwakoresya kalaamu. ");
INSERT INTO rub_vpl VALUES ("PS45_2","020_45_2","PSA","45","2","2","Weewe njuruute gi̱caasi̱ngi̱ri̱ mu badulu bensei̱! Bigambu byamu byabbanga bya mbabazi̱, hab̯wakubba Ruhanga aku̱heeri̱ mu̱gi̱sa gwa biro na biro. ");
INSERT INTO rub_vpl VALUES ("PS45_3","020_45_3","PSA","45","3","3","We wa maani, lwala kirooyo kyamu kiloho mpirima, obba wa b̯u̱sobozi̱ kandi wa ki̱ti̱i̱ni̱sa! ");
INSERT INTO rub_vpl VALUES ("PS45_4","020_45_4","PSA","45","4","4","Ai̱ mukama, mu ki̱ti̱i̱ni̱sa kyamu gyendanga noosi̱ngu̱ra! Osi̱ngu̱renge hab̯wa kwemeera ha mananu naakulwaniira b̯winganiza, mukono gwamu gwab̯udyo gwakoranga bintu bya b̯uzira. ");
INSERT INTO rub_vpl VALUES ("PS45_5","020_45_5","PSA","45","5","5","Leka mbasi zaamu zoobi, zi̱tu̱u̱te ha mitima mya banyanzigwa ba mukama, mahanga gagwa hansi mu magulu gaamu. ");
INSERT INTO rub_vpl VALUES ("PS45_6","020_45_6","PSA","45","6","6","Ai̱ Ruhanga, kitebe kyamu kiliicalaho biro na biro, b̯ukama b̯wamu ob̯ulemenge na b̯winganiza, ");
INSERT INTO rub_vpl VALUES ("PS45_7","020_45_7","PSA","45","7","7","Wendya kukora bintu bya b̯winganiza, noonoba kukora bintu bibiibi, kyokyo Ruhanga, Ruhanga waamu aku̱teeri̱ho maku̱ta ga kusemererwa, kukiraho bandi bensei̱. ");
INSERT INTO rub_vpl VALUES ("PS45_8","020_45_8","PSA","45","8","8","Bilwalu byamu bi̱b̯u̱nya kurungi hab̯wa maku̱ta ga migaaju, alosi̱ na kasi̱ya. Mu kikaali kya masyange, mabbwa ga bikwatu bi̱hi̱i̱mi̱sya mahu̱u̱zi̱ gaku̱nyu̱mi̱ra hoi̱. ");
INSERT INTO rub_vpl VALUES ("PS45_9","020_45_9","PSA","45","9","9","Bahara ba bakama boobo bakali̱ baamu ba ki̱ti̱i̱ni̱sa, ha mukono gwamu gwab̯udyo heemereeri̱ho mukaa mukama alweri̱ bilwalu bya zaabbu gya mwʼOfi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS45_10","020_45_10","PSA","45","10","10","Ai̱ muhara, weetegeerya kandi weegwe, webeera nsi gyamu na banyaruganda baamu. ");
INSERT INTO rub_vpl VALUES ("PS45_11","020_45_11","PSA","45","11","11","Mukama akusemererwa mu b̯urungi b̯wamu, mwegwe kubba ali mukama waamu. ");
INSERT INTO rub_vpl VALUES ("PS45_12","020_45_12","PSA","45","12","12","Bantu ba mu rub̯uga lwa Ti̱i̱ro balikuletera bisembu, bagu̱u̱da bakwesengereerye. ");
INSERT INTO rub_vpl VALUES ("PS45_13","020_45_13","PSA","45","13","13","Mu̱kali̱ wa mukama aliswera, mu ki̱si̱i̱ka kyamwe alilwala bilwalu bikore na zaabbu. ");
INSERT INTO rub_vpl VALUES ("PS45_14","020_45_14","PSA","45","14","14","Ndengeeti̱ ngogwo alimu kugab̯uka wu mukama, ndengeeti̱ zi̱i̱ra zikumuhondeera bazi̱ku̱leteeri̱. ");
INSERT INTO rub_vpl VALUES ("PS45_15","020_45_15","PSA","45","15","15","Bali mu kuziherekeera na kusemererwa na masanyu, nizingira kikaali kya mukama. ");
INSERT INTO rub_vpl VALUES ("PS45_16","020_45_16","PSA","45","16","16","Batabani̱ beenyu̱ balibbanga bagwete ba bahaaha baab̯u, mulibafoora bayolo mu nsi gyensei̱. ");
INSERT INTO rub_vpl VALUES ("PS45_17","020_45_17","PSA","45","17","17","Ibara lyamu lyabbanga kyakwi̱zu̱ka ha mi̱hi̱hi̱ myensei̱, nahab̯waki̱kyo mahanga gaaliicala nigakuhaariiza biro na biro. ");
INSERT INTO rub_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱. Zabbu̱li̱ gya baana ba Koora, gikukwatagana nʼAlamoti̱. Kyembu. Ruhanga yooyo b̯webi̱si̱ro na maani geetu̱, eicalaho kutujuna mu b̯uzub̯u. ");
INSERT INTO rub_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","Nahab̯waki̱kyo, nsi nab̯ugyahinduka ti̱tu̱li̱ti̱i̱na, nsahu nab̯uzagwa mwitaka, ");
INSERT INTO rub_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","kubbe kwetyobbolya na kuhuuka kwa meezi̱, nsahu nab̯uzajegeja hab̯wa kuhuuka kwago. ");
INSERT INTO rub_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","Haloho mugira gukasemeza rub̯uga lwa Ruhanga, kiikaru kitongoole kya Waahakyendi̱ Hoi̱ eicaliremwo. ");
INSERT INTO rub_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","Ruhanga eicala hakati̱ mulilwo tululitengeeta, Ruhanga alilujuna na kamambya. ");
INSERT INTO rub_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Mahanga gatab̯u̱ki̱ri̱, makama gagwi̱ri̱, iraka lya Ruhanga libbwatuka, nsi niginyelela, ");
INSERT INTO rub_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Mukama wa mahe eicala natwe, Ruhanga wa Yakobbo yooyo b̯wi̱ru̱ki̱ro b̯wetu̱. ");
INSERT INTO rub_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Mwi̱ze muwone mulimo gwa Mukama, muwone nka kwaku̱hwerekereerya nsi. ");
INSERT INTO rub_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","Amalaho malemu kudwa ku nkangu gya nsi, abinya b̯uta, masumu nagacwacwana, bigaali nabi̱kolereeryaho mworo. ");
INSERT INTO rub_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","“Mwetegeerye kandi mwege gyagya ndi Ruhanga. Mahanga gakwi̱za kumpariiza, nsi gyensei̱ ginyumize.” ");
INSERT INTO rub_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","Mukama wa mahe eicala natwe, Ruhanga wa Yakobbo yooyo b̯wi̱ru̱ki̱ro b̯wetu̱. ");
INSERT INTO rub_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱. Zabbu̱li̱ gya baana ba Koora. Bantu nywensei̱ mu̱ku̱u̱te mu ngalu, Muhaariize Ruhanga na byembu byeiraka likooto byakusemererwa. ");
INSERT INTO rub_vpl VALUES ("PS47_2","020_47_2","PSA","47","2","2","Kubba Mukama, Waahakyendi̱ Hoi̱, asemereeri̱ ku̱ti̱i̱nwa, yooyo mukama wa ki̱ti̱i̱ni̱sa alema nsi gyensei̱. ");
INSERT INTO rub_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","Yaatu̱heeri̱ ku̱si̱ngu̱ra banyanzigwa beetu̱, mahanga gaab̯u gaabba hansi wa magulu geetu̱. ");
INSERT INTO rub_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","Yaatukomeramwo b̯ugwete b̯wetu̱, kyokyo ki̱ti̱i̱ni̱sa kya Yakobbo gi̱yendya gyanyu̱mi̱rwa. ");
INSERT INTO rub_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","Ruhanga atembi̱ri̱ kwakyendi̱ bantu nibakuhaariiza, na maraka ga ngwara zikutoma. ");
INSERT INTO rub_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","Mu̱hi̱i̱me muhaariize Ruhanga! Mu̱hi̱i̱me nimumutenda mukama weetu̱! ");
INSERT INTO rub_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","Kubba Ruhanga eicala Mukama wa nsi gyensei̱, mu̱mu̱haari̱i̱ze na zabbu̱li̱. ");
INSERT INTO rub_vpl VALUES ("PS47_8","020_47_8","PSA","47","8","8","Ruhanga alema mahanga gensei̱, Ruhanga eicaara ha kitebe kyamwe ki̱syanu̱. ");
INSERT INTO rub_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","Balemi̱ beecooka hamwei̱ na bantu ba Ruhanga wa I̱bbu̱rahi̱mu̱ kubba ngab̯u za nsi zili na Ruhanga, yooyo gibahaariiza hoi̱. ");
INSERT INTO rub_vpl VALUES ("PS48_1","020_48_1","PSA","48","1","1","Kyembu. Zabbu̱li̱ gya baana ba Koora. Mukama ali wa maani, asemereeri̱ kuhaariizwa hoi̱, mu rub̯uga lwa Ruhanga weetu̱, na ha lusahu lwamwe lu̱syanu̱. ");
INSERT INTO rub_vpl VALUES ("PS48_2","020_48_2","PSA","48","2","2","Lusahu lwamwe kandi lwa ki̱ti̱i̱ni̱sa, kwokwo kweb̯uga kwa nsi gyensei̱. Lusahu Sayu̱u̱ni̱ hadei mu matemba, rub̯uga lwa Mukama wamaani. ");
INSERT INTO rub_vpl VALUES ("PS48_3","020_48_3","PSA","48","3","3","Ruhanga eicala mu lu̱lwo rub̯uga, yeezolokeerye nka kwali lugo. ");
INSERT INTO rub_vpl VALUES ("PS48_4","020_48_4","PSA","48","4","4","Muwone bakama nka ku̱beesoroozi̱ri̱, hamwei̱ ku̱ru̱mba rub̯uga. ");
INSERT INTO rub_vpl VALUES ("PS48_5","020_48_5","PSA","48","5","5","Bei̱tu̱ b̯u̱baalu̱weeni̱, beeru̱ndu̱ki̱ri̱ bei̱ru̱ka. ");
INSERT INTO rub_vpl VALUES ("PS48_6","020_48_6","PSA","48","6","6","Baakankeeni̱ nka mu̱kali̱ akwati̱i̱rwe bisa bya kubyala, ");
INSERT INTO rub_vpl VALUES ("PS48_7","020_48_7","PSA","48","7","7","hab̯wa bbuukuulu kuruga b̯uhulukalyoba waati̱ri̱ maati̱ ga Tarasi̱i̱si̱ mwitaka. ");
INSERT INTO rub_vpl VALUES ("PS48_8","020_48_8","PSA","48","8","8","Twegwi̱ri̱, kandi hataati̱ tu̱ki̱weeni̱, mu rub̯uga lwa Ruhanga weetu̱, Mukama wa mahe, lulu lwolwo rub̯uga lwa Ruhanga, ali̱caalyaho biro byensei̱. ");
INSERT INTO rub_vpl VALUES ("PS48_9","020_48_9","PSA","48","9","9","Ai̱ Ruhanga, b̯utubba mu nnyu̱mba gyamu ni̱tu̱ku̱ku̱ramya, tuteekereza ha ngonzi zaamu zinene. ");
INSERT INTO rub_vpl VALUES ("PS48_10","020_48_10","PSA","48","10","10","Ibara lyamu li̱ku̱mi̱ri̱ kandi bakukuhaariiza mu nsi gyensei̱, mukono gwamu gwa b̯ulyo guli gu̱si̱ngu̱zi̱. ");
INSERT INTO rub_vpl VALUES ("PS48_11","020_48_11","PSA","48","11","11","Lusahu lwa Sayu̱u̱ni̱ lu̱kwi̱za kweb̯uga, Yu̱da gyensei̱ gisemererwe kubba oleti̱ri̱ho b̯winganiza. ");
INSERT INTO rub_vpl VALUES ("PS48_12","020_48_12","PSA","48","12","12","Twali̱bati̱ri̱ mu Sayu̱u̱ni̱ twelogoolya, twabala minaara myaho. ");
INSERT INTO rub_vpl VALUES ("PS48_13","020_48_13","PSA","48","13","13","Twawona bi̱si̱i̱ka byalwo byamaani, b̯uli lugo tuludweho. Mwomwo oliweera, mi̱hi̱hi̱ mi̱kwi̱za nti, ");
INSERT INTO rub_vpl VALUES ("PS48_14","020_48_14","PSA","48","14","14","“Kwokwo Ruhanga weetu̱ eicala biro byensei̱, aliicala na twebembera.” ");
INSERT INTO rub_vpl VALUES ("PS49_1","020_49_1","PSA","49","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱. Zabbu̱li̱ gya baana ba Koora. Bantu nywensei̱ mwetegeerye, mwegwe kinkukoba nywensei̱ bali hansi, ");
INSERT INTO rub_vpl VALUES ("PS49_2","020_49_2","PSA","49","2","2","wa ki̱ti̱i̱ni̱sa na wa hansi, mu̱gu̱u̱da rundi museege. ");
INSERT INTO rub_vpl VALUES ("PS49_3","020_49_3","PSA","49","3","3","Bimbaza bibba bya magezi̱, kandi biteekerezu byange bibba na makuru. ");
INSERT INTO rub_vpl VALUES ("PS49_4","020_49_4","PSA","49","4","4","Mapokopo gange nyaagei̱calyanga ku ngeera, bi̱koi̱kyo byange ni̱mbi̱ti̱ra mu kukuuta ndi̱ngi̱di̱. ");
INSERT INTO rub_vpl VALUES ("PS49_5","020_49_5","PSA","49","5","5","B̯u̱ti̱i̱ni̱ b̯unkwatira ki mu b̯wi̱re b̯wa b̯ujune, banyanzigwa b̯ubabba banyeelogoleerye. ");
INSERT INTO rub_vpl VALUES ("PS49_6","020_49_6","PSA","49","6","6","Bab̯wo beesiga b̯u̱gu̱u̱da b̯wab̯u, nibehaariizisya b̯unene b̯weitungu lyab̯u. ");
INSERT INTO rub_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","7","Mu mananu tihaloho muntu akusobora kujuna wondi, rundi kusasulira muhendu gwa b̯womi b̯wamu hali Ruhanga. ");
INSERT INTO rub_vpl VALUES ("PS49_8","020_49_8","PSA","49","8","8","Kili kya muhendu gunene, kwi̱ryaho b̯womi b̯wamu, tooli na kyokusobora kusasula Ruhanga akadweb̯wa, ");
INSERT INTO rub_vpl VALUES ("PS49_9","020_49_9","PSA","49","9","9","we kwicala nooli mwomi biro byensei̱, kandi okakena lu̱ku̱u̱. ");
INSERT INTO rub_vpl VALUES ("PS49_10","020_49_10","PSA","49","10","10","Kubba tuwona ba magezi̱ ni̱bakwa, mpwi̱se na batakukenga de ni̱bakwa, kasi nsimbi zaab̯u nizisigala kudi̱b̯wa bandi. ");
INSERT INTO rub_vpl VALUES ("PS49_11","020_49_11","PSA","49","11","11","Nyanga zoozo zi̱i̱ra kubba maka gaab̯u ga biro na biro, nab̯ubakabba baali na matehe gaab̯u hab̯wab̯u. ");
INSERT INTO rub_vpl VALUES ("PS49_12","020_49_12","PSA","49","12","12","Muntu mu ki̱ti̱i̱ni̱sa kyamwe kya b̯untu talisigalaho, eisana nka bisolo bihwerekeera. ");
INSERT INTO rub_vpl VALUES ("PS49_13","020_49_13","PSA","49","13","13","Bibi byobyo bikora mpwi̱se, na beesiga bigambu bya badoma, ");
INSERT INTO rub_vpl VALUES ("PS49_14","020_49_14","PSA","49","14","14","nka ntaama zi̱li̱ndi̱ri̱i̱ri̱ ku̱kwa, lu̱ku̱u̱ lu̱kwi̱za ku̱bali̱i̱sya, lubagoromore mu nyanga. Kasu̱mi̱ b̯ukalidwa, bantu ba Ruhanga balibafuga, babahwerekereerye balemwe kwicala mu makaa gaab̯u garungi. ");
INSERT INTO rub_vpl VALUES ("PS49_15","020_49_15","PSA","49","15","15","Bei̱tu̱ Ruhanga alincungura, anjune maani ga lu̱ku̱u̱. ");
INSERT INTO rub_vpl VALUES ("PS49_16","020_49_16","PSA","49","16","16","Mitima myenyu̱ mitalyalyatiranga itungu lya muntu wondi rundi ki̱ti̱i̱ni̱sa kya makaa gaamwe kweyongera. ");
INSERT INTO rub_vpl VALUES ("PS49_17","020_49_17","PSA","49","17","17","Kubba handaki bakwe itungu lyab̯u lyensei̱ bali̱ti̱ge i̱nyu̱ma lilemwe kumuhondira. ");
INSERT INTO rub_vpl VALUES ("PS49_18","020_49_18","PSA","49","18","18","Twe bantu tu̱si̱i̱mwa b̯utubba tu̱koori̱ birungi, twensei̱ tusemererwa kubba boomi. ");
INSERT INTO rub_vpl VALUES ("PS49_19","020_49_19","PSA","49","19","19","Bei̱tu̱ tu̱kwi̱za kugyenda kuzumu, hali bahaaha beetu̱, nitub̯ula kwi̱ra kuwonaho, kyererezi̱. ");
INSERT INTO rub_vpl VALUES ("PS49_20","020_49_20","PSA","49","20","20","Ki̱ti̱i̱ni̱sa kyetu̱ kya b̯untu ni̱ki̱syeraho, tuli nka bisolo bi̱kwa. ");
INSERT INTO rub_vpl VALUES ("PS50_1","020_50_1","PSA","50","1","1","Zabbu̱li̱ gyʼAsafi̱. Yooyo Waamaani̱, Mukama Ruhanga abaza niyeeta bantu ba nsi gyensei̱, kuruga b̯uhulukalyoba kudwa b̯ugwalyoba. ");
INSERT INTO rub_vpl VALUES ("PS50_2","020_50_2","PSA","50","2","2","Ruhanga amuluka mu Sayu̱u̱ni̱, rub̯uga lukukirayo mu b̯urungi. ");
INSERT INTO rub_vpl VALUES ("PS50_3","020_50_3","PSA","50","3","3","Ruhanga weetu̱ wabba nakwi̱za, ti̱yeti̱keera, yebemberwa kingeere kya mworo gu̱kwokya, yeelogoleerwe bbuukuulu. ");
INSERT INTO rub_vpl VALUES ("PS50_4","020_50_4","PSA","50","4","4","Yeeta iguru na nsi kugaba b̯wakei̱so, muwone alimukucwera bantu baamwe musangu. ");
INSERT INTO rub_vpl VALUES ("PS50_5","020_50_5","PSA","50","5","5","Akukoba yati, “Mwesu̱me hali gi̱ya nywe beesigwa bange, banyakukora na gya ndagaanu gya kihongwa.” ");
INSERT INTO rub_vpl VALUES ("PS50_6","020_50_6","PSA","50","6","6","Iguru lirangiira mananu gaamwe, Ruhanga yankei ali mu̱cwi̱ wa musangu! ");
INSERT INTO rub_vpl VALUES ("PS50_7","020_50_7","PSA","50","7","7","Bantu bange ndi Ruhanga! I̱saleeri̱ ndi Ruhanga waamu, weegwa binkukuweera uwe. ");
INSERT INTO rub_vpl VALUES ("PS50_8","020_50_8","PSA","50","8","8","Ti̱nku̱ku̱zi̱nda hab̯wa bihongwa byamu, rundi bihongwa byokye byompongera, ");
INSERT INTO rub_vpl VALUES ("PS50_9","020_50_9","PSA","50","9","9","ti̱ki̱kwetagi̱sya gya kutwala nnumi rundi mbu̱li̱ za mu mali̱i̱si̱i̱ryo gaamu. ");
INSERT INTO rub_vpl VALUES ("PS50_10","020_50_10","PSA","50","10","10","Kubba b̯uli kisolo kyensei̱ kya mwihamba kili kyange, na magana ga nte ha nsahu nku̱mi̱ na nku̱mi̱. ");
INSERT INTO rub_vpl VALUES ("PS50_11","020_50_11","PSA","50","11","11","Nkyegi̱ri̱ bi̱nyoni̱ byensei̱ bya ha nsahu, na byensei̱ bilibatira mwihamba bili byange, ");
INSERT INTO rub_vpl VALUES ("PS50_12","020_50_12","PSA","50","12","12","kakubba nyali nzala, nyakaku̱weereeri̱ kwahi, hab̯wakubba nsi na bigilimwo byensei̱ byange. ");
INSERT INTO rub_vpl VALUES ("PS50_13","020_50_13","PSA","50","13","13","Okutekereza ndya nyama gya nnumi zi̱mu̱hongi̱ri̱, rundi nnywe ibbanga lya mbu̱li̱? ");
INSERT INTO rub_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","14","Gabi̱ranga Ruhanga kihongwa kya ku̱si̱i̱ma, kandi noodosereerya biragaanu byamu na yogwo Waahakyendi̱ Hoi̱, ");
INSERT INTO rub_vpl VALUES ("PS50_15","020_50_15","PSA","50","15","15","kasi onkunge nooli mu kizub̯u, nkwi̱za kukujuna kandi olimpariiza. ");
INSERT INTO rub_vpl VALUES ("PS50_16","020_50_16","PSA","50","16","16","Bei̱tu̱ hali nkori̱ za bibii Ruhanga akukoba yati, “Oli kwahi na b̯ugabe b̯wa ku̱hi̱i̱ma biragiro byange, rundi kubaza ha ndagaanu gyange! ");
INSERT INTO rub_vpl VALUES ("PS50_17","020_50_17","PSA","50","17","17","Hab̯wakubba onoba kulamba kwange kandi bigambu byange obikasuka ku̱di̱. ");
INSERT INTO rub_vpl VALUES ("PS50_18","020_50_18","PSA","50","18","18","Woowona mwi̱bi̱ yooyo noonywana nayo. Kandi oicala weekweti̱ na benzi̱. ");
INSERT INTO rub_vpl VALUES ("PS50_19","020_50_19","PSA","50","19","19","“Kanwa kaamu okakoresya bibiibi, kandi kalimi kaamu nikatara b̯u̱gobya. ");
INSERT INTO rub_vpl VALUES ("PS50_20","020_50_20","PSA","50","20","20","Weheeri̱yo kunyegeera banyaruganda baamu, noosensegula mwana wa maawu. ");
INSERT INTO rub_vpl VALUES ("PS50_21","020_50_21","PSA","50","21","21","Bibi bintu byokoori̱, gya nceeri̱ mbyetekereeri̱, waatekerezengi̱ naagya nyaali nka we. Bei̱tu̱ hataati̱ gya ndimu kukulamba nsobi̱ zaamu ni̱nzi̱kwolokya. ");
INSERT INTO rub_vpl VALUES ("PS50_22","020_50_22","PSA","50","22","22","“Mwezi̱remwo nywensei̱ bakwebeera Ruhanga, kitali ki̱kyo nkwi̱za kubahwerekereerya mulemwe na yaabacungura. ");
INSERT INTO rub_vpl VALUES ("PS50_23","020_50_23","PSA","50","23","23","Muntu agaba kihongwa kya ku̱nsi̱i̱ma abba anteri̱mwo ki̱ti̱i̱ni̱sa, yogwo akora birungi, nyaamwolokyanga kujuna kwa Ruhanga” ");
INSERT INTO rub_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱. Zabbu̱li̱ gya Dau̱di̱. Nasani̱ mu̱ragu̱ri̱ b̯u̱yeezi̱ri̱ hali Dau̱di̱ amaari̱ kukora b̯wenzi̱ na Bbasebba. Ai̱ Ruhanga, ngiira kisa, hab̯wa ngonzi zaamu zinene, na hab̯wa kuganyira kwamu kwa maani ntoolaho b̯ubiibi b̯wange. ");
INSERT INTO rub_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Onaabi̱i̱rye ki̱mwei̱ nduge mu b̯ubiibi b̯wange, kandi onsyani̱e kuruga mu kibii kyange! ");
INSERT INTO rub_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Kubba nyeetegeri̱i̱ze b̯ubiibi b̯wange, kandi kibii kyange kiicala nikimpondeera. ");
INSERT INTO rub_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Hali we, weewe musa gi̱nsobereerye, kandi nyakora bibii mu mei̱so gaamu, aleke oicale nooli wa mananu wakabazanga, bigambu byamu byolokye nka kwoli wa mananu, aleke osi̱nge bab̯wo bokucwera musangu. ");
INSERT INTO rub_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Wona nyaabyali̱i̱rwe mu kuhenera, kandi nda ginyakumbyala, mmaama yaagyemeti̱ri̱ mu kibii. ");
INSERT INTO rub_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Wona, weegondezera mu mananu gabba mu mutima gwa muntu, kandi onzegesya magezi̱ ga nsita za mutima gwange. ");
INSERT INTO rub_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Ntoolaho kibii kyange aleke nsemere, onaabye nsyane kukiraho pamba. ");
INSERT INTO rub_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Leka nyegwe kusemererwa na masanyu, aleke maku̱ha gobi̱nyi̱ri̱ gasemererwe. ");
INSERT INTO rub_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Bi̱sa mei̱so gaamu galeke kuwona bibii byange, kandi ontooleho ki̱mwei̱ b̯ubiibi b̯wange. ");
INSERT INTO rub_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","Ai̱ Ruhanga ompangemwo mutima gukwegwa, kandi onteekemwo mwozo guhyaka. ");
INSERT INTO rub_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Otambinga kuruga mu mei̱so gaamu, otantoolaho mwozo gwamu gu̱syanu̱. ");
INSERT INTO rub_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Nzi̱ri̱i̱rya kusemererwa kwa kujunwa kwamu, kandi ompe mutima gu̱ku̱kwegwa. ");
INSERT INTO rub_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Mwomwo ndyegesya babiibi mihanda myamu, aleke batandike kukuhondera. ");
INSERT INTO rub_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","Ai̱ Ruhanga, oncungure kuruga mu kibii kya b̯wi̱ti̱, ai̱ Ruhanga wa kujunwa kwange, kandi kalimi kange kali̱hi̱i̱ma na maani ha mananu gaamu. ");
INSERT INTO rub_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","Ai̱ Mukama mbuula mu̱nwa, gusobore kukuhaariiza. ");
INSERT INTO rub_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Kubba tosemererwa mu kihongwa, rundi nyaku̱bbeeri̱ nki̱ku̱heeri̱. Bihongwa byokye tibilikusemeera. ");
INSERT INTO rub_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","Bihongwa bya Ruhanga gwogwo mutima gu̱kwezi̱ramwo ai̱ Ruhanga mutima gu̱kwezi̱ramwo kandi gweb̯u̱ndaazi̱ toligugaya. ");
INSERT INTO rub_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Ai̱ Ruhanga bba na kisa na rub̯uga Sayu̱u̱ni̱, bimba b̯uhyaka bi̱si̱i̱ka bya Yeru̱salemu̱. ");
INSERT INTO rub_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Mwomwo olisemererwa mu bihongwa bya mananu, kihongwa kyensei̱ kyokye kikusemeze, kasi nnumi bazihonge ha kyoto kyamu. ");
INSERT INTO rub_vpl VALUES ("PS52_1","020_52_1","PSA","52","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱. Masikili gya Dau̱di̱. B̯wi̱re b̯wa Dyego Mu̱nyʼEdomu̱ agyendi̱ri̱ hali Sau̱lo, amuweera yati, “Dau̱di̱ agyendi̱ri̱ ha nnyu̱mba gya Ahi̱mereki̱.” Ai̱ we muntu wa maani, hab̯waki okwempankisya bibii? Ngonzi za Ruhanga zinene ziicalaho biro byensei̱. ");
INSERT INTO rub_vpl VALUES ("PS52_2","020_52_2","PSA","52","2","2","Okutegeka ku̱hwerekereerya bantu banene, Kalimi kaamu kabaza b̯u̱gobya nka nsone gyobi. ");
INSERT INTO rub_vpl VALUES ("PS52_3","020_52_3","PSA","52","3","3","Wendya b̯ubiibi kukira b̯urungi, na kubaza bya b̯u̱gobya kukira mananu. ");
INSERT INTO rub_vpl VALUES ("PS52_4","020_52_4","PSA","52","4","4","Wendya bigambu bikuhuutaaza, ai̱ kalimi kagobya! ");
INSERT INTO rub_vpl VALUES ("PS52_5","020_52_5","PSA","52","5","5","Bei̱tu̱ Ruhanga alikucwacwana akugume hansi hooho oicale biro byensei̱, alikusab̯ula kandi aku̱tooleho b̯wicalu b̯wamu, kandi aku̱ku̱pu̱le kuruga mu nsi gya boomi. ");
INSERT INTO rub_vpl VALUES ("PS52_6","020_52_6","PSA","52","6","6","Bantu barungi baliwona ki̱kyo bati̱i̱ne, kandi bali̱mu̱sekereerya nibakoba. ");
INSERT INTO rub_vpl VALUES ("PS52_7","020_52_7","PSA","52","7","7","“Wona yogo, munyakusuula Ruhanga akabba b̯wi̱ru̱ki̱ro b̯wamwe, kyonkei akacwamwo kwesiga b̯unene b̯weitungu lye, akasigala mu̱si̱gi̱ku̱ kuraba mu ku̱zi̱ndi̱ri̱za bei̱ra.” ");
INSERT INTO rub_vpl VALUES ("PS52_8","020_52_8","PSA","52","8","8","Bei̱tu̱ ndi nka musaali mu̱zayi̱tu̱u̱ni̱ gubisi, gukunyengetera mu nnyu̱mba gya Ruhanga. Nyesiga ngonzi zinene za Ruhanga biro byensei̱. ");
INSERT INTO rub_vpl VALUES ("PS52_9","020_52_9","PSA","52","9","9","Nkwi̱za ku̱ku̱si̱i̱manga Ruhanga biro byensei̱, hab̯wa ki̱kyo kyokoori̱, nyaatanga ku̱ni̱hi̱ra kwange muli we hab̯wa ibara lyamu lirungi, nyaakuhariizanga mu mei̱so ga bantu beesigwa. ");
INSERT INTO rub_vpl VALUES ("PS53_1","020_53_1","PSA","53","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱. Mwiraka lya Mahalasa. Masikili gya Dau̱di̱. Mudoma ateekereza naakoba yati, “Ruhanga eicala waahi.” Bantu ba yatyo babba bagwagwa, bakora bikorwa bibiibi, tihalohoona noomwei̱ akora birungi. ");
INSERT INTO rub_vpl VALUES ("PS53_2","020_53_2","PSA","53","2","2","Ruhanga wa mwiguru waalingiira bantu ba mu nsi, kuwona b̯uhakabbahoona akwetegereza, b̯uhakabbahoona aramya Ruhanga. ");
INSERT INTO rub_vpl VALUES ("PS53_3","020_53_3","PSA","53","3","3","Bensei̱ bahabi̱ri̱, baabba bensei̱ hamwei̱ bagwagwa, tihalohoona noomwei̱ akora kirungi, waahi kadi noomwei̱. ");
INSERT INTO rub_vpl VALUES ("PS53_4","020_53_4","PSA","53","4","4","Zi̱zo nkori̱ za bibii tizigira kwetegereza, bamalaho bantu bange nka bakudya bidyo, tibafaaho kusaba Ruhanga. ");
INSERT INTO rub_vpl VALUES ("PS53_5","020_53_5","PSA","53","5","5","Bakukankana na b̯u̱ti̱i̱ni̱, hatalohoona kyaku̱ti̱i̱na, kubba Ruhanga acwacwana maku̱ha ga yogwo aku̱ru̱mba, obaswazi̱ri̱, kubba Ruhanga abanu̱gi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS53_6","020_53_6","PSA","53","6","6","Ee, nyaakwendeerye kujunwa kwʼI̱saleeri̱ kuruge mu Sayu̱u̱ni̱! Ruhanga aha bantu baamwe mu̱gi̱sa, leka Yakobbo asemererwe, leka I̱saleeri̱ gijaguze. ");
INSERT INTO rub_vpl VALUES ("PS54_1","020_54_1","PSA","54","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱. Ni̱bakoresya kikwatu kya mahu̱u̱zi̱. Masikili gya Dau̱di̱. Zi̱faati̱ b̯u̱baagyendi̱ri̱ kandi baweera Sau̱lo yati, “Dau̱di̱ yeebi̱si̱ri̱ muli twe.” Ai̱ Ruhanga, njuna hab̯wa ibara lyamu, kandi ontooleho musangu hab̯wa maani gaamu. ");
INSERT INTO rub_vpl VALUES ("PS54_2","020_54_2","PSA","54","2","2","Ai̱ Ruhanga, weegwa kusaba kwange, tegera mapokopo bigambu bya kanwa kange. ");
INSERT INTO rub_vpl VALUES ("PS54_3","020_54_3","PSA","54","3","3","Hab̯wakubba bamyehaariizo bambyokereeri̱, batemu bakwendya ku̱nzi̱ta, kubba ti̱bati̱i̱na Ruhanga. ");
INSERT INTO rub_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","Wona, Ruhanga yooyo Mu̱ju̱ni̱ wange, Mukama ali mpagi̱ gya b̯womi b̯wange. ");
INSERT INTO rub_vpl VALUES ("PS54_5","020_54_5","PSA","54","5","5","Banyanzigwa bange ali̱bei̱ri̱i̱rya b̯ubiibi b̯wab̯u, hab̯wa b̯wesigwa b̯wamwo bahwerekeereerya. ");
INSERT INTO rub_vpl VALUES ("PS54_6","020_54_6","PSA","54","6","6","Ai̱ Mukama nyaakuhongiranga kihongwa nsemereerwe, nyaasi̱i̱manga ibara lyamu kubba lili lirungi. ");
INSERT INTO rub_vpl VALUES ("PS54_7","020_54_7","PSA","54","7","7","Hab̯wakubba wancu̱ngu̱u̱ri̱ kuruga mu b̯ujune b̯wensei̱, mei̱so gange gaweeni̱ banyanzigwa bange basi̱ngi̱i̱rwe. ");
INSERT INTO rub_vpl VALUES ("PS55_1","020_55_1","PSA","55","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱. Ni̱bakoresya kikwatu kya mahu̱u̱zi̱. Masikili gya Dau̱di̱. Ai̱ Ruhanga, weegwa kusaba kwange, kandi otanyebi̱si̱i̱ra ninkukusaba kisa! ");
INSERT INTO rub_vpl VALUES ("PS55_2","020_55_2","PSA","55","2","2","Nzegwa, kandi onzi̱remwo, b̯ujune b̯wange b̯u̱nki̱i̱ri̱, mpu̱mwi̱ri̱ kwahi kandi nkulira, ");
INSERT INTO rub_vpl VALUES ("PS55_3","020_55_3","PSA","55","3","3","hab̯wa rugambu lwa banyanzigwa, na ku̱wonawonesya kwa babiibi. Kubba bandeteeri̱ kuwonawona, kandi mu ki̱ni̱ga batara ntaru nagya. ");
INSERT INTO rub_vpl VALUES ("PS55_4","020_55_4","PSA","55","4","4","Mutima gwange guli na b̯ujune, b̯u̱ti̱i̱ni̱ b̯wa lu̱ku̱u̱ b̯u̱ndoori̱ho. ");
INSERT INTO rub_vpl VALUES ("PS55_5","020_55_5","PSA","55","5","5","B̯u̱ti̱i̱ni̱ na kukankana bi̱nzi̱zi̱i̱ri̱, ndimu kujegemeera. ");
INSERT INTO rub_vpl VALUES ("PS55_6","020_55_6","PSA","55","6","6","Kwokwo kukoba yati, “Haa! Kabbengi̱ nyaalingi na bimpaha nka kolomi̱, nyaku̱du̱ndu̱u̱ki̱ri̱ aleke ntunge b̯uhuumuuro. ");
INSERT INTO rub_vpl VALUES ("PS55_7","020_55_7","PSA","55","7","7","Nyaku̱haareeri̱ ningyenda hadei, nyaku̱gonyeere mwirungu. ");
INSERT INTO rub_vpl VALUES ("PS55_8","020_55_8","PSA","55","8","8","Nyakwangu̱hi̱ri̱ ku̱toolya b̯wicalu b̯urungi, nsobore kukena bihehu bya nnobi̱.” ");
INSERT INTO rub_vpl VALUES ("PS55_9","020_55_9","PSA","55","9","9","Ai̱ Mukama bazi̱kye obahu̱kani̱e b̯ulimi b̯wab̯u batakoragana, kubba nkuwona b̯wemi̱ na kuzongoba nikuli mu rub̯uga. ");
INSERT INTO rub_vpl VALUES ("PS55_10","020_55_10","PSA","55","10","10","Bagyenda ni̱belogoleerya bi̱si̱i̱ka byalwo mwinsi nei̱jolo, mu rub̯uga lu̱lwo heicalamwo b̯ubiibi na kabii. ");
INSERT INTO rub_vpl VALUES ("PS55_11","020_55_11","PSA","55","11","11","Hakati̱ mu rub̯uga gafooki̱ri̱ makandi, kumigiriza na nkora za b̯u̱gobya tibiruga mu b̯utali b̯walwo. ");
INSERT INTO rub_vpl VALUES ("PS55_12","020_55_12","PSA","55","12","12","Kabbengi̱ baali banyanzigwa boobo nibaku̱mparaarya, ki̱kyo nyaku̱ki̱gu̱mi̱i̱ri̱, kabbengi̱ baali bampi̱i̱gani̱sya boobo bambyokereeri̱, rundi nyaku̱bebi̱si̱ri̱ho. ");
INSERT INTO rub_vpl VALUES ("PS55_13","020_55_13","PSA","55","13","13","Bei̱tu̱ oli weewe muntu mwi̱ra wange, munywani wange wa kulusegere. ");
INSERT INTO rub_vpl VALUES ("PS55_14","020_55_14","PSA","55","14","14","Yogwo gi̱twanyu̱myengi̱ nayo ki̱mwei̱, nitukukumba hamwei̱ na bantu banene kugyenda mu nnyu̱mba gya Ruhanga. ");
INSERT INTO rub_vpl VALUES ("PS55_15","020_55_15","PSA","55","15","15","Leka lu̱ku̱u̱ lwi̱be b̯wi̱bi̱ banyanzigwa bange batakwega, bagoromorwe kuzumu mu nyanga nibali boomi, kubba bibii bi̱tu̱ngi̱ri̱ b̯uhuumuuro mu bo. ");
INSERT INTO rub_vpl VALUES ("PS55_16","020_55_16","PSA","55","16","16","Bei̱tu̱ gya, nsaba Ruhanga, kandi Mukama alinjuna. ");
INSERT INTO rub_vpl VALUES ("PS55_17","020_55_17","PSA","55","17","17","Nsaba nintaaga, mwakya karei, mwinsi na joojolo, kandi yeegwambe iraka lyange. ");
INSERT INTO rub_vpl VALUES ("PS55_18","020_55_18","PSA","55","18","18","Ancungura ntahu̱teeri̱ na kuhutaara kuruga mu ntaru zibba zi̱mbyokereeri̱, nab̯uhakabbaho banene baku̱ndwani̱sya. ");
INSERT INTO rub_vpl VALUES ("PS55_19","020_55_19","PSA","55","19","19","Ruhanga yogwo mukama wa biro byensei̱, Ruhanga alinzegwa kandi abab̯u̱ndaaze, hab̯wa bikorwa byab̯u bya b̯u̱jeemu̱. ");
INSERT INTO rub_vpl VALUES ("PS55_20","020_55_20","PSA","55","20","20","Mwi̱ra wange yaaru̱mbi̱ri̱ banywanwe yaabinya ndagaanu gye. ");
INSERT INTO rub_vpl VALUES ("PS55_21","020_55_21","PSA","55","21","21","Rubazu lwamwe lwalingi lu̱heheeru̱ nka maku̱ta, bei̱tu̱ mutima gwamwe gwi̱zwi̱ri̱ b̯ulemu, bigambu byamwe byalingi byorob̯u̱ kukira maku̱ta, bei̱tu̱ kandi nibikusala nka nsone mpirima. ");
INSERT INTO rub_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","Bizib̯u byamu obikwatyenge Mukama yooyo alikulinda, talikiriza bamananu baamwe kutengeeta. ");
INSERT INTO rub_vpl VALUES ("PS55_23","020_55_23","PSA","55","23","23","Bei̱tu̱ we, ai̱ Ruhanga, waabagoromoranga hansi mu ki̱i̱na kya kuhwerekeera, badulu batemu na bagobya, tibalihangaara kadi na kicweka kya kiro, bei̱tu̱ gya ndikwesiga. ");
INSERT INTO rub_vpl VALUES ("PS56_1","020_56_1","PSA","56","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱. Mwiraka “Kolome alimukuliriira ku musaali gwa hadei.” Zabbu̱li̱ gya Dau̱di̱. Bafi̱ri̱si̱i̱ti̱ b̯u̱baamu̱ru̱mbi̱ri̱ mu Gaza. Ai̱ Ruhanga nkwatirwa kisa, kubba banyanzigwa bange bandu̱mba b̯wi̱re b̯wensei̱. ");
INSERT INTO rub_vpl VALUES ("PS56_2","020_56_2","PSA","56","2","2","Nkuharanwa i̱jolo na mwinsi, banene baku̱ndwani̱sya na myehaariizo. ");
INSERT INTO rub_vpl VALUES ("PS56_3","020_56_3","PSA","56","3","3","B̯umba nti̱ni̱ri̱, kwikiriza nkuta muli weewe. ");
INSERT INTO rub_vpl VALUES ("PS56_4","020_56_4","PSA","56","4","4","Mu Ruhanga, wakigambu kimpaariiza, Ruhanga yooyo ginyeesiga, ti̱ndi̱ti̱i̱na. Muntu akusobora kunkora ki? ");
INSERT INTO rub_vpl VALUES ("PS56_5","020_56_5","PSA","56","5","5","Badi̱bya bigyendeerwa byange biro byensei̱, beicala nibantekerezaho b̯ubiibi b̯usa. ");
INSERT INTO rub_vpl VALUES ("PS56_6","020_56_6","PSA","56","6","6","Beicala nibantata ni̱bantolereerya b̯uli hankagyendi̱ri̱, beetegeki̱ri̱ ku̱nzi̱ta b̯wi̱ti̱. ");
INSERT INTO rub_vpl VALUES ("PS56_7","020_56_7","PSA","56","7","7","Ai̱ Ruhanga obafubire hab̯wa bibii byab̯u, hab̯wa ki̱ni̱ga kyamu balemwe kukena. ");
INSERT INTO rub_vpl VALUES ("PS56_8","020_56_8","PSA","56","8","8","Weegi̱ri̱ nka kunkuwonawona, mali̱ga gange waagasoroozi̱ri̱ mu cupa gyamu. Toli weewe waagahandi̱i̱ki̱ri̱ mu kitabbu kyamu? ");
INSERT INTO rub_vpl VALUES ("PS56_9","020_56_9","PSA","56","9","9","Kiro kindikwetiramwo, banyanzigwa bange bali̱singu̱rwa, hooho ndyetegereza nti Ruhanga ali na gya. ");
INSERT INTO rub_vpl VALUES ("PS56_10","020_56_10","PSA","56","10","10","Ruhanga, nkuhaariiza hab̯wa miragu myamu, Mukama, nkuhaariiza hab̯wa miragu myamu. ");
INSERT INTO rub_vpl VALUES ("PS56_11","020_56_11","PSA","56","11","11","Ruhanga yooyo ginyeesiga, ti̱nkwi̱za ku̱ti̱i̱na. Muntu akusobora kunkora kyani? ");
INSERT INTO rub_vpl VALUES ("PS56_12","020_56_12","PSA","56","12","12","Ai̱ Ruhanga, nyaarahi̱i̱ri̱ mu mei̱so gaamu, nkwi̱za kukuha kihongwa kya ku̱ku̱si̱i̱ma. ");
INSERT INTO rub_vpl VALUES ("PS56_13","020_56_13","PSA","56","13","13","Kubba oncu̱ngu̱u̱ri̱ kuruga mu lu̱ku̱u̱, na magulu gange b̯utagwa, kwokwo nsobore kulibatira mu mei̱so ga Ruhanga, mu kyererezi̱ kya b̯womi. ");
INSERT INTO rub_vpl VALUES ("PS57_1","020_57_1","PSA","57","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱. Gi̱hi̱i̱mwe mwiraka lya, “Otahwerekereerya.” Zabbu̱li̱ gya Dau̱di̱. B̯u̱yeezi̱bi̱ri̱i̱ri̱ Sau̱lo na mu b̯wingira. Ai̱ Ruhanga ngiira kisa, ngiira kisa, kubba muli we hooho b̯womi wange b̯webi̱si̱ra, mu̱tu̱ntu̱lu̱ gwa bimpaha byamu gwogwo gukundinda, ku̱doosya kumalika kwa ki̱heb̯u̱ kya kuhwerekeera. ");
INSERT INTO rub_vpl VALUES ("PS57_2","020_57_2","PSA","57","2","2","Nsaba Ruhanga, Waahakyendi̱ Hoi̱, Ruhanga yogwo adoosereerya byabba antegekeeri̱. ");
INSERT INTO rub_vpl VALUES ("PS57_3","020_57_3","PSA","57","3","3","Asi̱ri̱mu̱ka kuruga mwiguru kandi nanjuna, ali̱kwati̱sya nsoni̱ yogwo akunyeb̯ugira. Ruhanga ali̱si̱ndi̱ka ngonzi zaamwe zinene na mananu gaamwe! ");
INSERT INTO rub_vpl VALUES ("PS57_4","020_57_4","PSA","57","4","4","Ndi hakati̱ mu ntali, ndeeri̱ hakati̱ wa misege, badulu bali na meino gakwisana nka masumu na mbasi, banyab̯ulimi b̯wab̯u b̯uli nka mpirima gyobi. ");
INSERT INTO rub_vpl VALUES ("PS57_5","020_57_5","PSA","57","5","5","Ai̱ Ruhanga, ohaariizwe hakyendi̱ weiguru! Leka ki̱ti̱i̱ni̱sa kyamu kibbe mu nsi gyensei̱. ");
INSERT INTO rub_vpl VALUES ("PS57_6","020_57_6","PSA","57","6","6","Bantegi̱ri̱ mutegu kunkwata, mutima gwange gwehi̱nya, muhanda gwange bali̱mi̱ri̱mwo b̯u̱hya, bei̱tu̱ bab̯u̱gwi̱ri̱mwo bankei. ");
INSERT INTO rub_vpl VALUES ("PS57_7","020_57_7","PSA","57","7","7","Ai̱ Ruhanga, mutima gwange guli gu̱si̱gi̱ku̱ kandi tiguhinduhinduka! Nku̱hi̱i̱ma byembu birungi bya kukuhaariiza! ");
INSERT INTO rub_vpl VALUES ("PS57_8","020_57_8","PSA","57","8","8","Si̱si̱mu̱ka, ki̱ti̱i̱ni̱sa kyange! Ai̱ ki̱dongo na ndi̱ngi̱di̱ mu̱byoke, nku̱si̱si̱mu̱ka na mambya. ");
INSERT INTO rub_vpl VALUES ("PS57_9","020_57_9","PSA","57","9","9","Ai̱ Mukama, nku̱ku̱si̱i̱ma mu bantu, nku̱ku̱hi̱i̱mi̱ra kukuhaariiza mu mahanga, ");
INSERT INTO rub_vpl VALUES ("PS57_10","020_57_10","PSA","57","10","10","kubba ngonzi zaamu zinene kukiraho neiguru, b̯wesigwa b̯wamu b̯udwa mpaka mu bikaka. ");
INSERT INTO rub_vpl VALUES ("PS57_11","020_57_11","PSA","57","11","11","Ai̱ Ruhanga ohaariizwe hakyendi̱ weiguru! Leka ki̱ti̱i̱ni̱sa kyamu kibbe mu nsi gyensei̱. ");
INSERT INTO rub_vpl VALUES ("PS58_1","020_58_1","PSA","58","1","1","Hali Mu̱handu̱ wa bahi̱i̱mi̱. Zabbu̱li̱ gya Dau̱di̱. Gi̱hi̱i̱mwe mwiraka lya, “Otahwerekereerya.” Nywe balemi̱ mali̱ biragiro bimutaho bi̱doori̱? Bantu mubacwera misangu na b̯winganiza? ");
INSERT INTO rub_vpl VALUES ("PS58_2","020_58_2","PSA","58","2","2","Kwahi mu mitima myenyu̱ mubahab̯ura bi̱gu̱u̱, mikono myenyu̱ mikora byab̯wemi̱ mu nsi. ");
INSERT INTO rub_vpl VALUES ("PS58_3","020_58_3","PSA","58","3","3","Babiibi bahaba nibakyaruga b̯u̱ru̱gi̱ mu nda, nibatandika ku̱sobya kuruga mu b̯uto b̯wab̯u na mukubaza b̯u̱gobya. ");
INSERT INTO rub_vpl VALUES ("PS58_4","020_58_4","PSA","58","4","4","Bali na b̯umala nka b̯wa mpiri, nka b̯wa mpiri ncwera, zi̱bbu̱mbi̱ri̱ mapokopo. ");
INSERT INTO rub_vpl VALUES ("PS58_5","020_58_5","PSA","58","5","5","Zi̱takwegwa bafu̱mu̱, baku̱si̱i̱hya ndere. ");
INSERT INTO rub_vpl VALUES ("PS58_6","020_58_6","PSA","58","6","6","Ai̱ Ruhanga, batoole meino mu mi̱nwa myab̯u, ai̱ Mukama binyabinya meino ga ntali zibii! ");
INSERT INTO rub_vpl VALUES ("PS58_7","020_58_7","PSA","58","7","7","Leka basyere nka meezi̱ gakuheta b̯u̱heti̱, bahotoke nka b̯usubi b̯u̱kandagire. ");
INSERT INTO rub_vpl VALUES ("PS58_8","020_58_8","PSA","58","8","8","Boome nka ki̱tani̱i̱na ki̱kwereeri̱ mu lusonko lwakyo, nka mwana nzomoki̱ ataliwonahoona kalyoba. ");
INSERT INTO rub_vpl VALUES ("PS58_9","020_58_9","PSA","58","9","9","Ruhanga ali̱zi̱ki̱i̱rya ki̱mwei̱ bato na bahandu̱, b̯wangu hoi̱ kukira nka kyese ki̱bei̱ci̱i̱rye ha mworo gwa makala. ");
INSERT INTO rub_vpl VALUES ("PS58_10","020_58_10","PSA","58","10","10","Muntu munanu alisemererwa kuwona mubiibi naafubirwa, magulu gaamwei aliganabira mwibbanga lya nkori̱ za bibii. ");
INSERT INTO rub_vpl VALUES ("PS58_11","020_58_11","PSA","58","11","11","Bantu balikoba yati, “Mananu kwo heicalaho mpeera gya beesigwa, mananu kwo heicalaho Ruhanga mu̱cwi̱ wa musangu ku nsi.” ");
INSERT INTO rub_vpl VALUES ("PS59_1","020_59_1","PSA","59","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱. Mwiraka lya “Otahwerekereerya.” Zabbu̱li̱ gya Dau̱di̱. Sau̱lo b̯u̱yaatu̱mi̱ri̱ badulu kutata nnyu̱mba gya Dau̱di̱ naakwendya ku̱mwi̱ta. Ai̱ Ruhanga, ncungura kuruga mu banyanzigwa bange, ondinde hali bab̯wo baku̱mbyokeera. ");
INSERT INTO rub_vpl VALUES ("PS59_2","020_59_2","PSA","59","2","2","Njuna kuruga mu nkori̱ za bibii, kandi onsi̱ngu̱ri̱sye kuruga mu batemu. ");
INSERT INTO rub_vpl VALUES ("PS59_3","020_59_3","PSA","59","3","3","Kubba bandali̱ri̱i̱ri̱ ku̱nzi̱ta, badulu bakabi bambyokeeryeho ntaru. Ai̱ Mukama, ntali na nsobi̱ rundi kabii kensei̱, ");
INSERT INTO rub_vpl VALUES ("PS59_4","020_59_4","PSA","59","4","4","nab̯untali nabo musangu, bei̱tu̱ bo beicala banyeci̱i̱ki̱i̱ri̱. Si̱si̱mu̱ka, oi̱ze ondombe, kandi owone. ");
INSERT INTO rub_vpl VALUES ("PS59_5","020_59_5","PSA","59","5","5","We Mukama Ruhanga wa mahe, oli Ruhanga wʼI̱saleeri̱. Byokiramwo kufubira, mahanga gensei̱, otakeni̱a noomwei̱ mu batab̯ura nkwe za b̯ubii. ");
INSERT INTO rub_vpl VALUES ("PS59_6","020_59_6","PSA","59","6","6","B̯uli joojolo bei̱ra, nibaturuuma nka mbwene, nibalibatalibata mu rub̯uga. ");
INSERT INTO rub_vpl VALUES ("PS59_7","020_59_7","PSA","59","7","7","Babaza bigambo bya kuntinisiriirya ku̱nzi̱ta na mpirima mu mi̱nwa myab̯u, nibaniihira tihaloho aku̱beegwa. ");
INSERT INTO rub_vpl VALUES ("PS59_8","020_59_8","PSA","59","8","8","Ai̱ Mukama, oseke b̯u̱seki̱, mahanga gensei̱ gaku̱jeemera. ");
INSERT INTO rub_vpl VALUES ("PS59_9","020_59_9","PSA","59","9","9","Ai̱ Ruhanga, weewe maani gange, na b̯wi̱ru̱ki̱ro b̯wange b̯unyesiga. ");
INSERT INTO rub_vpl VALUES ("PS59_10","020_59_10","PSA","59","10","10","Ruhanga wange, mu ngonzi zaamu zinene, olinyebembera kandi nsi̱ngu̱re banyanzigwa bange. ");
INSERT INTO rub_vpl VALUES ("PS59_11","020_59_11","PSA","59","11","11","Otabei̱ta bensei̱ kubba bantu bange handaki bebeere b̯wangu bi̱waakoori̱, basasaani̱e habwa maani gaamu kandi obasi̱ngu̱re, ai̱ Mukama, ngab̯u gyetu̱! ");
INSERT INTO rub_vpl VALUES ("PS59_12","020_59_12","PSA","59","12","12","Hab̯wa kibii kya mi̱nwa myab̯u, bigambu bya ndimi zaab̯u, leka bakwatwe mu marara gaab̯u, hab̯wa kukyena na b̯u̱gobya b̯ubabaza. ");
INSERT INTO rub_vpl VALUES ("PS59_13","020_59_13","PSA","59","13","13","Bahwerekereerye mu ki̱ni̱ga, mpaka bamali̱ki̱ri̱ho, kwokwo beege nti Ruhanga alema Yakobbo, kumaaliiro gya nsi. ");
INSERT INTO rub_vpl VALUES ("PS59_14","020_59_14","PSA","59","14","14","B̯uli joojolo bei̱ra, nibaturuuma nka mbwene, nibalibatalibata mu rub̯uga. ");
INSERT INTO rub_vpl VALUES ("PS59_15","020_59_15","PSA","59","15","15","Bandaara ni̱baku̱toolereerya bidyo benghurunghuutya b̯u̱balemwa kubyagya. ");
INSERT INTO rub_vpl VALUES ("PS59_16","020_59_16","PSA","59","16","16","Bei̱tu̱ nku̱hi̱i̱ma kuhaariiza maani gaamu, b̯uli mwakya karei, mmpi̱i̱ma na maani hab̯wa ngonzi zaamu zinene, kubba oicala b̯wi̱ru̱ki̱ro b̯wange na mu̱tu̱ntu̱lu̱ gwange mu b̯wi̱re b̯wa kizib̯u. ");
INSERT INTO rub_vpl VALUES ("PS59_17","020_59_17","PSA","59","17","17","Ai̱ Ruhanga, weewe maani gange, nku̱ku̱hi̱i̱mi̱ra nkuhaariize, kubba weewe oicala b̯wi̱ru̱ki̱ro b̯wange, Ruhanga anzolokya ngonzi zinene. ");
INSERT INTO rub_vpl VALUES ("PS60_1","020_60_1","PSA","60","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱. Zabbu̱li̱ gya Dau̱di̱. Ni̱gi̱si̱gi̱ki̱ra hali Su̱sani̱ Edu̱sa. Mpandiika gya Dau̱di̱ yankei, hab̯wa kwegesya, b̯u̱yaalweni̱ na Aramu naharai̱mu̱ na Aramu zobba kandi Jowabbu b̯u̱yeetangi̱ri̱ akei̱ta badulu mutwaru gu̱mwei̱ na nku̱mi̱ ibiri bʼEdomu̱ mu kihanga kya kisura. Ai̱ Ruhanga, otu̱nu̱gi̱ri̱, watubinya ntege, oi̱ceeri̱ na ki̱ni̱ga, caali tu̱ganyi̱re. ");
INSERT INTO rub_vpl VALUES ("PS60_2","020_60_2","PSA","60","2","2","Oheeri̱ nsi kutengeeta wagibinyabinyamwo, su̱ngi̱i̱ra mi̱nyangaara byagyo kubba gikudengeeta. ");
INSERT INTO rub_vpl VALUES ("PS60_3","020_60_3","PSA","60","3","3","Oheeri̱ bantu baamu kuwonawona bintu byakalaseeni̱, otu̱heeri̱ vi̱i̱no gi̱ku̱tu̱tami̱i̱rya. ");
INSERT INTO rub_vpl VALUES ("PS60_4","020_60_4","PSA","60","4","4","Woolokeerye b̯u̱bonero b̯wamu hali bab̯wo baku̱ti̱i̱na, aleke basobore kukena kabii. ");
INSERT INTO rub_vpl VALUES ("PS60_5","020_60_5","PSA","60","5","5","Cungura bawendya, obajune na mukono gwamu gwab̯udyo, kandi otwi̱remwo! ");
INSERT INTO rub_vpl VALUES ("PS60_6","020_60_6","PSA","60","6","6","Ruhanga abazi̱ri̱ nali mu kiikaru kyamwe ki̱syanu̱, naakoba yati, “Mu kusemererwa kunene ndi̱bagaani̱amwo Sekemu̱, kandi ngabire bantu bange kihanga kya Su̱koosi̱. ");
INSERT INTO rub_vpl VALUES ("PS60_7","020_60_7","PSA","60","7","7","Gi̱ryadi̱, nsi gyange, Manaase de gyange, Efu̱rayi̱mu̱, kyoma kilinda mu̱twe gwange, Yu̱da, mubbeere gwa b̯ukama b̯wange. ");
INSERT INTO rub_vpl VALUES ("PS60_8","020_60_8","PSA","60","8","8","Mowaabbu gyogyo kalaaya gyange haanabi̱ra, Edomu̱ hooho nzi̱ca nkei̱to zange, mu Fi̱ri̱si̱ti̱ hooho nyeb̯uga hab̯wa b̯u̱si̱ngu̱zi̱.” ");
INSERT INTO rub_vpl VALUES ("PS60_9","020_60_9","PSA","60","9","9","Naani alintwala mu rub̯uga lunyamaani? Akanyebembera kugyenda mu Edomu̱? ");
INSERT INTO rub_vpl VALUES ("PS60_10","020_60_10","PSA","60","10","10","Ai̱ Mukama, mali̱ otu̱nu̱gi̱ri̱ kwahi? Kotakwebembera mahe geetu̱? ");
INSERT INTO rub_vpl VALUES ("PS60_11","020_60_11","PSA","60","11","11","Beiraba tu̱ju̱ne hali banyanzigwa beetu̱, kubba kujuna kwa bantu tikugasa! ");
INSERT INTO rub_vpl VALUES ("PS60_12","020_60_12","PSA","60","12","12","Ruhanga nka kwali ha rubaju lwetu̱ tu̱ku̱si̱ngu̱ra, yooyo akuziginiira banyanzigwa beetu̱. ");
INSERT INTO rub_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱. Kyembu nikikuutwa na kikwatu kya mahu̱u̱zi̱. Zabbu̱li̱ gya Dau̱di̱. Ai̱ Ruhanga, weegwa kukunga kwange, weetegeerye kusaba kwange. ");
INSERT INTO rub_vpl VALUES ("PS61_2","020_61_2","PSA","61","2","2","Kuruga ha mmaliiro gya nsi nyeeta weewe, mutima gwange b̯ugubba gumaalikiirwemwona maani, onyebembere hali mwandaara, gukukirahoona b̯ule b̯wange. ");
INSERT INTO rub_vpl VALUES ("PS61_3","020_61_3","PSA","61","3","3","Kubba weewe oi̱ceeri̱ lukomera lwange, mu̱longooti̱ gwa maani hali banyanzigwa. ");
INSERT INTO rub_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","Leka ncalire mu heema gyamu biro byensei̱! Leka nyebi̱si̱re mu bimpaha byamu. ");
INSERT INTO rub_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","Kubba weewe ai̱ Ruhanga, weegwi̱ri̱ kurahira kwange, wampa b̯ugwetwa b̯wa bab̯wo bati̱i̱na ibara lyamu. ");
INSERT INTO rub_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","Wongere biro bya b̯womi b̯wa mukama, leka myaka myamwe myeyongere ku̱doosya mi̱hi̱hi̱ minene. ");
INSERT INTO rub_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","Kwokwo eicarenge ha kitebe kyamwe mu mei̱so ga Ruhanga biro byensei̱, aragire ngonzi zinene na b̯wesigwa bimulindenge. ");
INSERT INTO rub_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","Nahab̯waki̱kyo ndiicala ni̱nku̱hi̱mi̱ra kukuhariiza, ni̱nku̱dooseereerya miragu myange biro byensei̱. ");
INSERT INTO rub_vpl VALUES ("PS62_1","020_62_1","PSA","62","1","1","Hali Mu̱handu̱ wa bahi̱i̱mi̱. Ku̱si̱gi̱ki̱ra ku Jedu̱sani̱. Zabbu̱li̱ gya Dau̱di̱. Mwozo gwange guhuumulira mu Ruhanga musa, kujunwa kwange kuruga hali yo. ");
INSERT INTO rub_vpl VALUES ("PS62_2","020_62_2","PSA","62","2","2","Yooyo musa ali lubbaali lwange na kujunwa kwange, lugo lwange lunyamaani, tinditengeeta. ");
INSERT INTO rub_vpl VALUES ("PS62_3","020_62_3","PSA","62","3","3","Nywe nywensei̱ mu̱li̱doosya di̱i̱ ku̱ndu̱mba, gya akwisana ki̱si̱i̱ka ki̱gogomi̱ri̱ kandi lugo lu̱swaswani̱ki̱ri̱? ");
INSERT INTO rub_vpl VALUES ("PS62_4","020_62_4","PSA","62","4","4","Bategeka ku̱nzi̱rya hansi kuntoola mu kiikaru kyange kya ki̱ti̱i̱ni̱sa. Benyumiza mu kubazaho b̯u̱gobya. Mi̱nwa myab̯u mibaza bigambo bya kuha mu̱gi̱sa, bei̱tu̱ mitima myab̯u mibba nimikukyena b̯u̱kyeni̱. ");
INSERT INTO rub_vpl VALUES ("PS62_5","020_62_5","PSA","62","5","5","Ai̱ Mwozo gwange, gu̱li̱ndi̱ri̱i̱ri̱ Ruhanga musa, kubba ku̱ni̱hi̱ra kwange kuruga hali yooyo. ");
INSERT INTO rub_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","Yooyo musa ali lubbaali lwange na kujunwa kwange, lugo lwange lunyamaani, tinditengeeta. ");
INSERT INTO rub_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","Mu Ruhanga hooho kujunwa kwange na ki̱ti̱i̱ni̱sa kyange biruga, ali yooyo cali nyi̱ru̱ki̱ra. ");
INSERT INTO rub_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","Nywe bantu, mu̱mwesi̱genge b̯wi̱re b̯wensei̱, mitima myenyu̱ mu̱mi̱mu̱he, yooyo b̯wi̱ru̱ki̱ro b̯wetu̱. ");
INSERT INTO rub_vpl VALUES ("PS62_9","020_62_9","PSA","62","9","9","Bantu beicala rwoya lusa, kadi babbe na ki̱ti̱i̱ni̱sa teetei̱, nob̯wobata ha ndengu, tibagira raati̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS62_10","020_62_10","PSA","62","10","10","Otalyesiga nsimbi zootu̱ngi̱ri̱ mu b̯u̱nyagi̱, rundi kwetembya hab̯wa bintu bi̱i̱be, itungu lyamu nab̯ubilikanya, otalilitaho mutima gwamu. ");
INSERT INTO rub_vpl VALUES ("PS62_11","020_62_11","PSA","62","11","11","Kintu kya Ruhanga abazi̱ri̱ gu̱mwei̱, nkyegwi̱ri̱ mirundi mibiri nti b̯u̱sobozi̱ b̯wensei̱, b̯uruga hali yo. ");
INSERT INTO rub_vpl VALUES ("PS62_12","020_62_12","PSA","62","12","12","Muli we Mukama hooho ngonzi zinene zibba, kubba olisasula b̯uli muntu nka mulimo gwamwe ku guli. ");
INSERT INTO rub_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","Zabbu̱li̱ gya Dau̱di̱. B̯uyaali mwirungu mu Yu̱da. Ai̱ Ruhanga, oli weewe Ruhanga wange gintoolya, na mutima gwange gwensei̱, mwozo gwange gukukuhyahyanira, mubiri gwange gu̱ku̱ku̱toolya, mu nsi gyomu gi̱nu̱u̱gi̱i̱rwe, gitalimwo meezi̱. ");
INSERT INTO rub_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","Kyokyo ndimu kukuwona mu nnyu̱mba gyamu, mbona b̯u̱sobozi̱ na ki̱ti̱i̱ni̱sa kyamu. ");
INSERT INTO rub_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","Hab̯wa ngonzi zaamu zinene, zitahinduka zikiraho na b̯womi, nahahwo nkwi̱za kukuhaariizanga. ");
INSERT INTO rub_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","Nyaakuhaariizanga nincaali mwomi, nyaaku̱byokeeryanga mikono ninkukusaba. ");
INSERT INTO rub_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","Mwozo gwange gwecu̱tanga nka ndi̱i̱ri̱ masaju, kandi kanwa kange kahi̱i̱manga kusemererwa kwa kukuhaariiza, ");
INSERT INTO rub_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","nkwi̱zu̱ka nindi ha ntabbu, nku̱tekerezaho i̱jolo lyensei̱. ");
INSERT INTO rub_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","Hab̯wakubba weewe oli mu̱ju̱ni̱ b̯wange, mu mu̱tu̱ntu̱lu̱ gwa bimpaha byamu, hooho nyaahi̱i̱mi̱ranga. ");
INSERT INTO rub_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","Mwozo gwange gu̱kwekweti̱ mukono gwamu gwab̯udyo gwogwo gundinda. ");
INSERT INTO rub_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","Bei̱tu̱ bab̯wo batoolya ku̱nzi̱ta, baligyenda hansi kuzumu. ");
INSERT INTO rub_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","Bei̱twanga mpirima kandi babbanga bidyo bya mahi̱mbe. ");
INSERT INTO rub_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","Mukama yaasemererwanga hab̯wa b̯u̱si̱ngu̱zi̱ b̯wa Ruhanga amuha, bab̯wo bensei̱ baragani̱sya nibarahira mwibara lya Ruhanga balitunga ki̱ti̱i̱ni̱sa, hab̯wakubba mi̱nwa mya bagobya milijalwa. ");
INSERT INTO rub_vpl VALUES ("PS64_1","020_64_1","PSA","64","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱. Zabbu̱li̱ gya Dau̱di̱. Ai̱ Ruhanga, nzegwa, ninkukuweera byetaagu byange, b̯womi b̯wange ob̯ulindenga ntati̱i̱na banyanzigwa. ");
INSERT INTO rub_vpl VALUES ("PS64_2","020_64_2","PSA","64","2","2","Ntegura kuruga mu nkwe za babiibi, na kuruga hakati̱ wa nkori̱ za bibii, ");
INSERT INTO rub_vpl VALUES ("PS64_3","020_64_3","PSA","64","3","3","bab̯wo bobohya ndimi zaab̯u nka mpirima, nibategeka bigambu bikululuha nka mbasi zi̱i̱ti̱. ");
INSERT INTO rub_vpl VALUES ("PS64_4","020_64_4","PSA","64","4","4","Zibakulasa mu nsita zi̱pi̱mi̱ri̱ muntu atali na musangu, nibazilasa mbura kulekeera kandi batali na b̯u̱ti̱i̱ni̱. ");
INSERT INTO rub_vpl VALUES ("PS64_5","020_64_5","PSA","64","5","5","Ni̱basi̱gi̱ki̱ra ha bigyendeerwa byab̯u bibiibi, bategeka kutega mitegu nibateekereza nti, “Naani akusobora kumiwona?” ");
INSERT INTO rub_vpl VALUES ("PS64_6","020_64_6","PSA","64","6","6","Bategeka kukora b̯utali b̯winganiza, nibakobanga, “Tu̱tegeki̱ri̱ kurungi.” Kitekerezo na mutima bya muntu tosobora kubyetegereza. ");
INSERT INTO rub_vpl VALUES ("PS64_7","020_64_7","PSA","64","7","7","Bei̱tu̱ Ruhanga ali̱balasa na mbasi zaamwe, bahutaare b̯ulohob̯uloho. ");
INSERT INTO rub_vpl VALUES ("PS64_8","020_64_8","PSA","64","8","8","Ali̱bahwerekereerya hab̯wa bigambu byab̯u bankei bibabaza, bantu bensei̱ balibawona bakwi̱za ku̱zi̱ngi̱i̱zya mi̱twe. ");
INSERT INTO rub_vpl VALUES ("PS64_9","020_64_9","PSA","64","9","9","Kasi bantu bensei̱ bati̱i̱ne, batebye mulimo gwa Ruhanga, bateekereza ha bi̱yaakoori̱. ");
INSERT INTO rub_vpl VALUES ("PS64_10","020_64_10","PSA","64","10","10","Leka munanu asemererwe mu Mukama, kandi ei̱ru̱ki̱re muli yo. Leka bananu mu mutima bensei̱ bamuhaariize. ");
INSERT INTO rub_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","1","Hali Mu̱handu̱ wa bahi̱i̱mi̱. Zabbu̱li̱ gya Dau̱di̱. Kili kyembu. Ai̱ Ruhanga, weewe osemereeri̱ kuhaariizib̯wa mu Sayu̱u̱ni̱, hali we miragu myetu̱ mi̱kwi̱za kudwereera. ");
INSERT INTO rub_vpl VALUES ("PS65_2","020_65_2","PSA","65","2","2","Ai̱ Ruhanga, weewe oi̱ramu kusaba, bantu bensei̱ bali̱i̱za hali weewe. ");
INSERT INTO rub_vpl VALUES ("PS65_3","020_65_3","PSA","65","3","3","Bibii byetu̱ nab̯ubyabba byali byakalaseeni̱, waatu̱ganyi̱i̱ri̱ b̯ubiibi b̯wetu̱. ");
INSERT INTO rub_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","Bali na mu̱gi̱sa bab̯wo bookomi̱ri̱, okabaleeta kwicala kwamwamu! Tuheeb̯wa binene bya mu nnyu̱mba gyamu Yeekaru gi̱syanu̱. ");
INSERT INTO rub_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","Ai̱ Ruhanga Mu̱ju̱ni̱ weetu̱, otwi̱remwo na bi̱ku̱ti̱i̱ni̱sya byokora bya mananu, ku̱ni̱hi̱ra kwa nsi gyensei̱, na kwa mataka ga hadei. ");
INSERT INTO rub_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","Munyakuhanga nsahu hab̯wa maani, na b̯u̱sobozi̱ waamu! ");
INSERT INTO rub_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","Weemereerya kuhuura kwamataka, kukuuta kwa bijanga na b̯u̱gu̱gu̱mu̱ko mu mahanga. ");
INSERT INTO rub_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","Nsi gyensei̱ gi̱ti̱i̱na byokora, weewe okesya b̯wi̱re noob̯uha na kusweka, oragira bantu bahi̱i̱me hab̯wa kusemererwa. ");
INSERT INTO rub_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","Weewe olinda nsi kandi noguma ndagali̱, aleke bilimwa bikwahukana byere, mugira gwamu tigwoma kandi nsi ogi̱tegeka kubba na bidyo bya mpuule binene. ");
INSERT INTO rub_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","Weewe oguma ndagali̱ mu ndimiro, nosi̱ndi̱ka b̯utuntu kwi̱nyamya nsi, bilimwa noobiha mu̱gi̱sa. ");
INSERT INTO rub_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","Mwaka ogukingaho na birungi binene, b̯uli hokagyendi̱ri̱ habbaho magesa ganene. ");
INSERT INTO rub_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","12","Isubi linene lyeri̱ri̱ mwihamba, nsahu zi̱zwi̱ri̱ kusemererwa. ");
INSERT INTO rub_vpl VALUES ("PS65_13","020_65_13","PSA","65","13","13","Mali̱i̱si̱i̱ryo gei̱zwi̱ri̱ magana, mpuule zinene zeri̱ri̱ mu bihanga, bantu baku̱hi̱i̱ma kandi bakukuuta mi̱zi̱ra hab̯wa kusemererwa! ");
INSERT INTO rub_vpl VALUES ("PS66_1","020_66_1","PSA","66","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱. Zabbu̱li̱ kili Kyembu. Muhaariize Ruhanga na kusemererwa, bantu nywensei̱ ba mu nsi. ");
INSERT INTO rub_vpl VALUES ("PS66_2","020_66_2","PSA","66","2","2","Hi̱i̱me ki̱ti̱i̱ni̱sa kyeibara lyamwe, mu̱mu̱haari̱i̱ze na ki̱ti̱i̱ni̱sa! ");
INSERT INTO rub_vpl VALUES ("PS66_3","020_66_3","PSA","66","3","3","Muweere Ruhanga yati, “Bintu byakora kwo bya b̯uzira, maani gaamu gali ganene, gaha banyanzigwa baamu kwi̱za hali we nibagula b̯wagu̱li̱. ");
INSERT INTO rub_vpl VALUES ("PS66_4","020_66_4","PSA","66","4","4","Bantu ba mu nsi gyensei̱ baku̱ramye, kandi baku̱hi̱i̱mi̱ra kuhaariiza ibara lyamu.” ");
INSERT INTO rub_vpl VALUES ("PS66_5","020_66_5","PSA","66","5","5","Mwi̱ze muwone Ruhanga byakoori̱ mu bantu, byamaani kandi bi̱ku̱ti̱i̱ni̱sya! ");
INSERT INTO rub_vpl VALUES ("PS66_6","020_66_6","PSA","66","6","6","Yaahi̱ndu̱u̱ri̱ itaka lyei̱ra nsi gyomu, bali̱bati̱ri̱ na magulu hakati̱ wa meezi̱, i̱ze aleke tujaguze muli yo. ");
INSERT INTO rub_vpl VALUES ("PS66_7","020_66_7","PSA","66","7","7","Alema biro byensei̱ na b̯u̱sobozi̱ b̯wamwe, mei̱so gaamwe gali̱ngi̱ri̱i̱ri̱ mahanga gensei̱, bajeemu̱ baleke kumubyokeera. ");
INSERT INTO rub_vpl VALUES ("PS66_8","020_66_8","PSA","66","8","8","Muhaariize Ruhanga weetu̱ nywe bantu, leke iraka lya kumuhaariiza kwenyu̱ balyegwe, ");
INSERT INTO rub_vpl VALUES ("PS66_9","020_66_9","PSA","66","9","9","atu̱li̱ndi̱ri̱ nituli boomi, yaagaana magulu geetu̱ kukiibbala. ");
INSERT INTO rub_vpl VALUES ("PS66_10","020_66_10","PSA","66","10","10","Ruhanga waatu̱lengi̱ri̱, nka feeza kugiraba mu mworo. ");
INSERT INTO rub_vpl VALUES ("PS66_11","020_66_11","PSA","66","11","11","Twakwatwa mutegu, kabii katudwereera. ");
INSERT INTO rub_vpl VALUES ("PS66_12","020_66_12","PSA","66","12","12","Waaleki̱ri̱ bantu batwicaara ha mi̱twe, twarabi̱ri̱ mu mworo na mu meezi̱, bei̱tu̱ mu byensei̱ waatu̱hu̱u̱mu̱u̱li̱i̱rye. ");
INSERT INTO rub_vpl VALUES ("PS66_13","020_66_13","PSA","66","13","13","Nyei̱zanga mu yeekaru gyamu na bihongwa byokye, ndosereerye kweraga kwange, ");
INSERT INTO rub_vpl VALUES ("PS66_14","020_66_14","PSA","66","14","14","ku̱nyeeragi̱ri̱ na mu̱nwa gwange, b̯unyaali nindi mu b̯ujune. ");
INSERT INTO rub_vpl VALUES ("PS66_15","020_66_15","PSA","66","15","15","Nyaakuhongiranga bihongwa byokye bya bisolo bya masaju, na mwi̱ca gwa kihongwa kya ntaama, nyaakuhongiranga kisembu kya mbu̱li̱ na nte. ");
INSERT INTO rub_vpl VALUES ("PS66_16","020_66_16","PSA","66","16","16","I̱ze mwetegeerye, nywe bati̱i̱na Ruhanga, mbaweere byankoleeri̱. ");
INSERT INTO rub_vpl VALUES ("PS66_17","020_66_17","PSA","66","17","17","Nyaamu̱ku̱ngi̱ri̱ na mu̱nwa gwange, kalimi kange kalimi kumuhaariiza. ");
INSERT INTO rub_vpl VALUES ("PS66_18","020_66_18","PSA","66","18","18","Kakubba bibii nyaalingi mbi̱bi̱si̱i̱ri̱ mu mutima gwange, Mukama yaaku̱bbeeri̱ atanzegwi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS66_19","020_66_19","PSA","66","19","19","Bei̱tu̱ Ruhanga yeetegeerye kandi yeegwi̱ri̱ iraka lyange ninkusaba. ");
INSERT INTO rub_vpl VALUES ("PS66_20","020_66_20","PSA","66","20","20","Ki̱ti̱i̱ni̱sa kibbe hali Ruhanga, atanu̱gi̱ri̱ kusaba kwange, rundi kuntoolaho ngonzi zaamwe zinene. ");
INSERT INTO rub_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱. Na kikwatu kya mahu̱u̱zi̱. Zabbu̱li̱ kili kyembu. Leka Ruhanga atugiire mbabazi̱, atuhe mu̱gi̱sa gwamu, kandi mei̱so gaamwe gatumulukire, ");
INSERT INTO rub_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","aleke muhanda gwamu bagwege mu nsi, mahanga gensei̱ gatunge maani ga kujuna kwamu. ");
INSERT INTO rub_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","Ai̱ Ruhanga, leka bantu bakuhaariize, leka bantu bensei̱ bakuhaariize! ");
INSERT INTO rub_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Leka mahanga gasemererwe kandi gahi̱i̱me hab̯wa kwegonza, kubba weewe ocwa musangu na b̯winganiza, kandi mahanga gensei̱ ga mu nsi weewe ogalema. ");
INSERT INTO rub_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","Ai̱ Ruhanga, leka bantu bakuhaariize, leka bantu bensei̱ bakuhaariize! ");
INSERT INTO rub_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Nsi gyereerye binene, Ruhanga, Ruhanga weetu̱ atu̱heeri̱ mu̱gi̱sa. ");
INSERT INTO rub_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","Ruhanga atu̱heeri̱ mu̱gi̱sa, leka bantu bensei̱ ba mu nsi bamuhe ki̱ti̱i̱ni̱sa. ");
INSERT INTO rub_vpl VALUES ("PS68_1","020_68_1","PSA","68","1","1","Hali Mu̱handu̱ Wa Bahi̱i̱mi̱. Zabbu̱li̱ gya Dau̱di̱. Kyembu. Ruhanga wange byoka, aleke banyanzigwa baamu, basasaane, kandi bab̯wo bamunoba bali̱mwi̱ru̱ke! ");
INSERT INTO rub_vpl VALUES ("PS68_2","020_68_2","PSA","68","2","2","Nka mwi̱ca ku̱gu̱tu̱u̱ka, kwokwo nawe oli̱beeru̱kya, nka b̯ubbaani kuhunyelela mu mworo, kwokwo nkori̱ za bibii zilihwerekeera mu mei̱so ga Ruhanga! ");
INSERT INTO rub_vpl VALUES ("PS68_3","020_68_3","PSA","68","3","3","Bei̱tu̱ bananu basemererwe, kandi bajaguze mu mei̱so ga Ruhanga, bajaguze na kusemererwa hoi̱! ");
INSERT INTO rub_vpl VALUES ("PS68_4","020_68_4","PSA","68","4","4","Mu̱hi̱i̱mi̱re Ruhanga nimumuhariiza, yooyo Mukama ali, hakyendi̱ wa b̯uli kintu mwi̱ze mu mei̱so gaamwe na kusemererwa. ");
INSERT INTO rub_vpl VALUES ("PS68_5","020_68_5","PSA","68","5","5","Yooyo bba nfu̱u̱zi̱ kandi awooneera na bamukaabakwere, ei̱cali̱i̱ri̱ mu kiikaru kyamwe kitongoole. ");
INSERT INTO rub_vpl VALUES ("PS68_6","020_68_6","PSA","68","6","6","Aha bantu bakulungwa lungwa b̯wicalu, banyankomo naabatesu̱la bei̱tu̱ bajeemu̱ baliwonawona mu nsi gya ndala. ");
INSERT INTO rub_vpl VALUES ("PS68_7","020_68_7","PSA","68","7","7","Ai̱ Ruhanga weebembeeri̱ bantu baamu kuruga mu nsi gya b̯wiru, waalibata nabo kuraba mwihamba. ");
INSERT INTO rub_vpl VALUES ("PS68_8","020_68_8","PSA","68","8","8","Nsi giitengeeta iguru niliguma ndagali̱, mu mei̱so ga Ruhanga wa Sinaayi, mu mei̱so ga Ruhanga wʼI̱saleeri̱. ");
INSERT INTO rub_vpl VALUES ("PS68_9","020_68_9","PSA","68","9","9","Ai̱ Ruhanga waagu̱mi̱ri̱ ndagali̱ ginene, nsi gyamu ginyaakubba gyomi̱ri̱ gyeinyama. ");
INSERT INTO rub_vpl VALUES ("PS68_10","020_68_10","PSA","68","10","10","Ai̱ Ruhanga, bantu baamu baatu̱ngi̱ri̱ yo b̯wicalu, mu b̯urungi b̯wamu, waagabiira bali mu b̯wetaagu. ");
INSERT INTO rub_vpl VALUES ("PS68_11","020_68_11","PSA","68","11","11","Ruhanga agabi̱ri̱ kigambu, mahe ga bakali̱ galimwo kwami̱i̱rya makuru garungi. ");
INSERT INTO rub_vpl VALUES ("PS68_12","020_68_12","PSA","68","12","12","“Bakama na mahe gaab̯u beeru̱ki̱ri̱, bakali̱ bʼI̱saleeri̱ baru̱gi̱ri̱ mu maka gaab̯u bali mu kubagana bintu byei̱he lyab̯u lyanyagi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS68_13","020_68_13","PSA","68","13","13","B̯uli muntu yaatu̱ngi̱ri̱ mugab̯u na banyakubba mu mali̱i̱si̱i̱ryo ga ntaama, baasengi̱ri̱yo bi̱si̱sani̱ bya makolome ga wa bimpaha b̯i̱doli̱ge na zaabbu na byoza b̯i̱doli̱ge na feeza.” ");
INSERT INTO rub_vpl VALUES ("PS68_14","020_68_14","PSA","68","14","14","Ruhanga Wab̯u̱sobozi̱ b̯wensei̱ yei̱ru̱ki̱i̱rye bakama banyanzigwa, nka mahi̱ga ga ndagali̱ gagwi̱ri̱ ha lusahu lwa zaali̱mooni̱. ");
INSERT INTO rub_vpl VALUES ("PS68_15","020_68_15","PSA","68","15","15","Bbasaani̱, oli lusahu lwa maani. Oli lusahu lu̱wa mi̱twe minene! ");
INSERT INTO rub_vpl VALUES ("PS68_16","020_68_16","PSA","68","16","16","Hab̯waki oli nei̱hali̱ na lusahu Sayu̱u̱ni̱ lwa Ruhanga yeegombi̱ri̱, cali Mukama eicala biro byensei̱. ");
INSERT INTO rub_vpl VALUES ("PS68_17","020_68_17","PSA","68","17","17","Mukama yei̱zi̱ri̱ kuruga Sinaayi, yengira mu kiikaru kyamwe ki̱syanu̱ na mahe ga bavu̱gi̱ batembi̱ri̱ bigaali nku̱mi̱ na nku̱mi̱. ");
INSERT INTO rub_vpl VALUES ("PS68_18","020_68_18","PSA","68","18","18","Waatembi̱ri̱ hakyendi̱, weebembeeri̱ bantu banene bab̯wo baawaatoori̱ mu b̯unyagwa, bantu nibakuha bisembu, na kuruga mu bajeemu̱, Mukama Ruhanga aliicalayo. ");
INSERT INTO rub_vpl VALUES ("PS68_19","020_68_19","PSA","68","19","19","Tu̱haari̱i̱ze Mukama, yogwo atwetwekera migugu myetu̱ b̯uli kiro, Ruhanga yooyo kujunwa kwetu̱. ");
INSERT INTO rub_vpl VALUES ("PS68_20","020_68_20","PSA","68","20","20","Ruhanga weetu̱ ali Ruhanga wa kujuna, kandi hali Mukama Ruhanga hooho tuhonera lu̱ku̱u̱. ");
INSERT INTO rub_vpl VALUES ("PS68_21","020_68_21","PSA","68","21","21","Ruhanga ali̱tema mi̱twe mya banyanzigwa, anyongotolere ki̱mwei̱ b̯uhanga b̯wa balibatira mu kuhenera. ");
INSERT INTO rub_vpl VALUES ("PS68_22","020_68_22","PSA","68","22","22","Mukama yaakoba yati, “Nkwi̱za kubatoolayo kuruga Bbasaani̱, mbatoole na mu ndi̱ha gyeitaka, ");
INSERT INTO rub_vpl VALUES ("PS68_23","020_68_23","PSA","68","23","23","aleke nywe bantu bange magulu geenyu̱ muganaabe neibbanga lyab̯u, na mbwene zaamu zitungeho kya kudya ha mibiri myab̯u.” ");
INSERT INTO rub_vpl VALUES ("PS68_24","020_68_24","PSA","68","24","24","Ai̱ Ruhanga kukumba kwamu baku̱weeni̱, kukumba kwa Ruhanga wange, kandi mukama wange mu nnyu̱mba gyamwei. ");
INSERT INTO rub_vpl VALUES ("PS68_25","020_68_25","PSA","68","25","25","Bahi̱i̱mi̱ bebembeeri̱, baku̱u̱ti̱ ba bikwatu bilira nibabahondeeranga, hakati̱ waab̯u nihaloho bahalaba baku̱u̱ti̱ ba bi̱cekere. ");
INSERT INTO rub_vpl VALUES ("PS68_26","020_68_26","PSA","68","26","26","“Muhaariize Ruhanga mu bantu banene, na nywe muli baalula lwʼI̱saleeri̱.” ");
INSERT INTO rub_vpl VALUES ("PS68_27","020_68_27","PSA","68","27","27","Haloho Bbenyami̱i̱ni̱, muto b̯wab̯u akusembayo, kasi bahandu̱ ba Yu̱da hamwei̱ na kitebe kyab̯u, ahonderweho bahandu̱ ba Zabbu̱looni̱ na Nafutaali. ");
INSERT INTO rub_vpl VALUES ("PS68_28","020_68_28","PSA","68","28","28","Ai̱ Ruhanga twolokye maani gaamu nka ku̱waakoori̱ woodi̱, ai̱ Ruhanga maani gokoresya muli twe. ");
INSERT INTO rub_vpl VALUES ("PS68_29","020_68_29","PSA","68","29","29","Bakama bali̱i̱za na bisembu ku̱ku̱si̱i̱ma, hab̯wa yeekaru gyamu mu Yeru̱salemu̱. ");
INSERT INTO rub_vpl VALUES ("PS68_30","020_68_30","PSA","68","30","30","Fubira ki̱kyo kisolo kiicalira mu kikemu, fubira ihanga li̱lyo lya bali̱mi̱ baalyo na bantu bali nka nnumi za mu kisaka, bakwagulire nibakukuletera bisembu, obi̱nge bantu basemererwa mu kubba na b̯ulemu. ");
INSERT INTO rub_vpl VALUES ("PS68_31","020_68_31","PSA","68","31","31","Bakama baliruga Mi̱si̱ri̱ na I̱syopi̱ya, balibyokya mikono myab̯u baramye Ruhanga. ");
INSERT INTO rub_vpl VALUES ("PS68_32","020_68_32","PSA","68","32","32","Mu̱hi̱i̱mi̱re Ruhanga nywe bantu ba nsi gyensei̱, mu̱hi̱i̱me muhaariize Mukama. ");
INSERT INTO rub_vpl VALUES ("PS68_33","020_68_33","PSA","68","33","33","Yogwo eicala mwiguru, iguru lya kadei, wona asi̱ndi̱ka iraka, iraka lyamwei lya hakyendi̱. ");
INSERT INTO rub_vpl VALUES ("PS68_34","020_68_34","PSA","68","34","34","Mu̱rangi̱i̱re b̯u̱sobozi̱ waamwe, waki̱ti̱i̱ni̱sa alema I̱saleeri̱, maani gaamwei gali mwiguru. ");
INSERT INTO rub_vpl VALUES ("PS68_35","020_68_35","PSA","68","35","35","Oli Ruhanga oti̱i̱ni̱sya nooli mu kiikaru kyamu ki̱syanu̱, Ruhanga wʼI̱saleeri̱, ogaba maani na b̯u̱sobozi̱ mu bantu baamu, Ruhanga osemereeri̱ kuhaariizwa. ");
INSERT INTO rub_vpl VALUES ("PS69_1","020_69_1","PSA","69","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱. Bikukwata ha byakyo birungi. Zabbu̱li̱ gya Dau̱di̱. Ai̱ Ruhanga, njuna! Hab̯wakubba meezi̱ gandoori̱ mwi̱coti̱. ");
INSERT INTO rub_vpl VALUES ("PS69_2","020_69_2","PSA","69","2","2","Ndi̱ki̱i̱ri̱ mu cokodo mulei, tihaloho na ha kwi̱cya kigulu, ndi mu meezi̱ galei bijanga bili heehi̱ ku̱mbu̱tya. ");
INSERT INTO rub_vpl VALUES ("PS69_3","020_69_3","PSA","69","3","3","Njwahi̱ri̱ hab̯wa kukunga kwange kwa kucungurwa, mimiro myange myomi̱ri̱ mei̱so ganzi̱mbi̱ri̱, hab̯wa kulindiira Ruhanga wange. ");
INSERT INTO rub_vpl VALUES ("PS69_4","020_69_4","PSA","69","4","4","Bannobira b̯usa, bali banene kukira ntumbu za mu̱twe gwange, bamaani boobo bakwendya ku̱nzi̱kya, bakumpangiira, bakumpambiriza kusasula bintu bi̱ntatweri̱. ");
INSERT INTO rub_vpl VALUES ("PS69_5","020_69_5","PSA","69","5","5","Ruhanga, weewe weegi̱ri̱ b̯udoma b̯wange nsobi̱ zi̱nkoori̱ ti̱zebi̱si̱ri̱ hali we. ");
INSERT INTO rub_vpl VALUES ("PS69_6","020_69_6","PSA","69","6","6","Ai̱ Mukama, Ruhanga wa mahe, leka baku̱ni̱hi̱ra muli we, bataswara hab̯wange, ai̱ Ruhanga wʼI̱saleeri̱, otaleka bakwesiga nibakasekwa. ");
INSERT INTO rub_vpl VALUES ("PS69_7","020_69_7","PSA","69","7","7","Hab̯wamu, ntu̱ngi̱ri̱ muswaru, nsoni̱ zi̱mbu̱mbi̱ri̱ mei̱so. ");
INSERT INTO rub_vpl VALUES ("PS69_8","020_69_8","PSA","69","8","8","Ndi nka mu̱genyi̱ hali banyaruganda bange, munyamahanga hali baana ba mmaama. ");
INSERT INTO rub_vpl VALUES ("PS69_9","020_69_9","PSA","69","9","9","Bihika binene bya nnyu̱mba gyamu bi̱mmaari̱ mwozo, bi̱lu̱mo bya bantu bi̱baku̱ku̱lu̱ma nagya babba ni̱baku̱ndu̱ma. ");
INSERT INTO rub_vpl VALUES ("PS69_10","020_69_10","PSA","69","10","10","B̯unkunga kandi nkasiiba, nakyo ki̱i̱ra ki̱lu̱mo. ");
INSERT INTO rub_vpl VALUES ("PS69_11","020_69_11","PSA","69","11","11","B̯undwala nsensede, bantu batandika nkunseka b̯u̱seki̱. ");
INSERT INTO rub_vpl VALUES ("PS69_12","020_69_12","PSA","69","12","12","Bab̯wo beicaara ha mulyangu gwa rub̯uga banseka b̯u̱seki̱, ndi kyembu kya batami̱i̱ru̱. ");
INSERT INTO rub_vpl VALUES ("PS69_13","020_69_13","PSA","69","13","13","Ai̱ Mukama, bei̱tu̱ gya nsaba weewe, mu b̯wi̱re b̯wa kisa kyamu, hab̯wa ngonzi zaamu zamaani, ai̱ Ruhanga onzi̱remwo mu ngonzi zaamu zinene, onzi̱remwo na kujuna kwamu kwa biribiri. ");
INSERT INTO rub_vpl VALUES ("PS69_14","020_69_14","PSA","69","14","14","Ncungura kuruga mu cogodo, otandeka nkabbuta, njuna bab̯wo bannobi̱ri̱, onjune na kuruga mu meezi̱ ga ndi̱ha. ");
INSERT INTO rub_vpl VALUES ("PS69_15","020_69_15","PSA","69","15","15","Otaleka bijanga kunkuuta, nkabbu̱ti̱ra mu meezi̱ rundi nkamerwa cogodo. ");
INSERT INTO rub_vpl VALUES ("PS69_16","020_69_16","PSA","69","16","16","Ai̱ Mukama, nzi̱ramwo, hab̯wa b̯urungi b̯wa ngonzi zaamu zinene, hab̯wa kisa kyamu kinene nzegwa. ");
INSERT INTO rub_vpl VALUES ("PS69_17","020_69_17","PSA","69","17","17","Otabi̱sa mei̱so gaamu hali muheereza waamu, nzi̱ramwo b̯wangu kubba ndi mu b̯ujune. ");
INSERT INTO rub_vpl VALUES ("PS69_18","020_69_18","PSA","69","18","18","Weesu̱ma heehi̱ nagya onjune, ncungura hab̯wa banyanzigwa bange. ");
INSERT INTO rub_vpl VALUES ("PS69_19","020_69_19","PSA","69","19","19","Weegi̱ri̱ ku̱lu̱mwa kwange, na muswaru gwange kandi kugaywa kundimwo, banyanzigwa bange bensei̱ obeegi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS69_20","020_69_20","PSA","69","20","20","Bi̱lu̱mo bi̱nzi̱ti̱ri̱ mutima, bi̱nti̱gi̱ri̱ ntali na maani, ntoleerye akungiira kisa, bei̱tu̱ atakabbeho, na naaku̱mpu̱mu̱u̱lya ntakamuwone. ");
INSERT INTO rub_vpl VALUES ("PS69_21","020_69_21","PSA","69","21","21","B̯unyaali nzala bampeeri̱ bidyo bikwisana nka b̯utwa, nyoota b̯u̱gyankweti̱, bampeeri̱ vi̱i̱no gilulu gyogyo nnywe. ");
INSERT INTO rub_vpl VALUES ("PS69_22","020_69_22","PSA","69","22","22","Leka magenyi̱ gaab̯u gafooke nka mutegu, na b̯u̱si̱nge b̯ubali nab̯wo b̯u̱bafookere mukorogo. ");
INSERT INTO rub_vpl VALUES ("PS69_23","020_69_23","PSA","69","23","23","Leka mei̱so gaab̯u geijale aleke batawona, kandi magulu gaab̯u geicale nigakankana. ");
INSERT INTO rub_vpl VALUES ("PS69_24","020_69_24","PSA","69","24","24","Obakwatirwe ki̱ni̱ga kyamu, leka b̯usungu b̯wamu b̯ukwaka b̯ubadweho. ");
INSERT INTO rub_vpl VALUES ("PS69_25","020_69_25","PSA","69","25","25","B̯wicalu b̯wab̯u gabbe makandi, hatabbaho noomwei̱ akwicala mu heema zaab̯u. ");
INSERT INTO rub_vpl VALUES ("PS69_26","020_69_26","PSA","69","26","26","Kubba bahi̱gani̱za yogwo gi̱waafu̱bi̱i̱ri̱, ni̱bateerya kukuuta bab̯wo booru̱mi̱i̱rye. ");
INSERT INTO rub_vpl VALUES ("PS69_27","020_69_27","PSA","69","27","27","Bateerye kifubiro ha kifubiro, kandi otabaganyira. ");
INSERT INTO rub_vpl VALUES ("PS69_28","020_69_28","PSA","69","28","28","Leka basusurwe mu kitabbu kya boomi, leka batabalirwa hamwei̱ na ba mananu. ");
INSERT INTO rub_vpl VALUES ("PS69_29","020_69_29","PSA","69","29","29","Ndimu kuwonawona kandi mu b̯u̱ru̱mi̱, ai̱ Ruhanga, leka kujuna kwamu kundindenge! ");
INSERT INTO rub_vpl VALUES ("PS69_30","020_69_30","PSA","69","30","30","Nkwi̱za kuhaariiza Ruhanga na kyembu, nkwi̱za kumuha ki̱ti̱i̱ni̱sa na ku̱mu̱si̱i̱ma. ");
INSERT INTO rub_vpl VALUES ("PS69_31","020_69_31","PSA","69","31","31","Kiki ki̱kwi̱za kusemeera Mukama kukira kumuhongera nte, rundi kumuhongera nnumi giwa mahembe na bi̱nompo. ");
INSERT INTO rub_vpl VALUES ("PS69_32","020_69_32","PSA","69","32","32","Bab̯u̱ndaaru̱ b̯ubaliwona ki̱kyo balisemereerwa, nywe batoolya Ruhanga, leke mitima myenyu̱ mi̱rwemwo. ");
INSERT INTO rub_vpl VALUES ("PS69_33","020_69_33","PSA","69","33","33","Hab̯wakubba Mukama yeegwa bali mu b̯wetaagu, kandi ti̱yeebeera bantu baamwe bali banyankomo. ");
INSERT INTO rub_vpl VALUES ("PS69_34","020_69_34","PSA","69","34","34","Leka iguru na nsi bi̱mu̱haari̱i̱ze, mataka na binyakulimwo byensei̱. ");
INSERT INTO rub_vpl VALUES ("PS69_35","020_69_35","PSA","69","35","35","Kubba Ruhanga alijuna Sayu̱u̱ni̱ kandi abi̱mbe mbuga za mu Yu̱da, bantu balicalamwo kandi balugweterwe, ");
INSERT INTO rub_vpl VALUES ("PS69_36","020_69_36","PSA","69","36","36","beizukulu ba baheereza baamwe balilugweterwa, na bab̯wo bendya ibara lyamwe, boobo bali̱lwicalamwo. ");
INSERT INTO rub_vpl VALUES ("PS70_1","020_70_1","PSA","70","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱. Zabbu̱li̱ gya Dau̱di̱. Gi̱kwi̱zu̱ka kugaba. Ai̱ Ruhanga wanguha oncungura, ai̱ Mukama wanguha onjune. ");
INSERT INTO rub_vpl VALUES ("PS70_2","020_70_2","PSA","70","2","2","Leka baku̱toolya ku̱nzi̱ta bakwatwe nsoni̱ kandi bahugutane, bakwendya mpwerekeere bemuke na muswaru. ");
INSERT INTO rub_vpl VALUES ("PS70_3","020_70_3","PSA","70","3","3","Leka beicala nibamponereerya nibambweranga nti, “Ee, koowonewone,” bemuke na muswaru! ");
INSERT INTO rub_vpl VALUES ("PS70_4","020_70_4","PSA","70","4","4","Bensei̱ baku̱toolya, bajaguze kandi basemererwe muli weewe, leka bab̯wo bendya kujunwa kwamu, beicalenge nibakoba yati, “Ruhanga wamaani!” ");
INSERT INTO rub_vpl VALUES ("PS70_5","020_70_5","PSA","70","5","5","Bei̱tu̱ gya ndi munaku kandi mu b̯wetaagu, ai̱ Ruhanga i̱za b̯wangu hali gya, weewe Mu̱ju̱ni̱ kandi mu̱cu̱ngu̱ri̱ wange, ai̱ Mukama, otakereerwa. ");
INSERT INTO rub_vpl VALUES ("PS71_1","020_71_1","PSA","71","1","1","Ai̱ Mukama mu weewe, hooho nzi̱ru̱ki̱i̱ri̱, otandeka nkaswara. ");
INSERT INTO rub_vpl VALUES ("PS71_2","020_71_2","PSA","71","2","2","Onjune kandi oncungure hab̯wa mananu gaamu, ntegera mapokopo gaamu, onjune! ");
INSERT INTO rub_vpl VALUES ("PS71_3","020_71_3","PSA","71","3","3","Mbeera lubbaali lwa kwebi̱si̱ramwo, ha nkusobora kugyendanga, hu̱lu̱kya kiragiro kya kunjuna, bba lubbaali lwange kandi lugo lwange. ");
INSERT INTO rub_vpl VALUES ("PS71_4","020_71_4","PSA","71","4","4","Ai̱ Ruhanga wange, ncungura kuruga mu mikono mya nkori̱ za bibii, oncungure kuruga mu mikono mya bantu babiibi na badulu ba bbuuru. ");
INSERT INTO rub_vpl VALUES ("PS71_5","020_71_5","PSA","71","5","5","Hab̯wakubba Mukama weewe ku̱ni̱hi̱ra kwange, hanteeka b̯u̱si̱gi̱ki̱ro kuruga mu b̯uto b̯wange. ");
INSERT INTO rub_vpl VALUES ("PS71_6","020_71_6","PSA","71","6","6","B̯womi b̯wange b̯wensei̱ b̯wehomeereeri̱ weewe, ondi̱ndi̱ri̱ kuruga nyaabyali̱i̱rwe. Ndiicala ninkuhaariizanga. ");
INSERT INTO rub_vpl VALUES ("PS71_7","020_71_7","PSA","71","7","7","Nceeri̱ kyakusungwa mu bantu banene, bei̱tu̱ weewe lugo lwange lu̱si̱gi̱ku̱. ");
INSERT INTO rub_vpl VALUES ("PS71_8","020_71_8","PSA","71","8","8","Mu̱nwa gwange gwi̱zwi̱ri̱ bigambu bya kukuhaariiza, na ki̱ti̱i̱ni̱sa kyamu kiro kyensei̱. ");
INSERT INTO rub_vpl VALUES ("PS71_9","020_71_9","PSA","71","9","9","Otalindeka b̯undibba ngu̱lu̱u̱si̱ri̱, otalinzebeera b̯undibba ntali na maani. ");
INSERT INTO rub_vpl VALUES ("PS71_10","020_71_10","PSA","71","10","10","Kubba banyanzigwa bange bakumbaza kubii, bakora rukwe lwa ku̱nzi̱ta nibaraganira hamwei̱. ");
INSERT INTO rub_vpl VALUES ("PS71_11","020_71_11","PSA","71","11","11","Bakoba yati, “Ruhanga amwebeereeri̱. Mu̱mu̱bi̱nge kandi mumukwate, kubba tihaloho akusobora kumujuna.” ");
INSERT INTO rub_vpl VALUES ("PS71_12","020_71_12","PSA","71","12","12","Ai̱ Ruhanga otabba hadei na gya, ai̱ Ruhanga wange i̱za b̯wangu onjune! ");
INSERT INTO rub_vpl VALUES ("PS71_13","020_71_13","PSA","71","13","13","Leka baku̱mpangi̱ri̱i̱rya bakwatwe nsoni̱ kandi bahwerekeere, leka bakwendya kumputaaza bahugutane kandi basware. ");
INSERT INTO rub_vpl VALUES ("PS71_14","020_71_14","PSA","71","14","14","Bei̱tu̱ gya nyaabbanga na ku̱ni̱hi̱ra, ninkuhaariizanga b̯utalekeera. ");
INSERT INTO rub_vpl VALUES ("PS71_15","020_71_15","PSA","71","15","15","Mu̱nwa gwange gulibazanga ha mananu gaamu, ga kujuna kwamu kiro kyensei̱, kubba b̯unene b̯wago b̯u̱nki̱i̱ri̱ kwetegereza. ");
INSERT INTO rub_vpl VALUES ("PS71_16","020_71_16","PSA","71","16","16","Ai̱ Mukama Wab̯u̱sobozi̱, nkwi̱za kurangiira byamaani byokora, nkwi̱za kurangiira mananu gaamu weewe musa. ");
INSERT INTO rub_vpl VALUES ("PS71_17","020_71_17","PSA","71","17","17","Ai̱ Ruhanga, kuruga mu b̯uto wange wanzegeseerye, kandi ntakarangiira ha kuhuniira kwa bya mahanu byamu. ");
INSERT INTO rub_vpl VALUES ("PS71_18","020_71_18","PSA","71","18","18","Ai̱ Ruhanga, nab̯u̱ndi̱gu̱lu̱u̱sa nkamera mbwi̱ otalindeka, mpaka b̯udirangiira b̯u̱sobozi̱ b̯wamu hali mi̱hi̱hi̱ mi̱kwi̱zaho, na mi̱myo milihonderaho. ");
INSERT INTO rub_vpl VALUES ("PS71_19","020_71_19","PSA","71","19","19","Ai̱ Ruhanga, mananu gaamu gadwa kwiguru, weewe okora bintu byamaani. Ai̱ Ruhanga naani ali nka we? ");
INSERT INTO rub_vpl VALUES ("PS71_20","020_71_20","PSA","71","20","20","Kadi wakabba weewe ondeki̱ri̱ mbonawona kyakalasanu̱, bei̱tu̱ b̯womi b̯wange oli̱b̯wi̱ryamwo b̯uhyaka, na b̯undiraba hansi kuzumu, oli̱mpu̱lu̱kya hanzei. ");
INSERT INTO rub_vpl VALUES ("PS71_21","020_71_21","PSA","71","21","21","Oli̱nzongera ki̱ti̱i̱ni̱sa kandi ompu̱mu̱u̱lye. ");
INSERT INTO rub_vpl VALUES ("PS71_22","020_71_22","PSA","71","22","22","Nkwi̱za kukuhaariiza ninkukuutira ki̱dongo kubba oicala mwesigwa, nku̱hi̱i̱mi̱re ninkuhaariiza na ndi̱ngi̱di̱, uwe Ruhanga mutongoole wa I̱saleeri̱. ");
INSERT INTO rub_vpl VALUES ("PS71_23","020_71_23","PSA","71","23","23","Nkwi̱za ku̱ku̱hi̱i̱mi̱ra nkuhaariize nakusemereerwa, hab̯wakubba oncu̱ngwi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS71_24","020_71_24","PSA","71","24","24","Nkwi̱za kubazanga ha bya mananu gaamu b̯u̱kakeeri̱, kubba bei̱ceeri̱ kwendya kunkola kubiibi basweri̱. ");
INSERT INTO rub_vpl VALUES ("PS72_1","020_72_1","PSA","72","1","1","Zabbu̱li̱ gya Sulumaani. Ai̱ Ruhanga, ha Mukama b̯winganiza b̯wamu, na b̯unanu b̯wamu hali mwana wa mu kikaali! ");
INSERT INTO rub_vpl VALUES ("PS72_2","020_72_2","PSA","72","2","2","Leka aramurenge bantu baamu na mananu, baseege baamu abacungure na b̯winganiza! ");
INSERT INTO rub_vpl VALUES ("PS72_3","020_72_3","PSA","72","3","3","Leka nsahu zileeteho ku̱hwa, mu mbamba habbemwo bijuma bya mananu. ");
INSERT INTO rub_vpl VALUES ("PS72_4","020_72_4","PSA","72","4","4","Leka alwaniire b̯winganiza b̯wa b̯anaku mu bantu baamu, kandi ocungure baana ba baseege, aswaswane bakubamigiriza. ");
INSERT INTO rub_vpl VALUES ("PS72_5","020_72_5","PSA","72","5","5","Leka bakutekengemwo ki̱ti̱i̱ni̱sa kalyoba nikakusuuka, na mu kwaka kwa mweri̱, ku̱doosya mi̱hi̱hi̱ myensei̱. ");
INSERT INTO rub_vpl VALUES ("PS72_6","020_72_6","PSA","72","6","6","Leke b̯u̱lemi̱ b̯wamwe b̯ubbe nka ndagali̱ gi̱gwi̱ri̱ mu musiri, abbe nka meezi̱ galimwo ku̱lu̱bya itehe. ");
INSERT INTO rub_vpl VALUES ("PS72_7","020_72_7","PSA","72","7","7","Leka mu biro bi̱byo habbeho mananu, kandi habbeho b̯u̱si̱nge ku̱doosya mweri̱ b̯ugulimalikaho. ");
INSERT INTO rub_vpl VALUES ("PS72_8","020_72_8","PSA","72","8","8","Leka aleme kuruga ha mataka kudwa ha mataka, kandi kuruga ha Mugira Efu̱raati̱ kudwa ha mmaliiro gya nsi! ");
INSERT INTO rub_vpl VALUES ("PS72_9","020_72_9","PSA","72","9","9","Leka bantu ba mu nsi gya ndala bamugondere, kandi banyanzigwa baamwe bei̱ze hali yo nibakwagula mwicuucu. ");
INSERT INTO rub_vpl VALUES ("PS72_10","020_72_10","PSA","72","10","10","Leka bakama ba Tarasi̱i̱si̱ na ba mu bi̱zi̱nga, bamu̱leetere bisembu, bakama ba Sebba na Seba nabo balimuletera bya b̯u̱gu̱u̱da. ");
INSERT INTO rub_vpl VALUES ("PS72_11","020_72_11","PSA","72","11","11","Bakama bensei̱ beetu̱lu̱ke hansi, kandi mahanga gensei̱ gamuheereze. ");
INSERT INTO rub_vpl VALUES ("PS72_12","020_72_12","PSA","72","12","12","Alijuna baseege bakutaaga, na batakwesobora. ");
INSERT INTO rub_vpl VALUES ("PS72_13","020_72_13","PSA","72","13","13","Aganyire baceke na bakwetaaga, bakwetaaga abajune lu̱ku̱u̱. ");
INSERT INTO rub_vpl VALUES ("PS72_14","020_72_14","PSA","72","14","14","Abacungure kuruga mu kumigirizib̯wa na mu b̯wemi̱, kubba ibbanga lyab̯u lili lya muhendu mu mei̱so gaamwe. ");
INSERT INTO rub_vpl VALUES ("PS72_15","020_72_15","PSA","72","15","15","Womeera biro binene! Leka bamuhe zaabbu kuruga mu Sebba. Leka bantu beicale nibamusabiranga, ni̱bamu̱si̱i̱ma b̯u̱kakeeri̱. ");
INSERT INTO rub_vpl VALUES ("PS72_16","020_72_16","PSA","72","16","16","Leka nsi gibbe na magesa ga mpuule zinene, na nsahu zibbumbwe na bilimwa. Leka bijuma byaho bi̱nyengetere nka lebbanooni̱, leka bantu bakanye mu rub̯uga nka isubi lya mu ndimiro. ");
INSERT INTO rub_vpl VALUES ("PS72_17","020_72_17","PSA","72","17","17","Leka ibara lyamwe liicaleho biro byensei̱, libbeho paka kudwa lyoba kumalika, aleke bantu bamwi̱zu̱kenge, nibacaali boomi. ");
INSERT INTO rub_vpl VALUES ("PS72_18","020_72_18","PSA","72","18","18","Ahaariizwe Mukama Ruhanga wʼI̱saleeri̱, yogwo yankei akora bi̱ku̱hu̱u̱ni̱ri̱za. ");
INSERT INTO rub_vpl VALUES ("PS72_19","020_72_19","PSA","72","19","19","Ibara lyamwe lihaariizwe biro byensei̱, aleke nsi gyensei̱ gizulemwo ki̱ti̱i̱ni̱sa kyamwe. ");
INSERT INTO rub_vpl VALUES ("PS72_20","020_72_20","PSA","72","20","20","Haha hooho kusaba kwa Dau̱di̱ mu̱tabani̱ wa Yese ku̱mali̱ki̱i̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS73_1","020_73_1","PSA","73","1","1","Zabbu̱li̱ gyʼAsafi̱. Mu mananu Ruhanga ali murungi hali I̱saleeri̱, na maani maani hali banyamitima mi̱syanu̱. ");
INSERT INTO rub_vpl VALUES ("PS73_2","020_73_2","PSA","73","2","2","Bei̱tu̱ kadooli̱ nkibbale, magulu gange gaatereb̯u̱ki̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS73_3","020_73_3","PSA","73","3","3","Hab̯wakubba nyaakwati̱i̱rwe i̱hali̱, b̯u̱nyaaweeni̱ nkori̱ za bibii ni̱zi̱ku̱hwa. ");
INSERT INTO rub_vpl VALUES ("PS73_4","020_73_4","PSA","73","4","4","Nahab̯waki̱kyo tibatalibana, mibiri myab̯u miicala myomi kandi mi̱nyi̱ri̱ru̱. ");
INSERT INTO rub_vpl VALUES ("PS73_5","020_73_5","PSA","73","5","5","Tibabba na b̯ujune nka bandi, tibakwatwaho nseeri̱ za bantu bandi. ");
INSERT INTO rub_vpl VALUES ("PS73_6","020_73_6","PSA","73","6","6","Nahab̯waki̱kyo balwala kwehaariiza nka lu̱kwanzi̱, b̯wemi̱ b̯ubabbumba nka kilwalu. ");
INSERT INTO rub_vpl VALUES ("PS73_7","020_73_7","PSA","73","7","7","Mei̱so gabaku̱du̱mu̱ki̱ri̱ nka mudya masaju, mitima myab̯u miicala mi̱zwi̱ri̱ biteekerezu bibiibi. ");
INSERT INTO rub_vpl VALUES ("PS73_8","020_73_8","PSA","73","8","8","Beicala nibasekereerya na kubaza bi̱ku̱zi̱nda bantu, myehaariizo myab̯u mibaha ku̱wonawonesya bantu. ");
INSERT INTO rub_vpl VALUES ("PS73_9","020_73_9","PSA","73","9","9","Babaza bigambu bi̱ku̱lu̱ma Ruhanga mwiguru, na bikucookooza bantu mu nsi. ");
INSERT INTO rub_vpl VALUES ("PS73_10","020_73_10","PSA","73","10","10","Kyokyo babetegeerya, nibekiriza na kwikiriza bi̱baku̱baweera. ");
INSERT INTO rub_vpl VALUES ("PS73_11","020_73_11","PSA","73","11","11","Beicala nibakoba, “Ruhanga asobora teetei̱ kwetegereza? Kya magezi̱ kyani kili hali yogwo Waahakyendi̱ Hoi̱?” ");
INSERT INTO rub_vpl VALUES ("PS73_12","020_73_12","PSA","73","12","12","Wona zizi nkori̱ za bibii, itungu lyab̯u lyeterya b̯weteerya b̯uli kiro. ");
INSERT INTO rub_vpl VALUES ("PS73_13","020_73_13","PSA","73","13","13","Ntakagasirwe kwicala na mutima gu̱syanu̱, na ngalu zitali na kibii kyensei̱. ");
INSERT INTO rub_vpl VALUES ("PS73_14","020_73_14","PSA","73","14","14","Mbonawona kiro kyensei̱, nakucomerwa nincomeerwa b̯uli mwakya. ");
INSERT INTO rub_vpl VALUES ("PS73_15","020_73_15","PSA","73","15","15","Kabbe nyaali nkobi̱ri̱ kubaza bya ha mutima gwange, nyaaku̱bbeeri̱ ntali wa mananu hali bantu baamu. ");
INSERT INTO rub_vpl VALUES ("PS73_16","020_73_16","PSA","73","16","16","Bei̱tu̱ b̯u̱nyalengi̱ri̱ho kwetegereza bibi byensei̱, nyei̱seeni̱ nka nkujwahira b̯usa. ");
INSERT INTO rub_vpl VALUES ("PS73_17","020_73_17","PSA","73","17","17","Ku̱doosya b̯u̱nyaagyendi̱ri̱ mu nnyu̱mba gya Ruhanga, nyetegereza mmaliriro gyab̯u. ");
INSERT INTO rub_vpl VALUES ("PS73_18","020_73_18","PSA","73","18","18","Mananu kwo obateeri̱ ha kuterera, aleke bagwe bahwerekeere. ");
INSERT INTO rub_vpl VALUES ("PS73_19","020_73_19","PSA","73","19","19","Kwokwo bazi̱ke mu b̯wi̱re b̯u̱dooli̱, bamalikaho cekeceke. ");
INSERT INTO rub_vpl VALUES ("PS73_20","020_73_20","PSA","73","20","20","Nka muntu waaloota akeeb̯wa kyalooti̱ri̱, ai̱ Mukama, b̯wolibyoka olibebeera. ");
INSERT INTO rub_vpl VALUES ("PS73_21","020_73_21","PSA","73","21","21","Mwozo gwange b̯u̱gwasali̱i̱rwe, mutima gwange niguganya. ");
INSERT INTO rub_vpl VALUES ("PS73_22","020_73_22","PSA","73","22","22","Nyaafooki̱ri̱ mudoma, kandi atali na kwetegereza, nyaabba nka kisolo mu mei̱so gaamu. ");
INSERT INTO rub_vpl VALUES ("PS73_23","020_73_23","PSA","73","23","23","Bei̱tu̱ nab̯wo ncaali nawe, onkwati̱ri̱i̱ri̱ mukono gwange gwab̯udyo. ");
INSERT INTO rub_vpl VALUES ("PS73_24","020_73_24","PSA","73","24","24","Onyehembera na magezi̱ gaamu, mwomwo ontangiire kubba mu ki̱ti̱i̱ni̱sa kyamu. ");
INSERT INTO rub_vpl VALUES ("PS73_25","020_73_25","PSA","73","25","25","Naani wondi gindinayo mwiguru kutoolaho weewe? B̯undi nawe, kyani kindi ki̱nkwendya ku nsi? ");
INSERT INTO rub_vpl VALUES ("PS73_26","020_73_26","PSA","73","26","26","Mubiri gwange na mutima gwange bisobora kulemwa, bei̱tu̱ Ruhanga yooyo maani ga mutima gwange, na mugab̯u gwange biro byensei̱. ");
INSERT INTO rub_vpl VALUES ("PS73_27","020_73_27","PSA","73","27","27","Wona, bab̯wo bali hadei nawe, bakwi̱za ku̱zi̱ka, b̯uli atali mwesigwa okwi̱za ku̱mu̱hwerekereerya. ");
INSERT INTO rub_vpl VALUES ("PS73_28","020_73_28","PSA","73","28","28","Bei̱tu̱ gya kirungi kwicala heehi̱ na Ruhanga, Mukama Ruhanga yooyo nteeri̱ abbe b̯wi̱ru̱ki̱ro b̯wange, kyokyo ndikuheera b̯u̱kei̱so b̯wa milimo myamu myensei̱. ");
INSERT INTO rub_vpl VALUES ("PS74_1","020_74_1","PSA","74","1","1","Masikili gyʼAsafi̱. Ai̱ Ruhanga, hab̯waki otu̱gu̱mi̱reseeni̱ biro byensei̱? Hab̯waki ki̱ni̱ga kyamu kibyokera ntaama za mwi̱li̱si̱i̱ryo lyamu? ");
INSERT INTO rub_vpl VALUES ("PS74_2","020_74_2","PSA","74","2","2","I̱zu̱ka bantu baamu ba waagu̱u̱ri̱ kadei, ki̱wacu̱ngu̱u̱ri̱ kibbe luganda lwa mugab̯u gwamu, i̱zu̱ka lusahu Sayu̱u̱ni̱ hoicalira. ");
INSERT INTO rub_vpl VALUES ("PS74_3","020_74_3","PSA","74","3","3","Gyendira ki̱mwei̱ odwe ha makandi ga biro na biro, na ha Yeekaru gya munyanzigwa yaazi̱ki̱i̱rye kubiibi. ");
INSERT INTO rub_vpl VALUES ("PS74_4","020_74_4","PSA","74","4","4","Banyanzigwa baamu baalu̱ki̱ri̱ mu Yeekaru, baabyokya bbendera kwolokya nka ku̱basi̱ngwi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS74_5","020_74_5","PSA","74","5","5","Bei̱sanengi̱ nka bakweti̱ mpasa, kutema misaali mu kibira. ");
INSERT INTO rub_vpl VALUES ("PS74_6","020_74_6","PSA","74","6","6","Baatematemi̱ri̱ bintu biheese bya mbaahu byensei̱, ni̱bakoresya mpasa na bipanga. ");
INSERT INTO rub_vpl VALUES ("PS74_7","020_74_7","PSA","74","7","7","Yeekaru gyamu baagi̱kolereeryeho mworo, baaswezi̱ cali baku̱rami̱i̱rya. ");
INSERT INTO rub_vpl VALUES ("PS74_8","020_74_8","PSA","74","8","8","Baaweeragana yati, “Tubaswaswanire ki̱mwei̱,” bookeerye marami̱i̱ryo gensei̱ ga Ruhanga mu nsi gi̱gyo. ");
INSERT INTO rub_vpl VALUES ("PS74_9","020_74_9","PSA","74","9","9","Tituli na b̯wakuwoneraho b̯wamu, tihacaalihoona mu̱ragu̱ri̱ waamu mu nsi, kandi tihaloho akusobora kutuweera hakikumaliira. ");
INSERT INTO rub_vpl VALUES ("PS74_10","020_74_10","PSA","74","10","10","Ai̱ Ruhanga, munyanzigwa, ali̱ku̱sekereerya ku̱doosya di̱i̱? Biro byensei̱, yeicaalanga naalu̱ma ibara lyamu? ");
INSERT INTO rub_vpl VALUES ("PS74_11","020_74_11","PSA","74","11","11","Hab̯waki otabba na kyokoori̱ho? Hu̱lu̱kya mukono gwamu gwab̯udyo obazi̱kye. ");
INSERT INTO rub_vpl VALUES ("PS74_12","020_74_12","PSA","74","12","12","Bei̱tu̱ nab̯wo, oli Ruhanga Mukama wange, wa kadei, ojuna bantu mu nsi. ");
INSERT INTO rub_vpl VALUES ("PS74_13","020_74_13","PSA","74","13","13","Waahu̱kani̱i̱rye itaka likooto na b̯u̱sobozi̱ b̯wamu, waaku̱u̱ti̱ri̱ mi̱twe mya banyanzigwa ba mwitaka. ");
INSERT INTO rub_vpl VALUES ("PS74_14","020_74_14","PSA","74","14","14","Waaku̱u̱ti̱ri̱ mi̱twe mya kihiri, waakiha bihangwa bya mwihamba bikidye. ");
INSERT INTO rub_vpl VALUES ("PS74_15","020_74_15","PSA","74","15","15","Weewe waaki̱ngu̱u̱ri̱ migira na mazu̱ba, migira minyakwicalanga nimiheta kadei na kadei, weewe waamyomereerye ki̱mwei̱. ");
INSERT INTO rub_vpl VALUES ("PS74_16","020_74_16","PSA","74","16","16","Mwinsi nei̱jolo byensei̱ byamu, weewe waateeri̱ho bimuluka byensei̱ na kalyoba. ");
INSERT INTO rub_vpl VALUES ("PS74_17","020_74_17","PSA","74","17","17","Waateeri̱ho mitaanu mya nsi, waateekaho kyanda na kibbaga. ");
INSERT INTO rub_vpl VALUES ("PS74_18","020_74_18","PSA","74","18","18","Ai̱ Mukama i̱zu̱ka munyanzigwa nka kwakukuseka, kandi bantu badoma ku̱baku̱ku̱lu̱ma. ");
INSERT INTO rub_vpl VALUES ("PS74_19","020_74_19","PSA","74","19","19","Otabahayo bantu baamu hali banyanzigwa baab̯u, otalyebeeranga b̯womi wa banaku baamu. ");
INSERT INTO rub_vpl VALUES ("PS74_20","020_74_20","PSA","74","20","20","I̱zu̱ka ndagaanu gi̱waakoori̱ natwe, hab̯wakubba batemu bebi̱si̱ri̱ hensei̱, mu biikaru bya mu nti̱ti̱ ku nsi gigi. ");
INSERT INTO rub_vpl VALUES ("PS74_21","020_74_21","PSA","74","21","21","Oteikiriza muswaru gwa bantu baamu bakuwonawona, bei̱tu̱ leka banaku na bali na byetaagu bahaariizenge ibara lyamu. ");
INSERT INTO rub_vpl VALUES ("PS74_22","020_74_22","PSA","74","22","22","Ai̱ Ruhanga, byoka olwaniire ki̱ti̱i̱ni̱sa kyamu, i̱zu̱ka badoma nka ku̱baku̱lu̱ma biro byensei̱. ");
INSERT INTO rub_vpl VALUES ("PS74_23","020_74_23","PSA","74","23","23","Oteebeera myehu̱lo mya banyanzigwa baamu, neitoko lyab̯u lya b̯uli kiro. ");
INSERT INTO rub_vpl VALUES ("PS75_1","020_75_1","PSA","75","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱: bikukwata ha Otahwerekereerya. Zabbu̱li̱ gyʼAsafi̱. Kyembu. Ai̱ Ruhanga tu̱ku̱ku̱si̱i̱ma, tu̱ku̱ku̱si̱i̱ma hab̯wakubba oli heehi̱ natwe, mu mu̱li̱ngo bantu baku̱tebya byamahanu byamu. ");
INSERT INTO rub_vpl VALUES ("PS75_2","020_75_2","PSA","75","2","2","Ruhanga akukoba yati, “Ha kasu̱mi̱ koonyi̱ni̱ ka ndibba nteeri̱ho, mwomwo ndicwa musangu mu b̯winganiza. ");
INSERT INTO rub_vpl VALUES ("PS75_3","020_75_3","PSA","75","3","3","Nsi b̯u̱gi̱zi̱ngi̱zi̱ka na byensei̱ bilimwo, gyagya ntati̱i̱rya mpagi̱ zaagyo. ");
INSERT INTO rub_vpl VALUES ("PS75_4","020_75_4","PSA","75","4","4","Banyamyehembo mbaweera yati, ‘Mu̱leke kwehaariiza,’ na babiibi nimbaweera yati, ‘Mu̱leke kwetembya yatyo, ");
INSERT INTO rub_vpl VALUES ("PS75_5","020_75_5","PSA","75","5","5","mu̱leke kwetembya kyakalasanu̱, kandi mu̱leke kubaza na myehaariizo yatyo.’ ” ");
INSERT INTO rub_vpl VALUES ("PS75_6","020_75_6","PSA","75","6","6","Hab̯wakubba b̯u̱si̱ngu̱zi̱, tib̯uruga b̯uhulukalyoba rundi b̯ugwalyoba, kandi tib̯uruga mwirungu, ");
INSERT INTO rub_vpl VALUES ("PS75_7","020_75_7","PSA","75","7","7","bei̱tu̱ Ruhanga yooyo acwamwo, abyokya omwei̱ hakyendi̱, wondi naamwi̱rya hansi. ");
INSERT INTO rub_vpl VALUES ("PS75_8","020_75_8","PSA","75","8","8","Mu ngalu zaamwe Mukama, akweti̱ ki̱kopo, kilimwo maaci gakwihukira, gahyangye kurungi, akwi̱za ku̱tu̱li̱kaho nkuta agihe babiibi bensei̱ ba mu nsi, baalinywera ki̱mwei̱ nibamalaho na bikanja. ");
INSERT INTO rub_vpl VALUES ("PS75_9","020_75_9","PSA","75","9","9","Bei̱tu̱ gya nyatebyanga bya Ruhanga akoori̱, nyahi̱i̱manga, nimpaariiza Ruhanga wa Yakobbo. ");
INSERT INTO rub_vpl VALUES ("PS75_10","020_75_10","PSA","75","10","10","Myehembo mya babiibi alimitemaho, bei̱tu̱ maani ga barungi aligabyokya hakyendi̱. ");
INSERT INTO rub_vpl VALUES ("PS76_1","020_76_1","PSA","76","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱: ni̱bakoresya bikwatu bya mahu̱u̱zi̱. Zabbu̱li̱ gyʼAsafi̱. Kyembu. Ruhanga akwegebwa mu Yu̱da, ibara lyamwe lya maani mwʼI̱saleeri̱. ");
INSERT INTO rub_vpl VALUES ("PS76_2","020_76_2","PSA","76","2","2","B̯ulaalu b̯wamwe b̯ubba mu Yeru̱salemu̱, na b̯wicalu b̯wamwe gyogyo Sayu̱u̱ni̱. ");
INSERT INTO rub_vpl VALUES ("PS76_3","020_76_3","PSA","76","3","3","Ku̱kwo hooho yaacwacweni̱ mbasi za maani, ngab̯u, mpirima na byaku̱lwani̱sya bya b̯ulemu. ");
INSERT INTO rub_vpl VALUES ("PS76_4","020_76_4","PSA","76","4","4","Oli wa ki̱ti̱i̱ni̱sa, wa b̯u̱sobozi̱ kukirahoona nsahu za kadei na kadei. ");
INSERT INTO rub_vpl VALUES ("PS76_5","020_76_5","PSA","76","5","5","Balwani̱ baab̯u bamaani baabatoori̱ho minyagu myab̯u, baalaali̱iri̱ ki̱mwei̱ beebbaka. Badulu balwani̱ bensei̱, baalingi batakusobora ku̱byokya mikono. ");
INSERT INTO rub_vpl VALUES ("PS76_6","020_76_6","PSA","76","6","6","Ai̱ Ruhanga wa Yakobbo, b̯wocoomera, mu̱ni̱i̱ni̱ wa mbaraasi na mbaraasi, byensei̱ bi̱kwa b̯u̱kwi̱. ");
INSERT INTO rub_vpl VALUES ("PS76_7","020_76_7","PSA","76","7","7","Bei̱tu̱ we, Mukama, bensei̱ baku̱ti̱i̱nambe, B̯wokwatwa ki̱ni̱ga, naani akusobora kukwemeera mu mei̱so? ");
INSERT INTO rub_vpl VALUES ("PS76_8","020_76_8","PSA","76","8","8","Waabazi̱i̱ri̱ mwiguru waacwa musangu, nsi gyati̱i̱ni̱ri̱ gyetekeera cei̱. ");
INSERT INTO rub_vpl VALUES ("PS76_9","020_76_9","PSA","76","9","9","Ruhanga waabyoki̱ri̱ kucwa musangu, kujuna bakumigirizib̯wa haha ku nsi. ");
INSERT INTO rub_vpl VALUES ("PS76_10","020_76_10","PSA","76","10","10","Mu mananu, bantu b̯ubakukwatirwa ki̱ni̱ga, ki̱teeryaho ki̱ti̱i̱ni̱sa kyamu, banyakukena lu̱ku̱u̱ balikuhaariiza. ");
INSERT INTO rub_vpl VALUES ("PS76_11","020_76_11","PSA","76","11","11","Mwerage hali Mukama Ruhanga weenyu̱, kandi mu̱doosereeryenge bi̱mweragi̱ri̱, nywensei̱ bamuli heehi̱ muleterenge bisembu, yogwo akusemeera ku̱ti̱i̱nwa. ");
INSERT INTO rub_vpl VALUES ("PS76_12","020_76_12","PSA","76","12","12","Yogwo ab̯u̱ndaarya balemi̱ bamyehembu kandi naati̱i̱ni̱sya bakama ba maani. ");
INSERT INTO rub_vpl VALUES ("PS77_1","020_77_1","PSA","77","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱: bikukwata ha Jedu̱sani̱. Zabbu̱li̱ gyʼAsafi̱. Nkuutira ki̱mwei̱ mukungu hali Ruhanga, mukungira ki̱mwei̱, kandi aku̱nzegwa. ");
INSERT INTO rub_vpl VALUES ("PS77_2","020_77_2","PSA","77","2","2","Mu b̯wi̱re b̯wange b̯wa b̯ujune, ntoolereerya Mukama, tinjwaha ku̱byokya mikono myange i̱jolo lyensei̱, kandi ti̱nkabbeeri̱ kuhumula mu mutima gwange. ");
INSERT INTO rub_vpl VALUES ("PS77_3","020_77_3","PSA","77","3","3","B̯unteekerezaho Ruhanga, nindira, b̯uncumitiriza mwozo gwange nigusalika. ");
INSERT INTO rub_vpl VALUES ("PS77_4","020_77_4","PSA","77","4","4","Weewe ankwata nkwihi za mei̱so, ndemwe kwebbaka, tindi na kyakubaza hab̯wa b̯ujune b̯undi nab̯wo. ");
INSERT INTO rub_vpl VALUES ("PS77_5","020_77_5","PSA","77","5","5","Nteekereza ha biro byange bya kadei, ni̱nyi̱zu̱ka myaka myei̱nyu̱ma. ");
INSERT INTO rub_vpl VALUES ("PS77_6","020_77_6","PSA","77","6","6","I̱jolo lyensei̱ ndimalira mu biteekerezu, b̯uncumitiriza nyeb̯u̱u̱lya yati, ");
INSERT INTO rub_vpl VALUES ("PS77_7","020_77_7","PSA","77","7","7","“Mukama alitugumirisana kudwa di̱i̱? Tali̱i̱ra kubba na mbabazi̱? ");
INSERT INTO rub_vpl VALUES ("PS77_8","020_77_8","PSA","77","8","8","Ngonzi zaamwe zinene za kadei na kadei, zaamali̱ki̱ri̱? Kweraga kwamwe kwa biro byensei̱ kuli hanya? ");
INSERT INTO rub_vpl VALUES ("PS77_9","020_77_9","PSA","77","9","9","Ruhanga yeebereeri̱ kubba na mbabazi̱? Hab̯wa ki̱ni̱ga, tacaali na kisa?” ");
INSERT INTO rub_vpl VALUES ("PS77_10","020_77_10","PSA","77","10","10","Mwomwo nyaabazi̱ri̱ ninkoba yati, “Kiki kyokyo kikira kunsaliza, nti Ruhanga, Waahakyendi̱ Hoi̱, tokyakatujuna.” ");
INSERT INTO rub_vpl VALUES ("PS77_11","020_77_11","PSA","77","11","11","Ai̱ Mukama, b̯u̱ntekereza ha byokoori̱, nyi̱zu̱ka byamahanu bi̱waakoori̱ kadei. ");
INSERT INTO rub_vpl VALUES ("PS77_12","020_77_12","PSA","77","12","12","Nditeekereza ha milimo myamu, mutima gwange ni̱gu̱toolereerya byensei̱ bi̱waakoori̱. ");
INSERT INTO rub_vpl VALUES ("PS77_13","020_77_13","PSA","77","13","13","Ai̱ Ruhanga, muhanda gwamu gubba gutongoole. Mbandwa kyani gikwijanjana Ruhanga weetu̱ wamaani? ");
INSERT INTO rub_vpl VALUES ("PS77_14","020_77_14","PSA","77","14","14","Oli Ruhanga akora byamahanu, woolokeerye b̯u̱sobozi̱ b̯wamu mu mahanga. ");
INSERT INTO rub_vpl VALUES ("PS77_15","020_77_15","PSA","77","15","15","Waacu̱ngu̱u̱ri̱ bantu baamu na mukono gwamu, baana ba Yakobbo na Yozefu̱. ");
INSERT INTO rub_vpl VALUES ("PS77_16","020_77_16","PSA","77","16","16","Ai̱ Ruhanga, meezi̱ b̯u̱gaaku̱weeni̱, meezi̱ b̯u̱gaaku̱weeni̱, gaati̱i̱na, kwokwo na ndi̱ha gyakankeeni̱. ");
INSERT INTO rub_vpl VALUES ("PS77_17","020_77_17","PSA","77","17","17","Byalu byabbwoma meezi̱, iguru lyaleeta nkuba, mbasi zaamu zaamyangasanengi̱. ");
INSERT INTO rub_vpl VALUES ("PS77_18","020_77_18","PSA","77","18","18","Kyalu kyati̱ndi̱ri̱ mwiguru nkuba zaaserya hensei̱, nsi gyakankeeni̱ kandi gyatengeeta. ");
INSERT INTO rub_vpl VALUES ("PS77_19","020_77_19","PSA","77","19","19","Waasaari̱ nzira mwitaka, waacwa itaka lilei, bei̱tu̱ nab̯wo tihaloho munyakuwona lugere lwamu. ");
INSERT INTO rub_vpl VALUES ("PS77_20","020_77_20","PSA","77","20","20","Weebembeeri̱ bantu baamu nkeigana lya ntaama, nookoresya Mu̱sa nʼAlooni̱. ");
INSERT INTO rub_vpl VALUES ("PS78_1","020_78_1","PSA","78","1","1","Masikili gyʼAsafi̱. Nywe bantu bange, mu̱tege mapokopo mwetegeerye kwegesya kwange, mu̱ku̱nku̱mu̱le mapokopo geenyu̱ mwetegeerye bigambu byange! ");
INSERT INTO rub_vpl VALUES ("PS78_2","020_78_2","PSA","78","2","2","Ndibazira mu ngeera, nsoboore bigambu bikuhuneeza bya kadei, ");
INSERT INTO rub_vpl VALUES ("PS78_3","020_78_3","PSA","78","3","3","bintu bitwegwi̱ri̱ kandi byegebeerwe, bya bahaaha beetu̱ baatu̱weereeri̱. ");
INSERT INTO rub_vpl VALUES ("PS78_4","020_78_4","PSA","78","4","4","Ti̱tu̱li̱bi̱bi̱sa baana baab̯u, bei̱tu̱ tulibiweera mu̱hi̱hi̱ gu̱kwi̱za bikorwa bya ki̱ti̱i̱ni̱sa Mukama bi̱yaakoori̱, na b̯u̱sobozi̱ b̯wamwe, kandi na byamahanu bi̱yaakoori̱. ");
INSERT INTO rub_vpl VALUES ("PS78_5","020_78_5","PSA","78","5","5","Yaateeri̱i̱ho b̯u̱kei̱so mu Yakobbo, yaaha I̱saleeri̱ biragiro, yaaragira bahaaha beetu̱, ku̱byegesya baana baab̯u, ");
INSERT INTO rub_vpl VALUES ("PS78_6","020_78_6","PSA","78","6","6","kwokwo mu̱hi̱hi̱ gu̱kwi̱za gubyege, na baana bacaali kubyalwa. Kandi nabo baweera baana baab̯u. ");
INSERT INTO rub_vpl VALUES ("PS78_7","020_78_7","PSA","78","7","7","Aleke beege kwesiga Ruhanga, kandi baleke kwebeera milimo mya Ruhanga, bei̱tu̱ bakwate biragiro byamwe, ");
INSERT INTO rub_vpl VALUES ("PS78_8","020_78_8","PSA","78","8","8","aleke batalibba nka bahaaha baab̯u, banyakubba bajeemu̱ kandi banyab̯wemi̱, banyamitima miceke, banyamyozo mitali myesigwa hali Ruhanga. ");
INSERT INTO rub_vpl VALUES ("PS78_9","020_78_9","PSA","78","9","9","Baalula lwʼEfu̱rayi̱mu̱ nab̯ubaali na b̯uta, bei̱ru̱ki̱ri̱ ha kiro kya b̯ulemu. ");
INSERT INTO rub_vpl VALUES ("PS78_10","020_78_10","PSA","78","10","10","Batakahondere ndagaanu gya Ruhanga, baasuula kugyendera mu biragiro byamwe. ");
INSERT INTO rub_vpl VALUES ("PS78_11","020_78_11","PSA","78","11","11","Beebereeri̱ bi̱yaakoori̱, na byamahanu bi̱yaabolokeerye. ");
INSERT INTO rub_vpl VALUES ("PS78_12","020_78_12","PSA","78","12","12","Yaakoori̱ byamahanu mu mei̱so ga bahaaha baab̯u, mu nsi gya Mi̱si̱ri̱, mu rub̯uga lwa Zohani̱. ");
INSERT INTO rub_vpl VALUES ("PS78_13","020_78_13","PSA","78","13","13","Yaahu̱kani̱rye itaka baalirabamwo, yaafoora meezi̱ mutuumo. ");
INSERT INTO rub_vpl VALUES ("PS78_14","020_78_14","PSA","78","14","14","B̯wi̱re b̯wa mwinsi yaabehemberengi̱ na kyalu, i̱jolo na kyererezi̱ kya mworo. ");
INSERT INTO rub_vpl VALUES ("PS78_15","020_78_15","PSA","78","15","15","Yaati̱i̱rye lubbaali na mwirungu, lwalu̱wa meezi̱ ganene, yaabaha baanywa basambalana. ");
INSERT INTO rub_vpl VALUES ("PS78_16","020_78_16","PSA","78","16","16","Meezi̱ yaagahangi̱ri̱ kuruga mu lubbaali, gaaheta nka migira. ");
INSERT INTO rub_vpl VALUES ("PS78_17","020_78_17","PSA","78","17","17","Bei̱tu̱ nab̯wo baab̯u̱ni̱i̱rye baakora kibii mu mei̱so gaamwe, baajeemeeri̱ Waahakyendi̱ Hoi̱ b̯ubaali mwirungu. ");
INSERT INTO rub_vpl VALUES ("PS78_18","020_78_18","PSA","78","18","18","Baalengi̱ri̱ Ruhanga mu mitima myab̯u, na kumusaba bidyo bi̱beegombi̱ri̱ ");
INSERT INTO rub_vpl VALUES ("PS78_19","020_78_19","PSA","78","19","19","Baalu̱mi̱ri̱ Ruhanga nibakoba yati, “Ruhanga yaakusobora kutuha bidyo nituli mwirungu? ");
INSERT INTO rub_vpl VALUES ("PS78_20","020_78_20","PSA","78","20","20","Yaati̱i̱rye lubbaali meezi̱ gaalu̱wa gaaheta na mu migira, yaakusobora kutuha bidyo, naatugabira na nyama?” ");
INSERT INTO rub_vpl VALUES ("PS78_21","020_78_21","PSA","78","21","21","Nahab̯waki̱kyo, Mukama b̯u̱yaakyegwi̱ri̱, yaakwati̱i̱rwe ki̱ni̱ga, yaahembaho Bei̱saleeri̱ mworo. ");
INSERT INTO rub_vpl VALUES ("PS78_22","020_78_22","PSA","78","22","22","Hab̯wakubba baalingi batakwikiririza mu Ruhanga, kandi baalingi batakwesiga maani ga kujuna kwamwe. ");
INSERT INTO rub_vpl VALUES ("PS78_23","020_78_23","PSA","78","23","23","Bei̱tu̱ nab̯wo yaaragi̱i̱ri̱ iguru, lyeijula nzi̱je. ");
INSERT INTO rub_vpl VALUES ("PS78_24","020_78_24","PSA","78","24","24","Kandi yaabagumira maanu baadya, yaabaha na bidyo kuruga mwiguru. ");
INSERT INTO rub_vpl VALUES ("PS78_25","020_78_25","PSA","78","25","25","Bantu baadi̱i̱ri̱ bidyo bya bamalayika, yaabasi̱ndi̱ki̱i̱ri̱ bidyo mu b̯unene. ");
INSERT INTO rub_vpl VALUES ("PS78_26","020_78_26","PSA","78","26","26","Yaaragi̱i̱ri̱ mpehu gya mu b̯uhulukalyoba gihuuhe mwiguru, kandi hab̯wa b̯u̱sobozi̱ b̯wamwe yaaragira mpehu gya mu masi̱ri̱mu̱ka gyarugayo. ");
INSERT INTO rub_vpl VALUES ("PS78_27","020_78_27","PSA","78","27","27","Yaasi̱ndi̱ki̱i̱ri̱ bantu baamwe bi̱nyoni̱ badye, bi̱nyoni̱ byei̱sanengi̱ musinyi gwa heitaka, ");
INSERT INTO rub_vpl VALUES ("PS78_28","020_78_28","PSA","78","28","28","yaabi̱ragi̱i̱ri̱ byei̱ci̱ya mu ngoonyi̱ zaab̯u, na hensei̱ cali bei̱calengi̱. ");
INSERT INTO rub_vpl VALUES ("PS78_29","020_78_29","PSA","78","29","29","Kandi baadi̱i̱ri̱ beicuta, hab̯wakubba yaabaheeri̱ ki̱bendyengi̱. ");
INSERT INTO rub_vpl VALUES ("PS78_30","020_78_30","PSA","78","30","30","Bei̱tu̱ b̯ubaali batakei̱cu̱ti̱ri̱, bidyo nibibali mu mi̱nwa, ");
INSERT INTO rub_vpl VALUES ("PS78_31","020_78_31","PSA","78","31","31","Ruhanga yaakwati̱i̱rwe ki̱ni̱ga, yei̱ta ba maani na basigazi ba mwʼI̱saleeri̱. ");
INSERT INTO rub_vpl VALUES ("PS78_32","020_78_32","PSA","78","32","32","Bi̱byo nab̯ubyabba byabbeeri̱ho baab̯u̱ni̱i̱rye bakora bibii, nab̯uhaabba habberi̱ho bikuhuneeza byamwe, nab̯wo batakeikirize. ");
INSERT INTO rub_vpl VALUES ("PS78_33","020_78_33","PSA","78","33","33","Yaakeeheerye b̯womi b̯wab̯u nka lwoya, beicala ni̱baku̱ti̱i̱na mu mitima myab̯u. ");
INSERT INTO rub_vpl VALUES ("PS78_34","020_78_34","PSA","78","34","34","B̯u̱yaakei̱tanga bamwei̱ muli bo, bakeni̱ri̱ho ni̱beezi̱ri̱mwo ni̱baatoolya Ruhanga na mitima myab̯u myensei̱. ");
INSERT INTO rub_vpl VALUES ("PS78_35","020_78_35","PSA","78","35","35","Bei̱zu̱ki̱ri̱ Ruhanga kuyaali lubbaali lwab̯u, yogwo Ruhanga, Waahakyendi̱ Hoi̱, yaali mu̱cu̱ngu̱ri̱ waab̯u. ");
INSERT INTO rub_vpl VALUES ("PS78_36","020_78_36","PSA","78","36","36","Bei̱tu̱ baamu̱jogi̱ri̱ na bigambu bya mi̱nwa myab̯u, baamu̱gobyagobya na b̯ulimi waab̯u. ");
INSERT INTO rub_vpl VALUES ("PS78_37","020_78_37","PSA","78","37","37","Mitima myab̯u mitakamub̯undalire, batakesige kiragaanu kyamwe. ");
INSERT INTO rub_vpl VALUES ("PS78_38","020_78_38","PSA","78","38","38","Hab̯wakubba abba wa mbabazi̱, yaabaganyi̱i̱ri̱ b̯ubiibi b̯wab̯u, atakabahwerekeerye, yaafu̱gengi̱ ki̱ni̱ga kyamwe, ki̱ni̱ga kyamwe atakakyolekye. ");
INSERT INTO rub_vpl VALUES ("PS78_39","020_78_39","PSA","78","39","39","Yei̱zu̱ki̱ri̱ nka b̯ubaali nibali bantu b̯untu, nka mpehu b̯u̱gi̱i̱za nigihunga nigyakala b̯u̱tei̱ra. ");
INSERT INTO rub_vpl VALUES ("PS78_40","020_78_40","PSA","78","40","40","Mirundi mingahi ni̱bamu̱jemeera mwirungu, kandi kangahi nibamusaliiza na mwirungu! ");
INSERT INTO rub_vpl VALUES ("PS78_41","020_78_41","PSA","78","41","41","Baamu̱lengi̱ri̱ mirundi na mirundi, baasaliiza yogwo Ruhanga Mu̱syanu̱ wʼI̱saleeri̱. ");
INSERT INTO rub_vpl VALUES ("PS78_42","020_78_42","PSA","78","42","42","Beebereeri̱ ki̱mwei̱ maani gaamwe, na kiro ki̱yaabacu̱ngwi̱ri̱ kuruga mu banyanzigwa baab̯u. ");
INSERT INTO rub_vpl VALUES ("PS78_43","020_78_43","PSA","78","43","43","Batakei̱zu̱ke byamahanu bi̱yaakoori̱ mu nsi gya Mi̱si̱ri̱, na bi̱yaakoori̱ mu rub̯uga lwa Zohani̱. ");
INSERT INTO rub_vpl VALUES ("PS78_44","020_78_44","PSA","78","44","44","Migira myab̯u yaami̱foori̱ri̱ ibbanga, aleke balemwe kunywa meezi̱. ");
INSERT INTO rub_vpl VALUES ("PS78_45","020_78_45","PSA","78","45","45","Yaabasi̱ndi̱ki̱i̱ri̱ ki̱du̱ndu̱li̱ kya nsohera zi̱nyaku̱baru̱mba na masonsooni̱a gaanyakubaheneera nsi. ");
INSERT INTO rub_vpl VALUES ("PS78_46","020_78_46","PSA","78","46","46","Yaaheeri̱yo bilimwa byab̯u byadib̯wa bi̱si̱i̱sa na nzi̱ge zaadya misiri myab̯u. ");
INSERT INTO rub_vpl VALUES ("PS78_47","020_78_47","PSA","78","47","47","Yaaheneeri̱ mi̱zabbi̱bbu̱ myab̯u na ndagali̱ gya mahi̱ga na kiho, mi̱ti̱i̱ni̱ myab̯u yaami̱cwekeerye na kiho. ");
INSERT INTO rub_vpl VALUES ("PS78_48","020_78_48","PSA","78","48","48","Yei̱ti̱ri̱ nte zaab̯u na ndagali̱ giwa mahi̱ga, neigana lya bisolo byab̯u na nkuba. ");
INSERT INTO rub_vpl VALUES ("PS78_49","020_78_49","PSA","78","49","49","Yaabakwati̱i̱rwe ki̱ni̱ga kinene, b̯usungu na b̯ukaya b̯wamwe kibba kitebe kya bamalayika bakazi̱kya. ");
INSERT INTO rub_vpl VALUES ("PS78_50","020_78_50","PSA","78","50","50","Atakatange ki̱ni̱ga kyamwe, habbe kubaganyira, bei̱tu̱ yaabei̱ti̱ri̱ na ki̱i̱zo. ");
INSERT INTO rub_vpl VALUES ("PS78_51","020_78_51","PSA","78","51","51","Yei̱ta mi̱zegei̱zo myensei̱ mya Mi̱si̱ri̱, kukira maani ba mu heema za Haamu. ");
INSERT INTO rub_vpl VALUES ("PS78_52","020_78_52","PSA","78","52","52","Mwomwo yeehembeeri̱ bantu baamwe nka mu̱li̱i̱sya kuyehembera ntaama, yaabarabya mwirungu nkeigana. ");
INSERT INTO rub_vpl VALUES ("PS78_53","020_78_53","PSA","78","53","53","Yaabehembeeri̱ kurungi nahab̯waki̱kyo batakabbe na b̯u̱ti̱i̱ni̱, bei̱tu̱ itaka lyameeri̱ banyanzigwa baab̯u. ");
INSERT INTO rub_vpl VALUES ("PS78_54","020_78_54","PSA","78","54","54","Yaabaleeti̱ri̱ mu nsi gyamwe gi̱syanu̱, ha nsahu ziyaali asi̱ngwi̱ri̱ na mukono gwamwe gwab̯udyo. ");
INSERT INTO rub_vpl VALUES ("PS78_55","020_78_55","PSA","78","55","55","Yaabi̱ngi̱ri̱mwo mahanga, nsi gyab̯u yaagiha bʼI̱saleeri̱ nka mugab̯u gwab̯u, mu heema zaab̯u hooho yaateeri̱ maka ga nganda zʼI̱saleeri̱. ");
INSERT INTO rub_vpl VALUES ("PS78_56","020_78_56","PSA","78","56","56","Bei̱tu̱ nab̯wo baalengi̱ri̱ Ruhanga, kandi baajeemera yogwo Waahakyendi̱ Hoi̱, baatakalinde biragiro byamwe. ");
INSERT INTO rub_vpl VALUES ("PS78_57","020_78_57","PSA","78","57","57","Baalingi bajeemu̱ nka bahaaha baab̯u kandi baatakwesigwa nka b̯uta b̯u̱bi̱nyeku̱, ");
INSERT INTO rub_vpl VALUES ("PS78_58","020_78_58","PSA","78","58","58","Baamu̱sali̱i̱ze hab̯wa bi̱bbi̱la byab̯u, i̱hali̱ lyamu̱kweti̱ hab̯wa bi̱si̱sani̱ byab̯u bi̱baramyengi̱ ");
INSERT INTO rub_vpl VALUES ("PS78_59","020_78_59","PSA","78","59","59","Ruhanga b̯u̱yaaki̱weeni̱, yaakwati̱i̱rwe b̯usungu, yaasu̱li̱i̱ri̱ ki̱mwei̱ I̱saleeri̱. ");
INSERT INTO rub_vpl VALUES ("PS78_60","020_78_60","PSA","78","60","60","Yeehoogi̱ri̱ kiikaru kyamwe kya Si̱i̱ro, na heema gyamwe hali yei̱calengi̱ mu bantu. ");
INSERT INTO rub_vpl VALUES ("PS78_61","020_78_61","PSA","78","61","61","Yei̱ki̱ri̱i̱ze banyanzigwa kunyaga sandu̱u̱ko gya kiragaanu, kinyakubba kaboneru ka b̯u̱sobozi̱ na ki̱ti̱i̱ni̱sa kyamwe. ");
INSERT INTO rub_vpl VALUES ("PS78_62","020_78_62","PSA","78","62","62","Yaaheeri̱yo bantu baamwe kwi̱twa mpirima, yoolokya b̯usungu hali bantu baamwe bayaakomi̱ri̱mwo. ");
INSERT INTO rub_vpl VALUES ("PS78_63","020_78_63","PSA","78","63","63","Batabani̱ baab̯u baabei̱ti̱i̱ri̱ mu b̯ulemu, bahara baab̯u baalemwa badulu bakubaswera. ");
INSERT INTO rub_vpl VALUES ("PS78_64","020_78_64","PSA","78","64","64","Balaami̱ baab̯u baabei̱ti̱ri̱ na mpirima na bamukaabakwere baalemwa kulira bei̱ba baab̯u. ");
INSERT INTO rub_vpl VALUES ("PS78_65","020_78_65","PSA","78","65","65","Mwomwo Mukama yaabyoki̱ri̱ nka muruga mu b̯ulo, nka mudulu wamaani aku̱tokeseb̯wa itamiiro. ");
INSERT INTO rub_vpl VALUES ("PS78_66","020_78_66","PSA","78","66","66","Yaabi̱ngi̱ri̱ baanyazigwa baamwe yaabeerya i̱nyu̱ma, kinyaakubaletere muswaru gwa biro na biro. ");
INSERT INTO rub_vpl VALUES ("PS78_67","020_78_67","PSA","78","67","67","Nahab̯waki̱kyo yaaswi̱ri̱ beizukulu ba Yozefu̱, yeehala luganda lwa Efu̱rayi̱mu̱ ");
INSERT INTO rub_vpl VALUES ("PS78_68","020_78_68","PSA","78","68","68","bei̱tu̱ yaakoma luganda lwa Yu̱da, na lusahu Sayu̱u̱ni̱ luyendya. ");
INSERT INTO rub_vpl VALUES ("PS78_69","020_78_69","PSA","78","69","69","Yaabi̱mbi̱ri̱ nnyu̱mba gyamwe yaagikora nka kiikaru kya mwiguru, yaagi̱tati̱i̱rya nka nsi gi̱yaakoori̱ gya biro byensei̱. ");
INSERT INTO rub_vpl VALUES ("PS78_70","020_78_70","PSA","78","70","70","Yaakomi̱ri̱mwo Dau̱di̱ muheereza waamwe, namutoola mu mali̱i̱si̱i̱ryo ga ntaama. ");
INSERT INTO rub_vpl VALUES ("PS78_71","020_78_71","PSA","78","71","71","Kuruga mu ku̱li̱i̱sya ntaama zinyakubba na b̯wana, yaamuleeti̱ri̱ kubba mu̱li̱i̱sya wa Yakobbo na bantu baamwe, na nsi gyamwe gyʼI̱saleeri̱ b̯ugwetwa b̯wamwe. ");
INSERT INTO rub_vpl VALUES ("PS78_72","020_78_72","PSA","78","72","72","Dau̱di̱ yaabali̱si̱i̱rye na mutima gu̱syanu̱, kandi yaabehembera na mukono gwa magezi̱. ");
INSERT INTO rub_vpl VALUES ("PS79_1","020_79_1","PSA","79","1","1","Zabbu̱li̱ gyʼAsafi̱. Ai̱ Ruhanga, banyamahanga banyagi̱ri̱ nsi gyamu, baaheneeri̱ nnyu̱mba gyamu gi̱syanu̱, Yeru̱salemu̱ baagi̱ri̱i̱rye makandi. ");
INSERT INTO rub_vpl VALUES ("PS79_2","020_79_2","PSA","79","2","2","Mitumbi mya baheereza baamu, bami̱heeri̱ masega, myomyo byakudya byago, mibiri mya barungi baamu, bami̱heeri̱ bisolo bya mwirungu. ");
INSERT INTO rub_vpl VALUES ("PS79_3","020_79_3","PSA","79","3","3","Babbwomi̱ri̱ ibbanga lyab̯u nka bakubbwoma meezi̱, kwetoroora Yeru̱salemu̱ gyensei̱, kandi tihaloho na muntu wa kubaziika. ");
INSERT INTO rub_vpl VALUES ("PS79_4","020_79_4","PSA","79","4","4","Twi̱ri̱ri̱ kintu kya ku̱lu̱mwa hali bataahi̱ batwelogoleerye, baku̱tu̱jooga nibatugaya. ");
INSERT INTO rub_vpl VALUES ("PS79_5","020_79_5","PSA","79","5","5","Ai̱ Mukama, oliicala osali̱i̱rwe biro byensei̱? Ki̱ni̱ga kyamu ki̱lyokya nka mworo kudwa di̱i̱? ");
INSERT INTO rub_vpl VALUES ("PS79_6","020_79_6","PSA","79","6","6","Kimalire ha mahanga gatakwegi̱ri̱, na makama gaateeta ibara lyamu! ");
INSERT INTO rub_vpl VALUES ("PS79_7","020_79_7","PSA","79","7","7","Hab̯wakubba, googo gei̱ti̱ri̱ beizukulu ba Yakobbo, gaaswaswana na nsi gyamwe. ");
INSERT INTO rub_vpl VALUES ("PS79_8","020_79_8","PSA","79","8","8","Otatufubira hab̯wa b̯ubiibi b̯wa bahaaha beetu̱, ganyira, i̱za b̯wangu, tituli na ku̱ni̱hi̱ra. ");
INSERT INTO rub_vpl VALUES ("PS79_9","020_79_9","PSA","79","9","9","Ai̱ Ruhanga weetu̱ tu̱li̱nde kurungi, tu̱ju̱ne otucungure, otuganyire bibii byetu̱, aleke ibara lyamu tulihe ki̱ti̱i̱ni̱sa. ");
INSERT INTO rub_vpl VALUES ("PS79_10","020_79_10","PSA","79","10","10","Mahanga kagatu̱b̯u̱u̱li̱i̱rye maani yati, “Ruhanga weenyu̱, ali hanya?” Gafubire twensei̱ nitukuwona, hab̯wa kubbwoma ibbanga lya baheereza baamu! ");
INSERT INTO rub_vpl VALUES ("PS79_11","020_79_11","PSA","79","11","11","Weegwa kutaaga kwa banyankomo, leka maani gaamu gajune bab̯wo bakugyenda ku̱kwa! ");
INSERT INTO rub_vpl VALUES ("PS79_12","020_79_12","PSA","79","12","12","Ai̱ Mukama, banyamahanga basasule mirundi musanju, hab̯wa ku̱ku̱lu̱ma ku̱baku̱lu̱mi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS79_13","020_79_13","PSA","79","13","13","Twe bantu baamu, ntaama za mwi̱li̱si̱i̱ryo lyamu, tu̱li̱ku̱si̱i̱ma biro na biro, tukuhaariize biro byensei̱ bi̱kwi̱za. ");
INSERT INTO rub_vpl VALUES ("PS80_1","020_80_1","PSA","80","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱. Bikukwata ha byakyo birungi. B̯u̱kei̱so. Zabbu̱li̱ gyʼAsafi̱. Weetegeerya we mu̱li̱i̱sya wʼI̱saleeri̱ weehembera Yozefu̱ nkeigana lya ntaama, oi̱cali̱i̱ri̱ ha kitebe hakati̱ wa bakeru̱u̱bbi̱, woolokya kyererezi̱ otumulikire. ");
INSERT INTO rub_vpl VALUES ("PS80_2","020_80_2","PSA","80","2","2","Weezolokya mu nganda za Efu̱rayi̱mu̱, Bbenyami̱i̱ni̱ na Manaase, tu̱ju̱ne na maani gaamu. ");
INSERT INTO rub_vpl VALUES ("PS80_3","020_80_3","PSA","80","3","3","Ai̱ Ruhanga, twi̱ryemwo b̯uhyaka, tu̱gi̱i̱re kisa, otujune! ");
INSERT INTO rub_vpl VALUES ("PS80_4","020_80_4","PSA","80","4","4","Ai̱ Mukama Ruhanga wa mahe, oli̱doosya hanya kukwatirwa ki̱ni̱ga kusaba kwa bantu baamu? ");
INSERT INTO rub_vpl VALUES ("PS80_5","020_80_5","PSA","80","5","5","Waatu̱di̱i̱si̱i̱rye bidyo bya b̯ujune, waatu̱heeri̱ mali̱ga googo tu̱nywe mu b̯unene. ");
INSERT INTO rub_vpl VALUES ("PS80_6","020_80_6","PSA","80","6","6","Hab̯wamu banyanzigwa batwicala nabo, bali mu ku̱tu̱sekeereerya kandi ni̱batu̱jooga. ");
INSERT INTO rub_vpl VALUES ("PS80_7","020_80_7","PSA","80","7","7","Ai̱ Ruhanga wa mahe, twi̱ryemwo b̯uhyaka, tu̱gi̱i̱re kisa, otujune! ");
INSERT INTO rub_vpl VALUES ("PS80_8","020_80_8","PSA","80","8","8","Mu Mi̱si̱ri̱ waatoori̱yo mu̱zabbi̱bbu̱, waabinga mahanga waagusimba. ");
INSERT INTO rub_vpl VALUES ("PS80_9","020_80_9","PSA","80","9","9","Waagu̱zu̱bi̱ri̱ kwokwo guhande, makolo gaagwo geesi̱mbi̱ri̱ hansi hadei, kandi gweizula nsi. ");
INSERT INTO rub_vpl VALUES ("PS80_10","020_80_10","PSA","80","10","10","Mu̱tu̱ntu̱lu̱ gwabbu̱mbi̱ri̱ nsahu, bi̱jangi̱ byaho byabbumba misaali. ");
INSERT INTO rub_vpl VALUES ("PS80_11","020_80_11","PSA","80","11","11","Bi̱jangi̱ byagwo byagaaji̱ri̱ kudwa heitaka lya Medetereni̱ani̱, na b̯usonga b̯wagwo weezali̱ri̱ ha Mugira Efu̱raati̱. ");
INSERT INTO rub_vpl VALUES ("PS80_12","020_80_12","PSA","80","12","12","Hab̯waki waabi̱nyi̱ri̱ bi̱si̱i̱ka byagwo, okaleka b̯uli mu̱gyendi̱ yensei̱ kunokola ha byana byagwo? ");
INSERT INTO rub_vpl VALUES ("PS80_13","020_80_13","PSA","80","13","13","Mpunu za mwirungu zi̱gu̱sambi̱ri̱, bisolo byensei̱ bilibata mu musiri bigudyeho. ");
INSERT INTO rub_vpl VALUES ("PS80_14","020_80_14","PSA","80","14","14","Ai̱ Ruhanga wa mahe gensei̱, kooraho kintu, lingiira na mwiguru owone, ojune gugu mu̱zabbi̱bbu̱. ");
INSERT INTO rub_vpl VALUES ("PS80_15","020_80_15","PSA","80","15","15","Mu̱zabbi̱bbu̱ gu̱weesi̱mbi̱i̱ri̱ kiki kyana ki̱i̱wehandi̱ri̱i̱rye. ");
INSERT INTO rub_vpl VALUES ("PS80_16","020_80_16","PSA","80","16","16","Baagwokeerye na mworo, baagutema gwagwa hansi. Bakahwerekeere hab̯wa mei̱so gaamu gaaki̱ni̱ga, kubawona. ");
INSERT INTO rub_vpl VALUES ("PS80_17","020_80_17","PSA","80","17","17","Tati̱i̱rya muntu waamu gi̱i̱wakomi̱ri̱mwo, mwana wa muntu gi̱waagu̱mi̱i̱rye we wankei, ");
INSERT INTO rub_vpl VALUES ("PS80_18","020_80_18","PSA","80","18","18","mwomwo ti̱tu̱li̱i̱ra kukurugaho, otuhe b̯womi, kwokwo twicalenge nitukuhaariiza! ");
INSERT INTO rub_vpl VALUES ("PS80_19","020_80_19","PSA","80","19","19","Ai̱ Mukama Ruhanga wa mahe, twi̱ryemwo b̯uhyaka, tu̱gi̱i̱re kisa, otujune! ");
INSERT INTO rub_vpl VALUES ("PS81_1","020_81_1","PSA","81","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱. Kikukwata ha Gititi Zabbu̱li̱ gyʼAsafi̱. Mu̱hi̱i̱mi̱re Ruhanga weetu̱ na kusemererwa, yooyo maani geetu̱, muhaariize Ruhanga wa Yakobbo, ");
INSERT INTO rub_vpl VALUES ("PS81_2","020_81_2","PSA","81","2","2","Mu̱ku̱ngye kyembu, mu̱cu̱kye bi̱cekere, mu̱ku̱u̱te ndi̱ngi̱di̱ na ki̱dongo. ");
INSERT INTO rub_vpl VALUES ("PS81_3","020_81_3","PSA","81","3","3","Mu̱ku̱u̱te bbu̱ru̱u̱zi̱ mweri̱ gu̱weneki̱ri̱, kandi gwi̱zwi̱ri̱, ha kiro kya B̯u̱genyi̱ b̯wetu̱. ");
INSERT INTO rub_vpl VALUES ("PS81_4","020_81_4","PSA","81","4","4","Hab̯wakubba kili kiragiro mwʼI̱saleeri̱, iteeka lya Ruhanga wa Yakobbo. ");
INSERT INTO rub_vpl VALUES ("PS81_5","020_81_5","PSA","81","5","5","Yaaki̱heeri̱ Yozefu̱, b̯u̱yaagyendi̱ri̱ ku̱ru̱mba nsi gya Mi̱si̱ri̱, haatwegwi̱ri̱ lukobo lututakukenga. ");
INSERT INTO rub_vpl VALUES ("PS81_6","020_81_6","PSA","81","6","6","Yaakobi̱ri̱ yati, “Nyaaku̱toori̱ mugugu ha mabega, nyaakuha b̯ugabe b̯utakora b̯uhinya. ");
INSERT INTO rub_vpl VALUES ("PS81_7","020_81_7","PSA","81","7","7","B̯uwaali mu b̯ujune wanzeti̱ri̱ nyaakujuna, nyakwi̱ri̱mwo nindi mu kiikaru kya nsita nyarabi̱i̱ri̱ mu nkuba, ha meezi̱ ga Meri̱bba nyaaku̱lengi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS81_8","020_81_8","PSA","81","8","8","Nywe bantu bange, mwetegeerye kulamba kwange! Ai̱ I̱saleeri̱, kabbe wanzegwi̱ri̱! ");
INSERT INTO rub_vpl VALUES ("PS81_9","020_81_9","PSA","81","9","9","Muli nywe hatalibbamwo ruhanga ategebeerwe, otaliramya ruhanga yensei̱ munyamahanga. ");
INSERT INTO rub_vpl VALUES ("PS81_10","020_81_10","PSA","81","10","10","Gyagya Ruhanga weenyu̱, munyakubatoola mu nsi gya Mi̱si̱ri̱, mu̱b̯u̱u̱le mi̱nwa mbadi̱i̱sye. ");
INSERT INTO rub_vpl VALUES ("PS81_11","020_81_11","PSA","81","11","11","“Bei̱tu̱ bantu bange, batakanzegwe, Bei̱saleeri̱ batambundalire. ");
INSERT INTO rub_vpl VALUES ("PS81_12","020_81_12","PSA","81","12","12","Nagya nkwi̱za kubaleka mu b̯wereme b̯wab̯u, bahondere kwetaaga kwab̯u. ");
INSERT INTO rub_vpl VALUES ("PS81_13","020_81_13","PSA","81","13","13","Ai̱ bantu bange, kabbe mwanzegwengi̱, I̱saleeri̱, kabbe mwakorengi̱ bi̱nkwendya! ");
INSERT INTO rub_vpl VALUES ("PS81_14","020_81_14","PSA","81","14","14","Nyaaku̱bi̱ngi̱ri̱ b̯wangu banyanzigwa beenyu̱, nimbafubira hab̯wa bibii byab̯u. ");
INSERT INTO rub_vpl VALUES ("PS81_15","020_81_15","PSA","81","15","15","Bensei̱ banyakunoba Mukama, baakwi̱zi̱ri̱ nibaagula b̯wagu̱li̱, nigibba mmaliiro gyab̯u. ");
INSERT INTO rub_vpl VALUES ("PS81_16","020_81_16","PSA","81","16","16","Bei̱tu̱ nyaaku̱ku̱di̱i̱si̱i̱rye nganu gikukira b̯urungi, nimwicuta b̯uhooki kuruga mu lubbaali.” ");
INSERT INTO rub_vpl VALUES ("PS82_1","020_82_1","PSA","82","1","1","Zabbu̱li̱ gyʼAsafi̱. Ruhanga eicaara mu lukuratu lwa mwiguru hakati̱ wa baruhanga kucwa misangu, ");
INSERT INTO rub_vpl VALUES ("PS82_2","020_82_2","PSA","82","2","2","akukoba yati, “Mu̱li̱doosya di̱i̱ nab̯utacwanga misangu mya b̯winganiza, kandi nimukalekera hahwo kusagika babiibi? ");
INSERT INTO rub_vpl VALUES ("PS82_3","020_82_3","PSA","82","3","3","Banaku na nfu̱u̱zi̱ mubacwere mu mananu, mu̱bbenge na b̯winganiza hali baseege na ha batali na akubajunira. ");
INSERT INTO rub_vpl VALUES ("PS82_4","020_82_4","PSA","82","4","4","Mujune baseege na bali mu b̯wetaagu, mubacungure mu mikono mya babiibi.” ");
INSERT INTO rub_vpl VALUES ("PS82_5","020_82_5","PSA","82","5","5","Bei̱tu̱ baba bahi̱gani̱zi̱ tibali na magezi̱, bali na b̯udoma b̯unene, bakugyendera mu nti̱ti̱, mi̱si̱nge myensei̱ mya nsi mikutengeeta. ");
INSERT INTO rub_vpl VALUES ("PS82_6","020_82_6","PSA","82","6","6","Nkukoba yati, “Muli baruhanga, nywensei̱ muli baana ba yogwo Waahakyendi̱ Hoi̱. ");
INSERT INTO rub_vpl VALUES ("PS82_7","020_82_7","PSA","82","7","7","Nka bantu mu̱kwi̱za ku̱kwa, mumalikeho nka mu̱lemi̱ yensei̱ kwa aruga ha ntebe.” ");
INSERT INTO rub_vpl VALUES ("PS82_8","020_82_8","PSA","82","8","8","Ai̱ Ruhanga, Byoka, ocwere nsi musangu, hab̯wakubba mahanga gensei̱ gali gaamu! ");
INSERT INTO rub_vpl VALUES ("PS83_1","020_83_1","PSA","83","1","1","Kyembu. Zabbu̱li̱ gyʼAsafi̱. Ai̱ Ruhanga, oteti̱keera, ai̱ Ruhanga, otei̱ca mutima, otagira cei̱! ");
INSERT INTO rub_vpl VALUES ("PS83_2","020_83_2","PSA","83","2","2","Wona banyanzigwa baamu nka ku̱baku̱gu̱gu̱mu̱ka, baanyakukunoba nka ku̱baku̱jemeeri̱. ");
INSERT INTO rub_vpl VALUES ("PS83_3","020_83_3","PSA","83","3","3","Bali mu kudyamwo bantu baamu rukwe, aleke basi̱ngu̱re bab̯wo boolinda. ");
INSERT INTO rub_vpl VALUES ("PS83_4","020_83_4","PSA","83","4","4","Bakoba yati, “Mwi̱ze tu̱hwerekereerye ki̱mwei̱ ihanga lyab̯u, ibara lyʼI̱saleeri̱ li̱syerekeere ki̱mwei̱!” ");
INSERT INTO rub_vpl VALUES ("PS83_5","020_83_5","PSA","83","5","5","Kwokwo nibeekoba batali na kwecwamwo, bakukora rukwe ku̱ku̱lwani̱sya, ");
INSERT INTO rub_vpl VALUES ("PS83_6","020_83_6","PSA","83","6","6","bantu bʼEdomu̱, bʼI̱si̱mai̱ri̱, ba Mowaabbu nʼAbahagali̱, ");
INSERT INTO rub_vpl VALUES ("PS83_7","020_83_7","PSA","83","7","7","ba Gebbaali̱, bʼAmoni̱, bʼAmereki̱ ba Fi̱ri̱si̱ti̱ na banyansi ba mu Ti̱i̱ro, ");
INSERT INTO rub_vpl VALUES ("PS83_8","020_83_8","PSA","83","8","8","nʼAsi̱i̱ri̱ya gi̱beteerani̱zeho, kwongera maani baana ba Looti̱. ");
INSERT INTO rub_vpl VALUES ("PS83_9","020_83_9","PSA","83","9","9","Bafubire nka ku̱wakoori̱ Bami̱dyani̱, nka ku̱waakoori̱ Si̱sera na Yabbi̱ni̱ ha mugira gwa Ki̱soni̱, ");
INSERT INTO rub_vpl VALUES ("PS83_10","020_83_10","PSA","83","10","10","baabahwerekereerye, mitumbi myab̯u myagwa hansi nka b̯use. ");
INSERT INTO rub_vpl VALUES ("PS83_11","020_83_11","PSA","83","11","11","Balemi̱ baab̯u bakwe nka Olebbu̱ na Zeebbu̱, na bayolo baab̯u bensei̱ nka Zebba na Zaru̱mu̱na, ");
INSERT INTO rub_vpl VALUES ("PS83_12","020_83_12","PSA","83","12","12","baanyakukoba yati, “Leka twetwalire twankei itungu, kuruga mu mali̱i̱si̱i̱ryo ga Ruhanga.” ");
INSERT INTO rub_vpl VALUES ("PS83_13","020_83_13","PSA","83","13","13","Ai̱ Ruhanga wange, obasasaani̱e nka cuucu lya kadandi, nka bisusunga bikuhuhuulwa mpehu. ");
INSERT INTO rub_vpl VALUES ("PS83_14","020_83_14","PSA","83","14","14","Nka mworo ku̱gu̱si̱dya kibira, nka ndimi za mworo ku̱zookya nsahu, ");
INSERT INTO rub_vpl VALUES ("PS83_15","020_83_15","PSA","83","15","15","nawe kwokwo abahuhuule na bbuukuulu gyamu, obati̱i̱ni̱sye na kihehu kyamu! ");
INSERT INTO rub_vpl VALUES ("PS83_16","020_83_16","PSA","83","16","16","Ai̱ Mukama, b̯u̱syo waab̯u ob̯uswaze, kwokwo baatoolye ibara lyamu. ");
INSERT INTO rub_vpl VALUES ("PS83_17","020_83_17","PSA","83","17","17","Kabasware kandi batunture biro byensei̱, leka baborogote na kihemu. ");
INSERT INTO rub_vpl VALUES ("PS83_18","020_83_18","PSA","83","18","18","Leka beege nti, weewe wankei weibara Mukama, oli Waahakyendi̱ Hoi̱, olema nsi gyenseenya. ");
INSERT INTO rub_vpl VALUES ("PS84_1","020_84_1","PSA","84","1","1","Hali Mu̱handu̱ wa Bahi̱i̱mi̱. Zabbu̱li̱ gya baana ba Koora. Ai̱ Mukama wa mahe, nnyu̱mba gyamu kagi̱semeru̱! ");
INSERT INTO rub_vpl VALUES ("PS84_2","020_84_2","PSA","84","2","2","Mwozo gwange gwegomba kandi guruhiira zi̱gati̱ gya Mukama, mutima gwange na mubiri gwange bisanyuka ni̱bi̱hi̱i̱mi̱ra Ruhanga mwomi. ");
INSERT INTO rub_vpl VALUES ("PS84_3","020_84_3","PSA","84","3","3","Ai̱ Mukama wa mahe, nab̯ukyakabba nti, mbaki gyetooleerya nnyu̱mba, na nsyo nigyebi̱mbi̱ra kizonza ha kyoto kyamu cali gilindira b̯wana, Mukama kandi Ruhanga wange. ");
INSERT INTO rub_vpl VALUES ("PS84_4","020_84_4","PSA","84","4","4","Ba mu̱gi̱sa bab̯wo beicala mu nnyu̱mba gyamu, b̯uli kasu̱mi̱ ni̱bahi̱i̱ma byakukuhaariiza! ");
INSERT INTO rub_vpl VALUES ("PS84_5","020_84_5","PSA","84","5","5","Bali na mu̱gi̱sa bali na maani garuga muliwe, ba mitima myab̯u mili na bihika kugyenda ha Lusahu Sayu̱u̱ni̱. ");
INSERT INTO rub_vpl VALUES ("PS84_6","020_84_6","PSA","84","6","6","B̯ubabba mu kihanga kya Bbaka. Baakifoora kiikaru kya misu, ndagali̱ gya mukyanda gi̱ki̱zu̱u̱lya na mwizulo. ");
INSERT INTO rub_vpl VALUES ("PS84_7","020_84_7","PSA","84","7","7","B̯ubabba nibakugyenda beeyongera maani, baliwona Ruhanga wa baruhanga ku̱kwo mu Sayu̱u̱ni̱. ");
INSERT INTO rub_vpl VALUES ("PS84_8","020_84_8","PSA","84","8","8","Ai̱ Mukama Ruhanga wa mahe, weegwa kusaba kwange, Ai̱ Ruhanga wa Yakobbo, ontegere mapokopo! ");
INSERT INTO rub_vpl VALUES ("PS84_9","020_84_9","PSA","84","9","9","Ai̱ Ruhanga ha mbabazi̱ mukama, ngab̯u gyetu̱, woolokya mbabazi̱ hali yogwo gi̱i̱wakomi̱ri̱mwo! ");
INSERT INTO rub_vpl VALUES ("PS84_10","020_84_10","PSA","84","10","10","Hab̯wakubba kiro ki̱mwei̱ mu nnyu̱mba gyamu, kikukira b̯urungi biro ru̱ku̱mi̱ mu biikaru bindi. Hakiri mba mu̱li̱ndi̱ wa mulyangu gwa nnyu̱mba, gya Ruhanga wange kukira kwicala mu maka ga babiibi. ");
INSERT INTO rub_vpl VALUES ("PS84_11","020_84_11","PSA","84","11","11","Kubba Mukama Ruhanga abba lyoba kandi ngab̯u, atuha mu̱gi̱sa na ki̱ti̱i̱ni̱sa, birungi byensei̱ tabi̱i̱ma bab̯wo baterekereru̱. ");
INSERT INTO rub_vpl VALUES ("PS84_12","020_84_12","PSA","84","12","12","Ai̱ Mukama wa mahe, wa mu̱gi̱sa yogwo akwesiga! ");
INSERT INTO rub_vpl VALUES ("PS85_1","020_85_1","PSA","85","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱. Zabbu̱li̱ gya Baana ba Koora. Ai̱ Mukama, oicala na mbabazi̱ na nsi gyamu, Bei̱saleeri̱ waabaahweseerye gwakandi. ");
INSERT INTO rub_vpl VALUES ("PS85_2","020_85_2","PSA","85","2","2","Waaganyi̱i̱ri̱ b̯ubiibi b̯wa bantu baamu, waabatoolaho bibii byab̯u byensei̱. ");
INSERT INTO rub_vpl VALUES ("PS85_3","020_85_3","PSA","85","3","3","Otakabakwatirwe ki̱ni̱ga, otakababihiriirwe. ");
INSERT INTO rub_vpl VALUES ("PS85_4","020_85_4","PSA","85","4","4","Ai̱ Ruhanga wakujunwa kwetu̱, twi̱ryemwo b̯uhyaka, otatubihirirwa! ");
INSERT INTO rub_vpl VALUES ("PS85_5","020_85_5","PSA","85","5","5","Olitukwatirwa ki̱ni̱ga biro byensei̱? B̯usungu b̯wamu b̯ulicalaho biro na biro? ");
INSERT INTO rub_vpl VALUES ("PS85_6","020_85_6","PSA","85","6","6","Toli̱tu̱byokya gwa kandi, kwokwo bantu baamu bakusemereerwemwo? ");
INSERT INTO rub_vpl VALUES ("PS85_7","020_85_7","PSA","85","7","7","Ai̱ Mukama, twolokye ngonzi zaamu zinene, otuhe kujunwa kwamu. ");
INSERT INTO rub_vpl VALUES ("PS85_8","020_85_8","PSA","85","8","8","Kanyetegeerye Mukama Ruhanga kiyakoba, hab̯wakubba akwi̱za kubaliza bantu baamwe bya b̯u̱si̱nge, aleke batei̱ri̱ra kukora bya b̯udoma. ");
INSERT INTO rub_vpl VALUES ("PS85_9","020_85_9","PSA","85","9","9","Mananu kwo kujunwa kwamwe kuli heehi̱ na bab̯wo bamutamwo ki̱ti̱i̱ni̱sa, kandi ki̱ti̱i̱ni̱sa kyeicalanga mu nsi gyetu̱. ");
INSERT INTO rub_vpl VALUES ("PS85_10","020_85_10","PSA","85","10","10","Ngonzi zinene na b̯wesigwa bi̱li̱romba, mananu na b̯u̱si̱nge biliramukyangana ");
INSERT INTO rub_vpl VALUES ("PS85_11","020_85_11","PSA","85","11","11","B̯wesigwa b̯ulirugira hansi, kandi mananu garuge mwiguru. ");
INSERT INTO rub_vpl VALUES ("PS85_12","020_85_12","PSA","85","12","12","Mukama alitugabaira birungi, kandi nsi gyetu̱ gilibba na makesa ganene. ");
INSERT INTO rub_vpl VALUES ("PS85_13","020_85_13","PSA","85","13","13","B̯winganiza b̯uligyenda mu mei̱so gaMukama b̯umuteekaniririze muhanda. ");
INSERT INTO rub_vpl VALUES ("PS86_1","020_86_1","PSA","86","1","1","Kusaba kwa Dau̱di̱. Ai̱ Mukama, ntegera mapokopo onzi̱remwo, hab̯wakubba ndi munaku kandi museege. ");
INSERT INTO rub_vpl VALUES ("PS86_2","020_86_2","PSA","86","2","2","Olindenge b̯womi b̯wange, hab̯wakubba nyendya Ruhanga, juna muheereza waamu akwesiga. ");
INSERT INTO rub_vpl VALUES ("PS86_3","020_86_3","PSA","86","3","3","Ai̱ Mukama ngiira mbabazi̱, hab̯wakubba nsiiba ninkuliriira. ");
INSERT INTO rub_vpl VALUES ("PS86_4","020_86_4","PSA","86","4","4","Ai̱ Mukama i̱zu̱u̱lya mwozo gwa muheereza waamu na kusemererwa, hab̯wakubba weewe ginguha. ");
INSERT INTO rub_vpl VALUES ("PS86_5","020_86_5","PSA","86","5","5","Ai̱ Mukama weewe murungi kandi mu̱ganyi̱ri̱, ogiira ngonzi zinene, bab̯wo baatula ibara lyamu. ");
INSERT INTO rub_vpl VALUES ("PS86_6","020_86_6","PSA","86","6","6","Ai̱ Mukama, ntegera mapokopo weegwa kusaba kwange, weegwanga kizabiro kya kwesengereerya kwange. ");
INSERT INTO rub_vpl VALUES ("PS86_7","020_86_7","PSA","86","7","7","B̯umba mu b̯ujune nkunga weewe, hab̯wakubba onzi̱ramwo. ");
INSERT INTO rub_vpl VALUES ("PS86_8","020_86_8","PSA","86","8","8","Ai̱ Mukama, mu baruhanga tihaloho noomwei̱ akukwisana, rundi munyakukora bintu nka bi̱waakoori̱. ");
INSERT INTO rub_vpl VALUES ("PS86_9","020_86_9","PSA","86","9","9","Ai̱ Mukama, mahanga gensei̱ gaawahangi̱ri̱, gakwi̱za ku̱ku̱ramya, kandi gaalihariiza ibara lyamu. ");
INSERT INTO rub_vpl VALUES ("PS86_10","020_86_10","PSA","86","10","10","Hab̯wakubba oli waki̱ti̱i̱ni̱sa kandi okora bintu byamahanu, weewe musa oli Ruhanga. ");
INSERT INTO rub_vpl VALUES ("PS86_11","020_86_11","PSA","86","11","11","Ai̱ Mukama, nzegesya muhanda gwamu, kwokwo ndibatire mu mananu gaamu, nzegesya kukuhereza na mutima gwange gwensei̱. ");
INSERT INTO rub_vpl VALUES ("PS86_12","020_86_12","PSA","86","12","12","Ai̱ Mukama Ruhanga wange, nku̱ku̱si̱i̱ma na mutima gwange gwensei̱, kandi nyahaariizanga ibara lyamu biro byensei̱. ");
INSERT INTO rub_vpl VALUES ("PS86_13","020_86_13","PSA","86","13","13","Ngonzi zaamu ka zinene hali gya, wancu̱ngu̱u̱ri̱ wantoola kuzumu. ");
INSERT INTO rub_vpl VALUES ("PS86_14","020_86_14","PSA","86","14","14","Ai̱ Ruhanga, bantu baamyepanku bambyokereeri̱, kitebe kya badulu batemu baku̱toolya ku̱nzi̱ta kandi we tibakuloho. ");
INSERT INTO rub_vpl VALUES ("PS86_15","020_86_15","PSA","86","15","15","Ai̱ Mukama, bei̱tu̱ we, weewe Ruhanga aganyira kandi wa mbabazi̱ otabihiriirwa b̯wangu, kandi wa ngonzi zinene kandi mwesigwa. ");
INSERT INTO rub_vpl VALUES ("PS86_16","020_86_16","PSA","86","16","16","Mpindukira kandi ongiire mbabazi̱, muheereza waamu omuhe maani gaamu kandi ojune mwana wa muzaana waamu. ");
INSERT INTO rub_vpl VALUES ("PS86_17","020_86_17","PSA","86","17","17","Onzolokye kawoneru ka mbabazi̱ zaamu, bab̯wo banyakunnoba, bawone kandi basware, hab̯wakubba weewe Mukama, kandi wanju̱ni̱ri̱ waampu̱mu̱u̱lya. ");
INSERT INTO rub_vpl VALUES ("PS87_1","020_87_1","PSA","87","1","1","Zabbu̱li̱ gya baana ba Koora. Yaabi̱mbi̱ri̱ rub̯uga lwamwe ha lusahu lu̱syanu̱, ");
INSERT INTO rub_vpl VALUES ("PS87_2","020_87_2","PSA","87","2","2","Mukama yendya irembu lya Sayu̱u̱ni̱, kukira mbuga zindi zensei̱ za mwʼI̱saleeri̱. ");
INSERT INTO rub_vpl VALUES ("PS87_3","020_87_3","PSA","87","3","3","Ai̱ rub̯uga lwa Ruhanga, bintu bya ki̱ti̱i̱ni̱sa bikukubazwaho. ");
INSERT INTO rub_vpl VALUES ("PS87_4","020_87_4","PSA","87","4","4","“Mu mahanga ganzegi̱ri̱ hooho hali, Mi̱si̱ri̱, Bbabbu̱looni̱, Fi̱ri̱si̱ti̱, Ti̱i̱ro nʼI̱syopi̱ya, bantu bensei̱ ba mu mahanga gagwo nkwi̱za kubabala nka banyansi ba mu Yeru̱salemu̱.” ");
INSERT INTO rub_vpl VALUES ("PS87_5","020_87_5","PSA","87","5","5","Hali Sayu̱u̱ni̱ bantu balikoba nti, “Yogo na yodi̱ hooho baabyali̱i̱rwe,” hab̯wakubba yogwo yankei eicala Waahakyendi̱ Hoi̱ yooyo ali̱lu̱tati̱i̱rya. ");
INSERT INTO rub_vpl VALUES ("PS87_6","020_87_6","PSA","87","6","6","Mukama alihandiika mabara ga bantu baamwe bensei̱, ni̱yolokya nka kubali banyansi ba mu Yeru̱salemu̱. ");
INSERT INTO rub_vpl VALUES ("PS87_7","020_87_7","PSA","87","7","7","Bahi̱i̱mi̱ na babi̱nyi̱ bensei̱ babaza ki̱mwei̱ nibakoba yati, “Mu Sayu̱u̱ni̱ hooho hali ndugiiro gya mi̱gi̱sa myetu̱ myensei̱.” ");
INSERT INTO rub_vpl VALUES ("PS88_1","020_88_1","PSA","88","1","1","Kyembu. Zabbu̱li̱ gya baana ba Koora. Hali mu̱handu̱ wa bahi̱i̱mi̱. Bikukwata ha Mahalasa Lyanota. Masikili gya Hemani Mu̱hezi̱ra. Ai̱ Mukama Ruhanga anjuna i̱jolo na mwinsi, nkunga weewe. ");
INSERT INTO rub_vpl VALUES ("PS88_2","020_88_2","PSA","88","2","2","Otegere mapokopo kizabiro kyange, leka kusaba kwange kudwe cali oli. ");
INSERT INTO rub_vpl VALUES ("PS88_3","020_88_3","PSA","88","3","3","Hab̯wakubba mwozo gwange gwi̱zwi̱ri̱ b̯ujune, b̯womi b̯wange b̯uli heehi̱ na kuzumu. ");
INSERT INTO rub_vpl VALUES ("PS88_4","020_88_4","PSA","88","4","4","Nkubalirwa mu bali heehi̱ ku̱kwa, ndi muntu atali na maani. ");
INSERT INTO rub_vpl VALUES ("PS88_5","020_88_5","PSA","88","5","5","Ndi nka muntu ati̱gi̱i̱rwe mu baku̱u̱, nkwisana nka mutumbi gu̱leeri̱ mu kituuru, ndi nka bab̯wo botakwi̱zu̱ka, kubba tokyakabajuna. ");
INSERT INTO rub_vpl VALUES ("PS88_6","020_88_6","PSA","88","6","6","Onteeri̱ kuzumu mu ki̱i̱na kilei, mu biikaru bilei bi̱zwi̱ri̱mwo nti̱ti̱. ");
INSERT INTO rub_vpl VALUES ("PS88_7","020_88_7","PSA","88","7","7","Ki̱ni̱ga kyamu ki̱nki̱i̱ri̱, Ombu̱mbi̱ri̱ na bijanga byamu byensei̱. ");
INSERT INTO rub_vpl VALUES ("PS88_8","020_88_8","PSA","88","8","8","Oheeri̱ banywani bange kunyehala, onzi̱ri̱i̱rye kinugwa hali bo. Ndi mu nkomo tinkusobora kucwa, ");
INSERT INTO rub_vpl VALUES ("PS88_9","020_88_9","PSA","88","9","9","Mei̱so gange galimwo nti̱ti̱, kubba ndi na b̯ujune. Ai̱ Mukama, nkukunga b̯uli kiro, nku̱byokeerya mikono. ");
INSERT INTO rub_vpl VALUES ("PS88_10","020_88_10","PSA","88","10","10","Baku̱u̱ obakoorambe byamahanu? Balisobora kubyoka kukuhaariiza? ");
INSERT INTO rub_vpl VALUES ("PS88_11","020_88_11","PSA","88","11","11","Basobora kubaza ha ngonzi zaamu zinene, nibali mu nyanga, rundi b̯wesigwa b̯wamu bab̯u̱tebeeze kuzumu? ");
INSERT INTO rub_vpl VALUES ("PS88_12","020_88_12","PSA","88","12","12","Byamahanu byamu babyegambe mu nti̱ti̱, rundi kujunwa kwamu bakwetegerezanga mu nsi ginyakweb̯wa? ");
INSERT INTO rub_vpl VALUES ("PS88_13","020_88_13","PSA","88","13","13","Bei̱tu̱ gya ai̱ Mukama, nkukuliriira, nkusaba b̯uli mwakya karei. ");
INSERT INTO rub_vpl VALUES ("PS88_14","020_88_14","PSA","88","14","14","Ai̱ Mukama hab̯waki onyetoori̱ho? Hab̯waki ombi̱si̱ra mei̱so gaamu? ");
INSERT INTO rub_vpl VALUES ("PS88_15","020_88_15","PSA","88","15","15","Kuruga mu b̯uto b̯wange ncala nimbonawona, kandi ni̱nyesu̱mi̱i̱ra ku̱kwa, nimbonawona na bifubiro byamu tindi na kikunjuna. ");
INSERT INTO rub_vpl VALUES ("PS88_16","020_88_16","PSA","88","16","16","Ki̱ni̱ga kyamu kyamali̱ki̱i̱ri̱ho, bifubiro byamu byampwerekereerye. ");
INSERT INTO rub_vpl VALUES ("PS88_17","020_88_17","PSA","88","17","17","Byanyelogoleerye nka mwizulo mwinsi lyensei̱, byensei̱ byanyeebbohereeri̱ ki̱mwei̱. ");
INSERT INTO rub_vpl VALUES ("PS88_18","020_88_18","PSA","88","18","18","Waaleteeri̱ banywani bange na bataahi̱ bange kunyesalaho, hataati̱ mu̱taahi̱ wange gi̱nsi̱gali̱si̱i̱rye yooyo nti̱ti̱. ");
INSERT INTO rub_vpl VALUES ("PS89_1","020_89_1","PSA","89","1","1","Masikili gyʼEsani̱ Mu̱hezi̱ra. Ai̱ Mukama, nkwi̱za ku̱hi̱i̱ma ha ngonzi zaamu zinene biro byensei̱. Nyarangiiranga b̯wesigwa b̯wamu hali mi̱hi̱hi̱ myensei̱. ");
INSERT INTO rub_vpl VALUES ("PS89_2","020_89_2","PSA","89","2","2","Hab̯wakubba ngonzi zaamu zinene, ziicalaho biro byensei̱, b̯wesigwa b̯wamu b̯uloho nkeiguru. ");
INSERT INTO rub_vpl VALUES ("PS89_3","020_89_3","PSA","89","3","3","Weewe waakobi̱ri̱ yati, “Nyaakoori̱ ndagaanu na yogwo gi̱nyaakomi̱ri̱, nyarahi̱ri̱i̱ri̱ Dau̱di̱ muheereza wange yati, ");
INSERT INTO rub_vpl VALUES ("PS89_4","020_89_4","PSA","89","4","4","‘Beizukulu baamu ndibaafoora bakama biro byensei̱, kandi ndi̱bi̱mba b̯ukama b̯wamu biro byensei̱.’ ” ");
INSERT INTO rub_vpl VALUES ("PS89_5","020_89_5","PSA","89","5","5","Ai̱ Mukama, iguru kalihaariiza byamahanu byamu na bamalayika baamu bensei̱ kabahaariiza b̯wesigwa b̯wamu. ");
INSERT INTO rub_vpl VALUES ("PS89_6","020_89_6","PSA","89","6","6","B̯u̱b̯wo, mwiguru naani gibakusobora ku̱lengesani̱sya na Mukama? Naani mu bihangwa bya mwiguru akwisana Mukama? ");
INSERT INTO rub_vpl VALUES ("PS89_7","020_89_7","PSA","89","7","7","Ruhanga ati̱i̱nwa mu lukuratu lwa bamalayika, waki̱ti̱i̱ni̱sa kandi muzira kukira bensei̱ bali nayo? ");
INSERT INTO rub_vpl VALUES ("PS89_8","020_89_8","PSA","89","8","8","Ai̱ Mukama, Ruhanga wa mahe, naani ali na b̯u̱sobozi̱ b̯ukwijanajana nka b̯wamu? Ai̱ Mukama b̯wesigwa b̯wamu b̯uli nawe. ");
INSERT INTO rub_vpl VALUES ("PS89_9","020_89_9","PSA","89","9","9","Weewe olema kuhuura kweitaka, bijanga b̯ubyesenga, weewe obi̱tekaani̱a. ");
INSERT INTO rub_vpl VALUES ("PS89_10","020_89_10","PSA","89","10","10","Weewe wasonyotoori̱ Rahabbu, nka mutumbi. Wasasaani̱a banyanzigwa baamu na mukono gwamu gwamaani. ");
INSERT INTO rub_vpl VALUES ("PS89_11","020_89_11","PSA","89","11","11","Iguru na nsi byamu, nsi na byensei̱ bigicalamwo, weewe waabi̱hangi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS89_12","020_89_12","PSA","89","12","12","Waahanga matemba na masi̱ri̱mu̱ka, lusahu Tabbora na Hamoni̱ zihaariiza ibara lyamu nakusemererwa. ");
INSERT INTO rub_vpl VALUES ("PS89_13","020_89_13","PSA","89","13","13","Oli na mukono gwamaani, maani gaamu ganene hoi̱. ");
INSERT INTO rub_vpl VALUES ("PS89_14","020_89_14","PSA","89","14","14","Mananu na b̯winganiza byobyo mu̱si̱nge gwa kitebe kyamu kya b̯ukama, ngonzi zinene na b̯wesigwa byobyo bikwehembera. ");
INSERT INTO rub_vpl VALUES ("PS89_15","020_89_15","PSA","89","15","15","Bali na mu̱gi̱sa bantu baaku̱ramya ni̱bahi̱i̱ma byembu, Ai̱ Mukama, bab̯wo bahondera kyererezi̱ kya mei̱so gaamu, ");
INSERT INTO rub_vpl VALUES ("PS89_16","020_89_16","PSA","89","16","16","basemererwa mwibara lyamu b̯wi̱re b̯wensei̱, kandi bahaariiza b̯urungi b̯wamu. ");
INSERT INTO rub_vpl VALUES ("PS89_17","020_89_17","PSA","89","17","17","Hab̯wakubba weewe ki̱ti̱i̱ni̱sa kya maani gaab̯u, mu ngonzi zaamu otwi̱rya basi̱ngu̱zi̱. ");
INSERT INTO rub_vpl VALUES ("PS89_18","020_89_18","PSA","89","18","18","Hab̯wakubba ngab̯u gyetu̱ giicala Mukama yankei, Ruhanga Ati̱i̱nwa wʼI̱saleeri̱, yaatu̱heeri̱ mukama weetu̱. ");
INSERT INTO rub_vpl VALUES ("PS89_19","020_89_19","PSA","89","19","19","Mu biro bya kadei, waabazengi̱ mu kuwonekerwa hali beesigwa baamu, noobaweera yati, “Ndeeti̱ri̱ kujuna hali yogwo wa maani, kitebe kya b̯ukama, nki̱heeri̱ yogwo gi̱nyaakomi̱ri̱ mu bantu. ");
INSERT INTO rub_vpl VALUES ("PS89_20","020_89_20","PSA","89","20","20","Nsoroori̱mwo Dau̱di̱ muheereza wange, nyaamubbwomaho maku̱ta gange gasyanu̱. ");
INSERT INTO rub_vpl VALUES ("PS89_21","020_89_21","PSA","89","21","21","Kwokwo mukono gwange gwicalenge na yo b̯u̱sobozi̱ b̯wange wamufooranga wa maani. ");
INSERT INTO rub_vpl VALUES ("PS89_22","020_89_22","PSA","89","22","22","Tihaloho munyanzigwa alimudirisana babiibi ti̱bali̱mu̱si̱ngu̱ra. ");
INSERT INTO rub_vpl VALUES ("PS89_23","020_89_23","PSA","89","23","23","Ndicwacwana banyanzigwa baamwe mu mei̱so gaamwe kandi ndiguma hansi bab̯wo bamunoba. ");
INSERT INTO rub_vpl VALUES ("PS89_24","020_89_24","PSA","89","24","24","B̯wesigwa na ngonzi zange zinene byeicaalanga hali yo, b̯uli kasu̱mi̱ nyamufooranga mu̱si̱ngu̱zi̱. ");
INSERT INTO rub_vpl VALUES ("PS89_25","020_89_25","PSA","89","25","25","Ndi̱gali̱hya b̯ukama b̯wamwe, kurugira ki̱mwei̱ heitaka likooto kudwa ha mugira Efu̱raati̱. ");
INSERT INTO rub_vpl VALUES ("PS89_26","020_89_26","PSA","89","26","26","Alindiriira naakoba yati, ‘Weewe Bbaabba, Ruhanga wange, lubbaali lwa kujunwa kwange.’ ");
INSERT INTO rub_vpl VALUES ("PS89_27","020_89_27","PSA","89","27","27","Ndimwi̱rya mu̱zegei̱zo wange wa b̯udulu ndimwi̱rya mukama akukira ki̱mwei̱ bakama bensei̱ ba hansi. ");
INSERT INTO rub_vpl VALUES ("PS89_28","020_89_28","PSA","89","28","28","Nyeicalanga na ngonzi zaamu zinene biro byensei̱, kandi kuragana kwange kutalimalika. ");
INSERT INTO rub_vpl VALUES ("PS89_29","020_89_29","PSA","89","29","29","Lubyalu lwamwe ndilwicaalyaho biro na biro, mwizukulu waamwe yeicalanga naali mukama. ");
INSERT INTO rub_vpl VALUES ("PS89_30","020_89_30","PSA","89","30","30","Bei̱tu̱ beizukulu baamwe b̯ubalijeemera biragiro byange, nibakalemwa kuhondera mateeka gange, ");
INSERT INTO rub_vpl VALUES ("PS89_31","020_89_31","PSA","89","31","31","b̯ubaligumirisana bya kwegesya kwange, batakwerinda biragiro byange, ");
INSERT INTO rub_vpl VALUES ("PS89_32","020_89_32","PSA","89","32","32","b̯u̱b̯wo, mwomwo ndibafubira na lu̱gei̱ hab̯wa bibii byab̯u, kandi ndibakuuta kijunju hab̯wa b̯ubiibi b̯wab̯u. ");
INSERT INTO rub_vpl VALUES ("PS89_33","020_89_33","PSA","89","33","33","Bei̱tu̱ ngonzi zange zinene hali Dau̱di̱ tizilimalika, habbe kumutoolaho muragu gu̱nyamu̱ragani̱si̱i̱rye. ");
INSERT INTO rub_vpl VALUES ("PS89_34","020_89_34","PSA","89","34","34","Tindibinya ndagaanu gi̱nyakoori̱ hamwei̱ nayo, nab̯ukyakabba kuhindula kigambu ki̱nyakobi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS89_35","020_89_35","PSA","89","35","35","Ndahi̱i̱ri̱ murundi gu̱mwei̱ ibara lyange li̱syanu̱ kuruga hataati̱ na biro byensei̱, Dau̱di̱ tindimuweera b̯u̱gobya. ");
INSERT INTO rub_vpl VALUES ("PS89_36","020_89_36","PSA","89","36","36","Beizukulu baamwe beicalangaho biro byensei̱, nka lyoba litamalikaho b̯ukama b̯wamwe kwokwo b̯ulicalaho. ");
INSERT INTO rub_vpl VALUES ("PS89_37","020_89_37","PSA","89","37","37","Nka mweri̱ ku̱gu̱kwi̱za kwicalaho biro byensei̱, niguli b̯u̱kei̱so b̯wa mananu mwiguru.” ");
INSERT INTO rub_vpl VALUES ("PS89_38","020_89_38","PSA","89","38","38","Bei̱tu̱ hataati̱, obi̱hi̱ri̱i̱rwe mutongoole waamu gi̱weekomeeri̱, omu̱ru̱gi̱ri̱ho kandi omu̱swi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS89_39","020_89_39","PSA","89","39","39","Ndagaanu gyamu na muheereza waamu waagi̱bi̱nyi̱ri̱, kondo gyamwe waagi̱gu̱mi̱ri̱ mu cuucu. ");
INSERT INTO rub_vpl VALUES ("PS89_40","020_89_40","PSA","89","40","40","Obi̱nyi̱ri̱ bi̱si̱i̱ka byamwe byensei̱, ngo zaamwe ozi̱foori̱ri̱ makandi. ");
INSERT INTO rub_vpl VALUES ("PS89_41","020_89_41","PSA","89","41","41","Bensei̱ bakurabaho bali mu kumunyaga, afooki̱ri̱ kintu kya kugaywa bataahi̱. ");
INSERT INTO rub_vpl VALUES ("PS89_42","020_89_42","PSA","89","42","42","Waaheeri̱ banyanzigwa baamwe b̯u̱si̱ngu̱zi̱, bensei̱ waabaha kusemererwe. ");
INSERT INTO rub_vpl VALUES ("PS89_43","020_89_43","PSA","89","43","43","Wei̱ti̱ri̱ b̯wogi wa mpirima gyamwe, otakamujune mu b̯ulemu. ");
INSERT INTO rub_vpl VALUES ("PS89_44","020_89_44","PSA","89","44","44","Mubbeere gwa b̯ukama waagu̱mu̱tooori̱ mu ngalu, waaguma hansi kitebe kya b̯ukama b̯wamwe. ");
INSERT INTO rub_vpl VALUES ("PS89_45","020_89_45","PSA","89","45","45","Waakeheerye biro bya b̯usigazi b̯wamwe, waamuletera muswaru. ");
INSERT INTO rub_vpl VALUES ("PS89_46","020_89_46","PSA","89","46","46","Ai̱ Mukama, oli̱doosya hanya? Oliicala weebi̱si̱ri̱ biro byensei̱? Ki̱ni̱ga kyamu ki̱li̱dooosya hanya kwicala nikyaka nka mworo? ");
INSERT INTO rub_vpl VALUES ("PS89_47","020_89_47","PSA","89","47","47","Ai̱ Mukama, i̱zu̱ka b̯womi wange kub̯uli b̯u̱dooli̱, hab̯waki bantu bawaahangi̱ri̱ batali na mugasu! ");
INSERT INTO rub_vpl VALUES ("PS89_48","020_89_48","PSA","89","48","48","Muntu kyani yogwo akusobora kwomeera akalemwa ku̱kwa? Naani akusobora kwejuna maani ga kuzumu? ");
INSERT INTO rub_vpl VALUES ("PS89_49","020_89_49","PSA","89","49","49","Mukama ngonzi zaamu zinene za kadei, mu b̯wesigwa b̯wamu zi̱i̱warahi̱ri̱i̱ri̱ Dau̱di̱ zili hanya? ");
INSERT INTO rub_vpl VALUES ("PS89_50","020_89_50","PSA","89","50","50","Ai̱ Mukama i̱zu̱ka gya muheereza waamu kundimwo ku̱lu̱mwa, kandi nka kungumisiriza bi̱lu̱mo bya mahanga gensei̱. ");
INSERT INTO rub_vpl VALUES ("PS89_51","020_89_51","PSA","89","51","51","Ai̱ Mukama, banyanzigwa baamu bi̱baku̱lu̱ma, bi̱baku̱jooga mutongoole waamu gi̱i̱wakomi̱ri̱mwo hensei̱ cali akugyenda. ");
INSERT INTO rub_vpl VALUES ("PS89_52","020_89_52","PSA","89","52","52","Mukama ahaariizwenge biro byensei̱! ");
INSERT INTO rub_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","Kusaba kwa Mu̱sa, mudulu wa Ruhanga. Ai̱ Mukama, oli b̯wicalu b̯wetu̱ biro na biro. ");
INSERT INTO rub_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","Otakahangi̱ri̱ nsahu, kandi otakahangi̱ri̱ nsi na bilimwo kuruga kadei na kadei obba Ruhanga. ");
INSERT INTO rub_vpl VALUES ("PS90_3","020_90_3","PSA","90","3","3","Oragira bantu ni̱bakwa, ni̱bei̱ra icuucu. ");
INSERT INTO rub_vpl VALUES ("PS90_4","020_90_4","PSA","90","4","4","Myaka ru̱ku̱mi̱ mu mei̱so gaamu miisana kiro ki̱mwei̱, mibba nka kiro kyei̱zo kinyakurabaho, rundi nka b̯wi̱re b̯wei̱jolo kuwanguha. ");
INSERT INTO rub_vpl VALUES ("PS90_5","020_90_5","PSA","90","5","5","Obbu̱tya bantu nka mwizulo, tumalikaho b̯wangu kukira na kilooto. Tuli nkeisubi limera mwakya karei, ");
INSERT INTO rub_vpl VALUES ("PS90_6","020_90_6","PSA","90","6","6","mwakya karei lyakya ni̱li̱nyi̱ri̱ra, joojolo lihotoka nilyoma. ");
INSERT INTO rub_vpl VALUES ("PS90_7","020_90_7","PSA","90","7","7","Ki̱ni̱ga kyamu ki̱twi̱ta b̯wi̱ti̱, tu̱saali̱i̱rwe nu hab̯wa b̯usungu b̯wamu. ");
INSERT INTO rub_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","Bibiibi byetu̱ waabiteeri̱ mu mei̱so gaamu, bibiibi byensei̱ bya nsita waabi̱weeni̱. ");
INSERT INTO rub_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","Biro byetu̱ bikeehaho wangu hab̯wa ki̱ni̱ga kyamu, myaka myetu̱ mimalikaho wangu nka kiyayamuko. ");
INSERT INTO rub_vpl VALUES ("PS90_10","020_90_10","PSA","90","10","10","Myaka myetu̱ miicala nsanju, b̯utubba na maani tu̱doosya kinaanei, bei̱tu̱ b̯unene b̯wamyo b̯wicala b̯ujune na kuwonawona, mimalikaho b̯wangu kandi ni̱tu̱syeraho. ");
INSERT INTO rub_vpl VALUES ("PS90_11","020_90_11","PSA","90","11","11","Naani yeegi̱ri̱ maani ga ki̱ni̱ga kyamu? Naani yeegi̱ri̱ b̯u̱ti̱i̱ni̱ wa ki̱ni̱ga kyamu kikusobora kuleeta? ");
INSERT INTO rub_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","Twegesye kubala biro bya b̯womi b̯wetu̱, aleke tubbe na mutima gwa magezi̱. ");
INSERT INTO rub_vpl VALUES ("PS90_13","020_90_13","PSA","90","13","13","Ai̱ Mukama, i̱ra, olitubihiriirwa ku̱doosya di̱i̱? Ganyira baheereza baamu! ");
INSERT INTO rub_vpl VALUES ("PS90_14","020_90_14","PSA","90","14","14","B̯uli mwakya karei twi̱cu̱tyenge ngonzi zaamu zinene, kwokwo twicalenge nitujaguza kandi nitusemererwa biro byetu̱ byensei̱. ");
INSERT INTO rub_vpl VALUES ("PS90_15","020_90_15","PSA","90","15","15","Tu̱he kusemererwa kunene, kukwijanjana na biro bi̱watu̱wonawoneseeryemwo, na myaka minene kwijanajana na mitwamaari mu b̯ujune. ");
INSERT INTO rub_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","Leka milimo myamu myezolokye mu baheereza baamu, na ki̱ti̱i̱ni̱sa kya maani gaamu kizookere mu beizukulu baab̯u. ");
INSERT INTO rub_vpl VALUES ("PS90_17","020_90_17","PSA","90","17","17","Ai̱ Mukama Ruhanga, tu̱he mi̱gi̱sa myamu, otuhe ku̱si̱ngu̱ra mu milimo myetu̱, ee, otuhe ku̱si̱ngu̱ra milimo myetu̱. ");
INSERT INTO rub_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","1","Yogwo yensei̱ eicalira mu nnyu̱mba gya Waahakyendi̱ Hoi̱, alihumulira mu mu̱tu̱ntu̱lu̱ gwa Ruhanga wa b̯u̱sobozi̱. ");
INSERT INTO rub_vpl VALUES ("PS91_2","020_91_2","PSA","91","2","2","Ndiweera Mukama yati, “Oli b̯wi̱ru̱ki̱ro kandi lugo lwange, Ruhanga wange ginyeesiga.” ");
INSERT INTO rub_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","Hab̯wakubba alikujuna mutegu gwensei̱, naakujuna na b̯u̱seeri̱ b̯wa kookoro. ");
INSERT INTO rub_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","Alikubbumba na byoza byamwe, kandi hansi wa bimpaha byamwe hooho halibba b̯wi̱ru̱ki̱ro b̯wamu, mananu gaamwe galikulinda. ");
INSERT INTO rub_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","5","Otali̱ti̱i̱na kabii kei̱za i̱jolo, habbe mbasi zi̱kwecu̱u̱ru̱ngya mwinsi, ");
INSERT INTO rub_vpl VALUES ("PS91_6","020_91_6","PSA","91","6","6","rundi nseeri̱ gibiibi gi̱kei̱zi̱ra mu nti̱ti̱, rundi kuhwerekeera kwa mwihangwe. ");
INSERT INTO rub_vpl VALUES ("PS91_7","020_91_7","PSA","91","7","7","Bantu ru̱ku̱mi̱ basobora ku̱kwera heehi̱ nawe, nku̱mi̱ na nku̱mi̱ ha mukono gwamu gwab̯udyo, bei̱tu̱ kandi we, kabii ti̱kali̱kwesu̱mi̱i̱ra. ");
INSERT INTO rub_vpl VALUES ("PS91_8","020_91_8","PSA","91","8","8","Olyemeera noolingiira na mei̱so gaamu, noowona babiibi nka kubalifubirwa. ");
INSERT INTO rub_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","9","Nka ku̱wafoori̱ri̱ Mukama b̯wi̱ru̱ki̱ro b̯wamu, yogwo Waahakyendi̱ Hoi̱, yooyo b̯wi̱ru̱ki̱ro b̯wamu, ");
INSERT INTO rub_vpl VALUES ("PS91_10","020_91_10","PSA","91","10","10","tihaloho kabii kensei̱ kalikudwereera, b̯ujune tib̯ulikudwereera. ");
INSERT INTO rub_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","Kubba akwi̱za kuragira bamalayika baamwe bakulinde, bakwehemberenge mu mihanda myamu myensei̱. ");
INSERT INTO rub_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","Balikutegera mikono myab̯u bakukwate, aleke magulu gaamu gateekuuta kwi̱hi̱ga. ");
INSERT INTO rub_vpl VALUES ("PS91_13","020_91_13","PSA","91","13","13","Oli̱si̱ngu̱ra ntali na hu̱lu̱hu̱ndu̱, olizigina mwana gwa ntali na mpiri. ");
INSERT INTO rub_vpl VALUES ("PS91_14","020_91_14","PSA","91","14","14","Ruhanga naakoba yati, “Ndimujuna hab̯wakubba anzendyambe, ndimulinda kubba yeegi̱ri̱ ibara lyange. ");
INSERT INTO rub_vpl VALUES ("PS91_15","020_91_15","PSA","91","15","15","Waalinzeta, ndi̱mwi̱ramwo, b̯walibba mu b̯ujune, ndibba nayo, ndimucungura, mutemwo ki̱ti̱i̱ni̱sa. ");
INSERT INTO rub_vpl VALUES ("PS91_16","020_91_16","PSA","91","16","16","Ndimuha kwomeera naasemererwa, mwolokye kujunwa kwange.” ");
INSERT INTO rub_vpl VALUES ("PS92_1","020_92_1","PSA","92","1","1","Zabbu̱li̱. Kyembu kya Sabbaato. Kakirungi ku̱si̱i̱ma Mukama, na kuhaariiza ibara lyamu, we Waahakyendi̱ Hoi̱, ");
INSERT INTO rub_vpl VALUES ("PS92_2","020_92_2","PSA","92","2","2","kakirungi kwatula ngonzi zaamu zinene mwakya karei, na kurangiira b̯wesigwa b̯wamu i̱jolo, ");
INSERT INTO rub_vpl VALUES ("PS92_3","020_92_3","PSA","92","3","3","ni̱tu̱hi̱i̱ma na ndi̱ngi̱di̱ nitukuuta bi̱dongo. ");
INSERT INTO rub_vpl VALUES ("PS92_4","020_92_4","PSA","92","4","4","Ai̱ Mukama, ompa kusemererwa hab̯wa bi̱byo byensei̱ byokoori̱, bindeetera ku̱hi̱i̱ma na masanyu. ");
INSERT INTO rub_vpl VALUES ("PS92_5","020_92_5","PSA","92","5","5","Ai̱ Mukama! Bintu byokora ka byamaani, biteekerezu byamu bi̱nki̱i̱ri̱ kubyetegereza. ");
INSERT INTO rub_vpl VALUES ("PS92_6","020_92_6","PSA","92","6","6","Muntu mu̱pu̱u̱ti̱ tasobora kwega, mudoma tasobora kwetegereza. ");
INSERT INTO rub_vpl VALUES ("PS92_7","020_92_7","PSA","92","7","7","Babiibi nab̯ubalihanda b̯wangu nkeisubi, na nkori̱ za bibii nizikakanya, balihwerekeera. ");
INSERT INTO rub_vpl VALUES ("PS92_8","020_92_8","PSA","92","8","8","Ai̱ Mukama oli Waahakyendi̱ Hoi̱ biro byenseenya. ");
INSERT INTO rub_vpl VALUES ("PS92_9","020_92_9","PSA","92","9","9","Ai̱ Mukama, wona banyanzigwa baamu, wona nka kubalihwerekeera, nkori̱ za bibii zensei̱ ziliswaswanika. ");
INSERT INTO rub_vpl VALUES ("PS92_10","020_92_10","PSA","92","10","10","Bei̱tu̱ gya ompeeri̱ maani nka ga mpeta, wambwomi̱ro maku̱ta ga muhendu. ");
INSERT INTO rub_vpl VALUES ("PS92_11","020_92_11","PSA","92","11","11","Mei̱so gange gaweeni̱ ku̱si̱ngu̱rwa kwa banyanzigwa bange, mapokopo gange geegwa itoko lya kuhwerekeera kwab̯u. ");
INSERT INTO rub_vpl VALUES ("PS92_12","020_92_12","PSA","92","12","12","Barungi balinyirira nka nsansa, kandi balifooka baamaani̱ nka mupoi gwa Lebbanooni̱. ");
INSERT INTO rub_vpl VALUES ("PS92_13","020_92_13","PSA","92","13","13","Babateeri̱ mu nnyu̱mba gya Mukama, balihandira mu zi̱gati̱ za Ruhanga weetu̱. ");
INSERT INTO rub_vpl VALUES ("PS92_14","020_92_14","PSA","92","14","14","Baliteeka byana na mu b̯u̱gu̱lu̱u̱su̱, nibali na rutege kandi basi̱gi̱ku̱, ");
INSERT INTO rub_vpl VALUES ("PS92_15","020_92_15","PSA","92","15","15","kwolokya Mukama nka kwali Murungi, lubbaali lwange yogwo ateicalamwo nsobi̱ kadi gi̱mwei̱. ");
INSERT INTO rub_vpl VALUES ("PS93_1","020_93_1","PSA","93","1","1","Mukama yooyo alema, eicala na ki̱ti̱i̱ni̱sa kinene, Mukama ali na b̯u̱sobozi̱, ab̯u̱lweri̱ nka muheeku. Yaahangi̱ri̱ nsi, tigisobora kutengeeta. ");
INSERT INTO rub_vpl VALUES ("PS93_2","020_93_2","PSA","93","2","2","Kitebe kya b̯ukama b̯wamu kyagu̱mi̱i̱rweho kuruga kadei, weewe oloho kuruga kadei na kadei. ");
INSERT INTO rub_vpl VALUES ("PS93_3","020_93_3","PSA","93","3","3","Ai̱ Mukama, mi̱i̱zu̱lo mya meezi̱ mi̱hu̱u̱ki̱ri̱, kwizula kwa meezi̱ ku̱ti̱nda nka nkuba, mwizulo gu̱hu̱ki̱i̱rye bijanga. ");
INSERT INTO rub_vpl VALUES ("PS93_4","020_93_4","PSA","93","4","4","Wamaani kukira kuhuura kweitaka, wamaani hoi̱ kukira bijanga bya mataka, Mukama yogwo waahakyendi̱ waamaani! ");
INSERT INTO rub_vpl VALUES ("PS93_5","020_93_5","PSA","93","5","5","Ai̱ Mukama, biragiro byamu bya b̯winganiza kwo, b̯unanu b̯u̱semereeri̱ nnyu̱mba gyamu, biro byensei̱. ");
INSERT INTO rub_vpl VALUES ("PS94_1","020_94_1","PSA","94","1","1","Ai̱ Mukama, Ruhanga ofubira basobeerye, woolokya ki̱ni̱ga kyamu, obafubire! ");
INSERT INTO rub_vpl VALUES ("PS94_2","020_94_2","PSA","94","2","2","Byoka ai̱ we ocwera nsi gyensei̱ misangu, cwera ba myehembo ku̱ki̱semereeri̱. ");
INSERT INTO rub_vpl VALUES ("PS94_3","020_94_3","PSA","94","3","3","Ai̱ Mukama babiibi bali̱doosya di̱i̱, bali̱doosya hanya kwetembya? ");
INSERT INTO rub_vpl VALUES ("PS94_4","020_94_4","PSA","94","4","4","Babaza bigambu bya kwehaariiza, nkori̱ za bibii ziicala ni̱zeetembya. ");
INSERT INTO rub_vpl VALUES ("PS94_5","020_94_5","PSA","94","5","5","Ai̱ Mukama zi̱zi̱kya bantu baamu, ni̱zi̱wonawonesya bantu bawakomi̱ri̱mwo. ");
INSERT INTO rub_vpl VALUES ("PS94_6","020_94_6","PSA","94","6","6","Bei̱ta bamukaabakwere na banyamahanga kandi ni̱bazi̱ri̱zi̱nda nfu̱u̱zi̱, ");
INSERT INTO rub_vpl VALUES ("PS94_7","020_94_7","PSA","94","7","7","nibeweeragana yati, “Mukama takubiwona, kandi Ruhanga wa Yakobbo bi̱byo tabifaaho.” ");
INSERT INTO rub_vpl VALUES ("PS94_8","020_94_8","PSA","94","8","8","Mwetegereze, nywe mpwi̱si̱, badoma nywe mulikenga di̱i̱? ");
INSERT INTO rub_vpl VALUES ("PS94_9","020_94_9","PSA","94","9","9","Yogwo munyakuhanga mapokopo ti̱yeegwa? Yogwo munyakukora mei̱so, tawona? ");
INSERT INTO rub_vpl VALUES ("PS94_10","020_94_10","PSA","94","10","10","Yogwo afubira mahanga, takusobora kukufubira? Yogwo yeegi̱ri̱ b̯uli kintu, takusobora kwega kyolimu kukora? ");
INSERT INTO rub_vpl VALUES ("PS94_11","020_94_11","PSA","94","11","11","Mukama yeega biteekerezu bya bantu, nka kubitali bya mugasu. ");
INSERT INTO rub_vpl VALUES ("PS94_12","020_94_12","PSA","94","12","12","Ai̱ Mukama, kaali na mu̱gi̱sa yogwo gyohab̯ura, okamwegeesya biragiro byamu. ");
INSERT INTO rub_vpl VALUES ("PS94_13","020_94_13","PSA","94","13","13","Aleke atunge kuhumula mu b̯wi̱re b̯wa b̯ujune, ku̱doosya babiibi b̯ubalibatemera ki̱i̱na. ");
INSERT INTO rub_vpl VALUES ("PS94_14","020_94_14","PSA","94","14","14","Kubba Mukama talilekeera bantu baamwe, talibahemukira. ");
INSERT INTO rub_vpl VALUES ("PS94_15","020_94_15","PSA","94","15","15","Barungi balitunga b̯winganiza, kandi ba mitima mi̱terekereru̱ balib̯uhondera. ");
INSERT INTO rub_vpl VALUES ("PS94_16","020_94_16","PSA","94","16","16","Naani munyakwemeera nagya ku̱lwani̱sya babiibi? Naani munyakukwatagana na gya ku̱lwani̱sya nkori̱ za bibii? ");
INSERT INTO rub_vpl VALUES ("PS94_17","020_94_17","PSA","94","17","17","Kabbenge Mukama atanju̱ni̱ri̱, nyaali heehi̱ kubba mu nsi gya baku̱u̱. ");
INSERT INTO rub_vpl VALUES ("PS94_18","020_94_18","PSA","94","18","18","Ai̱ Mukama, b̯u̱nyateekereze nkukibbala, hooho ngonzi zaamu zinene zanju̱ni̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS94_19","020_94_19","PSA","94","19","19","Mutima gwange b̯ugubba nigukutuntura bintu binene, nompu̱mu̱u̱lya mwozo gwange. ");
INSERT INTO rub_vpl VALUES ("PS94_20","020_94_20","PSA","94","20","20","Balemi̱ babiibi banyakukora byeitima bakabirabya mu kiragiro, basobora kwekwata nawe? ");
INSERT INTO rub_vpl VALUES ("PS94_21","020_94_21","PSA","94","21","21","Beekoba hamwei̱ mwa kwi̱ta bamananu, na ku̱zi̱ri̱zi̱nda bab̯wo batali na musangu. ");
INSERT INTO rub_vpl VALUES ("PS94_22","020_94_22","PSA","94","22","22","Bei̱tu̱ Mukama yooyo kigo kyange kinyamaani, kandi Ruhanga wange yooyo lubbaali lwa b̯wi̱ru̱ki̱ro b̯wange. ");
INSERT INTO rub_vpl VALUES ("PS94_23","020_94_23","PSA","94","23","23","Alibasasula hab̯wa bibii byab̯u, abahwerekereerye hab̯wa b̯ubiibi b̯wab̯u, Mukama Ruhanga weetu̱ alibatooleraho ki̱mwei̱. ");
INSERT INTO rub_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","Mwi̱ze tu̱hi̱i̱mi̱re Mukama, tu̱ku̱ngye na kusemererwa lubbaali lwa kujunwa kwetu̱. ");
INSERT INTO rub_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","Tugyende mu mei̱so gaamwe naaku̱si̱i̱ma tu̱hi̱i̱me tusemererwa na byembu bya kuhaariiza! ");
INSERT INTO rub_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","Kubba Mukama yooyo Ruhanga wamaani, ali mukama wa maani kukiraho baruhanga bensei̱. ");
INSERT INTO rub_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","Ndi̱ha za nsi zensei̱ zili mu mikono myamwe, nsahu zilei zensei̱ zaamwe. ");
INSERT INTO rub_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Itaka de lye, kubba yooyo yaali̱koori̱, nsi yaagi̱hangi̱ri̱ na ngalu zaamwe. ");
INSERT INTO rub_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Mwi̱ze tu̱ramye tu̱b̯u̱ndeeri̱, tu̱mu̱ku̱ndi̱re malu̱ Mukama Mu̱hangi̱ weetu̱! ");
INSERT INTO rub_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","Kubba yooyo Ruhanga weetu̱, twe tuli bantu bei̱li̱i̱si̱i̱ryo lyamwe, kandi ntaama za mukono gwamwe. Kiro kyadeeru b̯u̱mwakeegwa iraka lyamwe, ");
INSERT INTO rub_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","mu̱tataati̱i̱rya mitima myenyu̱, nka bahaaha beenyu̱ ku̱bakoori̱ mu Meri̱bba na Maasa nibali mwirungu. ");
INSERT INTO rub_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","Bandengi̱ri̱ kandi baapi̱ma kugumisiriza kwange, nab̯ubaali baweeni̱ bi̱nyabakoleeri̱. ");
INSERT INTO rub_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","Nyabi̱hi̱ri̱i̱rwe bantu ba mu̱hi̱hi̱ gu̱gwo kumala myaka maku̱mi̱ ganei, nyaakoba yati, “Bali bantu bahabi̱ri̱ mitima, kandi ti̱beegi̱ri̱ mihanda myange.” ");
INSERT INTO rub_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","Kyokyo nyaarahi̱ri̱i̱ri̱ na ki̱ni̱ga ninkoba yati, “Tihaloho noomwe mu mu̱hi̱hi̱ gwenyu̱ alingira mu kiikaru kya b̯uhuumulo b̯wange.” ");
INSERT INTO rub_vpl VALUES ("PS96_1","020_96_1","PSA","96","1","1","Mu̱hi̱i̱mi̱re Mukama kyembu kihyaka, mu̱hi̱i̱mi̱re Mukama nywe nsi gyensei̱! ");
INSERT INTO rub_vpl VALUES ("PS96_2","020_96_2","PSA","96","2","2","Mu̱hi̱i̱mi̱re Mukama, muhaariize ibara lyamwe, mu̱bazenge ha kujunwa kwamwe b̯uli kiro. ");
INSERT INTO rub_vpl VALUES ("PS96_3","020_96_3","PSA","96","3","3","Mu̱rangi̱i̱renge ki̱ti̱i̱ni̱sa kyamwe mu mahanga, na byamahanu byamwe mu bantu benseenya! ");
INSERT INTO rub_vpl VALUES ("PS96_4","020_96_4","PSA","96","4","4","Kubba Mukama wa maani kandi aki̱i̱rayo kuhaariizib̯wa, akusemeera ku̱ti̱i̱nwa kukiraho baruhanga bensei̱. ");
INSERT INTO rub_vpl VALUES ("PS96_5","020_96_5","PSA","96","5","5","Hab̯wakubba baruhanga bensei̱ ba mahanga bi̱si̱sani̱ kwankei, bei̱tu̱ Mukama yooyo munyakuhanga iguru. ");
INSERT INTO rub_vpl VALUES ("PS96_6","020_96_6","PSA","96","6","6","Ali na ki̱ti̱i̱ni̱sa na mananu! Mu kiikaru kyamwe kitongoole, halimwo b̯u̱sobozi̱ na kusemera. ");
INSERT INTO rub_vpl VALUES ("PS96_7","020_96_7","PSA","96","7","7","Mu̱haari̱i̱ze Mukama, nywe bantu bensei̱, mu̱haari̱i̱ze Mukama hab̯wa ki̱ti̱i̱ni̱sa na b̯u̱sobozi̱ b̯wamwe. ");
INSERT INTO rub_vpl VALUES ("PS96_8","020_96_8","PSA","96","8","8","Mu̱haari̱i̱ze ibara lya Mukama lya ki̱ti̱i̱ni̱sa, muleete kihongwa Mwi̱ngi̱re mu Yeekaaru̱ gyamwe! ");
INSERT INTO rub_vpl VALUES ("PS96_9","020_96_9","PSA","96","9","9","Mu̱ramye Mukama hab̯wa ki̱ti̱i̱ni̱sa kyamwe kitongoole, nsi gyensei̱ mujegeje mu mei̱so gaamwe. ");
INSERT INTO rub_vpl VALUES ("PS96_10","020_96_10","PSA","96","10","10","Muweere mahanga gensei̱ yati, “Mukama ahaariizwe! Nsi gyensei̱ yaagi̱taati̱i̱rye tigisobora ku̱zi̱ngi̱zi̱ka, alicwera bantu bensei̱ musangu na b̯winganiza.” ");
INSERT INTO rub_vpl VALUES ("PS96_11","020_96_11","PSA","96","11","11","Leka iguru lisemererwe, na nsi gyegonze, itaka na byensei̱ bigicalamwo, bihuure, ");
INSERT INTO rub_vpl VALUES ("PS96_12","020_96_12","PSA","96","12","12","leka misiri na bilimwa byensei̱ byebbune! Kasi misaali myensei̱ mya mu kibira myezi̱ngi̱i̱zye na kusemererwa. ");
INSERT INTO rub_vpl VALUES ("PS96_13","020_96_13","PSA","96","13","13","Bali̱hi̱i̱ma mu mei̱so ga Mukama, kubba akwi̱za kucwera nsi musangu, alicwera nsi mu mananu gaamwe, na bantu mu b̯wesigwa b̯wamwe. ");
INSERT INTO rub_vpl VALUES ("PS97_1","020_97_1","PSA","97","1","1","Mukama yooyo alema, leka nsi gisemererwe, bi̱zi̱nga byensei̱ byegonze. ");
INSERT INTO rub_vpl VALUES ("PS97_2","020_97_2","PSA","97","2","2","Bikaka na nti̱ti̱ bi̱mwelogoleerye, mananu na b̯winganiza byobyo mu̱si̱nge gwa kitebe kya b̯ukama b̯wamwe. ");
INSERT INTO rub_vpl VALUES ("PS97_3","020_97_3","PSA","97","3","3","Mworo gugyenda mu mei̱so gaamwe, ni̱gwokya banyanzigwa baamwe bensei̱. ");
INSERT INTO rub_vpl VALUES ("PS97_4","020_97_4","PSA","97","4","4","Kyererezi̱ kyamwe kyakira nsi gyensei̱, nsi giwona nigikankana. ");
INSERT INTO rub_vpl VALUES ("PS97_5","020_97_5","PSA","97","5","5","Nsahu zaaga nka masaju mu mei̱so ga Mukama, mu mei̱so ga Mukama wa mu nsi gyensei̱. ");
INSERT INTO rub_vpl VALUES ("PS97_6","020_97_6","PSA","97","6","6","Iguru lirangiira mananu gaamwe, kandi mahanga gensei̱ gawona ki̱ti̱i̱ni̱sa kyamwe. ");
INSERT INTO rub_vpl VALUES ("PS97_7","020_97_7","PSA","97","7","7","Bantu baramya bi̱si̱sani̱ bensei̱ baswarambe, beehaari̱i̱zi̱sya bi̱si̱sani̱ bi̱tagira mugasu, nywe baruhanga, mu̱ramyenge MUKAMA. ");
INSERT INTO rub_vpl VALUES ("PS97_8","020_97_8","PSA","97","8","8","Sayu̱u̱ni̱ gyegwa kandi nigisemererwa, na bahara ba Yu̱da nibeegonza, ai̱ Mukama hab̯wa mu̱li̱ngo gwocweramwo misangu myamu. ");
INSERT INTO rub_vpl VALUES ("PS97_9","020_97_9","PSA","97","9","9","Ai̱ Mukama, Waahakyendi̱ Hoi̱, olema nsi gyensei̱, oli wa ki̱ti̱i̱ni̱sa kukiraho baruhanga bandi bensei̱. ");
INSERT INTO rub_vpl VALUES ("PS97_10","020_97_10","PSA","97","10","10","Nywe nywensei̱ bendya Mukama, mu̱nobe bibii. Alinda b̯womi b̯wa barungi baamwe, naabajuna kuruga mu mikono bya babiibi. ");
INSERT INTO rub_vpl VALUES ("PS97_11","020_97_11","PSA","97","11","11","Kyererezi̱ kyakira bamananu, na kusemererwa ni̱kwi̱zi̱ra ba mitima mi̱terekereru̱. ");
INSERT INTO rub_vpl VALUES ("PS97_12","020_97_12","PSA","97","12","12","Nywe bamananu mu̱semereerwe mu Mukama kandi muhaariize ibara lyamwe li̱syanu̱. ");
INSERT INTO rub_vpl VALUES ("PS98_1","020_98_1","PSA","98","1","1","Zabbu̱li̱. Mu̱hi̱i̱mi̱re Mukama kyembu kihyaka, kubba akoori̱ byamahanu! Ngalu gyamwe gya b̯udyo gi̱leeti̱ri̱ ku̱si̱ngu̱ra, mukono gwamwe gu̱teeri̱ho kujunwa. ");
INSERT INTO rub_vpl VALUES ("PS98_2","020_98_2","PSA","98","2","2","Mukama aheeri̱ kujuna kwamwe kwegeb̯wa, yoolokeerye mananu gaamwe mu mahanga. ");
INSERT INTO rub_vpl VALUES ("PS98_3","020_98_3","PSA","98","3","3","Ei̱zu̱ki̱ri̱ b̯wesigwa na ngonzi zaamwe zinene hali nnyu̱mba gyʼI̱saleeri̱, mmaliiro gya nsi gyensei̱ gi̱weeni̱ kujunwa kwa Ruhanga weetu̱. ");
INSERT INTO rub_vpl VALUES ("PS98_4","020_98_4","PSA","98","4","4","Kuutira Mukama muzira gwa kusemererwa uwe nsi gyensei̱, Mu̱byokye kyembu, mu̱hi̱i̱me nimumuhariiza! ");
INSERT INTO rub_vpl VALUES ("PS98_5","020_98_5","PSA","98","5","5","Mu̱hi̱i̱mi̱re Mukama, mu̱mu̱haari̱i̱ze neiraka lya ndi̱ngi̱di̱! ");
INSERT INTO rub_vpl VALUES ("PS98_6","020_98_6","PSA","98","6","6","Mu̱ku̱u̱te ngwara na mubbilo, mu̱ku̱ngye mu̱semererwe mu mei̱so ga Mukama, mu̱lemi̱ weetu̱. ");
INSERT INTO rub_vpl VALUES ("PS98_7","020_98_7","PSA","98","7","7","Leke itaka na byensei̱ binyakulimwo byaluke, nsi na bab̯wo bagicalamwo! ");
INSERT INTO rub_vpl VALUES ("PS98_8","020_98_8","PSA","98","8","8","Leke migira mikuute mu ngalu, leke mbamba zi̱hi̱i̱mi̱re hamwei̱ na kusemererwa, ");
INSERT INTO rub_vpl VALUES ("PS98_9","020_98_9","PSA","98","9","9","mu mei̱so ga Mukama kubba akwi̱za kucwera nsi musangu, alicwera nsi na mananu, hamwei̱ na b̯winganiza mu bantu. ");
INSERT INTO rub_vpl VALUES ("PS99_1","020_99_1","PSA","99","1","1","Mukama yooyo alema, leka bantu bajegeje! Ei̱cali̱i̱ri̱ ha kitebe kya b̯ukama hakati̱ wa bakeru̱u̱bbi̱, leka nsi gi̱zi̱ngi̱zi̱ke! ");
INSERT INTO rub_vpl VALUES ("PS99_2","020_99_2","PSA","99","2","2","Mukama wamaani mu Sayu̱u̱ni̱, aku̱haari̱i̱zi̱b̯wa hakyendi̱ wa bantu bensei̱. ");
INSERT INTO rub_vpl VALUES ("PS99_3","020_99_3","PSA","99","3","3","Leka bantu bensei̱ bahaariize b̯ukooto na b̯uzira b̯weibara lyamu, Yooyo mu̱syanu̱! ");
INSERT INTO rub_vpl VALUES ("PS99_4","020_99_4","PSA","99","4","4","Mukama mu maani gaamwe yendya b̯winganiza ogu̱mi̱i̱ryeho nkoragana, waadosereerya b̯unanu, na b̯urungi mu Yakobbo. ");
INSERT INTO rub_vpl VALUES ("PS99_5","020_99_5","PSA","99","5","5","Muhaariize Mukama Ruhanga weetu̱, mu̱rami̱i̱rye mu mei̱so ga kitebe kyamwe! Ali yooyo mu̱syanu̱! ");
INSERT INTO rub_vpl VALUES ("PS99_6","020_99_6","PSA","99","6","6","Mu̱sa nʼAlooni̱ baalingi bamwei̱ mu balaami̱ baamwe, na Samwi̱ri̱ yaali mu bab̯wo banyakweta ibara lyamwe, beeti̱ri̱ Mukama, yaabeeramwo. ");
INSERT INTO rub_vpl VALUES ("PS99_7","020_99_7","PSA","99","7","7","Yaabazengi̱ nabo kuraba mu nkondo gyeiguru beegwi̱ri̱ bigambu byamwe baabikwata, hamwei̱ na biragiro bi̱yaabaheeri̱. ");
INSERT INTO rub_vpl VALUES ("PS99_8","020_99_8","PSA","99","8","8","Ai̱ Mukama Ruhanga weetu̱, waaberi̱ri̱mwo kusaba kwab̯u, oli Ruhanga munyakubaganyira, naab̯u̱wafu̱u̱bi̱i̱ri̱ b̯ubiibi b̯wab̯u. ");
INSERT INTO rub_vpl VALUES ("PS99_9","020_99_9","PSA","99","9","9","Muhaariize Mukama Ruhanga weetu̱, kandi mu̱rami̱i̱rye ha lusahu lwamwe lu̱syanu̱, kubba Ruhanga weetu̱ ali mu̱syanu̱! ");
INSERT INTO rub_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","Zabbu̱li̱ gya Ku̱si̱i̱ma. Mu̱hi̱i̱mi̱re Mukama, nywe ba mu nsi gyensei̱ neiraka lya kusemererwa! ");
INSERT INTO rub_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","Mu̱heereze Mukama nakusemererwa! Mwi̱ze mu mei̱so gaamwe na ku̱hi̱i̱ma! ");
INSERT INTO rub_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","Mukyege nti, Mukama abba Ruhanga! Yooyo munyakutuhanga, kandi tuli baamwe, tuli bantu bei̱li̱i̱si̱i̱ryo lyamwe. ");
INSERT INTO rub_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","Mwi̱ngi̱re mu Yeekaaru̱ gyamwe na ku̱si̱i̱ma, na mu zi̱gati̱ gyamwe na kuhaariiza, mu̱mu̱si̱i̱me muhaariize ibara lyamwe! ");
INSERT INTO rub_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","Kubba Mukama murungi, ngonzi zaamwe zinene za biro na biro, na b̯wesigwa b̯wamwe hali mi̱hi̱hi̱ myensei̱. ");
INSERT INTO rub_vpl VALUES ("PS101_1","020_101_1","PSA","101","1","1","Zabbu̱li̱ gya Dau̱di̱. Ai̱ Mukama, nyahi̱i̱manga ha b̯winganiza na ngonzi zaamu zinene, nyakuhaariizanga na kyembu. ");
INSERT INTO rub_vpl VALUES ("PS101_2","020_101_2","PSA","101","2","2","Nditaho mutima kukwata muhanda gutalimwo kabii. Beiraba olindwereera di̱i̱? Ndilibata na mutima gu̱syanu̱, mu nnyu̱mba gyange. ");
INSERT INTO rub_vpl VALUES ("PS101_3","020_101_3","PSA","101","3","3","Tinditaho mei̱so gange, hali kintu kyensei̱ kitalimwo mugasu, nnoba bikorwa bya bantu bakuhaba, tindikwatagana nabyo. ");
INSERT INTO rub_vpl VALUES ("PS101_4","020_101_4","PSA","101","4","4","Ba mitima mibiibi baabbanga hadei nagya, tindibba na nkoragana gyensei̱ na kibii. ");
INSERT INTO rub_vpl VALUES ("PS101_5","020_101_5","PSA","101","5","5","Yensei̱ ahesa mwi̱ra na mu nsita, ndi̱mu̱hwerekereerya. Ti̱ndi̱gu̱mi̱ri̱si̱za yensei̱, wa myehaariizo na bakwetembya. ");
INSERT INTO rub_vpl VALUES ("PS101_6","020_101_6","PSA","101","6","6","Bantu beesigwa mu nsi, ndibakwatirwa mbabazi̱, kwokwo basobore kwicala nagya. Yogwo alibatira mu muhanda gurungi, akwi̱za kumpeereza. ");
INSERT INTO rub_vpl VALUES ("PS101_7","020_101_7","PSA","101","7","7","Tihaloho mu̱gobya aliicaara mu nnyu̱mba gyange, tihaloho mucwa makuru alyemeera mu mei̱so gange. ");
INSERT INTO rub_vpl VALUES ("PS101_8","020_101_8","PSA","101","8","8","B̯uli mwakya, nyahwerekereeryanga, babiibi bensei̱ beicala mu nsi, mmaleho nkori̱ za bibii, kuruga mu rub̯uga lwa Mukama ");
INSERT INTO rub_vpl VALUES ("PS102_1","020_102_1","PSA","102","1","1","Kusaba kwa yogwo amigiriziib̯we, b̯wabba mu b̯u̱ru̱mi̱ kandi akatwala kulira kwamwe hali Mukama. Ai̱ Mukama, weegwa kusaba kwange, kukunga kwange kukudwereere! ");
INSERT INTO rub_vpl VALUES ("PS102_2","020_102_2","PSA","102","2","2","Otanyebi̱sangaho, mu b̯wi̱re b̯wa b̯ujune! Onzi̱remwo b̯wangu b̯unyakakusabanga! ");
INSERT INTO rub_vpl VALUES ("PS102_3","020_102_3","PSA","102","3","3","Kubba biro byange bi̱kwi̱ru̱ka nka mwi̱ca, na maku̱ha gange gaku̱hya nka kikoomi, ");
INSERT INTO rub_vpl VALUES ("PS102_4","020_102_4","PSA","102","4","4","Mutima gwange gu̱mali̱ki̱rwemwo maani kandi gwehi̱nyi̱ri̱ nkeisubi, ni̱nyebeera na kudya bidyo. ");
INSERT INTO rub_vpl VALUES ("PS102_5","020_102_5","PSA","102","5","5","Hab̯wa kutaaga maani, maku̱ha gange ganku̱du̱mu̱ki̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS102_6","020_102_6","PSA","102","6","6","Ndi nka ki̱nyoni̱ kya mwirungu, nkwisana nka hi̱i̱hya mu makandi. ");
INSERT INTO rub_vpl VALUES ("PS102_7","020_102_7","PSA","102","7","7","Ndaala nimbona ntakwebbaka, nkulungwalungwa nka nyoni ha kasolya. ");
INSERT INTO rub_vpl VALUES ("PS102_8","020_102_8","PSA","102","8","8","Banyanzigwa bange banjooga ku̱keesya b̯wi̱re, bankyena nibaatulanga ibara lyange, ");
INSERT INTO rub_vpl VALUES ("PS102_9","020_102_9","PSA","102","9","9","I̱syanu̱ lyolyo ndya, mali̱ga googo nywa. ");
INSERT INTO rub_vpl VALUES ("PS102_10","020_102_10","PSA","102","10","10","Hab̯wa ki̱ni̱ga na kusalirwa kwamu, wansengi̱ri̱ wanku̱u̱ti̱ra hansi ");
INSERT INTO rub_vpl VALUES ("PS102_11","020_102_11","PSA","102","11","11","Biro byange bikwisana nka mu̱tu̱ntu̱lu̱ gwa joojolo, mpotoki̱ri̱ keisubi. ");
INSERT INTO rub_vpl VALUES ("PS102_12","020_102_12","PSA","102","12","12","Ai̱ Mukama, olilema biro byensei̱, oliicala noi̱zu̱kwa mu mi̱hi̱hi̱ myenseenya ");
INSERT INTO rub_vpl VALUES ("PS102_13","020_102_13","PSA","102","13","13","Olibyoka okwati̱i̱rwe Sayu̱u̱ni̱ kisa, b̯ub̯u b̯wob̯wo b̯wi̱re b̯wa kuboolokya mbabazi̱, kasu̱mi̱ konyini kadoori̱. ");
INSERT INTO rub_vpl VALUES ("PS102_14","020_102_14","PSA","102","14","14","Kubba baheereza baamu, bendya hoi̱ Sayu̱u̱ni̱, kandi nibasaliirwa hab̯wa kuhwerekeera kwalwo. ");
INSERT INTO rub_vpl VALUES ("PS102_15","020_102_15","PSA","102","15","15","Mahanga gensei̱ gali̱ti̱i̱na ibara lya Mukama, na bakama bensei̱ ba munsi bali̱ti̱i̱na ki̱ti̱i̱ni̱sa kyamu. ");
INSERT INTO rub_vpl VALUES ("PS102_16","020_102_16","PSA","102","16","16","Kubba Mukama, ali̱bi̱mbamwo Sayu̱u̱ni̱ b̯uhyaka, ni̱yeezolokya mu ki̱ti̱i̱ni̱sa kyamwe. ");
INSERT INTO rub_vpl VALUES ("PS102_17","020_102_17","PSA","102","17","17","Aliiramwona kusaba kwa banaku, kandi taligaya kusaba kwab̯u. ");
INSERT INTO rub_vpl VALUES ("PS102_18","020_102_18","PSA","102","18","18","Leka ki̱kyo kihandiikwe hab̯wa mu̱hi̱hi̱ gu̱li̱i̱rahoona, aleke na bab̯wo bacaali kubyalwa bahaariize Mukama, ");
INSERT INTO rub_vpl VALUES ("PS102_19","020_102_19","PSA","102","19","19","yaali̱ngi̱ri̱i̱ri̱ kuruga mu kiikaru kyamwe ki̱syanu̱ kya mwiguru, Mukama yaawona nsi, ");
INSERT INTO rub_vpl VALUES ("PS102_20","020_102_20","PSA","102","20","20","yeegwa kulira kwa banyankomo, yaateesu̱la banyakucwerwa gwa ku̱kwa, ");
INSERT INTO rub_vpl VALUES ("PS102_21","020_102_21","PSA","102","21","21","aleke barangiire ibara lya Mukama mu Sayu̱u̱ni̱, kandi bamuhaariize mu Yeru̱salemu̱. ");
INSERT INTO rub_vpl VALUES ("PS102_22","020_102_22","PSA","102","22","22","Bantu balyesorooza hamwei̱, makama gahaari̱i̱ze Mukama. ");
INSERT INTO rub_vpl VALUES ("PS102_23","020_102_23","PSA","102","23","23","Amaari̱mwo maani mu b̯wi̱re b̯u̱dooli̱, yaakehyaho biro byange. ");
INSERT INTO rub_vpl VALUES ("PS102_24","020_102_24","PSA","102","24","24","Nkukoba yati, “Ai̱ Ruhanga, otanzi̱ta ntakagu̱lu̱u̱si̱ri̱, myaka myamu timihinduka hali mi̱hi̱hi̱ myenseenya!” ");
INSERT INTO rub_vpl VALUES ("PS102_25","020_102_25","PSA","102","25","25","B̯wodi̱ kadei waateeri̱ho mu̱si̱nge gwa nsi, neiguru liicala mulimo gwa ngalu zaamu. ");
INSERT INTO rub_vpl VALUES ("PS102_26","020_102_26","PSA","102","26","26","Bi̱byo byensei̱ bilimalikaho, bei̱tu̱ we, olisigalaho, bi̱li̱gu̱lu̱u̱sa nka kilwalu, olibihindula nka lu̱goye, bimalikeho. ");
INSERT INTO rub_vpl VALUES ("PS102_27","020_102_27","PSA","102","27","27","Bei̱tu̱ we, tohinduka, kandi olyomeera biro na biro. ");
INSERT INTO rub_vpl VALUES ("PS102_28","020_102_28","PSA","102","28","28","Baana ba baheereza baamu baliicala mu b̯u̱si̱nge, oliwona maani ga beizukulu baab̯u. ");
INSERT INTO rub_vpl VALUES ("PS103_1","020_103_1","PSA","103","1","1","Zabbu̱li̱ gya Dau̱di̱. Ai̱ mutima gwange, haariiza Mukama, na byensei̱ bili muli gya haari̱i̱ze ibara lyamwe li̱syanu̱! ");
INSERT INTO rub_vpl VALUES ("PS103_2","020_103_2","PSA","103","2","2","Haariiza Mukama, ai̱ mutima gwange, kandi oteebeera birungi byakora. ");
INSERT INTO rub_vpl VALUES ("PS103_3","020_103_3","PSA","103","3","3","Aganyira b̯ubiibi b̯wamu b̯wensei̱, naahoni̱a na nseeri̱ zaamu zensei̱. ");
INSERT INTO rub_vpl VALUES ("PS103_4","020_103_4","PSA","103","4","4","Munyakucungura b̯womi b̯wamu b̯wensei̱ kuruga mu ki̱i̱na, akulwalya kondo gya mbabazi̱ na ngonzi zinene, ");
INSERT INTO rub_vpl VALUES ("PS103_5","020_103_5","PSA","103","5","5","naakuha birungi, bi̱kwi̱ryemwo maani ga b̯uto nka ngweri̱. ");
INSERT INTO rub_vpl VALUES ("PS103_6","020_103_6","PSA","103","6","6","Mukama akora birungi, aha b̯winganiza hali bab̯wo bamigiriziib̯we. ");
INSERT INTO rub_vpl VALUES ("PS103_7","020_103_7","PSA","103","7","7","Yoolokeerye nkora gyamwe hali Mu̱sa, na milimo myamwe hali Bei̱saleeri̱. ");
INSERT INTO rub_vpl VALUES ("PS103_8","020_103_8","PSA","103","8","8","Mukama eicala wambabazi̱ kandi mu̱ganyi̱ri̱, tabihirwa wangu, ngonzi zaamwe zinene tizihinduka. ");
INSERT INTO rub_vpl VALUES ("PS103_9","020_103_9","PSA","103","9","9","Tali̱lamba njenjeera, kandi talibba na ki̱ni̱ga b̯wi̱re b̯wensei̱. ");
INSERT INTO rub_vpl VALUES ("PS103_10","020_103_10","PSA","103","10","10","Tatufubira ku̱si̱gi̱ki̱ra ha bibii byetu̱, tatubonereza nka b̯ubiibi b̯wetu̱ ku̱b̯u̱semereeri̱. ");
INSERT INTO rub_vpl VALUES ("PS103_11","020_103_11","PSA","103","11","11","Nkeiguru kulili hakyendi̱ hoi̱ na nsi, kwokwo ngonzi zaamwe zinene ziicala hali bab̯wo bamu̱ti̱i̱na. ");
INSERT INTO rub_vpl VALUES ("PS103_12","020_103_12","PSA","103","12","12","B̯uhulukalyoba nka kuheicala hadei na b̯ugwalyoba, kwokwo yatyo atutoolaho bibii byetu̱. ");
INSERT INTO rub_vpl VALUES ("PS103_13","020_103_13","PSA","103","13","13","Mu̱li̱ngo bba baana aganyira baana baamwe, kwokwo na Mukama aganyira bab̯wo bamu̱ti̱i̱na. ");
INSERT INTO rub_vpl VALUES ("PS103_14","020_103_14","PSA","103","14","14","Kubba yeegi̱ri̱ b̯uhangwa b̯wetu̱, ei̱zu̱ka nka ku̱twaru̱gi̱ri̱ mwicuucu. ");
INSERT INTO rub_vpl VALUES ("PS103_15","020_103_15","PSA","103","15","15","B̯womi b̯wa muntu b̯uli nkeisubi, rundi byakyo bya mwirungu bikunkumuka ni̱bi̱syeraho wangu. ");
INSERT INTO rub_vpl VALUES ("PS103_16","020_103_16","PSA","103","16","16","Mpehu gi̱bi̱ku̱u̱ta nibirugaho bitakusobora kwi̱raho gwakandi. ");
INSERT INTO rub_vpl VALUES ("PS103_17","020_103_17","PSA","103","17","17","Bei̱tu̱ ngonzi zinene za Mukama ziicaliraho kuruga kadei na kadei, hali bab̯wo bamu̱ti̱i̱na, mananu gaamwe gadwereera beizukulu ba bantu, ");
INSERT INTO rub_vpl VALUES ("PS103_18","020_103_18","PSA","103","18","18","na bab̯wo bei̱zu̱ka ndagaanu gyamwe, kandi nibakwata biragiro byamwe. ");
INSERT INTO rub_vpl VALUES ("PS103_19","020_103_19","PSA","103","19","19","Mukama ateeri̱hoona kitebe gya b̯ukama b̯wamwe mwiguru, kandi akulema b̯uli kintu kyenseenya. ");
INSERT INTO rub_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","Muhaariize Mukama, nywe bamalayika baamwe, nywe bamaani banyakukwata kigambu kyamwe, mukab̯undalira iraka lyamwe. ");
INSERT INTO rub_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","Muhaariize Mukama, nywe mahe gaamwe nywensei̱, nywe baheereza baamwe bakora bi̱yendya! ");
INSERT INTO rub_vpl VALUES ("PS103_22","020_103_22","PSA","103","22","22","Muhaariize Mukama, nywe bihangwa byensei̱, mu bikaaru byamwe byensei̱ byalemeramwo. B̯womi b̯wange, haariiza Mukama! ");
INSERT INTO rub_vpl VALUES ("PS104_1","020_104_1","PSA","104","1","1","B̯womi b̯wange haariiza Mukama! Ai̱ Mukama Ruhanga wange oli wamaani mali̱! Oli mukooto kandi wa ki̱ti̱i̱ni̱sa kwo! ");
INSERT INTO rub_vpl VALUES ("PS104_2","020_104_2","PSA","104","2","2","Welongoleerwe kyererezi̱ nkʼolweri̱ lu̱goye, waaregi̱ri̱ iguru nka mu̱bi̱mba heema. ");
INSERT INTO rub_vpl VALUES ("PS104_3","020_104_3","PSA","104","3","3","Obi̱mba nnyu̱mba gyamu ku meezi̱ nkoku̱gi̱bi̱mba ha lubbaali, ofoora bikaka kigaali kyamu, nooli̱bati̱ra hakyendi̱ wa mpehu nka bimpaha. ");
INSERT INTO rub_vpl VALUES ("PS104_4","020_104_4","PSA","104","4","4","Afoora batumwa baamwe mpehu, baheereza baamwe ndimi za mworo. ");
INSERT INTO rub_vpl VALUES ("PS104_5","020_104_5","PSA","104","5","5","Waateeri̱ nsi ha mu̱si̱nge gwagyo, aleke gi̱tali̱zi̱ngi̱zi̱ka. ");
INSERT INTO rub_vpl VALUES ("PS104_6","020_104_6","PSA","104","6","6","Waagyelogoleerye na meezi̱, meezi̱ gaabbumba nsahu. ");
INSERT INTO rub_vpl VALUES ("PS104_7","020_104_7","PSA","104","7","7","B̯u̱wacomeeri̱ meezi̱ gaasyereeri̱ho, b̯u̱gegwi̱ri̱ kubbwatuka kwamu gaaborogota. ");
INSERT INTO rub_vpl VALUES ("PS104_8","020_104_8","PSA","104","8","8","Meezi̱ gaaheteeri̱ kwakyendi̱ wa nsahu, gabbwomoka mu bihanga. ");
INSERT INTO rub_vpl VALUES ("PS104_9","020_104_9","PSA","104","9","9","Waagatereeri̱ mubaga aleke gatacwa, kandi gaatali̱i̱ra ku̱bbu̱tya nsi. ");
INSERT INTO rub_vpl VALUES ("PS104_10","020_104_10","PSA","104","10","10","Oha misu kubbwoma meezi̱ mu migira, nigaheetera hakati̱ wa mbamba na bihanga. ");
INSERT INTO rub_vpl VALUES ("PS104_11","020_104_11","PSA","104","11","11","Hooho bisolo bya mu kisaka binyweera, nyoota gimalika mu ndogoyi̱ za mwirungu. ");
INSERT INTO rub_vpl VALUES ("PS104_12","020_104_12","PSA","104","12","12","Mu misaali mi̱hereeri̱ho, hooho bi̱nyoni̱ bi̱bi̱mbi̱ra bizonza byabyo nibyegonzeramwo. ");
INSERT INTO rub_vpl VALUES ("PS104_13","020_104_13","PSA","104","13","13","Osi̱ndi̱ka meezi̱ kuruga mwiguru, nsi nigicuta byana bya mulimo gwamu. ");
INSERT INTO rub_vpl VALUES ("PS104_14","020_104_14","PSA","104","14","14","Ohandya isubi lya bisolo kudya, na bilimwa bya bantu kuruga mwitehe. ");
INSERT INTO rub_vpl VALUES ("PS104_15","020_104_15","PSA","104","15","15","Hooho batungira mwenge gwa mi̱zabbi̱bbu̱ gubaha kusemererwa, hamwei̱ na maku̱ta gaaku̱nyi̱ri̱i̱rya b̯u̱syo b̯wab̯u, na bidyo bikubaha maani. ");
INSERT INTO rub_vpl VALUES ("PS104_16","020_104_16","PSA","104","16","16","Misaali mya Mukama mitunga ndagali̱ ginene, mi̱vu̱le mya Lebbanooni̱ mi̱yeeli̱mi̱i̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS104_17","020_104_17","PSA","104","17","17","Mu misaali mi̱myo, bi̱nyoni̱ hooho bi̱bi̱mbi̱ra bizonza, manunda nigatungiramwo b̯ulaalu b̯wago. ");
INSERT INTO rub_vpl VALUES ("PS104_18","020_104_18","PSA","104","18","18","Mparaaki ziicala mu nsahu zilei, caali hali lubbaali hooho nsengi̱ zeebi̱sa. ");
INSERT INTO rub_vpl VALUES ("PS104_19","020_104_19","PSA","104","19","19","B̯wateeri̱hoona mweri̱ aleke gwahu̱kani̱enge kasu̱mi̱, lyoba lyegenge magwere gaalyo. ");
INSERT INTO rub_vpl VALUES ("PS104_20","020_104_20","PSA","104","20","20","Oleetaho nti̱ti̱, b̯wi̱re b̯wei̱jolo, bisolo byensei̱ bya mu kisaka nibihulukayo. ");
INSERT INTO rub_vpl VALUES ("PS104_21","020_104_21","PSA","104","21","21","Ntali zihuruguma nizitoolya zi̱kyagu̱mi̱sya, aleke Ruhanga azi̱di̱i̱syenge nka b̯uli kiro. ");
INSERT INTO rub_vpl VALUES ("PS104_22","020_104_22","PSA","104","22","22","Lyoba b̯ulihuluka, zigyenda nizilaala mu b̯wingira b̯wazo. ");
INSERT INTO rub_vpl VALUES ("PS104_23","020_104_23","PSA","104","23","23","Kasi bantu nibabyoka nibagyenda kukora milimo myab̯u, bakora ku̱doosya joojolo. ");
INSERT INTO rub_vpl VALUES ("PS104_24","020_104_24","PSA","104","24","24","Mukama, byokoori̱ kabinene! Byensei̱ waabi̱koori̱ mu magezi̱ gaamu. Nsi gyensei̱ gi̱i̱zwi̱ri̱ bihangwa byamu. ");
INSERT INTO rub_vpl VALUES ("PS104_25","020_104_25","PSA","104","25","25","Haloho itaka likooto kandi ligali, cali bihangwa bitakubalwa biicala, bikooto na bi̱dooli̱ ");
INSERT INTO rub_vpl VALUES ("PS104_26","020_104_26","PSA","104","26","26","Itaka li̱lyo, hooho maati̱ garabira, na bihiri bi̱waahangi̱ri̱ cali bi̱zeenyera. ");
INSERT INTO rub_vpl VALUES ("PS104_27","020_104_27","PSA","104","27","27","Bi̱byo byensei̱ byekwata weewe, obi̱di̱isya mu b̯wi̱re b̯wonyi̱ni̱. ");
INSERT INTO rub_vpl VALUES ("PS104_28","020_104_28","PSA","104","28","28","B̯wobiha bidyo, nibibisorooza, obiha byakudya nibidya nibiicutira ki̱mwei̱. ");
INSERT INTO rub_vpl VALUES ("PS104_29","020_104_29","PSA","104","29","29","Woobiima, nibituntura, woobi̱toolaho rwoya, nibikwa, bi̱bbola nibiira icuucu. ");
INSERT INTO rub_vpl VALUES ("PS104_30","020_104_30","PSA","104","30","30","Waabi̱hangi̱ri̱ na mwozo waamu, waabiha kwomeera byei̱zu̱lya nsi. ");
INSERT INTO rub_vpl VALUES ("PS104_31","020_104_31","PSA","104","31","31","Leke ki̱ti̱i̱ni̱sa kya Mukama ki̱i̱calengeho biro byensei̱, Aleke asemereerwe mu milimo myamwe. ");
INSERT INTO rub_vpl VALUES ("PS104_32","020_104_32","PSA","104","32","32","Alingiira nsi ni̱gi̱tengeeta, akwata ha nsahu nizitirimuka na mwi̱ca! ");
INSERT INTO rub_vpl VALUES ("PS104_33","020_104_33","PSA","104","33","33","Ndi̱hi̱i̱mi̱ra Mukama biro bya b̯womi b̯wange b̯wensei̱. Ndi̱hi̱i̱ma nimpariiza Ruhanga wange nincaali ku nsi. ");
INSERT INTO rub_vpl VALUES ("PS104_34","020_104_34","PSA","104","34","34","Leka biteekerezu byange byense bimusemezenge kubba nyenyumiriizira muli Mukama ");
INSERT INTO rub_vpl VALUES ("PS104_35","020_104_35","PSA","104","35","35","Leka babiibi bamalikireho ki̱mwei̱ mu nsi, nkori̱ za bibii zitalizookeraho ki̱mwei̱. Ai̱ mutima gwange, haariiza Mukama! Haari̱i̱ze Mukama! ");
INSERT INTO rub_vpl VALUES ("PS105_1","020_105_1","PSA","105","1","1","Mu̱si̱i̱me Mukama mukunge ibara lyamwe, mwolokye bantu bintu byakora! ");
INSERT INTO rub_vpl VALUES ("PS105_2","020_105_2","PSA","105","2","2","Mu̱hi̱i̱mi̱re nimumuhariiza, mubaze ha byamahanu byamwe byensei̱! ");
INSERT INTO rub_vpl VALUES ("PS105_3","020_105_3","PSA","105","3","3","Mu̱semererwe hab̯wa ibara lyamwe li̱syanu̱, nywe baramya Mukama mwegonze! ");
INSERT INTO rub_vpl VALUES ("PS105_4","020_105_4","PSA","105","4","4","Mu̱toolye Mukama hamwei̱ na maani gaamwe, mu̱mwekwate b̯utalekeera. ");
INSERT INTO rub_vpl VALUES ("PS105_5","020_105_5","PSA","105","5","5","Mwi̱calenge ni̱mwi̱zu̱ka byamahanu byakora, na ncwa gya misangu myamwe. ");
INSERT INTO rub_vpl VALUES ("PS105_6","020_105_6","PSA","105","6","6","Beizukulu bʼI̱bbu̱rahi̱mu̱ muheereza waamwe, batabani̱ ba Yakobbo gi̱yekoomeeri̱, mwi̱zu̱kenge bya mahanu byakora! ");
INSERT INTO rub_vpl VALUES ("PS105_7","020_105_7","PSA","105","7","7","Yooyo Mukama Ruhanga weetu̱, asalira nsi gyensei̱ misangu. ");
INSERT INTO rub_vpl VALUES ("PS105_8","020_105_8","PSA","105","8","8","Ei̱zu̱ka ndagaanu gyamwe gya biro na biro, na miragu myamwe ku̱doosya mi̱hi̱hi̱ ru̱ku̱mi̱. ");
INSERT INTO rub_vpl VALUES ("PS105_9","020_105_9","PSA","105","9","9","Ndagaanu gi̱yaakoori̱ nʼI̱bbu̱rahi̱mu̱, yaarahi̱i̱ri̱ muragu gwamwe nʼI̱saka ");
INSERT INTO rub_vpl VALUES ("PS105_10","020_105_10","PSA","105","10","10","Ndagaanu gi̱gyo, Ruhanga yaagi̱kwati̱i̱rye Yakobbo, yaagiha Bei̱saleeri̱ kumalaho biro byensei̱, ");
INSERT INTO rub_vpl VALUES ("PS105_11","020_105_11","PSA","105","11","11","yaakoba yati, “Ndikuha nsi gya Kanaani̱, gubbe mugab̯u gwa b̯ugwetwa b̯wamu.” ");
INSERT INTO rub_vpl VALUES ("PS105_12","020_105_12","PSA","105","12","12","B̯atakabbeeri̱ kukanya, baali bagenyi̱ mu nsi gya Kanaani̱. ");
INSERT INTO rub_vpl VALUES ("PS105_13","020_105_13","PSA","105","13","13","Nibazengeeranga b̯uli ihanga nibaruga mu b̯ukama b̯u̱mwei̱ nibagyenda mu bantu bandi. ");
INSERT INTO rub_vpl VALUES ("PS105_14","020_105_14","PSA","105","14","14","Bei̱tu̱ Ruhanga atakeeki̱ri̱zenge muntu noomwei̱ ku̱bawonawonesya, hab̯wab̯u, yaacoomeerengi bakama ");
INSERT INTO rub_vpl VALUES ("PS105_15","020_105_15","PSA","105","15","15","naakoba yati, “Mu̱takwatahoona batongoole bange, baragu̱ri̱ bange mutabakora kubii!” ");
INSERT INTO rub_vpl VALUES ("PS105_16","020_105_16","PSA","105","16","16","B̯uyaagu̱mi̱ri̱ho nzala mu nsi, yaakeeyahoona bidyo byab̯u byensei̱, ");
INSERT INTO rub_vpl VALUES ("PS105_17","020_105_17","PSA","105","17","17","yaatu̱mi̱ri̱ muntu mu̱mei̱so gaab̯u, mu̱nyaku̱tu̱ndwa nka mwiru, ibara lyamwe Yozefu̱. ");
INSERT INTO rub_vpl VALUES ("PS105_18","020_105_18","PSA","105","18","18","Baamu̱bbohi̱ri̱ njegere mu magulu, baamuteera kyoma mwi̱coti̱. ");
INSERT INTO rub_vpl VALUES ("PS105_19","020_105_19","PSA","105","19","19","Yozefu̱ yei̱ceeri̱ mu nkomo, Mukama yaamu̱pi̱ma ku̱doosereerya bigambu bi̱yaabazi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS105_20","020_105_20","PSA","105","20","20","Nahaahwo, hooho Mukama wa Mi̱si̱ri̱, yaaragi̱i̱ri̱ bamu̱teesye, kasi Faraaho mulema ihanga li̱lyo yaamwahuura. ");
INSERT INTO rub_vpl VALUES ("PS105_21","020_105_21","PSA","105","21","21","Mukama yaamu̱handi̱i̱rye, yaamukwatya b̯ujunanizib̯wa b̯wensei̱ mu kikaali, ");
INSERT INTO rub_vpl VALUES ("PS105_22","020_105_22","PSA","105","22","22","kuragira bayolo bensei̱, na kwegesya balemi̱ byamagezi̱. ");
INSERT INTO rub_vpl VALUES ("PS105_23","020_105_23","PSA","105","23","23","Hei̱nyu̱ma, I̱saleeri̱ gyagyendi̱ri̱ Mi̱si̱ri̱, Yakobbo yeicala mu nsi gya Haamu nka munyamahanga. ");
INSERT INTO rub_vpl VALUES ("PS105_24","020_105_24","PSA","105","24","24","Mukama yaaheeri̱ bantu baamwe kukanya, yaabaha rutege kukiraho banyanzigwa baab̯u. ");
INSERT INTO rub_vpl VALUES ("PS105_25","020_105_25","PSA","105","25","25","Yaaheeri̱ Banyami̱si̱ri̱ kubanoba na kudyamwo rukwe baheereza baamwe. ");
INSERT INTO rub_vpl VALUES ("PS105_26","020_105_26","PSA","105","26","26","Ruhanga yaatu̱mi̱ri̱ Mu̱sa muheereza waamwe, hamwei̱ nʼAlooni̱ gi̱yaakomirimwo. ");
INSERT INTO rub_vpl VALUES ("PS105_27","020_105_27","PSA","105","27","27","Baakoori̱ b̯uboneru b̯wa byamahanu b̯wamwe mu Banyami̱si̱ri̱, na bikuhuniriza mu nsi gya Haamu. ");
INSERT INTO rub_vpl VALUES ("PS105_28","020_105_28","PSA","105","28","28","Ruhanga yaabasi̱ndi̱ki̱i̱ri̱ nti̱ti̱ kandi nsi gyeragura, kubba baajeemeeri̱ biragiro byamwe baalemwa ku̱teesya bantu baamwe kugyenda. ");
INSERT INTO rub_vpl VALUES ("PS105_29","020_105_29","PSA","105","29","29","Meezi̱ gaab̯u yaagafoori̱ri̱ ibbanga, nsu̱ zaab̯u zensei̱ zaakwa. ");
INSERT INTO rub_vpl VALUES ("PS105_30","020_105_30","PSA","105","30","30","Masonsooni̱a gei̱zwi̱ri̱ b̯uli kicweka, na mu ki̱si̱i̱ka kya ntabbu gya mukama de gaali̱yo. ");
INSERT INTO rub_vpl VALUES ("PS105_31","020_105_31","PSA","105","31","31","Ruhanga yaaragi̱i̱ri̱ bi̱du̱ndu̱li̱ bya nsohera, na nsinya byei̱zu̱lya nsi gyab̯u gyensei̱. ");
INSERT INTO rub_vpl VALUES ("PS105_32","020_105_32","PSA","105","32","32","Mu kiikaru kya ndagali̱, baatu̱ngi̱ri̱ ndagali̱ gya mahi̱ga, b̯u̱serya hamwei̱ na nkuba mu nsi gyensei̱. ");
INSERT INTO rub_vpl VALUES ("PS105_33","020_105_33","PSA","105","33","33","Yaahwerekereerye mi̱zabbi̱bbu̱ na mi̱ti̱i̱ni̱ myab̯u, yaacwacwana misaali mya nsi gyab̯u myensei̱. ");
INSERT INTO rub_vpl VALUES ("PS105_34","020_105_34","PSA","105","34","34","Yaaragi̱i̱ri̱ nzi̱ge zei̱za, mu b̯unene zitakubalwa. ");
INSERT INTO rub_vpl VALUES ("PS105_35","020_105_35","PSA","105","35","35","Zaahwerekereerye bi̱merwa bya munsi gyab̯u gyensei̱, b̯uli kilimwa kya mwitehe lyab̯u kyadiib̯wa. ");
INSERT INTO rub_vpl VALUES ("PS105_36","020_105_36","PSA","105","36","36","Kasi yei̱ta b̯uli mu̱zi̱gai̱jo mu gi̱gyo nsi, na b̯uli kilimwa kyensei̱ kikubanza kuruga mu̱ndi̱mi̱ro zaab̯u. ");
INSERT INTO rub_vpl VALUES ("PS105_37","020_105_37","PSA","105","37","37","Ruhanga b̯u̱yaatoori̱ Bei̱saleeri̱ kuruga Mi̱si̱ri̱, baatwalageeni̱ feeza na zaabbu, atakabbeho noomwei̱ mu bo munyakusiitaara. ");
INSERT INTO rub_vpl VALUES ("PS105_38","020_105_38","PSA","105","38","38","Banyami̱si̱ri̱ baasemereerwe hab̯wa bei̱saaleeri̱ kubarugaho, kubba baati̱nwengi̱ hoi̱. ");
INSERT INTO rub_vpl VALUES ("PS105_39","020_105_39","PSA","105","39","39","Yaababbu̱mbi̱ri̱i̱ri̱ na bikaka, yaabateraho mworo gubamulukirenge mu b̯wi̱re b̯wei̱jolo. ");
INSERT INTO rub_vpl VALUES ("PS105_40","020_105_40","PSA","105","40","40","Baasabi̱ri̱ bidyo yaabaha maanu, yaabeecuti̱i̱rye migaati kuruga mwiguru. ");
INSERT INTO rub_vpl VALUES ("PS105_41","020_105_41","PSA","105","41","41","Ruhanga yaati̱i̱rye lubbaali meezi̱ gaalwa, gaaheta nka mugira mu nsi gyomu. ");
INSERT INTO rub_vpl VALUES ("PS105_42","020_105_42","PSA","105","42","42","Hab̯wakubba yei̱zu̱ki̱ri̱ muragu gwamwe gu̱syanu̱, gu̱yaaragani̱si̱i̱rye muheereza waamwe I̱bbu̱rahi̱mu̱. ");
INSERT INTO rub_vpl VALUES ("PS105_43","020_105_43","PSA","105","43","43","Baasemereerwe hoi̱ Ruhanga b̯u̱yaabatoori̱ mu nsi gya Mi̱si̱ri̱, baali̱batengi̱ nibatokera hakyendi̱. ");
INSERT INTO rub_vpl VALUES ("PS105_44","020_105_44","PSA","105","44","44","Mukama yaabaheeri̱ nsi, na b̯uli ki̱mwei̱ kya banyamahanga baali bakolereeri̱, ");
INSERT INTO rub_vpl VALUES ("PS105_45","020_105_45","PSA","105","45","45","aleke bakwate mateeka gaamwe kandi bahondere biragiro byamwe. Haari̱i̱ze Mukama! ");
INSERT INTO rub_vpl VALUES ("PS106_1","020_106_1","PSA","106","1","1","Mu̱haari̱i̱ze Mukama! Mu̱si̱i̱me Mukama, kubba abba murungi, kubba ngonzi zaamwe zinene za biro na biro! ");
INSERT INTO rub_vpl VALUES ("PS106_2","020_106_2","PSA","106","2","2","Tihalohoona akusobora kumuhaariiza kikumala, ku̱si̱gi̱ki̱ra ha bintu byamaani byakora. ");
INSERT INTO rub_vpl VALUES ("PS106_3","020_106_3","PSA","106","3","3","Bali na mu̱gi̱sa bab̯wo balibatira mu b̯u̱terekereru̱, nibakora birungi b̯wi̱re b̯wensei̱. ");
INSERT INTO rub_vpl VALUES ("PS106_4","020_106_4","PSA","106","4","4","Ai̱ Mukama, onzi̱zu̱ke waakakwatirwanga mbabazi̱ bantu baamu, mu b̯wi̱re b̯wa kubajuna, wei̱zanga nonjuna, ");
INSERT INTO rub_vpl VALUES ("PS106_5","020_106_5","PSA","106","5","5","aleke nsobore kuwonaho bakome baamu nibakutunga mi̱gi̱sa, kwokwo njaguze mu kusemererwa kweihanga lyamu, kandi nkuhe ki̱ti̱i̱ni̱sa hamwei̱ na bantu baamu. ");
INSERT INTO rub_vpl VALUES ("PS106_6","020_106_6","PSA","106","6","6","Twakoori̱ kibii nka bahaaha beetu̱, twakora bintu bitakusemeera. ");
INSERT INTO rub_vpl VALUES ("PS106_7","020_106_7","PSA","106","7","7","B̯ubaali Mi̱si̱ri̱, batakateho mutima, ha byamahanu bi̱wabakoleeri̱, rundi kwi̱zu̱ka ha b̯unene b̯wa ngonzi zaamu zinene, bei̱tu̱ baajeemera ha mutanda gwa Itaka Lyengu̱. ");
INSERT INTO rub_vpl VALUES ("PS106_8","020_106_8","PSA","106","8","8","Ki̱kyo naab̯ukyabberi̱ho, yaabaju̱ni̱ri̱ hab̯wa mananu gei̱bara lyamwe, aleke bantu beege b̯u̱sobozi̱ b̯wa maani gaamwe. ");
INSERT INTO rub_vpl VALUES ("PS106_9","020_106_9","PSA","106","9","9","Yaacoomeeri̱ Itaka Lyengu̱ lyebagaania, yaabambu̱la ndi̱ha nka bakulibatira heitehe lyomu. ");
INSERT INTO rub_vpl VALUES ("PS106_10","020_106_10","PSA","106","10","10","Kwokwo yatyo yaabaju̱ni̱ri̱ kuruga mu bantu banyakubba babanobi̱ri̱, yaabacungura kuruga mu banyanzigwa baab̯u. ");
INSERT INTO rub_vpl VALUES ("PS106_11","020_106_11","PSA","106","11","11","Meezi̱ gaabbu̱u̱ti̱i̱rye banyanzigwa baab̯u, hatakabbeho noomwei̱ munyakusigalaho. ");
INSERT INTO rub_vpl VALUES ("PS106_12","020_106_12","PSA","106","12","12","Hei̱nyu̱ma mwomwo bei̱ki̱ri̱i̱ze miragu myamwe, kasi baahi̱i̱ma nibamuhaariiza. ");
INSERT INTO rub_vpl VALUES ("PS106_13","020_106_13","PSA","106","13","13","Bei̱tu̱ beebereeri̱ b̯wangu b̯wangu bintu bi̱yabakoleeri̱, batakamu̱li̱ndi̱i̱re abahab̯ure. ");
INSERT INTO rub_vpl VALUES ("PS106_14","020_106_14","PSA","106","14","14","B̯ubaali mwirungu beegombi̱ri̱ bidyo bi̱baadyengi̱ mu nsi gya Mi̱si̱ri̱, baamali̱ri̱i̱ri̱ nibakulenga Ruhanga. ");
INSERT INTO rub_vpl VALUES ("PS106_15","020_106_15","PSA","106","15","15","Yaabaheeri̱ b̯uli kyensei̱ ki̱bendyengi̱, bei̱tu̱ hei̱nyu̱ma yaabahwerekereerya na b̯u̱seeri̱ b̯wa kabii. ");
INSERT INTO rub_vpl VALUES ("PS106_16","020_106_16","PSA","106","16","16","B̯uli muntu mwihamba, yaakwati̱i̱rwe i̱hali̱ hab̯wa Mu̱sa, hamwei̱ nʼAlooni̱ mutongoole wa Mukama. ");
INSERT INTO rub_vpl VALUES ("PS106_17","020_106_17","PSA","106","17","17","Nsi gyeku̱ngu̱u̱ri̱ gyamera Dasani, kandi gyabbu̱tu̱ki̱ra kitebe kya Abbi̱raamu̱. ");
INSERT INTO rub_vpl VALUES ("PS106_18","020_106_18","PSA","106","18","18","Mworo gwabbu̱tu̱ki̱ri̱ mu ki̱kyo kitebe, gwahwerekereerya bantu babiibi benseenya. ");
INSERT INTO rub_vpl VALUES ("PS106_19","020_106_19","PSA","106","19","19","Ha lusahu Holebbu̱ beekoleeri̱ ki̱si̱sani̱ kya nte, baaramya ki̱si̱sani̱ kya kyoma. ");
INSERT INTO rub_vpl VALUES ("PS106_20","020_106_20","PSA","106","20","20","Baahi̱ngi̱si̱i̱rye ki̱ti̱i̱ni̱sa kya Ruhanga, baaki̱ha nte gidya isubi. ");
INSERT INTO rub_vpl VALUES ("PS106_21","020_106_21","PSA","106","21","21","Beebeera Ruhanga Mu̱ju̱ni̱ waab̯u, munyakubakoora byamaani munsi gya Mi̱si̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS106_22","020_106_22","PSA","106","22","22","Bintu byamahanu mu nsi gya Haamu, kandi bikuhuniriza hʼItaka Lyengu̱. ");
INSERT INTO rub_vpl VALUES ("PS106_23","020_106_23","PSA","106","23","23","Yaali akobi̱ri̱ abahwerekereerye, kabbe ataali Mu̱sa mutongoole waamwe kubatonganeera, ku̱holya ki̱ni̱ga kyamwe kyakubahwerekereerya. ");
INSERT INTO rub_vpl VALUES ("PS106_24","020_106_24","PSA","106","24","24","Mwomwo baagaya kwingira mu nsi gyakusemererwa, baalemwa kwikiriza miragu myamwe. ");
INSERT INTO rub_vpl VALUES ("PS106_25","020_106_25","PSA","106","25","25","Beenghu̱ru̱nghu̱u̱ti̱i̱rye mu heema zaab̯u, bataketegeerye Mukama kyakubaweera. ");
INSERT INTO rub_vpl VALUES ("PS106_26","020_106_26","PSA","106","26","26","Nahab̯waki̱kyo yaabyokeerye mikono myamwe naabarahirira nti ali̱bahwerekereerya mwirungu, ");
INSERT INTO rub_vpl VALUES ("PS106_27","020_106_27","PSA","106","27","27","Kandi beizukulu baab̯u bakwere mu mahanga, basasaane mu nsi gyensei̱. ");
INSERT INTO rub_vpl VALUES ("PS106_28","020_106_28","PSA","106","28","28","Bantu beekonyi̱ri̱ mu kuhaariiza Bbaali mu kicweka kya Peeyoori̱, baadi̱i̱ri̱ bidyo bi̱bahongerengi̱ baku̱u̱. ");
INSERT INTO rub_vpl VALUES ("PS106_29","020_106_29","PSA","106","29","29","Baakwati̱si̱i̱rye Mukama ki̱ni̱ga hab̯wa bikorwa byab̯u, kasi yaabafubira na b̯u̱seeri̱ b̯wa kabii. ");
INSERT INTO rub_vpl VALUES ("PS106_30","020_106_30","PSA","106","30","30","Fenehansi̱ yaabyoki̱ri̱ yaafubira nkori̱ za bibii, kasi b̯u̱seeri̱ b̯wahona. ");
INSERT INTO rub_vpl VALUES ("PS106_31","020_106_31","PSA","106","31","31","Kiki kyamu̱leteeri̱ kweteb̯wanga munanu, mu b̯uli mu̱hi̱hi̱ gwensei̱. ");
INSERT INTO rub_vpl VALUES ("PS106_32","020_106_32","PSA","106","32","32","Ha meezi̱ ga Meri̱bba bantu baasali̱i̱ze Mukama kabii kei̱zi̱ra Mu̱sa hab̯wab̯u, ");
INSERT INTO rub_vpl VALUES ("PS106_33","020_106_33","PSA","106","33","33","hab̯wakubba baasali̱i̱ze mwozo gwamwe, yaakwatwa ki̱ni̱ga yaabaza bigambu bibiibi. ");
INSERT INTO rub_vpl VALUES ("PS106_34","020_106_34","PSA","106","34","34","Batakazi̱kye bantu, nka Mukama kuyaali abaragi̱i̱ri̱ bakore, ");
INSERT INTO rub_vpl VALUES ("PS106_35","020_106_35","PSA","106","35","35","bei̱tu̱ beekweti na banyamahanga, baahondera mirwa myensei̱ minyakukorwangayo. ");
INSERT INTO rub_vpl VALUES ("PS106_36","020_106_36","PSA","106","36","36","Baaheeri̱i̱ze mbandwa ki̱nyaku̱bei̱ri̱ra mutegu gwab̯u. ");
INSERT INTO rub_vpl VALUES ("PS106_37","020_106_37","PSA","106","37","37","Bahara na batabani̱ baab̯u, baabahongeeri̱ mizumu. ");
INSERT INTO rub_vpl VALUES ("PS106_38","020_106_38","PSA","106","38","38","Baabbwomi̱ri̱ ibbanga litalohoona musangu, ibbanga lya baana baab̯u, libaahongerengi mbandwa za Kanaani̱, lyahenera nsi gyenseenya. ");
INSERT INTO rub_vpl VALUES ("PS106_39","020_106_39","PSA","106","39","39","Beeheneeri̱ benkei̱ hab̯wa bikorwa byab̯u bibiibi, naab̯utesigwa kwa bikorwa byab̯u. ");
INSERT INTO rub_vpl VALUES ("PS106_40","020_106_40","PSA","106","40","40","Ki̱ni̱ga kya Mukama kyakira hali bantu baamwe, baamutamira ki̱mwei̱. ");
INSERT INTO rub_vpl VALUES ("PS106_41","020_106_41","PSA","106","41","41","Yaabaheeri̱yo hali banyamahanga, aleke bafugwe banyanzigwa baab̯u. ");
INSERT INTO rub_vpl VALUES ("PS106_42","020_106_42","PSA","106","42","42","Banyanzigwa baab̯u baabaki̱i̱ri rutege, bei̱ra nka beiru mu mei̱so gaab̯u. ");
INSERT INTO rub_vpl VALUES ("PS106_43","020_106_43","PSA","106","43","43","Mirundi minene yaabaju̱nengi̱, bei̱tu̱ bo baamali̱ri̱i̱ri̱ mu̱b̯u̱jeemu̱ hab̯wa bigyendeerwa byab̯u, bibii byab̯u byabeeri̱ri̱i̱rya hansi. ");
INSERT INTO rub_vpl VALUES ("PS106_44","020_106_44","PSA","106","44","44","Bei̱tu̱ nab̯wo Ruhanga yaaweeni̱ b̯ujune b̯wab̯u, yeegwa kusaba kwab̯u. ");
INSERT INTO rub_vpl VALUES ("PS106_45","020_106_45","PSA","106","45","45","Hab̯wab̯u yei̱zu̱ki̱ri̱ ndagaanu gyamwe, hab̯wa ngonzi zaamwe zinene yeezi̱ramwo. ");
INSERT INTO rub_vpl VALUES ("PS106_46","020_106_46","PSA","106","46","46","Yaaheeri̱ bensei̱ banyakubawonawonesya kwi̱ra kubasaasira. ");
INSERT INTO rub_vpl VALUES ("PS106_47","020_106_47","PSA","106","47","47","Ai̱ Mukama Ruhanga weetu̱ tu̱ju̱ne, kandi otucooke kuruga mu mahanga, tusobore ku̱si̱i̱ma ibara lyamu li̱syanu̱, kandi tujaguze nitukuhaariiza. ");
INSERT INTO rub_vpl VALUES ("PS106_48","020_106_48","PSA","106","48","48","Ahaariizwe Mukama, Ruhanga wʼI̱saleeri̱ biro na biro. B̯uli muntu akobe, “Ami̱i̱na!” ");
INSERT INTO rub_vpl VALUES ("PS107_1","020_107_1","PSA","107","1","1","Mu̱si̱i̱me Mukama hab̯wakubba murungi, ngonzi zaamwe zinene biro byenseenya. ");
INSERT INTO rub_vpl VALUES ("PS107_2","020_107_2","PSA","107","2","2","Leka ba Mukama yaacu̱ngu̱u̱ri̱, kwokwo bakobe yatyo, bayaatoori̱ kuruga mu mikono bya banyanzigwa. ");
INSERT INTO rub_vpl VALUES ("PS107_3","020_107_3","PSA","107","3","3","Yaabasorozi̱ri̱ kuruga mu mahanga ga, b̯uhulukalyoba na b̯ugwalyoba, kuruga matemba na masi̱ri̱mu̱ka. ");
INSERT INTO rub_vpl VALUES ("PS107_4","020_107_4","PSA","107","4","4","Bandi baahaabi̱i̱ri̱ mwihamba, batakawone muhanda gu̱ku̱badoosya mu rub̯uga lu̱bei̱caliramwo. ");
INSERT INTO rub_vpl VALUES ("PS107_5","020_107_5","PSA","107","5","5","Baadi̱bi̱i̱rwe nzala baakwatwa nyoota, mitima myab̯u myaroha. ");
INSERT INTO rub_vpl VALUES ("PS107_6","020_107_6","PSA","107","6","6","Mwomwo baakunga Mukama, yaabajuna kuruga mu b̯ujune b̯wab̯u, ");
INSERT INTO rub_vpl VALUES ("PS107_7","020_107_7","PSA","107","7","7","yaabeebemberi̱ yaabarabya mu muhanda gu̱terekereru̱, ku̱doosya b̯u̱baakadoori̱ mu rub̯uga lwa kwicalamwo. ");
INSERT INTO rub_vpl VALUES ("PS107_8","020_107_8","PSA","107","8","8","Leka basi̱i̱me Mukama hab̯wa ngonzi zaamwe zinene, na milimo myamwe mya mahanu mu bantu! ");
INSERT INTO rub_vpl VALUES ("PS107_9","020_107_9","PSA","107","9","9","Hab̯wakubba ateekaani̱a yogwo wa mwozo gwa nyoota, kandi nei̱cu̱tya banyanzala. ");
INSERT INTO rub_vpl VALUES ("PS107_10","020_107_10","PSA","107","10","10","Bandi bei̱ceeri̱ mu nti̱ti̱ na mu̱mu̱tu̱tu̱lu̱ gwa lu̱ku̱u̱, babboheerwe mu kumigirizib̯wa kwa mpi̱ngo. ");
INSERT INTO rub_vpl VALUES ("PS107_11","020_107_11","PSA","107","11","11","Hab̯wakubba baalingi bajeemeeri̱ bigambu bya Ruhanga, baasuula kuhanuura kwa yogwo Waahakyendi̱ Hoi̱. ");
INSERT INTO rub_vpl VALUES ("PS107_12","020_107_12","PSA","107","12","12","Yaab̯undeize mitima myab̯u kuraba mu milimo mya kukora na lu̱tege, baagwi̱ri̱ hansi batalina mu̱baju̱ni̱i̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS107_13","020_107_13","PSA","107","13","13","Mwomwo baakunga Mukama, yaabajuna kuruga mu b̯ujune b̯wab̯u. ");
INSERT INTO rub_vpl VALUES ("PS107_14","020_107_14","PSA","107","14","14","Yaabatoori̱ mu njegere zinyakubba zi̱babbohi̱ri̱ mikono na magulu, yaabatoola mu nkomo gya nti̱ti̱. ");
INSERT INTO rub_vpl VALUES ("PS107_15","020_107_15","PSA","107","15","15","Leka basi̱i̱me Mukama hab̯wa ngonzi zaamwe zinene, na milimo myamwe mya mahanu mu bantu! ");
INSERT INTO rub_vpl VALUES ("PS107_16","020_107_16","PSA","107","16","16","Hab̯wakubba acwacwana milyangu mya byoma, mi̱taahi̱mbwa naami̱temateemamwo kabiri. ");
INSERT INTO rub_vpl VALUES ("PS107_17","020_107_17","PSA","107","17","17","Bandi baadomi̱ri̱ hab̯wa b̯u̱jeemu̱ b̯wab̯u, baawonawona hab̯wa bibii byab̯u. ");
INSERT INTO rub_vpl VALUES ("PS107_18","020_107_18","PSA","107","18","18","Baanu̱gi̱ri̱ b̯uli kidyo, baadwa heehi̱ ku̱kwa. ");
INSERT INTO rub_vpl VALUES ("PS107_19","020_107_19","PSA","107","19","19","Mwomwo baakunga Mukama, yaabajuna kuruga mu b̯ujune b̯wab̯u. ");
INSERT INTO rub_vpl VALUES ("PS107_20","020_107_20","PSA","107","20","20","Yaaragi̱i̱ri̱ kigambu kyamwe kyabahoni̱a, yaabacungura kuruga mu kuhwerekeera. ");
INSERT INTO rub_vpl VALUES ("PS107_21","020_107_21","PSA","107","21","21","Leka basi̱i̱me Mukama hab̯wa ngonzi zaamwe zinene, na milimo myamwe mya mahanu mu bantu! ");
INSERT INTO rub_vpl VALUES ("PS107_22","020_107_22","PSA","107","22","22","Leka bagabe kihongwa kya ku̱si̱i̱ma, nibaweeranga bantu bintu bya Ruhanga byakora kuraba mu kyembu kya kusemererwa. ");
INSERT INTO rub_vpl VALUES ("PS107_23","020_107_23","PSA","107","23","23","Bamwei̱ mu bo baagozi̱ri̱ maati̱ mwitaka, baakora bya b̯u̱su̱u̱b̯u̱zi̱ ha mataka gakooto. ");
INSERT INTO rub_vpl VALUES ("PS107_24","020_107_24","PSA","107","24","24","Baaweeni bikorwa bya maani ga Mukama, na milimo myamwe mya mahanu mu ndi̱ha. ");
INSERT INTO rub_vpl VALUES ("PS107_25","020_107_25","PSA","107","25","25","Hab̯wakubba yaaragi̱i̱ri̱ kihehu kyahunga, kyabyokya bijanga mwitaka. ");
INSERT INTO rub_vpl VALUES ("PS107_26","020_107_26","PSA","107","26","26","Maati̱ gabyokengi̱ hakyendi̱ mu mwanya, ni̱gei̱ra hansi, nahahwo hooho bagozi̱ baamali̱ki̱i̱rwemwona maani. ");
INSERT INTO rub_vpl VALUES ("PS107_27","020_107_27","PSA","107","27","27","Baakankeeni̱ baataratara nka batami̱i̱ru̱, magezi̱ gaabamali̱ki̱ri̱i̱ri̱ baalemwa kyakukora. ");
INSERT INTO rub_vpl VALUES ("PS107_28","020_107_28","PSA","107","28","28","Mwomwo baakunga Mukama, yaabajuna kuruga mu b̯ujune b̯wab̯u. ");
INSERT INTO rub_vpl VALUES ("PS107_29","020_107_29","PSA","107","29","29","Yeemereerye bbuukuulu, na bijanga byetekeera. ");
INSERT INTO rub_vpl VALUES ("PS107_30","020_107_30","PSA","107","30","30","Baasemereerwe itaka b̯u̱lyatekeeni̱, yaabadoosya cali bendyengi̱ kudwa. ");
INSERT INTO rub_vpl VALUES ("PS107_31","020_107_31","PSA","107","31","31","Leka basi̱i̱me Mukama hab̯wa ngonzi zaamwe zinene, na milimo myamwe mya mahanu mu bantu! ");
INSERT INTO rub_vpl VALUES ("PS107_32","020_107_32","PSA","107","32","32","Leka bamu̱ramye mu kitebe kya bantu. Kandi bamuhaariize mu i̱rombero lya bahandu̱. ");
INSERT INTO rub_vpl VALUES ("PS107_33","020_107_33","PSA","107","33","33","Mukama aragira migira nimyoma, misu naamyemereerya ku̱hetya meezi̱. ");
INSERT INTO rub_vpl VALUES ("PS107_34","020_107_34","PSA","107","34","34","Nsi gya mweru yaagi̱heeri̱ kubba muzu gwa kisura, hab̯wa b̯ubiibi b̯wa bantu munsi. ");
INSERT INTO rub_vpl VALUES ("PS107_35","020_107_35","PSA","107","35","35","Afoora nsi gyomu kyeju̱ngo, ndala ngiira misu mikuheta. ");
INSERT INTO rub_vpl VALUES ("PS107_36","020_107_36","PSA","107","36","36","Ku̱kwo hooho ei̱caalya banyanzala, ni̱beebi̱mbi̱ra rub̯uga lwa kwicalamwo. ");
INSERT INTO rub_vpl VALUES ("PS107_37","020_107_37","PSA","107","37","37","Ku̱kwo hooho balima misiri nibasimba mi̱zabbi̱bbu̱, nibibaha kukesa kurungi. ");
INSERT INTO rub_vpl VALUES ("PS107_38","020_107_38","PSA","107","38","38","Hab̯wa mi̱gi̱sa myamwe, yaakanyi̱si̱i̱rye lubyalu lwab̯u, magana ga nte zaab̯u geeyongera. ");
INSERT INTO rub_vpl VALUES ("PS107_39","020_107_39","PSA","107","39","39","Muhendu gwab̯u gwakeehi̱ri̱, maani gaabamali̱ki̱i̱ri̱ hab̯wa kuwonawona na kumigirizib̯wa kuruga mu banyanzigwa baab̯u. ");
INSERT INTO rub_vpl VALUES ("PS107_40","020_107_40","PSA","107","40","40","Mukama yaabonebonesyeerye bahandu̱ baab̯u, yaabaha kwandaara mu rwomere haatalingi na muhanda. ");
INSERT INTO rub_vpl VALUES ("PS107_41","020_107_41","PSA","107","41","41","Bei̱tu̱ abyokya banaku naabatoola kuruga mukuwonawona, maka gaab̯u ni̱gahanda nka magana ga ntaama. ");
INSERT INTO rub_vpl VALUES ("PS107_42","020_107_42","PSA","107","42","42","Barungi b̯u̱bawona ki̱kyo ni̱basemereerwa, Mi̱nwa mya babiibi bensei̱ ni̱myebbu̱mba. ");
INSERT INTO rub_vpl VALUES ("PS107_43","020_107_43","PSA","107","43","43","Bamagezi̱ bensei̱ balinakutaho mutima ha bibi bigambu, aleke bateekereza ha ngonzi za Mukama zinene. ");
INSERT INTO rub_vpl VALUES ("PS108_1","020_108_1","PSA","108","1","1","Kyembu. Zabbu̱li̱ gya Dau̱di̱. Ai̱ Ruhanga, mutima gwange guli gu̱si̱gi̱ku̱! Nku̱hi̱i̱ma byembu birungi bya kukuhaariiza na b̯womi b̯wange b̯wensei̱. ");
INSERT INTO rub_vpl VALUES ("PS108_2","020_108_2","PSA","108","2","2","Ai̱ ki̱dongo na ndi̱ngi̱di̱ mu̱byoke, nku̱si̱si̱mu̱ka na mambya! ");
INSERT INTO rub_vpl VALUES ("PS108_3","020_108_3","PSA","108","3","3","Ai̱ Mukama, nku̱ku̱si̱i̱ma mu bantu, nku̱ku̱hi̱i̱mi̱ra kukuhaariiza mu mahanga, ");
INSERT INTO rub_vpl VALUES ("PS108_4","020_108_4","PSA","108","4","4","kubba ngonzi zaamu zinene kukiraho neiguru, b̯wesigwa b̯wamu b̯udwa mpaka mu bikaka. ");
INSERT INTO rub_vpl VALUES ("PS108_5","020_108_5","PSA","108","5","5","Ai̱ Ruhanga, ohaariizwe hakyendi̱ weiguru! Leka ki̱ti̱i̱ni̱sa kyamu kibbe mu nsi gyensei̱. ");
INSERT INTO rub_vpl VALUES ("PS108_6","020_108_6","PSA","108","6","6","Cungura bawendya, obajune na mukono gwamu gwab̯udyo, kandi onzi̱remwo. ");
INSERT INTO rub_vpl VALUES ("PS108_7","020_108_7","PSA","108","7","7","Ruhanga arageeni̱ nali mu kiikaru kyamwe ki̱syanu̱, naakoba yati, “Mu kusemererwa kunene ndi̱bagaani̱amwo Sekemu̱, kandi ngabire bantu bange kihanga kya Su̱koosi̱. ");
INSERT INTO rub_vpl VALUES ("PS108_8","020_108_8","PSA","108","8","8","Gi̱ryadi̱, nsi gyange, Manaase de gyange, Efu̱rayi̱mu̱, kyoma kilinda mu̱twe gwange, Yu̱da, mubbeere gwa b̯ukama b̯wange. ");
INSERT INTO rub_vpl VALUES ("PS108_9","020_108_9","PSA","108","9","9","Mowaabbu gyogyo kalaaya gyange haanabi̱ra, Edomu̱ hooho nzi̱ca nkei̱to zange, mu Fi̱ri̱si̱ti̱ hooho nyeb̯uga hab̯wa b̯u̱si̱ngu̱zi̱.” ");
INSERT INTO rub_vpl VALUES ("PS108_10","020_108_10","PSA","108","10","10","Naani alintwala mu rub̯uga lunyamaani? Akanyebembera kugyenda mu Edomu̱? ");
INSERT INTO rub_vpl VALUES ("PS108_11","020_108_11","PSA","108","11","11","Ai̱ Mukama, mali̱ otu̱nu̱gi̱ri̱ kwahi? Kotakwebembera mahe geetu̱? ");
INSERT INTO rub_vpl VALUES ("PS108_12","020_108_12","PSA","108","12","12","Beiraba tu̱ju̱ne hali banyanzigwa beetu̱, kubba kujuna kwa bantu tikugasa! ");
INSERT INTO rub_vpl VALUES ("PS108_13","020_108_13","PSA","108","13","13","Ruhanga nka kwali ha rubaju lwetu̱ tu̱ku̱si̱ngu̱ra. Yooyo akuziginiira banyanzigwa beetu̱. ");
INSERT INTO rub_vpl VALUES ("PS109_1","020_109_1","PSA","109","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱, Zabbu̱li̱ gya Dau̱di̱. Ai̱ Ruhanga gimpaariiza, oteti̱keera, ");
INSERT INTO rub_vpl VALUES ("PS109_2","020_109_2","PSA","109","2","2","hab̯wakubba babiibi na bagobya bagadwi̱ri̱ mi̱nwa, bakumbazaho bigambu bya b̯u̱gobya. ");
INSERT INTO rub_vpl VALUES ("PS109_3","020_109_3","PSA","109","3","3","Banyeelogoleerye na bigambu bya nnobi̱. Baku̱ndwani̱sya ntali na ki̱mbakoori̱. ");
INSERT INTO rub_vpl VALUES ("PS109_4","020_109_4","PSA","109","4","4","B̯u̱mbolokya ngonzi, bo bamparana b̯u̱harani̱, gya mbasabira b̯u̱sabi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS109_5","020_109_5","PSA","109","5","5","Bansasula bibiibi hab̯wa b̯urungi b̯umbakoora, nnobi̱ gyogyo bansasula hab̯wa ngonzi zi̱mboolokya. ");
INSERT INTO rub_vpl VALUES ("PS109_6","020_109_6","PSA","109","6","6","Muteereho muntu mubiibi amugaane, kandi oragire munyanzigwa waamwe, amunyegeere. ");
INSERT INTO rub_vpl VALUES ("PS109_7","020_109_7","PSA","109","7","7","Musangu gwamu̱si̱nganga b̯ubalimunyegeera. Leka kusaba kwamwe kubalwe nka kibii. ");
INSERT INTO rub_vpl VALUES ("PS109_8","020_109_8","PSA","109","8","8","Leka biro byamwe bikeehe, mulimo gwamwe gutwalwe muntu wondi. ");
INSERT INTO rub_vpl VALUES ("PS109_9","020_109_9","PSA","109","9","9","Aleke baana baamwe zibbe nfu̱u̱zi̱, na mu̱kali̱ waamwe akabbe mu̱kaamu̱kwere! ");
INSERT INTO rub_vpl VALUES ("PS109_10","020_109_10","PSA","109","10","10","Baana baamwe bandaarenge ni̱basabi̱ri̱i̱rya, babingwe na mu makandi gaab̯u. ");
INSERT INTO rub_vpl VALUES ("PS109_11","020_109_11","PSA","109","11","11","Leka bakumutonga bamunyage b̯uli kyalinakyo, banyamahanga batwale b̯uli bi̱yakakoori̱. ");
INSERT INTO rub_vpl VALUES ("PS109_12","020_109_12","PSA","109","12","12","Hatabbaho noomwei̱ aku̱mwolekya mbabazi̱, rundi kufaho nfu̱u̱zi̱ zaamwe! ");
INSERT INTO rub_vpl VALUES ("PS109_13","020_109_13","PSA","109","13","13","Beizukulu baamwe bensei̱ bazi̱ke, aleke ibara lyamwe li̱tali̱i̱zu̱kwa hali mu̱hi̱hi̱ gu̱kwi̱raho. ");
INSERT INTO rub_vpl VALUES ("PS109_14","020_109_14","PSA","109","14","14","Leka Mukama ei̱zu̱ke kuhenera kwa bahaahaawe, kandi na kibii kya mmaawe kitaganyirwa. ");
INSERT INTO rub_vpl VALUES ("PS109_15","020_109_15","PSA","109","15","15","Leka Mukama ei̱calenge naabi̱zu̱ka b̯uli kiro, mwomwo abasusure haha ku nsi. ");
INSERT INTO rub_vpl VALUES ("PS109_16","020_109_16","PSA","109","16","16","Kubba yogwo muntu atakei̱zu̱ke kubba na mbabazi̱, bei̱tu̱ yaalwani̱si̱i̱rye banaku na bali mu b̯wetaagu, na bali na nganye mu mitima, yaabei̱ta. ");
INSERT INTO rub_vpl VALUES ("PS109_17","020_109_17","PSA","109","17","17","Yaakyenengi̱ bandi, leka nayo bi̱mwi̱ri̱re, Ataakendeeryenge bandi mi̱gi̱sa, leka nayo bimubbeere. ");
INSERT INTO rub_vpl VALUES ("PS109_18","020_109_18","PSA","109","18","18","Ti̱yeebeera kukyena nka mulwala ngoye, gu̱kamwi̱ngi̱re mu mubiri gwamwe nka meezi̱, nka maku̱ta mu maku̱ha gaamwe! ");
INSERT INTO rub_vpl VALUES ("PS109_19","020_109_19","PSA","109","19","19","Leka mikyenu mi̱mweli̱ngi̱ze nka ngoye, kandi nka musupi gu̱yebbohesya b̯uli kiro! ");
INSERT INTO rub_vpl VALUES ("PS109_20","020_109_20","PSA","109","20","20","Leka kibbe kifubiro kya banyanzigwa bange kuruga hali Mukama, hali bakumbazaho kubii ");
INSERT INTO rub_vpl VALUES ("PS109_21","020_109_21","PSA","109","21","21","Bei̱tu̱ we Mukama Ruhanga wange, ndwaniira hab̯wa ibara lyamu, hab̯wa b̯urungi b̯wa ngonzi zaamu zinene, oncungure. ");
INSERT INTO rub_vpl VALUES ("PS109_22","020_109_22","PSA","109","22","22","Hab̯wakubba ndi munaku kandi museege, nkwegwa mutima gwange gu̱hu̱u̱teeri̱. ");
INSERT INTO rub_vpl VALUES ("PS109_23","020_109_23","PSA","109","23","23","Nsyereeri̱ho nka mu̱tu̱ntu̱lu̱ gwa joojolo, banzahya b̯wahya nka nzi̱ge. ");
INSERT INTO rub_vpl VALUES ("PS109_24","020_109_24","PSA","109","24","24","Malu̱ gange gaaceki̱ri̱ hab̯wa kusaba na kusiiba, mbaju zi̱nyeregi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS109_25","020_109_25","PSA","109","25","25","Nzi̱ri̱ri̱ kyakusekwa hali banyanzigwa bange, b̯ubambonaho ni̱bazi̱ngi̱i̱zya mi̱twe. ");
INSERT INTO rub_vpl VALUES ("PS109_26","020_109_26","PSA","109","26","26","Ai̱ Mukama Ruhanga wange, onjune. Oncungure ku̱si̱gi̱ki̱ra ha ngonzi zaamu zinene. ");
INSERT INTO rub_vpl VALUES ("PS109_27","020_109_27","PSA","109","27","27","Ai̱ Mukama leka beege nti gugu guli mukono gwamu, gwogwo gu̱ki̱koori̱. ");
INSERT INTO rub_vpl VALUES ("PS109_28","020_109_28","PSA","109","28","28","Leka bankyene, bei̱tu̱ olimpa mu̱gi̱sa! B̯u̱bali̱ndu̱mba balisigala na muswaru, bei̱tu̱ gya muheereza waamu nsigale nsemereerwe! ");
INSERT INTO rub_vpl VALUES ("PS109_29","020_109_29","PSA","109","29","29","Leka banyanzigwa bange bakwatwe nsoni̱, babbu̱mbwe nsoni̱ nka ngoye zi̱balweri̱. ");
INSERT INTO rub_vpl VALUES ("PS109_30","020_109_30","PSA","109","30","30","Mu̱nwa gwange gu̱kwi̱za ku̱si̱i̱ma Mukama, na maani ganene, ndimuhaariiza mu lugologombo lwa bantu, ");
INSERT INTO rub_vpl VALUES ("PS109_31","020_109_31","PSA","109","31","31","kubba atongoneera munaku, naamujuna hali bakumucwera gwa ku̱kwa. ");
INSERT INTO rub_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","Zabbu̱li̱ gya Dau̱di̱. Mukama yaaweereeri̱ mukama wange yati, “Icaara ha mukono gwange gwab̯udyo, ku̱doosya b̯undifoora banyanzigwa baamu katebe ka magulu gaamu.” ");
INSERT INTO rub_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","Mukama aligalihya b̯u̱sobozi̱ b̯wamu kuruga mu Sayu̱u̱ni̱. Olema hakati̱ wa banyanzigwa baamu. ");
INSERT INTO rub_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","Ha kiro ki̱kyo oli̱lwani̱sya banyanzigwa baamu, bantu baamu baalyehayo bankei batahambi̱ri̱zi̱i̱b̯we basigazi baamu bali̱i̱za hali we ha nsahu zi̱syanu̱, nibakwisana lu̱me lwa mwakya karei. ");
INSERT INTO rub_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","Mukama yaarahi̱i̱ri̱ kandi talyezi̱zu̱kya ki̱yaarahi̱i̱ri̱ yati, “Oli mu̱laami̱ biro na biro wa mu kika kya Meleki̱zedeki̱.” ");
INSERT INTO rub_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","Mukama akuli ha mukono gwamu gwab̯udyo, alicwacwana bakama bensei̱ ha kiro kyamwe kya ki̱ni̱ga. ");
INSERT INTO rub_vpl VALUES ("PS110_6","020_110_6","PSA","110","6","6","Alicwera mahanga misangu nsi gyab̯u nagi̱zu̱u̱lyamwo mitumbi. Ali̱si̱ngu̱ra bakama bensei̱ ba mu nsi. ");
INSERT INTO rub_vpl VALUES ("PS110_7","020_110_7","PSA","110","7","7","Mukama b̯walibba mu muhanda, ali̱nywa meezi̱ ha mugira, kandi abyoke asi̱ngu̱re malemu na malemu. ");
INSERT INTO rub_vpl VALUES ("PS111_1","020_111_1","PSA","111","1","1","Haari̱i̱ze Mukama! Nkwi̱za kuhaariiza Mukama na mutima gwange gwensei̱, ndi̱si̱i̱ma Mukama, nindi hakati̱ wa barungi, mu kitebe kya bantu baamwe. ");
INSERT INTO rub_vpl VALUES ("PS111_2","020_111_2","PSA","111","2","2","Milimo mya Mukama mya maani! Bab̯wo bensei̱ bamisemereerwa, boobo bamyetegereza. ");
INSERT INTO rub_vpl VALUES ("PS111_3","020_111_3","PSA","111","3","3","Milimo myamwe mi̱zwi̱ri̱ b̯u̱handu̱ na ki̱ti̱i̱ni̱sa, mananu gaamwe geicalaho biro byensei̱. ");
INSERT INTO rub_vpl VALUES ("PS111_4","020_111_4","PSA","111","4","4","Milimo myamwe yaami̱foori̱ri̱ myakwizukwanga, Mukama wa mbabazi̱ kandi mu̱ganyi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS111_5","020_111_5","PSA","111","5","5","Agabira bidyo bab̯wo bamu̱ti̱i̱na, ndagaanu gyamwe agiteekaho mutima biro byenseenya. ");
INSERT INTO rub_vpl VALUES ("PS111_6","020_111_6","PSA","111","6","6","Bantu baamwe yaabolokeerye b̯u̱sobozi̱ b̯wa milimo myamwe, b̯u̱yaabaheeri̱ nsi za mahanga gandi kubba b̯ugwete b̯wab̯u. ");
INSERT INTO rub_vpl VALUES ("PS111_7","020_111_7","PSA","111","7","7","Milimo myamwe myensei̱, yaami̱koori̱ mu b̯wesigwa na mu b̯winganiza, biragiro byamwe byensei̱, byakwesigwa, ");
INSERT INTO rub_vpl VALUES ("PS111_8","020_111_8","PSA","111","8","8","byatebeerweho hab̯wa biro byensei̱, byahebeerwe mu b̯wesigwa na mu b̯u̱terekereru̱. ");
INSERT INTO rub_vpl VALUES ("PS111_9","020_111_9","PSA","111","9","9","Bantu baamwe yaabacu̱ngwi̱ri̱, yaakora nabo ndagaanu gya biro na biro. Ibara lyamwe li̱syanu̱ kandi li̱ku̱ti̱i̱nwa! ");
INSERT INTO rub_vpl VALUES ("PS111_10","020_111_10","PSA","111","10","10","Ndugiiro gya magezi̱ gili mu ku̱ti̱i̱na Mukama. Bab̯wo bensei̱ bakora yatyo, batunga kwetegereza kunene. Kuhaariizwa kwamwe kwa biro byensei̱! ");
INSERT INTO rub_vpl VALUES ("PS112_1","020_112_1","PSA","112","1","1","Haari̱i̱ze Mukama! Ali na mu̱gi̱sa yogwo ati̱i̱na Mukama, asemereerwa hoi̱ mu biragiro byamwe. ");
INSERT INTO rub_vpl VALUES ("PS112_2","020_112_2","PSA","112","2","2","Beizukulu baamwe baabbanga ba maani mu nsi, lubyalu lwa murungi lwaheeb̯wanga mu̱gi̱sa. ");
INSERT INTO rub_vpl VALUES ("PS112_3","020_112_3","PSA","112","3","3","Itungu na b̯u̱gu̱u̱da byeicaalanga mu nnyu̱mba gyamwe, b̯urungi b̯wamwe tib̯umalika. ");
INSERT INTO rub_vpl VALUES ("PS112_4","020_112_4","PSA","112","4","4","Kyererezi̱ kimulikira baterekereru̱ bali mu nti̱ti̱, na yogwo ali na mbabazi̱, kisa na mananu. ");
INSERT INTO rub_vpl VALUES ("PS112_5","020_112_5","PSA","112","5","5","Ali na mu̱gi̱sa ahora na b̯wenda, kandi akora byab̯u̱su̱u̱b̯u̱zi̱ b̯wamwe mu b̯u̱terekereru̱. ");
INSERT INTO rub_vpl VALUES ("PS112_6","020_112_6","PSA","112","6","6","Hab̯wakubba murungi tazi̱ngi̱zi̱ka, biro byensei̱ beicalanga ni̱bamwi̱zu̱ka. ");
INSERT INTO rub_vpl VALUES ("PS112_7","020_112_7","PSA","112","7","7","Tati̱i̱na makuru gabiibi, mutima gwamwe gwicala gwesi̱mbu̱, yeesiga Mukama. ");
INSERT INTO rub_vpl VALUES ("PS112_8","020_112_8","PSA","112","8","8","Tati̱i̱na kandi mutima gwamwe gwicala gu̱si̱gu̱ku̱, ku̱doosya waawona banyanzigwa baamwe basi̱ngi̱i̱rwe. ");
INSERT INTO rub_vpl VALUES ("PS112_9","020_112_9","PSA","112","9","9","Agabira banaku na b̯wenda, b̯urungi b̯wamwe tib̯umalika b̯wa biro na biro, aheeb̯wa ki̱ti̱i̱ni̱sa hab̯wa maani gaamwe. ");
INSERT INTO rub_vpl VALUES ("PS112_10","020_112_10","PSA","112","10","10","Mubiibi b̯wawona yatyo, akwatwa ki̱ni̱ga, anena nsaya zaamwe naasyeraho, kwegomba kwa yogwo muntu mubiibi ku̱li̱zi̱ka. ");
INSERT INTO rub_vpl VALUES ("PS113_1","020_113_1","PSA","113","1","1","Haari̱i̱ze Mukama! Haari̱i̱ze, ai̱ baheereza ba Mukama, muhaariize ibara lya Mukama ");
INSERT INTO rub_vpl VALUES ("PS113_2","020_113_2","PSA","113","2","2","Ibara lya Mukama balihaariize, hataati̱, na biro byensei̱! ");
INSERT INTO rub_vpl VALUES ("PS113_3","020_113_3","PSA","113","3","3","Ibara lya Mukama lihaariizib̯we kalyoba nikakuhuluka ku̱doosya nikaku̱gwa! ");
INSERT INTO rub_vpl VALUES ("PS113_4","020_113_4","PSA","113","4","4","Mukama alema mahanga gensei̱, na ki̱ti̱i̱ni̱sa kyamwe kili hakyendi̱ hoi̱ weiguru! ");
INSERT INTO rub_vpl VALUES ("PS113_5","020_113_5","PSA","113","5","5","Tihaloho akwisana Mukama Ruhanga weetu̱, ei̱cali̱i̱ri̱ hakyendi̱ hoi̱, ");
INSERT INTO rub_vpl VALUES ("PS113_6","020_113_6","PSA","113","6","6","alingiira hadei naawona iguru na nsi. ");
INSERT INTO rub_vpl VALUES ("PS113_7","020_113_7","PSA","113","7","7","Abyokya munaku namutoola mwicuucu, museege namutoola mwi̱syanu̱, ");
INSERT INTO rub_vpl VALUES ("PS113_8","020_113_8","PSA","113","8","8","nabeicaarya hamwei̱ na bayolo, na bayolo ba bantu baamwe. ");
INSERT INTO rub_vpl VALUES ("PS113_9","020_113_9","PSA","113","9","9","Mu̱kali̱ ngumba amuha ki̱ti̱i̱ni̱sa mu maka gaamwe, naamufoora Mma baana wa masanyu. Haari̱i̱ze Mukama! ");
INSERT INTO rub_vpl VALUES ("PS114_1","020_114_1","PSA","114","1","1","Bei̱saleeri̱ b̯u̱baaru̱gi̱ri̱ Mi̱si̱ri̱, nnyu̱mba gya Yakobbo gyaruga mu bantu ba lukobo lundi, ");
INSERT INTO rub_vpl VALUES ("PS114_2","020_114_2","PSA","114","2","2","Yu̱da yaabba nnyu̱mba gya Mukama gi̱syanu̱, I̱saleeri̱ yaafooka b̯ukama b̯wamwe. ");
INSERT INTO rub_vpl VALUES ("PS114_3","020_114_3","PSA","114","3","3","Itaka b̯u̱lyaweeni̱ lyei̱ru̱ka, Mugira Yorodaani gwei̱ra i̱nyu̱ma. ");
INSERT INTO rub_vpl VALUES ("PS114_4","020_114_4","PSA","114","4","4","Nsahu zaagu̱su̱ki̱ri̱ nka mpaya, b̯usahu nka b̯wana b̯wa ntaama. ");
INSERT INTO rub_vpl VALUES ("PS114_5","020_114_5","PSA","114","5","5","Kyani kyakwirukiirye, we itaka? Ai̱ Mugira Yorodaani, hab̯waki wei̱ri̱ri̱ i̱nyu̱ma? ");
INSERT INTO rub_vpl VALUES ("PS114_6","020_114_6","PSA","114","6","6","Ai̱ nsahu nywe, kyani kyabagu̱su̱kagu̱su̱kyengi̱ nka mpaya? Ai̱ b̯usahu ni̱mu̱gu̱su̱ka nka b̯wana b̯wa ntaama? ");
INSERT INTO rub_vpl VALUES ("PS114_7","020_114_7","PSA","114","7","7","We nsi, jegemeera mu mei̱so ga Mukama, mu mei̱so ga Ruhanga wa Yakobbo, ");
INSERT INTO rub_vpl VALUES ("PS114_8","020_114_8","PSA","114","8","8","munyakufoora lubbaali i̱zu̱ba, mahi̱ga gaahinduka misu mya meezi̱. ");
INSERT INTO rub_vpl VALUES ("PS115_1","020_115_1","PSA","115","1","1","Ai̱ Mukama twetwe kwahi, twetwe kwahi, bei̱tu̱ ibara lyamu lyolyo litunge ki̱ti̱i̱ni̱sa, hab̯wa ngonzi zinene na b̯wesigwa b̯wamu! ");
INSERT INTO rub_vpl VALUES ("PS115_2","020_115_2","PSA","115","2","2","Hab̯waki mahanga gakoba nti, “Ruhanga waab̯u ali hanya?” ");
INSERT INTO rub_vpl VALUES ("PS115_3","020_115_3","PSA","115","3","3","Ruhanga weetu̱ ali mwiguru, akora byensei̱ nka kuyenderye. ");
INSERT INTO rub_vpl VALUES ("PS115_4","020_115_4","PSA","115","4","4","Bi̱si̱sani̱ byab̯u bi̱baramya bib̯umbe kuruga mu feeza na zaabbu, bikorwa b̯ukorwa mikono mya bantu. ");
INSERT INTO rub_vpl VALUES ("PS115_5","020_115_5","PSA","115","5","5","Bili na mi̱nwa, bei̱tu̱ tibibaza, bili na mei̱so, bei̱tu̱ tibiwona. ");
INSERT INTO rub_vpl VALUES ("PS115_6","020_115_6","PSA","115","6","6","Bili na mapokopo, bei̱tu̱ ti̱byegwa, bili na nni̱ndo, bei̱tu̱ tibikaga. ");
INSERT INTO rub_vpl VALUES ("PS115_7","020_115_7","PSA","115","7","7","Bili na ngalu, bei̱tu̱ tibikwata kintu, magulu gaabyo tigalibata, mu mimiro myabyo tihaloho iraka lihulukamwo. ");
INSERT INTO rub_vpl VALUES ("PS115_8","020_115_8","PSA","115","8","8","Bab̯wo babikora nabo kwokwo beisana, na bab̯wo bensei̱ babyesiga kwokwo bali. ");
INSERT INTO rub_vpl VALUES ("PS115_9","020_115_9","PSA","115","9","9","Ai̱ I̱saleeri̱, mwesiga Mukama! Yooyo mu̱ju̱ni̱ kandi ngab̯u gyenyu̱. ");
INSERT INTO rub_vpl VALUES ("PS115_10","020_115_10","PSA","115","10","10","Ai̱ we nnyu̱mba gya Alooni̱ mwesige Mukama! Yooyo mu̱ju̱ni̱ kandi ngab̯u gyenyu̱. ");
INSERT INTO rub_vpl VALUES ("PS115_11","020_115_11","PSA","115","11","11","Nywe batamwo Mukama ki̱ti̱i̱ni̱sa, mumwesige Mukama! Yooyo mu̱ju̱ni̱ kandi ngab̯u gyenyu̱. ");
INSERT INTO rub_vpl VALUES ("PS115_12","020_115_12","PSA","115","12","12","Mukama aku̱twi̱zu̱ka kandi alituha mu̱gi̱sa, aliha nnyu̱mba gyʼI̱saleeri̱ mu̱gi̱sa, aliha nnyu̱mba gya Alooni̱ mu̱gi̱sa, ");
INSERT INTO rub_vpl VALUES ("PS115_13","020_115_13","PSA","115","13","13","bab̯wo batamwo Mukama ki̱ti̱i̱ni̱sa, Mukama alibaha mu̱gi̱sa, atasoroori̱mwo bato na bahandu̱. ");
INSERT INTO rub_vpl VALUES ("PS115_14","020_115_14","PSA","115","14","14","Mukama akuhe baana, na beizukulu baamu abahe baana! ");
INSERT INTO rub_vpl VALUES ("PS115_15","020_115_15","PSA","115","15","15","Mukama munyakuhanga iguru na nsi, abahe mu̱gi̱sa! ");
INSERT INTO rub_vpl VALUES ("PS115_16","020_115_16","PSA","115","16","16","Iguru lya Mukama yankei bei̱tu̱ nsi yaagi̱heeri̱ bantu. ");
INSERT INTO rub_vpl VALUES ("PS115_17","020_115_17","PSA","115","17","17","Baku̱u̱ tibahaariiza Mukama, nab̯ubakubba bab̯wo bagyenda mu nsi gya baku̱u̱. ");
INSERT INTO rub_vpl VALUES ("PS115_18","020_115_18","PSA","115","18","18","Bei̱tu̱ tu̱kwi̱za kuhaariiza Mukama, hataati̱ na biro byensei̱. Haari̱i̱ze Mukama! ");
INSERT INTO rub_vpl VALUES ("PS116_1","020_116_1","PSA","116","1","1","Nyendya Mukama, hab̯wakubba yeegwi̱ri̱ iraka lyange na kwesengereerya kwange. ");
INSERT INTO rub_vpl VALUES ("PS116_2","020_116_2","PSA","116","2","2","Hab̯wakubba yantegeeri̱ ipokopo, b̯undibba nicaali mwomi nkwi̱za kumusabanga. ");
INSERT INTO rub_vpl VALUES ("PS116_3","020_116_3","PSA","116","3","3","Nyaaboheerwe miguha mya lu̱ku̱u̱, kandi b̯u̱ru̱mi̱ b̯wa kuzumu b̯wakwata, nyawonawona na b̯ujune na kusaalirwa. ");
INSERT INTO rub_vpl VALUES ("PS116_4","020_116_4","PSA","116","4","4","Mwomwo nyaaku̱ngi̱ri̱ ibara lya Mukama ninkoba yati, “Ai̱ Mukama, nku̱kwesengereerya, ncungura!” ");
INSERT INTO rub_vpl VALUES ("PS116_5","020_116_5","PSA","116","5","5","Mukama wa mbabazi̱ kandi wa munanu, Ruhanga weetu̱ wa kisa. ");
INSERT INTO rub_vpl VALUES ("PS116_6","020_116_6","PSA","116","6","6","Mukama alinda bab̯u̱ndaaru̱, kabii b̯u̱kanzi̱zi̱i̱ri̱, yanju̱ni̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS116_7","020_116_7","PSA","116","7","7","Ai̱ mwozo gwange, huumula, hab̯wa birungi bya Mukama aku̱koleeri̱. ");
INSERT INTO rub_vpl VALUES ("PS116_8","020_116_8","PSA","116","8","8","Ai̱ Mukama, weewe ohoneerye b̯womi b̯wange lu̱ku̱u̱, mei̱so gange kulira mali̱ga, magulu gange kukiibbala, ");
INSERT INTO rub_vpl VALUES ("PS116_9","020_116_9","PSA","116","9","9","aleke ndibatirenge mu mei̱so ga Mukama, mu nsi gya boomi. ");
INSERT INTO rub_vpl VALUES ("PS116_10","020_116_10","PSA","116","10","10","Nyei̱ki̱ri̱ri̱i̱ze muliwe, ninkoba yati, “Ndi mu b̯ujune b̯unene hoi̱,” ");
INSERT INTO rub_vpl VALUES ("PS116_11","020_116_11","PSA","116","11","11","kambe nyaabazi̱ri̱ mu b̯utagyendeera ninkoba yati, “Tihaloho mwesigwa.” ");
INSERT INTO rub_vpl VALUES ("PS116_12","020_116_12","PSA","116","12","12","Hab̯wa birungi byankoleeri̱, kikyani gya kindiha Mukama? ");
INSERT INTO rub_vpl VALUES ("PS116_13","020_116_13","PSA","116","13","13","Ndikuha vi̱i̱no nka kihongwa hab̯wa kujunwa kwange, kandi ndyeta ibara lya Mukama. ");
INSERT INTO rub_vpl VALUES ("PS116_14","020_116_14","PSA","116","14","14","Ndi̱doosereerya bi̱byo bi̱nyamu̱ragani̱si̱i̱rye, mu mei̱so ga bantu baamwe bensei̱. ");
INSERT INTO rub_vpl VALUES ("PS116_15","020_116_15","PSA","116","15","15","Kya muhendu mu mei̱so ga Mukama, bantu barungi b̯u̱bakwa. ");
INSERT INTO rub_vpl VALUES ("PS116_16","020_116_16","PSA","116","16","16","Ai̱ Mukama, ndi muheereza waamu, nka mmaama kuyaali muheereza waamu. Osu̱u̱mu̱rwi̱ri̱ kuruga mu njegere ");
INSERT INTO rub_vpl VALUES ("PS116_17","020_116_17","PSA","116","17","17","Ndikuhongera kyonzira kya ku̱ku̱si̱i̱ma, kandi ndyeta ibara lya Mukama. ");
INSERT INTO rub_vpl VALUES ("PS116_18","020_116_18","PSA","116","18","18","Ndi̱doosereerya miragu myange hali Mukama, mu mei̱so ga bantu baamwe bensei̱, ");
INSERT INTO rub_vpl VALUES ("PS116_19","020_116_19","PSA","116","19","19","mu zi̱gati̱ gya nnyu̱mba gya Mukama, hakati̱ na hakati̱, gyamu, ai̱ Yeru̱salemu̱. Haari̱i̱ze Mukama! ");
INSERT INTO rub_vpl VALUES ("PS117_1","020_117_1","PSA","117","1","1","Mu̱haari̱i̱ze Mukama, nywe mahanga gensei̱! Mu̱mu̱haari̱i̱ze nywe bantu nywensei̱! ");
INSERT INTO rub_vpl VALUES ("PS117_2","020_117_2","PSA","117","2","2","Kubba ngonzi zaamwe hali twe zinene, na mananu gaamwe ga biro na biro. Mu̱haari̱i̱ze Mukama! ");
INSERT INTO rub_vpl VALUES ("PS118_1","020_118_1","PSA","118","1","1","Mu̱si̱i̱me Mukama, kubba abba murungi, kubba ngonzi zaamwe zinene za biro na biro! ");
INSERT INTO rub_vpl VALUES ("PS118_2","020_118_2","PSA","118","2","2","Leka Bei̱saleeri̱ bakunge nibakoba, “Ngonzi zaamwe zinene za biro na biro” ");
INSERT INTO rub_vpl VALUES ("PS118_3","020_118_3","PSA","118","3","3","Leka ba nnyu̱mba gyʼAlooni̱ bakunge nibakoba, “Ngonzi zaamwe zinene za biro na biro” ");
INSERT INTO rub_vpl VALUES ("PS118_4","020_118_4","PSA","118","4","4","Leka bab̯wo bati̱i̱na Mukama bakunge nibakoba, “Ngonzi zaamwe zinene za biro na biro.” ");
INSERT INTO rub_vpl VALUES ("PS118_5","020_118_5","PSA","118","5","5","B̯unyaali nindi mu b̯ujune, nyaaku̱ngi̱ri̱ Mukama, yanzi̱ramwo, yampa b̯u̱si̱nge. ");
INSERT INTO rub_vpl VALUES ("PS118_6","020_118_6","PSA","118","6","6","Mukama abba wange, ti̱ndi̱ti̱i̱na, muntu b̯untu alinkora kyani? ");
INSERT INTO rub_vpl VALUES ("PS118_7","020_118_7","PSA","118","7","7","Mukama ali harubaju lwange nka mu̱ju̱ni̱ wange, nkwi̱za ku̱si̱ngu̱ra banyanzigwa bange bensei̱. ");
INSERT INTO rub_vpl VALUES ("PS118_8","020_118_8","PSA","118","8","8","Kirungi kwi̱ru̱ki̱ra hali Mukama, kukira kwesiga muntu. ");
INSERT INTO rub_vpl VALUES ("PS118_9","020_118_9","PSA","118","9","9","Kirungi kwi̱ru̱ki̱ra hali Mukama, kukira kwesiga balemi̱. ");
INSERT INTO rub_vpl VALUES ("PS118_10","020_118_10","PSA","118","10","10","Mahanga gensei̱ b̯u̱gangoti̱ri̱, mwibara lya Mukama nyagacwacweni̱! ");
INSERT INTO rub_vpl VALUES ("PS118_11","020_118_11","PSA","118","11","11","Gangotangoti̱ri̱ mbaju zensei̱, mwibara lya Mukama nyagacwacweni̱! ");
INSERT INTO rub_vpl VALUES ("PS118_12","020_118_12","PSA","118","12","12","Gangoti̱ri̱ nka b̯uhooki, gaasyeraho b̯wangu nka mworo gweisubi lya kyanda, mwibara lya Mukama nyagacwacweni̱! ");
INSERT INTO rub_vpl VALUES ("PS118_13","020_118_13","PSA","118","13","13","Gansi̱ndi̱ki̱ri̱, heehi̱ kunguma b̯u̱gu̱mi̱, bei̱tu̱ Mukama yanju̱ni̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS118_14","020_118_14","PSA","118","14","14","Mukama yooyo maani gange, kandi kyembu kyange, kandi yooyo kujunwa kwange. ");
INSERT INTO rub_vpl VALUES ("PS118_15","020_118_15","PSA","118","15","15","Mu heema za barungi habbamwo byembu bya kusemererwa na bya ku̱si̱ngu̱ra bikukoba yati, “Mukono gwa Mukama gwab̯udyo gu̱koori̱ byamaani, ");
INSERT INTO rub_vpl VALUES ("PS118_16","020_118_16","PSA","118","16","16","mukono gwa Mukama gwab̯udyo guhaariizwe, mukono gwa Mukama gwab̯udyo gu̱koori̱ byamaani!” ");
INSERT INTO rub_vpl VALUES ("PS118_17","020_118_17","PSA","118","17","17","Ti̱ndi̱kwa, bei̱tu̱ ndyomeera, aleke ndangiire bya Mukama akoori̱. ");
INSERT INTO rub_vpl VALUES ("PS118_18","020_118_18","PSA","118","18","18","Mukama anfu̱bi̱i̱ri̱ namaani, bei̱tu̱ tandeki̱ri̱ nkwe. ");
INSERT INTO rub_vpl VALUES ("PS118_19","020_118_19","PSA","118","19","19","Munkingulire malembu ga barungi, nzingire nsi̱i̱me Mukama. ");
INSERT INTO rub_vpl VALUES ("PS118_20","020_118_20","PSA","118","20","20","Lili irembu lya Mukama, barungi boobo balirabamwo. ");
INSERT INTO rub_vpl VALUES ("PS118_21","020_118_21","PSA","118","21","21","Nku̱ku̱si̱i̱ma hab̯wakubba weegwi̱ri̱ kusaba kwange, wanjuna. ");
INSERT INTO rub_vpl VALUES ("PS118_22","020_118_22","PSA","118","22","22","I̱hi̱ga lya babi̱mbi̱ li̱baaswi̱ri̱, lyolyo li̱fooki̱ri̱ lya mugasu lya ha nsonda. ");
INSERT INTO rub_vpl VALUES ("PS118_23","020_118_23","PSA","118","23","23","Kiki kyokyo kya Mukama ki̱yaakoori̱, kandi kili kintu kyamahanu mu mei̱so geetu̱. ");
INSERT INTO rub_vpl VALUES ("PS118_24","020_118_24","PSA","118","24","24","Kiro kiki kyokyo Mukama ateeri̱ho, leka tusemererwe kandi tujaguze. ");
INSERT INTO rub_vpl VALUES ("PS118_25","020_118_25","PSA","118","25","25","Ai̱ Mukama, tukukusaba tu̱ju̱ne! Ai̱ Mukama, tukukusaba, tu̱he ku̱si̱ngu̱ra! ");
INSERT INTO rub_vpl VALUES ("PS118_26","020_118_26","PSA","118","26","26","Ali na mu̱gi̱sa yogwo akwi̱za mwibara lya Mukama, tu̱basabi̱i̱ri̱ mu̱gi̱sa kuruga mu nnyu̱mba gya Mukama, ");
INSERT INTO rub_vpl VALUES ("PS118_27","020_118_27","PSA","118","27","27","Mukama ali Ruhanga, kandi atu̱heeri̱ kyererezi̱ kyamwe ki̱tu̱mu̱lu̱ki̱i̱ri̱. Mu̱kwate bihongwa mukumbe mugyende heihembe lya kyoto! ");
INSERT INTO rub_vpl VALUES ("PS118_28","020_118_28","PSA","118","28","28","Oli Ruhanga wange, nkwi̱za ku̱ku̱si̱i̱manga, oli Ruhanga wange, ndikuhariiza. ");
INSERT INTO rub_vpl VALUES ("PS118_29","020_118_29","PSA","118","29","29","Mu̱si̱i̱me Mukama, kubba abba murungi, kubba ngonzi zaamwe zinene za biro na biro! ");
INSERT INTO rub_vpl VALUES ("PS119_1","020_119_1","PSA","119","1","1","Bali na mu̱gi̱sa bab̯wo balibatira mu biragiro bya Mukama, batakora bibiibi. ");
INSERT INTO rub_vpl VALUES ("PS119_2","020_119_2","PSA","119","2","2","Bali na mu̱gi̱sa bab̯wo bakwata bigambu byamwe, bamu̱toolya na mitima myab̯u myensei̱. ");
INSERT INTO rub_vpl VALUES ("PS119_3","020_119_3","PSA","119","3","3","Bab̯wo batakora kibii, bei̱tu̱ nibalibatira mu mihanda myamwe. ");
INSERT INTO rub_vpl VALUES ("PS119_4","020_119_4","PSA","119","4","4","Weewe waatu̱ragi̱i̱ri̱ kukwatira ki̱mwei̱ ndagiiro zaamu. ");
INSERT INTO rub_vpl VALUES ("PS119_5","020_119_5","PSA","119","5","5","Nkusaba mihanda myange misobore kuhondera mateeka gaamu biro na biro. ");
INSERT INTO rub_vpl VALUES ("PS119_6","020_119_6","PSA","119","6","6","B̯u̱b̯wo mwomwo ntaliswara, biteekerezu byange byabbanga ha biragiro byamu. ");
INSERT INTO rub_vpl VALUES ("PS119_7","020_119_7","PSA","119","7","7","B̯undyega micwere myamu mirungi, nkwi̱za kukuhaariizanga na mutima gu̱syanu̱. ");
INSERT INTO rub_vpl VALUES ("PS119_8","020_119_8","PSA","119","8","8","Nkwi̱za kulinda mateeka gaamu, Ai̱ Mukama, otandekeera ki̱mwei̱. ");
INSERT INTO rub_vpl VALUES ("PS119_9","020_119_9","PSA","119","9","9","Haloho mu̱li̱ngo gwa musigazi akusobora kwicala nali mu b̯u̱doori̱? Akusobora nka kigambu kyamu kukikoba. ");
INSERT INTO rub_vpl VALUES ("PS119_10","020_119_10","PSA","119","10","10","Na mutima gwange gwensei̱ nkwi̱za ku̱ku̱toolyanga, otalindeka kwandaara nkaruga ha biragiro byamu. ");
INSERT INTO rub_vpl VALUES ("PS119_11","020_119_11","PSA","119","11","11","Nyateeri̱ kigambu kyamu mu mutima aleke ntalikora kibii mu mei̱so gaamu. ");
INSERT INTO rub_vpl VALUES ("PS119_12","020_119_12","PSA","119","12","12","Ai̱ Mukama, ohaariizib̯we, onzegesyenge mateeka gaamu! ");
INSERT INTO rub_vpl VALUES ("PS119_13","020_119_13","PSA","119","13","13","Ndangiira micwere myamu myensei̱ mya mu mu̱nwa gwamu. ");
INSERT INTO rub_vpl VALUES ("PS119_14","020_119_14","PSA","119","14","14","B̯u̱kei̱so b̯wamu b̯umpa kusemererwa kukira b̯u̱gu̱u̱da b̯wensei̱. ");
INSERT INTO rub_vpl VALUES ("PS119_15","020_119_15","PSA","119","15","15","Biteekerezu byange bi̱kwi̱za kwicalanga mu ndagiiro zaamu, na mei̱so gange ku mihanda myamu. ");
INSERT INTO rub_vpl VALUES ("PS119_16","020_119_16","PSA","119","16","16","Mateeka gaamu gampa kusemererwa, tindigumisirana kigambu kyamu. ");
INSERT INTO rub_vpl VALUES ("PS119_17","020_119_17","PSA","119","17","17","Nkolera birungi gya muheereza waamu, kwokwo nsobore kwomeera na kuhondera kigambu kyamu. ");
INSERT INTO rub_vpl VALUES ("PS119_18","020_119_18","PSA","119","18","18","Mmbuula mei̱so, aleke mbone byamahanu bya mu biragiro byamu. ");
INSERT INTO rub_vpl VALUES ("PS119_19","020_119_19","PSA","119","19","19","Ndi mu̱goonyi̱ haha ku nsi, otambi̱sanga biragiro byamu! ");
INSERT INTO rub_vpl VALUES ("PS119_20","020_119_20","PSA","119","20","20","Mwozo gwange gwegomba micwere myamu b̯wi̱re b̯wensei̱. ");
INSERT INTO rub_vpl VALUES ("PS119_21","020_119_21","PSA","119","21","21","Ocoomera banyamyehembu, bakyeneerwe, batahondera biragiro byamu. ");
INSERT INTO rub_vpl VALUES ("PS119_22","020_119_22","PSA","119","22","22","Ntoolaho bi̱lu̱mo na mugayo gwab̯u, kubba bigambu byamu biicala mu mutima gwange. ");
INSERT INTO rub_vpl VALUES ("PS119_23","020_119_23","PSA","119","23","23","Balemi̱ nab̯ubakora nkwe za ku̱ndwani̱sya, gya muheereza waamu nkwi̱za kuteekerezanga ha mateeka gaamu. ");
INSERT INTO rub_vpl VALUES ("PS119_24","020_119_24","PSA","119","24","24","Bigambu byamu bindeetera isanyu, kandi bimpa magezi̱. ");
INSERT INTO rub_vpl VALUES ("PS119_25","020_119_25","PSA","119","25","25","Mutima gwange gwicala mu cuucu, mmpa b̯womi ku̱si̱gi̱ki̱ra ku kigambu kyamu! ");
INSERT INTO rub_vpl VALUES ("PS119_26","020_119_26","PSA","119","26","26","B̯u̱nyakwolokeerye mihanda myange, wanzi̱ri̱ri̱mwo, nzegesya mateeka gaamu! ");
INSERT INTO rub_vpl VALUES ("PS119_27","020_119_27","PSA","119","27","27","Ompenge kwetegereza ndagiiro zaamu, aleke nteekerezenge ha milimo myamu mya mahanu. ");
INSERT INTO rub_vpl VALUES ("PS119_28","020_119_28","PSA","119","28","28","Ndi na kusalirwa kunene mu mutima gwange hab̯wa b̯ujune b̯undi nab̯wo, ntati̱i̱rya ku̱si̱gi̱ki̱ra ha kigambu kyamu. ");
INSERT INTO rub_vpl VALUES ("PS119_29","020_119_29","PSA","119","29","29","Ontoolemwo ngesu za b̯u̱gobya, mu mbabazi̱ zaamu onzegesye biragiro byamu! ");
INSERT INTO rub_vpl VALUES ("PS119_30","020_119_30","PSA","119","30","30","Ncwi̱ri̱mwo kubba mwesigwa, mei̱so gange ngateeri̱ hali micwere myamu. ");
INSERT INTO rub_vpl VALUES ("PS119_31","020_119_31","PSA","119","31","31","Ai̱ Mukama, nyeesiga bigambu byamu, otandeka kuswara. ");
INSERT INTO rub_vpl VALUES ("PS119_32","020_119_32","PSA","119","32","32","Nyetegeki̱ri̱ kukora ku̱si̱gi̱ki̱ra ha biragiro byamu, wakagali̱hya kwetegereza kwange. ");
INSERT INTO rub_vpl VALUES ("PS119_33","020_119_33","PSA","119","33","33","Ai̱ Mukama, nzegesya mateeka gaamu, aleke nsobore kugahondera biro byensei̱. ");
INSERT INTO rub_vpl VALUES ("PS119_34","020_119_34","PSA","119","34","34","Mmpa kwetegereza aleke nkwatenge biragiro byamu, mbihonderenge na mutima gwange gwensei̱. ");
INSERT INTO rub_vpl VALUES ("PS119_35","020_119_35","PSA","119","35","35","Onyebembere mu muhanda gwa biragiro byamu, kubba bimpa kusemererwa. ");
INSERT INTO rub_vpl VALUES ("PS119_36","020_119_36","PSA","119","36","36","Terekereerya mutima gwange mu kuhondera bigambu byamu, hatali byange nyankei. ");
INSERT INTO rub_vpl VALUES ("PS119_37","020_119_37","PSA","119","37","37","Toola mei̱so gange kulingiira bintu bitali na mugasu, ompe kwomeera mu kigambu kyamu. ");
INSERT INTO rub_vpl VALUES ("PS119_38","020_119_38","PSA","119","38","38","Odosereerye muragu gwamu hali muheereza waamu, aleke bakutemwo ki̱ti̱i̱ni̱sa. ");
INSERT INTO rub_vpl VALUES ("PS119_39","020_119_39","PSA","119","39","39","Ntoolahoona bi̱byo bi̱lu̱mo bi̱nsaagi̱ri̱, hab̯wakubba micwere myamu mirungi. ");
INSERT INTO rub_vpl VALUES ("PS119_40","020_119_40","PSA","119","40","40","Wona, nkakunyendya ndagiiro zaamu, ompenge maani mu mananu gaamu. ");
INSERT INTO rub_vpl VALUES ("PS119_41","020_119_41","PSA","119","41","41","Ai̱ Mukama, leka ngonzi zaamu zinene na kujunwa kwamu, bi̱i̱zenge caali ndi nka muragu gwamu kumili, ");
INSERT INTO rub_vpl VALUES ("PS119_42","020_119_42","PSA","119","42","42","mwomwo ndisobora kwi̱ramwo bab̯wo bandu̱ma, kubba nyesiga kigambu kyamu. ");
INSERT INTO rub_vpl VALUES ("PS119_43","020_119_43","PSA","119","43","43","Onterekereerye kubazanga mananu b̯wi̱re b̯wensei̱, hab̯wakubba ku̱ni̱hi̱ra kwange kuli mu micwere myamu. ");
INSERT INTO rub_vpl VALUES ("PS119_44","020_119_44","PSA","119","44","44","Nkwi̱za kukwata biragiro byamu ntakulekeera, biro byensei̱. ");
INSERT INTO rub_vpl VALUES ("PS119_45","020_119_45","PSA","119","45","45","Kandi nkwi̱za kulibatiranga hagali, hab̯wakubba mpondera ndagiiro zaamu. ");
INSERT INTO rub_vpl VALUES ("PS119_46","020_119_46","PSA","119","46","46","Nkwi̱za kurangiranga bigambu byamu mu mei̱so ga bakama, ntaku̱ti̱i̱na kuswara, ");
INSERT INTO rub_vpl VALUES ("PS119_47","020_119_47","PSA","119","47","47","kubba kusemererwa kwange kuruga mu biragiro byamu, bi̱nyendya. ");
INSERT INTO rub_vpl VALUES ("PS119_48","020_119_48","PSA","119","48","48","Nditamwo ki̱ti̱i̱ni̱sa biragiro byamu bi̱nyendya, kandi nteekerezenge ha mateeka gaamu. ");
INSERT INTO rub_vpl VALUES ("PS119_49","020_119_49","PSA","119","49","49","I̱zu̱ka kigambu ki̱waadagani̱si̱rye, gya muheereza waamu, kimpa ku̱ni̱hi̱ra. ");
INSERT INTO rub_vpl VALUES ("PS119_50","020_119_50","PSA","119","50","50","B̯umba mu kuwonawona, muragu gwamu gwogwo gu̱mpu̱u̱mu̱u̱lya. ");
INSERT INTO rub_vpl VALUES ("PS119_51","020_119_51","PSA","119","51","51","Babiibi batati̱i̱na Ruhanga beicala nibasekereerya, bei̱tu̱ gya tinkaruganga ha biragiro byamu. ");
INSERT INTO rub_vpl VALUES ("PS119_52","020_119_52","PSA","119","52","52","Ai̱ Mukama, b̯unteekereza ha micwere myamu mya kadei na kadei, bimpa maani. ");
INSERT INTO rub_vpl VALUES ("PS119_53","020_119_53","PSA","119","53","53","B̯umbona babiibi batakuhondera biragiro byamu, nyeegwa ni̱nku̱hya b̯u̱hi̱ na ki̱ni̱ga. ");
INSERT INTO rub_vpl VALUES ("PS119_54","020_119_54","PSA","119","54","54","Mateeka gaamu googo byembu byange mu ngoonyi̱ gyange. ");
INSERT INTO rub_vpl VALUES ("PS119_55","020_119_55","PSA","119","55","55","Ai̱ Mukama, kantekereza heibara lyamu b̯wi̱re b̯wei̱jolo, ninkwata biragiro byamu. ");
INSERT INTO rub_vpl VALUES ("PS119_56","020_119_56","PSA","119","56","56","Mu kukwata ndagiiro zaamu, hooho ntungira kusemererwa. ");
INSERT INTO rub_vpl VALUES ("PS119_57","020_119_57","PSA","119","57","57","Mukama yooyo mugab̯u gwange, nyeheeri̱yo kukwatanga bigambu byamu. ");
INSERT INTO rub_vpl VALUES ("PS119_58","020_119_58","PSA","119","58","58","Nkukwesegereerya na mutima gwange gwensei̱, ongiira mbabazi̱, ku̱si̱gi̱ki̱ra ha muragu gwamu. ");
INSERT INTO rub_vpl VALUES ("PS119_59","020_119_59","PSA","119","59","59","B̯u̱ntekereza ha mihanda myange, nzi̱ra nimpondera bigambu byamu. ");
INSERT INTO rub_vpl VALUES ("PS119_60","020_119_60","PSA","119","60","60","Ntakwesi̱tasi̱ta, aleke nkwate biragiro byamu b̯wangu b̯wangu. ");
INSERT INTO rub_vpl VALUES ("PS119_61","020_119_61","PSA","119","61","61","Babiibi nab̯ubatega miguha, tindyebeera biragiro byamu. ");
INSERT INTO rub_vpl VALUES ("PS119_62","020_119_62","PSA","119","62","62","Mbyoka i̱jolo itumbi kukuhaariiza, hab̯wa micwere myamu mirungi. ");
INSERT INTO rub_vpl VALUES ("PS119_63","020_119_63","PSA","119","63","63","Nnywana bab̯wo baku̱ti̱i̱na, bab̯wo bakwata ndagiiro zaamu. ");
INSERT INTO rub_vpl VALUES ("PS119_64","020_119_64","PSA","119","64","64","Ai̱ Mukama, nsi gyensei̱ gi̱i̱zwi̱ri̱ ngonzi zaamu zinene, nzegesya mateeka gaamu! ");
INSERT INTO rub_vpl VALUES ("PS119_65","020_119_65","PSA","119","65","65","Ai̱ Mukama, onkori̱ kurungi gya muheereza waamu, ku̱si̱gi̱ki̱ra mu kigambu kyamu. ");
INSERT INTO rub_vpl VALUES ("PS119_66","020_119_66","PSA","119","66","66","Nzegesya ncwamwo, magezi̱ na kwetegereza kurungi, hab̯wakubba nzikiririza mu biragiro byamu. ");
INSERT INTO rub_vpl VALUES ("PS119_67","020_119_67","PSA","119","67","67","B̯uwaali otakanfu̱u̱bi̱ri̱ nyaahabengi̱, bei̱tu̱ hataati̱, mmpondera kigambu kyamu. ");
INSERT INTO rub_vpl VALUES ("PS119_68","020_119_68","PSA","119","68","68","Oli murungi kandi okora birungi, nzegesya mateeka gaamu! ");
INSERT INTO rub_vpl VALUES ("PS119_69","020_119_69","PSA","119","69","69","Bamyehembu banteeri̱ho bigambu bya b̯u̱gobya, bei̱tu̱ gya nkwata ndagiiro zaamu na mutima gwange gwensei̱. ");
INSERT INTO rub_vpl VALUES ("PS119_70","020_119_70","PSA","119","70","70","Mitima myab̯u timilimwo kakwetegereza, bei̱tu̱ nsanyu̱ki̱ra mu biragiro byamu. ");
INSERT INTO rub_vpl VALUES ("PS119_71","020_119_71","PSA","119","71","71","B̯u̱wanfu̱u̱bi̱ri̱ kyabbeeri̱ kirungi, hab̯wakubba kyampeeri̱ kwega mateeka gaamu. ");
INSERT INTO rub_vpl VALUES ("PS119_72","020_119_72","PSA","119","72","72","Biragiro byamu bya muhendu, kukira nku̱mi̱ na nku̱mi̱ za zaabbu na feeza. ");
INSERT INTO rub_vpl VALUES ("PS119_73","020_119_73","PSA","119","73","73","Mikono myamu myambumba b̯u̱mbi̱ri̱ kandi myampangi̱ri̱, mpa kwetegereza nsobore kwega biragiro byamu. ");
INSERT INTO rub_vpl VALUES ("PS119_74","020_119_74","PSA","119","74","74","Bab̯wo bakutamwo ki̱ti̱i̱ni̱sa, b̯ubalimbona balijaguza, hab̯wakubba ndi naku̱ni̱hi̱ra mu kigambu kyamu. ");
INSERT INTO rub_vpl VALUES ("PS119_75","020_119_75","PSA","119","75","75","Ai̱ Mukama, nkyegi̱ri̱ nti micwere myamu mibba myamananu, kandi nti onfu̱bi̱i̱ri̱ mu b̯u̱doori̱. ");
INSERT INTO rub_vpl VALUES ("PS119_76","020_119_76","PSA","119","76","76","Leka ngonzi zaamu zinene zimbudab̯ude, ku̱si̱gi̱ki̱ra ha muragu gwamu hali muheereza waamu. ");
INSERT INTO rub_vpl VALUES ("PS119_77","020_119_77","PSA","119","77","77","Ongiire mbabazi̱ aleke kimpe kwomeera, kubba biragiro byamu byobyo binsemeza. ");
INSERT INTO rub_vpl VALUES ("PS119_78","020_119_78","PSA","119","78","78","Leka banyamyehembo baswarenge, hab̯wa kumpangiira ntali na ki̱nkoori̱, bei̱tu̱ gya nkwi̱za kwicala nintekerezanga ha ndagiiro zaamu. ");
INSERT INTO rub_vpl VALUES ("PS119_79","020_119_79","PSA","119","79","79","Leka bab̯wo bakutamwo ki̱ti̱i̱ni̱sa bei̱ze hali gya, aleke basobore kwega bigambu byamu! ");
INSERT INTO rub_vpl VALUES ("PS119_80","020_119_80","PSA","119","80","80","Leka mutima gwange gubbe gwa mananu hali mateeka gaamu, aleke ntaswara! ");
INSERT INTO rub_vpl VALUES ("PS119_81","020_119_81","PSA","119","81","81","Mutima gwange gwegomba kujunwa kwamu, ku̱ni̱hi̱ra kwange kuli mu kigambu kyamu. ");
INSERT INTO rub_vpl VALUES ("PS119_82","020_119_82","PSA","119","82","82","Mei̱so gange gajwahi̱ri̱ naakulindiira muragu gwamu, nku̱b̯u̱u̱lya “Olinjuna di̱i̱?” ");
INSERT INTO rub_vpl VALUES ("PS119_83","020_119_83","PSA","119","83","83","Nfoki̱ri̱ nka kisahu kya maaci ki̱badengeteerye mu mwi̱ca, bei̱tu̱ tindyebeera mateeka gaamu. ");
INSERT INTO rub_vpl VALUES ("PS119_84","020_119_84","PSA","119","84","84","Gya muheereza waamu, ndigumisiriza kudwa di̱i̱? Olibacwera di̱i̱ bakumparana? ");
INSERT INTO rub_vpl VALUES ("PS119_85","020_119_85","PSA","119","85","85","Bantu ba myehembo bandi̱mi̱i̱ri̱ bi̱i̱na ngwemwo, tibomeera ku̱si̱gi̱ki̱ra ha kiragiro kyamu. ");
INSERT INTO rub_vpl VALUES ("PS119_86","020_119_86","PSA","119","86","86","Biragiro byamu byensei̱ bibba byabiribiri, bakumparanira b̯usa, njuna! ");
INSERT INTO rub_vpl VALUES ("PS119_87","020_119_87","PSA","119","87","87","Kadooli̱ bantoole mu nsi, bei̱tu̱ ntakaruge hali ndagiiro zaamu. ");
INSERT INTO rub_vpl VALUES ("PS119_88","020_119_88","PSA","119","88","88","Mu ngonzi zaamu zinene njuna, b̯u̱b̯wo mwomwo ndilinda bigambu byamu. ");
INSERT INTO rub_vpl VALUES ("PS119_89","020_119_89","PSA","119","89","89","Ai̱ Mukama, biro byensei̱ kigambu kyamu, kiicala kinyamaani mwiguru. ");
INSERT INTO rub_vpl VALUES ("PS119_90","020_119_90","PSA","119","90","90","B̯wesigwa b̯wamu tib̯ulihinduka biro na biro, nka ku̱waakahangi̱ri̱ nsi kwokwo giicala. ");
INSERT INTO rub_vpl VALUES ("PS119_91","020_119_91","PSA","119","91","91","Bintu byensei̱ ku̱doosya na kiro kiki, bili nka ku̱waakacwi̱ri̱mwo, hab̯wakubba byensei̱ biheereza weewe. ");
INSERT INTO rub_vpl VALUES ("PS119_92","020_119_92","PSA","119","92","92","Kakubba ntahonderengi̱ biragiro byamu, nnaku zaku̱nzi̱ti̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS119_93","020_119_93","PSA","119","93","93","Tindyebeere ndagiiro zaamu biro byensei̱, hab̯wakubba bindeetera b̯womi. ");
INSERT INTO rub_vpl VALUES ("PS119_94","020_119_94","PSA","119","94","94","Ndi waamu, njuna, hab̯wakubba mpondera ndagiiro zaamu, ");
INSERT INTO rub_vpl VALUES ("PS119_95","020_119_95","PSA","119","95","95","Babiibi nab̯ubandaliira kunswaswana, bei̱tu̱ gya mutima gwange gwicala ha bigambu byamu. ");
INSERT INTO rub_vpl VALUES ("PS119_96","020_119_96","PSA","119","96","96","Birungi byensei̱ bili na habisambiira, bei̱tu̱ kiragiro kyamu kiicala hensei̱. ");
INSERT INTO rub_vpl VALUES ("PS119_97","020_119_97","PSA","119","97","97","Kanyegomba biragiro byamu, ka byobyo nteekerezaho kiro kyensei̱ ");
INSERT INTO rub_vpl VALUES ("PS119_98","020_119_98","PSA","119","98","98","Kiragiro kyamu kimpa magezi̱ gakukira ga banyanzigwa bange, kubba b̯wi̱re b̯wensei̱ gabba nagya. ");
INSERT INTO rub_vpl VALUES ("PS119_99","020_119_99","PSA","119","99","99","Beegesa bange bensei̱ mbansi̱nga kwetegereza, kubba bigambu byamu byobyo nteekerezaho. ");
INSERT INTO rub_vpl VALUES ("PS119_100","020_119_100","PSA","119","100","100","Kwetegereza kundi na kwo kukira kwa bagu̱lu̱u̱su̱, hab̯wakubba nkwata ndagiiro zaamu. ");
INSERT INTO rub_vpl VALUES ("PS119_101","020_119_101","PSA","119","101","101","Nyeehala kukwata muhanda gubiibi, aleke mpondere kigambu kyamu. ");
INSERT INTO rub_vpl VALUES ("PS119_102","020_119_102","PSA","119","102","102","Timpugukahuguka kuruga ha micwere myamu, kubba weewe obi̱nzegesya. ");
INSERT INTO rub_vpl VALUES ("PS119_103","020_119_103","PSA","119","103","103","Bigambu byamu ka binola, mali̱ kwo bi̱nwereerya mu kanwa kange kukira na b̯uhooki! ");
INSERT INTO rub_vpl VALUES ("PS119_104","020_119_104","PSA","119","104","104","Kwetegereza kwange kuruga mu ndagiiro zaamu, kyokyo nnobera muhanda gwensei̱ gwa b̯u̱gobya. ");
INSERT INTO rub_vpl VALUES ("PS119_105","020_119_105","PSA","119","105","105","Kigambu kyamu gili taara hali magulu gange, kandi kyererezi̱ hali muhanda gwange. ");
INSERT INTO rub_vpl VALUES ("PS119_106","020_119_106","PSA","119","106","106","Ndahi̱i̱ri̱ kandi nindagana, kukwata micwere myamu mya mananu. ");
INSERT INTO rub_vpl VALUES ("PS119_107","020_119_107","PSA","119","107","107","Ai̱ Mukama, kambwenaweeni̱, mpa b̯womi ku̱si̱gi̱ki̱ra ha kigambu kyamu. ");
INSERT INTO rub_vpl VALUES ("PS119_108","020_119_108","PSA","119","108","108","Ai̱ Mukama, ikiriza nkuhe bihongwa byange bya kukuhaariiza, kandi nzegesya micwere myamu. ");
INSERT INTO rub_vpl VALUES ("PS119_109","020_119_109","PSA","119","109","109","Biro byensei̱ nab̯unyakabba ni̱nku̱hi̱gwa, ntindyebeera biragiro byamu. ");
INSERT INTO rub_vpl VALUES ("PS119_110","020_119_110","PSA","119","110","110","Nkori̱ za bibii zintegi̱ri̱ mutegu bei̱tu̱ ndagiiro zaamu tizikandugangaho. ");
INSERT INTO rub_vpl VALUES ("PS119_111","020_119_111","PSA","119","111","111","Bigambu byamu byobyo mugab̯u gwange biro byensei̱, byobyo ku̱si̱i̱ma kwa mutima gwange. ");
INSERT INTO rub_vpl VALUES ("PS119_112","020_119_112","PSA","119","112","112","Biro byensei̱ ku̱doosya ha mmaliiro, mutima gwange gwakwatanga mateeka gaamu. ");
INSERT INTO rub_vpl VALUES ("PS119_113","020_119_113","PSA","119","113","113","Nnoba bantu bateesigwa, bei̱tu̱ nyeegomba kiragiro kyamu. ");
INSERT INTO rub_vpl VALUES ("PS119_114","020_119_114","PSA","119","114","114","Weewe b̯wi̱ru̱ki̱ro b̯wange, kandi ngab̯u gyange ku̱ni̱hi̱ra kwange kwicala mu kigambu kyamu ");
INSERT INTO rub_vpl VALUES ("PS119_115","020_119_115","PSA","119","115","115","Nywe nkori̱ za bibii, mundeke, mundeke nkwate biragiro bya Ruhanga wange. ");
INSERT INTO rub_vpl VALUES ("PS119_116","020_119_116","PSA","119","116","116","Nnsagikanga, ai̱ Mukama, nka muragu gwamu kugukoba, mwomwo ndyomeera, kandi ku̱ni̱hi̱ra kwange kutalimpemura. ");
INSERT INTO rub_vpl VALUES ("PS119_117","020_119_117","PSA","119","117","117","Nnsagikanga, aleke ncungurwe, kandi nkwatenge mateeka gaamu biro byensei̱. ");
INSERT INTO rub_vpl VALUES ("PS119_118","020_119_118","PSA","119","118","118","Ocoomera bensei̱ bahaba kuruga ha mateeka gaamu, kubba magezi̱ gaab̯u gabagobya b̯u̱gobya. ");
INSERT INTO rub_vpl VALUES ("PS119_119","020_119_119","PSA","119","119","119","Babiibi bensei̱ ba mu nsi, obawona nka bisasiro, kyokyo nyegombira bigambu byamu. ");
INSERT INTO rub_vpl VALUES ("PS119_120","020_119_120","PSA","119","120","120","Hab̯wa ku̱ku̱ti̱i̱na mubiri gwange gwegwa nigukukankana, hab̯wa micwere myamu. ");
INSERT INTO rub_vpl VALUES ("PS119_121","020_119_121","PSA","119","121","121","Nkoori̱ kya b̯winganiza kandi kya mananu, otandeka mu mikono mya banyanzigwa. ");
INSERT INTO rub_vpl VALUES ("PS119_122","020_119_122","PSA","119","122","122","Weeraga hab̯wa b̯urungi b̯wa muheereza waamu otekirizanga banyamyehembo kunjooga. ");
INSERT INTO rub_vpl VALUES ("PS119_123","020_119_123","PSA","119","123","123","Kanjwahi̱ri̱ kukanula mei̱so kulindiira kujunwa kwamu na kulindiira bi̱weeragi̱ri̱ bya b̯wesige b̯wamu. ");
INSERT INTO rub_vpl VALUES ("PS119_124","020_119_124","PSA","119","124","124","Gya muheereza waamu, nkolera ku̱si̱gi̱ki̱ra ha ngonzi zaamu zinene, onzegesye mateeka gaamu. ");
INSERT INTO rub_vpl VALUES ("PS119_125","020_119_125","PSA","119","125","125","Gya muheereza waamu, mpa kwetegereza, mwa kwega bigambu byamu. ");
INSERT INTO rub_vpl VALUES ("PS119_126","020_119_126","PSA","119","126","126","Ai̱ Mukama kaka kooko kei̱re kakukora, hab̯wakubba babi̱nyi̱ri̱ ndagiiro gyamu. ");
INSERT INTO rub_vpl VALUES ("PS119_127","020_119_127","PSA","119","127","127","Nahab̯waki̱kyo, nyeegomba biragiro byamu kukirahoona zaabbu gi̱sengeeje. ");
INSERT INTO rub_vpl VALUES ("PS119_128","020_119_128","PSA","119","128","128","Bei̱tu̱ ntwala ndagiiro zaamu zensei̱ kubba zi̱doori̱, kandi nnoba mihanda myensei̱ mya b̯u̱gobya. ");
INSERT INTO rub_vpl VALUES ("PS119_129","020_119_129","PSA","119","129","129","Bigambu byamu byamahanu, kyokyo mutima gwange gubihondera. ");
INSERT INTO rub_vpl VALUES ("PS119_130","020_119_130","PSA","119","130","130","Asoma bigambu byamu atunga kyererezi̱, kileetera ntwarwa kwetegereza. ");
INSERT INTO rub_vpl VALUES ("PS119_131","020_119_131","PSA","119","131","131","Mu kwegomba biragiro byamu, mu̱nwa gwange gu̱dokere b̯u̱dokeri̱ kubibaza. ");
INSERT INTO rub_vpl VALUES ("PS119_132","020_119_132","PSA","119","132","132","Nnzi̱rahoona, ongiire mbabazi̱, nka kwokoranga bab̯wo beegomba ibara lyamu. ");
INSERT INTO rub_vpl VALUES ("PS119_133","020_119_133","PSA","119","133","133","Onterekereeryenge magulu ku̱si̱gi̱ki̱ra ha muragu gwamu, aleke ntalifugwa kibii. ");
INSERT INTO rub_vpl VALUES ("PS119_134","020_119_134","PSA","119","134","134","Ncungura hali bab̯wo baku̱mbonawonesya, aleke mpondere ndagiiro zaamu. ");
INSERT INTO rub_vpl VALUES ("PS119_135","020_119_135","PSA","119","135","135","Omulikire gya muheereza waamu, onzegesye mateeka gaamu. ");
INSERT INTO rub_vpl VALUES ("PS119_136","020_119_136","PSA","119","136","136","Ndira b̯u̱li̱ri̱ mali̱ga hab̯wa bantu batahondera biragiro byamu. ");
INSERT INTO rub_vpl VALUES ("PS119_137","020_119_137","PSA","119","137","137","Ai̱ Mukama, kooli murungi, na micwere myamu mibba mi̱terekereru̱. ");
INSERT INTO rub_vpl VALUES ("PS119_138","020_119_138","PSA","119","138","138","Bigambu bi̱waaragi̱i̱ri̱ bibba byamananu, bibba byakwesigira ki̱mwei̱. ");
INSERT INTO rub_vpl VALUES ("PS119_139","020_119_139","PSA","119","139","139","Ndi na ki̱ni̱ga kinene, hab̯wa banyanzigwa bange kwebeera bigambu byamu. ");
INSERT INTO rub_vpl VALUES ("PS119_140","020_119_140","PSA","119","140","140","Muragu gwamu gwa mananu mali̱, kyokyo gya muheereza waamu ngwegomba. ");
INSERT INTO rub_vpl VALUES ("PS119_141","020_119_141","PSA","119","141","141","Kambe ntali wa ki̱ti̱i̱ni̱sa kandi akugaywa, bei̱tu̱ nab̯wo tindyeb̯wa ndagiiro zaamu. ");
INSERT INTO rub_vpl VALUES ("PS119_142","020_119_142","PSA","119","142","142","B̯urungi b̯wamu b̯wa biro byensei̱, kandi biragiro byamu bya mananu. ");
INSERT INTO rub_vpl VALUES ("PS119_143","020_119_143","PSA","119","143","143","Kambe na b̯ujune na kutuntura, bei̱tu̱ biragiro byamu bindeetera kusemererwa. ");
INSERT INTO rub_vpl VALUES ("PS119_144","020_119_144","PSA","119","144","144","Bigambu byamu biicala bya mananu biro byensei̱, mpa kwetegereza mwa kwomeera. ");
INSERT INTO rub_vpl VALUES ("PS119_145","020_119_145","PSA","119","145","145","Ai̱ Mukama, nkukweta na mutima gwange gwensei̱ nzi̱ramwo! Nkwi̱za kukwata mateeka gaamu. ");
INSERT INTO rub_vpl VALUES ("PS119_146","020_119_146","PSA","119","146","146","Nkukuliriira, njuna, aleke nkwate bigambu byamu. ");
INSERT INTO rub_vpl VALUES ("PS119_147","020_119_147","PSA","119","147","147","Mbyoka mambya atakasari ninkweta onjune, ku̱ni̱hi̱ra kwange kuli mu bigambu byamu. ");
INSERT INTO rub_vpl VALUES ("PS119_148","020_119_148","PSA","119","148","148","I̱jolo lyensei̱ ndaala ntebbaki̱ri̱, nintekereze ha muragu gwamu. ");
INSERT INTO rub_vpl VALUES ("PS119_149","020_119_149","PSA","119","149","149","Ai̱ Mukama, hab̯wa ngonzi zaamu zinene weegwa iraka lyange, ompe b̯womi ku̱si̱gi̱ki̱ra ha b̯winganiza b̯wamu. ");
INSERT INTO rub_vpl VALUES ("PS119_150","020_119_150","PSA","119","150","150","B̯ab̯wo banyankwe kabanyesegereerye heehi̱ na bigyendeerwa bibiibi, biragiro byamu tibabihondera. ");
INSERT INTO rub_vpl VALUES ("PS119_151","020_119_151","PSA","119","151","151","Ai̱ Mukama, kaweewe omba heehi̱, biragiro byamu byensei̱ byamananu. ");
INSERT INTO rub_vpl VALUES ("PS119_152","020_119_152","PSA","119","152","152","Kuruga kadei na kadei ninyeega bigambu byamu, nka kubiicala bya biro na biro. ");
INSERT INTO rub_vpl VALUES ("PS119_153","020_119_153","PSA","119","153","153","Wona kuwonawona kwange oncungure, kubba tindyebeera biragiro byamu. ");
INSERT INTO rub_vpl VALUES ("PS119_154","020_119_154","PSA","119","154","154","Ntonganiira oncungure, mpa b̯womi ku̱si̱gi̱ki̱ra ha muragu gwamu. ");
INSERT INTO rub_vpl VALUES ("PS119_155","020_119_155","PSA","119","155","155","Babiibi tibalijunwa, hab̯wakubba tibahondera mateeka gaamu. ");
INSERT INTO rub_vpl VALUES ("PS119_156","020_119_156","PSA","119","156","156","Ai̱ Mukama, mbabazi̱ zaamu ka za maani, mpa b̯womi ku̱si̱gi̱ki̱ra ha micwere myamu. ");
INSERT INTO rub_vpl VALUES ("PS119_157","020_119_157","PSA","119","157","157","Banyanzigwa bakumparana banene, bei̱tu̱ tindiruga hali bigambu byamu. ");
INSERT INTO rub_vpl VALUES ("PS119_158","020_119_158","PSA","119","158","158","B̯umbona bantu batakwikiririzamwo ntammwa b̯utamwa, hab̯wakubba tibahondera kigambu kyamu. ");
INSERT INTO rub_vpl VALUES ("PS119_159","020_119_159","PSA","119","159","159","Ai̱ Mukama, wona nka kunyegomba ndagiiro zaamu, mpa b̯womi hab̯wa ngonzi zaamu zinene. ");
INSERT INTO rub_vpl VALUES ("PS119_160","020_119_160","PSA","119","160","160","Bigambu byamu byensei̱ gabba mananu, na micwere myamu mirungi mya biro na biro. ");
INSERT INTO rub_vpl VALUES ("PS119_161","020_119_161","PSA","119","161","161","Balemi̱ bamparanira b̯usa, bei̱tu̱ mutima gwange gu̱ti̱i̱na bigambu byamu. ");
INSERT INTO rub_vpl VALUES ("PS119_162","020_119_162","PSA","119","162","162","Kansanyukira kigambu kyamu, nka muntu agu̱mbwi̱ri̱ kyeitungu kinyamaani. ");
INSERT INTO rub_vpl VALUES ("PS119_163","020_119_163","PSA","119","163","163","Kantamwa b̯u̱gobya, bei̱tu̱ kandi nyeegomba biragiro byamu. ");
INSERT INTO rub_vpl VALUES ("PS119_164","020_119_164","PSA","119","164","164","Nkuhaariiza mirundi musanju b̯uli kiro, hab̯wa micwere myamu mya mananu. ");
INSERT INTO rub_vpl VALUES ("PS119_165","020_119_165","PSA","119","165","165","Bab̯wo beegomba kiragiro kyamu babba na b̯u̱si̱nge b̯unene hoi̱, tihaloho kikusobora kubaleetera kukiibbala. ");
INSERT INTO rub_vpl VALUES ("PS119_166","020_119_166","PSA","119","166","166","Ai̱ Mukama, ndi na ku̱ni̱hi̱ra mu kujunwa kwamu, Nnkora biragiro byamu. ");
INSERT INTO rub_vpl VALUES ("PS119_167","020_119_167","PSA","119","167","167","Mutima gwange guhondera bigambu byamu, kubba mbyegombera ki̱mwei̱. ");
INSERT INTO rub_vpl VALUES ("PS119_168","020_119_168","PSA","119","168","168","Mmpondera ndagiiro zaamu na bigambu byamu, hab̯wakubba mihanda myange myensei̱ omyegi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS119_169","020_119_169","PSA","119","169","169","Ai̱ Mukama, leka kusaba kwange kukudwereere, ompe kwetegereza ku̱si̱gi̱ki̱ra ku kigambu kyamu. ");
INSERT INTO rub_vpl VALUES ("PS119_170","020_119_170","PSA","119","170","170","Leka kwesengereerya kwange kukudwereere, ncungura ku̱si̱gi̱ki̱ra ha muragu gwamu. ");
INSERT INTO rub_vpl VALUES ("PS119_171","020_119_171","PSA","119","171","171","Kanwa kange kaakuhaarizanga, hab̯wakubba onzegesya mateeka gaamu. ");
INSERT INTO rub_vpl VALUES ("PS119_172","020_119_172","PSA","119","172","172","Kalimi kange kahi̱i̱manga kigambu kyamu, kubba biragiro byamu byensei̱ bya mananu. ");
INSERT INTO rub_vpl VALUES ("PS119_173","020_119_173","PSA","119","173","173","Leka mukono gwamu gwetegeke kunjuna, hab̯wakubba nsi̱i̱ma ndagiiro zaamu. ");
INSERT INTO rub_vpl VALUES ("PS119_174","020_119_174","PSA","119","174","174","Ai̱ Mukama nyeegomba kujunwa kwamu, kandi biragiro byamu byobyo bimpa masanyu. ");
INSERT INTO rub_vpl VALUES ("PS119_175","020_119_175","PSA","119","175","175","Leka mutima gwange gwomeerenge, kandi gukuhaariizenge, leka micwere myamu minjunenge. ");
INSERT INTO rub_vpl VALUES ("PS119_176","020_119_176","PSA","119","176","176","Mpabi̱ri̱ nka ntaama gi̱syereeri̱, ntoolya gya muheereza waamu, kubba tinyeebeera biragiro byamu. ");
INSERT INTO rub_vpl VALUES ("PS120_1","020_120_1","PSA","120","1","1","Kyembu kya kutemba hakyendi̱. Mu b̯ujune b̯wange nyaaku̱ngi̱ri̱ Mukama, yanzi̱ramwo. ");
INSERT INTO rub_vpl VALUES ("PS120_2","020_120_2","PSA","120","2","2","Ai̱ Mukama, ncungura hali babaza b̯u̱gobya, kandi bakacwa makuru. ");
INSERT INTO rub_vpl VALUES ("PS120_3","020_120_3","PSA","120","3","3","We ngobya we, olikolwa kyani? Mucwa makuru we, olidweb̯waho kyani? ");
INSERT INTO rub_vpl VALUES ("PS120_4","020_120_4","PSA","120","4","4","Olifubirwa mbasi gya mu̱lwani̱, olihembwaho makala ga mworo. ");
INSERT INTO rub_vpl VALUES ("PS120_5","020_120_5","PSA","120","5","5","Kamboneweeni̱ gya b̯u̱nyagonyeeri̱ mu Meseki̱, nyei̱cala mu heema gya Kedara! ");
INSERT INTO rub_vpl VALUES ("PS120_6","020_120_6","PSA","120","6","6","Kasu̱mi̱ kanene kamaari ninkwicala na batendya b̯u̱si̱nge. ");
INSERT INTO rub_vpl VALUES ("PS120_7","020_120_7","PSA","120","7","7","Nyendya b̯u̱si̱nge, bei̱tu̱ b̯ubaza nibatara b̯ulemu. ");
INSERT INTO rub_vpl VALUES ("PS121_1","020_121_1","PSA","121","1","1","Kyembu kya kutemba hakyendi̱. Mei̱so gange gali̱ngi̱ri̱i̱ri̱ ha lusahu. Kujunwa kwange kuruga hanya? ");
INSERT INTO rub_vpl VALUES ("PS121_2","020_121_2","PSA","121","2","2","Kujunwa kwange kuruga hali Mukama, munyakuhanga iguru na nsi. ");
INSERT INTO rub_vpl VALUES ("PS121_3","020_121_3","PSA","121","3","3","Talikuleka ku̱gwa, yogwo akulinda tahongera. ");
INSERT INTO rub_vpl VALUES ("PS121_4","020_121_4","PSA","121","4","4","Mu mananu, yogwo alinda I̱saleeri̱ tahongera kandi tiyeebbaka. ");
INSERT INTO rub_vpl VALUES ("PS121_5","020_121_5","PSA","121","5","5","Mukama yooyo akulinda, Mukama yooyo mu̱tu̱ntu̱lu̱ ha mukono gwamu gwab̯udyo. ");
INSERT INTO rub_vpl VALUES ("PS121_6","020_121_6","PSA","121","6","6","Lyoba tilili kuhutaaza mwinsi kadi gubbe mweri̱ i̱jolo. ");
INSERT INTO rub_vpl VALUES ("PS121_7","020_121_7","PSA","121","7","7","Mukama yaakulindanga hali bibiibi byensei̱ yaalinda b̯womi b̯wamu. ");
INSERT INTO rub_vpl VALUES ("PS121_8","020_121_8","PSA","121","8","8","Mukama yaalindanga magyendere gaamu na mei̱ri̱re gaamu, kuruga hataati̱ na biro byensei̱. ");
INSERT INTO rub_vpl VALUES ("PS122_1","020_122_1","PSA","122","1","1","Kyembu kya kutemba hakyendi̱. Zabbu̱li̱ gya Dau̱di̱. Nyaasemereerwe b̯u̱bambwereeri̱ yati, “Tugyende mu nnyu̱mba gya Mukama!” ");
INSERT INTO rub_vpl VALUES ("PS122_2","020_122_2","PSA","122","2","2","Ai̱ Yeru̱salemu̱, magulu geetu̱ gemereeri̱ mwirembu lyamu! ");
INSERT INTO rub_vpl VALUES ("PS122_3","020_122_3","PSA","122","3","3","Yeru̱salemu̱ lwolwo rub̯uga lu̱nyaku̱bi̱mbwa hamwei̱ lunyamaani. ");
INSERT INTO rub_vpl VALUES ("PS122_4","020_122_4","PSA","122","4","4","Hali nganda zigyenda hakyendi̱, nganda za Mukama, nka ku kyateebeerweho hali I̱saleeri̱ kuhaariiza ibara lya Mukama. ");
INSERT INTO rub_vpl VALUES ("PS122_5","020_122_5","PSA","122","5","5","Ku̱kwo hooho baateeri̱ bitebe bya kucwera Bei̱saleeri̱ misangu, mu b̯ukama b̯wa Dau̱di̱. ");
INSERT INTO rub_vpl VALUES ("PS122_6","020_122_6","PSA","122","6","6","Musabire Yeru̱salemu̱ gitunge b̯u̱si̱nge, “Baabbanga na mu̱gi̱sa baakwendya! ");
INSERT INTO rub_vpl VALUES ("PS122_7","020_122_7","PSA","122","7","7","B̯u̱si̱nge b̯wabbanga mu bi̱si̱i̱ka byamu, na byakwerinda mu biikaru byamu bya maani.” ");
INSERT INTO rub_vpl VALUES ("PS122_8","020_122_8","PSA","122","8","8","Hab̯wa bantu na banywani bange, ndiweera Yeru̱salemu̱ yati, “B̯u̱si̱nge b̯ubbe na nywe!” ");
INSERT INTO rub_vpl VALUES ("PS122_9","020_122_9","PSA","122","9","9","Hab̯wa nnyu̱mba gya Mukama Ruhanga weetu̱, nkukusabira mu̱gi̱sa. ");
INSERT INTO rub_vpl VALUES ("PS123_1","020_123_1","PSA","123","1","1","Kyembu kya kutemba hakyendi̱. Hali weewe, mei̱so gange hooho gali̱ngi̱li̱ri̱i̱ri̱, weewe ei̱cali̱i̱ri̱ kitebekya b̯ukama mwiguru! ");
INSERT INTO rub_vpl VALUES ("PS123_2","020_123_2","PSA","123","2","2","Nka mei̱so ga baheereza, ku̱gali̱ngi̱ri̱i̱ri̱ ngalu za Mukama waab̯u, nka mei̱so ga muzaana kugeicala gali̱ngi̱ri̱i̱ri̱ ngalu za mukama waamwe, kwokwo mei̱so geetu̱ galingiira Mukama weetu̱ Ruhanga, ku̱doosya yaakatukwatirwa mbabazi̱. ");
INSERT INTO rub_vpl VALUES ("PS123_3","020_123_3","PSA","123","3","3","Ai̱ Mukama, tu̱gi̱i̱re mbabazi̱, tu̱gi̱i̱re mbabazi̱ hab̯wakubba batu̱cookoi̱ze hoi̱. ");
INSERT INTO rub_vpl VALUES ("PS123_4","020_123_4","PSA","123","4","4","B̯ujune b̯unene b̯utuli nab̯wo hab̯wa ku̱du̱u̱li̱ra kwa bagu̱u̱da, na mugayo gwa banyamyehembu. ");
INSERT INTO rub_vpl VALUES ("PS124_1","020_124_1","PSA","124","1","1","Kyembu kya kutemba hakyendi̱. Zabbu̱li̱ gya Dau̱di̱. Kabbengi̱ ataali Mukama yooyo kubba ha rubaju lwetu̱, leka I̱saleeri̱ hataati̱ gibaze, ");
INSERT INTO rub_vpl VALUES ("PS124_2","020_124_2","PSA","124","2","2","“Kabbengi̱ Mukama ataali ha rubaju lwetu̱, banyanzigwa b̯u̱batu̱ru̱mbi̱ri̱, ");
INSERT INTO rub_vpl VALUES ("PS124_3","020_124_3","PSA","124","3","3","bakatu̱zi̱ki̱i̱rye, hab̯wa ki̱ni̱ga kyab̯u kinene hali twe. ");
INSERT INTO rub_vpl VALUES ("PS124_4","020_124_4","PSA","124","4","4","Mwomwo mwizulo gwakutumaari twensei̱, hab̯wa meezi̱ kutumera, ");
INSERT INTO rub_vpl VALUES ("PS124_5","020_124_5","PSA","124","5","5","na bijanga byaku̱tu̱ku̱ti̱ri̱, nibitubbumba.” ");
INSERT INTO rub_vpl VALUES ("PS124_6","020_124_6","PSA","124","6","6","Mukama ahaariizwe, atatu̱heeri̱yo, mu meino ga banyanzigwa. ");
INSERT INTO rub_vpl VALUES ("PS124_7","020_124_7","PSA","124","7","7","Tu̱keni̱ri̱ nka nnyoni̱, gi̱tesu̱ki̱ri̱ mu mutegu gwa mu̱hi̱gi̱, mutegu gu̱kadu̱ki̱i̱ri̱ twahona! ");
INSERT INTO rub_vpl VALUES ("PS124_8","020_124_8","PSA","124","8","8","Kujunwa kwetu̱ kuruga mwibara lya Mukama, munyakuhanga iguru na nsi. ");
INSERT INTO rub_vpl VALUES ("PS125_1","020_125_1","PSA","125","1","1","Kyembu kya kutemba hakyendi̱. Bab̯wo beesiga Mukama, beisana lusahu Sayu̱u̱ni̱, lu̱tazi̱ngi̱zi̱ka bei̱tu̱ lwicalaho biro na biro. ");
INSERT INTO rub_vpl VALUES ("PS125_2","020_125_2","PSA","125","2","2","Nsahu nka ku̱zelogoleerye Yeru̱salemu̱, kwokwo Mukama yeelogoleeryanga bantu baamwe, kuruga hataati̱ na biro na biro. ");
INSERT INTO rub_vpl VALUES ("PS125_3","020_125_3","PSA","125","3","3","Babiibi tibalilema nsi gya barungi, b̯ubali balema, na barungi, balyezagya nibakukora bibiibi. ");
INSERT INTO rub_vpl VALUES ("PS125_4","020_125_4","PSA","125","4","4","Ai̱ Mukama, kolera barungi birungi, na bab̯wo bali beesigwa mu mitima myab̯u. ");
INSERT INTO rub_vpl VALUES ("PS125_5","020_125_5","PSA","125","5","5","Bei̱tu̱ bahabi̱ri̱ mu mihanda mibiibi, Mukama ali̱bazi̱kya hamwe na nkori̱ za bibiibi, B̯u̱si̱nge b̯ubbe mwʼI̱saleeri̱. ");
INSERT INTO rub_vpl VALUES ("PS126_1","020_126_1","PSA","126","1","1","Kyembu kya kutemba hakyendi̱. Mukama b̯u̱yaacu̱ngwi̱ri̱ banyansi ba mu Sayu̱u̱ni̱ kuruga mu b̯unyagwa, twei̱sanengi̱ nka bakuloota. ");
INSERT INTO rub_vpl VALUES ("PS126_2","020_126_2","PSA","126","2","2","Twasemererwe hoi̱, twahi̱i̱ma byembu neisanyu linene, mwomwo banyamahanga bakoba yati, “Mukama abakoleeri̱ byamaani.” ");
INSERT INTO rub_vpl VALUES ("PS126_3","020_126_3","PSA","126","3","3","Mukama atu̱koleeri̱ byamaani, tu̱semereerwe hoi̱. ");
INSERT INTO rub_vpl VALUES ("PS126_4","020_126_4","PSA","126","4","4","Ai̱ Mukama, tu̱he mu̱gi̱sa, nka ndagali̱ b̯ugiirya meezi̱ mu migira myomi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS126_5","020_126_5","PSA","126","5","5","Balisiga nibakulira, balikesa mu kusemererwa! ");
INSERT INTO rub_vpl VALUES ("PS126_6","020_126_6","PSA","126","6","6","Aligyenda naalira yeetweki̱ri̱ nsigo gya kusimba, ali̱i̱ra kwamu̱gi̱ na kusemererwa, yeetweki̱ri̱ byakesi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS127_1","020_127_1","PSA","127","1","1","Kyembu kya kutemba hakyendi̱. Zabbu̱li̱ gya Sulumaani. Mukama, waatabi̱mba nnyu̱mba, baku̱gi̱bi̱mba bagadira b̯usa. Mukama waatalinda rub̯uga, bali̱ndi̱ balindira b̯usa. ");
INSERT INTO rub_vpl VALUES ("PS127_2","020_127_2","PSA","127","2","2","Mugadira b̯usa ku̱zi̱ndu̱ka karei, kulaala itumbi, ku̱tu̱u̱ya kukoora bidyo, bei̱tu̱ Mukama bakwendya abaha bibakwetaaga baleeri̱. ");
INSERT INTO rub_vpl VALUES ("PS127_3","020_127_3","PSA","127","3","3","Mu mananu baana kili kisembu kuruga hali Mukama, baana gili mpeera kuruga hali Mukama. ");
INSERT INTO rub_vpl VALUES ("PS127_4","020_127_4","PSA","127","4","4","Nka mbasi mu ngalu za mu̱lwani̱, bali baana ba muntu abyala mu b̯usigazi b̯wamwe. ");
INSERT INTO rub_vpl VALUES ("PS127_5","020_127_5","PSA","127","5","5","Ali na mu̱gi̱sa, wa nsahu gye gi̱i̱zwi̱ri̱ mbasi, talikwatwa nsoni̱ kwemeera mwirembu, nab̯wali̱ru̱mbwa banyanzigwa baamwe. ");
INSERT INTO rub_vpl VALUES ("PS128_1","020_128_1","PSA","128","1","1","Kyembu kya kutemba hakyendi̱. Ali na mu̱gi̱sa atamwo Mukama ki̱ti̱i̱ni̱sa, akora bya Mukama bi̱yendya! ");
INSERT INTO rub_vpl VALUES ("PS128_2","020_128_2","PSA","128","2","2","Olidya ha bijuma bya ntu̱u̱yo zaamu, olibba wa mu̱gi̱sa kandi oli̱si̱ngu̱ra. ");
INSERT INTO rub_vpl VALUES ("PS128_3","020_128_3","PSA","128","3","3","Mu̱kali̱ waamu alibba nka mu̱zabbi̱bbu̱ guwa byana mu nnyu̱mba gyamu, nka mu̱zayi̱tu̱u̱ni̱ gu̱sogi̱ri̱ kwokwo baana baamu balibba ba maani ha meeza gyamu. ");
INSERT INTO rub_vpl VALUES ("PS128_4","020_128_4","PSA","128","4","4","Mu mananu kwokwo aliheeb̯wa mu̱gi̱sa, yogwo atamwo Mukama ki̱ti̱i̱ni̱sa. ");
INSERT INTO rub_vpl VALUES ("PS128_5","020_128_5","PSA","128","5","5","Mukama akuhenge mu̱gi̱sa mu Sayu̱u̱ni̱, woomeeranga kuwona mi̱gi̱sa mya Yeru̱salemu̱. ");
INSERT INTO rub_vpl VALUES ("PS128_6","020_128_6","PSA","128","6","6","Woomeeranga kuwona baana ba baana baamu, b̯u̱si̱nge b̯ubbe hali I̱saleeri̱! ");
INSERT INTO rub_vpl VALUES ("PS129_1","020_129_1","PSA","129","1","1","Kyembu kya kutemba hakyendi̱. “Kuruga mu b̯uto b̯wange bambonab̯woneserye hoi̱,” leka I̱saleeri̱ gibaze yati, ");
INSERT INTO rub_vpl VALUES ("PS129_2","020_129_2","PSA","129","2","2","“Bambonawoneseerye hoi̱ kuruga mu b̯uto b̯wange, bei̱tu̱ batakansi̱ngu̱re. ");
INSERT INTO rub_vpl VALUES ("PS129_3","020_129_3","PSA","129","3","3","Baasari̱ bihote ha mugongo gwange, kandi bagufoora nka musiri gubali̱mi̱ri̱mwo.” ");
INSERT INTO rub_vpl VALUES ("PS129_4","020_129_4","PSA","129","4","4","Mukama murungi, asaari̱ miguha mya babiibi, yancungura. ");
INSERT INTO rub_vpl VALUES ("PS129_5","020_129_5","PSA","129","5","5","Leka bensei̱ banyakunoba Sayu̱u̱ni̱, basingurwe kandi basware! ");
INSERT INTO rub_vpl VALUES ("PS129_6","020_129_6","PSA","129","6","6","Leka beisane nka mutala gwa ha kasolya ka nnyu̱mba, gu̱hotoka gu̱takahandi̱ri̱, ");
INSERT INTO rub_vpl VALUES ("PS129_7","020_129_7","PSA","129","7","7","mwi̱hi̱ra gu̱gwo mutala tasobora kugukwata mu ngalu, habbe kugubboha mutwaru, ");
INSERT INTO rub_vpl VALUES ("PS129_8","020_129_8","PSA","129","8","8","kandi na bakurabaho tibasobora kukoba, “Mu̱gi̱sa gwa Mukama gubbe nawe. Tukukusabira mu̱gi̱sa mwibara lya Mukama!” ");
INSERT INTO rub_vpl VALUES ("PS130_1","020_130_1","PSA","130","1","1","Kyembu kya kutemba hakyendi̱. Ai̱ Mukama, nka kundi mu b̯ujune b̯unene, nku̱kwesengereerye. ");
INSERT INTO rub_vpl VALUES ("PS130_2","020_130_2","PSA","130","2","2","Ai̱ Mukama, weegwa iraka lyange! Ontegere mapokopo gaamu geetegerye iraka lyange ninkukusaba! ");
INSERT INTO rub_vpl VALUES ("PS130_3","020_130_3","PSA","130","3","3","Ai̱ Mukama, obbe waahondekerengi̱ bibii byetu̱, naani yaakasobora kwemeera mu mei̱so gaamu? ");
INSERT INTO rub_vpl VALUES ("PS130_4","020_130_4","PSA","130","4","4","Bei̱tu̱ weewe otuganyira mwa kukutangamwo ki̱ti̱i̱ni̱sa. ");
INSERT INTO rub_vpl VALUES ("PS130_5","020_130_5","PSA","130","5","5","Ncala nindindiira Mukama, mutima gwange gwamulindiiranga, na kigambu kyamwe nkukyesiga, ");
INSERT INTO rub_vpl VALUES ("PS130_6","020_130_6","PSA","130","6","6","mutima gwange gwalindiranga Mukama, nka mu̱li̱ndi̱ kwalinda b̯wi̱re kukya, na kukirahoona mu̱li̱ndi̱ kwalinda b̯wi̱re kukya. ");
INSERT INTO rub_vpl VALUES ("PS130_7","020_130_7","PSA","130","7","7","Ai̱ I̱saleeri̱, weesiganga Mukama! Hab̯wakubba Mukama abba wa ngonzi zinene, naakucungura kwamwe kubba kwa biribiri. ");
INSERT INTO rub_vpl VALUES ("PS130_8","020_130_8","PSA","130","8","8","Kandi alicungura Bei̱saleeri̱, abatoolehoona bibii byab̯u byensei̱. ");
INSERT INTO rub_vpl VALUES ("PS131_1","020_131_1","PSA","131","1","1","Kyembu kya kutemba hakyendi̱ kya Dau̱di̱. Ai̱ MUKAMA, mutima gwange tigugira myesungo, na mei̱so gange tigagira myehembu, Ti̱nyeetembatembya rundi kwesengasenga. ");
INSERT INTO rub_vpl VALUES ("PS131_2","020_131_2","PSA","131","2","2","Bei̱tu̱ mwozo gwange gu̱teekanu̱ kandi gu̱holu̱, nka mwana ateekei̱ni̱ heibiiri lya mmaawe, nteekei̱ni̱ nka mwana gi̱bacu̱kwi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS131_3","020_131_3","PSA","131","3","3","We, I̱saleeri̱, kuruga hataati̱ na biro byensei̱, obbenge na ku̱ni̱hi̱ra mu Mukama. ");
INSERT INTO rub_vpl VALUES ("PS132_1","020_132_1","PSA","132","1","1","Kyembu kya kutemba hakyendi̱. Ai̱ Mukama, otalyebeera byensei̱ bya Dau̱di̱ bi̱yaawonaweeni̱, ");
INSERT INTO rub_vpl VALUES ("PS132_2","020_132_2","PSA","132","2","2","nka ku̱yeeragi̱ri̱ hali Mukama yaarahira hali Ruhanga Waamaani wa Yakobbo naakoba yati, ");
INSERT INTO rub_vpl VALUES ("PS132_3","020_132_3","PSA","132","3","3","“Tindigyenda mu nnyu̱mba gyange habbe kulaala mu kitabbu kyange, ");
INSERT INTO rub_vpl VALUES ("PS132_4","020_132_4","PSA","132","4","4","tindyebbaka, habbe kuta b̯ulo mu mei̱so, ");
INSERT INTO rub_vpl VALUES ("PS132_5","020_132_5","PSA","132","5","5","ku̱doosya b̯unditungira Mukama kiikaru, hali Waamaani wa Yakobbo aliicaara.” ");
INSERT INTO rub_vpl VALUES ("PS132_6","020_132_6","PSA","132","6","6","Twegwi̱ri̱ho ku Sandu̱u̱ko gya ndagaanu mu Efu̱raati̱, twagyagi̱i̱rye mu misiri mya Yaara. ");
INSERT INTO rub_vpl VALUES ("PS132_7","020_132_7","PSA","132","7","7","Twakoba yati, “Katugyenda mu kiikaru kyamwe hali eicala, tu̱ramye hansi wa katebe ka magulu gaamwe!” ");
INSERT INTO rub_vpl VALUES ("PS132_8","020_132_8","PSA","132","8","8","Ai̱ Mukama, i̱za cali ohuumulira, uwe na Sandu̱u̱ko gya Ndagaanu, kaboneru ka maani gaamu. ");
INSERT INTO rub_vpl VALUES ("PS132_9","020_132_9","PSA","132","9","9","Leka balaami̱ baamu balwalenge mananu, na beesigwa baamu baami̱i̱ryenge kusemererwa. ");
INSERT INTO rub_vpl VALUES ("PS132_10","020_132_10","PSA","132","10","10","Hab̯wa muheereza waamu Dau̱di̱, otalisuula mutongoole waamu. ");
INSERT INTO rub_vpl VALUES ("PS132_11","020_132_11","PSA","132","11","11","Mukama yaarahi̱ri̱i̱ri̱ Dau̱di̱ kirahiro kya mananu kyatalihindula, naakoba yati: “Omwei̱ ha baana baamu boonyi̱ni̱ ndimuta ha kitebe kyamu kya b̯ukama. ");
INSERT INTO rub_vpl VALUES ("PS132_12","020_132_12","PSA","132","12","12","Batabani̱ baamu b̯ubalilinda ndagaanu gyange na bigambu byange bindibeegeesya, na batabani̱ baab̯u de baliicaara ha kitebe kyamu biro byensei̱.” ");
INSERT INTO rub_vpl VALUES ("PS132_13","020_132_13","PSA","132","13","13","Hab̯wakubba Mukama yeekomeeri̱mwo Sayu̱u̱ni̱, yaagyegombira ki̱mwei̱ kugiicalamwo, ");
INSERT INTO rub_vpl VALUES ("PS132_14","020_132_14","PSA","132","14","14","“Kiki kyokyo kiikaru kinyahuumulirangamwo biro byensei̱, hab̯wakubba nkyendeerye, hooho nyeicalanga. ");
INSERT INTO rub_vpl VALUES ("PS132_15","020_132_15","PSA","132","15","15","Ndi̱kanyi̱sya bilimwa byakyo, banaku baayo ndibaha kwicuta. ");
INSERT INTO rub_vpl VALUES ("PS132_16","020_132_16","PSA","132","16","16","Balaami̱ baayo nyabalwalyanga kujunwa, beesigwa baayo bahi̱i̱manga nibakusemererwa na mi̱zi̱ra. ");
INSERT INTO rub_vpl VALUES ("PS132_17","020_132_17","PSA","132","17","17","B̯ukama b̯wa Dau̱di̱ ndib̯ufoora wamaani, mutongoole wange abbe nka taara. ");
INSERT INTO rub_vpl VALUES ("PS132_18","020_132_18","PSA","132","18","18","Banyanzigwa baamwe ndi̱bakwati̱sya nsoni̱, bei̱tu̱ b̯ukama b̯wamwe b̯weicalanga na mu̱gi̱sa, nib̯ugaliha.” ");
INSERT INTO rub_vpl VALUES ("PS133_1","020_133_1","PSA","133","1","1","Kyembu kya kutemba hakyendi̱. Zabbu̱li̱ gya Dau̱di̱. Muwone, kakirungi kandi kyakusemererwa bantu ba Ruhanga b̯ubeicala mu b̯u̱mwei̱! ");
INSERT INTO rub_vpl VALUES ("PS133_2","020_133_2","PSA","133","2","2","Kiisana maku̱ta ga muhendu gunene gababbwomi̱ri̱ ha mu̱twe, nigakasorodoka ha mu̱leju̱, ha mu̱leju̱ gwa Alooni̱, nigasorodoka ha ki̱togi̱ kya kilwalu kyamwe! ");
INSERT INTO rub_vpl VALUES ("PS133_3","020_133_3","PSA","133","3","3","Kiisana lu̱me lwa Hamoni̱, lu̱gwi̱ri̱ ha lusahu Sayu̱u̱ni̱! Ku̱kwo hooho Mukama aragani̱si̱i̱rye kugaba mu̱gi̱sa gwa b̯womi, b̯womi b̯wa biro byensei̱. ");
INSERT INTO rub_vpl VALUES ("PS134_1","020_134_1","PSA","134","1","1","Kyembu kya kutemba hakyendi̱. Mwi̱ze, muhaariize Mukama, nywe nywensei̱ baheereza baamwe, bamuheereza i̱jolo mu nnyu̱mba gya Mukama! ");
INSERT INTO rub_vpl VALUES ("PS134_2","020_134_2","PSA","134","2","2","Mu̱byokye mikono myenyu̱ ha kiikaru ki̱syanu̱, muhaariize Mukama. ");
INSERT INTO rub_vpl VALUES ("PS134_3","020_134_3","PSA","134","3","3","Mukama munyakuhanga iguru na nsi, akuhe mu̱gi̱sa kuruga Sayu̱u̱ni̱! ");
INSERT INTO rub_vpl VALUES ("PS135_1","020_135_1","PSA","135","1","1","Haari̱i̱ze Mukama! Haari̱i̱ze ibara lya Mukama, mu̱mu̱haari̱i̱ze nywe baheereza ba Mukama, ");
INSERT INTO rub_vpl VALUES ("PS135_2","020_135_2","PSA","135","2","2","nywe bab̯wo beemeera mu nnyu̱mba gya Mukama, mu zi̱gati̱ gya nnyu̱mba gya Ruhanga weetu̱! ");
INSERT INTO rub_vpl VALUES ("PS135_3","020_135_3","PSA","135","3","3","Haari̱i̱ze Mukama, kubba Mukama abba murungi, mu̱ku̱gi̱ze ibara lyamwe, hab̯wakubba wa mbabazi̱! ");
INSERT INTO rub_vpl VALUES ("PS135_4","020_135_4","PSA","135","4","4","Mukama yeekomeeri̱ yankei Yakobbo, I̱saleeri̱ abbe waamwe yankei. ");
INSERT INTO rub_vpl VALUES ("PS135_5","020_135_5","PSA","135","5","5","Kiki nkyegi̱ri̱ nti, Mukama wamaani, kandi nti Mukama weetu̱ akira baruhanga bensei̱. ");
INSERT INTO rub_vpl VALUES ("PS135_6","020_135_6","PSA","135","6","6","B̯uli kyensei̱ kya Mukama ki̱yendya kukora mwiguru na ha nsi akikora b̯u̱kori̱, mwitaka na mu ndi̱ha. ");
INSERT INTO rub_vpl VALUES ("PS135_7","020_135_7","PSA","135","7","7","Yooyo aragira bikaka biruge ha mmaliriro gya nsi. Yooyo aha nkuba kubbwatuka mu ndagali̱ kandi yooyo aleeta mpehu kuruga mwibiikiro lyamwe. ");
INSERT INTO rub_vpl VALUES ("PS135_8","020_135_8","PSA","135","8","8","Yooyo yei̱ti̱ri̱ mi̱zegei̱zo mya Mi̱si̱ri̱, myensei̱ mya bantu na bisolo, ");
INSERT INTO rub_vpl VALUES ("PS135_9","020_135_9","PSA","135","9","9","muli weewe, Mi̱si̱ri̱, hooho yaasi̱ndi̱ki̱ri̱ b̯uwoneru na byamahanu, naakufubira Faraaho na baheereza baamwe. ");
INSERT INTO rub_vpl VALUES ("PS135_10","020_135_10","PSA","135","10","10","Yaazi̱ki̱i̱rye mahanga ganene, yei̱ta bakama bamaani nka, ");
INSERT INTO rub_vpl VALUES ("PS135_11","020_135_11","PSA","135","11","11","Si̱honi̱, mukama wʼAbamooli̱, Ogi̱, mukama wa Bbasaani̱, na bakama bensei̱ ba Kanaani̱, ");
INSERT INTO rub_vpl VALUES ("PS135_12","020_135_12","PSA","135","12","12","yaahayo nsi gyab̯u nka mugab̯u, yaagi̱heeri̱yo nka mugab̯u hali bantu baamwe Bei̱saleeri̱. ");
INSERT INTO rub_vpl VALUES ("PS135_13","020_135_13","PSA","135","13","13","Ibara lyamu, ai̱ Mukama, lya biro na biro kaku̱u̱mi̱i̱re kaamu, ai̱ Mukama, kabbangaho biro na biro. ");
INSERT INTO rub_vpl VALUES ("PS135_14","020_135_14","PSA","135","14","14","Kubba Mukama alitoolaho bantu baamwe musangu, kandi baheereza baamwe alibagiira mbabazi̱. ");
INSERT INTO rub_vpl VALUES ("PS135_15","020_135_15","PSA","135","15","15","Bi̱si̱sani̱ bya mahanga bi̱baramya bib̯umbe kuruga mu feeza na zaabbu, bikorwa b̯ukorwa mikono mya bantu. ");
INSERT INTO rub_vpl VALUES ("PS135_16","020_135_16","PSA","135","16","16","Bili na mi̱nwa, bei̱tu̱ tibibaza, bili na mei̱so, bei̱tu̱ tibiwona. ");
INSERT INTO rub_vpl VALUES ("PS135_17","020_135_17","PSA","135","17","17","Bili na mapokopo, bei̱tu̱ ti̱byegwa, habbe kubba na rwoya mu mi̱nwa myab̯u. ");
INSERT INTO rub_vpl VALUES ("PS135_18","020_135_18","PSA","135","18","18","Bab̯wo babikora nabo kwokwo beisana, na bab̯wo bensei̱ babyesiga kwokwo bali. ");
INSERT INTO rub_vpl VALUES ("PS135_19","020_135_19","PSA","135","19","19","Nywe ba nnyu̱mba gyʼI̱saleeri̱, mu̱haari̱i̱ze Mukama! Nywe ba nnyu̱mba gyʼAlooni̱, mu̱haari̱i̱ze Mukama! ");
INSERT INTO rub_vpl VALUES ("PS135_20","020_135_20","PSA","135","20","20","Nywe ba nnyu̱mba gya Leevi̱, mu̱haari̱i̱ze Mukama! Nywe batamwo Mukama ki̱ti̱i̱ni̱sa, mu̱haari̱i̱ze Mukama! ");
INSERT INTO rub_vpl VALUES ("PS135_21","020_135_21","PSA","135","21","21","Mukama ahaariizwe mu Sayu̱u̱ni̱, yogwo eicala mu Yeru̱salemu̱! Haari̱i̱ze Mukama. ");
INSERT INTO rub_vpl VALUES ("PS136_1","020_136_1","PSA","136","1","1","Mu̱si̱i̱me Mukama, kubba murungi, kubba ngonzi zaamwe zinene za biro na biro. ");
INSERT INTO rub_vpl VALUES ("PS136_2","020_136_2","PSA","136","2","2","Mu̱si̱i̱me Ruhanga wa baruhanga, kubba ngonzi zaamwe zinene za biro na biro. ");
INSERT INTO rub_vpl VALUES ("PS136_3","020_136_3","PSA","136","3","3","Mu̱si̱i̱me Mukama wa bakama, kubba ngonzi zaamwe zinene za biro na biro. ");
INSERT INTO rub_vpl VALUES ("PS136_4","020_136_4","PSA","136","4","4","Yooyo yankei akora byamaani, bikuhuniriza, kubba ngonzi zaamwe zinene za biro na biro, ");
INSERT INTO rub_vpl VALUES ("PS136_5","020_136_5","PSA","136","5","5","hab̯wa magezi̱ gaamwe yaakoori̱ iguru, kubba ngonzi zaamwe zinene za biro na biro, ");
INSERT INTO rub_vpl VALUES ("PS136_6","020_136_6","PSA","136","6","6","munyakutandaaza nsi ku meezi̱, kubba ngonzi zaamwe zinene za biro na biro, ");
INSERT INTO rub_vpl VALUES ("PS136_7","020_136_7","PSA","136","7","7","yooyo yaakoori̱ bimuluka bya mwiguru byamaani, kubba ngonzi zaamwe zinene za biro na biro, ");
INSERT INTO rub_vpl VALUES ("PS136_8","020_136_8","PSA","136","8","8","lyoba lilemenge mwinsi, kubba ngonzi zaamwe zinene za biro na biro, ");
INSERT INTO rub_vpl VALUES ("PS136_9","020_136_9","PSA","136","9","9","mweri̱ na nzota bilemenge b̯wi̱re b̯wei̱jolo, kubba ngonzi zaamwe zinene za biro na biro. ");
INSERT INTO rub_vpl VALUES ("PS136_10","020_136_10","PSA","136","10","10","Ruhanga yogwo mu̱nyakwi̱ta mi̱zegei̱zo mya Mi̱si̱ri̱, kubba ngonzi zaamwe zinene za biro na biro, ");
INSERT INTO rub_vpl VALUES ("PS136_11","020_136_11","PSA","136","11","11","yaatoori̱ Bei̱saleeri̱ hakati̱ gya Mi̱si̱ri̱, kubba ngonzi zaamwe zinene za biro na biro, ");
INSERT INTO rub_vpl VALUES ("PS136_12","020_136_12","PSA","136","12","12","na ngalu gya maani na mukono gwa b̯u̱sobozi̱, kubba ngonzi zaamwe zinene za biro na biro, ");
INSERT INTO rub_vpl VALUES ("PS136_13","020_136_13","PSA","136","13","13","yooyo mu̱nyaku̱bagani̱amwo habiri Itaka Lyengu̱, kubba ngonzi zaamwe zinene za biro na biro, ");
INSERT INTO rub_vpl VALUES ("PS136_14","020_136_14","PSA","136","14","14","yaarabi̱i̱rye Bei̱saleeri̱ hakati̱ weitaka, kubba ngonzi zaamwe zinene za biro na biro, ");
INSERT INTO rub_vpl VALUES ("PS136_15","020_136_15","PSA","136","15","15","bei̱tu̱ yaazi̱ki̱i̱rye Faraaho na mahe gaamwe mwʼItaka Lyengu̱, kubba ngonzi zaamwe zinene za biro na biro, ");
INSERT INTO rub_vpl VALUES ("PS136_16","020_136_16","PSA","136","16","16","yooyo munyakwebembera bantu baamwe yaabarabya mwirungu, kubba ngonzi zaamwe zinene za biro na biro. ");
INSERT INTO rub_vpl VALUES ("PS136_17","020_136_17","PSA","136","17","17","Yaatematemi̱ri̱ bakama ba b̯u̱sobozi̱, kubba ngonzi zaamwe zinene za biro na biro, ");
INSERT INTO rub_vpl VALUES ("PS136_18","020_136_18","PSA","136","18","18","yei̱ta bakama ba maani hoi̱, kubba ngonzi zaamwe zinene za biro na biro, ");
INSERT INTO rub_vpl VALUES ("PS136_19","020_136_19","PSA","136","19","19","Si̱honi̱, mukama wa Bamooli̱, kubba ngonzi zaamwe zinene za biro na biro, ");
INSERT INTO rub_vpl VALUES ("PS136_20","020_136_20","PSA","136","20","20","na Ogi̱, mukama wa Bbasaani̱, kubba ngonzi zaamwe zinene za biro na biro, ");
INSERT INTO rub_vpl VALUES ("PS136_21","020_136_21","PSA","136","21","21","nsi gyab̯u yaagi̱gabi̱ri̱ nka mugab̯u, kubba ngonzi zaamwe zinene za biro na biro, ");
INSERT INTO rub_vpl VALUES ("PS136_22","020_136_22","PSA","136","22","22","mugab̯u hali muheereza waamwe, I̱saleeri̱, kubba ngonzi zaamwe zinene za biro na biro. ");
INSERT INTO rub_vpl VALUES ("PS136_23","020_136_23","PSA","136","23","23","Yooyo mu̱nyaku̱twi̱zu̱ka mu b̯uceke b̯wetu̱, kubba ngonzi zaamwe zinene za biro na biro, ");
INSERT INTO rub_vpl VALUES ("PS136_24","020_136_24","PSA","136","24","24","yaatujuna hali banyanzigwa beetu̱, kubba ngonzi zaamwe zinene za biro na biro, ");
INSERT INTO rub_vpl VALUES ("PS136_25","020_136_25","PSA","136","25","25","yooyo aha bi̱hangi̱rwe byensei̱ bili na b̯womi bidyo, kubba ngonzi zaamwe zinene za biro na biro. ");
INSERT INTO rub_vpl VALUES ("PS136_26","020_136_26","PSA","136","26","26","Mu̱si̱i̱me Ruhanga wa mwiguru, kubba ngonzi zaamwe zinene za biro na biro! ");
INSERT INTO rub_vpl VALUES ("PS137_1","020_137_1","PSA","137","1","1","Ha migira mya Bbabbu̱looni̱, twecali̱i̱ri̱ hansi twalira, b̯u̱twezu̱ki̱ri̱ Sayu̱u̱ni̱. ");
INSERT INTO rub_vpl VALUES ("PS137_2","020_137_2","PSA","137","2","2","Ha misaali myayo, hooho twabbani̱ki̱ri̱ ndi̱ngi̱di̱ zeetu̱. ");
INSERT INTO rub_vpl VALUES ("PS137_3","020_137_3","PSA","137","3","3","Kubba banyagi̱ banyakututwala mu b̯unyagwa baatu̱weereeri̱ ku̱hi̱i̱ma, baturagira ku̱bahi̱i̱mi̱ra byembu byabaha kusemererwa, bakoba yati, “Mu̱tu̱hi̱i̱mi̱re ki̱mwei̱ ha byembu bya Sayu̱u̱ni̱!” ");
INSERT INTO rub_vpl VALUES ("PS137_4","020_137_4","PSA","137","4","4","Tu̱hi̱i̱ma teetei̱ kyembu kya Mukama mu nsi gitali gyetu̱? ");
INSERT INTO rub_vpl VALUES ("PS137_5","020_137_5","PSA","137","5","5","B̯undikwebeera, ai̱ Yeru̱salemu̱, mukono gwange gwab̯udyo gwalimalanga! ");
INSERT INTO rub_vpl VALUES ("PS137_6","020_137_6","PSA","137","6","6","Lulimi lwange lwalemerenga ha b̯unkudankuda, b̯u̱ntali̱kwi̱zu̱ka, b̯u̱ntali̱si̱i̱ma Yeru̱salemu̱ na kusemererwa kukukiirayo ki̱mwei̱! ");
INSERT INTO rub_vpl VALUES ("PS137_7","020_137_7","PSA","137","7","7","Ai̱ Mukama, i̱zu̱ka bantu bʼEdomu̱ ha kiro kya Yeru̱salemu̱ gyanyagi̱i̱rwe, nka kubalu̱kengi̱ nibakoba, “Bbotola, Bbotola, bbotolera ki̱mwei̱ ku̱doosya ha mu̱si̱nge!” ");
INSERT INTO rub_vpl VALUES ("PS137_8","020_137_8","PSA","137","8","8","Ai̱ Bbabbu̱looni̱, oli̱zi̱ka ye! Kayeesi̱i̱mi̱ri̱ yogwo alikusasula kwijanjana na ki̱kyo ki̱watu̱koori̱! ");
INSERT INTO rub_vpl VALUES ("PS137_9","020_137_9","PSA","137","9","9","Kayeesi̱i̱mi̱ri̱ alitwala nkerembe zaamu akazikenya ha lubbaali! ");
INSERT INTO rub_vpl VALUES ("PS138_1","020_138_1","PSA","138","1","1","Zabbu̱li̱ gya Dau̱di̱. Ai̱ Mukama, nku̱ku̱si̱i̱ma na mutima gwange gwensei̱, ninkukuhaariiza mu mei̱so ga mbandwa. ");
INSERT INTO rub_vpl VALUES ("PS138_2","020_138_2","PSA","138","2","2","Hab̯wa ngonzi zaamu zinene na hab̯wa b̯wesigwa b̯wamu, ni̱nku̱ramya mu Yeekaru gyamu gi̱syanu̱, ni̱nku̱si̱i̱ma hab̯wa ibara lyamu, kubba otu̱mbi̱i̱rye ibara lyamu na bigambu byamu kukira bintu byensei̱. ");
INSERT INTO rub_vpl VALUES ("PS138_3","020_138_3","PSA","138","3","3","B̯u̱nyaku̱ku̱ngi̱ri̱ wanzi̱ri̱ri̱mwo, wampa maani wantati̱i̱rya mutima. ");
INSERT INTO rub_vpl VALUES ("PS138_4","020_138_4","PSA","138","4","4","Ai̱ Mukama, bakama ba mu nsi bensei̱ baakuhaariizanga, kubba beegwi̱ri̱ bigambu byamu. ");
INSERT INTO rub_vpl VALUES ("PS138_5","020_138_5","PSA","138","5","5","Baku̱hi̱i̱mi̱ranga hab̯wa bikorwa bya Mukama, hab̯wakubba ki̱ti̱i̱ni̱sa kya Mukama kinene. ");
INSERT INTO rub_vpl VALUES ("PS138_6","020_138_6","PSA","138","6","6","Mukama nab̯uyaabba nali mwiguru, awooneera bab̯u̱ndaaru̱, bei̱tu̱ banyamyehembu abeega nibali hadei. ");
INSERT INTO rub_vpl VALUES ("PS138_7","020_138_7","PSA","138","7","7","Nab̯unyaabba ngoteerwe b̯ujune kunu na kunu, weewe olinda b̯womi b̯wange, gorora mukono gwamu, okwate ki̱ni̱ga kya banyanzigwa bange, mukono gwamu gwab̯udyo gunjune. ");
INSERT INTO rub_vpl VALUES ("PS138_8","020_138_8","PSA","138","8","8","Mukama ali̱doosereerya ki̱kyo ki̱yantegekeeri̱, ngonzi zaamu zinene, ai̱ Mukama, za biro na biro. Otaligumirisana mulimo gwa ngalu zaamu. ");
INSERT INTO rub_vpl VALUES ("PS139_1","020_139_1","PSA","139","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱. Zabbu̱li̱ gya Dau̱di̱. Ai̱ Mukama, wangezeseerye hoi̱ kandi onzegi̱ri̱! ");
INSERT INTO rub_vpl VALUES ("PS139_2","020_139_2","PSA","139","2","2","Weegi̱ri̱ mabyokere gange na malaalire, weeteegereza biteekerezu byange nincaali hadei. ");
INSERT INTO rub_vpl VALUES ("PS139_3","020_139_3","PSA","139","3","3","Weewe owoneera magyendere gange na meeri̱re gange, bikorwa byange byensei̱ obyegeeri̱ ki̱mwei̱. ");
INSERT INTO rub_vpl VALUES ("PS139_4","020_139_4","PSA","139","4","4","Nab̯umba ntakabazi̱ri̱, ai̱ Mukama, byensei̱ binkugyenda kubaza, obba obyegi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS139_5","020_139_5","PSA","139","5","5","Onyeelogoleerya i̱nyu̱ma na mu mei̱so, kandi ontaho mukono gwamu gwa mu̱gi̱sa. ");
INSERT INTO rub_vpl VALUES ("PS139_6","020_139_6","PSA","139","6","6","Kukenga kwamu tinkwetegereza, tinsobora ku̱ku̱pi̱ma. ");
INSERT INTO rub_vpl VALUES ("PS139_7","020_139_7","PSA","139","7","7","Ndigyenda hanya mwa ku̱kwebi̱saho? Rundi ndi̱i̱ru̱ka hanya hali otali? ");
INSERT INTO rub_vpl VALUES ("PS139_8","020_139_8","PSA","139","8","8","Nab̯undintemba mwiguru, na ku̱kwo oli̱yo! Nab̯undilaala ha ntabbu kyange kuzimu, na ku̱kwo oli̱yo! ");
INSERT INTO rub_vpl VALUES ("PS139_9","020_139_9","PSA","139","9","9","Nab̯u̱ndi̱du̱du̱u̱ka nkagyenda b̯uhulukalyoba, habbe kwicaara hadei mu biikaru bya b̯ugwalyoba, ");
INSERT INTO rub_vpl VALUES ("PS139_10","020_139_10","PSA","139","10","10","na ku̱kwo olinyebembera, na mukono gwamu gwab̯udyo olinsagika. ");
INSERT INTO rub_vpl VALUES ("PS139_11","020_139_11","PSA","139","11","11","Kakubba nkoba yati, “Nti̱ti̱ kagimbumbe, na kyererezi̱ ki̱nyelogoleerye kifooke i̱jolo,” ");
INSERT INTO rub_vpl VALUES ("PS139_12","020_139_12","PSA","139","12","12","bei̱tu̱ nab̯wo nti̱ti̱ tigibba nti̱ti̱ hali we, hali we i̱jolo lyaka nka mwinsi, hab̯wakubba kyererezi̱ na nti̱ti̱ kyokyo ki̱mwei̱ hali we. ");
INSERT INTO rub_vpl VALUES ("PS139_13","020_139_13","PSA","139","13","13","Bicweka byange byensei̱ bya mu nda weewe waabi̱koori̱, wambu̱mbahu̱mbi̱ri̱ nindi mu nda gya mmaama. ");
INSERT INTO rub_vpl VALUES ("PS139_14","020_139_14","PSA","139","14","14","Nkukuhaariiza kubba nyaahangi̱rwe mu ngeru gi̱ku̱ti̱i̱ni̱sya kandi gikuhuniriza. Milimo myamu myamahanu hoi̱, ki̱kyo nkyegeeri̱ ki̱mwei̱ kurungi. ");
INSERT INTO rub_vpl VALUES ("PS139_15","020_139_15","PSA","139","15","15","Nginga za maku̱ha gange zensei̱ ozeegi̱ri̱, nka kunyab̯umba b̯u̱mbi̱i̱rwe mu nsita, nyakorwa kuruga mwitehe mu magezi̱ ganene. ");
INSERT INTO rub_vpl VALUES ("PS139_16","020_139_16","PSA","139","16","16","Mei̱so gaamu gambweni̱ ntakahangi̱i̱rwe, nka ku̱byahandi̱i̱ki̱i̱rwe mu kitabbu kyamu, ki̱mwei̱ ha ki̱mwei̱, na biro bi̱byo bi̱bakampangi̱ri̱mwo b̯ubyali bi̱takabbeeri̱ho. ");
INSERT INTO rub_vpl VALUES ("PS139_17","020_139_17","PSA","139","17","17","Ai̱ Ruhanga, biteekerezu byamu kabyamuhendu hali gya! Ku̱bi̱gei̱ta hamwei̱ kabinene maani! ");
INSERT INTO rub_vpl VALUES ("PS139_18","020_139_18","PSA","139","18","18","Kakubba mbibala, bikukira musinyi b̯unene. Biro byensei̱ b̯u̱nsi̱si̱mu̱ka mba nincaali nawe. ");
INSERT INTO rub_vpl VALUES ("PS139_19","020_139_19","PSA","139","19","19","Ai̱ Ruhanga, kyakunsemeera okei̱tanga nkori̱ za bibii! Nywe bakabbwoma ibbanga, nimukandugaho. ");
INSERT INTO rub_vpl VALUES ("PS139_20","020_139_20","PSA","139","20","20","Bantu bakakubazaho kubiibi, ibara lyamu balibazaho bibiibi bisa! ");
INSERT INTO rub_vpl VALUES ("PS139_21","020_139_21","PSA","139","21","21","Ai̱ Mukama, tikyokyo nnoba bantu bakunoba, kandi nsuulira ki̱mwei̱ bab̯wo baku̱jeemera? ");
INSERT INTO rub_vpl VALUES ("PS139_22","020_139_22","PSA","139","22","22","Kyokyo mbanobera ki̱mwei̱, mbatwala kubba banyanzigwa bange. ");
INSERT INTO rub_vpl VALUES ("PS139_23","020_139_23","PSA","139","23","23","Ai̱ Ruhanga, nnkebera, weege mutima gwange! Nngezesya, weege biteekerezu byange! ");
INSERT INTO rub_vpl VALUES ("PS139_24","020_139_24","PSA","139","24","24","Weeteegereza b̯unyakabba nindi mu nsobi̱ gyensei̱, nnyebembera ondoosye mu muhanda gwa biro na biro. ");
INSERT INTO rub_vpl VALUES ("PS140_1","020_140_1","PSA","140","1","1","Hali mu̱handu̱ wa bahi̱i̱mi̱. Zabbu̱li̱ gya Dau̱di̱. Ai̱ Mukama, njuna hali bantu babiibi, ondindenge hali bantu beetagu̱, ");
INSERT INTO rub_vpl VALUES ("PS140_2","020_140_2","PSA","140","2","2","banyamitima miteekerereza mu kukora bibiibi, na kutab̯ura bantu. ");
INSERT INTO rub_vpl VALUES ("PS140_3","020_140_3","PSA","140","3","3","Bigambu byab̯u biisana b̯umala wa mpiri, mi̱nwa myab̯u mi̱zwi̱ri̱ b̯utwa nka b̯wa wu̱lu̱b̯u̱ndu̱. ");
INSERT INTO rub_vpl VALUES ("PS140_4","020_140_4","PSA","140","4","4","Ai̱ Mukama, ndinda hali maani ga babiibi, na hali bantu beetagu̱, bategeki̱ri̱ kuntega magulu. ");
INSERT INTO rub_vpl VALUES ("PS140_5","020_140_5","PSA","140","5","5","Bab̯wo banyamyehembu bantegi̱ri̱ mutegu, banzwi̱ri̱ kitimba kyab̯u, bantegi̱ri̱ b̯u̱hya ha muhanda gwa ha rubaju. ");
INSERT INTO rub_vpl VALUES ("PS140_6","020_140_6","PSA","140","6","6","Ai̱ Mukama, nkukoba yati, “Weewe Ruhanga wange.” Weegwanga, ai̱ Mukama, kulira kwange! ");
INSERT INTO rub_vpl VALUES ("PS140_7","020_140_7","PSA","140","7","7","Ai̱ Mukama, Mukama wange, weewe maani ga kujunwa kwange, ombumba mu̱twe ha kiro kya b̯ulemu. ");
INSERT INTO rub_vpl VALUES ("PS140_8","020_140_8","PSA","140","8","8","Bantu babiibi, ai̱ Mukama, otalibaha bi̱bakwendya, bibiibi bibakutegeka bitalibba byamugasu, ni̱baketembatebya. ");
INSERT INTO rub_vpl VALUES ("PS140_9","020_140_9","PSA","140","9","9","Leka banyanzigwa bange batali̱nsi̱ngu̱ra, bibakubaza ni̱banti̱i̱ni̱si̱ri̱i̱rya byabbanga hali bo. ");
INSERT INTO rub_vpl VALUES ("PS140_10","020_140_10","PSA","140","10","10","Makala gakwokya gaabbanga ha mi̱twe myab̯u, baagumwanga mu mworo, baagoromokanga mu ki̱i̱na kibatalirugamwo. ");
INSERT INTO rub_vpl VALUES ("PS140_11","020_140_11","PSA","140","11","11","Bacwa makuru baalemwanga b̯wicalu, kabii kaahi̱i̱ganga bab̯wo beetagu̱. ");
INSERT INTO rub_vpl VALUES ("PS140_12","020_140_12","PSA","140","12","12","Mukama, nkyegi̱ri̱ nti ojuna banaku, kandi alwaniira baseege. ");
INSERT INTO rub_vpl VALUES ("PS140_13","020_140_13","PSA","140","13","13","Mu mananu beesigwa baahaariizanga ibara lyamu, na barungi beicalanga hali oli. ");
INSERT INTO rub_vpl VALUES ("PS141_1","020_141_1","PSA","141","1","1","Zabbu̱li̱ gya Dau̱di̱. Ai̱ Mukama, ndimukukunga, nzanguhiira! B̯unyakankwetanga, weegwanga iraka lyange! ");
INSERT INTO rub_vpl VALUES ("PS141_2","020_141_2","PSA","141","2","2","Leka kusaba kwange kubbenge nka ku̱wu̱nya kwa mugaaju hali we, mikono myange ni̱mi̱byokya hakyendi̱, myabbanga nka kyonzira kyei̱jolo! ");
INSERT INTO rub_vpl VALUES ("PS141_3","020_141_3","PSA","141","3","3","Ai̱ Mukama, linda kanwa kange, owoneere kalimi kange. ");
INSERT INTO rub_vpl VALUES ("PS141_4","020_141_4","PSA","141","4","4","Otalindeka kukora kibii kyensei̱, otalimpa kwicala mu kukora bibiibi na nkori̱ za bibii, kandi ondindenge b̯utadya bi̱nolu̱ byab̯u! ");
INSERT INTO rub_vpl VALUES ("PS141_5","020_141_5","PSA","141","5","5","Leka murungi waamu anfubirenga kandi ancoomerenge na mbabazi̱, bei̱tu̱ kuhab̯urwa kwa babiibi tindikwikiriza, hab̯wakubba kwokwo kusaba kwange hali bikorwa byab̯u bibiibi. ");
INSERT INTO rub_vpl VALUES ("PS141_6","020_141_6","PSA","141","6","6","Mwomwo baalyega nti kigambu kyange kibba kya mananu, b̯ubalikakasuka balemi̱ baab̯u hansi wa kihanga. ");
INSERT INTO rub_vpl VALUES ("PS141_7","020_141_7","PSA","141","7","7","Balibaza nibakoba, nka mu̱li̱mi̱ kwati̱ri̱mu̱ra itehe, kwokwo na maku̱ha gaab̯u galisasaana ha mu̱nwa gwa kituuru. ");
INSERT INTO rub_vpl VALUES ("PS141_8","020_141_8","PSA","141","8","8","Bei̱tu̱ mei̱so gange gali̱ngi̱ri̱i̱ri̱ weewe, ai̱ Mukama Ruhanga, muli we hooho nzi̱ru̱ki̱ra, otalindeka ntali na mu̱li̱ndi̱! ");
INSERT INTO rub_vpl VALUES ("PS141_9","020_141_9","PSA","141","9","9","Njuna ontoole mu mitegu mi̱bantegi̱ri̱, na mu b̯u̱hya b̯wa nkori̱ za bibii! ");
INSERT INTO rub_vpl VALUES ("PS141_10","020_141_10","PSA","141","10","10","Babiibi kabagwenge mu bitimba byab̯u bankei, bei̱tu̱ gya ningirooba b̯u̱roobi̱. ");
INSERT INTO rub_vpl VALUES ("PS142_1","020_142_1","PSA","142","1","1","Masikili gya Dau̱di̱ b̯uyaali mu b̯wingira. Kusaba. Nnkunga Mukama neiraka lyange, neiraka lyange nyesengereerya Mukama angiriire mbabazi̱. ");
INSERT INTO rub_vpl VALUES ("PS142_2","020_142_2","PSA","142","2","2","Bi̱byo byensei̱ binsaaliza, nyabimwolokyanga, nyamuweeranga b̯ujune b̯wange. ");
INSERT INTO rub_vpl VALUES ("PS142_3","020_142_3","PSA","142","3","3","Mwozo gwange b̯ugwakalemereerwanga, weewe weegi̱ri̱ kindikora! Muhanda gunkarabamwo, gubbamwo mutegu gu̱bategi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS142_4","020_142_4","PSA","142","4","4","B̯umagamaga ku rubaju lwange lwa b̯udyo, timbonaho noomwei̱ wa kunjuna, tihacaaloho b̯wi̱ru̱ki̱ro b̯wensei̱, tihaloho akunfaho. ");
INSERT INTO rub_vpl VALUES ("PS142_5","020_142_5","PSA","142","5","5","Ai̱ Mukama, weewe ginkunga, ninkoba yati, “Weewe b̯wi̱ru̱ki̱ro b̯wange, weewe mugab̯u gwange mu b̯womi b̯wa nsi.” ");
INSERT INTO rub_vpl VALUES ("PS142_6","020_142_6","PSA","142","6","6","Weegwanga kukunga kwange, hab̯wakubba ntabatabeeni̱ hoi̱! Njuna hali bab̯wo baku̱mpi̱i̱ga, hab̯wakubba bakunkira maani! ");
INSERT INTO rub_vpl VALUES ("PS142_7","020_142_7","PSA","142","7","7","Ntoola mu nkomo, aleke nsi̱i̱me ibara lyamu! Barungi balinyeecookaho, hab̯wa birungi byolinkolera. ");
INSERT INTO rub_vpl VALUES ("PS143_1","020_143_1","PSA","143","1","1","Zabbu̱li̱ gya Dau̱di̱. Ai̱ Mukama, weegwa kusaba kwange, nnyetegeerya, nku̱kwesengereerya! Onzi̱rengemwo hab̯wakubba obba wamananu kandi mwesigwa. ");
INSERT INTO rub_vpl VALUES ("PS143_2","020_143_2","PSA","143","2","2","Otacweranga muheereza waamu musangu, kubba tihaloho murungi mu mei̱so gaamu. ");
INSERT INTO rub_vpl VALUES ("PS143_3","020_143_3","PSA","143","3","3","Hab̯wa munyanzigwa kumpiigahiiga, anzi̱gazi̱gi̱ni̱ri̱ hansi, anteeri̱ kubba mu nti̱ti̱ nka bab̯wo banyaku̱kwa kadei. ");
INSERT INTO rub_vpl VALUES ("PS143_4","020_143_4","PSA","143","4","4","Kyokyo mwozo gwange gutali na ku̱ni̱hi̱ra, na mutima gwange gu̱ku̱ti̱i̱ni̱ hoi̱. ");
INSERT INTO rub_vpl VALUES ("PS143_5","020_143_5","PSA","143","5","5","Nkei̱zu̱ka biro bya kadei, nkateekereza ha bintu byensei̱ bi̱waakoori̱, nkawona milimo myamu, ");
INSERT INTO rub_vpl VALUES ("PS143_6","020_143_6","PSA","143","6","6","mbyokya mikono myange hali we. Hab̯wamu, nyeegwa mutima nigukudokera nkeitehe lya ndala kulidokera meezi̱. ");
INSERT INTO rub_vpl VALUES ("PS143_7","020_143_7","PSA","143","7","7","Ai̱ Mukama, wanguha ku̱nzi̱ramwo! Mwozo gwange tigucalimwo isanyu! Otanzi̱ti̱ra li̱i̱so lyamu, nkeisana bab̯wo basi̱ri̱mu̱ka kuzimu. ");
INSERT INTO rub_vpl VALUES ("PS143_8","020_143_8","PSA","143","8","8","B̯uli mwakya, onzegesyenge ha ngonzi zaamu zinene, hab̯wakubba weewe ginyeesiga. Ompe kwetegereza muhanda gunyarabangamwo, nahab̯waki̱kyo ninkuhongera mutima gwange. ");
INSERT INTO rub_vpl VALUES ("PS143_9","020_143_9","PSA","143","9","9","Njuna, ai̱ Mukama, hali banyanzigwa bange! Nzi̱ru̱ki̱ri̱ hali we kwebi̱sa. ");
INSERT INTO rub_vpl VALUES ("PS143_10","020_143_10","PSA","143","10","10","Onzegesya kukora bi̱wendya, hab̯wakubba weewe Ruhanga wange! Leka Mwozo waamu murungi anyebemberenge heetendeku̱. ");
INSERT INTO rub_vpl VALUES ("PS143_11","020_143_11","PSA","143","11","11","Ai̱ Mukama, hab̯wa ibara lyamu, olindenge b̯womi b̯wange! Hab̯wa b̯urungi b̯wamu, onjune b̯ujune ha mutima! ");
INSERT INTO rub_vpl VALUES ("PS143_12","020_143_12","PSA","143","12","12","Kandi mu ngonzi zaamu zinene, olihwerekereerya banyanzigwa bange, noozi̱kya bantu bensei̱ bantu̱ntwi̱ze mutima, hab̯wakubba ndi muheereza waamu. ");
INSERT INTO rub_vpl VALUES ("PS144_1","020_144_1","PSA","144","1","1","Zabbu̱li̱ gya Dau̱di̱. Ahaariizwe Mukama, lubbaali lwange, antendeka mu byakulwana na mu byab̯ulemu, ");
INSERT INTO rub_vpl VALUES ("PS144_2","020_144_2","PSA","144","2","2","anzolokeerya ngonzi zinene kandi lugo lwange, b̯wi̱ru̱ki̱ro b̯wange kandi ancungura, ngab̯u gyange, hali nzi̱ru̱ki̱ra, afuga mahanga gali hansi gyange. ");
INSERT INTO rub_vpl VALUES ("PS144_3","020_144_3","PSA","144","3","3","Ai̱ Mukama, kikuha kutaho muntu mutima, rundi kikuha kumuteekerezaho, kyokyo kyani? ");
INSERT INTO rub_vpl VALUES ("PS144_4","020_144_4","PSA","144","4","4","Muntu eisana rwoya, biro byamwe biisana mu̱tu̱ntu̱lu̱ guteicalaho. ");
INSERT INTO rub_vpl VALUES ("PS144_5","020_144_5","PSA","144","5","5","Ai̱ Mukama, i̱namya iguru lyamu osi̱ri̱mu̱ke hansi, kwata ku nsahu zi̱tu̱u̱ke mwi̱ca! ");
INSERT INTO rub_vpl VALUES ("PS144_6","020_144_6","PSA","144","6","6","Osi̱ndi̱ke nkuba, orarangye banyanzigwa, lasa mbasi gyamu gibabinge. ");
INSERT INTO rub_vpl VALUES ("PS144_7","020_144_7","PSA","144","7","7","Weemeera mwiguru odambule mukono gwamu onsahule kandi njuna, ontoole mu meezi̱ ganene ga mu ndi̱ha, na mu ngalu za banyamahanga, ");
INSERT INTO rub_vpl VALUES ("PS144_8","020_144_8","PSA","144","8","8","banyami̱nwa mikabaza b̯u̱gobya kandi bakarahira bya b̯u̱gobya babyokeerye mikono myab̯u mya b̯udyo. ");
INSERT INTO rub_vpl VALUES ("PS144_9","020_144_9","PSA","144","9","9","Ai̱ Ruhanga, nkwi̱za ku̱ku̱hi̱i̱mi̱ra kyembu kihyaka, ninkukuutira ki̱dongo kya hu̱u̱zi̱ i̱ku̱mi̱, ");
INSERT INTO rub_vpl VALUES ("PS144_10","020_144_10","PSA","144","10","10","weewe oha bakama ku̱si̱ngu̱ra, ojuna Dau̱di̱ muheereza waamu mpirima gya ku̱mwi̱ta. ");
INSERT INTO rub_vpl VALUES ("PS144_11","020_144_11","PSA","144","11","11","Nsahula kandi oncungure kuruga mu ngalu za banyamahanga, banyami̱nwa mikabaza b̯u̱gobya na bakarahira b̯u̱gobya babyokeerye mikono myab̯u mya b̯udyo. ");
INSERT INTO rub_vpl VALUES ("PS144_12","020_144_12","PSA","144","12","12","Batabani̱ beetu̱ mu b̯usigazi b̯wab̯u kababbenge nka bimera bi̱handu̱, bahara beetu̱ kababbenge nka mpagi̱ za ku nsonda zi̱sali̱i̱rwe ku̱bi̱mba kikaali. ");
INSERT INTO rub_vpl VALUES ("PS144_13","020_144_13","PSA","144","13","13","Bideeru byetu̱ byeizulanga nibibooga bilimwa bya mi̱li̱ngo myensei̱, ntaama zeetu̱ kazibyalenge byana nku̱mi̱ na b̯usiriira mu mali̱i̱si̱i̱ryo geetu̱. ");
INSERT INTO rub_vpl VALUES ("PS144_14","020_144_14","PSA","144","14","14","Nte zeetu̱ zaabyalanga nnyana, zaabyalanga zi̱taki̱ki̱ri̱ rundi kutorooga, ngu̱u̱do zeetu̱ zaabbanga zitalimwo kizabiro. ");
INSERT INTO rub_vpl VALUES ("PS144_15","020_144_15","PSA","144","15","15","Bali na mu̱gi̱sa baliheeb̯wa mi̱gi̱sa nka mi̱myo! Bali na mu̱gi̱sa ba Ruhanga waab̯u ali Mukama! ");
INSERT INTO rub_vpl VALUES ("PS145_1","020_145_1","PSA","145","1","1","Zabbu̱li̱ gya Dau̱di̱ gya Kuhaariiza. Ai̱ Mukama, nditumbula weewe Ruhanga wange, ndihaariiza ibara lyamu biro na biro. ");
INSERT INTO rub_vpl VALUES ("PS145_2","020_145_2","PSA","145","2","2","B̯ukyeb̯ukye nkwi̱za ku̱ku̱si̱i̱manga nimpaariizanga ibara lyamu biro na biro. ");
INSERT INTO rub_vpl VALUES ("PS145_3","020_145_3","PSA","145","3","3","Ahaariizwe hoi̱, Mukama waamaani, b̯u̱handu̱ b̯wamwe ti̱b̯wetegerezib̯we. ");
INSERT INTO rub_vpl VALUES ("PS145_4","020_145_4","PSA","145","4","4","Mu̱hi̱hi̱ gu̱mwei̱ ha gundi baahaariizanga bi̱waakoori̱, ni̱batebya bikorwa byamu bya maani. ");
INSERT INTO rub_vpl VALUES ("PS145_5","020_145_5","PSA","145","5","5","Hab̯wa ki̱ti̱i̱ni̱sa kinene kya b̯u̱handu̱ b̯wamu, na hab̯wa milimo myamu myamahanu, nyabi̱teekerezangaho. ");
INSERT INTO rub_vpl VALUES ("PS145_6","020_145_6","PSA","145","6","6","Baatebyanga bikorwa byamu bikuhuniriza bya maani, nagya nyabazanga ha b̯u̱handu̱ b̯wamu. ");
INSERT INTO rub_vpl VALUES ("PS145_7","020_145_7","PSA","145","7","7","Baasasani̱anga kaku̱u̱mi̱i̱re ka b̯urungi b̯wamu, ni̱bahi̱i̱manga na maani ha mananu gaamu. ");
INSERT INTO rub_vpl VALUES ("PS145_8","020_145_8","PSA","145","8","8","Mukama eicala mu̱ganyi̱ri̱ kandi wambabazi̱, tabihirwa wangu, ngonzi zaamwe zinene tizihinduka. ");
INSERT INTO rub_vpl VALUES ("PS145_9","020_145_9","PSA","145","9","9","Mukama abba murungi hali bensei̱, na mbabazi̱ zaamwe zili hensei̱ ha bihangwa byamwe. ");
INSERT INTO rub_vpl VALUES ("PS145_10","020_145_10","PSA","145","10","10","Ai̱ Mukama, byensei̱ bi̱waahangi̱ri̱ byaku̱si̱i̱manga, na bantu baamu beesigwa bensei̱ baakuhaariizanga! ");
INSERT INTO rub_vpl VALUES ("PS145_11","020_145_11","PSA","145","11","11","Baabazanga ha ki̱ti̱i̱ni̱sa kya b̯ukama b̯wamu, ni̱banyu̱mya ha maani gaamu, ");
INSERT INTO rub_vpl VALUES ("PS145_12","020_145_12","PSA","145","12","12","mwa ku̱manyi̱sya bantu bensei̱ bikorwa byamu bya maani na ki̱ti̱i̱ni̱sa kya b̯ukama b̯wamu kya maani. ");
INSERT INTO rub_vpl VALUES ("PS145_13","020_145_13","PSA","145","13","13","B̯ukama b̯wamu b̯wa biro na biro, na b̯u̱sobozi̱ b̯wamu b̯wa biro byensei̱. Mukama abba wamananu mu bigambu byamwe byensei̱ kandi wambabazi̱ hali bintu byensei̱ bi̱yaahangi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS145_14","020_145_14","PSA","145","14","14","Mukama asagika bensei̱ bagwa hansi, abyokya bab̯wo bensei̱ bahi̱nyi̱rwe hansi. ");
INSERT INTO rub_vpl VALUES ("PS145_15","020_145_15","PSA","145","15","15","Mei̱so ga bi̱hangi̱rwe byensei̱ gali̱ngi̱ri̱i̱ri̱ weewe, obiha bidyo mu b̯u̱su̱mi̱ b̯wabyo. ");
INSERT INTO rub_vpl VALUES ("PS145_16","020_145_16","PSA","145","16","16","Ob̯u̱u̱la ngalu zaamu, noi̱cu̱tya b̯uli kintu kikali na b̯womi. ");
INSERT INTO rub_vpl VALUES ("PS145_17","020_145_17","PSA","145","17","17","Mukama abba wamananu mu mihanda myamwe myensei̱, kandi wangonzi hali bintu byensei̱ bi̱yaakoori̱. ");
INSERT INTO rub_vpl VALUES ("PS145_18","020_145_18","PSA","145","18","18","Mukama abba heehi̱ hali bensei̱ bamukunga, hali bab̯wo bensei̱ bamukunga mu mananu. ");
INSERT INTO rub_vpl VALUES ("PS145_19","020_145_19","PSA","145","19","19","Bab̯wo bensei̱ bamutamwo ki̱ti̱i̱ni̱sa, abaha bibakwetaaga, yeegwa kusaba kwab̯u na bajuna. ");
INSERT INTO rub_vpl VALUES ("PS145_20","020_145_20","PSA","145","20","20","Mukama alinda bensei̱ bamwolokya ngonzi, bei̱tu̱ babiibi bensei̱, ali̱bazi̱kya. ");
INSERT INTO rub_vpl VALUES ("PS145_21","020_145_21","PSA","145","21","21","Mu̱nwa gwange gwahaariizanga Mukama, binyakuhangwa byensei̱ kabihaariizenge ibara lyamwe li̱ti̱i̱nwa biro na biro. ");
INSERT INTO rub_vpl VALUES ("PS146_1","020_146_1","PSA","146","1","1","Haari̱i̱ze Mukama! Ai̱ mutima gwange, haariiza Mukama! ");
INSERT INTO rub_vpl VALUES ("PS146_2","020_146_2","PSA","146","2","2","Biro byensei̱ bya b̯womi b̯wange nkwi̱za kukuhaariizanga Mukama, nkwi̱za ku̱hi̱i̱mi̱ranga Ruhanga wange nincali mwomi. ");
INSERT INTO rub_vpl VALUES ("PS146_3","020_146_3","PSA","146","3","3","Otalyesiga balemi̱, habbe kwesiga muntu b̯untu, atali na kyalikujuna. ");
INSERT INTO rub_vpl VALUES ("PS146_4","020_146_4","PSA","146","4","4","Lwoya lwamwe b̯ulumurugamwo, ei̱rayo mwitehe, ha kiro ki̱kyo kyonyi̱ni̱ byabba ategeki̱ri̱ bibba bi̱mali̱ki̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PS146_5","020_146_5","PSA","146","5","5","Yeesi̱i̱me yogwo wa Ruhanga wa Yakobbo alijuna, wa ku̱ni̱hi̱ra kwamwe kuli mu Mukama Ruhanga waamwe, ");
INSERT INTO rub_vpl VALUES ("PS146_6","020_146_6","PSA","146","6","6","munyakuhanga iguru na nsi, itaka na bintu byensei̱ biicalamwo, yooyo eicala mwesigwa biro byensei̱, ");
INSERT INTO rub_vpl VALUES ("PS146_7","020_146_7","PSA","146","7","7","yooyo alwaniira b̯ugabe b̯wa baceke kandi agabira baseege bidyo. Mukama ateesula banyankomo, ");
INSERT INTO rub_vpl VALUES ("PS146_8","020_146_8","PSA","146","8","8","Mukama eijula mei̱so ga bei̱jalu̱. Mukama abyokya bensei̱ bahi̱nyi̱rwe hansi, Mukama yendya barungi. ");
INSERT INTO rub_vpl VALUES ("PS146_9","020_146_9","PSA","146","9","9","Mukama alinda banyamahanga, awooneera bamukaabakwere na nfu̱u̱zi̱, bei̱tu̱ muhanda gwa babiibi agu̱zi̱ki̱i̱rya ki̱mwei̱. ");
INSERT INTO rub_vpl VALUES ("PS146_10","020_146_10","PSA","146","10","10","Mukama Ruhanga waamu, ai̱ Sayu̱u̱ni̱, alema biro na biro mi̱hi̱hi̱ myensei̱. Haari̱i̱ze Mukama! ");
INSERT INTO rub_vpl VALUES ("PS147_1","020_147_1","PSA","147","1","1","Haari̱i̱ze Mukama! Kubba kirungi kuhaariiza Ruhanga weetu̱, kubba wambabazi̱, kandi ki̱doori̱ b̯u̱dwi̱ kumuhaariiza. ");
INSERT INTO rub_vpl VALUES ("PS147_2","020_147_2","PSA","147","2","2","Mukama ali̱mu̱ku̱bi̱mba Yeru̱salemu̱, acookacoori̱ Bei̱saleeri̱ banyakusaasaana. ");
INSERT INTO rub_vpl VALUES ("PS147_3","020_147_3","PSA","147","3","3","Ahoni̱a banyamitima mya b̯ujune, naajanjaba bihote byab̯u. ");
INSERT INTO rub_vpl VALUES ("PS147_4","020_147_4","PSA","147","4","4","Nzota za mu mwanya, yooyo azibala, b̯uli gi̱mwei̱ agyeta neibara. ");
INSERT INTO rub_vpl VALUES ("PS147_5","020_147_5","PSA","147","5","5","Mukama weetu̱ wa maani hoi̱, kandi wa b̯u̱sobozi̱ b̯unene, na kwetegereza kwamwe tikulengwa. ");
INSERT INTO rub_vpl VALUES ("PS147_6","020_147_6","PSA","147","6","6","Mukama abyokya bab̯u̱ndaaru̱, bei̱tu̱ babiibi abei̱calya hansi. ");
INSERT INTO rub_vpl VALUES ("PS147_7","020_147_7","PSA","147","7","7","Mu̱hi̱i̱mi̱re Mukama ni̱mu̱mu̱si̱i̱ma, mu̱mu̱hi̱i̱mi̱re Ruhanga weetu̱ kyembu kirungi na ndi̱ngi̱di̱! ");
INSERT INTO rub_vpl VALUES ("PS147_8","020_147_8","PSA","147","8","8","Yooyo abbu̱mba iguru na bikaka, ategeka ndagali̱ hab̯wa nsi, amerya b̯usubi ha nsahu. ");
INSERT INTO rub_vpl VALUES ("PS147_9","020_147_9","PSA","147","9","9","Aha bisolo bidyo byabyo, na byana bya nnyoni̱ bikulira. ");
INSERT INTO rub_vpl VALUES ("PS147_10","020_147_10","PSA","147","10","10","Kwesi̱i̱ma kwamwe kwicala kwahi mu maani ga mbaraasi, habbe mu maani ga mahe, ");
INSERT INTO rub_vpl VALUES ("PS147_11","020_147_11","PSA","147","11","11","bei̱tu̱ Mukama yeegondesya bab̯wo bamu̱ti̱i̱na, bab̯wo bali na ku̱ni̱hi̱ra mu ngonzi zaamwe zinene. ");
INSERT INTO rub_vpl VALUES ("PS147_12","020_147_12","PSA","147","12","12","Haari̱i̱ze Mukama, ai̱ Yeru̱salemu̱! Ai̱ Sayu̱u̱ni̱, Ruhanga waamu ahaariizib̯we! ");
INSERT INTO rub_vpl VALUES ("PS147_13","020_147_13","PSA","147","13","13","Kubba yooyo atati̱i̱rya byoma bya malembo gaamu, kandi aha bantu baamu mu̱gi̱sa. ");
INSERT INTO rub_vpl VALUES ("PS147_14","020_147_14","PSA","147","14","14","Ataho b̯u̱si̱nge ha mitaanu myamu, kandi abei̱cu̱tya na nganu girungi ki̱mwei̱. ");
INSERT INTO rub_vpl VALUES ("PS147_15","020_147_15","PSA","147","15","15","Atuma kiragiro kyamwe mu nsi, kigambu kyamwe nikikorwa b̯wangu. ");
INSERT INTO rub_vpl VALUES ("PS147_16","020_147_16","PSA","147","16","16","Asi̱ndi̱ka ndagali̱ gya mahi̱ga nka muguma byoza bya ntaama, asaasaani̱a kiho nka mu̱tu̱ku̱u̱la i̱syanu̱. ");
INSERT INTO rub_vpl VALUES ("PS147_17","020_147_17","PSA","147","17","17","Aguma ndagali̱ gya mahi̱ga nka mpulungu, naani akusobora ku̱lwani̱sya b̯wi̱nyamu̱ b̯wamwe? ");
INSERT INTO rub_vpl VALUES ("PS147_18","020_147_18","PSA","147","18","18","Aragira kigambu kyamwe kwagya mahi̱ga ga ndagali̱, nigaaga, ata mpehu kuhunga, meezi̱ nigataraaka. ");
INSERT INTO rub_vpl VALUES ("PS147_19","020_147_19","PSA","147","19","19","Yaatula naaweera Yakobbo kigambu kyamwe, naateeraho I̱saleeri̱ mateeka gayaasomesya. ");
INSERT INTO rub_vpl VALUES ("PS147_20","020_147_20","PSA","147","20","20","Takagakooranga yatyo mahanga gandi, ti̱geegi̱ri̱ biragiro byamwe. Haari̱i̱ze Mukama! ");
INSERT INTO rub_vpl VALUES ("PS148_1","020_148_1","PSA","148","1","1","Haari̱i̱ze Mukama. Haari̱i̱ze Mukama, nywe ba mwiguru mu̱mu̱haari̱i̱ze mu biikaru bya hakyendi̱! ");
INSERT INTO rub_vpl VALUES ("PS148_2","020_148_2","PSA","148","2","2","Bamalayika baamwe nywensei̱, mu̱mu̱haari̱i̱ze, mahe gaamwe genseenya ga mwiguru, mu̱mu̱haari̱i̱ze! ");
INSERT INTO rub_vpl VALUES ("PS148_3","020_148_3","PSA","148","3","3","Lyoba na mweri̱, mu̱mu̱haari̱i̱ze, nywe nzota zikwangasana, mu̱mu̱haari̱i̱ze! ");
INSERT INTO rub_vpl VALUES ("PS148_4","020_148_4","PSA","148","4","4","Mu̱mu̱haari̱i̱ze, we iguru wa heiguru, nawe, meezi̱ oli hakyendi̱ weiguru! ");
INSERT INTO rub_vpl VALUES ("PS148_5","020_148_5","PSA","148","5","5","Byensei̱ kabihaariize ibara lya Mukama! Hab̯wakubba yooyo yaaragi̱i̱ri̱ byahangwa na kuhangwa. ");
INSERT INTO rub_vpl VALUES ("PS148_6","020_148_6","PSA","148","6","6","Hab̯wa kiragiro kyamwe yaabi̱teeri̱ho mu biikaru byabyo biro na biro yaabiteeraho mitaanu mitasobora kuhinduka. ");
INSERT INTO rub_vpl VALUES ("PS148_7","020_148_7","PSA","148","7","7","Haari̱i̱ze Mukama, nywe ba mu nsi, mu̱mu̱haari̱i̱ze nywe bisolo bya mu meezi̱ na ndi̱ha zeitaka, ");
INSERT INTO rub_vpl VALUES ("PS148_8","020_148_8","PSA","148","8","8","mworo na ndagali̱ gya mahi̱ga, mukamu gwa meezi̱ na kiho, na bbuukuulu ahondera bigambu bya Mukama. ");
INSERT INTO rub_vpl VALUES ("PS148_9","020_148_9","PSA","148","9","9","Nywe nsahu na mbamba, misaali mya bijuma na mitumba myensei̱, ");
INSERT INTO rub_vpl VALUES ("PS148_10","020_148_10","PSA","148","10","10","bisolo na nte zensei̱, byesikiira na bi̱nyoni̱ bi̱du̱du̱u̱ka, mu̱mu̱haari̱i̱ze! ");
INSERT INTO rub_vpl VALUES ("PS148_11","020_148_11","PSA","148","11","11","Bakama ba nsi na bantu bensei̱, bahandu̱ na balemi̱ bensei̱ ba hansi, ");
INSERT INTO rub_vpl VALUES ("PS148_12","020_148_12","PSA","148","12","12","basigazi na bahala, badulu bahandu̱ na baana, mu̱mu̱haari̱i̱ze! ");
INSERT INTO rub_vpl VALUES ("PS148_13","020_148_13","PSA","148","13","13","Bintu byensei̱ kabihaariize ibara lya Mukama, kubba ibara lyamwe lisa lyolyo litumbukenge, ki̱ti̱i̱ni̱sa kyamwe kibbe hakyendi̱ wa nsi neiguru. ");
INSERT INTO rub_vpl VALUES ("PS148_14","020_148_14","PSA","148","14","14","Mukama alinda ihanga lyamwe na maani, ihanga lyamwe lyesigwa, I̱saleeri̱, limuhaariize, ihanga liicala heehi̱ nayo. Haari̱i̱ze Mukama! ");
INSERT INTO rub_vpl VALUES ("PS149_1","020_149_1","PSA","149","1","1","Haari̱i̱ze Mukama! Mu̱hi̱i̱mi̱re Mukama kyembu kihyaka, mu̱mu̱haari̱i̱ze hamwei̱ na kitebe kya bantu baamwe bensei̱ barungi. ");
INSERT INTO rub_vpl VALUES ("PS149_2","020_149_2","PSA","149","2","2","Leka I̱saleeri̱ asanyukire Mu̱hangi̱ waamwe, leka bantu ba Sayu̱u̱ni̱ basemererwe hab̯wa mukama waab̯u! ");
INSERT INTO rub_vpl VALUES ("PS149_3","020_149_3","PSA","149","3","3","Leka bacekece nibahaariiza ibara lyamwe, Leka bahi̱i̱me nibahaariiza na bi̱cekere na ndi̱ngi̱di̱! ");
INSERT INTO rub_vpl VALUES ("PS149_4","020_149_4","PSA","149","4","4","Hab̯wakubba Mukama yeesu̱gu̱sya bantu baamwe, bab̯wo bab̯u̱ndaaru̱ alibalwalya kujunwa. ");
INSERT INTO rub_vpl VALUES ("PS149_5","020_149_5","PSA","149","5","5","Leka beesigwa ba Ruhanga basanyukire mu ki̱ti̱i̱ni̱sa, Leka bahi̱i̱me na kusemererwa nibali mu ntabbu zaab̯u. ");
INSERT INTO rub_vpl VALUES ("PS149_6","020_149_6","PSA","149","6","6","Leka kukugiza kwa maani hoi̱ kwa Ruhanga kuruge mu mi̱nwa myab̯u, na mpirima mu mukono myab̯u, ");
INSERT INTO rub_vpl VALUES ("PS149_7","020_149_7","PSA","149","7","7","kuhoora nzi̱go gya mahanga, na kufubira bantu, ");
INSERT INTO rub_vpl VALUES ("PS149_8","020_149_8","PSA","149","8","8","kubboha bakama ba gagwo mahanga njegere, na balemi̱ baago na mpi̱ngo, ");
INSERT INTO rub_vpl VALUES ("PS149_9","020_149_9","PSA","149","9","9","ku̱doosereerye kiragiro kya ncwamwo gya musangu! Kiki kyokyo ki̱ti̱i̱ni̱sa kya beesigwa ba Ruhanga bensei̱. Haari̱i̱ze Mukama! ");
INSERT INTO rub_vpl VALUES ("PS150_1","020_150_1","PSA","150","1","1","Haari̱i̱ze Mukama! Haari̱i̱ze Ruhanga mu nnyu̱mba gyamwe, Mu̱mu̱haari̱i̱ze mwiguru lyamwe linyamaani! ");
INSERT INTO rub_vpl VALUES ("PS150_2","020_150_2","PSA","150","2","2","Mu̱mu̱haari̱i̱ze hab̯wa bikorwa byamwe binyamaani, Mu̱mu̱haari̱i̱ze ku̱si̱gi̱ki̱ra ha b̯u̱handu̱ b̯wamwe b̯wa maani! ");
INSERT INTO rub_vpl VALUES ("PS150_3","020_150_3","PSA","150","3","3","Mu̱mu̱haari̱i̱ze na maraka ga ngwara, Mu̱mu̱haari̱i̱ze na ki̱dongo na ndi̱ngi̱di̱! ");
INSERT INTO rub_vpl VALUES ("PS150_4","020_150_4","PSA","150","4","4","Mu̱mu̱haari̱i̱ze na bi̱cekere nimukucekeca! Mu̱mu̱haari̱i̱ze nimukuuta bi̱dongo na ndere! ");
INSERT INTO rub_vpl VALUES ("PS150_5","020_150_5","PSA","150","5","5","Mu̱mu̱haari̱i̱ze na nsansi zikulira hoi̱! Mu̱mu̱haari̱i̱ze na nsansi zi̱ku̱segenya hoi̱! ");
INSERT INTO rub_vpl VALUES ("PS150_6","020_150_6","PSA","150","6","6","Bintu byensei̱ bili na rwoya bihaariize Mukama! ");
INSERT INTO rub_vpl VALUES ("PR1_1","021_1_1","PRO","1","1","1","Zizi zoozo Ngeera za Sulumaani, mu̱tabani̱ wa Dau̱di̱, mukama wʼI̱saleeri̱, ");
INSERT INTO rub_vpl VALUES ("PR1_2","021_1_2","PRO","1","2","2","ziha bantu kubba na magezi̱ na ngesu, naakwetegereza bigambu bya magezi̱, ");
INSERT INTO rub_vpl VALUES ("PR1_3","021_1_3","PRO","1","3","3","zeegesya kwetegereza ngesu na bikorwa birungi, bikorwa bi̱ku̱si̱i̱mwa na b̯winganiza. ");
INSERT INTO rub_vpl VALUES ("PR1_4","021_1_4","PRO","1","4","4","Ziha ntwarwa kubba na magezi̱, basigazi na bahala kwetegereza. ");
INSERT INTO rub_vpl VALUES ("PR1_5","021_1_5","PRO","1","5","5","Ali na magezi̱ na kwetegereza, yeetegeerye zizi ngeera, ateeryeho kwega na kulambwa, ");
INSERT INTO rub_vpl VALUES ("PR1_6","021_1_6","PRO","1","6","6","yeetegereze makuru gaazo, bigambu na bi̱koi̱kyo bya magezi̱. ");
INSERT INTO rub_vpl VALUES ("PR1_7","021_1_7","PRO","1","7","7","Ndugiiro gya kwetegereza gili mu ku̱ti̱i̱na Mukama, bei̱tu̱ badoma bagaya magezi̱ na kuhab̯urwa. ");
INSERT INTO rub_vpl VALUES ("PR1_8","021_1_8","PRO","1","8","8","Mwana wange, weetegeeryanga kulamba kwa bbaawu, kandi otaligumirisana bigambu bya mmaawu. ");
INSERT INTO rub_vpl VALUES ("PR1_9","021_1_9","PRO","1","9","9","Byabbanga nka kondo gya mbabazi̱ ha mu̱twe gwamu, kandi lu̱kwanzi̱ mwi̱coti̱ lyamu. ");
INSERT INTO rub_vpl VALUES ("PR1_10","021_1_10","PRO","1","10","10","Mwana wange, nkori̱ za bibii zaakakwohyanga, otabetegeeryanga. ");
INSERT INTO rub_vpl VALUES ("PR1_11","021_1_11","PRO","1","11","11","B̯ubakakuweeranga, “I̱za tugyende hamwei̱, tulaaliire gi̱tweta, tu̱gwere muceke atali na nsonga, ");
INSERT INTO rub_vpl VALUES ("PR1_12","021_1_12","PRO","1","12","12","tubagoromore nibacaali boomi mu nnyanga, bensei̱, nka bantu bagwi̱ri̱ mu ki̱i̱na, ");
INSERT INTO rub_vpl VALUES ("PR1_13","021_1_13","PRO","1","13","13","tu̱kwi̱za kutunga bintu bya muhendu, twi̱zu̱lye manyu̱mba geetu̱ na bintu bi̱tu̱nyagi̱ri̱, ");
INSERT INTO rub_vpl VALUES ("PR1_14","021_1_14","PRO","1","14","14","i̱za, otwekonyeho, tu̱kwi̱za twensei̱ kubagana bi̱byo bi̱tu̱nyagi̱ri̱.” ");
INSERT INTO rub_vpl VALUES ("PR1_15","021_1_15","PRO","1","15","15","Mwana wange, otaligyenda nabo, otalita kigulu kyamu mu mihanda myab̯u, ");
INSERT INTO rub_vpl VALUES ("PR1_16","021_1_16","PRO","1","16","16","kubba magulu gaab̯u ganguha kukora bibii, gei̱ru̱ka kubbwoma ibbanga. ");
INSERT INTO rub_vpl VALUES ("PR1_17","021_1_17","PRO","1","17","17","Tikigasa kutega mutegu, nnyoni̱ gyokutega nikikuwona. ");
INSERT INTO rub_vpl VALUES ("PR1_18","021_1_18","PRO","1","18","18","Bei̱tu̱ bantu nka bab̯wo bagwa mu mitegu myab̯u bankei, ni̱bei̱twa nkwe zaab̯u bankei. ");
INSERT INTO rub_vpl VALUES ("PR1_19","021_1_19","PRO","1","19","19","Kwokwo yatyo banyagi̱ ba sente babba, sente zi̱banyagi̱ri̱, zibamalaho b̯womi. ");
INSERT INTO rub_vpl VALUES ("PR1_20","021_1_20","PRO","1","20","20","Wamagezi̱ akukungira mu ngu̱u̱do, akwami̱i̱rya hasyanu̱ mu kabbaari. ");
INSERT INTO rub_vpl VALUES ("PR1_21","021_1_21","PRO","1","21","21","Akwetera bantu mu katali, akuweera beecooki̱ri̱ heirembu lya rub̯uga: ");
INSERT INTO rub_vpl VALUES ("PR1_22","021_1_22","PRO","1","22","22","“Nywe ntwarwa, mu̱lyendya b̯udoma kudwa di̱i̱? Nywe bagayi̱ na badoma muliicala nimusuula kwetegereza kudwa di̱i̱? ");
INSERT INTO rub_vpl VALUES ("PR1_23","021_1_23","PRO","1","23","23","I̱ze mwetegeerye kulamba kwange, aleke mbaweere bya ha mutima gwange, nkwi̱za ku̱bolokeerya bi̱nyeegesya. ");
INSERT INTO rub_vpl VALUES ("PR1_24","021_1_24","PRO","1","24","24","Nab̯u̱nyabeeti̱ri̱ mwaswi̱ri̱ ku̱nyeetegeerya, mu̱takanzegwe nab̯u̱nyabeesengereerye, ");
INSERT INTO rub_vpl VALUES ("PR1_25","021_1_25","PRO","1","25","25","mugaya b̯u̱gayi̱ bigambu byange, ti̱mwegwa binkubalamba. ");
INSERT INTO rub_vpl VALUES ("PR1_26","021_1_26","PRO","1","26","26","Kabii b̯u̱kali̱bei̱zi̱ra, ndibasekereerya, ndi̱bahonereerya, ");
INSERT INTO rub_vpl VALUES ("PR1_27","021_1_27","PRO","1","27","27","nnaku b̯u̱zi̱li̱bei̱zi̱ra nka bbuukuulu, kabii b̯ukalibasenga nka kihehu, b̯u̱ti̱i̱ni̱ na b̯ujune b̯ub̯ulibakwata. ");
INSERT INTO rub_vpl VALUES ("PR1_28","021_1_28","PRO","1","28","28","Mwomwo bali̱nyesengereerya, bei̱tu̱ ti̱ndi̱bei̱ramwo, nab̯u̱bali̱ntoolya, tibalinzagya, ");
INSERT INTO rub_vpl VALUES ("PR1_29","021_1_29","PRO","1","29","29","hab̯wakubba baaswi̱ri̱ kwetegereza, baacwamwo b̯u̱tati̱i̱na Mukama. ");
INSERT INTO rub_vpl VALUES ("PR1_30","021_1_30","PRO","1","30","30","Hab̯wakubba batakeikirize kulamba kwange baagaya na bigambu byange, ");
INSERT INTO rub_vpl VALUES ("PR1_31","021_1_31","PRO","1","31","31","kwokwo baliwonawona hab̯wa ngesu zaab̯u, nibadwa ha kutamwa bikorwa byab̯u. ");
INSERT INTO rub_vpl VALUES ("PR1_32","021_1_32","PRO","1","32","32","Kubba b̯u̱teegwa b̯u̱kwi̱za kwi̱ta basi̱ru̱si̱ru̱, na b̯utafaayo nib̯umalaho badoma, ");
INSERT INTO rub_vpl VALUES ("PR1_33","021_1_33","PRO","1","33","33","bei̱tu̱ b̯uli anyeetegeerya yeicalanga mu b̯u̱si̱nge, atali na kyaku̱ti̱i̱na na b̯ujune.” ");
INSERT INTO rub_vpl VALUES ("PR2_1","021_2_1","PRO","2","1","1","Mwana wange, b̯wolikaikiriza bigambu byange, okata biragiro byange mu mutima gwamu, ");
INSERT INTO rub_vpl VALUES ("PR2_2","021_2_2","PRO","2","2","2","okatega ipokopo lyamu hali bigambu bya magezi̱ okata mutima gwamu kubyetegereza, ");
INSERT INTO rub_vpl VALUES ("PR2_3","021_2_3","PRO","2","3","3","kwokwo b̯wolikasaba magezi̱ okakunga nakukunga mwa kwetegereza, ");
INSERT INTO rub_vpl VALUES ("PR2_4","021_2_4","PRO","2","4","4","b̯woli̱kagatoolya nka feeza okagaheega nka byamuhendu, ");
INSERT INTO rub_vpl VALUES ("PR2_5","021_2_5","PRO","2","5","5","mwomwo olyetegereza kutamwo Mukama ki̱ti̱i̱ni̱sa, noogumbura magezi̱ ga Ruhanga. ");
INSERT INTO rub_vpl VALUES ("PR2_6","021_2_6","PRO","2","6","6","Kubba Mukama agaba magezi̱, mu mu̱nwa gwamwe harugamwo magezi̱ na kwetegereza. ");
INSERT INTO rub_vpl VALUES ("PR2_7","021_2_7","PRO","2","7","7","Abiikira barungi magezi̱, eicala ngab̯u gya batali na kakuu, ");
INSERT INTO rub_vpl VALUES ("PR2_8","021_2_8","PRO","2","8","8","alinda bakakora ha byab̯winganiza naawoneera mihanda mya barungi. ");
INSERT INTO rub_vpl VALUES ("PR2_9","021_2_9","PRO","2","9","9","Mwomwo olyetegereza birungi na b̯winganiza, na byosemereeri̱ kukora, ");
INSERT INTO rub_vpl VALUES ("PR2_10","021_2_10","PRO","2","10","10","hab̯wakubba olifooka mu̱gezi̱, kwetegereza na kusemererwa bi̱li̱i̱za mu mwozo gwamu. ");
INSERT INTO rub_vpl VALUES ("PR2_11","021_2_11","PRO","2","11","11","Kwegyendereza kwakuwoneeranga, kwetegereza kwakulinda, ");
INSERT INTO rub_vpl VALUES ("PR2_12","021_2_12","PRO","2","12","12","nikukujuna mihanda mibiibi, na badulu bakalu̱ma bigambu bibiibi, ");
INSERT INTO rub_vpl VALUES ("PR2_13","021_2_13","PRO","2","13","13","baleki̱ri̱ mihanda mya mananu bakulibatira mu nti̱ti̱, ");
INSERT INTO rub_vpl VALUES ("PR2_14","021_2_14","PRO","2","14","14","banyu̱mi̱rwa kukora kubiibi, nibeegonza mu bibii bitali na mu̱twe na magulu, ");
INSERT INTO rub_vpl VALUES ("PR2_15","021_2_15","PRO","2","15","15","boobo bakora bi̱kyamu̱, banyangesu zibiibi. ");
INSERT INTO rub_vpl VALUES ("PR2_16","021_2_16","PRO","2","16","16","Kwokwo galikujuna mu̱kali̱ mubiibi, hali malaaya wa bigambu bi̱heheeru̱, ");
INSERT INTO rub_vpl VALUES ("PR2_17","021_2_17","PRO","2","17","17","atali mwesigwa hali i̱ba, munyakusuula bi̱yaarahi̱i̱ri̱ mu mei̱so ga Ruhanga, ");
INSERT INTO rub_vpl VALUES ("PR2_18","021_2_18","PRO","2","18","18","kubba nnyu̱mba gyamwe gitwala mu ku̱zi̱ka, muhanda gwamwe kuzumu. ");
INSERT INTO rub_vpl VALUES ("PR2_19","021_2_19","PRO","2","19","19","Bensei̱ bamub̯ungira ti̱bei̱ra, habbe kwi̱ra mu muhanda gwa b̯womi. ");
INSERT INTO rub_vpl VALUES ("PR2_20","021_2_20","PRO","2","20","20","Nahab̯waki̱kyo ohonderenge muhanda gwa barungi, aleke woomeere mu mananu. ");
INSERT INTO rub_vpl VALUES ("PR2_21","021_2_21","PRO","2","21","21","Hab̯wakubba barungi baliicala mu nsi, na batali na kamogo balyomeera. ");
INSERT INTO rub_vpl VALUES ("PR2_22","021_2_22","PRO","2","22","22","Bei̱tu̱ babiibi, Ruhanga alibamalaho mu nsi, na bateegwa alibatemaho. ");
INSERT INTO rub_vpl VALUES ("PR3_1","021_3_1","PRO","3","1","1","Mwana wange, otalyebeera bigambu bi̱nku̱kwegeesya, bei̱tu̱ mutima gwamu gu̱kwi̱zu̱kyenge bi̱nyaaku̱ragi̱i̱ri̱, ");
INSERT INTO rub_vpl VALUES ("PR3_2","021_3_2","PRO","3","2","2","hab̯wakubba bilikuha kwomeera myaka minene, nibikuleetera b̯u̱si̱nge na b̯u̱gu̱u̱da. ");
INSERT INTO rub_vpl VALUES ("PR3_3","021_3_3","PRO","3","3","3","Ngonzi na b̯wesige bitalikurugaho, waabilwalanga mwi̱coti̱ lyamu, waabihandiikanga ha mutima gwamu. ");
INSERT INTO rub_vpl VALUES ("PR3_4","021_3_4","PRO","3","4","4","Mwomwo oli̱si̱i̱mwa nooheeb̯wa ki̱ti̱i̱ni̱sa mu mei̱so ga Ruhanga na bantu. ");
INSERT INTO rub_vpl VALUES ("PR3_5","021_3_5","PRO","3","5","5","Weesiganga Mukama na mutima gwamu gwensei̱, otalyesiga magezi̱ gaamu wankei, ");
INSERT INTO rub_vpl VALUES ("PR3_6","021_3_6","PRO","3","6","6","oikirizenge akwehembere hensei̱, ali̱terekereerya malibatire gaamu. ");
INSERT INTO rub_vpl VALUES ("PR3_7","021_3_7","PRO","3","7","7","Otetwalanga kubba mu̱gezi̱, bei̱tu̱ oti̱i̱nenge Mukama, kandi osuulenge kukora bibii. ");
INSERT INTO rub_vpl VALUES ("PR3_8","021_3_8","PRO","3","8","8","Ki̱kyo kyokyo kilibba mu̱bazi̱ hali b̯womi b̯wamu nikikumalaho b̯u̱ru̱mi̱. ");
INSERT INTO rub_vpl VALUES ("PR3_9","021_3_9","PRO","3","9","9","Waatangamwo Mukama ki̱ti̱i̱ni̱sa noomuha heitungo lyamu, kandi omuhenge makesa ga bilimwa byakubanza. ");
INSERT INTO rub_vpl VALUES ("PR3_10","021_3_10","PRO","3","10","10","Woolikabikora, oli̱zu̱u̱lya bideeru, nibisaaga na kusaaga, noi̱zu̱u̱lya byese byamu bya vi̱i̱no ha mu̱nwa. ");
INSERT INTO rub_vpl VALUES ("PR3_11","021_3_11","PRO","3","11","11","Mwana wange, otagayanga kulamba kwa Mukama, otalimujwaha yaakakuhab̯uranga. ");
INSERT INTO rub_vpl VALUES ("PR3_12","021_3_12","PRO","3","12","12","Hab̯wakubba Mukama ahab̯ura gi̱yendya, nka mu̱byeru̱ kwahab̯ura mwana gi̱yendya. ");
INSERT INTO rub_vpl VALUES ("PR3_13","021_3_13","PRO","3","13","13","Ali na mu̱gi̱sa yogwo aheeb̯wa magezi̱, na yogwo ali na kwetegereza. ");
INSERT INTO rub_vpl VALUES ("PR3_14","021_3_14","PRO","3","14","14","Kubba mugasu gwago gukira feeza magoba gaago gakira ga zaabbu. ");
INSERT INTO rub_vpl VALUES ("PR3_15","021_3_15","PRO","3","15","15","Magezi̱ gakira mahi̱ga ga muhendu. Tihaloho kyokusobora ku̱galengeseni̱a nakyo. ");
INSERT INTO rub_vpl VALUES ("PR3_16","021_3_16","PRO","3","16","16","Galeeta kwomeera ha rubaju lu̱mwei̱, ha lundi nigaleeta b̯u̱gu̱u̱da na ki̱ti̱i̱ni̱sa. ");
INSERT INTO rub_vpl VALUES ("PR3_17","021_3_17","PRO","3","17","17","B̯womi b̯ulimwo kusemererwa b̯uruga hali magezi̱, mikoore myago myensei̱ mya b̯u̱si̱nge. ");
INSERT INTO rub_vpl VALUES ("PR3_18","021_3_18","PRO","3","18","18","Gei̱sana musaali gwa b̯womi hali bab̯wo baagekwata, yogwo yensei̱ agakwatira ki̱mwei̱ abba na mu̱gi̱sa. ");
INSERT INTO rub_vpl VALUES ("PR3_19","021_3_19","PRO","3","19","19","Mukama, yaahangi̱ri̱ nsi kuraba mu magezi̱, kuraba mu kwetegereza yaahanga iguru. ");
INSERT INTO rub_vpl VALUES ("PR3_20","021_3_20","PRO","3","20","20","Kuraba mu kukenga yaateeri̱ho meezi̱ gakwahukana, na bikaka biguma ndagali̱. ");
INSERT INTO rub_vpl VALUES ("PR3_21","021_3_21","PRO","3","21","21","Mwana wange, magezi̱ na kwetegereza bitalikurugaho, obitenge biicale mu mutima gwamu. ");
INSERT INTO rub_vpl VALUES ("PR3_22","021_3_22","PRO","3","22","22","Bi̱kwi̱za kukuha b̯womi nibibba kyakulwala mwi̱coti̱. ");
INSERT INTO rub_vpl VALUES ("PR3_23","021_3_23","PRO","3","23","23","Mwomwo oliicala mu nsi otali̱naku̱ti̱i̱na, kigulu kyamu tikilikibbala. ");
INSERT INTO rub_vpl VALUES ("PR3_24","021_3_24","PRO","3","24","24","B̯wolilalanga kuhuumulaho, otali̱ti̱i̱nanga, b̯ulo b̯wamu b̯wakunoleranga. ");
INSERT INTO rub_vpl VALUES ("PR3_25","021_3_25","PRO","3","25","25","Otati̱i̱nanga bigwa bi̱taragi̱ri̱ habbe kadi kuhwerekeera kwa babiibi. ");
INSERT INTO rub_vpl VALUES ("PR3_26","021_3_26","PRO","3","26","26","Kubba Mukama alikulinda, talikuleka ku̱gwa mu mutegu. ");
INSERT INTO rub_vpl VALUES ("PR3_27","021_3_27","PRO","3","27","27","Otalituubiranga bantu bali mu b̯wetaagu, kakubba obba nokusobora kubibaha. ");
INSERT INTO rub_vpl VALUES ("PR3_28","021_3_28","PRO","3","28","28","Otaliweera mu̱taahi̱ nti, “Gyenda, wei̱ra mwakya,” b̯u̱b̯wo kandi nooli nakyo. ");
INSERT INTO rub_vpl VALUES ("PR3_29","021_3_29","PRO","3","29","29","Otalidyamwo rukwe mu̱taahi̱, hab̯wakubba eikiririza mu kwicaranwa. ");
INSERT INTO rub_vpl VALUES ("PR3_30","021_3_30","PRO","3","30","30","Otalizongoba na mwi̱ra waamu hataloho b̯ulyo, b̯u̱b̯wo hataloho kibiibi ki̱baku̱koori̱. ");
INSERT INTO rub_vpl VALUES ("PR3_31","021_3_31","PRO","3","31","31","Otalikwatirwa i̱hali̱ bantu banyagi̱ habbe kuhondera mihanda myab̯u. ");
INSERT INTO rub_vpl VALUES ("PR3_32","021_3_32","PRO","3","32","32","Kubba Mukama anoba nkori̱ za bibii bei̱tu̱ barungi abatamwo b̯wesige. ");
INSERT INTO rub_vpl VALUES ("PR3_33","021_3_33","PRO","3","33","33","Akyena maka ga babiibi, ga barungi, agaha mu̱gi̱sa. ");
INSERT INTO rub_vpl VALUES ("PR3_34","021_3_34","PRO","3","34","34","Asekereerya bantu beehaariiza, bei̱tu̱ agiira mbabazi̱ bab̯u̱ndaaru̱. ");
INSERT INTO rub_vpl VALUES ("PR3_35","021_3_35","PRO","3","35","35","Ki̱ti̱i̱ni̱sa kitumbula bagezi̱ bei̱tu̱ b̯udoma b̯uleeta muswaru. ");
INSERT INTO rub_vpl VALUES ("PR4_1","021_4_1","PRO","4","1","1","Baana bange, mwetegeeryenge kulamba kwa bbaaweenyu̱, muteho mutima aleke mubbe na kwetegereza, ");
INSERT INTO rub_vpl VALUES ("PR4_2","021_4_2","PRO","4","2","2","hab̯wakubba ndimukubaha magezi̱, mutalekanga kwegesya kwange. ");
INSERT INTO rub_vpl VALUES ("PR4_3","021_4_3","PRO","4","3","3","Nincaali na bbaabba nka musigazi muto, nindi mwana nyaki̱mwei̱ wa mmaama, mugonze, ");
INSERT INTO rub_vpl VALUES ("PR4_4","021_4_4","PRO","4","4","4","bbaabba yanzegeseerye yambwera, “Kwatiranga ki̱mwei̱ bigambu byange, okwatenge biragiro byange, mwomwo olyomeera, ");
INSERT INTO rub_vpl VALUES ("PR4_5","021_4_5","PRO","4","5","5","Tunga magezi̱, obbe na kwetegereza, otalibyebeera, otalibirugaho. ");
INSERT INTO rub_vpl VALUES ("PR4_6","021_4_6","PRO","4","6","6","Otaligagumirisana, galikulinda, waagolokyanga ngonzi, galikuha b̯u̱si̱nge. ");
INSERT INTO rub_vpl VALUES ("PR4_7","021_4_7","PRO","4","7","7","Ki̱handu̱, tunga magezi̱, nab̯wotalibba na kintu, obbenge na kwetegereza. ");
INSERT INTO rub_vpl VALUES ("PR4_8","021_4_8","PRO","4","8","8","Wendyanga magezi̱ galikufoora wa maani, b̯woligab̯umbatira gali̱ku̱tu̱ngi̱sya ki̱ti̱i̱ni̱sa. ");
INSERT INTO rub_vpl VALUES ("PR4_9","021_4_9","PRO","4","9","9","Galikulwalya kondo gya byakyo, galikuha ki̱ti̱i̱ni̱sa.” ");
INSERT INTO rub_vpl VALUES ("PR4_10","021_4_10","PRO","4","10","10","Weegwa mwana wange, ikiriza binkukuweera, obite mu mutima, mwomwo olyomeera. ");
INSERT INTO rub_vpl VALUES ("PR4_11","021_4_11","PRO","4","11","11","Nkwegeseerye bintu bya magezi̱, nkwolokeerye mihanda mya mananu. ");
INSERT INTO rub_vpl VALUES ("PR4_12","021_4_12","PRO","4","12","12","Tihaloho kilyekiika mu muhanda gwamu b̯wolibba nookwi̱ru̱ka, toli̱ki̱i̱bbala. ");
INSERT INTO rub_vpl VALUES ("PR4_13","021_4_13","PRO","4","13","13","Kwatira ki̱mwei̱ bi̱bakwegeseerye, otalibileka, waabilindanga, kubba byobyo b̯womi b̯wamu. ");
INSERT INTO rub_vpl VALUES ("PR4_14","021_4_14","PRO","4","14","14","Otagyenda mu muhanda gwa babiibi, habbe kuhunguuka hali nkori̱ za bibii. ");
INSERT INTO rub_vpl VALUES ("PR4_15","021_4_15","PRO","4","15","15","Gu̱gwo muhanda, ogwehalenge, okwatenge gwamu, niweegyendera. ");
INSERT INTO rub_vpl VALUES ("PR4_16","021_4_16","PRO","4","16","16","Babiibi tibalaala batakoori̱ kibii, tibeebbaka ku̱doosya bahu̱tei̱ze muntu. ");
INSERT INTO rub_vpl VALUES ("PR4_17","021_4_17","PRO","4","17","17","Kubba banolerwa bidyo bya b̯ubiibi, na maaci ga b̯u̱nyagi̱. ");
INSERT INTO rub_vpl VALUES ("PR4_18","021_4_18","PRO","4","18","18","Bei̱tu̱ muhanda gwa barungi gwisana kyererezi̱ kya mambya, ki̱syani̱a ku̱doosya b̯u̱kereeri̱ ki̱mwei̱. ");
INSERT INTO rub_vpl VALUES ("PR4_19","021_4_19","PRO","4","19","19","Muhanda gwa babiibi gwisana nti̱ti̱ gyeitumbi, b̯ubakiibbala, tibeega ki̱baki̱i̱bbali̱i̱rye. ");
INSERT INTO rub_vpl VALUES ("PR4_20","021_4_20","PRO","4","20","20","Mwana wange, taho mwozo gwamu ha bigambu binkukuweera, otege ipokopo weegwe ngeera zange. ");
INSERT INTO rub_vpl VALUES ("PR4_21","021_4_21","PRO","4","21","21","Otalibyebeera, oicalenge noobi̱i̱zu̱ka, obitenge ha mutima gwamu, ");
INSERT INTO rub_vpl VALUES ("PR4_22","021_4_22","PRO","4","22","22","kubba babigumbura bibaha b̯womi, ni̱bi̱honi̱a mubiri. ");
INSERT INTO rub_vpl VALUES ("PR4_23","021_4_23","PRO","4","23","23","Weegyenderezanga bi̱byo byokuteekereza, kubba byobyo ndugiiro gya b̯womi. ");
INSERT INTO rub_vpl VALUES ("PR4_24","021_4_24","PRO","4","24","24","Weehalanga lu̱nyu̱mi̱yo lu̱ku̱habi̱sya, otabazanga bigambu bibiibi. ");
INSERT INTO rub_vpl VALUES ("PR4_25","021_4_25","PRO","4","25","25","Lingiiranga hookugyenda otakumagamaga, otalinamwo kakwekubiira. ");
INSERT INTO rub_vpl VALUES ("PR4_26","021_4_26","PRO","4","26","26","Teekerezanga, otakakoori̱ kyokwendya kukora, mwomwo byokukora bilidwereera. ");
INSERT INTO rub_vpl VALUES ("PR4_27","021_4_27","PRO","4","27","27","Weehala bibii, olibatirenge harungi, otalihuguka b̯umoso rundi ha gwab̯udyo. ");
INSERT INTO rub_vpl VALUES ("PR5_1","021_5_1","PRO","5","1","1","Mwana wange, taho mutima ha magezi̱ gange, otege ipokopo lyamu weetegeerye kwetegereza kwange, ");
INSERT INTO rub_vpl VALUES ("PR5_2","021_5_2","PRO","5","2","2","aleke weege kubba mwegyenderezi̱, niweegyendereza bigambu byokubaza. ");
INSERT INTO rub_vpl VALUES ("PR5_3","021_5_3","PRO","5","3","3","Kubba mu̱nwa gwa mu̱kali̱ mwenzi̱ gu̱toonya b̯uhooki, na bigambu byamwe biheheera nka maku̱ta, ");
INSERT INTO rub_vpl VALUES ("PR5_4","021_5_4","PRO","5","4","4","bei̱tu̱ hei̱nyu̱ma aluluha nka ndulu, asala nka mpirima, giwa b̯wogi b̯ubiri. ");
INSERT INTO rub_vpl VALUES ("PR5_5","021_5_5","PRO","5","5","5","Magulu gaamwe gatwala mu ku̱zi̱ka, mihanda myamwe mi̱si̱ri̱mu̱ra kuzumu. ");
INSERT INTO rub_vpl VALUES ("PR5_6","021_5_6","PRO","5","6","6","Eicala kwahi mu muhanda gwa b̯womi, yenjeera, atali na ki̱yeegi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PR5_7","021_5_7","PRO","5","7","7","Kale nu baana bange, mu̱nzegwe, mutaliruga hali bigambu binkubaweera. ");
INSERT INTO rub_vpl VALUES ("PR5_8","021_5_8","PRO","5","8","8","Mu̱kali̱ yogwo mu̱mwehalenge, na mulyangu gwamwe mu̱tali̱gwesu̱maho, ");
INSERT INTO rub_vpl VALUES ("PR5_9","021_5_9","PRO","5","9","9","b̯umutamwehale, byakwekamba kwenyu̱ bilitwalwa bandi, mu̱li̱kwera mu ngalu za batemu. ");
INSERT INTO rub_vpl VALUES ("PR5_10","021_5_10","PRO","5","10","10","Banyamahanga balitwala itungu lyenyu̱, kwekamba kwenyu̱ ni̱ku̱gu̱u̱dahaarya bandi! ");
INSERT INTO rub_vpl VALUES ("PR5_11","021_5_11","PRO","5","11","11","Hooli̱kwera olibba nookutaaga, waanu̱ki̱ri̱ kudwereera ki̱mwei̱ kwi̱ku̱ha. ");
INSERT INTO rub_vpl VALUES ("PR5_12","021_5_12","PRO","5","12","12","Olikoba yati, “Wona nka ku̱nnyaaswi̱ri̱ kulambwa! Wona mutima gwange nka ku̱gwagayi̱ri̱ kuhab̯urwa! ");
INSERT INTO rub_vpl VALUES ("PR5_13","021_5_13","PRO","5","13","13","Ntakeegwe beegesa bange ntakateho mutima kukwata bi̱bambwerenge. ");
INSERT INTO rub_vpl VALUES ("PR5_14","021_5_14","PRO","5","14","14","Nnyeezagi̱i̱rye mu kabii kanyamaani mu mei̱so ga bantu ba Ruhanga.” ");
INSERT INTO rub_vpl VALUES ("PR5_15","021_5_15","PRO","5","15","15","Mu̱kali̱ waamu abba nkei̱zu̱ba lya meezi̱ gei̱cu̱mi̱, Weewe wankei onywenge meezi̱ gei̱zu̱ba lyamu, weewe wankei onywenge gakukulukuta. ");
INSERT INTO rub_vpl VALUES ("PR5_16","021_5_16","PRO","5","16","16","Hab̯waki misu myamu mikulukuutira hensei̱, na meezi̱ gaamu gahetera mu ngu̱u̱do? ");
INSERT INTO rub_vpl VALUES ("PR5_17","021_5_17","PRO","5","17","17","I̱zu̱ba lyamu lili lyamu wankei, tilili lyakunywa na bandi. ");
INSERT INTO rub_vpl VALUES ("PR5_18","021_5_18","PRO","5","18","18","Mukama alihe mu̱gi̱sa, weegonzenge na mu̱kali̱ wa mu b̯usigazi b̯wamu, ");
INSERT INTO rub_vpl VALUES ("PR5_19","021_5_19","PRO","5","19","19","murungi nka mparaaki, wa mbabazi̱ nka mu̱nsi̱hi̱, salaka gyamwe gyaku̱hu̱u̱mu̱lyanga biro byensei̱. ");
INSERT INTO rub_vpl VALUES ("PR5_20","021_5_20","PRO","5","20","20","Mwana wange, mu̱kali̱ mwenzi̱, weegombi̱ri̱ waaki? Hab̯waki ob̯u̱mbati̱ri̱ mu̱kali̱ atali waamu? ");
INSERT INTO rub_vpl VALUES ("PR5_21","021_5_21","PRO","5","21","21","Kubba Mukama, awona byensei̱ byokora, yeekebeeja b̯uli muhanda gwa muntu. ");
INSERT INTO rub_vpl VALUES ("PR5_22","021_5_22","PRO","5","22","22","Muntu akwatwa bibiibi byamwe, kandi abbohwa miguha mya bibii byamwe. ");
INSERT INTO rub_vpl VALUES ("PR5_23","021_5_23","PRO","5","23","23","B̯uteerinda b̯u̱kwi̱za ku̱mwi̱ti̱sya, hab̯wa b̯udoma b̯wamaani akwi̱za kuhwerekeera. ");
INSERT INTO rub_vpl VALUES ("PR6_1","021_6_1","PRO","6","1","1","Mwana wange, b̯wolitaho musimbo hab̯wa wondi, rundi okabba mwema wa mwi̱zei̱zi̱, ");
INSERT INTO rub_vpl VALUES ("PR6_2","021_6_2","PRO","6","2","2","olibba okwati̱i̱rwe kweraga kwamu, weebbohi̱ri̱ na kanwa kaamu. ");
INSERT INTO rub_vpl VALUES ("PR6_3","021_6_3","PRO","6","3","3","Kale nu mwana wange, hondera magezi̱ gankukuha, weejune, hab̯wakubba oli mu ngalu zaamwe. Gyenda weehombokereerye, omwesengereerye! ");
INSERT INTO rub_vpl VALUES ("PR6_4","021_6_4","PRO","6","4","4","Otalaala, oteebbaka na kwebbaka. ");
INSERT INTO rub_vpl VALUES ("PR6_5","021_6_5","PRO","6","5","5","Weejuna, nka mparaaki gi̱teesu̱ki̱ri̱i̱ri̱ mu̱hi̱gi̱, nka ki̱nyoni̱ ki̱teesu̱ki̱ri̱ ha mutegu. ");
INSERT INTO rub_vpl VALUES ("PR6_6","021_6_6","PRO","6","6","6","Wonera hali nkakabi, we mugarei, weetegereza nka kuzikora, obbe mu̱gezi̱! ");
INSERT INTO rub_vpl VALUES ("PR6_7","021_6_7","PRO","6","7","7","Tizigira mwebemberi̱, habbe mu̱keberi̱, rundi mu̱lemi̱, ");
INSERT INTO rub_vpl VALUES ("PR6_8","021_6_8","PRO","6","8","8","bei̱tu̱ zeebiikira byetaagu byazo ha makesa, nizisorooza bidyo mu kyanda. ");
INSERT INTO rub_vpl VALUES ("PR6_9","021_6_9","PRO","6","9","9","Ee bei̱tu̱, wee mugarei, olilaala kudwa di̱i̱? Oli̱si̱si̱mu̱ka mu b̯ulo di̱i̱? B̯wolikoba yati, ");
INSERT INTO rub_vpl VALUES ("PR6_10","021_6_10","PRO","6","10","10","“Kandaaleho kadooli̱, kandindeho kadooli̱, kammpu̱u̱mu̱u̱lyeho mikono kadooli̱,” ");
INSERT INTO rub_vpl VALUES ("PR6_11","021_6_11","PRO","6","11","11","mwomwo nnaku zi̱li̱kwi̱zi̱ra nka mwi̱bi̱, ni̱zi̱ku̱ru̱mba nka mutemu. ");
INSERT INTO rub_vpl VALUES ("PR6_12","021_6_12","PRO","6","12","12","Muntu mugwagwa kandi mubiibi eicala naagobyagobya, ");
INSERT INTO rub_vpl VALUES ("PR6_13","021_6_13","PRO","6","13","13","ku̱mi̱gami̱gi̱ri̱i̱rya mei̱so, ku̱zi̱gazi̱gi̱i̱zya magulu, na ngalu mwa kwebbumbiira. ");
INSERT INTO rub_vpl VALUES ("PR6_14","021_6_14","PRO","6","14","14","Mutima gwamwe guteekereza mu b̯ubii, naaku̱cu̱u̱ki̱ri̱i̱rya bantu. ");
INSERT INTO rub_vpl VALUES ("PR6_15","021_6_15","PRO","6","15","15","Kyokyo ali̱ru̱mb̯wa bizib̯u atakwega, mu kasu̱mi̱ kadooli̱ alibba acwacwani̱ki̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PR6_16","021_6_16","PRO","6","16","16","Haloho bintu mukaaga Mukama bi̱yaanobi̱ri̱, bili nka musanju byamuziro: ");
INSERT INTO rub_vpl VALUES ("PR6_17","021_6_17","PRO","6","17","17","mei̱so ga marara, kalimi ka b̯u̱gobya, ngalu gibbwoma ibbanga, ");
INSERT INTO rub_vpl VALUES ("PR6_18","021_6_18","PRO","6","18","18","mutima guteekerereza mu nkwe, magulu ganguha kukora kibii, ");
INSERT INTO rub_vpl VALUES ("PR6_19","021_6_19","PRO","6","19","19","mu̱kei̱so abaza byab̯u̱gobya, na mutab̯ura makaa. ");
INSERT INTO rub_vpl VALUES ("PR6_20","021_6_20","PRO","6","20","20","Mwana wange, weegwanga bbaawu byakukuragira, ohonderenge maawu bi̱yaakwegeserye. ");
INSERT INTO rub_vpl VALUES ("PR6_21","021_6_21","PRO","6","21","21","Bigambu byab̯u obitenge mu mutima gwamu, obibbohenge mwi̱coti̱ lyamu. ");
INSERT INTO rub_vpl VALUES ("PR6_22","021_6_22","PRO","6","22","22","Byakwehemberanga mu kulibata kwamu, byakulindanga weebbaki̱ri̱, byakulambanga osi̱si̱mu̱ki̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PR6_23","021_6_23","PRO","6","23","23","Kubba biragiro byab̯u, taara, kwegesya kwab̯u, kyererezi̱, na bibahab̯ura, muhanda gwa b̯womi. ");
INSERT INTO rub_vpl VALUES ("PR6_24","021_6_24","PRO","6","24","24","Obikwatenge bilikujuna mu̱kali̱ mubiibi, na b̯ugambu b̯wa mu̱kali̱ mwenzi̱. ");
INSERT INTO rub_vpl VALUES ("PR6_25","021_6_25","PRO","6","25","25","Otalimwegomba b̯urungi b̯wa mubiri, atali̱ku̱du̱u̱pa na mei̱so gaakulelembuka. ");
INSERT INTO rub_vpl VALUES ("PR6_26","021_6_26","PRO","6","26","26","Kubba malaaya atoolya ki̱yaagu̱li̱sya kayaadya, bei̱tu̱ mulaala mukaa wondi abba yeeheeri̱yo ku̱kwa. ");
INSERT INTO rub_vpl VALUES ("PR6_27","021_6_27","PRO","6","27","27","Naani yaab̯u̱mbati̱ri̱ mworo mu salaka, ngoye zaamwe zaalema kuhya? ");
INSERT INTO rub_vpl VALUES ("PR6_28","021_6_28","PRO","6","28","28","Naani yaali̱beeti̱ ha makala gakwokya, magulu gaamwe gaalema kuhya? ");
INSERT INTO rub_vpl VALUES ("PR6_29","021_6_29","PRO","6","29","29","Kwokwo abba yatyo mulaala mukaa wondi, yensei̱ akumweha alifubirwa. ");
INSERT INTO rub_vpl VALUES ("PR6_30","021_6_30","PRO","6","30","30","Mwi̱bi̱ yaakuganywirwa, kubba nzala gyogyo gi̱mwi̱bi̱sya. ");
INSERT INTO rub_vpl VALUES ("PR6_31","021_6_31","PRO","6","31","31","Bei̱tu̱ b̯wakwatwa, ali̱ha mirundi musanju, nab̯ukimalaho itungu lyamwe lyensei̱. ");
INSERT INTO rub_vpl VALUES ("PR6_32","021_6_32","PRO","6","32","32","Mudulu mwenzi̱, abba atali na magezi̱, abba naakwezi̱ta yankei. ");
INSERT INTO rub_vpl VALUES ("PR6_33","021_6_33","PRO","6","33","33","Bihuta na muswaru biicala mpeera gyamwe, Kihemu kyamwe tikilimalika. ");
INSERT INTO rub_vpl VALUES ("PR6_34","021_6_34","PRO","6","34","34","Hab̯wa mei̱ha i̱ba mu̱kali̱ alikwatwa b̯usungu, naahoora nzi̱go atali na kisa. ");
INSERT INTO rub_vpl VALUES ("PR6_35","021_6_35","PRO","6","35","35","Talikiriza b̯u̱li̱hi̱ b̯wensei̱, nab̯u̱bali̱teeryaho b̯u̱li̱hi̱, tib̯ulimalaho b̯usungu. ");
INSERT INTO rub_vpl VALUES ("PR7_1","021_7_1","PRO","7","1","1","Mwana wange, kwatanga bigambu byange otalyebeera biragiro byange. ");
INSERT INTO rub_vpl VALUES ("PR7_2","021_7_2","PRO","7","2","2","Obikwatenge mwa kwomeera, nka mboni̱ gya li̱i̱so olindenge bi̱nkwegesya, ");
INSERT INTO rub_vpl VALUES ("PR7_3","021_7_3","PRO","7","3","3","obyebbohenge ha ngalu zaamu, obihandiike ha mutima gwamu. ");
INSERT INTO rub_vpl VALUES ("PR7_4","021_7_4","PRO","7","4","4","Oweerenge magezi̱, “Weewe nyakeetu̱,” weetanga kwetegereza mwijuwo, ");
INSERT INTO rub_vpl VALUES ("PR7_5","021_7_5","PRO","7","5","5","bilikujuna mukaa wondi, na yogwo mwohya. ");
INSERT INTO rub_vpl VALUES ("PR7_6","021_7_6","PRO","7","6","6","Haloho kiro ki̱nyeemereeri̱ ku di̱ri̱sa nyaalingiira hanzei, ");
INSERT INTO rub_vpl VALUES ("PR7_7","021_7_7","PRO","7","7","7","nyaaweeni̱ho basigazi, ntwarwa, nyeetegerezamwo omwei̱, atakabbe na magezi̱, ");
INSERT INTO rub_vpl VALUES ("PR7_8","021_7_8","PRO","7","8","8","naakulibalibata heigemero lya ngu̱u̱do, heehi̱ na nnyu̱mba gya mu̱kali̱, naakugyenda wu yogwo mu̱kali̱ ");
INSERT INTO rub_vpl VALUES ("PR7_9","021_7_9","PRO","7","9","9","joojolo, kaswekusweku, b̯wi̱re nib̯ukubbumba, mu kati̱ti̱. ");
INSERT INTO rub_vpl VALUES ("PR7_10","021_7_10","PRO","7","10","10","Wona mu̱kali̱ ku̱yaamu̱tangi̱ri̱i̱ri̱, alweri̱ nka malaaya, ku̱mwohya. ");
INSERT INTO rub_vpl VALUES ("PR7_11","021_7_11","PRO","7","11","11","(Mu̱kali̱ yogwo wampaka, mu̱jeemu̱, teicara kwamu̱gi̱, ");
INSERT INTO rub_vpl VALUES ("PR7_12","021_7_12","PRO","7","12","12","nka hati̱, omwegwera ku ru̱gu̱u̱do, ha katali, naakutegatega.) ");
INSERT INTO rub_vpl VALUES ("PR7_13","021_7_13","PRO","7","13","13","B̯u̱yaakaweeni̱ musigazi, amub̯umbatira amunwegera, amu̱ku̱ndu̱li̱ra mei̱so amuweera: ");
INSERT INTO rub_vpl VALUES ("PR7_14","021_7_14","PRO","7","14","14","“Mmpongi̱ri̱yo deeru kyonzira kya b̯u̱si̱nge, nyaadoosereerya bi̱byo bi̱nyeeragi̱ri̱, ");
INSERT INTO rub_vpl VALUES ("PR7_15","021_7_15","PRO","7","15","15","kyokyo nnzi̱ri̱ kukutangiira, nceeri̱ ni̱nku̱toolya, nkwagi̱i̱rye! ");
INSERT INTO rub_vpl VALUES ("PR7_16","021_7_16","PRO","7","16","16","Ntabbu gyange ngyali̱ri̱ho suuka zirungi, ziwa rangi̱, zi̱nyi̱ri̱ru̱ za Mi̱si̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PR7_17","021_7_17","PRO","7","17","17","Ngi̱fu̱hi̱ri̱i̱ri̱ maku̱ta gaku̱wu̱nya kurungi, b̯ubbaani, migaaju na bi̱b̯u̱nya bindi. ");
INSERT INTO rub_vpl VALUES ("PR7_18","021_7_18","PRO","7","18","18","I̱za twegonze i̱jolo lyensei̱, twolokyengane ngonzi. ");
INSERT INTO rub_vpl VALUES ("PR7_19","021_7_19","PRO","7","19","19","Hab̯wakubba ibange waahi̱yo, yaagyendi̱ri̱ hadei, ");
INSERT INTO rub_vpl VALUES ("PR7_20","021_7_20","PRO","7","20","20","yaatwalageeni̱ sente zinene, akwi̱ra i̱nyu̱ma lya sabbi̱i̱ti̱ ibiri.” ");
INSERT INTO rub_vpl VALUES ("PR7_21","021_7_21","PRO","7","21","21","Kwokwo yaamu̱sooni̱ri̱ naaku̱mu̱du̱u̱pa, yaamu̱gobya naakumusikiriza. ");
INSERT INTO rub_vpl VALUES ("PR7_22","021_7_22","PRO","7","22","22","Nahaahwo musigazi yaamuhondere, nka nnumi gikutwalwa mwibagiro, nka mu̱nsi̱hi̱ gu̱sambi̱ri̱ mutegu, ");
INSERT INTO rub_vpl VALUES ("PR7_23","021_7_23","PRO","7","23","23","ku̱doosya gu̱tu̱ti̱i̱rwe nigukakwa, nka ki̱nyoni̱ ki̱ku̱zeenyera mu mutegu, ti̱yeegi̱ri̱ kwakugyenda ku̱kwa. ");
INSERT INTO rub_vpl VALUES ("PR7_24","021_7_24","PRO","7","24","24","Kale nu baana bange, mu̱nyeetegeerye, mu̱kwate bigambu binkubaweera. ");
INSERT INTO rub_vpl VALUES ("PR7_25","021_7_25","PRO","7","25","25","Mu̱kali̱ yogwo atalibahugura mitima, mutalihondera mihanda myamwe, ");
INSERT INTO rub_vpl VALUES ("PR7_26","021_7_26","PRO","7","26","26","hab̯wakubba eti̱si̱i̱rye badulu banene, tibasobora kubabalwa. ");
INSERT INTO rub_vpl VALUES ("PR7_27","021_7_27","PRO","7","27","27","Nnyu̱mba gyamwe gi̱si̱ru̱mu̱ra kuzumu, cali hali bi̱si̱i̱ka bya Lu̱ku̱u̱. ");
INSERT INTO rub_vpl VALUES ("PR8_1","021_8_1","PRO","8","1","1","Mwegwe, wamagezi̱ kwalimukukoba! Muhondere, Mwetegerezi̱ byalimu kwami̱i̱rya! ");
INSERT INTO rub_vpl VALUES ("PR8_2","021_8_2","PRO","8","2","2","Hakyendi̱ ha rubamba ha ngu̱u̱do, ha masangananzira hooho yeemereeri̱. ");
INSERT INTO rub_vpl VALUES ("PR8_3","021_8_3","PRO","8","3","3","Heirembu mu mei̱so ga rub̯uga ha rubaju lwa mulyangu, akukoba yati, ");
INSERT INTO rub_vpl VALUES ("PR8_4","021_8_4","PRO","8","4","4","“Nywe bantu nywe, bandimukuweera, nywe baana ba bantu banku̱pompogeerya. ");
INSERT INTO rub_vpl VALUES ("PR8_5","021_8_5","PRO","8","5","5","Nywe ntwarwa, mwecwerengemwo, nywe badomadoma, mwetegereze. ");
INSERT INTO rub_vpl VALUES ("PR8_6","021_8_6","PRO","8","6","6","Mwegwe mbaweere bya mugasu, bigambu bimbaza biicala birungi. ");
INSERT INTO rub_vpl VALUES ("PR8_7","021_8_7","PRO","8","7","7","Kubba kalimi kange kabaza mananu, mu̱nwa gwange guzira b̯u̱gobya. ");
INSERT INTO rub_vpl VALUES ("PR8_8","021_8_8","PRO","8","8","8","Mbaza bigambu bya mananu bisa, bitalimwo b̯u̱gobya, habbe kwehinduhindula. ");
INSERT INTO rub_vpl VALUES ("PR8_9","021_8_9","PRO","8","9","9","Hali mwetegerezi̱ byensei̱ bimubbeera mananu, bi̱si̱i̱mwa b̯u̱si̱i̱mwa ali na magezi̱. ");
INSERT INTO rub_vpl VALUES ("PR8_10","021_8_10","PRO","8","10","10","Mwegombe bi̱babeegeseerye kukira feeza, na magezi̱ kukira zaabbu gi̱sengejeerwe, ");
INSERT INTO rub_vpl VALUES ("PR8_11","021_8_11","PRO","8","11","11","hab̯wakubba magezi̱ gakira mahi̱ga ga muhendu, tihaloho kigeerenga. ");
INSERT INTO rub_vpl VALUES ("PR8_12","021_8_12","PRO","8","12","12","“Gya Magezi̱, nsisana nkeicala na Mweri̱ndi̱, nyeetegeri̱i̱ze nyaatunga kucwamwo. ");
INSERT INTO rub_vpl VALUES ("PR8_13","021_8_13","PRO","8","13","13","Ku̱ti̱i̱na Mukama kwokwo kunoba kibii, nnoba myepanku na kwetembatembya, ngesu zibiibi na mbaza gibiibi. ");
INSERT INTO rub_vpl VALUES ("PR8_14","021_8_14","PRO","8","14","14","Gyagya mpab̯ura kandi mpanulira kurungi, mba na kwetegereza na maani. ");
INSERT INTO rub_vpl VALUES ("PR8_15","021_8_15","PRO","8","15","15","Nntaho bakama nibafuga, balemi̱ nibataho biragiro birungi. ");
INSERT INTO rub_vpl VALUES ("PR8_16","021_8_16","PRO","8","16","16","Bahandu̱ bafuga hab̯wange, babbe balemi̱ na baramu̱ri̱ ba mu nsi. ");
INSERT INTO rub_vpl VALUES ("PR8_17","021_8_17","PRO","8","17","17","Aku̱nzolokya ngonzi nagya mwolokya ngonzi, yogwo aku̱ntoolya alinzagya. ");
INSERT INTO rub_vpl VALUES ("PR8_18","021_8_18","PRO","8","18","18","B̯u̱gu̱u̱da na ki̱ti̱i̱ni̱sa byange, gya ngaba mi̱gi̱sa neitungu litamalika. ");
INSERT INTO rub_vpl VALUES ("PR8_19","021_8_19","PRO","8","19","19","Bintu bingaba bikira zaabbu b̯urungi, bikiira ki̱mwei̱ na feeza gi̱sengeeje. ");
INSERT INTO rub_vpl VALUES ("PR8_20","021_8_20","PRO","8","20","20","Bikorwa byange biicala hasyanu̱, ngyendera mu mananu, ");
INSERT INTO rub_vpl VALUES ("PR8_21","021_8_21","PRO","8","21","21","bakunzendya mbaha itungu, ni̱beezu̱u̱lya bideeru byab̯u. ");
INSERT INTO rub_vpl VALUES ("PR8_22","021_8_22","PRO","8","22","22","“Mukama yampangi̱ri̱ atakahangi̱ri̱ nsi, mu bi̱yaahangi̱ri̱ kadei gyagya abanza. ");
INSERT INTO rub_vpl VALUES ("PR8_23","021_8_23","PRO","8","23","23","Mu biro bya kadei, nyaabu̱mbi̱i̱rwe, mu kubanza, nsi gi̱takabbeeri̱ho. ");
INSERT INTO rub_vpl VALUES ("PR8_24","021_8_24","PRO","8","24","24","Nyaabyali̱i̱rwe hatakabbeeri̱ho mataka, migira mi̱takabbeeri̱ho. ");
INSERT INTO rub_vpl VALUES ("PR8_25","021_8_25","PRO","8","25","25","Nsau zi̱takabbeeri̱ho, mbamba zi̱takahangi̱i̱rwe, nnyaaloho, ");
INSERT INTO rub_vpl VALUES ("PR8_26","021_8_26","PRO","8","26","26","nsi gi̱takahangi̱i̱rwe na misiri myaho, habbe kadi cuucu gya mu nsi. ");
INSERT INTO rub_vpl VALUES ("PR8_27","021_8_27","PRO","8","27","27","Kannyaaloho, b̯uyaali nakutaho iguru, b̯u̱yaateeri̱ho mitaanu myeitaka, ");
INSERT INTO rub_vpl VALUES ("PR8_28","021_8_28","PRO","8","28","28","b̯uyaali nakubamba bikaka hakyendi̱, b̯u̱yaatati̱i̱rye misu mya kuzumu, ");
INSERT INTO rub_vpl VALUES ("PR8_29","021_8_29","PRO","8","29","29","b̯uyaali nakutaho mitaanu myeitaka, aleke meezi̱ gasambire hayaagaragi̱i̱ri̱, nab̯u̱yaateeri̱ho mi̱si̱nge mya nsi. ");
INSERT INTO rub_vpl VALUES ("PR8_30","021_8_30","PRO","8","30","30","Nnyaali mu̱ku̱gu̱ ha rubaju lwamwe, yei̱calengi̱ asemererwe hab̯wange, na gya ninsemererwa hab̯wamwe. ");
INSERT INTO rub_vpl VALUES ("PR8_31","021_8_31","PRO","8","31","31","Ndyegonza mu nsi gyange, ninsemererwa na bantu baamwo. ");
INSERT INTO rub_vpl VALUES ("PR8_32","021_8_32","PRO","8","32","32","“Kale nu hataati̱, baana bange mu̱nzegwe! Bali na mu̱gi̱sa bahondera kuhab̯urwa kwange. ");
INSERT INTO rub_vpl VALUES ("PR8_33","021_8_33","PRO","8","33","33","Mwegwengenge bi̱mbeegesya mubbe bagezi̱, mutalibigumisirana. ");
INSERT INTO rub_vpl VALUES ("PR8_34","021_8_34","PRO","8","34","34","Ali na mu̱gi̱sa anzegwa, eicala ali̱ngi̱ri̱i̱ri̱ irembu lyange, ali̱ndi̱ri̱i̱ri̱ mulyangu gwange. ");
INSERT INTO rub_vpl VALUES ("PR8_35","021_8_35","PRO","8","35","35","Kubba abba nagya abba na b̯womi, Mukama amugiira mbabazi̱ ");
INSERT INTO rub_vpl VALUES ("PR8_36","021_8_36","PRO","8","36","36","bei̱tu̱ atali nagya yeeru̱mya yankei, bensei̱ bannoba babba ni̱bakwendya ku̱kwa.” ");
INSERT INTO rub_vpl VALUES ("PR9_1","021_9_1","PRO","9","1","1","Wamagezi̱ abi̱mbi̱ri̱ nnyu̱mba gyamwe, yaagiteera mpagi̱ musanju. ");
INSERT INTO rub_vpl VALUES ("PR9_2","021_9_2","PRO","9","2","2","Ei̱ti̱ri̱ kisolo kyamwe ahyangi̱i̱rye maaci gaamwe yaati̱mba na kiihuru. ");
INSERT INTO rub_vpl VALUES ("PR9_3","021_9_3","PRO","9","3","3","Atu̱mi̱ri̱ bazaana baamwe, beete bantu mu bicweka binyamaani mu rub̯uga. ");
INSERT INTO rub_vpl VALUES ("PR9_4","021_9_4","PRO","9","4","4","“Akali ntwarwa, ei̱ze haha!” Mpwi̱se amu̱weereeri̱ yati, ");
INSERT INTO rub_vpl VALUES ("PR9_5","021_9_5","PRO","9","5","5","“I̱za, odye bidyo bi̱nti̱mbi̱ri̱, onywe maaci gampyagi̱i̱rye. ");
INSERT INTO rub_vpl VALUES ("PR9_6","021_9_6","PRO","9","6","6","Mu̱leke b̯udoma aleke mwomeere, Libata na bakwetegereza.” ");
INSERT INTO rub_vpl VALUES ("PR9_7","021_9_7","PRO","9","7","7","Acoomera mu̱gayi̱, yeesyomera bi̱lu̱mo, ahab̯ura mubiibi, yeeleetera bihuta. ");
INSERT INTO rub_vpl VALUES ("PR9_8","021_9_8","PRO","9","8","8","Otahab̯uranga mu̱gayi̱, kubba alikunoba. Ahab̯ura mu̱gezi̱, b̯ufooka b̯u̱nywani̱. ");
INSERT INTO rub_vpl VALUES ("PR9_9","021_9_9","PRO","9","9","9","B̯wolamba mu̱gezi̱, eicala na wa magezi̱, kwegesya murungi, ateeryaho ha ki̱yeegi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PR9_10","021_9_10","PRO","9","10","10","Ndugiiro gya magezi̱ gili mu ku̱ti̱i̱na Mukama, kwega Mu̱syanu̱ Akiira Ki̱mwei̱, kubba kwetegereza. ");
INSERT INTO rub_vpl VALUES ("PR9_11","021_9_11","PRO","9","11","11","Kubba na magezi̱ ki̱teeryaho biro bya kwomeera, ki̱teerya na b̯unene b̯wa myaka mya b̯womi. ");
INSERT INTO rub_vpl VALUES ("PR9_12","021_9_12","PRO","9","12","12","B̯wobba na magezi̱ obba weegasi̱i̱ri̱, b̯wogagaya ni̱weeru̱mya wankei. ");
INSERT INTO rub_vpl VALUES ("PR9_13","021_9_13","PRO","9","13","13","Mu̱kali̱ mudoma eicala naatokatooka, tagira ngesu, tali na ki̱yeegi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PR9_14","021_9_14","PRO","9","14","14","Eicaara ha mulyagu gwamwe, ha ntebe mu kiikaru, hakyendi̱ mu rub̯uga, ");
INSERT INTO rub_vpl VALUES ("PR9_15","021_9_15","PRO","9","15","15","niyeetanga bakurabaho, bali mu mihanda myab̯u nti, ");
INSERT INTO rub_vpl VALUES ("PR9_16","021_9_16","PRO","9","16","16","“Ntwarwa gyensei̱ gi̱i̱ze haha.” Aweera mpwi̱se yati, ");
INSERT INTO rub_vpl VALUES ("PR9_17","021_9_17","PRO","9","17","17","“Meezi̱ gei̱be googo gamala nnyoota, na bidyo bibadya mu nsita, byobyo binola!” ");
INSERT INTO rub_vpl VALUES ("PR9_18","021_9_18","PRO","9","18","18","Bei̱tu̱ bo badulu tibeega nti, hali̱yo b̯uzire, bagenyi̱ baamwe beicala kuzumu. ");
INSERT INTO rub_vpl VALUES ("PR10_1","021_10_1","PRO","10","1","1","Ngeera za Sulumaani: Mwana mu̱gezi̱ aha bbaawe kusemererwa, bei̱tu̱ mudoma ali̱rya mmaawe. ");
INSERT INTO rub_vpl VALUES ("PR10_2","021_10_2","PRO","10","2","2","Itungu lya b̯u̱gobya tiligasa, bei̱tu̱ mananu gahoni̱a lu̱ku̱u̱. ");
INSERT INTO rub_vpl VALUES ("PR10_3","021_10_3","PRO","10","3","3","Mukama taleka barungi kudiib̯wa nzala bei̱tu̱ babiibi tibali na kyalibaha. ");
INSERT INTO rub_vpl VALUES ("PR10_4","021_10_4","PRO","10","4","4","Ngalu gya mugarei gileeta nnaku bei̱tu̱ gya mwekambi̱ b̯u̱gu̱u̱da. ");
INSERT INTO rub_vpl VALUES ("PR10_5","021_10_5","PRO","10","5","5","Mwana mu̱gezi̱ akesa mu kyanda, bei̱tu̱ mwolo, aleeta muswaru ha makesa. ");
INSERT INTO rub_vpl VALUES ("PR10_6","021_10_6","PRO","10","6","6","Barungi baheeb̯wa mu̱gi̱sa, bei̱tu̱ kanwa ka mubiibi kabbumbiira b̯wemi̱. ");
INSERT INTO rub_vpl VALUES ("PR10_7","021_10_7","PRO","10","7","7","Murungi bamwi̱zu̱ki̱ra mi̱gi̱sa myamwe, bei̱tu̱ ibara lya mubiibi li̱zi̱ka b̯u̱zi̱ki̱. ");
INSERT INTO rub_vpl VALUES ("PR10_8","021_10_8","PRO","10","8","8","Mutima gwa magezi̱ gukwata bi̱bagu̱ragi̱i̱ri̱, bei̱tu̱ ku̱logozona kwa mudoma kulimalika. ");
INSERT INTO rub_vpl VALUES ("PR10_9","021_10_9","PRO","10","9","9","Alibatira mu mananu, abba na b̯u̱si̱nge, bei̱tu̱ akwebi̱si̱i̱ra azooka b̯u̱zooki̱. ");
INSERT INTO rub_vpl VALUES ("PR10_10","021_10_10","PRO","10","10","10","Mwi̱ta li̱i̱so mwa kubbumba mananu, aleeta b̯ujune, na aku̱logozona bya b̯udoma ali̱zi̱ka. ");
INSERT INTO rub_vpl VALUES ("PR10_11","021_10_11","PRO","10","11","11","Kanwa ka murungi keisana musu gwa b̯womi, bei̱tu̱ ka mubiibi kabbumbiira b̯wemi̱. ");
INSERT INTO rub_vpl VALUES ("PR10_12","021_10_12","PRO","10","12","12","Nnobi̱ zileeta izongobo, bei̱tu̱ ngonzi zibbumba bibiibi byensei̱. ");
INSERT INTO rub_vpl VALUES ("PR10_13","021_10_13","PRO","10","13","13","Bigambu bya mu̱kengeb̯u̱ bibbamwo magezi̱, bei̱tu̱ mpwi̱se awonawona na mubbeere. ");
INSERT INTO rub_vpl VALUES ("PR10_14","021_10_14","PRO","10","14","14","Kideeru kya bagezi̱, kwegeseb̯wa kwab̯u, bei̱tu̱ kanwa ka mudoma kaleeta kuhwerekeera. ");
INSERT INTO rub_vpl VALUES ("PR10_15","021_10_15","PRO","10","15","15","Itungu lya mu̱gu̱u̱da lili nka rub̯uga lwamwe lunyamaani, bei̱tu̱ banaku bahwerekeera mu b̯usege b̯wab̯u. ");
INSERT INTO rub_vpl VALUES ("PR10_16","021_10_16","PRO","10","16","16","Mpeera gya bikorwa birungi, b̯womi, bei̱tu̱ babiibi bagoboora mu kukora bibii. ");
INSERT INTO rub_vpl VALUES ("PR10_17","021_10_17","PRO","10","17","17","Akwata bi̱baamu̱ragi̱i̱ri̱, abba mu muhanda gwa b̯womi, bei̱tu̱ akugaya kulamba, mu̱habya. ");
INSERT INTO rub_vpl VALUES ("PR10_18","021_10_18","PRO","10","18","18","Ali na nzi̱ngo mu mutima, tabaza mananu, mudoma akora gwa kulibatya rugambu. ");
INSERT INTO rub_vpl VALUES ("PR10_19","021_10_19","PRO","10","19","19","Mu bigambu binene, kibiibi tikilemwamwo, bei̱tu̱ mu̱gezi̱ yeerinda kalimi kaamwe. ");
INSERT INTO rub_vpl VALUES ("PR10_20","021_10_20","PRO","10","20","20","Bigambu bya murungi feeza, bei̱tu̱ mutima gwa mubiibi tigugasa. ");
INSERT INTO rub_vpl VALUES ("PR10_21","021_10_21","PRO","10","21","21","Bigambu bya murungi bigasira banene, bei̱tu̱ badoma bei̱twa b̯utakenga. ");
INSERT INTO rub_vpl VALUES ("PR10_22","021_10_22","PRO","10","22","22","Mu̱gi̱sa gwa Mukama guleeta itungu, tigubbaho b̯ujune b̯wensei̱. ");
INSERT INTO rub_vpl VALUES ("PR10_23","021_10_23","PRO","10","23","23","Mazeenyi̱zeenyi̱ mudoma yeezagya naakukora kibii, bei̱tu̱ akwetegereza anyu̱mi̱rwa kukora bya magezi̱. ");
INSERT INTO rub_vpl VALUES ("PR10_24","021_10_24","PRO","10","24","24","Kya mubiibi akwehala, kilimudwaho, na barungi bibeegomba, byabaheeb̯wanga. ");
INSERT INTO rub_vpl VALUES ("PR10_25","021_10_25","PRO","10","25","25","B̯ujune b̯wisana kihehu, kikuuta babiibi, bei̱tu̱ barungi beicalaho biro byensei̱. ");
INSERT INTO rub_vpl VALUES ("PR10_26","021_10_26","PRO","10","26","26","Mugarei asaaliza mu̱mu̱tu̱mi̱, nka ndwa wa musinyi kub̯ulumira, rundi nka mwi̱ca kugusiiha mei̱so. ");
INSERT INTO rub_vpl VALUES ("PR10_27","021_10_27","PRO","10","27","27","Mu ku̱ti̱i̱na Mukama heicalamwo kwomeera, bei̱tu̱ mubiibi agira biro bi̱dooli̱. ");
INSERT INTO rub_vpl VALUES ("PR10_28","021_10_28","PRO","10","28","28","Ku̱ni̱hi̱ra kuleetera barungi kusemererwa, bei̱tu̱ babiibi balindiira bibataliwonaho. ");
INSERT INTO rub_vpl VALUES ("PR10_29","021_10_29","PRO","10","29","29","Mukama yooyo b̯wi̱ru̱ki̱ro b̯wa barungi, bei̱tu̱ nkori̱ za bibii, ali̱zi̱hwerekeerya. ");
INSERT INTO rub_vpl VALUES ("PR10_30","021_10_30","PRO","10","30","30","Tihaloho alidemula barungi, bei̱tu̱ babiibi tibeicala mu nsi. ");
INSERT INTO rub_vpl VALUES ("PR10_31","021_10_31","PRO","10","31","31","Kanwa ka mu̱gezi̱ kabaza bya magezi̱, bei̱tu̱ kalimi ka mubiibi balikasala. ");
INSERT INTO rub_vpl VALUES ("PR10_32","021_10_32","PRO","10","32","32","Barungi babaza bigambu bikwikirizib̯wa, bei̱tu̱ mu̱nwa gubiibi gu̱hu̱lu̱kya bikusaaliza. ");
INSERT INTO rub_vpl VALUES ("PR11_1","021_11_1","PRO","11","1","1","Mukama anoba bi̱pi̱myo bi̱tadoori̱, bei̱tu̱ asi̱i̱ma bi̱doori̱. ");
INSERT INTO rub_vpl VALUES ("PR11_2","021_11_2","PRO","11","2","2","Hei̱nyu̱ma wa myepanku, hei̱zaho nsoni̱, bei̱tu̱ mu kub̯undaara halimwo magezi̱. ");
INSERT INTO rub_vpl VALUES ("PR11_3","021_11_3","PRO","11","3","3","Bananu Beega mu̱li̱ngo gwa kukora bi̱doori̱, bei̱tu̱ bateesigwa, balihwerekeera. ");
INSERT INTO rub_vpl VALUES ("PR11_4","021_11_4","PRO","11","4","4","Itungu tililimugasa ha kiro kya kumucwera musangu, bei̱tu̱ b̯urungi b̯wa mutima b̯ulimujuna lu̱ku̱u̱. ");
INSERT INTO rub_vpl VALUES ("PR11_5","021_11_5","PRO","11","5","5","Muntu murungi yeega mu̱li̱ngo gwa kukora bi̱dooori̱, bei̱tu̱ mubiibi yeeletera ku̱zi̱ka. ");
INSERT INTO rub_vpl VALUES ("PR11_6","021_11_6","PRO","11","6","6","Barungi bajunwa hab̯wa kukora mananu, bei̱tu̱ bateesigwa balikwatirwa mu bibeegomba. ");
INSERT INTO rub_vpl VALUES ("PR11_7","021_11_7","PRO","11","7","7","Mubiibi akwa na byeni̱hi̱zo byamwe, na bi̱yani̱hi̱rengi̱ kutunga ni̱bi̱syera. ");
INSERT INTO rub_vpl VALUES ("PR11_8","021_11_8","PRO","11","8","8","B̯unanu wa muntu b̯umujuna bizib̯u, bei̱tu̱ ni̱bi̱i̱ri̱ra babiibi. ");
INSERT INTO rub_vpl VALUES ("PR11_9","021_11_9","PRO","11","9","9","Kanwa kaateegi̱ri̱ Ruhanga kahwerekeereerya bataahi̱, bei̱tu̱ kwetegereza kwa barungi kubajunambe. ");
INSERT INTO rub_vpl VALUES ("PR11_10","021_11_10","PRO","11","10","10","Mi̱gi̱sa mya barungi mi̱bi̱mba rub̯uga, ku̱kwa kwa babiibi kuleeta kusemererwa. ");
INSERT INTO rub_vpl VALUES ("PR11_11","021_11_11","PRO","11","11","11","Barungi baleetera rub̯uga kuhanda, bei̱tu̱ bya babiibi babaza biluletera kuhwerekeera. ");
INSERT INTO rub_vpl VALUES ("PR11_12","021_11_12","PRO","11","12","12","Mugaya bei̱ra abba mudoma, bei̱tu̱ mu̱gezi̱ yeerinda kalimi kaamwe. ");
INSERT INTO rub_vpl VALUES ("PR11_13","021_11_13","PRO","11","13","13","Warugambu yensei̱ alu̱mbu̱u̱la nsita, bei̱tu̱ mwesigwa agibbumbirambe. ");
INSERT INTO rub_vpl VALUES ("PR11_14","021_11_14","PRO","11","14","14","Ihanga b̯ulitabba na mwebemberi̱ mu̱gezi̱ lihwerekeerambe, bei̱tu̱ hali bakuhab̯ura banene habbaho b̯u̱si̱nge. ");
INSERT INTO rub_vpl VALUES ("PR11_15","021_11_15","PRO","11","15","15","Yemerera munyamahanga abba nakweletera bizub̯u, bei̱tu̱ asuula kumuha b̯wema abba na b̯u̱si̱nge. ");
INSERT INTO rub_vpl VALUES ("PR11_16","021_11_16","PRO","11","16","16","Mu̱kali̱ wa mbabazi̱ aheeb̯wa ki̱ti̱i̱ni̱sa, bei̱tu̱ badulu batemu batunga itungu lisa. ");
INSERT INTO rub_vpl VALUES ("PR11_17","021_11_17","PRO","11","17","17","Mudulu wa mbabazi̱, asagirwa mbabazi̱ zaamwe, bei̱tu̱ babiibi beeleetera bizub̯u. ");
INSERT INTO rub_vpl VALUES ("PR11_18","021_11_18","PRO","11","18","18","Itungu lya mubiibi tilicalaho, bei̱tu̱ akora birungi atunga bi̱mu̱semereeri̱. ");
INSERT INTO rub_vpl VALUES ("PR11_19","021_11_19","PRO","11","19","19","Akwatira ki̱mwei̱ kukora bi̱doori̱ alyomeera, bei̱tu̱ aku̱toolya b̯ubiibi ali̱zi̱ka. ");
INSERT INTO rub_vpl VALUES ("PR11_20","021_11_20","PRO","11","20","20","Mukama anoba bateekereza bibiibi, bei̱tu̱ yendya bakora birungi. ");
INSERT INTO rub_vpl VALUES ("PR11_21","021_11_21","PRO","11","21","21","Mu mananu babiibi balifubirwa, bei̱tu̱ barungi, kabii tikalibadwaho. ");
INSERT INTO rub_vpl VALUES ("PR11_22","021_11_22","PRO","11","22","22","Ndengeeti̱ gitali na ngesu, giisana mpi̱ta gya zaabbu mu nni̱ndo gya mpunu. ");
INSERT INTO rub_vpl VALUES ("PR11_23","021_11_23","PRO","11","23","23","Barungi bibeegomba bibaleetera birungi, bei̱tu̱ bya babiibi bani̱hi̱ra bibarugirwamwo kubakwatirwa ki̱ni̱ga. ");
INSERT INTO rub_vpl VALUES ("PR11_24","021_11_24","PRO","11","24","24","Haloho agaba na b̯wenda naateeryaho b̯u̱teerya itungu lyamwe, wondi naanakuhara hab̯wa b̯wi̱mi̱ b̯wamwe. ");
INSERT INTO rub_vpl VALUES ("PR11_25","021_11_25","PRO","11","25","25","Ali mwenda ali̱gu̱du̱hara, na akonyera bantu yoodede alikonyerwa. ");
INSERT INTO rub_vpl VALUES ("PR11_26","021_11_26","PRO","11","26","26","Abi̱sa bidyo bi̱bakwendya kugula, bamubaza kubiibi, bei̱tu̱ atundira habakubyetagira aheeb̯wa mu̱gi̱sa. ");
INSERT INTO rub_vpl VALUES ("PR11_27","021_11_27","PRO","11","27","27","Atoolya birungi yaagya birungi, bei̱tu̱ b̯ubiibi b̯wi̱zi̱ra aku̱b̯u̱toolya. ");
INSERT INTO rub_vpl VALUES ("PR11_28","021_11_28","PRO","11","28","28","Yeesiga b̯u̱gu̱u̱da b̯wamwe alikunkumuka nka bikoora bi̱hotoku̱, bei̱tu̱ barungi balyomeera nka bikoora bibisi. ");
INSERT INTO rub_vpl VALUES ("PR11_29","021_11_29","PRO","11","29","29","Atuntuza maka gaamwe, tali na kyalitunga, kandi mudoma afugwa mu̱gezi̱ biro byensei̱. ");
INSERT INTO rub_vpl VALUES ("PR11_30","021_11_30","PRO","11","30","30","B̯urungi b̯uleeta b̯womi, mu̱gezi̱ asika mitima mya bantu. ");
INSERT INTO rub_vpl VALUES ("PR11_31","021_11_31","PRO","11","31","31","Barungi bakabba na mpeera gyab̯u mumu mu nsi, na nkori̱ za bibii zi̱kwi̱za kufubirwa! ");
INSERT INTO rub_vpl VALUES ("PR12_1","021_12_1","PRO","12","1","1","Yendya kwega, anywana magezi̱, bei̱tu̱ anoba kuhab̯urwa abba mudoma. ");
INSERT INTO rub_vpl VALUES ("PR12_2","021_12_2","PRO","12","2","2","Mukama asi̱i̱ma barungi, bei̱tu̱ anoba bakora bya b̯u̱jeemu̱. ");
INSERT INTO rub_vpl VALUES ("PR12_3","021_12_3","PRO","12","3","3","B̯ubiibi tib̯uleeta b̯u̱si̱nge, bei̱tu̱ murungi abba mu̱si̱gi̱ku̱. ");
INSERT INTO rub_vpl VALUES ("PR12_4","021_12_4","PRO","12","4","4","Mu̱kali̱ mwegyenderezi̱ aheesya i̱ba ki̱ti̱i̱ni̱sa, bei̱tu̱ mu̱hemu̱ri̱ eisana kookoro mu maku̱ha gaamwe. ");
INSERT INTO rub_vpl VALUES ("PR12_5","021_12_5","PRO","12","5","5","Biteekerezu bya barungi byolokya b̯winganiza, bei̱tu̱ kuhab̯ura kwa babiibi b̯ubba b̯u̱gobya ");
INSERT INTO rub_vpl VALUES ("PR12_6","021_12_6","PRO","12","6","6","Babiibi babaza bya b̯wi̱ti̱, bei̱tu̱ kubaza kwa barungi kujuna bantu. ");
INSERT INTO rub_vpl VALUES ("PR12_7","021_12_7","PRO","12","7","7","Babiibi bahwerekeera ni̱basyeraho, bei̱tu̱ nnyu̱mba gya barungi gilyomeera. ");
INSERT INTO rub_vpl VALUES ("PR12_8","021_12_8","PRO","12","8","8","Ali na magezi̱ asi̱i̱mwambe, bei̱tu̱ wa biteekerezu bibiibi agayuwambe ");
INSERT INTO rub_vpl VALUES ("PR12_9","021_12_9","PRO","12","9","9","Kirungi kub̯undaara nooli na kyoli nakyo, kukira kwehaariiza otali na kyakudya. ");
INSERT INTO rub_vpl VALUES ("PR12_10","021_12_10","PRO","12","10","10","Muntu murungi mutima agumaara ha bisolo byamwe, bei̱tu̱ mubiibi tabba na mbabazi̱ nabyo. ");
INSERT INTO rub_vpl VALUES ("PR12_11","021_12_11","PRO","12","11","11","Akwekamba kulima abba na bidyo binene, bei̱tu̱ ei̱ru̱kya bitakugasa abba mudoma. ");
INSERT INTO rub_vpl VALUES ("PR12_12","021_12_12","PRO","12","12","12","Babiibi tibabba na b̯u̱si̱gi̱ki̱ro, bei̱tu̱ barungi babba basi̱gi̱ku̱ nka ikolo lya musaali. ");
INSERT INTO rub_vpl VALUES ("PR12_13","021_12_13","PRO","12","13","13","Kanwa kabiibi kabonebonesya mukamako, bei̱tu̱ murungi akena kabii. ");
INSERT INTO rub_vpl VALUES ("PR12_14","021_12_14","PRO","12","14","14","Bigambu birungi bi̱si̱i̱mwa na birungi, bikorwa birungi biheeb̯wa mpeera gyabyo. ");
INSERT INTO rub_vpl VALUES ("PR12_15","021_12_15","PRO","12","15","15","Mudoma ateekereza b̯uli byakora bibba bi̱doori̱, bei̱tu̱ mu̱gezi̱ yeetegeerya bibakumuhab̯ura. ");
INSERT INTO rub_vpl VALUES ("PR12_16","021_12_16","PRO","12","16","16","Ki̱ni̱ga kya mudoma ti̱kyebi̱sa, bei̱tu̱ mu̱gezi̱ baalu̱ma nagaya b̯u̱gayi̱. ");
INSERT INTO rub_vpl VALUES ("PR12_17","021_12_17","PRO","12","17","17","Mu̱kei̱so wa mazima aleetaho b̯winganiza, bei̱tu̱ mu̱gobya abaza b̯u̱gobya. ");
INSERT INTO rub_vpl VALUES ("PR12_18","021_12_18","PRO","12","18","18","Bigambu bya b̯ugwagwa bi̱tu̱u̱ta nka mpirima, bei̱tu̱ kalimi ka mu̱gezi̱ kaleeta kuhona. ");
INSERT INTO rub_vpl VALUES ("PR12_19","021_12_19","PRO","12","19","19","B̯u̱gobya b̯wicalaho b̯wi̱re b̯u̱dooli̱, bei̱tu̱ mazima biro na biro. ");
INSERT INTO rub_vpl VALUES ("PR12_20","021_12_20","PRO","12","20","20","Nkori̱ za bibii zitekereza mu kukora bibiibi, bei̱tu̱ bateekereza birungi babba na kusemererwa. ");
INSERT INTO rub_vpl VALUES ("PR12_21","021_12_21","PRO","12","21","21","Murungi talidweb̯waho kabii, bei̱tu̱ babiibi beicala nibawonawona. ");
INSERT INTO rub_vpl VALUES ("PR12_22","021_12_22","PRO","12","22","22","Mukama annoba babaza b̯u̱gobya, kyonkei asi̱i̱ma bananu. ");
INSERT INTO rub_vpl VALUES ("PR12_23","021_12_23","PRO","12","23","23","Mu̱gezi̱ ti̱yolokya kwetegereza kwamwe, bei̱tu̱ mudoma ararangya b̯udoma b̯wamwe. ");
INSERT INTO rub_vpl VALUES ("PR12_24","021_12_24","PRO","12","24","24","Kwekamba kufoora bantu kubba beebemberi̱, b̯ugarei nib̯ubaha kubba beiru. ");
INSERT INTO rub_vpl VALUES ("PR12_25","021_12_25","PRO","12","25","25","Kwelalikiira kuleetera muntu b̯ujune, bei̱tu̱ bigambu birungi bimuha kusemererwa. ");
INSERT INTO rub_vpl VALUES ("PR12_26","021_12_26","PRO","12","26","26","Murungi aterekereerya bei̱ra baamwe, bei̱tu̱ mubiibi abahabya b̯u̱habya. ");
INSERT INTO rub_vpl VALUES ("PR12_27","021_12_27","PRO","12","27","27","Mwolo alemwa kadi ku̱ti̱mba byamwe, bei̱tu̱ mwekambi̱ atunga b̯inene. ");
INSERT INTO rub_vpl VALUES ("PR12_28","021_12_28","PRO","12","28","28","Muhanda gwa bananu gutwala mu b̯womi, hatali mu lu̱ku̱u̱. ");
INSERT INTO rub_vpl VALUES ("PR13_1","021_13_1","PRO","13","1","1","Mwana mu̱gezi̱ yeegwa bbaawe byakumulamba, bei̱tu̱ mu̱gayi̱ ti̱yeegwa. ");
INSERT INTO rub_vpl VALUES ("PR13_2","021_13_2","PRO","13","2","2","Murungi byabaza bi̱mu̱heesya birungi, bei̱tu̱ kwegomba kwa mubiibi b̯wicala b̯ulemu. ");
INSERT INTO rub_vpl VALUES ("PR13_3","021_13_3","PRO","13","3","3","Akwerinda kalimi alinda b̯womi b̯wamwe, bei̱tu̱ muhonyola mu̱nwa yeeleetera kabii. ");
INSERT INTO rub_vpl VALUES ("PR13_4","021_13_4","PRO","13","4","4","Bantu bagarei bendya bintu kandi tibabitunga, bei̱tu̱ bakukora na maani batunga byensei̱ bi̱bakwendya. ");
INSERT INTO rub_vpl VALUES ("PR13_5","021_13_5","PRO","13","5","5","Muntu murungi anoba b̯u̱gobya, bei̱tu̱ babiibi bakora bikuhemura kandi bikuswaza. ");
INSERT INTO rub_vpl VALUES ("PR13_6","021_13_6","PRO","13","6","6","B̯urungi b̯ulinda mwinganiza, bei̱tu̱ kibii ki̱hwerekereerya babiibi. ");
INSERT INTO rub_vpl VALUES ("PR13_7","021_13_7","PRO","13","7","7","Haloho yeefoora mu̱gu̱u̱da naali munaku, na yeefoora munaku naali mu̱gu̱u̱da. ");
INSERT INTO rub_vpl VALUES ("PR13_8","021_13_8","PRO","13","8","8","Mu̱gu̱u̱da acungurwa itungu lyamwe, bei̱tu̱ tihabbaho aku̱ti̱i̱ni̱sya munaku. ");
INSERT INTO rub_vpl VALUES ("PR13_9","021_13_9","PRO","13","9","9","Barungi beisana taara gikwaka ni̱gi̱syani̱a bei̱tu̱ babiibi beisana taara gi̱ku̱lu̱mi̱i̱ra. ");
INSERT INTO rub_vpl VALUES ("PR13_10","021_13_10","PRO","13","10","10","Myehembu mileeta b̯ujune, bei̱tu̱ eikiriza kuhab̯urwa abba mu̱gezi̱. ");
INSERT INTO rub_vpl VALUES ("PR13_11","021_13_11","PRO","13","11","11","Itungu lya b̯wangu b̯wangu limalika b̯wangu, bei̱tu̱ li̱i̱za mpula lyeteeryaho b̯weteerya. ");
INSERT INTO rub_vpl VALUES ("PR13_12","021_13_12","PRO","13","12","12","Ku̱ni̱hi̱ra mu kitaabbeho ki̱hi̱mbi̱sya mutima, bei̱tu̱ kutunga kyokwendya gubba musaali gwa b̯womi. ");
INSERT INTO rub_vpl VALUES ("PR13_13","021_13_13","PRO","13","13","13","Atalambwa yeeleetera b̯ujune, bei̱tu̱ ahondera biragiro, aheeb̯wa mpeera. ");
INSERT INTO rub_vpl VALUES ("PR13_14","021_13_14","PRO","13","14","14","Kwegesya kwa bagezi̱, gubba musu gwa b̯womi, gukutanga ku̱gwa mu mitegu mya lu̱ku̱u̱. ");
INSERT INTO rub_vpl VALUES ("PR13_15","021_13_15","PRO","13","15","15","Kwetegereza kuleeta mbabazi̱, bei̱tu̱ butetegereza b̯utwala mu kuhwerekeera. ");
INSERT INTO rub_vpl VALUES ("PR13_16","021_13_16","PRO","13","16","16","Mu̱gezi̱, akoresya kwetegereza bei̱tu̱ mudoma eicala naahaariiza b̯udoma b̯wamwe. ");
INSERT INTO rub_vpl VALUES ("PR13_17","021_13_17","PRO","13","17","17","Mukwenda ateesigwa aleeta b̯ujune, bei̱tu̱ akwesigwa, aleeta b̯u̱si̱nge. ");
INSERT INTO rub_vpl VALUES ("PR13_18","021_13_18","PRO","13","18","18","Agaya kuhab̯urwa, yeegimbira nnaku na muswaru, bei̱tu̱ eikiriza kulambwa aheeb̯wa ki̱ti̱i̱ni̱sa. ");
INSERT INTO rub_vpl VALUES ("PR13_19","021_13_19","PRO","13","19","19","Kutunga kiwegombanga kikuha kusemererwa, bei̱tu̱ kyamuziro badoma b̯utahenera. ");
INSERT INTO rub_vpl VALUES ("PR13_20","021_13_20","PRO","13","20","20","Alibata na bagezi̱, nayo abba mu̱gezi̱, kyonkei b̯wolinywana badoma oli wakuwona nnaku. ");
INSERT INTO rub_vpl VALUES ("PR13_21","021_13_21","PRO","13","21","21","Kabii kagyenda na babiibi, bei̱tu̱ akora birungi aheeb̯wa mu̱gi̱sa. ");
INSERT INTO rub_vpl VALUES ("PR13_22","021_13_22","PRO","13","22","22","Murungi ati̱ga itungu libagwetera na beezukulu, bei̱tu̱ lya mubiibi lidiib̯wa bamananu. ");
INSERT INTO rub_vpl VALUES ("PR13_23","021_13_23","PRO","13","23","23","Kisambu kya munaku kyerya binene, bei̱tu̱ nibinyagwa banyamaani. ");
INSERT INTO rub_vpl VALUES ("PR13_24","021_13_24","PRO","13","24","24","Atakwata mubbeere kuhab̯ura mwanawe abba amu̱nobi̱ri̱, kyonkei aku̱mwendya ataho mutima kumuhab̯ura. ");
INSERT INTO rub_vpl VALUES ("PR13_25","021_13_25","PRO","13","25","25","Barungi babba nabibakudya nibeicuta, bei̱tu̱ babiibi beicala nibalira nzala. ");
INSERT INTO rub_vpl VALUES ("PR14_1","021_14_1","PRO","14","1","1","Mu̱kali̱ mu̱gezi̱ ani̱hi̱ri̱i̱rya maka gaamwe, bei̱tu̱ mu̱kali̱ mudoma agahenera hab̯wa b̯udoma. ");
INSERT INTO rub_vpl VALUES ("PR14_2","021_14_2","PRO","14","2","2","Akora birungi ati̱i̱na Mukama, bei̱tu̱ nkori̱ gya bibii gimugaya b̯u̱gayi̱. ");
INSERT INTO rub_vpl VALUES ("PR14_3","021_14_3","PRO","14","3","3","Kalimi ka mudoma kamuha kukuutwa mubbeere, bei̱tu̱ bagezi̱ babaza bibajuna. ");
INSERT INTO rub_vpl VALUES ("PR14_4","021_14_4","PRO","14","4","4","Nte zi̱li̱mi̱ ha zitali, bideeru bibba bisa, bei̱tu̱ bidyo byera binene hali zinyamaani zili. ");
INSERT INTO rub_vpl VALUES ("PR14_5","021_14_5","PRO","14","5","5","Mu̱kei̱so munanu abaza mananu, bei̱tu̱ mu̱gobya abaza b̯u̱gobya. ");
INSERT INTO rub_vpl VALUES ("PR14_6","021_14_6","PRO","14","6","6","Mu̱gayi̱ b̯watoolya magezi̱ tagaagya, bei̱tu̱ mu̱gezi̱ yeetegereza b̯wangu hoi̱ ");
INSERT INTO rub_vpl VALUES ("PR14_7","021_14_7","PRO","14","7","7","Weehalanga mudoma, kubba talikwegesya kyamagezi̱. ");
INSERT INTO rub_vpl VALUES ("PR14_8","021_14_8","PRO","14","8","8","Magezi̱ ga akwetegereza gamuhab̯ura byakukora, bei̱tu̱ b̯udoma b̯u̱habya b̯u̱habya. ");
INSERT INTO rub_vpl VALUES ("PR14_9","021_14_9","PRO","14","9","9","Mudoma b̯waguma musangu agaya b̯u̱gayi̱, bei̱tu̱ murungi asaba kuganyirwa. ");
INSERT INTO rub_vpl VALUES ("PR14_10","021_14_10","PRO","14","10","10","B̯uli Muntu yeega b̯ujune b̯wamwe yankei, kandi tihaloho yeega kusemererwa kwa mutima gwa wondi. ");
INSERT INTO rub_vpl VALUES ("PR14_11","021_14_11","PRO","14","11","11","Nnyu̱mba gya babiibi giliswaswanika, bei̱tu̱ gya murungi gilyomeera. ");
INSERT INTO rub_vpl VALUES ("PR14_12","021_14_12","PRO","14","12","12","Haloho muhanda gu̱zooka gurungi mu mei̱so ga muntu, bei̱tu̱ gumaliira nigutwala mu lu̱ku̱u̱. ");
INSERT INTO rub_vpl VALUES ("PR14_13","021_14_13","PRO","14","13","13","Na munseku mutima gusobora kutuntura, kandi kusemererwa b̯ukumalika hei̱zaho b̯ujune. ");
INSERT INTO rub_vpl VALUES ("PR14_14","021_14_14","PRO","14","14","14","Babiibi balitunga mpeera gi̱basemereeri̱, bei̱tu̱ murungi aliheeb̯wa gikwisana na bikorwa byamwe. ");
INSERT INTO rub_vpl VALUES ("PR14_15","021_14_15","PRO","14","15","15","Mudoma eikiriza kibakamu̱weereeri̱, kyonkei mu̱gezi̱ abanza kwetegereza hakugyenda. ");
INSERT INTO rub_vpl VALUES ("PR14_16","021_14_16","PRO","14","16","16","Mu̱gezi̱ yeegyendereza niyeehala kukora bibii, bei̱tu̱ mudoma akora nsobi̱ mu b̯utegyendereza. ");
INSERT INTO rub_vpl VALUES ("PR14_17","021_14_17","PRO","14","17","17","Waki̱ni̱ga kya b̯wangu akora byab̯udoma, bantu banoba muntu wa b̯u̱gobya. ");
INSERT INTO rub_vpl VALUES ("PR14_18","021_14_18","PRO","14","18","18","Mudoma atunga bi̱semereeri̱ b̯udoma, bei̱tu̱ mu̱gezi̱ aheeb̯wa mpeera gya kwetegereza. ");
INSERT INTO rub_vpl VALUES ("PR14_19","021_14_19","PRO","14","19","19","Babiibi bali̱ku̱ndi̱ra barungi malu̱, nabatali na mananu nabo baku̱ndi̱re bamananu. ");
INSERT INTO rub_vpl VALUES ("PR14_20","021_14_20","PRO","14","20","20","Munaku annob̯wa na bataahi̱, bei̱tu̱ mu̱gu̱u̱da abba na banywani banene. ");
INSERT INTO rub_vpl VALUES ("PR14_21","021_14_21","PRO","14","21","21","Mugaya bei̱ra abba mubiibi, bei̱tu̱ mwenda hali banaku abba na mu̱gi̱sa. ");
INSERT INTO rub_vpl VALUES ("PR14_22","021_14_22","PRO","14","22","22","Bantu bategeka kukora bibii babba bahabi̱ri̱, bei̱tu̱ bo beetegekera kukora kurungi beicala mu ngonzi na mananu. ");
INSERT INTO rub_vpl VALUES ("PR14_23","021_14_23","PRO","14","23","23","B̯uli akukora na maani atunga magoba, bei̱tu̱ kwicalira ngambu kuleeta nnaku. ");
INSERT INTO rub_vpl VALUES ("PR14_24","021_14_24","PRO","14","24","24","Kondo gya mu̱gezi̱ libba itungu, bei̱tu̱ b̯udoma b̯uleeta b̯udoma. ");
INSERT INTO rub_vpl VALUES ("PR14_25","021_14_25","PRO","14","25","25","Mu̱kei̱so wa mananu ajunira b̯womi, bei̱tu̱ mu̱gobya abba mu̱di̱raseni̱. ");
INSERT INTO rub_vpl VALUES ("PR14_26","021_14_26","PRO","14","26","26","Atamwo Mukama ki̱ti̱i̱ni̱sa abba mu̱si̱gi̱ku̱, na baana baamwe balibba nahaakwi̱ru̱ki̱ra. ");
INSERT INTO rub_vpl VALUES ("PR14_27","021_14_27","PRO","14","27","27","Ku̱ti̱i̱na Mukama, gwogwo musu gwa b̯womi, kijuna muntu mitegu mya lu̱ku̱u̱. ");
INSERT INTO rub_vpl VALUES ("PR14_28","021_14_28","PRO","14","28","28","Ki̱ti̱i̱ni̱sa kya mukama bakiwonera hali b̯unene wa bantu bakulema, bei̱tu̱ tikyegeb̯wa nakufuga badooli̱. ");
INSERT INTO rub_vpl VALUES ("PR14_29","021_14_29","PRO","14","29","29","Mukwata mpula abba nakwetegereza kunene, bei̱tu̱ wa ki̱ni̱ga kya b̯wangu yoolokya b̯udoma. ");
INSERT INTO rub_vpl VALUES ("PR14_30","021_14_30","PRO","14","30","30","Ateekeeni̱ mutima abba na mubiri gwomi, bei̱tu̱ i̱hali̱ lidya maku̱ha nka kookoro. ");
INSERT INTO rub_vpl VALUES ("PR14_31","021_14_31","PRO","14","31","31","Awonesya munaku agaya munyakumuhanga, bei̱tu̱ akwatirwa museege kisa atamwo Ruhanga ki̱ti̱i̱ni̱sa. ");
INSERT INTO rub_vpl VALUES ("PR14_32","021_14_32","PRO","14","32","32","Mubiibi ei̱twa kibii kyamwe, bei̱tu̱ murungi nawaakwa abba na haakwi̱ru̱ki̱ra. ");
INSERT INTO rub_vpl VALUES ("PR14_33","021_14_33","PRO","14","33","33","Mukwetegereza habbamwo magezi̱, bei̱tu̱ mudoma tagagira. ");
INSERT INTO rub_vpl VALUES ("PR14_34","021_14_34","PRO","14","34","34","B̯unanu b̯uha ihanga ki̱ti̱i̱ni̱sa, bei̱tu̱ kibii kileetera bantu bensei̱ muswaru. ");
INSERT INTO rub_vpl VALUES ("PR14_35","021_14_35","PRO","14","35","35","Mwiru akora birungi asi̱i̱mwa mukama waamwe, bei̱tu̱ afubira akukora bikuswaza. ");
INSERT INTO rub_vpl VALUES ("PR15_1","021_15_1","PRO","15","1","1","Kalimi kaheheeru̱ kamalaho ki̱ni̱ga, bei̱tu̱ bigambu bi̱kakaaru̱ bi̱ki̱teeryaho b̯u̱teerya. ");
INSERT INTO rub_vpl VALUES ("PR15_2","021_15_2","PRO","15","2","2","Kalimi ka mu̱gezi̱ kaleeta kwetegereza, bei̱tu̱ kanwa ka mudoma kahu̱lu̱kya byab̯udoma. ");
INSERT INTO rub_vpl VALUES ("PR15_3","021_15_3","PRO","15","3","3","Mukama awona hensei̱, eicala naawona barungi na babiibi. ");
INSERT INTO rub_vpl VALUES ("PR15_4","021_15_4","PRO","15","4","4","Kalimi karungi kaleeta b̯womi, bei̱tu̱ b̯u̱gobya b̯ucwa ntima. ");
INSERT INTO rub_vpl VALUES ("PR15_5","021_15_5","PRO","15","5","5","Mudoma agaya kulamba kwa bbaawe, bei̱tu̱ mu̱gezi̱ eikiriza bi̱bamu̱lambi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PR15_6","021_15_6","PRO","15","6","6","Maka ga barungi gabbamu itungu linene, bei̱tu̱ mpeera gya babiibi gileeta b̯ujune. ");
INSERT INTO rub_vpl VALUES ("PR15_7","021_15_7","PRO","15","7","7","Kalimi ka mu̱gezi̱ kasasaani̱a kwetegereza, bei̱tu̱ biteekerezu bya mudoma tibibbamwo karungi kensei̱. ");
INSERT INTO rub_vpl VALUES ("PR15_8","021_15_8","PRO","15","8","8","Mukama anoba bihongwa bya babiibi, bei̱tu̱ asi̱i̱ma kusaba kwa barungi. ");
INSERT INTO rub_vpl VALUES ("PR15_9","021_15_9","PRO","15","9","9","Mukama anoba bikorwa bya babiibi, bei̱tu̱ yendya bya barungi. ");
INSERT INTO rub_vpl VALUES ("PR15_10","021_15_10","PRO","15","10","10","Wolikora bibiibi olifubirwa hoi̱, woolisuula kuhab̯urwa, oli̱kwa. ");
INSERT INTO rub_vpl VALUES ("PR15_11","021_15_11","PRO","15","11","11","Mukama haawonera bali kuzumu, na bili mu mutima gwa muntu abyegi̱ri̱ ");
INSERT INTO rub_vpl VALUES ("PR15_12","021_15_12","PRO","15","12","12","Mu̱gayi̱ anoba kulambwa, nahab̯waki̱kyo yeehala bagezi̱. ");
INSERT INTO rub_vpl VALUES ("PR15_13","021_15_13","PRO","15","13","13","Kusemererwa bakuwonera ha b̯u̱syo wa muntu, bei̱tu̱ mutima gu̱zi̱ngalu̱ gubba na nganye. ");
INSERT INTO rub_vpl VALUES ("PR15_14","021_15_14","PRO","15","14","14","Mu̱gezi̱ yendya kwega, bei̱tu̱ mudoma anyu̱mi̱rwa bya b̯udoma. ");
INSERT INTO rub_vpl VALUES ("PR15_15","021_15_15","PRO","15","15","15","Munaku eicala naagadagada, bei̱tu̱ bantu bali na kusemererwa beicala nibeegonza. ");
INSERT INTO rub_vpl VALUES ("PR15_16","021_15_16","PRO","15","16","16","Hakiri obba munaku aku̱ti̱i̱na Mukama, kukira kubba mu̱gu̱u̱da otali na b̯u̱si̱nge. ");
INSERT INTO rub_vpl VALUES ("PR15_17","021_15_17","PRO","15","17","17","Hakiri ondya i̱ji̱ri̱ hali ngonzi zili, kukira kudya nnyama hei̱zwi̱ri̱ nnobi̱. ");
INSERT INTO rub_vpl VALUES ("PR15_18","021_15_18","PRO","15","18","18","Wa ki̱ni̱ga kya b̯wangu, atab̯ura b̯ulemu, Bei̱tu̱ mukwata mpula alu̱mi̱ri̱i̱rya izongobo. ");
INSERT INTO rub_vpl VALUES ("PR15_19","021_15_19","PRO","15","19","19","Muhanda gwa mugarei gubbumbwa mahwa, bei̱tu̱ gwa munanu gubba gu̱terekereru̱. ");
INSERT INTO rub_vpl VALUES ("PR15_20","021_15_20","PRO","15","20","20","Mwana mu̱gezi̱ aleetera bbaawe kusemererwa, bei̱tu̱ mudoma agaya bya maawe. ");
INSERT INTO rub_vpl VALUES ("PR15_21","021_15_21","PRO","15","21","21","Ntwarwa gi̱nyu̱mi̱rwa b̯udoma, bei̱tu̱ mu̱gezi̱ akora bi̱doori̱. ");
INSERT INTO rub_vpl VALUES ("PR15_22","021_15_22","PRO","15","22","22","Hatali muhe wa magezi̱ ntegeka zisobambe, bei̱tu̱ b̯u̱hei̱zaho bahab̯u̱ri̱ banene niziterekeera. ");
INSERT INTO rub_vpl VALUES ("PR15_23","021_15_23","PRO","15","23","23","Kigambu ki̱i̱zi̱ra mu b̯wi̱re b̯wonyi̱ni̱, kileetera muntu kusemererwa. ");
INSERT INTO rub_vpl VALUES ("PR15_24","021_15_24","PRO","15","24","24","Bagezi̱ bakwata muhanda gukutwala mu b̯womi, hatali gukutwala kuzumu. ");
INSERT INTO rub_vpl VALUES ("PR15_25","021_15_25","PRO","15","25","25","Mukama azi̱kya makaa gehembahemba, bei̱tu̱ alinda bya bamukaabakwere. ");
INSERT INTO rub_vpl VALUES ("PR15_26","021_15_26","PRO","15","26","26","Mukama annoba biteekerezu bibiibi, bei̱tu̱ asemereerwa mu bigambu birungi. ");
INSERT INTO rub_vpl VALUES ("PR15_27","021_15_27","PRO","15","27","27","Wa mururu gwa bintu bya b̯u̱nyagi̱ aleetera makaa gaamwe b̯ujune, bei̱tu̱ anoba kwegu̱li̱ri̱i̱rya alyomeera. ");
INSERT INTO rub_vpl VALUES ("PR15_28","021_15_28","PRO","15","28","28","Barungi babanza nibateekereza batakei̱ri̱ri̱mwo, bei̱tu̱ babiibi babaza ki̱kei̱zi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PR15_29","021_15_29","PRO","15","29","29","Bantu barungi b̯ubasaba Mukama ni̱yeegwa, bei̱tu̱ babiibi ababba hadei. ");
INSERT INTO rub_vpl VALUES ("PR15_30","021_15_30","PRO","15","30","30","B̯u̱syo b̯wa kamwenyumwenyu b̯uleeta kusemererwa, na makuru garungi galeeta b̯womi. ");
INSERT INTO rub_vpl VALUES ("PR15_31","021_15_31","PRO","15","31","31","Muntu eikiriza kulambwa, abalwa mu ba magezi̱. ");
INSERT INTO rub_vpl VALUES ("PR15_32","021_15_32","PRO","15","32","32","Yogwo atalambwa yeefereza binene, bei̱tu̱ alambwa yeyongera kukenga. ");
INSERT INTO rub_vpl VALUES ("PR15_33","021_15_33","PRO","15","33","33","Ku̱ti̱i̱na Mukama kyegesya magezi̱, na kub̯undaara kuleeta ki̱ti̱i̱ni̱sa. ");
INSERT INTO rub_vpl VALUES ("PR16_1","021_16_1","PRO","16","1","1","Muntu ategeka kyakukora, bei̱tu̱ Mukama yooyo acwamwo kukyabba. ");
INSERT INTO rub_vpl VALUES ("PR16_2","021_16_2","PRO","16","2","2","Bantu basobora kuteekereza bibakukora birungi, kyonkei bigyendeerwa byaho bi̱pi̱mwa Mukama. ");
INSERT INTO rub_vpl VALUES ("PR16_3","021_16_3","PRO","16","3","3","B̯uli kyokukora ki̱kwatyenge Mukama, mwomwo byotegeki̱ri̱ bidwereere. ");
INSERT INTO rub_vpl VALUES ("PR16_4","021_16_4","PRO","16","4","4","B̯uli Mukama kyakora abba na nsonga, na mubiibi amu̱tegekeeri̱ kiro kya ku̱zi̱ka. ");
INSERT INTO rub_vpl VALUES ("PR16_5","021_16_5","PRO","16","5","5","Mukama anoba beehaariiza, mu mananu tibalilemwa kufubirwa. ");
INSERT INTO rub_vpl VALUES ("PR16_6","021_16_6","PRO","16","6","6","Yensei̱ akwendya Mukama kandi akamwesiga, amuganyira bibii byamwe, na ku̱ti̱i̱na Mukama kwokwo kutoola muntu mu kibii. ");
INSERT INTO rub_vpl VALUES ("PR16_7","021_16_7","PRO","16","7","7","Akora bi̱ku̱si̱i̱imwa Mukama, na banyanzigwa baamwe bei̱ra nibamunywana. ");
INSERT INTO rub_vpl VALUES ("PR16_8","021_16_8","PRO","16","8","8","Hakiri otunga bi̱dooli̱ mu b̯urungi, kukira binene bya ngu̱zi̱. ");
INSERT INTO rub_vpl VALUES ("PR16_9","021_16_9","PRO","16","9","9","Muntu ategeka ha kugyenda, bei̱tu̱ Mukama yooyo amuhab̯ura muhanda. ");
INSERT INTO rub_vpl VALUES ("PR16_10","021_16_10","PRO","16","10","10","Ruhanga aterekereerya mutima gwa mukama, akusemeera kubbanga wab̯winganiza. ");
INSERT INTO rub_vpl VALUES ("PR16_11","021_16_11","PRO","16","11","11","Mukama yendya ki̱pi̱myo na ndengu zi̱doori̱, byab̯u̱gu̱li̱ byensei̱ biruga hali yo. ");
INSERT INTO rub_vpl VALUES ("PR16_12","021_16_12","PRO","16","12","12","Bakama banoba nkori̱ za bibii, kubba b̯u̱lemi̱ b̯urungi b̯uleetwa b̯winganiza. ");
INSERT INTO rub_vpl VALUES ("PR16_13","021_16_13","PRO","16","13","13","Mukama anyu̱mi̱rwa kwegwa akubaza mananu, asi̱i̱ma abaza bi̱doori̱. ");
INSERT INTO rub_vpl VALUES ("PR16_14","021_16_14","PRO","16","14","14","Hali mukama azi̱ngali̱i̱ri̱ asobora nakwi̱ta bei̱tu̱ mu̱gezi̱, amu̱holya b̯u̱holya. ");
INSERT INTO rub_vpl VALUES ("PR16_15","021_16_15","PRO","16","15","15","Kamwenyu ka mukama kaleeta b̯womi, kandi mbabazi̱ zaamwe zisana ndagali̱ gya kibbaga. ");
INSERT INTO rub_vpl VALUES ("PR16_16","021_16_16","PRO","16","16","16","Kubba na magezi̱ na kwetegereza, kikukira kubba na feeza na zaabbu. ");
INSERT INTO rub_vpl VALUES ("PR16_17","021_16_17","PRO","16","17","17","Murungi yeehala kukora kubiibi, kandi akora niyegyendereza, alinda b̯womi b̯wamwe. ");
INSERT INTO rub_vpl VALUES ("PR16_18","021_16_18","PRO","16","18","18","Kwetembya kuleeta kuhwerekeera, kandi myehaariizo mirugamwo ku̱gwa. ");
INSERT INTO rub_vpl VALUES ("PR16_19","021_16_19","PRO","16","19","19","Hakiri oicala munaku ali na mbabazi̱, kukira kwehemba na mugab̯u gwa b̯u̱nyagi̱. ");
INSERT INTO rub_vpl VALUES ("PR16_20","021_16_20","PRO","16","20","20","Akuta mutima gwamwe ha kwegeseb̯wa ali̱si̱ngu̱ra, naakwesiga Mukama aliheeb̯wa mu̱gi̱sa. ");
INSERT INTO rub_vpl VALUES ("PR16_21","021_16_21","PRO","16","21","21","Ali na magezi̱ bamweta mwetegerezi̱, abaza na mbabazi̱, asikiriza bantu. ");
INSERT INTO rub_vpl VALUES ("PR16_22","021_16_22","PRO","16","22","22","Magezi̱ hali ali na kwetegereza, musu gwa b̯womi, bei̱tu̱ kwegesya mudoma ogadira b̯usa. ");
INSERT INTO rub_vpl VALUES ("PR16_23","021_16_23","PRO","16","23","23","Ali na magezi̱ abaza bya magezi̱, bigambu byamwe bisikiriza bantu ku̱byegwa. ");
INSERT INTO rub_vpl VALUES ("PR16_24","021_16_24","PRO","16","24","24","Bigambu bya mbabazi̱ bi̱nwereerya nka b̯uhooki, bisemeera mwozo kandi bi̱tati̱i̱rya mubiri. ");
INSERT INTO rub_vpl VALUES ("PR16_25","021_16_25","PRO","16","25","25","Haloho muhanda gu̱zooka gurungi mu mei̱so ga muntu, bei̱tu̱ gumaliira nigutwala mu lu̱ku̱u̱. ");
INSERT INTO rub_vpl VALUES ("PR16_26","021_16_26","PRO","16","26","26","Ali na kyakwetaaga akikoleerambe, nzala gyegesya kukora. ");
INSERT INTO rub_vpl VALUES ("PR16_27","021_16_27","PRO","16","27","27","Mubiibi atoolya bayatab̯ura, bigambu byamwe bibba nka mworo. ");
INSERT INTO rub_vpl VALUES ("PR16_28","021_16_28","PRO","16","28","28","Mucwamakuru aleeta izongobo, na muhesa bantu yaahu̱kani̱a banywani. ");
INSERT INTO rub_vpl VALUES ("PR16_29","021_16_29","PRO","16","29","29","Mu̱habi̱ ahabya bei̱ra, naabatwala mu ku̱zi̱ka. ");
INSERT INTO rub_vpl VALUES ("PR16_30","021_16_30","PRO","16","30","30","Ami̱gami̱gi̱ri̱i̱rya mei̱so abba naakutegeka b̯ubii, amyola mu̱nwa abba na kibiibi kyakukora. ");
INSERT INTO rub_vpl VALUES ("PR16_31","021_16_31","PRO","16","31","31","Mbwi̱ zibba nka kondo gya ki̱ti̱i̱ni̱sa, giheeb̯wa bantu bananu. ");
INSERT INTO rub_vpl VALUES ("PR16_32","021_16_32","PRO","16","32","32","Ali na kugumisiriza abba muzira kukira waamaani, afuga mutima gwamwe akira ahamba rub̯uga lwensei̱. ");
INSERT INTO rub_vpl VALUES ("PR16_33","021_16_33","PRO","16","33","33","Bantu basobora ku̱cu̱hya nsoro kuwona kyarugamwo, bei̱tu̱ Mukama yooyo acwamwo. ");
INSERT INTO rub_vpl VALUES ("PR17_1","021_17_1","PRO","17","1","1","Kudya ki̱dooli̱ okabba na b̯u̱si̱nge, kikukira nnyu̱mba gilimwo kwegonza neizongobo. ");
INSERT INTO rub_vpl VALUES ("PR17_2","021_17_2","PRO","17","2","2","Mwiru mwekambi̱, alema mwana mugwagwa, kandi agweterwa bintu nkomwei̱ hali baana ba mu nnyu̱mba. ");
INSERT INTO rub_vpl VALUES ("PR17_3","021_17_3","PRO","17","3","3","Feeza na zaabbu bi̱pi̱mwa mworo, bei̱tu̱ Mukama api̱ma biteekerezu bya mitima. ");
INSERT INTO rub_vpl VALUES ("PR17_4","021_17_4","PRO","17","4","4","Nkori̱ gya bibii gyetegeerya rugambu lwa babiibi, mu̱gobya ahondera b̯u̱gobya. ");
INSERT INTO rub_vpl VALUES ("PR17_5","021_17_5","PRO","17","5","5","Adu̱u̱li̱ra munaku abba naakugaya munyakumuhanga, anyu̱mi̱rwa b̯ujune b̯wa wondi takena kufubirwa. ");
INSERT INTO rub_vpl VALUES ("PR17_6","021_17_6","PRO","17","6","6","Bagu̱lu̱u̱su̱ benyumiriza mu beizukulu baab̯u na baana nibenyumiriza mu babyeru̱ baab̯u. ");
INSERT INTO rub_vpl VALUES ("PR17_7","021_17_7","PRO","17","7","7","Kubaza bya magezi̱ tikigasira mudoma, naakubaza b̯u̱gobya ti̱ki̱semereeri̱ mu̱lemi̱. ");
INSERT INTO rub_vpl VALUES ("PR17_8","021_17_8","PRO","17","8","8","Bantu bateekerereza mu̱kwegu̱li̱ri̱i̱rya bawona byensei̱ nibikusoboka, bagu̱mya nti, kwegu̱li̱ri̱i̱rya kukora nka lu̱gi̱sa. ");
INSERT INTO rub_vpl VALUES ("PR17_9","021_17_9","PRO","17","9","9","Atoolya kunywana aganyira bamu̱sobereerye, bei̱tu̱ eicala naabaza nsobi̱ ei̱ta mukagu. ");
INSERT INTO rub_vpl VALUES ("PR17_10","021_17_10","PRO","17","10","10","Mu̱gezi̱ baamulamba lu̱mwei̱ naakenga, bei̱tu̱ mudoma naab̯ubakuuta njunju ki̱ku̱mi̱ tahab̯uka. ");
INSERT INTO rub_vpl VALUES ("PR17_11","021_17_11","PRO","17","11","11","Muntu mubiibi eicala natekereza b̯wemi̱ b̯usa, akwatwa batumwa batali na mbabazi̱ nayo. ");
INSERT INTO rub_vpl VALUES ("PR17_12","021_17_12","PRO","17","12","12","Hakiri orombya ntali gi̱basengereeri̱ b̯wana b̯wagyo, kukira ku̱rombya mudoma akukora byab̯udoma. ");
INSERT INTO rub_vpl VALUES ("PR17_13","021_17_13","PRO","17","13","13","B̯wokora kubiibi muntu akukukoora birungi, bizib̯u tibilimalika mwamu. ");
INSERT INTO rub_vpl VALUES ("PR17_14","021_17_14","PRO","17","14","14","Kutara b̯ulemu kiisana kwijuura mu̱hwi̱ gwa meezi̱, kale nu b̯wehale izongobo li̱takatandi̱ki̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PR17_15","021_17_15","PRO","17","15","15","Kufubira atali na musangu nookaganyira mubiibi, byensei̱ bya muziro hali Mukama. ");
INSERT INTO rub_vpl VALUES ("PR17_16","021_17_16","PRO","17","16","16","Sente za mudoma asasula kusoma tizili na kizimugasira, hab̯wa b̯utetegereza b̯wamwe. ");
INSERT INTO rub_vpl VALUES ("PR17_17","021_17_17","PRO","17","17","17","Mukagu gubba mukagu b̯wi̱re b̯wensei̱, kandi baluganda beelinda b̯wi̱re b̯wa b̯ujune. ");
INSERT INTO rub_vpl VALUES ("PR17_18","021_17_18","PRO","17","18","18","B̯udoma b̯ukutuma kusasula ibanza lya wondi, na kuhayo b̯wema hab̯wa mu̱taahi̱. ");
INSERT INTO rub_vpl VALUES ("PR17_19","021_17_19","PRO","17","19","19","Akwendya b̯ubii atoolya wakuzongoba nayo, atoolya myehembu yeeletera b̯ujune. ");
INSERT INTO rub_vpl VALUES ("PR17_20","021_17_20","PRO","17","20","20","Ateekereza mu kukora kubiibi tatunga mu̱gi̱sa, kalimi kabaza b̯u̱gobya keicala mu b̯ujune. ");
INSERT INTO rub_vpl VALUES ("PR17_21","021_17_21","PRO","17","21","21","Mwana mudoma akwati̱sya babyeru̱ b̯ujune, kandi tibalibba na kusemererwa kwensei̱. ");
INSERT INTO rub_vpl VALUES ("PR17_22","021_17_22","PRO","17","22","22","Kwicala osemereerwe guli mu̱bazi̱ gu̱ku̱honi̱a, bei̱tu̱ kandi kuzingala kwanu̱kya wanu̱kya. ");
INSERT INTO rub_vpl VALUES ("PR17_23","021_17_23","PRO","17","23","23","Mu̱ramu̱ri̱ mubiibi eikiriza ngu̱zi̱ mu kyebi̱si̱i̱re, aleke atasala musangu mu b̯winganiza. ");
INSERT INTO rub_vpl VALUES ("PR17_24","021_17_24","PRO","17","24","24","Mu̱gezi̱ ategeka bya magezi̱, bei̱tu̱ mudoma akwata kiki na ki̱di̱. ");
INSERT INTO rub_vpl VALUES ("PR17_25","021_17_25","PRO","17","25","25","Mwana mudoma asaliiza bbaawe, kandi ali̱rya mmaawe. ");
INSERT INTO rub_vpl VALUES ("PR17_26","021_17_26","PRO","17","26","26","Ti̱ki̱doori̱ ku̱li̱hi̱sya atali na musangu, na kukuuta bakora birungi. ");
INSERT INTO rub_vpl VALUES ("PR17_27","021_17_27","PRO","17","27","27","Mu̱gezi̱ abaza bi̱dooli̱, naakwetegereza akwata mpula. ");
INSERT INTO rub_vpl VALUES ("PR17_28","021_17_28","PRO","17","28","28","Mudoma b̯u̱yetekeera bamweta mu̱gezi̱, b̯wabbumba mu̱nwa azooka nka ali na kwetegereza. ");
INSERT INTO rub_vpl VALUES ("PR18_1","021_18_1","PRO","18","1","1","Yeehala bei̱ra abba nakwetooleerya byamwe yankei, abba naakusuula bintu bi̱doori̱. ");
INSERT INTO rub_vpl VALUES ("PR18_2","021_18_2","PRO","18","2","2","Mudoma ti̱yendya kwetegereza bei̱tu̱ anyu̱mi̱rwa kuhanuulira bandi. ");
INSERT INTO rub_vpl VALUES ("PR18_3","021_18_3","PRO","18","3","3","Akora bibiibi yeeleetera mugayo, muswaru guleeta kihemu. ");
INSERT INTO rub_vpl VALUES ("PR18_4","021_18_4","PRO","18","4","4","Bigambu birungi mu muntu meezi̱ ga mu ndi̱ha, musu gwa magezi̱ gukulukuta nka mugira. ");
INSERT INTO rub_vpl VALUES ("PR18_5","021_18_5","PRO","18","5","5","Ti̱ki̱doori̱ kuganyira mubiibi, rundi kufubira atali na musangu. ");
INSERT INTO rub_vpl VALUES ("PR18_6","021_18_6","PRO","18","6","6","Bigambu bya mudoma bileeta mpaka, naakuhonyola mu̱nwa kumuleetera kukuutwa. ");
INSERT INTO rub_vpl VALUES ("PR18_7","021_18_7","PRO","18","7","7","Mu̱nwa gwa mudoma gwogwo gu̱mu̱zi̱kya bigambu byabaza bimubboha nka mutegu. ");
INSERT INTO rub_vpl VALUES ("PR18_8","021_18_8","PRO","18","8","8","Makuru gacwe ganolira akugegwa nka bidyo bi̱nolu̱ kubiicala mu nda. ");
INSERT INTO rub_vpl VALUES ("PR18_9","021_18_9","PRO","18","9","9","Mukora mulimo na b̯ugarei, na mu̱gu̱heneri̱ tibahukana. ");
INSERT INTO rub_vpl VALUES ("PR18_10","021_18_10","PRO","18","10","10","Mukama eicala lugo lunyamaani, hali barungi baamwe bei̱ru̱ki̱ra kutunga b̯u̱si̱nge. ");
INSERT INTO rub_vpl VALUES ("PR18_11","021_18_11","PRO","18","11","11","Itungu lya mu̱gu̱u̱da lili nka rub̯uga lwamwe lunyamaani, lili nka ki̱si̱i̱ka kilei kyelogoleerye rub̯uga. ");
INSERT INTO rub_vpl VALUES ("PR18_12","021_18_12","PRO","18","12","12","Kwehaariiza kuleeta ku̱zi̱ka, ab̯undaara atunga ki̱ti̱i̱ni̱sa. ");
INSERT INTO rub_vpl VALUES ("PR18_13","021_18_13","PRO","18","13","13","Kwi̱ramu bigambu byotakabbeeri̱ kwetegeerya, kibba kya b̯udoma kandi kyamuswaru. ");
INSERT INTO rub_vpl VALUES ("PR18_14","021_18_14","PRO","18","14","14","Mutima gutatiro gwi̱ryamwo baseeri̱ maani, bei̱tu̱ hali gutali na ku̱ni̱hi̱ra kubba kwahi. ");
INSERT INTO rub_vpl VALUES ("PR18_15","021_18_15","PRO","18","15","15","Bagezi̱ beicala beetegeki̱ri̱ kwega, Mapokopo gaab̯u geicala gab̯uule mwa kutangiira magezi̱. ");
INSERT INTO rub_vpl VALUES ("PR18_16","021_18_16","PRO","18","16","16","Kisembu kya muntu kimuteerahoona muhanda hali bakama, kandi nikimwicaarya na bafura. ");
INSERT INTO rub_vpl VALUES ("PR18_17","021_18_17","PRO","18","17","17","Abanza kubaza mu mei̱so ga mu̱ramu̱ri̱ azooka nka wa mananu, ku̱doosya munyegeerwa waaketongonaho. ");
INSERT INTO rub_vpl VALUES ("PR18_18","021_18_18","PRO","18","18","18","Karu̱ru̱ kamala mpaka, kandi kuramura ntaru za maani. ");
INSERT INTO rub_vpl VALUES ("PR18_19","021_18_19","PRO","18","19","19","Weenyu̱ gyozi̱ngali̱i̱rye talikwikiriza kwingira mwamwe, mpaka zi̱tab̯wi̱ri̱ banywani zaahu̱kani̱a bantu nka irembu li̱ki̱ngi̱i̱rwe byoma. ");
INSERT INTO rub_vpl VALUES ("PR18_20","021_18_20","PRO","18","20","20","Bigambu bya muntu biicuutya nda gyamwe, mu mu̱nwa gwamwe harugamu bikumugasira ");
INSERT INTO rub_vpl VALUES ("PR18_21","021_18_21","PRO","18","21","21","Maani ga lu̱ku̱u̱ na b̯womi gali mu lulimi, nahab̯waki̱kyo b̯uli muntu yegyendereze bigambu byakubaza. ");
INSERT INTO rub_vpl VALUES ("PR18_22","021_18_22","PRO","18","22","22","Yaagya mu̱kali̱ wa kuswera abba yaagi̱i̱rye kintu kirungi, kubba abba na mu̱gi̱sa gwa Mukama. ");
INSERT INTO rub_vpl VALUES ("PR18_23","021_18_23","PRO","18","23","23","Bigambu bya munaku byolokya mbabazi̱, bei̱tu̱ mu̱gu̱u̱da abaza na nkabbu. ");
INSERT INTO rub_vpl VALUES ("PR18_24","021_18_24","PRO","18","24","24","Haloho mukagu gwa kasu̱mi̱ b̯u̱su̱mi̱, bei̱tu̱ aku̱nyweni̱ biribiri akukiira na mwijuwo. ");
INSERT INTO rub_vpl VALUES ("PR19_1","021_19_1","PRO","19","1","1","Munaku agyendera ha mananu, akira mu̱gobya mudoma. ");
INSERT INTO rub_vpl VALUES ("PR19_2","021_19_2","PRO","19","2","2","Kili kibiibi kubba na bihika bitalimwo kwetegereza, naakora naapapa tamaliira. ");
INSERT INTO rub_vpl VALUES ("PR19_3","021_19_3","PRO","19","3","3","Muntu b̯wafafaanika hab̯wa b̯udoma b̯wamwe, atandika kwekwati̱ri̱i̱rya na Mukama. ");
INSERT INTO rub_vpl VALUES ("PR19_4","021_19_4","PRO","19","4","4","Mu̱gu̱u̱da atunga mikagu minene, bei̱tu̱ mya munaku mimalika b̯u̱mali̱ki̱. ");
INSERT INTO rub_vpl VALUES ("PR19_5","021_19_5","PRO","19","5","5","Agaba b̯u̱kei̱so wa b̯u̱gobya afubirwa b̯ufubirwa, abaza b̯u̱gobya talikena. ");
INSERT INTO rub_vpl VALUES ("PR19_6","021_19_6","PRO","19","6","6","Banene batoolya kunywana benda, b̯uli muntu yendya yogwo agaba. ");
INSERT INTO rub_vpl VALUES ("PR19_7","021_19_7","PRO","19","7","7","Munaku onnob̯wa baamwe, Babbe banywanwe, nab̯wabeerya heehi̱, badahira b̯u̱dahi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PR19_8","021_19_8","PRO","19","8","8","Ali na magezi̱ abba atu̱ngi̱ri̱ kwegonza, Ali na kwetegereza agumbura birungi. ");
INSERT INTO rub_vpl VALUES ("PR19_9","021_19_9","PRO","19","9","9","Agaba b̯u̱kei̱so wa b̯u̱gobya afubirwa b̯ufubirwa, abaza b̯u̱gobya ali̱zi̱ka. ");
INSERT INTO rub_vpl VALUES ("PR19_10","021_19_10","PRO","19","10","10","Badoma tibakusemeera kwicala mu kwegonza, na beiru tibakusemeera kufuga bantu ba maani. ");
INSERT INTO rub_vpl VALUES ("PR19_11","021_19_11","PRO","19","11","11","Ali na kwetegereza yeegyendereza kukwatwa ki̱ni̱ga, mu kunuga bibiibi, atungiramwo ki̱ti̱i̱ni̱sa. ");
INSERT INTO rub_vpl VALUES ("PR19_12","021_19_12","PRO","19","12","12","Mukama b̯wakwatwa ki̱ni̱ga ahuruguma nka ntali, mbabazi̱ zaamwe zisana lu̱me lu̱gwereeri̱ heisubi. ");
INSERT INTO rub_vpl VALUES ("PR19_13","021_19_13","PRO","19","13","13","Mwana mudoma aleetera bbaawe nnaku, mu̱kali̱ weizongobo eisana nka b̯utuntu ku mabbaati. ");
INSERT INTO rub_vpl VALUES ("PR19_14","021_19_14","PRO","19","14","14","Nnyu̱mba neitungu babigwetera b̯u̱gweteri̱, bei̱tu̱ mu̱kali̱ mwetegerezi̱ kisembu kuruga hali Mukama. ");
INSERT INTO rub_vpl VALUES ("PR19_15","021_19_15","PRO","19","15","15","Muntu mugarei yeebbaka herere, eicala atakukora aliicala mu nzala. ");
INSERT INTO rub_vpl VALUES ("PR19_16","021_19_16","PRO","19","16","16","Akwata biragiro bya Ruhanga alinda b̯womi b̯wamwe, bei̱tu̱ agaya mihanda myamwe ali̱kwa. ");
INSERT INTO rub_vpl VALUES ("PR19_17","021_19_17","PRO","19","17","17","Agabira banaku eisana ahoori̱ Mukama, Mukama alimusasula birungi. ");
INSERT INTO rub_vpl VALUES ("PR19_18","021_19_18","PRO","19","18","18","Hab̯ura mwana nihacaaloho ku̱ni̱hi̱ra, kitali ki̱kyo okubba noku̱mu̱zi̱kya. ");
INSERT INTO rub_vpl VALUES ("PR19_19","021_19_19","PRO","19","19","19","Waaki̱ni̱ga kinene yei̱li̱hi̱ra kifubiro kyamwe, b̯womujuna gukubanza b̯undi de olimujuna. ");
INSERT INTO rub_vpl VALUES ("PR19_20","021_19_20","PRO","19","20","20","Weegwanga bibakukulamba, oikirizenge kuhab̯urwa, kwokwo olitunga magezi̱. ");
INSERT INTO rub_vpl VALUES ("PR19_21","021_19_21","PRO","19","21","21","Muntu nab̯wategeka binene byakukora, bei̱tu̱ kwendya kwa Mukama kwokwo kudwereera. ");
INSERT INTO rub_vpl VALUES ("PR19_22","021_19_22","PRO","19","22","22","Bantu bendya ali na ngonzi na b̯wesige, hakiri obba munaku otabbeeri̱ mu̱gobya. ");
INSERT INTO rub_vpl VALUES ("PR19_23","021_19_23","PRO","19","23","23","Kutamwo Mukama ki̱ti̱i̱ni̱sa kuleeta kwomeera, akimuha tadweb̯waho kabii kensei̱. ");
INSERT INTO rub_vpl VALUES ("PR19_24","021_19_24","PRO","19","24","24","Mugarei waakolya itongi mu nnyeni̱, alemwa galita mu mu̱nwa. ");
INSERT INTO rub_vpl VALUES ("PR19_25","021_19_25","PRO","19","25","25","Fubira mu̱gayi̱, na ntwarwa gitunge kyakwega, b̯wohab̯ura mu̱gezi̱ ateeryaho ha kwetegereza kwamwe. ");
INSERT INTO rub_vpl VALUES ("PR19_26","021_19_26","PRO","19","26","26","Mwana awonesya bbaawe, kandi akabinga mmaawe aleeta kijumu na muswaru. ");
INSERT INTO rub_vpl VALUES ("PR19_27","021_19_27","PRO","19","27","27","Mwana wange, b̯wosuula kulambwa, ogumirisana na biwaali wegi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PR19_28","021_19_28","PRO","19","28","28","Mu̱kei̱so mu̱gobya anoba b̯winganiza, mu̱nwa gubiibi gu̱hu̱lu̱kya bibiibi. ");
INSERT INTO rub_vpl VALUES ("PR19_29","021_19_29","PRO","19","29","29","Mu̱gayi̱ bamu̱fu̱bi̱rab̯u̱fu̱bi̱ri̱, akora bya b̯udoma akuutwab̯ukuutwa. ");
INSERT INTO rub_vpl VALUES ("PR20_1","021_20_1","PRO","20","1","1","Maaci gatogolokira baganywi̱, bagatamiira bafooka badoma. ");
INSERT INTO rub_vpl VALUES ("PR20_2","021_20_2","PRO","20","2","2","Mukama waakwatwa ki̱ni̱ga ahuruguma nka ntali, amuzingaalya yeeleetera lu̱ku̱u̱. ");
INSERT INTO rub_vpl VALUES ("PR20_3","021_20_3","PRO","20","3","3","Kwehala kukuuta mpaka kya ki̱ti̱i̱ni̱sa, yendya kuzongoba abba mudoma. ");
INSERT INTO rub_vpl VALUES ("PR20_4","021_20_4","PRO","20","4","4","Mugarei mu kibbaga, atoolya kya kukesa mu kyanda atakukiwonaho. ");
INSERT INTO rub_vpl VALUES ("PR20_5","021_20_5","PRO","20","5","5","Mutima gwa muntu gwisana ndi̱ha, mwetegerezi̱ agutoolamwo biteekerezu. ");
INSERT INTO rub_vpl VALUES ("PR20_6","021_20_6","PRO","20","6","6","Banene bazooka nka ba mbabazi̱, ti̱kyangu̱hi̱ri̱ kwagya mwesigwa. ");
INSERT INTO rub_vpl VALUES ("PR20_7","021_20_7","PRO","20","7","7","Murungi agyendera mu b̯winganiza, mu̱gi̱sa gwamwe guhondera baana baamwe. ");
INSERT INTO rub_vpl VALUES ("PR20_8","021_20_8","PRO","20","8","8","Mukama weicaara kusala misangu, ali̱ngani̱a kirungi na kibiibi. ");
INSERT INTO rub_vpl VALUES ("PR20_9","021_20_9","PRO","20","9","9","Naani akusobora kukoba nti, “Mutima gwange gu̱syanu̱, tindi na kibii kindi kyensei̱”? ");
INSERT INTO rub_vpl VALUES ("PR20_10","021_20_10","PRO","20","10","10","Mukama, anoba bakoresya ndengu na bi̱pi̱myo bya b̯u̱gobya. ");
INSERT INTO rub_vpl VALUES ("PR20_11","021_20_11","PRO","20","11","11","Bikorwa bya muto, byolokya kyani kyali, okusobora kwetegereza yaabba nali murungi rundi mubiibi. ");
INSERT INTO rub_vpl VALUES ("PR20_12","021_20_12","PRO","20","12","12","Mapokopo geegwa na mei̱so gawona, byensei̱ Mukama yooyo yaabi̱hangi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PR20_13","021_20_13","PRO","20","13","13","Alaala atakumala eicala mu nnaku, abyoka naakora abba na bidyo binene. ");
INSERT INTO rub_vpl VALUES ("PR20_14","021_20_14","PRO","20","14","14","Mu̱gu̱li̱ aramura naakoba, “Oku̱syera, oku̱syera,” b̯wamala kugula agyenda niyeehariiza kwakomi̱ri̱ b̯u̱komi̱. ");
INSERT INTO rub_vpl VALUES ("PR20_15","021_20_15","PRO","20","15","15","Kyamugasu hoi̱ kubba na kwetegereza, kukira kubba na zaabbu na mahi̱ga ga muhendu. ");
INSERT INTO rub_vpl VALUES ("PR20_16","021_20_16","PRO","20","16","16","B̯wema b̯wa ategebeerwe, b̯uli na kusembwa musimbo, asagika munyamahanga alinakumusasulira. ");
INSERT INTO rub_vpl VALUES ("PR20_17","021_20_17","PRO","20","17","17","Mudya byab̯u̱gobya bimunolira hoi̱, hei̱nyu̱ma bimufokira nka musinyi mu mu̱nwa. ");
INSERT INTO rub_vpl VALUES ("PR20_18","021_20_18","PRO","20","18","18","Kyotoleerya magezi̱ mwa ku̱si̱ngu̱ra, lwani̱sya otunge akukulamba. ");
INSERT INTO rub_vpl VALUES ("PR20_19","021_20_19","PRO","20","19","19","Mucwa makuru talinda nsita, weehalenge wa ndimi ibiri. ");
INSERT INTO rub_vpl VALUES ("PR20_20","021_20_20","PRO","20","20","20","Mu̱lu̱ma bbaawe rundi maawe, ali̱kwa nka taara gi̱lu̱mi̱ra mu nti̱ti̱. ");
INSERT INTO rub_vpl VALUES ("PR20_21","021_20_21","PRO","20","21","21","Itungu li̱i̱za b̯wangu, hei̱nyu̱ma tilibba na mugasu. ");
INSERT INTO rub_vpl VALUES ("PR20_22","021_20_22","PRO","20","22","22","Leka kukoba, “Nkwi̱za kumusasula kibii nkyankoori̱!” Bi̱kwatye Mukama, akwi̱za kukucungura. ");
INSERT INTO rub_vpl VALUES ("PR20_23","021_20_23","PRO","20","23","23","Mukama annoba bi̱pi̱myo bya b̯u̱gobya, ndengu zibiibi tazendya. ");
INSERT INTO rub_vpl VALUES ("PR20_24","021_20_24","PRO","20","24","24","Mukama yooyo ategeka malibatire ga muntu, muntu ki akusobora kwetegereza muhanda gwa b̯womi b̯wamwe? ");
INSERT INTO rub_vpl VALUES ("PR20_25","021_20_25","PRO","20","25","25","Otalikwatwa mutegu gwa ku̱rangu̱hi̱ri̱i̱rya kweraga hali Mukama, hei̱nyu̱ma okezu̱zu̱kya! ");
INSERT INTO rub_vpl VALUES ("PR20_26","021_20_26","PRO","20","26","26","Mukama ali na magezi̱ ali̱ngani̱a muntu mubiibi, naamufubira atakumuganyira. ");
INSERT INTO rub_vpl VALUES ("PR20_27","021_20_27","PRO","20","27","27","Mwozo gwa muntu gwisana taara gya Mukama, gimuluka nsita za mu mutima. ");
INSERT INTO rub_vpl VALUES ("PR20_28","021_20_28","PRO","20","28","28","Ngonzi na b̯wesigwa bilinda mukama, b̯u̱lemi̱ b̯wamwe b̯wemeera ku b̯urungi b̯wamwe. ");
INSERT INTO rub_vpl VALUES ("PR20_29","021_20_29","PRO","20","29","29","Maani ga basigazi googo ki̱ti̱i̱ni̱sa kyab̯u, b̯urungi b̯wa bagu̱lu̱u̱su̱ b̯wicala mu mbwi̱ zaab̯u. ");
INSERT INTO rub_vpl VALUES ("PR20_30","021_20_30","PRO","20","30","30","Bihuta bya njunju bigorora ngesu zibiibi, kukuutwa kujanjaba mutima. ");
INSERT INTO rub_vpl VALUES ("PR21_1","021_21_1","PRO","21","1","1","Mukama afuga mu̱lemi̱ nka meezi̱ ga mugira, aguragira guheete haakendeerye. ");
INSERT INTO rub_vpl VALUES ("PR21_2","021_21_2","PRO","21","2","2","Kyensei̱ kya muntu akora akyeta kirungi, bei̱tu̱ Mukama api̱ma mutima. ");
INSERT INTO rub_vpl VALUES ("PR21_3","021_21_3","PRO","21","3","3","Mukama yendya akora birungi na byab̯winganiza, kukira kumuhongera. ");
INSERT INTO rub_vpl VALUES ("PR21_4","021_21_4","PRO","21","4","4","Bantu babiibi bafugwa myehembo na myepanku, byensei̱ bibyala kibii. ");
INSERT INTO rub_vpl VALUES ("PR21_5","021_21_5","PRO","21","5","5","Kutegeka na kwekamba kurugamwo byamugasu, bei̱tu̱ yangu̱hi̱ri̱i̱rya kukora afooka munaku. ");
INSERT INTO rub_vpl VALUES ("PR21_6","021_21_6","PRO","21","6","6","Itungu lya b̯u̱gobya li̱tu̱u̱ka nka mwi̱ca, litwala bantu mu ku̱zi̱ka. ");
INSERT INTO rub_vpl VALUES ("PR21_7","021_21_7","PRO","21","7","7","Mubiibi ei̱twa bikorwa byamwe, hab̯wakubba azira kukora birungi. ");
INSERT INTO rub_vpl VALUES ("PR21_8","021_21_8","PRO","21","8","8","Ngesu za babiibi tiziterekeera, bei̱tu̱ barungi bagyendera hasyanu̱. ");
INSERT INTO rub_vpl VALUES ("PR21_9","021_21_9","PRO","21","9","9","Hakiri oicala mu ki̱si̱i̱si̱ra, kukira kwicala mu nnyu̱mba gi̱mwei̱ na mu̱kali̱ weizongobo. ");
INSERT INTO rub_vpl VALUES ("PR21_10","021_21_10","PRO","21","10","10","Babiibi beicala ni̱banyu̱mi̱rwa kukora bibiibi, tibali na gibakwatirwa kisa. ");
INSERT INTO rub_vpl VALUES ("PR21_11","021_21_11","PRO","21","11","11","Mu̱gayi̱ wafubirwa ntwarwa nigimwegiraho, Mu̱gezi̱ b̯wahab̯urwa niyetegereza. ");
INSERT INTO rub_vpl VALUES ("PR21_12","021_21_12","PRO","21","12","12","Ruhanga eicala murungi yeegi̱ri̱ bya mu maka ga gabiibi, kandi alibafubira. ");
INSERT INTO rub_vpl VALUES ("PR21_13","021_21_13","PRO","21","13","13","Muntu yensei̱ asuula kwegwa kutaaga kwa munaku, nayodede alitaaga atali naaku̱mwi̱ramwo. ");
INSERT INTO rub_vpl VALUES ("PR21_14","021_21_14","PRO","21","14","14","Muntu wakuzingalira, weegu̱lab̯wegu̱li̱ ki̱cei̱cei̱ ku̱mu̱holaholya. ");
INSERT INTO rub_vpl VALUES ("PR21_15","021_21_15","PRO","21","15","15","Bantu barungi basemereerwa bintu b̯ubikorwa mu b̯winganiza, bei̱tu̱ babiibi babaleetera b̯u̱ti̱i̱ni̱. ");
INSERT INTO rub_vpl VALUES ("PR21_16","021_21_16","PRO","21","16","16","Akweti̱ gutalimwo ka b̯untu, alyezagya nali mu kitebe kya baku̱u̱. ");
INSERT INTO rub_vpl VALUES ("PR21_17","021_21_17","PRO","21","17","17","Eicala mu kwegonza alinakuhara, anolerwa maaci na bi̱syeke tali̱gu̱dahara. ");
INSERT INTO rub_vpl VALUES ("PR21_18","021_21_18","PRO","21","18","18","Babiibi bagweb̯waho b̯ujune b̯ubabba ni̱bakwendeerya barungi. ");
INSERT INTO rub_vpl VALUES ("PR21_19","021_21_19","PRO","21","19","19","Hakiri oicala mwihamba, kukira kubba na mu̱kali̱ weizongobo kandi wa ki̱ni̱ga. ");
INSERT INTO rub_vpl VALUES ("PR21_20","021_21_20","PRO","21","20","20","Muntu wa magezi̱ abba neitungu na bintu bya muhendu, bei̱tu̱ badoma nsimbi zaab̯u bazimala nibacakazitunga b̯u̱tu̱ngi̱. ");
INSERT INTO rub_vpl VALUES ("PR21_21","021_21_21","PRO","21","21","21","Yogwo afaaho kukora birungi na bya mbabazi̱, alitunga b̯womi b̯urungi, hamwei̱ na ki̱ti̱i̱ni̱sa. ");
INSERT INTO rub_vpl VALUES ("PR21_22","021_21_22","PRO","21","22","22","Muntu wa magezi̱ asi̱ngu̱ra rub̯uga lwa ba maani, naabinya kigo kyalwo kibesiganga. ");
INSERT INTO rub_vpl VALUES ("PR21_23","021_21_23","PRO","21","23","23","Muntu yeegyendereza mu bigambu byabaza, yeejuna yenkei kuruga mu kabii. ");
INSERT INTO rub_vpl VALUES ("PR21_24","021_21_24","PRO","21","24","24","Mu̱gayi̱ lyolyo ibara lya muntu yeetembatembya, kandi wa myebbuno yooyo akukora bintu na myepanku. ");
INSERT INTO rub_vpl VALUES ("PR21_25","021_21_25","PRO","21","25","25","Mugarei ei̱twa kwegomba kwamwe, hab̯wakubba ti̱yendya kukora. ");
INSERT INTO rub_vpl VALUES ("PR21_26","021_21_26","PRO","21","26","26","Muntu mubiibi abba na mururu gwakutunga bintu binene b̯uli kiro, bei̱tu̱ muntu murungi eicala nagaba. ");
INSERT INTO rub_vpl VALUES ("PR21_27","021_21_27","PRO","21","27","27","Mukama ti̱yendya kihongwa kya muntu mubiibi, kukira maani b̯ukileetwa na kigyendeerwa kitali kirungi. ");
INSERT INTO rub_vpl VALUES ("PR21_28","021_21_28","PRO","21","28","28","Kei̱so wa b̯u̱gobya ali̱zi̱ka, bei̱tu̱ wa mazima, balyetegeerya bigambu byakubaza. ");
INSERT INTO rub_vpl VALUES ("PR21_29","021_21_29","PRO","21","29","29","Muntu mubiibi yeetwala kubba murungi, bei̱tu̱ kandi murungi yeegyendereza mihanda myamwe. ");
INSERT INTO rub_vpl VALUES ("PR21_30","021_21_30","PRO","21","30","30","Tihaloho magezi̱, kwetegereza, rundi kyakulamba kya muntu, kukusobora ku̱si̱ngu̱ra Mukama. ");
INSERT INTO rub_vpl VALUES ("PR21_31","021_21_31","PRO","21","31","31","Muntu naasobora kutekaniza mbaraasi zaaku̱lwani̱sya b̯ulemu, bei̱tu̱ b̯u̱si̱ngu̱zi̱ b̯uruga hali Mukama. ");
INSERT INTO rub_vpl VALUES ("PR22_1","021_22_1","PRO","22","1","1","Ibara lirungi balyendya kukira itungu, ki̱ti̱i̱ni̱sa kikira kubba na feeza rundi zaabbu ");
INSERT INTO rub_vpl VALUES ("PR22_2","021_22_2","PRO","22","2","2","Mu̱gu̱u̱da na munaku bali na habarombi̱ra, bensei̱ Mukama yooyo yaabahangi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PR22_3","021_22_3","PRO","22","3","3","Akwetegereza awona kabii ni̱kakwi̱za niyebbala, bei̱tu̱ ntwarwa gyecoberab̯wecoberi̱ nigiwonawona nakyo. ");
INSERT INTO rub_vpl VALUES ("PR22_4","021_22_4","PRO","22","4","4","Mu kub̯undaara, na ku̱ti̱i̱na Mukama heicalamwo mpeera gya b̯u̱gu̱u̱da, ki̱ti̱i̱ni̱sa, na kwomeera. ");
INSERT INTO rub_vpl VALUES ("PR22_5","021_22_5","PRO","22","5","5","Muhanda gwa babiibi gwicalamwo mahwa na mitegu, mweri̱ndenge mumyehale. ");
INSERT INTO rub_vpl VALUES ("PR22_6","021_22_6","PRO","22","6","6","Weegesya mwana ngesu zaakusemeera kwicala nazo, nab̯walibba ahandi̱ri̱ atalizeebeera. ");
INSERT INTO rub_vpl VALUES ("PR22_7","021_22_7","PRO","22","7","7","Ali neitungu afuga munaku, mwehori̱ akoora mu̱mu̱hori̱. ");
INSERT INTO rub_vpl VALUES ("PR22_8","021_22_8","PRO","22","8","8","Asiga gitalimwo b̯winganiza, akesa mi̱hi̱to, na b̯ubiibi b̯wamwe b̯ulimumalika. ");
INSERT INTO rub_vpl VALUES ("PR22_9","021_22_9","PRO","22","9","9","Kya mu̱gi̱sa kubba mwenda, hab̯wakubba mwenda abagana bidyo byamwe na banaku. ");
INSERT INTO rub_vpl VALUES ("PR22_10","021_22_10","PRO","22","10","10","Abinga wa migayo abba abi̱ngi̱ri̱ ntaru, izongobo na bi̱lu̱mo bi̱kwi̱za kumalika. ");
INSERT INTO rub_vpl VALUES ("PR22_11","021_22_11","PRO","22","11","11","Yendya mutima gu̱syanu̱, naakubaza na mbabazi̱, yooyo mukama gyanywana. ");
INSERT INTO rub_vpl VALUES ("PR22_12","021_22_12","PRO","22","12","12","Li̱i̱so lya Mukama li̱tolereerya mananu, kyokyo anuga b̯u̱nu̱gi̱ bigambu bya bagobya. ");
INSERT INTO rub_vpl VALUES ("PR22_13","021_22_13","PRO","22","13","13","Mugarei akuweera, “Ntali gili hanzei, gi̱i̱za ku̱nzi̱ti̱ra mu ngu̱u̱do.” ");
INSERT INTO rub_vpl VALUES ("PR22_14","021_22_14","PRO","22","14","14","Kanwa ka mu̱kali̱ mwenzi̱ b̯u̱hya, akyeneerwe Mukama, ali̱b̯u̱gwamwo. ");
INSERT INTO rub_vpl VALUES ("PR22_15","021_22_15","PRO","22","15","15","Kyab̯uhangwa mwana muto kukora byab̯udoma, bei̱tu̱ kakubba afubirwa atungamwo kakwetegereza. ");
INSERT INTO rub_vpl VALUES ("PR22_16","021_22_16","PRO","22","16","16","Awonawonesya banaku mwa kugudahara, na agabira bagu̱u̱da bintu, bensei̱ balinakuhara. ");
INSERT INTO rub_vpl VALUES ("PR22_17","021_22_17","PRO","22","17","17","B̯wegwanga bigambu bya magezi̱, otenge mutima ha bi̱nyeegesya, ");
INSERT INTO rub_vpl VALUES ("PR22_18","021_22_18","PRO","22","18","18","hab̯wakubba kirungi b̯woli̱bi̱zu̱u̱ka, okabyatulanga na kanwa kaamu. ");
INSERT INTO rub_vpl VALUES ("PR22_19","021_22_19","PRO","22","19","19","Nkwendya wesige Mukama, kyokyo mbi̱ku̱wereeri̱ kiro kiki, ");
INSERT INTO rub_vpl VALUES ("PR22_20","021_22_20","PRO","22","20","20","Nku̱handi̱ki̱i̱ri̱ bigambu birungi maku̱mi̱ gasatu, bikuhab̯ure kandi bikuhe kwetegereza. ");
INSERT INTO rub_vpl VALUES ("PR22_21","021_22_21","PRO","22","21","21","Bi̱kwegesye mananu na b̯wesigwa, mwomwo oliweera banyakubikutuma byotoori̱mwo. ");
INSERT INTO rub_vpl VALUES ("PR22_22","021_22_22","PRO","22","22","22","Otalinyaga munaku hab̯wakubba talinaho, kandi otali̱wonawonesya museege mwicwero lya musangu, ");
INSERT INTO rub_vpl VALUES ("PR22_23","021_22_23","PRO","22","23","23","hab̯wakubba Mukama alibatongoniira, naanyaga bakubanyaga. ");
INSERT INTO rub_vpl VALUES ("PR22_24","021_22_24","PRO","22","24","24","Otalinywana muntu akwatwa ki̱ni̱ga, habbe ku̱di̱da na wa b̯usungu b̯wa b̯wangu, ");
INSERT INTO rub_vpl VALUES ("PR22_25","021_22_25","PRO","22","25","25","aleke oteega mize myamwe, okagwa mu kabii. ");
INSERT INTO rub_vpl VALUES ("PR22_26","021_22_26","PRO","22","26","26","Otalibba omwei̱ hali bab̯wo beehayo nibeeraga, rundi nibeemeera mabanza ga bandi, ");
INSERT INTO rub_vpl VALUES ("PR22_27","021_22_27","PRO","22","27","27","b̯wolikalemwa kusasula, ntabbu gyamu gyolalira gyogyo balitwala. ");
INSERT INTO rub_vpl VALUES ("PR22_28","021_22_28","PRO","22","28","28","Otali̱segu̱li̱i̱rya mubaga gwa kadei na kadei, gwa bahaaha baamu baateeri̱ho. ");
INSERT INTO rub_vpl VALUES ("PR22_29","021_22_29","PRO","22","29","29","Akora mulimo gwamwe kurungi yeetonera na bakama, teicaara na bantu ba b̯uli kiro. ");
INSERT INTO rub_vpl VALUES ("PR23_1","021_23_1","PRO","23","1","1","B̯wolibbanga oi̱cali̱i̱ri̱ kudya na mu̱lemi̱, weekengerenge byaku̱segereerye. ");
INSERT INTO rub_vpl VALUES ("PR23_2","021_23_2","PRO","23","2","2","Waabba nooli waamururu weefugenge. ");
INSERT INTO rub_vpl VALUES ("PR23_3","021_23_3","PRO","23","3","3","Otalitubira bidyo byaku̱ti̱mbi̱i̱ri̱, tiweega gwakubba mutegu. ");
INSERT INTO rub_vpl VALUES ("PR23_4","021_23_4","PRO","23","4","4","Mu̱leke kwejwahya naaku̱toolya itungu, mu̱bbe na magezi̱ mwemige. ");
INSERT INTO rub_vpl VALUES ("PR23_5","021_23_5","PRO","23","5","5","Obba noocakalitaho li̱i̱so ni̱li̱syera nka rundi si li̱meeri̱ bimpaha lyadu̱ndu̱u̱ka mu mwanya nka wambooli̱. ");
INSERT INTO rub_vpl VALUES ("PR23_6","021_23_6","PRO","23","6","6","Otadyanga bidyo bya mupu, habbe kwegomba bi̱nolu̱ byamwe, ");
INSERT INTO rub_vpl VALUES ("PR23_7","021_23_7","PRO","23","7","7","hab̯wakubba eicala nabaliira muhendu gu̱yabi̱gu̱u̱ri̱, akuweera, “Dya kandi onywe,” bei̱tu̱ ataku̱ki̱manyi̱sya. ");
INSERT INTO rub_vpl VALUES ("PR23_8","021_23_8","PRO","23","8","8","Okwi̱za kubitunaka bi̱waadi̱i̱ri̱, na bigambu byakwenolereerya byolibba obazi̱ri̱ bilibba byab̯usa. ");
INSERT INTO rub_vpl VALUES ("PR23_9","021_23_9","PRO","23","9","9","Otali̱bazi̱ri̱ryanga mudoma, kubba byamagezi̱ byomuweera akwi̱za kubigaya. ");
INSERT INTO rub_vpl VALUES ("PR23_10","021_23_10","PRO","23","10","10","Otali̱segu̱li̱i̱rya nsaru gya kadei na kadei otalyezi̱ri̱i̱rya itehe lya nfu̱u̱zi̱. ");
INSERT INTO rub_vpl VALUES ("PR23_11","021_23_11","PRO","23","11","11","Hab̯wakubba mu̱bacu̱ngu̱ri̱ wamaani, akwi̱za kubalwaniira, atongane nanywe. ");
INSERT INTO rub_vpl VALUES ("PR23_12","021_23_12","PRO","23","12","12","Taho mutima gwamu ha kuhondera kulambwa, naakuteganga mapokopo kwegwa bigambu bya kwetegereza. ");
INSERT INTO rub_vpl VALUES ("PR23_13","021_23_13","PRO","23","13","13","Otalyehu̱u̱kya kuhab̯ura mwana waamu, kumukuuta na kajunju tikisobora ku̱mwi̱ta. ");
INSERT INTO rub_vpl VALUES ("PR23_14","021_23_14","PRO","23","14","14","Hab̯wakubba kumufubira ki̱i̱za kumujuna lu̱ku̱u̱. ");
INSERT INTO rub_vpl VALUES ("PR23_15","021_23_15","PRO","23","15","15","Mwana wanga, wolikabba na magezi̱ nagya ndisemererwa. ");
INSERT INTO rub_vpl VALUES ("PR23_16","021_23_16","PRO","23","16","16","B̯u̱ndikwegwa nookubaza bigambu bya magezi̱, ndyesi̱i̱ma mu mutima gwange. ");
INSERT INTO rub_vpl VALUES ("PR23_17","021_23_17","PRO","23","17","17","Otakwatirwa itima babiibi, gyenda mu mei̱so naakutamwo Mukama ki̱ti̱i̱ni̱sa. ");
INSERT INTO rub_vpl VALUES ("PR23_18","021_23_18","PRO","23","18","18","Hab̯wakubba olitungiramwo mpeera, kyaku̱ni̱hi̱ra kwamu kiliiza. ");
INSERT INTO rub_vpl VALUES ("PR23_19","021_23_19","PRO","23","19","19","Mwana wange, weetegeerya kandi obbe wa magezi̱, taho mutima kukora birungi. ");
INSERT INTO rub_vpl VALUES ("PR23_20","021_23_20","PRO","23","20","20","Weehalanga ku̱di̱da na batami̱i̱ru̱, rundi batubira nyama, ");
INSERT INTO rub_vpl VALUES ("PR23_21","021_23_21","PRO","23","21","21","hab̯wakubba mu̱tami̱i̱ru̱ na mu̱tu̱u̱b̯u̱ bakwi̱za kuseega, nibadwa ha kulwala nsensende. ");
INSERT INTO rub_vpl VALUES ("PR23_22","021_23_22","PRO","23","22","22","Weegwanga bbaawu, munyakukubyala, ogonderenge maawu nab̯wali̱gu̱lu̱u̱sa. ");
INSERT INTO rub_vpl VALUES ("PR23_23","021_23_23","PRO","23","23","23","Mananu, magezi̱, ngesu na kwetegereza bya mugasu kubitunga, otalibifeerwa. ");
INSERT INTO rub_vpl VALUES ("PR23_24","021_23_24","PRO","23","24","24","Mudulu wa mwana murungi alisemererwa, munyakubyala mwana mu̱gezi̱ yeesi̱i̱me. ");
INSERT INTO rub_vpl VALUES ("PR23_25","021_23_25","PRO","23","25","25","Bbaawu na mmaawu beesi̱i̱me, mu̱kali̱ yogwo munyakukubyala asemererwenge. ");
INSERT INTO rub_vpl VALUES ("PR23_26","021_23_26","PRO","23","26","26","Mwana wange taho mutima gwamu ha bigambu byange, ohondere ngesu zange. ");
INSERT INTO rub_vpl VALUES ("PR23_27","021_23_27","PRO","23","27","27","Mu̱kali̱ mu̱b̯u̱ngi̱ kandi mwenzi̱, eisana b̯u̱hya. ");
INSERT INTO rub_vpl VALUES ("PR23_28","021_23_28","PRO","23","28","28","Atega badulu nka banyagi̱, nabongera b̯utabba beesigwa. ");
INSERT INTO rub_vpl VALUES ("PR23_29","021_23_29","PRO","23","29","29","Banaani beicala nibazongoba? Mpaka zikuutwa banaani? Bihote bili na banaani? Kulwanagana kuli na naani? Mpaka zili na naani? Bihote bitakuhona bili na naani? Mei̱so gengu̱ gali na naani? ");
INSERT INTO rub_vpl VALUES ("PR23_30","021_23_30","PRO","23","30","30","Boobo bab̯wo beicaara ha maaci batakurugaho, nibanywa gaga na gadi̱. ");
INSERT INTO rub_vpl VALUES ("PR23_31","021_23_31","PRO","23","31","31","Maaci na rangi̱ zaago gatakwohyanga, gatakusikirizanga namu giraasi oganywe. ");
INSERT INTO rub_vpl VALUES ("PR23_32","021_23_32","PRO","23","32","32","Hei̱nyu̱ma gukuluma nka mpiri, nigakutematema nka b̯umala b̯wa hu̱lu̱hu̱ndu̱. ");
INSERT INTO rub_vpl VALUES ("PR23_33","021_23_33","PRO","23","33","33","Mei̱so gaamu galiwona masana, mutima gwamu nigutekereza kiki na ki̱di̱. ");
INSERT INTO rub_vpl VALUES ("PR23_34","021_23_34","PRO","23","34","34","Olyezegwa nkoleeri̱ hakati̱ weitaka, nka nkwokusulebera mu b̯wati̱ b̯ukukuutwa kihehu. ");
INSERT INTO rub_vpl VALUES ("PR23_35","021_23_35","PRO","23","35","35","Olikoba yati, “Banku̱u̱ti̱ri̱, b̯u̱ku̱u̱ti̱, bei̱tu̱ tindina hampu̱teeri̱, banti̱ndagi̱ri̱ b̯u̱ti̱ndagi̱ ntakwega!” B̯wi̱re b̯wakya di̱i̱? Ndinakutungayo maaci gandi. ");
INSERT INTO rub_vpl VALUES ("PR24_1","021_24_1","PRO","24","1","1","Otalikwatirwa i̱hali̱ nkori̱ za bibii, kadi habbe kubanywana, ");
INSERT INTO rub_vpl VALUES ("PR24_2","021_24_2","PRO","24","2","2","hab̯wakubba beicala nibatab̯ukatab̯uka, kubaza kwab̯u kuhutaaza bandi. ");
INSERT INTO rub_vpl VALUES ("PR24_3","021_24_3","PRO","24","3","3","Maka gakorwa magezi̱, kwetegereza ni̱ku̱gemereeryaho. ");
INSERT INTO rub_vpl VALUES ("PR24_4","021_24_4","PRO","24","4","4","Mu kukenga bi̱si̱i̱ka bya nnyu̱mba bizula na bikwatu bya mugasu bya muhendu kandi birungi. ");
INSERT INTO rub_vpl VALUES ("PR24_5","021_24_5","PRO","24","5","5","Muntu mu̱gezi̱ akira wamaani, mwetegerezi̱ yeyongera kubba munyamaani, ");
INSERT INTO rub_vpl VALUES ("PR24_6","021_24_6","PRO","24","6","6","hab̯wakubba kulwana b̯ulemu ki̱si̱gi̱ki̱ra ha ntegeka za magezi̱, ku̱b̯u̱si̱nga, bakub̯uhanulira balinakubba banene. ");
INSERT INTO rub_vpl VALUES ("PR24_7","021_24_7","PRO","24","7","7","Bigambu bya muntu mu̱gezi̱ tibigasira mudoma, talinakyabaza hali bakuhanuura byamugasu. ");
INSERT INTO rub_vpl VALUES ("PR24_8","021_24_8","PRO","24","8","8","Yensei̱ eicala naatekereza kukora bibiibi, bamweta mu̱gezi̱gezi̱. ");
INSERT INTO rub_vpl VALUES ("PR24_9","021_24_9","PRO","24","9","9","Kuhab̯urwa kwa mudoma kibba kibii, na mu̱gayi̱ abba muziro hali bantu. ");
INSERT INTO rub_vpl VALUES ("PR24_10","021_24_10","PRO","24","10","10","Kabii b̯u̱kei̱za ni̱kakaku̱su̱lu̱ngani̱a, mananu kwo obba muceke. ");
INSERT INTO rub_vpl VALUES ("PR24_11","021_24_11","PRO","24","11","11","Waacunguranga bantu bakutwalwa kwi̱twa, waajuniranga bakweti̱ gukubagoromora. ");
INSERT INTO rub_vpl VALUES ("PR24_12","021_24_12","PRO","24","12","12","Osobora kukoba, “Ntakakyege!” Bei̱tu̱ yogwo asengeeja biteekerezu yeega bili mu mutima. Yogwo akulinda akyegi̱ri̱, alikusasula naasi̱gi̱ki̱ra ha milimo mi̱wakoori̱. ");
INSERT INTO rub_vpl VALUES ("PR24_13","021_24_13","PRO","24","13","13","Mwana wange, dyanga b̯uhooki b̯ubba b̯urungi, manyondo gaab̯wo ganolira ki̱mwei̱. ");
INSERT INTO rub_vpl VALUES ("PR24_14","021_24_14","PRO","24","14","14","Okyege nti, magezi̱ nka b̯uhooki ganolira mutima gwamu, kakubba ogaagya olibba kurungi, naku̱ni̱hi̱ra kwamu tikulimalika. ");
INSERT INTO rub_vpl VALUES ("PR24_15","021_24_15","PRO","24","15","15","Otabba mubiibi aramagira murungi, weehalenge ku̱ru̱mba nnyu̱mba gyamwe, ");
INSERT INTO rub_vpl VALUES ("PR24_16","021_24_16","PRO","24","16","16","kubba nab̯wagwa mirundi musanju asigala naabyoka, bei̱tu̱ babiibi nibaswaswanika nibamaliraho ki̱mwei̱. ");
INSERT INTO rub_vpl VALUES ("PR24_17","021_24_17","PRO","24","17","17","Oteeb̯uganga munyanzigwa waamu yaakagweb̯wangaho kabii, otamu̱sekereeryanga b̯uyaakagwanga hansi. ");
INSERT INTO rub_vpl VALUES ("PR24_18","021_24_18","PRO","24","18","18","Kubba wolibikora, Mukama alikuzingalira, naalekaho kumufubira. ");
INSERT INTO rub_vpl VALUES ("PR24_19","021_24_19","PRO","24","19","19","Otatuntuliranga bantu babiibi, habbe kukwatirwa i̱hali̱ nkori̱ za bibii, ");
INSERT INTO rub_vpl VALUES ("PR24_20","021_24_20","PRO","24","20","20","kubba mubiibi talitunga birungi, ali̱lu̱ma b̯u̱lu̱mi̱ nka taara. ");
INSERT INTO rub_vpl VALUES ("PR24_21","021_24_21","PRO","24","21","21","Mwana wange, ti̱i̱nanga Mukama na mu̱lemi̱, kandi otadi̱danga na bantu bajeemu̱. ");
INSERT INTO rub_vpl VALUES ("PR24_22","021_24_22","PRO","24","22","22","Babiri bab̯wo basobora kubahwerekereerya hahwo b̯uloho b̯uloho haloho yeegi̱ri̱ b̯ujune b̯ulileetwa bab̯wo babiri? ");
INSERT INTO rub_vpl VALUES ("PR24_23","021_24_23","PRO","24","23","23","Bibi nabyo bili bigambu bya magezi̱. Muze gwa kusemba rubaju lu̱mwi̱ tigubba gurungi. ");
INSERT INTO rub_vpl VALUES ("PR24_24","021_24_24","PRO","24","24","24","Aweera mubiibi nti, “Toli na musangu,” bantu balimukyena kandi balimunoba. ");
INSERT INTO rub_vpl VALUES ("PR24_25","021_24_25","PRO","24","25","25","Baramu̱ri̱ bafubira nkori̱ za bibii, baliheeb̯wa mu̱gi̱sa. ");
INSERT INTO rub_vpl VALUES ("PR24_26","021_24_26","PRO","24","26","26","Akuweera mananu, abba akwolokeeye mukagu gwa biribiri. ");
INSERT INTO rub_vpl VALUES ("PR24_27","021_24_27","PRO","24","27","27","Banza otegeke misiri omisimbe, kasi obi̱mbe nnyu̱mba. ");
INSERT INTO rub_vpl VALUES ("PR24_28","021_24_28","PRO","24","28","28","Otarumirizanga mu̱taahi̱ atali na nsonga, otabazanga b̯u̱gobya. ");
INSERT INTO rub_vpl VALUES ("PR24_29","021_24_29","PRO","24","29","29","Otakobanga nti, “Kyankoori̱ nagya ndikimukora, ndikimusasula ki̱i̱yankoori̱.” ");
INSERT INTO rub_vpl VALUES ("PR24_30","021_24_30","PRO","24","30","30","Nyaarabi̱ri̱ mu ndimiro gya mugarei, mu musiri gwa mi̱zabbi̱bbu̱ gwa ntwarwa. ");
INSERT INTO rub_vpl VALUES ("PR24_31","021_24_31","PRO","24","31","31","Gwali gwi̱zwi̱ri̱ mahwa, gu̱ju̱mbi̱ri̱ neirungu, na lugo lwagwo lwa mahi̱ga lu̱gwi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PR24_32","021_24_32","PRO","24","32","32","Nyagu̱li̱ngi̱ri̱i̱ri̱, nyeega b̯utakoba, ");
INSERT INTO rub_vpl VALUES ("PR24_33","021_24_33","PRO","24","33","33","“Kandaaleho kadooli̱, kandindeho kadooli̱, kammpu̱u̱mu̱u̱lyeho mikono kadooli̱.” ");
INSERT INTO rub_vpl VALUES ("PR24_34","021_24_34","PRO","24","34","34","Mwomwo nnaku zi̱li̱kwi̱zi̱ra nka mwi̱bi̱, ni̱zi̱ku̱ru̱mba nka mutemu. ");
INSERT INTO rub_vpl VALUES ("PR25_1","021_25_1","PRO","25","1","1","Kandi zizi nazo zili ngeera za Sulumaani, badulu ba Mukama Heezeki̱ya wa Yu̱da zi̱bakoporoori̱. ");
INSERT INTO rub_vpl VALUES ("PR25_2","021_25_2","PRO","25","2","2","Ki̱ti̱i̱ni̱sa kya Ruhanga kulinda nsita kya bakama kubba ku̱hu̱lu̱kya makuru. ");
INSERT INTO rub_vpl VALUES ("PR25_3","021_25_3","PRO","25","3","3","Iguru nka kulibba hakyendi̱ na nsi nka kugiicala gilei, kwokwo de otasobora kwetegereza mitima mya bakama. ");
INSERT INTO rub_vpl VALUES ("PR25_4","021_25_4","PRO","25","4","4","Kakubba bantu batoola b̯u̱rofu̱ mu feeza kugifoora gyei̱cu̱mi̱, baheesa byoma bakusobora kukoramwo bintu birungi. ");
INSERT INTO rub_vpl VALUES ("PR25_5","021_25_5","PRO","25","5","5","Toolaho bantu babiibi mu mei̱so ga mukama, na b̯u̱lemi̱ b̯wamwe b̯ulyegeb̯wa kubba b̯wa b̯unanu. ");
INSERT INTO rub_vpl VALUES ("PR25_6","021_25_6","PRO","25","6","6","Lekanga kwetwala mu mei̱so hali mukama ali, rundi kwemeera mu kiikaru cali bantu ba bi̱ti̱i̱ni̱sa bali, ");
INSERT INTO rub_vpl VALUES ("PR25_7","021_25_7","PRO","25","7","7","hakiri bakuweera yati, “Weesu̱ma oicaare haha,” kukira kukuswazira mu babi̱ti̱i̱ni̱sa. Nooli na byoweeni̱ na mei̱so gaamu ");
INSERT INTO rub_vpl VALUES ("PR25_8","021_25_8","PRO","25","8","8","otanguhanga kunyegeera nsonga gyensei̱ mu mbuga gya mateeka olikola teetei̱ hakumaliira, kakubba harugayo muntu aku̱ku̱honereerya weewe kubba mu̱nsobi̱? ");
INSERT INTO rub_vpl VALUES ("PR25_9","021_25_9","PRO","25","9","9","Wakabbanga na nsonga na mwi̱ra waamu, mugimalenge nywenkei mu nsita gi̱takabbeeri̱ kwetegerezeb̯we mu bandi. ");
INSERT INTO rub_vpl VALUES ("PR25_10","021_25_10","PRO","25","10","10","Kakubba mutamala nsonga zi̱zo, bantu banene bakwi̱za kukwega nka muntu atagira nsita, kandi tolyejuna ki̱kyo kihemu. ");
INSERT INTO rub_vpl VALUES ("PR25_11","021_25_11","PRO","25","11","11","Kigambu ki̱zi̱i̱ri̱ mu kasu̱mi̱ kaakyo, kiisana zaabbu mu lukimba lwa feeza. ");
INSERT INTO rub_vpl VALUES ("PR25_12","021_25_12","PRO","25","12","12","Kuhab̯ura kwa muntu wa magezi̱ aweera yogwo yeetege kwegwa, kibba kyamugasu kukira bikwatu bikore kuruga mu zaabbu. ");
INSERT INTO rub_vpl VALUES ("PR25_13","021_25_13","PRO","25","13","13","Mukwenda mwesigwa ahu̱u̱mu̱u̱lya mu̱mu̱tu̱mi̱, nka meezi̱ geenyamu̱ gaakunywa b̯u̱gahu̱u̱mu̱u̱lya baganywi̱ mu b̯wi̱re wa lyoba. ");
INSERT INTO rub_vpl VALUES ("PR25_14","021_25_14","PRO","25","14","14","Aragani̱sya bisembu byataku̱doosereerya, abba nka byalu na mpehu bitaguma ndagali̱. ");
INSERT INTO rub_vpl VALUES ("PR25_15","021_25_15","PRO","25","15","15","Kugumisiriza ku̱sonasooni̱a mu̱lemi̱, kandi kalimi kaheheeru̱ kooko korobya muntu. ");
INSERT INTO rub_vpl VALUES ("PR25_16","021_25_16","PRO","25","16","16","B̯wolibba na b̯uhooki, dya b̯wokusobora, otali̱i̱za kudya kyakalaseeni̱ okamaliira ob̯u̱tu̱naki̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PR25_17","021_25_17","PRO","25","17","17","Otab̯ungiranga mwi̱ra waamu mirundi minene, akamaliira akweganyi̱ri̱ kandi aku̱nobi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PR25_18","021_25_18","PRO","25","18","18","Kuhangiira mwi̱ra waamwe, kiisana ku̱mu̱lwani̱sya okweti̱ mubbeere, mpirima, rundi mbasi. ");
INSERT INTO rub_vpl VALUES ("PR25_19","021_25_19","PRO","25","19","19","Kwesiga muntu atakuloho mu b̯wi̱re wa b̯uzib̯u, kiisana nka ku̱di̱sya liino li̱seeri̱ rundi nka wa kihote ha kigulu. ");
INSERT INTO rub_vpl VALUES ("PR25_20","021_25_20","PRO","25","20","20","Ku̱hi̱i̱mi̱ra kyembu kirungi muntu ali na b̯ujune, kiisana nka kumusomola ngoye mu b̯wi̱re b̯wi̱nyamu̱, rundi nka kumubbwomira mu̱kwa mu kihote. ");
INSERT INTO rub_vpl VALUES ("PR25_21","021_25_21","PRO","25","21","21","Munyanzigwa waamu nzala b̯ugyamudyanga omuhenge bidyo, nyoota b̯ugyamukwatanga omuhenge meezi̱ ga kunywa. ");
INSERT INTO rub_vpl VALUES ("PR25_22","021_25_22","PRO","25","22","22","Mu kukora yatyo olibba nookumuleetera kuswara, omu̱hembeeri̱ mworo ku mu̱twe, kandi we Mukama alikusasula. ");
INSERT INTO rub_vpl VALUES ("PR25_23","021_25_23","PRO","25","23","23","Nka mpehu ziruga mu mukono gumoso zileeta ndagali̱, kwokwo de kalimi kahesa kaleeta ki̱ni̱ga. ");
INSERT INTO rub_vpl VALUES ("PR25_24","021_25_24","PRO","25","24","24","Hakiri oicala mu ki̱si̱i̱si̱ra, kukira kwicala mu nnyu̱mba gi̱mwei̱ na mu̱kali̱ weizongobo. ");
INSERT INTO rub_vpl VALUES ("PR25_25","021_25_25","PRO","25","25","25","Kwegwa makuru garungi garu̱gi̱ri̱ hadei, kili nka kunywa meezi̱ gei̱nyamu̱ kumala nnyoota. ");
INSERT INTO rub_vpl VALUES ("PR25_26","021_25_26","PRO","25","26","26","Muntu murungi watwalwa bikorwa bya mubiibi, abba nka misu rundi nka i̱zu̱ba li̱ku̱hu̱lu̱kya meezi̱ gatomboku̱. ");
INSERT INTO rub_vpl VALUES ("PR25_27","021_25_27","PRO","25","27","27","Nka kukitecala kirungi kudya b̯uhooki b̯unene, kwokwo de ki̱tasemeeri̱ kwetoleerya ki̱ti̱i̱ni̱sa kyamu wenkei. ");
INSERT INTO rub_vpl VALUES ("PR25_28","021_25_28","PRO","25","28","28","Muntu aterinda, eisana nka rub̯uga lunyakwingirirwa lutali na bi̱si̱i̱ka byakwerinda. ");
INSERT INTO rub_vpl VALUES ("PR26_1","021_26_1","PRO","26","1","1","Nka byalu ku̱bi̱tetagi̱sya mu kyanda, rundi ndagali̱ mu b̯wi̱re b̯wa kukesa, kwokwo ki̱tetagi̱sya kuha mudoma ki̱ti̱i̱ni̱sa. ");
INSERT INTO rub_vpl VALUES ("PR26_2","021_26_2","PRO","26","2","2","Nka mantanta akwelongoolya atakwi̱cya, kwokwo na mukyenu gutaakwate muntu gutagira b̯u̱si̱gi̱ki̱ro. ");
INSERT INTO rub_vpl VALUES ("PR26_3","021_26_3","PRO","26","3","3","Mbooko zikuuta mbaraasi, nkobba nizibboha mi̱nwa mya ndogoyi̱, mubbeere gukuuta mugongo gwa mudoma. ");
INSERT INTO rub_vpl VALUES ("PR26_4","021_26_4","PRO","26","4","4","Mudoma otali̱mwi̱ramwo mu mu̱li̱ngo gwa b̯udoma, aleke nawe otalibba nka yo. ");
INSERT INTO rub_vpl VALUES ("PR26_5","021_26_5","PRO","26","5","5","Bei̱tu̱ nookwi̱ramwo badoma, bolookye nka kubali basu̱ru̱, kwokwo baleke kwezeta ba magezi̱. ");
INSERT INTO rub_vpl VALUES ("PR26_6","021_26_6","PRO","26","6","6","Kutuma mudoma b̯ukwenda, obba wetemi̱ri̱ ntege, kandi weeteeri̱ mu kabii. ");
INSERT INTO rub_vpl VALUES ("PR26_7","021_26_7","PRO","26","7","7","Nka magulu ga mulima kugeicala nigasuleeba, na lugeera lubacwera mudoma tulubba namugasu. ");
INSERT INTO rub_vpl VALUES ("PR26_8","021_26_8","PRO","26","8","8","Kuha mudoma ki̱ti̱i̱ni̱sa oisana nka kubbohira i̱hi̱ga ku kimancuuru. ");
INSERT INTO rub_vpl VALUES ("PR26_9","021_26_9","PRO","26","9","9","Lugeera lwa badoma bacwa, kiisana nka mu̱tami̱i̱ru̱ kwezokola ihwa mu ngalu. ");
INSERT INTO rub_vpl VALUES ("PR26_10","021_26_10","PRO","26","10","10","Muntu akoresya mudoma milimo rundi muntu gyakagi̱i̱rye, eisana nka mulasa mbasi atabali̱ri̱i̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PR26_11","021_26_11","PRO","26","11","11","Mudoma ei̱ri̱ra kukora byab̯udoma, eisana nka mbwene gi̱i̱ri̱ra bituna byagyo. ");
INSERT INTO rub_vpl VALUES ("PR26_12","021_26_12","PRO","26","12","12","Waaweeni̱ho muntu akwezeta wa magezi̱? Bantu bani̱hi̱ramwo birungi mu kukira yo. ");
INSERT INTO rub_vpl VALUES ("PR26_13","021_26_13","PRO","26","13","13","Mugarei akuweera, “Ntali gili hanzei mu muhanda! Ntali gili mu ngu̱u̱do!” ");
INSERT INTO rub_vpl VALUES ("PR26_14","021_26_14","PRO","26","14","14","Nka mulyangu kugwicala nigwehinduhindulira ha pata zaagwo, kwokwo de mugarei eicala niyehinduhindula mu ntabbu gyamwe. ");
INSERT INTO rub_vpl VALUES ("PR26_15","021_26_15","PRO","26","15","15","Mugarei waakolya itongi mu nnyeni̱, li̱mu̱jwahya kulita mu mu̱nwa. ");
INSERT INTO rub_vpl VALUES ("PR26_16","021_26_16","PRO","26","16","16","Mugarei yeezeta mu̱gezi̱ kukira bantu musanju bei̱ramu nakwegyendereza. ");
INSERT INTO rub_vpl VALUES ("PR26_17","021_26_17","PRO","26","17","17","Muntu yeezi̱ngi̱i̱rya mu mpaka zitakumukwataho, eisana nka muntu akukwata mapokopo ga mbwene gyateegi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PR26_18","021_26_18","PRO","26","18","18","Eisana nka muntu mugweraru, aku̱hu̱ngu̱u̱lya mworo naalasa na b̯uta, ");
INSERT INTO rub_vpl VALUES ("PR26_19","021_26_19","PRO","26","19","19","yooyo muntu agobya mwi̱ra, naakoba nyakali kusandaara b̯u̱sandaari̱. ");
INSERT INTO rub_vpl VALUES ("PR26_20","021_26_20","PRO","26","20","20","Nkwi̱ hazitali mworo gu̱lu̱mambe, na mu̱hesi̱ hatali tihabbaho izongobo. ");
INSERT INTO rub_vpl VALUES ("PR26_21","021_26_21","PRO","26","21","21","Muntu abyokereerya izongobo aleeta kulwana, nka nkwi̱, rundi makala gakwaka gatakumalikira. ");
INSERT INTO rub_vpl VALUES ("PR26_22","021_26_22","PRO","26","22","22","Makuru gacwe ganolira akugegwa nka bidyo bi̱nolu̱ kubiicala mu nda. ");
INSERT INTO rub_vpl VALUES ("PR26_23","021_26_23","PRO","26","23","23","Bantu babaza birungi nibakutekereza kukora bibiibi, beisana kyese ki̱si̱i̱gi̱rwe feeza. ");
INSERT INTO rub_vpl VALUES ("PR26_24","021_26_24","PRO","26","24","24","Muntu wa nnobi̱, agobyagobya bantu na bigambu byamwe, kandi b̯u̱gobya ab̯u̱bi̱sa mu mutima gwamwe. ");
INSERT INTO rub_vpl VALUES ("PR26_25","021_26_25","PRO","26","25","25","Nab̯walibazanga birungi teetei̱, otalimwikiriza, kubba ali na bibiibi musanju byabi̱i̱ki̱ri̱ mu mutima gwamwe. ");
INSERT INTO rub_vpl VALUES ("PR26_26","021_26_26","PRO","26","26","26","Nnobi̱ gyamwe gisobora kwebi̱sa hab̯wa bu̱gobya, bei̱tu̱ b̯ubiibi b̯wamwe b̯ulizooka hasyanu̱ mu bantu beicala nabo. ");
INSERT INTO rub_vpl VALUES ("PR26_27","021_26_27","PRO","26","27","27","Muntu alilima b̯u̱hya, ali̱b̯u̱gwamwo, kandi muntu abi̱ri̱ngi̱tya i̱hi̱ga yooyo li̱mwi̱ri̱ra. ");
INSERT INTO rub_vpl VALUES ("PR26_28","021_26_28","PRO","26","28","28","Kalimi kab̯u̱gobya kanoba gi̱kagobeerye, kandi kunweneeka kuleeta kuhwerekeera. ");
INSERT INTO rub_vpl VALUES ("PR27_1","021_27_1","PRO","27","1","1","Otepanki̱sya byokugyenda kukora mwakya, kubba ti̱wegi̱ri̱ kikugyenda kubbaho mu kiro. ");
INSERT INTO rub_vpl VALUES ("PR27_2","021_27_2","PRO","27","2","2","Leka bantu bandi boobo bakuhaariize, kukira we wenkei kwehaariiza. ");
INSERT INTO rub_vpl VALUES ("PR27_3","021_27_3","PRO","27","3","3","Mahi̱ga na musinyi biicala byozoho, bei̱tu̱ ki̱ni̱ga kya mudoma, kikira bi̱byo byensei̱. ");
INSERT INTO rub_vpl VALUES ("PR27_4","021_27_4","PRO","27","4","4","Muntu wa ki̱ni̱ga abba mubiibi, bei̱tu̱ wei̱hali̱ akiraho. ");
INSERT INTO rub_vpl VALUES ("PR27_5","021_27_5","PRO","27","5","5","Kirungi kucomera mu rwatu, kukira kwolokya ngonzi mu̱kyebi̱si̱i̱re. ");
INSERT INTO rub_vpl VALUES ("PR27_6","021_27_6","PRO","27","6","6","Kulamba kwa munywani kubba kwa mananu, bei̱tu̱ ku̱ramu̱kya kwa munyanzigwa b̯ubba b̯u̱gobya. ");
INSERT INTO rub_vpl VALUES ("PR27_7","021_27_7","PRO","27","7","7","Mwi̱cu̱tu̱ yooyo akoba b̯uhooki tib̯ukunola, bei̱tu̱ ali nzala, na kilulu akyeta ki̱nolu̱. ");
INSERT INTO rub_vpl VALUES ("PR27_8","021_27_8","PRO","27","8","8","Muntu aleka makaa gaamwe akazaahira handi, abba nka nnyoni̱ gi̱ti̱gi̱ri̱ kizonza kyagyo. ");
INSERT INTO rub_vpl VALUES ("PR27_9","021_27_9","PRO","27","9","9","Maku̱ta gaku̱b̯u̱nyo kurungi gasemaza mutima, na mukagu gurungi guleetwa kuhanuura kurungi. ");
INSERT INTO rub_vpl VALUES ("PR27_10","021_27_10","PRO","27","10","10","Otalyebeera munywanwo, rundi munywani wa bbaawu, kandi otalib̯ungiiranga weenyu̱ nooli mu bizib̯u, mu̱taahi̱, akira munyaruganda akuli hadei. ");
INSERT INTO rub_vpl VALUES ("PR27_11","021_27_11","PRO","27","11","11","Mwana wange bbanga mu̱gezi̱, osemeze mutima gwange, kwokwo ntunge kyakwi̱ramwo akumbihiza. ");
INSERT INTO rub_vpl VALUES ("PR27_12","021_27_12","PRO","27","12","12","Akwetegereza awona kabii ni̱kakwi̱za niyebbala, bei̱tu̱ ntwarwa gyecoberab̯wecoberi̱ nigiwonawona nakyo. ");
INSERT INTO rub_vpl VALUES ("PR27_13","021_27_13","PRO","27","13","13","B̯wema b̯wa ategebeerwe, b̯uli na kusembwa musimbo, asagika munyamahanga alinakumusasulira. ");
INSERT INTO rub_vpl VALUES ("PR27_14","021_27_14","PRO","27","14","14","Kakubba muntu akeera ku̱ramu̱kya mu̱taahi̱ neitoko, kiwonwa nka mukyeno. ");
INSERT INTO rub_vpl VALUES ("PR27_15","021_27_15","PRO","27","15","15","Mu̱kali̱ weizongobo, eisana nka ndagali̱ gikutuntula gitakwamuka. ");
INSERT INTO rub_vpl VALUES ("PR27_16","021_27_16","PRO","27","16","16","Kumugaana kuzongoba oisana okutanga mpehu, rundi kukwata maku̱ta mu ngalu. ");
INSERT INTO rub_vpl VALUES ("PR27_17","021_27_17","PRO","27","17","17","Kyoma nka kukiteekera kyoma, kwokwo de muntu ateekera mwi̱ra. ");
INSERT INTO rub_vpl VALUES ("PR27_18","021_27_18","PRO","27","18","18","Woroora musaali okwi̱za kugudyaho byana, linda mukama waamu akwi̱za ku̱ku̱si̱i̱ma. ");
INSERT INTO rub_vpl VALUES ("PR27_19","021_27_19","PRO","27","19","19","Nka muntu kuyeewona mu meezi̱, kwokwo de mutima gwamwe gwolokya kiki kyali. ");
INSERT INTO rub_vpl VALUES ("PR27_20","021_27_20","PRO","27","20","20","Kuzumu nka kukutadweb̯wa baku̱u̱, kwokwo de mei̱so ga muntu gatajwaha kuwona. ");
INSERT INTO rub_vpl VALUES ("PR27_21","021_27_21","PRO","27","21","21","Feeza na zaabbu bi̱pi̱mwa mworo, bei̱tu̱ muntu api̱mwa bikumuhaariiza. ");
INSERT INTO rub_vpl VALUES ("PR27_22","021_27_22","PRO","27","22","22","Mudoma nowomukuuta heehi̱ ku̱mwi̱ta b̯wi̱ti̱, b̯udoma waamwe tib̯umumalikamwo. ");
INSERT INTO rub_vpl VALUES ("PR27_23","021_27_23","PRO","27","23","23","Weega kulinda kurungi ntaama na mbu̱li̱ zaamu, kandi oteeho mutima ku nte zaamu. ");
INSERT INTO rub_vpl VALUES ("PR27_24","021_27_24","PRO","27","24","24","Kubba itungu tilyomeeraho biro na biro, na kondo giicalaho biro byensei̱? ");
INSERT INTO rub_vpl VALUES ("PR27_25","021_27_25","PRO","27","25","25","Isubi b̯ulyoma, hameraho lindi, na lya ku lusahu balisala nibalisoorozera bisolo. ");
INSERT INTO rub_vpl VALUES ("PR27_26","021_27_26","PRO","27","26","26","Okusobora kutunda ntaama na mbu̱li̱, kugula itehe na bilwalu. ");
INSERT INTO rub_vpl VALUES ("PR27_27","021_27_27","PRO","27","27","27","Okwi̱za kubba na mate ga mbu̱li̱ oganywe na mu̱gi̱ gwamu, kandi bahala bakori̱ baamu baganywe gababi̱mbe mibiri. ");
INSERT INTO rub_vpl VALUES ("PR28_1","021_28_1","PRO","28","1","1","Babiibi bei̱ru̱ka kadi hataloho akubabinga, bei̱tu̱ bananu babba basi̱gi̱ku̱ nka ntali. ");
INSERT INTO rub_vpl VALUES ("PR28_2","021_28_2","PRO","28","2","2","Ihanga b̯ulibba li̱jeemu̱ libba na balemi̱ banene, bei̱tu̱ hali mu̱lemi̱ mu̱gezi̱ kandi akwetegereza, liicala li̱tekanu̱. ");
INSERT INTO rub_vpl VALUES ("PR28_3","021_28_3","PRO","28","3","3","Mu̱lemi̱ mubiibi abonebonesya banaku, abba nka ndagali̱ gya kihehu, gikahenera bilimwa. ");
INSERT INTO rub_vpl VALUES ("PR28_4","021_28_4","PRO","28","4","4","Agaya biragiro, ahaariiza babiibi, bei̱tu̱ abikwata abalwani̱syambe. ");
INSERT INTO rub_vpl VALUES ("PR28_5","021_28_5","PRO","28","5","5","Babiibi tibeega b̯winganiza, bei̱tu̱ bahondera Mukama bab̯wetegereziira ki̱mwei̱. ");
INSERT INTO rub_vpl VALUES ("PR28_6","021_28_6","PRO","28","6","6","Kirungi kubba munaku nokulibatira mu b̯u̱terekereru̱, kukira kubba mu̱gu̱u̱da mu̱b̯u̱bbaamu̱. ");
INSERT INTO rub_vpl VALUES ("PR28_7","021_28_7","PRO","28","7","7","Mwana akwata biragiro, abba na magezi̱, bei̱tu̱ anywana na bamururu aswaza bbaawe. ");
INSERT INTO rub_vpl VALUES ("PR28_8","021_28_8","PRO","28","8","8","Ku̱kanyi̱a itungu nooraba mukutolaho bantu magoba ganene, lilimaliira mu nsahu gya mwenda. ");
INSERT INTO rub_vpl VALUES ("PR28_9","021_28_9","PRO","28","9","9","Muntu b̯wagaya biragiro bya Ruhanga, kusaba kwamwe Ruhanga talikwegwa. ");
INSERT INTO rub_vpl VALUES ("PR28_10","021_28_10","PRO","28","10","10","Yensei̱ ahabi̱sya barungi, alyeguma mu mutegu gwamwe, bei̱tu̱ batali na kabii baligweterwa birungi. ");
INSERT INTO rub_vpl VALUES ("PR28_11","021_28_11","PRO","28","11","11","Mu̱gu̱u̱da asobora kwewona nka mu̱gezi̱, bei̱tu̱ munaku akwetegereza awona bi̱doori̱. ");
INSERT INTO rub_vpl VALUES ("PR28_12","021_28_12","PRO","28","12","12","Muntu murungi waalema, bantu baasemererwambe, bei̱tu̱ mubiibi b̯ubamuhandya, bantu bei̱ru̱ka kwebi̱sa. ");
INSERT INTO rub_vpl VALUES ("PR28_13","021_28_13","PRO","28","13","13","Abbumbiira bibii byamwe talitunga mu̱gi̱sa, bei̱tu̱ abyatula akabileka alitunga mbabazi̱. ");
INSERT INTO rub_vpl VALUES ("PR28_14","021_28_14","PRO","28","14","14","Mukama aha mu̱gi̱sa yensei̱ ati̱i̱na kukora kibiibi, bei̱tu̱ atati̱i̱na aligwa mu kabii. ");
INSERT INTO rub_vpl VALUES ("PR28_15","021_28_15","PRO","28","15","15","Mu̱lemi̱ mubiibi abonebonesya banaku, eisana ntali gikuhuruguma, rundi musege gu̱ku̱hi̱i̱ga kya kudya. ");
INSERT INTO rub_vpl VALUES ("PR28_16","021_28_16","PRO","28","16","16","Mu̱lemi̱ atali na magezi̱ ahutaaza bantu bayebembera, bei̱tu̱ asuula bya b̯u̱nyagi̱ alyomeera. ");
INSERT INTO rub_vpl VALUES ("PR28_17","021_28_17","PRO","28","17","17","Muntu waabba nakujunaanwa hab̯wa b̯wi̱ti̱, mwamulekanga eicale naparaara, hatabbaho muntu yensei̱ akumujuna ");
INSERT INTO rub_vpl VALUES ("PR28_18","021_28_18","PRO","28","18","18","Akora birungi yooyo alijunwa, bei̱tu̱ ateesigwa ali̱zi̱ka b̯wangu. ");
INSERT INTO rub_vpl VALUES ("PR28_19","021_28_19","PRO","28","19","19","Akwekamba kulima abba na bidyo binene, bei̱tu̱ ei̱ru̱kya bitakugasa anakuhara ki̱mwei̱. ");
INSERT INTO rub_vpl VALUES ("PR28_20","021_28_20","PRO","28","20","20","Mwesigwa alitunga mi̱gi̱sa mitakubalwa, bei̱tu̱ wa mururu gweitungu alifubirwa. ");
INSERT INTO rub_vpl VALUES ("PR28_21","021_28_21","PRO","28","21","21","Kusoroora mu bantu kiicala kibiibi, bei̱tu̱ hab̯wa ngu̱zi̱ gi̱dooli̱, muntu amaliira asoobeerye. ");
INSERT INTO rub_vpl VALUES ("PR28_22","021_28_22","PRO","28","22","22","Mupu eicala ni̱yendya ku̱gu̱du̱hara, bei̱tu̱ atakwega nti nnaku gyogyo gi̱mu̱li̱ndi̱ri̱i̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PR28_23","021_28_23","PRO","28","23","23","Kuhab̯ura kwa mananu ku̱si̱i̱mwa, kukira kalimi kakuhaariiza. ");
INSERT INTO rub_vpl VALUES ("PR28_24","021_28_24","PRO","28","24","24","Yogwo ei̱ba babyeru̱ baamwe akateekereza tasobeerye, abba mwi̱bi̱ nyakabara. ");
INSERT INTO rub_vpl VALUES ("PR28_25","021_28_25","PRO","28","25","25","Waamururu yooyo aleeta mpaka, bei̱tu̱ yeesiga Mukama ali̱gu̱du̱hara. ");
INSERT INTO rub_vpl VALUES ("PR28_26","021_28_26","PRO","28","26","26","Yeesiga nteekereza gyamwe yankei abba mudoma, bei̱tu̱ alibatira mu magezi̱ alibba kurungi. ");
INSERT INTO rub_vpl VALUES ("PR28_27","021_28_27","PRO","28","27","27","Agabira banaku talibba na b̯wetaagu, bei̱tu̱ abei̱ti̱ira li̱i̱so alitunga mikyenu. ");
INSERT INTO rub_vpl VALUES ("PR28_28","021_28_28","PRO","28","28","28","Babiibi b̯u̱bei̱za mu b̯u̱lemi̱ bantu ni̱bebi̱sa, bei̱tu̱ b̯ubahwerekera barungi nibabyoka. ");
INSERT INTO rub_vpl VALUES ("PR29_1","021_29_1","PRO","29","1","1","Muntu walihanwa mirundi minene, akalemwa kwetegereza, alihwerekeera cekeceke. ");
INSERT INTO rub_vpl VALUES ("PR29_2","021_29_2","PRO","29","2","2","Bantu barungi b̯ubabba ha b̯u̱lemi̱, habbaho kusemererwa, bei̱tu̱ balemi̱ babiibi baleeta kwenghu̱ru̱nghu̱u̱tya. ");
INSERT INTO rub_vpl VALUES ("PR29_3","021_29_3","PRO","29","3","3","Yendya magezi̱ aleetera bbaawe kusemererwa, bei̱tu̱ yeekwata benzi̱ amalaho itungu lyamwe. ");
INSERT INTO rub_vpl VALUES ("PR29_4","021_29_4","PRO","29","4","4","Mukama waalema na b̯winganiza nsi nigiterekeera, bei̱tu̱ yendya byakwegula abba amaari̱ kugitemula. ");
INSERT INTO rub_vpl VALUES ("PR29_5","021_29_5","PRO","29","5","5","Muntu ahaariiza mwi̱ra, abba nakwetega magulu. ");
INSERT INTO rub_vpl VALUES ("PR29_6","021_29_6","PRO","29","6","6","Muntu mubiibi akwatwa kibii kyamwe, bei̱tu̱ murungi eicala naahi̱i̱ma na kusemererwa. ");
INSERT INTO rub_vpl VALUES ("PR29_7","021_29_7","PRO","29","7","7","Murungi yegi̱ri̱ banaku bi̱basemereeri̱ kutunga bei̱tu̱ mubiibi tabyega. ");
INSERT INTO rub_vpl VALUES ("PR29_8","021_29_8","PRO","29","8","8","Bagayi̱ batab̯ura rub̯uga, bei̱tu̱ bagezi̱ baleeta b̯u̱si̱nge. ");
INSERT INTO rub_vpl VALUES ("PR29_9","021_29_9","PRO","29","9","9","Mu̱gezi̱ watongona na mudoma, mudoma akwatwa ki̱ni̱ga kandi naaseka, bei̱tu̱ nab̯wo tihabbaho b̯u̱si̱nge. ");
INSERT INTO rub_vpl VALUES ("PR29_10","021_29_10","PRO","29","10","10","Bei̱ti̱ banoba muntu murungi, kandi ni̱bendya ku̱mwi̱ta. ");
INSERT INTO rub_vpl VALUES ("PR29_11","021_29_11","PRO","29","11","11","Mudoma yolookeerya ki̱mwei̱ ki̱ni̱ga kyamwe, bei̱tu̱ mu̱gezi̱ yeerinda naaki̱holereerya b̯u̱holya. ");
INSERT INTO rub_vpl VALUES ("PR29_12","021_29_12","PRO","29","12","12","Mu̱lemi̱ b̯u̱yetegeerya b̯u̱gobya, bayolo baamwe bensei̱ babba babiibi. ");
INSERT INTO rub_vpl VALUES ("PR29_13","021_29_13","PRO","29","13","13","Munaku na yogwo amuwonawonesya, bali na habarombi̱ra, bensei̱ Mukama yooyo abaha kwetegereza mananu. ");
INSERT INTO rub_vpl VALUES ("PR29_14","021_29_14","PRO","29","14","14","Kakubba mukama asala musangu gwa b̯ulyo hali banaku, b̯u̱lemi̱ b̯wamwe b̯ukusobora kwomeera. ");
INSERT INTO rub_vpl VALUES ("PR29_15","021_29_15","PRO","29","15","15","Kibboko na kuhab̯urwa bileeta magezi̱, bei̱tu̱ mwana gi̱balekereeri̱ aswaza mmaawe ");
INSERT INTO rub_vpl VALUES ("PR29_16","021_29_16","PRO","29","16","16","Bantu babiibi b̯ubalema, bibii nibyeyongera, bei̱tu̱ barungi baliwona ku̱zi̱ka kwab̯u. ");
INSERT INTO rub_vpl VALUES ("PR29_17","021_29_17","PRO","29","17","17","Wegesyanga mwana waamu ali̱ku̱hu̱mu̱u̱lya, kandi alikuha kusemererwa. ");
INSERT INTO rub_vpl VALUES ("PR29_18","021_29_18","PRO","29","18","18","Ihanga b̯ulitebemberwa Ruhanga tiliterekeera, wa mu̱gi̱sa yeerinda biragiro. ");
INSERT INTO rub_vpl VALUES ("PR29_19","021_29_19","PRO","29","19","19","Bigambu bisa tibisobora kulamba mwiru, kubba nab̯uyetegereza tasobora kutaho mutima. ");
INSERT INTO rub_vpl VALUES ("PR29_20","021_29_20","PRO","29","20","20","Mudoma bamu̱ni̱hi̱ramwo birungi kukira yangu̱hi̱ri̱i̱rya kubaza. ");
INSERT INTO rub_vpl VALUES ("PR29_21","021_29_21","PRO","29","21","21","Kakubba odedya mu̱kori̱ kuruga mu b̯uto, alikufookera kizib̯u. ");
INSERT INTO rub_vpl VALUES ("PR29_22","021_29_22","PRO","29","22","22","Wa ki̱ni̱ga abyokya izongobo, azingala b̯wangu akora bibiibi binene. ");
INSERT INTO rub_vpl VALUES ("PR29_23","021_29_23","PRO","29","23","23","Myehembu mileeta kuswara, bei̱tu̱ mweb̯u̱ndaazi̱ aheeb̯wa ki̱ti̱i̱ni̱sa. ");
INSERT INTO rub_vpl VALUES ("PR29_24","021_29_24","PRO","29","24","24","Akwatagana na mwi̱bi̱, annoba b̯womi, b̯ubamurahirisya mwicwero lya musangu, talinakyeramwo. ");
INSERT INTO rub_vpl VALUES ("PR29_25","021_29_25","PRO","29","25","25","Ku̱ti̱i̱na muntu kubba kwetega mutegu, bei̱tu̱ yeesiga Mukama alitunga b̯u̱si̱nge. ");
INSERT INTO rub_vpl VALUES ("PR29_26","021_29_26","PRO","29","26","26","Bantu banene bendya kwenolya hali balemi̱, bei̱tu̱ Mukama yooyo aleetaho b̯winganiza. ");
INSERT INTO rub_vpl VALUES ("PR29_27","021_29_27","PRO","29","27","27","Muntu murungi anoba mubiibi, na mubiibi naanoba murungi. ");
INSERT INTO rub_vpl VALUES ("PR30_1","021_30_1","PRO","30","1","1","Kuku kwokwo kubaza na kuwonekerwa kwʼAgu̱ru̱ mu̱tabani̱ wa Yaake. Muntu alimukuliriira Ruhanga nti, Njwahi̱ri̱! ");
INSERT INTO rub_vpl VALUES ("PR30_2","021_30_2","PRO","30","2","2","Mananu ndi mudoma, kandi tindi na magezi̱. ");
INSERT INTO rub_vpl VALUES ("PR30_3","021_30_3","PRO","30","3","3","Tinkatunganga magezi̱ rundi kwetegereza kwa Mutongoole ");
INSERT INTO rub_vpl VALUES ("PR30_4","021_30_4","PRO","30","4","4","Naani yaatembi̱ri̱ mwiguru akei̱ra akasi̱ri̱mu̱ka? Naani yaasorozi̱ri̱ mpehu akagikwatira mu ngalu? Naani yaakazi̱ngi̱ranga meezi̱ mu ngoye zaamwe? Naani yaakeganga nkangu gya nsi? Ibara lyamwe naani? Kandi lya mwana waamwe naani? Mbwera wakabba weegi̱ri̱! ");
INSERT INTO rub_vpl VALUES ("PR30_5","021_30_5","PRO","30","5","5","B̯uli kigambu kya Ruhanga kibba kya mananu, yooyo ngab̯u gya bab̯wo beebi̱si̱ra muli yo. ");
INSERT INTO rub_vpl VALUES ("PR30_6","021_30_6","PRO","30","6","6","Otali̱teeryangaho ku bigambu byamwe, akwi̱za kukucoomera akwete mu̱gobya. ");
INSERT INTO rub_vpl VALUES ("PR30_7","021_30_7","PRO","30","7","7","Ruhanga wange, ntakakwi̱ri̱ nkukusaba ompe bintu bibiri: ");
INSERT INTO rub_vpl VALUES ("PR30_8","021_30_8","PRO","30","8","8","Nfoora wamananu. Otandeka nkabba munaku, rundi mu̱gu̱u̱da hoi̱, ongabire bikummala. ");
INSERT INTO rub_vpl VALUES ("PR30_9","021_30_9","PRO","30","9","9","Kakubba mba na binene, nsobora kukwebeera nkakoba yati, “Mukama yooyo naani? Tinkumwetaaga,” aleke ntalibba munaku nkei̱ba, nkaswaza ibara lyamu, ai̱ Ruhanga wange. ");
INSERT INTO rub_vpl VALUES ("PR30_10","021_30_10","PRO","30","10","10","Otalibazanga kubiibi mu̱kori̱ hali mukama waamwe, alikukyena nowonawona. ");
INSERT INTO rub_vpl VALUES ("PR30_11","021_30_11","PRO","30","11","11","Haloho bantu bakyena babbaawaawu, kandi batendeerya karungi bamaawaawu. ");
INSERT INTO rub_vpl VALUES ("PR30_12","021_30_12","PRO","30","12","12","Haloho beewona nka barungi mu mei̱so gaab̯u, batalinaho, kandi babiibi nibalemwa kwezi̱ramwo bibii byab̯u. ");
INSERT INTO rub_vpl VALUES ("PR30_13","021_30_13","PRO","30","13","13","Haloho bantu beetwala kubba bahakyendi̱ hoi̱, nibeetwala kubba nibakukira b̯uli muntu. ");
INSERT INTO rub_vpl VALUES ("PR30_14","021_30_14","PRO","30","14","14","Haloho bantu ba meino gaab̯u geicala nka mpirima, na nsaya zaab̯u zibba nka nsone, kuhutaaza banaku na bali mub̯wetaagu. ");
INSERT INTO rub_vpl VALUES ("PR30_15","021_30_15","PRO","30","15","15","Mundidi guli na bahara babiri, beicala nibasaba yati, “Mpa! Mpa!” Heicalaho bintu bisatu biteicuta, binei bitakoba, “Ki̱ndoori̱,” byobyo: ");
INSERT INTO rub_vpl VALUES ("PR30_16","021_30_16","PRO","30","16","16","Kuzumu, nda gya mu̱kali̱ mugumba, nsi giicala nigirakiira meezi̱, na mworo tigukoba “Ki̱ndoori̱!” ");
INSERT INTO rub_vpl VALUES ("PR30_17","021_30_17","PRO","30","17","17","Muntu atetegeerya bbaawe akagaya na mmaawe, mei̱so gaamwe galisomwa bi̱nyoni̱, adiib̯we masega. ");
INSERT INTO rub_vpl VALUES ("PR30_18","021_30_18","PRO","30","18","18","Heicalaho bintu bisatu bimpuneeza hoi̱, binei bintetegereza: ");
INSERT INTO rub_vpl VALUES ("PR30_19","021_30_19","PRO","30","19","19","mu̱li̱ngo gwa wambooli̱ adu̱ndu̱u̱ki̱ra mu mwanya, mu̱li̱ngo gwa mpiri girabira ku lubbaali, mu̱li̱ngo gwa b̯wati̱ b̯ulibatira mwitaka, mu̱li̱ngo mudulu ali̱gi̱ramu muhala. ");
INSERT INTO rub_vpl VALUES ("PR30_20","021_30_20","PRO","30","20","20","Gigi gyogyo nkora gya mu̱kali̱ mwenzi̱: adya niyesusura mu̱nwa, naakoba, “Tindi na kibiibi ki̱nkoori̱.” ");
INSERT INTO rub_vpl VALUES ("PR30_21","021_30_21","PRO","30","21","21","Haloho bintu bisatu bi̱zi̱ngi̱i̱zya nsi, binei bigitasobora kugumisiriza, ");
INSERT INTO rub_vpl VALUES ("PR30_22","021_30_22","PRO","30","22","22","mwiru kufooka mukama, mudoma kubba na bidyo bikumala, ");
INSERT INTO rub_vpl VALUES ("PR30_23","021_30_23","PRO","30","23","23","mu̱kali̱ wa bikorwa bibiibi kutungwa, muzana kugweterwa makaa ga mu̱go waamwe. ");
INSERT INTO rub_vpl VALUES ("PR30_24","021_30_24","PRO","30","24","24","Bintu binei biicala bi̱dooli̱ ku nsi, bei̱tu̱ bya magezi̱ ganene: ");
INSERT INTO rub_vpl VALUES ("PR30_25","021_30_25","PRO","30","25","25","Nkakabi ziicala b̯u̱si̱i̱sa b̯u̱dooli̱, bei̱tu̱ weebikira bidyo bya kudya mu b̯wi̱re wa kyanda. ");
INSERT INTO rub_vpl VALUES ("PR30_26","021_30_26","PRO","30","26","26","Nsengi̱ giicala na maani gadooli̱, bei̱tu̱ gyebi̱mbi̱ra b̯wicalu mu lubbaali. ");
INSERT INTO rub_vpl VALUES ("PR30_27","021_30_27","PRO","30","27","27","Nzi̱ge tizigira mwebemberi̱, bei̱tu̱ zilibatira mu lukaara. ");
INSERT INTO rub_vpl VALUES ("PR30_28","021_30_28","PRO","30","28","28","Garagara mwangu kumukwatira mu ngalu, bei̱tu̱ omwagya mu kikaali. ");
INSERT INTO rub_vpl VALUES ("PR30_29","021_30_29","PRO","30","29","29","Haloho bintu bisatu bilibata nibyegonza, binei b̯ubibba nibikulibata bihambiriza kubiwonaho byobyo bibi: ");
INSERT INTO rub_vpl VALUES ("PR30_30","021_30_30","PRO","30","30","30","ntali kisolo kikirayo maani, tihaloho kintu ki̱gi̱ti̱ni̱si̱ri̱i̱rya, ");
INSERT INTO rub_vpl VALUES ("PR30_31","021_30_31","PRO","30","31","31","mpanga, mpaaya gya mbu̱li̱, na mukama wei̱he lyetoroori̱. ");
INSERT INTO rub_vpl VALUES ("PR30_32","021_30_32","PRO","30","32","32","B̯wobba oi̱ceeri̱ nookora bya b̯udoma, kandi notegeka kukora b̯ubiibi, weerinda kalimi kaamu. ");
INSERT INTO rub_vpl VALUES ("PR30_33","021_30_33","PRO","30","33","33","Wocunda mate harugamwo maku̱ta ga nte. Wokuuta muntu nni̱ndo harugamu ibbanga. Wotabbula ki̱ni̱ga, ogwa mu kabii. ");
INSERT INTO rub_vpl VALUES ("PR31_1","021_31_1","PRO","31","1","1","Bigambu bya Mukama Lameeri̱, mmaawe bi̱yaamwegeseerye. ");
INSERT INTO rub_vpl VALUES ("PR31_2","021_31_2","PRO","31","2","2","Kikyani kyolimukukora? Kikyani kyolimukukora mwana wa mu nda gyange? Kikyani kyolimukukora mwana wa kirahiro kyange? ");
INSERT INTO rub_vpl VALUES ("PR31_3","021_31_3","PRO","31","3","3","Otamalira maani gaamu hali bakali̱, bahwerekeereerya na bakama. ");
INSERT INTO rub_vpl VALUES ("PR31_4","021_31_4","PRO","31","4","4","Lameeri̱, weetegeerya. Ki̱doori̱ kwahi bakama kunywanga maaci, rundi balemi̱ kunywa binyweb̯wa bilulu. ");
INSERT INTO rub_vpl VALUES ("PR31_5","021_31_5","PRO","31","5","5","Kugunywa kukuha kwebeera b̯ujunanizib̯wa b̯wamu, na ku̱wonawonesya baseege. ");
INSERT INTO rub_vpl VALUES ("PR31_6","021_31_6","PRO","31","6","6","Maaci ganyweb̯wa bali heehi̱ ku̱kwa, na yogwo ali na b̯ujune b̯unene. ");
INSERT INTO rub_vpl VALUES ("PR31_7","021_31_7","PRO","31","7","7","Leka bagunywe bebeere nnaku zaab̯u, kandi bataliriira kwi̱zu̱ka kuwonawona kwab̯u. ");
INSERT INTO rub_vpl VALUES ("PR31_8","021_31_8","PRO","31","8","8","Baliziriranga bab̯wo batali na b̯ubalizo, olwaniriirenge bab̯wo batali na akubakonyera. ");
INSERT INTO rub_vpl VALUES ("PR31_9","021_31_9","PRO","31","9","9","Bazanga bya kulwaniira b̯winganiza, nolwaniira b̯ugabe b̯wa baseege na bali mu b̯wetaagu. ");
INSERT INTO rub_vpl VALUES ("PR31_10","021_31_10","PRO","31","10","10","Mu̱kali̱ wa ngesu zirungi naani asobora ku̱mwagya? Muhendu gwamwe gukira gwa mahi̱ga ga muhendu gunene. ");
INSERT INTO rub_vpl VALUES ("PR31_11","021_31_11","PRO","31","11","11","I̱baawe amwesiga kandi amugobamwo. ");
INSERT INTO rub_vpl VALUES ("PR31_12","021_31_12","PRO","31","12","12","Yogwo mu̱kali̱ mu b̯womi b̯wamwe b̯wensei̱, akolera i̱baawe birungi kandi tamutwala kubiibi. ");
INSERT INTO rub_vpl VALUES ("PR31_13","021_31_13","PRO","31","13","13","Atoolya byoza bya ntaama na pamba yaamikoramwo ngoye na kusemererwa. ");
INSERT INTO rub_vpl VALUES ("PR31_14","021_31_14","PRO","31","14","14","Ali nka b̯wati̱ wa basu̱b̯u̱ri̱ kandi aleeta bidyo byamwe kuruga hadei. ");
INSERT INTO rub_vpl VALUES ("PR31_15","021_31_15","PRO","31","15","15","Abyoka b̯u̱takakeeri̱, naategekera ba mu nnyu̱mba gyamwe bya kudya, kandi ni̱yolookeerya bahala bakori̱ baamwe kyakukora. ");
INSERT INTO rub_vpl VALUES ("PR31_16","021_31_16","PRO","31","16","16","B̯u̱yaagya musiri, agugula, naakoresya nsimbi zaamwe yankei naagusimbamwo mi̱zabbi̱bbu̱. ");
INSERT INTO rub_vpl VALUES ("PR31_17","021_31_17","PRO","31","17","17","Yeekamba kukora na maani kandi na mikono myamwe miicala minyamaani ku b̯ujunanizib̯wa b̯wamwe. ");
INSERT INTO rub_vpl VALUES ("PR31_18","021_31_18","PRO","31","18","18","Yeetegereza mugasu gwa bintu bya kukora, naacwamwo kukora i̱jolo acu̱mu̱ki̱ri̱ taara gyamwe. ");
INSERT INTO rub_vpl VALUES ("PR31_19","021_31_19","PRO","31","19","19","Yongosa mahu̱u̱zi̱ gaamwe yankei na lukamwona ngoye. ");
INSERT INTO rub_vpl VALUES ("PR31_20","021_31_20","PRO","31","20","20","Abba na kisa mu ku̱konyera baseege, na bali mu b̯wetaagu. ");
INSERT INTO rub_vpl VALUES ("PR31_21","021_31_21","PRO","31","21","21","Kadi b̯wi̱re b̯wi̱nyami̱ri̱, tati̱i̱na hab̯wakubba ba mu nnyu̱mba gyamwe abalwalya ngoye zi̱tagatu̱. ");
INSERT INTO rub_vpl VALUES ("PR31_22","021_31_22","PRO","31","22","22","Yeekolera suuka kandi nalwala ngoye zi̱di̱ zi̱ku̱nyi̱ri̱ra na zi̱ku̱serya. ");
INSERT INTO rub_vpl VALUES ("PR31_23","021_31_23","PRO","31","23","23","I̱baawe aheeb̯wa ki̱ti̱i̱ni̱sa mu rub̯uga, na mu bataahi̱ baamwe. ");
INSERT INTO rub_vpl VALUES ("PR31_24","021_31_24","PRO","31","24","24","Mu̱kali̱ yogwo asu̱nga ngoye na miheeko, naazi̱tu̱ndu̱sya basu̱b̯u̱ri̱. ");
INSERT INTO rub_vpl VALUES ("PR31_25","021_31_25","PRO","31","25","25","Abba wa maani kandi wa ki̱ti̱i̱ni̱sa ataku̱ti̱i̱na ki̱kwi̱za kubbaho. ");
INSERT INTO rub_vpl VALUES ("PR31_26","021_31_26","PRO","31","26","26","Abaza bya magezi̱, Yeegesya na mbabazi̱. ");
INSERT INTO rub_vpl VALUES ("PR31_27","021_31_27","PRO","31","27","27","Alingiira ba mu nnyu̱mba gyamwe, kandi tadya byatakolereeri̱. ");
INSERT INTO rub_vpl VALUES ("PR31_28","021_31_28","PRO","31","28","28","Baana baamwe bamweta wa mu̱gi̱sa, kandi i̱ba eicala naamu̱haari̱i̱za. ");
INSERT INTO rub_vpl VALUES ("PR31_29","021_31_29","PRO","31","29","29","Bakali̱ banene barungi, bei̱tu̱ we okira bensei̱. ");
INSERT INTO rub_vpl VALUES ("PR31_30","021_31_30","PRO","31","30","30","Kwegomba mubiri gwa mu̱kali̱ ku̱gobya b̯u̱gobya, bei̱tu̱ mu̱kali̱ aku̱ti̱i̱na Mukama Ruhanga ali̱si̱i̱mwa. ");
INSERT INTO rub_vpl VALUES ("PR31_31","021_31_31","PRO","31","31","31","Mumuhe byakolereeri̱, kandi milimo myamwe mi̱mu̱haari̱i̱zi̱sye mu bantu banene.");
INSERT INTO rub_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Kiro ki̱mwei̱, Mukama yaaweereeri̱ Yona mu̱tabani̱ wʼAmitaayi ");
INSERT INTO rub_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","yati, “Byokya ogyende mu lu̱lwo rub̯uga lukooto lwetwa Ni̱neeva, orangire bantu baamwona nti, ‘Ncwi̱ri̱mwo ku̱bahwerekereerya, kubba nyeetegeri̱i̱ze nka kubali na bibiibi binene.’ ” ");
INSERT INTO rub_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Bei̱tu̱ yo Yona, yaabyokeerye yaakwata muhanda gundi gwa kwi̱ru̱ki̱ra Tarasi̱i̱si̱, aleke aruge hali Mukama; yaasi̱ri̱mu̱ka Yopa, hayaagi̱i̱rye b̯wati̱ b̯ukooto bukugyenda Tarasi̱i̱si̱. Yaasasula sente zaa b̯wati̱ kumutwala, yaabutemba, agyende Tarasi̱i̱si̱ na banyakubbamwona, aruge hali Mukama. ");
INSERT INTO rub_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Bei̱tu̱ b̯ubaali nibakugyenda, Mukama yaaleeti̱ri̱ bbuukuulu munene hoi̱ mwitaka; haabbamu bijanga byakalasanu̱ b̯ukooto, binyakubba nibili heehi̱ kwata b̯wati̱. ");
INSERT INTO rub_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Ki̱kyo, kyati̱ni̱si̱i̱rye hoi̱ bakori̱ ba mu b̯wati̱. B̯uli omwei̱ yaatandika kwesengereerya kihala kya kwamwabu kibajune kizubu kibaalingimu; baaguma migugu minyakubba mu b̯wati̱, mwitaka, aleke b̯wati̱ buhuhe. Bei̱tu̱ Yona yo, yaali amaari̱ ku̱si̱ri̱mu̱ka kwansi mu b̯wati̱, aleeri̱ kandi yeebbaki̱i̱ri̱ ki̱mwei̱. ");
INSERT INTO rub_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Mwomwo mu̱handu̱ wa b̯wati̱ yaamugyendera yaamu̱bu̱u̱lya, “We, osobora teetei̱ kwebbaka? Byoka olaame hali kihala kya kwamwenyu̱, kisobora ku̱twetegeerya, aleke tutahwerekeera.” ");
INSERT INTO rub_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Kasi bakori̱ baaweerangana, “Tu̱cu̱u̱hye, aleke twege mu twe muntu atu̱gu̱mi̱ri̱ mu kizubu kiki.” Baacu̱u̱hya, baagya nali Yona. ");
INSERT INTO rub_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Mwomwo baamu̱b̯u̱u̱lya, “Tu̱weere, naani aleteereerye kiki kizubu? Okora mulimo ki? Oruga hai? Oruga mwihanga ki? Oli muki?” ");
INSERT INTO rub_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Yona yaabei̱ramu yati, “Ndi Mu̱hebbu̱rana, ndamya Mukama, Ruhanga wa mwiguru, munyakuhanga nsi neitaka.” ");
INSERT INTO rub_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Yona yeeyongera kubaweera, “Nkwi̱ru̱ka kuruga hali Mukama.” Habwaki̱kyo, badulu baati̱i̱ni̱ri̱ hoi̱ hoi̱, kandi baamu̱b̯u̱u̱lya, “Kiki kyani kyokoori̱?” ");
INSERT INTO rub_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","B̯u̱b̯wonu, bbuukuulu na bijanga, byeyongerengi̱-bweyongeri̱. Habwaki̱kyo, bakori̱ baabu̱u̱lya Yona, “Kyani twe, kitwakukola, kyaleetera i̱taka kwema?” ");
INSERT INTO rub_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Yona yaabei̱ramu yati, “Mu̱nsenge mungume mwitaka; li̱kwi̱za kwema. Kubba nyeegi̱ri̱ yogo bbuukuulu hamwenya na bijanga, bi̱i̱zi̱ri̱ hab̯wa nsobi̱ gyange.” ");
INSERT INTO rub_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Bei̱tu̱ bo, baalwani̱si̱i̱rye kugoza magyenda ku mutanda. Kyonkei, batakasobore hab̯wakubba bbuukuulu na bijanga byeyongerengi̱-bweyongeri̱ kwakalasani̱a. ");
INSERT INTO rub_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Habwaki̱kyo, bakori̱ beesengereerye Mukama nibakoba yati, “Beiraba Mukama, otatwi̱ta hab̯wa yogo mudulu; kandi otatujunaana hab̯wa ku̱mwi̱ti̱ra b̯usa, hab̯wakubba we Mukama weewe oki̱koori̱ nka ku̱wendeerye.” ");
INSERT INTO rub_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Mwomwo baasenga Yona, baamuguma mwitaka; lyema. ");
INSERT INTO rub_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Kiki kyabaleeteeri̱ ku̱ti̱i̱na hoi̱ Mukama, na kumusaara kyonzira, kandi, beeragani̱sya kumukooranga. ");
INSERT INTO rub_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Bu̱baagu̱mi̱ri̱ Yona mwitaka, Mukama yaasi̱ndi̱ki̱ri̱ nsu̱ gikooto gyamumera. Yona yaamaari̱ mu nda gya nsu̱, minsi misatu na majolo gasatu. ");
INSERT INTO rub_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Yona b̯uyaali mu nda gya nsu̱, yaasabi̱ri̱ Mukama Ruhanga waamwe ");
INSERT INTO rub_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","nakoba yati, “Bunyaali mu kizubu kyange, nyaataagi̱i̱ri̱ Mukama, kandi yankoonyera. Hakati̱ wa ki̱i̱na kya rufu, nyaalu̱ki̱ri̱ ninkusaba onkoonyere, waanyeetegeerya. ");
INSERT INTO rub_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Wanju̱gu̱nyi̱ri̱ hakati̱ weitaka, mali̱, mu ndiha gyeitaka, mu̱hwi̱ gwa meezi̱ gwanyeelogoleerya, na bijanga byamu byensei̱, byandaba hakyendi̱. ");
INSERT INTO rub_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Kandi nyaateekeri̱i̱ze, ‘Mbi̱ngi̱i̱rwe kuruga mu mei̱so gaamu; mali̱, ndi̱bu̱ni̱a mbone Yeekaru, Nyu̱mba gyamu gi̱tongoole.’ ");
INSERT INTO rub_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Meezi̱ gaanyeelogoleerye, heehi̱ ku̱nzi̱ta; ndiha gyamereeri̱ ki̱mwei̱, na bisubi bya mwitaka byanyeelyobi̱ri̱ ku mu̱twe. ");
INSERT INTO rub_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Nyaagi̱zi̱i̱ri̱ nyaadwa hansi wa nsau zaa mwitaka, mu nsi gya baku̱u̱ ha nzi̱je zaagyo zanki̱ngi̱reeni̱ biro na biro. Bei̱tu̱ we Mukama Ruhanga wange, waaju̱ni̱ri̱ b̯womi bwange nobutoola mu ki̱i̱na. ");
INSERT INTO rub_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Bunyaali nindi heehi̱ kukaba, nyei̱zu̱ki̱ri̱ we Mukama, kandi nawe, weegwa kusaba kwange, noli mu Yeekaru, Nyu̱mba gyamu gi̱tongoole. ");
INSERT INTO rub_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Babwo bahaamiira ku̱ramya bi̱si̱sani̱ bitali na mugasu, beefeereza mbabazi̱ zaaku̱bbeeri̱ zaab̯u. ");
INSERT INTO rub_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Bei̱tu̱ gya, nkwi̱za kukuhongera kyonzira ni̱nku̱ku̱hi̱i̱mi̱ra kyembu kya ku̱ku̱si̱i̱ma. Nkwi̱za kukora kiki ki̱nyeeragani̱si̱i̱rye, kujunwa kuruga hali Mukama.” ");
INSERT INTO rub_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Mwomwo Mukama yaaragi̱ra nsu̱, gyatunaka Yona ku mutanda. ");
INSERT INTO rub_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Mukama yaabu̱ni̱a yaaweera Yona, ");
INSERT INTO rub_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“Byokya ogyende mu rub̯uga lukooto lwa Ni̱neeva, orangire bantu baamwona, b̯ukwenda bunkuheeri.” ");
INSERT INTO rub_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Mwomwo Yona yaakora nka Mukama kuyaali amu̱weereeri̱, yaagyenda Ni̱neeva. Ni̱neeva, lwali rub̯uga lukooto, lukutwala biro bisatu kululibata okalurabamu. ");
INSERT INTO rub_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Yona yeingira mu rub̯uga hab̯wa kiro ki̱mwei̱, narangiranga bantu baamwona yati, “Hasi̱geeri̱yo biro maku̱mi̱ ganei, rub̯uga lwa Ni̱neeva luhwerekerezebwe.” ");
INSERT INTO rub_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Bantu baa Ni̱neeva bei̱ki̱ri̱i̱ze b̯ukwenda bu̱ru̱gi̱ri̱ hali Ruhanga; baarangiira kisiibo. Bantu bensei̱, kurugiira ki̱mwei̱ hali mu̱handu̱ waab̯u kudwera ki̱mwei̱ hali akusembayo, baalwala maku̱ti̱ya, kwolokya nti baali ni̱bakwezi̱ramwo. ");
INSERT INTO rub_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","B̯ukwenda b̯ub̯u bu̱bwadwerereeri̱ mukama wa Ni̱neeva, yaabyoki̱ri̱ yaaruga ha ntebe gyamwe gya b̯ukama; yaasomolamwo bilwalu byamwe bya b̯ukama, yaalwala maku̱ti̱ya, kandi yeicaara mwi̱syanu̱. ");
INSERT INTO rub_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Mukama yaarangiira kiragiro mu Ni̱neeva gyensei̱: “Kiki kyokyo kiragiro kyange, gya mukama hamwenya na bahandu̱ bampondera, kinkuragira: “Hatabbaho muntu yensei̱, rundi kisolo, kudya kantu kensei̱. Nabugyabba nte, rundi mbu̱li̱, gitadya kandi gitanywa kantu kensei̱. ");
INSERT INTO rub_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Bei̱tu̱ b̯uli muntu, akuragirwa kulwala maku̱ti̱ya; kandi na b̯uli kisolo baki̱lwalye maku̱ti̱ya. B̯uli muntu akuteekwa kwesengereerya Ruhanga na maani hoi̱; kandi akuragirwa kuleka bikorwa byamwe bibiibi na bu̱kabbu̱ru̱ b̯wamwe. ");
INSERT INTO rub_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Naani yeegi̱ri̱? Ruhanga asobora kuhindula ncwamu gyamwe, natugiira mbabazi̱, naleka kukwatwa ki̱ni̱ga, nabula ku̱tu̱hwerekereerya.” ");
INSERT INTO rub_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Ruhanga b̯u̱yaaweeni̱ bi̱baakoori̱, kandi beezi̱ri̱ri̱mwo bikorwa byab̯u bibiibi, yaabakwatirwa mbabazi̱ yaabula kubafubira nka kuyaali akobi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Ruhanga butafubira bantu baa Ni̱neeva, kyasaali̱i̱ze hoi̱ Yona, yaakwatwa ki̱ni̱ga. ");
INSERT INTO rub_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Yaasaba nakuuduumira Mukama, nakoba yati, “Tikyokyo nyaakobi̱ri̱ nincakali mu nsi gya kwamwetu̱? Kiki kyokyo kinyakubba ki̱mpeeri̱ kwi̱ru̱ki̱ra Tarasi̱i̱si̱. Nyeegi̱ri̱ nka kwoli Ruhanga alumirwa bantu kandi nobagiira mbabazi̱; ataranguha kukwatwa ki̱ni̱ga kandi ei̱zwi̱ri̱ ngonzi, aleka kuleeta kabii. ");
INSERT INTO rub_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Nku̱kwesengereerya Mukama, leka nkwe; kubba gya ku̱kwa, kikunkiira kubba mwomi.” ");
INSERT INTO rub_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Mwomwo Mukama yaamu̱bu̱u̱lya, “Kikudwa we kukwatwa ki̱ni̱ga?” ");
INSERT INTO rub_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Yona yo, yaaruga mu rub̯uga lu̱lwo, yaagyenda buhuluka lyoba wa lwo, yeicaara. Ku̱kwo, Yona yeebi̱mbi̱i̱ri̱yo kasi̱i̱si̱ra, yeicaara mu mu̱tu̱ntu̱lu̱ gwako ali̱ndi̱ri̱ kuwona kyani kyabbaho ha rub̯uga lwa Ni̱neeva. ");
INSERT INTO rub_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Mukama Ruhanga, yaateereeri̱ho Yona kimera kikulanda. Kyahanda kyadwa hakyendi̱ waamwe kumuleetera mu̱tu̱ntu̱lu̱ ku mu̱twe gwamwe, aleke yeezegwe nali kurungi. Mwomwo Yona yaasemereerwa hoi̱ hab̯wa kimera ki̱kyo. ");
INSERT INTO rub_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Bei̱tu̱ mwakya gunyakuhonderaho, Ruhanga yaaragi̱i̱ri̱ ki̱si̱i̱sa kyadya kimera ki̱kyo, ku̱doosya bu̱kyomi̱ri̱. ");
INSERT INTO rub_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Lyoba bu̱lyasu̱u̱ki̱ri̱, Ruhanga yaaragi̱ra mpehu gihyo gya buhuluka lyoba gihunge magyenda hali Yona. Lyoba lyokya Yona ku mu̱twe, ku̱doosya bu̱yaagwerekereeri̱ kandi yeesabira ku̱kwa, nakoba yati, “Gya kubba mwomi, hakiri nkwa.” ");
INSERT INTO rub_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Mwomwo Ruhanga yaab̯u̱u̱lya Yona, “Mali̱, kikudwa we kuzingala, hab̯wa ki̱kyo kimera kwoma?” Yona yei̱ramu, “Mali̱ kikudwa gya kuzingala. Ki̱ni̱ga ki̱nzakalaseeni̱, nyaakendya kadi nkwe.” ");
INSERT INTO rub_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Mwomwo Mukama yaakoba, “Okurumirirwa kimera kwoma, we kyotakolereeri̱, kandi kyotasi̱mbi̱ri̱, kinyakuhanda mu kiro ki̱mwei̱ kandi kyahwerekeera mu kiro ki̱mwei̱. ");
INSERT INTO rub_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Bei̱tu̱ gya, hab̯waki ntarumirirwa kuhwerekeera kwa rub̯uga lwa Ni̱neeva lulimwo baana batali na ki̱beegi̱ri̱, bakukira ha mitwaru i̱ku̱mi̱ na mibiri hamwenya na bisolo binene?” Yona yaagi̱i̱rye b̯wati̱ b̯ukooto bukugyenda Tarasi̱i̱si̱ (1:3) Ruhanga, yaateereeri̱ho Yona kimera kikulanda (4:6) “Gya kubba mwomi, hakiri nkwa.” (4:8)");
INSERT INTO rub_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","B̯ubyalwa b̯wa Yesu̱ Ku̱ri̱si̱to, wa mulula lwa Mukama Dau̱di̱, kandi wa mulula lwʼI̱bbu̱rahi̱mu̱, b̯walingi yati: ");
INSERT INTO rub_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","I̱bbu̱rahi̱mu̱ yaabyeri̱ I̱saka, I̱saka yaabyala Yakobbo, Yakobbo yaabyala Yu̱da na bei̱ra baamwe. ");
INSERT INTO rub_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yu̱da yaabyeri̱ Pereezi̱ na Zeera, maawaab̯u naali Tamali̱, Pereezi̱ yaabyala Hezi̱rooni̱, Hezi̱rooni̱ yaabyala Ramu. ");
INSERT INTO rub_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ramu yaabyeri̱ Aminadaabbu, Aminadaabbu yaabyala Nahasooni̱, Nahasooni̱ yaabyala Salu̱mooni̱. ");
INSERT INTO rub_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salu̱mooni̱ yaabyeri̱ Bbowaazi, maa yogo Bbowaazi naali Rahabbu̱, Bbowaazi yaabyeri̱ Obbeedi̱, maa Obbeedi̱ naali Ru̱u̱si̱, Obbeedi̱ yaabyeri̱ Yese, ");
INSERT INTO rub_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yese yaabyala Dau̱di̱, mukama. Dau̱di̱ yaabyeri̱ Sulumaani, na yogwo mu̱kali̱ munyakubba muka U̱ri̱ya. ");
INSERT INTO rub_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sulumaani yaabyala Rehobbowaamu, Rehobbowaamu yaabyala Abbi̱ya, Abbi̱ya yaabyala Asa. ");
INSERT INTO rub_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa yaabyeri̱ Yehosafaati, Yehosafaati yaabyala Yolaamu, Yolaamu yaabyala U̱zi̱ya. ");
INSERT INTO rub_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","U̱zi̱ya yaabyeri̱ Yosaamu, Yosaamu yaabyala Ahaazi̱, Ahaazi̱ yaabyala Heezeki̱ya. ");
INSERT INTO rub_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Heezeki̱ya yaabyeri̱ Manaase, Manaase yaabyala Amoni̱, Amoni̱ yaabyala Yosi̱ya. ");
INSERT INTO rub_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosi̱ya yaabyeri̱ Yekoni̱ya na bei̱ra baamwe, mu biro bi̱baanyagi̱i̱rwemwo kutwalwa Bbabbu̱looni̱. ");
INSERT INTO rub_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","B̯u̱baamaari̱ kutwalwa Bbabbu̱looni̱, Yekoni̱ya yaabyeri̱ Salatyeri̱, Salatyeri̱ yaabyala Zeru̱bbabbeeri̱. ");
INSERT INTO rub_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zeru̱bbabbeeri̱ yaabyeri̱ Abbi̱yu̱u̱di̱, Abbi̱yu̱u̱di̱ yaabyala Eri̱yaki̱mu̱, Eri̱yaki̱mu̱ yaabyala Azoori̱. ");
INSERT INTO rub_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azoori̱ yaabyeri̱ Zadoki̱, Zadoki̱ yaabyala Aki̱i̱mu̱, Aki̱i̱mu̱ yaabyala Eli̱yu̱di̱. ");
INSERT INTO rub_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eli̱yu̱di̱ yaabyeri̱ Eryeza, Eryeza yaabyala Mataani̱, Mataani̱ yaabyala Yakobbo. ");
INSERT INTO rub_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakobbo yogwo, yooyo munyakubyala Yozefu̱ i̱ba Mali̱ya, Mali̱ya munyakubyala Yesu̱, Yesu̱ yogwo yeetwa Ku̱ri̱si̱to. ");
INSERT INTO rub_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Nahab̯waki̱kyo kuruga hali I̱bbu̱rahi̱mu̱ kudwa hali Mukama Dau̱di̱, haalingiho mi̱hi̱hi̱ mya beizukulu i̱ku̱mi̱ na minei; na kuruga hali Mukama Dau̱di̱ kudwa ha Banyei̱saleeri̱ kutwalwa Bbabbu̱looni̱, nahoodede haalingiho mi̱hi̱hi̱ i̱ku̱mi̱ na minei. Kandi de, na kuruga ha kutwalwa Bbabbu̱looni̱ kudwa ha kubyalwa kwa Ku̱ri̱si̱to, naho haalingiho mi̱hi̱hi̱ i̱ku̱mi̱ na minei. ");
INSERT INTO rub_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Bigambu bya kubyalwa kwa Yesu̱ Ku̱ri̱si̱to byalingi yati: Maawe Mali̱ya, b̯uyaali atakamu̱byeri̱, naali ali̱ndi̱ri̱i̱ri̱ kugab̯uka wu Yozefu̱, kandi b̯u̱b̯wo de, atakawonangaho ku mudulu, kyazooki̱ri̱ nti yaalingi naali na nda hab̯wa Mwozo Mu̱syanu̱. ");
INSERT INTO rub_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Hab̯wakubba Yozefu̱, munyakubba naakugyenda kumugab̯ura, yaali mudulu akubalwa kubba naaku̱si̱i̱mwa mu mei̱so ga Ruhanga, yaacwi̱ri̱mwo kuleka Mali̱ya mu ki̱cei̱cei̱, mwa b̯utahemura Mali̱ya. ");
INSERT INTO rub_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","B̯uyaali naacaateekereza bi̱byo, malayika wa Mukama Ruhanga yaamu̱wonekeeri̱ mu kilooto naakoba, “Yozefu̱, mwizukulu wa Dau̱di̱, otati̱i̱na kugab̯ura Mali̱ya kubba mu̱kali̱ waamu, hab̯wakubba nda gyali nagyo, gili hab̯wa Mwozo Mu̱syanu̱. ");
INSERT INTO rub_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Alibyala mwana wa b̯udulu, kandi olina kumweta ibara Yesu̱, hab̯wakubba yooyo alijuna bantu baamwe kifubiro kya bibii byab̯u.” ");
INSERT INTO rub_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","B̯u̱b̯wo nu, bi̱byo byensei̱ byabbeeri̱ho, aleke bi̱doosereerye bigambu bya Mukama bi̱yaakobi̱ri̱ kuraba mu mu̱ragu̱ri̱ waamwe nti: ");
INSERT INTO rub_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Muhala atakawonangaho ku mudulu alibba na nda, abyale mwana wa b̯udulu, kandi balimweta ibara Manweri̱.” Makuru gaalyo: “Ruhanga ali natwe.” ");
INSERT INTO rub_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yozefu̱ b̯u̱yaasi̱si̱mu̱ki̱ri̱, yaakora kya malayika wa Mukama Ruhanga ki̱yaamu̱weereeri̱ kukora, yaagab̯ura Mali̱ya; ");
INSERT INTO rub_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","bei̱tu̱ kandi, atakateerane nayo, atakabyeri̱ yogwo mwana wa b̯udulu. Yozefu̱ yeeti̱ri̱ yogwo mwana ibara, Yesu̱. ");
INSERT INTO rub_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu̱ b̯u̱yaabyali̱i̱rwe mu rub̯uga Bbeterehemu̱ lwa mu kicweka kyetwa B̯uyudaaya, Herodi̱ naali mukama, badulu banyamagezi̱ baaru̱gi̱ri̱ b̯uhulukalyoba, bei̱za mu rub̯uga Yeru̱salemu̱, ");
INSERT INTO rub_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","baab̯u̱u̱lya yati: “Mwana akugyenda kubba Mukama wa Bayudaaya, abyali̱i̱rwe hanya? Twaweeni̱ luzota lu̱kwolokya nka kwabyali̱i̱rwe, niluhuluka kuruga b̯uhulukalyoba; kandi hataati̱, twi̱zi̱ri̱ ku̱mu̱ramya.” ");
INSERT INTO rub_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mukama Herodi̱ b̯u̱yeegwi̱ri̱ bigambu bya bab̯wo badulu bi̱baabazi̱ri̱, yeelalikiira hoi̱; na bantu banene ba mu Yeru̱salemu̱, nabo beelalikiira nka yo. ");
INSERT INTO rub_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Mwomwo yeeta bahandu̱ ba balaami̱ bensei̱ na beegesa ba biragiro, yaabab̯u̱u̱lya bamuweere ha Ku̱ri̱si̱to yaali naakugyenda kubyalirwa. ");
INSERT INTO rub_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Baamwi̱ri̱ri̱mwo nibakoba, “Mu rub̯uga Bbeterehemu̱ lwa B̯uyudaaya; kubba mu Binyakuhandiikwa, mu̱ragu̱ri̱ wa Ruhanga kwokwo yaakobi̱ri̱: ");
INSERT INTO rub_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“ ‘Nywe bantu ba Bbeterehemu̱ gya B̯uyudaaya muli lu̱mwei̱ ha mbuga zi̱handu̱ hoi̱ za B̯uyudaaya, hab̯wakubba omwei̱ muli nywe yooyo alibba mu̱lemi̱, alilema bantu bange Bei̱saleeri̱.’ ” ");
INSERT INTO rub_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Mwomwo Herodi̱ yeeta bab̯wo badulu bei̱ze mu nsita bamuwone; b̯u̱bei̱zi̱ri̱, yaabab̯u̱u̱lya bamu̱manyi̱sye kasu̱mi̱ koonyi̱ni̱ kabaawoneerimwo lu̱lwo luzota. ");
INSERT INTO rub_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","B̯u̱yaamaari̱ kubaza nabo, yaabatuma Bbeterehemu̱ naakoba, “Mu̱gyende mu̱toolye hoi̱ mwana yogwo, b̯umwakamwagya, mwi̱ze mu̱mmanyi̱sye, aleke nagya de ngyende mmu̱ramye.” ");
INSERT INTO rub_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","B̯u̱baamaari̱ kwegwa bya mukama bi̱yaabaragi̱i̱ri̱, baagyenda. B̯ubaali nibakugyenda, baaweeni̱ luzota lu̱di̱ lubaali baweeni̱, nagwa b̯uhulukalyoba. B̯u̱baalu̱weeni̱, baasemererwa hoi̱; lwabeebembera ku̱doosya b̯u̱lwemereeri̱ hali yogwo Mwana yaalingi. ");
INSERT INTO rub_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","B̯u̱bei̱ngi̱i̱ri̱ mu nnyu̱mba, baaweeni̱ yogwo Mwana na maawe Mali̱ya, baaku̱nda malu̱ beetu̱lu̱ka, baaramya Mwana. B̯u̱baamaari̱ ku̱mu̱ramya, baahula nsahu zaab̯u za bisembu bya zaabbu, bya b̯ubbaani, na bya bintu bi̱ku̱wu̱nya kurungi byetwa migaaju, baabimuha. ");
INSERT INTO rub_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ruhanga b̯u̱yaahab̯wi̱ri̱ bab̯wo badulu mu kilooto, batei̱ra hali Herodi̱, baatwali̱i̱rwe muhanda gundi ni̱baku̱ku̱bayo mwihanga lyab̯u. ");
INSERT INTO rub_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Banyamagezi̱ b̯u̱baamaari̱ kugyenda, malayika wa Mukama Ruhanga yaawonekera Yozefu̱ mu kilooto, naakoba, “Byoka, otwale mwana na maawe, mwezi̱be mwi̱ru̱ki̱re mwihanga lya Mi̱si̱ri̱, mwi̱caleyo ku̱doosya b̯undikuweera; hab̯wakubba Herodi̱ akugyenda ku̱toolya mwana yogwo mwa ku̱mwi̱ta.” ");
INSERT INTO rub_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Mwomwo Yozefu̱ yaabyoka i̱jolo lyolyo lyonyini, yaatwala mwana na maa mwana mwihanga lya Mi̱si̱ri̱. ");
INSERT INTO rub_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Bei̱ceeri̱yo ku̱doosya Herodi̱ b̯u̱yaakwi̱ri̱; aleke hei̱nyu̱ma, kuruga kwab̯u mu Mi̱si̱ri̱ habaagyendi̱ri̱, ku̱doosereerye bigambu bya Mukama Ruhanga biyaali aheeri̱ mu̱ragu̱ri̱ waamwe Hoseya, bikukoba nti: “Nyeeti̱ri̱ mwana wange aruge Mi̱si̱ri̱.” ");
INSERT INTO rub_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herodi̱ b̯u̱yeetegeri̱i̱ze badulu banyamagezi̱ nka kubaali baamu̱gobeerye, yaakwati̱i̱rwe ki̱ni̱ga kinene hoi̱. Ki̱yaakoori̱, yaaragi̱i̱ri̱ bei̱ta baana ba b̯udulu bensei̱, banyakubba nibali mu rub̯uga Bbeterehemu̱ na mu byaru bi̱hereeri̱ho, bab̯wo banyakubba nibali na myaka mibiri kwi̱ra ha nsi. Yo kuragira bei̱te baana ba myaka mi̱myo, yaasi̱gi̱ki̱i̱ri̱ ha kasu̱mi̱ ka banyamagezi̱, kabaamu̱wereeri̱ baawoneeri̱ho luzota. ");
INSERT INTO rub_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Mu mu̱li̱ngo gugu, kya Herodi̱ kwi̱ta bab̯wo baana, kyadoosereerye bigambu bya mu̱ragu̱ri̱ wa Ruhanga Yeremi̱ya, bi̱yaaragwi̱ri̱ naakoba, ");
INSERT INTO rub_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Haabbeeri̱ho iraka mu rub̯uga Rama, iraka li̱lyo kyali kizabiro, Lakeeri̱ yaali kuliriira baana baamwe, atakwendya baamu̱hu̱u̱mu̱u̱lye, hab̯wakubba bakwi̱ri̱ bamali̱ki̱ri̱ho.” ");
INSERT INTO rub_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herodi̱ b̯u̱yaakwi̱ri̱, malayika wa Mukama Ruhanga yaawonekera Yozefu̱ mu kilooto naali Mi̱si̱ri̱, ");
INSERT INTO rub_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","naakoba, “Byoka, otwale mwana na maawe, mwi̱re mu nsi gyʼI̱saleeri̱; hab̯wakubba bab̯wo banyaku̱toolyanga kwi̱ta yogwo mwana Yesu̱, bakwi̱ri̱.” ");
INSERT INTO rub_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Nahab̯waki̱kyo Yozefu̱ yaabyoki̱ri̱, yaatwala mwana na maawe, baaku̱bayo mu nsi gyʼI̱saleeri̱. ");
INSERT INTO rub_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Bei̱tu̱ Yozefu̱ yaati̱i̱ni̱ri kwi̱ra mwisaza lya B̯uyudaaya hab̯wakubba yaalingi yeegwi̱ri̱ nti Akileewo yaali naakulema mu kiikaru kya bbaawe Herodi̱. Ruhanga amaari̱ kuhab̯ura Yozefu̱ mu kilooto, Yozefu̱ yaaru̱gi̱ri̱yo yaagyenda mwisaza lya Galilaaya. ");
INSERT INTO rub_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Yaagyendi̱ri̱ yeicala mu rub̯uga lwetwa Nazareeti̱, aleke kigambu kya baragu̱ri̱ ba Ruhanga ki̱baaragwi̱ri̱ hali Ku̱ri̱si̱to ki̱dwereere, ki̱kyo kikoba nti: “Alyetwa Mu̱nazareeti̱.” ");
INSERT INTO rub_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Hei̱nyu̱ma gya kasu̱mi̱ kanene, hei̱zi̱ri̱ mudulu gi̱beetengi̱ Yohaana Mu̱bati̱zi̱, yaatandika ku̱tebeerya bantu mwirungu lya B̯uyudaaya, ");
INSERT INTO rub_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","naakoba, “Mwezi̱remwo bibiibi byenyu̱, hab̯wakubba b̯ukama b̯wa mwiguru b̯uli heehi̱ kudwa.” ");
INSERT INTO rub_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yohaana Mu̱bati̱zi̱ yooyo wa mu̱ragu̱ri̱ wa Ruhanga I̱saaya gi̱yaakobi̱ri̱ho yati: “Iraka lya yogwo akwamiira mwirungu naakoba, ‘Mu̱teekani̱ze muhanda gwa Mukama, mu̱terekereerye b̯uhanda b̯wamwe.’ ” ");
INSERT INTO rub_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohaana yogwo yaalwalengi̱ kilwalu kikore kuruga mu byoza bya ngamira, naalwala muheeku gwa kikuta mu mancwendu. Bidyo byamwe byali nzi̱ge na b̯uhooki b̯wa mwirungu. ");
INSERT INTO rub_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Bantu baaru̱gengi̱ Yeru̱salemu̱ na mu bicweka bi̱si̱geeri̱ho bya B̯uyudaaya gyensei̱, na mu bicweka bi̱hereeri̱ mugira gwa Yorodaani, ni̱bei̱za hali yo. ");
INSERT INTO rub_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Baatu̱lengi̱ bibii byab̯u, nibabatizib̯wa mu mugira gwa Yorodaani. ");
INSERT INTO rub_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Bei̱tu̱ Yohaana b̯u̱yaaweeni̱ Bafalisaayo na Basadukaayo banene ni̱bakwi̱za kubatizib̯wa, yaabaweera, “Nywe baana ba mpiri! Naani abahab̯wi̱ri̱ kwi̱ru̱ka ki̱ni̱ga kya Ruhanga, ki̱kyo kikugyenda kwi̱za? ");
INSERT INTO rub_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mu̱kore bintu bi̱kwolokya nti, mwezi̱ri̱ri̱mwo ngesu zeenyu̱ zibiibi. ");
INSERT INTO rub_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kandi mu̱leke kwehaariiza nimuteekereza nti, ‘Tuli kurungi, hab̯wakubba tuli beizukulu bʼI̱bbu̱rahi̱mu̱.’ Nkubaweera, Ruhanga akusobora kuhindula mahi̱ga gaga, naagafoora beizukulu bʼI̱bbu̱rahi̱mu̱. ");
INSERT INTO rub_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kandi ateeri̱ mpasa gyamwe heikolo lya musaali; musaali gwensei̱ gutakwana byana birungi, gu̱kwi̱za kutemwa gukasukwe mu mworo. ");
INSERT INTO rub_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Gya nkubabatiza na meezi̱, kwolokya nti mwezi̱ri̱ri̱mwo bibii byenyu̱; bei̱tu̱ yogwo akwi̱za kwei̱nyu̱ma lyange, akunkira mu kubba na b̯u̱sobozi̱, tinkusemeera kumukwatira nkei̱to zaamwe. Yogwo akwi̱za, alibabatiza na Mwozo Mu̱syanu̱ na mworo. ");
INSERT INTO rub_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Akweti̱ lugali lwamwe, asobore kuhuuhuula b̯u̱roi̱. Akwi̱za kusorooza b̯u̱roi̱ b̯wamwe, naab̯ubiika mu kideeru, bei̱tu̱ bisusunga akwi̱za ku̱byokya na mworo gutamalikaho.” ");
INSERT INTO rub_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Yesu̱ yaaru̱gi̱ri̱ Galilaaya, yaagyenda mu mugira gwa Yorodaani, aleke Yohaana amubatize. ");
INSERT INTO rub_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Bei̱tu̱ Yohaana yendeerye kumusuulukiira, yaaweera Yesu̱, “Weewe okusemeera kumbatiza; hati̱ kandi, oi̱zi̱ri̱ hali gya?” ");
INSERT INTO rub_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Bei̱tu̱ Yesu̱ yaamwi̱ri̱ri̱mwo naakoba, “Hataati̱, we ikiriza kwokwo kibbe, aleke tu̱doosereerye bintu byensei̱ bya Ruhanga byaku̱twendeerya.” Mwomwo Yohaana, yeikiriza kubatiza Yesu̱. ");
INSERT INTO rub_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesu̱ b̯u̱yaakamaari̱ kubatizib̯wa, yaaruga mu meezi̱. Mu kasu̱mi̱ kakwo iguru lyaki̱ngu̱li̱i̱rwe, yaawona Mwozo wa Ruhanga naaku̱si̱ri̱mu̱ka nka kolome, yaamwi̱cyaho. ");
INSERT INTO rub_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Mwomwo iraka lyaruga mwiguru nilikoba, “Yogwo yooyo Mwana wange gi̱nyendya, yooyo ampa kusemererwa mu mutima gwange.” ");
INSERT INTO rub_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Hei̱nyu̱ma, Mwozo Mu̱syanu̱ yeebembeeri̱ Yesu̱ yaamutwala mwirungu, kwoheb̯wa Sitaani. ");
INSERT INTO rub_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","B̯u̱yaamaari̱ biro maku̱mi̱ ganei mwinsi nei̱jolo atakudya kantu kensei̱, nzala gyamudya. ");
INSERT INTO rub_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Sitaani yaamwi̱zi̱i̱ri̱, yaamwohya naakoba, “Waakabba nooli Mwana wa Ruhanga, ragira mahi̱ga gaga, gafooke bidyo.” ");
INSERT INTO rub_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesu̱ yaamwi̱ri̱ri̱mwo naakoba, “Kyahandi̱i̱ki̱i̱rwe, “ ‘Muntu tiyoomeera hab̯wa bidyo bisa, bei̱tu̱ yoomeera hab̯wa b̯uli kigambu kiruga mu mu̱nwa gwa Ruhanga.’ ” ");
INSERT INTO rub_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Mwomwo Sitaani yaamutwala mu rub̯uga lu̱syanu̱, yaamuta kwakyendi̱ ha kasolya ka Yeekaru, ");
INSERT INTO rub_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","yaamuweera, “Waakabba nooli Mwana wa Ruhanga, gu̱su̱ka, weezi̱cye hansi; kubba Binyakuhandiikwa bikoba, “ ‘Ruhanga akwi̱za kuragira bamalayika baamwe bakulinde.’ Kandi, ‘Balikutegera mikono myab̯u bakukwate, aleke magulu gaamu gateekuuta kwi̱hi̱ga.’ ” ");
INSERT INTO rub_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu̱ yaamwi̱ri̱ri̱mwo naakoba, “Kandi de kyahandi̱i̱ki̱i̱rwe nti, ‘Otalilenga Mukama Ruhanga waamu.’ ” ");
INSERT INTO rub_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Sitaani yaab̯u̱ni̱i̱rye yaamutwala ha lusahu lulei hoi̱, yaamwolokya b̯ukama b̯wa mu nsi gyensei̱ na ki̱ti̱i̱ni̱sa kyab̯wo. ");
INSERT INTO rub_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Yaamuweera: “Nkwi̱za kukuha bibi byensei̱, b̯u̱waakaku̱nda malu̱ okandamya.” ");
INSERT INTO rub_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yesu̱ yaamwi̱ramwo naakoba, “Ndugaho Sitaani! Kubba kyahandi̱i̱ki̱i̱rwe nti, ‘Oramyenge Mukama Ruhanga waamu, kandi yooyo yankei oheerezenge.’ ” ");
INSERT INTO rub_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Mwomwo Sitaani yaamurugaho, bamalayika bei̱za baamuheereza. ");
INSERT INTO rub_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesu̱ b̯u̱yeegwi̱ri̱ nti Yohaana Mu̱bati̱zi̱ ateebeerwe mu nkomo, yeemu̱ki̱ri̱ mwisaza lya Galilaaya. ");
INSERT INTO rub_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Hei̱nyu̱ma gya kuruga Nazareeti̱, Yesu̱ yaagyendi̱ri̱ yeicala Kaperenau̱mu̱, rub̯uga lunyakubba niluli ha mutanda gweitaka lyetwa Galilaaya, mu kicweka ki̱kyo kya nganda ibiri, lwa Zabbu̱looni̱ na Nafutaali. ");
INSERT INTO rub_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yaagyendi̱ri̱yo aleke kya mu̱ragu̱ri̱ wa Ruhanga I̱saaya ki̱yaabazi̱ri̱ ki̱dwereere, ki̱kyo kikoba, ");
INSERT INTO rub_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Bantu bakwicala mu kicweka kya Zabbu̱looni̱ na mu kya Nafutaali, bab̯wo bali heehi̱ neitaka lya Galilaaya, nagwa b̯ugwalyoba b̯wa mugira gwa Yorodaani, mu nsi gya Galilaaya hali Banyamahanga banene beicala, ");
INSERT INTO rub_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","bab̯wo bantu banyakubba nibali mu nti̱ti̱, kyererezi̱ kinene ki̱basu̱u̱ki̱i̱ri̱. Na bab̯wo banyakwicalanga mu nsi gya kifubiro kya ku̱kwa, mambya wakubajuna asaari̱ hab̯wab̯u.” ");
INSERT INTO rub_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kuruga mu kasu̱mi̱ kakwo, Yesu̱ yaatandi̱ki̱ri̱ ku̱tebya naakoba, “Mwezi̱remwo, hab̯wakubba b̯ukama b̯wa mwiguru b̯uli heehi̱ kudwa.” ");
INSERT INTO rub_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu̱ b̯uyaali naakuraba ha mutanda gweitaka lya Galilaaya, yaaweeni̱ Si̱mooni̱ yeetwa Peeteru hamwenya nʼAndereya waab̯u, nibakuguma bitimba mu meezi̱, hab̯wakubba baalingi balobi̱, ");
INSERT INTO rub_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","kasi mwomwo yaabaweera: “Mwi̱ze mu̱mpondere, nkwi̱za kubafoora balobi̱ bakuloba bantu.” ");
INSERT INTO rub_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Nahaahwo baati̱gi̱ri̱ bitimba byab̯u baamuhondera. ");
INSERT INTO rub_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","B̯u̱yaagyendi̱ri̱ mu mei̱so kadooli̱, yaaweeni̱ baab̯u na baab̯u bandi babiri, Yakobbo mu̱tabani̱ wa Zebbedaayo na waab̯u Yohaana, nibali mu b̯wati̱ hamwei̱ na bbaawaab̯u Zebbedaayo, ni̱baku̱ni̱hi̱ri̱i̱rya bitimba byab̯u. Naboodede Yesu̱ yaabeeta. ");
INSERT INTO rub_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Nahaahwo, baati̱gi̱ri̱ b̯wati̱ b̯wab̯u na bbaawaab̯u, baahondera Yesu̱. ");
INSERT INTO rub_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu̱ yaali̱beeti̱li̱beeti̱ mu Galilaaya gyensei̱, ni̱yeegesyanga mu marombero gaab̯u, naatebyanga Makuru Garungi ga b̯ukama b̯wa Ruhanga, kandi naahoni̱a b̯uli nseeri̱ na kudiib̯wa kwensei̱ kwa bantu. ");
INSERT INTO rub_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Makuru gakumukwatanaho, gaasaaseeni̱ mu kicweka kya Si̱ri̱ya gyensei̱, bantu baamuleetera baseeri̱ bensei̱ banyakubba bakwati̱i̱rwe nseeri̱ na b̯u̱ru̱mi̱ b̯utali b̯u̱mwei̱, banyakubba na mizumu, banyakugwanga nsimbu, na bazi̱ngamu̱; yaabahoni̱a. ");
INSERT INTO rub_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Bitebe bya bantu banene byamu̱honderengi̱, bi̱byo binyakuruga mu Galilaaya, na mu li̱lyo isaza lya Mbuga I̱ku̱mi̱, na mu Yeru̱salemu̱, na mu B̯uyudaaya, na nseeri̱ gya Yorodaani. ");
INSERT INTO rub_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu̱ b̯u̱yaaweeni̱ bantu banene hoi̱ nibakumuhondera, yaatembi̱ri̱ ha lusahu, yeicaara ha nsi, mwomwo beegeseb̯wa baamwe bei̱za cali yaali, ");
INSERT INTO rub_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","yaatandika ku̱beegesya naakoba: ");
INSERT INTO rub_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Bali na mu̱gi̱sa bab̯wo beezegwa nibali baseege mu myozo myab̯u, hab̯wakubba b̯ukama b̯wa mwiguru b̯wab̯u. ");
INSERT INTO rub_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Bali na mu̱gi̱sa bab̯wo bali na nganye, hab̯wakubba Ruhanga ali̱bahu̱u̱mu̱u̱lya. ");
INSERT INTO rub_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Bali na mu̱gi̱sa bab̯wo bab̯u̱ndaaru̱, hab̯wakubba baligweterwa nsi. ");
INSERT INTO rub_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Bali na mu̱gi̱sa bab̯wo bali na nzala na nyoota gya kubalwa kubba basemereeri̱ mu mei̱so ga Ruhanga, hab̯wakubba alibaha bikubamala. ");
INSERT INTO rub_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Bali na mu̱gi̱sa bab̯wo bali na mbabazi̱, hab̯wakubba Ruhanga alibakwatiirwa mbabazi̱. ");
INSERT INTO rub_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Bali na mu̱gi̱sa bab̯wo ba mitima mi̱syanu̱, hab̯wakubba baliwona Ruhanga. ");
INSERT INTO rub_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Bali na mu̱gi̱sa bab̯wo bateeraniza bantu mu b̯u̱si̱nge, hab̯wakubba balyetwa baana ba Ruhanga. ");
INSERT INTO rub_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Bali na mu̱gi̱sa bab̯wo bahiiganizib̯wa hab̯wa kukora bintu birungi mu mei̱so ga Ruhanga, hab̯wakubba b̯ukama b̯wa mwiguru b̯wab̯u. ");
INSERT INTO rub_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Muli na mu̱gi̱sa bantu b̯u̱babalu̱ma, b̯ubabahiiganiza kandi b̯ubabahangiira bintu byensei̱ bibiibi hab̯wange. ");
INSERT INTO rub_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mu̱semererwenge, hab̯wakubba mpeera gyenyu̱ gili ginene mwiguru; kubba, kwokwo baahi̱i̱gani̱i̱ze yatyo baragu̱ri̱ ba Ruhanga banyakubanza. ");
INSERT INTO rub_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Nywe muli muzu gwa nsi. Bei̱tu̱ kakubba muzu gumalikwamwo b̯ululu b̯wagwo, tosobora ku̱b̯wi̱ryamwo. Gu̱gwo muzu gubba gutali na mugasu ha kintu kyensei̱, kutoolahoona gubba gwa ku̱kasu̱ka-b̯u̱kasu̱ki̱ bantu nibaguziginazigana. ");
INSERT INTO rub_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Nywe muli kyererezi̱ kya nsi, ki̱kyo kikwisana nka rub̯uga lu̱bi̱mbi̱i̱rwe ha lusahu, rub̯uga lutasobora kwebi̱sa. ");
INSERT INTO rub_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Tihaloho muntu yensei̱ akolereerya taara naagibbumba na lukimba, bei̱tu̱ agita ha kikondo kyagyo, aleke gimulukire bantu bensei̱ bali mu nnyu̱mba. ");
INSERT INTO rub_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nahab̯waki̱kyo, mu̱leke kyererezi̱ kyenyu̱ kimulukire bantu, aleke basobore kuwona bikorwa byenyu̱ birungi, bahaariize Bbaaweenyu̱ wa mwiguru. ");
INSERT INTO rub_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Mutateekereza nti, nyei̱zi̱ri̱ kutoolaho biragiro na Binyakuhandiikwa bya baragu̱ri̱; ntakei̱ze kubitoolaho, bei̱tu̱ nyei̱zi̱ri̱ ku̱bi̱doosereerya. ");
INSERT INTO rub_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Mu mananu nkubaweera nti, iguru na nsi bi̱takamali̱ki̱ri̱ho, tihaloho kadi kacweka kadooli̱ ka nyuguta kalirugaho, rundi kadi kacweka kaagyo kaliruga ha biragiro ku̱doosya byensei̱ b̯ubilidwereera. ");
INSERT INTO rub_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Nahab̯waki̱kyo yogwo yensei̱ alibinya kiragiro kyensei̱ kikusembayo b̯u̱dooli̱, akeegesya na bandi kubinya biragiro bya Ruhanga, yogwo muntu alibba na ki̱ti̱i̱ni̱sa ki̱dooli̱ mu b̯ukama b̯wa mwiguru; bei̱tu̱ kandi, yogwo yensei̱ alikwata bi̱byo biragiro akabyegesya bandi kubikora, alibba na ki̱ti̱i̱ni̱sa kinene mu b̯ukama b̯wa mwiguru. ");
INSERT INTO rub_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nahab̯waki̱kyo nkubaweera nti tihaloho muntu yensei̱ muli nywe alingira mu b̯ukama b̯wa mwiguru kutoolahoona yogwo akuhondera biragiro bya Ruhanga ku̱bi̱ki̱ryaho Bafalisaayo na beegesa ba biragiro. ");
INSERT INTO rub_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Mwegwi̱ri̱ nka ku̱baakobi̱ri̱ nti, ‘Otali̱i̱ta; yogwo yensei̱ ei̱ta, ali wa kuteeb̯waho musangu.’ ");
INSERT INTO rub_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Bei̱tu̱ gya nkubaweera, yogwo yensei̱ akwatirwa ki̱ni̱ga mwi̱ra waamwe aliteeb̯waho musangu; yogwo yensei̱ alu̱ma mwi̱ra waamwe, alitwalwa mu Lukuratu Lu̱handu̱; kandi yogwo yensei̱ yeeta mwi̱ra waamwe, ‘We mudoma we!’ Yogwo muntu akukoba yatyo aligumwa-b̯ugumwa mu mworo gwa Geehena. ");
INSERT INTO rub_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Nahab̯waki̱kyo, b̯wolibbanga nookuhayo kisembu kyamu ha kyoto kyeihongo kya Mukama Ruhanga, okei̱zu̱ka kintu kyensei̱ kya mwi̱ra waamu kyakukujunaana, ");
INSERT INTO rub_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","oi̱cyenge kisembu kyamu mu mei̱so ga kyoto, noobanza noogyenda hali mwi̱ra waamu ku̱mwezi̱ri̱ramwo, kasi noi̱rayo kutwala kisembu kyamu ha kyoto. ");
INSERT INTO rub_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Mwetegerezanganenge mu b̯wangu, na muntu ali na nsonga nawe, yogwo ali mu kukutwala mwicweru lya misangu atakaku̱dooseeryeyo. Kitali ki̱kyo akumaliira aku̱heeri̱yo hali mu̱cwi̱ wa misangu, kasi na mu̱cwi̱ yogwo naakuhayo hali musurukali, kasi musurukali naakuta mu nkomo. ");
INSERT INTO rub_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Mu mananu nkukuweera, toliruga mu nkomo kutoolahoona osaswi̱ri̱ b̯u̱li̱hi̱ b̯wensei̱. ");
INSERT INTO rub_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Mwegwi̱ri̱ nka ku̱baakobi̱ri̱ nti, ‘Otalikora b̯wenzi̱.’ ");
INSERT INTO rub_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Bei̱tu̱ gya nkubaweera nti, yogwo yensei̱ awona mu̱kali̱ akamwegomba, b̯u̱b̯wo yogwo muntu mu mutima gwamwe abba akoori̱ b̯wenzi̱ na yogwo mu̱kali̱. ");
INSERT INTO rub_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Li̱i̱so lyamu lya mukono gwab̯udyo kakubba libba nilikukuha kukora kibii, olitoolemwo olikasuke; hakiri ofeerwa ki̱mwei̱ ha bicweka bya mubiri gwamu, kukira mubiri gwamu gwensei̱ kugyenda mu mworo gwa Geehena. ");
INSERT INTO rub_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kandi mukono gwamu gwab̯udyo kakubba gubba nigukukuha kukora kibii, gutemeho ogukasuke; hakiri ofeerwa ki̱mwei̱ ha bicweka bya mubiri gwamu, kukira mubiri gwamu gwensei̱ kugyenda mu Geehena. ");
INSERT INTO rub_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Baakobi̱ri̱ nti, ‘Yogwo yensei̱ alibinga mu̱kali̱ waamwe, amuhe bbaruha gya kwahukana nayo.’ ");
INSERT INTO rub_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Bei̱tu̱ gya nkubaweera nti, mudulu yensei̱ abinga mu̱kali̱ waamwe, kutoolaho gana yogwo mu̱kali̱ naali akoori̱ b̯wenzi̱, yogwo mudulu abba naakuha yogwo mu̱kali̱ kukora b̯wenzi̱. Kandi na mudulu yensei̱ aswera mu̱kali̱ ei̱ti̱ri̱ nnyu̱mba, yogwo mudulu nayo abba akoori̱ b̯wenzi̱. ");
INSERT INTO rub_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Mwegwi̱ri̱ bahaaha beenyu̱ ba kadei nka ku̱baabaweereeri̱ nti, ‘Otalirahirira b̯usa ibara lya Mukama, bei̱tu̱ ki̱kyo ki̱waaragani̱syanga kumukoora, oki̱doosereeryenge!’ ");
INSERT INTO rub_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Bei̱tu̱ nkubaweera: Mutarahiranga kadi kadooli̱, rundi kurahira iguru, hab̯wakubba lyolyo ntebe gya b̯ukama b̯wa Ruhanga; ");
INSERT INTO rub_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","rundi kurahira nsi, hab̯wakubba kooko katebe ka magulu gaamwe; rundi Yeru̱salemu̱, kubba lwolwo rub̯uga lwa Mukama mu̱handu̱. ");
INSERT INTO rub_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kandi mutarahiranga ni̱mu̱hayo mi̱twe myenyu̱, hab̯wakubba timukusobora kuhindula kadi lutumbu lu̱mwei̱ lwa mi̱twe myenyu̱ kubba lu̱bbwi̱, rundi kubba lwi̱ragu̱ru̱. ");
INSERT INTO rub_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Nahab̯waki̱kyo leka kigambu kyamu ‘Kwokwo’ kiicalenge nikili ‘Kwokwo,’ rundi ‘Kwahi,’ kiicalenge nikili ‘Kwahi.’ Kubaza bigambu bikukira hali bi̱byo byabbanga bi̱ru̱gi̱ri̱ hali Sitaani. ");
INSERT INTO rub_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Mwegwi̱ri̱ ha bigambu bya kuhoora nzi̱go nti, ‘B̯u̱li̱hi̱ b̯wa kuhutaaza muntu li̱i̱so, b̯wabbanga li̱i̱so; na b̯u̱li̱hi̱ b̯wa kubinya muntu liino, b̯wabbanga liino.’ ");
INSERT INTO rub_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Bei̱tu̱ gya nkukoba, mutalihoora nzi̱go. Muntu yaakakupaalanga heitama lya mukono gwab̯udyo, muhinduurenge na lindi. ");
INSERT INTO rub_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Muntu yensei̱ alikutwala mu balemi̱ na kigyendeerwa kya kukunyaga saati gyamu, omulekerenge na kooti̱. ");
INSERT INTO rub_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kakubba habbaho muntu akukuhambiriza ku̱mwetwekera bintu hab̯wa lugyendu lwa ki̱lomi̱ta gi̱mwei̱, omwetwekerenge kumala ki̱lomi̱ta ibiri. ");
INSERT INTO rub_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Muntu yensei̱ yaakakusabanga kintu, okimuhenge; kandi yogwo yensei̱ yei̱zanga kukwehoraho, otalimusuulukiiranga. ");
INSERT INTO rub_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Mwegwi̱ri̱ nka ku̱baakobi̱ri̱ nti, ‘Wendyanga mwi̱ra waamu, onobenge munyanzigwa waamu.’ ");
INSERT INTO rub_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Bei̱tu̱ gya nkubaweera, mwendyenge banyanzigwa beenyu̱! Musabirenge bab̯wo bensei̱ babahiiga, ");
INSERT INTO rub_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","aleke mubbe baana ba Bbaaweenyu̱ ali mwiguru. Hab̯wakubba barungi na babiibi benseenya, Ruhanga abaha kalyoba; kandi, bantu bakora bintu bi̱doori̱ na bab̯wo bakora bi̱tadoori̱, abaha ndagali̱ atakubasoroora. ");
INSERT INTO rub_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mwakabba mwendya bab̯wo basa babendya, mulitunga mpeera ki? Na basorooza musolo, tikwokwo bakora yatyo? ");
INSERT INTO rub_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Mwakabba mu̱ramu̱kya bei̱ra beenyu̱ basa, bo bandi mu̱ku̱baki̱ri̱sya ki? Na Banyamahanga, tikwokwo bakora yatyo? ");
INSERT INTO rub_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nahab̯waki̱kyo, mu̱bbe basyanu̱ nka Bbaaweenyu̱ wa mwiguru kwali Mu̱syanu̱. ");
INSERT INTO rub_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Mwegyenderezenge b̯utakora bikorwa birungi mu mei̱so ga bantu, nimukugyendeera babawone. Kakubba mukola yatyo, Bbaaweenyu̱ wa mwiguru talibaha mpeera. ");
INSERT INTO rub_vpl V