﻿USE sofia;
DROP TABLE IF EXISTS sofia.rro_vpl;
CREATE TABLE rro_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES rro_vpl WRITE;
INSERT INTO rro_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Iesu Keriso ena rama kupu torina Aberahamo mai Davida bibirakiai emai. ");
INSERT INTO rro_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Aberahamo ehore Isako ebaramana, Isako ehore Iakobo ebaramana, Iakobo ehore Iuda uaho'abana kipokia ebaramanakia. ");
INSERT INTO rro_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Iuda ehore Perese mai Sera ebaramanakia, hinakia hanona Tamar, Perese ehore Hesarona ebaramana, Hesarona ehore Ram ebaramana. ");
INSERT INTO rro_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram ehore Aminadab ebaramana, Aminadab ehore Nasona ebaramana, Nasona ehore Salmon ebaramana. ");
INSERT INTO rro_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon ehore Boa ebaramana, hinana hanona Rahab rama haeai babi'ena. Boa ehore Obeda ebaramana, hinana hanona Ruta rama haeai babi'ena. Obeda ehore Iese ebaramana. ");
INSERT INTO rro_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Iese ehore Obia 'arana Davida ebaramana. Davida ehore Solomon ebaramana, ia hinana hanona 'uainai Uria atawana. ");
INSERT INTO rro_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon ehore Rehoboam ebaramana, Rehoboam ehore Abia ebaramana, Abia ehore Asa ebaramana. ");
INSERT INTO rro_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ehore Iehosabat ebaramana, Iehosabat ehore Ioram ebaramana, Ioram ehore Usia ebaramana. ");
INSERT INTO rro_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia ehore Iotam ebaramana, Iotam ehore Ahasa ebaramana, Ahasa ehore Hesekia ebaramana. ");
INSERT INTO rro_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekia ehore Manase ebaramana, Manase ehore Amon ebaramana, Amon ehore Iosia ebaramana. ");
INSERT INTO rro_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Iosia ehore Iekonia mai uaho'abana ebaramanakia, rani weianai Babulono haukia tehore Isaraela haukia tea'inakia teaoainakia ekia hanopakai. ");
INSERT INTO rro_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Baika teaoainakia Babulono murinai Iekonia ehore Sealtiel ebaramana, Sealtiel ehore Serubabel ebaramana. ");
INSERT INTO rro_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel ehore Abiud ebaramana, Abiud ehore Eliakima ebaramana, Eliakima ehore Asoro ebaramana. ");
INSERT INTO rro_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asoro ehore Sadok ebaramana, Sadok ehore Akim ebaramana, Akim ehore Eliud ebaramana. ");
INSERT INTO rro_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud ehore Eleasara ebaramana, Eleasara ehore Matan ebaramana, Matan ehore Iakobo ebaramana. ");
INSERT INTO rro_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Iakobo ehore Iosefa ebaramana. Iosefa atawana Maria ehore Iesu ebaramana, maearima atana teaparina Keriso bamauri hauna. ");
INSERT INTO rro_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Weiana Aberahamo ai eao Davida herenai hanona uru harau haea bani, Davida herenai eaomo teaoainakia Babulono raninai hanona uru harau haea bani, haeamona teaoainakia Babulono murinai eaomo Keriso herenai hanona uru harau haea bani. ");
INSERT INTO rro_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Iesu Keriso aea erama aiho hauna pouna hanona neiana. Hinana Maria hanona te'abi'uai aina Iosefa keatawana. Ia a'i tebahamomo baha aonai e'iobina Auba Robe hiabunai miori ha ea'ina. ");
INSERT INTO rro_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Iosefa hanona aka bero hauna, a'i enuatae Maria kebahaumaeana to'u wairakiai buonai, enuatae 'abi'uai weiana bunianai kea'i ki'ana. ");
INSERT INTO rro_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Raona weiana niraonana aonai, Obiapaka ena Aneru nibiai herenai ewaira tina e'abi etibaha, “Iosefa Davida 'aba'abana e, Maria iatawana a'i kota'uaina, pokina Auba Robe hiabunai miori weiana ea'ina. ");
INSERT INTO rro_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ia hanona miori ha kebaramana, atana katoaparina Iesu, pokina ia hanona ena maearima ekia ki'ai kebamaurinakia.” ");
INSERT INTO rro_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Hoa neiana erama hanona Obiapaka ena mahabanai hauna herenai e'abi hauna nibatohana. ");
INSERT INTO rro_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Uaho rari ha kepuma miori ha kebaramana, atana kateaparina Emanuela.” Isa 7.14 Anina hanona ‘Tirama aika herekai’. ");
INSERT INTO rro_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Iosefa eno'a murinai, Obiapaka ena Aneru e'abi ihobona ebabaina Maria eatawana. ");
INSERT INTO rro_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ia terarua a'i tenoti oioi 'apua eaomo Maria miori ebaramana. Iosefa miori atana eaparina Iesu. ");
INSERT INTO rro_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Heroda Obia 'arana Iuda eobia aina raninai, Iesu hanona Iuda aonai Betelehemai erama. Rani weianai aotipa haukia taetana taina hanopaka haeai ai temai Ierusalema teao, ");
INSERT INTO rro_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ba tebakai bakai tetibaha, “Iuda ekia Obia 'arana erama miorina hanona ae'eai? Ia ena bihiu taetana tainai taihana buonai tamai katakuti aina”. ");
INSERT INTO rro_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Heroda Obia 'arana 'abi weiana eona raninai nuana etae, mai Ierusalema ai maearima ikoinai abomo nuakia etae. ");
INSERT INTO rro_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ia ehore Iuda ekia robe haukia apa'uakia mai rauhubu poki haukia ikoikiai eaparinakia ebakainakia etibaha, “Keriso hanona ae'eai kerama?” ");
INSERT INTO rro_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ia ena 'abi tebamuena tetibaha, “Iuda Betelehema aonai. Mahabanai hauna ṉa erere aihona. ");
INSERT INTO rro_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Oi Betelehema, Iuda hanona aonai, Iuda ṯeiha 'inina aiarakia baiatakiai oi hanona a'i oko'iko'i ki'a baha, pokina oi heremuai poki hauna ha kemai ia hanona e'u Isaraela maearimakia ke'uai ainakia mamoe i'imana hauna 'abana.’” ");
INSERT INTO rro_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ua buonai Heroda aotipa haukia eapari buninakia ebakainakia ke'iobi haraina rani tabana tohanai hanona bihiu weiana ewaira tina. ");
INSERT INTO rro_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Euhunakia kateao Betelehema e'abi etibaha, “Katoao miori 'oru'oruna weiana katotabu haraina. Katotabu ahina hanona katoba'iobina'u, ba au abomo kaeao ia kakuti aina.” ");
INSERT INTO rro_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Aotipa haukia Heroda obia 'arana aiana teona murinai teka'a, taearai teao aonai bihiu weiana taetana tainai teihana hauna e'uai ainakia eaomo miori nemiaho 'ekanai hanona e'oro. ");
INSERT INTO rro_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Bihiu weiana teihana raninai aokia enamo banaina. ");
INSERT INTO rro_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Itu weiana aonai tetoto hanona miori hinana Maria ohi teihanakia ba tekaipehu miori tekuti aina. Murinai obia 'abana iberuberu bena tabakia gold, muramura timina orimona, mai muramura taburana hauani katetarona hauna tetara 'aunakia teberuberu bena. ");
INSERT INTO rro_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ba nibiai Tirama eharabunakia a'i katemue Heroda herena, weiana taeara haeai tekana temue teao ekia hanopaka. ");
INSERT INTO rro_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Aotipa haukia teka'a murikiai Obiapaka ena aneru nibiai Iosefa herenai ewaira tina e'abi etibaha, “Momikiri miori hinana ohi moba ka'anakia mo'uru ainakia moao Aigupito. Weia katomiaho keaomo au kahina beni'o, pokina Heroda hanona aba miori ketabuna keahu 'arina.” ");
INSERT INTO rro_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Epua, Iosefa emikiri miori hinana ohi ebaka'anakia rabi weianai teka'a teao Aikupito, ");
INSERT INTO rro_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","weia temiaho keaomo Heroda ke'ari. Weiana Obiapaka ena mahabanai hauna pinanai ehinana hauna ibatohana, “Au Aikupito ai Naha'u apari ahina.” ");
INSERT INTO rro_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Heroda e'iobina aotipa haukia a'i katemue herena, weiana aona eopuere ki'a, aotipa haukia ebakainakia ranina eraonana ihobonai 'abi ebaibeni ena huari haukia Betelehema mai aiara herenai haukia aokiai miori ikoinai ihaukia rua mai ba'ai haukia teahu'arinakia. ");
INSERT INTO rro_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Rani weianai mahabanai hauna Ieremia ehinana 'abina hanona etohana, ");
INSERT INTO rro_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Aia ha Rama ai teona hai mai aoko'o rarina 'akina, Rahela nahuna nihai ainakia, ia aona katebakirona hanona a'i nenuatae pokina ikoinai aba te'ari ore.” ");
INSERT INTO rro_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Heroda e'ari murinai Aigupito ai Obiapaka ena aneru Iosefa herenai nibiai ewaira tina, ");
INSERT INTO rro_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","e'abi etibaha, “Momikiri miori hinana ohi moba ka'anakia katomue Isaraela hanonai, weiakia miori kateahu 'arina haukia hanona aba te'ari”. ");
INSERT INTO rro_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ba Iosefa emikiri miori hinana ohi ebaka'anakia teao Isaraela. ");
INSERT INTO rro_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ia Akelao hamana Heroda 'ekana ea'ina Iuda neiha 'inina 'uruna eona raninai, keao hanona eta'u. Ba nibiai ba'iobi ea'ina ekabanai eao Galilea. ");
INSERT INTO rro_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ia teao aiara ha atana Nasareta wa'a temiaho, weiana hanona mahabanai haukia tehinana 'abina etohana, ‘Ia hanona kateaparina Nasareta hauna.’ ");
INSERT INTO rro_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Rani weianai Ioane Ba'uere robe hauna ewaira tina Iuda hano'akunai ena iroro ea'i ramana etibaha, ");
INSERT INTO rro_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Emi ki'ai tomoraona kabe, pokina Tirama ena obia aiarana hanona aba ekaibari.” ");
INSERT INTO rro_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Neiana hanona mahabanai hauna Isaia 'abina ehinana hauna etibaha, “Hau ha hano'akunai eio etibaha, ‘Obiapaka ena taeara tomoba'oruna, Ena kaoao boana tomobaberona.’” ");
INSERT INTO rro_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ioane ena habuni hanona mahi atana Kamela buirana tanatananai ebabaina, mai huana 'apana hanona poromakau paruana ehaina, ena aniani hanona pekaupekau mai hoho beina. ");
INSERT INTO rro_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ierusalema maearimakia mai Iuda aonai aiara maikoina, haeamona Ioridana ate herenai aiara ikoinai haukia temai herena aiana kateona. ");
INSERT INTO rro_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ekia ki'a tehina pounakia, haeamona eba'uere robenakia Ioridana ate aonai. ");
INSERT INTO rro_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ioane Parisea haukia mai Sadukea haukia bo'okia temai herenai keba'uere robenakia eihanakia raninai ehinabenakia etibaha, “'Erau nahuna haumi e. Tai ehinabenimi puma weiana Tirama aba ketiuahina hauna herenai katobeau pare? ");
INSERT INTO rro_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Raonakabe buabuana tomobawaira tinana. ");
INSERT INTO rro_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Aomiai a'i kato'abi wai hanona Aberahamo 'aba'abana buonai puma weiana herenai katobeau pare. Au wai nahinabenimi Tirama hanona mai hiabuna pihara neiakiai Aberahamo 'aba'abana kebabainakia! ");
INSERT INTO rro_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Wapira hanona aba e'oru matiu pokinai, buabua namokia a'i tibaramanakia matiukia ikoinai hanona ke'uinakia iruba aonai kekapo totonakia. ");
INSERT INTO rro_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Au hanona beiai mo naba'uere robenimi emi raona kabe hoana, ia weiana muri'uai nimai hauna hanona Auba Robeai mai irubai keba'uere robenimi. Ia hanona eapa'ua ki'a baha ba au, au a'i anamo ena tamaka kabuanakia. ");
INSERT INTO rro_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ena ikomo matiuna imanai ea'ina, ikomo 'ekana ea'i a'i haraina uho weiakia ikoinai kekomonakia paruakia keba'ehonakia, uho namokia ikoinai kebararonakia paraboa aonai kero'anakia, ia hamarakia hanona weiana a'i ni'ao 'apua irubana aonai kehuhu orenakia.” ");
INSERT INTO rro_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Rani weianai Iesu hanona Galilea ai emai Ioridana atena Ioane herenai keba'uere robena. ");
INSERT INTO rro_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ia Ioane ebaoao etibaha, “Oi au poba'uere robena'u hanona penamo. Iamo omai au here'u.” ");
INSERT INTO rro_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Iesu Ioane ena 'abi ebamuena etibaha, “Bariu hanona neiana oi kobabaina. Aka neianai Tirama ena bero akakia ikoikiai kahabatohanakia.” Ba Ioane ehore Iesu eba'uere robena. ");
INSERT INTO rro_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Iesu e'uere robe murinai, beronai beiai ekara'au aonai kupa ekaikau Tirama ena Auba eriri emai ahanai matoha rauria eriri 'abana eihana. ");
INSERT INTO rro_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ba aia ha Kupai emai e'abi etibaha, “Neiana hanona au Naha'u tohana, E'u raona'au. Au hanona ia naonamo aina.” ");
INSERT INTO rro_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Weiana Auba Robe ehore Iesu eaoaina hano'akunai tiaporo kehore kehobona. ");
INSERT INTO rro_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Iesu wapu ikoinai bariabui erobe aniani ha a'i eani, murinai hanona mare'a e'ari ki'a. ");
INSERT INTO rro_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Aonai baihobo hauna emai herena e'abi etibaha, “Peoi Tirama nahuna raninai, pihara neiakia mohina benakia pohamai temeao.” ");
INSERT INTO rro_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ia Iesu e'abi etibaha, “Puka robenai aba tererena, ‘Maearima hanona pohamai mo a'i katemauri, ia Tirama ena 'abi ehina haukia ikoinai katea'inakia hanona katemauri.’” ");
INSERT INTO rro_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Weiana tiaporo ehore Iesu eaoaina Ierusalema aiara robena, Marea robe 'ubina 'akinai ebakori 'auna, ");
INSERT INTO rro_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ba ehinabena etibaha, “Peoi Tirama nahuna raninai, kipomu naia morobo ahi. Pokina Puka robenai aba tererena, ‘Tirama ena aneru kehina benakia kate'imani'o imakiai katea'i taeani'o, weiana piharai aemu a'i mokaina ta'una.’” ");
INSERT INTO rro_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Iesu ia ena 'abi ebamuena etibaha, “Puka robenai abomo ṉa terere aihona, ‘Obiapaka emu Tirama baihobo 'ekanai a'i kohorotina.’” ");
INSERT INTO rro_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Haeamona tiaporo ehore Iesu eaoaina 'ubi 'akina kobiona kaipanai ebaehe 'auna, ba hanopaka aiarakia maikoina nuabina ebaihana. ");
INSERT INTO rro_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Tiaporo e'abi etibaha, “Kokaipehu kokuti aina'u raninai, neiakia maikoinai oi kabeni'o.” ");
INSERT INTO rro_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Iesu haeamona e'abi etibaha, “Satani e, mokatu'a! Puka robenai ṉa terere aihona, ‘Obiapaka emu Tirama iamo ikupaiana kokuti aina, mai ta'arana koa'i.’” ");
INSERT INTO rro_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Weiana tiaporo Iesu herenai ekaobo, ba aneru temai tebaraina. ");
INSERT INTO rro_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Iesu Ioane aba wapura itunai tehorotina pouna eona raninai emue eao Galilea hanonai. ");
INSERT INTO rro_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Weia Nasareta aiaranai a'i emiaho, ia eao Sebulon mai Napatali hanokiai Galilea obu haianai aiara ha atana Kaperanauma ua'a emiaho. ");
INSERT INTO rro_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Neiana erama hanona Isaia mahabanai hauna e'abi hanona kebatohana etibaha, ");
INSERT INTO rro_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sebulon hanonai mai Napatali hanonai, obu haianai, Ioridana ate abihanai, Galilea rama haeai haukia ekia hano ai! ");
INSERT INTO rro_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Maearima weiakia wapurai ṯemiaho haukia ea rarina 'akina kateihana. Weiakia 'ari aiaiakia hanokiai ṯemiaho haukia herekiai ea kerara.” ");
INSERT INTO rro_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Rani weianai Iesu ena iroro ea'i ramana etibaha, “Emi ki'ai tomoraona kabe, pokina Tirama ena obia aiarana hanona aba ekaibari!” ");
INSERT INTO rro_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Iesu Galilea 'obu poena haiana ekana eao aonai, a'a hati rua Simona, teaparina Petero, uaho 'abana Anderea ohi eihanakia ekia re'e 'obu aonai tehorenakia, pokina ia hanona ba'eha haukia. ");
INSERT INTO rro_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Iesu ehina benakia etibaha, “Muri'uai tomai. Au kahore maearima iba'eha benikia haumiai kabaonimi.” ");
INSERT INTO rro_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Beronai ekia re'e tehabonakia murinai teao. ");
INSERT INTO rro_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Eka'a haha eao hanona a'a hati rua Iakobo mai Ioane hamakia Sebedeo kipokia ekia ahi ahanai ekia re'e tiahu abunakia eihanakia ba eaparinakia. ");
INSERT INTO rro_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Beronai ekia ahi mai hamakia tehabonakia Iesu murinai teao. ");
INSERT INTO rro_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Iesu Galilea hanona maikoina aona ekana, Iuda haukia ekia marea aokiai eba'iobi, Tirama ena obia aiarana pouna namona eiroro aina, mai maearima ekia inawa haeai haeai mai hau haiara haeai haeai ikoinai ebanamonakia. ");
INSERT INTO rro_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Suria hanopakana maikoina aonai pouna erama otaraina, weiana maearima tehore inawa haeai haeai haukia temaiainakia Iesu herena, hau haiara haeai haeai haukia, aokiai auba ki'a obokia haukia, nawa ti'ari aina haukia, mai 'ome haukia. Ia ehore ikoinai ebanamonakia. ");
INSERT INTO rro_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","To'u rarina 'akina Galileai mai weiakia Aiara Harauhaeai, Ierusalemai mai Iudai, Ioridana atena abiranai hanokia maearimakia Iesu murinai teka'a. ");
INSERT INTO rro_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Iesu mako eihanakia raninai oeoai ekara'au weia emiati. I'abana haukia temai herena, ");
INSERT INTO rro_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","weia ena ba'iobi ea'i ramana, ehina benakia etibaha, ");
INSERT INTO rro_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Aokia te'aiaunu haukia hanona tenamo, pokina Tirama ena obia aiarana hanona ia 'eukia. ");
INSERT INTO rro_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Tihai hai haukia hanona tenamo, pokina Tirama aokia kebataburanakia. ");
INSERT INTO rro_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Mamata haukia hanona tenamo, pokina hano e'abi'uai aina hauna katea'ina. ");
INSERT INTO rro_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Aka berona timare'a aina mai ti'ako 'ororo aina haukia hanona tenamo, pokina Tirama kehore ekia raona kebabonunakia. ");
INSERT INTO rro_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Maearima tiaoko'o ainakia haukia hanona tenamo, pokina ia abokiamo Tirama keaoko'o ainakia. ");
INSERT INTO rro_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Aokia timahamaha haukia hanona tenamo, pokina ia hanona Tirama kateihana. ");
INSERT INTO rro_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Baibua akana tibabaina haukia hanona tenamo, pokina Tirama kehore nahunai kebaonakia. ");
INSERT INTO rro_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Aka berona tibabaina paunai ti'oatanakia haukia hanona tenamo, pokina Tirama ena obia aiarana hanona ia 'eukia. ");
INSERT INTO rro_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Au muri'uai tuka'a paunai maearima kateaiahunimi mai kate'oatanimi, bai'oi 'abikia ki'a obokia haeai haeai heremiai katehina hanona tonamo. ");
INSERT INTO rro_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Aomi kenamo mai katoaonamo, pokina kupai hana 'arami rarina. 'Uainai mahabanai haukia temiaho raninai ṉa te'oata aihonakia. ");
INSERT INTO rro_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Wai hanona maearima ekia kikimaru. Ia kikimaru ena 'aku'aku ke'akauma raninai, aea keiba'aku'aku mue aiho? Taba baika herekiai ena aka aha'i buonai, kahane'e ahina maearima ahanai kate'ehe hai 'ehe haina. ");
INSERT INTO rro_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Wai hanona maearima ekia ea. Aiara oeo 'ubinai tebabaina hauna hanona kebuni a'i ketaina. ");
INSERT INTO rro_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Hau ha ramepa keba'arana raninai uro ba'anai a'i kehorotina. Ia ihao'auna 'ekanai kehao'auna, ba maearima ikoinai itu aonai haukia ea kebenakia. ");
INSERT INTO rro_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Taeara neiana ihobonai, emi ea maearima wairakiai tomobawaira tinana, weiana aka namokia tubabai hanona temeiha Hamami kupai hauna temebanamona. ");
INSERT INTO rro_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ṉa a'i katoraona aiho au amai hanona Mose ena Rauhubu mai mahabanai haukia ekia ba'iobi ka'i parenakia paunai. Au amai hanona a'i ka'i parenakia, ia ekia ba'iobi kabatohanakia. ");
INSERT INTO rro_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","'Abi tohana au wai nahinabenimi, hanopaka mai kupa katepua, ia rererere puapuana 'aki ha 'ao 'abi papana 'aki ha rauhubu aonai a'i ke'akauma keao mo taba ikoinai katerama ore. ");
INSERT INTO rro_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Weiana buonai hau ha rauhubu papana 'aki a'i nika'aina ba maearima baika ba'iobi weiana ihobona kebenakia hanona Tirama ena obia aiaranai ia hanona ke'aera 'aera 'aki. Ia tai rauhubu nika'ai haraina mai ba'iobi weiana ihobona nibenakia hanona Tirama ena obia aiaranai ia hanona keapa'ua. ");
INSERT INTO rro_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Au wai nahinabenimi, wai emi bero akakia katehore weiakia Parisea haukia mai rauhubu poki haukia ekia bero akakia a'i katetara haonakia raninai Tirama ena obia aiaranai a'i katokatoto 'apua. ");
INSERT INTO rro_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","'Uainai 'aba'abami herekiai tehinana 'abina aba tona. “A'i koahuahu, ia hau ha keahuahu hauna hanona bakai 'ekanai kehoroti.” ");
INSERT INTO rro_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ia bariu au nahinabenimi. Hau ha uaho'abana niopuereaina hanona kateaoaina bakai 'ekana. Haeamona hau ha uaho'abana po'ona kehinana hanona kateaoaina bakai apa'uana ṯe'imana haukia herekia. Ia hau ha uaho'abana kehinabena ketibaha, “Ao 'abaea tohamu.” hanona kateaoaina 'eka ki'a obona iruba a'i ni'ao 'apua 'ekana. ");
INSERT INTO rro_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Weiana paunai emu ibeni tabana itara robena ahanai nubaibeni aonai uaho'abamu herenai emu beho ha nemiaho hauna oraona tinana raninai, ");
INSERT INTO rro_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","emu ibeni tabana weia itara robena wairanai kohabona. Koao 'uai uaho'abamu herenai torarua kato'abi oioi, ba komue emu ibeni tabana kobaibeni. ");
INSERT INTO rro_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Hau ha oi beho 'ekanai ehorotini'o hauna bariu torarua bakai 'ekana tuao aonai moba'amena beho weiana tomobabero biaina, ba bakai wairanai kokoroti. Weiana a'i kobabaina raninai, oi ni'oatani'o hauna bakai ne'imana hauna imanai keutani'o, bakai ne'imana hauna habuni hauna imanai keutani'o, ba oi hanona wapura 'ekanai kate horotini'o. ");
INSERT INTO rro_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","'Abi tohana au nahina beni'o, oi hanona a'i kokarahi 'apua keaomo emu beho 'arana pene orena kobaibeni. ");
INSERT INTO rro_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Wai 'abi 'uruna aba tona ṉa e'abi aiho, ‘Oi hau ha atawana a'i konabau aina.’ ");
INSERT INTO rro_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ia au wai nahina benimi hau ha babi'e neihana ba niraona ki'a hanona aonai aba nabau hoana ebabaina ia herenai. ");
INSERT INTO rro_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Mahamu itipana ki'ai nihorotini'o raninai, ko'ipa ahina kone'ena. Hauanimu puana ke'akauma hanona enamo ba haumu maikoina iruba a'i ni'ao 'apua 'ekana aonai a'i mekapo totoni'o marikina. ");
INSERT INTO rro_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Mai imamu itipana ki'ai nihorotini'o raninai, kokabe hurina kone'ena. Haumu puana hamona ke'akauma hanona enamo ba haumu maikoina iruba a'i ni'ao 'apua 'ekana aonai a'i mekapo totoni'o marikina. ");
INSERT INTO rro_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Abomo ṉa e'abi aiho, ‘Hau ha atawana nibakarahina raninai bakarahi marerena ha kererena kebena.’ ");
INSERT INTO rro_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ia au wai nahinabenimi, hau ha atawana a'i nimaha porepore ia nibakarahi 'abaeana hanona ena behoai atawana nabau 'ekanai ehorotina, mai hau ha kehore tebakarahina babi'ena weiana keatawana hanona ia abomo nabau hoana ebabaina. ");
INSERT INTO rro_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Haeamona 'uainai 'aba'abami herekiai tehinana 'abina aba tona, ‘Emi 'abi'uai hanona a'i katokabena. Ia emi 'abi'uai pahihina Obiapaka herenai hanona katobabaina.’ ");
INSERT INTO rro_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ia au wai nahinabenimi. 'Abi'uai pahihina a'i katobabaina. Kupa ahanai 'abi'uai pahihina a'i katohinana, pokina ia hanona Tirama ena imia'au. ");
INSERT INTO rro_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","'Ao hanopaka ahanai 'abi'uai pahihina a'i katohinana, pokina ia hanona Tirama 'apuna ihorotina 'ekana, 'ao Ierusalema ahanai 'abi'uai pahihina a'i katohinana, pokina ia hanona Obia 'arana apa'uana ena aiara. ");
INSERT INTO rro_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Mai oi 'aramu ahanai 'abi'uai pahihina a'i kohinana, pokina oi buimu ha hamona kobaporena 'ao koba'umuna hanona a'i o'iobina. ");
INSERT INTO rro_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Oi mo emu 'abi, 'E re'a 'E, 'ao Aha'i re'a Aha'i. Taba neiakia waira 'akinai nohinanakia hanona hau ki'a obona herenai timai. ");
INSERT INTO rro_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Wai 'abi neiana aba tona e'abi etibaha, ‘Maha 'arana hanona maha, mai nihe 'arana hanona nihe.’ ");
INSERT INTO rro_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ia au wai nahinabenimi, maearima ena ki'a 'arana hanona a'i kobamuena. Hau ha mekemu itipana kebo'ana raninai, koke'e banai awarimu abomo kobena. ");
INSERT INTO rro_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Hau ha nenuatae emu ibatoto kea'ina paunai bakai 'ekanai kehorotini'o raninai, emu iro'abu abomo kobena. ");
INSERT INTO rro_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Hau ha kebahi ahini'o maela hamona koka'aina raninai, torarua maela rua katoka'aina. ");
INSERT INTO rro_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Maearima tinoini'o tabana hanona kobenakia, mai heremuai taba ha nenuatae aina kea'i 'abaeana hanona a'i koubo aina. ");
INSERT INTO rro_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Wai 'abi 'uruna aba tona ṉa e'abi aiho, ‘Heremiai haukia katoraona'au ainakia mai emi 'ou haukia katobaki'anakia.’ ");
INSERT INTO rro_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ia au wai nahinabenimi, emi 'ou haukia katoraona'au ainakia mai weiakia ti'oatanimi haukia paukiai kato bahuba'ari. ");
INSERT INTO rro_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Weianai wai hanona Hamami kupai hauna nahunai katoao. Ia ena beraura ihobonai mo nibararana ki'a haukia mai namo haukia herekiai, mai abara ihobona mo nibatibona babai bero haukia mai babai ki'a haukia herekiai. ");
INSERT INTO rro_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Wai maearima weiakia tiraona'au ainimi haukia mo turaona'au ainakia raninai 'arami hanona taba katoa'ina? Moni bararo haukia abomo ua tibabai aiho. ");
INSERT INTO rro_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Wai uaho'abami mo tubaonakia raninai, emi namo hanona taba maearima baika herekiai? A'i tia'ikakauma haukia abomo ua tibabai aiho. ");
INSERT INTO rro_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ua buonai wai katobero harai ihobona Hamami kupai nemiaho hauna ebero harai 'abana.” ");
INSERT INTO rro_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Kato'ima'ima harainimi, emi bero akakia maearima wairakiai a'i katobabai, a'i temeihanimi marikina. Ua katobabai aihona raninai wai hanona 'arami aha'i Hamami kupai hauna herenai. ");
INSERT INTO rro_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Weiana buonai baraibarai tabana uraru hauna kobena raninai, maearima wairakiai a'i koapa, ihobona bahaorea haukia marea aokiai mai aiara ibuakiai tibabaina 'abana maearima banamo ia katebenakia paunai. 'Abi tohana au wai nahinabenimi, ia hanona 'arakia maikoina aba tea'ina. ");
INSERT INTO rro_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ia wai uraru haukia tubarainakia raninai, imamu awarina hauna a'i ke'iobina imamu itipana hanona taba nibabaina. ");
INSERT INTO rro_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Weiana emu baibeni hanona aomuai kobunina. Ba Hamamu taba bunianai tirama neihanakia hauna oi 'aramu kebeni'o. ");
INSERT INTO rro_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Wai katobahuba'ari raninai bahaorea haukia 'abakiai a'i katoao. Ia ekia nuatae apa'uana hanona marea aokiai mai aiara ibuakiai katekoroti katebahuba'ari maearima ia kateihanakia paunai. 'Abi tohana au wai nahinabenimi, 'arakia maikoina aba tea'ina. ");
INSERT INTO rro_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ia kobahuba'ari raninai, emu ikaihuri aonai kokatoto ba emu pa'abi kokaiabuna kobahuba'ari Hamamu a'i noihana hauna herenai. Hamamu taba bunianai tirama neiha hauna 'aramu kebeni'o. ");
INSERT INTO rro_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Tubahuba'ari aonai 'abi anikia ha'i haukia bo'ona a'i katohina matoha rama haeai haukia tibabaina 'abana. Tiraonana ekia bahuba'ari nihoma'a hanona Tirama aiakia aba niona. ");
INSERT INTO rro_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ia 'abakiai a'i katoao. Wai Hamami a'i tunoi bahana aonai aba e'iobina wai taba tonuatae aina. ");
INSERT INTO rro_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Wai hanona ṉa katobahuba'ari aiho. ‘Hamamai e, kupai nomiaho. Oi atamu hanona katabarobena. ");
INSERT INTO rro_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Emu obia aiarana kemai, ikoimaiai emu nuatae katababaina hanopakai, ihobona kupai tibabaina 'abana. ");
INSERT INTO rro_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Bariu rani neianai aniani ṯanuatae aina hauna kobenamai. ");
INSERT INTO rro_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Emai ki'a tababai haukia mohina hao, ihobona weiakia heremaiai tebabai ki'a haukia ekia ki'a tahina hao 'abana. ");
INSERT INTO rro_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","A'i koaoainamai baihobo 'ekakiai, ia tiaporo herenai kobamaurinamai. (Kupa aiarana oi 'eumu, Hiabu oi 'eumu, Nuabi oi 'eumu, keaomo banai banai. Amen.)’ ");
INSERT INTO rro_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Maearima weiakia heremiai tebabai ki'a haukia ekia ki'a katohina haonakia raninai, Hamami kupai hauna emi ki'a abomo kehina haonakia. ");
INSERT INTO rro_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ia wai maearima ekia ki'a a'i katohina haonakia raninai, Hamami kupai nemiaho hauna abomo emi ki'a a'i kehina haonakia. ");
INSERT INTO rro_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Wai tuanirobe raninai wairami a'i katobabira biranakia matoha bahaorea haukia 'abakia. Ihakia tibamaea maeanakia maearima ikoinai kateihanakia kate'iobina ia hanona tianirobe. 'Abi tohana au wai nahina benimi, 'arakia maikoina aba tea'ina. ");
INSERT INTO rro_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ia oi koanirobe raninai, wairamu koutu mai 'aramu tehoroai koutuna. ");
INSERT INTO rro_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Weiana maearima a'i kate'iobina oi hanona nuanirobe, iamo Hamaka a'i nahaihana hauna mo ke'iobina. Ba Hamamu taba bunianai tirama neihanakia hauna kehore 'aramu kebeni'o. ");
INSERT INTO rro_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Emi kepu hanopakai a'i katoro'anakia, weiana muhi mai 'abi'abi katehore katea'i ki'anakia, mai bainao haukia katehore itu kateahu pa'ana katebainao ainakia. ");
INSERT INTO rro_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ia emi kepu kupai katoro'anakia, weia hanona muhi mai 'abi'abi a'i katea'i ki'anakia, mai bainao haukia itu a'i kateahu pa'ana a'i katebainao ainakia. ");
INSERT INTO rro_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Weiana oi emu kepu 'eka tabanai hanona aomu abomo weia. ");
INSERT INTO rro_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Maha hanona hauani ena ramepa, oi mahamu tenamo raninai hauanimu maikoina hanona ea aonai. ");
INSERT INTO rro_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ia mahamu kateki'a raninai hauanimu maikoina hanona wapura aonai. Ba oi aomu eana niwapura raninai wapura weiana hanona keapa'ua wairai. ");
INSERT INTO rro_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Hau ha poki haukia rua rani hamonai ta'arakia a'i kea'i. Ia hamona 'arina a'i ke'ari mai ha keraona'au aina, 'ao hamona aiana keona mai ha kebaki'ana. Wai Tirama mai kepu terarua rani hamonai ta'arakia a'i katoa'i. ");
INSERT INTO rro_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Weiana buonai au wai nahinabenimi. Aomi a'i katearo'ari, taba patoana 'ao taba patoinu emi mauri paunai, 'ao hauanimiai taba patobatotona hauna a'i katoraonana. Mauri hanona eapa'ua ki'a baha ba pohama, mai hauanimu hanona eapa'ua ki'a baha ba habuni. ");
INSERT INTO rro_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Roborobo tirobo tomoihanakia. Ia uho a'i tibato, a'i tieueu mai rerea a'i tihoroti, ia Hamami kupai hauna ne'ima harainakia. Ia wai hanona tonamo ki'a baha ba roborobo. ");
INSERT INTO rro_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Oi tai ha emu ao aro'ari kehore emu mauriai pomiaho homa'a 'apuana? ");
INSERT INTO rro_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Mai taba buonai aomi niaro'ari habuni herenai? Hoeahoea arabu haianai aea ti'omu aiho katoihanakia. Ia a'i tiaro'ari 'ao kipokia habunikia a'i tibabai. ");
INSERT INTO rro_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ia au wai nahinabenimi, Solomon ena nuabiai habuni namona ebatotona, iamo taitai neiakia hanona tenamo ki'a baha. ");
INSERT INTO rro_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Weiana arabu tubukia bariu titaitai mara aba kate'ororo iruba aonai katekapo totonakia kate'ara haukia habunikia Tirama nihore ṉa nibabatoto aihonakia raninai, wai emi habuni ua a'i kebabatoto aihonimi, u? Emi a'ikakauma teko'iko'i haumi. ");
INSERT INTO rro_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ua buonai aomi a'i katearo'ari, a'i kato'abi, “Aika taba kahana?” 'ao “Aika taba kahainu?” 'ao “Aika taba kahabatotona?” ");
INSERT INTO rro_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Weiana rama haeai haukia taba nahomakia ikoinai titabunakia, ia wai Hamami kupai aba e'iobina taba neiakia tonuatae ainakia. ");
INSERT INTO rro_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Wai hanona Tirama ena obia aiarana mai ena nuatae akana berona katotabu 'uaina, ba taba nahomakia ikoinai hanona wai kebenimi. ");
INSERT INTO rro_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Weiana paunai aomu a'i kearo'ari mara 'eunai. Mara hanona kipona ena ao aro'ari. Wapu ha ha ekia aro'ari hanona kipokia 'eukia.” ");
INSERT INTO rro_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Baika beho 'ekanai a'i katohorotinakia pokina Tirama wai beho 'ekanai a'i mehorotinimi. ");
INSERT INTO rro_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Weiana wai baika behoai tuhorotinakia taeara ihobonai Tirama kehore wai behoai kehorotinimi. Mai wai emi babai baika herekiai ihobokiai Tirama kehore heremiai kebabai. ");
INSERT INTO rro_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Taba buonai uaho'abamu mahana aonai matiu nabunabuna noihana, iamo oi kipomu mahamu aonai matiu rarina robana a'i nuahuna? ");
INSERT INTO rro_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Aehoma buonai oi uaho'abamu nohinabena, “Mahamu aonai matiu nabunabuna ma'i ahina”? Ia oi hanona mahamu aonai matiu rarina nemiaho. ");
INSERT INTO rro_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Oi bahaorea haumu! Kipomu mahamu aonai matiu rarina moa'i ahi 'uaina, ba koihaiha harai uaho'abamu mahana aonai matiu nabunabuna koa'i ahina. ");
INSERT INTO rro_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Robe tabana waeha a'i katobenakia, katekabe a'i teme 'urinimi marikina. Emi mairi a'i katokapo ahinakia aiporo wairakiai. Aekiai a'i teme'ehe banai 'ehe banaina marikina. ");
INSERT INTO rro_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Katonoi hanona kebenimi, katotabuna hanona katotabu ahina, katoharahara hanona pa'abimi kekaikauna. ");
INSERT INTO rro_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Weiana maearima ha ha tinoinoi hanona katea'inakia, tabu tabu haukia hanona katetabu ahina, mai harahara haukia hanona pa'abikia kekaikauna. ");
INSERT INTO rro_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Oi hau tabamu, nahumu pohama penoi aina raninai pihara pobena, u? ");
INSERT INTO rro_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","'Ao maia penoi aina raninai 'erau pobena, u? ");
INSERT INTO rro_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Wai ki'a haumi, iamo nahumi taba namokia katobenakia hanona to'iobina. Babita 'abana Hamami kupai hauna kehore tinoi haukia taba namokia tohakia kebenakia, u? ");
INSERT INTO rro_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Maearima baika heremiai taba tonuatae aina katebabaina hauna wai abomo herekiai ihobona katobabaina. Neiana hanona Mose ena Rauhubu mai mahabanai haukia ekia ba'iobi 'abina anina tohana. ");
INSERT INTO rro_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Wai hanona pa'abi 'omo'omona aonai katokatoto. Pokina pa'abi weiana eao 'ari banaibanai 'ekana hanona emata mai taearana epanaba, maearima bo'ona hanona weia tikatoto. ");
INSERT INTO rro_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ia pa'abi weiana eao mauri 'ekana hanona e'omo'omo, mai taearana ika'ana hanona epahihi, maearima bitamo titabu ahina. ");
INSERT INTO rro_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Mahabanai bai'oi haukia katoiha harainakia, katemai heremi ihakia matoha mamoe 'abakia, ia aokia hanona waeha 'aki aibarakia 'abakia. ");
INSERT INTO rro_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Wai hanona maearima weiakia buabuakiai katobai'iobi. 'Ama'ama 'ororo buana a'i keba ramana, 'ao 'ini boaboa maiha buana a'i kebaramana. ");
INSERT INTO rro_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ihobona mo matiu namokia ikoikiai hanona buakia namokia tibaramanakia, ia matiu ki'a obokia hanona buakia ki'a obokia tibaramanakia. ");
INSERT INTO rro_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","'A matiu namona hanona buabua ki'a obona kebaramana a'i ketaina mai matiu ki'a obona hanona buabua namona kebaramana a'i ketaina. ");
INSERT INTO rro_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Matiu weiakia ikoinai buabua namokia a'i tibaramanakia haukia hanona ikabe obo iruba aonai katekapo totonakia. ");
INSERT INTO rro_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Weiana buabua uahomakiai hanona mahabanai bai'oikia aba kato'iobinakia. ");
INSERT INTO rro_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Maearima tiaparina'u, “Obiapaka e, Obiapaka e,” weiakia haukia maikoinai mo Tirama ena obia aiarana aonai a'i katekatoto, ia tai Hama'u kupai nemiaho hauna ena nuatae akana kebabaina hauna mo kekatoto. ");
INSERT INTO rro_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Wapu weianai maearima bo'ona here'u ai kate'abi katetibaha, “Obiapaka e, Obiapaka e, ai atamuai tamahabanai, ai atamuai auba ki'a obokia tau'u ahinakia, mai hoa haeai haeai tababainakia!” ");
INSERT INTO rro_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ba au hanona wairakiai kahinabe harainakia katibaha, “Au wai a'i a'iobinimi. Here'uai tomokapare, wai ki'a ibabaina haumi!” ");
INSERT INTO rro_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Weiana paunai hau ha e'u 'abi neiana 'uruna niona mai akakia nibabai hanona matoha ao bero hauna 'abana ena itu wairo ahanai ebakori 'auna. ");
INSERT INTO rro_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Abara etibo tou ekarahi mai baura rarina eabu 'au itu eabu ki'ana, ia a'i epobu, pokina itu hanona wairo ahanai ebakori 'auna. ");
INSERT INTO rro_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ia hau ha e'u 'abi neiana 'uruna niona, ia akana a'i nibabaina hanona matoha po'o hauna 'abana ena itu 'ano ahanai ebakorotina. ");
INSERT INTO rro_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Abara etibo tou ekarahi, mai baura eabu itu epobu earu otaraina.” ");
INSERT INTO rro_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Iesu 'abi weiana ebapuana hanona to'u haukia ikoikiai ena ba'iobiai teta'u ta'u huri. ");
INSERT INTO rro_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Pokina ia ena ba'iobi hanona rauhubu poki haukia ekia ba'iobi 'abakia aha'i, ena 'abi hanona mai hiabuna. ");
INSERT INTO rro_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Iesu oeo ai eriri raninai maearima to'u rarina 'akina murinai te'au. ");
INSERT INTO rro_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Morumoru hauna ha emai Iesu wairanai ekaipehu e'abi etibaha, “Obiapaka e, konuatae raninai kobanamona'u ketaina.” ");
INSERT INTO rro_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Iesu imana etiu ahina ea'i 'apuana e'abi etibaha, “Au nanuatae haumu menamo.” Biaimo ena morumoru enamo. ");
INSERT INTO rro_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ba Iesu hau weiana ehinabena etibaha, “Hau ha haianai a'i ko'abi, ia koao kipomu robe hauna herenai haumu kobaihana, mai beruberu Mose e'uahina hauna kobaibeni ia herenai kebatohani'o oi hanona aba onamo.” ");
INSERT INTO rro_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Iesu Kaperanauma aiaranai ekatoto raninai, Roma huari poki hauna ha emai herena enoina kebaraina. ");
INSERT INTO rro_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","E'abi etibaha, “Obiapaka e, e'u ta'ara a'i hauna nimero ituai enoti, hauna nihaiara ki'a.” ");
INSERT INTO rro_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Iesu ehinabena etibaha, “Kawahi kabanamona.” ");
INSERT INTO rro_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Huari poki hauna e'abi etibaha, “Obiapaka e, au a'i anamo oi komai e'u itu, 'a ko'abi mo weiana e'u ta'ara a'i hauna kemauri. ");
INSERT INTO rro_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Pokina au hanona hiabu hauna ha ba'anai ṉamiaho mai huari haukia baika au ba'a'uai ṯemiaho. Au hau neiana ṉahina bena, ‘Moao’ hanona niao, haeamona hau weiana ṉahina bena, ‘Omai.’ hanona nimai. Abomo e'u ta'ara a'i hauna ṉahina bena, ‘Neiana mobabaina.’ hanona ia nihore nibabaina.” ");
INSERT INTO rro_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Iesu aia weiana eona raninai eta'u ta'u huri, ba murinai ti'au haukia ehinabenakia etibaha, “'Abi tohana au wai nahinabenimi, Isaraela aonai hau ha herenai a'ikakauma ṉahomana ha a'i atabu ahi 'apuana. ");
INSERT INTO rro_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Au wai nahinabenimi maearima bo'ona 'akina taetanai mai tibotainai katemai Tirama ena obia aiarana aonai tatu 'ekanai Aberahamo, Isako, Iakobo kipokia katemiati haeamo. ");
INSERT INTO rro_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ia maearima weiakia Tirama ena obia aiarana eba'oruna 'eukia haukia hanona mahana wapuranai katekapo ahinakia weia katehai mai nihekia katearao'i arao'i.” ");
INSERT INTO rro_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Iesu huari poki hauna ehinabena etibaha, “Moao emu itu, oa'ikakauma ihobonai heremuai aba kerama.” Ena ta'ara a'i hauna beraura hoana weiana aonai beronai emauri mauri. ");
INSERT INTO rro_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Iesu Petero ena ituai ekatoto raninai, Petero rawana babi'ena eihana neinawa hauna nehiabu enoti. ");
INSERT INTO rro_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Iesu ehore babi'e imana ea'i 'apuana, ba inawa ehabona, babi'e emikiri Iesu ta'arana ea'i. ");
INSERT INTO rro_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Weiana rabirabi eaoaina aonai maearima bo'ona auba ki'a obokia aokiai haukia temaiainakia Iesu herena. Iesu hanona ena 'abiai auba ki'a obokia eu'u ahinakia mai inawa haukia ikoikiai ebamaurinakia. ");
INSERT INTO rro_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Neiana hanona Isaia mahabanai hauna ena 'abi ibatohana ṉa e'abi aiho, ‘Ia kipona eka 'abe'abe kea'i parenakia mai eka inawa kebua obonakia.’ ");
INSERT INTO rro_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Iesu to'u rarina tekori kaiarona eihanakia raninai i'abana haukia ehina benakia katekabanai obu abirana kateao. ");
INSERT INTO rro_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Rauhubu poki hauna ha emai Iesu ehinabena etibaha, “Ba'iobi haumu e, 'eka tabana koao ia au hanona oi murimuai ka'au.” ");
INSERT INTO rro_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Iesu ia ena 'abi ebamuena etibaha, “Waeha 'aki hanona mai ekia 'uri, mai 'ubi roborobokia hanona mai ekia ni'i, 'a au maearima nahuna hanona ara'u kahorotina karai 'ekana aha'i.” ");
INSERT INTO rro_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","I'abana hauna ha Iesu ehinabena etibaha, “Obiapaka e, paeao 'uai hama'u pahorena.” ");
INSERT INTO rro_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","'A Iesu ia ehinabena etibaha, “Muri'uai mo'au, 'ari haukia hanona mohabonakia kipokia ekia 'ari temehorena.” ");
INSERT INTO rro_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Weiana Iesu ahiai ehe'au, i'abana haukia kipokia teao. ");
INSERT INTO rro_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Weiana obuai kou rarina 'akina eabu 'au, roio rarikia temikiri ahi tebahu abuna, 'a Iesu hanona eparua 'ari. ");
INSERT INTO rro_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","I'abana haukia teao tebaona te'abi tetibaha, “Obiapaka e, moba maurinaka aba kahatono.” ");
INSERT INTO rro_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ia ekia 'abi ebamuena etibaha, “Emi a'ikakauma eko'i ko'i haumi, aehoma buonai tuta'u ki'a?” Ba Iesu emikiri rani mai roio erikenakia, weiana beronai e'omata harai 'aki. ");
INSERT INTO rro_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Hau weiakia teta'u ta'u huri te'abi tetibaha, “Neiana hanona hau tabana, ba rani mai roio abomo aiana tika'aina.” ");
INSERT INTO rro_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Iesu obu abirana Gadarene hanonai ekara'au raninai, hau rua aokiai auba ki'a obokia ṯemiaho haukia 'ari ahanai temai herena. Ia teaiahu wairai paunai hau ha taeara weianai a'i ekabanai. ");
INSERT INTO rro_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ia teio tetibaha, “Tirama nahuna e, heremai ai taba nonuatae aina? Rani a'i nitai bahana ia oi omai hanona ai kobahaiaranamai, u?” ");
INSERT INTO rro_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","'Eka weianai baiatana a'i ehoma'a hanona aiporo to'una ha tianiani. ");
INSERT INTO rro_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ba auba ki'a obokia Iesu tenoina tetibaha, “Oi kobakarahinamai raninai, kouhunamai kataeao aiporo to'una weiana aokiai katatoto.” ");
INSERT INTO rro_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Weiana ia ehinabenakia etibaha, “Tomoao.” Ba ia tekarahi teao, aiporo aokiai tetoto. Aiporo to'una maikoinai herehere ai tebeau riri papa'a ai terobo ahi obu aonai tetobu tetono 'ari. ");
INSERT INTO rro_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Aiporo 'ima haukia tebeau obo aiara apa'uanai pou neiana mai auba ki'a obokia hau aokiai temiaho haukia pouna abomo tehinana. ");
INSERT INTO rro_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Weiana aiara apa'uana maearimana maikoinai temai Iesu kateihana. Ba temai teihana raninai, tenoina ekia hano kehabona. ");
INSERT INTO rro_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Iesu ahi ai ehe'au obu ebeau banai ena aiara tohana eao. ");
INSERT INTO rro_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Maearima baika mero hauna ha toto'eai teaoaina herena. Iesu ekia a'ikakauma eihana raninai, mero hauna ehinabena etibaha, “Naha'u e, a'i kota'u, emu ki'a aba ihina hao.” ");
INSERT INTO rro_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Weiana rauhubu poki haukia baika kipokia baiatakia te'abi'abi tetibaha, “Hau neiana hanona Tirama herenai ni'abi ki'a.” ");
INSERT INTO rro_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Iesu ekia raona raona e'iobinakia ba e'abi etibaha, “Aehoma buonai raona ki'a obona aomiai turaonana? ");
INSERT INTO rro_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Aeana hauna e'ama'ama, ka'abi ‘Emu ki'a ihinahao.’ 'ao ka'abi ‘Momikiri, moka'a.’ ");
INSERT INTO rro_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","'A wai kato'iobina au maearima nahuna hanona mai e'u hiabu hanopaka maearimakia ekia ki'a kahina hao.” Ba Iesu mero hauna ehinabena etibaha, “Momikiri, emu toto'e moa'ina, moao emu itu.” ");
INSERT INTO rro_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Weiana ia emikiri, eao ena itu. ");
INSERT INTO rro_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","To'u haukia babai weiana teihana raninai teta'u ki'a, ba hiabu uahomana maearima ebenakia Tiramana tebanamona. ");
INSERT INTO rro_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Iesu 'eka weiana ehabona eao aonai hau ha eihana, ia atana Mataio moni a'i 'ekanai emiati, ehinabena etibaha, “Muri'uai mo'au.” Mataio emikiri murinai eka'a. ");
INSERT INTO rro_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Iesu Mataio ena itu ai nianiani aonai, moni bararo haukia bo'ona mai aka ki'a haukia abomo temai ia mai i'abana haukia kipokia teaniani haeamo. ");
INSERT INTO rro_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Parisea haukia baika hoahoa weiana teihana raninai i'abana haukia tebakainakia tetibaha, “Aehoma buonai emi ba'iobi hauna moni bararo haukia mai aka ki'a haukia kipokia tianiani haeamo?” ");
INSERT INTO rro_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Iesu aia neiana eona hanona ekia 'abi ebamuena etibaha, “A'i ṯeinawa haukia hanona muramura baibeni hauna a'i ṯenuatae aina, 'a ṯeinawa haukia mo ia ṯenuatae aina. ");
INSERT INTO rro_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Wai tomoao Puka robena 'abina neiana anina taba hanona katotabuna, ‘Au aoko'o nanuatae aina ia baibeni tabana aha'i.’ Au amai ena poki hanona bero haukia a'i kaparinakia, 'a aka ki'a haukia kaparinakia.” ");
INSERT INTO rro_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Weiana Ioane i'abana haukia temai Iesu herena tebakaina tetibaha, “Aehoma buonai ai mai Parisea haukia kipokia ṯani robe, 'a oi i'abamu haukia hanona a'i tiani robe?” ");
INSERT INTO rro_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Iesu ekia 'abi ebamuena etibaha, “Hawainibe mahamaha hauna ena baki haukia herekiai nemiaho aonai ia aea katehai aiho? 'A rani kemai hawainibe mahamaha hauna herekiai katea'i parena aonai ia kateani robe. ");
INSERT INTO rro_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Hau ha habuni mahamahana puana habuni 'ai'aina ohi a'i ketai orenakia, pokina itai 'ekana kepuhu pa'ana hanona tapa keapa'ua ki'a. ");
INSERT INTO rro_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Maearima bine beina mahamahana beibei 'ai'aikiai a'i katebaharuna, pokina beibei katepa'a hanona bine beina kekiki oioi abomo beibei keki'a, 'a bine beina mahamahana hanona beibei mahamahakiai kateibaharu weiana terarua katenamo.” ");
INSERT INTO rro_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Iesu 'abi neiana nehinana aonai, marea poki hauna ha emai wairanai ekai pehu ehinabena etibaha, “Naha'u uahona hanona bariu mo e'ari, ia omai imamu ahanai kohao 'au hanona kemauri.” ");
INSERT INTO rro_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ba Iesu emikiri murinai e'au, i'abana haukia abomo teao. ");
INSERT INTO rro_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Weia babi'e ekia inawa ea'ina ihau harau haea rua babi'ena ha Iesu murinai eka'a emai ena habuni puana ea'i 'apuana. ");
INSERT INTO rro_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Pokina kipona aonai etibaha, “Ena habuni puana mo ka'i 'apuana hanona kanamo.” ");
INSERT INTO rro_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","'A Iesu eiha kabe eihana ba ehinabena etibaha, “Naha'u e, a'i kota'u, emu a'ikakauma ehore ebanamoni'o.” Babi'e beronai mo enamo. ");
INSERT INTO rro_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Weiana Iesu marea poki hauna ena ituai etoto, irarabu ahu haukia mai to'u rarina urukia nebua eihanakia raninai, ");
INSERT INTO rro_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ia ehinabenakia etibaha, “Tomokatu'a, uaho hanona a'i e'ari, ia hanona niparua.” To'u haukia Iesu teiriri aina. ");
INSERT INTO rro_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ba to'u haukia tekarahi mahanai murinai, ia ikaihuri aonai etoto, uaho imanai ea'i hanona uaho emauri mauri ba emikiri. ");
INSERT INTO rro_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Pou neiana eao hano weiana maikoinai tehina otaraina. ");
INSERT INTO rro_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Iesu 'eka weianai ekarahi aonai mahakia teki'a haukia rua murinai teka'a teio tetibaha, “Davida nahuna e, moaoko'o ainamai.” ");
INSERT INTO rro_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ia ituai etoto raninai mahakia teki'a haukia temai herena, ba Iesu ebakainakia etibaha, “Wai tua'ikakaumana'u au aka neiana kababaina hanona ketaina, u?” Ia te'abi tetibaha, “'E, Obiapaka, ṯa'ikakaumani'o.” ");
INSERT INTO rro_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Weiana Iesu ia mahakia ea'i 'apuanakia ba e'abi etibaha, “Emi a'ikakauma ihobona heremiai merama.” ");
INSERT INTO rro_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Weiana mahakia teno'a. Ba Iesu eharabunakia etibaha, “Hau ha a'i katoba'iobina.” ");
INSERT INTO rro_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","'A ia tekarahi teao hano weiana maikoina aonai Iesu pouna tehina otaraina. ");
INSERT INTO rro_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ia tekarahi teka'a aonai, maearima baika hau ha aonai auba ki'a obona nemiaho buonai maeana eki'a hauna teaoaina Iesu herena. ");
INSERT INTO rro_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Auba ki'a obona eu'u ahina murinai maeana eki'a hauna enamo ba e'abi'abi, to'u haukia maikoinai teta'u ta'u huri te'abi tetibaha, “Isaraela aonai hoa nahomana ha a'i haiha 'apuana.” ");
INSERT INTO rro_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","'A Parisea haukia te'abi tetibaha, “Ia hanona auba ki'a obokia ekia poki hauna ena hiabuai auba ki'a obokia neu'u ahinakia.” ");
INSERT INTO rro_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Weiana Iesu eao aiara apa'uakia mai papakia maikoikiai aokiai ekaoao, ekia marea aokiai eba'iobi, Tirama ena obia aiara pouna namona eiroro aina, inawa mai haiara haeai haeai ikoikiai ebanamonakia. ");
INSERT INTO rro_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Iesu to'u haukia eihanakia hana eaoko'o ainakia pokina tiaru 'abaea mai hau hororokia ihobona mamoe i'imakia hauna aha'i haukia 'abana. ");
INSERT INTO rro_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ba ia i'abana haukia ehinabenakia etibaha, “Umai aniani bo'ona aba te'oru, ia aka haukia hanona a'i ebo'o. ");
INSERT INTO rro_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ua buonai uma Poki Hauna katonoina aka haukia keuhunakia ena umai kateueu.” ");
INSERT INTO rro_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Iesu i'abana haukia harau haea rua eaparinakia temai herena, hiabu ebenakia auba ki'a obokia kateu'u ahinakia haeamona inawa mai haiara haeai haeai ikoikiai kateba namonakia. ");
INSERT INTO rro_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Iuhubeau haukia harau haea rua atakia hanona neiakia, kori 'uaina Simona, ia hanona teaparina Petero, mai uaho'abana Anderea, Sebedeo nahuna Iakobo mai uaho'abana Ioane. ");
INSERT INTO rro_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilipo, Batolomeo, Toma mai moni bararo hauna Mataio, Alepeo nahuna Iakobo, mai Tadeo. ");
INSERT INTO rro_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Selote hauna Simona, mai Isakariote hauna Iuda, Iesu ehinahinaina hauna. ");
INSERT INTO rro_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Iesu hau harau haea rua neiakia euhunakia mai ehinabenakia etibaha, “Rama haeai haukia ekia hano a'i katoao abomo Samaria aiarakia ha a'i katokatoto. ");
INSERT INTO rro_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","'A katoao Isaraela itubuna ena mamoe te'akauma haukia herekia. ");
INSERT INTO rro_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Katoao aonai katoiroro katotibaha, ‘Tirama ena obia aiarana hanona aba herekai.’ ");
INSERT INTO rro_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Inawa haukia katoba namonakia, 'ari haukia katoba maurinakia, morumoru tea'ina haukia hauanikia katoba namonakia, mai auba ki'a obokia katou'u ahi. Wai toa'i 'abaeana buonai katobaibeni 'abaea. ");
INSERT INTO rro_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Emi mahoa ihiua ihiua aokiai moni apa'uana 'ao papana ha a'i katoutana. ");
INSERT INTO rro_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Emi kaoao paunai mahoa, habuni ibatoto ibaruana, tamaka, mai ikai'ini a'i katoa'inakia, pokina aka hauna hanona mai ena iro'o. ");
INSERT INTO rro_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Aiara tabanai tukatoto hanona kea'i taeanimi hauna katotabuna herenai katomiaho keaomo 'eka weiana katohabona. ");
INSERT INTO rro_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Itu weianai tukatoto hanona banamo katobaibeni. ");
INSERT INTO rro_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Itu maearimakia katea'i taeanimi raninai emi baibua banamona ahakiai kemiaho, 'a a'i katea'i taeanimi raninai emi banamo hanona kemue heremi. ");
INSERT INTO rro_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","'A tai ha a'i kea'i taeanimi 'ao aiami a'i keona raninai aiara 'ao itu weiana katohabona aonai 'apumi 'apurorokia katotabu tabu obonakia. ");
INSERT INTO rro_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","'Abi tohana au wai nahina benimi, bakai orena berauranai Sodoma mai Gomora aiarakia ekia puma ma ke'aera, ia aiara weiana ena puma hanona keapa'ua. ");
INSERT INTO rro_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Au wai nauhunimi hanona ihobona matoha mamoe 'abakia tuao waeha 'aki baiatakiai. Ua buonai 'erau 'abakiai katoao katoaobero mai rauria 'abakiai katoao aomiai ki'a a'i katoraonana. ");
INSERT INTO rro_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Maearima herekiai kato'ima 'ima harainimi, pokina ia kateaoainimi bakai 'ekanai katehorotinimi, abomo marea aokiai kate'atinimi. ");
INSERT INTO rro_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Au buo'uai wai kateaoainimi poki haukia apa'uakia mai obia haukia apa'uakia wairakiai katebabakainimi, aonai ia mai rama haeai haukia herekiai pou namona ihina pouna haumiai katoao. ");
INSERT INTO rro_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Kateaoainimi bakai 'ekana raninai aomi a'i kearo'ari 'abi tabana katohinana 'ao aea kato'abi aiho. Rani weianai taba katohinana hauna Tirama kebenimi. ");
INSERT INTO rro_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Pokina ihinana hanona wai aha'i, 'a Hamami Tirama Aubana aomiai hauna ke'abi. ");
INSERT INTO rro_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Uaho'aba ha kehore uaho'abana kehinahina aina kateahu 'arina, hama kehore nahuna ua kehomana, nahu katehore hamakia mai hinakia kate'oatanakia 'ari 'ekanai katehorotinakia. ");
INSERT INTO rro_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Maearima ikoikiai au buo'uai kateaotata ainimi, 'a tai kekori 'ini keao puanai hauna kemauri. ");
INSERT INTO rro_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Aiara hai kate'oatanimi raninai kato'uru katoao aiara 'abana ha. 'Abi tohana au wai nahinabenimi, Isaraela aiarakia ikoikiai a'i katokatoto ore bahanakia aonai au maearima nahuna hanona kamai. ");
INSERT INTO rro_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Marere miorina ena ba'iobi hauna a'i ketara haona 'ao ta'ara'i hauna ena poki hauna a'i ketara haona. ");
INSERT INTO rro_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Marere miorina ena ba'iobi hauna ohi kateihobo hanona enamo, mai ta'ara a'i hauna ena poki hauna ohi kateihobo hanona enamo. Itu poki hauna kateaparina Belesebulo raninai itu maearimakia baika abomo ata ki'a obokiai kateaparinakia. ");
INSERT INTO rro_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ua buonai a'i katota'u ainakia. Taba tebahu abunakia haukia ikoikiai hanona katea'i kau mai taba bunikia ikoikiai hanona katebawaira tinanakia kate'iobi. ");
INSERT INTO rro_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Taba wapurai nahina benimi haukia hanona ea aonai katohinanakia mai taba haiamiai abateteai haukia hanona itu kapenai katoiroro ainakia. ");
INSERT INTO rro_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Weiakia hauani kateahu 'arina haukia a'i katota'u ainakia pokina auba hanona a'i kateahu 'arina. Ia Tirama katota'u aina ia hanona hauani mai auba terarua kea'i ki'a ki'a bahanakia iruba aonai. ");
INSERT INTO rro_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Komure rua hanona pene hamonai katekawanakia. Iamo Hamami ena nuatae aha'i raninai ha a'i ke'eho 'anoai. ");
INSERT INTO rro_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Weiana buimi ikoikiai aramiai haukia aba etuabi orenakia. ");
INSERT INTO rro_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ua buonai a'i katota'u wai hanona komure bo'ona 'akina totara haonakia. ");
INSERT INTO rro_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Hau ha maearima wairakiai ke'abi ia au ni'abana'u hauna hanona au abomo Hama'u kupai nemiaho hauna wairanai ka'abi ia hanona au i'aba'u. ");
INSERT INTO rro_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","'A hau ha maearima wairakiai au kebuniai aina'u hauna hanona au abomo Hama'u kupai nemaiho hauna wairanai ia kabuniai aina. ");
INSERT INTO rro_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","A'i katoraonana au amai hanona baibua hanopakai kamaiaina. Au hanona baibua a'i amaiaina ia kareba amaiaina bai'oata kerama. ");
INSERT INTO rro_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Au amai pokina hanona neiana, ‘Hau kehore hamana ke'oatana, uaho kehore hinana ke'oatana, rawa babi'ena 'aru'aruna kehore rawana babi'ena kirona ke'oatana. ");
INSERT INTO rro_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Maearima ha ena itu haukia hanona ena 'ou haukiai kateao.’ ");
INSERT INTO rro_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Hau ha hamana 'ao hinana niraona'auai ki'a bahana ba au, ia hanona a'i ketaina here'uai. Hau ha nahuna hauna 'ao uahona niraona'auai ki'a bahana ba au, ia hanona a'i ketaina here'uai. ");
INSERT INTO rro_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Hau ha ena matiu ibiri ropo a'i nebuana muri'uai a'i ni'au hauna, ia hanona a'i ketaina here'uai. ");
INSERT INTO rro_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Hau ha ena mauri keani ki'aina hauna hanona ena mauri keba'akaumana, hau ha ena mauri keba'akaumana au pau'uai hauna hanona ena mauri ketabu ahina. ");
INSERT INTO rro_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Maearima tabana wai nia'i taeanimi hauna hanona au nia'i taeana'u, mai au nia'i taeana'u hauna hanona euhuna'u Tiramana abomo nia'i taeana. ");
INSERT INTO rro_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Hau ha mahabanai hauna ha nia'i taeana pokina ia mahabanai hauna paunai, ia hanona mahabanai 'arana ihobona kea'ina, mai hau ha bero hauna ha nia'i taeana pokina ia bero hauna paunai, ia hanona bero hauna 'arana ihobona kea'ina. ");
INSERT INTO rro_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Hau ha bei 'amarina ereai miori neiakia atakia a'i teapa'ua haukia kebenakia pokina ia au i'aba'u haukia paunai, 'abi tohana au wai nahina benimi, 'ara ia'ina aonai ia a'i kekapu.” ");
INSERT INTO rro_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Iesu i'abana haukia harau haea rua 'abi neiakiai erobenakia murinai, 'eka weiana ehabona eao Galilea aiarakia aokiai weia keba'iobi mai keiroro. ");
INSERT INTO rro_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ioane wapura ituna aonai Keriso ena aka poukia eo'o raninai i'abana haukia euhunakia herena teao, ");
INSERT INTO rro_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Iesu tebakaina tetibaha, “Kemai hauna hanona oi? 'Ao haeai ha kata'imana?” ");
INSERT INTO rro_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Iesu ekia 'abi ebamuena etibaha, “Tomomue tomoao, taba to'o mai toiha haukia Ioane haianai katohinanakia. ");
INSERT INTO rro_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Maha ki'a haukia aba ṯeihaiha mue, ome haukia tika'a, morumoru haukia aba tinamo, haia po'o haukia aia tio'o, 'ari haukia ṯemikiri timauri, mai uraru haukia herekiai pou namona ṯeiroro aina. ");
INSERT INTO rro_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Hau ha here'uai aona a'i nikai'au kai'au hauna Tirama nibanamona.” ");
INSERT INTO rro_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ioane i'abana haukia tekamuri aonai, Iesu to'u haukia herekiai Ioane pouna ehina ramana. “Wai taba katoihana buonai toao hano'akunai? Baura kopura nibaibiunakia katoihanakia, u? ");
INSERT INTO rro_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Aha'i raninai, toao hanona taba katoihana? Hau ha habuni ta'eta'ekia ebatotonakia hauna, u? Weiakia habuni ta'eta'ekia tibatoto haukia hanona obia 'arana ena ituai ṯemiaho. ");
INSERT INTO rro_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ba taba katoihana buonai toao? Mahabanai hauna ha? 'E, au wai nahinabenimi, Ioane hanona mahabanai haukia etara haonakia. ");
INSERT INTO rro_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ia pouna Puka robenai ṉa tererena aihona, ‘Au e'u iuhubeau hauna kauhu 'uaina wairamuai, ia kehore emu taeara kea'ia'i haraina.’ ");
INSERT INTO rro_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","'Abi tohana au wai nahinabenimi, weiakia babi'e tebaramanakia haukia baiatakiai hau ha ba'uere robe hauna Ioane a'i etara haona, iamo weiana Tirama ena obia aiaranai eko'i ko'i hauna Ioane etara haona. ");
INSERT INTO rro_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ba'uere robe hauna Ioane ena raniai emaimo bariu, Tirama ena obia aiarana hanona tikakina, kakikaki haukia hanona tibahobona katepuhu boina. ");
INSERT INTO rro_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Pokina mahabanai haukia mai Mose ena rauhubu ikoikiai aokiai Tirama ena obia aiarana pouna tehinana emai mo Ioane ena raniai. ");
INSERT INTO rro_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Wai tua'i taeana raninai kato'iobina Ioane hanona Elia weiana kemai hauna. ");
INSERT INTO rro_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Mai haiana hauna hanona aia keona. ");
INSERT INTO rro_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Uru neiana haukia tabai kaba batainakia? Ia hanona matoha miori papakia kawakawa 'ekanai ṯemiati 'abakia tiaparinakia ṯetibaha, ");
INSERT INTO rro_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Ai irarabu ṯahunakia wai paumiai, iamo wai a'i tuewa. 'Ari huikia ṯa'i, iamo wai a'i tuhai.’ ");
INSERT INTO rro_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Weiana Ioane emai hanona a'i eaniani mai a'i einuinu, ba ia te'abi tetibaha, ‘Auba ki'a obona ha ia aonai.’ ");
INSERT INTO rro_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Au Maearima nahuna amai aniani mai ainuinu hanona ia te'abi tetibaha, ‘Ia hanona aniani ki'a mai inuinu ki'a, moni bararo mai aka ki'a haukia ekia hau.’ 'A aobero hanona ena buabua nihore ena bero nibatohana.” ");
INSERT INTO rro_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Weiana Iesu aiara weiakia aokiai hiabu hoakia bo'okia ebabai 'ekakia maearimakia ebatanakia, pokina ia ekia ki'ai a'i teraona kabe buonai. ");
INSERT INTO rro_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Korasina e, heremuai keki'a wairai! Betesaida e, oi abomo heremuai keki'a wairai! Hiabu hoakia heremiai ababai haukia Turo mai Sidono haukia herekiai pababai raninai, ia hanona aba wa'i baha 'akinai pateraona kabe, habuni ki'a obokia patebatoto mai arakiai rabu patehoroti. ");
INSERT INTO rro_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","'A au wai nahina benimi, Tirama ena bakai apa'uana berauranai Turo mai Sidono haukia ekia puma hanona ma ke'ama'ama ba wai 'eumi. ");
INSERT INTO rro_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kaperanauma e, oi katea'i taeani'o koao kupa ubinai, u? Aha'i, oi hanona katekapo ririni'o koao iruba aonai. Hiabu hoakia weiakia heremuai ababai haukia Sodoma herenai pababai raninai, ia hanona pemiaho mo pemai bariu rani neianai. ");
INSERT INTO rro_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","'A au wai nahinabenimi, Tirama ena bakai apa'uana berauranai Sodoma ena puma hanona ma ke'ama'ama ba wai 'eumi. ");
INSERT INTO rro_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Rani weianai Iesu ena bahuba'ariai e'abi etibaha, “Hama'u e, kupa mai hanopaka Obiana. Au oi nabanamoni'o pokina taba neiakia ohore buninakia aotipa mai 'iobi haukia herekiai, ia miori papakia herekiai obawaira tinanakia. ");
INSERT INTO rro_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Hama'u e, 'abi tohana, pokina neiana hanona oi emu aonamo tohana. ");
INSERT INTO rro_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Hiabu ikoikiai hanona Hama'u aba ebena'u. Ia Nahuna a'i te'iobina Hamana mo kipona, mai hau ha Hamana a'i e'iobina Nahuna mai Nahuna etina'anakia haukia weiakia herekiai kipona kebawaira tinana haukia mo.” ");
INSERT INTO rro_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Tuhau hororo haumi mai puma ṯobuana haumi, ikoimiai ena here'u tomai, au wai arai kabenimi. ");
INSERT INTO rro_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","E'u iebebe tomoa'ina 'aromiai tomobuana mai here'uai 'iobi katoa'ina pokina au hanona ao 'amari mai 'aiaunu hau'u. Weiana wai aubami katearai. ");
INSERT INTO rro_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Pokina e'u iebebe hanona e'ama'ama mai e'u buabua hanona a'i epuma.” ");
INSERT INTO rro_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Rani weiana beraura robenai Iesu witi umana aonai ekabanai. I'abana haukia mare'a te'ari buonai witi buakia te'ini huri teani. ");
INSERT INTO rro_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Parisea haukia babai weiana teihana raninai Iesu tehinabena tetibaha, “Moihana, oi i'abamu haukia hanona beraura robenai taba a'i katebabaina hauna tibabaina.” ");
INSERT INTO rro_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Iesu ekia 'abi ebamuena etibaha, “Wai, Davida te'abana haukia kipokia mare'a te'ari aonai taba ebabaina hauna a'i totuabina? ");
INSERT INTO rro_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ia Tirama ena ituai etoto, weia parawa robena ea'ina, parawa weiana hanona erobe, robe haukia ikupaiakia mo kateana hauna, ia mai te'abana haukia kipokia teana. ");
INSERT INTO rro_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Haeamona robe haukia marea robe aonai beraura robe akana tibabai ki'ana iamo a'i tibeho, rauhubuna weiana a'i totuabina? ");
INSERT INTO rro_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Au wai nahinabenimi, hau ha neia hauna ehore marea robe etara haona. ");
INSERT INTO rro_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","‘Au nanuatae aoko'o, ia a'i nanuatae baibeni tabakia.’ Hos 6.6 Puka robenai 'abi neiakia anikia pato'iobi raninai maearima a'i tebeho haukia behoai a'i katohorotinakia. ");
INSERT INTO rro_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Pokina au Maearima nahuna hanona beraura robe obiana.” ");
INSERT INTO rro_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Iesu 'eka weiana ehabona eao ekia marea ha aonai etoto, ");
INSERT INTO rro_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","hau ha imana kobekobena abomo weia, maearima baika taeara tetabu Iesu beho 'ekanai katehorotina, ba Iesu tebakaina tetibaha, “Beraura robenai inawa kahabanamo hanona behona aha'i?” ");
INSERT INTO rro_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Iesu ehinabenakia etibaha, “Wai ha emu mamoe beraura robenai 'uriai petoa raninai a'i poa'i 'auna, u? ");
INSERT INTO rro_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Maearima hanona mamoe etara haona. Ua buonai beraura robenai namo kahababaina hanona ebero.” ");
INSERT INTO rro_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ba Iesu hau weiana ehinabena etibaha, “Imamu motiu berona.” Weiana imana etiu berona hanona maikoina enamo ihobona imana abihana 'abana. ");
INSERT INTO rro_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","'A Parisea haukia tekarahi teao teroba ahu aea katehoma Iesu kateahu'arina. ");
INSERT INTO rro_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Iesu aba e'iobina paunai 'eka weianai ekapare. Maearima bo'ona 'akina murinai te'au, ekia inawa ikoikiai ebanamonakia, ");
INSERT INTO rro_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ehara abunakia tai ha haianai a'i kate'abi ia hanona tai. ");
INSERT INTO rro_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Neiana hanona Isaia mahabanai hauna ehinana 'abina ibatohana. ");
INSERT INTO rro_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","‘Tomoihana ia hanona atina'ana e'u ta'ara'i hauna, naraona'au aina mai naonamo aina. Au e'u Auba Robe ia ahanai kahorotina, bero keiroroaina hanopaka haukia herekiai. ");
INSERT INTO rro_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ia hanona a'i kebaihara tae 'ao a'i keio abomo aiana aiara ibuakiai a'i kateona. ");
INSERT INTO rro_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ia hiribo aba nimohu hauna matoha 'abe'abe haukia 'abana ia a'i kebamohu hurina, abomo baubaea aba ni'ao hauna matoha ekia buabeni e'aera 'aera haukia 'abana ena buabeni a'i keba'aona keaomo bero akana kebawaira tinana. ");
INSERT INTO rro_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Hanopaka maearimakia ikoikiai ekia buabeni ia atana ahanai katehorotinakia.’ ");
INSERT INTO rro_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Hau ha aonai auba ki'a obona emiaho hauna temaiaina Iesu herena ia hanona mahana teki'a mai maeana eki'a, Iesu ehore ebanamona, weiana ia e'abi'abi mai eihaiha mue. ");
INSERT INTO rro_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Maearima ikoikiai teta'u ta'u huri tetibaha, “Pa'e hau neiana hanona Davida Nahuna.” ");
INSERT INTO rro_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","'A Parisea haukia pou neiana teona raninai te'abi tetibaha, “Neiana hanona auba ki'a obokia ekia poki Belesebulo ena hiabuai auba ki'a obokia naiakia neu'u ahinakia.” ");
INSERT INTO rro_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Iesu ekia raona e'iobina buonai ehinabenakia etibaha, “Hanopaka ha kipona kebapa'ana kate'au hanona ke'iti'iti, mai aiara ha kipona 'ao itubu ha kipona kebapa'ana kate'au raninai kekori 'ini hanona a'i ketaina. ");
INSERT INTO rro_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ba Satani kehore Satani keu'u ahina raninai ia hanona kipona nibapa'ana, weiana ena hanopaka hanona aea kekori 'ini aiho? ");
INSERT INTO rro_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Au Belesebulo hiabunai auba ki'a obokia nau'u ahinakia raninai tai 'eunai wai emi maearima auba ki'a obokia ṯeu'u ahi? Ua buonai emi maearima katehore behoai katehorotinimi. ");
INSERT INTO rro_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","'A au Tirama ena Auba hiabunai auba ki'a obokia nau'u ahinakia raninai weiana Tirama ena obia aiarana hanona aba emai wai heremiai. ");
INSERT INTO rro_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Hau ha tabura hauna ena itu a'i keahu pa'ana ena taba a'i kea'i parenakia keaomo ia tabura hauna kea'ina kebiri 'uaina, ba ena taba kebainao ainakia. ");
INSERT INTO rro_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Maearima ha tai'u a'i nitai hauna hanona au ni'oatana'u, mai maearima ha au tararua a'i ṯabararo bararo hauna hanona nikapo kapo otarai. ");
INSERT INTO rro_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Weiana buonai au wai nahina benimi, maearima ekia aka ki'a mai ekia 'abi ki'a ikoikiai hanona kehina hao ketaina, ia Auba Robe herenai e'abi ki'a hauna hanona a'i kehina hao 'apuana. ");
INSERT INTO rro_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Hau ha ke'abi ki'a Maearima nahuna herenai hanona kehina hao ketaina, 'a hau ha Auba Robe herenai ke'abi ki'a hauna hanona a'i kehina hao 'apuana bariu mauri neianai mai mauri wairai abomo. ");
INSERT INTO rro_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Matiu namonai hanona buabua namokia katerama, matiu ki'a obonai hanona buabua ki'a obokia katerama, pokina matiu aea homana hanona buabuanai i'iobina nirama. ");
INSERT INTO rro_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","'Erau nahukia e, emi raona teki'a aeahomanai mo 'abi namokia katohina? Pokina pina hanona aoai taba ebonu hauna nehinana. ");
INSERT INTO rro_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Hau namona aonai taba namokia euta haukia namokia nibakarahi, hau ki'a obona aonai taba ki'a obokia euta haukia ki'a obokia nibakarahi. ");
INSERT INTO rro_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Au wai nahinabenimi, maearima ikoinai te'abi 'abaea haukia ikoikiai Tirama ena bakai berauranai 'ara katebaibeni toha. ");
INSERT INTO rro_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ua buonai emu 'abi kehore bero kebeni'o abomo emu 'abi kehore puma kebeni'o.” ");
INSERT INTO rro_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ba Parisea haukia mai rauhubu poki haukia baika Iesu tehinabena tetibaha, “Ba'iobi haumu e, ai ṯanuatae oi heremuai hiabu hoana ha pobabaina pataihana.” ");
INSERT INTO rro_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Iesu ekia 'abi ebamuena etibaha, “Uru neiana ki'a obona mai a'ikakauma aha'i haumi, aehoma buonai hiabu hoana tubakai bakai aina? Ia hoa kabenimi hauna hanona mahabanai hauna Iona mo ena hoa. ");
INSERT INTO rro_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Iona mararani aihau mai rabi aihau maia apa'uana nuana aonai emiaho, ihobona mo au maearima nahuna abomo mararani aihau mai rabi aihau hano aonai kamiaho. ");
INSERT INTO rro_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Bakai ranina kemai Nineba maearimakia uru neiana haumi beho 'ekanai katehorotinimi, pokina Iona ena iroroai teraona kabe. Ia bariu Iona etara haona hauna hanona neia. ");
INSERT INTO rro_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ahitaina hanopakana obia babi'ena bakai 'ekanai kemikiri uru neiana haumi beho 'ekanai kehorotinimi, pokina ia hanopaka puanai emai Solomon ena aobero 'abikia eo'o. Ia bariu Solomon etara haona hauna hanona neia.” ");
INSERT INTO rro_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Auba ki'a obona hau ha aonai ekarahi raninai eao hano 'ororonai ekaoao 'eka etabu kearai, ia 'eka ha a'i etabu ahina, ");
INSERT INTO rro_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ba kipona e'abi etibaha, ‘Au hanona kamue e'u itu ahabona hauna kaeao’, weiana emue eao itu 'abaeana etabu ahina aba tetarona mai e'oru harai. ");
INSERT INTO rro_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ba ekarahi eao 'abana baika 'abaihau hamomo teki'a ki'a baha haukia emaiainakia tetoto weia temiaho. Hau weiana 'uainai ena miaho eki'a, ia bariu hanona eki'a ki'a baha. Weiana hanona uru ki'a obona neiakia haukia herekiai ua kerama aiho.” ");
INSERT INTO rro_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Iesu maearima nehinabe ohonakia aonai hinana mai uaho'abana tekara'au. Mahanai tekoroti tenuatae Iesu kipokia kate'abi'abi. ");
INSERT INTO rro_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Hau ha ia ehinabena etibaha, “Hinamu mai uaho'abamu hanona mahanai tekoroti, oi ṯenuatae aini'o kato'abi'abi.” ");
INSERT INTO rro_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Iesu ia ena 'abi ebamuena etibaha, “Tai hauna au hina'u, mai tai haukia au uaho'aba'u?” ");
INSERT INTO rro_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Imana etiu i'abana haukia e'uahinakia etibaha, “Neiakia haukia hanona au hina'u mai au uaho'aba'u. ");
INSERT INTO rro_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Pokina maearima ha au Hama'u kupai nemiaho hauna ena nuatae nibabaina hauna hanona au uaho'aba'u, haibu'u mai hina'u.” ");
INSERT INTO rro_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Beraura hamona weianai Iesu ituai ekarahi eao 'obu poenai emiati. ");
INSERT INTO rro_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Herenai to'u eapa'ua ki'a baha buonai emikiri ahi hai ehe'au emiati, maearima ikoikiai hanona poeai tekoroti. ");
INSERT INTO rro_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ba ia ehore taba bo'ona 'abi ibabataiai ehinanakia etibaha, “Biraura hauna ha ekarahi eao ena umai uho kebatonakia. ");
INSERT INTO rro_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ena uho ekapo kapo otarainakia aonai, baika hanona taearai te'eho, weiana roborobo temai teani orenakia. ");
INSERT INTO rro_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Baika bohuai te'eho, te'omu noanoa pokina hano enibinibi. ");
INSERT INTO rro_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ba beraura ekara'au raninai hubukia tepaea abomo te'ororo pokina ramukia aha'i. ");
INSERT INTO rro_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Uho baika 'ini boaboa aokiai te'eho, ia 'ini boaboa te'omu tetara tara abunakia. ");
INSERT INTO rro_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","'A uho baika hano namonai te'eho. Weiana buakia terama baika hanona hinabu hamomo, baika imabui harauhaea, mai baika harau aihau. ");
INSERT INTO rro_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Mai haiana hauna aia keona.” ");
INSERT INTO rro_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ba i'abana haukia temai Iesu herena tebakaina tetibaha, “Taba buonai maearima 'abi ibabataiai ṉohina benakia?” ");
INSERT INTO rro_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Iesu ekia 'abi ebamuena etibaha, “Tirama ena obia aiarana aotipana bunikia hanona aba heremiai tewaira tina, 'a ia herekiai hanona aha'i. ");
INSERT INTO rro_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Pokina maearima ha mai 'euna hauna bo'ona katebena, weiana ia 'euna hanona kebo'o harai. Maearima ha 'eunai aha'i hauna herenai papana nemiaho hauna abomo katea'i boina. ");
INSERT INTO rro_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","'Abi ibabataiai nahina benakia ena poki hanona neiana, kateihana mo ia a'i kateiha tinana, katebahu mo ia aia a'i kateona mai obona a'i kateobo. ");
INSERT INTO rro_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ua buonai 'eka neianai Isaia ena mahabanai 'abina hanona emai etohana, ‘Wai aia katobahu ai 'arimo ia obona a'i katobo, wai katoiha to'o baihana mo ia a'i katoiha tinana. ");
INSERT INTO rro_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Weiana hanona maearima neiakia aokia tewapura, haiakia te'ou abunakia mai mahakia tekaiabunakia, pokina mahakiai a'i temeihaiha, haiakiai aia a'i temeo'o, aokiai obo a'i temeobo, a'i temeraona kabe here'uai, a'i mabamaurinakia paunai.’ ");
INSERT INTO rro_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Wai hanona Tirama nibanamonimi, pokina mahamiai ṯoiha mai haiamiai aia tuo'o. ");
INSERT INTO rro_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","'Abi tohana au nahina benimi, mahabanai haukia mai bero haukia bo'okia tenuatae ki'a baha taba ṯoiha haukia pateiha, ia a'i teiha, mai taba wai tuo'o haukia pateo'o, ia a'i teo'o.” ");
INSERT INTO rro_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Ba tomobahu 'abi ibabataiai batobato anina hanona taba. ");
INSERT INTO rro_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Hau ha Tirama ena obia aiarana 'abina pouna niona 'a obona a'i niobo aonai tiaporo nimai taba aonai tebatona hauna nia'i parena. Neiana hanona uho weiakia taearai te'eho 'abakia. ");
INSERT INTO rro_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Uho bohu ahanai e'eho hanona hau ha Tirama ena 'abi aiana niona mai aonamona nia'i taea noanoana. ");
INSERT INTO rro_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ia ramuna a'i teriri harai buonai a'i nemiaho homa'ana. Tirama ena 'abi weiana paunai atetua 'ao bai'oata timai raninai beronai mo ni'eho. ");
INSERT INTO rro_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ba uho 'ini boaboa baiatakiai e'eho hanona hau ha Tirama ena 'abi aiana niona 'a hanopaka aoanina mai kepu raonaraonakia tihore 'abi weiana tita'a ta'a abuna ba a'i nebua'a. ");
INSERT INTO rro_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","'A uho hano namonai e'eho hanona hau ha Tirama ena 'abi aiana niona mai obona niobo. Ia hanona nebua'a buabuana hinabu hamomo nibarama, baika imabui harauhaea, mai baika harau aihau.” ");
INSERT INTO rro_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Iesu 'abi ibabatai ha herekiai ehinana. “Tirama ena obia aiarana hanona matoha hau ha uho namokia ena umai ebatonakia. ");
INSERT INTO rro_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","'A maearima ikoikiai teparua rea aonai, ena 'ou hauna emai witi baiatakiai awa ebatonakia ba eka'a. ");
INSERT INTO rro_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Witi te'omu buakia tekapo ahi raninai, awa abomo tekere. ");
INSERT INTO rro_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Poki hauna ena ta'ara'i haukia temai herena te'abi tetibaha, ‘Poki haumu e, oi emu umai uho namokia obatonakia, ia awa hanona ae'eai temai?’ ");
INSERT INTO rro_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ia ekia 'abi ebamuena etibaha, ‘'Ou hauna ha naiana ebabaina.’ Ena ta'ara'i haukia tetibaha, ‘Nonuatae kataeao awa katapuhu 'aunakia?’ ");
INSERT INTO rro_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ia e'abi etibaha, ‘Aha'i, pokina awa katopuhu 'aunakia raninai witi abomo awa kipokia a'i tomopuhu 'aunakia marikina. ");
INSERT INTO rro_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Tomohabonakia terarua teme'omu haeamo keaomo witi iarikia ranina. Rani weianai hanona iarina haukia kahina benakia, “Awa tomobararo 'uainakia katotoba 'ininakia kate'ara, ba witi kato bararonakia katomaiainakia e'u paraboa aonai.” ’” ");
INSERT INTO rro_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Iesu 'abi ibabatai ha herekiai ehinana. “Tirama ena obia aiarana hanona matoha tuaba uhona 'abana. Weiana hau ha ea'ina ena umai ebatona. ");
INSERT INTO rro_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Uho ikoikiai baiatakiai ia hanona e'aera 'aera 'aki, iamo eomu raninai ia hanona eapa'ua ba umai batobato tabakia ikoikiai eberenakia, matiu hai eao ubi roborobokia timai weia kakanai tiarai.” ");
INSERT INTO rro_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Iesu 'abi ibabatai ha haeamona ehinana. “Tirama ena obia aiarana hanona matoha bakupu muramurana 'abana. Babi'e ha bakupu mura murana ea'ina pani rarina aonai parawa bo'ona kipokia eu banai eu banaina eaomo parawa maikoina ekupu.” ");
INSERT INTO rro_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Iesu 'abi neiakia ikoikiai to'u haukia ehinabenakia hanona 'abi beronai a'i ehina benakia, ia 'abi ibabataiai mo ehinabenakia. ");
INSERT INTO rro_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Neiana hanona mahabanai hauna ehinana hauna nibatohana. “Ka'abi benakia raninai 'abi ibabataiai kahina benakia, hanopaka erama raninai emai mo bariu taba bunikia haukia au kahore kahina pounakia.” ");
INSERT INTO rro_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ba mako ehabonakia eao itu aonai etoto, i'abana haukia temai herena te'abi tetibaha, “'Abi ibabatai neiana awa uma aonai hauna heremaiai mohina hina haraina.” ");
INSERT INTO rro_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Iesu e'abi etibaha, “Weiana uho namona ebatona hauna hanona au maearima nahuna. ");
INSERT INTO rro_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Uma hanona hanopaka, uho namokia hanona Tirama ena obia aiarana maearimakia, awa hanona hau ki'a obona ena maearima. ");
INSERT INTO rro_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","'Ou hauna weiana awa ebatonakia hauna hanona tiaporo. Iarina ranina hanona hanopaka puana, ariari haukia hanona aneru. ");
INSERT INTO rro_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Awa ipuhu 'au ibararo irubai kate'ara ihobona hanona hanopaka puanai kerama. ");
INSERT INTO rro_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Au maearima nahuna e'u aneru kauhu ahinakia e'u aiara aonai beho tibaramana haukia mai aka ki'a tibabai haukia ikoinai katebararonakia. ");
INSERT INTO rro_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ia katehore iruba a'i ni'ao 'apua 'ekana aonai katekapo totonakia, weia katehai mai 'aki'akikia katearao'i arao'i. ");
INSERT INTO rro_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ba bero haukia hanona Hamakia ena obia aiarana aonai katea matoha beraura 'abana. Mai haiana hauna aia keona. ");
INSERT INTO rro_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Tirama ena obia aiarana hanona matoha kepu namona uma aonai ihore buni 'abana. Hau ha etabu ahina raninai ehore buni muena, mai aonamona eao ena taba maikoinai ekawa kawa ainakia moninai hano weiana mai umana ekawana. ");
INSERT INTO rro_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Haeamona Tirama ena obia aiarana hanona matoha kawakawa hauna ha hoea raia namona nitabuna 'abana. ");
INSERT INTO rro_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ba hoea raia namona 'akina ha etabu ahina raninai, ia eao ena taba maikoinai ekawa kawa ainakia moninai hoea raia weiana ekawana. ");
INSERT INTO rro_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Abomo Tirama ena obia aiarana hanona matoha re'e 'obuai tehorena weiana maia haeai haeai terewa 'abana. ");
INSERT INTO rro_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ba'eha haukia re'e ebonu raninai teberi 'auna poeai, ba temiati maia namokia pohea aonai teutanakia, 'a ki'a obokia hanona tene'enakia. ");
INSERT INTO rro_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Hanopaka ena puai hanona ua kerama aiho. Aneru katemai bero haukia mai ki'a haukia katebina'anakia. ");
INSERT INTO rro_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ki'a haukia hanona iruba a'i ni'ao 'apua 'ekana aonai katekapo totonakia, weia katehai mai 'aki'akikia katearao'i arao'i.” ");
INSERT INTO rro_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ba Iesu ebakainakia etibaha, “'Abi neiakia ikoikiai obokia aba tuobo?” Ena 'abi tebamuena tetibaha, “'E, obokia aba ṯaobo.” ");
INSERT INTO rro_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ia ehina benakia etibaha, “Weiana paunai rauhubu poki haukia weiakia Tirama ena obia aiarana pouna aba te'iobina haukia ha ha hanona matoha itu poki hauna 'abana, ena ro'aro'a ikaihurinai kepu mahamahakia mai 'ai'aikia nia'i ahinakia.” ");
INSERT INTO rro_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Iesu 'abi ibabatai neiakia ehinanakia murinai 'eka weiana ehabona, ");
INSERT INTO rro_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","emai ena aiarai marea aonai maearima eba'iobinakia hanona teta'u ta'u huri. Tebakai bakai tetibaha, “Hau neiana aobero mai hiabu akakia neiakia ae'eai ea'inakia? ");
INSERT INTO rro_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ia hanona kamuta hauna nahuna tohana, ia hinana atana Maria, uaho'abana hanona Iakobo, Iosepa, Simona mai Iuda. ");
INSERT INTO rro_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Haibuna ikoikiai hanona neia kipokia nahamiaho. Ba hau neiana taba neiakia ikoikiai ae'eai ea'inakia?” ");
INSERT INTO rro_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Weiana ia tehore Iesu tebaki'ana. 'A Iesu ia ehina benakia etibaha, “Mahabanai hauna hanona katemariki aina, ia ena aiarai mai ena itu haukia hanona a'i katemariki aina.” ");
INSERT INTO rro_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Weiana ekia a'ikakauma aha'i paunai hiabu hoakia bo'okia weia a'i ebabai. ");
INSERT INTO rro_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Rani weianai obia 'arana Herod hanona Galilea epoki aina aonai Iesu pouna eona. ");
INSERT INTO rro_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ba ena aka haukia ehinabenakia etibaha, “Ioane ba'uere robe hauna ahu'arina hauna 'ariai emue emai, weiana buonai hiabu akakia neiakia ia aonai tiaka.” ");
INSERT INTO rro_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","'Uaina raninai Herod hanona uaho'abana Pilipo atawana Herodia eatawana. Ba Ioane ba'uere robe hauna rani ikoinai Herod ehinabena etibaha, “Babi'e neiana oatawana hanona a'i ebero.” Weiana paunai Herod 'abi ebaibeni Ioane tebirina wapura itunai tekaiabuna. ");
INSERT INTO rro_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herod ena nuatae Ioane keahu 'arina, ia maearima eta'u ainakia, pokina ia hanona mahabanai haunai tebaona. ");
INSERT INTO rro_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Rani ha Herod ena rama beraurana tatunai Herodia nahuna uahona to'u wairakiai ewa, ba Herod aona ebaonamo ki'ana. ");
INSERT INTO rro_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Weiana Herod e'abi'uai uaho herenai, ena 'abi'uai taburana ehinana weiana taba kenoiaina hauna kebena mo. ");
INSERT INTO rro_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Hinana ena 'abiai uaho Herod enoina etibaha, “Bariu mo Ioane ba'uere robe hauna arana tihuai koutana kobena'u.” ");
INSERT INTO rro_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Obia 'arana hauna aona earo'ari. Ia ena 'abi'uai baki haukia wairakiai ehinana hauna paunai, 'abi ebaibeni uaho ena noi akana katebabaina. ");
INSERT INTO rro_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Weiana euhunakia wapura ituna aonai Ioane 'akona tekabe hurina. ");
INSERT INTO rro_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ioane 'arana tihu aonai teutana temaiaina uaho tebena, ba uaho eaoaina hinana ebena. ");
INSERT INTO rro_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ioane i'abana haukia temai hauanina tea'ina teaoaina tehorena. Ba teao Iesu teba'iobina. ");
INSERT INTO rro_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Iesu pou weiana eona raninai ahiai ehe'au ikupaiana eao 'eka 'abaeana ha, maearima bo'ona 'uru neiana teona hanona ekia aiarai aekiai Iesu murinai teao. ");
INSERT INTO rro_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Iesu ahiai eriri raninai to'u rarina eihana eaoko'o ainakia mai ekia inawa ebanamonakia. ");
INSERT INTO rro_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Aba erabirabi aonai i'abana haukia teao Iesu herena te'abi tetibaha, “Neiana hanona 'eka 'abaeana mai aba kerabi. To'u haukia mouhunakia temeao, aiara baika aokiai kipokia ekia aniani temekawa hanona kenamo.” ");
INSERT INTO rro_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Iesu e'abi etibaha, “Ia hanona a'i kauhunakia, wai taba ha katobenakia kateani.” ");
INSERT INTO rro_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","I'abana haukia te'abi tetibaha, “Ai heremaiai hanona parawa ima mai maia rua 'akimo.” ");
INSERT INTO rro_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Iesu e'abi etibaha, “Tomaiainakia here'u.” ");
INSERT INTO rro_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ba maearima ehina benakia tubu ahanai katemiati, weiana parawa ima mai maia rua ea'inakia ea'a taea kupa Tirama ebanamona ba parawa ehobinakia, i'abana haukia ebenakia teaoai maearima tebenakia. ");
INSERT INTO rro_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ia ikoikiai teaniani teani 'ari, i'abana haukia aniani harikia tebararo areha ikoinai harauhaea rua tebabonunakia. ");
INSERT INTO rro_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Weiakia teaniani haukia hanona taha ima (5,000) 'abana, hau mo tetuabinakia babi'e mai miori hanona a'i tetuabinakia. ");
INSERT INTO rro_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Weiana murinai Iesu beronai i'abana haukia ahiai ebaehe 'aunakia kate'uai kateao obu abiranai, aonai ia hanona maearima euhunakia kateka'a. ");
INSERT INTO rro_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Maearima euhunakia teka'a murinai, ia ikupaiana oeo ha ai ekara'au kebahuba'ari. Rabi emai aonai ia hanona ikupaiana weia. ");
INSERT INTO rro_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","'A ahi hanona aba ekarahi 'akaumana obu kapenai, roio niahuao ahuaona pokina baura hanona wairakiai emai. ");
INSERT INTO rro_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Raurani wapuranai kokoro'u ibaihauna ni'arara ihobonai Iesu bei kapenai eka'a eao herekia. ");
INSERT INTO rro_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","I'abana haukia Iesu bei kapenai eka'a teihana raninai teta'u ki'a, mai ta'ukia teio tetibaha, “'Ei, biriua.” ");
INSERT INTO rro_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Iesu beronai mo ehina benakia etibaha, “Tomobakiro, ṉa au, a'i katota'u.” ");
INSERT INTO rro_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ba Petero etae e'abi etibaha, “Obiapaka e, oi tohamu raninai mo'abi, bei kapenai mawahi heremu.” ");
INSERT INTO rro_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Iesu e'abi etibaha, “'Omai.” Weiana Petero ahiai eriri bei kapenai eka'a ha ha Iesu herena eao. ");
INSERT INTO rro_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","'A roio rarina eihana raninai eta'u, beiai nepurupuru aonai eio etibaha, “Obiapaka e, mobamaurina'u!” ");
INSERT INTO rro_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Beronaimo Iesu imana etiu ahina Petero ea'ina ehinabena etibaha, “Emu a'ikakauma e'aera haumu, taba buonai aomu ekai'au kai'au?” ");
INSERT INTO rro_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ba terarua ahi ahanai tehe'au hanona baura e'oko. ");
INSERT INTO rro_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","I'abana haukia weia ahi aonai haukia Iesu tekutiaina te'abi tetibaha, “'Abi tohana oi hanona Tirama Nahuna.” ");
INSERT INTO rro_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Obu tebeau banai temai Genesareta hanonai tekara'au. ");
INSERT INTO rro_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","'Eka weiana haukia Iesu teiha 'iobi aina hanona 'abi teuhuna eao aiara weiakia herekiai haukia herekia, ba maearima weiakia ekia inawa haukia ikoikiai temai ainakia herena. ");
INSERT INTO rro_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Maearima Iesu tenoina inawa haukia ena habuni puana mo patea'i 'apuana. Ba tea'i 'apuana haukia ikoikiai hanona tenamo. ");
INSERT INTO rro_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Rani weianai Parisea haukia mai rauhubu poki haukia baika Ierusalemai temai Iesu herena tebakaina tetibaha, ");
INSERT INTO rro_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Aehoma buonai i'abamu haukia 'ai'ai ekia hoahoa tikabenakia? Imakia a'i ṯeutu 'uai, ia tianiani mo.” ");
INSERT INTO rro_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Iesu ekia 'abi ebamuena etibaha, “Aehoma buonai wai Tirama ena rauhubu 'abina tukabena, ia emi 'ai'ai ekia hoahoa tua'i taeanakia? ");
INSERT INTO rro_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Pokina Tirama e'abi etibaha, ‘Hamamu mai hinamu komariki ainakia,’ abomo ‘Hau ha hamana 'ao hinana keururu aina hauna hanona kateahu 'arina.’ ");
INSERT INTO rro_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ia wai hanona emi ba'iobiai tu'abi ṯotibaha, ‘Hau ha hamana 'ao hinana kehina benakia ketibaha, “Kepu neiakiai pabarainimi haukia hanona kabaibeni Tirama 'euna.” ");
INSERT INTO rro_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ba hau weiana hanona hamana mai hinana kohu weianai a'i kemariki ainakia.’ Taeara ṉahomanai wai Tirama ena 'abi taba aha'iai tubaona, ia 'ai'ai ekia hoahoa mo tua'i taeanakia. ");
INSERT INTO rro_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Bahaorea haumi e, Isaia emahabanai harai wai ahamiai e'abi etibaha, ");
INSERT INTO rro_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Maearima neiakia hanona pinakia kapenai mo ata'u tibanamona, 'a aokia hanona atau'a 'akinai. ");
INSERT INTO rro_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ṯekutiai 'abaeana'u, pokina tiba'iobi rauhubukia hanona maearima ekia rauhubu 'abikia mo.” ");
INSERT INTO rro_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Iesu mako eaparinakia teao herena, ehinabenakia etibaha, “Katobahu abomo obona katobo. ");
INSERT INTO rro_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Taba pinai nitoto niao aoai hauna hanona Tirama wairanai maearima a'i niba 'opuna, ia taba pinai nikarahi hauna maearima niba'opuna.” ");
INSERT INTO rro_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ba i'abana haukia temai herena tebakaina tetibaha, “Parisea haukia aiamu teona raninai aokia teopuere hanona o'iobina?” ");
INSERT INTO rro_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ekia 'abi ebamuena etibaha, “Matiu ikoikiai Hama'u kupai nemiaho hauna a'i ebatonakia haukia mai ramukia kepuhu 'aunakia. ");
INSERT INTO rro_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Tomohabonakia. Ia mahakia teki'a ba maha ki'a haukia ṯe'uai ainakia. Maha ki'a hauna ha kehore maha ki'a hauna ha kebaka'ana raninai terarua 'uriai katetoa.” ");
INSERT INTO rro_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ba Petero e'abi etibaha, “'Abi ibabatai neiana anina mohina hina haraina heremaiai.” ");
INSERT INTO rro_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Iesu ia ehina benakia etibaha, “Wai abomimo obo a'i tuobo oho mo? ");
INSERT INTO rro_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Taba ikoikiai pinai titoto tiao mo'oru haukia haeamona mo'oruai tikarahi timai atapakai hanona a'i ṯo'iobina? ");
INSERT INTO rro_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","'A taba pinai tikarahi haukia hanona aoai timai tikarahi, ba weiakia haukia tihore maearima tiba'opuna. ");
INSERT INTO rro_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Weiana aoai nikarahi hauna hanona raona ki'a obokia maearima niao ainakia kateahuahu, katenabau, katemaha porepore, katebainao, katebai'oi mai kate'uahi 'uahi. ");
INSERT INTO rro_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Hoahoa weiakia haukia maearima tiba'opuna Tirama wairanai, ia imaka a'i nahautu nahaniani hauna maearima a'i niba'opuna.” ");
INSERT INTO rro_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Iesu 'eka weiana ehabona Turo mai Sidono hanokia eao. ");
INSERT INTO rro_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","'Eka weianai Kanana babi'ena ha emai herena ba eapari etibaha, “Obiapaka Davida Nahuna e, moaoko'o aina'u, auba ki'a obona nahu'u uahouahona aonai nibahaiara ki'a bahana.” ");
INSERT INTO rro_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","'A Iesu babi'e ena 'abi a'i ebamuena, ba i'abana haukia Iesu tenoi hao noi haona tetibaha, “Mouhuna mekatu'a, pokina ia murikai nimai niapari to'ona.” ");
INSERT INTO rro_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Iesu e'abi etibaha, “Tirama au euhuna'u hanona Isaraela mamoekia te'akauma haukia mo paukiai.” ");
INSERT INTO rro_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Babi'e emai Iesu wairanai ekai pehu, e'abi etibaha, “Obiapaka e, mobaraina'u.” ");
INSERT INTO rro_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Iesu babi'e ena 'abi ebamuena etibaha, “Miori ekia aniani kahane'ena waeha kateani hanona a'i enamo.” ");
INSERT INTO rro_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Babi'e etibaha, “'Abi tohana, ia mo obia hauna ena itara ai, aniani 'ika'ikakia ti'eho ba'ai hanona waeha abomo tiani.” ");
INSERT INTO rro_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ba Iesu ia ehinabena etibaha. “Babi'e e, emu a'ikakauma hanona eapa'ua, emu nuatae tabana hanona kerama.” Beraura hoana ihobonai nahuna uahouahona emauri mauri. ");
INSERT INTO rro_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Iesu 'eka weiana ehabona, Galilea obu poena ekana eao, ba oeoai ekara'au emiati. ");
INSERT INTO rro_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Mako rarina temai herena, temaiainakia haukia hanona 'ome, maha ki'a, ima kobekobe, maeakia teki'a, abomo inawa haukia haeaihaeai Iesu herenai tehorotinakia, ba ia ehore eba maurinakia. ");
INSERT INTO rro_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Maeakia teki'a haukia te'abi 'abi, ima kobekobe haukia imakia tebero, 'ome haukia teka'a, mahakia teki'a haukia teihaiha. Maearima hoa neiakia teihanakia raninai teta'u ta'u huri, weianai Isaraela ena Tirama tebanamona. ");
INSERT INTO rro_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Rani weianai Iesu i'abana haukia eaparinakia temai herena, ehina benakia etibaha, “Au maearima neiakia ṉaoko'o ainakia, pokina ia hanona aba wapu aihau au here'uai ṯemiaho taba ha a'i tiana, mai mare'akia kauhunakia kateka'a hanona a'i nanuatae, pokina ha taearai mare'a a'i meba'ehona.” ");
INSERT INTO rro_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","I'abana haukia te'abi tetibaha, “Neiana hanona hano 'abaeana, aniani ae'eai kata'inakia mako nahomana katabanianina?” ");
INSERT INTO rro_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Iesu ebakainakia etibaha, “Aniani heremiai bita?” Ia te'abi tetibaha, “Parawa 'abaihau hamomo mai maia papakia bita 'aki mo.” ");
INSERT INTO rro_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Iesu ehore to'u haukia ehina benakia 'anoai katemiati. ");
INSERT INTO rro_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ba parawa 'abaihau hamomo mai maia ea'inakia Tirama ebanamona, epua ehobi 'iti 'itinakia, i'abana haukia ebenakia ba i'abana haukia maearima tebenakia. ");
INSERT INTO rro_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Maearima ikoikiai teanaiani teani'ari, i'abana haukia aniani harikia areha 'abaihau hamomo tebabonunakia. ");
INSERT INTO rro_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Weia teaniani haukia tetuabinakia hanona 4,000, 'a babi'e mai miori hanona a'i tetuabinakia. ");
INSERT INTO rro_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Iesu to'u haukia euhunakia teka'a murinai ahiai ehe'au ebeau banai Magadan hanona eao. ");
INSERT INTO rro_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Parisea haukia mai Sadukea haukia temai Iesu herena tehobona, tenoina hoa ha keba ihanakia katebatohana ia hanona kupai emai. ");
INSERT INTO rro_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Iesu ehinabenakia etibaha, “Rabirabi beraura kaihu niaoaina raninai, tu'abi ṯotibaha, ‘Mara rani kenamo pokina kupa nipairu.’ ");
INSERT INTO rro_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kerani raurani tu'abi ṯotibaha, ‘Bariu rani neianai abara mai baura katemai pokina kupa nipairu auhao ekaiabu haraina.’ To'iobina kupai hoa tabakia katerama, ia aehoma buonai rani neianai hoa tabana kerama hauna a'i to'iobina? ");
INSERT INTO rro_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","A'ikakauma aha'i mai aka ki'a uruna haumi, hoa tutabu, ia hoa ha a'i kabenimi, mahabanai hauna Iona ena hoa mo kabaihanimi.” Ba Iesu ehabonakia herekiai ekaobo. ");
INSERT INTO rro_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Weiana i'abana haukia tekabanai obu abiranai raninai parawa tereanakia a'i tea'i. ");
INSERT INTO rro_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ba Iesu ehina benakia etibaha, “Mahami katoba no'a, Parisea haukia mai Sadukea haukia ekia bakupu muramurana herenai kato'ima 'ima harainimi.” ");
INSERT INTO rro_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","I'abana haukia kipokia te'abi'abi tetibaha, “'Abi neiana nehinana pokina parawa ha a'i hamaiaina.” ");
INSERT INTO rro_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Iesu ekia raona e'iobina ba ehina benakia etibaha, “A'ikakauma papana haumi e, aehoma buonai kipomi parawa ha a'i toa'ina hauna paunai tu'abi'abi? ");
INSERT INTO rro_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Aomi a'i niea baha parawa ima 'aki maearima taha ima (5,000) teani'ari mai harikia areha bita tobabonu hauna a'i turaona 'inina? ");
INSERT INTO rro_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Abomo parawa 'abaihau hamomoaimo maearima taha bani (4,000) teani'ari, harikia areha bita tobabonu haukia a'i toraona'ini? ");
INSERT INTO rro_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Aehoma buonai aomi a'i niea? Au hanona parawa robana a'i nahuna, ia Parisea haukia mai Sadukea haukia ekia bakupu muramurana herenai kato'ima'ima harainimi.” ");
INSERT INTO rro_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","'Abi weianai aokia ea, te'iobina ia hanona parawa ibakupuna muramurana robana a'i niahuna 'a ia hanona Parisea haukia mai Sadukea haukia ekia ba'iobi 'abikia herekiai kate'ima'ima harainakia. ");
INSERT INTO rro_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Iesu Kaisarea Pilipo hanokiai ekara'au aonai, i'abana haukia ebakainakia etibaha, “Maearima taba ṉa tihoma, au maearima nahuna hanona tai?” ");
INSERT INTO rro_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ena 'abi tebamuena tetibaha, “Baika ti'abi Ioane ba'uere robe hauna, baika ti'abi Elia, haeamona baika ti'abi Ieremia 'ao mahabanai hauna ha.” ");
INSERT INTO rro_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Iesu haeamona ebakai muenakia etibaha, “Ia wai taba ṉa tuhoma, au hanona tai?” ");
INSERT INTO rro_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simona Petero e'abi etibaha, “Oi hanona Keriso, mauri Tiramana Nahuna.” ");
INSERT INTO rro_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Iesu e'abi etibaha, “Simona Iona nahuna e, Tirama ebanamoni'o, pokina maearima ha 'abi neiana oi a'i eba'iobini'o 'a Hama'u kupai nemiaho hauna eba'iobini'o. ");
INSERT INTO rro_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nahina beni'o, oi hanona Petero, wairo neiana ahanai e'u marea kabakorina, 'ari ena hiabu e'u marea neiana a'i keba ibiuna. ");
INSERT INTO rro_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Au kahore Tirama ena obia aiarana ikaikauna hiabuna kabeni'o, ba hanopaka ai kobirinakia haukia abomo kupa ai kebirinakia, hanopaka ai korubunakia haukia abomo kupa ai kerubunakia.” ");
INSERT INTO rro_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ba Iesu i'abana haukia eharabunakia, hau ha haianai a'i kate'abi ia hanona Keriso. ");
INSERT INTO rro_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Rani weianai Iesu i'abana haukia eba'iobi ramanakia ia hanona keao toha Ierusalema ai weia Iuda ekia maearima apa'uakia, robe haukia apa'uakia mai rauhubu poki haukia hauna katebahaiara ki'ana ba kateahu 'arina, ia wapu ibaihaunai Tirama kehore ia kebamikiri muena. ");
INSERT INTO rro_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Petero ehore Iesu ebakapare haiahaiai ehinabe pahihina etibaha, “Obiapaka e, ua a'i kehoma, oi hanona ua a'i katehomani'o.” ");
INSERT INTO rro_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Iesu ekori kabe Petero erikena etibaha, “Satani e, here'uai mokatua, oi au e'u taeara nukaiabuna, pokina emu raona raona hanona Tirama 'eunai aha'i ia maearima 'eukiai emai.” ");
INSERT INTO rro_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ba Iesu i'abana haukia ehinabenakia etibaha, “Hau ha kenuatae au muri'uai keka'a raninai ia kipona ena mauri kehabona, ena matiu ibiri ropo kebuana au muri'uai keka'a. ");
INSERT INTO rro_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Hau ha kipona ena mauri nenuatae ai ki'ana hauna hanona keba'akaumana, ia hau ha au pau'uai kipona ena mauri kehabona hauna hanona kea'i muena. ");
INSERT INTO rro_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Hau ha hanopaka maikoina ia'inai ena mauri keba'akaumana hanona ena namo taba? 'Ao hau ha ena mauri tabai kekawa muena? ");
INSERT INTO rro_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Au Maearima Nahuna hanona Hama'u nuabinai kamai e'u aneru kipokia, rani weianai maearima ha ha ekia aka ihobokiai 'arakia kabenakia. ");
INSERT INTO rro_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","'Abi tohana au wai nahinabenimi, baika neia tikoroti haukia a'i kate'ari baha keaomo Au Maearima Nahuna kupa aiarana obia hiabunai kamai maearima baiatakiai hanona kateihana'u.” ");
INSERT INTO rro_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Wapu 'abaihau murinai Iesu ehore Petero mai Iakobo hatina Ioane ohi ia ikupaiakia mo e'uaiainakia oeo apa'uana ha ai tekara'au. ");
INSERT INTO rro_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ba weia ia wairakiai Iesu ihana ehaeai, wairana ea obo matoha beraura 'abana abomo ena habuni tepore ki'a te'imare 'imare. ");
INSERT INTO rro_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Mawa'eai Mose mai Elia tewaira tina ia wairakiai, Iesu kipokia te'abi 'abi. ");
INSERT INTO rro_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ba Petero Iesu ehinabena etibaha, “Obiapaka e, aika neia nahamiaho hanona enamo, oi konuatae raninai au i'aua aihau kababainakia ha oi 'eumu ha Mose 'euna ha Elia 'euna.” ");
INSERT INTO rro_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Petero ni'abi ohomo aonai, 'auhao pore obona emai ebahu abunakia, ba aia ha 'auhao aonai emai e'abi etibaha, “Naiana hanona au naha'u, e'u raona'au, au ia naonamoaina, aiana katona.” ");
INSERT INTO rro_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","I'abana haukia aia weiana teona raninai te'eho 'anoai te'umuti, teta'u wairai. ");
INSERT INTO rro_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","'A Iesu eka'a emai herekia, ea'i 'apuanakia e'abi etibaha, “A'i katota'u, tomomikiri.” ");
INSERT INTO rro_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ba ia tea'a taea hanona tai a'i teihana ia Iesu mo ikupaiana. ");
INSERT INTO rro_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Oeoai teriri raninai Iesu eharabunakia etibaha, “Taba toihana hauna hau ha haianai a'i kato'abi keaomo au maearima nahuna 'ariai kamikiri mue.” ");
INSERT INTO rro_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ba i'abana haukia tebakaina tetibaha, “Taba buonai rauhubu poki haukia ti'abi Elia hanona kemai 'uai?” ");
INSERT INTO rro_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Iesu ekia 'abi ebamuena etibaha, “'Abi tohana, Elia hanona kemai haeamona taba kehorehore harainakia. ");
INSERT INTO rro_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ia au wai nahina benimi, Elia hanona aba emai, maearima ia a'i teiha 'iobiaina ia herenai ekia nuatae akakia tebabainakia, ihobona uahomanai au maearima nahuna hau'u ua katebahaiara aiho.” ");
INSERT INTO rro_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ba i'abana haukia obona teobo, ia hanona Ioane ba'uere robe hauna robana eahuna. ");
INSERT INTO rro_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Weiana temue to'u haukia herekiai tekara'au raninai, hau ha emai Iesu wairanai ekaipehu e'abi etibaha, ");
INSERT INTO rro_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Obiapaka e, Naha'u moaoko'oaina pokina ia hanona nawa ni'ariaina ena haiara eapa'ua, rani baika kipona iruba ai neno'au 'ao beiai nitobu. ");
INSERT INTO rro_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Amaiaina i'abamu haukia herekia, katebanamona hanona a'i etainakia.” ");
INSERT INTO rro_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Iesu ehinabenakia etibaha, “A'ikakauma aha'i mai haia po'o uruna haumi, heremiai kabapahihi kamiaho keaomo aita? Miori tomaiaina here'u.” ");
INSERT INTO rro_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Iesu auba ki'a obona ebatana, ba auba ki'a obona miori aonai ekarahi, miori beronai enamo. ");
INSERT INTO rro_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Weiana murinai i'abana haukia bunianai teao Iesu tebakaina tetibaha, “Aehoma buonai ai auba ki'a obokia katau'u ahina hanona a'i etainamai?” ");
INSERT INTO rro_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Iesu ekia 'abi ebamuena etibaha, “Pokina emi a'ikakauma teko'iko'i 'aki. 'Abi tohana au wai nahina benimi, emi a'ikakauma petuaba uhona 'abana raninai, oeo neiana pohinabena, ‘Moibiu moao weia’ hanona beronai peibiu peao, taba ha heremi a'i kepahihi ki'a baha. ");
INSERT INTO rro_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ia taba nahomakia hanona kipokia a'i katekarahi 'apua, ia mo bahuba'ari ai mai ani robeai hanona katekarahi.” ");
INSERT INTO rro_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","I'abana haukia ikoikiai temai Galileai tebahamomo, ba Iesu ehina benakia etibaha, “Au maearima Nahuna hanona ihina hinai kaeao ba kateahu'arina'u, ");
INSERT INTO rro_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ia wapu ibaihaunai Tirama kebamikiri muena'u kamauri mauri.” Weiana teona raninai i'abana haukia aokia eaoko'o. ");
INSERT INTO rro_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Iesu mai i'abana haukia teao Kaperanaumai tekara'au raninai, marea robe takitina tibararo haukia temai Petero herena tebakaina tetibaha, “Emi poki hauna Marea Robe takitina nibaibeni?” ");
INSERT INTO rro_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petero e'abi etibaha, “'E, nibaibeni.” Ba Petero eao itu aonai etoto a'i ni'abi baha aonai, Iesu Petero ebakaina etibaha, “Simona e, oi taba ṉa nuho? Hanopaka obiakia hanona nahukia herekiai takiti tia'i 'ao maearima haeai herekiai tia'i?” ");
INSERT INTO rro_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petero e'abi etibaha, “Maearima haeai herekiai tia'i.” Iesu etibaha, “O'abi harai, weiana nahukia hanona takiti a'i katehoroti. ");
INSERT INTO rro_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ia maearima neiakia aokia a'i hamaba opuerenakia paunai, moao obuai monaku, maia koberi'au 'uaina hauna pinana kohaokauna aonai moni kotabu ahina, koa'ina kobenakia hararua eka takiti 'arana.” ");
INSERT INTO rro_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Rani weianai i'abana haukia temai Iesu herena tebakaina tetibaha, “Tai hanona eapa'ua ki'a baha Tirama ena obia aiarana aonai?” ");
INSERT INTO rro_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Weiana Iesu miori papana ha eaparina emai baiatakiai ebakorotina. ");
INSERT INTO rro_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ba ehina benakia etibaha, “'Abi tohana au wai nahina benimi, aomi a'i katoba ko'iko'ina miori papakia 'abakiai a'i katoao raninai wai hanona Tirama ena obia aiaranai a'i katokatoto. ");
INSERT INTO rro_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ua buonai hau ha ke'aiaunu miori papana neiana 'abanai keao hauna, ia hanona keapa'ua ki'a baha Tirama ena obia aiarana aonai. ");
INSERT INTO rro_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Hau ha au ata'uai miori papana nahomana kea'i taeana hanona au abo'umo aba ea'i taeana'u. ");
INSERT INTO rro_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ia hau ha au tia'ikakaumana'u miorina nahomana ha behoai kehorotina hauna hanona iata rarina 'akonai patetoba 'auna 'aku kunakunanai patekapo uhuna petono 'ari hanona penamo. ");
INSERT INTO rro_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Hanopaka neiana hanona keki'a wairai, pokina ia kehore maearima keaoainakia ki'ai kehorotinakia. Baihobo uahomakia hanona katerama, ia baihobo kebabaina hauna herenai keki'a wairai. ");
INSERT INTO rro_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Imamu 'ao aemu ki'ai kehorotini'o raninai kokabe hurina kone'e 'akaumana. Ba imamu ki'a obonai 'ao aemu ki'a obonai mauri banaibanai 'ekanai kokatoto hanona enamo, ia a'i enamo imamu rua mai aemu rua weiakia kateaoaini'o a'i ni'ao 'apua ni'ara banaibanai irubanai katekapo totoni'o. ");
INSERT INTO rro_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Mahamu ki'ai kehorotini'o raninai ko'ipa ahina kone'e 'akaumana. Mahamu hamonai mauri banaibanai 'ekai kokatoto hanona enamo, ia a'i enamo mahamu rua namokiai a'i ni'ao 'apua irubanai katekapo totoni'o. ");
INSERT INTO rro_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Kato'ima'ima harainimi miori papakia neiakia ha taba aha'iai a'i katobaonakia, pokina ekia aneru kupa ai hanona rani ikoinai Hama'u kupai nemiaho hauna katehinabena ketaina. ");
INSERT INTO rro_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Au maearima Nahuna hanona te'akauma haukia kabamaurinakia paunai amai. ");
INSERT INTO rro_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Wai aea turaona aihona? Hau ha ena mamoe hinabu hamomo, ba hamona pe'akauma raninai, imabui bariabui 'ababani hamomo oeoai pehobonakia ba peao e'akauma hauna petabuna. ");
INSERT INTO rro_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","'Abi tohana au wai nahina benimi, petabu ahina raninai, aona penamo wairai weiana hamona etabu ahina hauna paunai ba weiakia imabui bariabui 'ababani hamomo a'i te'akauma haukia paukiai aha'i. ");
INSERT INTO rro_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Weiana ihobonai Hamami kupai hauna nenuatae miori papakia neiakia ha a'i ke'akauma. ");
INSERT INTO rro_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Uaho'abamu ki'a ebabai heremuai raninai koao herena torarua mo kato'abi'abi aina ena babai ki'a haianai kohinahina haraina, ba aiamu kea'i taeana raninai oi hanona uaho'abamu aba nua'i muena. ");
INSERT INTO rro_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ia aiamu a'i keona raninai maearima ha 'ao rua koaoainakia herena, ba maearima weiakia rua 'ao aihau 'abi kato'abi'abi ainakia haukia ikoikiai katebatohanakia. ");
INSERT INTO rro_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ia keubo aiami a'i keona raninai, robe haukia a'ia'i harainai kohina karahina, ba kebaki'a aiakia a'i keona raninai rama haeai haunai 'ao ki'a haunai katobaona. ");
INSERT INTO rro_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","'Abi tohana au wai nahina benimi, taba hanopakai katobirinakia hanona kupai abomo kebirinakia 'a taba hanopakai katorubunakia hanona kupai abomo kerubunakia. ");
INSERT INTO rro_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Haeamona nahinabe muenimi, hanopakai torarua taba ha aomi hamonai katonoi aina hauna Hama'u kupai nemiaho hauna kebabaina 'eumi. ");
INSERT INTO rro_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Maearima rua 'ao aihau au ata'uai tito'u, au hanona weia ia herekiai.” ");
INSERT INTO rro_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Weiana Petero eao Iesu herena ebakaina etibaha, “Obiapaka e, uaho'aba'u kebabai ki'a here'uai hanona rani bita ena ki'a kahina haona? Rani 'abaihau hamomo, 'u?” ");
INSERT INTO rro_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Iesu e'abi etibaha, “Rani 'abaihau hamomo aha'i, ia rani imabui haraurua ikoinai rani 'abaihau hamomo 'abana kohina haonakia. ");
INSERT INTO rro_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Weiana Tirama ena obia aiarana hanona matoha obia arana ha 'abana, ena ta'ara'i haukia herenai taba bita tea'i haukia kebaberonakia. ");
INSERT INTO rro_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ua buonai ena aka ea'i ramana hanona ia herenai Kina kerepu harau haea ea'ina hauna temaiaina ia wairanai. ");
INSERT INTO rro_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ia poki hauna ena moni 'arana kehorena hanona imanai a'i etaina, ba poki hauna ia ehinabena etibaha, ‘Oi mai atawamu, nahumu mai emu taba ikoikiai katekawa kawainakia monikiai moni oa'ina hauna 'arana kohorena.’ ");
INSERT INTO rro_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Weiana ta'ara'i hauna ena poki hauna wairanai ekai pehu eba'amena, ‘Rani papana mobai'ima, ba a'ina hauna 'arana maikoina kahorena.’ ");
INSERT INTO rro_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Poki hauna ta'ara'i hauna eaoko'oaina, ba moni ea'ina hauna ekakina ba euhuna eka'a. ");
INSERT INTO rro_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ba ta'ara'i hauna ekarahi eao raninai 'abana ha etabu ahina hau weiana hanona ia herenai Kina harau rua ea'ina, emikiri hau weiana ea'i 'inina 'akona ebebena e'abi etibaha, ‘E'u moni oa'ina hauna 'arana mohorena.’ ");
INSERT INTO rro_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ba ia 'abana ekai pehu eba'amena, ‘Rani papana mobai'ima 'arana aba kahorena.’ ");
INSERT INTO rro_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","'A ia a'i enuatae, hau weiana eaoaina wapura 'ekanai ehorotina weia kemiaho keaomo 'ara kehore obona. ");
INSERT INTO rro_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ta'ara'i haukia baika hoa weiana teihana raninai aokia ehaiara, teao ekia poki hauna herena taba erama hauna pouna tehinana. ");
INSERT INTO rro_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ba poki hauna ta'ara'i hauna weiana eaparina emai, ehinabena etibaha, ‘Oi ta'ara'i haumu ki'a obomu, onoina'u paunai moni oa'ina hauna maikoina akakinakia. ");
INSERT INTO rro_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ia aehoma buonai 'abamu a'i oaoko'o aina ihobona au aoko'o aini'o 'abana?’ ");
INSERT INTO rro_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Poki hauna eopuere ki'a ta'ara'i hauna eba wapurana haiara katebahoaina keaomo moni weiana ea'ina hauna 'arana maikoina kehore obona. ");
INSERT INTO rro_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Weiana paunai wai ha ha uaho'abami aomi tohakiai ekia ki'a a'i katohina haonakia raninai Hama'u kupai nemiaho hauna abomo ua kehomanimi.” ");
INSERT INTO rro_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Iesu 'abi weiakia ebaorenakia murinai, Galilea ehabona eao Iuda hanonai Ioridana ate abihana tainai. ");
INSERT INTO rro_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Mako rarina 'akina ia murinai teao weia ekia inawa ebanamonakia. ");
INSERT INTO rro_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Weiana Parisea haukia baika temai Iesu herena tehobona tebakaina tetibaha, “Hau ha ena raona baika buonai atawana kebakarahina hanona mai ena bero ha 'ao aha'i?” ");
INSERT INTO rro_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Iesu ekia 'abi ebamuena etibaha, “Wai Puka Robena a'i totuabina, u? Bahabana 'akinai barama Tiramana ehore maearima ebabainakia hau mai babi'e ohi. ");
INSERT INTO rro_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ba e'abi etibaha, ‘Weiana buonai hau kehore hamana mai hinana kehabonakia, ia atawana ohi katebahamomo, terarua hanona hauani hamona.’ ");
INSERT INTO rro_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ua buonai ia hanona hamona ia rua aha'i. Weiana paunai Tirama ehore eba hamomonakia hauna hau ha a'i keboa 'apuana.” ");
INSERT INTO rro_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Parisea haukia tebakai muena tetibaha, “Aehoma buonai Mose ehinabenamai, hau kenuatae raninai bakarahi marerena kererena atawana kebena ba kebakarahina?” ");
INSERT INTO rro_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Iesu ekia 'abi ebamuena etibaha, “Wai emi ao pahihi paukiai Mose bero ebenimi atawami katoba karahinakia, ia popouna 'akinai hanona ua homana aha'i. ");
INSERT INTO rro_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Au wai nahinabenimi, hau ha atawana a'i enabau ia ebakarahi 'abaeana ia haeamona babi'e mahamahana ha eatawana, hau weiana hanona nabau hoana ebabaina.” ");
INSERT INTO rro_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","I'abana haukia Iesu tehinabena tetibaha, “Hau mai babi'e baiatakiai ua niho raninai, hau a'i pehawainibe hanona penamo.” ");
INSERT INTO rro_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Iesu ekia 'abi ebamuena etibaha, “'Abi naiana maearima ikoikiai herekiai hanona a'i ketaina, ia weiakia Tirama ea'i taeanakia haukia herekiai hanona ketaina. ");
INSERT INTO rro_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Maearima baika hanona a'i katehawainibe, hau baika hanona uahomanai terama a'i katehawainibe, hau baika hanona maearima tehore teuanakia a'i katehawainibe, hau baika hanona Tirama ena obia aiarana paunai hawainibe a'i tiraonana. Tai herenai etaina hauna 'abi neiana kea'i taeana.” ");
INSERT INTO rro_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Rani weianai maearima baika nahukia temaiainakia Iesu herena ahakiai kehao'au kebahuba'ari, ia i'abana haukia tehore maearima weiakia terikenakia, ");
INSERT INTO rro_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Iesu e'abi etibaha, “Miori papakia tomo habonakia, temai here'u a'i kato kaiabunakia, pokina Tirama ena obia aiarana hanona nahomakia haukia 'eukia.” ");
INSERT INTO rro_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Iesu miori papakia ahakiai imana ehao'au ebanamonakia, murinai 'eka weiana ehabona. ");
INSERT INTO rro_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Weiana hau ha emai Iesu herena ebakaina etibaha, “Ba'iobi haumu e, aka namona tabana kababai hanona mauri banaibanai ka'ina?” ");
INSERT INTO rro_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Iesu ia ena 'abi ebamuena etibaha, “Aehoma buonai au here'uai aka namona nubakaibakai aina? Weiana Tirama mo ikupaiana enamo, oi konuatae mauri banaibanai koa'ina raninai, rauhubu 'abikia ko'ima harainakia.” ");
INSERT INTO rro_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ia e'abi etibaha, “Rauhubu 'abikia aeakia?” Iesu etibaha, “Rauhubu neiakia, a'i koahuahu, a'i konabau, a'i kobainao, a'i kohinau bai'oi. ");
INSERT INTO rro_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Hamamu mai hinamu komariki ainakia, abomo heremu hauna koraona'au aina matoha oi kipomu nuraona'au aini'o 'abana.” ");
INSERT INTO rro_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Hau 'aru'aruna e'abi etibaha, “Naiakia ikoikiai aba a'ima harainakia, ba taba akapu aina?” ");
INSERT INTO rro_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Iesu ia ehinabena etibaha, “Konuatae konamo harai ki'a baha raninai moao emu kohu ikoikiai kokawa kawainakia monikia uraru haukia kobenakia, weiana emu kepu hanona aba wa'a kupai koa'ina, ba komai muri'uai moka'a.” ");
INSERT INTO rro_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Hau 'aru'aruna aia weiana eona raninai aona earo'ari ekaobo, pokina ia herena kepu ebo'o. ");
INSERT INTO rro_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ba Iesu i'abana haukia ehina benakia etibaha, “'Abi tohana au wai nahina benimi. Kepu hauna Tirama ena obia aiaranai kekatoto hanona kepahihi ki'a baha. ");
INSERT INTO rro_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Haeamona nahinabe muenimi. Mahi atana Kamela kopi ererenai kekuri banai hanona epahihi, ba kepu hauna Tirama ena obia aiaranai kekatoto hanona kepahihi ki'a baha.” ");
INSERT INTO rro_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","I'abana haukia 'abi weiana teona raninai teta'u ta'u huri tebakai bakai tetibaha, “Ba tai hanona mauri kea'ina?” ");
INSERT INTO rro_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Iesu eiha 'ini 'ininakia e'abi etibaha, “Maearima herekiai neiana katebabaina hanona a'i ketaina, ia Tirama herenai taba ikoikiai kebabai hanona ketaina.” ");
INSERT INTO rro_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ba Petero Iesu ebakaina etibaha, “Ai taba ikoikiai tahabonakia oi mo murimuai ṯaka'a, ba murimuai ṯaka'a hanona taba kata'ina?” ");
INSERT INTO rro_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Iesu ehina benakia etibaha, “'Abi tohana au wai nahina benimi. Taba ikoikiai ekia mahamaha raninai, au Maearima Nahuna e'u imia'au nuabina ahanai kamia'au aonai, wai harauhaea rua muri'uai tuka'a haumi abomo imia'au harau haea rua ahakiai katomia'au, Isaraela itubukia harau haea rua maearimakia kato bakainakia. ");
INSERT INTO rro_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Hau ha au pau'uai ena itu 'ao uaho'abana haibuna hamana hinana nahuna 'ao ena hano kehabonakia hauna hanona hinabu hinabu ketabu ahi muena, abomo mauri banai banai kea'ina. ");
INSERT INTO rro_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ia bo'okia te'uai haukia hanona murihai katetoto, ba bo'okia temurihai haukia hanona katetoto 'uai.” ");
INSERT INTO rro_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Tirama ena obia aiarana hanona hano poki hauna ha 'abana, raurani 'amarinai ekarahi eao aka haukia etabunakia ena bine haharuanai kateaka. ");
INSERT INTO rro_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Poki hauna kipokia 'abi tebatohana 'arakia beraura hamona aonai kina harau haea katea'ina, ba euhunakia ena haharua teao. ");
INSERT INTO rro_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Beraura hoana 9 'abana hanona ekarahi eao aiara ibuanai weia maearima baika tekoroti 'abaea eihanakia. ");
INSERT INTO rro_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ba ehinabenakia etibaha, ‘Wai abomo tomoao e'u haharuai katoaka, 'arami kahorenakia.’ ");
INSERT INTO rro_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ba ia abomo teao kateaka. Atiaha ekarahi eao haeamona rabirabi beraura hoana 3 'abana ekarahi mue eao hoahoa hamonamo weiana ebabaina. ");
INSERT INTO rro_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Haeamona rabirabi beraura hoana 5 'abana ekarahi eao hanona baika mo tekoroti 'abaea eihanakia, ebakainakia etibaha, ‘Aehoma buonai neia tukoroti rabi 'abaea taba ha a'i tubabai 'apuana?’ ");
INSERT INTO rro_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ena 'abi tebamuena tetibaha, ‘Pokina tai ha aka ha a'i ebenamai.’ Ba ehinabenakia etibaha, ‘Wai abomo tomoao e'u haharuai katoaka.’ ");
INSERT INTO rro_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Beraura ekaihuna, haharua poki hauna haharua i'imana hauna ehinabena etibaha, ‘Teaka haukia koaparinakia 'arakia kobenakia, muri 'akinai temai teaka haukia herekiai koa'i ramana keaomo temai 'uai haukia herekiai kobapuana.’ ");
INSERT INTO rro_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Rabirabi beraurana hoana 5 'abanai tetoto teaka haukia temai ha ha kina harauhaea harauhaea ebenakia tea'i. ");
INSERT INTO rro_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ba teaka 'uai haukia temai, ekia raona hanona 'arakia keapa'ua, 'a ia abokiamo ha ha kina harauhaea harauhaea tea'inakia. ");
INSERT INTO rro_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ekia moni tea'inakia aonai haharua poki hauna teururuaina, ");
INSERT INTO rro_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","te'abi tetibaha, ‘Muriai temai haukia hanona beraura hoana hamonamo teaka, 'a ai hanona beraura neiana ena aro'ari ena hiabu maikoina tahoaina, ia kipokia 'aramai obaihobona.’ ");
INSERT INTO rro_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Haharua poki hauna aka hauna ha ena 'abi ebamuena etibaha, ‘E'u hau e, heremuai a'i abeho. Aika hararua 'abi aba habatohana koaka beraura hamona aonai kina harau haea kabeni'o. ");
INSERT INTO rro_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Oi 'eumu hauna moa'ina moao. Au e'u nuataeai muriai emai eaka hauna 'euna kabena oi 'eumu abeni'o hauna ihobonai. ");
INSERT INTO rro_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Au kipo'u e'u taba kipo'u e'u nuataeai a'i kababaina, u? Au e'u namo paunai nuwae'e aina'u, u? ");
INSERT INTO rro_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Taeara ihobonai temurihai haukia kate'uai, 'a te'uai haukia katemurihai.’” ");
INSERT INTO rro_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Iesu taearai eka'a niao Ierusalema aonai i'abana haukia harauhaea rua ebakaparenakia haiahaiai ehinabenakia etibaha, ");
INSERT INTO rro_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Bariu aika hanona Ierusalema ai kahakara'au, au Maearima Nahuna hanona robe haukia apa'uakia mai rauhubu poki haukia imakiai kateutana'u behoai katehorotina'u kateahu 'arina'u. ");
INSERT INTO rro_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Au hanona rama haea haukia imakia kateutana'u katebataeaina'u kate'atina'u mai matiu ibiri ropo 'ubinai kateahu 'arina'u, 'a wapu ibaihaunai kamikiri mue.” ");
INSERT INTO rro_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sebedeo nahuna rua hinakia kipokia temai Iesu herena, hinakia Iesu wairanai ekaipehu ena nuatae tabana ha enoiaina. ");
INSERT INTO rro_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Iesu ia ebakaina etibaha, “Taba nonuatae?” Ia e'abi etibaha, “Mo'abi 'uai here'uai, naha'u neiakia rua ha itipamu tainai ha awarimu tainai katemiati emu kupa aiarana aonai.” ");
INSERT INTO rro_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Iesu e'abi etibaha, “Wai a'i to'iobina taba tunoiaina? Haiara 'erena kainu hauna wai katoinu ketaina, u?” Terarua te'abi, “Katainu ketaina.” ");
INSERT INTO rro_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Iesu ia ehinabenakia etibaha, “'Abi tohana e'u 'ere hanona katoinu, 'a itipa'u mai awari'u tainai katemiati haukia hanona au a'i katina'anakia, ia 'eka weiana hanona aba Hama'u eba'oruna etina'anakia haukia mo kebenakia.” ");
INSERT INTO rro_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","I'abana haukia harauhaea aia weiana teona raninai uaho'aba rua weiakia teopuere ainakia. ");
INSERT INTO rro_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ua buonai Iesu i'abana haukia ikoikiai eaparinakia temai herena ehina benakia etibaha, “Wai to'iobina rama haeai haukia ekia obia haukia hanona ekia nuataeai maearima tipoki ainakia ekia hau apa'uakia abomo ekia hiabuai tibaehe'au maearima tiaiahunakia. ");
INSERT INTO rro_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","'A wai heremiai hanona ua a'i kehoma, hau ha baiatamiai nenuatae keapa'ua hauna hanona ikoimiai emi ta'ara'i haunai keao. ");
INSERT INTO rro_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Abomo hau ha baiatamiai nenuatae ke'uai hauna hanona ikoimiai emi ta'ara ia'inai keao. ");
INSERT INTO rro_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ihobona au Maearima Nahuna amai hanona ta'ara'u a'i katea'i ia maearima ta'arakia ka'i, abomo e'u mauri kabaibeni maearima ekia ki'ai kabakarahinakia paunai.” ");
INSERT INTO rro_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Iesu i'abana haukia kipokia Ieriko tihabona aonai mako rarina ia murinai teka'a. ");
INSERT INTO rro_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Maha ki'a haukia rua taeara haianai temiati herekiai Iesu ekabanai 'uruna teona raninai, teapari aota tetibaha, “Obiapaka, Davida Nahuna e! Moaoko'o ainamai!” ");
INSERT INTO rro_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","'A mako ia terikenakia kateunu. 'A terarua teapari aota ki'a, “Obiapaka, Davida Nahuna e! Moaoko'o ainamai!” ");
INSERT INTO rro_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Iesu ekoroti eaparinakia temai herena, ba ebakainakia etibaha, “Taba ṯonuatae 'eumiai kababaina?” ");
INSERT INTO rro_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ia te'abi tetibaha, “Obiapaka e, ṯanuatae mahamai katekaikau.” ");
INSERT INTO rro_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Iesu eaoko'o ainakia, mahakia ea'i 'apuanakia. Beronai mahakia tekaikau teihaiha, ba Iesu murinai teka'a. ");
INSERT INTO rro_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Iesu i'abana haukia kipokia Ierusalema aba wairakiai Betefage ai tekara'au Olibe oeonai, weia Iesu ehore i'abana haukia rua euhu 'uainakia, ");
INSERT INTO rro_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ehina benakia etibaha, “Katoao aiara aonai toniki ha tetoba 'auna mai nahuna ohi katotabu ahinakia, katorubunakia katomai ainakia here'u. ");
INSERT INTO rro_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Hau ha 'abi ha kehinana raninai kato'abi, ‘Obiapaka nenuatae ainakia,’ ba beronai kebenimi.” ");
INSERT INTO rro_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Neiana hanona Mahabanai hauna ena 'abi ibatohana etibaha, ");
INSERT INTO rro_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Siona aiara haukia kohina benakia, Tomoihana, emi obia 'arana nimai heremi. Ia mai 'aiaununa toniki kapenai emia'au, toniki nahuna ahanai emia'au.” ");
INSERT INTO rro_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","I'abana haukia teao Iesu ehina benakia akakia ihobona tebabainakia. ");
INSERT INTO rro_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Toniki mai nahuna ohi temaiainakia, ekia habuni ahanai teabari 'aunakia ba Iesu emia'au. ");
INSERT INTO rro_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Mako rarina ekia habuni taearai teabarinakia, baika abomo matiu rekia tehara obonakia taearai teabarinakia. ");
INSERT INTO rro_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Iesu wairanai mai murinai teka'a haukia teio tetibaha, “Hosana, Davida Nahuna 'euna! Obiapaka atanai nimai hauna Tirama kehore kebanamona! Hosana 'ubi toha tohanai!” ");
INSERT INTO rro_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Iesu Ierusalemai ekatoto raninai aiara haukia te'uri'uri tebakaibakai tetibaha, “Neiana hanona hau tabana?” ");
INSERT INTO rro_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Mako te'abi tetibaha, “Neiana hanona Iesu mahabanai hauna Galilea Nasareta ai emai.” ");
INSERT INTO rro_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Iesu marea robe aonai ekatoto weia tikawakawa haukia ikoikiai eu'u ahinakia, moni a'i banai haukia ekia itara mai rauria tikawakawai haukia ekia imia'au etori tori ku'a banainakia. ");
INSERT INTO rro_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ehinabenakia etibaha, “Puka robenai aba tererena, ‘E'u itu hanona kateaparina bahuba'ari ituna,’ ia wai hanona kakikaki haukia ekia paparo'ai tubaona.” ");
INSERT INTO rro_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Mahakia teki'a haukia mai 'ome haukia teao Iesu herena marea robe aonai, ba ia ehore ebanamonakia. ");
INSERT INTO rro_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Robe haukia apa'uakia mai rauhubu poki haukia Iesu bamauri hoakia ebabai teihana abomo miori marea aonai teio tetibaha, ‘Hosana Davida Nahuna 'euna!’ raninai ia aokia teopuere, ");
INSERT INTO rro_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","tebakaina tetibaha, “Oi miori ti'abi aiakia hanona nuona?” Iesu ekia 'abi ebamuena etibaha, “'E, aiakia aba naona. Wai 'abi neiana aba totuabina? ‘Miori 'oru'orukia mai 'ae tiana miorikia pinakiai atamu tibanamona.’” ");
INSERT INTO rro_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ba Iesu ehabonakia aiara apa'uanai ekarahi eao Betani ai erabi weia emiaho. ");
INSERT INTO rro_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Erani raurani amarinai Iesu emue aiara apa'uana niao aonai mare'a e'ari. ");
INSERT INTO rro_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Suke matiuna ha taeara haianai eihana eao herena. Ia buana ha a'i eihana 'a rau 'abaeakia mo, ba ehinabena etibaha, “Oi a'i kobua'a mue!” Matiu weiana beronai rauna tepaea ba e'ororo. ");
INSERT INTO rro_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","I'abana haukia hoa weiana teihana hanona teta'u ta'u huri tetibaha, “Aehoma buonai rani a'i ehoma'a matiu weiana aba e'ororo?” ");
INSERT INTO rro_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Iesu ehinabenakia etibaha, “'Abi tohana au wai nahina benimi, patoa'ikakauma aomi a'i patekai'au kai'au raninai, Suke herenai erama hauna ikupaiana mo aha'i, ia kobio patohinabena, ‘Moao 'akuai moeno uhu,’ weiana abomo kerama. ");
INSERT INTO rro_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Taba ikoinai bahuba'ari ai katonoi ainakia mai a'ikakaumami hanona katoa'inakia.” ");
INSERT INTO rro_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Iesu haeamona Marea Robe ai ekatoto eba'iobi aonai, robe haukia apa'uakia mai Iuda ekia maearima apa'uakia temai herena tebakaina tetibaha, “Hiabu tabanai aka neiakia nubabai, abomo tai hiabu ebeni'o?” ");
INSERT INTO rro_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Iesu ekia 'abi ebamuena etibaha, “Au abomo wai bakai bakai hamona kabenimi, e'u 'abi katobamuena raninai au hiabu tabanai aka neiakia nababai haukia kaba'ioibinimi. ");
INSERT INTO rro_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ioane ena ba'uere robe hiabuna hanona ae'e ai emai? Kupai emai 'ao maearima herekiai emai?” Ia kipokia baiatakiai te'abi'abi tetibaha, “Kaha'abi, ‘Kupai emai.’ hanona kebakainaka ketibaha, ‘Aehoma buonai a'i toa'i taeana?’ ");
INSERT INTO rro_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","'A kahatibaha, ‘Maearima herekiai emai.’ raninai, to'u haukia neiakia abomo kahata'uainakia, pokina ia ikoikiai tiraonana Ioane hanona mahabanai hauna.” ");
INSERT INTO rro_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ua buonai ia Iesu ena 'abi tebamuena tetibaha, “Ai a'i ṯa'iobina.” Ba Iesu ehinabenakia etibaha, “Au abo'umo hiabu tabanai aka neiakia nababai hanona a'i kaba'iobinimi.” ");
INSERT INTO rro_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Wai taba ṉa tuhoma? Hau ha nahuna hanona rua, ba eao pakana hauna herena ehinabena etibaha, ‘Naha'u e, bariu beraura neianai koao e'u bine haharuanai koaka.’ ");
INSERT INTO rro_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Miori hamana ena 'abi ebamuena etibaha, ‘A'i kaeao.’ 'A muriai eraonaraona haraina ba eao eaka. ");
INSERT INTO rro_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Haeamona hamakia eao nahuna ibaruana herena 'abi ihobonamo ehinana, ba miori e'abi, ‘'E, hama'u, kaeao.’ Ia a'i eao. ");
INSERT INTO rro_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Weiakia terarua hanona aeana hauna hamakia ena nuatae akana ebabaina?” Ia te'abi tetibaha, “Kori 'uaina hauna.” Iesu ia ehina benakia etibaha, “'Abi tohana au wai nahina benimi, moni bararo haukia mai maha porepore babi'ekia hanona Tirama ena obia aiaranai katekatoto 'uai ba wai. ");
INSERT INTO rro_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Pokina ba'uere robe hauna Ioane emai heremi bero taearana ebaihanimi, ia wai a'i toa'i taeana 'a moni bararo haukia mai mahaporepore babi'ekia hanona tea'i taeana. Wai haeamona hoahoa weiana toihana, iamo a'i toraona kabe a'i toa'i taeana.” ");
INSERT INTO rro_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Tomobahu 'abi ibabatai ha neiana. Hano hauna ha ena bine haharuana ebabaina, arana eoko kakaiarona, bine buakia kehari 'iti 'itina urina ehabina mai bai'ima ituna ebakorina. Haharua hanona biraura haukia baika eba'ima'imanakia, 'a ia hanona eharima hano haeai eao. ");
INSERT INTO rro_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Bine buana ia'ina ranina aba ekaibari, poki hauna emikiri ena ta'ara'i haukia baika euhunakia buabua ibararokia teao. ");
INSERT INTO rro_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Haharua te'imana haukia tehore ta'ara'i haukia tea'i 'ininakia ha teahu ki'ana ha teahu 'arina ha piharai tekuina. ");
INSERT INTO rro_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Haeamona poki hauna ta'ara'i haukia euhunakia teao, 'uaina hanona bita mo bariu hanona bo'ona teao, ia hoa ihobonamo ia herekiai tebabaina. ");
INSERT INTO rro_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Muri 'akinai hanona poki hauna nahuna euhuna eao herekia etibaha, ‘Au naha'u buonai aba katemarikiaina.’ ");
INSERT INTO rro_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Haharua ṯe'imana haukia poki hauna nahuna teihana raninai kipokia te'abi'abi tetibaha, ‘Kepoki hauna neiana. Tomai hamahu'arina, haharua hanona aika 'eukai keao.’ ");
INSERT INTO rro_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ba weia tea'ina haharua aonai teberi ahina teaoaina parabu kapenai teahu'arina. ");
INSERT INTO rro_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ba wai turaonana, haharua poki hauna kemai raninai haharua te'imana haukia herekiai taba kebabaina?” ");
INSERT INTO rro_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ia ena 'abi tebamuena tetibaha, “Poki hauna kehore i'imana haukia ki'a obokia keahu'ari orenakia, 'a haharua hanona haharua i'imana haukia haeai kebenakia kate'imana, bine ekia bua'a raninai buakia kateaoainakia ia 'euna.” ");
INSERT INTO rro_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Iesu ia ehinabenakia etibaha, “Wai puka robena a'i totuabi 'apuana, u? Ṉa terere aihona, ‘Itu babai haukia tebaki'ana piharana hanona aba pihara apa'uana tohanai eao. Babai neiana hanona Obiapaka ebabaina, nahaihana nahata'u ta'u huri!’ ");
INSERT INTO rro_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ua buonai au wai nahinabenimi, Tirama ena obia aiarana heremiai kea'i parena, buabua nibaramanakia itubuna maearimakia kebenakia. ");
INSERT INTO rro_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Hau ha ke'eho pihara neiana ahanai hanona kepa'a, ia pihara ke'eho hau ha ahanai hauna hanona ke'iti 'iti apuroroai keao.” ");
INSERT INTO rro_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Robe haukia apa'uakia mai Parisea haukia Iesu ena 'abi ibabatai weiana ehinana aiana teona hanona te'iobina ia robakia niahuna. ");
INSERT INTO rro_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ia tenuatae katea'i 'inina, 'a mako teta'uainakia pokina maearima teraonana Iesu hanona mahabanai hauna ha. ");
INSERT INTO rro_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Iesu haeamona 'abi ibabatainai ehinabe muenakia etibaha, ");
INSERT INTO rro_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Tirama ena obia aiarana hanona matoha obia hauna ha nahuna ena hawainibe tatuna ebabaina 'abana. ");
INSERT INTO rro_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ia ena ta'ara'i haukia euhunakia tebeau beau enuatae ainakia haukia tehina benakia, ia enuatae ainakia haukia teubo a'i temai. ");
INSERT INTO rro_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ba ia haeamona ena ta'ara'i haukia haeai baika euhunakia etibaha, ‘Abeaunakia haukia katohinabe muenakia katotibaha, 'E'u poromakau mai e'u mahi namokia aba ahunakia aba teiua 'iti'itinakia taba ikoikiai aba teba'orunakia, hawainibe tatuna katomai.’ ");
INSERT INTO rro_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","'A maearima weiakia hanona ia robana a'i teahuna tekamuri, ha ena uma eao ha ena aka 'ekana eao. ");
INSERT INTO rro_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Harina haukia ta'ara'i haukia tea'i 'ininakia tebatae ainakia ba teahu 'arinakia. ");
INSERT INTO rro_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Weiana obia hauna eopuere wairai, ba emikiri ena huari haukia euhunakia, ahuahu haukia weiakia teahu 'arinakia ekia aiara abomo tehuhuna. ");
INSERT INTO rro_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ba ia ena ta'ara'i haukia ehinabenakia etibaha, ‘Hawainibe anianina aba e'oru, 'a abeaunakia haukia a'i tenamo a'i katemai. ");
INSERT INTO rro_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Tomoao aiara ibuanai taimo taimo katotabu ahinakia haukia katobeaunakia katemai hawainibe neiana tatunai.’ ");
INSERT INTO rro_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ua buonai ta'ara'i haukia teao aiara ibuanai tetabu ahi maearimakia namo haukia mai ki'a haukia ikoikiai temaiainakia, baki baki haukia hawainibe ituna tebabonu 'auna. ");
INSERT INTO rro_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","'A obia hauna eao baki haukia eihanakia raninai hau ha eiha tinana hawainibe tatuna habunina a'i ebatotona. ");
INSERT INTO rro_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ebakaina etibaha, ‘E'u hau e! Hawainibe tatuna habunina aha'i ia aea ohoma ototo?’ Hau weiana ke'abi 'ekana aha'i. ");
INSERT INTO rro_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Obia hauna ena ta'ara'i haukia ehina benakia etibaha, ‘Aena imana katobirinakia atapaka wapuranai katokapo ahina, ua'a kehai mai 'aki'akina kearao'i arao'i.’” ");
INSERT INTO rro_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Iesu ena 'abi orenai etibaha, “Bo'ona eaparinakia 'a bita mo etina'anakia.” ");
INSERT INTO rro_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Parisea haukia teto'u roba teahu aea patehoma Iesu ena 'abiai patebarewana. ");
INSERT INTO rro_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ekia maearima baika mai Heroda murinai ti'au haukia kipokia teuhunakia teao Iesu herena tehinabena tetibaha, “Ba'iobi haumu e, ai ṯa'iobina oi hanona 'abi tohana haumu, Tirama ena taeara tohana nuba'iobi aina abomo maearima taikia a'i nutai pokina ia aea homakia haukia robakia a'i nuahuna. ");
INSERT INTO rro_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ua buonai emu raona taba hanona moba'iobinamai, Takiti monina Kaisara katabena hanona ebero 'ao aha'i?” ");
INSERT INTO rro_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ekia raona ki'a obona weiana Iesu aba e'iobina buonai e'abi etibaha, “Wai bahaorea haumi, aehoma buonai au tuhobona'u? ");
INSERT INTO rro_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Takiti tubaibeni monina ha tomobaihana'u.” Ba silba monina ha temaiaina tebena. ");
INSERT INTO rro_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Iesu ia ebakainakia etibaha, “Neiana tai aubaubana abomo tai atana?” ");
INSERT INTO rro_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ia te'abi, “Kaisara 'euna.” Ba Iesu ia ehinabenakia etibaha, “Kaisara 'euna Kaisara katobena, 'a Tirama 'euna Tirama katobena.” ");
INSERT INTO rro_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","'Abi neiana aiana teona raninai te'arara ki'a ba tehabona teka'a. ");
INSERT INTO rro_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Beraura hamona weianai Sadukea haukia temai Iesu herena, ia hanona mikiri mue a'i tibatohana haukia, Iesu tebakaina, ");
INSERT INTO rro_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","tetibaha, “Ba'iobi haumu e, Mose ṉa eba'iobi aihonamai. Hau ha ehawainibe ia nahuna aha'i ebaramana e'ari raninai uaho'abana kehore wapu weiana keatawana miori kebaramana uaho'abana e'ari hauna nahunai keao. ");
INSERT INTO rro_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Bariu a'a hati haukia ikoinai 'abaihau hamomo baiatamaiai temiaho. Pakana ehawainibe, miori ha a'i ebaramana aonai e'ari wapu uaho'abana ibaruana hauna herenai ehabona, eatawana. ");
INSERT INTO rro_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Haeamona uaho'abana ibaruana abomo nahuna aha'i e'ari, taeara ihobonai mo erama uaho'abana ibaihauna herenai eao mo iba'abaihau hamomona herenai epua. ");
INSERT INTO rro_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Puana 'akinai babi'e abomo e'ari. ");
INSERT INTO rro_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Bariu mikiri mue raninai babi'e weiana hanona tai atawanai keao, pokina haukia 'abaihau hamomo babi'e weiana teatawana?” ");
INSERT INTO rro_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Iesu ekia 'abi ebamuena etibaha, “Wai aba tuhaorea pokina Puka robenai terere 'abikia mai Tirama ena hiabu a'i to'iobinakia paunai. ");
INSERT INTO rro_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Mikiri mue ai maearima hanona a'i katehawainibe. Ia haukia hanona kupa anerukia 'abakiai kateao. ");
INSERT INTO rro_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","'Ari haukia katemikiri mue 'abina Tirama ehina benimi hauna a'i totuabina, u? Ia etibaha, ");
INSERT INTO rro_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Au hanona Aberahamo ena Tirama, Isako ena Tirama, Iakobo ena Tirama’. Ia hanona 'ari haukia ekia Tirama aha'i, ia hanona mauri haukia ekia Tirama.” ");
INSERT INTO rro_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Mako 'abi neiana teona raninai ia ena ba'iobi 'abinai teta'u ta'u huri. ");
INSERT INTO rro_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Iesu Sadukea haukia ebaunu baihanakia pouna Parisea haukia teona raninai ia abomo teto'u. ");
INSERT INTO rro_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","'Abakia ha rauhubu hauna Iesu ehobona ebakaina etibaha, ");
INSERT INTO rro_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ba'iobi haumu e, rauhubu 'abina aeana hauna eapa'ua ki'a baha?” ");
INSERT INTO rro_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Iesu e'abi etibaha, “Obiapaka emu Tirama koraona'au aina mai aomu ikoinai mai aubamu ikoinai mai emu raona ikoinai. ");
INSERT INTO rro_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Neiana hauna hanona rauhubu 'abina apa'uana abomo kori'uaina. ");
INSERT INTO rro_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Rauhubu 'abina apa'uana ibaruana hanona neiana, heremu ai hauna koraona'au aina kipomu nuraona'au aini'o 'abana. ");
INSERT INTO rro_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Rauhubu 'abikia ikoikiai mai mahabanai 'abikia ikoikiai hanona rauhubu neiakia rua ahakiai tekori 'au.” ");
INSERT INTO rro_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Parisea haukia tito'u ohomo aonai Iesu ia ebakainakia etibaha, ");
INSERT INTO rro_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Wai hanona Keriso aea turaona aihona? Abomo ia hanona tai nahuna?” Ia tehinabena tetibaha, “Davida nahuna.” ");
INSERT INTO rro_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ba Iesu ebakainakia etibaha, “Aehoma buonai Davida Auba Robeai ebonu hanona ia Keriso eaparina Obiapaka? Pokina Davida e'abi etibaha, ");
INSERT INTO rro_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Obiapaka hanona e'u Obia ehinabena etibaha, “Itipa'u tainai komiati keaomo emu 'ou haukia 'apumu ba'anai kahorotinakia.” ");
INSERT INTO rro_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Davida Keriso eaparina e'u Obia raninai, aea homanai mo Keriso hanona Davida nahunai keao?” ");
INSERT INTO rro_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Hau ha Iesu ena 'abi kebamuena hanona a'i etaina, abomo rani weianai hau ha a'i enuako'o, Iesu a'i ebakaina. ");
INSERT INTO rro_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Weiana Iesu ehore mako mai ia i'abana haukia ehinabenakia etibaha, ");
INSERT INTO rro_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Rauhubu poki haukia mai Parisea haukia hanona Mose ena imia'auai ṯemia'au tipoki. ");
INSERT INTO rro_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ua buonai aiakia katoka'aina, ṯehina benimi akakia ikoikiai katobabai, 'a tibabai hoahoakia hanona a'i katobabai, pokina ia ṯeiroroai akakia hanona a'i tibabainakia. ");
INSERT INTO rro_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Puma rarikia iebebeai ṯebiri 'aunakia maearima 'arokiai tihore 'aunakia, 'a ia kipokia katea'i taeana hanona imakia riuriuna ituna ha a'i niata 'apuana. ");
INSERT INTO rro_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ekia babai ikoikiai hanona maearima kateihanakia kateba apa'uanakia, puka robena 'abikia tererena ṯeutanakia kohukohukia weiakia bahuba'ari aonai paukiai ṯebiri 'aunakia haukia tibapairi pairinakia abomo ekia bahuba'ari habunikia buibuikia tibawaro waronakia. ");
INSERT INTO rro_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Tatu 'ekakiai hanona imia'au namokia 'arikia ti'ari, marea aokiai imia'au 'orukia ṯenuatae ainakia. ");
INSERT INTO rro_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ekia nuatae hanona kawakawa 'ekakiai maearima katehore kateba namonakia mai katemariki ainakia haeamona kate'abi ia hanona maearima apa'uana ha. ");
INSERT INTO rro_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ia maearima a'i teme'abi wai hanona maearima apa'uami, pokina wai emi apa'ua hauna hanona hamona abomo wai ikoimiai hanona a'a mai hati. ");
INSERT INTO rro_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Hanopakai hau ha a'i katoaparina hamami, pokina wai hamami hanona hamona kupai nemiaho. ");
INSERT INTO rro_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Abomo a'i kate'abi, wai hanona poki haumi, pokina wai emi poki hauna hanona hamona Keriso. ");
INSERT INTO rro_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Baiatamiai ha kebapa'ua hauna wai emi ta'ara ia'ina haunai keao. ");
INSERT INTO rro_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Hau ha kipona nibapa'uana hauna Tirama kehore ia kebako'i ko'ina, ia kipona nibako'i ko'ina hauna Tirama kehore ia kebapa'uana.” ");
INSERT INTO rro_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Rauhubu poki haumi mai Parisea haumi bahaorea haumi, heremiai keki'a wairai, Tirama ena obia aiarana pa'abina maearima wairakiai tukaiabuna, wai kipomi a'i tutoto abomo weiakia ṯenuatae katetoto haukia tuehe abunakia. ");
INSERT INTO rro_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Rauhubu poki haumi mai Parisea haumi, bai'oi haumi, heremiai keki'a wairai, wapu ekia itu tuani 'aunakia, maearima tuba haoreanakia emi bahuba'ari tuba homa'anakia. Ua buonai puma rarina katoa'ina. ");
INSERT INTO rro_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Rauhubu poki haumi mai Parisea haumi bahaorea haumi, heremiai keki'a wairai, hanopaka maikoina tukakaiarona maearima i'abami haukiai katobaonakia, ba weiana tubabaina hanona ia ena ki'a barua tubapa'uana ia tua'i ki'ana keao iruba a'i ni'ao 'apua 'ekana wai 'abana. ");
INSERT INTO rro_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Baka'a haumi mahami ṯeki'a haumi, heremiai keki'a wairai, wai tu'abi maearima ha marea robe atana ke'abi'uai hanona robana a'i kateahuna, 'a peia gold weiana marea robe aonai hauna atanai ke'abi'uai hanona kebatohana. ");
INSERT INTO rro_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Wai po'o abomo mahami teki'a haumi, aeana hauna eapa'ua? Gold 'ao marea robe weiana gold nibarobena hauna? ");
INSERT INTO rro_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Wai haeamona tu'abi, maearima ha itara robena atanai ke'abi'uai hanona robana a'i kateahuna, 'a peia beruberu tabana itara robena ahana hauna atanai ke'abi'uai hanona kebatohana. ");
INSERT INTO rro_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Wai mahami teki'a haumi, aeana hauna eapa'ua? Beruberu tabana itara robena ahanai hauna 'ao itara robena weiana beruberu tabana nibarobena hauna? ");
INSERT INTO rro_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ua buonai itara robena atanai ni'abi'uai hauna hanona itara robena mai ahanai ṯemiaho tabakia ikoinai atakiai ni'abi'uai. ");
INSERT INTO rro_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Abomo marea robe atanai ni'abi'uai hauna hanona marea robe mai aonai nemiaho hauna atanai ni'abi'uai. ");
INSERT INTO rro_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Abomo kupa atanai ni'abi'uai hauna hanona Tirama ena imia'au mai nemia'au hauna atanai ni'abi'uai. ");
INSERT INTO rro_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Rauhubu poki haumi mai Parisea haumi wai bahaorea haumi, heremiai keki'a wairai, uma anianikia weiakia aniani tiba'orimona haukia hanona tubaharau haeanakia hamohamo tubaibeni obiapaka ena bararoai, 'a rauhubu akakia apa'uakia, bero, aoko'o mai a'ikakauma tureanakia, ba neiakia patobabai hanona penamo, weiakia abomo a'i patoreanakia. ");
INSERT INTO rro_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","'Uai haumi mahami teki'a, nene 'abiai tu'ato ahina ia mahi atana kamela hanona tutonona. ");
INSERT INTO rro_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Rauhubu poki haumi mai Parisea haumi bahaorea haumi, heremiai keki'a wairai, ere mai 'ororo kapekia ṯoutunakia ia aokia hanona bainai mai ripuripu ai toa'i tabakiai tebonu 'au. ");
INSERT INTO rro_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Parisea haumi mahami teki'a, ere mai 'ororo aokia tomoutu 'uainakia ba kapekia abomo aba katemahamaha. ");
INSERT INTO rro_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Rauhubu poki haumi mai Parisea haumi bahaorea haumi, heremiai keki'a wairai, wai hanona 'ariahakia tebaporenakia 'abakia, kapekia temahamaha 'a aokia hanona 'ari haukia huria mai pari ikoinai tebonu'au. ");
INSERT INTO rro_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Taeara ihobonai mo maearima wai haumi ṯeihanakia bero haumi 'abanai, 'a aomi hanona bai'oi mai ki'a tebonu'au. ");
INSERT INTO rro_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Rauhubu poki haumi mai Parisea haumi bahaorea haumi, heremiai keki'a wairai, mahabanai haukia ekia 'ariahakia tubabai mai bero haukia ekia 'ariahakia tubataitai harainakia. ");
INSERT INTO rro_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Wai tu'abi, ‘Kupumai ekia raniai tamarama raninai mahabanai teahu'arinakia aonai ai hanona a'i pata'i turinakia.’ ");
INSERT INTO rro_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Weiana hanona wai kipomi ṯohina pounimi, wai hanona mahabanai haukia teahu 'arinakia haukia 'aba'abakia. ");
INSERT INTO rro_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kupumi hamami ekia ki'a tea'i ramana hauna wai katobapa'ua haraina. ");
INSERT INTO rro_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Wai 'erau abomo 'erau nahukia haumi, Tirama ena puma keaoainimi iruba a'i ni'ao 'apua 'ekana herenai aea katokapare aiho? ");
INSERT INTO rro_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Mahabanai haukia aobero haukia mai ba'iobi haukia kauhunakia heremi katewahi, baika katoahu'ari, baika matiu ibiri ropoai katokoko 'aunakia, baika marea aokiai kato'atinakia, abomo aiara hai katouranakia kateao aiara ha. ");
INSERT INTO rro_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ua buonai bero haukia aruarukia ikoinai hanopaka ahanai ekiki oioi pumana hanona wai ahamiai keriri, aka bero hauna Abela aruarunai kea'i ramana keao mo Berekia nahuna Sekaraia aruaruna ia ikaihuri robena mai itara robena baiatakiai toahu'arina hauna herenai kepua. ");
INSERT INTO rro_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","'Abi tohana au wai nahinabenimi, ahuahu neiakia ikoikiai ekia puma hanona uru neiana maearimakia ahakiai keriri. ");
INSERT INTO rro_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ierusalema e, Ierusalema e, mahabanai haukia nuahu'arinakia abomo Tirama iuhubeau euhunakia heremu tewahi haukia piharai nokuinakia, rani babita anuatae nahumu kabararonakia ihobona kokoro'u ha banina ba'anai nahuna ne'umu hao 'abana, 'a a'i onuatae. ");
INSERT INTO rro_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ua buonai emu marea robe hanona kahabo 'abaeana abomo ke'aburu. ");
INSERT INTO rro_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Au oi nahinabeni'o, a'i koiha muena'u keao mo oi ko'abi kotibaha, “Tirama kehore Obiapaka atanai nimai hauna kebanamona!” ");
INSERT INTO rro_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Iesu marea robeai ekarahi taearai nika'a aonai i'abana haukia teka'a haha herena marea robe ituna robana teahuna. ");
INSERT INTO rro_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Iesu ia ehina benakia etibaha, “Taba neiakia ikoikiai ṯoihanakia? 'Abi tohana au wai nahinabenimi, pihara ha pihara ha ahanai a'i keno'au a'i kemiaho, ikoikiai hanona kateriri kate'eho.” ");
INSERT INTO rro_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Iesu olibe oeonai emiati aonai i'abana haukia tekabuni teao herena tehinabena tetibaha, “Moba 'iobinamai, taba neiakia aita katerama? Emu mai mue abomo hanopaka puana hoana hanona aea homana?” ");
INSERT INTO rro_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Iesu ekia 'abi ebamuena etibaha, “Kato'ima'ima harainimi, hau ha a'i me'oinimi. ");
INSERT INTO rro_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Pokina au ata'uai maearima bo'ona katemai kate'abi katetibaha, ‘Au Keriso neia'u,’ ba maearima bo'ona kate'oinakia. ");
INSERT INTO rro_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Wai hanona huari 'urukia mai poukia kato'o raninai nuami a'i katetae, taba uahomakia katerama ia puana hanona wairai. ");
INSERT INTO rro_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Hanopaka ha kehore hanopaka ha kehuarina, itubu ha kehore itubu ha ke'oatana. 'Eka haeai haeaiai 'arobo katerama mai 'eka bo'onai kanokau kateka'a. ");
INSERT INTO rro_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Neiakia ikoikiai hanona miori nirama haiarana kori'uaina 'abana. ");
INSERT INTO rro_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Weiana wai hanona kateaoainimi katebahaiaranimi, kateahu 'arinimi, au buo'uai hanopaka ikoikiai wai kate'oatanimi. ");
INSERT INTO rro_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Rani weiana maearima bo'ona ekia a'ikakaumai kate'eho haha kipokia hinahinakia katehina, abomo katebai'oata. ");
INSERT INTO rro_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Weiana mahabanai haukia bai'oikia bo'ona abomo katewaira tina maearima bo'ona kate'oinakia. ");
INSERT INTO rro_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Aka ki'a hanona keapa'ua buonai maearima bo'ona ekia raona'au ke'abe'abe. ");
INSERT INTO rro_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ia kekori 'ini keao puanai hauna hanona mauri kea'ina. ");
INSERT INTO rro_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Tirama ena obia aiarana pouna namona neiana hanona hanopaka maikoina aonai kateiroro aina, itubu ikoikiai kate'iobina, ba murinai hanopaka puana kemai. ");
INSERT INTO rro_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Ua buonai kaiba'uku ki'a obona tohana weiana mahabanai hauna Daniela robana eahuna hauna 'eka robenai kekoroti katoihana raninai, (tuabi tuabi hauna me'iobina.) ");
INSERT INTO rro_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","weiakia Iudai ṯemiaho haukia hanona oeo aokiai katebeau toto. ");
INSERT INTO rro_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Weiana itu kapenai hauna hanona a'i keriri ena taba itu aonai haukia a'i kea'inakia. ");
INSERT INTO rro_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Mai weiana umai nemiaho hauna a'i kemue ena itu ena habuni ia'ina a'i keao. ");
INSERT INTO rro_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Rani weiakia aokiai babi'e mai nuakia abomo miori 'oru'orukia tiba'aenakia babi'ekia herekiai hanona keki'a ki'a baha. ");
INSERT INTO rro_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Katobahuba'ari Tirama herenai, emi beau obo ipi mai hiribo 'ao beraura robenai a'i merama paunai. ");
INSERT INTO rro_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Pokina atetua rarina 'akina kerama, weiana hanopaka ea'i ramana emai mo bariu uahomana ha a'i erama, muriai abomo ihobona ha a'i kerama. ");
INSERT INTO rro_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Tirama beraura weiakia a'i pebako'onakia raninai maearima ha a'i kemauri, 'a ia ena tina'a maearimakia paukiai beraura weiakia kebako'onakia. ");
INSERT INTO rro_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Rani weianai hau ha kehina benimi ketibaha, ‘Tomoihana Keriso neiana’, 'ao ‘Ia weiana,’ raninai a'i katobatohana. ");
INSERT INTO rro_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Pokina Keriso bai'oikia mai mahabanai bai'oikia hanona katewaira tina bata'u ta'u huri akakia mai hoa rarikia katebabai, petaina raninai Tirama ena tina'a maearimakia abomo kate'oinakia. ");
INSERT INTO rro_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Katoraona 'inina Au aba naba'iobi 'uainimi. ");
INSERT INTO rro_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ua buonai ia katehina benimi katetibaha, ‘Keriso weia hano'akunai’ raninai a'i katoao, 'ao ‘Ia neiana ikaihuri aonai’, raninai a'i katobatohana. ");
INSERT INTO rro_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Pokina kupa neimare taetana niaomo tibotaina 'abana au maearima nahuna e'u mai hoana abomo ua homana. ");
INSERT INTO rro_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","'Ari hauanina enoti 'ekanai, po'i abomo weia kateto'u. ");
INSERT INTO rro_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","‘Atetua weiakia kateore murikiai beronai beraura kewapura, nawa a'i kerara, bihiu hanona kupai kate'eho, kupa hiabu tabakia ikoikiai kateibiu ibiu.’ ");
INSERT INTO rro_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Weiana maearima nahuna au e'u mai hoana hanona kupai kewaira tina, ba hanopaka maearimakia ikoikiai hanona katehai, au maearima nahuna hiabu mai nuabi rarina aonai auhao ahakiai kamai kateihana'u. ");
INSERT INTO rro_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Pihi kateubainakia urukia rarikia aonai e'u aneru kauhunakia kupa puanai keao kupa puana baura bani 'ekakiai atina'anakia maearimakia katebararonakia. ");
INSERT INTO rro_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Kuropou matiuna herenai 'iobi katoa'ina. Kuropou kehubu rauna kateahu boa raninai, wai aba kato'iobina hioro aba nikaibari. ");
INSERT INTO rro_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Taeara ihobonai taba neiakia katoihanakia raninai, wai aba kato'iobina rani hanona aba herekai au hanona aba pa'abi herenai. ");
INSERT INTO rro_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","'Abi tohana au wai nahinabenimi, uru neiana a'i ke'ari ore keao mo taba neiakia ikoikiai katerama. ");
INSERT INTO rro_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kupa mai hanopaka hanona kate'akauma, ia au e'u 'abi hanona a'i ke'akauma. ");
INSERT INTO rro_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","E'u mai beraurana abomo beraurana hoana hau ha a'i e'iobina, kupa anerukia a'i te'iobina Nahuna abomo a'i e'iobina, ia Hama'u ikupaiana mo e'iobina. ");
INSERT INTO rro_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Noa ena raniai 'abana, au maearima nahuna e'u mai ranina abomo ua kehoma. ");
INSERT INTO rro_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tou rarina a'i nimai baha aonai maearima hanona teaniani teinuinu tehawainibe eao mo wapu weianai Noa aunohiai etoto. ");
INSERT INTO rro_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","A'i te'iobi 'apuana taba kerama eao mo tou apa'uana ekara 'au, ba ikoikiai tetono 'ari. Au maearima nahuna e'u mai rarinai abomo ua kehoma. ");
INSERT INTO rro_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Rani weianai hau rua umai kateaka, Tirama kehore hamona kea'i taeana 'abana kehabona. ");
INSERT INTO rro_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Babi'e rua witi ibautuna piharana katebaherena aonai, Tirama kehore hamona kea'itaeana 'abana kehabona. ");
INSERT INTO rro_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ua buonai katomaha no'a pokina emi Obiapaka ena mai beraurana hanona a'i to'iobina. ");
INSERT INTO rro_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ia neiana katoraona 'inina, itu poki hauna pe'iobina rabi hoana tabanai bainao hauna kemai hanona ia aba pemaha no'a, ba ena itu a'i patetapana a'i patetoto. ");
INSERT INTO rro_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ua buonai wai abomimo katoba'oru rani ikoinai, pokina au maearima nahuna hanona rani weiana wai a'i tubahu bahuaina aonai kamai. ");
INSERT INTO rro_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Tai hanona ta'ara'i hauna namona mai aoberona ia ena poki hauna kehore kea'i taeana ena itu i'imanai keao, ta'ara'i miorikia ekia aniani kebenakia aniani ranina tohanai? ");
INSERT INTO rro_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ia aka weiana nibabaina aonai ena poki hauna kemue keihana raninai ia hanona kenamo. ");
INSERT INTO rro_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","'Abi tohana au wai nahinabenimi, poki hauna kehore ia kea'i taeana ena taba ikoikiai i'imakia haunai kebaona. ");
INSERT INTO rro_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ia ta'ara a'i hauna ki'a obona hanona ke'abi ketibaha, ‘E'u poki hauna a'i nimai baha.’ ");
INSERT INTO rro_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ba ia kehore 'abana ta'ara'i haukia keahunakia abomo inuinu haukia kipokia kateaniani kateinuinu haeamo. ");
INSERT INTO rro_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Rani ha ta'ara'i hauna weiana ena poki hauna a'i nibahu bahu aina abomo beraura hoana a'i e'iobina aonai ia kekara'au. ");
INSERT INTO rro_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Poki hauna kehore ia keahu ki'ana keuhu ahina bahaorea haukia kipokia 'eka hamonai, weia ia kehai mai 'aki'akina kearao'i arao'i.” ");
INSERT INTO rro_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Rani weiana Tirama ena obia aiarana hanona matoha uaho harau haea 'abakia, ekia ramepa tea'i teao hawainibe mahamaha hauna kipokia katebaitabu ahi. ");
INSERT INTO rro_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ima hanona teaopo'o 'a ima hanona teaobero. ");
INSERT INTO rro_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Weiana aopo'o uahokia ekia ramepa tea'inakia, ia karatini harikia a'i tea'i. ");
INSERT INTO rro_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","'A aobero uahokia ekia ramepa tebaharu abomo karatini harikia tea'i. ");
INSERT INTO rro_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Hawainibe mahamaha hauna hanona a'i emai baha, ba uaho parua ea'i ki'anakia teako rai tenoti teparua. ");
INSERT INTO rro_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Wapuka'a ibuanai io aiana teona etibaha, ‘Hawainibe mahamaha hauna aba nimai, tomokarahi kipokia katobaitabu ahi.’ ");
INSERT INTO rro_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ba uaho ikoikiai teno'a temikiri, ekia ramepa tea'ia'i harai. ");
INSERT INTO rro_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Weiana ao po'o uahokia tehore ao bero uahokia tenoinakia tetibaha, ‘Emi karatini harua tomobenamai emai ramepa aba kate'ao.’ ");
INSERT INTO rro_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ia ekia 'abi tebamuena tetibaha, ‘Aha'i. Wai mai ai kipokia kahabaharu hanona a'i ketaina. Namona hanona tomoao tikawa kawa 'ekanai 'eumi tomokawa.’ ");
INSERT INTO rro_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ao po'o uahokia kawakawa 'ekana teao aonai hawainibe mahamaha hauna ekara'au, teba'oru uahokia ima kipokia teao hawainibe tatuna aonai tekatoto ba pa'abi tekaiabuna. ");
INSERT INTO rro_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Murinai ao po'o uahokia temai teapari tetibaha, ‘Poki haumu e, Poki haumu e, pa'abi mokaikauna tamatoto.’ ");
INSERT INTO rro_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","'A ia ekia 'abi ebamuena etibaha, ‘'Abi tohana au wai nahina benimi, au wai a'i a'iobinimi.’ ");
INSERT INTO rro_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Weiana paunai katomaha no'a, beraura mai beraura hoana hanona wai a'i to'iobina. ");
INSERT INTO rro_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Haeamona Tirama ena obia aiarana hanona matoha hau ha harima keao 'eka homa'ana 'abana, ena ta'ara'i haukia eaparinakia, ehinabenakia ena taba ikoikiai kate'imanakia. ");
INSERT INTO rro_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Poki hauna weiana ehore ena ta'ara'i haukia ha ha ekia tabura ihobokiai moni ebenakia, hamona kina hinabu ima ebena, ha kina hinabu rua, ha hanona kina hinabu hamomo ebena ba ia harima eao. ");
INSERT INTO rro_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Kina hinabu ima ea'ina hauna hanona beronai eao akana ebabaina ba ahanai kina hinabu ima ha ebabaina. ");
INSERT INTO rro_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Kina hinabu rua ea'ina hauna abomo uamo ehoma, ba ahanai kina hinabu rua ha ebabaina. ");
INSERT INTO rro_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","'A kina hinabu hamona ea'ina hauna eao 'uri ehabina poki hauna ena moni ehano abuna. ");
INSERT INTO rro_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Rani homa'ana eao murinai ta'ara'i haukia weiakia ekia poki hauna emue emai ena moni ebakai bakai ainakia. ");
INSERT INTO rro_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kina hinabu ima ea'i hauna kina hinabu ima ha kipokia emaiainakia etibaha, ‘Poki haumu e, kina hinabu ima obena'u. Ba moihana, ahanai kina hinabu ima ha neiakia ababainakia.’ ");
INSERT INTO rro_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Poki hauna e'abi etibaha, ‘Ta'ara'i haumu namomu aka bero haumu, obabai harai, taba papakia o'ima harainakia buonai bariu taba apa'uakia i'imakiai kabaoni'o. Omai e'u aonamo aonai mototo.’ ");
INSERT INTO rro_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Kina hinabu rua ea'i hauna abomo emai e'abi etibaha, ‘Poki haumu e, kina hinabu rua obena'u. Ba moihana, ahanai kina hinabu rua ha neiakia ababainakia.’ ");
INSERT INTO rro_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Poki hauna e'abi etibaha, ‘Ta'ara'i haumu namomu aka bero haumu, obabai harai, taba papakia o'ima harainakia buonai bariu taba apa'uakia i'imakiai kabaoni'o. Omai e'u aonamo aonai mototo.’ ");
INSERT INTO rro_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","'A kina hinabu hamona ea'ina hauna emai e'abi etibaha, ‘Obiapaka e, au a'iobina oi hanona hau pahihimu, maearima haeai tebato bato 'ekakiai nueueu mai maearima haeai uho tekapo kapo otarai 'ekakiai nubararo bararo. ");
INSERT INTO rro_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ua buonai au ata'u aeao emu moni hinabu hamona hano aonai ahano abuna ba namaiaina. Moihana oi emu moni 'ekanai mo neiana.’ ");
INSERT INTO rro_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Poki hauna e'abi etibaha, ‘Ta'ara'i haumu ki'a obomu abomo o'aboro, oi nuraonana au maearima baika tebato bato 'ekakiai naeueu mai maearima tekapo kapo otarai 'ekakiai nabararo bararo, 'u? ");
INSERT INTO rro_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ua homana raninai moni i'imana haukia herekiai pohorotina ba amue amai raninai ahanai papana ha perama kipokia pa'i haeamona. ");
INSERT INTO rro_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Bariu hanona herenai kina hinabu hamona tomoa'i boina, kina hinabu harau haea ea'i hauna tomobena. ");
INSERT INTO rro_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Pokina mai 'euna hauna hanona bo'ona kabena, ena taba kebo'o ki'a, 'a ekapu hauna hanona papana herenai nemiaho hauna abomo ka'i boina. ");
INSERT INTO rro_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ta'ara'i hauna neiana ena namo aha'i hauna tomokapo ahina meao 'eka wapuranai weia kehai mai 'aki'akina kearao'i arao'i.’ ");
INSERT INTO rro_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Au maearima nahuna mai nuabi'u e'u aneru ikoikiai kipokia katamai raninai e'u imia'au nuabina ahanai kamia'au. ");
INSERT INTO rro_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Hanopakai itubu ikoikiai au waira'uai katebararona, ba au kahore maearima kabahu boanakia, mamoe 'ima hauna mamoe mai nani nibahu boana 'abana. ");
INSERT INTO rro_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Au kahore mamoe hanona itipa'u tainai, nani hanona awari'u tainai kahorotinakia. ");
INSERT INTO rro_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ba au Obia arana kahore itipa'u tainai haukia kahina benakia katibaha, ‘Hama'u ebanamonimi haumi, tomai kupa aiarana neiana hanopaka ebabaina raninai eba'oruna wai 'eumi hauna tomoa'ina wai barimi ai keao. ");
INSERT INTO rro_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Pokina au mare'a a'ari hanona wai aniani tobena'u ani, 'ako'u e'ororo hanona wai bei tobena'u ainu. Au maearima haeai hau'u hanona wai toa'i taeana'u emi 'ekai. ");
INSERT INTO rro_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Here'uai habuni aha'i hanona wai habuni tobabatotona'u. Au ainawa hanona wai au to'imana'u. Au wapura 'ekanai hanona wai totoana'u.’ ");
INSERT INTO rro_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ba bero haukia ena 'abi katebamuena katetibaha, ‘Obiapaka e, aita raninai mare'a o'ari, ba tabanianini'o, 'ao aita raninai 'akomu e'ororo ba bei tabeni oinu? ");
INSERT INTO rro_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Aita raninai taihani'o maearima haeai haumu ba ta'i taeani'o emai 'ekai, 'ao aita raninai heremuai habuni aha'i ba habuni tabeni'o? ");
INSERT INTO rro_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Aita oinawa 'ao owapura raninai ba tatoani'o?’ ");
INSERT INTO rro_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Weiana au Obia arana ia kahinabenakia katibaha, ‘'Abi tohana au wai nahinabenimi. Uaho'aba'u urarukia neiakia ha herekiai ua tobabai aiho hanona au here'uai abomo aba ua tobabai aihona.’ ");
INSERT INTO rro_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ba au Obia arana kahore awari'u tainai haukia kahinabenakia katibaha, ‘Tirama eururu ainimi haumi, here'uai tomokapare tomoao niara banai banai irubana teba'oruna tiaporo mai ena miori kipokia 'eukia hauna aonai katototo. ");
INSERT INTO rro_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Pokina au mare'a a'ari hanona a'i tobanianina'u, abomo 'ako'u e'ororo hanona bei a'i tobena'u a'i ainu. ");
INSERT INTO rro_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Au maearima haeai hau'u hanona emi 'ekanai a'i toa'i taeana'u, here'uai habuni aha'i hanona habuni ha a'i tobabatotona'u. Au ainawa mai wapura 'ekanai hanona a'i totoana'u.’ ");
INSERT INTO rro_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ia abokiamo ena 'abi katebamuena kate'abi katetibaha, ‘Obia arana e, aita raninai taihani'o, mare'a o'ari, 'ao 'akomu e'ororo, 'ao maearima haeai haumu, 'ao habuni heremuai aha'i, 'ao oinawa abomo wapura 'ekanai, ba a'i tabaraini'o?’ ");
INSERT INTO rro_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Weiana au ia kahinabenakia katibaha, ‘'Abi tohana au wai nahinabenimi, uaho'aba'u urarukia neiakia ha herekiai ua a'i tobabai aiho raninai au abomo here'uai ua a'i tobabai aiho.’ ");
INSERT INTO rro_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ba ia haukia hanona keuhunakia haiara banaibanai 'ekana kateao, 'a bero haukia hanona keuhunakia mauri banaibanai 'ekana kateao.” ");
INSERT INTO rro_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Weiana Iesu 'abi neiakia ikoikiai ebapuanakia murinai i'abana haukia ehinabenakia etibaha, ");
INSERT INTO rro_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Wai to'iobina Kabanai tatuna hanona wapu rua mo wairai. Weiana au maearima nahuna hanona hinahina'u katehina matiu ibiri ropoai katekoko 'auna'u ka'ari.” ");
INSERT INTO rro_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Rani weianai robe haukia apa'uakia mai Iuda ekia maearima apa'uakia kipokia, robe haukia arakiai hauna atana Kaiapasi ena ituai teto'u. ");
INSERT INTO rro_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ia terobahu temaea hamomo bunianai Iesu katea'ina kateahu 'arina. ");
INSERT INTO rro_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","'A ia kipokia te'abi tetibaha, “Tatu aonai a'i kahababaina maearima a'i hamaba 'uri'urinakia.” ");
INSERT INTO rro_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Iesu Betani ai morumoru hauna Simona ena ituai emiaho aonai, ");
INSERT INTO rro_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Babi'e ha kabapu mai tehorona 'arana rarinai pahakawana hauna ea'ina emai Iesu aniani 'ekanai emiati hanona arana eheina. ");
INSERT INTO rro_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","I'abana haukia teihana raninai teopuere tetibaha, “Taba buonai tehoro neiana nine'e 'abaeana? ");
INSERT INTO rro_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Tehoro neiana 'arana rarinai pekawa kawaina monina uraru haukia pebenakia.” ");
INSERT INTO rro_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","'A Iesu e'iobina taba robana tiahuna hanona ehina benakia etibaha, “Taba buonai babi'e aona tuba aro'arina? Ia aka namona 'akina au here'uai ebabaina. ");
INSERT INTO rro_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Uraru haukia hanona rani ikoinai wai heremiai katemiaho, ia au hanona rani ikoinai heremiai a'i kamiaho. ");
INSERT INTO rro_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Tehoro neiana ia eheina au aha'uai hanona ihore'u akana ia'i a'i haraina ebabaina. ");
INSERT INTO rro_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","'Abi tohana au wai nahinabenimi, hanopaka maikoina aonai pou namona kateiroro aina hanona babi'e aka neiana ebabaina hauna katehinana ia iraonanai keao.” ");
INSERT INTO rro_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Rani weianai i'abana haukia harau haea rua 'abakia ha atana Iuda Isakariote hauna hanona robe haukia apa'uakia herekia eao, ");
INSERT INTO rro_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ebakainakia etibaha, “Iesu imamiai kautana raninai taba katobena'u?” Weiana silba monikia harau aihau tebahunakia tebena. ");
INSERT INTO rro_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Rani weiana eaoaina Iuda taeara etabu rani namona tabanai Iesu imakiai keutana. ");
INSERT INTO rro_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Parawa 'abaeana ikine tatuna beraurana kori'uainai, i'abana haukia temai Iesu herena tebakaina tetibaha, “Kabanai tatuna anianina ae'eai kata'ia'i haraina koana?” ");
INSERT INTO rro_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ia ekia 'abi ebamuena etibaha, “Tomoao aiarai hau weiana herenai katohina bena katotibaha, ‘Emai poki hauna e'abi, “E'u rani aba ekaibari, Kabanai tatuna i'aba'u haukia kipokia emu ituai katababaina.” ’” ");
INSERT INTO rro_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ua buonai i'abana haukia Iesu ehinabenakia akana ihobonai tebabaina, Kabanai tatuna anianina tea'ia'i haraina. ");
INSERT INTO rro_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Erabirabi aonai Iesu mai i'abana haukia harauhaea rua kipokia aniani 'ekanai temiati teaniani. ");
INSERT INTO rro_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Tianiani aonai ia e'abi etibaha, “'Abi tohana au wai nahinabenimi, wai ha hanona au hinahina'u kohinahina.” ");
INSERT INTO rro_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","I'abana haukia aokia earo'ari ha ha tehore tebakaina tetibaha, “Obiapaka e, nuraonana au, u?” ");
INSERT INTO rro_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ia e'abi etibaha, “Hau weiana imana au ima'u ohi 'ororo hamonai ṯahao uta hauna hinahina'u kehinahina. ");
INSERT INTO rro_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Au maearima nahuna hanona Puka robenai tererena ihobonai ka'ari, ia maearima nahuna hinahinana kehinahina hauna herenai keki'a wairai maearima weiana a'i perama hanona penamo.” ");
INSERT INTO rro_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ehinahina hauna Iuda etibaha, “Ba'iobi haumu e, nuraonana au, u?” Iesu e'abi etibaha, “'Abi mo naiana ohinana.” ");
INSERT INTO rro_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ia tianiani aonai Iesu parawa ea'ina ebanamona ba ehobina, i'abana haukia ebenakia e'abi etibaha, “Tomoa'ina tomoana, neiana hanona au hau'u.” ");
INSERT INTO rro_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ba 'ere ha ea'ina ebanamona ba etiu benakia e'abi etibaha, “Ikoimiai neiana tomoinu. ");
INSERT INTO rro_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Neiana hanona au aruaru'u, 'abi 'uai aruaruna mako paukiai kekiki oi ki'a ihina haona. ");
INSERT INTO rro_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Au wai nahina benimi, bine beina neiana au a'i kainu mue keao mo Hama'u ena aiarai bine beina mahamahana wai kipokia kahainu haeamo.” ");
INSERT INTO rro_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Weiana hui ha tea'ina murinai tekarahi, Olibe oeona teao. ");
INSERT INTO rro_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ba Iesu ehinabenakia etibaha, “Bariu rabi neianai emi a'ikakauma ke'eho katohabona'u, pokina Puka robenai tererena, ‘Au mamoe i'imana hauna kahuna ba mamoe to'una hanona kerama otaraina.’ ");
INSERT INTO rro_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ia au kamikiri mue murinai au hanona ka'uai kaeao Galilea ba wai katoao.” ");
INSERT INTO rro_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petero etae e'abi etibaha, “Ikoikiai oi katehaboni'o katebeau re'a, au hanona oi a'i kahabo 'apuani'o.” ");
INSERT INTO rro_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Iesu Petero ena 'abi ebamuena etibaha, “'Abi tohana au oi nahina beni'o, bariu rabi neiana kokoro'u a'i kearara baha aonai, oi rani aihau au kobuniai aina'u. Ko'abi oi au a'i o'iobina'u.” ");
INSERT INTO rro_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petero haeamona e'abi etibaha, “'Abina aha'i, hararua paha'ari haeamo, ia au hanona a'i kabuniai aini'o.” Ba i'abana haukia abokiamo 'abi hamona weiana tehinana. ");
INSERT INTO rro_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Iesu i'abana haukia kipokia teao 'eka atana Getesemane, ba ehina benakia etibaha, “Au kaeao weia kabahuba'ari aonai wai hanona neia katomiati.” ");
INSERT INTO rro_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ia Petero mai Sebedeo nahuna rua ebaka'anakia teao. Weiana aona e'abe'abe ena raona eore, ");
INSERT INTO rro_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ba ehinabenakia etibaha, “Au ao'u hanona ni'abe'abe wairai matoha pa'ari moioina. Neia katomiaho kipokia kahabai'ima.” ");
INSERT INTO rro_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Eka'a haha 'apua aonai 'anonai e'umuti ebahuba'ari etibaha, “Hama'u e, heremuai ketaina raninai haiara 'erena neiana here'uai poa'i parena. Ia au e'u nuataeai aha'i, oi emu nuatae ai.” ");
INSERT INTO rro_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ba emue emai i'abana haukia herekia hanona tiparua eihanakia, ia ehore Petero ehinabena etibaha, “Aehoma buonai wai toaihau beraura hoana hamona kipokia a'i naha bai'ima? ");
INSERT INTO rro_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Katobai'ima katobahuba'ari baihobo aonai a'i tomototo marikina. Aubami hanona nenuatae ia hauanimi mo ni'abe'abe.” ");
INSERT INTO rro_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Emue eao rani ibaruana ebahuba'ari mue etibaha, “Hama'u e, haiara 'erena neiana ia'i obona taearana aha'i raninai kainu. Ba emu nuatae akana kerama.” ");
INSERT INTO rro_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Emue emai raninai tiparua eiha muekia pokina mahakia teparua ki'a baha. ");
INSERT INTO rro_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ua buonai ehabonakia emue rani ibaihauna ebahuba'ari, 'abi hamokia mo ehinanakia. ");
INSERT INTO rro_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ba emue emai i'abana haukia herekia ehinabenakia etibaha, “Wai tuparua mai tuarai oho mo? Tomoihana, beraurana aba ekara'au, au maearima nahuna hanona aba ki'a haukia imakiai kateutana'u. ");
INSERT INTO rro_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Tomomikiri, hamaeao. Tomoihana ehinahinaina'u hauna aba nimai.” ");
INSERT INTO rro_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Iesu ni'abi ohomo aonai i'abana haukia harau haea rua 'abakia ha Iuda ekara'au, maearima bo'ona kipokia kareba mai pura'a tea'inakia temai. Ia hanona robe haukia apa'uakia mai Iuda ekia maearima apa'uakia teuhunakia haukia. ");
INSERT INTO rro_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Hinahina hauna hoa ha eba 'iobinakia etibaha, “Kapauna hauna maearimana mo weiana ba katoa'ina.” ");
INSERT INTO rro_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Iuda beronai eka'a eao Iesu herena e'abi etibaha, “Ba'iobi haumu e, oi onamo?” Ba epauna. ");
INSERT INTO rro_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Iesu Iuda ena 'abi ebamuena etibaha, “E'u hau e, emu mai akana mobabaina.” Ba teka'a haha Iesu tea'i 'ini haraina. ");
INSERT INTO rro_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Weiana Iesu te'abana hauna ha etara kipona ena kareba eberi 'auna robe haukia arakiai hauna ena ta'ara'i hauna ha haiana ehara obona. ");
INSERT INTO rro_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Iesu ia ehinabena etibaha, “Emu kareba 'ekanai mohorotina, pokina karebai ti'au haukia ikoikiai karebai kate'ari. ");
INSERT INTO rro_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Au hama'u panoina raninai ia beronai aneru itubuna harau haea rua peuhunakia here'u hanona a'i o'iobina, 'u? ");
INSERT INTO rro_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ua perama aiho raninai, Puka robenai tererena au here'uai kerama toha hauna aea ketoha aiho?” ");
INSERT INTO rro_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Rani hamona weianai Iesu ehore to'u ehinabenakia etibaha, “Au kakikaki hau'u buonai wai imami mai karebakia mai pura'akia tomai katoa'ina'u, 'u? Rani ikoinai au hanona wai kipokia marea robe aonai amiati aba'iobi, ia a'i toa'ina'u a'i tobirina'u. ");
INSERT INTO rro_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ia mahabanai haukia ekia rererere ketohana paunai neiakia ikoikiai ṉa terama aiho.” Ba i'abana haukia ikoikiai Iesu tehabona tebeau 'akauma. ");
INSERT INTO rro_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Weiakia Iesu tea'ina hanona teaoaina robe haukia arakiai hauna Kaipasi herena, rauhubu poki haukia mai Iuda ekia maearima apa'uakia hanona weia tebararona. ");
INSERT INTO rro_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","'A Petero ehore ekaiturina atau'a tainai eka'a, teaomo robe haukia arakiai hauna ena parabu aonai tekatoto. Ia etoto 'ima haukia kipokia temiati taba kerama hanona keihana. ");
INSERT INTO rro_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Robe haukia apa'uakia mai rauhubu poki haukia hinau bai'oi haukia titabu Iesu beho 'ekanai katehorotina kateba'arina. ");
INSERT INTO rro_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Maearima bo'okia tekarahi bai'oi 'abikia herenai tehina, taba ha a'i tetabu ahina puanai hau rua tekarahi, ");
INSERT INTO rro_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","te'abi tetibaha, “Hau neiana e'abi Tirama ena marea robe hanona keahu 'iti'itina ba wapu aihau aonai kebakori muena hanona ketaina.” ");
INSERT INTO rro_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Robe haukia arakiai hauna emikiri Iesu ebakaina etibaha, “Mai emu 'abi ha? Hau neiakia ibabehomu 'abina ṯehinana hanona ekia 'abi 'arana kobamuena 'ao aha'i?” ");
INSERT INTO rro_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ia Iesu 'abi ha a'i ehinana. Robe haukia arakiai hauna haeamona ehinabena etibaha, “Mauri Tiramana atanai nabakaini'o kobatohana. Oi hanona Keriso Tirama nahuna raninai mo'abi!” ");
INSERT INTO rro_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Iesu e'abi etibaha, “'Abimo naiana aba ohinana. Ikoimiai nahinabenimi, bariu rani neiana keaoaina au maearima nahuna hiabu Tiramana itipanai kamiati mai kupa aiaranai auhao ahanai kamai katoihana'u.” ");
INSERT INTO rro_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ba robe haukia arakiai hauna kipona ena habuni etapana e'abi etibaha, “Ia hanona Tirama atana nia'i ki'ana. Taba buonai hinau 'abikia kahatabu? Bariu kipomi haiamiai Tirama atana ea'i ki'ana aiana aba tona. ");
INSERT INTO rro_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Wai taba ṉa tuho?” Maearima ena 'abi tebamuena tetibaha, “Ia hanona ebeho buonai ke'ari.” ");
INSERT INTO rro_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ba Iesu wairana te'atotina mai teahuna, ba baika tebo'ana, ");
INSERT INTO rro_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","te'abi tetibaha, “Oi Keriso, momahabanai tai ebo'ani'o hauna mohina pouna.” ");
INSERT INTO rro_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Rani weianai Petero hanona parabu aonai itu wairanai emiati, ba ta'ara'i uahona ha emai herena e'abi etibaha, “Oi abomo Iesu Galilea hauna o'abana.” ");
INSERT INTO rro_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Petero maearima ikoikiai wairakiai ebuniai etibaha, “Au a'i a'iobina oi taba robana nuahuna.” ");
INSERT INTO rro_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ba Petero ekarahi eao pa'abi 'akonai, weia ta'ara'i uahona haeai ha ehore ia eihana ba maearima ehinabenakia etibaha, “Hau neiana hanona Iesu Nasareta hauna e'abana.” ");
INSERT INTO rro_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petero haeamona ebuniai mue e'abi'uai pahihi etibaha, “'Ubi hauna e'iobina, hau weiana au a'i a'iobina.” ");
INSERT INTO rro_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Rani a'i ehoma'a murinai weia tekoroti haukia teao Petero herena te'abi tetibaha, “'Abi tohana oi abomo 'abakia ha, pokina oi emu 'abi 'urunai ṯabai'iobi.” ");
INSERT INTO rro_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ba ia e'abi'uai pahihi etibaha, “'Ubi hauna e'iobina 'abi tohana nahinana. Aha'i raninai Tirama puma kebena'u. Hau naiana au a'i a'iobina.” Beronai kokoro'u e'arara. ");
INSERT INTO rro_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ba Petero Iesu ena 'abi ehinana hauna eraona tinana, “Kokoro'u a'i ke'arara baha aonai oi rani aihau kobuniai aina'u.” Weiana ekarahi eao atapakai ehai ki'a. ");
INSERT INTO rro_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Raurani amarinai robe haukia apa'uakia mai Iuda ekia maearima apa'uakia ikoikiai terobahu 'abi tebahamona Iesu kateba'arina. ");
INSERT INTO rro_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ba Iesu tebirina tebaka'ana teaoaina Kabana hauna Pilato imanai teutana. ");
INSERT INTO rro_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Weiana Iuda hinahina hauna Iesu eihana aba puma kea'ina raninai eraona raona haraina, Silba monina harau aihau emueaina eao robe haukia apa'uakia mai Iuda ekia maearima apa'uakia kebenakia, ");
INSERT INTO rro_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","e'abi etibaha, “Au aba ki'a ababaina, pokina ena beho aha'i hauna hinahinana ahinahina.” Ia ena 'abi tebamuena tetibaha, “Weiana hanona ai aha'i oi kipomu emu aro'ari.” ");
INSERT INTO rro_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ua buonai Iuda moni weiana marea robe aonai ekapo totona ba ia ekarahi eao kipona ebato'ona e'ari. ");
INSERT INTO rro_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Robe haukia apa'uakia moni tea'ina te'abi tetibaha, “Neiana hanona aika eka rauhubu, moni neiana marea robe mauanai a'i kahautana pokina 'ari 'aranai eao.” ");
INSERT INTO rro_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","'Ari boi monina terobahu aina puanai puou babai hauna herenai hano tekawana, hano weiana hanona maearima haeai ekia 'ariahanai keao. ");
INSERT INTO rro_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Weiana buonai hano atana teaparina ‘Aruaru Hanona’ emai mo bariu. ");
INSERT INTO rro_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ieremia mahabanai hauna rani weiana ena 'abi ehinana hauna emai etohana etibaha, ‘Isaraela haukia 'ara teuahina ia 'aranai keao hauna Silba monina harau aihau tea'ina, ");
INSERT INTO rro_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","moni weiana puou babai hauna ena hano tekawana Obiapaka ehina bena'u ihobona.’ ");
INSERT INTO rro_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Rani weianai Iesu Kabana wairanai ekoroti, Kabana hauna ehore Iesu ebakaina etibaha, “Oi hanona Iuda haukia ekia obia arana, u?” Iesu ia ena 'abi ebamuena etibaha, “'E, aba nu'abi mo naiana.” ");
INSERT INTO rro_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ia robe haukia apa'uakia mai Iuda ekia maearima apa'uakia tehinau aina raninai Iesu hanona ekia 'abi ha a'i ebamuena. ");
INSERT INTO rro_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Weiana Pilato ehore Iesu ehinabena etibaha, “Ṯehinau aini'o 'abikia haeai haeai tehina aiakia a'i nuona?” ");
INSERT INTO rro_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ba Iesu 'abi ha a'i ehina 'apuana, buonai Kabana hauna aona earo'ari. ");
INSERT INTO rro_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kabanai tatukia ranikiai Kabana hauna ena hoahoa tainai maearima wapura hauna katenuatae aina hauna kebakarahi 'abaeana. ");
INSERT INTO rro_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Rani weianai wapura hauna wapura itunai emiaho hauna Baraba atana te'iobi haraina. ");
INSERT INTO rro_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Mako weia teto'u aonai Pilato ebakainakia etibaha, “Tai ṯonuatae aina kabakarahi 'abaeana, Baraba 'ao Iesu tuaparina Keriso hauna?” ");
INSERT INTO rro_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pokina Pilato e'iobi haraina Iuda ekia hau apa'uakia hanona Iesu tewamuruaina paunai imanai teutana. ");
INSERT INTO rro_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ia bakai imia'aunai emiati aonai atawana 'abi etiu ahina eao herena, “Hau naiana ena beho aha'i hauna herenai taba ha a'i kobabaina, pokina rabi ia anibi aina hanona ao'u earo'ari ki'a baha.” ");
INSERT INTO rro_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Aonai robe haukia apa'uakia mai Iuda ekia maearima apa'uakia mako tebahi ahinakia Baraba katenoi aina kebakarahina ia Iesu 'ariai kehorotina. ");
INSERT INTO rro_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Haeamona Pilato mako ebakainakia etibaha, “Terarua neiakia tai ṯonuatae aina kabakarahina?” Ia ena 'abi tebamuena tetibaha, “Baraba.” ");
INSERT INTO rro_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato e'abi etibaha, “Ba Iesu tuaparina Keriso hauna herenai taba kababaina?” Ikoikiai te'abi tetibaha, “Matiu ibiri ropo 'ubinai kokoko 'auna!” ");
INSERT INTO rro_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilato ebakainakia etibaha, “Aehoma, beho tabana ebabaina?” Ia mo teio aota ki'a tetibaha, “Matiu ibiri ropo 'ubinai kokoko 'auna!” ");
INSERT INTO rro_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilato e'iobina ena hiabu aba aha'i, weiana 'uri'uri rarina aba kerama. Buonai bei eberi hahana mako wairakiai imana eutunakia etibaha, “Au hau neiana ena 'ari buona a'i ka'arana, wai kipomi emi aro'ari.” ");
INSERT INTO rro_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Maearima ikoikiai te'abi tetibaha, “Ia ena 'ari pumana ai mai nahumai kipokia tamahoaina.” ");
INSERT INTO rro_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ba Pilato Baraba ebakarahina eao herekia, ia Iesu ebenakia kate'atina matiu ibiri ropo 'ubinai katekoko 'auna. ");
INSERT INTO rro_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kabana hauna ena huari haukia Iesu tea'ina teaoaina Kabamani itunai, ba huari haukia ikoikiai temai tekori kakaiarona. ");
INSERT INTO rro_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ia tehore Iesu ena habuni tebakuri ahina ia habuni birona tebabatotona. ");
INSERT INTO rro_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Aranai kebau'una hauna 'ini boaboai tebahuna aranai tebabau'una. Bitobito ha imana itipanai teba'ina, wairanai tekaipehu tebataeaina tetibaha, “Iuda haukia ekia obia arana e, oi onamo?” ");
INSERT INTO rro_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ba te'atotina bitobito tea'i boina, aranai te'ati ba te'ati hao 'ati haona. ");
INSERT INTO rro_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Tebataeaina epua habuni birona weiana tebakuri ahina, ia ena habuni tohakia tebabatotona. Tebaka'ana matiu ibiri ropo 'ubinai katekoko 'auna. ");
INSERT INTO rro_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Huari haukia Iesu tebaka'ana raninai Kurene hauna atana Simona tetabu ahina tebahi ahina Iesu ena matiu ibiri ropo kebuana. ");
INSERT INTO rro_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","'Eka hai tekara'au atana Kolkota. (Anina hanona ‘Ara huriakia 'ekana’.) ");
INSERT INTO rro_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Weia bine beina mai muramura mabina ha ohi tebarai haeamona Iesu tebena keinu, etema hobona mo ia a'i einu. ");
INSERT INTO rro_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Huari haukia Iesu matiu ibiri ropo 'ubinai tekoko 'auna epua baiatakiai ena habuni pu'iai tebina'ana. ");
INSERT INTO rro_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Weiana murinai temiati mahakia hanona ia teiha 'inina. ");
INSERT INTO rro_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Iesu arana 'ubinai hinau bai'oi 'abina tererena teahu 'auna tetibaha, ");
INSERT INTO rro_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Rani weianai kakikaki haukia rua Iesu kipokia ha ha ekia matiu ibiri ropo 'ubinai tekoko 'aunakia, ha itipana tainai mai ha awarina tainai. ");
INSERT INTO rro_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Maearima weia tekabanai haukia arakia tekaiai kaiainakia mai bataeai bataeai 'abikia Iesu herenai tehina, ");
INSERT INTO rro_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","tetibaha, “Oi o'abi marea robe koahu 'iti'itina wapu aihau aonai kobakori muena haumu, oi Tirama nahuna raninai kipomu moba maurini'o, matiu ibiri ropo 'ubinai moriri omai.” ");
INSERT INTO rro_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Robe haukia apa'uakia rauhubu poki haukia mai Iuda ekia maearima apa'uakia abomo tebataeaina te'abi tetibaha, ");
INSERT INTO rro_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ia maearima baika ebamaurinakia, ia aehoma kipona a'i nibamaurina? Ia hanona Isaraela ekia obia arana, bariu matiu ibiri ropo 'ubinai meriri emai hanona kaha'ikakaumana. ");
INSERT INTO rro_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ia Tirama ea'ikakaumana ba Tirama ia penuatae aina raninai bariu mebamaurina, pokina e'abi ia hanona Tirama nahuna.” ");
INSERT INTO rro_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Kakikaki haukia rua matiu ibiri ropo 'ubinai tekoko 'aunakia haukia abomo ua te'abi pahihi aiho ia herenai. ");
INSERT INTO rro_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Atiaha hanona wapura rarina hanopaka maikoinai ekaiabuna eaomo beraura ebaeno hoana 3. ");
INSERT INTO rro_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Beraura hoana 3 aonai Iesu eio etibaha, “Eloi eloi lama sabakatani!” Anina hanona ‘E'u Tirama e, E'u Tirama e, oi aehoma buonai ohabona'u!’ ");
INSERT INTO rro_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Maearima baika weia tekoroti aiana teona haukia te'abi tetibaha, “Hau neiana hanona Elia niaparina.” ");
INSERT INTO rro_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Beronai 'abakia ha ebeau eao rora'e ha ea'ina bine beina manoinai ehao uhuna, matiuai etiu taeana Iesu keinu. ");
INSERT INTO rro_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ia baika te'abi tetibaha, “Mohabona, Elia kemai kebamaurina re'a kahaihana.” ");
INSERT INTO rro_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Iesu haeamona eio aota ki'a murinai e'ari. ");
INSERT INTO rro_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Rani weianai marea robe i'aea hurina habunina etapa boana 'ubiai eriri eao mo ba'ai. Kanokau eka'a pihara tepa'a. ");
INSERT INTO rro_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","'Ari ahana 'urikia tekaikau Tirama ena robe haukia bo'okia te'ari haukia temikiri temauri mauri. ");
INSERT INTO rro_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Iesu emikiri mue murinai ekia 'ariahakiai tekarahi Ierusalema ai tekatoto maearima bo'okia herekiai tewaira tina. ");
INSERT INTO rro_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Huari poki hauna ena huari haukia kipokia Iesu te'imana, kanokau eka'a mai taba terama haukia ikoikiai teihanakia raninai teta'u wairai te'abi tetibaha, “'Abi tohana hau neiana hanona Tirama nahuna.” ");
INSERT INTO rro_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Babi'e bo'ona abomo weia atau'ai tekoroti teihana, weiakia hanona Galilea ai Iesu murinai te'au mai ta'arana tea'i babi'ekia. ");
INSERT INTO rro_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Baiatakiai hanona Maria Magadala babi'ena mai Maria ha Iakobo Iosepa ohi hinakia mai Sebedeo nahuna rua hinakia. ");
INSERT INTO rro_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Rabirabi weianai kepu hauna ha emai atana Iosepa Arimatea hauna ia abomo Iesu te'abana hauna ha. ");
INSERT INTO rro_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ia Pilato herena eao ba Iesu hauanina enoiaina, Pilato 'abi ebaibeni weiana Iesu hauanina Iosepa katebena. ");
INSERT INTO rro_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Weiana Iosepa Iesu hauanina ea'i obona, habuni mahamahana namonai e'apana. ");
INSERT INTO rro_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","'Ariahana mahamahana pihara ekuina ia kipona 'euna hauna aonai ehorena, pihara apa'uana ha ebaherena eao pa'abina ebahu abuna ba eka'a. ");
INSERT INTO rro_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Magadala babi'ena 'abana Maria ha ohi hanona weia 'ariahana abihanai temiati teihana. ");
INSERT INTO rro_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Erani raurani beraura robenai robe haukia apa'uakia mai Parisea haukia teao Pilato herena, ");
INSERT INTO rro_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","te'abi tetibaha, “Hau apa'uana e, ai bai'oi hauna weiana maurinai emiaho aonai ena 'abi ehinana hauna ṯaraona 'inina etibaha, ‘Wapu ibaihaunai kamikiri mue.’ ");
INSERT INTO rro_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ua buonai 'abi kobaibeni 'ariahana kate'ima haraina keao mo wapu ibaihaunai. Pokina a'i enamo, i'abana haukia kateao Iesu hauanina katebainao aina ba maearima haiakiai kate'abi ‘Ia hanona 'ari haukia baiatakiai aba emikiri mue.’ Bai'oi neiana muriai hauna atetuana keki'a wairai ba 'uaina hauna.” ");
INSERT INTO rro_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato ehinabenakia etibaha, “Bai'ima haukia tomoaoainakia, 'ariahana kate'ima haraina.” ");
INSERT INTO rro_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ua buonai teao 'ariahana ikaiabuna piharana tekaiabu haraina ahanai rauhubu mani'ana tehorotina, ba 'ima'ima haukia weia tehabona kateiha 'inina. ");
INSERT INTO rro_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Beraura robe eore murinai hui beraurana kori'uaina raurani amarinai, Maria Magadala babi'ena mai Maria ha ohi teao 'ariahana kateihana. ");
INSERT INTO rro_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Rani weianai kanokau rarina 'akina eka'a aonai Obiapaka ena aneru ha kupai eriri emai 'ariahana pa'abina piharana ebahere parena ahanai emia'au. ");
INSERT INTO rro_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ia hauna ea obo matoha 'imare 'abana ena habuni tepore wairai matoha 'auhao porena 'abana. ");
INSERT INTO rro_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","'Ariahana te'imana haukia aneru teihana raninai teta'u ki'a te'ururu aokia terea te'eho matoha te'ari. ");
INSERT INTO rro_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ia aneru hanona babi'e ehina benakia etibaha, “A'i tomota'u, au a'iobina wai Iesu matiu ibiri ropo ubinai tekoko 'auna hauna tutabuna. ");
INSERT INTO rro_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ia hanona neia aha'i. Ia hanona aba emikiri 'uainai ehinabenimi ihobona. Tomai enoti 'ekana tomoihana. ");
INSERT INTO rro_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ba tomoao biai i'abana haukia katohina benakia, ‘Ia hanona 'ari haukia baiatakiai aba emikiri mue ba aba ne'uai niao Galilea, weia katoihana.’ 'Abi neiana kabenimi paunai amai.” ");
INSERT INTO rro_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ua buonai babi'e 'ariahanai tekarahi noanoa mai ta'ukia mai aonamokia tebeau i'abana haukia herekia katehina benakia. ");
INSERT INTO rro_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Taearai tiao aonai Iesu kipokia tebaitabu ahi. Ehinabenakia etibaha, “Raurani namona!” Ba teao herena te'umuti aena tea'i to'o tekutiaina. ");
INSERT INTO rro_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ba Iesu ehina benakia etibaha, “A'i tomota'u, katoao uaho'aba'u katohina benakia kateao Galilea ua'a kateihana'u.” ");
INSERT INTO rro_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Babi'e taearai teka'a teao aonai, huari haukia 'ariahana te'imana haukia baika temue aiara apa'uana teao taba terama haukia poukia ikoikiai robe haukia apa'uakia herekiai tehinanakia. ");
INSERT INTO rro_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Robe haukia apa'uakia hanona Iuda ekia maearima apa'uakia kipokia teto'u te'abi'abi ekia raona tebakorina huari haukia weiakia moni rarina ha tebenakia, ");
INSERT INTO rro_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ba tehina benakia tetibaha, “Wai kato'abi katotibaha, ‘I'abana haukia rabi taparua rea aonai temai Iesu hauanina tebainao aina.’ ");
INSERT INTO rro_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Pou neiana Kabana hauna keona raninai ai kataba'amena, aona kataba kabanaina keraonana wai hanona emi ki'a aha'i, abomo taba ha aomi a'i kebaro'arina.” ");
INSERT INTO rro_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Huari haukia moni tea'ina ba tehina benakia ihobona tebabaina. Ua buonai 'abi neiana Iuda haukia baiatakiai tehina otaraina rani weianai emai mo bariu. ");
INSERT INTO rro_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ba i'abana haukia harau haea hamomo teao Galilea Iesu ehina benakia oeona teao. ");
INSERT INTO rro_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","I'abana haukia ia teihana raninai tekuti aina, 'a baika hanona aokia tekai'au kai'au. ");
INSERT INTO rro_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Iesu eka'a ha ha eao herekia ba ehinabenakia etibaha, “Tirama ehore hiabu ikoinai kupai mai hanopakai hauna aba ebena'u. ");
INSERT INTO rro_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ua buonai katoao itubu ikoikiai maearimakia herekia i'aba'u haukiai katobaonakia, katoba'uere robenakia Hamana Nahuna mai Auba Robe atakiai, ");
INSERT INTO rro_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ahinabenimi 'abikia ikoikiai katoba 'iobinakia kateka'ainakia. Tomobahu, au hanona rani ikoinai wai heremiai keao mo hanopaka kepua.” ");
INSERT INTO rro_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Tirama Nahuna Iesu Keriso pouna namona kori 'uaina hanona neiana. ");
INSERT INTO rro_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Isaia mahabanai hauna ererena etibaha, “Tirama e'abi, ‘E'u iuhubeau hauna ṉauhu 'uaina kewahi heremu, emu taeara kea'ia'i haraina.’ ");
INSERT INTO rro_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Aia ha hano'akunai neio netibaha, ‘Obiapaka ena taeara tomoba'oruna. Ena kaoao boana tomobaberona.’” ");
INSERT INTO rro_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ua buonai Ba'uere robe hauna Ioane hano'akunai ewaira tina, eba'uere robe mai eiroro etibaha, “Emi ki'ai tomoraona kabe, kato'uere robe, Tirama emi ki'a kehina haonakia.” ");
INSERT INTO rro_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Maearima bo'ona Iudea hanonai mai Ierusalema haukia ikoikiai teao Ioane Ba'uere robe hauna aiana teona, ekia ki'a tehina pou, abomo Ioridana atenai eba'uere robenakia. ");
INSERT INTO rro_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ioane habuni ebatotona hauna hanona Kamela buirana. Huana 'apana hanona Poromakau paruana, ena aniani hanona pekaupekau mai hoho beina. ");
INSERT INTO rro_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ṉa eiroro aiho maearima wairakiai. “Hau ha au muri'uai kemai hauna eapa'ua ki'a baha ba au. Au hanona a'i anamo kakuti, ena tamaka warona irubunai abomo a'i etaina'u. ");
INSERT INTO rro_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Au wai beiai naba'uere robenimi, 'a ia hanona Auba Robeai keba'uere robenimi.” ");
INSERT INTO rro_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Rani weianai Iesu Nasareta Galileai emai. Ioane ehore eba'uere robena Ioridana atenai. ");
INSERT INTO rro_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Iesu beiai ekara'au raninai, kupa epa'a eihana Auba Robe eriri ia ahanai ihana matoha rauria. ");
INSERT INTO rro_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Abomo aia ha kupai emai etibaha, “Oi hanona Au Naha'u, e'u raona'au. Au oi naonamoai ki'a bahani'o.” ");
INSERT INTO rro_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Rani a'i ehoma'a murinai Auba Robe Iesu eaoaina hano'akunai. ");
INSERT INTO rro_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Iesu weia emiaho wapu bariabui, Satani ia ehobona, 'aki tabakia kipokia temiaho, ba aneru temai tebaraina. ");
INSERT INTO rro_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ioane Ba'uere robe hauna wapura itunai tekaiabuna murinai, Iesu hanona eao Galilea ai Tirama ena pou namona eiroro aina. ");
INSERT INTO rro_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Etibaha, “'Abi'uai ranina tohana abekara'au, Tirama ena obia aiarana aba ekaibari, emi ki'ai tomoraona kabe, Pou Namona tomo a'ikakaumana.” ");
INSERT INTO rro_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Iesu hanona Galilea 'obu poena 'ekana eao raninai, Simona mai hatina Anderea ohi eihanakia, re'e 'obuai tehorena, pokina terarua hanona ba'eha haukia. ");
INSERT INTO rro_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Iesu ehina benakia etibaha, “Muri'uai tomai, au kahore wai maearima iba'ehakia kaba 'iobinimi.” ");
INSERT INTO rro_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Beronai mo ekia re'e tehabonakia murinai teao. ");
INSERT INTO rro_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ia ekataeana eao Sebedeo nahuna Iakobo mai hatina Ioane ohi eihanakia ahiai ekia re'e tia'ia'i harainakia. ");
INSERT INTO rro_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ba Iesu beronai terarua eaparinakia, hamakia Sebedeo mai teba'eha oioi miorikia ahiai tehabonakia murinai teao. ");
INSERT INTO rro_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Iesu mai i'abana haukia kipokia teao Kaperanauma aiaranai. Beraura Robeai Iesu hanona Iuda haukia ekia marea aonai ekatoto ena ba'iobi ea'i ramana. ");
INSERT INTO rro_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Maearima weiakia ena ba'iobi 'urukia teo'o raninai teta'u ta'u huri, pokina ena ba'iobi hanona mai hiabukia, rauhubu poki haukia 'abakia aha'i. ");
INSERT INTO rro_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Weia hanona hau ha aonai auba ki'a obona etoto hauna marea aonai eio etibaha, ");
INSERT INTO rro_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Iesu Nasareta haumu e! Taba heremaiai kobabaina, Oi ai koa'i ki'anamai paunai omai, u? Au oi a'iobini'o, oi hanona Robe haumu Tirama ea'i taeani'o.” ");
INSERT INTO rro_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Iesu auba ki'a obona ehina bena etibaha, “Mounu hau naiana aonai mokarahi.” ");
INSERT INTO rro_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Auba ki'a obona hau weiana eba'ururu ki'ana, mai ioiona hau weiana aonai ekarahi. ");
INSERT INTO rro_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Maearima weia ikoikiai teta'u ta'u huri, ha ha kipokia tebakai bakai, tetibaha, “Neiana taba? Ba'iobi mo mahamahana ha mai hiabuna. Auba ki'a obokia nehina benakia hanona aiana tiona.” ");
INSERT INTO rro_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ua buonai Iesu pouna Galilea hanona maikoinai tehina otaraina. ");
INSERT INTO rro_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Iesu i'abana haukia Ioane mai Iakobo kipokia marea tehabona berokiai teao Simona mai Anderea ekia ituai. ");
INSERT INTO rro_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simona rawana babi'ena einawa, hauna ehiabu ena ituai enoti. Iesu emai raninai, haianai ena inawa pouna tehinana. ");
INSERT INTO rro_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Iesu eao ia herena, imanai ea'i ebaraina eberi korina. Ena hau hiabu eore, babi'e emikiri ekia aniani ebabai. ");
INSERT INTO rro_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Beraura ekaihuna rabirabinai inawa haukia mai maearima aokiai auba ki'a obokia ṯemiaho haukia teaoainakia Iesu herena. ");
INSERT INTO rro_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Aiara maearimakia ikoikiai temai itu weiana wairanai teto'u. ");
INSERT INTO rro_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Inawa haeai haeai haukia bo'okia Iesu ebanamonakia, haeamona auba ki'a obokia bo'ona eu'u ahinakia, 'a auba ki'a obokia hanona Iesu te'iobina buonai ekaiabunakia a'i kate'abi. ");
INSERT INTO rro_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Raurani wapuranai, a'i nirani baha aonai Iesu emikiri itu ehabona, eao 'eka 'abaeanai ha, ua'a ebahuba'ari. ");
INSERT INTO rro_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ba Simona 'abana kipokia tekarahi itabuna teao. ");
INSERT INTO rro_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Weia tetabu ahina ba tehina bena tetibaha, “Maearima ikoinai hanona oi titabuni'o.” ");
INSERT INTO rro_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ia Iesu ekia 'abi ebamuena etibaha, “Aika hamaeao aiara herekai haukia, aokiai abomo kairoro, aka weiana hauna paunai amai.” ");
INSERT INTO rro_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Iesu hanona Galilea aona maikoina ekana, Iuda haukia ekia marea aokiai eiroro mai auba ki'a obokia maearima aokiai haukia eu'u u'u ahinakia. ");
INSERT INTO rro_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Morumoru hauna ha emai Iesu wairanai ekai pehu, enoina etibaha, “Ponuatae raninai, pobamaurina'u.” ");
INSERT INTO rro_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Iesu ehore eaoko'o aina, abomo etara ea'i 'apuana, ehina bena etibaha, “'E. Au nanuatae konamo. Haumu menamo!” ");
INSERT INTO rro_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Rani hamona morumoru hanona hau weiana ehabona, hauna enamo. ");
INSERT INTO rro_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Iesu hau weiana euhuna aonai eharabuna etibaha, ");
INSERT INTO rro_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Aia'u nona, hau ha haianai a'i ko'abi 'apua. Beronai koao, Robe hauna herena, haumu keihana. Mose ena rauhubu ihobona, onamo hanona beruberuna Tirama herenai kobaibeni, oi emu namo ibatohana.” ");
INSERT INTO rro_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","'A hau weiana eao 'eka ikoinai ena namo pouna ekikipa otaraina. Ena kikipa weiana buonai Iesu hanona aiara aokiai a'i ekatoto. 'A 'eka 'abaeakiai mo emiaho, 'eka haeai haeai maearimakia hanona teao herena. ");
INSERT INTO rro_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Wapu baika teore murinai Iesu haeamona emue eao Kaperanauma aiarana, maearima pouna teona ia hanona ituai. ");
INSERT INTO rro_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Maearima bo'ona 'akina temai teto'u itu ebonu 'auna, 'eka hana ha a'i emiaho eao mo pa'abi 'akonai epua, ba Iesu neiroro aiana tiona. ");
INSERT INTO rro_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Hau bani hanona mero hauna ha tebuana teaoaina. ");
INSERT INTO rro_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Maearima ebo'o ki'a baha buonai, hau weiana kateaoaina Iesu herenai hanona a'i etaina. Ua buonai Iesu 'arana paipana kapeheneai 'erere ha tebabaina. Mero hauna mai 'irena weia tebaririna eao Iesu wairanai. ");
INSERT INTO rro_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Iesu ekia a'ikakauma weiana eapa'ua ki'a baha eihana buonai, mero hauna ehina bena etibaha, “Naha'u e! Emu ki'a aba ihina hao.” ");
INSERT INTO rro_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Rauhubu poki haukia baika weia temiati, kipokia teraona raona. ");
INSERT INTO rro_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Taba buonai hau neiana ṉa ni'abi aiho? Ia Tirama herenai ni'abi ki'a. Tirama mo kipona ki'a kehina haonakia.” ");
INSERT INTO rro_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Iesu abahamo aokia e'iobina, ba wairakiai e'abi, etibaha, “Taba buonai 'abi neiana turaonana? ");
INSERT INTO rro_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ki'a ihina hao 'abina hanona e'ama'ama, a'i tubatohana re'a, bariu hau neiana kahina bena kemikiri keka'a katoihana. ");
INSERT INTO rro_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ba katobatohana, au Maearima nahuna hanona mai hiabu'u hanopakai ki'a kahina haonakia.” Ba mero hauna ehina bena etibaha, ");
INSERT INTO rro_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Au oi nahina beni'o. Omikiri, emu 'ire moa'i taeana, moka'a emu itu!” ");
INSERT INTO rro_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Maearima wairakiai emikiri, ena 'ire eouna ea'i taeana eka'a. Ikoikiai teta'u ta'u huri, Tirama tebanamona tetibaha, “Aika hoa ṉahomana ha a'i haiha 'apuana.” ");
INSERT INTO rro_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Iesu haeamona emue eao Galilea 'obu poena. Maearima bo'ona 'akina temai herena ba eba'iobinakia. ");
INSERT INTO rro_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","'A ia eka'a eao aonai, takiti a'i hauna Lebi Alepeo ena aka 'ekanai emiati eihana, Iesu ia ehina bena etibaha, “Muri'uai omai!” Lebi beronai mo emikiri murinai eao. ");
INSERT INTO rro_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Lebi ena ituai aniani 'ekanai temiati, takiti a'i haukia mai ki'a haukia bo'okia Iesu mai i'abana haukia kipokia teaniani, pokina mako Iesu murinai teka'a. ");
INSERT INTO rro_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Rauhubu poki haukia Parisea itubunai temai Iesu ki'a haukia mai takiti a'i haukia kipokia teaniani haeamo teihanakia raninai, i'abana haukia tebakainakia tetibaha, “Taba buonai Iesu maearima uahomakia kipokia tianiani haeamo?” ");
INSERT INTO rro_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Iesu aiakia eona raninai, ekia 'abi ebamuenakia etibaha, “Maearima a'i ṯeinawa haukia hanona muramura baibeni hauna a'i ṯenuatae aina, 'a inawa haukia mo ṯenuatae aina. Au aka bero haukia paukiai a'i amai, ia au hanona ki'a haukia paukiai amai.” ");
INSERT INTO rro_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Rani ha ba'uere robe hauna Ioane i'abana haukia mai Parisea haukia hanona teani robe. Ua buonai maearima baika temai Iesu tebakaina tetibaha, “Ba'uere robe hauna Ioane i'abana haukia mai Parisea haukia i'abakia haukia tiani robe, 'a oi i'abamu haukia aehoma buonai a'i tiani robe?” ");
INSERT INTO rro_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Iesu ekia 'abi ebamuena, etibaha, “Tomoraona haraina! Hawainibe mahamaha hauna ena baki haukia aonamo weiana aonai hanona aea kateani robe aiho? Aha'i baihana! Kipokia ṯemiaho oioi hanona a'i kateani robe. ");
INSERT INTO rro_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","'A rani kemai aonai hawainibe mahamaha hauna herekiai katea'i parena. Ua raninai ia abomo kateani robe. ");
INSERT INTO rro_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Habuni mahamahana puapuana ha habuni 'ai'aina marana a'i kehuri abuna, pokina habuni mahamahana puapuana keberi o'onaina habuni 'ai'aina ketapana. Mara rarina kerama. ");
INSERT INTO rro_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Abomo bine mahamahana beibei 'ai'ainai a'i kebaharuna, pokina bine mahamahana kehore beibei 'ai'aina kebua 'iti'itina, bine mai beibei ohi kateki'a haeamo. Ua buonai bine mahamahana hanona beibei mahamahanai mo katebaharuna.” ");
INSERT INTO rro_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Beraura Robenai Iesu Witi umanai ekabanai, i'abana haukia ka'akiai Witi buakia terurunakia teani. ");
INSERT INTO rro_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Parisea haukia hanona Iesu tehina bena tetibaha, “Moihana! Taba buonai oi i'abamu haukia hanona Beraura Robe rauhubuna tia'i ki'ana?” ");
INSERT INTO rro_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Iesu ekia 'abi ebamuena etibaha, “Davida ena maearima kipokia rani weianai mare'a te'ari, emikiri taba ebabaina hauna pouna a'i totuabi 'apuana? ");
INSERT INTO rro_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiata Robe hauna ena raniai, Davida emikiri eao Marea Robeai parawa robe weia robe haukia kateani hauna eani, baika ena maearima ebenakia teani.” ");
INSERT INTO rro_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Iesu haeamona ehinabe muenakia etibaha, “Tirama ehore Beraura Robe ebabaina hanona maearima ena namo paunai, ia maearima hanona Beraura Robe paunai a'i ebabaina. ");
INSERT INTO rro_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ua buonai Maearima Nahuna hanona Beraura Robe abomo keobia aina.” ");
INSERT INTO rro_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Iesu haeamona emue eao Iuda haukia ekia mareai ekatoto, weia hanona hau ha imana kobekobena eihana. ");
INSERT INTO rro_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Maearima baika aba weia Iesu te'itimana beho ha kebabaina re'a kateihana, hau weiana kebamaurina Beraura Robeai hanona behoai katehorotina. ");
INSERT INTO rro_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Iesu ima kobekobe hauna ehina bena etibaha, “Momikiri, omai ṉa'a maearima wairakiai.” ");
INSERT INTO rro_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Iesu ehore maearima ebakainakia etibaha, “Eka Rauhubu taba e'uahina kahababaina Beraura Robeai? Namo kahababaina 'ao ki'a kahababaina? Maearima kahaba maurina 'ao kahaba'arina?” Weia hanona taba ha a'i tehinana, a'i aia aiakia. ");
INSERT INTO rro_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Iesu mai opuerena eiha 'ini'ininakia, haeamona eaoko'o ainakia, pokina ekia aopahihi paunai. Ima kobekobe hauna ehina bena etibaha, “Imamu motiu pahihina!” Imana etiu pahihina hanona beronai enamo. ");
INSERT INTO rro_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ua buonai Parisea haukia mareai tekarahi, beronai teao Heroda titaina haukia kipokia teto'u, Iesu iahu'arina taearana terobahu aina. ");
INSERT INTO rro_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Iesu i'abana haukia kipokia tekarahi teao Galilea 'Obuna hanona mako rarina Galileai murikiai teao. ");
INSERT INTO rro_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Abomo maearima Iudeai, Ierusalemai, Idumeai, Ioridana ate abirana taetana haukia, Turo mai Sidono haukia abomo temai, ena poki hanona Iesu hoa weiakia ebabai poukia teo'o paukiai. ");
INSERT INTO rro_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Mako rarina 'akina buonai, Iesu i'abana haukia ehina benakia ahi ha kateba'oruna, maearima taeara a'i temekaikai abuna marikina. ");
INSERT INTO rro_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Iesu maearima bo'ona 'akina ebamaurinakia buonai, inawa haukia taeara tetabu hanona tebaituaina, Iesu katea'i 'apuana ṉa tehoma. ");
INSERT INTO rro_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Abonamo aokiai auba ki'a obokia ṯemiaho haukia Iesu teihana raninai, temai wairanai te'eho teio tetibaha, “Oi hanona Tirama Nahuna!” ");
INSERT INTO rro_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","'A Iesu hanona auba ki'a obokia eharabunakia, pouna a'i katehinana ia hanona tai. ");
INSERT INTO rro_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Iesu oeoai ekara'au enuatae ainakia haukia eaparinakia, teao herena. ");
INSERT INTO rro_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Haukia harauhaea rua ea'i taeanakia, atakia ehinana Iuhubeau haukia, ia kate'abana, keuhu ahinakia kateiroro, ");
INSERT INTO rro_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","abomo hiabu kebenakia auba ki'a obokia kateu'u ahinakia. ");
INSERT INTO rro_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Harauhaea rua haukia neiakia. Simona (Iesu ata ibaruana ebena Petero), ");
INSERT INTO rro_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sebedeo nahuna Iakobo, hatina Ioane ohi (Iesu ata ebenakia hanona Boanere, anina hanona ‘Kupa niro'u nahuna.’) ");
INSERT INTO rro_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Anderea, Pilipo, Batolomeo, Mataio, Toma, Alepeo nahuna Iakobo, Tadeo, Simona Kanana hauna, ");
INSERT INTO rro_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","mai Iuda Kariote hauna Iesu hinahinana ehinahina hauna. ");
INSERT INTO rro_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Iesu ituai etoto, maearima haeamona teto'u mue, i'abana haukia kipokia kateaniani hanona a'i etaina. ");
INSERT INTO rro_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Hatia'ana pouna teona raninai teao katebaka'ana, pokina maearima te'abi ia hanona nibeau 'ari. ");
INSERT INTO rro_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Rauhubu poki haukia baika Ierusalemai temai haukia te'abi tetibaha, “Auba ki'a obokia ekia poki hauna Belesebulo Iesu aonai etoto, hiabu ebena, auba ki'a obokia neu'u ahinakia.” ");
INSERT INTO rro_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ua buonai Iesu eaparinakia temai herena 'abi ibabataiai ehina benakia etibaha, “Aea homanai Satani hanona Satani keu'u ahina? ");
INSERT INTO rro_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Hanopaka ha kipona kebapa'ana ba terarua katehuari raninai, hanopaka weiana hanona a'i kekori 'ini 'apua. ");
INSERT INTO rro_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Itubu ha abomo kipona kebapa'ana ba kate'au raninai, itubu weiana abomo a'i kekori 'ini. ");
INSERT INTO rro_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Satani abomo ena itubu kebapa'ana ba kipokia katehuarinakia raninai, ena itubu a'i kekori 'ini, ia kepua. ");
INSERT INTO rro_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Hau ha a'i kehore tabura hauna ena itu a'i ketoto 'apua, ena itu kepukia a'i kebainaoai 'apua, keao mo ia kebiri 'uaina ba ena itu tabakia kebainao ainakia. ");
INSERT INTO rro_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","'Abi tohana mo au wai nahina benimi, Tirama hanona maearima ekia ki'a ikoikiai abomo ekia 'abi ki'a obokia ikoikiai kehina haonakia mai taearana. ");
INSERT INTO rro_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","'A hau ha Auba Robe herenai ke'abi ki'a hauna ena ki'a a'i kehina hao 'apuana kemiaho keao mo banai banai.” ");
INSERT INTO rro_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iesu ua e'abi aiho, pokina baika tetibaha, “Ia aonai hanona auba ki'a obona nemiaho.” ");
INSERT INTO rro_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ba Iesu hinana mai hatina temai atapakai tekoroti, 'abi mo teuhuna eao herena. ");
INSERT INTO rro_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","To'u rarina 'akina Iesu temia kaiarona haukia tehina bena tetibaha, “Oi hinamu mai hatimu hanona atapakai, ṯenuatae aini'o.” ");
INSERT INTO rro_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Iesu ekia 'abi ebamuena etibaha, “Tai hanona au hina'u mai hati'u?” ");
INSERT INTO rro_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Iesu maearima temia kaiarona haukia eihanakia ba ehina benakia etibaha, “Neiakia hanona au hina'u mai uaho'aba'u. ");
INSERT INTO rro_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Tirama ena nuatae akakia tibabai haukia hanona au uaho'aba'u, haibu'u mai hina'u.” ");
INSERT INTO rro_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Iesu haeamona eao Galilea 'obu poenai eba'iobi mue. To'u rarina 'akina teao herena tekori abuna buonai, Iesu ahi ha ahanai ekara'au emiati. Ahi papana ekarahi 'apua 'ourai, to'u haukia ikoikiai hanona poeai tekorina. ");
INSERT INTO rro_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Iesu hanona taba bo'okia 'abi ibabataiai to'u haukia eba'iobinakia. Ena ba'iobi aonai ṉa e'abi aiho. ");
INSERT INTO rro_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Tomobahu. Biraura hauna ha eao ena uho kebatonakia. ");
INSERT INTO rro_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ia uho umai ekapo kapo otarainakia aonai, baika hanona taearai te'eho, ba roborobo temai teani orenakia. ");
INSERT INTO rro_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Baika hanona bohuai te'eho, te'omu noanoa, pokina 'ano enibinibi 'aki. ");
INSERT INTO rro_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ia beraura etae eraranakia hanona tepaea te'ororo, pokina ramukia a'i teriri harai. ");
INSERT INTO rro_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Baika hanona awa 'ini'inikia aokiai te'eho. Te'omu, ia awa 'ini'inikia teta'a ta'a abunakia buonai, a'i tebua'a. ");
INSERT INTO rro_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Haeamona baika hanona hano namonai te'eho, ba te'omu harai tebua'a, baika buakia harau aihau, baika imabui harau haea, mai baika hinabu hamomo.” ");
INSERT INTO rro_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","'Abi puanai Iesu ehina benakia etibaha, “Mai haiana hauna hanona aia keona.” ");
INSERT INTO rro_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Iesu eikupai aonai, i'abana haukia harau haea rua mai maearima baika murinai ti'au haukia kipokia teao herena tebakaina 'abi ibabatai anikia kehina harainakia. ");
INSERT INTO rro_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Iesu ehina benakia etibaha, “Tirama ena obia aiarana 'abikia bunikia hanona wai heremiai tewaira tina harai, 'a kapeai ṯemiaho haukia taba ikoikiai hanona 'abi ibabataiai mo nahina benakia. ");
INSERT INTO rro_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ua buonai, ‘Ṯeihana ia a'i mo ṯeiha tinana, abomo tibahu aia tiona ia a'i mo ṯe'iobina. Pokina a'i temeraona kabe, Tirama ekia ki'a a'i mehina haonakia marikina.’” ");
INSERT INTO rro_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Iesu haeamona ebakainakia etibaha, “'Abi ibabataina 'ama'amana neiana a'i ṯo'iobina, u? Ba 'abi ibabatai baika hanona aea kato'iobi aihonakia. ");
INSERT INTO rro_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Biraura hauna uho weiana ekapo kapo otaraina hanona Tirama ena 'abi ekapo kapo otaraina. ");
INSERT INTO rro_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Uho weiakia taearai te'eho hanona maearima baika 'abana Tirama ena 'abi 'uruna tiona, ia Satani nimai hanona nia'i parenakia. ");
INSERT INTO rro_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Uho weiakia bohuai te'eho hanona Tirama ena 'abi 'uruna tiona mai aonamokia tia'i taea noanoana haukia 'abana. ");
INSERT INTO rro_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","'A ramukia a'i teriri harai 'ano aonai buonai, rani papana mo katemiaho, ba Tirama ena 'abi paunai kate'oatanakia 'ao kateba haiaranakia raninai, kate'eho. ");
INSERT INTO rro_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Uho weiakia awa 'ini'inikia aokiai te'eho haukia hanona maearima baika 'abana Tirama ena 'abi uruna tiona. ");
INSERT INTO rro_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","'A hanopaka ena aoaro'ari mai kepu inuataekia tihore Tirama ena 'abi aokiai haukia tia'i parenakia. Ua buonai buakia hanona aha'i. ");
INSERT INTO rro_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","'A uho weiakia hano namonai te'eho hanona maearima Tirama ena 'abi 'uruna tiona mai aokiai tia'i taeana, buakia tirama baika hanona harau aihau, baika imabui harau haea, baika hinabu hamomo.” ");
INSERT INTO rro_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Iesu haeamona ehina benakia etibaha, “Hau ha ramepa keba'arana raninai, uro aonai a'i keutana 'ao maua aonai a'i keutana. 'A ramepa ihao 'auna 'ekana tohanai kehao 'auna. ");
INSERT INTO rro_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Pokina taba tebuni haukia ikoikiai katewaira tina, abomo tehore buni tabakia ikoikiai hanona katekarahi, taba ha a'i kebuni 'apua. ");
INSERT INTO rro_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Mai haiana hauna hanona aia keona.” ");
INSERT INTO rro_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Haeamona ehina benakia etibaha, “Tuo'o 'abikia hanona tomoraona harainakia. Emi baibeni ihobokiai mo Tirama kebenimi, haeamona weiakia ahakiai harua kehore 'au. ");
INSERT INTO rro_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Pokina mai ena taba hauna ahanai kehore 'auna kebena, 'a herenai ha aha'i hauna hanona 'eunai papana nemiaho hauna abomo kea'i obona.” ");
INSERT INTO rro_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Iesu e'abi etibaha, “Tirama ena obia aiarana hanona nahomana, hau ha uho umai ekapo kapo otaraina. ");
INSERT INTO rro_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Hau weiana rabi eparua mararani emiaho, ia uho hanona te'omu tehubu, a'i e'iobina aea te'omu aiho. ");
INSERT INTO rro_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Hano kipona anina ebaramana, uho eba'omuna, hubuna etae erewa, ba murinai buana ebaramana. ");
INSERT INTO rro_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Buana ekiro iarina beraurana etaina raninai, biraura hauna ena akiua ea'ina eao, earina.” ");
INSERT INTO rro_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Iesu haeamona e'abi mue etibaha, “Tirama ena obia aiarana hanona tabai kahababataina? Ori tabanai 'abi ibabatai kahabaihobona? ");
INSERT INTO rro_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Tirama ena obia aiarana hanona matoha tuaba uhona 'abana, uho ikoikiai baiatakiai hanona ia mo papana 'aki, ba 'anoai ebatona, ");
INSERT INTO rro_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","muriai ia e'omu raninai, aniani matiukia ikoikiai eberenakia, abomo eapa'ua ki'a. Ia rena rarikia tekarahi, 'ubi roborobokia ikoikiai temai 'arunai tiarai.” ");
INSERT INTO rro_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Iesu hanona maearima weiakia ekia 'iobi ihobonai 'abi ibabatai bo'okia eba'iobinakia. ");
INSERT INTO rro_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","'A ia 'abi ibabatai ai mo ehina benakia, i'abana haukia kipokia teikupai hanona 'abi anikia eba'iobi harainakia. ");
INSERT INTO rro_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Beraura weiana mahabu mahabunai Iesu i'abana haukia ehina benakia etibaha, “Hamakabanai hamaeao 'obu abirana.” ");
INSERT INTO rro_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","I'abana haukia to'u tehabona teao, ahi weiana Iesu emia'au aina haunai tehe'au kipokia teao. Ahi baika abomo murikiai teao. ");
INSERT INTO rro_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Baura rarina 'akina eabu 'au, roio emikiri bei ahi aonai etoto, hereka 'akinai pateuhu. ");
INSERT INTO rro_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Iesu hanona ena iuna eunana ahi murinai enoti eparua. I'abana haukia teao herena, tebaona tetibaha, “Ba'iobi haumu e, aika kahatono hauna a'i nuraonana?” ");
INSERT INTO rro_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Iesu emikiri baura erikena haeamona roio ehina bena etibaha, “Tomo'oro!” Baura e'oro, roio abomo e'omata. ");
INSERT INTO rro_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Weiana Iesu i'abana haukia ebatanakia etibaha, “Aehoma ṉa tuta'u aiho? Emi a'ikakauma niaha'i oho mo?” ");
INSERT INTO rro_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","'A ia ikoikiai teta'u ki'a, tebaihamai aina, tetibaha, “Ṉahuna tai? Baura mai roio abomo aiana tiona!” ");
INSERT INTO rro_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Iesu i'abana haukia kipokia tekabanai 'obu abirana teao, Gerasa hanonai tekara'au. ");
INSERT INTO rro_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Rani weianai Iesu ahiai eriri hanona, hau ha auba ki'a obokia aonai ṯemiaho hauna 'ariahanai ekarahi emai Iesu ohi tebaitabu ahi. ");
INSERT INTO rro_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ena miaho 'ekana hanona 'ariahana, hau ha tabiri ai kebiri 'inina hanona a'i etaina. ");
INSERT INTO rro_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Pokina rani bo'ona hanona tabiri mai 'anaua ai tebirina, ia 'anaua ebamohunakia mai tabiri eba pa'anakia, ia ibamamatana hanona hau ha a'i e'iobina. ");
INSERT INTO rro_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Rabi mai mararani ia hanona 'ariahanai mai oeo ai rani ikoinai eio, abonamo ia kipona hauna wairoai eiuaiua 'auna. ");
INSERT INTO rro_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Hau weiana Iesu atau'ai nimai eihana raninai, ebeau eao wairanai ekaipehu. ");
INSERT INTO rro_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Iesu auba ki'a obona ehina bena etibaha, “Auba ki'a obona! Hau naiana aonai mokarahi.” Hau weiana eio aota etibaha, “Iesu 'Ubi 'akina Tiramana Nahuna e. Here'u ai taba kobabaina? Tirama atanai nanoini'o, a'i kobahaiarana'u.” ");
INSERT INTO rro_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Iesu ehore ebakaina etibaha, “Oi atamu hanona tai?” Ia ena 'abi ebamuena etibaha, “Ata'u hanona Mako, pokina ai hanona tabo'o ki'a baha.” ");
INSERT INTO rro_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ia Iesu enoi hao noi haona, 'eka weianai a'i keuhu ahinakia. ");
INSERT INTO rro_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Aiporo to'una rarina 'akina oeo mekenai ṯetuatua. ");
INSERT INTO rro_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Auba ki'a obokia weiakia tehore Iesu tenoina tetibaha, “Kouhunamai, aiporo weiakia aokiai katatoto.” ");
INSERT INTO rro_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ua buonai Iesu ena 'abi ai auba ki'a obokia hau weiana aonai tekarahi teao aiporo aokiai tetoto, aiporo to'una hanona taha rua (2,000) tebeau teao papa'ai terobo ahi 'obu ai tetobu, tetono 'ari. ");
INSERT INTO rro_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Aiporo 'ima haukia tebeau teao, aiara haukia mai umai teaiara haukia herekiai pou tehinana, ua buonai maearima tera'a teao taba erama hauna kateihana. ");
INSERT INTO rro_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Teao Iesu herenai tekara'au raninai, 'uainai hau weiana aonai auba ki'a obokia temiaho hauna aona aba ebero, ena habuni ebatotonakia emiati teihana raninai, teta'u ki'a. ");
INSERT INTO rro_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Maearima weiakia Iesu taba ebabaina teihana haukia maearima baika herekiai hau weiana auba ki'a obokia aonai temiaho hauna pouna mai aiporo poukia teba 'iobinakia. ");
INSERT INTO rro_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Aiara haukia tehore Iesu tenoina, ekia hano kehabona. ");
INSERT INTO rro_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Iesu ahiai ehe'au hanona auba ki'a obokia aonai temiaho hauna ehore Iesu enoina ke'abana kateao. ");
INSERT INTO rro_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","'A ia ebamuena etibaha, “Komue koao emu itu haukia herekia, Tirama aea eaoko'oai aihoni'o abomo ebamaurini'o hauna hatia'amu koba'iobinakia.” ");
INSERT INTO rro_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ua buonai hau weiana eao Tekapoli aiarakia aokiai Iesu taba herenai ebabaina hauna pouna eiroro aina, maearima ikoikiai teta'u ta'u huri. ");
INSERT INTO rro_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Iesu haeamona ahi ai ehe'au, tekabanai 'obu abiranai tebatai 'au, mako rarina hanona weia poeai haeamona teto'u mue. ");
INSERT INTO rro_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Marea poki hauna ha, atana Iairo, eao weia Iesu eihana aena pokinai ekaipehu, ");
INSERT INTO rro_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","mai aona ikoinai enoi, etibaha, “Naha'u uahouahona hanona aba ke'ari, pahaeao, haunai pohao 'au pemauri.” ");
INSERT INTO rro_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Iesu emikiri Iairo ohi teao, 'a mako rarina hanona Iesu te'opu abuna teka'a. ");
INSERT INTO rro_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Babi'e ha abomo weia babi'e ekia inawa ehaiara aina ihauna ikoinai harau haea rua. ");
INSERT INTO rro_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Muramura baibeni haukia bo'okia ia ena inawa katebanamona ia a'i etainakia, ena moni mai kepu bo'ona ebaorenakia, 'a ena inawa a'i enamo, inawa hanona eapa'ua. ");
INSERT INTO rro_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ia Iesu pouna eona raninai, mako baiatakiai ia murinai ekataeana, ena habuni ea'i 'apuana. ");
INSERT INTO rro_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Pokina ia eraonana, ‘Ena habuni mo pa'i 'apuana hanona pamauri.’ ");
INSERT INTO rro_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ena habuni ea'i 'apuana beronai aruaru e'oro, hauna eonobaina ena inawa hanona aba enamo. ");
INSERT INTO rro_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Iesu beronai eonobaina bamauri hiabuna aonai hauna ekarahi buonai ekori kabe ebakai bakai etibaha, “Tai e'u habuni ea'i 'apuana?” ");
INSERT INTO rro_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","I'abana haukia te'abi tetibaha, “Mako rarina 'akina tibai'abi aina heremuai, aehoma buonai nubakai bakai, tai ea'i 'apuani'o.” ");
INSERT INTO rro_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","'A Iesu hanona eihao ihao ia ea'i 'apuana hauna etabuna. ");
INSERT INTO rro_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Babi'e herenai erama akana aba e'iobina buonai, eta'u ki'a mai 'ururu 'ururuna eka'a eao Iesu wairanai ekaipehu, ena pou maikoina ehinana. ");
INSERT INTO rro_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Iesu ia ehina bena etibaha, “Naha'u e, emu a'ikakauma buonai aba omauri. Mai baibuamu moao. Emu haiara ikoikiai aba teore.” ");
INSERT INTO rro_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Iesu ni'abi oho mo aonai, Iairo ena ituai maearima baika temai herena tehina bena tetibaha, “Nahumu hanona aba e'ari. Ba'iobi hauna a'i mobaro'arina.” ");
INSERT INTO rro_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","'A Iesu 'abi weiana eona raninai a'i ea'i taeana, marea poki hauna ehina bena etibaha, “A'i mota'u, moa'ikakauma mo.” ");
INSERT INTO rro_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ia ehore ikoikiai ebamuenakia, tai ha a'i ke'abana, 'a Petero, Iakobo mai uaho'abana Ioane iamo teaihau kate'abana. ");
INSERT INTO rro_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Teao marea poki hauna ena ituai tekara'au, maearima eihanakia tehai aoko'o mai tehai apa'ua. ");
INSERT INTO rro_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Iesu itu aonai ekatoto, maearima ehina benakia etibaha, “Taba buonai tuhai, uru rarina 'akina tubabuana, uaho neiana a'i e'ari, 'a ia hanona niparua.” ");
INSERT INTO rro_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","'A ia hanona Iesu teiriri aina. Maearima ikoikiai ehina benakia tekarahi, epua murinai, uahouaho hamana mai hinana abomo ia mai i'abana haukia aihau kipokia teao uahouaho enoti 'ekanai tetoto. ");
INSERT INTO rro_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Iesu uahouaho imanai ea'i, ehina bena etibaha, “Tarita Kumi!” (Anina hanona ‘Uahouaho e, nahina beni'o, momikiri.’) ");
INSERT INTO rro_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Uaho uaho weiana beronai mo emikiri, ekaoao kaoao. Teihana haukia ikoikiai teta'uta'u huri. Uahouaho ihauna hanona harau haea rua. ");
INSERT INTO rro_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Iesu ehore eharabunakia pouna a'i katehinana. Haeamona ehina benakia, uahouaho ena aniani katebena. ");
INSERT INTO rro_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Iesu 'eka weiana ehabona, i'abana haukia kipokia teao ia ena aiara tohana. ");
INSERT INTO rro_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Beraura robeai ia ena ba'iobi ea'i ramana. Mareai aiana teona haukia ikoikiai teta'u ta'u huri, tetibaha, “Aotipa neiana tai ebena? Hiabu ae'eai emai hoa neiakia nibabai.” ");
INSERT INTO rro_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ia tebaki'ana, te'abi tetibaha, “Ia hanona kamuta hauna, Maria nahuna, Iakobo, Iosepa, Iuda mai Simona a'akia, haibuna baiatakai ṯemiaho.” ");
INSERT INTO rro_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Iesu ehina benakia etibaha, “Mahabanai hauna hanona 'eka ikoikiai aokiai katea'i taeana, 'a ena aiara tohanai mai hatia'ana tohakia hanona a'i katea'i taeana.” ");
INSERT INTO rro_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Weia hanona hoa bo'okia a'i ebabainakia, ia inawa haukia bita 'aki mo ahakiai ehao 'au, ebamaurinakia. ");
INSERT INTO rro_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Eta'u ta'u huri pokina ekia a'ikakauma aha'i buonai. Ia eao aiara haeai baika aokiai eba'iobi. ");
INSERT INTO rro_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Haeamona Iesu i'abana haukia harau haea rua eaparinakia temai herena, hiabu ebenakia, rua rua euhunakia auba ki'a obokia kateu'u parenakia. ");
INSERT INTO rro_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Erobenakia e'abi etibaha, “Emi kaoao aokiai taba ha a'i katoa'inakia, ikai'ini mo hamona katoa'ina. Mahoa, aniani abomo moni ha a'i katoa'ina. ");
INSERT INTO rro_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Emi tamaka katoaba'au, ibatoto ibaruakia a'i katoa'inakia. ");
INSERT INTO rro_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Katokara'au ituna weianai mo katomiaho keao mo aiara weiana katohabona. ");
INSERT INTO rro_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","A'i katea'i taeanimi 'ao aiami a'i kateona raninai katohabonakia, aemi apurorokia katotabu tabu obonakia ekia behoai keao ekia ki'a ibatohana.” ");
INSERT INTO rro_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Weiana i'abana haukia teao, teiroro maearima katebaraona kabenakia, ");
INSERT INTO rro_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","abomo auba ki'a obokia bo'okia teu'u u'u ahinakia, inawa haukia bo'okia tehoro ai tetaronakia tebamaurinakia. ");
INSERT INTO rro_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Heroda obia hauna pou weiana eona, pokina Iesu atana aba tehina otaraina. Baika te'abi tetibaha, “Ba'uere robe hauna Ioane 'ari ai aba emikiri mue ba hiabu akakia neiakia nibabainakia.” ");
INSERT INTO rro_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Haeamona baika te'abi tetibaha, “Neiana hanona Elia.” Baika tetibaha, “Neiana hanona mahabanai hauna ha, mahabanai 'uaikia 'abakia.” ");
INSERT INTO rro_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","'A Heroda uru weiana eona raninai, e'abi etibaha, “Ioane, 'akona akabe hurina hauna 'ari ai aba emikiri mue.” ");
INSERT INTO rro_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","'Uainai Ioane a'i e'ari baha aonai, Heroda hanona aba ebaiuhu, Ioane tea'ina tebirina wapura itunai tekaiabuna, weiana ebabaina hanona Herodia paunai. Heroda ehore hatina Pilipo atawana Herodia eatawana. ");
INSERT INTO rro_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ba Ioane ehore Heroda ehina bena etibaha, “Oi ohore hatimu atawana oatawa boina hanona obeho.” ");
INSERT INTO rro_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Weiana Herodia hanona Ba'uere robe hauna Ioane eopuere aina, iahu 'arina taearana etabuna, 'a ena taeara aha'i. ");
INSERT INTO rro_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Pokina Heroda hanona Ioane eta'u aina, e'iobina ia hanona aka bero abomo robe hauna, ua buonai ia ehore e'ima haraina. Rani bo'okia Heroda Ioane ena 'abi 'urukia eo'o, aona earo 'ari, ia enuatae aiana keona. ");
INSERT INTO rro_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Heroda ena rama ranina ekara'au buonai tatu apa'uana ha tebabaina, aiara obiakia, huari poki haukia, abomo Galilea maearimakia apa'uakia tebeaunakia temai. ");
INSERT INTO rro_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodia nahuna uahona emai to'u haukia wairakiai ewa. Heroda mai ena baki haukia ikoikiai aokia enamo, ba Heroda ehore uaho weiana ehina bena etibaha, “Nonuatae aina tabana ko'uahina hanona kabeni'o.” ");
INSERT INTO rro_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Herenai e'abi'uai tabura etibaha, “Taba konuatae aina hanona kabeni'o, e'u hanopaka abirana konoi aina re'a abomo kabeni'o.” ");
INSERT INTO rro_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Weiana uaho ekarahi eao hinana ebakaina etibaha, “Au taba kanoiaina?” Hinana e'abi etibaha, “Ba'uere robe hauna Ioane 'arana konoiaina.” ");
INSERT INTO rro_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Uaho haeamona emue ebeau toto eao Heroda obia 'arana hauna ehina bena etibaha, “Bariu bariu mo Ba'uere robe hauna Ioane 'arana tihu ai koutana, kobena'u.” ");
INSERT INTO rro_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Heroda obia 'arana hauna aona earo'ari, ia aba e'abi'uai uaho taba kenuatae aina hauna kebaibeni mo, abomo ena baki baki haukia weia teaniani haeamo haukia ena 'abi'uai 'uruna teona buonai keubo hanona taearana aha'i. ");
INSERT INTO rro_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ua buonai Heroda obia 'arana hauna huari hauna ha euhuna keao Ba'uere robe hauna Ioane 'arana kemaiaina. Huari hauna weiana eao wapura itunai Ba'uere robe hauna Ioane 'akona ekabe hurina. ");
INSERT INTO rro_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","'Arana tihu ai eutana eaoaina uaho ebena, uaho ehore eaoaina hinana ebena. ");
INSERT INTO rro_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ba'uere robe hauna Ioane i'abana haukia pouna teona raninai teao hauanina tea'ina teaoaina 'ariahanai tehorena. ");
INSERT INTO rro_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Iesu ena iuhubeau haukia temue teao herenai teto'u mue, tebabai tabakia mai teba'iobi 'abikia ikoikiai haianai tehinanakia. ");
INSERT INTO rro_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Mako rarina tiao timai buonai i'abana haukia ekia aniani 'ekana aha'i, ia emikiri ehina benakia etibaha, “'Eka 'abaeana ha hamaeao, ua'a katoarai.” ");
INSERT INTO rro_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ua buonai ahiai tehe 'au, tebeau banai 'eka 'abaeana ha teao. ");
INSERT INTO rro_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ekia beau ahi ai maearima bo'ona tehore teihanakia, te'iobinakia, aiara maearimakia ikoikiai tebeau raina te'uai teao 'eka weianai tekarahi. ");
INSERT INTO rro_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Tebahaha 'au aonai Iesu mako ranina eihana hanona eaoko'o ainakia matoha mamoe i'imakia hauna aha'i 'abana. Ua buonai mauri 'abikia eba'iobinakia. ");
INSERT INTO rro_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Rabirabi beraura aba kekaihuna ba i'abana haukia teao herena, tehina bena tetibaha, “Neiana hanona hano'akuna abomo beraura aba kerabi. ");
INSERT INTO rro_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ua buonai maearima neiakia pouhunakia pateao umai abomo aiarai weia ekia aniani patekawa pateani.” ");
INSERT INTO rro_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Iesu ehina benakia etibaha, “Wai kipomi aniani ha tomobenakia, temeani.” 'A i'abana haukia ia tehina bena tetibaha, “Ai katahore 200 kina anianina katakawana, katabenakia, 'u?” ");
INSERT INTO rro_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Iesu ebakainakia etibaha, “Aniani bita heremiai? Tomoao, tomoihana.” Teao teiha harai temue temai, tehina bena tetibaha, “Parawa ikine ima mai maia rua.” ");
INSERT INTO rro_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Iesu i'abana haukia ehina benakia, maearima katewatenakia to'uto'ukia ha ha tubu ahakiai katemiati. ");
INSERT INTO rro_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ua buonai maearima ikoikiai hinabu ha ha mai imbui ha ha tebamiatinakia. ");
INSERT INTO rro_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ba ia ehore parawa ima abomo maia rua ea'inakia ea'a taea kupa eihana aniani ebanamonakia. Parawa ehobinakia i'abana haukia ebenakia tewatenakia mako ikoikiai tebenakia. Maia rua abomo ua tewate aihonakia. ");
INSERT INTO rro_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Teaniani ikoikiai teani 'ari. ");
INSERT INTO rro_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Parawa mai maia harikia tebararonakia, areha ikoinai harau haea rua tebonu. ");
INSERT INTO rro_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Teaniani haukia baiatakiai hau 'abaeana hanona taha ima (5,000). ");
INSERT INTO rro_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Iesu beronai i'abana haukia euhunakia ahi ai katehe'au kate'uai kateao Betesaida abirana. 'A ia hanona to'u haukia euhunakia. ");
INSERT INTO rro_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Maearima teka'a murikiai ia ekara'au eao oeo ai kebahuba'ari. ");
INSERT INTO rro_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Beraura emahabu mahabu raninai ahi obu ibuanai, 'a ia ikupaiana hanona 'anoai. ");
INSERT INTO rro_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ia eihanakia tipara tiaro'ari pokina rani wairakiai emai buonai. Kokoro'u ekia 'arara hoanai Iesu 'aku kapenai eka'a eao herekia matoha ahi pekahaona moioina. ");
INSERT INTO rro_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ia teihana 'aku kapenai eka'a eao teraonana biriua re'a teta'u teio. ");
INSERT INTO rro_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ikoikiai teihana nuakia etae. Ia beronai ehina benakia etibaha, “A'i tomota'u, tomonua ko'o. Ṉa Au.” ");
INSERT INTO rro_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ahiai ehe'au ba rani e'oko hanona teta'uta'u huri. ");
INSERT INTO rro_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Pokina Iesu maearima parawa ebenakia teani, i'abana haukia hoa weiana obona a'i teobo, aokia tetubu abuna. ");
INSERT INTO rro_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Iesu i'abana haukia kipokia ahiai tebeau banai Genesareta poenai to'o tene'ena. ");
INSERT INTO rro_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ahiai teriri hanona maearima beronai Iesu te'iobina. ");
INSERT INTO rro_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Teka otaraina hano weiana aonai ekia inawa haukia toto'eai tebuanakia teao Iesu pouna teona nemiaho 'ekakia. ");
INSERT INTO rro_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Iesu eao 'ekakia ikoikiai aiara papakia mai aiara apa'uakia. Maearima inawa haukia tebuanakia teaoainakia kawakawa 'ekakiai tehorotinakia, tenoina ena habuni korina mo patea'i 'apuana. Ena habuni tea'i 'apuana haukia ikoikiai hanona temauri. ");
INSERT INTO rro_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Parisea mai rauhubu poki haukia baika Ierusalemai temai Iesu herenai teto'u. ");
INSERT INTO rro_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Aonai Iesu i'abana haukia baika imakia a'i teutu, mai 'opukia teaniani, weiana hanona Iuda ekia hoahoai a'i ebero Parisea haukia wairakiai. ");
INSERT INTO rro_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Parisea mai Iuda haukia ikoikiai hanona a'i tianiani 'abaea, ia ekia babai ihobonai imakia ṯeutu 'uai ba tianiani kupukia 'aba'abakia ekia hoahoa ihobona. ");
INSERT INTO rro_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Kawakawa 'ekakiai timai raninai ekia kawakawa tabakia a'i tiani baha, ia ṯeutu 'uainakia mai ia abokiamo ṯe'uere ba tianiani. Kupukia ekia rauhubu bo'ona abomo ṯe'ima harainakia matoha 'ere, uro 'ao puou iutukia 'abana. ");
INSERT INTO rro_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ua buonai Parisea mai rauhubu poki haukia Iesu tebakaina tetibaha, “I'abamu haukia kupuka 'aba'abaka tebabai akakia a'i tibabai, aehoma buonai imakia mai 'opukia tianiani?” ");
INSERT INTO rro_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Iesu ekia 'abi ebamuena etibaha, “Isaia ena mahabanaiai wai bahaorea haumi robami eahuna. Ṉa erere aihona. ‘Maearima neiakia hanona pinakiai mo Au tibanamona'u. 'A aokia tohana hanona atau'a 'akinai. ");
INSERT INTO rro_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ṯekutiai 'abaeana'u mo, pokina rauhubu neiakia maearima tiba'iobinakia hanona maearima tebabai rauhubukia.’ ");
INSERT INTO rro_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Wai hanona Tirama ena rauhubu aba tohabonakia, 'a maearima ekia rauhubu mo tua'i 'ininakia.” ");
INSERT INTO rro_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Haeamona ehina benakia etibaha, “Wai emi aotipai Tirama ena rauhubu ṯobunina, kipomi emi hoahoa tua'i 'ininakia. ");
INSERT INTO rro_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Pokina Mose e'abi etibaha, ‘Hamamu hinamu komariki ainakia’, 'a ‘hau ha hamana 'ao hinana herenai ke'abi ki'a hauna hanona katoahu 'arina.’ ");
INSERT INTO rro_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ia wai tu'abi ṯotibaha, ‘Hau ha hamana 'ao hinana kehina bena, barai barai tabakia pabenimi ia aba Koban.’ (Koban anina hanona ‘Beruberu tabakia Tirama 'euna’.) ");
INSERT INTO rro_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ua buonai maearima turauhubunakia, hamakia hinakia a'i katebarainakia. ");
INSERT INTO rro_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Hoahoa neiana tubabai hanona wai kipomi emi 'iobiai maearima tuba'iobinakia, Tirama ena 'abi ṯobunina. Weiana mo aha'i, ia uahomakia bo'okia tubabai.” ");
INSERT INTO rro_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Haeamona Iesu mako eapari muenakia teao herena, ehina benakia etibaha, “Ikoimiai katobahu, kato'iobi haraina. ");
INSERT INTO rro_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Taba weiana atapakai nitoto maearima aonai hauna maearima a'i niba'opuna, ia taba weiana maearima aonai nikarahi hauna maearima niba'opuna. ");
INSERT INTO rro_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Mai haiana hauna aia keona.” ");
INSERT INTO rro_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Iesu to'u haukia ehabonakia ituai etoto raninai i'abana haukia teao herena, 'abi ibabatai weiana anina tebakai bakai aina. ");
INSERT INTO rro_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Iesu ehina benakia etibaha, “Wai aomi a'i niea, 'u? A'i ṯo'iobina? Aniani nitoto maearima aonai hauna maearima a'i niba'opuna. ");
INSERT INTO rro_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Pokina weiana hanona aoai a'i nitoto, ia mo'oru aona niao haeamona kekarahi.” (Iesu 'abi neiana ehinana ena poki hanona aniani ikoinai tenamo kahani, a'i kateba 'opunaka.) ");
INSERT INTO rro_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","E'abi mue etibaha, “Taba aoai kekarahi hauna kehore maearima keba'opunakia. ");
INSERT INTO rro_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Raona ki'a obokia maearima aonai tikarahi tabakia hanona neiakia, nabau, bainao, ahuahu, ");
INSERT INTO rro_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","aniki'a, raonaki'a, bai'oi, rea, wamuru, apa, 'uahi'uahi, mai babai 'abaea. ");
INSERT INTO rro_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Taba ki'a obokia ikoikiai aoai tikarahi haukia tihore maearima tiba 'opunakia.” ");
INSERT INTO rro_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Iesu 'eka weianai ekaobo eao Turo hanonai, ia ena nuatae tai ha a'i ke'iobina ia hanona weia, ua buonai itu ha aonai eka toto, iamo ena pihi taearana aha'i. ");
INSERT INTO rro_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Babi'e ha nahuna uahona aonai auba ki'a obona emiaho, Iesu pouna eona raninai, beronai emai aena pokinai ekaipehu. ");
INSERT INTO rro_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Babi'e weiana hanona Iuda babi'ena aha'i, 'a ia hanona Helene babi'ena Suro-fenike ai erama. Iesu enoina auba ki'a obona nahuna aonai hauna keu'u ahina. ");
INSERT INTO rro_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","'A Iesu ia ehina bena etibaha, “Miori pateaniani 'uai, pokina miori ekia aniani kaha'ina kahakapo ahina waeha kateani hanona a'i enamo.” ");
INSERT INTO rro_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","'A babi'e e'abi etibaha, “Obiapaka e, 'abi tohana, ia waeha abomo miori tianiani 'ika'ikakia itara ba'anai haukia tiani.” ");
INSERT INTO rro_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Iesu ia ehina bena etibaha, “Ua nu'abi aiho buonai, momue moao emu itu, auba ki'a obona nahumu aonai hauna aba ekarahi.” ");
INSERT INTO rro_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Babi'e emue ena itu eao nahuna aba enamo etabu ahina ena parua 'ekanai, auba ki'a obona aba ekarahi. ");
INSERT INTO rro_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Haeamona Iesu Turo ehabona Sidono mai Dekapoli hanokiai ekabanai eao Galilea 'obunai ekarahi. ");
INSERT INTO rro_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Maearima baika tehore haiana tepo'o abomo maeana e'orare hauna ha temaiaina Iesu herena, tenoina ahanai kehao'au kebanamona. ");
INSERT INTO rro_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Iesu ehore hau weiana to'u baiatakiai ebakaparena, ba ia imana riuriuna haiana aonai etiu totona, haeamona imana e'atotina hau weiana maeana ea'i 'apuana. ");
INSERT INTO rro_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Iesu ea'a taea kupa eihana aona ebahi, ba hau weiana ehina bena etibaha, “Efata!” (Anina hanona mokaikau!) ");
INSERT INTO rro_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Beronai hau weiana haiana te'erere abomo maeana ebero e'abi'abi harai. ");
INSERT INTO rro_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Iesu ehore eharabunakia pou neiana tai ha haianai a'i katehinana. Eharabu 'ari iamo aiana a'i teona, ia pouna tehina hina otaraina. ");
INSERT INTO rro_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Maearima ikoinai teta'u ta'u huri ki'a, te'abi tetibaha, “Ia taba ikoinai nibabai harai. Haiakia tepo'o haukia aia tiona abomo maea 'orare haukia ti'abi'abi harai.” ");
INSERT INTO rro_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Rani weianai maearima bo'ona haeamona teao Iesu herenai teto'u mue. Ia aniani aha'i buonai, Iesu i'abana haukia eaparinakia temai herenai ehina benakia etibaha, ");
INSERT INTO rro_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Maearima neiakia hanona naoko'o ainakia, pokina wapu aba aihau here'uai ṯemiaho ekia aniani hanona aba eore. ");
INSERT INTO rro_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Mai mare'akia kauhunakia taearai hanona baika a'i teme'eho, pokina baika hanona 'eka homa'anai temai.” ");
INSERT INTO rro_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","I'abana haukia tehina bena tetibaha, “Aika hanona hano'akunai. Aniani ae'e ai kaha'ina, maearima neiakia kahabani aninakia?” ");
INSERT INTO rro_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Iesu ehore ebakainakia etibaha, “Emi aniani ikoinai bita?” Ia tetibaha, “Parawa 'abaihau hamomo.” ");
INSERT INTO rro_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Iesu maearima ehina benakia 'anoai katemiati. Ba parawa weiakia 'abaihau hamomo ea'i taeanakia namo 'abina Tirama ebena, ba ehobi 'iti'itinakia i'abana haukia ebenakia katewatena, maearima katebenakia. E'abi ihobona tebabaina. ");
INSERT INTO rro_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ekia maia papakia abomo weia, ebanamonakia, ba i'abana haukia ebenakia katewatenakia. ");
INSERT INTO rro_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ikoikiai teaniani, teani 'ari. I'abana haukia aniani harikia tebararonakia hanona areha 'abaihau hamomo. ");
INSERT INTO rro_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Haukia hanona ikoinai taha bani (4,000) 'abana. Ba euhunakia haha ekia 'eka teao. ");
INSERT INTO rro_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Haeamona i'abana haukia kipokia ahiai tehe'au teao Dalmanuta hanona. ");
INSERT INTO rro_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Parisea haukia temai Iesu tebakaina katehobona, hoa ha kebabaina kateihana, katebatohana ena hiabu hanona Tirama herenai emai. ");
INSERT INTO rro_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Iesu aona ebahi mai aohaiarana, e'abi etibaha, “Taba buonai uru neiana haumi hoa tutabuna? 'Abi tohana mo au wai nahina benimi, uru neiana haumi hoa ha a'i kabaihanimi.” ");
INSERT INTO rro_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Weiana ia ehabonakia ahiai ehe'au mue ekabanai 'obu abirana eao. ");
INSERT INTO rro_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","I'abana haukia parawa ikoinai tereanakia, parawa hamona mo ahiai emiaho. ");
INSERT INTO rro_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Iesu ia erobenakia etibaha, “Mahami katobano'anakia, Parisea haukia mai Heroda ekia bakupu mai ekia aoani hoahoakia a'i tomobabai marikina.” ");
INSERT INTO rro_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","I'abana haukia kipokia baiatakiai te'abi'abi tetibaha, “Aniani ha a'i hamaiaina buonai ṉa ni'abi aiho.” ");
INSERT INTO rro_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Iesu e'iobina taba ṯe'uahina, ebatanakia etibaha, “Taba buonai aniani heremi aha'i hauna robana tuahuna? Wai a'i ṯo'iobi bahana abomo obonai a'i tuobo? Aomi hama ua tepahihi aiho? ");
INSERT INTO rro_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mai mahami, ia a'i ṯoihana? Mai haiami, ia aiana a'i tuona? Taba a'i turaona 'ini? ");
INSERT INTO rro_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Au parawa ima ahobi 'iti'itinakia maearima taha ima (5,000) teani 'ari, harikia areha bita tobabonunakia?” Ia te'abi tetibaha, “Areha harau haea rua.” ");
INSERT INTO rro_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ia e'abi etibaha, “Abomo parawa 'abaihau hamomo ahobi 'iti'itinakia maearima taha bani (4,000) teani 'ari, harikia areha bita tobabonunakia?” Ia te'abi tetibaha, “Areha 'abaihau hamomo.” ");
INSERT INTO rro_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ia ehina benakia etibaha, “Wai aehoma buonai aomi a'i niea?” ");
INSERT INTO rro_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Temai Betesaida aiaranai tekara'au raninai, maearima baika maha ki'a hauna ha tebaka'ana temai Iesu herena tenoina ahanai kehao'au mahana kebanamonakia. ");
INSERT INTO rro_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Iesu maha ki'a hauna imanai e'ebe tekarahi aiara murinai, imana e'atotina ia mahana etaronakia epua imana ia mahana ahanai ehao'au ba ebakaina etibaha, “Taba aba noiha?” ");
INSERT INTO rro_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Maha ki'a hauna ea'a taea, e'abi etibaha, “Maearima naihanakia tikaoao kaoao matoha matiu 'abakia.” ");
INSERT INTO rro_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Haeamona mahanai ehao'au mue, weiana eihao ihao aonai ena ihaiha abenamo, taba ikoinai aba eiha harainakia. ");
INSERT INTO rro_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Euhuna keao ena itu, ia ehina bena etibaha, “Aiara aonai a'i kokatoto.” ");
INSERT INTO rro_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Iesu i'abana haukia kipokia Kaisarea Pilipo aiarakia teao, taearai i'abana haukia ebakainakia etibaha, “Maearima hanona taba ṉa tihoma, au hanona tai?” ");
INSERT INTO rro_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ena 'abi tebamuena tetibaha, “Baika ti'abi ṯetibaha, oi hanona Ba'uere robe hauna Ioane, 'a baika ṯetibaha, oi hanona Elia, haeamona baika ṯetibaha, oi hanona mahabanai hauna ha.” ");
INSERT INTO rro_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Haeamona ia ebakainakia etibaha, “Ia wai hanona taba ṉa tuhoma, au tai?” Petero ia ehina bena etibaha, “Oi hanona Keriso, Tirama ena a'i taea haumu.” ");
INSERT INTO rro_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Iesu eharabunakia ia pouna hau ha a'i kateba'iobina. ");
INSERT INTO rro_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ia i'abana haukia eba'iobi ramanakia, Maearima Nahuna hanona haiara bo'okia kehoainakia, aiara poki haukia, robe haukia apa'uakia, mai rauhubu poki haukia kate'oatana abomo kateahu 'arina, ia wapu ibaihaunai hanona kemikiri mue. ");
INSERT INTO rro_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","'Abi neiana ehina pou haraina raninai, Petero ehore Iesu eba kaparena haiahaiai ehinabe pahihina. ");
INSERT INTO rro_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","'A Iesu hanona ekori kabe, i'abana haukia eihanakia, Petero ebatana etibaha, “Satani, Mokapare, muri'u moao! Pokina emu raona hanona Tirama 'euna aha'i, ia maearima 'eukia.” ");
INSERT INTO rro_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Weiana Iesu mako eaparinakia abomo i'abana haukia kipokia ehina benakia etibaha, “Hau ha kenuatae au ke'abana'u raninai, ia kipona ena mauri kehabona, ena matiu ibiri ropo kea'i taeana kebuana, au muri'u ai keka'a. ");
INSERT INTO rro_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Pokina ena mauri kea'i 'inina hauna ena mauri keba 'akaumana, 'a au pau'uai mai pou namona paunai ena mauri kene'ena hauna hanona ena mauri kea'ina. ");
INSERT INTO rro_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Hau ha hanopaka maikoinai pea'ina ia ena mauri peba'akaumana hanona 'eunai ena namo taba? ");
INSERT INTO rro_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Hau ha taba kebaibeni ena mauri kea'i muena? ");
INSERT INTO rro_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Hau ha au pau'uai 'ao e'u 'abi paukiai nabau abomo aka ki'a uruna neiana wairakiai kehaumaea aina'u hauna, au Maearima Nahuna abomo ia kahaumaea aina Hama'u ena nuabiai ena aneru robekia kipokia katemai raninai.” ");
INSERT INTO rro_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Haeamona Iesu ehina benakia etibaha, “'Abi tohana mo au wai nahina benimi, baika neia tekoroti haukia a'i kate'ari baha keao mo Tirama ena obia aiarana mai hiabuna kemai hanona kateihana.” ");
INSERT INTO rro_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Beraura 'abaihau teao murinai, Iesu hanona Petero, Iakobo mai Ioane mo ebaka'anakia oeo apa'uana ha ai tekara'au, weia teikupai aonai wairakiai ihana ehaeai, ");
INSERT INTO rro_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ena habuni e'imare 'imare epore obo, epore ki'a baha hanopakai habuni utu hauna ha ua a'i pebapore aihona. ");
INSERT INTO rro_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Weiana Elia mai Mose ohi tewaira tina ia wairakiai, terarua Iesu kipokia te'abi 'abi. ");
INSERT INTO rro_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petero ehore Iesu ehina bena etibaha, “Ba'iobi haumu e, aika neia hanona enamo, i'aua aihau kata babainakia, ha oi 'eumu, ha Mose 'euna, ha Elia 'euna.” ");
INSERT INTO rro_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pokina teta'u ki'a baha buonai, Petero aea ke'abi aiho hanona a'i e'iobina. ");
INSERT INTO rro_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","'Auhao ha emai ekaiabunakia, abonamo aia ha 'auhao aonai emai, etibaha, “Neiana hanona au naha'u, e'u raona'au hauna, aiana katona.” ");
INSERT INTO rro_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Beronai teiha banai iha banai ia tai ha a'i teihana, Iesu ikupaiana mo ia baiatakiai. ");
INSERT INTO rro_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Oeoai teriri raninai, Iesu eharabunakia teiha tabakia hanona hau ha haianai a'i kate'abi, keao mo Maearima Nahuna 'ari ai kemikiri mue. ");
INSERT INTO rro_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ena 'abi tea'i 'inina, ia kipokia mo te'abi'abi aina, 'ariai mikiri mue anina hanona taba. ");
INSERT INTO rro_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ia tehore Iesu tebakaina tetibaha, “Taba buonai Rauhubu poki haukia te'abi Elia hanona kemai'uai?” ");
INSERT INTO rro_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Iesu ehina benakia etibaha, “'Abi tohana. Elia hanona kemai 'uai, taba ikoinai keba'orunakia. Ia taba buonai Maearima Nahuna 'abina Puka Robenai tererena kehaiara ki'a baha abomo kate'oatana? ");
INSERT INTO rro_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Au wai nahina benimi, Elia hanona aba emai, maearima ekia nuatae akakia ikoinai herenai tebabai, ia 'abina tererena ihobonai.” ");
INSERT INTO rro_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Temai i'abana haukia baika herekiai raninai, maearima bo'ona 'akina tekori kakaiaronakia, rauhubu poki haukia mai i'abana haukia kipokia tibaihara tae teihanakia. ");
INSERT INTO rro_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","To'u haukia Iesu teihana raninai, teta'u ta'u huri tebeau herena teao tebanamona. ");
INSERT INTO rro_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Iesu i'abana haukia ebakainakia etibaha, “Ia kipokia taba tubaihara taeaina?” ");
INSERT INTO rro_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","To'u aonai hau ha e'abi etibaha, “Ba'iobi haumu e! Au naha'u amaiaina oi heremu, pokina aonai maea ki'a aubana nemiaho a'i ni'abi'abi. ");
INSERT INTO rro_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Rani baika auba ki'a obona neibiu hanona niba'ehona 'anoai nienoti pinana 'uto'uto mai niara rabina hauna nipahihi obo. I'abamu haukia anoinakia, auba ki'a obona kateu'u ahina, ia a'i etainakia.” ");
INSERT INTO rro_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Iesu ehinabe pahihinakia etibaha, “Uru neiana haumi emi a'ikakauma aha'i, heremiai kamiaho keao mo rani tabanai? Kahau haiara heremiai keao mo rani tabanai? Miori tomaiaina here'u.” ");
INSERT INTO rro_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Miori teaoaina Iesu herena, auba ki'a obona Iesu eihana raninai, miori eba'ururu ki'ana, weiana e'eho 'anoai ehere banai here banai, pinana 'uto'uto tekarahi. ");
INSERT INTO rro_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Iesu miori hamana ebakaina etibaha, “Aita raninai nahomana ea'i ramana?” Ia e'abi etibaha, “Aba ko'iko'ina raninai. ");
INSERT INTO rro_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Rani bo'ona auba ki'a obona nihore iruba ahanai nikapo 'auna mai beiai nikapo uhuna keba'arina. Kobabaina ketaina re'a, poaoko'o ainamai, pobarainamai.” ");
INSERT INTO rro_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Iesu ehina bena etibaha, “Taba buonai kababaina ketaina ṉa ohoma! Tirama nia'ikakauma hauna herenai taba ikoikiai kebabai hanona ketaina.” ");
INSERT INTO rro_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Beronai miori hamana eio etibaha, “Au hanona aba na'ikakauma, mobaraina'u e'u a'ikakauma papana hauna mobapa'uana.” ");
INSERT INTO rro_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Iesu to'u haukia eihanakia, tera'a herena teao. Weiana ia auba ki'a obona ebatana etibaha, “Maea ki'a mai haia po'o aubana, au oi nahina beni'o. Miori aonai mokarahi, naia a'i kototo mue.” ");
INSERT INTO rro_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Auba ki'a obona eio, miori eba'ururu ki'ana, ba ia ekarahi, miori enoti matoha e'ari, maearima te'abi miori aba e'ari baihana. ");
INSERT INTO rro_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","'A Iesu miori imanai ea'i eberi taeana, beronai emikiri ekoroti. ");
INSERT INTO rro_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ia itu aonai tekatoto, i'abana haukia bunianai tebakaina tetibaha, “Taba buonai ai auba katau'u ahina hanona a'i etainamai?” ");
INSERT INTO rro_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ia ehina benakia etibaha, “Taba nahomakia iu'u ahikia taearana ha aha'i, bahuba'ari mo ikupaiana.” ");
INSERT INTO rro_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Iesu i'abana haukia kipokia 'eka weiana tehabona, Galilea hanonai tekabanai. A'i enuatae hau ha ke'iobina ia hanona ae'eai, ");
INSERT INTO rro_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","pokina i'abana haukia niba'iobinakia, ehina benakia etibaha, “Hau ha au Maearima Nahuna kehinahina aina'u maearima imakiai keutana'u, kateahu 'arina'u. 'A beraura ibaihaunai au hanona kamikiri mue.” ");
INSERT INTO rro_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","'A ia hanona a'i te'iobina taba e'uahina abonamo katebakaina hanona teta'u. ");
INSERT INTO rro_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kaperanauma aiaranai tekara'au, itu aonai Iesu i'abana haukia ebakainakia etibaha, “Bariu taearai hamai hanona taba tobaihara taeaina?” ");
INSERT INTO rro_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ia a'i te'abi, pokina taearai temai hanona tai atana keapa'ua hauna tebaihara taeaina. ");
INSERT INTO rro_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Iesu emiati, i'abana haukia harau haea rua eaparinakia, ehina benakia etibaha, “Tai nenuatae ke'uai hauna, ia kipona muri 'akinai kehorotina abomo maearima ikoikiai ekia ta'ara ia'ina haunai keao.” ");
INSERT INTO rro_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Weiana Iesu miori papana ha ea'ina wairakiai ebakorotina huanai ea'i ba ehina benakia etibaha, ");
INSERT INTO rro_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Hau ha au ata'u ai miori papana ṉa homana nia'i taeana hauna au abo'umo nia'i taeana'u, au nia'i taeana'u hauna hanona au mo ikupaia'u aha'i, ia euhuna'u Tiramana abomo nia'i taeana.” ");
INSERT INTO rro_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ioane ehore ehina bena etibaha, “Ba'iobi haumu e, hau ha taihana, atamuai auba ki'a obokia eu'u ahinakia, ai tahore tahina bena kebapuana, pokina ia hanona aika 'abaka aha'i.” ");
INSERT INTO rro_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Iesu ehina benakia etibaha, “A'i patokaiabuna, pokina au ata'uai hiabu akakia nibabai hauna, muriai au ata'u a'i kea'i ki'ana. ");
INSERT INTO rro_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Pokina a'i ni'oatanaka hauna hanona aika 'abaka. ");
INSERT INTO rro_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","'Abi tohana mo au wai nahina benimi. Ata'uai hau ha bei 'aki 'ereai kebenimi katoinu pokina wai hana Keriso 'euna, hau weiana hanona mai 'arana. ");
INSERT INTO rro_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Tai au tia'ikakaumana'u miorikia ha kebabehona hauna hanona iata rarina 'akina ha 'akonai patetoba 'auna patekapo uhuna 'akuai hanona ma enamo ba Tirama ena puma kebaibeni hauna. ");
INSERT INTO rro_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Imamu kebabehoni'o raninai, kokabe obona, imamu hamonai mauri namona aonai kototo, ba a'i enamo imamu ruai koao iruba a'i ni'ao 'apua 'ekana. ");
INSERT INTO rro_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","'Eka weiana 'erau'eraukia maearima tiani haukia hanona a'i ti'ari 'apua, abomo irubana a'i ni'ao 'apua. ");
INSERT INTO rro_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Aemu kebabehoni'o raninai, kokabe obona, aemu hamonai mauri namona aonai kototo, ba a'i enamo aemu rua namokiai iruba 'ekanai katekapo totoni'o. ");
INSERT INTO rro_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","'Eka weiana 'erau'eraukia maearima tiani haukia hanona a'i ti'ari 'apua, abomo irubana a'i ni'ao 'apua. ");
INSERT INTO rro_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Mahamu kebabehoni'o raninai, ko'ipahina, mahamu hamonai Tirama ena obia aiaranai kototo ba a'i enamo mahamu rua namokiai iruba 'ekanai katekapo totoni'o. ");
INSERT INTO rro_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","'Eka weiana 'erau'eraukia maearima tiani haukia hanona a'i ti'ari 'apua, abomo irubana a'i ni'ao 'apua. ");
INSERT INTO rro_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Weiana puma iruba 'abana kehore maearima ikoikiai kebahaiara banainakia matoha kikimaru ai tekapanakia 'abana. ");
INSERT INTO rro_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Kikimaru hanona taba namona, 'a kikimaru a'i ke'aku'aku hanona iba'aku muena taearana aha'i. Wai hanona uahomanai a'i katoao, ia kikimaru katoa'ina baiatamiai, katomiaho oioi mai baibuami.” ");
INSERT INTO rro_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Iesu 'eka weiana ehabona eao Iuda hanonai ekabanai eao Ioridana taina. Maearima bo'ona temai Iesu herenai teto'u mue, haeamona eba'iobinakia rani ikoinai nibabai ihobokia. ");
INSERT INTO rro_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Parisea haukia baika herena teao tehobona tetibaha, “Eka rauhubuai hau ha atawana kebakarahina hanona mai ena bero, 'ao?” ");
INSERT INTO rro_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Iesu ehina benakia etibaha, “Mose ena rauhubuai hanona taba ṉa ehoma?” ");
INSERT INTO rro_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ia ena 'abi tebamuena tetibaha, “Mose ena rauhubu e'abi, hau ha atawana kebakarahina hanona marerena kererena keao babi'e herena, ba babi'e kebakarahina.” ");
INSERT INTO rro_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Iesu ehina benakia etibaha, “Pokina emi ao pahihi paunai Mose rauhubu neiana ebenimi. ");
INSERT INTO rro_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ia Tirama hanopaka ebaramana raninai, maearima ebabainakia hau mai babi'e. ");
INSERT INTO rro_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ua buonai hau hanona hamana hinana nihabonakia, ia atawana ohi katemiaho haeamo. ");
INSERT INTO rro_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ia terarua hauanikia hanona hamona 'abana. Ua buonai terarua hauanikia hanona hamona, ia rua aha'i. ");
INSERT INTO rro_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Tirama ehore ebahamomonakia hauna maearima a'i katebapa'ana.” ");
INSERT INTO rro_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Teao itu ha aonai, i'abana haukia hanona Iesu herenai 'abi weiana anina tebakai bakai muena. ");
INSERT INTO rro_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Iesu ehina benakia etibaha, “Hau ha atawana kebakarahina haeamona babi'e ha keatawa muena ia hanona nabau ki'a hauna. ");
INSERT INTO rro_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Babi'e abomo atawana kehabona hau ha keatawana re'a ia hanona nabau ki'a babi'ena.” ");
INSERT INTO rro_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Maearima baika nahukia teaoainakia Iesu herena ahakiai kehao'au kebanamonakia, ia i'abana haukia tehore tebatanakia. ");
INSERT INTO rro_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Iesu babai weiana eihana raninai eopuere, etibaha, “Miori papakia naiakia tomohabonakia, temai au here'u, a'i tomou'unakia, pokina ṉahomakia hanona Tirama ena obia aiarana haukia. ");
INSERT INTO rro_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","'Abi tohana au wai nahina benimi, hau ha Tirama ena obia aiarana ia'inai miori papana 'abanai a'i keao raninai, ia hanona a'i kekatoto 'apua.” ");
INSERT INTO rro_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Weiana Iesu miori ea'inakia, imana ahakiai ehao'au ebanamonakia. ");
INSERT INTO rro_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Iesu taearai eka'a eao aonai, hau ha ebeau turina eao wairanai ekaipehu ebakaina etibaha, “Ba'iobi haumu namomu e, au aea kahoma mauri banaibanai ka'ina?” ");
INSERT INTO rro_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Iesu ehore ehina bena etibaha, “Taba buonai au namo'u ohinana? Hau ha a'i enamo, ia Tirama ikupaiana mo enamo. ");
INSERT INTO rro_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Rauhubu aba o'iobina. A'i koahuahu, a'i konabau, a'i kobainao, a'i kohinau bai'oi, a'i kobai'oi, hamamu hinamu komariki ainakia.” ");
INSERT INTO rro_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Hau weiana e'abi etibaha, “Ba'iobi haumu e, rauhubu naiakia hanona ko'iko'i'u raninai a'ima harainakia emai mo bariu.” ");
INSERT INTO rro_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Weiana Iesu ia eiha 'ini'inina mai raona'auna ba e'abi etibaha, “Taba hamona okapu aina hanona neiana, emu kepu kokawa kawainakia, monikia uraru haukia kobenakia weiana kupai 'aramu koa'ina, ba komai muri'uai koka'a.” ");
INSERT INTO rro_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","'Abi weiana eona raninai, wairana ebirabira ekaobo mai ao haiarana, pokina ia hanona kepu hauna. ");
INSERT INTO rro_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Iesu eihao ihao, i'abana haukia ehina benakia etibaha, “Taba herekia tebo'o haukia Tirama ena obia aiarana aonai katetoto hanona epahihi ki'a baha.” ");
INSERT INTO rro_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","I'abana haukia 'abi weiana teona hanona teta'u ta'u huri, haeamona ehinabe muenakia etibaha, “Naha'u e, Tirama ena obia aiarana ikatotona hanona epahihi ki'a baha. ");
INSERT INTO rro_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamela kopi ererenai kekuri banai hanona ketaina, 'a obia hauna Tirama ena obia aiaranai ketoto hanona epahihi ki'a baha.” ");
INSERT INTO rro_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","I'abana haukia teta'u ta'u huri, kipokia baiatakiai te'abi'abi tetibaha, “Tai hanona mauri kea'ina?” ");
INSERT INTO rro_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Iesu eiha 'ini'ininakia, ba etibaha, “Taba ibabaikia maearima herekiai a'i ketaina, ia Tirama herenai hanona etaina. Pokina taba ikoikiai ibabaikia Tirama herenai hanona etaina.” ");
INSERT INTO rro_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Weiana Petero ehore Iesu ehina bena etibaha, “Ai hanona emai taba ikoikiai tahabonakia, oi murimuai ṯaka'a.” ");
INSERT INTO rro_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Iesu e'abi etibaha, “'Abi tohana au wai nahina benimi, hau ha kehore au pau'uai 'ao pou namona paunai ena itu, uaho'abana, haibuna, hinana, hamana, nahuna, 'ao ena hano kehabonakia, ");
INSERT INTO rro_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","bariu rani neianai ia hanona taba bo'okia kea'i, ena itu, uaho'abana, haibuna, hinana, hamana, nahuna 'ao ena hano ikoikiai hinabu hinabu kea'i, abomo kateba haiarana, ba rani kemai aonai ia hanona mauri banaibanai kea'ina. ");
INSERT INTO rro_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Bariu bo'okia ṯe'uai haukia hanona katemurihai, ia ṯemurihai haukia hanona kate'uai.” ");
INSERT INTO rro_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Taearai teka'a Ierusalema teao aonai Iesu hanona e'uai i'abana haukia aokia earo 'ari, abomo murinai teka'a haukia teta'u, weiana Iesu ehore i'abana haukia eapari parenakia, herenai taba kerama hauna pouna wairakiai ehinana. ");
INSERT INTO rro_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Etibaha, “Aika bariu nahakara'au Ierusalemai weia hau ha au Maearima Nahuna hinahina'u kehinahina Robe haukia mai Rauhubu poki haukia herekiai, iahu'ari'u 'abina katebatohana, rama haeai haukia katebenakia. ");
INSERT INTO rro_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Maearima weiakia au katebatae aina'u kate'atotina'u kate'atina'u ba kateahu 'arina'u, ia wapu ibaihaunai kamikiri mue.” ");
INSERT INTO rro_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sebedeo nahuna rua Iakobo mai Ioane ohi temai Iesu herena, tehina bena tetibaha, “Ba'iobi haumu e, emai nuatae tabana ha heremu ai katanoiaina hanona kobabaina.” ");
INSERT INTO rro_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Iesu e'abi etibaha, “Taba ṯonuatae aina heremiai kababaina?” ");
INSERT INTO rro_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ia te'abi tetibaha, “Emu nuabi koa'ina raninai, ai tararua ha oi itipamuai ha awarimuai patamiati.” ");
INSERT INTO rro_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","'A Iesu ia ehina benakia etibaha, “tunoiaina tabana hanona a'i ṯo'iobina. Au kainu 'erena wai katoinu ketainimi? Abomo au kateba'uere robena'u 'uere robena wai kateba'uere robenimi ketaina?” ");
INSERT INTO rro_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Terarua te'abi tetibaha, “'E, ketainamai.” Ba Iesu ehina benakia etibaha, “Au kainu 'erena hanona wai abomimo katoinu, abomo au kateba'uere robena'u 'uere robena wai abomimo kateba'uere robenimi. ");
INSERT INTO rro_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","'A itipa'uai mai awari'uai katemiati haukia hanona au a'i katina'anakia. Miati 'ekakia weiakia hanona Tirama aba eba'orunakia, ia ena nuatae haukia mo 'eukia.” ");
INSERT INTO rro_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","I'abana haukia harau haea 'uru weiana teona hanona Iakobo mai Ioane ohi teopuere ainakia. ");
INSERT INTO rro_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Iesu eaparinakia temai herena ehina benakia etibaha, “Wai to'iobina. Rama haeai haukia ekia maearima tiobia ainakia, ia hanona taburai maearima ṯe'uai ainakia, haeamona ekia hiabuai maearima ṯe'imanakia. ");
INSERT INTO rro_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","'A wai baiatamiai hanona ua homana aha'i, tai apa'ua keraonana hauna hanona ta'arami ia'inai keao. ");
INSERT INTO rro_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Tai nenuatae ke'uai hauna hanona wai ikoimiai ta'arami ia'ina haunai keao. ");
INSERT INTO rro_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Pokina au Maearima Nahuna amai hanona ta'ara'u a'i katea'i, 'a ta'ara ka'i paunai amai, abonamo e'u mauri kabaibeni maearima bo'ona kakawanakia katemauri.” ");
INSERT INTO rro_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ia Ierikoai tekara'au. Iesu haeamona i'abana haukia mai maearima bo'ona kipokia Ieriko tihabona, taeara haianai maha ki'a hauna atana Batimeo (anina hanona Timeo nahuna) emiati weia enoi ba'ame. ");
INSERT INTO rro_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Hau weiana Iesu Nasareta hauna atana tehinana 'uruna eona raninai, beronai eapari etibaha, “Iesu Davida nahuna e! Moaoko'o aina'u.” ");
INSERT INTO rro_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Maearima tehore terikena 'uruna keaha'i, 'a ia hanona eapari hao apari hao eapari 'aota etibaha, “Davida nahuna e! Moaoko'o aina'u.” ");
INSERT INTO rro_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Iesu ekoroti, ehina benakia etibaha, “Tomoaparina.” Ua buonai ia tehore maha ki'a hauna tehina bena, “Aomu menamo, momikiri, ia hanona oi niaparini'o.” ");
INSERT INTO rro_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Beronai ena habuni iro'abuna ene'ena, emikiri eka'a eao Iesu herena. ");
INSERT INTO rro_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Iesu ia ebakaina etibaha, “Taba nonuatae aina kababaina heremuai?” Maha ki'a hauna e'abi etibaha, “Ba'iobi haumu e. Nanuatae maha'u pobano'anakia.” ");
INSERT INTO rro_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Iesu ehina bena etibaha, “Moao, emu a'ikakauma ehore aba eba maurini'o.” Mahana aba teno'a, weiana Iesu murinai eka'a. ");
INSERT INTO rro_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ierusalema tetabuna teao, temai Olibe oeonai, Betefage Betani herekiai, weia Iesu i'abana haukia rua euhu 'uainakia, ");
INSERT INTO rro_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","e'abi etibaha, “Katoao aiara weiana wairakai hauna aonai katokatoto, doniki nahu ha katotabu ahina hau ha a'i nemia'au 'apua hauna ua'a aba tetoba 'au, katorubuna katomaiaina. ");
INSERT INTO rro_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Hau ha kebakainimi, ketibaha, ‘Taba buonai naiana tubabaina?’ raninai, katohina bena katotibaha, ‘Obiapaka nenuatae aina, rani papana haeamona kemueaina.’” ");
INSERT INTO rro_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Terarua teao doniki nahu ha tetabu ahina aiara ibuanai itu ha pa'abina 'akonai itoba 'au teihana. Ṯerubuna aonai, ");
INSERT INTO rro_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","maearima baika weia tekoroti haukia tebakainakia, tetibaha, “Taba buonai doniki nahu ṯorubuna?” ");
INSERT INTO rro_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Iesu ehinana ihobonai mo maearima weiakia tehina benakia hanona tehabonakia. ");
INSERT INTO rro_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Doniki nahu temaiaina Iesu herena raninai, kapenai ekia habuni teabari 'aunakia, ba Iesu emia'au. ");
INSERT INTO rro_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Maearima bo'ona ekia habuni taearai teabari, 'a baika hanona taeara haianai matiu raukia tehara huri teabarinakia. ");
INSERT INTO rro_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Wairanai mai murinai teka'a haukia teio tetibaha, “Hosana! Obiapaka atanai nimai hauna hamabanamona. ");
INSERT INTO rro_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","'Aba'abaka Davida ena obia aiarana aba nimai hauna hamabanamona. Hosana, 'ubi toha tohana Tiramana hamabanamona.” ");
INSERT INTO rro_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Iesu Ierusalemai ekara'au Marea Robe aonai ekatoto, taba ikoikiai eihanakia, ia beraura eko'iko'i buonai i'abana haukia harau haea rua kipokia temue teao Betani. ");
INSERT INTO rro_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Erani Betani tehabona hanona Iesu mare'a e'ari. ");
INSERT INTO rro_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Suke mai rauna atau'ai eihana, eao herena keiha haraina buana ha re'a, rau 'abaeakia mo taba aha'i etabu ahina, pokina Suke ekia bua'a ranina aha'i. ");
INSERT INTO rro_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Iesu matiu weiana ehina bena etibaha, “Oi buabuamu hau ha a'i keani 'apuana keao mo banai banai.” I'abana haukia aiana weiana teona. ");
INSERT INTO rro_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ierusalemai tekara'au, Iesu Marea Robe ai ekatoto kawakawa haukia eu'u ahinakia, moni tia'i banai haukia ekia itara ebaku'a banainakia haeamona rauria tikawakawa ainakia haukia ekia imia'au tabakia etori ku'a banainakia. ");
INSERT INTO rro_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Iesu ekia taeara ekaiabunakia ha ena kawakawa tabana a'i kebua banaina Marea Robe i'aeana aonai. ");
INSERT INTO rro_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Weiana maearima eba'iobinakia etibaha, “Puka Robenai tererena, Tirama e'abi, ‘E'u itu hanona maearima ikoikiai kateaparina ekia bahuba'ari ituna’, ia wai aba kakikaki haukia ekia paparo'ai tubaona.” ");
INSERT INTO rro_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Robe haukia apa'uakia mai Rauhubu poki haukia 'uru neiana teona buonai, iahu'arina taearana tetabuna, ia teta'u aina pokina maearima ikoikiai hanona ena ba'iobi 'abikia weiakia teaonamo ainakia buonai. ");
INSERT INTO rro_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Rabirabi hanona aiara apa'uana weiana tehabona. ");
INSERT INTO rro_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Raurani tekabanai raninai, Suke weiana teihana aba e'ororo eao mo ramunai epua. ");
INSERT INTO rro_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petero eraona tinana ba Iesu ehina bena etibaha, “Ba'iobi haumu e! Moihana. Suke orikena hauna hanona aba e'ororo.” ");
INSERT INTO rro_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Iesu ehina benakia etibaha, “Tirama katoa'ikakauma. ");
INSERT INTO rro_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","'Abi tohana au wai nahina benimi. Hau ha oeo neiana pehina bena, ‘Kipomu momikiri 'aku aonai moeno uhu’, kebatohana aona a'i kekai'au kai'au raninai tabana kerama. Ia nenuatae aina hanona kea'ina. ");
INSERT INTO rro_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ua buonai au wai nahina benimi, ṯonuatae ainakia tabakia ikoikiai bahuba'ari ai katonoi, weiana katoa'ikakauma hanona katotabu ahinakia wai 'eumi. ");
INSERT INTO rro_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Weiana bahuba'ari aokiai katokoroti raninai, tea'i ki'animi haukia ekia ki'a katohina haonakia, ba Hamami kupai hauna emi ki'a abomo kehina haonakia. ");
INSERT INTO rro_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","'A ekia ki'a a'i katohina haonakia raninai, Hamami kupai nemiaho hauna emi ki'a abomo a'i kehina haonakia.” ");
INSERT INTO rro_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Haeamona Ierusalemai tekara'au, Iesu eao Marea Robe wairanai nikabanai aonai, Robe haukia apa'uakia, Rauhubu poki haukia, abomo aiara haukia apa'uakia teao Iesu herena. ");
INSERT INTO rro_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Tebakaina, te'abi tetibaha, “Hiabu tabanai aka neiakia nubabainakia, abomo tai hiabu ebeni'o?” ");
INSERT INTO rro_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Iesu e'abi etibaha, “Au abomo bakaibakai ha kabenimi, anina katobena'u raninai tai ena hiabuai aka neiakia nababai hanona kaba'iobinimi. ");
INSERT INTO rro_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ioane ena ba'uere robe hanona kupai emai 'ao maearima herekiai emai? Tomo'abi.” ");
INSERT INTO rro_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Kipokia baiatakiai terobahu aina tetibaha, “‘Kaha'abi kupai emai’ raninai kebakainaka ‘Taba buonai a'i tubatohana?’ ");
INSERT INTO rro_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","'Ao kaha'abi ‘Maearima herekiai emai re'a’...” Ia maearima mo teta'u ainakia, pokina maearima ikoinai te'iobina Ioane hanona maha banai hauna tohana. ");
INSERT INTO rro_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Weiana ia Iesu tehina bena tetibaha, “A'i ta'iobina.” Iesu abomo ehina benakia etibaha, “Au abo'umo hiabu tabanai aka neiakia nababai hanona a'i kaba'iobinimi.” ");
INSERT INTO rro_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Iesu ehore 'abi ibabatainai ehina benakia etibaha “Hau ha bine haharuana ebabaina, arana ea'i abuna, bine buakia ibahari 'iti'itikia 'urina ehabina, mai iha 'inina ituna ebabaina. Maearima baika ebenakia kate'imana, 'a ia hanona harima eao. ");
INSERT INTO rro_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Bine te'aiba raninai hau weiana ena ta'ara ia'ina hauna ha euhuna eao haharua ṯe'imana haukia herekia. Bine anikia harua herekiai kea'inakia. ");
INSERT INTO rro_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","'A haharua i'imana haukia tehore ta'ara ia'ina hauna tea'i 'inina, te'atina, teuhuna imana 'abaeana emue. ");
INSERT INTO rro_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Haeamona poki hauna ta'ara ia'ina hauna ha euhuna eao herekia hanona 'arana tebamani'ana abomo teba haumaeana. ");
INSERT INTO rro_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Haeamona ena ta'ara ia'ina hauna ha euhuna eao hanona teahu 'arina. Bo'okia euhunakia teao, baika teahu ki'anakia, ia baika hanona teahu 'arinakia. ");
INSERT INTO rro_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Hamona emiaho keuhuna hauna hanona nahuna niraona'au aina hauna. Orena 'akinai ia euhuna, e'abi etibaha, ‘Naha'u neiana kauhuna keao hanona aba katemariki aina.’ ");
INSERT INTO rro_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ia haharua i'imana haukia teroba ahu, te'abi tetibaha, ‘Tomai, neiana hanona haharua poki hauna nahuna, hamahu 'arina, ena haharua neiana hanona aika 'eukai keao.’ ");
INSERT INTO rro_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ua buonai tea'i 'inina, teahu 'arina, hauanina tekapo banaina haharua murinai.” ");
INSERT INTO rro_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Iesu ia ebakainakia etibaha, “turaonana, haharua poki hauna hanona taba kebabaina? Ia kemai haharua i'imana haukia keahu 'arinakia, bine haharuana kea'ina maearima baika kebenakia kate'imana. ");
INSERT INTO rro_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Puka Robenai tererena hauna a'i totuabina? Ṉa e'abi aiho, ‘Itu ibabaina haukia tebaoao aina piharana hanona itu ibua 'inina kupuana piharana namonai eao. ");
INSERT INTO rro_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Neiana hanona Obiapaka ena babai, nahaihana nahata'u ta'u huri!’” ");
INSERT INTO rro_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Iuda haukia apa'uakia Iesu ia'i 'inina teraonana pokina te'iobina 'abi ibabataina hanona ia ahakiai ehinana. Ia maearima teta'u ainakia buonai tehabona teka'a. ");
INSERT INTO rro_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Muriai ia tehore Parisea haukia mai Heroda titaina haukia baika teuhunakia teao Iesu herena bakai bakai ai katebarewana. ");
INSERT INTO rro_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ba teao herena tebakaina tetibaha, “Ba'iobi haumu e, ai ṯa'iobina oi hanona 'abi tohakia nohina, maearima ekia raona 'abikia a'i nuta'u ainakia, ia aea homakia robakia a'i nuahu, ia Tirama ena taeara tohanai mo nuba'iobi. Ba 'ara kahahore Kaisara herenai hanona ebero 'ao aha'i? ");
INSERT INTO rro_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","'Ara kahahore 'ao aha'i?” Iesu ekia bai'oi weiana e'iobina, ebakainakia etibaha, “Taba buonai tuhobona'u! Moni ha tomaiaina, maihana.” ");
INSERT INTO rro_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Moni ha temaiaina tebena hanona ebakainakia etibaha, “Neiana hanona tai aubaubana? Mai tai atana?” Ia te'abi, “Kaisara 'euna.” ");
INSERT INTO rro_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Iesu ehina benakia etibaha, “Kaisara 'euna Kaisara katobena, Tirama 'euna Tirama katobena.” Weiana teona hanona teta'uta'u huri. ");
INSERT INTO rro_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadukea haukia mikiri mue a'i tibatohana haukia baika ekia bakaibakai ha teaoaina Iesu herena. ");
INSERT INTO rro_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Tebakaina tetibaha, “Ba'iobi haumu e, Mose ṉa erere aihona, ‘Hau ha nahuna aha'i ke'ari wapuna kemiaho, 'ari hauna hatina kehore wapu weiana keatawana nahuna kebaramanakia 'ari hauna 'euna.’ ");
INSERT INTO rro_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ba bariu a'a hati ikoikiai 'abaihau hamomo. Pakana ehawainibe, nahuna aha'i e'ari. ");
INSERT INTO rro_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Hatina ibaruana wapu weiana eatawana, nahuna aha'i e'ari. Hatikia ibaihauna abomo uahomana herenai erama. ");
INSERT INTO rro_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Te'abaihau hamomo babi'e weiana hamona teatawana, ia ha nahuna a'i ebaramana. Muri 'akinai babi'e abomo e'ari. ");
INSERT INTO rro_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Hau 'abaihau hamomo ikoikiai teatawana, ba mikiri mueai hanona tai atawana tohanai keao?” ");
INSERT INTO rro_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Iesu ehina benakia etibaha, “Wai hanona tobeho pokina Puka Robena anina a'i ṯo'iobina abomo Tirama ena hiabu a'i ṯo'iobina. ");
INSERT INTO rro_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","'Ari haukia katemikiri raninai ia hanona aneru kupai haukia 'abakia, a'i katehawainibe. ");
INSERT INTO rro_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","'Ariai katemikiri mue 'abina a'i to'iobina, Mose ena Pukai a'i totuabina? Arabu e'ara 'ekanai Tirama Mose ehina bena, ‘Bariu Au hanona Aberahamo ena Tirama, Isako ena Tirama, Iakobo ena Tirama.’ ");
INSERT INTO rro_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Tirama ua e'abi aiho buonai aika kaha'iobina, Ia hanona 'ari haukia ekia Tirama aha'i, ia mauri haukia ekia Tirama. Wai tohaorea ki'a baha.” ");
INSERT INTO rro_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Rauhubu poki hauna ha weia ekia baihara tae 'uruna ebahu aina, ebabataina, Iesu Sadukea haukia ekia bakaibakai 'arana ebamue haraina. Ba ia ehore Iesu ebakaina etibaha, “Rauhubu ikoikiai, aeana hauna ikoikiai 'arakiai?” ");
INSERT INTO rro_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Iesu ehina bena etibaha, “Ikoikiai 'arakiai hauna neiana. ‘Isaraela haumi e, aia tomona. Obiapaka eka Tirama hanona Obiapaka hamomona mo. ");
INSERT INTO rro_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Obiapaka emu Tirama koraona'au aina, mai aomu ikoinai, mai aubamu ikoinai, mai emu raona ikoinai, mai taburamu ikoinai.’ ");
INSERT INTO rro_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ibaruana hanona neiana. ‘Heremuai hauna abomo koraona'au aina, kipomu nuraona'au aini'o 'abana.’ Rauhubu ua'a ha a'i nemiaho neiakia rua 'arakiai.” ");
INSERT INTO rro_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Hau weiana e'abi etibaha, “Ba'iobi haumu e, oi hanona obero. O'abi harai, Tirama hanona hamona mo, ha ua'a aha'i. ");
INSERT INTO rro_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Haeamona Tirama kaharaona'au aina mai aoka ikoinai, mai eka raona ikoinai, mai eka tabura ikoinai, weiana herekai nemiaho hauna kaharaona'au aina hanona eapa'ua ki'a baha ba mahi mai barobe tabakia ikoikiai kahabaibeni Tirama wairanai.” ");
INSERT INTO rro_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Iesu hau weiana eihana, e'abi harai buonai ehina bena etibaha, “Oi mai Tirama ena obia aiarana hanona baiatami a'i ehoma'a.” Weiana murinai maearima ia katebakaina hanona teta'u. ");
INSERT INTO rro_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Iesu Marea Robe aonai eba'iobi raninai maearima ebakainakia etibaha, “Aehoma buonai Rauhubu poki haukia ti'abi, ‘Keriso hanona Davida Nahuna’? ");
INSERT INTO rro_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Weiana hanona Auba Robe hiabunai Davida pinanai e'abi etibaha, ‘Obiapaka hanona e'u obia ehina bena etibaha, Itipa'u tainai momiati keao mo emu 'ou haukia ikoikiai 'apumu ba'anai kahorotinakia.’ ");
INSERT INTO rro_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Davida kipona ehore Keriso eaparina Obiapaka raninai, aea homanai mo ia nahunai keao?” Mako tebahu haukia mai aonamokia ia aiana teona. ");
INSERT INTO rro_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Haeamona eba'iobi muenakia, etibaha, “Rauhubu poki haukia herekiai kato'ima 'ima harainimi, ia hanona habuni homa'akia tibatotonakia tikabanai kabanai taearai mai kawakawa 'ekakiai, ekia nuatae hanona maearima ia kateihanakia katemariki ainakia. ");
INSERT INTO rro_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Haeamona marea aokiai ekia nuatae imia'au namokiai katemia'au, tatu aokiai abomo 'eka apa'uakia namokiai mo katemia'au. ");
INSERT INTO rro_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Wapu ekia itu tiba'arenakia, ekia bahuba'ari tibahoma'a ki'anakia kateihanakia buonai. Maearima uahomakia hanona ki'a rarina 'akina katetabu ahina.” ");
INSERT INTO rro_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Iesu Marea Robe aonai beruberu mauana wairanai emiati, to'u haukia ekia moni mauai ṯeuta eihanakia, obia haukia bo'ona hanona ekia moni bo'okia teuta. ");
INSERT INTO rro_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ia wapu uraruna ha emai, ena moni papakia rua emaiainakia eutanakia, ekia ihobo hanona pene hamona 'abana. ");
INSERT INTO rro_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","I'abana haukia eaparinakia teao herena ehina benakia etibaha, “'Abi tohana au wai nahina benimi, wapu uraruna weiana eutana hauna hanona eapa'ua ki'a baha ba ia ikoikiai teuta haukia. ");
INSERT INTO rro_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Pokina obia haukia ekia moni tebo'o ia papakia mo teuta, 'a wapu uraruna hanona ena tabu ahi tabana keaniani aina hauna maikoina eutana.” ");
INSERT INTO rro_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Iesu Marea Robeai ekarahi aonai, i'abana hauna ha ehore ehina bena etibaha, “Ba'iobi haumu e, Marea Robe namo abuna piharai tebabaina, moihana.” ");
INSERT INTO rro_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Iesu e'abi etibaha, “Itu rarikia 'akikia neiakia noihanakia? Maikoikiai katerabu tai ore, katehere obo, pihara ha pihara ha ahanai a'i keno'au a'i kemiaho.” ");
INSERT INTO rro_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Iesu Olibe oeonai emiati Marea Robe ewairana, Petero, Iakobo, Ioane mai Anderea abomo teao herena tebakai bunina. ");
INSERT INTO rro_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Moba'iobinamai, taba neiakia aita katerama? Haeamona katerama ranina hoana hanona aea homana?” ");
INSERT INTO rro_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Iesu ehina benakia, etibaha, “Kato'ima 'ima harainimi, hau ha a'i me'oinimi. ");
INSERT INTO rro_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Maearima bo'okia au ata'uai katemai kate'abi katetibaha, ‘Au hanona Keriso’, maearima bo'okia kate'oinakia. ");
INSERT INTO rro_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Huari 'urukia mai poukia kato'o raninai, nuami a'i katetae, taba neiakia katerama, ia puana hanona wairai. ");
INSERT INTO rro_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Itubu ha kemikiri itubu ha kehuarina, hanopaka ha kemikiri hanopaka ha kehuarina. Kanokau keka'a 'eka haeai haeai, 'arobo rarikia katerama. Neiakia hanona matoha miori nirama haiarana kori'uaina 'abana. ");
INSERT INTO rro_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Kipomi kato'ima 'ima harainimi, pokina katea'i 'ininimi bakai 'ekakiai katehorotinimi marea aokiai kate'atinimi. Au pau'uai rauhubu haukia mai hanopaka obiakia wairakiai katokoroti, herekiai pou'u katohinana. ");
INSERT INTO rro_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Puana hanona a'i kemai baha keao mo pou namona kateiroro aina itubu ikoikiai herekiai. ");
INSERT INTO rro_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Katea'i 'ininimi bakai 'ekanai katehorotinimi raninai, taba katouahina hauna a'i katoraonana, rani ketaina kebenimi 'abina mo katohinana, pokina wai a'i kato'abi, ia Auba Robe ke'abi. ");
INSERT INTO rro_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","A'a hati katehore kipokia hinahinakia katehinahina, hama katehore nahukia hinahinakia katehinahina kateahu 'arinakia. Nahu katehore hinakia hamakia kateba ki'anakia kateaoainakia, kateahu 'arinakia. ");
INSERT INTO rro_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Au pau'uai maearima ikoinai kate'oatanimi, ia tai kebapahihi keao puanai hauna hanona kemauri. ");
INSERT INTO rro_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Baki'a mai bata'u hauna a'i pekoroti 'ekanai kekoroti katoihana. (Tuabituabi haumu, 'abi neiana anina ko'iobi haraina.) Rani weianai Iudeai ṯemiaho haukia hanona katebeau 'akauma kobio kateao. ");
INSERT INTO rro_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Maearima ha ena itu kapenai re'a ia hanona a'i keriri itu aonai a'i ketoto ena taba a'i kea'inakia, ia kebeau 'akaumana. ");
INSERT INTO rro_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Umai niaka hauna abomo a'i kemue itu ena habuni a'i kea'ina. ");
INSERT INTO rro_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Rani weiakia aokiai babi'e mai nuakia haeamona batutu babi'ekia herekiai hanona keki'a ki'a baha. ");
INSERT INTO rro_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Katobahuba'ari Tirama herenai taba neiakia 'ipi mai hiribo aokiai a'i katerama. ");
INSERT INTO rro_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Pokina rani weiakia ekia ki'a hanona kateki'a ki'a baha, ba Tirama hanopaka ebabai ramana raninai emai mo bariu rani neiana ena ki'a kipokia a'i kateihobo 'apua, muriai haeamona uahomana ha a'i kerama mue. ");
INSERT INTO rro_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","'A Obiapaka rani weiakia a'i pebako'onakia hanona tai ha a'i pemauri 'apua, 'a ia ena a'itaea maearimakia buokiai rani weiakia kebako'onakia. ");
INSERT INTO rro_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Rani weianai hau ha kehina benimi, ‘Tomoihana, Keriso neiana’ 'ao ‘Tomoihana, Keriso weiana’ hanona a'i katobatohana. ");
INSERT INTO rro_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Pokina Keriso bai'oikia mai mahabanai bai'oikia haukia katemai, hoa haeai haeai mai hiabu haeai haeai katebabai, ekia nuatae hanona Tirama ena a'i taea maearimakia kate 'oinakia, iamo a'i ketainakia. ");
INSERT INTO rro_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ua buonai kato'ima 'ima harainimi, wairai ua'a a'i tirama baha tabakia ikoikiai aba naba'iobinimi. ");
INSERT INTO rro_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ki'a weiana keore murinai, Beraura hanona kewapura abuna, nawa a'i kerara. ");
INSERT INTO rro_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Bihiu kupai kate'eho, abomo kupai hiabu tabakia haeai haeai kateibiuibiu. ");
INSERT INTO rro_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Rani weianai maearima hanona au Maearima Nahuna kateihana'u 'auhao ahanai kamai mai hiabu'u abomo mai nuabi'u. ");
INSERT INTO rro_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Weiana e'u aneru kauhunakia kateao 'uni puakia bani baura timai 'ekakiai, e'u a'itaea maearimakia katebararonakia hanopaka puana keao puana. ");
INSERT INTO rro_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Kuropou herenai ihaiha namona katoihana, Kuropou kehubuhubu rauna mahamahakia katoihanakia hanona kato'iobina ihau aba nikaibari. ");
INSERT INTO rro_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Wai abomimo taba ṉahomakia katoihanakia raninai kato'iobina ia aba herekai pa'abi 'akonai. ");
INSERT INTO rro_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","'Abi tohana au wai nahina benimi, uru neiana a'i keore baha keao mo taba neiakia katerama. ");
INSERT INTO rro_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kupa mai hanopaka kate'akauma, ia au e'u 'abi hanona a'i ke'akauma. ");
INSERT INTO rro_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Beraura hoana 'ao ranina tai ha a'i e'iobina, ena aneru kupai a'i te'iobina, Nahuna abomo a'i e'iobina, ia Hamana ikupaiana mo e'iobina. ");
INSERT INTO rro_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Katomaha no'a, katobai'ima pokina rani kemai hanona wai a'i ṯo'iobina. ");
INSERT INTO rro_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ihobona hau ha harima eao raninai, ena ta'ara'i haukia hiabu ebenakia ena itu kate'imana, ha ha ekia aka katebabai abomo pa'abi i'imana hauna ehina bena kemaha no'a kebai'ima. ");
INSERT INTO rro_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ua buonai wai katobai'ima, pokina itu hauna ena mue hanona a'i ṯo'iobina rabi, wapuka'a, kokoro'u ai, 'ao rani tainai kemai. ");
INSERT INTO rro_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ia kebata'u kemai re'a, parua reami a'i metabu ahinimi. ");
INSERT INTO rro_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Wai nahina benimi 'abina maearima ikoikiai abomo nahina benakia natibaha, ‘Katobai'ima!’” ");
INSERT INTO rro_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Beraura rua wairai temiaho Kabanai mai Parawa 'abaeana tatuna. Robe haukia apa'uakia mai rauhubu poki haukia tebahamomo terobahu, bunianai taeara tetabu Iesu katea'ina kateahu 'arina. ");
INSERT INTO rro_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Tetibaha, “Aika tatu weiana aonai a'i kahababaina. To'u haukia 'uri'uri rarina a'i temebabaina ta'una.” ");
INSERT INTO rro_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Iesu hanona Betaniai, Simona morumoru hauna ena ituai, ua'a nianiani aonai, babi'e ha tehoro (atana Nado) timina 'orimona abomo 'arana rarina 'akina hauna kabapu namona 'akina eaoaina. Ba eahu pa'ana Iesu 'aranai eheina. ");
INSERT INTO rro_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Maearima baika weia hanona teopuere, kipokia baiatakiai te'abi'abi tetibaha, “Taba buonai tehoro neiana nibaore 'abaeana? ");
INSERT INTO rro_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mekawakawaina pa'e Kina hinabu aihau petabu ahina, monina weiana hanona uraru haukia pebenakia.” Ia tehore babi'e weiana teururuai ki'ana. ");
INSERT INTO rro_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","'A Iesu ehina benakia etibaha, “Tomohabona! Taba buonai tuopuere aina? Ia hanona aka namona au here'u ai ebabaina. ");
INSERT INTO rro_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","'A uraru haukia hanona rani ikoinai heremiai ṯemiaho, katonuatae raninai rani tebo'o emi banamo tabakia katobenakia. Ia au hanona rani ikoinai heremiai a'i kamiaho. ");
INSERT INTO rro_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ena 'iobi ihobonai ebabaina here'u ai. A'i tihore bahana'u, ia hau'u tehoroai eutuna, wairai kerama hauna eba'oru baihana. ");
INSERT INTO rro_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","'Abi toha tohana mo au wai nahina benimi, Pou Namona kateiroro aina hanopaka maikoinai babi'e neiana aka ebabaina hauna abomo katehinana, ia iraonana.” ");
INSERT INTO rro_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Iuda Isakariote hauna harau haea rua haukia 'abakia ha eao Robe haukia apa'uakia herekia Iesu hinahinana kehinahina. ");
INSERT INTO rro_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Robe haukia apa'uakia Iuda herenai 'uru weiana teona hanona aokia enamo ki'a, te'abi'uai moni katebena, ua buonai Iuda taeara etabu, taeara namona tabanai hanona Iesu robe haukia apa'uakia imakiai keutana katea'ina. ");
INSERT INTO rro_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Parawa 'abaeana tatuna wapuna kori'uaina Kabanai tatuna mamoekia iahu'arikia berauranai, Iesu i'abana haukia tehore tebakaina tetibaha, “Nuraonana Kabanai tatuna anianina ae'e kataba'oruna koani.” ");
INSERT INTO rro_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Iesu i'abana haukia rua euhunakia, e'abi etibaha, “Katoao aiara aonai katokatoto, ua'a hau ha katoihana puou mai beina kebuana, murinai kato'au katoao. ");
INSERT INTO rro_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ketoto itunai itu poki hauna katohina bena katotibaha, ‘Ba'iobi hauna e'abi, bakibaki ikaihurina ae'e ai? I'aba'u haukia kipokia Kabanai tatuna anianina katani.’ ");
INSERT INTO rro_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ba ia kipona ikaihuri rarina ha 'ubiai aba e'oru hauna keba ihanimi. Weia eka aniani katoa'ia'i haraina.” ");
INSERT INTO rro_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","I'abana haukia teao, aiara aonai tekatoto hanona Iesu ehina benakia tabakia ikoikiai tetabu ahinakia. Kabanai tatuna anianina tea'ia'i haraina. ");
INSERT INTO rro_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Rabirabi eaoaina aonai, Iesu i'abana haukia harauhaea rua kipokia temai. ");
INSERT INTO rro_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Aniani 'ekanai temiati tianiani aonai, Iesu ehina benakia etibaha, “'Abi tohana au wai nahina benimi, baiatamiai tararua ṯaniani oioi hauna ha au hinahina'u kehinahina.” ");
INSERT INTO rro_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","I'abana haukia aokia earo'ari, weiana ha ha tebakaina, “Nuraonana au, 'ao?” ");
INSERT INTO rro_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Iesu ekia 'abi ebamuena etibaha, “Wai harauhaea rua haumi ha, tararua 'ororo hamonai ṯahao uta hauna. ");
INSERT INTO rro_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Au Maearima Nahuna hanona ka'ari Puka Robenai ererena ihobona, 'a au Maearima Nahuna hinahina'u kehinahina hauna aoko'ona mo, ki'a rarina 'akina ketabu ahina, a'i perama hanona penamo.” ");
INSERT INTO rro_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Teaniani aonai, Iesu ehore parawa ea'ina, Tirama ebanamona ba ehobina, i'abana haukia ebenakia, e'abi etibaha, “Tomoa'ina, tomoana! Neiana hauna au hauani'u.” ");
INSERT INTO rro_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Haeamona 'ere ha ea'ina, Tirama ebanamona i'abana haukia ebenakia, ikoikiai teinu. ");
INSERT INTO rro_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Iesu e'abi etibaha, “Neiana hanona au aruaru'u maearima bo'okia paukiai kekiki oioi. Au aruaru'u hanona maearima mai Tirama ekia baibua 'abi'uaina mahamahana ibatohana hoana. ");
INSERT INTO rro_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Au wai nahina benimi, bine beina ha a'i kainu mue keao mo Tirama ena obia aiarana aonai mahamahana kainu.” ");
INSERT INTO rro_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Epua hui ha tea'ina, ba tekarahi Olibe oeona teao. ");
INSERT INTO rro_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Iesu i'abana haukia ehina benakia etibaha, “Ikoimiai katohabona'u katobeau otaraina, pokina Puka Robenai tererena, ‘Au kahore mamoe i'imakia hauna kakomo 'arina, weiana mamoe ikoinai katebeau otaraina.’ ");
INSERT INTO rro_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","'A au 'ariai kamikiri mue murinai ka'uai kaeao Galilea.” ");
INSERT INTO rro_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petero ehore Iesu ehina bena etibaha, “'Aba'u neiakia ikoikiai oi katehaboni'o re'a, ia au hanona a'i kahabo 'apuani'o.” ");
INSERT INTO rro_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Iesu Petero ehina bena etibaha, “'Abi tohana au oi nahina beni'o, bariu rabi neiana kokoro'u ibaruana a'i ke'arara baha aonai, oi rani aihau au kobuniai aina'u.” ");
INSERT INTO rro_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Petero e'abi pahihi etibaha, “Aika hararua kaha'ari haeamo re'a, 'a au hanona oi a'i kabuniai 'apuani'o.” I'abana haukia ikoikiai abomo ua te'abi aiho. ");
INSERT INTO rro_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","'Eka ha atana Getesemane ai tekara'au. Weiana Iesu i'abana haukia ehina benakia etibaha, “Wai ṉa'a tomomiati, au kaeao kabahuba'ari.” ");
INSERT INTO rro_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ba Petero, Iakobo, mai Ioane mo ebaka'anakia, aona e'abe'abe abomo earo'ari. ");
INSERT INTO rro_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ua buonai ehina benakia etibaha, “Au hanona auba'u nihaiara matoha pa'ari moioina. Neia kato miaho, katomaha no'a katobai'ima.” ");
INSERT INTO rro_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Papana eka'a ha ha 'apua eao, ba 'anoai e'umuti, ebahuba'ari, pe mai taearana haiara ranina weiana ia herenai pekaobo. ");
INSERT INTO rro_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ia ebahuba'ari etibaha, “Hama'u e, Hama'u e, taba ikoikiai heremuai hanona tetai. 'Ere neiana here'uai poa'i obona. 'A au e'u nuatae aha'i, ia oi emu nuataeai mo.” ");
INSERT INTO rro_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Iesu emue emai i'abana haukia aihau parua reakia etabu ahinakia, ia ehore Petero ehina bena etibaha, “Simona e, oi nuparua, 'u? Rani papana pomaha no'a pobai'ima a'i petaina? ");
INSERT INTO rro_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Katobahuba'ari kato bai'ima, pokina baihobo ai a'i tomototo. Auba hanona nenuatae tabura, ia hauani mo ni'abe'abe.” ");
INSERT INTO rro_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Haeamona emue eao ebahuba'ari, ena bahuba'ari 'abikia haeamokia ehina muenakia. ");
INSERT INTO rro_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Weiana emue emai, teaihau parua reakia etabu ahinakia, pokina mahakia tepuma buonai, herenai 'abi tabana katebamuena hanona a'i te'iobina. ");
INSERT INTO rro_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Rani ibaihauna emue emai, ehina benakia etibaha, “Wai tuparua oho mo tuarai. Hinoku'u, tomoihana ranina aba ekara'au. Maearima Nahuna hanona ki'a haukia imakiai aba enouta. ");
INSERT INTO rro_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Tomomikiri hamaka'a, hinahina'u ehinahina hauna aba nimai.” ");
INSERT INTO rro_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Iesu ni'abi oho mo aonai, Iuda weiana harauhaea rua haukia 'abakia ha hauna ekara'au, mako rarina imakia mai pura'akia abomo mai karebakia murinai te'au, ikoikiai hanona Robe haukia apa'uakia mai Rauhubu poki haukia mai aiara haukia apa'uakia ekia 'abiai teao. ");
INSERT INTO rro_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Hinahina hauna mako weiana aba ehina benakia etibaha, ‘Kapauna hauna hanona hau mo weiana katoa'i 'inina katoaoaina.’ ");
INSERT INTO rro_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Iuda ekarahi beronai eao Iesu herena, “Ba'iobi haumu e.” Ba epauna. ");
INSERT INTO rro_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Murinai Iesu tea'ina ba tebirina. ");
INSERT INTO rro_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","'A Iesu kipokia tekoroti haeamo hauna ha emikiri kareba eberi 'auna, Robe haukia 'arakiai hauna ena ta'ara'i hauna haiana ehara obona. ");
INSERT INTO rro_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Iesu ehore ehina benakia etibaha, “Wai imami mai karebakia mai pura'akia tomai au katoa'ina'u ihobona kakikaki hau'u ai tubaona'u. ");
INSERT INTO rro_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Rani ikoikiai au hanona wai kipokia Marea Robe aonai aba'iobi, ia a'i toa'ina'u. 'A neiana hanona Puka Robeai terere 'uaina 'abina ketohana paunai.” ");
INSERT INTO rro_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Weiana i'abana haukia ikoikiai Iesu tehabona tebeau otaraina. ");
INSERT INTO rro_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Hau 'aru'aruna ha Iesu murinai e'au, habuni hamona mo ero'abuna. Maearima tehore hau weiana tea'i 'inina aonai, ");
INSERT INTO rro_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ena habuni imakiai ehabona hauna 'abaeana ebeau 'akaumana. ");
INSERT INTO rro_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ia tehore Iesu tebaka'ana teaoaina Robe haukia 'arakiai hauna herena, ba Robe haukia apa'uakia, aiara haukia apa'uakia mai Rauhubu poki haukia ikoikiai weia teto'u. ");
INSERT INTO rro_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petero hanona Iesu ekaiturina, ia mai baiatakia teao Robe haukia 'arakiai hauna ena ara aonai, ua'a bai'ima haukia baika kipokia temiati haeamo, iruba eraranakia. ");
INSERT INTO rro_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Weiana Robe haukia apa'uakia mai Iuda ekia obia haukia tehore Iesu iba'arina taearana tetabuna, ia beho ha a'i tetabu ahina. ");
INSERT INTO rro_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Maearima bo'ona 'akina tehore hinau 'abikia tehina herenai, ia ekia hinau 'abikia hanona ha a'i teihobo. ");
INSERT INTO rro_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Haeamona maearima baika temikiri ekia bai'oi 'abina neiana tehinana Iesu herenai, tetibaha, ");
INSERT INTO rro_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ai aiana taona, e'abi etibaha, ‘Au Marea Robe neiana maearima imakiai tebabaina hauna hanona karubuna, wapu aihau aonai maearima imakiai a'i katebabaina Marea Robena ha kababaina.’” ");
INSERT INTO rro_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","'A ekia bai'oi 'abikia neiakia abomo a'i teihobo. ");
INSERT INTO rro_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Weiana Robe haukia 'arakiai hauna emikiri to'u wairakiai ekoroti Iesu ebakaina etibaha, “Oi emu 'abi ha aha'i 'abi neiakia ṯehina haukia ahakiai?” ");
INSERT INTO rro_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","'A Iesu hanona 'abi ha a'i ehinana abomo ena 'abi a'i ebamuena. Weiana Robe haukia 'arakiai hauna haeamona ebakai muena etibaha, “Oi Keriso, tibanamona Tiramana Nahuna, u?” ");
INSERT INTO rro_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Iesu e'abi etibaha, “Au mo neia'u, ikoimiai hanona au Maearima Nahuna katoihana'u, hiabu 'ubi tohana Tiramana imana itipanai kamiati, kupa 'auhaonai kamai.” ");
INSERT INTO rro_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Robe haukia 'arakiai hauna 'abi weiana 'uruna eona raninai aona ehaiara ki'a, kipona ena habuni etapana, eio etibaha, “'Abi tabana nahatabuna? ");
INSERT INTO rro_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Tirama nia'i ki'ana 'abina aba tona, emi raona taba?” Weiana ikoikiai te'abi, ke'ari. ");
INSERT INTO rro_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Weiana baika tehore Iesu te'atotina, haeamona mahana te'apa abuna abomo teahuna, te'abi tetibaha, “Mo'abi, tai ehore eahuni'o?” 'Ima haukia abomo tebo'ana. ");
INSERT INTO rro_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Petero hanona ara aonai 'anoai, ba Robe haukia 'arakiai hauna ena ta'ara'i uahona ha emai. ");
INSERT INTO rro_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ia Petero iruba nirarana eihana raninai, eiha 'ini'inina ehina bena etibaha, “Oi abomumo Iesu Nasareta hauna o'abana.” ");
INSERT INTO rro_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","'A Petero hanona ebuniai etibaha, “Taba robana nuahuna hauna hanona au a'i na'iobina.” Ba ekapare eao pa'abi 'akonai. ");
INSERT INTO rro_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ua'a uaho weiana haeamona eiha muena, ba baiaruru haukia ehina benakia etibaha, “'Abakia ha neiana.” ");
INSERT INTO rro_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ia haeamona ebuniai mue. Rani a'i ehoma'a Petero kipokia tekoroti haeamo haukia tehina bena tetibaha, “'Abi tohana, oi abomumo ia 'abakia ha. Pokina oi abomo Galilea haumu.” ");
INSERT INTO rro_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Weiana Petero ia ehinabe pahihinakia etibaha, “Wai taba ṯo'uahina hauna hanona au a'i na'iobina. Nabai'oi re'a Tirama puma mebena'u.” ");
INSERT INTO rro_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ba kokoro'u ibaruana e'arara. Weiana Petero Iesu ehinana 'abina eraona tinana, ‘Kokoro'u ibaruana a'i ke'arara baha aonai, oi rani aihau kobuniai aina'u.’ Weiana ia ehai ki'a. ");
INSERT INTO rro_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Raurani wapuranai robe haukia apa'uakia, aiara haukia apa'uakia, rauhubu poki haukia mai bakai apa'uana haukia ikoikiai 'abi tebahamomona, Iesu tebirina teaoaina Pilato tebena. ");
INSERT INTO rro_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato Iesu ebakaina etibaha, “Oi Iuda haukia ekia Obia 'arana haumu, 'u?” Iesu e'abi etibaha, “Aba nu'abi mo naia.” ");
INSERT INTO rro_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Robe haukia apa'uakia tehore 'abi bo'okia Iesu ahanai tehina. ");
INSERT INTO rro_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilato haeamona Iesu ebakai muena etibaha, “Oi a'i ko'abi, 'u? Oi o'iobina 'abi haeai haeai oi ahamuai ṯehinanakia.” ");
INSERT INTO rro_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","'A Iesu 'abi ha a'i ebamuena, weiana buonai Pilato ebaoao. ");
INSERT INTO rro_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pilato ena hoahoa rani ikoinai tatu aokiai maearima wapura hauna ha ṯenuatae aina hauna hanona nibakarahina. ");
INSERT INTO rro_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Rani weianai hau ha atana Baraba 'abana kipokia tewapura. Ia hanona Roma haukia te'oatanakia, 'au aonai maearima baika eahu 'arinakia. ");
INSERT INTO rro_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ba to'u haukia tehore Pilato tenoina rani ikoinai hoahoa weiana nibabaina hauna kebabaina. ");
INSERT INTO rro_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato ehore ebakainakia etibaha, “Ṯonuatae Iuda emi Obia 'arana hauna kabakarahina?” ");
INSERT INTO rro_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pokina Pilato aba e'iobina robe haukia apa'uakia hanona Iesu tiwamuru aina buonai tea'ina ia imanai teutana. ");
INSERT INTO rro_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","'A robe haukia apa'uakia temikiri to'u haukia tekai ta'ata'anakia, kate'abi, Pilato Baraba kebakarahina ia Iesu hanona kemiaho. ");
INSERT INTO rro_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato haeamona to'u haukia ebakai muenakia etibaha, “'A wai tu'abi Iuda ekia Obia 'arana hauna hanona aea kahomana?” ");
INSERT INTO rro_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ikoikiai teio tetibaha, “Matiu ibiri ropo 'ubinai koba'arina!” ");
INSERT INTO rro_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato ehore ebakai muenakia etibaha, “Aea ehoma, ena beho taba?” 'A ia teio aota tetibaha, “Matiu ibiri ropo 'ubinai koba'arina!” ");
INSERT INTO rro_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Weiana Pilato hanona to'u haukia aokia ibanamona enuatae aina buonai Baraba erubuna. 'A Iesu hanona e'atina huari haukia ebenakia, matiu ibiri ropo ahanai kateahu 'arina. ");
INSERT INTO rro_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Huari haukia Iesu tebaka'ana teaoaina rauhubu ituna apa'uana aonai ekia hau ikoikiai tebararonakia. ");
INSERT INTO rro_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Habuni birona tebabatoto aina, abomo 'ini boaboa tea'i kaiarona 'aranai tehore 'auna. ");
INSERT INTO rro_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ekia bapo'o po'o tea'i ramana tetibaha, “Iuda obia 'arana e, komauri.” ");
INSERT INTO rro_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Moheai 'arana te'atina te'atotina, wairanai tekaipehu haeamona tekutiai bai'oina. ");
INSERT INTO rro_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Tebapo'o nonoana murinai, habuni birona haunai tebakuri ahina, ena habuni tohana tebabatoto muena tebakarahina matiu ibiri ropo 'ubinai kateahu 'arina teao. ");
INSERT INTO rro_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kurene hauna ha atana Simona 'uniai emai Ierusalema niao, ia hanona Alesanda mai Rufo hamakia. Huari haukia Simona kipokia tebai tabu ahi aonai tebahi ahina Iesu ena matiu ibiri ropo kebuana. ");
INSERT INTO rro_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Iesu tebaka'ana teaoaina 'eka ha atana Golgota, anina hanona 'Ara Huriana 'Ekana. ");
INSERT INTO rro_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ia tehore bine beina mabina mai haiara ibako'iko'ina muramurana kipokia teu kibukibuna tebena keinu. Iesu hanona a'i einu. ");
INSERT INTO rro_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ba Iesu matiu ibiri ropo 'ubinai tekoko 'auna. Epua murinai huari haukia ena habuni pu'iai tewatenakia ha ha katea'i. ");
INSERT INTO rro_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Raurani beraura ehiabu hiabu aonai (9 a.m.) Iesu matiu ibiri ropo 'ubinai tekoko 'auna. ");
INSERT INTO rro_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ia 'arana 'ubinai beho marerena ṉa terere aihona. ");
INSERT INTO rro_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Kakikaki haukia rua Iesu kipokia rani hamomonai matiu ibiri ropo 'ubikiai tekoko 'aunakia, ha itipanai ha awarinai. ");
INSERT INTO rro_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Puka Robena 'abina aba etohana etibaha, ‘Aka ki'a haukia kipokia tetuabi haeamonakia.’ ");
INSERT INTO rro_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Tekabanai haukia tehore 'abi ki'a obokia tehina herena, abomo 'arakia tekapokapo te'abi tetibaha, “Oi neiamu haumu Marea Robe korubuna haeamona wapu aihau kobakori muena. ");
INSERT INTO rro_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Bariu naia matiu ibiri ropo 'ubinai moriri, kipomu mobamaurini'o.” ");
INSERT INTO rro_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Taeara ihobonai mo Robe haukia apa'uakia mai rauhubu poki haukia Iesu te'abi papura aina tetibaha, “Maearima baika ebamaurinakia, ia kipona kebamaurina hanona a'i nitaina. ");
INSERT INTO rro_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Keriso Isaraela ekia Obia 'arana, bariu weia matiu ibiri ropo 'ubinai meriri hamaihana ba kaha'ikakaumana.” Iesu kipokia matiu ibiri ropo 'ubinai tekokonakia haukia terarua abomo 'abi ki'a obokia tehina herenai. ");
INSERT INTO rro_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Atiaha tohanai hanopaka maikoinai ewapura abuna eao mo beraura ebaeno hoana aihau 'abana. ");
INSERT INTO rro_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Beraura ebaeno aonai Iesu eapari aota etibaha, “Eloi Eloi, lama sabakatani.” Anina hanona ‘E'u Tirama e, E'u Tirama e, taba buonai ohabona'u.’ ");
INSERT INTO rro_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Herenai tekoroti haukia baika Iesu aiana teona, te'abi tetibaha, “Tomobahu, ia hanona Elia niaparina.” ");
INSERT INTO rro_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Weiana hau ha ebeau eao poame ea'ina bine beina mabina aonai ehao uhuna, hiribo ai ekai to'ona ba etiu taeana Iesu ebena keinu ba e'abi etibaha, “Hamabai'ima, hamaihana. Elia pa'e kemai kea'i obona.” ");
INSERT INTO rro_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","'A Iesu eio aota, ba e'ari. ");
INSERT INTO rro_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Rani weianai Marea Robe aonai i'aea huri habunina ibuanai etapa boana 'ubi ai eriri eao ba'a. ");
INSERT INTO rro_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Huari poki hauna ha Iesu herena 'akinai ekoroti eihana ia eio aiana eona, ua e'ari aiho raninai e'abi etibaha, “Hau neiana hanona Tirama Nahuna tohana.” ");
INSERT INTO rro_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Babi'e baika abomo ata'uai tekoroti tebaiaruru, baiatakiai hanona Maria Magadala babi'ena Iakobo ko'iko'i Iosepa ohi hinakia Maria mai Salome. ");
INSERT INTO rro_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Babi'e neiakia hanona Galileai Iesu murinai teka'a tebaraina. Iesu kipokia Ierusalemai tekara'au haeamo babi'ekia bo'okia abomo weia. ");
INSERT INTO rro_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Wapu weiana hanona A'ia'i harai ranina, kerani mara hanona Beraura Robe. Beraura aba kaihu niaoaina aonai, ");
INSERT INTO rro_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Iosepa Arimatea hauna aona ebanua ko'ona eao Pilato wairanai Iesu hauanina enoiaina. Ia hanona Iuda ekia obia hauna ha maearima abomo timariki aina, Tirama ena obia aiarana kemai ne'imana hauna ha. ");
INSERT INTO rro_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato Iesu e'ari noanoa pouna eona raninai eta'u ta'u huri. Ia emikiri huari poki hauna eaparina Iesu ena 'ari ranina ebakai bakai aina. ");
INSERT INTO rro_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pilato Iesu ena 'ari 'uruna huari poki hauna herenai eona murinai, Iesu hauanina e'uahina Iosepa kea'ina. ");
INSERT INTO rro_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Iosepa ehore habuni namona tohana ha ekawana, Iesu hauanina ea'i obona habuni weianai e'apana eaoaina 'ariahana pihara ikui aonai ehorotina, pihara rarina ha ebaherena ebahu abuna. ");
INSERT INTO rro_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Magadala babi'ena mai Iosepa hinana Maria terarua Iesu hauanina tehorotina 'ekana teihana. ");
INSERT INTO rro_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Beraura Robe eore murinai Maria Magadala babi'ena Iakobo hinana Maria mai Salome tehoro timikia 'orimokia tekawa kateao Iesu hauanina kateutuna. ");
INSERT INTO rro_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Hui beraurana raurani 'amari 'amarinai, beraura nitae aonai, babi'e weiakia taearai teka'a 'ariahana teao aonai, ");
INSERT INTO rro_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","kipokia te'abi'abi tetibaha, “Tai kebarainaka, 'ariahana pa'abi piharana ketori parena.” ");
INSERT INTO rro_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Mahakia eao 'ariahana pa'abina, pihara rarina 'akina aba itori pare teihana. ");
INSERT INTO rro_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ia 'ariahana aonai tekatoto hanona hau 'aru'aruna ha habuni porekia eba totonakia itipa tainai emiati teihana raninai teta'u ki'a. ");
INSERT INTO rro_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Hau weiana e'abi etibaha, “A'i tomota'u. Wai Iesu Nasareta hauna tekoko 'auna hauna tutabuna. Ia hanona aba emikiri. Ṉa'a aha'i. Tehorotina 'ekana tomoihana. ");
INSERT INTO rro_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Tomoao i'abana haukia mai Petero katohina benakia, katotibaha, ‘Katoao Galileai, Iesu aba ke'uai ua'a, katoihana e'abi ihobona!’” ");
INSERT INTO rro_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ua buonai babi'e weiakia tekarahi 'ariahana tehabona mai nuataekia haeamona mai ta'ukia. Teta'u buonai tai ha haianai a'i te'abi.  ");
INSERT INTO rro_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Hui beraurana raurani 'amarinai, Iesu 'ariai emikiri murinai, Maria Magadala babi'ena herenai ewaira tina 'uai, ia hanona 'uainai Iesu auba ki'a obokia 'abaihau hamomo aonai eu'u ahinakia babi'ena. ");
INSERT INTO rro_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maria Magadala babi'ena eao Iesu te'abana haukia tiaoko'o tihaihai herekiai Iesu pouna ehinana. ");
INSERT INTO rro_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Maria herenai pou teona Iesu aba emauri, haeamona eihana ṉa ehoma hanona ena 'abi a'i tea'i taeana. ");
INSERT INTO rro_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Muriai Iesu ihana ebahaeaina hau rua taearai teka'a 'uni tiao aonai, herekiai ewaira tina. ");
INSERT INTO rro_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ba terarua temue teao 'abakia haiakiai te'abi. Ia abokiamo a'i tebatohanakia. ");
INSERT INTO rro_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Weiana murinai haukia harau haea hamomo tianiani aonai, Iesu ewaira tina herekiai. Ekia a'ikakauma aha'i haeamona ekia ao pahihi paunai ebatanakia. Pokina emikiri murinai teihana haukia aiakia a'i tebatohana. ");
INSERT INTO rro_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ba ia ehina benakia etibaha, “Katoao hanopaka ikoinai Pou Namona maearima ikoikiai herekiai katoiroro aina. ");
INSERT INTO rro_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kea'ikakaumana mai 'uere robe kea'ina hauna hanona mauri kea'ina, 'a a'i kea'ikakaumana hauna hanona puma kehoaina. ");
INSERT INTO rro_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","A'ikakauma haukia hanona bata'uta'u huri akakia ṉahomakia katebabai. Au ata'uai auba ki'a obokia kateu'u u'u ahinakia, haeamona maea haeai haeai kate'abi, ");
INSERT INTO rro_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","imakiai 'erau katea'inakia, muramura ki'a obokia kateinu ia herekiai taba ha a'i kerama, haeamona imakia inawa haukia ahakiai katehao'au hanona ekia inawa katenamo.” ");
INSERT INTO rro_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Obiapaka Iesu ia ehina benakia murinai, ekara'au eao kupa, Tirama itipana tainai emiati. ");
INSERT INTO rro_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","I'abana haukia ikoikiai weia tekarahi 'eka ikoikiai aokiai teiroro. Obiapaka etai turinakia buonai hoa haeai haeai tebabai, aka weianai ekia iroro ebatohanakia. ");
INSERT INTO rro_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Obia haumu Teofilo e. Maearima bo'ona baiatamai ai taba tohakia terama haukia aba tererenakia, ");
INSERT INTO rro_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","bahabanai mahakiai aka neiana teihana mai teiroro aina haukia tehina benamai ihobona. ");
INSERT INTO rro_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Au abo'umo popouna 'akinai ea'i ramana 'abikia ikoinai atabu harainakia. Ba naraonana enamo buonai au marere ha karerena oi 'eumu. ");
INSERT INTO rro_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Weiana ko'iobi haraina taba teba'iobini'o 'abikia hanona tohakia. ");
INSERT INTO rro_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Heroda Iuda eobia aina raninai robe hauna ha weia atana Sakaria, Abia ena itubu hauna, atawana Elisabeta hanona Arona ena rama babi'ena. ");
INSERT INTO rro_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Terarua hanona aka bero maearimakia Tirama wairanai, Obiapaka ena rauhubu mai bairobe te'ima harainakia, ki'a ha a'i tebabaina. ");
INSERT INTO rro_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Iamo terarua hanona nahukia aha'i pokina Elisabeta hanona 'one'one haeamona terarua aba teanepaka. ");
INSERT INTO rro_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Sakaria ena itubu haukia ekia aka raninai, ia ehore robe akakia ebabai Tirama wairanai. ");
INSERT INTO rro_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Robe haukia ekia hoahoa tainai, pu'iai ia tea'i taeana 'eka robena ketoto muramura timina 'orimona kekinena. ");
INSERT INTO rro_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ikinena ranina etaina, bahuba'ari haukia ikoikiai atapakai teto'una tibahuba'ari. ");
INSERT INTO rro_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Obiapaka ena aneru ha herenai ewaira tina muramura timina 'orimona ikinena itarana abihanai itipana tainai ekoroti. ");
INSERT INTO rro_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sakaria aneru eihana raninai nuana etae abomo eta'u ki'a baha. ");
INSERT INTO rro_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Iamo aneru ia ehina bena etibaha, “Sakaria e, a'i kota'u. Emu bahuba'ari 'uruna Tirama aba eona, oi atawamu Elisabeta hanona nahumu hau ha kebaramana, atana koaparina Ioane. ");
INSERT INTO rro_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Aomu hanona kenamo, mai koaonamo ki'a baha, mako abomo ena ramai kateaonamo. ");
INSERT INTO rro_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Pokina Obiapaka wairanai ia hanona keapa'ua, bine 'ao muramura kirokia a'i keinu, abomo hinana nuanai a'i kerama baha aonai Auba Robeai kebonu. ");
INSERT INTO rro_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ia kehore Isaraela maearimakia bo'ona 'akina kebaraona kabenakia Obiapaka ekia Tirama herena kateao. ");
INSERT INTO rro_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ke'uai Obiapaka wairanai Elia ena aka mai ena hiabu ihobona, hama mai nahu aokia keba hamomonakia, mai aia o'o aha'i haukia bero haukia ekia aotipa taearanai kebaka'anakia, maearima keba'orunakia Obiapaka 'euna.” ");
INSERT INTO rro_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakaria aneru ebakaina etibaha, “Neiana hanona aea ka'iobi harai aihona? Au hanona aba anepaka mai atawa'u abomo eanepaka.” ");
INSERT INTO rro_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Aneru ena 'abi ebamuena etibaha, “Au hanona Gabriel, Tirama wairanai nakoroti, euhuna'u pou namona neiana amaiaina heremu kaba'iobini'o. ");
INSERT INTO rro_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Bariu oi hanona maeamu keki'a a'i ko'abi'abi keaomo taba neiakia ekia rama ranina ketaina. Pokina e'u 'abi rani weianai ketohana hauna a'i obatohana paunai.” ");
INSERT INTO rro_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Maearima hanona Sakaria te'ima 'arina abonamo aokia earo'ari pokina marea robe aonai rani homa'ana emiaho. ");
INSERT INTO rro_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ia ekarahi raninai 'abi kehinana hanona a'i etaina. Weiana te'iobina ia hanona marea robe aonai taba ha eihana. Hoahoa mo ebabai maeana eki'a a'i e'abi'abi. ");
INSERT INTO rro_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ena aka beraurana ebaorena hanona emue ena itu eao. ");
INSERT INTO rro_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Murinai ia atawana Elisabeta epuma, nawa ima itu aonai mo emiaho. ");
INSERT INTO rro_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","E'abi etibaha, “Neiana hanona Obiapaka ena nuatae hoana here'uai, maearima baiatakiai e'u haumaea kea'i parena.” ");
INSERT INTO rro_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabeta nawana 'abaihau aonai Tirama ehore aneru ha atana Gabriel euhuna Galilea aonai aiara ha atana Nasareta eao. ");
INSERT INTO rro_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Uaho rari ha weia te'abi aina hau ha atana Iosepa keatawana Davida ena rama hauna, uaho weiana atana hanona Maria. ");
INSERT INTO rro_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Aneru eao herena ehina bena etibaha, “Moaonamo. Oi hanona enuataeai apa'uani'o. Obiapaka hanona oi heremuai.” ");
INSERT INTO rro_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","'Abi weiana Maria aona ebaro'arina, mai eraonaraona banamo weiana anina hanona taba. ");
INSERT INTO rro_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ia aneru e'abi etibaha, “Maria e, a'i mota'u, Tirama ena nuatae aba oa'ina. ");
INSERT INTO rro_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Oi hanona kopuma, miori ha kobaramana, atana koaparina Iesu. ");
INSERT INTO rro_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ia hanona ketarahi mai kateaparina 'Ubi toha tohana Hauna Nahuna, Tirama Obiapaka kehore 'aba'abana Davida ena obia kebena. ");
INSERT INTO rro_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Mai Iakobo ena itubu keobia aina keaomo banai banai, ena obia hanona a'i kepua.” ");
INSERT INTO rro_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria aneru ebakaina etibaha, “Au hau ha a'i a'iobina. Neiana hanona aea kerama aiho?” ");
INSERT INTO rro_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Aneru ehina bena etibaha, “Auba Robe keriri oi ahamuai, 'Ubi toha tohana Hauna ena hiabuai kebahu abuni'o, Robe Hauna kerama atana kateaparina Tirama Nahuna. ");
INSERT INTO rro_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Oi hatia'amu Elisabeta te'abi ia hanona 'one'one, ia ena anepakai miori ha ea'ina, bariu nawana aba 'abaihau. ");
INSERT INTO rro_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Tirama herenai hanona taba ha a'i epahihi.” ");
INSERT INTO rro_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maria e'abi etibaha, “Au hanona Obiapaka ena ta'ara'i babi'e'u. Emu 'abi ihobona here'uai merama.” Ba aneru Maria ehabona. ");
INSERT INTO rro_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Rani weianai Maria ea'i a'i harai mai enoanoa eao oeo aiarana ha Iudea puro'onai. ");
INSERT INTO rro_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Sakaria ena ituai etoto Elisabeta ebanamona. ");
INSERT INTO rro_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabeta Maria ena banamo 'uruna eona raninai nuana aonai miori eibiuibiu mai Auba Robe Elisabeta aona ebabonuna. ");
INSERT INTO rro_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Weiana e'abi aota, “Babi'e ikoikiai baiatakiai oi hanona onamo ki'a baha, miori kobaramana hauna abomo enamo. ");
INSERT INTO rro_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","E'u namo hanona taba e'u Obiapaka hinana here'u emai! ");
INSERT INTO rro_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Berona 'akinai emu banamo 'uruna aona raninai miori nua'u aonai mai aonamona eibiu ibiu. ");
INSERT INTO rro_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","A'ikakauma babi'emu e, aba onamo pokina Obiapaka ena 'abi ehina heremuai haukia katemai katetoha.” ");
INSERT INTO rro_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria e'abi etibaha, “Au ao'u Obiapaka nibanamona. ");
INSERT INTO rro_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Mai auba'u abomo e'u bamauri Tiramana niaonamo aina, ");
INSERT INTO rro_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","pokina ena uraru mai ta'ara'i babi'e'u eraona tinana'u paunai. Bariu rani neianai keao uru ikoikiai namo'u katehinana, ");
INSERT INTO rro_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","pokina hiabu Tiramana taba rarikia 'eu'uai ebabainakia. Ia atana hanona erobe, ");
INSERT INTO rro_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","uru ha keao uru ha ena aoko'o hanona nibawaira tinana weiakia timariki aina haukia herekia. ");
INSERT INTO rro_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ia imanai ena tabura ebakarahina, apa haukia ekia raona ekipu otarainakia. ");
INSERT INTO rro_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ia ehore obia haukia taburakia ekia obia 'ekakiai ebaririnakia, mai uraru haukia ebakara'aunakia. ");
INSERT INTO rro_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Mare'a ti'ari haukia taba namokiai ebabonu 'aunakia, ia kepu haukia euhunakia imakia 'abaeakia temue. ");
INSERT INTO rro_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ena 'abi'uai eraona tinana ena ta'ara'i itubuna Isaraela haukia ebarainakia. ");
INSERT INTO rro_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","'Aba'abaka herekiai ehinana hauna ena aoko'o ebawaira tinana Aberahamo mai kupuna 'aba'abana herekiai keaomo banai banai.” ");
INSERT INTO rro_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria Elisabeta ohi temiaho nawa aihau 'abana ba emue eao ena aiara. ");
INSERT INTO rro_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabeta ena mauri ranina etaina hanona nahuna hau ebaramana. ");
INSERT INTO rro_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Herenai ṯemiaho haukia mai hatia'ana pou teona, Obiapaka ena aoko'o rarina 'akina herenai ebawaira tinana hanona kipokia teaonamo haeamo. ");
INSERT INTO rro_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Wapu iba'ababanina emai hanona ikoikiai temai miori itarena to'una, haeamona hamana Sakaria atana kateaparina. ");
INSERT INTO rro_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ia hinana etae etibaha, “Aha'i, ia atana kahaparina Ioane.” ");
INSERT INTO rro_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ikoikiai tehina bena tetibaha, “Hatia'amu ha atana uahomana aha'i.” ");
INSERT INTO rro_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Weiana mahakia tebairu hamana herenai miori ata tabana keaparina. ");
INSERT INTO rro_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Weiana ia rererere piharana ebakai bakai aina, weia ahanai ṉa erere aihona, “Atana hanona Ioane,” raninai ikoikiai teta'uta'u huri. ");
INSERT INTO rro_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Mawa'eai pinana ekaikauna, maeana ebero e'abi'abi mue, Tirama ebanamona. ");
INSERT INTO rro_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Herekiai ṯemiaho haukia ikoikiai teta'u ki'a, mai Iudea oeo aiarakia maikoinai pou neiana tehina otaraina. ");
INSERT INTO rro_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Pou teona haukia aokiai teraona 'ini'inina tetibaha, “Miori neiana aea homanai keao.” pokina Tirama imana hanona ia ahanai. ");
INSERT INTO rro_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Miori hamana Sakaria aona Auba Robe ebabonuna, ba Tirama ena 'abi ehinana etibaha, ");
INSERT INTO rro_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Obiapaka Isaraela ekia Tirama kahabanamona, pokina emai ena maearima aba ekawa muenaka. ");
INSERT INTO rro_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Bamauri Pokina ebamikirina aika 'euka ena ta'ara'i hauna Davida ena itubuai. ");
INSERT INTO rro_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Aba wa'i baha raninai ena 'abi mahabanai robekia pinakiai tehinana 'abana. ");
INSERT INTO rro_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Eka 'ou haukia mai 'arika a'i ti'ari haukia ikoikiai imakiai kebamaurinaka. ");
INSERT INTO rro_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Kupuka eaoko'o ainakia mai ena 'abi'uai robena eraona 'inina. ");
INSERT INTO rro_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Kupuka Aberahamo herenai ena 'abi'uai ehinana: ");
INSERT INTO rro_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Eka 'ou haukia imakiai kebamaurinaka, a'i kahata'u ena aka kahababaina ");
INSERT INTO rro_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","robeai mai beroai ia wairanai eka miaho ranikia ikoikiai. ");
INSERT INTO rro_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Haeamona naha'u e, oi hanona kateaparini'o 'ubi toha tohanai hauna ena mahabanai haumu. Pokina oi ko'uai Obiapaka wairanai ena taeara koa'ia'i haraina, ");
INSERT INTO rro_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ena maearima bamauri aoberona koba'iobinakia ekia ki'a ihina haonai keao. ");
INSERT INTO rro_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Aika eka Tirama ena aoko'o paunai. Beraura nitae eana kupai keriri kemai hereka, ");
INSERT INTO rro_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","'ari aiaianai mai wapurai ṯemiaho haukia ahakiai kerara, weiana aeka kebaka'anakia baibua taearanai kebaka totonakia.” ");
INSERT INTO rro_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Miori hauaniai eapa'ua mai aubai etabura. Ia hano'akunai emiaho eaomo ekarahi Isaraela mako herekiai. ");
INSERT INTO rro_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Rani weiana aonai Augusto obia 'arana rauhubu 'abina ha euhuna eao Roma ena iha'ini hanopakana maikoinai ata katerere. ");
INSERT INTO rro_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Neiana hanona ata rere kori'uaina Kurene Suria hanopakana eiha 'inina raninai. ");
INSERT INTO rro_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Weiana maearima ikoikiai atakia katebaibeni paunai temue ikau ena aiara teao. ");
INSERT INTO rro_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Iosepa abomo Nasareta Galilea hanonai emikiri eao Davida ena Aiara Betelehema Iudea ai, pokina ia hanona Davida ena itubu mai ena rama hauna. ");
INSERT INTO rro_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Atakia katebaibeni paunai ia te'abi aina babi'ena Maria ohi teao, Maria hanona mai nuana. ");
INSERT INTO rro_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Terarua weia ṯemiaho aonai kemauri ranina etaina. ");
INSERT INTO rro_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Weiana emauri nuahobo miorina hau ebaramana, habuniai tebaro'a abuna poromakau ekia aniani ahiahinai tebaeno utana, pokina 'ima'ima itunai 'eka aha'i. ");
INSERT INTO rro_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Hano weiana hamona aonai mamoe 'ima haukia baika tubuai rabi aonai ekia mamoe te'imanakia. ");
INSERT INTO rro_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Obiapaka ena aneru ha herekiai ewaira tina, Obiapaka nuabinai ebaea obonakia raninai teta'u wairai. ");
INSERT INTO rro_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Aneru ia ehina benakia etibaha, “A'i tomota'u. Au pou namona amaiaina weiana maearima ikoikiai aokia kebaonamonakia. ");
INSERT INTO rro_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Bariu rani neianai Davida ena aiarai emi Bamauri hauna ha erama, ia hanona Keriso Obiapaka. ");
INSERT INTO rro_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Hoana hanona nahomana, miori 'oru'oruna ha katotabu ahina, habuniai tero'a abuna poromakau ekia aniani ahiahinai tebaeno utana.” ");
INSERT INTO rro_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Mawa'eai kupai aneru to'una tewaira tina aneru weiana herenai, Tirama tebanamona tetibaha, ");
INSERT INTO rro_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Kupa 'ubi toha tohanai nuabi hanona Tirama 'euna, hanopakai ena baibua hanona niaonamo ainakia haukia herekiai.” ");
INSERT INTO rro_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Aneru to'una ia herekiai tekaobo temue kupa raninai mamoe 'ima haukia kipokia te'abi'abi tetibaha, “Aika hamaeao Betelehema, Obiapaka eba'iobinaka taba weiana erama hauna kahaihana.” ");
INSERT INTO rro_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Tenoanoa teao Maria Iosepa mai miori 'oru'oruna poromakau ekia aniani ahiahinai enouta tetabu ahinakia. ");
INSERT INTO rro_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Weiana teihana raninai aneru miori robana eahuna 'abina maearima teba 'iobinakia, ");
INSERT INTO rro_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","mamoe 'ima haukia pou weiana tehinana raninai aia teona haukia ikoikia teta'u ta'u huri. ");
INSERT INTO rro_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maria hanona 'abi weiakia ikoikiai aonai eraona 'ininakia mai eraona raona ainakia. ");
INSERT INTO rro_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Mamoe 'ima haukia temue Tirama tekuti aina mai teapaina pokina taba weiakia 'urukia teo'o mai teiha haukia ikoikiai ia ehina benakia ihobona tohanai terama. ");
INSERT INTO rro_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Wapu iba'ababaninai ena itare ranina etaina hanona atana teaparina Iesu, aneru ata ebena hinana nuanai a'i erama baha aonai. ");
INSERT INTO rro_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mose ena rauhubu ihobona ena kopa kopa ahu ranina eore murinai miori teaoaina Ierusalema Obiapaka wairanai katebawaira tinana. ");
INSERT INTO rro_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Obiapaka ena rauhubuai tererena ihobona, “Hobohobo miorikia hau ikoikiai hanona katebaibeni Obiapaka 'euna.” ");
INSERT INTO rro_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Obiapaka ena rauhubu e'abi ihobona barobe tabakia katebaibeni mumu rua 'ao rauria nahu rua. ");
INSERT INTO rro_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Weia Ierusalemai hau ha atana Simeona ia hanona bero hauna haeamona Tirama nimariki aina. Isaraela ena bamauri hauna ne'imana, aona Auba Robe ebonu. ");
INSERT INTO rro_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Auba Robe ia ehina bena ia a'i ke'ari keaomo Obiapaka ena Keriso keiha 'uaina. ");
INSERT INTO rro_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Auba Robe ia ebakatotona Marea Robe aonai. Maria Iosepa ohi Iesu teaoaina Marea rauhubu ena hoahoa katebabaina paunai. ");
INSERT INTO rro_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeona imanai miori era'una Tirama ebanamona etibaha, ");
INSERT INTO rro_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Obiapaka e, emu 'abi'uai ihobona emu ta'ara'i hauna bariu mai baibuana aba nuhabona. ");
INSERT INTO rro_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Pokina maha'u ai emu Bamauri Pokina aba aihana, ");
INSERT INTO rro_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","weiana oi aba oba'oruna maearima ikoikiai wairakiai. ");
INSERT INTO rro_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Eana neiana hanona rama haeai haukia ibaeakia abomo oi emu maearima Isaraela ibanuabikia.” ");
INSERT INTO rro_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Miori hamana hinana 'abi weiakia teo'o hanona teta'u ta'u huri. ");
INSERT INTO rro_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeona ehore terarua eba namonakia haeamona hinana Maria ehina bena etibaha, “Miori neiana hanona e'oru Isaraela haukia bo'ona iba'ehokiai mai ibamikirikiai keao, abomo ena hoahoai kate'oatana, ");
INSERT INTO rro_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","maearima bo'ona ekia raona bunikia kabakarahinakia. Mai kareba itatona 'abana kehore oi aomu abomo kebahaiarana.” ");
INSERT INTO rro_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Weia hanona mahabanai babi'ena ha atana Ana, Panuela nahuna ena itubu hanona Asere, aba eanepaka, ena hawainibe ihauna 'abaihau hamomo atawana ohi temiaho, ");
INSERT INTO rro_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ba ewapu emiaho bariu ihauna imabui harau aihau bani (84). Ia marea robe a'i ehabo 'apuana Tirama ekuti aina rabi mai mararani eanirobe mai ebahuba'ari. ");
INSERT INTO rro_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Rani weiana hamona aonai Ana emai marea aonai Tirama ebanamona ba maearima ikoikiai Ierusalema kebamaurina hauna ṯe'imana haukia herekiai miori pouna ehinana. ");
INSERT INTO rro_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Iosepa mai Maria ohi Obiapaka ena rauhubu e'abi ihobonai aka ikoikiai tebaorenakia raninai temue Galilea ekia aiara tohana Nasareta teao. ");
INSERT INTO rro_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Miori eapa'ua mai etabura; aoberoai ebonu, Tirama ena baraibarai ia ahanai emiaho. ");
INSERT INTO rro_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ihau ikoinai hamana mai hinana Ierusalema teao kabanai tatuna paunai. ");
INSERT INTO rro_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Iesu ihauna harau haea rua raninai, teaihau teao Ierusalema ekia tatu hoahoana taina. ");
INSERT INTO rro_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Tatu eore murinai hamana mai hinana temue 'a miori Iesu hanona Ierusalemai emiaho, hamana mai hinana a'i te'iobina. ");
INSERT INTO rro_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Teraonana ia hanona baiatakiai, wapu hamona teka'aina murinai tetabu ramana 'abana mai hatia'a herekiai. ");
INSERT INTO rro_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","A'i tetabu ahina paunai temue teao Ierusalemai weia katetabuna. ");
INSERT INTO rro_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Wapu aihau teao murinai marea robe aonai tetabu ahina bamarere haukia baiatakiai emiati aia ebahuai mai ebakainakia. ");
INSERT INTO rro_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ena 'iobi mai 'abi bamueai aiana teona haukia ikoikiai teta'u ta'u huri. ");
INSERT INTO rro_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Hamana mai hinana teihana raninai teta'u ta'u huri. Weiana hinana ia ehina bena etibaha, “Naha'u e, taba buonai nahomana heremaiai obabaina? Au hamamu ohi aomai maihaina tatabu 'arini'o.” ");
INSERT INTO rro_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Iesu ehina benakia etibaha, “Taba buonai wai au tutabuna'u? A'i to'iobina au hanona hama'u ena itu aonai namiaho, u?” ");
INSERT INTO rro_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","'A ia ena 'abi ehinana hauna obona a'i teobo. ");
INSERT INTO rro_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Eriri kipokia teao Nasareta, weia aiakia eka'ai haraina, 'a hinana hanona taba weiakia terama ikoikiai aonai eraona 'ininakia. ");
INSERT INTO rro_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Iesu eapa'ua hauaniai mai aoberoai, abomo Tirama mai maearima ia tenuatae aina. ");
INSERT INTO rro_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tiberio obia 'arana Roma hanopakana eobia aina ihauna harauhaea ima aonai Pontio Pilato hanona Iudea ekia Kabana. Heroda hanona Galilea eobia aina, abomo hatina Pilipo hanona Iturea mai Trakonito eobia ainakia, Lusania hanona Abilene aiarakia eobia ainakia. ");
INSERT INTO rro_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Robe haukia arakiai haukia Ana mai Kaiafa ekia raniai, Tirama ena 'abi emai Sakaria nahuna Ioane herena hano'akunai. ");
INSERT INTO rro_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ioane eao Ioridana ate haiana hanokia ikoikiai aokiai raona kabe 'uere robena eiroro aina ekia ki'a ihina hao paunai. ");
INSERT INTO rro_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Isaia mahabanai hauna ena pukai ererena 'abana: “Aia ha hano'akunai neio netibaha, ‘Obiapaka ena taeara tomoa'i a'i haraina, ena ka'a 'ekana tomobaberona. ");
INSERT INTO rro_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tataira ikoikiai katepupu abunakia, kobio mai oeo ikoikiai katebaririnakia. Taeara tebeho haukia katebero, mai tehiroa hiroa haukia kateta'eta'e. ");
INSERT INTO rro_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Weiana maearima ikoikiai Tirama ena bamauri kateihana.’” ");
INSERT INTO rro_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Mako tekarahi temai Ioane herena keba'uere robenakia, eiroro benakia etibaha, “'Erau nahukia e, tai ehina benimi opuere nimai hauna herenai katobeau pare? ");
INSERT INTO rro_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Raona kabe aonai katomiaho buabuami katerama, ia a'i kato'abi ‘Aberahamo hanona aika 'aba'abaka.’ A'i katoraonana aba katonamo. Pokina au wai nahina benimi, Tirama mai ena hiabu pihara neiakiai Aberahamo nahuna kebaramanakia. ");
INSERT INTO rro_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Wapira hanona aba e'oru matiu pokinai, matiu ikoikiai buabuakia namokia a'i tibaramanakia haukia hanona kate'uinakia, irubai katekapo 'aunakia.” ");
INSERT INTO rro_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ba to'u haukia ia tebakaina tetibaha, “Ba ai taba katababaina?” ");
INSERT INTO rro_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ioane e'abi etibaha, “Mai ena ibatoto rua hauna 'abana weiana herena aha'i hauna ha kebena, mai ena aniani hauna abomo ua kebabai aiho.” ");
INSERT INTO rro_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Moni bararo haukia abomo temai keba'uere robenakia tebakai bakai tetibaha, “Ba'iobi haumu e, ai taba katababaina?” ");
INSERT INTO rro_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ioane ehina benakia etibaha, “Moni koa'ina raninai ihobonai mo koa'ina, a'i koa'i banaina.” ");
INSERT INTO rro_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Huari haukia baika abomo tebakai bakai tetibaha, “Ai hanona taba katababaina?” Ioane ehina benakia etibaha, “Aiahuai 'ao 'abi bai'oikiai maearima a'i kato'oinakia ekia moni a'i katoa'i. Aomi namonai arami tohana mo katoa'ina.” ");
INSERT INTO rro_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Maearima hanona tebai'ima paunai aokia teraona raona Ioane hanona pa'e Keriso. ");
INSERT INTO rro_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ioane ikoikiai ehina benakia etibaha, “Au hanona beiai wai naba'uere robenimi, 'a muri'uai nimai hauna ena hiabu au eu'u etara haona, ena tamaka warokia karubunakia abomo here'uai a'i etaina. Ia hanona Auba Robe mai iruba ai keba'uere robenimi. ");
INSERT INTO rro_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ena ikomo matiuna hanona imanai, witi ahu 'iti'iti 'ekana kea'ia'i haraina, weiana witi uhokia kebararonakia paraboai kero'anakia, 'a hamarakia hanona a'i ni'ao 'apua irubanai kehuhunakia.” ");
INSERT INTO rro_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ioane bairobe 'abikia bo'okiai maearima ehina benakia mai pou namona eiroro aina herekiai. ");
INSERT INTO rro_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ioane ehore Heroda obia apa'uana erikena, pokina ia hatina atawana Herodia eatawana mai aka ki'a obokia bo'okia ebabai paunai. ");
INSERT INTO rro_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Heroda ena ki'a weiakia ikoikiai ahakiai ki'a mo ha ebabai muena, Ioane wapura 'ekanai ekaiabuna. ");
INSERT INTO rro_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Maearima ikoikiai eba'uere robenakia raninai, Iesu abomo eba'uere robena. Iesu ena bahuba'ari aonai kupa ekaikau. ");
INSERT INTO rro_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Weiana Auba Robe rauria hauanina ihobonai eriri ia ahanai. Aia ha kupai emai e'abi etibaha, “Oi hanona Au Naha'u. E'u Raona'au, naonamo aini'o.” ");
INSERT INTO rro_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Iesu ihauna harau aihau hanona ena aka ea'i ramana. Maearima teraonana ia hanona Iosepa nahuna. Iosepa hamana hanona Heli, ");
INSERT INTO rro_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","hamana Matata, hamana Lebi, hamana Meleki, hamana Ianai, hamana Iosepa, ");
INSERT INTO rro_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","hamana Matatia, hamana Amosa, hamana Nauma, hamana Eseli, hamana Nagai, ");
INSERT INTO rro_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","hamana Mata, hamana Matatia, hamana Semeina, hamana Ioseka, hamana Ioda, ");
INSERT INTO rro_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","hamana Ioanana, hamana Resa, hamana Sorobabela, hamana Salatiele, hamana Neri, ");
INSERT INTO rro_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","hamana Meleki, hamana Adi, hamana Kosama, hamana Elamadama, hamana Ere, ");
INSERT INTO rro_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","hamana Iosua, hamana Eliesere, hamana Iorima, hamana Matata, hamana Lebi, ");
INSERT INTO rro_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","hamana Simeona, hamana Iuda, hamana Iosepa, hamana Ionama, hamana Eliakima, ");
INSERT INTO rro_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","hamana Melea, hamana Mena, hamana Matata, hamana Natana, hamana Davida, ");
INSERT INTO rro_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","hamana Iese, hamana Obeda, hamana Boa, hamana Salamone, hamana Nasona, ");
INSERT INTO rro_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","hamana Aminadab, hamana Admina, hamana Areni, hamana Hesarona, hamana Pare, hamana Iuda, ");
INSERT INTO rro_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","hamana Iakobo, hamana Isako, hamana Aberahamo, hamana Tera, hamana Nahoro, ");
INSERT INTO rro_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","hamana Seruka, hamana Reu, hamana Peleka, hamana Ebere, hamana Sala, ");
INSERT INTO rro_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","hamana Kainana, hamana Apasada, hamana Sema, hamana Noa, hamana Lameka, ");
INSERT INTO rro_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","hamana Metusala, hamana Enoka, hamana Iareta, hamana Mahalale, hamana Kainana, ");
INSERT INTO rro_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","hamana Eno, hamana Seta, hamana Adamu, hamana Tirama. ");
INSERT INTO rro_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Iesu Ioridana atenai emue emai aona Auba Robe ai ebonu weiana Auba ehore ebaka'ana hano'akuna eaoaina, ");
INSERT INTO rro_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","wapu bariabui weia tiaporo ehore ehobona. Rani weiakiai aniani ha a'i eani 'apuana, puanai ia mare'a e'ari. ");
INSERT INTO rro_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Tiaporo ehore ia ehina bena etibaha, “Peoi Tirama Nahuna raninai pihara neiakia pohina benakia pohamai pateao.” ");
INSERT INTO rro_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Iesu ia ehina bena etibaha, “Aba tererena, ‘maearima hanona pohamai mo a'i kemauri.’” ");
INSERT INTO rro_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tiaporo ehore Iesu ebakara'auna eao hano oeonai rani papana hanopaka aiarakia ikoikiai ebaihana. ");
INSERT INTO rro_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Tiaporo ia ehina bena etibaha, “Au kahore hiabu mai nuabi neiakia maikoinai kabeni'o, pokina ikoikiai au ima'u ai eutana, haeamona tai nanuatae aina hauna kabena. ");
INSERT INTO rro_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Weiana oi au kokuti aina'u hanona ikoinai 'eumu.” ");
INSERT INTO rro_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Iesu ena 'abi ebamuena etibaha, “Aba tererena, ‘Obiapaka oi emu Tirama kokuti aina, iamo kipona ta'arana koa'i.’” ");
INSERT INTO rro_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Haeamona ebaka'ana eaoaina Ierusalema marea robe kaipanai ebakori 'auna, ehina bena etibaha, “Peoi Tirama Nahuna hanona neia kipomu morobo ahi. ");
INSERT INTO rro_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Pokina aba tererena, ‘ia ena aneru kehina benakia kate'imani'o. ");
INSERT INTO rro_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Abomo ia imakiai katea'i taeani'o, aemu piharai a'i mokaina ta'una.’” ");
INSERT INTO rro_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Iesu ia ehina bena etibaha, “Aba tererena, ‘Obiapaka emu Tirama baihobo 'ekanai a'i kohorotina.’” ");
INSERT INTO rro_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Tiaporo ena baihobo ikoinai ebaorenakia hanona ia herenai ekapare keaomo rani namona ha kemai. ");
INSERT INTO rro_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Iesu Auba Robe ena hiabuai emue eao Galilea weia pouna tehina otaraina hano weiana aiarakia ikoikiai aokiai. ");
INSERT INTO rro_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Iuda haukia ekia marea aokiai eba'iobinakia, ikoikiai tebanamona. ");
INSERT INTO rro_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Iesu ena apa'ua aiarana Nasareta eao, ena hoa hoa taina Beraura Robenai Iuda haukia ekia marea aonai etoto, ekoroti Puka ketuabina. ");
INSERT INTO rro_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Isaia Mahabanai hauna ena puka tebena, weiana puka ekaikauna, ṉa terere aihona 'ekana etabu ahina etuabina etibaha, ");
INSERT INTO rro_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Obiapaka Aubana hanona au aha'uai, pokina ebatohana'u pou namona kairoro aina uraru haukia herekiai. Euhuna'u kairoro tebirinakia haukia irubukia mai maha ki'a haukia kateiha mue, atetua aonai ṯemiaho haukia kabakarahinakia, ");
INSERT INTO rro_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Obiapaka ena maearima kebamaurinakia ihauna aba etaina pouna kairoro aina.” ");
INSERT INTO rro_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Iesu puka ekaiabuna i'imana hauna ebena ba emiati, marea aonai haukia ikoikiai mahakia ia teiha 'ini'inina. ");
INSERT INTO rro_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Weiana ia ehinabe ramanakia etibaha, “'Abi tona Puka Robenai hauna bariu rani neianai aba etohana.” ");
INSERT INTO rro_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","'Abi namokia pinanai ehinanakia paunai ikoikiai ia tebanamona haeamona teta'u ta'u huri tebakai bakai tetibaha, “Neiana hanona Iosepa nahuna, u?” ");
INSERT INTO rro_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Iesu ia ehina benakia etibaha, “'Abi tohana wai 'abi ibabatai ha katohinana here'u ai, ‘Toketa haumu e, kipomu mobamaurini'o.’ abomo katohina bena'u katotibaha, ‘Taba taba weia Kaperanauma ai obabai urukia tao'o haukia, neia emu aiara tohanai abomo kobabainakia.’” ");
INSERT INTO rro_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ia etibaha, “'Abi tohana au wai nahina benimi, mahabanai hauna ena aiara tohanai hanona a'i katea'i taeana. ");
INSERT INTO rro_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","'Abi tohana au wai nahina benimi, Elia ena raniai wapu babi'ekia bo'okia Isaraelai temiaho, kupa ekaiabuna abara a'i etibo ihau aihau mai nawa 'abaihau arobo rarina 'akina erama hano maikoina. ");
INSERT INTO rro_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ba Elia a'i euhuna weiakia ha herena a'i eao, 'a eao Sarepata aiarana Sidono hanonai wapu babi'ena ha herena. ");
INSERT INTO rro_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Abomo mahabanai hauna Elisa ia ena raniai Isaraela aonai weia hanona morumoru haukia bo'okia, ha aha'i enamo, 'a Suria hauna Namana ikupaiana mo enamo.” ");
INSERT INTO rro_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Marea aonai maearima ikoikiai 'abi weiakia teo'o raninai teopuere wairai. ");
INSERT INTO rro_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Temikiri aiarai tetori ahina tebaka'ana teaoaina teaiara oeona ahanai papa'ai katekapo ahina. ");
INSERT INTO rro_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ia hanona to'u baiatakia tohanai ekaobo. ");
INSERT INTO rro_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Eriri eao Galilea aiarana ha Kaperanauma Beraura Robeai maearima eba'iobi ramanakia. ");
INSERT INTO rro_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ena ba'iobi 'abikiai teta'u ta'u huri pokina ena 'abi hanona mai hiabuna. ");
INSERT INTO rro_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Hau ha aonai auba ki'a obona etoto hauna weia marea aonai eio aota ki'a, ");
INSERT INTO rro_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","etibaha, “'Ai, Iesu Nasareta hauna e, taba heremaiai kobabaina? Omai hanona ai koahu 'arinamai? Au a'iobina oi hanona Tirama ena Robe hauna.” ");
INSERT INTO rro_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Iesu ia ebatana etibaha, “'Uri'urimu. Ia aonai mokarahi.” Ikoikiai wairakiai auba ki'a obona hau weiana eba'eho ki'ana ba ekarahi, a'i ebamani'ana. ");
INSERT INTO rro_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Maearima ikoinai teta'u ta'u huri, tebaihinabe aina tetibaha, “Neiana hanona ba'iobi tabana? Mai hiabuna haeamona mai taburana auba ki'a obokia nehina benakia hanona tikarahi.” ");
INSERT INTO rro_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Hano weiana maikoinai Iesu pouna tehina otaraina. ");
INSERT INTO rro_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Iesu marea ehabona eao Simona ena itu. Simona rawana babi'ena hau hiabu inawana ea'ina, Iesu tenoina kebaraina. ");
INSERT INTO rro_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Weiana ia babi'e herenai ekoroti hau hiabu inawana erikena, ba inawa epua, beronai babi'e emikiri ta'arakia ea'i. ");
INSERT INTO rro_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Beraura kaihu niaoaina aonai maearima ikoikiai herekiai inawa haeai haeai haukia temai ainakia Iesu herena, imana ha ha ahakiai ehao'au ebamaurinakia. ");
INSERT INTO rro_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Auba ki'a obokia maearima bo'okia abomo aokiai tekarahi teio tetibaha, “Oi hanona Keriso Tirama Nahuna.” Iesu erikenakia eharabunakia a'i kate'abi pokina te'iobina ia hanona Keriso. ");
INSERT INTO rro_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Rani nirerena aonai Iesu ekarahi 'eka 'okona ha eao. Mako ia itabuna teao, tetabu ahina raninai tehina bena herekiai a'i pekaobo. ");
INSERT INTO rro_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","'A Iesu ehina benakia etibaha, “Au hanona Tirama ena obia aiarana pouna kairoro aina aiara haeai haeai herekiai pokina weiana paunai euhuna'u.” ");
INSERT INTO rro_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ba Iudea mareakia aokiai eiroro. ");
INSERT INTO rro_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Rani ha Iesu Genesareta obu haianai ekoroti hanona mako tekori kakaiarona Tirama ena 'abi aiana kateona. ");
INSERT INTO rro_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ia ahi rua obu haianai tetai'au eihanakia, ba'eha haukia tehabonakia poeai ekia re'e teutunakia. ");
INSERT INTO rro_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Iesu Simona ena ahiai ehe'au, ehina bena papana kekai ahi 'apuana, ia ahi ai emiati ba mako eba'iobinakia. ");
INSERT INTO rro_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Iesu ena 'abi eore murinai ia Simona ehina bena, “'Oura hamaeao, re'e kohorenakia maia kobarewa.” ");
INSERT INTO rro_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simona ena 'abi ebamuena etibaha, “Poki haumu e, ai rabi maikoina taro 'ari rani taba ha a'i ta'ina, 'a emu 'abi paunai re'e kabaririnakia.” ");
INSERT INTO rro_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Weiana tebabaina hanona maia bo'ona 'akina tebarewanakia, ekia re'e herekai mo patetapa. ");
INSERT INTO rro_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","'Abakia baika ahi ha ai haukia tebakonakia katemai katebarainakia, ba temai ahikia rua tebabonunakia herekai mo pateuhu. ");
INSERT INTO rro_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simona Petero hoa weiana eihana raninai Iesu aena pokinai ekai pehu e'abi etibaha, “Obiapaka e, au hanona ki'a hau'u, here'u ai a'i komiaho.” ");
INSERT INTO rro_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ia mai 'abana kipokia teta'u ta'u huri pokina maia uahomana bo'ona 'akina tebarewanakia buonai, ");
INSERT INTO rro_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Simona kipokia teba'eha oioi haukia Sebedeo nahuna Iakobo mai Ioane abokiamo teta'u ta'u huri. 'A Iesu Simona ehina bena etibaha, “A'i kota'u. Bariu keaomo waira ranikiai oi hanona maearima koba'eha benakia.” ");
INSERT INTO rro_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ekia ahi teberi 'aunakia poeai, taba ikoinai tehabonakia Iesu murinai teka'a. ");
INSERT INTO rro_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Iesu emiaho aiara ha aonai hau ha hauna maikoinai emorumoru, ba Iesu eihana raninai e'eho aena pokinai e'umuti enoina e'abi etibaha, “Obiapaka e, ponuatae raninai pobanamona'u.” ");
INSERT INTO rro_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Iesu imana etiu ahina ea'i 'apuana, ehina bena etibaha, “Nanuatae, monamo.” Beronai morumoru hau weiana ehabona. ");
INSERT INTO rro_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ia eharabuna etibaha, “Hau ha haianai a'i ko'abi, ia koao robe hauna herenai keihani'o, mai banamo baibenina Mose e'abi ihobona tabana kobaibeni, ba maearima katebatohana oi aba onamo.” ");
INSERT INTO rro_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ia pouna tehina otaraina mai to'u rarikia temai tebararona aiana kateona ekia inawa kebanamonakia. ");
INSERT INTO rro_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","'A Iesu ekaobo hano 'abaeana ha eao ebahuba'ari. ");
INSERT INTO rro_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Rani ha Iesu eba'iobi aonai Parisea haukia mai rauhubu poki haukia baika weia temiati, ia hanona Galilea aiara ikoikiai, Iudea mai Ierusalema aokiai temai. Obiapaka hiabuna hanona Iesu ahanai inawa haukia ebanamonakia. ");
INSERT INTO rro_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Maearima baika mero hauna ha toto'eai tebuana teaoaina taearana tetabu katetoto aina Iesu wairanai katehorotina. ");
INSERT INTO rro_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Katetoto aina aonai taeara ha a'i tetabu ahina pokina to'u rarina buonai, ba tekara'au aina teao itu kapenai, kapehene teu kauna mai toto'ena tebaririna Iesu wairanai mako baiatakiai. ");
INSERT INTO rro_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Iesu ekia a'ikakauma eihana raninai e'abi etibaha, “E'u hau e, emu ki'a aba ihina hao.” ");
INSERT INTO rro_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Rauhubu poki haukia mai Parisea haukia aokiai teraonaraona tetibaha, “Neiana hanona hau tabana Tirama nia'i ki'ana? Tai ki'a kehina hao, Tirama mo kipona.” ");
INSERT INTO rro_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","'A Iesu ekia raona e'iobina paunai ehina benakia etibaha, “Taba buonai raona nahomakia aomiai turaonanakia? ");
INSERT INTO rro_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Aeana hauna e'ama'ama kahaihana, emu ki'a aba ihina hao 'ao momikiri moka'a. ");
INSERT INTO rro_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ia wai kato'iobina Maearima Nahuna hanopakai mai hiabuna ki'a kehina hao.” Ia mero hauna ehina bena etibaha, “Au oi nahina beni'o, momikiri emu toto'e moa'ina moao emu itu.” ");
INSERT INTO rro_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Beronai mo wairakiai emikiri ena toto'e ea'i taeana eao ena itu Tirama ebanamona. ");
INSERT INTO rro_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ikoikiai teta'u ta'u huri mai Tirama tebanamona, mai ta'ukia te'abi tetibaha, “Bariu taba neiana haeai tohana haihana.” ");
INSERT INTO rro_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Weiana murinai Iesu ekarahi eao moni bararo hauna ha atana Lebi moni a'i 'ekanai emiati eihana, eaparina etibaha, “Muri'uai omai.” ");
INSERT INTO rro_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lebi emikiri taba ikoikiai ehabonakia Iesu murinai eka'a. ");
INSERT INTO rro_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lebi ena ituai Iesu kero'ona anianina ha ebabaina, weia moni a'i haukia bo'okia mai maearima haeai baika kipokia temiati teaniani haeamo. ");
INSERT INTO rro_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Parisea haukia mai rauhubu poki haukia tehore i'abana haukia herekiai te'abi hara tae tetibaha, “Taba buonai moni a'i haukia mai ki'a haukia kipokia tuaniani mai ṯoinu inu haeamo?” ");
INSERT INTO rro_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Iesu ekia 'abi ebamuena etibaha, “A'i ṯeinawa haukia hanona toketa hauna a'i titabuna, ia inawa haukia mo toketa hauna titabuna. ");
INSERT INTO rro_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Au amai hanona bero haukia a'i kaparinakia, ia ki'a haukia kateraona kabe paunai amai.” ");
INSERT INTO rro_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ia Iesu tehina bena tetibaha, “Ioane i'abana haukia rani bo'okia tiani robe mai tibahuba'ari, Parisea i'abakia haukia abomo ihobona tibabaina, ia oi i'abamu haukia tianiani mai ṯeinuinu.” ");
INSERT INTO rro_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Iesu ehina benakia etibaha, “Wai turaonana hawainibe mahamaha hauna ena baki haukia kipokia ṯemiaho oioi aonai kateani robe hanona ketaina, u? ");
INSERT INTO rro_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","'A rani kemai aonai hawainibe mahamaha hauna herekiai katea'i parena, rani weiakiai ia hanona kateani robe.” ");
INSERT INTO rro_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ia 'abi ibabataiai ehina benakia, “Hau ha habuni maha mahana puana a'i ketapa obona habuni 'ai'aina maranai a'i kehuri abuna pokina habuni mahamahana ketapa obona raninai habuni 'ai'aina mai habuni mahamahana ohi hanona ihakia a'i kateihobo. ");
INSERT INTO rro_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Hau ha bine beina mahamahana aparu 'ai'ainai a'i kebaharuna, weiana kebabaina raninai bine beina mahamahana kekupu aparu 'ai'aina kebua pa'ana haeamona kekiki oioi mai 'aparu keki'a. ");
INSERT INTO rro_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","'A bine beina mahamahana hanona aparu mahamahanai kebaharuna, ba terarua katenamo. ");
INSERT INTO rro_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Hau ha bine beina 'ai'aina keinu murinai bine beina mahamahana a'i kenuatae aina pokina ke'abi bine 'ai'aina hanona enamo.” ");
INSERT INTO rro_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Beraura robenai Iesu mai i'abana haukia kipokia witi umana ha aonai tekabanai, i'abana haukia witi buakia te'ini hurinakia imakia aokiai temutunakia teani. ");
INSERT INTO rro_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Parisea haukia baika te'abi tetibaha, “Wai taba buonai Beraura Robenai a'i katobabaina akana tubabaina?” ");
INSERT INTO rro_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Iesu ekia 'abi ebamuena etibaha, “Wai pa'e Davida orina a'i totuabi 'apuana. Ia mai 'abana kipokia mare'a te'ari raninai taba ebabaina? ");
INSERT INTO rro_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ia Tirama ena ituai etoto tebarobena parawakia robe haukia ikupaiakia mo kateani haukia ea'inakia eani mai i'abana haukia ebenakia.” ");
INSERT INTO rro_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Haeamona ehina benakia etibaha, “Maearima Nahuna hanona Beraura Robe obiana.” ");
INSERT INTO rro_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Beraura robe haeai ha ai Iesu Iuda haukia ekia mareai etoto eba'iobi. Hau ha weia imana itipana hanona ekobe kobe. ");
INSERT INTO rro_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Rauhubu poki haukia mai Parisea haukia ia te'itimana Beraura Robeai kebamauri 'ao, Iesu beho 'ekanai katehorotina taearana tetabu. ");
INSERT INTO rro_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","'A Iesu ekia raona e'iobina, weiana ima kobe kobe hauna ehina bena etibaha, “Momikiri baiatakiai mokoroti.” Ba emikiri ekoroti. ");
INSERT INTO rro_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Iesu ehina benakia etibaha, “Au wai nabakainimi, aeana hauna ebero Beraura Robeai kahabanamo 'ao kahabaki'a, kahabamauri 'ao kahaba'ari?” ");
INSERT INTO rro_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Iesu ikoikiai eiha kakaiaronakia murinai ima kobe hauna ehina bena etibaha, “Imamu motiu berona.” Ia ebabaina hanona imana ebero mue. ");
INSERT INTO rro_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","'A ia hanona aokia teopuere ki'a, kipokia teroba ahu Iesu herenai taba katebabaina. ");
INSERT INTO rro_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Rani weianai Iesu oeoai ekara'au kebahuba'ari, rabi maikoina ebahuba'ari Tirama herenai. ");
INSERT INTO rro_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Aba rani nimaiaina aonai ia i'abana haukia eaparinakia temai, baiatakiai harau haea rua ea'i taeanakia ata ebenakia iuhubeau haukia. ");
INSERT INTO rro_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ia hanona Simona atana eaparina Petero mai hatina Anderea ohi, Iakobo mai Ioane ohi, Pilipo mai Batolomeo ohi, ");
INSERT INTO rro_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mataio, Toma, Alepeo nahuna Iakobo, mai Simona teaparina Selote hauna ohi, ");
INSERT INTO rro_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Iakobo nahuna Iuda mai Isakariote hauna Iuda ia hinahinana kehina hauna. ");
INSERT INTO rro_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Iesu i'abana haukia kipokia oeoai teriri hano beronai tekoroti. I'abana haukia to'una rarina weia mai maearima bo'ona 'akina Iudea hanona 'ekakia ikoikiai Ierusalema ai Turo mai Sidono poe hanokia ikoikiai temai, ");
INSERT INTO rro_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","aiana kateona mai ekia inawa katenamo. Auba ki'a obokia tebaro 'arinakia haukia abomo temai ebanamonakia. ");
INSERT INTO rro_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","To'u maikoina tebahobona katea'i 'apuana pokina hiabu ia aonai ekarahi ikoikiai ebamaurinakia. ");
INSERT INTO rro_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Iesu i'abana haukia eihanakia ena 'abi ea'i ramana etibaha, “Wai ṯouraru haumi tonamo, pokina Tirama ena obia aiarana hanona wai 'eumi. ");
INSERT INTO rro_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Wai bariu tumare'a haumi tonamo, pokina wai hanona nuami katebonu. Wai bariu tuhai haumi tonamo, pokina wai katoiriri. ");
INSERT INTO rro_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Maearima Nahuna paunai maearima ti'oatanimi, hoami tihorena, ti'abi ki'a heremiai, atami tia'i ki'anakia raninai wai hanona tonamo. ");
INSERT INTO rro_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Rani weianai aomi katenamo katorobo katoaonamo wairai, pokina kupai arami rarina 'akina. Weiana ihobona tohanai 'aba'abakia ua tebabai aiho mahabanai haukia herekiai. ");
INSERT INTO rro_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“'A bariu tuobia haumi heremiai hanona keki'a ki'a baha, pokina emi namo maikoinai aba toa'ina. ");
INSERT INTO rro_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Bariu tuani 'ari haumi heremiai hanona keki'a ki'a baha, pokina wai katomare'a. Bariu ṯoiriri haumi heremiai hanona keki'a ki'a baha, pokina aomi katehaiara mai katohai. ");
INSERT INTO rro_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Maearima ikoikiai atami tibanamona raninai heremiai hanona keki'a ki'a baha, pokina 'aba'abakia babai ihobona tohana tebabaina mahabanai bai'oi haukia herekiai. ");
INSERT INTO rro_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Iamo aia'u tuona haumi nahina benimi. Emi 'ou haukia katoraona'au ainakia, weiakia 'arimi a'i ti'ari haukia herekiai katobabai harai. ");
INSERT INTO rro_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Weiakia ṯeururu heremiai haukia katoba namonakia, tibabai ki'a heremiai haukia ahakiai katobahuba'ari. ");
INSERT INTO rro_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Hau ha mekemu kebo'ana raninai, koke'e banai abirana abomo kobena. Mai hau ha emu kota kea'i parena raninai, emu habuni ibatoto a'i koubo aina. ");
INSERT INTO rro_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Maearima heremuai taba tinoiai haukia kobenakia, mai hau ha emu taba ha ea'ina rea imue aina robana a'i koahuna. ");
INSERT INTO rro_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Wai emi nuatae maearima ua patebabai aiho heremiai, wai abomo ua katobabai aiho maearima herekiai. ");
INSERT INTO rro_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Weiakia tiraona'au ainimi haukia mo katoraona'au ainakia hanona ena namo taba wai heremiai? Aka ki'a haukia abomo tiraona'au ainakia haukia ua tiraona'auai aihonakia. ");
INSERT INTO rro_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Weiakia heremiai tibabai harai haukia herekiai mo tubabai harai hanona ena namo taba? Aka ki'a haukia abomo ua tibabai aiho. ");
INSERT INTO rro_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Weiakia taba katebamue haukia mo tubenakia hanona ena namo taba wai heremiai? Aka ki'a haukia abomo aka ki'a haukia tibenakia weiana 'arakia katebamue. ");
INSERT INTO rro_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","'A emi 'ou haukia katoraona'au ainakia, mai katobabai harai herekiai, mai katobaibeni tabakia 'arakia ibamuekia a'i katoraonanakia. Weiana 'arami apa'uana katoa'ina, mai wai hanona 'ubi toha tohana Tirama nahunai katoao, pokina Ia hanona a'i tibanamona haukia mai ki'a haukia abokiamo eaoko'o ainakia. ");
INSERT INTO rro_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Aoko'o akakia katobabai Hamami 'abana, Ia hanona mai ena aoko'o. ");
INSERT INTO rro_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“'Abami a'i katoba bakainakia ba Tirama abomo wai a'i mebabakainimi, 'abami a'i katobaki'anakia ba Tirama abomo wai a'i mebaki'animi, 'abami ekia ki'a katohina hao ba Tirama abomo wai emi ki'a kehina hao. ");
INSERT INTO rro_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Katobaibeni 'abami herekiai ba Tirama abomo kebenimi, ihobona taba ha kebonu 'auna 'abana kehao 'inina keahu 'inina kekiki oioi, ua kebeni aihonimi. Pokina tobaibeni ihobonai Tirama abomo wai kebeni muenimi.” ");
INSERT INTO rro_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Iesu 'abi ibabatai neiana ehina benakia etibaha, “Maha 'iau hauna ha kehore maha 'iau hauna ha a'i kebaka'ana, weiana kebabaina raninai terarua 'uri aonai katetoa. ");
INSERT INTO rro_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Marere miorina ha ena ba'iobi hauna a'i ketara haona, 'a marere miorikia ekia marere katebaore haraina hanona ba'iobi hauna kipokia kateihobo. ");
INSERT INTO rro_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Taba buonai matiu nabunabuna weiana 'abamu mahana aonai noihana, 'a arako'o rarina oi mahamu aonai hauna a'i nuraonana. ");
INSERT INTO rro_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Oi kipomu mahamu aonai arako'o rarina weiana a'i noihana raninai, aea homanai uaho'abamu kohina bena, ‘Uaho'aba'u e, mahamu aonai matiu nabunabuna ma'i ahina.’ Bahaorea haumu e, mahamu aonai arako'o rarina moa'i ahi 'uaina, murinai uaho'abamu mahana aonai matiu nabunabuna koiha haraina koa'i ahina.” ");
INSERT INTO rro_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Weiana matiu namona buabua ki'a obona a'i kebaramana, abomo matiu ki'a obona buabua namona a'i kebaramana. ");
INSERT INTO rro_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Pokina matiu haha buabuakiai 'iobi nirama, weiana maearima 'ini boaboai ororo a'i ṯebubu obona, haeamona awa 'ini'iniai 'aruhi a'i tia'ina. ");
INSERT INTO rro_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Hau namona ehore aonai taba namokia ebararo 'ekanai taba namokia nitara'au, hau ki'a obona ehore aonai ki'a tabakia ebararo 'ekanai ki'a tabakia nitara'au. Pokina aonai taba ebonu hauna pinanai nehinana. ");
INSERT INTO rro_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Wai taba buonai tuaparina'u, ‘Obiapaka e, Obiapaka e,’ ia e'u 'abi a'i tua'i taeana. ");
INSERT INTO rro_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Maearima here'u timai mai e'u 'abi aiana tiona mai akana tibabaina haukia kabaihanimi ia hanona aea homakia. ");
INSERT INTO rro_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ia hanona matoha hau ha itu ebabaina, 'uri ehabi 'ourana pihara ahanai hoboro ebakorinakia, tou ekarahi raninai itu etorina 'a itu a'i ebaibiuna, pokina itu hanona ebakori harai ki'a bahana. ");
INSERT INTO rro_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Iamo aia eona akana a'i ebabaina hauna ihobona matoha hau ha itu 'ano ahanai ebakorina hoborona aha'i, tou ekarahi itu etouna, beronai mo itu epobu, itu epobu hanona earu otaraina.” ");
INSERT INTO rro_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Iesu ena 'abi ikoinai ehina orenakia maearima herekiai murinai ekatoto Kaperanauma. ");
INSERT INTO rro_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Roma huari poki hauna ha weia ena ta'ara'i hauna 'arina e'ari ki'a baha hauna hanona einawa ki'a aba ke'ari. ");
INSERT INTO rro_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ia Iesu pouna eona raninai Iuda haukia apa'uakia baika euhunakia katenoina kemai ena ta'ara'i hauna kebamaurina. ");
INSERT INTO rro_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Temai Iesu herena raninai tenoi hao noi haona tetibaha, “Hau neiana pobaraina hanona penamo. ");
INSERT INTO rro_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Pokina ia eka itubu niraona'au aina, ia ehore marea ebakorina 'eumai.” ");
INSERT INTO rro_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Weiana Iesu kipokia teao, bariu Iesu itu ebarina aonai huari poki hauna ena hau euhunakia Iesu tehina bena tetibaha, “Obiapaka e, a'i koaro'ari, pokina au a'i anamo komai e'u ituai kototo. ");
INSERT INTO rro_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ua buonai kawahi heremu abomo a'i etaina. ");
INSERT INTO rro_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Weiana au hanona hau ha ena hiabu ba'anai, mai huari haukia abomo au ba'a'uai. Au hau neiana ha nahina bena moao hanona ia niao, 'abana nahina bena omai hanona ia nimai. E'u ta'ara'i hauna nahina bena neiana mobabaina hanona ia nibabaina.” ");
INSERT INTO rro_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Iesu aia weiana eona raninai eta'u ta'u huri, ekabe to'u murinai haukia ehina benakia, “Au wai nahina benimi, Isaraela aonai a'ikakauma nahomana ha a'i atabu ahina.” ");
INSERT INTO rro_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Weiakia euhunakia haukia temue teao itu raninai, ta'ara'i hauna aba enamo tetabu ahina. ");
INSERT INTO rro_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Rani papana eao murinai Iesu eao aiara ha atana Nain, i'abana haukia mai mako ia kipokia teao. ");
INSERT INTO rro_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Aiara pa'abina aba tibarina aonai, 'ari hauna ha tebua ahina weiana hanona wapu ha nahuna hamo hamona, aiara haukia bo'okia wapu te'abana. ");
INSERT INTO rro_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Obiapaka wapu eihana raninai eaoko'o aina, weiana ehina bena etibaha, “A'i kohai.” ");
INSERT INTO rro_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ia eka'a ha ha eao ko'o ea'i 'apuana, ba ko'o tebuana haukia tekoroti. Iesu e'abi etibaha, “Hau aruaruna e, au nahina beni'o, momikiri.” ");
INSERT INTO rro_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","E'ari hauna emikiri emiati e'abi'abi, Iesu miori hinana ebeni muena. ");
INSERT INTO rro_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ikoikiai teta'u wairai, weiana Tirama tebanamona tetibaha, “Mahabanai apa'uana ha baiatakai ewaira tina.” Haeamona tetibaha, “Tirama aba emai ena maearima herekia.” ");
INSERT INTO rro_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Iesu pouna neiana Iudea 'eka maikoina mai herena hanokia ikoikiai aokiai tehina otaraina. ");
INSERT INTO rro_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ioane i'abana haukia 'abi neiakia ikoikia tehinanakia ia herenai. ");
INSERT INTO rro_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","I'abana haukia rua eaparinakia euhunakia Obiapaka katebakaina katetibaha, “Kemai hauna hanona oi, 'ao haeai ha kata'imana?” ");
INSERT INTO rro_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Temai Iesu herena raninai tehina bena tetibaha, “Ba'uere Robe hauna Ioane euhunamai heremu katabakaini'o, ‘Kemai hauna hanona oi, 'ao haeai ha kata'ima?’” ");
INSERT INTO rro_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Rani weianai Iesu hanona maearima bo'ona 'akina ekia inawa, hau haiara mai auba ki'a obokia aokiai haukia ebanamonakia, abomo maha 'iau haukia bo'ona mahakia ebano'a. ");
INSERT INTO rro_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Iesu terarua ekia 'abi ebamuena etibaha, “Tomoao, taba toiha mai urukia to'o haukia Ioane katohina bena. Maha 'iau haukia aba ṯeihaiha, 'ome'ome haukia aba tika'a, morumoru haukia aba teta'e ta'e, haia po'o haukia aia aba tiona, 'ari haukia aba ṯemikiri timauri mauri, abomo uraru haukia herekiai pou namona nairoro aina.” ");
INSERT INTO rro_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Haeamona e'abi etibaha, “Aona a'i nikai'au kai'au here'uai hauna hanona enamo.” ");
INSERT INTO rro_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ioane euhunakia haukia temue murinai, Iesu haeamona to'u haukia herekiai Ioane pouna ehinana etibaha, “Toao hano 'akunai hanona taba katoihana? Baura kopura eabunakia katoihanakia, u? ");
INSERT INTO rro_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Aha'i raninai taba katoihana buonai toao weia? Hau ha habuni 'arana rarina ebatotona katoihana, u? Weiakia habuni namoabukia tibatotonakia mai ekia obia tabakia tebo'o haukia hanona obia arana hauna ena ituai katotabu ahinakia. ");
INSERT INTO rro_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Taba katoihana buonai toao weia? Mahabanai hauna ha, u? 'E, 'abi tohana, au wai nahina benimi, neiana hauna ehore mahabanai haukia bo'ona etara haonakia. ");
INSERT INTO rro_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Weiana hauna pouna Puka Robenai tererena, ‘E'u iuhubeau hauna kauhuna ke'uai, emu taeara kea'ia'i harai 'uaina.’ ");
INSERT INTO rro_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Au wai nahina benimi. Babi'e nuakiai terama haukia ikoikiai baiatakiai ha Ioane a'i etara haona. Ia Tirama ena obia aiarana aonai eko'i ko'i ki'a baha hauna mo Ioane etara haona.” ");
INSERT INTO rro_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Maearima ikoinai abomo moni bararo haukia Iesu ena 'abi 'uruna teona raninai Tirama ena taeara berona tebatohana, pokina ia hanona Ioane eba'uere robenakia. ");
INSERT INTO rro_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","'A Parisea haukia mai rauhubu poki haukia Ioane ena ba'uere robe a'i tenuatae aina buonai Tirama ena nuatae 'eukiai hauna tebaoao aina. ");
INSERT INTO rro_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Iesu haeamona e'abi etibaha, “Uru neiana maearimakia hanona tabai kababatainakia? Ia hanona tabai kabaihobonakia? ");
INSERT INTO rro_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ia hanona matoha miori papakia aiara ibuanai ṯemiati 'abakia tiaparinakia ṯetibaha, ‘Ai pihi ṯaubainakia, ia wai a'i ṯoewa, 'ari huikia ṯa'i, ia wai a'i tuhai.’ ");
INSERT INTO rro_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Pokina ba'uere robe hauna Ioane emai raninai a'i eaniani mai bine beina a'i einu, ba wai to'abi totibaha, ‘Ia aonai auba ki'a obona ha nemiaho.’ ");
INSERT INTO rro_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Maearima Nahuna emai nianiani mai neinuinu hanona wai tu'abi ṯotibaha, ‘Aniani ki'a mai inuinu ki'a hauna abomo moni bararo haukia mai aka ki'a haukia ekia hau.’ ");
INSERT INTO rro_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","'A Tirama ena aobero hanona katea'i taeana haukia herekiai ena bero kewaira tina.” ");
INSERT INTO rro_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Parisea hauna ha Iesu enuatae aina ena ituai kateaniani haeamo, ba Iesu eao ituai etoto aniani 'ekanai emiati. ");
INSERT INTO rro_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Aiara weiana aonai aka ki'a babi'ena ha, Iesu Parisea hauna ena ituai kateaniani pouna eona raninai, ia pihara kabapuna aonai muramura timina 'orimona hauna emaiaina. ");
INSERT INTO rro_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Eao Iesu murinai aena pokinai ekoroti ehai ba mahana beikiai aena ebabeinakia, buinai eba'ororonakia abomo epaunakia, muramura timina 'orimona eheina ahakiai. ");
INSERT INTO rro_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Parisea hauna weiana Iesu eaparina hauna babi'e ena babai eihana raninai, kipona aonai eraonana etibaha, “Neiana mahabanai hauna tohana raninai, ia aba pe'iobina, babi'e tabana ia nia'i 'apuana, pokina ia hanona ki'a babi'ena.” ");
INSERT INTO rro_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Iesu ehore ehina bena etibaha, “Simona e, au 'abi ha oi heremu ai, kahinana.” Ia etibaha, “Ba'iobi haumu e, mo'abi.” ");
INSERT INTO rro_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Iesu e'abi etibaha, “Hau rua moni baibeni hauna ha herenai moni tea'inakia, hamona hanona kina hinabu ima ea'ina, ha hanona kina imabui ea'ina. ");
INSERT INTO rro_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ara katehore a'i etainakia buonai terarua moni katemue ainakia haukia ekakinakia, ba aeana hauna ia 'arina ke'ari ki'a baha?” ");
INSERT INTO rro_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simona e'abi etibaha, “Naraonana, pa'e weiana ena a'i 'uai apa'uana ekakina hauna.” Iesu ia ehina bena etibaha, “Aba o'abi harai.” ");
INSERT INTO rro_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Iesu ekabe babi'e eihana, ba Simona ehina bena, “Babi'e neiana noihana? Au amai emu ituai atoto hanona ae'u beikia a'i obaibeni. 'A ia hanona mahana beikiai ae'u eutunakia abomo buinai eba'ororonakia. ");
INSERT INTO rro_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Oi a'i opauna'u, 'a babi'e neiana akatoto ramana raninai ae'u ipaukiai a'i e'oro 'apua. ");
INSERT INTO rro_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Oi ara'u tehoroai a'i oheina, 'a ia tehoro timina 'orimonai ae'u eheinakia. ");
INSERT INTO rro_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ua buonai nahina beni'o, ena ki'a bo'ona 'akina haukia aba ihina hao, pokina ena raona'au eapa'ua paunai, ia tai ena raona'au papana hauna hanona ena ki'a papana ihina hao.” ");
INSERT INTO rro_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ba Iesu babi'e ehina bena etibaha, “Emu ki'a aba ihina hao.” ");
INSERT INTO rro_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Aniani 'ekanai temiati haukia kipokia baiatakiai te'abi'abi tetibaha, “Neiana hanona tai, ba ki'a abomo nehina hao.” ");
INSERT INTO rro_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Iesu babi'e ehina bena etibaha, “Emu a'ikakauma ehore ebamaurini'o, mai baibuamu moao.” ");
INSERT INTO rro_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Neiana murinai rani a'i ehoma'a Iesu eao aiara apa'uakia mai papakia aokiai Tirama ena obia aiarana pouna namona eiroro aina. I'abana haukia harauhaea rua hanona te'abana kipokia teao, ");
INSERT INTO rro_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","mai babi'e baika abomo, auba ki'a obokia 'eukiai eu'u ahinakia mai hau haiarai ebanamonakia babi'ekia, ha Maria Magadala babi'ena aonai auba ki'aobokia 'abaihau hamomo eba karahinakia babi'ena, ");
INSERT INTO rro_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ha Ioanna, atawana Kusa hanona Heroda obia arana ena itu kohukia nipoki ainakia hauna, mai Susanna, mai babi'e bo'okia baika. Babi'e neiakia kipokia ekia tabai Iesu mai i'abana haukia tebarainakia. ");
INSERT INTO rro_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Maearima bo'ona aiara ha ha ai temai Iesu herenai to'u rarina tebabaina aonai Iesu 'abi ibabatai neiana ehinana etibaha, ");
INSERT INTO rro_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Biraura hauna ha eao ena uho kebatonakia. Ekapo kapo otarainakia aonai baika taearai te'eho, ba maearima ahakia tehe'au haeamona ubi roborobokia teani orenakia. ");
INSERT INTO rro_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Uho baika bohu ahanai te'eho, te'omu ia tepaea pokina hano a'i emapu mapu. ");
INSERT INTO rro_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Uho baika awa 'ini'inikia aokiai te'eho, awa 'ini'inikia kipokia te'omu haeamo ba tetara tara abunakia. ");
INSERT INTO rro_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Uho baika hano namonai te'eho, te'omu harai tebua'a buakia hinabu ha ha 'abana.” Iesu ena 'abi puanai e'abi aota etibaha, “Mai haiana hauna hanona ke'iobina.” ");
INSERT INTO rro_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","I'abana haukia Iesu tebakaina 'abi ibabatai neiana anina taba. ");
INSERT INTO rro_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ia e'abi etibaha, “Tirama ena obia aiarana 'iobikia bunikia hanona aba wai ebenimi, ia baika herekiai hanona 'abi ibabataiai nahina benakia, weiana, ‘kateihana mo ia a'i kateiha tinana aia kateona ia obona a'i kateobo.’ ");
INSERT INTO rro_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“'Abi ibabatai anina neiana. Uho hanona Tirama ena 'abi. ");
INSERT INTO rro_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Uho taearai te'eho haukia hanona weiakia, aia tiona ia tiaporo nimai 'abi aokiai nia'i parena pokina a'i teme a'ikakauma mai a'i tememauri ta'una. ");
INSERT INTO rro_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Uho weiakia bohu ahanai te'eho haukia hanona weiakia, aia tiona raninai 'abi tia'ina mai aonamokia, iamo ramukia aha'i rani papana mo tia'ikakauma ba baihobo nimai raninai ti'eho. ");
INSERT INTO rro_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Uho weiakia awa 'ini'inikia aokiai te'eho haukia hanona weiakia, aia tiona ia mauri neiana ena ao aro'ari ena obia tabakia mai ena aonamo tabakiai aokia nikaiabunakia ba buabuakia ṯepure. ");
INSERT INTO rro_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","'A uho weiakia hano namonai te'eho haukia hanona weiakia, aokia beronai mai namonai 'abi uruna tiona tia'i 'inina tibakiro niao mo buabuakia tibarama.” ");
INSERT INTO rro_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Iesu haeamona ehina benakia etibaha, “Hau ha ramepa niba'arana raninai uro aonai a'i nibahu abuna 'ao parua itarana ba'anai a'i nikai tina 'a ia ramepa ihao'auna 'ekanai nihao 'auna ba weiakia katetoto haukia hanona ea kateihana. ");
INSERT INTO rro_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Taba ikoinai tehore buni haukia hanona katekarahi mahanai, taba ikoinai tebahu abu haukia hanona eai katebawaira tinanakia. ");
INSERT INTO rro_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Aia aea nuo aihona hanona ko'ima haraina, pokina mai 'euna hauna hanona ahanai baika Tirama kehore 'auna kebena, ia 'euna aha'i hauna hanona herenai papana nemiaho niraonana 'euna hauna abomo kea'i obona.” ");
INSERT INTO rro_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ba Iesu hinana mai hatina temai kateihana iamo a'i etainakia pokina to'u rarina paunai. ");
INSERT INTO rro_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Hau ha Iesu ehina bena etibaha, “Oi hinamu mai hatimu mahanai tekoroti ṯenuatae kateihani'o.” ");
INSERT INTO rro_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ba ena 'abi ebamuena etibaha, “Neiakia Tirama ena 'abi aiana tiona mai akana tibabaina haukia hanona au hina'u mai hati'u.” ");
INSERT INTO rro_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Rani ha Iesu i'abana haukia kipokia ahi ai tehe'au ba ehina benakia etibaha, “Aika hamaeao obu abirana.” Ba tebeau ahi. ");
INSERT INTO rro_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Tebeau oho aonai, Iesu hanona enoti eparua 'ari. Ba kou rarina obu aonai eabu 'au, bei ahi aonai teraku uta hereka 'akinai pateuhu. ");
INSERT INTO rro_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","I'abana haukia teao Iesu tebaona tetibaha, “Poki haumu e, poki haumu e, aika aba kahatono 'ari.” Ba ia emikiri baura mai roio erikenakia, baura e'oro roio e'omata. ");
INSERT INTO rro_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ba i'abana haukia ehina benakia etibaha, “Emi a'ikakauma ae'e?” Ia teta'u ta'u huri abomo teta'u ki'a kipokia baiatakiai tebakai bakai tetibaha, “Neiana hanona hau tabana, baura mai roio ehina benakia hanona aiana tika'aina.” ");
INSERT INTO rro_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Iesu i'abana haukia kipokia ahiai tebeau banai teao Gerasene hanonai weiana hanona Galilea obu abiranai. ");
INSERT INTO rro_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Iesu ekara'au poeai raninai, aiarai hau ha aonai auba ki'a obokia temiaho hauna emai tebaitabu ahi. Aba wa'i baha 'akinai habuni ha'i ebatotona haeamona ituai a'i emiaho, ia 'ari ahanai emiaho. ");
INSERT INTO rro_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ia Iesu eihana raninai eio ki'a haeamona e'eho aena pokinai eio aota ki'a etibaha, “Iesu 'ubi tohanai Tiramana Nahuna e, taba nonuatae aina here'uai kobabaina. Nanoini'o puma a'i kobena'u.” ");
INSERT INTO rro_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Pokina Iesu auba ki'a obokia aba ehina benakia hau weiana aonai katekarahi. Rani bo'okia auba ki'a obokia tehaburi abuna, maearima tehore imana aena tabiriai tebirinakia te'ima haraina iamo tabiri eba mohunakia haeamona auba ki'a obokia tebabeau totona hano 'akunai. ");
INSERT INTO rro_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Iesu ia ebakaina etibaha, “Atamu tai?” Ia etibaha, “Ata'u hanona Mako.” Pokina auba ki'a obokia bo'ona 'akina aonai temiaho. ");
INSERT INTO rro_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ia auba ki'a obokia Iesu tenoina a'i keuhunakia a'i kateao 'uri 'ourana aena aha'i hauna aonai. ");
INSERT INTO rro_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Aiporo to'una ha weia teba korinakia oeo mekenai teaniani, ba auba ki'a obokia Iesu tenoina keuhunakia kateao aiporo aokiai katetoto buonai euhunakia teao. ");
INSERT INTO rro_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ba auba ki'a obokia hau weiana aonai tekarahi teao aiporo aokiai tetoto, aiporo to'una tebeau riri papa'ai terobo ahi, 'obu aonai tetono 'ari. ");
INSERT INTO rro_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Aiporo bakori haukia taba weiana erama teihana raninai tebeau 'akauma aiarai mai umai pou neiana tehinana. ");
INSERT INTO rro_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Maearima teao taba erama hauna kateihana Iesu herenai tekara'au raninai, hau weiana aonai auba ki'a obokia tekarahi hauna Iesu aena pokinai emiati habuni ebatotona abomo aona aba ebero teihana ba ikoikiai teta'u ki'a. ");
INSERT INTO rro_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Weiakia teihana haukia maearima herekiai hau weiana aonai auba ki'a obokia tetoto hauna aea enamo aiho hauna pouna tehinana. ");
INSERT INTO rro_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Gerasene maearimakia ikoikiai Iesu tenoina hano weianai kekapare pokina teta'u ki'a. Weiana ia ahiai ehe'au kemue. ");
INSERT INTO rro_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Hau weiana aonai auba ki'a obokia tekarahi hauna Iesu enoina pe'abana, ia Iesu ehore ebamuena ehina bena etibaha, ");
INSERT INTO rro_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Komue emu aiara, Tirama taba ebabaina heremuai hauna pouna kohinana.” Ua buonai hau weiana eao aiara maikoinai aokiai Iesu taba ebabaina herenai hauna pouna ehinana. ");
INSERT INTO rro_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Iesu emue raninai, to'u haukia tehore tea'i taeana pokina ikoikiai ia te'imana. ");
INSERT INTO rro_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Weiana hau ha atana Iairo marea poki hauna ha emai Iesu aena pokinai ekuti enoina kateao ena itu. ");
INSERT INTO rro_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Pokina nahuna uahona hamo hamonamo ihauna harauhaea rua hanona aba ke'ari. Iesu niao oho aonai to'u rarina aonai eka'a. ");
INSERT INTO rro_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ba babi'e ha weia, ia hanona babi'e ekia inawa ea'ina aba ihau harauhaea rua, muramura haukia herekiai ena kohu ebaorenakia, hau ha ia a'i ebanamona. ");
INSERT INTO rro_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ia Iesu murinai ekataeana eao ena habuni puana ea'i 'apuana, beronai mo ena inawa e'oro. ");
INSERT INTO rro_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Iesu ebakai bakai etibaha, “Tai ea'i 'apuana'u?” Ikoikiai tebuniai aonai Petero e'abi etibaha, “Poki haumu e, maearima tekori abuni'o abomo tetuani'o.” ");
INSERT INTO rro_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","'A Iesu e'abi etibaha, “Hau ha ea'i 'apuana'u pokina a'iobina hiabu hau'uai hauna aba ekarahi.” ");
INSERT INTO rro_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Weiana babi'e e'iobina kepihi taearana aha'i ba eao mai 'ururu 'ururuna e'eho Iesu aena pokinai, taba buonai ea'i 'apuana abomo aea enamo aiho pouna maearima ikoikiai wairakiai ehinana. ");
INSERT INTO rro_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ba Iesu babi'e weiana ehina bena etibaha, “Naha'u e, emu a'ikakauma ehore aba ebanamoni'o mai baibuamu moao.” ");
INSERT INTO rro_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Iesu ni'abi ohomo aonai hau ha Iairo ena ituai emai Iairo ehina bena etibaha, “Nahumu aba e'ari. Ba'iobi hauna a'i mobaro 'ari 'abaeana.” ");
INSERT INTO rro_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Iesu aia weiana eona ba Iairo ehina bena etibaha, “A'i kota'u, koa'ikakaumana'u. Nahumu hanona kenamo.” ");
INSERT INTO rro_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Iesu Iairo ena ituai ekara'au raninai maearima ikoikiai ebamuenakia, ia Petero, Iakobo, mai Ioane mai uaho hamana hinana mo te'abana tetoto. ");
INSERT INTO rro_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Weia hanona maearima ikoikiai uaho tihai aina mai tiaoko'o aina. Iesu e'abi etibaha, “Hai tomobapuana, uaho hanona a'i e'ari, ia niparua.” ");
INSERT INTO rro_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Maearima Iesu teiriri aina, te'iobina uaho hanona aba e'ari toha. ");
INSERT INTO rro_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Iesu uaho imanai ea'i eaparina etibaha, “Naha'u e, momikiri.” ");
INSERT INTO rro_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Uaho aubana emue beronai emikiri, ba Iesu ehina benakia taba ha katebena keana. ");
INSERT INTO rro_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Uaho hamana mai hinana teta'u ta'u huri, 'a Iesu ehara abunakia taba erama hauna hanona tai ha haianai a'i kate'abi. ");
INSERT INTO rro_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Iesu ehore i'abana haukia harau haea rua eaparinakia, ebato'unakia, tabura mai hiabu ebenakia paipai ki'a obokia ikoikiai kateu'u ahinakia mai inawa haeai haeai kateba maurinakia, ");
INSERT INTO rro_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ba euhunakia Tirama ena obia aiarana pouna kateiroro aina abomo inawa haukia kateba namonakia. ");
INSERT INTO rro_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ehina benakia, etibaha “Emi harima ai taba ha a'i katoa'ina, ikai'ini aha'i, mahoa aha'i, aniani aha'i, moni aha'i, abomo emi ibatoto ibaruakia a'i katoa'inakia. ");
INSERT INTO rro_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Itu tabanai katokara'au raninai weiamo katomiaho keaomo aiara weiana katohabona. ");
INSERT INTO rro_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ba maearima a'i katea'i taeanimi raninai 'apumi apurorokia katoahuahu obo ba ekia aiara katohabona ia irobekia 'abinai keao.” ");
INSERT INTO rro_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ba i'abana haukia temikiri teao aiara haha aokiai pou namona teiroro aina abomo maearima tebamaurinakia. ");
INSERT INTO rro_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Heroda Obia hauna taba ikoinai Iesu ebabai poukia eo'o raninai aona earo'ari, pokina baika tehina bena ba'uere robe hauna Ioane aba 'ariai emikiri mue. ");
INSERT INTO rro_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Baika tetibaha Elia aba ewaira tina, haeamona baika tetibaha mahabanai hauna 'ai'aina ha bariu emikiri mue. ");
INSERT INTO rro_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ia Heroda etibaha, “Ioane 'akona aba akabe hurina, 'a 'uruna ṉaona aka ṉahomakia nibabai hauna hanona tai?” Ba ena nuatae hanona keihana. ");
INSERT INTO rro_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Iuhubeau haukia temue Iesu herena taba taba tebabai haukia ia wairanai tehinanakia. Weiana ia ehore ebaka'a obonakia ia kipokia teao aiara ha atana Betesaida ai. ");
INSERT INTO rro_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ia maearima te'iobina Iesu aba weia hanona ikoikiai ia murinai teao. Ea'i taeanakia, Tirama ena obia aiarana 'abina ehinana abomo mauri tenuatae haukia ebamaurinakia. ");
INSERT INTO rro_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Beraura aba erabirabi i'abana haukia harau haea rua temai herena tehina bena tetibaha, “Maearima neiakia mouhunakia, temera'a temeao aiara 'ao uma herekai haukia weia katemiaho kipokia ekia aniani katetabu pokina 'eka neiana hanona hano'akuna.” ");
INSERT INTO rro_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Iesu ekia 'abi ebamuena etibaha, “Wai taba ha tomobenakia temeani.” Ia tetibaha, “Ai heremaiai ṯemiaho haukia hanona parawa ima maia rua mo, konuatae kataeao aniani katakawanakia maearima neiakia 'eukia, 'u?” ");
INSERT INTO rro_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Hau 'abaeana hanona ikoinai taha ima (5,000) 'abana. Iesu i'abana haukia ehina benakia etibaha, “Maearima neiakia haukia imabui imabui katoba miatinakia.” ");
INSERT INTO rro_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ehinana hauna ihobonai i'abana haukia tebabaina ba maearima ikoikiai temiati. ");
INSERT INTO rro_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Iesu ehore parawa ima mai maia rua ea'inakia ea'a taea kupa eihana ebanamona murinai ehobi 'iti'itinakia. Ba i'abana haukia ebenakia katekaitinakia maearima wairakiai. ");
INSERT INTO rro_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Weiana ikoikiai teaniani eao teani 'ari, i'abana haukia aniani harikia pohea harauhaea rua tebabonunakia. ");
INSERT INTO rro_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Rani ha Iesu kipona ebahuba'ari, i'abana haukia hanona ia herenai temiaho ebakainakia etibaha, “Maearima au aha'uai taba ṉa tihoma?” ");
INSERT INTO rro_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ia ena 'abi tebamuena tetibaha, “Baika ti'abi Ioane Ba'uere robe hauna, baika ti'abi Elia, baika ti'abi mahabanai hauna ha aba 'uainai e'ari hauna bariu emauri mue.” ");
INSERT INTO rro_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ebakainakia, “Ia wai hanona taba ṉa tuhoma? Au hanona tai?” Petero ena 'abi ebamuena etibaha, “Oi hanona Keriso Tirama euhuni'o haumu.” ");
INSERT INTO rro_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ia ehore eharabunakia hau ha a'i katehinabe 'apuana. ");
INSERT INTO rro_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Haeamona etibaha, “Maearima Nahuna hanona kehaiara ki'a baha, aiara hau apa'uakia, robe haukia apa'uakia mai rauhubu poki haukia kate'oatana abomo kateahu 'arina, ia wapu ibaihaunai kemikiri mue.” ");
INSERT INTO rro_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ikoikiai ehinabe muenakia etibaha, “Tai ha nenuatae au ke'abana'u raninai, ia kipona ena mauri kehabona ena matiu ibiri ropo kea'i taeana kebuana rani ikoinai au muri'uai keka'a. ");
INSERT INTO rro_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Pokina ena mauri kea'i 'inina hauna hanona ena mauri keba'akaumana, 'a au pau'uai ena mauri kene'ena hauna hanona mauri kea'ina. ");
INSERT INTO rro_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Hau ha hanopaka tabakia maikoinai pea'ina ena mauri peba 'akaumana 'ao pea'i ki'ana raninai ena namo hanona taba? ");
INSERT INTO rro_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Hau ha au pau'uai 'ao e'u 'abi paukiai kehaumaea raninai, Maearima Nahuna abomo ia kehaumaeaina ena nuabiai abomo Hamana ena nuabiai ena aneru robekia kipokia ekia mai raninai. ");
INSERT INTO rro_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","'Abi tohana mo au wai nahina benimi, neia tikoroti haukia baika hanona a'i kate'ari keaomo Tirama ena obia aiarana kateihana.” ");
INSERT INTO rro_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","'Abi neiakia ehinanakia wapu 'ababani teore murikiai Iesu ehore Petero, Ioane mai Iakobo eba ka'anakia oeoai tekara'au kebahuba'ari paunai. ");
INSERT INTO rro_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ebahuba'ari aonai ia wairana ehaeai ena habuni epore e'imare 'imare. ");
INSERT INTO rro_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Hau rua ia kipokia te'abi'abi, Mose mai Elia. ");
INSERT INTO rro_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Mai nuabikia tewaira tina Iesu kipokia Tirama ena nuatae ihobonai Ierusalemai ke'ari hauna terobahu aina. ");
INSERT INTO rro_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petero 'abana kipokia hanona teparua 'ari ba teno'a, Iesu nuabina mai hau rua herenai tekoroti haukia abomo teihanakia. ");
INSERT INTO rro_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Hau rua Iesu aba katehabona aonai, Petero ehore Iesu ehina bena etibaha, “Poki haumu e, aika neia nahamiaho hanona enamo ki'a baha! Ai i'aua aihau katababainakia, ha oi 'eumu, ha Mose 'euna, ha Elia 'euna.” Ia hanona a'i e'iobina paunai e'abi 'abaea. ");
INSERT INTO rro_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ia ni'abi ohomo aonai 'auhao emai ikoinai ekaiabunakia, ba ia 'auhao aonai hanona teta'u ki'a. ");
INSERT INTO rro_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Aia ha 'auhao aonai emai etibaha, “Neiana hanona Au Naha'u, atina'ana hauna, aiana katona.” ");
INSERT INTO rro_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Aia weiana epua murinai Iesu ikupaiana teihana. I'abana haukia 'abi ha a'i tehina 'apuana, abomo taba teihanakia haukia rani weianai hanona hau ha a'i tehina bena. ");
INSERT INTO rro_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Erani ia oeoai teriri Iesu maearima bo'ona kipokia tebaitabu ahi. ");
INSERT INTO rro_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Hau ha maearima baiatakiai eio etibaha, “Ba'iobi haumu e, au oi nanoini'o, naha'u neiana moihana, naha'u hamomona mo neiana. ");
INSERT INTO rro_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Rani baika auba ha miori neiana nia'ina, beronai neio, niba'ororo abuna, pinanai 'uto'uto tikarahi, a'i nihabona keaomo hauna nimani'a obo. ");
INSERT INTO rro_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Au ti'abani'o haukia anoinakia auba ki'a obona kateu'u ahina, ba ia a'i etainakia.” ");
INSERT INTO rro_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Iesu ehina benakia etibaha, “A'ikakauma aha'i mai ki'a babai uruna haumi, heremiai kamiaho keaomo aita? Nahumu omaiaina here'u.” ");
INSERT INTO rro_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Miori eka'a haha aonai biriua ki'a obona ehore miori 'anoai e'atiaina eba'ororo abuna, Iesu ehore auba ki'a obona ebatana ba miori ebamaurina, eaoaina hamana ebena. ");
INSERT INTO rro_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Tirama ena hiabu rarina 'akinai maearima ikoikiai teta'u ta'u huri. Ia Iesu taba ebabaina hauna tiaonamoai ohona aonai i'abana haukia ehina benakia etibaha, ");
INSERT INTO rro_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“'Abi tabana heremiai aba kahinana hauna tomobahuai haraina. Maearima Nahuna hanona hinahinana katehina maearima herekiai.” ");
INSERT INTO rro_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","'A ia ena 'abi neiana anina a'i te'iobina. Ia herekiai taba e'uahina hauna ebuni buonai obona a'i teobo, ba katebakaina hanona teta'u. ");
INSERT INTO rro_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Rani ha i'abana haukia kipokia mo baiatakiai tebaihara tae tai hanona keapa'ua ki'a baha. ");
INSERT INTO rro_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Iesu ekia raona weiana e'iobina buonai miori papana ha emaiaina herenai ebakorotina. ");
INSERT INTO rro_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ba ehina benakia etibaha, “Tai ha au ata'uai miori papana neiana nia'i taeana hauna hanona au nia'i taeana'u, au nia'i taeana'u hauna hanona euhuna'u Tirama abomo nia'i taeana. Wai ikoimiai baiatamiai ha eko'i ko'i ki'a baha hauna ia hanona keapa'ua ki'a baha.” ");
INSERT INTO rro_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ioane Iesu ehina bena etibaha, “Poki haumu e, ai hau ha taihana oi atamuai auba ki'a obokia eu'u ahinakia. Ba ai tahina bena kebapuana pokina ia hanona aika 'abaka aha'i.” ");
INSERT INTO rro_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Iesu ehina benakia etibaha, “A'i patoba'orona, pokina a'i ni'oatanimi hauna hanona wai 'abami.” ");
INSERT INTO rro_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Iesu kemue kupa keao ranina ekaibari aonai ia aona ebataburana emikiri Ierusalema keao. ");
INSERT INTO rro_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ba iuhubeau haukia euhu 'uainakia teao Samaria aiarana ha aonai taba ikoikiai kateba'orunakia. ");
INSERT INTO rro_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","'A maearima weia haukia a'i tea'i taeana, pokina ia te'iobina Iesu hanona Ierusalema niao. ");
INSERT INTO rro_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","I'abana haukia Iakobo mai Ioane babai weiana teihana raninai tebakaina tetibaha, “Obiapaka e, nonuatae iruba kupai kataparina, keriri keba'ara koukounakia, u?” ");
INSERT INTO rro_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","'A Iesu ekabe terarua erikenakia, ");
INSERT INTO rro_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ba ia teao aiara haeai ha. ");
INSERT INTO rro_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ia taearai teka'a aonai hau ha Iesu ehina bena etibaha, “Au oi aeana nuao hanona murimuai ka'au.” ");
INSERT INTO rro_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","'A Iesu ia ehina bena etibaha, “Waeha 'aki hanona mai ekia 'uri, 'ubi roborobokia abomo mai ekia ni'i, ia Maearima Nahuna kenoti kearai hanona 'ekana aha'i.” ");
INSERT INTO rro_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Haeamona Iesu hau ha ehina bena etibaha, “Muri'uai mo'au.” 'A hau weiana e'abi etibaha, “Obiapaka e, maeao hama'u mahore 'uaina.” ");
INSERT INTO rro_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Iesu ia ehina bena etibaha, “Ti'ari haukia ekia 'ari temehorena, 'a oi moao Tirama ena obia aiarana pouna koiroro aina.” ");
INSERT INTO rro_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Haeamona hau mo ha e'abi etibaha, “Obiapaka e, au murimuai ka'au, ia maeao 'uai e'u rama haukia herekiai haparua mahinana.” ");
INSERT INTO rro_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Iesu ena 'abi ebamuena etibaha, “Hau ha 'ani ihiuana imanai nia'ina, 'a keiha kabe to'o baihana hauna hanona Tirama ena obia aiarana akana kebabaina hanona a'i ketaina.” ");
INSERT INTO rro_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Neiana murinai Obiapaka ehore haukia imabui haraurua rua etina'anakia, ikoikiai baiatakiai rua rua euhunakia kate'uai kateao ia kipona keao aiarakia mai 'ekakia ikoikiai. ");
INSERT INTO rro_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ehina benakia etibaha, “Umai aniani aba ebo'o harai ia aka haukia mo a'i ebo'o, ua buonai uma poki hauna katonoina, ia kehore aka haukia keuhunakia ena umai kateaka. ");
INSERT INTO rro_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Tomoao! Au wai nauhu ahinimi ihobona mamoe nahukia 'abakia, waeha 'aki baiatakiai. ");
INSERT INTO rro_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mahoa ihiua hiua, pute 'ao tamaka ha a'i katoa'i. Taearai abomo maearima ha kipokia a'i katokikipa. ");
INSERT INTO rro_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Itu tabanai katokara'au, katohina 'uaina 'abina hauna neiana, ‘Baibua hanona itu neianai!’ ");
INSERT INTO rro_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Hau weiana aona kebaibua raninai, wai emi baibua hanona ia ahanai kemiaho. Ia keaha'i raninai emi baibua hanona kemue heremi. ");
INSERT INTO rro_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kipokia itu weianai katomiaho oioi, taba tibaibeni haukia katoani 'ao katoinu, pokina aka hauna mai 'arana hanona enamo. Itu ha ha a'i katoao. ");
INSERT INTO rro_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Aiara tabana aonai katokatoto, katea'i taeanimi raninai wairamiai taba tekaitina hauna katoana, ");
INSERT INTO rro_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","aiara weianai inawa haukia katoba maurinakia, abomo katohina benakia, katotibaha, ‘Tirama ena obia aiarana hanona aba nimai heremi.’ ");
INSERT INTO rro_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ia aiara ha aonai katokatoto, a'i katea'i taeanimi raninai katokarahi taearanai kato'abi katotibaha, ");
INSERT INTO rro_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Emi aiara apurorona weiana etau to'ona 'apumaiai hauna aba ṯatabu tabu obona niwahi heremi. Weia kato'iobina Tirama ena obia aiarana aba herekai.’ ");
INSERT INTO rro_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Au wai nahina benimi, bakai berauranai Sodoma ena haiara ma kenamo 'apua ba aiara weiana ena haiara keapa'ua. ");
INSERT INTO rro_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Korasina e! Heremuai hanona keki'a wairai. Betesaida e! Oi abomo heremuai hanona keki'a wairai. Ba ta'u ta'u huri akakia neiakia heremi ai ababai haukia weia Turo mai Sidono aokiai pababai raninai, aba wa'i baha pateraona kabe, habuni ki'a obokia patebatotonakia rabuai pateata patemiati. ");
INSERT INTO rro_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Bakai berauranai Turo mai Sidono ekia haiara ma kenamo 'apua ba wai 'eumi keapa'ua. ");
INSERT INTO rro_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kaperanauma e! Oi abomu mo. Kipomu pokara'au poao kupa ubinai ṉa nuhoma. Ia aha'i. Oi hanona katetori oboni'o koriri 'ari 'ekana.” ");
INSERT INTO rro_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Iesu i'abana haukia ehina benakia etibaha, “Wai aiami niona hauna au aia'u abomo aba niona, wai nibaki'animi hauna au abomo nibaki'ana'u, ia au nibaki'ana'u hauna euhuna'u hauna abomo nibaki'ana.” ");
INSERT INTO rro_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Haukia imabui haraurua rua teao haeamona mai aonamokia temue herena te'abi tetibaha, “Obiapaka e, oi atamuai auba ki'a obokia tau'u ahinakia hanona aiamai teona.” ");
INSERT INTO rro_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Iesu ia ehina benakia etibaha, “Au Satani kupai e'eho hanona aihana matoha 'imare 'abana. ");
INSERT INTO rro_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Au hiabu wai aba abenimi, 'erau 'ao hara katoehe 'ininakia abomo 'ou hauna ena hiabu ikoinai katotara haona, taba ha a'i kebamani'animi. ");
INSERT INTO rro_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Auba ki'a obokia aiami teona paunai a'i katoaonamo, 'a atami kupai aba terere hauna katoaonamo aina.” ");
INSERT INTO rro_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Rani weianai Iesu Auba Robe paunai aona enamo ki'a e'abi etibaha, “Hama'u e, kupa mai hanopaka Obiana nabanamoni'o, pokina taba neiakia aotipa mai aobero haukia herekiai obuninakia haukia miori papakia herekiai obawaira tinana. 'E, hama'u, pokina neiana hanona oi emu raona namona. ");
INSERT INTO rro_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Taba ikoinai hanona Hama'u aba ebaibeni here'uai, Nahuna hauna tai ha a'i e'iobina ia Hamana ikupaianamo, Hamana hauna tai ha a'i e'iobina Nahuna mai nahuna nenuatae ainakia herekiai kebawaira tinana haukia ikupaiakia mo.” ");
INSERT INTO rro_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Weiana Iesu eiha kabe i'abana haukia ehinabe buninakia etibaha, “Taba neiakia ṯoihanakia haumi hanona tutai harai ṯoiha tinanakia. ");
INSERT INTO rro_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Pokina au wai nahina benimi, mahabanai haukia mai aiara obiakia bo'okia tenuatae wai ṯoiha haukia pateiha ia a'i teiha, tuo'o haukia pateo'o ia a'i teo'o.” ");
INSERT INTO rro_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Weia rauhubu poki hauna ha emikiri Iesu ehobona etibaha, “Ba'iobi haumu e, taba kababaina hanona mauri banaibanai ka'ina?” ");
INSERT INTO rro_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Iesu ia ena 'abi ebamuena etibaha, “Rauhubu pukana aonai aea terere aihona? Aea o'iobi aihona?” ");
INSERT INTO rro_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ia ena 'abi ebamuena etibaha, “Obiapaka emu Tirama koraona'au aina mai aomu ikoinai, mai aubamu ikoinai, mai taburamu ikoinai, mai emu raona ikoinai, abomo heremu hauna koraona'au aina oi kipomu nuraona'au aini'o 'abana.” ");
INSERT INTO rro_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Iesu ia ena 'abi ebamuena etibaha, “Emu 'abi hanona ebero, ṉa kobabai aiho hanona komauri.” ");
INSERT INTO rro_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Rauhubu poki hauna kipona eapaina ebakai bakai etibaha, “Ba here'u hauna hanona tai?” ");
INSERT INTO rro_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Iesu ia ena 'abi ebamuena etibaha, “Hau ha Ierusalema ai eriri Ieriko eao aonai kakikaki haukia tehe abuna, ena habuni tebakurinakia teahu ki'ana herekai mo pe'ari ba tehabona. ");
INSERT INTO rro_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Rani weianai Robe hauna ha taeara weianai eka'a eao, eihana raninai taeara haia haianai ekabanai. ");
INSERT INTO rro_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ihobonaimo Lebi itubuna hauna ha taeara weianai eao, eihana raninai taeara haia haianai ekabanai. ");
INSERT INTO rro_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","'A Samaria hauna ha ena kaoao ai hau weiana herenai ekara'au, eihana raninai eaoko'o aina. ");
INSERT INTO rro_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Eao herena hauna mani'akia tehoro mai bine beinai etaronakia e'apanakia. Ba ena doniki ahanai ebamia'auna, eaoaina iha'ini itunai ua'a e'imana. ");
INSERT INTO rro_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Erani hau weiana ehore moni rua etara 'aunakia itu iha'inina hauna ebena ehina bena etibaha, ‘Ko'ima haraina, herenai bita kone'e hanona e'u mueai 'arakia kabeni'o.’” ");
INSERT INTO rro_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Iesu ia ebakaina etibaha, “Oi taba ṉa nuhoma? Hau weiakia teaihau aonai aeana hauna kakikaki haukia imakiai enouta hauna herena haunai ebaona?” ");
INSERT INTO rro_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ia etibaha, “Weiana eaoko'o aina hauna.” Iesu ia ehina bena etibaha, “Moao ebabaina ihobona mo kobabaina.” ");
INSERT INTO rro_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Iesu i'abana haukia kipokia taearai teao aiara haeai tekara'au, weia babi'e ha atana Mareta ehore ea'i taeana ena ituai. ");
INSERT INTO rro_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ia hatina atana Maria hanona eao Obiapaka aena pokinai emiati ena ba'iobi 'abikia aiakia nio'o. ");
INSERT INTO rro_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","'A Mareta baki ia'i taeakia a'i a'i haraina ebabaina hanona aona earo'ari, ba emikiri eao Iesu ehina bena etibaha, “Obiapaka e, oi a'i nuraonana hati'u naiana ehabona'u kipo'u aka ikoinai nababai. Mohina bena mebaraina'u.” ");
INSERT INTO rro_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Obiapaka ia ena 'abi ebamuena etibaha, “Mareta e, Mareta e, oi hanona aomu niaro'ari taba bo'okia paukiai nuatetua, ");
INSERT INTO rro_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ia taba hamona mo nahanuataeai hauna Maria aba enuatae aina, ia herenai a'i katea'i pare 'apuana.” ");
INSERT INTO rro_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Rani ha Iesu 'eka ha ai ebahuba'ari, ena bahuba'ari epua murinai i'abana haukia ha ehore ehina bena etibaha, “Obiapaka e, bahuba'ari moba'iobinamai Ioane i'abana haukia eba'iobinakia 'abana.” ");
INSERT INTO rro_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ba Iesu ia ehina benakia etibaha, “Katobahuba'ari raninai ṉa kato'abi aiho. ‘Hamamai e. Oi atamu hanona katabarobena. Emu obia aiarana kemai. ");
INSERT INTO rro_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Rani ikoinai ṯanuatae aina anianina kobenamai. ");
INSERT INTO rro_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Emai ki'a kohina haonakia, pokina ai tibaki'anamai haukia ekia ki'a ṯahina haonakia. Abomo baihobo aonai a'i kobakatotonamai.’” ");
INSERT INTO rro_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ia haeamona ehina benakia etibaha, “Wai haumi ha wapuka'a ibuanai peao ena hau ena ituai penoina petibaha, ‘E'u hau e, parawa aihau mo pobena'u. ");
INSERT INTO rro_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Pokina e'u hau ha ena kaoao aonai emai here'u, karo'ona ia aniani mo here'u aha'i.’ ");
INSERT INTO rro_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Aonai ua'a ke'abi ketibaha, ‘A'i kobaro'arina'u, pa'abi hanona aba ikaiabu abomo au naha'u kipokia hanona ṯaparua. A'i kamikiri taba ha a'i kabeni'o.’ ");
INSERT INTO rro_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Au wai nahina benimi, ena hau paunai ia a'i kemikiri taba ha a'i kebena, 'a ia ena noi 'ariai 'ariai paunai kemikiri, ia nenuataeai tabakia ikoikiai kebena. ");
INSERT INTO rro_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Haeamona au wai nahina benimi, katonoi hanona katoa'ina, katotabuna hanona katotabu ahina, katohara hara hanona pa'abi ikaikau 'eumi. ");
INSERT INTO rro_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Weiakia tinoiai haukia hanona tia'i, weiakia tibaitabu haukia hanona titabu ahi, nihara hara hauna 'eunai pa'abi hanona ikaikau. ");
INSERT INTO rro_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Wai hama haumi ha nahumu maia penoi raninai 'erau pobena, u? ");
INSERT INTO rro_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","'Ao ahoi penoi raninai hara pobena, u? ");
INSERT INTO rro_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Wai ki'a haumi re'a, taba namokia nahumi ibenikia ṯo'iobi. Namo babita Hamami kupai nemiaho hauna Auba Robe tinoi noi aina haukia kebenakia.” ");
INSERT INTO rro_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Iesu ehore 'aiaunu paipaina hau ha aonai eu'u ahina, paipai weiana ekarahi ba e'aiaunu hauna e'abi'abi, teihana haukia teta'u ta'u huri. ");
INSERT INTO rro_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ia maearima baika te'abi tetibaha, “Belesebulo paipai ekia obia arana ena hiabuai ia paipai neiakia eu'u ahinakia.” ");
INSERT INTO rro_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Baika Iesu tehobona ekia nuatae kupa ena hoa ha pebabaina pateihana. ");
INSERT INTO rro_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ia Iesu hanona ekia raona e'iobina, ba ehina benakia etibaha, “Hanopaka kipona niwatena ba nibai'oata hanona keki'a, abomo itubu kipona niwatena ba nibai'oata hanona ke'eho. ");
INSERT INTO rro_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Satani kipona kewatena ba kipona ke'oatana raninai, ena hanopaka aea kekori 'ini aiho? Neiana nahinana pokina wai tu'abi ‘Belesebulo ena hiabuai paipai au'u ahinakia.’ ");
INSERT INTO rro_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Au Belesebulo ena hiabuai paipai nau'u ahinakia raninai, tai ena hiabuai wai i'abami haukia tihore paipai ṯeu'u ahinakia? Ua buonai ia katehore wai kateba beronimi. ");
INSERT INTO rro_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ia au Tirama ena hiabuai paipai au'u ahinakia raninai, Tirama ena obia aiarana aba ekara'au heremi. ");
INSERT INTO rro_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Tabura hauna mai ena pura'a ena itu ke'imana hanona ena kohu ikoikiai katemiaho harai. ");
INSERT INTO rro_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","'A etabura ki'a hauna ha ia pehuari bena ba peahuna raninai, ena pura'a imanai kea'i obonakia ena kohu ikoikiai kewate otaraina. ");
INSERT INTO rro_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Tai'u a'i nitai hauna hanona au ni'oatana'u, au kipokia a'i ṯabararo bararo hauna hanona nikapo kapo otarainakia. ");
INSERT INTO rro_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Auba ki'a obona ha hau ha aonai nikarahi raninai, 'eka 'ororokia 'ekakiai nikaoao, ena nuatae kearai ia 'eka mo ha aha'i. Kipona ni'abi netibaha, ‘Kamue kaeao amiaho 'uai ituna.’ ");
INSERT INTO rro_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ba emue eao itu hanona aba itaro abomo aba e'oru harai etabu ahina. ");
INSERT INTO rro_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Weiana ia eao auba ki'a obokia 'akikia 'abaihau hamomo ebaka'anakia, ba teao tetoto weia temiaho, hau weiana ena mauri 'uainai papana enamo, 'a bariu ena mauri aba eki'a ki'a baha.” ");
INSERT INTO rro_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Iesu 'abi neiakia nehinanakia aonai babi'e ha mako baiatakiai Iesu eiona etibaha, “Oi ebaramani'o mai oi eba'aeni'o babi'ena hanona enamo.” ");
INSERT INTO rro_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","'A Iesu ena 'abi ebamuena etibaha, “Ua a'i kehoma, ia Tirama ena 'abi tiona abomo ṯe'ini bena haukia tenamo ki'a baha.” ");
INSERT INTO rro_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Maearima Iesu teto'u aina aonai, ena 'abi ea'i ramana etibaha, “Uru neiana hanona uru ki'a obona, bata'u ta'u huri hoakia nitabu, ia ha a'i kerama herekiai, Iona ikupaiana mo bata'u ta'u huri hoanai keao. ");
INSERT INTO rro_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Iona hanona bata'u ta'u huri hoanai eao Nineba haukia herekiai ihobona mo Maearima Nahuna hanona uru neiana herenai. ");
INSERT INTO rro_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Bakai ranina aonai obia babi'ena Seba kemikiri uru neiana haukia behoai kehorotinakia, pokina ia hanona hanopaka puanai emai Solomona ena aotipa 'abikia keo'o, ia bariu ha neia hanona Solomona etara haona. ");
INSERT INTO rro_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Bakai ranina aonai Nineba haukia hanona katemikiri uru neiana haukia behoai katehorotinakia pokina Iona ena iroroai teraona kabe, ia bariu ha neia hanona Iona etara haona. ");
INSERT INTO rro_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Hau ha ramepa keba'arana raninai itu bunianai 'ao uro aonai a'i kekai tina, ia ramepa ihao 'auna 'ekana tohanai kehao 'auna ba weia titoto haukia hanona ea weiana kateihana. ");
INSERT INTO rro_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Oi mahamu hanona hauanimu ena ramepa, ba oi mahamu enamo raninai hauanimu maikoina abomo ea aonai, ia mahamu keki'a raninai hauanimu maikoina hanona wapura aonai. ");
INSERT INTO rro_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ua buonai ko'ima 'ima haraini'o ea aomuai hauna a'i mewapura abuna ta'una. ");
INSERT INTO rro_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Oi hauanimu maikoinai niea obo papana ha wapura aonai aha'i raninai, maikoina hanona kea obo harai matoha ramepa eana maikoina nibeni'o nibaeani'o 'abana.” ");
INSERT INTO rro_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Iesu e'abi nonoa raninai, Parisea hauna ha ia enoina terarua kateaniani haeamo buonai ia etoto eao emiati keaniani. ");
INSERT INTO rro_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Parisea hauna Iesu eihana hanona eta'u ta'u huri, pokina aniani raninai imana a'i eutu. ");
INSERT INTO rro_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Weiana Obiapaka ia ehina bena etibaha, “Bariu wai Parisea haumi hanona 'ere mai uro kapekia mo ṯoutu harainakia, 'a ia aomi hanona bainao mai ki'a ebonu 'au. ");
INSERT INTO rro_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Po'o po'o haumi, ia kapena ebabaina hauna, aona abomo a'i ebabaina, u? ");
INSERT INTO rro_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ia aonai ṯemiaho tabakia uraru haukia katobenakia. Ba taba ikoikiai aba terau'a wai 'eumiai. ");
INSERT INTO rro_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Parisea haumi e, heremiai hanona keki'a wairai! Pokina emi aniani iba'orimokia mai ibahiabu hiabukia papakia tubahunakia harauhaea aonai hamomona tubaibeni Tirama herenai, 'a Tirama herenai bero mai raona'au pato babaina hauna tohabona. 'A neiana abomo katobabaina, ia weiana abomo a'i katohabona. ");
INSERT INTO rro_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Parisea haumi e, heremiai hanona keki'a wairai! Pokina emi nuatae hanona marea aonai miati 'ekakia namokiai katomiati, abomo kawakawa 'ekakiai katemariki ainimi katebanamonimi. ");
INSERT INTO rro_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","‘Heremiai keki'a ki'a baha! Pokina wai hanona ihobona 'ariahakia 'ai'aikia 'akikia, maearima a'i te'iobina ahakiai tiaoaina timaiaina Tirama wairanai aba te'opu.’” ");
INSERT INTO rro_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Rauhubu poki hauna ha ia ehina bena etibaha, “Ba'iobi haumu e, oi ṉa nu'abi aiho hanona ai abomo nubahaumaenamai.” ");
INSERT INTO rro_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","'A ia etibaha, “Rauhubu poki haumi e, heremiai hanona keki'a ki'a baha! Wai maearima iebebe pumakia tubabuanakia, 'a wai kipomi ha iebebe weiana ena puma aea homana imami kiri'u kiri'una hamona a'i ni'ata 'apuana. ");
INSERT INTO rro_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Heremiai keki'a wairai! Wai hamami mahabanai haukia teahu 'arinakia, ba wai tuhore ekia 'ariahakia tubabainakia. ");
INSERT INTO rro_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ua buonai wai hamami ekia babai tubatoha akakia tubaihanakia, pokina ia teahu 'arinakia, wai hanona ekia 'ariahakia tubabainakia. ");
INSERT INTO rro_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Ua paunai Tirama ena 'iobi 'abina etibaha, 'Au mahabanai haukia mai iuhubeau haukia kauhunakia kateao, baika hanona kateahu 'arinakia, baika katebaki'anakia. ");
INSERT INTO rro_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Weiana paunai hanopaka erama emai mo bariu mahabanai haukia ikoikiai aruarukia tekiki oioi, pumana hanona uru neiana haukia katehoaina. ");
INSERT INTO rro_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abela aruarunai ea'i ramana emai mo Sakaria aruarunai, ia hanona banamo itarana mai marea robena baiatakiai teahu 'arina. 'E, au wai nahina benimi, pumana hanona uru neiana haukia katehoaina. ");
INSERT INTO rro_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Rauhubu poki haumi e, heremiai hanona keki'a wairai! Pokina aotipa taearana aba tokaiabuna, wai kipomi a'i katototo, katetoto haukia ekia taeara abomo toehe abuna.” ");
INSERT INTO rro_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Iesu 'eka weiana nihabona raninai, rauhubu poki haukia mai Parisea haukia te'oatana, ekia bakaibakai haeai haeai tehina herenai. ");
INSERT INTO rro_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ena 'abi te'itimana, ha kehina ki'ana raninai katebato'ona. ");
INSERT INTO rro_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Rani weianai maearima bo'ona 'akina tebaehe aina, 'a Iesu i'abana haukia eba'iobi 'uainakia etibaha, “Parisea haukia ekia bai'oi akana herenai Kato'ima 'ima harainimi weiana hanona bakupu muramurana 'abana. ");
INSERT INTO rro_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","'A tebahu abunakia tabakia ikoikiai katekarahi abomo tehore buninakia tabakia ikoikiai kate'iobi. ");
INSERT INTO rro_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Wapura aonai taba ohinana hauna beraura eanai kateona abomo ikaihuri aonai haianai obatete aina hauna itu kapenai kateiroro aina. ");
INSERT INTO rro_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“E'u hau e, au wai nahina benimi. Hauani iahu'arina mo te'iobina ia murinai taba ha ahanai a'i katebabai muena haukia a'i katota'u ainakia. ");
INSERT INTO rro_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ia katota'u aina hauna au kahore kaba'iobinimi. Ia hanona hauanimi keahu 'arina murinai mai ena hiabu ni'ara banai banai irubana aonai kekapo 'aunimi hauna Tiramana katota'u aina. ");
INSERT INTO rro_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Komure ima pahakawanakia 'arakia toea rua mo. 'A Tirama hanona weiakia ha a'i ereana. ");
INSERT INTO rro_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","'Abi tohana, bui bita aramiai haukia aba etuabi orenakia. A'i katota'u, wai hanona komure bo'okia aba totara haonakia. ");
INSERT INTO rro_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Au wai nahina benimi. Hau ha au pou'u kehinana maearima wairakiai, Maearima Nahuna abomo Tirama ena aneru wairakiai ia pouna kehinana. ");
INSERT INTO rro_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","'A maearima wairakiai au kebuniaina'u hauna abomo Tirama ena aneru wairakiai au ia kabuniaina. ");
INSERT INTO rro_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Hau ha Maearima Nahuna herenai ke'abi ki'a hanona aba kehina haona ia hau ha Auba Robe herenai ke'abi ki'a hanona a'i kehina haona. ");
INSERT INTO rro_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Kateaoainimi marea obiakia rauhubu mai hiabu haukia wairakiai raninai, aomu a'i kearo 'ari ekia 'abi aea kobamue aihona 'ao oi aea ko'abi aiho. ");
INSERT INTO rro_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Pokina rani weianai Auba Robe kehore oi taba ko'uahina hauna aba keba'iobini'o.” ");
INSERT INTO rro_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","To'u aonai hau ha Iesu ehina bena etibaha, “Ba'iobi haumu e. A'a'u mohina bena emai kohu hamamai e'ari boinakia haukia tararua baiatamai ai mewatenakia.” ");
INSERT INTO rro_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Iesu ia ena 'abi ebamuena etibaha, “Hau e, tai au ea'i taeana'u emi bakai kababaina abomo emi kohu kawatenakia?” ");
INSERT INTO rro_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ba maearima ehina benakia etibaha, “Kato'inibeni harainimi kohu a'i katouhoreai ki'a baha, pokina maearima ena mauri tohana hanona ena kohu bo'onai a'i nimai.” ");
INSERT INTO rro_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Iesu 'abi ibabatai ha ehina benakia. “Herenai kepu ebo'o hauna ha ena hanoai uma anikia bo'ona etabu ahinakia. ");
INSERT INTO rro_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ba kipona aonai eraona raona etibaha, ‘Taba kababaina? 'Eka aha'i, 'eka tabanai e'u ube kahorotinakia.’ ");
INSERT INTO rro_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Haeamona etibaha, ‘Ṉa kababai aiho, paraboa 'ai'aina karubuna apa'uana ha mahamahana kababaina, ba e'u biraura aniani ubekia mai e'u kohu ikoikiai weia kahorotinakia. ");
INSERT INTO rro_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Au kipo'u ka'abi katibaha, “Au hanona taba namokia here'u aba ebo'o harai aro'anakia ihau bo'okia 'eukia. Bariu karai kaniani kainuinu kaonamo harai.” ’ ");
INSERT INTO rro_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","'A Tirama ehore ehina bena etibaha, ‘Po'o haumu e! Bariu rabi neianai au oi emu mauri ka'i obona raninai naiakia oro'anakia haukia hanona tai kea'inakia?’” ");
INSERT INTO rro_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ba Iesu ena 'abi orenai etibaha, “Neiana hanona maearima ha kipona ena taba nibararonakia ia kipona 'euna, ia Tirama wairai hanona ena ibararo a'i ebo'o.” ");
INSERT INTO rro_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ba Iesu i'abana haukia ehina benakia etibaha, “Weiana buonai au wai nahina benimi. Emi mauri paunai taba patoana 'ao haumiai taba patobatotona hauna aomi a'i kebaro 'arina. ");
INSERT INTO rro_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Pokina mauri hanona eapa'ua ba aniani hauani abomo eapa'ua ba habuni. ");
INSERT INTO rro_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","'Aokakara katoraonanakia. Aniani a'i tibato 'ao eueu berauranai aniani a'i tibararo abomo ekia rerea 'ekana aha'i ia Tirama akia nibenakia. Ia wai hanona roborobo totara haonakia. ");
INSERT INTO rro_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Oi tai ha emu ao aro'ariai haumu papana pebahoma'ana hanona petaina, 'ao? ");
INSERT INTO rro_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Weiana taba papakia neiakia ibabaikia a'i to'iobi raninai aehoma buonai taba haeai haeai aomi tibaro 'arinakia. ");
INSERT INTO rro_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Bebetu ti'omu hanona katoihanakia. Kipokia habuni akana a'i tibabaina. Ia au wai nahina benimi. Solomona obia arana ena habuni tenuabi ki'a, iamo bebetu neiana hanona enamo ki'a baha ba Solomona ena habuni. ");
INSERT INTO rro_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Tirama kipona hano tubukia nibataitainakia bariu timauri mara kate'ororo irubai kahakapo 'aunakia kate'ara. Tirama ehore ua nibataitai aihonakia, ia wai habuni a'i nibabatotonimi, u? A'ikakauma papana haumi. ");
INSERT INTO rro_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Aomi taba patoana mai patoinu hauna a'i katotabuna, weiakia aomi a'i katebaro 'arina. ");
INSERT INTO rro_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Hanopaka neiana aonai Tirama a'i tia'ikakaumana haukia ikoikiai taba neiakia titabunakia, ia Hamami kupai hauna taba neiakia ṯonuatae ainakia ikoikiai aba e'iobinakia. ");
INSERT INTO rro_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Tirama ena obia aiarana katotabu 'uaina hanona neiakia ikoikiai wai kebenimi.” ");
INSERT INTO rro_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“To'u papana haumi e. A'i katota'u, pokina Hamami mai aonamona ena aiara kebenimi. ");
INSERT INTO rro_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Emi kohu katokawa kawainakia monikia uraru haukia katobenakia, a'i neki'a 'apua mahoa ihiua ihiuana katoba'oruna 'eumi, kupa kepuna a'i niore 'apua hauna katoa'ina. Bainao ha weia a'i niao abomo muhi taba weia ha a'i tia'i ki'ana. ");
INSERT INTO rro_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Pokina emi kepu nemiaho 'ekana hanona wai aomi abomo weia.” ");
INSERT INTO rro_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Emi habuni katohai 'ininakia abomo emi ramepa hanona katoba'aranakia katobai'ima. ");
INSERT INTO rro_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Wai hanona ihobona bai'ima haukia 'abakia, ekia poki hauna hawainibe mahamaha 'ekanai kemue kemai ṯe'imana. Ba kemai pa'abi kehara harana raninai pa'abi beronai mo katekaikauna. ");
INSERT INTO rro_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ta'ara a'i haukia tibai'ima oho aonai ekia poki hauna kemai ketabu ahinakia hanona enamo. 'Abi tohana au wai nahina benimi. Poki hauna kipona ena habuni kehai 'inina ekia aniani 'ekanai kebamiatinakia, kero'onakia ekia aka kebabaina. ");
INSERT INTO rro_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Rabi wapuka'a 'ao kokoro'u ti'arara aonai ta'ara a'i haukia tibai'ima oho aonai ekia poki hauna ketabu ahinakia hanona tenamo. ");
INSERT INTO rro_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Neiana kato'iobi haraina. Itu poki hauna bainao hauna ena mai ranina ke'iobi 'uaina raninai ena itu ke'imana a'i kepa'a. ");
INSERT INTO rro_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Wai abomo katoba'oru, pokina a'i to'iobina rani tabanai Maearima Nahuna kemai.” ");
INSERT INTO rro_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petero Iesu ebakaina etibaha, “Obiapaka e, 'abi ibabatai neiana ai ikupaiamai heremai ai nohinana 'ao maearima ikoikiai abomo?” ");
INSERT INTO rro_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Obiapaka e'abi etibaha, “Tai aia iona mai ao bero hauna, ia ena poki hauna hiabu ebena ena itu kohukia keiha 'ini, weia ta'ara a'i haukia ekia aniani beraurakia tohakiai kebenakia? ");
INSERT INTO rro_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","'Ima'ima hauna weiana ena poki hauna ena mueai ua niaka harai aiho ketabu ahina hanona enamo. ");
INSERT INTO rro_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","'Abi tohana au wai nahina benimi. Poki hauna kehore 'ima hauna kebapokina ena kohu ikoikiai ke'imanakia. ");
INSERT INTO rro_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ia 'ima'ima hauna kipona ke'abi ketibaha, “E'u poki hauna a'i kemai baha,” ba ia kehore ta'ara a'i haukia mai babi'ekia ke'atinakia keani ani keinu inu keinu 'ari. ");
INSERT INTO rro_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Rani ha 'ima'ima hauna a'i eraonana a'i eba'oru aonai ena poki hauna kekara'au hanona ia kekabe kabe hurina, puma kebena matoha aia a'i tiona haukia 'abana. ");
INSERT INTO rro_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“'Ima'ima hauna ena poki hauna ena nuatae akana e'iobina kebabaina ia a'i eba'oru mai a'i ebabainakia, hau weiana hanona i'ati bo'ona katebena. ");
INSERT INTO rro_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","'A 'iobi aha'i hauna ena aka ki'a 'arana hanona kate'atina ia i'ati 'ama'amana katebena. Taba bo'ona tebena hauna herenai taba bo'ona katenuataeai, taba bo'ona ke'imanakia hauna herenai taba bo'ona katenoiai.” ");
INSERT INTO rro_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Au hanona iruba amaiaina hanopaka ahanai, e'u nuatae pe'ara biai. ");
INSERT INTO rro_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Au hanona 'uererobe ha ka'ina weiana kaopuma aina keaomo kabaore haraina. ");
INSERT INTO rro_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Wai turaonana Au amai hanona baibua amaiaina hanopaka, 'u? Au wai nahina benimi, aha'i. Baibua aha'i ia hoa hore. ");
INSERT INTO rro_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Bariu wairaka kahaeaoaina, rama ha aonai haukia ima baiatakiai katehoa hore, aihau katehore rua kate'oatanakia abomo rua katehore aihau kate'oatanakia. ");
INSERT INTO rro_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ia baiatakiai katehoa hore, hama kehore nahu hauna ke'oatana, nahuna kehore hamana ke'oatana, hina kehore nahuna babi'ena ke'oatana, nahu babi'ena kehore hinana ke'oatana, hinana kehore rawana babi'ena ke'oatana, rawa babi'ena kehore hinana ke'oatana.” ");
INSERT INTO rro_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Iesu haeamona to'u haukia ehina benakia etibaha, “Tibotaina tainai 'auhao ha kemikiri katoihana raninai beronai kato'abi katotibaha, ‘Abara ketibo,’ hanona nirama. ");
INSERT INTO rro_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ahitai tibo baurana niabu raninai wai tu'abi ṯotibaha, ‘Beraura kehiabu,’ hanona nirama. ");
INSERT INTO rro_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Bahaorea haumi e. Wai hanopakai mai kupai taba Tirama hanona 'abikia to'iobi, ia aehoma buonai bariu rani neianai nirama hauna 'abina a'i ṯo'iobina? ");
INSERT INTO rro_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Aehoma buonai wai kipomi ibaberomi raonana a'i tubabaina? ");
INSERT INTO rro_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Oi behoai ehorotini'o hauna keaoaini'o bakai 'ekana, a'i niaoai bahani'o bakai 'ekana raninai taeara namona kotabuna torarua emi atetua kobaberona, keaha'i raninai keaoaini'o kebabakaini'o hauna herenai, ba ia kehore keaoaini'o habuni hauna herena, ba habuni hauna wapura 'ekanai kehorotini'o. ");
INSERT INTO rro_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Au wai nahina benimi, weia a'i katokarahi 'apua keaomo 'ara maikoinai katohore orena.” ");
INSERT INTO rro_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Rani weianai baika Iesu haianai Galilea haukia poukia tehinana, ekia ibeni tibabaina Tirama herenai raninai Pilato ena huari haukia euhunakia teahu 'arinakia aruarukia mahi aruarukia kipokia teutena. ");
INSERT INTO rro_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Iesu ekia 'abi ebamuena etibaha, “Pokina Galilea haukia weiakia ua teahu aihonakia, wai turaonana Galilea haukia weiakia te'ari haukia ekia ki'a teapa'ua ki'a baha ba Galilea ṯemiaho haukia ekia ki'a? ");
INSERT INTO rro_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Au wai nahina benimi. Aha'i. Wai a'i katoraona kabe raninai, ikoimiai hanona ua kato'ari aiho. ");
INSERT INTO rro_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Wai turaonana weiakia haukia harauhaea 'ababani Siloama ai itu ro'ena epobu aonai te'ari haukia ekia ki'a teapa'ua ki'a baha ba baika Ierusalema ai ṯemiaho haukia ekia ki'a? ");
INSERT INTO rro_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Au wai nahina benimi. Aha'i. Wai a'i katoraona kabe raninai ikoimiai hanona ua kato'ari aiho.” ");
INSERT INTO rro_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Iesu 'abi ibabatai ha ehinana etibaha, “Hau ha suke matiuna ha ebatona ena bine haharuana aonai, muriai eao buana erarainakia ia ha a'i etabu ahina. ");
INSERT INTO rro_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Weiana ia haharua ne'imana hauna ehina bena etibaha, ‘Ihau aihau nakai mue matiu neiana buana ararainakia, ia ha a'i natabu ahina. Mo'ui rabu taina. Taba buonai hano namona kebaore 'abaeana?’ ");
INSERT INTO rro_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Haharua ne'imana hauna etibaha, ‘E'u poki haumu e. Mohabo 'abaeana ihau neiana hamona memiaho. Au pokina ka'ani kakaiarona kabahuna. ");
INSERT INTO rro_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ihau wairai buana baika katerama hanona enamo, aha'i raninai ia hanona i'ui kea'ina.’” ");
INSERT INTO rro_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Beraura robenai Iesu Iuda haukia ekia marea ha aonai eba'iobi, ");
INSERT INTO rro_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","babi'e ha weia auba ki'a obona ha ehore ebainawana ihauna harauhaea 'ababani kapena ebarara, kipona kebaberona hanona a'i etaina. ");
INSERT INTO rro_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Iesu babi'e weiana eihana raninai eaparina etibaha, “Babi'e e! Aba enamo. Emu inawa aba epua.” ");
INSERT INTO rro_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Weiana Iesu imana babi'e ahanai ehao 'au raninai, beronai kapena ebero, ba emikiri Tirama ebanamona. ");
INSERT INTO rro_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Marea poki hauna eopuere, pokina Iesu beraura robenai ebamauri paunai. Ia maearima ehina benakia etibaha, “Wapu 'abaihau hanona wai emi aka wapukia. Beraura weiakiai katomai kebamaurinimi, ia beraura robenai aha'i.” ");
INSERT INTO rro_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Obiapaka ia ena 'abi ebamuena etibaha, “Wai bahaorea haumi! Wai ha Beraura robenai emi poromakau 'ao emi toniki 'ekakiai a'i ṯorubunakia bei 'urina a'i tuaoainakia, u? ");
INSERT INTO rro_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Babi'e neiana hanona Aberahamo ena itubu babi'ena. Satani ia ebainawana ihauna aba harauhaea 'ababani. Ba Beraura robe aonai ia bamauri a'i pea'ina, u?” ");
INSERT INTO rro_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Iesu ia ena 'abi ua ebamue aihona hanona ti'oatana haukia ikoikiai tehaumaea ki'a, 'a to'u haukia ikoikia teaonamo aka nuabikia weiakia ebabainakia paukiai. ");
INSERT INTO rro_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Iesu ebakai bakai etibaha, “Tirama ena obia aiarana ibabataina taba? Tabai kababataina? ");
INSERT INTO rro_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ia hanona ihobona tuaba uhona papana, weiana hau ha ea'ina ena umai ebatona e'omu matiu rarinai eao renai 'ubi roborobokia ekia ni'i terobenakia.” ");
INSERT INTO rro_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Haeamona e'abi etibaha, “Tirama ena obia aiarana tabai kababataina? ");
INSERT INTO rro_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ia hanona ihobona bakupu muramurana, weiana babi'e ha ea'ina parawa bo'ona uro aonai kipokia euta haeamona, euna eaomo maikoinai ekupu.” ");
INSERT INTO rro_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Iesu ena kaoao Ierusalema taearanai eao aonai, aiara apa'uakia mai papakia aokiai maearima eba'iobinakia. ");
INSERT INTO rro_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Hau ha Iesu ebakaina etibaha, “Obiapaka e! Maearima tebabita 'akimo katemauri, 'ao?” Ia ena 'abi ebamuena etibaha, ");
INSERT INTO rro_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Katotabura katoao pa'abi 'omo'omonai katototo. Pokina au wai nahina benimi, maearima bo'ona katenuatae katetoto ia a'i ketainakia. ");
INSERT INTO rro_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Itu poki hauna kemikiri pa'abi kekaiabuna murinai, wai atapakai katokoroti ba pa'abi katohara harana katotibaha, ‘Obiapaka e, pa'abi mokaikauna tamatoto.’ 'A ia emi 'abi kebamuena ketibaha, ‘Wai ae'eai tomai, au a'i a'iobinimi.’ ");
INSERT INTO rro_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ba wai kato'abi katotibaha, ‘Ai oi kipokia hanona haniani mai hainuinu haeamo, abomo emai aiarai oba'iobi.’ ");
INSERT INTO rro_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","'A ia ketibaha, ‘Wai ae'eai tomai, au a'i a'iobinimi, ki'a ibabaina haumi ikoimiai tomokatu'a here'uai.’ ");
INSERT INTO rro_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Weia mahami keao Aberahamo, Isako, Iakobo mai mahabanai haukia ikoikiai Tirama ena obia aiaranai katoihanakia, ia wai aba katetori ahinimi atapakai raninai, wai hanona katohai 'aki 'akimi katoarao'i arao'i. ");
INSERT INTO rro_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Maearima hanona taetanai tibo tainai mai toto tainai ahi tainai katemai tatu 'ekanai katemiati Tirama ena obia aiarana aonai. ");
INSERT INTO rro_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ba baika ṯemurihai haukia hanona kate'uai, ia baika ṯe'uai haukia hanona katemurihai.” ");
INSERT INTO rro_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Rani weianai Parisea haukia baika temai Iesu herena tehina bena tetibaha, “'Eka neiana kohabona koao 'eka haeai, pokina Heroda nenuatae keahu 'arini'o.” ");
INSERT INTO rro_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Iesu ekia 'abi ebamuena etibaha, “Tomoao, waeha 'aki weiana katohina bena. Au bariu mara hanona auba ki'a obokia nau'u ahinakia mai inawa haukia nabanamonakia, ba rani ibaihaunai e'u aka maikoinai kabaorena. ");
INSERT INTO rro_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","'A au bariu mara mai erani hanona kaka'a kaeao, pokina mahabanai hauna hanona 'eka haeai a'i ke'ari, ia Ierusalemai mo.” ");
INSERT INTO rro_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Ierusalema e, Ierusalema e, oi ohore mahabanai haukia oahu 'arinakia, abomo Tirama euhunakia haukia piharai oahu 'arinakia. Rani bita au anuatae nahumu ikoinai ka'umu abunakia matoha kokoro'u hina nahuna ne'umu abunakia 'abana, ia wai hanona a'i ṯonuatae aina'u. ");
INSERT INTO rro_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Weiana emu itu hanona ke'aburu. Au wai nahina benimi, a'i katoiha muena'u keaomo rani ha kemai ba katotibaha, ‘Obiapaka atanai nimai hauna hamabanamona.’” ");
INSERT INTO rro_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Beraura robena ha ai Iesu eao Parisea ekia poki hauna ha ena ituai kateaniani haeamo, ba baika hanona ia teiha 'ini haraina. ");
INSERT INTO rro_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Weia bua haiarana hauna ha Iesu wairanai emiati. ");
INSERT INTO rro_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Iesu emikiri Parisea haukia mai rauhubu poki haukia ebakainakia etibaha, “Kahabamauri Beraura robenai hanona mai rauhubuna 'ao aha'i?” ");
INSERT INTO rro_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","'A ia 'abi ha'i tehinana. Ba Iesu emikiri hau weiana ea'ina ebamaurina euhuna eka'a. ");
INSERT INTO rro_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Haeamona ehina benakia etibaha, “Wai ha beraura robenai nahumu 'ao emu poromakau 'uriai petoa raninai, a'i ponoanoa ia a'i poberi 'auna, u?” ");
INSERT INTO rro_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ena 'abi katebamuena taearana aha'i. ");
INSERT INTO rro_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Iesu baki haukia ekia miati 'ekakia namokia tetina'anakia eihanakia raninai, 'abi ibabatai neiana ehinabenakia. ");
INSERT INTO rro_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Hau ha ena beaubeau kemai heremu ena hawainibe tatuna koao raninai, miati 'ekana namona 'akinai a'i komiati, pokina a'i o'iobina tatu poki hauna oi aramuai hauna ha aba ehina bena. ");
INSERT INTO rro_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Tatu poki hauna torarua ebeaunimi hauna kemai heremu kehina beni'o ketibaha, ‘Imia'au naiana mohabona, hau neiana naia kemia'au.’ Ba oi hanona mai haumaeamu koao muriai ṯemiati haukia herekiai wa'a katomiati. ");
INSERT INTO rro_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","'A beaubeau kemai heremu raninai koao muriai komiati, ba ebeauni'o hauna kemai heremu ketibaha, ‘E'u hau e, oi emu imia'au hanona neiana 'ubiai.’ Tatu weiana aonai tetoto haukia ikoikiai oi mo katebanamoni'o. ");
INSERT INTO rro_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Hau ha kipona kebapa'uana hanona katebaririna, 'a kipona kebaririna hauna hanona katebapa'uana.” ");
INSERT INTO rro_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Iesu tatu poki hauna ehina bena etibaha, “Atiaha 'ao rabirabi anianina koba'oruna raninai, emu hau, uaho'abamu, hatia'amu 'ao obia haukia a'i kobeaunakia, pokina ia abokiamo oi katebeauni'o 'eumu 'arana katehorena. ");
INSERT INTO rro_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","'A oi tatu ha kobabaina raninai, uraru, kaiti, 'ome mai 'iau haukia kobeaunakia. ");
INSERT INTO rro_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Weianai oi banamo koa'ina, pokina 'eumu 'arana a'i katehorena, ia aka bero haukia ibamikiri muekiai 'aramu koa'ina.” ");
INSERT INTO rro_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Weia kipokia tianiani haeamo hauna ha aia neiana eona, ba ia Iesu ehina bena etibaha, “Tirama ena obia aiaranai kateaniani haukia hanona katenamo.” ");
INSERT INTO rro_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Iesu ena 'abi ebamuena etibaha, “Hau ha tatu rarina 'akina ha ebabaina, ba maearima bo'okia ebeaunakia. ");
INSERT INTO rro_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tatu anianikia teba'orunakia aonai, ena ta'ara a'i hauna euhuna enuatae ainakia haukia kehina benakia etibaha, ‘Tomai taba ikoikiai aba te'oru.’ ");
INSERT INTO rro_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","'A ia ikoikiai teubo. Ba kori'uaina hauna ta'ara a'i hauna ehina bena etibaha, ‘Au hanona hano ha akawana, ua buonai kaeao kaihana. Emu poki hauna kohina bena, a'i kawahi.’ ");
INSERT INTO rro_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ha etibaha, ‘Au hanona bariumo e'u poromakau harau haea akawanakia, ba aba ṉaeao kabahobonakia, emu poki hauna kohina bena, a'i kawahi.’ ");
INSERT INTO rro_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Haeamona ha etibaha, ‘Au hanona bariu mo ahawainibe, buonai a'i kawahi.’ ");
INSERT INTO rro_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Ta'ara a'i hauna emue emai ena poki hauna eba'iobina, ba poki hauna eopuere wairai, ena ta'ara a'i hauna euhuna etibaha, ‘Moao biai aiara ibuakiai mai ikariri 'ekakiai, uraru haukia, kaiti haukia, 'iau haukia, 'ome haukia komaiainakia.’ ");
INSERT INTO rro_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Ba ta'ara a'i hauna eao aka weiana ebabaina emue emai ia ehina bena etibaha, ‘Poki haumu e, ohina bena'u akana aba ababaina, ia miati 'ekana mo a'i ebonu.’ ");
INSERT INTO rro_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ba poki hauna haeamona ena ta'ara a'i hauna ehina bena etibaha, ‘Moao aiara aokiai mai ara pokikiai ṯemiati haukia komaiainakia, e'u itu katemia bonuna. ");
INSERT INTO rro_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Au wai nahina benimi. Abeau 'uainakia haukia ha au e'u tatu anianina ha a'i kateani 'apuana.’” ");
INSERT INTO rro_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Mako rarina Iesu kipokia teao, ba ekori kabe ehina benakia etibaha, ");
INSERT INTO rro_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Hau ha here'u kemai raninai ia hamana 'ao hinana, atawana 'ao nahuna, uaho'abana 'ao haibuna, abomo ia kipona ena mauri keraona apa'uana hauna au i'aba'u ai a'i keao. ");
INSERT INTO rro_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Abomo hau ha kipona ena matiu ibiri ropo a'i kebuana muri'u a'i kemai hauna hanona au i'aba'u haunai a'i keao. ");
INSERT INTO rro_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Wai ha nonuatae itu ro'ena ha kobakorina raninai, oi komiati 'arana bita hanona kobahu 'uaina, itu weiana kobaorena monina aba ketaina, 'ao? ");
INSERT INTO rro_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Itu weiana ebabai ramana, hoborona ebakoroti ia 'ubina a'i kebaorena raninai kateihana haukia ikoikiai kateiriri aina, ");
INSERT INTO rro_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","kate'abi katetibaha, ‘Hau neiana ena itu akana ea'i ramana, ia kebaorena hanona a'i etaina.’ ");
INSERT INTO rro_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Ihobona obia 'arana ha pemikiri obia 'arana ha pehuari bena raninai, pemiati 'uai peraona raona ia ena huari haukia taha harau haea ai kehore huari haukia weiakia taha harau rua timai haukia kehuari benakia hanona aba ketaina 'ao? ");
INSERT INTO rro_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","A'i ketaina raninai, weia atau'ai ṯemiaho oho aonai, ena iuhubeau hauna ha keuhuna keao, baibua 'abina katerobahu aina. ");
INSERT INTO rro_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ihobonaimo wai ha emu taba ikoikiai a'i kohabonakia raninai, oi hanona au i'aba'u haumuai a'i koao. ");
INSERT INTO rro_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Kikimaru hanona taba namona, ia kikimaru 'aku'akuna ke'akauma raninai aea kahaba'aku mue aihona? ");
INSERT INTO rro_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ia hanona hano mai batobato tabakia ibanamokia tabanai aha'i, ia hanona kahane'ena mo. Mai haiana hauna hanona ke'iobina.” ");
INSERT INTO rro_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Moni bararo haukia mai aka ki'a haukia ikoikiai temai Iesu herena aiana kateona. ");
INSERT INTO rro_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","'A Parisea haukia mai Rauhubu poki haukia hanona teururu tetibaha, “Hau neiana hanona aka ki'a haukia nia'i taeanakia mai kipokia 'eka hamonai tianiani.” ");
INSERT INTO rro_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Weianai Iesu ehore 'abi ibabatai neiana ehinana ia herekiai e'abi etibaha, ");
INSERT INTO rro_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Hau ha wai baiatamiai ena mamoe hinabu hamomona. Ia hamona pe'akauma raninai, imabui baria bui 'ababani hamomo 'eka 'abaeanai pehabonakia, ia weiana e'akauma hauna murinai peao petabuna petabu ahina. ");
INSERT INTO rro_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Petabu ahina raninai aronai pebuana mai aonamona, ");
INSERT INTO rro_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","peaoaina ena aiara. Ena hau mai herenai ṯemiaho haukia pebeaunakia, patemai herena pehina benakia petibaha, ‘Hamaonamo haeamo, pokina e'u mamoe e'akauma hauna aba atabu ahina.’ ");
INSERT INTO rro_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Au wai nahina benimi. Ihobonai mo weia kupai aonamo keapa'ua, pokina neia ki'a hauna hamona eraona kabe paunai, ia bero haukia weiakia imabui bariabui 'ababani hamomo raona kabe a'i ṯenuatae aina haukia paukiai aha'i. ");
INSERT INTO rro_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Babi'e ha ena Kina harau haea, ba hamona peba'akaumana raninai, ramepa peba'arana, ena itu aona petarona, 'eka maikoina peiha haraina peaomo petabu ahina. ");
INSERT INTO rro_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Petabu ahina raninai, ena hau mai herenai ṯemiaho haukia pebeaunakia, patemai herena, pe'abi petibaha, ‘Hamaonamo, pokina e'u koini hamona e'akauma hauna aba atabu ahina.’ ");
INSERT INTO rro_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Au wai nahina benimi. Ihobonai mo, ki'a hauna hamona keraona kabe raninai, Tirama ena aneru wairakiai aonamo keapa'ua.” ");
INSERT INTO rro_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Iesu haeamona etibaha, “Hau ha nahuna rua. ");
INSERT INTO rro_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Miori i'irina hamana ehina bena etibaha, ‘Hama'u e, emu kohu powatenakia, au 'eu'u hanona kobena'u.’ Weiana hamana ehore ena kohu ewatenakia terarua herekiai. ");
INSERT INTO rro_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Wapu baika teao murinai, miori i'irina ena taba ea'i a'i harai, emikiri eao hanopaka haeai ha, weia mauri ki'a obonai ena kohu epapurai 'abaeanakia. ");
INSERT INTO rro_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ena kohu ikoikiai ebaorenakia murinai, hano weianai arobo rarina ekara'au, ia hanona aba neuraru. ");
INSERT INTO rro_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ba emikiri eao hano weiana hauna ha herenai emiaho, hau weiana ehore euhuna eao aiporo 'ima 'ekanai aiporo e'imanakia. ");
INSERT INTO rro_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Mare'a e'ari buonai aiporo ekia aniani harua peani nuana ke'ini hauna eraonana, ia tai ha aniani a'i ebena. ");
INSERT INTO rro_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Weiana ia eraona raona harai aonai etibaha, ‘Hama'u hanona mai ena aka haukia tebo'o, mai ekia aniani harikia, 'a au neia mare'a keba'arina'u. ");
INSERT INTO rro_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Au kamikiri kaeao hama'u herena kahina bena katibaha, Hama'u e, Tirama wairanai mai oi wairamuai aba aka ki'a. ");
INSERT INTO rro_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nahumuai kaeao hanona a'i ketaina, ia emu aka hauna ha ai kobaona'u.’ ");
INSERT INTO rro_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Weiana emikiri keao hamana herena. Taearai nika'a oho aonai, hamana atau'ai mahana eao nahuna nimai eihana eaoko'o aina ebeau eao nahuna huanai era'una epauna. ");
INSERT INTO rro_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","'A miori etibaha, ‘Hama'u e, Tirama wairanai mai oi wairamuai aba aka ki'a. Nahumuai kobaona'u hanona a'i ketaina.’ ");
INSERT INTO rro_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","'A hamana hanona ena ta'ara a'i haukia ehina benakia etibaha, ‘Tomoao, habuni namoabuna ha tomaiai biaina katobabatotona, imana kiri'unai rini ha katohorotina, mai tamaka abomo ha aenai katobaba'auna. ");
INSERT INTO rro_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Aniani poromakauna nahu namona ha katomaiaina katoahu 'arina, kahatatu kahaonamo. ");
INSERT INTO rro_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Pokina naha'u neiana hanona e'ari ia emauri mue, e'akauma ia atabu ahi muena.’ Ba aonamo tea'i ramana. ");
INSERT INTO rro_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Beraura weianai hau pakana hanona ua'a umai. Ena mueai, eao itu herenai hanona hui mai ewa 'urukia eo'o. ");
INSERT INTO rro_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ba emikiri ta'ara a'i hauna ha eaparina ebakaina, ‘Weiana taba nirama?’ ");
INSERT INTO rro_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ta'ara a'i hauna e'abi etibaha, ‘Oi hatimu aba emai, hamamu ehore aniani poromakauna nahu namona ha eahu 'arina, pokina ia hanona maurina abomo namona emue etabu ahina.’ ");
INSERT INTO rro_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Hau pakana aona eopuere, ebaki'a a'i ekatoto. Ba hamana ekarahi eao herena eba'amena. ");
INSERT INTO rro_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","'A ia hamana ehina bena etibaha, ‘Moihana! Ihau neiakia ikoikiai au oi ta'aramu a'i emu 'abi ha a'i abaki'ana. Ia oi nani nahu ha a'i obena'u, e'u hau kipokia a'i taonamo. ");
INSERT INTO rro_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","'A nahumu naiana hanona rea babi'ekia herekiai emu kohu ebaorenakia hauna, emai aiara raninai omikiri aniani poromakauna nahu namona oahu 'arina ia 'euna.’ ");
INSERT INTO rro_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Hamana etibaha, ‘Naha'u e, oi hanona rani ikoinai au here'uai omiaho, taba neiakia au 'e'u haukia ikoikiai hanona oi 'eumu. ");
INSERT INTO rro_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ia aika hanona kahaonamo, kahaonamo ki'a baha, pokina oi hatimu neiana hanona e'ari haeamona emauri, e'akauma haeamona hatabu ahina.’” ");
INSERT INTO rro_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Iesu ehore i'abana haukia ehina benakia etibaha, “Obia hauna ha mai ena kohu i'imana hauna ha, ba maearima baika tehore tehinau aina 'ima hauna hanona ena poki hauna ena kohu nipapura ainakia. ");
INSERT INTO rro_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ba obia hauna emikiri eaparina emai ehina bena etibaha, ‘Emu aka aonai hanona taba ha 'uruna aona, emu bai'ima akakia koba'iobina'u pokina oi e'u kohu i'imakiai hanona a'i ketaina.’ ");
INSERT INTO rro_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Kohu 'ima hauna aonai e'abi etibaha, ‘Au bariu aea kababai aiho? E'u poki hauna aka neianai aba keba'okona'u, ka'ani ia a'i mo atabura kanoi ia e'u haumaeamo eabu. ");
INSERT INTO rro_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Au taeara ha aba naraonana aea kababai aiho. E'u akai kea'i obona'u raninai e'u hau baika katehore katea'i taeana'u ekia ituai.’ ");
INSERT INTO rro_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Weiana ena poki hauna herenai tea'i 'abaea 'uai haukia ha ha eaparinakia. E'uai hauna ebakaina etibaha, ‘Oi e'u poki hauna herenai oa'i 'abaea hanona bita?’ ");
INSERT INTO rro_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ia etibaha, ‘Tehoro puoukia hinabu hamomona.’ Ba 'ima hauna ehina bena etibaha, ‘Oa'i 'abaea 'uai pepana neiana, momiati, naia pepai imabui korerena.’ ");
INSERT INTO rro_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Haeamona hau ibaruana ebakaina etibaha, ‘Oi oa'i 'abaea 'uai hanona bita?’ Ia etibaha, ‘Witi pute taha hamomona.’ Ia ehina bena etibaha, ‘Oa'i 'abaea 'uai, pepana neiana, momiati, pepai hinabu 'ababani korerena.’ ");
INSERT INTO rro_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Poki hauna ehore 'ima hauna ena bai'oi akana ea'i taeana, pokina aka weiana mai aotipana ebabaina. Bariu hanopaka neiana haukia ekia aotipa tehore ea haukia ekia aotipa tetara haonakia. ");
INSERT INTO rro_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Au wai nahina benimi, hanopaka ena obia tabakiai maearima kipokia katobaihau, ba wai heremiai kekaobo raninai miaho banai banai itunai katea'i taeanimi. ");
INSERT INTO rro_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Aka papana ha ebabai haraina hauna kehore aka apa'uana abomo kebabai haraina, ba aka papana a'i ebabai haraina hauna kehore aka apa'uana abomo a'i kebabai haraina. ");
INSERT INTO rro_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Hanopaka ena kohu ki'a obokia a'i kato'ima harainakia raninai, tai kehore kupa kohu namokia kebenimi kato'imanakia? ");
INSERT INTO rro_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Maearima haeai ekia kohu a'i kato'ima harainakia raninai, tai kehore emi kohu tohakia kebenimi? ");
INSERT INTO rro_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Ta'ara'i hauna ha poki rua ta'arakia a'i kea'ina, pokina ha ke'oatana ha keraona'au aina, 'a ha ke'ini bena ha kebaoaoaina. Tirama mai kepu rani hamonai ta'arakia a'i katoa'ina.” ");
INSERT INTO rro_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Parisea haukia aia weiana teona raninai Iesu tebatae aina, pokina ia hanona moni 'arikia ti'ari paunai. ");
INSERT INTO rro_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Iesu ehina benakia etibaha, “Wai hanona maearima wairakiai kipomi tobero ṉa tuho, 'a Tirama hanona wai aomi e'iobinakia, pokina maearima tiaonamo ai tabakia hanona Tirama nibaoao ainakia. ");
INSERT INTO rro_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Rauhubu 'abikia mai mahabanai haukia ekia 'abi hanona teiroro ainakia, emai mo Ioane Ba'uere Robe hauna ena raniai. Weiana murinai hanona Tirama ena obia aiarana pouna namona ṯeiroro aina, maearima ikoikiai taburakiai taeara tetabu katetoto. ");
INSERT INTO rro_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kupa mai hanopaka kate 'akauma hanona e'ama'ama ia rauhubu 'abina puana papana ha a'i ke'akauma 'apua. ");
INSERT INTO rro_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Hau ha atawana kebakarahina haeamona babi'e mahamahana ha eatawana hanona nabau hoana ebabaina. Mai hau ha babi'e ibakarahi eatawana hauna abomo nabau hoana ebabaina. ");
INSERT INTO rro_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Kepu hauna ha weia habuni namoabukia ebatotonakia abomo rani ikoikiai aonamo tatukia ebabai. ");
INSERT INTO rro_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ena pa'abi 'akonai hanona uraru hauna ha enoti atana Lasaro, ia hauna etua tua obo, ");
INSERT INTO rro_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ena nuatae hanona kepu hauna ena itara ai aniani puapuakia ti'eho haukia ha peani. Waeha temai hauna tuakia tetemanakia. ");
INSERT INTO rro_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Rani emai aonai uraru hauna e'ari hanona aneru teaoaina Aberahamo herenai. Kepu hauna abomo e'ari tehorena. ");
INSERT INTO rro_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Kepu hauna 'ari 'ekanai weia haiara rarina 'akina aonai emiaho, ea'a taea atau'a 'akinai Aberahamo eihana, Lasaro hanona ia herenai. ");
INSERT INTO rro_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ia eapari etibaha, ‘Hama'u Aberahamo e, moaoko'o aina'u, Lasaro mouhuna imana kiri'una beiai mekaihuna emai maea'u meba'amarina, pokina au hanona nahaiara ki'a baha iruba neiana aonai.’ ");
INSERT INTO rro_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Ia Aberahamo e'abi etibaha, ‘Naha'u e, koraonana emu mauri beraurakiai oi hanona taba namokia oa'i ia Lasaro hanona taba ki'a obokia ea'i. 'A bariu ia hanona niaonamo ia oi hanona nuhaiara. ");
INSERT INTO rro_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Abonamo aika baiatakai hanona 'oura rarina 'akina ha nemiaho, neia haukia ṉa a'i katewahi, naia haukia abomo ha a'i kemai neia.’ ");
INSERT INTO rro_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Kepu hauna e'abi etibaha, ‘Hama'u Aberahamo e, enamo, nanoini'o Lasaro mouhuna meao hama'u ena itu. ");
INSERT INTO rro_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Pokina au uaho'aba'u ima weia, keba'iobinakia ia abokiamo haiara 'ekana neiana a'i tememai.’ ");
INSERT INTO rro_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Aberahamo e'abi etibaha, ‘Mose mai mahabanai haukia hanona weia ia herekiai aiakia temeona.’ ");
INSERT INTO rro_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","'A ia e'abi etibaha, ‘Aha'i, hama'u Aberahamo e, ia hau ha 'ariai pemikiri peao herekia raninai aba kateraona kabe.’ ");
INSERT INTO rro_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Aberahamo e'abi etibaha, ‘Weia Mose mai mahabanai haukia aiakia a'i tiona raninai, neia 'ari hauna ha keao hanona aiana abomo a'i kateona.’” ");
INSERT INTO rro_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Iesu i'abana haukia ehina benakia etibaha, “Taba maearima kebabehonakia hanona aba timai, 'a hau weiana maearima behoai nihorotinakia hauna ki'ana. ");
INSERT INTO rro_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Penamo 'akonai iata rarina patetoba 'auna 'akuai patekapo uhuna, pokina papakia neiakia ha a'i mea'i ki'ana. ");
INSERT INTO rro_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kipomi kato'ima 'ima harainimi, uaho'abamu ki'a kebabaina raninai, koao herena korobe haraina. Ia keraona kabe raninai, ena ki'a kohina hao. ");
INSERT INTO rro_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Beraura hamonai rani 'abaihau hamomo heremuai ki'a kebabaina, haeamona kemue heremuai rani 'abaihau hamomo ke'abi ‘Au naraona kabe.’ raninai, ena ki'a kohina haonakia.” ");
INSERT INTO rro_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Iuhubeau haukia Obiapaka tehina bena tetibaha, “Emai a'ikakauma pobapa'uanakia.” ");
INSERT INTO rro_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Obiapaka ekia 'abi ebamuena etibaha, “Pe wai emi a'ikakauma matoha sinapi uhona papana 'abana raninai matiu rarina neiana patohina bena, bariu mounu 'auni'o moao 'akuai mo'omu hanona aiami pea'i taeana. ");
INSERT INTO rro_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Turaonana, wai ha emu ta'ara'i hauna 'ani 'ao mamoe 'ima 'ekanai pemai raninai, pohina bena potibaha, ‘Omai biai momiati moaniani’? ");
INSERT INTO rro_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Aha'i, ua a'i po'abi aiho, ia po'abi, ‘E'u aniani kokai'auna koba'oruna, koa'ia'i harai ko'imana'u, au kaniani e'u arera kainu kepua murinai, ba oi koaniani emu arera koinu.’ ");
INSERT INTO rro_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ehina bena akakia ebabainakia paunai ena ta'ara'i hauna banamona kebena? Aha'i. ");
INSERT INTO rro_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ihobonai wai abomo ehina benimi akakia ikoikia tobaorenakia raninai kato'abi katotibaha, ‘Ai hanona ta'ara'i 'abaeamai, emai aka ohina benamai hauna mo tababai.’” ");
INSERT INTO rro_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Iesu taearai eka'a eao Ierusalema aonai, Samaria mai Galilea baihoakiai ekabanai. ");
INSERT INTO rro_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Aiara papana ha ai ekatoto aonai, morumoru haukia harauhaea kipokia tebaitabu ahi. Ia atau'a tainai tekoroti, ");
INSERT INTO rro_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Iesu teaparina teio aota tetibaha, “Iesu poki haumu e, moaoko'o ainamai.” ");
INSERT INTO rro_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Iesu eihanakia raninai ehina benakia etibaha, “Tomoao, robe haukia herekia haumi katobaihanakia.” Ba tiao herekia aonai hanona haukia tenamo. ");
INSERT INTO rro_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Baiatakiai hau hamona hauna eihana aba enamo hanona emue emai Tirama ebanamona aiana 'ubi tohanai. ");
INSERT INTO rro_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Hau weiana Iesu wairanai ekai pehu ebanamona, ia hanona Samaria hauna. ");
INSERT INTO rro_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","'A Iesu ebakaina etibaha, “Haumi harauhaea tonamo, u? Ia 'ababani hamomo hanona ae'e? ");
INSERT INTO rro_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Taba buonai rama haeai hauna neiana mo emue emai Tirama ebanamona?” ");
INSERT INTO rro_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Iesu Samaria hauna ehina bena etibaha, “Momikiri moao, emu a'ikakauma ehore aba ebamaurini'o.” ");
INSERT INTO rro_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Parisea haukia baika Iesu tebakaina tetibaha, “Tirama ena obia aiarana aita kemai?” Ia ekia 'abi ebamuena etibaha, “Tirama ena obia aiarana hanona matoha taba ha nahaihana hauna 'abanai a'i kemai. ");
INSERT INTO rro_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Hau ha a'i ketibaha, ‘Moihana taba mo neiana’ 'ao ‘taba mo weiana,’ pokina Tirama ena obia aiarana hanona wai aomiai.” ");
INSERT INTO rro_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Iesu i'abana haukia ehina benakia etibaha, “Rani hanona nimai, emi nuatae Maearima Nahuna ena beraura ha hamona patoihana, ia mo a'i katoihana. ");
INSERT INTO rro_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Maearima baika katehina benimi katetibaha, ‘Tomoihana, hauna neiana.’ 'ao ‘Tomoihana, hauna weiana.’ Ia a'i katoao, murikiai a'i katoka'a. ");
INSERT INTO rro_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Maearima Nahuna ena mai ranina hanona matoha kupa ne'imare 'abana, bariu mo kupa abiranai ne'imare abamo niao kupa maikoina nibaeana. ");
INSERT INTO rro_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ia bariu kori 'uaina hanona katebahaiara ki'a baha, abomo uru neiana haukia katebaki'ana. ");
INSERT INTO rro_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Ihobona Noa ena raniai erama 'abana Maearima Nahuna ena raniai abomo ua kehoma. ");
INSERT INTO rro_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Maearima hanona teani ani teinu inu hau mai babi'e tehawainibe eao mo Noa aunohi ai etoto, abara etibo tou ekarahi maearima maikoina tetono ore. ");
INSERT INTO rro_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Lota ena raniai abomo uahomana, maearima hanona teani ani teinu inu tekawa kawa tebato bato mai itu terobe. ");
INSERT INTO rro_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Rani weianai Lota Sodoma aiarana ehabona ekarahi murinai iruba mai pihara hiabukia kupa 'ubinai te'eho, maikoikiai teba'ari orenakia. ");
INSERT INTO rro_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Maearima Nahuna kewaira tina ranina abomo ua kehoma. ");
INSERT INTO rro_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Rani weianai, hau ha itu kapenai raninai ia a'i keriri itu aonai ena kohu a'i kea'i parenakia, ihobonai mo hau ha umai raninai ia a'i kemue ena aiara. ");
INSERT INTO rro_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lota atawana katoraonana! ");
INSERT INTO rro_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Hau ha nenuatae ena mauri kea'i 'inina hanona ena mauri keba'akaumana, 'a ena mauri kene'ena raninai ena mauri kea'ina. ");
INSERT INTO rro_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Au wai nahina benimi, rabi weianai maearima rua 'ire hamonai kateparua, hamona kea'i taeana 'abana kehabona. ");
INSERT INTO rro_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Babi'e rua 'eka hamonai witi iba'iti 'itina piharana katebaherena, ha kea'i taeana 'abana kehabona. ");
INSERT INTO rro_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Hau rua umai kateaka, ha kea'i taeana 'abana kehabona.” ");
INSERT INTO rro_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","I'abana haukia tehore tebakaina tetibaha “Obiapaka e, ae'eai?” Obiapaka ekia 'abi ebamuena etibaha, “'Ari tabakia ae'eai hanona po'i abomo weia tito'u.” ");
INSERT INTO rro_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Iesu i'abana haukia 'abi ibabatai ha ehinana kateraonana rani ikoinai kate bahuba'ari ia a'i katehau hororo. ");
INSERT INTO rro_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Etibaha, “Aiara ha aonai bakai hauna ha emiaho, ia Tirama a'i eta'u aina haeamona maearima a'i eraonanakia. ");
INSERT INTO rro_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Aiara weiana aonai wapu ha abomo emiaho, rani ikoinai eao bakai hauna herena enoina etibaha, ‘Mobaraina'u, e'oatana'u hauna herenai kobaberona.’ ");
INSERT INTO rro_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Rani ehoma'a bakai hauna hanona eubo taba ha a'i ebabaina, muriai hanona kipona e'abi etibaha, ‘Au hanona Tirama a'i nata'u aina abomo maearima a'i naraonanakia. ");
INSERT INTO rro_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Iamo wapu neiana nibaro 'arina'u paunai ena bakai ibaberona akana mababaina, a'i memue a'i mebaro 'arina'u.’” ");
INSERT INTO rro_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Obiapaka etibaha, “Bakai hauna ki'a obona ena 'abi uruna tomo'ona. ");
INSERT INTO rro_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Tirama ea'i taeanakia haukia tiapari rabina tiapari ranina haukia ekia nuatae a'i kebaberonakia, u? Turaonana a'i kebarai noanoanakia, u? ");
INSERT INTO rro_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Au wai nahina benimi, Tirama kehore ekia nuatae kebabero noanoanakia. Ia Maearima Nahuna kemai raninai hanopakai a'ikakauma haukia aba ketabu ahinakia? Aha'i.” ");
INSERT INTO rro_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Abomo Iesu 'abi ibabatai neiana ehinana maearima weiakia kipokia ekia aka bero Tiapa ainakia haeamona maearima haeai ṯeiha hahanakia haukia herekia. ");
INSERT INTO rro_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Hau rua teao Marea Robe aonai katebahuba'ari, ha Parisea hauna ha moni bararo hauna. ");
INSERT INTO rro_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Parisea hauna hanona ekoroti kipona ahanai ebahuba'ari, ‘Tirama e, au hanona oi nabanamoni'o, pokina au hanona hau baika 'abakia aha'i, kakikaki haukia, babai ki'a haukia, nabau haukia 'ao moni bararo hauna neiana 'abana aha'i. ");
INSERT INTO rro_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Au hui hamona aonai wapu rua ṉani robe, abomo e'u tabu ahi ikoikiai harauhaea aonai hamomona nabaibeni oi 'eumu.’ ");
INSERT INTO rro_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","'A moni bararo hauna hanona atau'ai ekoroti, a'i ea'a taea kupa ia era'u ti'ou ekuti etibaha, ‘Tirama e, moaoko'o aina'u, au hanona ki'a hau'u.’” ");
INSERT INTO rro_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Iesu e'abi etibaha, “Au wai nahina benimi, moni bararo hauna hanona Tirama wairanai ebero ba ena itu eao, 'a Parisea hauna hanona aha'i. Pokina kipona ebapa'uana hauna Tirama kehore kebaririna, 'a kipona ebaririna hauna Tirama kehore kebapa'uana.” ");
INSERT INTO rro_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Maearima baika tehore nahukia papakia teaoainakia Iesu herena ahakiai kehao'au, ia i'abana haukia teihanakia aonai terikenakia. ");
INSERT INTO rro_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ia Iesu hanona miori papakia eaparinakia temai herena ba e'abi etibaha, “Miori papakia hanona au here'u temai a'i tomo kaiabunakia, pokina Tirama ena obia aiarana hanona nahomakia haukia 'eukia. ");
INSERT INTO rro_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","'Abi tohana au wai nahina benimi, hau ha Tirama ena obia aiarana ia'ina miori papana 'abanai a'i keao raninai, ia hanona a'i kekatoto 'apua.” ");
INSERT INTO rro_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Iuda haukia ekia poki hauna ha Iesu ebakaina etibaha, “Ba'iobi haumu namomu e, au taba kababaina hanona mauri banai banai ka'ina?” ");
INSERT INTO rro_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Iesu e'abi etibaha, “Taba buonai au namo'u ohinana, tai ha a'i enamo Tirama mo ikupaiana. ");
INSERT INTO rro_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Rauhubu aba o'iobina, ‘a'i konabau, a'i koahu ahu, a'i kobainao, a'i kohinau bai'oi, hamamu hinamu komariki ainakia.’” ");
INSERT INTO rro_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ia e'abi etibaha, “Rauhubu naiakia hanona miori'u ai raninai a'ima harainakia emai mo bariu.” ");
INSERT INTO rro_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Iesu aia weiana eona raninai ehina bena etibaha, “Taba hamona okapu aina hanona neiana. Emu taba ikoikiai kokawa kawa ainakia monikia uraru haukia kobenakia. Weianai kupa kohuna koa'ina, ba komai muri'u ai koka'a.” ");
INSERT INTO rro_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","'A hau weiana 'abi eona raninai aona earo'ari pokina ia hanona eobia ki'a baha. ");
INSERT INTO rro_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Iesu hau weiana ena ao aro'ari eihana ba e'abi etibaha, “Herekiai kepu tebo'o haukia Tirama ena obia aiaranai katekatoto hanona epahihi ki'a baha. ");
INSERT INTO rro_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Herenai kepu tebo'o hauna Tirama ena obia aiaranai kekatoto hanona epahihi ki'a baha ba kamela kopi ererenai kekuri banai.” ");
INSERT INTO rro_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Aiana teona haukia tebakaina tetibaha, “Ba tai hanona mauri kea'ina?” ");
INSERT INTO rro_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Iesu ekia 'abi ebamuena etibaha, “Taba katebabaina maearima herekiai a'i ketaina hauna Tirama herenai hanona ketaina.” ");
INSERT INTO rro_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Petero, Iesu ehina bena etibaha, “Ai hanona emai taba ikoikiai tahabonakia, oi murimuai ṯaka'a.” ");
INSERT INTO rro_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Iesu ehina benakia etibaha, “'Abi tohana mo au wai nahina benimi, hau ha ena itu, atawana, uaho'abana, hamana, hinana 'ao nahuna ehabonakia Tirama ena obia aiarana paunai, ");
INSERT INTO rro_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ia hanona bariu rani neianai taba bo'okia kea'i abomo wairanai rani kemai aonai hanona mauri banai banai kea'ina.” ");
INSERT INTO rro_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Iesu i'abana haukia harauhaea rua ebakaparenakia haia haiai ehina benakia etibaha, “Aika hanona bariu kahakara'au Ierusalema, mahabanai haukia tererenakia haukia ikoikiai bariu Maearima Nahuna herenai katetoha. ");
INSERT INTO rro_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ia hanona rama haeai haukia imakiai kateutana, katebapo'ona, kateba opuerena, kate'atotina, kate'atina, mai kateahu 'arina. ");
INSERT INTO rro_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","'A wapu ibaihaunai ia hanona kemikiri mue.” ");
INSERT INTO rro_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ia i'abana haukia taba neiakia obokia a'i teobo 'apua. 'Abi weiana anina ebuni ia herekiai, haeamona a'i te'iobina ia hanona 'abi tabana nehinana. ");
INSERT INTO rro_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Iesu Ieriko aiaranai aba kekara'au aonai 'iau hauna ha taeara haianai emiati ninoi ba'ame, ");
INSERT INTO rro_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","maearima bo'ona teka'a urukia eona, ba ebakai bakai weiana taba nirama. ");
INSERT INTO rro_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Tehina bena tetibaha, “Iesu Nasareta hauna nikabanai.” ");
INSERT INTO rro_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","'Iau hauna eapari, “Iesu Davida Nahuna e, moaoko'o aina'u!” ");
INSERT INTO rro_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Maearima wairai teka'a haukia terikena tetibaha, “Oi 'urumu.” 'A ia hanona eapari aota, “Davida nahuna e, moaoko'o aina'u!” ");
INSERT INTO rro_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Iesu ekoroti ehina benakia hau weiana katemaiaina herena. Ia emai herena raninai Iesu ia ebakaina etibaha, ");
INSERT INTO rro_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Taba nonuatae oi heremuai kababaina?” Ia e'abi etibaha, “Obiapaka e, au e'u nuatae kaiha iha.” ");
INSERT INTO rro_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Iesu ia ehina bena etibaha, “Mahamu temeno'a, emu a'ikakauma ehore ebanamoni'o.” ");
INSERT INTO rro_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Beronai mo mahana teno'a, Tirama ebanamona, Iesu murinai eka'a, maearima ikoinai teihana haukia abomo Tirama tebanamona. ");
INSERT INTO rro_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Iesu Ieriko ai ekatoto nikabanai aonai, ");
INSERT INTO rro_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","hau ha weia atana hanona Sakaio, takiti a'i haukia ekia poki ha, ia hanona kepu hauna. ");
INSERT INTO rro_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ia ena nuatae hanona Iesu keihana, ia a'i etaina pokina maearima ebo'o ia hanona eko'o ko'o. ");
INSERT INTO rro_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ua buonai ebeau 'uai eao matiuai etae Iesu taeara weianai kekabanai hanona keihana. ");
INSERT INTO rro_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Iesu emai 'eka weianai ekarahi raninai ea'a taea eihana ehina bena etibaha, “Sakaio e. Moriri biai. Bariu rani neianai au hanona oi emu ituai kamiaho.” ");
INSERT INTO rro_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ia beronai eriri biai mai aonamona Iesu eaoaina ena ituai ea'i taeana. ");
INSERT INTO rro_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Maearima ikoikiai teihana hanona teururu tetibaha, “Ia hanona aba ki'a hauna ena bakiai niao.” ");
INSERT INTO rro_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","'A Sakaio ekoroti Obiapaka ehina bena etibaha, “Obiapaka e. Bariu e'u kepu abirana maikoinai uraru haukia kabenakia, abomo hau ha ena kepu a'i 'abaeana hanona rani bani ena kepu 'arana kabamuena.” ");
INSERT INTO rro_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Iesu ia ehina bena etibaha, “Bariu rani neianai bamauri hanona itu neianai aba ekara'au, pokina hau neiana ia abomo Aberahamo nahuna. ");
INSERT INTO rro_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Maearima Nahuna emai ena poki hanona te'akauma haukia ketabunakia kebamaurinakia.” ");
INSERT INTO rro_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Maearima aia weiana tiona aonai 'abi ibabatai ha ehina benakia pokina ia aba emai Ierusalema herenai abomo teraonana Tirama ena obia aiarana hanona aba kewaira tina. ");
INSERT INTO rro_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ba Iesu etibaha, “Obia hauna ha eao hanopaka haeai weia ena obia arana hoana katebena ba kemue. ");
INSERT INTO rro_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","A'i eka'a baha aonai ena ta'ara'i haukia harauhaea eaparinakia, gold monikia atakia mina ha ha ebenakia etibaha, ‘Moni neiakia hanona katoaka ainakia keaomo au kamue.’ Ba eka'a. ");
INSERT INTO rro_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","'A ena aiara haukia a'i tenuatae aina ekia iuhubeau baika teuhunakia murinai teao katetibaha, ‘Ai hau naiana a'i ṯanuatae aina, emai obia 'aranai a'i keao.’ ");
INSERT INTO rro_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Hau weiana obia 'arana hoana aba ea'ina emue emai raninai, ena ta'ara'i haukia moni ebenakia haukia eaparinakia aea teaka aiho hauna ke'iobina. ");
INSERT INTO rro_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Hau kori 'uaina emai e'abi etibaha, ‘E'u poki haumu e, emu mina hamonai mina harauhaea atabu ahinakia.’ ");
INSERT INTO rro_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Poki hauna ia ena 'abi ebamuena etibaha, ‘E'u ta'ara'i haumu namomu e, obabai harai. Taba papana 'akina ia o'ima haraina buonai aiara harauhaea ekia obia haunai koao.’ ");
INSERT INTO rro_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Hau ibaruana emai etibaha, ‘E'u poki haumu e, emu mina hamona ahanai mina ima atabu ahinakia.’ ");
INSERT INTO rro_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Poki hauna ehina bena etibaha, ‘Oi hanona aiara ima ekia obia haunai koao.’ ");
INSERT INTO rro_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Haeamona ta'ara'i hauna ha emai etibaha, ‘E'u poki haumu e, emu mina hamona neiana, habuniai a'apana ahore buni haraina. ");
INSERT INTO rro_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Au oi ata'u aini'o, pokina oi hanona hau pahihimu, a'i ohoroti tabana nua'i parena haeamona a'i obato tabana nukabe hurina.’ ");
INSERT INTO rro_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Poki hauna ia ehina bena etibaha, ‘Ta'ara'i haumu ki'a obomu, emu 'abiai kababakaini'o, oi o'iobina au hau pahihi'u, a'i ahorotina tabana ṉa'i parena haeamona a'i abatona tabana nakabe hurina. ");
INSERT INTO rro_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ba taba buonai e'u mina moni itunai a'i ohorotina, ba amue hanona ahanai ha patabu ahina.’ ");
INSERT INTO rro_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Herenai tekoroti haukia ehina benakia etibaha, ‘Ena mina hamona tomopuhu boina, weiana mina harauhaea ebabaina hauna tomobena.’ ");
INSERT INTO rro_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","'A ia te'abi tetibaha, ‘Poki haumu e, ia mina harauhaea aba imanai.’ ");
INSERT INTO rro_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ekia 'abi ebamuena etibaha, ‘Au wai nahina benimi, maearima ha mai ena taba hauna bo'ona katebena, ia taba aha'i hauna hanona herenai papana nemiaho hauna abonamo katea'i obona. ");
INSERT INTO rro_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Abomo au e'u 'ou haukia, a'i ṯenuatae, au a'i kaobia haukia tomaiainakia neia, au waira'u ai katoahu 'arinakia.’” ");
INSERT INTO rro_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Iesu 'abi neiakia ehinanakia murikiai e'uai ainakia Ierusalema teao. ");
INSERT INTO rro_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Eka'a eao Betefage mai Betani aiarakia aba herekiai Olibe oeonai, Iesu i'abana haukia rua euhunakia, ");
INSERT INTO rro_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ehina benakia etibaha, “Katoao aiara wairakai hauna aonai katokatoto, toniki nahuna ha ua'a tetoba 'auna katoihana, ahanai hau ha a'i nemia'au 'apua, katorubuna katomaiaina here'u. ");
INSERT INTO rro_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Hau ha kebakainimi, ‘Taba buonai naiana ṯorubuna?’ Wai katohina bena, ‘Obiapaka nenuatae aina.’” ");
INSERT INTO rro_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Euhunakia teao haukia ehina benakia ihobonai mo tetabu ahina. ");
INSERT INTO rro_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Toniki nahuna terubuna aonai poki haukia tebakainakia, “Taba buonai doniki nahuna ṯorubuna?” ");
INSERT INTO rro_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ia ekia 'abi tebamuena tetibaha, “Obiapaka nenuatae aina.” ");
INSERT INTO rro_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Teaoaina Iesu herena, ekia habuni toniki nahuna kapenai teabari 'aunakia, ba Iesu emia'au. ");
INSERT INTO rro_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Eao aonai maearima ekia habuni taearai teabarinakia. ");
INSERT INTO rro_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Teao aiara aba herekiai, taeara Olibe oeonai eriri 'ekanai ti'abana haukia ikoikiai mai aonamokia teio Tirama tebanamona hiabu akakia ebabai teiha haukia paukiai. ");
INSERT INTO rro_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ia tetibaha, “Aika eka Obia Arana Obiapaka atanai nimai hauna hamabanamona. Baibua kupai, nuabina hanona 'ubi 'akinai.” ");
INSERT INTO rro_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Parisea haukia baika mako baiatakiai Iesu tehina bena tetibaha, “Ba'iobi haumu e, i'abamu haukia morikenakia temeunu.” ");
INSERT INTO rro_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Iesu ekia 'abi ebamuena etibaha, “Au wai nahina benimi, neiakia kateunu raninai pihara kateio.” ");
INSERT INTO rro_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Iesu eka'a eao Ierusalema herena tainai mahana eao aiara eihana raninai ehai aina. ");
INSERT INTO rro_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Etibaha, “Ierusalema e, bariu rani neianai emu baibua pokina po'iobina hanona penamo, 'a mahamu ebuni. ");
INSERT INTO rro_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Beraura weiana ketaina aonai, oi emu 'ou haukia 'anoai kekepirimu katekai kakaiarona, katekori kaiaroni'o, haia haia ikoikiai katekaiabunakia. ");
INSERT INTO rro_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Katekaponi'o koao 'ano tohanai oi mai nahumu emu pihia aonai ṯemiaho haukia maikoinai kate'ari ore, pihara ha a'i katehabona pihara ha ahanai pokina Tirama kemai heremu beraurana a'i o'iobina.” ");
INSERT INTO rro_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ba Iesu Marea Robe aonai ekatoto, weia tikawakawa haukia eu'u ahi ramanakia, ");
INSERT INTO rro_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ehina benakia etibaha, “Aba Puka Robenai ererena, ‘E'u itu hanona bahuba'ari itunai keao’, ia wai hanona kakikaki haukia ekia paparo'ai tubaona.” ");
INSERT INTO rro_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Rani ikoinai Iesu Marea Robe aonai eba'iobi, 'a robe haukia apa'uakia rauhubu poki haukia mai aiara obia haukia kipokia taearana tetabuna Iesu kateahu 'arina. ");
INSERT INTO rro_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Taeara ha a'i tetabu ahina taba katebabaina pokina maearima hanona ia mo ena 'abi ai tearuru reana. ");
INSERT INTO rro_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Rani ha Iesu hanona Marea Robe aonai maearima eba'iobinakia mai pou namona eiroro aina, robe haukia apa'uakia rauhubu poki haukia mai aiara haukia apa'uakia kipokia tebahamomo tekara'au teao Iesu herena. ");
INSERT INTO rro_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Tehina bena tetibaha, “Mohina benamai, bero tabanai aka neiakia nubabainakia, tai bero neiana ebeni'o?” ");
INSERT INTO rro_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Iesu ekia 'abi ebamuena etibaha, “Au abomo wai kabakainimi, katohina bena'u. ");
INSERT INTO rro_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ioane ena ba'uere robe hanona kupai emai 'ao maearima herekiai emai?” ");
INSERT INTO rro_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Kipokia baiatakiai te'abi'abi aina tetibaha, “Kaha'abi ‘kupai emai,’ raninai ia ke'abi, ‘Aehoma buonai a'i toa'ikakaumana?’ ");
INSERT INTO rro_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","'A kahatibaha, ‘Maearima herekiai emai,’ raninai maearima neiakia piharai kateahunaka, pokina ia te'abi, ‘Ioane hanona mahabanai hauna.’” ");
INSERT INTO rro_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Iesu ena 'abi tebamuena tetibaha, “Ai a'i ta'iobina ae'eai emai.” ");
INSERT INTO rro_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Iesu ehina benakia etibaha, “Au abomo wai a'i kahina benimi, taba neiakia tai ena beroai nababainakia.” ");
INSERT INTO rro_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ba Iesu 'abi ibabatai neianai maearima ehina benakia etibaha, “Hau ha bine haharuana ebatona, biraura haukia baika ea'inakia kate'imana, 'a ia hanona ekaobo rani homa'ana hanopaka haeai emiaho. ");
INSERT INTO rro_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Bine buana ibararona ranina etaina, poki hauna ena ta'ara'i hauna ha euhuna eao haharua i'imana haukia herekiai bine buakia baika katebena. 'A bai'ima haukia tehore ta'ara'i hauna teahuna imana 'abaeana teuhuna emue. ");
INSERT INTO rro_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Haeamona ena ta'ara'i hauna haeai ha euhuna, ia bai'ima haukia aka hamomona mo tebabaina, teahuna tebahaumaeana imana 'abaeana teuhuna emue. ");
INSERT INTO rro_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ibaihauna euhuna, 'a bai'ima haukia tehore tebamani'ana teu'u ahina. ");
INSERT INTO rro_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Weiana haharua poki hauna etibaha, ‘Tabamo kababaina? Au Naha'u tohana, e'u raona'au kauhuna keao hanona pa'e ia aba katemariki aina.’ ");
INSERT INTO rro_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","'A haharua i'imana haukia ia teihana raninai te'abi'abi aina tetibaha, ‘Neiana hanona haharua poki hauna nahuna, hamahu 'arina, haharua hanona aika 'eukai keao.’ ");
INSERT INTO rro_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Temikiri teberi ahina haharua kapenai teahu 'arina. Ba haharua poki hauna taba kebabaina haharua i'imana haukia herekiai? ");
INSERT INTO rro_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ia hanona kemai haharua i'imana haukia weiakia keahu 'arinakia haharua hanona maearima haeai kebenakia.” Maearima 'abi weiana teona raninai tetibaha, “Neiana ua a'i pehoma.” ");
INSERT INTO rro_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Iesu eiha 'ini 'ininakia ba ebakainakia etibaha, “Puka Robenai tererena 'abina anina hanona taba? ‘Itu ibakorina haukia tebaoao aina piharana hanona aba itu ibua 'inina piharanai eao.’ ");
INSERT INTO rro_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Hau ha ke'eho pihara weiana ahanai hanona keahu ahu hurina, 'a pihara weiana ke'eho hau ha ahanai hanona hau weiana ke'iti 'iti obo matoha apuroro 'abana.” ");
INSERT INTO rro_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Rani weianai rauhubu poki haukia mai robe haukia apa'uakia taeara tetabu Iesu katebirina, pokina 'abi ibabatai hanona ia mo ahakiai ehinana, ia maearima teta'u ainakia buonai a'i etainakia. ");
INSERT INTO rro_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Iesu teiha 'inina, 'abi bai'oi haukia baika teuhunakia katebakai bai'oina matoha bero haukia 'abakia. Ena 'abiai hanona katea'ina, rauhubu mai hiabu haukia imakiai kateutana. ");
INSERT INTO rro_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Weiana bai'oi haukia tebakaina tetibaha, “Ba'iobi haumu e, ai ta'iobina oi emu ba'iobi mai emu 'abi hanona tebero ki'a baha, maearima ekia hoahoa hanona oi a'i nuraonanakia, 'a Tirama ena 'abi tohana taearanai nuba'iobi harainamai. ");
INSERT INTO rro_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ai takiti monina obia arana katabena hanona ebero 'ao aha'i?” ");
INSERT INTO rro_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","'A Iesu ekia bai'oi weiana hanona aba e'iobina, ba ehina benakia etibaha, ");
INSERT INTO rro_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Moni ha tomobaihana'u. Tai aubaubana mai tai atana?” Ia te'abi, “Obia 'arana 'euna.” ");
INSERT INTO rro_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Iesu ehina benakia etibaha, “Obia 'arana 'euna hanona Obia 'arana katobena, 'a Tirama 'euna hanona Tirama katobena.” ");
INSERT INTO rro_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Maearima wairakiai ena 'abiai katebarewana hanona a'i etainakia, ia ena 'abiai mo teta'uta'u huri, 'abi ha a'i tehina 'apuana. ");
INSERT INTO rro_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadukea haukia baika weiakia 'ariai mikiri mue a'i tibatohana haukia temai Iesu herena tebakaina tetibaha, ");
INSERT INTO rro_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Ba'iobi haumu e, Mose eka rauhubu ṉa erere aihona, hau ha ke'ari atawana kemiaho nahuna aha'i raninai ia uaho'abana kehore wapu keatawana, miori katebarama e'ari hauna 'euna. ");
INSERT INTO rro_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Weiana uaho'aba 'abaihau hamomo temiaho, pakana babi'e ha eatawana nahuna aha'i aonai e'ari. ");
INSERT INTO rro_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ibaruana wapu weiana eatawana ba e'ari, ");
INSERT INTO rro_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ibaihauna abomo wapu weiana eatawana, ba taeara hamonaimo haukia 'abaihau hamomo teatawana nahukia aha'i te'ari. ");
INSERT INTO rro_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Muri 'akinai babi'e weiana abomo e'ari. ");
INSERT INTO rro_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ba mikiri mue raninai babi'e weiana hanona tai atawanai keao, pokina ia haukia 'abaihau hamomo ikoikiai teatawana.” ");
INSERT INTO rro_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Iesu ia ehina benakia etibaha, “Hanopaka neiana haukia hanona ikoikiai tihawainibe. ");
INSERT INTO rro_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","'A hanopaka weiana haukia 'ariai katemikiri mue haukia hanona a'i katehawainibe. ");
INSERT INTO rro_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ia a'i kate'ari mue, pokina ia hanona aneru ihobokia abomo aba 'ariai temikiri mue Tirama nahunai kateao. ");
INSERT INTO rro_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","'Ariai mikiri mue 'abina hanona Mose abomo ebaihana matiu 'ini'inina arabuna e'ara orina aonai. Ia Obiapaka e'uahina Aberahamo ena Tirama, Isako ena Tirama, Iakobo ena Tirama. ");
INSERT INTO rro_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ia hanona 'ari haukia ekia Tiramana aha'i, 'a mauri haukia ekia Tiramana, pokina Ia aonai maearima ikoikai nahamauri.” ");
INSERT INTO rro_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Iesu ena 'abi teona raninai rauhubu poki haukia baika te'abi tetibaha, “Ba'iobi haumu e, 'abi tohana mo naiana.” ");
INSERT INTO rro_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Weiana murinai ibakaina tebaoao aina. ");
INSERT INTO rro_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Iesu ehore maearima ebakainakia etibaha, “Aeahoma buonai maearima ti'abi Keriso hanona Davida nahuna? ");
INSERT INTO rro_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Davida kipona Salamo pukanai e'abi, ‘Obiapaka hanona e'u Obia ehina bena etibaha, Itipa'u tainai momiati, ");
INSERT INTO rro_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","keaomo oi emu 'ou haukia ikoikiai oi 'apumu iehe'auna tabanai kabaonakia.’ ");
INSERT INTO rro_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Neiana Davida ehore ia Obiana ehinana ba aea homanai mo Keriso hanona Davida nahuna?” ");
INSERT INTO rro_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Maearima ikoinai tibahu aonai, Iesu i'abana haukia ehina benakia etibaha, ");
INSERT INTO rro_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Rauhubu poki haukia herekiai kato'ima harainimi, ekia nuatae hanona habuni homa'akia katebatoto katekaoao kaoao, mai kawakawa 'ekakiai maearima ia kateba namonakia, haeamona mareai mai tatu 'ekakiai imia'au 'ekakia namokiai mo katemia'au. ");
INSERT INTO rro_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Wapu ekia itu tiani 'aunakia, maearima ia kateihanakia paunai ekia bahuba'ari Tibahoma'anakia. Maearima uahomakia haukia puma rarina katea'ina.” ");
INSERT INTO rro_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Iesu mahana eao kepu herekia tebo'o haukia ekia baibeni marea monina iutana mauana aonai teuta eihanakia. ");
INSERT INTO rro_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Abomo wapu uraruna ha ena toea papakia rua eutanakia eihana. ");
INSERT INTO rro_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Iesu e'abi etibaha, “'Abi tohana au wai nahina benimi, wapu uraruna neiana euta tabana eapa'ua ba ikoikiai. ");
INSERT INTO rro_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Maearima neiakia ikoikiai ekia obiai baibeni tabakia papakia tehoroti, 'a wapu neiana ena uraruai kemiaho aina tabana maikoina ehorotina.” ");
INSERT INTO rro_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","I'abana haukia baika marea robe terobahu aina ena nuabi piharakia namoabukiai mai baibeni Tirama tebena tabakiai tebabaina. 'A Iesu e'abi etibaha, ");
INSERT INTO rro_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Bariu ṯoiha tabakia neiakia rani kemai aonai pihara ha pihara ha ahanai a'i kemiaho maikoinai kateruru ore.” ");
INSERT INTO rro_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Tebakaina tetibaha, “Ba'iobi haumu e, aita raninai taba neiakia katerama? Abomo katerama ranina mai hoana hanona taba?” ");
INSERT INTO rro_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Iesu e'abi etibaha, “Kato'ima harainimi, a'i teme'oinimi, weiana maearima bo'ona au ata'uai katemai kate'abi, ‘Hauna neiana Au,’ haeamona ‘Rani aba herekai,’ hanona murikiai a'i kato'au. ");
INSERT INTO rro_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Huari mai 'au urukia kato'o hanona a'i katota'u, taba neiakia hanona katerama 'uai, 'a puana hanona wairai.” ");
INSERT INTO rro_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Haeamona ia ehina benakia etibaha, “Hanopaka ha kemikiri hanopaka ha kehuarina, itubu ha kemikiri itubu ha kehuarina. ");
INSERT INTO rro_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","'Eka haeai haeai kanokau apa'uakia, arobo, mai inawa ki'a obokia katerama, abomo ta'u tabakia mai hoa rarikia kupai katerama. ");
INSERT INTO rro_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“'A taba neiakia ikoikiai a'i katerama baha aonai, au ata'u paunai katea'inimi haeamona katebapo'onimi ba kateaoainimi mareai mai wapura 'ekakiai katehorotinimi, abomo kateberinimi kateaoainimi obia mai kabamani haukia wairakiai. ");
INSERT INTO rro_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ia rani neiana hanona wai Pou Namona katohinana herekiai ranina. ");
INSERT INTO rro_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Aea katobakai aiho paunai, aomi a'i katearo 'ari. ");
INSERT INTO rro_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Pokina Au kahore aobero 'abikia kabenimi, weiana emi 'ou haukia katebamuenakia 'ao katebuniai ainakia hanona a'i ketaina. ");
INSERT INTO rro_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Hamami, hinami, uaho'abami, hatia'ami, mai emi hau katehore katehina hinainimi, abomo wai baika kateahu 'arinimi. ");
INSERT INTO rro_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Maearima ikoikiai kate'oatanimi au pau'uai. ");
INSERT INTO rro_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","'A aramiai bui ha hamona a'i keki'a. ");
INSERT INTO rro_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Emi bapahihiai wai emi mauri katoa'inakia. ");
INSERT INTO rro_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“'A huari haukia Ierusalema katekori kaiarona katoihanakia raninai, aba kato'iobina ena pua ranina aba herekai. ");
INSERT INTO rro_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ba weiakia Iudea ai ṯemiaho haukia katebeau kobio kateao, weiakia aiara apa'uana aonai haukia katekarahi mahanai, weiakia mahanai haukia aiara apa'uanai a'i katekatoto. ");
INSERT INTO rro_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Pokina rani neiakia hanona haiara ranikia taba ikoikiai Puka Robenai tererenakia haukia ibatohakia. ");
INSERT INTO rro_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","'A rani weiakia aokiai babi'e mai nuakia abomo nahukia 'oru'orukia babi'ekia herekia hanona keki'a ki'a baha, haiara rarina 'akina hano ahanai kerama abomo Tirama ena opuere keriri maearima neiakia ahakiai. ");
INSERT INTO rro_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ia baika kareba mahanai kate'ari, ba baika katea'i maurinakia kateaoainakia hanopaka haeai haeai aokiai wapura haukiai kateao, rama haea haukia hanona Ierusalema katebaripu ripuna keaomo ekia rani Tirama e'uahina hauna ketaina. ");
INSERT INTO rro_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Beraura, nawa, mai bihiu aokiai hoa katerama mai 'aku roio mai harapuni urukiai hanopaka haukia ikoikiai aokia kearo 'ari abomo nuakia ketae. ");
INSERT INTO rro_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Hanopakai taba kerama hauna kate'imana aonai maearima kateta'u aokia katerea, pokina kupai hiabu tabakia kateibiu ibiu. ");
INSERT INTO rro_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Rani weianai maearima hanona Maearima Nahuna kateihana 'auhao ahanai kemai mai hiabuna mai nuabina. ");
INSERT INTO rro_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","'A taba neiakia katea'i ramana raninai katokoroti arami katoa'i taeana, pokina ibamaurimi aba niherekai.” ");
INSERT INTO rro_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ba Iesu 'abi ibabatai neiana ehina benakia etibaha, “Kuropou mai matiu ikoikiai katoihanakia. ");
INSERT INTO rro_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Raukia hubu hubukia katekarahi katoihanakia raninai kato'iobina hioro aba herekai. ");
INSERT INTO rro_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ba ihobonaimo wai abomimo taba neiakia katerama katoihanakia raninai, kato'iobina Tirama ena obia aiarana hanona aba herekai. ");
INSERT INTO rro_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“'Abi tohana au wai nahina benimi, uru neiana maearimakia a'i kate'ari ore baha aonai taba neiakia ikoikiai katerama. ");
INSERT INTO rro_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kupa mai hanopaka kate'akauma, 'a e'u 'abi hanona a'i ke'akauma 'apua. ");
INSERT INTO rro_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Kipomi kato'ima 'ima harainimi. Tatuai inuinuai abomo hanopaka ena aoaniai aomi a'i mebareana marikina, rani kemai hanona aba herekai matoha rio 'abana, a'i mebata'u ta'u hurinimi. ");
INSERT INTO rro_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Rani weiana kemai hanona maearima ikoikiai hanopakai ṯemiaho haukia ahakiai. ");
INSERT INTO rro_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Rani ikoinai katobai'ima abomo katobahuba'ari, weianai katotabura taba neiakia ikoikiai katerama haukia herekiai katokapare Maearima Nahuna wairanai katokoroti.” ");
INSERT INTO rro_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Iesu rani weiakiai mararani hanona marea robe aonai eba'iobi, 'a rabirabi hanona ekarahi eao Olibe oeonai rabi maikoina weia emiaho. ");
INSERT INTO rro_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Raurani amarikiai maearima ikoikiai teao marea robe aonai aiana kateona. ");
INSERT INTO rro_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Parawa ibakupu aha'i tatuna beraurana teaparina Kabanai tatuna hanona aba niherekai. ");
INSERT INTO rro_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Robe haukia apa'uakia mai rauhubu poki haukia Iesu iahu 'arina taearana tetabu iamo maearima teta'u ainakia. ");
INSERT INTO rro_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Satani ehore Iuda Kariote hauna Iesu i'abana haukia harauhaea rua ha aonai etoto. ");
INSERT INTO rro_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Iuda eao robe haukia apa'uakia mai marea robe ṯe'imana poki haukia kipokia teroba ahu Iesu aea kehinahinai aihona. ");
INSERT INTO rro_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ia aokia enamo, ba te'abi'uai moni katebena. ");
INSERT INTO rro_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Iuda ekia 'abi ea'i taeana, taeara etabu rani namona tabanai to'u aha'i aonai imakiai keutana. ");
INSERT INTO rro_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Parawa ibakupu aha'i tatuna wapuna etaina hanona Kabanai banamo mamoekia kateahu 'arinakia ranina. ");
INSERT INTO rro_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Iesu Petero mai Ioane euhunakia e'abi etibaha, “Tomoao eka Kabanai anianina aika kahani hauna katoa'ia'i haraina.” ");
INSERT INTO rro_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Terarua tehina bena tetibaha, “Nonuatae ae'eai kata'ia'i haraina.” ");
INSERT INTO rro_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ia ehina benakia etibaha, “Aiara apa'uanai katokatoto aonai hau ha puou mai beina aronai kebuana katoihana, murinai katoao ketoto itunai katokatoto. ");
INSERT INTO rro_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Weiana itu poki hauna katohina bena, ‘Ba'iobi hauna ninoini'o, baki ikaihurina hanona ae'e ai. Weia au mai i'aba'u haukia kipokia emai Kabanai tatuna anianina katana.’ ");
INSERT INTO rro_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ia kehore ikaihuri apa'uana 'ubiai aba iba'oru hauna kebaihanimi, weia aniani katoa'ia'i haraina.” ");
INSERT INTO rro_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Terarua tekaobo teao Iesu ehina benakia tabakia ikoinai ihobona tohanai tetabu ahinakia, weia Kabanai tatuna anianina tea'ia'i haraina. ");
INSERT INTO rro_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Beraura hoana etaina Iesu ena iuhubeau haukia kipokia aniani 'ekanai temiati. ");
INSERT INTO rro_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ia ehina benakia, etibaha, “Au e'u nuatae tohana hanona Kabanai tatuna anianina neiana kipokia kahaniani oioi 'uaina ba kateba haiarana'u. ");
INSERT INTO rro_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Pokina au wai nahina beninimi, Au hanona neiana a'i kani muena keaomo anina tohana Tirama ena obia aiaranai ketohana.” ");
INSERT INTO rro_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ba 'ere ha ea'ina ebanamona e'abi etibaha, “Neiana tomoa'ina ikoimiai tomoinu. ");
INSERT INTO rro_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Pokina au wai nahina benimi, bine buana beina a'i kainu mue bariu keaomo Tirama ena obia aiarana kemai.” ");
INSERT INTO rro_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Parawa ha ea'ina ebanamona haeamona ehobina ebenakia e'abi etibaha, “Neiana hanona au hau'u, wai paumiai nabaibeni. Neiana katobabaina au iraona'u.” ");
INSERT INTO rro_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Taeara ihobonaimo teaniani murinai ia 'ere ha ea'ina ehina benakia etibaha, “'Ere neiana hanona baibua mahamahana ibatohana hoana au aruaru'u ai, wai paumiai kekiki oioi. ");
INSERT INTO rro_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ia au hinahina'u kehinahina hauna imana abomo neia au ima'u kipokia aniani 'ekanai. ");
INSERT INTO rro_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","'Abi tohana Maearima Nahuna hanona keao Tirama ena raona ihobona, 'a hau weiana kehinahina hauna ki'ana herenai ki'a rarina kerama.” ");
INSERT INTO rro_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ia kipokia ha ha tebakai bakai baiatakiai, tai hanona aka weiana kebabaina. ");
INSERT INTO rro_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","I'abana haukia kipokia baiatakiai tebaihara tae tai hanona keapa'ua. ");
INSERT INTO rro_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Iesu ehina benakia etibaha, “Rama haeai obia arana haukia hanona ekia maearima Tiobia ainakia, ekia nuatae weiakia ekia iha 'ini ba'anai ṯemiaho haukia hanona kateaparinakia ia maearima namokia. ");
INSERT INTO rro_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","'A wai heremiai hanona ua a'i kehoma, keapa'ua baiatamiai hauna hanona aona mebamiorina, ne'uai ainimi hauna hanona matoha barai barai akana nibabaina hauna 'abana. ");
INSERT INTO rro_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Tai hanona eapa'ua, weiana aniani 'ekanai nemia'au hauna 'ao barai barai akana nibabaina hauna? Weiana aniani 'ekanai nemiati hauna hanona eapa'ua. Ia au wai baiatamiai hanona barai barai akana nibabaina haunai naeao. ");
INSERT INTO rro_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Wai hanona au kipokia hamiaho haeamo baihobo ikoikiai aokiai. ");
INSERT INTO rro_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Hama'u hiabu ebena'u ena 'eka ka'imana, ihobonai mo bariu Au hiabu kabenimi e'u 'eka kato'imana. ");
INSERT INTO rro_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Weiana e'u obia aiaranai wai hanona e'u aniani 'ekanai katoaniani katoinuinu, haeamona obia imia'aunai katomia'au Isaraela itubuna harauhaea rua i'imana haumiai katoao. ");
INSERT INTO rro_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simona e, Simona e, Satani aba enoinoi ikoimiai kebarobonimi kehobonimi ihobona witi 'abana. ");
INSERT INTO rro_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Iamo Simona au aba ahamuai abahuba'ari emu a'ikakauma a'i me'eho, ba oi koraona kabe raninai uaho 'abamu abokiamo koba taburanakia.” ");
INSERT INTO rro_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Petero ehore Iesu ehina bena etibaha, “Obiapaka e, au aba aba'oru oi ka'abani'o kahaeao kahawapura 'ao kaha'ari.” ");
INSERT INTO rro_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Iesu ena 'abi ebamuena etibaha, “Petero e, au oi nahina beni'o, bariu rabi neianai kokoro'u a'i ke'arara baha aonai, oi rani aihau au kobuniaina'u, au a'i o'iobina'u ṉa kohoma.” ");
INSERT INTO rro_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Iesu ehore i'abana haukia ebakainakia etibaha, “'Uainai auhu ahinimi, toao mahoa ihiuaihiua, mahoa mai tamaka aha'i toka'a raninai taba ha heremiai tokapu, 'ao?” Ia te'abi tetibaha, “Aha'i.” ");
INSERT INTO rro_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ia ehina benakia etibaha, “'A bariu tai mahoa ihiuaihiua herenai hanona kea'ina, mahoa abomo kea'ina, mai tai kareba herena aha'i hauna ena habuni kekawa kawa aina moninai kareba ha kekawana. ");
INSERT INTO rro_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Pokina au wai nahina benimi, tererena ‘Kakikaki haunai tebaona,’ 'abina neiana hanona au here'uai ketohana, taba tererena au aha'uai hauna ibatohana ranina aba nimai.” ");
INSERT INTO rro_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","I'abana haukia te'abi tetibaha, “Obiapaka e, moihana kareba rua neiakia.” Weiana ia ehina benakia, “Abetaina.” ");
INSERT INTO rro_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Iesu nibabai babai bena ihobonai ekarahi Olibe oeona eao, i'abana haukia ia murinai teao. ");
INSERT INTO rro_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","'Eka weianai tekara'au raninai ia ehina benakia etibaha, “Tomobahuba'ari baihobo aonai a'i tomototo.” ");
INSERT INTO rro_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Herekiai ekaobo baiatakia ena homa'a matoha pihara ha pahakapona peao pe'eho ihobonai weia ekaipehu ebahuba'ari. ");
INSERT INTO rro_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","E'abi etibaha, “Hama'u e, konuatae raninai haiara 'erena neiana here'uai koa'i obona, iamo au e'u nuataeai aha'i, 'a oi emu nuatae mobabaina.” ");
INSERT INTO rro_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ba aneru ha kupai emai ia herenai ewaira tina, ebataburana. ");
INSERT INTO rro_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Aona earo'ari, ebahuba'ari haeamona ebahuba'ari tabura tabura, maorona te'eho 'anoai ihobona aruaru kokoma'akia 'abana. ");
INSERT INTO rro_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ena bahuba'ari murinai emikiri eao i'abana haukia herekia, aoko'oai aba temahe harai buonai parua reakia etabu ahinakia. ");
INSERT INTO rro_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ehina benakia etibaha, “Taba buonai tuparua? Tomono'a, tomobahuba'ari baihobo aonai a'i tomototo marikina.” ");
INSERT INTO rro_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Iesu ni'abi oho mo aonai i'abana harauhaea rua haukia 'abakia ha atana Iuda to'u rarina e'uai ainakia temai, ba ekahaha Iesu herena eao kepauna. ");
INSERT INTO rro_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","'A Iesu ehore Iuda ehina bena etibaha, “Oi hanona baipauai Maearima Nahuna nohinahinaina, u?” ");
INSERT INTO rro_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Weiakia herenai tekoroti haukia taba kerama hauna te'iobina aonai te'abi tetibaha, “Obiapaka e, karebai tamaharanakia, u?” ");
INSERT INTO rro_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ba 'abakia ha robe haukia 'arakiai hauna ena ta'ara a'i hauna haiana itipana ehara obona. ");
INSERT INTO rro_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","'A Iesu e'abi etibaha, “Naiana mepua.” Ba ia ehore hau weiana haiana ea'i 'apuana ebanamona. ");
INSERT INTO rro_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Iesu ehore robe haukia apa'uakia marea robe 'ima haukia mai aiara hau apa'uakia temai ia katea'ina haukia ehina benakia etibaha, “Mai karebami mai pura'ami tomai matoha bainao hauna katoa'ina 'abana, u? ");
INSERT INTO rro_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Rani ikoinai au hanona wai kipokia marea robe aonai, iamo wai a'i toa'i 'inina'u. 'A bariu rani neiana hanona wai emi rani, wapura ena hiabu ranina.” ");
INSERT INTO rro_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ia tehore Iesu tea'ina tebaka'ana teaoaina robe haukia 'arakiai hauna ena ituai, 'a Petero hanona murikiai eao ia mo mai baiatakia. ");
INSERT INTO rro_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Baika tehore ara aona ibuanai iruba teba'arana ba temia kakaiarona, Petero abomo weia baiatakia emiati. ");
INSERT INTO rro_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ba ta'ara a'i uahona ha iruba eanai Petero emiati eihana, eiha iha haraina e'abi etibaha, “Hau neiana hanona Iesu 'abana ha.” ");
INSERT INTO rro_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","'A Petero ebuniai etibaha, “Uaho e, au ia a'i a'iobina.” ");
INSERT INTO rro_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Rani a'i ehoma'a aonai, hau ha ia eihana e'abi etibaha, “Oi abomo 'abakia ha.” Petero e'abi etibaha, “Hau e, au hanona aha'i.” ");
INSERT INTO rro_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Beraura hoana ha eao 'abana hau ha ia eihana ba e'abi tabura etibaha, “'Abi tohana hau neiana abomo ia 'abana ha, pokina ia abomo Galilea hauna.” ");
INSERT INTO rro_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ba Petero e'abi etibaha, “Hau e, au a'i a'iobina oi taba robana nuahuna.” Ni'abi oho mo aonai kokoro'u e'arara. ");
INSERT INTO rro_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Weiana Obiapaka eiha kabe Petero eihana. Ba Petero ehore Obiapaka ena 'abi ehinana hauna eraona tinana, “Oi bariu rani neianai kokoro'u a'i ke'arara baha aonai au rani aihau kobuniai aina'u.” ");
INSERT INTO rro_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Weiana Petero ekarahi eao atapakai ehai ki'a. ");
INSERT INTO rro_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Hau weiakia Iesu tea'i 'inina haukia tebatae aina. ");
INSERT INTO rro_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Mahana te'apa abunakia te'atina ba tebakaina tetibaha, “Mohina benamai. Tai oi e'atini'o?” ");
INSERT INTO rro_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Abomo 'abi ki'a obokia bo'ona herenai tehinanakia. ");
INSERT INTO rro_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Erani aonai aiara hau apa'uakia, robe haukia apa'uakia, mai rauhubu poki haukia kipokia teto'u ba Iesu temaiaina bakai apa'uana weiana wairakiai. ");
INSERT INTO rro_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Bakai apa'uana haukia tebakaina tetibaha, “Mohina benamai. Oi hanona Keriso, 'ao?” 'A Iesu ia ehina benakia etibaha, “Pahina benimi hanona a'i patobatohana'u. ");
INSERT INTO rro_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Abomo pabakainimi hanona a'i patobamuena. ");
INSERT INTO rro_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ia bariu rani neiana keaoaina hanona Maearima Nahuna hiabu Tiramana imana itipana tainai kemiati.” ");
INSERT INTO rro_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ia ikoikiai tebakaina tetibaha, “Ba oi hanona Tirama Nahuna, u?” Weiana Iesu ia ehina benakia etibaha, “'E, aba tu'abi mo naia.” ");
INSERT INTO rro_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ba ia te'abi tetibaha, “Taba buonai hinau 'abikia nahatabunakia? Aika aba ia kipona pinanai Tirama nia'i ki'ana aiana haona.” ");
INSERT INTO rro_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Weiana bakai apa'uana haukia maikoina temikiri Iesu teaoaina Pilato herena. ");
INSERT INTO rro_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Weia ena beho 'abikia tea'i ramana tetibaha, “Hau neiana tatabu ahina emai hanopaka maearimakia aokia niana aiara niba'uri 'urina mai obia arana herenai takiti katabaibeni hauna nikaiabuna, abomo kipona ni'abi ia hanona Keriso, obia arana.” ");
INSERT INTO rro_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ba Pilato ehore Iesu ebakaina etibaha, “Oi hanona Iuda haukia ekia obia arana, u?” Ia ena 'abi ebamuena etibaha, “'Abimo naiana aba nohinana.” ");
INSERT INTO rro_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilato ehore robe haukia apa'uakia mai to'u haukia ehina benakia etibaha, “Au hau neiana herenai beho ha a'i atabu ahina.” ");
INSERT INTO rro_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ia te'abi tabura tetibaha, “Ena ba'iobi 'abikiai Iuda maearimakia aba eba'uri 'urinakia, weia Galilea ai ea'i ramana emai mo aba 'eka neianai ekara'au.” ");
INSERT INTO rro_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilato 'abi weiana 'uruna eona hanona ebakai bakai hau neiana Galilea hauna 'ao. ");
INSERT INTO rro_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pilato e'iobina Iesu hanona Heroda ena iha'ini ba'anai buonai euhuna teaoaina Heroda herena, rani weianai Heroda abomo weia Ierusalema ai. ");
INSERT INTO rro_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Heroda Iesu eihana raninai aona enamo ki'a pokina aba wa'i baha 'akinai Iesu pouna eona, enuatae ia peihana abomo ena nuatae Iesu hoa baika pebabai peihanakia. ");
INSERT INTO rro_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ua buonai 'abi bo'okiai ebakaina, 'a Iesu ia ena 'abi ha a'i ebamuena. ");
INSERT INTO rro_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Robe haukia apa'uakia mai rauhubu poki haukia weia tekoroti te'abi pahihi herenai. ");
INSERT INTO rro_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ba Heroda mai ena huari haukia kipokia Iesu tebapo'ona, 'abi ki'a obokia haeai haeai tehina murinai, obia habunina ha tebabatotona, haeamona temue aina teaoaina Pilato herena. ");
INSERT INTO rro_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Rani weianai Heroda mai Pilato hanona tebaihau, ia 'uainai terarua hanona tebai'oata. ");
INSERT INTO rro_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato ehore robe haukia apa'uakia aiara obiakia mai aiara maearimakia eaparinakia ebato'unakia. ");
INSERT INTO rro_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ehina benakia etibaha, “Hau neiana tomaiaina here'uai to'abi, maearima aokia niani aiara niba'uri 'urina, ia au wairamiai 'abi weiakia tohina herenai haukia abakaina hanona ena ki'a ha a'i atabu ahina. ");
INSERT INTO rro_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Heroda abomo ua homana buonai euhuna emue emai hereka, katoihana ia hanona 'ari akana ha a'i ebabaina. ");
INSERT INTO rro_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Weiana buonai ka'atina ba kahabona keao.” ");
INSERT INTO rro_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Rani ikoinai Kabanai tatuna aonai Pilato ena hoa hoa tainai wapura hauna ha ebakarahina. ");
INSERT INTO rro_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","'A mako teio haeamo tetibaha, “Hau neiana moahu 'arina! Baraba morubuna mobenamai!” ");
INSERT INTO rro_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Baraba hanona aba ua'a wapura 'ekanai emiaho pokina aiara apa'uana aonai baripuripu mai ahuahu ebaramanakia paunai. ");
INSERT INTO rro_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato ena nuatae hanona Iesu pebakarahina paunai to'u haukia ehinabe muenakia. ");
INSERT INTO rro_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","'A to'u haukia teio hao io hao tetibaha, “Matiu ibiri ropo 'ubinai me'ari! Matiu ibiri ropo 'ubinai me'ari!” ");
INSERT INTO rro_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilato rani ibaihauna to'u haukia ehinabe muenakia, “Hau neiana beho tabana ebabaina? Ia ke'ari hauna behona ha a'i atabu ahina. Ua paunai ka'atina ba kahabona keao.” ");
INSERT INTO rro_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","'A to'u haukia teio to'o baihana aiakia 'ubi tohanai Iesu matiu ibiri ropo 'ubinai ke'ari. Ekia ioai Pilato etara haona. ");
INSERT INTO rro_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ua buonai Pilato ehore ekia nuatae ebabaina Iesu behoai ehorotina. ");
INSERT INTO rro_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pilato ehore hau weiana baripuripu mai ahuahu ebaramanakia paunai wapura 'ekanai tehorotina hauna ebakarahina ekia noinoi ihobonai, ba Iesu ebenakia ekia nuatae akakia katebabai. ");
INSERT INTO rro_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Huari haukia Iesu tebaka'ana teaoaina aonai Kurene hauna ha atana Simona ia hanona 'uniai emai Ierusalema niao tetabu ahina ba tea'ina matiu ibiri ropo tebabua ahina Iesu murinai eka'a aina. ");
INSERT INTO rro_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Maearima bo'ona 'akina Iesu murina te'au baiatakiai babi'e baika ia teaoko'o aina tehai. ");
INSERT INTO rro_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Iesu ekabe ehina benakia etibaha, “Ierusalema nahuna babi'emi e, au a'i tomohai aina'u, 'a wai mai nahumi kipokia paumiai tomohai. ");
INSERT INTO rro_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Pokina rani kemai aonai maearima kate'abi katetibaha, ‘Babi'e te'one 'one miori a'i tebarama, mai a'i teba'ae ba'ae babi'ekia hanona namo tea'ina.’ ");
INSERT INTO rro_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Weiana ‘kobio katehina benakia, “tomo'eho ahamai ai”, mai oeo katehina benakia, “tomobahu abunamai.” ’ ");
INSERT INTO rro_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Au matiu maurina 'abana here'uai ṉa tibabai aiho raninai, wai matiu 'ororona 'abana heremiai aea patebabai aihona?” ");
INSERT INTO rro_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Beho haukia rua abomo tebaka'anakia teaoainakia Iesu kipokia kateahu 'arinakia. ");
INSERT INTO rro_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Temai 'eka atana ‘'Ara huriana’ ai tekara'au aonai, Iesu matiu ibiri ropo ahanai tekoko 'auna beho haukia rua kipokia hamona itipanai, ha awarinai. ");
INSERT INTO rro_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ba Iesu e'abi etibaha, “Hama'u e, mohina haonakia pokina ia a'i te'iobina taba tibabaina.” Weiana huari haukia pu'i ai ena habuni tewatena. ");
INSERT INTO rro_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Maearima tekoroti tebaiaruru, aiara obiakia tehore Iesu tebapo'ona te'abi tetibaha, “Ia maearima haeai ebamaurinakia, ba ia Tirama ena Keriso Tirama etina'ana hauna raninai kipona mebamaurina.” ");
INSERT INTO rro_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Huari haukia abomo tebapo'ona tekahaha herena bine beina manoina tebena. ");
INSERT INTO rro_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ba tehina bena tetibaha, “Oi Iuda ekia obia 'arana raninai kipomu mobamaurini'o.” ");
INSERT INTO rro_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Iesu 'arana ubinai marere ha abomo weia ṉa terere aihona, ");
INSERT INTO rro_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Beho haukia weia tekapa'au haukia ha Iesu ebapo'ona e'abi etibaha, “Oi bamauri haumu 'ao aha'i? Kipomu mobamaurini'o ai abomo mobamaurinamai.” ");
INSERT INTO rro_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","'A 'abana ehore erikena etibaha, “Oi puma ihobona nua'ina mo Tirama a'i nuta'u aina, u? ");
INSERT INTO rro_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Aika hararua kaha'ari hanona ebero, pokina puma naha'ina hauna hanona eka babai ihobonai, 'a hau neiana hanona taba ha'i ebabai ki'ana.” ");
INSERT INTO rro_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Haeamona ia e'abi etibaha, “Iesu e, emu obia aiarana kokatoto raninai au koraonana'u.” ");
INSERT INTO rro_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Iesu ia ehina bena etibaha, “'Abi tohana au oi nahina beni'o, bariu rani neianai oi mai au hararua hanona paradiso aonai kahamiaho.” ");
INSERT INTO rro_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ihobona matoha atiaha hororo aonai beraura ewapura, abomo wapura hanopaka maikoina ekaiabuna eaomo beraura hoana aihau. ");
INSERT INTO rro_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Abomo marea robe aona i'aea hurina habunina etapa boana rua. ");
INSERT INTO rro_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Iesu eapari aota, “Hama'u e, auba'u imamuai nautana.” Ua e'abi aiho murinai e'ari. ");
INSERT INTO rro_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Weiana huari poki hauna taba terama haukia eihanakia aonai Tirama ebanamona etibaha, “'Abi tohana hau neiana hanona bero hauna.” ");
INSERT INTO rro_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Baiaruru haukia weia teto'una taba terama teihanakia raninai, haharakia teahu ahunakia mai aoko'okia temue aiara teao. ");
INSERT INTO rro_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","'A Iesu te'iobina haukia ikoikiai mai babi'e weiakia murinai te'au Galileai temai haukia atau'ai tekoroti taba terama haukia teihanakia. ");
INSERT INTO rro_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Bakai apa'uana hauna ha atana Iosepa ia hau namona abomo aka bero hauna, ");
INSERT INTO rro_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ena aiara hanona Arimatea Iudea aiarana ha, Tirama ena obia aiarana ne'imana kemai. Ia bakai apa'uana haukia ekia raona mai babai a'i ea'i taeanakia. ");
INSERT INTO rro_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Hau neiana eao Pilato herena Iesu hauanina enoi aina. ");
INSERT INTO rro_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Weiana ia Iesu hauanina ea'i obona habuni imukinai e'apana 'ariahana pihara tekuina 'urina aonai ehorotina, 'uri weiana hanona tai aha'i tihore bahana. ");
INSERT INTO rro_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Rani weiana hanona a'ia'i harai wapuna abomo beraura robena aba kea'i ramana. ");
INSERT INTO rro_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Babi'e weiakia Iesu kipokia Galileai temai babi'ekia Iosepa murinai teao, 'ariahana mai Iesu hauanina aea tebaenoti aihona teiha haraina. ");
INSERT INTO rro_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Weiana ia temue teao aiara muramura timikia namokia mai hauna katetarona tehorokia teba'orunakia. Ba beraura robenai tearai rauhubu taina. ");
INSERT INTO rro_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Hui beraurana kori 'uainai raurani 'amari 'amarinai babi'e muramura timikia namokia teba'orunakia haukia tea'inakia 'ariahana teao. ");
INSERT INTO rro_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","'Ariahana ikaiabuna piharana aba ehere pare atau'ai teihana. ");
INSERT INTO rro_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ia 'ariahana aonai tetoto raninai Iesu Obiapaka hauanina a'i teihana. ");
INSERT INTO rro_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Weiana paunai tekoroti aokia earo'ari aonai hau rua ekia habuni 'imare 'imarekia beronai herekia tekoroti. ");
INSERT INTO rro_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Babi'e teta'u ki'a tekuti wairakia 'ano eao, hau rua babi'e tebakainakia tetibaha, “Taba buonai emauri hauna 'ari haukia baiatakiai tutabuna. ");
INSERT INTO rro_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ia hanona neia aha'i. Ia aba emikiri mue! Galileai emiaho oho aonai wai ehina benimi 'abina tomoraonana. ");
INSERT INTO rro_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Etibaha, ‘Maearima Nahuna hanona ki'a haukia imakiai kateutana, matiu ibiri ropo 'ubiai kateahu 'arina haeamona wapu ibaihauna murinai kemikiri mue.’” ");
INSERT INTO rro_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Weia ia Iesu ena 'abi teraona tinanakia. ");
INSERT INTO rro_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","'Ariahanai temue temai raninai taba neiakia ikoikiai i'abana haukia harauhaea hamomo mai harina baika herekiai tehinanakia. ");
INSERT INTO rro_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Babi'e neiakia Maria Magadala babi'ena, Ioana, Iakobo hinana Maria, mai babi'e baika te'abanakia haukia kipokia pou neiana iuhubeau haukia herekia tehinana. ");
INSERT INTO rro_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Iamo iuhubeau haukia babi'e ekia 'abi ori 'abaeanai tebaona buonai a'i tebatohana. ");
INSERT INTO rro_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","'A Petero emikiri ebeau eao 'ariahana. Ekuti aona eribana te'apana habunikia mo weia kipokia tenoti 'abaea eihanakia, emue ena itu eao aonai kipona aona earo'ari taba weiana erama hauna paunai. ");
INSERT INTO rro_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Rani weiana hamona aonai Iesu i'abana haukia rua tiao aiara ha atana Emao, aiara weiana mai Ierusalema baiatakia ena homa'a hanona kilometa harauhaea hamomo 'abana. ");
INSERT INTO rro_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Taearai teka'a aonai taba neiakia ikoikiai terama haukia terarua baiatakiai te'abi 'abi ainakia. ");
INSERT INTO rro_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ba terarua te'abi 'abi mai terobahu aonai Iesu kipona emai herekia teka'a oioi. ");
INSERT INTO rro_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","'A maearimana teihana ia a'i te'iobina ia hanona Iesu. ");
INSERT INTO rro_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Iesu ia ebakainakia etibaha, “Wai torarua ka'amiai taba robana tuahuna?” Terarua tekori 'ororo wairakia mai birabirakia. ");
INSERT INTO rro_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ha weiana atana Kaleapa ebakai bakai etibaha, “Ierusalema aonai oi pa'e ikupaiamu mo taba rani murikai terama haukia a'i o'iobinakia?” ");
INSERT INTO rro_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ia ebakainakia etibaha, “Aka tabakia?” Hau rua tetibaha, “Iesu Nasareta hauna pouna. Ia hanona mahabanai hauna, Tirama mai maearima ikoikiai wairakiai ena 'abi mai aka tehiabu wairai. ");
INSERT INTO rro_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Robe haukia apa'uakia mai aiara haukia apa'uakia ia Roma haukia tebenakia matiu ibiri ropo 'ubinai teahu 'arina. ");
INSERT INTO rro_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","'A ai taraonana ia hanona aika Isaraela hauka kebamaurinaka hauna. Haeamona taba neiakia terama wapu aihau teore. ");
INSERT INTO rro_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Babi'e baika baiatamai ai tebata'u ta'u hurinamai. Ia raurani amarinai teao 'ariahana hanona ");
INSERT INTO rro_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Iesu hauanina a'i tetabu ahina temue temai te'abi aneru teihanakia abomo aneru weiakia ia tehina benakia, ‘Iesu hanona aba emauri mue.’ ");
INSERT INTO rro_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ba 'abamai baika teao 'ariahana teihana hanona babi'e te'abi ihobonai mo tetabu ahina, 'a Iesu hauanina a'i teihana.” ");
INSERT INTO rro_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Iesu ehina benakia etibaha, “Hama ṉa topo'o aiho abomo mahabanai haukia taba tehina haukia ibatohakiai aomi temahari. ");
INSERT INTO rro_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Keriso ṉa kehaiara aiho 'uai ba ena nuabi aonai ketoto, weiana a'i ṯo'iobina, u?” ");
INSERT INTO rro_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Iesu hanona Mose mai mahabanai ekia rere rereai ea'i ramana Puka Robena aonai ia kipona 'abina maikoinai hau rua eba'iobinakia. ");
INSERT INTO rro_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Aiara tiao hauna aba herekiai ba Iesu hanona kekabero ṉa ehoma. ");
INSERT INTO rro_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","'A terarua tebamuena te'abi tetibaha, “Beraura aba kekaihuna abomo aba kerabi, kipokia pahamiaho.” Ba ia ekatoto kipokia katemiaho. ");
INSERT INTO rro_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Weiana aniani 'ekanai kipokia temiati raninai Iesu ehore parawa ea'ina ebanamona ehobina terarua ebenakia. ");
INSERT INTO rro_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ba mahakia teno'a aokia tea weia te'iobina ia hanona Iesu, haeamona wairakiai e'akauma 'abaea. ");
INSERT INTO rro_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ia terarua kipokia te'abi tetibaha, “Taearai ehina benaka abomo Puka Robena 'abikia eba'iobinaka raninai matoha iruba aokai eara, uhe?” ");
INSERT INTO rro_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Terarua beronai temikiri temue Ierusalema teao, i'abana haukia harauhaea hamomo 'abakia kipokia tito'u haukia tetabu ahinakia. ");
INSERT INTO rro_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ia hau rua tehina benakia tetibaha, “Obiapaka hanona emikiri toha, Simona herenai ewaira tina.” ");
INSERT INTO rro_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Weiakia terarua taearai taba erama pouna abomo parawa ehobina aonai aokia ea Iesu te'iobina pouna tehinanakia. ");
INSERT INTO rro_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","'Abi weiakia tehina oho mo aonai Iesu tohana ia baiatakiai ekoroti abomo e'abi etibaha, “Baibua wai heremiai!” ");
INSERT INTO rro_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ia ikoikiai teta'ukia mai ubo ea'inakia, teraonana biriua teihana. ");
INSERT INTO rro_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","'A Iesu ehina benakia etibaha, “Ae homa buonai tuta'u mai aomi tikai'au kai'au. ");
INSERT INTO rro_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ima'u mai ae'u tomoihanakia tomoa'i hobona'u tomo'iobina'u, Ṉahuna au toha'u pokina auba hanona bitiona mai huriana aha'i ia au hanona mai eu'u.” ");
INSERT INTO rro_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","'Abi weiana ehinana murinai imana mai aena ebaihanakia. ");
INSERT INTO rro_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ia teaonamo ki'a baha paunai Iesu a'i tebatoha bahana aokia raona raona ebonu buonai ia ebakainakia etibaha, “Wai taba katoani hauna ha ṉa'a?” ");
INSERT INTO rro_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ia maia ha aba eawati hauna hana papana tebena. ");
INSERT INTO rro_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Weiana ia ea'ina wairakiai eana. ");
INSERT INTO rro_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ba Iesu ia ehina benakia etibaha, “Au wai heremiai amiaho oho aonai taba robakia ahu haukia neiakia, Au pou'u tererenakia Mose ena rauhubuai mahabanai haukia ekia rere rereai mai Salamo aonai haukia ikoikiai katetoha.” ");
INSERT INTO rro_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Weiana aokia ebaeanakia Puka Robena obona kateobo. ");
INSERT INTO rro_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Haeamona Iesu ia ehina benakia etibaha, “Puka Robenai ṉa terere aihona. Bamauri hauna hanona kehau haiara abomo 'ariai kemikiri mue wapu ibaihaunai. ");
INSERT INTO rro_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ia atanai raona kabe mai ki'a ihina haokia poukia kateiroro ainakia Ierusalema ai katea'i ramana keaomo hanopaka ikoikiai aokiai. ");
INSERT INTO rro_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Wai hanona taba neiakia poukia ibatohakia haumi. ");
INSERT INTO rro_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Aia'u tomona. Hama'u Auba Robe e'uahi 'uaina hauna au kipo'u kauhuna kemai ahamiai, 'a wai hanona Ierusalema aonai katobai'ima keao mo hiabu 'ubiai kemai hauna katoa'ina.” ");
INSERT INTO rro_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Iesu ia aiara apa'uanai ebakarahinakia teao Betani herena tainai, ba imana ea'i taea banamo ebenakia. ");
INSERT INTO rro_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Nibanamonakia aonai Tirama ehore herekiai ea'i taeana eaoaina kupa. ");
INSERT INTO rro_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ia tekuti aina ba mai aonamokia temue teao Ierusalema. ");
INSERT INTO rro_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Rani ikoinai teao Marea Robe aonai temiaho Tirama tebanamona. ");
INSERT INTO rro_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Bahabana 'akinai hanopaka a'i erama baha aonai 'Abi hanona aba ua'a, 'Abi hanona Keriso, 'Abi hana Tirama ohi temiaho, 'Abi hanona Tirama. ");
INSERT INTO rro_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ia hana bahabana 'akinai Tirama ohi temiaho. ");
INSERT INTO rro_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Tirama ebabai tabakia ikoikiai hana 'Abi weianai terama, terama tabakia ikoikiai hanona ha kipona a'i erama. ");
INSERT INTO rro_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","'Abi hanona mauri pokina, ba mauri weiana hanona maearima ekia ea. ");
INSERT INTO rro_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ea hanona e'ara wapura aonai, ia wapura hana ea a'i nihao abuna. ");
INSERT INTO rro_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Tirama hau ha euhuna emai, ia atana hanona Ioane. ");
INSERT INTO rro_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ia emai maearima herekiai ea pouna kehinana, ia paunai maearima ikoikiai ea pouna kateona ba katea'ikakauma. ");
INSERT INTO rro_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ia kipona hanona ea weiana aha'i, ia ea pouna kehinana paunai emai. ");
INSERT INTO rro_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ea tohana hanona emai hanopakai maearima ikoinai herekiai kebaeanakia. ");
INSERT INTO rro_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ia hanona hanopaka aonai, hanopaka hanona ia 'eunai erama, iamo hanopaka hanona ia a'i e'iobina. ");
INSERT INTO rro_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ia ena hanopaka tohana haukia herekia emai, ia kipona ena maearima tohakia hanona a'i tea'i taeana. ");
INSERT INTO rro_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ia tia'i taeana mai atana tia'ikakaumana haukia ikoikiai hanona bero ebenakia Tirama nahunai kateao. ");
INSERT INTO rro_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Tirama nahunai teao haukia hanona maearima ekia rama taearanai aha'i, 'ao hauani ena nuataeai aha'i, 'ao maearima ha ena nuataeai aha'i, ia Tirama ena nuataeai terama. ");
INSERT INTO rro_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","'Abi weiana hanona maearima hauaninai emai, baiatamai ai kipokia tamiaho. Ena nuabi taihana, nuabina weiana hanona Hamana herenai emai Nahuna hamohamona 'euna, ia aonai aoko'o hoana mai 'abi tohana ebonu 'auna. ");
INSERT INTO rro_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ioane ehore ia pouna ehinana eio etibaha, “Au pouna ahinana hauna hanona neiana, atibaha, ‘Au muri'uai nimai hauna etara haona'u pokina ia hauna emiaho 'uai ba au arama.’” ");
INSERT INTO rro_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ia aoko'o hoanai ebonu 'auna ba aika ikoikai banamo ia herenai naha'ihao a'ihaona. ");
INSERT INTO rro_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Tirama rauhubu ebenaka Mose imanai, ia aoko'o hoana mai 'abi tohana hanona Iesu Keriso herenai temai. ");
INSERT INTO rro_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Hau ha Tirama a'i eiha 'apuana, 'a Nahuna hamohamona Tirama herena 'akinai nemiaho mai ia kipona abomo Tirama, ia hauna ehore Tirama eba'iobinaka. ");
INSERT INTO rro_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Weia Ierusalemai Iuda haukia apa'uakia tehore robe haukia mai Lebi haukia teuhunakia teao Ioane herena katebakaina ia hanona tai. ");
INSERT INTO rro_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ioane a'i ebuniai ia ehina pou haraina etibaha, “Au hanona Keriso aha'i.” ");
INSERT INTO rro_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ia tebakaina tetibaha, “Ba oi hanona tai? Oi hanona Elia?” Ia e'abi etibaha, “Au Elia aha'i.” Ia tebakai muena tetibaha, “Oi mahabanai haumu 'ao?” Ekia 'abi ebamuena etibaha, “Aha'i.” ");
INSERT INTO rro_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ua buonai ia tehina bena tetibaha, “Mohina benamai oi hanona tai. Emu 'abi kataeaoaina teuhunamai haukia katahina benakia. Oi kipomu poumu aea nohina aihona?” ");
INSERT INTO rro_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ioane ekia 'abi ebamuena etibaha, “Au hanona mahabanai hauna Isaia ena rererere 'abina, ia e'abi etibaha, ‘Aia ha hano'akunai eio hauna etibaha, Obiapaka ena ka'a taearana tomobaberona kekana.’” ");
INSERT INTO rro_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Baika hanona Parisea haukia teuhunakia haukia, ");
INSERT INTO rro_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","haeamona tebakaina tetibaha, “Oi Keriso aha'i 'ao Elia aha'i 'ao mahabanai haumu aha'i raninai aehoma buonai nuba'uere robe?” ");
INSERT INTO rro_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ioane ehina benakia etibaha, “Au beiai naba'uere robenimi, 'a wai baiatamiai a'i ṯo'iobina hauna ha ekoroti. ");
INSERT INTO rro_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ia hanona muri'uai nimai, iamo ia eapa'ua ba au, ia ena tamaka warokia karubunakia abomo here'uai a'i ketaina.” ");
INSERT INTO rro_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Neiakia ikoikiai hanona Ioane Ioridana ate abirana Betaniai eba'uere robe aonai terama. ");
INSERT INTO rro_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Erani Ioane ehore Iesu eka'a herena nimai hanona eihana ba e'abi etibaha, “Tomoihana Tirama ena mamoe nahuna hanopaka ena ki'a ibua parena hauna. ");
INSERT INTO rro_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Maraniai au robana ahuna hauna neiana atibaha, ‘Muri'uai nimai hauna hanona au etara haona'u, pokina ia emiaho 'uai ba au arama.’ ");
INSERT INTO rro_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Au kipo'u ia a'i a'iobina, ia au amai beiai kaba'uere robe hana ia kabawaira tinana Isaraela haukia ia kate'iobina paunai.” ");
INSERT INTO rro_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ba Ioane ia pouna ehinana etibaha, “Au Auba Robe aihana rauria 'abana kupai eriri ia ahanai ehiri'au. ");
INSERT INTO rro_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Au a'i a'iobi bahana, ia weiana euhuna'u beiai kaba'uere robe ṉa ehoma Tiramana ehina bena'u etibaha, ‘Ahanai Auba Robe keriri kehiri'au koihana hauna ko'iobina ia hanona Auba Robe ai keba'uere robe.’ ");
INSERT INTO rro_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Au maha'uai aba aihana ba nahina pouna neiana hana Tirama Nahuna.” ");
INSERT INTO rro_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Erani Ioane haeamona weia i'abana haukia rua kipokia tekoroti. ");
INSERT INTO rro_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ia Iesu nikabanai eihana raninai e'abi etibaha, “Tomoihana Tirama ena mamoe nahuna.” ");
INSERT INTO rro_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ioane i'abana haukia rua ia e'abi aiana teona raninai teao Iesu murinai teka'a. ");
INSERT INTO rro_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Iesu eiha kabe murinai tika'a haukia eihanakia ba ebakainakia etibaha, “Wai taba ṯonuatae aina?” Ia ena 'abi tebamuena tetibaha, “Rapi e, oi ae'eai nomiaho?” (Maeakiai Rapi anina hanona ‘ba'iobi hauna.’) ");
INSERT INTO rro_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ia ehina benakia etibaha, “Tomai tomoihana.” Ba teao ena emiaho 'ekana teihana, weiana hanona beraura ebaeno hoana bani, ia kipokia temiaho. ");
INSERT INTO rro_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Weiakia terarua Ioane e'abi aiana teona abomo Iesu murinai teao haukia ha hanona Anderea, ia hanona Simona Petero hatina. ");
INSERT INTO rro_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Anderea beronai a'ana Simona etabu ahina ba ehina bena etibaha, “Ai Mesia aba tatabu ahina.” (Mesia anina hanona Keriso, Bamauri hauna.) ");
INSERT INTO rro_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ba ia Simona eaoaina Iesu herena. Iesu Simona eiha 'ini 'inina e'abi etibaha, “Oi atamu hanona Simona, Ioane nahuna, bariu oi atamu kateaparina Kepa.” (Kepa hanona ihobona Petero, anina hanona pihara.) ");
INSERT INTO rro_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Erani Iesu enuatae keao Galilea aonai, Pilipo etabu ahina ba ehina bena etibaha, “Muri'uai omai.” ");
INSERT INTO rro_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilipo hanona Betesaida hauna Anderea mai Petero 'abakia. ");
INSERT INTO rro_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilipo ehore Natanaela etabu ahina ehina bena etibaha, “Mose rauhubu aonai pouna ererena abomo mahabanai haukia ekia pukai tererena hauna ai aba tatabu ahina. Ia hanona Nasareta hauna Iesu, Iosepa nahuna.” ");
INSERT INTO rro_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaela ehore ebakai bakai, “Nasareta ai taba namona ha ua'a ha kerama ketaina, u?” Pilipo etibaha, “Omai mo, moihana.” ");
INSERT INTO rro_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Iesu Natanaela eka'a herena nimai eihana raninai pouna ehinana, “Ia hana Isaraela hauna tohana. Ia aonai bai'oi hoana ha aha'i.” ");
INSERT INTO rro_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaela ehore ebakaina, “Aea o'iobi aihona'u?” Iesu ia ena 'abi ebamuena etibaha, “Oi suke matiuna ba'anai aiha 'uaini'o ba Pilipo eaparini'o.” ");
INSERT INTO rro_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ba Natanaela e'abi etibaha, “Ba'iobi haumu e, oi hana Tirama nahuna. Oi hana Isaraela ekia obia arana.” ");
INSERT INTO rro_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Iesu ia ehina bena etibaha, “Au a'abi suke matiuna ba'anai aihani'o buonai nua'ikakaumana'u, u? Neiana mo aha'i, wairai oi hana taba rarikia koihanakia.” ");
INSERT INTO rro_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Haeamona ehina benakia etibaha, “'Abi tohana au wai nahina benimi, kupa kekaikau Tirama ena aneru katekara'au kateriri au Maearima Nahuna aha'uai katoihanakia.” ");
INSERT INTO rro_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Wapu rua murinai Galilea Kana aiarana aonai hawainibe tatuna ha erama. Iesu hinana hanona weia, ");
INSERT INTO rro_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Iesu mai i'abana haukia kipokia abomo tebeaunakia teao hawainibe tatuna weianai. ");
INSERT INTO rro_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Tatu aonai bine beina teinu orena raninai Iesu hinana ehore Iesu haianai e'abi etibaha, “Ia herekiai bine beina aba eore.” ");
INSERT INTO rro_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Iesu e'abi etibaha, “Hina'u, taba buonai ekia aro'ari hauna au nubena'u. Au e'u rani a'i nitai bahana.” ");
INSERT INTO rro_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ia hinana ta'ara'i haukia ehina benakia etibaha, “Ia taba ṉa keho hanona maikoinai katobabai.” ");
INSERT INTO rro_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Weia pihara puoukia 'abaihau tekoroti, Iuda haukia ekia hoahoa taikia weia bei katerai'au imakia mai aekia kateutu, puou ha ha aokiai beibei matoha harau rua 'ao harau aihau 'abakia. ");
INSERT INTO rro_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Iesu ta'ara'i haukia ehina benakia etibaha, “Puou aokiai bei tomoba bonunakia.” Ua buonai teheinakia tebabonu teao 'ako'akokiai. ");
INSERT INTO rro_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ba ia ehina benakia etibaha, “Bariu harua tomorai 'aunakia tomoaoaina tatu iha'ini hauna tomobena.” Ba harua teraina teaoaina ia tebena. ");
INSERT INTO rro_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Tatu neiha 'inina hauna bei weiana bine beinai eao hauna einu hobona, ae'e ai emai hanona ia a'i e'iobina, ta'ara'i haukia bei teraina haukia mo te'iobina. Ba iha'ini hauna hawainibe mahamaha hauna eaparina haiahaiai, ");
INSERT INTO rro_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","e'abi etibaha, “Maearima ikoikiai hanona bine beina namona tibeni 'uainakia, ba ṯeinu 'ari murinai bine beina 'ama'amana tibenakia, ia oi hanona bine beina namona obamauaina emai mo bariu obaibeni.” ");
INSERT INTO rro_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Iesu bata'uta'u huri hoana kori'uaina neiana ebabaina Galilea Kana aonai. Ena nuabi ebawaira tinana ba i'abana haukia ia tea'ikakaumana. ");
INSERT INTO rro_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Tatu neiana murinai Iesu hinana hatina mai i'abana haukia kipokia teao Kaperanauma ua'a temiaho wapu baika teao. ");
INSERT INTO rro_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Iuda haukia ekia Kabanai tatuna beraurana ekaibari buonai Iesu ekara'au Ierusalema eao. ");
INSERT INTO rro_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ua'a marea robe aonai hanona poromakau, mamoe, rauria tikawakawa ainakia haukia mai moni tia'i banai haukia temiati eihanakia. ");
INSERT INTO rro_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ba i'ati'ati 'anauana ha ebabaina 'anauai marea robe aonai poromakau mai mamoe ikoikiai eura ahinakia, moni a'ibanai haukia ekia moni ebarobo otarainakia ekia itara etori ku'a banainakia. ");
INSERT INTO rro_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Weiakia rauria tikawakawa ainakia haukia herekiai e'abi etibaha, “Neiakia tomoa'i katu'anakia 'eka neianai. Hama'u ena itu hanona wai emi kawakawa 'ekanai a'i tomobaona!” ");
INSERT INTO rro_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ba i'abana haukia Puka robena aba tererena 'abina teraona tinana, “Oi emu itu iraona'au aina hanona au ao'uai iruba niara 'abana.” ");
INSERT INTO rro_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ba Iuda haukia apa'uakia tehore Iesu tebakaina tetibaha, “Bata'uta'u huri hoana tabana ai kobaihanamai hanona katabatohani'o oi mai emu bero neiakia ikoikiai nubabai.” ");
INSERT INTO rro_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Iesu ekia 'abi ebamuena etibaha, “Marea robe neiana tomoahu 'iti'itina, au wapu aihau aonai kabakori muena.” ");
INSERT INTO rro_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Iuda haukia apa'uakia te'abi tetibaha, “Marea robe neiana tebabaina ihauna hanona bariabui 'abaihau, ia wapu aihau aonai aea kobakori mue aihona?” ");
INSERT INTO rro_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","'A Iesu marea robe robana eahuna hauna hanona ia kipona hauanina. ");
INSERT INTO rro_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Weiana Iesu 'ariai emikiri mue murinai ia i'abana haukia ena 'abi ehinana hauna teraona tinana. Ba Puka robena mai Iesu ehina 'abikia tebatohanakia. ");
INSERT INTO rro_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Iesu Kabanai tatuna aonai Ierusalema ai emiaho, maearima bo'ona bata'uta'u huri hoakia ebabai teihana hanona tea'ikakaumana. ");
INSERT INTO rro_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","'A Iesu kipona hanona maearima a'i ebatohanakia pokina ia hanona ikoinai e'iobinakia. ");
INSERT INTO rro_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Iesu kipona maearima aokiai ṯemiaho tabakia aba e'iobinakia paunai, hau ha a'i kehore maearima poukia ia herenai a'i kehinanakia. ");
INSERT INTO rro_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Parisea hauna ha atana Nikodemo ia hanona Iuda haukia ekia hau apa'uana ha. ");
INSERT INTO rro_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Rabi ha ia eao Iesu herena ehina bena etibaha, “Ba'iobi haumu e, ai ṯa'iobina oi hanona Tirama herenai omai. Oi bata'uta'u huri hoakia nubabai hanona Tirama ia herenai aha'i hauna ha a'i kebabaina hoakia oi nubabai.” ");
INSERT INTO rro_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Iesu ia ena 'abi ebamuena etibaha, “'Abi tohana au oi nahina beni'o, maearima ha a'i kerama mue raninai ia hanona Tirama ena obia aiarana a'i keiha 'apuana.” ");
INSERT INTO rro_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Weiana Nikodemo ebakai bakai etibaha, “Maearima aba eapa'ua raninai ia aea kerama mue aiho? 'Abi tohana rani ibaruana ia hinana nuanai a'i ketoto mue haeamona a'i kerama.” ");
INSERT INTO rro_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Iesu ia ena 'abi ebamuena etibaha, “'Abi tohana au oi nahina beni'o, maearima hanona beiai mai Auba Robeai a'i kerama mue raninai ia hanona Tirama ena obia aiaranai a'i ketoto 'apuana. ");
INSERT INTO rro_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Hauani nihore hauani nibaramana, ia Auba Robe nihore auba nibaramana. ");
INSERT INTO rro_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ahina beni'o korama mue 'abina hauna a'i kobaoao aina. ");
INSERT INTO rro_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Baura niabu nenuatae aina 'ekanai niao, ia oi hanona 'uruna mo nuona, ia ae'eai nimai 'ao aeana niao hanona a'i o'iobina. Auba Robe ai terama haukia ikoinai abomo uamo homana.” ");
INSERT INTO rro_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemo ehore ia ebakai muena etibaha, “Taba neiakia aea katerama aiho?” ");
INSERT INTO rro_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Iesu ia ehina bena etibaha, “Oi hanona Isaraela ena ba'iobi haumu apa'uana ha, ia aehoma buonai taba neiakia obokia a'i nuobo? ");
INSERT INTO rro_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","'Abi tohana au oi nahina beni'o, ai ṯa'iobi haukia ṯahinanakia, ai ṯaiha haukia ṯahina pounakia, ia emai 'abi ṯahina pou haukia a'i tua'i taeanakia. ");
INSERT INTO rro_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Au nahore hanopaka tabakiai nahina benimi hanona a'i tuba tohanakia, iamo kupa tabakiai kahina benimi raninai aea katobatoha aihonakia. ");
INSERT INTO rro_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Maearima ha a'i ekara'au 'apua kupa, iamo au Maearima Nahuna ikupaia'u mo kupai ariri amai. ");
INSERT INTO rro_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Hano'akunai Mose 'erau aubaubana eihi taeana ihobonai mo au Maearima Nahuna abomo kateihi taeana'u. ");
INSERT INTO rro_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Weiana tia'ikakaumana'u haukia ikoinai hanona mauri banaibanai katea'ina. ");
INSERT INTO rro_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Pokina Tirama hanopaka eraona'auai ki'a bahana paunai Nahuna hamohamona mo ebaibeni, tia'ikakaumana haukia ikoikiai hanona a'i kate'ari, ia mauri banaibanai katea'ina. ");
INSERT INTO rro_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Tirama nahuna euhuna hanopakai hanona puma kebaibeni paunai aha'i, ia paunai hanopaka 'arana kebamaurina. ");
INSERT INTO rro_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Tia'ikakaumana haukia ikoikiai hanona puma a'i katehoaina, ia a'i tia'ikakaumana haukia ikoikiai hanona aba puma tihoaina, pokina Tirama Nahuna hamohamona atana a'i tia'ikakaumana paunai. ");
INSERT INTO rro_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Bakai hanona ṉa eaka aiho. Ea aba emai hanopaka aonai, 'a maearima wapura 'arina ti'ari ia ea tibaki'ana, pokina ekia hoahoa hanona teki'a. ");
INSERT INTO rro_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Weiana ki'a tibabai haukia ikoikiai ea ti'oatana ba a'i timai ea aonai pokina ekia hoahoa ki'a obokia a'i temewaira tina ta'una. ");
INSERT INTO rro_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ia aka beronai timauri haukia hanona timai ea aonai pokina ekia hoahoa Tirama aiana tika'aina hauna katebawaira tinana.” ");
INSERT INTO rro_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Neiana murinai Iesu i'abana haukia kipokia tekarahi Iudea hanona teao, ia weia kipokia temiaho beraura baika teao ba eba'uere robe. ");
INSERT INTO rro_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ioane ba'uere robe hauna abomo Salima abirana Aenona ai eba'uere robe pokina weia hanona bei rarina mai maearima teao eba'uere robenakia. ");
INSERT INTO rro_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Weiana hanona Ioane wapura 'ekanai a'i tekaiabu bahana aonai. ");
INSERT INTO rro_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ba Ioane i'abana haukia baika mai Iuda hauna ha kipokia te'abi baitaeai ekia hoahoa weiana Tirama wairanai katebamaha mahana hauna paunai. ");
INSERT INTO rro_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ua buonai ia temai Ioane herena tehina bena tetibaha, “Ba'iobi haumu e, hau weiana Ioridana atena abiranai kipokia tomiaho pouna ohinana hauna ia bariu niba'uere robe, ba maearima ikoinai tiao herena.” ");
INSERT INTO rro_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ioane ekia 'abi ebamuena etibaha, “Maearima hanona Tirama kebaibeni hauna mo ketabu ahina. ");
INSERT INTO rro_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Wai kipomi abomo aba tubatohana'u au aba ahina benimi, ‘au hanona Keriso aha'i, ia au hanona euhu 'uaina'u ia wairanai.’ ");
INSERT INTO rro_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Hawainibe mahamahana babi'ena weiana hanona ia niatawana hauna 'eunai, ba hawainibe mahamahana hauna ena hau ia herenai nikoroti hauna hanona aiana niona raninai aonamo ni'opu abuna. Aonamona neiana hanona au 'eu'u, ba bariu ao'uai aba ebonu. ");
INSERT INTO rro_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ia hanona keapa'ua keaoaina, ia au hanona ka'aera'aera kaeaoaina.” ");
INSERT INTO rro_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“'Ubiai emiaho ba emai hauna hanona taba ikoikiai 'ubikiai, ia hanopakai erama hauna hanona hanopaka 'euna, ena 'abi'abi ai hanopaka mo robana keahuna. Kupai emai hauna hanona taba ikoikiai 'ubikiai. ");
INSERT INTO rro_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ia eiha mai eo'o tabakia poukia nehinanakia, ia ena 'abi hau ha a'i nia'i taeanakia. ");
INSERT INTO rro_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ia ena 'abi ea'i taeana hauna hanona ebatohana Tirama hanona 'abi tohana hauna. ");
INSERT INTO rro_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tirama euhuna hauna hanona Tirama ena 'abi nehinana, pokina Tirama ehore ia aonai Auba Robe nibabonu 'auna. ");
INSERT INTO rro_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Hamana ehore nahuna niraona'au aina taba ikoikiai ia imanai eutanakia. ");
INSERT INTO rro_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nahuna nia'ikakaumana hauna hanona mauri banaibanai ea'ina, ia nahuna nibaoao aina hauna hanona mauri a'i keiha 'apuana, ia Tirama ena opuere ia ahanai nemiaho.” ");
INSERT INTO rro_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Parisea haukia pou teona hanona Iesu maearima bo'ona nia'inakia ti'abana mai niba'uere robenakia ba Ioane ba'uere robe hauna hanona bita mo ea'inakia. ");
INSERT INTO rro_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Taba tohana hanona Iesu kipona a'i eba'uere robe, ia i'abana haukia teba'uere robe. ");
INSERT INTO rro_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Iesu Parisea haukia pou teona hauna e'iobina raninai Iudea ehabona, emue haeamona keao Galilea. ");
INSERT INTO rro_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ia bariu hanona Samaria haukia ekia hano aona kekana keao. ");
INSERT INTO rro_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ia emai Samaria aiarana ha atana Sukara, aiara weiana herenai Iakobo ehore nahuna Iosepa hano ebena hauna herenai ekarahi. ");
INSERT INTO rro_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Iakobo ena bei 'urina hanona weia, ba Iesu taeara homa'ana ekana buonai emahe obo bei 'urina haianai emiati. Beraura hanona aba eatiaha. ");
INSERT INTO rro_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Weiana Samaria babi'ena ha emai ena bei kerai, ba Iesu ehore enoina etibaha, “Bei harua mobena'u mainu.” ");
INSERT INTO rro_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ia i'abana haukia hanona aiara teao aniani katekawa. ");
INSERT INTO rro_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Samaria babi'ena ehore ia ehina bena etibaha, “Oi hanona Iuda haumu ia au hanona Samaria babi'e'u, ba aehoma buonai here'uai bei inu nunoi aina?” (Pokina Iuda maearimakia mai Samaria maearimakia ekia bahamomo hanona aha'i.) ");
INSERT INTO rro_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Iesu ehore ehina bena etibaha, “Tirama ena beruberu po'iobina mai tai bei ninoi aina heremuai hauna po'iobina raninai, herenai aba ponoina ba ia mauri beina pebeni'o.” ");
INSERT INTO rro_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Babi'e e'abi etibaha, “Hau apa'uamu e, bei irai tabana heremuai aha'i abomo bei 'urina neiana hanona e'oura. Mauri beina weiana hanona ae'eai koa'ina? ");
INSERT INTO rro_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ai 'aba'abamai Iakobo hanona bei 'urina neiana ebenamai, ia kipona einu, nahuna teinu, ena mamoe mai poromakau abomo teinu, ba oi Iakobo otara haona?” ");
INSERT INTO rro_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Iesu ena 'abi ebamuena etibaha, “Bei neiana ṯeinu haukia ikoinai hanona 'akokia kate'ororo mue. ");
INSERT INTO rro_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ia au kabaibeni beina hau ha keinu hanona 'akona a'i ke'ororo 'apua. 'Abi tohana, au kabaibeni beina hanona ia aonai mauri beinai keao kebuti keharu haru mauri kebaibeni keaomo banaibanai.” ");
INSERT INTO rro_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Babi'e ehore Iesu enoina etibaha, “Hau apa'uamu e, bei weiana mobena'u, 'ako'u a'i ke'ororo mue abomo bei rai neia a'i kamai mue.” ");
INSERT INTO rro_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Iesu ia ehina bena etibaha, “Moao atawamu koaparina torarua katomai.” ");
INSERT INTO rro_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Babi'e e'abi etibaha, “Au atawa'u aha'i.” Iesu ia ehina bena etibaha, “Oi atawamu aha'i ṉa nuhoma hanona obero. ");
INSERT INTO rro_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Pokina oi atawamu ikoinai ima, bariu heremuai nemiaho hauna hanona oi atawamu tohana aha'i. Bariu ohinana hauna hanona 'abi tohana.” ");
INSERT INTO rro_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Babi'e e'abi etibaha, “Hau apa'uamu e, bariu ao'u aba ea, oi hanona mahabanai haumu. ");
INSERT INTO rro_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ai kupumai hamamai hanona oeo neiana ahanai Tirama tekuti aina, ia wai Iuda haumi tu'abi kuti 'ekana hanona hamona Ierusalemai mo.” ");
INSERT INTO rro_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Iesu e'abi etibaha, “Babi'e e, e'u 'abi moa'i taeana, ranina nimaiaina aonai Hamaka katokuti aina hanona oeo neiana 'ubinai 'ao Ierusalemai mo aha'i. ");
INSERT INTO rro_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Wai Samaria haumi a'i to'iobina hauna ṯokuti aina, ai Iuda haumai ta'iobina hauna ṯakuti aina, pokina Tirama ena bamauri taearana hanona Iuda haukia herekiai nimai. ");
INSERT INTO rro_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ranina aba nimai katekutiai tohana haukia hanona aubai mai aokia maikoinai Hamaka katekuti aina. Bariu ranina aba ekara'au. Pokina Hamaka hanona ua ṯekutiai aihona haukia nenuatae ainakia. ");
INSERT INTO rro_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Tirama hanona Auba, ua buonai ṯekuti aina haukia hanona aubai mai aokia maikoinai katekuti aina.” ");
INSERT INTO rro_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Babi'e e'abi etibaha, “Au a'iobina Mesia bamauri hauna atana Keriso kemai, ia kemai raninai taba ikoikiai kehina pou harai herekai.” ");
INSERT INTO rro_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ba Iesu ia ehina bena etibaha, “Hauna mo au neia'u bariu nahina beni'o.” ");
INSERT INTO rro_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Rani weianai ia i'abana haukia temue temai hanona teta'uta'u huri, pokina Iesu teihana babi'e ha ohi ti'abi'abi. 'A tai ha a'i ebakaina, “Taba nonuatae aina?” 'ao “Aehoma buonai torarua tu'abi'abi?” ");
INSERT INTO rro_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ba babi'e ena puou ehabona emue noanoa eao aiarai maearima ehina benakia etibaha, ");
INSERT INTO rro_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Tomai hamaeao hau ha tomoihana e'u babai 'uainai ababai haukia ikoikiai ehina pou, iamo taina Keriso mo pa'e weiana?” ");
INSERT INTO rro_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ba maearima aiarai tekarahi Iesu herena teao. ");
INSERT INTO rro_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Weiana aonai i'abana haukia Iesu tenoina tetibaha, “Ba'iobi haumu e, aniani ha moana.” ");
INSERT INTO rro_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","'A ia ehina benakia etibaha, “Au mai e'u aniani kani weiana hanona wai a'i to'iobina.” ");
INSERT INTO rro_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ba i'abana haukia kipokia te'abi'abi tetibaha, “Pa'e maearima ha aniani emaiaina ebena.” ");
INSERT INTO rro_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Iesu ehina benakia etibaha, “E'u aniani hanona euhuna'u hauna ena nuatae kababaina abomo ia ebena'u akana kabaorena. ");
INSERT INTO rro_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Wai tu'abi ‘nawa bani ṯemiaho ba ariari ranina ketaina.’ Ia au nahina benimi, mahami tomobano'a uma tomoiha harainakia, aniani aba te'oru katearinakia. ");
INSERT INTO rro_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ariari hauna 'arana nia'ina ba uma anianina nibararona mauri banaibanai 'ekanai, weiana buonai ibatona hauna mai iarina hauna terarua kateaonamo haeamo. ");
INSERT INTO rro_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Tehinana 'abina hanona 'abi tohana, ‘Nibato bato hauna haeai ia niariari hauna abomo haeai.’ ");
INSERT INTO rro_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Au nauhunimi a'i toaro'ari aina umanai aniani katoarina. Baika uma weianai aro'arina aba tebabaina ba wai tuhore ekia aro'ari anianina tua'ina.” ");
INSERT INTO rro_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Aiara weiana aonai Samaria haukia bo'ona Iesu tea'ikakaumana pokina babi'e ena batoha 'abina paunai, babi'e etibaha, “Ia ehore e'u babai ikoikiai ehina pounakia.” ");
INSERT INTO rro_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ua buonai Samaria maearimakia temai herena, ia tenoina kipokia katemiaho, ba Iesu wapu rua weia emiaho. ");
INSERT INTO rro_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Weiana ena 'abi aiana teona aonai bo'ona haeamona tea'ikakaumana. ");
INSERT INTO rro_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Maearima weiakia babi'e tehina bena tetibaha, “Ai bariu ṯa'ikakaumana hanona oi o'abi hauna paunai aha'i, ia ai bariu kipomai haiamai taona abomo ai ṯa'iobina hau neiana 'abi tohana hanopaka ibamaurina hauna.” ");
INSERT INTO rro_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Wapu ibaruana eore murinai Iesu emikiri Galilea eao. ");
INSERT INTO rro_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Iesu kipona e'abi etibaha, “Mahabanai hauna ena aiara tohana haukia hanona a'i katemariki aina.” ");
INSERT INTO rro_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Iesu Galileai ekara'au raninai, Galilea haukia tea'i taeana, pokina ia abomo teao Ierusalemai weia Kabanai tatuna aonai taba ebabai mahakiai teihanakia paunai. ");
INSERT INTO rro_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Iesu haeamona emue eao Galilea Kana aiarana ua'a bei ea'i banaina bine beinai eao. Weia Kaperanauma aonai obia 'arana hauna ena maearima ha nahuna hauna papana einawa. ");
INSERT INTO rro_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Hau weiana Iesu Iudeai emai Galileai pouna eona raninai, ia eao Iesu herena enoina keao nahuna kebamaurina pokina ia aba ke'ari. ");
INSERT INTO rro_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Iesu ehina bena etibaha, “Wai hoa mai bata'u ta'u huri hoakia a'i katoiha hanona a'i katoa'ikakauma 'apua.” ");
INSERT INTO rro_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Obia hauna e'abi etibaha, “Hau apa'uana e, hamariri hamaeao naha'u hanona aba ke'ari.” ");
INSERT INTO rro_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Iesu ia ehina bena etibaha, “Moao, nahumu hanona aba kemauri.” Obia hauna Iesu ena 'abi ebatohana eka'a. ");
INSERT INTO rro_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ia taeara weiana niao aonai ena ta'ara'i haukia temai taearai tebaitabu ahi, nahuna emauri hauna pouna tehinana. ");
INSERT INTO rro_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ia ebakai bakai beraura hoana tabanai nahuna emauri mauri, ba ia tetibaha, “Warani rabirabi beraura hoana hamona hanona emauri mauri.” ");
INSERT INTO rro_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Hamana eraona tinana beraura hoana weianai hanona Iesu ia ehina bena etibaha, “Nahumu hanona aba kemauri.” Ua buonai ia mai ena itu haukia ikoikiai hanona tea'ikakauma. ");
INSERT INTO rro_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Neiana hanona Iesu bata'uta'u huri hoana ibaruana ebabaina weia Iuda ehabona emai Galilea aonai. ");
INSERT INTO rro_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Rani baika teao murinai Iuda haukia ekia tatu ha erama ba Iesu ekara'au eao Ierusalema. ");
INSERT INTO rro_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Weia Ierusalema ai pa'abi ha atana ‘Mamoe pa'abina’ herenai obu papana ha Heberu maeakiai atana teaparina ‘Betesaida’, ba haianai hanona arai paraboakia ima temia kaiarona. ");
INSERT INTO rro_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","'Eka weiakiai inawa haukia bo'ona ṯenoti, maha ki'a haukia, 'ome haukia, mero haukia, (tibai'ima bei kebure bure. ");
INSERT INTO rro_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Pokina rani ha ha aneru neriri obu beina nibabure burena, murinai inawa hauna ha obuai keriri 'uai hauna ena inawa taba ia ninamo.) ");
INSERT INTO rro_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Inawa hauna ha 'eka weianai ena inawa ihauna ikoinai harau aihau 'ababani. ");
INSERT INTO rro_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Iesu ehore inawa hauna weiana enoti eihana raninai e'iobina ia hanona rani homa'ana ua enoti aiho, ba Iesu ia ebakaina etibaha, “Oi nonuatae konamo, u?” ");
INSERT INTO rro_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Inawa hauna Iesu ena 'abi ebamuena etibaha, “Hau apa'uana e, bei nebure bure aonai au kebaraina'u hauna ha aha'i buonai au nabahobona kariri aonai hau ha aba ne'uai waira'uai.” ");
INSERT INTO rro_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ba Iesu ia ehina bena etibaha, “Momikiri, emu 'ire mouna moa'ina moka'a.” ");
INSERT INTO rro_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Beronai hau weiana emauri mauri, ba emikiri ena 'ire eouna ea'ina eka'a. Weiana hanona beraura robenai hoa neiana erama. ");
INSERT INTO rro_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ua buonai Iuda haukia apa'uakia hau weiana inawa ai enamo hauna tehina bena tetibaha, “Bariu hanona beraura robena, ia oi emu 'ire obuana hanona eka rauhubu nukabena.” ");
INSERT INTO rro_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ia ekia 'abi ebamuena etibaha, “Ebamaurina'u hauna ehina bena'u etibaha, ‘Emu 'ire moa'ina moka'a.’” ");
INSERT INTO rro_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ba ia tebakaina tetibaha, “Hau tabana oi ehina beni'o, ‘Emu 'ire moa'ina moka'a.’” ");
INSERT INTO rro_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Emauri mauri hauna a'i e'iobina tai ia ebamaurina pokina Iesu abamo mako aokiai ehe toto eka'a 'akaumana. ");
INSERT INTO rro_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Muriai marea robe aonai Iesu hau weiana etabu ahina ehina bena etibaha, “Aia'u mona, oi hanona aba omauri mauri, a'i koaka ki'a mue, taba ki'a obona ha heremuai a'i merama mue marikina.” ");
INSERT INTO rro_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ba hau weiana eao Iuda haukia apa'uakia herekia ehina benakia ia ebamaurina hauna hanona Iesu. ");
INSERT INTO rro_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ua buonai Iuda haukia apa'uakia hanona Iesu te'oatana pokina ia taba ikoikiai beraura robena aonai nibabainakia paunai. ");
INSERT INTO rro_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ia Iesu ehina benakia etibaha, “Au Hama'u hanona rani ikoinai niaka to'ona emai mo bariu beraura neiana. Au abo'umo ṉaka.” ");
INSERT INTO rro_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","'Abi neiana paunai Iuda haukia apa'uakia hanona tenuatae ki'a baha Iesu kateahu 'arina. Beraura robe rauhubuna nikabena paunai mo aha'i ia Tirama niaparina hamana tohana ṉa nihoma abomo ia kipona Tirama ohi nibaihobonakia. ");
INSERT INTO rro_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Weiana buonai Iesu ekia 'abi ṉa ebamue aihona, “'Abi tohana au wai nahina benimi. Nahuna kipona 'eunai taba ha kebabaina hanona a'i ketaina. Ia hanona Hamana nibabai akakia eihanakia weiakia mo kebabainakia. Hamana nibabai haukia Nahuna abomo nibabai. ");
INSERT INTO rro_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Pokina Hamana nihore Nahuna niraona'au aina paunai nibabai haukia ikoinai nibaihana. 'E, neiakia mo aha'i taba rarikia baika abomo kebaihana, ba katoihana hanona katota'uta'u huri. ");
INSERT INTO rro_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Weiana Hamana nihore 'ari haukia nibamikiri muenakia mauri nibenakia ihobonai mo Nahuna nihore nenuatae ainakia haukia mauri nibenakia. ");
INSERT INTO rro_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Haeamona Hamana kipona tai ha a'i nibabakaina, bakai ena hiabu maikoina aba Nahuna ebena. ");
INSERT INTO rro_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Hamana timariki aina ihobonai ikoikiai Nahuna katemariki aina, Nahuna a'i nimariki aina hauna hanona Hamana weiana Nahuna euhuna hauna abomo a'i nimariki aina. ");
INSERT INTO rro_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“'Abi tohana au wai nahina benimi, aia'u niona hauna mai euhuna'u Tiramana nia'ikakaumana hauna hanona mauri banaibanai aba ea'ina puma a'i kehoaina. Ia hanona 'ari aba ehabona ba aba mauri aonai etoto. ");
INSERT INTO rro_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“'Abi tohana au wai nahina benimi, 'ari haukia Tirama Nahuna aiana kateona ranina hanona aba nimai, weiakia aiana tiona haukia ikoikiai hanona katemauri mue, bariu ranina aba ekara'au. ");
INSERT INTO rro_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Hamana hanona mauri poki hauna, ihobonai ia ehore Nahuna mauri pokinai ebaona. ");
INSERT INTO rro_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Tirama ehore Nahuna bakai apa'uana ke'uai aina hiabuna aba ebena pokina ia hanona Keriso Maearima Nahuna paunai. ");
INSERT INTO rro_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","E'u 'abi neiana paunai a'i katota'uta'u huri. Ranina aba nimai weiakia 'ariahakiai ṯemiaho haukia ikoikiai Nahuna aiana kateona, ");
INSERT INTO rro_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ekia 'ariahakiai katekarahi. Weiakia namo tebabai haukia katemikiri mauri banaibanai katea'ina, ba weiakia ki'a tebabai haukia katemikiri puma katehoaina. ");
INSERT INTO rro_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Au kipo'u eu'uai taba ha kababaina hanona a'i ketaina. Au aia naona hauna mo ihobonai nabakai, ua buonai e'u bakai hanona ebero, pokina au kipo'u e'u namo a'i natabuna, ia euhuna'u hauna ena nuatae natabuna. ");
INSERT INTO rro_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Au kipo'u pou'u kahinana raninai, e'u pou hina hanona a'i katebatohana. ");
INSERT INTO rro_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Weiana au pau'uai pou'u nehinana hauna hanona haeai, ba au a'iobina ia nehinana 'abina hanona tohana. ");
INSERT INTO rro_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Wai aba tobaiuhu Ioane herena ba ia ehore 'abi tohana pouna ehinana. ");
INSERT INTO rro_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Au pou'u berona hanona maearima herekiai a'i nimai, ia au Ioane ena batoha 'abina na'uahina hanona wai bamauri katotabu ahina paunai. ");
INSERT INTO rro_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ioane hanona e'ara ea nibaibeni matoha lamepa 'abana, ia wai hanona rani papana ena ea toaonamo aina. ");
INSERT INTO rro_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Au mai ibatoha'u hoana ha hanona Ioane 'euna etara haona. Nababai akakia neiakia Hama'u ebena'u kababai orenakia haukia tihore Hama'u euhuna'u pouna ṯehinana. ");
INSERT INTO rro_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ba Hama'u euhuna'u hauna Ia kipona ehore au pou'u ehinana. Ia wai rani ha aiana a'i to'o 'apuana abomo wairana a'i toihana, ");
INSERT INTO rro_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","'ao ena 'abi abomo aomiai a'i nemiaho, pokina ia euhuna hauna wai a'i tua'ikakaumana paunai. ");
INSERT INTO rro_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Wai Puka robena tumarereai haraina pokina wai turaonana weiana herenai mauri banaibanai katotabu ahina paunai. Ia Puka robena neiana hanona au mo pou'u nehinana. ");
INSERT INTO rro_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Wai katomai here'u mauri katoa'ina, iamo ṯoubo aina. ");
INSERT INTO rro_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Au hanona maearima ekia banamo a'i ṉa'i taeanakia. ");
INSERT INTO rro_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Au a'iobi harainimi, aomiai Tirama iraona'au aina a'i nemiaho. ");
INSERT INTO rro_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Au aba Hama'u atanai amai, ia wai au a'i tua'i taeana'u. Ia hau ha kipona atanai pemai raninai wai aba patoa'i taeana. ");
INSERT INTO rro_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Wai kipomi emi banamo ha ha baiatamiai tutabunakia, iamo Tirama ena banamo weiana ia ikupaiana herenai nimai hauna a'i tutabu ahina, ua homana raninai aea katoa'ikakauma aihona'u? ");
INSERT INTO rro_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Ia aomiai a'i katoraonana au Hama'u wairanai kababehonimi. Aha'i. Wai kebabehonimi hauna hanona Mose ia ahanai wai emi buabeni ekori. ");
INSERT INTO rro_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Wai Mose tua'ikakauma tohana raninai au abomo kato a'ikakaumana'u, pokina ia hanona au pou'u ererena. ");
INSERT INTO rro_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ia ererena hauna a'i mo tua'ikakaumana raninai au e'u 'abi hanona aea katoa'ikakauma aihona?” ");
INSERT INTO rro_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Rani baika teao murinai Iesu ekabanai eao Galilea 'obu abiranai. (Weiana atana haeai hanona Tiberia 'obuna.) ");
INSERT INTO rro_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Iesu inawa haukia ebanamonakia, bata'uta'u huri hoakia weiakia teiha paunai mako rarina ia murinai tera'a teao. ");
INSERT INTO rro_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ba Iesu oeoai ekara'au eao i'abana haukia kipokia temiati. ");
INSERT INTO rro_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Iuda haukia ekia Kabanai tatuna hanona aba ekaibari. ");
INSERT INTO rro_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Iesu mahana eao mako rarina timai herena eihanakia raninai, Pilipo ebakaina etibaha, “Aniani ae'eai kaha kawanakia maearima neiakia kateani?” ");
INSERT INTO rro_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ia kebabaina hauna aba eraonana, iamo Pilipo kehobona paunai ua ebakai bakai aiho. ");
INSERT INTO rro_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pilipo ia ena 'abi ebamuena etibaha, “Moni bo'ona 'akinai aniani pahakawanakia abomo a'i petaina, papakia 'akimo pateani.” ");
INSERT INTO rro_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","I'abana haukia ha atana Anderea, Simona Petero hatina etae etibaha, ");
INSERT INTO rro_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Miori papana ha neia ena parawa papakia ima mai ena maia papakia rua. Ia weiana hanona aeamo kaha homanakia pokina maearima hanona ebo'o ki'a baha?” ");
INSERT INTO rro_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Iesu i'abana haukia ehina benakia etibaha, “Maearima tomoba miatinakia.” 'Eka weiana hanona panapana 'ekana, maearima ikoikiai temiati hau 'abaeana ikoinai taha ima (5,000). ");
INSERT INTO rro_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Iesu parawa ea'inakia Tirama ebanamona ba ebenakia weiakia temiati haukia teani eaomo ekia nuatae etaina, ba maia abomo ihobonai ebabaina. ");
INSERT INTO rro_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Weiana ikoikiai teani 'ari aonai Iesu i'abana haukia ehina benakia etibaha, “Harikia ikoikiai katobararonakia ha papana a'i katohabona.” ");
INSERT INTO rro_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ua buonai parawa ima teani 'ari harikia weiakia tebararonakia areha harau haea rua tebabonunakia. ");
INSERT INTO rro_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Iesu bata'uta'u huri hoana weiana ebabaina teihana murinai maearima te'abi tetibaha, “'Abi tohana, mahabanai hauna kemai hanopakai hauna hanona neiana.” ");
INSERT INTO rro_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Iesu e'iobina ia ekia taburai katea'i taeana ekia obia 'arana haunai katebaona, ua buonai ia kipona haeamona ekaobo oeoai ekara'au. ");
INSERT INTO rro_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Erabirabi raninai i'abana haukia teriri teao weia obuai, ");
INSERT INTO rro_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ahiai tehe'au tebeau banai Kaperanauma tiao hanona aba ewapura abuna, Iesu hanona ia baiatakiai aha'i. ");
INSERT INTO rro_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Baura apa'uana eabu'au roio ebuataea ehurehure ki'a. ");
INSERT INTO rro_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ia tepara homa'ana matoha maela aihau 'ao bani 'abana aonai Iesu bei kapenai eka'a herekia eao, teihana raninai teta'u ki'a. ");
INSERT INTO rro_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Iesu ehina benakia etibaha, “Ṉahuna au. A'i tomota'u.” ");
INSERT INTO rro_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ia aokia mai namokia ahiai tebaehe'auna, beronai mo ṯenuatae aina poenai tebahaha'au. ");
INSERT INTO rro_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Erani mako weia 'obu abiranai ṯemiaho haukia te'iobina ahi hamona mo ua'a Iesu hanona i'abana haukia baiatakiai a'i ehe'au i'abana haukia ikupaiakia mo tebeau ahi teka'a. ");
INSERT INTO rro_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ba ahi baika Tiberia ai temai Obiapaka parawa ebanamona ebaibeni maearima ebenakia teani 'ekana herenai tebahoa. ");
INSERT INTO rro_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Weiana mako te'iobina Iesu mai i'abana haukia kipokia wairakia aha'i, ba ahi weiakiai tehe'au Kaperanauma Iesu itabuna teao. ");
INSERT INTO rro_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ia 'obu abiranai ua'a Iesu tetabu ahina raninai tebakaina tetibaha, “Ba'iobi haumu e, oi hanona aita mo okabanai omai neia?” ");
INSERT INTO rro_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Iesu ekia 'abi ebamuena etibaha, “'Abi tohana au wai nahina benimi, wai au tutabuna'u hanona bata'uta'u huri hoana toihanakia paunai aha'i ia parawa toani nuami tebonu paunai. ");
INSERT INTO rro_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Aniani weiana keki'a hauna akanai a'i katoaro'ari ia aniani weiana kemiaho keao mauri banaibanai akanai katoaro'ari, weiana au Maearima Nahuna kabenimi. Hamaka Tirama hanona hiabu weiana ebena'u.” ");
INSERT INTO rro_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ba ia tebakaina tetibaha, “Ai Tirama ena aka tabana katababaina?” ");
INSERT INTO rro_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Iesu ekia 'abi ebamuena etibaha, “Tirama ena aka hanona neiana. Euhuna hauna hamona mo kato a'ikakaumana.” ");
INSERT INTO rro_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ua buonai ia tebakaina tetibaha, “Bata'uta'u huri hoana tabana kobabaina kataihana ba kata a'ikakaumani'o? Tabana hauna kobabaina? ");
INSERT INTO rro_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Aika 'aba'abaka hano'akunai mana teana, Puka robenai tererena ihobona, ‘Kupai emai parawana hauna Mose ebenakia teana.’” ");
INSERT INTO rro_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Iesu ehina benakia etibaha, “'Abi tohana au wai nahina benimi, kupa parawana ebenimi hauna Mose aha'i, ia au Hama'u ehore kupa parawana tohana wai ebenimi. ");
INSERT INTO rro_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Tirama ena parawa hanona neiana, ia kupai eriri emai hauna hanopakai mauri nibaibeni.” ");
INSERT INTO rro_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ia tehina bena tetibaha, “Obiapaka e, aniani neiana hanona rani ikoinai kobenamai.” ");
INSERT INTO rro_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ba Iesu ia ehina benakia etibaha, “Au hanona mauri anianina, here'u kemai hauna hanona mare'a a'i ke'ari 'apua, abomo kea'ikakaumana'u hauna hanona 'akona a'i ke'ororo 'apua. ");
INSERT INTO rro_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ia au aba ahina benimi, wai aba toihana'u iamo a'i tua'ikakaumana'u. ");
INSERT INTO rro_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Hama'u nibena'u haukia ikoikiai hanona katemai here'u, ba nimai here'u hauna hanona a'i kau'u ahi 'apuana. ");
INSERT INTO rro_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Pokina au kupai ariri amai hanona kipo'u e'u nuataeai a'i kababaina, ia euhuna'u hauna ena nuataeai akana kababaina. ");
INSERT INTO rro_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ba euhuna'u Tiramana ena nuatae hanona neiana, weiakia ebena'u haukia ikoikiai ha a'i kaba'akaumana, ia rani orenai kabamikiri muenakia. ");
INSERT INTO rro_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","'Abi tohana au Hama'u ena nuatae hanona neiana, Nahuna kateihana mai kate a'ikakaumana haukia ikoikiai hanona mauri banaibanai katea'ina, ba rani orenai hanona kabamikiri muenakia.” ");
INSERT INTO rro_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","'Abi neiana paunai Iuda haukia ia teururu aina, pokina ia e'abi, “Au hanona mauri anianina kupai ariri amai.” ");
INSERT INTO rro_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ba ia te'abi tetibaha, “Iesu neiana hanona Iosepa nahuna, hamana mai hinana naha'iobinakia. Ia bariu aehoma buonai ṉa ni'abi aiho, ‘Au kupai ariri amai.’?” ");
INSERT INTO rro_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Iesu ekia 'abi ebamuena etibaha, “Kipomi baiatamiai ururu naiana tomobapuana. ");
INSERT INTO rro_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Hau ha ena nuataeai here'u a'i kemai 'abaea ia Hama'u euhuna'u hauna kebaka'anakia haukia katemai here'u, ba au rani orenai kabamikiri muenakia. ");
INSERT INTO rro_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Mahabanai haukia Puka robenai aba tererena, ‘Ikoikiai hanona Tirama aba keba'iobinakia.’ Hama'u tibahuaina abomo herenai 'iobi tia'ina haukia ikoikia timai here'u. ");
INSERT INTO rro_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Hau ha Hamaka a'i eiha 'apuana, ia Tirama herenai emai hauna ikupaiana mo Hamaka eihana. ");
INSERT INTO rro_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","'Abi tohana au wai nahina benimi. Tia'ikakaumana'u haukia hanona mauri banaibanai tea'ina. ");
INSERT INTO rro_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mauri anianina hanona Au neia'u. ");
INSERT INTO rro_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Wai 'aba'abami hano'akunai mana teana, iamo ikoikiai te'ari. ");
INSERT INTO rro_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ia hau ha aniani neiana kupai eriri emai hauna keana hanona a'i ke'ari. ");
INSERT INTO rro_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Au hanona aniani maurina weiana, kupai ariri amai. Hau ha aniani neiana keana hanona kemauri banaibanai. Aniani neiana au kabaibeni hauna hanona au bitio'u, weianai hanopaka haukia mauri katea'ina.” ");
INSERT INTO rro_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Weiana Iuda haukia kipokia baiatakiai tebaihara tae te'abi tetibaha, “Hau neiana bitiona aea kebeni aihonaka kahana?” ");
INSERT INTO rro_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Iesu ehina benakia etibaha, “'Abi tohana au wai nahina benimi. Wai au Maearima Nahuna bitio'u a'i katoana mai aruaru'u a'i katoinu raninai wai aomiai mauri a'i kemiaho. ");
INSERT INTO rro_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Au bitio'u niana mai aruaru'u neinu hauna hanona mauri banaibanai aba nia'ina abomo rani orenai hanona kabamauri muena. ");
INSERT INTO rro_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Pokina au bitio'u hanona aniani tohana abomo aruaru'u hanona inuinu beina tohana. ");
INSERT INTO rro_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Au bitio'u niana mai aruaru'u neinu hauna hanona ia ao'uai nemiaho au abomo ia aonai namiaho. ");
INSERT INTO rro_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Hama'u nimauri hauna ehore euhuna'u, au hanona Hama'u paunai namauri ihobonai mo au hau'u keana hauna hanona au pau'uai kemauri. ");
INSERT INTO rro_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Au aniani neia'u hanona kupai ariri amai. 'Aba'abami mana teana 'abana aha'i, teani iamo te'ari, ia hau ha aniani neia'u keanina'u hauna hanona kemauri banaibanai.” ");
INSERT INTO rro_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Iesu Kaperanaumai weia eba'iobi raninai 'abi neiana ehinana Iuda haukia ekia marea aonai. ");
INSERT INTO rro_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Aiana teona murinai ti'abana haukia bo'ona te'abi tetibaha, “'Abi neiana hanona epahihi, tai kehore 'abi neiana kea'i taeana?” ");
INSERT INTO rro_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Iesu aba e'iobina ti'abana haukia 'abi weiana ṯeururu aina ba ehina benakia etibaha, “'Abi neiana aomi nibaro'arina, u? ");
INSERT INTO rro_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Au Maearima Nahuna pakara'au amiaho 'uai 'ekana paeao patoihana'u raninai aea patohoma? ");
INSERT INTO rro_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Auba Robe hanona mauri nibaibeni, 'a hauani hanona taba ha a'i nibaramana. Ahina benimi 'abikia neiakia hanona auba 'abikia mai mauri 'abikia. ");
INSERT INTO rro_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ia baiatamiai baika hanona a'i tua'ikakauma.” Popounai Iesu aba e'iobina baiatakiai tai a'i tia'ikakauma mai tai ia hinahinana kehinahinaina. ");
INSERT INTO rro_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ia haeamona ehina benakia etibaha, “Ua buonai aba ahina benimi atibaha, ‘Hama'u maearima a'i kemaiaina raninai hau ha kemai here'u taearana aha'i.’” ");
INSERT INTO rro_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Iesu ena 'abi weiana buonai te'abana haukia bo'okia tehabona Iesu murinai a'i teka'a mue. ");
INSERT INTO rro_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ba Iesu i'abana haukia harau haea rua ebakainakia etibaha, “Wai abomo ṯonuatae katohabona'u, u?” ");
INSERT INTO rro_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simona Petero ehore ehina bena etibaha, “Obiapaka e, ai tai herena kataeao? 'Abi weiana mauri nimaiaina hauna hanona oi heremuai nemiaho. ");
INSERT INTO rro_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ai aba ṯa'ikakauma mai ṯa'iobina oi hanona robe haumu tohamu Tirama herenai omai.” ");
INSERT INTO rro_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ba Iesu ehina benakia etibaha, “Wai harau haea rua atina'animi. Ia 'abami hamona hanona tiaporo.” ");
INSERT INTO rro_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ia e'uahina hauna hanona Iuda Isakariote hauna Simona nahuna, ia i'abana haukia harau haea rua ha Iesu hinahinana kehinahina hauna. ");
INSERT INTO rro_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Weiakia murikiai Iesu Galilea aonai ekaoao kaoao, ia a'i enuatae keao Iudea pokina Iuda haukia apa'uakia hanona ṯe'imana kateahu 'arina. ");
INSERT INTO rro_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Weiana Iuda haukia ekia I'aua tatuna ranina ekaibari. ");
INSERT INTO rro_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Iesu hatina tehore tehina bena tetibaha, “'Eka neiana kohabona koao Iudea ba weia bata'uta'u huri hoakia kobabai ti'abani'o haukia kate ihanakia. ");
INSERT INTO rro_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Pokina hau ha kipona ibawaira tinana nenuatae aina raninai taba ha buniakiai a'i nibabai, neiakia aba nubabainakia buonai moba karahini'o hanopaka wairakiai teme'iobini'o.” ");
INSERT INTO rro_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ua te'abi aiho pokina hatina abokiamo a'i tea'ikakaumana. ");
INSERT INTO rro_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ba Iesu ehina benakia etibaha, “E'u rani tohana hanona a'i nimai baha. Ia wai heremiai hanona rani mo 'akina ikoikiai tetai. ");
INSERT INTO rro_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Hanopaka hanona a'i ke'oatanimi ia au ni'oatana'u, pokina au ia pouna ṉahinana weiana ia nibabaina hauna hanona eki'a. ");
INSERT INTO rro_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Wai tomoao tatu 'ekana, au hanona a'i kawahi tatu 'ekana naiana pokina e'u rani tohana hanona a'i nitai bahana.” ");
INSERT INTO rro_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ia 'abi neiana ehinana ba Galileai emiaho. ");
INSERT INTO rro_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Hatina tatu 'ekana teao murikiai ia abomo tatu 'ekana eao bunianai mo to'u wairakiai aha'i. ");
INSERT INTO rro_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ba tatu weiana aonai Iuda haukia apa'uakia hanona Iesu titabuna tibakai bakaiaina, “Hauna weiana hanona ae'e?” ");
INSERT INTO rro_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Weia to'u aonai hanona tebateteaina, baika te'abi, “Ia hanona hau namona.” Ia baika te'abi, “Aha'i, ia hanona maearima ne'uaiai behonakia.” ");
INSERT INTO rro_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ia Iuda haukia apa'uakia teta'u ainakia paunai, hau ha to'u wairakiai ia 'abina a'i ehina 'apuana. ");
INSERT INTO rro_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Weia tatu ranina ibuanai Iesu ekara'au marea robeai eba'iobi ramanakia. ");
INSERT INTO rro_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ba Iuda haukia apa'uakia teta'uta'u huri te'abi tetibaha, “Hau neiana marere 'ekana ha a'i eao, ia marere mahakia aea e'iobi aihonakia?” ");
INSERT INTO rro_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Iesu ekia 'abi ebamuena etibaha, “E'u ba'iobi 'abikia hanona au kipo'u 'eu'u aha'i, ia euhuna'u Tiramana herenai timai. ");
INSERT INTO rro_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Hau ha Tirama ena nuatae akana kebabaina raninai ia aba ke'iobina, au e'u ba'iobi hanona Tirama herenai nimai 'ao au kipo'u e'u 'abi. ");
INSERT INTO rro_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Hau ha kipona 'euna nehinana hauna hanona kipona ena namo nitabuna 'a euhuna hauna ena namo nitabuna hauna hanona ebero, ia aonai beho aha'i. ");
INSERT INTO rro_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mose rauhubu aba ebenimi, aonai ha hamomomu rauhubu neiana a'i to'inibena. Taba buonai katoahu 'arina'u taearana tutabuna?” ");
INSERT INTO rro_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","To'u haukia ena 'abi tebamuena tetibaha, “Oi hanona nubeau 'ari, tai nenuatae keahu 'arini'o?” ");
INSERT INTO rro_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Iesu ehina benakia etibaha, “Au beraura robenai bata'uta'u huri hoana hamona ababaina, ba wai ikoinai tota'uta'u huri. ");
INSERT INTO rro_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mose itare akana wai ebenimi buonai wai miori papakia beraura robenai itare tubenakia. (Itare akana hanona Mose herenai a'i emai, ia wai kupumi 'aba'abami herekiai emai.) ");
INSERT INTO rro_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Bariu miori beraura robe aonai tutarenakia hanona Mose ena rauhubu a'i tomokabena marikina. Taba buonai beraura robe aonai hau ha hauna maikoinai abanamona hanona tuopuere aina'u? ");
INSERT INTO rro_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Taba ihakiai a'i katobaihobo, ia taba ekia bero tohakiai katobaihobo.” ");
INSERT INTO rro_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Rani weianai Ierusalema maearimakia baika tebakai bakai tetibaha, “titabuna kateahu 'arina hauna hanona neiana 'ao? ");
INSERT INTO rro_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Hauna mo naiana to'u wairakiai neiroro ba 'abi ha ia herenai a'i ṯehina 'apuana, hau apa'uakia pa'e aba teraona haraina ia hanona Keriso 'ao? ");
INSERT INTO rro_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Keriso kemai raninai ena mai 'ekana tai ha a'i ke'iobina, ia hau neiana ena mai 'ekana aika naha'iobina.” ");
INSERT INTO rro_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ba Iesu marea robe ai niba'iobi aonai eio etibaha, “Wai au to'iobina'u, ae'eai amai abomo to'iobina. Au kipo'u e'u nuatae ai a'i amai Tirama euhuna'u ba amai, ia hanona 'abi tohana. Wai ia a'i to'iobina. ");
INSERT INTO rro_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","'A au hanona ia na'iobina pokina au ia herenai amai abomo Ia au euhuna'u.” ");
INSERT INTO rro_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","'Abi neiana teona aonai ia katebirina hanona teraonana 'a hau ha ia ahanai a'i ehao'au pokina ena rani a'i nitai bahana. ");
INSERT INTO rro_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","To'u aonai maearima bo'ona ia tea'ikakaumana ba te'abi tetibaha, “Keriso kemai raninai, bata'uta'u huri hoakia bo'okia kebabai ba hau neiana? Pa'e aha'i.” ");
INSERT INTO rro_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Parisea haukia mako Iesu tebatete aina 'uruna teona ba robe haukia apa'uakia mai Parisea haukia tehore marea robe ṯe'imana haukia teuhunakia Iesu katebirina. ");
INSERT INTO rro_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ba Iesu e'abi etibaha, “Au bariu rani papana wai heremiai kamiaho ba kamue kaeao euhuna'u hauna herena. ");
INSERT INTO rro_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Weiana wai katotabuna'u iamo a'i katotabu ahina'u. Au kamiaho 'ekana wai katoao hanona a'i ketaina.” ");
INSERT INTO rro_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ba Iuda haukia apa'uakia kipokia baiatakiai te'abi'abi tetibaha, “Hau neiana hanona aeana keao, ba ni'abi aika ia a'i kahatabu ahina? Weia Iuda haukia terama otaraina Helene haukia baiatakiai ṯemiaho haukia herekiai keao ba Helene haukia keba'iobinakia, 'ao? ");
INSERT INTO rro_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ena 'abi ‘Wai hanona katotabuna'u iamo a'i katotabu ahina'u.’ abomo ‘Kamiaho 'ekana katoao hanona a'i ketaina.’ weiana anina hanona taba?” ");
INSERT INTO rro_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Tatu ranina orenai rani apa'uanai Iesu ekoroti e'abi etibaha, “'Akona ni'ororo hauna emai here'u bei keinu. ");
INSERT INTO rro_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Puka robenai tererena 'abana, ‘Au nia'ikakaumana'u hauna hanona ia aonai mauri beina keharu ate 'abana.’” ");
INSERT INTO rro_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Neiana hanona Auba Robe 'abina ehinana ia weiakia tea'ikakaumana haukia muriai kebenakia, pokina Iesu ena nuabi a'i nia'i bahana buonai Auba Robe hanona a'i nibaibeni baha. ");
INSERT INTO rro_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Iesu ena 'abi neiakia urukia teo'o raninai maearima baika te'abi tetibaha, “'Abi tohana hau neiana hanona mahabanai hauna.” ");
INSERT INTO rro_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Baika te'abi tetibaha, “Ia hanona Keriso.” 'a baika tebakai bakai tetibaha, “Ia aea homanai Keriso hanona Galileai kemai? ");
INSERT INTO rro_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Puka robenai ṉa a'i e'abi aiho? Keriso hanona Davida nininai kerama Davida emiaho aiarana Betelehema aonai.” ");
INSERT INTO rro_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ua buonai maearima baiatakia epa'a Iesu paunai. ");
INSERT INTO rro_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Baiatakiai baika tenuatae katebirina, ia mo hau ha imana ia haunai a'i ehao'au. ");
INSERT INTO rro_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Murinai marea robe ṯe'imana haukia weiakia temue teao robe haukia apa'uakia mai Parisea haukia herekia, ba ia tehore tebakainakia tetibaha, “Aehoma buonai a'i tobaka'ana a'i tomaiaina?” ");
INSERT INTO rro_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","'Ima'ima haukia ekia 'abi tebamuena tetibaha, “Ua raninai emai mo bariu hau ha ua a'i ni'abi aiho 'apua hau neiana ni'abi 'abana.” ");
INSERT INTO rro_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ba Parisea haukia te'abi pahihi tetibaha, “Wai abomimo aba ebaka'a behonimi, uhe? ");
INSERT INTO rro_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Wai turaonana hau apa'uakia 'ao Parisea haukia ha ia nia'ikakaumana? Aha'i. ");
INSERT INTO rro_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","To'u haukia weiakia Mose ena rauhubu a'i te'iobina haukia hanona Tirama ena puma katehoaina.” ");
INSERT INTO rro_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ia 'abakia ha Nikodemo, rani ha eao Iesu herena hauna, ehore ehina benakia etibaha, ");
INSERT INTO rro_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Aika eka rauhubu tainai hau ha puma a'i kahabeni 'abaeana, ia aiana kahao'o 'uaina, ia taba ebabaina hauna kaha'iobi 'uaina.” ");
INSERT INTO rro_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ia tehina bena tetibaha, “Oi abomo Galileai omai, u? Puka robena koraona haraina mahabanai hauna hanona Galileai a'i kemai.” ");
INSERT INTO rro_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ba maearima ikoikiai temue ikau ena itu teao. ");
INSERT INTO rro_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","'A Iesu hanona Olibe oeona eao. ");
INSERT INTO rro_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Erani raurani 'amarinai Iesu haeamona eao marea robe aonai maearima ikoinai ia herena teao teto'una, ba ia emiati eba'iobinakia. ");
INSERT INTO rro_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Rauhubu poki haukia mai Parisea haukia babi'e ha enabau ki'a aonai tetabu ahina temaiaina. To'u wairakiai tebakorotina, ");
INSERT INTO rro_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ba Iesu tehina bena tetibaha, “Ba'iobi haumu e, babi'e neiana hanona ninabau ki'a aonai tatabu ahina. ");
INSERT INTO rro_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ba Mose ena rauhubu aonai ṉa ehinabe aihonaka, babi'e nahomakia hanona piharai kahahu 'arinakia. Ia bariu oi hanona taba ṉa nuhoma?” ");
INSERT INTO rro_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Bakaibakai neiana teaoaina ia herenai hanona weianai patebarewana Iesu behoai patehorotina. Ia Iesu hanona ehiriti imana kiri'unai 'anoai erererere. ");
INSERT INTO rro_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ia tehore tebakai hao bakai haona, ba emikiri ehina benakia etibaha, “Hau ha baiatamiai emu ki'a aha'i haumu, pihara mokapo 'uaina babi'e neiana moahuna.” ");
INSERT INTO rro_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Haeamona ehiriti 'anoai erere rere mue. ");
INSERT INTO rro_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ba 'abi neiana teona haukia hanona kipokia ekia ki'a teraonanakia ba hamohamo tekaobo kironai ea'i ramana eaomo 'aru'arunai epua, Iesu ikupaiana tehabona babi'e ia herenai ekoroti. ");
INSERT INTO rro_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Iesu emikiri tai ha a'i eihana babi'e mo weia, ba ebakaina etibaha, “Babi'e e, maearima neiakia ae'e? Tai ha puma a'i ebeni'o?” ");
INSERT INTO rro_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Babi'e e'abi etibaha, “Obiapaka e, tai ha aha'i.” Iesu ia ehina bena etibaha, “Au abo'umo oi puma ha a'i kabeni'o, moao ki'a ha a'i kobabai muena.” ");
INSERT INTO rro_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Haeamona Iesu maearima ehinabe muenakia etibaha, “Au hanona hanopaka eana. Hau ha au muri'uai keka'a hauna hanona wapura aonai a'i keka'a, weiana ia hanona mauri eana kea'ina.” ");
INSERT INTO rro_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","'Abi neiana teona raninai Parisea haukia ṉa tehinabe aihona, “Oi kipomu poumu nohinana, emu pou hanona a'i ebero.” ");
INSERT INTO rro_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Iesu ehina benakia etibaha, “Kipo'u pou'u nahinana hanona ebero pokina amai 'ekana mai kaeao 'ekana au a'iobina ia wai hanona au amai 'ekana 'ao kaeao 'ekana a'i to'iobi 'apuana. ");
INSERT INTO rro_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Wai maearima ekia hoahoa ihobonai au tukaiahina'u. Au hanona tai ha a'i nakaiahina. ");
INSERT INTO rro_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ia au e'u kaiahi pababaina re'a, e'u 'abi hanona ebero, pokina au hanona ikupaia'u aha'i, Hama'u euhuna'u hauna abomo here'uai. ");
INSERT INTO rro_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Emi rauhubu aonai abomo ṉa erere aihona, maearima rua ekia 'abi kehamona hanona 'abi tohana. ");
INSERT INTO rro_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Au hau'u kipo'u pou'u nahinana mai Hama'u euhuna'u hauna abomo pou'u nehinana.” ");
INSERT INTO rro_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ba ia tebakaina tetibaha, “Hamamu hanona ae'e?” Iesu e'abi etibaha, “Wai a'i ṯo'iobina'u buonai Hama'u abomo a'i ṯo'iobina. Wai au pato'iobina'u raninai Hama'u abomo pato'iobina.” ");
INSERT INTO rro_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Iesu marea robe aonai baibeni monina ihorotina 'ekanai 'abi neiakia eba'iobi ainakia. Weiana hau ha ia a'i ebirina pokina ia ena rani a'i nitai bahana. ");
INSERT INTO rro_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Iesu haeamona ia ehina benakia etibaha, “Au hanona naka'a 'akaumana, ia wai hanona au katotabuna'u ia emi ki'a aonai kato'ari. Au kaeao 'ekana katoao hanona a'i ketainimi.” ");
INSERT INTO rro_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","'Abi neiana paunai Iuda haukia apa'uakia kipokia tebakai bakai tetibaha, “Ia ṉa ni'abi aiho, ‘Au kaeao 'ekana hanona wai a'i katomai,’ weiana hanona ia kipona keahu 'arina, 'ao?” ");
INSERT INTO rro_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Iesu ehina benakia etibaha, “Wai hanona ba'a ai tomai au hanona 'ubiai amai, wai haumi hanona hanopaka neiana 'euna, au hau'u hanona hanopaka neiana 'euna aha'i. ");
INSERT INTO rro_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Au aba ahina benimi, ‘Emi ki'a aonai kato'ari,’ weiana Au miaho banaibanai hau'u a'i kato a'ikakaumana'u raninai wai hanona emi ki'a aonai kato'ari.” ");
INSERT INTO rro_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ia tebakai bakai tetibaha, “Ba oi hanona tai?” Iesu ekia 'abi ebamuena etibaha, “Au tai hanona aba ahinabe hinabe benimi 'uainai emai mo bariu. ");
INSERT INTO rro_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Wai paumiai au 'abi bo'ona pahinana abomo puma rarina pabahoainimi, ia euhuna'u hauna hanona toha tohana, au ia herenai naona hauna mo hanopaka nahina bena.” ");
INSERT INTO rro_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ia Hamana robana eahuna hanona obona a'i teobo. ");
INSERT INTO rro_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ua buonai Iesu ia ehina benakia etibaha, “Au Maearima Nahuna katotiu taeana'u raninai aba kato'iobina au hanona Keriso, abomo au kipo'u taba ha a'i nababaina ia Hama'u eba'iobina'u haukia mo nahinanakia. ");
INSERT INTO rro_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Abomo euhuna'u hauna hanona ni'abana'u ia au a'i nihabo 'abaeana'u, pokina ia ena nuatae akakia rani ikoinai nababainakia.” ");
INSERT INTO rro_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","'Abi neiakia ehinanakia hanona maearima bo'ona ia tea'ikakaumana. ");
INSERT INTO rro_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ba Iesu Iuda haukia tea'ikakaumana haukia ehina benakia etibaha, “E'u 'abi kato'ini benakia raninai wai hanona au i'aba'u haumi tohami. ");
INSERT INTO rro_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Weiana 'abi tohana kato'iobina, ba 'abi tohana kehore kerubunimi.” ");
INSERT INTO rro_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ia Iesu tehina bena tetibaha, “Ai Aberahamo bibirana haumai abomo tai ha ta'arana a'i ṯa'i. Aehoma buonai porubunamai ṉa ṉuho?” ");
INSERT INTO rro_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Iesu ehina benakia etibaha, “'Abi tohana au wai nahina benimi, ki'a nibabaina hauna hanona ki'a ena ta'ara ia'ina haunai niao. ");
INSERT INTO rro_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ta'ara'i hauna hanona poki hauna ena ituai a'i kemiaho banaibanai, nahuna hanona itu weianai kemiaho banaibanai. ");
INSERT INTO rro_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ua buonai Nahuna kehore kerubunimi raninai wai hanona aba erubu tai baihanimi. ");
INSERT INTO rro_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Au aba a'iobinimi wai Aberahamo bibirana haumi, ia e'u 'abi aomiai a'i nemiaho paunai ṯonuatae katoahu 'arina'u. ");
INSERT INTO rro_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Au hanona Hama'u wairanai aihana hauna nahina benimi, mai wai hanona hamami herenai tuo'o haukia tubabainakia.” ");
INSERT INTO rro_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ia ena 'abi tebamuena tetibaha, “Aberahamo hanona ai hamamai.” Ba Iesu ehina benakia etibaha, “Wai Aberahamo nahuna raninai Aberahamo ebabai akakia patobabai. ");
INSERT INTO rro_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","'Abi tohana Tirama herenai aona hauna nahina benimi, ia wai hanona taeara'u tutabuna katoahu 'arina'u. Aberahamo hanona ṉa a'i ebabai aiho. ");
INSERT INTO rro_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Wai hamami ebabai tabakia hanona wai tubabainakia.” Ia Iesu tehina bena tetibaha, “Ai hanona tubu miorimai aha'i, ai hamamai hanona hamona Tirama mo ikupaiana.” ");
INSERT INTO rro_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Iesu haeamona ehina benakia etibaha, “Wai hamami Tirama raninai au patoraona'au aina'u. Pokina au Tirama herenai akarahi amai neia. Au hanona kipo'u e'u nuataeai a'i amai ia Hama'u euhuna'u. ");
INSERT INTO rro_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Aehoma buonai nahinanakia 'abikia hanona aomi a'i tiea? Pokina wai e'u 'abi ia'i taeana a'i ṯonuatae aina. ");
INSERT INTO rro_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Wai hamami hanona tiaporo, emi nuatae hanona hamami ena nuatae akana katobabaina. Ia hanona ahuahu hauna bahabanai emai mo bariu, 'abi tohanai a'i ekoroti, pokina ia aonai 'abi tohana ha a'i nemiaho. Ia bai'oi nehinana hanona ia ena hoahoa tohana, pokina ia hanona bai'oi hauna abomo bai'oi ikoikiai hamakia. ");
INSERT INTO rro_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Au 'abi tohana nahinana paunai wai au e'u 'abi a'i tua'i taeana. ");
INSERT INTO rro_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ba naia haumi tai ha au e'u ki'a o'iobina raninai 'ekana ko'uahina. Au 'abi tohana nahinana raninai aehoma buonai e'u 'abi a'i tua'i taeana? ");
INSERT INTO rro_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Tirama nahuna hauna hanona Tirama ena 'abi aiakia nio'o, ia wai aia a'i tuona ena poki hanona wai Tirama nahuna aha'i.” ");
INSERT INTO rro_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Iuda haukia apa'uakia Iesu ena 'abi tebamuena tetibaha, “Oi hanona Samaria haumu aomuai auba ki'a obona nemiaho, weiana hanona aba ta'abi harai 'ao?” ");
INSERT INTO rro_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ba Iesu ehina benakia etibaha, “Au ao'uai hanona auba ki'a obona aha'i. Au hanona Hama'u namariki aina ia wai au a'i tumariki aina'u. ");
INSERT INTO rro_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Au hanona kipo'u e'u nuabi a'i natabuna, ia Tirama kehore e'u nuabi ketabuna abomo bakai kebabaina au pau'uai. ");
INSERT INTO rro_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","'Abi tohana au wai nahina benimi, e'u 'abi ne'inibena hauna hanona a'i ke'ari 'apua.” ");
INSERT INTO rro_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Weia Iuda haukia apa'uakia tehina bena tetibaha, “Bariu ai ṯa'iobi haraini'o, oi hanona aomuai auba ki'a obona nemiaho. Aberahamo e'ari mahabanai haukia abomo te'ari iamo oi nu'abi emu 'abi pe'inibena hauna hanona 'ari abiabina a'i keonobaina. ");
INSERT INTO rro_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Oi hanona Aberahamo otara haona, u? Ia e'ari mahabanai haukia te'ari, ba nuraonana oi hanona tai?” ");
INSERT INTO rro_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Iesu ia ehina benakia etibaha, “Kipo'u pabanuabina'u raninai e'u nuabi anina aha'i. Au Hama'u hauna tohana wai tu'abi ‘Emi Tirama’ hauna nihore au nibanuabina'u. ");
INSERT INTO rro_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Wai ia a'i to'iobina au mo a'iobina. Ba au pa'abi au ia a'i a'iobina raninai au hanona bai'oi hau'u wai 'abami. Ia au a'iobina mai ena 'abi na'inibenakia. ");
INSERT INTO rro_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Wai hamami Aberahamo e'u rani keihana paunai eaonamo, ba eihana hanona aona enamo.” ");
INSERT INTO rro_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Iuda haukia apa'uakia te'abi tetibaha, “Oi ihaumu hanona imabui a'i nia'i bahana, ia Aberahamo aba hamo oihana, u?” ");
INSERT INTO rro_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Iesu ehore ehina benakia etibaha, “'Abi tohana au wai nahina benimi. Aberahamo a'i erama baha au hanona aba amiaho.” ");
INSERT INTO rro_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","'Abi weiana teona raninai ia pihara tea'i Iesu kateahuna, ia Iesu hanona kipona epihi to'u baiatakiai ekaobo marea robe ehabona eka'a. ");
INSERT INTO rro_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Iesu taeara ekana eao aonai maha ki'a hauna ha eihana, ia hanona mahana ki'akiai erama. ");
INSERT INTO rro_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","I'abana haukia Iesu tebakaina tetibaha, “Ba'iobi haumu e, tai ena ki'a paunai hau neiana mai 'iauna erama, hau neiana ena ki'ai 'ao hinana hamana ekia ki'ai?” ");
INSERT INTO rro_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Iesu ekia 'abi ebamuena etibaha, “Hau neiana ena ki'a aha'i abomo hinana hamana ekia ki'a aha'i, ia Tirama ena hiabu akakia ia haunai kewaira tina hauna kateihana paunai. ");
INSERT INTO rro_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Au euhuna'u Tiramana ena aka mararani kahababaina. Rabi kemai aonai hau ha keaka hanona a'i ketaina. ");
INSERT INTO rro_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Au hanopakai namiaho aonai au hanona hanopaka ena ea.” ");
INSERT INTO rro_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Iesu 'abi neiana ehinana murinai 'anoai e'atoti ba 'atotinai tipu emakana, 'iau hauna mahana rua etaronakia. ");
INSERT INTO rro_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ba ehina bena etibaha, “Moao, Siloama obunai wairamu koutuna.” (Siloama anina hanona ‘baiuhu.’) Hau weiana eao wairana eutuna, emue emai mahana aba tenamo. ");
INSERT INTO rro_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Herenai haukia mai maearima baika ia 'uainai enoi ba'ame teihana haukia kipokia tebakai bakai tetibaha, “Hau neiana 'uainai weia emiati enoi ba'ame hauna, u?” ");
INSERT INTO rro_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Harua etibaha, “Hauna mo naiana.” Baika tetibaha, “Aha'i, ihana mo ia teaobena.” Ia kipona ehina benakia etibaha, “Au mo neia'u.” ");
INSERT INTO rro_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ia tehore tebakaina tetibaha, “Bariu mahamu aea tehoma noihaiha?” ");
INSERT INTO rro_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ia ekia 'abi ebamuena etibaha, “Hau atana teaparina Iesu hauna tipu emakana maha'u etaronakia, ba ehina bena'u kaeao Siloama obuna waira'u kautuna. Ua buonai aeao waira'u autu ba naiha iha.” ");
INSERT INTO rro_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ia tebakaina tetibaha, “Hau weiana hanona ae'e?” 'Iau hauna e'abi etibaha, “Au a'i a'iobina.” ");
INSERT INTO rro_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ia tehore weiana 'uainai mahana teki'a hauna tebaka'ana teaoaina Parisea haukia herekia. ");
INSERT INTO rro_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Wapu weiana Iesu tipuai 'iau hauna mahana etaronakia tekaikau hanona beraura robena. ");
INSERT INTO rro_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ua paunai Parisea haukia abomo ia tebakaina mahana aea tenamo aiho. Maha ki'a hauna e'abi etibaha, “Ia tipuai maha'u etaronakia, autunakia ba bariu aba naihaiha.” ");
INSERT INTO rro_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Parisea haukia baika te'abi tetibaha, “Hau neiana hanona Tirama herenai a'i emai pokina ia beraura robe a'i ne'inibena.” Ia baika te'abi tetibaha, “Ki'a hauna ha hoa ṉahomakia aea kebabai aiho?” Weiana paunai ia kipokia baiatakia epa'a. ");
INSERT INTO rro_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Haeamona Parisea haukia maha ki'a hauna tebakai muena tetibaha, “Ia ehore mahamu ekaikaunakia, ba oi nuraonana ia hanona tai?” Hau weiana e'abi etibaha, “Ia hanona mahabanai hauna.” ");
INSERT INTO rro_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Iuda haukia apa'uakia maha ki'a hauna mahana aba tenamo hauna a'i tebatohana eao mo hau weiana hinana mai hamana teaparinakia temai. ");
INSERT INTO rro_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ba ia tebakainakia tetibaha, “Neiana hanona wai nahumi, u? Mahana ki'a obokiai erama hauna neiana? Ia bariu hanona mahana aea tenamo aiho ba neihaiha?” ");
INSERT INTO rro_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Hinana mai Hamana ia ekia 'abi tebamuena tetibaha, “Ai ta'iobina ia hanona ai nahumai abomo ia hanona mahana ki'a obokiai erama. ");
INSERT INTO rro_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ia bariu aeahoma neihaiha abomo tai ehore ia mahana ekaikaunakia hanona ai a'i ṯa'iobina. Tomobakaina, ia abeapa'ua kipona robana meahuna.” ");
INSERT INTO rro_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Hinana mai hamana Iuda haukia apa'uakia teta'u ainakia paunai ua te'abi aiho. Iuda haukia aba teroba ahu hau ha Iesu kehina pouna ia hanona Keriso raninai mareai katebakarahina. ");
INSERT INTO rro_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Weiana buonai hinana mai hamana te'abi, “Ia hanona abeapa'ua tomobakaina.” ");
INSERT INTO rro_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Maha ki'a hauna rani ibaruana teaparina tehina bena tetibaha, “Ko'abi'uai Tirama wairanai ba 'abi tohana kohinana. Ai ṯa'iobina hau neiana ebanamoni'o hanona ki'a hauna.” ");
INSERT INTO rro_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Hau weiana ekia 'abi ebamuena etibaha, “Ia ki'a hauna 'ao aha'i au a'i a'iobina. Taba hamona au a'iobina hanona maha'u teki'a ia bariu aba naihaiha.” ");
INSERT INTO rro_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ba ia tebakaina tetibaha, “Oi heremuai taba ebabaina? Mahamu aea ekaikau aihonakia?” ");
INSERT INTO rro_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ia ekia 'abi ebamuena etibaha, “Au aba wa'i baha ahina benimi, ia aia'u a'i to'ona. Bariu aehoma buonai ṯonuatae katoo muena? Wai abomo ṯonuatae ia i'abana haumiai katoao, u?” ");
INSERT INTO rro_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ia tehore terike ki'ana ba ṉa te'abi aiho, “Oi hanona maearima weiana i'abana haumu, ia ai hanona Mose i'abana haumai. ");
INSERT INTO rro_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ai ṯa'iobina Tirama ehore Mose ehina bena, ia maearima naiana ae'e ai emai hanona a'i ṯa'iobina.” ");
INSERT INTO rro_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Hau weiana ekia 'abi ebamuena etibaha, “Bariu taba haeai tohana erama pokina ia maha'u ekaikaunakia iamo wai hanona ena mai 'ekana a'i ṯo'iobina. ");
INSERT INTO rro_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Aika ha'iobina Tirama ki'a haukia aiakia a'i nibahu ainakia. Ia hanona ṯekuti aina haukia mai weiakia ena nuatae akana tibabaina haukia mo aiakia nibahu ainakia. ");
INSERT INTO rro_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","'Uainai hanopaka erama raninai emai mo bariu hau ha ehore mahana teki'a erama hauna mahana ekaikaunakia pouna ha a'i hao'o 'apuana. ");
INSERT INTO rro_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Hau neiana Tirama herenai a'i emai raninai ia hanona aka ṉa homana ha a'i pebabaina.” ");
INSERT INTO rro_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ia ena 'abi tebamuena tetibaha, “Oi hanona ki'a aonai orama ba oi nuhore ai kobamarerenamai, u?” Ia tehore mareai tetori ahina. ");
INSERT INTO rro_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Iesu hau weiana tetori ahina pouna eona ba etabu ahina raninai ia ebakaina etibaha, “Oi Maearima Nahuna nua'ikakaumana, u?” ");
INSERT INTO rro_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Hau weiana Iesu ena 'abi ebamuena etibaha, “Hau apa'uana e, ia hanona tai? Mohina bena'u au kahore ia ka'ikakaumana.” ");
INSERT INTO rro_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Iesu e'abi etibaha, “Oi bariu ia aba noihana hauna naiana oi nehina beni'o.” ");
INSERT INTO rro_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ba hau weiana e'abi etibaha, “Obiapaka e, au na'ikakauma.” Ba ia Iesu ekuti aina. ");
INSERT INTO rro_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Iesu haeamona e'abi etibaha, “Kabakai paunai amai hanopaka neianai, weiakia maha ki'a haukia kateihaiha, ia neiakia ṯeihaiha haukia mahakia kateki'a.” ");
INSERT INTO rro_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Parisea haukia baika ia herenai haukia 'abi weiana teona hanona tebakaina, “'Abi tohana ai abomo mahamai teki'a, u?” ");
INSERT INTO rro_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Iesu ehina benakia etibaha, “Wai mahami pateki'a raninai heremiai ki'a peaha'i. Ia bariu wai tu'abi ṯoihaiha buonai emi ki'a hanona 'ekakiai ṯemiaho.” ");
INSERT INTO rro_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Iesu e'abi etibaha, “'Abi tohana au wai nahina benimi. Hau ha mamoe parabuna pa'abinai a'i nikatoto ia ara huanai nirobanai hauna hanona bainao mai kakikaki hauna. ");
INSERT INTO rro_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ia pa'abiai nikatoto hauna hanona mamoe i'imana hauna. ");
INSERT INTO rro_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Pa'abi iha'inina hauna hanona pa'abi nikaikauna hau weiana 'euna ba ena mamoe hanona ia aiana tiona. Ia ena mamoe ha ha atakia tohakia niaparinakia mai ne'uai ainakia tikarahi. ");
INSERT INTO rro_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ia ena mamoe ikoikiai nibakarahi orenakia raninai, wairakiai nika'a weiana ena mamoe ia murinai ti'au pokina ia aiana te'iobina. ");
INSERT INTO rro_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Maearima haeai ha murinai a'i kate'au ia katebeau 'akaumana, pokina maearima weiana aiana a'i te'iobina.” ");
INSERT INTO rro_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Iesu 'abi ibabatai neianai ehina benakia, 'a ia taba e'uahina hauna obona a'i teobo 'apua. ");
INSERT INTO rro_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Weiana buonai Iesu e'abi mue etibaha, “'Abi tohana au wai nahina benimi. Au hau'u hanona mamoe ekia pa'abi. ");
INSERT INTO rro_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Weiakia ikoikiai temai 'uai haukia hanona bainao mai kakikaki haukia ua buonai mamoe ia aiakia a'i teona. ");
INSERT INTO rro_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Au hau'u hanona pa'abi, hau ha au ao'uai nikatoto hauna hanona kemauri. Ia hanona kekatoto mai kekarahi aniani ketabu ahina. ");
INSERT INTO rro_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","“Bainao hauna emai hanona kebainao, keahuahu mai kebapururu paunai emai. Au amai hanona mamoe mauri katea'ina mauri namona maikoinai katea'ina. ");
INSERT INTO rro_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Au hanona mamoe 'ima hauna namo'u, mamoe 'ima hauna namona hanona ena mauri kebaibeni ena mamoe paukiai. ");
INSERT INTO rro_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","'Ara tabu hauna hanona mamoe 'ima hauna tohana aha'i, mamoe abomo ia 'euna aha'i, ua buonai waeha 'aki nimai neihana raninai ia mamoe nihabonakia nibeau 'akaumana, ba waeha 'aki mamoe ne'urinakia tibeau otaraina. ");
INSERT INTO rro_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Hau weiana nibeau 'akaumana pokina ia hanona 'ara tabu hauna mai mamoe robakia a'i niahuna. ");
INSERT INTO rro_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Au hanona mamoe 'ima hauna namo'u, au hanona e'u mamoe a'iobinakia mai e'u mamoe abomo te'iobina'u. ");
INSERT INTO rro_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ihobona mo Hama'u au e'iobina'u au Hama'u a'iobina, ba e'u mauri kabaibeni e'u mamoe paukiai. ");
INSERT INTO rro_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Au hanona e'u mamoe haeai baika, weiakia hanona parabu neiana aonai aha'i, weiakia abokiamo kamaiainakia ia abomo aia'u kateona, weia mamoe to'una kehamomo mai mamoe 'ima hauna hamona. ");
INSERT INTO rro_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Hama'u niraona'au aina'u pokina au e'u mauri nabaibeni, haeamona au kahore ka'i muena. ");
INSERT INTO rro_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Hau ha here'uai e'u mauri a'i kea'i boina, 'a au kipo'u e'u nuataeai e'u mauri nabaibeni. Au mai e'u hiabu e'u mauri kabaibeni mai e'u hiabuai e'u mauri haeamona ka'i muena. Hama'u ebena'u 'abina hanona weiana.” ");
INSERT INTO rro_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","'Abi neiakia paukiai Iuda haukia baiatakia epa'a mue. ");
INSERT INTO rro_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Maearima bo'ona te'abi tetibaha, “Auba ki'a obona ia aonai nemiaho nibeau 'ari. Taba buonai ia aiana tuona?” ");
INSERT INTO rro_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ia baika te'abi tetibaha, “'Abi ṉa homakia hanona auba ki'a obona aonai nemiaho hauna ua a'i ke'abi aiho. Ba auba ki'a obona maha ki'a hauna mahana a'i kekaikaunakia.” ");
INSERT INTO rro_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ba Ierusalema ai marea barobe iraonana tatuna ranina etaina, weiana hanona iaia ranina. ");
INSERT INTO rro_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ba Iesu hanona Marea robe aonai itara ha ahanai eka'a, weiana hanona Solomona ena itara. ");
INSERT INTO rro_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Iuda haukia apa'uakia temai Iesu tekori kaiarona te'abi tetibaha, “Aomai nubakai'au kai'auna, aita raninai kohinabe harainamai? Oi Keriso raninai mohinabe harainamai.” ");
INSERT INTO rro_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ba Iesu ekia 'abi ebamuena etibaha, “Au wai aba ahina benimi, ia wai hanona a'i tua'ikakauma. Au Hama'u atanai hiabu akakia ababainakia haukia hanona waira'u tia'i ahina. ");
INSERT INTO rro_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ba wai a'i tua'ikakaumana'u pokina wai hanona au e'u mamoe aha'i. ");
INSERT INTO rro_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","E'u mamoe hanona aia'u tiona. Au a'iobinakia, mai ia hanona muri'uai tika'a. ");
INSERT INTO rro_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Au mauri banaibanai nabenakia, ia hanona a'i kate'ari abomo hau ha ima'uai a'i kea'i boinakia. ");
INSERT INTO rro_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Hama'u mamoe weiakia ebena'u hauna hanona taba ikoikiai etara haonakia, hau ha Hama'u imanai weiakia ha a'i kea'i boina. ");
INSERT INTO rro_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Au mai Hama'u tararua hanona hamomomai.” ");
INSERT INTO rro_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Iuda haukia 'abi neiana teona raninai pihara tea'i taea ia kateahu 'arina. ");
INSERT INTO rro_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","'A Iesu ehina benakia etibaha, “Aka namokia bo'okia Hama'u herenai haukia abaihanimi, aka neiakia aeana hauna paunai piharai katoahuna'u?” ");
INSERT INTO rro_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ia ena 'abi tebamuena tetibaha, “Ai piharai katahuni'o hanona aka namokia nubabai paunai aha'i, ia Tirama nu'abi ki'aina paunai, pokina oi hanona maearima 'abaeamu ia mo oi kipomu Tiramai nubaoni'o.” ");
INSERT INTO rro_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Iesu ekia 'abi ebamuena etibaha, “Emi rauhubu aonai aba tererena, Tirama e'abi, ‘Wai hanona tirama.’ ");
INSERT INTO rro_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Tirama ena 'abi emai herekiai haukia eaparinakia tirama, ba Puka robena 'abina weiana hanona a'i keikabe. ");
INSERT INTO rro_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Weiana Tirama ebarobena'u mai euhuna'u amai hanopakai ba a'abi atibaha, ‘Au hanona Tirama Nahuna,’ raninai, aehoma buonai tu'abi au Tirama na'abi ki'aina? ");
INSERT INTO rro_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Hama'u ena aka a'i pababaina raninai a'i pato a'ikakaumana'u. ");
INSERT INTO rro_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ia Hama'u ena aka nababai raninai, wai a'i tua'ikakaumana'u re'a ia aka weiakia nababai haukia tomo a'ikakaumanakia. Weianai wai kato'iobina mai obokia katobo Hama'u hanona au ao'uai mai au hanona Hama'u aonai.” ");
INSERT INTO rro_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Weiana Iuda haukia apa'uakia taeara tetabu mue Iesu katebirina. Ia hanona herekiai ekaobo. ");
INSERT INTO rro_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Iesu ekabanai Ioridana atena abirana eao mue, 'uainai Ioane eba'uere robe 'ekanai weia emiaho. ");
INSERT INTO rro_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Maearima bo'ona temai ia herena ba te'abi tetibaha, “Ioane hoa ha a'i ebabaina ia mo Ioane hau neiana robana eahuna tabakia ikoikiai hanona tetoha.” ");
INSERT INTO rro_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ba maearima bo'ona weia Iesu tea'ikakaumana. ");
INSERT INTO rro_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Hau ha atana Lasaro, Betani hauna, ia hanona einawa, Betani hanona Maria uaho'abana Mareta ohi ekia aiara. ");
INSERT INTO rro_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maria weiana kehore tehoro timina 'orimonai Obiapaka Iesu aena keheinakia ba buinai keutu 'ororonakia babi'ena, ia haibuna hanona Lasaro weiana einawa. ");
INSERT INTO rro_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Weiana buonai uaho'aba rua 'abi teuhuna eao Iesu herena tetibaha, “Obiapaka e, nuraona'au aina hauna hanona neinawa.” ");
INSERT INTO rro_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","'A Iesu pou neiana eona raninai e'abi etibaha, “Inawa neiana hanona Lasaro a'i keba'ari baiha, ia neiana erama hanona Tirama ena nuabi kewaira tina, weianai Tirama Nahuna nuabi kea'ina.” ");
INSERT INTO rro_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Iesu hanona Mareta uaho'abana Maria ohi mai haibukia Lasaro kipokia eraona'au ainakia. ");
INSERT INTO rro_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Weiana Iesu Lasaro ena inawa pouna eona raninai, ia 'ekanai mo weia wapu rua emiaho. ");
INSERT INTO rro_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ba Iesu i'abana haukia ehina benakia etibaha, “Aika hamamue hamaeao Iudea.” ");
INSERT INTO rro_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","I'abana haukia te'abi tetibaha, “Ba'iobi haumu e, maraniai mo Iuda haukia apa'uakia tenuatae piharai kateahu 'arini'o, ia mo oi emu raona hanona komue koao weia?” ");
INSERT INTO rro_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Iesu e'abi etibaha, “Mararani hamona aonai beraura hoana hanona harau haea rua, maearima ha mararani nika'a hauna hanona a'i kekai, pokina ia hanona hanopaka ena ea neihana. ");
INSERT INTO rro_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ia rabi keka'a hauna hanona kekai, pokina ia aonai hanona ea aha'i.” ");
INSERT INTO rro_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Iesu 'abi weiana ehinana murinai e'abi etibaha, “Eka hau Lasaro hanona aba eparua rea. Ia au hanona kaeao kabaona.” ");
INSERT INTO rro_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","I'abana haukia te'abi tetibaha, “Obiapaka e, ia neinawa niparua raninai ia hanona aba kenamo mue.” ");
INSERT INTO rro_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Iesu hanona Lasaro ena 'ari robana eahuna, 'a i'abana haukia teraonana ia hanona niparua 'abaea. ");
INSERT INTO rro_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Weiana buonai Iesu ehinabe mahanakia etibaha, “Lasaro hanona aba e'ari. ");
INSERT INTO rro_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Wai paumiai au weia aha'i hanona ao'u ninamo, pokina wai katohore au kato a'ikakaumana'u. Aika hamaeao ia herena.” ");
INSERT INTO rro_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ba Toma (tiaparina Bai'apaea hauna) 'abana ehina benakia etibaha, “Aika abomo hamaeao, ia kipokia kaha'ari haeamo.” ");
INSERT INTO rro_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Iesu weia ekara'au raninai tehina bena Lasaro hanona aba e'ari hauanina wapu bani uri aonai nemiaho. ");
INSERT INTO rro_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ierusalema mai Betani baiatakia hanona a'i ehoma'a matoha maela rua 'abana. ");
INSERT INTO rro_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Weiana Mareta mai Maria haibukia Lasaro e'ari paunai Iuda haukia bo'okia temai ia herekia aokia katebataburana. ");
INSERT INTO rro_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mareta Iesu emai pouna eona raninai, ia ekarahi eao keihana, ia Maria hanona ituai emiaho. ");
INSERT INTO rro_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mareta Iesu ehina bena etibaha, “Obiapaka e, oi neia pomiaho raninai haibu'u hanona a'i pe'ari. ");
INSERT INTO rro_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ia au a'iobina bariu taba Tirama herenai konoi aina hauna ia kehore kebeni'o.” ");
INSERT INTO rro_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Iesu Mareta ehina bena etibaha, “Oi haibumu hanona kemikiri mue.” ");
INSERT INTO rro_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mareta e'abi etibaha, “Au a'iobina ia hanona kemikiri mue rani orenai.” ");
INSERT INTO rro_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Iesu Mareta ehina bena etibaha, “Au hanona mikiri mue abomo mauri. Au nia'ikakaumana'u hauna hanona 'abi ṉa aha'i pe'ari, ia kemauri. ");
INSERT INTO rro_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ba timauri mai tia'ikakaumana'u haukia ikoikiai hanona a'i kate'ari 'apua ia katemauri banaibanai. Oi 'abi neiana nua'ikakaumana, u?” ");
INSERT INTO rro_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mareta e'abi etibaha, “'E, Obiapaka, au na'ikakaumani'o, oi hanona Keriso, Tirama Nahuna weiana kemai hanopakai hauna.” ");
INSERT INTO rro_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","'Abi neiana ehinana murinai emue eao uaho'abana Maria eapari ke'ena ehina bena etibaha, “Ba'iobi hauna hanona aba emai oi nibakai bakai aini'o.” ");
INSERT INTO rro_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria 'abi neiana eona raninai emikiri noanoa eao Iesu herena. ");
INSERT INTO rro_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Rani weianai Iesu hanona aiarai a'i ekatoto baha, ia weia Mareta ohi tebaitabu ahi 'ekanai emiaho oho. ");
INSERT INTO rro_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Iuda haukia weiakia Maria kipokia ituai temiaho aona tebataburana haukia ia teihana emikiri noanoa ekarahi raninai murinai teao, teraonana ia hanona niao 'ariahanai weia kehai. ");
INSERT INTO rro_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maria hanona Iesu emiaho 'ekanai ekara'au ba eihana raninai beronai aena pokinai e'umuti e'abi etibaha, “Obiapaka e, oi neia pomiaho raninai haibu'u hanona a'i pe'ari.” ");
INSERT INTO rro_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Iesu Maria ehai eihana mai Iuda haukia weiakia kipokia temai haukia tehai eihanakia hanona aona eaoko'o mai e'abe'abe. ");
INSERT INTO rro_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ia ebakainakia etibaha, “Wai ia ae'eai tohorena?” Ia ena 'abi tebamuena tetibaha, “Obiapaka e, omai moihana.” ");
INSERT INTO rro_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ba Iesu ehai. ");
INSERT INTO rro_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Weiana Iuda haukia te'abi tetibaha, “Tomoihana hama ua niraona'auai aihona.” ");
INSERT INTO rro_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ia baika te'abi tetibaha, “Hau neiana maha ki'a hauna mahana ebanamonakia ba ia pehore Lasaro 'ariai peba'orona a'i pe'ari.” ");
INSERT INTO rro_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Iesu aona eaoko'o ki'a. Ba eao 'ariahana, 'ariahana weiana hanona pihara paparo'ana ha pihara rarina temaiaina pa'abina tebahu abuna. ");
INSERT INTO rro_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Iesu e'abi etibaha, “Pihara tomoa'i parena!” Ia 'ari hauna haibuna Mareta e'abi etibaha, “Obiapaka e, timina aba ṉa eki'a, pokina ia tehorena hanona wapuna aba ebani.” ");
INSERT INTO rro_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ba Iesu ia ehina bena etibaha, “Au aba ahina beni'o, oi koa'ikakaumana'u raninai Tirama ena nuabi koihana.” ");
INSERT INTO rro_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ua buonai ia tehore pihara tea'i parena. Ba Iesu ea'a taea e'abi etibaha, “Hama'u e, au nabanamoni'o pokina aia'u aba nuona. ");
INSERT INTO rro_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Au a'iobina oi hanona rani ikoinai aia'u nuona, ia au neiana nahinana ena poki hanona maearima neiakia neia tekoroti haukia paukiai. Weiana kate a'ikakauma oi ohore au ouhuna'u.” ");
INSERT INTO rro_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Iesu 'abi neiana ehinana murinai eapari aota etibaha, “Lasaro e, naia mokarahi omai!” ");
INSERT INTO rro_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ba 'ari hauna ekarahi emai, imana mai aena hanona 'ariahana habuninai te'apanakia haeamona wairana abomo habuni ha ai te'apana. Iesu e'abi etibaha, “'Ariahana habunikia tomorubunakia, tomohabona meao.” ");
INSERT INTO rro_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Iuda haukia bo'ona temai Maria tetoana haukia hanona Iesu taba weiana ebabaina teihana ba tea'ikakaumana. ");
INSERT INTO rro_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ia baika hanona teao Parisea haukia herekia ba Iesu taba ebabaina hauna robana teahuna. ");
INSERT INTO rro_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ba robe haukia apa'uakia mai Parisea haukia bakai apa'uana ṯe'imana haukia teaparina kipokia te'abi'abi, “Bariu aika taba kaha babaina hau weiana aba bata'u ta'u huri hoakia bo'ona nibabainakia. ");
INSERT INTO rro_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Aika ia kahahabona hoa neiakia kebabai hao babai hao raninai maearima ikoinai ia kate a'ikakaumana, ba Roma haukia katemai eka marea robe mai eka hanopaka katea'i boinaka.” ");
INSERT INTO rro_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ba ia 'abakia ha atana Kaiafa, ihau weiana aonai ia hanona robe haukia arakiai hauna ha etae e'abi etibaha, “Wai taba ha'i to'iobi 'apuana. ");
INSERT INTO rro_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Wai obo a'i tuobo, namona hanona hau ha hamona pe'ari maearima paukiai, ba hanopaka maikoina keki'a hanona a'i enamo.” ");
INSERT INTO rro_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ia 'abi neiana ehinana hanona ia kipona ena raonai aha'i. 'A ihau weiana aonai ia hanona robe haukia 'arakiai hauna paunai, ena mahabanaiai ua e'abi aiho Iesu ke'ari Iuda haukia paukiai, ");
INSERT INTO rro_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Iuda haukia ikupaiakia mo paukiai aha'i, ia Tirama nahuna 'eka haeai haeai ṯemiaho haukia kebararonakia mai kebahamonakia. ");
INSERT INTO rro_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Rani weiana ea'i ramana eaoaina aonai Iuda haukia apa'uakia hanona terobahu Iesu kateahu 'arina. ");
INSERT INTO rro_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ua buonai Iesu Iuda haukia baiatakiai a'i eka'a maha. Ia weia ekaobo eao hano'akuna haianai aiara ha atana Eperaim, weia i'abana haukia kipokia temiaho. ");
INSERT INTO rro_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Iuda haukia ekia Kabanai tatuna aba ekaibari aonai Iuda maearimakia bo'ona aiara haeai haeai ai tekara'au teao Ierusalema ai katea'ia'i harai katerobe 'uai ba tatu kerama. ");
INSERT INTO rro_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ia Iesu tetabuna ba marea robe aonai tekoroti kipokia baiatakiai tebakai bakai tetibaha, “Wai taba turaonana? Ia tatu kemai 'ao?” ");
INSERT INTO rro_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","'A robe haukia apa'uakia mai Parisea haukia 'abi tebaibeni, hau ha Iesu ena miaho 'ekana e'iobina raninai ia keba 'iobinakia, weiana ia katehore katea'ina. ");
INSERT INTO rro_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Wapu 'abaihau wairai ṯemiaho Kabanai tatuna kerama hanona Iesu eao Betani Lasaro nemiaho aiarana, hau weiana 'ariai ebamikirina hauna. ");
INSERT INTO rro_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Rabirabi Iesu ia'i taeana hoana anianina ha teba'oruna, ba Mareta hanona ia ta'arakia ea'i, ia Lasaro hanona Iesu mai maearima baika kipokia aniani 'ekanai temiati. ");
INSERT INTO rro_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ba Maria ehore tehoro kawapu hamona arana rarina 'akinai pahakawana hauna ea'ina Iesu aena eheinakia ba buinai Iesu aena eutu 'ororonakia. Tehoro timana 'orimona weiana itu aona maikoinai ebabonu 'auna. ");
INSERT INTO rro_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Iesu i'abana hauna ha Iuda Isakariote hauna wairai Iesu kehinahinaina hauna e'abi etibaha, ");
INSERT INTO rro_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“'Ei, tehoro neiana moni rarina 'akinai patekawa kawaina ba monina uraru haukia patebenakia.” ");
INSERT INTO rro_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ia 'abi neiana ehinana hanona uraru haukia niraonanakia paunai aha'i, 'a ia hanona bainao hauna, moni puteputena weiana ea'ina haunai ia kipona nibaraina. ");
INSERT INTO rro_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ba Iesu e'abi etibaha, “Tomohabo 'abaeana, tehoro neiana hanona kebamauaina keaomo wapu weiana au katehorena'u hauna 'euna. ");
INSERT INTO rro_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Rani ikoikiai uraru haukia hanona wai baiatamiai katemiaho, 'a au hanona rani ikoikiai wai baiatamiai a'i kamiaho.” ");
INSERT INTO rro_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Weiana Iuda haukia to'una rarina Iesu pouna teona ia hanona aba Betani ai, buonai teao 'eka weiana. Iesu mo kipona a'i kateihana, ia Lasaro 'ariai ebamikiri muena hauna abomo kateihana. ");
INSERT INTO rro_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ia robe haukia apa'uakia teroba ahu Lasaro abomo kateahu 'arina, ");
INSERT INTO rro_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","pokina hoa weiana Lasaro herenai erama hauna paunai Iuda haukia bo'ona ia tehabonakia tekabanai Iesu tea'ikakaumana. ");
INSERT INTO rro_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Erani wapu weianai to'u rarina tatu paunai temai haukia Iesu pouna teona nimai Ierusalema. ");
INSERT INTO rro_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ua buonai ia 'ari'ari tea'i tekarahi teao Iesu kipokia katebaitabu ahi, ba teio tetibaha, “Hosana! Tirama kehore Obiapaka atanai nimai hauna kebanamona! Tirama kehore Isaraela ekia obia 'arana kebanamona!” ");
INSERT INTO rro_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Iesu toniki nahu ha etabu ahina ahanai emia'au. Weiana hanona Puka robenai tererena ihobona etibaha, ");
INSERT INTO rro_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Siona aiara apa'uana haumi e, a'i katota'u. Tomoihana, neiana hanona emi obia arana toniki nahu ahanai emia'au nimai.” ");
INSERT INTO rro_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Rani weianai i'abana haukia 'abi neiakia obokia a'i teobo eaomo Iesu ena nuabi ai emikiri mue murinai ba ia robana teahuna 'abikia tererenakia haukia mai taba neiakia ia herenai tebabai haukia teraona tinanakia. ");
INSERT INTO rro_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Maearima weiakia Iesu Lasaro 'ariai ebamikiri muena teihana haukia tehore ia hauna pouna tehina otaraina. ");
INSERT INTO rro_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Maearima bo'ona Iesu bata'u ta'u huri hoana weiana ebabaina pouna teona paunai tekarahi teao kateihana. ");
INSERT INTO rro_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ua buonai Parisea haukia kipokia baiatakiai te'abi'abi tetibaha, “Tomoihana, aika hanona a'i ketainaka maearima maikoinai aba ia murinai tika'a.” ");
INSERT INTO rro_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Tatu weiana aonai weiakia teao Ierusalema Tirama katekuti aina haukia baiatakiai hanona Helene haukia abomo baika. ");
INSERT INTO rro_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ia temai Galilea Betesaida hauna Pilipo herena tehina bena tetibaha, “Poki haumu e, ai ṯanuatae Iesu kataihana.” ");
INSERT INTO rro_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pilipo eao Anderea ehina bena ba terarua teao Iesu tehina bena. ");
INSERT INTO rro_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Iesu ekia 'abi ebamuena etibaha, “Au Maearima Nahuna nuabi apa'uana ka'ina beraurana hanona aba ekara'au. ");
INSERT INTO rro_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","'Abi tohana au wai nahina benimi, witi uhona ha a'i ke'eho hanoai a'i ke'ari raninai ia hanona uho 'abaeana mo kemiaho. 'A ke'ari raninai uho bo'ona kebaramanakia. ");
INSERT INTO rro_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Hau ha ena mauri ibanamona niraonana hauna hanona ena mauri keba'akauma, hau ha hanopaka neiana aonai ena mauri ibanamona robana a'i niahuna hauna hanona ena mauri kea'i 'inina keaomo banai banai. ");
INSERT INTO rro_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Hau ha au ta'ara'u kea'i hauna hanona muri'uai kemai, ba au ae'eai hanona e'u ta'ara'i hauna abomo weia. Hau weiana ta'ara'u nia'i hauna Hama'u kehore ia kea'i taeana. ");
INSERT INTO rro_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Bariu hanona ao'u niaro'ari ki'a ba taba ṉa kahoma? Au ka'abi, ‘Hama'u, beraura hoana neiana aonai mobamaurina'u?’ Aha'i. Au amai ena pokina tohana hanona beraura hoana neianai kahaiara. ");
INSERT INTO rro_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Hama'u e, atamu mobanuabina.” Ba aia ha kupai emai etibaha, “Au aba abanuabina, haeamona kabanuabi muena.” ");
INSERT INTO rro_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","To'u haukia aia weiana teona raninai te'abi tetibaha, “Kupa niro'u,” baika hanona te'abi tetibaha, “Aneru ha Iesu ehina bena.” ");
INSERT INTO rro_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Iesu ehina benakia etibaha, “Aia neiana emai hanona wai keba namonimi paunai, ia au aha'i. ");
INSERT INTO rro_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Bariu rani neiana hanona hanopaka kebakai ranina, ba hanopaka neiana niobia aina hauna Satani bariu kateu'u ahina. ");
INSERT INTO rro_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Weiana au hanopakai katetio taeana'u aonai maearima ikoikiai kaberinakia katemai here'u.” ");
INSERT INTO rro_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ia 'abi neiana ehinana hanona ia aea ke'ari aiho hauna ehina pouna. ");
INSERT INTO rro_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","To'u haukia te'abi tetibaha, “Ai rauhubuai aia taona e'abi Keriso hanona kemiaho banai banai, ia aea homanai mo oi nu'abi notibaha, ‘Au Maearima Nahuna hanona katetio taeana'u.’ Tai hanona Maearima Nahuna?” ");
INSERT INTO rro_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ba Iesu ekia 'abi ebamuena etibaha, “Wai hanona rani papana mo ea kipokia katomiaho. Ea toa'ina aonai tomoka'a, weiana wapura kehore a'i mekaiabunimi marikina. Maearima wapura aonai nika'a hauna hanona a'i e'iobina aeana niao. ");
INSERT INTO rro_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ea heremiai nemiaho oho aonai tomo a'ikakaumana. Weiana wai hanona ea nahunai katoao.” Iesu ena 'abi neiana ebapuana murinai herekiai ekaobo eao epihi. ");
INSERT INTO rro_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Iesu bata'u ta'u huri hoakia bo'okia wairakiai ebabai, iamo to'u haukia ia a'i tea'ikakaumana. ");
INSERT INTO rro_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Neiana hanona Isaia mahabanai hauna ena 'abi ibatohana ṉa e'abi aiho, “Obiapaka e, tai emai 'abi tahinana hauna ea'ikakaumana, haeamona Obiapaka imana hiabuna hanona tai herenai kebawaira tinana?” ");
INSERT INTO rro_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Neiana paunai to'u haukia kate a'ikakaumana hanona a'i etaina. Haeamona Isaia e'abi mue etibaha, ");
INSERT INTO rro_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Obiapaka ehore mahakia eba'iaunakia, mai aokia ebapahihinakia, weiana mahakiai a'i temeiha iha mai ekia raonaraonai obo a'i temeobo, a'i temeraona kabe a'i mabamaurinakia, Tirama ua e'abi aiho.” ");
INSERT INTO rro_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaia 'abi neiana ehinana pokina Iesu ena nuabi eihana ba pouna ehinana. ");
INSERT INTO rro_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Rani weianai Iuda haukia apa'uakia bo'ona Iesu tea'ikakaumana. Ia Parisea haukia teta'u ainakia buonai ekia a'ikakauma a'i tehina pou, pokina marea aonai a'i temeba karahinakia ta'una. ");
INSERT INTO rro_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Pokina ekia nuatae hanona maearima ia kateba namonakia, 'a Tirama kebanamonakia hauna a'i tenuataeai haraina. ");
INSERT INTO rro_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ba Iesu eio aota etibaha, “Hau ha au nia'ikakaumana'u hauna hanona au mo a'i nia'ikakaumana'u ia weiana euhuna'u hauna abomo nia'ikakaumana. ");
INSERT INTO rro_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Hau ha au neihana'u hauna hanona weiana au euhuna'u hauna abomo neihana. ");
INSERT INTO rro_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Au hanona ea 'abana amai hanopakai, ba maearima tia'ikakaumana'u haukia ikoikiai hanona wapura aonai a'i katemiaho. ");
INSERT INTO rro_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Hau ha e'u 'abi aiakia nio'o ia a'i nika'ainakia hauna, au ia a'i kababakaina, pokina au amai hanona hanopaka a'i kababakaina ia hanopaka 'arana kabamaurina. ");
INSERT INTO rro_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Hau ha au nibaki'ana'u mai e'u 'abi a'i nia'i taeanakia hauna hanona mai ibabakaina hauna ha nemiaho, rani orenai 'abi weiakia ahina haukia katehore ia katebabakaina. ");
INSERT INTO rro_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Pokina au kipo'u e'u nuataeai a'i a'abi, 'a Hama'u euhuna'u hauna ena 'abi ebaibeni 'abina kahinana abomo kahinahina haraina hauna ahinana. ");
INSERT INTO rro_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ba au a'iobina ia ena 'abi ebaibeni hanona keaoainimi mauri banai banai 'ekana, ua buonai 'abi ahinanakia haukia hanona Hama'u mo ehina bena'u 'abikia ahinanakia.” ");
INSERT INTO rro_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Mara hanona Kabanai tatuna, weiana Iesu e'iobina ena rani aba ekara'au hanopaka kehabona keao Hamana herena. Ia hanopakai ia 'euna haukia rani ikoinai eraona'au ainakia, ia bariu ena raona'au maikoinai kebaihanakia keao mo ke'ari. ");
INSERT INTO rro_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Rabirabi teaniani aonai, tiaporo aba Simona nahuna Iuda Isakariote hauna aona eana Iesu hinahinana kehinahinaina. ");
INSERT INTO rro_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Iesu hanona aba e'iobina Hamana ehore taba ikoikiai aba ia imanai eutanakia, weiana ia hanona Tirama herenai emai haeamona kemue Tirama herena. ");
INSERT INTO rro_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Weiana Iesu aniani 'ekanai emikiri ena ibatoto habuni ahanai hauna ea'i obona ehorotina ba tauera ea'ina huanai ehaina. ");
INSERT INTO rro_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Bei ebaharu ahina ritiai ba i'abana haukia aekia eutu ramanakia, tauera huanai ehaina hauna aekia eba'ororonakia. ");
INSERT INTO rro_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Iesu emai Simona Petero herenai ekara'au raninai Petero e'abi etibaha, “Obiapaka e, oi hanona au ae'u koutunakia, u?” ");
INSERT INTO rro_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Iesu Petero ena 'abi ebamuena etibaha, “Bariu au taba nababaina hauna oi obona a'i nuobo, 'a keao muriai hanona obona aba kobo.” ");
INSERT INTO rro_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petero Iesu ehina bena etibaha, “Oi hanona au ae'u a'i koutu 'apuanakia.” Iesu Petero ena 'abi ebamuena etibaha, “Aemu a'i kautunakia raninai oi hanona au i'aba'u haumu aha'i.” ");
INSERT INTO rro_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simona Petero ia ehina bena etibaha, “Obiapaka e, ae'u mo ikupaiakia aha'i, 'a ima'u mai ara'u abomo koutunakia.” ");
INSERT INTO rro_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Iesu ia ehina bena etibaha, “Hau ha aba e'uere hauna hanona hauna maikoina aba emahamaha ba aena mo keutunakia. Wai hanona aba tomahamaha, iamo hamona hanona aha'i.” ");
INSERT INTO rro_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Pokina Iesu e'iobina tai hanona ia kehinahinaina, weiana buonai e'abi etibaha, “Ikoimiai hanona tomahamaha iamo hamona hanona aha'i.” ");
INSERT INTO rro_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Weiana aekia eutunakia murinai ena ibatoto habuni ea'ina ebatoto muena. Emue 'ekanai emiati. Ia ehore ebakainakia etibaha, “Au taba heremiai ababaina hauna anina to'iobina? ");
INSERT INTO rro_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Wai au tuaparina'u emi ba'iobi hau'u mai Obiapaka, ua tu'abi aiho hanona ebero, pokina au hanona ua homa'u. ");
INSERT INTO rro_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ba au emi Obiapaka mai emi ba'iobi hau'u iamo aemi autunakia raninai wai abomimo 'abami ha ha aekia katoutunakia. ");
INSERT INTO rro_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Au babai neiana heremiai ababaina toihana hauna ihobonai mo katobabaina. ");
INSERT INTO rro_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","'Abi tohana au wai nahina benimi, ta'ara'i hauna hanona ena poki hauna a'i etara haona, ihobona mo iuhubeau hauna hanona euhuna hauna a'i etara haona. ");
INSERT INTO rro_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Bariu babai neiakia ababainakia anikia aba to'iobinakia, ba taeara ihobonai katobabainakia hanona wai Tirama kebanamonimi. ");
INSERT INTO rro_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Au ikoimiai robami a'i nahuna, ia weiakia atina'anakia haukia hanona a'iobinakia. Ia weiana hanona Puka robenai tererena 'abina nibatohana, ‘Tararua parawa ṯani haeamo hauna ehore au ni'oatana'u.’ ");
INSERT INTO rro_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Bariu taba neiana a'i nirama baha aonai naba'iobi baihanimi, pokina taba weiana kerama raninai wai katoa'ikakauma au hanona miaho banaibanai hau'u. ");
INSERT INTO rro_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","'Abi tohana au wai nahina benimi, hau ha au auhuna hauna nia'i taeana hauna hanona au nia'i taeana'u, mai hau ha au nia'i taeana'u hauna hanona euhuna'u hauna abomo nia'i taeana.” ");
INSERT INTO rro_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Iesu 'abi neiana ehinana murinai ia aona epuma e'abi etibaha, “'Abi tohana mo au wai nahina benimi. Wai hau ha au kohinahinaina'u.” ");
INSERT INTO rro_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Weiana buonai i'abana haukia kipokia tebaiha maiaina a'i te'iobina ia hanona tai robana niahuna. ");
INSERT INTO rro_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ia i'abana haukia ha Iesu ena raona'au hauna Iesu herenai emiati. ");
INSERT INTO rro_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Weiana Simona Petero mahana ebairu ia herenai ba etibaha, ‘Mobakaina ia tai robana niahuna.’ ");
INSERT INTO rro_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ia Iesu herenai emiati hauna eiru haha Iesu herena ebakaina etibaha, “Obiapaka e, oi tai robana nuahuna?” ");
INSERT INTO rro_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Iesu ia ena 'abi ebamuena etibaha, “Parawa papana 'ororo aonai kakaihuna kabena hauna iamo weiana.” Ba Iesu ehore parawa ea'ina 'ororo aonai ekaihuna ba Iuda ebena, ia hanona Simona nahuna Isakariote hauna. ");
INSERT INTO rro_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Beronai Iuda parawa ea'ina eana hanona Satani ia aonai etoto. Weiana Iesu Iuda ehina bena etibaha, “Taba kobabaina hauna mobabai biaina.” ");
INSERT INTO rro_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Weiakia aniani 'ekanai temiati haukia Iesu Iuda ua ehinabe aihona hanona obona a'i teobo. ");
INSERT INTO rro_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Iuda hanona moni puteputena e'imana paunai baika teraonana Iesu ia ehina bena taba tatuai tenuatae ainakia haukia kekawanakia, 'ao taba baika uraru haukia kebenakia. ");
INSERT INTO rro_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Iuda parawa puana papana ea'ina eana murinai, beronai emikiri ekarahi, ba weiana hanona aba erabi. ");
INSERT INTO rro_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Iuda ekamuri aonai, Iesu e'abi etibaha, “Bariu hanona au Maearima Nahuna e'u nuabi kewaira tina mai au hau'uai Tirama ena nuabi abomo kewaira tina. ");
INSERT INTO rro_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ba au hau'uai Tirama ena nuabi kewaira tina raninai Tirama abomo au Maearima Nahuna e'u nuabi kebawaira tinana, ba beronai mo kebabaina. ");
INSERT INTO rro_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","E'u raona'au miorimi e, au hanona rani papana mo wai kipokia kahamiaho. Ba wai au katotabuna'u. Iuda haukia aba ahina benakia ihobonai bariu wai nahina benimi, au kaeao 'ekana wai katoao hanona a'i ketaina. ");
INSERT INTO rro_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Au rauhubu 'abina mahamahana wai nabenimi, wai ha ha katoraona'au ainimi. Au wai araona'au ainimi ihobonai wai abomo ha ha katoraona'au ainimi. ");
INSERT INTO rro_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Wai ha ha katoraona'au ainimi raninai, maearima ikoikiai kate'iobina wai hanona au i'aba'u haumi.” ");
INSERT INTO rro_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simona Petero ia ebakaina etibaha, “Obiapaka e, oi hanona aeana nuao?” Iesu e'abi etibaha, “Au bariu naeao 'ekana oi muri'uai komai hanona a'i ketaina, 'a muriai hanona muri'uai komai.” ");
INSERT INTO rro_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petero e'abi etibaha, “Obiapaka e, aehoma buonai bariu murimuai ka'au hanona a'i ketaina? Au hanona aba aba'oru oi paumuai ka'ari.” ");
INSERT INTO rro_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ba Iesu ia ena 'abi ebamuena etibaha, “Oi au pau'uai ko'ari, u? 'Abi tohana au oi nahina beni'o, kokoro'u a'i kearara baha aonai oi rani aihau au kobuniai aina'u.” ");
INSERT INTO rro_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Iesu e'abi etibaha, “Aomi a'i katearo'ari. Tirama kato a'ikakaumana, au abo'umo kato a'ikakaumana'u. ");
INSERT INTO rro_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Hama'u ena itu aonai miaho 'ekakia hanona ebo'o, peaha'i raninai au wai aba pahina benimi. Au kaeao 'eka ha ka'ia'i haraina wai 'eumi. ");
INSERT INTO rro_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Weiana au kaeao 'eka ha ka'ia'i haraina wai 'eumi, murinai kamue kamai ka'inimi kahaeao au ae'eai kamiaho hanona wai abomimo weia. ");
INSERT INTO rro_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Au kaeao 'eka weiana taearana hanona wai aba to'iobina.” ");
INSERT INTO rro_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Toma Iesu ehina bena etibaha, “Obiapaka e, oi koao 'ekana hanona ai a'i ṯa'iobina, ba katawahi taearana hanona aea kata'iobi aihona?” ");
INSERT INTO rro_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Iesu Toma ehina bena etibaha, “Taearana hanona au, 'abi tohana abomo au, haeamona mauri abomo au. Hamaka herena kateao haukia ikoikiai ekia taeara hanona au. ");
INSERT INTO rro_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Wai au pato 'iobina'u raninai, Hama'u abomo aba pato'iobina, bariu waira keaoaina aonai ia aba to'iobina abomo aba toihana.” ");
INSERT INTO rro_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pilipo Iesu ehina bena etibaha, “Obiapaka e, emai nuatae tohana hanona neiana, Hamaka mobaihanamai.” ");
INSERT INTO rro_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Iesu ena 'abi ebamuena etibaha, “Pilipo e, rani ehoma'a aba kipokia hamiaho oioi, iamo oi hanona au a'i o'iobina'u, u? Hau ha au eihana'u hauna hanona Hama'u aba eihana, ae homa buonai nu'abi, Hamaka mobaihanamai. ");
INSERT INTO rro_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Pilipo, nua'ikakaumana'u, au hanona Hama'u aonai mai Hama'u hanona au ao'uai. 'Abi neiakia nahinanakia heremiai hanona au kipo'u e'u nuataeai a'i na'abi, weiana hanona Hama'u au ao'uai nemiaho hauna ena aka nibabainakia. ");
INSERT INTO rro_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Tomo a'ikakaumana weiana a'abi au hanona Hama'u aonai mai Hama'u hanona au ao'uai, aha'i raninai aka ababainakia haukia paukiai tomo a'ikakaumana'u. ");
INSERT INTO rro_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“'Abi tohana mo au wai nahina benimi, hau ha au nia'ikakaumana'u hauna aka nababainakia haukia ia abomo kebabainakia. Haeamona aka apa'uakia tohakia abomo kebabainakia, pokina au naeao Hama'u herena. ");
INSERT INTO rro_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ba au ata'uai taba ikoikiai katonoi ainakia hanona kababainakia. Weiana Hama'u ena nuabi hanona kewaira tina nahuna paunai. ");
INSERT INTO rro_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Weiana au ata'uai taba ikoikiai katonoi ainakia hanona au kahore kababainakia. ");
INSERT INTO rro_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Wai au katoraona'au aina'u raninai e'u rauhubu 'abikia hanona katobabua 'aunakia. ");
INSERT INTO rro_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Au kahore Hama'u kanoina ba Baraibarai hauna kebenimi, ia hanona 'abi tohana Auba Robena wai heremiai kemiaho banaibanai. ");
INSERT INTO rro_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ia hanona 'abi tohana Auba Robena, hanopaka haukia hanona a'i katea'i taeana pokina a'i teihana mai a'i te'iobina, 'a wai hanona ia to'iobina pokina ia hanona wai heremiai nemiaho mai wai aomiai kemiaho. ");
INSERT INTO rro_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Au hanona a'i kahabo 'abaeanimi matoha miori hamana hinana aha'i hauna 'abana, au hanona kamue kamai heremi. ");
INSERT INTO rro_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Rani papana murinai hanopaka haukia hanona au a'i kateiha muena'u, ia wai hanona au katoihana'u, pokina au namauri haeamona wai abomimo katomauri paunai. ");
INSERT INTO rro_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Wapu weiana kemai aonai wai kato'iobina au hanona Hama'u aonai, wai hanona au ao'uai, ihobona mo au hanona wai aomiai. ");
INSERT INTO rro_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Hau ha au e'u rauhubu 'abikia nia'i taeanakia mai nibabua 'aunakia hauna hanona au niraona'au aina'u, ia au niraona'au aina'u hauna Hama'u kehore ia keraona'au aina. Ba au abomo ia karaona'au aina, mai ia herenai kawaira tina.” ");
INSERT INTO rro_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Iuda Isakariote hauna aha'i ia Iuda haeai ha hauna Iesu ebakaina etibaha, “Obiapaka e, aehoma buonai ai mo heremaiai kowaira tina, ia hanopaka haukia herekiai hanona a'i kowaira tina?” ");
INSERT INTO rro_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Iesu Iuda ena 'abi ebamuena etibaha, “Hau ha au niraona'au aina'u hauna e'u ba'iobi 'abikia kebabua 'aunakia, Hama'u kehore ia keraona'au aina, haeamona au mai Hama'u ohi katamai herenai kipokia katamiaho. ");
INSERT INTO rro_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Hau ha au a'i niraona'au aina'u hauna hanona e'u 'abi a'i nibabua 'aunakia. 'Abi neiakia aiakia tuo'o haukia hanona au kipo'u e'u 'abi aha'i ia Hama'u euhuna'u hauna ena 'abi. ");
INSERT INTO rro_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Au wai kipokia hamiaho oioi aonai taba neiakia hanona aba ahinanakia heremiai. ");
INSERT INTO rro_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","'A Baraibarai hauna Auba Robe, au ata'uai Hama'u keuhuna hauna kehore taba ikoikiai keba'iobinimi, mai 'abi weiakia ikoikiai ahina haukia kebaraona tinanimi. ");
INSERT INTO rro_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Baibua wai heremiai nahabona. Au e'u baibua wai nabenimi, weiana hanona hanopaka 'euna nibaibeni hauna 'abana aha'i. Aomi a'i kearo'ari mai a'i katota'u. ");
INSERT INTO rro_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Wai a'abi au kahabonimi hanona aia'u aba to'ona, ia haeamona kamue kamai heremi. Wai au turaona'au aina'u raninai, au naeao Hama'u herena hanona aomi kenamo pokina ia hanona etarahi ba au. ");
INSERT INTO rro_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Au taba neiakia bariu aba naba'iobi 'uainimi ba muriai katerama, ba weiakia katerama aonai wai hanona aba katoa'ikakauma. ");
INSERT INTO rro_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Au wai kipokia a'i kaha'abi'abi homa'ana pokina hanopaka neiana nipoki aina hauna aba nimai. Ia hanona au here'u ai ena hiabu aha'i, ");
INSERT INTO rro_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ia hanopaka ke'iobina, au hanona Hama'u naraona'au aina mai Hama'u ena 'abi ihobonai au nababaina. Tomikiri hamaka'a.” ");
INSERT INTO rro_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Iesu e'abi etibaha, “Au hanona bine matiuna toha'u, ia Hama'u hanona haharua poki hauna. ");
INSERT INTO rro_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ia nihore au re ikoikiai aha'uai a'i tebua'a haukia hanona nikabe obonakia mai re weiakia tebua'a haukia ikoikiai ia nihore nirorinakia katemahamaha weiana buakia bo'ona katehore ahinakia. ");
INSERT INTO rro_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Wai hanona 'abi neiakia ahinabe ainimi haukia paukiai aba tomahamaha. ");
INSERT INTO rro_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Wai au ao'uai katomiaho, au abomo wai aomiai kamiaho. Re kipona a'i kebua'a 'abaea, ia re hanona bine matiuna ahanai kekomo 'au harai hanona kebua'a. Weiana ihobonai mo wai au hau'uai a'i katokomo 'au harai hanona buami a'i katerama. ");
INSERT INTO rro_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Au hanona bine matiuna wai hanona rena. Hau ha au ao'uai, mai au ia aonai namiaho hauna hanona buabua bo'okia kebaramanakia, au katohabona'u raninai wai taba ha katobabaina hanona a'i ketaina. ");
INSERT INTO rro_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Hau ha au ao'uai a'i kemiaho raninai, ia hanona katene'ena re 'abana ke'ororo. Ba re uahomakia hanona katebararonakia iruba aonai katekapo totonakia weia kate'ara. ");
INSERT INTO rro_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Wai au ao'uai katomiaho mai e'u 'abi wai aomiai katemiaho raninai ṯonuataeai tabakia katonoiai haukia ikoikiai Hama'u kehore kebenimi. ");
INSERT INTO rro_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Wai buabuami katebo'o au i'aba'u haumi ai katoao raninai Hama'u ena nuabi kewaira tina. ");
INSERT INTO rro_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Hama'u au niraona'au aina'u ihobonai, au abomo wai ua naraona'au aihonimi. Bariu hanona e'u raona'au aonai katomiaho. ");
INSERT INTO rro_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Au Hama'u ena rauhubu 'abikia ababua 'aunakia paunai ena raona'au aonai namiaho, ihobonai wai e'u rauhubu 'abikia katobabua 'aunakia raninai, wai abomo au e'u raona'au aonai katomiaho. ");
INSERT INTO rro_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Au 'abi neiana aba ahinabe ainimi buonai e'u aonamo hanona wai aomiai kemiaho, weianai emi aonamo hanona keapa'ua harai. ");
INSERT INTO rro_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Au e'u rauhubu 'abina hanona neiana. 'Abami ha ha katoraona'au ainakia ihobona mo au wai araona'au ainimi 'abana. ");
INSERT INTO rro_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Hau ha ena raona'au keapa'uana ki'a baha ena hau herekiai raninai, ena mauri kebaibeni ia paukiai. ");
INSERT INTO rro_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Au taba a'uahina hauna katobabaina raninai, wai hanona au e'u hau. ");
INSERT INTO rro_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Bariu keaoaina aonai au a'i kapari muenimi ta'ara'i haumi, pokina ta'ara'i hauna hanona ena poki hauna taba nibabaina hauna ia a'i e'iobina. Ia au wai naparinimi e'u hau, pokina taba Hama'u herenai a'iobi haukia aba aba'iobinimi. ");
INSERT INTO rro_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","“Wai au a'i totina'ana'u 'a au wai atina'animi mai a'itaeanimi weiana katoao buabuami katobarama, buabua weiakia katemiaho banaibanai. Ba taba au ata'uai katonoi ainakia haukia Hama'u kehore kebenimi. ");
INSERT INTO rro_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","E'u rauhubu 'abina hanona neiana. 'Abami ha ha katoraona'au ainakia. ");
INSERT INTO rro_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Hanopaka haukia kate'oatanimi raninai, kato'iobina ia au te'oata 'uaina'u ba wai ti'oatanimi. ");
INSERT INTO rro_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Wai hanopaka 'eunai katoao raninai, ia kehore keraona'au ainimi ihobona ia 'euna tohana. Ia wai hanona hanopaka 'euna aha'i. Ia au hanopakai atina'animi paunai hanopaka nihore wai ni'oatanimi. ");
INSERT INTO rro_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","'Abi heremiai ahina haukia katoraona 'ininakia, ta'ara'i hauna hanona ena poki hauna a'i etara haona. Au kateba haiarana'u raninai, wai abomimo kateba haiaranimi. Au e'u 'abi katebabua 'aunakia raninai wai abomimo emi 'abi katebabua 'aunakia. ");
INSERT INTO rro_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Wai hanona au eu'u paunai hoahoa neiakia heremiai katebabainakia, pokina euhuna'u hauna a'i te'iobina. ");
INSERT INTO rro_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Au a'i pamai a'i pahina benakia raninai ia hanona ekia ki'a behona peaha'i. Ia bariu ekia ki'a katebunina taearana hanona aba aha'i. ");
INSERT INTO rro_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Hau ha au ni'oatana'u hauna hanona Hama'u abomo ni'oatana. ");
INSERT INTO rro_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Au hoa neiakia hau ha a'i ebabai haukia a'i pababainakia ia baiatakiai raninai ia ekia ki'a hanona peaha'i. Ia bariu hanona hoa neiakia aba teihanakia, iamo au Hama'u ohi tararua ti'oatanamai. ");
INSERT INTO rro_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","'A ia neiana tebabaina hanona 'abi weiana ekia rauhubu pukana aonai tererena hauna katebatohana paunai, ‘Ia au te'oata 'abaeana'u hanona ena poki aha'i.’ ");
INSERT INTO rro_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Baraibarai hauna 'abi tohana Auba Robena, Hama'u herenai kemai kauhuna kewahi heremi, ba ia hanona au pou'u kehinana. ");
INSERT INTO rro_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Weiana wai abomimo au pou'u katohinana pokina kipokia popounai hamiaho emai mo bariu.” ");
INSERT INTO rro_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Iesu ehina benakia etibaha, “Au 'abi neiakia ikoinai ahinanakia heremiai ena poki hanona emi a'ikakauma a'i me'akauma marikina. ");
INSERT INTO rro_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Wai hanona mareai kateba karahinimi. 'Abi tohana beraura ha kemai aonai maearima katehore kateahu 'arinimi, ia kateraonana babai weiana hanona aba Tirama tibanamona. ");
INSERT INTO rro_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Taba neiakia katebabainakia heremiai pokina ia hanona Hama'u 'ao au a'i te'iobinamai. ");
INSERT INTO rro_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ia 'abi neiakia heremiai ahinanakia hanona ranina kemai aonai au aba'iobinimi 'abikia aba katoraona tinanakia. “Ia 'uainai hanona a'i ahina benimi pokina au wai kipokia hamiaho paunai. ");
INSERT INTO rro_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","'A bariu au hanona aba naeao euhuna'u Tiramana herena, ia wai hau ha a'i nubakaina'u a'i notibaha, ‘Oi hanona aeana nuao?’ ");
INSERT INTO rro_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ia 'abi neiakia ahinanakia heremiai paunai aomi aoko'o mo ebonu. ");
INSERT INTO rro_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","'Abi tohana mo au wai nahina benimi, au kaeao hanona wai namo katoa'ina. Pokina au a'i kaeao raninai baraibarai hauna a'i kemai heremi, iamo au kaeao raninai ia kauhuna kemai heremi. ");
INSERT INTO rro_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Weiana ia kemai raninai hanopaka haukia ki'a, bero mai Tirama ena bakai taearana a'i te'iobina hauna keba'iobinakia. ");
INSERT INTO rro_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ia ki'a robana keahuna pokina maearima au a'i tia'ikakaumana'u. ");
INSERT INTO rro_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Bero robana keahuna pokina au naeao Hama'u herena ba wai hanona au a'i katoiha muena'u paunai. ");
INSERT INTO rro_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Bakai robana keahuna pokina hanopaka neiana obiana hauna aba bakai ea'ina puma nihoaina paunai. ");
INSERT INTO rro_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Au hanona 'abi bo'ona ṯemiaho wai pahina benimi, iamo katoa'inakia hanona a'i ketainimi. ");
INSERT INTO rro_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Weiana 'abi tohana Auba Robena kemai raninai, ia kehore ke'uai ainimi 'abi tohana taearana ikoikiai aokiai. Ia kipona ena nuataeai a'i ke'abi, ia taba niona hauna mo kehinana mai taba kerama hauna wai keba'iobinimi. ");
INSERT INTO rro_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ia kehore e'u nuabi kebawaira tinana pokina taba au here'uai kea'i haukia wai keba'iobinimi. ");
INSERT INTO rro_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Hama'u ena taba ikoikiai hanona au 'eu'u. Weiana buonai a'abi atibaha, Auba Robe taba 'eu'uai hauna kea'ina wai keba 'iobinimi. ");
INSERT INTO rro_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Rani papana aonai wai au a'i katoihana'u, ba rani papana murinai hanona wai au katoihana'u.” ");
INSERT INTO rro_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ia i'abana haukia baika kipokia baiatakiai tebakai bakai tetibaha, “Ni'abi netibaha, ‘rani papana aonai a'i katoihana'u, ba rani papana murinai hanona wai au katoihana'u,’ ‘pokina au hanona Hama'u herena naeao,’ 'abi weiana anina hanona taba?” ");
INSERT INTO rro_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ia kipokia te'abi 'abi tetibaha, “Rani papana anina hanona taba? Aika ia taba ne'uahina hauna obona a'i nahaobo.” ");
INSERT INTO rro_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Iesu e'iobina i'abana haukia ṯenuatae katebakaina buonai ehina benakia etibaha, “E'u 'abi neiana, ‘rani papana aonai a'i katoihana'u ba rani papana murinai wai au katoihana'u’ hauna wai kipomi baiatamiai tubakai bakai aina, 'u? ");
INSERT INTO rro_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","'Abi tohana au wai nahina benimi, wai hanona katohai mai aomi kehaihai, iamo hanopaka maearimakia hanona kateaonamo. Wai hanona aomi keaoko'o, ia emi aoko'o hanona kebaebo aonamoai keao. ");
INSERT INTO rro_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Babi'e ha miori kebaramana raninai nihaiara pokina ena mauri ranina aba etaina, ia miori aba erama raninai ena haiara nirea 'iti'itina ia aona ninamo pokina miori ha aba erama hanopakai. ");
INSERT INTO rro_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ihobona uahomana bariu hanona emi aoko'o beraurana, ia au hanona wai kaiha muenimi weiana wai katoaonamo, ba hau ha emi aonamo weiana a'i kea'i parena. ");
INSERT INTO rro_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Rani weiana kemai aonai wai hanona au here'uai taba ha a'i katobakai bakaiaina. 'Abi tohana au wai nahina benimi, ṯonuatae tabakia au ata'uai Hama'u katonoina hanona kebenimi. ");
INSERT INTO rro_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ata'uai a'i tonoi 'apua emai mo bariu. Wai katonoina hanona kebenimi katoa'ina, weiana emi aonamo hanona aomiai kebonu 'auna. ");
INSERT INTO rro_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Au ahina benimi 'abikia ikoinai hanona 'abi ibabatai ai ahinanakia, ia ranina kemai aonai au wai 'abi ibabatai ai a'i kahina benimi, ia Hama'u pouna kahina haraina. ");
INSERT INTO rro_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Rani weiana aonai au ata'uai katonoi, ia au a'i na'abi Hama'u kanoina wai kebarainimi, ");
INSERT INTO rro_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","pokina Hama'u kipona wai niraona'au ainimi, weiana wai au turaona'au aina'u, abomo au Tirama herenai amai hauna tubatohana'u paunai. ");
INSERT INTO rro_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Au hanona Hama'u herenai ba amai hanopaka neianai namiaho, ia bariu hanona hanopaka nahabona namue naeao Hama'u herena.” ");
INSERT INTO rro_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Weiana i'abana haukia tehina bena tetibaha, “Bariu emu 'abi hanona ea harai, 'uaina 'abi ibabataiai o'abi 'abana aha'i. ");
INSERT INTO rro_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Bariu ai hanona oi a'i katabakai mueni'o, ba aba ṯa'iobina oi hanona taba ikoikiai o'iobinakia, weiana ai ṉuba a'ikakaumanamai oi hanona Tirama herenai omai.” ");
INSERT INTO rro_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Iesu ekia 'abi eba muena etibaha, “Bariu mo muri 'akinai tua'ikakaumana'u, u? ");
INSERT INTO rro_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Rani hanona nimai, ia aba ekara'au, weiana wai ikoimiai katorama otaraina, haha emi aiara katoao. Au katohabona'u kaikupai. Iamo au hanona a'i kaikupai, pokina Hama'u hanona au here'uai. ");
INSERT INTO rro_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Au wai 'abi neiakiai aba ahina benimi, au wai kipokia kahabahamomo aonai baibua katoa'ina. Hanopaka neiana hanona kebatetuanimi, ia katonuako'o, au hanona hanopaka aba ahao haina.” ");
INSERT INTO rro_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Iesu 'abi neiana ehinana murinai, ea'a taea kupa eihana ba ebahuba'ari etibaha, “Hama'u e, rani aba ekara'au nahumu ena nuabi mobawaira tinana, ba nahumu abomo oi emu nuabi kebawaira tinana. ");
INSERT INTO rro_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Pokina oi hiabu obena maearima ikoikiai ke'uai ainakia, maearimakia ikoikia weiakia oi ohore nahumu obena haukia mauri banaibanai kebenakia. ");
INSERT INTO rro_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Mauri banaibanai hanona neiana, maearima oi kate'iobini'o, oi hanona ikupaiamu mo Tirama tohamu, abomo kate'iobina Iesu Keriso oi ouhuna hauna. ");
INSERT INTO rro_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","“Aka obena'u kababaina hauna aba abaorena, ba emu nuabi hanopaka ahanai aba abaiha baihaina. ");
INSERT INTO rro_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Hama'u e, nuabi weiana hanopaka a'i erama baha aonai heremuai hamiaho aina hauna ihobonai bariu wairamuai e'u nuabi mobawaira tinana. ");
INSERT INTO rro_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Au atamu abawaira tinana maearima neiakia wairakiai, ia hanona oi 'eumu oi ohore au obena'u, ba ia emu 'abi aiana teka'aina. ");
INSERT INTO rro_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Bariu ia aba te'iobina taba ikoikiai obena'u haukia hanona oi heremuai temai. ");
INSERT INTO rro_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Pokina 'abi weiakiai ohina bena'u haukia, ia aba'iobinakia hanona tea'i taeanakia, ba te'iobina au hanona oi heremuai amai abomo tebatohana oi hanona au ouhuna'u. ");
INSERT INTO rro_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Au ia paukiai nabahuba'ari. Au hanopaka maearimakia paukiai a'i nabahuba'ari, ia weiakia obena'u haukia paukiai, nabahuba'ari pokina ia hanona oi 'eumu. ");
INSERT INTO rro_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Au 'eu'u haukia ikoikiai hanona oi 'eumu, oi 'eumu haukia ikoikiai hanona au 'eu'u, ba ia paukiai e'u nuabi ewaira tina. ");
INSERT INTO rro_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Au hanona hanopaka nahabona ba kawahi oi heremu, 'a ia hanona hanopakai ṯemiaho oho. Hama'u Robemu e, atamu weiana obena'u hauna hiabunai ko'aeabunakia weiana ia ketehamomo ihobona aika habahamomo 'abana. ");
INSERT INTO rro_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Au ia kipokia tamiaho aonai a'ima harainakia oi atamu obena'u hauna hiabunai a'aeabunakia. Ha a'i e'akauma, 'a ke'akauma maearimana hamona hauna mo e'akauma, puka robena 'abina kebatohana paunai. ");
INSERT INTO rro_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Au hanona bariu nawahi oi heremu, ia hanopakai namiaho oho aonai 'abi neiakia nahinanakia, weiana ia aokiai e'u aonamo maikoina katea'ina. ");
INSERT INTO rro_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","“Emu 'abi aba abenakia ba hanopaka hanona aba ni'oatanakia, pokina au hanona hanopaka 'euna aha'i ihobona ia abomo hanopaka 'euna aha'i. ");
INSERT INTO rro_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","E'u noi hanona hanopakai a'i koa'i parenakia ia tiaporo herenai ko'aeabunakia. ");
INSERT INTO rro_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Au hanona hanopaka 'euna aha'i ihobonai ia abomo hanopaka 'euna aha'i. ");
INSERT INTO rro_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Emu 'abiai kobarobenakia emu maearima tohakiai kateao, emu 'abi hanona 'abi tohana. ");
INSERT INTO rro_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Oi au ouhuna'u amai hanopaka maearimakia baiatakiai amiaho ihobona mo au ia auhunakia teao hanopaka maearimakia baiatakiai ṯemiaho. ");
INSERT INTO rro_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ia paukiai au kipo'u abarobena'u oi 'eumu, weiana ia abomo kipokia kateba robenakia oi 'eumu. ");
INSERT INTO rro_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Au e'u bahuba'ari hanona ia mo ikupaiakia ahakiai aha'i, ia ekia 'abiai au katea'ikakauma'u haukia ahakiai abomo nabahuba'ari. ");
INSERT INTO rro_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Hama'u e, oi hanona au ao'uai mai au hanona oi aomuai, ihobonai ia ikoikiai hanona aokia kehamona. Ia abomo katemai aika aokai weianai hanopaka maearimakia kate'iobina oi hanona au ouhuna'u. ");
INSERT INTO rro_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nuabi obena'u hauna aba ia abenakia, weiana oi mai au aoka ehamona ihobonai ia abomo aokia kehamona. ");
INSERT INTO rro_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Au hanona ia aokiai mai oi hanona au ao'uai. Ba ia aokia kehamomo harai hanopaka maearimakia kate'iobina oi hanona au ouhuna'u, au oraona'au aina'u ihobonai oi ia abomo nuraona'au ainakia. ");
INSERT INTO rro_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Hama'u e, au nanuatae weiakia obena'u haukia kipokia au ae'eai hanona ia abomo weia, ba ia weia e'u nuabi kateihana, nuabi weiana hanona hanopaka a'i obabai bahana aonai oi au oraona'au aina'u paunai obena'u hauna. ");
INSERT INTO rro_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Hama'u bero haumu e, hanopaka maearimakia hanona oi a'i ṯe'iobini'o, ia mo au hanona oi a'iobini'o mai e'u maearima neiakia te'iobina oi hanona au ouhuna'u. ");
INSERT INTO rro_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Au hanona oi atamu aba'iobinakia mai rani ikoinai kaba'iobi to'onakia, pokina emu raona'au here'uai hauna hanona ia herekiai abomo kemiaho, ba au abomo ia aokiai kamiaho.” ");
INSERT INTO rro_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Iesu ena bahuba'ari neiana ehinana epua murinai i'abana haukia kipokia Kidron tatairanai tekabanai teao Olibe haharuana aonai tekatoto. ");
INSERT INTO rro_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Hinahina hauna Iuda abomo 'eka weiana e'iobina, pokina rani bo'ona Iesu mai i'abana haukia kipokia 'eka weianai teto'u. ");
INSERT INTO rro_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Weiana Iuda ehore robe haukia apa'uakia mai Parisea haukia ekia miori weiakia marea robe ṯeiha 'inina haukia mai huari haukia to'ukiai ebaka'anakia, imakia mai irubakia mai ramepakia abomo huari tabakia tea'i haharua weiana aonai tekatoto. ");
INSERT INTO rro_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Iesu taba herenai katerama haukia ikoinai aba e'iobina, ua buonai ekahaha eao herekia ebakainakia etibaha, “Wai tai tutabuna?” ");
INSERT INTO rro_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ia te'abi tetibaha, “Iesu Nasareta hauna.” Ba Iesu e'abi, “Au neia'u.” Hinahina hauna Iuda abomo weia kipokia tekoroti. ");
INSERT INTO rro_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Iesu e'abi “Au neia'u.” raninai ia teta'u tehemue te'eho 'anoai tenoti. ");
INSERT INTO rro_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Iesu haeamona ebakai muenakia etibaha, “Wai tai tutabuna?” Ba ia te'abi mue tetibaha, “Iesu Nasareta hauna.” ");
INSERT INTO rro_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Iesu ehina benakia etibaha, “Aba ahina benimi ‘au neia'u.’ Wai au tutabuna'u raninai, hau neiakia katohabonakia kateka'a.” ");
INSERT INTO rro_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Babai neianai ena 'abi 'uaina ehinana hauna “Aba obena'u haukia ikoinai ha a'i aba'akaumana.” hauna ebatohana. ");
INSERT INTO rro_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simona Petero hanona mai ena kareba, ba weiana eberi 'auna, robe haukia arakiai hauna ena ta'ara'i hauna haiana itipana ehara obona. Ta'ara'i hauna weiana atana hanona Malaku. ");
INSERT INTO rro_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Weiana Iesu Petero e'abi pahihi bena etibaha, “Kareba naiana iutana 'ekanai moutana. Haiara 'erena neiana Hama'u ebena'u hauna a'i kainu, u?” ");
INSERT INTO rro_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Weiana huari haukia ekia poki hauna kipokia mai Iuda haukia apa'uakia marea robe ṯeiha 'inina haukia kipokia Iesu tea'ina tebirina, ");
INSERT INTO rro_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Anna herena teaoai 'uaina, pokina Anna hanona Kaiafa rawana. Kaiafa hanona robe haukia 'arakiai hauna ihau weianai. ");
INSERT INTO rro_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Weiana 'uainai Kaiafa ena raonai Iuda haukia apa'uakia ehina benakia etibaha, “Namona hanona hau hamona ke'ari maearima ikoikiai paukiai.” ");
INSERT INTO rro_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simona Petero mai Iesu i'abana hauna ha ohi Iesu murinai teao. I'abana hauna weiana hanona robe haukia arakiai hauna e'iobi haraina paunai ia hanona Iesu murinai robe haukia arakiai hauna ena itu parabuna aonai ekatoto. ");
INSERT INTO rro_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","'A Petero hanona ua'a pa'abi 'akonai ebai'ima, i'abana hauna weiana robe haukia arakiai e'iobi haraina hauna emue emai pa'abi ne'imana uahona ehina bena, ba Petero ebatotona parabu aonai. ");
INSERT INTO rro_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Pa'abi ne'imana uahona weiana Petero ebakaina etibaha, “Oi abomo hau weiana i'abana haumu ha, u?” Petero etibaha, “Au aha'i.” ");
INSERT INTO rro_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","'Ama ranina buonai ta'ara'i haukia mai marea robe ṯeiha 'inina haukia iruba teba'arana herenai tekoroti eraranakia haukia katehiabunakia. Petero abomo ia baiatakiai iruba eraranakia. ");
INSERT INTO rro_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Rani weianai robe haukia 'arakiai hauna Anna, Iesu herenai i'abana haukia mai ena ba'iobi 'abikia ebakai bakai ainakia. ");
INSERT INTO rro_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Iesu ia ena 'abi ebamuena etibaha, “Au hanona rani ikoikiai mako wairakiai a'abi'abi, au rani ikoikiai Iuda haukia ekia to'u 'ekakiai weia marea aokiai mai marea robe aonai aba'iobi, au 'abi ha a'i abuni 'apuana. ");
INSERT INTO rro_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Aehoma buonai oi au nubakaina'u? Weiakia e'u 'abi teona haukia mobakainakia, ia te'iobina au 'abi tabana ahinana.” ");
INSERT INTO rro_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Iesu ua e'abi aiho raninai weia marea robe ṯeiha 'inina hauna ha emikiri Iesu wairana ebo'ana etibaha, “Robe haukia 'arakiai hauna ena 'abi ua a'i kobamue aihona.” ");
INSERT INTO rro_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Iesu e'abi etibaha, “Au 'abi ha ahina ki'ana raninai, weiana hauna mohina karahina. Ia au 'abi berona ahinana raninai taba buonai obo'ana'u?” ");
INSERT INTO rro_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Weiana Anna ehore Iesu euhuna imana ibiri 'ini eao Kaiafa robe haukia arakiai hauna herena. ");
INSERT INTO rro_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simona Petero hanona weia iruba herenai ekoroti erarana. Weiana tebakaina tetibaha, “Oi abomo ia i'abana haumu ha, u?” Ia ebuniai etibaha, “Au hanona aha'i.” ");
INSERT INTO rro_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Robe haukia arakiai hauna ena ta'ara'i hauna haiana Petero ehara obona hauna hatia'ana ha ehore Petero ebakaina etibaha, “Weia haharua aonai oi Iesu kipokia aihanimi, u?” ");
INSERT INTO rro_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Petero haeamona ebuniai mue aonai, kokoro'u beronai e'arara. ");
INSERT INTO rro_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Iuda haukia apa'uakia Iesu Kaiafa ena ituai tebakarahina tebaka'ana teaoaina Kabana hauna ena aka itunai. Kabana hauna hanona Romai emai. Weiana hanona aba rani nirerena ba Iuda haukia apa'uakia hanona Kabana ena itu aonai a'i tekatoto, pokina ia hanona ekia hoahoa tainai Tirama wairanai a'i kate'opu Kabanai tatuna aonai kateaniani paunai. ");
INSERT INTO rro_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ua buonai Pilato ekarahi eao herekia ebakainakia etibaha, “Hau neiana beho taba ebabaina buonai tomaiaina here'u?” ");
INSERT INTO rro_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ia ena 'abi tebamuena tetibaha, “Ia ki'a aha'i ebabaina raninai ai hanona ia a'i patamaiaina oi heremu.” ");
INSERT INTO rro_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato ehina benakia etibaha, “Wai kipomi tomoaoaina emi rauhubu ihobonai tomobabakaina.” Iuda haukia apa'uakia te'abi tetibaha, “Ai hau ha 'ariai katahorotina hanona emai rauhubuai hiabu uahomana aha'i.” ");
INSERT INTO rro_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Neiana erama hanona Iesu ena 'abi ehinana hauna ia aea ke'ari aiho 'abina ketohana. ");
INSERT INTO rro_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato ena aka itunai etoto ba Iesu eaparina, ebakaina etibaha, “Oi hanona Iuda haukia ekia obia 'arana, u?” ");
INSERT INTO rro_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Iesu ia ena 'abi ebamuena etibaha, “Bakaibakai naiana hanona oi kipomu emu raonai nohinana, 'ao maearima baika au roba'u teahuna heremuai hauna nohinana?” ");
INSERT INTO rro_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato Iesu ena 'abi ebamuena etibaha, “Ba oi nuraonana au hanona Iuda hau'u? Oi emu maearima tohakia mai robe haukia apa'uakia oi temaiaini'o here'u. Oi beho taba obabaina?” ");
INSERT INTO rro_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Iesu e'abi etibaha, “E'u obia 'ekana hanona hanopaka neiana 'eunai aha'i. Ia e'u obia 'ekana hanopaka neiana 'eunai raninai, e'u maearima pate'au aina'u, Iuda haukia apa'uakia imakiai patebamaurina'u, ia mo e'u obia aiarana hanona hanopaka neianai aha'i.” ");
INSERT INTO rro_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilato ia ebakaina etibaha, “Oi hanona obia 'arana ha, u?” Iesu ia ena 'abi ebamuena etibaha, “'Abi mo naiana aba nohinana, au hanona obia 'arana ha, au arama amai hanopakai ena poki hanona 'abi tohana kabawaira tinana. 'Abi tohana tainai ṯemiaho haukia hanona au aia'u kateona.” ");
INSERT INTO rro_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato e'abi etibaha, “'Abi tohana hanona taba?” Ua e'abi aiho, ba ekarahi mue Iuda haukia apa'uakia ehina benakia etibaha, “Hau neiana herenai beho ha a'i atabu ahina. ");
INSERT INTO rro_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Weiana wai emi hoahoa tainai Kabanai tatuna ranina nitaina hanona wapura hauna ha nabakarahina heremi. Ba wai ṯonuatae Iuda haumi emi obia 'arana Iesu neiana kabakarahina, u?” ");
INSERT INTO rro_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Weiana ena 'abi ioai tebamuena tetibaha, “Aha'i. Hau naiana aha'i. Ai ṯanuatae Baraba kobenamai.” Baraba hanona kakikaki hauna. ");
INSERT INTO rro_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Weiana Pilato 'abi ebaibeni huari haukia Iesu tea'ina teaoaina te'atina. ");
INSERT INTO rro_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Huari haukia 'ini boa boa tehao kaiarona ia aranai tebabau'una, abomo habuni birona ha ia tebabatotona. ");
INSERT INTO rro_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Weiana tekai haha kai haha herenai te'abi tetibaha, “Iuda haukia ekia Obia 'arana e, komauri banai banai!” Ba wairana tebo'ana. ");
INSERT INTO rro_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato haeamona ekarahi, Iuda haukia apa'uakia ehina benakia etibaha, “Tomobahu, au kahore wairamiai kabakarahina weianai kato'iobina herenai beho ha a'i atabu ahi 'apuana.” ");
INSERT INTO rro_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Weiana Iesu ekarahi aonai 'aranai 'ini boaboa ihao kaiaro tebabau'una mai habuni birona tebabatotona ia haunai. Pilato ehina benakia etibaha, “Tomoihana, hauna neiana.” ");
INSERT INTO rro_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Robe haukia apa'uakia mai marea ṯeiha 'inina haukia Iesu teihana raninai teio tetibaha, “Matiu ibiri ropo 'ubinai tomoahu 'arina, matiu ibiri ropo 'ubinai tomoahu 'arina!” Pilato ia ehina benakia etibaha, “Wai kipomi tomoa'ina, matiu ibiri ropo 'ubinai tomoahu 'arina, pokina au beho ha ia herenai a'i atabu ahina.” ");
INSERT INTO rro_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Iuda haukia apa'uakia ia ena 'abi tebamuena tetibaha, “Ai hanona mai emai rauhubu. Rauhubu weiana tainai ia hanona ke'ari, pokina ia kipona Tirama nahunai nibaona.” ");
INSERT INTO rro_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilato aia weiana eona raninai eta'u banaina. ");
INSERT INTO rro_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Pilato ena aka itunai ekatoto mue, Iesu ebakaina etibaha, “Oi ae'eai omai?” Ia Iesu 'abi ha a'i ehinana. ");
INSERT INTO rro_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Weiana Pilato e'abi etibaha, “Oi noubo a'i kohina bena'u, u? Oi o'iobina au hanona mai e'u hiabu oi karubuni'o, 'ao matiu ibiri ropo 'ubinai kahu 'arini'o?” ");
INSERT INTO rro_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Iesu ia ena 'abi ebamuena etibaha, “Tirama hiabu oi a'i pebeni'o raninai oi au koahu 'arina'u hiabuna hanona heremuai aha'i. Ua buonai hau weiana imamuai eutana'u hauna ena ki'a hanona eapa'ua ki'a baha ba oi 'eumu.” ");
INSERT INTO rro_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Rani weianai Pilato taeara etatu Iesu kerubuna. Ia Iuda haukia apa'uakia teio to'ona tetibaha, “Hau naiana korubuna raninai oi hanona obia 'arana Kaisa ena maearima aha'i. Hau ha ia kipona obia 'aranai nibaona hauna hanona Kaisa ni'oatana.” ");
INSERT INTO rro_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilato 'abi neiana eona raninai Iesu ebakarahina, ba ia hanona ena bakai 'ekana imia'aunai emiati, 'eka weiana atana teaparina hanona ‘pihara panabana’, Heberu maeakiai atana hanona ‘Gabata’. ");
INSERT INTO rro_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Rani weiana hanona Kabanai tatuna ia'ia'i haraina ranina, beraura hanona aba eatiaha, Pilato Iuda haukia ehina benakia etibaha, “Emi obia 'arana neiana tomoihana.” ");
INSERT INTO rro_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Weiana ia teio tetibaha, “Tomoahu 'arina, tomoahu 'arina, matiu ibiri ropo 'ubinai tomoahu 'arina!” Pilato ebakainakia etibaha, “Wai au ṯonuataena'u emi obia 'arana naiana kahu 'arina?” Robe haukia apa'uakia te'abi tetibaha, “Emai obia 'arana ha aha'i, Kaisa mo ikupaiana.” ");
INSERT INTO rro_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Weiana Pilato ehore Iesu huari haukia imakiai eutana matiu ibiri ropo 'ubinai kateahu 'arina. Ba huari haukia Iesu tebaka'ana teaoaina. ");
INSERT INTO rro_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Kipona ena matiu ibiri ropo ebuana teao 'eka ha atana ‘'Ara 'ou'ouna’, Heberu maeakiai hanona ‘Golgota’. ");
INSERT INTO rro_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Weia Iesu matiu ibiri ropo 'ubinai tekoko 'auna, hau rua abomo tekoko 'aunakia ha abirai ha abirai, Iesu hanona ibuakiai. ");
INSERT INTO rro_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato hanona marere ha weia matiu ibiri ropo 'ubinai tekoko 'auna ṉa erere aihona, ");
INSERT INTO rro_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Iuda haukia bo'okia marere weiana tetuabina, pokina Iesu tekoko 'auna 'ekana mai Ierusalema aiarana hanona baiatakiai a'i eatau'ai ki'a baha. Abomo marere weiana hanona Heberu maeakiai, Roma maeakiai mai Helene maeakiai tererena. ");
INSERT INTO rro_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Weiana Iuda haukia ekia robe haukia apa'uakia Pilato tehina bena tetibaha, “‘Iuda haukia ekia Obia 'arana’ a'i porerena. Ia ṉa porere aihona, ‘Kipona e'abi, Au hanona Iuda haukia ekia Obia 'arana.’” ");
INSERT INTO rro_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilato ekia 'abi ebamuena etibaha, “'Abi ṉa aha'i, aba arere 'auna hauna uahomana mo kemiaho.” ");
INSERT INTO rro_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Huari haukia Iesu tekoko 'auna murinai ena habuni tea'ina tetapa banina haha puakia tea'i. 'A ena habuni ibatoto aonai hauna hanona itaiore aha'i, maikoina hanona 'ubinai tetaina emai mo ba'ai epua. ");
INSERT INTO rro_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Huari haukia kipokia te'abi'abi tetibaha, “A'i kahatapana ia pu'iai kaha'iobina tai kea'ina.” Ṉa erama aiho hanona Puka robenai tererena 'abina weiana, “Ia e'u habuni tewatena, e'u ibatoto hanona tepu'i aina” Sal 22.18 hauna ketohana. Ba huari haukia hanona babai neiana tebabaina. ");
INSERT INTO rro_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Matiu ibiri ropo herenai tekoroti babi'ekia hanona Iesu hinana mai hinana hatina, ba Maria Klopa atawana mai Maria Magadala babi'ena. ");
INSERT INTO rro_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Iesu hinana mai i'abana eraona'au aina hauna weia tekoroti eihanakia, ba hinana ehina bena etibaha, “Hina'u e, nahumu naiana.” ");
INSERT INTO rro_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","I'abana hauna herenai abomo ehina bena etibaha, “Aia'u mona, hinamu naiana.” Rani weianai eaoaina i'abana hauna weiana ehore Maria ebaka'ana ena ituai temiaho. ");
INSERT INTO rro_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Weiana murinai Iesu e'iobina aka ikoinai aba ebaorenakia, ba Puka robena 'abina kebatohana buonai e'abi etibaha, “'Ako'u ni'ororo.” ");
INSERT INTO rro_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Puou ha weia bine beina mabinai tebabonuna, ba poame ha tea'ina bine beina mabina aonai tehao uhuna, ba hiriboai tebiri 'auna, tetiu taeana eao pinana haianai. ");
INSERT INTO rro_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Iesu bine beina manoina einu murinai e'abi etibaha, “Aba eore.” Ba 'ekuna enobo, e'ari baihana. ");
INSERT INTO rro_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Bariu hanona a'ia'i harai wapuna ia mara hanona Kabanai tatuna, a'i kenamo 'ari haukia weia matiu 'ubinai katemiaho keao mo mara buonai, Iuda haukia apa'uakia Pilato tenoina, matiu 'ubinai tekoko 'aunakia haukia aekia huriakia kateahu hurinakia hauanikia katea'i obonakia. ");
INSERT INTO rro_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Weiana huari haukia teao, Iesu kipokia tekoko 'aunakia haukia herekiai, ba hau kori'uaina aena huriakia teahu hurinakia, haeamona teao 'abana ha herenai aena huriakia teahu hurinakia. ");
INSERT INTO rro_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ia teao Iesu herenai teiha 'iobiaina aba e'ari hanona aena huriakia a'i teahu hurinakia. ");
INSERT INTO rro_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Huari hauna ha ehore Iesu robuna arawaiai ekai ruruna, beronai mo aruaru mai bei tekiki oioi. ");
INSERT INTO rro_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Mahanai eihana hauna 'abina aba ehinana, ia ena 'abi neiana hanona tohana, ia e'iobina ehinana hauna hanona tohana, ba wai ia ebatohana hauna kato a'ikakaumana. ");
INSERT INTO rro_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Aka neiana erama hanona Puka robena 'abina “Huriana ha hamona a'i tebamohu 'apuana.” hauna ebatohana. ");
INSERT INTO rro_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Puka robenai ha haeamona e'abi etibaha, “Maearima robuna tekai ruruna hauna kateihana.” ");
INSERT INTO rro_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Iosepa Arimatea hauna abomo Iesu i'abana hauna ha, iamo kipona a'i ebawaira tinana pokina Iuda haukia apa'uakia eta'u ainakia. Taba weiakia murikiai ia eao Pilato herena enoi Iesu hauanina kea'i obona. Ba Pilato ena 'abiai Iosepa eao Iesu hauanina ea'i obona. ");
INSERT INTO rro_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemo 'uainai rabi ha eao Iesu herena hauna abomo Iosepa e'abana wapaea mai to'ore muramura timikia taburakia rua te'utenakia hauna ea'ina eaoaina, ena puma hanona kilogram harau aihau 'abana. ");
INSERT INTO rro_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Weiana ia terarua Iesu hauanina tea'ina muramurai teutuna mai habuni namona 'ari haukia tiapanakia haunai teapana, Iuda haukia ekia 'ari haukia tia'ia'i harainakia akana ihobonai tebabaina. ");
INSERT INTO rro_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Iesu teahu 'arina 'ekana herenai hanona haharua ha, haharua weiana aonai 'ariahana mahamahana ha, aonai hanona 'ari hauna ha a'i tihore bahana. ");
INSERT INTO rro_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ba Iesu hanona weia tehorena, pokina 'ariahana weiana hanona herekiai abomo rani weiana hanona Kabanai tatuna a'ia'i haraina ranina. ");
INSERT INTO rro_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Wapu kori'uaina Hui raurani wapuranai Maria Magadala babi'ena eao 'ariahana keihana, mahana eao 'uri tekaiabuna piharana aba tea'i parena eihana. ");
INSERT INTO rro_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ia ebeau emue Simona Petero mai i'abana ha Iesu eraona'au aina hauna herekia e'abi etibaha, “Weiakia Obiapaka 'ariahanai aba tea'i parena, ai a'i ta'iobina 'eka tabanai tehorotina.” ");
INSERT INTO rro_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Weiana Petero mai i'abana hauna ha temikiri 'ariahana teao. ");
INSERT INTO rro_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Terarua tebeau haeamona teao ba ha ehore Pereto ebeau haona e'uai eao 'ariahana. ");
INSERT INTO rro_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ia a'i etoto iamo 'uri 'akonai eriba toto, habuni namokia 'anoai tenoti haukia eihanakia. ");
INSERT INTO rro_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simona Petero murihai ebeau emai beronai eao 'ariahana 'urina aonai etoto, habuni namokia tenoti haukia eihanakia. ");
INSERT INTO rro_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Abomo habuni ha Iesu 'arana te'apana hauna hanona iou harai habuni namokia kipokia a'i tenoti haeamo, ia 'eka haeai enoti. ");
INSERT INTO rro_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Weiana aonai i'abana ha 'ariahanai ekara'au 'uai hauna etoto eao eihanakia ba ea'ikakauma. ");
INSERT INTO rro_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Iamo Puka robena 'abina ‘Ia hanona 'ariai kemikiri mue’ hauna obona a'i tiobo baha. ");
INSERT INTO rro_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ba i'abana haukia rua temue ekia itu teao. ");
INSERT INTO rro_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maria hanona 'ariahana haianai ekoroti ehai, ehai aonai eriba toto 'ariahana aona eihana. ");
INSERT INTO rro_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Weiana ia aneru rua habuni porekia tebatotonakia eihanakia, Iesu hauanina tehorotina 'ekanai temiati, ha hanona aena tainai ha hanona 'arana tainai. ");
INSERT INTO rro_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ia tebakaina tetibaha, “Babi'e e, taba nuhai aina?” Ia e'abi etibaha, “E'u Obiapaka aba tea'i parena, 'ekana a'i a'iobina ae'eai tehorotina.” ");
INSERT INTO rro_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ua e'abi aiho ba ekori kabe hanona Iesu weia ekoroti eihana, ia a'i e'iobina weiana hanona Iesu. ");
INSERT INTO rro_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Iesu ia ebakaina etibaha, “Babi'e e, taba nuhai aina? Tai nutabuna?” Maria eraonana ia hanona haharua i'imana hauna ha, ba e'abi etibaha, “Obiamu e, oi ia oaoaina ae'eai ohorotina hanona au moba'iobina'u. Ba au kaeao ka'ina.” ");
INSERT INTO rro_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Iesu eapari, “Maria e!” Maria ekori kabe, Heberu maeanai e'abi etibaha, “Raboni!” ('Abi neiana anina hanona ‘ba'iobi haumu.’) ");
INSERT INTO rro_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Iesu Maria ehina bena etibaha, “A'i koa'i 'inina'u, pokina a'i nakara'au baha hama'u herena. Ia koao 'uahoaba'u kohina benakia, au hanona kakara'au au hama'u mai wai hamami abomo e'u Tirama mai emi Tirama herena kaeao.” ");
INSERT INTO rro_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Weiana Maria Magadala babi'ena eao i'abana haukia ehina benakia ia Obiapaka eihana, haeamona Iesu 'abi ehinana haukia ia ehina benakia. ");
INSERT INTO rro_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Rani weiana hamonai wapu kori'uaina Huiai beraura ekaihuna aonai, i'abana haukia ikoinai 'eka hamonai teto'una, itu pa'abina tekaiabunakia, pokina Iuda haukia apa'uakia teta'u ainakia. Ba Iesu eao baiatakiai ekoroti ehina benakia etibaha, “Baibua heremiai kemiaho.” ");
INSERT INTO rro_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","'Abi neiana ehinana murinai imana rua mai robuna ebaihanakia. I'abana haukia Obiapaka teihana buonai teaonamo ki'a. ");
INSERT INTO rro_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Iesu haeamona ehina benakia etibaha, “Baibua heremiai kemiaho. Hama'u au euhuna'u ihobonai, au abomo wai nauhunimi.” ");
INSERT INTO rro_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ua e'abi aiho murinai maeabuna ebahi benakia, e'abi etibaha, “Wai Auba Robe tomoa'ina. ");
INSERT INTO rro_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Maearima ekia ki'a katohina hao raninai ekia ki'a hanona ihina haoai kateao, ia ekia ki'a a'i katohina hao raninai ekia ki'a ihina hao aha'i.” ");
INSERT INTO rro_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","I'abana haukia harau haea rua ha atana Toma, tiaparina bai'apaea, Iesu to'u weiana herekiai ewaira tina rabinai ia hanona weia baiatakiai aha'i. ");
INSERT INTO rro_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","I'abana haukia baika ia tehina bena tetibaha, “Ai Obiapaka taihana.” Ia Toma ehina benakia, “Au ikoko mani'akia imanai haukia kaihanakia haeamona ia robunai ima'u katiu totona, uahomana aha'i raninai au hanona ia a'i ka'ikakaumana.” ");
INSERT INTO rro_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Wapu 'ababani teao murinai i'abana haukia itu aonai teto'u mue, Toma abomo weia ia kipokia. Pa'abi tekaiabu 'inina. Iamo Iesu hanona eao ia baiatakiai ekoroti e'abi etibaha, “Baibua heremiai kemiaho.” ");
INSERT INTO rro_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ba ia Toma ehina bena etibaha, “Imamu riuriuna emai ima'u neiana moa'i 'apuana, abomo imamu emai robu'uai motiu totona, weiana aomu a'i kekai'au kai'au ia koa'ikakaumana'u.” ");
INSERT INTO rro_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toma Iesu ena 'abi ebamuena etibaha, “Oi hanona e'u Obiapaka, au e'u Tirama!” ");
INSERT INTO rro_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Iesu ia ehina bena etibaha, “Aba oihana'u buonai nua'ikakaumana'u. Ia weiakia a'i ṯeihana'u iamo tia'ikakaumana'u haukia hanona tenamo.” ");
INSERT INTO rro_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Iesu hiabu hoakia bo'ona i'abana haukia wairakiai ebabainakia haukia hanona puka neiana aonai a'i arere 'aunakia. ");
INSERT INTO rro_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ia neiakia mo arerenakia ena poki hanona wai katoa'ikakauma Iesu hanona Keriso, Tirama Nahuna. Weiana ia kato a'ikakaumana hanona atanai mauri katoa'ina. ");
INSERT INTO rro_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Weiana murinai, Iesu Tiberia obunai i'abana haukia herekiai ewaira tina mue, ṉa ebawaira tina aihona. ");
INSERT INTO rro_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simona Petero, Toma tiaparina bai'apaea, Natanaela Galilea Kana hauna, Sebedeo nahuna rua, mai i'abana haukia rua abomo weia kipokia 'eka hamonai temiaho. ");
INSERT INTO rro_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simona Petero ehina benakia etibaha, “Au aba naeao kaba'eha.” Ia tetibaha, “Ai abomo kipokia hamaeao.” Weiana teao ahiai tehe'au, ia rabi weiana aonai hanona maia ha a'i tebarewana. ");
INSERT INTO rro_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Rani nirerena aonai Iesu hanona poe haianai ekoroti, ia i'abana haukia a'i te'iobina weiana hanona Iesu. ");
INSERT INTO rro_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ba Iesu ebakainakia etibaha, “E'u hau e, taba ha tobarewana?” Ia te'abi tetibaha, “Taba ha aha'i.” ");
INSERT INTO rro_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Iesu haeamona ehina benakia etibaha, “Emi re'e ahi itipanai tomohorena, ba maia baika katobarewanakia.” Weiana tebabaina aonai re'e kateberi 'auna hanona a'i etainakia, pokina maia ebo'o ki'a baha. ");
INSERT INTO rro_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ba Iesu i'abana hauna weiana eraona'au aina hauna ehore Petero ehina bena etibaha, “Weiana hanona Obiapaka.” Simona Petero hanona ena habuni ebakuri ahina eba'eha, ba 'abi neiana ‘Ia hanona Obiapaka’ hauna eona raninai emikiri ena habuni ehaina beronai obuai etobu. ");
INSERT INTO rro_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","I'abana haukia baika hanona ahiai re'e mai maiana ebonu hauna teberi ririna teaoaina poe, pokina poe hanona a'i ehoma'a roba hinabu hamomo 'abana. ");
INSERT INTO rro_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ia poeai tekara'au raninai mahakia eao iruba baubaeana ahanai maia ihore'au teihanakia, parawa baika abomo weia. ");
INSERT INTO rro_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Iesu ia ehina benakia etibaha, “Maia bariu toa'inakia haukia baika tomai ainakia.” ");
INSERT INTO rro_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simona Petero emue ahiai ekara'au re'e eberi'auna poeai, re'e aonai maia rarikia mo 'abaeana ikoinai hinabu hamomo imabui aihau, maia rarikia 'abaeana ia ekia re'e hanona a'i etapa. ");
INSERT INTO rro_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Iesu ia eaparinakia etibaha, “Tomai, tomoaniani!” Ba i'abana haukia ia katebakaina, ‘Oi tai?’ hauna a'i tenuatae, pokina aba te'iobina ia hanona Obiapaka. ");
INSERT INTO rro_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Iesu eka'a haha eao herekiai parawa ea'ina ba ebenakia, ihobonai maia abomo ua ebabai aihona. ");
INSERT INTO rro_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Neiana hanona Iesu 'ariai emikiri mue murinai rani ibaihauna kipona i'abana haukia herekiai ewaira tina. ");
INSERT INTO rro_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Teaniani murinai Iesu Simona Petero ebakaina etibaha, “Simona Ioane nahuna e, oi emu raona'au here'uai eapa'ua ki'a baha ba neiakia ekia raona'au, u?” Petero etibaha, “'E, Obiapaka, o'iobina au 'arimu na'ari.” Ba Iesu e'abi etibaha, “E'u mamoe nahu ko'ima harainakia.” ");
INSERT INTO rro_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Rani ibaruana ebakai muena etibaha, “Simona Ioane nahuna e, oi au nuraona'au aina'u, u?” Petero etibaha, “'E, Obiapaka, o'iobina au oi 'arimu na'ari.” Ba Iesu e'abi etibaha, “E'u mamoe ko'ima harainakia.” ");
INSERT INTO rro_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Iesu rani ibaihauna Petero ebakaina etibaha, “Simona Ioane nahuna e, oi au 'ari'u nu'ari, 'u?” Petero aona ehai hai pokina aba rani aihau ebakaina etibaha, “Oi au nuraona'au aina'u?” Weiana Petero e'abi etibaha, “Obiapaka e, oi hanona taba ikoinai o'iobinakia, o'iobina au oi 'arimu na'ari.” Iesu etibaha, “E'u mamoe kobanianinakia. ");
INSERT INTO rro_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","'Abi tohana au oi nahina beni'o, 'aru'arumuai raninai oi kipomu emu habuni obatotona abomo emu nuatae 'ekana ae'eai hanona oao. Ia koanepaka raninai imamu kotiu ahinakia, hau ha kehore emu habuni kebabatotoni'o, keaoaini'o a'i nonuatae aina 'ekanai.” ");
INSERT INTO rro_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Iesu 'abi neiana ehinana hanona Petero aea ke'ari aiho Tirama ena nuabi kebawaira tinana. Ba ehina bena etibaha, “Muri'uai omai.” ");
INSERT INTO rro_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petero eiha kabe hanona Iesu i'abana niraona'au aina hauna eihana, ia hanona ani to'uai Iesu haunai ekape'au, ba ebakaina etibaha, “Obiapaka e, tai oi hinahinamu kehinahina?” ");
INSERT INTO rro_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Petero hau weiana eihana raninai Iesu ebakaina etibaha, “Obiapaka e, hau weiana hanona aea keho?” ");
INSERT INTO rro_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Iesu ehore Petero ehina bena etibaha, “Panuatae ia pemiaho peaomo au pamue pamai, iamo oi emu aka hanona taba ia herenai? Oi hanona muri'uai omai.” ");
INSERT INTO rro_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","'Abi neiana paunai i'abana haukia kipokia baiatakiai te'abi'abi aina, i'abana hauna weiana a'i ke'ari ṉa ehoma. Iamo Iesu hanona ua a'i e'abi aiho hau weiana a'i ke'ari, 'a ia e'abi, “Panuatae ia pemiaho peaomo au pamue pamai, iamo oi emu aka hanona taba ia herenai?” ");
INSERT INTO rro_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","I'abana hauna weiana ehore 'abi neiakia ikoinai ehinanakia haeamona ererenakia, ba ha'iobina 'abi neiakia ehina haukia hanona tohakia. ");
INSERT INTO rro_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Iesu hanona hoa bo'ona 'akina ebabainakia. Au naraonana weiakia ikoikiai hamohamo temerere 'aunakia raninai, hanopaka maikoinai puka neiakia patebararonakia hanona 'ekana aha'i. ");
INSERT INTO rro_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teofilo e, e'u puka 'uaina aonai Iesu ena aka mai ena ba'iobi ea'i ramanakia haukia, ");
INSERT INTO rro_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","emai mo ea'i taea kupa keao ranina pouna ikoikiai arerenakia. A'i ea'i taea baha aonai, Auba Robe hiabunai ena iuhubeau ia etina'anakia herekiai aka kate babainakia haukia robakia eahunakia. ");
INSERT INTO rro_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ena 'ari murinai, katebatohana ia hanona emauri toha paunai wapu bariabui aonai ia kipona rani bo'ona ewaira tina maearima wairakiai, abomo wairakiai Tirama ena obia aiarana pouna ehinana. ");
INSERT INTO rro_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Rani ha ekia miato'uai Iesu 'abi neiana ebenakia etibaha, “Ierusalema a'i katohabona, ia Hama'u e'abi'uai aina Auba Robena kato'imana, 'abina weiana au wai aba ahina benimi. ");
INSERT INTO rro_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ioane hanona beiai maearima eba'uere robenakia, 'a wapu a'i kebo'o aonai wai hanona Auba Robe ai kato'uere robe.” ");
INSERT INTO rro_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Iesu i'abana haukia kipokia teto'u raninai ia tebakaina tetibaha, “Obiapaka e, bariu rani neianai Isaraela hanopakana ena hiabu kobeni muena, u?” ");
INSERT INTO rro_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Iesu ekia 'abi ebamuena etibaha, “Rani mai wapu hanona Hama'u kipona ena hiabuai aba eba'orunakia, wai emi bero aha'i taba neiana aita kerama hauna kato'iobina. ");
INSERT INTO rro_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","'A Auba Robe keriri wai ahamiai raninai hiabu katoa'ina, au pou'u katohinahina otaraina Ierusalemai, Iudea mai Samaria aiarakia maikoinai, abomo keaomo hanopaka puana.” ");
INSERT INTO rro_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Iesu 'abi neiana ehinana murinai, ia mahakia tohanai ea'i taeana ekara'au kupa eao teihana, ba 'auhao ha ia ekaiabuna, weiana ia a'i teiha muena. ");
INSERT INTO rro_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ia kupai ekara'au 'ekana teiha 'ini'inina aonai, beronai hau rua habuni porekia tebatotonakia hanona ia tekori turinakia. ");
INSERT INTO rro_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ba tehina benakia tetibaha, “Galilea haumi e. Taba buonai neia tukoroti tua'a taea kupa ṯoihana? Iesu bariu heremiai ea'i taeana kupa eao hauna haeamona kemue kemai bariu ekara'au toihana ihobonai.” ");
INSERT INTO rro_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ba iuhubeau haukia Olibe oeonai teriri teao Ierusalema, 'eka weiakia baiatakia ena homa'a hanona kilometa hamona 'abana. ");
INSERT INTO rro_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ierusalema ai tekatoto raninai ṯemiaho aina ituna ikaihuri 'ubiai weiana hauna teao. Maearimakia atakia hanona neiakia, Petero, Ioane, Iakobo, Anderea, Pilipo, Toma, Batolomeo, Mataio, Iakobo Alepeo, Simona Selote hauna, mai Iuda Iakobo. ");
INSERT INTO rro_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ia ikoikiai tea'i to'u 'eka hamonai, babi'e baika abomo ia baiatakiai mai Iesu hinana Maria mai hatina kipokia tebahuba'ari to'ona. ");
INSERT INTO rro_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Rani weiana a'ikakauma haukia 'abaeana haukia ikoinai hinabu hamomo harau rua teto'una, aonai wairakiai Petero emikiri ekoroti eiroronakia. ");
INSERT INTO rro_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Etibaha, “Uaho'aba'u e! Puka Robena 'abina kemai ketohana hauna Auba robe ehore Davida pinanai Iuda robana aba hamo eahu 'uaina Iesu ia'ina kateao haukia hanona ia ke'uai ainakia. ");
INSERT INTO rro_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Iuda hanona 'abamai ha, pokina ia abomo etina'ana kipokia taka haeamo aka neiana aonai.” ");
INSERT INTO rro_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Iuda ena aka ki'a moninai hano ha tekawana, ba weia e'eho 'arana benu eao mo'oruna epou maikoina ekiki atapakai. ");
INSERT INTO rro_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ierusalemai ṯemiaho haukia ikoikiai pou neiana teona, ua buonai hano weiana atana teaparina ‘Akeledama’, maeakiai 'abi weiana anina hanona ‘Aruaru Hanona’.) ");
INSERT INTO rro_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Pokina Salamo pukanai aba irere'au etibaha, ‘Ena itu hanona ke'oko. Tai ha ua'a a'i kemiaho.’ Sal 69.25 Haeamona ererena, ‘Ia 'ekana hanona hau ha kehore kea'ina.’ ");
INSERT INTO rro_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Ua buonai bariu hanona aika 'abaka ha baiatakai kipokia hamiaho Obiapaka Iesu ena kaoao maikoina eihana hauna mai ");
INSERT INTO rro_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Ioane ena ba'uere robe eramana raninai emaimo Iesu ekara'au kupa eao hanona ia abomo ua'a hauna kaha'i taeana. Ai kipokia kataka haeamo Iesu ena mikiri mue pouna ihinanai.” ");
INSERT INTO rro_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Weiana hau rua tenuatae ainakia ha katea'i taeana, ha atana Iosepa baika tiaparina Barasaba haeamona tiaparina Iusto, mai ha hanona atana Matia. ");
INSERT INTO rro_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Weiana ia tebahuba'ari tetibaha, “Obiapaka e! Oi hanona maearima ikoinai aokia o'iobina, hau neiakia terarua baiatakiai hanona aeana otina'ana hauna bariu kobaihanamai. ");
INSERT INTO rro_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Ia hanona baraibarai mai iuhubeau akana neiana Iuda ehabona hauna kebabaina, pokina Iuda hanona aba ekaobo ena 'eka tohana eao.” ");
INSERT INTO rro_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ba tepu'i, aonai ata ewaira tina hanona Matia, ba iuhubeau haukia harau haea hamomo hanona ebaharau haea ruanakia. ");
INSERT INTO rro_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentekoste berauranai a'ikakauma haukia ikoikiai 'eka hamomonai teto'una. ");
INSERT INTO rro_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Weia kupai 'uru rarina ha biaimo emai ta'uainakia, matoha rani rarina ha eabu 'uruna 'abana, ia temia to'u ituna ebabonu 'auna. ");
INSERT INTO rro_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Mai abonamo taba ha teihana ihana matoha iruba upana maeana 'abana eao ha ha kaipakia 'ubinai. ");
INSERT INTO rro_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ia ikoikiai Auba Robe ai aba tebonu, ba Auba Robe ebenakia ihobonai aiara haeai haeai maeakiai te'abi. ");
INSERT INTO rro_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ua raninai Iuda haukia Tirama marikina temariki haukia hanopaka haeai haeai ṯemiaho haukia temai Ierusalemai. ");
INSERT INTO rro_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","'Uru weiana teona raninai, 'eka hamomonai teto'una abomo to'u hanona rarina 'akina, to'u haukia tehaorea, pokina ha ha maeakia tohanai a'ikakauma haukia pou weiana tehinana hauna teona. ");
INSERT INTO rro_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ikoikia teta'u ta'u huri mai aokia tearo 'ari tetibaha, “'Ai, neiakia ti'abi haukia hanona Galilea haukia, u? ");
INSERT INTO rro_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Aehoma buonai aika ikoikai hanona haha maeaka tohanai ti'abi aiakia nahaona? ");
INSERT INTO rro_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Aika hanona hanopaka haeai haeai ai hamai, Patia, Media, Elama ai, Mesopotamia, Iudea, Kapadokia ai, Ponto, Asia ai, ");
INSERT INTO rro_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Furugia, Pamfulia ai, Aigupito ai abomo Kurene ai, ia hanona Libia ekia 'eka ha. Roma ai tamai haumai, baika hana Iuda haumai baika hana Iuda haukia aha'i ia kuti taearanai Iuda haukiai tibaonakia haumai, ");
INSERT INTO rro_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ai baika hanona Krete mai Arabia ai tamai. Hau weiakia maeaka tohanai Tirama hoa apa'uana ebabaina hauna tehinana 'uruna haona.” ");
INSERT INTO rro_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ikoikiai teraona raona mai aokia a'i etaina, ia ha ha kipokia tebakai bakai tetibaha, “Neiana hanona taba?” ");
INSERT INTO rro_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","'A baika hanona a'ikakauma haukia teiriri ainakia tetibaha, “Aba bia teinu 'ari.” ");
INSERT INTO rro_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Weiana Petero mai 'abana harauhaea hamomo kipokia temikiri, ia aiana ebapa'uana eiroro benakia etibaha, “Iuda haumi mai Ierusalemai ṯomiaho haumi e. Aia'u tomobahu bahu aina. Taba neiana aea erama aiho hauna pouna kaba'iobinimi. ");
INSERT INTO rro_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ai neiamai hanona a'i ṯainu 'ari, wai turaonana 'abana aha'i, abomo bariu hanona raurani beraura hoana 'ababani hamomo. ");
INSERT INTO rro_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ia mahabanai hauna Ioel ṉa e'abi aiho etibaha, ");
INSERT INTO rro_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Tirama etibaha, Hanopaka ena pua raninai, Au Auba'u hanona maearima ikoikiai ahakiai kabakiki oioina. Nahumi hau haukia mai babi'ekia kateaobero, emi hau 'aru'arukia hanona katemahabanai, abomo emi anepaka katenibi. ");
INSERT INTO rro_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Haeamona rani weianai au e'u ta'ara ia'ina haukia mai babi'ekia ahakiai au Auba'u kabakikina weiana kateaobero. ");
INSERT INTO rro_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ta'u tabakia baika kupa 'ubinai kabawaira tinanakia, hanopaka ahanai abomo taba baika katerama, weiana aruaru, iruba abomo hiabu imukina. ");
INSERT INTO rro_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Obiapaka ena beraura apa'uana mai nuabina kekaibari raninai, beraura hanona kewapura abuna, nawa hanona kebiro matoha aruaru 'abana. ");
INSERT INTO rro_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","'A Obiapaka atana kateaparina haukia katemauri.’ ");
INSERT INTO rro_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Isaraela haumi e, tomobahu aia'u tomona. Iesu Nasareta hauna hiabu akakia haeai haeai mai hoa akakia haeai haeai ebabainakia hanona Tirama ia aonai eaka, hoahoakia wai baiatamiai ua tewaira tina aiho haukia aba to'iobi harainakia. ");
INSERT INTO rro_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Iesu neiana Tirama ena nuatae abomo ena 'iobi ua'i baha aba eba'oruna taearana wai ebenimi. Wai tohore maearima ki'a obokia imakiai toutana weiana matiu ibiri ropo 'ubinai tokoko 'auna toahu 'arina. ");
INSERT INTO rro_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","'A Tirama ehore ebamikiri muena 'ari ena haiara ikoinai ebapuanakia, pokina 'ari ia kea'i 'inina ua'a wapura 'ekanai hanona a'i etaina. ");
INSERT INTO rro_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Davida abomo ia pouna ehinana etibaha, ‘Obiapaka hanona rani ikoinai waira'uai aihana. Pokina ia hanona au itipa'u tainai, a'i kaibiu 'apua. ");
INSERT INTO rro_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ua buonai ao'u ena aonamo hanona eapa'ua ki'a baha. Maea'u hanona aonamo 'abikia ehinanakia, hau'u hanona buabeni aonai kemiaho. ");
INSERT INTO rro_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Pokina auba'u hanona 'ari haukia ekia 'ekai a'i kohabona, abomo emu Robe hauna ua'a a'i kohabona a'i kepari. ");
INSERT INTO rro_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Oi ohore mauri taearana obaihana'u, emu waira tina hanona e'u aonamo kebapa'uana.’ ");
INSERT INTO rro_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Uaho'aba'u e! 'Aba'abaka Davida ena pou mahina haraina. Tomo'iobina ia hanona aba e'ari tehorena, ena 'ariahana hanona bariu neia aika hereherekai. ");
INSERT INTO rro_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","'A Davida hanona mahabanai hauna e'iobina Tirama ena 'abi'uai pahihina ebena, ia 'aba'abana ha hanona ia ena imia'au 'ekanai ua'a kemia'au. ");
INSERT INTO rro_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Davida ehore Tirama taba kebabaina hauna eiha 'uaina Keriso ena mikiri mue 'abina ehinana etibaha, ‘Ia hauna hanona 'ariahana aonai ua'a a'i kehabona, ia hauna a'i kepari.’ ");
INSERT INTO rro_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Iesu neiana hauna Tirama ehore 'ariai ebamikiri muena. Ai ikoimaiai taihana abomo ta'iobina. ");
INSERT INTO rro_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ia hana Tirama ehore ea'i taeana imana itipanai nemiaho. Auba Robe weiana Hamana e'abi 'uai aina hauna ea'ina. Weiana hana aba euhu ririna, bariu ena hiabu mahamiai aba ṯoihana, haiamiai aba tuona. ");
INSERT INTO rro_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Pokina Davida hanona kupai a'i ekara'au aonai e'abi etibaha, ‘Obiapaka hanona e'u Obia ehina bena etibaha, Au itipa'u tainai momiati, ");
INSERT INTO rro_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","keaomo oi emu 'ou haukia kaehe rabu tainakia aemu ba'anai kahorotinakia.’ ");
INSERT INTO rro_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Ua buonai, Isaraela haumi ikoimiai kato'iobi haraina, Iesu wai matiu ibiri ropo 'ubinai tokoko 'auna hauna Tirama ehore aba Obiapaka mai Kerisoai ebaona.” ");
INSERT INTO rro_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Weiana 'abi neiakia teo'o raninai nuakia tetae, ia Petero mai iuhubeau haukia tebakainakia tetibaha, “Uaho'abamai e! Ai aea katababai aiho?” ");
INSERT INTO rro_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petero ia ehina benakia etibaha, “Katoraona kabe, ha ha Iesu Keriso atanai kato'uere robe emi ki'a ihina hao hoana. Weiana Auba Robe ena beruberu aba katoa'ina. ");
INSERT INTO rro_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Pokina 'abi'uai neiana hanona wai 'eumi, nahumi 'eukia, abomo atau'ai ṯemiaho haukia weiakia Obiapaka eka Tirama keaparinakia haukia ikoikiai 'eukia.” ");
INSERT INTO rro_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petero 'abi bo'okia maearima ehinabe harainakia abomo eba taburanakia etibaha, “Uru ki'a obona neiana aonai katokaobo hanona katomauri.” ");
INSERT INTO rro_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Petero ena 'abi tea'i taeana haukia ikoikiai 'uere robe hoana tea'ina, rani weianai maearima hanona ikoinai taha aihau (3,000) a'ikakauma haukia ekia to'u aonai tetoto. ");
INSERT INTO rro_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ia hanona rani ikoinai iuhubeau haukia herekiai 'iobi tetabuna, ekia miato'u mai 'abi'abi aokiai ia abokia mo weia, kipokia teaniani haeamo, 'eka hamonai tebahuba'ari. ");
INSERT INTO rro_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Iuhubeau haukia hoa haeaihaeai mai babai haeaihaeai tebabainakia hanona maearima ikoikiai Tirama teta'u aina. ");
INSERT INTO rro_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Weiana a'ikakauma haukia ikoikiai 'eka hamonai teto'u, ekia taba ikoikiai 'eka hamonai tewate harainakia. ");
INSERT INTO rro_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ekia kepu mai hano tekawakawa ainakia monikia hanona tewate wate nuatae ihobonai ha ha tebenakia. ");
INSERT INTO rro_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Rani ikoinai wapu ha ha mai aokia hamonai marea robe aonai teto'u, abonamo ekia ituai mai aonamokia mai aokia hamonai teaniani haeamo, ");
INSERT INTO rro_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Tirama teba namona, maearima ikoikiai ia teaonamo ainakia. Obiapaka ehore ebamaurinakia haukia rani ikoikiai a'ikakauma haukia kipokia eba hamomonakia. ");
INSERT INTO rro_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Rani ha rabirabi beraura hoana aihau 'abana bahuba'ari ranina, Petero mai Ioane ohi Marea robe teao. ");
INSERT INTO rro_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Weia 'ome hauna ha rani ikoinai temaiaina ua'a marea robe pa'abina atana ‘Nuabi pa'abina’ 'akonai tebamiatina. Ia hinana nuanai uahomanai erama. Maearima marea robe teao haukia ikoikiai herekia moni enoi. ");
INSERT INTO rro_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Petero mai Ioane ohi marea robe ai katekatoto raninai eihanakia ba enoinakia taba ha katebena. ");
INSERT INTO rro_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","'A Petero mai Ioane ohi teiha 'ini'inina, weiana Petero ehinabena etibaha, “Ai tararua moihanamai!” ");
INSERT INTO rro_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ua buonai 'ome hauna ia eihanakia ena raona hanona taba ha katebena. ");
INSERT INTO rro_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Petero ia ehina bena etibaha, “Au hanona moni here'uai aha'i. Ia here'uai nemiaho hauna neiana. Iesu Keriso Nasareta hauna atanai momikiri moka'a!” ");
INSERT INTO rro_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ba Petero ia imana itipanai ea'i ebaraina eberi taeana, beronai aena mai aena 'eku'ekukia tetabura. ");
INSERT INTO rro_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ia erobo tae ekoroti, eka'a hobo. Ia kipokia marea robe aonai tekatoto, eka'a abomo erobo taea erobo taea Tirama ebanamona. ");
INSERT INTO rro_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","To'u haukia ikoikiai wairakiai eka'a Tirama ebanamona teihana. ");
INSERT INTO rro_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Weiana te'iobina ia hanona rani ikoinai marea robe pa'abina atana ‘Nuabi pa'abina’ 'akonai emiati enoi ba'ame hauna, teta'uta'u huri hoa haeai tohana herenai erama paunai. ");
INSERT INTO rro_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Aena enamo hauna ehore Petero mai Ioane e'aberenakia aonai, maearima bo'ona 'akina tebeau teao itara ha atana Solomona ena itarai weia teihana teta'u ki'a. ");
INSERT INTO rro_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Petero ia eihanakia etibaha, “Isaraela haumi e, taba buonai taba neiana nibata'u ta'u hurinimi? Abomo taba buonai ai tuarurunamai? Turaonana ai kipomai emai hiabuai 'ao emai auba hiabukiai hau neiana tabamikirina nika'a, u? ");
INSERT INTO rro_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Aberahamo, Isako mai Iakobo ekia Tirama abomo aika 'aba'abaka ekia Tirama ena banamo nuabina ena ta'ara'i hauna Iesu ebena. 'A wai tohore Pilato tobena, abomo Pilato enuatae kerubuna raonana ebabaina hanona wai a'i tonuatae. ");
INSERT INTO rro_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Robe mai aka bero hauna a'i tonuatae aina, 'a tonoina ahuahu hauna erubuna wai 'eumi. ");
INSERT INTO rro_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Wai tohore mauri pokina hauna toahu 'arina, ia Tirama ehore 'ari ai ebamikiri muena, ai taihana haumai neiamai. ");
INSERT INTO rro_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Iesu atana hiabunai 'ome hauna neiana etabura mue, hau neiana aba ṯoihana abomo ṯo'iobina. 'Abi tohana Iesu ta'ikakaumana buonai hau neiana ebanamona wai ikoimiai wairamiai. ");
INSERT INTO rro_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Uaho'aba'u e, a'iobina wai emi obia kipokia Iesu herenai ua tobabai aiho hanona a'i to'iobina buonai. ");
INSERT INTO rro_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","'A Tirama hanona mahabanai haukia ikoikiai pinakiai Keriso ena haiara pouna aba tehinana. Taeara weianai 'abi weiana aba etohana. ");
INSERT INTO rro_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","“Ua buonai tomoraona kabe, Tirama herena katomai, weiana emi ki'a kea'i obo. Obiapaka mauri mahamahana kebenimi. ");
INSERT INTO rro_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Tirama kehore Iesu haeamona keuhuna kemai wai heremi, 'uainai etina'ana Keriso wai 'eumi. ");
INSERT INTO rro_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Iesu kupa 'ubinai kemiaho keaomo Tirama taba ikoinai kebamaha mahanakia. Aba wa'i baha ia ena mahabanai haukia robekia pinakiai aba te'abi ihobona. ");
INSERT INTO rro_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","“Mose e'abi etibaha, ‘Obiapaka emi Tirama hanona mahabanai hauna ha kea'i taeana au ihobo'u wai hatia'ami kipokia baiatamiai, ia kehina 'abikia ikoikiai hanona aiana katona. ");
INSERT INTO rro_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","'A mahabanai hauna weiana aiana a'i kateona haukia ikoikiai hanona Tirama ena maearima baiatakia kate'ari ore.’ ");
INSERT INTO rro_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","'Abi tohana, mahabanai haukia ikoikiai weiakia Samuela ena rani ai emai mo bariu aba te'abi 'uai aina beraurana hanona neiana. ");
INSERT INTO rro_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","“Wai hanona mahabanai haukia 'aba'abakia. Tirama ena 'abi'uai ia herekiai hanona wai 'eumi, Tirama 'aba'abami banamo ebenakia hauna wai katoa'ina. Ia Aberahamo ehina bena etibaha, ‘Oi 'aba'abamu paukiai hanopaka maearima ikoinai katenamo.’ ");
INSERT INTO rro_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Tirama ehore ena Ta'ara'i hauna etina'ana euhuna emai 'uai wai heremi, wai ikoimiai kebanamonimi mauri ki'a obokia taearakia katohabonakia paunai.” ");
INSERT INTO rro_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petero mai Ioane maearima ṯehina benakia aonai, robe haukia mai marea robe i'imana hauna abomo Sadukea haukia hanona terarua herekia temai. ");
INSERT INTO rro_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Iesu ena mikiri mue paunai 'ari haukia katemikiri mue pouna maearima wairakiai teba'iobi aina buonai ia terarua teopuere ainakia. ");
INSERT INTO rro_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Weiana ia terarua tea'inakia tebirinakia wapura itunai tekaiabunakia keaomo mara, pokina aberabirabi buonai. ");
INSERT INTO rro_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","'A ekia 'abi weiana teona mai tea'i taeana haukia hanona ikoinai taha ima (5,000) 'abana. ");
INSERT INTO rro_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Erani hanona aiara obiakia mai aiara hau apa'uakia mai rauhubu poki haukia ikoikiai Ierusalemai teto'una. ");
INSERT INTO rro_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Robe haukia 'arakiai hauna Ana weia, Kaiafa mai Ioane mai Alesanda abomo weia, robe haukia 'arakiai hauna ena itubu haukia ikoikiai abomo weia. ");
INSERT INTO rro_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Weiana wairakiai terarua teba korotinakia tebakainakia tetibaha. “Hiabu tabanai mai tai atanai aka neiakia tubabai?” ");
INSERT INTO rro_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Petero hanona Auba Robe ai ebonu 'auna, weiana ekia 'abi eba muena etibaha, “Aiara ṯoiha 'inina mai ṯo'uai aina haumi e. ");
INSERT INTO rro_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Wai ai tubakainamai 'ome hauna aea enamo aiho hanona robana katahuna wairamiai raninai, ");
INSERT INTO rro_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","wai kato'iobina abomo Isaraela haukia ikoikiai kate'iobina, Iesu Keriso Nasareta hauna, wai toahu 'arina ba Tirama ehore 'ariai ebamikiri muena hauna atanai 'ome hauna neiana abenamo wairamiai ekoroti ṯoihana. ");
INSERT INTO rro_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Iesu hanona ‘itu ibabaina haumi tobaki'ana piharana, itu kupuana piharanai eao.’ ");
INSERT INTO rro_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Bamauri hanona ia kipona mo aonai nemiaho, pokina hanopaka ikoinai aonai Tirama ata haeai ha a'i ebaibeni aika kebamaurinaka.” ");
INSERT INTO rro_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Iuda obiakia teraonana Petero mai Ioane ohi marere 'ekana apa'uana ha a'i teao 'apua ekia 'iobi aha'i haukia, iamo a'i teta'u 'abi tehina haraina teihanakia hanona teta'uta'u huri. Abomo te'iobina terarua hanona Iesu te'abana. ");
INSERT INTO rro_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ia terarua mai 'ome hauna abenamo hauna kipokia wairakiai tekoroti haeamo buonai katebakai muenakia taearana ha aha'i. ");
INSERT INTO rro_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ia Petero Ioane mai 'ome hauna tehina benakia bakai 'ekanai katekarahi, ba tekarahi murinai weiakia ikupaiakia te'abi'abi. ");
INSERT INTO rro_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Tetibaha, “Ia terarua herekiai taba kahababaina? Pokina Ierusalemai ṯemiaho haukia ikoikiai aba te'iobina ia hanona bata'uta'u huri akakia tebabai, aika kahabuni ainakia 'ekana aha'i. ");
INSERT INTO rro_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Pou neiana a'i memata maearima ikoikiai a'i teme'iobina marikina, terarua kahaba ta'unakia abomo kaharauhubu ainakia Iesu atana hanona a'i katehinana hau ha herenai.” ");
INSERT INTO rro_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Epua terarua teapari muenakia tetoto, terauhubunakia Iesu atana a'i kateiroro aina abomo a'i kateba'iobi aina aha'i 'akina. ");
INSERT INTO rro_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","'A Petero mai Ioane ohi ekia 'abi tebamuena tetibaha, “Wai kipomi tomobabataina. Wai aiami kata'i taeana 'ao Tirama aiana kata'i taeana. Tirama wairanai aeana hanona ebero? ");
INSERT INTO rro_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ai taiha mai tao'o tabakia katabuninakia hanona a'i ketaina.” ");
INSERT INTO rro_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ia terarua tehinabe pahihinakia ba teba karahinakia, kateba wapuranakia hanona taearana ha a'i tetabu ahina pokina maearima ikoikiai Tirama tebanamona hoa weiakia terama buokiai. ");
INSERT INTO rro_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Hau neiana herenai hoa apa'uana erama enamo hauna ihauna hanona bariabui mai reana. ");
INSERT INTO rro_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Teba karahinakia murinai, terarua teao 'abakia herekiai, robe haukia apa'uakia mai obia apa'uakia taba ṉa tehoma 'abikia ikoinai tehinabenakia. ");
INSERT INTO rro_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Aiakia teona murinai, ikoikia aiakia tebahamomona Tirama tebahuba'ari bena tetibaha, “'Ubi tohana Obiana e, kupa hanopaka 'akupaka mai aokiai ṯemiaho tabakia hanona oi mo obabainakia. ");
INSERT INTO rro_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Emu 'abi Auba Robe ena hiabuai emu ta'ara'i hauna 'aba'abamai Davida pinanai e'abi etibaha, ‘Rama haeai haukia taba buonai tiopuere, abomo taba buonai maearima taba tohakia aha'i haukia tiraona apa'uanakia? ");
INSERT INTO rro_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Hanopaka obiakia temikiri abomo aiara obiakia kipokia tibahamomo Obiapaka ena Keriso ohi ti'oatanakia.’ ");
INSERT INTO rro_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“'Abi tohana, Heroda mai Pontio Pilato hanona rama haeai haukia mai Isaraela haukia kipokia aiara neiana aonai aba teto'una. Emu ta'ara'i hauna robena Iesu oi tehoroai 'aranai oheina Kerisoai eao hauna kate'oatana. ");
INSERT INTO rro_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ia hanona Oi emu hiabu mai nuatae aba oba'oruna akana kerama hauna tebabaina. ");
INSERT INTO rro_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ua buonai, Obiapaka e, ekia bata'u 'abikia moraonanakia, ai emu ta'ara'i haumai tabura mobenamai, a'i katata'u ainakia emu 'abi katahinana. ");
INSERT INTO rro_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Imamu motiu ahina emu hiabu mobawaira tinana inawa haukia mobamaurinakia, haeamona hoa akakia mai bata'uta'u huri hoakia kobabai oi emu ta'ara'i hauna robena Iesu atanai.” ");
INSERT INTO rro_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ia tebahuba'ari murinai temia to'u ituna eibiuibiu, ia hanona Auba robe ai tebonu, mai nuako'okia Tirama ena 'abi tehinana. ");
INSERT INTO rro_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","A'ikakauma haukia ikoikiai hanona ao'aokoikia mai aokia hamona, ha kipona ena taba a'i euhore aina 'a ekia taba ikoikiai hanona tebina'anakia ha ha baiatakiai. ");
INSERT INTO rro_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Iuhubeau haukia mai hiabukia rarina Obiapaka Iesu ena mikirimue mahakiai teihana hauna pouna teiroro aina. Ba Tirama ena banamo hanona ia ikoikiai ahakiai. ");
INSERT INTO rro_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ia baiatakiai hanona tai ha'i ekapu, pokina weiakia mai ekia hano 'ao itu haukia hanona tekawakawa ainakia monikia weiakia teaoainakia, ");
INSERT INTO rro_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","iuhubeau haukia imakiai teutanakia, weiana tewate harainakia ha ha ena uraru ihobonai. ");
INSERT INTO rro_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Hau ha atana Iosepa, Lebi itubuna hauna Kupuro ai erama, iuhubeau haukia hanona ia atana teaparina Banaba (anina hanona ‘Batabura hauna’.) ");
INSERT INTO rro_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ena hano ekawakawaina monina ikoinai eaoaina iuhubeau haukia imakiai eutana. ");
INSERT INTO rro_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Weiana hau ha atana Anania atawana Sapira ohi ekia hano ha tekawakawaina. ");
INSERT INTO rro_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ia hano weiana monina abirana ea'i 'inina hanona atawana ohi te'iobina, abirana mo eaoaina iuhubeau haukia imakiai eutana. ");
INSERT INTO rro_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Weiana Petero ia ehina bena etibaha, “Anania e! Aehoma buonai Satani aomu eana, Auba Robe o'oina hano monina abirana oa'i 'inina? ");
INSERT INTO rro_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","A'i okawakawaina raninai hano hanona oi 'eumu, okawakawaina raninai monina abomo oi 'eumu. Bariu rani neianai hanona aea oraona aiho? Pinamuai moni maikoina ṉa nuhoma, oi hanona maearima a'i o'oinakia, ia Tirama o'oina.” ");
INSERT INTO rro_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Anania aia weiana eona raninai e'eho e'ari baihana, uru weiana teona haukia ikoikiai teta'u ki'a. ");
INSERT INTO rro_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Hau 'aru'arukia baika temikiri temai habuniai hauanina teapana tea'i ahina teaoaina tehorena. ");
INSERT INTO rro_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Beraura hoana aihau murinai babi'e ekatoto, atawana herenai taba erama hauna a'i e'iobina. ");
INSERT INTO rro_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petero babi'e ebakaina etibaha, “Mohina bena'u, torarua emi hano tokawa kawaina hanona 'arana mo weiana, u?” Ia e'abi etibaha, “'E, 'arana mo naiana.” ");
INSERT INTO rro_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Weiana Petero ia ehina bena etibaha, “Taba buonai atawamu ohi aomi tobahamona Obiapaka Aubana tuhobona? Aia'u nuona, atawamu tehorena miorikia pa'abi 'akonai tekoroti, oi abomo katebuani'o kateaoaini'o.” ");
INSERT INTO rro_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ia beronai e'eho Petero aena pokinai e'ari baihana. Hau 'aru'arukia tetoto temai teihana abe'ari toha, ba tebuana atawana herenai tehorena. ");
INSERT INTO rro_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Rani weianai a'ikakauma haukia ikoikiai mai pouna teona haukia ikoikiai teta'u wairai. ");
INSERT INTO rro_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Hoa mai babai haeai haeai iuhubeau haukia maearima wairakiai tebabainakia, ikoikiai mai aokia hamonai Solomona ena itarai teto'u. ");
INSERT INTO rro_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","'A maearima baika hanona teta'u ainakia herekia a'i teao, ia aokiai hanona ia temariki ainakia. ");
INSERT INTO rro_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Iamo hau mai babi'e bo'okia Obiapaka tea'ikakaumana haukia teao hanona ia haukia tebabo'o hao bo'o haona. ");
INSERT INTO rro_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Inawa haukia teaoainakia airabuanai tehorotinakia mai ieno'aukia mai 'irekia tebaenotinakia taearai. Weiana Petero herekiai kekabanai raninai aiaiana keao ahakiai. ");
INSERT INTO rro_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ierusalema herena aiarakia haukia bo'okia abomo temai teto'u, inawa haukia mai auba ki'a obokia aokiai tetoto haukia temaiainakia weia, ba ikoikiai temauri. ");
INSERT INTO rro_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Robe haukia arakiai hauna mai 'abana weiakia Sadukea itubuna haukia kipokia hanona iuhubeau haukia tewamuru ainakia. ");
INSERT INTO rro_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ba iuhubeau haukia tebirinakia teaoainakia wapura ituna aonai tekaiabunakia. ");
INSERT INTO rro_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","'A rabi weianai Obiapaka ena aneru ha ehore wapura ituna pa'abina ekaikauna eba karahinakia, ");
INSERT INTO rro_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","etibaha, “Tomoao, Marea Robe aonai mauri maha mahana pouna neiana maikoina katohinana maearima wairakiai.” ");
INSERT INTO rro_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Aia weiana teona ihobona tebabaina, raurani amarinai Marea Robeai tekatoto maearima teba 'iobinakia. Rani weianai robe haukia arakiai hauna mai 'abana kipokia teao bakai apa'uana haukia abomo Isaraela hau apa'uakia kipokia teto'u, 'abi teuhuna eao iuhubeau haukia wapura itunai katemaiainakia. ");
INSERT INTO rro_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Teuhunakia teao wapura itunai hanona wairakia aha'i, haeamona temue teao bakai apa'uana haukia haiakiai te'abi tetibaha, ");
INSERT INTO rro_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Taeao raninai pa'abi hanona ikaiabu, pa'abi i'imana haukia abomo weia tekoroti, ia pa'abi takaikauna takatoto hanona tai ua'a aha'i 'akina.” ");
INSERT INTO rro_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","'Abi weiana teona raninai, Marea Robe poki hauna mai robe haukia apa'uakia teraona raona 'ari ki'a baha, hoa weiana anina hanona taba. ");
INSERT INTO rro_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Weiana hau ha eao herekia ehina benakia etibaha, “Wapura itunai tokaiabunakia haukia hanona aba Marea Robe aonai tekoroti maearima tiba'iobinakia.” ");
INSERT INTO rro_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Marea Robe poki hauna mai ena miori kipokia teao iuhubeau haukia tebaka'anakia, ia a'i teaiahu benakia pokina maearima katehore piharai a'i temeahunakia marikina. ");
INSERT INTO rro_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Teaoainakia bakai apa'uana wairanai teba korotinakia, ba robe haukia arakiai hauna ehore ebakainakia. ");
INSERT INTO rro_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Etibaha, “Ai wai taharabunimi, hau neiana atanai a'i katoba'iobi. Ia bariu emi ba'iobi 'abikiai Ierusalemai pou neiana hanona abeapa'ua, abomo ena 'ari hanona ai tukaiahinamai.” ");
INSERT INTO rro_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Petero mai iuhubeau haukia te'abi tetibaha, “Tirama aiana kahaona hanona enamo, 'a maearima aiana kahaona hanona a'i enamo. ");
INSERT INTO rro_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Iesu wai tohore matiu 'ubinai tokokona toahu 'arina hauna, aika 'aba'abaka ekia Tirama ehore 'ariai aba ebamikiri muena. ");
INSERT INTO rro_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Tirama ia ea'i taeana imana itipana tainai eba miatina i'uaiaika mai ibamaurika haunai ebaona Isaraela haukia ibaraona kabekia mai ekia ki'a ihina haokia paunai. ");
INSERT INTO rro_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ai hanona taba neiakia taihanakia haumai, Auba Robe weiana Tirama aiana tiona haukia ebenakia hauna abomo ihobona.” ");
INSERT INTO rro_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","'Abi weiana teona raninai, teopuere wairai ekia nuatae hanona iuhubeau haukia pateahu 'arinakia. ");
INSERT INTO rro_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","'A Parisea hauna ha atana Gamaliel, rauhubu poki hauna ia bakai apa'uana hauna ha maearima ikoikiai abomo timariki aina hauna, emikiri iuhubeau haukia ehina benakia katekarahi atapakai katebai'ima rani papana. ");
INSERT INTO rro_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Weiana ia ehina benakia etibaha, “Isaraela haumi e, katoiha haraina hau neiakia aea katohomanakia. ");
INSERT INTO rro_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","'Uaina raninai Teuda emikiri e'abi ia abomo hau mo ha, weiana maearima ikoinai hinabu bani 'abana murinai teka'a. Ia teahu 'arina raninai ena maearima ikoikiai tebeau otaraina, ha a'i emiaho 'apua. ");
INSERT INTO rro_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ia murinai Galilea hauna ha atana Iuda, maearima atakia irerena raninai emikiri, maearima bo'okia aokia eana ia murinai teka'a, 'a ia abomo teahu 'arina, weiana murinai teka'a haukia ikoinai terama otaraina. ");
INSERT INTO rro_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ua buonai nahina benimi, hau neiakia hanona katohabonakia kateao, pokina 'abi hoahoa mai aka neiakia hanona maearima 'eukiai katemai raninai anikia a'i katerama. ");
INSERT INTO rro_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ia Tirama 'eunai kemai raninai, wai hanona a'i katoba'oro 'apuana. Kato'ima 'ima harainimi, Tirama a'i tomohuarina.” ");
INSERT INTO rro_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ia Gamaliel aiana tea'i taeana, weiana iuhubeau haukia teaparinakia tetoto, te'atinakia murinai terauhubunakia Iesu atanai a'i kateba'iobi muena, teba karahinakia. ");
INSERT INTO rro_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Iuhubeau haukia bakai 'ekana tehabona mai aonamokia, pokina Tirama ena banamo aonai ia hanona Iesu atanai tehaiara. ");
INSERT INTO rro_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Rani ikoinai Marea Robe aonai mai itu aokiai, pou namona teba'iobi aina mai teiroro aina Iesu hanona Keriso. ");
INSERT INTO rro_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Rani baika teao murikiai a'ikakauma haukia ekia bo'o hanona ekara'au raninai Iuda maearimakia Helene maeanai ti'abi haukia mai Heberu maeanai ti'abi haukia baiatakiai atetua erama, pokina aniani iwatekia raninai ekia wapuwapu hanona a'i tiraonanakia. ");
INSERT INTO rro_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Weiana iuhubeau harauhaea rua tehore Iesu tia'ikakaumana haukia ikoikiai tebato'unakia tetibaha, “A'i enamo Tirama ena 'abi iroro akana kaha habona aniani 'ao kohu iwatekia paunai. ");
INSERT INTO rro_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ua buonai uaho'abamai e, wai baiatamiai hau 'abaihau hamomo poukia tenamo haukia Auba Robe mai aotipai tebonu haukia katoa'i taeanakia aka neiana katobenakia kate'uai aina. ");
INSERT INTO rro_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","'A ai hanona rani ikoinai bahuba'ari mai iroro akakia mo katababainakia.” ");
INSERT INTO rro_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Iuhubeau ekia raona 'abina tebatohana, ba hau neiakia tea'i taeanakia, Stefano a'ikakauma mai Auba Robeai ebonu hauna, Pilipo, Porokoro, Nikanoro, Timona, Pamena, mai Nikolao ia hanona rama haeai hauna Antiokai emai Iuda haunai tebaona hauna. ");
INSERT INTO rro_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Haukia 'abaihau hamomo teaoainakia iuhubeau haukia wairakiai teba korotinakia, ba iuhubeau haukia tehore imakia 'arakiai tehao'au tebahuba'ari tebanamonakia. ");
INSERT INTO rro_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Weiana Tirama ena 'abi hanona tehina otaraina, Iesu tia'ikakaumana haukia tebo'o hao bo'o hao Ierusalema aonai, robe haukia bo'okia abomo Iesu tea'ikakaumana. ");
INSERT INTO rro_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stefano hanona Tirama ena aoko'o hoana mai hiabunai ebonu, ia ehore hoa mai bata'uta'u huri akakia maearima wairakiai ebabainakia. ");
INSERT INTO rro_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","'A hau baika hanona ia te'oatana, maearima weiakia hanona ‘Karahi 'abaea Mareana’ haukia, ia hanona Iuda maearimakia Kurene, Alesandereai temai, abomo Kilikia, Asiai temai haukia, baika tehore Stefano kipokia te'abi baitaeai. ");
INSERT INTO rro_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ia Stefano a'i te'abi haona pokina aotipai mai Auba Robe hiabunai ehina benakia. ");
INSERT INTO rro_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ua buonai ia tehore baika aokia teani kate'abi katetibaha, “Ai hanona ia ena 'abi ki'a obokia ehina Mose mai Tirama ohi ahakiai hauna taona.” ");
INSERT INTO rro_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Uahomanai aiara haukia mai aiara haukia apa'uakia abomo rauhubu poki haukia teba opuerenakia, ia temikiri teao Stefano tea'ina teaoaina bakai apa'uana haukia herekia. ");
INSERT INTO rro_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ba ia temaiainakia hinau bai'oi haukia baika tehore tehina benakia tetibaha, “Hau neiana hanona Robe 'ekana mai Mose ena rauhubu ia'iki'akia 'abina a'i nibapua 'apuana. ");
INSERT INTO rro_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ai aiana taona etibaha, Iesu Nasareta hauna kehore Marea Robe neiana kerubuna abomo Mose ena rauhubu ebenaka haukia ikoinai kebahaeainakia.” ");
INSERT INTO rro_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Bakai 'ekanai temiati haukia ikoikiai Stefano teiha 'ini'inina wairana ihana hanona matoha aneru ha wairana 'abana. ");
INSERT INTO rro_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Robe haukia arakiai hauna Stefano ebakaina etibaha, “Ekia 'abi hanona tohana, u?” ");
INSERT INTO rro_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stefano ena 'abi ebamuena etibaha, “Uaho'aba'u mai hama'u ikoimiai, aia'u tomona. Aika 'aba'abaka Aberahamo Harana a'i eao baha Mesopotamiai emiaho raninai, nuabi Tiramana ia herenai ewaira tina, ");
INSERT INTO rro_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ehina bena etibaha, ‘Emu hano mai hatia'amu kohabonakia, au ka'uahina hanona aeana hanomo weiana koao.’ ");
INSERT INTO rro_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Ua buonai Aberahamo ehore Kaldea haukia ekia hano ehabona, emikiri eao Haranai emiaho. Weia emiaho eaomo hamana e'ari, ba Tirama ehore ebaka'ana emaiaina bariu ṯomiaho aina hano neianai ebakarahina. ");
INSERT INTO rro_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Tirama Aberahamo ena hano tohana ha a'i ebena, 'apuna ihobona abomo ha a'i e'uahina. 'A Tirama hanona e'abi'uai hano weiana ia kipona mai 'aba'abana kebenakia. Rani weianai hanona Aberahamo nahuna aha'i. ");
INSERT INTO rro_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Tirama haeamona ehina bena etibaha, ‘Oi kupumu 'aba'abamu hanona hano neiana katehabona hano haeai haukia ekia hanoai katemiaho, hano weiana haukia ta'arakia katea'i ihau hinabu bani aonai ia hanona katehau haiara.’ ");
INSERT INTO rro_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Tirama e'abi mue etibaha, ‘Ekia ta'ara ia'inai katebaonakia haukia au kahore kabakainakia, murinai ia hanona katekarahi neia au katekuti aina'u.’ ");
INSERT INTO rro_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ba Tirama Aberahamo ehina bena itare katebabaina weiana hanona Tirama ena 'abi'uai apa'uana ibatohana hoana. Ua buonai Isako erama wapuna 'ababani aonai itare hoana ebabaina. Isako nahuna Iakobo ebaramana, abomo Iakobo nahuna harauhaea rua Isaraela itubu arakia terama. ");
INSERT INTO rro_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Itubu arana haukia tehore hatikia Iosepa tewamuru aina, Aigupito haukia herekiai tekawa kawaina ta'ara'i haunai eao. 'A Tirama hanona Iosepa e'abana, ");
INSERT INTO rro_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","abomo ena hau haiara ikoikiai aokiai ebamaurina. Hoahoa namona mai aotipa ebena Parao Aigupito obia 'arana wairanai, weiana Parao ehore Iosepa hiabu ebena Aigupito hanopakana mai ena itu haukia ikoikiai kepoki ainakia. ");
INSERT INTO rro_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“'A arobo rarina erama Aigupito mai Kanana hanokia maikoinai haiara rarina 'akina. Aika 'aba'abaka aniani ae'e katea'ina 'ekana aha'i. ");
INSERT INTO rro_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Iakobo 'uru eona Aigupito hanonai mai ekia aniani, ba nahuna aika 'aba'abaka euhunakia ekia rani kori'uaina. ");
INSERT INTO rro_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ekia rani ibaruanai Iosepa kipona ebawaira tinana uaho'abana wairakiai, Parao abomo e'iobina Iosepa hatia'ana. ");
INSERT INTO rro_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ba Iosepa 'abi euhuna hamana Iakobo mai hatia'ana ikoikiai katemai Aigupito, haukia imabui haraurua ima. ");
INSERT INTO rro_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ua buonai Iakobo emikiri eao Aigupito, weia e'ari murinai aika 'aba'abaka abomo weia te'ari. ");
INSERT INTO rro_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","'A ekia 'ari haukia hanona teaoainakia Sekem 'ariahanai tehorenakia. 'Ariahana weiana hanona Aberahamo ehore Hamoro nahuna imakiai moniai ekawana. ");
INSERT INTO rro_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Tirama ena 'abi'uai Aberahamo herenai ibatohana ranina ekaibari aonai, aika 'aba'abaka Aigupitoai terama ahi rama ahi abomo tebo'o ki'a baha. ");
INSERT INTO rro_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Eaomo puanai obia haeai ha Aigupito eobia aina, ia hanona Iosepa a'i e'iobina. ");
INSERT INTO rro_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Obia weiana 'aba'abaka ebapo'onakia, ebahaiaranakia abomo ebahi ahinakia kipokia nahukia 'oru'orukia katene'enakia kate'ari. ");
INSERT INTO rro_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Rani weianai Mose erama, miori papana namona Tirama wairanai, hamana ena ituai te'imana nawa aihau. ");
INSERT INTO rro_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Weiana atapakai tehabona murinai Parao nahuna uahona ea'ina ebapa'uana nahunai eao. ");
INSERT INTO rro_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ua buonai Aigupito haukia ekia 'iobi ikoinai Mose teba'iobina, ba Mose ena 'abi abomo ena aka hanona mai hiabukia. ");
INSERT INTO rro_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Mose ihauna bariabui ea'ina aonai eraonana hatia'ana Isaraela haukia keihanakia. ");
INSERT INTO rro_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ia 'abana ha eihana Aigupito hauna ehore nia'i ki'ana, buonai eao hau weiana ebaraina Aigupito hauna eahu 'arina. ");
INSERT INTO rro_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mose ena raona hanona hatia'ana kate'iobi haraina Tirama kehore Mose imanai ia arakia kebamaurinakia, ia a'i te'iobi 'apuana. ");
INSERT INTO rro_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Erani Isaraela haukia rua te'au, Mose eao herekia ebairarao etibaha, ‘Wai torarua hanona hatia'a, taba buonai kipomi tuba haiaranimi?’ ");
INSERT INTO rro_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Etabura hauna ehore Mose etori parena ebakaina etibaha, ‘Tai oi ea'i taeani'o, ai kopoki ainamai abomo kobakainamai? ");
INSERT INTO rro_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Nonuatae au koahu 'arina'u, warani Aigupito hauna oahu 'arina 'abana?’ ");
INSERT INTO rro_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Mose 'abi weiana eona raninai, beronai e'uru eao Midian hanonai emiaho hano haeai hauna 'abana, weia nahuna hau rua terama. ");
INSERT INTO rro_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Ihau bariabui teore murinai, hano'akunai Sinai oeo herenai matiu 'ini'ininai iruba eupa aonai aneru ha ewaira tina Mose wairanai. ");
INSERT INTO rro_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mose eihana raninai eta'uta'u huri, eka'a haha eao herena keiha haraina aonai, Obiapaka aiana eona. ");
INSERT INTO rro_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Etibaha, ‘Au hanona 'aba'abamu Aberahamo, Isako mai Iakobo ekia Tirama.’ Mose eta'u ki'a e'ururu 'ururu, a'i enuatae keihana. ");
INSERT INTO rro_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Obiapaka ehore ehina bena etibaha, ‘Emu tamaka moa'i obonakia, pokina okoroti 'ekana hanona Tirama nemiaho hanona erobe. ");
INSERT INTO rro_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Au e'u maearima Aigupitoai tihau haiara aihanakia abomo ti'arara aiakia aona, ua buonai ariri amai kabamaurinakia, bariu 'omikiri kauhuni'o koao Aigupito.’ ");
INSERT INTO rro_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Mose mo neiana tebaki'ana te'abi, ‘Tai oi ea'i taeani'o ai kopoki ainamai abomo kobakainamai?’ hauna Tirama ehore euhuna ekia poki abomo ibamaurikia haunai keao, matiu 'ini'inina e'ara aonai ewaira tina aneruna ena baraibarai ai. ");
INSERT INTO rro_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Mose weiana hauna Isaraela haukia Aigupitoai ebakarahinakia, bata'uta'u huri akakia abomo hoa akakia haeaihaeai ebabainakia Aigupitoai, 'Aku Bironai abomo ihau bariabui hano'akunai. ");
INSERT INTO rro_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mose mo weiana ehore Isaraela haukia ehina benakia etibaha, ‘Tirama kehore mahabanai hauna ha kebamikirina wai baiatamiai, matoha au 'abana.’ ");
INSERT INTO rro_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Hau weiana hanona Isaraela haukia hano'akunai temia to'u raninai Sinai Oeo 'ubinai e'abi aneruna mai 'aba'abaka baiatakiai, mauri 'abina ea'ina ebakabanaina aika 'euka. ");
INSERT INTO rro_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Ia aika 'aba'abaka hanona Mose aiana iona 'arina a'i te'ari teubo, ekia nuatae patemue Aigupito. ");
INSERT INTO rro_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Weiana ia tehore Arona tehina bena, ‘Tirama baika mobabainakia aika 'euka kate'uai ainaka, pokina a'i ta'iobina Mose Aigupitoai ebaka'anaka hamai hauna bariu aehoma?’ ");
INSERT INTO rro_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Rani weianai ia tehore poromakau nahu aubaubana ha tebabaina, banamo tabakia temaiainakia kaiba'uku weiana wairanai tehorotinakia, imakiai tebabaina tabana wairanai teaonamo. ");
INSERT INTO rro_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Weiana Tirama ia herekiai ekaobo ehabonakia kipokia kupa tabakia katekuti ainakia. Mahabanai hauna ena pukai tererena 'abana etibaha, ‘Isaraela haumi e, ihau bariabui hano'akunai beruberu mai banamo mahikia hanona au a'i tobanamo aina'u. ");
INSERT INTO rro_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Wai hanona tirama atana Molok ena ro'e ituna abomo emi bihiu tiramana atana Refan aubaubana tobuanakia, weiakia tobabainakia katokuti ainakia. Ua buonai Au kahore wai kabaibiunimi Babulono puana 'akinai.’ ");
INSERT INTO rro_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Aika 'aba'abaka herekiai Tirama ibawaira tinana ro'e ituna ha hano'akunai, ro'e weiana hanona Mose ebabaina Tirama ebaihana ihobonai. ");
INSERT INTO rro_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Muriai 'aba'abaka hamakia imakiai ro'e ituna weiana tea'ina tebuana Iosua kipokia teao rama haeai haukia ekia hanoai tekara'au, Tirama ehore wairakiai hano haukia eu'u parenakia, ia temiaho aina emai mo Davida ena raniai. ");
INSERT INTO rro_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Tirama ena banamo hanona Davida ebena, ba ia Tirama enoina Iakobo ena Tirama ena itu ha kebabaina. ");
INSERT INTO rro_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ia itu hanona Solomona ehore ebakorina. ");
INSERT INTO rro_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“'A 'ubi toha tohanai Tiramana hanona maearima imakiai tebabaina ituna aonai a'i nemiaho. Mahabanai hauna ena 'abi ihobona etibaha, ");
INSERT INTO rro_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Obiapaka ṉa e'abi aiho, Kupa hanona e'u mia'au 'ekana, hanopaka hanona ae'u ihorotina 'ekana. Itu aehomana katobabaina Au eu'u? E'u arai 'ekana hanona aeana? ");
INSERT INTO rro_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Taba neiakia ikoikiai hanona Au ima'uai a'i ababai, u?’ ");
INSERT INTO rro_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“'Ara pahihi haumi, aomi mai haiami tokaiabu harai matoha Tirama a'i te'iobina haukia 'abakia. Rani ikoinai wai tuhore Auba Robe tuhao abuna. 'Aba'abami ekia aka a'i torea 'apuana toa'i 'ini baihana. ");
INSERT INTO rro_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Wai 'aba'abami mahabanai hauna ha a'i te'oatana, u? Aka bero hauna kemai 'abina tehinana haukia teahu 'arinakia, bariu wai tohore tohina hinaina bero hauna toahu 'arina. ");
INSERT INTO rro_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Wai rauhubu weiana Tirama ena aneru ebaibeni hauna aba toa'ina iamo kipomi a'i toa'i taeana.” ");
INSERT INTO rro_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Iuda ekia obia haukia Stefano aiana teona raninai teopuere wairai 'aki'akikia teara 'ini'ini. ");
INSERT INTO rro_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ia Stefano hanona Auba Robeai ebonu, weiana ea'a taea kupa eihana, Tirama nuabina abomo Iesu Tirama itipana tainai ekoroti eihana. ");
INSERT INTO rro_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ia etibaha, “Tomoihana! Kupa aba ekaikau naihana abomo Maearima Nahuna Iesu Tirama itipana tainai ekoroti.” ");
INSERT INTO rro_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Weiana ia teio aota imakiai haiakia tekaiabunakia ikoikiai tebeau teao Stefano herena, ");
INSERT INTO rro_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","tea'ina aiara aonai teberi ahina atapakai ba piharai teahu ramana, hinau bai'oi haukia weiakia hanona ekia habuni tero'a ahinakia haukia tebakuri ahinakia hau 'aru'aruna ha atana Saulo aena pokinai tehoroti. ");
INSERT INTO rro_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Piharai teahuna aonai Stefano ebahuba'ari etibaha, “Obiapaka Iesu e, au auba'u moa'i taeana.” ");
INSERT INTO rro_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Weiana ekaipehu eio etibaha, “Obiapaka e! Ki'a neiana 'arana a'i kobenakia.” Ua e'abi aiho murinai e'ari. ");
INSERT INTO rro_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulo ehore Stefano teahu 'arina hanona ebatohana. Rani weianai bai'oata ranina erama, a'ikakauma haukia Ierusalemai temiaho haukia ikoikiai tebeau otaraina teao Iudea, Samaria hanokiai temiaho, 'a iuhubeau haukia kipokia mo Ierusalemai temiaho. ");
INSERT INTO rro_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Tirama timariki aina haukia baika Stefano tea'ina tehaiaina ba teaoaina 'ariahanai tehorena. ");
INSERT INTO rro_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","'A Saulo enuatae a'ikakauma haukia kea'i ki'anakia, itu ha ha aokiai etoto, hau mai babi'e eberi beri ahinakia, eaoainakia wapura ituna aonai ekaiabunakia. ");
INSERT INTO rro_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","A'ikakauma haukia tebeau otaraina haukia hanona pou namona teiroro aina eka ha ha aokiai. ");
INSERT INTO rro_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pilipo eao Samaria aiara apa'uanai ekarahi, weia Keriso pouna eiroro aina maearima herekiai. ");
INSERT INTO rro_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Maearima ikoikiai Pilipo aiana teona abomo hoa haeaihaeai akakia ebabai haukia teihana raninai mai aokia ikoinai tea'i taeana. ");
INSERT INTO rro_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Maearima aokiai auba ki'a obokia ṯemiaho haukia eu'u ahinakia tekarahi mai ioiokia, abomo mero mai 'ome haukia ebamaurinakia. ");
INSERT INTO rro_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ua buonai aonamo rarina 'akina erama aiara weiana aonai. ");
INSERT INTO rro_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","'Eka weianai hau ha atana Simona 'uaina raninai nepu akakia ebabai Samaria haukia ebata'unakia. Ia kipona ebapa'uana, ");
INSERT INTO rro_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","abomo maearima ikoikiai apa'uana eao mo papanai epua iamo aiana teona tetibaha, “Hau neiana hanona Tirama ena hiabuai niaka.” ");
INSERT INTO rro_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Rani homa'ana ena mea hoakia terama buonai aiana teona. ");
INSERT INTO rro_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","'A Pilipo Tirama ena obia aiarana pouna namona mai Iesu Keriso atana eiroro aina, weiana maearima hanona ia aiana tea'i taeana, ba hau mai babi'e eba'uere robenakia. ");
INSERT INTO rro_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simona abomo ea'ikakauma 'uere robe ea'ina murinai, Pilipo e'abana tekaoao aonai hoa haeaihaeai mai babai haeaihaeai akakia ebabainakia eihanakia hanona nuana etae. ");
INSERT INTO rro_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Iuhubeau Ierusalemai ṯemiaho haukia pou teona Samaria haukia abomo Tirama ena 'abi tia'i taeana, ua buonai Petero mai Ioane teuhunakia teao Samaria. ");
INSERT INTO rro_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Terarua Samariai tekatoto raninai, a'ikakauma haukia ahakiai tebahuba'ari Auba Robe katea'ina paunai, ");
INSERT INTO rro_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","pokina rani weianai Auba Robe hanona ia ahakiai a'i eriri baha, ia 'uere robe 'abaeana mo tea'ina Obiapaka Iesu atanai. ");
INSERT INTO rro_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ua buonai Petero mai Ioane ohi imakia ia ahakiai tehao'au tebahuba'ari raninai Auba Robe tea'ina. ");
INSERT INTO rro_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ba Simona Iuhubeau haukia eihanakia imakia a'ikakauma haukia ahakiai tehao'au tebahuba'ari Auba Robe tea'ina raninai, ia ehore moni baika emaiainakia iuhubeau haukia nibenakia netibaha, ");
INSERT INTO rro_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Hiabu naiana au abo'umo patobena'u, ba weiakia ikoikiai ima'u ahakiai pahao'au pabahuba'ari raninai ia abokiamo Auba Robe patea'ina.” ");
INSERT INTO rro_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","'A Petero ia ehina bena etibaha, “Oi emu moni ohi kato'ari haeamo pokina oraonana Tirama ena beruberu tabana hanona moniai kokawana. ");
INSERT INTO rro_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Aka neiana aonai oi 'ekamu 'ao itaumu hanona aha'i pokina aomu a'i ebero Tirama wairanai. ");
INSERT INTO rro_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Emu ki'ai moraona kabe, Obiapaka monoina, pa'e emu raona ki'a obona kehina haona. ");
INSERT INTO rro_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Pokina naihani'o, oi aomuai hanona wamuru ebonu 'auna abomo aka ki'a aba ebiri haraini'o.” ");
INSERT INTO rro_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simona nepu hauna iuhubeau haukia enoinakia etibaha, “Obiapaka tomobahuba'ari bena au pau'uai taba tohinana hauna here'uai a'i merama.” ");
INSERT INTO rro_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Petero mai Ioane Obiapaka ena 'abi tehina waira tinana abomo teiroro aina murinai, haeamona temue Ierusalema. Ekia mueai hanona Samaria aiarakia bo'okia aokiai pou namona teiroro aina. ");
INSERT INTO rro_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Obiapaka ena aneru ha Pilipo ehina bena etibaha, “Omikiri ahi taina moao, taeara weiana Ierusalemai eao Gasa taeara weiana hanona hano'akuna.” ");
INSERT INTO rro_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Pilipo emikiri taearai eao aonai Etiopia hauna ha eihana. Ia hanona hau apa'uana ha Etiopia obia 'arana babi'ena Kandake ena kohu i'imana hauna. Aba eao Ierusalemai ebahuba'ari, ");
INSERT INTO rro_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ba ena mueai ena rerueai emia'au Isaia mahabanai hauna ena puka ekaikauna netuabina. ");
INSERT INTO rro_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Weiana Auba Robe ehore Pilipo ehina bena etibaha, “Moao rerue weiana hauna herenai.” ");
INSERT INTO rro_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Pilipo ebeau eao aonai Isaia mahabanai hauna ena puka netuabina aiana eona. Ba ebakaina etibaha, “Notuabina hauna anina nubabataina, u?” ");
INSERT INTO rro_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Hau apa'uana weiana etibaha, “'A aea ka'iobi aihona? Iba'iobi'u hauna aha'i.” Ba ia ehore Pilipo enoina kekara'au herenai kemiati. ");
INSERT INTO rro_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Puka Robena etuabina aonai 'abina hanona ṉa terere aihona. “Ia hanona matoha mamoe 'abana katebaka'ana kateaoaina kateahu 'arina pinana a'i ekaikauna, 'ao matoha mamoe nahu buirana katekabena hauna 'uru'uruna aha'i 'abana, pinana a'i ekaikauna 'abi ha a'i ehina 'apuana. ");
INSERT INTO rro_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ena 'aiaunu buonai bakai aonai ena bero tea'i obona. Tai ha ena itubu robana a'i keahuna pokina ena mauri hanona huanai epua hanopakai aba ea'i obona.” ");
INSERT INTO rro_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Hau apa'uana weiana Pilipo ebakaina etibaha, “Moba'iobina'u, mahabanai hauna hanona tai robana eahuna? Ia kipona pouna ehinana 'ao hau ha pouna ehinana?” ");
INSERT INTO rro_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Weiana Pilipo ehore puka etuabina hauna 'ekanai ea'i ramana, Iesu pouna namona eba'iobina. ");
INSERT INTO rro_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Terarua taearai teao aonai bei 'ekanai ha tekara'au, ba hau apa'uana weiana etibaha, “Moihana, bei weiana, au ka'uere robe a'i ketaina pokina hana taba?” ");
INSERT INTO rro_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","(Pilipo etibaha, “Koa'ikakauma mai aomu ikoinai raninai, 'uere robe koa'ina hanona enamo.” Ba hau apa'uana weiana etibaha, “Mai ao'u ikoinai na'ikakauma Iesu Keriso hanona Tirama Nahuna.”) ");
INSERT INTO rro_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ba ehina bena rerue ebakorotina, Pilipo mai hau apa'uana terarua teriri teao bei aonai, Pilipo ehore hau weiana eba'uere robena. ");
INSERT INTO rro_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Terarua beiai tekara'au raninai, Obiapaka Aubana ehore Pilipo ea'i parena. Ba hau apa'uana weiana Pilipo a'i eiha muena, ia taearai eao mai aonamona. ");
INSERT INTO rro_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","'A Pilipo hanona Asoto aiaranai ewaira tina, ba ekatoto aiarakia ikoikiai aokiai pou namona eiroro aina eaomo Kaisarea aiaranai ekara'au. ");
INSERT INTO rro_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Rani weianai weia Ierusalema aonai Saulo ena ao haiara ikoinai hanona Obiapaka te'abana haukia kebata'unakia 'ao keahu 'arinakia, buonai eao robe haukia 'arakiai hauna herena. ");
INSERT INTO rro_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Enoina marere ha kererena kebena keao Damaseko marea herekiai. Weia Iesu tia'ikakauma taearana neianai teka'aina haukia hau mai babi'e kebirinakia keaoainakia Ierusalema wapura 'ekana. ");
INSERT INTO rro_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Saulo taearai eao Damaseko aiara aba ebarina aonai mawa'eai mo ea ha kupai eriri ia ebarara ahina. ");
INSERT INTO rro_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Saulo e'eho 'anoai, aia ha eona etibaha, “Saulo e! Saulo e! Taba buonai au nu'oatana'u?” ");
INSERT INTO rro_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saulo ebakai bakai etibaha, “Obiapaka e, oi tai?” Ena 'abi ebamuena etibaha, “Au Iesu nu'oatana'u hau'u. ");
INSERT INTO rro_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Bariu momikiri koao aiara aonai, weia hau ha kehore oi kobabainakia haukia akakia keba'iobini'o.” ");
INSERT INTO rro_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Te'abana haukia ikoikiai tekoroti a'i 'uri'urikia, pokina aia mo teona ia tai ha a'i teihana. ");
INSERT INTO rro_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saulo 'anoai emikiri mahana ebano'anakia, ia taba ha a'i eiha 'apuana. Ua buonai imanai te'ebe tebaka'ana teaoaina Damaseko. ");
INSERT INTO rro_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Weia wapu aihau emiaho taba ha a'i eihana, aniani ha a'i eana, bei abomo a'i einu. ");
INSERT INTO rro_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ba a'ikakauma hauna ha Damasekoai atana Anania, ena mahabanaiai Obiapaka ia eaparina etibaha, “Anania e!” Anania eo'o e'abi etibaha, “'E! Obiapaka. Au neia'u.” ");
INSERT INTO rro_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ba Obiapaka Anania ehina bena etibaha, “Momikiri koao airabuana atana ‘Bero’ weia Iuda ena ituai Taso hauna atana Saulo kobakai bakai aina. Pokina ia hanona nibahuba'ari nemiaho. ");
INSERT INTO rro_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ia emahabanai hanona hau ha atana Anania eihana nimai ia ahanai kehao'au kebahuba'ari hanona mahana katenamo.” ");
INSERT INTO rro_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ia Anania Obiapaka ena 'abi ebamuena etibaha, “Hau neiana pouna rani bo'ona aona, Ierusalemai emu maearima robekia bo'okia ebahaiara ki'anakia. ");
INSERT INTO rro_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ba bariu robe haukia apa'uakia hiabu tebena, kemai neia abomo oi atamu tiaparina haukia ikoikiai kebirinakia.” ");
INSERT INTO rro_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Obiapaka ia ehina bena etibaha, “Moao. Pokina au aba ia atina'ana ta'ara'u ia'inai keao, rama haeaihaeai haukia, aiara obiakia abomo Isaraela haukia wairakiai au ata'u keiroro aina. ");
INSERT INTO rro_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Haeamona au kahore kabaihana ia kehaiara ki'a baha au ata'u paunai.” ");
INSERT INTO rro_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ua buonai Anania emikiri eao, itu ai etoto, imana rua Saulo ahanai ehao'au etibaha, “Uaho'aba'u Saulo e! Obiapaka Iesu taearai omai heremuai ewaira tina hauna euhuna'u amai, oi mahamu kateno'a koiha mue abomo Auba Robeai kebabonuni'o paunai.” ");
INSERT INTO rro_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Beronai matoha maia unakia 'abana Saulo mahanai te'eho, ba mahana tenamo, ena ihaiha enamo mue. Emikiri eao teba'uere robena. ");
INSERT INTO rro_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ba eaniani murinai hanona hauanina etabura mue. Wapu baika Damaseko ai emiaho a'ikakauma haukia herekiai. ");
INSERT INTO rro_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Rani a'i ehoma'a aonai, Saulo emikiri Iuda haukia ekia marea ha ha aokiai eiroro ramana Iesu hanona Tirama Nahuna. ");
INSERT INTO rro_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Aiana teona haukia ikoikiai teta'u ta'u huri tetibaha, “Neiana hanona Ierusalemai Iesu tekuti aina haukia ea'i ki'a ki'a bahanakia hauna. Ba emai neia baika abomo kebirinakia keaoainakia robe haukia apa'uakia herekia, 'u?” ");
INSERT INTO rro_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","'A Saulo ena iroro hanona ehiabu e'ariai 'ariai, ia ebatohana Iesu hanona Keriso. Ua buonai Iuda haukia Damasekoai ṯemiaho haukia ena 'abi katebamuena taearana aha'i. ");
INSERT INTO rro_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Wapu baika teao murinai, Iuda haukia teto'u Saulo iahu 'arina robana teahuna, ");
INSERT INTO rro_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ia Saulo hanona ekia robahu aba e'iobina. Ia hanona aiara parabuna pa'abina ṯe'ima rabina ṯe'ima ranina Saulo kateahu 'arina paunai. ");
INSERT INTO rro_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ia murinai tika'a haukia rabi aonai Saulo areha aonai teutana parabu 'ubinai waroai tebaririna. ");
INSERT INTO rro_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ba Saulo eao Ierusalemai ekara'au raninai ena nuatae hanona a'ikakauma haukia kipokia kateto'u, ia ikoikiai teta'u aina pokina a'i te'iobina ia hanona aba Iesu nia'ikakaumana. ");
INSERT INTO rro_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ia Banaba ehore ebaraina ebaka'ana eaoaina iuhubeau haukia herekia. Saulo taearai Obiapaka aea eiha aihona, mai Obiapaka ehore ia ehina bena hauna, haeamona Damaseko ai Iesu pouna aea eiroroai aihona mai taburana hauna poukia ehinanakia. ");
INSERT INTO rro_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Weiana buonai Saulo weia kipokia Ierusalemai temiaho, ena kaoaoai Iesu atana eiroro aina mai taburana. ");
INSERT INTO rro_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Iuda maearimakia Helene maeanai ṯehinana haukia Saulo kipokia te'abi 'abi hanona tebaiara, buonai taearana tetabu kateahu 'arina. ");
INSERT INTO rro_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Uaho'abana baika pou weiana te'iobina aonai, Saulo tebaka'ana teaoaina Kaisarea weia teuhuna eao Taso. ");
INSERT INTO rro_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Weiana Iudea, Galilea mai Samaria hanokia ikoikiai Tirama ena marea haukia aokiai baibua erama Obiapaka temariki aina mai Auba Robe baraibarai ebenakia ihobonai ekia tabura eapa'ua haeamona Tirama ena marea haukia ekia bo'o hanona ekara'au. ");
INSERT INTO rro_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petero hanona aiara ha ha aokiai ekabanai eaomo Rudai Tirama ena maearima herekiai ekara'au. ");
INSERT INTO rro_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Eka weianai mero hauna ha etabu ahina atana Aenea. Ia hanona uahomana enoti ihau aba 'ababani. ");
INSERT INTO rro_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ba Petero e'abi etibaha, “Aenea e! Iesu Keriso bariu oi nibamauri maurini'o. Momikiri, emu taba moa'i a'i harainakia.” Beronai mo Aenea emikiri. ");
INSERT INTO rro_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ruda mai Saronai ṯemiaho haukia ikoikiai hoa weiana teihana raninai, teraona kabe Obiapaka herena teao. ");
INSERT INTO rro_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Iopa aiaranai a'ikakauma babi'ena ha emiaho, atana hanona Tabita. (Helene maeakiai hanona Doreka.) Rani ikoikiai aka namokia ebabai uraru haukia ebarainakia. ");
INSERT INTO rro_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Rani weianai ia hanona einawa ba e'ari. Epua teba'uere haraina ba itu aonai ikaihuri ha 'ubiai hauna aonai tebaenotina. ");
INSERT INTO rro_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ruda mai Iopa baiatakia hanona a'i ehoma'a. Ua buonai Iopa ai a'ikakauma haukia baika te'iobina Petero hanona weia Ruda ai, ba temikiri hau rua teuhunakia teao Petero herena, tenoina keao biai herekia. ");
INSERT INTO rro_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ua buonai Petero emikiri kipokia teao, ba tekara'au raninai teaoaina itu aonai ikaihuri ha 'ubiai hauna aonai tebakara'auna. Wapu baika abomo weia tekoroti tihai, Doreka maurinai habuni ibatoto mai iro'abu etainakia haukia Petero tebaihana. ");
INSERT INTO rro_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petero ehore euhunakia tekarahi ba ekaipehu ebahuba'ari. Murinai 'ari babi'ena ewairana e'abi etibaha, “Tabita e! 'Omikiri.” Weiana ia mahana eba no'anakia Petero eihana ba emikiri emiati. ");
INSERT INTO rro_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Petero ehore imanai ea'i ebaraina, emikiri ekoroti. A'ikakauma haukia mai wapu eaparinakia temai herena, babi'e ebamauri maurina hauna ebaihanakia. ");
INSERT INTO rro_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Pou neiana hanona Iopa aiarana ikoinai tehina otaraina, ba maearima bo'ona Obiapaka tea'ikakaumana. ");
INSERT INTO rro_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petero weia Iopai Simona poromakau paruakia nitainakia hauna herenai rani homa'ana emiaho. ");
INSERT INTO rro_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Kaisarea aiaranai Roma huari hauna ha atana Korenelio, Italia huari haukia ikoinai hinabu hamomo ekia poki hauna. ");
INSERT INTO rro_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ia mai ena itu haukia kipokia hanona Tirama timariki aina mai ena nuatae tika'i haraina, ia ena taba bo'okia Iuda haukia uraru haukia eberuberu benakia, abomo rani ikoinai ebahuba'ari Tirama herenai. ");
INSERT INTO rro_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Rani ha atiaha abiranai beraura hoana aihau 'abana, ia emahabanai hanona Tirama ena aneru ha eiha haraina emai ia ena ituai etoto ehina bena etibaha, “Korenelio e.” ");
INSERT INTO rro_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ia mai ta'una aneru eiha 'ini'inina e'abi etibaha, “Obiapaka e, omai hanona taba?” Aneru ia ehina bena etibaha, “Emu bahuba'ari mai emu beruberu uraru obarainakia haukia Tirama aba ea'i taeanakia ba ia hanona oi a'i nireani'o. ");
INSERT INTO rro_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Bariu emu miori baika mouhunakia temeao Iopa, hau ha atana Simona atana ibaruana Petero katehina bena kipokia katemai. ");
INSERT INTO rro_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ia hanona Simona ha poromakau paruakiai taba haeaihaeai nitainakia hauna ena 'ekai nemiaho, ena itu hanona poe haianai.” ");
INSERT INTO rro_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Aneru 'abi weiana ebaibeni ba eka'a, murinai Korenelio ehore ena ituai ta'ara'i miorikia rua mai huari hauna ha Obiapaka ena nuatae nika'aina hauna kipokia eaparinakia. ");
INSERT INTO rro_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Weiana Korenelio herenai terama haukia maikoinai hau weiakia teaihau ehina benakia, epua euhunakia Iopa teao. ");
INSERT INTO rro_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Wapu ibaruana atiahanai maearima weiakia Iopa aba tebarina hana Petero ekara'au eao itu kapena arai 'ekanai ua'a kebahuba'ari. ");
INSERT INTO rro_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Mare'a e'ari, enuatae taba ha pehaea peana, aniani tiba'oru ohonamo aonai ia taba ha eihana matoha nenibi 'abana. ");
INSERT INTO rro_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Kupa ikaikau eihana mai taba ha habuni panabana rarina 'abana puana bani banikiai ia'i to'o ibariri nimai hanopaka. ");
INSERT INTO rro_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Habuni weiana aonai mahi aekia bani bani haukia ikoikiai, hanopakai tikara haukia ikoikiai mai 'ubiai tirobo roborobokia ikoikiai weia aonai iuta'au. ");
INSERT INTO rro_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ba aia ha ia ehina bena etibaha, “Petero e, omikiri moahu moani.” ");
INSERT INTO rro_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","'A Petero aia weiana ena 'abi ebamuena etibaha, “Obiapaka e, aha'i 'akina, au mahi Tirama wairanai te'opu haukia 'ao a'i terobe haukia ha a'i ṉani 'apuana.” ");
INSERT INTO rro_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Aia weiana haeamona Petero ehina bena etibaha, “Tirama aba ebamaha mahanakia haukia oi 'opukia a'i kohinana.” ");
INSERT INTO rro_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Hoa neiana rani aihau ewaira tina ba beronai habuni weiana hanona iberi'au emue eao kupa. ");
INSERT INTO rro_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Petero mahabanai weiana anina niraonana aonai, Korenelio euhunakia haukia Simona ena itu tetabu ahina ba temai ena ara pa'abina 'akonai tekoroti. ");
INSERT INTO rro_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Weiana teapari tebakai bakai Simona atana ha Petero hanona weia nemiaho 'ao. ");
INSERT INTO rro_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Petero mahabanai weiana niraona ohona aonai Auba Robe ehore ia ehina bena etibaha, “Petero e, maearima aihau hanona oi titabuni'o. ");
INSERT INTO rro_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Momikiri, moriri moao herekia, aomu a'i kearo'ari kipokia katoao, pokina ia haukia au auhunakia.” ");
INSERT INTO rro_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Petero eriri eao hau weiakia ehina benakia etibaha, “tutabuna hauna hanona au neia'u. Emi raona ha buonai tomai, 'u?” ");
INSERT INTO rro_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ba ia ena 'abi tebamuena tetibaha, “Ai hanona Korenelio huari haukia hinabu hamomo nipokinakia hauna euhunamai tamai. Ia hanona bero hauna mai Tirama nimariki aina hauna Iuda haukia ikoikiai hanona ia timariki aina. Tirama ena aneru ha ia ehina bena kebaiuhu koao ena itu, weiana oi taba ko'uahina hanona aiamu keona.” ");
INSERT INTO rro_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Petero ehore hau weiakia ebatotonakia ituai kipokia teparua. Erani rauraninai Petero eba'oru ba temikiri teka'a, a'ikakauma haukia baika Iopai ṯemiaho haukia abomo ia te'abanakia kipokia teao. ");
INSERT INTO rro_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Erani ba rani haeai hanona ia Kaisarea aiaranai tekara'au. Korenelio hanona hatia'ana mai ena hau tohakia baika ebeaunakia ia kipokia Petero kate'imana. ");
INSERT INTO rro_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Petero ituai ekara'au ba Korenelio ohi tebaitabu ahi aonai Petero aena pokinai e'umuti ekuti aina. ");
INSERT INTO rro_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ia Petero Korenelio eberi taeana ehina bena etibaha, “'Omikiri, au hanona maearima 'abaea'u oi 'abana.” ");
INSERT INTO rro_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Weiana terarua mai 'abi'abikia ituai tekatoto aonai maearima bo'ona teto'una eihanakia. ");
INSERT INTO rro_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ba Petero ehina benakia etibaha, “Wai to'iobi ki'a bahana Iuda hauna hanona rama haeai hauna ohi a'i katemiaho haeamo, abomo a'i keao herena mai rauhubuna. Ia Tirama ebaihana'u hau ha 'opuna 'ao a'i erobe hauna a'i kahina 'apuana. ");
INSERT INTO rro_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Weiana buonai emi beaubeau eao hanona beronai amai a'i aubo. E'u bakai bakai hanona neiana, taba buonai tobaiuhu au amai?” ");
INSERT INTO rro_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Korenelio ia ena 'abi ebamuena etibaha, “Wapu bani aba teao aonai, atiaha abiranai beraura hoana aihau 'abana bariu ihobona ṉahomanai e'u ituai abahuba'ari aonai beronai mo hau ha ena habuni 'imare'imarena waira'uai ekoroti. ");
INSERT INTO rro_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ba ehina bena'u etibaha, ‘Korenelio e, Tirama hanona emu bahuba'ari aiana abeona abomo emu beruberu akakia uraru herekiai haukia niraona 'ini'ininakia. ");
INSERT INTO rro_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ua buonai 'abi kouhuna keao Iopa, Simona atana ha Petero kemai, ia hanona hau ha poromakau paruakia nitai hauna atana Simona ena ituai nemiaho weia poe haianai.’ ");
INSERT INTO rro_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Weiana buonai 'abi auhu noanoana ewahi, ba omai hanona enamo. Ai ikoimaiai neia Tirama wairanai aba tato'una, Obiapaka oi ebahi ahini'o 'abikia ikoikiai kohinanakia aiamu kataona.” ");
INSERT INTO rro_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Petero ena 'abi ea'i ramana etibaha, “'Abi tohana, bariu a'iobi haraina Tirama hanona maearima ha a'i nitaina ia ikoikiai ihoboai niba ka'anakia. ");
INSERT INTO rro_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","'Abina aha'i itubu tabana hauna ia Tirama nimariki aina abomo bero akakia nibabai hauna Tirama nihore nia'i taeana. ");
INSERT INTO rro_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Tirama 'abi euhuna eao Isaraela maearimakia herekiai hanona neiana, baibua pouna namona hana Iesu Keriso aonai nimai, ia hanona maearima ikoikiai ekia Obiapaka. ");
INSERT INTO rro_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Wai aba to'iobina hoa neiana hanona Galilea ai ea'i ramana, Ioane maearima wairakiai ba'uere robe eiroro aina murinai Isaraela hanona maikoina aonai erama. ");
INSERT INTO rro_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Wai Iesu Nasareta hauna to'iobina, Tirama ehore Auba Robe mai hiabu ia ahanai ebakikina, Iesu eao 'ekakia ikoikiai namo ebabai, mai Satani ea'i ki'anakia haukia ikoikiai ebamaurinakia, pokina Tirama hanona ia e'abana. ");
INSERT INTO rro_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Iuda aiarakia maikoina aonai mai Ierusalemai ebabai tabakia ikoikiai mahamaiai taihanakia. Iuda haukia tehore matiu ibiri ropo 'arunai tekoko 'auna e'ari. ");
INSERT INTO rro_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ia wapu ibaihaunai Tirama ehore Iesu 'ariai ebamikirina mai ebawaira tinana, ");
INSERT INTO rro_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","maearima ikoikiai wairakiai aha'i, ai Tirama aba etina'anamai haumai wairamaiai mo. Ia 'ariai emikiri murinai kipokia taniani haeamo abomo bei tainu haumai neiamai hanona ia pouna ṯahinana. ");
INSERT INTO rro_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ia ai ehina benamai maearima herekiai pou namona katairoro aina haeamona katahina pou haraina weiana Tirama ehore ia ea'i taeana mauri haukia mai 'ari haukia kebabakainakia haunai ebaona. ");
INSERT INTO rro_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Mahabanai haukia ikoikiai ia pouna aba tehina haraina, weiakia ikoikiai Iesu kate a'ikakaumana haukia hanona ia atanai ekia ki'a kehina hao.” ");
INSERT INTO rro_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Petero 'abi neiakia nehina ohonakia aonai, weiakia tibahu haukia ikoikiai ahakiai Auba Robe eriri. ");
INSERT INTO rro_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Iuda haukia weiakia Iesu tia'ikakaumana mai Petero ti'abana haukia teta'uta'u huri, pokina Auba Robe ena beruberu hanona rama haeai haukia ahakiai abomo eba ririna, ");
INSERT INTO rro_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","haeamona ia aiakia teona maea haeaihaeai ti'abi'abi mai Tirama tibanamona. Weiana Petero e'abi etibaha, ");
INSERT INTO rro_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Maearima neiakia hanona Auba Robe aba tea'ina aika ha'ina ihobonai. Ba tai ia kebamuenakia beiai a'i kate'uere robe?” ");
INSERT INTO rro_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Weiana Petero ia ehina benakia Iesu Keriso atanai kate'uere robe. Ba te'uere robe murinai Petero tenoina wapu baika weia herekiai kemiaho. ");
INSERT INTO rro_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Iuhubeau haukia mai uaho'aba Iudeai ṯemiaho haukia hanona rama haeai haukia abomo Tirama ena 'abi aba tea'i taeana hauna pouna teona. ");
INSERT INTO rro_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Weiana Petero emue Ierusalemai ekara'au raninai, Iuda haukia weiakia Iesu tia'ikakauma haukia ia herenai te'abi pahihi, ");
INSERT INTO rro_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","tetibaha, “Oi a'i tetarenakia haukia herekia oao ekia ituai kipokia toaniani haeamo, 'u?” ");
INSERT INTO rro_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Weiana Petero ehore taba terama haukia ikoikiai ia wairakiai ehina harainakia. ");
INSERT INTO rro_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Ia e'abi etibaha, “Iopai ua'a rani ha e'u bahuba'ari aonai amahabanai, ba taba ha kupai eriri aihana ihana matoha habuni rarina 'akina 'abana, puana bani banikiai ia'i to'o ibariri here'u. ");
INSERT INTO rro_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Aihaiha haraina aona tabakia ikoikiai hanona mahi aekia banibani tika'a haukia, hanopakai tikara tabakia mai 'ubiai tirobo roborobokia aihanakia. ");
INSERT INTO rro_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ba aia ha aona ehina bena'u etibaha, ‘Petero e, omikiri moahu 'ari moani.’ ");
INSERT INTO rro_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ia au a'abi atibaha, ‘Obiapaka e, aha'i 'akina, au 'opu tabakia 'ao a'i terobe tabakia ha pina'uai a'i ṉani 'apuana.’ ");
INSERT INTO rro_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Iamo aia ibaruana haeamona kupai emai etibaha, ‘Tirama ebamaha mahanakia tabakia hanona oi 'opukia a'i kohinanakia.’ ");
INSERT INTO rro_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Hoa neiana rani ibaihauna ewaira tina. Ba taba weiakia ikoikiai mai habunina haeamona iberi'au mue kupa eao. ");
INSERT INTO rro_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Rani weianai hau aihau Kaisareai teuhunakia temai here'u haukia beronai amiaho itunai tekara'au. ");
INSERT INTO rro_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Aonai Auba Robe ehina bena'u a'i kabaoao ia kipokia kataeao. Uaho'abaka neiakia 'abaihau kipokia taeao Kaisareai hau weiana atana Korenelio ena ituai takatoto. ");
INSERT INTO rro_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ia ehina benamai, aneru ha ena ituai ewaira tina ba ia ehina bena etibaha, ‘Hau harua kouhunakia kateao Iopa ai ua'a Simona atana ha Petero katehina bena kemai. ");
INSERT INTO rro_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ia kehore 'abi kemaiaina, weiana oi mai emu itu maearimakia kipokia ibamaurimi.’ ");
INSERT INTO rro_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","E'u 'abi a'iramana aonai Auba Robe ia ahakiai eriri ihobona 'uainai aika ahakai eriri 'abana. ");
INSERT INTO rro_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Weiana aonai Obiapaka ena 'abi araona tinana, ‘Ioane beiai eba'uere robe 'a wai hanona Auba Robeai kato'uere robe.’ ");
INSERT INTO rro_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Weiana aika Obiapaka Iesu Keriso ha'ikakauma aonai Tirama ena beruberu ebenaka ihobonai beruberuna hamona ia abomo ebenakia. Ba au maearima aea homa'u Tirama ena aka weiana kakaiabuna?” ");
INSERT INTO rro_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Iuda a'ikakauma haukia 'abi neiana teona raninai ekia baoao baoao tebapuanakia iamo Tirama tebanamona tetibaha, “Tirama ehore rama haeai haukia abomo aba bero ebenakia weiana ekia ki'ai kateraona kabe raninai mauri kebenakia.” ");
INSERT INTO rro_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Stefano ena 'ari murinai a'ikakauma haukia terama otaraina, baika atau'a tohana teao Foenikia, Kupuro hanokia mai Antioka, Iuda haukia kipokia mo baiatakiai pou namona teba'iobi aina. ");
INSERT INTO rro_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ia a'ikakauma haukia baika hanona Kupuro mai Kurene haukia. Ia teao Antioka ai tekara'au raninai rama haeai haukia abomo tehina benakia. Obiapaka Iesu pouna namona teiroro aina. ");
INSERT INTO rro_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Obiapaka ena hiabu hanona ia herekiai paunai maearima bo'ona 'akina tea'ikakauma Obiapaka herena teao. ");
INSERT INTO rro_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Pou neiana eao Ierusalemai a'ikakauma haukia teona, weiana Banaba teuhuna Antioka keao. ");
INSERT INTO rro_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ia Antiokai ekara'au Tirama maearima ua ebanamo harai aihonakia eihana raninai ia aona hanona enamo, haeamona ikoikiai ebataburanakia Obiapaka aiana kateka'aina mai aokia ikoinai. ");
INSERT INTO rro_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banaba hanona hau namona Auba Robeai ebonu mai ena a'ikakauma etabura. Ua buonai maearima bo'ona temai Obiapaka herena. ");
INSERT INTO rro_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Weiana murinai Banaba emikiri Taso eao Saulo ketabuna. ");
INSERT INTO rro_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Etabu ahina raninai eaoaina Antioka. Ihau hamona terarua ua'a, a'ikakauma haukia kipokia teto'u abomo maearima bo'ona teba'iobinakia. Weia Antiokai Iesu tia'ikakaumana haukia weiakia atakia teapari ramana Keriso ena maearima. ");
INSERT INTO rro_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Rani weianai mahabanai haukia baika Ierusalemai teriri temai Antioka. ");
INSERT INTO rro_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ha atana hanona Agabo emikiri Auba Robe ena hiabuai arobo rarina 'akina hanopaka maikoinai kerama hauna pouna ehinana. (Arobo weiana hanona Klaudio ena obia raninai erama toha.) ");
INSERT INTO rro_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Weiana a'ikakauma haukia weia Antiokai hanona aokia tebahamona tenuatae ia ha ha ekia tabura ihobonai baraibarai katetiu ahina uaho'abakia Keriso aonai weia Iudea ai ṯemiaho haukia 'eukia. ");
INSERT INTO rro_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ba ua tebabai aiho. Ekia beruberu hanona Banaba mai Saulo imakiai teutana ba ia terarua tehore beruberu weiana teaoaina Iudeai a'ikakauma haukia ṯe'uai ainakia haukia katebenakia. ");
INSERT INTO rro_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ua raninai Heroda Obia hauna ehore Tirama ena marea haukia baika ea'inakia enuatae kea'i ki'anakia paunai. ");
INSERT INTO rro_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ia ehore Ioane a'ana Iakobo akiua ai ehara 'arina, ");
INSERT INTO rro_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Heroda Iuda haukia eihanakia babai weiana hauna teaonamo aina, ua buonai ia ehore Petero abomo ea'ina. Rani weiana hanona Iuda haukia ekia tatu ha Parawa ibakupu aha'i tatuna ranina. ");
INSERT INTO rro_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ea'ina wapura itunai ekaiabuna, huari haukia harau haea 'abaihau imakiai eutana, bani bani kate'imana. Heroda ena raona hanona tatu murinai kebakarahina mako wairakiai kebabakaina. ");
INSERT INTO rro_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ua buonai Petero wapura itunai te'imana, ia a'ikakauma haukia hanona Tirama tenoi tabura taburana Petero paunai. ");
INSERT INTO rro_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Heroda eraonana kebakarahina ṉa ehoma rani weiana a'i nimai baha rabinai, Petero hanona huari haukia rua baiatakiai enoti eparua mai ibirikia rua. Ba huari haukia rua pa'abi 'akonai tebai'ima. ");
INSERT INTO rro_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Aonai biai mo Obiapaka ena aneru ia herenai ekoroti eana ikaihuri ebaeana, aneru ehore Petero robuna eati 'apuana, ebaona etibaha, “'Omikiri biai,” raninai imana rua tabiri te'eho. ");
INSERT INTO rro_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Aneru ehore Petero ehina bena etibaha, “Emu habuni mobatotona, emu tamaka moaba'au.” Petero ua ebabai aiho, aneru e'abi mue, “Emu iro'abu moa'ina moro'abuni'o, muri'uai koka'a.” ");
INSERT INTO rro_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Petero wapura ituna ikaihurina ekarahi aneru murinai eka'a, ia a'i ebabataina aneru ena aka weiana hanona tohana 'ao nimahabanai. ");
INSERT INTO rro_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","'Ima haukia kori 'uaina mai ibaruana tekaboinakia teao auri pa'abina weiana katekarahi aiarai katetoto hauna kipona ekaikauna, ba terarua tekarahi aiara taearana teka'a teao aonai beronai aneru Petero herenai ekaobo. ");
INSERT INTO rro_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Weiana Petero aona ea e'abi etibaha, “Bariu au a'iobi haraina Obiapaka ehore ena aneru euhuna, Heroda ena hiabu ba'anai mai Iuda haukia ekia raona weiana here'uai katebabai aokiai ebamaurina'u.” ");
INSERT INTO rro_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Kipona aonai eraona raona haraina, ba beronai Maria ena itu eao, Maria weiana hanona Ioane Mareko hinana, a'ikakauma haukia bo'ona weia teto'una tibahuba'ari. ");
INSERT INTO rro_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Petero itu weiana pa'abinai ehara hara, ba ta'ara'i uahona ha atana Roda eao pa'abi kekaikauna. ");
INSERT INTO rro_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Uaho Petero aiana e'iobina raninai, aona enamo ki'a baha, pa'abi a'i ekaikauna ia ebeau emue eao ehina benakia etibaha, “Petero hanona pa'abi 'akonai ekoroti.” ");
INSERT INTO rro_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ia uaho tehina bena tetibaha, “Oi nuao 'abaea!” 'A uaho e'abi tabura weiana hanona tohana. Ua buonai ia te'abi tetibaha, “Ṉa pa'e Petero ne'imana aneruna.” ");
INSERT INTO rro_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","'A Petero ehara hara oho paunai, ia pa'abi tekaikauna ba teihana raninai teta'u ta'u huri. ");
INSERT INTO rro_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Petero imanai ehara abunakia urukia keaha'i, ba Obiapaka wapura itunai aea ebakarahi aihona hauna pouna ehinana, abomo ehina benakia Iakobo mai uaho'abakia herekiai pouna katehinana. Ba ekaobo 'eka ha eao. ");
INSERT INTO rro_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Raurani 'amarinai atetua rarina erama huari haukia kipokia baiatakiai tebakai bakai Petero herenai taba erama. ");
INSERT INTO rro_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Heroda e'abi katetabuna, ia a'i tetabu ahina, ua buonai i'imana haukia ebakainakia ba ena 'abiai teahu 'arinakia. Neiana murinai Heroda Iudea ehabona eao Kaisarea ua'a emiaho. ");
INSERT INTO rro_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Heroda hanona Turo mai Sidono maearimakia eopuereai ki'anakia, ua buonai ikoikiai aokia tebahamona herena kateao. Kori'uaina Heroda ena itu nipoki aina hauna atana Blasto herena teao teba'amena temaiaina ia taikiai, ba teao Heroda herena baibua tenoi aina. Pokina ekia aniani hanona obia hauna weiana ena hanoai nimai. ");
INSERT INTO rro_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Heroda etina'ana wapunai, ia ehore ena obia habunina ebatotona ena obia imia'aunai emia'au maearima eiroronakia. ");
INSERT INTO rro_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ba aiara maearimakia ia teioaina tetibaha, “Neiana hanona Tirama ha aiana, ia maearima ha aiana aha'i.” ");
INSERT INTO rro_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Weiana aonai Obiapaka ena aneru beronai Heroda eahu obona pokina ia Tirama a'i ebanamona paunai, 'erau'erau ia hauanina teana ba e'ari. ");
INSERT INTO rro_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ia Tirama ena 'abi hanona etabura haeamona erama otaraina, a'ikakauma maearimakia hanona ebo'o hao bo'o hao. ");
INSERT INTO rro_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banaba mai Saulo ekia aka weiana moni tebenakia hauna tebaorena raninai Ierusalema tehabona, Ioane atana ha Mareko abomo tebaka'ana kipokia Antioka teao. ");
INSERT INTO rro_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antioka mareana aonai mahabanai mai bamarere haukia baika atakia neiakia, Banaba, Simeona (hau umuna), Lukio (Kurene hauna), Manaen (Heroda ohi tekiro haeamo) mai Saulo. ");
INSERT INTO rro_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ia tehore Obiapaka tekuti aina mai teani robe aonai, Auba Robe ehina benakia etibaha, “Banaba mai Saulo ohi katoa'i taeanakia au pau'uai, au anuatae aina akana katebabaina.” ");
INSERT INTO rro_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Weiana teani robe mai tebahuba'ari murinai, imakia ia terarua ahakiai tehao 'au ba teuhu ahinakia. ");
INSERT INTO rro_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Auba Robe ehore Banaba mai Saulo ohi euhunakia teriri teao Seleukia ai, weia haeamona aunohiai tebeau ahi teao Kupuro kereibuanai. ");
INSERT INTO rro_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Salami ai tekara'au weia Tirama ena 'abi Iuda haukia ekia marea aokiai teiroro aina Ioane Mareko abomo weia herekiai ia ebarainakia. ");
INSERT INTO rro_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Kereibua maikoinai tekabanai teao Pafo ai hanona hau ha tetabu ahina, Iuda haukia ekia mea hauna mai mahabanai bai'oina hauna ha atana Bariesu. ");
INSERT INTO rro_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ia hanona kereibua weiana ena Kabana hauna Seregio Paulo aobero hauna ena hau. Kabana hauna ehore Banaba mai Saulo eaparinakia wairanai, pokina ena nuatae Tirama ena 'abi aiana keona. ");
INSERT INTO rro_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","'A Bariesu atana ibaruana Eluma (Helene maeanai anina hanona mea hauna) ia terarua ekaiabunakia Kabana hauna ekia 'abi paunai a'i mea'ikakauma. ");
INSERT INTO rro_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","'A Saulo, atana ibaruana hanona Paulo, Auba Robe ai ebonu 'auna, mea hau weiana eiha 'ini'inina, ");
INSERT INTO rro_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ehina bena etibaha, “Oi Tiaporo nahuna! Oi hanona taba namokia ikoikiai nu'oatanakia aomu bai'oi mai ki'a akakiai ebonu. Obiapaka ena 'abi tohakia ikoinai nua'i banai bai'oi ai nubaonakia. ");
INSERT INTO rro_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Bariu Obiapaka imana hanona oi ahamuai kehore 'auna aonai mahamu kateki'a, rani papana beraura eana a'i koihana.” Beronai Eluma eonobaina 'abu mai wapura mahana tekaiabuna, maearima enoinakia ibaka'ana hauna ha pehaea imanai pe'ebe pebaka'ana. ");
INSERT INTO rro_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Kabana hauna hoa weiana erama eihana raninai ea'ikakauma, pokina Obiapaka ena ba'iobi 'abikiai eta'uta'u huri. ");
INSERT INTO rro_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paulo mai te'abana haukia kipokia Pafo ai tebeau ahi teao Perega, Pamfulia hanonai tekara'au, weia Ioane Mareko ia ehabonakia emue Ierusalema eao. ");
INSERT INTO rro_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Paulo mai Banaba ohi Perega ai temikiri teao Pisidia hanona Antioka ai tekara'au. Weia beraura robe aonai teao Iuda haukia ekia mareai tekatoto temiati. ");
INSERT INTO rro_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Mose ena rauhubu pukana mai mahabanai haukia tererenakia pukakia tetuabinakia murinai marea poki haukia tebaiuhu eao herekiai tetibaha, “Uaho'abamai e, emai nuatae emi batabura 'abina ha re'a maearima neiakia herekiai patohinanakia.” ");
INSERT INTO rro_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Paulo emikiri imanai etori abunakia etibaha, “Isaraela haumi mai rama haeai Tirama ṯokuti aina haumi e, aia'u tomona. ");
INSERT INTO rro_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Isaraela hauka eka Tirama ehore kupuka 'aba'abaka etina'anakia abomo haukia ebabo'onakia ekia miaho Aigupito aonai, haeamona ia ena hiabu apa'uanai Aigupito ai ebakarahinakia. ");
INSERT INTO rro_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ihau bariabui 'abana hano'akunai herekiai ebapahihi. ");
INSERT INTO rro_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ia ehore Kanana hanopakakia 'abaihau hamomo ebapururunakia. Hanokia ewatenakia Isaraela hanokiai teao ihau hinabu bani reana imabui 'abana aonai. ");
INSERT INTO rro_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Taba neiakia murikiai bakai haukia ebamikirinakia kate'uainakia emaimo mahabanai hauna Samuela ena rani ai. ");
INSERT INTO rro_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","“'A ia tehore obia 'arana ha tenuatae aina hanona Tirama ehore Beniamina itubuna hauna ha, Kisa nahuna Saulo ebenakia, ihau bariabui aonai eobia. ");
INSERT INTO rro_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Tirama Saulo ea'i obona murinai Davida ea'i taeana ekia obia 'aranai eao. Ia pouna ehinana etibaha, ‘Iese nahuna Davida abatabu ahina anuatae aina, ia hanona e'u nuatae akakia ikoikiai kebabainakia.’ ");
INSERT INTO rro_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Tirama ena 'abi'uai ihobonai Davida ena rama haunai Isaraela maearimakia kebamaurinakia hauna ebamikirina, weiana hanona Iesu. ");
INSERT INTO rro_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","“Iesu ena aka a'i ea'i rama bahana aonai Ioane hanona aba eiroro 'uai Isaraela maearimakia ikoikiai ekia ki'ai kateraona kabe mai kate'uere robe. ");
INSERT INTO rro_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ioane ena aka aba kepua aonai maearima ehina benakia etibaha, ‘Wai turaonana au hanona tai? Au hanona Keriso aha'i. Ia hanona muri'uai nimai, au hana a'i anamo ena tamaka warokia a'i karubunakia.’ ");
INSERT INTO rro_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Uaho'aba'u Aberahamo ramana haukia nahukia abomo wai rama haeai Tirama ṯokuti aina haumi e, Tirama ehore bamauri 'abina neiana aba euhuna emai aika herekai. ");
INSERT INTO rro_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ierusalema ai ṯemiaho haukia mai te'uai ainakia haukia a'i te'iobina Iesu hanona bamauri hauna. Abomo beraura robe ai rani ikoikiai tetuabina 'abina weiana mahabanai haukia tererena hauna obona a'i teobo, Iesu aka ki'a haunai tebaona, weiana hanona mahabanai haukia ekia 'abi aba etohana. ");
INSERT INTO rro_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Iesu kateahu 'arina ena pokina ha a'i tetabu ahina, weiana Pilato tenoina 'ari 'ekanai kehorotina. ");
INSERT INTO rro_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ia 'abina puka robenai terere 'uainakia ihobonai akakia ikoikiai tebaorenakia murinai, ia e'ari hauanina matiu ibiri ropo 'ubinai tea'i obona 'ariahanai tehorena. ");
INSERT INTO rro_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ia Tirama ehore Iesu 'ariai ebamikiri muena. ");
INSERT INTO rro_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Weiana murinai, Iesu hanona rani bo'ona kipokia teka'a Galilea ai eaomo Ierusalemai haukia herekiai ewaira tina. Bariu maearima weiakia hanona ia mahakiai teihana hauna pouna tehinana Isaraela haukia wairakiai. ");
INSERT INTO rro_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Ua buonai ai abomo pou namona weiana Tirama 'aba'abaka herekiai e'abi'uai aina hauna ṯamaiaina wai heremi. ");
INSERT INTO rro_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Tirama hanona Iesu 'ariai ebamikirina weianai ena 'abi'uai 'aba'abakia herekiai ebatohana. Salamo ibaruana aonai abomo Iesu pouna ehinana etibaha, ‘Oi hanona au Naha'u. Bariu rani neianai au hanona oi Hamamu.’ ");
INSERT INTO rro_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Tirama Iesu 'ariai ebamikirina, ba 'ariahana aonai a'i keburu buru. Weiana hanona ena 'abi puka robenai hauna ebatohana, ‘Au kahore Davida herenai a'abi'uai aina weiana erobe mai etohana hauna wai kabenimi.’ ");
INSERT INTO rro_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Salamo haeai aonai abomo ṉa e'abi aiho, ‘Emu robe hauna hanona a'i kohabo 'abaeana a'i keburu buru.’ ");
INSERT INTO rro_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Davida ena mauriai hanona Tirama ena nuatae akakia ebabai, murinai e'ari kupuna 'aba'abana herekiai tehorena, haeamona hauanina 'uriai eburu buru. ");
INSERT INTO rro_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ia Tirama 'ariai ebamikiri muena hauna hanona 'uriai a'i eburu buru. ");
INSERT INTO rro_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Ua buonai uaho'aba'u e, ṯanuatae kato'iobina Iesu paunai ki'a ihina haona pouna hanona wai heremiai ṯairoro aina. ");
INSERT INTO rro_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Tirama ehore Iesu tia'ikakaumana haukia hanona bero ebenakia, pokina Mose ena rauhubuai 'ekakia ikoikiai wai bero a'i katotabu ahina. ");
INSERT INTO rro_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ua buonai kato'ima 'ima harainimi mahabanai haukia 'abi tabana tehinana hauna heremiai a'i merama. Ṉa te'abi aiho, ");
INSERT INTO rro_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘'Uahi'uahi haumi, tomota'uta'u huri ba tomo'ari baihana. Au emi raniai taba ha kababaina, hau ha pekikipa haraina iamo a'i kato a'ikakaumana.’” ");
INSERT INTO rro_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Paulo mai Banaba marea ai tikarahi aonai, maearima ia tenoinakia pou neiakia waira rani robenai katehina mue herekiai. ");
INSERT INTO rro_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","To'u epua murinai, Iuda maearimakia mai rama haeai maearimakia Tirama tekuti aina ba Iuda haukia baiatakiai tetoto haukia bo'okia Paulo mai Banaba murikiai te'au. Ia terarua maearima weiakia tebahi ahinakia Tirama ena aoko'o hoana aonai katemiaho. ");
INSERT INTO rro_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Rani robena ibaruanai aiarai ṯemiaho haukia ikoinai temai tebararona Tirama ena 'abi aiana kateona. ");
INSERT INTO rro_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","'A Iuda haukia hanona to'u haukia teihanakia raninai tewamuru ki'a, Paulo 'abi ehinanakia haukia tea'i ki'anakia haeamona 'abi ki'a obokia tehina ia herenai. ");
INSERT INTO rro_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ia Paulo mai Banaba te'abi tabura tetibaha, “Tirama ena 'abi hanona wai pato'iobi 'uaina, ia wai hanona tubaki'ana haeamona kipomi ki'a 'ekanai tuhorotinimi mauri banaibanai a'i ṯonuatae aina, ua buonai ai aba rama haeai haukia herekia ṯaeao. ");
INSERT INTO rro_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Obiapaka ṉa ehinabe aihonamai, ‘Au oi nahorotini'o rama haeai haukia ibaeakia ai koao, abomo bamauri koaoaina hanopaka puana.’” ");
INSERT INTO rro_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Rama haeai haukia aia weiana teona raninai aokia enamo ba Obiapaka ena 'abi tebanamona. Weiakia Tirama etina'anakia mauri banaibanai katea'ina haukia hanona tea'ikakauma. ");
INSERT INTO rro_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ba Obiapaka ena 'abi hanona hano weiana maikoina aonai teuhu otaraina. ");
INSERT INTO rro_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ia Iuda haukia tehore obia babi'ekia weiakia Tirama ṯekuti aina haukia mai aiara haukia apa'uakia aokia teani tekai ta'a ta'anakia, Paulo mai Banaba ohi te'oatanakia haeamona hano weiana aonai teu'u ahinakia. ");
INSERT INTO rro_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Paulo mai Banaba hanona baki'a aiarana weiana herenai aekia apurorokia teahuahu obonakia ba teao Ikonio. ");
INSERT INTO rro_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","A'ikakauma haukia weiakia Antioka ai ṯemiaho haukia aokiai enamo mai Auba Robe ai tebonu. ");
INSERT INTO rro_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Antiokai tebabaina ihobonai Ikonio ai abomo Paulo mai Banaba ohi Iuda haukia ekia marea aonai tekatoto teiroro, Auba Robe ena baraibarai ai weiana ekia iroro harai buonai Iuda haukia mai rama haeai haukia bo'ona 'akina tea'ikakauma. ");
INSERT INTO rro_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","'A Iuda haukia baika a'i tea'ikakauma haukia tehore rama haeai haukia haiakia tekui tea'ikakauma haukia kate'oatanakia. ");
INSERT INTO rro_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Terarua rani homa'ana weia temiaho mai taburakia Obiapaka pouna tehinana abomo hoa mai bata'uta'u huri akakia tebabainakia, weianai Obiapaka hanona ena aoko'o hoana 'abina teiroro aina hauna ebatohana. ");
INSERT INTO rro_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Weiana aiara apa'uana aonai maearima kipokia tewatenakia, baika teao Iuda haukia herekia harua teao iuhubeau haukia herekia. ");
INSERT INTO rro_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","'A rama haeai haukia mai Iuda haukia ekia aiara ṯe'uai aina haukia kipokia teroba ahu, iuhubeau haukia rua katebatae ainakia abomo piharai kateahu 'arinakia. ");
INSERT INTO rro_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Terarua pou teona raninai te'uru Lukaonia hanona aonai Lustera mai Derebe aiarakia herekia teao. ");
INSERT INTO rro_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Weia pou namona teiroro aina. ");
INSERT INTO rro_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Lustera aiaranai 'ome hauna ha, ia erama hanona a'i eka'a uahomana mo emiaho. ");
INSERT INTO rro_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Hau weiana Paulo e'abi'abi aiana ebahuaina. Paulo hanona hau weiana eiha 'ini'inina ba ebabataina hau weiana ena a'ikakauma Tirama herenai hauna kehore aba kebamaurina. ");
INSERT INTO rro_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","E'abi aota etibaha, “Momikiri mokoroti!” Hau weiana beronai erobo taea ekoroti haeamona ekaoao kaoao. ");
INSERT INTO rro_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Mako hoa weiana Paulo ebabaina hauna teihana raninai Lukaonia maeanai teio tetibaha, “Tirama hanona aba maearimai teao teriri temai herekai.” ");
INSERT INTO rro_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Temikiri Banaba teaparina Deo, weiana ekia tirama ha atana, Paulo teaparina Hereme, weiana abomo ekia tirama ha atana teaparina pokina ia hanona 'abi ihinana hauna. ");
INSERT INTO rro_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Deo ena marea hanona aiara apa'uana pa'abina 'akona wairanai, ena robe haukia poromakau koa baika mai taitaikia teaoainakia pa'abi 'akonai, weia maearima kipokia kuti akakia katebabainakia iuhubeau haukia herekiai. ");
INSERT INTO rro_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Paulo Banaba ohi pou weiana teona raninai ekia habuni tetapanakia tebeau toto to'u haukia baiatakiai teio tetibaha, ");
INSERT INTO rro_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Emai hau e, taba buonai hoa neiana tubabainakia? Ai hanona maearima 'abaeamai wai ihobomi. Ai tamai neia pou namona ṯahinana hanona wai kuti akakia ki'a obokia neiakia herekiai katokapare, mauri Tiramana weiana kupa hanopaka mai akupaka ebabainakia abomo aokia tabakia ikoikiai ebabainakia hauna kato a'ikakaumana. ");
INSERT INTO rro_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Tirama hanona 'uaina raninai hanopaka haeai haeai haukia ehabonakia kipokia ekia nuatae taearakiai katemauri. ");
INSERT INTO rro_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Iamo kipona ibawaira tinana, aka namokia ia ebabai abara kupai nibatibona heremiai, hano anikia ekia rani tohakiai nibenimi, nuami niba kironakia mai aomi niba aonamona.” ");
INSERT INTO rro_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Terarua ua te'abi aiho iamo mai aro'arikiai to'u haukia kuti akana katebabaina haukia tebamuenakia. ");
INSERT INTO rro_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ia Iuda haukia baika ua'a Pisidia Antioka mai Ikonioai temai haukia tehore to'u haukia aokia teani epua temikiri Paulo piharai teahuna teberina teaoaina aiara apa'uana parabuna kapenai, teraonana ia hanona aba e'ari. ");
INSERT INTO rro_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ia a'ikakauma haukia tehore herena tekori kaiarona raninai, Paulo emikiri ba eao aiara apa'uana aonai ekatoto mue. Erani hanona Banaba ohi temikiri teao Derebe. ");
INSERT INTO rro_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Paulo mai Banaba weia Derebeai pou namona teiroro aina ba maearima bo'ona temaiainakia Iesu i'abana haukiai teao. Weiana murinai temue teao Lustera Ikonio mai Pisidia Antioka. ");
INSERT INTO rro_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","'Eka weiakiai ia tehore Iesu i'abana haukia teba taburanakia abomo aokia tebakironakia a'ikakauma tohanai katemiaho, tehina benakia tetibaha, “Aika hanona atetua bo'okia ṉahomakia aokiai kahatoto 'uai ba Tirama ena obia aiaranai kahakatoto.” ");
INSERT INTO rro_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Tirama ena marea ha ha aokiai Paulo mai Banaba hanona 'uai haukia tea'i taeanakia mai anirobekiai tebahuba'ari ba tia'ikakaumana Obiapakana imanai teutanakia. ");
INSERT INTO rro_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Murinai terarua temikiri Pisidia hanonai tekabanai temai Pamfulia hanonai tekara'au. ");
INSERT INTO rro_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ba weia Peregai pou namona teiroro aina murinai teriri teao Atalia aiaranai. ");
INSERT INTO rro_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Weia terarua aunohiai tehe'au tebeau temue Antioka, 'uainai Antioka neianai tea'i taeanakia Tirama ena aoko'o hoana aonai kateaka, ba aka neiana hauna bariu aba tebaorena. ");
INSERT INTO rro_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Antiokai tekara'au raninai terarua tehore a'ikakauma haukia teba to'unakia, Tirama taba ebabaina ia imakiai hauna mai rama haeai haukia ekia a'ikakauma taearana ekaikauna hauna wairakiai pouna tehinana. ");
INSERT INTO rro_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Terarua rani homa'ana weia a'ikakauma haukia kipokia temiaho. ");
INSERT INTO rro_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Iuda haukia tia'ikakauma haukia baika Iudeai temai Antiokai a'ikakauma haukia teba'iobinakia tetibaha, “Mose ena rauhubu ihobonai a'i katetarenimi raninai wai hanona bamauri a'i katoa'ina.” ");
INSERT INTO rro_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","'Abi weiana paunai Paulo mai Banaba ohi maearima weiakia kipokia tebaihara tae eaomo tebaiara ki'a, ua buonai Tirama ena marea haukia tehore Paulo mai Banaba ohi tea'i taeanakia a'ikakauma haukia baika kipokia kateao Ierusalema, weia iuhubeau haukia mai 'uai haukia herekiai 'abi weiana katebakai bakaiaina. ");
INSERT INTO rro_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Tirama ena marea haukia tehore ia teuhunakia, weiana Foenikia mai Samaria hanokiai tekabanai aonai, rama haeai haukia ekia mauri aea tebaibeni aiho hauna pouna tekikipana. Pou neiana teona hanona a'ikakauma haukia ikoikiai teaonamo ki'a. ");
INSERT INTO rro_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ia Ierusalemai tekara'au raninai Tirama ena marea haukia, iuhubeau haukia, mai 'uai haukia tehore ia tea'i taeanakia, ba Paulo mai Banaba ohi Tirama taba ebabaina ia imakiai hauna ikoikiai wairakiai pouna tehinana. ");
INSERT INTO rro_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","A'ikakauma haukia baika weiakia Parisea itubunai tekarahi haukia temikiri te'abi tetibaha, “Rama haeai haukia kahatarenakia abomo kahahina benakia Mose ena rauhubu hanona kate'ima haraina hanona mauri banaibanai katea'ina.” ");
INSERT INTO rro_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Weiana iuhubeau haukia mai 'uai haukia kipokia teto'u atetua 'abina weiana teroba ahuaina. ");
INSERT INTO rro_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Rani homa'ana tebaihara tae murinai Pereto emikiri e'abi etibaha, “Uaho'aba'u e, aba to'iobina Tirama ehore wai baiatamiai au etina'ana'u pina'uai pou namona kahinana rama haeai haukia kateona katea'ikakauma. ");
INSERT INTO rro_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Maearima aokia e'iobinakia Tiramana ehore aika herekai ebabaina ihobonai rama haeai haukia abomo Auba Robe ebenakia, hoa weianai Tirama ia ea'i taeanakia hauna ebatohana. ");
INSERT INTO rro_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ia mai aika kipokia baiataka a'i ebahaeaina, Tirama ehore ekia a'ikakauma paunai aokia ebamaha mahanakia ia wairanai. ");
INSERT INTO rro_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ia aehoma buonai Tirama tuhobona 'aba'abaka 'ao aika Mose ena rauhubu ika'aina pumana habuana a'i etainaka hauna a'ikakauma haukia ahakiai tuhore 'auna? ");
INSERT INTO rro_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Aika naha'ikakauma, ia bamauri tia'ina ihobonai, Obiapaka Iesu ena aoko'o hoana paunai bamauri kaha'ina.” ");
INSERT INTO rro_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","To'u haukia ikoikiai 'uru'urukia aha'i, ia Banaba mai Paulo ohi imakiai Tirama hoa mai bata'uta'u huri akakia rama haeai haukia herekiai ebabainakia haukia poukia tehinanakia hanona aiakia tiona. ");
INSERT INTO rro_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ia ekia 'abi eore murinai Obiapaka hatina Iakobo emikiri e'abi etibaha, “Uaho'aba'u e, aia'u tomona. ");
INSERT INTO rro_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simona aba ehinabe harainaka Tirama ehore rama haeai haukia eraonanakia, kori'uaina ia baiatakiai maearima aea ea'i taea aihonakia ia 'euna. ");
INSERT INTO rro_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Babai neiana hanona mahabanai haukia ekia 'abi kipokia teihobo, ṉa terere aihona, ");
INSERT INTO rro_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Neiana murinai au kamue kamai, Davida ena obia aiarana e'eho hauna kabakori muena. Te'iti'iti haukia kabamahamaha muenakia. ");
INSERT INTO rro_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Weiana maearima harina temauri haukia ikoinai mai rama haeai haukia weiakia ata'uai aparinakia au 'eu'u ai kateao haukia ikoikiai hanona au Obiapaka katetabuna'u. ");
INSERT INTO rro_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Obiapaka ua e'abi aiho, 'abi neiana hanona aba ua'i baha eba'iobi aina.’ ");
INSERT INTO rro_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Ua buonai e'u raona hanona rama haeai haukia weiakia Tirama herena timai haukia ekia taeara a'i kahabapahihi ki'a bahana. ");
INSERT INTO rro_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Namona hanona marereai kahahina benakia, kaiba'uku teberuberu benakia tabakia Tirama wairanai te'opu haukia a'i kateani, a'i katenabau ki'a, mai mahi 'akokia tebato'o 'arinakia haukia a'i kateani, abomo aruarukia a'i kateinu. ");
INSERT INTO rro_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Pokina 'uaina raninai emai mo bariu Mose ena rauhubu weiakia hanona beraura robe ikoikiai aokiai tetuabina marea ha ha aokiai abomo pouna teiroro aina aiara ikoikiai aokiai.” ");
INSERT INTO rro_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ba iuhubeau haukia mai 'uai haukia Tirama ena marea haukia ikoikiai kipokia teraonana weia baiatakiai maearima baika katea'i taeanakia Paulo mai Banaba kate 'abanakia Antioka kateao, ba tea'i taeanakia haukia neiakia, Iuda atana teaparina Barasaba mai Sila, terarua hanona maearima i'uaiaikia haukia uaho'abakia baiatakiai. ");
INSERT INTO rro_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Marere ṉa terere aihona ka'a haukia tebenakia, “Ai iuhubeau mai 'uai haumai, ai uaho'abami, emai banamo 'abina niwahi wai uaho'abamai rama haeai ai torama Antiokai Suriai mai Kilikiai ṯomiaho haumi heremi. ");
INSERT INTO rro_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ai poumi aba taona 'abamai baika neia tewahi, ekia 'abiai aomi tiba haiaranakia abomo aomi tibaro'arinakia, ia ai hanona 'abi uahomana a'i tabenakia. ");
INSERT INTO rro_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ua buonai ai tato'una emai raona tabahamona hau baika kata'i taeanakia katauhunakia eka raona'au haukia Banaba mai Paulo kipokia katewahi. ");
INSERT INTO rro_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Neiakia Banaba mai Paulo terarua hanona ekia mauri a'i tiraonanakia aika eka Obiapaka Iesu Keriso atanai. ");
INSERT INTO rro_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Iuda mai Sila ṯauhunakia marere tarerena hauna ia pinakiai katehinana abomo katebatohana. ");
INSERT INTO rro_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Auba Robe mai ai kipokia ṉa taraona aihona, ai puma haeai a'i katabenimi rauhubu neiakia ahakiai. ");
INSERT INTO rro_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Kaiba'uku wairanai tehoroti anianikia a'i katoani, mahi mai aruarukia a'i katoani, mahi 'akokia tebato'o 'arinakia haukia a'i katoani, abomo nabau akakia a'i katobabai. Wai taba neiakia a'i katobabai hanona emi aka kebero. Tarere nonoa. Haparua.” ");
INSERT INTO rro_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Marea haukia tehore hau naiakia teuhunakia, ia teriri teao Antiokai, a'ikakauma haukia tebato'unakia ba marere tebenakia. ");
INSERT INTO rro_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Marere tetuabi aonai batabura 'abikia aiakia teo'o hanona aokia enamo wairai. ");
INSERT INTO rro_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Iuda mai Sila hanona mahabanai haukia terarua 'abi namokia tehina a'ikakauma haukia aokia tebakironakia mai teba taburanakia. ");
INSERT INTO rro_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ia rani baika weia temiaho murinai, a'ikakauma haukia ia tebaparuanakia temue teao Ierusalema ia teuhunakia haukia herekia. ");
INSERT INTO rro_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","(Ia Sila enuatae buonai emiaho.) ");
INSERT INTO rro_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paulo mai Banaba hanona Antiokai temiaho, ia mai maearima bo'okia kipokia Obiapaka ena 'abi teba'iobi aina abomo pou namona teiroro aina. ");
INSERT INTO rro_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Wapu baika teore murikiai Paulo Banaba ehina bena etibaha, “Aika hamamue hamaeao aiara weiakia Obiapaka pouna hairoro aina haukia aokiai uaho'abaka weia aea tibabai aiho hanona kahaihanakia.” ");
INSERT INTO rro_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Ba Banaba ena nuatae hanona Ioane weiana tiaparina Mareko hauna kipokia kateao haeamo. ");
INSERT INTO rro_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ia Paulo ena raona, ia kipokia kateao hanona a'i enamo pokina ia Pamfuliai weia hanona eubo ekia akai a'i e'abanakia. ");
INSERT INTO rro_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Weiana buonai terarua tebaiara baiatakia epa'a. Banaba ehore Mareko ea'ina aunohiai tehe'au Kupuro teao. ");
INSERT INTO rro_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ia Paulo ehore Sila enuatae aina kateka'a aonai uaho'abakia tehore Obiapaka ena aoko'o hoanai tebanamonakia. ");
INSERT INTO rro_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ia terarua teao Suria mai Kilikia hanokiai tekabanai, Tirama ena marea maearimakia weia haukia teba taburanakia. ");
INSERT INTO rro_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulo eao Derebe ba haeamona eao Lustera ai ekara'au, a'ikakauma hauna ha weia nemiaho ia atana hanona Timoteo, hinana hanona Iuda babi'ena Iesu nia'ikakaumana, ia hamana hanona Helene hauna. ");
INSERT INTO rro_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","A'ikakauma haukia weia Lustera mai Ikonio ai ṯemiaho haukia Timoteo ena namo pouna tehinana. ");
INSERT INTO rro_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulo enuatae Timoteo ia kebaka'ana kipokia kateao, ba etarena pokina Iuda haukia weia ṯemiaho haeamona te'iobina ia hamana hanona Helene hauna. ");
INSERT INTO rro_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Aiara ha ha aokiai tekabanai aonai iuhubeau haukia mai 'uai haukia Ierusalemai ṯemiaho haukia rauhubu weiakia tebatohanakia haukia ia terarua tehore tehinanakia maearima kateka'aina. ");
INSERT INTO rro_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ua buonai Tirama ena marea haukia ekia a'ikakauma hanona etabura abomo maearima ekia bo'o eapa'ua hao apa'ua hao beraura ha ha aokiai. ");
INSERT INTO rro_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Paulo mai 'abana kipokia teao Furugia mai Galatia hanokia aokiai tekabanai pokina Auba Robe ehore ekaiabunakia Asia hanonai Tirama ena 'abi a'i kateiroro aina. ");
INSERT INTO rro_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Teao Musia hano hoanai tekara'au aonai teraonana Batunia hanona kateao, ia Iesu Aubana ebamuenakia. ");
INSERT INTO rro_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Weiana buonai Musia aiaranai tekabanai teriri teao Toroa aiarana. ");
INSERT INTO rro_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Rabi weianai Paulo emahabanai, ena mahabanai aonai Makedonia hauna ha eihana ia wairanai ekoroti enoina etibaha, “Komai Makedoniai ai kobarainamai.” ");
INSERT INTO rro_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Paulo ena mahabanai weiana murinai ai tanoanoa taeara tatabu kataeao Makedonia, pokina ai ta'iobina Tirama hanona eaparinamai pou namona weia katairoro aina. ");
INSERT INTO rro_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Weia Toroai hanona aunohiai taehe'au tabeau berona taeao Samotrake. Haeamona erani hanona tabeau taeao Neapoliai takara'au. ");
INSERT INTO rro_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","'Eka weiana tahabona taka'a taeao aiara apa'uana Pilipo, weiana hanona aiara kori'uaina Makedonia hanona aonai Roma ena iha'ini ba'anai emiaho. Ba wapu baika weia tamiaho. ");
INSERT INTO rro_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Beraura Robenai aiara pa'abinai takarahi taeao ate haianai taraonana bahuba'ari 'ekana ha weia. 'Eka weianai tamiati babi'e baika weia teto'u haukia kipokia ta'abi'abi. ");
INSERT INTO rro_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Weiakia aiamai teona babi'ekia baiatakiai ha atana Ludia ena aiara hanona Tuatira. Ia hanona habuni birokia nikawa kawainakia. Ia abomo Tirama nekuti aina babi'ena ha. Obiapaka ehore aona ebaeana ba Paulo ena 'abi ea'i taeana. ");
INSERT INTO rro_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Weia ia mai ena itu haukia ikoikiai taba'uere robenakia murinai enoinamai kataeao ena itu ba e'abi etibaha, “Aomiai tua'i taeana'u au Obiapaka ia'ikakaumana babi'e'u ha raninai patomai e'u ituai weia patomiaho.” Ena bahiahi 'abina eaoainamai ena itu. ");
INSERT INTO rro_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Rani ha bahuba'ari 'ekana taeao aonai ta'ara'i uahona ha aonai auba ki'a obona nemiaho uahona kipokia tabaitabu ahi. Uaho weiana hanona taba wairai katerama haukia ihina poukiai ena poki hauna ena kepu bo'okia ebabainakia. ");
INSERT INTO rro_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Uaho neiana Paulo mai ai murimaiai eka'a eio etibaha. “Hau neiakia hanona 'ubi 'aki'akinai nemiaho Tiramana ena iuhubeau haukia, bamauri taearana ṯeiroro aina heremiai.” ");
INSERT INTO rro_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Rani bo'okia aokiai ia ua ebabai aiho. Ba Paulo haiana ebapo'ona buonai ekori kabe auba ki'a obona ebatana etibaha, “Iesu Keriso atanai nahina beni'o, uaho naiana aonai mokarahi!” Beronai auba ki'a obona uaho ehabona ekarahi. ");
INSERT INTO rro_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Uaho ena poki hauna e'iobina ena kepu tabu ahi taearana aba epua, weiana Paulo mai Sila tea'inakia teberinakia teaoainakia maearima ekia to'u 'ekana Roma haukia apa'uakia herekiai. ");
INSERT INTO rro_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Hau apa'uakia wairakiai teba korotinakia ba te'abi tetibaha, “Maearima rua neiakia hanona Iuda haukia, eka aiara aonai ripuripu tibabaina. ");
INSERT INTO rro_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Abomo hoahoa tiba'iobinaka haukia hanona aika Roma hauka eka rauhubu tainai a'i kaha'i taeanakia mai a'i kahaka'a ainakia haukia.” ");
INSERT INTO rro_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","To'u haukia temikiri Paulo mai Sila herekiai 'abi ki'a obokia tehinanakia, ba bakai te'uai aina haukia 'abi tebaibeni terarua ekia habuni katetapanakia mai kate'atinakia. ");
INSERT INTO rro_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Te'ati ki'anakia epua murinai teaoainakia wapura itunai tetori totonakia, wapura ne'imanakia hauna tehina bena kekaiabu 'ini harainakia. ");
INSERT INTO rro_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ua tehinabe aihona buonai wapura 'ima hauna terarua eaoainakia ikaihuri aona 'akinai hauna aonai ehorotinakia, aekia matiu baiatakiai ebahutanakia ebiri 'ini harainakia. ");
INSERT INTO rro_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Rabi wapuka'a ore'akuai Paulo mai Sila tebahuba'ari mai ekia huiai Tirama tebanamona, wapura haukia hanona ia aiakia tebahuaina. ");
INSERT INTO rro_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Beronai kanokau rarina eka'a wapura ituna maikoina ebaibiuna, pa'abi ikoikiai tekaikau mai wapura haukia imakia aekia tabirikia ikoinai teta'i. ");
INSERT INTO rro_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Wapura ituna ne'imana hauna paruana eno'a, pa'abi ikoikiai tekaikau eihanakia raninai emikiri ena kareba eberi 'auna kipona keahu 'arina pokina ia eraonana wapura haukia hanona aba tebeau 'akauma. ");
INSERT INTO rro_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","'A Paulo eio aota etibaha, “Kipomu a'i moahu 'arini'o, ai ikoimaiai neiamai ṯamiaho.” ");
INSERT INTO rro_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Wapura ituna ne'imana hauna eapari ramepa katemaiaina, ebeau toto eao eta'u buonai mai 'ururu 'ururuna Paulo mai Sila wairakiai ekaipehu. ");
INSERT INTO rro_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ba eba karahinakia eaoainakia mahanai ebakainakia etibaha, “Hau apa'uami e, taba kababaina hanona bamauri katabu ahina?” ");
INSERT INTO rro_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Terarua tehina bena tetibaha, “Obiapaka Iesu Keriso koa'ikakaumana hanona bamauri koa'ina oi mai emu itu haukia ikoikiai.” ");
INSERT INTO rro_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ba terarua Obiapaka ena 'abi teiroro aina ia mai ena itu haukia ikoikiai wairakiai. ");
INSERT INTO rro_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Rabi weiana aonai terarua eaoainakia, haukia tebamani'anakia 'ekakia eututu harainakia, ba beronai Paulo mai Sila tehore ia mai ena itu haukia ikoikia teba'uere robenakia. ");
INSERT INTO rro_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Wapura i'ima hauna terarua eaoainakia ena ituai ero'onakia, ba ia mai ena itu haukia ikoikiai teaonamo pokina Tirama tia'ikakaumana paunai. ");
INSERT INTO rro_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Erani raurani aonai bakai te'uai aina haukia ekia 'abi tebaibeni habuni haukia teuhunakia teao wapura 'ima hauna herena tetibaha, “Hau neiakia kobakarahinakia kateka'a.” ");
INSERT INTO rro_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Wapura i'ima hauna Paulo ehina bena etibaha, “Bakai ṯe'uai aina haukia 'abi tebaibeni, oi mai Sila ohi kaba karahinimi katoka'a, ua buonai tomokarahi mai baibuami tomoao.” ");
INSERT INTO rro_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ia Paulo bakai ṯe'uai aina haukia ekia habuni haukia ehina benakia etibaha, “Ai hanona Roma maearimamai, emai beho aha'i bakai 'ekanai a'i teba korotinamai ia maearima wairakiai teahunamai haeamona wapura itunai tekaiabu 'abaeanamai. Ba bariu hanona bunianai kateba karahinamai, u? A'i ketai 'apuana, ia kipokia katemai kateba karahinamai.” ");
INSERT INTO rro_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Habuni haukia temue teao bakai ṯe'uai aina haukia haiakiai te'abi ia terarua hanona Roma maearimakia, 'abi neiana teona raninai bakai ṯe'uai aina haukia teta'u wairai. ");
INSERT INTO rro_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Bakai ṯe'uai aina haukia temikiri teao terarua haiakiai te'abi 'abi harai a'i teme'opuere, ba teba karahinakia, tenoinakia aiara weiana katehabona. ");
INSERT INTO rro_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Paulo mai Sila wapura itunai tekarahi teao Ludia ena itu weia a'ikakauma haukia baika kipokia tebaitabu ahi, batabura 'abikiai tehina benakia ba teka'a. ");
INSERT INTO rro_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paulo mai Sila ohi teao Amfipoli mai Apolonia hanokiai tekabanai teao Tesalonika weia hanona Iuda haukia ekia marea ha. ");
INSERT INTO rro_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Paulo ena hoa hoa tainai eao marea aonai etoto. Weia beraura robe aihau aokiai maearima kipokia teroba ahu Puka Robenai terere 'abikia tohakiai e'abi'abi, ");
INSERT INTO rro_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ehina hina harainakia, 'abikia ebawaira tina harainakia Keriso hanona kehau haiara mai 'ariai kemikiri mue, etibaha, “Iesu neiana au pouna nahinana wai heremiai hauna hanona Keriso.” ");
INSERT INTO rro_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Iuda haukia baika aokia teba kabanainakia Paulo mai Sila kipokia tebahamomo, Helene maearimakia Tirama timariki aina haukia bo'okia abomo kipokia tebahamomo baiatakiai hanona obia babi'ekia bo'okia. ");
INSERT INTO rro_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ia Iuda haukia baika tewamuru buonai aru 'abaea haukia ekia hoa teki'a haukia kawakawa 'ekanai tebararonakia tebato'unakia iripu rarina aiara apa'uana aonai teba ramana. Hau ha atana Iason ena itu teao Paulo mai Sila katetabunakia kateba karahinakia maearima wairakiai. ");
INSERT INTO rro_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ia a'i tetabu ahinakia buonai Iason mai a'ikakauma haukia baika itu weianai teberi ahinakia temaiainakia aiara apa'uana tipoki aina haukia wairakia teio tetibaha, “Hau baika hanopaka maikoinai ripuripu tibabai haukia bariu temai eka aiara apa'uana aonai. ");
INSERT INTO rro_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ba Iason hanona ea'i taeanakia ena ituai ebatotonakia. Hau weiakia hanona Kaisa ena rauhubu tikabenakia, te'abi tetibaha, Obia 'arana haeai ha nemiaho. Ia atana hanona Iesu.” ");
INSERT INTO rro_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","'Abi neiana teona raninai maearima to'una mai aiara apa'uana tipoki aina haukia kipokia 'uru rarina tebabuana. ");
INSERT INTO rro_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Aiara apa'uana tipoki aina haukia tehore Iason mai 'abana kipokia tehina benakia moniai bakai arana tehorena ba tehabonakia kateka'a. ");
INSERT INTO rro_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Rabi weiana aonai a'ikakauma haukia tehore Paulo mai Sila teuhunakia Berea teao. Weia tekara'au raninai berokiai Iuda haukia ekia marea teao. ");
INSERT INTO rro_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Iuda haukia weiakia Bereai ṯemiaho haukia hanona mai ekia aia o'o ba Tesalonika maearimakia, aokia tohanai pou namona teona ba rani ikoinai Puka Robena 'abikia temarere ainakia kate'iobina Paulo ehina haukia hanona tohakia. ");
INSERT INTO rro_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ua buonai bo'okia tea'ikakauma, Helene obia babi'ekia bo'okia mai Helene haukia bo'okia abomo tea'ikakauma. ");
INSERT INTO rro_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ia Iuda haukia Tesalonikai ṯemiaho haukia Paulo Tirama ena 'abi Berea aonai neiroro aina pouna teona raninai temai weia mako tebahi ahinakia tebaripu ripu. ");
INSERT INTO rro_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Beronai mo a'ikakauma haukia tehore Paulo teuhuna poe taina eao. Ia Sila mai Timoteo ohi hanona Bereai temiaho. ");
INSERT INTO rro_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Maearima baika Paulo tebaka'ana haukia Paulo kipokia teaomo Atene, ba ia hanona temue teao Berea, Paulo ena 'abi teaoaina Sila mai Timoteo herekia kateao biai Paulo herena. ");
INSERT INTO rro_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Paulo Ateneai Sila mai Timoteo ne'imanakia aonai aiara apa'uana aonai kaiba'uku ebo'o ki'a eihanakia hanona aona ehaiara ki'a. ");
INSERT INTO rro_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ua buonai Paulo hanona marea aonai Iuda haukia mai Helene haukia Tirama ṯekuti aina haukia kipokia teroba ahu, haeamona rani ikoikiai hanona kawakawa 'ekanai tikaoao kaoao maearimakia mo 'akina kipokia terobahu. ");
INSERT INTO rro_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Epikuro haukia mai Stoiko 'iobi haukia baika Paulo kipokia te'abi baitaeai. Baika tebakai bakai tetibaha, “'Abi 'abaea 'abi 'abaea hauna neiana taba ne'uahina?” Baika te'abi, “Ia hanona hanopaka haeai tiramakia robakia niahuna.” 'Abi neiana tehinana pokina Paulo hanona Iesu mai ena mikiri mue pouna namona eiroro aina. ");
INSERT INTO rro_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ua buonai Paulo tea'ina teaoaina to'u 'ekana ha atana Areopago ai weia tehina bena tetibaha, “Ai ṯanuatae kata'iobina oi ba'iobi mahamahana tabana neiana robana nuahuna? ");
INSERT INTO rro_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Taba baika nohina 'urukia tao'o hanona heremaiai tehaeai ki'a baha, ua buonai ai ṯanuatae anikia taba hanona kata 'iobinakia.” ");
INSERT INTO rro_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Atene haukia mai atau'ai temai haukia 'eka weianai ṯemiaho haukia hanona taba haeai haeai robakia a'i tiahu, ia rani ikoinai taba mahamahakia poukia tio'o mai robakia tiahu.) ");
INSERT INTO rro_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Paulo 'eka weiana Areopago to'u haukia wairakiai ekoroti e'abi etibaha, “Wai Atene haumi e, au naihanimi hanona wai taeara ikoinai kuti akakiai tutabura. ");
INSERT INTO rro_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","E'u kaoao kaoao emi aiara apa'uana aonai emi kuti 'ekakia aihanakia aonai emi itara robena ha ahana ṉa terere aihona ‘A'i ha'iobina Tiramana herena’ hauna atabu ahina. Weiana wai a'i to'iobina hauna tokuti aina, iamo bariu wai heremiai kairoro aina. ");
INSERT INTO rro_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Tirama weiana hauna hanopaka mai aona tabakia ikoikia ebabainakia, ia hanona kupa mai hanopaka Obiapakana ba maearima imakiai tebabai mareakia aokiai a'i nemiaho. ");
INSERT INTO rro_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Abomo ia taba ha a'i nikapu aika taba imakai pahabena hauna a'i niraonana, pokina ikupaiana mauri maeabu mai taba haeai haeai ikoinai maearima nibenakia. ");
INSERT INTO rro_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Hau hamona herenai itubu haeai haeai maearimakia ikoikiai ebabainakia hanopaka maikoina aonai katemiaho. Ia kipona ehore ekia miaho ranikia tohakia mai ekia hano hoakia eba'oru 'uainakia. ");
INSERT INTO rro_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Tirama aka neiakia ebabainakia hanona maearima ikoinai katemai herena ia katetabu ahina, 'abi tohana Tirama hanona ata'uai aha'i ia aika herekai. ");
INSERT INTO rro_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Maearima baika ṉa ti'abi aiho, ‘Ia aonai nahamauri nahaibiu ibiu mai nahamiaho.’ Matoha emi ori kikipa haukia te'abi 'abana, ‘Aika hanona ia nahuna.’ ");
INSERT INTO rro_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ba aika Tirama nahuna raninai Tirama hanona weiakia gold 'ao silba 'ao pihara maearima aotipakia imakiai tebabainakia 'abakiai a'i kahabaona. ");
INSERT INTO rro_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","“Tirama hanona maearima ia a'i te'iobina raninai ekia po'o aba eiha haonakia, ia bariu hanona 'eka ikoinai maearima ikoikiai nehinabe pahihinakia kateraona kabe. ");
INSERT INTO rro_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Weiana ia bakai ranina ha aba eba'oruna, ena maearima ha ea'i taeana, hauna kehore hanopaka maikoina taeara beronai kebabakaina. Tirama ehore hau weiana 'ariai ebamikiri muena hanona maearima ikoikiai wairakiai aka neiana ebatohana.” ");
INSERT INTO rro_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","'Ariai emikiri mue 'abina Paulo ehinana aiana teona raninai, baika ia teiriri aina, ia baika hanona te'abi, “Ai ṯanuatae 'abi'abi neiana kohina muena aiamu kataona.” ");
INSERT INTO rro_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Weiana murinai Paulo 'eka weianai ekapare. ");
INSERT INTO rro_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Maearima baika Paulo kipokia tebahaeamo abomo tea'ikakauma. Baiatakiai hanona bakai hauna ha atana Dionusio, ia bakai 'ekana Areopago tipoki aina haukia ha, haeamona babi'e ha atana Damari mai maearima haeai baika abomo tea'ikakauma. ");
INSERT INTO rro_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Weiana murinai Paulo Atene aiarana ehabona eao Korinto aiarana. ");
INSERT INTO rro_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Weia Iuda hauna ha atana Akula ohi tebaitabu ahi, ia hanona Pontoai erama, bariu tainai mo atawana Priskila ohi Italiai temai, pokina rani weianai obia 'arana hauna atana Klaudio 'abi ebaibeni Iuda haukia ikoikiai Roma katehabona. Paulo eao ia keihanakia, ");
INSERT INTO rro_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","weia kipokia temiaho mai teaka, pokina ia hanona parae itukia etai hauna ia terarua 'abakia. ");
INSERT INTO rro_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Paulo hanona beraura robe ikoikiai Iuda haukia ekia marea aonai pou namona 'abina terobahu aina pokina ena nuatae hana Iuda mai Helene haukia aokia keba kabanainakia katea'ikakauma. ");
INSERT INTO rro_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sila mai Timoteo Makedoniai temai murinai, Paulo hanona rani ikoinai 'abi weiakia eiroro ainakia Iuda haukia wairakiai ehina pouna weiana Iesu hanona bamauri hauna Keriso. ");
INSERT INTO rro_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Weiana ena 'abi teahu taeanakia mai herenai 'abi ki'a obokia tehina raninai eopuere ena habuni apurorokia eahu ahunakia, ehina benakia etibaha, “Wai kato'ari raninai weiana hanona wai kipomi emi beho, 'a au hanona behona a'i ka'arana. Bariu rani neianai keaoaina aonai au hanona rama haeai haukia herekia kaeao.” ");
INSERT INTO rro_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ba marea ehabona eao rama haeai hauna ha atana Tito Iusto ena ituai ua'a kemiaho, ia hana Tirama nekuti aina hauna, mai ena itu hana marea herenai. ");
INSERT INTO rro_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Marea poki hauna Kerisopo mai ena itu haukia kipokia Obiapaka tea'ikakaumana haeamona Korinto haukia bo'okia abomo Paulo ena iroro aiana teona raninai tea'ikakauma mai teba'uere robenakia. ");
INSERT INTO rro_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Rabi ha aonai Obiapaka mahabanai ai Paulo ehina bena etibaha, “A'i kota'u, ia ko'abi to'o baihana a'i kounu. ");
INSERT INTO rro_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Pokina Au hana oi heremuai. Tai ha oi a'i kea'i ki'ani'o. Aiara apa'uana neiana aonai au e'u maearima hanona ebo'o.” ");
INSERT INTO rro_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Weiana buonai Paulo ihau hamona mai nawa 'abaihau weia emiaho Tirama ena 'abi maearima eba'iobinakia. ");
INSERT INTO rro_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Kabana hauna Galio Akaia hanona eiha 'inina aonai, Iuda haukia temikiri haeamo Paulo tea'ina teaoaina bakai 'ekanai tehorotina. ");
INSERT INTO rro_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Te'abi tetibaha, “Hau neiana hana maearima aokia niani taeara haeaiai Tirama katekuti aina Iuda haumai emai rauhubu kate'oatana.” ");
INSERT INTO rro_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Paulo aba ke'abi aonai Galio ehore Iuda haukia ehina benakia etibaha, “Wai Iuda haumi, hau neiana beho ebabainakia 'ao hoahoa ki'a obokia ebabainakia raninai wai aiami ka'i taeana ketaina. ");
INSERT INTO rro_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ia neiana hana 'abi mai ata mai wai kipomi emi rauhubu atetuakia raninai, wai kipomi tomoba berona. Taba ṉahomakia hana au robakia a'i kahu.” ");
INSERT INTO rro_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Weiana ia ena 'abiai Iuda haukia bakai 'ekanai teu'u ahinakia. ");
INSERT INTO rro_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ia ikoinai temikiri marea poki hauna Sostene tea'i 'inina bakai 'ekana wairanai teahuahu banaina. Iamo Galio hanona aka weiana robana a'i eahuna. ");
INSERT INTO rro_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulo wapu baika Korintoai emiaho murinai, uaho'abana ehabonakia Priskila mai Akula hanona ia te'abana kipokia aunohiai tebeau banai Suria teao. Aunohiai a'i tebeau ahi aonai Kenkrea aiaranai buina maikoina terehe obona pokina 'abi'uai ha Tirama wairanai ebabaina hauna ebaorena paunai. ");
INSERT INTO rro_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Epesoai tekara'au aonai Paulo ehore Priskila mai Akula weia ehaobonakia. Ia ikupaiana eao Iuda haukia ekia mareai ekatoto weia Iuda haukia kipokia teroba ahu. ");
INSERT INTO rro_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Weiana Iuda haukia Paulo tenoina herekiai rani homa'ana kemiaho, ia eubo. ");
INSERT INTO rro_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ia aba keka'a aonai ehina benakia etibaha, “Tirama kenuatae raninai kamue kamai heremi.” Epua aunohiai ehe'au Epeso ehabona. ");
INSERT INTO rro_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Paulo Kaisareai ekara'au ba eao Ierusalemai ua'a Tirama ena marea haukia etoanakia epua eriri Antioka eao. ");
INSERT INTO rro_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Weia Antiokai rani baika emiaho murinai eao Galatia mai Furugia hanokia maikoina aonai eka'a 'eka ha ha aokiai a'ikakauma haukia ikoinai ebataburanakia. ");
INSERT INTO rro_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Weiana Iuda hauna ha atana Apolo ia hanona Alesandereai erama hauna emai Epeso. Ia hanona 'abi'abi harai hauna abomo Puka robena 'abikia e'iobi harainakia hauna. ");
INSERT INTO rro_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ia hana Obiapaka ena ba'iobi taearanai 'iobi ea'ina mai Iesu pouna namokia berokia eba'iobiai mai aona tohanai eiroroai, iamo ia ena 'iobi hana Ioane ena ba'uere robeaimo epua. ");
INSERT INTO rro_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ia hanona mai nuako'ona Iuda haukia ekia marea aonai eiroro, Priskila mai Akula ia aiana teona raninai tebaka'ana teaoaina ekia ituai Tirama ena 'abi taearana tohana ia herenai tehinahina haraina. ");
INSERT INTO rro_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apolo enuatae keao Akaia aiarana raninai Epesoai ṯemiaho a'ikakauma haukia temikiri ia tebataburana, epua marere ha tererena eao Akaiai ṯemiaho a'ikakauma haukia herekiai, weiana ia keao weia raninai aonamoai katea'i taeana. Ia weia ekara'au raninai Tirama ena aoko'o hoanai tea'ikakauma haukia herekiai barai barai hauna tohanai eao. ");
INSERT INTO rro_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ia ena 'abi taburai hanona Iuda haukia mako wairakiai 'abi baihara taeai eba 'ehonakia, ia Puka robena 'abinai ebatoha tohana Iesu hanona bamauri hauna Keriso. ");
INSERT INTO rro_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolo Korintoai emiaho oho aonai, Paulo hanona Asia hanona oeokia ibuakiai ekabanai eao Epeso. Weia a'ikakauma haukia baika kipokia tebaitabu ahi. ");
INSERT INTO rro_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Paulo ebakainakia etibaha, “Toa'ikakauma aonai Auba Robe emai heremi, 'ao?” Ia te'abi, “Aha'i. Ai hanona Auba Robe 'abina uruna ha a'i tao 'apuana.” ");
INSERT INTO rro_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ba ia ebakai muenakia etibaha, “Ba'uere robe tabanai teba'uere robenimi?” Ia te'abi tetibaha, “Ba'uere robe weiana Ioane e'uahina haunai teba'uere robenamai.” ");
INSERT INTO rro_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Paulo e'abi etibaha, “Ioane ena ba'uere robe hanona raona kabe hoana. Ioane maearima ehina benakia ia murinai nimai hauna kate a'ikakaumana, weiana hanona Iesu.” ");
INSERT INTO rro_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","'Abi weiana teona raninai Obiapaka Iesu atanai teba'uere robenakia. ");
INSERT INTO rro_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Paulo imana ahakiai ehao'au aonai Auba Robe eriri ahakiai, ba temikiri maea haeai haeaiai te'abi'abi haeamona temahabanai Tirama pouna tehinana. ");
INSERT INTO rro_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Maearima weia haukia ikoinai hanona harau haea rua 'abana. ");
INSERT INTO rro_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Nawa aihau aonai Paulo eao Iuda haukia ekia mareai maearima herekiai mai taburana e'abi 'abi Tirama ena obia aiarana pouna eba'iobinakia aokiai kebakabanaina paunai. ");
INSERT INTO rro_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ia maearima baika hanona aokia teba pahihinakia a'i tea'ikakauma haeamona to'u wairakiai 'abi ki'a obokia tehina ba'iobi neiana Iesu katea'ikakauma taearana herenai. Ua buonai Paulo maearima weiakia ehabonakia, ia a'ikakauma haukia mo ebaka'anakia teao Turano ena marere ituna aonai ua'a rani ikoinai eba marerenakia. ");
INSERT INTO rro_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ihau rua hanona weia ebamarere, weiana Iuda haukia mai Helene haukia Asia hanonai ṯemiaho haukia maikoinai Obiapaka ena 'abi pouna teona. ");
INSERT INTO rro_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Tirama ehore Paulo hiabu ebena hoa haeai 'akikia ebabai. ");
INSERT INTO rro_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Maearima Paulo ena muko mai ena habuni ihai hauaninai temiaho haukia teaoainakia inawa haukia ahakiai tehore 'au hanona ekia inawa tenamo abomo aokiai auba ki'a obokia tekarahi. ");
INSERT INTO rro_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Iuda haukia baika ekia aka hanona mea, ia aiara aokiai tekabanai kabanai Obiapaka Iesu atana tehinana tebahobona auba ki'a obokia kateba karahinakia. Ṉa tehinabe aihonakia, “Iesu weiana pouna Paulo neiroro aina hauna atanai nahinabe pahihini'o. Mokarahi!” ");
INSERT INTO rro_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Iuda haukia ekia robe hauna apa'uana Skeba nahuna 'abaihau hamomo hanona aka neiana tebabaina. ");
INSERT INTO rro_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Rani ha auba ki'a obona ekia 'abi ebamuena etibaha, “Au Iesu a'iobina, Paulo abomo a'iobina. Ia wai hanona tai?” ");
INSERT INTO rro_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ba hau weiana aonai auba ki'a obona nemiaho hauna erobo taea hau weiakia eba'ehonakia, ia etabura ki'a baha buonai, eahu ki'anakia, ena ituai tebeau ahi mai haukia abomo mai mani'akia. ");
INSERT INTO rro_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Iuda mai Helene maearimakia Epesoai ṯemiaho haukia pou neiana teona raninai ikoinai teta'u ki'a, ba Iesu Obiapaka atana tebanamona 'ubi tohanai. ");
INSERT INTO rro_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Tirama tea'ikakaumana haukia bo'ona temai ekia ki'a tebabai haukia tehina pounakia. ");
INSERT INTO rro_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Weia nepu haukia bo'ona ekia mea pukakia temaiainakia, maearima wairakiai tehuhunakia. Puka weiakia 'arakia tebahuna hanona taha imabui (50,000) Kina 'abana. ");
INSERT INTO rro_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Taeara neianai hanona Obiapaka ena 'abi erama otaraina haeamona etabura hao tabura hao. ");
INSERT INTO rro_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Taba neiakia ikoikiai terama murinai Paulo aona ea'ia'i haraina enuatae Makedonia mai Akaia hanokiai kekabanai keao Ierusalema. Ia kipona e'abi etibaha, “Kaeao 'uai weia, ba muriai hanona kaeao Roma abomo kaihana.” ");
INSERT INTO rro_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Paulo ena baraibarai haukia rua Timoteo mai Erasto euhunakia te'uai teao Makedonia, ia Paulo hanona rani papana weia Asiai emiaho 'apua. ");
INSERT INTO rro_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Rani weianai Obiapaka ena taeara paunai atetua rarina Epesoai erama. ");
INSERT INTO rro_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Hau ha weia atana Demeterio ia hanona silba akana ebabaina, ena aka haukia tehore tirama babi'ena Atemi ena itu silbai temakanakia, aka weianai moni bo'ona tea'inakia. ");
INSERT INTO rro_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Rani ha Demeterio ehore ena aka haukia mai maearima baika aka ihobona tibabaina haukia eaparinakia temai ia herena, ba ehina benakia etibaha, “E'u hau e, wai to'iobina aika hanona aka neianai eka moni namokia nahatabu ahi. ");
INSERT INTO rro_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","'A hau neiana Paulo hanona neia Epesoai mai Asia hanona maikoina aonai maearima bo'ona aokia nibakabanaina mai niba kaparenakia hanona aba toihana mai uruna tona, ia ni'abi tirama weiakia maearima imakia tibabainakia haukia hanona tirama tohakia aha'i. ");
INSERT INTO rro_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Wairai ki'a ha kerama eka aka neiana atana namona hauna kea'i ki'ana, ia tirama babi'ena apa'uana Atemi ena marea mai ia kipona atana abomo kea'i ki'anakia. Ia hanona Asia hanona maikoina aonai mai hanopaka maikoina aonai ṯekuti aina hauna ena apa'ua aba ke'akauma 'abaea.” ");
INSERT INTO rro_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Maearima to'una 'abi weiana teona raninai teopuere ki'a teio tetibaha, “Epeso haumai emai tirama babi'ena Atemi e, oi hanona oapa'ua ki'a baha!” ");
INSERT INTO rro_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Aiara apa'uana aonai maearima maikoina teio raina temikiri Gaio mai Aristako tea'inakia. Maearima neiakia terarua hanona Makedonia haukia Paulo kipokia tekaoao kaoao haukia, maearima ikoinai ia teberinakia teaoainakia to'u ituna aonai. ");
INSERT INTO rro_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paulo ena nuatae kekarahi keao to'u haukia wairakiai, ia a'ikakauma haukia ia tekaiabuna. ");
INSERT INTO rro_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Abonamo 'eka weianai poki haukia baika hanona Paulo ena 'iobi haukia, ia 'abi teuhuna eao Paulo herena teba'amena to'u ituna weiana aonai a'i kekatoto. ");
INSERT INTO rro_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","'A to'u haukia taba katebabaina hanona a'i te'iobina, maearima baika taba ha teioaina, baika hanona taba haeai mo ha teioaina. Iamo maearima bo'ona hanona a'i te'iobina taba buonai teao weia. ");
INSERT INTO rro_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Iuda haukia baika hau atana Alesanda teaoaina maearima wairakiai tebakorotina. Alesanda imana ea'i taeana to'u haukia ekia io tebapuana, ba ia Iuda haukia beho a'i patehoaina maearima wairakiai kehinana. ");
INSERT INTO rro_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ia te'iobina Alesanda hanona Iuda hauna raninai, teio mue 'abi hamonamo tehina to'ona beraura hoana rua 'abana teio tetibaha, “Epeso haumai emai Tirama babi'ena Atemi e, oi hanona oapa'ua ki'a baha!” ");
INSERT INTO rro_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Murinai aiara ena 'abi irerena hauna to'u haukia ehina benakia 'uri'uri katebapuana ba e'abi etibaha, “Epeso haumi e, hanopakai maearima ikoinai aba te'iobina Epeso hauka hanona tirama babi'ena Atemi ena Marea mai ia aubaubana weiana kupai emai hauna naha'imanakia. ");
INSERT INTO rro_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Taba neiana hanona a'i kahabuniai aina hauna, ua buonai 'uri'urimi mepua. Haeamona noanoai taba ha a'i katobabai ki'ana. ");
INSERT INTO rro_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Maearima neiakia tomaiainakia haukia hanona marea tabakia ha a'i tebainaoaina, haeamona eka tirama babi'ena herenai 'abi ki'a obona ha a'i tehinana. ");
INSERT INTO rro_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","'A Demeterio mai ena aka haukia kipokia ṯenuatae maearima ha beho 'ekanai kate horotina re'a, bakai ranikia hanona ṯemiaho mai bakai poki haukia abomo ṯemiaho, ia katehore beho weiana katetabuna. ");
INSERT INTO rro_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Taba ha nemiaho robana katoahuna raninai, ua'a aiara haukia ekia to'u taearana tohanai katebaberona. ");
INSERT INTO rro_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Poki haukia 'uri'uri neiana bariu nirama hauna paunai aika a'i temeba atetuanaka. Ua kehoma raninai ekia 'abi kahaba muena taearana aha'i, pokina to'u neiana hanona ena bero aha'i.” ");
INSERT INTO rro_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ia 'abi neiana ehinana murinai, to'u haukia maikoina euhunakia terama otaraina. ");
INSERT INTO rro_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Atetua eore murinai, Paulo ebaiuhu a'ikakauma haukia temai herena, aokia ebataburanakia ba haparua ehinana ehabonakia eao Makedonia. ");
INSERT INTO rro_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","'Eka weiakia haeai haeai aokiai 'abi bo'okiai a'ikakauma haukia ebataburanakia ba Helene ai ekara'au. ");
INSERT INTO rro_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Nawa aihau weia Helene ai emiaho, eba'oru aunohiai kehe'au Suria keao aonai Iuda haukia baika terobahu kateahu 'arina pouna eona, buonai Paulo haeamona eraonana Makedonia kekabanai keao Suria. ");
INSERT INTO rro_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Maearima kate'abana haukia hanona neiakia. Puro nahuna Sopatere ia hanona Berea hauna, Aristako mai Sekundo ia hanona Tesalonika haukia, Gaio Derebe hauna, Tukiko mai Trofimo ia hanona Asia haukia, mai Timoteo. ");
INSERT INTO rro_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Maearima neiakia te'uai teao Toroa ai tebai'ima. ");
INSERT INTO rro_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Parawa 'abaeana tatuna murinai Pilipo ai aunohiai tabeau ahi wapu ima murinai weia Toroa ai tabaitabu ahi. Weia hui hamona tamiaho. ");
INSERT INTO rro_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Hui weianai wapu kori'uaina aonai ikoimaiai tamiato'u parawa robena katana. Paulo to'u haukia eba'abi 'abinakia eaomo wapuka'a, pokina kerani hanona ia kehabonakia. ");
INSERT INTO rro_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ai ikoimaiai hanona ikaihuri ha 'ubiai hauna aonai ta'abi'abi, ikaihuri weiana aonai hanona lamepa bo'ona te'ara. ");
INSERT INTO rro_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Hau 'aru'aruna ha atana Eutuko hanona weia riba ahi 'ekanai emiati. Paulo e'abi'abi homa'ana aonai, Eutuko hanona eparua rea itu weiana itarana ibaihauna 'ubiai haunai e'eho eao 'ano. Tea'itaeana hanona aba e'ari. ");
INSERT INTO rro_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Paulo eriri eao Eutuko ahanai eno'au imana huanai era'u huri, e'abi etibaha, “Aomi a'i kearo'ari ia hanona mauri maurina nemiaho.” ");
INSERT INTO rro_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ba Paulo ekara'au mue eao itu 'ubinai Parawa ehobina teani. E'abi'abi homa'a herekiai eaomo raurani 'amari 'amarinai, ba eka'a. ");
INSERT INTO rro_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Hau 'aru'aruna mai mauri maurina teaoaina aiara buonai aokia etabura ki'a. ");
INSERT INTO rro_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Paulo e'abi ia hanona aenai keao Aso paunai, ena 'abi ta'i taeana ai aunohi ai taehe'au tabeau ta'uai taeao, weia ta'imana kehe'au. ");
INSERT INTO rro_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Ba Aso ai tabaitabu ahi aonai kipokia aunohiai taehe 'au taeao Mitulene. ");
INSERT INTO rro_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Erani tabeau taeao Kioso kereibua haianai takara'au ba wapu ibaruanai takabanai taeao Samo ba wapu ibaihaunai hanona Mileto ai takara'au. ");
INSERT INTO rro_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paulo ena raona hanona Epeso katabeau banai, a'i enuatae weia Asia hanonai a'i tamamiaho 'abaea, pokina kenoanoa Pentekoste berauranai hanona Ierusalemai kekara'au biai. ");
INSERT INTO rro_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Weia Mileto ai Paulo ebaiuhu Epeso marea ena kiro haukia herekia katemai herena. ");
INSERT INTO rro_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ia tekara'au aonai ehina benakia etibaha, “Au wapu kori'uaina Asia hanonai akara'au emai mo bariu beraura maikoina wai baiatamiai aea amiaho aiho hanona to'iobi haraina. ");
INSERT INTO rro_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Iuda haukia baika ekia aibara tehobonakia here'uai ranikiai, mai 'aiaunu'u maha'u mai beina Obiapaka ena aka ababaina. ");
INSERT INTO rro_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Wai aba to'iobina ibaraimi 'ekakiai hanona e'u iroro ai mai e'u ba'iobi ai to'u wairakiai mai itu ha ha aokiai, ha a'i ahore bunina. ");
INSERT INTO rro_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Au Iuda haukia mai Helene haukia herekiai ahina karahi haraina ia kateraona kabe kateao Tirama herena eka Obiapaka Iesu kate a'ikakaumana. ");
INSERT INTO rro_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Bariu hanona Auba Robe aiana ika'ainai kaeao Ierusalema, ia a'i na'iobina weia taba here'uai kerama. ");
INSERT INTO rro_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Au a'iobina hana aiara ha ha aokiai Auba Robe ehina bena'u atetua pahihina mai wapura hanona waira'uai nimai. ");
INSERT INTO rro_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Iamo kipo'u e'u mauri ena namo a'i natabuna, ia au nanuatae e'u mauri orenai hanona Obiapaka Iesu aka ebena'u hauna kabaore haraina, aka weiana hanona Tirama ena aoko'o hoana pouna namona kahina karahina. ");
INSERT INTO rro_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Ikoimiai baiatamiai akabanai kabanai Tirama ena obia aiarana airoro aina, bariu a'iobina wai hanona au a'i katoiha muena'u. ");
INSERT INTO rro_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Ua buonai bariu wairamiai nahina karahina hau ha ke'ari ki'a 'ekana keao hanona behona a'i ka'arana. ");
INSERT INTO rro_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Pokina Tirama ena nuatae maikoina aba airoro aina heremi taba ha a'i abunina. ");
INSERT INTO rro_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Kipomi katoiha 'ini harainimi mai a'ikakauma haukia kato'ima harainakia matoha mamoe i'imana hauna mamoe ne'ima harainakia 'abana. Auba Robe aka weiana ebenimi Tirama ena marea haukia ibaka'a haraikia haumiai ebaonimi, weiakia hanona Tirama Nahuna ena 'ariai aba ekawanakia. ");
INSERT INTO rro_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","A'iobina kahabonimi murinai, ba'iobi haukia bai'oikia baika waeha 'aki aiahukia 'abakia katemai baiatamiai a'ikakauma haukia weiakia mamoe 'abakia katea'i ki'anakia. ");
INSERT INTO rro_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Abomo maearima baika kipokia tuaka haeamo haukia katemikiri bai'oi 'abikiai a'ikakauma haukia baika katebahureanakia kateba kaparenakia ia murikiai kateka'a. ");
INSERT INTO rro_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Ua buonai kato'ima harainimi, rani ikoinai katoraona 'inina ihau aihau aonai maha'u mai beina rabi mai mararani wai ikoimiai ha ha aba'iobinimi a'i a'oro 'apua. ");
INSERT INTO rro_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Bariu wai Tirama imanai mai ena aoko'o hoana 'abinai nahorotinimi, 'abi weiana hanona ikoimiai kebakori 'ininimi mai hiabuna Tirama ena banamo kebenimi ena maearima robekia ikoikiai ha ha 'eukia kebenakia ihobonai. ");
INSERT INTO rro_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Au baiatamiai aonai hau ha ena moni 'ao habuni ha a'i anuataeai 'abaeana. ");
INSERT INTO rro_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Wai kipomi aba to'iobina au i'aba'u haukia mai au e'u nuatae tabakia ikoikiai hanona ima'u neiakiai mo ababainakia. ");
INSERT INTO rro_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Au taba maikoina aba abaihanimi taeara neianai wai abomo katoaka tabura haukia te'abe'abe haukia katobarainakia, Obiapaka Iesu 'abi ehinana hauna katoraona 'inina ṉa e'abi aiho, ‘Baibeni hanona ena namo eapa'ua ba ia'ina hanona ena namo eko'iko'i.’” ");
INSERT INTO rro_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Paulo 'abi neiana ehinana murinai, kipokia tekaipehu haeamo tebahuba'ari. ");
INSERT INTO rro_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ikoikiai mai haihaikia huanai tera'u huri tepauna baparua hoana. ");
INSERT INTO rro_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ia teaoko'oai ki'ana pokina ia e'abi wairana a'i kateiha muena. Weiana te'abana kipokia teao weia aunohi ai kehe'au. ");
INSERT INTO rro_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Ia herekiai haparua tahinana murinai, aunohi ai tabeau ahi beromaiai taeao Koso, rani ibaruanai takabanai taeao Rodo ba taeao Patara ai takara'au. ");
INSERT INTO rro_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Weia aunohi ha Foenikia keao hauna tatabu ahina ba taehe'au tabeau ahi. ");
INSERT INTO rro_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Ba Kupuro kereibuana ahitainai tabeau banai kataeao Suria aonai, Turo ai tabahaha'au weia aunohi kohuna katetaranakia. ");
INSERT INTO rro_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","A'ikakauma haukia baika weia tatabu ahinakia kipokia hui hamona tamiaho. Ia Auba Robe ena hiabuai Paulo tehina bena Ierusalema a'i keao. ");
INSERT INTO rro_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ia emai miaho beraurana eore aonai, tahabonakia taka'a. A'ikakauma haukia ikoinai atawakia mai nahukia kipokia te'abanamai takarahi aiara murinai, weia poeai takaipehu tabahuba'ari. ");
INSERT INTO rro_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Ha ha kipokia haparua tahinana murinai takara'au aunohiai taehe'au, ba ia temue ekia aiara teao. ");
INSERT INTO rro_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Turo ai beromaiai tabeau taeao Tolemaia ai takara'au, a'ikakauma haukia kipokia tabaitabu ahi ba wapu hamona weia kipokia tamiaho. ");
INSERT INTO rro_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Erani weia tahabona taeao Kaisarea ai takara'au. Ebaneria hauna Pilipo ena itu ai tamiaho, ia hanona diakono haukia 'abaihau hamomo 'abakia ha. ");
INSERT INTO rro_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ia nahuna uahokia bani hanona mahabanai uahokia. ");
INSERT INTO rro_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Weia tamiaho wapu baika teore murinai mahabanai hauna ha atana Agabo Iudea ai emai. ");
INSERT INTO rro_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ia emai heremaiai hanona Paulo huana ihaina ea'ina kipona imana mai aena ebirinakia e'abi etibaha, “Auba Robe e'abi, Ierusalemai Iuda haukia katehore ihai neiana pokina hauna ṉa katebiri aihona rama haeai haukia katebenakia.” ");
INSERT INTO rro_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","'Uru neiana taona raninai, ai mai maearima weia haukia kipokia Paulo tanoina a'i keao Ierusalema. ");
INSERT INTO rro_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ba Paulo ai emai 'abi ebamuena etibaha, “Taba buonai tuhai ao'u tuba'abe'abena? Au hana aba aba'oru, ia Ierusalemai katebirina'u 'ao kateahu 'arina'u re'a Obiapaka Iesu atanai.” ");
INSERT INTO rro_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Ia aiamai a'i ea'i taeana paunai tahabona ba tatibaha, “Obiapaka ena nuatae hanona merama.” ");
INSERT INTO rro_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Neiana murinai, wapu baika teore ba taba'oru ba takarahi kataeao Ierusalema. ");
INSERT INTO rro_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","A'ikakauma haukia baika Kaisareai te'abanamai taeao Nasona ena itu ai weia katamiaho. Ia hanona Kupuro hauna abomo a'ikakauma hauna ha 'ai'aina. ");
INSERT INTO rro_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Ierusalemai takara'au raninai, uaho'abaka teba katotonamai mai aonamokia. ");
INSERT INTO rro_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Erani hanona Paulo kipokia taeao Iesu hatina Iakobo kataihana, weia marea ena kiro haukia ikoinai abomo tewaira tina. ");
INSERT INTO rro_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Paulo ia imakia ea'inakia murinai, ia ena aka aonai Tirama taba ebabai rama haeai haukia herekiai haukia ikoikiai poukia ehinanakia. ");
INSERT INTO rro_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","'Abi neiana teona raninai Tirama tebanamona. Weiana ia Paulo haianai te'abi tetibaha, “Uaho'abamai e, aba o'iobina Iuda haukia bo'okia tia'ikakauma, ia haukia ikoikiai Mose ena rauhubu ia'itaeana hanona tiraona apa'uana. ");
INSERT INTO rro_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ia Iuda haukia neiakia hanona pou bai'oina ṉahomana teona, Iuda haukia rama haeai haukia baiatakiai ṯemiaho haukia ohina benakia Mose ena rauhubu herenai katekapare, miorikia a'i katetarenakia, haeamona Iuda haukia ekia hoa hoa a'i kateka'aina. ");
INSERT INTO rro_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ia aba poumu kateona oi hanona omai. Bariu aea kahababai aiho? ");
INSERT INTO rro_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Ua buonai katahina beni'o akana kobabaina. Emai maearima bani hanona Tirama wairanai ekia 'abi'uai aba tehorotina. ");
INSERT INTO rro_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Maearima neiakia koaoainakia ekia 'opu ia'iobona to'una aonai, ekia to'u 'arakia kohorenakia buikia katekabe obonakia. Weiana maearima ikoinai kate'iobina 'abi weiakia oi ahamuai tehina haukia hanona tohakia aha'i, ia oi hanona Mose ena rauhubu tainai nomiaho. ");
INSERT INTO rro_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Rama haeai haukia weiakia bariu tia'ikakauma haukia herekiai hanona emai raona taraonana hauna marere ai aba tarerena tatiu ahina taba 'iobinakia, weiana aniani tibaibeni tirama bai'oikia herekiai haukia a'i kateani, haeamona mahi tiaruaru haukia a'i kateani, mahi 'akokiai teto'o 'ari haukia a'i kateani, mai a'i katenabau 'abaea nabau 'abaea.” ");
INSERT INTO rro_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Erani Paulo maearima neiakia bani ebaka'anakia kipokia teao 'opu ia'iobona to'una aonai tetoto, ba eao marea robe aonai etoto eba'iobinakia rani tabanai hanona 'opu ia'iobona akana ranina keore, haeamona wapu ha ha kipokia ekia baibeni katebabai. ");
INSERT INTO rro_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Wapu 'abaihau hamomo aka weiana aba keore aonai, Iuda haukia baika Asia hanonai temai haukia Paulo marea robe aonai teihana raninai, ia mako tebahi ahinakia Paulo tea'ina, ");
INSERT INTO rro_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","teio tetibaha, “Isaraela haumi e, tomobarainamai! Hau neiana hanona 'eka ikoikiai aokiai ena ba'iobi maearima ikoinai herekiai eka maearima mai Mose ena rauhubu mai marea robe neiana ni'oatanakia, abomo bariu hanona rama haeai haukia nimaiainakia marea robe ai 'eka robena neiana tiba'opuna.” ");
INSERT INTO rro_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ua te'abi aiho pokina 'uainai Paulo Trofimo Epeso hauna ohi Ierusalema aiarana aonai temiaho teihanakia, ba teraonana ebaka'ana eaoaina marea robe aonai. ");
INSERT INTO rro_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","'Abi neianai aiara maikoina 'uri'uri rarina ebaramana maearima taeara haeai haeaiai tebeau temai Paulo tea'ina teberi karakarana marea robe ai tekarahiaina, murinai marea robe pa'abina tekaiabuna. ");
INSERT INTO rro_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Paulo iahu'arina akana tibabaina aonai pouna eao Roma ekia huari poki hauna eona Ierusalema maearimakia atetua rarina tibabaina. ");
INSERT INTO rro_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Beronai huari ṯe'uai aina haukia mai huari haukia eaoainakia tebeau to'u tekokina. Maearima weiakia huari poki hauna mai ena huari haukia teihanakia raninai Paulo iahunai te'oro 'abaea. ");
INSERT INTO rro_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Huari poki hauna eka'a eao Paulo ea'ina, ba ena 'abiai tabiri rua ai tebirina. Weiana ebakainakia ia hanona tai haeamona taba ebabaina. ");
INSERT INTO rro_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","To'u ranina aonai maearima baika teio 'abi haeai tehina haeamona baika 'abi haeai mo tehina, weiana 'uri'uri rarina 'akina tebabuana buonai, huari poki hauna 'abi tohana ha'i eona hanona e'abi Paulo katebaka'ana kateaoaina huari haukia ekia miaho 'ekana. ");
INSERT INTO rro_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Paulo tebaka'ana itataea ai ehe'au raninai to'u haukia teaibara ki'a baha buonai, huari haukia tehore Paulo tebuana teao. ");
INSERT INTO rro_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Mako ia murinai teao haukia mai ioiokia te'abi tetibaha, “Tomoahu 'arina!” ");
INSERT INTO rro_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Huari haukia Paulo aba ekia parabuai katebakatotona aonai Paulo huari poki hauna enoina etibaha, “Penamo haiamuai e'u 'abi ha pahinana.” Ba huari poki hauna ebakai bakai etibaha, “Oi Helene maeana ona, u? ");
INSERT INTO rro_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Oi Aigupito haumu weiamu atetua obaramana ahuahu haukia ikoinai taha bani (4,000) obato'unakia obaka'anakia toao hano'akunai, 'u?” ");
INSERT INTO rro_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paulo ia ena 'abi ebamuena etibaha, “Aha'i. Au hanona Iuda hau'u, Kilikia hanona Taso ai arama, aiara apa'uana weiana maearima'u. Nanoini'o, maearima neiakia pahina benakia.” ");
INSERT INTO rro_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Huari poki hauna Paulo bero ebena ke'abi, ba Paulo itataeai ehe'au imana ea'i taea maearima kateunu. To'u 'uri'uri tebapuana raninai, Paulo Heberu maeanai ehina benakia. ");
INSERT INTO rro_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Uaho'aba'u mai hama'u ikoimiai, tomobahu e'u pou mahinana aia'u tomona.” ");
INSERT INTO rro_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Heberu maeanai ehina benakia hanona ikoikiai tebahu harai ia e'abi hanona aiana teona. ");
INSERT INTO rro_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","E'abi mue etibaha, “Au hanona Paulo, Iuda hau'u e'u rama aiarana hanona Taso Kilikiai, ia aiara neiana Ierusalemai tebapa'uana'u. Au hanona Gamaliel ebamarerena'u, 'aba'abaka ekia rauhubu aea homakia ikoikiai eba'iobina'u abomo Tirama ena aka ataburaina matoha bariu wai tutabura 'abana. ");
INSERT INTO rro_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Au Iesu tea'ikakaumana haukia mai babi'ekia a'oatanakia, taeara neiana teka'aina haukia baika kateahu 'arinakia, baika abirinakia wapura itunai akapo totonakia. ");
INSERT INTO rro_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","E'u 'abi hanona robe haukia arakiai hauna mai bakai apa'uana haukia katebatohana. Ia tehore marere tebena'u aeao uaho'abaka Damaseko ai haukia herekia, weia a'ikakauma haukia kamaiainakia Ierusalemai katewapura. ");
INSERT INTO rro_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Atiaha 'abana taearai aeao Damaseko aba here'uai hanona ea rarina 'akina ha kupai eriri ebarara kakaiarona'u. ");
INSERT INTO rro_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Beronai a'eho 'anoai, aia ha aona etibaha, ‘Saulo e, Saulo e, taba buonai au nu'oatana'u?’ ");
INSERT INTO rro_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Au abakai bakai atibaha, ‘Obiapaka e, oi tai?’ Ia etibaha, ‘Au Iesu, Nasareta hau'u, nu'oatana'u.’ ");
INSERT INTO rro_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Te'abana'u haukia ea weiana teihana, ia aia weiana au ehina bena'u hauna a'i teona. ");
INSERT INTO rro_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Au abakaina, ‘Obiapaka e, au taba kababaina?’ Ia etibaha, ‘Momikiri, koao Damaseko, weia hau ha ua'a taba ke'uahina hanona akakia ikoikiai kobabainakia.’ ");
INSERT INTO rro_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Te'aba'u haukia ima'uai te'ebe tebaka'ana'u taeao Damaseko, pokina ea weiana 'imare 'abana maha'u eba'iaunakia. ");
INSERT INTO rro_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Hau ha atana Anania emai eihana'u. Ia hanona rauhubu 'abikia ne'ima harainakia hauna, Iuda haukia weia ṯemiaho haukia ikoikiai hanona ia timariki aina. ");
INSERT INTO rro_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ia emai here'uai ekoroti ehina bena'u etibaha, ‘Uaho'aba'u Saulo e, emu ihaiha moa'i muena.’ Rani weianai beronai maha'u enamo au ia aihana. ");
INSERT INTO rro_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ba ia etibaha, ‘Aika 'aba'abaka ekia Tirama etina'ani'o ena nuatae ko'iobina abomo aka bero hauna Iesu koihana, ia pinanai ke'abi hanona aiana kona. ");
INSERT INTO rro_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Weiana oi hanona ia pouna ihinanai koao, taba ona 'ao oihana hauna maearima ikoikiai kohina benakia. ");
INSERT INTO rro_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Bariu taba naha'imana? Momikiri Obiapaka koaparina atanai ko'uere robe, emu ki'a keuhu obonakia.’ ");
INSERT INTO rro_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Muriai au amue aeao Ierusalema, marea robe aonai abahuba'ari hanona amahabanai. ");
INSERT INTO rro_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Obiapaka aihana ba ehina bena'u etibaha, ‘Monoanoa. Bariu bariu mo Ierusalema kohabona, pokina e'u pou kohinana hanona maearima neiakia emu 'abi a'i katea'i taeana.’ ");
INSERT INTO rro_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Au atibaha, ‘Obiapaka e, ia aia'u kateona, pokina maearima neiakia hanona te'iobina'u au aeao marea ha ha aokiai tia'ikakaumani'o haukia ahunakia, abirinakia wapura itunai ane'etinakia. ");
INSERT INTO rro_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Oi poumu ihinana hauna Stefano aruaruna ekiki oioi raninai au abomo weia kipokia takoroti haeamo teahu 'arina haukia abatohanakia abomo ekia habuni aiha 'ininakia.’ ");
INSERT INTO rro_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Weiana Obiapaka ehina bena'u etibaha, ‘Aha'i, oi hana moao, au oi nauhuni'o rama haeai haukia atau'ai ṯemiaho haukia herekia.’” ");
INSERT INTO rro_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Maearima hanona Paulo aiana tebahu aina eaomo 'abi neiana ehinana raninai aiakia tebakara 'aunakia teio tetibaha, “Hau neiana kahahu 'arina! Neia hanopakai kemiaho hanona ena namo aha'i.” ");
INSERT INTO rro_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ia tebakoko ekia habuni tekapo abomo 'ano te'iti tekapo 'ubi teao. ");
INSERT INTO rro_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Weiana huari poki hauna ena huari haukia ehina benakia Paulo teaoaina aka 'ekana, weia kate'atina ba katebakaina taba buonai teioaina. ");
INSERT INTO rro_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Temikiri tebirina kate'atina aonai, Paulo huari haukia hinabu nipoki aina hauna ia herenai ekoroti hauna ehina bena etibaha, “Roma hauna bakai a'i nia'i bahana, ia kate'atina hanona mai ena bero, 'u?” ");
INSERT INTO rro_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Huari hauna weiana aia eona raninai eao ia ena poki hauna ehina bena etibaha, “Hau weiana hanona Roma hauna ṉa niho. Aea kobabai aiho?” ");
INSERT INTO rro_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Weiana huari poki hauna eao Paulo ebakaina etibaha, “Oi Roma haumu?” Paulo e'abi, “'E.” ");
INSERT INTO rro_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Huari poki hauna e'abi etibaha, “Au Roma hau'uai aeao hanona moni rarina 'akina 'ara ahore.” Ia Paulo e'abi etibaha, “Au hanona Roma hau'u arama.” ");
INSERT INTO rro_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Weia tekoroti katebakaina haukia beronai tehe mue, huari poki hauna e'iobina hanona eta'u, pokina Paulo hanona Roma hauna, iamo tabiriai ebirina paunai. ");
INSERT INTO rro_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Erani huari poki hauna ena nuatae ke'iobi haraina Iuda haukia taba buonai Paulo tekaiahina. Weiana robe haukia apa'uakia mai bakai apa'uana haukia ebato'unakia, ba Paulo erubuna eaoaina wairakiai ebakorotina. ");
INSERT INTO rro_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paulo bakai apa'uana haukia eiha 'ini'ininakia e'abi etibaha, “Uaho'aba'u e, ao'u tohana beho ha a'i ababaina Tirama wairanai amiaho emai mo bariu.” ");
INSERT INTO rro_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Weiana Anania robe haukia 'arakiai hauna 'abi neiana eona hanona Paulo herenai tekoroti haukia ehina benakia pinana kateahu 'iti'itina. ");
INSERT INTO rro_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ba Paulo ia ehina bena etibaha, “Kaita'ata'a haumu, Tirama keahuni'o, rauhubuai naia omiati, au kobabakaina'u, ia oi haeamomu mo rauhubu obakai hurina, o'abi kateahuna'u.” ");
INSERT INTO rro_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Paulo herenai tekoroti haukia tehore tehina bena tetibaha, “Oi hama Tirama ena robe haukia 'arakiai hauna herenai nu'abi ki'a?” ");
INSERT INTO rro_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paulo etibaha, “Uaho'aba'u, a'i a'iobina ia hanona robe haukia 'arakiai hauna. Weiana puka robenai ṉa erere aiho, ‘Emu obia hauna herenai a'i ko'abi ki'a.’” ");
INSERT INTO rro_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Paulo bakai apa'uana haukia eiha 'iobi ainakia baika Parisea haukia baika Sadukea haukia hanona wairakia eio 'aota etibaha, “Uaho'aba'u e! Au hanona Parisea hau'u, Parisea nahukia, e'u raona raona 'ari haukia katemikiri mue paunai bariu bakai 'ekanai nakoroti.” ");
INSERT INTO rro_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","'Abi neiana ehinana raninai baiara rarina 'akina erama, ia tehe boana Parisea haukia 'abaeana mo mai Sadukea haukia 'abaeana mo. ");
INSERT INTO rro_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Pokina Sadukea haukia hanona 'ari haukia ekia mikiri mue a'i tibatohana, aneru 'ao auba abomo aha'i, ia Parisea haukia hanona ikoikiai tibatohanakia. ");
INSERT INTO rro_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Atetua rarina erama, Parisea haukia aokiai rauhubu poki haukia baika temikiri teio 'aota tetibaha, “Hau neiana ena beho ha a'i tatabu ahina. Pa'e aneru 'ao auba mo hau neiana ehina bena.” ");
INSERT INTO rro_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Baiara erarina 'akina. Huari poki hauna Paulo a'i temetapa 'iti'itina ta'una, huari haukia euhunakia teriri teao Paulo herekiai tepuhu boinakia, teaoaina huari haukia ekia 'eka. ");
INSERT INTO rro_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Rabi weiana Obiapaka Paulo herenai ekoroti e'abi etibaha, “Kotabura! Ierusalemai pou'u ohinana 'abana Roma ai abomo pou'u kohinana.” ");
INSERT INTO rro_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Erani raurani Iuda haukia teto'u terobahu te'abi'uai Tirama wairanai, aniani ha a'i kateana abomo bei ha a'i kateinu keao mo Paulo kateahu 'arina. ");
INSERT INTO rro_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Haukia ikoinai bariabui reana hanona ua te'abi aiho. ");
INSERT INTO rro_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Teao robe haukia apa'uakia mai aiara maearima apa'uakia herekiai te'abi tetibaha, “Ai aba ta'abi'uai Tirama wairanai, aniani ha a'i katana keao mo Paulo katahu 'arina. ");
INSERT INTO rro_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Bariu wai mai bakai apa'uana haukia 'abi tomouhuna meao huari poki hauna herena katobai'oi kato'abi, Paulo kemai ṉa'a heremi 'abi berona katoa'ina ṉa katohoma. Ia ṉa kemai a'i kekarahi baha aonai ai aba ta'oru katahu 'arina.” ");
INSERT INTO rro_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","'A Paulo uana Paulo hinahina tehinahina 'uruna eona, ua buonai eao huari haukia ekia 'ekai, Paulo haianai e'abi. ");
INSERT INTO rro_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Ba Paulo huari haukia hinabu nipoki ainakia hauna ha eaparina ehina bena etibaha, “Hau 'aru'aruna neiana kobaka'ana koaoaina huari poki hauna herena, ia mai ena 'abi ha ua'a kehinana herenai.” ");
INSERT INTO rro_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ua buonai huari hauna weiana Paulo uana eaoaina huari poki hauna herena e'abi etibaha, “Paulo wapura hauna ebaiuhu aeao herena, enoina'u hau 'aru'aruna neiana kamaiaina heremu ia mai ena 'abi ha haiamuai kehinana.” ");
INSERT INTO rro_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Huari poki hauna Paulo uana imanai e'ebe teao haiahaiai ba ebakaina, “Emu nuatae 'abina taba haia'uai kohinana?” ");
INSERT INTO rro_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ia e'abi etibaha, “Iuda haukia aba tehina haeamona katenoini'o, ‘Mara Paulo koaoaina bakai apa'uana haukia herekia, katebakai haraina herenai 'abi berona katea'ina.’ ṉa katehoma. ");
INSERT INTO rro_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ia aiakia a'i kona pokina maearima haukia ikoinai bariabui reana hanona katebai'ima Paulo katehe abuna. Te'abi'uai Tirama wairanai a'i kateani 'ao bei a'i kateinu keao mo Paulo kateahu 'arina. Bariu maearima weiakia hanona aba te'oru kate babaina, ekia noi mo koa'i taeana hanona tibahubahu aina.” ");
INSERT INTO rro_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Huari poki hauna hau 'aru'aruna weiana eharabuna etibaha, “Ohina bena'u 'abina neiana pouna hanona hau ha haianai a'i kohinana.” Ba euhuna eka'a. ");
INSERT INTO rro_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Weiana huari poki hauna ehore huari haukia hinabu tipoki ainakia haukia rua eaparinakia ehina benakia etibaha, “Huari haukia hinabu rua, hoti ai ṯehuari haukia ikoinai imabui harau rua mai 'arawai haukia ikoinai hinabu rua katoba'orunakia. Bariu rabi beraura hoana 'ababani hamomo hanona katoao Kaisarea. ");
INSERT INTO rro_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Hoti baika abomo katoba'orunakia Paulo kemia'au, kato'ima haraina katoaoaina Kabana hauna Feliki herena.” ");
INSERT INTO rro_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ba huari poki hauna marere ha ererena keao Kabana hauna herena, ṉa erere aihona. ");
INSERT INTO rro_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Au Klaudio Lusia, ao'u namonai oi Feliki Kabana haumu namomu banamo nabeni'o. ");
INSERT INTO rro_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Iuda haukia hau neiana tea'ina teahuna aba kateahu 'arina aonai, e'u huari haukia kipokia taeao 'arana tabamaurina. Pokina a'iobina ia hanona Roma hauna. ");
INSERT INTO rro_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Au anuatae ka'iobina taba buonai tikai ahina buonai aeaoaina Iuda haukia ekia bakai apa'uana aonai. ");
INSERT INTO rro_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Weia a'iobina hau neiana taba ua'a ha a'i ebabaina weiana ke'ari 'ao kewapuraina, ia kipokia ekia rauhubu aonai bakaibakai baika buokiai tea'ina. ");
INSERT INTO rro_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Haeamona Iuda haukia baika terobahu kateahu 'arina ṉa teho, pouna aona raninai beronai mo auhuna heremu. Tehinau aina haukia abomo ahina benakia ekia hinau 'abikia katewahi ainakia heremu.” ");
INSERT INTO rro_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Ua buonai huari haukia ekia poki hauna aiana teka'aina ihobonai rabi weiana aonai Paulo teaoaina Antipatri ai tekarahi. ");
INSERT INTO rro_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Erani hanona aekiai teka'a haukia temue ekia aka 'ekana teao, ia hotiai haukia Paulo teaoaina. ");
INSERT INTO rro_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Hotiai teao haukia Kaisareai tekara'au raninai, marere weiana Kabana hauna atana Feliki tebena, ba Paulo abonamo Feliki ena iha'ini ba'anai tehabona. ");
INSERT INTO rro_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Kabana hauna marere weiana etuabina murinai, ia Paulo ebakaina ia hanona 'eka tabana hauna. Ia e'iobina Paulo hanona Kilikia hauna raninai, ");
INSERT INTO rro_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","e'abi etibaha, “Oi beho 'ekanai tihorotini'o haukia katemai raninai, oi emu pou kohina aiamu kaona.” Epua ia ena huari haukia ehina benakia Paulo weia Heroda obia hauna ena itu aonai kateiha 'inina. ");
INSERT INTO rro_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Wapu ima teore murinai Anania robe haukia arakiai hauna, aiara haukia apa'uakia mai Roma ekia rauhubu e'iobi haraina hauna atana Teretulo kipokia teriri teao Kaisarea, Kabana hauna Feliki wairanai Paulo katehinau aina. ");
INSERT INTO rro_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Ba Feliki 'abi euhuna eao Paulo temaiaina, weiana Teretulo emikiri ena hinau 'abina ea'i ramana etibaha, “Feliki, Kabana haumu namomu e, ihau rarina o'uaiai harainamai baibua aonai ṯamiaho. Emu aotipai emai hano neiana aonai taba namokia bo'okia terama. ");
INSERT INTO rro_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Ua buonai 'eka maikoinai mai taeara ikoikiai ai hanona oi ṯa'i taeani'o. Feliki Kabana haumu namomu, ai mai aomai ikoikiai oi ṯabanamoni'o. ");
INSERT INTO rro_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Bariu a'i kabaro'arini'o, ia nanoini'o koaoko'o ainamai, emai 'abi papana uruna kona. ");
INSERT INTO rro_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","'Abina hanona neiana. Hau neiana tatabu ahina ia hanona ripuripu hauna. Hanopaka maikoina aonai Iuda maearimakia ikoikiai herekiai atetua nibarama barama bena hauna, abomo Nasareta maearimakia ki'a obokia ne'uai ainakia ekia a'i to'u aokiai. ");
INSERT INTO rro_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Ia nihore Marea Robe niba'opuna buonai ta'ina. (Emai rauhubu tainai katababakaina. ");
INSERT INTO rro_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Ia Lusia huari poki hauna apa'uana emai ebatabura ki'a heremaiai epuhu boina. ");
INSERT INTO rro_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ba tehinau aina haukia ehina benakia katewahi heremu.) Ba oi kipomu hau naiana kobakaina, ai ia ṯahinau aina hauna aiana kona hanona ko'iobina.” ");
INSERT INTO rro_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Weiana Iuda haukia abomo Teretulo tebaruana te'abi ena 'abi ikoikiai hanona tohakia. ");
INSERT INTO rro_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Kabana hauna 'ekuna ekaina Paulo ke'abi, ba Paulo e'abi etibaha, “Ihau rarina eka hanopaka aonai bakai bo'ona obabainakia buonai au ao'u namonai kipo'u pou'u kahinana oi wairamuai. ");
INSERT INTO rro_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Oi kipomu 'uri'uri neiana pokina kotabuna raninai aba ko'iobina, weiana wapu harau haea rua aba teao aonai au akara'au Ierusalema aeao kabahuba'ari. ");
INSERT INTO rro_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Aonai Iuda haukia here'uai beho ha a'i tetabu ahina, marea robe aonai hau ha ohi a'i tabaiara 'ao marea aokiai 'ao aiara weiana aonai a'i abatetua. ");
INSERT INTO rro_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Hau neiakia bariu ṯehinau aina'u 'abikia hanona a'i mo kateba tohanakia oi wairamuai. ");
INSERT INTO rro_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","“Iamo au wairamuai kahina pouna hanona neiana, hau neiakia ti'abi kuti bai'oina taearanai au hanona 'aba'abamai ekia Tirama nakuti aina, taba ikoikiai Mose ena rauhubuai mai mahabanai haukia ekia pukai tererenakia ikoikiai ṉa'i taeanakia. ");
INSERT INTO rro_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","E'u buabeni Tirama herenai hanona ihobonamo maearima neiakia. Emai buabeni hanona bero haukia mai ki'a haukia ikoikiai 'ariai katemikiri mue. ");
INSERT INTO rro_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ua buonai rani ikoinai nabatabura ao'u beronai kamiaho Tirama mai maearima wairakiai. ");
INSERT INTO rro_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Ihau baika atau'ai amiaho murinai amue aeao Ierusalema e'u maearima herekia beruberu kaeao ainakia uraru haukia kabenakia haeamona ki'a ihina haona banamona kababaina paunai. ");
INSERT INTO rro_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Au hanona robe hoahoana ababaina abamaha mahana'u aonai marea robe ai teihana'u, mako ua'a aha'i, abomo 'uri'uri ua'a ha a'i ababaina. ");
INSERT INTO rro_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Ia Iuda haukia baika Asiai temai haukia abomo weia, e'u beho ha teihana raninai bariu wairamuai patewaira tina patehina pouna. ");
INSERT INTO rro_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Aha'i raninai Iuda haukia neiakia aba temai haukia teme'abi, bakai apa'uana haukia wairakiai tebabakaina'u aonai e'u beho tabana tetabu ahina. ");
INSERT INTO rro_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ia wairakiai akoroti raninai aio 'abi ha neiana ahinana atibaha, ‘'Ari haukia katemikiri mue mo paunai bariu toa'ina'u bakai 'ekanai tohorotina'u.’” ");
INSERT INTO rro_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Ba Feliki a'ikakauma taearana e'iobi haraina paunai bakai ekaiabuna ba e'abi etibaha, “Huari poki hauna Lusia kemai raninai emi bakai karaonana.” ");
INSERT INTO rro_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ia ehore huari haukia hinabu nipoki ainakia hauna ehina bena Paulo keiha 'ini haraina, ia a'i kekaiabu ki'a bahana, ena hau katemai katetoana haeamona ena nuatae tabakia re'a katebabai. ");
INSERT INTO rro_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Rani baika teao murinai Feliki atawana Drusila ohi temai, Drusila hanona Iuda babi'ena Feliki ebaiuhu eao Paulo emai, ba Paulo a'ikakauma Keriso Iesu aonai hauna pouna ehinana aiana teona. ");
INSERT INTO rro_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Ia Paulo ehore aka bero, bakiro mai bakaibakai rarina kemai hauna robakia eahuna, weiana Feliki hanona eta'u e'abi etibaha, “Abetaina naia, bariu hanona komue koao, rani ha namona kehaea 'eu'uai raninai kapari mueni'o.” ");
INSERT INTO rro_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Rani weianai Feliki eraonana Paulo moni baika ia kebena ba keba karahina, weiana buonai rani bo'ona ebaiuhu Paulo eao terarua te'abi'abi. ");
INSERT INTO rro_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Weiana ihau rua teao murinai Porokio Festo ehore Feliki 'ekana ea'ina. Ia Feliki Iuda haukia aokia keana paunai Paulo wapura itunai ehabona. ");
INSERT INTO rro_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Festo ke'imana hanonai ekara'au ena aka ea'i ramana wapu aihau murinai Kaisareai eao Ierusalema. ");
INSERT INTO rro_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Robe haukia apa'uakia mai Iuda haukia apa'uakia teao herenai ua'a Paulo tehinau aina. ");
INSERT INTO rro_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Festo teba'amena ṯenuatae bariu Paulo keuhuna kemai Ierusalema. Pokina Paulo kekara'au hanona kateba'oru, taearai katehe abuna kateahu 'arina teraonana. ");
INSERT INTO rro_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Ia Festo e'abi etibaha, “Paulo hanona Kaisarea wapura itunai tekai abuna, rani papana haeamona aba kamue kaeao. ");
INSERT INTO rro_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Namona hanona ṯeuai ainimi haukia katemai kipokia kataeao Kaisareai hau weiana mai ena beho re'a katehinau aina.” ");
INSERT INTO rro_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Wapu 'ababani 'ao harau haea 'abana kipokia temiaho murinai Festo eao Kaisarea. Erani eao bakai 'ekanai emiati 'abi euhuna eao Paulo kate maiaina. ");
INSERT INTO rro_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Ba Paulo emai raninai, Iuda haukia Ierusalemai temai haukia teao Paulo tekori kaiarona 'abi bo'okia pumakia 'akikia tehina herenai, ikoikiai a'i mo katebatoha 'abikia 'abaeana. ");
INSERT INTO rro_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Paulo ekia 'abi arana ebamuena etibaha, “Au taba ha a'i ababaina, Iuda haukia ekia rauhubu a'i mo abakai hurina, marea robe abomo a'i a'iki'ana, 'ao Roma ekia obia 'arana Kaisa herenai beho mo ha a'i ababaina.” ");
INSERT INTO rro_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Ia Festo Iuda haukia ketainakia aokia kebanamona ṉa ehoma Paulo ebakaina, “Nonuatae kokara'au koao Ierusalema hinau 'abikia neiakia paukiai ua'a waira'uai kobakai?” ");
INSERT INTO rro_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paulo e'abi etibaha, “Au bariu Kaisa ena bakai 'ekanai nakoroti, au bariu mo neianai mebakaina'u. Pokina oi o'iobi ki'a bahana, Iuda haukia herekiai taba ha a'i a'iki'ana. ");
INSERT INTO rro_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ia pabeho mo ba beho 'arana 'ari pate'uahina, a'i naubo pa'ari. Ia Iuda haukia ekia hinau 'abikia aha'uai tene'eti ikoikiai a'i tetoha, hau ha ena bero aha'i kea'ina'u ia imakiai keutana. Nanoi Kaisa wairanai kakoroti kabakai.” ");
INSERT INTO rro_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Festo bakai haukia kipokia terobahu epua hanona Paulo ehina bena etibaha, “Oi onoi Kaisa herenai buonai koao Kaisa herena kobakai.” ");
INSERT INTO rro_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Wapu baika teao murinai obia 'arana hauna Agripa haibuna Berenike ohi Festo itoana ibanamona paunai teao Kaisarea. ");
INSERT INTO rro_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Rani homa'ana temiaho aonai Festo ehore Paulo robana eahuna obia 'arana Agripa herenai, “Feliki wapura hauna ha ṉa'a ehabona wapura itunai. ");
INSERT INTO rro_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Aeao Ierusalema raninai, robe haukia apa'uakia mai Iuda haukia apa'uakia kipokia temai here'u tehinau tenoina'u kabawapurana. ");
INSERT INTO rro_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ahina benakia atibaha, ‘Roma haukia ekia hoahoa hanona nahomana aha'i, maearima hanona a'i ṯakaiabu 'abaeana keao mo ehinau aina hauna ohi bakai 'ekanai katekoroti ia mai ena bero kipona pouna kehinana.’ ");
INSERT INTO rro_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Kipokia tamai neia raninai, a'i abahoma'ana erani aeao bakai 'ekanai, abaiuhu eao hau weiana kemai, ba emai. ");
INSERT INTO rro_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Tehinau haukia temikiri te'abi raninai beho araonanakia haukia a'i tehina. ");
INSERT INTO rro_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ia ae'emo ekia bahuba'ari taearana te'uri'uri aina mai 'ari hauna ha atana Iesu e'ari weiana Paulo e'abi emauri hauna buonai kipokia tebaiara hauna robana teahuna. ");
INSERT INTO rro_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Taba neiana itabuna ababataina here'uai a'i etaina buonai, Paulo abakaina, kenuatae re'a keao Ierusalema ua'a kebakai. ");
INSERT INTO rro_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","'A enoi ena bakai Kaisa keihana, ua buonai a'abi katekaiabuna wapura itunai kemiaho keaomo kauhuna keao Kaisa herena.” ");
INSERT INTO rro_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Ba Agripa ehore Festo ehina bena etibaha, “Au abomo nanuatae hau weiana aiana kipo'u haia'uai kaona.” Festo ia ena 'abi ebamuena etibaha, “Mara ia aiana aba kona.” ");
INSERT INTO rro_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Erani Agripa mai Berenike ekia habuni namokia mai nuabikia ekia apa'ua hoana ibawaira tinana haukia tebatotonakia, huari poki haukia mai aiara haukia apa'uakia kipokia tetoto teao to'u ituna. Festo ena 'abiai Paulo temaiaina. ");
INSERT INTO rro_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festo emikiri e'abi, “Obia arana haumu Agripa mai towaira tina haumi ikoimiai! Hau neiana ṯoihana. Iuda haukia Ierusalemai ua'a mai neia Kaisareai ṯemiaho haukia maikoina hau neiana here'uai tehinau aina teioaina tetibaha, ‘Ia kemiaho hanona ena namo aha'i, ia ke'ari.’ ");
INSERT INTO rro_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ia beho tabai ke'ari hanona au a'i atabu ahina, haeamona kipona enoina'u ena bakai Kaisa keihana buonai, naraonana kauhuna keao Roma. ");
INSERT INTO rro_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ia a'i na'iobina ahanai 'abi tabana mo karere keao Kaisa herena. Ua buonai amaiaina ikoimiai wairamiai, tohana hana obia 'arana hauna Agripa wairamuai, kahabakai haraina ia 'abina namona kahatabu ahina karerena. ");
INSERT INTO rro_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Naraonana a'i ebero wapura hauna kauhu 'abaeana ia ena beho a'i karere pouna.” ");
INSERT INTO rro_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agripa ehore Paulo ehina bena etibaha, “Aba bero nabeni'o kipomu poumu mohinana.” Ba Paulo imana ea'i taeanakia e'abi etibaha, ");
INSERT INTO rro_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Obia 'arana hauna Agripa e, au kipo'u nababataina bariu rani neianai oi wairamuai akoroti hanona enamo, pokina Iuda haukia ekia hinau 'abikia here'uai hauna kipo'u pouna kahinana. ");
INSERT INTO rro_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Neiana hanona taba tohana, oi o'iobina Iuda haukia ekia hoahoa mai ekia atetua, ua buonai nanoini'o kobai'ima au ka'abi. ");
INSERT INTO rro_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Iuda haukia ikoikiai te'iobina'u ko'iko'i'uai a'iramana emai mo bariu, e'u miaho maurina kipo'u e'u aiarai abomo Ierusalema ai. ");
INSERT INTO rro_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Aba wa'i baha te'iobina'u abomo au hanona Parisea haunai tebaona'u, ekia kuti rauhubukia pahihikia katebabai aokiai au abomo baiatakiai, ia katenuatae hanona katehina pouna. ");
INSERT INTO rro_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Bariu bakai 'ekanai akoroti, pokina Tirama e'abi 'uai 'aba'abaka herekiai hauna nabuabena paunai. ");
INSERT INTO rro_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Itubu harauhaea rua rabi mai mararani Tirama nahakuti aina mai 'abi'uai neiana nahabuabena kerama. Hau apa'uana e, buabeni weiana paunai Iuda haukia au ṯehinau aina'u. ");
INSERT INTO rro_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Taba buonai wai tu'abi Tirama nihore maearima 'ariai nibamikiri muenakia a'i katoa'i taeana ṉa tuho? ");
INSERT INTO rro_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Au abomo ao'uai araonana Iesu Nasareta hauna atana a'oatana ia'i ki'ana akakia bo'ona pababai hanona penamo. ");
INSERT INTO rro_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Au Ierusalemai ua ababai aiho, robe haukia apa'uakia hiabu tebena'u, aeao Tirama ena maearima a'inakia abawapuranakia, abomo kateahu 'arinakia 'abina tehinana au ima'u a'itaeana. ");
INSERT INTO rro_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Rani bo'ona aeao marea ha ha aokiai ahunakia abahaiaranakia, abahobona ahina benakia ekia a'ikakauma kate buniaina, au aopuereai ki'a bahanakia, weiana hanopaka haeai abomo aeao ahunakia. ");
INSERT INTO rro_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Raona neiana paunai au rani ha robe haukia apa'uakia hiabu tebena'u teuhuna'u kaeao Damaseko. ");
INSERT INTO rro_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Obiamu, taearai atiaha tohanai ea ha aihana kupa 'ubinai, ea ki'a baha ba beraura, te'abana'u haukia kipokia ebaea obonamai. ");
INSERT INTO rro_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Ikoimaiai ta'eho 'anoai aia ha aona Heberu maeakia ehina bena'u etibaha, ‘Saulo e, Saulo e, taba buonai au nu'oatana'u? Au nubaki'ana'u hanona kipomu kobahaiarani'o akana nubabaina.’ ");
INSERT INTO rro_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Abakaina atibaha, ‘Obiapaka e, oi tai?’ Obiapaka e'abi, ‘Au Iesu oi nu'oatana'u hau'u. ");
INSERT INTO rro_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Momikiri aemu tohanai mokoroti, au heremuai awaira tina hanona ka'itaeaini'o e'u ta'ara'i haunai koao, bariu oi aea oiha aihona'u abomo wairai kabaihani'o haukia poukia maearima kohina benakia. ");
INSERT INTO rro_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Au Iuda mai rama haeai haukia imakiai oi kabamaurini'o, haeamona kauhuni'o rama haeai haukia herekiai. ");
INSERT INTO rro_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Mahakia kobano'anakia wapurai koba kabanainakia katemai ea, ba Satani ena hiabuai katekabanai katemai Tirama herena, weiana kate a'ikakaumana'u ekia ki'a ihina hao mai ekia 'eka katea'ina Tirama ena maearima robekia baiatakiai.’ ");
INSERT INTO rro_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Obia 'arana haumu Agripa e, kupai aia weiana aona hauna aka'ai tohana. ");
INSERT INTO rro_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Kori'uaina hanona weia Damasekoai, haeamona Ierusalemai mai Iudea aiarakia ikoinai eaomo rama haeai haukia herekiai airoro aina kateraona kabe katemue Tirama herenai, aka namokia katebabainakia weiana ia aba teraona kabe haukia katebatohanakia. ");
INSERT INTO rro_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Weiana buonai Iudea haukia marea robe aonai tea'ina'u, ekia nuatae hanona kateahu 'arina'u. ");
INSERT INTO rro_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Au hanona Tirama ebarai to'ona'u emai mo bariu au wairamiai akoroti nabatohana, maearima papakia 'ao apa'uakia ikoikiai herekiai teihobo. Au nahinana hauna hanona taba hamona mo mahabanai haukia mai Mose ia robana teahuna kerama hauna. ");
INSERT INTO rro_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Keriso hanona kehaiara ba 'ariai kemikiri 'uai, Isaraela haukia mai rama haeai haukia ikoikiai herekiai ena bamauri eana kemaiaina.” ");
INSERT INTO rro_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Paulo kipona pouna nehinana aonai Festo eio etibaha, “Paulo e, oi hanona aba nubeau 'ari, emu aotipa apa'uana ehore aba ebabeau 'arini'o.” Paulo ia ehina bena etibaha, ");
INSERT INTO rro_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","“Festo Apa'uamu e, au hanona a'i nabeau'ari, au nahina haukia hanona 'abi tohakia abomo mai anikia. ");
INSERT INTO rro_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Au ahina 'abikia hanona obia 'arana hauna abomo neiakia e'iobi buonai au mai ao'u ikoinai na'abi. Au a'iobina ia neiakia ikoikiai aba ea'i harainakia, pokina taba neiakia hanona eua'a haiahaiai a'i terama. ");
INSERT INTO rro_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Agripa Obia haumu e, oi mahabanai haukia nubatohanakia? Au a'iobina oi ia nubatohanakia.” ");
INSERT INTO rro_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agripa Paulo ehina bena etibaha, “Rani papana neiana aonai oi nuraonana au Keriso ena maearima ai aba kobaona'u, 'u?” ");
INSERT INTO rro_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Paulo e'abi etibaha, “Rani eko'o ko'o 'ao rani ehoma'a, ia au Tirama nanoina, oi ikupaiamu aha'i, ia aia'u tuona haumi ikoimiai bariu beraura neianai hanona patomai au 'abanai patoao, iamo heremiai tabiri hamona ṉahomana a'i nanuatae aina.” ");
INSERT INTO rro_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Ba Obia 'arana hauna, Kabana hauna, Berenike mai weia temiati haukia ikoikiai temikiri, ");
INSERT INTO rro_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ikaihuri weiana tehabona tekarahi, ha ha te'abi'abi tetibaha, “Hau neiana taba ha a'i ebabai ki'ana weiana ia ke'ari 'ao kewapura hauna a'i ebabaina.” ");
INSERT INTO rro_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agripa ehore Festo ehina bena etibaha, “Hau neiana hanona pahabakarahina, ia Kaisa mo atana ehinana ua'a kebakai.” ");
INSERT INTO rro_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Weiakia ekia raona tebatohana ai hanona aunohi ai kataeao Italia, ba Paulo mai wapura haukia baika hanona huari haukia hinabu ha ne'imanakia hauna ha atana Iulio imanai teutanakia, ia hanona obia 'arana Augusto ena huari hauna ha. ");
INSERT INTO rro_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Ai Adramutio aunohina ha ai taehe'au ba Asia 'abirakia poekia katabeauna tabeau ahi, Aristako Makedonia hauna weia Tesalonika ai emai hauna abomo ai baiatamai ai. ");
INSERT INTO rro_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Erani hanona Sidono ai tabeau'au, ba weia hanona Iulio ena namo hoana Paulo herenai ebabaina ehabona keao ena hau herekia keihanakia ena nuatae tabakia re'a katebena. ");
INSERT INTO rro_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","'Eka weiana tahabona tabeau ahi mue 'akupakanai taeao Kupuro kereibua murinai tabeauna pokina baura wairamaiai emai paunai. ");
INSERT INTO rro_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","'Akupaka 'abaeanai tabeauna Kilikia mai Pamfulia poekia tahabonakia taeao Lukia hanonai 'eka atana Mura ai tabeau 'au. ");
INSERT INTO rro_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Weia hanona huari poki hauna weiana Alesanderea aunohina ha Italia niao hauna etabu ahina, ba weia ebaehe banainamai. ");
INSERT INTO rro_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Wapu bo'ona maharimahari tabeau ba mai aro'arimai taeao Kenido ai tabeau 'au. Emai nuatae 'ekana ṯabeau bena aonai baura wairamaiai emai paunai Salmone pauna tabeau banai tabeau taeao Krete kereibua bunianai. ");
INSERT INTO rro_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Mai aro'arimai poe haiana tabeauna tamai 'eka ha atana ‘Ihoahoa Namoabuna’, 'eka weiana mai Lasea aiarana baiatakia hanona a'i ehoma'a. ");
INSERT INTO rro_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Wapu bo'ona hanona ua'a eore ba rani ena ki'ai 'akuai beau hanona aba keki'a ki'a baha pokina bariu Iuda haukia ekia ani robe ranina hanona aba ekabanai. Ua buonai Paulo eba'iobi baihanakia etibaha, ");
INSERT INTO rro_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Hau ikoimiai e, au eka harima naihana bariu neia keao hanona aba keki'a ki'a baha eka taba rarina hanona kate 'akauma aunohi ke'iti'iti mai eka mauri abomo kahane'enakia.” ");
INSERT INTO rro_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Iamo huari poki hauna Paulo e'abi hanona aiana a'i ebatohana ia aunohi pokina hauna mai aunohi kapena hauna mo aiakia eka'aina. ");
INSERT INTO rro_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","'Amari rarina 'akina aunohi weia ketai'au hanona emai miaho a'i kenamo, ua buonai hau bo'okia hanona tenuatae patabeau ahi mue ba petaina raninai Foenikia ai patabeau 'au ba 'amari rarina ranina hanona weia mo patamiaho. Krete aonai ihoahoa weiana mo enamo pokina ahitaina tibotaina ohi baiatakia mai tototaina tibotaina ohi baiatakia taina ewairana. ");
INSERT INTO rro_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Tibo baurana namona eabu raninai, ia teraonana ekia nuatae baurana aba eabu 'au, buonai to'o teberi 'auna ba Krete poena haiahaiana tabeauna taeao. ");
INSERT INTO rro_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Iamo tabeau ahi homa'ana aha'i hanona baura taburana 'akina atana Kou hanona kereibua tainai eabu 'au emai. ");
INSERT INTO rro_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Kou weiana aunohi etabu ahina raninai, aunohi Kou ketarina hanona a'i etai 'apuana, ua buonai ta'i 'ororo ia baura mo eabunamai taeao. ");
INSERT INTO rro_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Kereibua papana ha atana Kauda abirana ahitainai taru banai raninai, tai'oro papana tatabu ahina, emai 'epi tabiri 'auna aonai aro'ari takaiai haraina. ");
INSERT INTO rro_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Ba ia weiakia 'epi teberi 'auna raninai 'anaua baika aunohi ba'anai teberi banainakia tebiri 'ininakia, weiana Libia poenai bauru ai a'i metoto ta'una parae teba ririnakia mai to'o tane'ena, ba aunohi earu eao. ");
INSERT INTO rro_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Kou ki'a obona hanona ekai 'inina eao wapu ibaruanai hanona maearima ekia taba baika tekapo uhunakia. ");
INSERT INTO rro_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Haeamona eao wapu ibaihaunai hanona aunohi tabana tohakia tekapokapo uhunakia. ");
INSERT INTO rro_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Wapu bo'ona aokiai beraura mai bihiu ha a'i taihana mai Kou pahihina eabu a'i epua 'apua, emai raona eore taraonana a'i katamauri. ");
INSERT INTO rro_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Hau ikoikiai a'i teaniani 'apua rani ehoma'a ki'a murinai Paulo wairakiai ekoroti e'abi etibaha, “Hau ikoimiai e, wai au aia'u patona Krete ai a'i pahabeau ahi raninai, ki'a neiana a'i pahatabu ahina taba ha a'i peki'a mai taba ha a'i pahaba 'akaumana. ");
INSERT INTO rro_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ia bariu au wai nanoinimi, aomi katoba taburanakia, pokina neia hau ha ena mauri a'i ke'akauma, ia aunohi kiponamo ke'akauma. ");
INSERT INTO rro_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Pokina warani rabi e'u Tirama nakuti aina hauna ena aneru euhuna emai here'uai ekoroti, ");
INSERT INTO rro_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ba e'abi etibaha, ‘Paulo e, a'i kota'u. Oi hanona Kaisa wairanai kokoroti kobakai, Tirama ena banamo oi heremuai paunai maearima naiakia aunohiai toehe'au haukia ikoikiai katemauri.’ ");
INSERT INTO rro_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Ua buonai hau ikoimiai aomi katoba taburanakia, au hanona Tirama nabatohana ia ehina bena'u ihobonai kebabaina. ");
INSERT INTO rro_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Iamo aika hanona kaharu kahaeao kereibua ha ai kahabure 'au.” ");
INSERT INTO rro_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Wapu ibaharau haea banina rabinai ai hanona Adria 'akupakai tabure ohomo. Wapuka'a ibuanai aunohi haukia weiana tebabataina hanopaka aba tabarina. ");
INSERT INTO rro_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Buonai 'anaua tebaririna roio ena 'oura tehobona hanona roba harau rua, tamiaho 'apua homa'ana aha'i haeamona 'oura tehobo muena hanona aba emue roba harau haea ima. ");
INSERT INTO rro_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Weia aunohi haukia teta'u emai aunohi piharai a'i meahu 'auna paunai to'o bani tebaririnakia, ba tenuatae perani biai. ");
INSERT INTO rro_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Aunohi ai tiaka haukia tenuatae katebeau 'akauma, 'epi ha tebaririna ba tebai'oi matoha aunohi paunai to'o baika katebaririnakia. ");
INSERT INTO rro_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Aonai Paulo huari haukia mai ekia poki hauna ehina benakia etibaha, “Hau neiakia aunohi ahanai a'i katemiaho raninai wai hanona a'i katomauri.” ");
INSERT INTO rro_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Ua buonai huari haukia 'epi warona tekabe hurina ba tehabona e'eho roioai earu ahina. ");
INSERT INTO rro_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Aba kerani aonai, Paulo ikoikiai enoinakia aniani ha kateana ba e'abi etibaha, “Bariu wapu harau haea bani aba teao wai hanona tobai'ima tomiaho mo taba ha a'i toana. ");
INSERT INTO rro_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Bariu hana nanoinimi aniani baika katoani, katoaniani hanona mauri katoa'ina. 'Aramiai bui ha hamona a'i ke'akauma.” ");
INSERT INTO rro_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Neiana ehinana murinai, Paulo parawa baika ea'inakia ia ikoikiai wairakiai banamo 'abina Tirama herenai ehinana murinai ehobina eani ramana. ");
INSERT INTO rro_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Ikoikiai aokia ebataburanakia kipokia abomo aniani teani. ");
INSERT INTO rro_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Aunohiai taehe'au haumai ikoinai hanona hinabu rua imabui harau rua 'abaihau (276). ");
INSERT INTO rro_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Ikoikiai teaniani eao teani 'ari harai raninai aunohi kateba'ama 'amana hanona aniani tekapo kapo uhunakia 'akuai. ");
INSERT INTO rro_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Rani ererena aonai, hano teihana ia 'eka tabana a'i te'iobina, iamo aopaka ha poe namona teihana, ba aokia tea'ia'i haraina aunohi hanona poe weianai patebahaha 'auna. ");
INSERT INTO rro_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","To'o warokia tekabe hurinakia, to'o tehabonakia 'akuai hari warona tebatataenakia ba parae teberi taeana baura kehao uta kateao poeai katebahaha 'au. ");
INSERT INTO rro_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ia aunohi hanona rema ai ebamia'auna wairana hanona eahu to'ona a'i eibiuibiu 'apua, aonai roio apa'uakia tehore aunohi murina teahu 'iti'itina. ");
INSERT INTO rro_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Huari haukia ekia raona hanona wapura haukia kateahu 'arinakia pokina a'i temena'u 'au a'i temebeau 'akaumana paunai. ");
INSERT INTO rro_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Ia huari haukia ekia poki hauna enuatae Paulo kebamaurina paunai huari haukia ekia raona akana katebabaina hauna ekaiabuna. Ba ehina benakia na'u te'iobina haukia katerobo uhu 'uai katena'u kateao poe. ");
INSERT INTO rro_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Ia harina maikoina hanona aunohi bahana puapuakia tea'i baika aunohi tabana papakia tea'i tena'u. Eṉa tebabai aiho hanona ikoikiai poeai tekara'au mai namokia. ");
INSERT INTO rro_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Ikoimaiai namomai poeai takoroti raninai ta'iobina kereibua weiana atana hanona Melita. ");
INSERT INTO rro_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Kereibua weiana haukia terabo harai heremaiai. Abara etibo mai 'ama rarina buonai ia iruba teba'arana ikoimai haumai ehiabu tea'i taeanamai. ");
INSERT INTO rro_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Paulo matiu mai i'akena ea'ina iruba ahanai ehore 'auna, 'erau iruba hiabuna eonobaina hanona erobo ahi Paulo imanai e'uri to'o ekapa oreore. ");
INSERT INTO rro_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Kereibua weiana haukia 'erau Paulo imanai teihana raninai ha ha te'abi tetibaha, “Pa'e hau neiana hanona ahuahu hauna, 'akuai a'i e'ari maurinai ekara'au, bariu neiana erama hanona ena beho 'arana.” ");
INSERT INTO rro_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","'A Paulo ehore imanai 'erau weiana ebaure obona eao iruba aonai e'eho, ia haiara ha a'i eonobaina. ");
INSERT INTO rro_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Maearima weia haukia teraonana imana kebua 'ao kebata'u ke'eho ke'ari, ia tebai'ima rani ehoma'a ia herenai taba ha a'i erama, ba aokia tebahaeaina tetibaha, “Ia tirama mo ha.” ");
INSERT INTO rro_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Ia temiaho herena tainai ua'a hanona kereibua obiana hauna atana Pubilio ena 'eka, mai aonamona ebakara'aunamai ena ituai, ba wapu aihau ai hanona ia ena baki haumai e'ima harainamai. ");
INSERT INTO rro_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Weiana Pubilio hamana hanona enoti itu aonai, ena inawa hanona hau hiabu mai me'ime'i, Paulo eao ena ikaihuri aonai etoto ahanai ebahuba'ari, imana ia ahanai ehao 'au ena inawa enamo. ");
INSERT INTO rro_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Hoa weiana erama murinai inawa maearimakia kereibua weiana aonai haukia ikoikiai temai ba eba namonakia. ");
INSERT INTO rro_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Temariki ainamai taeara haeaihaeai ai tebanamonamai, abomo katabeau ahi raninai taearai tanuatae ainakia tabakia ikoikiai hanona teuta 'aunakia. ");
INSERT INTO rro_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Nawa aihau murikiai ai hanona Alesanderea aunohinai taehe 'au tabeau ahi 'akupakai. Aunohi atana hanona ‘Bai'apaea’, weiana hanona 'ama rarinai kereibuai weia etai'au emiaho. ");
INSERT INTO rro_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Surakuse ai takara'au, weia tamiaho wapu aihau. ");
INSERT INTO rro_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Weia emai parae takaina tabeau ahi taeao Regio ai tabahaha 'au, erani hanona baruru eabu, ba tabeau ahi wapu ibaruanai hanona ai Puteoli ai tabeau 'au. ");
INSERT INTO rro_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Weia uaho'abaka baika tatabu ahinakia, tebaka'anamai taeao herekiai tamiaho hui hamomo, weia tamikiri hanona taeao Roma. ");
INSERT INTO rro_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Uaho'abaka baika weia poumai teona hanona temai mo aiara baika wairai atakia ‘Apio kawakawa 'ekana’ mai ‘Pariki aihau’ hanona weia kipokia tabaitabu ahi. Paulo hau neiakia eihanakia raninai Tirama ebanamona abomo aona ekiro. ");
INSERT INTO rro_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Roma ai takara'au raninai Paulo hanona ikupaiana ena 'eka teba haeaina, huari hauna ha ia ke'imana. ");
INSERT INTO rro_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Wapu aihau teore murikiai Paulo ehore Iuda te'uai aina haukia eaparinakia teto'u aonai, Paulo emikiri e'abi etibaha, “Uaho'aba'u ikoimiai, au eka maearima a'i mo abareana 'ao 'aba'abaka ekia hoahoa a'i mo abakai hurina, ia au hanona weia Ierusalema ai ia tebirina'u Roma haukia imakiai teutana'u. ");
INSERT INTO rro_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Roma haukia tebakaina'u ekia nuatae kateba karahina'u pokina ki'a ha a'i tetabu ahina weia au ka'ari. ");
INSERT INTO rro_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ia Iuda haukia bakai ena 'abi tebaki'a, au hanona tebahi ahina'u mo Kaisa atana ahinana, wairanai kakoroti kabakai ṉaho. 'A au e'u maearima kahinahina ainakia hanona aha'i. ");
INSERT INTO rro_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Neiana paunai au aparinimi kaihanimi mai kipokia kaha'abi'abi. Isaraela maearimakia ia ṯebuabena hauna buonai tabiri neiana au aha'uai.” ");
INSERT INTO rro_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Ia ena 'abi tebamuena tetibaha, “Oi 'abimu marerena weia Iudea ai ha a'i emai a'i tatabu ahina, 'ao uaho'abaka abomo ua'a ha 'abi a'i emaiaina 'ao oi emu babai ki'a obona ha pouna a'i ehinana. ");
INSERT INTO rro_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Bariu ai hanona ṯanuatae oi emu raona 'abina kohinana aiamu kataona, pokina ai ta'iobina oi a'ito'u naiana nubabaina hauna eka maikoina maearima a'i ṯenuatae aina.” ");
INSERT INTO rro_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Ba Paulo mai to'u haukia kipokia wapu ha teba'oruna, wapu weiana etaina hanona maearima bo'ona tera'a temai Paulo nemiaho 'ekanai teto'u mo raurani eaomo erabi. Paulo ehore Tirama ena obia aiarana hauna robana eahuna maearima herekiai mai Iesu pouna Puka robenai tererena hauna eba'iobi aina Mose ena rauhubu pukakia aokiai mai mahabanai haukia ekia pukakiai. ");
INSERT INTO rro_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Maearima baika ena 'abi teona hanona aokia eaoaina, 'a baika hanona ena 'abi a'i tea'i taeana. ");
INSERT INTO rro_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Aokia a'i ehamona katera'a, ekia ra'ai Paulo 'abi hamona neiana ehinana e'abi etibaha, “Auba Robe Isaia mahabanai hauna pinana hama ehina harai ki'a bahana 'aba'abami herekiai etibaha, ");
INSERT INTO rro_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Moao maearima neiakia herekiai kotibaha, Aia neiana kato'o o'o bena ia obona a'i katobo, katoihaiha bena ia a'i katoiha tinana. ");
INSERT INTO rro_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Pokina uru neiana haukia aokia hanona tetubu abu haiakia hanona tepo'o, mahakia te'iau. Ua a'i katehoma raninai, mahakiai kateihana, haiakiai kateona, aokia kate'iobi, kateraona kabe katekabe katemai here'u au mauri kabenakia.’ ");
INSERT INTO rro_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Ua buonai kato'iobi haraina, Tirama ena bamauri 'abina hanona aba euhuna rama haeai haukia herekia, ia kateona.” ");
INSERT INTO rro_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","(Paulo ua e'abi aiho murinai Iuda haukia terama otaraina, 'a ikoikiai 'abi weiana kipokia tebaiara aina.) ");
INSERT INTO rro_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Paulo ihau maikoikia rua weia emiaho, itu emiaho aina hauna kipona 'arana ehorena, herena temai kateihana haukia ea'i taeanakia. ");
INSERT INTO rro_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Ia Tirama ena obia aiarana 'abina eiroro aina mai Obiapaka Iesu Keriso pouna eba'iobi aina mai taburana, hau ha a'i ekaiabuna. ");
INSERT INTO rro_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Au Paulo e'u marere neiana. Iesu Keriso ena ta'ara ia'ina hau'u, ena iuhubeau haunai kaeao paunai Tirama etina'ana'u eaparina'u ena pou namona kairoro aina. ");
INSERT INTO rro_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Pou namona neiana hanona Tirama ehore aba wa'i baha e'abi'uai aina ena mahabanai haukia pinakiai tehinana Puka Robena aonai tererena, ");
INSERT INTO rro_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","ia Nahuna pouna, eka Obiapaka weiana Iesu Keriso, hauaniai hanona Davida nininai erama, ");
INSERT INTO rro_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","ia aubana robenai hanona 'ariai ebamikirina raninai ebatohana mai hiabuna ia hanona Tirama Nahuna. ");
INSERT INTO rro_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Iesu Keriso paunai mai ia atanai baraibarai apa'uana abomo iuhubeau hoana aba ta'ina, weiana rama haeai haukia baiatakiai maearima ikoikiai kataparinakia a'ikakaumai aia kateka'ai. ");
INSERT INTO rro_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Wai abomimo weia Iesu Keriso 'eunai Tirama ehore eaparinakia haukia baiatakiai. ");
INSERT INTO rro_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Roma ai ṯomiaho Tirama eraona'au ainimi eaparinimi ena maearimai ebaonimi haumi ikoimiai, Hamaka Tirama mai Obiapaka Iesu Keriso herekiai aoko'o hoana abomo baibua katoa'ina. ");
INSERT INTO rro_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","E'u 'abi kori 'uaina neiana: Iesu Keriso atanai e'u Tirama nabanamona wai ikoimiai paumiai, pokina wai emi a'ikakauma pouna hanopaka ikoinai aba teona. ");
INSERT INTO rro_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Tirama weiana Nahuna pouna namona nairoro aina aonai ta'arana ṉa'i mai ao'u ikoinai hauna e'iobina e'u bahuba'ari ai au wai naraonanimi, ");
INSERT INTO rro_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","rani ikoinai e'u bahuba'ari ai Tirama nanoina ena nuataeai taeara'u pekaikauna rani ha pawahi paihanimi. ");
INSERT INTO rro_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Pokina au nanuatae ki'a baha kaihanimi, auba ena beruberu kabaibeni katotabura. ");
INSERT INTO rro_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Weiana hanona au mai wai kipoka kahabarainaka, eka a'ikakaumai ha ha kahataburanaka. ");
INSERT INTO rro_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Uaho'aba'u e, au nanuatae wai kato'iobina, rani bo'ona anuatae kawahi heremi, buabua katabu ahi ihobona rama haeai haukia baika ekia mauri tebaibeni aihanakia 'abana, ia taba baika tehore tekaiabuna'u emaimo bariu. ");
INSERT INTO rro_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Au hanona pou namona ihinanai 'ara kahore maearima ikoikiai herekiai, Helene haukia mai ea aha'i haukia abomo ao 'abaea haukia mai aotipa haukia herekiai. ");
INSERT INTO rro_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Weiana buonai au nanuatae ki'a baha wai Roma ai ṯomiaho haumi wairamiai abomo pou namona kairoro aina. ");
INSERT INTO rro_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Au pou namona a'i nahaumaea aina, pokina ia hanona Tirama ena hiabu, a'ikakauma haukia ikoikiai kebamaurinakia kori'uaina hanona Iuda haukia, muriai hanona rama haeai haukia. ");
INSERT INTO rro_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Pokina pou namona aonai bero Tirama herenai emai hauna ewaira tina, kaha'i ramana a'ikakaumai keaomo puana, puka robenai tererena 'abana, “Aka bero hauna hanona a'ikakaumai kemauri.” ");
INSERT INTO rro_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Maearima ekia kamuri mai babai ki'a paukiai Tirama ena opuere kupai emai ewaira tina, weiakia ekia babai ki'ai 'abi tohana tihao parena haukia herekiai. ");
INSERT INTO rro_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Tirama i'iobina hanona aba emahanai harai herekiai, pokina Tirama ehore ebaihanakia. ");
INSERT INTO rro_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Hanopaka erama popounai emaimo bariu Tirama 'eunai a'i nahaihanakia tabakia ena hiabu banai banai mai ena auba maurina hanona ia ebabai tabakia aokiai tewaira tina harai teihanakia te'iobinakia, weiana paunai maearima kebuniai hanona taearana aha'i. ");
INSERT INTO rro_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Tirama te'iobina iamo a'i tea'i taeana abomo a'i tebanamona ia hanona Tirama, ia ekia ao 'abaea mai ekia ao po'oai wapura ehore aokia ekaiabuna. ");
INSERT INTO rro_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Ia kipokia teraonana teaotipa, iamo po'o haukiai teao. ");
INSERT INTO rro_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Miaho banai banai Tiramana ikuti aina tehabona, ia maearima aubaubakia a'i katemiaho banai banai haukia, roborobo, mahi, mai tikara tabakia haukia, aubaubakia imakiai tebabai tabakia tekuti ainakia. ");
INSERT INTO rro_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Weiana buonai Tirama ehore aokiai ki'a tenuatae ainakia 'ekanai ehabonakia, weiana kipokia ekia babai ki'a obokia parikia akakia katebabai ha ha herekia. ");
INSERT INTO rro_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Tirama ena 'abi tohana hanona ia tehore bai'oi tabanai tebaona, iamo 'ekanai hanona taba ebarama tabakia tekuti ainakia ta'arakia tea'i. Iamo ebabainakia hauna Ia ikupaiana kahabanamona keaomo banai banai. Amen. ");
INSERT INTO rro_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Tirama ehore ehabonakia teao ekia babai ki'a obokia aonai. Ekia babi'e tehore babi'e tenabau ainakia weiana ua a'i pehoma hauna tebabaina. ");
INSERT INTO rro_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Taeara ihobonai hau abomo babi'e kipokia hawainibena tehabona, ia hau tehore hau tenuatae ai ki'anakia. Hau kipokia 'abakia herekiai babai ki'a obokia tebabai. Weiana hanona ekia babai ki'a 'arana kipokia pumana tehoa aina. ");
INSERT INTO rro_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Ia tehore aokiai Tirama iraona 'ininai a'i tenuatae aina, weiana Tirama ehore ekia ao 'abaeai ehabonakia, a'i patebabai akakia tebabai. ");
INSERT INTO rro_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Aka ki'a obokia haeai haeai aokia tebonu, babai ki'a obokia, uhore mai raona ki'a obokia, wamuru, ahuahu, 'au, bai'oi mai ao bahaiara akakiai tebonu. Ṯeuahiuahi, ");
INSERT INTO rro_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","mai 'abi'abiai ha ha atakia tia'i ki'anakia, Tirama ti'oatana, tiaiahu 'abaea, tiapa, abomo tibaro'e, raona ki'a obokia 'eka baikai tiraonanakia katebabai. Hamakia mai hinakia aiakia a'i tio'o. ");
INSERT INTO rro_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Ia hanona ekia raonaraona aha'i, ekia 'abi'uai a'i tibatohanakia, mai maearima herekiai namo 'ao aoko'o a'i tiba ihanakia. ");
INSERT INTO rro_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Tirama ena rauhubu aba te'iobina maearima 'eka ua homanai ṯemiaho haukia hanona kate'ari. Ia ki'a weiakia tibabai to'o baihanakia abomo maearima baika tibabai raninai tiaonamo ainakia. ");
INSERT INTO rro_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Weiana buonai 'abiai hau ha behoai nuhorotina haumu, emu bero 'abina ha aha'i. Oi 'abiai hau ha behoai nuhorotina hanona kipomu puma nubeni'o. Pokina ia behoai ohorotina akana ihobonai oi abomo nubabaina. ");
INSERT INTO rro_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Aika ha'iobina Tirama hanona mai ena bero ua tibabai aiho haukia behoai kehorotinakia. ");
INSERT INTO rro_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Weiana oi 'abiai hau ha behoai nuhorotina ia akana ihobona nubabaina haumu, oi nuraonana Tirama behoai kehorotini'o 'ekanai aba kokapare, u? ");
INSERT INTO rro_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","'Ao aehoma a'i o'iobina Tirama ena namo apa'uana weiana ehore e'uai aini'o raona kabe taearanai ena namo apa'uana, ena baiha hao mai ena bakiro oiha ta'erainakia? ");
INSERT INTO rro_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Ia aomu etubu, emu raona kabe aha'i paunai oi kipomu emu puma nubararona, Tirama ena opuere mai ena bero bakai beraurana kekara'au raninai emu puma weia kewaira tina. ");
INSERT INTO rro_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Tirama kehore maearima ha ha ekia babai ihobohobokiai arakia kebenakia. ");
INSERT INTO rro_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Maearima baika aka namokiai tibapahihi haukia abomo nuabi mai mariki abomo a'i kepua maurina titabuna haukia hanona Tirama kehore mauri banaibanai kebenakia. ");
INSERT INTO rro_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Ia maearima baika tiani ki'a mai 'abi tohana tibaoao aina, aka behokia tia'i taeanakia haukia hanona Tirama ena opuere mai ena puma ahakiai kebaririna. ");
INSERT INTO rro_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Aka ki'a obona tibabaina haukia ikoikiai hanona atetua mai haiara katehoaina Iuda haukia mo aha'i rama haeai haukia abokia mo. ");
INSERT INTO rro_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Ia aka namona tibabaina haukia ikoikiai hanona Tirama kehore nuabi, mariki mai baibua kebenakia, kori'uaina hanona Iuda haukia, muriai hanona rama haeai haukia. ");
INSERT INTO rro_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Pokina Tirama hanona maearima ha a'i nitaina. ");
INSERT INTO rro_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Mose ena rauhubu kapenai ṯemiaho haukia tiaka ki'a hanona weianai aka ki'a haiarana katea'ina, 'a rauhubu aonai ṯemiaho haukia tiaka ki'a hanona rauhubu kebabakainakia. ");
INSERT INTO rro_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Rauhubu uruna tio 'abaeana haukia hanona Tirama wairanai bero a'i katea'ina, ia rauhubu akana tibabaina haukia hanona berokia kehinana. ");
INSERT INTO rro_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Rama haeai haukia herekiai Mose ena rauhubu aha'i, ia aokiai rauhubu hoana ihobona tebabaina raninai, rauhubu herekiai aha'i re'a, ia kipokia rauhubuai teao. ");
INSERT INTO rro_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Ia aokiai rauhubu 'abina tererena hauna ekia hoahoai niwaira tina aokia abomo weiana nibatohana, ekia raonaraona weiana nihore behokia nehinana 'ao berokia nehinana. ");
INSERT INTO rro_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Pou namona airoro aina ihobonai, beraurana kekara'au raninai Tirama kehore maearima ekia raona bunikia kebakainakia Iesu Keriso paunai. ");
INSERT INTO rro_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Ia wai kipomi tu'abi Iuda haumi, rauhubuai tukori 'ini abomo Tirama tuapaina, ");
INSERT INTO rro_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","abomo Tirama taba nenuatae aina hauna to'iobina mai bero nimai 'ekana to'iobina pokina wai rauhubu tomarere aina. ");
INSERT INTO rro_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Turaonana wai hanona maha'iau haukia ibaka'a haraikia mai wapurai ṯemiaho haukia ekia ea ");
INSERT INTO rro_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","abomo po'o haukia irobekia mai a'i temarere haukia iba'iobikia haumi, pokina rauhubu aonai aotipa mai 'abi tohana maikoinai totabu ahinakia. ");
INSERT INTO rro_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","'Abami tuba'iobinakia ia aehoma wai kipomi a'i tubatohana? Ṯoiroro a'i katebainao, ia wai tubainao? ");
INSERT INTO rro_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Tu'abi a'i katenabau, ia wai tunabau? Kaiba'uku 'arikia a'i tu'ari, ia wai ro'e aona tabakia tubainao ainakia? ");
INSERT INTO rro_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Wai rauhubu nemiaho paunai tuapa, ia rauhubu tukabena hanona Tirama atana tua'i ki'ana. ");
INSERT INTO rro_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Puka robena aonai e'abi, “Wai Iuda haumi paumiai rama haeai haukia Tirama atana tia'i ki'ana.” ");
INSERT INTO rro_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Rauhubu koka'ai haraina raninai emu itare hanona namo kebeni'o, ia rauhubu kokabena raninai oi hanona ihobona itare a'i oa'ina 'abana. ");
INSERT INTO rro_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Rama haeai hauna ha a'i tetarena ia Tirama ena rauhubu 'abina keka'ai haraina raninai Tirama kehore itare ea'ina haunai kebaona. ");
INSERT INTO rro_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Weiana hauaniai a'i etarena ia rauhubu eka'ai haraina hauna kehore oi Iuda haumu behoai kehorotini'o, pokina rauhubu tererena hauna heremuai abomo itare oa'ina ia rauhubu nukabena. ");
INSERT INTO rro_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Maearima hauaniai ihaihana Iuda hauna ia Iuda hauna tohana aha'i abomo hauaniai itare tea'ina hanona itare tohana aha'i. ");
INSERT INTO rro_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","'A aona nibamaha mahana hauna ia hanona Iuda hauna tohana, abomo itare hanona aoai kebabaina Auba Robeai, ia rauhubuai aha'i. Maearima uahomana hanona banamo Tirama herenai kea'ina, ia maearima herekiai aha'i. ");
INSERT INTO rro_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Uahomana raninai Iuda haukia ekia namo hanona taba? Itare ena namo hanona taba? ");
INSERT INTO rro_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Taeara bo'okiai. Kori 'uaina hanona Tirama ena 'abi Iuda haukia herekiai ehorotina kate'imana. ");
INSERT INTO rro_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Weiana baika ekia a'ikakauma peaha'i raninai aehoma? Ekia a'ikakauma aha'i buonai Tirama kipona ena 'abi'uai a'i kebatohana, u? ");
INSERT INTO rro_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Ua a'i kehoma. Maearima ikoikiai katebai'oi, ia Tirama ikupaiana keibatoha. Puka robenai tererena ihobona, “Emu 'abiai kobatohani'o obero. Weiana kateba bakaini'o raninai kotara haonakia.” ");
INSERT INTO rro_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","'A aika eka ki'a kehore Tirama ena babai berona kebawaira tinana raninai, taba ṉa kahahoma? Weiana Tirama puma 'ekanai nihorotinaka hanona nibeho, u? Aha'i. Ua a'i kehoma. (Neiana hanona maearima ekia raonaraona nahinana.) ");
INSERT INTO rro_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Ua homana aha'i. Tirama a'i kebero raninai, hanopa