﻿USE sofia;
DROP TABLE IF EXISTS sofia.row_vpl;
CREATE TABLE row_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES row_vpl WRITE;
INSERT INTO row_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Fefeu na, Lamatualain naꞌadadadꞌiꞌ lalai no raefafoꞌ a. ");
INSERT INTO row_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Leleꞌ naa, raefafoꞌ a nda feꞌe dadꞌi sa, ma basaꞌ e feꞌe runggu-ranggaꞌ. Feꞌe akaꞌ a, oeꞌ ma maꞌahatuꞌ a tatana nala e. Lamatualain Dula-dale Na laa-laa sia oeꞌ ata. ");
INSERT INTO row_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Boe ma, Lamatualain olaꞌ nae, “Manggareloꞌ dadꞌi.” Ana olaꞌ basa ma, manggareloꞌ a dadꞌi tuteꞌ a. ");
INSERT INTO row_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ana nita manggareloꞌ a ma, rala Na namahoꞌo, huu saa fo Eni taoꞌ naa, maloleꞌ. Basa de, Ana tadꞌa manggareloꞌ mia hatuꞌ a, de esa-esaꞌ no fai na. ");
INSERT INTO row_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ana babꞌae manggareloꞌ a ‘rereloꞌ’, ma hatuꞌ a, ‘tetembaꞌ’. Naa, fai kaesa na. ");
INSERT INTO row_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","7","Basa ma, Lamatualain olaꞌ seluꞌ nae, “Mamana rouꞌ sa dadꞌi, fo tadꞌa oeꞌ a. Naa fo, hambu oeꞌ sia ataꞌ, ma sia raeꞌ boe.” Ana olaꞌ basa ma, oeꞌ a banggi neu rua tuteꞌ a. ");
INSERT INTO row_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ana babꞌae oeꞌ mana sia ataꞌ a, ‘lalai’. Naa, fai karua na. ");
INSERT INTO row_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Basa ma, Lamatualain olaꞌ seluꞌ fai nae, “Oe mana sia raeꞌ a musi naꞌabꞌue neu mamanaꞌ esa, fo hambu rae madꞌa.” Ana olaꞌ basa ma, rae madꞌa a dadꞌi tuteꞌ a. ");
INSERT INTO row_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Ana babꞌae rae madꞌa a, ‘madꞌa ata’; ma oe mana maꞌabꞌueꞌ a, ‘tasiꞌ’. Ana nita basa naa ra ma, rala Na namahoꞌo, huu saa fo Eni taoꞌ naa ra, memaꞌ maloleꞌ. ");
INSERT INTO row_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Boe ma, Lamatualain olaꞌ seluꞌ fai nae, “Hau-hau musi mori sia madꞌaꞌ ata. Musi hambu hau mabꞌoaꞌ, madekeꞌ, ma maroo modꞌoꞌ. Naa fo, hau ra esa-esaꞌ mbule-bꞌoa na tungga mata na.” Ana olaꞌ basa ma, basa hau ra dadꞌi tuteꞌ a. ");
INSERT INTO row_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ma hau naa ra mbule-bꞌoa nara esa-esaꞌ tungga mata na, losa rasofe madꞌaꞌ ata. Ana nita basa naa ra ma, rala Na namahoꞌo, huu saa fo Eni taoꞌ naa ra, memaꞌ maloleꞌ. ");
INSERT INTO row_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Naa, fai katelu na. ");
INSERT INTO row_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","15","Boe ma, Lamatualain olaꞌ seluꞌ fai nae, “Sia ataꞌ musi hambu manggareloꞌ mataꞌ-mataꞌ fo raronda neu raefafoꞌ ia. Musi hambu mana fee manggareloꞌ neu fai rereloꞌ, ma mana fee manggareloꞌ neu fai tetembaꞌ. Basa naa ra, dadꞌi tatandaꞌ fo bisa reken fai, too, no fula-fai.” Ana olaꞌ basa ma, manggareloꞌ ra dadꞌi tuteꞌ a. ");
INSERT INTO row_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Ana tao manggarelo monaeꞌ mataꞌ rua. Manggarelo monaeꞌ a naronda rereloꞌ ma manggarelo anadikiꞌ a naronda tetembaꞌ. Ana o tao nduuꞌ ra boe. ");
INSERT INTO row_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Ma Ana ator basa naa ra sia lalai, fo raronda neu raefafoꞌ a. ");
INSERT INTO row_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","De ara fee manggareloꞌ neu rereloꞌ ma tetembaꞌ. No taꞌo naa, ara tadꞌa manggareloꞌ mia hatuꞌ a. Ana nita basa naa ra ma, rala Na namahoꞌo, huu saa fo Eni taoꞌ naa ra, memaꞌ maloleꞌ. ");
INSERT INTO row_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Naa, fai kahaa na. ");
INSERT INTO row_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Basa ma, Lamatualain olaꞌ seluꞌ fai nae, “Banda mataꞌ-mataꞌ musi rasodꞌa sia oeꞌ rala. Ma mbuiꞌ mataꞌ-mataꞌ musi ratambembele sia raefafoꞌ ata.” ");
INSERT INTO row_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Boe ma Ana naꞌadadadꞌiꞌ basa uꞌu mataꞌ-mataꞌ no banda monaeꞌ mana rasodꞌa sia oeꞌ. Ana o naꞌadadadꞌiꞌ mbuiꞌ mataꞌ-mataꞌ fo ratambembele sia lalai. Ana nita basa naa ra ma, rala Na namahoꞌo, huu saa fo Eni taoꞌ naa ra, memaꞌ maloleꞌ. ");
INSERT INTO row_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Basa ma Ana olaꞌ fee papala-babꞌanggiꞌ neu basa banda ra nae, “Uꞌu ra musi ramaheta, fo rasofe oeꞌ a sia bee-bꞌee. Ma mbuiꞌ ra o musi ramaheta boe.” ");
INSERT INTO row_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Naa, fai kalima na. ");
INSERT INTO row_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","25","Basa ma, Lamatualain olaꞌ seluꞌ fai nae, “Banda mataꞌ-mataꞌ musi rasodꞌa sia madꞌaꞌ ata. Musi hambu banda neꞌebꞌoiꞌ, banda fui, ma banda mana nodꞌoꞌ sia rae, esa-esaꞌ no mata na.” Ana olaꞌ basa ma, basa se dadꞌi tuteꞌ a. Ana nita basa se ma, rala Na namahoꞌo, huu saa fo Eni taoꞌ naa ra, memaꞌ maloleꞌ. ");
INSERT INTO row_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Basa ma Lamatualain olaꞌ seluꞌ fai nae, “Ima fo Ata tao atahori tungga onaꞌ Hita boe. Naa fo, ara tao mataꞌ neu uꞌu ra sia tasi, mbuiꞌ ra sia lalai, banda neꞌeboiꞌ ra, ma basa banda feaꞌ mana masodꞌa sia raefafoꞌ a.” ");
INSERT INTO row_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Boe ma Ana naꞌadadadꞌiꞌ atahori onaꞌ mata ao Na boe. Ana naꞌadadadꞌiꞌ se, touꞌ no inaꞌ. ");
INSERT INTO row_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ma Ana olaꞌ fee se papala-babꞌanggiꞌ nae, “Hei musi bꞌonggi mimihefu, fo misofe raefafoꞌ ia, ma tao mataꞌ neu e. Au o fee hei koasa fo tao mataꞌ neu uꞌu ra, mbuiꞌ ra, ma basa banda madꞌaꞌ ata ra. ");
INSERT INTO row_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Rena malolole! Au fee hei nanaat mataꞌ-mataꞌ sia raefafoꞌ ia. Au fee hau mabꞌoaꞌ, madekeꞌ, ma maroo modꞌoꞌ ra. ");
INSERT INTO row_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Au o fee basa hau mataꞌ-mataꞌ, fo dadꞌi basa banda ra nanaat na. Nanaat soaꞌ neu banda neꞌeboiꞌ, banda fui, banda mana nodꞌoꞌ, ma mbuiꞌ ra.” Ana olaꞌ basa ma, basa nanaat mataꞌ-mataꞌ dadꞌi tuteꞌ a. ");
INSERT INTO row_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ana nita basa naa ra ma, rala Na namahoꞌo, huu saa fo Eni taoꞌ naa ra, memaꞌ maloleꞌ. Naa, fai kanee na. ");
INSERT INTO row_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","No dalaꞌ naa, Lamatualain tao lalai no raefafoꞌ, no basa isi-oe na. ");
INSERT INTO row_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Mbilaꞌ neu ma, ndaa no fai kahitu na, Ana hahae ao Na, huu tao nala basaꞌ e ena. ");
INSERT INTO row_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","No taꞌo naa, Ana tao fai kahitu na dadꞌi fai monaeꞌ mia fai feaꞌ ra, huu Ana tao basa ue-tatao Na ena, de fai kahitu na ma, Ana hahae ao Na. ");
INSERT INTO row_vpl VALUES ("GN2_4a","002_2_4a","GEN","2","4a","4a","Lamatualain naꞌadadadꞌiꞌ lalai no raefafoꞌ dudꞌui na, taꞌo a naa. ");
INSERT INTO row_vpl VALUES ("GN2_4b","002_2_4b","GEN","2","4b","4b","Leleꞌ LAMATUALAIN naꞌadadadꞌiꞌ lalai no raefafoꞌ a, ");
INSERT INTO row_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","6","nda feꞌe hambu hau-bebꞌa saa saꞌ boe, huu Ana nda feꞌe naꞌondaꞌ udꞌan sa. Leleꞌ naa, feꞌe akaꞌ a lumeꞌ a namasu mia rae fo naꞌadꞌoe raefafoꞌ. Ma nda feꞌe hambu atahori fo tao osi sa. ");
INSERT INTO row_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Dei de LAMATUALAIN haꞌi rae mbei, de tao dadꞌi atahori. Ana fuu ani-hahaeꞌ tungga mbana ndola na, ma atahori a nasodꞌa tuteꞌ a. ");
INSERT INTO row_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Basa ma, LAMATUALAIN tao osi esa mia rae Eden seriꞌ rulu, de Ana fee atahori a leo sia naa. ");
INSERT INTO row_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Ana naꞌadadadꞌiꞌ hau huuꞌ maloleꞌ mataꞌ-mataꞌ sia osi a, fo atahori a naa no maladꞌaꞌ. Ma Ana o tao hau huuꞌ mataꞌ rua sia osi a taladꞌa na. Mete ma atahori raa hau esa boa na, ara rasodꞌa rakandoo. Te mete ma ara raa hau esa ka boa na, ara rahine bee maloleꞌ ma bee deꞌulakaꞌ. ");
INSERT INTO row_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Hambu loe sa nandali mia osi a, de dea neu. Loe naa, masaranggaaꞌ haa. ");
INSERT INTO row_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Ranggaꞌ kaesa na, naran Pison. Ranggaꞌ naa nandali rereoꞌ rae Hawila. Sia naa, hambu lilo naeꞌ. ");
INSERT INTO row_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Lilo naa ra meuꞌ. Sia naa o hambu hau raa maꞌameniꞌ ma fatu makahadꞌoꞌ. ");
INSERT INTO row_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ranggaꞌ karua na, naran Gihon. Ranggaꞌ naa nandali rereoꞌ rae Kus. ");
INSERT INTO row_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ranggaꞌ katelu na, naran Tigris. Ranggaꞌ ia, dadꞌi tadꞌaꞌ sia rae Asyur seriꞌ rulu. Ma rangga kahaa na, naran Efrat. ");
INSERT INTO row_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","LAMATUALAIN fee atahori a leo sia Eden, fo tao mataꞌ neu osi a. ");
INSERT INTO row_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ma Ana parenda e nae, “Ho sudꞌiꞌ a mua hau boaꞌ saa mia basa hau huuꞌ sia osi ia. ");
INSERT INTO row_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Te akaꞌ na, afi mua hau boaꞌ mia hau huuꞌ mana fee nggo muhine bee maloleꞌ ma bee deꞌulakaꞌ. Mete ma mua, naa, mate nggo.” ");
INSERT INTO row_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Basa ma, LAMATUALAIN olaꞌ seluꞌ nae, “Nda maloleꞌ sa atahori ia nasodꞌa mesaꞌ ne. De Au ae tao fee ne, nonoon esa fo ndaa no e.” ");
INSERT INTO row_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","20","Leleꞌ naa, LAMATUALAIN ao nala rae mbei, de tao banda ma mbuiꞌ mataꞌ-mataꞌ. Ana nendi se risiꞌ atahori a, fo nanara se. Boe ma, atahori a nanara se, esa-esaꞌ no nara na. Te ana nda feꞌe hambu nonoon sa. ");
INSERT INTO row_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","De LAMATUALAIN fee atahori a sungguꞌ nasambeta, de haꞌi nala rui aiusu na esa. Dei de, Ana mbalu baliꞌ bisu a. ");
INSERT INTO row_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ma Ana tao ruiꞌ naa dadꞌi inaꞌ, de fee neu atahori a. ");
INSERT INTO row_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Atahori a nita inaꞌ a ma, ana nae, “Ia dei, fo ndaa no au! Rui na o, onaꞌ au rui ngga boe. Ma ao sisi na, onaꞌ au ao sisi ngga. Huu eni dadꞌi mia touꞌ, naa de au babꞌae e ‘inaꞌ’.” ");
INSERT INTO row_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Huu naa, touꞌ musi lao hela ina-ama nara, fo nasodꞌa ralaꞌ esa no sao na, te ruꞌa se dadꞌi esa ena. ");
INSERT INTO row_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Leleꞌ naa, ruꞌa se maꞌaholaꞌ, te ara nda mae saꞌ. ");
INSERT INTO row_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Mia basa banda fo LAMATUALAIN tao sia raefafoꞌ ia, mengge a nahine pepeko-lelekoꞌ lenaꞌ basa e. Lao esa, hambu mengge sa natane inaꞌ a nae, “Tebꞌe, do? Lamatualain ai hei nae, ‘Afiꞌ mia hau boaꞌ mana sia osi ia, to?’” ");
INSERT INTO row_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","3","Inaꞌ a nataa nae, “Hokoꞌ! Hai bole mia! Te akaꞌ a hau esa sia osi a taladꞌa na, Lamatualain ai hai fo afiꞌ mia. Ana nae hai afiꞌ mia, ma afiꞌ nggama boa na, te hokoꞌ naa, hai mate.” ");
INSERT INTO row_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Te mengge a nataa nae, “Weh! Naa, nda tebꞌe sa! Hei nda mate sa. ");
INSERT INTO row_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Lamatualain memaꞌ ai taꞌo naa, huu Ana bubꞌuluꞌ mete ma hei mia hau a boa na, naa, hei mihine bee maloleꞌ ma bee deꞌulakaꞌ, onaꞌ Eni boe.” ");
INSERT INTO row_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Boe ma, inaꞌ a nita hau a malole na seli, no boa na onaꞌ maladꞌaꞌ. Ana dꞌua nae, “Mete ma au ua boaꞌ ia, neꞌo au uhine.” Basa ma, ana etu boaꞌ naa, de naa. Ma nendi fee sao na, de ana o naa boe. ");
INSERT INTO row_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Ara raa basa ma, aiboiꞌ ma rahine rae sira maꞌaholaꞌ. Naa de, ara nato hau roo fo babꞌata ao nara. ");
INSERT INTO row_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Bꞌobꞌo na ma, ara rena LAMATUALAIN lao-laoꞌ sia osi a. De ara keke mia hau sa deaꞌ, naa fo, LAMATUALAIN nda nita se sa. ");
INSERT INTO row_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Te LAMATUALAIN noꞌe touꞌ a nae, “Adam! Ho sia bee?” ");
INSERT INTO row_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Touꞌ a nataa nae, “Au rena hara Ma sia ia. Te au mae, huu au maꞌaholaꞌ. Naa de, au keke.” ");
INSERT INTO row_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Boe ma Lamatualain nae, “Seka nafadꞌe oi ho maꞌaholaꞌ? Taꞌo bee? Ho mua hau boaꞌ fo Au aiꞌ a, to?” ");
INSERT INTO row_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Nataa nae, “Inaꞌ ia, fo Lamatualain fee dadꞌi nonoo ngga, ana mana fee au hau boaꞌ a, fo ua!” ");
INSERT INTO row_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Boe ma LAMATUALAIN olaꞌ no inaꞌ a nae, “Ho tao saa, ia?” Nataa nae, “Mengge a mana eꞌedik nala au! Naa de, au ua ma.” ");
INSERT INTO row_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Basa ma, LAMATUALAIN huku-doki mengge a nae, “Huu tatao ma, Au hukun nggo. Mia basa banda ra, akaꞌ a mesaꞌ nggo dai huku-dokiꞌ ia. Mia oras ia losa mate, nodꞌo mendiꞌ a tenda ma, ma mua siaꞌ a rae a. ");
INSERT INTO row_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Au tao nggo mo inaꞌ ia bamusuꞌ mikindooꞌ a. Hei ruꞌa nggi tititi-nonosi mara o, taꞌo naa boe. Dei fo, tititi-nonosi mara ero atahori ra ei tingga nara. Te inaꞌ a tititi-nonosi na esa, tutu nalutu langga ma.” ");
INSERT INTO row_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Basa ma, Lamatualain nafadꞌe inaꞌ a nae, “Au fee nggo sususaꞌ naeꞌ leleꞌ muiru, ma bꞌonggi no doidꞌosoꞌ seli. Te taꞌo naa o, ho feꞌe hii-nau mo sao ma. Ma ana mana nauli nggo.” ");
INSERT INTO row_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Boe ma Lamatuaꞌ nafadꞌe touꞌ a nae, “Ho nda tungga Au parenda ngga sa, te tunggaꞌ a sao ma hihii na, de mua hau boaꞌ fo Au aiꞌ a. Naa de Au huku-dokiꞌ nggo boe. Ma Au o huku-doki rae a boe. Mia oras ia losa mate, ho musi tao ues naeꞌ aꞌali rae, fo feꞌe hambu mua na. Naa fo, musodꞌa. ");
INSERT INTO row_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Onaꞌ mae ho sela mataꞌ-mataꞌ o, akaꞌ a duri-nggaut a mori. ");
INSERT INTO row_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","De ho musi tao ues naeꞌ, fo rae a fee nggo mua. Ma mbusa ma musi nandali losa ho mate. Au tao nggo mia rae, de mete ma mate nggo, naa, dadꞌi baliꞌ rae.” ");
INSERT INTO row_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Basa naa ma, Adam babꞌae sao na ‘Hawa’ (sosoa na ‘mana masodꞌa’), huu basa atahori masodꞌaꞌ ra ina na, eni. ");
INSERT INTO row_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Boe ma LAMATUALAIN tao buas mia banda rouꞌ, de seluao neu se. ");
INSERT INTO row_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Basa ma LAMATUALAIN olaꞌ nae, “Ia naa, atahori rahine bee maloleꞌ ma bee deꞌulakaꞌ, onaꞌ Hita boe. Afiꞌ losa ara o raa boaꞌ mia hau mana fee se rasodꞌa rakandoo.” ");
INSERT INTO row_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Naa de, Ana oi hendiꞌ se mia osi Eden. Ara risiꞌ mamana feaꞌ, de aꞌali rae, fo rasodꞌa mia rae a. ");
INSERT INTO row_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Lamatualain oi basa se ma, Ana denu ate malida Nara mia sorga, fo reu ranea osi seriꞌ rulu. Ara toꞌu tafaꞌ mana mbila onaꞌ ai, de lalaes neu-nema. Lamatualain denu se ena dalaꞌ rala neu, huu Ana nda nau atahori ra reu etu hau boaꞌ mana fee se rasodꞌa rakandoo. ");
INSERT INTO row_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Lao esa, Adam sungguꞌ no sao na Hawa, de ana nairu. Ana bꞌonggi ana touꞌ esa, ma nae, “Ana touꞌ esa dea nema ena, huu LAMATUALAIN tulu-fali au.” De babꞌae e, Kaen (sosoa na ‘dea nema’). ");
INSERT INTO row_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Basa ma, Hawa bꞌonggi seluꞌ ana touꞌ esa, de babꞌae e Habel. Ruꞌa se raꞌamoko ma, Habel dadꞌi manatadꞌa banda, ma Kaen tao osi. ");
INSERT INTO row_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Lao esa, Kaen nendi osi na mbule-bꞌoa na ruma, fee LAMATUALAIN. ");
INSERT INTO row_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Habel o nendi bibꞌi lombo nara, ana ulu nara. Ana mbau-hala se, ma nendi sisi maloleꞌ neu Lamatualain. Ma LAMATUALAIN rala Na namahoꞌo, huu Habel, ma tutunu-hohotu na. ");
INSERT INTO row_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Te Ana nda hii Kaen tutunu-hohotu na sa. Naa de, Kaen namanasa, de mata na maꞌalasi. ");
INSERT INTO row_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Boe ma LAMATUALAIN olaꞌ no Kaen nae, “Heh, Kaen! Taꞌo bee de mumunasa, losa mata ma maꞌalasi taꞌo naa? ");
INSERT INTO row_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Mete ma ho tao maloleꞌ, naa, Au simbo nggo no maloleꞌ boe. Te besa-bꞌesa! Mete ma ho tao deꞌulakaꞌ, dei fo deꞌulakaꞌ a naa baliꞌ nggo, onaꞌ meo obꞌo lafo. Dadꞌi mete ma hii mae tao deꞌulakaꞌ, malole lenaꞌ nggari hendi leo!” ");
INSERT INTO row_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Lao esa, Kaen kokoe Habel nae, “Odꞌiꞌ! Uma fo teu lao-laoꞌ sia osi.” Ara losa naa, aiboiꞌ ma, Kaen momoko nisa odꞌi na. ");
INSERT INTO row_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Basa ma LAMATUALAIN natane Kaen nae, “Heh, Kaen! Odꞌi ma saa bee?” Nataa nae, “Au nda bubꞌuluꞌ saꞌ! Mae au mana toꞌu ei na, do?” ");
INSERT INTO row_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Te Lamatualain olaꞌ nae, “Taꞌo bee de ho tao deꞌulaka taꞌo naa? Afiꞌ mae ho bisa funi odꞌi ma raa na sia rae a, te Au ita basa ena! ");
INSERT INTO row_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Ia naa huku-dokiꞌ sae nala nggo. Leleꞌ misa odꞌi ma, rae a musi nala raa na. De ia naa, rae a nda fee masodꞌaꞌ neu nggo sa ena. ");
INSERT INTO row_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Mete ma ho tao osi, rae a nda fee mbule-bꞌoaꞌ saa-saa saꞌ boe. Mia oras ia, ho koo-kale muu-uma onaꞌ atahori mana toꞌa-taaꞌ sangga masodꞌaꞌ sia raefafoꞌ ia.” ");
INSERT INTO row_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Te Kaen labꞌan LAMATUALAIN nae, “Awii! Lamatualain, e! Taꞌo bee de huku-doki au bera na seli, losa au nda lemba beꞌi sa! ");
INSERT INTO row_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Huu Lamatualain oi hendi au sia mamanaꞌ ia, dei fo au uꞌudꞌoodꞌooꞌ mia Lamatualain. Au koo-kale sudꞌiꞌ a bee uu. Ma sudꞌiꞌ a se randaa ro au, naa, tati risa au.” ");
INSERT INTO row_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Te LAMATUALAIN nataa nae, “Nda taꞌo naa sa! Seka tati nisa nggo, naa, Au huku-doki e bera na lenaꞌ lao hitu!” Dei de, LAMATUALAIN tao tatandaꞌ neu Kaen, fo atahori rahine, rae nda bole tao risa e sa. ");
INSERT INTO row_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Basa ma, Kaen lao hela mamanaꞌ naa, fo neu naꞌadꞌodꞌoꞌ no LAMATUALAIN. Ana lao losa mamanaꞌ esa sia osi Eden seriꞌ rulu, nara na Nod, sosoa na nae, ‘koo-kale’. Boe ma, ana leo sia naa. ");
INSERT INTO row_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Basa ma, Kaen sao, de sao na nairu. Ana bꞌonggi ana touꞌ esa, de babꞌae e, Henok. Kaen o nafefela kamboꞌ esa, de babꞌae kamboꞌ a Henok, tungga ana na nara na. ");
INSERT INTO row_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Henok ana na, Irad. Ma Irad ana na, Mehuyael. Mehuyael ana na, Metusael. Ma Metusael ana na, Lamek. ");
INSERT INTO row_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamek sao na rua. Esa naran Ada, ma esa naran Sila. ");
INSERT INTO row_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada ana ulu na, naran Yabal. Yabal tititi-nonosi nara, dadꞌi manatadꞌa. Ara rasodꞌa lali-laliꞌ, ma leo sia lalaat. ");
INSERT INTO row_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Yabal odꞌi na, naran Yubal. Yubal tititi-nonosi nara, mana maꞌaminaꞌ lii-liiꞌ mana pake sanar onaꞌ a sasando, ma fuu onaꞌ suling. ");
INSERT INTO row_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Ma Lamek sao na Sila bꞌonggi Tubal Kaen. Tubal Kaen tititi-nonosi nara mana tutu besi. Ara tao sudꞌiꞌ a saa mataꞌ-mataꞌ mia besi ma riti. Tubal Kaen feto na, Naꞌama. ");
INSERT INTO row_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lao esa, Lamek nananaru ao na mia sao nara ruꞌa se mata nara nae, “Rena, e! Faꞌ ra monetenaꞌ esa tutu au, te au tao isa e. ");
INSERT INTO row_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Atahori mana tao nisa Kaen, hambu huku-dokiꞌ lao hitu. Te mete ma hambu mana nae nambedꞌaꞌ ralaꞌ no au, ana hambu huku-dokiꞌ lao hitu nulu hitu.” ");
INSERT INTO row_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam sao na Hawa bonggi ana touꞌ esa fai. De ara babꞌae e, Set, huu Hawa nae, “Lamatualain fee anaꞌ ia nggati Habel, fo Kaen tao nisaꞌ a.” ");
INSERT INTO row_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Dꞌoo-dꞌoo ma, Set hambu ana touꞌ esa, naran Enos. Leleꞌ naa, atahori ra feꞌe rahine LAMATUALAIN ena, ma beꞌutee neu E. ");
INSERT INTO row_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","2","Leleꞌ Lamatualain naꞌadadadꞌiꞌ atahori, Ana tao mata nara, onaꞌ Eni mata na boe. Naꞌadadadꞌiꞌ se, touꞌ no inaꞌ. Ana noꞌe se, nae “atahori”, ma fee se papala-babꞌanggiꞌ. Atahori fefeu na, nara na, Adam. Ia, Adam tititi-nonosi nara: ");
INSERT INTO row_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adam too natun esa telu nulu ma, ana hambu ana touꞌ esa, mata na onaꞌ e boe. Ana babꞌae e, Set. ");
INSERT INTO row_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Basa ma, Adam feꞌe nasodꞌa too natun falu, de hambu seluꞌ ana touꞌ no inaꞌ fai. ");
INSERT INTO row_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Ana too natun sio telu nulu ma, ana mate. ");
INSERT INTO row_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Set too natun esa lima ma, ana hambu ana touꞌ esa, naran Enos. ");
INSERT INTO row_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Basa ma, Set feꞌe nasodꞌa too natun falu hitu, de hambu seluꞌ ana touꞌ ma inaꞌ fai. ");
INSERT INTO row_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Ana too natun sio sanahulu rua ma, ana mate. ");
INSERT INTO row_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enos too sio nulu ma, ana hambu ana touꞌ esa, naran Kenan. ");
INSERT INTO row_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Basa ma, Enos feꞌe nasodꞌa losa too natun falu sanahulu lima, de hambu seluꞌ ana touꞌ ma inaꞌ fai. ");
INSERT INTO row_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Ana too natun sio lima ma, ana mate. ");
INSERT INTO row_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan too hitu nulu ma, ana hambu ana touꞌ esa, naran Mahalalel. ");
INSERT INTO row_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Basa ma, Kenan feꞌe nasodꞌa losa too natun falu haa nulu, de hambu seluꞌ ana touꞌ ma inaꞌ fai. ");
INSERT INTO row_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Ana too natun sio sanahulu ma, ana mate. ");
INSERT INTO row_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalel too nee nulu lima ma, ana hambu ana touꞌ esa, naran Yared. ");
INSERT INTO row_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Basa ma, Mahalalel feꞌe nasodꞌa losa too natun falu telu nulu, de hambu seluꞌ ana touꞌ ma inaꞌ fai. ");
INSERT INTO row_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Ana too natun falu sio nulu lima ma, ana mate. ");
INSERT INTO row_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yared too natun esa nee nulu rua ma, ana hambu ana touꞌ esa, naran Henok. ");
INSERT INTO row_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Basa ma Yared feꞌe nasodꞌa losa too natun falu, de hambu seluꞌ ana touꞌ ma inaꞌ fai. ");
INSERT INTO row_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Ana too natun sio nee nulu rua ma, ana mate. ");
INSERT INTO row_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Henok too nee nulu lima ma, ana hambu ana touꞌ esa, naran Metusalak. ");
INSERT INTO row_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Henok nasodꞌa ralaꞌ esa no Lamatualain losa too natun telu. De ana hambu seluꞌ ana touꞌ ma inaꞌ fai. ");
INSERT INTO row_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","24","Ana nasodꞌa ralaꞌ esa nakandoo no Lamatualain. Ana too natun telu nee nulu lima ma, mopo e, huu Lamatualain soꞌu botiꞌ e. ");
INSERT INTO row_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metusalak too natun esa falu nulu hitu ma, ana hambu ana touꞌ esa, naran Lamek. ");
INSERT INTO row_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Basa ma, Metusalak feꞌe nasodꞌa losa too natun hitu falu nulu rua, de hambu seluꞌ ana touꞌ ma inaꞌ fai. ");
INSERT INTO row_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Ana too natun sio nee nulu sio ma, ana mate. ");
INSERT INTO row_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamek too natun esa falu nulu rua ma, ana hambu ana touꞌ esa. ");
INSERT INTO row_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Ana nae, “Dei fo anaꞌ ia tao namahoꞌo hita rala nara, mia ue-taos sofeꞌ no doidꞌosoꞌ sia rae fo Lamatualain huku-dokiꞌ a.” De ana babꞌae e, Noh (lii na naeꞌ a onaꞌ dedꞌeat esa, sosoa na nae, ‘nendi nemehoꞌot’). ");
INSERT INTO row_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Basa ma, Lamek feꞌe nasodꞌa losa too natun lima sio nulu lima, de hambu seluꞌ ana touꞌ ma inaꞌ fai. ");
INSERT INTO row_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Ana too natun hitu, hitu nulu hitu ma, ana mate. ");
INSERT INTO row_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noh too natun lima ma, ana hambu ana touꞌ telu ena, nara nara, Sem, Yafet ma Ham. ");
INSERT INTO row_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Leleꞌ naa, atahori bau ramaheta. Ara rasodꞌa nggari-nggari sia bee-bꞌee ndule raefafoꞌ ia. Ara o bꞌonggi ana inaꞌ ra boe. ");
INSERT INTO row_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Lamatuaꞌ ana tou nara rita atahori ra ana fetoꞌ nara meulauꞌ. De reu sao ana feto fo sira hiiꞌ ra. ");
INSERT INTO row_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Boe ma LAMATUALAIN nae, “Au benggeꞌ a o atahori mana rasodꞌa tao leliꞌ ia ra. Dula-dale Ngga mana fee masodꞌa neu se, nda nau se rasodꞌa rakandoo sa ena. Ara musi mate. De mia ia, ara rasodꞌa losaꞌ a too natun esa rua nulu.” ");
INSERT INTO row_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Leleꞌ naa, ma fai maꞌabuiꞌ ra, hambu atahori seleꞌ sia raefafoꞌ ena. Lamatualain ana tou nara sao atahori ra ana feto nara, de bꞌonggi atahori seleꞌ naa ra. Ara dadꞌi malangga matatiꞌ ra, fo mana nenebebenggaꞌ sia dudꞌui maꞌahulu na. ");
INSERT INTO row_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Leleꞌ naa, LAMATUALAIN nita atahori sia raefafoꞌ deꞌulaka na naseliꞌ ena. Rala nara duꞌa akaꞌ a deꞌulakaꞌ rakandooꞌ a. ");
INSERT INTO row_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","De LAMATUALAIN fale rala Na, huu naꞌadadadꞌiꞌ se, ma fee se leo sia raefafoꞌ ia ena. Naa, nameraꞌ rala Na seli. ");
INSERT INTO row_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Naa de, Ana olaꞌ nae, “Dei fo Au tao ulutu atahori, fo Au uꞌudadadꞌiꞌ sia raefafoꞌ ia. Au o tao ulutu mbuiꞌ ra ro banda feaꞌ ra, huu Au fale rala Ngga tao ala se ena.” ");
INSERT INTO row_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Akaꞌ a Noh, tao namahoꞌo LAMATUALAIN rala Na. ");
INSERT INTO row_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Ia, Noh dudꞌui na. Ana tou na telu, nara nara Sem, Yafet ma Ham. Noh nasodꞌa ndoos, nda tao deꞌulakaꞌ sa. Ana nasodꞌa deka no Lamatualain. Ma leleꞌ naa, akaꞌ a mesaꞌ ne maloleꞌ. ");
INSERT INTO row_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","12","Te Lamatualain nita atahori feaꞌ ra, basa se deꞌulakaꞌ. Sia bee-bꞌee atahori dala masodꞌa nara nda matetuꞌ sa. Lamatualain nita atahori sia raefafoꞌ, akaꞌ a deꞌulakaꞌ ra. ");
INSERT INTO row_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Boe ma Ana nafadꞌe Noh nae, “Sia bee-bꞌee, Au ita akaꞌ a atahori deꞌulaka nara. De Au uꞌetuꞌ ae tao ulutu raefafoꞌ ia no basa isi-oe na. ");
INSERT INTO row_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Dadꞌi taꞌo ia, Noh! Tao ofai esa mia hau manggateeꞌ. Sia ofai naa rala, tao kama-kama. Basa naa, dudꞌu ofai a ma leli e no ter. ");
INSERT INTO row_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Tao ofai a nanaru na, meter natun esa telu nulu telu. Loloa na, meter rua nulu rua. Ma ataꞌ neu a, meter sanahulu telu. ");
INSERT INTO row_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Tao ofai a ma mbuniꞌ. Te hela mbuni na onaꞌ a banggi rua meter esa mia ririndi na. Banggi ofai a neu tadꞌaꞌ telu ma tao lelesu esa neu bobꞌoa na. ");
INSERT INTO row_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Musunedꞌa malolole! Dei fo Au uꞌondaꞌ oe mandaliꞌ monaeꞌ fo tao nisa basa mana masodꞌaꞌ sia raefafoꞌ ia, losa nda hela saa saꞌ boe. ");
INSERT INTO row_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Te Au ae tao hehelu-fufuliꞌ o nggo. Dei fo ofai rala muu mo sao ma, ana mara, ma ana feto feu mara. ");
INSERT INTO row_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Ho o musi haꞌi mala basa banda ra pasan beꞌe esaꞌ, ma mendi se ofai rala neu, fo ara rasodꞌa ro nggo boe. Haꞌi banda neꞌeboiꞌ ra, mbuiꞌ ra, ma banda mana nodꞌoꞌ ra, fo basa se rasodꞌa. ");
INSERT INTO row_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ho o musi mendi nanaat mataꞌ-mataꞌ nisiꞌ ofai rala neu, soaꞌ neu hei mo banda ra.” ");
INSERT INTO row_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Boe ma, Noh tao tungga basa Lamatulain parenda Na. ");
INSERT INTO row_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Basa naa ma, LAMATUALAIN olaꞌ no Noh nae, “Au mete neu bee-bꞌee, akaꞌ ho fo rala ma ndoos. Huu naa, mo sao-ana mara, ofai rala mi leo. ");
INSERT INTO row_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","3","Mendi basa banda fo hei miaꞌ ra, ma basa banda fo hei tao neu tutunu-hohotuꞌ fee Auꞌ ra, pasan hitu-hitu ofai rala neu. Mendi basa mbuiꞌ ra, pasan beꞌe hituꞌ boe. Te banda feaꞌ ra naa, mendi pasan beꞌe esaꞌ a. No taꞌo naa, banda ma mbuiꞌ naa ra, dadꞌi fini, fo ara afiꞌ mopo. ");
INSERT INTO row_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Musunedꞌa malolole e! Te helaꞌ a fai hitu ena, Au uꞌondaꞌ udꞌan nda hahae sa, losa rereloꞌ fai haa nulu ma tetembaꞌ fai haa nulu. Naa fo, mate basa mana masodꞌaꞌ sia madꞌaꞌ ata, fo Au uꞌudadadꞌiꞌ alaꞌ ra.” ");
INSERT INTO row_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Boe ma, Noh tao tungga basa LAMATUALAIN parenda Na. ");
INSERT INTO row_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noh too natun nee ma, oeꞌ a lala nema. ");
INSERT INTO row_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Ana no sao na, ana nara, ma ana feto feu nara, ofai rala reu, fo rasodꞌa mia oe mandali monaeꞌ a. ");
INSERT INTO row_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Noh o tungga LAMATUALAIN parenda Na, de nendi basa mbuiꞌ mataꞌ-mataꞌ ma banda feaꞌ ra, esaꞌ no nonoo na, mae banda fo atahori raaꞌ ra, ma banda fo atahori nda raaꞌ ra sa. ");
INSERT INTO row_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Basa fai hitu ma, udꞌan monaeꞌ mboꞌa nema, fo nae tatana raefafoꞌ a. ");
INSERT INTO row_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Noh too natun nee, fula rua, fai sanahulu hitu ma, oe monaeꞌ a nema! Onaꞌ lalai a lelesu na nenesoiꞌ, de oeꞌ a mboꞌa rae neu. Ma basa oe mataꞌ sia rae rala ra fanggi, de oe a nasapupuraꞌ dea neu. ");
INSERT INTO row_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Udꞌan o nda hahae sa hatuꞌ-rerelon, losa fai haa nulu. ");
INSERT INTO row_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Te faiꞌ naa, Noh, no sao na, ma ana nara teluꞌ se Sem, Yafet no Ham, ma ana feto feu nara, basa se ofai rala reu. ");
INSERT INTO row_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Ara rala reu ro banda mata-mataꞌ. Naeni, banda neꞌeboiꞌ, banda fui, banda mana nodꞌoꞌ, mbuiꞌ ra ma banda malidꞌa feaꞌ ra. ");
INSERT INTO row_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","16","Noh ofai rala neu no basa masodꞌaꞌ ra pasan beꞌe esaꞌ, tungga Lamatualain parenda na. Basa se rala reu ma, LAMATUALAIN nggoe ofai a lelesu na. ");
INSERT INTO row_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","19","Boe ma, udꞌan monaeꞌ a nema nakandooꞌ a losa fai haa nulu, de oe mandali monaeꞌ a boe hene naruꞌ ata neu, losa ofai a laa. Basa ma, oeꞌ a hene nakandooꞌ a, losa tatana nala lete naruꞌ ra. ");
INSERT INTO row_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Basa ma, oeꞌ a hene nda naloeꞌ sa, losa naru na meter hitu sia mbukuꞌ ra ata. ");
INSERT INTO row_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","23","No taꞌo naa, basa mana masodꞌaꞌ sia madꞌaꞌ ata ra, mate. Atahori, banda neꞌebꞌoiꞌ, banda fui, banda mana nodꞌoꞌ, ma mbuiꞌ ra, basa se mate. Akaꞌ a Noh no basa mana sia ofai rala ra, rasodꞌa. ");
INSERT INTO row_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Oeꞌ a nda reꞌe sa, losa fula lima. ");
INSERT INTO row_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Te Lamatualain nda liliiꞌ Noh se ro basa banda mana sia ofai a. Naa de, Ana fee anin fuu nareꞌe oe mandaliꞌ a. ");
INSERT INTO row_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ana o tatana basa oe mataꞌ sia raefafoꞌ a, ma naloeꞌ udan mia lalai a. ");
INSERT INTO row_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Boe ma oeꞌ a namakura. Basa fula lima ma, oeꞌ a nda naruꞌ naeꞌ sa ena. ");
INSERT INTO row_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ndaa no fula ka hitu na, fai sanahulu hitu ma, ofai a hara sia leteꞌ naruꞌ sa ata, nara na Ararat. ");
INSERT INTO row_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Basa ma, oeꞌ a reꞌe nakandoo. Fula ka sanahulu na, fai ka esa na ma, mbuku-leteꞌ ra tonggo nara sou. ");
INSERT INTO row_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Seli fai haa nulu ma, Noh soi ofai a jandela na esa. ");
INSERT INTO row_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Ana mboꞌi mbui kaaꞌ esa. Mbuiꞌ naa natambele neu-nema losa oe mandali monaeꞌ a reꞌe tebꞌe ena. Ana nda baliꞌ ofai neu sa. ");
INSERT INTO row_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Boe ma, Noh mboꞌi mbui lunda esa, fo nae nahine oeꞌ a reꞌe tebꞌe, do feꞌe hokoꞌ. ");
INSERT INTO row_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Te huu oeꞌ a feꞌe ndule raefafoꞌ, de mbuiꞌ a nda hambu mamana teteeꞌ sa. De ana baliꞌ ofai neu. Noh loo lima na, de simbo nala baliꞌ mbuiꞌ a ofai rala neu. ");
INSERT INTO row_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Noh nahati fai hitu fai, dei de ana mboꞌi seluꞌ mbuiꞌ a. ");
INSERT INTO row_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Bꞌobꞌo naa ma, mbuiꞌ a baliꞌ seluꞌ nisiꞌ Noh, nendi saitun rooꞌ esa, fo ana feꞌe bito nala naa. Dei de, Noh bubꞌuluꞌ oeꞌ a meti tetebꞌes ena. ");
INSERT INTO row_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ana nahati fai hitu fai, de mboꞌi seluꞌ mbui lunda a. Te ia naa, mbuiꞌ a nda baliꞌ sa. ");
INSERT INTO row_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Noh too natun nee esa, ndaa no fai ka esa fula ka esa na ma, oeꞌ a meti tebꞌe-tebꞌeꞌ ena. Boe ma, Noh soi ofai a jandela na, de mete rereoꞌ ma nita rae a madꞌa ena. ");
INSERT INTO row_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Fula ka rua na, fai ka sanahulu hitu na ma, rae a madꞌa tebꞌe-tebꞌeꞌ ena. ");
INSERT INTO row_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Basa ma, Lamatualain olaꞌ no Noh nae, ");
INSERT INTO row_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Noh! Basa nggi onda mia ofai a leo. ");
INSERT INTO row_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Soi basa banda ra dea reu! Soi basa banda neꞌeboiꞌ, banda fui, banda mana nodꞌoꞌ, no mbuiꞌ ra. Naa fo, basa se boe ramahefu, fo rasofe raefafoꞌ ia.” ");
INSERT INTO row_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","19","Basa de, Noh no sao na, ma ana nara, ma ana feto feu nara, dea reu mia ofai a. Basa banda ra o, dea reu, esa-esaꞌ no nonoo na. ");
INSERT INTO row_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Basa naa ma, Noh lutu mbatu mei tutunu-hohotuꞌ fee LAMATUALAIN. Noh haꞌi nala banda beꞌe esaꞌ, mia basa banda fo bisa tao dadꞌi tutunu-hohotuꞌ. Ana mbau hala se, ma tunu se sia mei tutunu-hohotuꞌ a, fo dadꞌi tutunu-hohotuꞌ fee LAMATUALAIN. ");
INSERT INTO row_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","LAMATUALAIN hae nala tutunu-hohotuꞌ a maꞌafo meni na ma, rala Na namahoꞌo. De Ana duꞌa nae, “Mia faiꞌ ia, Au nda afiꞌ huku-doki raefafoꞌ a huu atahori deꞌulaka na sa. Onaꞌ mae ara duꞌa akaꞌ a deꞌulakaꞌ o, Au nda afiꞌ tao ulutu basa masodꞌa ra sa, onaꞌ Au taoꞌ basaꞌ a ena. ");
INSERT INTO row_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Mete ma raefafoꞌ a feꞌe sia, naa, fula-faiꞌ ia ra basa se laoꞌ rakandoo, tungga dala nara. Fula-fai sela-nggariꞌ no fula-fai etu-oruꞌ, fula-fai maꞌasufuꞌ no fula-fai matobꞌiꞌ, fula-fai relo-ai no fula-fai udꞌa-oeꞌ, ma rereloꞌ no tetembaꞌ, basa se lao tungga dala nara.” ");
INSERT INTO row_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Basa naa ma, Lamatualain fee papala-babꞌanggiꞌ neu Noh no ana nara. Ana olaꞌ nae, “Ama bꞌonggi nae-nae, fo misofe raefafoꞌ a. ");
INSERT INTO row_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Dei fo basa banda fui ra, mbuiꞌ ra, ma uꞌu ra ramatau hei. Hei musi tao mataꞌ neu se. ");
INSERT INTO row_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Hei bisa mia basa banda ra sisi na, onaꞌ hei mia huu-huuꞌ ra buna-bꞌoa na. Au fee basa ia ra neu nggi. ");
INSERT INTO row_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Akaꞌ na, hei afiꞌ mia sisi feꞌe ma raaꞌ, huu banda hahae na sia raa na. ");
INSERT INTO row_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","6","Au uꞌudadadꞌiꞌ atahori onaꞌ mata Ngga boe. Huu naa, de afi tao misa atahori. Mete ma hambu atahori, do banda, tao risa atahori, naa, musi tao misa se boe. Hohoro-lalaneꞌ ia, mia Au nema. ");
INSERT INTO row_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Hei musi bꞌonggi mimihefu, fo misofe baliꞌ raefafoꞌ ia.” ");
INSERT INTO row_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Basa ma, Lamatualain olaꞌ seluꞌ nae, ");
INSERT INTO row_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Ia naa, Au ae tao hehelu-fufuli o hei, no hei tititi-nonosi mara boe. ");
INSERT INTO row_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Hehelu-fufuliꞌ ia dai basa mana masodꞌaꞌ ra, mana dea rema ro hei mia ofai rala. Naeni, basa banda neꞌeboiꞌ, banda fui, ma mbuiꞌ ra. ");
INSERT INTO row_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Au hehelu ngga, taꞌo ia: Au nda afiꞌ fee oe mandali monaeꞌ sa ena, fo tao nisa basa mana masodꞌaꞌ ra, ma nalutu basa raefafoꞌ ia. ");
INSERT INTO row_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Au tao elus Ngga sia lalai, dadꞌi bukti fee nesenenedꞌaꞌ neu hehelu-fufuli Ngga nda mana neneneꞌetuꞌ sa. Au helu-fuli ia, neu hei, ma basa mana masodꞌa ra, ma raefafoꞌ ia. ");
INSERT INTO row_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","17","Mete ma hambu leleeꞌ sia lalai, ma elus a sou, naa, fee nesenenedꞌaꞌ neu Au hehelu-fufuli ngga ia, nae: oe mandali monaeꞌ nda afiꞌ nalutu basa mana masodꞌaꞌ ra sa ena. Au hehelu-fufuli ngga ia, nda neneneꞌetuꞌ sa. Au helu-fuli ia, neu nggi, mo basa mana masodꞌaꞌ ra.” ");
INSERT INTO row_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noh ana nara mana dea rema mia ofai a, nara nara Sem, Yafet, ma Ham. (Ham naa, Kanaꞌan ama na). ");
INSERT INTO row_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Basa atahori sia raefafoꞌ tititi-nonosi nara laoꞌ mia Noh ana ka telu nara naa ra. ");
INSERT INTO row_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noh ia, atahori mana ue rae. Ana mana tao naꞌahuluꞌ osi anggor. ");
INSERT INTO row_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Lao esa, ana ninu anggor losa mafu naeꞌ. De olu hendi bua-baꞌu na, ma sungguꞌ lengga-loli no maꞌahola na mia lalaa na rala. ");
INSERT INTO row_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ham nita ama na maꞌaholaꞌ ma, ana nela dea neu, nafadꞌe aꞌa na Sem no Yafet. ");
INSERT INTO row_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","De ruꞌa se haꞌi rala lafe esa, ma ndae dodoko neu aru nara. Dei de, ara lao rasadꞌedꞌeaꞌ lalaaꞌ rala reu, de luꞌumbanu rala ama na. No taꞌo naa, ara nda rita ama na maꞌahola na sa. Basa de, ara dea reu. ");
INSERT INTO row_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Noh mamafu na nae mopo ma, ana bubꞌuluꞌ ana muri na tatao na. ");
INSERT INTO row_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Boe ma ana olaꞌ nae, “He! Kanaꞌan ama na! Au sumba-ndoon nggo! Dei fo ho dadꞌi ate sia aꞌa mara! ");
INSERT INTO row_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Au koa-kio LAMATUALAIN, huu Sem! Te Kanaꞌan, dadꞌi Sem ate na. ");
INSERT INTO row_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Au hule-oꞌe fo Lamatualain naloa Yafet rae na; Ma tititi-nonosi nara rasodꞌa dame ro Sem tititi-nonosi nara. Te hela fo Kanaꞌan dadꞌi Yafet ate na.” ");
INSERT INTO row_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Oe mandali monaeꞌ a basa ma, Noh feꞌe nasodꞌa too natun telu lima nulu fai. ");
INSERT INTO row_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Ana too natun sio lima nulu ma, ana mate. ");
INSERT INTO row_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Oe mandali monaeꞌ a basa ma, Noh ana nara hambu tititi-nonosiꞌ. Ia, Sem, Yafet no Ham tititi-nonosi nara. ");
INSERT INTO row_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","5","Yafet tititi-nonosi nara, Gomer, Magog, Madai, Yawan, Tubal, Mesek ma Tiras. Esa-esaꞌ no dedꞌea na, leo na, ma rae heheli na. Gomer tititi-nonosi nara, Askenas, Rifat ma Togarma. Yawan tititi-nonosi nara, Elisa, Tarsis, atahori Kitim ra, ma atahori Dodanim mana leo sia tasi suu nara. ");
INSERT INTO row_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ham tititi-nonosi nara, Kus, Misraim, Put, ma Kanaꞌan. ");
INSERT INTO row_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kus tititi-nonosi nara, Seba, Hawila, Sabta, Raema ma Sabteka. Raema tititi-nonosi nara, Syeba ma Dedan. ");
INSERT INTO row_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kus ana tou na, naran Nimrod. Nimrod, atahori manaseliꞌ, mana dadꞌi malangga matati fefeu na. ");
INSERT INTO row_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Nesiꞌet na laoꞌ mia LAMATUALAIN, losa ana o dadꞌi mana sombu banda masiꞌet seliꞌ. Naa de, atahori ra olaꞌ rae, “Hule-huleꞌ fo ho dadꞌi mana sombu banda masiꞌet, onaꞌ Nimrod, fo mana hambu nesiꞌet na mia LAMATUALAIN.” ");
INSERT INTO row_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Fefeu na, Nimrod rae na mia Babel, Erek Akad, no Kalne. Basa mamanaꞌ naa ra, sia Sinear. ");
INSERT INTO row_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Mia naa, ana koasa Asyur boe. Basa ma, nafefela kamboꞌ Niniwe, Rehobot-Ir, Kala, ");
INSERT INTO row_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ma Resen, mana sia Niniwe no Kala taladꞌa na. Basa naa ra, kambo monaeꞌ. ");
INSERT INTO row_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misraim tititi-nonosi nara, atahori Ludim, atahori Anamim, atahori Lehabim, atahori Naftuhim, ");
INSERT INTO row_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","atahori Patrisium, atahori Kasluhim, ma atahori Kaftorim. Atahori Kasluhim naa, atahori Filistin bei-baꞌi nara. ");
INSERT INTO row_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaꞌan ana ulu na, naran Sidꞌon. Kanaꞌan o dadꞌi bei-baꞌi mia atahori Het, ");
INSERT INTO row_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","atahori Yebusi, atahori Amori, atahori Girgasi, ");
INSERT INTO row_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","atahori Hiwi, atahori Arki, atahori Sini, ");
INSERT INTO row_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","atahori Arwadi, atahori Semari, ma atahori Hamati. Kanaꞌan tititi-nonosi nara sea-saranggaa raꞌadodꞌooꞌ. ");
INSERT INTO row_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Sira rae na, mia Sidꞌon nakandoo nisiꞌ Gerar, losa Gasa. Ma mia Gasa, nisiꞌ Sodꞌom, Gomora, Adma, ma Seboim, losa Lasa. ");
INSERT INTO row_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Basa se, Ham tititi-nonosi nara. Esa-esaꞌ no dedꞌea na, leo na, ma rae heheli na. ");
INSERT INTO row_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Yafet aꞌa na Sem, dadꞌi atahori Eber ra bei-baꞌi nara. ");
INSERT INTO row_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sem tititi-nonosi nara, Elam, Asyur, Arpaksad, Lud ma Aram. ");
INSERT INTO row_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram tititi-nonosi nara, atahori Us, atahori Hul, atahori Geter ma atahori Mas. ");
INSERT INTO row_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpaksad ana na, naran Sela. Ma Sela ana na, naran Eber. ");
INSERT INTO row_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber hambu ana touꞌ rua. Ulu ka, naran Pelek (sosoa na ‘banggi-bꞌanggi’), huu leleꞌ naa, atahori ra leo banggi-bꞌanggi sia raefafoꞌ. Muri ka, naran Yoktan. ");
INSERT INTO row_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoktan tititi-nonosi nara, Almodad, Selef, Hasar-Mawet, Yera, ");
INSERT INTO row_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Usal, Dikla, ");
INSERT INTO row_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Syeba, ");
INSERT INTO row_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Hawila, ma Yobab. Basa se, Yoktan tititi-nonosi nara. ");
INSERT INTO row_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Mamana leleo nara, mia Mesa, nakandoo losa Sefar, fo mamana mbuku-leteꞌ seriꞌ rulu. ");
INSERT INTO row_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Basa se, Sem tititi-nonosi nara. Esa-esaꞌ no dedꞌea na, leo na, ma rae heheli na. ");
INSERT INTO row_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Basa naa ra, Noh tititi-nonosi nara, esa-esaꞌ no leo na. Oe mandali monaeꞌ basa ma, ara mana leo sea-saranggaa rasofe raefafoꞌ ia. ");
INSERT INTO row_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Maꞌahulu na, basa atahori sia raefafoꞌ ia olaꞌ rendiꞌ a dedꞌeat esaꞌ a. ");
INSERT INTO row_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ruma sangga lali risiꞌ seriꞌ rulu, losa rae tetuꞌ esa sia Sinear, de ara leo sia naa. ");
INSERT INTO row_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","4","Basa se rala hara esa rae, “We! Toronooꞌ re! Ima fo tafefela nusa monaeꞌ esa. Ata musi tao fatu mbilas, fo lalangge losa manggatee. Basa fo ata lutu fatu mbilas naa ra no ter, fo tariri ume naruꞌ esa, tonggo na losa lalai. Naa fo, ata hambu naraꞌ ma dadꞌi leo monaeꞌ sa nda banggi-bꞌanggiꞌ sa.” ");
INSERT INTO row_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Boe ma LAMATUALAIN nema mete sobꞌa nusaꞌ naa, no ume naruꞌ fo rafefelaꞌ a. ");
INSERT INTO row_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ana olaꞌ nae, “Basa atahori ia ra, leo esa, ma dedꞌeat esa. Saa fo ara taoꞌ a ia, feꞌe fefeuꞌ. Mbila-fini esaꞌ, mete ma basa se raꞌabꞌue reu esa onaꞌ ia, naa, ara bisa tao sudꞌi a saa. ");
INSERT INTO row_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Malole lenaꞌ Hita onda fo tao se esa-esaꞌ no dedꞌea na, fo esa nda nahine esa dedꞌea na saꞌ boe.” ");
INSERT INTO row_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Boe ma Lamatualain onda tao tasibu dedꞌea nara. No taꞌo naa, Ana tao atahori ra sea-saranggaa risiꞌ basa mamanaꞌ sia raefafoꞌ a. Ara o nda rafefela rakandoo nusaꞌ naa saꞌ ena. ");
INSERT INTO row_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Naa de, ara babꞌae nusaꞌ naa, Babel, (lii na naeꞌ a onaꞌ dedꞌeat esa, fo sosoa na ‘tabꞌanganga’), huu LAMATUALAIN tao tasibꞌu dedꞌea nara, ma fee se sea-saranggaa sudꞌiꞌ a bee reu sia raefafoꞌ a. ");
INSERT INTO row_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ia, Sem tititi-nonosi nara. Leleꞌ oe mandali monaeꞌ a naloeꞌ too rua ena, nandaa no Sem too natun esa ma, ana hambu ana touꞌ esa, naran Arpaksad. ");
INSERT INTO row_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Basa ma, Sem feꞌe nasodꞌa too natun lima, de hambu seluꞌ ana touꞌ ma inaꞌ fai. ");
INSERT INTO row_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arpaksad too telu nulu lima ma, ana hambu ana touꞌ esa, naran Sela. ");
INSERT INTO row_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Basa ma, Arpaksad feꞌe nasodꞌa too natun haa telu, de hambu seluꞌ ana touꞌ ma inaꞌ fai. ");
INSERT INTO row_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sela too telu nulu ma, ana hambu ana touꞌ esa, naran Eber. ");
INSERT INTO row_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Basa ma, Sela feꞌe nasodꞌa too natun haa telu, de hambu seluꞌ ana touꞌ ma inaꞌ fai. ");
INSERT INTO row_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eber too telu nulu haa ma, ana hambu ana touꞌ esa, naran Pelek. ");
INSERT INTO row_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Basa ma, Eber feꞌe nasodꞌa seluꞌ too natun haa telu nulu, de ana hambu seluꞌ ana touꞌ ma inaꞌ fai. ");
INSERT INTO row_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pelek too telu nulu ma, ana hambu ana touꞌ esa, naran Rehu. ");
INSERT INTO row_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Basa ma, Pelek nasodꞌa seluꞌ too natun rua sio, de hambu seluꞌ ana touꞌ ma inaꞌ fai. ");
INSERT INTO row_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Rehu too telu nulu rua ma, ana hambu ana touꞌ esa, naran Seruk. ");
INSERT INTO row_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Basa ma, Rehu feꞌe nasodꞌa too natun rua hitu, de hambu seluꞌ ana touꞌ ma inaꞌ fai. ");
INSERT INTO row_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Seruk too telu nulu ma, ana hambu ana touꞌ esa, naran Nahor. ");
INSERT INTO row_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Basa ma, Seruk feꞌe nasodꞌa seluꞌ too natun rua, de hambu seluꞌ ana touꞌ ma inaꞌ fai. ");
INSERT INTO row_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahor too rua nulu sio ma, ana hambu ana touꞌ esa, naran Tera. ");
INSERT INTO row_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Basa ma, Nahor feꞌe nasodꞌa seluꞌ too natun esa sana hulu sio, de hambu seluꞌ ana touꞌ ma inaꞌ fai. ");
INSERT INTO row_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tera too hitu nulu lena ma, ana hambu ana touꞌ telu ena, nara nara Abram, Nahor, ma Haran. ");
INSERT INTO row_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Ia, Tera tititi-nonosi nara. Tera ana nara, Abram, Nahor, ma Haran. Haran hambu ana touꞌ esa, naran Lot. ");
INSERT INTO row_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran mate mia kambo na, naran Ur, sia atahori Kasdim ra rae na. Ana mate te, ama na Tera feꞌe masodꞌaꞌ. ");
INSERT INTO row_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram sao na Sarai. Nahor sao nala Haran ana feto na, Milka. Haran o ma ana touꞌ esa, naran Yiska. ");
INSERT INTO row_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Te Sarai nda mana bꞌonggiꞌ sa. ");
INSERT INTO row_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Lao esa, Tera nendi ana na Abram, ana feto feu na Sarai, ma umbu na Lot, de ara lao hela kambo Ur. Ara rae reu sia rae Kanaꞌan, te losa kambo Haran ma, ara leo reuꞌ a naa. ");
INSERT INTO row_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera too natun rua lima ma, ana mate sia naa. ");
INSERT INTO row_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Leleꞌ naa, LAMATUALAIN olaꞌ no Abram nae, “Abram! Lao hela bobꞌonggi ma, ama ma ume na, ma kambo ma. Misiꞌ mamanaꞌ esa, dei fo Au utudꞌu neu nggo. ");
INSERT INTO row_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Dei fo Au fee papala-babꞌanggiꞌ neu nggo. Tititi-nonosi mara, boe ramaheta, dadꞌi leo manaseliꞌ losa atahori ra rahine nara ma. Ma ho dadꞌi papala-babꞌanggiꞌ soaꞌ neu atahori feaꞌ. ");
INSERT INTO row_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Dei fo Au fee papala-babꞌanggiꞌ neu atahori mana fee papala-babꞌanggiꞌ neu nggo. Te Au huku-doki atahori mana fee huku-dokiꞌ neu nggo. Rena malolole! Dei fo basa leo sia raefafoꞌ hambu papala-babꞌanggiꞌ laoꞌ mia nggo.” ");
INSERT INTO row_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Abram too hitu nulu lima ma, ana no sao na Sarai, ma odꞌi na anan Lot, ma basa hata-heto na, no basa atahori mana ue-tao nara fo ana hambu mia kambo Haran. Basa ma, ara lao hela Haran, de risiꞌ mamanaꞌ fo LAMATUALAIN nafadꞌe neu e. Ara laoꞌ rakandoo, losa mamanaꞌ esa, naran Kanaꞌan. ");
INSERT INTO row_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Losa naa, Abram lao rereoꞌ rae naa, losa deka no kamboꞌ esa, naran Sikem. De ara leo raꞌatataaꞌ deka no hau huu ineꞌ esa sia More. Leleꞌ naa, atahori Kanaꞌan ra feꞌe leo sia naa. ");
INSERT INTO row_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","LAMATUALAIN natudꞌu Aon neu Abram sia naa. Ana nae, “Au fee nusaꞌ ia neu tititi-nonosi ma.” Basa ma Abram lutu mbatu mei tutunu-hohotuꞌ soaꞌ neu LAMATUALAIN, mana natudꞌu Aon sia naa. ");
INSERT INTO row_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Basa ma, Abram se lali risiꞌ leteꞌ sia ona, de leo raꞌatataaꞌ sia kambo Betel no kambo Ai taladꞌa nara. Ana o lutu mbatu mei tutunu-hohotuꞌ esa, de beꞌutee neu LAMATUALAIN sia naa. ");
INSERT INTO row_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Basa naa ma, ana lali-laliꞌ mamanaꞌ, losa rae Negeb sia Kanaꞌan seriꞌ ona. ");
INSERT INTO row_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Faiꞌ sa boe, ndoe-laꞌas manaseliꞌ mia rae Kanaꞌan. Naa de Abram se lao rakandoo risiꞌ seriꞌ ona, losa nusa Masir. Ara leo raꞌatataaꞌ sia naa. ");
INSERT INTO row_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ara rae risiꞌ nusa Masir rala reu ma, nafadꞌe sao na Sarai nae, “Sarai. Ho ia, meulau ma seli. ");
INSERT INTO row_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Te mete ma atahori Masir ra rita ho meulau ma ia, ara tao risa au, huu au ia, ho sao ma. No taꞌo naa, ara sao rala nggo. ");
INSERT INTO row_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","De malole lenaꞌ, mufadꞌe se mae, au ia, ho aꞌa ma. Naa fo, ara nda tati-mbau risa au sa, te ara maloleꞌ ro au, huu ho.” ");
INSERT INTO row_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","De Abram se losa Masir ma, atahori ra rita inaꞌ a meulau na seli. ");
INSERT INTO row_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Pagau mane Masir ra rita e ma, ara koa inaꞌ meulau na mia maneꞌ a mata na. Basa ma, ara rendi e nisiꞌ maneꞌ a ume na. ");
INSERT INTO row_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","De maneꞌ a malolole no Abram, huu Sarai. Ana fee mudꞌaꞌ Abram bibꞌi lombo, hiek, sapi, keledei, no banda onta. Ana o fee ate touꞌ ma inaꞌ boe. ");
INSERT INTO row_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Te huu maneꞌ a haꞌi nala atahori sao na nisiꞌ ume na, naa de LAMATUALAIN huku-doki mataꞌ-mataꞌ neu e no atahori nara. ");
INSERT INTO row_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Dei de maneꞌ a noꞌe Abram ma natane nae, “Abram! Ho tao au taꞌo bee ia? Saa de nda mufadꞌe mae, inaꞌ ia, sao ma sa!? ");
INSERT INTO row_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Te mae odꞌi ma! Helaꞌ a mbei na, au sao ala e! Sie, haꞌi mendi e! Dinggoꞌ hela mata ngga!” ");
INSERT INTO row_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Basa ma maneꞌ a parenda pagau nara, fo oi hendi Abram, no sao na, ma sudꞌiꞌ a saa nara mia nusaꞌ naa. ");
INSERT INTO row_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Basa ma, Abram lao hela Masir, de baliꞌ nisiꞌ rae Negeb. Neu no sao na, ma basa hata-heto na. Odꞌi na anan Lot o tungga e boe. ");
INSERT INTO row_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram ia, mamasuꞌin seli. Banda neꞌeboiꞌ, lilo mbilas ma doi fulaꞌ, nae na seli. ");
INSERT INTO row_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Mia Negeb ana lao lali-laliꞌ de baliꞌ nisiꞌ kambo Betel no Ai taladꞌa na. Dalahulu na, ana leo mia naa. ");
INSERT INTO row_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Ana o lutu mbatu fatu dadꞌi mei tutunu-hohotuꞌ boe. De beꞌutee neu LAMATUALAIN sia naa. ");
INSERT INTO row_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot, mana tungga no Abram, naꞌena banda neꞌeboiꞌ naeꞌ, ma atahori mana tao ues o naeꞌ boe. ");
INSERT INTO row_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","7","Te mamanaꞌ naa nda loaꞌ, soaꞌ neu Abram no Lot, no basa hata-heto nara fo rasodꞌa sa. De manatadꞌa nara rareresi, huu uru nda dai banda nara sa. (Leleꞌ naa, atahori Kanaꞌan ro atahori Feris o feꞌe leo sia naa boe.) ");
INSERT INTO row_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","De Abram nafadꞌe ana na nae, “Lot, e! Hita ia bobꞌonggiꞌ. Afiꞌ losa hita esa nda maloleꞌ no esa sa, huu atahori mana tao ues tara ratofa rakandooꞌ a. ");
INSERT INTO row_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Dadꞌi malole lenaꞌ ruꞌa nggita saranggaa. Mamanaꞌ ia loaꞌ, de mete ma hii mala rae seriꞌ dii, naa au isiꞌ seriꞌ ona. Mete ma hii mala seriꞌ ona, naa au isiꞌ seriꞌ dii.” ");
INSERT INTO row_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Boe ma Lot mete rereoꞌ, de nita babafaꞌ loe Yordan oe na naeꞌ losa kambo Soar. Mamanaꞌ naa maꞌasufuꞌ onaꞌ LAMATUALAIN osi na, ma onaꞌ rae Masir. (Leleꞌ naa, LAMATUALAIN nda feꞌe tao nalutu kambo Sodꞌom no Gomora sa. De rae naa feꞌe maloleꞌ.) ");
INSERT INTO row_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Dadꞌi Lot hii nala basa rae sia babafaꞌ loe Yorden. De ruꞌa se saranggaa ma, Lot nisiꞌ seriꞌ rulu. ");
INSERT INTO row_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Te Abram leo nahati rae Kanaꞌan. Lot neu leo sia kambo-kamboꞌ deka Sodꞌom sia babafaꞌ Yarden. ");
INSERT INTO row_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Atahori Sodꞌom ra, deꞌulaka nara seli ma nda nau rena LAMATUALAIN sa. ");
INSERT INTO row_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lot no Abram saranggaa ma, LAMATUALAIN olaꞌ no Abram nae, “Abram! Sobꞌa mete rereoꞌ basa mamanaꞌ mia mamanaꞌ ho mumburiꞌ siaꞌ a. Mete malolole deaꞌ-mataꞌ ma dii-ona. ");
INSERT INTO row_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Basa rae fo mitaꞌ naa, dei fo Au fee neu nggo, mo tititi-nonosi mara, fo dadꞌi hata-heto ma losa doo na neu. ");
INSERT INTO row_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Dei fo Au fee tititi-nonosi mara ramaheta onaꞌ saraꞌaeꞌ sia tasi suu na, losa atahori nda reken rala se sa. ");
INSERT INTO row_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","De ia naa, muu laoꞌ rereoꞌ rae a loa-naru na. Te dei fo, Au fee basa naa ra neu nggo!” ");
INSERT INTO row_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Basa ma, Abram se lali, reu leo baliꞌ sia mamanaꞌ deka hau-hau huu ineꞌ sia Mamre, deka kambo Hebron. Ana lutu mbatu mei tutunu-hohotuꞌ, de beꞌutee neu LAMATUALAIN sia naa. ");
INSERT INTO row_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Leleꞌ naa, hambu maneꞌ haa raꞌabꞌue. Naeni: Amrafel, mane nusa Sinear. Ariok, mane nusa Elasar. Kedarlaomer, mane nusa Elam. Ma Tideal, mane nusa Goyim. ");
INSERT INTO row_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Ma mane feaꞌ lima o raꞌabꞌue boe. Naeni: Bera, mane kota Sodꞌom. Birsa, mane kota Gomora. Sinab, mane nusa Adema. Semeber, mane nusa Seboim. Ma Bela, mane nusa Soar. Mane ka haaꞌ ra ratati labꞌan mane ka limaꞌ ra. ");
INSERT INTO row_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Mane ka limaꞌ ra raꞌabꞌue ro soldꞌadꞌu nara sia babafaꞌ sa naran Sidim (fo aleꞌ ia ara rae Tasi Mates). ");
INSERT INTO row_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Netatiꞌ naa, huu na taꞌo ia: Maꞌahulu na, mane ka limaꞌ ra taꞌalok mane Kedarlaomer losa too sanahulu rua. Te too ka sanahulu telu na ma, ara labꞌan e. ");
INSERT INTO row_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Masoꞌ too ka sanahulu haa na ma, mane Kedarlaomer no nonoo mane ka teluꞌ nara rema ro soldꞌadꞌu nara. Ara ratati rakalaꞌ nusaꞌ hira. Naeni: atahori Refaim sia nusa Asterot-Karnaim, atahori Susim sia nusa Ham, atahori Emim sia nusa Sawe-Kiryataim, ");
INSERT INTO row_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ma atahori Hori mana leo sia lete Seir losa nembe saraꞌaeꞌ El Paran suu na. ");
INSERT INTO row_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Basa ma, ara baliꞌ risiꞌ En Mispat (fo aleꞌ ia naran Kades). Ara tao ralutu atahori Amalek nusa na, ro atahori Amori mana leo nusa Haseson-Tamar. ");
INSERT INTO row_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","9","Basa naa ma, mane ka limaꞌ ra ator soldꞌadꞌu nara sia babafaꞌ Sidim, de ratati labꞌan mane ka haaꞌ ra. ");
INSERT INTO row_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Sia babafaꞌ naa, hambu lifu ter romaꞌ naeꞌ. Leleꞌ ara ratati ma, mane Sodꞌom no mane Gomora ma soldꞌadꞌu nara rela. Ruma tudꞌa risiꞌ lifu ter rala, ma ruma rela risiꞌ leteꞌ. ");
INSERT INTO row_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Mane ka haaꞌ ra rasenggiꞌ mane ka limaꞌ ra, de rambas rala basa sudꞌiꞌ a saa ma nanaat mia Sodꞌom no Gomora. Basa de, ara baliꞌ. ");
INSERT INTO row_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Leleꞌ naa, Abram ana na Lot leo sia Sodꞌom. De mane ka haaꞌ ra toꞌu rendi Lot se, ma rambas rendi basa sudꞌiꞌ a saa nara. ");
INSERT INTO row_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Te atahori esa sai, de neu nafadꞌe Abram, atahori Ibrani a. Hambu atahori Amori esa, naran Mamre. Abram leo deka sia Mamre hau-hau huu ine na. Mamre odꞌi na, Eskol no Aner. Sira, mana dadꞌi Abram partei na. ");
INSERT INTO row_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abram rena oi atahori toꞌu rendi ana na ma, ana naꞌabꞌue nala atahori mana ratati rahine mia mana tao ues nara. Basa se atahori natun telu sanahulu falu. Ara reu oi mane ka haaꞌ ra losa kambo Dan fo naꞌadooꞌ sia seriꞌ dii. ");
INSERT INTO row_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Sia naa, Abram banggi atahori nara reu babanggiꞌ hira. Tetemba na ma, reu sambu atahori naa ra. Te ruma rela, ma Abram se oi rakandoo se, losa kambo Hoba, sia kota Damsik seriꞌ dii. ");
INSERT INTO row_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Basa naa ma, Abram haꞌi nala baliꞌ Lot, no atahori nara, ro basa sudꞌiꞌ a saa nara, ma atahori feaꞌ ra boe. ");
INSERT INTO row_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abram baliꞌ mia nakalaꞌ mane ka haaꞌ ra ma, mane Sodꞌom nema soru e mia babafaꞌ sa naran Sawe (fo atahori rae, Babafa Maneꞌ). ");
INSERT INTO row_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Leleꞌ naa, mane Salem a, naran Melkisedek. Ana o malangga agama mia Lamatualain mana sia Ataꞌ a. Ana nendi fee Abram, roti no oe anggor. ");
INSERT INTO row_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","20","Basa ma ana olaꞌ fee Abram papala-babꞌanggiꞌ nae, “Hela fo Lamatualain mana sia Ataꞌ a, ma mana tao lalai no raefafoꞌ a, fee nggo papala-babꞌanggiꞌ. Koa-kio Lamatualain, mana fee nggo musenggiꞌ musu mara.” Basa boe ma Abram fee Melkisedek babanggiꞌ esa mia sanahulu, mia basa saa fo ana rambas nala baliꞌ ra. ");
INSERT INTO row_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Boe ma, mane Sodꞌom sendeꞌ fee hadat neu Abram nae, “Ama Abram. Sudꞌiꞌ a saa fo amaꞌ rambas mia musu nggara, amaꞌ hambu basa se. Te au oꞌe baliꞌ akaꞌ a atahori nggara.” ");
INSERT INTO row_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Abram nataa nae, “Au sumba endiꞌ Lamatualain mana sia Ataꞌ a, ma mana tao lalai no raefafoꞌ a, ");
INSERT INTO row_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ae, au nda haꞌi ala saa saꞌ boe mia ho sudꞌiꞌ a saa mara. Mae abꞌas ndooꞌ esa o, au nda haꞌi sa. No taꞌo naa, ho nda hambu olaꞌ mae, ‘Abram namasuꞌi, huu au.’ ");
INSERT INTO row_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Au nda parlu saa saꞌ boe. Akaꞌ a bee fo au atahori nggara pakeꞌ ra, naa mana basaꞌ ena. Ma fee au nonoo ka telu ngga ia ra, Aner, Eskol no Mamre, haꞌi rendi babanggi nara.” ");
INSERT INTO row_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Basa ma, Lamatualain natudꞌu Aon neu Abram nae, “Abram! Afiꞌ mumutau. Au usulaꞌe nggo mia musu ma. Ma Au fee nggo hahambuꞌ naeꞌ.” ");
INSERT INTO row_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Te Abram nae, “Eee, Lamatualain. Onaꞌ mae Lamatualain nae fee au naeꞌ o, nda ngguna saa saꞌ boe. Huu au nda ma anaꞌ fo fee au tititi-nonosiꞌ sa. Dadꞌi hambu hata-hetoꞌ nae-nae tao neu saa? Neꞌo akaꞌ au ate ngga, Eliasar mia Damsik, hambu basa se.” ");
INSERT INTO row_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Te LAMATUALAIN nataa nae, “Nda taꞌo naa sa! Te ho ana ma mana hambu hata-heto ma, nda ate a sa.” ");
INSERT INTO row_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Boe ma Ana no Abram dea neu, de nafadꞌe nae, “Mete lalai a dei. Mete sobꞌa nduuꞌ ra. Ho reken mala se, do? Tititi-nonosi mara dei fo ramaheta onaꞌ nduuꞌ ra boe!” ");
INSERT INTO row_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram rena nala ma, ana simbo LAMATUALAIN oꞌola na. De LAMATUALAIN uku nae, Abram rala ndos, huu namahere E. ");
INSERT INTO row_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","LAMATUALAIN olaꞌ tute nae, “Au ia, Lamatualain. Au mana o nggo lao hela kambo Ur sia atahori Kasdim rae na. Au mana fee rae ia dadꞌi hata-heto ma.” ");
INSERT INTO row_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Abram natane nae, “Dadꞌi taꞌo bee LAMATUALAIN? Taꞌo bee fo uhine ae rae ia dadꞌi au hata-heto ngga?” ");
INSERT INTO row_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Boe ma nataa nae, “Taꞌo ia! Uma fo ata tao dalaꞌ esa dadꞌi hehelu-fufuliꞌ neu Au oꞌola Ngga faꞌ ra. De muu haꞌi banda fee Au. Naeni, sapi ine sa, hiek ine sa, ma bibꞌi lombo mone sa. Basa se musi too beꞌe teluꞌ. Boe ma mendi seluꞌ mbui teu esa, no mbui lunda esa.” ");
INSERT INTO row_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Boe ma Abram neu haꞌi basa banda naa ra. De ana sefa se reu beꞌe ruaꞌ. Ana mbedꞌaꞌ sisi naa ra banggi rua neu rae, esa mbali esa, dadꞌi dalaꞌ rua. Te ana nda sefa mbuiꞌ ra sa. ");
INSERT INTO row_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Dei de mbui-mbuiꞌ mana naa sisi mburuꞌ ra rema rae raa sisi naa ra. Te Abram oi hendi se. ");
INSERT INTO row_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Relo a nae mopo ma, Abram sungguꞌ nasambeta ma nalamein nae, maꞌahatuꞌ a tatana nala e, losa namatau seli. ");
INSERT INTO row_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","15","Ma Lamatualain nafadꞌe e nae, “Abram! Dei fo musodꞌa losa mumulasi mala seli, ma mate mo nemehoꞌot, fo raꞌoi nggo no malolole. Te tititi-nonosi mara dadꞌi atahori manatain sia atahori feaꞌ nusa na. Dei fo atahori sia nusaꞌ naa tao se dadꞌi ate, ma tuni-ndeni se losa too natun haa. Te Au huku-doki nusaꞌ naa atahori nara. Basa fo Au o tititi-nonosi mara lao hela naa, ma rendi basa hata-heto nara. ");
INSERT INTO row_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Dei fo Au ulalao tititi-nonosi ka lima ma baliꞌ ia rema. Aleꞌ ia, atahori Amori ra leo sia rae ia. Atahori ia ra deꞌulakaꞌ, te nda feꞌe raseliꞌ sa. Mete ma umbu-ana mara baliꞌ ia rema, Au ae pake se fo hukun atahori Amori ra. Te leleꞌ naa, deꞌulaka nara raseliꞌ ena.” ");
INSERT INTO row_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Tetemba na aiboiꞌ ma, hura rae sa namasu, ma mbele sa mbila, raꞌaundaꞌ tungga sisi dala karuaꞌ ra taladꞌa na. ");
INSERT INTO row_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Leleꞌ naa, LAMATUALAIN helu-fuli no Abram nae, “Au helu fee nusaꞌ ia neu tititi-nonosi mara, mia loe Masir, losa loe Efrat, ");
INSERT INTO row_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ma atahori Keni, Kenas, Kadmon, ");
INSERT INTO row_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Het, Feris, Refaim, ");
INSERT INTO row_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amori, Kanaꞌan, Girgasi, ma Yebus rae nara.” ");
INSERT INTO row_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","3","Leleꞌ naa, Abram baliꞌ mia Masir, de leo sia Kanaꞌan too sanahulu ena. Sao na Sarai, nda feꞌe ma anaꞌ sa. Te Sarai ma ate inaꞌ mia Masir, naran Hagar. Lao esa ma, Sarai ola-olaꞌ no Abram nae, “Aꞌa! LAMATUALAIN babata mamana ana ngga ena. De malole lenaꞌ, muu sungguꞌ mo ate ngga Hagar, fo ana bꞌonggi fee au.” Abram tungga sao na oꞌola na boe. De Sarai fee Hagar dadꞌi Abram sao muri na. ");
INSERT INTO row_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Boe ma Abram neu sungguꞌ no Hagar, de nairu. Hagar bubꞌuluꞌ eni mairuꞌ ma, ana koao, de naloe Sarai. ");
INSERT INTO row_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Boe ma Sarai olaꞌ no Abram nae, “Au mana fee ate naa fo dadꞌi sao muri ma. Te ana bubꞌuluꞌ eni mairuꞌ, ma naloe-nadꞌae au. Ia, ho sala ma! Hela fo LAMATUALAIN naꞌetuꞌ hita ruꞌa nggita dedꞌea na. Dei fo ho bubꞌuluꞌ!” ");
INSERT INTO row_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abram nataa nae, “Taꞌo ia! Ho ia, sao ulu ngga. Eni, sao muriꞌ a. Dadꞌi muꞌena koasa neu e. Mae tao saa mbali e, siaꞌ a nggo!” Boe ma Sarai tao suka-ranggaꞌ e, losa ana nela. ");
INSERT INTO row_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Hagar nela losa nembe saraꞌae ma, LAMATUALAIN ate na esa mia sorga, hambu e deka no oe mataꞌ sia dalaꞌ mana nisiꞌ Sur. ");
INSERT INTO row_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ana nae, “We! Hagar, Sarai ate na! Taꞌo bee de ho sia ia? Mia bee uma ma mae bee muu?” Nataa nae, “Au lao hela nyora ngga.” ");
INSERT INTO row_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","De LAMATUALAIN ate na kokoe nae, “Taꞌo ia! Malole lenaꞌ baliꞌ misiꞌ nyora ma. Ana tao nggo taꞌo bee o, simboꞌ a. ");
INSERT INTO row_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Afiꞌ mumutau. Dei fo au tao tititi-nonosi ma ramaheta, losa atahori nda reken rala se sa. ");
INSERT INTO row_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ho mairuꞌ ena, de nda dooꞌ sa te, bꞌonggi ana touꞌ esa. Musi babꞌae e Ismael (lii na naeꞌ a onaꞌ dedꞌea feaꞌ esa sosoa na ‘Lamatuaꞌ rena’), huu LAMATUALAIN rena haradꞌoi ma. ");
INSERT INTO row_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Anaꞌ naa naꞌamoko nema, nasodꞌa naꞌadꞌoodꞌoꞌ no bobꞌonggi nara. Huu ana onaꞌ ndara fui e, nda rena parendaꞌ sa. Ana labꞌan sudꞌi a se. Ma basa atahori labꞌan baliꞌ e.” ");
INSERT INTO row_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hagar rena nala ma, ana olaꞌ sia rala na nae, “Au ita LAMATUALAIN, mana mete-seꞌu ma nanea au.” De ana noꞌe Lamatualain, no naraꞌ “Lamatualain mana fadꞌuli au.” ");
INSERT INTO row_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Naa de, atahori babꞌae oe mataꞌ naa, naran, Beer Lahai Roi. Sosoa na oi, “Oe mataꞌ mia Mana masodꞌaꞌ, ma Mana mete-seꞌu au.” Oe mataꞌ naa, sia kambo Kades no kambo Beret taladꞌa na. Oe mataꞌ naa feꞌe sia, losa faiꞌ ia. ");
INSERT INTO row_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Basa naa ma, Hagar baliꞌ, de bꞌonggi ana touꞌ esa. Abram babꞌae e Ismael. ");
INSERT INTO row_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Hagar bꞌonggi Ismael te, Abram too falu nulu nee ena. ");
INSERT INTO row_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abram too sio nulu sio ma, LAMATUALAIN natudꞌu Aon neu e nae, “Au ia, Lamatualain fo Mana Koasa. Ho musi tungga mukundoo Au hihii Ngga, ma musodꞌa no ndo-tetuꞌ. ");
INSERT INTO row_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Au ae tao manggatee hehelu-fufuliꞌ Ngga, fo tao tititi-nonosi mara ramaheta.” ");
INSERT INTO row_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abram rena nala ma ana sendeꞌ lululangga na ma naloe langga na losa rae a. Lamatualain o olaꞌ nakandoo nae, ");
INSERT INTO row_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","5","“Au helu-fuli o nggo, taꞌo ia: Dei fo ho dadꞌi leo naeꞌ bei-baꞌi nara. Naa de, nara ma nda afiꞌ Abram sa (sosoa na ‘amaꞌ nenenahineꞌ’), te nara ma dadꞌi Abraham (sosoa na ‘nusaꞌ naeꞌ bei-baꞌi nara’). ");
INSERT INTO row_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Dei fo Au tao tititi-nonosiꞌ mara ramahefu-ramabela. Au ufefela leo naeꞌ mia se, ma soꞌu maneꞌ naeꞌ mia tititi-nonosi naa ra. ");
INSERT INTO row_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Au toꞌu uhereꞌ hehelu Ngga o nggo ma tititi-nonosi mara. Hehelu-fufuliꞌ ia nda etu sa, huu Au ia, ho mo tititi-nonosi mara Lamatualain ma. ");
INSERT INTO row_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Basa rae Kanaꞌan ia, Au fee neu nggo mo tititi-nonosi mara. Oras ia, ho numban a sia ia. Dei fo tititi-nonosi mara soa rae Kanaꞌan ia losa doo na neu. Ma Au o dadꞌi sira Lamatualain na. ");
INSERT INTO row_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","10","Te ho mo tititi-nonosi mara musi toꞌu mihereꞌ hehelu-fufuliꞌ ia losa babasa na. Basa touꞌ ra musi sunat. ");
INSERT INTO row_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","13","Ia naa, ho musi muu sunat basa touꞌ mia fai beꞌe faluꞌ ra. Ho bobꞌonggi ma, atahori mana tao ues ra, no ate fo hasa mia nusa feaꞌ, basa se musi sunat. Sunat ia, dadꞌi hita ruꞌa nggita bukti hehelu-fufuliꞌ na sia hei ao mara. ");
INSERT INTO row_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Touꞌ bee nda sunat sa naa, ana nda masoꞌ sia Au hehelu-fufuli Ngga rala, ma nda dadꞌi Au atahori Ngga sa.” ");
INSERT INTO row_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Basa de, Lamatualain olaꞌ nakandoo nae, “Mia faiꞌ ia, ho afiꞌ moꞌe sao ma, mae Sarai, te maeꞌ a Sara. ");
INSERT INTO row_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Dei fo Au fee papala-babꞌanggiꞌ naeꞌ neu Sara, fo ana bonggi fee nggo ana touꞌ esa. Tebꞌe! Dei fo Sara dadꞌi leo naeꞌ bei-baꞌi nara. Au o soꞌu maneꞌ naeꞌ mia tititi-nonosi na.” ");
INSERT INTO row_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Boe ma Abraham sendeꞌ lululangga na, ma beꞌutee losa rae a. Te ana mali sia rala na, ma duꞌa nae, “Tou lasi naeꞌ too natun esa onaꞌ au ia, feꞌe hambu anaꞌ? Ma Sara o lasi naeꞌ too sio nulu naa, feꞌe nae bꞌonggi ena?” ");
INSERT INTO row_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","De ana nafadꞌe Lamatualain nae, “Lamatualain. Hela fo Ismael hambu au hata-heto ngga o, nda saa saꞌ boe.” ");
INSERT INTO row_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Te Lamatualain nataa nae, “Hokoꞌ! Mete te sao ma Sara bꞌonggi ana touꞌ esa. Ho musi babꞌae naran, Isak. Au hehelu-fufuli Ngga tudꞌa neu e, no tititi-nonosi nara, losa doo na neu. ");
INSERT INTO row_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Te Au o rena saa fo moꞌe fee Ismael. Naa de, Au o fee papala-babꞌanggiꞌ neu e, ma tao umuhefu-umubela tititi-nonosi nara boe. Dei fo hambu maneleo sanahulu rua mia tititi-nonosi nara. Ma tititi-nonosi nara dadꞌi leo esa manaseliꞌ. ");
INSERT INTO row_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Onaꞌ mae taꞌo naa o, Au hehelu-fufuli Ngga ia fee neu ana ma Isak. To mana nemaꞌ ia, nandaa no leleꞌ ia, Sara bꞌonggi e.” ");
INSERT INTO row_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Olaꞌ basa taꞌo naa ma, Lamatualain lao hela Abraham. ");
INSERT INTO row_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","27","Faiꞌ naa boe, Abraham tungga Lamatualain parenda Na, de ana sunat. Ana o sunat Ismael no basa touꞌ mana sia ume na ma basa ate touꞌ ra boe. Leleꞌ naa, Abraham too sio nulu sio, ma Ismael too sanahulu telu. ");
INSERT INTO row_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Lao esa, Abraham leo deka no hau ineꞌ ra sia Mamre, LAMATUALAIN natudꞌu Ao na neu e sia naa. Dudꞌui na taꞌo ia: Faiꞌ naa, mafeoꞌ a seli, de Abraham endoꞌ haꞌi anin mia lalaat mataꞌ. ");
INSERT INTO row_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ana botiꞌ mata na ma, nita atahori telu rambariiꞌ sia naa. Boe ma, ana nelaꞌ soru se, de sendeꞌ lululangga na, ");
INSERT INTO row_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","nae, “Ama nggare! Mete ma bisa na, amaꞌ se tuli au lalaat ngga dei. Onaꞌ mae minu akaꞌ a oe hieꞌ o, malole. ");
INSERT INTO row_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Amaꞌ se hahae sia hau mafoꞌ ia, dei fo au denu ana kara haꞌi oe fo safe ei mara. ");
INSERT INTO row_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ma au uu sadꞌia nanaat fee amaꞌ se, fo maꞌadere baliꞌ, fo feꞌe lao mikindoo na. Au umuhoꞌo bisa uhao amaꞌ se.” Ara rataa rae, “Malole. Makasi. Hai tuli.” ");
INSERT INTO row_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abraham nelaꞌ nisiꞌ lalaat, de nafadꞌe Sara nae, “Lailai! Haꞌi mala tarigu maloleꞌ sak esa, fo tao roti.” ");
INSERT INTO row_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Basa ma nelaꞌ nisiꞌ sapi nara, de paꞌa nala sapi ana mbarunaꞌ esa, ma denu ate na tati, de tunu-nasu e. ");
INSERT INTO row_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Boe ma ana neu haꞌi susu, keju, ma sisi naa, de nendi fee fuiꞌ ra. Ara raa ma, ana nambariiꞌ sia hau huu na, de mete-seꞌu se. ");
INSERT INTO row_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Boe ma ara ratane rae, “Abraham! Sao ma Sara, sia bee? Ana nataa nae, “Sia lalaat rala.” ");
INSERT INTO row_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Boe ma esa mia teluꞌ se olaꞌ nae, “To mana nemaꞌ ia, Au baliꞌ. Leleꞌ naa, sao ma Sara bꞌonggi ana touꞌ esa ena.” Ara olaꞌ taꞌo naa ma, Sara rena mia lelesu a seriꞌ. ");
INSERT INTO row_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Leleꞌ naa, Abraham no Sara lasiꞌ ena, ma Sara o nda afiꞌ hambu fula na sa ena. ");
INSERT INTO row_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Ana rena ara olaꞌ taꞌo naa ma, ana mali sia rala na, ma duꞌa nae, “Awe! Umulasi helaꞌ a rui ngga onaꞌ ia, ma sao ngga o mana masaloeꞌ ena. Naa taꞌo bee hai feꞌe hii dadꞌi masao feuꞌ, fo sangga anaꞌ fai?” ");
INSERT INTO row_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Basa de LAMATUALAIN natane Abraham nae, “Taꞌo bee de Sara mali? Ana duꞌa nae saa fo Au olaꞌ ia, nda dadꞌi sa, huu eni lasiꞌ ena, do? ");
INSERT INTO row_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Au ia, LAMATUALAIN! Nda hambu saa fo Au nda tao alaꞌ sa! Misinedꞌa malolole, e! Mete ma Au baliꞌ too mana nemaꞌ ia, Sara bꞌonggi ana touꞌ esa ena.” ");
INSERT INTO row_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sara rena taꞌo naa ma, namatau. De ana nafanii nae, “Au nda mali sa ma!” Te Lamatualain nataa nae, “Ho mali tebꞌe ma!” ");
INSERT INTO row_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Basa ma, fuiꞌ ka teluꞌ ra rae risiꞌ kamboꞌ Sodꞌom, de Abraham no se losa dalaꞌ taladꞌa na. Mia naa, ara bisa rita Sodꞌom. ");
INSERT INTO row_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Basa ma LAMATUALAIN duꞌa sia rala na nae, “Au ae tao ulutu kambo Sodꞌom, te malole lenaꞌ, Au dui Abraham, ");
INSERT INTO row_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","huu tititi-nonosi nara boe ramaheta, ma dadꞌi leo manaseliꞌ. Ma ana o dadꞌi papala-babꞌanggiꞌ soaꞌ neu basa leo sia raefafoꞌ a. ");
INSERT INTO row_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Au here ala e, fo nanori ana nara ro atahori feaꞌ ra, fo tungga rakandoo LAMATUALAIN dala Na ma rasodꞌa no ndoo-tetuꞌ. Mete ma ara tao taꞌo naa, Au tao utetu hehelu-fufuli Ngga o Abraham.” ");
INSERT INTO row_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Boe ma LAMATUALAIN nafadꞌe Abraham nae, “Taꞌo ia! Au rena atahori ra fale rala nara, huu atahori kambo Sodꞌom no Gomora deꞌulaka nara, seli tebꞌe ena. ");
INSERT INTO row_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Naa de, Au onda, fo ita no mata Ngga, basa saa fo Au renaꞌ a, tebꞌe, do, hokoꞌ. Mete ma hokoꞌ, Au musi bubꞌuluꞌ.” ");
INSERT INTO row_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","LAMATUALAIN feꞌe olaꞌ no Abraham ma, fuiꞌ ka ruaꞌ ra laoꞌ rakandoo risiꞌ Sodꞌom. ");
INSERT INTO row_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abraham neu deka-deka no Lamatualain, de kokoe nae, “Taꞌo bee? Amaꞌ nae tao nalutu atahori maloleꞌ ro atahori deꞌulakaꞌ lao esaꞌ, do? ");
INSERT INTO row_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Mete ma hambu atahori maloleꞌ lima nulu sia kamboꞌ naa, Amaꞌ feꞌe mae tao mulutu basa atahori ra, do? Do, Amaꞌ nda tao mulutu kamboꞌ naa sa, huu sira? ");
INSERT INTO row_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Amaꞌ afiꞌ tao taꞌo naa! Afiꞌ losa atahori maloleꞌ ra o mate boe, huu Amaꞌ nae nalutu atahori deꞌulakaꞌ ra. Amaꞌ dadꞌi mana maꞌetuꞌ sia lalai no raefafoꞌ ia. Amaꞌ o bubꞌuluꞌ naa nda matetuꞌ sa.” ");
INSERT INTO row_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","LAMATUALAIN nataa nae, “Mete ma Au hambu atahori maloleꞌ lima nulu sia Sodꞌom, Au nda hukun kamboꞌ naa sa, huu sira.” ");
INSERT INTO row_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Boe ma Abraham olaꞌ seluꞌ nae, “Amaꞌ, oꞌe ambon, au ae olaꞌ mbei fai. Au ia, atahori nggoaꞌ, nda uhine saa-saa saꞌ boe. ");
INSERT INTO row_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Onaꞌ nda hambu atahori maloleꞌ losa lima nulu sa, te akaꞌ a haa nulu lima, naa taꞌo bee? Mete ma kuran atahori lima, naa Amaꞌ feꞌe mae tao mulutu kamboꞌ naa, do?” Lamatualain nataa nae, “Mete ma Au hambu atahori maloleꞌ haa nulu lima sia naa, Au nda tao ulutu e sa.” ");
INSERT INTO row_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abraham feꞌe kokoe seluꞌ nae, “Mete ma hambu akaꞌ a atahori haa nulu, naa taꞌo bee, Amaꞌ?” Nataa nae, “Mete ma hambu atahori haa nulu, Au nda hukun se sa.” ");
INSERT INTO row_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abraham kokoe nakandooꞌ a nae, “Amaꞌ afiꞌ mumunasa, te mete ma akaꞌ a atahori maloleꞌ telu nulu a, naa taꞌo bee?” Nataa nae, “Mete ma hambu telu nulu, Au nda hukun se sa.” ");
INSERT INTO row_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Basa ma Abraham naloe seluꞌ nae, “Amaꞌ afiꞌ mumunasa, te au utane seluꞌ mbei fai. Mete ma akaꞌ a atahori rua nulu, naa taꞌo bee?” Nataa nae, “Mete ma hambu atahori rua nulu, Au nda tao ulutu kamboꞌ naa sa.” ");
INSERT INTO row_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Boe ma Abraham tatana oꞌola na nae, “Amaꞌ! Au olaꞌ lao esa fai, te afiꞌ mumunasa au, o! Mete ma akaꞌ a atahori maloleꞌ sanahulu a, naa taꞌo bee?” Nataa nae, “Mete ma hambu atahori maloleꞌ sanahulu sia naa, Au nda tao ulutu kamboꞌ naa sa.” ");
INSERT INTO row_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","LAMATUALAIN olaꞌ basa ma, Ana lao nakandoo. Boe ma, Abraham baliꞌ. ");
INSERT INTO row_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Lamatualain feꞌe olaꞌ no Abraham ma, ate Na rua mia sorga risiꞌ kota Sodꞌom. Ara losa naa te, relo a nae mopo ena. Leleꞌ naa, Lot feꞌe endoꞌ sia kota a lelesu ine na. Nita atahori karuaꞌ ra ma, ana neu soru se. Ana sendeꞌ lululangga na ma beꞌutee mia mata nara. ");
INSERT INTO row_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Ma ana olaꞌ nae, “Ama nggare! Ima tuli ume ngga dei. Safe ei mara, ma sungguꞌ. Mbila fefetu na fo, feꞌe lao naa.” Te rataa rae, “Makasi. Afiꞌ tao ia-naa! Hai sungguꞌ miiꞌ a lenu loaꞌ ia.” ");
INSERT INTO row_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Te Lot kokoe nakandooꞌ a, losa ara nau. Boe ma Lot se tunu roti, ma sadꞌia mei fo raa raꞌabꞌue. ");
INSERT INTO row_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Fuiꞌ ra nda feꞌe sungguꞌ sa, te touꞌ Sodꞌom ra moko-anak, rema heo rala Lot ume na. ");
INSERT INTO row_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ara rameli Lot rae, “He, Lot! Tou karuaꞌ faꞌ ra, sia bee? Fee se dea rema, te hai mae bodꞌe se!” ");
INSERT INTO row_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Boe ma Lot dea neu, ma ena lelesu a. ");
INSERT INTO row_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Ana olaꞌ nae, “Toronooꞌ re! Afiꞌ tao deꞌulakaꞌ neu fuiꞌ nggara. ");
INSERT INTO row_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Rena dei! Au ana feto nggara rua, feꞌe feto anaꞌ ra. Onaꞌ bee naa, au fee se reu hei. Hei mae tao se taꞌo bee o, naa siaꞌ a hei e. Sadꞌi afiꞌ tao saa-saa neu au fuiꞌ nggara boe. Huu tungga hita hadat na, au musi unea se malolole.” ");
INSERT INTO row_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Te atahori Sodꞌom ra rameli rae, “Ho afiꞌ sambor! Ho, manatain! Ho atahori deaꞌ, nda muꞌena hak fadꞌuli hai sa. Dinggoꞌ naa! Hokoꞌ naa, hai tao nggo lenaꞌ atahori karuaꞌ naa ra!” Boe ma ara timba hendi Lot, de reu tara lelesu a, fo rae ralutu e. ");
INSERT INTO row_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Te atahori karuaꞌ ra soi lelesu ma loo lima nara de lea Lot ume rala neu. Basa ma, ara nggoe lelesu a, ");
INSERT INTO row_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","ma tao rapokeꞌ atahori Sodꞌom ra mata nara. Naa de, ara nggao-nggao lelesu a, te nda hambu sa. ");
INSERT INTO row_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","13","Basa ma, fuiꞌ ka ruaꞌ naa ra olaꞌ ro Lot rae, “Lot! LAMATUALAIN nahine kamboꞌ ia deꞌulaka na ena. Ana fee hai ima fo tao milutu e. Dadꞌi feꞌe muꞌena odꞌi-aꞌa, ana touꞌ, do inaꞌ, do ana mone feus, do sudꞌi a se sia kamboꞌ ia, do hokoꞌ? Mete ma, sia, muu mala se fo lao hela ia leo!” ");
INSERT INTO row_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","De Lot neu nandaa no touꞌ rua mana rae dadꞌi ana mone feu nara. Nafadꞌe se nae, “Rena malolole! Hei lao hela kamboꞌ ia leo, te LAMATUALAIN nae tao nalutu e!” Te ara rae Lot olaꞌ andiaoꞌ. ");
INSERT INTO row_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Mbila fefetu na ma, Lamatualain ate karuaꞌ naa ra, raꞌasusuuꞌ Lot se lao hela Sodꞌom lai-lai. Ara rae, “Lot! Fela leo! Mendi sao ma, ma ana feto mara ruꞌa se, fo mela hela kamboꞌ ia leo. Afiꞌ losa hei mate hieꞌ a, ma mimbilutu mo kamboꞌ ia.” ");
INSERT INTO row_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Te Lot feꞌe pale-pale. Tao-tao te LAMATUALAIN nae fee ne nasodꞌa. Naa de, fuiꞌ karuaꞌ ra toꞌu lima nara de nore Lot, ma sao na, ma ana feto nara ruꞌa se, de ro se lao hela kamboꞌ naa. ");
INSERT INTO row_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Boe ma fuiꞌ esa parenda se nae, “Melaꞌ lai-lai, fo sangga masodꞌa leo! Afiꞌ mete deaꞌ! Afiꞌ hahae sia lololoꞌ! Mela mikindoo misiꞌ leteꞌ naa, fo hei afiꞌ mate!” ");
INSERT INTO row_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Te Lot nataa nae, “Aduu, amaꞌ! Afiꞌ taꞌo naa! ");
INSERT INTO row_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Memaꞌ amaꞌ tulu-fali fee masodꞌa neu hai. Akaꞌ a leteꞌ naa, doo na seli! Seꞌu te hai nda feꞌe losa naa sa, te deꞌulakaꞌ oi hambu hai siaꞌ a dalaꞌ taladꞌa na ena. ");
INSERT INTO row_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Amaꞌ mete dei. Hambu kambo anaꞌ esa nda naꞌadꞌooꞌ no ia sa. Kamboꞌ naa nda nandaandaa sa. De mete ma amaꞌ nau, naa hai mii sangga masodꞌa sia naa.” ");
INSERT INTO row_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Nataa nae, “Neu! Mii leo! Au nda tao ulutu kamboꞌ naa sa. ");
INSERT INTO row_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Mela lai-lai mii leo! Mete ma hei nda feꞌe losa naa sa naa, au nda bisa tao saa-saa saꞌ boe.” Eniꞌ a leleꞌ naa, atahori babꞌae kamboꞌ naa naran Soar, sosoa na ‘anak’. ");
INSERT INTO row_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Relo a sangga todꞌa ma, Lot se losa Soar. ");
INSERT INTO row_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Aiboiꞌ ma, LAMATUALAIN mbori ai no baleran manahotuꞌ mia lalai a nisiꞌ Sodꞌom no Gomora. ");
INSERT INTO row_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","LAMATUALAIN tao nalutu basa kamboꞌ ra ma basa mana masodꞌaꞌ sia mamanaꞌ naa. Basa atahori, banda, ro hau-bebꞌa ra nenehotuꞌ. ");
INSERT INTO row_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Lot se rela ma, sao na mete deaꞌ. Aiboiꞌ ma, ana dadꞌi rii masiꞌ. ");
INSERT INTO row_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Mbila fefetu anan ma, Abraham neu seluꞌ mia mamanaꞌ fo afis sa ana nambariiꞌ kokoe LAMATUALAIN. ");
INSERT INTO row_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Ana mete raeꞌ neu nisiꞌ Sodꞌom no Gomora no ndule lololoꞌ a. Sia bee-bꞌee masuꞌ bubꞌue-bubꞌueꞌ hene lalai neu. Ma ai a naa hendi basaꞌ e. ");
INSERT INTO row_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Dadꞌi leleꞌ Lamatualain tao nalutu mamanaꞌ a, nasanedꞌa hehelu Na neu Abraham. Naa de, Ana nore hendi Lot mia mamana nenehuku-dokiꞌ naa. ");
INSERT INTO row_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Basa naa ma, Lot namatau leo nakandoo sia kamboꞌ Soar. Naa de, no ana feto nara ruꞌa se lali risiꞌ leteꞌ reu, de ara leo mia luat esa. ");
INSERT INTO row_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Lao esa, ana feto aꞌa ka olaꞌ no odꞌi na nae, “Sia ia, nda hambu touꞌ esa saꞌ boe fo nema sao hita sa. Nda dooꞌ sa te, amaꞌ boe namalasi fo nda bisa hambu anaꞌ sa ena. ");
INSERT INTO row_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","De malole lenaꞌ, ata fee ne ninu mafu, fo sungguꞌ to e. Naa fo, ata tute tititi-nonosi nara.” ");
INSERT INTO row_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Tetembaꞌ naa, ara fee ama na ninu anggor de mafu. Boe ma ana aꞌa ka neu sungguꞌ no e. Te tou lasiꞌ a mafu seli, de nda nitaꞌ nae eni tao sa no ana feto na saꞌ boe. ");
INSERT INTO row_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Mbila ma, aꞌa ka nafadꞌe odꞌi na nae, ‘Odꞌiꞌ! Tembaꞌ a au sungguꞌ o amaꞌ ena. Tetembaꞌ ia, ho hahambu ma. Dei fo tamafuꞌ amaꞌ fai, fo muu sungguꞌ mo e. Naa fo, hita ruꞌa nggita hambu anaꞌ, fo tute tititi-nonosi nara.” ");
INSERT INTO row_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Tetemba na boe, ara tao ramafuꞌ ama na. De ana feto muri ka neu sungguꞌ no e. Te toulasiꞌ a mafu seli, de nda nitaꞌ nae eni tao sa no ana feto na saꞌ boe. ");
INSERT INTO row_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","No taꞌo naa, ruꞌa se rairu mia ama bꞌonggi na. ");
INSERT INTO row_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Boe ma aꞌa ka bꞌonggi ana touꞌ esa. Ana babꞌae e Moab (lii na onaꞌ dedꞌea Ibrani sa, sosoa na nae ‘nema mia amaꞌ’). Ana dadꞌi atahori Moab ra bei-baꞌi nara losa faiꞌ ia. ");
INSERT INTO row_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ma odꞌi a bꞌonggi touꞌ esa. Ana babꞌae e Ben Ami (sosoa na ‘mia au atahori ngga’). Ana dadꞌi atahori Amon ra bei-baꞌi nara losa faiꞌ ia. ");
INSERT INTO row_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Basa ma, Abraham lali mia Mamre, nisiꞌ rae Negeb seriꞌ ona, de leo sia kambo Kades no Sur taladꞌa na. Te nda dooꞌ sa ma, ana lali nisiꞌ kambo Gerar fai. ");
INSERT INTO row_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Nafadꞌe atahori sia naa nae, Sara naa, eni odꞌi na. Naa de, Abimelek, mane Gerar a, denu atahori nara reu roꞌe Sara, fo ro e nisiꞌ ume panggat na. ");
INSERT INTO row_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Tetembaꞌ esa, Lamatualain natudꞌu Aon neu maneꞌ sia meit. Ana olaꞌ nae, “Ho mae mate, ia ena! Huu haꞌi mala atahori sao na.” ");
INSERT INTO row_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","5","Te Abimelek naselu nae, “Lamatualain! Au nda feꞌe kois inaꞌ naa sa. Au nda sala sa. Abraham mana nae, inaꞌ naa eni odꞌi na. Ma inaꞌ naa o nataa taꞌo naa boe. Naa de, au denu reu haꞌi e no rala meuꞌ. Dadꞌi Lamatualain afiꞌ fee salaꞌ neu au!” ");
INSERT INTO row_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Lamatualain nataa nae, “Memaꞌ Au bubꞌuluꞌ rala ma ndos. Naa de, Au tao fo ho afiꞌ kois inaꞌ naa. Naa fo, ho nda tao salaꞌ neu Au saꞌ boe. ");
INSERT INTO row_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ia naa, haitua baliꞌ inaꞌ naa neu sao na. Eni, Au mana ola-ola Ngga. De moꞌe fo ana hule-oꞌe fee nggo fo afiꞌ mate. Te mete ma ho nda fee baliꞌ inaꞌ naa sa, musunedꞌa malolole! Te ho mo basa atahori mara, mate a ia ena.” ");
INSERT INTO row_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Mbila fefetu ana naa, maneꞌ a noꞌe basa pagau nara, de dui meit na. Boe ma basa se ramatau. ");
INSERT INTO row_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Basa ma maneꞌ a noꞌe Abraham, de natane nae, “Au tao salaꞌ saa neu nggo, losa muꞌusususaꞌ au o manggarau nggara taꞌo ia? Ho afiꞌ tao dala deꞌulakaꞌ onaꞌ ia. ");
INSERT INTO row_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Ho duꞌa saa, losa ho tao taꞌo ia?” ");
INSERT INTO row_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham nataa nae, “Ama maneꞌ! Au duꞌa basa hei nda mihine Lamatualain sa. De neꞌo ruma rae tao risa au, fo haꞌi rala sao ngga. ");
INSERT INTO row_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Memaꞌ au olaꞌ tebꞌe, ae eni, au odꞌi ngga. Hai ruꞌa nggi amaꞌ esa, te esaꞌ ina na. Naa de, hai esa sao esa. ");
INSERT INTO row_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Dadꞌi leleꞌ Lamatualain denu hai misiꞌ mamana dodꞌooꞌ, au ufadꞌe sao ngga ae, ‘Mete ma hai mii sia bee-bꞌee, fo atahori ratane hai ruꞌa nggi neꞌebꞌue ma, mete ma ho sue au, naa mutaa mae hita odꞌi-aꞌa.’” ");
INSERT INTO row_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","16","Basa ma, mane Abimelek fee baliꞌ Sara. Ana olaꞌ no e nae, “Ia naa, au bae aꞌa ma doi fulaꞌ rifon esa, fo dadꞌi bukti oi, au nda tao salaꞌ saa-saa o nggo saꞌ boe. Naa fo, basa atahori rahine boe!” Maneꞌ a o olaꞌ no Abraham nae, “Abraham! Au nusa ngga ia, nenesoiꞌ soa neu nggo. Mae muu leo sia bee o, neu.” Ana fee Abraham sapi ma hiek-lombo. Ana o fee ate inaꞌ ma touꞌ boe. ");
INSERT INTO row_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Fefeu na, LAMATUALAIN ena mamana anaꞌ mia basa inaꞌ mana sia Abimelek nusa na, huu ana rambas nala Abraham sao na. Ana fee baliꞌ Sara nisiꞌ sao na ma, Abraham hule-oꞌe, de Lamatualain soi baliꞌ inaꞌ ra mamana ana nara. De ara bisa bꞌonggi seluꞌ fai. ");
INSERT INTO row_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","7","Basa ma, LAMATUALAIN fee papala-babꞌanggiꞌ neu Sara, tungga hehelu-fufuli Na. Abraham too natun esa ena ma, Sara nairu boe. Dai fai na ma, ana bꞌonggi ana touꞌ esa. Abraham babꞌae e, Isak (sosoa na ‘mali’). Sara o olaꞌ nae, “Lamatualain tao au mali, te ia naa au umuhoꞌo. Atahori ra duꞌa rae au nda hambu anaꞌ sia fai lasiꞌ ia sa. Tao-tao te, mae au sao ngga lasiꞌ naeꞌ ena o, au feꞌe bꞌonggi fee ne. De ia naa, sudꞌiꞌ a se rena dalaꞌ ia o, ara mali ro au.” Isak fai falu ma, Abraham sunat e, tungga Lamatualain parenda Na. ");
INSERT INTO row_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Basa ma, Isak boe naꞌamoko. Ara rae fila e ma, Abraham feta-dote monaeꞌ. ");
INSERT INTO row_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","10","Lao esa, Sara nita Abraham sao muri na, Hagar, anan Ismael, akaꞌ a naꞌasesenggoꞌ Isak. De Sara olaꞌ no sao na nae, “Oi hendi ate mana mia Masir no ana na! Au nda nau ate naa ana na simbo hata-heto saa-saa saꞌ boe. Akaꞌ a ana ngga Isak, musi soa basa se.” ");
INSERT INTO row_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Abraham rena Sara olaꞌ taꞌo naa ma, dudꞌuꞌa na nda maloleꞌ sa, huu Ismael o eni anan boe. ");
INSERT INTO row_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Te Lamatualain olaꞌ no e nae, “Bram! Ho afiꞌ duꞌa sao muri ma no ana na. Tunggaꞌ a Sara hihii na, huu tititi-nonosiꞌ fo Au helu-fuliꞌ a, ho hambu miaꞌ a Isak. ");
INSERT INTO row_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Te Au o fee papala-babꞌanggiꞌ neu sao muri ma ana na, huu eni o ho ana ma boe. Mete te tititi-nonosi na dadꞌi leo monaeꞌ saꞌ boe.” ");
INSERT INTO row_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Mbila fefetu anan ma, Abraham tao lepa-ngges fee Hagar, ma fee ne nasalili oe boto esa. De ana mboꞌi inaꞌ naa no anan Ismael lao. Ara lao rereoꞌ rae rouꞌ deka no Beer Syeba. ");
INSERT INTO row_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Oe nininu nara basa ma, Hagar lao hela ana na mia hau huu anaꞌ esa mafo na. ");
INSERT INTO row_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ana duꞌa sia rala na nae, “Au nda uꞌutataaꞌ ita anaꞌ ia mate sa.” Naa de, ana endoꞌ naꞌadꞌodꞌooꞌ mbei ma meter lima nulu mia anaꞌ naa, de nggae ei-ei. ");
INSERT INTO row_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Lamatualain o rena Ismael hara ngganggaet na. Ate Na esa mia sorga noꞌe Hagar nae, “Hagar! Saa de ho susa taꞌo ia? Afiꞌ mumutau, te Lamatualain rena basa ana ma ngganggae na ena. ");
INSERT INTO row_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Ia naa, fela muu seꞌu ana ma, fo tao manggatee rala na. Dei fo Au tao tititi-nonosi na dadꞌi leo manaseliꞌ esa.” ");
INSERT INTO row_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Boe ma Lamatualain tao nameu mata na, losa ana nita oe mataꞌ esa. Ana nadꞌai oe neu boto a, de neu fati ana na. ");
INSERT INTO row_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","21","Basa naa ma, Ismael no ina na leo sia nembe saraꞌaeꞌ Paran. Ana naꞌamoko nema ma, ana dadꞌi mana busu masiꞌet. Basa ma, ina na fee ne sao ina Masir esa. Basa ia ra dadꞌi, huu Lamatualain no Ismael. ");
INSERT INTO row_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Leleꞌ naa, mane Abimelek, no malangga netatiꞌ na, naran Fikol, rema randaa ro Abraham. Maneꞌ a olaꞌ nae, “Abraham! Hai bubꞌuluꞌ Lamatualain no nggo. Naa de, ho tao saa naa, basaꞌ e dadꞌi. ");
INSERT INTO row_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Dadꞌi ia naa, au oꞌe ho sumba sia Lamatualain mata Na, mae ho nda lelekoꞌ au ma umbu-ana nggara sa. Onaꞌ au tao maloleꞌ neu nggo, de ho musi tao maloleꞌ neu au ma nusa ngga ia.” ");
INSERT INTO row_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abraham nataa nae, “Malole! Au sumba.” ");
INSERT INTO row_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Te basa naa ma, Abraham nafadꞌe maneꞌ a nae, “Ama maneꞌ atahori nara rambas rala au oe mata ngga esa.” ");
INSERT INTO row_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Maneꞌ a rena taꞌo naa ma, nataa nae, “Waa! Au feꞌe rena dalaꞌ ia naa. Saa de amaꞌ nda nafadꞌe eniꞌ a dalahulu na sa? Au nda bubꞌuluꞌ seka tao saꞌ boe.” ");
INSERT INTO row_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","28","Basa ma, Abraham no Abimelek tao hehelu-fufuliꞌ. De Abraham haꞌi sapi no bibꞌi lombo fee maneꞌ a. Ma ana humu seluꞌ bibꞌi lombo tenaꞌ hitu fai. ");
INSERT INTO row_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Boe ma maneꞌ a natane nae, “Saa de ho tao taꞌo naa?” ");
INSERT INTO row_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abraham nafadꞌe nae, “Ama maneꞌ simbo bibꞌi lombo tenaꞌ ka hituꞌ ia ra, fo dadꞌi bukti ama maneꞌ mutaa mae, au mana ali oe mataꞌ ia.” ");
INSERT INTO row_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Huu ruꞌa se soꞌu susumbaꞌ sia naa, de ara babꞌae mamanaꞌ naa, Beer Syeba. Sosoa na ‘oe mata susumbaꞌ’. ");
INSERT INTO row_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Ara sumba basa ma, mane Abimelek no malangga netati na baliꞌ risiꞌ sira nusa na Filistin. ");
INSERT INTO row_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Basa de, Abraham sela hau tamareska esa sia Beer Syeba. Mia leleꞌ naa, hau naa fee nesenenedꞌaꞌ neu Abraham oi, sia naa, eni beꞌutee neu LAMATUALAIN mana nasodꞌa losa doo na neu. ");
INSERT INTO row_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","De Abraham numban dooꞌ mia atahori Filistin ra nusa na. ");
INSERT INTO row_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Nda dooꞌ sa ma, Lamatualain sobꞌa Abraham, nae mete ana rena Eni, do hokoꞌ. De Lamatualain noꞌe e nae, “Abraham!” Abraham nataa nae, “Ia, Lamatualain.” ");
INSERT INTO row_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Lamatualain denu e nae, “Rena malolole! Haꞌi mala ana mone ise ma, fo ho sueꞌ a. Mendi e nisiꞌ rae Moria, fo tao e dadꞌi tutunu-hohotuꞌ fee Au. Losa naa, dei fo Au feꞌe utudꞌu ho mamanaꞌ sia leteꞌ sa.” ");
INSERT INTO row_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Mbila fefetu anan ma, Abraham tati hau ai. Ana futu hau naa ra, de fua neu banda keledei. Boe ma, ana no Isak ma ate nara rua, lao risiꞌ mamanaꞌ fo Lamatualain nafadꞌe basa neu e. ");
INSERT INTO row_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Ara lao-laoꞌ, boe ma finiesa na ma, Abraham nita mamanaꞌ naa mia dodꞌooꞌ. ");
INSERT INTO row_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ana nafadꞌe ate karuaꞌ ra nae, “Hei ruꞌa nggi mihati ia dei, mo banda keledei ia. Au o ana ngga mii sia ataꞌ naa dei, mae beꞌutee neu Lamatualain. Basa fo, hai baliꞌ iaꞌ ima fai.” ");
INSERT INTO row_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Boe ma Abraham haꞌi hau ai tutunu-hohotuꞌ, de fua neu Isak aru na. Ana o nendi memaꞌ dombe no hau ma ai. Ruꞌa se laoꞌ data-data ma, ");
INSERT INTO row_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isak noꞌe ama na nae, “Amaꞌ!” Abraham nataa nae, “Taꞌo bee, Isak?” Ana natane nae, “Amaꞌ. Hita tae tunu tutunu-hohotuꞌ. Hau sia ena, ma ai o sia boe. Te bibꞌi lombo anaꞌ fo dadꞌi tutunu-hohotuꞌ a sia bee?” ");
INSERT INTO row_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham nataa nae, “Ana ngge! Dei fo Lamatualain mana fee nggita bibꞌi lombo anaꞌ dadꞌi tutunu-hohotuꞌ.” De ruꞌa se lao rakandoo. ");
INSERT INTO row_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Ara losa mamanaꞌ fo Lamatualain nafadꞌe basaꞌ a ma, Abraham lutu mbatu mei tutunu-hohotuꞌ a. Basa ma, ana naꞌalalangga hau ai neu ataꞌ. De ana paꞌa ana na, ma naꞌalelenggaꞌ e neu hau ai ra ata. ");
INSERT INTO row_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Boe ma haꞌi nala dombe nae mbau nisa ana na. ");
INSERT INTO row_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Te aiboiꞌ ma, LAMATUALAIN ate na mia sorga nameli mia lalai nae, “We! Bram! Helafiꞌ dei!” Ana nataa nae, “Taꞌo bee?” ");
INSERT INTO row_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Boe ma haraꞌ naa nae, “Afiꞌ tao misa anaꞌ naa! Afiꞌ tao saa-saa neu e boe! Ia naa, Au bubꞌuluꞌ tebꞌe-tebꞌeꞌ ho tungga Au hihii Ngga, huu ho nau fee ana mone ise ma, fo dadꞌi tutunu-hohotu neu Lamatualain.” ");
INSERT INTO row_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Basa ma, Abraham nita bibꞌi lombo moneꞌ esa sura na kadꞌoꞌ sia hau anaꞌ ra nggangge nara. Ana neu haꞌi bibꞌi lombo naa, de tunu dadꞌi tutunu-hohotuꞌ soaꞌ neu Lamatualain, nggati ana na. ");
INSERT INTO row_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Naa de, Abraham babꞌae mamanaꞌ naa Yahova Yire, sosoa na ‘Dei fo, Lamatualain fee saa fo parluꞌ a.’ Losa ia, atahori o olaꞌ rae, “Sia LAMATUALAIN lete na ata, dei fo Ana fee saa fo parluꞌ a.” ");
INSERT INTO row_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Basa ma Lamatualain ate Na nameli mia lalai nae, ");
INSERT INTO row_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“LAMATUALAIN nafadꞌe ao Na nae, ‘Au sumba endiꞌ nara ngga, taꞌo ia: Ho nau fee ana mone ise ma neu Au, fo dadꞌi tutunu-hohotuꞌ. Naa de, ");
INSERT INTO row_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Au fee papala-babꞌanggiꞌ nae na seli neu nggo ma tititi-nonosi mara. Dei fo ara boe ramahefu-ramabela losa atahori nda reken rala se sa, onaꞌ nduuꞌ sia lalai, ma saraꞌaeꞌ sia tasi suu na. Dei fo umbu-ana mara o rakalaꞌ musu nara boe. ");
INSERT INTO row_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Mia tititi-nonosi mara, basa leo mana sia raefafoꞌ ia hambu papala-babꞌanggiꞌ, huu ho tungga parenda Ngga ena.’” ");
INSERT INTO row_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Basa ma, Abraham no Isak onda baliꞌ risiꞌ ate ka ruaꞌ ra, de baliꞌ Beer Syeba reu. Boe ma, Abraham se leo sia naa. ");
INSERT INTO row_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Lao esa, Abraham rena oi odꞌi na Nahor sao na Milka bꞌonggi ana nara ena. ");
INSERT INTO row_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Ana uluꞌ a, naran Us. Odꞌi na, naran Bus. Boe ma, Kemuel (ana dadꞌi Aram aman), ");
INSERT INTO row_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","ma Kesed, Haso, Pildas, Yidlaf, no Betuel. ");
INSERT INTO row_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuel ia, Ribka aman. ");
INSERT INTO row_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nahor o hambu seluꞌ anaꞌ mia sao tias na, naran Reuma. Ana bꞌonggi Teba, Gaham, Tahas, no Maaka. ");
INSERT INTO row_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","2","Sara too natun esa rua nulu hitu ma, ana mate. Leleꞌ ana mate, Abraham se leo sia kambo Kiryat-Arba (naeni Hebron), sia rae Kanaꞌan. Abraham nggae ei-ei ma beꞌe sao na mamate na. ");
INSERT INTO row_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Basa ma, ana neu nandaa no atahori Het ra, de olaꞌ nae, ");
INSERT INTO row_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Au ia numban sia hei taladꞌa mara. Au nda ma raeꞌ fo uꞌoi sao ngga sa. Mete ma hei nau, naa fee au hasa hei rae ma mbei, fo au uꞌoi e sia naa.” ");
INSERT INTO row_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Ara rataa rae, ");
INSERT INTO row_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Taꞌo ia amaꞌ! Mia doo na nema, hai tao amaꞌ onaꞌ atahori lasiꞌ esa fo hai fee hadat. Dadꞌi amaꞌ hii neuꞌ ena, rae bee malole lenaꞌ, nandaa no amaꞌ hihii na. Hai simbo no maloleꞌ, esa o nda ai saꞌ boe.” ");
INSERT INTO row_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Boe ma Abraham o beꞌutee fee hadat neu tenu raeꞌ ra, atahori Het ra. ");
INSERT INTO row_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Ana nafadꞌe nae, “Mete ma hei simbo oꞌola ngga faꞌ ra, naa, au oꞌe tulun hei olaꞌ mo toulasi Sohar ana mone na, Efron. ");
INSERT INTO row_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Moꞌe, mete ma ana nau seo luat na, naran Makpela, neu au, naa, hasa ala e. Luat naa, sia osi na suu na. Ana noꞌe feli na sudꞌiꞌ a baꞌu saa o, au bae. Au nau bae etu feli na sia basa hei mata mara, fo rae naa dadꞌi au ena ngga. Au ae tao rae naa, dadꞌi hai mamana rates ma.” ");
INSERT INTO row_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Leleꞌ naa, Efron o endoꞌ no atahori Het ra boe, de ana rena Abraham oꞌola na. Ana nambariiꞌ de nataa Abraham sia basa atahori lasiꞌ ra mata nara nae, ");
INSERT INTO row_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Afiꞌ taꞌo naa, amaꞌ. Te taꞌo ia. Au fee osi naa no luat Makpela neu amaꞌ. Amaꞌ muu muꞌoi sao ma sia naa. Au fee rae naa neu amaꞌ sia atahori nggara mata nara. Naa fo, basa se sakasii!” ");
INSERT INTO row_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Boe ma Abraham beꞌutee seluꞌ sia atahori Het ra mata nara. ");
INSERT INTO row_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Ana olaꞌ no Efron nae, “Naa o malole boe, te rena au dei. Au ae hasa etu rae naa, fo uꞌoi atahori nggara sia naa.” ");
INSERT INTO row_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","15","Efron nataa nae, “Rae naa feli na akaꞌ a doi fulaꞌ natun haa. Soa saa ruꞌa nggita taloe neu-nema akaꞌ doiꞌ mbei anaꞌ naa? Amaꞌ muꞌoi sao ma sia naa leo.” ");
INSERT INTO row_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham naꞌaheiꞌ rae a feli na, tungga Efron oꞌola na. Dadꞌi ana reken doi fulaꞌ natun haa, de bae neu Efron mia basa atahori Het ra mata na, fo ara dadꞌi sakasii. ");
INSERT INTO row_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","19","No taꞌo naa, Abraham hambu Efron rae na, dadꞌi eni ena na. Rae naa sia Makpela, deka no Mamre (naeni Hebron). Ana hasa etu rae naa no osi ma luat na, ma basa hau huuꞌ ra. Basa lasi-lasiꞌ atahori Het ra dadꞌi sakasii rae no isi na, Abraham ena na. Basa naa de, Abraham neu naꞌoi sao na sia luat naa, sia rae Kanaꞌan. ");
INSERT INTO row_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","No taꞌo naa, osi no luat naa fo feꞌesaꞌan na, atahori Het ra rae na, ia naa, dadꞌi Abraham ena na. De ana tao dadꞌi mamana rates. ");
INSERT INTO row_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham uanale na naruꞌ losa namalasi nala seli. LAMATUALAIN nanea e malolole, ma fee ne nasodꞌa no mole dame. ");
INSERT INTO row_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","3","Abraham ate nemehere na esa, tao mataꞌ neu hata-heto nara. Lao esa, Abraham noꞌe e nae, “Rena malolole! Au oꞌe ho sumba mendiꞌ LAMATUALAIN nara na. Lamatualain mana tao lalai no raefafoꞌ a. Mae, ho afiꞌ haꞌi inaꞌ mia atahori Kanaꞌan ra, fo muꞌusasaoꞌ no ana ngga Isak. ");
INSERT INTO row_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Musi muu sia au nusa ngga, sia au bobꞌonggi nggara. Sangga ana fetoꞌ esa sia naa, fo taꞌasasaoꞌ no ana ngga.” ");
INSERT INTO row_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Basa de ate naa natane Abraham nae, “Malole, Amaꞌ! Te mete ma ana fetoꞌ a nda nau nema sa, naa taꞌo bee? Au musi o amaꞌ anan fo sao sia naa, do, taꞌo bee?” ");
INSERT INTO row_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham nataa nae, “Musunedꞌa malolole! Mae taꞌo bee o, afiꞌ mo ana ngga naa neu! ");
INSERT INTO row_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Musunedꞌa te LAMATUALAIN mana toꞌu koasa sia lalai no raefafoꞌ a, no au lao hela nusa ngga, de nendi au losa rae ia. Ana tao hehelu-fufuliꞌ no au nae, ‘Dei fo Au fee basa rae ia neu tititi-nonosi ma.’ Dadꞌi afiꞌ hia-bii! Muu neuꞌ ena. Dei fo Lamatualain denu ate Na mia sorga nema soi dalaꞌ fee nggo, fo mundaa mo ana fetoꞌ mana nae dadꞌi ana ngga sao na. ");
INSERT INTO row_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Te mete ma ana fetoꞌ naa nda nau tungga nema sa, naa susumbaꞌ ia nda dai nggo sa. Mae taꞌo bee o, afiꞌ mo ana ngga naa neu.” ");
INSERT INTO row_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Boe ma, ate a sumba no Abraham, nae eni tao tungga basa Abraham hihii-nanau na. ");
INSERT INTO row_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Basa naa ma, ana here nala onta sanahulu, de no atahori nara fua sudꞌi a saa meulauꞌ ra reu banda onta ra ata. De lao risiꞌ Nahor kambo na sia Mesopotamia. ");
INSERT INTO row_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Neu mateꞌe na, ate a losa kamboꞌ naa. Ana fee banda onta ra hahae deka oe mataꞌ esa, sia kamboꞌ a suu na. Leleꞌ naa bobꞌoꞌ ena, de ana fetoꞌ ra reu hando oe sia oe mataꞌ a. ");
INSERT INTO row_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Boe ma ate a hule-oꞌe nae, “LAMATUALAIN, malangga ngga Abraham Lamatua na. Tulun soi dalaꞌ, fo leleo-lalao ngga ia, hambu maloleꞌ. Mutudꞌu rala malole Ma neu malangga ngga, ma musunedꞌa hehelu-fufuli na neu au. Naa fo, undaa o ana fetoꞌ fo mana nae dadꞌi Isak sao na. ");
INSERT INTO row_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Lamatualain, au umburiꞌ sia oe mataꞌ suu na ia. Ana fetoꞌ mia kamboꞌ ia ra rema hando oe sia ia. ");
INSERT INTO row_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Dadꞌi au oꞌe taꞌo ia: Mete ma au olaꞌ o ana fetoꞌ esa ae, ‘Ana fetoꞌ e! Muꞌondaꞌ hura oe ma fo au inu mbei dei.’ Mete ma nataa nae, ‘Amaꞌ minu leo! Ma au o fee banda onta mara rinu boe.’ Naa, dadꞌi bukti, ana fetoꞌ naa Lamatualain dudꞌu basa dadꞌi Isak sao na! No taꞌo naa, au uhine, Lamatualain mutudꞌu malole ma neu malangga ngga Abraham ena.” ");
INSERT INTO row_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","16","Ana nda feꞌe hule-oꞌe basa sa, te ana fetoꞌ esa naran, Ribka, nema. Eni, Abraham odꞌin Nahor no sao na Milka umbu na. Ribka ama na, naran Betuel. Ribka, meulau na seli, ma feꞌe nda nasalaꞌ no touꞌ ra sa. Ana onda oe mataꞌ neu, nadꞌai hura oe na, de hene baliꞌ. ");
INSERT INTO row_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Ribka losa ataꞌ ma, Abraham ate na nelaꞌ neu. Ana noꞌe nae, “Ana fetoꞌ. Fee au inu mbei dei.” ");
INSERT INTO row_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ana fetoꞌ a nataa nae, “Minu leo, toꞌo!” Ana naꞌondaꞌ hura oe na lai-lai, de fee ate a ninu. ");
INSERT INTO row_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ana ninu basa ma, ana fetoꞌ a nae, “Au hando oe fee toꞌo banda onta nara, fo rinu raꞌabeta boe.” ");
INSERT INTO row_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Ana oni oe sisaꞌ neu banda onta ra mamana nininu nara, ma nelaꞌ neu hando seluꞌ oe sia oe mataꞌ fo hani banda onta naa ra, losa raꞌabeta. ");
INSERT INTO row_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Abraham ate na nambariiꞌ hie-hie, mete namemeu ana fetoꞌ a tatao na. Ana dudꞌuꞌa nae, “Ana fetoꞌ ia, Lamatualain hii nalaꞌ a, do?” ");
INSERT INTO row_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Basa banda onta naa ra rinu losa raꞌabeta. Boe ma ate a fee Ribka bꞌua mafelit fo ana fetoꞌ ra biasa pake. Ana fee ndeli liloꞌ fo nato neu mbana na, ma kale liloꞌ pasan esa, fo olu neu lima nara. ");
INSERT INTO row_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Basa ma, ana natane nae, “Ana fetoꞌ e! Ho ama ma, nara na se? Mete ma nau, naa, au sungguꞌ sia ama ma ume na.” ");
INSERT INTO row_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ana fetoꞌ a nataa nae, “Ama ngga, naran Betuel. Baꞌi ngga, naran Nahor ma nene ngga, Milka. ");
INSERT INTO row_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Sia hai ume ma mamana susungguꞌ dai toꞌo se. Uru o naeꞌ fee toꞌo se banda nara boe.” ");
INSERT INTO row_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Basa ma, ate a beꞌutee neu LAMATUALAIN, ");
INSERT INTO row_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","de olaꞌ nae, “Koa-kio Lamatuaꞌ! Lamatuaꞌ soi dalaꞌ fee au ena, de undaa o malangga ngga Abraham bobꞌonggi nara sia ia. No taꞌo naa, Lamatuaꞌ mutudꞌu rala malole Ma neu malangga ngga Abraham, ma tao mutetu hehelu-fufuli na neu au.” ");
INSERT INTO row_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Basa ma, ana fetoꞌ a nela baliꞌ, de dui ume isi nara, basa saa fo mana dadꞌiꞌ a. ");
INSERT INTO row_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Ribka naa na, naran Labꞌan. Leleꞌ ana nita bua mbilas ra ma rena Ribka dudꞌui na ma, ana nelaꞌ lai-lai, neu nandaa no ate mana rii-rii no banda onta nara deka oe mataꞌ a. ");
INSERT INTO row_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Labꞌan olaꞌ no e nae, “Toꞌo! Lamatualain no toꞌo losa ia no masodꞌaꞌ ena. Dadꞌi afiꞌ mumburiꞌ siaꞌ a deaꞌ! Uma tisiꞌ hai ume ma. Hai sadꞌia kama ena, ma nanaat fee toꞌo se banda onta nara o, naeꞌ boe.” ");
INSERT INTO row_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Basa boe ma, Abraham ate na tungga Labꞌan, de risiꞌ Betuel ume na. Labꞌan se tulun se raꞌondaꞌ sudꞌiꞌ a saa ra mia banda onta ra. Ara fee banda onta ra uru, ma rendi oe fee ate a no atahori nara safe ei nara. ");
INSERT INTO row_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ara tao nanaat neu mei ma, ate a nae, “Hita tae taa, te au ae ufadꞌe duduꞌat esa dei.” Labꞌan nataa nae, “Olaꞌ leo, toꞌo.” ");
INSERT INTO row_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ma ate a nae, “Au ia, hei baꞌi ma Abraham ate na. ");
INSERT INTO row_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","LAMATUALAIN fee papala-babꞌanggiꞌ naeꞌ neu malangga ngga, de namasuꞌi seli. Lamatualain fee lilo mbilas, lilo fulaꞌ, ate touꞌ-inaꞌ, ma banda naeꞌ. Naeni: sapi, banda onta, keledai, ma hiek-lombo. ");
INSERT INTO row_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Au malangga ngga touꞌ-inaꞌ ramalasi, dei de mama Sara bꞌonggi fee malangga ngga ana touꞌ esa. Dei fo, ana mana hambu basa Abraham hata-heto nara. ");
INSERT INTO row_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Lao esa, malangga ngga denu au sumba oi, ‘Ho afiꞌ haꞌi ana feto Kanaꞌan, fo muꞌusasaoꞌ no ana mone ngga Isak. ");
INSERT INTO row_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Te ho musi haꞌi ana fetoꞌ mia bobꞌonggi nggara, dadꞌi eni sao naꞌ.’ ");
INSERT INTO row_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Boe ma au utane malangga ngga ae, ‘Te mete ma ana fetoꞌ a nda nau tungga au sa naa, taꞌo bee?’ ");
INSERT INTO row_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ana nataa nae, ‘LAMATUALAIN fo au tungga hihii Na, dei fo denu ate Na mia sorga nema soi dalaꞌ fee nggo, fo hambu ana fetoꞌ mia au bobꞌonggi nggara, fo dadꞌi ana ngga sao na. ");
INSERT INTO row_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Te mete ma bobꞌonggi nggara nda simbo sa, ma nda nau mboiꞌ ana fetoꞌ a nema sia ia sa, naa, susumbaꞌ naa nda dai nggo sa.’ ");
INSERT INTO row_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Dadꞌi losa oe mataꞌ a ma, au hule-oꞌe sia rala ngga ae, ‘LAMATUALAIN, malangga ngga Abraham Lamatua na. Tulun soi dalaꞌ, fo leleo-lalao ngga ia, hambu maloleꞌ. Naa fo, au undaa o ana fetoꞌ fo mana nae dadꞌi Isak sao na. ");
INSERT INTO row_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Lamatualain, au umburiiꞌ sia oe mataꞌ ia suu na. Ana fetoꞌ mia kamboꞌ ia ra rema hando oe sia ia. Dadꞌi au oꞌe taꞌo ia: Mete ma au olaꞌ o ana fetoꞌ esa ae, ‘Ana fetoꞌ e! Muꞌondaꞌ hura oe ma fo au inu mbei dei.’ ");
INSERT INTO row_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Mete ma ana nataa nae, ‘Amaꞌ minu leo! Ma au o fee banda mara rinu boe.’ Naa, dadꞌi bukti, ana fetoꞌ naa Lamatualain dudꞌu basa dadꞌi Isak sao na! ");
INSERT INTO row_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Au nda feꞌe hule-oꞌe basa sa, te Ribka nema nendi hura oe na, de hando oe sia oe mataꞌ a. Ana hene ata neu ma, au oꞌe ae, ‘Ana fetoꞌ e. Fee au inu mbei dei.’ ");
INSERT INTO row_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Boe ma ana naꞌondaꞌ hura oe na, de nae, ‘Toꞌo e, minu leo! Au o hani toꞌo banda nara boe.’ De au inu ma banda onta ra o rinu boe. ");
INSERT INTO row_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Basa ma, utane e ae, ‘Ama ma, naran seka?’ Nataa nae, ‘Ama ngga, naran Betuel. Baꞌi ngga, Nahor ma nene ngga, Milka.’ Boe ma au fee ne ndeli a ma kale ra. ");
INSERT INTO row_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Boe ma, au beꞌutee neu Lamatualain ae, ‘Koa-kio Lamatualain! Lamatualain soi dalaꞌ fee au, de undaa o malangga Abraham bobꞌonggi nara sia ia. Ma au o undaa o mana nae dadꞌi malangga soruꞌ a sao na boe.’ ");
INSERT INTO row_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","De ia naa, mete ma amaꞌ se mae mitudꞌu susueꞌ neu malangga ngga Abraham, naa, mifadꞌe au relo-relo. Mete ma hokoꞌ o, mifadꞌe relo-relo boe. Naa fo au bubꞌuluꞌ musi tao saa.” ");
INSERT INTO row_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Ate a olaꞌ basa ma, Labꞌan no Betuel rataa rae, “Mete ma LAMATUALAIN tao nala taꞌo naa, naa, hai mae saa fai. ");
INSERT INTO row_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Ribka sia ia, de mo e naa neu leo fo dadꞌi baꞌi Abraham ana feto feu na, tungga saa fo LAMATUALAIN ator nalaꞌ a ena.” ");
INSERT INTO row_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ate a rena nala ma, ana beꞌutee losa rae, fo noꞌe makasi neu LAMATUALAIN. ");
INSERT INTO row_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Basa ma, ana haꞌi lilo mbilas ma lilo fulaꞌ, ma bua-baꞌu meulauꞌ fo fee neu Ribka. Ana o fee sudꞌi a saa mafelit neu Ribka naa na no ina na boe. ");
INSERT INTO row_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Boe ma no atahori nara, endoꞌ raa fefetas. Basa de, ara sungguꞌ sia naa. Mbila fefetu na, ara fela ma, ana nafadꞌe tenu umeꞌ a nae, “Au oꞌe fo, nau naa, hai mae baliꞌ leo misiꞌ malangga ngga.” ");
INSERT INTO row_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Te Ribka naa na no ina na rae, “Hei halai baliꞌ tao saa? Hela Ribka nahani no hai fai sanahulu dei ma. Basaꞌ fo, mo e neu.” ");
INSERT INTO row_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Te nataa nae, “Aduu! Afiꞌ ai au! LAMATUALAIN tulun au ena, de au undaa o mana nae dadꞌi malangga soru ngga sao na. De inaꞌ se mboꞌi hai, fo baliꞌ mii mifadꞌe malangga dei.” ");
INSERT INTO row_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ara rataa rae, “Taꞌo ia! Ima fo tataneꞌ a Ribka, eni hihii na, taꞌo bee?” ");
INSERT INTO row_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Boe ma ara roꞌe Ribka, de ratane rae, “Ribka! Ia siaꞌ a nggo. Mae tungga memaꞌ mo atahori ia ra leo, do taꞌo bee?” Ana nataa nae, “Au nau.” ");
INSERT INTO row_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","60","Boe ma, ara mboꞌi Ribka, no ate inan mana mete-seꞌu e eniꞌ a aꞌanan, fo reu ro Abraham ate nara. Ara olaꞌ fee Ribka papala-babꞌanggiꞌ rae, “Ribka! Hai hule-huleꞌ fo Lamatualain fee nggo bꞌonggi mumuhefu, fo tititi-nonosi mara dadꞌi rifo-rataꞌ. Ma hai o hule-huleꞌ fo tititi-nonosi mara rasenggiꞌ musu nara!” ");
INSERT INTO row_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Basa naa ma, Ribka no ate ina nara raꞌalilinuꞌ bua-baꞌu nara, de sae banda onta, fo lao ro Abraham ate nara. ");
INSERT INTO row_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Lele naa, Isak leo sia rae Negeb. Ana feꞌe baliꞌ mia oe mataꞌ sia Beer Lahai Roi. ");
INSERT INTO row_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Bꞌobꞌobꞌoꞌ esa, ana dea neu lao-laoꞌ haiꞌ anin. Ana botiꞌ mata na ma, nita banda onta ra rema. ");
INSERT INTO row_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ribka nita Isak ma, ana onda lai-lai mia banda onta na. ");
INSERT INTO row_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Natane Abraham ate na nae, “Toꞌo! Touꞌ mana laoꞌ nema naa, seka?” Ate a nataa nae, “Naeni au malangga soru ngga.” Boe ma Ribka haꞌi nala salenda na, de babata mata na. ");
INSERT INTO row_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Ara losa ma, ate a nafadꞌe basaꞌ e neu Isak. ");
INSERT INTO row_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Boe ma Isak no Ribka risiꞌ inan lalaat na rala, de ruꞌa se esa sao esa. Isak sue Ribka, naa de, ana nda afiꞌ susa ina na mamaten sa ena. ");
INSERT INTO row_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham sao seluꞌ inaꞌ esa, naran Ketura. ");
INSERT INTO row_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","De Ketura bꞌonggi fee ne, anaꞌ nara nara: Simran, Yoksan, Medan, Midian, Isbak, ma Sua. ");
INSERT INTO row_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yoksan ana nara, Seba no Dedan. Dedan tititi-nonosi nara, naeni atahori Asyur, atahori Letus, ma atahori Leum ra. ");
INSERT INTO row_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midian ana nara, Efa, Efer, Henok, Abida ma Elda. Basa naa ra, Ketura tititi-nonosin. ");
INSERT INTO row_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","6","Leleꞌ Abraham feꞌe masodꞌaꞌ, ana bꞌanggi fee sudꞌi a saa neu Hagar no Ketura ana nara. Ana denu se reu leo sia Kanaꞌan seriꞌ rulu, fo raꞌadꞌodꞌooꞌ ro anan Isak. Te basa hata-hetoꞌ ra, ana fee neu Isak. ");
INSERT INTO row_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Abraham too natun esa hitu nulu lima ma, ana mate. ");
INSERT INTO row_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","Ana nara Isak no Ismael raꞌoi e sia luat Makpela, deka no Mamre. Abraham hasa etu osi naa mia atahori Het esa, naran Efron, fo Sohar anan. Maꞌahulu na, ana naꞌoi Sara sia luat naa. ");
INSERT INTO row_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abraham mate ma, Lamatualain fee papala-babꞌanggiꞌ neu Isak, de ana nasodꞌa no mole-dame. Leleꞌ naa, ana leo deka oe mataꞌ, naran Beer Lahai Roi. ");
INSERT INTO row_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ismael dudꞌui na, taꞌo ia. Eni ia, Abraham no sao tias na Hagar ana na. Ma Hagar ia, Sara ate na mia Masir. ");
INSERT INTO row_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","16","Ismael ana nara touꞌ sanahulu rua. Nara nara batutunggaꞌ mia uluꞌ a losa odꞌi muriꞌ a: Nebayot, Kedar, Adbeel, Mibsam, Misma, Duma, Masa, Hadad, Tema, Yetur, Nafis, ma Kedma. Anaꞌ naa ra, dadꞌi bei-baiꞌ mia leo sanahulu rua, esa-esaꞌ no nusa na. Ara babꞌae nusaꞌ naa ra, esa-esa tungga bei-baꞌiꞌ ra naran. ");
INSERT INTO row_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismael too natun esa telu nulu hitu ma, ana mate. ");
INSERT INTO row_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Te tititi-nonosi nara, esa namusuꞌ no esa. Basa se leo saranggaa mia Hawila losa Syur, fo natoo no nusa Masir, nakandoo losa Asyur. ");
INSERT INTO row_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Abraham anan Isak dudꞌui na, taꞌo ia. ");
INSERT INTO row_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isak too haa nulu ma, ana sao Ribka. Ribka ia, aman, Betuel. Ma naa na, Labꞌan. Sira, atahori Aram, mia Padan Aram. ");
INSERT INTO row_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Huu Ribka nda hambu anaꞌ sa, de Isak hule-oꞌe neu LAMATUALAIN noꞌe soi Ribka mamana ana na. Boe ma LAMATUALAIN rena hule-oꞌe na, de Ribka nairu. ");
INSERT INTO row_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Tao-tao te, ana nairu ana duaꞌ. Ana kara ratimba-rasamba rakandooꞌ a sia inan ambu na. De Ribka natatane sia rala na nae, “Taꞌo bee de ruꞌa se, taꞌo ia, e?” De natane LAMATUALAIN. ");
INSERT INTO row_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","LAMATUALAIN nataa nae, “Sia ambu ma rala, hambu nusaꞌ rua. Dei fo ara ramusuꞌ rakandooꞌ a. Mete te, muriꞌ a maꞌadereꞌ lenaꞌ uluꞌ a. Ma aꞌa ka tao ues fee odꞌiꞌ a.” ");
INSERT INTO row_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Fai na losa ma, Ribka bꞌonggi ana touꞌ rua. ");
INSERT INTO row_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Aꞌa ka ao na mbilas, ma mafuluꞌ. Naa de, ara babꞌae e, Esau (lii na onaꞌ dedꞌea feaꞌ esa, sosoa na ‘mafuluꞌ’). ");
INSERT INTO row_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Basa de, odꞌi na feꞌe dea nema. Te ana toꞌu aꞌan ei tinggan. Naa de, ara babꞌae e, Yakob (lii na naeꞌ a onaꞌ dedꞌea feaꞌ esa, sosoa na ‘ei tinggaꞌ’). Leleꞌ Ribka bꞌonggi ruꞌa se, Isak too nee nulu ena. ");
INSERT INTO row_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Ana karuaꞌ ra raꞌamoko ma, Esau dadꞌi mana sombu banda fui. Ana hiiꞌ a leo sia lasi. Te Yakob, mana neneeꞌ ma hii leo siaꞌ a ume. ");
INSERT INTO row_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isak hii naa sisi banda fui. Naa de, ana sue Esau nalenaꞌ. Te Ribka sue Yakob nalenaꞌ. ");
INSERT INTO row_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Lao esa, Yakob tao kua fufue mbilas ma, Esau feꞌe sombu baliꞌ naa. Ana bengge ma ndoe nala seli. ");
INSERT INTO row_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Nafadꞌe Yakob nae, “Odꞌiꞌ e! Au ndoe ae mate ena. Fee au kua fufue mbilas mbei dei.” (Naa de, ara roꞌe e rae, Edom. Lii na, naeꞌ a onaꞌ dedꞌeat esa, fo sosoa na ‘mbilas’.) ");
INSERT INTO row_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Boe ma Yakob nataa nae, “Malole, aꞌa. Te fee au hak ulu ma dei!” ");
INSERT INTO row_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau nataa nae, “Parsetan no hak uluꞌ naa! Soa e leo! Au ndoe ena! Sodꞌe mendi leo, te au ae ua.” ");
INSERT INTO row_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Te Yakob olaꞌ fai nae, “Aꞌa helafiꞌ dei! Aꞌa sumba dei mae, aꞌa fee au hak naa.” Boe ma Esau sumba. ");
INSERT INTO row_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Basa de, Yakob sodꞌe fee ne kua fufue no roti. Esau naa-ninu basa ma, ana fela lao. No tao naa, Esau fee hieꞌ hendi hak ulu na. ");
INSERT INTO row_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Lao esa, hambu ndoe-laꞌas manaseliꞌ sia nusaꞌ naa, onaꞌ ndoe-laꞌas leleꞌ Abraham feꞌe masodꞌaꞌ. Dadꞌi Isak neu noꞌe isin sia Abimelek, atahori Filistin ra mane na, fo eni bisa leo sia Gerar. ");
INSERT INTO row_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ana tao taꞌo naa, huu LAMATUALAIN natudꞌu Ao na neu e nae, “Afiꞌ muu sia Masir. Dei fo Au utudꞌu nggo mamana feaꞌ. ");
INSERT INTO row_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","4","Mete ma ho leo manumban sia mamanaꞌ naa, naa, Au o nggo, ma fee nggo papala-babꞌanggiꞌ mataꞌ-mataꞌ. Au tao tititi-nonosi mara ramahefu, onaꞌ nduuꞌ sia lalai a. Au fee nggo mo tititi-nonosi mara mamanaꞌ ia no basa nusa nara. Mia tititi-nonosi mara, basa atahori raefafoꞌ a hambu papala-babꞌanggiꞌ. No naa, Au tao utetu hehelu-fufuli ngga o amam Abraham. ");
INSERT INTO row_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Au tao basa ia ra, huu amam tungga hihii Ngga, parenda Ngga, ma dala Ngga.” ");
INSERT INTO row_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","De Isak leo manumban sia Gerar. ");
INSERT INTO row_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ribka, meulau na seli. Dadꞌi atahori sia naa ra rita e ma, ara ratatane e. Te Isak nataa nae, “Ribka ia, au odꞌi ngga.” Ana namatau mete ma eni nataa nae sao na, neꞌo atahori ra tao risa e fo haꞌi rala Ribka. ");
INSERT INTO row_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isak leo dodꞌoo sia naa ena ma, lao esa maneꞌ a nakaloloik mia jendela, ma nita Isak holu ma idꞌu Ribka. ");
INSERT INTO row_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Boe ma ana denu atahori roꞌe Isak, de natane e nae, “Isak! Inaꞌ naa, sao ma! Saa de mae, ho odꞌim?” Isak nataa nae, “Taꞌo ia, amaꞌ! Au umutau mete ma ae eni, au sao ngga, afiꞌ losa atahori ra tao risa au.” ");
INSERT INTO row_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Maneꞌ a nataa nae, “Mete ma atahori sia ia sungguꞌ ro sao ma naa, ho fee salaꞌ neu hai! Taꞌo bee de ho tao taꞌo naa neu hai?” ");
INSERT INTO row_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Basa ma, Abimelek fee nesenenedꞌaꞌ neu rauinggu nara nae, “Misinedꞌa malolole! Hei seka mimbirani ngganggu atahori ia, do sao na, naa, au hukun isa nggi.” ");
INSERT INTO row_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Leleꞌ naa, Isak sela-nggari sia nusaꞌ naa. Ana hambu baliꞌ buna-bꞌoa na lao natun esa, huu LAMATUALAIN fee ne papala-babꞌanggiꞌ. ");
INSERT INTO row_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Ana bau namasuꞌi, losa namasuꞌi raranggi. ");
INSERT INTO row_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Sapi, bibꞌi, ma hiek nara, boe ramahefu. Ana mana tao ues nara o, hetar boe. De atahori Filistin ra rala nara mera mbali e. ");
INSERT INTO row_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Maꞌahulu naa, Isak aman Abraham se ali oe mataꞌ naeꞌ. Te ia naa, atahori Filistin ra mbori raꞌateme oe mataꞌ ra no rae. ");
INSERT INTO row_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Boe ma mane Abimelek olaꞌ no Isak nae, “Isak! Malole lenaꞌ, ho lao hela nusaꞌ ia leo. Te koasa ma lenaꞌ hai ena.” ");
INSERT INTO row_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Basa de, Isak lao hela naa, de neu leo baliꞌ sia lololoꞌ Gerar. ");
INSERT INTO row_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ana ali baliꞌ oe mataꞌ, fo ara tatanaꞌ ra. Ana babꞌae oe mataꞌ ra, tungga nara-naraꞌ fo ama na babꞌae nalaꞌ ra. ");
INSERT INTO row_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Isak ate nara ali oe mataꞌ sia lololoꞌ Gerar ma, ara ali dai oe a mata na, de nasapupuraꞌ dea neu. ");
INSERT INTO row_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Te Gerar manatadꞌa nara rareresi ro Isak manatadꞌa nara, huu oe mataꞌ naa. Ara rae, “Ia hai oe ma!” Naa de, Isak babꞌae oe mataꞌ naa Esek, sosoa na ‘rareresi’. ");
INSERT INTO row_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Basa ma, Isak atahori nara ali seluꞌ oe mataꞌ esa fai. Te ara rareresi fai, huu oe mataꞌ naa. Naa de, Isak babꞌae oe mataꞌ naa, Sitna, sosoa na ‘balabꞌan’. ");
INSERT INTO row_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Basa naa ma, ana lao hela mamanaꞌ naa, de ali seluꞌ oe mataꞌ feaꞌ fai. Ia ma, ara nda rareresi sa. Naa de Isak babꞌae oe mataꞌ naa, Rehobot, sosoa na ‘mamana loaꞌ’. Ana olaꞌ nae, “Ia naa, Lamatualain fee hita leo sia mamana loaꞌ. Sia ia dei de, hita feꞌe tamahefu naa.” ");
INSERT INTO row_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Mia naa, Isak se lao fo reu leo sia Beer Syeba. ");
INSERT INTO row_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Tetembaꞌ naa, LAMATUALAIN natudꞌu Ao na neu e, ma olaꞌ nae, “Isak! Au ia, ho ama ma Abraham Lamatualain na. Afiꞌ mumutau, te Au unea nggo. Au fee nggo papala-babꞌanggiꞌ. Ma tititi-nonosi mara boe ramahefu. Au tao taꞌo ia, huu hehelu-fufuli Ngga neu ama ma.” ");
INSERT INTO row_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Basa ma Isak lutu mbatu mei tutunu-hohotuꞌ sia naa, de noꞌe makasi neu LAMATUALAIN. Ana leo sia naa, ma atahori nara ali oe fai. ");
INSERT INTO row_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Leleꞌ naa, mane Abimelek nema mia Gerar. Ana nema no nonoo na Ahusat, ma malangga netati na, Fikol, fo randaa ro Isak. ");
INSERT INTO row_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isak natane nae, “Ama maneꞌ! Feꞌesaꞌan, hei oi hendi hai ena. De ia naa, hei ima mae tao saa fai?” ");
INSERT INTO row_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ara rataa rae, “Taꞌo ia! Ia naa hai bubꞌuluꞌ mae, Lamatualain nanea nggo. Huu naa, hai duꞌa-duꞌa, maloleꞌ lenaꞌ ruꞌa nggita tao hehelu-fufuliꞌ taꞌo ia: Ho sumba mae, ");
INSERT INTO row_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","hei nda tao deꞌulakaꞌ mbali hai sa, onaꞌ hai o nda tao deꞌulakaꞌ mbali hei saꞌ boe. Memaꞌ hai rala mara maloleꞌ mo hei. Naa de, fai mana neuꞌ naa ra, hei lao mo mole-dame mia hai mbuku-kambo ma. Hai mihine tebꞌe-tebꞌeꞌ, LAMATUALAIN mana fee papala-babꞌanggiꞌ neu hei.” ");
INSERT INTO row_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Basa ma, Isak tao fefetas, de raa-rinu raꞌabꞌue reu esa. ");
INSERT INTO row_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Mbila fefetu na ma, ara tao susumbaꞌ. Dei de Isak fee se baliꞌ no mole-dame. ");
INSERT INTO row_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Faiꞌ naa, Isak atahori mana tao ues nara rema rafadꞌe rae oe mataꞌ fo sira aliꞌ a, hambu oeꞌ ena.” ");
INSERT INTO row_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","De Isak babꞌae oe mataꞌ naa, Syeba, sosoa na ‘susumbaꞌ’. Ara babꞌae kamboꞌ naa Beer Syeba, losa faiꞌ ia. ");
INSERT INTO row_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esau too haa nulu ma, ana sao nala ana fetoꞌ rua mia leo Het. Esa, Beeri ana na, naran Yudit. Ma esa fai, Elon ana na, naran Basmat. ");
INSERT INTO row_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Inaꞌ ka ruaꞌ naa ra, raꞌasususaꞌ Isak no Ribka rala nara. ");
INSERT INTO row_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isak namalasi ma, mata nara rangga, de noꞌe ana ulu na, fo ana sue naseliꞌ a nae, “Sau e! Uma ia dei!” Esau nataa nae, “Taꞌo bee, amaꞌ?” ");
INSERT INTO row_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isak nafadꞌe nae, “Taꞌo ia! Au, lasiꞌ ena. Nda bubꞌuluꞌ fai hiraꞌ naa au mate sa. ");
INSERT INTO row_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","De haꞌi tee-tande mara, fo muu sombu banda fui esa fee au dei. ");
INSERT INTO row_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Baliꞌ naa, tunu-nasu maladꞌa-maladꞌaꞌ tungga au hihii ngga, fo mendi nema. Ua basa fo, au fee nggo papala-babꞌanggiꞌ. Basa naa, fo au mate o, malole.” ");
INSERT INTO row_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Boe ma, Esau lao neu sombu banda. Te Ribka o rena Isak oꞌola na boe. ");
INSERT INTO row_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","De neu nafadꞌe Yakob nae, “We, Ako! Rena malolole! Faꞌ ra ama ma olaꞌ no Esau taꞌo ia: ");
INSERT INTO row_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Muu sombu banda fui esa, fo tunu-nasu maladꞌa-maladꞌaꞌ fee au. Mete ma au ua basa, dei fo au fee nggo papala-babꞌanggiꞌ, sia LAMATUALAIN mata na.’ ");
INSERT INTO row_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","De rena malolole, Ako! Tungga tebꞌe-tebꞌeꞌ parenda ngga ia. ");
INSERT INTO row_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Oras ia, muu sia hita lalaet hiek-lombo na, fo hii mala hie tena mbarunaꞌ rua. Mbau se fo haꞌi mala sisi na, mendi fee au. Dei fo au tunu-nasu tungga ama ma hihii na. ");
INSERT INTO row_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Au tunu-nasu ala, naa, mendi fee ama ma fo ana naa. Basa fo, ana fee nggo papala-babꞌanggiꞌ, dei fo ana feꞌe mate na. No taꞌo naa, ho mana hambu papala-babꞌanggiꞌ naa, te nda aꞌa ma sa.” ");
INSERT INTO row_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Boe ma Yakob olaꞌ no ina na nae, “Te Inaꞌ e! Aꞌa Saul ao na mafuluꞌ, te au ao ngga manggamomouꞌ! ");
INSERT INTO row_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Afiꞌ losa amaꞌ nafaroe ao ngga ma, ana nahine au eꞌedik e. Boe ma ana sumba-ndoon au!” ");
INSERT INTO row_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ma ina na nataa nae, “Ako e! Afiꞌ duꞌa saꞌ boe. Fee nema, dei fo au tao dalan! Mete ma amam sumba-ndoon nggo, dei fo au lemba-doi! De muu haꞌi hiek leo.” ");
INSERT INTO row_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Dei de, Yakob neu humu nendi hiek ra, de ana mbau, ma nendi fee ina na. Ma Ribka tunu-nasu tungga Isak hihii na. ");
INSERT INTO row_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Ana o haꞌi Esau bua-baꞌu malole na, de fee Yakob pake. ");
INSERT INTO row_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Ma ana mboti Yakob lima na no nggara-bote na, nendiꞌ hiek ka fulu na. ");
INSERT INTO row_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Ma ana fee Yakob nanaa maladꞌaꞌ naa ra, no roti fo ana taoꞌ a. ");
INSERT INTO row_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Boe ma Yakob nendi nanaat naa fee ama na. Ana olaꞌ nae, “Ama ngge! Au uma ena.” Isak nataa nae, “Hee? Ho seka?” ");
INSERT INTO row_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakob nataa nae, “Au ia, amaꞌ ana ulu na, Esau! Au tao tungga saa fo amaꞌ denu faꞌ ra. Fela fo mua leo. Au nasu ala sisi fo sombu endi mia lasi a. Mua, fo basa na fee au papala-babꞌanggiꞌ leo!” ");
INSERT INTO row_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ma Isak olaꞌ nae, “Ho seli, o! Ho hambu banda fui lai-lai neuꞌ ena!” Yakob nataa nae, “Au hambu lai-lai, huu LAMATUALAIN fo amaꞌ beꞌutee neuꞌ a, tulu-fali au.” ");
INSERT INTO row_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Boe ma Isak noꞌe Yakob nae, “Uma deka-deka, fo au ufuroe sobꞌa nggo! Ho ia, tebꞌe Esau, do?” ");
INSERT INTO row_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yakob neu deka no ama na, de lasiꞌ a nafaroe e. Ma ana olaꞌ nae, “Haraꞌ ia, onaꞌ Yakob hara na! Te limaꞌ ia, onaꞌ Esau lima na.” ");
INSERT INTO row_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Isak nda nahine ana na Yakob sa, huu lima na mafuluꞌ onaꞌ a Esau. Ana nae fee papala-babꞌanggiꞌ neu Yakob ma, ");
INSERT INTO row_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","natane seluꞌ fai nae, “Ho ia, tebꞌe-tebꞌeꞌ Esau, do?” Yakob nataa nae, “Tebꞌe amaꞌ!” ");
INSERT INTO row_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Boe ma, Isak olaꞌ nae, “Lo sisi naa nema, te au ae ua. Dei fo, fee nggo papala-babꞌanggiꞌ.” Yakob loo sisi a neu e, ma fee oe anggor fo ana ninu. ");
INSERT INTO row_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Basa ma, ama na olaꞌ nae, “Ana ngge! Uma deka-deka sia ia, fo idꞌu au dei.” ");
INSERT INTO row_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yakob neu deka-deka de idꞌu e, ma Isak hae nala Esau bua-baꞌu na foo na. Basa de, ana olaꞌ fee Yakob papala-babꞌanggiꞌ nae, “Ana ngga foo na, onaꞌ nembe uru fo LAMATUALAIN pala-banggiꞌ. ");
INSERT INTO row_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Au hule-oꞌe fo Lamatualain naꞌondaꞌ dinis mia lalai a nema, fo tao osi-lutu mara dadꞌi meulauꞌ! Fo Ana fee are nae-nae, ma boa anggor maisi sofeꞌ. ");
INSERT INTO row_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Nusaꞌ ra dadꞌi ho ate ma, ma leo ra, beꞌutee fee hadat neu nggo. Dei fo ho parenda basa toronoo mara, ma ara sendeꞌ lululangga nara neu nggo. Seka sumba-ndoon nggo, sira o hambu sumba-ndoon boe. Ma seka fee nggo papala-babꞌanggiꞌ, sira o hambu papala-babꞌanggiꞌ boe.” ");
INSERT INTO row_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isak fee basa papala-babꞌanggiꞌ ma, Yakob lao hela e. Boe ma, aꞌa na Esau baliꞌ nendi banda fo sombu nalaꞌ a. ");
INSERT INTO row_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ana tunu-nasu nala, de nendi fee ama na, ma olaꞌ nae, “Ama ngge! Fela fo mua leo. Au tunu-nasu sisi fo sombu alaꞌ a. Mua leo, fo basa naa, fee au papala-babꞌanggiꞌ.” ");
INSERT INTO row_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Isak rena nala ma, ana titindindi, de natane nae, “Hee! Ho se fai?” Esau nataa nae, “Au, Sau! Ana ulu ma.” ");
INSERT INTO row_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Boe ma Isak nggeꞌe-nggeꞌe. Natane nae, “Seka mana nendi sisi faꞌ ra? Au ua basa, de fee ne papala-babꞌanggiꞌ ena. Nda bisa lea baliꞌ sa.” ");
INSERT INTO row_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Rena ama na olaꞌ taꞌo naa ma, Esau rala na mera, de nggae ma nggasi nahereꞌ nae, “Adoo! Amaꞌ e! Fee au papala-babꞌanggiꞌ boe!” ");
INSERT INTO row_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Te Isak nae, “Nesen. Odꞌim eꞌedik nala au ena, ma namanaꞌo nendi papala-babꞌanggim ena.” ");
INSERT INTO row_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Boe ma Esau olaꞌ nae, “Ana eꞌedik nala au lao rua ena. Fefeu na, ana eꞌedik de haꞌi nala hak ulu ngga. Ia naa, papala-babꞌanggi ngga fai. Memaꞌ naran ‘Yakob’ naa, nandaa, huu ana mana maꞌedik. Amaꞌ feꞌe muꞌena papala-babꞌanggiꞌ feaꞌ fee au, do?” ");
INSERT INTO row_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Boe ma Isak nataa nae, “Nesen. Au soꞌu e dadꞌi malanggam ena. Ma odꞌi-aꞌa nara, dadꞌi ate nara. Au fee ne are naen seli, ma boa anggor maisi sofeꞌ. Dadꞌi ana ngge! Hela feꞌe papala-babꞌanggiꞌ saa fai, fo fee nggo?” ");
INSERT INTO row_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau rena nala ma, ana akaꞌ a suu-noki ama na nakandooꞌ a nae, “Amaꞌ papala-babꞌanggi ma akaꞌ esaꞌ, do? Amaꞌ feꞌe bisa sangga fee au papala-babꞌanggi feaꞌ. Mae papala-babꞌanggi anadikiꞌ o, neu!” Boe ma ana nggae fai. ");
INSERT INTO row_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Boe ma, Isak nataa mbali e nae, “Ho masodꞌa ma naꞌadooꞌ mia osi meulauꞌ, te nda hambu dinis onda mia lalai fo naꞌadꞌoe rae ma sa. ");
INSERT INTO row_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ho fela-tafa ma mana fee nggo masodꞌaꞌ. Te mae taꞌo bee o, ho dadꞌi odꞌi ma ate na. Mete ma ho bisa labꞌan e, naa, ho feꞌe bisa nenemboꞌit mia liman.” ");
INSERT INTO row_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau namanasa Yakob seli, huu odꞌi na nalaka nala papala-babꞌanggi na. Ana duꞌa nae, “Nda dooꞌ sa te, ama ngga mate. De nehani dei. Basa bebeꞌe na fo, au isa e!” ");
INSERT INTO row_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","43","Ribka rena nala Esau dudꞌuꞌa na ma, ana noꞌe Yakob nae, “Rena malolole! Aꞌa ma naꞌena dudꞌuꞌat nae balas rala mera na. Ana nae nisa nggo, de, mela lai-lai misiꞌ toꞌo Labꞌan ma sia Haran. ");
INSERT INTO row_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Muu leo dodꞌoo sia naa, losa aꞌa ma nda afiꞌ namanasa sa ena. ");
INSERT INTO row_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Mete ma ana liliiꞌ saa fo ho tao neu e, dei fo au denu atahori roꞌe baliꞌ nggo. Te au nda nau ana ngga ruꞌa se mopo sia fai esa rala sa.” ");
INSERT INTO row_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Basa ma, Ribka sangga dala fo Isak denu Yakob lao. Dadꞌi ana kokoe Isak nae, “Aꞌa e! Au doaꞌ o Esau sao nara atahori Het ia ra! Mete ma Yakob o sao ana feto Het boe, malole lenaꞌ au mateꞌ a.” ");
INSERT INTO row_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Boe ma Isak noꞌe Yakob, de fee ne papala-babꞌanggiꞌ ma denu e nae, “Rena malolole! Ho afiꞌ sao ina Kanaꞌan. ");
INSERT INTO row_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Te muu sia Padan Aram, sia baꞌi Betuel ume na, fo sao mala toꞌo Labꞌan ma ana feto na esa. ");
INSERT INTO row_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Au hule-oꞌe fo Lamatualain Mana Koasa fee nggo papala-babꞌanggiꞌ, fo ho umbu-ana mara ramahefu, ma tititi-nonosi mara dadꞌi leo manaseliꞌ. ");
INSERT INTO row_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Naa fo, Lamatualain hehelu-fufuli Na neu Abraham tudꞌa neu nggo, mo tititi-nonosi ma. Dei fo hambu mala rae fo Lamatualain helu-fuli fee neu Abraham a. ");
INSERT INTO row_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Isak olaꞌ basa ma, ana mboꞌi Yakob Padan Aram neu, nisiꞌ toꞌo Labꞌan no baꞌi Betuel na umen. ");
INSERT INTO row_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Boe ma Esau rena oi Isak fee Yakob papala-babꞌanggiꞌ, ma ai e fo afiꞌ sao ina Kanaꞌan. Ana o rena oi, ama na denu odꞌi na neu sao toꞌo na ana feto na esa sia Padan Aram ");
INSERT INTO row_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Yakob rena aman no inan parenda na, de lao Padan Aram neu. ");
INSERT INTO row_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Esau o bubꞌuluꞌ oi, ama na nda hii eni sao, atahori Kanaꞌan ra sa. ");
INSERT INTO row_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","De ana nisiꞌ ama aꞌa na Ismael, de sao nala Ismael anan, naran Mahalat. Mahalat ia, Nebayot feton. ");
INSERT INTO row_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Leleꞌ naa Yakob lao hela Beer Syeba, fo nae Haran neu. ");
INSERT INTO row_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Relo a mopo ma, ana losa mamanaꞌ esa, de sungguꞌ sia naa. Ana nae sungguꞌ ma, haꞌi nala fatu esa, fo tao dadꞌi ainulu. ");
INSERT INTO row_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Tetembaꞌ naa, ana nalamein nita eꞌedaꞌ esa nambariiꞌ sia rae ma tonggo na losa lalai. Lamatualain ate Nara mia sorga onda-hene eꞌedaꞌ a. ");
INSERT INTO row_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Sia meit naa, Yakob nita LAMATUALAIN nambariiꞌ sia bobꞌoa na, de olaꞌ nae, “Au ia LAMATUALAIN, ho baꞌi ma Abraham no Isak Lamatualain na. Dei fo Au fee rae ia neu nggo ma tititi-nonosi mara. ");
INSERT INTO row_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Mete te, tititi-nonosi mara ramahefu onaꞌ afu. Ara sea-sarangganggaa bee-bꞌee reu sia basa mamanaꞌ. Mia tititi-nonosi mara, basa nusaꞌ sia raefafoꞌ hambu papala-babꞌanggiꞌ. ");
INSERT INTO row_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Musunedꞌa malolole! Ho muu sia sudꞌiꞌ a bee-bꞌee o, Au unea nggo. Dei fo Au o baliꞌ nggo misiꞌ nusaꞌ ia. Au nda hela mesaꞌ nggo sa. Ma Au o tao utetu basa hehelu-fufuliꞌ fo Au helu fee nggoꞌ a.” ");
INSERT INTO row_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yakob sungguꞌ fela ma nae, “Au feꞌe uhine ae, LAMATUALAIN o sia ia boe!” ");
INSERT INTO row_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ma ana namatau, de duꞌa nae, “We! Mamanaꞌ ia tao au ao fulu ngga tenggou. Memaꞌ Lamatualain ume na sia ia! Ia, lelesu nisiꞌ sorga neu.” ");
INSERT INTO row_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Mbila fefetu ana na, Yakob fela, haꞌi nala fatu ainuluꞌ a, de naririi e dadꞌi tatandaꞌ. Ana mbori mina nisiꞌ fatu a ata, de beꞌutee neu Lamatualain. ");
INSERT INTO row_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ana babꞌae mamanaꞌ naa naran Betel, sosoa na nae ‘Lamatualain ume na’. (Maꞌahulu na, mamanaꞌ naa, naran Lus). ");
INSERT INTO row_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Boe ma Yakob sumba nae, “Mete ma Lamatualain no au, ma nanea au sia dala ngga, ma fee nanaat ma bua-baꞌus, ");
INSERT INTO row_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","losa au baliꞌ no masodꞌaꞌ, naa, LAMATUALAIN dadꞌi au Lamatua ngga. ");
INSERT INTO row_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Fatu fo au uririiꞌ ia, dadꞌi mamana beꞌuteeꞌ neu Lamatualain. Ma basa saa fo Ana fee au, dei fo au fee baliꞌ babanggiꞌ esa mia sanahulu.” ");
INSERT INTO row_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Basa ma, Yakob lao nakandoo seriꞌ rulu neu. ");
INSERT INTO row_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Faiꞌ esa, ana nita oe mataꞌ sa deka kamboꞌ esa. Hiek-lombo nononggoꞌ telu, nea-nea rae rinu sia naa. Te fatu monaeꞌ esa tatana oe mataꞌ a. ");
INSERT INTO row_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Mia doo na, mete ma hiek-lombo basa se raꞌabꞌue, dei fo manatadꞌa ra oꞌo dinggoꞌ fatu a, fo hando oe fee se rinu. Basa fo, ara tatana baliꞌ oe mataꞌ a. ");
INSERT INTO row_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakob natane manatadꞌa ra nae, “Hei ma bee ima?” Ara rataa rae, “Hai, mia kambo Haran ia.” ");
INSERT INTO row_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Yakob natane seluꞌ nae, “Mihine toꞌo Labꞌan ngga, do? Eni, Nahor anan.” Ara rataa rae, “Hai mihine.” ");
INSERT INTO row_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Ma Yakob natane fai nae, “Ana malolole, do?” Ara rataa rae, “Tou lasiꞌ a malolole. Sobꞌa mete dei. Naa, eni ana feto na, naran Rahel. Ana mboo nendi hiek-lombo nara rema rinu sia ia. De muhani e.” ");
INSERT INTO row_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Basa ma Yakob olaꞌ nae, “Oras ia, feꞌe rereloꞌ. Malole lenaꞌ banda bee raꞌabꞌue sia ia ena, naa, hei fee se rinu leo. Basa fo, mboo mendi se nembe reu, fo raa selu uru.” ");
INSERT INTO row_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Te ara rareresi rae, “We, nda taꞌo naa sa! Hai musi mihani manatadꞌa ra basa se mboo rendi banda ra raꞌabꞌue sia ia dei, fo hai feꞌe oꞌo dinggoꞌ fatu a, fo hani se.” ");
INSERT INTO row_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yakob feꞌe ola-olaꞌ no atahori ra ma, Rahel losa no ama na hiek-lombo nara. Eni mana biasa mboo banda naa ra. ");
INSERT INTO row_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yakob nita Rahel ma hiek-lombo nara ma, ana neu oꞌo dinggoꞌ oe mataꞌ a tatana na. De hani toꞌo na banda nara. ");
INSERT INTO row_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Basa ma, ana neu holu-idu Rahel, ma nggae. ");
INSERT INTO row_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Ana dui Rahel nae, “Odꞌi! Au ia, ho ama ma odꞌi na Ribka anan.” Boe ma, Rahel nela baliꞌ neu nafadꞌe ama na. ");
INSERT INTO row_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Labꞌan rena Rahel dui soꞌal Yakob, eni odꞌi na Ribka anan ma, ana nelaꞌ neu soru e. Ara randaa ma, Labꞌan holu ma idu e. Basa ma, no Yakob ume neu, de Yakob dui basaꞌ e neu e. ");
INSERT INTO row_vpl VALUES ("GN29_14a","002_29_14a","GEN","29","14a","14a","Ma Labꞌan olaꞌ nae, “Memaꞌ tebꞌe! Hita ruꞌa nggita bobꞌonggiꞌ!” ");
INSERT INTO row_vpl VALUES ("GN29_14b","002_29_14b","GEN","29","14b","14b","Yakob leo no se losa fula esa ena ma, ");
INSERT INTO row_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Labꞌan olaꞌ no e nae, “Taꞌo ia, Ako! Au nda nau ho tao ues mudꞌaꞌ sa, huu ruꞌa nggita bobꞌonggiꞌ. Ho moꞌe nggadiꞌ baꞌu sa?” ");
INSERT INTO row_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Labꞌan ana feton rua. Aꞌa ka, naran Lea, ma odꞌi ka, naran Rahel. ");
INSERT INTO row_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea, akaꞌ mata deke na fo maloleꞌ, te Rahel meulau na seli. ");
INSERT INTO row_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakob sue Rahel, de nataa Labꞌan nae, “Au tao ues fee toꞌo too hitu, sadꞌi toꞌo fee au sao ala Rahel.” ");
INSERT INTO row_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Ma Labꞌan nataa nae, “Au nau! Malole lenaꞌ au fee ne sao nggo, fo au bobꞌonggi ngga. Naa fo, atahori feaꞌ afiꞌ sao rala e. De leo siaꞌ a ia, fo tao ues fee au.” ");
INSERT INTO row_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Boe ma Yakob tao ues too hitu, fo bisa sao Rahel. Huu ana sue Rahel seli, naa de, too hitu naa ra, ana medꞌa onaꞌ fai hiraꞌ a. ");
INSERT INTO row_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Basa too hitu naa ra ma, Yakob fee nesenenedꞌaꞌ neu Labꞌan nae, “Toꞌo! Au tao ues fee toꞌo too hitu ena. De fee au sao Rahel leo.” ");
INSERT INTO row_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Boe ma, Labꞌan lemba-dꞌodꞌe se, de narolo basa atahori sia nusaꞌ naa. ");
INSERT INTO row_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","27","Tetembaꞌ naa, Labꞌan nda fee Rahel sa, te ana fee Lea nisiꞌ Yakob lalaat na rala. De Yakob sungguꞌ no e. Mbila fefetu na ma, Yakob feꞌe bubꞌuluꞌ nae, eni sao Lea. De ana neu natane Labꞌan nae, “Saa de toꞌo eꞌedꞌik au? Au tao ues too hitu, fo ae sao Rahel! Taꞌo bee de nggati no Lea?” Ma Labꞌan nataa nae, “Afiꞌ mumunasa taꞌo naa! Tungga hai adat ma, odꞌiꞌ afiꞌ sao naꞌahuluꞌ aꞌaꞌ. Malole lenaꞌ taꞌo ia! Muhani lemba-dꞌodꞌeꞌ ia losa fai hitu basa dei. Basa fo, ho sao Rahel, sadꞌi ho tao ues fee au too hitu fai.” Boe ma Labꞌan fee ate ina na, naran Silpa, fo dadꞌi Lea ate na. ");
INSERT INTO row_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakob o nau boe. Naa de, fefeta fai kahituꞌ a basa ma, Labꞌan naꞌasasaoꞌ Rahel no Yakob. ");
INSERT INTO row_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Labꞌan fee ate inaꞌ na esa fai, naran Bilha, fo dadꞌi Rahel ate na. ");
INSERT INTO row_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Basa ma, Yakob sungguꞌ no Rahel. Ana sue Rahel lenaꞌ Lea, de tao ues seluꞌ too hitu fee ama ari na. ");
INSERT INTO row_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","LAMATUALAIN nahine Yakob sue Rahel lenaꞌ Lea. De Ana fee Lea bꞌonggi, te Rahel nda bꞌonggi sa. ");
INSERT INTO row_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea nairu, de bꞌonggi ana touꞌ esa. Ana nae, “LAMATUALAIN memaꞌ nita au sususa ngga. Ia naa, sao ngga nau mete-seꞌu au, huu anaꞌ ia.” Naa de, ana babꞌae anaꞌ a, Ruben (lii na, naeꞌ a onaꞌ dedꞌeat esa fo sosoa na, ‘ana nita au sususa ngga ena’). ");
INSERT INTO row_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Basa ma, Lea nairu seluꞌ, de bꞌonggi ana touꞌ esa fai. Ana nae, “LAMATUALAIN rena au sao ngga nda tao mataꞌ neu au sa. Naa de, Ana fee au anaꞌ esa fai.” Naa de, ana babꞌae anaꞌ naa, Simeon (sosoa na ‘atahori rena ena’). ");
INSERT INTO row_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Basa ma, Lea nairu seluꞌ, de bꞌonggi ana touꞌ esa fai. Ana nae, “No anaꞌ ia, au dedꞌeat ngga basa ena. Au sao ngga musi nenepaꞌaꞌ no au, huu au bꞌonggi fee ne ana touꞌ telu ena.” Naa de, ana babꞌae anaꞌ naa, Lewi (sosoa na ‘nenepaꞌaꞌ’). ");
INSERT INTO row_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Basa ma, Lea nairu fai, de bꞌonggi ana touꞌ esa. Ana nae, “Oeꞌ ia, au ae koa-kio LAMATUALAIN!” Naa de, ana babꞌae anaꞌ naa, Yahuda (sosoa na mbei ma ‘koa-kio’). Basa naa ma, Lea nda bꞌonggi sa ena. ");
INSERT INTO row_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Te Rahel nda feꞌe bꞌonggi sa. Naa de, ana horo-mbala aꞌa na. De ana olaꞌ no sao na nae, “Aꞌa! Fee au anaꞌ dei! Mete ma hokoꞌ, malole lenaꞌ, au mateꞌ a.” ");
INSERT INTO row_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Boe ma, Yakob bua e nae, “Ho mae au ia, Lamatualain, fo bisa fee ho anaꞌ, do?” ");
INSERT INTO row_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rahel olaꞌ nae, “Taꞌo ia! Malole lenaꞌ, aꞌa haꞌi mala ate ngga Bilha. Muu sungguꞌ mo e, fo ana bꞌonggi fee au anaꞌ.” ");
INSERT INTO row_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Boe ma, ana fee Bilha neu Yakob, de ana sungguꞌ no e. ");
INSERT INTO row_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilha o nairu boe, de bꞌonggi ana touꞌ esa. ");
INSERT INTO row_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rahel olaꞌ nae, “Lamatualain rena au hule-oꞌe ngga. Naa de, Ana fee au ana touꞌ esa. Ana naꞌetuꞌ au dedꞌea ngga no ndoo-tetuꞌ.” Rahel babꞌae anaꞌ naa, Dan (sosoa na ‘neꞌetuꞌ dedꞌeat’). ");
INSERT INTO row_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Basa ma, Bilha nairu seluꞌ, de bꞌonggi ana touꞌ esa fai. ");
INSERT INTO row_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rahel olaꞌ nae, “Au ukusosoek o aꞌa ngga ena, ma au uꞌsenggiꞌ e.” Naa de, ana babꞌae anaꞌ naa, Naftali (sosoa na ‘esa nda nau kala saꞌ boe’). ");
INSERT INTO row_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lea duꞌa nae eni nda bꞌonggi sa ena ma, ana fee Yakob sao nala ate na Silpa. ");
INSERT INTO row_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Boe ma Silpa bꞌonggi ana touꞌ esa. ");
INSERT INTO row_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lea olaꞌ nae, “Au uanale ngga, malole ena.” Naa de, ana babꞌae anaꞌ naa, Gad (sosoa na ‘uanale maloleꞌ’). ");
INSERT INTO row_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Basa ma, Silpa bꞌonggi ana touꞌ esa fai. ");
INSERT INTO row_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Lea olaꞌ nae, “Weh! Ia naa, au feꞌe umuhoꞌo na! Mete te, basa inaꞌ ra olaꞌ-olaꞌ rae, au onton seli.” Naa de, ana babꞌae anaꞌ naa, Aser (sosoa na ‘nemehoꞌo’). ");
INSERT INTO row_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Lao esa, nandaa no fai etu-oru are ma, Ruben lao lasi neu, de nita hau modꞌo sa bisa tao atahori hambu anaꞌ. De ana nendi fee ina na Lea. Rahel nita taꞌo naa ma, ana noꞌe Lea nae, “Aꞌa e! Fee au modꞌo fo Ruben nendiꞌ a mbei dei.” ");
INSERT INTO row_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Te Lea nataa nae, “We! Ho ia, manaseliꞌ! Rambas mala au sao ngga. Ia ma, ho mae rambas mala modꞌo naa mia au ana ngga fai, do? Ho, nda mo mamaem sa!” Te Rahel olaꞌ nae, “Taꞌo ia, aꞌa. Mete ma au hambu modꞌo na, tetembaꞌ ia, muu sungguꞌ mo Ako.” Ma Lea nau boe. ");
INSERT INTO row_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Bꞌobꞌo na ma, Yakob baliꞌ mia osi nema. Ma Lea neu nandaa no e, de olaꞌ nae, “Aꞌa! Tetembaꞌ ia, aꞌa musi sungguꞌ mo au! Huu au bae basa aꞌa endiꞌ ana ngga modꞌo na ena.” De tetembaꞌ na, Yakob sungguꞌ no Lea. ");
INSERT INTO row_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Boe ma Lamatualain rena Lea hule-oꞌe na. Ana nairu, de bꞌonggi ana touꞌ kaliman. ");
INSERT INTO row_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Ana nae, “Lamatualain bae basa au bebꞌengge ngga ena, huu au fee Silpa sao nala sao ngga.” Naa de, ana babꞌae anaꞌ naa, Isaskar (sosoa na ‘bae bebꞌenggeꞌ’). ");
INSERT INTO row_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Basa ma Lea nairu seluꞌ, de bꞌonggi ana kanee na. ");
INSERT INTO row_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Ana olaꞌ nae, “Lamatualain fee papala-babꞌanggiꞌ maloleꞌ neu au. De ia naa, au sao ngga musi fee hadat neu au, huu au bꞌonggi fee ne ana moneꞌ nee ena.” Naa de, ana babꞌae anaꞌ naa Sebulon (sosoa na ‘fee hadat’). ");
INSERT INTO row_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Lea o bꞌonggi ana inaꞌ esa, de babꞌae e Dina. ");
INSERT INTO row_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Basa ma, Lamatualain nasanedꞌa Rahel, ma rena hule-oꞌe na. Naa de, Ana soi mamana ana na. ");
INSERT INTO row_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Boe ma, Rahel nairu, de bꞌonggi ana touꞌ esa. Ana nae, “Lamatualain nggari hendi au mamaet ngga ena.” ");
INSERT INTO row_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ana olaꞌ nae, “Au oꞌe fo Lamatualain fee seluꞌ au ana touꞌ esa fai.” Naa de, ana babꞌae anaꞌ naa, Yusuf (sosoa na ‘hule fo fee seluꞌ’). ");
INSERT INTO row_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Rahel bꞌonggi Yusuf ma, Yakob olaꞌ no Labꞌan nae, “Amaꞌ! Mete ma bisa, naa, au ae baliꞌ isiꞌ nusa ngga dei. ");
INSERT INTO row_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Fee au baliꞌ o sao-ana ngga ra. Amaꞌ bubꞌuluꞌ au tao ues naeꞌ fee amaꞌ ena, de au bae etu se ena. Huu naa, au hak se.” ");
INSERT INTO row_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Boe ma, ama ari na nataa nae, “Ana ngge! Rena dei. Au sangga basa uanaleꞌ, de bubꞌuluꞌ ae Lamatualain fee papala-babꞌanggiꞌ neu au, huu ho. ");
INSERT INTO row_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","De ia naa, ho mae moꞌe baꞌu sa o, au bae! Sadꞌi ho leo sia ia, ma tao ues mukundoo fee au.” ");
INSERT INTO row_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Ma Yakob nataa nae, “Amaꞌ mita no mata ma, au tao ues no manggateeꞌ. Naa de, banda mara boe ramaheta. ");
INSERT INTO row_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Leleꞌ au nda feꞌe uma sa, amaꞌ suꞌi na nda naeꞌ sa. Te aleꞌ ia, amaꞌ namasuꞌi ena. Lamatualain pala-banggi fee amaꞌ ena, huu au ue-tatao ngga. Ia naa, au ae ue-tao fee sao-ana ngga ra.” ");
INSERT INTO row_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Te Labꞌan natane nae, “Au musi bae ho taꞌo bee?” Yakob nataa nae, “Amaꞌ sudꞌi fee au saa-saa boe. Au uꞌuboi ukundoo banda mara, sadꞌi au bisa tao dalaꞌ esa. ");
INSERT INTO row_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Fee isin au faiꞌ ia boe, uu sia amaꞌ banda nara, fo hii ala hiek-lombo. Bee nda kokotoꞌ sa, ma nda eꞌetaꞌ sa, naa ra, amaꞌ ena na. Te bee kokotoꞌ, ma eꞌetaꞌ, naa, au ena ngga. Ma au o haꞌi ala basa lombo nggeoꞌ ra. Basa naa ra, bae neu bebꞌengge ngga. ");
INSERT INTO row_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Sia fai maꞌabui na, dei fo amaꞌ nahine au ia ndoos, do hokoꞌ. Sudꞌi a fai hiraꞌ amaꞌ nema paresaꞌ au banda nggara. Mete ma hambu hiek nda kokotoꞌ sa, ldo nda eꞌetaꞌ sa, do lombo mutiꞌ, naa, amaꞌ nahine au umunaꞌo banda mara.” ");
INSERT INTO row_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Boe ma Labꞌan nau nae, “Malole! Taꞌo naa leo.” ");
INSERT INTO row_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Faiꞌ naa boe, Labꞌan banggi fea banda kokotoꞌ, eꞌetaꞌ ra, ma lombo nggeoꞌ ra. Ana denu ana nara reu tao mataꞌ neu banda naa ra. ");
INSERT INTO row_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Ma ara rendi se risiꞌ mamanaꞌ esa dodꞌoo na lao eiꞌ fai telu mia Yakob e. Ma Yakob feꞌe naꞌabꞌoi ama ari na hiek-lombo feaꞌ nara. ");
INSERT INTO row_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Basa ma, Yakob tati nala hau mataꞌ telu dana nara, de ana fina se dudꞌuiꞌ ra. ");
INSERT INTO row_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Basa de, ana mbedaꞌ hau naa ra, sia banda ra mamana nininu na. Banda ra hiiꞌ a rahoo sia mamana nininuꞌ naa. ");
INSERT INTO row_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Banda naa ra rahoo sia hau madꞌudꞌuiꞌ ra mata na, naa fo, ara bꞌonggi na ana nara fulu na kokotoꞌ ma eꞌeꞌtaꞌ. ");
INSERT INTO row_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Dadꞌi Labꞌan banda nara, rae rahoo naa, Yakob fee se mbali banda kokotoꞌ ma eꞌeꞌta ra. De ana nara o kokotoꞌ ma ꞌeꞌeta ra. Naa de, banda nara boe ramaheta. Basa de, ana tadꞌa fea se mia Labꞌan banda nara. ");
INSERT INTO row_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Banda maꞌadereꞌ ra rahoo naa, Yakob tao hau madꞌudꞌuiꞌ ra neu mata nara, sia mamana nininu na. ");
INSERT INTO row_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Te mete ma banda manamaleꞌ ra rahoo na, ana nda tao hau naa ra sa. Naa de, Labꞌan hambu basa banda manamaleꞌ ra. Ma Yakob hambu basa banda maꞌadereꞌ ra. ");
INSERT INTO row_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","No taꞌo naa, Yakob namasuꞌi seli. Hiek-lombo, banda onta, keledei, no ate nara nae na seli. ");
INSERT INTO row_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Lao esa, Yakob rena Labꞌan ana nara ola-olaꞌ rae, “Yakob namasuꞌi seli, huu ana ao nabasaꞌ hita ama na hata-heto nara.” ");
INSERT INTO row_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yakob o mete ama ari na matan nda matetuꞌ sa ena, ma nda malole onaꞌ feꞌesaꞌan sa. ");
INSERT INTO row_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Basa ma, LAMATUALAIN olaꞌ no Yakob nae, “Ia naa, fai na losa ena. Ho musi baliꞌ misiꞌ ina-ama mara. Dei fo Au o nggo.” ");
INSERT INTO row_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Basa naa ma, Yakob denu reu roꞌe Rahel no Lea, fo reu randaa ro e sia mooꞌ mamana banda ra. ");
INSERT INTO row_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Boe ma nafadꞌe se nae, “Fai maꞌabui na ia, au mete hei ama ma mata na nasat, ma nda maloleꞌ no au sa onaꞌ maꞌahulu na. Te Lamatualain fo ama ngga namahereꞌ a, no au. ");
INSERT INTO row_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Hei ruꞌa nggi bubꞌuluꞌ, doo basa ia, au tao ues itaꞌ mamate ngga fee hei ama ma! ");
INSERT INTO row_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Te onaꞌ naa o, ana eꞌedik au lao hetar ena. Ana nggati au bebꞌengge ngga losa lao sanahulu. Mae onaꞌ naa o, Lamatualain nanea nahereꞌ au. ");
INSERT INTO row_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Leleꞌ hei ama ma olaꞌ nae, ‘Banda kokotoꞌ ra, seba neu ho,” boe ma, banda ra bꞌonggi na basa se kokotoꞌ. Faiꞌ ruma te, ana olaꞌ fai nae, ‘Ia naa, banda eꞌeꞌta ra dadꞌi ena ma,’ boe ma banda ra bꞌonggi na akaꞌ a eꞌeꞌta ra. ");
INSERT INTO row_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Lamatualain tao taꞌo naa, fo Ana haꞌi nala ama ma banda nara, fee neu au. ");
INSERT INTO row_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Lao esa, leleꞌ banda ra fula-fai rahoo na, au ulumein, ae basa banda mone mana mahooꞌ ra, akaꞌ a kokotoꞌ ma eꞌetaꞌ. ");
INSERT INTO row_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Au ulumein onaꞌ a Lamatualain ate na mia sorga noꞌe au nae, ‘We! Yakob!’ De au utaa ae, ‘Taꞌo bee, Lamatuaꞌ?’ ");
INSERT INTO row_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ma ana nafadꞌe nae, ‘Mete dei! Basa banda mana mahooꞌ ra, akaꞌ a kokotoꞌ ma eꞌetaꞌ ra. Au mana tao naa ra, huu Au ita Labꞌan tatao na neu nggo. ");
INSERT INTO row_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Au ia, Lamatualain mana natudꞌu Ao na neu nggo mia Betel. Sia naa, ho muririi fatu, ma mbori mina neu ata, de beꞌutee neu Au. Boe ma ho tao hehelu-fufuliꞌ mo Au sia naa. Ia naa, ho musi lao hela nusaꞌ ia, fo baliꞌ misiꞌ ina-ama ma nusa na.’” ");
INSERT INTO row_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Boe ma Lea no Rahel rataa rae, “Neu! Hai tunggaꞌ a! Hai nda afiꞌ miꞌena hata-hetoꞌ saa-saa mia ama Labꞌan sa ena. ");
INSERT INTO row_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Dꞌoo na basa ia, toulasiꞌ a tao hai onaꞌ a atahori feaꞌ. Ana seo hendi hai ma naa hendi hai feli ma ena. ");
INSERT INTO row_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Basa hata-heto fo Lamatualain haꞌi mia ama Labꞌan, ia naa dadꞌi hita to tititi-nonosiꞌ tara hata-heto na ena. De mete ma Lamatualain nae taꞌo bee, naa, hai tunggaꞌ a!” ");
INSERT INTO row_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Basa naa ma, Yakob mbedꞌaꞌ-nggao sudꞌi a saa nara, de nafufuaꞌ sao-ana nara reu banda onta ata. Ana o mboo nendi basa banda nara, ma nendi sudꞌi a saa nara fo ana hambu mia Padan Aram, fo baliꞌ Kanaꞌan reu. ");
INSERT INTO row_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Leleꞌ naa, Labꞌan neu nggute hiek-lombo ra fulu nara. De Rahel namanaꞌo nendi ama na paton sosonggo na. ");
INSERT INTO row_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Basa ma, Yakob se lao neneeꞌ a, nda rafadꞌe ama ari na sa. ");
INSERT INTO row_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Ana haꞌi nendi basa hata-heto nara, ma lao haelalai tungga loe Efrat, mbali lete Gilead reu. ");
INSERT INTO row_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Seli fai telu ma, Labꞌan hambu haraꞌ oi, Yakob se rela ena. ");
INSERT INTO row_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Ana naꞌabꞌue atahori nara, de reu oi tungga ana mone feu na. Ara oi tungga se basa fai hitu, dei de hambu se mia lete-leteꞌ mana sia Gilead. ");
INSERT INTO row_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Tetembaꞌ naa, Lamatualain natudꞌu ao na neu Labꞌan mia meit rala. Ana nae, “Labꞌan! Mete ma olaꞌ mo Yakob, naa, munea mulolole bafa ma.” ");
INSERT INTO row_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Tetembaꞌ naa, Yakob naririi lalaat sia lete Gilead. Ma Labꞌan se o raririi sira lalaat na nda naꞌadꞌodꞌooꞌ no naa sa. ");
INSERT INTO row_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Basa ma, Labꞌan nema nandaa no Yakob. Ana olaꞌ nae, “He! Yakob! Taꞌo bee de ho mela mendi au ana feto nggara neuꞌ ena taꞌo ia? Onaꞌ a rambas mala se mia musu a. ");
INSERT INTO row_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Hieꞌ o ho mela neeneeꞌ a, nda mutea au saꞌ boe! Onaꞌ a ho mufadꞌe au no malolole na, au tao fefetas, fo ro hei mo lii-liiꞌ ra, basa fo mboꞌi hei lao. ");
INSERT INTO row_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ho sala ma esa fai, ho nda fee au idꞌu umbu-ana nggara, dei fo mboꞌi hei sa. Tatao ma ia, nggoaꞌ! ");
INSERT INTO row_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Au bisa tao deꞌulaka neu nggo no mudaꞌ! Te tembaꞌ a, Lamatualain, fo ama ma namahereꞌ a, ai au nae, mete ma au olaꞌ o nggo, naa, musi unea bafa ngga malolole. ");
INSERT INTO row_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Memaꞌ ho mae lao o nda saa saꞌ boe, huu hii maeꞌ a baliꞌ ena. Te taꞌo bee de ho feꞌe mumunaꞌo mendi au paton sosonggo nggara?” ");
INSERT INTO row_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakob nataa nae, “Toꞌo afiꞌ mumunasa au! Au lao nenee na, huu umutau, afiꞌ losa toꞌo ai hela ana nggara, naa, taꞌo bee?” ");
INSERT INTO row_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Te Yakob nda nahine nae sao na Rahel haꞌi nendi paton naa ra sa. De ana nae, “Toꞌo! Paton naa ra sangga neuꞌ ena! Mete ma hambu sia seka, naa, hukun misa e. Lengga-ofe basa e! Mete ma toꞌo hambu bua pusaka feaꞌ mara, naa, haꞌi mala baliꞌ se. Hela fo basa atahori ia ra, dadꞌi sakasii.” ");
INSERT INTO row_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Boe ma Labꞌan neu lengga-ofe esa-esaꞌ lalaat na. Naꞌahuluꞌ mia Yakob lalaat na. Basa de, mia Lea lalaat na. Dei de ate ina karuaꞌ ra lalaat nara. Te nda nita paton na sa. Dei de, ana nisiꞌ Rahel lalaat na. ");
INSERT INTO row_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Te Rahel funi paton naa ra sia banda onta lalakat na raeꞌ. De ana endoꞌ neu lalakat naa ataꞌ. Labꞌan lengga-ofe lutuꞌ-leloꞌ sia Rahel lalaat na, te nda nita sa. ");
INSERT INTO row_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Ma Rahel olaꞌ no ama na nae, “Amaꞌ afiꞌ mumunasa. Au nda umburiiꞌ ala sa, te au hambu hedꞌi inaꞌ.” Boe ma Labꞌan sangga fai, te nda nita paton naa ra sa. ");
INSERT INTO row_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Boe ma Yakob namanasa, de bua Labꞌan nae, “Au tao salaꞌ saa o toꞌo? De toꞌo nema oi tungga au, onaꞌ au atahori deꞌulakaꞌ! ");
INSERT INTO row_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Toꞌo lengga-ofe basa sudꞌi a saa ra ena. De toꞌo hambu saa? Tao sobꞌa se reu mataꞌ ia fo basa nggita mete! Naa fo atahori ia ra raꞌetuꞌ, sudꞌiꞌ a saa ra, seka ena na. ");
INSERT INTO row_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Au dadꞌi toꞌo kuli na, too rua nulu ena. Au unea toꞌo banda nara, esa nda hendir saꞌ boe. Ma au nda ua esa saꞌ boe! ");
INSERT INTO row_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Mete ma banda fui ra tao risa toꞌo banda na esa, au nda ufadꞌe toꞌo sa, te au nggati. Ma mete ma atahori ramanaꞌo toꞌo banda na, toꞌo fee au nggati, mae au nda sala sa o. ");
INSERT INTO row_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Rereloꞌ na, relo a haa au. Ma tetembaꞌ na, au maꞌarini huu maꞌasufuꞌ a. Au beꞌe nda sungguꞌ ala sa, huu unea toꞌo banda nara. ");
INSERT INTO row_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Memaꞌ taꞌo naa, losa too rua nulu. Au tao ues too sanahulu haa, de hambu toꞌo ana feto nara. Basa ma, tao ues too nee fai, de hambu banda nggara. Tao ues doo basa na, te toꞌo nggati naꞌamiminaꞌ au sesebꞌa ngga lao sanahulu. ");
INSERT INTO row_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Andiꞌ a Lamatualain, fo baꞌi Abraham no baꞌi Isak ramahereꞌ a. Onaꞌ Ana nda nanea au sa, naa, toꞌo denu oi hendi au ena, no lima rouꞌ. Te Lamatualain nda naꞌapopokeꞌ mata Na neu au sususa ngga sa, ma Ana nita basa ue-taos nggara. Naa de, tembaꞌ a, Ana nema ai toꞌo.” ");
INSERT INTO row_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Labꞌan rena Yakob olaꞌ taꞌo naa ma, ana nataa nae, “Taꞌo ia! Ana ina karuaꞌ ra naa ra, au ana nggara. Ara bꞌonggi ralaꞌ ra, au umbu nggara. Basa banda ia ra, au ena nggara. Basa ho mitaꞌ ra, memaꞌ au ena ngga. Te au ae tao saa? Au nda bisa ai se sa. ");
INSERT INTO row_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Malole lenaꞌ, ruꞌa nggita tao hehelu-fufuliꞌ, fo tasodꞌa tungga e.” ");
INSERT INTO row_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Basa ma, Yakob haꞌi fatu monaeꞌ esa, de naririi neu naa, dadꞌi tatandaꞌ. ");
INSERT INTO row_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ana o denu atahori nara, reu kumbu fatu, fo lutu mbatu. Basa ma, ara endoꞌ raa deka fatu naa ra. ");
INSERT INTO row_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Labꞌan babꞌae lutu mbatu naa, Yegar Sahaduta. Te Yakob babꞌae naran, Galeed. ");
INSERT INTO row_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Boe ma Labꞌan nae, “Fatu nenelutu mbatuꞌ ia dadꞌi sakasii fee ruꞌa nggita.” Naa de, mamanaꞌ naa, naran, Galeed. ");
INSERT INTO row_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Labꞌan o babꞌae mamanaꞌ naa naran, Mispa (onaꞌ dedꞌea feaꞌ esa, fo sosoa na ‘mamana nenea naruꞌ’), huu ana olaꞌ nae, “Dei fo LAMATUALAIN nanea ruꞌa nggita, fo mae hita esa naꞌadooꞌ no esa o, ata afiꞌ liliꞌ hehelu-fufuliꞌ ia. ");
INSERT INTO row_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Mete ma ho tao deꞌulakaꞌ neu au ana ngga ia ra, do sao mo ina feaꞌ fai, naa, au nda bubꞌuluꞌ sa. Te musunedꞌa! Lamatualain dadꞌi sakasii neu rua nggita. ");
INSERT INTO row_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","52","Mete sobꞌa fatu mana ririiꞌ ia, no fatu manalutu mbatuꞌ ia. Musunedꞌa, fatu ia ra, o dadꞌi lalaneꞌ. Ho afiꞌ lao seli fatu lalaneꞌ ia ra, fo tao deꞌulakaꞌ neu au. Ma au o afiꞌ lao seli fatu ia ra, fo tao deꞌulakaꞌ neu nggo. ");
INSERT INTO row_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Hita tao hehelu-fufuliꞌ ia, tendiꞌ hita bei-baꞌi nara Lamatualain na. Eni, ho baꞌi ma Abraham, ma au baꞌi ngga Nahor Lamatualain na. Dei fo Ana dadꞌi mana maꞌetuꞌ hita dedꞌea na.” Yakob rena taꞌo naa ma, ana soꞌu susumbaꞌ, nendiꞌ Lamatualain naran fo ama na Isak beꞌutee neuꞌ a. ");
INSERT INTO row_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Basa naa ma, Yakob hala banda, de nendi dadꞌi tutunu-hohotuꞌ fee Lamatualain sia leteꞌ naa ata. Ana noꞌe basa atahori ra, de raa raꞌabꞌue, ma beꞌe losa fefetun. ");
INSERT INTO row_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Mbila fefetu na ma, Labꞌan neu holu-idꞌu basa umbu-ana nara. Ana olaꞌ fee se papala-babꞌanggiꞌ, de baliꞌ nisiꞌ nusa na. ");
INSERT INTO row_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Basa ma, Yakob se laoꞌ rakandoo. Ma Lamatualain ate nara mia sorga rema randaa ro e. ");
INSERT INTO row_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Ana nita se ma, olaꞌ nae, “Ia, Lamatualain soldꞌadꞌu nara mamana hahae ao nara!” Naa de, ana babꞌae mamanaꞌ naa Mahanaim (sosoa na ‘mamana hahaeꞌ rua’). ");
INSERT INTO row_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Basa naa ma, Yakob denu atahori nara hira, lao raꞌahuluꞌ risiꞌ nusa Edom (nara feaꞌ na, Seir), fo rafadꞌe aꞌa na Esau rae, eni nae nema. ");
INSERT INTO row_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Yakob denu se nae, “Mi mifadꞌe au aꞌa ngga Esau taꞌo ia: ‘Malangga Esau! Malangga ate na, odꞌi Yakob, fee dudꞌuꞌa-aꞌafiꞌ neu malangga. Mia au lalao ngga dalahulu na, losa faiꞌ ia, malangga ate na ia, leo sia toꞌo Labꞌan ume na. ");
INSERT INTO row_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Ia naa, malangga ate na ia, naꞌena sapi, keledei, hiek-lombo, ma ate touꞌ ma inaꞌ. Au fee atahori ia ra raꞌahuluꞌ, fo rafadꞌe malangga, au uꞌuma ngga. Au oꞌe, malangga hii simbo hai no maloleꞌ.” Yakob denu basa taꞌo naa ma, atahori naa ra lao. ");
INSERT INTO row_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Ara baliꞌ risiꞌ Yakob ma, rafadꞌe rae, “Hai mindaa mo amaꞌ aꞌa na Esau ena. Ia naa, ana nema no touꞌ natun haa, fo rae randaa ro amaꞌ.” ");
INSERT INTO row_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yakob rena nala ma, tenda na rombe, huu namatau nala seli. De ana bꞌanggi atahori nara no banda nara, neu nononggoꞌ rua. ");
INSERT INTO row_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Ana duꞌa nae, “Mete ma Esau nema namue mana sia mataꞌ ra, naa, mana sia deaꞌ ra bisa rela sangga masodꞌa.” ");
INSERT INTO row_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Basa ma, Yakob hule-oꞌe nae, “Lamatualain, e! Lamatualain fo au baꞌi Abraham no ama Isak ngga beꞌuteeꞌ a. Rena au dei! Fai maꞌahulu na, Lamatualain denu au baliꞌ uma sia bobꞌonggi nggara, sia nusaꞌ ia. Ma Lamatualain o helu nae, dei fo Lamatualain tao natetu basa ia ra. ");
INSERT INTO row_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Au nda undaa sa te, Lamatualain sue au, ma mete-seꞌu au nakandooꞌ a. Maꞌahulu na, au nggani loe Yarden ia, au endi akaꞌ a teteas. Te ia naa, au baliꞌ uma endi atahori no banda nononggoꞌ rua. ");
INSERT INTO row_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Au umutau, afiꞌ losa aꞌa Esau nema namue fo tao nisa basa hai. De au oꞌe Lamatualain fee masodꞌa neu au, o basa sao-ana nggara, mia e. ");
INSERT INTO row_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Lamatualain o mana helu mae fee au papala-babꞌanggiꞌ nae-nae, ma tao tititi-nonosi nggara boe ramaheta, onaꞌ a saraꞌae sia tasi suu na, losa atahori nda ito-reken rala sa.” ");
INSERT INTO row_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Basa ma, Yakob sungguꞌ sia mamanaꞌ naa. Mbila fefetu na ma, ana haꞌi banda nae fee aꞌa na Esau. ");
INSERT INTO row_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Ana tengga nala bibꞌi hiek ine natun rua, bibꞌi hiek mone rua nulu, bibꞌi lombo ine natun rua, bibꞌi lombo mone rua nulu, ");
INSERT INTO row_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","banda onta ine telu nulu ro ana nara feꞌe mana susuꞌ, sapi ine haa nulu, sapi mone sanahulu, keledei ine rua nulu, ma keledei mone sanahulu. ");
INSERT INTO row_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Ana banggi banda ra mataꞌ esa-esaꞌ no nononggo na. Ma ana fee nononggoꞌ esa-esaꞌ no manatadꞌa na. Ana nafadꞌe se nae, “Laoꞌ miꞌihuluꞌ. Dei fo au tungga deaꞌ. Te hei musi minea fo nononggoꞌ esa naꞌadꞌooꞌ no esa.” ");
INSERT INTO row_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Ma Yakob parenda manatadꞌa mia nononggoꞌ maꞌahuluꞌ a nae, “Mete ma au aꞌa ngga Esau nandaa no nggo, ma natane nae, ‘Ho mae bee muu? Ho ia, seka ate na? Banda ia ra, seka ena nara?’ ");
INSERT INTO row_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","naa, musi mutaa mae, ‘Banda ia ra, malangga ate na Yakob ena na. Ana haitua fee aꞌa na, Esau. Te ana feꞌe tungga dea. ");
INSERT INTO row_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","20","Yakob o fee parendaꞌ onaꞌ naa neu basa manatadꞌa feaꞌ nara nae, “Mete ma mindaa mo aꞌa Esau, fee banda naa ra reu e, dei fo mifadꞌe mae au feꞌe tungga deaꞌ.” Ana duꞌa nae, mete ma fee basa banda naa ra reu Esau, naa, Esau rala na namaloa no e. ");
INSERT INTO row_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Dadꞌi ana haitua banda ra raꞌahuluꞌ, te tetembaꞌ naa, ana feꞌe nahani sia naa. ");
INSERT INTO row_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Tetembaꞌ naa, Yakob fela, de naꞌabꞌue sao nara ruꞌa se, sao tias nara ruꞌa se, ma ana nara sanahulu esa. Ana denu se nggani raꞌahuluꞌ risiꞌ loe Yabok seriꞌ. ");
INSERT INTO row_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Ara losa seriꞌ ma, ana haitua basa hata-heto nara naa reu. ");
INSERT INTO row_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Te Yakob mesaꞌ ne nahani sia naa. Boe ma, touꞌ esa nema, napote no e losa deka manggarelo. ");
INSERT INTO row_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Touꞌ a medꞌa naeꞌ a kala ma, ana hemba Yakob soꞌe noo na, de rui bobꞌonggo na lao hela manggo na. ");
INSERT INTO row_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Boe ma, touꞌ a nae, “Mboꞌi au, te mbeifen te, relo a todꞌa ena.” Te Yakob nataa nae, “Olaꞌ fee au papala-babꞌanggiꞌ, dei fo au mboꞌi nggo!” ");
INSERT INTO row_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Touꞌ a nataa nae, “Ho naram, seka?” Nataa nae, “Yakob.” ");
INSERT INTO row_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Te touꞌ a olaꞌ nae, “Ho naram, nda Yakob sa ena. Mia leleꞌ ia, atahori roꞌe nggo rae Israꞌel, huu mufetu mo atahori ma Lamatualain, losa musenggiꞌ se.” (Naraꞌ Israꞌel sosoa na ‘mana napote no Lamatualain’.) ");
INSERT INTO row_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Ma Yakob nataa nae, “Ho naram, seka?” Te touꞌ a nae, “Mutane nara ngga, tao sa?” Boe ma ana olaꞌ fee papala-babꞌanggiꞌ neu Yakob sia naa. ");
INSERT INTO row_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Boe ma Yakob olaꞌ nae, “Au ita Lamatualain mata Na, te au feꞌe masodꞌaꞌ.” Huu naa, ana babꞌae mamanaꞌ naa Peniel, sosoan ‘Lamatualain mata na’. ");
INSERT INTO row_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Relo a todꞌa ma, Yakob lao hela mamanaꞌ naa. Te ana laoꞌ doka-doka, huu saka buku na nelasala. ");
INSERT INTO row_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Naa de losa fai ia, atahori Israꞌel ra nda raa sisi banda saka bukuꞌ sa, huu Lamatualain poko nasalaꞌ baꞌi Yakob saka buku na. ");
INSERT INTO row_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Faiꞌ naa, Yakob nita Esau nema no nononggoꞌ atahori natun haa. Ma ana babanggi ana nara fee se esa-esaꞌ risiꞌ ina nara. ");
INSERT INTO row_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ana fee sao tias nara ro ana nara lao risiꞌ mataꞌ. Basa de, Lea no ana nara, dei fo Rahel no anan Yusuf raꞌabui oe-oeꞌ. ");
INSERT INTO row_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Te Yakob lao naꞌahuluꞌ basa se. Ara rae deka ro aꞌa na ma, ana sendeꞌ lululangga na ma beꞌutee losa rae a, lao hitu. ");
INSERT INTO row_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Esau nita odꞌi na ma, ana nelaꞌ neu nandaa no e. Ana holu ma idꞌu e, ma ruꞌa se nggae. ");
INSERT INTO row_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Esau nita inaꞌ naa ra ro ana nara, ma natane nae, “Basa atahori ia ra, seka?” Yakob nataa nae, “Naa ra, atahori fo Lamatualain fee au, aꞌa ate na.” ");
INSERT INTO row_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Basa naa ma, sao tias nara ro ana nara, rema raloe ao nara neu Esau. ");
INSERT INTO row_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Basa de, Lea no ana nara, rema raloe ao nara neu Esau. Mana maꞌabuiꞌ a, Yusuf no ina na Rahel rema raloe ao nara neu Esau. ");
INSERT INTO row_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Boe ma Esau natane nae, “Banda nononggoꞌ fo ho haituaꞌ ra, masud na saa?” Yakob nataa nae, “Taꞌo ia, aꞌa! Au fee basa naa ra neu aꞌa, naa fo aꞌa simbo au no rala teme aoꞌ.” ");
INSERT INTO row_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Te Esau nataa nae, “Odꞌiꞌ! Au suꞌi ngga o naeꞌ boe. De afiꞌ fee au saaꞌ boe.” ");
INSERT INTO row_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Ma Yakob nataa nae, “Aꞌa afiꞌ taꞌo naa! Aꞌa musi simbo fo dadꞌi bukti aꞌa simbo au no lima ruaꞌ. Te, au ita aꞌa humek faꞌ ra ma, onaꞌ au ita Lamatualain humek. ");
INSERT INTO row_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","De au hule no hadat fo simbo au fefee ngga ia. Lamatualain malole na seli neu au, naa de Ana fee basa saa fo au parluꞌ ra.” Yakob kokoe nakandooꞌ a, de nau nda nau sa o, Esau simbo nala se. ");
INSERT INTO row_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Basa naa ma, Esau olaꞌ nae, “Mete ma taꞌo naa, naa, miote fo ata lao leo! Dei fo au o nggi.” ");
INSERT INTO row_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Te Yakob nataa nae, “Afiꞌ, aꞌa! Aꞌa mete neuꞌ ena. Anaꞌ ra feꞌe anadikiꞌ ri, de nda feꞌe laoꞌ beꞌi sa. Ma banda mana bꞌonggi feuꞌ ra o, naeꞌ. Mete ma hita taꞌasusuuꞌ se laoꞌ lai-lai, sia fai esa rala, naa, banda ra bisa mate basa se. ");
INSERT INTO row_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","De malole lenaꞌ aꞌa se lao miꞌihuluꞌ. Dei fo basa hai laoꞌ koe-koe miꞌibuit. Losa naa fo, au eti seꞌu aꞌa sia Seir.” ");
INSERT INTO row_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Boe ma, Esau olaꞌ fai nae, “Mete ma taꞌo naa, naa, au lao hela atahori nggara ruma ro nggo fo ratudꞌu hei dalaꞌ.” Te Yakob nae, “Afiꞌ tao ia-naa, aꞌa! Sadꞌi au bubꞌuluꞌ aꞌa simbo au ena, naa, au umuhoꞌo.” ");
INSERT INTO row_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Esau rena nala ma, ana lao hela se, de baliꞌ Seir neu. ");
INSERT INTO row_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Te Yakob lao Sukot neu. Sia naa, ana tao ume, ma lalaet fee banda nara. Naa de, ara babꞌae mamanaꞌ naa Sukot (sosoan ‘ume neꞌetataaꞌ’). ");
INSERT INTO row_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Neu mateꞌe na ma, Yakob se losa no masodꞌaꞌ mia Padan Aram risiꞌ kambo Sikem sia nusa Kanaꞌan. Boe ma ara raririi lalaat, de leo deka kamboꞌ naa. ");
INSERT INTO row_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Rae fo Yakob naririi lalaat naa, ana hasa naꞌetuꞌ mia Hemor, Sikem aman. Ana bae no doi fulaꞌ natun esa. ");
INSERT INTO row_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Sia naa, ana lutu mbatu mei tutunu-hohotuꞌ. Ana babꞌae mamanaꞌ naa El-Elohe-Israꞌel. Sosoa na ‘Lamatualain naa, Israꞌel Lamatualain na’. ");
INSERT INTO row_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Lao esa, Yakob no Lea ana feto na, Dina, neu eko-daꞌi no ana feto mana sia nusaꞌ naa. ");
INSERT INTO row_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Mane nusaꞌ naa, naran Hemor, mia leo Hewi. Ana mone na, naran Sikem. Lao esa, Sikem nita Dina, de nela nendi e, ma parkosa e. ");
INSERT INTO row_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Sikem rala na hii Dina. De ana olaꞌ malolole no Dina, naa fo Dina o simbo e boe. ");
INSERT INTO row_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Basa ma, Sikem nafadꞌe ama na nae, “Amaꞌ e! Tulun muu mutane Dina fee au, fo au sao ala e.” ");
INSERT INTO row_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Lele naa, Yakob o rena atahori parkosa ana feto na, te ana hie-hieꞌ a, nda tao saa saꞌ boe, huu ana mone nara ranea banda ra sia mooꞌ, de ana nahani losa basa se baliꞌ. ");
INSERT INTO row_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Boe ma Sikem aman Hemor, nisiꞌ Yakob, fo nae natane Dina. ");
INSERT INTO row_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Ruꞌa se ola-olaꞌ ma, Yakob ana nara baliꞌ mia mooꞌ a. Ara rena oi Sikem parkosa sira feton Dina ma, rala nara mera, ma ramanasa seli. Ara rae, “Tataos mataꞌ naa, nda nandaa sia Israꞌel sa. Ata afiꞌ simbo atahori mana tao deꞌulakaꞌ mataꞌ naa.” ");
INSERT INTO row_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Ma Hemor kokoe Yakob nae, “Toronooꞌ Yakob! Ana ngga Sikem rala na hii toronooꞌ ana feto ma. De au oꞌe fo ana ngga sao nala e. ");
INSERT INTO row_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Mete ma nau naa, hita ana nara esa sao esa. Hei ana mone mara sao hai ana feto mara. Ma hai ana mone mara sao hei ana feto mara. ");
INSERT INTO row_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","No taꞌo naa, hei leo miꞌibꞌue mo hai sia ia. Hei hii ao mara sudꞌiꞌ a mae leo sia bee. Fo ama danggan, ma hambu suꞌi sia ia.” ");
INSERT INTO row_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","12","Basa naa ma, Sikem olaꞌ no Dina aman ma naa nara nae, “Hei mae moꞌe saa o, au tunggaꞌ a. Hei mae moꞌe doi tatana mamaet do, felis baꞌu sa o, au bꞌae. Sadꞌi fee au sao hei feto ma.” ");
INSERT INTO row_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Te Yakob ana nara bubꞌuluꞌ oi Sikem parkosa sira feto na Dina ena. De ara rataa eꞌedik Sikem no ama na Hemor, ");
INSERT INTO row_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","rae, “Hai nda nau fee ne sao atahori nda mana sunat saa! Naa, naꞌamamaeꞌ hai! ");
INSERT INTO row_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Te dala malole na taꞌo ia: Basa hei touꞌ musi sunat onaꞌ hai dei. ");
INSERT INTO row_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Mete ma hei tao taꞌo naa, dei fo hita esa sao esa. Ma hai o leo mo hei sia ia, fo hita dadꞌi leo esa. ");
INSERT INTO row_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Te mete ma hei nda tungga hai hihii mara sa, ma nda sunat sa, dei fo hai mo baliꞌ hai feto ma, fo lao hela mamanaꞌ ia.” ");
INSERT INTO row_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Boe ma, Hemor no Sikem simbo oꞌola nara no maloleꞌ. ");
INSERT INTO row_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Te Sikem nda afiꞌ naꞌatataaꞌ sa ena, huu ana hii Dina seli. Leleꞌ naa, basa atahori sia nusaꞌ naa fee hadat neu Sikem. ");
INSERT INTO row_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","De Hemor no Sikem risiꞌ lelesu ineꞌ kamboꞌ, mamana nggero-furi dedꞌeat a, de reu raꞌabꞌue ro basa atahori nusaꞌ naa. Ara olaꞌ rae, ");
INSERT INTO row_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Toronoo nggare! Atahori Israꞌel ra hii rasodꞌa no mole-dame ro hita. Dadꞌi fee se leo raꞌabꞌue ro hita sia ia, huu nusaꞌ ia loaꞌ de dai basa hita. Ara o nau hita sao sira ana feto nara, ma sira o nau sao hita ana feto nara boe. ");
INSERT INTO row_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Te ara roꞌe akaꞌ a dala anaꞌ esa, mia hita. Ara roꞌe fo basa hita touꞌ ra musi sunat onaꞌ sira boe. ");
INSERT INTO row_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Mete ma hita tasodꞌa taꞌabꞌue ena, naa, banda no basa hata-heto nara o dadꞌi hita pusaka na boe. De malole lenaꞌ ata simbo hihii nara fo basa nggita sunat. Nau, do?” ");
INSERT INTO row_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Basa atahori mana maꞌabꞌueꞌ sia naa ra, tungga Hemor no Sikem oꞌola na. De basa touꞌ sia nusaꞌ naa sunat. ");
INSERT INTO row_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Fai ka telu na ma, leleꞌ basa mana sunat ra bisu nara feꞌe rambeta, Dina naa nara, Simeon no Lewi, lesu rala fela-tafa nara, ma masoꞌ nenee risiꞌ kamboꞌ rala reu. De ara tao risa basa touꞌ ra. ");
INSERT INTO row_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ara o risa Hemor no Sikem boe. Basa de, ro baliꞌ Dina lao hela Sikem ume na. ");
INSERT INTO row_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Basa ma, Yakob ana nara ruma kamboꞌ rala reu, de rambas rala kamboꞌ naa sudꞌiꞌ a saa nara. Ramanasa, huu atahori parkosa sira feto na sia naa. ");
INSERT INTO row_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ara rambas rendi basa atahori ra saa-saa nara mia ume rala, ma mboo rendi basa banda mana mia mooꞌ ra. ");
INSERT INTO row_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Ara o toꞌu rendi basa inaꞌ ra ro ana nara, ma rambas rala nusaꞌ naa bua-baꞌu mafeli nara. ");
INSERT INTO row_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yakob bubꞌuluꞌ ana nara tao taꞌo naa ma, ana olaꞌ no Simeon no Lewi nae, “Hei tao tatao nggoaꞌ saa ia? Tao miꞌisususaꞌ au! Mete te, atahori Kanaꞌan, atahori Peris, ma basa atahori ndule nusaꞌ ia ra, ramanasa hita. Atahori naa ra, naeꞌ. Te hita atahori nara, idꞌak a. Mete ma ara taliono rema, naa, lutu-etoꞌ nala basa hita ena.” ");
INSERT INTO row_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ara rataa no nasat rae, “Amaꞌ nau fo hai hela ara tao hai feto ma dadꞌi ina dalaꞌ, do?” ");
INSERT INTO row_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Basa naa ma, Lamatualain olaꞌ no Yakob nae, “Au ia, Lamatualain fo mana utudꞌu ao ngga neu nggo, leleꞌ mela hela aꞌa ma Esau. Ia naa, ho lali Betel muu leo. Losa naa, muririi mei tutunu-hohotuꞌ fee Au. Ma leo muu naa leo.” ");
INSERT INTO row_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","3","Basa ma, Yakob olaꞌ no basa ume isi nara nae, “Ia naa, basa hita tae lao Betel teu. Maꞌahulu na, au mia sususaꞌ rala, Lamatualain tulu-fali au mia naa. Au ae uririi mei tutunu-hohotuꞌ sia naa. Dadꞌi ia naa, nggari hendi basa paton sosonggoꞌ ra leo. Tao mimemeu ao mara, ma nggati bua-baꞌu mara, te ata tae beꞌutee neu Lamatualain.” ");
INSERT INTO row_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Boe ma ara fee basa paton sosonggoꞌ ma basa aꞌandikiꞌ ra. De Yakob naꞌoi se sia hau huu ineꞌ esa raeꞌ, deka kambo Sikem. ");
INSERT INTO row_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Yakob atahori nara lao mia Sikem ma, Lamatualain fee nemetaus neu atahori ndule nusaꞌ naa ra, de ara nda rambarani tao deꞌulaka Yakob se sa. ");
INSERT INTO row_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Naa de, Yakob no atahori nara, losa Betel sia rae Kanaꞌan no masodꞌaꞌ. (Feꞌesaꞌan, Betel, naran Lus). ");
INSERT INTO row_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Losa naa ma, Yakob lutu mbatu mei tutunu-hohotuꞌ. Ana babꞌae mamanaꞌ naa, El Betel, (sosoa na ‘Betel Lamatualain na’), huu maꞌahulu na Lamatualain natudꞌu Ao na neu e sia naa, leleꞌ ana nela mia aꞌa na. ");
INSERT INTO row_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Deka no kambo Betel, hambu hau huu ineꞌ esa atahori rae Alon Bakut. Sosoa na ‘hau ngganggaet’. Ara babꞌae raꞌo naa, huu leleꞌ Ribka ina mana oꞌo na, naran Debora, mate, ara raꞌoi e sia hau huuꞌ naa raeꞌ. ");
INSERT INTO row_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yakob baliꞌ mia Padan Aram ma, Lamatualain natudꞌu Ao na fai, ma fee ne papala-babꞌanggiꞌ. ");
INSERT INTO row_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Lamatualain olaꞌ nae, “Eniꞌ a mia ia nema, nara ma, nda Yakob sa ena. Te, Au fee nara feu ma, naeni, Israꞌel. ");
INSERT INTO row_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Au ia, Lamatualain mana Koasa. De bꞌonggi mumuhefu leo! Mete te, nusa-nusaꞌ ra rema mia tititi-nonosi mara. Ma ho bꞌonggi mane-maneꞌ ra. ");
INSERT INTO row_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Nusaꞌ fo Au fee neu baꞌi Abraham ma amam Isak, ia naa Au fee neu nggo mo tititi-nonosi mara.” ");
INSERT INTO row_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","14","Lamatualain olaꞌ basa ma, Yakob naririi rii fatuꞌ esa sia naa, dadꞌi nesenenedꞌaꞌ neu Lamatualain hehelu-fufuli na. Boe ma, ana mboꞌa oe anggor, no mina neu fatu a ata, de beꞌutee neu Lamatualain. ");
INSERT INTO row_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ana babꞌae mamanaꞌ naa, Betel. ");
INSERT INTO row_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Basa naa ma, Yakob se lao hela Betel. Ara feꞌe raꞌadꞌooꞌ ro Efrata (nara feaꞌ na, Betlehem), te Rahel naeꞌ a bꞌonggi ena. Te ana bꞌonggi susa. ");
INSERT INTO row_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ana feꞌe naꞌananasaꞌ ma, mana naꞌabꞌobꞌonggiꞌ a nafadꞌe e nae, “Ina Rahel! Tao manggatetee rala ma, huu inaꞌ hambu ana touꞌ esa fai!” ");
INSERT INTO row_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Rahel hahae na nae etu ma, ana babꞌae anaꞌ naa, Ben-Oni, (sosoa na ‘ana doidꞌosoꞌ’). Basa naa ma, ana mate boe. Te Yakob babꞌae anaꞌ naa, Benyamin, (sosoa na ‘ana lima onaꞌ’). ");
INSERT INTO row_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Basa ma, ara raꞌoi Rahel sia dalaꞌ mana nae nisiꞌ Efrata suu na (ia naa, Efrata naran Betlehem). ");
INSERT INTO row_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Boe ma Yakob naririi fatu rates esa sia naa. Rahel fatu rates na naa, feꞌe sia ia, losa faiꞌ ia. ");
INSERT INTO row_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Basa naa ma, Yakob lali-laliꞌ nakandooꞌ a. Lao esa, ana naririi lalaat deka ume kanaru ineꞌ sa, naran Eder. ");
INSERT INTO row_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Ara feꞌe leo sia naa ma, Ruben sungguꞌ no ama na sao tias na, Bilha. Ma Yakob o bubꞌuluꞌ dalaꞌ naa boe. Yakob ana mone nara sanahulu rua. Naeni, ");
INSERT INTO row_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Lea ana nara, Ruben (fo Yakob ana ulu na), Simeon, Lewi, Yahuda, Isaskar, ma Sebulon. ");
INSERT INTO row_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rahel ana nara, Yusuf ma Benyamin. ");
INSERT INTO row_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Rahel ate na Bilha ana nara, Dan ma Naftali. ");
INSERT INTO row_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Ma Lea ate na Silpa ana nara, Gad, ma Aser. Ara bꞌonggi basa anaꞌ naa ra sia Padan Aram. ");
INSERT INTO row_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Basa naa ma, Yakob neu seꞌu ama na Isak sia Mamre deka kambo Kiriat Arba (aleꞌ ia, naran Hebron). Maꞌahulu na, baꞌi Abraham o leo sia naa boe. ");
INSERT INTO row_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Isak nasodꞌa losa too natun esa falu nulu ma, ana mate. De ana na Yakob no Esau raꞌoi e. ");
INSERT INTO row_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ia ra, Esau tititi-nonosi nara. Esau nara fea na, Edom. ");
INSERT INTO row_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Ana sao ina Kanaꞌan rua. Esa, atahori Het, naran Ada, fo Elon ana feto na. Ma esa, atahori Hewi, naran Oholibama. Ama na, naran Anah, no baꞌi na, naran Sibeon. ");
INSERT INTO row_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Esau o sao nala Ismael ana feto na, naran Basmat. Basmat naa na, naran Nebayot. ");
INSERT INTO row_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Esau sao ulu na, Ada, bꞌonggi Elifas. Ma Basmat bꞌonggi Rehuel. ");
INSERT INTO row_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Ma Oholibama bꞌonggi Yeus, Yalam ma Kora. Ara bꞌonggi basa Esau ana nara mia Kanaꞌan. ");
INSERT INTO row_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Lao esa, Esau lali nisiꞌ nusa feaꞌ esa, naꞌadꞌodꞌooꞌ no Yakob. Ana nendi sao-ana nara, atahori mana tao ues nara, banda nara, ma basa suꞌi nara. ");
INSERT INTO row_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Ana saranggaa no Yakob, huu sira banda ma suꞌi nara naeꞌ. De ara leo rakaseꞌe sia nusaꞌ naa. ");
INSERT INTO row_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Boe ma Esau (naeni Edom), neu leo sia leleteꞌ Seir. ");
INSERT INTO row_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ia ra, Esau tititi-nonosi nara, fo rae atahori Edom. Ara leo sia nusa leleteꞌ sia Seir. ");
INSERT INTO row_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Esau sao na Ada, bꞌonggi ana moneꞌ esa, naran Elifas. Elifas ana na touꞌ lima. Nara nara, Teman, Omar, Sefo, Gatam ma Kenas. Elifas sao tias na, naran Timna. Ana bꞌonggi ana touꞌ esa, naran Amalek. Esau sao na Basmat, bꞌonggi ana moneꞌ esa, naran Rehuel. Rehuel ana na touꞌ haa. Nara nara, Nahat, Sera, Syama, ma Misa. ");
INSERT INTO row_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esau sao na Oholibama, fo Anah anan ma Sibeon umbun, bꞌonggi ana touꞌ telu. Nara nara, Yeus, Yalam, ma Kora. ");
INSERT INTO row_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","16","Esau umbu-ana nara raꞌababꞌanggi dadꞌi leo naeꞌ. Esa-esaꞌ no mane leo na. Esau ana ulun Elifas ana nara, dadꞌi mane leo Teman, mane leo Omar, mane leo Sefo, mane leo Kenas, mane leo Kora, mane leo Gatam, ma mane leo Amalek. Basa se, Esau no sao na Ada tititi-nonosi nara. ");
INSERT INTO row_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esau ana na Rehuel ana nara, dadꞌi mane leo Nahat, mane leo Sera, mane leo Syama, ma mane leo Misa. Basa se, Esau no sao na Basmat tititi-nonosi nara. ");
INSERT INTO row_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esau no sao na Oholibama ana nara, dadꞌi mane leo Yeus, mane leo Yalam, ma mane leo Kora. ");
INSERT INTO row_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Basa leo naa ra, Esau tititi-nonosi nara. ");
INSERT INTO row_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Sia mamanaꞌ naa o, hambu atahori Hori esa, naran Seir. Ana nara raꞌabꞌabꞌanggi dadꞌi leo naeꞌ. Esa-esaꞌ no mane leo na. Ana nara dadꞌi mane leo Lotan, mane leo Sobal, mane leo Sibeon, mane leo Anah, mane leo Dison, mane leo Eser, ma mane leo Disan. ");
INSERT INTO row_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan ana na, Hori ma Heman. (Lotan feto na, Timna). ");
INSERT INTO row_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobal ana nara, Alwan, Manahat, Ebal, Sefo, ma Onam. ");
INSERT INTO row_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibeon ana nara, Aya ma Anah. Anah, mana nita oe mata matobiꞌ sia nembe saraꞌae, leleꞌ ana tadꞌa aman keledei nara. ");
INSERT INTO row_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","26","Anah ana feto na, Oholibama. Ana mone na, Dison. Dison ana nara, Hemdan, Esban, Yitran, ma Keran. ");
INSERT INTO row_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Eser ana nara, Bilhan, Saꞌawan, ma Akan. ");
INSERT INTO row_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Dison ana nara, Us ma Aran. ");
INSERT INTO row_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Dadꞌi basa mane leo atahori Hori ra, naeni, Lotan, Sobal, Sibeon, Anah, Dison, Eser, ma Disan. Basa se leo sia rae Seir. ");
INSERT INTO row_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Leleꞌ nusa Israꞌel nda feꞌe hambu maneꞌ sa, te sia rae Edom hambu maneꞌ ena. Nara nara matutunggaꞌ, taꞌo ia: ");
INSERT INTO row_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Ara soꞌu Beor anan Bela, dadꞌi maneꞌ sia nusa Dinhaba. ");
INSERT INTO row_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela mate ma, Yobab dadꞌi maneꞌ, nggati e. Ama na, naran Sera mia kambo Bosra. ");
INSERT INTO row_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobab mate ma, Husam dadꞌi maneꞌ, nggati e. Husam, mia atahori Teman ra nusa na. ");
INSERT INTO row_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husam mate ma, Hadad dadꞌi maneꞌ, nggati e. Ama na, naran Bedad mia kambo Awit. (Eni, mana nasenggiꞌ atahori Midian leleꞌ ratati mia Moab.) ");
INSERT INTO row_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadad mate ma, Samla dadꞌi maneꞌ, nggati e. Samla, mia kambo Masreka. ");
INSERT INTO row_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samla mate ma, Saul dadꞌi maneꞌ, nggati e. Saul, mia kambo Rehobot sia loe suu na. ");
INSERT INTO row_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saul mate ma, Baꞌal-Hanan dadꞌi maneꞌ, nggati e. Ama na, naran Akbor. ");
INSERT INTO row_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baꞌal-Hanan mate ma, Hadar dadꞌi maneꞌ, nggati e. Hadar, mia kambo Pau. Sao na, naran Mehetabel. Mehetabel ama na, naran Matret. Ma baꞌi na, naran Mesahab. ");
INSERT INTO row_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Dadꞌi basa mane leo mana mia Esau se, naeni: Timna, Alwa, Yetet, Oholibama, Ela, Pinon, Kenas, Teman, Mibsar, Magdiel, ma Iram. Esa-esaꞌ babꞌae nusa na tungga naran. Dadꞌi basa naa ra, Esau tititi-nonosi nara, atahori Edom ra, dudꞌui na. ");
INSERT INTO row_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","2a","Ia, Yakob se dudꞌui na. Leleꞌ naa, Yakob neu leo baliꞌ sia rae Kanaꞌan, fo maꞌahulu na, aman Isak mamana leleon. ");
INSERT INTO row_vpl VALUES ("GN37_2b","002_37_2b","GEN","37","2b","2b","Leleꞌ naa, Yakob anan esa mia sao na Rahel, naran Yusuf. Ana too sanahulu hitu ma, no aꞌa nara reu ranea hiek-lombo ra. Aꞌa nara, anaꞌ mia Yakob sao nara, Bilha ma Silpa. Te Yusuf ia, mana nendi-nendiꞌ dedꞌeat fee ama na, soꞌal aꞌa nara. ");
INSERT INTO row_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Bonggi Yusuf te, Yakob lasiꞌ ena. Naa de ana sue Yusuf lenaꞌ ana na laen ra. Lao esa, Yakob soo badꞌu naru meulauꞌ esa, fee Yusuf. ");
INSERT INTO row_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Aꞌa nara rahine ama na sue Yusuf lenaꞌ, de ramanasa e seli. Ara nda nau ola-olaꞌ malolole ro e sa ena. ");
INSERT INTO row_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","7","Tetembaꞌ esa ma, Yusuf nalamein. De nafadꞌe meit naa neu aꞌa nara nae, “We! Hei rena dei! Au ulumein ae basa nggita paꞌa are-nggandum sia osi rala. Au are ngga nambariiꞌ ndos. Te hei are mara rambariiꞌ nduleꞌ au are ngga, ma beꞌutee neu are ngga.” Aꞌa nara rena rala ma, ramanasa e. ");
INSERT INTO row_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Boe ma ara ai Yusuf rae, “Woi! Mbei ma ho mae dadꞌi hai malangga mana parenda ma, do?” Ara ramanasa e seli, huu nafadꞌe meit naa. ");
INSERT INTO row_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Basa naa ma, Yusuf nalamein seluꞌ fai. De ana nafadꞌe aꞌa nara nae, “We! Au ulumein fai. Au ita relo, fulan, ma nduuꞌ sanahulu esa. Basa se beꞌutee malolole neu au.” ");
INSERT INTO row_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Yusuf dui basa meit naa neu aman no aꞌa nara ma, aman ai e nae, “Meit saa ka naa! Ho duꞌa mae au, o inam, ma aꞌa mara ima idꞌu ei ma, do? Ho seli, ma!” ");
INSERT INTO row_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","De Yusuf aꞌa nara rambedꞌaꞌ ralaꞌ ro e. Te aman dudꞌuꞌa meit naa nakandooꞌ a. ");
INSERT INTO row_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Faiꞌ esa ma, Yusuf aꞌa nara rendi ama na hiek-lombo nara losa deka no kambo Sikem. ");
INSERT INTO row_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Nda dooꞌ sa ma, ama na nae, “Yusuf e! Aꞌa mara ranea hiek-lombo deka no Sikem. De muote fo muu seꞌu se dei.” Yusuf nataa nae, “Malole amaꞌ.” ");
INSERT INTO row_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Boe ma ama na nae, “Muu dei, fo seꞌu aꞌa mara ro hiek-lombo nggara. Ara ona bee naa, baliꞌ mufadꞌe au.” Boe ma, Yusuf lao hela rae Hebron moo na, de nakandoo Sikem neu. ");
INSERT INTO row_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Losa naa, de sangga se ndule mooꞌ a. Basa ma, nandaa no atahori esa. De atahori naa natane e nae, “Ho sangga saa?’. ");
INSERT INTO row_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yusuf nataa nae, “Toꞌo. Au sangga aꞌa nggara. Ara mboo hiek-lombo sangga uru deka-deka ia. Toꞌo nita se boe, do?” ");
INSERT INTO row_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Nafadꞌe nae, “Ara nda sia ia sa. Oi rae reu sia deka-deka kambo Dotan.” Boe ma, Yusuf neu tungga aꞌa nara, losa nita se sia Dotan. ");
INSERT INTO row_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Yusuf feꞌe sia dodꞌooꞌ, te ara rita e ena. Boe ma ara maꞌiraꞌ rae tao risa e. ");
INSERT INTO row_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Esa nafadꞌe esa nae, “Mete dei. Malangga meit a nema ena! ");
INSERT INTO row_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ata tao tisa e leo, do? Basa fo honda hendiꞌ e nisiꞌ oe mates rala neu. Dei fo tafadꞌe amaꞌ tae banda fui ra raa hendi e. Basa fo ata mete meit nara, taꞌo bee!” ");
INSERT INTO row_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Rena nala naa ma, aꞌa Ruben na sangga dalaꞌ fo nae fee ne nasodꞌa. De ana ai odꞌi nara nae, “We! Ata afiꞌ tao tisa e! ");
INSERT INTO row_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Malole lenaꞌ ata tumbuꞌ e nisiꞌ oe mates ia rala. Sia ia mamana maꞌabambiꞌ, de atahori nda rahine sa. Sadꞌi afiꞌ tasaiꞌ raa na.” Ana olaꞌ taꞌo naa, huu ana nae mboꞌi Yusuf, fo denu e baliꞌ. ");
INSERT INTO row_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Yusuf losa boe ma, aꞌa nara toꞌu rala e, de sidꞌa hendi badꞌu naru meulau na. ");
INSERT INTO row_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Basa ma, ara lea dudꞌui e, de timba e oe mates rala neu. ");
INSERT INTO row_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Basa boe ma ara baliꞌ reu raa. Ara feꞌe raa, aiboiꞌ ma, rita nononggoꞌ esa nema. Nononggoꞌ naa, banda onta nara fua bua danggan, onaꞌ hau maꞌameniꞌ, bumbu-bumbu, ma modꞌo mataꞌ-mataꞌ. Tao-tao te nononggoꞌ naa atahori Ismael mia kambo Gilead rae laoꞌ dooꞌ reu sia Masir. ");
INSERT INTO row_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Basa ma, Yahuda nafadꞌe odꞌi-aꞌa nara nae, “Weh! Malole lenaꞌ taꞌo ia. Afiꞌ tisa e. Hita hambu saa, boe? Mae ona bee o, nda taꞌafuniꞌ tala raa na sa. ");
INSERT INTO row_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Malole lenaꞌ seo hendiꞌ e neu atahori Ismael ra. Mae tao taꞌo bee mbali e o, eni, hita odꞌi bꞌonggi na. De afiꞌ taꞌahinaꞌ e!” Boe ma, basa se tungga oꞌola na. ");
INSERT INTO row_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Basa naa ma, nandaa no atahori mana danggan naa ra tungga naa, Yusuf aꞌa nara lea e mia oe rala. De ara seo e neu atahori Ismael ra, no feli na doi fulaꞌ rua nulu. Basa ma, ara rendi Yusuf Masir neu. ");
INSERT INTO row_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ara seo Yusuf, te Ruben nda bubꞌuluꞌ sa. Leleꞌ ana baliꞌ nisiꞌ oe mataꞌ a neu, ana nggengger nala seli, huu Yusuf nese ena. De ana sisidꞌa bua na sia ao na, huu ralan susa nala seli. ");
INSERT INTO row_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Boe ma ana baliꞌ nisiꞌ odꞌi nara nae, “Aweee! Anaꞌ a nese ia ena. Ia naa, au ae tao taꞌo bee fai?” ");
INSERT INTO row_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Basa ma ara hala hiek esa, de haꞌi Yusuf badꞌu meulau na, de boroꞌ e neu raaꞌ. ");
INSERT INTO row_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Haꞌi rala badꞌu fo akaꞌ raaꞌ naa, de rendi fee ama na, ma rafadꞌe rae, “Amaꞌ! Hai here mala badꞌu ia. Mete sobꞌa. Afiꞌ losa odꞌi Yusuf ena na.” ");
INSERT INTO row_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Yakob mete badꞌu a ma, nahine neuꞌ ena. Nataa nae, “Aweee! Memaꞌ ia au ana ngga badꞌu na. Mitaꞌ mae banda fui ra raa e sia bee ena. Aweee! Au ana ngga mate ena!” ");
INSERT INTO row_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Basa naa ma, Yakob sisidꞌa badꞌu na, de olu karon abas, huu ana susa nala seli. Boe ma ana nggaee nakandondooꞌ a anan doo na seli. ");
INSERT INTO row_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Basa ana touꞌ ma ana ina nara rema radadale, te nda rala e sa. Ana nae, “Hokoꞌ! Au susa losa mate. Au nda bisa liliiꞌ anaꞌ ia sa.” De Yakob susa nakandooꞌ a, huu nasanedꞌa anan Yusuf mana mateꞌ a. ");
INSERT INTO row_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Leleꞌ Yakob feꞌe susa taꞌo naa, te atahori danggan naa ra losa Masir ena. De reu seo Yusuf neu malangga esa, naran Potifar. Eni, mane Masir a malangga nanea na. ");
INSERT INTO row_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Basa naa ma, Yahuda lao hela odꞌi-aꞌa nara, de leo no nonoo na Hira sia kambo Adulam. ");
INSERT INTO row_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Sia naa, hambu amaꞌ esa, atahori Kanaꞌan, naran Sua. Yahuda hii Sua ana feto na esa, de ruꞌa se sao. De ana bꞌonggi ana touꞌ hira matutunggaꞌ. ");
INSERT INTO row_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Ana ka esa na, ara babꞌae e, Er. ");
INSERT INTO row_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Boe ma karua na, ara babꞌae e, Onan. ");
INSERT INTO row_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ma katelu na, naran Sela. Bonggi Sela ma, ara lali risiꞌ kambo feaꞌ, naran Kesib. ");
INSERT INTO row_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Ana kaesa na, Er, naꞌamoko boe, Yahuda neu natane fee ne ana fetoꞌ esa, naran Tamar. De ruꞌa se sao. ");
INSERT INTO row_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Te Er naa, deꞌulaka na seli. Naa de, Lamatualain hukun nisa e. De ana mate nda hela anaꞌ sa. ");
INSERT INTO row_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Basa ma, Yahuda denu ana karua na nae, “Onan! Aꞌa ma mate ena, te nda ma anaꞌ sa. De ia naa, tungga atahori lasiꞌ ra, musi nggati aꞌa ma fo sao mala sao na. Fo fee aꞌa ma tititi-nonosiꞌ.” ");
INSERT INTO row_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Onan nahine adat naa ena. Te ana nda nau fee tititi-nonosiꞌ neu aꞌa na Er sa. De mete ma ana sungguꞌ no Tamar, naa, ana nggari hendi fini a, naa fo Tamar nda bꞌonggi sa. ");
INSERT INTO row_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Onan tatao na taꞌo naa, tao fee Lamatualain namanasa seli. Naa de Lamatualain o hukun nisa e boe. ");
INSERT INTO row_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Huu Yahuda ana nara ruꞌa se mana sao Tamar mate ena, de ana namatau. Ana duꞌa, afiꞌ losa ana muri na Sela sao nala Tamar, ma ana o mate boe. Naa de, nafadꞌe ana feto feu na Tamar nae, “Ana ngge. Malole lenaꞌ baliꞌ misiꞌ ina-ama mara leo. Dei fo ana ngga Sela naꞌamoko fo, baliꞌ uma sao mala e.” Boe ma Tamar baliꞌ. ");
INSERT INTO row_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Nda doo sa ma, Yahuda sao na mate. De ana susa losa fai sususaꞌ basa. Basa naa ma, ana noꞌe nonoo na naran Hira, de ruꞌa se kambo Timna reu. Sia naa, atahori ra raꞌabꞌue nggute bibꞌi lombo fuluꞌ, fo seo. ");
INSERT INTO row_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Boe ma atahori rafadꞌe Tamar rae, “Ama ari ma, Timna neu tungga fefetas nggute bibꞌi lombo fuluꞌ.” ");
INSERT INTO row_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Leleꞌ naa, Yahuda ana muri na Sela naꞌamoko ena. Te Tamar nahine nae ama ari na nda nau fee eni sao nala Sela sa. Boe ma Tamar sangga dalaꞌ fo noꞌe hak na. De ana olu hendi bua ina-falu na, ma nggati bua meulauꞌ. Ana lalaa langgan ma mboti matan nendiꞌ lafe anaꞌ. De neu endoꞌ sia kambo Enaim lelesu ine na, sia dalaꞌ nisiꞌ Timna neu. ");
INSERT INTO row_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Leleꞌ Yahuda tungga lelesu ineꞌ a, nita inaꞌ esa. Nae neꞌo ina dalaꞌ, huu Tamar koao no bua-baꞌu na, ma mboti mata na. ");
INSERT INTO row_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Yahuda nda bubꞌuluꞌ nae, naa eni ana feto feu na sa. Dadꞌi ana neu deka-deka inaꞌ naa, de natane nae, “We! Mete ma au o ho naa, moꞌe baꞌu sa?” Tamar nataa nae, “Neu. Miaꞌ a amaꞌ hihii na.” ");
INSERT INTO row_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Yahuda naloe nae, “Ona bee, au fee hiek esa, do?” Tamar naselu nae, “Malole, Amaꞌ. Sadꞌi fee au toꞌu saa dadꞌi neu nemehereꞌ dei. Losa sudꞌiꞌ a fai hiraꞌ amaꞌ haitua hiek a nema.” ");
INSERT INTO row_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","19","Boe ma Yahuda natane nae, “Au fee saa dadꞌi neu nemehereꞌ?” Tamar nataa nae, “Amaꞌ fee hela cap fo mana doko-dokoꞌ, no tali na sia boto ma. Ma lao hela teteas boe.” Rena taꞌo naa, ma Yahuda fee basa saa naa ra neu e. De ruꞌa se reu sungguꞌ raꞌabꞌue. Basa ma, Tamar baliꞌ. Ana olu hendi bua-baꞌu meulau na no lafe anaꞌ naa, de pake baliꞌ bua-baꞌu ina falu na. Nda bubꞌuluꞌ sa te, Tamar nairu. ");
INSERT INTO row_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Nda doo sa fai, Yahuda noꞌe tulun nonoo na Hira nae, “Mendi hiek ia fee ina dalaꞌ sia Enaim dei, fo haꞌi mala baliꞌ au sudꞌi a saa ngga fo ana toꞌu a.” Hira neu losa naa ma, natane neu nema, te nda nandaa no inaꞌ naa sa. ");
INSERT INTO row_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Boe ma natane atahori mana sia naa ra nae, “We! Hei mita ina dalaꞌ fo laꞌefa naa ana endoꞌ sia lelesu ineꞌ ia, do? Ana sia bee?” Te rataa rae, “Amaꞌ, ina dalaꞌ nese ia.” ");
INSERT INTO row_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","De Hira baliꞌ nisiꞌ Yahuda neu. Nafadꞌe nae, “Au nda undaa o inaꞌ naa sa. Au sangga-sangga, te atahori rae, ina dalaꞌ nese naa.” ");
INSERT INTO row_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yahuda nataa nae, “Hela sudꞌi a saa naa ra, fo ana soa se. Sadꞌi atahori afiꞌ tao raꞌamamaeꞌ hita. Au ae bae, te nda tandaa to e sa na.” ");
INSERT INTO row_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Seli fula telu ma, atahori reu rafadꞌe Yahuda rae, “Ana feto feu ma Tamar tao ao na dadꞌi ina dalaꞌ. De ia naa ana nairu ena.” Rena taꞌo naa, ma Yahuda namanasa seli. De ana parenda atahori nara nae, “Mi lea mo inaꞌ naa nema, fo lalangge e horis!” ");
INSERT INTO row_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","De reu lea rendi Tamar. Te ana haꞌi cap no teteas a. Boe ma ana denu rafadꞌe ama ari na nae, “Amaꞌ, tulun paresaꞌ sudꞌi a saa ia ra dei. Tenu-enaꞌ cap ma teteas ia, tao au uiru.” ");
INSERT INTO row_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Nita sudꞌi a saa naa ra, ma Yahuda nahine neuꞌ ena, nae eni ena na. De nafadꞌe nae, “Memaꞌ! Inaꞌ naa nda sala sa. Mana salaꞌ a, au. Matetu na, au musi uꞌusasaoꞌ e no ana ngga Sela. Te huu au nda nau sa. Mboꞌi e neu!” Boe ma, Yahuda nda naꞌabꞌue no Tamar sa ena. ");
INSERT INTO row_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Tamar fula-fai bobꞌonggi na losa ma, ana bꞌonggi ana dꞌuaꞌ. ");
INSERT INTO row_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Leleꞌ ana bꞌonggi, anaꞌ esa lima na naꞌahuluꞌ dea nema. De mana naꞌabꞌobꞌonggiꞌ a paꞌa aba mbilas neu lima na. Ana nae, “Ia, kaesa na.” ");
INSERT INTO row_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Te anaꞌ naa lea baliꞌ lima na. De nonoo na dea nema naꞌahuluꞌ. Mana naꞌabꞌobꞌonggiꞌ a nafadꞌe neu anaꞌ naa nae, “We! Ho memaꞌ maꞌadereꞌ o. Naa de, mukuseseti muꞌuhuluꞌ dea muu!” Ara babꞌae anaꞌ naa, Peres (sosoa na, ‘naseseti dea nema’). ");
INSERT INTO row_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Dei de, odꞌi na mana paꞌa aba mbilas a dea nema. Ara babꞌae e, Sera (sosoa na, ‘mbila raraa’). ");
INSERT INTO row_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","2","Leleꞌ naa, atahori Ismael ra ro Yusuf Masir neu. Sia naa, hambu malangga esa, nara na Potifar. Eni, malangga mia basa soldꞌadꞌu mana manea sia mane Masir ume panggat na. Potifar hasa nala Yusuf mia mana danggan ra, fo dadꞌi ate sia ume na. Sia naa, LAMATUALAIN tulu-fali Yusuf, de ue-tatao nara basa se dadꞌi no maloleꞌ. ");
INSERT INTO row_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Malangga na nita e tao ues malole na seli, ma nahine tebꞌe nae LAMATUALAIN tulu-fali Yusuf. ");
INSERT INTO row_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Naa de malangga na hii ma namahere e. De ana soꞌu e dadꞌi mandor sia umen. Ana fee ne tao mataꞌ neu umen ma basa hata-heton. ");
INSERT INTO row_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Huu Yusuf leo sia naa, de Lamatualain o fee papala-babꞌanggiꞌ neu malangga, atahori Masir naa. Ume isi nara, hata-heto na, osi na, no ue-tatao na o dadꞌi maloleꞌ. ");
INSERT INTO row_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Huu Potifar mete Yusuf tao mataꞌ neu basa ue-tataos ra no maloleꞌ, naa de ana nda afiꞌ duꞌa saa saꞌ boe, nahineꞌ a naaꞌ a. Leleꞌ naa, Yusuf ia meulau na seli. ");
INSERT INTO row_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Ana nda feꞌe leo dooꞌ sia naa sa te, Potifar sao na nau no e. Boe ma ana kokoe Yusuf fo nae sungguꞌ no e. ");
INSERT INTO row_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Te Yusuf nda nau sa. De nataa nae, “Afiꞌ taꞌo naa, inaꞌ! Te malangga ngga Potifar fee au koasa fo tao mataꞌ neu basa ue-tataos ra. ");
INSERT INTO row_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Sia ume ia, nda hambu atahori sa toꞌu koasa lenaꞌ au sa. Malangga fee au koasa basa ume isiꞌ a, akaꞌ a inaꞌ fo hokoꞌ. Taꞌo bee de au tao deꞌulakaꞌ onaꞌ naa. Naa o au labꞌan Lamatualain hihiin.” ");
INSERT INTO row_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Te mae onaꞌ naa o, tungga fai, malangga sao na akaꞌ kokoe nakandooꞌ a. Te Yusuf nda tao afiꞌ neu e sa. ");
INSERT INTO row_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Lao esa ma, Yusuf ume rala neu, de nae mete ues nara. Faiꞌ naa, atahori nese ume. ");
INSERT INTO row_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Boe ma malangga sao na nema lea Yusuf badꞌu na, de nae, “Uma leo! Ia naa helaꞌ a hita ruꞌa nggita ena. Uma leo fo teu sungguꞌ.” Te Yusuf nda nau sa. De ana nalelea, sambe badꞌu na lufa hendiꞌ e. Boe ma ana nela dea neu. Te inaꞌ naa feꞌe toꞌu nahereꞌ badꞌu a. ");
INSERT INTO row_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ana nita Yusuf nela hela badꞌu na ma, ");
INSERT INTO row_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","15","ana noꞌe atahori mana tao ues nara, de nafadꞌe nae, “We! Ima mita dei. Faꞌ ra tou Ibrani naa, masoꞌ au kama ngga. Ana nae parkosa au, te au nggasi uhereꞌ. Mete sie, ana hela badꞌu na, de nela dea neu. Au sao ngga nendi atahori ia nda maloleꞌ sa de tao naꞌamamaeꞌ a hita!” ");
INSERT INTO row_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Boe ma ana toꞌu badꞌu naa losa sao na baliꞌ. ");
INSERT INTO row_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Sao na baliꞌ ma, ana dui nae, “Aꞌa e! Atahori Ibrani fo aꞌa noꞌ a, faꞌ ra ana mia au kama ngga rala, nae parkosa au. ");
INSERT INTO row_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Te au randu uhereꞌ oꞌe atahori ra. De ana nela, lao hela badꞌu na.” ");
INSERT INTO row_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Rena sao na dui taꞌo naa, boe ma Potifar namanasa seli. ");
INSERT INTO row_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Ana denu reu toꞌu Yusuf, de tao e nisiꞌ maneꞌ a bui na rala. ");
INSERT INTO row_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Te LAMATUALAIN nda liliiꞌ Yusuf sa. De Ana tulun e, losa malangga bui a o hii Yusuf, ");
INSERT INTO row_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","ma namahere e boe. De ana fee ne tao mataꞌ neu basa atahori bui ra, ma basa ue-tataos sia naa ra. ");
INSERT INTO row_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Huu naa, malangga nda tao mataꞌ neu saa-saa sia bui rala sa ena. LAMATUALAIN tulu-fali Yusuf nakandooꞌ a, de basa ue-tataos ra dadꞌi no maloleꞌ. ");
INSERT INTO row_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","3","Sia bui naa, hambu atahori rua. Maꞌahulu na, ruꞌa se malangga tao mataꞌ sia mane Masir ume panggat na. Esa tao mataꞌ neu maneꞌ a nininu na, ma esa tao mataꞌ neu maneꞌ a roti na. Lao esa ara tao rasalaꞌ maneꞌ a. Maneꞌ a namanasa, de tao se bui rala reu. De ruꞌa se leo mamanaꞌ sa ro Yusuf. ");
INSERT INTO row_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Boe ma, malangga bui a parenda Yusuf tao mataꞌ neu ruꞌa se. Ara leo sia naa losa too esa do rua. ");
INSERT INTO row_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Tetembaꞌ esa, ruꞌa se ralamein. Esa-esaꞌ no meit na. Meit naa ra esaꞌ no sosoa na. ");
INSERT INTO row_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Mbilaꞌ neu ma, Yusuf nema, nita ruꞌa se mata nara susa. ");
INSERT INTO row_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Ana natane se nae, “Taꞌo bee de mata mara nda matetuꞌ sa?” ");
INSERT INTO row_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ara rataa rae, “Tembaꞌ a hai milimein, te hai nda bubꞌuluꞌ sosoa na sa.” Boe ma Yusuf olaꞌ nae, “Nda hambu atahori esa nahine meit ra sosoa na sa, akaꞌ a Lamatualain. Hei dui sobꞌa dei. Dei fo au sangga sosoa na mia Lamatualain.” ");
INSERT INTO row_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Basa naa ma, atahori mana tao mataꞌ neu maneꞌ a nininu na, dui nae, “Taꞌo ia. Sia meit ngga, au ita hau huuꞌ anggor esa, ");
INSERT INTO row_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","nasaranggaa telu. Hau huuꞌ naa naroo neuꞌ ena, nabuna, ma naboa latu nggingginuꞌ. ");
INSERT INTO row_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Basa ma ita, au toꞌu maneꞌ a nggala nininu na. Boe ma au haꞌi boa anggor de eꞌee oe na nisiꞌ maneꞌ a nggala na. Basa de, au loo fee maneꞌ a fo ninu.” ");
INSERT INTO row_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Rena taꞌo naa, boe ma Yusuf nafadꞌe nae, “Amaꞌ. Meit naa sosoa na taꞌo ia: masaranggaaꞌ telu naa, sosoa na fai telu. ");
INSERT INTO row_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Siaꞌ a fai telu rala ia, maneꞌ a fee amaꞌ kalua mia bui ia. Basa naa ana soꞌu baliꞌ amaꞌ, fo tao mataꞌ seluꞌ neu nininu na onaꞌ maꞌahulu na. ");
INSERT INTO row_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Mete ma amaꞌ uanale ma taꞌo naa, naa, afiꞌ liliiꞌ au o! Mete ma amaꞌ sue au, tulun mufadꞌe maneꞌ a, fo ana tao au deaꞌ uu mia mamanaꞌ ia dei. ");
INSERT INTO row_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Te tungga matetuꞌ na, ara haꞌi raꞌasususaꞌ au mia atahori Ibrani ra kambo na. Sia ia, au nda tao deꞌulakaꞌ saa saꞌ boe. Tao-tao te, ara tao au bui rala uu ena, onaꞌ au, atahori deꞌulakaꞌ. ");
INSERT INTO row_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Atahori mana tao roti a rena nala meit a sosoa na meulaun taꞌo naa ma, ana dui Yusuf nae, “Odꞌiꞌ e. Au o ulumein taꞌo ia: au suu boa telu. ");
INSERT INTO row_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Sia boa ata ka, hambu maneꞌ a kokis na mataꞌ-mataꞌ. Te mbuiꞌ ra rema de raa hendi basa se, mia langga ngga ata.” ");
INSERT INTO row_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yusuf rena nala ma, nataa nae, “Amaꞌ meit na, sosoa na taꞌo ia: boa ka teluꞌ naa ra, sosoa na fai telu. ");
INSERT INTO row_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Siaꞌ a fai telu rala ia, maneꞌ a denu atahori rema tati hendi amaꞌ langga na. De ara londa amaꞌ ao na neu rii. Boe ma mbuiꞌ ra rema bidꞌo rabasa amaꞌ ao sisi na.” ");
INSERT INTO row_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Seli fai telu ma, nandaa no maneꞌ a fai bobꞌonggi na, ana tao fefeta monaeꞌ fee basa pagau nara. Ana parenda se reu kalua pagau karuaꞌ ra dea reu. ");
INSERT INTO row_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Basa ma, ana soꞌu baliꞌ pagau mana tao mataꞌ neu maneꞌ a nininu na, neu baliꞌ panggat fefeu na, fo ana tao mataꞌ baliꞌ neu maneꞌ a nininu na. ");
INSERT INTO row_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Te pagau mana tao mataꞌ neu maneꞌ a roti na, ara londa risa e, onaꞌ a Yusuf oꞌola na. ");
INSERT INTO row_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Te pagau mana tao mataꞌ nininuꞌ a, nda nasanedꞌa Yusuf sa. Ana liliiꞌ hendi e. ");
INSERT INTO row_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Seli too rua ma, mane Masir a nalamein nae, eni nambari sia loe Nil suu na. ");
INSERT INTO row_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Aiboiꞌ ma, nita sapi mbaruna hitu. Rou nara manggadidilaꞌ. Ara dea reu mia loe a, de raa uru sia naa. ");
INSERT INTO row_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Boe ma, sapi hitu fai, dea reu mia loe a. Ao nara nggodaꞌ ra. Ara rambariiꞌ deka ro sapi maao ka hituꞌ ra. ");
INSERT INTO row_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Basa ma, sapi nggoda ka hituꞌ ra odꞌo hendi sapi maaoꞌ ra. Boe ma maneꞌ a nggengger de fela. ");
INSERT INTO row_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Nda dooꞌ sa ma, ana sungguꞌ seluꞌ fai, de nalamein. Nita are mbule maisiꞌ hitu dea rema mia are huu meulauꞌ esa. ");
INSERT INTO row_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Basa ma, nita seluꞌ, are mbule lakaꞌ hitu, loe-lesu rae reu, dai ani matobꞌiꞌ. ");
INSERT INTO row_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Boe ma basa are mbule lakaꞌ ra odꞌo hendi are mbule maisi ka hituꞌ ra. Basa naa ma, maneꞌ a fela. Dei de ana nahine, eni nalamein fai. ");
INSERT INTO row_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Fefetu anan ma, maneꞌ a namedꞌa nda maloleꞌ sa. De ana parenda atahori ra reu roꞌe basa mana tiroura ra ma atahori mahineꞌ sia Masir ra. Basa de ana dui meit na neu se, te nda hambu esa nahine meit na sosoa na sa. ");
INSERT INTO row_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Basa ma, pagau mana tao mataꞌ neu maneꞌ a nininu na, nasanedꞌa Yusuf. De nafadꞌe maneꞌ a nae, “Ama maneꞌ. Au musi utaa sala. ");
INSERT INTO row_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Maꞌahulu naa, amaꞌ namanasa au, o nonoo ngga, de tao hai bui rala mi. ");
INSERT INTO row_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Tetembaꞌ esa ma, hai ruꞌa nggi milimein. Esa-esaꞌ no meit na, ma meit naa ra, esa-esaꞌ no sosoa na. ");
INSERT INTO row_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Sia bui rala o hambu atahori Ibrani esa feꞌe soruꞌ. Malangga bui a soꞌu e dadꞌi malangga mana tao mataꞌ sia bui. Hai dui meit mara neu e. Boe ma ana nafadꞌe meit naa ra sosoa na. ");
INSERT INTO row_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","De ama maneꞌ soꞌu baliꞌ au. Te nonoo ngga naa, nenehukun mate. De basa naa ra, onaꞌ atahori Ibrani naa oꞌola na!” ");
INSERT INTO row_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Maneꞌ a rena nala ma, ana denu atahori lai-lai reu haꞌi Yusuf mia bui a. De Yusuf neu eu timi fulu na, tao ao na meuꞌ-meuꞌ, ma nggati bua-baꞌu na, fo neu nandaa no maneꞌ a. ");
INSERT INTO row_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Ana losa, boe ma maneꞌ a olaꞌ nae, “Taꞌo ia. Au ulumein, te nda hambu atahori esa nahine meit naa sosoa na sa. Te atahori rafadꞌe au rae, ho malaꞌ.” ");
INSERT INTO row_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Boe ma Yusuf nataa nae, “Ama maneꞌ. Au o nda alaꞌ saa saꞌ boe. Akaꞌ a Lamatualain mana nalaꞌ tebꞌe meit ma sosoa na. Ana nau nafadꞌe dala maloleꞌ neu ama maneꞌ.” ");
INSERT INTO row_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Boe ma, maneꞌ a dui nae, “Sia meit ngga, au umburiꞌ sia loe Nil suu na. ");
INSERT INTO row_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Hambu sapi maaoꞌ hitu, rou nara manggadidilaꞌ. Ara dea rema mia loe a, de raa uru mia loe suu na. ");
INSERT INTO row_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Basa ma sapi feaꞌ hitu rema. Te sapi naa ra nggoda ruiꞌ. Sia rae Masir ia, au nda feꞌe ita sapi nggodaꞌ onaꞌ naa sa! ");
INSERT INTO row_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","De au titindindiꞌ a. Huu aiboiꞌ ma, sapi nggoda kahituꞌ ra, odꞌo hendi sapi maao kahituꞌ ra. ");
INSERT INTO row_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ara odꞌo basa ma, ao nara nggodaꞌ feꞌe na ena. Boe ma au fela boe. ");
INSERT INTO row_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Basa ma, au sungguꞌ seluꞌ, de ulumein fai. Ita are mbule maisiꞌ hitu, dea rema mia are hauꞌ esa. ");
INSERT INTO row_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Boe ma, ita are mbuleꞌ lakaꞌ hitu, loe-lesu rae reu, dai ani matobꞌiꞌ. ");
INSERT INTO row_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Boe ma are mbule lakaꞌ ra, odꞌo hendi are mbule maisi ka hituꞌ ra. Ma au fela boe. Au dui meit naa ra reu atahori mahineꞌ ra. Te nda hambu esa nahine sosoa na saꞌ boe.” ");
INSERT INTO row_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Dei de Yusuf nafadꞌe nae, “Ama maneꞌ. Meit ka ruaꞌ naa ra sosoa na akaꞌ esa. Lamatualain nafadꞌe memaꞌ ama maneꞌ, saa fo Eni nae tao. ");
INSERT INTO row_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Meit naa ra sosoa na taꞌo ia: sapi ka hitu maaoꞌ naa ra, ma are mbule maisi ka hituꞌ naa ra, naeni fula-fai betas too hitu. Sosoa nara akaꞌ esaꞌ a. ");
INSERT INTO row_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Boe ma, sapi nggoda kahituꞌ ra, ma are mbule laka kahituꞌ naa ra, fula-fai ndoe-laꞌas too hitu. ");
INSERT INTO row_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","No taꞌo naa, Lamatualain nafadꞌe memaꞌ saa fo Eni nae taoꞌ a. Naa, onaꞌ au olaꞌ faꞌ ra. ");
INSERT INTO row_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Dei fo hita hambu fula-fai betas too hitu ndule mamanaꞌ sia nusa Masir ia. ");
INSERT INTO row_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","31","Basa fo hita hambu fula-fai ndoe-laꞌas too hitu. Fula-fai ndoe-laꞌas naa manaseliꞌ, losa nda hambu nanaat sia nusaꞌ ia sa. Basa atahori ndoe rala seli, de nda afiꞌ rasanedꞌa fula-fai betas naa sa ena. ");
INSERT INTO row_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Dadꞌi ama maneꞌ nalamein lao rua naa ra, sosoa na nae, Lamatualain nafadꞌe memaꞌ saa fo Eni nae taoꞌ naa. Nda doo sa te, ara sangga rae dadꞌi ena. ");
INSERT INTO row_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Huu naa, au oꞌe taꞌo ia: malole lenaꞌ ama maneꞌ sangga atahori mahineꞌ esa mana tao mataꞌ nalaꞌ no maloleꞌ. Fo soꞌu e fo tao malolole nusaꞌ ia. ");
INSERT INTO row_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Fula-fai betas too hitu naa, malole lenaꞌ ama maneꞌ soꞌu atahori feaꞌ fai, fo radꞌuru nanaat lenaꞌ, fo banggi neu lima ma mbedaꞌ babanggiꞌ esa. ");
INSERT INTO row_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ara musi tungga ama maneꞌ parenda na, fo reu haꞌi are mia basa kamboꞌ sia Masir. Fo ara mbedaꞌ are sia soka-poleꞌ ra fo nenea malolole. ");
INSERT INTO row_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Fo too hitu ndoe-laꞌas losa, te, hita feꞌe taꞌena nanaat. Naa fo nda hambu atahori mate ndoes sa.” ");
INSERT INTO row_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Maneꞌ no pagau monaeꞌ ra rena Yusuf oꞌola na ma, ara tungga e. ");
INSERT INTO row_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Maneꞌ a olaꞌ nae, “Lamatualain Dula-dalen koasa na, sia Yusuf. Naa de, hita nda bisa hambu atahori feaꞌ lenaꞌ e sa.” ");
INSERT INTO row_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Maneꞌ a olaꞌ no Yusuf nae, “Lamatualain nafadꞌe basa ia neu nggo. Ia naa, hai feꞌe bubꞌuluꞌ ho mahineꞌ. Ma ho dudꞌuꞌa ma lenaꞌ basa atahori. ");
INSERT INTO row_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Naa de, ia naa au soꞌu nggo dadꞌi fetor ngga. Dei fo basa rauinggu nggara tungga parenda ma. Te akaꞌ a au fo lenaꞌ nggo.” ");
INSERT INTO row_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","42","Basa naa ma, maneꞌ a olu hendi ndeli stempel na, de olu neu Yusuf lima uꞌu na. Boe ma olaꞌ nae, “No ndeli ia, au soꞌu nggo dadꞌi fetor ngga sia basa nusa Masir ia.” Boe ma ana olu badꞌu naru meulauꞌ esa neu Yusuf, ma boꞌoli rante liloꞌ neu boto na. ");
INSERT INTO row_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Ma ana fee kareta ndara karua na neu Yusuf fo sae. Atahori rela raꞌahuluꞌ reu mataꞌ ma nggasi rasafafali rae, “We! Soi dalaꞌ o! Fee hadat! Fetor nema tungga ia.” No taꞌo naa, maneꞌ a soꞌu Yusuf dadꞌi fetor sia nusa Masir. ");
INSERT INTO row_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Basa naa ma, maneꞌ a olaꞌ no Yusuf nae, “Taꞌo ia. Ho bubꞌuluꞌ au ia maneꞌ. Te au ufadꞌe basa atahori sia Masir ia ae, mete ma ho nda munggoloꞌ sa naa, ara nda bole tao saa saꞌ boe.” ");
INSERT INTO row_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Basa naa ma, maneꞌ a babꞌae Yusuf Safnat Panea, tungga atahori Masir ra naran. Ana naꞌasasaoꞌ Yusuf no inaꞌ esa, naran Asnat. Yusuf ama ari na, naran Potifera. Eni mana tao mataꞌ neu agama sia kambo On. No taꞌo naa, Yusuf dadꞌi atahori monaeꞌ sia nusa Masir. ");
INSERT INTO row_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Leleꞌ maneꞌ a soꞌu Yusuf, ana too telu nulu ena. Basa ma, ana neu lao ndule basa mamanaꞌ sia nusa Masir. ");
INSERT INTO row_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Sia too hitu fula-fai betas naa, osi ra nanaat nara nae na seli. ");
INSERT INTO row_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yusuf denu radꞌuru nanaat lenaꞌ ra, de mbedaꞌ se. Are mia mamana deka kamboꞌ bee naa, mbedaꞌ se sia soka-poleꞌ sia kamboꞌ naa. ");
INSERT INTO row_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Are fo ana nadꞌuruꞌ naa, nae na seli. Onaꞌ saraaeꞌ sia tasi suu na, de nda hambu atahori uku rala sa ena. ");
INSERT INTO row_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Fula-fai ndoe-laꞌas nda feꞌe losa sa te, Yusuf sao na Asnat bꞌonggi ana touꞌ rua. ");
INSERT INTO row_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yusuf olaꞌ nae, “Lamatualain tao au liliiꞌ doidꞌoso ngga leleꞌ au lao hela ama ngga ume na.” Naa de ana babꞌae ana ulu na Manase (lii na naꞌe a onaꞌ dedꞌea feaꞌ, fo sosoa na ‘liliiꞌ’). ");
INSERT INTO row_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Ana hambu ana karua na, boe ma olaꞌ fai nae, “Au hambu doidꞌosoꞌ naeꞌ sia mamanaꞌ ia. Te Lamatualain fee papala-babꞌanggiꞌ, ma au hambu anaꞌ sia ia.” De ana babꞌae anaꞌ naa Efraim (sosoa na ‘hambu anaꞌ’). ");
INSERT INTO row_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Fula-fai betas too hita a basa ma, ");
INSERT INTO row_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","fula-fai ndoe-laꞌas too hita losa, nandaa no saa fo Yusuf nafadꞌe maꞌahulu na. Sia mamana feaꞌ, atahori ndoe, te basa mamanaꞌ sia Masir, hambu nanaat. ");
INSERT INTO row_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Dꞌoo-dꞌoo ma, atahori Masir ra o ndoe boe. De ara reu roꞌe nanaat sia maneꞌ a. Boe ma ana denu se risiꞌ Yusuf, fo tunggaꞌ a Yusuf parenda na. ");
INSERT INTO row_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Te ndoe-laꞌas manaseliꞌ, de basa atahori sia Masir o ndoe boe. Dei de, Yusuf sefi soka-poleꞌ ra de seo are fee atahori Masir ra. ");
INSERT INTO row_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Basa naa ma, atahori ra mia bee-bꞌee rema hasa nanaat mia Yusuf sia Masir. Huu ndoe-laꞌas manaseliꞌ. ");
INSERT INTO row_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Leleꞌ naa, Yusuf ama na Yakob rena atahori rafadꞌe oi hambu are sia Masir. De ana ola-olaꞌ no ana nara nae, “Ana nggare! Taꞌo bee de hei endoꞌ onaꞌ nggoa ra taꞌo naa! ");
INSERT INTO row_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Au rena oi hambu nanaat sia Masir. Malole lenaꞌ mi hasa sia naa dei, fo ata afiꞌ mate ndoes.” ");
INSERT INTO row_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","De Yusuf aꞌa ka sanahulu nara, raote rae reu hasa nanaat sia Masir. ");
INSERT INTO row_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Te Yakob nda nau mboꞌi Yusuf odꞌi muri na Benyamin fo neu no se sa. Ana duꞌa, “Afiꞌ losa anaꞌ a hambu sususaꞌ fai!” ");
INSERT INTO row_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Dadꞌi, huu atahori sia bee-bꞌee rena oi hambu nanaat sia Masir, naa de ara reu hasa sia naa. Fula-fai ndoes o losa rae Kanaꞌan. De Yakob ana nara o reu hasa sia naa boe. ");
INSERT INTO row_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Leleꞌ naa, Yusuf dadꞌi fetor sia Masir. Mete ma atahori rema mia bee-bꞌee hasa are, Yusuf mana seo neu se. Naeni de, leleꞌ aꞌa nara losa, ara reu sendeꞌ lululangga nara fee hadat neu e, losa langga nara dai rae a. ");
INSERT INTO row_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","8","Leleꞌ nita se, ana nahine memaꞌ. Te Yusuf tao ao na onaꞌ atahori Masir, de ara nda rahine e sa. Ana natane se no deres nae, “Hei ia, mia bee ima?” Rataa rae, “Hai mia Kanaꞌan. Hai ima mae hasa nanaat sia ama fetor.” ");
INSERT INTO row_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Boe ma Yusuf nasanedꞌa meit na. De ana naꞌatatauꞌ se nae, “Au nda umuhere sa! Neꞌo basa hei ia ra mana maku-maꞌu. Hei ima mae mihine nusa Masir rahasia na, fo mitati mo hai.” ");
INSERT INTO row_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Te rataa rae, “Hokoꞌ, amaꞌ! Hai amaꞌ atahori dedenu na. Tebꞌe-tebꞌeꞌ hai ima mae hasa nanaat. ");
INSERT INTO row_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Basa hai amaꞌ esa. Hai nda maku-maꞌu sa, amaꞌ! Hai atahori maloleꞌ.” ");
INSERT INTO row_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Te Yusuf olaꞌ nahereꞌ nae, “He! Ombo koson! Afiꞌ peko-leleloꞌ au. Memaꞌ hei ia ra, mana maku-maꞌuꞌ. Hei ima mae mihine nusaꞌ ia rahasia nara!” ");
INSERT INTO row_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ara rahara rae, “Hokoꞌ, amaꞌ! Hai amaꞌ dedenu na. Hai ima mia rae Kanaꞌan. Hai odꞌi-aꞌa atahori sanahulu rua. Basa hai ama esa. Hai odꞌi muri ma leo nahani no hai ama ma, ma esa nese ena.” ");
INSERT INTO row_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yusuf nataa se nae, “Hokoꞌ! Saa fo au olaꞌ faꞌ ra, tebꞌe! Hei ia ra memaꞌ mana maku-maꞌuꞌ. ");
INSERT INTO row_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","De hei musi fee bukti dei, fo au uhine hei oꞌola ma naa, memaꞌ tebꞌe, do hokoꞌ. Au sumba! Mete ma hei odꞌi muri ma nda nema sia ia sa, hei nda lao hela nusaꞌ ia sa! ");
INSERT INTO row_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Dadꞌi hei tengga atahori sa fo neu nala hei odꞌi muri ma ia nema. Ma hela hei ruma. Au ae ita hei oꞌola ma naa, tebꞌe do hokoꞌ. Mete ma hokoꞌ, hei memaꞌ mana maku-maꞌu.” ");
INSERT INTO row_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Boe ma Yusuf denu tao se bui rala reu fai telu. ");
INSERT INTO row_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Fai ka telu na boe, Yusuf neu olaꞌ no se sia bui a nae, “Au ia, umutau neu Lamatualain ma tungga hiihii-nanau Na. Au nau mboꞌi hei, naa fo misodꞌa. Te hambu dalaꞌ esa. ");
INSERT INTO row_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Mete ma hei olaꞌ no matetuꞌ na, hei musi fee bukti neu au dei. Eni dala na taꞌo ia: au tao esa sia bui rala. Rumaꞌ baliꞌ fo mendi nanaat fee ume isi mara. Te ara rahani hei ena. ");
INSERT INTO row_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Basa naa, mendi odꞌi ma nema, fo dadꞌi bukti hei atahori maloleꞌ. Fo au afiꞌ hukun isa hei.” Rena taꞌo naa, ma raꞌaheiꞌ. ");
INSERT INTO row_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","De ara esa olaꞌ no esa rae, “Ia naa hita hambu bala-bꞌaeꞌ mia hita tatao na, fo hita tao neu hita odꞌi na. Hita tita ana doidꞌoso nala seli. Ana noꞌe tulun te, hita nda tao-afiꞌ sa. Naa de, ia naa hita doidꞌoso onaꞌ ia ena.” ");
INSERT INTO row_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Boe ma Ruben fee nesenenedꞌaꞌ neu se nae, “We, odꞌiꞌ re! Maꞌahulu na, au ai hei ena, fo afiꞌ tao saa-saa neu anaꞌ naa boe, to? Te hei nda tao-afiꞌ neu au oꞌola ngga sa. Naa de, ia naa hita lemba Yusuf raa na ena.” ");
INSERT INTO row_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Ara ola-olaꞌ taꞌo naa, te nda rahine rae Yusuf nahine sira dedꞌea na sa. Huu, Yusuf ola-olaꞌ no se nendiꞌ dedꞌea Masir, dei fo mana ola-olaꞌ na olaꞌ nisiꞌ dedꞌea Ibrani. ");
INSERT INTO row_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Rena ara ola-olaꞌ taꞌo naa, Yusuf fela hela se, de neu nggae mia mamana feaꞌ. Ana nggae basa dei de, baliꞌ nisiꞌ se. De ana denu ara futu Simeon mia odꞌi-aꞌa nara mata na. ");
INSERT INTO row_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Basa naa ma, Yusuf parenda pagau nara, fo ombo are nisiꞌ aꞌa nara karon nara. Ma tao baliꞌ doi nara risiꞌ karon nara rala. Ana o denu tao fee se lepa-ngges. De pagau nara tao tungga Yusuf parenda na. ");
INSERT INTO row_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Basa de, Yusuf aꞌa nara rafufuaꞌ karon are ra risiꞌ kaledei ata. De ara lao baliꞌ. ");
INSERT INTO row_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Mia dalaꞌ taladꞌa na, ara hahae. Boe ma, esa sefi karon tali na, fo nae fee keledei na naa. Te nita doi na sia are ata. ");
INSERT INTO row_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ana nggengger nala seli. Boe ma ana randu aꞌa nara nae, “Awiii! Mete dei! Hita soe ena. Ara tao baliꞌ au doi ngga sia karon rala.” Ara rita taꞌo naa ma, bingun ma ramatau. De ara ola-olaꞌ rae, “Lamatualain tao sa neu hita fai ia?” ");
INSERT INTO row_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Basa naa ma, ara lao rakandoo. Losa Kanaꞌan ma, ara dui ama na, basa saa mana dadꞌi neu se. ");
INSERT INTO row_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Rafadꞌe rae, “Amaꞌ e! Fetor Masir a, manaseliꞌ. Oꞌola na nda no hadat sa. Ana napepenggo hai oi, hai mana maku-maꞌu nusaꞌ naa. ");
INSERT INTO row_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Te hai mitaa mae, “Hokoꞌ! Hai olaꞌ no matetuꞌ. Hai ia ra nda mana maku-maꞌu sa. ");
INSERT INTO row_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Hai atahori maloleꞌ. Basa hai, odꞌi-aꞌa atahori sanahulu rua mia amaꞌ esa. Te esa mate ena, ma muriꞌ a leo no hai ama ma sia Kanaꞌan.’ ");
INSERT INTO row_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Boe ma, fetor a nae, ‘Au ae sobꞌa, hei ia ra ndos do hokoꞌ! Hei esa musi leo sia ia. Ruma baliꞌ mendi are fee ume isi mara, fo ara afiꞌ mate ndoes. ");
INSERT INTO row_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Basa naa, hei musi mendi odꞌi ma dei. No taꞌo naa, dei fo au bubꞌuluꞌ hei ia ra nda mana maku-maꞌu sa, te memaꞌ hei atahori ndos. Boe ma, au mboꞌi hei torono ma mia bui a. Ma mboꞌi hei, fo sudꞌiꞌ a bee mii, sia nusaꞌ ia.’” ");
INSERT INTO row_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Dꞌui basa ma, ara bonggar karon nara isi na. Aiboiꞌ ma rita doi nara, feꞌe sia karon rala. De Yakob no ana nara ramatau rae mate. ");
INSERT INTO row_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Basa naa ma, Yakob olaꞌ no se nae, “Hei ia ra tao mimopoꞌ ana nggara. Yusuf nese ena. Simeon o nese boe. Ia naa hei mae mendi Benyamin fai, do? Hei ia ra tebꞌe-tebꞌeꞌ mae tao doidꞌoso au, ma!” ");
INSERT INTO row_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Boe ma Ruben olaꞌ no ama na nae, “Amaꞌ e! Fee Benyamin neu au. Au unea e. Au helu, dei fo au endi baliꞌ e nisiꞌ amaꞌ. Te mete ma hokoꞌ, tao misa ana mone karua nggara.” ");
INSERT INTO row_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Te Yakob olaꞌ nae, “Hokoꞌ! Hei nda bole mo Benyamin sa. Aꞌa na Yusuf mate ena. Helaꞌ a mesaꞌ ne. Mete ma ana taꞌo esa sia dalaꞌ, naa, hei tao au susa sambe mate.” ");
INSERT INTO row_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Leleꞌ naa, ndoes-laꞌas sia Kanaꞌan boe fua. ");
INSERT INTO row_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Yakob no ume isi nara rabasaꞌ hendi nanaat fo maꞌahulu na, ana nara rendi mia Masir. Boe ma ana nafadꞌe se nae, “Ana nggare. Malole lenaꞌ hei baliꞌ Masir mii, fo hasa seluꞌ nanaat fee hita dei.” ");
INSERT INTO row_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Te Yahuda nataa nae, “Amaꞌ! Faiꞌ naa, fetor naa fee nesenenedꞌaꞌ neu hai nae, mete ma hai nda mo amaꞌ ana muri ma sa, naa, hai afiꞌ mitudꞌu mata mara neu e. ");
INSERT INTO row_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","De amaꞌ musi mboꞌi odꞌi Benyamin, fo tungga hai dei. Naa fo hai feꞌe mii hasa nanaat fee amaꞌ. ");
INSERT INTO row_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Te mete ma amaꞌ nda fee Benyamin neu sa, naa, hai o nda mi saꞌ boe. Te atahori Masir naa olaꞌ taꞌo naa ena naa.” ");
INSERT INTO row_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Boe ma Yakob ai se nae, “Taꞌo bee de hei mifadꞌe atahori naa, mae hei odꞌi ma feꞌe hela esa fai. Hei sangga miꞌisususaꞌ a au!” ");
INSERT INTO row_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Te ara kokoe rae, “Amaꞌ e! Atahori naa akaꞌ natane nakandooꞌ a, fo nae bubꞌuluꞌ hita bobꞌonggiꞌ nara. Ana natane nae, ‘Taꞌo bee? Hei ama ma feꞌe masodꞌaꞌ, do? Hei feꞌe ma odꞌi touꞌ fai, do?’ De hai feꞌe mae saa fai!’ Naa de hai o olaꞌ no matetuꞌ boe. Te se nitaꞌ nae ana nae denu hai mendi odꞌiꞌ neu sia naa?” ");
INSERT INTO row_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","9","Boe ma Yahuda olaꞌ seluꞌ nae, “Amaꞌ! Mboꞌi anaꞌ naa neu no hai leo. Au helu, mete ma dadꞌi saa-saa neu e, naa, au nggati ala e. Mete ma au nda o baliꞌ e masodꞌaꞌ neu amaꞌ sa, naa, amaꞌ fua salaꞌ neu au losa mate. Dadꞌi amaꞌ mboꞌi anaꞌ naa leo, te hai mae lao ia ena. Malole lenaꞌ hai mi lai-lai, fo ata afiꞌ mate ndoes. ");
INSERT INTO row_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Sobꞌa hai nda mihani doo na basa ia sa, naa hai baliꞌ lao rua ena.” ");
INSERT INTO row_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Boe ma ama na nae, “Mete ma taꞌo naa, naa, hei tao taꞌo ia. Mendi hita rae na buna-bꞌoa malole na, onaꞌ a oni oeꞌ, bumbu-bumbu, hau maꞌameniꞌ raa na, modꞌo salap, kanari no hau dekeꞌ lain ra. Mendi basa se fee neu fetor Masir a, fo mae ia hita lepa-ngges na. ");
INSERT INTO row_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Hei o mendi doiꞌ dedesi na lao rua, huu hei musi fee baliꞌ doiꞌ fo hei hambu mia karon mara faiꞌ naa. Mbei ma atahori naa ra mbedꞌaꞌ rasalaꞌ. ");
INSERT INTO row_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Mo hei odꞌi ma boe, te baliꞌ lai-lai e. ");
INSERT INTO row_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Au hule-huleꞌ fo Lamatualain Koasa mana Seliꞌ na, tao fetor a kasian hei. Naa fo ana nau fee baliꞌ Benyamin no Simeon, fo basa hei baliꞌ. Te, mete ma ana nggara mopo se, naa, au lemba sususaꞌ naa sambe mate.” ");
INSERT INTO row_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Basa naa de, ara reu raduru lepa-ngges ma haꞌi doiꞌ, fo rendi Masir neu. De ara lao ro Benyamin. Ara losa naa de, reu risiꞌ Yusuf. ");
INSERT INTO row_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Yusuf nita Benyamin no aꞌa nara ma, ana denu malangga mana tao ues nae, “We! Mo atahori ia ra risiꞌ ume ngga. Mi tati sapi esa, fo nasu maladꞌa-maladꞌaꞌ. Te dei fo, ara raa reorenduꞌ ro au.” ");
INSERT INTO row_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Boe ma, malangga mana tao ues tao tungga Yusuf parenda na. De ana no se risiꞌ Yusuf ume na. ");
INSERT INTO row_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ara lao boe ma, aꞌa nara ramatau rala seli. Sia dalaꞌ taladꞌa na ara ola-olaꞌ rae, “We! Taꞌo bee de ana denu ro hita tisiꞌ ia. Seꞌu-seꞌu te nae tao naꞌasususaꞌ hita, huu doiꞌ fo ara tao baliꞌ sia hita karon na maꞌahulu na. Ara ro hita ia tema, fo aiboiꞌ ma, toꞌu hita, fo tao dadꞌi ate na. Ma rambas rala hita keledei nara.” ");
INSERT INTO row_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Naa de, deka-deka Yusuf ume na ma, ara olaꞌ ro malangga mana tao ues a rae, ");
INSERT INTO row_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Ama! Hai moꞌe maꞌaf, te maꞌahulu na hai ima hasa nanaat sia ia ena boe. ");
INSERT INTO row_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","22","Hai baliꞌ kamboꞌ mi, de hai hahae mia dalaꞌ. Mae sungguꞌ ma, hai sefi karon fo mae hani banda ra. Naa te hai hambu baliꞌ esa-esaꞌ doiꞌ are mara, mia karon rala. Hai nda mihine seka mana tao neu naa sa. De ia naa, hai mendi baliꞌ basa doiꞌ naa ra. Dadꞌi amaꞌ afiꞌ mumunasa o. Hela fo amaꞌ nahine, ia naa hai o mendi doiꞌ lenaꞌ fo mae hasa seluꞌ nanaat feuꞌ.” ");
INSERT INTO row_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Basa ma, malangga mana tao uesꞌ a nataa nae, “Hei neneꞌ a. Afiꞌ mimitau. Mbei ma hei Lamatualain ma, mana fee nggi papala-babꞌanggiꞌ sia karon naa ra. Faiꞌ naa, au simbo ala basa hei doi ma ena. Hei nda mihuta saa saꞌ boe!” Boe ma ana mboꞌi Simeon neu se. ");
INSERT INTO row_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","De basa se risiꞌ Yusuf ume na rala. Malangga mana tao ues a fee se oe safe ei nara. Ana o hani keledei nara boe. ");
INSERT INTO row_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Boe ma, nafadꞌe nae, “Dei fo hei mia reorenduꞌ mo malangga.” Ara feꞌe rahati Yusuf nenema na ma, ara haꞌi memaꞌ lepa-ngges nara. ");
INSERT INTO row_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Yusuf losa boe, basa se sendeꞌ lululangga nara sia mata na. Dei de, ara fee lepa-ngges ra reu e. ");
INSERT INTO row_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Yusuf natane se nae, “Taꞌo bee? Basa hei malolole, do? Hei ama ma lasiꞌ naa, onaꞌ bee? Ana malole, do?” ");
INSERT INTO row_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Rataa rae, “Amaꞌ ate lasi ma, fo hai ama bꞌonggi ma, malolole.” Basa de, ara beꞌutee fee hadat neu e. ");
INSERT INTO row_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Yusuf mete ndule basa se, de nita odꞌi na Benyamin. Ana nae, “Ooo! Ia eni, hei odꞌi muri ma fo hei dui faiꞌ naa, do?” Boe ma ana olaꞌ no Benyamin nae, “Ana ngge! Au hule-huleꞌ fo Lamatualain pala-banggi fee nggo papala-babꞌanggiꞌ naeꞌ.” ");
INSERT INTO row_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Nita Benyamin ma, Yusuf naeꞌ a natudꞌu susue na ena. Huu ana sue odꞌi na nae na seli. Ana nda naeꞌ a naꞌatataaꞌ nala rala na sa ena. De ana lai-lai lao hela se, nisiꞌ kama na rala. Ana nggae mesuꞌudꞌu-faruka sia naa. ");
INSERT INTO row_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Nggae basa, dei de neu narou mata na. Ana naꞌamamateꞌ rala na, de neu nandaa no se fai. Basa de, ana denu pagau nara reu ralalau mei a. ");
INSERT INTO row_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Ara tao fee Yusuf naa mia mei mesaꞌ ne. Odi-aꞌa nara raa sia mei feaꞌ. Atahori Masir mana tao ues nara raa sia mei feaꞌ boe, huu atahori Masir ra melumudꞌu raa raꞌabꞌue ro atahori Ibrani ra. ");
INSERT INTO row_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Malangga mana tao ues a fee Yusuf odꞌi-aꞌa nara endoꞌ matambambaliꞌ ro e. Ana fee se endoꞌ teri-teri tungga sira too nara, mia aꞌaꞌ losa odꞌi muriꞌ a. Rita taꞌo naa ma, titindindi. ");
INSERT INTO row_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Yusuf denu pagau nara haꞌi nanaat fee odꞌi-aꞌa nara mia mei na. Basa se simbo ona-ona esaꞌ. Te ara tao fee Benyamin, lenaꞌ aꞌa nara lao lima. De basa se raa-rinu losa raꞌabeta. ");
INSERT INTO row_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Ara raa basa ma, Yusuf naꞌauꞌutuꞌ malangga mana tao ues na nae, “We! Muu ombo are neu atahori ia ra karon nara losa sofe se. Ma tao baliꞌ doi nara nisiꞌ esa-esaꞌ karon na rala. ");
INSERT INTO row_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Boe ma haꞌi mala au mok lilo fula ngga, fo tao nisiꞌ ana muriꞌ a karon na.” De ana neu tao tungga Yusuf parenda na. ");
INSERT INTO row_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Mbila fefetu ana na, Yusuf mboꞌi se lao baliꞌ rendi nanaat no keledei nara. ");
INSERT INTO row_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ara nda feꞌe raꞌadooꞌ kamboꞌ sa ma, Yusuf nafadꞌe malangga mana tao ues na nae, “Muu tungga atahori naa ra lai-lai. Mete ma hambu se, naa, mufadꞌe maꞌo ia: ‘Taꞌo bee de rala mara deꞌulakaꞌ mbali toulasiꞌ a? Losa hei balas malole na mo deꞌulakaꞌ taꞌo ia. ");
INSERT INTO row_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Taꞌo bee de loi mendi malangga mok lilo fula na? Hei nda bubꞌuluꞌ sa, do? Naa nda akaꞌ a mok nininuꞌ sa. Ana o sangga atahori uanale nara nendiꞌ mok naa. Naa mok mahineꞌ! Hei tatao mara ia, deꞌulaka na seli ma!’” ");
INSERT INTO row_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Basa de, malangga mana tao ues neu tungga de hambu se. Ana nafadꞌe se, tungga Yusuf oꞌola na. ");
INSERT INTO row_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ara rataa rae, “Amaꞌ masud na taꞌo bee ia? Hai sumba. Hai nda tao deꞌulakaꞌ taꞌo naa sa. ");
INSERT INTO row_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Amaꞌ bubꞌuluꞌ, to? Doi-doiꞌ mana mia karon rala faiꞌ naa, hai fee baliꞌ neu amaꞌ, to? De taꞌo bee de hai loi malangga lilo fula na mia umen fai. Hokoꞌ o! ");
INSERT INTO row_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Amaꞌ paresaꞌ neuꞌ ena. Hambu sia seka karon na, naa hukun misa e leo. Ma hai ruma dadꞌi ate ma.” ");
INSERT INTO row_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Malangga mana tao ues a nae, “Hokoꞌ! Taꞌo ia. Mete ma hambu mok sia seka, naa, ana dadꞌi au ate ngga. Ruma baliꞌ.” ");
INSERT INTO row_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Boe ma ara raꞌondaꞌ karon naa ra lai-lai, de sefi se. ");
INSERT INTO row_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Malangga mana tao ues a paresaꞌ lutu-leloꞌ karon naa ra esa-esaꞌ, mia aꞌa ka karon na, losa odꞌiꞌ a ena na. De ana hambu mok lilo fulaꞌ mia Benyamin karon na. ");
INSERT INTO row_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Boe ma Benyamin aꞌa nara rala nara rambalulutu. De ara fua baliꞌ karon naa ra keledei ata reu, ma baliꞌ kambo reu. ");
INSERT INTO row_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Losa Yusuf ume na boe, ana feꞌe sia naa. De ara sendeꞌ lululangga nara neu mata na. ");
INSERT INTO row_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yusuf bua se nae, “He! Taꞌo bee de hei tao onaꞌ ia neu au. Hei nda mihine mae atahori monaen onaꞌ au ia, sangga atahori rahasia na endiꞌ mahineꞌ naa sa, do?” ");
INSERT INTO row_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yahuda nataa nae, “Awi! Lamatualain natudꞌu hai sala mara ena. Hai mae saa fai, amaꞌ? Hai mae misilaꞌe ao ma, onaꞌ bee fai. Mete ma amaꞌ nae hela hai odꞌi muri ma ia, naa, malole lenaꞌ amaꞌ hela basa hai. Haꞌi mala basa hai dadꞌi ate ma.” ");
INSERT INTO row_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Yusuf nataa nae, “Hokoꞌ! Hambu mok a sia seka e, na eni mana dadꞌi au ate ngga. Hei ruma, nenemboꞌit. Baliꞌ misiꞌ ama ma leo!” ");
INSERT INTO row_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Yahuda neu deka-deka no Yusuf, de olaꞌ nae, “Ama fetor! Au bubꞌuluꞌ amaꞌ koasa na onaꞌ maneꞌ a boe. Huu naa, de afiꞌ mumunasa au dei. Au oꞌe ola-olaꞌ mbei o amaꞌ. ");
INSERT INTO row_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Maꞌahulu na amaꞌ natane hai mae, ‘Hai ama ma no odꞌi ma esa feꞌe sia, do?’ ");
INSERT INTO row_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Hai mitaa mae, ‘Hai ama ma lasiꞌ ena. Boe ma odꞌi muri ma, esa. Leleꞌ bꞌonggi e, hai ama ma lasiꞌ ena. Aꞌa bꞌonggi na esaꞌ a, te ana nese ena. Ruꞌa se ina na mate ena. De ia naa, helaꞌ a mesaꞌ ne. Naa de, hai ama ma sue nala e seli.’ ");
INSERT INTO row_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Basa de, amaꞌ denu hai mo e, fo mita e. ");
INSERT INTO row_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Te hai mitaa mae, anaꞌ naa nda lao hela ama na sa. Mete ma ana lao hela e, naa, hai ama ma mate, neuꞌ ena. ");
INSERT INTO row_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Boe ma amaꞌ nataa nae, ‘Mete ma hei nda mendi odꞌi ma sa, naa, hei nda bisa mita mata ngga sa ena.’ ");
INSERT INTO row_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Basa de hai baliꞌ. Mifadꞌe basa amaꞌ oꞌola na neu hai ama ma. ");
INSERT INTO row_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Dꞌoo-dꞌoo ma, hai nanaa mara basa boe. De hai ama ma denu ima hasa seluꞌ nanaat fai. ");
INSERT INTO row_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Hai mitaa seluꞌ mae, ‘Amaꞌ e! Hai nda mi sia naa sa. Te fetor a, nafadꞌe ena, mete ma hai nda mo odꞌi muriꞌ a sa, naa, hai sudꞌi mindaa mo e. Dadꞌi hai odꞌi muri ma musi tungga, dei fo hai feꞌe lao naa.’ ");
INSERT INTO row_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Hai ama ma olaꞌ fai nae, ‘Hei bubꞌuluꞌ, to? Au sao ngga Rahel, ana na akaꞌ ruaꞌ a. ");
INSERT INTO row_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ana uluꞌ a nese ena. Banda fui ra raa hendi ena. Naa de, losa faiꞌ ia au nda undaa o e sa. ");
INSERT INTO row_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Mete ma hei haꞌi mala ana muriꞌ ia mia au fai, boe ma ana taꞌo esa naa, hei boe tao miꞌisususaꞌ au lasiꞌ ia, de au mate neuꞌ ena.’ ");
INSERT INTO row_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","De onaꞌ naa, ama fetor. Mete ma au baliꞌ isiꞌ ama ngga, nda o baliꞌ odꞌi muriꞌ ia sa, naa, hai ama ma mate neuꞌ ena, huu rala na esa no anaꞌ naa. Ana namalasi seli ena, naa de mete ma hai boe tao miꞌisususaꞌ e, naa, ana mate neuꞌ ena. ");
INSERT INTO row_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Boe ma au o helu ama ngga, au mana o baliꞌ anaꞌ naa. Au helu ae, mete ma nda o baliꞌ anaꞌ ia sa, naa au tanggon salaꞌ losa mate. ");
INSERT INTO row_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Dadꞌi au oꞌe taꞌo ia, amaꞌ: Au leo uhatiꞌ a ia nggati e, fo dadꞌi amaꞌ ate na. Hela e baliꞌ no aꞌa nara. ");
INSERT INTO row_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Mete ma anaꞌ naa nda tungga sa, naa, au o nda baliꞌ saa boe. Au nda nau ita ama ngga doidꞌoso losa mate sa.” ");
INSERT INTO row_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yusuf rena nala Yahuda oꞌola na, rala na noe rau-rau nda naꞌatataaꞌ sia pagau nara mata nara sa. De ana denu se dea reu, fo hela mesaꞌ ne no odꞌi-aꞌa nara. Ana nae nafadꞌe eni ia, seka. ");
INSERT INTO row_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Paggau nara basa se dea reu, ma Yusuf nggae nahereꞌ, losa atahori Masir mana sia kama a deaꞌ, rena. Ma atahori mana sia maneꞌ a ume na, o rena boe. ");
INSERT INTO row_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Basa de, Yusuf nafadꞌe relo-relo odꞌi-aꞌa nara nae, “We! Odꞌi-aꞌa re. Au ia Yusuf, hei toronoo ma. Amaꞌ feꞌe masodꞌaꞌ, to?” Odꞌi-aꞌa nara rena taꞌo naa ma, ramatau rala seli, losa nda ola-olaꞌ rala saa saꞌ boe. ");
INSERT INTO row_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Boe ma Yusuf noꞌe se nae, “We! Ima deka-deka ia dei.” Ara reu deka Yusuf. Ma ana olaꞌ seluꞌ nae, “Au ia Yusuf, fo maꞌahulu na hei seo neu atahori Masir ra. ");
INSERT INTO row_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Hei memaꞌ seo hendi au ena. Te afiꞌ mimitau, ma afiꞌ mireresi esa fee salaꞌ neu esa fai. Matetu na, Lamatualain mana no au ia uma uꞌuhuluꞌ mia hei e. Onaꞌ naa, Ana fee masodꞌaꞌ neu atahori naeꞌ huu au. Fo ara afiꞌ mate ndoes. ");
INSERT INTO row_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Ndoe-laꞌas feꞌe laoꞌ too rua ia. Feꞌe hela too lima fai. Atahori nda aꞌali rae sa, nda sela nggari sa, de nda hambu mbule-bꞌoaꞌ saa saꞌ boe. ");
INSERT INTO row_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","No dalaꞌ fo hita nda tahineꞌ sa ia, Lamatualain no au uꞌuhuluꞌ hei. Naa fo hambu ruma mia hei ma umbu-ana mara, rasodꞌa. ");
INSERT INTO row_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Matetu na, nda hei tatao ma de au sia ia sa, te Lamatualain tatao Na. Naa de au dadꞌi fetor sia Masir ia. De au dadꞌi malangga mana tao ues sia maneꞌ a ume panggat na. Nda hambu atahori lenaꞌ au sa. ");
INSERT INTO row_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","De ia naa, hei baliꞌ lai-lai leo, fo mifadꞌe au oꞌola ngga ia neu amaꞌ mae, ‘Amaꞌ ana na Yusuf feꞌe masodꞌaꞌ. Ana dadꞌi atahori malangga sia Masir. Ana noꞌe amaꞌ Masir neu lai-lai. ");
INSERT INTO row_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Dei fo amaꞌ leo sia Masir sia mamana esa naran Gosen, deka no e. Mamanaꞌ naa maloleꞌ ma loaꞌ. De amaꞌ bisa naꞌaboi bibꞌi lombo mara sia naa, ma basa hiek no sapi ra. Ana o noꞌe fo amaꞌ muu mo umbu-ana mara, ume isi mara, no basa hata-heto mara fo leo siaꞌ a naa. ");
INSERT INTO row_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Mete ma amaꞌ sia Gosen, naa, ana naꞌaboi amaꞌ sia naa. Ndoe-laꞌas feꞌe too lima fai. Dei fo ana tao fo amaꞌ no bobꞌonggiꞌ mara, basa banda ra nda kuran saa saꞌ boe.’” ");
INSERT INTO row_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Yusuf nafadꞌe basa boe, ana olaꞌ fai nae, “Ia naa, hei mita ena, to? Ma ho, Benyamin, mita, to? Au ia, memaꞌ Yusuf. ");
INSERT INTO row_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","De mifadꞌe hita ama na mae, au koasa ngga monaeꞌ sia Masir. Boe ma dui basa-bꞌasa saa fo hei mitaꞌ ia neu amaꞌ. Basa fo, mo amaꞌ lai-lai ia nema leo!” ");
INSERT INTO row_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Basa boe ma, ana holu odꞌi na Benyamin, de rua se nggae. ");
INSERT INTO row_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ana o holu odꞌi-aꞌa nara, de idꞌu se esa-esaꞌ. Dei de, ara feꞌe ola-olaꞌ ro e. ");
INSERT INTO row_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Basa naa ma, maneꞌ a no basa pagau nara rena Yusuf odꞌi-aꞌa nara rema, de basa se ramahoꞌo. ");
INSERT INTO row_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","De maneꞌ a olaꞌ no Yusuf nae, “Yusuf, e! Mufadꞌe odꞌi-aꞌa mara fo ara fua are nara reu keledei leo, fo rendi Kanaꞌan neu. ");
INSERT INTO row_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Denu se rema ro ama ma, no basa bobꞌonggi nara, fo ara lali ia rema leo. Dei fo fee se rae meulauꞌ sia Masir, fo ara rasodꞌa sia naa, ma raa rae minan. ");
INSERT INTO row_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Boe ma nafadꞌe se, fo rendi memaꞌ kareta hira mia ia, fo fua neu anadikiꞌ ra ro ama ma. ");
INSERT INTO row_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Afiꞌ duꞌa mendi basa hata-hetoꞌ ra, te basa maloleꞌ mana sia Masir ia, dei fo sira hambu se.” ");
INSERT INTO row_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Maneꞌ a olaꞌ basa ma, Yusuf fee se kareta hira ma lepa-ngges, tungga maneꞌ a parenda na. De odꞌi-aꞌa nara raꞌalilinuꞌ fo baliꞌ tungga maneꞌ a parenda na. ");
INSERT INTO row_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Yusuf o fee se, bua-baꞌus feuꞌ pasan beꞌe esaꞌ. Te ana fee Benyamin doi fulaꞌ natun telu, ma bua feuꞌ pasan lima. ");
INSERT INTO row_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ana haitua fee ama na sudꞌi a saa meulauꞌ mia Masir, de fua neu kaledei mone sanahulu. Ana o fee seluꞌ, are, roti, ma nanaat mataꞌ-mataꞌ, sia keledei ine sanahulu fai, fo dadꞌi lepa-ngges baliꞌ Masir rema. ");
INSERT INTO row_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Basa ma, ana fee se baliꞌ, ma nafadꞌe se nae, “Hei afiꞌ mireresi sia dalaꞌ e!” ");
INSERT INTO row_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Boe ma ara lao baliꞌ risiꞌ ama na sia Kanaꞌan. ");
INSERT INTO row_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Losa naa ma, rafadꞌe ama na rae, “Amaꞌ e! Ana ma Yusuf feꞌe masodꞌaꞌ. Ana dadꞌi atahori monaeꞌ, de parenda sia Masir!” Yakob rena ma, ana titindindi, de nda namahere oꞌola nara sa. ");
INSERT INTO row_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Te ara rafadꞌe basa Yusuf oꞌola na ma, Yakob nita kareta fo Yusuf haitua nema nae fua no e nisiꞌ Masir, dei de feꞌe namahere na. ");
INSERT INTO row_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Ana olaꞌ nae, “Awi! Au ana ngga feꞌe masodꞌaꞌ o! Taꞌo naa dei de au feꞌe umuhoꞌo na. Au musi uu seꞌu-ita dei, dei fo au feꞌe mate no maloleꞌ.” ");
INSERT INTO row_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Basa naa ma, Yakob naꞌalilinuꞌ sudꞌiꞌ a saa nara, de lao hela Kanaꞌan. Losa kambo Berseba, ana hala banda tao tutunu-hohotuꞌ fee Lamatualain, fo mia dalahulu na aman Isak namahereꞌ a. ");
INSERT INTO row_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Tetembaꞌ sa, nalamein. Sia meit naa, ana rena Lamatualain noꞌe nae, “Wei! Yakob! Yakob! Fela fo rena dei!” Boe ma ana nataa nae, “Taꞌo bee?” ");
INSERT INTO row_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Lamatualain nae, “Au ia, Lamatualain fo ama ma namahere mia maꞌahulu na. Afiꞌ mumutau Masir muu. Te dei fo Au tao tititi-nonosi mara dadꞌi leo monaeꞌ sia naa. ");
INSERT INTO row_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Au o nggo Masir muu boe. Ma dei fo Au o baliꞌ tititi-nonosi mara risiꞌ Kanaꞌan fai. Leleꞌ ho mate, naa, ana ma Yusuf sia bobꞌoa ma.” ");
INSERT INTO row_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","De Yakob no ana nara lao hela kambo Berseba. Ara fua e, no sao-ana nara, reu kareta fo mane Masir haituaꞌ ra. ");
INSERT INTO row_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","7","Ara rendi hata-heto nara, ma basa banda mana dadꞌi sira ena na mia Kanaꞌan. No taꞌo naa, Yakob no ana mone nara, ana feton, ma basa umbu nara ma sufe nara, lao Masir reu. ");
INSERT INTO row_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Yakob no bobꞌonggi nara mana lao Masir reu, naeni: Ruben, ana uluꞌ a, ");
INSERT INTO row_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","no ana nara Henok, Palu, Hesron, ma Karmi. ");
INSERT INTO row_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeon, no ana nara Yemuel, Yamin, Ohad, Yakin, ma Sohar. No Saul, fo Simeon ana na mia sao ina Kanaꞌan. ");
INSERT INTO row_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Lewi, no ana nara Gerson, Kehat, ma Merari. ");
INSERT INTO row_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yahuda, no ana nara Sela, Peres ma Sera. Yahuda ana feaꞌ na, Er ma Onan, mate se mia Kanaꞌan. Ana o no Peres ana nara Hesron ma Hamul. ");
INSERT INTO row_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isaskar, no ana nara Tola, Pua, Ayub, ma Simron. ");
INSERT INTO row_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sebulon, no ana nara Sered, Elon, ma Yahleel. ");
INSERT INTO row_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Basa se, Yakob no Lea ana nara. Ara bꞌonggi se mia Mesopotamia. Ara o ma ana inaꞌ esa, nara na Dina. Dadꞌi Yakob no Lea tititi-nonosi nara, basa se atahori telu nulu telu. ");
INSERT INTO row_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Boe ma, Yakob ana nara mia sao esa fai, naeni: Gad no ana nara Sifion, Hagi, Suni, Esbon, Eri, Arodi, ma Areli. ");
INSERT INTO row_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aser, no ana nara Yimna, Yiswa, Yiswi, Beria, no feto na, naran Sera. Ma Beria ana nara Heber no Malkiel. ");
INSERT INTO row_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Basa se, atahori sanahulu nee. Sira, Yakob no sao na Silpa umbu-ana nara. Silpa naa, ate fo Labꞌan fee neu anan Lea, Yakob sao ulu na. ");
INSERT INTO row_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Boe ma, hambu Yakob sao feaꞌ na fai, naran Rahel. Ana bꞌonggi anaꞌ rua, nara nara Yusuf no Benyamin. ");
INSERT INTO row_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Leleꞌ naa, Yusuf sao nala Asnat mia Masir. Ama ari na, malangga agama sia kamboꞌ On, naran Potifera. Yusuf no Asnat ana nara, Efraim no Manase. ");
INSERT INTO row_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benyamin o tungga Masir neu no ana nara Bela, Beker, Asibel, Gera, Naaman, Ehi, Ros, Mupim, Hupim, ma Ared. ");
INSERT INTO row_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","De Yakob no sao na Rahel tititi-nonosi na, atahori sanahulu haa. ");
INSERT INTO row_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Yakob sao na feꞌe esa fai, naran Bilha. Ana nara, Dan no Naftali. Dan o tungga Masir neu no ana na Husim. ");
INSERT INTO row_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Ma Naftali no ana nara Yasel, Guni, Yeser ma Silem. ");
INSERT INTO row_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Yakob no Bilha tititi-nonosi na, atahori hitu. Bilha naa, Rahel ate na fo ana hambu ma ama na Labꞌan. ");
INSERT INTO row_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Dadꞌi Yakob tititi-nonosi nara fo mana risiꞌ Masir reu a, atahori nee nulu nee. Nda feꞌe ana mone-ana feto feu nara sa. ");
INSERT INTO row_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Tamba Yusuf no ana na rua fo bꞌonggi se sia Masir, de reken naa Yakob no basa bobꞌonggi nara mana leo sia Masir, atahori hitu nulu. ");
INSERT INTO row_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Ara rae deka Masir ma, Yakob denu ana na Yahuda laoꞌ naꞌahuluꞌ, neu noꞌe Yusuf, nema nandaa no e sia Gosen. Ara losa Gosen boe ma, ");
INSERT INTO row_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yusuf sae kareta na, de neu nandaa no aman sia naa. Ara randaa ma, Yusuf holu aman, de nggae doo na seli. ");
INSERT INTO row_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Yakob olaꞌ no Yusuf nae, “Ana Yusuf e! Ia naa, au ita nggo ena. Ma bubꞌuluꞌ ho feꞌe masodꞌaꞌ. Naa de, mae au mate oras ia o, malole.” ");
INSERT INTO row_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Basa de, Yusuf nafadꞌe basa odꞌi-aꞌa nara nae, “Au musi uu ufadꞌe maneꞌ a, ae bobꞌonggi nggara rema mia Kanaꞌan. ");
INSERT INTO row_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Dei fo au ufadꞌe ae hei ia, atahori mana maꞌaboi bibꞌi lombo ma sapi. Naa de hei mendi banda ma hata-hetoꞌ mara mia Kanaꞌan. ");
INSERT INTO row_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Mete ma maneꞌ a noꞌe hei, ma natane ue-tatao mara saa, ");
INSERT INTO row_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","na mitaa mae, basa hai mana miꞌiboi banda mia anadikiꞌ ima, onaꞌ hei bei-baꞌi mara boe. No naa, dei fo ana fee hei leo sia Gosen.” Yusuf nafadꞌe taꞌo naa, huu atahori Masir ra melumudꞌu, leo raꞌabꞌue ro atahori manatadꞌa ra. ");
INSERT INTO row_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","2","Basa ma, Yusuf no toronoo nara lima reu risiꞌ maneꞌ a. Ana nafadꞌe nae, “Ama maneꞌ! Au ama ngga no odꞌi-aꞌa nggara rema mia Kanaꞌan ena. Ara rema rendi banda hiek-lombo, sapi, ma sudꞌiꞌ a saa nara. Basa se sia Gosen ena.” ");
INSERT INTO row_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Boe ma maneꞌ a natane nae, “Hei ue-tatao ma saa?” Rataa rae, “Hai manatadꞌa onaꞌ hai bei-baꞌi mara. ");
INSERT INTO row_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Aleꞌ ia, sia rae Kanaꞌan ndoe-laꞌas naseliꞌ de nda hambu nanaat ma uru sa ena. Naa de, hai ima sia nusaꞌ ia fo leo miꞌitataaꞌ. Hai o mendi banda mara boe. De hai mae moꞌe ama maneꞌ, fo leo sia Gosen, fo miꞌiboi banda ra sia naa.” ");
INSERT INTO row_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Boe ma maneꞌ a nafadꞌe hihii-nanau na neu Yusuf nae, “Ia naa, ama ma no odꞌi-aꞌa mara sia ia ena. ");
INSERT INTO row_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","De ara bole tao nusaꞌ ia onaꞌ sira nusa na. Au uhine ngga, Gosen naa, mamana maloleꞌ sia nusaꞌ ia. De malole lenaꞌ ara leo siaꞌ a naa leo. Ma mete ma sira rahine tao-mataꞌ neu banda no maloleꞌ, naa, onaꞌ bee na ara tao-mataꞌ neu banda nggara sia naa boe.” ");
INSERT INTO row_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Basa naa ma, Yusuf natudꞌu ama na neu maneꞌ a. De Yakob hule-oꞌe neu Lamatualain, noꞌe papala-babꞌanggiꞌ fee maneꞌ a. ");
INSERT INTO row_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Basa naa ma, maneꞌ a natane e nae, “Amaꞌ too hira ena?” ");
INSERT INTO row_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakob nataa nae, “Au usodꞌa too natun esa telu nulu ena, te au nda leo sia mamanaꞌ esaꞌ a sa. Au bei-baꞌi nggara o onaꞌ naa boe. Te au too ngga memaꞌ eꞌekuꞌ lenaꞌ se. Ma sofeꞌ no doidꞌosoꞌ.” ");
INSERT INTO row_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Basa de Yakob natea maneꞌ a. Ana nda feꞌe lao sa, te ana noꞌe Lamatualain fee papala-babꞌanggiꞌ neu maneꞌ a fai. ");
INSERT INTO row_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Yusuf tungga maneꞌ a oꞌola na, de natudꞌu mamanaꞌ fee se sia Gosen. Mamanaꞌ naa maloleꞌ. (Dei de ara babꞌae mamanaꞌ naa ‘Rameses’.) Basa de Yusuf ama na no odi-aꞌa nara leo rakandoo sia naa. ");
INSERT INTO row_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yusuf o banggi-bꞌae nanaat fee ama na, odi-aꞌa nara, ro basa sao-ana nara, tungga sira ume isi nara dedꞌesi nara. ");
INSERT INTO row_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Leleꞌ naa, ndoe-laꞌas manaseliꞌ, de sia bee-bꞌee nanaat nese. Mia Masir losa Kanaꞌan atahori ra masaloe ena. Ara nda tao rala saa-saa saꞌ boe, huu ndoe ritaꞌ a mamate nara. ");
INSERT INTO row_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Naa de, atahori mia basa mamanaꞌ sia Masir no Kanaꞌan, rema hasa nanaat sia Yusuf. Ana naduru doiꞌ ra, de neu mbedꞌa sia maneꞌ a ume na. ");
INSERT INTO row_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Dꞌoo-dꞌoo ma, atahori Masir ro Kanaꞌan ra doi nara basa se ena. De ara nda hasa rala nanaat sa ena. Ara risiꞌ Yusuf, ma roꞌe rae, “Ama fetor e! Fee hai nanaat dei, fo hai afiꞌ mate ndoes. Te basa hai doi mara ena.” ");
INSERT INTO row_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yusuf nataa nae, “Mete ma memaꞌ hei doiꞌ nese ena, naa, taꞌo ia: fee banda mara fo nggati no nanaat.” ");
INSERT INTO row_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","De ara fee banda nara reu Yusuf, fo nggati no nanaat. Ara fee ndara, hiek-lombo, sapi no keledei nara. No taꞌo naa, ara rasodꞌa tooꞌ naa, huu Yusuf tao taꞌo naa. ");
INSERT INTO row_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Manafali ma, ara rema risiꞌ Yusuf rae, “Ama fetor e! Hai olaꞌ no matetuꞌ. Hai doi ma no banda mara, amaꞌ nggati mala basa se ena. Nda afiꞌ hela saa saꞌ boe. Helaꞌ a hai ao ma no rae ma. ");
INSERT INTO row_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Dadꞌi afiꞌ hela hai mate. Mete ma hai mate, seka mana tao mataꞌ neu rae ra? Malole lenaꞌ, ama fetor haꞌi mala hai dadꞌi ate. Haꞌi mala hai rae ma dadꞌi amaꞌ ena na boe. Ma fee fini-ngges fo hai sela fee amaꞌ. Hai bebengge ma, no rae a, amaꞌ nggati no nanaat. Sadꞌi hai afiꞌ mate!” ");
INSERT INTO row_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Huu ndoe-laꞌas boe fua, naa de basa atahori Masir ra seo hendiꞌ rae nara. De Yusuf hasa nala basa rae sia Masir, dadꞌi maneꞌ a enan. ");
INSERT INTO row_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Naa de, basa rauinggu Masir ra dadꞌi maneꞌ a ate na. ");
INSERT INTO row_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Te mia basa e, Yusuf nda hasa malangga agama ra rae na sa, huu maneꞌ a fee se nanaat nakandooꞌ a. Naa de, ara nda parlu seo rae nara sa. ");
INSERT INTO row_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Leleꞌ naa, Yusuf olaꞌ no manggaraun nara nae, “Ia naa hei dadꞌi maneꞌ a ate na. Basa hei rae ma, au hasa ala fee maneꞌ a ena. De mala fini-ngges ia ra, fo mii sela neu rae ra leo. ");
INSERT INTO row_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Dei fo oru naa, banggi neu lima. Babanggiꞌ esa mendi fee neu maneꞌ a. Hela babanggiꞌ haa, hei tao neu fini, ma mo ume isi mara mia.” ");
INSERT INTO row_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ara rataa rae, “Amaꞌ fee masodꞌaꞌ nema hai. Huu naa, hai moꞌe makasi. Hai mae dadꞌi maneꞌ a ate nara.” ");
INSERT INTO row_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Yusuf tao hohoro-lalaneꞌ naa dadꞌi adat sia Masir. Mia basa are fo manggaraun ra oru, ara banggi neu lima. Babanggiꞌ esa fee neu maneꞌ a. Ma babanggiꞌ haa, ara soa. Akaꞌ a malangga agama ra rae nara, maneꞌ a nda hasa sa. Adat naa, feꞌe sia losa faiꞌ ia. ");
INSERT INTO row_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Eniꞌ a leleꞌ naa, atahori Israꞌel ra leo rakandoo sia Masir, sia rae Gosen. Ara ramasuꞌi, ma tititi-nonosi nara boe ramaheta. ");
INSERT INTO row_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakob feꞌe nasodꞌa too sanahulu hitu fai sia Masir. De ana too natun esa haa nulu hitu. ");
INSERT INTO row_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Fai mamate na deka-deka boe, ana noꞌe Yusuf de nafadꞌe nae, “Ana Usu e! Au duꞌa-duꞌa na nda doo sa ena, Lamatualain noꞌe baliꞌ au. Dadꞌi au oꞌe, mete ma sue au, naa, teꞌa fo afiꞌ muꞌoi au sia rae Masir ia. ");
INSERT INTO row_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Musi mendi baliꞌ au ao sisi ngga, nisiꞌ bei-baꞌi tara mamana na. Muꞌoi au sia naa, huu naa, au hiihii ngga.” Yusuf nataa nae, “Malole, amaꞌ! Mete ma amaꞌ nau taꞌo naa, naa, au tunggaꞌ a.” ");
INSERT INTO row_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yakob olaꞌ seluꞌ nae, “Te, mete ma taꞌo naa, naa, oras ia ho teꞌa dei, mae ho tungga amaꞌ hihiin.” De Yusuf teꞌa tungga Yakob oꞌola na. Basa naa ma, Yakob sendeꞌ lululangga na neu koi ata de hule-oꞌe noꞌe makasi neu Lamatualain. ");
INSERT INTO row_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Nda dooꞌ sa ma, atahori rema rafadꞌe Yusuf rae ama na namahedꞌi. De no ana nara ruꞌa se, Manase ma Efraim, reu seꞌu baꞌi Yakob na. ");
INSERT INTO row_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Yakob rena Yusuf se rema ma, ana naꞌamamateꞌ ao na endoꞌ sia koi. ");
INSERT INTO row_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Ana nafadꞌe Yusuf nae, “Ana Usu e! Lamatualain koasa manaseli na, natudꞌu Ao na nema au mia kambo Lus sia rae Kanaꞌan. Sia naa, Ana helu au, ");
INSERT INTO row_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","nae, ‘Dei fo au fee umbu-ana mara ramaheta, fo tititi-nonosi mara dadꞌi leo monaeꞌ. Ma nusaꞌ ia, Au fee neu tititi-nonosi mara, fo dadꞌi sira hata-heto na losa nduꞌu-dꞌoo na neu.’ ");
INSERT INTO row_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","De ia naa, ana ma Efraim no Manase, hak nara taꞌo ia: au uma sia Masir ia, ruꞌa se au umbu nggara. Mae onaꞌ naa o, ia naa, au tao se dadꞌi ana nggara, onaꞌ a Ruben ma Simeon. ");
INSERT INTO row_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Te mete ma ho hambu anaꞌ fai, naa ho ana mara. Au nda tao se onaꞌ au ana nggara sa. De ara simbo hata-hetoꞌ mia aꞌa nara Manase no Efraim. ");
INSERT INTO row_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Au tao taꞌo naa, fo musunedꞌa ina ma Rahel. Leleꞌ hai baliꞌ mia Mesopotamia misiꞌ Kanaꞌan, ina ma bꞌonggi de mate mia dalaꞌ taladꞌa na deka kambo Efrata sia rae Kanaꞌan. Leleꞌ naa, au susa ala seli. De au uꞌoi e sia dalaꞌ suu na nae nisiꞌ kambo Efrata.” (Kamboꞌ naa aleꞌ ia, ara babꞌae e, Betlehem.) ");
INSERT INTO row_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Yakob olaꞌ basa ma, ana botiꞌ mata na, nita Yusuf ana nara sia naa. Natane Yusuf nae, “We! Seka ana nara ia ra?” ");
INSERT INTO row_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yusuf nataa nae, “Anaꞌ ia ra, Lamatualain fee au sia Masir ia.” Yakob olaꞌ nae, “Mete ma taꞌo naa, naa mo se deka ro au, fo au hule-oꞌe Lamatualain fee papala-babꞌanggiꞌ neu se.” ");
INSERT INTO row_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Yakob lasiꞌ ena, de mata nara poke ena. Naa de ana nda nita malole sa. Yusuf no ana nara, deka ro Yakob, de ana holu ma idu se. ");
INSERT INTO row_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ana olaꞌ no Yusuf nae, “Dꞌoo basa ia, au duꞌa na, nda undaa o nggo sa ena. Te ia naa, Lamatualain tao lenaꞌ naa fai, sambe au o feꞌe ita ana mara.” ");
INSERT INTO row_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Basa naa ma, Yusuf naꞌadꞌodꞌooꞌ ana nara mia Yakob, de sendeꞌ lululangga na ma beꞌutee losa rae, mia ama na matan. ");
INSERT INTO row_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Basa boe ma Yusuf fela. Noꞌe nala ana nara de fee se rambariiꞌ deka ro aman. Ana ulu na, Manase, neu Yakob bobꞌoa onan, ma ana ka rua na, Efraim, neu Yakob bobꞌoa diin. ");
INSERT INTO row_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Yakob loo lima na fo hule-oꞌe fee se, te ana lali lima ona na neu Efraim langga na, ma lima dii na neu Manase langga na. ");
INSERT INTO row_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ana hule-oꞌe noꞌe Lamatualain pala-banggi fee Yusuf nae, “Ho baꞌi Isak ma no ama na Abraham, ruꞌa se tungga Lamatualain hiihii-nanau na. Lamatualain o naꞌaboi au mia feꞌe soru ngga losa oras ia. ");
INSERT INTO row_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Ana mboꞌi au mia basa deꞌulakaꞌ ra. De au o oꞌe fo Ana pala banggi fee anaꞌ ia ra ro tititi-nonosi nara. Boe ma, mete ma ara hule-oe neu Lamatualain, ara afiꞌ liliiꞌ ingga baꞌi Abraham, baꞌi Isak, ma au nara ngga. Fo tititi-nonosi nara boe ramaheta, dadꞌi leo monaeꞌ sia raefafoꞌ ia.” ");
INSERT INTO row_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yusuf nita aman tao lima ona na neu Efraim langga na, de ana toꞌu aman lima na, ma lali nisiꞌ Manase langga na. ");
INSERT INTO row_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Nafadꞌe ama na nae, “Amaꞌ e! Afiꞌ tao taꞌo naa. Te Efraim odꞌiꞌ. Eni nda ana uluꞌ sa. Amaꞌ musi tao lima ona ma sia Manase langga na ata. Huu naa, ana uluꞌ a hak na.” ");
INSERT INTO row_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Te ama na Yakob nda nau sa. Olaꞌ nae, “Ana ngge. Au memaꞌ uhine. Te dei fo Manase dadꞌi manaseliꞌ, ma tititi-nonosi nara o ramaheta losa dadꞌi leo monaeꞌ. Te odꞌi na Efraim, dei fo lenaꞌ e fai. Tititi-nonosi nara, nae na seli losa ara dadꞌi leo hetar manaseliꞌ fai.” ");
INSERT INTO row_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","De ana nafadꞌe ana karuꞌaꞌ ra nae, “Dei fo mete ma atahori Israꞌel roꞌe Lamatualain pala banggi fee atahori, ara ingga hei ruꞌa nggi nara mara boe. Ara roꞌe rae, ‘Hule-huleꞌ a Lamatualain pala banggi fee nggo, onaꞌ a Ana fee Efraim no Manase.’” No taꞌo naa, Yakob ingga Efraim naran naꞌahuluꞌ aꞌan Manase naran. ");
INSERT INTO row_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Boe ma Yakob nafadꞌe Yusuf nae, “Ana ngge! Nda dooꞌ sa, te au mate. Te dei fo Lamatualain tulu-fali hei, ma no baliꞌ hei misiꞌ bei-baꞌiꞌ mara nusa na. ");
INSERT INTO row_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Te ia naa, au fee nggo lenaꞌ odꞌi-aꞌa mara. Au fee seluꞌ nggo mbukuꞌ sia rae Kanaꞌan fo dalahulu na au haꞌi mia atahori Amori leleꞌ utati o se.” ");
INSERT INTO row_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Basa naa ma, Yakob denu roꞌe basa ana nara. Ara rema ma, nafadꞌe nae, “Ana nggare! Ima miꞌibꞌue deka mo au dei. Au ae ufadꞌe hei esa-esaꞌ dala masodꞌa na sia fai maꞌabui na.” ");
INSERT INTO row_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Basa ma Yakob nafadꞌe memaꞌ ana nara nae, “Taꞌo ia! Yakob ana nara! Ima, mimbiriiꞌ rereoꞌ au. Rena ama ma Israꞌel oꞌolaꞌ na. ");
INSERT INTO row_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben! Ho ia, au ana ulu ngga! Au teteas ngga, ma lima ona ngga. Atahori fee hadat lenaꞌ neu nggo. ");
INSERT INTO row_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Te rala ma nda matetuꞌ sa, nda mitaꞌ mae hihii-nanau ma bee sa boe, onaꞌ tasiꞌ ree na neu-nema. Aiboiꞌ ma, muu sungguꞌ mo sao ngga Bilha, de munggenggeo ama ma koi na. Naa de, ho panggat aꞌa ma mopo e. ");
INSERT INTO row_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon ma Lewi! Hei ruꞌa nggi ona esaꞌ, huu ama akaꞌ mae mitati, tao miꞌisususaꞌ atahori. ");
INSERT INTO row_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Hei maꞌahe tati miꞌetuꞌ sapi ra ei ua nara, fo ara sorereo reuꞌ a mamana nara. Hei deꞌulaka mara fai, hei miminasa seli ma henggu nisi mara, losa misa atahori ra. Naa de, au nda nau rena hei oꞌola mara sa. Au o nda nau sambor o hei dedꞌea ma sa. ");
INSERT INTO row_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","De ia naa, au sumba-ndoo nasaborii mara, huu naseliꞌ ena. Ma nasa mara nda miꞌena sue-laiꞌ mbei sa boe. Dei fo mesaꞌ nggi lemba-dꞌoi deꞌulaka mara naa. Lamatualain mbia-nggari tititi-nonosi mara, fo ara leo nggari-nggari sudꞌiꞌ a bee reu sia rae Israꞌel. ");
INSERT INTO row_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yahuda! Nara ma sosoa na nae ‘koa-kio’. Dei fo odꞌi-aꞌa mara koa ma fee hadat neu nggo. Boe ma ho tuni-ndeni musu mara, losa ara nda botiꞌ rala langga nara sa. ");
INSERT INTO row_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ho onaꞌ a meoaku manaseliꞌ, sangga nanaat ao ma. Meoaku mone lea ao na fo nae sungguꞌ, ma nda hambu atahori rambarani reti ngganggu sa. Meoaku ine nanea ana na, ma nda hambu atahori rambarani reti ngganggu sa. Atahori o ramatau nggo, de nda rambarani tao mataꞌ-mataꞌ neu nggo sa. ");
INSERT INTO row_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Dei fo ho ia, toꞌu parendaꞌ. Tititi-nonosi mara boe o toꞌu parendaꞌ tungga-tungga, losa esa mana naena hak manaseliꞌ endoꞌ toꞌu parendaꞌ naa. Basa leo ra ramahere ma rena e. ");
INSERT INTO row_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Dei fo musodꞌa no nemehoꞌot. Hii saa, naa, akaꞌ a sia. Mae tao saa o, dadꞌiꞌ a. Banda mara, no osi ra mbule-bꞌoa nara o nae na seli, losa leꞌa-nggari. ");
INSERT INTO row_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Ho nana-nininu mara, maladꞌa-maladꞌaꞌ, nda basa-bꞌasa sa. ");
INSERT INTO row_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sebulon! Ho rae-oe mara loa na seli, deka noꞌ a tasiꞌ, natooꞌ no kota Sidꞌon. Ofai mia bee-bꞌee rema nggari nafuꞌ no leo nenee sia namo ma. ");
INSERT INTO row_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","15","Isaskar! Ho ia, onaꞌ banda keledei maꞌadereꞌ, huu langga fatu ma nda nenelabꞌan sa. Mete ma keledei luꞌu sia dalaꞌ taladꞌa na, esa o nda bisa nafefelaꞌ e sa, fo laoꞌ nakandoo fai. Mete ma keledei nita kambo maloleꞌ sia seriꞌ na, naa, nda denu sa o, lemba nala neꞌefufuan fo lao neuꞌ ena. Ho, onaꞌ naa boe. ");
INSERT INTO row_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan! Nara ma sosoa na ‘mana nggero’. Ho ia, mo tititi-nonosi mara, dei fo miꞌetuꞌ Israꞌel ra dedꞌea nda misilaꞌe esa saꞌ boe. ");
INSERT INTO row_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Ho ia onaꞌ mengge mana sungguꞌ sia dalaꞌ suu na. Mete ma atahori sae ndara tungga naa, aiboiꞌ na, mengge a ero ndara ei na, de atahori naa tudꞌa. Ho o muꞌutetee hahambuꞌ, naa mata muu. ");
INSERT INTO row_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","LAMATUALAIN! Au hule-huleꞌ fo fee masodꞌaꞌ neu basa hai. ");
INSERT INTO row_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad! Nara ma lii na naeꞌ a onaꞌ a ‘netati’. Dei fo mana rambok ra ratati ro nggo, te mutati musenggiꞌ se. ");
INSERT INTO row_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aser! Dei fo osi mara mbule-bꞌoa nara malole na seli. Losa ho bisa tao kokis mataꞌ-mataꞌ, fo maneꞌ ra rema hasa sia nggo. ");
INSERT INTO row_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naftali! Ho ia, onaꞌ banda rusa ine mana nela fuiꞌ, huu nda hambu atahori ralalao nggo sa. Ho o bꞌonggi mala ana mara akaꞌ a meulauꞌ ra. ");
INSERT INTO row_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yusuf! Ho onaꞌ hau huu mana malonggeꞌ nasodꞌa deka no oe mataꞌ. Ho dꞌana mara nama risiꞌ lutu naruꞌ. ");
INSERT INTO row_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Hambu atahori fua rala mera nara neu nggo, onaꞌ musu a busu nggo. ");
INSERT INTO row_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Te Lamatualain fo au umuhereꞌ a, tulu-fali nggo. Ana tao lima ma maꞌadereꞌ, fo busu labꞌan baliꞌ se. Mae mia dꞌoo-dꞌooꞌ o, ho musenggiꞌ se, huu Lamatualain tulun nggo. Koasa Na memaꞌ manaseliꞌ tebꞌe. De au umuhena E, huu Ana mana nanea au. ");
INSERT INTO row_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Dei fo Ana nanea nggo. Ana fee nggo papala-babꞌanggiꞌ mia lalai ma raefafoꞌ. Ana o fee papala-babꞌanggiꞌ fo bꞌonggi anaꞌ ao meulauꞌ hetar. ");
INSERT INTO row_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Mbuku-leteꞌ ra nda mopo sa. Ma au papala-babꞌanggi ngga ia, naeꞌ lenaꞌ basa papala-babꞌanggi mia mbuku-leteꞌ ra! Basa papala-babꞌanggiꞌ ia ra, mbori-mboꞌa neu nggo, huu ho manaseliꞌ lenaꞌ odꞌi-aꞌa mara. ");
INSERT INTO row_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benyamin! Mbarani ma onaꞌ busa fui mana ndoeꞌ. Feꞌe fefetuꞌ, ana neu sombu nala nanaat na ena. Te mete ma tetembaꞌ, ana neu babanggi sisa-sisa nara, fee ana nara. Tititi-nonosi mara o manaseliꞌ onaꞌ naa boe!” ");
INSERT INTO row_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","No taꞌo naa, Yakob nafadꞌe memaꞌ ana nara dala masodꞌa nara sia fai maꞌabui na, esa-esaꞌ no tititi-nonosi na. Basa se mana raꞌondaꞌ leo Israꞌel kasanahulu ruaꞌ ra. ");
INSERT INTO row_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","30","Basa boe ma, Yakob noꞌe ana nara fo helu nae, “Nda dooꞌ sa te, au mate. Mete ma au mate, naa hei musi miꞌoi au sia Baꞌi Abraham rates na. Rates naa sia luat, deka no kambo Makpela no Mamre sia rae Kanaꞌan. Maꞌahulu na, Baꞌi Abraham hasa luat naa no osi fo tao neu mamana rates. Ana hasa etu mia atahori Het, naran Efron. ");
INSERT INTO row_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Sia naa raꞌoi hita baꞌi Abraham no bei Sara, ma ama ngga Isak no ina ngga Ribka. Dadꞌi hei musi miꞌoi au sia naa, sia sao ngga Lea bobꞌoa na. ");
INSERT INTO row_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","De hei afiꞌ liliiꞌ miꞌoi au sia luat fo baꞌi Abraham hasa nalaꞌ naa.” ");
INSERT INTO row_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yakob olaꞌ basa ma, ana sungguꞌ bali neu koi, ma mate e boe. ");
INSERT INTO row_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Ama na mate ma, Yusuf holu nala e, de nggae ei-ei. Ana idꞌu ama na nasafafali. ");
INSERT INTO row_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Basa naa ma, Yusuf parenda mana tao mataꞌ mamates ra tao modꞌo neu e, fo ao sisi na afiꞌ maꞌafoo. ");
INSERT INTO row_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Basa boe ma, ara linuafi mamates a losa fai haa nulu, tungga sira hadat na. Basa atahori Masir ra o nggae Yakob mamate na losa fai hitu nulu. Onaꞌ sira atahori monaen na mate. ");
INSERT INTO row_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Basa fai kahitu nulu na boe, Yusuf nafadꞌe pagau nara nae, “Rena! Mendi haraꞌ ia, mi mifadꞌe maneꞌ a maꞌo ia: ");
INSERT INTO row_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Ama ngga nae mate ma, ana noꞌe au uꞌoi e sia rae Kanaꞌan. Dadꞌi au oꞌe maneꞌ fee au uu uꞌoi ama ngga dei. Basaꞌ fo au baliꞌ ia uma.’” ");
INSERT INTO row_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Maneꞌ a nataa nae, “Mete ma ho helu ama ma taꞌo naa ena, muu muꞌoi e sia naa leo.” ");
INSERT INTO row_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Boe ma Yusuf neu naꞌoi ama na. Atahori naeꞌ o tungga e boe. Maneꞌ a pagau nara, ma basa atahori monaeꞌ Masir ra. ");
INSERT INTO row_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Yusuf odꞌi-aꞌa nara, ro basa atahori mana tao ues nara o reu raꞌoi Yakob boe. Mana mahani sia Gosen, akaꞌ a sao nara ro anadikiꞌ ra ma banda nara. ");
INSERT INTO row_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Soldꞌadꞌu naeꞌ o tungga boe. Ruma ro kareta, ma ruma sae ndara. Huu mana tungga ra, nae na seli, naa de nononggo mana tunggaꞌ laoꞌ ro mamates a narun seli. ");
INSERT INTO row_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Basa se lao losa loe Yordan seriꞌ sia mamanaꞌ esa naran Atad. Atahori biasa poko are sia naa. Yusuf se nggae ei-ei ama na mamate na ma bebeꞌek tetembaꞌ hitu fai sia naa. ");
INSERT INTO row_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Atahori Kanaꞌan sia naa rita se susa onaꞌ naa ma, ara olaꞌ rae, “Wei! Mita dei. Atahori Masir ra beꞌe mamates nara no sususaꞌ seli o. Ara nggae mataꞌ naa.” Naa de ara babꞌae mamanaꞌ naa, Abel-Misraim. Sosoa na ‘atahori Masir sususa na’. ");
INSERT INTO row_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Basa ma, Yakob ana nara tao tungga sira helu-fuli na. ");
INSERT INTO row_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Ara rendi Yakob ao sisi na, de raꞌoi sia luat deka kambo Makpela no Mamre. Maꞌahulu na, Abraham hasa mamanaꞌ naa mia atahori Het, naran Efron, de tao dadꞌi mamana rates. ");
INSERT INTO row_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yusuf naꞌoi basa ama na ma, no odꞌi-aꞌa nara baliꞌ Masir reu. Basa atahori mana tungga reu raꞌoiꞌ ra o baliꞌ boe. ");
INSERT INTO row_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ara losa Masir boe ma, Yusuf aꞌa nara ramatau. Huu ama na nese ena, de ara ola-olaꞌ rae, “Wei! Hei duꞌa dei! Mete ma Yusuf feꞌe mbedꞌaꞌ nasat no nggita, fo nae balas hita deꞌulakaꞌ na neu e, naa taꞌo bee? ");
INSERT INTO row_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ara rala haraꞌ sa fo fee haraꞌ neu Yusuf rae: “Ama fetor. Hai feꞌe misinedꞌa leleꞌ hita ama na feꞌe masodꞌa na, ana denu hai ");
INSERT INTO row_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","mifadꞌe amaꞌ mae, ‘Usu musi fee ambon neu aꞌa nara salan. Huu maꞌahulu na ara tao deꞌulakaꞌ neu e.’ Hai o misinedꞌa hita ama na namahere neu Lamatualain mia maꞌahulu na. Naa de, hai, fo Lamatualain ate nara, ima moꞌe ambon, huu basa hai tao salaꞌ neu amaꞌ ena.” Yusuf rena taꞌo naa ma, ana nggae. ");
INSERT INTO row_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Boe ma aꞌa nara rema mata nara ma sendeꞌ lululangga nara, de olaꞌ rae, “Amaꞌ, tao hai dadꞌi ate ma.” ");
INSERT INTO row_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Yusuf nafadꞌe se nae, “Aꞌa nggare! Sudꞌi mimitau fai! Akaꞌ a Lamatualain ma hak fo huku-doki atahori. Te au ia, hokoꞌ. ");
INSERT INTO row_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Maꞌahulu na, memaꞌ hei mala haraꞌ fo tao deꞌulakaꞌ neu au. Te Lamatualain nggati hei dudꞌuꞌa deꞌulaka ma, dadꞌi maloleꞌ. Naa de, Ana soꞌu au dadꞌi atahori monaeꞌ, fo atahori naeꞌ hambu masodꞌaꞌ. ");
INSERT INTO row_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Dadꞌi ia naa, au ufadꞌe nggi fo sudꞌi mimitau fai. Au helu dei fo au mete-seꞌu nggi, mo basa ana mara.” Yusuf oꞌola na naa, tao mangatetee aꞌa nara ralan. ");
INSERT INTO row_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Basa naa ma, Yusuf leo nakandoo sia Masir no odꞌi-aꞌa nara. Ana nasodꞌa losa too natun esa sanahulu. ");
INSERT INTO row_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Ana feꞌe nita Efraim sufe nara. Ma ana o naꞌaboi Manase umbu nara, naeni Makir ana nara. ");
INSERT INTO row_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Yusuf nafadꞌe aꞌa nara nae, “Aꞌa nggare! Au duꞌa-duꞌa na, fai mamate ngga deka ena. Te au umuhere, Lamatualain naꞌaboi hei. Dei fo, Ana no nggi lao hela nusaꞌ ia, ma nalalao nggi baliꞌ misiꞌ nusaꞌ fo Ana helu-fuli fee baꞌi Abraham, baꞌi Isak no ama Yakob.” ");
INSERT INTO row_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Boe ma Yusuf noꞌe odꞌi-aꞌa nara teꞌa nae, “Hei musi teꞌa neu au. Mete ma losa fai na Lamatualain no baliꞌ nggi misiꞌ nusaꞌ naa, naa hei o mo baliꞌ ao sisi ngga.” ");
INSERT INTO row_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Yusuf too natun esa sanahulu ma, ana mate sia Masir. Boe ma ara tao modꞌo neu ao sisi na, de tao e kopa na rala neu. ");
INSERT INTO row_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","2","Susura ia dui soal Yesus Kristus, Atahori fo Lamatualain helu-fuli memaꞌ eniꞌ a maꞌahulun fo nae haitua nemaꞌ a. Eni, mane Daud no baꞌi Abraham tititi-nonosin. Reken mia baꞌi Abraham losa mane Daud, hambu bei-baꞌiꞌ sanahulu haa. Bei-baꞌiꞌ naa ra tutungga nara, taꞌo ia: Abraham anan Isak, Isak anan Yakob Yakob anan Yahuda no odꞌi-aꞌa nara, ");
INSERT INTO row_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yahuda anan Peres no Sera (sira inan, naran Tamar), Peres anan Hesron, Hesron anan Ram, ");
INSERT INTO row_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram anan Aminadab, Aminadab anan Nahason, Nahason anan Salmon, ");
INSERT INTO row_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon anan Boas (Eni inan naran Rahab), Boas anan Obet (eni inan, naran Rut), Obet anan Isai, ");
INSERT INTO row_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","11","Isai anan Daud. Mia Daud losa leleꞌ atahori Israꞌel ra nenenggariꞌ risiꞌ Babel, hambu bei-baꞌiꞌ sanahulu haa fai, naeni: Daud anan Soleman (eni inan naa, feꞌesaꞌan Uria saon). Soleman anan Rehabeam, Rehabeam anan Abia, Abia anan Asaf, Asaf anan Yosafat, Yosafat anan Yoram, Yoram anan Usia, Usia anan Yotam, Yotam anan Ahas, Ahas anan Heskia, Heskia anan Manase Manase anan Amos, Amos anan Yosias, Yosias anan Yekonya no odꞌi nara leleꞌ ara nenenggariꞌ mia Babel. ");
INSERT INTO row_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","16","Leleꞌ ara nenenggariꞌ mia Babel losa Yesus, hambu bei-baꞌiꞌ sanahulu haa fai, naeni: Yekonya anan Sealtiel, Sealtiel anan Serubabel, Serubabel anan Abihut, Abihut anan Elyakim, Elyakim anan Asor, Asor anan Sadok, Sadok anan Akim, Akim anan Eliut, Eliut anan Eliasar, Eliasar anan Matan, Matan anan Yakob, ma Yakob anan Yusuf. Yusuf ia, sao Maria. Maria mana bonggi Yesus Kristus. ");
INSERT INTO row_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Dadꞌi eniꞌ a mia Abraham losa Daud, hambu bei-baꞌiꞌ sanahulu haa; mia Daud losa ara nenenggariꞌ risiꞌ Babel hambu bei-baꞌiꞌ sanahulu haa; boe ma mia Babel losa bonggi Kristus, hambu bei-baꞌiꞌ sanahulu haa boe. ");
INSERT INTO row_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Maria bonggi Yesus naa, dudꞌuin taꞌo ia: Maria no Yusuf nenehengge-nee basaꞌ ena. Ruꞌa se nda feꞌe sungguꞌ raꞌabꞌue onaꞌ masaoꞌ ra sa, te tao-tao te Maria nairu mia Lamatualain Dula-dꞌale Meumaren ena. ");
INSERT INTO row_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Leleꞌ Yusuf nahine, boe ma ana nae noꞌe naꞌetuꞌ sira ruꞌa se neꞌebꞌue nara. Te ana nda nau tao naꞌamamaeꞌ Maria sia atahori hetar matan sa, huu ralan meumareꞌ. De ana nae naꞌetuꞌ no neeneeꞌ a. ");
INSERT INTO row_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Boe ma tetembaꞌ sa, leleꞌ ana feꞌe duꞌa neu-nema, ma nalamein. Sia meit naa, nita Lamatualain aten mia sorga nema nafadꞌe nae, “Wee, Yusuf! Ho ia, mane Daud tititi-nonosin. Afiꞌ mumutau sao mala Maria. Te anaꞌ mana sia tein rala naa, mia Lamatualain Dula-dalen. ");
INSERT INTO row_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Dei fo, Maria bonggi ana touꞌ esa. Ho musi babꞌae naran, Yesus, te dei fo Eni mana fee masoi-masodꞌaꞌ neu Lamatualain atahori nara mia sala-kilu nara.” ");
INSERT INTO row_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Dei fo dalaꞌ ia dadꞌi taꞌo naa, huu Lamatualain nafadꞌe basa eniꞌ a lele uluꞌ a. Ana pake mana ola-olan Yesaya de suraꞌ nae, ");
INSERT INTO row_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Hei rena, o! Hambu ana fetoꞌ sa feꞌe nda sao sa, te tao-tao te mairuꞌ ena. De ana bonggi Ana touꞌ sa. Ara babꞌae naran, Imanuel.” (Sia dedꞌea Ibrani, ‘Imanuel’ sosoan: Lamatualain naꞌabꞌue no nggita.) ");
INSERT INTO row_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yusuf nalamein basa, boe ma ana fela. Ma ana tungga Lamatualain hehelu-fufulin neuꞌ ena. Ana haꞌi nala Maria dadꞌi saon, ");
INSERT INTO row_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","te ana nda sungguꞌ no Maria sa losa ana bonggi. Ana bonggi basa ma, Yusuf babꞌae anaꞌ naa naran, Yesus. ");
INSERT INTO row_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Leleꞌ bonggi Yesus mia kambo Betlehem sia profinsi Yudea, mane Herodes toꞌu parendaꞌ. Leleꞌ naa, hambu atahori hira mia mamana dodꞌooꞌ sia langgan rulu rema risiꞌ kota Yerusalem. Sira, atahori mana rahine mete nduuꞌ. ");
INSERT INTO row_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Leleꞌ ara losa Yerusalem, ara ratatane reu-rema rae, “Atahori Yahudi ra manen fo feꞌe nenebꞌonggiꞌ a, sia bee, e? Hai mita nduuꞌ sa sia langgan rulu, mana fee tatandaꞌ nae, bonggi E ena. Naeni de hai ima mae beꞌutee neu E.” ");
INSERT INTO row_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Leleꞌ mane Herodes rena oꞌola nara, ma ralan liuali. Naa de basa atahori sia Yerusalem ra o ramedꞌa taꞌo naa boe. ");
INSERT INTO row_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Basa ma, mane Herodes naꞌabꞌue nala basa malangga agama Yahudi ra ro meser agama ra, de natane se nae, “Hei mifadꞌe sobꞌa au dei! Kristus fo, Lamatualain helu-fuli memaꞌ a, nenebꞌonggiꞌ sia bee, e?” ");
INSERT INTO row_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ma rataa rae, “Sia kambo Betlehem, sia profinsi Yudea, ama maneꞌ. Huu Lamatuaꞌ mana ola-olan Mika suraꞌ memaꞌ mia dalahulun taꞌo ia: ");
INSERT INTO row_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘We, hei atahori Betlehem, mana sia profinsi Yudea re. Afiꞌ duꞌa mae, hei kambom naa, kambo anaꞌ nda naꞌena sosoa-ndandaaꞌ sa. Huu dei fo hambu atahori moko-monaen sa mia naa nema. Dei fo Ana dadꞌi manatadꞌa soaꞌ neu Au atahori Israꞌel ngga ra.’” ");
INSERT INTO row_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Rena basa taꞌo naa ma, mane Herodes noꞌe nee-nee nala atahori mana mete rahine nduuꞌ ra. De natane se, sira rita nduuꞌ naa sou sia lalai a eni bees. Ma ara rafadꞌe e. ");
INSERT INTO row_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Boe ma ana denu se Betlehem reu. Nafadꞌe se nae, “Mii sangga rereoꞌ Anaꞌ naa sia naa. Mete ma hei mindaa mo E, na, baliꞌ ima mifadꞌe au. Huu au ae uu beꞌutee neu E boe. ");
INSERT INTO row_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ara rena basa maneꞌ a oꞌolan, ma ara reu boe. Tao-tao te, ara rita nduuꞌ fo dalahulun rita mia seriꞌ rulu a. Nduuꞌ a sou mia mata nara, ma ana laoꞌ de losa Anaꞌ a mamana leleon, ma naloeꞌ. ");
INSERT INTO row_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Rita taꞌo naa, ma ramahoꞌo rala seli. ");
INSERT INTO row_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Basa de ara ume rala reu, ma rita Anaꞌ a no maman Maria. De sendeꞌ lululangga nara beꞌutee neu E. Boe ma ara buka mbomboti sudꞌiꞌ a saa mafelit nara, fo fee neu Anaꞌ a. Ara fee lilo, kemenyan, no hau raa maꞌameniꞌ. ");
INSERT INTO row_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nda dooꞌ sa ma, ara hambu meit mia Lamatualain oi, “Ama afiꞌ baliꞌ misiꞌ mane Herodes fai.” Naa de ara bali risiꞌ kambo nara tungga dalaꞌ laen. ");
INSERT INTO row_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Leleꞌ atahori mana mete rahine nduuꞌ ra lao baliꞌ, boe ma Lamatualain aten esa mia sorga nema nafadꞌe neu Yusuf sia meit na, nae “Wae, Yusuf! Fela lailai! Haꞌi mala Anaꞌ naa no maman fo mela nusa Masir mi. Leo mihati naa losa faiꞌ bee fo Au ufadꞌe nggi fo ama baliꞌ na dei fo ama baliꞌ, te mane Herodes sangga nae nisa Anaꞌ naa!” ");
INSERT INTO row_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Basa ma Yusuf fela. Boe ma ana nendi saon no Anaꞌ naa tetembaꞌ, de rela nusa Masir reu. ");
INSERT INTO row_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ara leo mia naa losa Herodes mate. No taꞌo naa Lamatualain oꞌolan dadꞌi, onaꞌ mana ola-olan Hosea nafadꞌe memaꞌ eniꞌ a mia lele uluꞌ a nae, “Au oꞌe baliꞌ Ana Ngga, fo lao hela Masir.” ");
INSERT INTO row_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Leleꞌ mane Herodes nahine nae, atahori mana mete rahine nduuꞌ ra lelekoꞌ e, ma ana namanasa seli. De ana parenda soldꞌadꞌu nara nae, “Mii sia kambo Betlehem ma kambo-kambo mana deka naa ra. Tao misa basa ana diki tou anaꞌ, mana to beꞌe ruaꞌ fo rae neu.” Herodes parenda taꞌo naa, huu ana nasanedꞌa atahori mahineꞌ ra dudꞌuin. Ana reken eniꞌ a ara rita nduuꞌ a sou fefeun mia lalai a. ");
INSERT INTO row_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Basa dalaꞌ ia ra dadꞌi, tungga saa fo Lamatualain mana ola-olan Yeremia sura memaꞌ mia lele uluꞌ a nae, ");
INSERT INTO row_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Rena atahori nggae ei-ei sia kota Rama. Rahel nggae ei-ei, huu basa ana nara mate ena. Ana nda nau atahori reu kokoe e sa. huu basa ana nara nese ena.” ");
INSERT INTO row_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Dodꞌoo ma mane Herodes mate. Leleꞌ naa Yusuf se feꞌe sia Masir. Boe ma Lamatualain aten esa mia sorga, nema natudꞌu matan neu e mia meit. ");
INSERT INTO row_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ate a nafadꞌe nae, “Wae, Yusuf! Fela leo! Mo baliꞌ Anaꞌ naa no maman, Israꞌel reu. Te atahori fo mana nae tao nisa Anaꞌ naa mate ena.” ");
INSERT INTO row_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Rena taꞌo naa ma Yusuf fela. De ana no baliꞌ se nusa Israꞌel reu. ");
INSERT INTO row_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Te leleꞌ ana rena nae, mane Herodes anan Arkalaus toꞌu parendaꞌ sia profinsi Yudea, boe ma namatau baliꞌ naa neu. Basa ma Lamatualain parenda e sia meit sa fai nae, “Yusuf, afiꞌ leo sia Yudea.” Naeni de ana neu leo sia profinsi Galilea, ");
INSERT INTO row_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","sia kamboꞌ sa naran Nasaret. No taꞌo naa, Lamatualain oꞌolan, dadꞌi tebꞌe-tebꞌeꞌ ena, tungga saa fo mana ola-ola nara suraꞌ memaꞌ rae, “Dei fo ara roꞌe E rae, Atahori Nasaret.” ");
INSERT INTO row_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Leleꞌ Yesus naꞌamoko boe ma, Yohanis Mana Saraniꞌ a mulai nanori atahori ra sia mamanaꞌ naꞌadooꞌ no kamboꞌ, sia profinsi Yudea. ");
INSERT INTO row_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ana nafadꞌe nae, “Toronoo susue ngga ra e! Ama musi mitaa ma lao hela basa sala-kilu mara, fo baliꞌ misiꞌ Lamatualain leo. Te aleꞌ ia basa atahori bisa masoꞌ dadꞌi Lamatualain atahorin.” ");
INSERT INTO row_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Dalahulun Lamatualain mana ola-olan esa, naran Yesaya sura soꞌal Yohanis ena nae, “Dei fo hambu atahori nameli sia mamana mana naꞌadoo no kamboꞌ nae, ‘Basa atahori rahehere tao ralole dalaꞌ, fo soru Lamatualain neneman! Tao mitetu dalaꞌ fee neu E!” ");
INSERT INTO row_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohanis ia dala masodꞌan onaꞌ Lamatuaꞌ mana ola-ola dalahulu nara. Eni bua-baun, tao mia banda onta fulun. Bobꞌorin, tao mia banda rouꞌ a. Ma nanaa-nininun, lamat no oni lasi oeꞌ. ");
INSERT INTO row_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Leleꞌ naa atahori hetar rema rae randaa ro Yohanis. Ara rema mia Yerusalem, ma mia basa profinsi Yudea isin. Ara o rema mia kambo-kamboꞌ fo badeka ro loe Yarden. ");
INSERT INTO row_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ara buka rala nara ma rataa basa sala-kilu nara, basa ma Yohanis sarani se mia loe Yarden. ");
INSERT INTO row_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Leleꞌ naa, atahori mia partei Farisi ma partei agama Saduki ra o rema risiꞌ mamanaꞌ fo Yohanis saraniꞌ a. Te leleꞌ ana nita se ma, ana bua se nae, “heh! Ama onaꞌ mengge mana peko-lelekoꞌ! Dei fo Lamatualain huku-dꞌoki nggi huu tatao-nonoꞌi deꞌulaka mara. Wae! Afiꞌ duꞌa mae hei bisa mela mia Lamatuaꞌ huku-dꞌokin ");
INSERT INTO row_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","De malole lenaꞌ baliꞌ misiꞌ Lamatualain, ma lao hela basa sala-kilu mara. Basa na, tao dala-dala maloleꞌ ra, onaꞌ hau huuꞌ mana nabꞌoa boa maloleꞌ. ");
INSERT INTO row_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Afiꞌ duꞌa mae hei hambu masodꞌaꞌ ena huu hei, baꞌi Abraham tititi-nonosin. Mimihere au! Huu Lamatualain bisa tao fatu ra dadꞌi baꞌi Abraham tititi-nonosin. ");
INSERT INTO row_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Besa-bꞌesa e! Te hambu atahori toꞌu taꞌa fo rahehere rae ungga hendi basa hau huuꞌ nda mana rabꞌoa maloleꞌ ra sa. Ungga basa na, Ana nggari hendi se ai rala reu. ");
INSERT INTO row_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Aleꞌ ia au sarani nggi endiꞌ oe, fo dadꞌi tatandaꞌ oi, hei hiruꞌ misidꞌea hela sala-kilu mara ena. Te dei fo Atahori sa manaseliꞌ lenaꞌ au nae nema. Dadꞌi akaꞌ dedꞌenun o au nda undandaa sa. Dei fo Ana tao nasofe rala mara nendiꞌ Lamatuaꞌ Dula-dale Meumaren. Ana o tao nggi dadꞌi meumareꞌ boe, onaꞌ atahori hotu manggarauꞌ rendiꞌ ai. ");
INSERT INTO row_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Huu Ana toꞌu nala lalaꞌo esa isiꞌ sia rala, fo nae tai hendi etoꞌ mia isiꞌ ra. Basa fo Ana oni isiꞌ ra risiꞌ sokaꞌ rala reu, ma Ana nggari hendi etoꞌ ra risiꞌ ai mana mbilaꞌ nda mana basaꞌ sa. ");
INSERT INTO row_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Leleꞌ naa, Yesus onda nema mia Galilea nisiꞌ loe Yarden. Ana nema noꞌe Yohanis Sarani Eni, ");
INSERT INTO row_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","te Yohanis nda nau sa. Ana nareresi nae, “Taꞌo bee fo au musi sarani Lamatuaꞌ? Nda tabalek sa, do? Lamatuaꞌ mana musi sarani au dei. Te au parlu naa!” ");
INSERT INTO row_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Te Yesus nataa nae, “Nda saa sa boe. Hela fo oras ia, aꞌa sarani Au. No taꞌo naa hita tungga Lamatualain hihii-nanaun.” Rena naꞌo naa ma Yohanis nataa nae, “Siaꞌ a Lamatuaꞌ.” Boe ma ana sarani Yesus. ");
INSERT INTO row_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Sarani basa ma, Yesus dea nema mia loe a. Aiboiꞌ ma, lalai a sii. Ma Ana nita Lamatualain Dula-dalen onda nema neu E, onaꞌ mbui lunda tee neu E. ");
INSERT INTO row_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Boe ma ara rena Lamatualain haran mia lalai a nae, “Eni ia, Au Ana susue ngga. Ana tao namahoꞌo Rala ngga nakandooꞌ a.” ");
INSERT INTO row_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Basa ma, Lamatualain Dula-dalen no Yesus nisiꞌ mamana rouꞌ, fo nitu ra malangga monaeꞌ na sobꞌa-dꞌou E. ");
INSERT INTO row_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Boe ma Ana puasa sia naa rereloꞌ fai 40 ma tetembaꞌ fai 40. Basa boe ma, Ana ndoe nala seli. ");
INSERT INTO row_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Leleꞌ Ana ndoe nala seli ma, nitu ra malangga monae na neu sobꞌa-dꞌou E nae, “Ho ia, tebꞌe-tebꞌeꞌ Lamatualain Anan, to? Mete ma tebꞌe, na, parenda fatu ia ra dadꞌi nanaat leo.” ");
INSERT INTO row_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Te Yesus nataa nae, “Nenesuraꞌ sia Lamatualain Susura Meumaren nae: ‘Atahori nda rasodꞌa miaꞌ a nanaat sa. Te ara o musi rena Lamatualain Dedꞌea-oꞌolan, ma tao tungga Hihii-nanaun.’” ");
INSERT INTO row_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Boe ma, nitu a nendi Yesus nisiꞌ kota Yerusalem, Lamatuaꞌ kota meumaren a. Ma no Yesus hene risiꞌ Ume Hule-oꞌe Huuꞌ mamana narun. ");
INSERT INTO row_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Boe ma nitu a nae, “Mete ma memaꞌ tebꞌe-tebꞌeꞌ Lamatualain Anan, na, sobꞌa boke rae muu leo. Huu nenesuraꞌ sia Lamatualain Susura Meumaren oi, ‘Dei fo Lamatualain parenda aten mia sorga ra, fo ranea nggo.’ Sia Lamatualain Susura Meumaren nenesuraꞌ oi, ‘Dei fo ara ratanee nggo rendiꞌ lima nara, naa fo eim nda naꞌatunu dai fatu sa boe.’” ");
INSERT INTO row_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Te Yesus nataa nae, “Nenesuraꞌ sia Lamatualain Susura Meumaren boe oi, ‘Lamatualain naa, Lamatuam. Naeni de afiꞌ sobꞌa-dou E.’” ");
INSERT INTO row_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Boe ma nitu a no Yesus nisiꞌ lete naruꞌ sa ata. De natudꞌu basa nusaꞌ ra sia raefafoꞌ ia, ro basa manaseli nara. ");
INSERT INTO row_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Natudꞌu basa naa ra ma, nitu a nafadꞌe nae, “Sadꞌi sendeꞌ lululangga ma neu au, dei fo au fee basa-bꞌasa ia ra reu Nggo.” ");
INSERT INTO row_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Te Yesus olaꞌ mbali e nae, “Hee, nitu! Dinggoꞌ hela mamanaꞌ ia! Te Lamatualain Susura Meumaren nae, ‘Ho musi beꞌutee neu Lamatualain, Ma musi tao-ues fee neu E.’” ");
INSERT INTO row_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Rena taꞌo naa ma, nitu a lao hela Yesus. Te Lamatualain aten mia sorga ra reu tao mataꞌ neu E. ");
INSERT INTO row_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Leleꞌ naa, mane Herodes tao Yohanis mana saraniꞌ a bui rala neu. Leleꞌ Yesus rena nala, boe ma Ana lao baliꞌ Galilea neu. ");
INSERT INTO row_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ana neu sia kambon Nasaret, boe ma lao nakandoo de leo sia kambo Kapernaum. Kamboꞌ naa sia dano Galilea suun, sia Sebulon no Naftali raen. ");
INSERT INTO row_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","No taꞌo naa, Ana tao tungga saa fo Lamatualain mana ola-olan Yesaya suraꞌ memaꞌ ena nae, ");
INSERT INTO row_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sebulon no Naftali raen mana deka sia dano Galilea, sia loe Yarden bobꞌoan. Atahori nda Yahudi ra sa leo sia naa. ");
INSERT INTO row_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Masodꞌa nara sia maꞌahatuꞌ a te ia na ara sia Manggareloꞌ a ena. Huu Manggareloꞌ a naronda neu basa atahori nda mana feꞌe rahine Lamatualain sa. ");
INSERT INTO row_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Eniꞌ a leleꞌ naa, boe ma Yesus nanori atahori nae, “Ama musi misidea ma lao hela sala-kilu mara, fo misodꞌa no meumareꞌ leo! Huu ia na basa atahori bisa dadꞌi Lamatualain atahorin ena.” ");
INSERT INTO row_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Faiꞌ sa, Yesus laoꞌ tungga dano Galilea suun. Ana nandaa no atahori rua odꞌi-aꞌaꞌ. Esa naran Simon, te atahori roꞌe na rae, Petrus. No odꞌin naran Anderias. Ara dala uꞌu mia dano, huu ruꞌa se mana tasi ra. ");
INSERT INTO row_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Boe ma Yesus noꞌe se nae, “Wae, ima tungga Au leo! Hei mana dolu uꞌu, te ia na Au ae unori nggi, fo ama dadꞌi mana sangga ao samanaꞌ.” ");
INSERT INTO row_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Rena basa ma, ruꞌa se lao hela dala nara, de tungga Yesus neuꞌ ena. ");
INSERT INTO row_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Basa ma, Yesus lao nakandoo mbei fai, boe ma nita Sabadeus ana nara. Aꞌa ka naran Yakobis, no odꞌin naran Yohanis. Ruꞌa se ralolole puꞌa nara sia ofaꞌ rala ro sira aman. Boe ma Yesus noꞌe ruꞌa se fo tungga E. ");
INSERT INTO row_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ara rena rala ma, lao hela sira aman no ofaꞌ a, de tungga Yesus neuꞌ ena. ");
INSERT INTO row_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Boe ma, Yesus se lao-laoꞌ ndule profinsi Galilea, fo ranori sia atahori Yahudi ra ume hule-oꞌe nara. Nanori Lamatualain Hara-lii Malolen, boe ma nafadꞌe tao taꞌo bee fo atahori nau tungga Lamatualain parendan. Boe ma Ana o naꞌahahaiꞌ basa atahori mia hedꞌis mataꞌ-mataꞌ. ");
INSERT INTO row_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nda doo sa ma, haraꞌ soꞌal Yesus tataon naa, nenedꞌui-bꞌenggaꞌ ndule basa profinsi Siria. Basa ma, atahori rendi atahori mamahedꞌiꞌ mataꞌ-mataꞌ reu E. Ara o rendi atahori nitu taoꞌ ra, mulu bibꞌiꞌ, ma mana mamaluꞌuꞌ ra. De Ana naꞌahahaiꞌ basa se. ");
INSERT INTO row_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Leleꞌ naa, atahori hetar rema tungga E. Ara rema mia profinsi Galilea, ma mia rae Kota Sanahulu, fo ara roꞌe rae, Dekapolis. Ruma fai rema mia kota Yerusalem, mia profinsi Yudea, ma mia loe Yarden bobꞌoan. ");
INSERT INTO row_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Leleꞌ Yesus nita atahori hetar rema tungga E, ma Ana hene nisiꞌ lete anaꞌ sa, de endoꞌ neu naa. Ana mana tungga nara fo tengga nalaꞌ ra, rema deka-deka fo rena E. ");
INSERT INTO row_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Boe ma Ana mulai nanori se nae, ");
INSERT INTO row_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Atahori mana tudꞌa-loloeꞌ ma duꞌa rae sira parlu Lamatuaꞌ, ara onton, te akaꞌ Lamatualain mesaꞌ ne, sira Mane malolen. ");
INSERT INTO row_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Atahori mana ramedꞌa susa-sonaꞌ ra onton, huu Lamatualain mesaꞌ ne mana tao se ramahoꞌo. ");
INSERT INTO row_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Atahori anak ra onton, huu dei fo ara simbo basa papala-babꞌanggiꞌ fo Lamatualain helu-fuliꞌ a. ");
INSERT INTO row_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Atahori mana nau tungga Lamatualain dala ndoo-tetun ra onton, huu dei fo Ana tao fee se ramedꞌa dai. ");
INSERT INTO row_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Atahori mana ratudꞌu rala kasian ra onton, huu dei fo Lamatualain kasian se boe. ");
INSERT INTO row_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Atahori rala meumareꞌ ra onton, huu dei fo sira hambu rita Lamatualain. ");
INSERT INTO row_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Atahori mana tao mole-dꞌame ra onton, huu dei fo Lamatualain nae, ‘Sira, Au ana nggara.’ ");
INSERT INTO row_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Atahori mana nenetao doidꞌosoꞌ huu tungga Lamatualain, ara onton, te akaꞌ Lamatuaꞌ mesaꞌ ne, sira Mane malolen. ");
INSERT INTO row_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Mete ma atahori laen tao doidꞌoso nggi huu ama tungga Au, ama hambu hahambuꞌ boe. Mete ma ara olaꞌ deꞌulaka nggi, ma dui-bꞌengga peko-lelekoꞌ tao maꞌafoo nara mara, na ama o hambu hahambuꞌ boe. ");
INSERT INTO row_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Onaꞌ mae taꞌo naa o, ama musi tao ao mara ramahoꞌo ma rala mara maꞌaheeꞌ a, huu Lamatualain sadꞌia bala-bꞌae babꞌanggi mara naen seli sia sorga. Te misinedꞌa, e! Nda akaꞌ hei hambu doidꞌosoꞌ onaꞌ naa sa, te dalahulun atahori ra o tao dala deꞌulakaꞌ onaꞌ naa neu Lamatualain mana ola-ola nara boe.” ");
INSERT INTO row_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Mete ma tae tao nanaat maladꞌaꞌ, na, ata parlu tao masiꞌ neu dei. Onaꞌ naa boe atahori mana rasodꞌa sia raefafoꞌ ia, ara parlu nggi. Te mete ma masiꞌ a, mami ena, na, sosoan saa fai? Nggari hendi sia dalaꞌ fo nenetabꞌu-rorooꞌ. ");
INSERT INTO row_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Hei o musi misodꞌa onaꞌ lambu a, fo atahori hetar rita no maloleꞌ. Ama musi mbila manggareloꞌ, onaꞌ kota mana sia leteꞌ ata, fo atahori mete rita. ");
INSERT INTO row_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Atahori mana nambilaꞌ lambu teꞌoek, nda tao lambu a neu hura rae a rala sa. Te ara mbedꞌaꞌ lambu a sia mamana naruꞌ, fo naronda neu basa ume rala. ");
INSERT INTO row_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ama o musi misodꞌa onaꞌ naa boe. Ama musi mironda, fo atahori laen rita masodꞌa malole mara boe. Rita taꞌo naa dei fo ara koa-kio Lamatualain rae, ‘Wee! Hei Amam sia sorga, manaseliꞌ, o!’” ");
INSERT INTO row_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ama afiꞌ duꞌa mae, Au raefafoꞌ uma ia, fo ae umopoꞌ hendi Lamatualain hohoro-lalanen fo Ana fee neu baꞌi Musa. Boe ma afiꞌ mae Au nda tao afiꞌ neu saa fo Lamatualain mana ola-ola nara olaꞌ memaꞌ eniꞌ a lele uluꞌ a. Huu Au uma ia, ae tao basaꞌ e dadꞌi onaꞌ basa dalaꞌ fo ara olaꞌ memaꞌ a. ");
INSERT INTO row_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Huu naa de, rena malolole, e! Lalai no raefafoꞌ nda feꞌe bisa rambalulutu sa, mete ma basa e nda feꞌe dadꞌi tungga Lamatualain hohoro-lalane nara sa. Mae akaꞌ titiꞌ do koma esa o nda bisa neneose hendiꞌ sa. ");
INSERT INTO row_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Mia basa Lamatuaꞌ atahori nara, mete ma ruma ralena-langga Lamatualain hohoro-lalanen, huu ana duꞌa nae, ‘Hee! Hohoro-lalaneꞌ ia, anadꞌikiꞌ a, nda naꞌena sosoan saa sa boe!’ Basa ma ana nanori onaꞌ naa fee neu atahori laen, dei fo Lamatualain sia sorga tao e dadꞌiꞌ a anadꞌikiꞌ. Te, atahori mana tao tungga basa Lamatualain hohoro-lalanen, ma ana nanori onaꞌ naa neu atahori laen, dei fo Lamatualain tao eni dadꞌi atahori mana naꞌena ngguna. ");
INSERT INTO row_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mimihere Au! Mete ma hei nda misodꞌa ndoo-tetuꞌ malole lenaꞌ meser agama ro atahori partei Farisi ra sa, na, hei nda bisa dadꞌi Lamatualain atahorin sa. ");
INSERT INTO row_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Hei bubꞌuluꞌ baꞌi Musa hohoro-lalanen fo ana nafadꞌe memaꞌ neu bei-baꞌi tara nae, ‘Afiꞌ misa atahori, te se nisa atahori, dei fo ana hambu huku-dꞌokiꞌ.’ ");
INSERT INTO row_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Te Au ae ufadꞌe taꞌo ia: esa afiꞌ miminasa esa, te seka namanasa toronoon, dei fo nenehuku-dꞌokiꞌ. Atahori mana namue toronoon nae, ‘Nggoa ma onaꞌ ee!’ Dei fo atahori naa musi neu nataa sia lasi-lasi agama ra matan. Boe ma atahori mana bua toronoon nae, ‘Nggoaꞌ e!, dei fo nenehuku-dꞌokiꞌ sia ai naraka. ");
INSERT INTO row_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Dadꞌi mete ma mae mendi tutunu-hohotum neu Lamatualain, te musunedꞌa, toronoom feꞌe namanasa nggo, ");
INSERT INTO row_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","na, afiꞌ mbedaꞌ tutunu-hohotum dei. Muu dame mo toronoom dei, dei fo feꞌe na muu mbedaꞌ tutunu-hohotum fee neu Lamatualain. ");
INSERT INTO row_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Mete ma hambu atahori rae tao dedꞌeat ro nggo, na malole lenaꞌ muu dame lai-lai mo e leo. Mete ma hokoꞌ, naa, dei fo atahori naa no nggo muu mutaa sia mana nggero-furiꞌ a. Basa fo mana nggero-furiꞌ a fee nggo misiꞌ polisi, boe ma ara tao nggo bui rala muu. ");
INSERT INTO row_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Au olaꞌ ia tebꞌe-tebꞌeꞌ! Dei fo leo mukundoo sia bui rala losa bae basa hutam dei.” ");
INSERT INTO row_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Hei bubꞌuluꞌ baꞌi Musa hohoro-lalanen nae, ‘Afiꞌ hohongge.’ ");
INSERT INTO row_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Te Au ae ufadꞌe taꞌo ia: atahori botiꞌ matan fo mete inaꞌ sa, ma ralan hii nae sungguꞌ naꞌabꞌue no e, na, touꞌ naa hohongge no inaꞌ naa sia ralan ena. ");
INSERT INTO row_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Mete ma tao salaꞌ mendiꞌ mata onam, na, edꞌo hendiꞌ e. Huu malole lenaꞌ sorga muu mendiꞌ a matam seri, afiꞌ losa ara nggari nggo misiꞌ ai naraka muu mendi matam ruꞌa se. ");
INSERT INTO row_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ma mete ma tao salaꞌ mendiꞌ lima onam, na, nggero hendi e. Te malole lenaꞌ sorga rala muu mendiꞌ a limam seri, te afiꞌ losa ara nggari nggo misiꞌ ai naraka no limam ruꞌa se.” ");
INSERT INTO row_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Hei bubꞌuluꞌ baꞌi Musa hohoro-lalanen nae, ‘Atahori mahelaꞌ no saon, na, ana musi fee susura mahelaꞌ neu inaꞌ a.’ ");
INSERT INTO row_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Te Au ufadꞌe taꞌo ia: mete ma hambu atahori mahelaꞌ no saon, tao-tao te saon nda hohongge, sa, ma inaꞌ naa sao seluꞌ, na, onaꞌ sao ulun tao e hohongge. Ma mete ma hambu touꞌ sa sao nala inaꞌ mana hela hendiꞌ sa, na, ruꞌa se o hohongge boe. ");
INSERT INTO row_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Hei bubꞌuluꞌ baꞌi Musa hohoro-lalanen fo ana nafadꞌe neu bei-baꞌi tara nae, ‘Mete ma ho helu-fuli pake sumba mendiꞌ Lamatualain naran, na, ho nenepaꞌaꞌ mo hehelu-fufuliꞌ naa ena.’ ");
INSERT INTO row_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Te Au ufadꞌe taꞌo ia: mete ma helu-fuliꞌ, na, afiꞌ pake susumbaꞌ. Afiꞌ sumba mendiꞌ sorga naran, huu sorga naa, Lamatualain mamana leleon. ");
INSERT INTO row_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Afiꞌ sumba mendiꞌ raefafoꞌ naran, huu raefafoꞌ naa Lamatualain ei tatabꞌun boe. Boe ma afiꞌ sumba mendiꞌ Yerusalem naran, huu Yerusalem naa o, Mane Monaeꞌ a kotan boe. ");
INSERT INTO row_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Afiꞌ sumba mendiꞌ langga mara. Te hei nda miꞌena koasa fo parenda langga fulu mara esa fo dadꞌi nggeoꞌ do mutiꞌ sa boe. ");
INSERT INTO row_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Dadꞌi mete ma ama mae helu-fuliꞌ mae, iya, na, mifadꞌe mae, ‘iya’. Do mete ma hokoꞌ naa, mae ‘Hokoꞌ’. Mete ma hei olaꞌ lenaꞌ naa fai, na, naa naꞌoka sia nitu ra ena. ");
INSERT INTO row_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Hei bubꞌuluꞌ baꞌi Musa hohoro-lalanen nae, ‘Mete ma hambu atahori tao ralutu matam, na, bala-bꞌae tao mulutu matan boe. Ma mete ma hambu atahori tao raꞌouꞌ nisim, na, tao muꞌouꞌ nisin boe.’ ");
INSERT INTO row_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Te Au ae ufadꞌe taꞌo ia: afiꞌ bala-bꞌae deꞌulakaꞌ no deꞌulakaꞌ. Mete ma atahori mbasa nasum seri, na, hela fo ana mbasa seluꞌ nasum seri fai. ");
INSERT INTO row_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mete ma hambu atahori rae radꞌedꞌea ro nggo, fo rae haꞌi rala badꞌum, na, fee jeket ma neu boe. ");
INSERT INTO row_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mete ma hambu soldꞌadꞌu esa naꞌasusuuꞌ nggo laoꞌ ma lemba mendi sudꞌiꞌ a saan dodꞌoon kilo esa, na, lemba mendi e dodꞌoon kilo rua leo. ");
INSERT INTO row_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mete ma hambu atahori roꞌe saa mia nggo, na, fee neu leo. Ma mete ma hambu atahori rae pindan sudꞌiꞌ a saa ma, na, fee neuꞌ ena. ");
INSERT INTO row_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Hei rena atahori rae, ‘Sue toronoo mara, ma binci atahori mana binci nggo.’ ");
INSERT INTO row_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Te Au ufadꞌe taꞌo ia: musi sue atahori mana binci nggo. Ma moꞌe Lamatuaꞌ fee papala-babꞌanggiꞌ neu atahori mana tao doidꞌoso nggo. ");
INSERT INTO row_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Mete ma tao taꞌo naa, na, mutudꞌu mae, ho ia Amam mana sia sorga anan. Huu Ana tao relo a naronda fee neu atahori maloleꞌ ma fee neu atahori deꞌulaka ra boe. Ana o naꞌondaꞌ udꞌan fee neu atahori mana tungga parendan naꞌabꞌue no atahori mana labꞌan parendan boe. ");
INSERT INTO row_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Dadꞌi mete ma sue akaꞌ atahori mana sue nggo, na, duꞌa mae Lamatualain musi bala-bꞌae nggo papala-babꞌanggiꞌ do? Hokoꞌ! Te atahori deꞌulakaꞌ o sue nonoo mana sue sira boe. ");
INSERT INTO row_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Dadꞌi mete ma ho fee sodꞌa-moleꞌ neuꞌ a nonoom, na, lenan saa? Te atahori nda mana ramahere neu Lamatualain sa o tao onaꞌ naa boe. ");
INSERT INTO row_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Dadꞌi musunedꞌa, e! Amam mana sia sorga sue basa atahori. Dadꞌi musi tao tungga taꞌo naa boe. ");
INSERT INTO row_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yesus nanori nakandoo nae, “Misinedꞌa, e! Afiꞌ tungga-tunggaꞌ a agama hohoro-lalanen fo atahori koa-bobꞌoꞌu nggi. Te mete ma ama tao taꞌo naa, na, hei Amam mana sia sorga nda fee nggi bala-bꞌaeꞌ saa sa boe. ");
INSERT INTO row_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Mete ma hei nau tulu-fali atahori mana kasian ra, na, afiꞌ mii bengga leli sia bee bee. Te mete ma hei tao taꞌo naa, na, hei onaꞌ atahori mana olaꞌ laen, tao laen. Ara hiiꞌ a lao-laoꞌ risiꞌ ume hule-oꞌe huuꞌ a fo atahori koa se oi, ‘Wei, atahori ia ra, seli tebꞌe, o!’ Au olaꞌ no matetuꞌ! Te noꞌ a koaot onaꞌ naa, ara simbo sira hahambun ena. ");
INSERT INTO row_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Dadꞌi mete ma hei mae tulu-fali atahori mana kasian ra, na, afiꞌ mifadꞌe see-see boe e! ");
INSERT INTO row_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","No taꞌo naa, atahori sia raefafoꞌ ia nda rahine sa. Te hei Amam sia sorga nahine saa fo ama tao nee-neeꞌ naa. Dei fo Ana bala-bꞌae nggi no papala-babꞌanggiꞌ naen seli.” ");
INSERT INTO row_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Leleꞌ ama hule-oꞌe, na, afiꞌ tao aom onaꞌ atahori mana olaꞌ laen, te tao laen. Ara hiiꞌ a reu lao-laoꞌ sia dala rarameꞌ a, ma rambariiꞌ sia ume hule-oꞌeꞌ rala, fo atahori hetar rita ma koa-koaꞌ se rae, ‘Wue! Sira ia, atahori meumareꞌ, o!’ Te rena, e! Te mete ma ara simbo kokoaꞌ naa, na, ara simbo rala hahambu nara ena. ");
INSERT INTO row_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Te ama afiꞌ taꞌo naa. Mete ma mae hule-oꞌe, na, kama rala mii fo ena lelesu a. Ma hule-oꞌe neenee neu Amam. Mae atahori nda rita nggi sa o, Amam nita nggi. Dei fo Ana bala-bꞌae fee nggi papala-babꞌanggiꞌ naen seli. ");
INSERT INTO row_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Mete ma ama hule-oꞌe, naa, afiꞌ ola leꞌu-lolo neu nema. Te atahori nda mana rahine Lamatualain sa o hule-oꞌe rahine onaꞌ naa boe. Ara duꞌa rae, mete ma hule-oꞌe loa-naruꞌ onaꞌ naa, na Lamatualain hiiꞌ a rena ma nataa se. ");
INSERT INTO row_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Afiꞌ tao tungga onaꞌ se, e! Te mae ama nda feꞌe moꞌe saa mbali Amaꞌ sia sorga sa o, Ana bubꞌuluꞌ memaꞌ hei parlu ma ena. ");
INSERT INTO row_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Dadꞌi mete ma hule-oꞌe, na, hule-oꞌe onaꞌ ia: ‘Amaꞌ sia sorga! Amaꞌ naram meumareꞌ manaseliꞌ Hela fo basa atahori soꞌu rananaru Amaꞌ naram manaseliꞌ a. ");
INSERT INTO row_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Amaꞌ dadꞌi maneꞌ soaꞌ neu basa atahori! Hela neu fo basa atahori tao tungga Amaꞌ parendan sia raefafoꞌ ia, onaꞌ basa mana sia sorga ra tao tungga Amaꞌ parendan sia sorga. ");
INSERT INTO row_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Amaꞌ tulun pala-banggi fee hai nanaat manadꞌaiꞌ tungga-tungga fai. ");
INSERT INTO row_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Hai moꞌe Amaꞌ fee ambon neu basa hai sala-kiluꞌ mara, onaꞌ hai fee ambon neu atahori mana tao salaꞌ neu hai boe. ");
INSERT INTO row_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Amaꞌ, munea hai fo hai afiꞌ tao deꞌulakaꞌ. Ma mboꞌi hendi hai mia nitu a koasan. Te Amaꞌ, Maneꞌ mana koasa ma manaseliꞌ Amaꞌ mana toꞌu parendaꞌ mukundooꞌ a. Hai hule-oꞌem baꞌu a naa ena, Amaꞌ. Amin.’ ");
INSERT INTO row_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Te rena, e! Mete ma ama fee ambon neu atahori salan, dei fo Amam sia sorga o fee ambon neu sala-kilu mara boe ");
INSERT INTO row_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Te mete ma ama nda nau fee ambon neu atahori salan, dei fo Amaꞌ sia sorga o, nda nau fee ambon neu sala mara sa boe. ");
INSERT INTO row_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Mete ma ama hule-oꞌe no puasa, na, afiꞌ tao mata masaloeꞌ onaꞌ atahori mana olaꞌ laen te tao laen. Huu ara tao taꞌo naa fo atahori koa se rae, ‘Wue! Sira ia, atahori meumareꞌ, o!’ Te rena, e! No koaot naa, ara simbo rala hahambu nara ena. ");
INSERT INTO row_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Te mete ma ama puasa, na, safe mata mara meuꞌ-meuꞌ, ma sau langga mara malolole! ");
INSERT INTO row_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Dadꞌi dei fo atahori rita nggi o, nda rahine rae, ama puasa sa. Te hei Amam bubꞌuluꞌ. Dei fo Ana bala-bꞌae fee nggi no papala-babꞌanggiꞌ naen seli.” ");
INSERT INTO row_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Afiꞌ tao ues nggate-nggate fo miꞌidꞌuru hata-hetoꞌ nae-nae sia raefafoꞌ ia. Te dei fo fufuꞌ no rurutuꞌ tao nalutu se. Ma naꞌo ra rema bonggar fo haꞌi rendi se. ");
INSERT INTO row_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Te malole lenaꞌ ama nggate-nggate tao ues miꞌidꞌuru hata-heto nae-nae sia sorga. Te sia naa fufuꞌ no rurutuꞌ a nda tao nalutu se sa. Naꞌo ra o nda reu bonggar fo haꞌi rendi se sa boe. ");
INSERT INTO row_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Hei mbedꞌaꞌ hata-heto mara sia bee, na, neꞌo rala mara sia naa boe.” ");
INSERT INTO row_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Atahori matan, onaꞌ lambu mana naronda sia ralan rala. Mete ma matan manggareloꞌ, na, ana tungga dala masodꞌa maloleꞌ, onaꞌ atahori mana laoꞌ sia manggareloꞌ a. ");
INSERT INTO row_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Te mete ma matan mana malaafuꞌ, na, ana nda tungga dala maloleꞌ a sa, onaꞌ atahori mana laoꞌ hama-hama sia maꞌahatuꞌ a. Dadꞌi mete ma manggareloꞌ mana sia rala mara dadꞌi maꞌahatu ena, na, hei o misodꞌa sia maꞌahatu manaseliꞌ a boe.” ");
INSERT INTO row_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Atahori sa nda bisa tao ues tebꞌe-tebꞌeꞌ fee neu malangga rua lao esaꞌ sa, huu dei fo ana hii malangga esa lenaꞌ malangga laen. Boe ma ana bisa tungga malanggan esa, ma nda taoafiꞌ neu malanggan esa ka sa. Huu naa, de nda bisa olaꞌ mae, ‘Lamatuaꞌ naa, au Lamatua ngga,’ mete ma tao doiꞌ a dadꞌi lamatua ma. ");
INSERT INTO row_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Naeni de Au ufadꞌe taꞌo ia: afiꞌ duꞌa doaꞌ mae, au usodꞌa taꞌo bee, au ae ua saa, inu saa, pake-nggao saa? Hei duꞌa mae masodꞌaꞌ naa, akaꞌ nanaa-nininuꞌ a, do? Boe ma aom naa, akaꞌ pake-nggaoꞌ a, do? Nda taꞌo naa sa. ");
INSERT INTO row_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mete sobꞌa mbui mana ratambele sia lalai a. Ara nda sela-nggari ma etu-oru fo mbedꞌa nanaat sia soka-poleꞌ ra sa. Te hei Amam sia sorga naꞌabꞌoi se nakandooꞌ a. Ana o bisa naꞌabꞌoi nala nggi lenaꞌ se fai. Dadꞌi duꞌa malolole dei. Te Ana nile nggi, lenaꞌ mbuiꞌ naa ra. ");
INSERT INTO row_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Mete ma atahori rambariiꞌ sia tiroao fo lole-lau aon, na, ana bisa tao namanaru aon, do? Nda bisa sa! ");
INSERT INTO row_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Mete ma hokoꞌ, na, taꞌo bee de ama feꞌe duꞌa doaꞌ bua-loꞌas fai? Mii seꞌu mita buna bakung sia moo-loaꞌ. Ara nda podꞌeꞌ abꞌas, ma tenu-lolo temeꞌ sa. ");
INSERT INTO row_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Te rena malolole, o! Mane Soleman bua-baꞌun meulau manaseli na o, nda naseliꞌ bunaꞌ naa ra meulaun sa. ");
INSERT INTO row_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Lamatualain tao mataꞌ neu bunaꞌ mana nasodꞌa akaꞌ faiꞌ ia, te mbilaꞌ neu ana mate fo atahori nggari e ai rala neu. Mete ma Ana tao taꞌo naa, dei fo Ana pake-nggao nggi lenaꞌ bunaꞌ naa ra. De saa de ama nda mimihere tebꞌe-tebꞌeꞌ neu E sa? ");
INSERT INTO row_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Dadꞌi ama sudꞌi boe duꞌa doaꞌ mae, ‘Ata taa saa?’ do, ‘Tinu saa?’ do, ‘Pake-nggao saa? ");
INSERT INTO row_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Atahori nda mana ramahere neu Lamatualain sa, ara tao ues ritaꞌ mamate nara fo nau hambu basa naa ra. Te ama afiꞌ taꞌo naa, huu hei Amam sia sorga bubꞌuluꞌ basa saa fo ama parluꞌ a ena. ");
INSERT INTO row_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Te akaꞌ na hei musi milalao ue-tataos Na no tebꞌe-tebꞌeꞌ dei, boe ma musi tungga parendan, dei fo Ana fee seluꞌ basa saa fo ama parluꞌ ra. ");
INSERT INTO row_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Dadꞌi afiꞌ duꞌa doaꞌ saa fo ama parlu mlbila. Te fai esa na no eni sususan. Faiꞌ ia sususan dai ena.” ");
INSERT INTO row_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ama afiꞌ fua salaꞌ neu atahori, fo Lamatuaꞌ afi fee salaꞌ neu nggi. ");
INSERT INTO row_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ama nile atahori taꞌo bee, na, dei fo Lamatualain o nile nggi onaꞌ naa boe. Ama uku-uli atahori laen salan taꞌo bee, na, dei fo Lamatualain o uku-uli nggi taꞌo naa boe. ");
INSERT INTO row_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Te hiiꞌ a mete atahori sala anak na, te sala monaem, ho nda mita sa. Mae salaꞌ nese. Naa onaꞌ mita afu dꞌekeꞌ sa sia nonoom matan. Tao-tao te bꞌalok monaeꞌ a bambi nala matam, te nda medꞌa sa. ");
INSERT INTO row_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Taꞌo bee fo mbarani olaꞌ mae, ‘Toronooꞌ! Uma fo au ose hendi afu mia mata dekem dei.’ Tao-tao te nda mita balok mana bambi nala matam sa. ");
INSERT INTO row_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Wae! Memaꞌ ho, atahori mana dea-ralaꞌ tebꞌe! Nggari hendi balok a mia matam dei, na fo mete mita no malole, fo ose hendi afu deke bibꞌia anaꞌ mia nonoom matan. ");
INSERT INTO row_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Afiꞌ minori dala meumareꞌ soꞌal Lamatuaꞌ fee mana maꞌaꞌeꞌeiꞌ ra. Huu ara onaꞌ busa deꞌulaka dei fo heoꞌ baliꞌ rema fo ero nggi. Nggoa nara onaꞌ fafi ra. Mete ma atahori fee rante mafelit, na, ana nda taoafiꞌ sa! Huu ana nahineꞌ a tabꞌu-rorooꞌ a.” ");
INSERT INTO row_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Mete ma ama hule-oꞌe, na moꞌe mikindooꞌ mbali Lamatuaꞌ dei fo Ana fee. Mete ma sangga mikindooꞌ a; dei fo Ana natudꞌu dalaꞌ. Mete ma mimeli mikindooꞌ a; na dei fo Ana soi lelesu a. ");
INSERT INTO row_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Te basa atahori mana roꞌe rakandooꞌ a mbali Lamatuaꞌ, na dei fo ara simbo. Mana sangga nakandooꞌ a dei fo hambu, Mana nameli nakandooꞌ a, na dei fo Ana soi lelesu a. ");
INSERT INTO row_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ama duꞌa sobꞌa! Mete ma hambu anaꞌ sa noꞌe roti, neꞌo aman nda fee ne fatu sa, to? ");
INSERT INTO row_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Do mete ma anan noꞌe uꞌu, na aman nda fee ne mengge sa! ");
INSERT INTO row_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Hei Amam mana sia sorga, memaꞌ malolen seli. De atahori fo deꞌulakaꞌ mataꞌ onaꞌ hei ia ra o, hiiꞌ a fee sudꞌiꞌ a malole neu ana mara, na, saa fai hei Amam! Dei fo Ana fee saa fo ama moꞌeꞌ a. ");
INSERT INTO row_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Dadꞌi saa fo nau atahori tao neu nggo, na, musi tao taꞌo naa neu e boe. Huu ia, netehuuꞌ mia basa baꞌi Musa no Lamatualain mana ola-ola nara ranori eniꞌ a lele uluꞌ a.” ");
INSERT INTO row_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Mete ma atahori sa nae sorga neu, na ana musi laoꞌ tungga lelesu makabꞌiaꞌ. Te hambu dala mudaꞌ no lelesu loaꞌ, fo atahori hetar hii tunggaꞌ a. Te besa-bꞌesa, o! Huu dalaꞌ mana onaꞌ naa nendi atahori naraka reu, fo saranggaa mia Lamatuaꞌ. ");
INSERT INTO row_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Atahori mana nae sorga neu musi tungga dala doidꞌosoꞌ ma lelesu makabꞌiaꞌ. Onaꞌ mae akaꞌ atahori hidꞌaꞌ a laoꞌ sia naa o, dala makabꞌiaꞌ onaꞌ naa nendi atahori nisiꞌ Lamatuaꞌ.” ");
INSERT INTO row_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Besa-bꞌesa mo mana pepeko-lelekoꞌ mana soꞌu ao nara rae, sira Lamatuaꞌ mana ola-olan. Huu ara tao ao nara maloleꞌ onaꞌ bibꞌi lombo a. Tao-tao te sira deꞌulakaꞌ, onaꞌ busa fui mana nema naa bibꞌi lombo. ");
INSERT INTO row_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Taꞌo bee fo bisa mihine atahori mana peko-lelekoꞌ onaꞌ naa? Mete siaꞌ a tatao-nonoꞌi nara. Onaꞌ atahori mete boaꞌ, fo rahine boaꞌ naa huun. Boa maloleꞌ, nda kalua mia hau hu nda maloleꞌ sa. ");
INSERT INTO row_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Huu hau maloleꞌ nabꞌoa boa maloleꞌ boe. Te hau hu nda maloleꞌ sa nabꞌoa boa nda maloleꞌ sa boe. ");
INSERT INTO row_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nda hambu hau hu maloleꞌ fo nabꞌoaꞌ boa nda maloleꞌ sa. Ma nda hambu hau huu nda maloleꞌ sa nabꞌoa boa maloleꞌ. ");
INSERT INTO row_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Hau hu mana nabꞌoa nda maloleꞌ a sa, dei fo ara rema ungga e fo nggari e ai rala neu. ");
INSERT INTO row_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Onaꞌ naa boe neu mana ola-olaꞌ pepeko-lelekoꞌ ra. Ama mihine se mia sira tatao-nonoꞌi nara.” ");
INSERT INTO row_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Dei fo hambu atahori roꞌe Au rae, ‘Lamatuaꞌ!’ Te ara olaꞌ siaꞌ a bafa nara. Dei fo Lamatualain sia sorga timba hendi se. Huu, akaꞌ atahori mana tungga tebꞌe-tebꞌeꞌ Eni hihii-nanaun, Ana simbo nala se dadꞌi atahorin. ");
INSERT INTO row_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Dei fo leleꞌ fai mateteꞌen, atahori hetar rataa rae, Au ia sira Lamatuan. Ara kokoe Au rae, ‘Lamatuaꞌ, e! Hai mii dui-bꞌengga Nenori ma. Hai use-oi nitu ra mendiꞌ Naram. Ma hai tao manadadꞌiꞌ mataꞌ-mataꞌ mendiꞌ koasa Ma.’ ");
INSERT INTO row_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Mae ara akaꞌ kokoe Au taꞌo naa o, dei fo Au ufadꞌe se ae, ‘Hei ia ra, seka? Au nda uhine nggi sa, huu ama nda misodꞌa tungga Lamatuaꞌ hihii-nanaun sa. Dadꞌi dinggoꞌ hela ia leo!’” ");
INSERT INTO row_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Atahori mana nema rena Au, fo tao tungga Au oꞌola ngga, eni onaꞌ atahori mahineꞌ, mana naririi umen sia fatu netehuuꞌ ata. ");
INSERT INTO row_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Dodꞌoo ma udꞌan monaeꞌ a nggangga losa oeꞌ a lala. Ma sanggu anin o nema uli-fae ume naa. Te ume naa nda foi sa, huu neneneririiꞌ sia fatu netehuuꞌ manggateeꞌ a ata. ");
INSERT INTO row_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Atahori mana nema rena Au, te nda tao tungga oꞌola ngga sa, eni onaꞌ atahori nggoaꞌ mana naririi umen sia saraꞌaeꞌ ata. ");
INSERT INTO row_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Dodꞌoo ma udꞌa monaeꞌ a nggangga nema losa oe a lala. Ma sanggu anin o nema uli-fae ume a boe. Ma ume a foi hendiꞌ e losa nambalulutu.” ");
INSERT INTO row_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesus olaꞌ naꞌo naa ma, basa atahori mana rena nenorin ra titindindiiꞌ a, ");
INSERT INTO row_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","huu Ana nahine tebꞌe-tebꞌeꞌ nenoriꞌ naa isin. Dala nenorin, nda onaꞌ sira meser agama nara ranorin sa. ");
INSERT INTO row_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesus onda nema mia leteꞌ a, ma atahori hetar nonggo-nonggo reu tungga E. ");
INSERT INTO row_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Aibꞌoiꞌ ma, atahori hedꞌi kusta esa neu nisiꞌ E. Ana sendeꞌ lululanggan de noꞌe tulun Yesus nae, “Papa, e! Tulun au dei! Mete ma Papa nau, na, Papa bisa muꞌuhahaiꞌ hedꞌi ngga ia, naa fo atahori sudꞌi boe melumudꞌu au fai, ma au o bisa uu hule-oꞌe sia ume nggareiꞌ rala.” ");
INSERT INTO row_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Rena onaꞌ naa, ma Yesus loo liman, kois atahori kusta, ma olaꞌ nae, “Au nau! Hai leon!” Aibꞌoiꞌ ma, atahori naa hedꞌis na mopo neuꞌ ena. ");
INSERT INTO row_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","De Yesus olaꞌ no e nae, “Musunedꞌa, e! Ho hai ena, te afiꞌ mufadꞌe esa boe. Musi tungga baꞌi Musa hohoro-lalanen dei. Dadꞌi muu sia malangga agama, fo ana paresaꞌ aom dei, naa fo ana nahine hedꞌis ma mopo tebꞌe ena, do feꞌe hokoꞌ. Basa na musi muu fee tutunu-hohotuꞌ dadꞌi tanda makasi, fo basa atahori bubꞌuluꞌ rae, ho hai tebꞌe ena.” ");
INSERT INTO row_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Basa naa ma, Yesus neu sia Kambo Kapernaum. Sia naa, malangga soldꞌadꞌu Roma esa nema noꞌe tulu-faliꞌ nae, ");
INSERT INTO row_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Papa, e! Au ana mana tao ues ngga esa namahedꞌi sia ume. Ana nda fela nala mia koi a sa, huu ana namahedꞌi nitaꞌ mamaten.” ");
INSERT INTO row_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesus nataa nae, “Malole! Dei fo Au eti fo tao uhaiꞌ e.” ");
INSERT INTO row_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Te malangga nae, “Papa afiꞌ bengge-bꞌengge muu fai, huu Au nda undandaa simbo Papa sia ume ngga sa. Sadꞌi Papa olaꞌ mia ia nema, na au ana mana tao ues ngga, hai neuꞌ ena. ");
INSERT INTO row_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Au uhine dalaꞌ ia, huu au malangga nggara raꞌena koasa parenda au. Ma au o uꞌena koasa fo parenda soldꞌadꞌu nggara boe. Mete ma au parenda soldꞌadꞌu ngga ae, ‘Muu sia naa!’ na, ana neu. Mete ma au ae, ‘Ia uma!’ na, ana nema. Ma mete ma au denu ana mana tao ues ra ae, ‘Ue-tao ia!’ na, ana tao taꞌo naa. Dadꞌi sadꞌi Papa olaꞌ, na, au ana mana tao ues ngga, hai neuꞌ ena. ");
INSERT INTO row_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesus rena nala onaꞌ naa, ma Ana heran. Ana olaꞌ neu atahori hetar mana tungga Eni nae, “Heran, e! Doon basa ia te, Au nda feꞌe undaa o atahori Yahudi esa sa boe nemehere seli onaꞌ atahori Roma ia sa! ");
INSERT INTO row_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Rena, e! Te dei fo hambu atahori fuiꞌ hetar onaꞌ atahori Roma ia rema mia seriꞌ rulu ma mia seriꞌ muri, fo endoꞌ raa fefetas raꞌabꞌue ro baꞌi Abraham, baꞌi Isak, ma Yakob sia Lamatualain umen sia sorga. ");
INSERT INTO row_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Onaꞌ mae Lamatuaꞌ pili atahori Yahudi fo dadꞌi atahorin ena o, te hambu atahori hetar nda taoafiꞌ neu E sa. Dei fo Ana timba hendi se risiꞌ mamana maꞌahatu kibꞌu-kibꞌuꞌ a. Sia naa ara nggae eiei ma doidꞌoso ritaꞌ mamate nara.” ");
INSERT INTO row_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Olaꞌ basa onaꞌ naa ma, Yesus olaꞌ neu malangga soldꞌadꞌu a nae, “Pak baliꞌ leo. Te ana mana tao ues ma hai ena, onaꞌ Pak nemeheren.” Nandaa no leleꞌ naa o, anaꞌ naa hai neuꞌ ena boe. ");
INSERT INTO row_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Lao esa ma, Yesus neu nisiꞌ Petrus umen. Ana nita Petrus ina arin sungguꞌ sia koi a, mana mera mafeo-matobꞌiꞌ. ");
INSERT INTO row_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesus toꞌu liman, ma mafeo-matobꞌiꞌ a mopo neuꞌ ena mia ina lasiꞌ a. Basa ma ana fela de neu lole-lau fee Yesus se. ");
INSERT INTO row_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Leleꞌ relo a soko ma, atahori ra rema rendi atahori nitu taoꞌ ra. Ma Yesus parenda nitu ra nae, “He, nitu! Dinggoꞌ hela atahori ia ra leo!” Boe ma nitu ra rela reuꞌ ena. Ana o tao nahaiꞌ basa atahori mamahedꞌiꞌ ra. ");
INSERT INTO row_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ana tao basa ia ra, tungga saa fo Lamatualain mana ola-olan Yesaya suraꞌ memaꞌ nae, “Ana naꞌahahaiꞌ hedꞌi-nggarau tara. Ma Ana tanggon doidꞌoso tara.” ");
INSERT INTO row_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Basa naa ma, Yesus nita atahori hetar rema rereoꞌ rala E. Boe ma Ana denu ana mana tungga nara nae, “Ima ata lea laar fo lao tisiꞌ dano seriꞌ.” ");
INSERT INTO row_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Boe ma meser agama sa nema de olaꞌ nae, “Ama Meser! Amaꞌ neu sudꞌiꞌ a sia bee o, au nau tungga ukundoo o Amaꞌ!” ");
INSERT INTO row_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Te Yesus nataa nae, “Malole, boe! Te musunedꞌa taꞌo ia. Basa atahori ro banda ra raꞌena mamana leleo-luluꞌuꞌ. Busa fui a baliꞌ nisiꞌ ndolan. Mbuiꞌ ra baliꞌ risiꞌ nduna nara. Te Au, Atahori Tetebꞌes ia, nda uꞌena ume fo baliꞌ uu sa. Mamanaꞌ fo ndae langga ngga o, Au nda maꞌenaꞌ sa boe.” ");
INSERT INTO row_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Basa ma atahori sa fai, mana tunggaꞌ no E, nema noꞌe nae, “Papa! Au ae tungga Papa boe, te au baliꞌ fo mete-seꞌu ala ina-ama nggara dei. Mete ma ama ngga mate ena, na, dei fo au tungga.” ");
INSERT INTO row_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Te Yesus olaꞌ nae, “‘Taꞌo ia! Hela neu fo atahori nda mana namahere neu Lamatualain sa, mete seꞌu atahori mana mate nara. Te mete ma mae tungga Au, na, musi tungga no tebꞌe-tebꞌeꞌ!” ");
INSERT INTO row_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Basa naa ma, Yesus hene ofaꞌ ata neu, no ana mana tungga nara. ");
INSERT INTO row_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Leleꞌ ara lea laar de lao risiꞌ dano a seriꞌ, boe ma Ana sungguꞌ. Nda doo ꞌ sa ma, sanggu-anin fela boe. Ree ra poꞌa ofaꞌ, ma oeꞌ a ofaꞌ rala neu. ");
INSERT INTO row_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ara Rita onaꞌ naa, ma ana mana tungga nara rafefela E rae, “Papa! Papa, e! Fela fo tulun tao musodꞌa nggita dei! Te taeꞌ a tena ena!” ");
INSERT INTO row_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Boe ma Yesus nataa nae, “Woi, taꞌo bee de hei mimitau? Hei nda mimihere Au sa, do?” Boe ma Ana fela. Basa de Ana ai sanggu-anin ma ree ra nae, “Miloeꞌ leo!” Boe ma ree ra no sanggu-anin linoꞌ neuꞌ ena. ");
INSERT INTO row_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Boe ma Yesus ana mana tungga nara heran. Ara rae, “Awii! Eni ia, seka, e? Taꞌo bee de Ana parenda anin no ree ra de ara tungga Hihii-nanaun?” ");
INSERT INTO row_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Nda dooꞌ sa ma, ara losa dano a seriꞌ, sia atahori Gadara ra nusan. Sia naa hambu atahori nitu taoꞌ rua leo sia lua fatuꞌ atahori mates ra mamanan. Ruꞌa se deꞌulaka nara seli, losa nda hambu atahori esa nambarani laoꞌ sia naa sa boe. Ara rita Yesus nema ma, ");
INSERT INTO row_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ara nggasi rae, “Woi, Lamatualain Anan! Taꞌo bee de uma ngganggu hai? Eni fain nda feꞌe losa sa, te mae tao doidꞌoso hai ena.” ");
INSERT INTO row_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Hambu fafi hetar sosoꞌa rae a sangga nanaat deka-deka naa. ");
INSERT INTO row_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Boe ma nitu ra roꞌe Yesus rae, “Mete ma mae oi hai, na denu hai misiꞌ a fafi naa ra!” ");
INSERT INTO row_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Boe ma Yesus parenda se nae, “Mii leo!” Boe ma nitu ra rela lao hela atahori ka ruaꞌ ra, de risiꞌ fafi ra. Boe ma fafi ra rela leli onda tungga leteꞌ a suun de dano rala reu. Boe ma tena hendi basa se de mate. ");
INSERT INTO row_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Mete rita taꞌo naa ma, mana manea fafi ra rela baliꞌ kamboꞌ reu, de dui basa-bꞌasaꞌ e. ");
INSERT INTO row_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Rena rala dudꞌui nara, ma atahori hetar reu sia mamanaꞌ naa. Ara randaa ro Yesus, ma ara kokoe Yesus fo lao hela mamanaꞌ naa leo. ");
INSERT INTO row_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Basa naa ma, Yesus se hene baliꞌ ofaꞌ rala reu, de lea laar risiꞌ dano seriꞌ reu, losa Eni nusan. ");
INSERT INTO row_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Sia naa atahori ndoro rendi nonoon esa mamaluꞌuꞌ nisiꞌ Yesus matan. Nita taꞌo naa ma, Yesus bubꞌuluꞌ ara ramahere Eni rae, Eni bisa tao nahaiꞌ sira nonoon. Boe ma Ana olaꞌ neu atahori mamaluꞌuꞌ a nae, “Ana, ngge! Tao manggatetee ralam dei! Te Au fee ambon neu basa sala mara ena.” ");
INSERT INTO row_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Te hambu meser agama Yahudi hira sia naa, rena Yesus oꞌolan. Ma ara ramanasa neuꞌ ena. Boe ma ara ola-olaꞌ rae, “Atahori ia nambarani olaꞌ taꞌo naa, o! Akaꞌ Lamatualain mana fee ambon neu atahori salan. Te atahori ia oꞌolan, tao aon onaꞌ Lamatualain. Ana naꞌamuti!” ");
INSERT INTO row_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Te Yesus bubꞌuluꞌ rala nara. Basa ma Ana olaꞌ nae, “Taꞌo bee de ama duꞌa mae, Au, olaꞌ uꞌumuti? ");
INSERT INTO row_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Be mudaꞌ lenaꞌ? Mete ma Au ufadꞌe atahori mamaluꞌuꞌ ia ae, ‘Sala-kilum hambu ambon ena,’ do, Au ae, ‘Fela leo, fo baliꞌ.’ ");
INSERT INTO row_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Mete ma ana fela neuꞌ ena, ama feꞌe mita bukti mae, Au ia, Atahori Matetuꞌ a. Huu Au uꞌena hak fee ambon neu atahori sala-kilun.” Boe ma Yesus parenda atahori mamaluꞌuꞌ a nae, “Fela leo! Soꞌu-botiꞌ radꞌat ma fo lao baliꞌ leo!” ");
INSERT INTO row_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Boe ma, atahori mamaluꞌuꞌ a fela, de lao baliꞌ. ");
INSERT INTO row_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Rita onaꞌ naa ma, basa atahori ra titindindi. De ara soꞌu rananaru Lamatualain naran rae, “Lamatualain manaseliꞌ, o! Ana fee koasa monaeꞌ onaꞌ ia neu atahori.” ");
INSERT INTO row_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Basa ma, Yesus lao mia naa, ma nita atahori mana edꞌa bea esa sia ume bea a. Naran, Mateos. Yesus noꞌe nala e nae, “Uma tungga Au!” Rena nala ma, Mateos fela de tungga neuꞌ ena. ");
INSERT INTO row_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Basa ma, Mateos noꞌe Yesus se reu raa sia umen. Ana o noꞌe nonoo mana ꞌedꞌa bea nara ro fuiꞌ laen ra, fo atahori duꞌa rae atahori deꞌulakaꞌ ra, fo rema raa raꞌabꞌue ro se. ");
INSERT INTO row_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Te hambu atahori partei Farisi hira o, rema ramue mbali Yesus ana mana tungga nara rae, “Taꞌo bee de hei meser ma endoꞌ naa naꞌabꞌue no atahori nda mana laku-lakuꞌ ra sa, onaꞌ mana edꞌa bea ra, ro nonoo atahori deꞌulaka nara?” ");
INSERT INTO row_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Te Yesus nafadꞌe se nae, “Atahori mamahedꞌiꞌ ra memaꞌ parlu doter. Te atahori nda mamahedꞌiꞌ ra sa, nda parlu sa. ");
INSERT INTO row_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Malole lenaꞌ ama baliꞌ fo paresaꞌ malolole Lamatualain Dedꞌea-oꞌolan, fo lele uluꞌ a Ana denu mana ola-olan Hosea sura nae, ‘Au hihii ngga, naeni, Au atahori ngga esa sue esa ratudꞌu susue-lalaiꞌ. Mete ma ara nda tao taꞌo naa sa, na, banda tutunu-hohotuꞌ fo rendi fee Auꞌ a, nda naꞌena sosoaꞌ sa.’ Naa Lamatualain nafadꞌe ena. Huu naa, Au nda uma mete-seꞌu atahori mana duꞌa rae sira ndoo-tetuꞌ sa, te uma mete-seꞌu atahori mana rahine rae sira masala-kiluꞌ.” ");
INSERT INTO row_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Basa ma, Yohanis Mana Saraniꞌ a, ana mana tungga nara rema risiꞌ Yesus. Ara ratane rae, “Hai mana tungga Yohanis, biasa puasa. Atahori Farisi ra puasa boe. Te taꞌo bee de Amaꞌ ana mana tungga mara akaꞌ raa-rinu rakandooꞌ a? Saa de ara nda puasa sa?” ");
INSERT INTO row_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Te Yesus nataa se, nendiꞌ nekendandaaꞌ nae, “Taꞌo ia: mete ma hambu fefeta kakabꞌiꞌ, fuiꞌ ra nda puasa sa, te raa raꞌabꞌeta. Mete ma touꞌ a lemba-dodꞌen feꞌe sia naa, neꞌo basa se raa raꞌabꞌue reu esa. Te dei fo lao esa, mete ma atahori laen toꞌu rendi touꞌ a lemba-dodꞌen, na nonoon ra susa, dei fo oras naa ara puasa. ");
INSERT INTO row_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Atahori nda haꞌi teme feuꞌ mbei, fo tanda neu badꞌu mbara manasideꞌ sa. Huu mete ma safe badꞌu a, na teme feuꞌ a kurulululu. No taꞌo naa, badꞌu nenetandaꞌ a boe sika naꞌadꞌuaꞌ. ");
INSERT INTO row_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Onaꞌ naa boe, atahori nda oni tua feuꞌ neu mbaꞌo mbokoꞌ sa. Te hokoꞌ na mbaꞌo a fanggi neuꞌ ena, ma nosi hendiꞌ tuaꞌ a. Dadꞌi tua feuꞌ musi oni neu mbaꞌo feuꞌ boe, naa fo ruꞌa se raꞌatataaꞌ no maloleꞌ!” De Yesus nanori se nae Eni nenorin, feuꞌ. De afiꞌ neꞌebꞌue no nenori mbaraaꞌ. ");
INSERT INTO row_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Leleꞌ Yesus feꞌe olaꞌ no Yohanis ana mana tungga nara, malangga ume hule-oꞌeꞌ esa nema nandaa no Yesus. Atahori naa sendeꞌ lululanggan neu Yesus matan, de noꞌe nae, “Amaꞌ e! Tulun dei! Te au ana feto ngga feꞌe mate ena na. Amaꞌ nema fo tao limam neu e dei, fo ana nasodꞌa baliꞌ.” ");
INSERT INTO row_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesus rena nala ma, no ana mana tungga nara tungga tuteꞌ a atahori naa. ");
INSERT INTO row_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Sia dalaꞌ taladꞌan, ma inaꞌ esa lao tungga no se. Ana mboꞌa-mboꞌaꞌ a raaꞌ nda naloeꞌ no matetuꞌ sa too sanahulu rua ena. Ana duꞌa sia ralan nae, “Sadꞌi au nggama Yesus badꞌun, na, au hai neuꞌ ena.” Naa de ana neu nggama Yesus badꞌun suun. ");
INSERT INTO row_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesus medꞌa, de Ana heoꞌ dean de mete inaꞌ naa. Boe ma, Ana olaꞌ nae, “Ana ngge! Tao manggatee ralam. Te, huu mumuhere tebꞌe-tebꞌeꞌ neu Au, naa de ho hai.” Leleꞌ naa, inaꞌ naa hai neuꞌ ena boe. ");
INSERT INTO row_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Boe ma Yesus se lao rakandoo risiꞌ malangga ume hule-oꞌeꞌ a umen. Losa naa ma, Ana rala neu ma nita mana maꞌaminaꞌ lilii sususaꞌ, ma atahori hetar nggae ei-ei. ");
INSERT INTO row_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Te Yesus nafadꞌe se nae, “Sudꞌi nggae, fo ama baliꞌ leo! Huu anaꞌ ia nda mate sa. Ana sungguꞌ a.” Te ara mali penggo bafa nara mbali Yesus. ");
INSERT INTO row_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Te basa ma, basa atahori ra lao dea reu. Boe ma Yesus nisiꞌ anaꞌ a kaman rala neu, de toꞌu nala liman. Boe ma anaꞌ a nasodꞌa neuꞌ ena. ");
INSERT INTO row_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Atahori rita onaꞌ naa, boe ma ara dui-bꞌengga ndule basa mamanaꞌ, saa fo Yesus taoꞌ naa. ");
INSERT INTO row_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Boe ma Yesus lao nakandoo. Mia dalaꞌ taladꞌan, atahori pokeꞌ rua matutunggaꞌ ro Yesus. Ara nggasi rae, “Mane Daud tititi-nonosin, e! Kasian hai dei!” ");
INSERT INTO row_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesus ume rala neu, boe ma atahori poke ka ruaꞌ ra rema risiꞌ Yesus. De natane se nae, “Hei mimihere tebꞌe-tebꞌeꞌ mae Au uꞌena koasa fo tao nggi mita baliꞌ?” Boe ma rataa rae, “Awii! Amaꞌ afiꞌ mutane fai, te hai mimihere Amaꞌ tebꞌe-tebꞌeꞌ.” ");
INSERT INTO row_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Yesus rena nala boe ma, Ana nggama mata nara, de olaꞌ nae, “Mete ma taꞌo naa, na, dadꞌi tungga hei nemehere mara!” ");
INSERT INTO row_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Yesus olaꞌ basa boe ma, ara rita neuꞌ ena. Te Yesus fee nesenenedꞌaꞌ neu se nae, “Misinedꞌa, e! Afiꞌ mifadꞌe neu atahori esa boe soꞌal saa mana dadꞌiꞌ ia!” ");
INSERT INTO row_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Te ara nda raꞌatataaꞌ rala ao nara sa. De ara laoꞌ ndule mamanaꞌ dui-bꞌengga saa fo Yesus taoꞌ a. ");
INSERT INTO row_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Atahori pokeꞌ ka ruaꞌ ra dea reu boe ma, atahori ra rendi atahori laen esa nisiꞌ Yesus. Atahori naa nda olaꞌ nalaꞌ sa, huu nitu a tao e. ");
INSERT INTO row_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesus nita taꞌo naa ma, Ana parenda nitu a lao hela atahori naa. Nitu a lao hela e ma, atahori naa olaꞌ nalaꞌ neuꞌ ena. Basa atahori hetar sia na titindindiiꞌ a. Ara rae, “Awii! Hita atahori Yahudi nda feꞌe tita onaꞌ ia sa!” ");
INSERT INTO row_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Te atahori Farisi ra nda nau sa. Ara olaꞌ rae, “Weh! Nitu ra malanggan fee koasa fo Ana use-oi hendi nitu ra.” ");
INSERT INTO row_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Basa ma Yesus neu ndule kota ma kamboꞌ hetar, fo nanori sia ume hule-oꞌeꞌ ra. Ana nanori atahori Lamatualain Hara-lii Malolen, ma tao taꞌo bee fo ara dadꞌi atahorin. Ana o tao nahaiꞌ basa hedꞌis mataꞌ-mataꞌ. ");
INSERT INTO row_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yesus nita atahori hetar naa ra ma, Ana kasian se, huu nda ritaꞌ rae tao taꞌo bee sa boe. Nda hambu esa nasalaꞌe se sa boe, de ara onaꞌ bibꞌi lombo nda raꞌena manatadꞌaꞌ sa. ");
INSERT INTO row_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","De Yesus olaꞌ no ana mana tungga nara nae, “Atahori ia ra, onaꞌ osi a buna-bꞌoan. Buna-bꞌoan naeꞌ, te mana tao ues ra nda dai, fo etu-ꞌoru rala basa buna-bꞌoan, fo mbedꞌa neu soka-poleꞌ. ");
INSERT INTO row_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Huu na, ama musi moꞌe sia Tenu osiꞌ a, fo Ana haitua atahori mana tao ues, fo reu raꞌadꞌuru rala buna-bꞌoan.” ");
INSERT INTO row_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Basa naa ma, Yesus noꞌe ana mana tungga nara fo rema raꞌabꞌue. Boe ma Ana fee se koasa fo reu use-oi nitu hetar ma tao raꞌahahaiꞌ atahori mamahedꞌiꞌ mataꞌ-mataꞌ. ");
INSERT INTO row_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ana mana tunggan ka sanahulu ruaꞌ fo Ana denuꞌ ra nara nara, naeni: Ka esan, naran Simon (fo roꞌe na rae, ‘Petrus’) boe ma odꞌin, naran Anderias, ma, Yakobis, no odꞌin, naran Yohanis (ruꞌa se, Sabadeus ana nara) ");
INSERT INTO row_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Boe ma Filipus, no Bartolomeos. Ma Tomas, no Mateos (mana edꞌa bea). Yakobis (Alpius anan), no Tadius. ");
INSERT INTO row_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon (mana tungga partei Selot), boe ma Yudas Iskariot (dei fo mana seo hendi Yesus). ");
INSERT INTO row_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","6","Basa naa ma, Yesus denu ana mana tungga atahori ka sanahulu ruaꞌ ra, Ana parenda se nae, “Au denu nggi mii sia hita atahori Yahudi nara, huu hetar mia hita atahori nara nda tungga Lamatuaꞌ dalan no matetuꞌ sa. Ara onaꞌ, bibꞌi lombo mana mopoꞌ ra. Huu naa, ama afiꞌ mii sia atahori nda Yahudi ra sa ma atahori Samaria ra. ");
INSERT INTO row_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Mii mifadꞌe hita atahori Israꞌel nara mae, ‘Fai na losa de basa atahori bisa dadꞌi Lamatualain atahorin ena.’ ");
INSERT INTO row_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mii tao miꞌihahaiꞌ atahori mamahedꞌiꞌ ra, mii tao misodꞌa baliꞌ atahori mates ra, tao miꞌihahaiꞌ atahori mamahedꞌi kusta, ma use-oi hendi nitu ra. Lamatuaꞌ pala-banggi fee nggi naen seli ena, te Ana nda noꞌe baliꞌ saa sa boe. Dadꞌi ia naa ama musi mii fo pala-banggi naeꞌ fee neu atahori laen fai, akaꞌ naa afiꞌ moꞌe baliꞌ saa-saa sia se boe. ");
INSERT INTO row_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ama laoꞌ rou-rou, e. Nda parlu mendi doiꞌ sa, ");
INSERT INTO row_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","lepa-ngges, bua-baꞌu seluaoꞌ, sapatu, do teteas. Huu atahori mana tao ues, nandaa hambu eni hahambun fo nasodꞌa. ");
INSERT INTO row_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Mete ma misiꞌ kota esa, do, kamboꞌ esa, na, ama sangga atahori mana naena rala maloleꞌ mana nau simbo nggi. Fo leo sia naa, losa ama lao hela mamanaꞌ naa. ");
INSERT INTO row_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Mete ma misiꞌ atahori sa umen, na, olaꞌ mae, ‘Sodꞌa-moleꞌ! Lamatuaꞌ fee nggi papala-babꞌanggiꞌ.’ ");
INSERT INTO row_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Mete ma atahori sia ume a simbo nggi no maloleꞌ, ama moꞌe fo Lamatuaꞌ fee se papala-babꞌanggiꞌ. Te mete ma ara nda simbo nggi sa, na, Lamatuaꞌ o nda fee se papala-babꞌanggiꞌ sa boe. Te papala-babꞌanggiꞌ baliꞌ neti nggi. ");
INSERT INTO row_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Mete ma atahori nda nau rena nggi sa, na, lao hela ume naa, do, kota naa, basa naa nggafur hendi afu sia ei mara, fo dadꞌi tatandaꞌ oi, ara nda nau rena saa, de, ara lemba-dꞌoi ao nara ");
INSERT INTO row_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Mete ma losa fai nggero-furiꞌ fo Lamatualain huku-dꞌoki atahori sia raefafoꞌ, na huku-dokiꞌ soaꞌ neu atahori nda mana nau simbo nggi sa, beran lenaꞌ huku-dokiꞌ neu Sodꞌom no Gomora fo deꞌulaka nara manaseliꞌ a. Te misinedꞌa, e! Te dei fo Ana natudꞌa huku-dokiꞌ beran seli soaꞌ neu atahori nda mana nau simbo nggi sa!” ");
INSERT INTO row_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Misinedꞌa, e! Te Au denu nggi ia, onaꞌ Au fee bibꞌi lombo nisiꞌ busa fui deꞌulakaꞌ a taladꞌan. Huu naa, ama musi pake dudꞌuꞌat onaꞌ mengge mahineꞌ. Boe ma rala mara musi ndoos onaꞌ mbui lunda nda mana sangga dala deulakaꞌ sa. ");
INSERT INTO row_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Te besa-besa, o! Dei fo atahori tao doidꞌoso nggi. Dei fo ara nore nggi misiꞌ mamana nggero dedꞌeat agama. Ma dei fo ara filo nggi sia ume hule-oꞌe nara. ");
INSERT INTO row_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Dei fo ara nore nggi mii mitaa sia hofernor no maneꞌ a, huu ama tungga Au. Te ama musi pake kakaꞌeꞌ naa fo mifadꞌe Hara-lii Malole ngga neu se. No taꞌo naa, atahori nda mana rahine Lamatuaꞌ sa o, hambu rena soꞌal Au boe. ");
INSERT INTO row_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Te mete ma atahori nore rendi nggi onaꞌ naa, na, afiꞌ mimitau mae, ‘Dei fo au olaꞌ ae saa?” Do, ‘Dei fo, au utaa ae, saa?’ Sudi boe dudꞌuꞌa taꞌo naa, huu losa fain, dei fo hei Amam sia sorga nafadꞌe saa fo ama musi olaꞌ. ");
INSERT INTO row_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Leleꞌ naa, saa fo ama olaꞌ naa, nda miaꞌ a hei e sa, te Dula-dalen nafadꞌe nggi saa fo ama olaꞌ a. ");
INSERT INTO row_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Hei mete neuꞌ ena, te dei fo sia ume sa rala, mete ma hambu atahori ramahere Au, dei fo toronoo nara sangga dalaꞌ fo fee atahori tao risa e. Ma mete ma anaꞌ sa namahere, dei fo aman tao nisa e. Mete ma amaꞌ no inaꞌ sa ramahere, dei fo ana bonggin tao nisa se. ");
INSERT INTO row_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Mete te, dei fo basa atahori binci nggi seli, huu ama tungga Au. Te, atahori mana naꞌatataaꞌ nakandoo losa babꞌasan, dei fo Lamatualain fee ne masoi-masodꞌaꞌ. ");
INSERT INTO row_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Mete ma atahori tao doidꞌoso nggi sia kota esa, na, mela misiꞌ kota laen. Tebꞌe! Au ia, Atahori Matetuꞌ a. Dei fo ama nda feꞌe lao ndule basa kota Israꞌel sa, te Au baliꞌ uma ena. ");
INSERT INTO row_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Atahori ra biasa fee hadꞌa-hormat neu meser esa, lenaꞌ ana dedꞌenu nara. Ma atahori fee hadꞌa-hormat neu malangga esa, lenaꞌ ana mana tao ues nara. ");
INSERT INTO row_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Mete ma ana dedꞌenuꞌ esa nanori fo mahinen onaꞌ meser na, ana nae naa dai ena. Ma mete ma ana mana tao ues naa nanori fo mahinen onaꞌ malanggan, na, ana o nae naa dai ena boe. Dadꞌi misinedꞌa, e! Mete ma atahori roꞌe tenu umeꞌ a ena rae, ‘Ho ia, Balsebul, naeni nitu ra malanggan!’ Na, tantu ume isi nara o hambu naraꞌ nda maloleꞌ lenaꞌ sa fai.” ");
INSERT INTO row_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Dadꞌi ama afiꞌ mimitau atahori mana labꞌan nggi. Te saa fo atahori tao raꞌafuniꞌ, dei fo basa atahori rita boe. ");
INSERT INTO row_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Saa fo Au unori neu mesaꞌ nggi, dei fo ama musi mii mifadꞌe neu basa atahori. Boe ma saa fo Au ufadꞌe neenee, dei fo ama musi mii mifadꞌe ndule basa mamanaꞌ ra. ");
INSERT INTO row_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Afiꞌ mimitau atahori, te ara bisa ramateꞌ atahori, te nda bisa tao ralutu atahori ao samana nara sa. Naa de, ama musi mimitau Lamatualain, huu naꞌena koasa fo nggari atahori ao sisin no samanan nisiꞌ tasi ai mana mbila roroo nakandooꞌ a. ");
INSERT INTO row_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Dadꞌi tao manggatetee rala mara. Atahori seo mbui randak sia pasar felin mbeiꞌ a. Te nda hambu esa tudꞌa fo mate sa boe, mete ma Amam mana sia sorga nda nau sa. ");
INSERT INTO row_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Hei Amam sia sorga o tao mataꞌ neu nggi losa dala-dala ana dikiꞌ ra. Langga fulu mara dedesi nara o, Ana nahine ena. ");
INSERT INTO row_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","De ama afiꞌ mimitau! Huu Lamatualain nilei nggi mafeliꞌ lenaꞌ basa mbui randak ra.” ");
INSERT INTO row_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Basa ma Yesus olaꞌ fai nae, taꞌo ia, “Atahori mana nambarani nataa sia atahori matan sia raefafoꞌ ia nae eni nahine Au, dei fo Au o utaa sia Ama Ngga matan sia sorga ae, ‘Eni ia, Au atahori ngga.’ ");
INSERT INTO row_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Te atahori mana nafanii Au sia atahori matan nae, eni nda nahine Au sa, dei fo Au o ufadꞌe Ama ngga sia sorga ae, ‘Au nda uhine atahori ia sa.’” ");
INSERT INTO row_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Hei afiꞌ duꞌa mae, Au uma endi sodꞌa-moleꞌ sia raefafoꞌ ia. Te Au uma tao atahori esa balabꞌan no esa. ");
INSERT INTO row_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Au raefafoꞌ uma ia, tungga saa fo Lamatuaꞌ mana ola-ola nara olaꞌ memaꞌ rae, ‘Dei fo ana touꞌ labꞌan aman, ana inaꞌ labꞌan inan, ma ana feto feus labꞌan ina arin, ");
INSERT INTO row_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Te ume isiꞌ ra esa musu no esa.’ ");
INSERT INTO row_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","De atahori mana nae tungga Au tebꞌe-tebꞌeꞌ, musi sue Au lenaꞌ basa e; lenaꞌ ina-aman ma lenaꞌ ana nara. Te hokoꞌ na, atahori naa nda nandaa dadꞌi Au atahori ngga sa. ");
INSERT INTO row_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Huu atahori mana nae tungga Au, te nda nau lemba susa-sonaꞌ sa, na nda nandaa dadꞌi Au atahori ngga sa. ");
INSERT INTO row_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Atahori mana sadꞌia mate huu ana tungga Au, dei fo ana hambu nasodꞌa nakandoo no Lamatuaꞌ. Te atahori mana nauꞌ a nasodꞌa soaꞌ neuꞌ a aon, dei fo masodꞌan, mopo hendiꞌ e neuꞌ ena!” ");
INSERT INTO row_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Atahori mana simbo nggi no maloleꞌ, eni o simbo Au boe. Ma atahori mana simbo Au, ana o simbo Lamatualain mana denu Auꞌ a. ");
INSERT INTO row_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Atahori mana simbo Lamatualain mana ola-olan, huu ana olaꞌ soꞌal Lamatuaꞌ, dei fo Lamatuaꞌ bala-bꞌae e onaꞌ Ana bala-bꞌae mana ola-olan esa. Boe ma atahori mana simbo atahori rala ndoos esa, huu atahori naa tungga tebꞌe-tebꞌeꞌ Lamatuaꞌ hihii-nanaun, dei fo Lamatuaꞌ bala-bꞌae e onaꞌ Ana bala-bꞌae atahori rala ndoos esa. ");
INSERT INTO row_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Atahori mana simbo ana diki anaꞌ esa huu ana tungga Au, dei fo Lamatuaꞌ bala-bꞌae e. Mae atahori fee akaꞌ oe nggalas esa o, Lamatualain nda liliiꞌ e sa.” ");
INSERT INTO row_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Leleꞌ Yesus helu-fuli basa neu ana mana tungga ka sanahulu rua nara, boe ma Ana neu ndule kambo-kamboꞌ sia nusaꞌ naa, de nanori atahori ma nafadꞌe Lamatualain Hara-lii Malaolen. ");
INSERT INTO row_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Leleꞌ naa, Yohanis sia bui rala ena. Leleꞌ ana rena basa saa fo Yesus taoꞌ ra, ma ana denu ana mana tungga nara reu ratane Yesus rae, ");
INSERT INTO row_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Lamatualain helu-fuli memaꞌ eniꞌ a lele uluꞌ a nae, Eni nae haitua Kristus nema fo fee masodꞌaꞌ neu hita atahori Yahudi. Amaꞌ ia, Kristus, do? Do, hai musi mihani atahori laen fai? Boe ma reu ratane Yesus. ");
INSERT INTO row_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Rena taꞌo naa, ma Yesus nataa nae, “Hei rena ma mita no ao mara ena. De baliꞌ, fo mifadꞌe Aꞌa Yohanis mae, basaꞌ e dadꞌi onaꞌ saa fo Lamatualain mana ola-olan Yesaya suraꞌ hela ena, nae. ");
INSERT INTO row_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Atahori pokeꞌ, nita baliꞌ. Atahori mamaluꞌuꞌ, fela fo laoꞌ. Atahori mamahedꞌi kusta, meu neuꞌ ena. Atahori mbakeꞌ, rena baliꞌ boe. Atahori mates, nasodꞌa baliꞌ Atahori mana tudꞌa-loloeꞌ ra, rena Hara-lii Maloleꞌ. ");
INSERT INTO row_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Dadꞌi taꞌo ia: mii mifadꞌe aꞌa Yohanis, mae ana onton mete ma ana namahere nakandoo neu Au. Huu dei fo Lamatualain fee papala-babꞌanggiꞌ neu atahori mana namahere tebꞌe-tebꞌeꞌ neu Au!” ");
INSERT INTO row_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Leleꞌ Yohanis ana mana tungga nara baliꞌ, boe ma Yesus olaꞌ no atahori hetar soꞌal Yohanis nae, “Leleꞌ hei mii sangga Yohanis sia mamana maꞌafuniꞌ naa, hei duꞌa mae mindaa mo atahori mataꞌ onaꞌ bee? Neꞌo hei nda mindaa mo atahori mana male-maleꞌ, onaꞌ oo mana uli-faeꞌ tungga anin sa to? ");
INSERT INTO row_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ma neꞌo hei nda mita atahori mana pake bua-baꞌu mafelit sa, huu atahori mataꞌ naa leo siaꞌ a maneꞌ umen! ");
INSERT INTO row_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Dadꞌi hei mita atahori mataꞌ bee sia naa? Hei duꞌa na hei mii sangga Lamatualain mana ola-ola nara? Tebꞌe! Te eni, mana ola-ola manaseliꞌ nenenefadꞌe memaꞌ ena. ");
INSERT INTO row_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Huu Lamatualain Susura Meumaren sura memaꞌ soꞌal Yohanis nae, ‘Rena! Au denu atahori ngga, fo neu soi dalaꞌ fee neu Nggo.’ ");
INSERT INTO row_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Rena malolole, o! Sia raefafoꞌ ia, nda hambu atahori esa, manaseliꞌ lenaꞌ Yohanis sa. Te mia basa atahori mana nataa Lamatualain onaꞌ Maneꞌ, atahori mana maꞌabꞌuit a manaseliꞌ lenaꞌ Yohanis ena. ");
INSERT INTO row_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Eniꞌ a mia Yohanis soꞌu ue-tataos na losa ia nema, atahori hetar dadꞌi Lamatualain atahorin ena. Te ruma duꞌa sala, de ratati fo raꞌasusuuꞌ atahori masoꞌ dadꞌi Lamatualain atahorin. Ma ruma ratati labꞌan Lamatualain atahorin boe. ");
INSERT INTO row_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Losa Yohanis Mana Saraniꞌ a neneman, hita atahori Yahudi biasa tasodꞌa tungga baꞌi Musa no Lamatualain mana ola-olan hohoro-lalanen. ");
INSERT INTO row_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Dadꞌi mimihere neuꞌ a Au leo! Yohanis naa, naeni Elia fo Lamatualain mana ola-olan nafadꞌe memaꞌ neneman ena. ");
INSERT INTO row_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Dadꞌi mana nau nahine musi rena malolole, o! ");
INSERT INTO row_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Au ae fee nekendandaaꞌ fo ama bubꞌuluꞌ, atahori aleꞌ ia ra, atahori mataꞌ saa. Huu sira, onaꞌ ana dikiꞌ mana nggua-nggua sia pasar. Ara akaꞌ eki-randu ro nonoon nara rae, ");
INSERT INTO row_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Woi! hai fuu mindaa sulin, te hei nda lendo mimihoꞌo sa. Ma hai sodꞌa sosodꞌa sususaꞌ, te hei nda nggae sa.’ ");
INSERT INTO row_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Hei ia onaꞌ ana dikiꞌ ra mana nda ramedꞌa rae dai ena sa. Leleꞌ Yohanis nema, ana hiiꞌ a puasa, ma nda ninu anggor sa. Te atahori cap e rae, ‘Nitu taoꞌ!’ ");
INSERT INTO row_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Te Au aleꞌ ia, Au, Atahori Tebe-tebꞌe, uma ena. Au nda puasa sa, ma Au inu anggor. Te atahori cap Au rae, ‘Eni, memaꞌ atahori mana bare-naꞌo! Mamafun seli boe! Ana neu naꞌabꞌue no mana edꞌa bea ra! Partei sa no atahori nda papakeꞌ ra sa! Nda nahine aon sa ena! Te ama mete neuꞌ ena e, Au oꞌola ngga ia, e! Lamatuaꞌ mahinen nenenitaꞌ sia atahori nara masodꞌa nara.” ");
INSERT INTO row_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Basa ma, Lamatuaꞌ Yesus ai atahori mana leo sia kamboꞌ hira. Ana tao manadadꞌiꞌ hetar lenaꞌ sia naa ena, te ara nda nau lao hela sala-kilu nara fo tungga baliꞌ Lamatuaꞌ dala masodꞌa ndoo-tetun sa. ");
INSERT INTO row_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Yesus ai se nae, “Hei atahori Korasin ma atahori Betsaida ra! Besa-bꞌesa e! Dei fo ama hambu sosoeꞌ! Au tao manadadꞌiꞌ mataꞌ-mataꞌ sia mata mara ena, te ama nda nau mimihere Lamatualain sa. Te hei ia ra, atahori Yahudi, fo mana mitaa mae hei mihine Lamatuaꞌ. Te onaꞌ saa-saa manadadꞌiꞌ fo Au tao sia kambo mara, dadꞌi naꞌahuluꞌ sia nusa deꞌulakaꞌ onaꞌ kota Tirus no kota Sidꞌon dei na, neꞌo doo basa ia ena atahori sia naa ra doaꞌ memaꞌ, ma lao hela sala-kilu nara fo tungga Lamatuaꞌ. Ma neꞌo ara pake bua-baꞌu sususaꞌ ena, ma tao afu sia langga nara fo dadꞌi tatandaꞌ oi, sira fale rala nara mia sala-kilu nara. Tao-tao te atahori Tirus ro atahori Sidꞌon ia, nda atahori Yahudi mana rataa rae, sira rahine Lamatuaꞌ. ");
INSERT INTO row_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Tebꞌe! Dei fo hei mete neuꞌ ena! Mete ma Lamatuaꞌ naꞌetuꞌ basa atahori dedꞌeat nara, na, atahori Tirus ro atahori Sidꞌon ra huku-dokiꞌ nara nggafat lenaꞌ hei huku-doki mara. ");
INSERT INTO row_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Hei atahori Kapernaum! Besa-bꞌesa, e! Ama afiꞌ duꞌa mae, dei fo Lamatuaꞌ soꞌu nggi sorga mii. Hokoꞌ o! Dei fo Lamatuaꞌ nggari hendi nggi misiꞌ naraka rala mii! Onaꞌ manadadꞌiꞌ fo Au tao sia kambo mara dadꞌi naꞌahuluꞌ sia nusa deꞌulakaꞌ onaꞌ kota Sodꞌom, neꞌo Lamatualain nda parlu tao nalutu nusa deꞌulakaꞌ naa sa. Te mete ma atahori Sodꞌom ra rita manadadꞌi naa ra, neꞌo ara lao hela deꞌulaka nara ena. ");
INSERT INTO row_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Tebꞌe! Dei fo ama mete neuꞌ ena! Mete ma Lamatuaꞌ naꞌetuꞌ basa atahori ra dedꞌeat nara, na, atahori Sodꞌom ra huku-doki nara feꞌe nggafat lenaꞌ hei huku-doki mara!” ");
INSERT INTO row_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Olaꞌ basa ma, Yesus hule-oꞌe nae, “Amaꞌ! Amaꞌ mana dadꞌi Malangga sia lalai no raefafoꞌ. Au oꞌe makasi nae-nae, huu Amaꞌ tatana mala ndoo-tetuꞌ a mia atahori mana tao ao nara onaꞌ atahori mahineꞌ, ma mana koaoꞌ ra. Te Amaꞌ soi basa dalaꞌ naa ra fee neu atahori ana dikiꞌ ra, ma atahori mana maloe-madꞌae rala nara. ");
INSERT INTO row_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tebꞌe, Amaꞌ! Huu naa mana tao Amaꞌ ralan namahoꞌo!” ");
INSERT INTO row_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Hule-oeꞌ basa onaꞌ naa, ma Yesus nafadꞌe atahori sia naa ra nae, “Rena malolole, o! Au Ama ngga sia sorga fee basa koasa neu Au. Mana nahine Au no malole, naeni akaꞌ Ama ngga. Ma mana nahine Ama ngga no maloleꞌ, naeni akaꞌ Amaꞌ Anan, naeni Au. Ma Au pili atahori laen ra, fo rafadꞌe neu se, naa fo ara rahine E no malole. ");
INSERT INTO row_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Basa hei mana bengge tao ues mitaꞌ mamate mara, ima tungga Au! Basa hei mana lemba-misaa beraꞌ, ima misiꞌ Au ia! Ima hahae ao mara. ");
INSERT INTO row_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mete ma ama simbo Au nenori ngga fo laoꞌ miꞌibꞌue mo Au, na, hita ia ra onaꞌ sapi mana hohombuꞌ rua lea raꞌabꞌue tali hohombuꞌ sa. Hu Au ia, rala maloleꞌ, ma Au ia, rala maloe-madꞌaeꞌ. Mete ma hei tungga Au, na, ama dadꞌi maꞌadꞌere baliꞌ. ");
INSERT INTO row_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Huu Au nenori ngga naa, nda susa sa. ma Au parenda ngga, nda namabꞌera sa.” ");
INSERT INTO row_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Lao esa, nandaa no atahori Yahudi ra fai hahae tao ues na, Yesus no ana mana tungga nara laoꞌ tungga atahori osin. Ana mana tungga nara ndoe, de ara etu rala are nggandum mbuleꞌ de raa lao-laoꞌ. ");
INSERT INTO row_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Sia naa, hambu atahori hira mia partei agama Farisi feꞌe toꞌu rahereꞌ adat Yahudi. Rita Yesus ana mana tungga nara tao taꞌo naa, ma ara ai E rae, “Ana mana tungga mara etu are nggandum nandaa no fai hahae tao ues! Afiꞌ taꞌo naa! Te naa nalena-langga neu hita hohoro lalanen.” ");
INSERT INTO row_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","Te Yesus nataa nae, “Taꞌo bee, o! Hei nda misinedꞌa baꞌi Daud dudꞌuit na sa, do? Baꞌi Daud no ana mana tungga nara ndoe de tei nara radꞌiro-dꞌoro huu ndoe rala seli. Boe ma ana nisiꞌ Lamatualain Lalaa hule-oꞌen rala, de haꞌi roti fo malangga agama ra fee neu Lamatuaꞌ ena, fo ara raa. Tao-tao te akaꞌ malangga agama ra bole raa roti naa. Atahori laen nda bole raa sa. Basa de baꞌi Daud se raa, te atahori nda rae ara sala sa. Hei onaꞌ nda baca mihine Lamatualain Susura Meumaren sa! ");
INSERT INTO row_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Te sia naa o nenesuraꞌ soꞌal malangga agama ra tao ues mete-seꞌu sia ume hule-oꞌe, nandaa no fai hahae tao ues. Te ara nda hambu salaꞌ saa sa boe. ");
INSERT INTO row_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Rena, o! Dalahulun, ume hule-oꞌe na pantin, te aleꞌ ia hambu dalaꞌ sa pantin lenaꞌ, naeni, Au, Atahori Matetuꞌ ia. ");
INSERT INTO row_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Sia Lamatualain Susura Meumaren, Lamatualain nae, ‘Au hihii-nanau ngga taꞌo ia: Au atahori nggara musi ratudꞌu susueꞌ esa no esa. Mete ma ara nda tao taꞌo naa sa, na, banda tutunu-hohotuꞌ fo ara rendi fee Auꞌ naa, nda naꞌena sosoa-ndandaaꞌ saa sa boe.’ Na, mete ma ama mihine malolole Lamatuaꞌ oꞌolan, neꞌo ama nda fee salaꞌ neu ana mana tungga ngga ra sa. Te ara nda tao sala saa sa boe! ");
INSERT INTO row_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Te Au ia, Atahori Matetuꞌ a. Au uꞌena hak uꞌetuꞌ ae, atahori bole tao saa nandaa no fai hahae tao ues.” ");
INSERT INTO row_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Basa naa ma Yesus lao hela mamanaꞌ naa, de nisiꞌ sira ume hule-oꞌen. ");
INSERT INTO row_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Sia naa, hambu touꞌ esa liman seri maꞌamateꞌ. Atahori Farisi naa ra rae sangga dalaꞌ fo fee salaꞌ neu Yesus, mete ma Ana tao nahaiꞌ atahori naa, nandaa no fai hahae tao ues. De ara ratane rae, “Tungga hita agaman hohoro-lalanen, atahori bole tao nahaiꞌ atahori nandaa no fai hahae tao ues, do hokoꞌ?” ");
INSERT INTO row_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","De Yesus nataa nae, “Mete ma atahori sa bibꞌin esa tudꞌa ndolaꞌ rala neu, nandaa no fai hahae tao ues, neꞌo tenu bibꞌiꞌ a neu oꞌo bibꞌi a dea neu, to? ");
INSERT INTO row_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Naa! Lamatuaꞌ sue atahori lenaꞌ tenu bibꞌiꞌ a sue bibꞌin. Huu naa, atahori bole tao dala maloleꞌ nandaa no fai hahae tao ues.” ");
INSERT INTO row_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Boe ma Ana olaꞌ no atahori lima maꞌamate seseriꞌ naa nae, “Aꞌa, e! Loo limam nema!” Boe ma ana loo lima maꞌamate seseriꞌ naa, boe ma liman hai neuꞌ ena, onaꞌ liman seriꞌ a. ");
INSERT INTO row_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Rita taꞌo naa ma, atahori Farisi ra ramue. De ara fela lao hela ume hule-oꞌe a, boe ma ara reu rala ralaꞌ sa rae, “Ata musi sangga dalaꞌ fo tisa E!” ");
INSERT INTO row_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Te Yesus bubꞌuluꞌ dudꞌuꞌa deꞌulaka nara, naa de Ana lao nisiꞌ mamanaꞌ laen. Atahori hetar tungga E, ma Ana tao nahaiꞌ basa atahori mamahedꞌiꞌ ra ");
INSERT INTO row_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Te Ana ai se nae, “Ama afiꞌ mifadꞌe atahori laen soꞌal Au.” ");
INSERT INTO row_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ana tao taꞌo naa tungga saa fo Lamatualain nafadꞌe neu mana ola-olan Yesaya nae, ");
INSERT INTO row_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Mete dei! Eni ia, Au Atahori dedꞌenu ngga fo tengga alaꞌ a ena. Au sue E, ma Au umuhoꞌo ukundoo o E. Dei fo Au fee Dula-dale ngga neu E, fo neu nanori atahori sia basa nusaꞌ ra soꞌal Au dala masodꞌa ndoos ngga. ");
INSERT INTO row_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ana nda toꞌo tendan sa. Ana nda soꞌu-soꞌu aon sa. ");
INSERT INTO row_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ralan maloleꞌ. Ana nda naꞌasususaꞌ atahori sa. Ana nda helu tiku hau mana naeꞌa tiku sa. Ana nda fuu nisa lambu anaꞌ mana naeꞌa mate sa. Ana nanori atahori nakandooꞌ a, losa dodꞌoo ma basa nusaꞌ ra rahine de tungga Lamatuaꞌ dala masodꞌa ndoo-tetun boe. ");
INSERT INTO row_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Dei fo atahori mia basa nusaꞌ ra ramahere neu E, huu rahine rae Eni, seka.” ");
INSERT INTO row_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Lao esa, atahori ra rendi atahori nitu taoꞌ esa nisiꞌ Yesus. Atahori naa matan pokeꞌ ma nda olaꞌ nala sa. Boe ma Yesus oi hendi nitu de naꞌahahaiꞌ e. Boe ma, atahori naa nita ma olaꞌ neuꞌ ena. ");
INSERT INTO row_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Rita taꞌo naa, ma basa atahori titindindiꞌ a. Ara ola-olaꞌ rae, “Mbei ma Eni ia, Daud tititi-nonosin, fo Lamatuaꞌ mana ola-ola nara suraꞌ memaꞌ mia lele uluꞌ a. Eni ia, neꞌo Atahori fo hita nea-neaꞌ a!” ");
INSERT INTO row_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Te leleꞌ atahori Farisi ra rena rala, ma ara nda simbo sa. Boe ma ara ola-olaꞌ rae, “Woe! Atahori ia bisa oi hendi nitu, huu nitu ra malanggan Balsebul mana fee E koasa.” ");
INSERT INTO row_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Te Yesus nahine atahori Farisi ra oꞌolan. Boe ma nafadꞌe se nae, “Hei oꞌolam naa, nda naꞌena sosoa-ndandaaꞌ sa! Mete ma sia nusaꞌ esa, rauinggu nara rafetu-raparu, taꞌo bee fo nusaꞌ naa naꞌatataaꞌ! Onaꞌ naa boe mete ma atahori sia kota esa, do sia ume sa rala, esa natofa no esa, neꞌo ara sea-saranggaa losa rambalulutu, o! ");
INSERT INTO row_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Dadꞌi mete ma nitu ra bamusuꞌ ma esa oi esa, na, sira malanggan nda toꞌu parendaꞌ doo-doo sa ena! ");
INSERT INTO row_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Misinedꞌa, e! Hei atahori mara o oi rahine nitu ra boe. Ara oi rendiꞌ nitu a koasan, do? Hokoꞌ! Dadꞌi ama afiꞌ olaꞌ leli mae, Au oi nitu ra endiꞌ nitu a koasan. Dei fo hei atahori mara raꞌetuꞌ ao nara rae, saa fo ama runduꞌ a, nda tebꞌe sa. ");
INSERT INTO row_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Te mete ma Au tebꞌe-tebꞌeꞌ oi nitu endiꞌ koasa mia Lamatuaꞌ Duladꞌalen, na natudꞌu nae, Lamatuaꞌ memaꞌ Maneꞌ mana sia hei mata mara ena. ");
INSERT INTO row_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Mete ma atahori rae rema ramanaꞌo sudꞌiꞌ a saa sia atahori maꞌadꞌereꞌ sa umen, na, ana musi futu-paꞌa nahereꞌ atahori naa dei. Dei fo, ana namanaꞌo nala atahori naa sudꞌiꞌ a saa nara. ");
INSERT INTO row_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Misinedꞌa malolole! Te atahori nda mana partei no Au sa, bamusuꞌ no Au. No atahori nda mana tao afiꞌ neu Au ue-tatao ngga sa, ana taoꞌ a nemue-neanggiꞌ. ");
INSERT INTO row_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Dadꞌi rena malolole Au oꞌola ngga ia! Lamatualain sadꞌia fee ambon neu atahori sala-kilu nara ena. Ma mete ma atahori olaꞌ nda malole soꞌal atahori laen, na, Lamatualain feꞌe sadꞌia fee ambon neu e. Te mete ma atahori nambarani olaꞌ nda maloleꞌ soꞌal Lamatualain Dula-dale Meumaren, na Lamatualain nda fee ambon neu sala-kilun sa. ");
INSERT INTO row_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Mete ma atahori olaꞌ deꞌulakaꞌ soꞌal Au, Atahori Tebꞌeꞌ-tebꞌeꞌ ia, Lamatuaꞌ sadꞌia fee ambon neu e. Te mete ma atahori olaꞌ naꞌamuti-naꞌamuu labꞌan Lamatuaꞌ Duladꞌale Meumaren, na, Lamatualain nda fee ambon neu salan naa sa losa fai mateteꞌen!” ");
INSERT INTO row_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Basa ma Yesus olaꞌ nakandoo neu atahori Farisi ra nae, “Dudꞌuꞌa malolole! Hau hu maloleꞌ nabꞌoa boa maloleꞌ. Te hau hu nda maloleꞌ a sa nabꞌoa boa nda maloleꞌ sa, Hu mia hau a boan, atahori bisa bubꞌuluꞌ rae, hau huuꞌ na, maloleꞌ do hokoꞌ. ");
INSERT INTO row_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Te hei ia ra onaꞌ mengge mana peko-lelekoꞌ! Ama nda bisa olaꞌ dala-dala maloleꞌ ra sa. Huu saa nenembedaꞌ sia atahori ralan, na, ana kalua tungga bafan. ");
INSERT INTO row_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Atahori maloleꞌ, tantu olaꞌ dala maloleꞌ, huu hambu dala-dala maloleꞌ nenembedaꞌ sia ralan. Te atahori deꞌulakaꞌ, olaꞌ a deꞌulakaꞌ, hu hambu dala-dala deꞌulakaꞌ nenembedaꞌ sia ralan. ");
INSERT INTO row_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Mimihere neu Au! Te dei fo losa fai mateteꞌen, Lamatualain paresaꞌ basa atahori tatao-nonoꞌin. Leleꞌ naa, atahori esa-esaꞌ musi nataa eni dedꞌea-oꞌolan mana nda ma nggunaꞌ a sa. ");
INSERT INTO row_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Dadꞌi maꞌabꞌebꞌesa, e! Te dei fo Lamatualain timba-tai dedꞌea-oꞌola mara, no naꞌetuꞌ nae, ama hambu huku-dokiꞌ do hokoꞌ.” ");
INSERT INTO row_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Rena Yesus olaꞌ naꞌo naa ma, hambu meser agama hira ro atahori Farisi ra roꞌe mbali E rae, “Ama Meser! Hai mae mita Amaꞌ tao manadadꞌiꞌ, fo dadꞌi bukti oi, Amaꞌ koasan tebꞌe-tebꞌeꞌ mia Lamatualain.” ");
INSERT INTO row_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Te Yesus bua se nae, “Wuih! Hei atahori aleꞌ ia, nda nau tao rerenaꞌ neu Lamatuaꞌ sa! Ama mihineꞌ a tao deꞌulakaꞌ! Mae ama moꞌe manadadꞌiꞌ o, Au nda fee sa. Huu feꞌesaꞌan Lamatuaꞌ fee manadadꞌiꞌ nendiꞌ mana ola-olan Yunus. Naa dai ena! ");
INSERT INTO row_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yunus leo rereloꞌ telu, ma tetembaꞌ telu mia uꞌu monaeꞌ a ambun rala. Au o onaꞌ naa boe, Atahori Tetebꞌes ia. dei fo Au leo rereloꞌ telu, ma tetembaꞌ telu sia lua fatuꞌ, atahori mates ra mamanan. ");
INSERT INTO row_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Dei fo sia fai mateteꞌen, mete ma Lamatuaꞌ dadꞌi mana nggero-furi, na, atahori Niniwe ra rambariiꞌ dadꞌi sakasii fo rundu nggi rae, ‘Basa hei ia, nggoaꞌ!’ Feꞌesaꞌan, atahori Niniwe ra rena Lamatuaꞌ mana ola-olan Yunus, de ara doaꞌ ma lao hela sala-kilu nara. Te hei hokoꞌ. Tao-tao te, aleꞌ ia hambu Atahori sia hei taladꞌa mara manaseliꞌ lena Yunus, naeni Au ia. Te ama nda nau tao afiꞌ neu Au mbei sa boe. ");
INSERT INTO row_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Dei fo sia fai mateteꞌen, mete ma Lamatuaꞌ dadꞌi mana nggero-furi, na, ina mane Seba mia seriꞌ ona o, nambarii dadꞌi sakasii. Ana dudꞌu fo rundu basa mana masodꞌa aleꞌ ia nae, ‘Basa hei ia ra, nggoaꞌ, e!’ Feꞌesaꞌan, ina maneꞌ a nema mia dodꞌoo fo nita no mata aon mane Soleman mahinen. Tao-tao te, aleꞌ ia hambu Atahori sia taladꞌa mara manaseliꞌ lenaꞌ mane Soleman, naeni Au ia. Te ama nda tao afiꞌ mbei neu Au sa boe.” ");
INSERT INTO row_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Mete ma nitu neneoi hendiꞌ mia atahori esa, nitu a neu nisiꞌ mamana rouꞌ fo sangga mamana hahaeꞌ. Te ana nda hambu mamana maloleꞌ sa. ");
INSERT INTO row_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Boe ma ana dudꞌuꞌa nae, “Hee! Nda hambu mamanaꞌ sa, de malole lenaꞌ au baliꞌ isiꞌ atahori fo feꞌesaꞌan au leo miaꞌ a.’ Basa ma ana baliꞌ, ma nita mamanaꞌ naa, meuꞌ ma nene tao maloleꞌ ena. ");
INSERT INTO row_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Boe ma nitu naa neu noꞌe nonoon hitu, deꞌulaka nara seli lenaꞌ e fai. Boe ma basa se reu leo sia atahori naa, ma ara poko-paru randaa e. Dadꞌi aleꞌ ia, atahori naa masodꞌan deꞌulakan seli. Onaꞌ naa boe, atahori sia fai-fai maꞌabꞌuiꞌ ia ra.” ");
INSERT INTO row_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Leleꞌ naa, Yesus feꞌe olaꞌ no atahori hetar. Boe ma maman no odꞌi nara rema rae randaa ro E. Ara riirii mia ume deaꞌ de denu atahori reu roꞌe E. ");
INSERT INTO row_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Boe ma atahori reu rafadꞌe rae, “Amaꞌ, e! Amaꞌ maman no odꞌi mara sia dean. Ara rae randaa ro Amaꞌ.” ");
INSERT INTO row_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","De Yesus nataa nae, “Au mama ngga, seka? Ma Au toronoo ngga, seka?” ");
INSERT INTO row_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Boe ma Ana dudꞌu atahori mana tungga E, de nafadꞌe nae, “Mete, huu ia ra Au mama ngga ma toronoo ngga ra. ");
INSERT INTO row_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Huu atahori mana tao tungga Au Ama ngga sia sorga hihii-nanaun, sira Au bobꞌonggi matetu nggara.” ");
INSERT INTO row_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Faiꞌ naa boe Yesus kalua mia ume naa, de neu endoꞌ sia dano Galilea suun. ");
INSERT INTO row_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Boe ma atahori hetar reu heo rala E. Ma Ana hene neu endoꞌ sia ofaꞌ sa ata mananafuꞌ sia naa, de nanori. Basa atahori mana sia madꞌa ata rena E. ");
INSERT INTO row_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ana nanori se naeꞌ nendiꞌ nekendandaaꞌ hetar. Ana dui nae, “Hambu atahori mana ue-rae sa neu sia osin, de nggari fini. ");
INSERT INTO row_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Leleꞌ ana nggari fini ra, hambu ruma tudꞌa sia dalaꞌ. Boe ma mbuiꞌ ra rema de bito rendi basa fini ra. ");
INSERT INTO row_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Te fini ruma tudꞌa sia rae fatu-fatuꞌ. Fini a nanumbu losaꞌ a, huu rae isiꞌ mbeiꞌ a. ");
INSERT INTO row_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Te reo-rendu ma, numbuꞌ ra male de meto hendi se. Huu oka nara nda masoꞌ losa rae rala sa. ");
INSERT INTO row_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Hambu fini ruma fai tudꞌa sia uru manggouꞌ. Boe ma uru manggouꞌ a hapi nisa numbuꞌ naa ra. ");
INSERT INTO row_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Te hambu fini ruma tudꞌa sia rae isiꞌ. Fini naa ra ranumbu, ma raꞌamoko losa rabꞌoa. Ruma fee baliꞌ buna-bꞌoa nara dedꞌesin lao telu nulu, ruma losa nee nulu, ma ruma losa natun esa. ");
INSERT INTO row_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Seka ma ndikiꞌ, na, rena malolole, o!” ");
INSERT INTO row_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Basa ma Yesus ana mana tungga nara rema de ratane E rae, “Taꞌo bee de Pak nanori atahori hetar naa ra mendiꞌ nekandandaaꞌ?” ");
INSERT INTO row_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Boe ma Yesus nataa nae, “Huu Lamatualain nau fee nggi mihine parendan, naa de Au ufadꞌe memaꞌ nekendandaaꞌ ia sosoan. Te mete ma atahori laen, na, Au unori endiꞌ a nekendandaaꞌ. ");
INSERT INTO row_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Huu atahori mana nahine Lamatuaꞌ hihii-nanaun, dei fo Lamatuaꞌ fee ne bau nahine. Te atahori nda mana nau tao afiꞌ neu Lamatuaꞌ hihii-nanaun sa, dei fo Lamatuaꞌ fee ne lili hendi saa fo ana nahineꞌ a. ");
INSERT INTO row_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Au unori se endiꞌ a nekendandaaꞌ a, huu: ‘Ara rita ena, te nda rahine sa. Ara rena ena, te nda tao afiꞌ sa.’ ");
INSERT INTO row_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ara onaꞌ atahori fo Lamatualain mana ola-olan Yesaya suraꞌ nae, ‘Dei fo ama rena, te ama nda nau mihine sai-sai sa. Dei fo ama mita, te ama nda nau bubꞌuluꞌ saa fo manadadꞌiꞌ naa sa. ");
INSERT INTO row_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Huu atahori ia ra rala nara manggateeꞌ ara raꞌambambakeꞌ ndiki nara, ara raꞌapopokeꞌ mata nara. Dadꞌi hela neu fo ndiki nara mbake taꞌoꞌ a naa leo, ma hela neu fo, mata nara poke taꞌoꞌ a naa leo. Hela neu fo Au sudꞌi boe tao malole se, huu ara nda nau tao afiꞌ neu Au sa.’ ");
INSERT INTO row_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Te hei ia ra, nenefee papala-babꞌanggiꞌ, o! Huu ama mita no mata mara ena, ma ama rena no ndiki mara ena. ");
INSERT INTO row_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mimihere Au! Feꞌesaꞌan Lamatuaꞌ mana ola-olan no atahori rala ndoos ra nau rae rita saa fo hei mitaꞌ ia, te ara nda bisa sa. Ara o nau rena saa fo ama renaꞌ a, te ara nda bisa sa.” ");
INSERT INTO row_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Olaꞌ basa ma, Yesus nafadꞌe se nae, ‘Dadꞌi ia na ama rena nekendandaaꞌ ia sosoan. ");
INSERT INTO row_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Fini mana tudꞌa sia dalaꞌ a, naeni atahori mana rena Hara-liiꞌ soꞌal Lamatualain toꞌu parendaꞌ, te ana nda nahine no matetuꞌ sa. Basa ma nitu ra malanggan nema rambas nendi Hara-liiꞌ naa mia atahori naa ralan. ");
INSERT INTO row_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Fini mana tudꞌa sia rae fatu-fatuꞌ a, naeni atahori mana rena Lamatuaꞌ Hara-liin, ma ana simbo no rala nemehoꞌot. ");
INSERT INTO row_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Te Hara-liiꞌ naa ra nda raꞌoka sa. Naa de nda nenembedaꞌ dooꞌ sia atahori naa ralan sa. De leleꞌ atahori laen tao raꞌasususaꞌ e huu simbo Hara-liiꞌ naa ra, ma ana nggari hendi se neuꞌ ena. ");
INSERT INTO row_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","No fini mana tudꞌa sia uru manggouꞌ a taladꞌan, onaꞌ atahori mana rena Hara-liiꞌ naa. Te ana sebꞌo-mue noꞌ a ue-tataos mataꞌ-mataꞌ fo nasodꞌa noꞌ a lole-ladꞌaꞌ ra. De basa ue-tataos naa ra, seti hendi Hara-liiꞌ naa mia ralan, de nda naꞌena ngguna saa sa ena boe. ");
INSERT INTO row_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Te fini mana tudꞌa sia rae isiꞌ a, onaꞌ atahori mana pasa ndikin fo simbo Hara-liiꞌ naa, ma tungga Lamatuaꞌ hihii-nanaun. Boe ma ana taoꞌ a dala-dala maloleꞌ, onaꞌ fini mana mabꞌoaꞌ a. Hambu ruma raboa dedꞌesin lao telu nulu, ma ruma lao nee nulu, ma ruma lao natun esa.” ");
INSERT INTO row_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesus nafadꞌe seluꞌ nekendandaaꞌ esa fai nae, “Lamatualain toꞌu parendaꞌ naa, onaꞌ atahori esa nggari fini maloleꞌ sia osin. ");
INSERT INTO row_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Temba neu ma, basa atahori mana sunggu masambetaꞌ ra. Boe ma atahori deꞌulaka nema, de nggari uru fui dekeꞌ ra risiꞌ osi a. ");
INSERT INTO row_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Leleꞌ osi a nabꞌuna-nabꞌoa, ma atahori mana tao ues nara rita uru fui a mori belaꞌ no are nggandum sia naa. ");
INSERT INTO row_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Boe ma reu rafadꞌe tenu osiꞌ a rae, ‘Papa! Faiꞌ naa hita sela fini maloleꞌ sia papa osin, to? Taꞌo bee de uru a naeꞌ boe?’ ");
INSERT INTO row_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Malangga nataa nae, “Naa, atahori deꞌulakaꞌ ue-tataon.’ Boe ma mana tao ues nara olaꞌ rae, ‘Papa, hai mii miue hendi uru a, do?’ ");
INSERT INTO row_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Te nataa nae, ‘Afiꞌ! Leleꞌ hei miue uru a, neꞌo hita sela-nggari malole nara nenelea hendiꞌ boe. ");
INSERT INTO row_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Hela se mori belaꞌ losa fula-fai etu-oruꞌ a losa. Leleꞌ naa, dei fo au ufadꞌe atahori mana tao ues ra ae, “Ama miꞌidꞌuru miꞌihuluꞌ uru fui ra dei. Ma futu se mbumbutu-mbumbutuꞌ, fo dedꞌee hendi se. Basa naa midꞌudꞌuru buna-bꞌoa maloleꞌ ra, fo mbedꞌaꞌ nisiꞌ soka-poleꞌ rala.” ’ ” ");
INSERT INTO row_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Basa ma, Yesus olaꞌ fai nae, “Au fee seluꞌ nekendandaaꞌ esa fai, fo ama bisa mihine taꞌo bee fo Lamatualain dadꞌi Maneꞌ soaꞌ neu atahori hetar. Fefeun atahori nara onaꞌ deke anadikiꞌ sa fo atahori sela sia osin rala. ");
INSERT INTO row_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mae dekeꞌ naa, anadikiꞌ seli, te mete ma mori nema, na, dadꞌi hau huu ine monaeꞌ sia osi. Sambe mbuiꞌ ra rema randuna sia dana nara.” ");
INSERT INTO row_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesus fee seluꞌ nekendandaaꞌ esa fai nae, “Lamatualain atahorin, onaꞌ bibꞌit roti fo inaꞌ sa haꞌi fo sambor no tarigu sak esa. Boe ma roti a reis losa naꞌamoko, huu bibꞌit roti mbei anaꞌ naa.” ");
INSERT INTO row_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesus nanori atahori hetar nendiꞌ dudꞌuit mataꞌ hetar. Ana olaꞌ nendiꞌ a nekendandaaꞌ. ");
INSERT INTO row_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ana nanori taꞌo naa tungga saa fo Lamatualain mana ola-olan suraꞌ memaꞌ ena nae, “Dei fo Au unori endiꞌ nekendandaaꞌ. Dei fo Au ufadꞌe dala-dalaꞌ fo atahori nda feꞌe rene rita sa, eniꞌ a mia Lamatualain tao raefafoꞌ ia losa ia nema.” ");
INSERT INTO row_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Basa ma, Yesus lao hela atahori hetar naa ra, de baliꞌ ume neu. Boe ma ana mana tungga nara rema, de roꞌe tulun sia E rae, “Amaꞌ Tulun mufadꞌe hai nekendandaaꞌ soꞌal uru mana moriaoꞌ a sosoan dei!” ");
INSERT INTO row_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Boe ma Yesus nataa nae, “Atahori mana nggari fini maloleꞌ naa, naeni Au, Atahori Matetuꞌ ia. ");
INSERT INTO row_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ma osi naa, naeni raefafoꞌ ia. Fini maloleꞌ naa, naeni atahori mana dadꞌi Lamatualain bobꞌonggin ena. No uru mana mori aoꞌ naa, naeni nitu ra malanggan atahori nara. ");
INSERT INTO row_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Boe ma, atahori deꞌulakaꞌ mana nema nggari fini uru naa, naeni nitu ra malangga monaen. Ma fai etu-oruꞌ naa, naeni fai mateteꞌen. Atahori mana etu-oru buna-bꞌoaꞌ naa, naeni Lamatualain ate nara mia sorga. ");
INSERT INTO row_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Leleꞌ fai mateteꞌen, ara radꞌuru rala uru ra fo hotu hendi se. ");
INSERT INTO row_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Huu Au, Atahori Matetuꞌ ia, dei fo haitua ate mana sia sorga rema. Dei fo ara reu radꞌuru basa atahori nda mana tungga Lamatuaꞌ parendan sa. Ma ara reu radꞌuru rala basa atahori mana neu kokoe-nanasi atahori laen ra, fo ara nda tungga Lamatuaꞌ parendan sa. ");
INSERT INTO row_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Dei fo ara mbia hendi basa atahori deꞌulakaꞌ ra risiꞌ ai naraka rala reu, onaꞌ uru nenehotu hendiꞌ naa. Sia naa, dei fo ara feꞌe na ramedꞌa doidꞌosoꞌ ritaꞌ mamate nara, ma nggae eiei nda raloeꞌ sa. ");
INSERT INTO row_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Te atahori mana nasodꞌa no ndoos tungga Lamatualain hihii-nanaun, dei fo ara leo rakandoo ro Ama Maneꞌ sia sorga. Sia naa, ara raronda onaꞌ relo a. Naa! Atahori mana nau nahine Au, pasa ndikim malolole, o!” ");
INSERT INTO row_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yesus fee seluꞌ nekendandaaꞌ esa fai nae, “Atahori mana nau nahine soꞌal Lamatuaꞌ toꞌu parendan, onaꞌ atahori mana nau hambu sudꞌiꞌ-saa mafelit, fo atahori funiꞌ mia rae rala. Atahori naa nema ali, ma ana hambu sudiꞌ-saa naa ra sia naa, naa de namahoꞌo nala seli. Basa ma, ana nasambombori baliꞌ sudiꞌ-saa naa. Boe ma ana baliꞌ lailai, de neu seo hendi basa hata-heton. De ana neu hasa nala rae naa, fo eni bisa hambu sudꞌi-saa mafelit naa.” ");
INSERT INTO row_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Yesus fee seluꞌ nekendandaaꞌ fai nae, “Atahori mana nae nahine Lamatuaꞌ toꞌu parendan naa, onaꞌ atahori mana danggan esa nau hambu mutiara mafelit. De ana sangga-sanggaꞌ mutiara fo nae hasa. ");
INSERT INTO row_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Leleꞌ ana hambu mutiara sa meulaun seli, ma ana baliꞌ neuꞌ ena, de neu seo hendi basa hata-heton. Basa ma ana neu hasa mutiara naa, fo eni bisa hambu e.” ");
INSERT INTO row_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yesus fee seluꞌ nekendandaaꞌ nae, “Lamatualain toꞌu parendan, onaꞌ mana puꞌa ra reu mboꞌi puꞌat esa sia dano. Boe ma puꞌat naa hambu uꞌu mataꞌ-mataꞌ. ");
INSERT INTO row_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Leleꞌ puꞌat naa sofeꞌ no uꞌu, ma mana puꞌa ra reu haꞌi rala se, fo rendi dano suun neu. Boe ma ara endoꞌ de raisi uꞌu mia puꞌat. Uꞌu maloleꞌ ra, ara tao nisiꞌ rela rala neu. Te uꞌu nda maloleꞌ sa na ara nggari hendi se. ");
INSERT INTO row_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Onaꞌ naa boe, neu fai mateteꞌen. Dei fo Lamatualain ate nara rema mia sorga, fo bingga-banggi atahori deꞌulakaꞌ mia atahori rala ndoos ra. ");
INSERT INTO row_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Dei fo ara nggari basa atahori deꞌulaka ra ai naraka rala reu. Dei fo ara ramedꞌa doidꞌosoꞌ manaseliꞌ sia naa, ma nggae eiei nda raloeꞌ sa,” ");
INSERT INTO row_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Olaꞌ basa taꞌo naa, ma Yesus natane se nae, “Hei mihine basa saa fo Au olaꞌ faꞌ ia ra, do? Ara rataa rae, “Mihine, Lamatuaꞌ!” ");
INSERT INTO row_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Boe ma Yesus nataa baliꞌ se nae, “Malole! Huu meser agama esa-esaꞌ mana tebꞌe-tebꞌeꞌ nanori Lamatualain Dedꞌea-oꞌolan fo mana suraꞌ eniꞌ mia dalahulun, ma toꞌu nahereꞌ Au nenori ngga oras ia, na, ana onaꞌ tenu umeꞌ sa soaꞌ a soi nggudꞌan, fo natudꞌu hata-heto mbaran, naꞌabꞌue no hata-heto feun.” ");
INSERT INTO row_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Leleꞌ Yesus nanori basa atahori nendiꞌ nekendandaaꞌ ma, Ana lao hela mamanaꞌ naa, ");
INSERT INTO row_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","de lao nisiꞌ kambon. Sia naa, Ana ume hule-oꞌeꞌ rala neu de nanori atahori ra. Basa atahori mana rena E, titindindiiꞌ a. Ara ola-olaꞌ rae, “Awii! Atahori ia mahinen dei! Ana neu nanori mia bee ia? Taꞌo bee de Ana tao nalaꞌ manadadꞌiꞌ naa ra? ");
INSERT INTO row_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Tao-tao te Eni tukan hau a Anan. Hita tahine maloleꞌ inan Maria; ma odꞌi nara, naeni Yakobis, Yusuf, Yudas no Simon. ");
INSERT INTO row_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Hita o tahine feto nara boe, huu basa nggita leo sia kamboꞌ sa na! Dadꞌi Ana hambu mahineꞌ naa, mia bee nema fai? Boe ma Ana hambu koasa manaseliꞌ naa, mia seka fai?” ");
INSERT INTO row_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Naa de ara ramanasa losa nda nau rae rena E sa ena. Te Yesus nafadꞌe nae, “Memaꞌ tebꞌe! Sia mamanaꞌ laen, atahori ra hiiꞌ a fee hadꞌa-hormat neu Lamatualain mana ola-ola nara. Te sia kambon ma ume isi nara, atahori ra nda nau fee hadꞌa-hormat neu e sa.” ");
INSERT INTO row_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Huu rala nara manggateeꞌ de ara nda nau ramahere Yesus sa, naa de Ana nda tao manadadꞌi hetar sia naa sa. ");
INSERT INTO row_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Leleꞌ naa, mane Herodes toꞌu parendaꞌ sia propinsi Galilea. Ana o rena haraꞌ mataꞌ-mataꞌ soꞌal Yesus. ");
INSERT INTO row_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ana nafadꞌe penggau nara nae, “Yesus ia, neꞌo Yohanis Mana Saraniꞌ fo feꞌesaꞌan au denu nggero rala langgan. Ia na ana nasodꞌa baliꞌ ena, o! Naa de naꞌena koasa fo tao manadadꞌiꞌ naa ra.” ");
INSERT INTO row_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Mane Herodes olaꞌ taꞌo naa, huu dalahulun ana nadꞌedꞌea no Yohanis, losa ana humu ma tao Yohanis bui rala neu. Dedꞌeat naa dudꞌuin taꞌo ia: mane Herodes sao nala odꞌin Filipus saon, naran Herodias. Tao-tao te Filipus no Herodias nda feꞌe mahelaꞌ sa. ");
INSERT INTO row_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Naeni de Yohanis ai nasafafali nae, “Ama maneꞌ afiꞌ haꞌi mala odꞌi ma saon. Te naa mulena-langga hita hohoro-lalane adat Yahudi na!” ");
INSERT INTO row_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Te Herodes nda nau rena e sa, boe ma sao nala Herodias neuꞌ ena. Herodes naeꞌ a doo beꞌ fo tati nisa Yohanis mana Saraniꞌ a. Te ana namatau atahori hetar, huu ramahere rae, Yohanis naa, Lamatualain mana ola-olan. Naa de ana denu atahorin, fo tao Yohanis bui rala neu. ");
INSERT INTO row_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Te doo-doo ma, Herodes tao fefeta fai bobꞌonggin. Leleꞌ naa, ina mane Herodias ana feton neu lendo mbali fuiꞌ ra. Lelendon malolen seli, de tao Herodes ralan maꞌahee nala seli. ");
INSERT INTO row_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Lendo basa ma, Herodes noꞌe ana fetoꞌ naa nae, “Mae moꞌe saa sia au, na, mufadꞌe leo! Te dei fo au fee nggo. Au toꞌu uhereꞌ hehelu-fufuli ngga ia. Ma au sumba endiꞌ Lamatualain naran.” ");
INSERT INTO row_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Rena maneꞌ a oꞌolan ma, ana fetoꞌ a inan ira e. Naa de ana neu noꞌe nae, “Amaꞌ! Au oꞌe Yohanis Mana Saraniꞌ a langgan. Tao neu dulan rala, fo mendi fee neu au.” ");
INSERT INTO row_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Rena nala ana fetoꞌ a noꞌe taꞌo naa ma, Herodes ralan susa. Te ana nda bisa lea baliꞌ susumban sa, huu basa fuiꞌ ra rena ena na. Naa de ana tunggaꞌ a ana fetoꞌ a hihii-nanaun. ");
INSERT INTO row_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Boe ma ana parenda atahori reu nggero rala Yohanis langgan, mia bui rala. ");
INSERT INTO row_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ara nggero rala Yohanis langgan, ma tao neu dulan rala, de reu fee neu ana fetoꞌ a. Ana simbo nala dulan ma, ana oꞌo nendi e fee neu inan. ");
INSERT INTO row_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Leleꞌ Yohanis ana mana tungga nara rena oi ara nggero rendi langgan, ma ara reu haꞌi rendi ao sisin, de reu raꞌoi e. Basa de ara reu rafadꞌe Yesus. ");
INSERT INTO row_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Leleꞌ Yesus rena nala haraꞌ soꞌal Yohanis, ma Ana no ana mana tungga nara rae lao hela mamanaꞌ naa boe. Ma Ara sae ofaꞌ de rae reu risiꞌ mamana rouꞌ fo hahae ao nara. Te atahori hetar rita Yesus se ofan tungga-tunggaꞌ a dano suun. De ara lao hela kambon nara, ma laoꞌ lai-lai tungga dala madꞌaꞌ ata. Naeni de ara losa mamanaꞌ naa raꞌahuluꞌ Yesus se. ");
INSERT INTO row_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Leleꞌ Ana onda mia ofaꞌ, ma Ana nita atahori hetar rahani E. De Ana tudꞌa kasian mbali se. Ma Ana tao nahaiꞌ atahori mamahedꞌiꞌ ra. ");
INSERT INTO row_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Bobꞌoꞌ neu ma, Ana mana tungga nara reu rafadꞌe rae, “Amaꞌ, e! Malole lenaꞌ Amaꞌ denu basa atahori ia ra, reu hasa nanaat sia kambo-kamboꞌ mana deka-deka ia. Te bobꞌoꞌ ena na! Sia ia nda hambu nanaat saa sa boe.” ");
INSERT INTO row_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Te Yesus nataa nae, “Afiꞌ! Hei mihao se.” ");
INSERT INTO row_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Te ara rataa rae, “Awii, Amaꞌ, e! Hai nda miꞌena saa-saa fo mihao neu atahori desi basa ia ra sa. Hai mae tao taꞌo bee? Te akaꞌ roti balaꞌ lima, ma uꞌu ruaꞌ a na!” ");
INSERT INTO row_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Te Yesus olaꞌ nae, “Naa malole ena. Mendi nema leo!” ");
INSERT INTO row_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Boe ma Ana denu basa atahori ra endoꞌ raꞌabꞌubꞌue reu uru ata. Basa ma, Ana haꞌi nala roti bueꞌ lima, ma uꞌu ka ruaꞌ ra. Boe ma Ana oroꞌa mbali lalai a de noꞌe makasi neu Lamatualain. Basa ma, Ana babꞌanggi roti naa ra, de loo fee neu ana mana tungga nara, fo reu banggi fee neu basa atahori naa ra ");
INSERT INTO row_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","De basa se raa losa raꞌabeta. Raa basa ma, ara kumbu rala nanaa sisaꞌ ra, boa sanahulu rua. ");
INSERT INTO row_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Basa atahori mana raaꞌ ra, mbei ma touꞌ rifon lima. Nda feꞌe reken inaꞌ ra ro anadꞌikiꞌ ra sa. ");
INSERT INTO row_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Basa se raa basa ma, Yesus denu ana mana tungga nara reu sae ofaꞌ fo lao raꞌahuluꞌ risiꞌ dano a seri. Te Ana feꞌe nahati sia naa, fo denu basa atahori naa ra baliꞌ. ");
INSERT INTO row_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Leleꞌ basa se baliꞌ, ma Yesus hene nisiꞌ leteꞌ esa, de hule-oꞌe. Losa temba, te mesaꞌ ne feꞌe sia naa. ");
INSERT INTO row_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Leleꞌ naa, ana mana tungga nara ofan losa dano a taladꞌan ena. Te ara sefe ritaꞌ mamate nara, huu ofaꞌ labꞌan ani mataꞌ, ma ree monaeꞌ ra mbembesiꞌ se. ");
INSERT INTO row_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Deka manggarelo ma, Yesus neu tungga se boe. Te Ana laoꞌ sia oeꞌ ata. ");
INSERT INTO row_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Rita taꞌo naa ma, ana mana tungga nara nggengger. Ara olaꞌ ramatatau rae, “Heꞌe o! Maro sa sini!” ");
INSERT INTO row_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Te Yesus olaꞌ no se nae, Woe! Ama afiꞌ mimitau! Te Au ia Yesus! Subꞌa-subꞌa leo!” ");
INSERT INTO row_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petrus rena taꞌo naa ma nataa nae, “Mete ma tebꞌe-tebꞌeꞌ Yesus, na, denu au laoꞌ sia oeꞌ ata fo naa eti.” ");
INSERT INTO row_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Boe ma Yesus nataa nae, “Neu! Uma leo!” Boe ma Petrus onda mia ofaꞌ de laoꞌ nisiꞌ Yesus tungga oeꞌ ata. ");
INSERT INTO row_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Te leleꞌ Pertus medꞌa nae hambu sanggu anin, ma namatau nala seli. Ana naeꞌ a tena ena, ma randu nae, “Aduu, Lamatuaꞌ, e! Tulun fee au usodꞌa dei!” ");
INSERT INTO row_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Boe ma Yesus loo Liman lailai de toꞌu nala e. Ana olaꞌ nae, “Awe, Petrus, e! Taꞌo bee de ralam nabꞌabꞌanggi? Nda mumuhere tebꞌe Au sa do?” ");
INSERT INTO row_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Basa ma, ruꞌa se ofaꞌ rala reu. Boe ma anin o naloeꞌ neuꞌ ena. ");
INSERT INTO row_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Rita taꞌo naa, ma ana mana tungga nara soꞌu kokoa-kikioꞌ neu E rae, “Awii! Amaꞌ ia, memaꞌ tebꞌe-tebꞌeꞌ Lamatualain Anan!” ");
INSERT INTO row_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Leleꞌ ara losa dano a seriꞌ ma, ara onda risiꞌ kambo Genesaret dano suun. ");
INSERT INTO row_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Leleꞌ ara onda, ma atahori hetar rahine se neuꞌ ena. De ara rameli rae, “We! Yesus nema ena, o!” Ara relaꞌ reu rafadꞌe ndule kamboꞌ, ma atahori rendi basa atahori mamahedꞌiꞌ ra. ");
INSERT INTO row_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ara roꞌe rae sadꞌi sira nggamaꞌ a badꞌun. Huu ara duꞌa rae, “Sadꞌi atahori mamahedꞌiꞌ ra nggama rala Yesus badꞌun suun, neꞌo ara hai reuꞌ ena.” De basa atahori mamahedꞌiꞌ mana nggama badꞌu narun, hai reuꞌ ena. ");
INSERT INTO row_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Leleꞌ esa, hambu atahori Farisi ro meser agama nononggoꞌ sa rema mia Yerusalem fo randaa ro Yesus. ");
INSERT INTO row_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Atahori Farisi ra toꞌu rahereꞌ sira adat Yahudin. Leleꞌ ara rena rae, Yesus ana mana tungga nara raa na nda safe lima nara tungga adat hihii-nanaun sa, ma ramanasa. Boe ma ara rema de fee salaꞌ neu Yesus rae, “Taꞌo bee de ana mana tungga mara raa, te nda safe lima nara sa? Naa nalena-langga mbali bei-baꞌi tara adat na!” ");
INSERT INTO row_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Te Yesus nataa nae, “Memaꞌ hei atahori mana olaꞌ laen ma tao laen! Ama mihine milena-langga neu Lamatualain parendan, fo tunggaꞌ a bei-baꞌi mara adat na. ");
INSERT INTO row_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Huu Lamatualain parenda ena nae, ‘Fee hadꞌa-hormat neu ina-ama mara,’ Ma seluꞌ fai nae, ‘Mete ma atahori sa rarai-oole inan no aman, na, musi hukun misa e.” ");
INSERT INTO row_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Lamatualain nanori taꞌo naa, te hei minori laen fai. Ama mae, ‘Atahori sa nda parlu tulu-fali ina-aman nendiꞌ sudꞌiꞌ a saa nara, itaꞌ mae ara doidꞌoso rala seli o, mete ma ana helu-fuli basa nae fee sudꞌiꞌ a saa naa ra neu Lamatuaꞌ ena. Te no hei nenorim taꞌo naa, hei nggari hendi Lamatualain parendan, ma nggati no hei parendam. ");
INSERT INTO row_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Naa de, Au ae hei ia ra, atahori mana olaꞌ laen, te tao laen! Naa nandaa no Lamatuaꞌ mana ola-olan Yesaya suraꞌ memaꞌ soꞌal hei mia lele uluꞌ a! Huu Lamatuaꞌ denu e suraꞌ nae, ");
INSERT INTO row_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Hambu atahori koa-boꞌu Au, siaꞌ a bafan, te nda no ralan sa. ");
INSERT INTO row_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Mae ara tao taꞌo naa o, parsumaꞌ a. Ara nda tungga Au sa. Ara nda ranori Lamatualain nenorin sa, te ranori atahori nenorin.’” ");
INSERT INTO row_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Basa naa ma, Yesus noꞌe atahori laen sia naa de nanori se nae, “Pasa ndiki mara malolole, fo bisa mihine! ");
INSERT INTO row_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Saa mana masoꞌ nisiꞌ atahori bafan rala neu, naa nda tao nanggenggeo atahori sa. Te saa mana kalua mia atahori bafan, naa mana tao nanggenggeo atahori.” ");
INSERT INTO row_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Basa ma, Yesus ana mana tungga nara rema rafadꞌe E rae, “Amaꞌ bubꞌuluꞌ, do? Atahori Farisi ra rala nara mera rena Amaꞌ oꞌolan.” ");
INSERT INTO row_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Te Yesus nataa nae, “Dei fo Ama ngga sia sorga nore hendi atahori nda mana nanori tungga Eni hihii-nanaun sa. Naa onaꞌ atahori nore hendi saa mana moriꞌ fo ana nda hiiꞌ ra sa. ");
INSERT INTO row_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Dadꞌi afiꞌ taoafiꞌ neu atahori Farisi naa ra! Te ara, onaꞌ atahori pokeꞌ natudꞌu dalaꞌ fee atahori pokeꞌ. Dei fo ara tudꞌa ndolaꞌ rala reu ona esaꞌ.” ");
INSERT INTO row_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Basa ma Petrus olaꞌ nae, “Amaꞌ, tulun mufadꞌe hai nekendandaaꞌ naa sosoan dei!” ");
INSERT INTO row_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesus nataa nae, “Naa! Hei nda feꞌe mihine sa? ");
INSERT INTO row_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Sosoan taꞌo ia: saa fo ata taa, masoꞌ sia bafa tara, nakandoo tei tara rala, basa fo baliꞌ dea neu nisiꞌ mamana mbia deaꞌ. ");
INSERT INTO row_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Te saa mana kalua mia bafaꞌ, naa mana tao nanggenggeo atahori, losa Lamatualain o melumudꞌu e, ma nda nau simbo e sa. ");
INSERT INTO row_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Huu Dala deꞌulakaꞌ naeꞌ laoꞌ mia atahori ralan! Onaꞌ a: dudꞌuꞌa deꞌulakaꞌ, risa atahori, hohongge, nda feꞌe sao sa te tao salaꞌ, ramanaꞌo, sakasii peko-lelekoꞌ, ma olaꞌ raꞌamuti-raꞌamu atahori naran. ");
INSERT INTO row_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Basa naa ra, mana tao atahori ra ranggenggeo. Te mete ma atahori raa-rinu nda pake safe lima nara tungga adat hihii-nanaun sa, na, naa nda dadꞌi soꞌal sa.” ");
INSERT INTO row_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Basa ma Yesus lao hela mamanaꞌ naa, de neu nisiꞌ mamanaꞌ mana deka no kota Tirus ma kota Sidꞌon. ");
INSERT INTO row_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Sia naa hambu inaꞌ sa laoꞌ mia mamanaꞌ naa. Eni nda atahori Yahudi sa. Leleꞌ ana rena Yesus sia naa, ana nema noꞌe no tebꞌe-tebꞌe nae, “Mane Daud tititi-nonosin, e! Sue au dei! Te nitu tao au ana feto ngga. Awee, kasian, e! Te ana doidꞌoso ena.” ");
INSERT INTO row_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Te Yesus neneeꞌ a, nda nataa nae saa sa boe. Boe ma Ana mana tungga nara rema rafadꞌe rae, “‘Amaꞌ, inaꞌ ia akaꞌ nameli tao tasibuꞌ a. Malole lenaꞌ Amaꞌ mbuu hendi e mia ia leo!” ");
INSERT INTO row_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Boe ma Yesus nataa nae, “Lamatualain denu Au uma fo tulu-fali hita atahori Yahudi nara, huu ara lao sala ena, onaꞌ bibꞌi lombo mana tara-kooꞌ ena. Ana nda denu Au uu tulu-fali atahori feaꞌ ra sa.” ");
INSERT INTO row_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Te inaꞌ naa nema deka-deka no Yesus. Ana sendeꞌ lululanggan ma noꞌe nae, “Papa, e! Tulun au dei.” ");
INSERT INTO row_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Te Yesus nggari dedꞌeat nae, “Nda nandaa sa haꞌi nanaat mia ana kara fo nggari fee busa ra.” No masud maꞌafuniꞌ nae, Yesus musi tulu-fali naꞌahuluꞌ atahori Yahudi nara, dei fo tulu-fali atahori feaꞌ ra. ");
INSERT INTO row_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Te inaꞌ naa nataa nae, “Tebꞌe, Amaꞌ, e! Te busa ra nahani sia mei a filenggan. Ara o ra saa mana tudꞌaꞌ mia ana kara pinggan boe.” No masud na nae, Leleꞌ ana kara raa, busa o hambu naa boe. Onaꞌ mae Yesus tulu-fali atahori nara o, Eni musi mete-seꞌu atahori feaꞌ ra boe. ");
INSERT INTO row_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yesus rena naꞌo naa, ma nafadꞌe nae, “Awii! Mama mumuhere tebꞌe neu Au, o! Dadꞌi mama baliꞌ leo, te saa fo moꞌeꞌ naa, dadꞌi ena!” Basa ma ana baliꞌ, te memaꞌ anan hai ena. ");
INSERT INTO row_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Basa naa ma, Yesus no ana mana tungga nara lao hela mamanaꞌ naa, boe ma lao tungga-tunggaꞌ a dano Galilea suun. Basa ma ara hene risiꞌ leteꞌ sa, de Yesus endoꞌ nanori se. ");
INSERT INTO row_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Boe ma atahori hetar rema risiꞌ E. Ara rendi atahori dokaꞌ, atahori pokeꞌ, atahori mamaluꞌuꞌ, atahori nda mana bale nalaꞌ sa, ma atahori mamahedꞌiꞌ laen ra boe. Ara raꞌeꞌendo atahori mamahedꞌiꞌ ra deka Yesus ein. Boe ma Ana naꞌahahaiꞌ se, ");
INSERT INTO row_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Rita taꞌo naa, ma atahori hetar titindindiiꞌ a. Ara olaꞌ rae, “We! Manaseliꞌ, o! Atahori dokaꞌ o bisa laoꞌ no malole. Atahori pokeꞌ o, rita baliꞌ. Atahori mamaluꞌuꞌ o, laoꞌ boe. Ma atahori nda mana bale nalaꞌ sa o, bisa bale boe! Ia tantu Lamatualain mana tao. Eni ia, bei-baꞌi tara beꞌutee neu E eniꞌ a lele uluꞌ a.” ");
INSERT INTO row_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Basa fai hira boe ma, Yesus noꞌe nala ana mana tungga nara de nae, “Au kasian neu atahori ia ra ena. Ruma mia dodꞌooꞌ rema, boe ma raꞌabꞌue fai telu ena, losa nanaat nara basa ena. Malole lenaꞌ ara afiꞌ baliꞌ ro tei rouꞌ. Afiꞌ losa ara masaloe sia dalaꞌ taladꞌan.” ");
INSERT INTO row_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ma Yesus ana mana tungga nara rataa rae, “Amaꞌ! Ia mamana rouꞌ naꞌadꞌodꞌoꞌ no kamboꞌ. De hita nda bisa tahao tala atahori desi basa ia ra sa.” ");
INSERT INTO row_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ma Yesus natane se nae, “Hei roti mara, baꞌu bee?” Ara rataa rae, “Hituꞌ a! No uꞌu mbei!” ");
INSERT INTO row_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Basa ma Yesus denu basa atahori ra endoꞌ reu rae a. ");
INSERT INTO row_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Boe ma Ana haꞌi nala roti bue kahituꞌ no uꞌu ra, de noꞌe makasi mbali Lamatualain. Ana bibꞌibꞌi se, de Ana fee neu ana mana tungga nara, fo reu banggi fee neu basa atahori naa ra. ");
INSERT INTO row_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","De basa se raa losa raꞌabeta. Basa de, radꞌuru rala nanaa lenaꞌ ra, sofe boa hitu. ");
INSERT INTO row_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Basa atahori mana raaꞌ ra, mbei ma hambu touꞌ rifon ha. Nda feꞌe reken inaꞌ ra ro ana dikiꞌ ra sa. ");
INSERT INTO row_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Basa naa dei de, Yesus denu atahori naa ra baliꞌ. Boe ma Ana sae ofaꞌ de lao risiꞌ mamana Magadan. ");
INSERT INTO row_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Lao esa, hambu atahori Farisi hira ro atahori Saduki rema risiꞌ Yesus. Ara rae raselu-bale ro Yesus, fo rae raꞌatutudaꞌ E. Huu naa, ara roꞌe rae, “Pak! Tulun mutudꞌu manadadꞌiꞌ mataꞌ esa dei, fo dadꞌi bukti oi, Pak hambu koasa mia Lamatualain ena.” ");
INSERT INTO row_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Te Yesus nataa nae, “Mete ma relo mopo ma lalai dulan mbilas, na, hei mihine, mae ‘Mbila na nda udꞌa sa.’ ");
INSERT INTO row_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Mete ma relo botiꞌ ata nema no lele nggeoꞌ, hei mihine mae, ‘Faiꞌ ia nae udꞌa.’ Naa, mete ma hei bisa mihine fula-fai ra nenendin, na, taꞌo bee de hei nda mihine leleꞌ ra nenendin sa? ");
INSERT INTO row_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Wou! Aleꞌ ia hei atahori, mihine taoꞌ a deꞌulakaꞌ! Hei nda tao afiꞌ neu Lamatuaꞌ sa! Mae hei moꞌe manadadꞌiꞌ ra o, Au nda fee sa. Huu maꞌahulun Lamatuaꞌ fee manadadꞌiꞌ nendiꞌ mana ola-olan Yunus. Dadꞌi naa dai ena!” Yesus olaꞌ basa, ma Ana lao hela se. ");
INSERT INTO row_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Leleꞌ Yesus se losa dano a taladꞌan, deidꞌe ana mana tungga nara rasanedꞌa rae, sira liliꞌ rendi roti soaꞌ neu sira lepa-ngges na. ");
INSERT INTO row_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Rena ara olaꞌ raꞌo na, ma Ana nafadꞌe nae, “Hei musi besa-bꞌesa mbali atahori Farisi ro atahori Saduki ra bibꞌit roti na e.” ");
INSERT INTO row_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Rena taꞌo naa, ma ana mana tungga nara bingun. Ara ola-olaꞌ rae, “Toulasiꞌ a olaꞌ saa ia? Mbei ma Ana ola taꞌo naa, huu ata nda tendi roti sa, do?” ");
INSERT INTO row_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Te Yesus nahine dudꞌuꞌa nara. Basa ma, Ana olaꞌ nae, “Weh! Hei ia ra seli tebꞌe ma! Taꞌo bee de hei olaꞌ soꞌal roti! Hei kuran mimihere neu Au, do? ");
INSERT INTO row_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Hei nda feꞌe mihine Au koasa ngga sa, do? Te faiꞌ na Au bibꞌibi roti bꞌueꞌ lima fo fee atahori rifon lima raa, hei kumbu mala lena nara boa hira? ");
INSERT INTO row_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Boe ma taꞌo bee fai roti hitu fo Au banggi fee neu atahori rifon ka haꞌ ra? Hei kumbu mala lena nara boa hira fai? ");
INSERT INTO row_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Taꞌo bee de faꞌ ra ama nda mihine Au oꞌola ngga sa? Au nda olaꞌ soꞌal roti sa. Au ae fee nesenenedꞌaꞌ neu nggi, ama besa-bꞌesa mo atahori Farisi ma Saduki ra nenori nara. Te nenori nara kokoe-nanasi rala atahori hetar, onaꞌ bibꞌit roti tao neu roti fo hene naꞌamoko.” ");
INSERT INTO row_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yesus olaꞌ taꞌo naa, deidꞌe ara rahine rae, Ana nda olaꞌ soꞌal roti sa. Te Ana olaꞌ soꞌal atahori Farisi ro atahori Saduki ra nenori nara. ");
INSERT INTO row_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Basa ma, Yesus se laoꞌ reu sia mamanaꞌ mana dekaꞌ no kota Kaisarea Filipi. Sia dalaꞌ taladꞌan, Ana natane se nae, “Tungga atahori oꞌolan, ara rae, Au, naeni Atahori Matetuꞌ ia, seka?” ");
INSERT INTO row_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ara rataa rae, “Hambu ruma rae Amaꞌ ia, Yohanis Mana Saraniꞌ a nasodꞌa baliꞌ ena. Laen fai rae, mbei ma Amaꞌ ia, baꞌi Elia. Laen ra fai oi, baꞌi Yeremia. Mete ma hokoꞌ na, Lamatualain mana ola-olaꞌ laen dalahulun.” ");
INSERT INTO row_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Boe ma Yesus natane seluꞌ se fai nae, “Mete ma tungga hei, na, Au ia, seka?” ");
INSERT INTO row_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Boe ma Simon nataa nae, “Amaꞌ ia, Kristus, naeni Atahori fo dalahulun Lamatualain helu-fuli nae haitua nemaꞌ a! Ma Amaꞌ ia, Lamatualain mana nasodꞌa nakandooꞌ a Anan. ");
INSERT INTO row_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesus nae, “Simon, Yunus anan, e! Ho ia, nenefee papala-babꞌanggiꞌ, o! Huu atahori nda rafadꞌe nggo hal ia sa. Te Au Ama ngga sia sorga mana nafadꞌe. ");
INSERT INTO row_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Rena, e! Aleꞌ ia Au babꞌae naram ‘Petrus’. Naraꞌ naa sosoan naeni, fatu. Huu nemeherem manggateeꞌ onaꞌ fatu, dei fo dadꞌi netehuuꞌ fee neu Au atahori mamahere ngga ra. Mae ara nenepoko-paruꞌ losa mate boe o, ara raꞌatataaꞌ rakandooꞌ a. ");
INSERT INTO row_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Dei fo Au fee nggo hak, fo mete-seꞌu atahori ra, onaꞌ ho toꞌu lelesu sorga nggoen. Huu saa fo ho ena-ai sia raefafoꞌ ia, Lamatuaꞌ ena-ai sia sorga ena. Ma saa fo ho fee isin sia raefafoꞌ ia, Lamatuaꞌ fee isin sia sorga ena.” ");
INSERT INTO row_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Olaꞌ basa taꞌo naa, ma Yesus naꞌangge se fo afiꞌ rafadꞌe esa-esa boe rae Eni ia, Kristus. ");
INSERT INTO row_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Eniꞌ a leleꞌ naa, Yesus nafadꞌe neu ana mana tungga nara nae, “Au musi uu isiꞌ kota Yerusalem. Te dei fo sia naa, Au hambu doidꞌosoꞌ naen seli mia lasi-lasi adat, ma malangga agama Yahudi ra malangga nara, ro basa meser agama ra. Dei fo ara tao risa Au, te finiesan ma Au usodꞌa baliꞌ.” ");
INSERT INTO row_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Yesus nafadꞌe taꞌo naa ma, Petrus nore nala E nisiꞌ bobꞌoan de ai nae, “Amaꞌ afiꞌ olaꞌ taꞌo naa! Neꞌo Lamatualain nda hela neu taꞌo naa sa!” ");
INSERT INTO row_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Te Petrus oꞌolan, nda tungga Lamatuaꞌ hihii-nanaun sa. Naa de Yesus heoꞌ mbali e de ai e nae, “Hee! Dinggoꞌ hela mamanaꞌ ia! Naa, nitu ra malanggan oꞌolan! Afiꞌ babꞌaa Au! Ho duꞌa tunggaꞌ a atahori hihii-nanaun, te nda tungga Lamatuaꞌ hihii-nanaun sa!” ");
INSERT INTO row_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Basa boe ma Yesus nanori ana mana tungga nara nae, “Atahori mana nau tungga Au, eni musi naꞌatataaꞌ nakandoo tungga-tungga fai! Eni musi liliiꞌ hendi hihii-nanaun, fo tunggaꞌ a Lamatuaꞌ hihii-nanaun. Mae atahori rae tao risa e o, eni musi tungga nakandooꞌ a, onaꞌ atahori lemba eni hau ngganggen fo neu mate. ");
INSERT INTO row_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Huu atahori mana sadꞌia mate huu eni tungga Au, dei fo ana hambu nasodꞌa nakandoo no Lamatuaꞌ. Te atahori mana nasodꞌa soaꞌ neuꞌ a aon, dei fo masodꞌan, sambu-lalo neuꞌ ena! ");
INSERT INTO row_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Rena, e! Mete ma hambu basa hata-heto raefafoꞌ ia, te Lamatualain nda simbo nggo sa, na, hahambun sa? Mae lemba mendi basa raefafoꞌ isin o, ho nda bisa soi mala ao samanam sa! ");
INSERT INTO row_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Au ufadꞌe basa dalaꞌ ia ra neu nggi, huu Au ia, Atahori Matetuꞌ a. Dei fo Au onda baliꞌ uma endiꞌ Ama ngga koasa manaselin, o ana dedꞌenu nara mia sorga. Leleꞌ naa, dei fo Au bala-bꞌae atahori tungga saa fo ana taoꞌ a. ");
INSERT INTO row_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Misinedꞌa malolole, e! Mia basa hei ia, dei fo hambu atahori hira nda mate sa, losa faiꞌ bee fo ara rita Au, Atahori Matetuꞌ a, dadꞌi Maneꞌ mana toꞌu parendaꞌ.” ");
INSERT INTO row_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Seli fai nee ma, Yesus noꞌe Petrus, Yakobis no odꞌin Yohanis, fo reu ramaloloꞌ hene risiꞌ leteꞌ naruꞌ sa ata, fo mesaꞌ se sia naa. ");
INSERT INTO row_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Losa ata ma, rita Yesus dadꞌi laen. Matan naronda onaꞌ relo, no buan dadꞌi muti makahahadꞌoꞌ. ");
INSERT INTO row_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Aibꞌoiꞌ ma, ara rita Ana ola-olaꞌ no baꞌi Musa no baꞌi Elia. ");
INSERT INTO row_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Boe ma Petrus bingun de olaꞌ nae, “Amaꞌ! Hai maꞌahe sia ia ena, o! De malole lenaꞌ ata tao lalaat telu. Esa fee neu Amaꞌ, esa fee neu baꞌi Musa, ma esa fai fee neu baꞌi Elia.” ");
INSERT INTO row_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Lele Petrus feꞌe olaꞌ taꞌo naa, aibꞌoiꞌ ma lelee marondaꞌ a onda de tatana nala se. Boe ma ara titindindi rena haraꞌ sa nea nema mia leleꞌ a rala nae, “Rena, o! Yesus ia, Au Ana susue ngga. Ana tao rala ngga namahoꞌo nakandooꞌ a. Rena malolole neu E, e!” ");
INSERT INTO row_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Rena rala taꞌo naa, ma ana mana tungga nara ramatau rae mate, de raꞌaloli raꞌatotonoꞌ. ");
INSERT INTO row_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Te Yesus nema keis se, ma Ana nae, “We! Ama fela leo. Afiꞌ mimitau!” ");
INSERT INTO row_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Basa ma ara botiꞌ mata nara, te nda rita esa sa boe. Akaꞌ Yesus sia naa. ");
INSERT INTO row_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Basa ma, ara onda mia leteꞌ naa. Boe ma Yesus naꞌangge se nae, “Saa fo faꞌ ra hei mitaꞌ naa, afiꞌ mifadꞌe esa boe, e! Te Au, Atahori Matetuꞌ ia, musi mate dei. Dei fo Au usodꞌa baliꞌ ena dei, fo ama feꞌe na bole mifadꞌe atahori ena.” ");
INSERT INTO row_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Boe ma ara ratane E rae, “Amaꞌ ia, memaꞌ Kristus, te baꞌi Elia sia bee? Huu meser agama ra ranori rae, baꞌi Elia musi nema dei, fo Kristus feꞌe nema na. Te tungga Amaꞌ, na taꞌo bee?” ");
INSERT INTO row_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesus nataa nae, “Memaꞌ tebꞌe. Baꞌi Elia musi nema dei, fo soi dalaꞌ fee neu Kristus. ");
INSERT INTO row_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Te rena malolole, e! Baꞌi Elia nema ena, te atahori nda rahine sa. Ara tao raꞌasusaꞌ e, tungga hihii nara. Dei fo ara tao Au, Atahori Matetuꞌ ia onaꞌ naa boe.” ");
INSERT INTO row_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Rena basa taꞌo naa, dei de ara bubꞌuluꞌ rae, baꞌi Elia fo Yesus olaꞌ naa, naeni Yohanis mana saraniꞌ a. ");
INSERT INTO row_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Leleꞌ Yesus se baliꞌ, ara randaa ro atahori hetar rahani se ena. Boe ma papa esa neu sendeꞌ lululanggan noꞌe tulun mbali E, ");
INSERT INTO row_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","nae, “Papa! Kasian au ana ngga dei! Te ana namahedꞌi mulu bibiꞌ, ana doidꞌoso nala seli. Mete ma hedꞌis na losa, na, ana akaꞌ tudaꞌ oe rala neu, hokoꞌ na ai rala neu. Tulun dei, Papa, e! ");
INSERT INTO row_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Au endi e nisiꞌ Papa ana mana tungga mara ena, te ara nda bisa raꞌahahaiꞌ rala e sa.” ");
INSERT INTO row_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Rena taꞌo naa, ma Yesus namanasa atahori mana ramahere no rala seseriꞌ nae, “Heeꞌ! Hei ia ra seli tebꞌe! Au unori usufafali nggi ena, te ama nda mihine malolole sa. Ma ama nda mimihere tebꞌe-tebꞌeꞌ neu Au sa! Au musi uꞌutataaꞌ o nggi losa fai hiraꞌ fai? Mo anaꞌ naa ia nema!” ");
INSERT INTO row_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ara ro anaꞌ naa, ma Ana oi hendi nitu mia anaꞌ naa. Basa ma, nitu a lao hela anaꞌ naa, ma ana hai neuꞌ ena. ");
INSERT INTO row_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Basa de, leleꞌ Yesus mesaꞌ ne no ana mana tungga nara, ara ratane E rae, “Amaꞌ! Taꞌo bee de faꞌ ra hai nda bisa oi hendi nitu naa sa?” ");
INSERT INTO row_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesus nataa baliꞌ nae, “Ama nda bisa oi hendi nitu naa sa, huu nda mimihere tebꞌe sa na. Misinedꞌa, e! Mete ma hei mimihere tebꞌe-tebꞌeꞌ neu Au, itaꞌ akaꞌ mbei anaꞌ a o, onaꞌ deke anadꞌikiꞌ sa o, ama bisa parenda leteꞌ sa mae, ‘Hee, leteꞌ! Lali naa muu!’ Neꞌo ana lali. Dadꞌi hei bisa tao mala sudꞌiꞌ a saa, sadꞌi ama mimihere tebꞌe-tebꞌeꞌ neu Lamatuaꞌ. ");
INSERT INTO row_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Te rena, e! Nitu mataꞌ ia ra memaꞌ deꞌulakaꞌ. Mete ma ama nda hule-oꞌe ma puasa fo moꞌe tulu-faliꞌ neu Lamatuaꞌ sa, na, ama nda bisa oi nitu mataꞌ naa ra sa.” ");
INSERT INTO row_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Lao esa ma, Yesus no ana mana tungga nara raꞌabꞌue sia profinsi Galilea. Ana nafadꞌe se nae, “Nda doꞌ sa ena, te ara rae seo Au neu atahori feaꞌ ra. ");
INSERT INTO row_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Basa ma ara tao risa Au, Atahori Matetuꞌ ia. Memaꞌ Au mate, te fini esan ma, Au usodꞌa baliꞌ.” Ana mana tungga nara susa rala seli, huu rena Ana ola naꞌo naa. ");
INSERT INTO row_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Leleꞌ Yesus no ana mana tungga nara reu risiꞌ kambo Kapernaum, boe ma mana edꞌa bea ra, ratane Petrus rae, “Hei Meser ma bae ume hule-oꞌeꞌ a bea na, do hokoꞌ?” ");
INSERT INTO row_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Boe ma Petrus nataa nae, “Bae, e!” Leleꞌ ana baliꞌ, ma Yesus nafadꞌe naꞌahuluꞌ neu e nae, “We, Simon! Duꞌa sobꞌa dei. Mane-maneꞌ sia raefafoꞌ ia haꞌi bea mia seka? Mia ana nara do, mia atahori feaꞌ? ");
INSERT INTO row_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petrus nataa nae, “‘Mia atahori feaꞌ!” Yesus olaꞌ seluꞌ fai nae, “Mete ma taꞌo naa, na maneꞌ a anan afiꞌ bae, to? ");
INSERT INTO row_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Onaꞌ naa boe no ume Hule-Oꞌe Huuꞌ a bea na. Te, hita afiꞌ tao mana edꞌa bea ra ramanasa. Dadꞌi malole lenaꞌ muu dolu uꞌu sia dano a. Mala uꞌu ka esan, na, fingga bafan. Dei fo hambu doi fulaꞌ esa sia naa. Muu bae ruꞌa nggita bea na mendiꞌ doiꞌ naa. Te naa dai soaꞌ neu ruꞌa nggita ena.” ");
INSERT INTO row_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Leleꞌ naa, Yesus ana mana tungga nara reu ratane mbali E rae, “Amaꞌ! Seka monaeꞌ lenaꞌ mia basa Lamatualain atahori nara?” ");
INSERT INTO row_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Boe ma Yesus noꞌe nala anadꞌikiꞌ sa, de naririi e neu taladꞌa nara. ");
INSERT INTO row_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Basa ma Ana olaꞌ nae, “Rena malolole! Atahori mana nau masoꞌ dadꞌi Lamatuaꞌ atahorin, ana musi ubꞌa dudꞌuꞌan dei, fo dadꞌi onaꞌ anadꞌikiꞌ nda mana nahine soꞌu-soꞌuꞌ aon sa. ");
INSERT INTO row_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Huu atahori mana maloe-madꞌae ralaꞌ onaꞌ anadꞌikiꞌ ia, eni atahori monaeꞌ lenaꞌ sia Lamatuaꞌ matan. ");
INSERT INTO row_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Boe ma atahori mana simbo atahori anak onaꞌ anadꞌikiꞌ ia, huu namahere neu Au, na, atahori naa simbo Au ena.” ");
INSERT INTO row_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Basa ma Yesus nafadꞌe se fai nae, “Mete ma hambu atahori tao anadꞌikiꞌ esa tungga dala salaꞌ, losa ana nda namahere Au sa ena, na besa-bꞌesa, o! Malole lenaꞌ atahori paꞌa fatu monaeꞌ sa, neu boton, fo neꞌetetenaꞌ e tasi rala neu. ");
INSERT INTO row_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Raefafoꞌ ia memaꞌ mamana deꞌulakaꞌ, huu hambu dalaꞌ hetar mana tao atahori tudꞌa salaꞌ rala reu. Te atahori mana hambu sosoeꞌ seli, naeni atahori mana tao atahori laen tudꞌa salaꞌ. ");
INSERT INTO row_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Mete ma tao salaꞌ mendiꞌ limam, do, eim, na, nggero hendi e! Huu malole lenaꞌ sorga muu mendiꞌ a limam seri, do, eim seri, afiꞌ losa ara nggari nggo misiꞌ ai naraka rala muu mo limam ma eim ruꞌa se. ");
INSERT INTO row_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Mete ma, tao salaꞌ mendiꞌ matam, na edꞌo hendi e! Huu malole lenaꞌ masoꞌ sorga muu mo matam esaꞌ a, afiꞌ losa ara nggari nggo misiꞌ ai naraka muu mo matam ruꞌa se.” ");
INSERT INTO row_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Yesus olaꞌ fai nae, “Besa-bꞌesa, o! Afiꞌ losa hei miloe-midꞌae anadꞌikiꞌ onaꞌ ia. Huu Lamatuaꞌ aten mana sia sorga ranea se. Ma ate naa ra sudꞌi a reu fain sa, fo rafadꞌe soꞌal atahori ia ra dala nara neu Lamatualain mana sia sorga. ");
INSERT INTO row_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","13","Ama duꞌa malolole, te Au ae fee nekendandaaꞌ taꞌo ia: hambu atahori sa bibꞌi lombon natun esa. Faiꞌ sa ma, hambu bibꞌi lombo sa lao leli, tunggaꞌ a dalan. Naa, ama duꞌa mae manatadꞌa a musi tao saa? Neꞌo Ana lao hela bibꞌi lombon ka 99 nara sia leteꞌ fo neu sangga bibꞌi lombo ka esaꞌ mana mopoꞌ naa. Mete ma ana hambu baliꞌ ena, na ana namahoꞌo mete bibꞌi lombo ka esaꞌ fo ana nita baliꞌ naa lena mia bibꞌi lombo ka 99 fo nda mana mopoꞌ ra sa. Au, Atahori Matetuꞌ ia, uma fo ae fee masodꞌaꞌ neu atahori mana lao leliꞌ mia dala ndo-tetuꞌ a. ");
INSERT INTO row_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Dadꞌi mae akaꞌ anadꞌikiꞌ sa mopo o, Au Ama ngga sia sorga nda namahoꞌo sa.” ");
INSERT INTO row_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yesus olaꞌ fai nae, “Mete ma toronoom atahori mamahereꞌ ra tao salaꞌ neu nggo, na, musi muu mundaa mo e. Mete ma akaꞌ ruꞌa nggi, dei fo feꞌe mufadꞌe salan. Mete ma ana rena oꞌolam, na, hei ruꞌa nggi malole baliꞌ ena. ");
INSERT INTO row_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Te mete ma ana nda nau rena nggo sa, na, muu moꞌe mala nonoom atahori esa do rua fo mimiloloꞌ mii. Mii mindaa mo atahori naa, fo olaꞌ mo e fai. Huu sia Lamatuaꞌ susura Meumaren nenesuraꞌ oi, ‘Sia dedꞌeat esa, musi hambu sakasii rua do telu mana olaꞌ ona esaꞌ, dei fo feꞌe na simbo dedꞌea-oꞌola nara.’ ");
INSERT INTO row_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Te mete ma ana nda feꞌe nau rena oꞌola mara sa, na, mii mifadꞌe jamaꞌat. Mete ma ana o nda feꞌe nau simbo no maloleꞌ jamaꞌat ra oꞌolan, sa, na, duꞌa mae ana onaꞌ atahori nda feꞌe nahine Lamatuaꞌ sa. Mete ma hokoꞌ, duꞌa mae deꞌulakan onaꞌ mana edꞌa bꞌea ra. ");
INSERT INTO row_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Misinedꞌa malolole Au oꞌola ngga ia, e! Saa fo hei ena-ai sia raefafoꞌ ia, naa Lamatuaꞌ ena-ai sia sorga ena. Ma saa fo hei fee isin sia raefafoꞌ ia, naa Lamatuaꞌ fee isin sia sorga ena boe. ");
INSERT INTO row_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ma Au ufadꞌe seluꞌ ae, mete ma hambu atahori rua sia hei hule-oꞌe no ralaꞌ esa, dei fo Au Ama ngga sia sorga fee se saa fo ara roꞌeꞌ a. ");
INSERT INTO row_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Mete ma hambu atahori rua do telu raꞌabꞌue fo hule-oꞌe reu esa, huu sira, Au atahori nggara, na, Au o sia taladꞌa nara boe.” ");
INSERT INTO row_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Basa naa ma, Petrus nema natane Yesus nae, “Papa, au ae utane mbei. Mete ma toronoo ngga atahori mamahereꞌ tao salaꞌ nasafafali mbali au, na, au musi fee ambon neu e lao hira? Lao hitu, do?” ");
INSERT INTO row_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Boe ma Yesus nataa nae, “Hokoꞌ! Musi fee ambon neu e losa hitu lao hitu nulu, losa nda bisa ito reken mala sa ena. ");
INSERT INTO row_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ama musi tao tungga taꞌo naa, huu Lamatualain onaꞌ maneꞌ esa mana ito-reken pagau nara huta-buku nara. ");
INSERT INTO row_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Leleꞌ Ana ito-reken ma, ana denu atahorin esa neu noꞌe pagawen esa mana nahuta doiꞌ mbali e, losa juta-juta. ");
INSERT INTO row_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Te pagawe a nda bae nala huta-bukun sa. Dadꞌi maneꞌ a parenda nae, ‘Mii seo atahori ia no basa sao ana nara, fo ara dadꞌi ate. Boe ma seo mibasaꞌ hata-heto nara, fo bae neu huta-buku nara.’ ");
INSERT INTO row_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Rena taꞌo naa, ma pagawe naa naloe aon de sendeꞌ lululanggan neu maneꞌ a matan, de kokoe e nae, ‘Aduu! Amaꞌ, e! Ama maneꞌ tulun fee fai mbei neu au dei do! Dei fo au fee baliꞌ basa huta nggara.’ ");
INSERT INTO row_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Maneꞌ a rena nala onaꞌ naa ma, ana kasian e. Boe ma ana nggaris memaꞌ hendi basa pagau naa huta nara. Boe ma ana mboꞌi hendi pagawe naa. ");
INSERT INTO row_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Te leleꞌ pagawe naa dea neu, ma nandaa no nonoon esa nahuta e doiꞌ mbei. Boe ma ana toꞌu nala nonoon, de mese nggara boten ma bua e nae, ‘Weh! Faiꞌ ia bae huta ma leo!’ ");
INSERT INTO row_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nonoon rena nala onaꞌ naa ma, ana naloe aon fo sendeꞌ lululanggan de kokoe e nae, ‘Aduu! toronooꞌ, e! Tulun fee fai mbei nema au dei! Dei fo au bae huta ngga.’ ");
INSERT INTO row_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Te pagawe naa nae, ‘Nda bisa sa! Akaꞌ faiꞌ ia musi bae!’ Basa ma ana nendi nonoon bui rala neu, losa ana bae nabasaꞌ hutan. ");
INSERT INTO row_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Leleꞌ maneꞌ a pagawe laen nara rita saa fo manadadꞌiꞌ naa, ma rala nara susa. De basa ma reu rafadꞌe neu maneꞌ a. ");
INSERT INTO row_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Maneꞌ a rena nala onaꞌ naa ma, ana noꞌe pagawe naa, de olaꞌ nae, ‘Hee, atahori deꞌulakaꞌ! Huu moꞌe Au kasian nggo, naa de au nggaris hendi basa huta-buku mara. ");
INSERT INTO row_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Te taꞌo bee de nda muꞌena kasian neu nonoom sa, onaꞌ au kasian neu nggo ena to?’ ");
INSERT INTO row_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Maneꞌ a namue, losa ana denu atahori tao e bꞌui rala neu, fo ara poko-paru e, losa ana bae nabasaꞌ huta-buku nara.” ");
INSERT INTO row_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Boe ma Yesus nateꞌe dudꞌuit na, ma nafadꞌe nae, “Naa, Au Ama ngga sia sorga boe o ito-reken onaꞌ naa boe. Dei fo Ana hukun nggi, mete ma ama nda liliiꞌ tebꞌe-tebꞌe hendiꞌ hei toronoo atahori mamahere mara sala-kilu nara sa.” ");
INSERT INTO row_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesus nanori basa naa ra ma, Ana lao hela Galilea de nisiꞌ profinsi Yudea sia Loe Yarden bobꞌoan. ");
INSERT INTO row_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Atahori hetar tungga E, ma Ana naꞌahahaiꞌ atahori hedꞌis mana sia naa ra. ");
INSERT INTO row_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Hambu atahori Farisi hira rema rae teꞌe-sii ratudꞌaꞌ E. Ara ratane rae, “Amaꞌ! Tungga hita hohoro-lalane agaman, mete ma touꞌ sa sao ena na, ana bole hela hendi saon nendiꞌ sudꞌiꞌ a dalaꞌ sa, do? Do taꞌo bee?” ");
INSERT INTO row_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Te Ana nataa nae, “Hei ia ra, atahori mahineꞌ agama. Te taꞌo bee de ama nda mihine Lamatualain Susura Meumaren isin sa? Sia Dudꞌui Fefeuꞌa, nenesuraꞌ oi, ‘Lamatualain naꞌadꞌadꞌadꞌiꞌ atahori, touꞌ no inaꞌ.’ ");
INSERT INTO row_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Boe ma nenesuraꞌ fai nae, ‘Huu naa, touꞌ musi lao hela ina-ama nara, fo neu nasodꞌa ralaꞌ sa no saon, huu ruꞌa se dadꞌi reu esa ena.’ ");
INSERT INTO row_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Huu naa, de mete ma Lamatualain tao nala ruꞌa se dadꞌi esa ena, na, atahori afiꞌ fee se mahelaꞌ fai!” ");
INSERT INTO row_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Rena Yesus ola naꞌo naa ma, atahori Farisi ra ratane fai rae, “Mete ma taꞌo naa, na, taꞌo bee de baꞌi Musa nae, atahori bole mahelaꞌ, sadꞌi ana fee susura mahelaꞌ neu saon dei?” ");
INSERT INTO row_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Boe ma Yesus nataa fai nae, “Baꞌi Musa hela bei-baꞌi mara mahelaꞌ ro saon nara, huu, langga fatu nara onaꞌ nggi boe! Te leleꞌ Lamatualain naꞌadadadꞌi raefafoꞌ ia, Masud na nda taꞌo naa sa. ");
INSERT INTO row_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Naa de Au ufadꞌe, e! Mete ma inaꞌ hohongge naꞌahuluꞌ na touꞌ a bole mahelaꞌ. Te mete ma inaꞌ nda hohongge sa, te touꞌ a hela hendi inaꞌ a, ma sao seluꞌ inaꞌ laen, na, touꞌ a o hohongge ena boe!” ");
INSERT INTO row_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Rena Ana olaꞌ naꞌo naa, ma ana mana tungga nara olaꞌ rae, “Mete ma taꞌo naa na malole lenaꞌ afiꞌ sao.” ");
INSERT INTO row_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Boe ma Yesus nataa nae, “Nda basa atahori simbo Au oꞌola ngga ia sa. Akaꞌ atahori fo Lamatualain dudꞌu memaꞌ a. ");
INSERT INTO row_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Hambu atahori nda sao sa, huu ao-sisin nenendin tao e nda bisa sao sa. Hambu fai nda sao sa, huu atahori tao raꞌamate ua sasao nara. Boe ma hambu o, ara nda rae sao sa, huu ana naeꞌa nalalao Lamatualain ue-tataon. Atahori mana bisa nahine nenoriꞌ ia, na, hela e simbo.” ");
INSERT INTO row_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Leleꞌ naa, atahori oꞌo ro ana nara risiꞌ Yesus, fo Ana lalaa liman ma olaꞌ papala-babꞌanggiꞌ fee se. Te ana mana tungga nara raꞌangge atahori naa ra. ");
INSERT INTO row_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ma Yesus namanasa se nae, “Hela ana diki ra rema risiꞌ Au! Afiꞌ neꞌengge se! Te atahori mana onaꞌ ana dikiꞌ ia ra, naeni Lamatualain atahori nara.” ");
INSERT INTO row_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Basa ma Ana lalaa liman neu ana dikiꞌ ra, de noꞌe Lamatualain fee se papala-babꞌanggiꞌ. Basa naa ma, Ana lao hela mamanaꞌ naa. ");
INSERT INTO row_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Lao esa ma, hambu atahori rema ratane Yesus rae, “Ama meser! Au musi tao maloleꞌ taꞌo bee, fo uhine tebꞌe ae, au bisa maso sorga? Te au nau usodꞌa uꞌubꞌue ukundoo o Lamatualain.” ");
INSERT INTO row_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Boe ma Ana nataa nae, “Taꞌo bee de mutane Au soꞌal saa fo maloleꞌ? Akaꞌ Lamatualain fo maloleꞌ. Mete ma mae musodꞌa mo E, naa, musodꞌa tungga parendan.” ");
INSERT INTO row_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Atahori naa natane fai nae, “Parendaꞌ bee ka?” Boe ma Yesus nataa nae, “Afiꞌ misa atahori; afiꞌ hohongge; afiꞌ mumunaꞌo; afiꞌ dadꞌi sakasii peko-lelekoꞌ; ");
INSERT INTO row_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","fee hada-hormat neu ina-ama mara; ma sue toronoo odi-aꞌa mara onaꞌ ho sue aom boe.” ");
INSERT INTO row_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Atahori naa nataa nae, “Naa, basa parendaꞌ naa ra, au tao ena. Feꞌe kuran saa fai?” ");
INSERT INTO row_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesus rena taꞌo naa, ma nae, “Naa! Mete ma mae tungga basa Lamatuaꞌ hihii-nanaun, na, baliꞌ fo seo hendi basa hata-hetom. Fo muu babꞌanggi doi nara neu atahori mana toꞌa-taꞌ ra. Huu dei fo Lamatualain bala-bꞌae fee nggo hata-hetoꞌ naeꞌ sia sorga. Basaꞌ fo, baliꞌ uma tungga Au.” ");
INSERT INTO row_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Rena taꞌo naa, ma atahori naa baliꞌ no rala sususaꞌ, huu suꞌin naen seli. ");
INSERT INTO row_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Basa ma Yesus olaꞌ no ana mana tungga nara nae, “Mimihere Au, te atahori mamasuꞌiꞌ a susaꞌ fo ana masoꞌ sorga. ");
INSERT INTO row_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Eni sususan, onaꞌ banda onta monaeꞌ, masoꞌ nisiꞌ lalaet na tungga sosoot ndolan.” ");
INSERT INTO row_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Rena taꞌo naa ma, ana mana tungga nara titindindi. Boe ma rataa rae, “Mete ma taꞌo naa, na, seka bisa masoꞌ sorga?” ");
INSERT INTO row_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ana mete maꞌabꞌebꞌesa se, ma Ana olaꞌ nae, “Mete ma atahori mana tao, memaꞌ nda bisa sa. Te mete ma Lamatualain mana tao, na, basaꞌ e bisa dadꞌi!” ");
INSERT INTO row_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Boe ma Petrus fee nesenenedꞌaꞌ nae, “Amaꞌ! Hai lao hela basa hata-heto mara ena, de tungga Amaꞌ. Te hai hambu saa?” ");
INSERT INTO row_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ana nataa nae, “Mimihere Au! Dei fo leleꞌ Lamatualain tao nafefeu baliꞌ basaꞌ e, Au, Atahori Matetuꞌ ia, endoꞌ sia kadꞌera parenda monaeꞌ a. Leleꞌ naa, hei mana tungga Au ra, endoꞌ sia kadꞌera parendaꞌ ka sanahulu ruaꞌ ra ata, fo dadꞌi mana nggero soꞌaꞌ neu hita leo Israꞌel ka sanahulu rua tara. ");
INSERT INTO row_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Atahori mana lao hela umen, odi-aꞌan, ina-aman, ana nara, osi-lutun, fo tungga Au, dei fo ana simbo baliꞌ losa lao natun esa. Ma mete ma raefafoꞌ ia nateꞌe, na, ana hambu nasodꞌa nakandoo no Lamatuaꞌ. ");
INSERT INTO row_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","De misinedꞌa, e! Tungga Lamatualain dudꞌuꞌan, atahori hetar mana tao rananaru ao nara, sira ia ra, atahori anadꞌiki manaseliꞌ. Te atahori mana raloe ao nara dadꞌi anadꞌiki manaseliꞌ, tungga Lamatuaꞌ dudꞌuꞌan, naa, sira ia ra, atahori moko-monaen.” ");
INSERT INTO row_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Basa naa ma, Yesus nanori nae, “Lamatualain totoꞌu parendan, onaꞌ nekendandaaꞌ ia: hambu tenu osiꞌ esa feꞌe fefetu anaꞌ liiꞌ nee te ana lao, neu sangga atahori fo tao ues sia osi anggor na. ");
INSERT INTO row_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ana hambu atahori mana tao ues, boe ma ara rala haraꞌ esa de tao ues fai sa na, sesebꞌan, doi fulaꞌ esa, tungga felin. Raꞌaheiꞌ basa ma, ana denu se reu tao ues sia osin rala. ");
INSERT INTO row_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Liiꞌ sio fefetun ma, ana lao pasar neu. Sia naa nita atahori hira mana endoꞌ hie-hieꞌ a. ");
INSERT INTO row_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Boe ma ana nafadꞌe se nae, ‘We aꞌa nggara e! Hei nau tao ues sia au osi ngga, do? Dei fo au bae nggi tungga ndandaan.’ Rena rala taꞌo naa ma, ara raꞌaheiꞌ neuꞌ ena, de reu ue-tao. ");
INSERT INTO row_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Liiꞌ sanahulu rua reorendun no liiꞌ telu bobꞌon, tenu osiꞌ a lao hela umen, de neu sangga seluꞌ mana tao ues fai. ");
INSERT INTO row_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Mbei ma liiꞌ lima bobꞌon, ma tenu osiꞌ a lao fai. Ana mete neu-nema ma, feꞌe hambu atahori mana bakariiꞌ hie-hieꞌ a. Boe ma natane se nae, ‘Taꞌo bee de ama ririi hie-hieꞌ a mia fefetun losa bobꞌon, nda tao saa sa boe?’ ");
INSERT INTO row_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Atahori naa ra rataa rae, ‘Amaꞌ e! Nda hambu atahori fee hai ue-tataos sa.’ Basa ma, tenu osiꞌ a nae, ‘Mete ma taꞌo naa, naa, ama mii tao ues sia osi ngga leo!’ ");
INSERT INTO row_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Losa jam hahae tao ues ma, tenu osiꞌ a noꞌe dedꞌenun de nae, ‘Moꞌe atahori mana tao ues ra, fo bae esa-esaꞌ nggadi nara leo. Mulai mia atahori mana maso tao ues maꞌabꞌuit a losa mana tao ues fefeun.’ ");
INSERT INTO row_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","De dedꞌenun noꞌe atahori mana tao ues mia liiꞌ lima bobꞌon. Ana fee se esa na simbo doi fulaꞌ esa. ");
INSERT INTO row_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Basa ma, dedꞌenun noꞌe atahori mana tao ues laen ra, losa atahori mana tao ues eniꞌ a liiꞌ nee fefetun. Mana tao ues mia fefetun duꞌa rae, neꞌo sira simbo naeꞌ lena mana tao ues mia liiꞌ lima bobꞌon. Tao-tao te, ara o simbo doi fulaꞌ beꞌe esaꞌ boe. ");
INSERT INTO row_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Simbo onaꞌ naa ma, ara ramue tenu osiꞌ a rae, ");
INSERT INTO row_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Aweꞌ! Nda bisa taꞌo ia sa, malangga! Sira mana rema maꞌabuit ra, tao ues akaꞌ liiꞌ esaꞌ a. Te hai mana masoꞌ tao ues eniꞌ a fefetu anan ia, tao ues mitaꞌ mamate mara losa mbusar nandali! Te taꞌo bee de malangga bae hai onaꞌ naa ra boe?’ ");
INSERT INTO row_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Boe ma tenu osiꞌ a nataa neu esa nae, ‘Aꞌa, e! Au nda laka aꞌa sa. Huu aꞌa naꞌaheiꞌ tao ues fai sa naa, eni babꞌaen doi fulaꞌ esa. Tebꞌe, to? Dadꞌi au bꞌae tungga hita oꞌolan, to? ");
INSERT INTO row_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Malole lenaꞌ, aꞌa simbo doi babꞌaem fo baliꞌ leo. Mete ma au ae fee atahori mana rema tao ues raꞌabuit aꞌa naa babꞌaen onaꞌ saa fo au fee aꞌa boe, na, au hihii-nanau ngga. ");
INSERT INTO row_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Neꞌo au bisa pake-nggao doi ngga tungga hihii ngga. Taꞌo bee de aꞌa namanasa au huu uꞌena rala maloleꞌ?’ ");
INSERT INTO row_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Onaꞌ naa boe, leleꞌ Lamatualain dadꞌi Maneꞌ soaꞌ neu atahori ra, Ana bala-bꞌae atahori ra tungga hihii-nanaun. De atahori mana nema naꞌabꞌuit, dei fo ana simbo babꞌanggin onaꞌ atahori mana nema naꞌahuluꞌa boe. Boe ma atahori mana nema naꞌahuluꞌ a, dei fo ana simbo babꞌanggin onaꞌ atahori mana nema naꞌabꞌuit a boe. ");
INSERT INTO row_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Basa naa ma, Yesus se lao risiꞌ Yerusalem reu. Sia dalaꞌ taladꞌan, Ana noꞌe ana mana tungga nara mesaꞌ se fo raꞌabꞌue ro E. Dei de nafadꞌe seluꞌ nae, ");
INSERT INTO row_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Hei rena, e! Ia naa hita tae Yerusalem teu. Te sia naa ara seo hendi Au, Atahori Matetuꞌ a, neu malangga agama Yahudi ra malangga nara ro meser agama ra. Basa fo ara raꞌetuꞌ hukun risa Au. ");
INSERT INTO row_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Boe ma ara fee Au neu atahori laen nda mana rahine Lamatualain sa. Basa ma ara olaꞌ raꞌamamaeꞌ Au. Ma ara filo ralutu ao ngga. Dei de, ara tao risa Au sia hau ngganggeꞌ a. Memaꞌ tebꞌe Au mate. Te fini esan boe ma Au usodꞌa baliꞌ.” ");
INSERT INTO row_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Basa naa ma, Sabadeus saon no ana nara Yakobis no Yohanis reu risiꞌ Yesus. Ma ana sendeꞌ lululanggan ma fee hadꞌa-hormat fo kokoe Yesus. ");
INSERT INTO row_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Boe ma Yesus natane nae, “Mama, mae parlu saa? Boe ma mama naa nafadꞌe nae, “Taꞌo ia, Amaꞌ! Au oꞌe, mete ma Amaꞌ endoꞌ toꞌu parendaꞌ, na, Amaꞌ soꞌu ana nggara ruꞌa se, fo ara o toꞌu parendaꞌ tungga raꞌabꞌue ro Nggo boe. Au oꞌe fo Amaꞌ muꞌeꞌendo esa neu bobꞌoa onam, ma esa neu bobꞌoa diim.” ");
INSERT INTO row_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesus rena ana noꞌe onaꞌ naa ma, nafadꞌe neu Yakobis no Yohanis nae, “Hei nda mihine saa fo ama moꞌeꞌ a sa. Te dei fo Au hambu doidꞌosoꞌ naeꞌ. De taꞌo bee? Seꞌu te hei duꞌa mae hei o bisa lemba doidꞌosoꞌ naa miꞌibꞌue mo Au, do? Ruꞌa se rataa randaa rae, “Hai bisa, Amaꞌ, e!” ");
INSERT INTO row_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Basa ma Ana nataa fai nae, “Memaꞌ, dei fo hei o doidꞌoso onaꞌ Au boe. Te dei fo seka mana endoꞌ sia Au bobꞌoa ona ngga no dii ngga, Au nda uꞌetuꞌ naa sa. Lamatualain mana naꞌena hak naꞌetuꞌ naa. Lamatualain naꞌetuꞌ memaꞌ, seka mana endoꞌ sia mamanaꞌ naa ena.” ");
INSERT INTO row_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Leleꞌ ana mana tungga ka sanahuluꞌ ra rena ruꞌa se roꞌe taꞌo naa, ma, ramanasa. ");
INSERT INTO row_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Te Yesus noꞌe nala basa se, ma nafadꞌe nae, “Taꞌo ia! Hei bubꞌuluꞌ ena, to? Atahori moko-monaen mana toꞌu parendaꞌ ra biasa tuni-ndeni rauinggu nara, de nda tao rala saa sa boe. Ma malangga-malangga mia nusaꞌ fo nda mana rahine Lamatualain sa, ara parenda raꞌalelenaꞌ, de rauinggu nara nda botiꞌ rala langga nara sa. ");
INSERT INTO row_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","De ama sudꞌi boe tao taꞌo naa! Mia hei, seka nae dadꞌi atahori moko-monaen, ana musi dadꞌi onaꞌ ate fo mete-seꞌu atahori laen. ");
INSERT INTO row_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Boe ma seka nau dadꞌi malangga, ana musi tao aon onaꞌ ate. ");
INSERT INTO row_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Rena, e! Au o onaꞌ naa boe. Au, Atahori Matetuꞌ ia, uma fo mete-seꞌu atahori. Au nda uma fo atahori mete-seꞌu Au sa. Huu Au uma fee masodꞌa ngga teme-teme, fo tefa-soi neu atahori hetar sala-kilu nara.” ");
INSERT INTO row_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Basa naa ma, Yesus see lao rakandoo. Leleꞌ ara lao hela kota Yeriko, hambu atahori hetar tungga se boe. ");
INSERT INTO row_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Sia naa, atahori pokeꞌ rua endoꞌ sia dalaꞌ suun. Leleꞌ ara rena rae, mana tungga naa, naeni Yesus mia Nasaret, ma ara randu, rahereꞌ rae, “Papa! Daud tititi-nononosin, e! Hai mihani Papa doon seli ena! Kasian hai dei!” ");
INSERT INTO row_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Rena ara rameli raꞌo naa, ma atahori raꞌanggee rae, “Hee! Ama nenee!” Te ara bau rameli rahereꞌ lenaꞌ fai rae, “Papa, e! Daud tititi-nononosin, e! Kasian hai dei!” ");
INSERT INTO row_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Leleꞌ Ana rena raꞌo naa, ma Ana nambariiꞌ de natane se nae, “Hei nau Au tao saa fee nggi?” ");
INSERT INTO row_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ara rataa rae, “Papa, e! Tulun fo hai mete mita dei!” ");
INSERT INTO row_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Rena ara olaꞌ taꞌo naa, ma Ana kasian se. De Ana nggama mata nara, ma ara mete rita neuꞌ ena boe. Basa naa ma, ara lao tungga E. ");
INSERT INTO row_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Basa naa ma, Yesus se lao rakandoo losa kamboꞌ sa naran Betfage, sia lete Saitun sun. Kamboꞌ naa deka no kota Yerusalem ena. Ara hahae mbei sia naa. Boe ma Ana denu mana tungga nara atahori rua reu raꞌahuluꞌ ");
INSERT INTO row_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ana parenda se nae, “Ruꞌa nggi kamboꞌ naa mii. Mete ma hei rala mii, dei fo ama mita banda keledei ine no anan esa, nenepaꞌaꞌ sia naa. Hei mii sefi hendi tali nara fo lea mendi fee Au. ");
INSERT INTO row_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Te mete ma atahori ratane nggi rae, ‘Taꞌo bee de hei lea mendi atahori banda keledꞌein?’ Naa, ama mitaa mae, ‘Lamatuaꞌ nae pake. Mete ma Ana pake basa naa, dei fo haitua baliꞌ neuꞌ ena.’ ");
INSERT INTO row_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Basa ia musi dadꞌi, tungga saa fo Lamatualain mana ola-olan sura memaꞌ ena oi, ");
INSERT INTO row_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","‘Wae, hei atahori Yerusalem ra e! Ima, mete ia dei! Te hei Mane ma nema ena. Ana nema no rala naloe-nedꞌaeꞌ. Ana nema sae keledꞌei anaꞌ.’” ");
INSERT INTO row_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Basa ma ana dedꞌenu nara reu, de tao tungga basa saa fo Yesus helu-fuli neu se. ");
INSERT INTO row_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ara lea rendi keledei ine no anan fee neu Yesus. Ara bela lafe nara, de Ana sae fo nae kota Yerusalem rala neu. ");
INSERT INTO row_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Leleꞌ ara rae kota rala reu boe, atahori hetar haꞌi lafe ma salendan nara, de bela neu dalaꞌ. Hambu ruma reu tati palma roon de bela neu dalaꞌ taladꞌan. No taꞌo naa, ara tao tatandaꞌ rae, sira soru E onaꞌ atahori moko-monaen. ");
INSERT INTO row_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Boe ma atahori ruma laoꞌ raꞌahuluꞌ Yesus, ma ruma tungga-tungga dea. Ara randu randaa rae, “Hosana! Hai koa-kio Lamatualain! Huu Daud tititi-nononosin nema ena! Hosana! Hai koa-kio Lamatualain! Huu Lamatuaꞌ denu Atahori ia nema ena. Hosana! Hai koa-kio Lamatualain! Huu Lamatuaꞌ endoꞌ parenda memaꞌ sia lalai mamana naruꞌ ata!” ");
INSERT INTO row_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Leleꞌ Yesus Yerusalem rala neu no rarameꞌ naa, ma basa kota isin dea reu ratatane rae, “Awii! Mana nemaꞌ ia, seka?” ");
INSERT INTO row_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Atahori hetar rataa rae, “Eni ia, Lamatualain mana ola-olan. Naran Yesus, atahori Nasaret, mia profinsi Galilea,” ");
INSERT INTO row_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Basa ma Yesus se lao rakandoo, de lao risiꞌ Lamatualain Ume Hule-oꞌe Huu na rala reu. Sia Ume Hule-oꞌeꞌ a sodꞌan, atahori tao dadꞌi neu pasar de raseoꞌ mbui lunda fo atahori tao rendiꞌ neu tutunu-hohotuꞌ soaꞌ neu hule-oꞌeꞌ a. Yesus nita taꞌo naa ma, neu oi hendi se dea reu. Ana mbesiꞌ leꞌa-nggari hendi mei-mei fo ara tukar rendiꞌ neu doiꞌ, ma mbesiꞌ naꞌalelenggaꞌ banggu fo ara raseoꞌ rendiꞌ neu mbuiꞌ ra. ");
INSERT INTO row_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Boe ma Ana nafadꞌe se nae, “Lamatualain mana ola-olan suraꞌ hela oi, ‘Au ufefela Ume ia fo atahori rema hule-oꞌe sia ia.’ Lamatuaꞌ masud na taꞌo naa, te hei tao Ume ia dadꞌi rambok ra mamana neꞌebꞌuen!” ");
INSERT INTO row_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Basa ma atahori pokeꞌ no atahori kekoꞌ ra rema risiꞌ Yesus sia Lamatualain Ume Hule-oꞌe na. Boe ma Ana naꞌahahaiꞌ basa se. ");
INSERT INTO row_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Malangga agama Yahudi ra malangga nara ro meser agama ra o sia naa boe. Leleꞌ ara rita Yesus tao onaꞌ naa ma, ara ramanasa. Lelenan fai, leleꞌ ara rena ana kara randu ona esaꞌ sia Ume Hule-oꞌe a rae, Hosana! Hai koa-kio Lamatualain! Huu mane Daud tititi-nonosin nema ena!” ");
INSERT INTO row_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Basa naa ma, malangga ra rafadꞌe Yesus rae, “Weh! Ho rena anaꞌ naa ra oꞌola nara, do? Naa nda ndaa sa!” Te Yesus nataa se nae, “Hei, Au rena. Te taꞌo bee? Hei nda feꞌe baca mita Lamatualain Susura Meumaren soꞌal ana mana koa-kio Lamatualain sa, do? Sia naa nenesuraꞌ oi, ‘Lamatualain sadꞌia memaꞌ ana mana bonggi feuꞌ no anadꞌikiꞌ, fo ara koa-kio E.’” ");
INSERT INTO row_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Basa ma, Yesus se lao hela kota naa, de reu sungguꞌ sia kambo Betania. ");
INSERT INTO row_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mbilaꞌ neu feꞌe fefetu anan, ma Yesus se lao fai risiꞌ kota Yerusalem rala reu. Te sia dalaꞌ taladꞌan ma, Ana ndoe. ");
INSERT INTO row_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ana nita hau huuꞌ sa sia dalaꞌ suun fo atahori biasa ra boan. Dadꞌi Ana neu deka-deka hau huuꞌ naa, nae mete sobꞌa mabꞌoaꞌ, do hokoꞌ. Te leleꞌ Ana losa hau huuꞌ naa, nda nita boaꞌ esa saa boe, te nitaꞌ a roon. Boe ma Ana olaꞌ neu hau huuꞌ naa nae, “Huu nda mubꞌoa fee Au sa, de sudꞌi mubꞌoa leo!” Ana olaꞌ basa ma, hau huuꞌ naa o meto neuꞌ ena boe. ");
INSERT INTO row_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ana mana tungga nara rita onaꞌ naa ma, ara nggengger. Ara ratane rae, “Taꞌo bee de hie-hieꞌ ma hau huuꞌ ia meto neuꞌ ena? ");
INSERT INTO row_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Boe ma Ana nataa nae, “Rena malolole, e! Mete ma hei mimihere tebꞌe-tebꞌeꞌ neu Lamatuaꞌ, ma rala mara nda babꞌanggi mbei sa boe, na hei bisa tao malaꞌ onaꞌ Au tao alaꞌ ra ena. Hei o bisa tao malaꞌ lenaꞌ naa fai. Onaꞌ a: Hei bisa parenda mala leteꞌ sa laliꞌ tasi neu. Neꞌo Lamatualain fee leteꞌ naa lali neuꞌ ena, sadꞌi hei mimihere tebꞌe-tebꞌeꞌ neu E! ");
INSERT INTO row_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Huu basa dalaꞌ fo hei moꞌe sia Lamatualain, dei fo ama simbo, sadꞌi mimihere tebꞌe-tebꞌeꞌ neu e.” ");
INSERT INTO row_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Basa ma Yesus se lao rakandoo. Losa Yerusalem, ara rala reu risi Ume Hule-oꞌe Huuꞌ a sodꞌan fai. Leleꞌ Ana nanori Lamatualain dala masodꞌan, ma malangga agama Yahudi ra malangga nara, ro lasi-lasi adat ra reu ratane E rae, “Afis a seka mana denu nggo uma tao kaco mia ia? Seka mana fee nggo hak naa?” ");
INSERT INTO row_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Te Ana nahine ara sangga dalaꞌ fo rae raꞌatutudꞌaꞌ E. De Ana nataa mbali se nae, “Au o ae utane nggi. Hei mitaa Au dei, dei fo Au utaa nggi boe. ");
INSERT INTO row_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Au ae utane taꞌo ia: Basa hei mihine Yohanis, mana saraniꞌ naa, to? Naa, seka mana fee ne hak fo sarani atahori? Lamatualain do, atahori?” Boe ma ara duꞌa reu-rema, ma rala haraꞌ rae, “Aweꞌ! Hita neneteꞌe-sii ia, ma! Huu mete ma hita tataa tae, “Lamatualain mana fee ne hak’, dei fo Ana nataa nae, ‘Mete ma taꞌo naa, na taꞌo bee de hei nda mimihere Yohanis sa?’ ");
INSERT INTO row_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Te hita o nda bisa olaꞌ tae, ‘Atahori mana fee ne hak’, te dei fo basa atahori ra ramue nggita. Huu ara ramahere rae, Yohanis naa, Lamatualain mana ola-olan.” ");
INSERT INTO row_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Naeni de rataa Yesus rae, “Hai nda mihine sa.” Boe ma Yesus nataa se nae, “Naa! Mete ma taꞌo naa, na Au o nda parlu ufadꞌe ae seka mana fee hak naa neu Au sa boe.” ");
INSERT INTO row_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesus olaꞌ nakandoo no malangga naa ra nae, “Hei duꞌa taꞌo bee soꞌal nekendandaaꞌ ia? Hambu amaꞌ esa no anan touꞌ rua. Ana denu ana ulun nae, ‘Ana ngge! Faiꞌ ia, muu tao ues sia osi a dei.’ ");
INSERT INTO row_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Te anaꞌ naa nataa nae, ‘Eeh! Au nda uu sa.’ Te nda dooꞌ sa ma ana fale ralan, de neu. ");
INSERT INTO row_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Basa ma, amaꞌ naa denu ana karuan nae, ‘Ana ngge! Faiꞌ ia, muu tao ues sia osi a dei.’ Boe ma anaꞌ naa nataa nae, ‘Ia amaꞌ. Dei fo au uu.’ Tao-tao te ana nda neu sa.” ");
INSERT INTO row_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Yesus dui basa ma, natane se nae, “Naa, Au ae utane taꞌo ia: mia ana karuaꞌ naa ra, bee ka mana tao tungga aman parendan?” Boe ma ara rataa rae, “Ana uluꞌ a!” Basa de Ana olaꞌ nae, “Hei. Te rena malolole, huu Au olaꞌ matetuꞌ. Atahori fo hei cap mae atahori nda papakeꞌ ra sa, onaꞌ mana edꞌa bea, ma ina dalaꞌ ra, dei fo ara masoꞌ raꞌahuluꞌ nggi risi Lamatualain umen rala. Huu hei akaꞌ miꞌihei-miꞌihuuꞌ neu Lamatuaꞌ, te nda tao tungga Hihii-nanaun sa. ");
INSERT INTO row_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Feꞌesaꞌan, Yohanis mana saraniꞌ a nanori neu nggi dalaꞌ taꞌo bee fo ama bisa misodꞌa no ndoo-tetuꞌ. Te hei nda nau mimihere e sa. Tao-tao te, leleꞌ atahori nda papakeꞌ ra sa rena Yohanis, ara lao hela sala-kilu nara, de tungga nenori-nefadꞌen. Hei o mita atahori naa ra ramahere Yohanis te hei nda nau mimihere e sa, fo miloeꞌ mia sala-kilu mara, fo tungga Lamatualain hihii-nanaun. ");
INSERT INTO row_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Basa naa ma, Yesus dui nekendandaaꞌ esa fai nae, “Hambu tenu raeꞌ esa neu tao osi feuꞌ, fo nae sela hau anggor sia raen mbei. Boe ma ana lutu-mbaa rereoꞌ e. Boe ma ana tao bak fo nae ee boa anggor oen. Boe ma naririi mamana nanea naruꞌ esa. Basa ma ana fee atahori tao osin, fo ara banggi buna-bꞌoan neu rua ro eni. Boe ma ana lao nusa deaꞌ neu. ");
INSERT INTO row_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Losa fula-fai seu anggor boan, ma tenu osiꞌ a denu ana mana tungga nara reu sia mana tao osi a, fo roꞌe eni hahambun. ");
INSERT INTO row_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Te mana tao osi ra nda tao afiꞌ mbali ana mana tungga nara sa. Ruma hambu lima-eiꞌ, ruma nenetati nisaꞌ, ma ruma nenehonda-mbiaꞌ no fatu. ");
INSERT INTO row_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Te tenu osiꞌ a denu seluꞌ ana mana tungga nara nononggoꞌ esa hetar lenaꞌ fefeun. Te mana tao osi ra tao deꞌulaka onaꞌ naa neu basa se boe. ");
INSERT INTO row_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Doo-doo ma, tenu osiꞌ a denu ana bonggin. Huu ana duꞌa nae, ‘Mete ma au haitua ana bonggi ngga, neꞌo ara simbo no malole, ma rena e.’ ");
INSERT INTO row_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Te leleꞌ mana tao osi ra rita anan, ma ara ola-olaꞌ rae, ‘We, hei mete dei! Tou lasiꞌ a haitua ana bonggin. Eni mana simbo basa toulasiꞌ a hata-heton. De ima fo ata tao tisa E leo, naa fo ata hambu osi ia.’ ");
INSERT INTO row_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Boe ma ara toꞌu rala anaꞌ naa, de lea rendi e nisiꞌ osi a deaꞌ fo tao risa e.” ");
INSERT INTO row_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesus dui basa ma, natane se nae, “Naa, Au ae utane taꞌo ia: mete ma tenuꞌ osiꞌ a baliꞌ ana tao taꞌo bee mbali mana tao osi ra?” ");
INSERT INTO row_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Basa ma, atahori Yahudi ra malangga nara rataa rae, “Neꞌo ana tao nisa basa atahori deꞌulakaꞌ naa ra. Basa naa, ana fee osi a neu atahori feaꞌ ra tao, fo nandaa no fula-fain, na banggi buna-bꞌoan.” ");
INSERT INTO row_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Basa de Yesus olaꞌ no se nae, “Mbei ma hei nda baca mita sia Lamatualain Susura Meumaren oi, ‘Hambu fatu esa mana tati fatu ra nggari hendi ena, te ia na fatu naa dadꞌi neu ume a fatu netehun! Lamatualain mana tengga nala, ma naꞌeꞌendo fatu naa. Naa de ata tita e malolen seli!’” ");
INSERT INTO row_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Basa ma Yesus tute oꞌolan nae, “Dadꞌi ama duꞌa matalolole, e. Dalahulun, Lamatuaꞌ tengga hita atahori Yahudi ra ia, fo dadꞌi atahorin. Te huu hei nda nau tao afiꞌ neu Au sa, dei fo Lamatuaꞌ tengga atahori feaꞌ ra. Huu akaꞌ atahori mana nasodꞌa tungga Eni Hihii-nanaun bisa dadꞌi Eni atahorin. ");
INSERT INTO row_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Au ufadꞌe relo-relo ena. Au ia, naeni fatu netehuuꞌ naa. Atahori mana tudꞌa neu fatu ia, neꞌo atahori naa nambalulutu. Ma mete ma fatu naa tudꞌa dai atahori, neꞌo atahori naa dadꞌi afu neu ꞌena.” ");
INSERT INTO row_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Leleꞌ malangga agama Yahudi ra malangga nara ro atahori Farisi ra rena Yesus dui taꞌo naa, ma ara rahine rae, Ana olaꞌ naa neu sira. Sira onaꞌ atahori mana tao osi naa ra, ma mana tati fatu mana nggari hendi fatu netehuuꞌ naa. ");
INSERT INTO row_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","De ramanasa seli. Basa ma, ara sangga dalaꞌ fo rae humu E. Te ramatau atahori hetar huu ara rae Yesus naa, Lamatualain mana ola-olan. Naeni de ara nda rambarani tao saa-saa neu E sa boe. ");
INSERT INTO row_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Basa ma Yesus olaꞌ no se fai nendiꞌ nekendandaaꞌ nae, ");
INSERT INTO row_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Lamatualain toꞌu parendan naa, onaꞌ maneꞌ sa tao fefeta kakabꞌiꞌ fee ana toun. ");
INSERT INTO row_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Leleꞌ ara sadꞌia rala fefetas ma, ana denu ate nara reu rafadꞌe atahori nene neroloꞌ ra oi, ‘Ima, te fefetas sangga nae mulai ena.’ Te atahori naa ra nda nau rema sa. ");
INSERT INTO row_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Basa ma, ate ra baliꞌ reu rafadꞌe maneꞌ a. Maneꞌ a rena nala ma ana denu aten laen fai nae, ‘Hei mii mifadꞌe atahori naa ra, fo rema leo, te fefetas nenesadꞌiaꞌ ena. Au tati sapi a ena, ma tunu-nasu ala e maladꞌan seli. Denu se rema raa fefetas leo, huu basaꞌ e nenesadꞌiaꞌ ena.’ ");
INSERT INTO row_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ate naa ra reu rafadꞌe raꞌo naa. Te atahori nene neroloꞌ ra nda nau taoafiꞌ sa. Ruma osi rala reu, ruma reu sia mamana tao ue-osan nara, ");
INSERT INTO row_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ma ruma toꞌu rala maneꞌ a ate nara, de poko-paru se losa ara mate. ");
INSERT INTO row_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Rena onaꞌ naa ma, maneꞌ a namanasa nala seli. Basa ma, ana denu soldꞌadꞌu nara reu tati risa atahori mana tati risa ate nara. Basa de, soldꞌadꞌu ra hotu-lalangge hendi nusaꞌ naa losa taa no rae a. ");
INSERT INTO row_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Basa ma, maneꞌ a noꞌe nala ate laen nara de nafadꞌe se nae, “Fefeta kakabꞌiꞌ a nenesadꞌiaꞌ ena, te atahori fo au uroloꞌ ra, nda randaa tungga au fefeta ngga sa. ");
INSERT INTO row_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ia na, ama mii sia dala rarameꞌ fo mindaa mo sudꞌiꞌ a se, na moꞌe mendi se.’ ");
INSERT INTO row_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Basa de, ate naa ra lao reu sia dala rarameꞌ ra. Ara randaa ro atahori hetar mia naa, de ro se risiꞌ fefeta kakabꞌiꞌ a. Hambu atahori maloleꞌ ma atahori nda maloleꞌ ra sa rema tao rasofe mamana fefetas a. ");
INSERT INTO row_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Basa ma, maneꞌ a nisi mamana fefetas rala neu de mete rereoꞌ fuiꞌ ra. Ma ana nita atahori esa nda pake buꞌa-baꞌu fefetas sa. ");
INSERT INTO row_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Boe ma maneꞌ a natane nae, ‘Hee, toronooꞌ! saa de misiꞌ mamanaꞌ ia, na nda pake bua-baꞌu fefetas saa?’ Te atahori naa titindindii onaꞌ nggoaꞌ e. ");
INSERT INTO row_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Boe ma maneꞌ a parenda ana mana tungga nara nae, paꞌa atahori ia ei-lima nara, fo toꞌu nggari e dea neu. Hela e nggae ma doidꞌoso sia mamana maꞌahatuꞌ naa.’ ");
INSERT INTO row_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Onaꞌ naa boe, Lamatualain narolo atahori hetar, te tengga nala akaꞌ idꞌaꞌ dadꞌi neu Eni atahorin.’ ");
INSERT INTO row_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Atahori Farisi ra rena rala Yesus olaꞌ naꞌo naa, ma rala haraꞌ fo rae teꞌe-sii ma fua salaꞌ neu E. ");
INSERT INTO row_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Basa ma ara denu ana mana tungga nara reu ro atahori mia Herodes partei politik na, fo reu raselu-bale ro Yesus. Ara koa-boꞌu Yesus rae, “Ama Meser! Hai mihine Amaꞌ ralan ndoos. Amaꞌ nda mana peko-lelekoꞌ ma nda pili-tadꞌa sa. Amaꞌ akaꞌ nanori Lamatualain Hara-liin no matetuꞌ. ");
INSERT INTO row_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","De ia na, hai mae mitane dalaꞌ sa. Tungga hita atoran agama Yahudi na, ata musi bae bea neu mana parenda Roma manen, do afiꞌ?” ");
INSERT INTO row_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Te Yesus nahine ara rae teꞌe-sii E, fo Ana olaꞌ labꞌan mana parenda Roma. Boe ma Ana nataa nae, “Memaꞌ hei atahori mana dea-ralaꞌ! Taꞌo bee de hei mae teꞌe-sii Au mendiꞌ soꞌal naa? ");
INSERT INTO row_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mitudꞌu sobꞌa Au doi fulaꞌ sa fo atahori bae rendiꞌ neu bea!” Boe ma ara ratudꞌu doi fulaꞌ neu E. ");
INSERT INTO row_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Basa ma, Ana natane se nae, “Ia seka mata-aon ia? Ma ia seka naran ia?” ");
INSERT INTO row_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ara rataa rae, “Naa keser, mana parenda Roma mane monaen.” Boe ma Yesus nafadꞌe se nae, “Naa! Mete ma taꞌo naa, hei fee neu mana parenda, saa fo mana parenda hak na. Ma fee neu Lamatualain saa fo Lamatualain hak na.” ");
INSERT INTO row_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Rena Ana nataa naꞌo naa, ma basa se titindindii, huu Ana olaꞌ naa ndaa na. Naa de ara nda teꞌe-sii rala E sa. Boe ma ara lao hela E. ");
INSERT INTO row_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Sia naa hambu atahori mia partei Saduki boe. Atahori mia partei Saduki ia, nanori nae, atahori mates ra nda rasodꞌa baliꞌ sa. Faiꞌ naa, ara rae sangga dalaꞌ fo teꞌe-sii Yesus. Naeni de ara rema raselu-bale ro E rae, ");
INSERT INTO row_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Ama Meser! Baꞌi Musa suraꞌ hela fee hai, adat ia, nae: mete ma touꞌ esa mate hela saon, te nda ma anaꞌ sa, na, touꞌ naa odꞌin musi sao nala ina falu naa, naa fo ana bonggi fee aꞌan mana mateꞌ a tititi-nonosiꞌ. ");
INSERT INTO row_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Memaꞌ, feꞌesaꞌan baꞌi Musa nanori taꞌo naa, te ia na hai mae mitane taꞌo ia: hambu touꞌ hitu odꞌi-aꞌa bonggiꞌ. Uluꞌ ka sao, te mate, nda ma anaꞌ sa. Boe ma odꞌin mana tungga e, sao nala ina falu naa. ");
INSERT INTO row_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Nda dooꞌ sa ma ana mate fai, ma nda ma anaꞌ sa. Onaꞌ naa boe odꞌin ka telun, ana sao nala ina falu naa, te basa ma mate fai, te nda ma anaꞌ sa. Onaꞌ naa rakandondooꞌ a losa odꞌin muriꞌ a mate, nda lao hela anaꞌ sa. ");
INSERT INTO row_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Basa ma, ina falu a mate. ");
INSERT INTO row_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Naa! Hai mae mitane taꞌo ia: Inaꞌ naa sao nala touꞌ hitu ena. Mete ma neu mateteꞌen, Lamatuaꞌ nafefela baliꞌ atahori mana mateꞌ ra na, inaꞌ ia dadꞌi touꞌ bee ka saon?” ");
INSERT INTO row_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Basa ma, Yesus nataa nae, “Mete ma hei mitane taꞌo naa, na, hei sala naeꞌ ena ma! Huu hei nda mihine Lamatualain Susuran liin sa. Ma nda mihine koasa manaselin sa! ");
INSERT INTO row_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Matetun, taꞌo ia. Neꞌo, mete ma Lamatualain nafefela baliꞌ atahori mana mateꞌ ra, ara esa nda sao esa sa ena, onaꞌ ate nara mana sia sorga ra. ");
INSERT INTO row_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Boe ma Au ae olaꞌ soꞌal atahori mana mateꞌ ra rasodꞌa baliꞌ, do hokoꞌ. Sia baꞌi Musa susuran ra nenedꞌuiꞌ oi hau huu anaꞌ nene tunu-hotuꞌ te nda kadꞌe hendi e sa. Mia dudꞌuit naa, hita tahine tae, atahori mana mateꞌ ra bisa rasodꞌa baliꞌ boe. Huu Lamatualain nafadꞌe baꞌi Musa mia naa nae, ");
INSERT INTO row_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Au ia, bei-baꞌi mara Lamatualain na. Naeni baꞌi Abraham, baꞌi Isak, ma baꞌi Yakob. Basa se beꞌutee neu Au rakandoo losa ia nema.’ Naa! Hita tahine tae, leleꞌ Lamatuaꞌ olaꞌ naꞌo naa, te basa baꞌiꞌ naa ra mate se dooꞌ ena. Huu Lamatualain nae Eni feꞌe dadꞌi nakandoo sira Lamatuan. Naeni de ata tahine tae, ao samana nara rasodꞌa rakandoo, mae ara mate dooꞌ ena. De mae atahori mate o, ana nasodꞌa baliꞌ. Huu akaꞌ atahori masodꞌaꞌ beꞌutee neu Lamatualain, nda atahori mates ra sa to?!” ");
INSERT INTO row_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Rena Yesus nanori naꞌo naa, ma atahori Saduki ra nda ritaꞌ rae bale saa sa ena boe. Te atahori hetar naa ra titindindii de olaꞌ rae, “Awii! Atahori ia nenorin manaseliꞌ tebꞌe, o!” ");
INSERT INTO row_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Leleꞌ atahori Farisi ra rena rae, Yesus nasenggiꞌ atahori Saduki ra, ma ara raꞌabꞌue reu esa de rae ratane rasafafali E. ");
INSERT INTO row_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Sira mana mahine agaman esa nae teꞌe-sii sobꞌa Yesus nae, ");
INSERT INTO row_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ama Meser! Au ae utane taꞌo ia: hita adat na hohoro-lalanen, no agama parendan ra, hetar. Mia basa parendaꞌ fo mana mia baꞌi Musa naa, bee ka manaseliꞌ lenaꞌ?” ");
INSERT INTO row_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Boe ma Ana nataa nae, “Parendaꞌ fo manaseliꞌ sia Lamatualain Susura Meumaren nae, taꞌo ia: ‘Lamatualain naa, hei Lamatuam. De ama musi sue lenaꞌ e mia basaꞌ e. Huu naa, hei musi hii E mikindooꞌ a, ma mihine E, ma manggate tao ues tungga Hihii-nanaun.’ ");
INSERT INTO row_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Parendaꞌ naa, pantin ma manaseliꞌ! ");
INSERT INTO row_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Boe ma parendaꞌ ka ruan, naꞌo ia: Musi sue atahori laen ra, onaꞌ ho sue aom boe.’ ");
INSERT INTO row_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Parendaꞌ rua ra ia ra, naeni huuꞌ mia basa baꞌi Musa hohoro-lalanen no Lamatualain mana dui-bꞌengga nara nenorin. Neꞌo atahori nda tungga parendaꞌ laen ra sa, mete ma ana nda feꞌe tungga naꞌahuluꞌ parendaꞌ karuaꞌ ia ra sa.” ");
INSERT INTO row_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Leleꞌ atahori Farisi ra feꞌe raꞌabꞌue sia naa, ma Yesus natane baliꞌ se nae, ");
INSERT INTO row_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Mia lele uluꞌ a Lamatualain helu haitua Kristus fo fee masoi-masodꞌaꞌ neu atahori nara. De tungga hei dudꞌuꞌa mara, Kristus naa, seka tititi-nonosin?” Boe ma ara rataa rae, “Eni, mane Daud tititi-nonosin.” ");
INSERT INTO row_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesus olaꞌ seluꞌ nae, “Mete ma taꞌo naa, naa, taꞌo bee de Lamatualain Dula-dale Meumaren nafadꞌe neu mane Daud fo noꞌe Kristus nae, ‘Lamatua’? Te Daud suraꞌ ena nae, ");
INSERT INTO row_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Lamatualain nafadꞌe au Lamatua ngga ena nae, “Uma fo endoꞌ sia bobꞌoa ona ngga, sia mamana nene fee hadꞌa-hormat ia. Huu dei fo Au tao musu mara, losa ara raloe ao nara neu nggo.’” ");
INSERT INTO row_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Naa! Mia susura naa, hita tahine tae, mane Daud o noꞌe Kristus nae, ‘Lamatuaꞌ’. Dadꞌi mete ma atahori rae Kristus naa, akaꞌ mane Daud tititi-nonosin, naa feꞌe nda dai sa! Huu Eni o Mane Daud Lamatuan boe!” ");
INSERT INTO row_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Rena Yesus ola naꞌo naa ma, atahori Farisi ra hie-hie reuꞌ ena, nda hambu atahori esa saa sa boe bisa nataa nasafali Yesus sa ena. Naa de eniꞌ a mia faiꞌ naa ma, ara ramatau ratane ena, ma nda rambarani sobꞌa teꞌe-sii E sa ena. ");
INSERT INTO row_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Basa ma Yesus nanori ana mana tungga nara, ro atahori hetar mana tungga se. ");
INSERT INTO row_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ana nafadꞌe nae, “Meser agama ra ro atahori Farisi ra toꞌu hak fo ranori baꞌi Musa hohoro-lalane nara. ");
INSERT INTO row_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Huu naa, hei musi rena se ma tungga nenori nara. Te afiꞌ tungga saa fo ara taoꞌ ra, huu ara nda tao tungga sira nenori nara sa. ");
INSERT INTO row_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ara raꞌasusuuꞌ atahori fo lemba-doi agama hohoro-lalane mambera nara. Te sira mesaꞌ se nda nau tulu-fali atahori fo tao tungga hohoro-lalaneꞌ naa sa. ");
INSERT INTO row_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Basa saa fo ara taoꞌ a, ara tao fo atahori koa-boꞌu se. Onaꞌ a: saa esa isi na Lamatualain Hara-liin fo atahori rea sia langga nara, ma feo sia lima nara. Te ara bau tao raꞌamoko sira enan. Ma ara o tao rananaru lenaꞌ taliꞌ mana sia badꞌu naru nara suun, fo mana fee nesenenedꞌaꞌ neu se soꞌal Lamatuaꞌ Hara-liin. Ara tao taꞌo naa, fo atahori koa-boꞌu se rae, ‘We! Naa ra dei, atahori meumareꞌ re, o!’ ");
INSERT INTO row_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Mete ma ara ume hule-oꞌeꞌ rala reu, do tungga fefetas, ara sanggaꞌ a mamana eꞌendo meulauꞌ, fo atahori hetar rita se. ");
INSERT INTO row_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Mete ma ara reu sia pasar, na, ara o hiiꞌ a simbo hada-hormat. Ara hiiꞌ a fo atahori beꞌutee mbali se oi, “Ama meser nenefee hadꞌa-hormat.’ ");
INSERT INTO row_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Te ama afiꞌ tungga naa ra dalan! Atahori afiꞌ roꞌe nggi rae, ‘ama meser’, huu hei meser ma akaꞌ esaꞌ a. Boe ma basa hei ia ra, bobꞌonggiꞌ sa. ");
INSERT INTO row_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Afiꞌ minanaru atahori sia raefafoꞌ ia mae, ‘amaꞌ’, te hei Amam sia sorga akaꞌ esaꞌ a. ");
INSERT INTO row_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Atahori ra o afiꞌ roꞌe nggi na rae, ‘lamatuaꞌ’, te huu hei Lamatuam akaꞌ esaꞌ a, naeni Au ia, fo Lamatualain helu-fuli nae haitua nema eniꞌ a mia lele uluꞌ a ena. ");
INSERT INTO row_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Naa de Au ufadꞌe nggi fo afiꞌ minanaru ao mara onaꞌ atahori mana hiiꞌ a sangga hadꞌa-hormat. Hei seka mae dadꞌi atahori moko-monaen, ana musi dadꞌi onaꞌ ate fo mete-seꞌu atahori laen ra. ");
INSERT INTO row_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Te atahori mana soꞌu nanaru aon, neꞌo Lamatuaꞌ naꞌatutudꞌaꞌ E. Te atahori mana tao aon onaꞌ ana dikiꞌ e, dei fo Lamatuaꞌ soꞌu nanaru e.” ");
INSERT INTO row_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Basa ma, Yesus olaꞌ seluꞌ nae, “Hee, hei meser agama ma atahori Farisi re! Memaꞌ hei, atahori mana dea-ralaꞌ! Dei fo ama hambu sosoeꞌ, huu hei nda nau masoꞌ misiꞌ Lamatuaꞌ parendan fo mimihere Au sa, naeni Atahori fo Lamatualain helu-fuli nae haitua nemaꞌ a. Deꞌulakan lenaꞌ fai, hei mii miꞌingge mala atahori mana nau masoꞌ nisiꞌ Lamatuaꞌ parendan fo ara nda ramahere neu Au sa. ");
INSERT INTO row_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Hee, hei meser agama ma atahori Farisi ra! Mema hei, atahori mana dea-ralaꞌ! Dei fo ama hambu sosoeꞌ, huu hei akaꞌ peko-lelekoꞌ ina-falu ra, ma besla mala ume nara. Te sia atahori hetar matan, hei miꞌifuniꞌ deꞌulaka mara, ma mimbiriiꞌ hule-oꞌe dooꞌ fo atahori rae hei rala mara meumareꞌ. Te dei fo Lamatualain hukun nggi beran seli. ");
INSERT INTO row_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Hee, meser agama ma atahori Farisi re! Memaꞌ hei, atahori mana dea-ralaꞌ! Dei fo ama hambu sosoeꞌ huu hei sae ofaꞌ sudꞌi a bee mi, ma onda-hene leteꞌ o, mae sangga akaꞌ atahori esaꞌ a, fo ana tungga hei partei agama ma. Te mete ma ana tungga ena, na, hei tao masodꞌan dadꞌi deꞌulakan lenaꞌ fai, losa ana hambu hukun sia naraka beran lenaꞌ lao rua mia hei e. ");
INSERT INTO row_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Weh, Hei rala mara pokeꞌ re ena, te taꞌo bee de hei feꞌe mae mitudꞌu dalaꞌ fee neu atahori laen fai? Neꞌo ama hambu sosoeꞌ huu ama minori leli mae, ‘Mete ma atahori rae soꞌu hehelu-fufuliꞌ rendiꞌ susumbaꞌ ma ingga Ume Hule-oꞌe Huuꞌ a, na, atahori naa nda nenepaꞌaꞌ no hehelu-fufuliꞌ naa sa. Te mete ma ana soꞌu hehelu-fufuliꞌ nendi susumba ma ingga lilo mbilas mana sia Ume Hule-oꞌeꞌ a, na, eni feꞌe nenepaꞌaꞌ no hehelu-fufuliꞌ naa ena.’ ");
INSERT INTO row_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Hei ria ra atahori nggoa mateꞌe re! Neꞌo hei mae Lamatuaꞌ nae lilo mbilas pantin lenaꞌ, Eni Ume Hule-oꞌe Huuꞌ na do? Hokoꞌ! Te ume naa, mana tao lilo mbilas naa ra dadꞌi meumareꞌ! ");
INSERT INTO row_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Hei o minori leli mae, ‘Mete ma atahori soꞌu hehelu-fufuliꞌ no susumbaꞌ ingga nendiꞌ mei tutunu-hohotuꞌ mana sia Ume Hule-oꞌe Huuꞌ a, na, atahori nda nenepaꞌaꞌ no hehelu-fufulin naa sa. Te mete ma ana soꞌu hehelu-fufuliꞌ no susumbaꞌ ingga nendi tutunu-hohotuꞌ mana sia mei ata, na, eni feꞌe na nenepaꞌa no hehelu-fufulin naa ena.’ ");
INSERT INTO row_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Hei ia ra, tebꞌe-tebꞌeꞌ pokeꞌ re ena. Memaꞌ mei tutunu-hohotuꞌ naa, pantin lenaꞌ tutunu-hohotuꞌ mana sia mei ata. Huu mei naa, mana tao tutunu-hohotu nara dadꞌi meumareꞌ soaꞌ neu Lamatualain. ");
INSERT INTO row_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Huu naa, mete ma atahori sumba ma ingga mei tutunu-hohotuꞌ, na, malole lenaꞌ ingga mei a no basa saa mana sia mei ata boe. ");
INSERT INTO row_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ma mete ma atahori sumba no ingga Ume Hule-oꞌe Huuꞌ a, na, malole lenaꞌ ingga lao esaꞌ Ume Hule-oꞌeꞌ a no Lamatualain naran boe. Huu Ana leo sia naa. ");
INSERT INTO row_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ma mete ma atahori sumba ma ingga sorga, na, naa o, onaꞌ ana ingga lao esaꞌ Lamatualain kadꞌera parendan no naran ena, huu Ana mana endoꞌ toꞌu parendaꞌ sia naa. ");
INSERT INTO row_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Hee, hei meser agama ma atahori Farisi re! Memaꞌ hei, atahori mana dea-ralaꞌ ra! Dei fo ama hambu sosoeꞌ, huu hei mihine bareken fo fee neu Lamatuaꞌ babꞌanggiꞌ esa mia babꞌanggi ka sanahuluꞌ ra. Hei akaꞌ bareken basa-bꞌasaꞌ e, losa bumbu-dai mana mia osi o, hei reken mates boe. Onaꞌ a hei reken lutuꞌ-leloꞌ, dare, adas maꞌameniꞌ, ma jintan dekeꞌ. Tao-tao te ama liliiꞌ hendi Lamatualain hohoro-lalanen pantin manaseliꞌ nara! Hei misodꞌa nda no ndoo-tetuꞌ sa. Hei nda sue atahori mana tudꞌa-loloeꞌ ra sa. Hei nda misodꞌa mikindoo tungga Lamatuaꞌ hihii-nanaun sa. Malole lenaꞌ, ama tao tungga basa naa ra dei, dei fo ama mii bareken bumbu-dai, fo mae fee neu Lamatuaꞌ. ");
INSERT INTO row_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Hei rala mara pokeꞌ re ena, te taꞌo bee fo mae mii mitudꞌu dalaꞌ neu atahori fai? Hei tao hohoro-lalaneꞌ losa lutuꞌ-leloꞌ fo denu atahori laen ra tungga, te Lamatuaꞌ hohoro-lalanen pantin manaseliꞌ nara, hei nda tungga sa. Onaꞌ hei paresaꞌ lutuꞌ-leloꞌ fo sula hendi mbene mumuuꞌ mia hei oe nininum. Te banda monaeꞌ onaꞌ amba, na hei odꞌo hendi e teme-teme! ");
INSERT INTO row_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Hee, hei meser agama ma atahori Farisi re! Memaꞌ hei, atahori mana dea-ralaꞌ! Dei fo ama hambu sosoeꞌ, huu hei safe mala pinggaꞌ-manggo ra losa rakahahadꞌoꞌ, te naa akaꞌ siaꞌ a deaꞌ. Tao-tao te sia ralaꞌ manggenggeoꞌ a mamafafauꞌ no nggeoꞌ lao mia nanaꞌo mara ma bare-naꞌo mara. ");
INSERT INTO row_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Weh! Atahori Farisi poke-lakaꞌ re! Safe miꞌihuluꞌ pinggaꞌ-manggo mara rala nara dei! No taꞌo naa, dea nara o dadꞌi meuꞌ boe! ");
INSERT INTO row_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Hee, hei meser agama no atahori Farisi re! Memaꞌ hei, atahori mana dea-ralaꞌ! Dei fo hei hambu sosoeꞌ, huu hei ia onaꞌ rates mana dama mutiꞌ. Atahori mete rita dean meulaun seli. Te ralan na, sofeꞌ no atahori mates ra rui nara, ma basa mana maꞌafo mburuꞌ ra. ");
INSERT INTO row_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Hei o onaꞌ naa boe! Hei hiiꞌ a tao ao mara onaꞌ atahori meumareꞌ re. Atahori ra mete nggi taꞌi deaꞌ na, hei onaꞌ atahori rala ndoos. Tao-tao te rala mara, sofeꞌ no dala deꞌulakaꞌ. Huu hei olaꞌ laen, te tao laen, ma liliiꞌ hendi Lamatualain parenda nara. ");
INSERT INTO row_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Hee, hei meser agama ma atahori Farisi re! Memaꞌ hei, atahori mana dea-ralaꞌ! Dei fo ama hambu sosoeꞌ! Ama tao rates monae-monaeꞌ fee Lamatualain mana dui-bꞌengga nara, ma paroon malole-maloleꞌ atahori maloleꞌ ra rates nara. ");
INSERT INTO row_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Te hei mae, ‘Onaꞌ hita tasodꞌa leleꞌ esa to bei-baꞌi tara, neꞌo ata nda tungga tao tisa Lamatualain mana dui-bꞌengga nara sa.’ ");
INSERT INTO row_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","No naa, hei mikimbembela tatao-nonoꞌi mara mae, hei o, deꞌulakaꞌ onaꞌ bei-baꞌi mara boe. ");
INSERT INTO row_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Dadꞌi malole lenaꞌ, hei tao deꞌulakaꞌ onaꞌ naa losa babꞌasan, tungga bei-baꞌi mara sala-kilu nara! ");
INSERT INTO row_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Hei ia ra tebꞌe-tebꞌeꞌ deꞌulaka mara onaꞌ mengge marasoꞌ. Seꞌu te hei mae Lamatualain nda hukun nggi sa? Afiꞌ mimihena! Neꞌo Ana nggari nggi misiꞌ ai naraka rala mii! ");
INSERT INTO row_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Rena, e! Dei fo Au haitua fee nggi mana dui-bꞌengga nggara, fo ara ranori ma ratudꞌu nggi Lamatuaꞌ dala masodꞌa ndoo-tetun. Te neꞌo ama tao misa ruma, ma mbaku misa ruma sia hau ngganggeꞌ. Hei o liꞌu ruma sia ume hule-oꞌeꞌ, ma hei poko-paru ruma losa ara rela mia kota esa risiꞌ kota laen. ");
INSERT INTO row_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Feꞌe fai dalahulun hei bei-baꞌi mara tao risa Habel. Tao-tao te eni, atahori rala ndoos. Hei beꞌi-baꞌi mara tao risa atahori rala ndoos ra, rakandooꞌ a mia tititi-nonosiꞌ esa losa tititi-nonosiꞌ laen. Losa nala Sakaria, naeni Barakia anan. Ara tao risa e mia Ume Hule-oꞌe Huuꞌ a sodꞌan deka no mei tutunu-hohotuꞌ a. Huu hei tungga bꞌei-baꞌi mara deꞌulaka nara naa, naa de hei musi lemba-doi basa atahori rala ndoos ra raa nara. ");
INSERT INTO row_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Memaꞌ tebꞌe! Te hei fo feꞌe sia leleꞌ ia, dei fo nenehukun, huu dala-dala deꞌulakaꞌ ra fo hei bei-baꞌi mara tao mia lele uluꞌ a.” ");
INSERT INTO row_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Hei atahori Yerusalem re! Hei mana akaꞌ tao misa Lamatualain mana dui-bꞌengga nara, ma mbia misa dedꞌenu nara fo mana rema tulu-fali heiꞌ ra. Au akaꞌ kokoe usufafali nggi fo ima misiꞌ Au, onaꞌ manu ine a nae nasarorombo nala ana nara sia lidꞌan rala. Te hei nda nau sa. ");
INSERT INTO row_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Huu naa, Lamatuaꞌ nda tao afiꞌ neu ume mara sa ena. Ma mbila do fini esaꞌ te rouꞌ ena. ");
INSERT INTO row_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Rena malolole, e! Huu hei nda afiꞌ mita Au sa ena, losa leleꞌ hei mitaa mae, ‘Hita toꞌe fo Lamatualain fee papala-babꞌanggiꞌ fee neu Atahori ia, huu Lamatuaꞌ mana denu E.’ Hei mitaa onaꞌ naa, dei fo hei feꞌe na mete-mita Au fai.” ");
INSERT INTO row_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Basa naa ma, Yesus nae lao hela Ume Hule-oꞌe Huuꞌ a. Leleꞌ Ana lao dea neu, ma ana mana tungga nara reu ratudꞌu Ume Hule-oꞌe Huuꞌ naa meulaun. ");
INSERT INTO row_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Te Ana nataa nae, “Ume ia memaꞌ meulauꞌ! Te rena, e! Nda dooꞌ sa te, ara ndefaꞌ hendi basa fatu ia ra.” ");
INSERT INTO row_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Basa ma, Yesus lao neu endoꞌ sia lete Saitun. Boe ma ana mana tungga nara rema fo rae ola-olaꞌ mesaꞌ se ro E rae, “Amaꞌ! Sobꞌa mufadꞌe seluꞌ Amaꞌ oꞌolan faꞌ ra dei. Amaꞌ neneman naa dadꞌi fai hiraꞌ, e? Boe ma tatandan saa e? Boe ma raefafoꞌ a neteteꞌen taꞌo bee?” ");
INSERT INTO row_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Basa ma Yesus nataa nae, “Minea aom matalolole, o! Fo ama afiꞌ nene pepeko-lelekoꞌ. ");
INSERT INTO row_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Te dei fo atahori mataꞌ-mataꞌ rema toꞌo tendan nae, ‘Au ia, Kristus, Atahori fo Lamatualain helu-fuli mia lele uluꞌ a.’ No taꞌo naa, ara peko-lelekoꞌ atahori hetar. ");
INSERT INTO row_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mete ma hei mita atahori ratati, do ama rena haraꞌ rae, netatis sia bee-bꞌee, na, ama afiꞌ mimitau. Te dalaꞌ mataꞌ naa, musi dadꞌi. Te fai neteteꞌen nda feꞌe losa sa. ");
INSERT INTO row_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Dei fo leo esa natati labꞌan leo laen. Nusa monaeꞌ esa natati labꞌan nusaꞌ laen. Rae nanggenggo sia bee-bꞌee. Boe ma fula-fai ndoes, manaseliꞌ boe! ");
INSERT INTO row_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Te basa naa ra, feꞌe tatandaꞌ fefeun mana nafadꞌe oi, fai mateteꞌen deka-deka ena. Naa onaꞌ ina mairuꞌ nae bonggi, de ana medꞌa nambetan, huu fula-fai bobꞌonggin deka-deka ena. ");
INSERT INTO row_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Dadꞌi hei musi minea aom maꞌabꞌebꞌesa, e! Te dei fo ara tao nggi doidꞌoso ma tao risa nggi. Dei fo atahori mia basa nusaꞌ ra ramanasa nggi seli, huu hei tungga Au. ");
INSERT INTO row_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Leleꞌ naa, atahori hetar rasadꞌea ma nda nau ramahere neu Au sa ena. Esa namanasa esa, ma esa seo esa. ");
INSERT INTO row_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Dei fo hambu mana peko-lelekoꞌ ra rae sira, Lamatuaꞌ mana ola-olan. Ma atahori hetar ramahere se. ");
INSERT INTO row_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Dei fo bau namadꞌoo na atahori deulaka nara bau ramanae, losa esa nda sue-lai esa sa ena. ");
INSERT INTO row_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Te atahori mana maꞌatataaꞌ losa mate, Dei fo Lamatualain fee ne masodꞌaꞌ. ");
INSERT INTO row_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Huu atahori musi dui-bꞌengga Lamatualain Hara-lii Malolen, losa ndule raefafoꞌ ia, naa fo basa atahori rahine Lamatuaꞌ dala ndoo-tetun. Basa naa fo fai mateteꞌen feꞌe losa ena na.” ");
INSERT INTO row_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Yesus olaꞌ nakandoo nae, “Lamatualain mana ola-olan Daniel suraꞌ soꞌal atahori esa deꞌulakan manaseliꞌ. Dei fo ana nema neu nambariiꞌ sia mamana meumare manaseliꞌ sia Lamatualain Ume Hule-oꞌe Huuꞌ na. No taꞌo naa ana tao nanggenggeo mamanaꞌ naa. Naa de Lamatua lao nasadꞌea hela mamanaꞌ naa. Naa! Mete ma hei mita onaꞌ naa ena, besa-bꞌesa, o! (Seka baca susura ia, musi nahine malolole!) ");
INSERT INTO row_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Te naa dadꞌi tanda oi, fai-fai susa-sonaꞌ sia lelesu mataꞌ ena. Mete ma mita onaꞌ naa, na, atahori sia profinsi Yudea fela fo mela leteꞌ ata mii leo. ");
INSERT INTO row_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Mete ma hambu ruma lao hela ume ena, afiꞌ sudꞌi baliꞌ mii haꞌi sudꞌiꞌ a saa ra fai. Melaꞌ lai-lai leo, fo afi hambu sosoeꞌ. ");
INSERT INTO row_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Atahori mana sia osi rala, afiꞌ sudꞌi baliꞌ fo haꞌi teme nelusaꞌ fai. Mela mikindoo leo! ");
INSERT INTO row_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kasian seli neu ina mairuꞌ ra, ro ina mana rasusu ana mana bonggi feuꞌ ra. Te ara nda relaꞌ haelai rala sa. ");
INSERT INTO row_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","De malole lenaꞌ hei hule-oꞌe fo moꞌe sosoeꞌ naa afiꞌ dadꞌi sia fai udꞌan, do sia fai hahae tao ues. ");
INSERT INTO row_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Huu faiꞌ naa susa-sonan seli! Eniꞌ a mia Lamatualain naꞌadadꞌiꞌ raefafoꞌ ia losa nala faiꞌ ia, atahori nda feꞌe rita sususaꞌ manaseliꞌ mataꞌ naa sa. Boe ma atahori o nda rita seluꞌ sususaꞌ mataꞌ naa sa ena. ");
INSERT INTO row_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Te hei onton monaeꞌ, huu Lamatualin naꞌaꞌeꞌeku faiꞌ naa. Mete ma hokoꞌ, na, nda hambu atahori esa saa sa boe naꞌatataaꞌ nasodꞌa. Huu, Lamatualain sue atahori fo Ana pili nalaꞌ ra, naa de Ana naꞌaꞌeꞌeku fai-fai susa-sonaꞌ ra. ");
INSERT INTO row_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Dei fo mete ma faiꞌ naa losa, hei rena atahori rae, ‘Mete dei! Kristus sia ia!’ Boe ma atahori laen fai rae, ‘Kristus sia naa!’ Te ama afiꞌ mimihere, e! ");
INSERT INTO row_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Te dei fo atahori rema fo toꞌo tendan nae, ‘Au ia, Kristus!’ Ma laen ra fai rae, ‘Au ia, Lamatualain mana ola-olan.’ Dei fo ara tao manadadꞌiꞌ mataꞌ-mataꞌ rendiꞌ nitu a koasan fo peko-lelekoꞌ atahori. Ara sobꞌa-sobꞌa fo Lamatualain atahori nara nenepeko-lelekoꞌ! ");
INSERT INTO row_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","De ama musi minea ao mara malolole, e! Fai susa-sonaꞌ naaꞌ ra nda feꞌe losa sa, te Au fee nesenenedꞌaꞌ neu nggi ena, o! ");
INSERT INTO row_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Mete ma atahori rafadꞌe nggi rae, ‘Kristus sia rae moo loaꞌ naa!’ Na, ama afiꞌ naa mii. Ma, mete ma hambu fai rae, ‘Kristus sia ume ia rala!’, na, ama afiꞌ mimihere neu pepeko-leleko nara. ");
INSERT INTO row_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Huu Au ia, Atahori Matetuꞌ a. Dei fo mete ma Au baliꞌ raefafoꞌ uma, basa atahori mete rita Au, onaꞌ atahori rita ndelas makahahadꞌoꞌ mana naronda mia seriꞌ rulu nisiꞌ seriꞌ muri. ");
INSERT INTO row_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Mete ma Au baliꞌ uma, dei fo hei bubꞌuluꞌ Au sia bee. Onaꞌ atahori rahine, rae mete ma mbui kaaꞌ mana naa mburuꞌ a heo sia mamanaꞌ bee, na, sia naa hambu mana mburuꞌ a boe.” ");
INSERT INTO row_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Basa ma Yesus olaꞌ fai, de nafadꞌe ana mana tungga nara nae, “Mete ma fai susa-sonaꞌ naa ra basa ena, ‘Dei fo relo dadꞌi hatuꞌ, fulan o nda naronda sa boe. Nduuꞌ ra tudꞌa mia lalai, ma basa koasa mana sia lalai ra ranggenggo.’ ");
INSERT INTO row_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Basa naa ma, basa atahori ra o rita tanda sia lalai ata oi, Atahori Matetuꞌ a nae baliꞌ nema ena. Rita onaꞌ naa, ma basa atahori sia raefafoꞌ ia ramatau losa ara nggae. Te dei fo Au onda uma o leleeꞌ, fo ara feꞌe rita basa Au koasa ngga ma manaseli ngga. ");
INSERT INTO row_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Boe ma Au pake maꞌoa mana nalii nahereꞌ fo parenda Lamatualain aten mana sia sorga reu raꞌabꞌue basa atahori fo Au tengga ala mia ndule raefafoꞌ ia, mia relo a mamana todꞌan losa relo a mamana mopon; mia dii losa ona.” ");
INSERT INTO row_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Au haꞌi conto onaꞌ hau huuꞌ. Mete ma roon huni ena, naa natudꞌu oi, fai matobꞌiꞌ deka-deka losa ena. ");
INSERT INTO row_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Onaꞌ naa boe, mete ma hei mita fai susa-sonaꞌ nema, onaꞌ Au ufadꞌe faꞌ ra naa, naa natudꞌu oi, Au deka-dekaꞌ uma ena. ");
INSERT INTO row_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","De ia na, rena malolole! Mia basa atahori masodꞌaꞌ leleꞌ ia, dei fo ruma nda feꞌe mate sa, te fai sususaꞌ naa ra losa ena. ");
INSERT INTO row_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Onaꞌ mae lalai no raefafoꞌ ia sambu-lalo, te Au Hara-Lii ngga ia naꞌatataaꞌ losa babꞌasan. ");
INSERT INTO row_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Nda hambu atahori rahine rae fai hiraꞌ na Au uma sa boe. Lamatualain aten mana sia sorga ra o, nda rahine sa boe. Au o, nda uhine sa boe. Akaꞌ Au Ama ngga nahine. ");
INSERT INTO row_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Te Au ia, Atahori Matetuꞌ a. Dei fo mete ma Au baliꞌ uma, naa onaꞌ lele uluꞌ a leleꞌ Noh feꞌe masodꞌaꞌ. ");
INSERT INTO row_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Oe mandali monaeꞌ a nda feꞌe nema sa, te atahori raa-rinu maladꞌa-maladꞌaꞌ ma sao rame-rame ona biasan. Ara tao taꞌo naa rakandooꞌ a, losa Noh hene ofai monaeꞌ rala neu. ");
INSERT INTO row_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Te leleꞌ oe mandali monaeꞌ a nema nandali nendi se, dei de ara feꞌe na nggengger, ma feꞌe rahine saa manadadꞌiꞌ naa. Onaꞌ naa boe no Au uꞌuma ngga. ");
INSERT INTO row_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Leleꞌ naa, mete ma atahori rua tao ues sia osi rala, aibꞌoiꞌ te, Lamatualain soꞌu nendi esa, ma Ana lao hela esa. ");
INSERT INTO row_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Mete ma inaꞌ rua mbau are, aibꞌoiꞌ te, Lamatualain soꞌu nendi esa, ma Ana lao hela esa. ");
INSERT INTO row_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Huu naa, hei o musi minea hatuꞌ-rerelon, te ama nda bubꞌuluꞌ fai hiraꞌ na hei Lamatuam nema sa. ");
INSERT INTO row_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Dudꞌuꞌa malolole, e! Mete ma tenu umeꞌ a bubꞌuluꞌ nae temba na naꞌo ra rema, na tantu ana nanea nakandooꞌ a, fo naꞌo ra afiꞌ umen rala reu. ");
INSERT INTO row_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Dadꞌi hei o musi mihehere. Huu aibꞌoiꞌ te Au uma ena!” ");
INSERT INTO row_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Basa ma Yesus olaꞌ seluꞌ fai nae, “Hei musi dadꞌi onaꞌ atahori dedꞌenuꞌ ra fo tungga mikindooꞌ a malangga hihii-nanaun. Te mete ma malangga nae lao neu sia mamana dodꞌooꞌ na, ana soꞌu atahori dedꞌenuꞌ mataꞌ naa ra, fo mete-seꞌu ume isi nara nanaa-nininu nara. ");
INSERT INTO row_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Mete ma malangga baliꞌ ma nita atahori dedꞌenu nara tao ue-tataos nara no maloleꞌ, tantu ana namahoꞌo no atahori naa. ");
INSERT INTO row_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Mimihere neu Au, te dei fo malangga fee koasa neu dedꞌenu nara fo mete-seꞌu basa hata-heto nara. ");
INSERT INTO row_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Te mete ma atahori dedꞌenuꞌ ra deꞌulakaꞌ, na tantu ana olaꞌ sia ralan nae, ");
INSERT INTO row_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","‘Malole! Malangga lao onaꞌ ia na, seka bubꞌuluꞌ fai hiraꞌ fo ana baliꞌ, o!’ Duꞌa taꞌo naa ma, ana poko-paru nonoon mana tao ues laen ra. Boe ma ana endoꞌ naa-ninu maladꞌa-maladꞌaꞌ naꞌabꞌue no mana mafuꞌ ra. ");
INSERT INTO row_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ma nda bubꞌuluꞌ sa te, aibꞌoiꞌ ma malangga naa baliꞌ boe. ");
INSERT INTO row_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Boe ma malangga naa tao doidꞌoso e nda fefeet sa, basa de piru hendi e dea neu, fo leo naꞌabꞌue no atahori mana dea-ralaꞌ ra. Sia mamanaꞌ naa, basa se nggae eiei huu ara doidꞌosoꞌ rita mamate nara.” ");
INSERT INTO row_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Basa ma, Yesus tute oꞌolan soꞌal Lamatualain parendan, nae “Hei musi mihehere fo soru Au uꞌuma ngga, onaꞌ nekendandaa ia. Taꞌo ia: lao esa, hambu ana fetoꞌ atahori sanahulu laoꞌ tetembaꞌ ma rendi sira lambu ana nara, fo reu soru pangantin touꞌ a sia nonoon umen. ");
INSERT INTO row_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Te mia ina ka sanahuluꞌ naa ra, hambu lima nggoaꞌ, ma lima mahineꞌ. ");
INSERT INTO row_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nggoaꞌ kalimaꞌ ra, liliiꞌ rendi mina lenaꞌ. ");
INSERT INTO row_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Te mahineꞌ kalimaꞌ ra rendi memaꞌ ena. ");
INSERT INTO row_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Losa ume naa te, pangantin touꞌ a nda feꞌe nema sa. Dodꞌoo ma ana fetoꞌ naa ra nduar, de ara sungguꞌ rasambetaꞌ. ");
INSERT INTO row_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tao-tao te neofaa banggi rua ma, ara rena atahori rameli rae, ‘Woi! Pangantin touꞌ a losa ena! Ima fo ata teu soru e leo!’ ");
INSERT INTO row_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Rena taꞌo naa, ma ana fetoꞌ ra fela randaa. De reu raote lambu anaꞌ ra. ");
INSERT INTO row_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ma ana feto nggoaꞌ ra olaꞌ ro nonoo nara rae, ‘We, toronooꞌ re! tulun banggi fee hai mina mbei dei, te hai lambu mara raeꞌ a mate ena!’ ");
INSERT INTO row_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Te ana feto mahineꞌ ra rataa rae, ‘Aweꞌ! Afiꞌ miminasa, te nda bisa sa, o. Huu hai mina ma ia nda dai basa hita sa! Malole lenaꞌ mii hasa sia kios.’ ");
INSERT INTO row_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Boe ma ara lao reu hasa mina. Te leleꞌ ara dea reu ma, pangantin a losa boe. De ana feto mahineꞌ ra tungga rala reu risiꞌ mamana kakabꞌiꞌ a, raꞌabꞌue ro pangantin ra ma basa fuiꞌ ra. Basa se rala ume rala ma, atahori ena lelesu a. ");
INSERT INTO row_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Basa ma, ana feto nggoaꞌ ra o rema boe. Ara rameli de kokoe rae, ‘Papa! Papa, e! Tulun soi lelesu a dei!’ ");
INSERT INTO row_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Te pangantin a nataa nae, ‘Weh, nda bisa sa, o. Te au nda uhine nggi sa!’ ");
INSERT INTO row_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Huu naa, hei musi mihehere fo minea mikindooꞌa, huu hei nda bubꞌuluꞌ Au uꞌuma ngga leleꞌ bee sa boe, do liiꞌ hira sa boe.” ");
INSERT INTO row_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Basa ma Yesus tute seluꞌ nekendandaaꞌ esa fai nae, “Mete ma Au lao hela nggi ena, na, ama musi tao ues maloleꞌ fee Au, onaꞌ nekendandaaꞌ ia. Taꞌo ia: Malangga esa nae lao mamanaꞌ dodꞌooꞌ neu. Leleꞌ ana naote nala nae lao, ana noꞌe nala dedꞌenuꞌ nara, basa ma ana parenda se nae, ‘Ama pake doiꞌ ia ra dadꞌi pokoꞌ. Dei fo mete ma au baliꞌ, ama musi mifadꞌe au, hei hambu bunaꞌ baꞌu sa.’ ");
INSERT INTO row_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Basa de ana fee dedꞌenu ka esan doi mbilas saku lima, fo ana naꞌabꞌubꞌunaꞌ doiꞌ naa. Boe ma, ana fee dedꞌenu ka ruan doiꞌ saku rua, ma dedꞌenu ka telun doiꞌ saku esa, tungga esa-esaꞌ bebꞌeꞌin. Basa ma ana lao dodꞌooꞌ neu. ");
INSERT INTO row_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Simbo rala doiꞌ ra, ma dedꞌenu ka esan lao de neu danggan. Nda doo sa ma, ana hambu doi bunaꞌ saku lima fai. ");
INSERT INTO row_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Onaꞌ naa boe, dedꞌenu ka ruan. Ana hambu doi bunaꞌ saku rua fai. ");
INSERT INTO row_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Te dedꞌenuꞌ ka telun mana simbo doiꞌ saku esa, ana neu ali ndolaꞌ sia rae a, de susuu malanggan doin naa. ");
INSERT INTO row_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Dodꞌoo ma, malangga a baliꞌ. De ana naꞌabꞌue dedꞌenu nara de paresaꞌ doin fo ara raꞌabꞌubꞌunaꞌ naa. ");
INSERT INTO row_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Atahori ka esan rala neu de fee doiꞌ saku sanahulu, de nae, ‘Malangga! Doi ma sia. Faiꞌ naa malangga fee au doiꞌ saku lima. Te ia na, au hambu bunaꞌ saku lima fai. ");
INSERT INTO row_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Rena nala ma, malangga namahoꞌo. Ana nafadꞌe nae, ‘Malole! Ho ia, dedꞌenu maloleꞌ. Mae au nese ia o, ho tao ues no manggateeꞌ ma tungga mukundooꞌ a au parenda ngga. Huu mete-seꞌu muhine dala ana dikiꞌ onaꞌ ia ena, de dei fo au soꞌu nggo fo mete-seꞌu dala monaeꞌ ra. Dei fo au tao fefetas fo basa nggita tamahoꞌo teu esa.’ ");
INSERT INTO row_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Basa ma, dedꞌenu ka ruan nema fai de fee doi saku ha neu malangga, ma nae, ‘Malangga! Dalahulun malangga fee au, doiꞌ saku rua. Mita neuꞌ ena, au hambu doi bunaꞌ saku rua fai.’ ");
INSERT INTO row_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Malangga o namahoꞌo boe. Ana nafadꞌe nae, ‘Malole! Ho ia, dedꞌenu maloleꞌ. Ho tao ues no manggateeꞌ, ma mae au nese ia o, tungga mukundooꞌ a au parenda ngga. Huu mete-seꞌu muhine dala ana dꞌikiꞌ onaꞌ ia, dei fo au soꞌu nggo fo mete seꞌu dalaꞌ monaeꞌ lenaꞌ fai. Dei fo au tao fefetas fo basa nggita tamahoꞌo teu esa.’ ");
INSERT INTO row_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Boe ma, dedꞌenu ka telun nema fai. Ma ana nafadꞌe nae, ‘Malangga, o! Au bubꞌuluꞌ malangga ia atahori rala manggateeꞌ. Huu malangga haꞌi saa fo atahori laen tao, ma etu mala saa fo atahori laen sela-nggari. ");
INSERT INTO row_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Au umutau, afiꞌ losa doiꞌ ia ra mopo hendi se, te doi ma saku ka esaꞌ ia feꞌe temeꞌ!’ ");
INSERT INTO row_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Rena nala ma, malangga bua kakasoꞌ e nae, ‘Ho ia dedꞌenu deꞌulakaꞌ ma mana mbera-mbikeꞌ! Mete ma bubꞌuluꞌ mae, au haꞌi ala saa fo atahori laen tao, ma etu ala saa fo atahori laen sela nggari, ");
INSERT INTO row_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","na taꞌo bee de nda muu mbedꞌaꞌ doi ngga sia bank sa? Fo hela au baliꞌ, na, au hambu baliꞌ bunan mbei, boe o neu!’ ");
INSERT INTO row_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Basa ma, malangga denu dedꞌenun laen ra nae, ‘Haꞌi mala doiꞌ naa ra sia e, fo fee neu dedꞌenuꞌ mana hambu doi bunaꞌ saku limaꞌ naa. ");
INSERT INTO row_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Te atahori mana tao mataꞌ maloleꞌ neu saa fo ana toꞌu ena, dei fo ana hambu naeꞌ lenaꞌ fai. Te atahori fo nda nau tao-mataꞌ neu saa fo ana toꞌu naa sa, dei fo ara haꞌi rala baliꞌ basa se mia e. ");
INSERT INTO row_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Toꞌu mala dedꞌenuꞌ nda mana naꞌena ngguna-bara saa-saa ia. Lea roroso fo nggari e dea neu. Hela e nggae eiei ma doidꞌoso sia mamana maꞌahatuꞌ naa!’” ");
INSERT INTO row_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Basa ma Yesus olaꞌ nakandoo nae, “Au, Atahori Matetuꞌ ia, dei fo onda baliꞌ uma endiꞌ Ama ngga koasa manaselin, uma o ate mana mia sorga Nara. Basa fo Au endoꞌ sia kadꞌera parenda mana seliꞌ ngga, fo paresaꞌ basa atahori masodꞌa nara. ");
INSERT INTO row_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Dei fo basa atahori mana rasodꞌa mia raefafoꞌ, rema randaa ro Au. Dei fo Au bingga-banggi se, ona manatadꞌa bingga-banggi bibꞌi lombo no bibꞌi hiek fo dadꞌi nononggoꞌ rua. ");
INSERT INTO row_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Atahori mana nasodꞌa tungga Lamatualain hihii-nanaun, Au tao e sia Au bobꞌoa ona ngga. Te laen ra, Au tao se sia bobꞌoa dii ngga. ");
INSERT INTO row_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Leleꞌ naa, Au toꞌu parendaꞌ onaꞌ maneꞌ. Dei fo Au ufadꞌe atahori mana sia bobꞌoa ona ngga ae, ‘Hei ia mana simbo papala-babꞌanggiꞌ mia Au Ama ngga. Ima misiꞌ ume mana nenesadꞌia memaꞌ fee neu nggi eniꞌ a mia fefeun. ");
INSERT INTO row_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Au urolo nggi, huu feꞌesaꞌan leleꞌ Au ndoe, hei mana fee Au ua. Leleꞌ Au uꞌumadꞌa, hei mana fee Au inu. Au uma onaꞌ atahori fuiꞌ, te hei mana simbo Au sia ume mara. ");
INSERT INTO row_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Au nda uꞌena bua-loꞌas sa, te hei mana fee Au bua-loꞌas. Au umuhedꞌi, te hei ima tao mataꞌ neu Au. Au sia bui rala, te hei ima seꞌu Au.’ ");
INSERT INTO row_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Rena onaꞌ naa, dei fo atahori rala ndoos sia Au bobꞌoa ona ngga naa, rataa baliꞌ, rae. ‘Papa, ia taꞌo bee ia ena? Papa nae, Papa ndoe, de hai mihao nggo. Papa naꞌamadꞌa, de hai o fee nggo minu. ");
INSERT INTO row_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Papa onaꞌ atahori fuiꞌ, de hai simbo nggo misiꞌ hai umem. Papa nda naꞌena bua-baꞌus saa, de hai fee. ");
INSERT INTO row_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Papa mumuhedꞌi, de hai tao mataꞌ neu nggo. Papa sia bui rala, de hai mii tulu fali nggo. Te eni bees hai tao dalaꞌ onaꞌ naa?’ ");
INSERT INTO row_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Dei fo Au utaa se ae, ‘Mimihere Au! Huu leleꞌ hei tao dalaꞌ onaꞌ naa neu Au atahori ngga ra, mae tao fee neu atahori mana tudꞌa-loloeꞌ ra o, na, hei tao fee neu Au ena!’ ");
INSERT INTO row_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Boe ma Au ufadꞌe neu atahori mana sia bobꞌoa dii ngga ae, ‘Hee, atahori deꞌulaka ra e! Lamatualain sumba-doon nggi. Dinggoꞌ hela ia! Dei fo Au denu atahori reu piru hendiꞌ nggi misiꞌ ai naraka mana mbila roo-rooꞌ nda mana mateꞌ sa. Huu Lamatualain sadꞌia memaꞌ mamana huku-dokin, fee neu nitu ra, ro malangga monaen. ");
INSERT INTO row_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Au mbuu hendi nggi, huu leleꞌ Au ndoe, hei nda fee Au ua sa. Leleꞌ Au uꞌumadꞌa, hei nda fee Au inu sa. ");
INSERT INTO row_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Au uma onaꞌ atahori fuiꞌ, te ama nda simbo au sia hei umem sa. Au nda uꞌena bua-baꞌus sa, te hei nda fee Au bua-baꞌus sa. Au umuhedꞌi, te ama nda ima taomataꞌ neu Au sa. Au sia bui rala, te hei nda ima tulu-fali Au sa.’ ");
INSERT INTO row_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Rena onaꞌ naa, dei fo atahori deꞌulakaꞌ ra rataa rae, ‘Papa, ia taꞌo bee ena ia? Papa nae Papa ndoe, te hai nda fee nanaat sa. Papa naꞌamadꞌa, te hai nda fee nggo minu sa. Papa onaꞌ atahori fuiꞌ, te hai nda simbo sia hai umem sa. Papa nda naꞌena bua-baꞌus sa, te hai nda fee sa. Papa namahedꞌi, te hai nda mii tao-mataꞌ sa. Papa sia bui rala, te hai nda mii tulu-fali sa. Te eni bee se hai tao Papa onaꞌ naa?’ ");
INSERT INTO row_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Dei fo Au utaa se ae, ‘Mimihere Au! Te leleꞌ hei nda tulu-fali atahori mana tudꞌa-loloeꞌ ra sa, naa, onaꞌ hei nda tulu-fali Au sa boe.’ ");
INSERT INTO row_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Basa naa ma, atahori deꞌulakaꞌ ra hambu doidꞌoso rakandooꞌ a losa doo nduꞌu doon neu. Te atahori rala ndoos ra hambu masoi-masodꞌaꞌ rakandoo ro Lamatualain losa doo nduꞌu doon neu.” ");
INSERT INTO row_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Leleꞌ Yesus nanori nateꞌe basa dalaꞌ naa ra, ma Ana nafadꞌe ana mana tungga nara nae, ");
INSERT INTO row_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Hei bubꞌuluꞌ ena, fai rua fai te hita fai malolen, naeni, Fefeta Paska. Leleꞌ naa, dei fo hambu atahori mana seo Au, Atahori Matetuꞌ ia. Basa de ara mbaku risa Au sia hau ngganggeꞌ.” ");
INSERT INTO row_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Faiꞌ naa, malangga agama Yahudi malangga nara ro lasi-lasi adat ra raꞌabꞌue sia Kayafas umen. Kayafas naa, naeni malangga agama Yahudi malangga moko-monae na. ");
INSERT INTO row_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ara sangga dalaꞌ fo rae humu Yesus no nee-nee, fo rae risa E. ");
INSERT INTO row_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Te ara rala haraꞌ rae, “Helafiꞌ dei! Ata afiꞌ humu E lai-laiꞌ huu fai-fai maloleꞌ sangga losa ena. Afiꞌ losa atahori hetar mana hii E, fela ramue.” ");
INSERT INTO row_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Sia Kambo Betania, hambu atahori esa, naran Simon. Feꞌesaꞌan, atahori melumudꞌu e, huu ana namahedꞌi kusta. Te ia na, ana hai ena. Leleꞌ fai malole ra nda feꞌe losa sa, ma Yesus se reu raa mia Simon umen. ");
INSERT INTO row_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Leleꞌ ara raa, ma inaꞌ esa nema nandaa no Yesus. Ana toꞌu boto esa, tao mia fatu mafelit. Boto a isin mina maꞌameni mafelit. Basa ma, inaꞌ a poko tiku boto a tatanan. De ana mbori naꞌandandaliꞌ mina naa mbei-mbei neu Yesus langgan, fo dadꞌi bukti eni fee hadꞌa-hormat neu E. ");
INSERT INTO row_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Te leleꞌ Yesus ana mana tungga nara rita inaꞌ a tao taꞌo naa, ma ramanasa, de ara ola-olaꞌ rae, “Hee! Afiꞌ nggari hendi mina maꞌameniꞌ mafelit naa neuꞌ ena! ");
INSERT INTO row_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Malole lenaꞌ eni seo mina naa! Fo doin, babꞌanggi fee neu atahori mana toꞌa-taaꞌ ra!” ");
INSERT INTO row_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Te Yesus nahine dudꞌuꞌa nara, de Ana olaꞌ nae, “Hei afiꞌ tao miꞌisususaꞌ inaꞌ ia! Hela neu leo!! Te saa fo ana tao neu Auꞌ ia maloleꞌ. ");
INSERT INTO row_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Te atahori mana toꞌa-taaꞌ ra sia hei taladꞌam mara rakandooꞌ a. Te nda doo sa ena, te Au ia, nda uꞌubꞌue o nggi sa ena. ");
INSERT INTO row_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ma inaꞌ ia mbori mina ia, ana sadꞌia Au ao ngga onaꞌ ana rambe memaꞌ Au ao sisi mana mate ngga. Huu Au masodꞌa ngga nda dooꞌ sa ena. ");
INSERT INTO row_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Misinedꞌa matalolole, o! Sia bee-bꞌee Lamatualain Dudꞌui malolen nene dui-bꞌenggaꞌ ndule raefafoꞌ ia, neꞌo ara o dui inaꞌ ia malolen! Naa fo basa atahori rasanedꞌa e.” ");
INSERT INTO row_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Hambu atahori esa mia Yesus ana mana tungga ka sanahulu rua nara, naran Yudas Iskariot. Faiꞌ naa boe o, ana lao neu sangga malangga agama Yahudi ra malangga nara, fo nae fee hendi Yesus neu se. ");
INSERT INTO row_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Losa se ma, ana natane nae, “Amaꞌ re! Mete ma au tulun humu Yesus fee neu nggi, naa, hei fee au saa?” Boe ma rataa rae, “Mete ma nau seo E neu hai naa, hai bae.” Basa ma, ara reken rala doi fulaꞌ telu nulu de fee neu Yudas. ");
INSERT INTO row_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Basa ma, Yudas lao dea neu, ma ana sangga dalaꞌ fo nae fee Yesus neu se. ");
INSERT INTO row_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Tungga too, atahori Yahudi ra fai maloleꞌ nara doon fai hitu. Ara roꞌe fai malole naa ra rae, ‘Fefeta Roti nda pake bibꞌit sa’. Leleꞌ ara sadꞌia rae feta ma, Yesus ana mana tungga nara rema ratane E rae, “Amaꞌ! Tetembaꞌ ia hita musi mulai tao fai malole tara. Dadꞌi Amaꞌ nau hai mi mbau bibꞌi Lombo, ma mii sadꞌia mamanaꞌ feta Paska sia bee?” ");
INSERT INTO row_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Boe ma Ana nataa nae, “Ama kota rala mii, dei fo hei mindaa mo amaꞌ sa. Mifadꞌe mbali e maꞌo ia, ‘Aꞌa, e! Ama Meser medꞌa-medꞌa na nda dooꞌ sa te Eni mate ena. De Ana noꞌe mamanaꞌ sia aꞌa umen, fo Ana tao fefeta Paska no ana mana tungga nara.’” ");
INSERT INTO row_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Rena taꞌo naa ma, ana mana tungga nara reu tao tungga oꞌolan. De ara lole-lau nanaat fefeta Paska sia naa. ");
INSERT INTO row_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Tetemban ma, Yesus no ana mana tungga ka sanahulu rua nara endoꞌ ra fefetas. ");
INSERT INTO row_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Leleꞌ ara raa ma, Ana olaꞌ nae, “Hei rena, e! Hambu esa mia hei, dei fo mana seo hendi Au neu atahori feaꞌ ra.” ");
INSERT INTO row_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Rena rala ma, rala nara susa. Boe ma esa-esaꞌ natane Yesus nae, “Atahori fo Amaꞌ olaꞌ naa, nda au sa to?” ");
INSERT INTO row_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Boe ma Ana nataa nae, “Atahori fo mana boroꞌ rotin nandaa no Au nisiꞌ manggo a rala, dei fo ana mana seo hendi Au. ");
INSERT INTO row_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Misinedꞌa, e! Au, atahori Tebꞌe-Tebꞌeꞌ ia, musi mate onaꞌ ara suraꞌ memaꞌ sia Lamatualain Susura Meumaren. Te besa-bꞌesa! Atahori mana nae seo hendi Au na, dei fo ana lemba-nasaa sosoen! Malole lenaꞌ maman nda bonggi e sa!” ");
INSERT INTO row_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Basa naa ma, Yudas o tungga natane nae, “Neꞌo atahori fo Amaꞌ olaꞌ na, nda au sa, to?” Boe ma Yesus nataa nae, “Memaꞌ mesaꞌ nggo mana maꞌo naa ena. Te seka fai?” ");
INSERT INTO row_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Leleꞌ ara feꞌe ra ma, Yesus haꞌi roti balaꞌ esa, de noꞌe makasi mbali Lamatualain. Basa de Ana bibꞌibꞌi roti a, ma olaꞌ nae, “Roti ia, Au ao ngga. Ama haꞌi fo mia leo!” ");
INSERT INTO row_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Basa naa ma, Ana haꞌi nala nggalas esa anggor sofe, de noꞌe makasi mbali Lamatualain. Basa ma Ana loo neu ana mana tungga nara, ma olaꞌ nae, “Basa nggi haꞌi fo minu leo. ");
INSERT INTO row_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Huu anggor ia, Au raa ngga. Dei fo Au mate, na raa ngga nandali fo fee masodꞌaꞌ neu atahori hetar mia sala-kilu nara. Raaꞌ ia dadꞌi tanda nesenenedꞌaꞌ oi, saa fo Lamatualain helu-fuliꞌ a, ia na dadꞌi ena. Naa, haꞌi fo minu leo! ");
INSERT INTO row_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Te rena malolole! Eniꞌ a mia tetembaꞌ ia, Au nda inu anggor sa ena. Dei fo mete ma Ama ngga endoꞌ toꞌu parendaꞌ sia sorga, fo Au feꞌe inu o nggi fai.” ");
INSERT INTO row_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Basa ma, ara sodꞌa sosodꞌat esa de koa-kio Lamatualain. Ma, tetemba naa boe o, ara lao risiꞌ lete Saitun. ");
INSERT INTO row_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Leleꞌ ara lao-laoꞌ ma, Yesus nafadꞌe ana mana tungga nara nae, “Dei fo tetembaꞌ ia na, basa hei mela hela Au. Te ara suraꞌ memaꞌ sia Lamatualain Susura Meumaren oi, ‘Dei fo Lamatualain tao nisa manatadꞌa a, ma bibꞌi lombo nara rela sea-saranggaa.’ ");
INSERT INTO row_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Memaꞌ au mate. Te dei fo Au usodꞌa baliꞌ, na Au uu uhani nggi sia profinsi Galilea. ");
INSERT INTO row_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Te Petrus nareresi nae, “Amaꞌ! Onaꞌ mae atahori laen ra basa se rela hela Amaꞌ, te au nda ela hela nggo sa!” ");
INSERT INTO row_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Boe ma Yesus nataa nae, “Tebꞌe taꞌo naa do Petrus? Mumuhere neu Au! Tetembaꞌ ia, manu nda feꞌe koꞌokee sa, te ho olaꞌ lao telu ena mae, nda muhine Au sa!” ");
INSERT INTO row_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Te Petrus nareresi nae, “Hokoꞌ, Amaꞌ! Mete ma Amaꞌ mate, na au mate o nggo boe. Huu au nda ela hela Amaꞌ sa!” Petrus nonoon laen ra o esa-esaꞌ raꞌo naa boe. ");
INSERT INTO row_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Basa ma Yesus se lao rakandoo sia lete Saitun, losa osi esa naran Getsemani. Sia naa Ana olaꞌ no ana mana tungga nara nae, “Ama endoꞌ tahan sia ia dei, te Au ae uu hule-oꞌe sia naa.” ");
INSERT INTO row_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Te Ana noꞌe nala Petrus, Yakobis, no Yohanis, fo teluꞌ se reu ramaloloꞌ ro E. Eniꞌ a mia leleꞌ naa, ma ralan susa nala seli ma nda fefeet sa. ");
INSERT INTO row_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ara feꞌe laoꞌ rala mbei, te Ana nafadꞌe se nae, “Au rala ngga susa nala seli! Au medꞌa onaꞌ Au aeꞌ a mate! Ama endoꞌ beꞌe minea mo au sia ia dei.” ");
INSERT INTO row_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Basa de ana mata neu naꞌadꞌodꞌooꞌ mbei, ma Ana sendeꞌ lululanggan de hule-oꞌe nae, “Ama boꞌi! Mete ma Amaꞌ naꞌaheiꞌ, na, Au afiꞌ lemba-doi doidꞌosoꞌ ia. Te afiꞌ tungga Au hihii Ngga; tunggaꞌ a Amaꞌ hihiin.” ");
INSERT INTO row_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Hule-oꞌe basa, ma Ana baliꞌ nisiꞌ ana mana tungga ka teluꞌ ra. Te mana sunggu masambetaꞌ ra. De Ana fafae se ma olaꞌ no Petrus nae, “He, Petrus! Saa de hei sungguꞌ? Au mia naa losaꞌ a, te ama nda beꞌe minea mo Au mbei sa boe do! ");
INSERT INTO row_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kukur mimeu mata mara dei. Basaꞌ fo fela minea mo Au! Huu memaꞌ hei rala mara mae tao maloleꞌ, akaꞌ na ao sisi mara nda beꞌi sa. Dadꞌi malole lenaꞌ ama hule-oꞌe fo mete ma hambu sosoba-dodꞌouꞌ, na bisa miꞌitataꞌ. ");
INSERT INTO row_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Basa de Ana neu hule-oꞌe fai nae, “Amaꞌ! Mete ma Au musi lemba doidꞌosoꞌ ia, na, tunggaꞌ a Amaꞌ hihii-nanaun.” ");
INSERT INTO row_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Hule-oꞌe basa ma, Ana baliꞌ nema nisiꞌ ana mana tungga ka teluꞌ ra. Te ara sungguꞌ baliꞌ fai, huu ara nduar rala seli na. ");
INSERT INTO row_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Boe ma Ana lao hela se, de baliꞌ neu hule-oꞌe lao esa faiꞌ. Ana noꞌe seluꞌ Aman, fo afiꞌ fee Eni lemba-nasaa doidꞌosoꞌ naa, te tungga neu akaꞌ Amaꞌ hihii-nanaun. ");
INSERT INTO row_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Hule-oꞌe basa ma, Ana baliꞌ neu de fafae Ana mana tungga nara nae, “Hei feꞌe sunggu mikindoo, do? Fela leo! Te atahori mana nae seo Au, Atahori Matetuꞌ ia, sangga losa ena. Leleꞌ ia, ara rae humu Au, fo fee neu atahori deꞌulakaꞌ ra liman. ");
INSERT INTO row_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Weh! Fela leo! Milaa mata mara fo mete sobꞌa sia naa dei! Te atahori mana seo Au a, nema ena.” ");
INSERT INTO row_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Leleꞌ Yesus feꞌe ola-olaꞌ taꞌo naa, ma Yudas nema no atahori nononggoꞌ sa. Ara rema rendi fela tafaꞌ no hau eꞌetuꞌ, fo rae humu E. Ara tao taꞌo naa, tungga malangga agama Yahudi ra malangga monaen ma lasi-lasi adat ra parendan. ");
INSERT INTO row_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yudas nafadꞌe memaꞌ se nae, “hei mete malolole, e! Atahori fo au idꞌuꞌ a, hei toꞌu E leo! Te Eni, atahori fo hei sanggaꞌ a! ");
INSERT INTO row_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Leleꞌ ara losa Yesus, boe ma Yudas neu nisiꞌ Yesus matan, de nae, “Sodꞌa-moleꞌ, Ama Meser!” Boe ma Yudas holu ma idꞌu E. ");
INSERT INTO row_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Boe ma Yesus natane mbali e nae, “Hee, Yudas! Uꞌuma ma, no masud ia, do?” Boe ma, atahori naa ra mata reu, fo rae humu E. ");
INSERT INTO row_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ma nda bubꞌuluꞌ sa te, Yesus atahorin esa lesu tafaꞌ na de, soe naꞌetuꞌ atahori esa ndiki roon. (Atahori mana hambu bisu naa, naeni malangga agama Yahudi ra malangga monaen atahori dedꞌenun.) ");
INSERT INTO row_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Nita taꞌo naa ma, Yesus nafadꞌe nae, “Dosoꞌ baliꞌ tafa ma neu ngguman. Huu atahori mana nasodꞌa naꞌamiminaꞌ tafaꞌ, dei fo ana o mate no tafaꞌ boe. ");
INSERT INTO row_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nda muhine sa, do? Au bisa oꞌe Ama ngga fo Ana haitua ana mana tunggan rifon-rifon sia sorga, fo rema tulu-fali Au. ");
INSERT INTO row_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Te onaꞌ leo. Hela fo atahori ia ra humu rala Au. Te basa saa fo nenesuraꞌ memaꞌ sia Lamatualain Susura Meumaren soꞌal Au, musi dadꞌi.” ");
INSERT INTO row_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Boe ma Yesus olaꞌ neu atahori hetar mana rema humu E nae, “Weh! Hei mae Au ia, atahori deꞌulakaꞌ, do? Taꞌo bee de ama ima mae humu Au mendiꞌ tafaꞌ no hau eꞌetuꞌ? Tao-tao te, tungga-tungga fai Au unori nggi sia Lamatualain Ume Hule-oꞌe Huu na, te nda hambu atahori esa tao saa-saa mbali Au sa boe. ");
INSERT INTO row_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Te hela neu! Ima, toꞌu mala Au leo! Te basa ia nenesuraꞌ memaꞌ eniꞌ a lele uluꞌ a sia Lamatualain Susura Meumaren.” Rita taꞌo naa ma, Yesus ana mana tungga nara ramatau rala seli. Boe ma ara fela rela hela Lamatuaꞌ. ");
INSERT INTO row_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Basa ma, atahori humu rala Yesus de ro E nisiꞌ Malangga agama Yahudi ra malangga monaen, Kayafas, umen, huu atahori moko-monaen ra raꞌabꞌue sia naa ena. Naeni, malangga agama Yahudi ra malangga monae na, meser agama ra, ro lasi-lasi adꞌat ra. ");
INSERT INTO row_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Leleꞌ ara toꞌu ro E, ma Petrus laoꞌ naꞌabꞌabꞌambiꞌ aon tungga-tungga deaꞌ, losa malangga monaeꞌ a umen. Petrus o rala neu nisiꞌ nembeleon, de tungga endoꞌ naꞌabꞌue no atahori mana sia naa ra. Huu ana nae nahine saa fo neꞌo dadꞌi. ");
INSERT INTO row_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Sia ume naa rala, malangga agama Yahudi ra malangga nara raꞌabꞌue ro basa atahori mana maꞌetuꞌ dedꞌeat agama ra. Ara rae sangga bukti ma sangga dalaꞌ rae raꞌetuꞌ hukun risa Yesus. ");
INSERT INTO row_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Te mae ara sangga bukti rendiꞌ sakasii lelekoꞌ hetar o, ara nda hambu bukti saa-saa sa boe. Dei de ara hambu mana sakasii atahori rua. ");
INSERT INTO row_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Atahori ka ruaꞌ naa ra sakasii rae, “Hai rena mita atahori ia olaꞌ nae, ‘Dei fo Au ofe hendi Ume Hule-oꞌe Huuꞌ a. Te Au ufefela baliꞌ e, siaꞌ a fai telu rala.’” ");
INSERT INTO row_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Basa ma, malangga agama Yahudi malangga monaen nambariiꞌ sia basa atahori mana endoꞌ sia naa ra mata nara. Boe ma natane Yesus nae, “Ho rena atahori naeꞌ fua salaꞌ neu nggo. Te, taꞌo bee de neneeꞌ a?” ");
INSERT INTO row_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Te Yesus nda nataa saa-saa sa boe. Boe ma malangga monaeꞌ a natane fai nae, “Au ae utane ia fai! Te musi mutaa no matetuꞌ onaꞌ mutaa neu Lamatualain mana masodꞌa sia sorga. Hambu atahori rae, Ho ia, Kristus, Lamatualain Anan fo Ana helu-fuli mia lele uluꞌ a. Naa tebꞌe, do? ");
INSERT INTO row_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Basa boe ma, Yesus nataa nae, “Memaꞌ tebꞌe, onaꞌ pak oꞌolan. Te musunedꞌa, e! Dei fo basa nggi mita Au, Atahori Matetuꞌ ia. Dei fo Au endoꞌ sia sorga sia Lamatualain bobꞌoa onan, fo toꞌu parendaꞌ uꞌubꞌue o E mana koasa manaseliꞌ a. Basa naa dei fo, Au onda baliꞌ uma o leleeꞌ a.” ");
INSERT INTO row_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Rena Ana olaꞌ naꞌo naa, ma malangga monaeꞌ a namanasa seli, losa ana sii nasikaꞌ hendi badꞌu narun. Ma randu nahereꞌ neu basa atahori mana endoꞌ sia naa ra nae, “Woe! Hita nda parlu sangga sakasii sa ena! Hei rena oꞌolan no ndiki mara ena to. Ana soꞌu Aon dadꞌi Lamatualain Anan ena. Ia neꞌemutis! Basa hei bubꞌuluꞌ mae, tungga hita atoran agama na, mete ma hambu atahori tao aon onaꞌ Lamatuaꞌ, na, atahori naa musi mate! ");
INSERT INTO row_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Dadꞌi ia na, tae taꞌetuꞌ, taꞌo bee?” Boe ma basa se randu rahereꞌ rae, “Atahori ia memaꞌ sala tebꞌe ena! Dadꞌi Ana musi nenehukun mate!” ");
INSERT INTO row_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Basa ma, hambu atahori hira mata reu de puras miru neu Yesus. Ma ara poko-paru raꞌamiminaꞌ ma mbasa E. ");
INSERT INTO row_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Basa ma ara raꞌaꞌeꞌeiꞌ E rae, “Weh! Ho ia, Kristus, to? Mufadꞌe sobꞌa dei! Seka mana tutu nggo?” ");
INSERT INTO row_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Leleꞌ naa, Petrus tungga de feꞌe endoꞌ sia ume a nembeloan. Boe ma ate inaꞌ esa neu de olaꞌ mbali e nae, “Faꞌra, ho o uma muꞌubꞌue mo Yesus, atahori Nasaret naa, to?” ");
INSERT INTO row_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Te ana nafanii sia atahori hetar matan nae, “Hokoꞌ! Taꞌo bee de mutane taꞌo naa! Au nda uhine atahori naa sa, ma.” ");
INSERT INTO row_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Basa ma, Petrus dea neu de nambariiꞌ sia lelesu ineꞌ mataꞌ. Boe ma, inaꞌ laen sa fai nita e sia naa. Boe ma, ana nafadꞌe neu atahori mana sia naa ra nae, “We, faꞌ ra au ita atahori ia nema no Yesus, atahori Nasaret naa.” ");
INSERT INTO row_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Boe ma Petrus namue nae, “Mbei ma ho muluꞌ do! Au nda uhine atahori naa, sa ma! Au sumba!” ");
INSERT INTO row_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Nda doo sa fai ma, atahori laen mana sia naa ra olaꞌ ro e fai rae, “Hee! Ho afiꞌ ombo-koson fai mae, ho nda muꞌubꞌue mo atahori naa sa! Huu hai rena dedꞌea ma naa, onaꞌ atahori Galilea ra boe!” ");
INSERT INTO row_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Te ana rarai-oꞌole, ma labꞌan nae, “Weh! Au sumba endiꞌ Lamatualain naran, te au nda uhine Atahori ia sa!” Ana olaꞌ taꞌo naa, boe ma manu a koꞌokee boe. ");
INSERT INTO row_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Rena manu koꞌokee ma, Petrus nasanedꞌa Yesus dedꞌean faꞌ ra nae, “Manu nda feꞌe koꞌokee sa te, ho mutaa mae nda muhine Au sa lao telu ena.” Nasanedꞌa nala taꞌo naa ma, ana lao deaꞌ neu de nggae mesuꞌudꞌu. ");
INSERT INTO row_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Fefetu anan, basa atahori mana nggero dedꞌeat agama naa, rala haraꞌ sa, fo rae tao risa Yesus. ");
INSERT INTO row_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Huu naa, ara paꞌa rendi E neu nataa hofernor Pilatus. Huu ara nauꞌ a hofernor Pilatus hukun nisa Yesus. ");
INSERT INTO row_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Leleꞌ Yudas bubꞌuluꞌ oi, Yesus nene hukun mate ma, ana fale ralan, huu eni mana seo hendi Yesus. Basa ma ana baliꞌ nisiꞌ malangga agama Yahudi ra malangga nara, ro lasi-lasi adat ra, fo fee baliꞌ doi fula ka telu nulu nara. ");
INSERT INTO row_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ana nafadꞌe nae, “Au sala ena, huu au fee hendi atahori nda mana naꞌena salaꞌ saa sa boe.” Te ara rataa rae, “Weh! Hai nda bubꞌuluꞌ mo nggo saa ena! Mesaꞌ nggo musi lemba-musaa salaꞌ naa.” ");
INSERT INTO row_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Basa ma Yudas mbia hendi doiꞌ ra risiꞌ Ume Hule-oꞌe Huuꞌ a. De lao dea neu londa aon losa ana mate. ");
INSERT INTO row_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Boe ma malangga agama Yahudi ra malangga nara reu tengga rala doiꞌ fo Yudas nggari hendiꞌ naa ra. Ara ola-olaꞌ rae, “Ata afiꞌ tao baliꞌ doiꞌ ia ra risiꞌ peti doiꞌ rala neu, te doiꞌ ia manggenggeoꞌ. ");
INSERT INTO row_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Dadꞌi malole lenaꞌ teu hasa rae ombat esa sia mana tao huraꞌ ra. Mete ma atahori feaꞌ ra mate, ma atahori nda rahine e sa, na, ata taꞌoi e sia naa.” ");
INSERT INTO row_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Basa ma ara pake doiꞌ naa ra, de reu hasa rendiꞌ neu rae. Naa de losa faiꞌ ia, atahori roꞌe rae naa oi, “Rae raaꞌ’. ");
INSERT INTO row_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","No taꞌo naa, ara tungga Lamatuaꞌ mana ola-olan Yermia nafadꞌe memaꞌ nae, “Ara pake doi fulaꞌ telu nulu fo hasa rae. Ara pake doiꞌ naa ra, huu doiꞌ naa dai bae neu atahori sa felin, tungga saa fo atahori Israꞌel ra raꞌetuꞌ memaꞌ ena. ");
INSERT INTO row_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Rae naa ara hasa mia mana tao huraꞌ, tungga Lamatualain parendan neu au.” ");
INSERT INTO row_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Leleꞌ naa atahori toꞌu rendi Yesus nisiꞌ hofernor, boe ma ana naselu bale no Yesus nae, “Taꞌo bee e? Ho ia, tebꞌe-tebꞌeꞌ atahori Yahudi ra, Manen do?” Ana nataa nae, “Tebꞌe. Pak olaꞌ naa nda ena.” ");
INSERT INTO row_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Te leleꞌ malangga agama Yahudi ra malangga nara ro lasi-lasi adat ra fua salaꞌ hetar neu Yesus. Ana nda nataa saa sa boe. ");
INSERT INTO row_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Basa ma hofernor natane mbali E nae, “Nda rena oꞌolan nara sa do? Ara fee salaꞌ hetar neu Nggo. Te taꞌo bee de nda muselu sa boe?!” ");
INSERT INTO row_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Te Ana nda nataa mbei sa boe, losa hofernor a o ndindiiꞌ a boe. ");
INSERT INTO row_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Tungga too, mete ma atahori Yahudi ra tao fefeta Paska, na, Hofernor a biasa mboi atahori bui esa fee neu se tungga sira hihiin. ");
INSERT INTO row_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Lele naa, atahori bui esa, naran Barabas. Basa atahori rahine e, huu deꞌulakan seli. ");
INSERT INTO row_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Faiꞌ naa o, atahori hetar reu risiꞌ hofernor fo roꞌe ana mboꞌi hendi atahori bui esa onaꞌ biasan. Boe ma Pilatus natane se nae, “Malole! Te au mboꞌi seka? Sia ia Barabas, ma Yesus fo atahori roꞌe rae, Yesus, Kristus. Au mboꞌi seka? Hei pili.” ");
INSERT INTO row_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","(Hofernor olaꞌ naꞌo naa, te ana bubꞌuluꞌ malangga agama Yahudi ra malangga nara rendi Yesus fee neu eni, huu mburuoeꞌ seli ro E.) ");
INSERT INTO row_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Leleꞌ hofernor feꞌe paresaꞌ dedꞌeat naa, ma saon haitua haraꞌ fee neu e nae, “Amaꞌ, e! Besa-besa o te Yesus nda naena salaꞌ saa sa boe. Huu Yesus, de tembaꞌ au ulumein nda maloleꞌ sa. Losa leleꞌ ia boe o au feꞌe medꞌa na nda maloleꞌ sa.” ");
INSERT INTO row_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Te malangga agama Yahudi ra malangga nara ro lasi-lasi adꞌat ra akaꞌ tusu-hai atahori hetar naa ra, fo roꞌe hofernor mboꞌi Barabas, ma hukun risa Yesus. ");
INSERT INTO row_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Basa de natane seluꞌ se fai nae, “Mia atahori ka ruaꞌ ia ra, au mboꞌi seka?” Ma basa se rataa randaa rae, “Barabas! Mboꞌi Barabas!” ");
INSERT INTO row_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Basa ma natane se nae, “Mete ma taꞌo naa, na, au tao Yesus ia taꞌo bee, fo atahori roꞌe rae, Kristus?” Boe ma basa se nggasi randaa rae, “Mbaku misa Yesus sia hau ngganggeꞌ a!” ");
INSERT INTO row_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Hofernor natane fai nae, “Te Yesus salan saa? Au paresaꞌ Yesus ena, te nda hambu salan saa sa boe!” Te basa se nggasi rahereꞌ fai rae, “Tao misa E! Mbaku E neu hau ngganggeꞌ a leo!” ");
INSERT INTO row_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Nda dooꞌ sa ma, ana nahine nae, eni nda bisa tao saa sa ena, huu basa atahori naa ra rae ramue ena. Naa de ana haꞌi oe de safe liman sia mata nara, de nafadꞌe nae, “Au nda lemba-doi atahori ia mamaten sa! Hei mana lemba-doi!” ");
INSERT INTO row_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Boe ma basa atahori naa ra nggasi rataa rae, “Hei, hela neu! Hela fo hai mo hai umbu ana mara lemba-doi mala raa na!” ");
INSERT INTO row_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Rena onaꞌ naa, ma ana oi, “Neu.” Boe ma ana mboꞌi Barabas, tungga hihii nara. Ma ana parenda atahori mana raneaꞌ ra, fo reu liꞌu Yesus rendiꞌ ue. Liꞌu basa, boe ma soldꞌadꞌu ra ro Yesus, de rae reu mbaku risa E sia hau ngganggeꞌ a. ");
INSERT INTO row_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Basa naa ma, soldꞌadꞌu ra lea ro Yesus nisiꞌ sira ume nenean nembeleon. Sia naa, roꞌe rala nonoo nara batalion esa. ");
INSERT INTO row_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Boe ma ara fee Yesus pake badꞌu naruꞌ dula mbila rorooꞌ esa. ");
INSERT INTO row_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Boe ma, ara haꞌi rala hau manggouꞌ a longgen de hano e dadꞌi soloꞌ. De ara ndeni solo mahinat naa neu Yesus langgan, de raꞌamiminaꞌ onaꞌ ara rae soꞌu mane feuꞌ rendiꞌ solo panggat. Boe ma ara fee Yesus toꞌu hau esa sia lima onan, onaꞌ tetea parendaꞌ. Basa ma ara sendeꞌ lululangga nara mbali Yesus, ma raꞌaeꞌeiꞌ E rae, “Hadꞌa-hormat atahori Yahudi ra manen.” ");
INSERT INTO row_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Boe ma ara puras miru neu Yesus, ma haꞌi teteas mia liman, de dedꞌeu raꞌamiminaꞌ neu Yesus langgan. ");
INSERT INTO row_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ara raꞌaꞌeꞌeiꞌ basa Yesus, ma ara olu hendi badꞌu naruꞌ a. De ara olu baliꞌ Yesus bua-baꞌu na. Basa ma, ara ro Yesus kalua mia kota Yerusalem, fo reu mbaku Yesus sia hau ngganggeꞌ losa mate. ");
INSERT INTO row_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Leleꞌ ara lea rendi Yesus, losa dalaꞌ taladꞌan ma randaa ro atahori Kirene sa nae kota rala neu. Naran Simon. Ara raꞌasusuuꞌ e nasaa nggati Yesus hau ngganggen. ");
INSERT INTO row_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Basa ma ara losa mamanaꞌ sa, naran Golgota. (Sia dedꞌea Aram, sosoan nae, “Mamana langga ruiꞌ.”) ");
INSERT INTO row_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Sia naa ara rae fee Yesus ninu anggor mana sambor no modꞌo mana meruꞌ, naa fo Ana bisa naꞌatataaꞌ mambetaꞌ a. Yesus sobꞌa nala mbei ma, Ana timba hendi e. ");
INSERT INTO row_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Basa ma ara mbaku E sia hau ngganggeꞌ. Boe ma soldꞌadꞌu ra lea lot fo rae rahine seka mana hambu bua-baꞌun. ");
INSERT INTO row_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Basa ma ara endoꞌ ranea E sia naa. ");
INSERT INTO row_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ara suraꞌ sia papaꞌ sa rae, “IA YESUS, ATAHORI YAHUDI RA MANEN” Boe ma ara mbaku papaꞌ neu Yesus Langgan ataꞌ, de rafadꞌe saa de ara hukun risa Lamatuaꞌ Yesus. ");
INSERT INTO row_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Sia naa, ara o mbaku risa atahori naꞌo rua boe. Esa sia Yesus bobꞌoa onan; ma esa sia bobꞌoa diin. ");
INSERT INTO row_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Basa atahori mana lao tungga naa, mete E. Boe ma ara penggo-ule bafa nara ma raꞌaꞌeꞌei E. ");
INSERT INTO row_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ara eki-randu E rae, “Hoi! Ho mae, Ho bisa ofe hendi Lamatualain Ume Hule-oꞌe Huu na, basa fo mufefela baliꞌ e sia akaꞌ fai telu, rala, to? Mete ma tebꞌeꞌ-tebꞌeꞌ Ho Lamatualain Anan, na, sobꞌa mboꞌi hendi Aom fo onda mia hau naa ata.” ");
INSERT INTO row_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Malangga agama Yahudi ra malangga nara, meser agama ra, ro lasi-lasi adat ra o raꞌaeꞌeiꞌ E onaꞌ naa boe rae, ");
INSERT INTO row_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ana fee atahori laen rasodꞌa ena, te Ana nda tao nasodꞌa nala aon sa, o. Ana nae, Eni atahori Israꞌel ra Manen! Mete ma taꞌo naa na malole lenaꞌ Ana onda mia hau ngganggeꞌ a leo. Mete ma tita taꞌo naa, fo ata feꞌe tamahere E Ena. ");
INSERT INTO row_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Mete ma tebꞌe-tebꞌeꞌ Eni Lamatualain Anan, Hela neu fo ‘Ana namahena neu Lamatualain. Dadꞌi mete ma Lamatuaꞌ hii E, hela neu fo Lamatuaꞌ mana fee E masodꞌa.’” ");
INSERT INTO row_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Naꞌo karuaꞌ ra o raꞌaeꞌeiꞌ E onaꞌ naa boe. ");
INSERT INTO row_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Basa naa ma, maꞌahatuꞌ a tatana nala mamanaꞌ naa mia reorendun losa liiꞌ telu bobꞌon. ");
INSERT INTO row_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Nandaa no liiꞌ telu bobꞌon ma, Yesus nggasi nendiꞌ dedꞌea Aram nae, “Eli-Eli! Lama sabaktani?” (Sosoan oi, “Au Lamatua ngga! Au Lamatualain ngga, e! Taꞌo bee de Amaꞌ musudꞌea lao hela Au taꞌo ia?”) ");
INSERT INTO row_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Hambu atahori hira deka-deka sia naa rena haran. Boe ma ara rae, “Hoi! Hei rena dei. Ana noꞌe Elia, Lamatuaꞌ mana ola-ola maꞌahulun!’ ");
INSERT INTO row_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Basa ma atahori sa nela-nelaꞌ neu haꞌi nala lombu de boroꞌ neu anggor maꞌeiꞌ a. Boe ma ana dosoꞌ te a tonggo na neu lombu a, de loo neu Yesus nudꞌun fo Ana musi. ");
INSERT INTO row_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Te atahori ruma fai olaꞌ rae, “Tahani dei fo ata mete sobꞌa, Elia nau nema fee masodꞌaꞌ neu E, do hokoꞌ?” ");
INSERT INTO row_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Basa ma Yesus nggasi nahereꞌ seluꞌ, ma etu hahaen boe. ");
INSERT INTO row_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Sia Ume Hule-Oꞌe Huuꞌ a, hambu teme babꞌa monae loaꞌ sa doko-doko bambi Lamatualain Kama Meumare manaseliꞌ Na. Leleꞌ Yesus hahaen etu boe, ma teme babꞌaꞌ a sika hendi neu rua, mia ataꞌ losa raeꞌ neu. Boe ma rae a nanggenggo losa fatu monaeꞌ ra senggi. ");
INSERT INTO row_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Rates ra o tabuka boe. Boe ma Lamatualain tao nasodꞌa bali atahori mana mate nara ruma. ");
INSERT INTO row_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Leleꞌ Yesus nasodꞌa baliꞌ, ma ara dea rema mia rates ra, de masoꞌ risiꞌ Yerusalem. Atahori hetar rita se mia naa. ");
INSERT INTO row_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Sia Golgota, malangga no ana mana tungga nara ranea Yesus hau nggangge na. Leleꞌ ara rita raefafoꞌ nanggenggo, no basa manadadꞌiꞌ ra, boe ma ara ramatau rae mate. Ara ola-olaꞌ rae, “Awi! atahori ia, memaꞌ tebꞌe-tebꞌeꞌ Lamatualain Anan. ");
INSERT INTO row_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Sia naa boe o hambu mama hira, mana rita Yesus mamaten miaꞌ a dodꞌooꞌ. Ara tungga E eniꞌ a mia Galilea, te sira mana mete-seꞌu E eniꞌ a dalahulun. ");
INSERT INTO row_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mia mama naa ra, Maria mia Kambu Magdala, Maria esa fai (naeni Yakobis no Yusuf maman), Ma Sabadius saon (naeni Yakobis no Yohanis maman). ");
INSERT INTO row_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Sia naa hambu atahori mamasuꞌi esa naran Yusuf mia kambo Arimatea. Ana tungga Lamatuaꞌ Yesus nenorin dooꞌ ena. Yesus mamaten naa, nandaa no hari Lima. Mbilaꞌ neu nandaa no atahori Yahudi ra fai hule-oꞌen. Naa de leleꞌ relo a nae mopo ma, Yusuf sangga dalaꞌ fo nae naꞌondaꞌ memaꞌ Yesus ao sisin mia hau ngganggeꞌ a. ");
INSERT INTO row_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Boe ma ana neu nisiꞌ hofernor Pilatus, de noꞌe Yesus ao sisin. Boe ma hofernor o parenda fo ara fee Yesus ao sisin neu Yusuf. ");
INSERT INTO row_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ma Yusuf o Golgota neu boe. Ana naꞌondaꞌ Yesus ao sisin mia hau ngganggeꞌ a. De ana mboti nalolole Yesus ao sisin nendiꞌ teme feu mafelit. ");
INSERT INTO row_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Leleꞌ naa, atahori feꞌe na paa basa ndolaꞌ sa sia lete fatuꞌ, fo tao memaꞌ rates fee Yusuf no bobꞌonggi nara. De Yusuf se oꞌo Yesus ao sisin reu tao nisiꞌ ndolaꞌ naa rala. Boe ma, ara lolir rala fatu monaeꞌ sa, de reu tatana malolole ndolaꞌ naa. Basa ma, Yusuf se baliꞌ. ");
INSERT INTO row_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Leleꞌ naa, Maria mia Magdala no Maria laen o, tungga losa naa boe. Ara nggua-nggua mbali ndolaꞌ naa. ");
INSERT INTO row_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Mbilaꞌ neu ma, nandaa no atahori Yahudi ra fai hahae tao ues na. Boe ma malangga agama Yahudi ra malangga nara ro atahori Farisi ra reu randaa ro hofernor. ");
INSERT INTO row_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ara rafadꞌe rae, “Amaꞌ Hofernor, hai misinedꞌa leleꞌ mana peko-lelekoꞌ a feꞌe masodꞌan, ana parna nafadꞌe naꞌo ia: ‘Memaꞌ Au mate, te finiesan na, Au usodꞌa baliꞌ.’ ");
INSERT INTO row_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Huu naa, amaꞌ tulun denu soldꞌadꞌu ra ranea malolole rates a losa nala fai ka telun. No taꞌo naa, ana mana tungga nara nda bisa ramanaꞌo rala ao sisin, fo lelekoꞌ atahori rae, Ana nasodꞌa baliꞌ ena sa. Huu mete ma ara lelekoꞌ taꞌo naa, naa deꞌulaka nara lenaꞌ feꞌesaꞌan sira leleko nara, leleꞌ ara rafadꞌe oi Eni, naa Kristus.” ");
INSERT INTO row_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Rena taꞌo naa, ma hofernor nataa nae, “Maloleꞌ boe! Te hei o miꞌena atahori mana maneaꞌ boe. Malole lenaꞌ denu se, fo reu ranea matalolole mamanaꞌ naa.” ");
INSERT INTO row_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Basa ma ara reu sia mamanaꞌ naa, de roo sira atahori mana manea nara.” Losa naa, ara segel risa fatu neu rates lelesun. Boe ma ara denu atahori naa ra ranea rakandoo mamanaꞌ naa, fo atahori feaꞌ ra afiꞌ rema ramanaꞌo aosisiꞌ naa. ");
INSERT INTO row_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Basa ma nggarei fefetun, ma Maria mia Magdala no Maria laen a, reu seꞌu rates a. ");
INSERT INTO row_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Abꞌoiꞌ ma, raefafoꞌ nanggenggo seli, huu Lamatualain aten esa mia sorga onda nema, ma neu lolir hendi fatu monaeꞌ mana tatana neu rates bafan. Basa ma ana endoꞌ neu fatu naa ata. ");
INSERT INTO row_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ate naa matan naronda onaꞌ ndelas, ma bua-baꞌu nara muti fuufuuꞌ. ");
INSERT INTO row_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Atahori mana maneaꞌ ra ramatau rae mate, losa ara foti nggeꞌe-nggeꞌe, ma nda raꞌaundaꞌ sa onaꞌ atahori mates ra. ");
INSERT INTO row_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Boe ma ate mana mia sorga, nafadꞌe neu mama ra nae, “Ama afiꞌ mimitau! Au bubꞌuluꞌ hei ima sangga Yesus, Atahori fo ara mbaku risa E mia hau ngganggeꞌ a. ");
INSERT INTO row_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Te Ana nda sia ia sa ena. Ana nasodꞌa baliꞌ ena, onaꞌ Ana olaꞌ basa memaꞌ a ena. De rala ima fo mete mataꞌ mamanaꞌ fo ara mbedꞌaꞌ ao sisin. Mamanaꞌ naa rouꞌ ena! ");
INSERT INTO row_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Naa, ia naa ama baliꞌ lai-lai leo! Mii mifadꞌe ana mana tungga nara mae, Yesus nasodꞌa baliꞌ ena. Ana lao naꞌahuluꞌ Galilea neu ena. Ara musi reu randaa roo E sia naa, onaꞌ feꞌesaꞌan Ana helu-fuli memaꞌ neu se. Mimihere leo. Baliꞌ mii mifadꞌe malolole saa fo au olaꞌ iaꞌ a!” ");
INSERT INTO row_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Boe ma mama ra rela dea reu lao hela mamanaꞌ naa. Ara ramatau, te akaꞌ na ramahoꞌo. Ara baliꞌ halalai rendi haraꞌ fee neu ana mana tungga nara. ");
INSERT INTO row_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Te losa dalaꞌ taladꞌan, aibꞌoiꞌ ma Yesus nema nandaa no se. Ana olaꞌ nae, “Sodꞌa-moleꞌ” Rita onaꞌ naa, ma ara rema deka-deka de holu ei nara, ma beꞌutee mbali E. ");
INSERT INTO row_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Boe ma Ana olaꞌ nae, “Afiꞌ mimitau, e! Mii mifadꞌe Au ana mana tungga nggara, fo reu rahani Au sia Galilea.” ");
INSERT INTO row_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Leleꞌ mama ra feꞌe sia dalaꞌ taladꞌan, ma atahori mana manea ra baliꞌ kota reu, Ara reu rendi haraꞌ neu malangga agama Yahudi ra malangga nara soꞌal basa saa mana dadꞌiꞌ ra. ");
INSERT INTO row_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Boe ma malangga sangga dalaꞌ ro lasi-lasi adat ra, fo osu mana manea ra rendiꞌ doiꞌ naeꞌ, fo ara tatana bafa nara. ");
INSERT INTO row_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Malangga naa ra rafadꞌe rae, “Taꞌo ia. Mete ma atahori ratane, na, hei musi mitaa mae, tetembaꞌ naa, hei mana sungguꞌ masambetaꞌ. Tao-tao te ana mana tungga nara rema ramanaꞌo rendi ao sisin. ");
INSERT INTO row_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ma mete ma ama hofernor rena dedꞌeat ia, na, ama afiꞌ mimitau, te dei fo hai mana bale mo toulasiꞌ a.” ");
INSERT INTO row_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Boe ma atahori mana manea ra haꞌi rala doiꞌ ra, Ara tao tungga malangga ra hihii-nanau nara. Naa de losa fain ia atahori Yahudi ra feꞌe ramahere dudꞌui peko-lelekoꞌ naa. ");
INSERT INTO row_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Rena basa mama ra dudꞌuin, ma Yesus ana mana tungga ka sanahulu esa nara, reu risiꞌ profinsi Galilea fo randaa ro E sia leteꞌ sa, tungga hehelu-fufulin. ");
INSERT INTO row_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Leleꞌ ara rita E sia naa, ma ara beꞌutee neu E. Mae taꞌo naa o, feꞌe hambu ruma rala nara banggi-bꞌanggiꞌ. ");
INSERT INTO row_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Boe ma Ana neu deka-deka no se, de olaꞌ nae, “Lamatualain fee Au koasa ena, fo parenda basa mana sia sorga, ma basa mana sia raefafoꞌ ia ra. ");
INSERT INTO row_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Dadꞌi hei mii sia bee-bꞌee, na, hei musi dui-bꞌengga Au Dudꞌui Malole ngga neu basa nusaꞌ ra. Hei musi minori se malolole, naa fo ara dadꞌi Au ana dedꞌenu ngga. Ma musi sarani se fo dadꞌi tatandaꞌ oi, ara raꞌabꞌue reu esa ro Amaꞌ, ma Anan, boe ma Dula-dale Meumaren ");
INSERT INTO row_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ma nenori se fo ara tao tungga basa parendaꞌ fo Au ufadꞌe basa neu nggi ena. Misinedꞌa, e! Au sia hei taladꞌa mara ukundooꞌ a, losa raefafoꞌ ia sambulalo.” ");
INSERT INTO row_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Dudꞌui maloleꞌ ia, Lamatualain Ana na dudꞌui na. Nara na, Yesus Kristus. Lamatualain dudu basa E mia doo na neu. Dudꞌui fefeu na taꞌo ia: ");
INSERT INTO row_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Yesus nda feꞌe tao Eni tatao na sa, te Lamatualain denu atahori sa nara na Yohanis. Yohanis musi neu soi dalaꞌ fee neu Yesus nenema na. Te fai dalahulu naa, Lamatualain pake mana dui-bꞌengga na esa, nara na Baꞌi Yesaya fo suraꞌ memaꞌ nae: “Rena o! Au denu Au atahori ngga, fo neu soi dalaꞌ fee neu Nggo. ");
INSERT INTO row_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Atahori naa neu nisiꞌ mamanaꞌ fo atahori nese, fo nameli nae: ‘Basa atahori raloleꞌ dalaꞌ, fo simbo Lamatuaꞌ nenema na! Ratetu dalaꞌ, fo simbo E.’” ");
INSERT INTO row_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","6","Atahori babꞌae Yohanis, Mana Sarani. Ana leo sia mamana maꞌafuniꞌ. Bua-baꞌu na tao mia onta fulu na. Bꞌobꞌori na tao mia banda rou a. Nanaa na, lamat no oni oeꞌ. (Yohanis masodꞌa na ia, onaꞌ a Baꞌi Elia dalahulu naa). Leleꞌ naa, atahori mia kota Yerusalem, no propinsi Yudea isi nara, rema randaa ro Yohanis sia mamana na. Ara rema rae rita Yohanis ma rae rena nenori na. Ana nafadꞌe nae, “Musi mitaa sala-singgo mara, fo Lamatualain ose hendi basa salaꞌ mara. Basa naa, hei musi sarani dei, fo tao tanda oi hei malole mo Lamatualain ena.” Basa ma, ara rataa sala-singgo nara, de ana sarani se sia loe Yordan. ");
INSERT INTO row_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ana nafadꞌe naꞌo ia, “Dei fo hambu atahori sa mana seliꞌ lenaꞌ au nae nema. Mae dadꞌi akaꞌ a eni dedenu na o, au nda undaa sa. ");
INSERT INTO row_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Au akaꞌ a sarani hei pake oe, te dei fo Ana tao lenaꞌ au, ma Ana tao nasofe hei rala mara no Lamatuaꞌ Dula-Dale Meumare Na.” ");
INSERT INTO row_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Leleꞌ naa, Yesus nema mia kambo Nasaret nisiꞌ Galilea, de nandaa no Yohanis. De Yohanis sarani E mia loe Yordan. ");
INSERT INTO row_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesus dea neu mia oe a, ngegger ma, lalai a sii. Basa ma Lamatualain Dula-Dale na, sama onaꞌ mbui lunda onda neu E. ");
INSERT INTO row_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Boe ma rena Lamatualain hara na mia lalai a oi, “Ho ia, Au Ana susue ngga. Ho tao mumuhoꞌo Au mukundoꞌa.” ");
INSERT INTO row_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Basa ma, Lamatuaꞌ Dula-Dale na nore nendi Yesus nisiꞌ mamana rouꞌ maꞌafuniꞌ. ");
INSERT INTO row_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ana leo mia mamanaꞌ naa fai haa nulu no banda fui ra. Sia naa, malangga nitu ra nema sobꞌa Yesus fo tungga e, te nda nala E sa. Basa ma, Lamatualain ate nara mia sorga rema tao mataꞌ neu Eni. ");
INSERT INTO row_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ara tao Yohanis Mana Saraniꞌ a bui rala neu, te Yesus nisiꞌ propinsi Galilea, de bengga Lamatualain Hara-lii Malole na sia naa. ");
INSERT INTO row_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ana olaꞌ nae, “Rena o! Ia naa, Lamatuaꞌ fai Na losa ena! Ia naa, basa atahori rahine rae Lamatualain toꞌu parendaꞌ. Naa de hei musi miloeꞌ mia sala-singgo mara! Basa fo, tungga Lamatualain Hara-lii Maloleꞌ na leon.” ");
INSERT INTO row_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Faiꞌ esa, Yesus laoꞌ tungga dano Galilea suu na. Ana mete-nita atahori esa nara na Simon, no odꞌi na, Anderias. Ruꞌa se dala uꞌu. Naa sira ue nara fai-fai esa. ");
INSERT INTO row_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesus noꞌe se nae, “Ima fo tungga Au leo! Hei biasa sangga uꞌu, te ia naa Au ae tao hei dadꞌi mana sangga ao samanaꞌ. ");
INSERT INTO row_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Rena rala boe ma, ruꞌa se lao hela dala, de reu tungga E. ");
INSERT INTO row_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Basa ma, Yesus laoꞌ nakandoo mbei fai, Ana mete-nita Sabadius ana nara. Aꞌa ka, nara na Yakobis, no odꞌi na Yohanis. Ruꞌa se ralole puꞌat sia ofaꞌ rala. ");
INSERT INTO row_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yesus noꞌe ruꞌa se nae, “Ima fo tungga Au.” De ruꞌa se lao hela sira papa na, no mana tulu-fali nara sia ofaꞌ ata. De ara reu tungga E. ");
INSERT INTO row_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Basa ma, Yesus no atahori kahaaꞌ ra, losa kambo Kapernaum. Losa atahori Yahudi fai hule-oꞌe na, Yesus nisiꞌ ume hule-oꞌe, de nanori mia naa. ");
INSERT INTO row_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Rena Eni oꞌola na, basa atahori ra ndii-ndiiꞌ a, huu Eni nahine tebꞌe nenoriꞌ naa isi na. Naa, fea no atahori Yahudi meser nara. ");
INSERT INTO row_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Leleꞌ naa, hambu atahori nitu taoꞌ a sia ume naa rala, nameli nae, ");
INSERT INTO row_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Woi! Yesus, atahori Nasaret! Mae tao saa mo hai? Uma mae tao mulutu hai, do? Hai mihine Ho. Ho ia, atahori fo dalahulu naa Lamatualain helu nae haitua nema. Ho ia, atahori nda ma salaꞌ sa.” ");
INSERT INTO row_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Te Yesus nae, “Soo bafa ma! Lao hela atahori naa!” ");
INSERT INTO row_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nitu ra tao atahori naa ao na ndundulea nahereꞌ, de lao hela e no randu nahereꞌ. ");
INSERT INTO row_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Basa atahori mana sia ume hule-oꞌe rala titindindii. De basa se ola-olaꞌ rae, “We! Ia, saa ia! Ana parenda nitu ra dea reu, boe ma ara tungga hihii Na. Ia nenori feuꞌ, do? Tou Lasiꞌ a oꞌola na, seli!” ");
INSERT INTO row_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Boe ma atahori akaꞌ dui-bꞌengga mia kamboꞌ nisiꞌ kamboꞌ sia propensi Galilea. ");
INSERT INTO row_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ara lao hela ume hule-oꞌe, de Yesus nisiꞌ Simon no Anderias umen. Yakobis no Yohanis reu ro se. ");
INSERT INTO row_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon ina ari na mera mafeo-matobꞌi, de ana sungguꞌ mia koi a. Yesus se masoꞌ ume na, boe ma atahori rema rafadꞌe rae, “Ina lasiꞌ a mera mafeo-matobꞌi.” ");
INSERT INTO row_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesus neu seꞌu ina lasiꞌ a, toꞌu lima na, de nafefela e. Memera na hai neuꞌ ena. Ina lasiꞌ a dea neu tao mataꞌ neu se. ");
INSERT INTO row_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Relo a loe-loe boe, atahori ra rendi atahori mamahedꞌi ra, ro atahori nitu taoꞌ ra. Ara risiꞌ Yesus roꞌe tulu-faliꞌ. ");
INSERT INTO row_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Losa basa kambo isiꞌ a, rema tesa sia ume mata na. ");
INSERT INTO row_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Hedꞌi nara mataꞌ-mataꞌ, te Yesus naꞌahahaiꞌ se. Ana o oi hendi nitu ra. Te Ana nda fee se kaꞌe rala fo olaꞌ sa, huu ara rahine Eni ena. ");
INSERT INTO row_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Mbila deka manggarelo, feꞌe maꞌahatuꞌ, Yesus fela lao nisiꞌ mamana rou esa, de ola-olaꞌ no Lamatualain. ");
INSERT INTO row_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon se fela, nda rita Yesus sa, de ara reu sangga E. ");
INSERT INTO row_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Randaa ro E, de rafadꞌe rae, “Papa, atahori naeꞌ sangga Papa.” ");
INSERT INTO row_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Te Ana nataa nae, “Naa malole. Te lao tisiꞌ kambo laen dei, mana deka ia, fo Au ae ufadꞌe Hara-lii Maloleꞌ neu se. Huu naa, Au uma.” ");
INSERT INTO row_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Basa boe, ara lao rereoꞌ propinsi Galilea, de Yesus dui-bꞌengga Hara-lii Maloleꞌ sia sira ume-ume hule-oꞌe na. Ma Ana oi hendi nitur mia atahori ra. ");
INSERT INTO row_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Leleꞌ naa, hambu atahori hedꞌi kusta esa, nema nisiꞌ Yesus. De ana sendeꞌ lululangga na noꞌe tulu-faliꞌ neu E nae, “Papa e! Tulu-fali au dei! Au bubꞌuluꞌ Papa bisa naꞌahahaiꞌ au hedꞌi ngga ia. Sadꞌi Papa nau.” ");
INSERT INTO row_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesus kasian atahori naa, de loo lima na toꞌu nala e, ma nae, “Memaꞌ, Au nau! Ho hai leon!” ");
INSERT INTO row_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Nggengger ma, atahori naa hedꞌi na mopo, de ana hai neuꞌ ena. ");
INSERT INTO row_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesus denu atahori naa baliꞌ, de nafadꞌe mbali e nae, ");
INSERT INTO row_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","‘Musunedꞌa matalolole! Ho hai ena, te afiꞌ mufadꞌe esa-esa boe! Musi tungga Baꞌi Musa parenda na dei. Misiꞌ malangga agama, fo ana paresaꞌ ao ma, fo seꞌu hedꞌi ma hai tebꞌe, do hokoꞌ. No musi fee tutunu-hohotuꞌ dadꞌi makasi, fo basa atahori ra bubꞌuluꞌ ho hai ena.” ");
INSERT INTO row_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Te atahori naa lao, ma neu dui sudꞌiꞌ a sia bee-bꞌee. Huu naa, atahori naeꞌ rae randaa ro Yesus, de ana naeꞌ a nda natudꞌu mata na sia kamboꞌ naa sa. Ana leo siaꞌ a mamana-mamana rou sia kambo deaꞌ. Te mia bee-bꞌee, atahori nonggo rema, rae randaa ro E. ");
INSERT INTO row_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Sodꞌaꞌ fai hira boe ma, Yesus se reu seluꞌ risiꞌ Kapernaum. De atahori ra rafadꞌe sia bee-bꞌee oi Ana sia ume ena. ");
INSERT INTO row_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Huu naa, atahori rema mia bee-bꞌee. Rakaseseti rakaseꞌe sia ume rala, losa dea boe. De Yesus nanori se Lamatualain hihii-nanau na. ");
INSERT INTO row_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ana feꞌe ola-olaꞌ boe ma, atahori haa ndoro rendi atahori mamaluꞌu esa nisiꞌ Yesus. ");
INSERT INTO row_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Te huu atahori nae na seli, de ara nda bisa rendi atahori naa losa mata na sa. De ara hene risiꞌ ume mbuni na, no ofe mbuni na nandaa no Yesus fafo na. Boe ma ara raondaꞌ e no nenei na. ");
INSERT INTO row_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nita se boe, nahine sira ramahere tebꞌe-tebꞌeꞌ neu Eni. Boe ma Ana nafadꞌe atahori mamaluꞌu nae, “Ana ngga e! Au fee ambon sala ma ena!” ");
INSERT INTO row_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Te sia naa, hambu atahori meser agama Yahudi hira nggua-nggua. Rena Yesus oꞌola na, ramedꞌa nda maloleꞌ sia rala nara sa. ");
INSERT INTO row_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","De ara olaꞌ rae, “Te atahori ia nambarani olaꞌ taꞌo naa! Akaꞌ Lamatualain bisa fee ambon neu atahori sala nara. Te atahori ia oꞌola na, sama onaꞌ Eni, Lamatualain. Ana naꞌamuti ma!” ");
INSERT INTO row_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Te Yesus bubꞌuluꞌ memaꞌ rala nara ena. De Ana olaꞌ nae, “Hei afiꞌ dꞌua taꞌo naa! ");
INSERT INTO row_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","10","Bee ka mudaꞌ lenaꞌ? Mete ma Au ufadꞌe mbali atahori mamaluꞌu ia ae, ‘Ho sala ma hambu ambon’, hei nda bubꞌuluꞌ dadꞌi taꞌo naa, do hokoꞌ. Te mete ma Au ufadꞌe ae, ‘Fela leon! Haꞌi ho nenei ma fo baliꞌ.’ Mete ma ana fela neuꞌ ena, hei feꞌe seꞌu-mita bukti mae Au uꞌena koasa fee ambon neu atahori sala nara. Huu, Au ia, tebꞌe-tebꞌe Atahori Matetuꞌ a.” Boe ma Ana nafadꞌe atahori mamaluꞌu naa nae, ");
INSERT INTO row_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Rena e! Ia naa ho hai ena! Fela, haꞌi nenei ma, fo baliꞌ leon.” ");
INSERT INTO row_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Rena taꞌo naa, nggengger ma ana fela. De haꞌi nenei na, lao dea neu. Atahori mana sia naa ra rita no mata nara. Basa se titindindii, de oi, “Awi! Hita feꞌe tita onaꞌ ia! Lamatualain memaꞌ mana seli!” ");
INSERT INTO row_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Basa ma, Yesus se reu seluꞌ risiꞌ dano Galilea suu na. Atahori naeꞌ rema sangga e, de nafadꞌe se Lamatualain hihii-nanaun. ");
INSERT INTO row_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Sa naa, atahori esa nara na Lewi, Alfeus ana na. Ue-tatao na edꞌa bea fee mana parenda. Yesus laoꞌ tungga naa, ma nita Lewi. De nafadꞌe nae, “Wei! Uma tungga Au!” Rena naꞌo naa boe, Lewi fela tungga E. ");
INSERT INTO row_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Basa boe, Yesus se endoꞌ raa mia Lewi ume na, ro nono mana edꞌa bea ra. Hambu atahori feaꞌ fo atahori Yahudi ra rae atahori nda maloleꞌ sa, raa ro sira. Atahori naa ra, naeꞌ hii rena Yesus. ");
INSERT INTO row_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Leleꞌ naa, meser agama mia partei Farisi hira, rita Yesus endoꞌ naa no mana edꞌa bea ra, ma atahori fo sira rae nda maloleꞌ ra sa. De ratane mana tungga nara rae, “Taꞌo bee de hei Meser ma endoꞌ naa no atahori mana edꞌa bea ra, ma atahori nda maloleꞌ naa ra sa?” ");
INSERT INTO row_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesus rena, boe ma nataa nae, “Atahori mamahedꞌiꞌ parlu doter, te atahori maloleꞌ ra hokoꞌ. Au uma tao mata neu atahori nda maloleꞌ ra sa. Te nda uma tao mata neu atahori mana namedꞌa ao na maloleꞌ sa. ");
INSERT INTO row_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Lao esa, atahori partei agama Farisi ra puasa. Ara rita Yohanis Mana Sarani a mana tungga nara o puasa. Te Yesus ana mana tungga nara nda puasa sa. Ara rema randaa ro Yesus de ratane rae, “Papa. Hai puasa. Yohanis atahori nara puasa boe. Te, taꞌo bee de Papa ana mana tungga mara nda puasa sa?” ");
INSERT INTO row_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesus nataa nae, “Hei bubꞌuluꞌ ena, mete ma fefeta kakabꞌi, fuiꞌ ra nda puasa sa, te raa raꞌabꞌeta. Mete ma touꞌ a feꞌe sia naa, basa se raa rabꞌue. ");
INSERT INTO row_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Te mete ma atahori feaꞌ lea rendi touꞌ a, nono nara susa, dei fo ara puasa.” ");
INSERT INTO row_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Boe, Yesus olaꞌ nekendandaaꞌ esa nae, “Atahori nda tanda teme feuꞌ neu badꞌu mbaraaꞌ sa. Te mete ma safe, teme feu a, kukundu tao nasideꞌ seluꞌ badꞌu mbaraaꞌ a. ");
INSERT INTO row_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Onaꞌ naa boe, atahori nda ombo tua feuꞌ neu mbaꞌo mbokoꞌ sa. Te mete ma mbaꞌo a fanggi, tuaꞌ a nandali hendi e. De tua feuꞌ musi ombo neu mbaꞌo feuꞌ.” Onaꞌ naa, Yesus nanori se nae Eni nenori na feuꞌ, de afiꞌ nebali no atahori Farisi ra nenori mbaraaꞌ na. ");
INSERT INTO row_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Lao esa, nandaa no atahori Yahudi fai hule-oꞌe na, Yesus se laoꞌ tungga osi. Boe ma mana tungga nara etu are gandum, de raa. ");
INSERT INTO row_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Te atahori Farisi ra mete-rita, de rafadꞌe Yesus rae, “Taꞌo bee de mana tungga mara langgar hita atoran agama na? Ara etu are gandum nandaa no fai hahae aoꞌ! Hei afiꞌ tao taꞌo naa!” ");
INSERT INTO row_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Nataa nae, “Taꞌo bee o? Hei nda misinedꞌa Baꞌi Daud dudꞌui na sa. Leleꞌ naa tou lasi Abiatar dadꞌi sira malangga agama na. Baꞌi Daud no mana tungga nara ndoe rala seli. Boe ma ara risiꞌ Lamatualain lalaa hule-oꞌe na rala, de haꞌi roti fo malangga agama ra fee basa neu Lamatuaꞌ. Tao-tao te akaꞌ a malangga agama ra bole raa, te atahori feaꞌ ra hokoꞌ. Te Baꞌi Daud se raa, nda hambu atahori fee salaꞌ neu se sa.” ");
INSERT INTO row_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesus nafadꞌe seluꞌ nae, “Lamatualain tao fai hahae aoꞌ fo tulu-fali hita atahori a. Te Ana nda tao hita atahori fo tungga fai hahae aoꞌ a atoran na sa. ");
INSERT INTO row_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Au ia, tebꞌe-tebꞌe Atahori Matetuꞌ a. Au uꞌena hak fo ae atahori bole, do nda bole tao saa-saa nandaa no fai hahae aoꞌ sa.” ");
INSERT INTO row_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Basa naa boe, Yesus se baliꞌ risiꞌ ume hule-oꞌe. Sa naa Ana nita atahori esa lima na seri maꞌamateꞌ. ");
INSERT INTO row_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Sa naa o hambu atahori hira mana sangga-sangga dalaꞌ fo fee salaꞌ neu Yesus. De ara memeteꞌ, fo rae rahine Ana nae naꞌahahaiꞌ atahori nandaa no fai hahae aoꞌ, do hokoꞌ. ");
INSERT INTO row_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesus noꞌe atahori naa nae, “Uma misiꞌ ia.” ");
INSERT INTO row_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Boe ma natane basa atahori naa ra nae, “Tungga hita atoran agama na, saa fo hita bole tao nandaa no fai hahae aoꞌ? Hita tao maloleꞌ, do afiꞌ? Hita tao tahaiꞌ atahori, do tao tisa e?” Te basa se neneeꞌ a. ");
INSERT INTO row_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Boe ma Yesus namanasa no rala na susa nala seli, huu sira tao fadꞌuli lenaꞌ neu sira atoran na, te nda tao fadꞌuli neu atahori fo lima maꞌamateꞌ seseriꞌ naa sa. De Ana nakarereluk seꞌu rereoꞌ se, ma nafadꞌe atahori naa nae, “Loo lima ma!” Atahori naa loo lima na, nggengger ma, lima na hai. ");
INSERT INTO row_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","De atahori Farisi ra lao hela ume hule-oꞌe naa. Ara raꞌabꞌue ro atahori partei Herodes ra, fo sangga dalaꞌ rae risa Yesus. ");
INSERT INTO row_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Lao esa, Yesus no mana tungga nara dinggoꞌ risiꞌ dano Galilea suu na. Atahori naeꞌ rena basa saa fo Eni tao, de rema mia bee-bꞌee. Atahori naa ra rema mia propensi Galilea, Yudea, Idumea, kota Yerusalem, Sidꞌon, Tirus, boe ma loe Yordan bobꞌoa rulu na. Basa se rae randaa ro E. ");
INSERT INTO row_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Huu atahori nara naeꞌ, Yesus denu mana tungga nara fo sadꞌia fee ofaꞌ esa. Ana nae olaꞌ sia ofaꞌ ata, fo basa se hambu rena, ma afiꞌ rakaseseti ro E. ");
INSERT INTO row_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Feꞌe saꞌ a naa, Eni naꞌahahaiꞌ atahori hedꞌis naeꞌ. Naa de, ia naa basa atahori hedꞌis ra rema rakaseseti rae nggama Eni. ");
INSERT INTO row_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Atahori nitu masoꞌ ra rita E, boe ma raꞌaloli mia mata na. Basa ma, rataa rae, “Ho ia memaꞌ Lamatualain Ana na.” ");
INSERT INTO row_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Te Ana naꞌangge nahereꞌ neu se nae, “Hei afiꞌ mifadꞌe atahori mae Au ia, seka!” ");
INSERT INTO row_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Basa ma Yesus hene nisiꞌ leteꞌ esa ata. Ana noꞌe nala atahori hira ndaa no rala na. Boe ma ara rema risiꞌ Eni. ");
INSERT INTO row_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ana tengga nala atahori sanahulu rua, ma nafadꞌe se nae, “Hei tungga Au, mi dui-bꞌengga Lamatualain Dudꞌui Malole na neu basa atahori. ");
INSERT INTO row_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Au fee koasa neu hei, fo oi nitu mia atahori ra.” ");
INSERT INTO row_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Atahori naa ra, nara-nara onaꞌ ia: Simon (fo Yesus babꞌae nara na Petrus), Yakobis Yohanis, (Yakobis no odꞌi na Yohanis ia, ruꞌa se, Sabadius ana na. Yesus babꞌae ruꞌa se nara na ‘Boanerges’, sosoa na ‘onaꞌ ndukurulu.’) Anderias, Felipus, Bartolomeos, Mateos, Tomas, Yakobis (Alpius ana na), Tadius, Simon (mana tungga partei poletik Selot), no Yudꞌas Iskariot (eni mana seo Yesus). ");
INSERT INTO row_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Basa naa ma, Yesus no mana tungga nara onda baliꞌ mia leteꞌ a. De Yesus no mana tungga nara ume rala reu, atahori naeꞌ rema heo rala se, losa nda kaꞌe raa sa. ");
INSERT INTO row_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Rita taꞌo naa boe, atahori rae, “Mita dei! Ana liliꞌ fadꞌuli ao na.” Bꞌobꞌonggi nara rena atahori olaꞌ taꞌo naa, de rae ro baliꞌ E. ");
INSERT INTO row_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Leleꞌ naa meser agama ra mia Yerusalem rema rafadꞌe atahori sia naa rae, “We! Hei afiꞌ tungga-tunggaꞌ Yesus. Ana oi nitu ra taꞌo na, huu hambu koasa mia malangga nitu ra, fo rae Baalsebul.” ");
INSERT INTO row_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesus rena taꞌo naa boe, noꞌe basa se de nafadꞌe nae, “Nda masoꞌ dudꞌuꞌat sa! Taꞌo bee de malangga nitu ra oi baliꞌ mana tungga nara! ");
INSERT INTO row_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mete ma sia nusaꞌ esa, manggarau nara ramusuꞌ na, malangga nda hambu saa sa boe! ");
INSERT INTO row_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Do, mete ma ume isiꞌ esa rarau aoꞌ na, ara sea-sarangganggaa! ");
INSERT INTO row_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Onaꞌ naa boe, nitu ra esa musu esa na, ara sea-sarangganggaa, ma rambalulutu! ");
INSERT INTO row_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Musenedꞌa! Mete ma atahori esa nae nema namanaꞌo buas sia maꞌadereꞌ esa ume na, ana musi paꞌa mates atahori naa dei. Dei fo ana namanaꞌo. ");
INSERT INTO row_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","De Au ufadꞌe hei: Lamatualain nau fee ambon neu atahori sala nara. Mete ma atahori sa naꞌamuti atahori laen, Lamatualain feꞌe fee ambon sala na. ");
INSERT INTO row_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Te mete ma atahori sa naꞌamuti Dula-Dale Meumareꞌ a, Lamatualain nda fee ambon neu sala na sa, losa rae-fafoꞌ a noe!” ");
INSERT INTO row_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesus naꞌo naa, huu ara fee salaꞌ neu E rae, “Nitu ra dai E!” ");
INSERT INTO row_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Basa ma, Yesus mama na no odꞌi nara risiꞌ ume naa, rae randaa ro E. Sa naa rambariiꞌ siaꞌ a ume deaꞌ, de denu atahori reu roꞌe. ");
INSERT INTO row_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Leleꞌ naa, Yesus nggua-nggua olaꞌ no atahori naeꞌ. Ma atahori rema rafadꞌe rae, “Papa! Papa mama na no odꞌi mara sia deaꞌ. Ara rae randaa ro Papa.” ");
INSERT INTO row_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Boe ma Yesus nataa nae, “Au mama ngga no toronoo nggara seka?” ");
INSERT INTO row_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Basa ma Ana mete atahori mana endoꞌ rereoꞌ E. De olaꞌ nae, “Basa hei, Au mama ngga no toronoo nggara. ");
INSERT INTO row_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Huu atahori mana tungga Lamatualain hihii-nanau na, sira tebꞌe-tebꞌeꞌ Au bobꞌonggi nggara.” ");
INSERT INTO row_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Lao esa, Yesus se reu seluꞌ sia dano Galilea. Atahori naeꞌ rema heo rala E. Basa ma Ana hene neu endoꞌ nisiꞌ ofaꞌ sa ata mana nafuꞌ sia naa, de nanori. Basa atahori mana sia madꞌaꞌ ata ra, rena E. ");
INSERT INTO row_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ana nanori naeꞌ neu se nendiꞌ nekendandaaꞌ nae, ");
INSERT INTO row_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Rena matalolole! Atahori sa neu nggari fini sia osi na. ");
INSERT INTO row_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Fini naa ra, ruma tudꞌa sia dala ata. De mbuiꞌ ra rema bito hendi basa fini ra. ");
INSERT INTO row_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Fini ruma tudꞌa sia rae fatu-fatuꞌ. Ara mori halalai, te huu rae a niꞌis, ");
INSERT INTO row_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","relo a botiꞌ boe, numbuꞌ naa ra male meto hendi se. Huu oka nara nda masoꞌ losa rala sa. ");
INSERT INTO row_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Fini ruma tudꞌa sia unu hau anaꞌ. Boe ma unu hau anaꞌ a hapi nisa numbuꞌ naa ra, de nda bisa mori sa. ");
INSERT INTO row_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Fini ruma tudꞌa sia rae isiꞌ a. De ranumbu, raꞌamoko, rabuna, no rabꞌoa. Ruma rabꞌoa telu nulu, ruma nee nulu, ma ruma losa natun esa. ");
INSERT INTO row_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Se mandikiꞌ, rena matalolole!’ ");
INSERT INTO row_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Leleꞌ Yesus mesaꞌ ne, mana tungga kasanahulu ruaꞌ ra, ro atahori laen baꞌubꞌe mana rena basa Eni nenori na, ara rema randaa ro E. Ara roꞌe Eni nafadꞌe nekendandaaꞌ naa sosoa na. ");
INSERT INTO row_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Boe ma Yesus nataa nae, ‘Huu hei mae mihine tebꞌe-tebꞌeꞌ Lamatualain parenda na, de Au ufadꞌe memaꞌ nekendandaaꞌ naa sosoa na. Te mete ma atahori laen naa, Au unori noꞌ a nekendandaaꞌ. ");
INSERT INTO row_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Te mia dalahulu na Lamatualain mana dui-bꞌengga nara suraꞌ hela atahori naa ra hadꞌaꞌ nara rae, ‘Sira rita ena, te nda nau rahine sa. Sira rena ena, te nda nau bubꞌuluꞌ sa. Hela fo afiꞌ ramahere Lamatualain, fo Lamatualain afiꞌ parlu fee ambon neu sala nara.” ");
INSERT INTO row_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Basa naa boe, Yesus nafadꞌe se nekendandaaꞌ naa sosoa na nae, “Wei! Mete ma hei nda feꞌe mihine nekendandaaꞌ ia sosoa na sa, taꞌo bee fo hei bisa mihine nekendandaaꞌ laen sosoa na? ");
INSERT INTO row_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","De eni sosoa na, taꞌo ia: Atahori mana nggari fini naa, eni onaꞌ a atahori mana dui-bꞌengga Lamatualain Hara-lii na. ");
INSERT INTO row_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Fini mana tudꞌa sia dalaꞌ ata losa mbuiꞌ ra bito hendi, onaꞌ atahori mana rena Lamatualain hara-lii na. Te nda doo saꞌ ma, malanga nitu ra nema de haꞌi nendi hara-lii naa mia atahori naa rala na. ");
INSERT INTO row_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Fini mana tudꞌa sia rae fafatuꞌ naa, onaꞌ atahori mana rena ma simbo nala hara-lii naa no rala nemehoꞌot. ");
INSERT INTO row_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Te hara-lii naa nda naꞌoka sa. Naa de ana nda nenembedꞌa dooꞌ sia atahori rala na sa. Mete ma atahori laen naꞌasususaꞌ e, ana mboꞌi hendi e neuꞌ ena. ");
INSERT INTO row_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Fini mana tudꞌa sia unu hau anaꞌ a, onaꞌ atahori mana rena nala hara-lii naa. ");
INSERT INTO row_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Te ana akaꞌ tasibꞌu no tataos mataꞌ-mataꞌ, fo namasuꞌi. Tataos naa ra seti hendi hara-lii mia rala na, de nda nendi papakeꞌ sa. ");
INSERT INTO row_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Fini mana tudꞌa sia rae isiꞌ a, onaꞌ a atahori mana rena no simbo nala hara-lii naa, ma tungga Lamatuaꞌ hihii na. Ana tao saa-saa akaꞌ maloleꞌ, onaꞌ a fini mana maboaꞌ. Hambu ruma boaꞌ telunulu, ruma neenulu, ma ruma losa natun esa.” ");
INSERT INTO row_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesus olaꞌ nakandoo mia ofaꞌ ata. Ana fee seluꞌ nekendandaaꞌ esa nae, “Taꞌo bee! Atahori pake lambu, basa ma tatana sia boa rala? Do mbedꞌa e sia mamana susungguꞌ a raeꞌ? Hokoꞌ, to? Mete ma tao taꞌo naa, nda manggareloꞌ saꞌ ena. Atahori musi tao lambu neu mamana naruꞌ fo manggareloꞌ. ");
INSERT INTO row_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","De saa fo maꞌafuniꞌ aleꞌ ia, dei fo nene nitaꞌ. Saa fo atahori nda rahine aleꞌ ia sa, dei fo rahine. ");
INSERT INTO row_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Seka mandikiꞌ, rena matalolole.” ");
INSERT INTO row_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Basa ma Ana olaꞌ seluꞌ nae, “Dꞌua matalolole Au nenori ngga ia! Mete ma hei uku atahori laen tatao na, atahori o uku hei tataꞌo ma onaꞌ naa boe. Lamatualain o uku hei tatao ma boe. Te Eni uꞌuku na, bera na lenaꞌ. ");
INSERT INTO row_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Atahori mana rae sangga Lamatualain hihii-nanau na, ana tamba mahine. Te atahori mana nda nau fadꞌuli Lamatualain hihii-nanau na sa, ana tamba namanggoa. ");
INSERT INTO row_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Basa naa ma Yesus olaꞌ seluꞌ nae, “Lamatualain nusaꞌ-namo na onaꞌ a fini fo atahori nggari sia osi na. ");
INSERT INTO row_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Mae atahori naa baliꞌ, sungguꞌ-fela, nda nasanedꞌa fini naa sa ena, te fini naa nanumbu ma naꞌamoko nakandooꞌ a. ");
INSERT INTO row_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Fini naa nasodꞌa ao na sia rae a, de nadana, nabuna, losa naisi. ");
INSERT INTO row_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Mete ma namatasa na, tenu osiꞌ a nahineꞌ a nema oruꞌ. Lamatualain nusaꞌ-namo na onaꞌ a naa boe. Basa naa ra, Lamatualain mana tao, nda atahori mana tao sa.” ");
INSERT INTO row_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Basa naa ma, Yesus olaꞌ seluꞌ nae, “Au fee seluꞌ nekendandaaꞌ esa fo hei mihine Lamatualain atahori nara. Fefeu na hidꞌaꞌ a, te bau dooꞌ, sira bau ramaheta. ");
INSERT INTO row_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Fefeu na, sira onaꞌ a deke anahikiꞌ. ");
INSERT INTO row_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Mete ma sela tala e naa, ana nasodꞌa dadꞌi hau huu ineꞌ. Mbui ra rema sangga mafoꞌ fo randuna sia ataꞌ.” ");
INSERT INTO row_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Taꞌo naa Yesus nanori se, nandaa no sisimbo nara. ");
INSERT INTO row_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Mete ma nanori atahori naeꞌ, ana pakeꞌ a nekendandaaꞌ. Te mete ma no mana tungga nara, Ana nafadꞌe nekendandaaꞌ no sosoa na. ");
INSERT INTO row_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Bobꞌo naa, Yesus feꞌe sia ofaꞌ ataꞌ. De Ana noꞌe mana tungga nara nae, “Ima tisiꞌ seriꞌ naa.” ");
INSERT INTO row_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Basa ma ara sae ofaꞌ ro Yesus. De ara lea laa lao hela atahori ra sia naa. Te ruma sae tungga ofaꞌ laen. ");
INSERT INTO row_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","Faiꞌ naa, Yesus sungguꞌ nasambeta ndae langga na neu ainulu a mia ofaꞌ deaꞌ. Nda dooꞌ saꞌ boe, sanggu anin losa. Ree ra poꞌa oe a masoꞌ nisiꞌ ofaꞌ rala, losa naeꞌ a sofe. De mana tungga nara ramatau. Ara fafae rae, “Papa! Fela dei! Hita tae molo ena! Papa nda nau hita tasodꞌa sa, do?” ");
INSERT INTO row_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ana fela de ai anin naa nae, “Muloeꞌ!” Ana o parenda dano a nae, “Muꞌumate leon!” Anin naa naloeꞌ ma dano a naꞌamate neuꞌ ena. ");
INSERT INTO row_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Basa ma Yesus natane se nae, “Saa de hei mimitau? Hei nda mimihere Au sa, do?” ");
INSERT INTO row_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Basa se ramatau ma titindindii, de olaꞌ rae, “Ia, seka e? Losa anin no ree ra rena E!” ");
INSERT INTO row_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Basa naa ma, Yesus no mana tungga nara losa dano Galilea seriꞌ, sia mamanaꞌ esa nara na Gerasa. ");
INSERT INTO row_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","6","Sa naa hambu atahori touꞌ esa, nitu ra tao e losa namulu. Ana leo sia rates ra. Hatuꞌ-rerelon ana koo-koo rereoꞌ mbuku-mbukuꞌ sa naa ra no maꞌaholaꞌ. Nameli nakandooꞌ a. Ana tutu tao nabisuꞌ ao na no fatu. Huu maꞌadere na seli, naa de nda hambu atahori bisa paꞌa nala e sa, mae no rante besi. Atahori ra paꞌa rasafafali ei-lima nara no rante besi, te naꞌetuꞌ rante a. Yesus se rae onda mia ofa a boe, atahori muluꞌ naa mete-nita se ma dꞌooꞌ-dꞌooꞌ. Ana kalua mia rates, nela nisiꞌ Yesus, de sendeꞌ lululangga na neu mata Na. ");
INSERT INTO row_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Yesus mete-nita e boe, Ana olaꞌ nae “Woi! Nitu deꞌulakaꞌ! Lao hela atahori ia!” Basa ma, atahori naa randu nahereꞌ nae, “Woi! Ho mae tao saa mbali au! Au bubꞌuluꞌ Ho ia, Yesus, Lamatualain fo mana koasa Ana na. Au oꞌe fo Ho nda tao doidꞌoso neu au sa!” ");
INSERT INTO row_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Boe ma Yesus natane mbali e oi, “Ho nara ma, seka?” Atahori naa nataa nae, “Au nara ngga Legion, sosoa na hetar, huu hai nitu naeꞌ seli!” ");
INSERT INTO row_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Basa ma nitu ra pake atahori naa fo noꞌe Yesus afiꞌ denu sira lao hela nusaꞌ naa. ");
INSERT INTO row_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Deka mia naa, hambu atahori ranea fafi lalaet esa. Mbei ma fafi rifon rua. Ara sosoꞌa sia mbukuꞌ a suu na. ");
INSERT INTO row_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nitu ra roꞌe Yesus oi, “Denu hai fo masoꞌ misiꞌ fafi naa ra. ");
INSERT INTO row_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Rena taꞌo naa, Yesus nau. Nitu naa ra, rela lao hela atahori naa risiꞌ fafi ra. Fafi rifon rua naa ra, onda leli mia mbuku suu na, risiꞌ dano rala. De basa se mate, tena sia naa. ");
INSERT INTO row_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Rita taꞌo na boe, atahori mana ranea fafi ra, relaꞌ reu rafadꞌe rereoꞌ basa atahori sia kambo-kamboꞌ ra. Atahori naeꞌ rema nau rita saa mana dadꞌiꞌ naa. ");
INSERT INTO row_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ara rema randaa ro Yesus, ma rita atahori nitu taoꞌ a endoꞌ sia naa. Eni dudꞌuꞌa na malole baliꞌ, no pake baliꞌ bua-baꞌus ena. Rita taꞌo naa boe, atahori naa ra basa se ramatau, huu ara rahine mana oi hendi nitu ra mia atahori naa, memaꞌ mana seli. ");
INSERT INTO row_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Atahori mana rita no mata nara dui atahori muluꞌ naa hahai na, ma fafi mana mate tena hendiꞌ ra. ");
INSERT INTO row_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Boe ma atahori kambo-kamboꞌ naa ra rema roꞌe fo Yesus lao hela sira mamana na. ");
INSERT INTO row_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesus nae hene nisiꞌ ofaꞌ ataꞌ, boe ma atahori nitu taoꞌ a nema, nae “Papa e, fee au tungga boe. ");
INSERT INTO row_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Te Yesus nda nau sa. Ana nafadꞌe nae, “Malole lenaꞌ ho baliꞌ fo mufadꞌe basa bobꞌonggi mara saa fo Lamatualain tao fee ho ena. Muu mufadꞌe mae Lamatualain sue ho.” ");
INSERT INTO row_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Basa ma, atahori naa baliꞌ de neu rereoꞌ nusaꞌ esa no kamboꞌ sanahulu fo sira roꞌe rae ‘Dekapolis’. Eni dui saa fo Yesus tao basa neu e. Basa atahori mana rena dudꞌuit naa, ara titindindii. ");
INSERT INTO row_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Basa ma, Yesus se lea laa baliꞌ risiꞌ dano a seriꞌ. Ara onda mia ofaꞌ, atahori naeꞌ rema heo rala E. ");
INSERT INTO row_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Sa naa atahori sa, nara na Yairus. Eni malangga ume hule-oꞌe sia nusaꞌ naa. Ana nita Yesus, ma sendeꞌ lululangga na neu mata na, ");
INSERT INTO row_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","de noꞌe nae, “Papa! Au ana feto ngga feꞌe too sanahulu rua, mera nae a mate. Papa tulun nema fo muꞌuhahaiꞌ e dei.” ");
INSERT INTO row_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Boe ma Yesus tungga Yairus, de nisiꞌ ume na. Ara lao boe ma, atahori naeꞌ tungga Eni losa rakaseseti dii-onaꞌ. ");
INSERT INTO row_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Sia atahori naa ra taladꞌan na, inaꞌ esa hambu fulan na nda nateꞌe malole sa losa too sanahulu rua. ");
INSERT INTO row_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ana fee basa doi na no hata-heto na fo bae neu dokter ra. Te nda hambu esa naꞌahahaiꞌ nala e sa. Hedꞌi na foe nakandooꞌ a. ");
INSERT INTO row_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","29","Inaꞌ naa rena dudꞌuit naeꞌ soꞌal Yesus. De ana sususi sia atahori naeꞌ taladꞌan naa, fo nae deka-deka Yesus dea na. Ana dꞌua nae, “Sadꞌi au kois badꞌu na, au hai!” Ana kois badꞌu na boe, nggengger ma, hedꞌi na naloeꞌ ena. Ana medꞌa, eni hai tebꞌe ena. ");
INSERT INTO row_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nandaa no leleꞌ naa, Yesus medꞌa koasa kalua mia E. Ana heoꞌ deaꞌ de seꞌu atahori naa ra. Ana natane nae, “Seka kois Au badꞌu ngga?” ");
INSERT INTO row_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Mana tungga nara rataa rae, “Papa seꞌu neuꞌ ena. Atahori naeꞌ rakaseseti basa ia naa. Papa feꞌe mutane mae, ‘Seka kois badꞌu ma?’” ");
INSERT INTO row_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Te Yesus mete rereoꞌ, fo nae sangga tiro, seka kois Eni. ");
INSERT INTO row_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Rena Yesus natane taꞌo naa boe, inaꞌ naa namatau seli. Ana sendeꞌ lululangga na neu mata na, de nataa nae, “Papa! Au mana kois Papa badꞌu na.” ");
INSERT INTO row_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ana nataa e oi, “Huu mama namahere tebꞌe-tebꞌeꞌ Au, naa de mama hai ena. Ia naa, mama baliꞌ no nemehoꞌot ena.” ");
INSERT INTO row_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ana feꞌe ola-olaꞌ taꞌo naa, atahori sa nema mia Yairus ume na, de nafadꞌe nae, “Kasian! Anaꞌ a mate ena. De onaꞌ neꞌe-bebꞌenggeꞌ Papa Meser fali. Afiꞌ neu fali.” ");
INSERT INTO row_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Te Yesus nda fadꞌuli atahori naa oꞌola na sa. Nafadꞌe Yairus nae, “Ho onaꞌ mumutau! Mumuhere neu a Lamatuaꞌ.” ");
INSERT INTO row_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Boe ma Yesus lao hela mana tungga laen nara. Ana no Petrus, Yakobis no odꞌi na Yohanis, de ara lao rakandoo. ");
INSERT INTO row_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Losa Yairus ume na, ara rita atahori naeꞌ selu-sole ma rena se nggae ei-ei. ");
INSERT INTO row_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yesus masoꞌ rala neu, de natane mbali se nae, “Saa de hei nggae taꞌo ia? Anaꞌ ia nda mate sa. Ana sungguꞌ a.” ");
INSERT INTO row_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ara rena E, ma basa se mali. Te Ana denu basa se dea reu. Ana noꞌe anaꞌ na papa na no mama na, no mana tungga nara atahori telu, de ara risiꞌ ana a kama na. ");
INSERT INTO row_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yesus toꞌu anaꞌ lima na, ma olaꞌ dedꞌea Aram nae, “Talitakum”! Sosoa na nae, “Anaꞌ fetoꞌ! Fela leon!” ");
INSERT INTO row_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","43","Nggengger ma, ana fetoꞌ naa fela, de laoꞌ. Yesus denu mama na nae, “Fee ne naa leon!” Basa atahori mana rita mana dꞌadꞌiꞌ naa, ara titindindii. Te Yesus ira se nae, “Afiꞌ mifadꞌe see-see mae Au tao usodꞌa baliꞌ e!” ");
INSERT INTO row_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Basa ma, Yesus no mana tungga nara baliꞌ risiꞌ Eni kambo Nasaret na. ");
INSERT INTO row_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Basa ma, nandaa no atahori Yahudi fai hule-oꞌe na, Yesus nisiꞌ ume hule-oꞌe, de nanori. Faiꞌ naa atahori naeꞌ reu hule-oꞌe. Rena nenori na, ara titindindii, de rae, “Atahori ia mahine na dei! Eni o naꞌena koasa! Saa de Ana tao taꞌo naa? ");
INSERT INTO row_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Eni akaꞌ a tukan hau. Hita tahine mama na Maria; no odꞌi nara, Yakobis, Yoses, Yudꞌas ma Simon. Eni ma fetoꞌ boe. Hita kamboꞌ esa na!” Naa de, rala nara mera ma nda nau rena E sa. ");
INSERT INTO row_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Te Yesus nafadꞌe nae, “Memaꞌ tebꞌe! Sia kamboꞌ laen, atahori fee hadat neu Lamatualain dedenu na lenaꞌ sia sira kambo na.” ");
INSERT INTO row_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6a","Te atahori naa ra rala manggatee na seli, de nda nau ramahere Yesus sa. Naa de, Ana titindindii ma nda pake koasa na sia naa sa. Ana naꞌahahaiꞌ akaꞌ a atahori esa-ruaꞌ a. ");
INSERT INTO row_vpl VALUES ("MK6_6b","071_6_6b","MRK","6","6b","6b","Basa ma, Yesus laoꞌ ndule kambo mana dekaꞌ ra, fo nanori Lamatualain hihii-nanau na. ");
INSERT INTO row_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ana noꞌe mana tungga nara sanahulu rua de denu se laoꞌ rua-ruaꞌ reu bengga Lamatualain Hara-lii Malole na. Ana o fee se koasa fo oi nitu ra. ");
INSERT INTO row_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Ana parenda se nae, “Afiꞌ mendi nae-nae sia dalaꞌ a. Onaꞌ mendi lepa-ngges, doiꞌ ma kapiꞌ. Pake a buas, laopei, ma mendi teteas. ");
INSERT INTO row_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Mete ma atahori simbo hei sia ume na, hei musi leo sia naa losa hei lao. ");
INSERT INTO row_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Te mete ma losa mamanaꞌ esa, atahori naa ra nda simbo sa, ma nda rena hei sa, lao hela naa. Boe ma mifadꞌe se mae, “Hei nda nau rena sa, de lemba-misaa ao mara!” ");
INSERT INTO row_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Basa ma, reu bengga Hara-lii Maloleꞌ a, neu atahori ra rae, ara musi doaꞌ tao salaꞌ. ");
INSERT INTO row_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Mana tungga nara o oi nitu ra, ma tao mina neu atahori hedꞌis langga nara, de raꞌahahai se. ");
INSERT INTO row_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Leleꞌ naa, atahori rahine Yesus sia bee-bꞌee. Dudꞌuit koasa na, Mane Herodes o rena boe. Hambu atahori rae, “Yohanis Mana Sarani a, nasodꞌa baliꞌ sia Yesus ao na! Naa de, Ana tao mana dadꞌi naa ra.” ");
INSERT INTO row_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Te atahori ruma rae, “Hokoꞌ! Yesus ia, Elia nasodꞌa baliꞌ sia ao na. Do Lamatualain mana dui-bꞌengga nara ruma mia doo na neu.” ");
INSERT INTO row_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Mane Herodes rena ara olaꞌ taꞌo naa boe, nataa nae, “Ia, Yohanis Mana Sarani fo au denu nggero rala langga na. Ia naa nasodꞌa baliꞌ ena!” ");
INSERT INTO row_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Mane Herodes denu taꞌo naa, huu nadꞌedꞌea no Yohanis. Dudꞌui naa taꞌo ia: Mane Herodes nae sao nala odꞌi na Filipus sao na, nara na Herodias. Te huu Filipus no Herodias nda feꞌe mahelaꞌ sa. Naa de, Yohanis ai nasafafali nae, “Papa Maneꞌ afiꞌ sao mala odꞌi ma sao na. Te sala no hita adat Yahudi na!” Te onaꞌ o Herodes sao nala e. Basa ma, ana denu humu Yohanis de tao bui rala neu. ");
INSERT INTO row_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Yohanis ai nasafafali, naa de inaꞌ a nambedꞌa ralaꞌ ma nae tao nisa e. Te nda feꞌe kaꞌe nala sa, huu Herodes tao e sia bui rala, ");
INSERT INTO row_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ma denu soldꞌadꞌu ra ranea rahereꞌ e. Memaꞌ Herodes hia Yohanis, ma nahine nae eni Lamatualain dedenu na. Eni o atahori maloleꞌ. Herodes hii rena Yohanis oꞌola na, te lao-lao esa naa, ana rasa nda malole saꞌ boe. ");
INSERT INTO row_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Faiꞌ esa, ina Herodias kaꞌe nala fo balas rala mera na. Faiꞌ naa, ara tao Mane Herodes fai bobꞌonggi na. Roꞌe malangga ra rema boe. Mana nemaꞌ ra, mana parenda ra, malangga soldꞌadꞌu ra, ro lasi adat Galilea raꞌ. ");
INSERT INTO row_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Sia fefetas naa taladꞌa na, ina Herodias ana feto na lendo. Lelendo na, meulau na seli, tao namahoꞌo Herodes no fuiꞌ ra. Herodes noꞌe nala e, de nafadꞌe nae, “Mae moꞌe saa na, mufadꞌe leo! Te au fee. ");
INSERT INTO row_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Mae moꞌe banggi rua nusaꞌ ia o, au fee. Au sumba endiꞌ Lamatualain nara Na!” ");
INSERT INTO row_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Basa naa, ana feto naa neu natane mama na nae, “Mama! Au oꞌe saa sia papa?” Mama na nataa nae, “Naaa! Moꞌe Yohanis langga na.” ");
INSERT INTO row_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ana feto na, neu de nae, “Papa! Au oꞌe Yohanis langga na, tao sia dulang rala, fo mendi fee au oras ia!” ");
INSERT INTO row_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mane Herodes rena ma fale rala na. Ana nda bisa lea baliꞌ susumba na sa, huu atahori rena ena. ");
INSERT INTO row_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","De ana parenda malangga soldꞌadꞌu a neu nggero Yohanis langga na mia bui rala. ");
INSERT INTO row_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ara nggero rala Yohanis langga na, ma tao neu dulang rala, de fee neu ana fetoꞌ naa. Simbo nala dulang boe, ana oꞌo nendi fee neu mama na. ");
INSERT INTO row_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Yohanis mana tungga nara rena boe ma, reu oꞌo rendi ao sisi na, de raꞌoi e. Baꞌu naa, Yohanis mamate na, dudꞌuit na. ");
INSERT INTO row_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Lao esa, mana tungga naa ra baliꞌ reu ro Yesus. Rafadꞌe saa fo sira tao ma ranori. ");
INSERT INTO row_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Leleꞌ naa, atahori naeꞌ reu-rema sangga Yesus. Naa de, Ana no mana tungga nara nda raa rala sa. De nafadꞌe se nae, “Ima teu sangga mamana rouꞌ, fo hita hahae tala mbei dei.” ");
INSERT INTO row_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","De basa se risiꞌ ofaꞌ rala, reu sangga mamana rouꞌ. ");
INSERT INTO row_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Te atahori naeꞌ naa ra rita Yesus se ofa na, de reu tungga dano a suu na. Ara lao hela kamboꞌ tungga dala madꞌaꞌ ata, de losa raꞌahuluꞌ Yesus se. ");
INSERT INTO row_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesus onda mia ofaꞌ, nita atahori naeꞌ rahani Eni ena. Ana tudꞌa kasian se, huu sira nda ritaꞌ rae tao saa saꞌ boe, onaꞌ bibꞌi lombo nda raꞌena manatadꞌa sa. De nanori se Lamatualain hihii-nanau na ");
INSERT INTO row_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","mia fefetun losa bobꞌoꞌ. Mana tungga nara rafadꞌe rae, “Papa! Malole lenaꞌ denu atahori ia ra reu hasa nanaat sia kambo mana deka ia ra. Bꞌobꞌoꞌ ena te nanaat nese.” ");
INSERT INTO row_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yesus nataa nae “Afiꞌ! Hei fee se nanaat.” Te ratane baliꞌ rae, “Awe! Mete ma hai mihao atahori ia ra, hai musi pake doiꞌ nae na seli. Baꞌu atahori sa nggadi na fula falu! Mabꞌee hai hambu doiꞌ baꞌu naa?” ");
INSERT INTO row_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Te Yesus nataa nae, “Mitane se mae, mendi lepa-ngges boe.” Reu ratane, de baliꞌ rafadꞌe rae, “Hambu roti bueꞌ lima, no uꞌu rua.” ");
INSERT INTO row_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Basa ma Yesus denu basa atahori naa ra endoꞌ raꞌabꞌubꞌue sia uru ata. ");
INSERT INTO row_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ara reu endoꞌ raꞌabꞌue. De hambu atahori natun-natun, ma ruma lima nulu-lima nulu. ");
INSERT INTO row_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yesus haꞌi nala roti kalimaꞌ, ma uꞌu karuaꞌ ra. Ana oroꞌa noꞌe makasi mbali Lamatualain. Basa ma, Ana bibꞌibꞌi roti naa ra, de soro fee mana tungga nara, denu se reu banggi fee atahori ra. Uꞌu karuaꞌ ra o, banggi fee se boe. ");
INSERT INTO row_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Basa se raa raꞌabꞌeta. ");
INSERT INTO row_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Basa boe, mana tungga nara radꞌuru nanaa lenaꞌ ra, sofe boa sanahulu rua. ");
INSERT INTO row_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Mbeima sira atahori rifon lima. Naa akaꞌ a touꞌ mana naaꞌ ra. Nda feꞌe ingga inaꞌ ra ro anahikiꞌ ra sa. ");
INSERT INTO row_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Basa naa ma, Yesus denu mana tungga nara sae ofaꞌ raꞌahuluꞌ risiꞌ kambo Betsaida sia dano seriꞌ. Te Eni feꞌe nahati sia naa, fo denu atahori naa ra baliꞌ. ");
INSERT INTO row_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ara baliꞌ boe, Ana hene mbukuꞌ esa de hule-oꞌe. ");
INSERT INTO row_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","50","Fai a hatuꞌ dei de Ana onda baliꞌ. Nita mana tungga nara ofa na losa dano a taladꞌa na. Ara sefe rae mate, huu ofaꞌ labꞌan anin. Deka manggarelo, Yesus tungga se. Ana laoꞌ sia oeꞌ ata. Sangga seli ofa a, ara rita E. Ara nggengger. De ratane rae, “He! Saa ia? Nitu, do?” Te Yesus olaꞌ nggero nae, “Afiꞌ mimitau! Ia Au.” ");
INSERT INTO row_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ana hene ofaꞌ ata neu, ma anin naa naloeꞌ. Mana tungga nara titindindii. ");
INSERT INTO row_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Sira feꞌe rita Yesus pake koasa na fo nahao atahori rifon lima lenaꞌ. Te nda feꞌe rahine tebꞌe-tebꞌeꞌ koasa na sa, huu sira rala nara manggateeꞌ. ");
INSERT INTO row_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Losa dano a seriꞌ boe, ara nafu mia nusa Genesaret dano suu na. ");
INSERT INTO row_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ara onda mia ofa a, atahori naeꞌ rita se. Rameli rae, “We! Yesus nema ena!” ");
INSERT INTO row_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","56","Basa se relaꞌ reu rafadꞌe ndule kamboꞌ, de atahori ra oꞌo rendi atahori mamahedꞌiꞌ ra. Sadꞌi sira rena Yesus sia mamanaꞌ esa, ara nonggo-nonggo rendi atahori mamahedꞌiꞌ, de ralololi se sia rae loaꞌ. Ara dꞌua rae, “Sadꞌi atahori hedꞌis naa ra kois dai Yesus badꞌu Na suu na, sira hai reuꞌ ena.” Kois taꞌo naa, ma ara hai tuteꞌ a. ");
INSERT INTO row_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Hambu atahori Farisi ro meser agama bubꞌueꞌ esa rema mia Yerusalem, fo randaa ro Yesus. ");
INSERT INTO row_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","5","Atahori Farisi naa ra toꞌu rahereꞌ sira adat Yahudi na. Onaꞌ a, mete ma atahori rae raa, musi safe lima na tungga adat hihii-nanau na. Mete ma baliꞌ mia pasar, sira musi rariu dei. Losa-losa sira bua dapu na boe o, onaꞌ a huraꞌ, pinggaꞌ, nggalas, ceret, basa se musi safe tungga adat hihii na, dei fo pake raa. Mete ma hambu atahori Yahudi laen nda tungga adat naa sa, atahori Farisi ra ramanasa. Naa de, leleꞌ ara mete-rita Yesus mana tungga nara raa nda safe lima nara tungga adat hihii na, ara ramanasa. Basa ma ara rema fee salaꞌ neu Yesus rae, “Saa de mana tungga mara raa, nda safe lima nara sa? Naa, sira labꞌan basa hita adat na mia bei-baꞌi tara!” ");
INSERT INTO row_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","7","Te Yesus nataa nae, “Hei ia ra memaꞌ atahori mana oꞌolaꞌ laen, tao laen! Mia dalahulu naa Baꞌi Yesaya suraꞌ hela Lamatualain hara-lii na oi, ‘Atahori ia ra koa-kio Au, no akaꞌ bafa a, te nda no rala nara sa. Sira tao taꞌo naa, o parsuma a. Sira nda fadꞌuli Au hihii ngga sa, te sira tungga akaꞌ a atahori hihii na. Hei onaꞌ naa boe. ");
INSERT INTO row_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","9","Hei lao hela Lamatualain hihii na, fo tungga atahori adat na. Hei memaꞌ mahine mara seli tao onaꞌ a naa! ");
INSERT INTO row_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Lele uluꞌ a Baꞌi Musa nafadꞌe Lamatualain parenda na nae, ‘Fee hadat neu hei papa-mama mara.’ Ma oi, ‘Mete ma atahori se rarai eni papa-mama na, musi hukun misa e.’ ");
INSERT INTO row_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Lamatualain nanori taꞌo naa, te hei minori fea. Hei mae, ‘Mete ma atahori helu basa fee buas esa neu Lamatualain, mae eni papa-mama na doidꞌoso rae mate o, te buas naa nda bole pake tulu-fali neu se sa, huu helu basa fee neu Lamatualain ena.’ ");
INSERT INTO row_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Naa de, Au ufadꞌe basa faꞌ ra, hei nggari Lamatualain hihii na, de nggati no atoran feuꞌ. Hei nggati basa atoran naeꞌ taꞌo naa ena.” ");
INSERT INTO row_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Basa ma, Yesus noꞌe atahori laen sia naa, de nae, “Pasa ndiki mara dei, fo mihine. ");
INSERT INTO row_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Saa fo masoꞌ nisiꞌ teiꞌ a rala, naa nda tao nanggenggeo atahori sa. Te saa fo kalua dea neu, naa mana tao nanggenggeo. ");
INSERT INTO row_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Seka mandikiꞌ, rena matalolole o!” ");
INSERT INTO row_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Basa ma Yesus no mana tungga nara lao hela atahori ra, de masoꞌ risiꞌ ume sa rala. Boe ma mana tungga nara ratane nekendandaaꞌ naa sosoa na. ");
INSERT INTO row_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yesus nataa nae, “Hei o nda mihine sa, do? Sosoa na taꞌo ia: saa fo atahori raa, naa maloleꞌ. Te saa fo kalua, naa nda maloleꞌ sa. ");
INSERT INTO row_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Saa fo hita taa, masoꞌ nisiꞌ tei tara, basa naa kalua seluꞌ fali. (Lamatuaꞌ Yesus hihii na oi atahori bole raa sudꞌiꞌ saa. Nda ena-ai sa.) ");
INSERT INTO row_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Saa fo kalua mia atahori rala na, naa fo tao nanggenggeo losa Lamatualain melu-mudꞌu eni, boe ma nda nau naꞌabꞌue no e sa. ");
INSERT INTO row_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Dedꞌea deꞌulakaꞌ naeꞌ kalua mia atahori rala nara! Sama onaꞌ dudꞌuꞌa deꞌulaka, hohongge, nemenaꞌo, tisa atahori, ");
INSERT INTO row_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","bare-naꞌo, deꞌulakaꞌ, lelekoꞌ, tungga hihii na, dale loleꞌ, olaꞌ natudꞌa atahori, koao, nda nahine hadat sa, ma langga fatu. ");
INSERT INTO row_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Basa deꞌulakaꞌ naa ra, kalua mia atahori rala nara. Naa, mana tao nalutu se. Lamatualain melu-mudꞌu se bee.” ");
INSERT INTO row_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Basa boe, Yesus se lao hela mamanaꞌ naa, de risiꞌ kamboꞌ esa nara na Tirus. Losa naa, ara masoꞌ risiꞌ ume esa, huu Yesus nda nau atahori bubꞌuluꞌ Eni sia naa sa. Te Eni nda bisa keke sa. ");
INSERT INTO row_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Sa naa hambu mama esa nda atahori Yahudi sa. Bꞌonggi eni mia Fenesia sia propensi Siria. Ana rena Yesus nema, ana neu noꞌe Yesus fo oi hendi nitu mia ana feto na. ");
INSERT INTO row_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Te Yesus nggari dedꞌeat nae, “Anaꞌ ra musi raa raꞌahuluꞌ, dei fo nggari lena na neu busa!” (No hihii maꞌafuniꞌ, Yesus musi tulu-fali Eni atahori Yahudi nara dei, dei fo bisa tulu-fali atahori feaꞌ ra). ");
INSERT INTO row_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Te mama naa naselu nae, “Tebꞌe, Papa! Te busa sia mei a raeꞌ, naa nanaat mana tudꞌa mia anaꞌ a pinggan.” (No hihiiꞌ na, leleꞌ anaꞌ ra raa, busa o hambu naa boe. Mae Yesus tulu-fali Eni atahori nara, Eni o musi mete atahori feaꞌ ra boe.) ");
INSERT INTO row_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Rena taꞌo naa, Yesus nafadꞌe nae, “Wei! Mama olaꞌ ndaa lao esaꞌ! De mama baliꞌ leo, te nitu a lao hela mama ana na ena.” ");
INSERT INTO row_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Basa ma, mama naa baliꞌ. Losa ume, ana na mana sunggu masambetaꞌ. Nitu a memaꞌ lao hela e. ");
INSERT INTO row_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Basa ma, Yesus lao hela kambo Tirus, tungga dala tasi suu na seli kambo Sidꞌon. Mia naa, ara lao rakandoo losa dano Galilea. Basa ma ara lao risiꞌ nusaꞌ esa no kamboꞌ sanahulu fo roꞌe rae ‘Dekapolis’. ");
INSERT INTO row_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Sa naa hambu atahori esa mabꞌobꞌeꞌ ma mbakeꞌ. Nono nara rendi e nisiꞌ Yesus. Ara roꞌe Yesus tao lima neu langga na fo nahai e. ");
INSERT INTO row_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Boe ma Yesus lao hela atahori naeꞌ naa ra, de mesaꞌ ne neu no atahori naa. Yesus mbau lima uꞌu na neu atahori naa ndiki na ruꞌa se rala. Basa ma, Ana tao miru neu lima uꞌu na, de nggama atahori naa maa na. ");
INSERT INTO row_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ana oroꞌa mbali lalai ata, lea hahae naruꞌ, basa ma parenda nae, “Efata” (sosoa na oi “Tabuka leon!”) ");
INSERT INTO row_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ana olaꞌ taꞌo naa, boe ma atahori naa ndiki na rena neuꞌ ena. Ma maa baraꞌaiꞌ na, bangganaꞌu neuꞌ ena, losa ana olaꞌ malole. ");
INSERT INTO row_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Basa ma, ruꞌa se baliꞌ risiꞌ atahori naeꞌ naa ra. Yesus ai se nae, “Rena! Hei afiꞌ mifadꞌe atahori mae, Au uhaiꞌ atahori ia ena.” Mae Yesus ena-ai se, te ara dui sia bee-bꞌee. ");
INSERT INTO row_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Atahori mana rena dudꞌuit naa ra, ndindiiꞌ a. De ara ola-olaꞌ rae, “Mana seli! Atahori ia tao basa e, dadꞌi malole. Atahori mbakeꞌ rena. Atahori mabꞌobꞌeꞌ ola-olaꞌ.” ");
INSERT INTO row_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","3","Lao esa, atahori naeꞌ rema raꞌabꞌue, fo rena Yesus. Ara tungga E fai telu ena, naa de, sira nanaa na basa. Boe ma Yesus noꞌe nala mana tungga nara, de nafadꞌe nae, “Au sue atahori ia ra. Hambu ruma mana nemaꞌ mia dodꞌooꞌ, naa te, ara raꞌabꞌue fai telu ena losa nanaat nara basa ena. Malole lenaꞌ ara afiꞌ baliꞌ no tei rouꞌ. Afiꞌ losa ara masaloe sia dalaꞌ taladꞌan.” ");
INSERT INTO row_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Yesus mana tungga nara rataa oi, “Papa. Mamanaꞌ ia naꞌadꞌoo no kamboꞌ a. De nda bisa hita fee atahori naeꞌ ia ra raa sa!” ");
INSERT INTO row_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Te Yesus natane se, oi “Hei roti ma hira?” Rataa rae, “Papa. Hai mbedꞌa hela akaꞌ roti bueꞌ hitu.” ");
INSERT INTO row_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Basa ma, Yesus denu atahori naa ra endoꞌ reu rae a. Ana haꞌi nala roti bueꞌ hitu naa ra, de noꞌe makasi neu Lamatualain. Ana bibꞌibꞌi roti naa ra, de fee neu mana tungga nara, fo reu babanggi fee neu basa atahori naa ra. ");
INSERT INTO row_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Sira o hambu uꞌu hira boe. Basa ma Yesus noꞌe makasi seluꞌ neu Lamatualain soaꞌ neu uꞌu naa ra. Basa ma Ana denu seluꞌ mana tungga nara, fo babanggi fee atahori naa ra fali. ");
INSERT INTO row_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Basa se mbeima atahori rifon haa. Ara raa losa raꞌabꞌeta. Basa ma, mana tungga nara reu raduru nanaa sisaꞌ ra, sofe boa monaeꞌ hitu. Basa naa de, Yesus denu se baliꞌ. ");
INSERT INTO row_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ara baliꞌ, boe ma Yesus no mana tungga nara hene risiꞌ ofaꞌ rala, de lao risiꞌ mamanaꞌ esa, nara na Dalmanuta. ");
INSERT INTO row_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Yesus se losa Dalmanuta, boe ma atahori bꞌaꞌubꞌe mia partei Farisi rema randaa ro E. Ara raselu bale ro E fo rae raꞌatutudꞌa E. Ara roꞌe E rae, “Papa! Mutudꞌu mana dadꞌi fo dadꞌi tatanda oi Papa memaꞌ hambu koasa mia Lamatualain.” ");
INSERT INTO row_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesus lea hahae naruꞌ nae, “Mete ma Au rena hei olaꞌ taꞌo naa na, Au fale-rala ngga! Saa de hei moꞌe mana dadꞌi ra? Afiꞌ taꞌo naa! Memaꞌ Au bisa tao mana dadꞌi ra, te Au nda nau utudꞌu hei sa.” ");
INSERT INTO row_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Basa naa boe, Yesus lao hela se de hene baliꞌ ofaꞌ rala neu, no mana tungga nara. Boe ma ara lao risiꞌ dano a seriꞌ. ");
INSERT INTO row_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yesus se losa dano a taladꞌan na, dei de mana tungga nara rasanedꞌa oi sira liliꞌ rendi lepa-ngges. Sira rendi akaꞌ roti bueꞌ esa. ");
INSERT INTO row_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Rena se olaꞌ roti, Yesus nae, “Hei musi besa-bꞌesa! Afiꞌ losa mane Herodes a no atahori Farisi ra kokoe-nanasi deꞌulakaꞌ na dai hei. Sira kokoe-nanasi na onaꞌ bibit roti.” ");
INSERT INTO row_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Rena Ana naꞌo naa, mana tungga nara bingun. Ara ola-olaꞌ rae, “Tou lasiꞌ a olaꞌ saa ia? Mbei ma Ana olaꞌ taꞌo naa, huu hita nda tendi roti sa.” ");
INSERT INTO row_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Te Yesus nahine sira dudꞌuꞌa na. De Ana olaꞌ nae, “Saa de hei olaꞌ akaꞌ a roti a! Hei nda mihine Au oꞌola ngga sa, do? Hei uta mara memaꞌ mbakat seli! ");
INSERT INTO row_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Hei mita no mata mara, te nda mihine sosoa na sa. Onaꞌ a nda mita sa! Hei rena no hei ndiki mara, te nda mihine saa-saa saꞌ bee. Onaꞌ a hei nda rena mihine sa! Hei liliꞌ hendi ");
INSERT INTO row_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","roti bueꞌ lima fo Au bibꞌibꞌi se, de nahao atahori rifon lima naa ra sa, do? Leleꞌ naa hei miduru mala roti a lena naa, boa hira?” Rataa rae, “Boa sanahulu rua, Papa.” ");
INSERT INTO row_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yesus natane seluꞌ nae, “Hei feꞌe misinedꞌa faiꞌ naa fo Au bibꞌibꞌi roti bue kahitu ra, de fee atahori rifon haa raa, do? Hei miduru mala lena naa ra, boa hira?” Rataa rae, “Boa manaeꞌ hitu, Papa!” ");
INSERT INTO row_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Boe ma Yesus nae, “Memaꞌ tebꞌe! Hei mita no mata mara, te saa de hei nda feꞌe mihine Au koasa ngga mia bee nema sa?” ");
INSERT INTO row_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Basa ma, Yesus se losa kambo Betsaida. Sa naa atahori ra rendi atahori pokeꞌ sa nisi Yesus. Ara roꞌe Yesus kois naꞌahahaiꞌ atahori pokeꞌ naa. ");
INSERT INTO row_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","De Yesus toꞌu nala atahori naa lima na ma nendi e nisiꞌ kamboꞌ a deaꞌ. Ana pupu miru neu atahori naa mata na, basa ma nggama matan. Natane nae, “Taꞌo bee? Ho mita ena, do?” ");
INSERT INTO row_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Atahori naa botiꞌ mata na, de mete dii-ona. Nataa nae, “Ia! Au ita atahori lao-laoꞌ. Te onaꞌ a hau huu ra laoꞌ!” ");
INSERT INTO row_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesus tao seluꞌ lima na neu atahori naa matan. Boe ma atahori naa mete seluꞌ, naa-naa te mata na nita tebꞌe ena. Ia naa eni nita no manggareloꞌ ena. ");
INSERT INTO row_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Boe ma Yesus denu atahori naa baliꞌ, ma fee nesenedꞌaꞌ neu e, nae “Baliꞌ leo, te muu tungga dalaꞌ laen! Afiꞌ heoꞌ baliꞌ misiꞌ Betsaida.” ");
INSERT INTO row_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Basa naa ma, Yesus se lao rereoꞌ kambo-kamboꞌ sia Kaisaria Filipi. Mia dalaꞌ taladꞌan Yesus natane mbali se nae, “Mete ma tungga atahori ra dudꞌui na, ara rae Au ia, seka?” ");
INSERT INTO row_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Rataa E rae, “Atahori ruma rae, ‘Yohanis Mana Sarani.’ Ruma rae, ‘Baꞌi Elia’, Lamatualain mana dui-bꞌengga na mia fai dalahulu naa. Ruma rae, Papa ia, esa mia Lamatualain mana dui-bꞌengga laen nara.” ");
INSERT INTO row_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Boe ma Yesus natane seluꞌ nae, “Te hei mae Au ia, seka?” Petrus nataa nae, “Papa ia, Kristus, atahori fo Lamatualain dudu basa mia dalahulu naa neu.” ");
INSERT INTO row_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Te Yesus naꞌanggee se nae, “Hei afiꞌ mifadꞌe atahori esa boe!” ");
INSERT INTO row_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Basa ma Yesus nafadꞌe mana tungga nara, nae “Au ia, tebꞌe-tebꞌeꞌ Atahori Matetuꞌ a. Dei fo Au doidꞌosoꞌ naeꞌ, huu lasi adat, malangga agama, ro meser agama ra basa se nda simbo Au sa. Ara risa Au, te finiesa na boe ma, Au usodꞌa baliꞌ.” ");
INSERT INTO row_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesus nafadꞌe relo-relo taꞌo naa, te Petrus nore nala E nisiꞌ suuꞌ, de ai nae, “Papa afiꞌ olaꞌ taꞌo naa! Au nda hela fee se lima nara dai Papa sa.” ");
INSERT INTO row_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Te Petrus olaꞌ taꞌo naa, nda tungga Lamatualain hihii na sa. Yesus heoꞌ dea na mete mana tungga laen nara. Ana ai Petrus nae, “He! Naa, malangga nitu ra dedꞌea na! Dinggoꞌ naa! Ho dudꞌuꞌa akaꞌ a atahori hihii na, te nda Lamatualain hihii na sa!” ");
INSERT INTO row_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Basa ma Yesus noꞌe atahori laen ra, fo rema raꞌabꞌue ro mana tungga nara. Basa ma nanori se nae, “Se nae tungga Au, eni musi naꞌatataaꞌ nakandoo tungga fai! Eni musi liliꞌ hendi hihii-nanau na, fo tungga akaꞌ Lamatualain hihii na. Mae atahori rae tao risa eni o, eni musi tungga nakandoo, onaꞌ a atahori lemba hau nggangge na fo neu mate. ");
INSERT INTO row_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Atahori mana nae dꞌuaꞌ a eni masodꞌa na, eni masodꞌa na mopo e! Te atahori mana sadꞌia mate, huu tungga Au no dui-bꞌengga Lamatualain Hara-lii Malole na, eni hambu masodꞌaꞌ nakandoo no Lamatualain. ");
INSERT INTO row_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Rena! Mae ho hambu basa raefafoꞌ a isi na, te Lamatualain nda simbo nggo sa na, ho hambu saa? ");
INSERT INTO row_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Mae ho lemba mendi raefafoꞌ a isi na boe o, nda bisa nggati ao samana ma sa! ");
INSERT INTO row_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Musunedꞌa e! Atahori sia raefafoꞌ aleꞌ ia deꞌulaka na mataꞌ-mataꞌ. Ara nda hii tungga Lamatualain sa. De see mae tungga Au, ma mae toꞌu Au nanori ngga, Au o mae utaa eni sia Lamatualain mata na. Te Au, tebꞌe-tebꞌeꞌ Atahoriꞌ Matetuꞌ ia, dei fo Au baliꞌ mia sorga uma. Lamatualain ate nara mia sorga rema ro Au. Hai onda mia sorga mo Amaꞌ koasa monae na, dei fo atahori ra rahine rae Au ia, seka. ");
INSERT INTO row_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Hei afiꞌ liliꞌ Au oꞌola ngga ia. Hambu mia basa hei ia ra, ruma nda feꞌe mate sa, dei fo rita Lamatualain parenda no koasa monae na. ");
INSERT INTO row_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Basa fai nee boe, Yesus noꞌe Petrus, Yakobis, ma Yohanis, de hene risiꞌ mbuku naruꞌ sa atahori nese na. Losa ata ma, rita Yesus dadꞌi laen. ");
INSERT INTO row_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Eni badꞌu na dadꞌi muti makahahadꞌo. Sia raefafoꞌ ia nda hambu saa fo mutiꞌ lenaꞌ Eni badꞌu na sa. ");
INSERT INTO row_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Aiboiꞌ ma, rita Yesus ola-olaꞌ no Baꞌi Elia ma Baꞌi Musa. ");
INSERT INTO row_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Petrus se ramatau rae mate. Petrus o bingun, losa ana olaꞌ leli. Nafadꞌe Yesus nae, “Papa! Hita maloleꞌ sia ia, e! Dadꞌi malole lenaꞌ hita tao lalaꞌ telu. Fee esa neu Papa, esa neu Baꞌi Musa, ma esa neu Baꞌi Elia.” ");
INSERT INTO row_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Basa naa ma, leleeꞌ a onda nema, de tatana nala se. Boe ma rena haraꞌ mia leleeꞌ a nae, “Rena! Yesus ia, Au Ana susue ngga. Hei rena matalolole neu E!” ");
INSERT INTO row_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Petrus se rena haraꞌ na, ara mete rereoꞌ te nda rita atahori laen sa, akaꞌ a Yesus mesaꞌ ne. ");
INSERT INTO row_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Basa naa, Yesus no mana tungga nara onda mia leteꞌ naa. Yesus ai se nae, “Saa fo hei feꞌe mita faꞌ ra, hei afiꞌ mifadꞌe atahori esa boe. Au ia, tebꞌe-tebꞌeꞌ Atahori Matetuꞌ a. Au musi mate dei. Basa fo, Au usodꞌa baliꞌ, dei fo hei bole mifadꞌe atahori ra.” ");
INSERT INTO row_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ara toꞌu rahereꞌ Yesus hehelu-fufuli na, de nda rafadꞌe atahori sa. Te teluꞌ se, esa natane esa rae, “Eni dudꞌuꞌa na saa, losa nae Eni nasodꞌa baliꞌ mia mamate na? Taꞌo bee, e?” ");
INSERT INTO row_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Boe ma, ratane E rae, “Meser agama ra rae ‘Baꞌi Elia musi nema dei, dei fo Kristus nema.’ Te tungga Papa, naa taꞌo bee?” ");
INSERT INTO row_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesus nataa nae, “Memaꞌ tebꞌe. Baꞌi Elia musi nema dei, fo soi dalaꞌ fee neu Kristus, atahori fo Lamatualain dudu basa mia dalahulu naa neu. Te taꞌo bee? Hei nda feꞌe mihine saa fo ara suraꞌ sia Lamatualain susura na soaꞌ neu Atahori Matetuꞌ naa? Ara suraꞌ memaꞌ, rae mete ma Eni nema ena, atahori raꞌasususaꞌ E, losa tao risa E. ");
INSERT INTO row_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Hei musi pasa ndiki mara matalole! Baꞌi Elia naa memaꞌ nema ena. Ma atahori raꞌasususaꞌ e, tungga sira hihii na. Naa o nandaa no saa fo baꞌi-baꞌi ra suraꞌ hela memaꞌ mia doo na neu.” ");
INSERT INTO row_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesus no mana tungga katelu nara, randaa baliꞌ ro mana tungga laen nara, ma rita atahori naeꞌ raꞌabꞌubꞌue. Ara rema rita Yesus mana tungga laen nara rareresi ro meser agama ra. ");
INSERT INTO row_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Atahori naeꞌ naa ra mete-rita Yesus, ara nggengger, te rae Ana feꞌe sia leteꞌ ata. De ara relaꞌ reu randaa ro E. ");
INSERT INTO row_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesus natane mbali se nae, “Hei mireresi saa sia ia?” ");
INSERT INTO row_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Te atahori esa nema nae, “Papa, rena dei! Au o ana tou ngga. Ana nabobꞌeꞌ nda ola-olaꞌ nala sa, huu nitu a tao e. Au oꞌe Papa naꞌahahaiꞌ e dei. ");
INSERT INTO row_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Mete ma nitu a masoꞌ e, ana mbembesiꞌ ao na neu rae a. Boe ma bafa na lua fufureꞌ, ma ale nisi na. Boe ma ao na o baraꞌai onaꞌ hau a. Au oꞌe Papa mana tungga nara, fo oi hendi nitu a. Te ara nda bisa saa-saa sa bee.” ");
INSERT INTO row_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Rena taꞌo naa, Yesus bua se nae, “He! Hei seli tebꞌe! Au unori hei bali-baliꞌ, onaꞌ o hei nda mihine sa. Ma nda mimihere tebꞌe-tebꞌeꞌ neu Au sa! Au musi fee tembo neu hei losa bee fai! Mendi anaꞌ naa nisiꞌ ia!” ");
INSERT INTO row_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","De oꞌo rendi e nisiꞌ Yesus. Nitu a mete-nita Yesus, boe ma ana mbesiꞌ hendi anaꞌ a losa naꞌaloli lololir neu rae a ma bafa na nafufure. ");
INSERT INTO row_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Basa boe ma, Yesus natane anaꞌ a papa na nae, “Ho ana ma dadꞌi taꞌo ia mia leleꞌ bee?” Papa na nataa nae, “Mia ana diki na.” ");
INSERT INTO row_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Nitu a nae nisa e doo ena. Ana tao hendi ana ngga ia bali-baliꞌ ai rala neu, ma naꞌatetenaꞌ e oe rala neu boe. De Papa tulun dei! Mete ma bisa, Papa sue hai na, muꞌuhahaiꞌ e dei.” ");
INSERT INTO row_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesus nataa nae, “Taꞌo bee de ho mae ‘mete ma bisa’? Au memaꞌ bisa tao basa-bꞌasaꞌ e, sadꞌi atahori ramahere dei!” ");
INSERT INTO row_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Basa boe ma, tou lasiꞌ a nataa no naeꞌ a nggaee oi, “Papa! Memaꞌ au umuhere ena. De tulun au fo nemehere ngga boe tamba manggate!” ");
INSERT INTO row_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Leleꞌ naa, Yesus nita atahori naeꞌ rema rakaseseti sia naa. Boe ma Ana parenda nitu a nae, “He! Nitu deꞌulaka! Lao hela ana ia leo fo ana rena, ma ola-olaꞌ nalaꞌ. Ho afiꞌ masoꞌ seluꞌ misiꞌ e fai!” ");
INSERT INTO row_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Rena Yesus olaꞌ naꞌo naa boe, nitu a nggasi nahereꞌ. Ana tao anaꞌ naa naꞌaloli ndundulea dei, de ana lao hela e. Boe ma anaꞌ naa onaꞌ a mates e. De atahori mana sa naa ra rae, “Naa, maten!” ");
INSERT INTO row_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Te Yesus toꞌu nala anaꞌ lima na, de nafefela e. Boe ma ana fela neuꞌ ena. ");
INSERT INTO row_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Basa naa, de Yesus no mana tungga nara lao hela mamanaꞌ naa, de risiꞌ ume sa rala. Sia naa ratane Yesus rae, “Papa! Taꞌo bee de hai nda bisa oi nitu naa sa?” ");
INSERT INTO row_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesus nafadꞌe se nae, “Rena matalolole! Nitu ra memaꞌ deꞌulakaꞌ. De mete ma hei nda hule-oꞌe moꞌe tulun neu Lamatualain sa, hei nda bisa oi nitu onaꞌ naa sa.” ");
INSERT INTO row_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Basa ma Yesus no mana tungga nara lao hela mamanaꞌ naa, de risiꞌ propinsi Galilea. Leleꞌ naa, Yesus nda nau atahori rahine Eni sia naa sa, ");
INSERT INTO row_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","huu Ana nae nanori a mana tungga nara. Ana nafadꞌe se nae, “Nda doo saꞌ te, ara seo hendi Au neu atahori feaꞌ. Dei fo ara risa Au, Atahori Matetuꞌ ia. Memaꞌ Au mate, te finiesa na, Au usodꞌa baliꞌ.” ");
INSERT INTO row_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Yesus nafadꞌe naꞌo naa, ma mana tungga nara bingun. Te ara nda rambarani ratane seluꞌ Yesus oꞌola na sosoa na sa. ");
INSERT INTO row_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Basa naa ma, Yesus se laoꞌ losa Kapernaum. Ara risiꞌ ume rala, boe ma Yesus natane se nae, “Faꞌra hei mireresi saa mia dalaꞌ?” ");
INSERT INTO row_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Te huu, nda hambu esa nambarani nataa sa bee, te mia dalaꞌ taladꞌan ara rasimbo bafaꞌ rae seka monaeꞌ sia basa-bꞌasa sira. ");
INSERT INTO row_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Basa ma Yesus endoꞌ de nanori se nae, “Seka nae dadꞌi atahori monaeꞌ, eni masodꞌaꞌ na musi onaꞌ a ate fo tulu-fali basa atahori. ");
INSERT INTO row_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Basa boe ma, Yesus oꞌo nala ana dikiꞌ esa mia naa, de baliꞌ nisiꞌ taladꞌa nara. Ana olaꞌ nae, ");
INSERT INTO row_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","‘Seka tungga Au fo simbo atahori anadikiꞌ onaꞌ anaꞌ ia, naa sosoa na eni simbo Au ena. Ana o simbo Au Papa ngga mana denu Au isiꞌ raefafoꞌ ia.” ");
INSERT INTO row_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Basa naa boe, Yesus mana tungga na Yohanis, kalaak nae, “Papa! Lao esa, hai mita atahori sa pake Papa nara na oi nitu. Te hai miꞌinggee e, huu eni nda hita atahori na sa.” ");
INSERT INTO row_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Boe ma Yesus nataa nae, “He! Afiꞌ miꞌinggee e. Te seka pake Au nara ngga fo tao mana dadꞌi, eni nda olaꞌ tao Au nara ngga maꞌafoo sa. ");
INSERT INTO row_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Mete ma eni nda labꞌan hita sa, sosoa na, eni o hita atahori na boe. ");
INSERT INTO row_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Misinedꞌa matalolole o! Mete ma hambu atahori rahine rae hei tungga Kristus, boe ma ana tulun hei, Lamatualain nda liliꞌ atahori naa bebengge na sa. Mae ana fee akaꞌ a oe mutiꞌ nggalas esa o, Lamatualain nda liliꞌ e sa.” ");
INSERT INTO row_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Basa boe ma, Yesus nafadꞌe seluꞌ se nae, “Mete ma atahori sa kokoe ana dikiꞌ esa fo tungga dala masalaꞌ losa anaꞌ naa nda namahere Au sa na, besa-bꞌesa o! Malole lenaꞌ atahori naa haꞌi nala fatu monaeꞌ esa, paꞌa neu lesu ai na, ma naꞌatetenaꞌ ao na nisiꞌ tasiꞌ a taladꞌa na. ");
INSERT INTO row_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Mete ma ho tao salaꞌ mendiꞌ lima ma na, tati hendiꞌ e! Malole lenaꞌ sorga muu mendiꞌ lima seseriꞌ a. Afiꞌ losa ara nggari nggo misiꞌ ai naraka mo lima ma ruꞌa se. ");
INSERT INTO row_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Naraka naa, memaꞌ mamana doidꞌosoꞌ. Ai a nda mate sa, no ula-ula sia naa ra nda hahae tao maꞌafooꞌ sa. ");
INSERT INTO row_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Mete ma ho tao salaꞌ mendiꞌ ei ma na, tati hendi e. Malole lenaꞌ sorga muu mendiꞌ ei seseriꞌ. Afiꞌ losa ara nggari nggo misiꞌ ai naraka mo ei ma ruꞌa se. ");
INSERT INTO row_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Naraka naa, memaꞌ mamana doidꞌosoꞌ. Ai a nda mate sa, no ula-ula sia naa ra nda hahae tao maꞌafooꞌ sa. ");
INSERT INTO row_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Mete ma ho tao salaꞌ mendi mata ma na, edꞌo nggari hendi e! Malole lenaꞌ sorga muu mendi mata seseriꞌ. Afiꞌ losa ara nggari nggo misiꞌ ai naraka mo mata ma ruꞌa se. ");
INSERT INTO row_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‘Naraka naa, memaꞌ mamana doidꞌosoꞌ. Ai a nda mate sa, no ula-ula sia naa ra nda hahae tao maꞌafooꞌ sa.’ ");
INSERT INTO row_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Au nanori ngga ia, memaꞌ bera na seli. De seka nae tungga Au, musi naꞌatataaꞌ tungga nakandoo, onaꞌ sisi fo atahori tao masiꞌ, de pangga neu ai, fo sisi naa naꞌatataa dooꞌ. ");
INSERT INTO row_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Masiꞌ a mafeliꞌ. Hita pake fo tao nanaat a maladꞌaꞌ. Te mete ma masiꞌa nda masi sa na, eni soaꞌ neu saa fai? Hita nggari hendiꞌ e. Hei o musi dadꞌi onaꞌ masiꞌ, fo misodꞌa sue-lai mo basa atahori. De hei musi miloeꞌ mireresi seka monaeꞌ ma seka anadikiꞌ!” ");
INSERT INTO row_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Basa boe, Yesus se risiꞌ propensi Yudea, ma mamana-mamanaꞌ laen sia loe Yordan bobꞌoa rulu na. Mia bee-bꞌee atahori naeꞌ rema heo rala E. Onaꞌ a biasa, Yesus nanori se. ");
INSERT INTO row_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Hambu atahori Farisi hira rema rae tao raꞌatutudꞌa E. Ratane rae, “Tungga hita atoran agama na naa, mete ma touꞌ sao ena, bole mahelaꞌ, do hokoꞌ?” ");
INSERT INTO row_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesus nataa se nae, “Misinedꞌa dei! Atoran sasaot fo Baꞌi Musa fee hela neu hita nae taꞌo bee?” ");
INSERT INTO row_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Rataa rae, “Baꞌi Musa atoran na nae, touꞌ bole mahelaꞌ, sadꞌi fee susura mahelaꞌ neu sao na dei.” ");
INSERT INTO row_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesus naselu nae, “He! Rena dei! Huu hei langga fatu mara, naa de Baꞌi Musa suraꞌ taꞌo naa! ");
INSERT INTO row_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Afiꞌ hei liliꞌ dudꞌui fefeu na, leleꞌ Lamatualain tao lalai no raefafoꞌ! Nene suraꞌ hela nae, “Lamatualain tao atahori, touꞌ no inaꞌ. ");
INSERT INTO row_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Naa de, touꞌ a lao hela papa-mama na, neu nasodꞌa ralaꞌ esa no sao na, ");
INSERT INTO row_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","huu ruꞌa se dadꞌi esa ena.’ ");
INSERT INTO row_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Mete ma Lamatualain, tao nala sira ruꞌa se dadꞌi esa ena, atahori afiꞌ fee se mahelaꞌ fai!” ");
INSERT INTO row_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Basa boe ma, Yesus no mana tungga nara risiꞌ ume sa rala. Sia naa ratane Yesus nenori na faꞌ ra. ");
INSERT INTO row_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","De nataa nae, “Seka hela hendiꞌ sao na, basa ma ana sao seluꞌ, naa hohongge ena! ");
INSERT INTO row_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Inaꞌ o onaꞌ naa boe! Mete ma ana hela hendi sao na, basa ma sao seluꞌ fai, naa hohongge boe! ");
INSERT INTO row_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Leleꞌ esa, atahori ra rendi ana nara risiꞌ Yesus, roꞌe fee se papala-babꞌanggi. Te Yesus mana tungga nara ai atahori naa ra. ");
INSERT INTO row_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesus mete-nita taꞌo naa, namanasa mana tungga nara nae, “Hela anaꞌ naa ra rema risiꞌ Au! Afiꞌ miꞌinggee! Te atahori onaꞌ sira ia ra, Lamatualain atahori nara. ");
INSERT INTO row_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Misinedꞌa matalolole! Seka nau nema nandaa no Lamatualain, ana musi hii E, sama onaꞌ anaꞌ hii papa-mama na. Mete ma nda taꞌo naa sa, ana nda nandaa dadꞌi Lamatualain atahori na sa.” ");
INSERT INTO row_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Basa boe ma, Yesus holu nala anaꞌ naa ra, tao lima na neu esa-esaꞌ, de fee se papala-babꞌanggi. ");
INSERT INTO row_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesus se rae lao boe, atahori mamasuiꞌ esa nela-nelaꞌ nema nae nandaa no E. Ana sendeꞌ lululangga na neu Yesus mata na, ma natane nae, “Papa Meser nene fehadat! Au ae utane mbei. Taꞌo ia, Papa. Au musi tao taꞌo bee, fo uhine tebꞌeꞌ au masoꞌ sorga fo usodꞌa o Lamatualain? ");
INSERT INTO row_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesus nataa nae, “Taꞌo bee de ho mae Au, ‘nene fehadat’!? Nda hambu atahori esa nene fehadat, akaꞌ a Lamatualain. ");
INSERT INTO row_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ho muhine, Lamatualain parenda na ma fai maꞌahulu naa nae, ‘Afiꞌ misa atahori; Afiꞌ hohongge; Afiꞌ mumunaꞌo; Afiꞌ dadꞌi sakasii lelekoꞌ; Afiꞌ laka atahori fo haꞌi mala sudꞌiꞌ saa nara; Ma fee hadꞌat neu ho papa-mama ma.’” ");
INSERT INTO row_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Atahori na nataa nae, “Tebꞌe, Papa Meser! Mia au soru ngga, au tungga basa parendaꞌ naa ra ena.” ");
INSERT INTO row_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesus kasian atahori naa, de nafadꞌe nae, “Tebꞌe! Te feꞌe hela dalaꞌ esa. Ia naa baliꞌ fo seo hendi basa suꞌi mara. Basa naa, muu babanggi doiꞌ nara fee atahori toꞌataꞌ ra. Dei fo uma tungga Au leo. Te Lamatualain pala-baꞌe fee ho suꞌi-betas sia sorga!” ");
INSERT INTO row_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Atahori naa rena Yesus oꞌola na taꞌo naa, rala na nambalulutu. Ana baliꞌ no rala sususaꞌ, huu eni suꞌiꞌ na naeꞌ. ");
INSERT INTO row_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Boe ma Yesus mete neu-nema, ma olaꞌ no mana tungga nara nae, “Rena e! Atahori mamasuiꞌ a memaꞌ susa lao esaꞌ nisiꞌ sorga! ");
INSERT INTO row_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Rena taꞌo naa boe, mana tungga nara bingun. Te Yesus olaꞌ seluꞌ nae, “Rena matalolole! Mae dadꞌi Lamatualain atahori na, susa lao esaꞌ! Afiꞌ dꞌua mae naa mudaꞌ. ");
INSERT INTO row_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Atahori mamasuiꞌ a nisiꞌ sorga dadꞌi Lamatualain atahori na, sususa na onaꞌ a banda onta monaeꞌ esa nisiꞌ lalae na tungga sosoot a ndola na.” ");
INSERT INTO row_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yesus ola taꞌo naa, tao se bau bingun, de ratane rae, “Mete ma memaꞌ taꞌo naa, seka bisa hambu masodꞌa?” ");
INSERT INTO row_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesus mete esa-esa, boe ma nafadꞌe nae, “Atahori memaꞌ nda bisa tao sa. Te afiꞌ liliꞌ! Lamatualain bisa tao basaꞌ e!” ");
INSERT INTO row_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Basa boe ma, Petrus olaꞌ nae, “Papa. Hai lao hela basa saa-saa mara ena fo tungga Papa. Te hai hambu saa?” ");
INSERT INTO row_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Yesus nataa nae, “Au ufadꞌe hei taꞌo ia! Seka tungga Au, ma lao hela papa-mama nara, odꞌi-aꞌa nara, ana nara, osi na, ue-tatao na, no ume isi nara, fo neu bengga Lamatualain Hara-lii Malole na neu atahori sia bee-bꞌee, eni simbo baliꞌ buna-bꞌoaꞌ lao natun esa. Basa saa fo eni lao helaꞌ nara, eni simbo baliꞌ lenaꞌ naa. Te atahori tao e doidꞌosoꞌ, huu eni tungga Au. Te mete ma raefafoꞌ ia nateteꞌe, eni nasodꞌa nakandoo no Lamatualain. Naa, eni balaꞌ-bae na! ");
INSERT INTO row_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Misinedꞌa e! See naꞌamoko ao na, tungga Lamatualain dudꞌuꞌa na, atahori naa atahori anadikiꞌ seli. Te seka naloe ao na, tungga Lamatualain dudꞌuꞌa na, eni atahori monaeꞌ.” ");
INSERT INTO row_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Leleꞌ naa, Yesus se lao risiꞌ Yerusalem. Yesus laoꞌ naꞌahuluꞌ, ma mana tungga nara ro atahori laen nara raꞌabuit. Sira rasanedꞌa saa fo Ana olaꞌ dalahulu naa nae, atahori rae risa Eni sia Yerusalem. Naa de, ara dadꞌi bingun boe ramatau. Rena taꞌo naa, Yesus noꞌe nala mana tungga nara, de nafadꞌe seluꞌ saa fo atahori rae tao neu Eni sia Yerusalem. ");
INSERT INTO row_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ana olaꞌ nae, “Rena o! Ia naa, hita tae Yerusalem teu. Au ia, Atahori Matetuꞌ a. Losa naa, ara seo Au neu malangga agama ro meser agama ra. Basa ma ara hukun risa Au. Boe ma ara mboꞌi nggari hendi Au neu atahori laen mana nda rahine Lamatualain sa. ");
INSERT INTO row_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Basa ma ara olaꞌ raꞌamamaeꞌ Au. Ara puras miru neu Au. Ara filo ralulutu Au ao ngga. Basa dei de, ara risa Au. Memaꞌ Au mate tebꞌe. Te finiesa na ma, Au usodꞌa baliꞌ.” ");
INSERT INTO row_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Basa boe, Yakobis no Yohanis, Sabadius ana nara, rema risiꞌ Yesus. Ara roꞌe Yesus rae, “Papa Meser! Hai parlu.” ");
INSERT INTO row_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesus natane se nae, “Hei parlu saa?” ");
INSERT INTO row_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Rataa rae, “Taꞌo ia, Papa! Mete ma Papa endoꞌ toꞌu parendaꞌ ena, hai moꞌe Papa naꞌeꞌendoꞌ hai, esa sia Papa bobꞌoa ona ma, esa sia bobꞌoa dii ma. Fo hai o toꞌu parendaꞌ.” ");
INSERT INTO row_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesus nataa nae, “Hei ruꞌa nggi nda mihine saa fo hei moꞌe sa. Te Au hambu doidꞌosoꞌ naeꞌ. De taꞌo bee? Hei dꞌua mae hei o bisa lemba doidꞌosoꞌ naa mo Au losa mate, do?” ");
INSERT INTO row_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Rataa rae, “Hai bisa, Papa!” Yesus olaꞌ a seluꞌ no se nae, “Memaꞌ hei bisa lemba doidꞌosoꞌ naa, onaꞌ Au boe. ");
INSERT INTO row_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Te seka endoꞌ sia Au bobꞌoa dii-ona ngga, naa Au nda uꞌetuꞌ sa. Naa, Lamatualain mana naꞌetuꞌ. Ana naꞌetuꞌ basa ena, seka-seka mana endoꞌ sia mamanaꞌ naa.” ");
INSERT INTO row_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Leleꞌ mana tungga laen nara rena Yakobis no Yohanis roꞌe taꞌo naa ma, ramanasa. ");
INSERT INTO row_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Basa ma Yesus noꞌe nala basa se, de nae, “Hei mihine ena, to? Atahori monaeꞌ mana toꞌu parendaꞌ ra akaꞌ a tuni-ndeni manggarau nara, losa ara nda bisa raꞌalalauꞌ saa sa bee. Boe ma malangga nusaꞌ fo nda rahine Lamatualain sa, ara parendaꞌ raꞌaꞌlelenaꞌ, losa manggarau nara nda bisa botiꞌ langga nara sa. ");
INSERT INTO row_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Te hei afiꞌ tao taꞌo naa! Seka mia hei ia ra, nae dadꞌi neu atahori monaeꞌ, eni musi dadꞌi onaꞌ mana tulu-fali fo tao mataꞌ neu atahori laen. ");
INSERT INTO row_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Seka nae dadꞌi neu malangga, eni musi dadꞌi onaꞌ ate. ");
INSERT INTO row_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Te Au ia, tebꞌe-tebꞌe Atahori Matetuꞌ a. Au nda uma fo atahori tao mataꞌ neu Au sa. Te Au uma fo tao mataꞌ neu atahori naeꞌ. Au uma fee masodꞌa ngga teme-teme fo mboꞌi hendi atahori naeꞌ mia sira sala nara.” ");
INSERT INTO row_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesus no mana tungga nara losa kambo Yeriko. Leleꞌ ara rae lao rakandoo, boe ma atahori nae na seli tungga se. Sia naa o hambu atahori pokeꞌ esa endoꞌ hule-huleꞌ sia dalaꞌ a bife na. Nara na Bartimeos, Papa Timeos ana na. ");
INSERT INTO row_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ana rena nae mana tungga naa, Yesus mia Nasaret, boe ma ana nggasi nahereꞌ nae, “Yesus! Daud tititi-nonosi na, ee! Hai nea-nea Papa doo ena! Sue-lai au dei!” ");
INSERT INTO row_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Rena ana nggasi naꞌo naa, boe ma atahori ra ai e rae, “He! Nee-nee!” Te ana nggasi nahereꞌ seluꞌ fai nae, “Yesus! Daud tititi-nonosi na, ee! Sue-lai au dei!” ");
INSERT INTO row_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Boe ma Yesus nambariiꞌ. Ana denu nae, “Mo e nema!” Ara reu, de rae, “Mumuhoꞌo leo! Te Papa Meser noꞌe nggo. De uma leo!” ");
INSERT INTO row_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Rena taꞌo naa, Bartimeos piru hendi lafe na, boe ma ana nambariiꞌ haelalai, de neu nandaa no Yesus. ");
INSERT INTO row_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesus natane e nae, “Ho nau saa?” Nataa nae, “Papa, e! Au oꞌe fo au bisa ita.” ");
INSERT INTO row_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesus nafadꞌe seluꞌ e nae, “Huu ho mumuhere mae Au bisa uꞌuhahaiꞌ nggo, leleꞌ ia o, ho hai boe! Muu leo!” Boe ma mata na nita neuꞌ ena, de ana neu namaloloꞌ no Yesus. ");
INSERT INTO row_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Leleꞌ ara deka ro kota Yerusalem, ara losa kamboꞌ rua, nara na Betfage no Betania, sia Leteꞌ Saitun suu na. Mia naa Yesus se rahani mbeiꞌ. De Ana haitua mana tungga na rua lao raꞌahuluꞌ. ");
INSERT INTO row_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ana denu nae, “Hei ruꞌa nggi miꞌihuluꞌ misiꞌ kamboꞌ naa. Mete ma hei losa, hei mita keledei anaꞌ esa, mana paꞌaꞌ sia naa. Atahori nda feꞌe sae rita e sa. Hei mi sefi hendi tali na fo lea mendi e nema. ");
INSERT INTO row_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Te mete ma atahori ratane hei rae, ‘Taꞌo bee de hei sefi mendi keledei naa?’ hei musi mitaa mae, ‘Lamatuaꞌ nae pake. Mete ma pake basa na, Ana fee baliꞌ eꞌ.’” ");
INSERT INTO row_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Basa ma, atahori karuaꞌ ra reu, boe ma rita keledei anaꞌ nene paꞌaꞌ sia ume sa mataꞌ sia dalaꞌ a bobꞌoa na. Ara sefi rendi e. ");
INSERT INTO row_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Te atahori mana sia nara, ratane rae, “He! Taꞌo bee de hei sefi mendi atahori keledei naa?” ");
INSERT INTO row_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Rataa rae, “Hai Lamatua ma nae pake. Mete ma Ana pake basa, hai mendi baliꞌ e.” Boe ma atahori naa ra lao hela se nore rendi keledei a. ");
INSERT INTO row_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ara nore rendi nisiꞌ Yesus. Basa de, ara lakaꞌ lafe nara neu keledei a, de Yesus sae. ");
INSERT INTO row_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Leleꞌ ara rae losa kota rala, atahori naeꞌ haꞌi rala lafe nara, de bela neu dalaꞌ. Hambu ruma reu tati hau palam rooꞌ mia dalaꞌ bife na, de bela neu dalaꞌ taladꞌan. Ara tao taꞌo naa, fo dadꞌi tatandaꞌ rae sira simbo Lamatuaꞌ Yesus no hadꞌat. Onaꞌ a sira simbo atahori monae nara boe. ");
INSERT INTO row_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Boe ma atahori ruma lao raꞌahuluꞌ Yesus, no ruma raꞌabꞌuit. De ara eki randu rae, “Hosana! Hai koa-kio Lamatualain! Lamatualain naꞌondaꞌ pala-banggi fee atahori mana nema pake Lamatualain nara na, huu Lamatualain mana denu E! ");
INSERT INTO row_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Hosana! Hai koa-kio Lamatualain! Huu Lamatualain nae nafefela baliꞌ Mane Daud parenda na! Hosana! Hai koa-kio Lamatualain! Huu Lamatualain endoꞌ parenda memaꞌ ena, sia lalai naru ata!” ");
INSERT INTO row_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Losa kota rala, Yesus se reu risiꞌ Ume Hule-oꞌe Huuꞌ nembeleo na. Yesus mete matalolole ndule basa mamanaꞌ naa. Te naꞌe a hatuꞌ ena, de ara lao baliꞌ risiꞌ kambo Betania. ");
INSERT INTO row_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mbila fefetu na, ara lao hela Betania de baliꞌ risiꞌ kota Yerusalem. Mia dalaꞌ taladꞌan, Yesus namedꞌa ndoe. ");
INSERT INTO row_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ana nita hau huuꞌ esa mia dalaꞌ bife na. Atahori biasa raa boa na. De Yesus neu deka-deka hau huu naa, nae mete sobꞌa hambu boaꞌ, do hokoꞌ. Losa hau huuꞌ naa, Ana nda nita saa-saa saꞌ bee. Te memaꞌ nda fai nabꞌoa na sa. Ana feꞌe nae naroo naa. ");
INSERT INTO row_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Boe ma Yesus olaꞌ fee hau huuꞌ naa nae, “Ho nda fee boa ma neu Au sa, de mia faiꞌ ia, ho nda bisa fee boa ma neu atahori laen sa!” Mana tungga nara rena Ana olaꞌ nahereꞌ taꞌo naa. ");
INSERT INTO row_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Basa ma ara lao rakandoo, losa Yerusalem, boe ma Yesus neu seluꞌ nisiꞌ Ume Hule-oꞌe Huu na. Sia Ume Hule-oꞌe a nembeleo na, atahori tao dadꞌi pasar, fo raseoꞌ mbui lunda fo atahori tao neu tutunu-hohotuꞌ. Nita taꞌo naa boe, Yesus neu oi hendi se. Ana timba lenggu-babara hendi mei-mei fo ara pake tukar doiꞌ, ma timba hendi banggu-banggu fo ara pake raseoꞌ neu mbuiꞌ ra. ");
INSERT INTO row_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ana o naꞌangge basa atahori fo nda bole haꞌi rendi sira saa-saa nara fo lao nggero tungga nembeleo naa sa. ");
INSERT INTO row_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Boe ma Ana nanori se nae, “Hei mihine memaꞌ saa fo Lamatualain mana dui-bꞌengga nara suraꞌ hela rae, ‘Au ufefela Au Ume ngga ia fo atahori mia basa nusaꞌ ra rema hule-oꞌe sia ia.’ Te hei tao mala Ume ia dadꞌi neu naꞌo ra mamana neꞌebꞌue na!” ");
INSERT INTO row_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Leleꞌ malangga agama ra ro meser agama ra rena Yesus tao taꞌo naa ena, ara ramanasa E, de sangga dalaꞌ fo rae risa E. Te ara o hia boe, huu atahori naeꞌ hii a rena nanori na. ");
INSERT INTO row_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Leleꞌ relo a nae mopo, boe ma Yesus se lao hela kota Yerusalem, de baliꞌ reu sungguꞌ sia kambo Betania. ");
INSERT INTO row_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","21","Mbila fefetu ana na ma, Yesus se baliꞌ risiꞌ Yerusalem. Mia dalaꞌ taladꞌan ara tungga baliꞌ hau afis a. Mana tungga nara kakaler, huu hau naa mate meto losa oka-oka na. Boe ma Petrus nasanedꞌa Yesus oꞌola naa afis a. Nafadꞌe nae, “Papa! Mete dei! Hau fo afis a Papa ndoondoon a, mate ena!” ");
INSERT INTO row_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesus nataa nae, “Memaꞌ tebꞌe! Sadꞌi hei mimihere Lamatualain taꞌo naa boe. ");
INSERT INTO row_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Mete ma hei mimihere tebꞌe-tebꞌeꞌ, hei bisa denu leteꞌ esa lali tasiꞌ rala neu. Boe ma Lamatualain fee leteꞌ naa lali, sadꞌi hei afiꞌ mimihere mo rala mana banggiꞌ! Hei musi mimihere tebꞌe-tebꞌeꞌ neu Lamatualain. ");
INSERT INTO row_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Afiꞌ liliꞌ! Sadꞌi hei mimihere tebꞌe-tebꞌeꞌ Lamatualain bisa fee saa fo hei moꞌe, naa, Ana fee hei! ");
INSERT INTO row_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Te mete ma hei hule-oꞌe, te hei esa rala na nda maloleꞌ no atahori laen sa, eni musi malolole no atahori naa dei. Taꞌo naa, dei fo hei Papa ma sia sorga nau tao nameu hei sala mara. ");
INSERT INTO row_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Mete ma hei esa mimbedꞌa ralaꞌ, no nda nau fee ambon neu atahori sa, hei Papa ma sia sorga boe o nda fee ambon neu hei sala mara sa.” ");
INSERT INTO row_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Basa boe ma, ara laoꞌ rakandoo. Losa Yerusalem, ara masoꞌ baliꞌ risiꞌ Ume Hule-oꞌe Huuꞌ a. Leleꞌ ara masoꞌ losa nembeleon naa, malangga agama ra ro meser agama ra rema, ");
INSERT INTO row_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","de ratane Yesus rae, “Seka denu Nggo uma mumue mia ia afis a? Seka fee Nggo hak!” ");
INSERT INTO row_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Te Yesus nahine sira sangga dalaꞌ fo rae raꞌatutudꞌa E. Basa ma Ana nataa nae, “Au o ae utane hei bee. Hei mitaa Au, dei fo Au utaa hei. ");
INSERT INTO row_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Au utane taꞌo ia: Basa hei mihine Yohanis, Mana Saraniꞌ naa, do? Seka denu e fo sarani atahori? Lamatualain, do atahori?” ");
INSERT INTO row_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Boe ma ara dudꞌuꞌa neu-nema, no ralaꞌ esa rae, “Awe! Dai hita ena! Mete ma hita tataa tae, ‘Lamatualain mana denu’, naa, Ana nataa nae, ‘Mete ma taꞌo naa, saa de hei nda mimihere Yohanis sa!’ ");
INSERT INTO row_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Te hita o nda bisa tae ‘atahori mana denu’ sa. Te basa atahori ra ramue. Huu ara ramahere rae Yohanis naa, Lamatualain mana dui-bꞌengga na.” ");
INSERT INTO row_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Basa de rataa rae, “Hai nda mihine sa!” Boe ma Yesus nataa baliꞌ nae, “Mete ma taꞌo naa, Au o nda nau ufadꞌe seka mana denu Au sa bee.” ");
INSERT INTO row_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Basa naa, Yesus olaꞌ seluꞌ no malangga agama Yahudi ra no meser agama ra. Ana fee nekendandaaꞌ nae, “Hambu atahori esa nae tao osi anggor sa sia rae na. Ana lutu-mbaa rereoꞌ, ma nafefela mamana neneaꞌ naruꞌ esa, de sela hau anggor. Ana o tao bak fo nae natanee boa anggor oe na. Basa boe ma, ana fee osi naa neu atahori laen mete-seꞌu, fo banggi hasil na. De ana lao tuteꞌ nusa lain neu. ");
INSERT INTO row_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Losa fai etu boa anggor boe ma, tenu osi a denu ate na esa neu nisiꞌ atahori mana tao osi ra, fo noꞌe eni hahambu na. ");
INSERT INTO row_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Losa naa, mana mete-seꞌu osi ra toꞌu rala e, de popoko. Basa ma ara denu e baliꞌ no lima rouꞌ. ");
INSERT INTO row_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Basa ma tenu osi a haitua ate na esa fali. Te mana mete-seꞌu osi ra popoko langga na losa hinaꞌ-hinaꞌ, ma raꞌamamaeꞌ e, de oi hendi. ");
INSERT INTO row_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Basa naa, tenu osi a haitua seluꞌ ate na esa fai. Te ara risa e. Mae ara tao taꞌo bee o, tenu osi a haitua nakandoo a ate nara. Te mana mete-seꞌu osi ra popoko ruma, ma risa ruma. ");
INSERT INTO row_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ia naa hela akaꞌ a atahori esa ena. Naa eni tenu osi a ana mone susue na. Huu nda hambu dalaꞌ laen seluꞌ sa, de ana haitua anaꞌ naa. Ana dꞌua nae, ‘Mete ma au haitua ana ngga, ara simbo no malolole, boe ma ara rena e. ");
INSERT INTO row_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","De ana haitua ana na neu sia naa. Te mana mete-seꞌu osi ra rita ana naa nema, boe ma ara ola-olaꞌ rae, “Wei! Mete dei! Tou lasiꞌ a haitua ana na nema mata na! Mete ma tou lasiꞌ a mate, eni ia mana simbo nala basa hata-heto naa ra. Ima hita tisa e, fo hita soa hata-heto na ia ra! ");
INSERT INTO row_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Basa ma ara humu e, de risa e. Ara mbia hendi ao sisi na nisiꞌ osi deaꞌ. Dudꞌui na losaꞌ a naa.” ");
INSERT INTO row_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yesus dui basa boe ma, natane atahori monaeꞌ ra nae, “Tungga hei dudꞌuꞌa mara, tenu osi a nae tao taꞌo bee neu mana mete-seꞌu osi ra? Tungga Au, ana nema fo nisa basa se. Basa naa, ana fee osi anggor na neu atahori laen mete-seꞌu. ");
INSERT INTO row_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Basa hita seꞌu-tita sia Lamatualain susuraꞌ na nae, ‘Hambu fatu esa fo tukan ra nggari hendi. Te ia naa, fatu naa dadꞌi neu fatu lalakaꞌ. ");
INSERT INTO row_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Lamatualain tengga nala, boe ma naꞌeꞌendoꞌ fatu naa. Naa de, hita tita eni malole na seli!’” ");
INSERT INTO row_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Atahori monaeꞌ ra rahine neuꞌ ena rae, Yesus nggari dedꞌeat naa neu se pake nekendandaaꞌ. Ara onaꞌ mana mete-seꞌu osi naa ra. Basa boe ma ara ator dalaꞌ fo rae humu Yesus. Te ara hia atahori naeꞌ mana hii rena Yesus nenori na. De ara lao hela E. ");
INSERT INTO row_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Basa ma, atahori Yahudi moko-monae naa ra, denu atahori Farisi bꞌaꞌubꞌe, ro atahori mia Herodes partei nara, reu raselu bale ro Yesus, fo rae raꞌatutudꞌa E. ");
INSERT INTO row_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Boe ma ara rema raseluꞌ bale ro Yesus rae, “Papa Meser! Basa hai mihine mae Papa rala na tetuꞌ, ma Papa nda pepeko-lelekoꞌ sa. Papa mete akaꞌ atahori rala nara. Papa o nafadꞌe Lamatualain hihii-nanau na no relo-relo, huu Papa nda mete mataꞌ sa. Ia naa, hai mae mitane dalaꞌ esa. Tungga hita atoran agama Yahudi na, hita musi bae bea neu mana parenda Roma, do afiꞌ?” ");
INSERT INTO row_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Te Yesus nahine sira rae teꞌe-sii E, fo olaꞌ labꞌan mana parenda Roma. De nataa nahereꞌ nae, “Taꞌo bee de hei mae miꞌitutudꞌa Au no dalaꞌ naa! Fee doi fulaꞌ esa, fo Au mete sobꞌa dei!” ");
INSERT INTO row_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Boe ma ara loo fee doi fulaꞌ esa. Yesus haꞌi nala, de seꞌu namemeuꞌ doiꞌ naa. Boe ma natane mbali se nae, “Ia, seka mata na? Ia, seka nara na?” Rataa rae, “Naa, mana parenda Roma Mane Monae na!” ");
INSERT INTO row_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Boe ma Yesus nae, “Mete ma taꞌo naa, fee mana parenda saa fo mana parenda ena na. Ma fee Lamatualain saa fo Lamatualain ena na.” Rena nataa naꞌo naa, boe ma basa se ndii-ndiiꞌ a, te Ana nataa ndaa. Naa de, ara nda bisa teꞌe-sii rala E sa. ");
INSERT INTO row_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Hambu partei agama laen esa, fo atahori rae partei Saduki. Ara ranori rae atahori mates nda bisa rasodꞌa baliꞌ sa. Lao esa, atahori Saduki hira rema rae hengge Yesus. ");
INSERT INTO row_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Ara olaꞌ ro Yesus rae, “Papa Meser! Baꞌi Musa suraꞌ hela fee hai, adat ia nae: Mete ma touꞌ esa mate hela sao na, ma anaꞌ nese, touꞌ naa odꞌi na musi sao nala ina falu na, fo hela fee tititi-nonosiꞌ neu aꞌa mana mate na. ");
INSERT INTO row_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Memaꞌ Musa nanori taꞌo naa. Te hai mae mitane taꞌo ia. Hambu touꞌ hitu odꞌi-aꞌa. Aꞌa ka sao naꞌahuluꞌ. Basa ma ana mate, te nda ma anaꞌ sa. ");
INSERT INTO row_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Boe ma odꞌi mana tungga eni a, sao baliꞌ ina falu naa. Nda doo sa ma, ana mate, nda hambu anaꞌ sa. Onaꞌ naa odꞌi ka telu na, sao baliꞌ no ina falu naa, te ana mate, ma anaꞌ nese. ");
INSERT INTO row_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Taꞌo naa nekendooꞌ a losa odꞌi muri na o mate. Basa boe ma, ina falu naa mate. ");
INSERT INTO row_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ia naa hai mae mitane taꞌo ia: Inaꞌ naa sao touꞌ hitu ena! Te mete ma raefafoꞌa nateteꞌe fo Lamatualain fee atahori mates ra rasodꞌa baliꞌ, inaꞌ naa dadꞌi seka sao na mia touꞌ kahituꞌ naa ra?” ");
INSERT INTO row_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Basa ma Yesus nataa nae, “Mete ma hei mitane taꞌo naa, naa hei nda mihine Lamatualain susuraꞌ na isi na sa. Hei o nda mihine Lamatualain koasa na sa. De hei ia ra seli tebꞌe ma! ");
INSERT INTO row_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Rena, e! Taꞌo ia! Sia sorga, nda hambu masaoꞌ sa. Basa atahori mates fo Lamatuaꞌ fee rasodꞌa baliꞌ ra, nda hambu rasao seluꞌ sa ena. Onaꞌ naa boe o Lamatualain ate nara sia sorga nda sao saꞌ bee. ");
INSERT INTO row_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Au o ufadꞌe atahori mates ra, ara rasodꞌa baliꞌ, do hokoꞌ. Sia Baꞌi Musa susura na ana suraꞌ nae hau anaꞌ mana lalanggeꞌ te nda kadꞌe sa. Hei misinedꞌa dudꞌuit naa, do hokoꞌ? Leleꞌ ai a mbila mia hau naa, Lamatualain nafadꞌe Musa nae, ‘Au ia ho baꞌi mara Lamatualain na. Naa, eni Baꞌi Abraham, Baꞌi Isak, ma Baꞌi Yakob. Basa sira beꞌutee neu Au losa ia neme. ");
INSERT INTO row_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Hita tahine tae baꞌi naa ra, mate doo ena. Te huu Lamatualain nafadꞌe nae Eni feꞌe dadꞌi neu sira Lamatuaꞌ na. Memaꞌ atahori mana beꞌutee neu Lamatualain, atahori masodꞌaꞌ, nda atahori mates sa. Naa de, hita tahine tae ara rasodꞌa baliꞌ ena. De mae atahori mate ena o, ara rasodꞌa baliꞌ. De mete ma hei toꞌu mikindoo neu nenoriꞌ a nae, atahori mates ra nda rasodꞌa baliꞌ sa, hei memaꞌ talalu sala ena!” ");
INSERT INTO row_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Leleꞌ naa, meser agama esa rena Yesus ola-olaꞌ no atahori partei Saduki ra. Meser agama naa dꞌua nae Yesus nataa sira no maloleꞌ. Basa ma ana natane Yesus nae, “Papa! Au ae utane taꞌo ia: Hita parenda adat no parenda agama na, nae na seli. Mia basa se, bee ka lenaꞌ?” ");
INSERT INTO row_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesus nataa nae, “Baꞌi Musa suraꞌ hela Lamatualain parenda mana seliꞌ na, nae taꞌo ia: ‘Basa atahori sia Israꞌel! Rena matalolole! Lamatualain memaꞌ hita Lamatuaꞌ na no hita malangga na! Nda hambu laen sa, akaꞌ a Eni! ");
INSERT INTO row_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","De hita musi sue-lai E lenaꞌ basa e. Hita musi hii E nakandooꞌ a, tahine E, ma manggate tungga hihii-nanau na. ");
INSERT INTO row_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ma parendaꞌ karua naa nae taꞌo ia: ‘Hita musi sue atahori, onaꞌ a hita sue hita ao na boe.’ Parenda karuaꞌ ia ra mana seliꞌ. Nda hambu parendaꞌ laen mana lenaꞌ mia parenda karua ia ra sa.” ");
INSERT INTO row_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Basa ma, meser agama ra olaꞌ seluꞌ ro Yesus rae, “Memaꞌ! Papa nafadꞌe naa, tebꞌeꞌ. Lamatualain dadꞌi hita malangga na, ma nda hambu Lamatuaꞌ laen sa ena. ");
INSERT INTO row_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Hita musi sue Eni lenaꞌ basa e, losa hita hii eni, tahine eni, ma manggate tungga hihii-nanau na. Hita o musi sue atahori, onaꞌ a hita sue ao tara. Hita bisa tungga parenda lain ra, te mete ma hita tungga parenda karuaꞌ naa ra, Lamatualain namahoꞌo lenaꞌ. Hita bisa fee banda tutunu-hohotuꞌ a, do tutunu-hohotuꞌ laen, te mete ma hita tungga parenda karuaꞌ naa ra, Ana namahoꞌo lenaꞌ.” ");
INSERT INTO row_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Rena nataa naꞌo naa, Yesus dꞌua nae meser agama ia nahine no maloleꞌ ena. De Yesus nae, “Ho maeꞌ a dadꞌi Lamatualain atahorin.” Basa naa, nda hambu atahori laen rambarani raselu-bale ro Yesus, huu nda hambu atahori rasenggiꞌ E sa ena. ");
INSERT INTO row_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Leleꞌ Yesus feꞌe nanori atahori ra sia Ume Hule-oꞌe Huuꞌ a, natane se nae, “Tungga hei dudꞌuꞌa ma, naa taꞌo bee? Meser agama ra ranori rae Kristus naa, atahori fo Lamatualain dudu basa mia fai maꞌahulu na. Tungga sira, Eni akaꞌ a Mane Daud a tititi-nonosi na. Te naa nda tebꞌe sa. ");
INSERT INTO row_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Fai maꞌahulu na Lamatualain Dula-Dale Meumareꞌ na pake Daud fo suraꞌ nae, ‘Lamatualain nafadꞌe basa neu au malangga ngga nae, “Uma endoꞌ muu mamana maloleꞌ sia Au bobꞌoa ona ngga. Dei fo Au tao musu mara losa ara taꞌalok neu nggo.’” ");
INSERT INTO row_vpl VALUES ("MK12_37a","071_12_37a","MRK","12","37a","37a","Mia naa nema hita hambu tahine tae mane Daud noꞌe Kristus, nae ‘Malangga’. Sosoa na, mete ma atahori rae Kristus akaꞌ a mane Daud tititi-nonosi na, naa nda feꞌe dai sa! Huu Eni o dadꞌi Mane Daud malangga na boe! ");
INSERT INTO row_vpl VALUES ("MK12_37b","071_12_37b","MRK","12","37b","37b","Yesus olaꞌ taꞌo naa ma, atahori naeꞌ hii rena E. ");
INSERT INTO row_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ana nafadꞌe seluꞌ se nae, “Hei musi besa-bꞌesa mbali meser agama ra. Ara hiiꞌ a pake sira badꞌu naru nara, lao-lao reu randaa ro atahori naeꞌ, fo ara rae, ‘We! Sira atahori moko, o!’ ");
INSERT INTO row_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Mete ma risiꞌ ume hule-oꞌe a, do tungga fefetas, ara sangga mamana eꞌendoꞌ maloleꞌ, fo atahori naeꞌ rita se. ");
INSERT INTO row_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","De besa-bꞌesa! Te ara boe o hii a peko-leleloꞌ ina falu ra, fo lea rala basa ume nara. Sia atahori naeꞌ mata na, ara tatana deꞌulaka nara, ma rambariiꞌ hule-oꞌe doo na seli. Sira hiiꞌ a fo atahori rafadꞌe rae sira rala nara meuꞌ. Te dei fo Lamatualain fee huku-dokiꞌ monaeꞌ neu se.” ");
INSERT INTO row_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Basa naa, Yesus neu endoꞌ mbali, peti kolete a mia Ume Hule-oꞌe Huuꞌ a. Ana mete atahori ra rema mbedꞌa doi kolete neu peti kolete a rala. Ana nita atahori mamasuꞌi-maꞌenaꞌ ra rema mbedꞌa doi kolete naeꞌ nisiꞌ peti rala neu. ");
INSERT INTO row_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Basa ma, ina falu mana tudꞌa-loloeꞌ esa o nema tungga hule-oꞌe. Ana mbedꞌa doiꞌ sen rua nisiꞌ peti a. Doiꞌ naa, feli na mbeiꞌ na sala. ");
INSERT INTO row_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Basa ma Yesus kaper mana tungga nara nae, “Hei mete matalolole ina falu mana tudꞌa-loloeꞌ naa. Ana fee akaꞌ doiꞌ sen ruaꞌ a, te ana fee nalenaꞌ basa atahori ra. ");
INSERT INTO row_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Atahori laen ra basa se fee doi kolete mia sira doi sisa nara. Te ina falu ia, fee nabasaꞌ doi nara reu Lamatualain. Nda hela mbei sa bee.” ");
INSERT INTO row_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Basa ma, Yesus no mana tungga nara rae lao hela Ume Hule-oꞌe Huuꞌ a. Ara kalua, ma mana tungga na esa dudu ume hule-oꞌe naa, de nafadꞌe nae, “Papa, e! Mete dei! Ume ia meulau na seli! Ara dama fatu monaeꞌ nara malole na seli! ");
INSERT INTO row_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Te Yesus nataa nae, “Ume ia memaꞌ maloleꞌ! Nda doo saꞌ te, atahori raseaꞌ hendi fatu ia ra.” ");
INSERT INTO row_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Basa boe ma, Yesus se lao risiꞌ Lete Saitun, de endoꞌ mbali Ume Hule-oꞌe Huuꞌ a. Basa ma, mana tungga nara haa rema ola-olaꞌ ro mesaꞌ ne. Sira ia ra, Petrus, Yakobis, Yohanis, ma Anderias. ");
INSERT INTO row_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Ratane rae, “Papa! Sobꞌa mufadꞌe seluꞌ oꞌola ma faꞌ ra. Fai hiraꞌ fo fai na losa? No tatanda nara, onaꞌ beeꞌ?” ");
INSERT INTO row_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Basa ma Yesus nataa nae, “Sadꞌi hei minea matalolole! Fo afiꞌ edi rala hei. ");
INSERT INTO row_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Te atahori mataꞌ-mataꞌ rema toꞌo tenda nara rae, ‘Au ia, Kristus, atahori fo Lamatualain helu-fuli mia fai maꞌahulu na!’ Boe ma ara edꞌi rala atahori naeꞌ. ");
INSERT INTO row_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Mete ma hei mita atahori ratati, do hei rena siuꞌ rae, hambu netatiꞌ sia bee-bꞌee na, hei afiꞌ mimitau. Te mana onaꞌ naa ka, musi dadꞌi dei. Te huu fai mateteꞌe na, nda feꞌe losa sa. ");
INSERT INTO row_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Leleꞌ naa, leo esa natati no leo laen. Nusa esa natati labꞌan no nusaꞌ laen. Hambu rae a nanggenggo sia bee-bꞌee. Ndoe-laꞌas o sia bee-bꞌee. Basa tatanda ia ra, onaꞌ inaꞌ mana feꞌe namedꞌa nae bꞌonggi. ");
INSERT INTO row_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","De hei musi minea matalolole! Te ara rema humu rala hei fo ro hei misiꞌ mamana nggenggero agama. Ma ara poko-paru hei sia ume-ume hule-oꞌe rala. Ara o paꞌa rendi hei misiꞌ atahori mana toꞌu koasa, huu hei tungga Au. Sia naa hei kaꞌe mala fo mifadꞌe Au dala malole ngga neu se. ");
INSERT INTO row_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Te Lamatualain atahori nara musi reu rafadꞌe raꞌahuluꞌ Au Hara-lii Malole ngga neu basa leo sia raefafoꞌ ia, dei fo fai mateteꞌe na losa. ");
INSERT INTO row_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Misinedꞌa! Mete ma ara paꞌa rendi hei misiꞌ mamana nggenggero a, hei afiꞌ mimitau mae, ‘Au olaꞌ taꞌo bee? Au utaa ae saa?’ Mete ma fai naa losa ena, hei olaꞌ tungga saa fo Lamatualain Dula-Dale Meumareꞌ na nafadꞌe hei. ");
INSERT INTO row_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Sia ume sa rala, mete ma hambu atahori ramahere Au, odꞌi-aꞌa nara mesaꞌ se sangga dalaꞌ fo risa e. Mete ma anaꞌ a namahere, ama na mesaꞌ ne nisa e. Mete ma papa no mama ramahere, ana nara tao risa se. ");
INSERT INTO row_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Atahori ra ramanasa hei, huu mimihere Au. Te seka naꞌatataaꞌ losa basa, dei fo Lamatualain fee ne masodꞌa.” ");
INSERT INTO row_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yesus olaꞌ nakandoo nae, “Atahori esa nae nema. Eni deꞌulaka na seli. Ana nambariiꞌ sia mamanaꞌ meumare sia Ume Hule-oꞌe Huuꞌ a. Ana nda nandaa no mananaꞌ naa sa, losa eni tao melu-mudꞌu. Naa de, Lamatualain hiruꞌ nasadea hela mamanaꞌ naa. Mete ma hei mita taꞌo naa, besa-bꞌesa! (Seka mana baca ia, musi besa-bꞌesa o!) Naa dadꞌi netudꞌuꞌ nae fai-fai sususaꞌ a losa lelesu a bafa na ena. Mete ma mita taꞌo naa ena, atahori sia propinsi Yudea, fela mela misiꞌ leteꞌ a leo. ");
INSERT INTO row_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Musti melaꞌ lai-lai, fo afiꞌ doidꞌoso. Mete ma kalua hela ume ena, afiꞌ baliꞌ haꞌi bua-loꞌas fai. ");
INSERT INTO row_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Atahori mana sia osi a, afiꞌ baliꞌ haꞌi lafe fai. Te mela mikindoo leo. ");
INSERT INTO row_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kasian lenaꞌ ina mairuꞌ, no mama mana rasusu ana diki mana mbilaꞌ ra. Te sira nda bisa relaꞌ haelai sa. ");
INSERT INTO row_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","De malole lenaꞌ hei hule-oꞌe fo moꞌe dala deꞌulakaꞌ naa, afiꞌ tudꞌa nandaa no fai udꞌan. ");
INSERT INTO row_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Te faiꞌ naa, sususa na seli! Eniꞌ a mia Lamatualain tao raefafoꞌ losa ia, atahori-atahori nda feꞌe hambu rita sususa monaeꞌ mataꞌ naa saꞌ bee. De atahori nda rita seluꞌ sususaꞌ mataꞌ naa saꞌ ena. ");
INSERT INTO row_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Mete ma Lamatualain nda naꞌaꞌeꞌeku fai naa sa, nda hambu atahori esa o naꞌatataaꞌ nasodꞌa saꞌ bee. Te huu Lamatualain sue atahori fo Ana tengga nalaꞌ ra, naa de Ana naꞌaꞌeꞌeku fai susa-sonaꞌ naa ra. ");
INSERT INTO row_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Mete ma fai naa losa, hei rena atahori rae, ‘Mete dei! Kristus sia ia!’ Te atahori feꞌa ra rae, ‘Kristus sia naa!’ Te hei onaꞌ rena e! ");
INSERT INTO row_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Te hambu atahori kalua fo toꞌo tenda nara rae, ‘Au ia, Kristus!’ Ruma fali rae, ‘Au ia, Lamatualain mana dui-bꞌengga na.’ Ara ratudꞌu mana dadꞌi mataꞌ-mataꞌ pake nitu a koasa na, fo ara peko-lelekoꞌ atahori. Ara sobꞌa-sobꞌa Lamatualain atahori nara fo edꞌi rala se! ");
INSERT INTO row_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","De hei musi minea matalolole! Fai sususaꞌ naa ra nda feꞌe losa sa, te Au fee hela nesenenedꞌaꞌ neu hei! ");
INSERT INTO row_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Basa ma Yesus tute nafadꞌe mbali mana tungga nara nae, “Mete ma faiꞌ sususaꞌ naa ra basa, ‘Relo a dadꞌi maꞌahatuꞌ. Fulan o nda manggareloꞌ saꞌ ena. ");
INSERT INTO row_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Nduuꞌ ra tudꞌa mia lalai a, no basa koasa sia lalai a dadꞌi sea-sasaraꞌ! ");
INSERT INTO row_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Basa naa, dei fo basa atahori mete-rita Au, Atahori Matetuꞌ ia. Te Au onda mia lalai a o leleeꞌ fo basa atahori ra rita Au koasa ngga, ma mandete-masaꞌa ngga! ");
INSERT INTO row_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Basa naa, Au denu Lamatualain ate nara mia sorga reu raꞌabꞌue atahori fo Au tengga alaꞌ ra mia raefafoꞌa suu na, mia rulu losa muri, mia dii losa ona. ");
INSERT INTO row_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yesus olaꞌ nakandoo nae, “Au haꞌi nekendandaaꞌ mia hau. Mete ma roo na sangga fula, naa tatandaꞌ fai matobꞌiꞌ a deka-deka nema. ");
INSERT INTO row_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Taꞌo naa boe, mete ma hei mita fai-fai sususaꞌ naa nema, naa tatanda Au deka-deka uma. ");
INSERT INTO row_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Rena matalolole! Mia basa atahori mana masodꞌaꞌ leleꞌ ia, hambu ruma nda feꞌe mate sa, te fai sususaꞌ naa nema ena. ");
INSERT INTO row_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mae lalai no raefafoꞌ a mopo, te Au oꞌola ngga ia nda basa sai-sai sa. ");
INSERT INTO row_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Yesus o olaꞌ nae, “Nda hambu atahori esa fo bubꞌuluꞌ faiꞌ bee no leleꞌ bee Au uma baliꞌ sa. Lamatualain ate nara sia sorga, o nda rahine sa. Au ia o, nda uhine sa. Akaꞌ a Au Ama ngga nahine. ");
INSERT INTO row_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Naa de, hei musi minea matalolole, te hei nda bubꞌuluꞌ faiꞌ bee Au baliꞌ sa. ");
INSERT INTO row_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nda doo saꞌ te, Au lao hela hei, te Au heoꞌ baliꞌ. Onaꞌ atahori mana lao hela ume na, fo lao nisiꞌ mamana dodꞌooꞌ. Ana denu mana tungga nara fo tao malolole ume naa. Boe ma ana banggi fee se esa-esaꞌ no ue-tatao na. Ana parenda mana manea lelesu a, fo nanea matalolole, losa eni baliꞌ. ");
INSERT INTO row_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Hei o musi minea hatuꞌ-rerelon, te hei nda bubꞌuluꞌ fain saa tenu umeꞌ a nema sa. Baliꞌ bobꞌoꞌ do, fai banggi ruaꞌ do, relo mamatetuꞌ do, relo a todꞌa saa. Hei nda bubꞌuluꞌ fain saa saꞌ boe. ");
INSERT INTO row_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Afiꞌ losa ana nema aiboiꞌ, te hambu hei sungguꞌ masambetaꞌ. ");
INSERT INTO row_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","De saaꞌ fo Au ufadꞌe hei ia, Au o ufadꞌe basa atahori feaꞌ ra ae, ‘Hei musi minea matalolole fo simbo Au nenema ngga.’” (Losa naa, Lamatuaꞌ Yesus naloeꞌ ola-olaꞌ no mana tungga nara mia Lete Saitun.) ");
INSERT INTO row_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","2","Basa ma, malangga agama Yahudi ra feꞌe sangga dalaꞌ fo humu Yesus no nee-nee, te ara rae risa E. Ara rae, ‘Nehati dei! Te fai-fai malole a deka ena. Hita afiꞌ humu E dei, afiꞌ losa atahori ramue.” Ara ola-olaꞌ taꞌo naa, huu hela feꞌe fai rua fali, te atahori Yahudi fai malole nara, fo ara babꞌae, rae ‘Fai Paska’ no ‘Fefeta roti nda tao bibit sa’. Sia fai maloleꞌ naa ra, ara rasanedꞌa fai maꞌahulu naa, leleꞌ sira bei-baꞌi nara lao hela nusa Masir. ");
INSERT INTO row_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Sia kambo Betania, hambu atahori esa, nara na Simon. Maꞌahulu na, eni namahedꞌi kusta. Te ia naa, ana hai ena. Fai malole ra nda feꞌe losa sa, Yesus se reu raa mia Simon ume na. Leleꞌ ara raa, inaꞌ esa masoꞌ rala neu. Ana toꞌu boto fatuꞌ esa. Isi na mina maꞌameniꞌ mafelit. Basa ma, inaꞌ a helu-tiku botoꞌ a tatana na. De ana mboꞌa nandali mbei-mbei neu Yesus langga na, fo fee hadꞌat neu E. ");
INSERT INTO row_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Te hambu atahori laen hira tungga raa sia naa boe. Rita inaꞌ a tao taꞌo naa, ara ramanasa, de olaꞌ koao rae, “Hmm! Ina saa a ia! Ana mboꞌa hendi parsumaꞌ a mina maꞌameni mafelit a! ");
INSERT INTO row_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Malole lenaꞌ seo, fo banggi doi naa ra, neu mana toꞌataꞌ ra! ");
INSERT INTO row_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Te Yesus naselu nae, “Hei onaꞌ miꞌisususaꞌ inaꞌ ia! Hela neu! Au umuhoꞌo, huu ana mboꞌa mina maꞌameniꞌ ia neu langga ngga. ");
INSERT INTO row_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Atahori mana toꞌataꞌ ra raꞌabꞌue ro hei rakandoo a. De hei bisa tulun se sudꞌiꞌ a leleꞌ bee. Te nda doo saꞌ ena, Au nda uꞌubꞌue o hei sa. ");
INSERT INTO row_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Au masodꞌa ngga nda doo saꞌ ena. No mboꞌa mina ia a, inaꞌ ia sadꞌia memaꞌ au ao ngga, soa neu au fai naꞌoi ngga. ");
INSERT INTO row_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Misinedꞌa matalolole! Sia bee atahori dui-bꞌenggaꞌ Lamatualain Hara-lii Malole na, sa naa o ara dui-bꞌengga inaꞌ ia tatao malole na, fo basa atahori rasanedꞌa e. ");
INSERT INTO row_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Boe ma Yesus mana tungga kasanahulu rua nara esa, nara na Yudꞌas Iskariot, neu sangga malangga agama Yahudi ra, fo seo Yesus neu se. Nandaa no se, ma nafadꞌe dudꞌuꞌa na. ");
INSERT INTO row_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Leleꞌ ara rena boe, ramahoꞌo seli. Ara helu rae, “Mete ma ho seo Yesus na, hai bae.” Boe ma Yudꞌas dea neu, sangga dalaꞌ fo fee Yesus neu se. ");
INSERT INTO row_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Faiꞌ naa, fai kaesaꞌ mia atahori Yahudi fai malole na. No fai naa, ara tunu roti nda tao bibit sa, ma mbau bibꞌi lombo. Leleꞌ naa, Yesus mana tungga nara rema ratane E rae, “Papa! Faiꞌ ia, hita fai malole Paska. De Papa nau hai mi sadꞌia nanaat sia ume bee?” ");
INSERT INTO row_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Basa ma, Yesus denu mana tungga nara rua nae, “Hei mi miꞌihuluꞌ misiꞌ kota. Sia naa hei mindaa mo touꞌ esa, nasaa oe nggusi esa. Hei tungga e leo. ");
INSERT INTO row_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Mete ma ana ume rala neu, hei tungga e. Mifadꞌe tenu umeꞌ a mae, ‘Papa! Hai papa meser ma noꞌe kama esa fo tao fefeta Paska no mana tungga nara. ");
INSERT INTO row_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Dei fo ana natudꞌuꞌ kama loaꞌ esa sia tadꞌaꞌ ata ka. Ana sadꞌia nala kama ena. Helaꞌ a hei sadꞌia nanaat.” ");
INSERT INTO row_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Boe ma ruꞌa se lao kota reu. Sia naa, randaa ro saa fo Yesus nafadꞌe se. Ara sadꞌia basaꞌ e, fo sira raa fefeta Paska sia naa. De ruꞌa se reu roꞌe Yesus no mana tungga laen ra. ");
INSERT INTO row_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Relo a mopo boe, Yesus no mana tungga kasanahulu rua nara lao reu. ");
INSERT INTO row_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Basa ma ara endoꞌ, de raa raꞌabꞌue. Ara raa boe, Yesus olaꞌ nae, “Rena, e! Esa mia hei, nau seo Au neu atahori laen ra.” ");
INSERT INTO row_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Rena taꞌo naa, rala nara mera. Esa-esa natane Yesus nae, “Nda au sa, to?” ");
INSERT INTO row_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","De Yesus nataa nae, “Atahori mana boroꞌ roti nisiꞌ manggo a rala naꞌabꞌue no Au, naa eni mana seo Au. ");
INSERT INTO row_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Misinedꞌa e! Au ia, Atahori Matetuꞌ. Au musi mate onaꞌ ara suraꞌ memaꞌ sia Lamatualain susura na. Te, besa-bꞌesa! Atahori mana seo Au, ana lemba huku-doki na! Malole lenaꞌ, mama na afiꞌ bꞌonggi e! ");
INSERT INTO row_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Leleꞌ ara feꞌe raa, Yesus haꞌi nala roti bueꞌ esa, de noꞌe makasi neu Lamatualain. Ana bibꞌibꞌi roti a, de soro fee mana tungga nara, ma nafadꞌe nae, “Roti ia, Au ao ngga. Haꞌi, fo mia leo.” ");
INSERT INTO row_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Basa ma, Ana haꞌi nala oe anggor nggalas esa. Ana noꞌe makasi neu Lamatualain, de loo nggalas naa neu mana tungga nara fo rinu. ");
INSERT INTO row_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nafadꞌe nae, “Oe anggor ia, Au raa ngga. Raaꞌ ia nandali fo fee masodꞌaꞌ neu atahori naeꞌ. Raaꞌ ia o dadꞌi nesenedꞌaꞌ nae, “Saa fo Lamatualain helu, memaꞌ dadꞌi ena. Haꞌi, fo minu leo. ");
INSERT INTO row_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Rena! Au nda inu seluꞌ oe anggor sa, losa Ama ngga sia sorga endoꞌ parenda.” ");
INSERT INTO row_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Basa boe ma, ara sodꞌa sosodꞌat esa fo koa-kio Lamatualain. Basa ma ara dea reu de lao risiꞌ Lete Saitun. ");
INSERT INTO row_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ara laoꞌ boe ma, Yesus nafadꞌe memaꞌ nae, “Tetembaꞌ ia, basa hei mela hela Au. Te ara suraꞌ memaꞌ sia Lamatualain susuraꞌ na nae, ‘Lamatualain nisa manatadꞌa, de bibꞌi lombo nara rela sea-saranggaa.’ ");
INSERT INTO row_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Au memaꞌ mate. Te leleꞌ Au usodꞌa baliꞌ naa, Au lao uꞌuhuluꞌ hei isiꞌ propensi Galilea.” ");
INSERT INTO row_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Rena Yesus ola taꞌo naa, Petrus nda nau sa, de nae, “Papa! Mae atahori laen ra basa se rela hela Papa o, te au hokoꞌ!” ");
INSERT INTO row_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesus nataa nae, “Petrus! Musunedꞌa, e! Tetembaꞌ ia, manu ra nda feꞌe koꞌo-kee lao rua sa, te ho olaꞌ lao telu mae ho nda muhine Au sa! ");
INSERT INTO row_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Te Petrus nataa seluꞌ fai nae, “Hokoꞌ, Papa! Mete ma Papa mate, au o mate tungga boe. Te au nda ela hela Papa sa!” Petrus nono nara o, basa se raꞌo naa boe. ");
INSERT INTO row_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Basa naa, Yesus se laoꞌ rakandoo losa osi esa sia Lete Saitun, nara na ‘Getsemani’. Boe ma Yesus nafadꞌe mbali se nae, “Hei endoꞌ mihani ia. Au ae uu hule-oꞌe sia naa.” ");
INSERT INTO row_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Boe ma Yesus noꞌe Petrus, Yakobis, ma Yohanis, fo reu raꞌabꞌue ro E. Mia faiꞌ naa, Yesus rala na namedꞌa susa no nda malololeꞌ sa. ");
INSERT INTO row_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ana nafadꞌe se nae, “Au rala ngga susa nala seli! Au medꞌa na onaꞌ a Au ae mate. Hei endoꞌ minea sia ia.” ");
INSERT INTO row_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Basa ma Ana lao naꞌadꞌooꞌ mbei. Boe ma sendeꞌ lululangga na neu rae a, de hule-oꞌe nae, “Papa e! Mete ma Papa hii naa, afiꞌ fee Au lemba doidꞌosoꞌ naa losa mate. Au bubꞌuluꞌ memaꞌ ae, nda hambu sa fo Papa nda bisa tao sa. Mete ma bisa, Papa naꞌadꞌodꞌoo hendi doidꞌosoꞌ ia mia Au. Te afiꞌ tungga Au hihii ngga; tungga akaꞌ a Papa hihii na.” ");
INSERT INTO row_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Basa ma, Ana baliꞌ nisiꞌ mana tungga katelu nara, te ara sungguꞌ rasambeta ena. Ana fafae se, de olaꞌ no Petrus nae, “He! Petrus! Ho sungguꞌ, do? Au ma naa nda doo sa, te hei nda bisa minea mbei saꞌ boe! ");
INSERT INTO row_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ose mumeu mata ma dei, fo fela munea mo Au! Hei rala mara memaꞌ dꞌua tao maloleꞌ, te huu au sisi mara nda beꞌi sa. De malole lenaꞌ hei hule-oꞌe, fo mete ma hambu sosobꞌa-dꞌodꞌouꞌ naa, hei nda tudꞌa sa.” ");
INSERT INTO row_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Basa ma Yesus neu hule-oꞌe seluꞌ lao esa fai. Ana noꞌe seluꞌ neu Lamatualain, fo afiꞌ fee Eni lemba doidꞌosoꞌ naa. ");
INSERT INTO row_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Basa ma Ana baliꞌ nisiꞌ mana tungga katelu nara. Te ara sungguꞌ baliꞌ fai, te mata nara nduar seli. Basa ma Ana fafae seluꞌ se, te ara nda ritaꞌ rae rataa saa mbali E saꞌ boe. ");
INSERT INTO row_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Basa naa, Yesus lao hela se, de neu hule-oꞌe lao katelu na. Basa ma, Ana baliꞌ de fafae se nae, “Hei feꞌe sungguꞌ fai, do? Dai ena! Fela leo! Te atahori mana nae seo Au, Atahori Matetuꞌ ia, ana deka ena. Ia naa, ara rae humu Au ena, fo fee neu atahori deꞌulaka ra lima na. ");
INSERT INTO row_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Fela leo! Milaa mata mara fo mete sobꞌa sia naa dei! Atahori mana nae seo Au a, nema ena. Ima fo teu tandaa to se! ");
INSERT INTO row_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Leleꞌ Yesus feꞌe olaꞌ naꞌo naa, aiboiꞌ ma, Yudꞌas nema no atahori naeꞌ. Ara rema rendi tafaꞌ no hau eꞌetuꞌ, fo rae humu Yesus. Ara tao taꞌo naa, tungga parendaꞌ mia malangga agama Yahudi ra, meser agama ra, ro lasi adat ra. ");
INSERT INTO row_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yudꞌas nafadꞌe memaꞌ neu se nae, “Mete malolole! Seka fo au idꞌu e, hei humu mala E leo! Atahori fo hei sangga a, naa Eni ena! ");
INSERT INTO row_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yudꞌas se losa naa ma, ana neu nandaa no Yesus. Natea nae, “Papa Meser!” De ana holu ma idꞌu E. ");
INSERT INTO row_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Boe ma, atahori naeꞌ mata reu, de humu rala Yesus. ");
INSERT INTO row_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Te Yesus atahori na esa lesu nala tafa na, de soe atahori esa ndiki roo na. Atahori maꞌahinaꞌ naa, malangga manae agama Yahudi aten. ");
INSERT INTO row_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Basa ma Yesus olaꞌ no atahori mana rema humu E nae, “Taꞌo bee? Hei mae Au ia atahori deꞌulakaꞌ, do? De hei ima humu Au mendi tafaꞌ no hau eꞌetuꞌ! ");
INSERT INTO row_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Tungga fai, Au unori hei sia Ume Hule-oꞌe Huuꞌ a, te nda hambu atahori esa fo nema humu Au saꞌ bee. Humu Au leo! Te ara suraꞌ memaꞌ taꞌo naa mia fai maꞌahulu na sia Lamatualain susuraꞌ na. ");
INSERT INTO row_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Leleꞌ naa, Yesus mana tungga nara ramatau seli. De rela hela mesaꞌ ne. ");
INSERT INTO row_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Sia naa o hambu atahori soru esa tungga-tungga Yesus dea na. Ana mboti ao na nendiꞌ temeꞌ eꞌetuꞌ esa. Atahori ra o rae humu e boe, ");
INSERT INTO row_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","te ara toꞌu rala akaꞌ a eni teme na. De ana nela no maꞌahola na, huu namatau nae mate na. ");
INSERT INTO row_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Basa ma, ara toꞌu rendi Yesus nisiꞌ malangga manae agama Yahudi umen. Sia naa, atahori moko ra raꞌabꞌue ena. Ia eni, malangga agama ra, meser agama ra, ro lasi adat ra. ");
INSERT INTO row_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Leleꞌ ara toꞌu rendi Yesus, Petrus naꞌafuniꞌ tungga-tungga deaꞌ, losa malangga manae agama Yahudi ume na. Ana o nisiꞌ nembeleo na rala, de endoꞌ no atahori mana dara ai ra. ");
INSERT INTO row_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Sia ume naa rala, malangga agama ra ola-olaꞌ ro atahori mana endoꞌ sia mamana nggengero agama. Basa se sangga dalaꞌ fo rae fee salaꞌ neu Yesus, fo rae hukun risa e. Te ara nda hambu dalaꞌ saa-saa saꞌ bee. ");
INSERT INTO row_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Boe ma ara roꞌe rala sakasii naeꞌ fo rae raꞌatutudꞌa Yesus. Te sira dedꞌea ola na, esa nda nandaa no esa saꞌ bee. ");
INSERT INTO row_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Boe ma hambu sakasii hira fela rambariiꞌ, de olaꞌ peko-lelekoꞌ rae, ");
INSERT INTO row_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Hai rena atahori ia olaꞌ nae, ‘Au ndefaꞌ hendi Ume Hule-oꞌe Huuꞌ a fo atahori rafafela rendiꞌ limaꞌ. Finiesa na ma, Au ufefela baliꞌ e, te nda pake atahori liman sa. ");
INSERT INTO row_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Te sira oꞌola nara boe, esa nda nandaa no esa saꞌ bee. ");
INSERT INTO row_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Basa ma malangga manae agama Yahudi, fela nambariiꞌ mia atahori mata nara mana endoꞌ mia mamana nggengeroꞌ naa. Ana natane Yesus nae, “Atahori naeꞌ kalaak ho ena. Te, saa de ho nee-neeꞌ a?” ");
INSERT INTO row_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yesus nda olaꞌ saa-saa saꞌ boe. Basa ma malangga manaeꞌ a natane seluꞌ nae, “Mutaa dei! Memaꞌ Ho ia, tebꞌe-tebꞌeꞌ Kristus, Lamatualain Ana na fo Ana helu-fuli mia maꞌahulu na, do?” ");
INSERT INTO row_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesus nataa nae, “Memaꞌ tebꞌe! Au ia eni. Basa fo hei mete-mita Au, Atahori Matetuꞌ ia, endoꞌ sia sorga sia Lamatualain bobꞌoa ona na. Lamatualain naa, koasa na mana seliꞌ! Au o E miꞌibꞌue toꞌu parendaꞌ! Basa naa boe, Au onda mia sorga o leleeꞌ a. ");
INSERT INTO row_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Rena Yesus olaꞌ naꞌo naa ma, malangga manaeꞌ a namanasa, losa ana sidꞌa nalutu badꞌu naru na. Basa ma ana nafadꞌe atahori mana endoꞌ sia mamana nggengero naa nae, “Hita nda parlu sangga sakasii seluꞌ sa! ");
INSERT INTO row_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Hei rena no ndiki mara, Eni mesaꞌ ne olaꞌ naꞌo naa, to? Ana soꞌu ao na dadꞌi Lamatualain Ana na. Ia neꞌemutis! Tungga atoran agama, mete ma atahori tao ao na onaꞌ Lamatualain, atahori naa musi mate! De ia naa, hei mae nggero taꞌo bee? Boe ma basa se nggero rae, “Atahori ia memaꞌ sala ena! De ana musi hambu hukun mate!” ");
INSERT INTO row_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Basa ma atahori bꞌaꞌubꞌe mata reu puras miru neu Yesus. Ara mboti rala mata na, de tutu E. Basa ma ratane rae, “Mete ma ho muꞌena koasa naa, rai sobꞌa. Seka tutu Nggo?” Basa ma ara parenda atahori mana manea Ume Hule-oꞌe Huuꞌ a, fo rema ro Yesus. Ara ro Yesus neu, no mbasa raꞌamiminaꞌ E. ");
INSERT INTO row_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Leleꞌ naa, Petrus feꞌe endoꞌ sia nembeleo naa. Sia naa o hambu malangga manae agama Yahudi ate ina na esa. Ana nema nita Petrus dara ai. Ana mete namemeu mata na, ma olaꞌ nae, “Faꞌra, ho o tungga muꞌubꞌue mo Yesus, atahori Nasaret naa. Ia, to?” ");
INSERT INTO row_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Te Petrus nataa nae, “Hokoꞌ! Taꞌo bee de mutane taꞌo naa! Au nda uhine Eni sa.” Basa naa ma, Petrus kalua neu nambariiꞌ sia lelesu ineꞌ a. Nandaa no leleꞌ naa ma, manu a koꞌo-kee boe. ");
INSERT INTO row_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Basa ma, inaꞌ a nita seluꞌ Petrus. De nafadꞌe atahori mana sia naa ra nae, “Atahori ia, esa mia sira!” ");
INSERT INTO row_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Te Petrus nareresi nae, “Seꞌute ho muluꞌ! Au nda uhine atahori naa sa, ma!” Nda doo saꞌ fali ma, atahori feaꞌ ra olaꞌ seluꞌ neu Petrus rae, “He! Ho feꞌe pepekoꞌ mae ho nda muꞌubꞌue mo atahori naa ra sa!? Wei! Basa hei, atahori Galilea, to?” ");
INSERT INTO row_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Te Petrus labꞌan seluꞌ nae, “We! Au sumba! Au nda uhine atahori naa sa! ");
INSERT INTO row_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Nandaa no ana olaꞌ naꞌo naa ma, manu a koꞌo-kee lao rua boe. Petrus nasanedꞌa Yesus dedꞌea na faꞌ ra nae, “Manu a nda feꞌe koꞌo-kee lao rua sa, te ho mufunii Au lao telu ena.” Nasanedꞌa nala taꞌo naa boe ma, ana nggae ei-ei. ");
INSERT INTO row_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Feꞌe fefetu anaꞌ na, basa atahori sia mamana nggengero naa, maꞌiraꞌ fo rae risa Yesus. Basa ma ara paꞌa ro E neu nandaa no Hofernor Pilatus. ");
INSERT INTO row_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Losa hofernor, ana natane Yesus nae, “Taꞌo bee? Ho ia, tebꞌe-tebꞌe atahori Yahudi Mane na, do?” Yesus nataa nae, “Tebꞌe! Papa hofernor olaꞌ ndaa.” ");
INSERT INTO row_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Basa ma malangga agama ra olaꞌ ro hofernor rae, “Atahori ia tao salaꞌ nda mbei-mbeiꞌ a sa!” Boe ma ara rafadꞌe sala nara, esa-esaꞌ. ");
INSERT INTO row_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Basa ma hofernor natane seluꞌ Yesus nae, “Ho nda rena oꞌola nara sa, do? Ara fee salaꞌ nae-nae neu Nggo. Sobꞌa mutaa dei!” ");
INSERT INTO row_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Te Yesus nda nataa saa-saa sa bee, losa hofernor a ndii-ndiiꞌ a, de kakaus langga na. ");
INSERT INTO row_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Tungga too, nandaa no atahori Yahudi ra fefeta Paska na, hofernor mboꞌi hendi atahori bui esa. ");
INSERT INTO row_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Leleꞌ naa, atahori bui esa, nara na Barabas. Fai maꞌahulu na, ara humu e de tao e bui rala neu, huu ana labꞌan mana parenda Roma ra, ma nisa atahori boe. ");
INSERT INTO row_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Fefeta Paska deka-deka ena, naa de atahori naeꞌ risiꞌ Hofernor Pilatus, de rameli rae, “Papa Hofernor! Fai Paska nema ena! Meta ma bisa, Papa Hofernor tulun mboꞌi atahori bui sa sama onaꞌ biasa!” ");
INSERT INTO row_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Basa ma hofernor naselu nae, “Au mboꞌi see? Mete ma Au mboꞌi hendi atahori Yahudi mane na naa, hei nau, do?” ");
INSERT INTO row_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Hofernor olaꞌ taꞌo naa, tao-tao te ana nahine malangga agama ra ro Yesus nisiꞌ eni, huu ara nda hii E sa, ma rambedꞌa ralaꞌ ro E. ");
INSERT INTO row_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Te, malangga agama ra dudunggu-mbau atahori naa ra, de basa se roꞌe mbali hofernor rae, “Hai nda nau mboꞌi Yesus sa! Mboꞌi hendiꞌ a Barabas!” ");
INSERT INTO row_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Basa ma Hofernor natane seluꞌ nae, “Mete ma taꞌo naa, au musi tao saa mbali Yesus, fo ara roꞌe rae, ‘Mane Yahudi’?” ");
INSERT INTO row_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Boe ma basa se rameli randaa rae, “Tao misa E! Mbaku E neu hau ngganggeꞌ a!” ");
INSERT INTO row_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Basa ma hofernor natane nae, “Te Ana sala saa? Au paresaꞌ basa ena, te au nda hambu sala na saa-saa saꞌ boe!” Te basa se randuꞌ rahereꞌ seluꞌ rae, “Tao tisa E! Mbaku E neu hau ngganggeꞌ a leo!” ");
INSERT INTO row_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Hofernor nae tao namahoꞌoꞌ atahori naa ra rala nara, naa de, ana mboꞌi hendi Barabas, tungga hihii-nanau nara. Basa ma ana parenda atahori mana maneaꞌ ra, fo reu filo Yesus rendiꞌ ue. Filo basa ma, soldꞌadꞌu ra haꞌi rendi E, de reu mbaku risa E sia hau ngganggeꞌ a. ");
INSERT INTO row_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Basa ma, soldꞌadꞌu ra nore rendi Yesus nisiꞌ sira nembeleo monae na. Sia naa, ara roꞌe rala sira nono nara nononggo esa. ");
INSERT INTO row_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Boe ma ara fee Yesus pake badꞌu naruꞌ esa dula na mbila-maranggeoꞌ onaꞌ a maneꞌ biasa pake. Basa ma, haꞌi rala hau manggouꞌ a dana na de hano neu soloꞌ. Boe ma ara ndeni solo manggouꞌ a neu Yesus langga na, de tao raꞌamiminaꞌ onaꞌ a sira rae soꞌu mane feuꞌ pake solo panggat. ");
INSERT INTO row_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Boe ma, basa se fee hadꞌat neꞌemiminaꞌ neu E rae, “Sodꞌaꞌ Papa Mane Yahudiꞌ!” ");
INSERT INTO row_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Boe ma ara beꞌutee eꞌedik fee hadꞌat neu Yesus. Ma ara puras miru bali-baliꞌ neu mata na. Basa ma, ara hemba rasafafali E no hau. ");
INSERT INTO row_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ara raꞌamiminaꞌ basa E, boe ma olu hendi badꞌu naruꞌ a, de olu baliꞌ badꞌu na. Ara rendi E lao hela kota Yerusalem, de reu mbaku E sia hau ngganggeꞌ a losa mate. ");
INSERT INTO row_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Leleꞌ ara lao hela Yerusalem, randaa ro atahori esa mia dalaꞌ taladꞌan. Ana feꞌe nema mia kota Kirene. Nara na Simon, Aleksander no Rufus papa na. Ana nae nisiꞌ Yerusalem, te soldꞌadꞌu ra toꞌu rala e, de raꞌasusuꞌe lemba Yesus hau nggangge na. ");
INSERT INTO row_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ara rendi Yesus losa mamanaꞌ esa, nara na Golgota. Sosoa na nae, ‘mamana langga ruiꞌ’. ");
INSERT INTO row_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Sia naa, ara rae fee Yesus ninu oe anggor maꞌeiꞌ sambor no modꞌo, fo Ana naꞌatataaꞌ nembeta na. Te Yesus nda nau ninu sa. ");
INSERT INTO row_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Basa de, ara mbaku raꞌalelenggaꞌ Yesus mia hau ngganggeꞌ a. Boe ma ara raririi hau naa, nandaa no liꞌ sio fefetu na. Boe ma soldꞌadꞌu ra lea lot fo rae rahine seka hambu Yesus badꞌu na. ");
INSERT INTO row_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Basa ma ara suraꞌ sia papaꞌ esa rae, “Ia, Atahori Yahudi Mane na.” De ara mbaku neu Yesus langga na ataꞌ. No dalaꞌ naa, rafadꞌe saa de sira hukun Yesus. ");
INSERT INTO row_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Sia naa o, ara mbaku risa atahori naꞌo rua. Esa sia Yesus bobꞌoa ona na, ma esa sia bobꞌoa dii na. ");
INSERT INTO row_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","No taꞌo naa, memaꞌ ara tungga Lamatualain susuraꞌ na nae, “Ara tao E, onaꞌ a atahori deꞌulakaꞌ.” ");
INSERT INTO row_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Basa atahori mana laoꞌ tungga naa, rita Yesus mana mbakuꞌ sia hau ngganggeꞌ. Boe ma ara kakaler langga nara de olaꞌ raneneut Yesus rae, “Hoi! Ho mae, Ho bisa ndefaꞌ Ume Hule-oꞌe Huuꞌ a. Basa fo mufefela baliꞌ sia fai telu rala, to? ");
INSERT INTO row_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Sobꞌa Ho onda mia hau ngganggeꞌ a, fo mboꞌi hendi ao ma leo! Mete ma taꞌo naa, dei fo hai mimihere mae, Ho memaꞌ Lamatualain Ana na.” ");
INSERT INTO row_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Atahori Yahudi malangga agama ra, ma meser agama ra raneneut Yesus rae, “Ana tao nasodꞌa atahori laen, te nda nasodꞌa nala ao na sa! ");
INSERT INTO row_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Eni nafadꞌe Ao na nae ‘Kristus’, ia eni atahori fo Lamatualain helu memaꞌ mia maꞌahulu na. Atahori laen rae, ia Eni atahori Israꞌel mane na. Mete ma tebꞌe taꞌo naa, hela Eni onda mia hau ngganggeꞌ a fo hita tita dei. Naa, dei fo hita tamahere E.” Atahori karuaꞌ mana mbakuꞌ raꞌabꞌue ro Yesus sia hau ngganggeꞌ a, ara o raneneut boe. ");
INSERT INTO row_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Basa naa ma, maꞌahatuꞌ a tatana nala mamanaꞌ naa mia reorenduꞌ losa liꞌ telu bobꞌon. ");
INSERT INTO row_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Liꞌ telu bobꞌon boe ma, Yesus nameli no dedꞌea Aram nae, “Eloi! Eloi! Lama sabaktani?” sosoa na nae, “Au Lamatualain ngga! Au Lamatualain ngga e! Taꞌo bee de Papa hiruꞌ musudea hela Au taꞌo ia?” ");
INSERT INTO row_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Hambu atahori hira deka-deka sia naa rena Yesus hara na. Boe ma rae, “Hoi! Rena dei. Ana noꞌe Elia, Lamatualain mana dui-bꞌengga maꞌahulu na!” ");
INSERT INTO row_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Basa ma atahori esa nela-nelaꞌ neu haꞌi lolombuꞌ, de dombo neu oe anggor maꞌeiꞌ a rala. Boe ma ana dunggu lolombu naa neu teteas tonggo na, de deta neu Yesus nudꞌu na fo Ana musi. Basa ma, atahori naa olaꞌ nae, “Mihati fo mete sobꞌa! Se bubꞌuluꞌ mbei fo Elia nema na ondaꞌ E mia hau ngganggeꞌ a.” ");
INSERT INTO row_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Basa ma Yesus nameli seluꞌ fai, boe ma Ana mate. ");
INSERT INTO row_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Sia Ume Hule-oꞌe Huuꞌ a, hambu teme pepele monaeꞌ esa mana londaꞌ babata Lamatualain kama meumare na. Etu Yesus hahaen na, boe ma teme pepele naa sika banggi neu rua, mia ata losa raeꞌ. ");
INSERT INTO row_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Sia Golgota, hambu malangga soldꞌadꞌuꞌ esa nambariiꞌ deka Yesus hau nggangge na. Leleꞌ ana nita Yesus mamate na, ana nggengger nae, “Awi! Atahori ia, memaꞌ tebꞌe-tebꞌeꞌ Lamatualain Ana na, o!” ");
INSERT INTO row_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Hambu inaꞌ bꞌaꞌubꞌe rita Yesus mamate na mia a dodꞌooꞌ. Maꞌahulu na ara tao mataꞌ neu Yesus se mia Galilea. Inaꞌ naa ra, Salome, Maria mia kamboꞌ Magdala, ma Maria esa fali (Yakobis soruꞌ a no Yoses mama na). ");
INSERT INTO row_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Basa ma, hambu atahori esa sangga dalaꞌ fo naondaꞌ Yesus ao sisi na mia hau ngganggeꞌ a. Atahori naa, nara na Yusuf. Ana mia kota Arimatea. Eni o mana nggero-furi sia mamana nggenggeroꞌ agama Yahudiꞌ a. Rala na maloleꞌ. Eni o nahani Lamatualain parenda na nema. Yesus mamate na, nandaa no hari lima. De mbilaꞌ neu ma, nandaa no atahori Yahudi fai hule-oꞌe na. Naa de, Yusuf nda nau nahati losa mbilaꞌ fo feꞌe naondaꞌ Yesus ao sisi na. De ana nambararani rala na, fo neu noꞌe Yesus ao sisi na mbali Hofernor Pilatus. ");
INSERT INTO row_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Hofernor rena Yusuf noꞌe taꞌo naa, ana titindindii. Basa ma nae, “Awi! Atahori naa mate haelai! Au ae neꞌoko nda dadꞌi taꞌo naa sa!” Boe ma ana denu atahori reu roꞌe malangga soldꞌadꞌuꞌ a, de natane nae, “Taꞌo bee, e! Yesus mate ena, do feꞌe hokoꞌ?” ");
INSERT INTO row_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Malangga soldꞌadꞌuꞌ a nataa nae, “Ana memaꞌ mate faꞌ ra, Papa.” Hofernor rena taꞌo naa, boe ma nanggoloꞌ Yusuf fo neu haꞌi Yesus ao sisi na. ");
INSERT INTO row_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Basa de Yusuf lao Golgota neu, de naondaꞌ Yesus ao sisi na mia hau ngganggeꞌ a. Ana mboti malolole no teme feu mafelit. Leleꞌ naa, ara feꞌe paa basa rates sa sia mbuku fatuꞌ. Boe ma Yusuf se oꞌo rala Yesus ao sisi na, de tao rates rala neu. Boe ma ara lolir rala fatu bebelaꞌ monaeꞌ esa, de tatana ralolole neu rates a bafa na. Boe ma Yusuf se baliꞌ. ");
INSERT INTO row_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Leleꞌ naa, Maria mia Magdala no Maria laen (Yoses mama na), ara tungga losa naa. Ruꞌa se mete fo rasanedꞌa matalolole mamanaꞌ fo ara tao Yesus ao sisi na. ");
INSERT INTO row_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Mbilaꞌ, fo hari anam, atahori Yahudi fai hule-oꞌe na. Relo a tena, boe ma Maria mia kambo Magdala, Maria laen naa (Yakobis mama na) ma Salome, reu hasa mina maꞌameniꞌ, fo mbilaꞌ rae bibirus neu Yesus ao sisi na, tungga sira adat na. ");
INSERT INTO row_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Basa ma nggarei fefetu na, teluꞌ se risiꞌ rates. ");
INSERT INTO row_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Mia dalaꞌ taladꞌan ara ola-olaꞌ rae, “Wei! Seka bisa tulun oꞌo hendi fatu monaeꞌ mia rates a bafa na? Hita telu ia ra nda beꞌi sa, te fatu a monaeꞌ na seli! Te ara losa naa, rita fatu a faliꞌ hendi ena.” ");
INSERT INTO row_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Basa ma rates rala reu. Te ara nggengger, huu mete-rita atahori soruꞌ esa endoꞌ sia sira bobꞌoa ona nara, pake bua muti makahahadꞌoꞌ. ");
INSERT INTO row_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Boe ma atahori soruꞌ naa nafadꞌe se nae, “We! Afiꞌ mimitau! Au bubꞌuluꞌ hei ima mae sangga Yesus mia Nasaret. Ara risa E sia hau ngganggeꞌ a. Te Ana nda sia ia sa, huu nasodꞌa baliꞌ ena. Ima fo mete neuꞌ ena mamanaꞌ fo ara tao ao sisa na. Rouꞌ ena. ");
INSERT INTO row_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Hei baliꞌ lai-lai! Mifadꞌe Petrus se mae, Yesus nasodꞌa baliꞌ ena. Ana lao naꞌahuluꞌ nisiꞌ Galilea. Basa fo hei mindaa mo E sia naa, onaꞌ a mia fai maꞌahulu na, ana nafadꞌe basa neu hei ena. Hei baliꞌ leo!” ");
INSERT INTO row_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Inaꞌ ra rita mamanaꞌ a rouꞌ ma, ara nggengger. Boe ma rela dea reu, de ara baliꞌ lai-lai. Te ara nda rafadꞌe esa-esa mia dalaꞌ a saꞌ boe, huu ramatau rae mate. ");
INSERT INTO row_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Nggarei fefetu ana na, Yesus natudꞌu mata na naꞌahuluꞌ neu Maria mana mia Magdala, fo maꞌahulu na Ana oi hendi nitu hitu mia ao na. ");
INSERT INTO row_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maria nita Yesus boe ma, ana baliꞌ neu nafadꞌe basa atahori fo fai maꞌahulu naa tungga Yesus. Ara feꞌe raꞌabꞌubꞌue no rala sususaꞌ ma luu oe nara tudꞌa, huu rasanedꞌa Yesus mamate na. ");
INSERT INTO row_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Maria nafadꞌe se nae, “Taꞌo bee de hei feꞌe susa? Afiꞌ susa fai, te Yesus nasodꞌa baliꞌ ena! Faꞌra, au feꞌe undaa o E!” Te basa se rataa rae, “We! Ho lelekoꞌ!” ");
INSERT INTO row_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Basa ma, Yesus mana tungga na rua laoꞌ risiꞌ kamboꞌ esa. Mia dalaꞌ taladꞌan, Yesus natudꞌu mata na neu se, te Yesus mata na dadꞌi laen. Te dodꞌooꞌ ma, ara rahine E. ");
INSERT INTO row_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Basa ma ruꞌa se baliꞌ reu rafadꞌe nono nara rae, “We! Rena dei! Faꞌra, hai mindaa mo Yesus mia dalaꞌ! Te rataa rae, “We! Afiꞌ lelekoꞌ taꞌo naa! ");
INSERT INTO row_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Basa boe ma, Yesus nandaa no mana tungga kasanahulu esa nara, leleꞌ ara endoꞌ raa. Ana natea se nae, “We! Hei langga fatu mara! Atahori rafadꞌe hei rae, sira rita Au no sira mata nara o, te hei nda nau mimihere sa! Hei mae, ara lelekoꞌ! Ia naa, mete neuꞌ ena. Au memaꞌ mate, te usodꞌa baliꞌ ena! ");
INSERT INTO row_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Mi rereoꞌ raefafoꞌ ia, fo dui-bꞌengga neu basa atahori, Au Dudꞌui Malole ngga. ");
INSERT INTO row_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Seka namahere Au, no hambu sarani, Lamatualain o fee masodꞌaꞌ neu e, fo ana leo no Lamatualain sia sorga. Te seka nda namahere sa, dei fo ana hambu huhukuꞌ, boe ma Lamatualain timba hendi e fo ana leo nakandoo sia deaꞌ. ");
INSERT INTO row_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Atahori mana ramahere Au, ara tao mana dadꞌi mataꞌ-mataꞌ, fo basa atahori rahine rae, sira koasa na, memaꞌ mia Lamatualain. Ara o bisa oi nitu ra pake Au nara ngga. Ma Lamatualain fee se olaꞌ rendiꞌ dedꞌeat laen fo sira nda rahine sa. ");
INSERT INTO row_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Mete ma sira toꞌu mengge marasoꞌ, do ara rinu raso, ara nda hambu deꞌulakaꞌ sa. Ma mete ma ara nggama liman nara reu atahori mamahedꞌiꞌ a langga na, atahori naa hai.” ");
INSERT INTO row_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Yesus ola-olaꞌ basa no mana tungga nara, boe ma Lamatualain soꞌu E sorga neu. Sa naa, Ana dadꞌi Lamatualain lima ona na, de ruꞌa se endoꞌ parenda raꞌabꞌue. ");
INSERT INTO row_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Basa ma, mana tungga nara tungga parenda na. Ara reu sia bee-bꞌee de rafadꞌe basa atahori, Yesus Dudꞌui Malole na. Boe ma Lamatualain fee se koasa fo ara tao basa mana dadꞌi ra fo Yesus nafadꞌe leleꞌ naa ra. Basa ma atahori naeꞌ ramahere Yesus, huu rahine rae memaꞌ dudꞌui maloleꞌ naa, tebꞌe. Leleꞌ ina kateluꞌ ra losa Petrus se, boe ma rafadꞌe basa-bꞌasa se saa fo atahori soruꞌ a olaꞌ mia rates faꞌ ra. Basa boe ma, Yesus mesaꞌ ne parenda mana tungga nara, fo reu rafadꞌe Dudꞌui Malole na neu basa mamanaꞌ ra, losa raefafoꞌ suu nara. Dudꞌui Malole ia natudꞌu dalaꞌ fo Lamatualain fee masodꞌa neu atahori mia sira sala-kilu nara, fo rasodꞌa rakandoo ro E. Dudꞌui malole ia, memaꞌ tebꞌe lao esaꞌ. Naa de, ana naꞌatataaꞌ nakandoo losa doo na neu. ");
INSERT INTO row_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Ama Teofilus nene fee hadꞌat. Sodꞌa-moleꞌ. Atahori hetar sobꞌa suraꞌ dudꞌuit soꞌal dalaꞌ mana dadꞌiꞌ sia hai taladꞌa mara ena. Ara suraꞌ dudꞌuit ra, rendiꞌ dudꞌuit mana nenedꞌuiꞌ neu-nema mia hai, nisiꞌ hai ma sia hai eniꞌ a dalahulun, fo hai bubꞌuluꞌ mia Lamatuaꞌ Yesus atahori mana tungga nara, ma mia atahori feaꞌ mana rita no mata nara. Basa dudꞌuit naa ra, ndaa no Lamatualain hehelu-fufulin eniꞌ fai dalahulun. Dadꞌi au paresaꞌ lutuꞌ-leloꞌ basa dalaꞌ naa ra, eniꞌ a mia teteri-netehun. Dei de au uꞌetuꞌ fo suraꞌ basa naa ra no malole tungga tutute nara. No taꞌo naa, amaꞌ bisa bubꞌuluꞌ no matetuꞌ saa mana dadꞌiꞌ ena. ");
INSERT INTO row_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ma amaꞌ o mumuhere, saa fo atahori ra dꞌuiꞌ naa, nda dudꞌui peko-lelekoꞌ sa. Basa naa ra, tebꞌe-tebꞌeꞌ dadꞌi! ");
INSERT INTO row_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Dudꞌuit ia teteri-netehun taꞌo ia: leleeꞌ mane Herodes toꞌu parendaꞌ sia propinsi Yudea, hambu atahori sa, naran Sakaria. Eni, malangga agama Yahudi esa. Boe ma eni o, esa mia baꞌi Abia nononggoꞌ malangga agaman. Sakaria saon, naran Elisabet. Eni o tititi-nonosiꞌ mia malangga agama ra, huu eni ia, baꞌi Musa aꞌan Harun tititi-nonosin. ");
INSERT INTO row_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ruꞌa se rasodꞌa ndoos tungga basa Lamatualain parendan ma hohoro-lalane nara. Atahori fee hadꞌat neu se boe. ");
INSERT INTO row_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ruꞌa se lasiꞌ ena, te nda ma anaꞌ sa, huu Elisabet mamana anan maꞌatemeꞌ. ");
INSERT INTO row_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Lao esa, Sakaria no nononggon Abia hambu babꞌanggi tao ues sia Ume Hule-oꞌe Huuꞌ sia kota Yerusalem. ");
INSERT INTO row_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Tungga sira hadꞌat na, malangga agama naa ra lea lot, fo rahine seka mana hambu babꞌanggiꞌ nisiꞌ kama Meumareꞌ sia Ume Hule-oꞌe Huuꞌ a. Sia naa, atahori naa musi dedꞌe hau maꞌameniꞌ sia Lamatualain matan. Faiꞌ naa, lot tudꞌa neu Sakaria. ");
INSERT INTO row_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Boe ma ana rala neu. Leleꞌ ana hotu hau maꞌameniꞌ mia kama rala, atahori hetar hule-oꞌe sia ume sodꞌan. ");
INSERT INTO row_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Aiboiꞌ ma, Lamatualain aten esa mia sorga, nambariiꞌ sia mamana dedꞌe hau maꞌameniꞌ bobꞌoa onan. ");
INSERT INTO row_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nita taꞌo naa, ma Sakaria namatau nae mate, de nda nitaꞌ nae tao saa sa boe. ");
INSERT INTO row_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Te ate mana mia sorga olaꞌ nae, “Sakaria! Afiꞌ mumutau e! Huu Lamatualain rena hule-oꞌem ena. Dadꞌi dei fo saom bꞌonggi fee nggo ana touꞌ sa. Musi babꞌae naran, Yohanis. ");
INSERT INTO row_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Dei fo atahori hetar ramahoꞌo ro nggi, huu hei hambu anaꞌ ena. Dei fo anaꞌ ia tao ralam namahoꞌo. ");
INSERT INTO row_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Lamatuaꞌ Dula-dale Meumaren koasan naꞌabꞌue no e, eniꞌ a maman nairu e. Ana musi naluli basa nininuꞌ mana nendi mamafut. Leleꞌ naꞌamoko dei fo Lamatualain, pake e dadꞌi atahori moko-monaen. ");
INSERT INTO row_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Dei fo ana kokoe atahori Israꞌel hetar fo tungga baliꞌ sira Lamatuan, naeni Lamatualain. ");
INSERT INTO row_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ndolu-hadꞌan ma koasan onaꞌ baꞌi Elia, naeni Lamatuaꞌ mana ola-olan eniꞌ a mia dalahulun. Ana nema naꞌahuluꞌ hita Lamatuan. Ana tao ama-inaꞌ ra rala nara sue baliꞌ ana nara. Ma atahori mana lao hela Lamatuaꞌ ena o, ana ubꞌa rala nara fo ara tungga baliꞌ Lamatuaꞌ hihii-nanaun. No taꞌo naa, ana tao atahori ra sadꞌia rala nara fo simbo Lamatuaꞌ neneman.” ");
INSERT INTO row_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Te Sakaria natane baliꞌ ate a nae, “Bisa taꞌo naa, do?! Au ꞌo sao ngga lasiꞌ onaꞌ ia ena! Taꞌo bee fo au uhine basa ia ra bisa dadꞌi?” ");
INSERT INTO row_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Boe ma, ate a nataa nae, “Taꞌo ia! Au Gabriel, Lamatulain dedenun. Ana mana denu au uma, ufadꞌe hara-lii malolen neu nggo. ");
INSERT INTO row_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Te nda nau mumuhere oꞌola ngga sa. Dadꞌi tatandaꞌ fo moꞌeꞌ a taꞌo ia! Maa ma naꞌaꞌeꞌeku ma nda olaꞌ mala sa eniꞌ a mia oras ia, losa hambu mala anaꞌ naa. Dei fo mete neuꞌ ena. Saa fo au olaꞌ ia dei fo dadꞌi, nandaa no fain.” ");
INSERT INTO row_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Atahori hetar mana hule-oꞌe sia deaꞌ ra, duꞌa-duꞌaꞌ a, huu Sakaria nda nau kalua-kalua sa. ");
INSERT INTO row_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Leleꞌ ana dea nema, ana nda olaꞌ nala sa ena. Boe ma ana lalaes mbali se, ma rahine boe rae, Lamatuaꞌ natudꞌu e manadadꞌi manaseliꞌ sa mia Kama Meumare Manaseliꞌ a. ");
INSERT INTO row_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ue-taos nara basa, boe ma Sakaria baliꞌ ume neu. ");
INSERT INTO row_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Nda dooꞌ sa ma Elisabet nairu. Boe ma ana kama aon siaꞌ a ume losa fula lima. Ana olaꞌ nae, “Koa-kio Lamatuaꞌ! Mateꞌen ma Lamatuaꞌ natudꞌu rala malolen neu au ena. Mete ma au hambu tititi-nonosiꞌ ena, atahori nda raꞌamamaeꞌ au sa ena.” ");
INSERT INTO row_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Leleꞌ Elisabet ambun fula nee, boe ma Lamatualain haitua aten mia sorga, nisiꞌ kamboꞌ sa sia profinsi Galilea, naran Nasaret. Ate a naran, Gabriel. ");
INSERT INTO row_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Sia Nasaret hambu ana fetoꞌ sa, naran Maria. Maria tunangan no touꞌ sa, naran Yusuf. Yusuf naa, mane Daud tititi-nonosin. Gabriel neu nandaa no Maria. ");
INSERT INTO row_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ana natudꞌu aon neu ana fetoꞌ a, ma nae, “Sodꞌa-moleꞌ, ana feto! Lamatualain pili nala nggo, fo nae tao dꞌala maloleꞌ sa fee nggo. Lamatualain naꞌabꞌue no nggo, Maria.” ");
INSERT INTO row_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria rena nala naa, ma ana tintindindi no ate a oꞌolan. Ana nda nahine naa sosoan saa sa boe. ");
INSERT INTO row_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Boe ma ate a ola seluꞌ nae, “Maria! Afiꞌ mumutau. Te Lamatualain sangga nae natudꞌu rala malolen neu nggo. ");
INSERT INTO row_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nda doo sa te, muiru ena, Ma, dei fo bꞌonggi ana touꞌ sa. Ho musi babae naran, Yesus. ");
INSERT INTO row_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Dei fo Ana dadꞌi Atahori monaeꞌ. Dei fo Lamatuaꞌ noꞌe E nae, ‘Eni, Au Ana heheli ngga.’ Naeni, Lamatualain manaseliꞌ a anan. Dei fo Lamatualain soꞌu E fo toꞌu parendaꞌ, onaꞌ baꞌin, mane Daud. ");
INSERT INTO row_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Dei fo Eni mana toꞌu parendaꞌ nakandooꞌ a neu atahori Israꞌel ra. Huu parendan nda mana basaꞌ sa. ");
INSERT INTO row_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Te Maria natane Gabriel nae, “Au, nda feꞌe sunggu o tou esa sa boe! Taꞌo bee fo au bisa uiru?” ");
INSERT INTO row_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ma Gabriel nataa nae, “Taꞌo ia! Dei fo Lamatuaꞌ Dula-dale Meumaren nema nisiꞌ nggo. Ma Lamatualain Manaseliꞌ a koasan mboti nala nggo. No taꞌo naa, Anaꞌ, dei fo bꞌonggi malaꞌ naa, tebꞌe-tebꞌe meumareꞌ. Huu Eni, Lamatualain Anan. ");
INSERT INTO row_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Afiꞌ titindindi! Te bobꞌonggi ma esa, naran Elisabet, nairu ena boe. Atahori rae ana nda bisa bꞌonggiꞌ sa, huu namalasi ena. Tao-tao te ia na ambun fula nee ena. ");
INSERT INTO row_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Huu, soaꞌ neu Lamatualain, basaꞌ e bisa dadꞌi!” ");
INSERT INTO row_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Boe ma Maria nataa nae, “Malole. Au ia Lamatualain aten. Hela neu fo basa e dadꞌi tungga oꞌolam naa. Au sadꞌia tungga a Lamatuaꞌ hihii-nanaun.” Basa ma ate mana mia sorga lao hela e. ");
INSERT INTO row_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Seli fai hira ma, Maria lao halalai mia Nasaret nisiꞌ Zakaria kambon propinsi Yudea mamana mbuku leteꞌ. Losa naa ma, ana masoꞌ tuteꞌ nisiꞌ Sakaria umen rala. Ma ana fee hara sodꞌa-moleꞌ neu Elisabet. ");
INSERT INTO row_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Leleꞌ Elisabet rena Maria haran ma, anadikiꞌ a natingga-nasamba sia Elisabet ambun rala. Ma Lamatuaꞌ Dula-dale Meumaren masoꞌ nisiꞌ Elisabet boe. ");
INSERT INTO row_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Boe ma ana olaꞌ nae, “Maria! Dei fo atahori ra soꞌu rananaru naram lenaꞌ basa inaꞌ sia raefafoꞌ ia! Ma atahori o soꞌu rananaru Anaꞌ mana sia ambum rala boe! ");
INSERT INTO row_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Au o nene nenanaru boe, huu Lamatua ngga maman nema nandaa no au. ");
INSERT INTO row_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Leleꞌ rala uma fee hara sodꞌa-moleꞌ neu au, ma ana ngga natingga-nasamba tuteꞌ sia ambu ngga huu namahoꞌo. ");
INSERT INTO row_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Lamatualain natudꞌu rala malolen neu nggo, huu mumuhere mae, Ana nae tao tungga hehelu-fufulin.” ");
INSERT INTO row_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria olaꞌ nae, “Mia au rala ngga, au soꞌu unanaru Lamatuaꞌ ");
INSERT INTO row_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Au rala ngga namahoꞌo, huu Lamatualain fee au masodꞌaꞌ! ");
INSERT INTO row_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ana tao mataꞌ neu au, atahori dedenun nda mana naꞌena sosoa-ndandaaꞌ ia sa. Mia leleꞌ ia basa atahori rae au ia, ina uanale maloleꞌ, ");
INSERT INTO row_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","huu Lamatuaꞌ tao dala manaseliꞌ ra fee au. Eni, mana koasa manaseliꞌ no Meumaren manaseliꞌ. ");
INSERT INTO row_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Lamatualain akaꞌ natudꞌu rala susuen neu basa atahori mana fee hadꞌa-hormat ma beꞌutee neu E. mia tititi nonosiꞌ sa losa tititi nonosiꞌ laen. ");
INSERT INTO row_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ana pake koasan, fo tao atahori mana koaoꞌ ra ramue-raanggiꞌ. ");
INSERT INTO row_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ana naꞌatutudꞌaꞌ atahori mana toꞌu koasa ra, huu sira rananaru ao nara. Te Ana soꞌu nananaru atahori mana maloe-madꞌae rala nara. ");
INSERT INTO row_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ana nahao atahori mana ndoeꞌ ra losa raꞌabeta, te Ana oi hendi atahori mamasuꞌi ra lao ro lima rouꞌ ");
INSERT INTO row_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ana tulu-fali atahori Israꞌel nara, ma akaꞌ natudꞌu rala susuen neu se. ");
INSERT INTO row_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Dalahulun, Ana tao hehelu-fufuliꞌ no bei-baꞌi tara, naeni, baꞌi Abraham no basa tititi-nonosi nara. Losa faiꞌ ia hehelu-fufuliꞌ naa feꞌe nenepaꞌaꞌ nakandoo.” ");
INSERT INTO row_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Basa de, Maria leo no Elisabet losa fula telu. Dei de ana baliꞌ nisiꞌ umen sia Nasaret. ");
INSERT INTO row_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Leleꞌ fain losa ma, Elisabet bꞌonggi ana touꞌ sa. ");
INSERT INTO row_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Haraꞌ naa nenedꞌui-bꞌenggaꞌ losa bobꞌonggin ma basa kambo isiꞌ ra oi, Lamatualain natudꞌu rala malolen ma fee Elisabet anaꞌ sa. Ma basa se o ramahoꞌo boe. ");
INSERT INTO row_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Anaꞌ naa fai falu ma, ara sunat e tungga atahori Yahudi ra adꞌat na. Ara rae babꞌae naran, Sakaria, tungga aman naran. ");
INSERT INTO row_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Te inan nda nau sa nae, “Nda taꞌo naa sa! Naran, musi Yohanis!” ");
INSERT INTO row_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Te rataa rae, “Saa de nauꞌ a naran Yohanis? Sia hei bobꞌonggi mara nda hambu esa naran onaꞌ naa sa boe!” ");
INSERT INTO row_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Boe ma ara laes Sakaria, fo rae rahine nae babꞌae anaꞌ a naran neu se. ");
INSERT INTO row_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sakaria laes noꞌe fatu lei. Ara fee, de ana suraꞌ nae, “Naran Yohanis!” Boe ma basa atahori ra titindindii. ");
INSERT INTO row_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Aiboiꞌ ma, Sakaria maa maꞌaꞌeꞌekun, bangganaꞌu neuꞌ ena. Boe ma ana soꞌu koa-kio Lamatualain. ");
INSERT INTO row_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Basa atahori mana leo deka naa ra, ramatau ma heran. Boe ma dudꞌuit naa neneduiꞌ, losa basa atahori sia lete-leteꞌ propinsi Yudea ra o bubꞌuluꞌ boe. ");
INSERT INTO row_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Atahori mana rena dudꞌuit naa, dꞌuꞌa-dꞌuꞌa rae, “Lamatualain koasan memaꞌ no anaꞌ ia, De naꞌamoko nema na, ana dadꞌi atahori onaꞌ beek o?” ");
INSERT INTO row_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Basa ma, Lamatuaꞌ Dula-dale Meumaren masoꞌ nisiꞌ Sakaria. Naa de ana olaꞌ nae, ");
INSERT INTO row_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Koa-kio Lamatuaꞌ, atahori Israꞌel Lamatuan! Huu nema de tefa-soi nala atahori nara ena, naa fo ara afiꞌ onaꞌ ate fai. ");
INSERT INTO row_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Lamatuaꞌ soꞌu nala Atahori sa koasan manaseliꞌ, fo ana fee masodꞌaꞌ neu nggita. Eni ia, laoꞌ mia mane Daud tititi-nonosin. ");
INSERT INTO row_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Lamatuaꞌ helu basa ia ra eniꞌ a lele uluꞌ a, pake Eni mana ola-ola nara fo rala nara mana maꞌatataaꞌ ra. ");
INSERT INTO row_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ia naa nae mboꞌi nggita mia musu tara, ma atahori mana rala nara mera ro nggita. ");
INSERT INTO row_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Ana natudꞌu rala malolen neu bei-baꞌi tara, huu akaꞌ nasanedꞌa hehelu-fufulin neu se, fo Ana henggenee no baꞌi Abraham a. ");
INSERT INTO row_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ana mboꞌiꞌ nggita mia musu tara ena, fo ata bisa beꞌutee neu E, ma sudꞌi tamatau fai. ");
INSERT INTO row_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ana mboꞌiꞌ nggita ena, fo tasodꞌa takandoo no ndoo-tetuꞌ ma meumareꞌ sia matan. ");
INSERT INTO row_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Yohanis! Ho ia, au ana ngga. Dei fo atahori rahine nggo rae, ho Lamatualain manaseliꞌ a mana ola-olan. Dei fo muu mufadꞌe atahori ra, fo ara simbo no malole Lamatuaꞌ neneman. ");
INSERT INTO row_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Dei fo muu mutudꞌu dalaꞌ neu Lamatuaꞌ atahori nara, fo bisa rahine rae, sira o bisa hambu masoi-masodꞌaꞌ boe, huu Lamatuaꞌ fee ambon neu sala-kilu nara ena. ");
INSERT INTO row_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Huu Lamatuaꞌ ralan bꞌangganaꞌus ma sue-lai nggita, naa de Ana fee seluꞌ nggita kakaꞌe feuꞌ, onaꞌ fai feuꞌ nendi manggarelo feuꞌ. Hita mana leo-lao sia maꞌahatuꞌ a ma tamatau mate, huu nda feꞌe malole to Lamatuaꞌ sa, dei fo hambu manggareloꞌ fo nalalao nggita tisiꞌ dꞌala mole-dꞌameꞌ.” ");
INSERT INTO row_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Basa boe ma, Yohanis boe naꞌamoko. Lamatuaꞌ Dula-dalen tao e maꞌadere. Naꞌamoko nema, boe ma neu leo sia mamana rouꞌ, losa ana soꞌu ue-tataos na fee atahori Israꞌel ra. ");
INSERT INTO row_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","2","Lao esa, leleꞌ Kirenius dadꞌi malangga mana parenda sia Siria, ma mane monaeꞌ, naran Agustus, fee parendaꞌ nae, “Basa atahori mana sia manaparenda Roma koasan musi baliꞌ kambon fo tungga sensus!” Naa fefeun fo manaparenda Roma reken rauinggu nara. ");
INSERT INTO row_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Dadꞌi basa atahori baliꞌ kambon fo tungga sensus. ");
INSERT INTO row_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Leleꞌ naa, Yusuf leo sia kambo Nazaret sia propinsi Galilea. Ana nae laꞌe ana fetoꞌ sa, naran Maria, de mana henggene basaꞌ ena. Maria ia, mairuꞌ ena. Yusuf naa, mane Daud tititi-nonosin, de musi baliꞌ risiꞌ Betlehem kota Daud sia propinsi Yudea fo tungga sensus. Naa de ruꞌa se lao kota Betlehem reu. ");
INSERT INTO row_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Leleꞌ ara losa naa ena, Maria fula-fai bobꞌonggin nae losa boe. ");
INSERT INTO row_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Te sia naa, ara nda hambu kama sia ume sesebaꞌ sa. De ara risiꞌ lalaet bibꞌi rala. Boe ma ana bꞌonggi Ana ulun, touꞌ. Boe ma ara ralusa E rendiꞌ temeꞌ, ma rasusunggu sia haꞌo rala. ");
INSERT INTO row_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Tetembaꞌ naa, hambu manatadꞌa hira beꞌe ranea bibꞌi lombo nara sia lenuꞌ sia kota a deaꞌ. ");
INSERT INTO row_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Aiboiꞌ ma, ara rita Lamatualain aten mia sorga. Boe ma Lamatuaꞌ manggarelon naronda rereoꞌ se, de ramatau rae mate. ");
INSERT INTO row_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ma ate naa nafadꞌe nae, “Ama afiꞌ mimitau dei! Rena malolole, e! Huu Au uma ufadꞌe hara-lii maloleꞌ sa neu nggi. Basa mana rena hara-liiꞌ ia, ramahoꞌo. ");
INSERT INTO row_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Hara-lii maloleꞌ ia liin taꞌo ia: Faiꞌ ia inaꞌ sa bꞌonggi Kristus, sia Betlehem, mane Daud kotan. Kristus naa, Atahori fo Lamatualain helu-fuli eniꞌ a maꞌahulun. Lamatuaꞌ haitua E nema fo soi-tefa atahori sala-kilu nara! Eni ia, dei fo atahori roꞌe rae, ‘Lamatuaꞌ’, huu Eni mana parenda basaꞌ e! ");
INSERT INTO row_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Dei fo hei mihine E taꞌo ia: hei mindaa Anadikiꞌ sa nenebꞌonggi feuꞌ mana nelusaꞌ no temeꞌ. Ana sungguꞌ sia haꞌo rala.” ");
INSERT INTO row_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ana olaꞌ basa ma, aiboiꞌ te, Lamatualain aten hetar mia sorga rema raꞌabꞌue ro E. Boe ma ara koa-kio Lamatualain ma sodꞌa rae, ");
INSERT INTO row_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Hai soꞌu minanaru Lamatualain naran! Eni mana endoꞌ parenda sia lalai narun manaseliꞌ a. Lamatualain nae fee dꞌame neu atahori sia raefafoꞌ, naa tao ralan namahoꞌo!’. ");
INSERT INTO row_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Basa de, Lamatuaꞌ ate nara baliꞌ sorga reu. Boe ma manatadꞌa naa ra ola-olaꞌ rae, “We! Ata Betlehem teu seꞌu tita Anaꞌ naa dei! Huu Lamatuaꞌ fee haraꞌ neu nggita ena.” ");
INSERT INTO row_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Boe ma ara lao lai-lai Betlehem reu. De ara randaa ro Maria no Yusuf. Ara o rita Anadiki mana bꞌonggi feuꞌ a mana sungguꞌ sia haꞌo rala. ");
INSERT INTO row_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Leleꞌ ara rita Anaꞌ a, ma ara dui rae, “Faꞌra Lamatualain ate nara mia sorga rafadꞌe hai soꞌal Anaꞌ ia ena!” Boe ma ara duꞌi lutuꞌ-leloꞌ losa basa. ");
INSERT INTO row_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Basa atahori mana rena manatadꞌa ra dudꞌui nara, mbombooꞌ a. ");
INSERT INTO row_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Te Maria mbedꞌaꞌ basa mana dadꞌiꞌ naa sia ralan. Ma ana dꞌuꞌa-dꞌuꞌa sangga nahine dalaꞌ naa sosoan. ");
INSERT INTO row_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Basa de, manatadꞌa ra baliꞌ risiꞌ bibꞌi lombo nara. Ma ara soꞌu rananaru Lamatualain naran. Roꞌe makasi neu E, huu saa fo ara rena ma ritaꞌ naa, tebꞌe ona saa fo Lamatuaꞌ aten nafadꞌeꞌ a. ");
INSERT INTO row_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Fai falu, ma ara sunat anadikiꞌ a, tungga baꞌi Musa hohoro-lalanen. De ina-ama nara babꞌae naran ‘Yesus’. Naraꞌ naa, ate mana mia sorga nafadꞌe neu se ena, leleꞌ inan nda feꞌe nairu E sa. ");
INSERT INTO row_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Hambu hohoro-lalaneꞌ sa mia baꞌi Musa nae, ina mana bꞌonggi basa fai haa nulu musi neu tao tungga adꞌat nameu-aoꞌ sia Ume Hule-oꞌe Huuꞌ a. Naa fo ara bisa masoꞌ ume hule-oꞌeꞌ a rala reu onaꞌ biasa. Naa de, Yusuf no Maria Yerusalem reu, fo tao tungga adꞌat naa. Ma ara rendi sira Ana mana bꞌonggi feun nisiꞌ Ume Hule-oꞌe Huuꞌ a, fo fee ne dadꞌi Lamatuaꞌ enan. ");
INSERT INTO row_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ara tungga Lamatuaꞌ hohoro-lalanen mana nae, “Sudꞌiꞌ a inaꞌ se bꞌonggi ana ulun, mete ma touꞌ, na, musi fee anaꞌ naa dadꞌi Lamatuaꞌ enan.” ");
INSERT INTO row_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Tungga Lamatuaꞌ hohoro-lalanen, mete ma fee anaꞌ naa neu Lamatuaꞌ, ama-ina nara musi fee tutunu-hohotuꞌ mbui teu pasan esa, do mbui lunda mandaꞌ rua. Naa de Yusuf no Maria o tao tungga hohoro-lalaneꞌ naa. ");
INSERT INTO row_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","26","Leleꞌ naa, hambu tou lasiꞌ sa, naran Simeon, leo sia kota Yerusalem. Eni, Atahori rala ndoos ma ralan hii Lamatuaꞌ. Lamatuaꞌ Dula-dale Meumaren nafadꞌe neu e nae, hela ana nita Kristus, dei fo ana feꞌe maten. Kristus naa, mana fee masodꞌaꞌ neu atahori Israꞌel ra. ");
INSERT INTO row_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Leleꞌ naa, Lamatuaꞌ Dula-dalen nendi Simeon nisiꞌ Ume Hule-oꞌe Huuꞌ a. Naa nandaa no Yesus ama-ina nara ro E nisiꞌ naa, fo fee ne dadꞌi Lamatuaꞌ enan. ");
INSERT INTO row_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Nita Anaꞌ a ma, tou lasiꞌ Simeon oꞌo nala E, ma soꞌu koa-kioꞌ neu Lamatualain nae, ");
INSERT INTO row_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Koa-kio Lamatuaꞌ! Lamatuaꞌ tao tungga hehelu-fufulin neu au ena. Dadꞌi ia naa, Lamatuaꞌ bisa mboꞌi au ena, naa fo au mate no maloleꞌ, ");
INSERT INTO row_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Huu au ita Atahori fo Lamatuaꞌ haituaꞌ a ena, fo fee ambon neu hai sala-kilu mara! ");
INSERT INTO row_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Lamatuaꞌ nae pake Anaꞌ ia fo fee masodꞌaꞌ neu basa nusaꞌ ra. ");
INSERT INTO row_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Dei fo Ana onaꞌ rondaꞌ fo mana nendi hadꞌa-hormat neu Lamatuaꞌ atahori Israꞌel nara. Ana o onaꞌ manggareloꞌ a, fo mana matudꞌu Lamatuaꞌ dꞌalan. fee basa nusa feaꞌ ra.” ");
INSERT INTO row_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Rena taꞌo naa, ma Yusuf no Maria heran bali-baliꞌ neu saa fo tou lasiꞌ a olaꞌ soꞌal sira Anan. ");
INSERT INTO row_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Basa de, Simeon olaꞌ papala-babꞌanggiꞌ fee se. Boe ma ana nafadꞌe Maria nae, “Yesus maman e! Dei fo atahori hetar sia Israꞌel nda simbo mama Anan ia sa. Te tatao-nonoꞌi nara mbali E, dei fo ratudaꞌ baliꞌ se. Mama Anan ia, o tao fee atahori hetar rala nara ramahoꞌo. ");
INSERT INTO row_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","No taꞌo naa, dei fo Lamatuaꞌ soi natudꞌu atahori ra rala-dꞌudꞌuꞌa nara. Te ho, Maria, dei fo hambu doidꞌosoꞌ naen seli, onaꞌ fela tafaꞌ nenembauꞌ nisiꞌ tenda boam rala.” ");
INSERT INTO row_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Sia Ume Hule-oꞌe Huuꞌ a o hambu beiꞌ sa, naran Hana. Ana too falu nulu haa ena. Aman, naran Fanuel, mia leo Aser. Ana sao too hitu, boe ma saon mate hela e. Bei Hana Ia, Lamatualain mana ola-olan. Ue-tataon, naeni hule-oꞌe ma puasa sia Ume Hule-oꞌe Huuꞌ a, fo beꞌutee neu Lamatualain hatuꞌ-rerelon. ");
INSERT INTO row_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Leleꞌ Simeon olaꞌ no Yusuf ma Maria, Hana o neu deka-deka boe. De ana rena se, ma ana soꞌu kokoa-kikioꞌ neu Lamatualain. Basa ma ana olaꞌ soꞌal Yesus neu basa atahori mana rahani Maneꞌ fo Lamatuaꞌ helu nae haitua nema fo mboꞌi atahori Israꞌel ra. ");
INSERT INTO row_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Leleꞌ Yusuf no Maria tao tungga baꞌi Musa hohoro-lalane nara sia kota Yerusalem ena, boe ma ara baliꞌ risiꞌ sira kambon Nasaret sia propinsi Galilea. ");
INSERT INTO row_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Boe ma Yesus boe naꞌamoko. Ana boe maꞌadereꞌ, boe nahine, ma nahine dalaꞌ naeꞌ sosoa-ndandaa nara. Lamatualain o natudꞌu rala malolen neu E. ");
INSERT INTO row_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Tungga too, Yusuf no Maria reu raa fefeta Paska sia Kota Yerusalem. ");
INSERT INTO row_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Leleꞌ Yesus too sanahulu rua, ara reu risiꞌ Yerusalem fo tungga fefetas ona biasa na. ");
INSERT INTO row_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","44","Leleꞌ fai-fai Paska basa ena, boe ma Yusuf no Maria lao baliꞌ Nasaret reu ramaloloꞌ ro atahori hetar mana rae baliꞌ Galilea reu. Te nda bubꞌuluꞌ rae, Yesus feꞌe sia Yerusalem sa. Ara rae neꞌo Ana lao namaloloꞌ no nonoo nara. Te, losa bobꞌoꞌ ena, nda rita E sa. Boe ma ara sangga E reu-rema sia bobꞌonggi nara ma nonoo nara. ");
INSERT INTO row_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Huu nda hambu randa ro E sa, de ara lao baliꞌ Yerusalem reu, fo sangga E sia naa. ");
INSERT INTO row_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Losa naa, ara sangga E losa fai telu, dei de hambu E mia Ume Hule-oꞌe Huuꞌ a rala. Ana endoꞌ naselu-bale no meser agama Yahudi ra. ");
INSERT INTO row_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Basa atahori mana rena se mbomboꞌ a, huu Ana nahine tebꞌe-tebꞌeꞌ Lamatualain Hara-liin sosoa-ndandan, ma Ana nataa netane nara no maloleꞌ. ");
INSERT INTO row_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Rita taꞌo naa ma, ina-ama nara titindindiꞌ a. Boe ma inan nae, “Yesus! Taꞌo bee de tao hai susa onaꞌ ia? Au o ama ma susa-susa sangga rereoꞌ Nggo. ");
INSERT INTO row_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Te Yesus nataa nae, “Taꞌo bee de papa no mama susa-susa sangga Au? Bꞌubꞌuluꞌ ena, to? Au hambu ue-taos sia Ama Ngga Umen.” ");
INSERT INTO row_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Te ara nda rahine Yesus oꞌolan no matetuꞌ sa. ");
INSERT INTO row_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Boe ma basa se baliꞌ Nasaret reu. Yesus tungga ina-aman parenda nara. Ma inan mbedaꞌ basa dalaꞌ naa ra sia ralan. ");
INSERT INTO row_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ma Yesus boe naꞌamoko ma, boe nahine basa dꞌala maloleꞌ ra. Lamatualain ma atahori o sue E boe. ");
INSERT INTO row_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Leleꞌ naa, Tiberius dadꞌi keser mana toꞌu parendaꞌ sia Roma, too sanahulu lima ena. Pontius Pilatus dadꞌi hofernor sia propensi Yudea. Herodes dadꞌi hofernor sia propensi Galilea. Herodes aꞌan Filipus, dadꞌi hofernor sia propensi Iturea no propensi Trakonitis. Boe ma Lisanias dadꞌi hofernor sia propensi Abilene. Leleꞌ naa Hanas no Kayafas dadꞌi malangga monaeꞌ agama Yahudi sia kota Yerusalem. Leleꞌ naa o, Yohanis, Sakaria anan, leo sia mamana rouꞌ fo naꞌadꞌoꞌ mia kamboꞌ. Sia naa, Lamatuaꞌ fee hara-liin neu e. ");
INSERT INTO row_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yohanis rena nala, ma ana lao nisiꞌ basa kamboꞌ mana deka no loe Yarden, de nafadꞌe atahori ra nae, “Hei musi mitaa ma lao hela basa sala mara, fo Lamatualain fee ambon neu sala-kilu mara naa ra. Hei o musi sarani dei, fo dadꞌi tanda oi, hei malole mo Lamatuaꞌ ena.” ");
INSERT INTO row_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Dalahulun, Lamatuaꞌ mana ola-olan baꞌi Yesaya suraꞌ soꞌal Yohanis nae, “Hambu atahori sia mamana rouꞌ nggasi nae, Basa atahori mihehere tao mitetu dalaꞌ, fo simbo Lamatuaꞌ neneman! Tao mitetu dalaꞌ fo soru E. ");
INSERT INTO row_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Mbori misofe ndola romaꞌ. Poko mitetu leteꞌ ra. Tao mindoo dꞌala penggoꞌ ra, tao mimilenu dꞌala fatu-fatuꞌ ra. ");
INSERT INTO row_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Naa fo atahori mia basa nusaꞌ ra bisa bubꞌuluꞌ rae, Lamatuaꞌ nae fee atahori rasodꞌa mia sala-kilu nara.’” ");
INSERT INTO row_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Atahori hetar rema mia sudꞌiꞌ a bee fo roꞌe Yohanis sarani se. Te ana bua se nae, “Weh! Hei mana peko-lelekoꞌ! Hei onaꞌ mengge marasoꞌ a! Afiꞌ duꞌa mae hei nenemboꞌit mia Lamatuaꞌ huku-dokin noꞌa lelekoꞌ miloeꞌ tao sala! Hokoꞌ! Nda dooꞌ sa ena, Lamatuaꞌ fee huku-dokiꞌ neu basa atahori nda mana dꞌoaꞌ tao salaꞌ no matetuꞌ sa. ");
INSERT INTO row_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Hei afiꞌ duꞌa mae, ‘Au ia nda hambu huku-dokiꞌ sa, huu au baꞌi Abraham tititi-nonosin.’ Hambu sia bee taꞌo naa? Naa nda tulun hei sa, huu nda bisa tao nggi dadꞌi atahori meumareꞌ sa. Lamatuaꞌ bisa tao fatu ia ra dadꞌi baꞌi Abaraham tititi-nonosin. Au ufadꞌe, e! Mitudꞌu no hei tatao-nonoim mara, mae hei misidꞌea lao hela sala mara, ma tungga baliꞌ neu Lamatuaꞌ ena. ");
INSERT INTO row_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Hei musi tao dꞌala maloleꞌ. Mete ma hokoꞌ, dodꞌoo fa te hei hambu Lamatuaꞌ huku-doki mamberan, onaꞌ atahori ungga hendi hau huuꞌ rendiꞌ taꞌa. Mete ma hau huuꞌ sa nda naꞌena buna-bꞌoa maloleꞌ sa, na, nda ma nggunaꞌ sa! De malole lenaꞌ ungga hendi e, fo tao ai rala neu.” ");
INSERT INTO row_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Basa ma, atahori naa ra ratane Yohanis rae, “Dadꞌi hai musi tao sa?” ");
INSERT INTO row_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Boe ma ana nataa nae, “Mete ma miꞌena badꞌu rua, na, fee esa neu atahori nda ma badꞌuꞌ sa. Mete ma miꞌena nanaat, na, banggi fee atahori nda mana naꞌena nanaat sa.” ");
INSERT INTO row_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Basa ma, mana edꞌa bea ra rema roꞌe Yohanis sarani se. Ara ratane rae, “Papa meser! Hai musi tao taꞌo bee?” ");
INSERT INTO row_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ana nataa nae, “Hei akaꞌ peko-lelekoꞌ. Te ia na hei musi ue-tao no ndoo-tetuꞌ. Afi moꞌe bea lenaꞌ-lenaꞌ mia mana parenda ra atoran. Hela rauinggu ra bae bea tungga atoran.” ");
INSERT INTO row_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Hambu soldꞌadꞌu hira o mia naa boe. Ara ratane Yohanis rae, “hai taꞌo bee? Hai musi tao sa?” Basa ma nataa nae, “Afi mia mateꞌ atahori ra doin, tungga hihii mara. Ma afiꞌ fua salaꞌ leli neu atahori. Hei musi mimihoꞌo-mitidꞌale mo nggadꞌi mara.” ");
INSERT INTO row_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Rena oꞌolan ma, basa atahori ra esa keis esa ma utu-utu rae, “Awee! Mbei ma Yohanis ia, Kristus, fo Lamatuaꞌ helu basa nae haitua nema eniꞌ a dalahulun!” ");
INSERT INTO row_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Te Yohanis ai se nae, “Rena malolole! Dei fo hambu atahori sa manaseliꞌ lena au nae nema. Onaꞌ mae dadꞌiꞌ a dedꞌenun o, au nda undandaa sa. Au sarani hei noꞌ a oe, te dei fo Ana tao lenaꞌ au, Ana tao nasofe rala mara no Lamatuaꞌ Dula-dale Meumaren. Dei fo Ana tao nameu nggi, onaꞌ atahori hotu manggarauꞌ rendiꞌ ai. ");
INSERT INTO row_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ana huku-doki atahori mana tao salaꞌ ra, onaꞌ atahori mana tao moleꞌ sa nalaidꞌi are-gandum dꞌekeꞌ. Basa ma ana oni are-gandum dꞌeke meuꞌ nisiꞌ soka-poleꞌ rala neu, ma hotu hendi manggenggeoꞌ ra. Onaꞌ naa boe, dei fo Kristus huku-doki atahori mana tao salaꞌ ra, ma nggari se risiꞌ ai mbilaꞌ nda mana mamaꞌetuꞌ a sa. ");
INSERT INTO row_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","No taꞌo naa, Yohanis fee nesenenedꞌaꞌ mata-mataꞌ neu atahori, ma nafadꞌe se Lamatuaꞌ Hara-lii Malolen. ");
INSERT INTO row_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","Leleꞌ naa, Yohanis o olaꞌ relo-relo Herodes tataon. Eni salan taꞌo ia: Herodes naa, hofernor sia propensi Galilea. Salan naen seli ena. Salan esa, naeni: Ana lea nala odꞌin saon, naran Herodias. Naa te, odin feꞌe masodꞌaꞌ, ma nda feꞌe mahelaꞌ no Herodias sa. Herodes masodꞌan fo nda matetuꞌ naa sa, tao Yohanis ai e no relo-relo, de Herodes nda hii e sa. Basa ma Herodes toꞌu nala e, de nggari e bui rala neu. ");
INSERT INTO row_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Dalahulun, leleꞌ ara nda feꞌe humu Yohanes sa, ana sarani atahori hetar. Ma Ana o sarani Yesus boe. Basa naa ma Yesus hule-oꞌe ma lalai a sii. ");
INSERT INTO row_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Boe ma Lamatuaꞌ Dula-dale Meumaren onda neu E. Dula-daleꞌ a mata aon onaꞌ mbui lunda. Boe ma haraꞌ mia lalai nae, “Ho ia, Au Ana susue ngga. Ho tao mumuhoꞌo Au mukundooꞌ a.” ");
INSERT INTO row_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Leleꞌ Yesus mulai nafadꞌe atahori Lamatuaꞌ dala masodꞌan, mbeima Ana too telu nulu ena. Atahori rahine rae, Yesus naa, Yusuf Anan. Yusuf bei-baꞌi nara, onaꞌ ia: Yusuf aman, Eli. ");
INSERT INTO row_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli aman, Matat. Matat aman, Lewi. Lewi aman, Melki. Melki aman Yanai. Yanai aman, Yusuf. ");
INSERT INTO row_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusuf aman, Matatias. Matatias aman, Amos. Amos aman, Nahum. Nahum aman, Hesli. Hesli aman, Nagai. ");
INSERT INTO row_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai aman, Maat. Maat aman, Matatias. Matatias aman, Semein. Semein aman, Yosek. Yosek aman, Yoda. ");
INSERT INTO row_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda aman, Yohanan. Yohanan aman, Resa. Resa aman, Serubabel. Serubabel aman, Sealtiel. Sealtiel aman, Neri. ");
INSERT INTO row_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri aman, Melki. Melki aman, Adꞌi. Adꞌi aman, Kosam. Kosam aman, Elmadam. Elmadam aman, Er. ");
INSERT INTO row_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er aman, Yosua. Yosua aman, Elieser. Elieser aman, Yorim. Yorim aman, Matat. Matat aman, Lewi. ");
INSERT INTO row_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewi aman, Simeon. Simeon aman, Yehuda. Yehuda aman, Yusuf. Yusuf aman, Yonam. Yonam aman, Elyakim. ");
INSERT INTO row_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elyakim aman, Melea. Melea aman, Mena. Mena aman, Matata. Matata aman, Natan. Natan aman, Daud. ");
INSERT INTO row_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daud aman, Isai. Isai aman, Obet. Obet aman, Boas. Boas aman, Salmon. Salmon aman, Nahason. ");
INSERT INTO row_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahason aman, Aminadab. Aminadab aman, Admin. Admin aman, Arni. Arni aman, Hesron. Hesron aman, Peres. Peres aman, Yahuda. ");
INSERT INTO row_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yahuda aman, Yakob. Yakob aman, Isak. Isak aman, Abraham. Abraham aman, Tera. Tera aman, Nahor. ");
INSERT INTO row_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor aman, Seruk. Seruk aman, Rehu. Rehu aman, Pelek. Pelek aman, Eber. Eber aman, Sela. ");
INSERT INTO row_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela aman, Kenan. Kenan aman, Arpaksad. Arpaksad aman, Sem. Sem aman, Noh. Noh aman, Lamek. ");
INSERT INTO row_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek aman Metusalak. Metusalak aman, Henok. Henok aman Yared. Yared aman, Mahalalel. Mahalalel aman, Kenan. ");
INSERT INTO row_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan aman, Enos. Enos aman, Set. Set aman Adam. Adam naa, Lamatualain ana naꞌadadadꞌin. ");
INSERT INTO row_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Leleꞌ Yohanis sarani basa Yesus, boe ma Yesus lao hela loe Yarden. Lamatuaꞌ Dula-dale Meumaren naꞌabꞌue no E. Basa ma Dula-daleꞌ no E nisiꞌ mamana rouꞌ sa. ");
INSERT INTO row_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Yesus leo mia naa losa fai haa nulu. Leleꞌ naa, Ana o nda naa saa-saa sa boe, losa ana ndoe nala seliꞌ. Boe ma, nitu ra malanggan nema sobꞌa-dou E. ");
INSERT INTO row_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ana olaꞌ neu Yesus nae, “Mete ma memaꞌ Ho Lamatualain Anan, na muꞌena koasa. De denu fatu ia ra dadꞌi roti, fo mua se.” ");
INSERT INTO row_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Te Yesus nataa nae, “Hokoꞌ! Nda bubꞌuluꞌ sa, do? Nenesuraꞌ sia Lamatualain Susura Meumaren oi, ‘Atahori nda rasodꞌa miaꞌ a nanaat sa!’” ");
INSERT INTO row_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","6","Basa ma, nitu ra malanggan no E nisiꞌ mamana naruꞌ sa, ma natudꞌu neu E basa mana parenda sia raefafoꞌ no manaseli nara. Boe ma ana kokoe Yesus nae, “Basa manaparenda ra ro koasa nara, ma manaseli nara, au ena ngga ra. De au uꞌena hak ae fee neu sudꞌiꞌ a se fo au hii. ");
INSERT INTO row_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Au ae fee basa se neu Nggo. Akaꞌ musi tao dalaꞌ sa dei, dei fo au fee Nggo. Mudꞌa hieꞌ a! Ho beꞌutee neu au. Akaꞌ naa ena!” ");
INSERT INTO row_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Te Yesus nataa nasafali nae, “Hambu sia bee taꞌo naa? Te sia Lamatualain Susura Meumaren nenesuraꞌ oi, ‘Ho musi beꞌutee neuꞌ a Lamatualain. Ma musi tao-ues fee neu E.” ");
INSERT INTO row_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Basa ma, nitu ra malanggan no Yesus nisiꞌ kota Yerusalem. Losa naa, ana nendi Yesus nisiꞌ Ume Hule-oꞌe Huuꞌ a ata-ataꞌ. Ma ana nae, “Mete ma memaꞌ Ho Lamatualain Anan, na, boke rae Muu leo! ");
INSERT INTO row_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Te nenesuraꞌ sia Lamatualain susura Meumaren oi, ‘Dei fo Lamatualain denu ate nara mia sorga, ranea nggo. ");
INSERT INTO row_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Dei fo ara rema nggaso Nggo, fo Ei mara nda dai rae sa.’” ");
INSERT INTO row_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Te Yesus nataa nae, “Afiꞌ sobꞌa-dou Au. Te nenesuraꞌ sia Lamatualain susura Meumaren oi, Afiꞌ sobꞌa-dꞌou Lamatualain!’” ");
INSERT INTO row_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nitu ra malanggan sobꞌa Yesus no dalaꞌ mataꞌ-mataꞌ, te nda nala E sa. De ana lao hela Yesus, fo nahani kakaꞌe maloleꞌ. ");
INSERT INTO row_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Basa ma, Yesus baliꞌ fai nisiꞌ propensi Galilea, huu Lamatuaꞌ Dula-dalen fee koasa neu E. Nda dooꞌ sa ma, atahori sia mamanaꞌ naa ra, mulai rahine Naran boe. ");
INSERT INTO row_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ana nanori sia atahori Yahudi ra ume hule-oꞌen sia bee-bꞌee. Boe ma atahori ra koa E rae, “Yesus naa, Atahori manaseliꞌ, o.” ");
INSERT INTO row_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Lao esa, Yesus nema nisiꞌ kambon Nasaret. Nandaa no atahori Yahudi ra fai hule-oꞌen, naeni ‘fai nggarei’, Ana nisiꞌ ume hule-oꞌeꞌ rala neu, ona biasa na. Basa ma Ana nambariiꞌ fo nae baca mia Lamatualain Susura Meumaren. ");
INSERT INTO row_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Boe ma ara loo fee ne baꞌi Yesaya susuran. Ana nakambembela e, ma sangga tatadꞌaꞌ, de baca nae, ");
INSERT INTO row_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Lamatualain Dula-dalen koasan sia Au. Naa de Ana dudꞌu Au, fo ufadꞌe Lamatuaꞌ Hara-lii Malolen neu atahori mana tudꞌa-loloeꞌ ra. Ana denu Au ena, fo ufadꞌe ae, dei fo mana sia bꞌui ra, nenemboꞌit; dei fo pokeꞌ ra, rita baliꞌ; dei fo nenetuni-ndeniꞌ ra, rasodꞌa no nenemboꞌit ");
INSERT INTO row_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Te ia na, Lamatuaꞌ fain losa ena, fo fee masodꞌaꞌ neu Atahori nara.” ");
INSERT INTO row_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesus baca basa susura naa, ma Ana lulu baliꞌ de loo neu mana toꞌu nggareiꞌ a, ma Ana endoꞌ. Basa atahori mana sia ume hule-oꞌeꞌ rala ra mete rahereꞌ E. ");
INSERT INTO row_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Basa de Ana nafadꞌe se nae, “Saa fo hei rena mia Lamatualain Susura Meumaren faꞌ ra, ia na dadꞌi ena!” ");
INSERT INTO row_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Boe ma atahori mana sia naa ra olaꞌ soꞌu-soꞌuꞌ Yesus rae, “Awii! Saa fo Ana olaꞌ faꞌ ra naa, malolen seli! Te Eni ia, Usu Anan, to! Taꞌo bee de taꞌo ia?” ");
INSERT INTO row_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Boe ma Yesus nafadꞌe se nae, “Tantu basa nggi mihine dedꞌeat mana oi, “We, doter! Tao muhaiꞌ aom dei!” Hei mae miꞌitutudꞌa Au mendiꞌ dedꞌeat naa. Hei mae, ‘Taꞌo bee de nda tao manadꞌadꞌi manaseliꞌ esa fee hai sia ia sa, onaꞌ Ho tao mia kota Kapernaum naa?’ ");
INSERT INTO row_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Matetun taꞌo ia: Atahori nda nau simbo Lamatuaꞌ mana ola-ola nara sia kambo nara sa. ");
INSERT INTO row_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Haꞌi conto mia Lamatuaꞌ mana ola-olan, baꞌi Elia. Lao esa, udꞌan nda nema sa too telu fula nee ena. Leleꞌ naa, hambu ina falu hetar sia Israꞌel. Te Lamatuaꞌ nda denu Elia fo tulu-fali se sia Israꞌel sa. Lamatuaꞌ denu e nisiꞌ akaꞌ ina falu sa sia kambo Sarfat deka no kota Sidꞌon. Tao-tao te ina lasiꞌ a nda atahori Yahudi sa. Te namahere neu Lamatualain koasan. ");
INSERT INTO row_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Haꞌi conto laen fai mia Lamatuaꞌ mana ola-olan Elisa. Leleꞌ naa, hambu atahori Yahudi hetar ramahedꞌi kusta sia Israꞌel. Te Lamatuaꞌ nda naꞌahahaiꞌ se sa. Lamatuaꞌ denu Elisa naꞌahahaiꞌ akaꞌ atahori kusta esa, naran Naꞌaman. Tao-tao te, eni, atahori Siria, nda atahori Yahudi sa. Te namahere Lamatualain koasan.” ");
INSERT INTO row_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Leleꞌ ara rena Yesus olaꞌ taꞌo naa, ma basa se ramanasa E seli. ");
INSERT INTO row_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Boe ma basa se fela randaa, ma mbuu hendi E mia ume hule-oꞌeꞌ naa. Boe ma ara lea rendi E nisiꞌ mbia tonggon sia kamboꞌ a suun, fo rae timba hendi E nisiꞌ ndolaꞌ rala neu. ");
INSERT INTO row_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Te Ana sususi tungga atahori hetar taladꞌan, de lao hela se. ");
INSERT INTO row_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Basa naa ma, Yesus onda nisiꞌ kota Kapernaum sia dano Galilea suun. Tungga-tungga fai hule-oꞌeꞌ, Ana nanori atahori sia ume hule-oꞌeꞌ rala. ");
INSERT INTO row_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Atahori ra titindindi rena oꞌolan, huu Ana nahine tebꞌe nenoriꞌ naa isin. ");
INSERT INTO row_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Lao esa, Leleꞌ Yesus nanori sia ume hule-oꞌeꞌ rala, hambu atahori nitu daiꞌ sa nameli nahereꞌ nae, ");
INSERT INTO row_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Woi! Yesus, atahori Nasaret! Ho mae tao saa neu hai! Uma mae tao mulutu hai, do? Hai mihine Nggo. Ho ia, Atahori Meumareꞌ fo feꞌesaꞌan Lamatualain helu nae haitua nemaꞌ a.” ");
INSERT INTO row_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Te Yesus bua e nae, “Nee-nee! Kalua mia atahori naa!” Aiboiꞌ ma, nitu naa mbesiꞌ atahori naa neu rae a sia atahori ra taladꞌan nara. Mbesiꞌ basa, ma nitu a lao hela atahori naa, ma nda tao nambeta aon sa. ");
INSERT INTO row_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Atahori ra mbomboꞌ a rae, “Seli, e! Atahori ia oꞌolan, naꞌena koasa manaseliꞌ! Losa nitu ra o tungga parendan de lao hela atahori ra!” ");
INSERT INTO row_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Basa de, dudꞌuit soꞌal Yesus mulai nenedꞌui-bꞌenggaꞌ sia basa nusaꞌ naa. ");
INSERT INTO row_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Leleꞌ ara kalua mia ume hule-oꞌeꞌ naa ma Yesus lao nisiꞌ Simon umen. Simon ina arin namahedꞌi mafeo-matobꞌiꞌ, de aon natobꞌi rorooꞌ. Boe ma ara roꞌe Yesus rae, “Amaꞌ! Tulun muꞌuhahaiꞌ ina lasiꞌ a dei.!” ");
INSERT INTO row_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesus neu ririi neu koi a suu na, de oi mafeo-matobꞌiꞌ a dea neu mia ina lasiꞌ a. Hatemataꞌ naa boe ma, mafeo-matobꞌiꞌ a mopo neuꞌ ena. Boe ma ana fela neuꞌ ena de neu lole-lau nanaat fee se. ");
INSERT INTO row_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Bꞌobꞌoꞌ naa, relo a nae mopo ma, atahori ra rendi basa atahori mamahedꞌiꞌ ra risiꞌ Yesus. Hedꞌi nara mataꞌ-mataꞌ. Boe ma Ana ndae liman neu atahori mamahedꞌiꞌ ra, de tao nahaiꞌ basa se. ");
INSERT INTO row_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Mia atahori mamahedꞌiꞌ naa ra, hambu nitu taoꞌ hira boe. De Yesus parenda nitu ra dea reu mia atahori naa ra. Ara dea reu ma rameli rae, “Ho ia, Lamatualain Anan!” Te huu nitu naa ra rahine rae, Eni, Kristus, fo Lamatualain helu basa mia dalahulun nae haitua nemaꞌ a. Naa de, Yesus ai se fo afiꞌ olaꞌ saa boe soꞌal Eni. ");
INSERT INTO row_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Mbila deka manggarelo ma Yesus fela de nisiꞌ mamana rouꞌ sa sia kota deaꞌ. Atahori ra sangga E sia bee-bꞌee. Leleꞌ rita E, ma ara akaꞌ kokoe E rae, “Amaꞌ leo mo hai! Afiꞌ misiꞌ mamanaꞌ laen!” ");
INSERT INTO row_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Te Ana nataa nae, “Au o musi uu sia kamboꞌ laen ra, fo uu dui-bꞌengga Hara-lii Maloleꞌ soꞌal Lamatualain parendan. Huu Lamatuaꞌ denu Au ulalao ue-taos naa.” ");
INSERT INTO row_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Boe ma Ana laoꞌ mia kamboꞌ esa nisiꞌ kamboꞌ laen fo nanori sia ume-ume hule-oꞌeꞌ sia propensi Yudea. ");
INSERT INTO row_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Lao esa, Yesus nanori atahori ra sia dꞌano Galilea suun. Atahori hetar rema rae rena Lamatualain Hara-liin. Losa ara rakaseseti heo rala Yesus. ");
INSERT INTO row_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Deka naa, hambu manatasi ra raisi puꞌa nara sia madꞌaꞌ ata. Boe ma Yesus nita ofa rouꞌ rua mananafuꞌ sia naa. ");
INSERT INTO row_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ofaꞌ naa ra Simon enan esa. Boe ma Yesus hene nisiꞌ Simon ofan, ma noꞌe e tola ofaꞌ nisiꞌ oe romaꞌ mbei. Basa ma Ana endoꞌ nanori atahori hetar naa ra. ");
INSERT INTO row_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ana nanori basa, ma olaꞌ neu Simon nae, “Simon! Misiꞌ mamana romaꞌ mbei fo nggari puꞌat sia naa. Te dei fo hei hambu uꞌu hetar.” ");
INSERT INTO row_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Te Simon nataa nae, “Papa dei! Hai puꞌa tetembaꞌ sa teme-ao, te nda mala uꞌu boaꞌ esa sa boe! Te huu Papa maꞌo naa ena, de, au uꞌondaꞌ sobꞌa.” ");
INSERT INTO row_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Boe ma ara raꞌondaꞌ puꞌat. Leleꞌ rae lea baliꞌ ata neu, puꞌat a sofeꞌ noꞌ a uꞌu, losa puꞌat a sii mbei ena. ");
INSERT INTO row_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Boe ma Simon randu nonoon mana sia ofaꞌ laen fo rema tulun se. De ara ao uꞌu ofaꞌ rala reu, de ofa karuaꞌ naa ra sofeꞌ roꞌa uꞌu, de raeꞌ a molo. ");
INSERT INTO row_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Simon nonoo manatasi nara, Yakobis no Yohanis, naeni Sabadeus ana nara, ara o sia naa boe. Ara o titindindiꞌ a, huu rala uꞌu hetar seli. Leleꞌ Simon Petrus nita saa mana dadꞌiꞌ naa, ma ana sendeꞌ lululanggan sia Yesus matan nae, “Au ia, atahori mana tao sala-kiluꞌ naen seli ena. Dadꞌi malole lenaꞌ Lamatuaꞌ afiꞌ deka-deka mo au fai.” Te Yesus nataa nae, “Simon! Afiꞌ duꞌa nae-nae dalaꞌ naa, huu Au ae pake nggi. Hei ia, biasa sangga uꞌu. Te ia na Au unori nggi sangga atahori fo tungga Au.” ");
INSERT INTO row_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Basa ma ara lea tuteꞌ ofa nara madꞌaꞌ ata reu. Boe ma ara lao hela basa saa-saa nara, fo tungga Yesus. ");
INSERT INTO row_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Sia kamboꞌ sa, Yesus nandaa no atahori sa hedꞌi kusta ndule ao na. Leleꞌ ana nita Yesus, boe ma neu sendeꞌ lululanggan ma beꞌutee sia matan losa rae a. Boe ma nae, “Amaꞌ, e! Tulun au dei! Au bubꞌuluꞌ, Amaꞌ bisa muꞌuhahaiꞌ hedꞌi ngga ia. Sadꞌi Amaꞌ nau. Naa fo atahori sudꞌi boe melumudꞌu au fai.” ");
INSERT INTO row_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Boe ma Yesus loo liman de nggama e. Boe ma olaꞌ nae, “Au nau! Hai leon! Olaꞌ basa ma, hedꞌi kusta mopꞌo neuꞌ ena mia atahori naa aon. ");
INSERT INTO row_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Boe ma Yesus olaꞌ fee nesenenedꞌaꞌ neu e nae, “Musunedꞌa malolole! Ho hai ena, te afiꞌ mufadꞌe esa boe! Ho musi tungga baꞌi Musa parendan dei. Dadꞌi muu sia malangga agama leo, fo ana paresaꞌ ao ma, naa fo ana nahine hedꞌis ma hai tebꞌe ena, do hokoꞌ. Basa na, ho musi mendi tutunu-hohotuꞌ moꞌe makasi, fo basa atahori bubꞌuluꞌ oi, ho hai tebꞌe ena.” ");
INSERT INTO row_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Mae Yesus ai o, nda doo sa ma dudꞌuit soꞌal koasa Na naa, nenedꞌui-bꞌenggaꞌ sia bee-bꞌee. Dadꞌi atahori ra akaꞌ nonggo-nonggo rema rae rena E nanori se. Boe ma Ana naꞌahahaiꞌ atahori hetar mia hedꞌis mataꞌ-mataꞌ ");
INSERT INTO row_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Te Yesus o hii dinggoꞌ Aon mia atahori hetar, fo neu hule-oꞌe sia mamana rouꞌ. ");
INSERT INTO row_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Lao esa, Yesus nanori atahori sia ume sa. Leleꞌ naa hambu atahori mia partei agama Farisi ro meser agama hira, rema rena E. Ara rema mia kambo-kamboꞌ sia propensi Galilea, propensi Yudea, ma kota Yerusalem. Lamatualain fee koasa neu Yesus fo naꞌahahaiꞌ atahori mamahedꞌiꞌ ra. ");
INSERT INTO row_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","19","Leleꞌ naa, hambu atahori hira ndoro rendi atahori mamaluꞌu sa sia radꞌat sa ata. Ara sangga dalaꞌ fo ro atahori mamaluꞌuꞌ naa nisiꞌ Yesus fo naꞌahahaiꞌ e. Te ume naa sofeꞌ no atahori ena, de raꞌasusuuꞌ rala reu, te nda bisa sa. Naa de, ara rendi atahori mamaluꞌuꞌ a ume ata neu. Boe ma ara ofe randola ume a sinin, de raꞌondaꞌ atahori mamaluꞌuꞌ mana sia radꞌat ata naa. Ara raꞌondaꞌ e, nisiꞌ atahori hetar taladꞌan nara, nandaa no Yesus matan. ");
INSERT INTO row_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesus nita ma nahine nae, ara ramahere Eni bisa naꞌahahaiꞌ sira nonoon. Boe ma Ana olaꞌ neu atahori mamaluꞌuꞌ naa nae, “Ana, ngge! Au fee ambon neu sala mara ena.” ");
INSERT INTO row_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Rena Yesus olaꞌ naꞌo naa, boe ma atahori Farisi ro meser agama ra mulai ratatane rae, “Heꞌe! Akaꞌ Lamatualain mesaꞌ ne naꞌena hak fee ambon neu atahori sala-kilu nara. Te eni ia, seka, de tao aon onaꞌ Lamatualain! Ia, neꞌemutis!” ");
INSERT INTO row_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Te Yesus bubꞌuluꞌ rala nara. De Ana olaꞌ nae, “Taꞌo bee de hei duꞌa mae Au ia, olaꞌ neꞌemutis? ");
INSERT INTO row_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","24","Au ia, Atahori Matetuꞌ a. Au uꞌena hak fee ambon neu atahori sala-kilu nara. Mete ma Au ufadꞌeꞌ a atahori mamaluꞌuꞌ ia ae, ‘Au fee ambon neu sala mara ena’, hei nda mita Au koasa ngga saa sia raefafoꞌ ia sa. Te mete ma Au ae, ‘Fela leo! Haꞌi mala radꞌat ma fo baliꞌ.’ Mete ma ana fela neuꞌ ena, hei feꞌe mita koasa Ngga. Naa de, Au ae uꞌuhahaiꞌ atahori mamaluꞌuꞌ ia, naa fo hei o bubꞌuluꞌ, Au uꞌena hak fee ambon neu atahori sala-kilun.” Boe ma Ana heoꞌ mbali atahori mamaluꞌuꞌ a, de olaꞌ nae, “Mumburiꞌ leo! Haꞌi mala radꞌat ma, fo lao baliꞌ ume muu!” ");
INSERT INTO row_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Aiboiꞌ ma, atahori naa fela nambariiꞌ sia atahori hetar mata nara, de haꞌi nala radꞌat na. Boe ma ana lao baliꞌ no koa-kio Lamatualain. ");
INSERT INTO row_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Rita taꞌo naa ma basa atahori mbo-mboꞌ a. Boe ma ara soꞌu rananaru Lamatualain naran rae, “Lamatualain manaseliꞌ, o! Faiꞌ ia, hita tita dꞌala manaseliꞌ no mata ao tara ena!” ");
INSERT INTO row_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Nda doo sa ma, Yesus dea nema mia ume naa, ma nita atahori mana edꞌa bea sa endoꞌ sia mamana edꞌa bea na. Atahori naa naran Lewi. Boe ma Yesus noꞌe nae, “Uma tungga Au!” ");
INSERT INTO row_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lewi rena nala, ma ana fela neuꞌ ena, lao hela basa-bꞌasaꞌ e sia naa, de neu tungga Yesus. ");
INSERT INTO row_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Basa ma, Lewi tao fefetas fo noꞌe Yesus neu sia umen. Ana o noꞌe nonoo mana edꞌa bea nara, ro fuiꞌ ra, fo rema ra fefetas. ");
INSERT INTO row_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Te hambu atahori partei agama Farisi hira, ro meser agama ra, oꞌolaꞌ Yesus ana dedꞌenu nara rae, “Taꞌo bee de hei endoꞌ mia mo atahori nda papakeꞌ ra sa, onaꞌ mana edꞌa bea ro atahori nda malololeꞌ naa ra sa? Atahori maloleꞌ afiꞌ miꞌibꞌue mo atahori mataꞌ naa ra!” ");
INSERT INTO row_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Te Yesus nafadꞌe se nae, “Atahori mamahedꞌiꞌ memaꞌ parlu doter. Te atahori nda mamahedꞌiꞌ ra sa, nda parlu sa. ");
INSERT INTO row_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Au uma fo mete-seꞌu atahori nda maloleꞌ ra sa. Te nda uma fo mete-seꞌu atahori mana duꞌa rae sira aon ndoo-tetuꞌ ena.” ");
INSERT INTO row_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Basa ma, atahori mia partei agama Farisi ro meser agama ra oꞌolaꞌ mbali Yesus rae, “Taꞌo ia, Amaꞌ! Yohanis Mana Saraniꞌ a ana mana tungga nara puasa ma hule-oꞌe rakandooꞌ a. Atahori Farisi ra ana mana tungga nara o tao onaꞌ naa boe. Te taꞌo bee de Amaꞌ ana mana tungga mara akaꞌ raa rinu rakandooꞌ a? Ara nda puasa rita sa, do? ");
INSERT INTO row_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Te Yesus olaꞌ no se nendiꞌ nekendandaaꞌ nae, “Memaꞌ hei bubꞌuluꞌ ena, mete ma hambu feta kakabꞌiꞌ, mana neu fefetas ra nda puasa sa, te raa-rinu raꞌabeta. Mete ma touꞌ mana masao feuꞌ a feꞌe sia naa, na tantu basa se raa-rinu raꞌabꞌue. ");
INSERT INTO row_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Te dei fo lao esa, mete ma atahori feaꞌ toꞌu rendi tou mana sao feuꞌ a, na nonoo nara susa, fo ara feꞌe puasa ena.” ");
INSERT INTO row_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Basa ma, Yesus nafadꞌe nekendandaaꞌ esa fai nae, “Nda hambu atahori haꞌi teme feuꞌ eꞌetuꞌ esa, fo tanda neu badꞌu mbara manasikaꞌ sa. Te mete ma safe badꞌu a, na teme feuꞌ naa kukundu ma badꞌu a boe sika. ");
INSERT INTO row_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","38","Onaꞌ naa boe atahori nda oni tua feuꞌ nisiꞌ sambat mana mbokoꞌ sa. Te mete ma sambat fanggi e, na tuaꞌ nandali hendi e. Dadꞌi tua feuꞌ musi oni neu sambat feuꞌ boe. No taꞌo naa, Yesus nanori se nae, Eni nenori feun, afiꞌ neꞌebꞌue no atahori Farisi ra nenori mbaran. ");
INSERT INTO row_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Atahori mana ninu nita oe anggor mbaraaꞌ ena, nda hii ninu anggor feuꞌ sa. Huu nahine nae, “Anggor mana nenembedꞌa mbaraaꞌ naa, maladꞌan seli!” ");
INSERT INTO row_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Lao esa, nandaa no atahori Yahudi ra fai hahae tao ues na, Yesus no mana tungga nara laoꞌ tungga atahori osin. Boe ma ana mana tungga nara oru are-gandum mbuleꞌ, mana sia mata nara. Basa ma raisi de raa. ");
INSERT INTO row_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Sia naa, hambu atahori hira mia partei Farisi toꞌu rahereꞌ hohoro-lalane adat Yahudi. Rita Yesus ana mana tungga nara tao taꞌo naa, boe ma ara oꞌolaꞌ E rae, “Taꞌo bee de Ana mana tungga mara ralena-langga hai hohoro-lalane agama ma? Ara tao ues nandaa no fai hahae aoꞌ! Mete se sini nae! Ara oru are-gandum. Afiꞌ taꞌo naa!’. ");
INSERT INTO row_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Te Yesus olaꞌ nae, “Ona bee, ee? Hei nda misinedꞌa baꞌi Daud dudꞌuit na sa do? Baꞌi Daud no ana mana tungga nara ambu nara korororoꞌ huu ndoe rala seli ena. Boe ma ara risiꞌ lala hule-oꞌeꞌ rala reu, de haꞌi roti fo malangga agama ra fee neu Lamatuaꞌ ena, de raa. Tao-tao te akaꞌ malangga agama ra fo bole raa roti naa. Atahori laen hokoꞌ. Baꞌi Daud se raa, te nda hambu atahori fee salaꞌ neu se sa. Hei onaꞌ nda baca mita Lamatualain Susura Meumaren sa! ");
INSERT INTO row_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Pasa ndiki mara fo rena malolole! Au ia, Atahori Matetuꞌ a. Au uꞌena hak uꞌetuꞌ, atahori bisa tao saa, nandaa no fai hahae tao ues.” ");
INSERT INTO row_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Faiꞌ sa, nandaa no fai hahae tao ues esa fai, Yesus neu nanori mia ume hule-oꞌeꞌ. Sia naa, hambu touꞌ sa liman seri maꞌamateꞌ. ");
INSERT INTO row_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Sia naa o, hambu meser agama hira ro atahori mia partei agama Farisi mana sangga slak fo rae raꞌatutudaꞌ Yesus. De ara mamakuꞌ a mete ma Ana nae tao nahaiꞌ atahori lima maꞌamate seseriꞌ a, nandaa no fai hahae tao ues. No taꞌo naa, ara ratudꞌu salan sia naa neuꞌ a ena. ");
INSERT INTO row_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Te Yesus nahine masud nara ena. Naa de Ana noꞌe atahori lima maꞌamate seseriꞌ a nae, “Aꞌa, e! Uma mumburiiꞌ sia taladꞌaꞌ ia, dei!” Boe ma ana neu nambariiꞌ memaꞌ. ");
INSERT INTO row_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Basa ma Yesus natane atahori naa ra nae, “Au utane sobꞌa nggi, dei. Tungga hita hohoro-lalane agaman, hita bisa tao saa nandaa no fai hahae tao ues? Hita tao maloleꞌ do, tao deꞌulakaꞌ? Ata fee masodꞌaꞌ neu atahori, do tao nembelulutu masodꞌa nara?” ");
INSERT INTO row_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Boe ma Yesus mete rereoꞌ se, de Ana olaꞌ no atahori lima mana maꞌamate seseriꞌ a nae, “Loo limam!” Ana o loo, ma liman hai neuꞌ ena boe. ");
INSERT INTO row_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Rita taꞌo naa, ma Yesus musu nara ramanasa seli. De ara ator dalaꞌ rae, “Ata musi sangga dalaꞌ laen, fo taꞌatutudꞌaꞌ E!” ");
INSERT INTO row_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Nda doꞌ sa fai, ma Yesus nisiꞌ leteꞌ sa de hule-oꞌe. Ana hule-oꞌe tetembaꞌ sa temeao sia naa. ");
INSERT INTO row_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Mbila fefetu anan, ma Ana noꞌe nala ana mana tungga nara. Mia basa se, Ana tengga nala atahori sanahulu rua dadꞌi neu dedꞌenun. Atahori fo Ana tenggaꞌ ra, naeni: ");
INSERT INTO row_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon (fo Yesus noꞌe nae ‘Petrus’), Anderias (Simon odꞌin), Yakobis, Yohanis (Yakobis odꞌin), Filipus Bartolomeos, ");
INSERT INTO row_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateos, Tomas, Yakobis (Alpius anan), Simon (mana tungga partei poletik Selot), ");
INSERT INTO row_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yudas (Yakobis anan), ma Yudas Iskariot (mana seo hendi Yesus). ");
INSERT INTO row_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Leleꞌ onda mia leteꞌ a, Yesus no ana mana tungga nara rambariiꞌ mia rae tetuꞌ. Sia naa o, atahori hetar raꞌabꞌue. Ara, rema mia profinsi Yudea, mia kota Yerusalem, mia Tirus no Sidꞌon, kota karuaꞌ ia ra sia tasi suun. ");
INSERT INTO row_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ara rema rae rena Yesus, ma hambu ruma rae roꞌe E fo Ana naꞌahahaiꞌ atahori mamahedꞌi ra. Boe ma Ana tao nahaiꞌ se. Ana o naꞌahahaiꞌ atahori nitu taoꞌ ra, ma use-oi nitu mia atahori naa ra. ");
INSERT INTO row_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Basa atahori rae nggama E, huu mete ma ara nggama dai E, na, hambu koasa kalua mia E fo tao nahaiꞌ se. ");
INSERT INTO row_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Basa ma Yesus heoꞌ mbali ana dedꞌenu nara, de nanori nae, “Atahori mana tudꞌa-loloeꞌ re! Hei onton, huu Lamatualain mesaꞌ ne, hei Mane malolem. ");
INSERT INTO row_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Atahori mana ndoeꞌ re! Hei onton, huu dei fo Lamatualain fee nggi miꞌibeta. Atahori mana nggae luu-mbinu no rala susaꞌ re! Hei onton, huu, dei fo rala mara ramahoꞌo. ");
INSERT INTO row_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","23","Atahori mana hambu doidꞌosoꞌ huu tungga Au, Atahori Matetuꞌ ia! Hei onton, huu dei fo Lamatuaꞌ bala-bꞌae nggi sia sorga. Onaꞌ mae atahori mburu-oeꞌ ro nggi, do tao maꞌafoo nara malole mara, ma tabꞌu-roroo nggi do, use-oi nggi onaꞌ atahori deꞌulakaꞌ o, hei onton, huu dei fo Lamatuaꞌ nasanedꞌa nggi sia sorga. De mete ma atahori tao raꞌasususaꞌ nggi taꞌo naa, o, tao rala mara ramahoꞌo a! No maꞌahee! Afi heran, te atahori mana tao raꞌasususaꞌ hei aleꞌ ia, bei-baꞌi nara mana tao doidꞌoso Lamatualain mana ola-ola maꞌahulu nara. De mete ma hei hambu sususaꞌ mataꞌ naa, tao rala mara mimihoꞌo, huu dei fo Lamatuaꞌ bala-bꞌae nggii naen seli sia sorga. ");
INSERT INTO row_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Te atahori mamasuꞌi re! Hei soe, huu hei masodꞌa nemehoꞌot ma, losaꞌ ia ena. ");
INSERT INTO row_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Atahori maꞌabetaꞌ re! Hei soe, huu dei fo hei hambu fai ndoes manaseliꞌ Atahori mana kidꞌo-kedꞌe leliꞌ re! Hei soe, huu susa-sonaꞌ a nema tao nggi nggae luu-mbinu. ");
INSERT INTO row_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Atahori mana maꞌahe hadꞌa-hormat re! Hei soe, huu maꞌahulun bei-baꞌi mara, koa-boꞌu mana ola-olaꞌ ombo-koson ra! ");
INSERT INTO row_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Boe ma Yesus olaꞌ nakandoo nae, “Pasa ndikim fo rena malolole! Musi sue musu mara, ma tao dꞌala maloleꞌ neu atahori mana mburu-oeꞌ ro nggo. ");
INSERT INTO row_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Hule-oꞌe moꞌe Lamatualain tao dꞌala maloleꞌ fee neu atahori mana sumba-ndon nggo. Ma moꞌe Ana tao dꞌala maloleꞌ fee neu atahori mana fua salaꞌ mata-mataꞌ neu nggo. ");
INSERT INTO row_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mete ma atahori mbasa nasum seri, na, soro fo ana mbasa nasum seri fai. Mete ma hambu atahori rambas nala badꞌu matobꞌim, na, fee badꞌum neu e boe. ");
INSERT INTO row_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mete ma hambu atahori roꞌe sudꞌiꞌ a sa ma esa, na, fee neuꞌ ena. Boe ma mete ma ana haꞌi nendi saa ma esa, na, hela neu fo ana hambu e leo. Afiꞌ muu moꞌe baliꞌ e fai! ");
INSERT INTO row_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Musi tao atahori ra, onaꞌ saa fo ho mae fee se tao neu nggo boe. ");
INSERT INTO row_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ho hiiꞌ a mutudꞌu susueꞌ neu atahori mara. Naa maloleꞌ. Te naa, lenan, sa? Huu atahori deꞌulakaꞌ ra o sue atahori nara boe! ");
INSERT INTO row_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Mete ma taoꞌ a maloleꞌ neu akaꞌ atahori mana tao maloleꞌ neu nggo, naa lenan saa? Huu atahori deꞌulakaꞌ ra o bala-bꞌae maloleꞌ no maloleꞌ taꞌo naa boe. ");
INSERT INTO row_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Mete ma ho fee pindan doi ma neu akaꞌ atahori mana bisa fee baliꞌ, na, naa lenan sa? Huu atahori deꞌulaka ra o fee pindan doi nara reu atahori feaꞌ ra boe, sadꞌi mbila do fini esan, na, ara simbo baliꞌ manadaiꞌ. ");
INSERT INTO row_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Te manaselin, taꞌo ia: Sue musu mara! Ma tao dꞌala maloleꞌ fee se. Saa fo ara parlu, na, fee pindan. Afiꞌ dꞌuꞌa-dꞌuꞌaꞌ mae, ara fee baliꞌ, do hokoꞌ. No taꞌo naa, dei fo Lamatualain bala-bꞌae baliꞌ nggo. Boe ma dadꞌi muu Lamatualain Mana Seliꞌ anan. Huu masodꞌam onaꞌ Amam mana hiiꞌ a tao maloleꞌ fee atahori deꞌulakaꞌ ra. Ana o tao maloleꞌ neu atahori mana nda rahine roꞌe makasi sa. ");
INSERT INTO row_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Dadꞌi musi mutudꞌu susueꞌ neu atahori, onaꞌ Amam mana sia sorga natudꞌu susueꞌ neu nggo. ");
INSERT INTO row_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Yesus nanori nakandoo nae, “Afiꞌ nile leli atahori, fo atahori afiꞌ nile leli nggo boe. Afiꞌ fua salaꞌ neu atahori, fo atahori afiꞌ fua salaꞌ neu nggo boe. Fee ambon neu atahori sala nara, naa fo ara o fee ambon neu sala mara boe. ");
INSERT INTO row_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mete ma ho fee atahori saa fo ara parlu, na, dei fo ho o simbo boe. Huu dei fo Lamatuaꞌ mete-seꞌu nggo fo simbo naeꞌ lenaꞌ fai. Naa onaꞌ atahori ombo fufue naen seli nisiꞌ balek uꞌukuꞌ rala neu, de nggonggonggar e ma ndeni e, fo ombo nesofe seluꞌ e losa mbori rae neu. Ho simboꞌ a nanaen onaꞌ naa boe. Mete ma ho fee mbeiꞌ a, na ho simbo bꞌaliꞌ mbeiꞌ a boe. Te mete ma ho fee naeꞌ na, ho o simbo baliꞌ nanaen seli boe.” ");
INSERT INTO row_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesus o nanori nendiꞌ nekendandaaꞌ boe. Ana dui nae, “Atahori pokeꞌ nda bisa natudꞌu dalaꞌ fee atahori pokeꞌ sa. Te hokoꞌ naa ruꞌa se tudꞌa ndolaꞌ rala reu! ");
INSERT INTO row_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ana sakolaꞌ nda mahineꞌ lenaꞌ meser na sa! Te mete ma ana tungga malolole meser na nenorin, ana bisa dadꞌi onaꞌ meser na boe. ");
INSERT INTO row_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ho hiiꞌ a mete maꞌabebesa atahori sala ana nara. Te sala monaem na, nda mae naa salaꞌ sa. Naa onaꞌ ho mita rae dekeꞌ sa sia atahori matan. Tao-tao te balok monaeꞌ sa natabꞌaꞌ sia mata ma, te nda medꞌa sa! ");
INSERT INTO row_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Taꞌo bee de mumburani olaꞌ mae, “Toronooꞌ! Uma fo au nggue hendi rae dekeꞌ sia matam dei.” Tao-tao te nda mita saa-saa sa boe, huu hambu balok natabꞌa sia matam naa! Woe! Memaꞌ ho, atahori mana dea-ralaꞌ tebꞌe! Haꞌi hendi balok naa mia matam dei. Dei fo feꞌe mita, fo tulun nggue hendi rae dekeꞌ sia nonoom matan.” ");
INSERT INTO row_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yesus fee seluꞌ nekendandaaꞌ sa nae, “Hau huu maloleꞌ, nda bisa nabꞌoa bꞌoa nda maloleꞌ sa. Boe ma hau huu nda maloleꞌ sa, nda bisa nabꞌoa bꞌoa maloleꞌ sa. ");
INSERT INTO row_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Atahori rahine rae hau huuꞌ sa maloleꞌ do hokoꞌ, mia hau naa bꞌoa nara. Basa atahori bubꞌuluꞌ rae, atahori nda seu jambu bꞌoaꞌ, do anggor boaꞌ mia hau huu manggouꞌ sa. ");
INSERT INTO row_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Onaꞌ naa boe atahori rala meumareꞌ, ana tao dꞌala maloleꞌ. Te atahori rala manggenggeoꞌ, ana tao dꞌala deꞌulakaꞌ. Huu atahori dedꞌea-oꞌolan, natudꞌu eni dudꞌuꞌan.” ");
INSERT INTO row_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Basa ma Yesus tute oꞌolan fai nae, “Hei akaꞌ moꞌe Au mikindooꞌ a mae, ‘Malangga’. Te taꞌo bee de hei nda nau tungga Au oꞌola ngga sa? ");
INSERT INTO row_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Atahori mana rema rena Au, ma tao tungga oꞌola Ngga, eni, onaꞌ ");
INSERT INTO row_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","atahori mana nae tao ume manggateeꞌ. Ana ali malolole naꞌahuluꞌ fanderen ndolan sia rae isiꞌ losa hambu fatu manggateeꞌ. Basa de ana tao fanderen sia fatu naa ata, dei de feꞌe naririi ume a. Mete ma oe mandaliꞌ a nandali nema o, ume naa nda nanggonggaꞌ sa, huu fanderen na manggateeꞌ. ");
INSERT INTO row_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Te atahori mana rena no rala banggi-bꞌanggiꞌ ma nda tungga Au oꞌola ngga sa, eni onaꞌ atahori mana naririi umen, te nae sadꞌi dadꞌi. Ana nda tao fanderen sa, te dꞌama ume a siaꞌ a rae isiꞌ sia loe suun. De leleꞌ oe mandaliꞌ a nandali nema ma, nandali nendi ume a!” ");
INSERT INTO row_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesus nanori basa ma Ana lao baliꞌ kota Kapernaum neu. ");
INSERT INTO row_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Sia naa hambu malangga soldꞌadꞌu Roma esa. Ana naꞌena ana mana tao ues esa, dadꞌi eni ana nemeheren. Ana mana tao ues naa, namahedꞌi naeꞌ a mate. ");
INSERT INTO row_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Leleꞌ malangga rena soꞌal Yesus, boe ma ana haitua atahori lasiꞌ Yahudi hira naa reu roꞌe Yesus nema fo tao nahaiꞌ ana mana tao ues naa. ");
INSERT INTO row_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ara kokoe Yesus, fo mete ma nau, na, Ana tungga no se fo naꞌahahaiꞌ atahori naa. Ara kokoe E rae, “Amaꞌ! Atahori Roma ia, atahori maloleꞌ! Eni nandaa Amaꞌ tulu-fali e. ");
INSERT INTO row_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Te huu ana naririi ume hule-oꞌeꞌ sa fee hai, huu ana sue hai atahori Yahudi ra.” ");
INSERT INTO row_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Boe ma Yesus tungga no se. Ara nda feꞌe losa ume sa, te malangga denu nonoon nendi haraꞌ neu Yesus nae, “Papa afiꞌ bengge-bꞌengge uma fai, huu au nda undandaa simbo Papa sia ume ngga sa. ");
INSERT INTO row_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","8","Boe ma au nda undandaa uma undaa o Papa sa. Memaꞌ Papa naꞌena koasa. Dadꞌi sadꞌi Papa olaꞌ miaꞌ a naa o, ana mana tao ues ngga hai neuꞌ ena. Au uhine dalaꞌ ia, huu au malangga ngga naꞌena koasa fo parenda au. Ma au o uꞌena koasa fo parenda soldꞌadꞌu nggara. Mete ma au parenda ana mana tungga ngga ae, ‘Misiꞌ naa!’ Ana neu. Mete ma au ae, ‘Ia uma!’ na ana nema. No mete ma au parenda ana mana tao ues ngga ae, ‘Tao ues ia!’ ana tao taꞌo naa. Dadꞌi sadꞌi Papa olaꞌ a, na ana mana tao ues ngga ia, hai neuꞌ ena.” ");
INSERT INTO row_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Rena taꞌo naa ma Yesus heran. Ana heoꞌ dꞌean mbali atahori hetar mana tungga E. Boe ma Ana “Olaꞌ nae! Doon basa ia ena, te Au nda feꞌe undaa o atahori Yahudi esa sa boe, nemeheren onaꞌ atahori Roma ia!” ");
INSERT INTO row_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Dadꞌi Yesus laoꞌ losaꞌ a naa. Basa ma, malangga nonoo nara lao baliꞌ. Ara losa malangga umen, ma rita anaꞌ naa hai ena. ");
INSERT INTO row_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Mbilaꞌ neu, ma Yesus no ana mana tungga nara lao risiꞌ kamboꞌ sa, naran Nain. Atahori hetar laoꞌ raꞌabꞌue ro se. ");
INSERT INTO row_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Leleꞌ ara rae deka ro lelesu masoꞌ kamboꞌ a, atahori nononggoꞌ sa rae dea reu raꞌoi mamates. Mana mateꞌ naa, ina falu sa ana mone isen. ");
INSERT INTO row_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Leleꞌ Yesus nita ina falu naa, ma ralan tudꞌa kasian. Boe ma Ana olaꞌ no ina falu a nae, “Mama! Dꞌai ena, sudꞌi nggae!” ");
INSERT INTO row_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Boe ma Yesus neu deka-deka, ma kois radꞌat mamates naa. Boe ma atahori mana lemba radꞌat a, hahae tahan. Boe ma Yesus olaꞌ neu atahori mates a nae, “Ana moneꞌ e! Fela leo!” ");
INSERT INTO row_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Boe ma, anaꞌ a nasodꞌa baliꞌ, ma fela nggua-nggua neuꞌ ena. Boe ma ana ola-olaꞌ no basa atahori mana ririi ndule e. Basa ma Yesus nafadꞌe neu inaꞌ naa nae, “Mama! Anam sie.” ");
INSERT INTO row_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Basa atahori mana sia naa ra, ramatau rae mate! Boe ma ara koa-kio Lamatualain rae, “Lamatualain denu mana ola-olan manaseliꞌ sa fee nema hita!” Hambu laen fai rae, “Lamatualain nema sia hita taladꞌan ena, de natudꞌu rala malolen ena!” ");
INSERT INTO row_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Boe ma dudꞌuit naa nenedꞌui-bꞌenggaꞌ sia bee-bꞌee sia propensi Yudea, losa nusaꞌ laen boe. ");
INSERT INTO row_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","20","Yohanis Mana Saraniꞌ a ana mana tungga nara rena basa saa fo Lamatuaꞌ Yesus taoꞌ ra ena. Dadꞌi ara reu dui neu Yohanis sia bꞌui rala. Boe ma ana denu atahori rua reu risi Yesus fo ratane E rae, “Amaꞌ ia, tebꞌe-tebꞌeꞌ Kristus, fo hai mihaniꞌ a, do? Do hai musi mihani atahori laen fai?” De ara randaa ro Yesus, ma ratane taꞌo naa. ");
INSERT INTO row_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Leleꞌ mana nendi haraꞌ ra mia naa, Yesus naꞌahahaiꞌ atahori hetar mia hedꞌi-nggarau nara mataꞌ-mataꞌ. Ma Ana oi nitu mia atahori nitu daiꞌ ra. Ana o tao nahaiꞌ atahori pokeꞌ ra fo rita baliꞌ. ");
INSERT INTO row_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Basa ma Yesus nafadꞌe Yohanis ana dedꞌenu nara nae, “Ama baliꞌ mii mifadꞌe aꞌa Yohanis, basa-bꞌasa saa fo hei rena ma mitaꞌ a, onaꞌ Lamatualain mana ola-olan Yesaya suraꞌ nae, ‘Atahori pokeꞌ, nita baliꞌ. Atahori mamaluꞌuꞌ, fela lao-laoꞌ. Atahori hedꞌi kusta, dadꞌi mamalelenuꞌ. Atahori mbakeꞌ, bisa rena. Atahori mates, rasodꞌa baliꞌ. Atahori manatudꞌa-loloeꞌ, rena Hara-lii Maloleꞌ.” ");
INSERT INTO row_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Baliꞌ mii mifadꞌe aꞌa Yohanis mae, ‘Atahori nda mana mae simbo Au sa, dei fo ara onton tebꞌe.’” ");
INSERT INTO row_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Leleꞌ Yohanis ana mana tungga nara baliꞌ boe, ma Yesus olaꞌ no atahori naeꞌ naa ra soꞌal Yohanis nae, “Leleꞌ hei mii sangga Yohanis sia mamana maꞌafuniꞌ naa, hei duꞌa mae hei mii mindaa mo atahori onaꞌ beek? Hei nda dꞌua mae mii mindaa mo atahori mana male-maꞌaꞌ onaꞌ hau oo neneuli-faeꞌ tungga anin sa! ");
INSERT INTO row_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Hei nda duꞌa mae mii mindaa mo atahori mana pake bua-baꞌu mafelit sa, huu atahori mataꞌ naa leo siaꞌ a ume maneꞌ! ");
INSERT INTO row_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Dadꞌi hei mii mindaa mo see sia naa? Hei duꞌa mae mii mindaa mo Lamatualain mana ola-olan, do? Tebꞌe! Te eni naa, mana ola-olaꞌ manaseliꞌ tebꞌe. ");
INSERT INTO row_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Huu sia Susura Meumareꞌ nenesuraꞌ memaꞌ Yohanis dꞌalan oi, ‘Rena! Au denu atahori ngga, fo neu soi dalaꞌ fee nggo.’ ");
INSERT INTO row_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Sia raefafoꞌ ia, nda hambu atahori esa saa boe, manaseliꞌ lenaꞌ Yohanis. Te sia Lamatuaꞌ mamana parendan, atahori mana maꞌabꞌuit a o manaseliꞌ lenaꞌ Yohanis.” ");
INSERT INTO row_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Atahori mana rena Yesus oꞌolan, rahine rae, Lamatuaꞌ dꞌalan naa, dꞌala masodꞌa ndoo-tetuꞌ. Mana edꞌa bea ra o rahine boe. Huu feꞌesaꞌan Yohanis sarani se, ma nanori se ena. ");
INSERT INTO row_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Te atahori mia partei agama Farisi ma mana mahine hukun Yahudi ra, nda nau tungga Lamatualain hihii-nanaun sa ena. Naa de, ara nda roꞌe Yohanis sarani se sa. ");
INSERT INTO row_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Boe ma Yesus natane nae, “Au ae uꞌusasamaꞌ atahori leleꞌ ia ra ro saa e? Atahori mataꞌ saa ra ia ra? ");
INSERT INTO row_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ara onaꞌ ana-ana mana endo-endoꞌ sia pasar. Ara soa randu ma unggu-remu rae, ‘Hai fuu suling rame-rame, te hei nda lendo-foti maꞌahee sa. Boe ma hai sodꞌa sosodꞌa beꞌe mamates, te hei nda nggae sa.’ ");
INSERT INTO row_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Huu Yohanis mana saraniꞌ a nda ninu anggor, ma ana hiiꞌ a puasa, na, hei moꞌe e mae, ‘Nitu daiꞌ!’ ");
INSERT INTO row_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Te ia na Au, Atahori Matetuꞌ a, inu anggor ma ua roti onaꞌ biasa. Boe ma, hei moꞌe Au mae, ‘Eni ia, mana bare-tasaꞌ! Ma mana mafuꞌ seli! Neu naꞌabꞌue no mana edꞌa bea ra! Eko-daꞌi no atahori nda papakeꞌ ra sa. Ana nda ma hadꞌat sa. ");
INSERT INTO row_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Te ama meteꞌ a, Au dedꞌea ngga ia! Atahori mana bubꞌuluꞌ no matetuꞌ, ara tungga Lamatuaꞌ hihii-nanaun.” ");
INSERT INTO row_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Sia kota naa, hambu atahori Farisi sa, naran Simon. Lao esa, ana noꞌe Yesus se reu raa sia umen. Yesus se simbo rala haraꞌ ma reu fo endo rae raa. ");
INSERT INTO row_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Leleꞌ naa, ina manendit sa rena oi, Yesus naa sia naa. Ma ana rala neu, de toꞌu nendi mina maꞌameniꞌ mafelit boto sa. ");
INSERT INTO row_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ana nema tungga deaꞌ deka no Yesus. De sendeꞌ lululanggan sia Yesus ein. Ma ana nggae losa luun titi dai Yesus ein. Ana seka Yesus ein nendiꞌ langga fulun, ma idꞌu nasafafali Yesus ein. Basa ma ana mbori mina maꞌameniꞌ naa neu Yesus ein. ");
INSERT INTO row_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Simon, nahine inaꞌ naa leleo-lalaon. Naa de ana duꞌa sia ralan nae, “Ia dadꞌi bukti Yesus ia, nda Lamatualain mana ola-olan sa! Mete ma tebꞌe-tebꞌe Lamatualain mana haitua E, naa Yesus bubꞌuluꞌ, inaꞌ mana kois Eni a, ina manendit. Lamatualain mana ola-ola nara nda onaꞌ E sa, huu atahori meumareꞌ nda deka-deka ro atahori manggenggeoꞌ ra sa!” ");
INSERT INTO row_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Te Yesus nahine Simon dudꞌuꞌan. Boe ma Ana nae, “Aꞌa Simon! Taꞌo ia, aꞌa. Au ae ufadꞌe nggo dalaꞌ sa.” Boe ma Simon nataa nae, “Neu! Ama Meser, olaꞌ leo.” ");
INSERT INTO row_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","De Yesus fee nekendandaaꞌ sa nae, “Atahori sa hiiꞌ a fee atahori pindan doi na. Lao esa ana fee atahori rua pindan doin. Ana fee esa doi fulaꞌ natun lima; ma esa ka akaꞌ lima nuluꞌ a. ");
INSERT INTO row_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Te losa fain, ruꞌa se nda fee rala baliꞌ dꞌoiꞌ naa ra sa. Boe ma atahori mana fee doiꞌ naa, kasian ruꞌa se. Naa de ana mboꞌi ruꞌa se mia huta nara. Dadꞌi tungga aꞌa Mon dudꞌuꞌan, atahori karuaꞌ mana pindan dꞌoiꞌ naa ra, bee ka sue lenaꞌ atahori mana hiiꞌ a fee pindan dꞌoiꞌ a?” ");
INSERT INTO row_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon nataa neuꞌ ena nae, “Neꞌo mana nahuta naeꞌ a!” Yesus nataa nae, “Tebꞌe aꞌa!” ");
INSERT INTO row_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Boe ma Ana mete mbali inaꞌ a, ma olaꞌ neu Simon nae, “Sobꞌa aꞌa Simon mete inaꞌ ia. Leleꞌ Au uma isiꞌ aꞌa umen rala, aꞌa nda haꞌi hela oe fo safe ei ngga tungga hita adat na sa. Te inaꞌ ia naꞌadoe ei ngga nendiꞌ luu-oen, basa ma seka namadꞌaꞌ nendiꞌ langga fulun. ");
INSERT INTO row_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Boe ma faaꞌ ra, leleꞌ soru Au isiꞌ aꞌa Mon umem rala, aꞌa Simon nda idꞌu Au, tungga hita adat na sa. Te eniꞌ a Au isiꞌ ume ia rala, inaꞌ ia nda naloeꞌ idꞌu ei ngga sa. ");
INSERT INTO row_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Aꞌa Simon o liliiꞌ adat fo mbori mina neu fuiꞌ ra langgan. Leleꞌ Au rala uma faaꞌ ra, inaꞌ ia mbori mina maꞌameni mafelit neu ei ngga. ");
INSERT INTO row_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Aꞌa Simon rena malolole dei! Inaꞌ ia salan memaꞌ naeꞌ. Te Lamatuaꞌ fee ambon neu basa sala nara ena, huu ana natudꞌu susuen ma rala makasin nae-nae neu Au. Te atahori mana namedꞌa aon nda mana tao salaꞌ naeꞌ sa, ana o namedꞌa nae eni nda parlu hambu ambon naeꞌ sa. Naa de ana nda nahine susueꞌ, ma nda namahoꞌo nahine noꞌe makasi mbali Lamatuaꞌ sa.” ");
INSERT INTO row_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Basa ma Yesus olaꞌ neu inaꞌ naa nae, “Au fee ambon neu sala mara ena!” ");
INSERT INTO row_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Atahori mana endoꞌ raa raꞌabꞌue, ara utu-utu rae, Aweee! Ana duꞌa nae, Eni seka ia?! Nambarani fee ambon neu atahori salan, o! Tao-tao te akaꞌ Lamatualain mesaꞌ ne mana naꞌena hak fee ambon neu atahori sala nara! Cih!” ");
INSERT INTO row_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Te Yesus nafadꞌe neu inaꞌ naa nae, “Huu mumuhere Au ena, naa de Lamatualain fee nggo masodꞌaꞌ ena. Baliꞌ leo mo sodꞌa-moleꞌ!” ");
INSERT INTO row_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nda dooꞌ sa ma, Yesus no ana dedꞌenun kasanahulu rua nara, reu laoꞌ ndule kota-kota ma kambo-kamboꞌ sia naa. Ana laoꞌ nafadꞌe atahori soꞌal Lamatualain parendan. Naa dadꞌi hara-lii maloleꞌ neu se. ");
INSERT INTO row_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Sia nononggoꞌ naa, hambu inaꞌ ruma tungga boe. Inaꞌ ia ra, ruma parna ramahedꞌi mataꞌ-mataꞌ, ma ruma nitu taoꞌ boe. Te Yesus tao nahaiꞌ basa se ena. Onaꞌ Maria mia kambo Magdala. Feꞌesaꞌan Yesus oi hendi nitu hitu mia e. ");
INSERT INTO row_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Susana no mama Yohana o tungga boe. Mama Yohana ia, ama Kusa saon. Kusa ia, malangga mana nanalalau sia mane Herodes ume panggat na. Feꞌe hambu inaꞌ hetar mana laoꞌ roo Yesus se. Inaꞌ ia ra tanggon Yesus se doꞌi dꞌala nara. ");
INSERT INTO row_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Lao esa, atahori rema mia kamboꞌ hetar fo sangga Yesus. Leleꞌ atahori ra raꞌabꞌue ena, ma Ana dui se nekendandaaꞌ sa nae, ");
INSERT INTO row_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Hambu atahori mana ue rae sa neu nggari fini sia osin. Fini ruma tudꞌa sia dalaꞌ. Leleꞌ atahori laoꞌ sia naa, ara tatabꞌu fini ra. Basa ma mbuiꞌ ra rema de bꞌidꞌo-raa hendi basa se. ");
INSERT INTO row_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Fini ruma tudꞌa sia rae fatuꞌ. Fini ra ranumbu boe, te male hendi se, huu oe mbeiꞌ a. ");
INSERT INTO row_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Fini ruma tudꞌa sia mamana dꞌuri nggaut. De leleꞌ fini ra ranumbu boe, dꞌuri nggaut hapi nisa se. ");
INSERT INTO row_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Te fini ruma fai, tudꞌa sia rae isi maloleꞌ. Ara ranumbu, ma raꞌamoko losa rabꞌoa. Fini naa ra fee baliꞌ buna-bꞌoaꞌ lao natun sa.” Dꞌui basa taꞌo naa, ma Yesus nateꞌe nekendandaaꞌ naa, ma nafadꞌe nae, “Hei mana pasa ndiki mara, ama duꞌa malolole!” ");
INSERT INTO row_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Basa ma, Yesus ana dedꞌenu nara ratane nekekendandaaꞌ a sosoan. ");
INSERT INTO row_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ana nataa nae, “Taꞌo ia! Huu hei tungga tebꞌe-tebꞌeꞌ Lamatualain hihii-nanaun ena, naa de Au ufadꞌe relo-relo fo ama bubꞌuluꞌ, Lamatuaꞌ nae parenda atahori nara taꞌo bee. Te atahori feaꞌ ra nda nau tao-afiꞌ neu Lamatuaꞌ hihii-nanaun sa. Naeni de Au unori se endiꞌ nekendandaaꞌ. Huu Lamatuaꞌ mana ola-ola nara suraꞌ memaꞌ soꞌal atahori ia ra nae, “Ara rita ena, te nda nau rahine sa. Ara rena ena, te nda nau bubꞌuluꞌ sa.” ");
INSERT INTO row_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Boe ma Yesus nafadꞌe nekendandaaꞌ naa sosoan, nae “Fini naa, naeni Lamatualain Dedꞌea-oꞌolan. ");
INSERT INTO row_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Fini mana tudꞌa sia dalaꞌ a, naeni atahori mana rena Lamatuaꞌ Dedꞌea oꞌolan, te basa ma nitur malanggan nema rambas nendi Dedꞌea Oꞌolaꞌ ra mia rala nara. No taꞌo naa, ara nda ramahere Lamatuaꞌ, ma nda hambu masodꞌaꞌ sa. ");
INSERT INTO row_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Fini mana tudꞌa sia rae fatuꞌ a, naeni atahori mana rena Lamatuaꞌ Dedꞌea-oꞌolan no nemehoꞌot. Te oka nara nda romaꞌ rala reu sa. Ara mulai ramahere, te mete ma hambu sususaꞌ, ara tudꞌa neuꞌ ena. ");
INSERT INTO row_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Fini mana tudꞌa sia mamana dꞌuri-nggaut naa, naeni atahori mana rena ma simbo Lamatuaꞌ Dedꞌea-oꞌolan. Te nda dooꞌ sa ma, ara liliiꞌ hendi Dedꞌea-oꞌolaꞌ naa ra, huu ara hiiꞌ a sebꞌo-mue ro ue-tatao nara, hata-hetoꞌ mataꞌ-mataꞌ, ma hiiꞌ a rasodꞌa no nemehoꞌotꞌ a. Naa de, nemehere nara, nda naꞌena buna-bꞌoaꞌ saa-saa sa boe. ");
INSERT INTO row_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Te fini mana tudꞌa sia rae isi maloleꞌ naa, naeni atahori rala ndoos no maloleꞌ. Leleꞌ ara rena Lamatualain Dedꞌea-oꞌolan, ara mbedꞌaꞌ malolole sia rala nara. No taꞌo naa, ramahere rakandoo, ma tao dꞌala maloleꞌ naeꞌ.” ");
INSERT INTO row_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Basa ma Yesus olaꞌ seluꞌ nae, “Nda hambu atahori rambilaꞌ lambu tiiꞌoek, basa na tatana hura rae neu e sa. Boe ma nda hambu atahori mbedꞌaꞌ lambu nisiꞌ koi a raeꞌ sa. Mete ma tao taꞌo naa, na, atahori nda rita rondan sa ena. Lambu mana naꞌena nggunaꞌ, naeni mana mbedꞌaꞌ sia mamana naruꞌ ata, naa fo rondan fee manggareloꞌ neu atahori mana rala rema. ");
INSERT INTO row_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ia naa basa mana maꞌafuniꞌ ra, dei fo nenenitaꞌ. Boe ma basa saa fo atahori nda rahine leleꞌ ia sa, dei fo ara hambu rahine boe. ");
INSERT INTO row_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Dadꞌi hei musi duꞌa malolole dalaꞌ ia ra. Atahori mana nau sangga nahine tebꞌe-tebꞌeꞌ Lamatuaꞌ hihii-nanaun, ana boe nahine. Te atahori fo nda mana taoafiꞌ neu Lamatuaꞌ hihii-nanaun sa ana boe namanggoa. ");
INSERT INTO row_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Lao esa, Yesus sebꞌo-mue no atahori hetar. Boe ma maman no odꞌi nara rema rae randaa ro E. Te ara nda bisa deka-deka ro E sa, huu atahori naen seli. ");
INSERT INTO row_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Boe ma hambu atahori sa neu nafadꞌe Yesus nae, “Amaꞌ! Mamam no odꞌi mara sia dꞌean. Ara rae randaa ro Amaꞌ.” ");
INSERT INTO row_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Boe ma Ana nataa nae, “Ia! Te taꞌo ia. Mama ngga ma toronoo matetu nggara, naeni atahori mana rena ma tao tungga Lamatualain Dedꞌea-oꞌolan.” ");
INSERT INTO row_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Lao esa, Yesus noꞌe ana mana tungga nara nae, “Lao teu sae ofaꞌ, fo tisiꞌ dꞌano seriꞌ,” Boe ma ara sae ofaꞌ sa, de ara lao. ");
INSERT INTO row_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Leleꞌ ara lao, ma Yesus sungguꞌ. Nda dooꞌ sa ma, sanggu anin losa. Ma ree poꞌa ofaꞌ rala neu, de raeꞌ a molo. ");
INSERT INTO row_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ana mana tungga nara rita taꞌo naa ma, ara fafae Yesus rae, “Papa! Papa, e! Fela fo tulun dei! Hita taeꞌ a molo mate ia ena!” Boe ma Yesus o fela boe. De Ana ai anin no ree a nae, “Muloeꞌ leo!” Boe ma ree no anin o namalino neuꞌ ena. ");
INSERT INTO row_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Basa ma Ana bꞌua ana mana tungga nara nae, “Taꞌo bee de hei nda feꞌe mimihere Au sa?” Ara ramatau ma heran. Boe ma esa natane esa nae, “Awii! Yesus ia, seka? Taꞌo bee de Ana bisa parenda ree-anin, fo tungga hihii-nanaun e?” ");
INSERT INTO row_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Nda dooꞌ sa ma, Yesus se losa nusa Gerasa, sia dano Galilea seriꞌ. ");
INSERT INTO row_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Sia naa, hambu atahori sa nitu ra tao e dooꞌ ena. Ana nda ma umeꞌ sa, de ana leo siaꞌ a rates. Fais-fais na ana laoꞌ neu-nema no maꞌaholan. Huu nitu ra parenda e rakandondooꞌ a. Atahori paꞌa e rasafafali rendiꞌ rante ma kale besiꞌ ena, te ana naꞌetuꞌ hendi se. Boe ma nitu ra akaꞌ raꞌasusuuꞌ e fo nela nisiꞌ mamana rouꞌ. Leleꞌ Yesus se onda mia ofaꞌ ma, atahori muluꞌ naa neu nisiꞌ Yesus. Atahori naa nggasi, ma natudꞌa aon sia Yesus ein. Boe ma Yesus parenda nae, “Woi, nitu! Kalua mia atahori ia!” Boe ma atahori muluꞌ naa nggasi nae, “Woi afiꞌ ngganggu au! Huu au uhine nggo, Yesus, Lamatualain manaseliꞌ a Anan! Afiꞌ tao doidꞌoso au!” ");
INSERT INTO row_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesus natane e nae, “Naram seka?” Boe ma nitu naa nataa nae, “Legion, huu hai hetar, ona soldꞌadꞌu rifon-rifon.” Ana naꞌo naa, huu nitu hetar leo sia aon rala. ");
INSERT INTO row_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nitu ra roꞌe rakandooꞌ a mbali Yesus fo afiꞌ fee sira risiꞌ Ndola Doidꞌosoꞌ a, naeni koasa deꞌulakaꞌ ra mamanan. ");
INSERT INTO row_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Te deka-deka sia naa, hambu fafi nononggo monaeꞌ esa sosoꞌa rae fo sangga nanaat sia leteꞌ a suun. De nitu ra roꞌe Yesus rae, “Denu hai misiꞌ fafi naa ra rala!” Boe ma Yesus naꞌaheiꞌ. ");
INSERT INTO row_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Basa ma, nitu ra lao hela touꞌ naa, de risiꞌ fafi naa ra rala. Basa fafi ra ramulu, de relaꞌ mia leteꞌ naa, ma boke risiꞌ dano rala reu. De basa se mate rasamele. ");
INSERT INTO row_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Mana manea fafi ra rita taꞌo naa ma rela reu dui basaꞌ e ndule kambo-kamboꞌ mana sia naa ra. ");
INSERT INTO row_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Rena rala dudꞌuit naa, ma atahori hetar reu risiꞌ mamanaꞌ naa. Ara rae rita mataꞌ saa mana dadꞌiꞌ ena. Losa naa, ma rita atahori nitu dꞌaiꞌ a endoꞌ subꞌa-subꞌa deka Yesus ein. Ana pake bua-baꞌus ena, ma mulun mopo ena. Rita taꞌo naa, ma basa se ramatau ");
INSERT INTO row_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Basa ma atahori mana rita mana dadꞌiꞌ naa ra, dui atahori mana rema feuꞌ ra soꞌal taꞌo bee de atahori muluꞌ naa hai. ");
INSERT INTO row_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Boe ma basa atahori Gerasa mana leo sia mamanaꞌ naa, roꞌe mbali Yesus fo Ana lao hela se, huu basa se ramatau rae mate. Boe ma Yesus se hene ofaꞌ neu, de baliꞌ risiꞌ dano Galilea seriꞌ reu. ");
INSERT INTO row_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Te atahori faaꞌ ra mana nenemboꞌiꞌ mia nitu ra, akaꞌ noꞌe mbali Yesus nae, “Amaꞌ! Au tungga ꞌo nggo boe!” Te Yesus nataa nae, ");
INSERT INTO row_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Taꞌo ia! Malole lenaꞌ baliꞌ misiꞌ bobꞌonggi mara, fo dui se Lamatualain malolen, fo Ana tao fee nggoꞌ a.” Basa ma, atahori naa laoꞌ rereoꞌ kota naa, ma dui neu basa atahori soꞌal Yesus tao nahaiꞌ eni. ");
INSERT INTO row_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Basa ma Yesus se lao risi dꞌano Galilea seriꞌ. Leleꞌ ara onda mia ofaꞌ, atahori hetar nea-neaꞌ E ena. Ara reu rakarumbu rae soru E. ");
INSERT INTO row_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Sia naa o, hambu atahori esa, naran Yairus. Eni, malangga ume hule-oꞌe sia kota naa. Anan, akaꞌ esaꞌ a; ana fetoꞌ, too sanahulu rua ena. Ana fetoꞌ naa namahedꞌi naeꞌ, de naeꞌ a mate. Leleꞌ Yairus nita Lamatuaꞌ Yesus nema, ana neu sendeꞌ lululanggan sia Yesus matan. Ana noꞌe Yesus neu sia umen, fo tulu-fali ana feton. Leleꞌ Yesus naꞌaheiꞌ boe, ma ara lao risiꞌ Yairus umen. Atahori hetar o rae tungga boe de raote de reu. Naa de ara laoꞌ rakaseseti. ");
INSERT INTO row_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Hambu inaꞌ sa o tungga no se boe. Ana namahedꞌi mboꞌa raaꞌ nda naloeꞌ bꞌatuu sa, doo na too sanahulu rua ena. Ana nabꞌasaꞌ dꞌoin no hata-heton ena, huu bꞌae neu dꞌoter ra. Te nda hambu esa bisa tao nahaiꞌ e sa boe. Hedꞌi na naa, akaꞌ mesu-fela nakandooꞌ a. ");
INSERT INTO row_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","De ana neu deka-deka neu Yesus dean. Boe ma ana kois Yesus badꞌun suun. Leleꞌ ana kois basa boe ma, hedꞌi mboꞌa-mboꞌa raa na naloeꞌ neuꞌ ena boe. ");
INSERT INTO row_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Aboiꞌ ma Yesus nambariiꞌ, de natane nae, “Seka mana kois Au?” Te atahori esa o nda nataa sa boe. De Petrus nae, “Malangga, dei! Te atahori hetar rakaseseti onaꞌ ia! Neꞌo mana ratimba mia dꞌeaꞌ rema.” ");
INSERT INTO row_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Te Yesus olaꞌ no e nae, “Hokoꞌ! Au medꞌa koasa kalua mia Au e. Dadꞌi Au uhine atahori esa sangaja kois Au.” ");
INSERT INTO row_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Leleꞌ naa inaꞌ a nahine nae eni nda naꞌafuniꞌ nala sa, boe ma namatau seli. Ana nggeꞌe-nggeꞌe, de sendeꞌ lululanggan neu Yesus matan. De ana dui saa manadadꞌi neu e sia basa atahori hetar matan. Boe ma nafadꞌe nae, eni kois Yesus boe ma, eni hai neuꞌ ena. ");
INSERT INTO row_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Boe ma Yesus olaꞌ no e nae, “Feto ngge! Ho hai, huu mumuhere Au. Baliꞌ mo sodꞌa-moleꞌ ena!” ");
INSERT INTO row_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Leleꞌ Yesus feꞌe olaꞌ no inaꞌ naa, ma Yairus atahorin esa nema nafadꞌe nae, “Aduu, Amaꞌ, e! Amaꞌ anan nese ena! Ana mate ena, dadꞌi sudꞌi boe neꞌebꞌebꞌenggeꞌ Ama Meser fai.” ");
INSERT INTO row_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Te leleꞌ Yesus rena atahori naa dudꞌuin, boe ma Ana olaꞌ no Yairus nae, “Aꞌa! Subꞌa-subꞌaꞌ a! Afiꞌ dꞌuꞌa-dꞌuꞌa! Mumuhere neuꞌ a Lamatualain. Mana fee masodꞌaꞌ neu aꞌa anan.” ");
INSERT INTO row_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Leleꞌ ara losa Yairus umen, atahori sofe ume ena. Ara nggae ei-ei. Boe ma Yesus ai se nae, “Ama sudꞌi boe nggae fai! Anaꞌ ia nda mate sa. Ana sungguꞌ a!” Te atahori ra mali rapepenggo bafa nara neu E, huu sira rita no mata nara anaꞌ a etu hahaen. Basa ma Yesus noꞌe anaꞌ a ama-ina nara, Petrus, Yohanis, no Yakobis, rala reu ro E. Laen ra Ana denu rahani siaꞌ a dꞌeaꞌ. ");
INSERT INTO row_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ara rala reu, boe ma Yesus toꞌu anaꞌ a liman, de noꞌe nae, “Nona, e! Fela leo!” ");
INSERT INTO row_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Aibꞌoiꞌ ma, anaꞌ naa nasodꞌa baliꞌ, de fela neuꞌ ena. De Yesus denu ana fetoꞌ naa maman nae, “‘Fee anaꞌ ia naa leo!” ");
INSERT INTO row_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Anaꞌ a ina-ama nara heran rala seli. Te Yesus fee nesenedꞌaꞌ neu se, fo afiꞌ dui-bꞌengga dalaꞌ ia neu atahori ra. ");
INSERT INTO row_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Lao esa, Yesus naꞌabꞌue ana dedꞌenun atahori sanahulu rua. Boe ma Ana fee se koasa fo reu oi nitur ra, ma tao rahaiꞌ atahori mamahedꞌiꞌ mataꞌ-mataꞌ. ");
INSERT INTO row_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ana denu se, fo reu rafadꞌe atahori soꞌal Lamatualain toꞌu parendaꞌ. Ana o denu se fo reu tao rahaiꞌ atahori mamahedꞌiꞌ sia bee-bꞌee. ");
INSERT INTO row_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Te Ana nafadꞌe se nae, “Misinedꞌa malolole! Afiꞌ mendi saa-saa boe sia dalaꞌ. Mendiꞌ a badꞌu siaꞌ ao mara. Afiꞌ mendi teteas, do tas, do lepa-ngges, ma dꞌoiꞌ. Afiꞌ mendi badꞌu seluaoꞌ boe! ");
INSERT INTO row_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Mete ma hei misiꞌ kamboꞌ sa, ma hambu atahori nau simbo nggi, na, mii leo sia ume nara. Afiꞌ heheli ume. Leo mikindoo sia naa, losa hei lao hela kamboꞌ naa. ");
INSERT INTO row_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Mete ma misiꞌ kamboꞌ sa, ma atahori sia kamboꞌ naa, nda nau simbo ma nda rena nggi sa, na, soꞌu ei mara fo lao hela se leo. Mete ma hei lao hela mamanaꞌ naa, na, tao tungga hadꞌat fo hendaꞌ hendi afu mia ei mara. Mifadꞌe se mae, ‘Hei nda nau rena sa, na, hela neu fo hei lemba-misaa ao mara!’” ");
INSERT INTO row_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Basa ma, ana dedꞌenuꞌ ra lao mia kamboꞌ risi kamboꞌ. Ara reu rafadꞌe Lamatualain Hara-lii Malolen neu atahori ra. Ma ara tao rahaiꞌ atahori mamahedꞌiꞌ ra boe. ");
INSERT INTO row_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Leleꞌ naa, Mane Herodes Antipas rena dudꞌuit mataꞌ-mataꞌ soꞌal Yesus. Ana rena dudꞌuit naa ra, ma ana bingun, huu hambu atahori hira rafadꞌe rae, “Yesus naa, naeni Yohanis Mana Saraniꞌ a nasodꞌa baliꞌ ena.” ");
INSERT INTO row_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Hambu ruma fai rafadꞌe rae, “Eni ia, baꞌi Elia mana nasodꞌa baliꞌ ena.” Hambu ruma fai rae, “Eni ia, esa mia Lamatuaꞌ mana ola-olan laen ra eniꞌ a dalahulun.” ");
INSERT INTO row_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Te Herodes nasanedꞌa nae, “Faiꞌ naa, au mana denu tati etu Yohanis langgan. Ana nasodꞌa baliꞌ, do saa? Te ia, seka fai?” Boe ma ana sangga dalaꞌ fo nae nandaa mataꞌ no Yesus. ");
INSERT INTO row_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Lao esa, Yesus ana dedꞌenun fo ana dꞌenuꞌ ra, baliꞌ fo raꞌabꞌue ro E fai. Ara rafadꞌe neu E basa saa fo sira taoꞌ ra ena. Basa ma Yesus se laoꞌ nee-nee risiꞌ mamanaꞌ sa deka no kambo Betsaida, fo reu hahae ao nara sia naa. ");
INSERT INTO row_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Te atahori hetar rahine Yesus se rae reu sia bee, de ara tungga E. Dadꞌi Yesus simbo se no maloleꞌ, ma tao nahaiꞌ basa atahori mamahedꞌi ra, ma dui se soꞌal Lamatualain toꞌu parendaꞌ. ");
INSERT INTO row_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Bꞌobꞌon ma, Ana dedꞌenu kasanahulu ruaꞌ ra, roe mbali Yesus rae, “Malole lenaꞌ Amaꞌ denu atahori ia ra risiꞌ kamboꞌ mana deka-deka ia ra, fo sangga nanaat ao nara. Ma hela neu fo ara sangga mamana susungguꞌ. Huu mamana rouꞌ onaꞌ ia, taꞌo bee fo ara hambu raa?” ");
INSERT INTO row_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","14","Te Yesus nataa nae, “Taꞌo ia! Hela fo hei mana mihao se!” Te ara rareresi rae, “Aweꞌ, Amaꞌ dei! Nda bisa taꞌo naa sa ma? Atahori ia ra, rifon lima lenaꞌ! Naa feꞌe akaꞌ touꞌ ra, nda feꞌe reken inaꞌ ra ro ana ka ra sa! Ma hai roti ma akaꞌ bꞌueꞌ limaꞌ a, ma uꞌu boaꞌ ruaꞌ a. Mete ma Amaꞌ nau hai mihao atahori ia ra, na, taꞌo bee fo hai bisa hasa nanaat naeꞌ fee se?!” Boe ma Yesus denu se nae, “Dꞌenu atahori ia ra endoꞌ raꞌabꞌue reu mamanaꞌ sa na lima nulu-lima nuluꞌ.” ");
INSERT INTO row_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Boe ma reu ator se endoꞌ taꞌo naa. ");
INSERT INTO row_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Leleꞌ ara endoꞌ rala ma, Yesus haꞌi nala roti bꞌue ka limaꞌ ma uꞌu boaꞌ ka ruaꞌ naa ra. De Ana oroꞌa lalai ata neu, ma hule-oꞌe noꞌe makasi. Basa de Ana bibꞌibꞌi roti no uꞌu ra, de loo fee neu ana dedꞌenu nara fo reu babꞌanggi fee neu atahori naa ra. ");
INSERT INTO row_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Basa se raa losa raꞌabꞌeta. Basa de, ara radꞌuru rala nanaa lenaꞌ ra, sofe boa sanahulu rua. ");
INSERT INTO row_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Lao esa, Yesus mesaꞌ ne hule-oꞌe sia mamanaꞌ sa. Basa ma, ana dedꞌenu nara raꞌabꞌue ro E. Hule-oꞌe basa ma, Ana natane se nae, “Hei rena-renaꞌ atahori ola-olaꞌ rae, Au ia, seka? ");
INSERT INTO row_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ara rataa rae, “Ruma rae Amaꞌ ia, Yohanis Mana Saraniꞌ a. Laen ra rae, mbei ma Amaꞌ ia, baꞌi Elia. Hokoꞌ na, esa mia Lamatualain mana ola-olan maꞌahulun nasodꞌa baliꞌ ena.” ");
INSERT INTO row_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Boe ma Yesus natane se fai nae, “Mete ma tungga hei, na, hei mae Au ia, se?” Basa ma Petrus nataa nae, “Amaꞌ ia, Kristus, naeni Atahori fo Lamatualain dudꞌu memaꞌ eniꞌ a dalahulun!” ");
INSERT INTO row_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Basa ma Yesus naꞌangge se nae afiꞌ mifadꞌe neu see-see boe mae, Au ia, Kristus. ");
INSERT INTO row_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Basa ma, Yesus olaꞌ selu nae, “Au ia, Atahori Matetuꞌ a. Au musi lemba doidꞌoso beran mataꞌ-mataꞌ. Dei fo atahori Yahudi ra lasi-lasi adꞌat, ma malangga agama nara, ro meser agama ra nda nau simbo rae, Au ia, Kristus. Basa fo ara risa Au. Memaꞌ Au mate, te finiesan ma, Au usodꞌa baliꞌ!” ");
INSERT INTO row_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Basa ma, Ana nafadꞌe atahori hetar nae, “Atahori mana nae tungga Au, na, musi naꞌatataaꞌ tungga nakandoo fais-fais. Ana musi mboꞌi hendi hihii-nanaun. Musi tungga nakandooꞌ a, onaꞌ mae atahori ra rae tao risa e, onaꞌ atahori rasaa hau ngganggen fo neu nisiꞌ eni mamana mamates na. ");
INSERT INTO row_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Te atahori mana nahehere mate huu tungga Au, dei fo ana hambu masodꞌaꞌ nakandoo no Lamatuaꞌ. Te atahori fo nau nasodꞌa soaꞌ neu akaꞌ aon, dei fo ana saranggaa no Lamatualain. ");
INSERT INTO row_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Mete ma atahori sa hambu basa raefafoꞌ no isi oen, te Lamatualain nda simbo e sa, na, ana hambu onton saa? ");
INSERT INTO row_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Au ia, Atahori Matetuꞌ a. Dadꞌi atahori mana mae tungga Au, ma mae toꞌu nenori ngga, dei fo Au o mae utaa e sia Lamatualain matan leleꞌ Au baliꞌ mia sorga uma. Huu dei fo Au onda uma o Ama ngga koasa manaselin, o basa ate nara mia sorga ra. ");
INSERT INTO row_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Au ufadꞌe tebꞌe-tebꞌeꞌ neu nggi. Hambu hira mia hei mana sia ia ra, dei fo rita rala Lamatuaꞌ toꞌu parendaꞌ, fo ara feꞌe mate na.” ");
INSERT INTO row_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Basa fai kafalun, ma Yesus noꞌe no Petrus, Yohanis ma Yakobis reu sia leteꞌ esa fo hule-oꞌe. ");
INSERT INTO row_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Leleꞌ Yesus hule-oꞌe, boe ma mata-aon dadꞌi laen, ma bua-baꞌu nara dadꞌi muti makahahadꞌoꞌ. ");
INSERT INTO row_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Aibꞌoiꞌ ma, atahori rua rema boe. Ruꞌa se, naeni baꞌi Musa no baꞌi Elia. Boe ma ara ola-olaꞌ ro Yesus. ");
INSERT INTO row_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ara o randela-rasaꞌa. Teluꞌ se ola-olaꞌ soꞌal Yesus mamaten sia Yerusalem. ");
INSERT INTO row_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Leleꞌ naa, Petrus no nonoon karuaꞌ ra nduar kau-kau de ara sungguꞌ. Leleꞌ ara fela, boe ma rita Yesus nambariiꞌ no atahori rua. Ara o rita Yesus naronda manggareloꞌ boe. ");
INSERT INTO row_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Leleꞌ baꞌi Musa no baꞌi Elia rae lao, ma Petrus bingun, nda nitaꞌ nae tao saa sa boe. Boe ma ana olaꞌ leli nae, “Papa! Sia ia maloleꞌ, o! Dadꞌi malole lenaꞌ hai miririi lalaaꞌ telu. Esa fee neu Papa, esa fee neu baꞌi Musa, ma esa fai fee neu baꞌi Elia.” ");
INSERT INTO row_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Te leleꞌ ana feꞌe ola-olaꞌ taꞌo naa, ma lelee bubꞌueꞌ sa nema tatana nala se. Boe ma Petrus se ramatau. ");
INSERT INTO row_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Boe ma ara rena haraꞌ sa mia leleeꞌ naa nae, “Ia, Au Ana ngga fo Au pili memaꞌ a! Ana olaꞌ, na, rena malolole neu E!” ");
INSERT INTO row_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Olaꞌ basa ma, Petrus se rita akaꞌ Yesus mesaꞌ ne. Teluꞌ se nee-neeꞌ a ma nda dui neu esa sa boe, saa fo sira ritaꞌ naa. Doo-doo dei de ara feꞌe dui neu atahori laen. ");
INSERT INTO row_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Mbilaꞌ neu ma, Leleꞌ Yesus no Petrus se onda mia leteꞌ naa, atahori hetar rema randaa ro Yesus. ");
INSERT INTO row_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Boe ma atahori sa nameli mbali E nae, “Ama Meser, e! Tulun seꞌu ana mone ise ngga dei! ");
INSERT INTO row_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Te nitu akaꞌ toꞌu nala e, fo tao e nggasi aiboiꞌ-aiboiꞌ, ma mbembesiꞌ e losa fufureꞌ lua mia bꞌafan. Nitu naa o, akaꞌ momoko e, ma neu kakaur e nakandooꞌ a. ");
INSERT INTO row_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Au oꞌe tulun Amaꞌ ana dedꞌenun nara fo oi hendi nitu naa, te ara nda bole e sa!” ");
INSERT INTO row_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Rena taꞌo naa, ma Yesus bꞌua basa se nae, “Woi! Hei nda mimihere mae Lamatuaꞌ bisa tao nahaiꞌ nala atahori, sa do? Hei ia ra, memaꞌ atahori nda mana mihine misodꞌa tungga dꞌala ndoos sa! Au musi uꞌubꞌue o hei losa fai hiraꞌ fai, dei fo hei nau mimihere neu Au? Au musi uꞌutataaꞌ o hei losa faiꞌ bee fai!?” Basa ma Ana olaꞌ no amaꞌ naa nae, “Mo anam ia nema leo!” ");
INSERT INTO row_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Leleꞌ ara roo anaꞌ naa nisiꞌ Yesus, boe ma nitu a rupa anaꞌ naa neu rae a, ma mbembesiꞌ naꞌamiminaꞌ e. Te Yesus parenda nitu a fo lao hela anaꞌ naa, boe ma anaꞌ naa hai neuꞌ ena. Basa de Yesus fee anaꞌ naa neu aman. ");
INSERT INTO row_vpl VALUES ("LK9_43a","072_9_43a","LUK","9","43a","43a","Atahori mana rita Lamatuaꞌ koasa manaselin naa, basa se titindindii. ");
INSERT INTO row_vpl VALUES ("LK9_43b","072_9_43b","LUK","9","43b","43b","Leleꞌ basa atahori ra feꞌe ola-olaꞌ soꞌal manadꞌadꞌiꞌ fo Yesus taoꞌ ra, Ana nafadꞌe ana dedꞌenun nara nae, ");
INSERT INTO row_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Misinedꞌa malolole oꞌola ngga ia! Nda dooꞌ sa te, atahori rae seo hendi Au, Atahori Matetuꞌ ia. Ara fee Au isiꞌ atahori dꞌeaꞌ ra.” ");
INSERT INTO row_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Te ana dedꞌenun nara titindindiiꞌ a. Ara nda rahine dudꞌuꞌan sa. Ara o ramatau ratane naa sosoan saa. ");
INSERT INTO row_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Lao esa, Yesus ana dedꞌenun nara rareresi seka mia sira e dei fo mana dadꞌi malangga. ");
INSERT INTO row_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Te Yesus bubꞌuluꞌ saa fo rareresiꞌ a. Boe ma Ana noꞌe anadikiꞌ sa, de fee ne nambariiꞌ neu bobꞌoan. ");
INSERT INTO row_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Basa ma nafadꞌe se nae, “Rena malolole! Atahori mana tungga Au fo mete-seꞌu atahori anadikiꞌ onaꞌ anaꞌ ia, naa sosoan, eni mete-seꞌu Au. Ma eni o mete-seꞌu Ama Ngga sia sorga mana denu Au raefafoꞌ uma. Hambu atahori naeꞌ hiiꞌ a raloe-radꞌae se. Onaꞌ atahori mana tudꞌa-loloeꞌ, atahori manasusaꞌ, atahori nda papakeꞌ ra sa, atahori mana soeꞌ, ma atahori anak ra. Naa! Atahori mana hiiꞌ a mete-seꞌu atahori mataꞌ naa ra, Lamatualain duꞌa nae sira manaseliꞌ ra.” ");
INSERT INTO row_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Basa ma Yohanis nafadꞌe Yesus nae, “Papa! Lao esa, hai mita atahori sa oi nitur nendiꞌ Papa naran. Dadꞌi hai ꞌai fo afiꞌ ingga-inggaꞌ Papa naran, huu eni nda hita atahorin sa.” ");
INSERT INTO row_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Te Yesus nataa nae, “Afiꞌ! Huu atahori nda mana labꞌan hita sa, eni hita nonoon.” ");
INSERT INTO row_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesus bubꞌuluꞌ nae, Eni fai hehene sorga neu deka-deka ena. Boe ma Ana naꞌetuꞌ fo lao kota Yerusalem neu. ");
INSERT INTO row_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ana denu atahori lao raꞌahuluꞌ se, naa fo ara ralalau hela nanaa-nininuꞌ. Boe ma ara risiꞌ kamboꞌ sa sia propensi Samaria de rae ralalau mamana leleoꞌ. ");
INSERT INTO row_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Te atahori Samaria naa ra nda nau simbo Yesus se sa, huu Ana nae lao neu hule-oꞌe neu Lamatualain sia kota Yerusalem. ");
INSERT INTO row_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Leleꞌ Yakobis no Yohanis rena atahori Samaria ra tatao nara, ma ara kokoe Yesus rae, “Papa! Taꞌo bee, ata toꞌe Lamatualain naꞌondaꞌ ai mia lalai nema naa hendi basa se?” ");
INSERT INTO row_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Te Yesus mete mbali ruꞌa se, ma ai nae, “Sudꞌi boe duꞌa taꞌo naa fai.” ");
INSERT INTO row_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Basa ma ara lao rakandoo risiꞌ kamboꞌ laen. ");
INSERT INTO row_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Leleꞌ ara feꞌe lao-laoꞌ, hambu atahori sa olaꞌ no Yesus nae, “Amaꞌ! Amaꞌ neu sia bee o, au nau tungga ukundoo o Amaꞌ!” ");
INSERT INTO row_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Te Yesus nataa nae, “Malole, boe! Te musunedꞌa taꞌo ia. Basa atahori ro banda ra esaꞌ no mamana luꞌu-leleon. Busa fui baliꞌ nisiꞌ ndolan. Mbuiꞌ bꞌaliꞌ nisiꞌ ndunan. Te Au, Atahori Matetuꞌ ia, nda maumeꞌ fo baliꞌ uu sa. Mamanaꞌ fo ndae langgaꞌ o, nese boe.” ");
INSERT INTO row_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Lao esa, Yesus noꞌe atahori laen sa nae, “Uma tungga Au, fo dadꞌi atahori ngga.” Atahori naa nataa nae, “Neu! Te taꞌo ia, Lamatuaꞌ. Hela fo au baliꞌ mete-seꞌu ala ina-ama nggara dei. Mete ma ama ngga mate ena, dei fo au feꞌe tungga na.” ");
INSERT INTO row_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Te Yesus nafadꞌe neu e nae, “Taꞌo ia! Hela fo atahori nda mana ramahere neu Lamatuaꞌ sa, ralalau sira atahori mates nara. Te hei mana mimihere neu Lamatuaꞌ, hei ue-tataos mara mii mifadꞌe soꞌal Lamatualain toꞌu parendaꞌ.” ");
INSERT INTO row_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Hambu atahori sa fai nae, “Malole boe, Lamatuaꞌ! Au ae tungga Lamatuaꞌ ukundoo. Te fee kakaꞌeꞌ fo uu idꞌu ala bobꞌonggi nggara, dei fo au baliꞌ uma tungga Lamatuaꞌ.” ");
INSERT INTO row_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Te Yesus nafadꞌe neu e nae, “Taꞌo ia! Mete ma atahori tatati rala osi nara, basa ma ara mbute-mue roꞌ a ue-tatao laen ra losa ara liliiꞌ sela, na, osi naa nda dadꞌi sa. Onaꞌ naa boe atahori mana naꞌetuꞌ nae tungga Au, te akaꞌ nasanedꞌa masodꞌa maꞌahulun. Atahori mataꞌ naa nda naꞌena ngguna dadꞌi atahori mana ue-tao sia Lamatualain parendan sa. ");
INSERT INTO row_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Basa ma, Yesus pili nala ana dedꞌenun laen atahori hitu nulu rua. Basa de Ana bꞌanggi se atahori rua-ruaꞌ, fo reu raꞌahuluꞌ E sia mamana-mamanaꞌ fo nae neuꞌ a. ");
INSERT INTO row_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ana denu se nae, “Hambu atahori hetar onaꞌ are mbule manahuniꞌ ena. Helaꞌ a tenu osiꞌ a haitua atahori mana tao ues nara rema etu-oru. Dadꞌi hei musi hule-oꞌe moꞌe Lamatualain haitua seluꞌ mana tao ues nara fo raꞌabꞌue rala atahori mana nae tungga Au ra. Huu, atahori mana nae tungga Au ra, hetar. Te atahori mana tao ues ra hidꞌaꞌ a. ");
INSERT INTO row_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ia naa ama laoꞌ leo! Au denu nggi mii sia atahori hetar. Te misinedꞌa taꞌo ia. Hei onaꞌ bibꞌi lombo ana rala maloleꞌ, mana neu sia busa fui deꞌulakaꞌ ra taladꞌan. ");
INSERT INTO row_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ama afiꞌ mendi dꞌoiꞌ, do tas bꞌua-baꞌus, do laopei lenaꞌ sia dalaꞌ. Afi ngganggari fai parsumaꞌ a, huu akaꞌ mitea atahori sia dalaꞌ. ");
INSERT INTO row_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","8","Mete ma hei misiꞌ kamboꞌ sa, afiꞌ lali-laliꞌ mia ume sa misiꞌ ume laen. Mete ma atahori simbo hei no maloleꞌ sia ume sa, na, mihani sia naa leo, losa hei lao hela kamboꞌ naa. Mete ma hei misiꞌ ume sa, hei musi moꞌe fo Lamatualain fee papala-babꞌanggiꞌ neu atahori sia ume naa. Mete ma tenu umeꞌ a simbo nggi no malolole, dei fo Lamatuaꞌ natudꞌu rala malolen neu ume isiꞌ naa ra. Te mete ma ara nda nau simbo nggi sa, na, hela neu fo Lamatuaꞌ natudꞌu rala malolen neu akaꞌ mesaꞌ nggi. Mete ma hei misiꞌ ume sa, do, kamboꞌ sa, na, mia-minu sudꞌiꞌ a saa fo ara feeꞌ ra. Simbo no rala nemehoꞌot, te nandaa ara fee nggi taꞌo naa fo nggati mbusa-titi mara. ");
INSERT INTO row_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Tao mihaiꞌ sira atahori mamahedꞌiꞌ nara. Boe ma mifadꞌe se mae, ‘Lamatualain toꞌu parendan deka ena!’ ");
INSERT INTO row_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Te dei fo hambu kamboꞌ ruma atahori nara nda nau simbo nggi sa. Mete ma ara tao taꞌo naa mbali nggi, na, mii mimbiriiꞌ sia kamboꞌ a dꞌalan fo olaꞌ mae, ");
INSERT INTO row_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Rena malolole! Hai ima mendi Lamatuaꞌ Hara-liin neu nggi, te hei nda nau mbei-mbei sa boe. Dadꞌi ia naa hai hendaꞌ hendi kamboꞌ ia afun sia hai ei mara, fo dadꞌi bukti oi, dei fo hei lemba-misaa ao mara! Te misinedꞌa malolole! Lamatualain toꞌu parendan deka ena!’ ");
INSERT INTO row_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Hei bubꞌuluꞌ kota Sodꞌom deꞌulakan, to? Au ufadꞌe, e! Dei fo nandaa no fai neteteꞌen, Lamatuaꞌ fee huhuku-dꞌodꞌokiꞌ neu atahori nda mana simbo heiꞌ ra sa, beran lenaꞌ atahori Sodꞌom ra!” ");
INSERT INTO row_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yesus olaꞌ seluꞌ fai nae, “Hei mana sia kambo Korasin ma kambo Betsaida ra, ama besa-bꞌesa! Sosoeꞌ dai nggi ena! Au tao manadadꞌiꞌ mataꞌ-mataꞌ sia mata mara ena, te hei nda nau mimihere Lamatuaꞌ sa. Tao-tao te, hei ia ra, atahori Yahudi mana mitaa mae hei mihine E. Te onaꞌ manadadꞌiꞌ fo Au tao sia hei kambom dadꞌi sia kota Tirus no Sidꞌon, neꞌo doo basa ia de atahori sia naa ra dꞌoaꞌ memaꞌ ena, ma lao hela basa sala-kilu nara fo tungga Lamatuaꞌ ena. Neꞌo ara pake bua-baꞌu sususaꞌ, ma mbori afu neu langga nara fo dadꞌi bukti rae, sira fale ralan nara mia sala-kilu nara. Tao-tao te atahori Tirus ro Sidꞌon ia ra, nda atahori Yahudi mana rataa rae sira rahine Lamatuaꞌ. ");
INSERT INTO row_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Tebꞌe! Hei mete neuꞌ ena! Mete ma Lamatuaꞌ naꞌetuꞌ basa atahori dedꞌea nara, atahori Tirus ro Sidꞌon ra huhuku-dꞌodꞌoki nara feꞌe nggafat lenaꞌ hei huhuku-dodꞌoki mara. ");
INSERT INTO row_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Besa-bꞌesa hei atahori kambo Kapernaum! Ama afiꞌ duꞌa mae, dei fo Lamatuaꞌ soꞌu bꞌotiꞌ nggi sorga mii. Hokoꞌ! Dei fo Lamatuaꞌ mbia nggi naraka rala mii! ");
INSERT INTO row_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Misinedꞌa malolole! Atahori mana rena hei, onaꞌ ara rena neu Au boe. Ma atahori nda mana nau rena hei sa, onaꞌ ara nda nau rena Au sa boe. Lenaꞌ fai, atahori nda mana nau rena Au sa, onaꞌ ara nda nau rena Lamatualain sa, mana denu Au raefafoꞌ uma.” ");
INSERT INTO row_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Leleꞌ dedꞌenu kahitu nulu rua ra baliꞌ rema, rala nara ramahoꞌo. Boe ma rafadꞌe neu Yesus rae, “Awii! Manaseliꞌ tebꞌe! Leleꞌ hai oi nitu ra mendiꞌ Amaꞌ naran, nitu ra rena hai boe, de rela neuꞌ ena! Manaseliꞌ tebꞌe!” ");
INSERT INTO row_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Boe ma Yesus nataa se nae, “Tebꞌe! Leleꞌ hei tao taꞌo naa, Au ita Lamatualain mbia hendi nitu ra no malanggan mia lalai, onaꞌ ndelas nakahahadꞌoꞌ dii-onaꞌ mia lalai! ");
INSERT INTO row_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Misinedꞌa, e! Nitur malanggan naa, hita musun. Eni o ma koasa boe! Te Au o fee nggi koasa fo misenggiꞌ koasan. Mete ma hei tabꞌu mala mengge marasoꞌ, do uraꞌ, na, hei nda taꞌo bee sa boe. Nda hambu saa bisa tao nasoeꞌ nggi sa. ");
INSERT INTO row_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Hei rala mara maꞌahee, huu nitu ra rena nggi. Malole boe, te naa feꞌe dꞌala anadikiꞌ! Malole lenaꞌ rala mara maꞌahee, huu Lamatuaꞌ suraꞌ nala nara mara fo dadꞌi rauinggun mana masoꞌ sorga.” ");
INSERT INTO row_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Leleꞌ naa, Lamatuaꞌ Dula-dale Meumaren tao Yesus ralan namahoꞌo. De Ana koa-kio Lamatualain nae, “Amaꞌ! Amaꞌ mana dadꞌi Malangga Monaeꞌ sia lalai no raefafoꞌ. Au oꞌe makasi nae-nae, huu Amaꞌ babꞌata mala basa dalaꞌ ra mia atahori mana tao aon onaꞌ mahineꞌ ma mana koaoꞌ ra. Te Amaꞌ mutudꞌu basa dalaꞌ ia ra neu anadiki ra ma neu atahori mana maloe-madꞌae ralaꞌ ra. Tebꞌe, Amaꞌ! Huu naa mana tao Amaꞌ ralan namahoꞌo!” ");
INSERT INTO row_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Basa ma Yesus nafadꞌe atahori hetar nae, “Rena o! Ama ngga sia sorga fee basa koasa neu Au ena. Mana nahine tebꞌe nae, Au ia, seka, naeni akaꞌ Amaꞌ. Ma mana nahine tebꞌe nae, Amaꞌ naa, seka, akaꞌ Amaꞌ Anan, naeni Au. Ma atahori laen fo Au pili ala ae ufadꞌe se, fo ara o rahine E boe.” ");
INSERT INTO row_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Basa de Yesus heoꞌ mbali ana dedꞌenun nara, de nafadꞌe neuꞌ a mesaꞌ se nae, “Hei onton tebꞌe, huu mita Lamatuaꞌ koasan ena. ");
INSERT INTO row_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Mane-maneꞌ ro mana ola-ola maꞌahuluꞌ ra rae rita saa fo hei mitaꞌ a ena, te ara nda bisa rita sa. Ara o hii rae rena saa fo hei hambu renaꞌ a, te ara nda hambu rena sa.” ");
INSERT INTO row_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Lao esa, hambu atahori Yahudi mahine hukun esa, nambariiꞌ nae naꞌatutudꞌaꞌ Yesus. Ana natane nae, “Ama Meser! Tulun mufadꞌe dei! Au musi tao saa, fo ona bee naa au uhine hambu usodꞌa ukundoo o Lamatuaꞌ sia sorga?” ");
INSERT INTO row_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesus nataa nae, “Baꞌi Musa suraꞌ saa soꞌal dalaꞌ ia ra? Tungga dudꞌuꞌam na taꞌo bee?” ");
INSERT INTO row_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Atahori naa nataa nae, “Ana suraꞌ nae: ‘Ho musi sue Lamatualain, ho Lamatua ma, lena basaꞌ e. Huu naa, ho ralam musi hii mukundoo E, manggate fo tungga hihii-nanaun, ma muhine E.’ Ma nenesuraꞌ oi, ‘Ho musi sue toronoom onaꞌ ho sue aom boe.’” ");
INSERT INTO row_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesus nataa nae, “Tebꞌe! Mete ma ho tao tungga tao naa, na, musodꞌa mo Lamatuaꞌ mukundondoꞌ a.” ");
INSERT INTO row_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Te atahori naa nae tao aon onaꞌ atahori maloleꞌ. Boe ma natane Yesus nae, “Te, au ‘toronoo’ nggara, seka ra?” ");
INSERT INTO row_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Boe ma Yesus nataa nae, “Taꞌo ia! Au ae ufadꞌe nekendandaaꞌ esa. Dei fo mufadꞌe, bee ka tebꞌe-tebꞌeꞌ ‘toronooꞌ’. Dꞌudꞌuin taꞌo ia: Hambu atahori Yahudi esa mia kota Yerusalem, onda nisiꞌ Yeriko neu. Te aibꞌoiꞌ ma, hambu mana rambok ra rema rambok e. Ara momoko e, basa ma rambas rala dꞌoiꞌ ma basa bꞌua-baꞌu nara. Boe ma ara nggari hendi e nisiꞌ dalaꞌ suun, de lao hela e neu naa. Atahori naa naeꞌ a mate ena. ");
INSERT INTO row_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Te dodꞌoo ma, malangga agama Yahudi sa laoꞌ tungga naa boe. Te leleꞌ ana nita atahori maꞌahinaꞌ mana lengga-lengga sia dalaꞌ suun, ana nda nambariiꞌ fo tulu-fali atahori naa sa, te ana dꞌinggoꞌ nisiꞌ dalaꞌ suun seri de lao nakandoo. ");
INSERT INTO row_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nda dooꞌ sa ma, atahori laen sa nema tungga naa fai. Eni, atahori mia leo Lewi mana ue-tao sia Lamatualain Ume Hule-oꞌe Huu na. Leleꞌ ana nita atahori na sia dalaꞌ suun, ana neu deka-deka de meteꞌ a, te nda tulu-fali e sa, ma dinggoꞌ nisiꞌ dalaꞌ suun seri de lao nakandoo. ");
INSERT INTO row_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","34","Nda dooꞌ sa fai ma, atahori sa mia kambo Samaria tungga naa no banda keledei nara. Basa nggita bubꞌuluꞌ tae, atahori Yahudi ra raloe-radꞌae atahori Samaria ra. Te, leleꞌ atahori Samaria a nita atahori mana neneramboꞌ naa, ma ana kasian e. Ana neu deka-deka fo nae tulu-fali atahori naa. Ana ombo oe anggor de safe nameu hinaꞌ ra, ma tao mina neu se. Basa ma ana mbalu malolole e, de oꞌo e keledei ata neu. Boe ma no atahori naa losa kota. Ana fee atahori naa leo sia ume sesebꞌaꞌ, ma mete-seꞌu e no maloleꞌ. ");
INSERT INTO row_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Mbilaꞌ neu ma, atahori Samaria naa neu fee naꞌahuluꞌ doi fulaꞌ rua neu tenu umeꞌ a, de nafadꞌe nae, ‘Mala dꞌoiꞌ ia fo mete-seꞌu neu atahori mamahedꞌiꞌ a losa ana hai. Mete ma nda dai sa, na, tulun mete-seꞌu mendiꞌ doi ma fo au uma fai, fo fee baliꞌ amaꞌ dꞌoin.’” ");
INSERT INTO row_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesus nekendandan losaꞌ a naa ena. Basa ma Ana natane mana mahine hukun a nae, “Tungga dudꞌuꞌam na, bee ka tebꞌe-tebeꞌ ‘toronooꞌ,’ soaꞌ neu atahori neneramboꞌ faaꞌ ra?” ");
INSERT INTO row_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Atahori naa nataa nae, “Se fai, neꞌo atahori mana tudꞌa kasian neu e,” Yesus nae, “Tebꞌe, aꞌa! Baliꞌ leo, fo tao tungga,” ");
INSERT INTO row_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","40","Basa ma, Yesus no ana dedꞌenun nara lao rakandoo risiꞌ Yerusalem. Ara tuli mia kamboꞌ sa. Sia naa hambu toronoo odꞌi-aꞌaꞌ rua, nara nara Marta ma Maria. Marta noꞌe fo Yesus se leo sia eni umen. De ara leo raꞌatataaꞌ sia naa. Leleꞌ Yesus endoꞌ nanori atahori ra, Marta mbute-mue no nanaa-nininuꞌ sia dapu rala. Te odꞌin Maria, endoꞌ deka-deka sia Yesus ein, fo rena oꞌolan. Nda dooꞌ sa, ma ‘Marta rala neu de oꞌolaꞌ neu Yesus nae, “Amaꞌ, e! Taꞌo bee, o! Au mbute-mue ulalau nanaa-nininuꞌ itaꞌ mamate ngga, te odꞌi ngga endoꞌ teꞌe-teꞌe sia ia. Tulun dei! Denu e tulun au mbei sia dapu rala.” ");
INSERT INTO row_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Te Lamatuaꞌ Yesus nataa nae, “Marta, Marta. Ho ia, mbute-mue moꞌa dudꞌuꞌa-afiꞌ mataꞌ-mataꞌ. ");
INSERT INTO row_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Malole boe, te leleꞌ ia hambu dalaꞌ nggunan naeꞌ lenaꞌ. Maria endoꞌ rena Au Dedꞌea oꞌola ngga, na, ana pili nala maloleꞌ a ena. Huu atahori nda bisa haꞌi rala Dedꞌea-oꞌola ngga ia mia e sa.” ");
INSERT INTO row_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Lao esa, Yesus neu hule-oꞌe. Ana hule-oꞌe basa ma, ana dedenun esa nema noꞌe mbali E nae, “Papa! Yohanis mana saraniꞌ a nanori ana dedꞌenu nara ena, fo hule-oꞌe rahine. Hai o moꞌe fo Papa munori hai dei!” ");
INSERT INTO row_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ma Yesus nae, “Malole boe! Hule-oꞌe taꞌo ia: ‘Ama! Amaꞌ naran meumareꞌ seli. Hela fo atahori soꞌu rananaru Amaꞌ naram manaseliꞌ naa. Hela fo Amaꞌ, dadꞌi Maneꞌ neu basa atahori. ");
INSERT INTO row_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Amaꞌ pala-banggi fee hai nanaat manadꞌaiꞌ tungga-tungga fai. ");
INSERT INTO row_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Hai moꞌe fo Amaꞌ liliiꞌ hendi hai sala-kilu mara, onaꞌ hai o liliiꞌ atahori sala-kilun fo ara tao neu hai. Amaꞌ munea hai fo hai afiꞌ tao deꞌulakaꞌ.” ");
INSERT INTO row_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Basa de Yesus nanori seluꞌ se soꞌal dꞌala hule-oꞌeꞌ. Ana fee nekendandaaꞌ nae, “Onaꞌ neofa ma hambu nonoom esa mia dodꞌooꞌ nema nae numban sia ume ma. Te nda muꞌena saa fo fee ne naa sa boe. Boe ma, muu sia nonoom laen umen, fo akaꞌ moꞌe mia dꞌeaꞌ mae, ‘Aꞌa, e! Fee au roti bꞌueꞌ telu dei! Huu au hambu fuiꞌ sia ume, te au nda uꞌena saa sa boe! Aꞌa, tulun dei! Bꞌue teluꞌ a!! Dei fo au nggati!” ");
INSERT INTO row_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Neꞌo nonoom nataa nggo nae, ‘Te aꞌa fai, o! Atahori mana sungguꞌ masambetaꞌ ra o, aꞌa nema ngganggu fai! Lelesu ra mana nggoe nisaꞌ ena, ia! Ana kara mana sungguꞌ masambetaꞌ ena. Afiꞌ mumunasa, e! Te faiꞌ ruma dei, aꞌa!’ ");
INSERT INTO row_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mae onaꞌ naa o, musunedꞌa malolole. Itaꞌ mae atahori naa nda fela fo fee nggo sa o, huu ho eni nonoon, de mete ma akaꞌ moꞌe mukundondoꞌ a na, dei fo ana fela fo fee nggo. ");
INSERT INTO row_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Onaꞌ naa boe, no hule-oꞌeꞌ a. Moꞌe mukundondoꞌ a neu Lamatuaꞌ; dei fo Ana fee. Sangga mukundooꞌ a; dei fo Ana natudꞌu dalaꞌ. Mumeli mukundooꞌ a; dei fo Ana soi lelesu a. ");
INSERT INTO row_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Huu basa atahori mana roꞌe rakandooꞌ a neu Lamatualain, dei fo ara simbo. Mana sangga nakandooꞌ ra, dei fo ara hambu. Mana nameli nakandooꞌ ra, dei fo Ana soi lelesu a. ");
INSERT INTO row_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Hei duꞌa sobꞌa! Hambu sia bee, amaꞌ sa, mete ma anan noꞌe uꞌu, na, ana fee ne mengge? ");
INSERT INTO row_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Do, mete ma anan noꞌe manuteloꞌ, na, ana fee uraꞌ? Nda bisa taꞌo naa sa, to? ");
INSERT INTO row_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Atahori memaꞌ deꞌulakaꞌ. Te hei Amam sia sorga, Netehun maloleꞌ tebꞌe. Dadꞌi mete ma atahori deꞌulakaꞌ onaꞌ hei, te hii fee sudꞌiꞌ saa maloleꞌ neu ana mara, saa fai Amaꞌ! Ana nda feeꞌ a saa fo hei parluꞌ a, te lenaꞌ naa fai, Ana fee Dula-dꞌale Meumaren neu atahori mana noꞌe mbali E.” ");
INSERT INTO row_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Lao esa, Yesus oi nitur mia atahori esa nda mana bꞌale nalaꞌ sa. Oi basa ma, atahori naa olaꞌ nalaꞌ neuꞌ ena. Atahori mana sia naa ra heran bali-baliꞌ. ");
INSERT INTO row_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Te hambu ruma rae, “Memaꞌ, Ana bisa oi nitur! Huu Ana hambu koasa mia nitu ra malanggan, naeni Balsebul.” ");
INSERT INTO row_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Atahori laen ra rae sobꞌa Yesus. De ara roꞌe fo Ana tao seluꞌ manadadꞌiꞌ esa fai fo natudꞌu neu sira oi, Eni koasan memaꞌ mia Lamatuaꞌ. ");
INSERT INTO row_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Te Yesus nahine dudꞌuꞌa deꞌulaka nara ena. Boe ma Ana olaꞌ nae, “Mete ma sia nusa monaeꞌ sa, rauinggu nara ratofa, neꞌo nusa monaeꞌ naa nambalutu. Onaꞌ naa boe, mete ma sia ume sa rala, ume isi nara akaꞌ rareresi esa no esa, na, neꞌo ume-loo naa nda dadꞌi maloleꞌ sa ena! ");
INSERT INTO row_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Dadꞌi mete ma nitu ra akaꞌ ratofa, ma esa oi esa, na, sira malanggan nda hambu toꞌu parendaꞌ dooꞌ sa ena! De nda masoꞌ dudꞌuꞌat sa, mete ma hei mae Au oi nitur endiꞌ nitur koasan! ");
INSERT INTO row_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Misinedꞌa, e! Hei atahori mara o oi rahine nitu ra boe. Ara oi rendiꞌ nitur koasan do? Hokoꞌ, to! Dadꞌi ama afiꞌ olaꞌ leliꞌ mae, Au oi nitu ra endiꞌ nitur koasan. Dei fo atahori mara raꞌetuꞌ rae, saa fo hei mifadꞌeꞌ naa, sala. ");
INSERT INTO row_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Te mete ma Au oi nitu ra endiꞌ Lamatualain koasan, naa natudꞌu oi, Lamatuaꞌ parendan sia hei mata mara ena. Sia, te hei onaꞌ nda bubꞌuluꞌ sa. ");
INSERT INTO row_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Mete ma atahori maꞌadꞌereꞌ sa toꞌu sisiro dii-onaꞌ, fo nanea malolole umen, neꞌo eni sudꞌiꞌ a saa nara nda mopo sa. ");
INSERT INTO row_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Te dei fo hambu atahori maꞌadꞌereꞌ lenaꞌ e fai, nema tao nasenggiꞌ e, ma rambas nala atahori naa sisiro nara. Basa ma, ana amba-ao nendi basa atahori naa hata-heto nara de neu babꞌanggi fee ana dedenun nara. Dꞌoo basa ia ena atahori maꞌadꞌereꞌ kaesan namahere sisiron. Te ia naa ana nda namahena sisiron sa ena. ");
INSERT INTO row_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Misinedꞌa malolole! Atahori nda mana naꞌabꞌue no Au sa, eni, labꞌan Au. Boe ma atahori nda mana tulun Au sia ue-tataos nggara sa, na, atahori naa kai-baaꞌ a.” ");
INSERT INTO row_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yesus olaꞌ seluꞌ nae, “Mete ma hita oi hendi nitu mia atahori sa, ana nisiꞌ mamana rouꞌ fo sangga mamana hahaeꞌ. Huu ana nda hambu mamanaꞌ sa, boe ma ana duꞌa nae, ‘Hee! Nda hambu mamanaꞌ sa, de malole lenaꞌ au heoꞌ baliꞌ isiꞌ atahori dalahulun.’ ");
INSERT INTO row_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Basa ma ana baliꞌ, te neu hambu mamanaꞌ naa, meuꞌ ma nene mbeda-nggao maloleꞌ ena. ");
INSERT INTO row_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Boe ma nitu a neu noꞌe nonoon hitu fai, deꞌulaka nara lena e fai, de basa se reu leo sia atahori naa. De aleꞌ ia atahori naa masodꞌan boe hambu sosoeꞌ.” ");
INSERT INTO row_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Leleꞌ Yesus feꞌe ola-olaꞌ no atahori naeꞌ naa ra, hambu inaꞌ sa nameli sia naa nae, “Mama ma uanalen maloleꞌ, huu ana mana bꞌonggi ma nasusu Nggo!” ");
INSERT INTO row_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yesus nataa nae, “Tebꞌe, mama! Te mana hambu uanale maloleꞌ lenaꞌ, naeni atahori mana pasa ndikin fo rena Lamatualain Dedꞌea-oꞌolan, ma tao tungga!” ");
INSERT INTO row_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Leleꞌ Yesus feꞌe ola-olaꞌ, atahori hetar heo rala E. Boe ma Ana olaꞌ nae, “Atahori aleꞌ ia ra rahine taoꞌ a deꞌulakaꞌ ra. Ara akaꞌ roꞌe fo Au tao manadadꞌi manaseliꞌ fee se, fo rahine Au ia, tebꞌe-tebꞌeꞌ Lamatuaꞌ atahorin. Tao-tao te feꞌesaꞌan Lamatuaꞌ tao manadadꞌi manaseliꞌ fee se nendiꞌ mana ola-olan Yunus. Naa dai ena! ");
INSERT INTO row_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Maꞌahulun, Yunus nafadꞌe atahori kota Niniwe nae, ara musi dꞌoaꞌ dei. Naa, saa mana dadꞌi neu Yunus leleꞌ naa, dadꞌi bukti fee neu se oi, Lamatualain mana denu e. Au, Atahori Matetuꞌ ia, o taꞌo naa boe. Au uma ufadꞌe nggi, fo ama musi dꞌoaꞌ dei. Ma saa mana nae dadꞌi sia Au, dadꞌi bukti fee atahori oras ia oi, memaꞌ Lamatualain mana denu Au. ");
INSERT INTO row_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Dei fo sia fai mateteꞌen, mete ma Lamatuaꞌ dadꞌi mana Maꞌetuꞌ dedꞌeat, dei fo ina maneꞌ mana nema mia ona nema, nasodꞌa baliꞌ, fo nambariiꞌ dadꞌi sakasii. Ana dudꞌu fo fua salaꞌ neu basa hei mana masodꞌaꞌ oras ia nae, ‘Basa hei ia ra, nggoaꞌ!’ Feꞌesaꞌan ina maneꞌ naa nema mia dodꞌooꞌ fo nita no matan mane Soleman mahinen. Tao-tao te, ia naa hambu Atahori sia taladꞌam mara, manaseliꞌ lenaꞌ mane Soleman. Te hei nda nau tao-afiꞌ mbei neu E sa boe. ");
INSERT INTO row_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nda akaꞌ mesaꞌ ne sa! Dei fo atahori mia Niniwe ra o fela rambariiꞌ fo dudꞌu hei mana feꞌe masodꞌaꞌ oras ia rae, ‘Basa hei, nggoaꞌ ra!’ Ara olaꞌ taꞌo naa, huu faiꞌ naa, leleꞌ Yunus neu nafadꞌe Lamatuaꞌ hihii-nanaun, ma ara dꞌoaꞌ reuꞌ ena. Tao-tao te, oras ia Atahori manaseliꞌ lenaꞌ Yunus, sia hei taladꞌam, te hei nda dꞌoaꞌ sa boe!” ");
INSERT INTO row_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yesus tute seluꞌ oꞌolan nae, “Atahori rambilaꞌ lambu tiioek, boe ma mbedꞌaꞌ e sia mamana naruꞌ ata, fo ana tao manggarelo kama naa fee neu basa atahori mana rala reu. Nda hambu atahori rambilaꞌ lambu, basa ma tatana e rendiꞌ bꞌoa, fo funi e. Naa nda naꞌena nggunaꞌ saa sa boe. ");
INSERT INTO row_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Hei mata mara o onaꞌ lambu boe. Ana tao manggarelo hei rala mara. Mete ma mataꞌ a maꞌahatuꞌ, na atahori mete basaꞌ e no rala deꞌulakaꞌ. Te mete ma mataꞌ a manggareloꞌ, na atahori mete basaꞌ e no rala maloleꞌ. ");
INSERT INTO row_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Tao malolole fo manggareloꞌ mana sia rala mara, dadꞌi manggareloꞌ seli, onaꞌ relo a rondan. Rondaꞌ mana sia ralam naa, afiꞌ onaꞌ fulan rondan, fo titaꞌ a salaoꞌ. ");
INSERT INTO row_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mete ma rala mara manggareloꞌ, losa nda hambu sosodꞌaꞌ esa maꞌahatuꞌ sa boe, na basa masodꞌa mara manggareloꞌ, onaꞌ lambu monaeꞌ fee manggareloꞌ neu masodꞌa mara”. ");
INSERT INTO row_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesus olaꞌ basa ma, atahori esa mia partei agama Farisi ra noꞌe E fo nema naa sia umen. Losa naa ma, Yesus ume rala neu de neu endoꞌ sia mei nanaaꞌ a. ");
INSERT INTO row_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Tenu umeꞌ a ndindiꞌ a mete Yesus endoꞌ naa, te nda safe liman naꞌahuluꞌ tungga atahori Farisi ra hohoro-lalanen sa. ");
INSERT INTO row_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Basa ma Yesus nafadꞌe e nae, “Hei atahori Farisi ra manaseliꞌ! Hei toꞌu mihereꞌ hei agamam hohoro-lalanen! Hei misinedꞌa safe mimeuꞌ a pinggaꞌ ma nggalas ra dean na losa nakahahadꞌok, te nda misinedꞌa tao mimeu rala manggenggeo mara, mana deꞌulakaꞌ ma bare-naꞌo seli. ");
INSERT INTO row_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Manggonggoaꞌ, e! Afiꞌ liliiꞌ. Lamatualain mana tao deaꞌ ma ralaꞌ boe. ");
INSERT INTO row_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Te malole lenaꞌ, hei fee atahori mana toꞌa-taaꞌ ra mia saa fo hei enam, naa fo hei bisa meumareꞌ sia Lamatuaꞌ matan. ");
INSERT INTO row_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Hei atahori Farisi ra! Dei fo hei hambu sosoeꞌ! Soꞌal fee Lamatuaꞌ babꞌanggi esa mia babꞌanggiꞌ sanahulu, hei reken no matetuꞌ basaꞌ e, anak-moko. Losa hei bꞌumbu huu anaꞌ mia osi o, hei reken mates! Te hei nda taoafiꞌ neu saa fo nggunan seli sa. Soꞌal susueꞌ neu Lamatualain, ma dala ndoo-tetuꞌ a, hei liliiꞌ hendi se neuꞌ ena! Memaꞌ hita musi fee takandoo neu Lamatuaꞌ, Eni hahambun, te afiꞌ liliiꞌ hendi dala-dalaꞌ fo nggunan lenaꞌ ra. ");
INSERT INTO row_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Dei fo hei hambu sosoeꞌ! Huu hei hiiꞌ a sangga mamana meulauꞌ sia ume hule-oꞌeꞌ, ma hiiꞌ a sangga hadꞌa-hormat sia atahori hetar matan. ");
INSERT INTO row_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Dei fo hei hambu sosoeꞌ! Hei onaꞌ rates, rae na tetuꞌ ena. Atahori laoꞌ sia naa, te nda rahine rae, sia naa hambu rates sa, huu sia rates ata rae a meuꞌ, te sia ralan maꞌafo mburu. Tao-tao te, tungga hita adꞌat na, atahori mana tabꞌu rates tao nanggenggeo aon, de nda nandaa ume hule-oꞌeꞌ rala neu sa. Hei atahori Farisi ra onaꞌ rates naa boe! Sia deaꞌ hei meu mara seli. Te rala mara sofeꞌ no manamburuꞌ.” ");
INSERT INTO row_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Hambu mahine hukun Yahudi esa sia naa, nggaso Yesus oꞌolan nae, “Ama Meser! Amaꞌ dedꞌea-oꞌolam faaꞌ ra naa, dai hai boe!” ");
INSERT INTO row_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesus nataa e nae, “Tebꞌe! Hei mana mihine hukun Yahudi re, hela fo ama hambu sosoeꞌ boe! Hei nda tulufali atahori ma tao minggafa masodꞌa nara sa, te ama boe tao miꞌisususaꞌ se no agamam hohoro-lalane mamabꞌera mara. Ma fee se lemba hei hohoro-lalane mataꞌ-mataꞌ mara. Te hei nda tulun lemba sobꞌa mamabꞌeraꞌ naa no lima uꞌu mara esa sa boe.! ");
INSERT INTO row_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Dei fo hei hambu sususaꞌ! Huu hei mbute-mue mifefela rii fatuꞌ fee Lamatuaꞌ mana ola-ola dalahulu nara fo fee hadꞌa-hormat neu se. Tao-tao te, hei bei-baꞌi mara mana tao risa mana ola-olaꞌ naa ra! ");
INSERT INTO row_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Hei o eiꞌ esa mo bei-baꞌi mara boe. Ara nda simbo Lamatuaꞌ mana ola-ola nara, ma tao risa se. Basa ma hei lutu-mbatu rates fee mana ola-olaꞌ ra, fo dadꞌi bukti oi, hei o tungga bei-baꞌi mara boe. ");
INSERT INTO row_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Huu naa, Lamatualain fo mana nahine basaꞌ e, olaꞌ nita nae, ‘Dei fo Au denu mana ola-ola ngga ra ro dedenuꞌ laen ra fo reu sia atahori Israꞌel ra. Basa ma, atahori naa ra tao doidꞌoso ruma, ma tao risa ruma.’ ");
INSERT INTO row_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Atahori mana rasodꞌa aleꞌ ia, musi lemba-dꞌoi atahori mana tao risa Lamatuaꞌ mana ola-ola nara. Naa reken mia Lamatuaꞌ tao raefafoꞌ ia, eniꞌ a Habel mamaten, losa maꞌabꞌui oe-oeꞌ a, Sakaria. Eni ia, fo risa sia mei tutunu-hohotuꞌ a no Kama Meumareꞌ a taladꞌan, sia Lamatualain Ume Hule-oꞌe Huuꞌ na. Hei o lemba mala huhuku-dodꞌoki nara boe! ");
INSERT INTO row_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Hei mana mihine hukun Yahudi ra e! Dei fo ama hambu sosoeꞌ! Huu hei mana toꞌu nggoeꞌ fo soi lelesu fo atahori hambu rahine malolole Lamatualain hihii-nanaun. Te hei nda masoꞌ naa mii sa. Deꞌulakan lenaꞌ fai, hei bꞌambi mala atahori, fo ara nda bisa masoꞌ naa reu sa!” ");
INSERT INTO row_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Leleꞌ Yesus olaꞌ basa ma, meser agama ro atahori Farisi ra ramue E. Eniꞌ a leleꞌ naa, ara akaꞌ ratane mataꞌ-mataꞌ fo rae teꞌe-sii raꞌatutudꞌaꞌ E. Ara sangga dalaꞌ rakandondooꞌ a fo tao nemuet ro E. ");
INSERT INTO row_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Leleꞌ naa, hambu atahori rifon hira rema rae rena Yesus. Ara laoꞌ rakaseseti ma heo rala E. Boe ma Ana olaꞌ naꞌahuluꞌ no ana dedꞌenu nara nae, “Minea ao mara fo afiꞌ tunga atahori Farisi ra mana dꞌea-rala nara. Huu ara hiiꞌ a olaꞌ laen, ma tao laen. ");
INSERT INTO row_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ara tao ao nara onaꞌ atahori maloleꞌ, te dei fo sira mana dꞌea-rala nara nenenitaꞌ. Huu basa mana neꞌefuniꞌ aleꞌ ia, dei fo nenenitaꞌ. ");
INSERT INTO row_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Saa fo hei olaꞌ funi-funiꞌ leleꞌ ia, dei fo atahori rena relo-relo. Saa fo hei utu-utu sia kama rala o, dei fo atahori olaꞌ rahereꞌ sia atahori hetar matan.” ");
INSERT INTO row_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yesus olaꞌ seluꞌ nae, Ana nggare! Afiꞌ mimitau mete ma atahori rae tao risa nggi. Huu ara bisa risaꞌ a hei ao-sisim, te nda bisa tao saa-saa mbali samanam sa boe. ");
INSERT INTO row_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Au ae ufadꞌe ae, hei musi mimitau seka. Hei musi mimitau Lamatualain. Huu Eni bisa tao nisa nggi, ma mbia nggi misiꞌ naraka rala mii. De Eni ia, fo hei musi mimitau tebꞌe-tebꞌeꞌ. ");
INSERT INTO row_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ama duꞌa sobꞌa, mbui lutuk felin baꞌu saa? Nda mafelit sa, to?! Mbuiꞌ lima na sen rua, to? Mae taꞌo naa o Lamatualain nda liliiꞌ hela esa sa boe. ");
INSERT INTO row_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Onaꞌ naa boe, Lamatuaꞌ taomataꞌ neu nggi. Ana nahine tebꞌe langga fuluꞌ hira sia langga mara. Dadꞌi ama afiꞌ, mimitau, huu Lamatuaꞌ nile hei lenaꞌ mbui lutuk hetar naa ra.” ");
INSERT INTO row_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Basa ma, Yesus olaꞌ fai no Ana dedꞌenun nae, “Pasa ndiki mara malolole! Mete ma hambu atahori nambarani nataa Au sia atahori hetar matan sia raefafoꞌ ia, dei fo Au o utaa e sia Lamatualain ana dedenu nara matan sia sorga ae, eni, Au atahori ngga. ");
INSERT INTO row_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Te mete ma hambu atahori olaꞌ sia atahori matan nae, eni nda nahine Au sa, dei fo Au o, olaꞌ sia Lamatualain ate nara matan sia sorga ae, Au o nda uhine e sa boe. ");
INSERT INTO row_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Au ia, Atahori Matetuꞌ a. Mete ma hambu atahori olaꞌ tao maꞌafo Nara malole ngga, na, Lamatualain feꞌe nau fee ambon neu salan. Te mete ma ana olaꞌ tao maꞌafo Lamatuaꞌ Dula-dꞌale Meumaren nara malolen, Lamatualain nda fee ambon neu salan sa. ");
INSERT INTO row_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Mete ma atahori ro nggi misiꞌ mamana neꞌetuꞌ dedꞌea-oꞌolaꞌ agama, fo, misiꞌ atahori mana toꞌu parenda ra, huu hei mimihere Au, na afiꞌ mimitau soꞌal hei mae misilaꞌe ao mara taꞌo bee. ");
INSERT INTO row_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Huu leleꞌ naa o, Lamatualain Dula-dꞌale Meumaren nanori nggi dedꞌea-oꞌolaꞌ nandaa no saa, fo hei parlu mitaa neu se.” ");
INSERT INTO row_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Basa naa ma, esa mia atahori hetar naa ra natane Yesus nae, “Ama Meser! Tulun denu aꞌa ngga fo bꞌanggi no au hai amam hata-heton dei.” ");
INSERT INTO row_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Te Yesus nataa e nae, “Wah! Seka mana soꞌu Au dadꞌi mana maꞌetu hei ruꞌa nggi dedꞌeꞌat ma mataꞌ naa?” ");
INSERT INTO row_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Basa ma Yesus olaꞌ neu atahori hetar naa ra nae, “Hei musi besa-bꞌesa fo afiꞌ misuu-miseti. Huu hata-hetoꞌ naeꞌ nda bisa tao nggi misodꞌa no mole-dꞌame sa.” ");
INSERT INTO row_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Boe ma, Ana dui nekendandaaꞌ sa nae, “Hambu atahori mamasuꞌiꞌ sa, osin hambu buna-bꞌoaꞌ naen seli. ");
INSERT INTO row_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Losa nggudꞌan nara sofe nenedidinaꞌ, de nda nitaꞌ nae tao taꞌo bee sa boe. ");
INSERT INTO row_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","De ana duꞌa nae, ‘Au ae tao taꞌoꞌ a ia! Au ofe hendi nggudꞌan mbaraaꞌ a, fo tao uꞌumoko e, fo au mbedꞌaꞌ osi ngga buna-bꞌoa nara ma basa hata-heto nggara sia naa. ");
INSERT INTO row_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Mete ma taꞌo naa ena, na au olaꞌ mbali ao ngga ae, ‘We! nggudꞌan sofe ena! Nanaat dai ua losa too-too ena. De mua-minu malaladꞌa ma mumuhoꞌo pepedꞌos ei ma leo!” ");
INSERT INTO row_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Te huu Lamatualain nafadꞌe neu e nae, ‘Woi! Nggoa ma, dei! Tetembaꞌ ia boe, mate nggo. Naa, seka mana hambu basa nggudꞌan ma isi-oen?’ ");
INSERT INTO row_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Dadꞌi taꞌo ia! Atahori bisa raꞌadꞌuru hata-hetoꞌ nae-nae sia raefafoꞌ ia soaꞌ neu aon, huu sia Lamatualain dudꞌuꞌan, eni, hata-taaꞌ, huu nda maloleꞌ no Lamatuaꞌ sa.” ");
INSERT INTO row_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Basa ma Yesus nanori seluꞌ ana dedenu nara nae, “Ama afiꞌ mbute-mue mo masodꞌa mara fai-fai esa, soꞌal mae mia saa do pake saa. ");
INSERT INTO row_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Huu hita masodꞌan ia, lenaꞌ mia saa fo hita taaꞌ a, ma saa fo hita pakeꞌ a. ");
INSERT INTO row_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mete sobꞌa mbui kaaꞌ ra! Ara nda sela sa, nda etu-oru sa, nda raꞌena nggudꞌan fo mbedꞌaꞌ nanaat sa, te Lamatualain naꞌabꞌoi se. Mete ma taꞌo naa, na, Ana o bisa naꞌabꞌoi nggi boe. Huu Ana nile hei lenaꞌ mbuiꞌ naa ra. ");
INSERT INTO row_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Mete ma atahori rambariiꞌ sia tiroao a matan, fo barias aon, na, ana bisa tao namadꞌoo fula-fai masodꞌan, do? Hokoꞌ! ");
INSERT INTO row_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Dadꞌi mete ma soaꞌ a mbute-mue mo dꞌala anak naa ra, nda nendi fee nggo saa sa boe, na, saa de hei feꞌe mae mbute-mue mo dꞌala monaeꞌ ra fai? Naa, onton na saa? ");
INSERT INTO row_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Mete sobꞌa bꞌuna lasi ra. Ara nda tao osi-lutu sa, ma nda tenu-lolo sa. Te mane Soleman bꞌua-baꞌu meulaun o, nda maloleꞌ lenaꞌ buna lasi a meulaun sa. ");
INSERT INTO row_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Huu Lamatualain naꞌaboi uru anaꞌ fo nda naꞌena sosoaꞌ sa, mana nasodꞌa faiꞌ ia, ma mbilaꞌ neu na mate, fo atahori nggari nisiꞌ ai rala. Mete ma taꞌo naa, na, Ana o bisa naꞌaboi hei fo mana mafeliꞌ lenaꞌ uru anaꞌ. Dadꞌi, taꞌo bee de hei nda mimihena tebꞌe-tebꞌeꞌ neu E sa? ");
INSERT INTO row_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Onaꞌ naa boe, hei sudꞌi dudꞌuꞌa dꞌala nanaa-nininuꞌ fai. Te dei fo Lamatuaꞌ mana ator. ");
INSERT INTO row_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Atahori nda mana namahena neu Lamatuaꞌ sa, ara ue-tao ritaꞌ mamate nara tao basa dalaꞌ naa ra. Te ama afiꞌ taꞌo naa, huu hei Amam sia sorga nahine basa saa fo hei parluꞌ ra ena. ");
INSERT INTO row_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mete ma hei milalao Lamatualain ue-tataos nara raꞌahuluꞌ, na, dei fo Ana o fee ia ra neu hei boe.” ");
INSERT INTO row_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Basa ma Yesus ola seluꞌ nae, “Hei onaꞌ bibꞌi lombo nononggo anaꞌ sa nda beꞌi saa sa boe. Te afiꞌ mimitau! Huu Ama ma sia sorga, Mane Monaeꞌ. Saa fo Eni enan, Ana namahoꞌo fee neu ana susue nara. ");
INSERT INTO row_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Dadꞌi mii seo hendi sudꞌiꞌ a saa mara, basa na babꞌanggi doi nara fee neu atahori mana toꞌa-taaꞌ ra. No taꞌo naa hei mbedꞌaꞌ suꞌit sia sorga. Naꞌo ra nda reu ramanaꞌo rala se sa, ma mbaꞌi ra o nda raꞌaninisi ralutu hendi se sa. ");
INSERT INTO row_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Misinedꞌa malolole! Hei hata-heto mara sia bee na, rala mara o sia naa boe.” ");
INSERT INTO row_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Yesus olaꞌ seluꞌ fai nae, “Hei musi mihehere fo ue-tao fee Lamatuaꞌ hatuꞌ-rerelon. Onaꞌ ana dedenuꞌ mana beꞌe nahani tenu umeꞌ a baliꞌ ume nema mia fefeta kakabꞌiꞌ. Mete ma malangga dedꞌeu lelesu a, na, ana bisa soi lai-lai. ");
INSERT INTO row_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Mete ma malangga nema hambu atahori mana tao ues nara rahani taꞌo naa, na ara onton. Huu dei fo malangga natudꞌu rala malolen neu se. Ana pake bua-baꞌus onaꞌ atahori mana tao ues nara, fo neu nahao se nanaa maladꞌaꞌ. ");
INSERT INTO row_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Atahori mana tao-ues ra memaꞌ onton huu ara tao-mataꞌ neu malangga no malole. Mae malangga sudꞌiꞌ a nema faiꞌ baꞌu saa, neofaꞌ do deka manggarelo o, ara rahehere rakandooꞌ a. ");
INSERT INTO row_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Dꞌuꞌa malolole! Mete ma hambu tenu umeꞌ nahine tebꞌe faiꞌ baꞌu saa naꞌo ra rae rema, neꞌo ana nda fee kakaꞌe fo naꞌo ra bonggar umen sa. ");
INSERT INTO row_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Dadꞌi hei musi mihehere mikindooꞌ a, huu nda hambu atahori rahine tebꞌe fai hiraꞌ Atahori Matetuꞌ a nae nema sa.” ");
INSERT INTO row_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Basa ma, Petrus natane Yesus nae, “Ama Meser! Amaꞌ nekendandaan faaꞌ ra naa, dai akaꞌ hai, do dai basa atahori?” ");
INSERT INTO row_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","44","Ma Yesus nataa nae, “Nekendandaaꞌ naa dai basa atahori mana tao onaꞌ malangga mana tao-ues mahineꞌ a, mana naꞌtataaꞌ no malanggan. Dei fo malanggan soꞌu e fo babꞌanggi nanaat fee atahori mana tao-ues laen ra. Mete ma ana manggate tao tungga ue-tataon taꞌo naa, mae malanggan nema sudꞌiꞌ a fain sa o, ana tao-taoꞌ a ue-tataon no tebꞌe-tebꞌeꞌ. De ana onton, huu dei fo malanggan soꞌu e fo mete-seꞌu basa hata-heto nara. ");
INSERT INTO row_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Te soe neu e mete ma malangga mana tao-ues dudꞌuꞌa nae, ‘Eh! Neꞌo toulasiꞌ a feꞌe doo fo ana nema.’ Boe ma ana poko-paru atahori mana tao-ues laen ra, touꞌ ma inaꞌ ra. Boe ma ana endoꞌ naa-ninu maꞌahee losa mafu. ");
INSERT INTO row_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Te faiꞌ sa ma, leleꞌ malangga mana tao-ues a nda medꞌa nala sa, aiboiꞌ ma malangga a baliꞌ. Leleꞌ malangga bubꞌulu dalaꞌ naa ra, ma ana poko-paru e tuteꞌ a, de oi hendi e, fo hambu nala bala-bꞌaen onaꞌ atahori nda mana raꞌatataaꞌ tungga malangga hihii-nanaun sa. ");
INSERT INTO row_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Huu atahori mana tao-ues mana nahine malangga hihii-nanaun, te nda nahehere tao tungga sa, do, nda nau tao tungga sa, dei fo nenehuku-dokiꞌ bꞌeran seli. ");
INSERT INTO row_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Te atahori mana tao ues mana ue-tao leli huu nda nahine malangga hihii-nanaun sa, dei fo hambu huku-dokiꞌ nggafat. Atahori mana simbo naen seli, eni babꞌala-babaen o naeꞌ boe. Atahori mana simbo ue-tataos monaeꞌ, lemba-nesaan o naeꞌ boe.” ");
INSERT INTO row_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yesus tute oꞌolan nae, “Au uma fo saranggaa hendi atahori nggara mia atahori laen ra sia raefafoꞌ ia. Naa, onaꞌ atahori hotu manggarauꞌ rendiꞌ ai mbilaꞌ. Au hihii ngga ai a mulai mbila sia bee-bꞌee ena. ");
INSERT INTO row_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Te huu Au musi lemba-dꞌoi uꞌuhuluꞌ doidꞌosoꞌ manaseliꞌ dei, naa fo tebꞌe-tebꞌeꞌ Au doidꞌoso losa ue-tatao Ngga basa. ");
INSERT INTO row_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Hei duꞌa mae Au uma endi mole-dꞌameꞌ nisiꞌ raefafoꞌ ia, do? Hokoꞌ! Au uma tao atahori ra ratofa rasimboꞌ bafaꞌ, ma tao fee atahori ra sea-saranggaa huu nenori Ngga. ");
INSERT INTO row_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mia leleꞌ ia odꞌi-aꞌa toronoo bꞌonggiꞌ ra o sea-saranggaa. Sia ume sa, telu labꞌan rua, do rua labꞌan telu. ");
INSERT INTO row_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ama bonggiꞌ labꞌan ana bonggiꞌ; ana bonggiꞌ labꞌan ama bonggiꞌ. Ina bonggiꞌ labꞌan ana bonggiꞌ; ana bonggiꞌ labꞌan ina bonggiꞌ. Ina ariꞌ labꞌan ana arin; ana ariꞌ labꞌan ina arin.” ");
INSERT INTO row_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Boe ma Yesus olaꞌ no atahori hetar naa ra nae, “Mete ma hei mita lelee fauꞌ sou sia muri, hei mae, ‘ia, nenendin udꞌan nae nema ena.’ Memaꞌ tebꞌe taꞌo naa. ");
INSERT INTO row_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Mete ma ani onas fuu nema, hei mae, ‘ia, nenendin faiꞌ ia matobꞌiꞌ seli.’ Memaꞌ tebꞌe taꞌo naa. ");
INSERT INTO row_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Woi! Hei atahori mana dꞌea-ralaꞌ mana olaꞌ laen na tao laen re! Hei miꞌindandaaꞌ mihine fula-fai tungga lalai no raefafoꞌ ia nenendin. Te taꞌo bee de hei nda nau mihine Lamatualain hihii-nanaun leleꞌ ia sa?” ");
INSERT INTO row_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","58","Yesus olaꞌ seluꞌ nae, “Mete ma hei midꞌedꞌea na, taꞌo bee de hei nda miꞌetuꞌ aom mae bee tebꞌe sa! Malole lenaꞌ dꞌame dei! Afiꞌ losa hei losa mana nggero-furiꞌ a matan, ma ana naꞌetuꞌ tao nggi bui rala mii. ");
INSERT INTO row_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Huu mete ma taꞌo naa, neꞌo hei nda bisa dea mii sa losa bꞌae mibasaꞌ huta-bukuꞌ fo mana nggero a naꞌetu basaꞌ a.” ");
INSERT INTO row_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Leleꞌ naa, hambu atahori rafadꞌe Yesus oi, hofernor Pilatus nisa atahori Yahudi hira mia Galilea, leleꞌ ara rendi tutunu-hohotuꞌ nisiꞌ Ume Hule-oꞌe Huuꞌ a sia Yerusalem. ");
INSERT INTO row_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Rena taꞌo naa, ma Yesus natane se nae, “Tungga hei, na, atahori nenetao nisaꞌ naa ra, sala nara monaeꞌ lena basa atahori Galilea laen ra, do? Naa de ara nenehuku-dokiꞌ, do? ");
INSERT INTO row_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Hokoꞌ! Te mete ma hei nda lao hela masodꞌa deꞌulakaꞌ mara sa, fo tungga baliꞌ Lamatuaꞌ hihii-nanaun, na, dei fo hei o mimbilutu onaꞌ se boe. ");
INSERT INTO row_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ma atahori ka sanahulu faluꞌ mana mate nenetendes manara mana ndefaꞌ sia Siloam faiꞌ naa, ara onaꞌ bee? Sala nara monaeꞌ lenaꞌ basa atahori laen mana sia Yerusalem, do? ");
INSERT INTO row_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Hokoꞌ! Te mete ma hei nda lao hela hei leleo-lalao mana tao leli mara sa, fo tungga baliꞌ Lamatuaꞌ dꞌala ndoo-tetun, na, dei fo hei o mimbilulutu onaꞌ se boe.” ");
INSERT INTO row_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Basa ma, Yesus fee nekendandaaꞌ esa nae, “Hambu atahori sa sela hau huu mabꞌoaꞌ sa sia osin. Ana akaꞌ nema nadoꞌ e fo nae nahine nabꞌoa ena, do hokoꞌ. Te hau naa, nda feꞌe nabꞌoa sa. ");
INSERT INTO row_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Basa ma, ana denu mana manea osi a nae, “Too telu ia ena, au uma usufafali sangga hau ia bꞌoan. Te au nda hambu saa sa boe. De ungga hendi e leo, huu hau huuꞌ ia nalaꞌ a mamanaꞌ.’ ");
INSERT INTO row_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Te mana tao osi a nataa nae, ‘Amaꞌ afiꞌ mumunasa. Fee hau huuꞌ ia too esa fai. Hela fo au sasaro ndule e, basa fo mbori pupuk neu e, naa fo ana sengga baliꞌ ");
INSERT INTO row_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Mete ma too mana nemaꞌ ma hau huuꞌ ia nabꞌoa, na, malole. Te mete ma hokoꞌ, na, ungga hendi e leo.’” ");
INSERT INTO row_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Lao esa, nandaa no atahori Yahudi ra fai hule-oꞌen, Yesus neu nanori sia ume hule-oꞌeꞌ. ");
INSERT INTO row_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Sia naa hambu inaꞌ sa ruku too sanahulu falu ena, huu nitu ra tataon. Ana nda nambariiꞌ nala tetuꞌ sa. ");
INSERT INTO row_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesus nita inaꞌ naa ma, Ana noꞌe nala e, de olaꞌ nae, “Mama! Ia naa mama hai ena.” ");
INSERT INTO row_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Boe ma Yesus nggama liman neu inaꞌ a. Aibꞌoiꞌ ma, inaꞌ a nggarasan tetuꞌ neuꞌ ena. Boe ma ana noꞌe makasi, no koa-kio Lamatualain. ");
INSERT INTO row_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Te malangga ume hule-oꞌeꞌ a namanasa, huu Yesus tao nahaiꞌ atahori nandaa no fai hule-oꞌeꞌ. Boe ma ana nafadꞌe neu atahori hetar naa ra nae, “Sia nggarei sa rala hambu fai nee fo tao ue-osaꞌ. De malole lenaꞌ atahori hedꞌis ra rema sia fai-fai tao ue-osaꞌ ra, fo sangga atahori raꞌahahaiꞌ se. Afiꞌ rema sia fai hule-oꞌeꞌ!” ");
INSERT INTO row_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Te Yesus nataa e nae, “Hee! Atahori mana dꞌea-ralaꞌ. Sia fai hule-oꞌeꞌ o hei tao ue-osaꞌ boe, to?! Huu hei o mii mboꞌi sapi ma keledei mara fo fee se rinu, to?! ");
INSERT INTO row_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Mama ia, baꞌi Abraham tititi-nonosin, onaꞌ hitaꞌ boe. Nitu ra malanggan paꞌa nala e too sanahulu falu ena. De mete ma Au mboꞌi e nandaa no fai hule-oꞌeꞌ, na, sala do?” ");
INSERT INTO row_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Rena taꞌo naa, ma Yesus musu nara mae. Te atahori naeꞌ naa ra ramahoꞌo ro Eni ue-tatao meulaun. ");
INSERT INTO row_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Boe ma Yesus olaꞌ seluꞌ fai nae, “Au uꞌusasamaꞌ Lamatuaꞌ atahori nara onaꞌ saa, e? ");
INSERT INTO row_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Fefeun sira hidaꞌ a, te dodꞌoo ma ara boe ramaheta. Fefeun ara onaꞌ fini dekeꞌ anadikiꞌ. Atahori sela sia osi. Basa ma ana mori de dadꞌi hau huu ineꞌ, Ma mbuiꞌ ra rema randuna sia dꞌana nara.” ");
INSERT INTO row_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Basa de Yesus olaꞌ fai nae, “Au uꞌusasamaꞌ Lamatuaꞌ atahori nara no saa fai, e? ");
INSERT INTO row_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ana onaꞌ bibꞌit roti fo inaꞌ ra sambor no tarigu saku rua, fo tao roti naeꞌ. Boe ma tarigu hene monaen seli, huu bibꞌit mbei anak naa. Lamatuaꞌ atahori nara pangaru nara boe namanae onaꞌ naa boe. ");
INSERT INTO row_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Basa naa ma, Yesus se lao risiꞌ kota Yerusalem. Ana tuli tungga-tungga dalaꞌ, sia kota ma kamboꞌ fo nanori atahori ra. ");
INSERT INTO row_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mia mamanaꞌ sa, hambu atahori sa natane E nae, “Ama Meser! Mbei ma akaꞌ atahori hidꞌaꞌ a hambu masodꞌaꞌ, do?” ");
INSERT INTO row_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Ana nataa nae, “Sorga lelesun anadꞌikiꞌ anaꞌ a. De mihehere ei mara fo rala mii tungga naa. Huu hambu atahori hetar rae sobꞌa rala reu, te nda rala sa. ");
INSERT INTO row_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Mete ma tenu umeꞌ a nggoe lelesu a, dei fo mimbiriiꞌ siaꞌ a dꞌeaꞌ fo dedꞌeu lelesu a, ma mimeli moꞌe tulu-faliꞌ, mae ‘Papa! Soi lelesu a dꞌei!’ Te dei fo Ana nataa nae, ‘Hei seka, ra? Au nda uhine nggi sa!’ ");
INSERT INTO row_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Boe ma hei mae, ‘Taꞌo bee de papa nda muhine hai sa? Hai mana endoꞌ mia-minu mo papa. Ma papa biasa munori hai sia okofoꞌ ra boe.’ ");
INSERT INTO row_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Dei fo nataa nae, ‘Au ufadꞌe faaꞌ ra, Au nda uhine hei sa! Hei ia ra, atahori mana taoꞌ a deꞌulakaꞌ ra. Dꞌinggoꞌ hela ia!” ");
INSERT INTO row_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Basa dei fo, leleꞌ Lamatualain naꞌetu basa atahori dedꞌeat nara, hei nggae eiei ma henggu nisi mara. Huu hei mita baꞌi Abraham, baꞌi Isak, baꞌi Yakob ro Lamatualin mana ola-ola nara basa se endoꞌ masoꞌ risiꞌ sorga ena. Te hei neneoi hendiꞌ siaꞌ a dꞌeaꞌ. ");
INSERT INTO row_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Dei fo atahori rema mia ndule raefafoꞌ suun, mia rulu losa muri, mia dꞌii losa ona, fo endoꞌ raa raꞌabꞌue sia Lamatualain ume manen. ");
INSERT INTO row_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Misinedꞌa malolole basa ia ra: mete ma Lamatuaꞌ naꞌetuꞌ basa atahori ra dedꞌea nara, hambu atahori fo maꞌahulun atahori rae neꞌo eni atahori anak, te ana hambu hadꞌa-hormat monaeꞌ. Boe ma hambu atahori fo maꞌahulun atahori rae, eni atahori monaeꞌ, tao-tao te Lamatuaꞌ nae eni atahori anak.” ");
INSERT INTO row_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Leleꞌ naa, hambu atahori Farisi hira rema randaa ro Yesus, de rafadꞌe rae, “Malole lenaꞌ, Ama Meser muꞌudꞌodꞌooꞌ misiꞌ mamanaꞌ laen, huu mane Herodes nae tao nisa Amaꞌ.” ");
INSERT INTO row_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","33","Boe ma Yesus nataa nae, “Hee! Tou lasiꞌ naa onaꞌ busa fui e! Mii mifadꞌe e mae, ‘Au oi nitu ra ma uꞌuhahaiꞌ atahori mamahedꞌiꞌ ra faiꞌ ia ma mbila. Fini esaꞌ fo Au ue-tatao ngga basa.’ Onaꞌ mae taꞌo bee o, Au feꞌe ae ue-tao seluꞌ mbei fai sia lalao ngga isiꞌ Yerusalem, Huu atahori Yerusalem naa ra, mana hiiꞌ a tao risa Lamatualain mana ola-ola nara. ");
INSERT INTO row_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Aduu, atahori Yerusalem ra, e! Hei ia ra akaꞌ misa Lamatualain mana ola-ola nara, ma honda-mbia misa dedꞌenuꞌ fo mana rae rema ratudꞌu dalaꞌ fee nggi. Lao hetar, Au ae uꞌubꞌue ma unea nggi fo mbambi ala nggi mia deꞌulakaꞌ ra, ona manu ine nasalaꞌe nala ana nara sia lidꞌan rala. Te huu hei nda nau sa. ");
INSERT INTO row_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ia naa, Lamatuaꞌ nda tao afiꞌ neu ume hule-oꞌem sa ena. De mbila do finiesaꞌ te rouꞌ ena. Dei fo hei nda afiꞌ mita Au sa ena, losa mitaa mae, ‘Lamatualain fee papala-babꞌanggiꞌ neu atahori mana nendi Lamatuaꞌ naran, huu Lamatuaꞌ denu E ena!’” ");
INSERT INTO row_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Lao esa, nandaa no fai hule-oꞌeꞌ, atahori partei agama Farisi ra malanggan esa noꞌe Yesus fo nema naa sia umen. Ana endoꞌ naa-ninu, ma hambu atahori maku-maꞌu E fo rae rita Ana nae tao saa nandaa no fai hule-oꞌeꞌ. ");
INSERT INTO row_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Leleꞌ naa, hambu atahori esa mamahedꞌi ao maꞌasofeꞌ endoꞌ sia naa boe. ");
INSERT INTO row_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Boe ma, Yesus natane mahine hukun Yahudi ma atahori Farisi mana endo raa-rinu sia naa nae, “Tungga baꞌi Musa hohoro-lalanen, bisa tao nahaiꞌ atahori hedꞌis, nandaa no fai hule-oꞌeꞌ, do hokoꞌ?” ");
INSERT INTO row_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Te nda hambu esa nahara sa boe. Boe ma Yesus kois atahori mamahedꞌiꞌ a, de hai neuꞌ ena. Basa ma Yesus denu e baliꞌ. ");
INSERT INTO row_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Basa naa ma, Yesus natane se fai nae, “Mete ma hambu anadikiꞌ sa tudꞌa oe rala neu, nandaa no fai hule-oꞌeꞌ, hei mii nore baliꞌ e dꞌean, do hokoꞌ? Mete ma sapi a tudꞌa rala neu, na hei hela e, do, lea hendi e dꞌean? Neꞌo hei lea hendi e dꞌean. De naa sosoan nae, hei o tao ues ena boe, to!” ");
INSERT INTO row_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Rena Yesus olaꞌ taꞌo naa, te nda hambu atahori esa bisa nataa E sa boe. ");
INSERT INTO row_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Leleꞌ naa, Yesus memeteꞌ atahori mana rema raa sia ume fefetas a. Hambu atahori hetar pili mamanaꞌ sia mataꞌ, fo reu endoꞌ sia naa. Nita taꞌo naa, boe ma Ana olaꞌ nae, ");
INSERT INTO row_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Besa-bꞌesa, o! Mete ma atahori rarolo nggi misiꞌ fefeta kakabꞌiꞌ, na, afiꞌ mii endo sia ataori moko-monaen ra mamanan. Huu afiꞌ losa tenu fefetas narolo fuiꞌ manaseliꞌ lenaꞌ nggo. ");
INSERT INTO row_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Mete ma taꞌo naa, tenu fefetas neꞌo nema olaꞌ no nggo nae, ‘Afiꞌ mumunasa, e! Amaꞌ tulun lali misiꞌ deaꞌ naa dei, huu au sadꞌia hela kadꞌera ia fee neu atahori moko monaen ra.’ Boe ma ho fela hela kadꞌera naa no mamaet, de muu endoꞌ sia seku dꞌeaꞌ. ");
INSERT INTO row_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Dadꞌi mete ma hambu nerolot, na, muu endoꞌ sia kadꞌera mana seku sia deaꞌ. Dei fo mete ma tenu fefetas nita nggo, na neti noꞌe nae, ‘Eh, Amaꞌ! Laꞌi fo endoꞌ sia mataꞌ ia.’ No taꞌo naa hei hambu hadꞌa-hormat sia atahori fuiꞌ ra matan nara. ");
INSERT INTO row_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Huu atahori mana soꞌu-soꞌuꞌ aon, dei fo Lamatuaꞌ naꞌatutudꞌaꞌ e. Te atahori mana tao aon onaꞌ anadꞌiki, dei fo Lamatuaꞌ soꞌu nanaru e.” ");
INSERT INTO row_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Basa naa ma, Yesus olaꞌ no tenu umeꞌ a nae, “Faiꞌ ruma, mete ma amaꞌ tao fefetas, na, afiꞌ muroloꞌ a bobꞌonggim no nonoom atahori mamasuꞌiꞌ ra! Te neꞌo ara bisa rarolo baliꞌ nggo fai! ");
INSERT INTO row_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","De mete ma amaꞌ feta-dꞌote, na, murolo atahori hata-taaꞌ, ei doꞌoꞌ, keko-lukuꞌ, ma atahori pokeꞌ ra. ");
INSERT INTO row_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Huu neꞌo ara nda bisa bala-bꞌae rala nggo sa. Te mete ma amaꞌ murolo se, Lamatualain mana bala-bꞌae. Dei fo mete ma nafefela baliꞌ atahori mamahereꞌ mia mamates ena, Ana nda liliiꞌ amaꞌ malolem sa.” ");
INSERT INTO row_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Rena taꞌo naa ma, hambu atahori sa mana endoꞌ no Yesus olaꞌ nae, “Atahori mana onton seli naeni atahori mana raa raꞌabꞌue sia Lamatualain ume manen, o!” ");
INSERT INTO row_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesus nataa e nae, “Au dui taꞌo ia: Hambu atahori sa tao fefeta ineꞌ. Boe ma ana narolo atahori hetar. ");
INSERT INTO row_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Leleꞌ ara sadꞌia rala fefetas ena ma, ana denu atahori dedꞌenun, neu noꞌe atahori mana hambu nerolotꞌ ra nae, ‘Laꞌi, te fefetas sangga mulai ena.’ ");
INSERT INTO row_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Te basa se sangga dalaꞌ mataꞌ-mataꞌ naa fo ara nda reu sa. Esa bꞌale nae, ‘Waa! Au feꞌe hasa ala osi sa, de au musi uu mete sobꞌa e dei. Afiꞌ mumunasa o! Huu au nda bisa uu sa.’ ");
INSERT INTO row_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Hambu esa fai nae, ‘Au feꞌe hasa ala sapi hohombu moleꞌ pasan lima. Au ae uu sobꞌa sudꞌi se, de afiꞌ mumunasa, o! ");
INSERT INTO row_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Esa fai nae, ‘Au feꞌe sao ena, de nda bisa uu sa.’ ");
INSERT INTO row_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Basa ma, atahori dedꞌenuꞌ a baliꞌ de nafadꞌe tenu fefetas a. Rena nala ma, tenu fefetas namanasa seli. Boe ma ana parenda atahori dedꞌenuꞌ a nae, ‘Mete ma taꞌo naa, lao muu leo lai-lai! Muu sia basa okofoꞌ ma dꞌala kabiaꞌ ra sia kota, fo murolo mendi basa atahori hata-taaꞌ ra, ei doꞌo, pokeꞌ, ma keko-lukuꞌ ra.’ ");
INSERT INTO row_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Rena taꞌo naa ma, atahori dꞌedeꞌnuꞌ a neu narolo atahori ra. De ana baliꞌ ma nafadꞌe nae, ‘Amaꞌ!! Basa se rema ena, te mamana rouꞌ feꞌe hetar.’ ");
INSERT INTO row_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Boe ma tenu fefetas nae, ‘Mete ma taꞌo naa, muu seluꞌ fai sia kambo-kamboꞌ sia kota dꞌeaꞌ, losa osi-lutu ra. Kokoe sudꞌiꞌ a se, fo mo se rema, sadꞌi tao sofe mamana fefetas ia. ");
INSERT INTO row_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Rena, e! Atahori nda mana simbo nerolo ngga naa, ara nda ramedꞌa rita fefetas ia nanaat nara maladꞌan mbei sa boe!’” ");
INSERT INTO row_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Basa naa ma, Yesus se lao rakandoo risiꞌ Yerusalem. Atahori hetar tungga E. De Ana mbali se, ma Ana olaꞌ nae, ");
INSERT INTO row_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“‘Atahori mana tebꞌe-tebꞌeꞌ nau tungga Au, ana musi sue Au lenaꞌ basa e: lenaꞌ ina-ama nara, lenaꞌ sao-ana nara, lenaꞌ odꞌi-aꞌa nara, lelenan fai eni aon. Mete ma hokoꞌ, atahori naa, nda nandaa dadꞌi Au ana mana tungga ngga sa. ");
INSERT INTO row_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Te atahori mana nda nau lemba doidꞌosoꞌ sa, huu ana tungga Au, ana nda nandaa dadꞌi Au atahori ngga sa. Atahori mana nae dadꞌi Au atahori ngga, onaꞌ mae atahori rae tao risa e o, ana lemba nakandoo doidꞌoson. ");
INSERT INTO row_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Dadꞌi mete ma mae tungga Au, na, duꞌa malolole dei. Onaꞌ atahori rae rafefela Ume dek. Ana musi reken lutuꞌ-leloꞌ naꞌahuluꞌ dei, ume nala dꞌoiꞌ baꞌu saa. Afiꞌ losa dꞌoiꞌ nda dai sa. ");
INSERT INTO row_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Huu mete ma nda ito-reken lutuꞌ-leloꞌ sa na, afiꞌ losa feꞌe taoꞌ a ume a netehun, te dꞌoiꞌ basa ena. Ma atahori ra mali raꞌamamaeꞌ e, ");
INSERT INTO row_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","rae, ‘Hei mita atahori naa dei! Ana feꞌe taoꞌ a ume netehun, nda feꞌe saa sa boe, te dꞌoin basa ena.’ ");
INSERT INTO row_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Conto Laen fai, naeni soꞌal netatiꞌ. Mane mana nae natati musi endoꞌ no nonoon nara fo ola-olaꞌ raꞌahuluꞌ deiꞌ Mete ma naꞌena a soldꞌadꞌu atahori rifon sanahuluꞌ a, na musi timba-tai eni bisa nasenggiꞌ musu, atahori rifon ruanulu, do hokoꞌ? ");
INSERT INTO row_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Mete ma timba-tai basa, ma duꞌa nae neꞌo eni nda nasenggiꞌ sa, na, malole lenaꞌ, leleꞌ musu a feꞌe sia dodꞌooꞌ, te ana haitua memaꞌ dedꞌenuꞌ fo olaꞌ dꞌame. ");
INSERT INTO row_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Onaꞌ naa boe, atahori mana nae tungga Au. Eni musi duꞌa neu-nema malolole, nae eni nahehere lao hela basaꞌ e, do hokoꞌ? Mete ma hokoꞌ, atahori naa nda nandaa dadꞌi ana dedꞌenu Ngga sa.” ");
INSERT INTO row_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","35","Yesus tute seluꞌ dedꞌea-oꞌolan no conto laen fai nae, “Masiꞌ naa, maloleꞌ. Hita pake fo tao maladꞌa nanaat. Te mete ma masiꞌ a nda masi sa ena, na nggunan sa fai? Hita nda bisa pake e fo tao maladꞌa nanaat sa ena. Tae tao dadꞌi pupuk o, nda bisa sa ena. Hita nggari hendi e neuꞌ ena. Dadꞌi hei o musi dadꞌi onaꞌ masiꞌ a, fo misodꞌa sue-lai basa atahori. Seka ma ndikiꞌ, na, rena malolole, o!” ");
INSERT INTO row_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Leleꞌ naa, atahori mana edꞌa bꞌea ma atahori nda papakeꞌ laen ra sa, akaꞌ rema risiꞌ Yesus fo rae rena E. Te atahori Yahudi ra rae fee se atahori nda maloleꞌ sa. ");
INSERT INTO row_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Atahori Farisi ro meser agama Yahudi ra rita taꞌo naa ma unggu-remu rae, “Ciih! Atahori ia naꞌabꞌue no atahori nda papakeꞌ ra sa. Lenaꞌ fai Ana endoꞌ naa no se boe!” ");
INSERT INTO row_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yesus rena taꞌo naa ma, Ana dui fee se nekendandaaꞌ nae, ");
INSERT INTO row_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Mete ma mia hei ia hambu atahori sa naꞌena bibꞌi lombo natun esa. Boe ma mopo hendi esa. Oras ia atahori naa musi tao sa? Neꞌo ana lao hela bibꞌi lombo ka sio nulu sioꞌ ra reu lenuꞌ sa, ma neu sangga losa ana nita baliꞌ bibꞌi lombo mana mopoꞌ a. ");
INSERT INTO row_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Leleꞌ ana nita baliꞌ bibꞌi lombo naa, ma nasaa nendi baliꞌ e no nemehoꞌot. ");
INSERT INTO row_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Losa ume, ma ana noꞌe nala nonoon nara, de nafadꞌe se nae, ‘Wae! Hei ima mimihoꞌo mo au dei! Huu au ita baliꞌ bibꞌi lombo mana mopoꞌ ngga ena.’ ");
INSERT INTO row_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Naa, sia sorga o onaꞌ naa boe. mete ma hambu atahori mana tao salaꞌ sa dꞌoaꞌ ena, fo baliꞌ nisiꞌ Lamatuaꞌ, na basa mana sia sorga ra ramahoꞌo. Ara romahoꞌo lenaꞌ huu atahori esa mana bali nisiꞌ Lamatua, mia atahori ka sionulu sioꞌ fo mana rasodꞌa no ndoo-tetuꞌ, ma nda laoꞌ sala dalaꞌ sa.” ");
INSERT INTO row_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Boe ma Yesus dui nekendandaaꞌ esa fai nae, “Hambu mama esa naꞌena doi fulaꞌ sanahulu. Te, mopo hendi esa. Oras ia, ana nae tao saa o? Neꞌo ana neu nambilaꞌ lambu fo dꞌelo sia bee-bꞌee, ma ngganggai ume a losa mamana makabiaꞌ ra, fo sangga dꞌoiꞌ naa no malolole. ");
INSERT INTO row_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Leleꞌ ana nita baliꞌ dꞌoiꞌ naa ma, ana neu noꞌe atahori ume titia nara, de nafadꞌe nae, Woi! ima fo mimihoꞌo mo au dei! Huu au ita baliꞌ doi mana mopo ngga ena!’ ");
INSERT INTO row_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Sia sorga o onaꞌ naa boe. Mete ma hambu atahori mana tao salaꞌ sa dꞌoaꞌ, de baliꞌ nisiꞌ Lamatuaꞌ, na, basa dedꞌenuꞌ sia sorga ramahoꞌo seli boe.” ");
INSERT INTO row_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesus tute oꞌolan nendiꞌ nekendandaaꞌ laen esa fai nae, “Hambu amaꞌ sa no anan touꞌ rua. ");
INSERT INTO row_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Lao esa, ana murin nafadꞌe aman nae, ‘Amaꞌ e! Banggi fee au hata-hetoꞌ ra leo! Boe ma aman babꞌanggi hata-hetoꞌ ra fee neu ruꞌa se. ");
INSERT INTO row_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Nda dooꞌ sa ma, ana muriꞌ a seo hendi ena nara. De ana mboti bꞌua-baꞌu nara, boe ma lao nisiꞌ nusa dodꞌooꞌ. Sia naa, ana ngganggari doi nara no nesodꞌat sosoa aoꞌ. ");
INSERT INTO row_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Leleꞌ doi nara basa ma, ndoe-laꞌas manaseliꞌ dai nusaꞌ naa, de ana o nasodꞌa toꞌa-taa nala seli. ");
INSERT INTO row_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Boe ma neu sangga ues. Atahori sa sia nusaꞌ naa simbo e de denu e hani fafi nara. ");
INSERT INTO row_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Huu anaꞌ naa nda nabeꞌi ndondoen sa ena, de ana nae naa fafi ra nanaat na. Huu nda hambu atahori esa fee ne nanaat sa boe. ");
INSERT INTO row_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Dodꞌoo ma ana duꞌa neu-nema nae, ‘Sia ama ngga umen, basa atahori mana tao-ues ra hambu raa losa raꞌabꞌeta. Te au sia ia aeꞌ a mate ndoes ena. ");
INSERT INTO row_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Malole lenaꞌ, au baliꞌ isiꞌ ama ngga. Fo ufadꞌe ae, “Amaꞌ! Au tao sala monaeꞌ ena neu Lamatuaꞌ ma amaꞌ boe. ");
INSERT INTO row_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Au nda undandaa dadꞌi amaꞌ anan sa ena. Sadꞌi amaꞌ simbo au dadꞌi ate sia amaꞌ umen, o naa malole boe!’” ");
INSERT INTO row_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ana duꞌa nala taꞌo naa ma, fela de baliꞌ nisiꞌ aman umen. Feꞌe sia dodꞌooꞌ te toulasiꞌ a nita e, ma tudꞌa kasian mbali e. Ana onda mia umen de nela-nelaꞌ neu soru anan mana baliꞌ a. De ana holu ma idꞌu e. ");
INSERT INTO row_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Boe ma anaꞌ a olaꞌ no aman nae, ‘Amaꞌ! Au tao sala monaeꞌ neu Lamatuaꞌ ma amaꞌ. Au nda undandaa dadꞌi anam sa ena.’ ");
INSERT INTO row_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Te aman parenda tuteꞌ atahori mana tao ues nara nae, ‘Woi! Lailai, e! Mii haꞌi mendi badꞌu meulauꞌ seli a! fo fee ne pake. Olu ndeli neu lima uꞌun, ma sapatu neu ei nara. ");
INSERT INTO row_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Mii lea mala sapi mbarunaꞌ naa fo tati, te hita tae feta-dote teu esa. ");
INSERT INTO row_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Huu ana ngga ia onaꞌ mana mateꞌ ena, te ia naa ana nasodꞌa baliꞌ ena. Ana mopo, te ia naa au hambu baliꞌ e ena.’ Olaꞌ basa taꞌo naa ma, ara feta-dꞌote boe. ");
INSERT INTO row_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Leleꞌ naa, ana uluꞌ a nese ume, huu ana neu tao ues sia osi rala. Leleꞌ ana baliꞌ ma, feꞌe sia dodꞌooꞌ te ana rena atahori raꞌaminaꞌ lii-liiꞌ ma lendo-foti. ");
INSERT INTO row_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Boe ma ana noꞌe nala mana tao ues esa, de natane nae, ‘Woi! Tao rarameꞌ saa ia?’ ");
INSERT INTO row_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Atahori mana tao ues a nataa nae, ‘Malangga odꞌi ma nema ena. Dadꞌi amaꞌ, denu tati sapi fo tao fefeta monaeꞌ, huu anan baliꞌ no sodꞌaꞌ.’ ");
INSERT INTO row_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Rena taꞌo naa, ma ana uluꞌ a namanasa. Ana nda nau ume rala neu sa ena. Boe ma aman nema de kokoe e ume rala neu. ");
INSERT INTO row_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Te ana namue nae, ‘Amaꞌ! Dꞌuꞌa sobꞌa dei! Dꞌoon basa ia au tao ues itaꞌ mamate ngga onaꞌ ate fee amaꞌ. Au nda ulena-langga neu amaꞌ hihii-nanaun sa. Onaꞌ naa o, amaꞌ nda feꞌe fee mita au hie anaꞌ esa fo tao fefetas umuhoꞌo o nonoo nggara sa boe. ");
INSERT INTO row_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Tao-tao te amaꞌ ana mana ngganggari hata-hetoꞌ a, neu naꞌaminaꞌ no inaꞌ ra de nabasaꞌ amaꞌ dꞌoin. Ana baliꞌ nema ma, amaꞌ tati sapi malolen seli de tao fefeta monaeꞌ fee ne.’ ");
INSERT INTO row_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Te aman nataa nae, ‘Ana susue ngge! Rena malolole! Leo mo au doo basa ia ena. Basa saa fo amaꞌ enan, naa ra o ho enam boe. ");
INSERT INTO row_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Te oras ia hita musi feta-dꞌote tamahoꞌo, huu odꞌim ia. Feꞌesaꞌan, onaꞌ ana mate ena, te ia naa nasodꞌa baliꞌ ena. Ana mopo ena, te ia naa hambu baliꞌ e ena.’” ");
INSERT INTO row_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Basa ma, Yesus dui seluꞌ nekendandaaꞌ esa fee neu ana dedꞌenu nara nae, “Hambu atahori mamasuꞌiꞌ esa fee ue-tataos neu atahori mana dadꞌi eni malangga mana tao ues na. Te dodꞌoo ma malangga rena mbasiꞌ nae, malangga mana tao-ues naa nae podꞌe-padꞌi naꞌarurunggiꞌ e. ");
INSERT INTO row_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Dadꞌi ana noꞌe malangga mana tao-ues, de nafadꞌe nae, ‘Ho ia, taꞌo bee? Au rena nggo akaꞌ podꞌe-padꞌiꞌ au hata-heto ngga. De ia naa muu suraꞌ ue-tataom ra fo au paresaꞌ dei. Te basa na, au ae nda pake nggo sa ena.’ ");
INSERT INTO row_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Rena taꞌo naa ma, malangga mana tao ues duꞌa neu-nema nae, ‘Au soe ena! Oras ia au ae tao saa? Tatati rae o, au nda bꞌeꞌi sa. Dadꞌi mana hule-huleꞌ o, au mae. ");
INSERT INTO row_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Mete ma au nda tao ues sia ia sa, au musi sangga dalaꞌ, fo ona bee na atahori laen ra nau simbo au.’ ");
INSERT INTO row_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Huu naa, ana noꞌe nala basa atahori mana rahuta malangga a. De natane atahori ka esan nae, ‘Wae! Muhuta baꞌu saa neu malangga ngga?’ ");
INSERT INTO row_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Atahori naa nataa nae, ‘Au uhuta mina saitun liter rifon haa.’ Boe ma malangga mana tao ues a nae, ‘Tebꞌe. Ho susura hutam sie. Ia naa sika hendi leo, basa na endoꞌ fo suraꞌ lai-lai susura huta feuꞌ fai mae, ho muhuta liter rifon ruaꞌ a.’ ");
INSERT INTO row_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Basa de neu natane atahori karuan nae, “Muhuta malangga ngga baꞌu saa fai?’ Ma nataa nae, ‘Au uhuta are karon rifon esa.’ De malangga mana tao ues a denu e nae, ‘Sika hendi susura hutaꞌ mbaraaꞌ naa leo, fo suraꞌ feuꞌ mae, karon natun faluꞌ a.’ ");
INSERT INTO row_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ana tao taꞌo naa, losa malanggan bubꞌuluꞌ tataon. Te malangga musi nataa nae malangga mana tao-ues deꞌulakaꞌ ia memaꞌ masiꞌet. Naa! Au ufadꞌe nekendandaaꞌ ia fo mihine mae, mete ma naꞌasasamaꞌ no atahori mamahereꞌ, atahori nda mamahereꞌ sa memaꞌ masiꞌet lenaꞌ sia rau-inggu ra taladꞌa nara aleꞌ ia. ");
INSERT INTO row_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Dadꞌi hei duꞌa sobꞌa. Onaꞌ mae atahori raefafoꞌ tao manggenggeoꞌ rendiꞌ hata-heto nara, te malole lenaꞌ pake hata-heto raefafo mara fo tulu-fali atahori. No taꞌo naa, hei o hambu toronooꞌ hetar. Mae hata-hetoꞌ naa basa, te dei fo Lamatuaꞌ sadꞌia hela mamanaꞌ fee nggi sia sorga. ");
INSERT INTO row_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Mete ma atahori tao dꞌala anaꞌ ra tungga ndoon, na, ana o tao dꞌala monaeꞌ ra tungga ndoon boe. Te mete ma atahori pode-padꞌi ro dꞌala anaꞌ ra, na, ana pode-padꞌi no dalaꞌ monae ra boe. ");
INSERT INTO row_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Mete ma atahori nda ramahere hei lole-lau hata-heto biasa no dala-dala anak ra sia raefafoꞌ ia, onaꞌ bee fo Lamatuaꞌ namahere nggi sia dꞌala monaeꞌ fai? ");
INSERT INTO row_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Mete ma hei nda bisa mete-seꞌu atahori laen hata-heton sa, na, seka mbarani fee hei hata-hetoꞌ? ");
INSERT INTO row_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Mana dedꞌenuꞌ esa nda bisa rena malangga rua sa. Huu dei fo ralan mburu-oeꞌ no esa, ma sue esa. Ana naꞌatataaꞌ no esa, te nda tao afiꞌ neu esa ka sa. Hei onaꞌ naa boe, atahori nda bisa sue Lamatualain ma sue dꞌoiꞌ sa. ");
INSERT INTO row_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Leleꞌ naa, hambu atahori Farisi hira tungga rena Yesus oꞌolan naa. De ara raneneut E, huu ara dꞌale dꞌoiꞌ. ");
INSERT INTO row_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Te Yesus nataa nae, “Wei! Mae hei tao mimeu ao mara sia atahori mata nara, te Lamatualain nahine rala mara deꞌulakaꞌ. Hambu dalaꞌ naeꞌ fo atahori soꞌu rananaru, tao-tao te Lamatualain nae naa ra dꞌala deꞌulakaꞌ, de melumudꞌu se. ");
INSERT INTO row_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Losa Yohanis Mana Saraniꞌ neneman, hita atahori Yahudi tasodꞌa tungga baꞌi Musa no Lamatuaꞌ mana ola-ola nara hohoro-lalanen. Te ia naa Lamatuaꞌ Hara-Lii malolen nenedꞌui-bꞌenggaꞌ sia bee-bꞌee ena. Atahori hetar sangga dalaꞌ rakandooꞌ a fo masodꞌa nara tungga Lamatuaꞌ hihii-nanaun. ");
INSERT INTO row_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Mae lalai no raefafoꞌ sambulalo o, Lamatualain hohoro-lalanen mbei o nda mopo sa boe, titiꞌ-koma sa boe o nda mopo sa! ");
INSERT INTO row_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Atahori mana mahelaꞌ no saon, basa ma sao seluꞌ no inaꞌ laen, ana hohongge. Boe ma seka sao no inaꞌ fo mana mahelaꞌ no saon, ana o hohongge boe.” ");
INSERT INTO row_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesus dui seluꞌ nekendandaaꞌ sa nae, “Hambu atahori mamasuꞌiꞌ sa. Ana hiiꞌ a pake bꞌua-baꞌu meulauꞌ nenetaoꞌ mia teme meulauꞌ. Hatuꞌ-rerelon naa-ninu maladꞌa-maladꞌaꞌ, ma maꞌaheeꞌ a sosoa aon. ");
INSERT INTO row_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Sia naa hambu atahori mana tudꞌa-loloeꞌ sa, Naran Lasarus. Aon sofeꞌ no bisu maꞌafoꞌ. Fai-fai esa na nonoo nara ro e nisiꞌ atahori mamasuꞌiꞌ a umen lesu matan. ");
INSERT INTO row_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ana hii nae naa atahori mamasuꞌiꞌ a nanaa sisa nara, te ana nda hambu saa sa boe. Akaꞌ busa ra reu dadꞌalo bisu nara nanan. ");
INSERT INTO row_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Basa ma, Lasarus mate, de Lamatualain ate nara mia sorga rema haꞌi rendi e, de raeꞌendo e sia baꞌi Abraham bobꞌoan. Nda dooꞌ sa ma atahori mamasuꞌiꞌ a o mate boe, de atahori ra raꞌoi e. ");
INSERT INTO row_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ana nda sorga neu sa, te ana masoꞌ naraka neu, naꞌabꞌue no atahori mana mateꞌ hetar. Sia naa ana hambu huku-dokiꞌ ma dꞌoidosoꞌ nakandooꞌ a. Lao esa, ana botiꞌ matan ma nita Lasarus endoꞌ namahoꞌo sia baꞌi Abraham bobꞌoan. ");
INSERT INTO row_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Boe ma ana randu nahereꞌ nae, ‘Baꞌi Abraham, e! Kasian au dei! Denu Lasarus dꞌombo lima uꞌun neu oe, fo sadꞌi nema tao naꞌadꞌoe maa tonggo ngga o malole. Huu au doidꞌoso aeꞌ a mate ena sia naraka ia!’ ");
INSERT INTO row_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Te Abraham nataa nae, ‘Naa! Ana ngge! Musunedꞌa malolole dꞌei. Faiꞌ naa, leleꞌ musodꞌa sia raefafoꞌ, hambu mala basa maloleꞌ ra. Te Lasarus hambu akaꞌ sususaꞌ a. Dadꞌi ia naa Lamatuaꞌ fee ne namahoꞌo sia ia, ma doidꞌoso muu naa. ");
INSERT INTO row_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Lelenan fai, mia ho e nisiꞌ ia nema, Lamatuaꞌ tadꞌa hita no ndola romaꞌ, de atahori sia ia nda bisa naa reu sa, ma atahori sia naa nda bisa ia rema sa.’ ");
INSERT INTO row_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Boe ma atahori mamasuꞌiꞌ a noꞌe nae, ‘Mete ma taꞌo naa, na, baꞌiꞌ tulun denu Lasarus neu sia ama ngga umen dꞌei. ");
INSERT INTO row_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Huu sia naa feꞌe hela odꞌi tou nggara atahori lima. Denu Lasarus neu nafadꞌe se, fo ara baliꞌ risiꞌ Lamatua, naa fo ara mate, na, ara afi risiꞌ mamana doidꞌosoꞌ ia.’ ");
INSERT INTO row_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Te Abraham nataa nae, ‘Lamatualain fee se baꞌi Musa ma mana ola-olaꞌ ra susura nara ena. Odꞌi mara bisa baca rasafafali se, fo ara rahine Lamatuaꞌ hihii-nanaun.’ ");
INSERT INTO row_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Te atahori mamasuꞌiꞌ a nareresi nae, ‘Baꞌi Abraham, e! Naa nda feꞌe dai sa, huu ara nda tao-afiꞌ neu Lamatuaꞌ Hara-Liin sa! Musi hambu atahori mates ra dea rema mia rates fo reu rafadꞌe se, fo ara feꞌe rae rena ena, fo ramahere ma doaꞌ.’ ");
INSERT INTO row_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Te Abraham nataa nae, ‘Mete ma ara nda nau rena baꞌi Musa no Lamatuaꞌ mana ola-ola nara dedꞌea-oꞌolan nara sa, na, mae atahori mana mateꞌ ra dea rema mia rates fo reu olaꞌ ro se o, ara nda rena sa boe.’” ");
INSERT INTO row_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesus nafadꞌe ana dedꞌenu nara nae, “Lao hetar atahori tudꞌa salaꞌ, huu atahori laen tatao-nonoꞌi nara. Te atahori mana pode-edoꞌ, ara soe rala seli. ");
INSERT INTO row_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mete ma atahori pode-edꞌoꞌ losa tao anadikiꞌ sa tudꞌa salaꞌ, dei fo Lamatualain fee huku-dokiꞌ beran seli neu e. Malole lenaꞌ paꞌa fatu monaeꞌ sa neu bꞌoton, fo nggari e tasi rala neu. ");
INSERT INTO row_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","De minea ao mara malolole fo ama afiꞌ tao atahori tudꞌa salaꞌ! Te mete ma toronom tao salaꞌ, na, ai e. Mete ma ana dꞌoaꞌ, de nema noꞌe ambon, na, sudꞌi musunedꞌa salan fai. ");
INSERT INTO row_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Mete ma toronoom esa tao salaꞌ lao hitu sia faiꞌ sa rala, boe ma ana dꞌoaꞌ, ma nema lao hitu fo noꞌe ambon, na, ho musi liliiꞌ hendi salan lao hitu.” ");
INSERT INTO row_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Faiꞌ sa, Yesus ana dedꞌenu nara rema randaa ro E de roꞌe rae, “Ama Meser! Hai nemehere mara nda mahereꞌ sa. De tulun tao nehere hai nemehere, mara dei.” ");
INSERT INTO row_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Boe ma Yesus nataa nae, “Mete ma hei mimihere neu Lamatualain koasan, mae anak o, hei parenda hau huu ineꞌ ia mae, ‘Neneleaꞌ fo lali tasi muu!’ Dei fo hau huu ineꞌ naa o tungga hei parendam neuꞌ ena boe.” ");
INSERT INTO row_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Basa ma Yesus olaꞌ fai nae, “Haꞌi conto. Hambu ate mana tatati rae sia osi, ma nanea bibꞌi lombo sia mooꞌ a. Basa ues ra ma, ate a baliꞌ ume neu. Neꞌo malanggan nda olaꞌ no e nae, ‘Uma fo ruꞌa nggita taa taꞌabꞌue leo!’ ");
INSERT INTO row_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Hokoꞌ! Tungga matetun, malangga a denu e nae, ‘Muu lole-lau mei a fee au dei. Basaꞌ fo, muu mua-minu sia deaꞌ.’ ");
INSERT INTO row_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Mete ma ate a tao tungga malanggan hihii-nanaun, neꞌo hei mae malangga noꞌe makasi mbali e, do? Hokoꞌ! ");
INSERT INTO row_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Hei onaꞌ naa boe. Mete ma hei ue-tao basa saa fo Lamatuaꞌ parendaꞌ a ena, na, hei olaꞌ mae, ‘Hai atahori dedꞌenuꞌ a, hai nda sangga kokoaꞌ sa. Hai milalaoꞌ a hai ue-tataos mara.’” ");
INSERT INTO row_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Leleꞌ Yesus se lao risiꞌ Yerusalem, ara losa propensi Galilea no propensi Samaria rae toor na. ");
INSERT INTO row_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Leleꞌ ara rae risiꞌ kamboꞌ esa sia naa, hambu atahori kusta sanahulu rema rae randaa ro Yesus. Ara rambariiꞌ miaꞌ a dodꞌooꞌ. ");
INSERT INTO row_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Boe ma nggasi randaa rae, “Yesus! Lamatuaꞌ! Kasian hai dei!” ");
INSERT INTO row_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Leleꞌ Yesus nita se, ma, Ana denu nae, “Mii mitudꞌu ao mara reu malangga agama dei, fo ara paresaꞌ rae, Hei kusta ma hai ena, do feꞌe hokoꞌ.” Rena taꞌo naa ma, ara lao. Te sia dꞌala taladꞌan, aiboiꞌ ma, basa se hai reuꞌ ena. ");
INSERT INTO row_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ara lao rakandoo no nemehoot. Te hambu esa baliꞌ nisiꞌ Yesus. Ana nggasi nae, “Koa-kio Lamatuaꞌ! Huu au hai ena!” ");
INSERT INTO row_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Boe ma ana sendeꞌ lululanggan de noꞌe makasi naeꞌ mbali Yesus. (Tao-tao te eni nda atahori Yahudi sa. Eni atahori Samaria mana radꞌedꞌea rakandooꞌ a ro atahori Yahudi ra.) ");
INSERT INTO row_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Boe ma Yesus natane atahori mana tungga E nae, “Taꞌo bee, e? Faꞌra Au uꞌuhahaiꞌ atahori kusta sanahulu, to? Atahori sio sia bee? ");
INSERT INTO row_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Taꞌo bee de akaꞌ atahori feaꞌ ia baliꞌ nema fo noꞌe makasi neu Lamatualain, ma soꞌu koa-kioꞌ neu E?” ");
INSERT INTO row_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Boe ma Ana nafadꞌe atahori naa nae, “Ho malole ena huu mumuhere tebꞌe-tebꞌeꞌ neu Au. De fela fo baliꞌ mo masoi-masodꞌaꞌ. ");
INSERT INTO row_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","21","Faiꞌ sa, atahori Farisi hira rema ratane Yesus rae, “Ama Meser! Mufadꞌe dꞌei! Fai hiraꞌ fo Lamatualain nalalao parendan?” Ma Yesus nataa nae, “Taꞌo ia! Afiꞌ duꞌa mae Lamatuaꞌ nalalao parendan nendiꞌ tanda mataꞌ-mataꞌ sia raefafoꞌ ia fo atahori bisa rita no mata nara. Atahori nda hambu bꞌuti fo rae, ‘Mete ia dꞌei! Huu Lamatualain nalalao parendan sia ia!’, do ‘Hambu sia naa!’ Hokoꞌ! Te Ana nalalao parendan sia taladꞌa mara sia atahori ra rala nara.” ");
INSERT INTO row_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Basa ma Yesus nafadꞌe ana dedꞌenu nara nae, “Nda doo sa te Au, Atahori Matetuꞌ ia, nda uꞌubꞌue o hei sa ena. Dei fo sia fai sususaꞌ ra, hei hii mae doo bee fo mita Au baliꞌ uma. Te Au nda feꞌe uma sa. ");
INSERT INTO row_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Mete ma atahori rema rafadꞌe nggi rae, ‘Kristus sia ia!’ do, ‘Kristus sia naa!’ na, ama afiꞌ miꞌibebꞌenggeꞌ ao mara fo sangga mii-ima, huu oꞌola nara, peko-lelekoꞌ. ");
INSERT INTO row_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Te mete ma Atahori Matetuꞌ a baliꞌ nema, tatandan manggareloꞌ ena, onaꞌ ndelas naronda fo tao lalai dadꞌi manggareloꞌ mia suuꞌ seri nisi suuꞌ seri neu. ");
INSERT INTO row_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Te huu Ana musi lemba-dꞌoi doidꞌosoꞌ mataꞌ-mataꞌ dei. Ma atahori leleꞌ ia, nda nau rena ma nda nau simbo E sa. ");
INSERT INTO row_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Te dei fo leleꞌ Ana nae baliꞌ nema, atahori ra rasodꞌa roꞌ a deꞌulakaꞌ onaꞌ biasa, onaꞌ Noh lelen. ");
INSERT INTO row_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Leleꞌ naa, ara raa-rinu, tao feta-dote kakabꞌiꞌ, losa faiꞌ leleꞌ Noh masoꞌ nisiꞌ ofan rala. Te atahori naa ra o nda nau rena sa boe. Basa ma, aiboiꞌ neuꞌ ena te, oe monaeꞌ nandali nema de tao nalutu basa se. ");
INSERT INTO row_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Naa o onaꞌ atahori mana rasodꞌa deꞌulakaꞌ sia Lot lelen. Leleꞌ naa, ara raa-rinu, raseo-rahasaꞌ, tao osi-lutu, rafefela ume, ma rasodꞌa deꞌulakaꞌ onaꞌ biasa. ");
INSERT INTO row_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Te atahori ra nda nau rena sa. Basa ma, fefetuꞌ naa, leleꞌ Lot nela hela kota Sodꞌom, aiboiꞌ ma udꞌa ai-baleran onda nema mia lalai de lalangge hendi basa se. ");
INSERT INTO row_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Dadꞌi hei musi besa-bꞌesa, e! Afi losa leleꞌ Atahori Matetuꞌ a nae baliꞌ nema, te atahori ra rasodꞌa biasa-biasaꞌ a. Huu aiboiꞌ ma Ana losa boe. ");
INSERT INTO row_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Faiꞌ naa, atahori mana sia ume nembeleon, na, sudꞌi ume rala mii fo lolelau fai. Atahori mana tao ues sia osi, afi baliꞌ ume mii haꞌi sudꞌiꞌ a saa mara fai. ");
INSERT INTO row_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Misinedꞌa saa mana dadꞌi neu Lot saon mia lele uluꞌ a. Ana mate, huu nasanedꞌa sudꞌiꞌ a saa nara sia ume. ");
INSERT INTO row_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Atahori nda mana nau tungga Au sa huu sueꞌ a aon, dei fo masodꞌan parsumaꞌ a. Te atahori mana nau tungga Au losa ana fee masodꞌan huu sue Au, dei fo ana hambu masoi-masodꞌaꞌ, ma nasodꞌa nakandoo no Lamatualain. ");
INSERT INTO row_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Au ufadꞌe mema! Leleꞌ Atahori Matetuꞌ a baliꞌ nema, mete ma hambu atahori rua sungguꞌ sia mamanaꞌ sa, aiboiꞌ ma Lamatuaꞌ soꞌu nendi esa, ma lao hela esa. ");
INSERT INTO row_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Mete ma hambu inaꞌ rua mbau are raꞌabꞌue, dei fo Lamatuaꞌ soꞌu nendi esa, te lao hela esa. ");
INSERT INTO row_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Mete ma hambu atahori rua tao ues raꞌabꞌue sia osi, dei fo Lamatuaꞌ soꞌu nendi esa, ma lao hela esa.” ");
INSERT INTO row_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Yesus ana dedꞌenu nara rena rala taꞌo naa, ma ratane E rae, “Ama Meser! Dei fo basa naa ra dadꞌi sia bee?” Ma Yesus nggari dedꞌeat nae, ‘Taꞌo ia. Mete ma hei mita mbui kaaꞌ ra ratambele raꞌabꞌue risiꞌ bee, hei bubꞌulu naa dadꞌi tanda oi, ara raa mana mburuꞌ sia mamanaꞌ naa ena.” Naa sosoa maꞌafunin nae, dei fo leleꞌ Kristus baliꞌ nema, tatanda nara manggareloꞌ ena, mete ma atahori baca rahine. ");
INSERT INTO row_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Lao esa, Yesus nanori ana dedꞌenu nara nendiꞌ nekendandaaꞌ, fo ara hule-oꞌe, nda namaꞌetu sa, no nda male-maꞌa sa. Ara musi ramahere rakandoo neu Lamatuaꞌ. ");
INSERT INTO row_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Dꞌudꞌuin taꞌo ia: “Sia kota esa hambu mana nggero-furiꞌ sa nda mana tao-afiꞌ neu Lamatualain sa. Ana nda tao-afiꞌ neu esa sa boe. ");
INSERT INTO row_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Sia naa o hambu ina falu sa akaꞌ neu noꞌe mana nggero-furiꞌ a nae, ‘Amaꞌ mana nggero-furiꞌ! Muꞌetuꞌ dedꞌea ngga no matetuꞌ, o!’ ");
INSERT INTO row_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Fefeun mana nggero-furiꞌ a nda tao-afiꞌ neu ina falu a sa. Te dodꞌoo ma ana bengge rena e ena. Boe ma ana dudꞌuꞌa nae, ‘Memaꞌ au ia nda tao-afiꞌ neu Lamatualain sa, lelenan fai neu atahori. ");
INSERT INTO row_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Te ina falu ia tao langga ngga nambeta ena. Huu naa, malole lenaꞌ au uꞌetuꞌ dedꞌeat na no ndoos. Hokoꞌ na, ana akaꞌ nema tao naꞌabꞌebꞌenggeꞌ au nakandondooꞌ a.’ ");
INSERT INTO row_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Naa, hei dꞌua sobꞌa mana nggero-furiꞌ dꞌeulakaꞌ naa oꞌolan. ");
INSERT INTO row_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Mete ma dodꞌoo ma ana tulu-fali ina falu a, na, Lamatualain o nau tulu-fali atahori mana hule-oꞌe hatuꞌ-rerelon fo noꞌe tulu-faliꞌ sia E. Te Lamatuaꞌ nda mana eꞌo-lali fai a sa. ");
INSERT INTO row_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ana naꞌetuꞌ dedꞌeat nara lai-lai, Naa de Au ae utane taꞌo ia: mete ma Au, atahori Tebꞌe-Tebꞌeꞌ ia, baliꞌ uma ena, neꞌo Au feꞌe hambu undaa o atahori mamahereꞌ sia raefafoꞌ do hokoꞌ?” ");
INSERT INTO row_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesus dui seluꞌ nekendandaaꞌ sa, soꞌal atahori mana hii nananaru aon ma naloe-nadꞌae atahori laen ra. Ana dui nae, ");
INSERT INTO row_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Hambu amaꞌ rua reu hule-oꞌe sia Ume Hule-oꞌe Huuꞌ a. Esa, atahori mia partei agama Farisi; esa fai, mana edꞌa bea. Atahori Yahudi ra rae atahori Farisi ra, atahori meumareꞌ. Ma ara rae mana edꞌa bea ra atahori nda maloleꞌ ra sa. ");
INSERT INTO row_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Losa ume hule-oꞌeꞌ ma, atahori Farisi a nambariiꞌ mesaꞌ ne ma hule-oꞌe nae, ‘Makasi Lamatuaꞌ, huu au ia, atahori maloleꞌ. Au nda deꞌulakaꞌ onaꞌ atahori laen ra sa. Au nda dadꞌi naꞌo sa. Au nda mana usuu-usetiꞌ sa. Au nda mana hohonggeꞌ sa. Makasi, Lamatuaꞌ, huu au o nda deꞌulakaꞌ onaꞌ mana edꞌa bea ia sa. ");
INSERT INTO row_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Au manggate puasa nggarei sa na lao rua. Ma au endi babꞌanggiꞌ esa mia sanahulu mia basa saa fo au hambuꞌ a.’ Atahori Farisi naa hule-oꞌe taꞌo naa. ");
INSERT INTO row_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Te mana edꞌa bea a nambariiꞌ naꞌadꞌodꞌooꞌ sia dea-deaꞌ. Ana nda nambarani botiꞌ matan fo mete ataꞌ neu sa. Ana hule-oꞌe no beꞌutee langgan ma rala mambalulutuꞌ nae, O, Lamatualain. Kasian au, atahori mana masala-singgoꞌ ia! Fee ambon neu au dꞌei!’ ");
INSERT INTO row_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Naa, leleꞌ atahori karuaꞌ naa ra lao baliꞌ ume reu, mae bee ka maloleꞌ no Lamatualain? Atahori Farisi mana koaoꞌ a do, atahori mana edꞌa bea? Tantu Ana simbo no maloleꞌ mana edꞌa bea, mana naloe-nadꞌae ralan. Ma Ana nda tao-afiꞌ neu atahori Farisi a sa. Huu Lamatualain naꞌatutudꞌaꞌ atahori mana koaoꞌ ma nananaru atahori mana naloe-nadꞌae ralan.” ");
INSERT INTO row_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Lao esa, atahori ra oꞌo ro anadikiꞌ ra reu Yesus, fo Ana ndae liman neu se ma olaꞌ fee se papala-babꞌanggiꞌ. Yesus ana dedꞌenu nara rita taꞌo naa, ma ara ai atahori naa ra. ");
INSERT INTO row_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","17","Te Yesus simbo nala anadikiꞌ mana rema risiꞌ E. Basa ma ana ai ana dedꞌenun nara nae, “Hela fo anadikiꞌ naa ra rema risiꞌ Au. Ama afiꞌ ai se. Misinedꞌa malolole! Huu atahori mana nae dadꞌi Lamatualain atahorin, ana musi namahena neuꞌ a Lamatualain, ona anadikiꞌ namahena neu ina-ama nara.” ");
INSERT INTO row_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Lao esa, hambu atahori Yahudi ra malanggan esa neu natane Yesus nae, “Ama Meser nenefee hadꞌa-hormat! Au musi tao taꞌo bee fo uhine ae bisa masoꞌ sorga uu fo usodꞌa ukundoo o Lamatualain?” ");
INSERT INTO row_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Boe ma Yesus nataa nae, “Taꞌo bee de moꞌe mae, ‘Mana nenefee hadꞌa-hormat’? Akaꞌ esaꞌ a nenefee hadꞌa-hormat, naeni Lamatualain. ");
INSERT INTO row_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Naa! Ho bubꞌuluꞌ ena, to, Lamatualain hohoro-lalanen mia fai dalahulun, oi: Afiꞌ hohongge; afiꞌ tati-mbau misa atahori; Afiꞌ miminaꞌo; Afi dadꞌi sakasii peko-lelekoꞌ; ma fee hadꞌa-hormat neu ina-ama mara.” ");
INSERT INTO row_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Atahori naa nataa nae, “Tebꞌe, Amaꞌ! Au tungga hohoro-lalaneꞌ naa ra eniꞌ a aꞌana ngga.” ");
INSERT INTO row_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Rena taꞌo naa ma, Yesus nae, “Malole! Te feꞌe hela dalaꞌ esa fai. Naeni, baliꞌ fo muu seo hendi basa hata-heto mara. Basa naa, muu babꞌanggi dꞌoiꞌ naa ra reu atahori mana tudꞌa-loloeꞌ ra. Dei fo baliꞌ uma fo tungga Au leo. Te dei fo Lamatualain bala-bꞌae fee nggo hata-hetoꞌ sia sorga.” ");
INSERT INTO row_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Atahori naa rena taꞌo naa, ma ralan susa, huu suꞌin naen seli. ");
INSERT INTO row_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesus mete ana laoꞌ no rala nambalulutu, ma Ana nafadꞌe ana dedꞌenun nara nae, “Atahori mamasuꞌiꞌ memaꞌ susa seli masoꞌ sorga neu. ");
INSERT INTO row_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Hita taꞌasasamaꞌ no dalaꞌ laen fai. Memaꞌ bꞌanda onta monaeꞌ a nda bisa lalaet rala neu tungga sosoot ndolan sa. Onaꞌ naa boe atahori mana namahenaꞌ a hata-heton, te nda namahena neu Lamatuaꞌ sa, ana o nda bisa masoꞌ sorga rala neu sa boe. ");
INSERT INTO row_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Atahori mana rena Yesus olaꞌ taꞌo naa, ratane E rae, “Mete ma memaꞌ atahori mamasuꞌiꞌ susa taꞌo naa, na, atahori mataꞌ bee mana hambu masoi-masodꞌaꞌ?” ");
INSERT INTO row_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesus nataa nae, “Soaꞌ neu atahori, memaꞌ dalaꞌ hetar nda bisa dadꞌi sa. Te soaꞌ neu Lamatualain basaꞌ e bisa dadꞌi.” ");
INSERT INTO row_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Boe ma Petrus olaꞌ nae, “Amaꞌ! Hai lao hela basa hata-heto mara ena, fo tungga Amaꞌ. Te dei fo hai hambu saa?” ");
INSERT INTO row_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesus nataa nae, “Petrus! Rena malolole! Atahori mana lao hela umen, saon, odi-aꞌa nara, ama-ina nara, do ana nara, huu nalalao Lamatualain ue-tataos nara, ");
INSERT INTO row_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","dei fo ana simbo baliꞌ naeꞌ lenaꞌ sia raefafoꞌ ia. Ma mete ma raefafoꞌ ia nateꞌe ena, ana o hambu nasodꞌa nakandoo no Lamatualain.” ");
INSERT INTO row_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesus no ana dedꞌenun atahori kasanahulu rua ra fo neu olaꞌ mesaꞌ ne no se nae, “Basa hei bubꞌuluꞌ mae, ia naa hita lao tisiꞌ kota Yerusalem ena. Losa naa, basa dalaꞌ fo Lamatuaꞌ mana ola-ola nara suraꞌ feꞌesaꞌan soꞌal Atahori Matetuꞌ naa, dei fo dadꞌi onaꞌ saa mana nenesuraꞌ helaꞌ ena. ");
INSERT INTO row_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Dei fo ara fee Au neu atahori deaꞌ mana nda ramahere neu Lamatualain sa. Boe ma ara raneneut Au, raꞌamamaeꞌ Au no mataꞌ-mataꞌ, puras miru neu Au, ");
INSERT INTO row_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","filo Au, basa ma tao risa Au. Te fai katelun, ma Au usodꞌa baliꞌ.” ");
INSERT INTO row_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Rena Yesus olaꞌ taꞌo naa ma, ana dedꞌenu nara bingun, huu ara nda feꞌe rahine dedꞌea-oꞌolaꞌ naa sosoan sa. ");
INSERT INTO row_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Leleꞌ Yesus se rae losa kota Yeriko, hambu atahori pokeꞌ sa endoꞌ hule-huleꞌ sia dalaꞌ suun. ");
INSERT INTO row_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Leleꞌ ana rena atahori hetar tungga naa ma, ana natane nae, “We! Saa sia ia?” ");
INSERT INTO row_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Boe ma atahori rafadꞌe rae, “Yesus, mia Nasaret, laoꞌ tungga ia.” ");
INSERT INTO row_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Atahori pokeꞌ naa rena nala ma, ana nggasi nahereꞌ nae, “Yesus! Mane Daud tititi-nonosin, e! Sue au dꞌei!” ");
INSERT INTO row_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Atahori mana laoꞌ sia Yesus matan ai e rae nee-nee. Te ana boe nggasi nahereꞌ nae, “Mane Daud tititi-nonosin, e! Kasian au dꞌei!” ");
INSERT INTO row_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Leleꞌ Yesus rena taꞌo naa, ma Ana nambariiꞌ. Ma Ana denu atahori reu rala atahori pokeꞌ a. Losa matan ma, Yesus natane e nae, ");
INSERT INTO row_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Ho nau Au tao saa fee nggo?” Ana nataa nae, “Amaꞌ! Au oꞌe fo fee au bisa mete ita.” ");
INSERT INTO row_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesus nataa e nae, “Maloleꞌ boe. Huu mumuhere mae, Au bisa tao uhaiꞌ nggo, de ia naa ho bisa mita ena.” ");
INSERT INTO row_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Aibꞌoiꞌ ma, atahori pokeꞌ a nita neuꞌ ena. Boe ma ana tungga Yesus no koa-kio Lamatualain. Basa atahori mana rita taꞌo naa, o koa-kio neu Lamatuaꞌ boe. ");
INSERT INTO row_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Basa ma Yesus se masoꞌ tungga kota Yeriko, fo rae lao rakandoo. ");
INSERT INTO row_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Sia naa hambu malangga mana edꞌa bea esa fee mana parenda Roma, naran Sakeos. Sakeos ia, atahori mamasuꞌiꞌ. ");
INSERT INTO row_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Leleꞌ ana rena Yesus se rae tungga naa, ma ana nae nita Yesus, te ana nda nita no maloleꞌ sa, huu Sakeos bobokuꞌ ma atahori hetar heo rala Yesus. ");
INSERT INTO row_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Naa de ana nela-nelaꞌ naꞌahuluꞌ, de hene nisiꞌ hau huuꞌ sa sia dalaꞌ suun, fo Yesus nae tunggaꞌ naa. ");
INSERT INTO row_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Losa hau huuꞌ a raeꞌ, ma Yesus mete ataꞌ. Ma Ana noꞌe Sakeos nae, “Sakeos! Uma, onda leo! Lai-lai, te faiꞌ ia au ae numban sia ume ma.” ");
INSERT INTO row_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakeos heran bali-baliꞌ. Boe ma ana onda lai-lai, de no Yesus nisiꞌ ume na. Ralan namahoꞌo nae mate. ");
INSERT INTO row_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Te atahori hetar ramue rae, “Cih! Sakeos ia, atahori nda maloleꞌ sa! Basa atahori rahine, naa boe! Taꞌo bee de Yesus neu numban sia umen?!” ");
INSERT INTO row_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Losa umen ma, Sakeos nambariiꞌ sia Yesus matan de, ola nae, “Ama Meser! Eniꞌ a mia faiꞌ ia au bꞌanggi basa hata-heto ngga neu rua, fo fee babꞌanggiꞌ sa neu atahori mana toꞌa-taaꞌ ra. Mete ma au parna edꞌa bea ulenaꞌ, au bae baliꞌ neu se dedꞌesin lao haa.” ");
INSERT INTO row_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesus nataa nae, “Malole. Faiꞌ ia Lamatualain fee masoi-masodꞌaꞌ neu nggo mo basa bobꞌonggi mara, huu mumuhere neu Lamatuaꞌ onaꞌ baꞌi Abraham. ");
INSERT INTO row_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Te Lamatualain denu Au dadꞌi Atahori Matetuꞌ a sia raefafoꞌ. Au uma fo sangga atahori mana dinggoꞌ mia Lamatuaꞌ dꞌalan ena, fo fee se masoi-masodꞌaꞌ.” ");
INSERT INTO row_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Leleꞌ naa, hambu atahori hetar reu rena Yesus. Ara rae dꞌeka-dꞌeka kota Yerusalem ena. Ara rae neꞌo Ana nae nalalao Lamatualain parendan sia naa, onaꞌ maneꞌ sa. Boe ma Yesus dui se nekendandaaꞌ esa fai, ");
INSERT INTO row_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","nae, “Hambu atahori moko-monaen esa. Ana nae lao nusa dꞌeaꞌ neu, fo ara soꞌu e dadꞌi maneꞌ. Basa fo ana feꞌe baliꞌ fo dadꞌi maneꞌ sia nusan. ");
INSERT INTO row_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Leleꞌ ana nahehere nae lao, ana noꞌe nala atahori mana tao ues nara atahori sanahulu, de fee se esa na doi liloꞌ esa. Ana parenda nae, ‘Hei pake dꞌoiꞌ ia dadꞌi neu pokoꞌ. Te dei fo au baliꞌ, na ama mifadꞌe au hahambu mara baꞌu saa.’ Basa ma ana lao boe. ");
INSERT INTO row_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Te rauinggu nara mburu-oeꞌ ro e. De ara haitua dedꞌenuꞌ ra naa reu fo rafadꞌe rae, ‘Hai nda nau atahori ia toꞌu parendaꞌ neu hai sa.’ ");
INSERT INTO row_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Mae onaꞌ naa o, ara soꞌu e sia naa. Basa de ana baliꞌ. Losa umen boe, ana noꞌe nala mana tao ues nara atahori sanahuluꞌ ra, de natane se nae, ‘Hei hambu bꞌunaꞌ baꞌu saa mia doi liloꞌ fo au fee neu nggiꞌ a? ");
INSERT INTO row_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Atahori mana tao-ues kaesan nafadꞌe nae, ‘Ama maneꞌ! Au hambu bꞌunaꞌ lao sanahulu mia doi pokoꞌ fo au simboꞌ a!’ ");
INSERT INTO row_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Boe ma maneꞌ a nafadꞌe e nae, ‘Malole! Ho ia, atahori mana tao ues maloleꞌ. Huu au bisa umuhere nggo sia dꞌala anadikiꞌ ra, de ia naa au soꞌu nggo fo parenda kota sanahulu.’ ");
INSERT INTO row_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Boe ma, atahori mana tao ues karuan, nafadꞌe nae, ‘Ama maneꞌ! Au hambu bꞌunaꞌ doi liloꞌ lima mia doi pokoꞌ fo au simboꞌ a.’ ");
INSERT INTO row_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Boe ma, maneꞌ a koa e nae, ‘Maloleꞌ! Mete ma taꞌo naa, au soꞌu nggo fo parenda kota lima. ");
INSERT INTO row_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Te atahori mana tao ues katelun nendi baliꞌ doi liloꞌ a. Ma nafadꞌe nae, ‘Ia malangga dꞌoin! Au mboti e, de funi e malolole fo afiꞌ mopo e. ");
INSERT INTO row_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Au tao taꞌo naa, huu au umutau. Au bubꞌuluꞌ amaꞌ ia atahori mana laka-eseꞌ. Huu amaꞌ hii haꞌi saa fo amaꞌ nda enan sa, ma etu mala saa fo amaꞌ nda sela sa.’ ");
INSERT INTO row_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Maneꞌ a rena nala ma, ana bua e nae, ‘Ho ia, nda mana nenoriꞌ sa! Oꞌolam huku-doki baliꞌ ao ma. Ho mae au ia atahori mana laka-eseꞌ, fo haꞌi saa fo nda au ena ngga sa, ma haꞌi saa fo au nda sela sa. ");
INSERT INTO row_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Mete ma taꞌo naa, na, taꞌo bee de ho nda muu mbedꞌaꞌ dꞌoiꞌ ia sia bank sa? Naa fo leleꞌ au baliꞌ, au hambu bꞌunan. Itaꞌ mbeiꞌ a o malole.’ ");
INSERT INTO row_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Boe ma, maneꞌ a denu atahori laen sia naa ra, nae ‘Haꞌi mala dꞌoin, fo fee neu atahori mana tao ues mana hambu bꞌunaꞌ lao sanahulu faaꞌ ra.’ ");
INSERT INTO row_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Te ara nda nau sa rae, ‘Amaꞌ! Atahori naa hambu dai ena. Taꞌo bee de mae haꞌi mia atahori mana hambu mbeiꞌ a, fo fee seluꞌ neu e fai?’ ");
INSERT INTO row_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Te maneꞌ a nataa nae, ‘Dꞌuꞌa malolole! Huu atahori mana nahine tao mataꞌ neu saa fo atahori ramahere neu e, dei fo ana hambu seluꞌ. Te atahori mana mbera tao mataꞌ, dei fo ara haꞌi rala basa enan. ");
INSERT INTO row_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Naa! Ia naa. Mii humu mala musu nggara mana nda hii au dadꞌi maneꞌ sia ia sa. Mendi se ia rema. Basa fo tao misa basa se sia au mata ngga. Mii leo!’” ");
INSERT INTO row_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesus dui basa ma, ara lao rakandoo risiꞌ Yerusalem. Yesus laoꞌ mia mataꞌ. ");
INSERT INTO row_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Leleꞌ rae deka-deka ro kamboꞌ rua, naeni Betfage no Betania, mana deka no lete Saitun suun, ma Ana denu ana dedꞌenun rua laoꞌ raꞌahuluꞌ. ");
INSERT INTO row_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ana denu se nae, “Ruꞌa nggi mii sia kamboꞌ mana sia mataꞌ naa. Dei fo ama mita bꞌanda keledei anaꞌ sa nenepaꞌaꞌ sia naa. Atahori nda feꞌe sae rita e sa. Ama sefi papaꞌan fo lea mendi e ia nema. ");
INSERT INTO row_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Te mete ma hambu ruma ratane, rae ‘Saa de hei sefi keledei a talin?’ na, mifadꞌe se mae, ‘Hai Lamatuam nae pake.” ");
INSERT INTO row_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Basa de, ruꞌa se reu, ma rita keledei anaꞌ, onaꞌ Yesus oꞌolan. ");
INSERT INTO row_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Leleꞌ ara sefi keledei anaꞌ a talin, ma tenuꞌenaꞌ a natane se nae, “Saa de hei sefi bꞌanda ia?” ");
INSERT INTO row_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Boe ma rataa rae, “Hai Lamatuam nae pake.” ");
INSERT INTO row_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Tenuꞌenaꞌ a naꞌaheiꞌ, de ruꞌa se lea rendi keledei anaꞌ a nisiꞌ Yesus. Ara ndae lafe nara naeꞌ neu keledei a nggarasan, de ara oꞌo Yesus ata neu. ");
INSERT INTO row_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Atahori hetar o haꞌi lafe no salendang nara, de bela neu dalaꞌ, fo soru Yesus onaꞌ simbo atahori moko-monaen ra. ");
INSERT INTO row_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Leleꞌ Ana nae onda mia lete Saitun, ma atahori hetar ro Ana dꞌedeꞌnun nara, eki-randu koa-kio Lamatualain, huu basa koasa manadadꞌiꞌ fo sira ritaꞌ ra. ");
INSERT INTO row_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ara eki-randu rae, “Ia Eni, Maneꞌ fo Lamatualain denu nemaꞌ a! Lamatualain fee papala-babꞌanggiꞌ neu E! Ia naa, atahori bisa dꞌame ro Lamatuaꞌ sia sorga ena. Koa-kio Lamatuaꞌ mana endoꞌ parenda sia lalai nanarun seli.” ");
INSERT INTO row_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Te hambu atahori Farisi hira sia atahori naa ra taladꞌan nara. Ara rafadꞌe Yesus rae, “Ama Meser! Ai se fo ara afiꞌ randu taꞌo naa, huu ia seli tebꞌe ena ma!” ");
INSERT INTO row_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Te Yesus nataa nae, “Hee! Au ufadꞌe memaꞌ! Mete ma atahori ia ra raꞌateme bafa nara, dei fo fatu ra koa-kio Lamatuaꞌ!” ");
INSERT INTO row_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Leleꞌ ara dꞌeka-dꞌeka rae Yerusalem rala reu, Yesus nita kota naa, ma Ana nggae, ");
INSERT INTO row_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","nae, “Aduu, Atahori Yerusalem, e! Au nau fo faiꞌ ia hei simbo mole-dꞌameꞌ fo Au endiꞌ ia. Te huu hei nda tao-afiꞌ neu Lamatuaꞌ sa, de ia naa babꞌanggo ena. Mole-dꞌameꞌ naa naꞌadꞌodꞌooꞌ mia nggi ena. ");
INSERT INTO row_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Dei fo musu mara mbori rae ndule kota a tembok na, basa ma ara rala reti ratati ro nggi. ");
INSERT INTO row_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ara ndefaꞌ hendi hei kota ma naꞌabebelaꞌ neu rae a, ma reti tao risa nggi mo basa ana mara. Ara nda hela fatu esa nambariiꞌ sa boe, huu Lamatuaꞌ nema ena fo nae fee masoi-masodꞌaꞌ neu nggi, te hei nda mihine E sa!” ");
INSERT INTO row_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Basa ma Yesus masoꞌ nisiꞌ Ume Hule-oꞌe Huuꞌ a rala. Sia ume sodꞌan, atahori tao dadꞌi pasar fo seo bꞌanda tutunu-hohotuꞌ. Yesus nita ma Ana oi hendi se mia naa. ");
INSERT INTO row_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ana bꞌua se nae, “Lamatualain mana ola-ola nara suraꞌ memaꞌ rae, ‘Au ufefela Ume ia, fo basa atahori rema hule-oꞌe sia ia.’ Te hei tao e dadꞌi rambok ra mamana neꞌebꞌuen.” ");
INSERT INTO row_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Basa ma, tunggaꞌ fai Yesus nisiꞌ Ume Hule-oꞌe Huuꞌ a fo nanori sia naa. Te malangga agama Yahudi ra malangga nara, ma meser agama ro lasi-lasi adat Yahudi ra sangga dalaꞌ rae tao risa E ");
INSERT INTO row_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Te ara nda hambu dalaꞌ sa, huu atahori hetar ramahoꞌo rena Yesus oꞌolan. ");
INSERT INTO row_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Lao esa, Yesus neu nisiꞌ Ume Hule-oꞌe Huuꞌ a, de nanori Lamatuaꞌ Hara-lii Malolen sia ume sodꞌan. Ma malangga agama Yahudi ra malangga nara, meser agama ra, ro lasi-lasi adat ra rema raselu-bale ro E. ");
INSERT INTO row_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ara ratane rae, “Seka fee hak neu Nggo de afis tao kaco mia ia? Mufadꞌe sobꞌa dei!” ");
INSERT INTO row_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Boe ma Yesus nataa nae, “Au o ae utane dalaꞌ esa boe, dei fo Au utaa nggi. ");
INSERT INTO row_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Taꞌo ia: hei mihine Yohanis Mana Saraniꞌ a, to? Seka fee e koasa fo sarani atahori? Lamatualain do, atahori?” ");
INSERT INTO row_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Boe ma esa-esaꞌ fee dudꞌuꞌat ma ola-olaꞌ rae, “Awee! Daꞌi hita ena ma. Mete ma tae, ‘Lamatualain mana denu’, dei fo Ana nataa nae, ‘Mete ma taꞌo naa, na taꞌo bee de hei nda mimihere Yohanis sa?’ ");
INSERT INTO row_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Te hita o nda bisa tae, ‘atahori denu’ sa, te hokoꞌ naa atahori haꞌi fatu fo mbia risa nggita. Huu ara ramahere rae, Yohanis naa, Lamatualain mana ola-olan.” ");
INSERT INTO row_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Boe ma rataa Yesus rae, “Hai nda mihine sa.” ");
INSERT INTO row_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ma Yesus nafadꞌe nae, “Mete ma taꞌo naa, na Au o nda nau ufadꞌe seka mana denu Au sa boe.” ");
INSERT INTO row_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Basa ma, Yesus dui atahori hetar naa ra, nekendandaaꞌ esa fai nae, “Hambu atahori esa mana sela osi anggor. Ana fee osin neu atahori ue-tao e, fo basa na ara banggi buna-bꞌoan. Boe ma ana lali nusa deaꞌ neu de leo dooꞌ sia naa. ");
INSERT INTO row_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Losa fula-fai etu anggor bꞌoan ma tenu osiꞌ a denu atahori mana tao ues na esa neu simbo babꞌanggin mia mana tao osi naa ra. Te mana tao osi ra popoko atahori mana tao ues naa, de oi e baliꞌ no lima rouꞌ. ");
INSERT INTO row_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Basa ma, tenu osiꞌ a haitua seluꞌ atahori mana tao ues na esa neu fai. Te mana tao osi ra popoko ma tao raꞌamamaeꞌ e. Basa ma ara oi baliꞌ e no lima rouꞌ. ");
INSERT INTO row_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Boe ma tenu osiꞌ a haitua seluꞌ atahori mana tao ues katelun neu fai, te ara popoko raꞌahinaꞌ e ma nggari e dea neu. ");
INSERT INTO row_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Boe ma tenu osiꞌ a dudꞌuꞌa nae, ‘Au musi tao taꞌo bee fai? Malole lenaꞌ au haitua ana susue ngga. Neꞌo ara simbo e ma fee hadꞌa-hormat neu e.’ De ana haitua ana bꞌonggin neu. ");
INSERT INTO row_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Te leleꞌ mana tao osi ra rita e, ma ara ola-olaꞌ rae, ‘Woi, mete dꞌei! Te lasiꞌ a haitua ana bꞌonggin nema ena. Ana mana simbo basa aman hata-heto nara. Dadꞌi ima fo ata tao tisa e leo.’ Hela fo ata soa osi a. ");
INSERT INTO row_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Leleꞌ anaꞌ losa ma, ara lea dudꞌui e dea neu mia osi a, basa de ara tao risa e. Naa! Au ae utane, taꞌo ia: hei duꞌa na tenu osiꞌ a nae tao mana tao osi ra taꞌo bee? ");
INSERT INTO row_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Tungga Au, na ana nema tao nisa basa se, basa ma, ana fee atahori laen ra tao osi a.” Leleꞌ atahori naa ra rena Yesus olaꞌ taꞌo naa ma, ara rataa rae, “Mete ma bisa na, Lamatualain afiꞌ huku-doki hai taꞌo naa!” ");
INSERT INTO row_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Basa ma Yesus mete naꞌateteeꞌ se, de natane nae, “Mete ma nda dadꞌi fee huku-dokiꞌ taꞌo naa sa, na, saa de Lamatuaꞌ mana ola-ola nara suraꞌ taꞌo ia: ‘Hambu fatu esa fo tukan ra nggari hendi ena, te ia naa dadꞌi rii-ineꞌ a fatu netehun?’ ");
INSERT INTO row_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Atahori mana naꞌatunu sia fatu naa, tantu nambalutu, huu hambu huku-dokiꞌ. Ma mete ma fatu a tudꞌa dai atahori, ana o nambalutu eto-etoꞌ boe, huu hambu huku-dokiꞌ a.” ");
INSERT INTO row_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Leleꞌ meser agama ra ro malangga agama ra malanggan rena dudꞌuit naa, ara bubꞌuluꞌ rae, Yesus olaꞌ nekendandaaꞌ naa neu se. Sira onaꞌ mana tao osi ra. De ara ramanasa rala seli. Boe ma ara sangga dalaꞌ fo rae humu E. Te ara ramahia atahori hetar mana hii rena Yesus nenorin. De ara lao hela E neu naa. ");
INSERT INTO row_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Basa naa ma, Yesus musu nara maku-maꞌu E. Ara sangga mana makuꞌ mana bisa tao aon nara onaꞌ atahori maloleꞌ, fo reu raꞌahehengge Yesus. Ara raeꞌ a do bee fo Yesus olaꞌ labꞌan mana parenda Roma ra, fo reu kalak neu hofernor, naa fo ara denu atahori reu humu Yesus. ");
INSERT INTO row_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Boe ma ara haitua mana maku-maꞌuꞌ ra reu raselu-bale ro Yesus rae, Ama Meser! Hai bubꞌuluꞌ Amaꞌ rala ndoos. Amaꞌ nda mana peko-lelekoꞌ sa, ma nda mana mete mataꞌ sa. Amaꞌ munoriꞌ a Lamatualain Dedꞌea-oꞌolan no matetuꞌ ");
INSERT INTO row_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","De ia naa hai mae mitane dalaꞌ esa: tungga hai agama Yahudi hohoro-lalanen, na, hai bꞌae bea fee mana parenda Roma ra mane monaen a, do hokoꞌ?” ");
INSERT INTO row_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Te Yesus nahine dudꞌuꞌa deꞌulaka nara rae raꞌahehengge E. De nataa nae, ");
INSERT INTO row_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Mitudꞌu doi fulaꞌ sa dꞌei, fo Au mete sobꞌa e.” Boe ma ara ratudꞌu dꞌoiꞌ neu E. Boe ma natane nae, “Ia, seka nggambar na? ma ia, seka naran?” Ara rata rae, “Naa mane monae Keser a.” ");
INSERT INTO row_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Boe ma Yesus nae, “Mete ma taꞌo naa, na, fee mana parenda saa fo mana parenda ra hak na. Ma fee Lamatualain saa fo Lamatualain hak na.” ");
INSERT INTO row_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Rena taꞌo naa, ma ara heran bali-baliꞌ, huu ara nda raꞌahehengge rala E sa, sia atahori hetar matan. De nda rahara sa ena. ");
INSERT INTO row_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Basa naa ma, hambu atahori hira mia partei agama Saduki rema fo rae raꞌahehengge Yesus. Atahori Saduki ra ranori rae, atahori mates ra nda rasodꞌa baliꞌ sia fai mateteꞌen sa. Ara rema raselu-bale ro Yesus rae, ");
INSERT INTO row_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Ama Meser! Baꞌi Musa suraꞌ hela fee nema hita hohoro-lalaneꞌ nae: mete ma hambu touꞌ mate, te nda ma anaꞌ sa, na, odꞌin musi sao nala ina falun, fo ana bisa fee tititi-nonosiꞌ neu aꞌan mana mateꞌ a ena. ");
INSERT INTO row_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Memaꞌ feꞌesaꞌan baꞌi Musa nanori taꞌo naa. Te ia naa hai mae mitane, taꞌo ia: hambu touꞌ hitu odꞌi-aꞌa, de uluꞌ a sao, ma mate hendi e te anaꞌ nese. ");
INSERT INTO row_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Basa de odꞌin mana tungga e sao nala ina falu a. Nda doo sa ma, mate hendi touꞌ a fai, te nda ma anaꞌ sa boe. ");
INSERT INTO row_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Onaꞌ naa boe, ana katelun. Ana sao nala ina falu a, basa ma mate te nda ma anaꞌ sa. Onaꞌ naa nakandooꞌ a losa ana muriꞌ a mate. ");
INSERT INTO row_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Boe ma ina falu naa o mate boe. ");
INSERT INTO row_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Naa! Ia naa hai mae mitane taꞌo ia: inaꞌ naa saon touꞌ hitu ena. De mete ma losa fai mateteꞌen, ma Lamatuaꞌ tao nasodꞌa baliꞌ atahori mana mateꞌ ra, na, inaꞌ naa dadꞌi neu touꞌ bee saon?” ");
INSERT INTO row_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Boe ma Yesus nataa nae, “Atahori masaoꞌ siaꞌ a raefafoꞌ ia. ");
INSERT INTO row_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","36","Te sia sorga atahori nda sao sa ena. Ma sia naa ara nda mate sa boe. Ara onaꞌ Lamatualain ate nara sia sorga. Huu leleꞌ Lamatualain tao nasodꞌa baliꞌ atahori mates ra, Ana pili nala se fo dadꞌi Eni ana nara ena ");
INSERT INTO row_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Baꞌi Musa susuran dui soꞌal hau huu anaꞌ mana nenelalanggeꞌ te nda kadꞌe sa. Mia dudꞌuit naa hita tahine tae, atahori mates ra bisa rasodꞌa baliꞌ boe. Sia naa Lamatualain nafadꞌe baꞌi Musa nae, ‘Au ia, bei-baꞌi mara Lamatualain na. Naeni baꞌi Abraham, baꞌi Isak ma baꞌi Yakob. Basa se beꞌutee rakandoo neu Au losa ia nema.’ ");
INSERT INTO row_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Tao-tao te baꞌiꞌ naa ra mate eniꞌ a fai dꞌalahulun ena. Te huu Lamatualain nae Eni feꞌe dadꞌi sira Lamatuan, naa de hita tahine tae ara feꞌe masodꞌaꞌ. De mae atahori mate ena o, ara rasodꞌa baliꞌ. Te akaꞌ atahori masodꞌa fo beꞌutee neu Lamatualain, nda atahori mates ra sa, to!” ");
INSERT INTO row_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Rena Yesus nataa taꞌo naa ma, hambu meser agama sa olaꞌ nae, “Ama Meser netaa na, seli tebꞌe.” ");
INSERT INTO row_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Eniꞌ a mia leleꞌ naa ma, nda hambu atahori esa nambarani natane Yesus sa ena, huu nda hambu esa naꞌahehengge nala E sa boe. ");
INSERT INTO row_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Basa ma, Yesus feꞌe nanori atahori naa ra sia Ume Hule-oꞌe Huuꞌ a. Ma Ana natane nasafafali se nae, “Tungga dudꞌuꞌa mara na, taꞌo bee? Meser agama ra ranori rae, Kristus naa, Atahori fo Lamatualain dudꞌu eniꞌ a lele-uluꞌ a. Tungga se, Eni dadꞌi akaꞌ mane Daud tititi-nonosin. Te huu naa nda feꞌe dai sa. ");
INSERT INTO row_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Huu lele-uluꞌ a mane Daud suraꞌ hela sia susura sosodꞌa koa-kio ra nae, ‘Lamatualain nafadꞌe neu Lamatua ngga nae, “Uma endoꞌ sia Au bobꞌoa ona ngga, sia mamana nenefee hadꞌa-hormat. ");
INSERT INTO row_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Huu dei fo Au tao musu Mara, losa ara beꞌutee mbali Nggo.’” ");
INSERT INTO row_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Naa! Mia susura naa, hita tahine tae, mane Daud noꞌe Kristus nae, ‘Lamatuaꞌ’. Naa sosoan nae, mete ma atahori rae Kristus, akaꞌ mane Daud tititi-nonosin, na nda feꞌe dai sa! Huu Eni o dadꞌi mane Daud Lamatua na boe!” ");
INSERT INTO row_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Leleꞌ basa atahori ramanene neu Yesus, ma Ana olaꞌ no ana dedꞌenu nara nae, ");
INSERT INTO row_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Hei musi besa-bꞌesa mo meser agama ra. Huu ara hiiꞌ a lao-laoꞌ ro badꞌu naru masaroromboꞌ, fo reu randaa ro atahori hetar, naa fo atahori rita se, na rae, ‘We! Sira naa, atahori moko-monaen ra, o!’ Ara hiiꞌ a sangga mamana nenefee hadꞌa-hormat sia ume hule-oꞌeꞌ ra, sia fefetas, ma sia mamanaꞌ fo atahori hiiꞌ a raꞌabꞌue. ");
INSERT INTO row_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Te besa-bꞌesa, huu ara akaꞌ peko-lelekoꞌ ina falu ra fo haꞌi rala ume nara. Te sia atahori hetar matan, ara babꞌata deꞌulaka nara no rambariiꞌ hule-oꞌe doon seli. Ara hiiꞌ a fo atahori rae sira, atahori meumareꞌ re. Te Lamatualain nahine sala nara, de dei fo Ana fee huku-dokiꞌ beran seli neu se.” ");
INSERT INTO row_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Leleꞌ Yesus nanori mia Ume Hule-oꞌe Huuꞌ a, Ana nita atahori mamasuꞌiꞌ ra rema mbedꞌaꞌ kolete sia peti kolete a. ");
INSERT INTO row_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ana o nita ina falu mana tudꞌa-loloꞌe esa nema hule-oꞌe boe. Ana mbedꞌaꞌ dꞌoiꞌ sen rua sia peti naa boe. Dꞌoiꞌ a felin mbeiꞌ lenaꞌ basa e. ");
INSERT INTO row_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Basa ma Yesus olaꞌ neu ana dedꞌenu nara nae, “Rena malolole! Ina falu mana tudꞌa-lololeꞌ a, ana mbedꞌaꞌ a dꞌoiꞌ sen ruaꞌ a, te huu ana fee nalenaꞌ basa atahori ra. ");
INSERT INTO row_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Atahori laen naa ra rendi kolete mia sira doi lena nara. Te ina falu ia fee nabꞌasaꞌ dꞌoin ena. Tao-tao te, eni taiꞌ a dꞌoiꞌ naa ra.” ");
INSERT INTO row_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Leleꞌ naa, Yesus ana dedꞌenu nara olaꞌ koa-boꞌu Ume Hule-oꞌe Huuꞌ a rae, “Amaꞌ!! Mita Ume ia meulaun dꞌei! Ara tao e rendiꞌ fatu tatatiꞌ monaeꞌ ra, ma ara dꞌama se tetuꞌ. Boe ma hambu atahori fee sudꞌiꞌ a saa mafelit fo paroon neu Ume a!” Te Yesus nataa nae, ");
INSERT INTO row_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ume ia memaꞌ meulauꞌ. Te nda dooꞌ sa te, atahori ra poko ralutu hendi basa fatu ra losa raꞌabꞌebꞌelaꞌ ro rae a.” ");
INSERT INTO row_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Basa ma, Yesus ana dedꞌenu nara ratane rae, “Ama Meser! Saa fo Amaꞌ olaꞌ faꞌ ra, fai hiraꞌ fo dadꞌi? Mete ma fain deka ena, na tatanda nara onaꞌ bee?” ");
INSERT INTO row_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Boe ma Yesus nataa nae, “Sadꞌi minea malolole fo afiꞌ neneꞌedꞌi nalaꞌ. Huu dei fo hambu atahori mataꞌ-mataꞌ rema toꞌo tenda nara rae, “Au ia, Kristus.’ Hambu ruma fai rae, ‘Fai mateteꞌen deka-deka nema ena!’ Te afiꞌ mimihere! ");
INSERT INTO row_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Mete ma hei rena haraꞌ oi, atahori ra ramue-raanggi ma ratati sia bee-bꞌee, na, afiꞌ mimitau. Memaꞌ, basa naa ra musi dadꞌi raꞌahuluꞌ. Te fai mateteꞌen nda feꞌe losa sa. ");
INSERT INTO row_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Dei fo leo esa natati no leo laen. Nusaꞌ esa natati no nusaꞌ laen. ");
INSERT INTO row_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Rae o nanggonggaꞌ monaen seli. Sia bee-bꞌee fai ndoe-laꞌas manaseliꞌ, hedꞌis deꞌulaka ndule-feo mamanaꞌ. Dei fo atahori o rita dalaꞌ mana tao atahori ao nara tenggou, boe ma manadadꞌiꞌ manaseliꞌ sia lalai. ");
INSERT INTO row_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Dꞌala mana dadꞌiꞌ ia ra nda feꞌe basa sa, te atahori ra humu nggi, ma poko-paru nggi, huu mimihere Au. Basaꞌ fo ara rendi dedꞌea mara nisiꞌ ume hule-oꞌeꞌ ra, ma tao nggi bꞌui rala mii. Ara o rendi nggi misiꞌ maneꞌ ra no mana parenda laen ra boe. Basa ia ra, huu hei tungga Au. ");
INSERT INTO row_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Te hei musi pake naa dadꞌi kakaꞌeꞌ fo mifadꞌe Hara-lii Malole ngga neu se. ");
INSERT INTO row_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Dadꞌi sudꞌi boe dudꞌuꞌa miꞌihuluꞌ mae, hei mae misilaꞌe ao mara taꞌo bee. ");
INSERT INTO row_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Te dei fo Au fee dedꞌea-oꞌolaꞌ nandaa neu nggi fo misilaꞌe ao mara. No taꞌo naa, hei musu mara nda ritaꞌ rae olaꞌ saa sa ena boe. ");
INSERT INTO row_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","17","Dei fo atahori hetar mburu-oeꞌ ro nggi, huu hei tungga Au. Hambu mia bobꞌonggi mara, onaꞌ ina-ama mara, odꞌi-aꞌa mara, toronoo mara, ma nonoo mara. Dei fo hambu ruma mia sira e sangga dalaꞌ fo seo nggi, losa tao risa hei ruma. ");
INSERT INTO row_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Te ama afiꞌ mimitau, huu Lamatuaꞌ nda liliiꞌ nggi sa. Langga fulu mara esa o nda ou sa boe, mete ma Ana nda nau sa. ");
INSERT INTO row_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Mete ma hei miꞌitataaꞌ mikindondooꞌ a, tantu Lamatualain fee nggi masoi-masodꞌaꞌ.” ");
INSERT INTO row_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Yesus olaꞌ seluꞌ nae, “Mete ma hei mita musu ra heo rala kota Yerusalem ena, hei bubꞌuluꞌ mae, ana nae nambalutu ena. ");
INSERT INTO row_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Hei atahori sia propensi Yudea mita taꞌo naa, na fela mela misiꞌ leteꞌ a leo. Atahori mana sia kota o fela mela leo. Ma atahori mana sia kamboꞌ sudꞌi misiꞌ kota mii fai. ");
INSERT INTO row_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Huu Lamatuaꞌ haitua fai sususaꞌ ra fo huku-dꞌoki atahori nda mana nau rena E sa. Basa naa ra dadꞌi tungga onaꞌ saa fo Lamatualain mana ola-ola nara suraꞌ memaꞌ eniꞌ a lele-uluꞌ a ");
INSERT INTO row_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kasian neu ina mairuꞌ ma ina mana nasusu ana nara. Leleꞌ naa, basa raefafoꞌ ia hambu susa-sonaꞌ, ma basa atahori Yahudi ra hambu doidꞌosoꞌ beran seli, huu Lamatualain namanasa se. ");
INSERT INTO row_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Dei fo musu ra tao risa ruma, ma futu ruma, fo dadꞌi ate sia bee-bꞌee sia raefafoꞌ ia. Atahori fuiꞌ mana nda rahine Lamatualain sa, rema tabꞌu-roroo ranggenggeo kota Yerusalem, ma parenda kota isin, losa sira fula-fain basa.” ");
INSERT INTO row_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Basa naa ma Yesus nafadꞌe soꞌal Eni neneman, nae “Dei fo leleꞌ Atahori Matetuꞌ a nae baliꞌ nema, hambu tatandaꞌ sia relo a, fulan, ma sia nduuꞌ ra. Sia raefafoꞌ ia o hambu tatandaꞌ, naeni tasiꞌ namue, no sanggu-anin manaseliꞌ, riree ra sou ata rema monaen seli. Basa ia ra tao fee atahori ramatau ma titindindi, de nda ritaꞌ rae taꞌo bee saa ena boe. ");
INSERT INTO row_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Basa koasa mana sia lalai ra ranggenggo leli. Rita onaꞌ naa ma, atahori ramatau rala seli, huu raefafoꞌ nae soe ena! ");
INSERT INTO row_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Basa naa, dei fo atahori rita Au, ‘Atahori Matetuꞌ a, onda uma o leleꞌ’. Au onda o koasa, ma basa manaseli ngga. ");
INSERT INTO row_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Mete ma basa tatandaꞌ ia ra dadꞌi, na, ama botiꞌ langga mara leo, huu Lamatuaꞌ fain losa fo fee nggi masoi-masodꞌaꞌ.” ");
INSERT INTO row_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Basa naa ma, Yesus nafadꞌe nekendandaaꞌ esa nae, “Hei mete miꞌibꞌebꞌesa hau-hau huuꞌ ra. ");
INSERT INTO row_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Mete ma roo nara huni-huni ena, na dadꞌi bukti oi, fai matobꞌiꞌ deka nema ena. ");
INSERT INTO row_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Onaꞌ naa boe no fai sususaꞌ ra boe. Mete ma ara sou rema, na dadꞌi tanda oi, Lamatualain parendan deka nema ena. ");
INSERT INTO row_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Au ufadꞌe memaꞌ! Mia basa atahori feꞌe masodꞌa ia ra, dei fo ruma nda feꞌe mate sa, te fai sususaꞌ ra losa ena, ");
INSERT INTO row_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Onaꞌ mae lalai no raefafoꞌ sambulalo boe o, Au Dedꞌea-oꞌola ngga naꞌatataaꞌ nakandoo.” ");
INSERT INTO row_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Yesus olaꞌ seluꞌ fai nae, “Mihehere, huu aiboiꞌ te Au uma! Afiꞌ losa hei nda duꞌa no matetuꞌ sa, ma misodꞌa moꞌ a minu mafu, ma mbute-mue sanggaꞌ a lole-ladꞌaꞌ ra. Afiꞌ losa hei nda mihine tatandaꞌ ra sa, huu hei mbute-mue moꞌ a ue-tataos laen ra. ");
INSERT INTO row_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Afiꞌ duꞌa mae nda dai hei sa. Te aiboiꞌ ma Au uma. Ma mete ma Au baliꞌ uma, nda hambu atahori esa bisa keke nala aon sia Au mata ngga sa boe. ");
INSERT INTO row_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","De minea mikindooꞌ a. Hule-oꞌe mikindooꞌ a, naa fo bisa miꞌitataaꞌ sia basa sususaꞌ naa ra. No taꞌo naa, mete ma Au baliꞌ uma, hei nda mae mimbiriiꞌ sia Atahori Matetuꞌ a matan sa.” ");
INSERT INTO row_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Tungga fai na Yesus neu nanori sia Ume Hule-Oꞌe Huuꞌ a. Te mete ma tetembaꞌ, na, Ana kalua hela Yerusalem fo neu sungguꞌ sia kamboꞌ sia lete Saitun. ");
INSERT INTO row_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Feꞌe fefetu anaꞌ te, atahoriꞌ hetar rema raꞌabꞌue, fo rena E nanori sia Ume Hule-oꞌe Huuꞌ a. ");
INSERT INTO row_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Leleꞌ naa, sangga deka no atahori Yahudi ra fai malolen, naeni fefeta Roti nda mana tao bibꞌit sa. Sia fai maloleꞌ naa, ara o mbau-hala bibꞌi lombo fo feta fai Paska. Ara tao taꞌo naa huu rasanedꞌa fai maꞌahulun, leleꞌ bei-baꞌi nara lao hela Masir. ");
INSERT INTO row_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Leleꞌ naa, malangga agama Yahudi ra malangga nara, ro meser agama ra sangga dalaꞌ fo rae tao risa Yesus. Te ramatau duꞌa atahori hetar ramue-raanggi, huu ara hiiꞌ a rena E. ");
INSERT INTO row_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Mia Yesus ana dedꞌenun kasanahulu ruaꞌ ra, esa naran Yudas Iskariot. Leleꞌ malangga agama Yahudi ra malangga nara sangga dalaꞌ rae tao risa Yesus, nitu ra malanggan masoꞌ nisiꞌ Yudas ralan. ");
INSERT INTO row_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Basa ma, ana neu sangga malangga agama ra malangga nara ma malangga mana nanea Ume Hule-oꞌe Huuꞌ a. Ana nae maꞌiraꞌ fo seo hendi Yesus neu se. ");
INSERT INTO row_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Leleꞌ malangga ra rena Yudas olaꞌ taꞌo naa, ma, ara ramahoꞌo rala seli. Ara helu rae, “Neu! Mete ma mae seo Yesus neu hai, tantu hai bꞌae.” ");
INSERT INTO row_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yudas o naꞌaheiꞌ boe. Boe ma ana sangga kakaꞌeꞌ fo seo nee-nee hendi Yesus neu se, naa fo atahori hetar afiꞌ rahine. ");
INSERT INTO row_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Atahori Yahudi ra fai malolen losa, de ara rae mbau bibꞌi lombo anaꞌ fo tao fefeta Paska. ");
INSERT INTO row_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Basa ma, Yesus denu Petrus no Yohanis nae, “Ruꞌa nggi miꞌihuluꞌ, fo sadꞌia hela nanaat fee nggita fo taa fefeta Paska taꞌabꞌue.” ");
INSERT INTO row_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Boe ma ruꞌa se ratane rae, “Amaꞌ! Hai musi mii sadꞌia mei sia bee?” ");
INSERT INTO row_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ana nataa nae, “Mete ma hei kota Yerusalem rala mii, dei fo hei mindaa mo touꞌ esa nasaa nggusi oe. Ama tungga e losa ume. ");
INSERT INTO row_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Mifadꞌe tenu umeꞌ a sia naa mae, ‘Hai Ama Meser ma noꞌe kama fo nae tao fefeta Paska no ana dedꞌenu nara sia rala. Sia, do?’ ");
INSERT INTO row_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Dei fo tenu umeꞌ a dudꞌu fee nggi kama loaꞌ esa sia tadꞌaꞌ ataꞌ. Ana sadꞌia nala kama naa ena. Helaꞌ a ruꞌa nggi mii fo sadꞌia nanaat neu naa.” ");
INSERT INTO row_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Basa de ruꞌa se reu. Boe ma rita basa saa fo Yesus nafadꞌe memaꞌ neu se ena. De ruꞌa se sadꞌia nanaat Paska mia naa. ");
INSERT INTO row_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Leleꞌ basaꞌ e nenesadꞌiaꞌ ena ma, Yesus se losa. Ana endoꞌ sia mei a, ma dedꞌenu nara o endoꞌ boe, de raa fefetas. ");
INSERT INTO row_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Boe ma Yesus nafadꞌe se nae, “Au aeꞌ a doo bee fo endoꞌ ua fefeta Paska ia o nggi, naꞌahulu mia Au dꞌoidoso ngga. ");
INSERT INTO row_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Misinedꞌa ia malolole. Huu basa ia, na, Au nda endoꞌ ua seluꞌ nanaat fefeta Paska o nggi sa ena. Dei fo atahori rahine relo-relo rae, Amaꞌ toꞌu parendaꞌ, dei fo Au feꞌe ua seluꞌ fefetas fai.” ");
INSERT INTO row_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Basa ma Ana botiꞌ nggalas neneꞌisi oe anggor sia rala. Boe ma Ana noꞌe makasi neu Lamatualain, ma loo nggalas neu se. Ana olaꞌ nae, “Simbo nggalas ia, fo esa-esaꞌ minu. ");
INSERT INTO row_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Misinedꞌa, e! Eniꞌ mia tetembaꞌ ia, Au nda inu oe anggor sa ena. Dei fo atahori rahine relo-relo rae, Amaꞌ toꞌu parendaꞌ, dei fo Au feꞌe inu seluꞌ na.” ");
INSERT INTO row_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Boe ma Ana toꞌu nala roti bꞌueꞌ sa, ma noꞌe makasi neu Lamatualain. Basa ma, Ana bibꞌibꞌi roti a, de loo neu se. Ana oi, “Roti ia, Au ao sisi ngga fo Au fee neu basa nggi. Mete ma mia roti ia, na, hei musi misinedꞌa Au.” ");
INSERT INTO row_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Leleꞌ ara raa basa, ma Ana haꞌi nala nggalas neneisiꞌ no oe anggor. Ma Ana olaꞌ nae, “Anggor ia, Au raa ngga, mana nenemboꞌaꞌ fo fee nggi masoi-masodꞌaꞌ. Lamatualain pake raaꞌ ia fo tao hehelu-fufuli feuꞌ no nggi. ");
INSERT INTO row_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Te besa-bꞌesa, hambu atahori sa oras ia endoꞌ naa naꞌabꞌue sia mei ia, dei fo ana seo hendi Au. ");
INSERT INTO row_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Memaꞌ Au, Atahori Matetuꞌ a, musi mate tungga Lamatualain hihii-nanaun. Te atahori mana seo hendi Au a, besa-bꞌesa! Huu dei fo ana lemba-dꞌoi sosoen!” ");
INSERT INTO row_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Yesus ana dedꞌenu nara rena rala ma esa natane esa rae, “Te seka mana nae tao deꞌulakaꞌ neu E taꞌo naa e?” ");
INSERT INTO row_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Boe ma Yesus ana dedꞌenu nara mulai rareresi rae, seka mia sira e monaeꞌ lenaꞌ. ");
INSERT INTO row_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Te Yesus ai se nae, “Sia nusa-nusaꞌ nda mana rahine Lamatuaꞌ sa, maneꞌ ra tuni-ndeni rauinggu nara ma parenda se raꞌalelenaꞌ. Tao-tao te ara nau fo rauinggu nara roꞌe se rae, “Amaꞌ mana tulun rauinggu.’ ");
INSERT INTO row_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Te ama afiꞌ taꞌo naa. Seka nau dadꞌi atahori monaeꞌ, masodꞌan musi tebꞌe-tebꞌeꞌ dadꞌi onaꞌ atahori anak e, fo tulu-fali basa atahori. Ma seka nau dadꞌi malangga musi tulu-fali onaꞌ atahori dedꞌenuꞌ ra. ");
INSERT INTO row_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ama duꞌa sobꞌa, atahori monaen a, seka? Atahori mana endoꞌ sia mei a, do, mana lolelau mei a? Neꞌo ko atahori mana endoꞌ a, eni atahori monaen, to? Te, Au ia nda tao ao ngga taꞌo naa sa. Au uma fo tulu-fali nggi. ");
INSERT INTO row_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Hei ia ra miꞌibꞌue mo Au mikindooꞌ a leleꞌ Au hambu doidꞌoso. ");
INSERT INTO row_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Au Ama ngga soꞌu nala Au fo toꞌu parendaꞌ sia Nusaꞌ namon. Dadꞌi ia na Au soꞌu nggi boe, ");
INSERT INTO row_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Naa fo hei o endoꞌ mia mei esa mo Au sia sorga. Au o fee nggi koasa fo ama toꞌu parendaꞌ sia leo ka sanahulu ruaꞌ mana sia Israꞌel ra boe.” ");
INSERT INTO row_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Basa ma Yesus nafadꞌe Petrus nae, “Petrus, Petrus. Nitu ra malanggan nae tao saranggaa basa hei mo Au, onaꞌ atahori tai isiꞌ fo here hendi are taaꞌ mia isiꞌ ");
INSERT INTO row_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Te Au hule-oꞌe fee nggo, Petrus, fo mumuhere mukundoo neu Au. Dei fo mete ma ho baliꞌ uma misiꞌ Au, na, musi tao manggate toronoo mara rala nara.” ");
INSERT INTO row_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Boe ma Petrus nataa nae, “Hokoꞌ, Amaꞌ! Au nda lao hela Amaꞌ mbei sa boe. Au sadꞌia masoꞌ bui rala uu o Amaꞌ. Mae mate uꞌubꞌue o Amaꞌ o, malole boe.” ");
INSERT INTO row_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Te Yesus nataa nae, “Petrus! Rena malolole. Tetembaꞌ ia, manu ra nda feꞌe koꞌokee sa, te ho mufunii Au lao telu ena mae, ho nda muhine Au sa.” ");
INSERT INTO row_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Basa ma, Yesus olaꞌ no se nae, “Faiꞌ naa, leleꞌ Au denu nggi mii mifadꞌe Hara-lii Malole ngga sia bee-bꞌee, Au ufadꞌe Ae ama afiꞌ mendi dꞌoiꞌ, kapiꞌ, boe ma lao-peiꞌ. Leleꞌ naa, hei toꞌa saa? Boe ma ara rataa randaa rae, “Faiꞌ naa, hai nda toꞌa saa sa boe!” ");
INSERT INTO row_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Basa de Ana ola seluꞌ, nae “Te ia na laen ena. Mete ma hei hambu dꞌoiꞌ, na, mendi. Mete ma tas sia, na, mendi boe. Mete ma fela tafaꞌ nese, na, mi seo badꞌu mara esa, fo hasa. ");
INSERT INTO row_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Huu atahori Yahudi ra rae Au ia atahori deꞌulakaꞌ. De mbeifen te ara rema toꞌu Au ena. Te naa nandaa no baꞌi Yesaya suraꞌ memaꞌ ena, nae: ‘Ara cap E atahori deꞌulaka!’” ");
INSERT INTO row_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ara rafadꞌe rae, “Amaꞌ! Hai mendi felas rua.” Boe ma Yesus nataa nae, “Dꞌai ena, Sudi boe olaꞌ naa leo!” ");
INSERT INTO row_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ara raa basa fefeta Paska ma, Yesus no ana dedꞌenu nara lao lete Saitun reu, onaꞌ fai mana laoꞌ ra boe. ");
INSERT INTO row_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Losa naa ma, Ana nafadꞌe se nae, “Hei musi hule-oꞌe naa fo afiꞌ hambu sosobꞌa-dꞌodꞌouꞌ.” ");
INSERT INTO row_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Basa de Ana dꞌinggoꞌ hela se mbei. Ana laoꞌ naꞌadꞌooꞌ mbei, ma sendeꞌ lululanggan de hule-oꞌe nae, ");
INSERT INTO row_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Amaꞌ! Mete ma Amaꞌ nau, na, muꞌudꞌodꞌooꞌ hendi doidꞌosoꞌ ia mia Au. Te afiꞌ tungga Au hihii-nanau ngga; tunggaꞌ a Amaꞌ hihii-nanaun.” ");
INSERT INTO row_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Basa ma Lamatuaꞌ aten esa mia sorga nema tao manggatee ralan. ");
INSERT INTO row_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Huu Ana doidꞌoso nitaꞌ mamaten, losa mbusan titi onaꞌ raaꞌ a tititin boe ");
INSERT INTO row_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Hule-oꞌe basa ma Ana neu nandaa no ana dedꞌenu nara. Te mana sungguꞌ ra, huu ara bꞌengge ma rala nara susa. ");
INSERT INTO row_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Boe ma Yesus ai se nae, “Naa! Taꞌo bee de hei sungguꞌ?! Malole lenaꞌ hei hule-oꞌe fo itaꞌ sosobꞌaꞌ nema o, hei nda tudꞌa sa.” ");
INSERT INTO row_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesus feꞌe olaꞌ taꞌo naa, ma Yudas (fo esa mia ana dedꞌenun ka sanahulu ruaꞌ ra), nema no atahori hetar. Ana nema dꞌeka-dꞌeka Yesus fo nae holu ma idꞌu E. ");
INSERT INTO row_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Te Yesus ai e nae, “Wii, Yudas! Mae seo Atahori Matetuꞌ a noꞌ a iꞌidꞌuꞌ, do? ");
INSERT INTO row_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Leleꞌ Yesus ana dedꞌenu laen nara rahine Yudas dudꞌuꞌa deꞌulakan onaꞌ naa, ma ratane Yesus rae, “Amaꞌ! Hai labꞌan se leo, do? Huu hai mendi felas.” ");
INSERT INTO row_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Boe ma esa mia sira e lesu felan, de soe etu atahori naa ra esa ndiki onan. Atahori naa, malangga agama Yahudi ra malangga monaen atahori dedꞌenun. ");
INSERT INTO row_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Te Yesus nataa nae, “Miloeꞌ leo! Afiꞌ labꞌan se!” Boe ma Ana nggama atahori naa ndikin, de tao nahaiꞌ e. ");
INSERT INTO row_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Atahori mana rema humu Yesus, naeni: malangga agama Yahudi ra malangga nara, lasi-lasi adat ro mana manea Ume Hule-oꞌe Huuꞌ a, ma atahori laen ra fai. Yesus natane se nae, “Taꞌo bee? Hei duꞌa mae Au ia, atahori deꞌulakaꞌ, losa hei ima humu Au mendiꞌ fela tafaꞌ ma hau eꞌetuꞌ, do? ");
INSERT INTO row_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Tungga fai Au unori nggi sia Ume Hule-oꞌe Huuꞌ a, te nda hambu atahori esa o nema humu Au sa boe. Te hela neu! Ia, hei fai ma. Huu oras ia nitu ra malanggan koasan ia!” ");
INSERT INTO row_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Basa ma ara humu rala Yesus, de lea ro E nisiꞌ malangga agama Yahudi ra malangga monaen umen. Petrus o keke tungga-tungga deaꞌ ");
INSERT INTO row_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Sia ume sodꞌan atahori tao ai monaeꞌ. Petrus o neu endoꞌ dara ai sia naa boe. ");
INSERT INTO row_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ate inaꞌ esa nita Petrus endoꞌ deka ai a. Ana mete namemeu Petrus matan, basa ma nafadꞌe atahori laen mana sia naa ra nae, “Hee! Atahori ia o tungga-tunggaꞌ Yesus boe!” ");
INSERT INTO row_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Te Petrus nafanii nae, “Hokoꞌ! Au nda uhine atahori naa sa. Ho muhine saa?” ");
INSERT INTO row_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Nda dooꞌ sa ma atahori esa puik nita Petrus, ma ola nae, “Memaꞌ, ho ia, Yesus atahorin esa, to?” Te Petrus nareresi nae, “Hokoꞌ! Ho tao leli!” ");
INSERT INTO row_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Mbei ma onaꞌ jam esa fai ma, atahori laen esa olaꞌ nae, “Woi! Au bubꞌuluꞌ, atahori ia, Yesus ana dedꞌenun esa, huu eni atahori Galilea.” ");
INSERT INTO row_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Te Petrus nafanii nahereꞌ nae, “Ho peko-lelekoꞌ!” Petrus olaꞌ taꞌo naa ma, manu ra o koꞌokee boe. ");
INSERT INTO row_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ma Yesus heoꞌ dꞌean, de mete e. Boe ma Petrus nasanedꞌa Yesus oꞌolan faꞌ ra na nae, “Tetembaꞌ ia, manu ra nda feꞌe koꞌokee sa, te ho mufunii Au lao telu ena.” ");
INSERT INTO row_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Petrus nasanedꞌa nala taꞌo naa ma, ana lao dea neu mia mamanaꞌ naa, ma nggae mesuꞌudꞌu. ");
INSERT INTO row_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Basa naa ma, atahori mana ranea Yesus mulai raꞌaꞌeꞌeiꞌ ma momoko raꞌamiminaꞌ E. ");
INSERT INTO row_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Boe ma ara babꞌata matan rendiꞌ temeꞌ, ma ratane rae, “Woi! Mete ma ho Lamatuaꞌ mana ola-olan, na, Mufadꞌe sobꞌa! Seka mana tutu Nggo?” ");
INSERT INTO row_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Basa ma ara ole-rarai E. ");
INSERT INTO row_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Feꞌe fefetu anaꞌ, te malangga agama Yahudi ra malangga nara, meser agama, ro lasi-lasi adꞌat ra raꞌabꞌue fo rae paresaꞌ Yesus dedꞌean. Ara denu atahori lea ro Yesus nisiꞌ mamana nggero-furi dedꞌeat agama. ");
INSERT INTO row_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Leleꞌ Ana rala neu, ma ratane mbali E rae, “Mufadꞌe sobꞌa dei! Memaꞌ tebꞌe-tebꞌeꞌ Ho ia Kristus, do??” Te Ana nataa nae, “Mae Au utaa tebꞌe o, hei nda mimihere sa. ");
INSERT INTO row_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ma mete ma Au utane baliꞌ nggi dalaꞌ esa, tantu hei o nda mitaa sa boe. ");
INSERT INTO row_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Nda dooꞌ sa te, Lamatualain nae pake koasa manaselin fo soꞌu Au, Atahori Matetuꞌ ia, ataꞌ u. Basa naa, Au endoꞌ sia bobꞌoa onan, fo parenda uꞌubꞌue o E.” ");
INSERT INTO row_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Rena taꞌo naa ma, basa se ratane rae, “Mete ma taꞌo naa, na, ho duꞌa mae, ho ia, Lamatualain Anan, do?” Ma Yesus nataa nae, “Memaꞌ, hei oꞌolam naa, tebꞌe.” ");
INSERT INTO row_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Boe ma atahori mana nggero-furi dedꞌeat naa ra olaꞌ randa rae, “Basa nggita rena ena, to? Ana soꞌu aon dadꞌi Lamatualain Anan. Ia, neꞌemutis! Tungga hita agaman hohoro-lalanen, mete ma hambu atahori tao aon onaꞌ Lamatuaꞌ, atahori naa, musi mate. Dadꞌi, taꞌo bee? Hita nda parlu sakasii sa ena. Hukun tisa E leo.” ");
INSERT INTO row_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Te, mana maꞌetuꞌ dedꞌeat agama Yahudi ra, nda raꞌena hak fo hukun risa atahori sa. Naa de ara ro Yesus nisiꞌ hofernor manaparenda Roma mana sia Yerusalem, naeni Pilatus. Ara nauꞌ a fo hofernor mana hukun Yesus. ");
INSERT INTO row_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","De losa hofernor matan ma, ara dui Yesus sala nara rae, “Atahori ia, mana labꞌan mana parenda Roma mana sia Yerusalem. Ana nanori nae, atahori afiꞌ bꞌae bꞌea neu manaparenda Roma. Ana o soꞌu aon nae Eni ia, Kristus, atahori Yahudi ra manen.” ");
INSERT INTO row_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Hofernor rena nala, ma natane mbali E nae, “Tebꞌe, do? Ho ia atahori Yahudi ra manen, do?” Ma Yesus nataa nae, ‘Tebꞌe. Onaꞌ amaꞌ oꞌolan.” ");
INSERT INTO row_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Hofernor paresaꞌ basa, ma ana mete mbali malangga agama ra malangga nara, ro basa atahori mana sia naa ra. Boe ma ana oi, “Taꞌo ia. Au nda hambu Atahori ia salan saa sa boe.” ");
INSERT INTO row_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Te ara rahereꞌ rae, “Hokoꞌ, ama hofernor. Atahori ia neu nanori sudꞌiꞌ a sia bee-bꞌee, dꞌunggu-mbau rauinggu ra fo ramue-raanggi ro mana parenda. Ana tao nemuet mia propensi Galilea losa kota Yerusalem ia.” ");
INSERT INTO row_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Hofernor rena nala taꞌo naa, ma natane se nae, “Mete ma taꞌo naa, na, Eni ia, atahori Galilea, do?” Boe ma rataa rae, “Tebꞌe, amaꞌ. Eni atahori Galilea!” ");
INSERT INTO row_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Hofernor nahine onaꞌ naa, ma denu se ro Yesus nisiꞌ mane Herodes, mana parenda propensi Galilea. Leleꞌ naa, ana sia kota Yerusalem. ");
INSERT INTO row_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Naa, mane Herodes o rena dudꞌuit naeꞌ soꞌal Yesus dꞌalan, ma ana hii nae nita Yesus eniꞌ a dooꞌ ena. Ana nae sadꞌi doo bee fo nita Yesus natudꞌu manadadꞌiꞌ mana seliꞌ esa do rua. Naa de, leleꞌ ro Yesus neu e, ma ralan namahoꞌo seli. ");
INSERT INTO row_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Boe ma natane dalaꞌ mataꞌ-mataꞌ mbali Yesus, te Ana nda nataa saa sa boe. ");
INSERT INTO row_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Herodes feꞌe olaꞌ no Yesus, te malangga agama ra malanggan no meser agama ra rundu seluꞌ salaꞌ mataꞌ-mataꞌ neu Yesus fai. ");
INSERT INTO row_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Basa ma mane Herodes no soldꞌadꞌu ra raꞌaꞌeꞌeiꞌ ma raneneut raꞌamuti Yesus. Boe ma ara olu badꞌu meulauꞌ esa neu E onaꞌ maneꞌ ra badꞌun, ma raꞌaꞌeꞌeiꞌ rakandooꞌ a. Basa ma, ara haitua baliꞌ E nisiꞌ hofernor Pilatus. ");
INSERT INTO row_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Feꞌesaꞌan, hofernor naa musu no mane Herodes. Te faiꞌ naa ma esa malole baliꞌ no esa. ");
INSERT INTO row_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Basa ma, hofernor Pilatus noꞌe malangga agama Yahudi ra malangga nara, lasi-lasi adat laen ra, ro basa atahori hetar naa, fo rema raꞌabꞌue rena neꞌetun. ");
INSERT INTO row_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ana olaꞌ nae, “Hei mo Yesus nema nisiꞌ au, ma rundu salaꞌ neu E mae, Ana hiiꞌ a dꞌunggu-mbau rauinggu ra fo labꞌan manaparenda Roma. Au paresaꞌ lutuꞌ-leloꞌ sia hei mata mara, te au nda hambu salan saa sa boe. ");
INSERT INTO row_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Mane Herodes o paresaꞌ ena boe, te nda hambu salan sa. Naa de ana haitua baliꞌ E nisiꞌ au. Atahori ia nda ma salaꞌ saa sa boe, de au nda bisa hukun mate E sa. ");
INSERT INTO row_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Dadꞌi au ae uꞌetuꞌ taꞌo ia: au denu filo E, basa fo au mboꞌi E.” ");
INSERT INTO row_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","18","Rena rala taꞌo naa, ma ara randu randaa rae, “Nda bisa sa! Misa E. Mboꞌiꞌ a Barabas.” Ara nggasi raꞌo naa, huu tungga too mete ma atahori Yahudi ra tao fefeta Paska, na, hofernor biasa mboꞌi atahori bꞌui esa tungga sira hihii-nanau nara. ");
INSERT INTO row_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barabas ia, masoꞌ bꞌui huu ana dadꞌi mana kokoe-nanasiꞌ, labꞌan mana parenda Roma sia kota Yerusalem, ma nisa atahori boe.) ");
INSERT INTO row_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Te hofernor nae mboꞌi Yesus. Dadꞌi ana natane seluꞌ atahori hetar naa ra nae, “Mete ma au mboꞌi Yesus ia, na taꞌo bee?” ");
INSERT INTO row_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Te basa se nggasi randaa rae, “Hokoꞌ! Mbaku tisa E neu hau ngganggeꞌ a! Mbaku tisa E neu hau ngganggeꞌ a!” ");
INSERT INTO row_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Te hofernor duꞌa nae naa nda matetuꞌ sa, de natane seluꞌ se lao katelun nae, “Taꞌo bee de au musi mbaku isa E onaꞌ naa? Deꞌulakan saa? Au paresaꞌ lutuꞌ-leloꞌ te nda hambu salaꞌ nandaa no au hukun mate E sa. Dadꞌi hela fo au denu filo E, fo basa na mboꞌi E.” ");
INSERT INTO row_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Te basa atahori naa ra nggasi rahereꞌ fai, rasuu rae mbaku risa E sia hau ngganggeꞌ. Neu mateꞌen, hofernor nda ai-baa nala se sa, ");
INSERT INTO row_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","de naꞌetuꞌ tungga hihii-nanau nara. ");
INSERT INTO row_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Boe ma ana mboꞌi hendi Barabas, mana hiiꞌ a bꞌalabꞌan ma mana tati atahori. Ma Ana fee Yesus neu se, fo ara sudꞌiꞌ a tao E tunggaꞌ hihii-nanau nara. ");
INSERT INTO row_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Basa naa ma, soldꞌadꞌu Roma ra lea rendi Yesus kalua mia Kota Yerusalem. Sia dalaꞌ taladꞌan ara randaa ro atahori kota Kirene esa, naran Simon. Ana feꞌe nema mia kota deaꞌ nema. Ara raꞌasusuuꞌ e nasaa hau ngganggeꞌ a nggati Yesus, boe ma laoꞌ tungga Yesus dꞌean. ");
INSERT INTO row_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Faiꞌ naa, atahori hetar rema tungga ranilu Yesus. Hambu mama-mama ra o nggae ei-ei E boe. ");
INSERT INTO row_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesus rena ara nggae, ma Ana mete mbali se, de olaꞌ nae, “We! Mama-mama Yerusalem. Afiꞌ nggae Au. Malole lenaꞌ nggaeꞌ a hei ao mara, mo ana mara. ");
INSERT INTO row_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Huu mbila-finiesaꞌ sususa monaeꞌ nae nema ena, losa atahori olaꞌ rae, ‘Inaꞌ mana onton seli, naeni inaꞌ nda mana feꞌe bꞌonggi nitaꞌ sa, ma nda feꞌe nasusu nita sa.’ ");
INSERT INTO row_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Leleꞌ sususa monaeꞌ losa, atahori ra doidꞌoso rala seli, losa ara roꞌe rae, ‘Malole lenaꞌ, leteꞌ ra ndefaꞌ fo tuni rala nggita leo!’ Ara o olaꞌ rae, ‘No doidꞌoso onaꞌ ia, malole lenaꞌ mbukuꞌ ra tatana rala nggita leo!’ ");
INSERT INTO row_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Naa, mete ma atahori bisa tao raꞌasususaꞌ onaꞌ ia neu atahori nda mana tao salaꞌ sa, saa fai neu atahori deꞌulakaꞌ?” ");
INSERT INTO row_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Leleꞌ soldꞌadꞌu ra rendi Yesus, ara o lea rendi atahori deꞌulakaꞌ rua, fo rae hukun risa se ro Yesus. ");
INSERT INTO row_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ara losa mamanaꞌ esa, naran ‘Langga ruiꞌ’. Boe ma ara mbaku Yesus no atahori deꞌulakaꞌ karuaꞌ ra esa-esaꞌ neu hau ngganggen. Basa ma ara sela raririiꞌ hau ngganggeꞌ naa ra. Ara mbaku atahori deꞌulakaꞌ esa sia Yesus bobꞌoa onan, ma esa sia bobꞌoa diin. ");
INSERT INTO row_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Leleꞌ naa, Yesus hule-oꞌe nae, “Amaꞌ! Fe ambon neu atahori ia ra sala nara, te ara nda rahine saa fo ara taoꞌ ia sa.” Basa ma, soldꞌadꞌu ra lea lot fo rae rahine seka mana hambu Yesus bꞌadu narun. ");
INSERT INTO row_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Atahori hetar rema ranilu sia mamanaꞌ naa. Atahori Yahudi ra malangga nara raneneut Yesus rae, “Ana fee masodꞌaꞌ neu atahori laen ra, te nda bisa tao nasodꞌa nala Aon sa. Mete ma tebꞌeꞌ-tebꞌeꞌ Eni, Kristus, fo Lamatualain pili memaꞌ, na, hela neu fo Ana onda mia hau ngganggeꞌ naa leo. ");
INSERT INTO row_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Soldꞌadꞌu naa ra o raneneut E boe. Ara fati E anggor maꞌeiꞌ, ");
INSERT INTO row_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ma nggasi raꞌaꞌeꞌeiꞌ rae, “Mete ma ho ia tebꞌe-tebꞌeꞌ atahori Yahudi ra manen, na, tao musodꞌa aom leo!” ");
INSERT INTO row_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ara suraꞌ sia papaꞌ sa oi, “Ia atahori Yahudi ra manen.” Basa ma ara mbaku papaꞌ naa sia Yesus langgan ataꞌ, fo rafadꞌe saa de sira hukun E. ");
INSERT INTO row_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Atahori deꞌulaka sa fo mana nenembakuꞌ sia Yesus bobꞌoan o naneneut nae, “Tebꞌe ho Kristus, do? Mete ma taꞌo naa, na, tao musodꞌa basa nggita leo!” ");
INSERT INTO row_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Te atahori deꞌulakaꞌ esa ka ai e nae, “Weh! Ho ia, nda mumutau Lamatualain sa, do? Ho nenehukun mate onaꞌ E boe. ");
INSERT INTO row_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ruꞌa nggita nenehukun nandaa no tatao-nonoꞌi deꞌulaka tara, Te Atahori ia nda tao deꞌulakaꞌ saa sa boe.” ");
INSERT INTO row_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Boe ma ana olaꞌ seluꞌ nae, “Yesus, e! Mete ma Amaꞌ losa nusaꞌ namo ma, na, musunedꞌa au, e.” ");
INSERT INTO row_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesus nataa nae, “Au helu-fuli! Faiꞌ ia boe o, ho masoꞌ mo Au isiꞌ sorga rala uu.” ");
INSERT INTO row_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Leleꞌ naa, reorendu ena. Te relo a nda naronda sa, de maꞌahatu kibꞌu-kibꞌuꞌ babꞌata nala mamanaꞌ naa, losa liiꞌ telu bobꞌon. Sia Ume Hule-Oꞌe Huuꞌ a hambu teme loa-naru monaeꞌ nenelondaꞌ bambi Lamatualain Kama Meumare Manaselin. Aiboiꞌ ma, teme loa-naruꞌ monaeꞌ a sii neu rua. ");
INSERT INTO row_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Mia mamanaꞌ naran ‘Langga Ruiꞌ’ naa, Yesus nggasi nahereꞌ nae, “Amaꞌ! Ia na Au fee samana ngga neu Nggo.” Ana olaꞌ basa naꞌo naa, ma etu hahaen boe. ");
INSERT INTO row_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Hambu soldꞌadꞌu Roma esa nambariiꞌ deka Yesus hau ngganggen. Leleꞌ ana nita Yesus mamaten, ma ana koa-kio Lamatualain nae, “Waa! Atahori ia tebꞌe-tebꞌeꞌ rala ndoos, o!” ");
INSERT INTO row_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Leleꞌ atahori hetar mana raꞌabꞌue sia naa rita Yesus mamaten ma, fale rala nara, ma baliꞌ no rala sususaꞌ. ");
INSERT INTO row_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Te Yesus atahori nara rambariiꞌ lalanik siaꞌ a dodꞌooꞌ mete Yesus mamaten. Mama-mama mana tungga E mia Galilea losa Yerusalem o sia naa boe. ");
INSERT INTO row_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Leleꞌ Yesus mate ena ma, hambu atahori esa sangga dalaꞌ fo nae naꞌondaꞌ Yesus ao-sisin mia hau ngganggeꞌ fo neu naꞌoi E no malolole. Atahori naa naran Yusuf, mia kota Arimatea. Yusuf ralan ndoos, ma ana tao dꞌala maloleꞌ naeꞌ. Ana nea-nea fo Lamatualain natudꞌu Eni toꞌu parendan. Eni o esa mia mana endoꞌ neꞌetuꞌ dedꞌea agama Yahudi, te ana nda naꞌaheiꞌ tungga neꞌetuꞌ fo hukun mate Yesus sa. ");
INSERT INTO row_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Huu ana nae naꞌondaꞌ Yesus ao-sisin mia hau ngganggeꞌ a, de neu nisiꞌ hofernor Pilatus fo noꞌe nae lolelau aosisiꞌ naa. ");
INSERT INTO row_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ana hambu isin ma, neu naꞌondaꞌ. Basa ma ana mboti ao-sisiꞌ naa no teme meulauꞌ. Boe ma ana nendi ao-sisiꞌ naa neu mbedaꞌ sia fatu ndolaꞌ esa, fo atahori feꞌe paa basa ena. Mamana rates naa, esa nda feꞌe pake sa boe. ");
INSERT INTO row_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Yesus mamaten, nandaa no hari lima. Leleꞌ Yusuf se raꞌoi basa ma, bobꞌoꞌ ena. Mete ma relo a mopo ena, na, atahori Yahudi fai hule-oꞌen nae losa ena. ");
INSERT INTO row_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Mama-mama mana rema ro Yesus mia Galilea, ara tungga ro Yusuf rae rahine ana tao ao-sisin sia rates bee. ");
INSERT INTO row_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ara mete malolole rala rates naa, boe ma mama naa ra baliꞌ fo sadꞌia bꞌunaꞌ rambe ma mina maꞌameniꞌ. Leleꞌ relo a mopo ma, ara raloeꞌ tao ues, tungga atahori Yahudi ra fai hule-oꞌe nara atoran na. Ara rahani fai hule-oꞌeꞌ a seli, dei fo rae reu ngganggari rambe neu Yesus ao-sisin. ");
INSERT INTO row_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Nggarei deka manggarelo, ma mama naa ra rendi mina maꞌameniꞌ ma bꞌuna rambe fo reu sia Yesus raten. ");
INSERT INTO row_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Leleꞌ ara losa naa, ma rita fatu monaeꞌ fo ara pake ꞌena neu rates a, nenelolir neu sia suuꞌ ena. ");
INSERT INTO row_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Boe ma ara rates rala reu, te nda rita Yesus ao-sisin sia naa sa. ");
INSERT INTO row_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Dadꞌi ara bingun. Aiboiꞌ ma, atahori rua pake bꞌua-baꞌu makahahadꞌok, rema ririi mia bobꞌoa nara. ");
INSERT INTO row_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Mama naa ra ramatau ritaꞌ mamate nara, de bꞌeꞌute losa rae a. Boe ma atahori karuaꞌ ra ratane rae, ‘Taꞌo bee de hei ima sangga atahori masodꞌaꞌ sia atahori mates ra mamana nara? ");
INSERT INTO row_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yesus nda sia ia sa ena! Huu Ana nasodꞌa baliꞌ ena. Mbei ma hei liliiꞌ hendi saa fo Ana olaꞌ leleꞌ Ana feꞌe mia Galilea, do? ");
INSERT INTO row_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Huu Ana nafadꞌe memaꞌ nae, dei fo ara seo hendi Atahori Matetuꞌ a neu atahori deꞌulakaꞌ ra liman. Basa ma ara mbaku risa E sia hau ngganggeꞌ a ata. Te fai katelun ma, Ana nasodꞌa baliꞌ.” ");
INSERT INTO row_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ara rena rala taꞌo naa, dei de feꞌe rasanedꞌa Yesus oꞌolan malahulun. ");
INSERT INTO row_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Boe ma ara bꞌaliꞌ lai-lai, fo rafadꞌe basa-bꞌasaꞌ e neu Yesus dedꞌenu kasanahulu esa nara, ma atahori laen mana tungga E. ");
INSERT INTO row_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","(Mama-mama mana reu sia rates a, naeni Yakobis maman Maria, no Maria mia kambo Magdala, ma Yohana no mama laen hira fai. Sira mana reu dui basa ia neu Yesus ana dedꞌenu nara.) ");
INSERT INTO row_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Te leleꞌ dedꞌenuꞌ ra rena dudꞌuit naa, ara duꞌa rae mama naa ra lelekoꞌ. ");
INSERT INTO row_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Te Petrus fela de nela-nelaꞌ rates neu. Losa naa ma, ana mete rates rala neu, te nitaꞌ a temeꞌ fo ara mboti neu mamates a. Boe ma ana baliꞌ de dudꞌuꞌa nae, “Ia taꞌo bee, e?” ");
INSERT INTO row_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Faiꞌ naa o, Yesus ana dedꞌenu na rua reu sia kamboꞌ esa, naran Emaus. Dꞌodꞌoon mbei ma kilo sanahulu esa mia kota Yerusalem. ");
INSERT INTO row_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ara lao-laoꞌ ma ola-olaꞌ Yesus mamaten na. ");
INSERT INTO row_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Aiboiꞌ ma, Yesus nambariiꞌ dꞌeka-dꞌeka no ruꞌa se, ma laoꞌ naꞌabꞌue no se. ");
INSERT INTO row_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Te ara nda rahine rae naa Yesus sa, huu Lamatuaꞌ tao fo ara nda rahine sa. ");
INSERT INTO row_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Boe ma Yesus natane se nae, “Hei ruꞌa nggi, ola-olaꞌ saa, e?” Ara rena ma, ruꞌa se rambariiꞌ. Mata nara onaꞌ manasusaꞌ seli. ");
INSERT INTO row_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Basa ma, Kleopas natane E nae, “Amaꞌ ia, onaꞌ atahori feuꞌ fo nda nahine saa mana feꞌe dadꞌi sia Yerusalem, sa do?” ");
INSERT INTO row_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Boe ma Yesus natane nae, “Saa sia naa?” Ara rataa rae, “Te soꞌal Yesus, mana mia Nasaret a! Eni tebꞌe-tebꞌeꞌ Lamatualain mana ola-olan. Ma Lamatuaꞌ fee koasa neu E fo tao manadadꞌiꞌ mataꞌ-mataꞌ ra. Eni nanori nahine atahori. Basa atahori ra hii E, ma Lamatuaꞌ o hii E boe. ");
INSERT INTO row_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Tao-tao te, hita malangga agama Yahudi nara malangga nara ro lasi-lasi adꞌat ra toꞌu rala E. Basa ma ara fee E nisiꞌ hofernor fo hukun risa E. Boe ma ara mbaku risa E mia hau ngganggeꞌ ata. ");
INSERT INTO row_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Fefeun basa hai mimihena mae, Eni Kristus, mana nema mboꞌi hai atahori mara mia mana parenda Roma mana tuni-ndeni hai. Te hari lima faiꞌ naa, ara tao risa E ena. ");
INSERT INTO row_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Aleꞌ ia hai boe bingun. Huu faꞌ ra hai mama mara rema rafadꞌe rae, fefetu anan sira reu mia rates. ");
INSERT INTO row_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Te ara dui rae, Yesus ao-sisin mopo hendi ena. Boe ma rita Lamatualain aten mia sorga, nafadꞌe se nae, Yesus nasodꞌa baliꞌ ena. ");
INSERT INTO row_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Rena taꞌo naa, ma hai nonoo mara hira relaꞌ rates reu. Ara o rita onaꞌ hai mama mara nefadꞌe nara boe. Ara o nda rita Yesus ao-sisin sa boe.” ");
INSERT INTO row_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ruꞌa se dui basa ma, Yesus olaꞌ no se nae, Hei nggonggoa mara seli! Taꞌo bee de hei nda nau mimihere saa fo Lamatuaꞌ mana ola-ola nara rafadꞌe memaꞌ eniꞌ a fai dꞌalahulun! ");
INSERT INTO row_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ara suraꞌ ena rae, Kristus naa, musi hambu doidꞌosoꞌ mataꞌ naa, dei fo Ana simbo hadꞌa-hormat ma koasa manaseliꞌ.” ");
INSERT INTO row_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Boe ma Yesus nanori se, basaꞌ e fo Lamatuaꞌ mana ola-ola nara suraꞌ memaꞌ soꞌal Kristus. Mulai mia Baꞌi Musa susuran, losa mana ola-olaꞌ laen ra ꞌena nara. ");
INSERT INTO row_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Leleꞌ ara rae losa Emaus, ma Yesus tao onaꞌ nae laoꞌ nakandoo. ");
INSERT INTO row_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Te ruꞌa se roꞌe rae, “Amaꞌ! tuli fo leo mo hai tetembaꞌ ia, te relo a naeꞌ a mopo ena.” Boe ma Yesus ume rala neu no se. ");
INSERT INTO row_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Leleꞌ ara endoꞌ rae raa, ma Yesus haꞌi nala roti bꞌueꞌ sa, boe ma Ana hule-oꞌe noꞌe makasi mbali Lamatualain, ma Ana bibꞌibꞌi roti a. Leleꞌ Ana loo roti fee ruꞌa se, ");
INSERT INTO row_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","dei de ruꞌa se feꞌe rahine rae, naa, Yesus, te aibꞌoiꞌ ma, mopo E mia mata nara! ");
INSERT INTO row_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Boe ma ruꞌa se babꞌales rae, “Waa! Leleꞌ rena Ana olaꞌ tao manggarelo mana ola-olaꞌ ra susuran faꞌ ra, hita tamedꞌa onaꞌ rala tara ramahoꞌo.” ");
INSERT INTO row_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Oras naa boe, ruꞌa se fela de lao baliꞌ Yerusalem reu. Ara randaa ro Yesus ana dedꞌenun atahori ka sanahulu esaꞌ ra, ma atahori laen mana raꞌabꞌueꞌ sia naa. ");
INSERT INTO row_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Boe ma ana dedꞌenuꞌ naa ra rafadꞌe ruꞌa se rae, “Memaꞌ tebꞌe! Lamatuaꞌ Yesus nasodꞌa baliꞌ ena! Faꞌra natudꞌu Aon neu aꞌa Petrus.” ");
INSERT INTO row_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Basa ma, atahori ka ruaꞌ ra dui basa mana dadꞌiꞌ mia dalaꞌ, losa ruꞌa se rahine Yesus leleꞌ Ana bibꞌibꞌi roti. ");
INSERT INTO row_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Leleꞌ ara feꞌe ola-olaꞌ taꞌo naa aiboiꞌ ma, Yesus nambariiꞌ sia taladꞌa nara. Ana natea se nae, “Sodꞌa-moleꞌ!” ");
INSERT INTO row_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Te, ara nggengger ma ramatau, huu rae neꞌo nitu. ");
INSERT INTO row_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Te Yesus olaꞌ nae, “Taꞌo bee de hei mimitau taꞌo ia? Hei nda mimihere mae, ia Au, usodꞌa baliꞌ ena sa, do? ");
INSERT INTO row_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Mete sobꞌa lima ma ei ngga ra. Ia Au. Loo lima mara fo nggama neuꞌ ena! Naa fo mimihere mae, ia Au, nda nitu sa. Huu nitur nda ma aoꞌ sa, te basa hei bisa mita Au ao ngga, to?!” ");
INSERT INTO row_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Feꞌe olaꞌ naꞌo naa ma, Ana natudꞌu neu se bisu foaꞌ mana sia lima-ei nara. ");
INSERT INTO row_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ara ramahoꞌo seli, huu Yesus nasodꞌa baliꞌ ena. Akaꞌ ara onaꞌ mana bingun, huu nda rahine rae taꞌo bee de dadꞌi taꞌo naa sa. Boe ma Yesus natane se nae, “Hei mia saa sia ia?” ");
INSERT INTO row_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Boe ma ara loo fee Ne uꞌu manapanggaꞌ eꞌetuꞌ sa. ");
INSERT INTO row_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Yesus simbo nala uꞌu a, de naa mia mata nara. ");
INSERT INTO row_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Boe ma Ana olaꞌ nae, “Taꞌo bee? hei feꞌe misinedꞌa leleꞌ au uꞌubꞌue o nggi do? Au ufadꞌe faiꞌ naa ae, basa saa fo Lamatua mana ola-ola nara, suraꞌ soꞌal Au naa, musi dadꞌi. Naeni, mia baꞌi Musa, mia mana ola-olaꞌ laen ra, ma mia buku sosodꞌa kokoa-kikioꞌ ra.” ");
INSERT INTO row_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Basa ma, Ana soi dudꞌuꞌa nara fo rahine tebꞌe-tebꞌeꞌ Lamatuaꞌ Susura Meumaren sosoa-ndandaan. ");
INSERT INTO row_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ana olaꞌ seluꞌ fai nae, “Lamatualain mana ola-ola nara suraꞌ ena rae, Kristus, fo Lamatualain haitua nemaꞌ naa, musi hambu doidꞌosoꞌ mataꞌ-mataꞌ, dei fo Ana mate. Te fini esan, ma Ana nasodꞌa baliꞌ. Ara suraꞌ basa ena na! ");
INSERT INTO row_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","De ia na Au fee nggi koasa fo mendi Hara-lii maloleꞌ neu basa atahori, mulai mia Yerusalem ia, Mifadꞌe se mae, atahori mana nataa salan ma baliꞌ nisiꞌ Lamatualain, dei fo Lamatualain ose hendi neu basa sala nara. ");
INSERT INTO row_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Hei musi dadꞌi sakasii fo dui-bꞌengga, Au hambu doidꞌosoꞌ, de mate, basa ma usodꞌa baliꞌ ");
INSERT INTO row_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Dei fo Au haitua Dula-dꞌale Meumare ngga nema, fo Ama ngga helu-fuli memaꞌ ena. Te hei musi mihani sia kota Yerusalem ia, losa ama simbo mala koasa mia sorga.” ");
INSERT INTO row_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Faiꞌ sa, Yesus no se kota a deaꞌ reu. Leleꞌ ara rae losa kambo Betania, Ana bꞌotiꞌ liman de olaꞌ fee se papala-babꞌanggiꞌ. ");
INSERT INTO row_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Leleꞌ Ana feꞌe olaꞌ fee papala-babꞌanggiꞌ, ma Ana nenesoꞌuꞌ sorga neu. ");
INSERT INTO row_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Basa se rita taꞌo naa, ma ara sendeꞌ lululangga nara fo beꞌutee neu E. Basa ma ara baliꞌ Yerusalem reu ro rala nemehoꞌot seli. ");
INSERT INTO row_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Tungga fai ara raꞌabꞌue sia Ume Hule-oꞌe Huuꞌ a fo koa-kio Lamatualain. Ama Teofilus! Dudꞌui ngga losaꞌ a ia. Sodꞌa-moleꞌ, Lukas ");
INSERT INTO row_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Fefeu na, Lamatualain Dedꞌea-oꞌolan sia memaꞌ ena. Lamatualain Dedꞌea-oꞌolan, naeni Atahori esa. Atahori naa naꞌabꞌue no Lamatualain. Eni o, Lamatualain boe. ");
INSERT INTO row_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Leleꞌ lalai no raefafoꞌ nda feꞌe dadꞌi sa, Atahori naa sia memaꞌ no Lamatualain ena. ");
INSERT INTO row_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Lamatualain naꞌadadadꞌiꞌ basa-bꞌasaꞌ e, nendiꞌ Dedꞌea-oꞌolan. Nda hambu sudꞌiꞌ a saa esa dadꞌi sa boe, mete ma Atahori naa nda tao sa. ");
INSERT INTO row_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Eni, masodꞌaꞌ a okan. Dadꞌi atahori mana hambu masodꞌa matetuꞌ a, ara rasodꞌa mia E. Ana o onaꞌ Manggareloꞌ mana naronda, fo atahori mana rasodꞌa sia Manggareloꞌ naa, bisa rita ma rahine. ");
INSERT INTO row_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Manggareloꞌ naa, naronda tora maꞌahatuꞌ a rala; de maꞌahatuꞌ a nda ai-baa nala Manggareloꞌ naa sa. Huu Manggareloꞌ naa naronda nakandooꞌ a. ");
INSERT INTO row_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Naa, hambu atahori laen esa, naran Yohanis. Lamatualain o denu e boe, ");
INSERT INTO row_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","fo dadꞌi sakasii mana dui-bꞌengga Manggareloꞌ naa neu atahori. Naa fo basa atahori ramahere neu Lamatuaꞌ, huu Yohanis oꞌolan. ");
INSERT INTO row_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yohanis ia, nda Manggareloꞌ naa sa. Te Lamatualain denu e dui-bꞌengga soꞌal Manggareloꞌ naa neu atahori. ");
INSERT INTO row_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Huu Atahori mana dadꞌi Manggareloꞌ matetuꞌ a, nae nema sia raefafoꞌ ia. Manggareloꞌ naa mana tao dala-dalaꞌ ndoo-tetuꞌ ra nenenitaꞌ soaꞌ neu basa atahori. ");
INSERT INTO row_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Mae Ana tao basa mana sia raefafoꞌ ia ra dadꞌi ena o, te atahori sia raefafoꞌ ia nda rahine E sa, leleꞌ Ana nema leo sia ia. ");
INSERT INTO row_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Mae Ana nema leo no Eni atahori nara o, te ara nda nau simbo E sa. ");
INSERT INTO row_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Mae onaꞌ naa o, basa atahori mana simbo ma ramahere neu E, Ana fee se hak dadꞌi Lamtualain ana nara. ");
INSERT INTO row_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Naa onaꞌ sira nenebonggi baliꞌ ena. Te sira nenebonggi feuꞌ naa, nda onaꞌ atahori bonggi ana dikiꞌ sa. Ma nda mia touꞌ esa mana hii-nau hambu tititi-nonosiꞌ sa. Te ara dadꞌi Lamatualain ana nara, huu Lamatualain mana fee se masodꞌa feuꞌ naa. ");
INSERT INTO row_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Boe ma, ‘Lamatualain Dedꞌea-oꞌola’ naa, nenebonggiꞌ dadꞌi atahori. Ana leo sia taladꞌa tara. Hita mete-tita Eni manaselin. Eni manaseliꞌ onaꞌ naa, huu Eni, Lamatualain Ana isen. Ana hiiꞌ a natudꞌu rala malolen nema nggita, huu memaꞌ Eni ndolu-hadꞌan onaꞌ naa ena. Boe ma basa saa fo Ana nafadꞌe soꞌal Lamatualain, memaꞌ tetebꞌes. ");
INSERT INTO row_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Naa, Yohanis naa, dui-bꞌengga soꞌal Atahori ia. Ana nameli nae, “Rena, e! Eni ia, au dui ena ae, ‘Dei fo Atahori esa nae nema. Eni manaseliꞌ lenaꞌ au. Huu nda feꞌe bonggi au sa te, Ana sia naꞌahuluꞌ ena!’” ");
INSERT INTO row_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Yohanis olaꞌ naꞌo naa, huu Atahori naa hiiꞌ a natudꞌu rala malolen. Boe ma Ana tao nasafafali taꞌo naa nakandooꞌ a soaꞌ neu basa nggita. ");
INSERT INTO row_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Lele uluꞌ a, baꞌi Musa naꞌondaꞌ Lamatualain Hohoro-lalanen soaꞌ neu bei-baꞌi tara. Te aleꞌ ia, Atahori naa, naeni Yesus Kristus, mana natudꞌu Lamatualain rala ralolen neu nggita. Boe ma basa saa fo Ana nafadꞌe soꞌal Lamatualain, memaꞌ tebꞌe. ");
INSERT INTO row_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nda hambu atahori esa sa boe mana nita tebꞌe-tebꞌeꞌ Lamatualain. Te Eni Ana ise susuen, mana natudꞌu neu nggita Lamatualain ralan. Anaꞌ naa, sia Aman bobꞌoan. Huu Eni o, Lamatualain boe. ");
INSERT INTO row_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Lao esa, atahori Yahudi ra malangga nara sia Yerusalem denu malangga agama hira ro atahori hira mia suku Lewi mana lole-lau sia Lamatualain Ume Hule-oꞌe Huun. Ara reu sia loe Yarden bobꞌoan de ratane Yohanis mana saraniꞌ a rae, “Ho ia, Kristus fo Lamatualain helu-fuli nae haitua nemaꞌ a, do?” De nafadꞌe se nae, eni ia, seka. ");
INSERT INTO row_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ana nataa relo-relo nae, “Hokoꞌ. Au ia, nda Kristus sa.” ");
INSERT INTO row_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Boe ma ratane seluꞌ rae, “Mete ma taꞌo naa, ho ia, seka? Baꞌi Elia, do?” Ana nataa nae, “Hokoꞌ boe.” Boe ma ratane fai rae, “Afiꞌ losa ho ia, Lamatualain mana ola-olan laen, do?” Ana nataa nae, “Hokoꞌ boe.” ");
INSERT INTO row_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Basa naa ma, ara ratane seluꞌ rae, “Naa, mete ma taꞌo naa, ho ia, seka? Mufadꞌe dei! Huu hai musi baliꞌ mii mifadꞌe neu malangga-malangga mana denu hai ra. Tulun dei!” ");
INSERT INTO row_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Boe ma ana olaꞌ tungga saa fo baꞌi Yesaya suraꞌ nita oi, “Au ia, naeni atahori mana nameli sia mamana rouꞌ oi, ‘Basa atahori mihehere tao milole dalaꞌ ra, fo simbo Lamatuaꞌ neneman! Tao mitetu dalaꞌ fo soru E.’” ");
INSERT INTO row_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Sia atahori mana rema mia Yerusalem taladꞌa nara, hambu atahori hira mia partei agama Farisi. ");
INSERT INTO row_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Basa ma ratane Yohanis rae, “Taꞌo ia. Mete ma ho nda Kristus sa, nda baꞌi Elia sa, ma nda Lamatualain mana ola-olan sa, na, taꞌo bee de sarani atahori? Hambu hak mia bee?” ");
INSERT INTO row_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","De Yohanis nataa nae, “Au ia, sarani atahori endiꞌ a oe. Te hambu Atahori esa sia taladꞌa mara ena, te nda mihine sa. ");
INSERT INTO row_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Eni manaseliꞌ lenaꞌ au, mae au unori uꞌuhuluꞌ atahori. Mae dadꞌiꞌ a Eni aten boe o, au nda undandaa sa.” ");
INSERT INTO row_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Basa dalaꞌ ia ra dadꞌi sia Betania, sia loe Yarden bobꞌoan. Yohanis no ana mana tungga nara sarani atahori sia naa. ");
INSERT INTO row_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Mbilaꞌ neu ma, Yohanis mete nita Yesus laoꞌ nisiꞌ e. Boe ma ana olaꞌ nae, “Mete neu Atahori mana sia naa dei! Eni, Lamatualain Bibꞌi Lombo Anan mana dadꞌi tutunu-hohotuꞌ fo tefa-soi atahori sia raefafoꞌ ia sala-kilu nara. ");
INSERT INTO row_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Atahori ia, au ufadꞌe neu nggi afis a ena ae, ‘Dei fo Atahori esa nema. Eni manaseliꞌ lenaꞌ au, huu Ana sia naꞌahuluꞌ au ena.’ ");
INSERT INTO row_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Fai maꞌahulun, au nda uhine ae, Eni, Kristus sa. Mae onaꞌ naa o, uhine ena ae au musi fee atahori Israꞌel ra rahine E. Huu naa, au uma fo sarani atahori endiꞌ oe. ");
INSERT INTO row_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Lamatualain denu au sarani atahori endiꞌ oe. Ana o nafadꞌe au nae, ‘Dei fo Atahori esa nisiꞌ nggo. Basa naa ma, Dula-dale Ngga onda nema leo sia E. Atahori naa, mana nendi Dula-dale Meumare Ngga, fo fee koasa neu atahori Ngga ra.’ Leleꞌ Atahori naa nema, au nda uhine tuteꞌ E sa. Te leleꞌ au ita Lamatualain Dula-dalen onda nema mia lalai a onaꞌ mbui lunda, tee neu E, dei de au uhine E ae, ‘Atahori ia, Eni ena!’ ");
INSERT INTO row_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Au ita dalaꞌ naa ra no mata ngga. Basa de au ufadꞌe neu nggi ae, ‘Atahori mana nemaꞌ naa, naeni Lamatualain Anan!’” ");
INSERT INTO row_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Mbilaꞌ neu ma, Yohanis nambariiꞌ no ana mana tungga nara, atahori rua. ");
INSERT INTO row_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Leleꞌ Yohanis nita Yesus laoꞌ tungga naa, ana nafadꞌe nae, “Mete dei! Huu Eni ia, Lamatualain Bibꞌi Lombo Anan dei fo mana dadꞌi tutunu-hohotuꞌ!” ");
INSERT INTO row_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Basa ma Yohanis ana mana tungga karua nara mana rena oꞌolan, lao hela e, de reu tungga Yesus. ");
INSERT INTO row_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Boe ma Yesus heoꞌ dean, ma nita se laoꞌ tungga Eni. Boe ma natane se nae, “Taꞌo bee? Parlu, do?” Ara ratane mbali E rae, “Rabi leo sia bee?” (Sira dedꞌea Aram, ‘Rabi’ sosoan nae, ‘Ama Meser’.) ");
INSERT INTO row_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yesus nataa nae, “Ima fo mita neuꞌ ena.” Boe ma ara tungga E, de rita mamana leleon. Leleꞌ ara losa, mbei ma liiꞌ haa boboon ena. De ara rahani ro E losa relo a mopo. ");
INSERT INTO row_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Naa, mia atahori karuaꞌ mana rena Yohanis oꞌolan, ma tungga Yesus naa, esa naran Anderias. Eni, Simon Petrus odin. ");
INSERT INTO row_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Baliꞌ losa-losaꞌ ma Anderias neu sangga aꞌan Simon nae, “We, aꞌa! Hai mindaa mo Mesias ena!” (Sia sira dedꞌean ‘Mesias’ sosoan nae, ‘Kristus, naeni Atahori fo Lamatualain helu-fuli memaꞌ eniꞌ a lele uluꞌ a fo nae haitua nemaꞌ a.’) ");
INSERT INTO row_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Basa ma, ana no aꞌan nisiꞌ Yesus. Boe ma Yesus mete e, de nafadꞌe nae, “Ho ia, Simon. Amam, Yohanis. Mia faiꞌ ia, atahori roꞌe nggo, rae ‘Kefas’” (Eni sosoan onaꞌ ‘Petrus’, naeni ‘fatu’.) ");
INSERT INTO row_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","44","Sia naa hambu atahori laen esa, naran Filipus. Eni kambon, Betsaida. Petrus no Anderias o mia naa rema boe. Naa, mbilaꞌ neu ma, Yesus naꞌetuꞌ nae neu sia profinsi Galilea. Boe ma neu nandaa no Filipus, de Ana noꞌe nae, “Uma, tungga Au fo dadꞌi atahori ngga!” ");
INSERT INTO row_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Basa ma Filipus neu sangga Natanel, de nafadꞌe nae, “Aꞌa, e! Hai mindaa mo Atahori fo baꞌi Musa suraꞌ sia Lamatualain Hohoro-lalanen ena. Lamatualain mana ola-olan daluhuluꞌ ra suraꞌ soꞌal Atahori ia boe. Eni naran Yesus, mia kambo Nasaret, ma aman, naran Yusuf.” ");
INSERT INTO row_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Te Natanel nataa nae, “Atahori Nasaret!? Aweꞌ! Nda hambu dala maloleꞌ esa sa boe, laoꞌ mia naa nema sa, o!” Boe ma Filipus nae, “We! Afiꞌ taꞌo naa. Uma fo mita no matam!” ");
INSERT INTO row_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Leleꞌ Natanel laoꞌ nema, Yesus nita e memaꞌ ena, de nae, “Eni ia, atahori ndoos! Huu sia ralan, nda hambu peko-lelekoꞌ sa. Eni atahori Israꞌel tebꞌe-tebꞌeꞌ!” ");
INSERT INTO row_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanel natane nae, “Taꞌo bee de Papa nahine au?” Yesus nataa nae, “Taꞌo ia. Au ita nggo ena leleꞌ mia hau naa huun. Leleꞌ naa, Filipus nda feꞌe neu noꞌe nggo sa.” ");
INSERT INTO row_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Boe ma Natanel nataa nae, “Ama Meser ia, tantu Lamatualain Anan! Boe ma Amaꞌ o, tantu hai atahori Israꞌel ra Manem boe!” ");
INSERT INTO row_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesus natane e nae, “Seꞌu te ho ia, mumuhere neu Au, huu faꞌ ra Au ae, ‘Au ita nggo leleꞌ ho mia hau huuꞌ a raeꞌ,’ do? Musunedꞌa, te dei fo bisa mita dala-dala manaseliꞌ lenaꞌ naa fai! ");
INSERT INTO row_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Tebꞌe! Au ufadꞌe memaꞌ. Dei fo ama mita lalai a sii. Boe ma Lamatualain ate nara mana sia sorga ra onda-hene sia Au bobꞌoa ngga. Ma Au ia, Atahori Matetuꞌ a.” ");
INSERT INTO row_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Fini esan boe ma, hambu fefeta kakabꞌiꞌ sia kambo Kana, sia profinsi Galilea. Yesus maman neu boe. ");
INSERT INTO row_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesus no ana mana tungga nara o neneneroloꞌ boe. De ara reu. ");
INSERT INTO row_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Te doo-doo ma, anggor sia mamana fefetas nae basa. Boe ma Yesus maman nafadꞌe E nae, “Tulun dei! Te anggor nara naeꞌ a basa ena.” ");
INSERT INTO row_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Te Yesus nataa nae, “Mama. Taꞌo bee de mama nauꞌ a Au mana tao mataꞌ? Huu Au fai ngga nda feꞌe losa sa.” ");
INSERT INTO row_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Te maman nafadꞌe atahori mana lole-lau sia naa ra nae, “Rena, e! Ana denu nggi tao saa, na, tao tungga.” ");
INSERT INTO row_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Sia naa hambu nggusi nee, fo atahori tao mia fatu. Nggusi esa na, mbei ma nala oe liter hitu nulu lima losa natun esa sanahulu lima (75-115). Atahori Yahudi ra biasa tao rameu ao nara rendiꞌ oe mia nggusi mataꞌ naa ra tungga sira agaman hohoro-lalanen. ");
INSERT INTO row_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Boe ma Yesus nafadꞌe atahori mana lole-lauꞌ ra nae, “Mii haꞌi oe fo oni neu nggusi ia ra.” Boe ma ara oni sofe se. ");
INSERT INTO row_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","De nafadꞌe se nae, “Naa. Ndui mala mbei, fo mendi fee neu tenu fefetas a.” Ma ara tao tungga. ");
INSERT INTO row_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Losa naa, ma tenu fefetas ninu sobꞌa oe a. Tao-tao te oe a dadꞌi anggor ena! Ana tabanganga, huu nda nitaꞌ nae ara hambu anggor mia bee sa boe. (Te atahori mana lole-lauꞌ ra bubꞌuluꞌ.) Boe ma ana noꞌe tou mana saoꞌ a. ");
INSERT INTO row_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Boe ma ana nae, “Taꞌo ia. Hita biasan, tenu umeꞌ a banggi naꞌahuluꞌ anggor maladꞌa manaseliꞌ a. Mete ma atahori ra rinu naeꞌ ena, dei fo haꞌi anggor nomor ka ruan. Te tao tabalek. De haꞌi anggor nomor ka ruan naꞌahuluꞌ, dei de feꞌe haꞌi anggor maladꞌaꞌ a naꞌabꞌuit!” ");
INSERT INTO row_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Dalaꞌ naa dadꞌi sia kambo Kana, sia profinsi Galilea. Naa Yesus tao manadadꞌi-manaseliꞌ fefeun fo atahori ritaꞌ a. Ana natudꞌu manaselin onaꞌ naa, dei de ana mana tungga nara ramahere E. ");
INSERT INTO row_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Basa naa, ma Yesus, maman, odi nara, boe ma ana mana tungga nara onda reu sia kota Kapernaum. Te ara leo sia naa akaꞌ fai hiraꞌ a. ");
INSERT INTO row_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Leleꞌ atahori Yahudi ra fai malole Paska deka-deka nema ena, Yesus hene nisiꞌ kota Yerusalem. ");
INSERT INTO row_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Sia Ume Hule-oꞌe Huuꞌ a sodꞌan, Yesus nita atahori ra raseseoꞌ sapi, bibꞌi lombo, ma mbui lunda fo atahori hasa fo tao neu tutunu-hohotuꞌ. Sia naa, hambu atahori endoꞌ sia mei a tukar doiꞌ fo atahori rae fee neu Lamatualain sia Ume Hule-oꞌe Huuꞌ a. ");
INSERT INTO row_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Boe ma Ana haꞌi nala taliꞌ ndooꞌ hira de tao dadꞌi fifiloꞌ. Boe ma Ana mbuu hendi basa se dea reu mia ume sodꞌan. Ana o mboo hendi sapi ro bibꞌi lombo ra. Ana ofe lenggu-bara hendi mei ra, ma mboꞌa leꞌa-nggari hendi doiꞌ ra. ");
INSERT INTO row_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Boe ma Ana denu atahori mana seo mbui lunda ra nae, “Mendi sudꞌiꞌ a sa ia ra dea reu! Mamanaꞌ ia, nda mamana neseoꞌ sa! Afiꞌ tao Ama ngga Umen dadꞌi mamana sembo-danggan!” ");
INSERT INTO row_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Boe ma ana mana tungga nara rasanedꞌa Lamatualain Susura Meumaren suraꞌ oi, “Au sue ala seli Lamatualain Umen. Naeni de au rala ngga maꞌadꞌereꞌ de unea nara malolen.” ");
INSERT INTO row_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Boe ma atahori Yahudi ra malangga nara denu Yesus rae, “Mete ma memaꞌ muꞌena hak mbuu atahori ra onaꞌ naa, na, mutudꞌu manadadꞌi-manaseliꞌ esa neu hai fo dadꞌi bukti!” ");
INSERT INTO row_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesus nataaꞌ nae, “Mete ma hei tao milutu mamana meuꞌ ia, dei fo fini esan, na Au ufefela baliꞌ e.” ");
INSERT INTO row_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Te ara rasapaa rae, “Hambu sia bee? Huu atahori ra rafefela Ume Hule-oꞌe Huuꞌ ia dodꞌoon too haa nulu nee. Saa de duꞌa mae, bisa mufefela baliꞌ e fai teluꞌ a?!” ");
INSERT INTO row_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Te ara nda rahine rae, Yesus olaꞌ soꞌal Aon sa, onaꞌ mamana meuꞌ sa. ");
INSERT INTO row_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Dadꞌi sia fai maꞌabꞌuin, leleꞌ Yesus mate, basa ma nasodꞌa baliꞌ, dei de ana mana tungga nara rasanedꞌa saa fo Ana olaꞌ memaꞌ neu se. Boe ma ara ramahere saa fo Lamatualain Susura Meumaren suraꞌ mia fai maꞌahulun, no saa fo Yesus nafadꞌe memaꞌ neu se ena. ");
INSERT INTO row_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Naa, Yesus leo naꞌatataaꞌ mbei sia kota Yerusalem fo tungga fai malole Paska a sia naa. Boe ma atahori hetar rita manadadꞌi-manaseliꞌ fo Ana taoꞌ ra, de ramahere E. ");
INSERT INTO row_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Te Yesus nda namahere se sa, huu nahine basa atahori ra rala nara ena. Ana nda parlu atahori rafadꞌe Eni sa, huu mesaꞌ ne bubꞌuluꞌ memaꞌ atahori tetende-nemberiin ena. ");
INSERT INTO row_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Hambu atahori esa mia partei agama Farisi, naran Nikodemus. Eni, atahori Yahudi ra meser monaen esa. ");
INSERT INTO row_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Lao esa, ana nema tetembaꞌ nandaa no Yesus. Boe ma ana nae, “Ama Meser! Hai bubꞌuluꞌ oi, Lamatualain mana denu Papa fo munori hai. Huu manadadꞌi-manaseliꞌ fo Papa taoꞌ ra naa, ratudꞌu bukti oi, Lamatualain mana fee koasa naa neu Papa. Mete ma nda taꞌo naa sa, na, tantu manadadꞌi-manaseliꞌ naa nda dadꞌi sa.” ");
INSERT INTO row_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesus nataa nae, “Tebꞌe! Ma Au ae ufadꞌe taꞌo ia: mete ma atahori nda nenebonggi baliꞌ sa, na, ana nda dadꞌi Lamatualain atahorin sa.” ");
INSERT INTO row_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Boe ma Nikodemus natane nae, “Taꞌo bee fo atahori bisa nenebonggiꞌ onaꞌ naa, mete ma ana naꞌamoko ena!? Ana nda bisa baliꞌ lao ka ruan nisiꞌ maman tein rala neu, fo bonggi seluꞌ e sa. Nda bisa sa, to!?” ");
INSERT INTO row_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesus nataa nae, “Tebꞌe! Te Au ufadꞌe taꞌo ia: atahori musi nenebonggiꞌ no oe fo dadꞌi meuꞌ, ma nenebonggiꞌ no dula-daleꞌ a fo dadꞌi atahori feuꞌ. No taꞌo naa, dei fo ana bisa dadꞌi Lamatualain atahorin. ");
INSERT INTO row_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Huu atahori nenebonggiꞌ mia atahori, te atahori dula-dalen nenebonggi feuꞌ mia Lamatualain Dula-dalen. ");
INSERT INTO row_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Afiꞌ tabanganga mete ma Au ae, ‘Hei musi nenebonggi feuꞌ, fo hambu masodꞌa feuꞌ.’ ");
INSERT INTO row_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ata taꞌasasamaꞌ no anin. Huu anin humbu tungga hihiin. Hita rena muun, te nda bubꞌuluꞌ ana mia bee nema, ma nae bee neu sa boe. Basa atahori mana nenebonggi feuꞌ mia Lamatualain Dula-dalen o onaꞌ naa boe. Huu ata bisa tita Lamatualain Dula-dalen tao atahori dadꞌi feuꞌ ena, mae hita nda tahine tae taꞌo bee de dalaꞌ naa bisa dadꞌi.” ");
INSERT INTO row_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Basa ma Nikodemus natane nae, “Taꞌo bee de bisa dadꞌi taꞌo naa?” ");
INSERT INTO row_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesus nataa nae, “We, aꞌa. Aꞌa dadꞌi atahori Israꞌel ra meser monaen ena. Taꞌo bee de aꞌa nda nahine dalaꞌ ia ra sa? ");
INSERT INTO row_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Au ufadꞌe tetebꞌes. Naa, hai, naeni Au o atahori nggara, mihine dalaꞌ ia ra. Huu hai dadꞌi sakasii soꞌal dala-dalaꞌ fo hai mita no mata mara ena. Te hei nda simbo no maloleꞌ hai oꞌola mara sa. ");
INSERT INTO row_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Hei nda nau mimihere leleꞌ Au ufadꞌe dala-dalaꞌ manadadꞌiꞌ sia raefafoꞌ ia sa. Saa fai mete ma Au ufadꞌe soꞌal dala-dala manadadꞌi sia lalai a. Tantu hei nda mimihere tebꞌe-tebꞌeꞌ sa boe! ");
INSERT INTO row_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nda hambu atahori esa sa boe hene neu nataa mbali Lamatuaꞌ sia lalai a sa. Akaꞌ Au, naeni Atahori Matetuꞌ ia, mana onda nema mia E. ");
INSERT INTO row_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Fai maꞌahulun sia mamana rouꞌ, baꞌi Musa londa mengge riti esa sia hau ata, fo basa atahori mete rita e, fo ara hambu masodꞌaꞌ. Dalaꞌ onaꞌ naa boe o musi dadꞌi fee Au, Atahori Matetuꞌ ia. Dei fo ara rae londa doko-doko au sia hau ata, ");
INSERT INTO row_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","fo basa atahori mana ramahere Au hambu masodꞌa ndoo-tetuꞌ nda mana basaꞌ sa. ");
INSERT INTO row_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Huu Lamatualain sue-lai naseliꞌ basa atahori sia raefafoꞌ ia. Naeni de Ana denu Au, Ana isen ia, fo basa atahori mana ramahere neu Au nda saranggaa mia Lamatualain sa. No taꞌo naa, ara hambu masodꞌa ndoo-tetuꞌ nda etu ma nda basa sa. ");
INSERT INTO row_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Naa! Lamatualain nda denu Au, Anan ia, uma sia raefafoꞌ ia fo nggero-furi atahori huku-dokin sa. Te Ana denu Au fee masoi-masodꞌaꞌ neu atahori mia sala-kilu nara. ");
INSERT INTO row_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Lamatualain nda huku-doki atahori mana ramahere neu Au sa. Te Ana naꞌetu memaꞌ huku-dokiꞌ fee neu atahori nda mana namahere neu Au sa, huu atahori naa nda namahere neu Au sa, naeni Lamatualain Ana isen ia. ");
INSERT INTO row_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Onaꞌ taꞌo ia: Lamatualain haitua manggareloꞌ a nema fo naronda sia raefafoꞌ ia. Te atahori hiiꞌ a rasodꞌa sia maꞌahatuꞌ a. Ara nda hii rasodꞌa sia manggareloꞌ a sa, huu sira tataon nara nda maloleꞌ sa. Naa de Lamatualain nae huku-doki se. ");
INSERT INTO row_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Huu basa atahori nda mana tao maloleꞌ ra sa, binci manggareloꞌ naa. Ara nda hii manggareloꞌ a naronda sia se sa, naa fo manggareloꞌ a afiꞌ soi natudꞌu tatao deꞌulaka nara. ");
INSERT INTO row_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Te atahori mana tao tungga ndoo-tetuꞌ a, ara rema fo manggareloꞌ a naronda sia se. Huu manggareloꞌ a natudꞌu nae, sira tao tungga Lamatualain hihii-nanaun.” ");
INSERT INTO row_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Basa naa ma, Yesus no ana mana tungga nara lao hela kota Yerusalem, de leo raꞌatataaꞌ sia nusa Yudea. Ara sarani atahori sia naa. ");
INSERT INTO row_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Leleꞌ naa, Herodes se nda feꞌe tao Yohanis bui rala neu sa. Ma Yohanis o sarani atahori sia kambo Ainon, deka kambo Salim, huu oe mataꞌ hetar sia naa. Boe ma atahori akaꞌ rema sia Yohanis fo ana sarani se. ");
INSERT INTO row_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Naa, agama Yahudi hambu adꞌat esa fo tao nemeu aoꞌ, dei fo ara feꞌe bisa hule-oꞌe ena. Sia naa, hambu atahori Yahudi esa nareresi no Yohanis ana mana tungga nara soꞌal dalaꞌ naa. ");
INSERT INTO row_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Basa ma ara rema risiꞌ Yohanis de rafadꞌe rae, “Ama Meser! Musunedꞌa do hokoꞌ, Atahori fo mana sangga papa mia loe Yarden bobꞌoan, fo papa mae, Eni, Kristus? Ana o sarani atahori boe! Nda hambu rema sia hai sa ena! Huu basa atahori akaꞌ reu sia E!” ");
INSERT INTO row_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohanis nataa nae, “Taꞌo ia! Atahori nda bisa tao rala saa-saa sa boe, mete ma Lamatualain sia sorga nda soi dalaꞌ fee ne sa. ");
INSERT INTO row_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Hei rena au ufadꞌe relo-relo ena ae, ‘Au ia, nda Kristus fo hita tahaniꞌ a sa. Te Lamatualain denu au uma uꞌuhuluꞌ, fo soi dalaꞌ fee neu Kristus. Taꞌoꞌ a naa ena!’ ");
INSERT INTO row_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Conto, tou mana nae saoꞌ a naꞌena inaꞌ fo nae saoꞌ a. Te eni sakasii na, mana nambariiꞌ no eni, leleꞌ rena tou mana nae saoꞌ ola-olaꞌ na ralan namahoꞌo. Yesus naa, onaꞌ tou mana nae saoꞌ esa. Boe ma au ia, onaꞌ Eni sakasii na. Naeni de leleꞌ ia rala ngga namahoꞌo nala seli. ");
INSERT INTO row_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Pantin na, Eni musi bau dadꞌi atahori manaseliꞌ nakandoo, ma au bau umukura ukundoo dadꞌi atahori ana dikiꞌ.” ");
INSERT INTO row_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Yohanis tute oꞌolan nae, “Ana onda nema mia Lamatualain sia lalai, naeni de Ana monaeꞌ lenaꞌ mia basaꞌ e. Te au uma miaꞌ a raefafoꞌ ia, naeni de au onaꞌ basa atahori mana sia raefafoꞌ ia. Au olaꞌ soꞌal dala mana dadꞌi tungga-tungga fai sia raefafoꞌ ia. Te mana onda nema mia Lamatualain sia lalai a naa, Eni manaseliꞌ lenaꞌ basa e. ");
INSERT INTO row_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ana nafadꞌe soꞌal saa fo Ana nita ma rena ena. Te atahori nda simbo no malole saa fo Ana nafadꞌeꞌ a sa. ");
INSERT INTO row_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Mete ma atahori simbo saa fo Atahori mana nema mia ataꞌ naa nefadꞌen, naa o natudꞌu bukti boe oi, namahere Lamatualain oꞌolan naa, tebꞌe. ");
INSERT INTO row_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Atahori fo Lamatualain haitua nemaꞌ a, nafadꞌe Lamatualain hehelu-fufulin. Te Lamatualain fee Dula-dalen nda mana etu mana basaꞌ sa neu Eni ena. ");
INSERT INTO row_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Huu Amaꞌ sia sorga sue nala Anan seli. Ma Ana fee basa-bꞌasaꞌ e neu Anaꞌ naa liman ena. ");
INSERT INTO row_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ma atahori mana namahere neu Anan, ara hambu masodꞌa ndoo-tetuꞌ nda mana basaꞌ sa. Te atahori nda mana namahere neu E sa, ma nda tao tungga hehelu-fufulin sa, ara nda hambu masodꞌaꞌ naa sa, huu Lamatualain akaꞌ natudꞌuꞌ a nasan fo huku-doki se.” ");
INSERT INTO row_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Mete ma taꞌasasamaꞌ Yohanis no Yesus, na, Yesus ana mana tungga nara sarani atahori hetar lenaꞌ mana tungga E. Yesus nda sarani atahori sa, akaꞌ Eni ana mana tungga nara mana sarani atahori. Basa ma, leleꞌ Yesus bubꞌuluꞌ oi, atahori mia partei agama Farisi rena ara sarani atahori hetar lenaꞌ, ");
INSERT INTO row_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","boe ma no ana mana tungga nara lao hela nusa Yudea, de baliꞌ risiꞌ profinsi Galilea. ");
INSERT INTO row_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Te ara musi lao tungga profinsi Samaria fo losa profinsi Galilea. ");
INSERT INTO row_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ara lao, ma ara losa kota esa sia Samaria, naran Sikar, deka-deka no rae fo baꞌi Yakob fee neu anan Yusuf. ");
INSERT INTO row_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","8","Sia naa, hambu oe mataꞌ esa, naran ‘Yakob oen’. Reorendu boe ma, Yesus se losa naa. Ana namedꞌa bengge mia sira lalao nara, de Ana endoꞌ hahae aon sia oe naa. Boe ma Ana mana tungga nara lao hela mesaꞌ ne neu naa, de reu hasa nanaat sia kota rala. Boe ma inaꞌ esa mia kota naa nema haꞌi oe sia oe mataꞌ naa. Yesus noꞌe mbali e nae, “Aꞌa. Au bisa oꞌe oe nininuꞌ mbei, do?” ");
INSERT INTO row_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Te inaꞌ naa nggengger, huu atahori Yahudi nda nau raꞌabꞌue ro atahori Samaria ra sa. De ana natane baliꞌ Yesus nae, “Weh! Toꞌo atahori Yahudi. Au ia, atahori Samaria. Nda sala sa, do? Toꞌo moꞌe minu sia au e?” ");
INSERT INTO row_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesus nafadꞌe nae, “Taꞌo ia. Mete ma aꞌa bubꞌuluꞌ saa fo Lamatualain nae fee basa atahori, ma muhine Au mana oꞌe inu ia, Seka, na tantu aꞌa noꞌe oe mia Au. Boe ma Au fee oe mana nendi masodꞌaꞌ.” ");
INSERT INTO row_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Inaꞌ naa nae, “Toꞌo nda ma ember hahandoꞌ sa. Boe ma oe mataꞌ ia, roman seli. Mia bee nema Toꞌo hambu oe mana nendi masodꞌaꞌ naa? Oe naa hambu sia bee fai? ");
INSERT INTO row_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Tantu Toꞌo nda manaseliꞌ lenaꞌ hai baꞌi Yakob ma sa! Eni mana lao hela oe mataꞌ ia fee hai. Boe ma eni o ninu mia oe mataꞌ ia boe. Eni ana nara, ro banda nara o onaꞌ naa boe.” ");
INSERT INTO row_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesus nataa nae, “Musunedꞌa, e! Atahori mana ninu mia oe mataꞌ ia, dei fo ana naꞌamadꞌa seluꞌ fai. ");
INSERT INTO row_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Te atahori mana ninu oe fo Au feeꞌ a, dei fo ana nda naꞌamadꞌa seluꞌ sa ena. Huu oe fo Au feeꞌ naa, onaꞌ oe mataꞌ sa mana nasapupuraꞌ dea nema. Oe naa, nendi masodꞌaꞌ matetuꞌ nda mana etuꞌ sa.” ");
INSERT INTO row_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Inaꞌ naa nae, “Mete ma taꞌo naa, na, Toꞌo fee au oe naa leo, fo onaꞌ bee na, au sudꞌi boe uꞌumadꞌa fai! No taꞌo naa, au sudꞌi boe uma haꞌi usufafali oe sia ia fai.” ");
INSERT INTO row_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Boe ma Yesus denu nae, “Taꞌo ia. Aꞌa baliꞌ dei. Moꞌe aꞌa sao ma. fo baliꞌ uma sia ia.” ");
INSERT INTO row_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","18","Ana nataa nae, “Te au nda masaoꞌ sa.” Boe ma Yesus nae, “Tebꞌe. Mufadꞌe no rala ndoos. Huu sao ma lima ena. Boe ma mana sia aleꞌ ia, nda sao ma sa.” ");
INSERT INTO row_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Boe ma inaꞌ naa nae, “Awii! Ia naa au uhine ena, Toꞌo ia, Lamatualain mana ola-olan esa. ");
INSERT INTO row_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Naa, au ae utane. Hai atahori Samaria ra bei-baꞌi mara beꞌutee neu Lamatualain sia lete Gerisim. Te hei atahori Yahudi mae, mete ma nau beꞌutee neu Lamatualain, basa atahori musi reu sia Yerusalem. Tungga Toꞌo, matetun, taꞌo bee?” ");
INSERT INTO row_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesus nataa nae, “Aꞌa mumuhere neu oꞌola ngga ia dei, huu ia tebꞌe. Mae beꞌutee neu Lamatualain sia leteꞌ ia do, sia Yerusalem do, dei fo fai na nema, ruꞌa se nda raꞌena ngguna sa ena. ");
INSERT INTO row_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Hei atahori Samaria nda mihine naeꞌ sa, soꞌal mimihere neu seka. Te hai atahori Yahudi mihine naeꞌ, soꞌal Lamatualain fo hai beꞌutee neuꞌ a. Huu Ana nae pake hai fo soi dalaꞌ, naa fo atahori hambu masoi-masodꞌaꞌ mia sala-kilu nara. ");
INSERT INTO row_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Dei fo fai na nema, naeni mia leleꞌ ia, atahori mana beꞌutee tebꞌe neu hita Aman sia sorga, na, ara beꞌutee neu E tungga Dula-dalen, ma tungga ndoo-tetuꞌ a. Huu Amaꞌ sia sorga hii atahori mataꞌ naa ra mana beꞌutee neu E. ");
INSERT INTO row_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Huu Lamatualain naa, Dula-daleꞌ. De atahori mana beꞌutee neu E musi beꞌutee tungga Dula-dalen, ma tungga matetuꞌ a.” ");
INSERT INTO row_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Inaꞌ naa nafadꞌe nae, “Au bubꞌuluꞌ Mesias naa nae nema ena, naeni atahori ingga rae, ‘Kristus’, fo Lamatualain helu-fuli memaꞌ nae haitua nemaꞌ a. Leleꞌ Ana nema ena, na dei fo nafadꞌe basa-bꞌasaꞌ e neu nggita.” ");
INSERT INTO row_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesus nataa nae, “Ia eni, Au ena, fo mana ola-olaꞌ leleꞌ ia.” ");
INSERT INTO row_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Nandaa no leleꞌ naa, Ana mana tungga nara baliꞌ mia kota rala rema. Ara heran, huu rita E ola-olaꞌ no ina Samaria esa. Te nda hambu esa natane mbali inaꞌ naa nae, “Nau saa?” Boe ma nda hambu esa natane Yesus nae, “Saa de Papa ola-olaꞌ mo inaꞌ ia?” ");
INSERT INTO row_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Basa ma, inaꞌ a lao hela nggusi na sia naa, de lao baliꞌ kota rala neu. Boe ma ana dui neu atahori sia naa ra nae, ");
INSERT INTO row_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ima mete sobꞌa Atahori ia dei! Te Ana nafadꞌe relo-relo basa-bꞌasa saa fo au tao itaꞌ ra ena. Seꞌu-seꞌu te Eni ia, Kristus, fo Lamatualain helu nae haitua nemaꞌ a!” ");
INSERT INTO row_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","De atahori ra dea rema mia kota naa, de reu seꞌu E. ");
INSERT INTO row_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Leleꞌ inaꞌ naa feꞌe baliꞌ neu sia kota rala, Yesus ana mana tungga nara kokoe E rae, “Papa Meser! Uma mua dei!” ");
INSERT INTO row_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Te nataa nae, “Au uꞌena nanaat ena, te hei nda bubꞌuluꞌ sa.” ");
INSERT INTO row_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ana mana tungga nara esa natane esa rae, “Taꞌo bee, ia? Seka mana nema de fee Ne nanaat?” ");
INSERT INTO row_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Te Yesus nafadꞌe nae, “Taꞌo ia. Lamatualain denu Au fo tao tungga Eni hihii-nanaun, ma ulalao ue-tataon losa basa. Naa onaꞌ nanaat soaꞌ neu Au. ");
INSERT INTO row_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Naa, hei biasa memeteꞌ sia tine-osi, basa fo takseer mae, ‘Feꞌe fula haa fai, dei fo feꞌe bisa etu-oru ena.’ Rena, e! Au 