﻿USE sofia;
DROP TABLE IF EXISTS sofia.roo_vpl;
CREATE TABLE roo_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES roo_vpl WRITE;
INSERT INTO roo_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Voea-a voeao Jisas Krais aao iraraaro. Uva vaiterei-a vaitereo Ebraham vaio ora Devit rera aaotoareiaro ro Jisas. ");
INSERT INTO roo_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Oire uva Ebraham-a Aisak aitearo. Ari Aisak-a Jekop aitearo. Uva Jekop-a Juda aitearo ora araoko irara oaro. ");
INSERT INTO roo_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ari Judas-a Peres aitearo ora Sira vo araorei. Uva aakova oaesi-a o-ia Tema. Uva Peres-a Hesron aitearo. Uva Hesron-a Ram aitearo. ");
INSERT INTO roo_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ari Rama-a Aminadap aitearo. Uva Aminadap-a Nason aitearo. Ari Nason-a Salmon aitearo. ");
INSERT INTO roo_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Uva Salmon-a Boas aitearo. Ari aakova-a o-ia Rehap. Uva Boas-a Obet aitearo ari aakova o-ia Rut. Uva Obet-a Jesi aitearo. ");
INSERT INTO roo_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ari Jesi-a King Devit aitearo. Uva Devit-a Solomon aitearo. Oire uva Solomon aakoaro-a Yuraia vatuavaaro tuariri. ");
INSERT INTO roo_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Uva Solomon-a Riaboam aitearo. Ari Riaboam-a Abaisa aitearo. Uva Abaisa-a Esa aitearo. ");
INSERT INTO roo_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ari Esa-a Jehosafat aitearo. Uva Jihosafat-a Joram aitearo. Uva Joram-a Asaia aitearo. ");
INSERT INTO roo_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ari Asaia-a Jotam aitearo. Uva Jotam-a Ehas aitearo. Uva Ehas-a Hesekaia aitearo. ");
INSERT INTO roo_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ari Hesekaia-a Manasa aitearo. Uva Manasa-a Emos aitearo. Uva Emos-a Josaia aitearo. ");
INSERT INTO roo_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ari Josaia-a Jekonaia aitearo ora oeavu araoko irara oaro. Oire uva vo vuuta vao oa-ia vo arao touiva Jekonaia arao osa Babilon vata Isrel-pa irara ouiva voea tovosa vo tauai vego-ia Babilon-ia. ");
INSERT INTO roo_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Uva voa Babilon-ia toupaoro Jekonaia Sialtiel kavaureva. Oa iava Sialtiel-a Serababel aitearo. ");
INSERT INTO roo_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Uva Serababel-a Abaiat aitearo. Ari Abiata-a Elaiakim aitearo. Uva Elaiakim-a Eso aitearo. ");
INSERT INTO roo_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ari Eso-a Sedok aitearo. Uva Sedok-a Ekim aitearo. Ari Ekim-a Elaiat aitearo. ");
INSERT INTO roo_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ari Elaiat-a Eliesa aitearo. Uva Eliesa-a Matan aitearo. Uva Matan-a Jekop aitearo. ");
INSERT INTO roo_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ari Jekop-a Josep aitearo. Uva Josep-a Maria vatuatoaaro, o-ia iria Jisas kavaueva. Uva rera-a ro ira vaisiiva oiso, Krais. ");
INSERT INTO roo_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Oire uva Ebraham isivaaro iava katai tau vo resura (14) aao ora kavakavauaepa. Oa iava Devit-ia aue pura piropa katai tau vo resura (14) aaoro. Uva rera vo vuutaaro isivaaro iava ora kavakavauaepa. Oa iava oavu ita katai tau vo resura (14) aaoro ora puraaepa, voeao oea vo karekeepa vao-ia ovuuta-ia touiva vo Babilon-ia. Uva voa toupaoro Babilon-ia oavu ita katai tau vo resura (14) aaoro ora kavakavauaepa. Uva vo sara-a eva oa isivaaro iava Krais kavauroepa. ");
INSERT INTO roo_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Oire uva va-a vao Jisas Krais kavauaro iava vo siposipo. Uva aakova-a o-ia Maria iria reesiiva, oiso ra oira oureve Josep. Uva rera ou asavira toueva osa vagevagevira kakae kovu-ia taraiopa ora oira-ia vao oa purareva Tugoropato Uraurato. ");
INSERT INTO roo_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Uva rera ro oira oiratoaaro torevoko vovouto. Ira viapau oiso rugooparoepa ra reo goru sirova Maria arii piereve. Uva oiso ruipaparoepa ra oisivi raga oira kavureve. Reasiparoepa ra riro irara oira-ia taraiave. ");
INSERT INTO roo_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Oire uva va-ia Josep rirovira rugorugoo iraoparoepa, osa purapurapato enselto Turaro reraaro urioroepa aue-ia urusia rera iare. Uva oiso puraroepa purapurapato, “Josep, Devit aaotoaaro-a vii. Opeita uriripau riakova oara ou arapa Maria. Vo reo uvuri! Ari kakaeto karekeroi oira kovuaro-ia. Eera ira vaterevorao Tugoropato Uraurato oirapa. ");
INSERT INTO roo_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Uva kakaeto kavauevere, ra rera vaisiri oiso Jisas. Eake iava? Uvare oirara oaro rutu iava vuriara verareverea vara opesi pieoro, ra ora rerapa voea oureve vorevira vova vuria iava.” ");
INSERT INTO roo_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Vara rutu-a varao oiso karekeepa profet vo reoaro oirao piesa. Oreoa vatereva Turaro profet gisipoaro-ia oiso, ");
INSERT INTO roo_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","‘Uvuta! Oiso iriavu iria viapau oiratoa vaiva uusiopa iria oiso kakaeto kavaueve. Oa iava rera vaisiiverea Emanyuel.’ Uva vo vaisio oa vituaro oiso toupai, Pauto vigei tapo toupareveira. ");
INSERT INTO roo_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Oire uva Josep uusia iava toreroepa. Oa iava oiso piereva osa Turaro purapurapatoaaro rera tavireva. Oa iava oira oureva Maria. ");
INSERT INTO roo_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Uva viapau oiso oira tapo oisoa uusiparo vore osa kakaeto kavaueva. Oa iava oiso rera vaisireva, Jisas. ");
INSERT INTO roo_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Maria Jisas kavaueva Betlehem urui-ia vo Judia taere-ia, vo osa voa oisoa Herot turaroparo. Oire uva vo vuuta-ia eva oeavu riro tarai irara aaviikoara-ia oea taraioro urioaepa Jerusalem iare tauai iava, vo uva ravireo kae uviroparoveira. ");
INSERT INTO roo_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Uva oiso akeiva, “Ovu-ia kakaeto kavauroe ro Turaro oae Jiu? Igei aaviiko sirova utuie iria rera reesipae. Iria kae oviro vova uvava ravireo kaeparo viroveira. Oa iava urioiei rera-ia vuurapa vaisi purasa.” ");
INSERT INTO roo_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Oire uva King Herot vo reo uvureva. Oa iava rikerikeparoepa rirovira uriripaoro ora voea rutu voeao Jerusalem urui sovara-ia. ");
INSERT INTO roo_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Uva Herot va iava reipa irara gurureva voeao pris irara oea oisoa tauopaave, ora riro tarai irara oea oisoa taraipaave aue-ia Reo Taisi. Oa iava voea akepareva oiso, “Aa vo uruio-ia kavaurovere Krais?” ");
INSERT INTO roo_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Uva rera taviiva oiso, “Ari Betlehem urui-ia vo Judia taere-ia osa profet irara voari tuariri Pauto vo reoaro rigatoiva oiso, ");
INSERT INTO roo_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Vii vao vo Betlehem urui-a vo rasio-ia vo Judia taere-ia. Viapau oiso gare vaisi urui-a vii vo Judia taere sovara-ia. Uvare vii sovara iava iravu reito karekeroverea. Ira ragai voeaaro tuvetuvereverea voea tokioro voeao Isrel.’ ");
INSERT INTO roo_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Oire uva oisi-a eisi osa iava Herot oavu iare vataua paua riro tarai irarare keeraroepa voeao oea oisoa aaviikoara-ia taraipaave. Oa iava oiso voea akereva, “E ovirovu voki putevoiva, o-ia taraitae vo osa kaeo viro?” ");
INSERT INTO roo_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Oa iava voea arureva Betlehem iare. Uva oiso voea tavireva, “Kasikasi pievira rutu rerare taraasa avata. Ra rera keketavora, ragai tavisa voreta. Ra ragai tapo rera-ia vuurapa vaisi puraa.” ");
INSERT INTO roo_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Oire uva King Herot vo reoaro uvuiva. Uva avaaepa. Oa iava oira eira aaviiko kekeiva oira raga iria keke rovoiva, iria vova kaeo viropa uva ravireo kaeparo viroveira. Uva vo kepao aivaro rueva uvavi-ia kakaeto toupareva. ");
INSERT INTO roo_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Oire uva aaviiko kekeoro voeare vovouisiro roru iraova rutu. ");
INSERT INTO roo_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Uva koataaepa vo kepa-ia kakaeto kekesa ora rera aakovaaro Maria. Oa iava voa kokoto rekuoro takua viropa rera-ia vuurapa vaisi puraoro. Oa iava moni tagiro oaive karuiva. Oire va iava rerapa oaravu vatevateara vateiva auero gol, ora frankinsens avuo geesi ovi, ora oavu mer vearo geesia iisi ovi. ");
INSERT INTO roo_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Uva urusia-ia Pauto oiso voea vosireva, “Teapi vorepata Herot iare.” Oire uva va iava oraivavu raga gaeoro kareaepa voea vo taerearo iare. ");
INSERT INTO roo_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Oire uva kareaepa vo aao kavuoro. Oa iava enselto Turaro reraaro Josep iare karekeroepa urusia-ia. Uva oiso puraroepa rerare, “Toreu ra ovii avaorei oarava tapo avau torioro Isip iare. Uva voa toupatavere Isip-ia ragai vo reoarore tuepaoro. Oa-ia vii taviavere ra kareu vorevira vo avaoreiva, uvare Herot kakaeto uposa rerare taraaparevere.” ");
INSERT INTO roo_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Uva va-a vao oa iava Josep aao ora vaseaepa vokiaro Isip iare. ");
INSERT INTO roo_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Uva voa touiva osa Herot kopiiroepa. Uva oisi-a oiso osa pura piropa profetato vo reoaro oirao piesa oiso osa vo reo vatereva Turaro Pauto tuariri oiso puraoro, ‘Ragai oviitoa oaare keeraraepa Isip-ia kavusa.’ ");
INSERT INTO roo_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herot oiso tarairoepa, Voeao aaviikoara-ia taraipa irara ragai keaivora. Oa iava rirovira rutu kasipu iraoparoepa. Uva oeavu arureva vo kakaero rutu uposa oea vo peva ivaro-ia tugura asavira toupaiva vo Betlehem urui-ia, ora vo uruiro ouruiroa tutuu pie visivi oisoa toupaive. Aue iava uvare vaore rugooroepa osa tarai irara aaviiko iava rera taviiva oiso, Tuariri o aaviiko kaeo viropa. ");
INSERT INTO roo_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Oire uva oiso osa varao puraiva Jeremaia vo reoaro oirao pieoro ro profet. Uvare oisi puraroepa voari tuariri oiso, ");
INSERT INTO roo_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","‘Gau guruko uvuivoi Rama urui-ia, sirao pie guruko rutu. Ovusa Resel gau iraopaevoi ovii irarapa. Uva viapau irai uvuiparoi ra oira vovouaro sisireve, uvare ovii vure rutu viapau toupai. Oea rutu kopiiae.’ ");
INSERT INTO roo_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Uva Herot vo kopiiaro isivaaro iava Turaro Pauto reraaro enselto Josep iare karekeroepa urusia-ia, vo osa Isip-ia toupareva. ");
INSERT INTO roo_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Uva oiso puraroepa, “Toreu! Ra ovii avaorei oarava ora vaseu Isrel iare. Ari ro kopiiroera ira kakaeto uposa aueparoera.” ");
INSERT INTO roo_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Oa iava Josep ovii avaoreiaro tapo avaroepa Isrel rasi iare. ");
INSERT INTO roo_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Uva voa pou virooro Akeleas iava uvureva, uvare aiteto Herot vo tavukiaro oureva. Uva Judia taere-ia turaroparoepa. Eva-a oa iava Josep rirovira uririparoepa voa tou arapa. Uva Pauto oavu-ia urusia Josep ravaavira tavireva. Oa iava Galili taere iare avaroepa ");
INSERT INTO roo_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","voa tousa atoia Nasaret urui-ia. Oire uva eisi osa piereva oiso osa va puraiva profet irara voari tuariri. Oreoa oirao piereva oisi voa touoro, uvare oiso puraaepa, ‘Ira vaisiiverea oiso, Nasaret-pato.’ ");
INSERT INTO roo_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Uva vo voki-a vao oa-ia Jon Baptais urioroepa raaka tapi tousa oiso Judia-ia. Uva voa oiso siposipo rovoroepa. ");
INSERT INTO roo_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Oa-ia oiso puraroepa voeare, “Sopaura oavisii poreta, ra vuri vovouro kavuta. Uvare Pauto vo Saraaro tutuu pievoi, ra karekepe vova vuvuiua iava.” ");
INSERT INTO roo_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Rera ro Jon ira iava taviroepa profet Aisaia ira oiso puraroepa, ‘Iravu ira keeraparoi vo raaka tapi oiso purapa, Turaro vo raivaaro vatatopopata va ravaaoro oa-ia pouro viroverea.’ ");
INSERT INTO roo_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Oire uva Jon apota visivi toupaoro aue kamel oruaro iava oisoa rera-ia kuvuparo kuvupato ora takipa iro aue iava bulmakau rakari. Uva aio oaro-a vao-ia siiko ora koisi. ");
INSERT INTO roo_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Uva vo voki-a vao oa-ia voeao Jerusalem vata, ora voea rutu vova Judia distrik, ora voeao vova Jodan taere-ia rutu urioaepa rera iare Jon. ");
INSERT INTO roo_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Oa iava vuri vovouro oaive kosi pieiva rera iare. Osa iava Jon voea-ia Tugoropa Sisu Baptais purareva vo uukova-ia o Jodan. ");
INSERT INTO roo_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Oire uva Jon riro irara kekereva lotua-ia irapa irara voeao Farisi-pa irara ora oearovu Sadyusi-pa irara, oearea rutu urioaepa Baptais ousa. Oa iava voeare oiso puraroepa, “Visii vao rakoru ovii iraraaro vuri irara. Irouto visii vosipare, oa iava toripata Pauto vo kasipuaro asavira? ");
INSERT INTO roo_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Visii iava sopaura poreta, ra vuri vovouro oavisii kavuta. Oa iava oirao pie vovou oavisii poeravira karekepere oearovupa. ");
INSERT INTO roo_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Opeita oiso vovoupata ora visii raga vovouaro-ia, Ebraham-a igei aitearo oa iava igei-a Pauto oiraraaro rutu. Easi Pauto raga uvuipa vo avekero iava kakae vure purareve. Ra oiso pieive, Ebraham ovii iraraaro. ");
INSERT INTO roo_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Torara eira iriaei ravaavira evaova vituaro-ia. Oire vo evaro oiso toupai osa visii, varao oara viapau oiso vearovira kuepape oara rutu taru toepaiverea vara vikipasa tuitui kasi-ia. ");
INSERT INTO roo_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Ragai visii baptaispaavoi uukoa raga-ia visii reesioro visiigoa vovouisiro oavisii poretavora. Ari ro ira ragai sirova uturovere, ira vo goruaro ragai vo goruaro-ia putevere, uvare rei vaisito-a. Uva viapau uvuiparai ra rera vaaro tasipa kaea, uvare akukuto-a ragai. Ari rera visii vaterevere vao baptaisa Tugoropato Uraurato vaaro visii reesipaoro Tugoropato Uraurato vo goruaro-ia ora tuituia vo goruaro. ");
INSERT INTO roo_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ira vururua-ia pitupare wit ragipasa oira rakariaro verapaoro. Oa iava oira aioaro orirurevere vo aio kitupa tapi oira rakariaro vikioro tuitui kasi-ia vao roko asa kasi.” ");
INSERT INTO roo_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Vo voki-a vao oa-ia Jisas Galili-ia kavureva uuko ovi iare avaoro vao Jodan, oiso ra baptaisa oureve Jon vavaearo-ia. ");
INSERT INTO roo_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Osa Jon rerare korukoruparoepa oiso purapaoro, “Ae, apeisi ragavira ragai iare uriouei? Easi ragai uvuiparai ra vii ruvara-ia Baptaisa oua?” ");
INSERT INTO roo_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Oire Jisas rera vo reoaro pukoreva oiso puraoro, “Eagara, oisi va purave Pauto vo vovouaro sirova utuoro.” Oa iava Jon rerapa vasereva. ");
INSERT INTO roo_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Oire Baptaisa oureva Jisas. Uva ikauvira uuko ovi iava veraro viropa osa vuvuiua karu piropa. Uva Pauto reraaro Tugoropato Uraurato kekereva osa oiso vararoepa osa kurue. Uva Jisas-ia pitusa rerereva. ");
INSERT INTO roo_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Oa iava reoreoa varaepa vuvuiua iava oreoa-ia oiso puraroepa Pauto, “Rera-a eera Oviitoa oaa. Ira kavikopaaveira rutu rera-ia rorupaoro.” ");
INSERT INTO roo_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Vo Tugoropato Uraurato Jisas siporeva kuvau rasi iare vo uva viapau oirara vai toupaive. Uva voa Seten rera-ia kokara ragaparoepa. ");
INSERT INTO roo_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Uva Jisas oisoa aio kavuvira toupareve varao-ia vo resura tau (40) vokiro ora vo resura tau (40) ruparo. Oa iava ogoeroepa. ");
INSERT INTO roo_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Uva rera ruvara iare kokarapato tutuu piereva oiso purasa, “Vosa vii Pauto Oviitoaaro rutu, oire ore aveke reou ra opovira ora poreo.” ");
INSERT INTO roo_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Uva Jisas rera aatoreva rera vo reoaro tuuoro oiso, “Tugoropa Reo oiso purapai, ‘Viapau oiso opoa raga tootooa vatepai oiratoapa. Ari oirato uvuiparoi ra tootooa oupareve vo reoro-ia oara vatepareveira Pauto.’” ");
INSERT INTO roo_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Uva va-a vao oa iava Seten rerava avaroepa ouruivu iare Jerusalem urui Rovopa Kepa Tugoropa Kepa kukuearo-ia rera tovosa viara-ia rutu. ");
INSERT INTO roo_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Uva rera tavireva, “Vosa vii Pauto Oviitoaaro rutu, oire ora vikiu vova rasiuaarore. Aue iava uvare Tugoropa Reo oisi purapai, ‘Ari ita, ensel irara oaro arurevere Pauto, ra vii pituive vo ora voea vavaearo-ia. Ra viapau vii iava kokotoa tatu piro avekeara-ia.’” ");
INSERT INTO roo_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Uva Jisas rera tavireva ita oiso, “Tugoropa Reo oiso purapai, ‘Opeita Turaro Pautoa oavisii-ia kokarapata.’” ");
INSERT INTO roo_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Oire va iava Jisas oureva aia ita Seten oavu iare pukuia-ia riro kaekae pukui. Uva voava varao rutu-ia osararovu rutu Jisas kareke piepareva Seten, varao kekekeke pie sararo vo rasio iava. ");
INSERT INTO roo_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Uva va iava oiso puraroepa Seten, “Vosa ragai-ia vuurapa vaisi purari ragai iare taku virooro, oire eva-a oa iava vii vateavere osararovu rutu.” ");
INSERT INTO roo_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Osa iava rerare oiso puraroepa Jisas, “Verau Seten! Tugoropa Reo oiso purapai, ‘Pautoa raga-ia vuurapa vaisi purapata eera visii reraaro Turaro. Rara rera raga vo kovoaro purapata eera Kataitoa raga.’” ");
INSERT INTO roo_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Uva oisi-a eisi osa iava Seten rera kavureva. Oa iava oearovu enselpa irara urioaepa Jisas tauvasa. ");
INSERT INTO roo_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Uva Jisas Jon iava uvureva osa rera tovoiva tuukepa kepa-ia. Oa iava Galili taere iare avaroepa. ");
INSERT INTO roo_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Oire uva voava Nasaret-ia kavureva Kapaneam-ia toupasa. Uva voa vo Kapaneam urui oa Galili rovu ruvara-ia toupaiveira. Oiso ragavira Sebyulan Distrikrei sovara-ia ora Naptalai. ");
INSERT INTO roo_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Vo taererei iare avaoro profetato Aisaia vo reoaro oirao piereva oreoa-ia oiso puraroepa Jisas iava, ");
INSERT INTO roo_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","‘Vo rasio Sebyulan ora vo rasio Naptalai vo raivao-ia vore toko rovu Jodan-ia toapaoro Galili-ia rupa vovou irara voaaro. ");
INSERT INTO roo_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Voeao oirara rutu oea rupa pitupitu-ia oisoa toupaive oea riroa aviavia kekeiverea. Ora voeao-ia roroverea riroa aviavia, oea vo urauraaro kopiivira toupaiveira vo ovusa rupa rugoovira toupaiveira.’ ");
INSERT INTO roo_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Vo voki-a vao oa-ia Jisas ora rera vo siposipoaro rovoreva. Va poerapaoro oiso puraroepa, “Poreta viro vuriara oavisii iava. Ari Pauto vo Saraaro vova vuvuiua oa tutuu pievoi!” ");
INSERT INTO roo_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jisas vokapareva toko rovu vatuaro-ia vao vo Galili. Uva voa vo araoreo kekereva Saimon araorei, ro ira oisoa oiso vaisipaive Pita ora araokoto Andru. Vo osa kuverava vikivikipasiva toko rovu-ia, uvare vo kovo purapatoarei-a aue atari. ");
INSERT INTO roo_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Uva vaiterei tavireva Jisas oiso, “Ragai sirova utusi, ra vei siposipoa oira ivupasa ragai iare.” ");
INSERT INTO roo_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Uva ikauvira kuverava kavusiva rera taveosa utuoro. ");
INSERT INTO roo_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Oire gare visivi vokaoro avaroepa. Oa iava vo araoreo-ia pouro viropa Jems araorei ora Jon, Sebedi oviitoareiaro. Osa oavu sovara-ia toupaiva uvuoa ora ro aiteto Sebedi. Uva voa kuverava torevokopaiva oira rekorekopaoro. Uva voa vo araorei kekeoro vaitereire keeraroepa. ");
INSERT INTO roo_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Oa iava ikauvira uvuoa kavusiva ora aiteto tapo Jisas sirova utuoro. ");
INSERT INTO roo_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Voraro rutu virireva vo taereo-ia vao vo Galili vo oirara rutupa siposipopaoro Reo Taisi Uvupa Keparo-ia aue Sinagog voea varaaro. Uva voeapa Vearo Siposipo kosi piepareva aue iava Pauto vo Saraaro. Oa iava oupiarovu iava oirara porete piepareva, ora orekerovu rutu varao oara oisoa varaura vuri piepaive oirara rutu iava. ");
INSERT INTO roo_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Siposipoara rutu viriva rera iava voraro ruture Siria taere sovara-ia. Uva va-a eva vituaro iava vuri upia irara rutu sipopaiva rera iare osasararovu rutuva aue upia, ora voearo oearoa-ia oisoa vuri tugararo toupaive, ora voearo oearoa koakoapeko upiarova oisoa toupaive, ora voearo oearoa oisoa kerau upiarova toupaive. Oa iava voea rutu porete piereva. ");
INSERT INTO roo_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Uva riro irara rutu vova Galili taere, Dekapolis uruiro, Jerusalem-ia, ora Judia-ia, ora vova uukova Jodan ivirovira oearoa rutu rera sirova utupaaepa. ");
INSERT INTO roo_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Uva riro irara kekereva. Oa iava iparoepa pukuia-ia. Uva voa rera utuoro ora guruaepa rera voeaaro disaipel. Oa iava voea rutupa voa siposiporeva pauvira toupaoro. ");
INSERT INTO roo_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Oire uva Jisas voea vatepareva reoa oiso purapaoro voeare, ");
INSERT INTO roo_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Oire voeao oea apotavira toupaiveira oea roruiverea. Aue iava rara oiso ora voea-ia taraipaave, Igei apota irara Pauto vo taraiaropa evoea oea Pauto vo Saraaro-ia toupaiveira. ");
INSERT INTO roo_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Ari voearo oearoa gaupaive siraopaoro, oearoa roruiverea, aue iava rara Pauto voeapa gavaurea vatereve. ");
INSERT INTO roo_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Ari voearo oearoa kave vovouvira toupaiveira, oearoa roruiverea. Aue iava rara voeapa vara rutu vatereve Pauto varao oarare voeapa reo ovoi purareva vara vatesa ora rera vo Saraaro iavirava. ");
INSERT INTO roo_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Ari voearo oearoa ovovourovu rutupa torevoko vovouro ruipa iraopaave, oiso osa ro ira ogoeparo auepa aio ora rogepareve auepa uuko, evoearo oearoa roruiverea. Uvare Pauto voea vo ruiparoaro uvui pieoro vateroverea voeapa. ");
INSERT INTO roo_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Ari voearo oearoa oearovupa siraopaave oea roruiverea, rara Pauto voeapa siraoro. ");
INSERT INTO roo_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Ari voearo oearoa airerei vovouvira toupaiveira, oearoa roruiverea, rara Pauto kekeive. ");
INSERT INTO roo_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Ari voearo oearoa gavaure vovou kataia goru piepaiveira vo oirara rutu ruvara-ia, oearoa roruiverea. Oeare oiso puraroverea Pauto, Ragai ovii iraraaro visii. ");
INSERT INTO roo_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Ari voeao oea Pauto vo ruipaaro sirova toupaiveira, oire va iava vuria oupaiveira voeao ruvara-ia oea viapau oirao pie vovouro vai, oea taru roruiverea, uvare Pauto vo Saraaro-ia toupaiveira. ");
INSERT INTO roo_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Ari vosa visii kekepaive vo osa ragai sirova utupataveira. Oire visii takaupaive ora visii vuri piepaive, ra oreoreorovu rutu purapaive kuuvu vaisiro visiire ragai iavirava, visiigoa rorutaverea. Oire vo osa oisi eisi visii piepaive visii vuri piepaoro, ra roru iraopata. ");
INSERT INTO roo_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Uvare riroa toupai voria visii vaaro vuvuiua-ia. Ari ita, voari tuariri uva oiso ragavira profet irara oisoa tariopaive voea-ia vuri pitupituro purapaoro, voeao profet irara oea visiipa oisoa irapaave. ");
INSERT INTO roo_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Oire visii vao oiso toupata osa avaka voeapa vo rasio-ia. Ari vosa avaka vo sipeiaro opesipe, ra apeisi ragavira vorevira avaka vo sipeiaro vorepe? Ari vosa oisi pieive vovueooro, ra viapau kovoa vaiaro va vao avaka. Oa iava va vikipaive, ra voava va-ia tasiasipaive oirara rutu. ");
INSERT INTO roo_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Visii-a vao visiigoa oiso toupata osa aviavia rasito vaaro. Oire vosa oai riro urui vai toupaive pukuia vai kukuearo-ia, ra viapau voa utopape. ");
INSERT INTO roo_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Vosa iravu vuravu rukuereve, oire ra viapau oiso oira tovoreve baket sopaaro-ia. Ari uvuipa ra oira tovoreve viaevira tebol ivara-ia. Ra voava kepa rutu sopaaro-ia roropaeve voea rutupa aviavia vatepaoro. ");
INSERT INTO roo_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Eisi osa aviavia oavisii roro piepata vo oirara rutu osireiaro-ia. Ra vearo kovo oavisii kekepaive vao oa purapata. Oa iava Aite oavisii vaisiaro kae piepaivere ro vova vuvuiua. ");
INSERT INTO roo_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Opeita oiso rugoopata, Ragai uriorai Reo Taisi verasa vao Moses vaaro ora voeao profet irara. Viapau! Easi, va uvui piesa uriorai vo reoro rutu oirao pieoro. ");
INSERT INTO roo_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Oiraopavira rutu visii tavipaa, Oa-a vao Reo Taisi oa vo tugurasa osa auero rutu karekeperea varao oara Reo Taisi sovara-ia toupaiveira. Uva vuvuiua opesiperea ora rasito, ari viapau oavi gare rigatovi vai opesiperea vova Reo Taisi Pauto vaaro. ");
INSERT INTO roo_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Oire vosa ro ira oavivu gareavi putepareve vao iava Reo Taisi, ora vosa oearovu tarai piepareve oisi piepasa, ira vaisiaro gareroverea vo Pauto vo Saraaro-ia. Ari vosa ro ira vearovira Reo Taisi sirova utuparoveira oirara rutu tarai piepaoro oisi piesa, ira riro vaisi oureverea vo Pauto vo Saraaro sovara-ia vao vo vuvuiua. ");
INSERT INTO roo_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Visii tavipaavoi oiso, Vosa torevoko vovouro oavisii viapau Farisi vo vovouroaro-ia puteve varao torevoko vovouro ora voeao Reo Taisi-ia tarai irara, oa iava viapau uvuipatai ra Pauto vo Saraaro-ia koatata. ");
INSERT INTO roo_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Oire vo reo uvutavora oreoa ouiva aao irara oavi oa oiso purapai, ‘Opeita oira upopau. Oire vosa iravu visii iava iravu uporeve, uva rera-a eera ira kortua-ia kosiro viroverea.’ ");
INSERT INTO roo_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ari ita, visii tavipaavoi oiso, Ro ira araokotoaarore kasipuparo ira rovirieia-ia kosiro virovere. Ora ro ira araokoto oaro takaupareve eera-a ira rovopatoa-ia kosiro virovere kaunsel. Ora ro ira oiso puraro, Vii-a kokoropatoa rutu, ira tuitui kasi iare avaroverea vo kasio oa viapau rokopaive. ");
INSERT INTO roo_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Oire vosa rovopa kue oavisii vatesa tapo auepata Pautoa iare roru vaisi purapaoro, oire araokotoa oavisiire rugoo rovota, uvare rera-ia reoai visiire kasipua. ");
INSERT INTO roo_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Oire rovopa kuero oavisii tovo rovota rerava ora reo rovosa. Ra kasipua opesi pie rovota. Oire ra voreta taru rovopa kue oavisii vatesa. ");
INSERT INTO roo_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Vosa iravu visii tovosa aueparo kortua-ia, oire uva uvuipatai ra ikauvira rera tapo ora agiagi rovota. Teapi rera visiiva avaro reo rovirieipato vavaearo-ia visii tovosa. Oa iava visii vaterevere polis irarapa. Oire evoea visii tovoive tuukepa kepa-ia. ");
INSERT INTO roo_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Visii tavipaavoi oiraopavira oiso, Vosa vao visii vaaro voria vo osa tuukepa kepa-ia toupata. Ra viapau va rutu opesi pieta ropa reo rovirieipato, ra viapau oiso tuukepa kepa iava kosi uvirota. ");
INSERT INTO roo_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Visii vao vo reo uvutavora oa oiso purapapeira, ‘Opeita ora oupa oaesi vuri piepasi.’ ");
INSERT INTO roo_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ari ita, oiraopavira oiso visii tavipaavoi, Vosa iravu iriavu kekereve riakova, ra rerare sopaua ora sitape oirava garagarakooro. Oire ra va raga rerapa vo vovou purave oirare o riakova. Uva va-a eva oa-ia reo goru gasire vao ora oupa taisi vaaro. ");
INSERT INTO roo_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Vosa ro oirapapato osireito vii kove piereve vuria iare, oire rera tateri rera-ia vikisa. Vearopai vosa orekerovu vova varaua opesipe. Ra viapau oiso ita vii iava varaua oara rutu vikiive vore tuitui kasi vao oa viapau rokopaive. ");
INSERT INTO roo_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ora vosa oirapapa vavae vii kove pieive vore vuria, oire vo vavae tokori va-ia vikisa. Vearopai vosa orekerovu vova varaua oara opesipe, ra viapau oiso vii iava varaua oara rutu vikiive vore tuitui kasi vao oa viapau rokopaive. ");
INSERT INTO roo_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Tuariri vo reo karekeepa oiso, ‘Vosa iravu oirato iriavu kavureve riakova, oire oira vatereve oavu pepa vao oa-ia reo goru iava oreovu toupaive, oiso ra viapau oira oureve vorevira.’ ");
INSERT INTO roo_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ari ita, visii tavipaa oiso, Vosa ro ira riakovaaro kavureve o iria viapau otopa pitupitu purapaeve, eera-a ira riakova oaro takau pierevoi reo goru-ia vao ora oupa. Oire ra iravu oueve. Osa iava rera tapo ita reo goru gasirevoi ora oupa. ");
INSERT INTO roo_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Oire oavu reoa vao oa ouiva aao irara oavisii tuariri oa iava va uvutavora. Oa oiso purapai, ‘Opeita vii vaaro reo ovoi puteri. Ari varao purari rutu oarare reo ovoi purarivora Turaropa vara purasa.’ ");
INSERT INTO roo_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ari ita, visii tavi iraopaa oiraopavira oiso, Opeita viara-ia vaisi ragapata reo ovoi purapaoro. Viapau rutu uvuipatai ra vuvuiua vaisi ragapata oreorovu goru pie ragapaoro. Eake iava? Uvare paupa tugoropa Pauto vaaro aue vuvuiua. ");
INSERT INTO roo_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ora opeita rasitoa tapo vaisi ragapata vo oreorovu goru pie ragapaoro. Oavu eva garea paupa oaro Pauto vo rasito uva tasipareveira. Ora viapau uvuipatai ra Jerusalem-ia vaisi ragapata vo oreorovu goru pie ragapaoro. Uvare rei-a urui Turaro vo uruiaro. ");
INSERT INTO roo_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ora opeita ora visii kukuearaaro-ia rei piepata oreorovu ora visii vo rugooaro-ia. Aue iava uvare viapau rutu uvuipatai ra kukue iava oavu orua popote pieta, eke voua rupa pieta. Viapau rutu. ");
INSERT INTO roo_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","O ita, uvuipatai oiso purapasa, Iu ita! ora Viapau rutu! Ari vosa ovaisivu outavere ita uvavuva va siguvasa va vao Iu ora Viapau, ra oiso purape, Seten vaaro. ");
INSERT INTO roo_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Ari ita, visii vo reo uvutavora oreoa tuariri karekeepa oiso, ‘Vosa iravu vii osireiaro vuri piereve, oire vii ita rera osireiaro vuri pieri. Ari vosa iravu vii reuriaro vuri piereve, oire ita vii ita rera reuriaro vuri pieri.’ ");
INSERT INTO roo_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ari ita, oiraopavira visii tavipaavoi oiso, Opeita voearova ora tuutuukopata oea visii-ia vuria pura rovopaive. Vosa iravu visii tautauaraaro tapareve, oire rerapa ita ovaratavu poreta aia. ");
INSERT INTO roo_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ari vosa iravu visii tovo vovouparo kortua-ia, ra visii reraaro oureve siglis, oire vo popota rutu vateta ora kuvupato. ");
INSERT INTO roo_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ari vosa irouto riroto visii kae piereve orekevu-ia, oiso ra katai vuuta-ia va kaepaoro vokata. Oire rera tavita oiso, Erao vuuta-ia viipa va kaepaio. ");
INSERT INTO roo_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ari vosa ro ira visii arepareve orekevure, oire rera vateta. Ora vosa ro ira visii ruvara-ia ou ragasa aueparo, opeita rerare isivapata. ");
INSERT INTO roo_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Ari ita, vo reo uvutavora oa tuariri karekeepa oiso, ‘Vii vao voeaopa siraopau ora vii vate iraraaro. Oire ra voeao raga tapo ora kasipupau oea viiva ora keripaave.’ ");
INSERT INTO roo_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ari visii oiso tavipaa, Katai vovou purapata voeaopa siraopaoro oearoa visiiva ora keripaave. Oire Pautoa iare variripata ra voea tauvapareve voeao oea visiire vuri vovoupaave. ");
INSERT INTO roo_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Eisi osa iava oiso uvuipatai oiso kareketa, Aite ovii iraraaro visii ro ira vuvuiua-ia toupareveira oirara rutupa siraopaoro. Oiso osa ravireo kae piepareveira voeaopa vuri irara ora vearo irara. Ora aue tapo kokeva kove piepareveira voeaopa torevoko irara ora voeaopa tapo riro vakuvaku irara. ");
INSERT INTO roo_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Vosa voeao ragapa siraopata oea visii tapo ora agiagipaaveira, ra eake vori outa rera ruvara-ia Pauto va iava vao? Easi voeao vuri irara takis oupa irara oea vai pasi viapau oisi vai piepaiveira tapo oiso, raa? ");
INSERT INTO roo_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ari vosa vate irara oavisii raga tapo ora reopata, ra va iava rei vaisi outaverea, raa? Viapau. Uvare voeao rupa vovou irara tapo oisi piepaiveira oiso. ");
INSERT INTO roo_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Oisi vo vovouo purapataveira osa vo vovouo purapareveira Aite oavisii ro vuvuiua-ia touto torevoko vovoutoa rutu. ");
INSERT INTO roo_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Oire visii vao-ia vatatopo iraopata. Teapi taavoko ragapata oearovu osireiaro-ia visii varaaro purapaoro vearo pitupituro. Vosa oisi piepatavere, ra viapau voria vai oavisii outa vo Aite oavisii ruvara-ia vo vuvuiua-ia. ");
INSERT INTO roo_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Vosa apota irarapa orekerovu vatepata voea tauvapasa, ra opeita va kareke piepata oirara rutu osireiaro-ia. Uva va-a eva osa voearo toupaiveira riro kuuvu irara oearoa oiso varao-ia utavepaaveira vo Reo Taisi Uvupa Kepa aue Sinagog vo raivara sirova ora voea vaisiaro rei piepaoro. Uva oisi-a eisi osa oiraopavira rutu visii tavipaa oiso, Voea-a evoea riro kuuvu irara oea voria oaive ou ovoiivora ora voea vaaro. ");
INSERT INTO roo_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Oire vosa apota irara tauvapata, ra viapau oiso voearo tavitavipata va iava vate irara oavisii vao iava oa purapata voeapa vatauvira. ");
INSERT INTO roo_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Oa-ia taraipa Aite oavisii osa eisi vara purapatavoi rera osireiaro-ia. Oa iava va-ia voria outavere Pauto ruvara-ia. ");
INSERT INTO roo_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Oire vosa visii oiso variria purapata, ra viapau oiso va purapata osa voeao riro kuuvu irara. Oearoa tore ruipapaaveira, ra variripaave vo Sinagog Keparo sovara-ia. Ora vo raivara sirova, oiso ra voea kekepaive. Uva oiraopavira rutu visii tavi iraopaa oiso, Voea evoea riro ratarataa vovou irara oea voria oaive ou ovoiivora vo osa oirara raga rei vaisi pieivora. ");
INSERT INTO roo_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Oire vosa variri vovoupata, ra tugiaravi iare koatapata rataoara tupapaoro voa variripasa Aite oavisii iare. Ira vo toupareveira vatau urui. Eera Aite oavisii ira visii-ia taraiparoveira osa vatauvira variripata. Oa iava vara-ia voriaro outaverea. ");
INSERT INTO roo_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ora vosa variripata, opeita riroara rutu purapata reo akukuro oiso rutu osa voeao rupa vovou irara. Oea oiso rugoopaai ra riro reoreoro vai rutu purapaive ra Pauto voea uvupareve. ");
INSERT INTO roo_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Opeita voeao vo pitupituroaro sirova utupata. Pauto Aite orekerovu rutu-ia taraipa varao oarapa ruipapataveira. Varao oara-ia viapau rera arepata oara-ia taraiparoi. ");
INSERT INTO roo_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Visii uvuipatai ra oiso variripata, Igei Aitearo eisi toupari vuvuiua-ia, vii vaisiaropa avivikepaiei vii vaisiaro kae piepaoro rutu. ");
INSERT INTO roo_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Vii vo Saraaro urio pieri. Vii vo vovouaro puraive eisi vuvuiua, oiso osa raga igei uvui iraopaiei ra va sirova utuio vo rasito. ");
INSERT INTO roo_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Vo vokio igei vateri aioa vao vo vokio iare. ");
INSERT INTO roo_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Igei varaaro vuri vovouro verari, vo rara oeavu iava oaravu vuriara vera rovopaio voeao oea igei vuri piepaiveira. ");
INSERT INTO roo_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Opeita igei tovopari kokara-ia. Vara asavira igei vatatopo piepari kokarapatoapa tugarato Seten. ");
INSERT INTO roo_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Oire uvuta. Vosa oearovivu iava vuri vovouro vera rovopataveira varao oara purapaiveira visii-ia, osa iava Aite oavisii visii iava vuri vovouro oavisii verapareve. ");
INSERT INTO roo_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ari vosa viapau oisi eisi piepata, ra ita viapau Aite oavisii visii iava vuri vovouro verapareve. ");
INSERT INTO roo_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Oire vosa aio kavupata rugooara oavisii vatepasa Pautoa-pa, ra opeita ora sirakoisi piepata oiso osa voearo riro kuuvu irara. Aio kavupaoro ora sirao keke piepaaveira, oisore ra va iava taraipaave oirara oiso, Eari aio kavupai. Uva oiraopavira rutu visii tavipaa oiso, Oea-a evoea riro ratarataa vovou irara oea voria oaive ou ovoiivora, vo osa oirara raga rei vaisi pieivora. ");
INSERT INTO roo_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ari vosa aio kavupata rugoo vatepaoro rerapa. Oire korovo tovo rovopata vo ora visii kukuearo-ia, ora puaura oavisii tapo sisu rovopata. ");
INSERT INTO roo_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Oire eva-a oa iava oearovu viapau oiso taraipaavere oiso, Voeao aio kavupai. Ari ita, Aite oavisii raga vara-ia taraiparovere. Eera Aite ira visii-ia taraiparoveira osa vatauvira aio kavupata. Oa iava vara-ia voria outavere rera ruvara-ia. ");
INSERT INTO roo_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Visii vao viapau oiso uvuipatai ra vearopara gurupata vo-ia vo rasio-ia. Ari ita, vo rasio-ia atarike kare orekerovu vuri piepaiveira ora aue asikauru. Uva aue tapo kavirupa irara kovokovoara kasuraara tokopaiveira orekerovu kavirupasa. ");
INSERT INTO roo_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ari vosa vearopara gurupata vo Pauto vo uruiaro sovara-ia, uvare voa viapau atarike kare toupaiveira, ora viapau varao asikauruara, ora viapau voeao kavirupa irara oea kasuraara tokopaiveira orekerovu kavirupasa. ");
INSERT INTO roo_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Oire vo uva vearopara oavisii toupaiverea, vo-a vo uva visii varaaro rutu rugorugooara oavisii toupaiveira varaore rugoopasa vearopara. ");
INSERT INTO roo_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Oiso-ia osireitoarei-a aoa auepa sopaua. Vosa osireiara oavisii roroioara, oire sopaura oavisii rutu tapo roroiovira aviavivira toupaive. ");
INSERT INTO roo_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ari vosa osireiara oavisii vuriara, oire oisi raga ita sopaura oavisii rupavira toupaive. Eisi osa raga ita oiso vosa vo aviavio visii sopaaro-ia rupavira toupaive, oire ra voava rirope rutu vo rupa vearo vovou rakusa. ");
INSERT INTO roo_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Viapau irai uvuiparoi ra aitereipa kovo tokipatoarei vai kovopareve. Ra ita iravure vuri vovoupaoro iravu ragapa vearovira kovopareve vo iravupa reasipaoro. Oire visii vao-ia viapau rutu uvuipatai oiso ra kasi pievira rugoopata vaiterei rutu vo kovoreiarore oiso-ia, Pauto vo kovoaro-a vao, ari monito vo kovoaro-a vao. ");
INSERT INTO roo_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Eisi osa iava oiso visii tavipaavoi, Opeita rirovira rugorugoopata vo ora visii varaarore aue aioara ora uukoara oavisii varao oara visiipa vearo tou vatepaiveira. Ora varao varoara varaura oavisii oritopasa. Eake-a vao rovopa rutu, tootooa eke aioa vore varaua? Ora eake-a vao rovopa rutu, varaua eke varoa varaua oritopasa? ");
INSERT INTO roo_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Oire uva kokio kare kekepataveira oea viapau oiso kukara paupaiveira. Ora viapau oiso aio gurupaiveira, ra vo tovopaive aio gurupa keparo-ia. Ari ita, Aite oavisii ro vova vuvuiua-ia voea aio piepareveira. Easi pasi Aite vo tokiaro visiipa kokio kare vaaro-ia putepaiveira vaopa oa vatepareveira visiipa? ");
INSERT INTO roo_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Oire iroutoa vaiei visii iava ira uvuiparoi ra ivaara vai sigusiguvareve ora rera vo tootooaro uvuioro, vo rara rirovira rutu rugorugooparo ora rera tootooarore? ");
INSERT INTO roo_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Visii vao eakere tuuparare rirovira rutu rugorugoopataveira? Vearovira rutu rugoopata auere kokookoara oara ratau tou ragapaiveira. Ari ita, viapau oiso ora varapa kasivaripapeira ora tuupara vaire taraapaoro. ");
INSERT INTO roo_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ari ita, visii tavipaa aue iava King Solomon riro orekerovu rutu-ia pituto ira ora rera raga ora oritoroepa. Uva viapau oiso vearo oritoa vaiaro rera oaiaro oiso osa vao-ia vearoa rutu kokookoa. ");
INSERT INTO roo_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Iu, isiso kouro toupai varuparo. Oire uva vokipavira vo kouro tateivere vara vikisa tuitui kasi-ia. Uva vara evara okouroa oritopareveira Pauto. Oire uva apeisi-a? Uva viapau uvuiparoi Pauto ra oisi visii tapo oritopareve? Ari ita oiraopavira, viapau oiso uvuivira rutu raripatai rera-ia! ");
INSERT INTO roo_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Eisi ra opeita rirovira rugorugoopata oiso, Eake vai aiopere, o eake vai-a ukaioviovere, o eakero vai-a ora tuupaviovere? ");
INSERT INTO roo_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ari ita, rupa vovou irara oisi eisi rugorugoopaaveira varare varao. Oara rutu-ia taraiparoveira Aite oavisii ro vova vuvuiua varao oarapa ruipapataveira. ");
INSERT INTO roo_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Oire vearovira rutu rugorugoopata, ra vo rugoo-ia tagau rovopata Pauto vo Saraarore rugoo rovopasa ora rera vo ruipaarore tapo. Ra va iava Pauto visii-ia osireoparoverea. Oiso-ia osa iava viapau uvuipatai ra rera vo tokiaropa apotavira toupataverea. ");
INSERT INTO roo_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Eisi osa iava visii viapau uvuipatai ra vo vokiore rugorugoopata vokipavira. Ovokia-ia tavaka uvuivira toupai. Teapi vo vokio iava vo tavakao takuvupata vo vokio iavapa ora vokipavira. ");
INSERT INTO roo_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Opeita oirara togapata ikauvira reoara-ia. Uva va-a eva osa Pauto visii tapo ikauvira togareverea visii rovirieioro. ");
INSERT INTO roo_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Uva vo pitupitu-a vao oa purapataveira oearovu-ia oirara voea toga ragapaoro reoara-ia ora voea rovirieipaoro, evo pitupitu purareverea Pauto visii rovirieioro. Vao oa purapataveira oirara-ia voea rovirieipaoro, uva va-a eva oa kareke piereverea Pauto visiipa. ");
INSERT INTO roo_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Eakere koroto kekepaoro rera sisiropari eera araokoara osireiaro-ia? E viapau ora vii osireiaro-ia evo keposire rugoo rovo asapau? ");
INSERT INTO roo_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Keposiua-a evoua vii osireiaro-ia. Uva apeisi ragavira uvuipau ra araokoara taviri oiso, Araoko, oiso ruipaparai ra koroto veraa eera vii osireiaro-ia? ");
INSERT INTO roo_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Uva vii-a eva riro kuuvuto. Viigoa ora vii iava evo keposi vera rovori oa vii osireiaro tupapai. Oa iava utupavira araokoara osireiaro-ia vuravurarivere vearovira ra koro verau. ");
INSERT INTO roo_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Oire opeita orekerovu vatepata kaakau karepa varao iava oara tugoropapeira. Vosa oisi voeapa vara iava piepata, oa iava visii sirova utuavere visii aiosa. Opeita vearopara tapo varao aasiara vikipata koie karepa. Teapi vara-ia tasiasipaive vara uverepaoro ora vo kare tasiaro-ia. ");
INSERT INTO roo_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Areri variria-ia, ra viipa vatereve oa arepari. Ora taraari, ra va kekeri. Ora rataoa totori, ra viipa karureve Pauto. ");
INSERT INTO roo_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Voea rutu voeao oea Pautoa-pa variripaave oea orekerovu oupaive. Ora ro ira orekerovure taraapareve, ira vara kekepareve. Ora ro ira rataoa totoreve, irapa karureve Pauto. ");
INSERT INTO roo_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Vosa oviitoa vaiaro irai aitetoa vai visii iava, ra irai arepareve oiso purapaoro, Aite, opoa vai ragaipa. Oire ra aveke vai vatereve? ");
INSERT INTO roo_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ora vosa aiteto ruvara-ia atari arero, ra rerapa vuriva vai rakoru vai vatereve, raa? ");
INSERT INTO roo_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Eisi osa toupai oiso, Vosa visii vuri irara oaravu vearopara vatevateara vatepata ovii kakaero oavisiipa, uva va-a eva oa iava ro vearotoa rutu Pauto orekerovu vearopara rutu vateparevere pute pievira voeapa oea rerare variripaaveira. ");
INSERT INTO roo_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Ovovourovu rutupa ruipapata oiso ra vara purapaive oirara visiipa. Oire vo vovouro raga pura rovopata voeapa, uvare va-a vao Reo Taisi rutu vituaro ora vao profet irara vo siposipoaro vituaro. ");
INSERT INTO roo_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Visii vao-ia koatapatai gare rataoavi-ia. Ari vao raiva vore opesipa tapi riroa rutu ora riro paraka. Oa sirova utupaaveira riro irara oirara. ");
INSERT INTO roo_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ari vao raiva oa riaaro pipigovira toupaiveira vavagisia rutu vore Tootoopa ratao-ia. Oire uva kataipa iraravi raga va vao pipigo raiva gaeiverea pasi voa koatasa. ");
INSERT INTO roo_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Oire voeaopa vatatopopata riro kuuvu irara profet irara. Oea visii iare uriopaavere sipsip rakariro-ia ora kuvupaoro visii keasa oiso, Vearo pitupitu igei vaaro. Uva oiraopavira rutu vara sovara-ia oiso rutu toupaivere osa vavarai kare kaakau kare vo kareo vuri kare. ");
INSERT INTO roo_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Uva voea eveipatavere varao iava voea vo kueroaro. Ari ita, viapau uvuipatai ra vearoara vai oupata aioara vai vo evaro iava rokarokapa ovaro. ");
INSERT INTO roo_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Eisi osa raga vearo ova aio kuero purapaiveira vearopara, ora vao oava vuri kuero purapaiveira vuri ova. ");
INSERT INTO roo_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Oire vao vearo ova oa viapau uvuipai ra vuri kue vai purave. Ora vosa vao vuri ova oa viapau uvuipai ra vearo kue vai purave. ");
INSERT INTO roo_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Oeva toeivere va-ia vikisa tuitui kasi-ia. ");
INSERT INTO roo_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Uva voea eveipatavere varao iava voea vo kueroaro, ra vara iava oiso taraipata voea-ia, Riro kuuvu irara voeao-ia profet irara. ");
INSERT INTO roo_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Visii rutu vao-ia oirara viapau ra oiso rugorugoopata, Oirara rutu ragai vaisipaoro keerapaaveira oiso, Turaro, Turaro, oisore ra koataave Pauto vo Saraaro-ia. Viapau rutu. Ari voeao raga oea ragai Aitearo vo ruipaaro sirova utupaaveira ro vo vuvuiua, oea raga rera vo Saraaro-ia koataaverea. ");
INSERT INTO roo_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ari ita, riro irara rutu vo vokio-ia vao oa urioperea utupaua ragaire oiso puraaverea, Turaro, Turaro. Igei-a vao igoa vii vaisiaro sovara-ia Pauto vo reoaro vatepaioveira. Ora oearovu tapo iava vuri tugararo kosi piepaioveira vii vaisiaro raga-ia, uvare riro gorutoa vii. Ora oaravu rutu ravoto kovoro oara tapo purapaioveira. ");
INSERT INTO roo_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Oire uva vo voki-a eva oa-ia voea taviaverea oiso, Viapau visii-ia taraiparai. Voreta ragai ruvara iava. Visii-a riro vuri pitupituro purapa irara. ");
INSERT INTO roo_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Ro ira ragai vo reoaro uvureve ra va sirova uturo, eera-a ira oiso touparevere, Ira-ia vearo rugorugoo toupai. Oa iava kepa oaro paureva avekeara ivara-ia. ");
INSERT INTO roo_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ra vosa kokeva koveopa, ora vosa pirutupe aue uuko, ora vosa kiuvu vusireve goruava, oire vara rutu goruaro evara vo kepa-ia ora iupe, ra viapau oiso kovepe. Aue iava uvare simen votopaoi avekeara-ia vo rasito sovara-ia. ");
INSERT INTO roo_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ari vosa ro ira ragai vo reoaro viapau uvureve, ora viapau va sirova uturo, ira oiso toupare, Rera-a eera kokoropato. Ira kepa oaro paureva rogara raga ivara-ia. ");
INSERT INTO roo_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Uva kokeva urioopa koveoro. Uuko oviro tapo pirutuepa, ora kiuvu tapo vusireva goruava, oire vara rutu evara goruaro vo kepa gugiugiva. Oa iava kove ovoiepa vuri ovoioro.” ");
INSERT INTO roo_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Oire uva Jisas vo siposipo opesi pierevoiva, riro irara rutu oirara tavetave iraopaiva vo reo-ia vao rera vaaro. ");
INSERT INTO roo_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Eake iava? Uvare viapau oiso voeapa siposiporeva osa voeao tarai irara vao-ia Reo Taisi. Ari oiso rutu toupai, Goruava voeapa siposiporeva. ");
INSERT INTO roo_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Oire uva pukui iava vararoepa, oa iava riro irara rutu rera sirova utuaepa. ");
INSERT INTO roo_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Uva iravu ira-ia oisoa lepra upia toupaive Jisas iare tutuu piereva. Oa iava kotupiuarei rekuoro takuro viropa rera ruvara-ia oiso puraoro, “Turaro. Vosa ruipapau, ra ragai porete pieri.” ");
INSERT INTO roo_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Uva Jisas rera-ia vavaea taku pieoro oiso puraroepa, “Oiso ruipaparai, ra sisigarueu.” Osa-a eisi osa iava lepra upia opesi ovoiepa. Oa iava sisigarueroepa. ");
INSERT INTO roo_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Uva Jisas rera tavireva oiso, “Vearovira rutu ora vatatopo iraopauei. Opeita irai taviparivere. Viapau. Ari varaua oara karekesa avapau pris irarapa. Ra tauoa vai purari oiso osa Moses tuariri puraroepa. Oa iava oirara rutu taraiavere oiso, Upia rutu vii iava opesiepa.” ");
INSERT INTO roo_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Vo Jisas Kapaneam urui-ia koataroepa. Uva iravu ami viurupa irara katai vovoto (100) oirara reitoaaro urioroepa rera goruvira rutu aresa. ");
INSERT INTO roo_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Turaro. Ragai reraaro kovopato upiaparoi. Uva reraei kepa-ia. Ira iava keruara rutu kopiiepa aue-ia kerau upia.” ");
INSERT INTO roo_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Uva Jisas rera tavireva oiso, “Ira porete piesa urioravere rara.” ");
INSERT INTO roo_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Oire uva rera ro viurupa irara reitoaaro rera vo reoaro pukooro oiso puraroepa, “Turaro. Viapau oiso vearoto-a ragai ra ragai vo kepaaro-ia ora kiuu. Ari oiso raga ruipaparai ra vo raga touoro rerare reoreou osa poretero. ");
INSERT INTO roo_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ari ita, ragai tapo ro reroarovi toupaavoi ira reesiiva kepten rutu ragai tokipasa. Uva ragai raga oearovuva toupaavoi viurupa irara katai vovoto (100), oea ragai reroarovi ita toupai. Oire uva oiso-ia vosa irai arua voea iava oiso, Avau, ra avaro. Oire ita, iraire keerara oiso, Uriou, ra urioro. Ra ita kovopatoa oaa ragai reraaro tavia oiso, Vao purari, oire oai purareve.” Oiso puraroepa ami reitoaaro. Uva evo reo oa kosi pieva Jisas vo goruaro. ");
INSERT INTO roo_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Oire uva Jisas varao rutu uvureva rera ruvara-ia. Oa iava rirovira rutu vara-ia rugorugoo iraoparoepa. Uva voeao tavireva oea rera sirova utupaaepa oiso, “Oiraopavira rutu visii tavipaavoi oiso-ia, Viapau oiso irai kekeavora Isrel-ia oiso osa ro-ia amipa irarapa irapato ira-ia oirao pie vovou toupai. ");
INSERT INTO roo_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","“Oire vo reore rugoopatai oiso, Riro irara oirara oisova uriopaavere uvarovu rutuva vo uvava ravireo kaeparo viroveira ora vova uva rokopareveira. Vo uva aueva Ebraham pauaverea aioa-ia ora Aisak ora Jekop vo vuvuiua Pauto vo Saraaro-ia. ");
INSERT INTO roo_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ari ita, oirara rutu voeao Jiu-pa irara rera voeaaro oea reesireva ora rerapa, oea iava oeavu kosi piereverea vore rupa tapi voea siguoro ora rera vo tokiaro sovara iava. Oea vurivira gaupaiverea ora voea reuriaro kuripaoro ora voeapa siraopaoro.” ");
INSERT INTO roo_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Oire uva Jisas viurupa irara reitoaaro tavireva oiso, “Kareu vaviopavira. Vii vaaro oirao pie vovou oa oiraopavira karekepere viipa.” Oa iava vo vuuta raga-ia eva porete ovoiroepa rera kovopatoaaro. ");
INSERT INTO roo_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jisas koataroepa Pita vo kepaaro-ia. Voa Pita aigevaaro kekereva osa voa kukue upia iava urua-ia gerevira toupaeva. ");
INSERT INTO roo_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Oa iava oira vavaearo-ia pitureva. Oire uva kukue upia oira kavu ovoiva. Oa iava voava porete ovoioro Jisas-pa aioara vatatopo ovoieva. ");
INSERT INTO roo_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Uva ovaiaro riro irara rutu oirara ora riakora sipopaiva rera iare Jisas voearo oearoa-ia oisoa vuri tugararo rutu toupaive. Oa iava voa voeare reoreoparoepa tugara voea sigupaoro voeao vuri tugararo rutu. Uva voea rutu upiapa irara vorevira poretepaaepa. ");
INSERT INTO roo_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Uva oisi-a eisi osa vara purapareva vo reo oirao piepaoro oa purareva Pauto Aisaia gisipoaro-ia ro profetato oiso puraoro, ‘Eera ira upiara rutu vo vavataaro kaereverea vara verapaoro vigei iava.’ ");
INSERT INTO roo_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jisas riro irara oirara kekereva oea ora guruaepa rera kovokovopaoro. Oa iava ora rera voeaaro disaipel tavireva oiso, “Vova iviropaviei vavo varata iare.” ");
INSERT INTO roo_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Oire uva iravu riro taraito Reo Taisi-ia urioroepa oiso rerare purasa, “Tisato. Vosa ragaipa ruipapau, oire ra vegei rutu avave vo uruiro iare uvaroare avapau.” ");
INSERT INTO roo_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Uva Jisas rerare ora rera iavirava oiso puraroepa, “Ari ita, Akau kare vo tavukiroaro toupai uusipa tavukiro rasiuaaro, ora kokio kare oea vo epitaroaro toupai. Ari ropa Oirato Oviitoaaro Ro Ropoto viapau oiso tavukia vaiei rerapa kukuearo vasepasa.” ");
INSERT INTO roo_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Oa iava iravu disaipelto Jisas tavipareva oiso, “Ragai ava rovoparai aite tova rovosa, eke?” ");
INSERT INTO roo_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Oa iava Jisas oiso rerare puraroepa, “Eagara, voeaope kopii rugoo irara, oea raga ora tovapaavere osa ragai sirova utuu.” ");
INSERT INTO roo_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jisas uvua sovara-ia koataroepa. Oa iava disaipel irara rera sirova utuaepa voa. ");
INSERT INTO roo_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Oire rirova purepava kiuvuva toko rovu ivara-ia urioopa. Oa iava rirovira rutu uvuoa petopetopaiva toru kouro osa voa Jisas uusiparoepa. ");
INSERT INTO roo_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Oire uva va-a vao oa iava disaipel urioaepa rera tore piesa oiso puraoro, “Turaro. Igei tauvari! Easi opesipaviei.” ");
INSERT INTO roo_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Uva voeare oiso puraroepa, “E apeisi iava uriripatai? Easi gare visivi raga raripatai ragai-ia.” Uva voava toreroepa purepava kiuvuva rakote pie ovoisa ora uuko ovi vara ruture reooro. ");
INSERT INTO roo_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Oa iava ora voea raga va-ia tavetavepaoro oiso ora reopaaepa, “Avoeao, eaketo-a irao ro oirato ira gisipoaro uvu ovoivoi vo vatakore kiuvu ora uuko ovi?” ");
INSERT INTO roo_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jisas ovaratavu iava toko rovu-ia pouro viropa vo Gadara vase vaaro. Oire uva voa aitereivu oiratoarei rerava aivarosiva raivaaro aiterea-ia oisoa vuri tugararo toupaive. Oa iava vavaraisiepa tova uruiro-ia uusipaoro. Uva eisi osa iava oisoa oirara ora riakora vo raiva vao viapau oisoa gaepaive vaiterei asavira. ");
INSERT INTO roo_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Uva rirovira rutu oivepaoro vaiterei iava keerapaaepa oiso purapaoro, “Vii Pauto Oviitoaaro! Apeisi vai igei piesa uriouei? Vuuta igei vaaro tugura asavira toupaivoi ovusa igei rirovira upia piesa vagevagevira uriouei.” ");
INSERT INTO roo_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ovusa oavu koie ragui tauaivi toupaiva aiopaoro. ");
INSERT INTO roo_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Uva voea voeao vuri tugararo goruvira rutu Jisas arepaiva oiso purapaoro, “Vosa igei kosi piepari, ra vavore igei sipori koie ragui sovara-ia.” ");
INSERT INTO roo_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Uva va-a vao oa iava voea tavireva oiso, “Avata!” Uva vaiterei kavuoro koie ragui-ia koatasa avaaepa. Uva voava vo ragui riro varivarivira rutu ikauoro varaaepa oavu-ia ora vikisa vagapa toko rovu sovara-ia. Oa iava voa gisiaepa kopii ovoioro. ");
INSERT INTO roo_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Uva koie tokipa irara toriiva riro urui-ia kare uvirosa. Uva voa toupaoro voeapa siposipopaiva varao iava oara rutu karekeepa vaiterei-ia tapo aiterea-ia oisoa vuri tugararo toupaive. ");
INSERT INTO roo_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Oire uva oirara rutu voeao vo uruia iava Jisas-va aivarosa avaaepa. Oa iava rera kekeoro rerare oiso puraaepa, “Vova igei vo rasiaro iava avau uvai ragare.” ");
INSERT INTO roo_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jisas uvuoa sovara-ia koataroepa ovaratavu iare voresa voa vo toko rovu-ia. Uva voava vorevira karero viropa vore rera vo uruiaro torevokoaro-ia. ");
INSERT INTO roo_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Uva iravu upiapato kaepaoro urioaepa rera iare ira iava keruara rutu kopiiepa. Oire uva Jisas rera vurareva peperava uru ivara-ia osa voa gerevira toupareva. Oa iava voea varaaro eveioro rari vovouro oiso puraroepa rerare, “Sopaua oara kavepe viire. Vuria oara vera ovoiavoi vii iava.” ");
INSERT INTO roo_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Evo reo uvupaoro voeao tarai irara aue-ia Reo Taisi oiso rugorugoopaaepa, Easi ro Pauto toviparevoi. ");
INSERT INTO roo_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ari ita, vo ovusa Jisas voea varaaro-ia tarairoepa rugorugooara. Oa iava oiso puraroepa voeare, “Eakere eisi ora visii vovouroaro ragaire vurivira rugorugoopatai? ");
INSERT INTO roo_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ari aa vo reo irao-a oa avekatapai rutu ragaipa, ra va-ia oiso purara, Vuria oara vera ovoiavoi vii iava, eke oiso purara, Toreu ra vokari? ");
INSERT INTO roo_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Oa-a vao-ia oa purapaavoi visiipa ro vearo pieoro. Oire va kekepaoro oiso purapata ragai iavirava, Oirato Oviitoaaro Ro Ropoto vo goruaro vao-ia oiraopa. Oa-a vao uvuipai vuriara rutu verapasa oirara iava voeao rasitoa-ia tou irara.” Oire uva va-a vao oa iava rerare upiapato oiso puraroepa Jisas, “Toreu, ra uruara kaepaoro kareu vii vo kepaaro iare.” ");
INSERT INTO roo_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Uva oisi-a eisi osa iava avaroepa tore ovoioro rera vo kepaaro iare. ");
INSERT INTO roo_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Oa iava oirara rutu va vao kekeoro va-ia tavetave iraopaiva. Uva taraipaaepa oiso, Pauto vo goruaro iava vo karopo vao-ia oa vatereva oirarapa. Oa iava Pauto vaisiaro kae pieiva. ");
INSERT INTO roo_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jisas vokapaoro iravu kekereva osa pauparoepa moni oupa kepa-ia gavman vo kepaaro. Rera vaisiaro Matyu. Oa iava voa rerare oiso puraroepa, “Matyu, ragai sirova utuu.” Uva rera sirova utu ovoisa toreroepa. ");
INSERT INTO roo_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Oire uva kepa-ia toupareva voa aiooro. Uva voa riro irara rutu takis oupa irara ora riro irara vuri irara oearea rutu rera tapo aiosa urioaepa. Oa iava voea tapo aiopareva ora rera voeaaro disaipel. ");
INSERT INTO roo_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Oire uva Farisi va vao kekeiva. Oa iava disaipelre oiso puraaepa, “Uva apeisi visii reraaro tuvetuvepato voea tapo takis oupa irara ora voeao vuri vovou irara aiopare?” ");
INSERT INTO roo_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Uva Jisas vo reo uvuoro oiso puraroepa, “Voeao upia asa irara viapau oiso ra avapaave ruvarupatoa iare. Viapau. Ari voeao raga oea-ia upiara toupaive, oea raga uvuipaai rera iare avapaave ruvarupato. ");
INSERT INTO roo_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Visii vao-ia taraia ousa avata vo reo porearo-ia, oreoa Tugoropa Vuku sovara-ia toupaiveira oiso, ‘Vaopa reasiparai tauo purapa pitupitu. Ragoa vaopa ruipaparai tauva vatepa pitupitu.’ Oire viapau oiso voeaore keerasa urioraera torevoko vovou irara. Viapau. Ari voeaore keerasa urioraera rupa vovou irara vuri irara, oiso ra ora voea varaaro iava vuriara oaive porea viro.” ");
INSERT INTO roo_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Uva vo vuuta-a eva oa-ia Jon voeaaro disaipel urioaepa oiso purasa rerare, “Uva apeisi iava igei rutu vao-ia aio kavupaioveira ora Farisi-pa irara osa vii voeaaro disaipel viapau oisi piepaive?” ");
INSERT INTO roo_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Oa iava Jisas voea tavireva oiso, “Vosa irai oiratoa vai pitu pie asavira toupareve vo raga sara irara ruvara-ia, ra viapau oiso vovousopaave aioa purapaoro vao ora ousapa aio. Aue iava uvare utupauavi ora voea iava rera veraivere vo osa riako ouro. Oire ra viapau ita voea tapo sara irara toupareve. Uva vo vuuta-a eva oa-ia oisoa aio kavupaave taru voea sara irara rerapa siraopaoro, uvare tauaipa voea arova. Osa eisi ragai voeaaro toupaivoi. Oa vituaro iava viapau aio kavupaiveira vo ragai tapo toupaoro. ");
INSERT INTO roo_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Viapau rutu irai uvuiparoi ra ruta vai varoa vai taporeve voava airepa. Vosa oisi pieive, ra ita rutapa karikari piro airepa arova. Ra karia ita riro iraope. ");
INSERT INTO roo_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Uva viapau irai uvuipa ra tuariripa rakari vai sovara-ia wain ovi vai airepa vai kuvureve. Vosa oisi piereve, ra meme rakariaro kari piro. Ra wain koko viro ovusa va tapo meme rakari opesi ovoipe. Ari vosa aue raga-ia airepa kuvupaave, ra vearovira raga oriruvira toupaive va-ia.” Eisi osa voea vo akearo aatoreva Jon voeaaro disaipel. ");
INSERT INTO roo_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Oire uva Jisas vo reo raga vao purareva, ovusa ro reito urioroepa kokoto rekusa rera ruvara-ia. Oa iava oiso puraroepa, “Vo vokio raga-ia oviiva oaa kopiioi. Uva oiso ruipaparai ra uriou oira-ia vavaea tovosa, ra vorevira tooo.” ");
INSERT INTO roo_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Uva va iava Jisas rera sirova uturoepa ora disaipel irara tapo. ");
INSERT INTO roo_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Uva voa-a evoa uva iriavu riakova toupaeva iria-ia oisoa kekira koveparo vokiara rutu-ia. Uva oisi raga toupaoro katai tau erao (12) ivaro-ia tuguraopa. Oire uva oira o rera isivaaro-ia urioopa varoa vatuaro-ia pitusa rera vaaro Jisas. ");
INSERT INTO roo_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Uvare ora vovouaro raga-ia oiso rugorugoopaopa, Vosa rera vaaro-ia varoa pitua, ra va iava vearora poreteoro. ");
INSERT INTO roo_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Oire uva Jisas ora poreroepa oirare oiso purasa, “Oviiva oaa. Vii iava sopaua varaape kaveoro. Ari vii vaaro oirao pie vovou oa vii ravotovira porete pievoi.” Uva vo vuutavi raga-ia eva varaa ovoiopa porete ovoioro. ");
INSERT INTO roo_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Oa iava Jisas voa vo pouro viropa reito vo kepaaro-ia ovusa pupipaiva ora riroa gau guruko purapaiva oirapa gaupaoro. ");
INSERT INTO roo_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Uva oiso puraroepa Jisas voeare, “Verata vova. Viapau oiso o kopiioe kakaeva. Iria uusi ragapaoi.” Oa iava rera agesipaiva. ");
INSERT INTO roo_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Oire uva oirara rutu veraiva. Oa iava koataroepa Jisas oira vo tugiaro-ia oira vavaearo-ia pitusa. Oa iava tore ovoiopa. ");
INSERT INTO roo_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Uva vo tavitavi vao vokava voraro vo taere-ia vo rasio-ia. ");
INSERT INTO roo_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Uva voava vo urui kavureva Jisas. Oa iava voosito vaio rera sirova keerapaoro utupasiepa oiso purapaoro, “Vii Jisas vegei aaotoaaro, Devit Oviitoaaro. Vegeivipa siraou.” ");
INSERT INTO roo_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Oa iava koataroepa oavu-ia kepa. Uva voa vaitereo voosito vaio Jisas iare uriosiepa. Uva vaitereire oiso puraroepa, “Easi ragai vai-ia raripasiei, oiso ra vao puraa?” Uva oiso purasiepa, “Iu, Turaro!” ");
INSERT INTO roo_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Uva vavaerei tovoreva vaiterei osirearo-ia aarovira oiso puraoro, “Va-a vao oa reivira karekepere vei vaarova oirao pie vovou.” ");
INSERT INTO roo_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Oire uva vaitereire osireiara karu piropa. Uva va iava Jisas vaitereipa riro goru reo vatereva oiso puraoro, “Opeita irai tavipasi vao iava.” ");
INSERT INTO roo_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Oa iava voava kosi virooro rera iava Jisas siposiposa kosisi viropa. Uva voraro rutu viriva vo taereo-ia vo rasia vao. ");
INSERT INTO roo_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Oire uva voava avasieiva, iravu ita sipoiva kapuu gisipoto rera iare ira-ia oisoa vurito tugarato toupareve. ");
INSERT INTO roo_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Oa iava rera ro vurito tugarato kosi piereva rera iava. Uva voaviva vorevira reoroepa. Uva va iava vao-ia rirovira rutu tavetave iraopaiva oiso purapaoro, “Viapau rutu oiso oai karekeepa Isrel-ia oiso osa vao-ia.” ");
INSERT INTO roo_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Oa iava Farisi oiso ora reopaaepa, “Easi eera tugara kare reitoaaro vo goruaro iava varao purapare ro Jisas.” ");
INSERT INTO roo_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Uva voava Jisas voraro rutu virireva riropa uruiro-ia ora garepa uruiro-ia Vearo Siposipo kosi piepaoro Pauto vo Saraaro iava. Ora oupiarovu rutu tapo iava voea porete piepareva ora ovovourovu iava raveraveara. ");
INSERT INTO roo_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Oire uva voa-a evoa uva oeavu riro irara oirara kekeoro siraoroepa voeapa. Eake iava? Uvare voea varaaro rugorugooara piro piropaepa. Oa iava vurivira rutu toupaiva oiso rutu osa sipsip ragui voeao oea viapau tokipatoa vai oaive. ");
INSERT INTO roo_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Uva eisi osa iava oiso disaipelre puraroepa, “Riroara rutu aioara vioroe oara oiso toupai osa oirao pie asa irara vo ragai-ia Jisas. Osa viapau kovopa irara vai vo voea tavitavipasa. ");
INSERT INTO roo_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Eisi osa iava uvuipatai ra rore Turaro Pauto variri iraopata ira ruvara-ia toupaiveira vo kovo. Ra va iava kovopa irara vai siporeve vo kovo aioaro gurusa.” ");
INSERT INTO roo_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisas katai tau eraore keeraroepa voea iava oea oisoa rera sirova utupaave aue disaipel, auere voeapa goruaro karutusa vuri tugararo kosi piepasa, ora aue okopiirovu rutu iava voea porete piepasa, ora oaravu rutu raverave vovouro verapasa vova varaura. ");
INSERT INTO roo_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Oire uva voea katai tau erao (12) vaivaisiaro-a voeao aposel irara oiso-ia, rovopato-a ro-ia Saimon, uva ovaisivu-a vao rera raga-ia aue Pita, ora araokoto aue Andru, ora Jems ro Sebedi oviitoaaro, ora ro araokoto Jon. ");
INSERT INTO roo_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ora Filip, ora Batolomyu, ora Tomas, ora Matyu ro moni oupato, ora Jems Alfias oviitoaaro, ora Tadias. ");
INSERT INTO roo_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ora Saimon Selot, ora Judas Iskariot ro ira Jisas kosi piereva keripa irara vavaearo iare. ");
INSERT INTO roo_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Oire uva Jisas voea voeao katai tau erao siporeva vao kaepasa Vearo Siposipo. Uva voeapa reo vatereva oiso, “Visii vao opeita ratau toupa irara iare avapatavere aue Jentael. Ora opeita tapo Sameria uruiro-ia ora kiupatavere. ");
INSERT INTO roo_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ari visii vao voeao raga iare Isrel-pa irara avapatai oea opesikoaepa rutu oiso rutu osa sipsip ragui voeao oea opesikopaaveira. ");
INSERT INTO roo_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ari ava iraopatai ra oiso ragavira siposipota, Pauto vo Saraaro vao vova vuvuiua tutuuvoi. ");
INSERT INTO roo_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Uva oearovu porete piepatavere upiapa irara, ora oearovu kopiipa irara rutu vorevira tore piepatavere, ora voearo tapo leprapa irara sisigarue piepatavere, ora oearovu iava vuri tugararo tapo kosi piepatavere. Oire vo goru vao oa outavoi oa-ia viapau oiso voria vaiei. Uva oisi raga ita voea vatetavere akukuvira, ra viapau oiso vori oupata ita va-ia. ");
INSERT INTO roo_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Viapau oiso uvuipatai ra moniara vai kaeoro avata vo resipotara oavisii-ia. ");
INSERT INTO roo_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Visii vao viapau uvuipatai ra oapara vai-ia pitupaoro tapo avatavere varao vokapa oaparo ora aue kuvupara vai. Ari katakataivira oaraiva avatavere ora aue tasipara aue tapo tooroara. Oire vosa ro ira vearovira rutu kovoparevere, ira aioa vatea ouparevere voeao ruvara-ia oea tauvaparevere, aue iava uvare voea vaaro-a rerare rugoopasa rera tokipaoro. ");
INSERT INTO roo_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Vosa visii vao ouruirovu-ia riropa uruiro karepata virovere, eke ouruirovu garepa uruiro, oire vearovira rutu oirara eveipatavere oiso, Aa ro avuo-a vearo vovouto kovu taraa vovouto. Oire rera tapo touta vo tugurasa uva vo urui arova ita avata. ");
INSERT INTO roo_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Vosa okepavu-ia koatata, oire vearo voki purata oirarava ora riakora voeao vo kepa-ia tou irara. ");
INSERT INTO roo_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Vosa vearo vovou irara vai visiiva ora aatopaavere, oire ra voeapa ita kave vovouro oavisii vatepata. Ari vosa viapau visii aatopaive, oire visii iare ita vorevira visii vararo kave vovouro vorepape varao torevokoara. ");
INSERT INTO roo_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ora vosa ouruivu iava visiipa reasipaave vo visii uvu arapa ora reasipaave visii tapo paupa arapa, ra voa ita kavuta. Ra kokotoara tovetove rovota auere rasi voare voea vo vuriaro reesipaoro. ");
INSERT INTO roo_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Oiraopavira rutu oiso osa visii tavipaavoi oiso, Vo vokio vao oa-ia oirara rovirieireverea Pauto, ovokia-ia vo siitoka oa ouverea vo uruireo Sodom ora Gomora urui, ouruirea oisoa vuri pitupitu purapaive vo tuariri. Oa-ia puteverea vo uruio vo vavataaro oa-ia visiipa reasipaave. ");
INSERT INTO roo_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Uvuta! Visii sipopaavoi oiso rutu osa sipsip ragui akau kare vuutaaro iare, riro sipsip aio kare. Eisi osa uvuipatai ra kasivarivira rutu rugoo rovopata oiso osa o rakoru riro kasivari rugorugoova, ora oiso osa ro-ia kurue kave vovouto, aiterea vo pitupituaro sirova utupata. Ra viapau vuri rugorugooro vai purapata. ");
INSERT INTO roo_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Oire vatatopo iraopatavere voearopa oearovu oea visii sipopaivere Kaunsel irara iare, ra visii rovirieipaive visii ragipaoro voea vo keparoaro sovara-ia varao Reo Taisi Uvupa Keparo, Sinagog. ");
INSERT INTO roo_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ari ita, oiso purapaavere, Oari Jisas voeaaro-a evoea. Oa iava oiso visii oupaive vore gavman irara oaive vavaearo-ia, ora vore turaro irara oaive vavaearo iare tapo. Oisore ra voea rutupa ora voeao ratau tou irara tavitavipata ragai vaisiaro iava. ");
INSERT INTO roo_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Uva visii kosi piepaiverea kortua iare, ra opeita uriripata oiso rugorugoopaoro, Apeisi purapaiei? O Apeisi ragavira vo reo purapai? Viapau. Ari evo vuuta raga-ia visiipa Pauto rera vo rugooaro vateparevere. ");
INSERT INTO roo_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ra viapau oiso ora visii orugooaro iava tavita. Viapau. Ari Tugoropatoaaro Aite oavisii ira raga reoreoparovere visii gisipoaro-ia. ");
INSERT INTO roo_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Oearovu voearo oea araoko irara oaive oiso vatepaiverea vore gavman vavaearo iare, oiso ra voea kopii piepareve. Ora oearovu oea ovii irara oaive kosi piepaivere gavman vavaearo iare. Ora tapo oiso-ia ovii irara aite irarava ora keripaavere ora aako riako, ra voea vatepaivere gavman vavaearo iare, ra voea kopii piepareve. ");
INSERT INTO roo_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Vo vuuta-ia vao riro irara rutu visiire vuri vovou iraopaavere. Eake iava? Uvare ragai vaisiaro-ia toupata. Ari vosa ro ira goruvira rutu Pautoa-ia rugooa tovopareve vo tugurasa Ovoipa Voki-ia, eera-a ira taru oureverea Pauto ora rera vo Saraaro iare. ");
INSERT INTO roo_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ari vosa visii-ia oai puraive vuria vai vo ouruii-ia riro urui vai, oire visii vao torioro ita avata ourui iare ita. Ari ita, oiraopavira rutu visii tavipaa, Asi viapau oiso kovoara oavisii potu pietavere vo uruiara rutu-ia varao vo Isrel-ia vo osa Oirato Oviitoaaro ragai vorevira vorera vore rasito. ");
INSERT INTO roo_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Voeao tarai taraapa irara viapau oiso uvuipaai ra tarai vatepatoa-ia putepaive ro voea reraaro. Ora kovopa irara tapo viapau uvuipaai ra reito oaive-ia putepaive. ");
INSERT INTO roo_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Vosa tarai taraapato oiso toupareve osa ro-ia tarai vatepato rera reraaro, uva vearopai oisi. Ari vosa kovopato oiso toupareve osa ro reito rera reraaro, uva oisi vearopai ita. Vosa vo vaisio vateive ragaipa visii reitoaaro, Bielsebul ovaisio porearo vao oiso purapai, Seten, ra va iava vearovira taraipata oiso, Visii-a ragai voeaaro visiigoa tapo vurivira rutu takaupaivere. ");
INSERT INTO roo_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Visii vao viapau uvuipatai rutu ra uriripata voeaopa oirara. Ari ita, orekerovu rutu vatauara poeravira karekeperea utupaua. Ora vara rutu varao vatau reoro oara rutu poeravira karekeperea ra vara-ia taraiave oirara. ");
INSERT INTO roo_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Vo reo-a vao oa puraavoi visiipa rupa-ia, oreoa taru vatepatavere vo ravireo-ia roroiovira. Ora vo reo oa ogaoga visivi raga oa uvutavoi vao-ia, oreoava uvuipatai ra ora reopa tapiro-ia toupaoro vo reo-ia riropavira reopata. ");
INSERT INTO roo_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ra visii vao opeita uriripatavere voeaopa oea visii varaaro vuri piepaivere. Ari ita, ra ratarataavira kopiipata osa urauraara oavisii viapau kopiipape. Viapau. Ari ro raga Pauto irapa uvuipatai ra avivikepata. Ro ira uvuipa ra visii iava varaura rutu ora urauraara oavisii opesi piereve vo vuri tapi. ");
INSERT INTO roo_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Garetoareivi voripaiveira kokiotoarei katai toea-ia akukutoarei. Ari vosa aite oavisii reasiparo, ra viapau oiso kataitoavi kokioto kove ragaro vore rasito. ");
INSERT INTO roo_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ari ita, visii kukuearo-ia oruara oavisii vieirevora Pauto Aite oavisii. ");
INSERT INTO roo_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Eisi osa iava viapau uvuipatai ra uriripata vaopa, uvare viapau oiso toupataveira osa kokio kare akuku kare vo Pauto osireiaro-ia. ");
INSERT INTO roo_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Ro ira ragai vaisiaro iava tavitavirovere oirara rutu osireiaro-ia, ira iava ita taru taviraverea Aite osireiaro-ia ro vo vuvuiua. ");
INSERT INTO roo_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ari ro ira ragaire isivaroverea vo oirara rutu osireiaro-ia, ragai tapo ita irare isivaraverea vo Aite osireiaro-ia. ");
INSERT INTO roo_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Visii vao viapau oiso ra oiso rugoopata, Ragai vo upo vo rasito opesi piesa urioraera. Viapau. Ora oiso tapo viapau oiso gavaurea vaiva urioraera, ari aue ragava toorio urioraera upo purapasa. ");
INSERT INTO roo_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ari vao purasa urioraera ora keripa pitupitu oiso ra, ‘Ovii irara aite irara tapo ora upopaave. Osa ita ovii riakoro aako riakoro tapo ora upopaave, ovusa vaireo aako riakoro taato riakoro tapo ora upopaave. ");
INSERT INTO roo_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ari ita, katai kepa raga-ia oa-ia tou irara ora voeava upoaverea.’ ");
INSERT INTO roo_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Oire vosa irouto aitetoarei ragapa siraoparo, ra viapau ragaipa oisi sirao rovoparo rutu, eerapa ira viapau oiso vaisiaverea oiso, Vatetoa oaa. Ora vosa irouto ovii vavuatareiaro ragapa siraoparo, ra viapau oiso ragaipa sirao rovoparo rutu, eera ita-a ira viapau oiso vaisiaverea oiso, Vatetoa oaa. ");
INSERT INTO roo_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ari ro ira rera vaaro riro vavata siitoka viapau oiso oureve va kaesa ragai sirova utuoro, eera-a ira viapau vaisiaverea oiso, Vatetoa oaa. ");
INSERT INTO roo_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ari vosa ro ira ora tootooaro ragare taraapareve kovopaoro, ira vaaro tootooa taru opesiperea. Ari ro ira ragai raga-ia rugoopaoro rera vaaro tootooa eakapareve, ira oiraopa tootoo rutu oureverea taru. ");
INSERT INTO roo_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ari ro ira visii vearopareve, eera-a ira ragai tapo vearopare. Ari vosa ro ira ragai tapo vearopareve, ira Pautoa tapo vearopare ro ira ragai siporeva. ");
INSERT INTO roo_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ari ro ira profetato vearoreve aue iava uvare Pauto reraaro-a, ira voria oureverea oiso rutu osa vao profet irara vo voriaro. Ari vosa ro ira iravu vearoreve torevoko vovouto, aue iava uvare torevoko vovou-a rera vaaro oa purapareveira, ira-a eera voria oureverea oiso osa torevoko vovou irara vo voriaro. ");
INSERT INTO roo_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ari vosa irouto voeao iava ragai voeaaro iravivu vatereve uukoa rera ukaio pieoro, uvare rera-ia taraiparo oiso, Ro Jisas sirova utuparoveira, oire uva oiraopavira oiso visii tavipaavoi ro iava oirato, Ira vao voria rutu ou iraoreverea taru.” ");
INSERT INTO roo_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jisas vo reo vatereva kovoara purasa auepa katai tau erao (12) disaipel rera voeaaro. Vao isivaaro iava vo uruio kavuoro avaroepa vo uruiro iare tutuu pie uruiro voa voeapa siposiposa. ");
INSERT INTO roo_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Vo osa Jon tuukepa kepa-ia toupaoro Krais vo kovoaro iava uvureva. Oa iava oeavu arureva rera voeaaro iava disaipel rera iare Jisas. ");
INSERT INTO roo_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Uva rera-ia pou viropaoro rera akepaiva oiso, “Esa vii-a vao viigoa iava taviroepa Jon oiso, Iravu uriorovere? Eke aa ro-a irare tuepaiei, eke irai raga?” ");
INSERT INTO roo_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Oire uva Jisas voea vo reoaro pukooro oiso puraroepa, “Vorepata Jon tavisa varao iava orekerovu rutu oara uvuta ora vara keketa oiso-ia, ");
INSERT INTO roo_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Voosi irara vorevira vuraivoi. Ora voearo oearoa iava kokotoara oisoa kopiipape oea tapo vorevira vokaivoi. Ora voeao oea-ia lepra upiaaro toupaiveira oea tapo sisigarueai. Ora voearo uvagi irara oea tapo reo uvuai vorevira. Ora voeao kopii irara rutu oea vorevira tootoopai. Ora voea tapo apota irara oeapa Vearo Siposipo puraavoiva, va uvuivoi. ");
INSERT INTO roo_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ari vosa irouto ragai goruvira oirao pieparevere rutu, eera-a ira taru rorupareve!” ");
INSERT INTO roo_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Oire uva va iava Jon voeaaro disaipel vorevira kareaepa ovusa Jisas voea isivaaro iava oirara rutu tavitavireva Jon iava. Oiso puraroepa voea akeoro, “Eake-a vao kekesa avataera vo raaka tapi vo vokio-ia oa-ia Jon iare avataera? Esa pito isiva-ia aisia va ratesa avataera ovusa kiuvu vaisi vurevureparevora, raa? Viapau. Uvare Jon viapau oiso raveravea vaiva siposipoparevora oiso osa pito isi. ");
INSERT INTO roo_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Visii vao eake kekesa avataera? Easi pasi irai vaiva oiratoa vai ratepasa avataera osa vearotoa vai-ia kuvuparoera kuvutoa vai? Voearo iava, pasi, irai oirara oearoa vearopara-ia kuvupaoro kepaara raga sovara-ia toupaiveira reipa irara vo keparoaro. ");
INSERT INTO roo_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ari eake irao-a oare avataera? Irai vai profetatoa vai kekesa, eke? Iu. Visii tavipaavoi oiso, Eera profetato Jon ira oearovu rutu-ia putepareveira profet irara. ");
INSERT INTO roo_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Aue iava uvare rera iava taviepa Tugoropa Vuku oa-ia oiso puraepa, ‘Uvuta! Ro sipopaavoi reo kaepato. Ira viipa irarovere, eera ira raiva oara vatatoporevere va ravaaoro viipa.’ ");
INSERT INTO roo_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Visii tavipaa oiraopavira oiso, Jon Baptais kataito ira oirara rutu-ia putereva voeao oea karekeaepa vo rasio-ia. Ari ita, vosa aa ro avuo-a ro ira Pauto vo Saraaro-ia akaipavira toupareve, eera-a ira Jon-ia putepare rei vaisi oupaoro. ");
INSERT INTO roo_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Voea riro kasipu irara oea rirovira kaureopaaveira Pauto vo Saraarore, uvare oiso ruipapaaveira ra Pauto vo Saraaro-ia pituive rutu va vuri piepaoro. Voea vo pitupituaro vao oa rovoiva rutu vo Jon Baptais vo vokiaro-ia. Uva touvira vo vovou voka piepaivoi vo vokio iare. ");
INSERT INTO roo_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Varao voeao rutu profet irara ora vao Reo Taisi Moses vaaro oearoa rutu Pauto vo Saraaro iava oisoa tavitavipaave vo tugurasa Jon Baptais vo vuutaaro-ia. ");
INSERT INTO roo_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Oire vosa vo reo uvu ruipapata, ra oiso ragavira taraita, Jon eera-a Ilaija, ira vo urioaro iava tavitaviepa vo reo. ");
INSERT INTO roo_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ro ira-ia kokito toupareve, oire uvureve! ");
INSERT INTO roo_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Uva aa voeao-a voeao oea uvuipaai ra voeao tapo ora areiiave vo vokio iavapa irara? Uva voea-a evoea oea oiso toupaivoi osa kakae vure, oea paupaai vo uupa tapi okakaerovure keerapaoro. ");
INSERT INTO roo_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Oiso purapaoro, Igei visiipa pupiara-ia pupi ragapaio osa reasipatai roru arapa. Ora vo osa gau guruko tapo pura ragapaio osa reasipatai gau arapa. ");
INSERT INTO roo_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jon urioroepa aio kavuvira ora viapau ukaioparoepa aue-ia wain ovi vai aue korovo. Oa iava oiso puraaepa, Ira-ia eera tugarato vurito toupare. ");
INSERT INTO roo_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Oire uva Oirato Oviitoaaro ragai urioraepa oearovu tapo aiopasa ora ukaiopasa. Oa iava oiso purapaaepa, Rera keketa riro aioto ora riro ukaioto riroara-ia aue wain oviro korovo. Eera-a takis oupa irara vatetoaaro ora voeao vuri irara. Ari ita, Pauto vo goruaro-a vegei vo kovoaro vituaro ora Jon. Eva-a oa iava vegei vo kovoaro kuearo eveipaivere.” ");
INSERT INTO roo_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Oire ouruirovu-ia uva Jisas riroara purareva ravoto kovoro oirara porete piepara. Uva viapau oiso oearovu iava sopaura oaive porepa piropa. Uva vo voki-a vao oa-ia Jisas voeare kasipuroepa oiso puraoro, ");
INSERT INTO roo_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Siraovira rutu visiipa vao Korasin urui, ora siraovira rutu visiipa Betsaida urui. Vosa ragai oai ravoto kovo vai puraavori Taia uruireipa ora Saidon urui voari rutu tuariri oiso osa vao-ia oa puraavora visii ruvara-ia, oa iava tuariri vuri irara Taia vata ora Saidon vata oearea rutu vuri varorovi raga-ia tuupaaeri ra vo tuurova gavutara raga ivara-ia paupaave vuri vovouro oaiveva ariipaoro. Uva va-a eva oa iava vo vovouro evara tavario pirori. ");
INSERT INTO roo_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Oiraopavira rutu oiso osa visii tavipaavoi oiso, Vo vokio vao oa-ia oirara rovirieireverea Pauto ovokia-ia vo siitoka oa ouverea vo uruireo Taia ora Saidon urui, oarea-ia puteverea vo tavaka visii vaaro. ");
INSERT INTO roo_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ari ita, visii vao Kapaneam vata visiigoa kaeta viroverea vuvuiua iare ora rei vaisipaoro, eke? Viapau. Easi visii oiso vara pieiverea vuri tapire. Vosa ragai oai ravoto kovo vai puraavori Sodom urui-ia voari rutu tuariri oiso osa vao-ia oa puraavora visii ruvara-ia, oire ra vo vokio-ia vearovira toupaive Sodom urui. ");
INSERT INTO roo_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Oiraopavira rutu oiso osa visii tavipaavoi oiso, Vo vokio vao oa-ia oirara rovirieireverea Pauto ovokia-ia vo siitoka oa ouverea vo uruio Sodom urui, oa-ia puteverea rutu vo siitoka visii vaaro.” ");
INSERT INTO roo_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Vo voki-a vao oa-ia Jisas oiso puraroepa, “Aite, vii reipau vo vuvuiua-ia ora vo rasito. Vearovira rutu, uvare varao rutu vatauriva voeao asavira riro tarai irara, oa iava voeaopa vara karekeparivorao akaipa irara. ");
INSERT INTO roo_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Iu ita Aite, vii vo ruipaaro oisi raga toupai oiso osa va puraparivoi. ");
INSERT INTO roo_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Ragai Aitearo vara rutu vasereva ragai vavaearo-ia. Uva viapau irai taraipa Oviitoa-ia, ari Aitetoa raga kataito ira raga taraipa ragai-ia. Ora viapau oiso irai taraipa Aitetoa-ia, ari Oviitoa raga ragai taraiparai rera-ia, ora voeao oirara oeapa Aite oaa kareke piesa aueparai. ");
INSERT INTO roo_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Oire visii vao raverave vovou irara orekerovu vavataara kaepaoro visiigoa rutu uriota ragai iare ra visii vatea reareaa. ");
INSERT INTO roo_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ragai vo siposipoaro-a oiso osa evaova kaepa ova vao oa ragai vutuoaro-ia toupaivoi. Oa outa ra va kaeta vo ora visii vutuoaro-ia, ra ragai ruvara-ia tarai outa. Eake iava? Uvare ragai raga gavaure vovou purapaa vo oirara, uvare ora gare pieparai ragai raga. Auere ra visii vao reareaa outa ora visii varaaro-ia urauraara. ");
INSERT INTO roo_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Vao kae ova ragai vaaro oa tovopaa visii vutuoaro-ia vearoa rutu, oa-ia visii vutuo piepaavoi oa-ia viapau oiso vavataa vaiei. Uva vao rutu-a Vearo Siposipo oa-ia visii kae piepaa varaata.” ");
INSERT INTO roo_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ovokivu-ia Sabat voki utupavira Jisas vokapareva kukara kovo sovara-ia rera voeaaro tapo disaipel ogoevira toupaoro. Oa iava vo kovo iava tueaepa aue kukara. Uva vara aioiva voea raga disaipel irara. ");
INSERT INTO roo_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Uva va vao kekeiva Farisi. Oa iava rerare oiso puraaepa, “Kekeri vo pitupituo oa purai voeao disaipel oapa tugoropapeira vo vokio Sabat voki.” ");
INSERT INTO roo_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Uva Jisas voea akereva oiso, “Easi viapau pasi vo siposipo vieipataveira vao iava osa tuariri rutu Devit ogoevira toureva ora rera voeaaro tapo? ");
INSERT INTO roo_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Oa-a vao oa iava Pauto vo kepaaro-ia koataaepa oavu bret aiosa. Oa-ia oisoa Pauto-ia vuurapa vaisi purapaive. Oa iava oisoa tugoropape rutu voeaopa akuku irara raga. Uva oisoa pris irara raga va aiopaive. ");
INSERT INTO roo_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Easi pasi viapau vo siposipo vieipataveira oa vo vukuo-ia toupaiveira oa-ia Reo Taisi toupaiveira vao Moses vaaro? Oa voeao iava tavipapeira pris irara oea oisoa Tugoropa Kepa-ia tauo koko vatatopopaive. Uva oisi eisi kovopaoro Sabat vokiro rutu-ia oisoa Reo Taisi-ia tagaupaive. Uva va iava viapau vuria vai voea-ia. ");
INSERT INTO roo_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Visii tavipaavoi oiso, Orugoovuei oa vo rugoo-ia putepaivoi orugooa purapataveira vore Tugoropa Kepa aue Tempel. ");
INSERT INTO roo_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ari vosa vearovira rutu vo reore rugoo rovota oreoa oiso purapai, ‘Ragai reasiparai auepa tauo, ragoa kaviko vovou ragapa ruipaparai oirara ruvara iava.’ Ra va iava viapau voea-ia kasipua tovopata oea-ia viapau vuria vai. ");
INSERT INTO roo_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Easi Oirato Oviitoaaro raga ira uvuiparoi vo oirara rutu vo pitupituroaro rovirieipasa, varao opitupituroa purapaiveira vo Sabat voki-ia.” ");
INSERT INTO roo_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Uva voa vo kavureva Jisas Reo Taisi Uvupa Kepa iare aue Sinagog avaoro voea Jiu vo kepaaro. ");
INSERT INTO roo_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Uva voa toupareva iravu vuri vavaeto ira iava vavae keruepa. Oa iava oearovu oiso vovoupaaepa ra Jisas tavatavaeive. Oa iava rera akeiva oiso, “E vearopai ra Sabat vokiaro-ia vo kovo purapape oirara ruvarupaoro, eke?” ");
INSERT INTO roo_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Oa iava Jisas oiso voeare puraroepa, “Vosa irai visii iava iriaiaro sipsip vai rikui vai-ia koveo Sabat voki-ia, ra va iava oiso taraipavio rera-ia, Easi pasi ro viapau oiso sipsip kae pieparoveira vorevira rikui iava, raa? ");
INSERT INTO roo_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Easi viapau sipsip ragui voriaro oirato vo voriaro-ia putepaiveira? Viapau. Oire uva va-a eva oa iava uvuipatai ra oirara tapo tauvapata Sabat voki-ia Reo Taisi oavisii sirova utupaoro.” ");
INSERT INTO roo_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Oa iava oiso rera tavireva rera ro puko vavaeto, “Vavaea oara irairari va torevokooro.” Uva oisi va piereva. Oa iava oiso pieva osa ovavaevu vearo ovoipaoro. ");
INSERT INTO roo_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Uva va-a vao oa iava Farisi voava vo toreoro avaaepa ora reosa, oiso ra rera upoive. ");
INSERT INTO roo_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Vosa Jisas vo reo-ia vao tarai ovoiroepa, oire va iava voa kavuoro avaroepa. Uva riro irara oirara rera sirova utupaaepa. Uva voa-a vo uva riro irara upiapa irara ravotovira porete piepareva. ");
INSERT INTO roo_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Oa iava oiso voea tavipareva voea vosipaoro, “Opeita vao iava tavipatavere ragai iava poeravira.” ");
INSERT INTO roo_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Eisi osa iava vo reo purareva Pauto profetato gisipoaro-ia Aisaia vao oirao pieoro oa purareva Jisas, ");
INSERT INTO roo_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","‘Ro-ia ragai reraaro kovopato ira ropoavora rera reesioro. Ira kavikopaaveira rutu vovouisi-ia rera-ia rorupaoro. Ira-ia ragai reraaro Tugoropato Uraurato tovo pieaverea. Ira vao kosi piereve ragai vaaro oirara rovirieipa pitupitu vo ratau tou irarapa. ");
INSERT INTO roo_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Eera ira viapau kaureoparoverea ora viapau oiso rirovira keeraparoverea takatovira reopaoro vo raivaro. ");
INSERT INTO roo_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Aisivu pito isi aisia vikopi. Uva viapau oiso ra vaisi sigu piereve voava. Iravu wik vuravu iava ira gavagavaruvira rovapa. Oire ra va iava rera viapau oiso roko piereve rutu. Oire kovopareverea vo toupaoro vo tugurasa uva ovovourovu rutu vo pitupituroaro-ia rera vaaro torevoko pitupitu puteve. ");
INSERT INTO roo_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Uva oearovu osararovu iava ratau tou sararo rera-ia raripaaverea rerare tuepaoro.’ ");
INSERT INTO roo_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Uva vo voki-a vao-ia oa-ia iravu sipoiva oirato ira-ia oisoa toupareve vurito tugarato. Ira iava osireitoarei voosisiepa, ora gisipo tapo rera iava tupao viropa. Oa iava Jisas rera ravotovira porete piereva. Uva vorevira vurareva ora reoreoroepa tapo. ");
INSERT INTO roo_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Oire uva va-a vao oa-ia voeao riro irara tavetave iraopaiva. Oa iava oiso puraaepa, “Easi pasi Devit Oviitoaaro-a ro-ia ira roporeva Pauto, eke?” ");
INSERT INTO roo_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Uva va iava Farisi va uvuoro oiso puraaepa, “Easi oiso ragavira vao vituaro toupai. Oa vituaro iava tugara vera purapareveira aue vo goruaro iava Bielsebul tugara kare turaroaro.” ");
INSERT INTO roo_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ari ita, tuariri tarai rovoroepa voea varaaro-ia rugorugooara. Oa iava voeare oiso puraroepa, “Vosa oeavu oirara oavu katai sara ora roopa pieave, oire ora upoave ra va iava ora opesi pie ovoiave. Ora vosa oeavu katai urui iava eke katai kepa iava, ra ora roopa pieave vo sararei puraoro, oire ra ora upoave ra vo urui eva eke vo kepa eva viapau toupaive, ora opesi pie ovoiave. ");
INSERT INTO roo_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ari vosa Seten voeao sigureve ora rera voeaaro tugara kare, oire ra va iava rera vo saraaro pute ovoireve. Ra apeisi ragavira rera vo saraaro goruvira toupaive? ");
INSERT INTO roo_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Vosa oiraopavira Bielsebul ragai tauvareve vo tugara kosi piepaoro, oire ra irou voeao oea visii tauvapaiveira vatepaive gorua tugara kosi piepasa? Oire voea evoea visii raga voeaaro oea raga oiso visii vo vovouroaro ratarataa vovouro oavisii oiso kareke pieive, Visii-a vakuvakupaaverea. ");
INSERT INTO roo_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ari ita, vosa Pauto reraaro Uraurato ragaipa gorua vatepareveira, oire ra rera vo goruaro-ia tugara kosi piepaa. Ra va iava oiso taraipata, Pauto vo Saraaro pou pirora visii iare osa viapau va eveitavora. ");
INSERT INTO roo_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Apeisi-a uvuipa irai oiratoa vai ra riro varivaritoa vai kepaa vaiaro-ia koataro vore, ra auero vaiaro kavirusa? Easi viapau uvuipai. Ari vosa rera tuuke rovoreve iroiro-ia, oire va iava orekerovu rutu rera varaaro kavirureve. ");
INSERT INTO roo_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Vosa irouto ro ira viapau oiso ragai tapo kovopareve, ira-a eera ragaire isivapa. Ora vosa irouto ro ira viapau ragai iare oirara gurupareve, uva rera-a eera ira oirara sikasikapareveira ragai arova. ");
INSERT INTO roo_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Uva eisi osa iava visii tavipaavoi oiso, Pauto vuriara rutu verarevere ora orekerovu rutu takau reoro varao oara purapaiveira oirara rutu. Ari vosa ro ira Tugoropato Uraurato takaupareve rera akai piepaoro, eva-a oa-ia viapau Pauto uvuipa ra va verareve rera iava va vao vuria oaro. ");
INSERT INTO roo_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Vosa ro ira oavu purareve takau reo ragai-ia, oa-ia uvuipa Pauto ra va verareve. Ari vosa ro ira Tugoropato Uraurato takaupareve, oa-ia viapau uvuipa Pauto oiso ra va verareve rera iava. Eva rera vaaro vuria oava toupareverea vo vokio ora vo vokiri utupavira rutu. Viapau va-ia opesia vaiei. ");
INSERT INTO roo_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Vosa vearo ova, oire vo eva kuearo tapo vearovira toupaive. Ari vosa vuri ova, oire vo eva kuearo tapo vurivira toupaive. Oire ra va iava vearovira vo evarei eveipari oiso, Vearo ova vao oa kuearo oiso toupai, ari vuri ova vao oa kuearo oiso toupai. ");
INSERT INTO roo_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Visii vao-ia rakoru ovii iraraaro. Visiigoa uvuipatai vearo reo purasa, raa? Apeisi ragavira? Uvare vuri irara visii! Eake iava? Uvare eakero epao visii sopaaro-ia evara oara raga visii gisipoaro iava kosipa piroveira. ");
INSERT INTO roo_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ro vearoto oirato ira sopaaro-ia vearopa rugorugooro toupaive. Oire ra oisi raga ita vearo reoro kosi piepareve. Ari ro vurito ira sopaaro-ia vuri rugorugooro toupaive. Ra ita oisi raga ita vuri reoro kosi piepareve. ");
INSERT INTO roo_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Ari ita, oiso visii tavi iraopaa, Varao reoreo akukuro raga oara purapaiveira oirara rutu, oarare Pauto voea rutu akereverea vo vokio-ia oa-ia oirara rutu rovirieireverea. ");
INSERT INTO roo_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Oire uva va-a vao osa ragavira Pauto visii oirara eveipaoro visii rovirieireverea oiso, Vearoto-a ro ari vurito-a ro vara iava varao oara gisipoara oavisii iava kosipapi.” ");
INSERT INTO roo_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Uva vo voki-a vao oa-ia tarai irara Reo Taisi-ia oiso puraaepa ora oearovu Farisi-pa irara, “Tisato. Igei oiso ruipapaiei ra oai purari ravotoa vai, ra oai kekeio.” ");
INSERT INTO roo_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Oa iava oiso puraroepa, “Oirara voeao vuri irara oirao pie asa irara vo vokio iava oea taraa ragapaiveira oiso, Eake ravoto reesi vai kekeoro oirao pieive? Ari ita, ragai arepata, uva viapau oiso ra visiipa va puraa. Ari vao raga vao oa keketaverea oiso osa piereva Jona ravotovira. ");
INSERT INTO roo_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Vo tuariri uva Jona vo peva-ia voki toureva ora vo peva-ia rupa riroto atarito sopaaro-ia. Uva eisi osa ragai ro Oirato Oviitoaaro vo peva-ia voki touaverea ora vo peva-ia rupa vo rasito sovara-ia.” Uva Jisas ora rera iava vo reo tavipareva voeapa oiso, ");
INSERT INTO roo_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“Utupaua Pauto oirara rovirieireverea vo vokio-ia oa-ia voeao Niniva kortua-ia toreaverea. Oire ra vo vokio iavapa irara togaive reoara-ia. Eake iava? Uvare Jona vo reoaro uvuiva vao oa-ia voea tavireva. Oa iava sopaura oaive poreiva. Ari ita, vo toupare ro ira Jona-ia putepare vo osa viapau rera vo reoaro uvupata vovouisiro oavisii poresa. ");
INSERT INTO roo_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Vo osa vo voki-a vao oa-ia Pauto oirara rovirieireverea ovusa kwin o oisova Siba rovirieia-ia toreoverea. Oire ra voeao vo vokio iavapa irara togaeverea reoara-ia. Eake iava? Uvare oira o kwin tauai rutuva urioopa Solomon vo taraiaro uvusa, uvare riro taraito-a. Ari ita, uva vo touparevoi ro ira Solomon-ia puteparevoi.” Jisas ora rera raga iava voea tavipareva. ");
INSERT INTO roo_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Vo osa iravu iava kosiro viro ro-ia tugarato rera kavuoro vore avaoro raaka tapi voa ora rerapa toua vaire taraasa reareaa taraapaoro. Oire ra taraa ragaparevora. ");
INSERT INTO roo_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Oiso puraro, Voreparai vo kepao iare uva tou rovopaavora tuariri. Oire vorero vo kepa kekesa vo rara vo kepa viouive, ra vo kepa-ia viapau irai. ");
INSERT INTO roo_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Oire uva va-a vao oa-ia oisoa oeavu erao vatara tugara tuvetuvepareve ora rera iare, voeao oea vo vovouroaro vuri vovouro oisoa rera vo vovouroaro-ia putepaive rutu. Oire uva voea rutu tapo koataro vorevira voea tapo toupasa voa. Ra va iava rera vo touaro ro oirato vuri iraope rutu vo touo-ia puteoro oa-ia rera ro rovopato tugarato oisoa rera sopaaro-ia tou rovopareve. Uva oisi raga ita voeao toupaiverea vuri irara vo vokio iavapa irara.” ");
INSERT INTO roo_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisas touvira oirara vatepareva reoara osa aakova urioopa ora araoko irara, oisore ra rera tapo ora reoave. Uva ratau toupaiva. ");
INSERT INTO roo_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Oa iava iravu rera tavireva oiso, “Aako oara uvuri ora araoko irara oara vo avao ratau torepaai. Oea vii kekesa auepaai.” ");
INSERT INTO roo_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Oa iava Jisas rerare oiso puraroepa, “Irouva aako? Ora irou irara araoko irara oaa?” ");
INSERT INTO roo_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Oire uva ora rera voeaaro-ia disaipel pirooro oiso puraroepa, “Aako keketa ora araoko irara oaa. ");
INSERT INTO roo_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Vosa irouto Aite vo vovouaro sirova utuparo ro ira vuvuiua-ia toupare, eera araokotoa oaa ora taataava oaa ora aako.” ");
INSERT INTO roo_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Uva vo voki raga-ia Jisas kepa iava kosiro viropa toko rovu ruvara-ia pausa. ");
INSERT INTO roo_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Uva riro irara rutu oirara ora guruaepa rera ruvara-ia. Oa iava oavu-ia uvuoa kaero viropa voa pausa ovusa oirara rutu rogaraua-ia torepaaepa. ");
INSERT INTO roo_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Uva riroara rutu reoara purareva voeapa voa aue-ia ovoovo reo. Oa-ia oiso puraroepa voeare, “Iravu iava uvupata ira avaroera wit kokoro vikisa varuparo. ");
INSERT INTO roo_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","“Uva vikivikiparoera aue wit osa oaravu vo kovepaera raivaaro osa kokio kare voa vara aiopasa uriopaaera. ");
INSERT INTO roo_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Osa oaravu vo kovepaera avekeara ivara-ia vo uva viapau riroa vai rasia vai toupaive. Uva eisi-a osa iava ikauvira kova ragapaera. ");
INSERT INTO roo_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Vo osa ravireo kaeparo viro vara raverave piesa vara erako pieoro, aue iava uvare viapau vavurupara vai vara piepaivora vara wit kovaro. Oa iava kopiipaera. ");
INSERT INTO roo_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ari oaravu vo kovepaera kokopa kouro sovara-ia varao rokarokapara. Oa iava vara ururao papatapaivora rokarokapa kouro vara ruupasa. ");
INSERT INTO roo_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Vo osa oaravu witara vo kovepaera vearo rasi-ia, uva voa rirovira rutu witara kuepaera oiso, oaravu katai vovoto (100) kuero, ari oaravu katai vatara tau (60) kuero, ari oaravu vo peva tau (30) kuero. ");
INSERT INTO roo_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Vosa irai-ia kokitoa vai karuvira toupareve, vearopai ra va uvureve, uvare uvupatoa ita kokito.” ");
INSERT INTO roo_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Uva disaipel irara rera voeaaro urioaepa oiso purasa rerare, “Eakere reo ruuro purapariveira voeare?” ");
INSERT INTO roo_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Oa iava voeare oiso puraroepa, “Ari ita, Pauto visii kareke pierevora aue iava vatau reoro vituaro varao Pauto vo Saraaro-ia oara toupaiveira. Ari voeao, viapau. ");
INSERT INTO roo_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Vosa iravu orekerovu-ia pitupareve. Ra ita Pauto oaravu ita vatereve, ra riroara rutu pura piro rerapa. Ari vosa ro ira oaravu-ia garearavi pitupareve oara evara opesi ovoiperea rera arova. ");
INSERT INTO roo_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ari ita, ragai reo ruu vituaro iava voeapa oiso ragavira puraparai. Uva vura ragapaivo osa viapau vo reo vituaro eveipaivo. Ora va uru pie ragapaivo osa viapau va-ia taraipaai. ");
INSERT INTO roo_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Oire voea-a evoea oea-ia vo reo oirao pievira karekepai oa purareva Aisaia profetato oiso puraoro, ‘Visii vao reoara uvu ragapata oa iava viapau taraipatai vara vituaro-ia. Vara vura ragapata uva viapau orekevu avu vai eveipatavoi. ");
INSERT INTO roo_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Aue iava uvare voea ita iava rugorugooara vavagisiepa ora kokiara voea iava uvagiepa, uvare voea raga ora uvagi pieaepa. Ora osireiara oaive voea iava aauepa, uvare voea raga ora voosi pieaepa. Aue vituaro vosa viapau oisi eisi ragavira toupaive, ra va iava vearovira vurapaive ora voea varaaro iava osireiara. Ora vearovira tapo uvupaive voea varaaro iava kokiara vo rara tapo voea vaaro rugorugooara karuvira toupaive. Ra va iava ragai iare ora goripaave, ra voea porete piepaa vorevira. ");
INSERT INTO roo_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Ari ita, visii vao rorupata, uvare visii varaaro osireiara uvuipai orekerovu kekepasa, ora kokiara visii varaaro uvuipai oreorovu uvupasa. ");
INSERT INTO roo_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Oiraopavira rutu oiso osa visii tavipaa oiso, Tuariri riro irara profet irara ora oearovu torevoko irara oea oisoa ruipapaave orekerovu Pauto vo Saraaro iava vara kekepasa, ra va iava viapau vara kekepaive varao oara kekepatavoi vo vokio. Ora varapa ruipapaave vara uvupasa varao reoara raga ita viapau vara uvupaive, varao-ia oara oupatavoi ragai ruvara-ia vo vokio. ");
INSERT INTO roo_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Visii uvuta ro iava oirato ira-ia reo ruu vituaro toupai aue iava wit takuraro varao oara vikiparevora varuparo. ");
INSERT INTO roo_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Oire vo osa oisoa oirara rutu voeao vo Pauto vo Saraaro-ia reoara rutu oisoa uvupaive, ra viapau roroiopaave vara-ia. Uva va-a eva oa-ia oiso toupai osa takuraro kove ragapapeira raivaro. Oire ra Seten ikaureve vo takuraro verasa varao oara oisoa pau ragapareve Pauto voea sopaaro-ia. ");
INSERT INTO roo_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Uva oaravu wit takuraro kovepaaepa vo uva rirovira toupaiva avekeara. Oa oiso toupai, Ro ira ikauvira Pauto vo Saraaro iava vo reo uvureve, ra va iava rorupareve rutu. ");
INSERT INTO roo_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Osa viapau rera sopaaro-ia oriruvira toupaive vo reo oa uvupareve. Oreoa oiso toupai osa ikopito ro ira viapau avekeara rutu-ia goruvira pitupare rokopaoro. Oire utupauavi oearovu Pauto vo reoaro tekipasa opitupiturovu purapaive ro oirato vuri piepaoro. Oa iava rera vaaro rari vuku viapau uvupai ra gorupe vo osa va kavureve. ");
INSERT INTO roo_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Oire vo osa oaravu wit takuraro kovepaepa vo uva kokopa kouro toupai uva va-a eva oiso ragavira toupai, Ro ira Pauto vo reoaro uvu ragareve varaore rirovira vovousopaoro vo rasio-ia oiso osa varao orekerovu varaura oritopasa ora auero moniara. Uva vara-a evara oara oisoa Pauto vo reoaro vuri piepave vo rera sopaaro-ia, ra viapau aio kue vai rera-ia karekepe. ");
INSERT INTO roo_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ari vao wit oa kovepe vo vearo rasia oa oiso toupai, Ro ira reo uvuro vo rara rerapa aviavive, oire ra vare rugooparo. Oa iava rerapa kuepe oiso, katai vovoto (100), ora katai vatara tau (60), ora vo peva tau (30).” ");
INSERT INTO roo_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Oire uva Jisas oavu reo ruu vatereva ita voeapa oa-ia oiso puraroepa, “Pauto vo Saraaro oa oiso toupai, Iravu oirato vearo takuraro wit takuraro vikipareva varuparo vo rera voaro. ");
INSERT INTO roo_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ari ita, vo osa oirara rutu uusiave osa rera ro keripato urioro. Oire ra vuri takuraro isiso takuraro vikireve wit takuraro sovara-ia. Oa iava vorero. ");
INSERT INTO roo_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Oire uva wit kovo kovaepa. Oa iava kuesa auepaepa. Uva vuriva isiso kekeiva vo kovo sovara-ia. ");
INSERT INTO roo_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Oa iava kovopa irara avaaepa ro iare ira vo kovoaro-a. Uva rerare oiso puraaepa, Turaro. Igei oiso rugoopaiei, Vearoara rutu wit takuraro vikirivora varuparo. Uva eake iava vuri kou isiso kou karekei? ");
INSERT INTO roo_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Oire uva oiso voeare puraroepa, Easi keripatoa va-ia eera ira eisi evo kovo pierevo. Oa iava kovopa irara oiso rerare puraaepa, Uva apeisi vovoupau? Ra avaio oira aruosa eira vuriva isiso? ");
INSERT INTO roo_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Uva voeare oiso puraroepa, Viapau. Teapi aruopaoro isiso kou vuri kou sovara-ia wit tapo tatepata. ");
INSERT INTO roo_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Vairei rutu eakata, ra vairei rutu riroere vo tugurasa uva vairei kuearo tokopere. Oire ra visii tavia visiigoa vo kovoaro-a. Ra oira vuriva isiso guru rovotavere oira tutuukeoro vo tuukero kasisa. Oa isivaaro iava wit kuearo gurutavere ragai vo kepaaro-ia aio orirupa kepa.” ");
INSERT INTO roo_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jisas voea vatereva oavu reo ruu oa-ia oiso puraroepa, “Sara vao Pauto vaaro oa oiso rutu toupaiveira, Oavu aioa oa oiso vaisipaiveira, mastet. Uva iravu oirato oaravu oureva vara pausa rera vo kovoaro-ia va kuearo iava. ");
INSERT INTO roo_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Gare isivi rutu aisia-ia putepaiveira orekerovu rutu kuearo. Uva vosa kovape, ra kovaoro ipape, ra vara rutu-ia puteve evaoara riropavira rutu rao puraoro. Ra virata kokioro uriopaave epitapasa voa.” ");
INSERT INTO roo_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Oire uva oavu ita kosi piereva reo ruu voeapa oa-ia oiso puraroepa, “Vao Sara Pauto vaaro oa oiso rutu toupaiveira osa yis. Vosa iriavu riakova va oueve va tapo uveresa aue tapo plaua, oire va iava va vao plaua kae piro riropaoro.” ");
INSERT INTO roo_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Vo reoro rutu varao oara-ia Jisas voeapa oirara rutu oiso siposipopareva ruuvira. Uva viapau oiso oai-ia voeapa aviavi pievira taviparoepa. Ari ruuvira raga voeapa siposipopareva. ");
INSERT INTO roo_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Uva eisi-a osa vo reoa vao oa iava siposiporeva voeapa vo reo oirao piesa oa vatereva profetato. Oa-ia oiso puraroepa, ‘Ragai gisipo karuavere ruuvira reooro. Ora vo reoro iava taviravere vatau reoro, oreoroa oisoa toupaive vova vo rasio rovoaro.’ ");
INSERT INTO roo_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Oire uva Jisas voea arova oirara avaroepa kepa iare. Oa iava voa rera iare rera voeaaro disaipel irara utuaepa oiso rerare purasa, “Igei taviri vao iava reo ruu aue iava isiso kou vao oa karekeepa vo varuparo. Va vituaro kosi pieri igeipa.” ");
INSERT INTO roo_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Uva voea vo reoaro pukooro Jisas oiso puraroepa, “Ro oirato ira vearo takuraro vikireva eera-a Oirato Oviitoaaro Ro Ropoto. ");
INSERT INTO roo_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Uva va-a vao kovoa vo-ia rasitoa rutu-ia. Ari aue-ia vao-ia wit takuraro kuearo, voeao oirara oea Pauto vo Saraaro sovara-ia toupaiveira. Uva isiso vuriva oiso osa oearovu vuri irara Seten voeaaro. ");
INSERT INTO roo_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Eera ro-ia keripato ira oisoa isiso takuraro vikipareve, ira-a vuriara aue Seten. Oire uva vo voki-a vao-ia aio kovo aioaro gurupa voki, vao-ia ovoiopa vuuta oa-ia aioara guruiverea voeao-ia purapurapa irara ensel. ");
INSERT INTO roo_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ovokia-ia taru vuriva isiso guruiverea oira vikisa tuituia-ia. Eisi raga osa pieiverea Ovoiopa Vuuta-ia vao vo rasitoa-ia. ");
INSERT INTO roo_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Uva Oirato Oviitoaaro enselpa irara siporeverea ora rera voeaaro. Ra orekerovu rutu ouive varao oara oirara oirao pie vovouroaro vuri piepaiveira ora voeao tapo oirara oearoa vuri pitupituro purapaiveira. Oea vova veraiverea Pauto vo Saraaro-ia. ");
INSERT INTO roo_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Uva vo voea vikiiverea riroa-ia tuitui kasi. Uva vo kasi-a vao-ia tuitui kasi oa-ia vurivira gaupaiverea siraovira ora reuriara oaive kuripaoro. ");
INSERT INTO roo_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Oire uva vo voki-a vao oa-ia voeao Pauto voeaaro oirara torevoko irara sisikorepaiverea aviavipaoro oiso rutu roropaoro osa ravireo vo Aiteto oaive vo Saraaro sovara-ia. Ari ita, ro ira-ia kokito toupareve oire vo siposipo orirureve. ");
INSERT INTO roo_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Vao-ia Pauto vo Saraaro oa oiso rutu toupaiveira osa moni bokis vao oa oisoa vataupape varuparo kovoa-ia. Uva iravu va kekereva. Oa iava va vataureva ita vorevira. Uva va-ia rorupaoro kareroepa oaravu rutu-ia moni ousa ora rera varaaro. Uva vara voriiva rera ruvara-ia. Oa iava vo moni-ia vo rasi vorireva ora rerapa. ");
INSERT INTO roo_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Vao-ia Pauto vo Saraaro oa oiso rutu toupaiveira osa ro iravu oirato ira oisoa aasi isirore taraapareve vaisiro voripasa. ");
INSERT INTO roo_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Oire uva aisivu kekereva vearo isi rutu. Oa iava orekerovu rutu-ia ora rera varaaro monia ousa avaroepa. Oa iava vaisi vorireva vaisio vearo isi rutu aasi isi. ");
INSERT INTO roo_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Pauto vo Saraaro oa oiso rutu toupaiveira osa kuverava o iria oisoa vikipaive toko rovu-ia. Oire ra oira-ia osasararovu rutu kuverapaive aue atari. ");
INSERT INTO roo_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Oire vosa agasio kuverava, ra oira ivuoro oira vera pieive. Ra pauave vearopa kare rovirieisa voea guruoro atari kare. Ra vo kareo tovoive vearopa kare vo pekuri-ia vo kareo vuri kare vikipaoro. ");
INSERT INTO roo_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Eisi osa toupai vao-ia Ovoiopa Vuuta osa pieiverea vo rasio-ia voeao enselpa irara. Oea urioaverea vearopa irara sovara iava vuri irara roporopopaoro ");
INSERT INTO roo_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","voea vikipasa tuitui kasi-ia. Oire uva voa-a evoa uva vurivira siraopaaverea gaupaoro ora reuri oaive raga kuripaoro.” ");
INSERT INTO roo_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Uva Jisas oiso voea akereva, “Asi visii vai taraipatai varao vituaro-ia reoara?” Uva oiso rera taviiva, “Iu.” ");
INSERT INTO roo_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Oa iava Jisas voeare oiso puraroepa, “Oire vo osa voea voeao tarai irara Reo Taisi-ia vao Moses vaaro oea uvuipaai ra Pauto vo Saraaro-ia tapo tarai oupaave. Oea oiso toupaivoi osa ro ira kepa tokipareve rera vaaro kotokoto gurupa kepa. Oire ra voa koataro oaravu ousa airepara ora rutaara, ra vara rutu kosi piereve.” ");
INSERT INTO roo_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Oire uva Jisas reo ruuro pura rovorevoiva, vo urui kavuoro avaroepa. ");
INSERT INTO roo_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Uva voare avaroepa vo ora rera vo taerearo rutu-ia voa Pauto vo reoaro vatesa oirarapa Reo Taisi Uvupa Kepa Sinagog. Uva va-a vao oa iava ora sitaaepa. Oa iava rirovira tavetave iraopaiva oiso purapaoro, “Vo tarairo-ia ora varao ravotoara, ovu irao vara ourevorao rera ro-ia? ");
INSERT INTO roo_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Esa kepa paupatoa avu oviitoaaro-a ro-ia, eke? Easi viapau oiso Maria oviitoaaro-a ro-ia? Ora viapau oiso rera araoko iraraaro-a voeao-ia, Jems vase ora Josep, ora Saimon, ora Judas evoea? ");
INSERT INTO roo_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ora vairo taataa riako rutu airoa vigei tapo toupaiveira? Oire uva ovu rutu-a vo uva varao ou iraorevorao?” ");
INSERT INTO roo_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Oa iava Jisas voeare oiso puraroepa, “Ari ita, profetatoapa avivikepaaveira vo uruiara rutu. Ari vo ora rera vo uruiaro rutu uva viapau avivikea vaiei rerapa ora vo rera vo kepaaro rutu-ia.” ");
INSERT INTO roo_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Uva va-a vao oa iava viapau uvuiparoepa ra riroara vai rutu purareve ravotoara vai vo urui-ia vao rera vaaro. Aue iava uvare viapau rerapa avivikepaaepa ora oisoa rera vo reoroaro reroaropaive. ");
INSERT INTO roo_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Oire uva vo vuuta-a vao oa-ia Herot ro Galili vata turaroaro Jisas iava uvureva. ");
INSERT INTO roo_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Oa iava ora rera voeaaro kovopa irara tavireva oiso, “Jon Baptais eera ira tova tapi iava toreroi ravotopa goru ouoro.” Oire oiso-ia osa ragavira iava Jon-ia rugooroepa. Aue vituaro iava uvare ");
INSERT INTO roo_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","5","Herot ira Herodias oureva rera araokotoaaro Filip vatuavaaro. Iriapa oisoa Herot-re oiso puraparo Jon, “Viapau uvuipai ra araokotoara riakovaaro ouri. Viapau oisi torevokopapeira.” Oa iava Herot Jon-ia rovorovosiparoepa, oiso ra rera uporeve. Uva aue ragapa uririparo Jiu-pa irara, oa iava viapau voa rera uporeva. Aue iava uvare voeao Jiu-pa irara oiso rugorugoopaaepa, Profetato ro-ia Jon. Oa iava Herot Jon raureva rera tuukesa sen iro-ia. Uva rera tovoreva tuukepa kepa-ia. ");
INSERT INTO roo_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Oire uva vo voki-a vao oa-ia Herot kavaueva aakova ovokia-ia aioa purareva vo voki-a rugorugooro vao oa-ia rera kavaueva. Uva oearovu rutu tapo pauroepa vo aio-ia vao-ia. Uva vo aio aiopaiva osa Herodias oviivaaro urioopa vearovira rekurekusa rauraupaoro voea rutu osireiaro-ia. Oa iava oira vurapaoro rirovira Herot rorupareva rutu ovusa rekurekupaeva. ");
INSERT INTO roo_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Uva reo ovoi purareva oirare oiso puraoro, “Vosa eakepa ruipapau, oire ragai taviri, ra vii vatea oai.” ");
INSERT INTO roo_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Uva aakova Herodias oirapa orugoovu vateeva oa-ia oiso puraopa, “Jon Baptais kukuearo tokopari. Ra ragaipa oira tovori tauo vai-ia.” ");
INSERT INTO roo_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Uva eisi-a osa puraoiva, King Herot sopaaro vavataroepa. Oire uva vorevira vo reore rugorugooroepa ita oa purareva voea osireiaro-ia oiso puraoro, “Vosa eakepa ruipapau, oire ragai taviri, ra vii vatea oai.” Oa iava oira vo rugooaro iava pura ovoi piropa. ");
INSERT INTO roo_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Oa iava iravu arureva tuukepa kepa iare Jon Baptais kukuearo tokosa. ");
INSERT INTO roo_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Uva rera kukuearo sipoiva iriavu-ia tauo. Uva oira vateiva o tavauruva vo koko. Oa iava vo koko siposa avaopa aakovapa. ");
INSERT INTO roo_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Uva voeao Jon voeaaro disaipel oea urioaepa varaua ousa rera iava voua tovasa. Uva rera tovaivoiva Jon, avaaepa Jisas tavisa. ");
INSERT INTO roo_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jisas vo reo uvurevoiva, vo uruio kavuoro avaroepa oavu-ia uvuoa ipasa uvavure avasa kuvau tapi uva viapau oirara vai toupaive. Rera raga voare avaroepa. Oire uva rera iava uvuoro oirara rutu uruiara oaive kavuoro rogaraua-ia utuaepa toko rovu sirova rera iare. ");
INSERT INTO roo_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Uva voava Jisas veraro viropa. Oa iava riro irara rutu kekereva oirara. Uva voeapa siraoroepa. Oa iava voea iava oearovu upiapa irara porete piereva ravotovira. ");
INSERT INTO roo_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Uva vokiarovi rera voeaaro disaipel urioaepa rera iare oiso purasa, “Kuvau tapi-a vo-ia uva viapau oirara vai toupaiveira. Uva apeisi viapau voeao arupari, ra avaave aioara vai vorisa ora voeapa voraro uruiara vo vuutavio-ia? Teapi ogoevira voeare vokipe.” ");
INSERT INTO roo_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Oa iava Jisas voeare oiso puraroepa, “Eake iraore avaavere? Visii raga voea vateta aioara vai.” ");
INSERT INTO roo_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Uva oiso puraaepa rerare, “Viapau oiso igei aioa vaiei vo-ia. Ari vo vavaevi raga aue bret oava toupaio ora kataitoarei atari.” ");
INSERT INTO roo_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Uva voeare oiso puraroepa, “Varaviva uriota vore ragai iare.” ");
INSERT INTO roo_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Uva oirara tavireva ora riakora oiso, “Pauta evoa isiso kou ivara-ia.” Oa iava vo vavae oureva breteara ora ataritoarei. Uva vara-ia pitupaoro vuvuiua-ia vurareva vearo vaisi puraoro. Oa iava breteara rekarekareva disaipel vatesa. Uva oirara vatevateiva vara. ");
INSERT INTO roo_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Voea rutu aioiva, oa iava vukuaepa. Oire uva ururukoara guruguruiva varao oara arova vukuaepa. Uva oisi raga disaipel irara katai tau erao (12) agasi pieiva aue pekuri. ");
INSERT INTO roo_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Uva voea voeao oirara oea rutu vo aio aioiva vao vo vavae tuku rutu (5,000). Ari ita, viapau riakora vieiiva ora kakae vure. ");
INSERT INTO roo_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Uva Jisas rera voeaaro disaipel tavireva oiso, “Uvuoa-ia irata vavo oisore iviropa varata toko rovu iava.” Oire uva oiso ruipaparoepa ra oirara ruture koruro, ra voreave kareoro uruiara oaive iare. ");
INSERT INTO roo_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Uva rera raga oavu-ia pukuia-ia iparoepa voa varirisa. Oire uva voa toupareva osa rerare ovaiaepa. ");
INSERT INTO roo_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Osa tauai rutu avaaepa uvuoa-ia disaipel irara raga. Oa iava vo rovu toko rovu vuruvuruaro rutu-ia ora tovoaepa. Uva voa riroto kiuvu voeare vusireva. Oa iava toruva uvuoa sisiputapaeva voa voeava. ");
INSERT INTO roo_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Uva avipaepa ovusa Jisas voea iare uturoepa toko rovu ivara-ia vokapaoro voea ruvara-ia pou virosa, ovusa ravireo kae viro asavira toupareva. ");
INSERT INTO roo_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Oa iava rera tueiva osa vokapaoro urioparoepa toko rovu ivara-ia voea iare disaipel. Uva rirovira rutu rikerikepaoro oivepaoro uriripaaepa rera asavira. Oa iava oiso puraaepa, “Avoeao, asi tugarato-a ro!” ");
INSERT INTO roo_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Uva ikauvira Jisas voeare oiso puraroepa, “Opeita uriri ragapata. Sopaura oavisii goru pieta. Easi ragai-a vao ragoa uturai.” ");
INSERT INTO roo_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Uva Pita rerare oiso puraroepa, “Vosa vii-a vao Turaro, oire ragaire keerau. Ra vii iare oisi eisi vokaoro uriora vo vao ivara-ia rovua.” ");
INSERT INTO roo_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Uva Jisas oiso puraroepa, “Uriou.” Oa iava Pita uvuoa iava rere ovoioro voka rovoparoepa uuko rovu ivara-ia Jisas iare. ");
INSERT INTO roo_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Uva kiuvu sovooro uririroepa. Oa iava roko rovosa auepaoro osa oiso puraroepa, “Turaro! Ragai-ia pituri!” ");
INSERT INTO roo_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Oire ikauvira Jisas vavaea tovoreva Pita-ia pituoro. Uva oiso puraroepa, “Gareavi raga-a eva raria oava touparivoi. Eakere vo rugorugoorei rutuva toupari?” ");
INSERT INTO roo_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Oire uva voava kaesi viropa uvuoa iare osa kiuvu rakote ovoiroepa. ");
INSERT INTO roo_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Osa voeao oea uvuoa-ia toupaiva oea oiso purapaaepa rera-ia vuurapa vaisi purapaoro, “Oiraopatoa rutu vii Pauto Oviitoaaro.” ");
INSERT INTO roo_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Uva toko rovu ivirooro rereiva Genesaret iare. ");
INSERT INTO roo_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Uva voea voeao voava vo-ia rera eveiiva oiso, Eari Jisas-a ro-ia. Oa iava reo vikiaepa uruiara rutu iare varao Genesaret taere sovara-ia. Oa iava upiapa irara rutu sipoiva rera iare. ");
INSERT INTO roo_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Osa iava rirovira rutu rerare oiso purapaaepa, “Jisas, igeipa vaseri eera iava kuvupato, ra rera raga vatuaro-ia pitupaoro poretepaio.” Uva va iava oisi voeapa rera iava ora vaseroiva, rera vatuaro-ia pitupaoro porete ovoipaaepa voea rutu. ");
INSERT INTO roo_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Oire uva vo vuuta-a vao oa-ia Farisi ora oearovu Reo Taisiro-ia tarai irara oea Jerusalem iava urioaepa Jisas iare. Uva oiso puraaepa, ");
INSERT INTO roo_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Apeisi iava voeao disaipel Reo Taisi-ia tagau iraopaiveira vigei aao iraraaro varaaro? Aue-ia vosa aiosa auepaave, ra viapau oiso vavaeara sisu rovoave Tugoropa Reo Taisi sirova utupaoro.” ");
INSERT INTO roo_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Oa iava Jisas voea vo reoaro pukooro oiso puraroepa, “Apeisi ragavira iava ora visii raga vo pitupituroaro sirova utupataveira Pauto vaaro-ia tagaupaoro Reo Taisi? ");
INSERT INTO roo_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Pauto oiso puraroepa, ‘Aitetoarei oarapa ora aakoara ora avivikepau. Ari vosa ro ira aitetoarei takaupareve, eera-a ira kopii pieivere oearovu.’ ");
INSERT INTO roo_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Uva visii oiso purapataveira oirara siposipopaoro, Aako ora aite viapau uvuiparai ra vei vatea varao vei tauvapasa. Uvare vara rutu varao vate rovoavora Pautoa-pa. Vosa eisi oirara tavitavipata oiso, Eagara, uvuipatai ra oisi eisi aite irara oavisii piepata. Oire eva-a oa-ia Pauto vaaro Reo Taisi akaipa piepatavere visii vo pitupituroaro rigaoro ora visii iare. ");
INSERT INTO roo_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Visii vao-ia riro ratarataa vovou irara, visiigoa reesireva Aisaia vearovira rutu oiso puraoro, ");
INSERT INTO roo_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Voea rutu ragai vaisiaro kae pie ragapai gisipoara raga iava osa voea sopaaro tauaipai rutu ragaipa. ");
INSERT INTO roo_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Oea oirara varaaro reo goruro iava tavipaaveira. Uva viapau oiso vo reo-a eva Pauto vaaro. Eisi osa iava ragai-ia vuurapa vaisi pura ragapaiveira.’” ");
INSERT INTO roo_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Oire uva Jisas oirara ruture keeraroepa ora rera iare. Uva oiso puraroepa voeare, “Visii uvuta vearovira rutu, ra vare rugoopata. ");
INSERT INTO roo_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Viapau oiso vao oa aiopare oirato oa rera sopaaro vuri piepaivoi. Ari varao-a oara rera sopaaro iava kosipa piroi, evara oara oirato vuri piepaivoi.” ");
INSERT INTO roo_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Uva vo voki-a vao oa-ia urioaepa disaipel rera tavisa oiso, “Farisi vii vo reoaro uvuivo. Oa iava vuri vovoupai. E pasi va vai-ia taraiuei vao?” ");
INSERT INTO roo_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Uva Jisas oiso puraroepa, “Aite toupare eisi vuvuiua ira auero rutu ketoo piepareveira. Ari varao oara viapau ketoo piereve oara rutu evara tatereverea iroara tapo. ");
INSERT INTO roo_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Voea eakata uvare voea-a voosi irara oea raiva purapai oearovupa voosi irara. Ari ita, vosa vaiterei raga voositoarei ora tuvetuvepaoro avapasi raiva-ia, ra kovesi rikui-ia vaiterei rutu.” ");
INSERT INTO roo_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Uva Pita Jisas aatoreva, “Oire vo reo vituaro karuri vao-ia reo ruu. Ra va uvuio.” ");
INSERT INTO roo_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Uva Jisas oiso puraroepa, “E avoeao, visii tapo viapau rugorugooara vaiei? ");
INSERT INTO roo_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Easi visii viapau taraipatai auero rutu-ia varao oara gisipo-ia rokopaiveira vore sare. Oire ra sare vo vikieve vore gare kepa. ");
INSERT INTO roo_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ari vao oa gisipo iava kosipa piroveira vovouisi rutu iava, oa-a eva oirato vuri piepaiveira. ");
INSERT INTO roo_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Oire uva vo rugooro-a varao vuri rugooro oara kosipa piroveira oirato sopaaro iava, oira upo, otopa pitupituro, kaakau kare vo pitupituaro, kaviru, keakea reo, reo toga. ");
INSERT INTO roo_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Oara rutu oirara vuri piepaiveira. Ari vosa ro ira vavae sisu asavira aioa-ia pitureve, viapau oiso eva-ia vuria vai epao.” ");
INSERT INTO roo_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jisas vo uruio iava avaroepa vo taereo iare oa-ia oisoa vo uruireo toupaive Taia urui ora Saidon urui. ");
INSERT INTO roo_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Uva iriavu riakova Kenan iava ratau tou irara iava oira, iria oiso keeraopa rerare, “Turaro vii-a Devit Oviitoaaro viigoa roporeva Pauto. Ragaipa siraou. Vurito tugarato kakaeva oaa vuri piepareveira.” ");
INSERT INTO roo_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Uva viapau Jisas oira vo reoaro aatopareva. Oa iava disaipel urioaepa rera tavisa oiso, “O riakova keerapaoro vigei sirova utupaoi. Oirare koruu.” ");
INSERT INTO roo_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Uva Jisas voeare oiso puraroepa, “Pauto ragai siporevora voeao raga iare Jiu, oea oiso toupaiveira osa sipsip ragui voeao vova Isrel-ia oea opesikoaepa.” ");
INSERT INTO roo_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Uva riakova urioopa rekusa ora taku virosa rera ruvara-ia oiso puraoro, “Turaro, ragai tauvari!” ");
INSERT INTO roo_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Uva Jisas oirare oiso puraroepa, “Teapi aioara oupe kakae vure varaaro kaakau karepa vara vikisa.” ");
INSERT INTO roo_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Uva oiso puraopa, “Turaro, oiraopavira eisi purauei igeire ratau tou irara. Ari ita, kaakau kare ururukoara aiopaiveira varao oara tebol iava kovekovepapeira.” ");
INSERT INTO roo_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Oa iava Jisas oiso puraroepa, “Ae auoo, vii vaaro riroa rutu raria. Oapa ruipapauei, oiso ra vii-ia karekepe.” Uva vo vuuta raga-ia eva voaviva porete ovoiopa kakaeva. ");
INSERT INTO roo_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Uva voa vo kavuoro avaroepa Jisas toko rovu ruvara iare vao vo Galili. Uva voa pukuia-ia iparoepa pausa. ");
INSERT INTO roo_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Uva riro irara oirara ora riakora urioaepa rera ruvara iare ora gurupasa vuri kokoto irara sipopaoro rera iare, ora voosi irara, ora regorepa keru irara, ora voeao oea iava oisoa gisipoara kapuuvira raga toupaive, ora oearovu rutu oearoa tapo uriopaaepa rera kokotoaro ruvara-ia voea tovopasa. Uva voava voea porete piepareva ravotovira. ");
INSERT INTO roo_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Uva rirovira rutu tavetave iraopaiva. Aue iava uvare reoreo asa irara reoreoaepa, ora voeao regorepa keru irara oea tapo vearopaaepa vorevira, ora voeao vuri kokoto irara oea tapo vorevira vokapaiva, ora voeao voosi irara oea tapo vorevira vuravuraiva. Uva eisi osa iava Pauto vaisiaro kae pieiva rera-ia vuurapa vaisi puraoro ro Jiu reraaro. ");
INSERT INTO roo_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Uva Jisas disaipelre keeraroepa. Oa iava oiso puraroepa voeare, “Sirao iraoparai voeaopa oirara, uvare vo peva rutu-ia voki ragai tapo toupaivoi aio asavira. Uva reasiparai ra ogoevira voea arua. Teapi osireiara voeare avavaraopape raveravepaoro ogoetoa iava raivaaro karepaoro.” ");
INSERT INTO roo_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Oa iava disaipel rera akeiva oiso, “Uva ovu opoara vai toupai voeapa, ra voea aio piepe? Ari raaka tapi raga vo-ia.” ");
INSERT INTO roo_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Uva Jisas voea akereva oiso, “Visii ovirovua toupai aue bret?” Uva rera taviiva, “Ari erao vatara (7) aue bret oarava toupaio ora garearavi atariara.” ");
INSERT INTO roo_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Oa iava Jisas oirara rutu tavireva oiso, “Pauta evoa rasiuaaro.” ");
INSERT INTO roo_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Uva erao vatara-ia bret ora aue atariara vearo vaisi purareva Pautoa-ia. Oa iava voava vara rekarekareva. Uva disaipel vatevatereva. Oa iava evoea oirara rutupa vara vatevateiva. ");
INSERT INTO roo_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Uva voea rutu vukuaepa. Oa iava aio opesiaepa. Uva ururukoara guruguruiva. Oa iava erao vatara (7) pekuri agasi pieiva. ");
INSERT INTO roo_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Uva voea rutu vieiaro-a voeao oirara vo resura tuku (4,000) rutu. Uva viapau oiso riakora tapo vieiiva ora kakae vure. ");
INSERT INTO roo_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Oa iava Jisas voea aru ovoioro kaero viropa uvuoa-ia avaoro Magadan taere iare. ");
INSERT INTO roo_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Vo Farisi urioaepa voearei ora Sadyusi-pa irara Jisas-ia kokarasa, oiso ra voea osireiaro-ia ravotoa vai purareve Pauto vo goruaro-ia karekeoro. ");
INSERT INTO roo_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ari Jisas voea vo reoaro pukooro oiso puraroepa, “O ita, visii vao visiigoa oiso purapataveira vo ovaiarovi, Vuvuiua revasivira kekepi. Ari vokipavira raipipere. ");
INSERT INTO roo_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ora vokipaua oiso purapataveira, Rukuta rupapaoi. Oa iava vuvuiua revasipai. Uva kiuvu vusirevere ora kokeva koveovere vo voki-ia. Iu ita, visii ita vuvuiua vo reesiaro kekepataveira. Oire vearovira rutu vara rovirieipata. Ari varao kekepataveira oara vo vuuta vao reesipaiveira osa viapau vara eveipata. ");
INSERT INTO roo_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Oiraopavira, oirara voeao vuri irara oirao pie asa irara voeao vo vokio iava oea taraa ragapaiveira oiso, Eake ravoto reesi vai kekeoro Pauto oirao pieive? Ari ita, ragai arepata, uva viapau oiso ra visiipa va puraa. Ari vao raga oa keketaverea oiso osa piereva Jona vo peva voki-ia ora vo peva rupa peva.” Uva Jisas voea arova avaroepa. ");
INSERT INTO roo_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Oire voeao-ia disaipel oea toko rovu iviropaoro uriopaaepa auere bret ovaupaoro. ");
INSERT INTO roo_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Uva Jisas oiso puraroepa voeare disaipel, “Visii vao-ia uutuvira rutu toupata vaore yis Farisi ora Sadyusi vaaro.” ");
INSERT INTO roo_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Oa iava oiso ora voea raga ora reopaaepa, “Ari eake-a viapau aioara vaiva urioviei, oa iava oiso vigeire reopa?” ");
INSERT INTO roo_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Oire uva Jisas voea-ia tarairoepa. Oa iava oiso puraroepa, “Uva eakere oiso ora reopatai, Vigeire reopa aio arapa varao oarare ovauviei uriooro? Ari ita, visii vao gareavi ragava toupatavoi raria. ");
INSERT INTO roo_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Easi pasi ragai vo goruaropa sopaivira toupata, raa? E viapau vaore rugoopatai bret vavae oa vateavora voeaopa vo vavae tuku (5,000) rutu aue oira, eke? Ora ovirovua pekuri oara agasi pietavora aue-ia aio ururukoro? ");
INSERT INTO roo_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ora pasi viapau vaore erao vatara breteara rugoopatai oara vateavora vo resura tuku (4,000) rutupa aue oira? Uva ovirovua pekuri oa agasi pietavora? ");
INSERT INTO roo_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Apeisi iava viapau oiso taraipatai, Viapau visii tavipaavo aue iava bret? Visii vao ora vatatopo iraopata uutupaoro vaore yis Farisi ora Sadyusi-pa irara vaaro.” ");
INSERT INTO roo_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Oire uva va iava oiso taraiaepa, O asi viapau oiso vigeire reoparoi ra vaopa vatatopopavio yis vao plaua kae piepa. Viapau. Ari vaopa Farisi ora Sadyusi vo siposipoaro oapa vigei vatatopo pieparevoi. ");
INSERT INTO roo_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jisas oiso ragavira avaroepa Sisaria taere Filipai-ia. Uva vo vuuta-a vao oa-ia disaipel akereva oiso, “Apeisi ragavira ragai vaisipaiveira oirara?” ");
INSERT INTO roo_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Uva oiso puraaepa, “Ari oearovu oiso vii vaisipaiveira, Jon Baptais, ovusa oearovu oiso, Ilaija, ari oearovu oiso, Jeremaia, ora oearovu oiso purapaai, Vii iravu voea iava profet irara.” ");
INSERT INTO roo_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Uva Jisas oiso voea akereva, “Ari apeisi visii raga ragai vaisipata?” ");
INSERT INTO roo_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Uva Saimon Pita rerare oiso puraroepa, “Vii-a Krais Pauto Oviitoaaro, ro Tootoo Ovoi ira vii arureva vore.” ");
INSERT INTO roo_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Oa iava Jisas oiso puraroepa rerare, “Saimon, Jona oviitoaaro roruri, uvare viapau oiso vo rasitoa iava irai vii tavirevoi vo vaisio iava. Viapau. Ari Aite raga ro ira toupareveira vuvuiua-ia ira vo vaisio iava vii tavirevoi oiraopa. ");
INSERT INTO roo_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Uva vii tavipaa oiso, Pita, oiso toupari osa aveke o peka pie asava. Lotua vituaro aveke-ia iria-ia vo Lotu pauavere. Uva kopiia vo goruaro viapau uvuipai oiso ra vo Lotu opesi pieive. ");
INSERT INTO roo_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Uva viipa ki vateavere karupava o iria-ia uvuipau ra karuri Pauto Saraaro-ia oearovu oirara koata piepasa. Vosa eake pitupituro-ia taraipau vova rasito, oire ra vara iava o pitupiturovure korukorupau, oarare korukorurovere vuvuiua-ia. Ari vao oa iava vaseri vo rasito, oa iava vaserevere Pauto vova vuvuiua.” ");
INSERT INTO roo_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Uva Jisas goruvira rutu voeare oiso puraroepa voeao disaipel, “Opeita irai tavipatavere oiso ragai vaisipaoro, Ro Krais Pauto reraaro vigei Tuvetuvepato.” ");
INSERT INTO roo_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Oire vo vuuta-a vao oa iava vo vokia Jisas ora rera iava roroio pievira disaipel tavitavireva voea vosipaoro. Oiso puraroepa, “Jerusalem iare avaravere turaro irara iare voea rutu, ora voeao pris, ora voeao oea Reo Taisi-ia taraipaai, oiso ra voa riroara vai siitokaara ouavere vo osa ragai upoive. Oire ra vo peva voki-ia vorevira torera.” ");
INSERT INTO roo_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Uva Pita rera auauoro avaroepa vatuarore rerare oiso pura rovosa, “Turaro. Easi viapau vao vii-ia karekepere!” ");
INSERT INTO roo_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Uva Jisas ora poreroepa Pita-re oiso purasa, “Seten. Ragai isivaaro-ia ora tovou. E ragai-ia kokarapau ragaire korupaoro Pauto vo ruipaaro pura arapa? Eva vii vaaro rugorugooa, viapau oiso Pauto vaaro-a. Oirara raga vo rugooaro eva.” ");
INSERT INTO roo_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Oa iava voeare disaipel oiso puraroepa, “Vosa irai ragai sirova utu vovouparo, oire ra ora rera iava vaisia vara pie rovoreve. Ra ora rerapa vavata siitoka kaeoro uturo ragai sirova, vo vavata vao oa oiso toupai osa evao parikou. ");
INSERT INTO roo_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ro ira tootooa virivaripareve, oava eva opesiroverea tootooaro. Ari ro ira tootooaro vatereve vo oearovupa ragai vo ruipaaro sirova utupaoro, eera-a ira tootooaro tapo virivariavere taru. ");
INSERT INTO roo_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Aa vao-a vearoa oa oureverea oirato vo rasio-ia vo rara auero rutu vo rasio iava oureve, vo osa tootooa oaro rutu viki ragapareve rasito oaraaro-ia rugorugoopaoro? Eake vai oureverea vorevira tootoo oaro-ia tavariovira? Viapau oavu avu vaiei rerapa. ");
INSERT INTO roo_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Oirato Oviitoaaro Ro Ropoto kerariava voreroverea Aiteto vaaro. Ora aue tapo enselpa irara oirara vorisa kovoara oaive uvuioro oiso osa uvuivira kovoivora. ");
INSERT INTO roo_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Oiraopavira visii tavipaa oiso, Oearovuei vo-ia visii iava oea viapau tuguraaverea kopiia-ia oea tootoovira toupaiverea osa ragai Oirato Oviitoaaro turarovira urioraverea osa ragai kekeive.” ");
INSERT INTO roo_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Uva katai vatara (6) aue voki putevoiva, Jisas vo Pita vase oureva, ora Jems araorei ora Jon. Uva voea tapo iparoepa oavu-ia riro pukui, uva voa raga toupaiva. ");
INSERT INTO roo_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Uva Jisas iava varaua ora tavarioepa vo voea osireiaro-ia. Oa iava sisikorevira kekero viropa osa rera iava kagave aviavieva sirusiruoro rutu oiso osa ravireo. Varoara tapo rera varaaro popotevira keke piropa oiso osa aviavia. ");
INSERT INTO roo_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Uva voa-a evoa uva Moses vaio ora Ilaija Pauto ruvara iava ora karekesiepa Jisas iare vo pukuia kukuearo-ia. Uva voa rera tapo ora reopasiepa osa voea disaipel vo peva siituepaiva. ");
INSERT INTO roo_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Uva va-a vao oa kekereva aue Pita. Oa iava Jisas-re oiso puraroepa, “Turaro, vearovira rutu vo touei vigei rutu vao. Apeisi vovoupauei ra kepa peva vai pauio oiso, vii okepai, ari Moses okepai, ari Ilaija okepai?” ");
INSERT INTO roo_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Uva oisi raga puraoepa osa rukuta popoteva voea tavurusa urioopa riro aviaviva. Uva oavu reo guruko karekeepa ruruta sovara-ia. Uva oavu reo guruko karekeepa rukuta sovara-ia oa-ia oiso puraroepa Pauto, “Eera-a ira Oviitoa oaa, ira kavikopaaveira rutu rera-ia rorupaoro. Ira vo reoaro uvuta!” ");
INSERT INTO roo_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Uva voea disaipel vo reoreo vao uvuoro takua viropa rasiuaaro, uvare va uvuoro rirovira rutu uriri iraoaepa. ");
INSERT INTO roo_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Uva Jisas urioroepa voea ruvara iare. Oa iava-ia pituoro oiso puraroepa, “Opeita uriripata. Toreta.” ");
INSERT INTO roo_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Oa iava vuravuraiva. Uva viapau oiso irai kekeiva oiratoa vai. Ari Jisas raga. ");
INSERT INTO roo_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Oire uva pukuia iava varapaoro touvira Jisas oiso goruvira rutu voea vosipareva oiso purapaoro, “Vao-ia oa keketavoi opeita va iava tavipatavere. Ari vo raga osa ragai tova urui iava vorevira tore rovoraverea.” ");
INSERT INTO roo_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Uva disaipel oiso rera akeiva, “Apeisi ragavira iava tarai irara Reo Taisiro-ia oiso purapaaveira, Ilaija urio rovoroverea, ra rera sirova uturo Pauto reraaro vigei tuvetuvesa?” ");
INSERT INTO roo_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Uva oiso puraroepa, “Ari ita, oiraopavira Ilaija urio rovoroverea orekerovu rutu torevoko rovosa. ");
INSERT INTO roo_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Uva visii tavipaavoi oiso, Ilaija urio rovoroera uva ora voea-ia rera goguivora. Oa iava rera-ia oiso vo pitupituro puraivora eisi raga ita osa ragai pieiverea ragaipa siitoka vateoro ita.” ");
INSERT INTO roo_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Uva oisi-a eisi osa Jisas puraroepa. Oa iava disaipel rugorugooaepa oiso, O! Ari Jon Baptais iavirava Ilaija vaisirevo. ");
INSERT INTO roo_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Oire uva oirara rutu ruvara iare avaaepa. Oa iava voa rera ruvara-ia rekusa urioroepa iravu oirato ");
INSERT INTO roo_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","oiso puraoro, “Turaro. Siraou ragai oviitoaaropa. Ira kokopeko upia tapo purapareveira. Oa iava varaua rerare vurivira toupaiveira. Ari ita, vokiara rutu-ia koveparoveira tuitui kasiro iare. Ora vokiara rutu-ia tapo uuko oviro iare koveparoveira tuutuusipaoro. ");
INSERT INTO roo_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Rera sipoavorao oeavu iare disaipel vii voeaaro. Uva viapau oiso uvuiaerao oiso ra rera porete pieive.” ");
INSERT INTO roo_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Uva Jisas oiso puraroepa, “Ae! Visii vao-ia visiigoa-ia viapau oirao pie vovou vai toupai. Visiigoa viapau torevoko vovou vaiei. Uva ovirovu-ia vuuta visii tapo toupaaverea? Ora ovirovu purapaaverea visii vo vovouroaro-ia kasikasipaoro, osa viapau goruvira ragai vaaro-ia pitupata? Rera sipota ragai iare!” ");
INSERT INTO roo_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Uva Jisas rerare ro tugarato kasipuvira reoroepa rera kosi pieoro viovokotoa iava. Oa iava rera iava upia opesi ovoiepa. ");
INSERT INTO roo_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Oire uva voea raga disaipel urioaepa Jisas iare rera akepasa oiso, “Apeisi ragavira iava viapau uvuipaiei tugara kosi piepasa?” ");
INSERT INTO roo_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Uva voea tavireva oiso puraoro, “Raria oavisii garepai oa iava viapau uvuipatai. Iu, oiraopavira eisi osa visii tavipaa, Vosa rari vukuro vai toupaive oiso osa mastet kuearo garepa takurarovi rutu, oire va iava vo pukuiore oiso purata, Toreu ra vova avau uvaire. Ra avape. Vosa oisi eisi visii varaaro rariara oisi toupaive, oa iava uvuipatai osasararovu rutu purasa kovo oisi eisi. ");
INSERT INTO roo_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Uva viapau oraivai epao tugara kosi piepa raiva vai. Ari vao raga vosa aio kavu rovopata variria purapasa katai rugoo raga-ia.” ");
INSERT INTO roo_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Uva avaaepa Galili iare. Oa iava voa Jisas disaipel vosireva oiso puraoro ora rera iava, “Tutuu pievoi ra Oirato Oviitoaaro Ro Ropoto tovoive oirara vavaearo-ia. ");
INSERT INTO roo_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ra rera upoive rera kopii pieoro. Oire voava vo pevapa vokia vorevira torerovere.” Oa iava disaipel vovouaro rirovira vavataaepa. ");
INSERT INTO roo_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Oire uva Kapaneam-ia pou virosa avaaepa. Uva voeao moni oupa irara urioaepa Pita ruvara-ia oiso akesa, “E visii tuvetuvepatoaaro avu moniara vai vikipareveira vo kepa-ia Rovopa Kepa Tugoropa Kepa takis voripaoro, eke?” ");
INSERT INTO roo_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Uva Pita oiso puraroepa, “Iu.” Oa iava koataroepa kepa-ia. Uva Jisas reo rovoroepa oiso rera akeoro, “Saimon. Apeisi rugoopau voeao-ia turaro irara vo rasio tokipa irara. Irou ruvara-ia oisoa moni oupaave, ora voea raga vo ovii irara oaive ruvara-ia, eke oearovu raga voeao tauai irara?” ");
INSERT INTO roo_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Oire uva va-a vao oa iava Pita oiso puraroepa, “Ari voearo ruvara-ia oisoa moni oupaave tauai irara iava voea.” Oa iava Jisas oiso puraroepa, “O ita, oa vituaro-a vao oa iava voeao ovii irara oaive viapau moni vikipaaveira takispaoro. Osa ita viapau uvuiparai ra monia vai vatea takisoro vo kepao-ia Aite oaa vo kepaaro. ");
INSERT INTO roo_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ari ita, teapi voea kasipu piepe. Uva oiso vii tavipaa, Avau toko rovu iare ataritoa vai kaa piesa. Uva rovotoa vai kaa pierivere, ra irai gisipoaro gaari. Ra monia vai ouri. Oire ra oaiva voreu vegeipa takis vorisa Tugoropa Kepa-ia vao uvui pieoro vegei vaaro.” ");
INSERT INTO roo_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Uva vo vuuta-a vao oa-ia disaipel urioaepa Jisas iare oiso akesa, “Irou vai oearovu rutu-ia putepai vo Sarao-ia Pauto vaaro?” ");
INSERT INTO roo_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Oire va iava Jisas iravure kakaeto keeraroepa. Oa iava rera tore piereva voea vuutaaro-ia. ");
INSERT INTO roo_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Uva oiso voeare puraroepa, “Visii tavi iraopaavoi oiraopavira oiso, Vosa visii vovouisiro oavisii iava viapau poreta viro, ra viapau oiso Pauto vo Saraaropa ruipapata osa ro-ia kakaeto vapa ruipaparoveira, uva viapau uvuita koatasa vo Pauto vo Saraaro-ia. Viapau rutu! ");
INSERT INTO roo_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Vosa ro ira ora akaipa pieparo ra oiso karekero osa ro-ia kakaeto, ira oearovu rutu-ia putepare Sara-ia Pauto vaaro. ");
INSERT INTO roo_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Ari vosa irai visii iava ragai vaisiarore rugoopaoro oiso irai tauvareve kakaetoa vai, ira-a eera ira ragai tauvapare. ");
INSERT INTO roo_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ari ita, vosa irai oiratoa vai ira kakaeto raria vaiaro vuri piereve voeao iava kakae vure oea ragai-ia raripaaveira, uva vearopai oiso ra oeai rera-ia riroa vai aveke vai tuuive rera okoearo-ia rera roko piesa avakava vuruvuruaro-ia. ");
INSERT INTO roo_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Siraovira rutu oirara-ia voeao vo rasio-ia oea oearovu kove piepaiveira vuri vovou-ia. Oiraopavira rutu vao-ia vuri pitupitu oa karekeperea. Ari ita, uva siraovira rutu-a ropa ira voea kove piepareveira vuria-ia. ");
INSERT INTO roo_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Oire vosa ovavaevu visii kove pieive ora okokotovu, vearopai va tokooro va-ia vikiu, ra katai vavae ragava ora katai kokoto toupari. Oa iava uvuipau ra vearo tootoo-ia ouri. Teapi vo vavaerei rutuva ora vo kokotoarei rutuva touparivora, vara rutuva vii vikiiverea tuitui kasi iare okasia viapau rokoa vai vo vuri tapi. ");
INSERT INTO roo_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ari ita, vosa osireito vii kove piereve vuri vovou-ia, oire rera tateri rera vikisa, ra kataitoa ragava toupari. Oa iava uvuipau ra tootooa rutu-ia karekeu. Teapi vaiterei rutuva touparivora, vaitereiva vii vikiiverea vo tuituia-ia vao oa viapau rokopaive. ");
INSERT INTO roo_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Visii vao vatatopo iraopata. Teapi oiso keapata voeao vuutaaro-ia kakae vure akaipa irara raga. Visii tavi iraopaavoi oiso, Vo vuvuiua uva enselpa irara epao voeao oea kakae vure tokipaiveira oea vokiara rutu-ia Aite puaaro kekepaiveira ira touparevoi vo vuvuiua-ia. ");
INSERT INTO roo_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Eake iava uvare ragai-a vao Oirato Oviitoaaro Ro Ropoto urioraera oirara ousa vorevira voeao oea opesikoaepa, ra va iava voea vorevira vorea Pautoa-re. ");
INSERT INTO roo_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Apeisi vai rugorugoopatai? Vosa irai oiratoa vai katai vovoto (100) sipsip ragui tokipareve. Oire vosa iriavu opesikoo, ra viapau oirare taraapareve, eke? Iu! Ra ita aue raga kavu piro vo resura vatara tau vo resura vatara (99) pukuia-ia vo uva vo ragui tokipareve, ra oirare kataiva rororo. Ra voava oirare taraasa avaro o iria opesikoo. ");
INSERT INTO roo_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Oiraopavira visii tavipaavoi oiso, Vosa vorevira oira oureve o iria opesikoo, ra rirovira rorupareve rutu. Vo roruo-ia pute pievira oa tou rovopaive vao-ia vo resura vatara tau vo resura vatara (99) sipsip vo rara vorevira oira oureve vo ragui iare. ");
INSERT INTO roo_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Eisi osa raga vao toupai Aite oavisii vo vovouaro ro vova vuvuiua. Ira vaopa reasiparoveira, opeita iravu opesikoro voeao iava garepa kakaerovi. ");
INSERT INTO roo_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Oire vosa araokotoa vai oavisii vuria purareve visii-ia, oire avata rera iare, ra rera tapo pauta rera aviavi piesa. Ra rugooro vaore vuria oa purareve visii-ia. Uva oiso rutu toupai, Rera agiagita vo rara visii vo reoaro uvureve. ");
INSERT INTO roo_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ari vosa viapau visii uvureve, oire aitereivu outa ra visii peva rutu avata rera iare. Uva eva oiso toupai, Vaiterei evaiterei o vo peva oea rutu katai reo purapaoro vii vo reoaro oirao piepai, oiso osa purapapeira Tugoropa Vuku. ");
INSERT INTO roo_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ari vosa viapau visii vo reoaro uvureve, oire oirao pie vovou irara gururi voea tavisa va iava vao-ia voeao lotupa irara. Oire ra vosa voa evoa viapau visii rutu uvureve, ra oiso rerare purata, Auoro, oirao pie asato rutu vii kaviruto, takis oupato. ");
INSERT INTO roo_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Oiraopavira oiso osa visii tavipaa oiso, Auero rutu varao oarare korukorupatai vo rasio-ia, Pautoa tapo oarare korukorurovere vo vuvuiua-ia. Ari varao oara rutu tapo vasepata vo rasito, Pautoa tapo-a oara vaseparevere vo vuvuiua-ia visiipa. ");
INSERT INTO roo_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Uva vorevira ita aia visii tavipaavoi oiso, Vosa visii iava aiterei katai vovou purasi ora vaiterei-ia vo orekevu avu vai-ia, oire varirisi. Ra Aite oisi va purareve vaitereipa. ");
INSERT INTO roo_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Iu, vosa vaiterei o vo peva ragai vaisiarore rugoo rovoave, oire uvavivu ora guruave, ra voa voea vuutaaro-ia toua voea tapo.” ");
INSERT INTO roo_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Oire uva vo voki-a vao oa-ia Pita Jisas iare urioroepa. Oa iava voa oiso rera akereva, “Vosa ovirovu purareve araokotoa oaa vuriara ragai-ia, oire ra ovirovu-ia vuuta rera iava vara veraa? Erao vatara (7) vuutaro-ia?” ");
INSERT INTO roo_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Oa iava Jisas rerare oiso puraroepa, “Easi viapau oiso eisi vii tavipaa oiso, Erao vatara vuutaro-ia. Ari oiso vii tavipaavoi, Erao vatara tau vuutaro-ia ora erao vatara vuutaro (77). ");
INSERT INTO roo_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Uva oisi-a eisi osa Sara vao vova vuvuiua oisi toupaiveira oiso, Uva iravu turaro oiso ruipaparoepa ra ou ragaaro torevokoreve kovopa irara varaaro voeao rera voeaaro. ");
INSERT INTO roo_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Oa iava rovoroepa vara torevokopaoro. Uva rera iare iravu sipoiva oirato ira varaaro oiso uvuipaepa katai tau ipu kina (Kl0,000) rutu-ia. ");
INSERT INTO roo_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ari ita, osa viapau monia vai toupaiva rera ruvara-ia kovopato. Oa iava turaro rerare oiso puraroepa, Vearopai vii-ia voriparai ora riakova oara ora kakae vure rutu voeao vii voeaaro ora orekerovu rutu varao vii varaaro oara rutu vatepaa iraipa. Oire ragaipa visii voriaro vatereve irai vao opesi piesa osa ragai ruvara-ia monia ou ragariva. ");
INSERT INTO roo_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Oire uva oisi-a oiso-ia osa iava rera ro kovopato takuro viropa vo rasia vao oiso puraoro turarore, Turaro reito ragaivipa siraou tue rovooro ragaire. Oara rutu vore piepaa varao. ");
INSERT INTO roo_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Oa iava turaro rerapa siraoroepa. Uva vara eaka ragareva varao ou ragaara. ");
INSERT INTO roo_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Uva rera kovopato kosiro viropa iravu iare kovopato ira tapo oisoa kovopareve. Oa iava rerare oiso puraroepa rera okoearo-ia pituoro, Auoro! Ragai vaaro vore pieri erao vovoto kina (K200) rutu. ");
INSERT INTO roo_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Oa iava rera eera ira oisoa tapo kovopareve ira takuro viropa rerare oiso puraoro, Ragaivipa siraou tue rovooro ragaire. Oa vore piepaavere rara viipa. ");
INSERT INTO roo_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Vo osa roari reasiparoepa. Oa iava rera tovoreva tuukepa kepa-ia, oiso ra voa toureve aue vore piepaoro vao oa ou ragareva. ");
INSERT INTO roo_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Oire uva va vao kekeiva kovopa irara. Oa iava rirovira kasipuaepa rutu. Uva vara rutu varao rera vo vovouroaro karekesa avaaepa turaro oaivepa. ");
INSERT INTO roo_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Oa iava turaro rerare keeraroepa ro kovopato rera akesa oiso, E vii-a vao vurito viigoa vao purarivo? Ari ita, riroara rutu eaka ragaavorao vii vore pieoro, uvare ragaire ora sirao pieuerao. ");
INSERT INTO roo_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Oa iava ita viipa siraoraerao. Uva apeisi iava viapau eerapa ita siraouerao vii tapo kovopato? ");
INSERT INTO roo_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Uva va-a vao oa-ia rirovira rutu kasipuroepa ro rera reitoaaro. Oa iava rera vatereva voeao vavaearo iare riro upia vate irara, oiso ra voa toureve vao rutu vore pieoro oa ou ragareva.” ");
INSERT INTO roo_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Oire uva vo reo opesi pieoro Jisas oiso puraroepa, “Vosa viapau oisi oiso araoko irara oavisii iava viapau vuriara verapata, ra oisi raga ita Aite ro vova vuvuiua visii oisi piepareverea oiso-ia.” ");
INSERT INTO roo_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Oire uva Jisas vo reoara rutu opesi piereva. Oa iava Galili-ia kavureva Judia taere iare oiso ragavira ivirovira Jodan. ");
INSERT INTO roo_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Uva riro irara rutu oirara rera sirova utupaaepa. Uva voa voea iava upiara rutu porete piepareva ravotovira. ");
INSERT INTO roo_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Oa iava vo Farisi rera tavatavaesa urioaepa oiso rera akepaoro, “Vosa oirato ora rera vo ruipaaro-ia riakovaaro kavu ovoireve, uva apeisi-a Reo Taisi vai pasi oisi purapai, Oiso vearopai oisi?” ");
INSERT INTO roo_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Oa iava vo reo pukooro Jisas oiso puraroepa voeare, “E viapau vo siposipo vieipataveira oa toupaiveira Tugoropa Vuku-ia vao rovoa iava? Oa-ia Pauto oiratoarei pura rovoreva ora riakova ora oupa pitupitu iava ");
INSERT INTO roo_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","oiso purapaoro, ‘Vosa oirato aitetoarei kavureve ora aakova. Ora vosa riakova tapo rera oiraaro ra kataito purasi ora vaiterei-ia.’ ");
INSERT INTO roo_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Eisi osa iava viapau uvuipasiei ra oiso toupasi, Vaiterei. Viapau. Ari oiso piesivoi kataiua varaua. Eisi osa va vao Pauto otavosia purareva oa-ia viapau uvuiparoi irai ra va sikareve.” ");
INSERT INTO roo_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Oire uva Farisi rerare oiso puraaepa, “Ari eakere Moses igei vatereva vao Reo Taisi oiso, Vo osa oirato reo ovoi rigatooro riakova vatereve, ra oira sigureve?” ");
INSERT INTO roo_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Uva Jisas voeare oiso puraroepa, “Riro kaureo irara visii visiigoa vo rugooroaro paivuruvira toupaiveira. Oa iava Moses visii vaipa va vao karureva, oiso ra riakora sigupata. Osa viapau rutu tuariri rutu vo pitupitu oisoa toupaive. ");
INSERT INTO roo_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ari ita, visii tavipaa oiso, Vosa ro ira riakovaaro kavureve o iria viapau otopa pitupitu purapaeve, eera-a ira ora oupa vo taisiaro-ia tagaure vo osa iriavu riakova oureve ita.” ");
INSERT INTO roo_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Va-a vao oa iava disaipel rerare oiso puraaepa, “O ita, vosa Reo Taisire rugooro irai vao ora oupa taisi oiso, Riro gorua rutu-a vao ora oupa taisi. Eerapa vearopa-a ira viapau ousa vo pitupitu purarevori rovoa-ia.” ");
INSERT INTO roo_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Oa iava Jisas voeare oiso puraroepa, “Ari ita, viapau oiso oirara rutupa-a vo reoa vao-ia ora riakora. Viapau. Ari voeao raga vaaro-a oeapa va vatereva Pauto. ");
INSERT INTO roo_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Aue iava uvare oearovu kavupaiveira aako riakoro oisi raga, ra viapau va iava riakova vai oureve, ora voearo oearoa kakae pura arapa reasipaoro ora itakorepaaveira, ora voearo oearoa vaore rugoopaaveira Pauto vo Saraaro vova vuvuiua. Ari vosa aa ro avuo ro ira vo reo vao sirova utu ruipaparo, oire rera eakata, uvare rera vo reasiaro-a vao riako ou arapa.” ");
INSERT INTO roo_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Va-a vao oa iava garepa kakaero sipoiva rera iare. Oa iava oiso ruipapaaepa ra voea kukuearo-ia ora rera vavaearo tovoreve varirioro, ovusa disaipel voeare korupaaepa. ");
INSERT INTO roo_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Uva Jisas oiso puraroepa, “Kakae vure eakata, ra urioave ragai iare. Opeita voeare korupata. Ari Pauto vaaro Sara voea vaaro oiso osa voeao garepa kakaero.” ");
INSERT INTO roo_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Oire uva voea kukuearo-ia vavaearei tovoreva. Uva va eva purarevoiva, voea arova avaroepa. ");
INSERT INTO roo_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Iravu viovokoto Jisas iare urioroepa oiso purasa, “Tisato. Eake vai puraa vearo pitupitu vai, ra oai iava Tootoo Ovoi oua?” ");
INSERT INTO roo_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Oa iava Jisas oiso rerare puraroepa, “Eakere ragaire eisi purauei? Ari kataitoa raga-a vearotoa rutu Pauto. Vosa rera vaaro Reo Taisi rutu sirova utuu vearovira, oire va iava vo Tootoo ouri.” ");
INSERT INTO roo_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Oa iava oiso Jisas akereva, “Aa vao-a Reo Taisi?” Uva Jisas oiso puraroepa, “Vao-ia Reo Taisi oiso-ia, Opeita oira upopau, opeita otopau, opeita kavirupau, opeita kuuvupau oearovu iava, ");
INSERT INTO roo_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","aiteara vaiopa avivikepau ora aakoara, ora oearovu rutupa siraopau oiso osa ora viipa siraopauveira.” ");
INSERT INTO roo_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Oa iava viovokoto oiso puraroepa, “Otaisiroa rutu varao Reo Taisiro sirova utuparaveira. Uva eake vai ragapa potepaavoi?” ");
INSERT INTO roo_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Oa iava Jisas oiso rera tavireva, “Ari ita, vosa vearo vovou rutu purasa auepau, oire auero rutu-ia vii varaaro vori rovou. Oa iava uvuipau vara voriaro vaterivora voearopa apota irara, ra ragai sirova utuu. Eva oa iava viipa varao pere vuvuiua-ia vearopara.” ");
INSERT INTO roo_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Uva vo reo uvureva rera ro viovokoto. Oa iava rerare sopaua vavataepa. Uva avaroepa, uvare riroara rutu-a orekerovu rera varaaro. ");
INSERT INTO roo_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Oire uva va iava Jisas ora rera voeaarore disaipel oiso puraroepa, “Ari ita, vavagisipapeira rutu voeaopa riro kotokoto guru irara vore ora kiupa arapa Pauto vo Saraaro sovara-ia. ");
INSERT INTO roo_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Uva ita, vavagisipai vao tavaatoa iava vo rito vo osa rirova vai vo kare iava kamel kare iriai voa koatasa auepao. Uva oisi rutu rirovira vavagisi iraopai ropa riro vori guruto vore koatapasa Pauto vo Saraaro-ia.” ");
INSERT INTO roo_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Uva tavetave iraopaiva rera-ia. Oa iava oiso puraaepa, “Uva apeisi-a? Iroutoa vai-a ira uvuipa Tootoo Ovoi ousa?” ");
INSERT INTO roo_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Oa iava Jisas voeava vurapareva tuupavira. Uva oiso puraroepa, “Viapau uvuipa oirato. Ari Pautoa raga uvuiparoi irai oisiri avu pierevora, rera vo Saraaro iare koataro.” ");
INSERT INTO roo_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Uva Pita rerare oiso puraroepa, “Ari ita, igei auero oaio rutu kavuiovora vii sirova utupasa. Uva va iava eake vai ouioverea?” ");
INSERT INTO roo_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Uva Jisas voeare oiso puraroepa ora rera iava, “Oiraopavira visii tavipaavoi. Vo utupaua orekerovu rutu isivaaro iava varao oara airepavira karekepaperea osa varao vo rasitoa-ia torevoko rovoreverea Pauto, ovuutaroa-ia oiso Oirato Oviitoaaro Ro Ropoto kerariava pouro viroverea paupa-ia vao king vo vuutaaro. Eva-a oa-ia visii tapo pautaverea aue katai tau erao (12) paupara, visiigoa ragai sirova utupataveira. Oire katai tau erao (12) aue sara vova Isrel oea taavataverea voea rovirieioro. ");
INSERT INTO roo_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Voeao oirara ora riakora oea ragai vaisiarore rugoopaoro orekerovu rutu kavuivora oiso-ia, araoko irara, ora taataa riako, ora aite irara, ora aako riako, ora kakae vure, ora voea varaaro rasiara, oea vara-ia varao pute pievira rutu oaravu rutu ouiverea taru aue tapo Tootoo Ovoi. ");
INSERT INTO roo_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ari ita, uva voeao oea visii sirova oisoa utupaave, evoea oea visiipa iraaverea vo Pauto vo Saraaro sovara iare. Ovusa voeao oea visiipa oisoa irapaave, oea taru visii sirova utuaverea. ");
INSERT INTO roo_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Iu, Pauto vo Saraaro oa oiso toupaiveira osa iravu oirato ira vaaro-a riroa rasia. Oire vokipaua rutu ovokivu-ia avaroepa oearovu kovopa irara ousa wain kovo-ia kovosa rera vaaro. ");
INSERT INTO roo_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Uva oearovu tapo kovopa irara ora reoparoepa katai vovou raga-ia, oisore ra katai vovou raga puraive. Ra katakataivira katai voki voriaro oupaive katai kina. Oa iava voea arureva voa kovosa wain kovo-ia. ");
INSERT INTO roo_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Oire vo peva vuuta isivaaro-ia avaroepa ita oearovu kekesa vo uva oisoa aivaropaive osa tou ragapaiva voa. ");
INSERT INTO roo_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Oa iava oiso voea tavireva, Visii tapo avata wain kovo-ia kovosa, ra va iava uvuivira visiipa monia vai vateavere. ");
INSERT INTO roo_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Uva avaaepa. Oire ravireo vuuta-ia ora ovaiaro avaroepa ita. Uva oisi raga ita piereva. ");
INSERT INTO roo_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“Oire vokiarovi vo vavae vuuta-ia avaoro oearovu ita kekereva osa touiva. Uva oiso puraroepa voeare, Eakepa tou ragapatavoi vo-ia ro rutu-ia ravireo? ");
INSERT INTO roo_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Uva rerare oiso puraaepa, Ari aue iava uvare viapau irai igei vatepare kovoa vai. Oa iava oiso voeare puraroepa, Oire visii tapo avata, ra kovota wain kovo-ia. ");
INSERT INTO roo_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Oire uva vokiepa voeare. Oa iava rera ro ira vo kovoaro-a wain kovo ira tokipato tavireva oiso, Kovopa irarare keerau voea vorisa. Uva voeao iava rovouvere utupa irara voeao-ia rekasipasa irapa kovo irara. ");
INSERT INTO roo_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Oire uva voeao oea vo vavae vuuta-ia kovo rovoaepa oea karea viropa katai kina raga ousa katakataivira. ");
INSERT INTO roo_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Uva voeao oea irapavira rutu kovo rovoiva oea karea viropa ita. Uva oiso keapaaepa, Vigei riroa vai pute pievira oupai, osa viapau. Ari oisi raga ita katai kina katakataivira ouaepa voea rutu. ");
INSERT INTO roo_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Oire uva oisi-a oiso osa ouaiva, vara agarupaiva rerare reopaoro ro ira vo kovoaro-a. ");
INSERT INTO roo_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Oiso puraaepa, Evoeare oea utupavira kovoivo oea katai vuutavi raga-ia kovoivoi. Uva voea vo voriaro vaearivo rutu igei vaarova uvuipai. Ari ita, igei vao riro vavata kovoro rutu pura rovopaiovo rirotoa-ia ravireo. ");
INSERT INTO roo_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Oa iava oiso puraroepa iravure oirato voea iava rera, Vatetoa oaa. Katai reo puravevo, oisore ra katai kina raga oupata visii rutu katakataivira. Uva viapau visii vuri pieavoi. ");
INSERT INTO roo_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Vii vaaro voria ouri, ra vava kareu, uvare ragai vo ruipaaro-a, oa iava oisi raga eisi voeao voriavoi utupa irara rutu oiso osa vii vo voriaro. ");
INSERT INTO roo_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Apeisi ragavira? Ra vosa orekevu avu vai purasa auepara vao-ia monia ragai vaaro, uva viapau oisi uvuiparai, eke? Vearo pitupitu puraavoi, uva va-ia agarupari.” ");
INSERT INTO roo_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Oire uva vo reo opesi pieoro voea iavirava oiso puraroepa, “Ari ita, uva voeao oea visii sirova oisoa utupaave, evoea oea visiipa iraaverea vo Pauto vo Saraaro sovara iare. Ovusa voeao oea visiipa oisoa irapaave, oea taru visii sirova utuaverea.” ");
INSERT INTO roo_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jisas Jerusalem iare ipasa aueparoepa. Oa iava disaipel ragare keeraroepa, uvare voea raga tapo ora reo ruipaparoepa vo vokapaoro raivaaro. Uva oiso puraroepa voeare, ");
INSERT INTO roo_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Uvuta! Ipaviei Jerusalem iare uva Oirato Oviitoaaro Ro Ropoto tovopai reipa irara vavaearo-ia pris irara ora voeao tarai irara Reo Taisi-ia. Oea rera tovopai kortua-ia. Ora reo goru puraivere rera kopii piesa. ");
INSERT INTO roo_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ra rera vateive oearovupa ratau tou irara iava. Ra rera tovipaive rera ragipaoro. Oire rera tapaive evao parikou-ia. Uva taru vo pevapa vokia torerovere kopiia iava tootooro vorevira.” Eisi osa voea tavireva ora rera iava. ");
INSERT INTO roo_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Vo vokio-ia aakova vaitereo oviitoarei sipooro Sebedi oviitoareiaro, rekueva rasiuaaro Jisas areoro orekerovure. ");
INSERT INTO roo_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Oa iava Jisas oira akereva oiso, “Eake vaipa ruipapauei?” Uva oiso Jisas tavieva, “Oiso ruipaparai ra reo ovoi purari vaitereopa oviitoarei oaa. Ra oiso pausiverea utupaua, iravu vo pauroverea oirapapa varata, ari iravu vo koike varata vo osa turarou.” ");
INSERT INTO roo_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Uva Jisas oiso puraroepa vo araorei iare ovoovovira, “Viapau taraipasiei vao-ia oare akepasi. E uvuipasiei ra o-ia kap ukaiosi iria-ia ukaioravere, iria agasioi aue iava tavaka?” Oa iava oiso rera tavisiva, “Iu, uvuipaveiei.” ");
INSERT INTO roo_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Oa iava Jisas vaitereire oiso puraroepa, “Oiraopavira rutu. O-ia kap iria-ia ukaiosivere ragai oiraaro. Uva irouto-a ira vo oirapapa varata-ia ora koike varata ragai sirova paurovere? Uva vo reoa vao viapau oiso ragai vo reoaro-a. Viapau. Ari varao-ia paupara oara ravaarevora Aite oearovupa oirara voeao oea reesireva.” ");
INSERT INTO roo_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Uva vo reoa vao uvuiva voea katai tau (10) disaipel. Oa iava vo araoreire aveavepaaepa. ");
INSERT INTO roo_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Uva va-a vao oa iava Jisas voeare keeraroepa ora rera iare. Uva oiso puraroepa voeare, “Taraipatai oearovu-ia reipa irara oea ratau tou irarapa turaropaai, oea-ia kae pievira oearovupa toupaiveira uvare pute pievira goruava toupaiveira. Oire ita, oearovu reipa irara rutu voea-ia pute pievira rutu toupaive. ");
INSERT INTO roo_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Uva vo pitupitu-a vao-ia oa viapau uvuipai ra visii vuutaaro-ia toupaive. Viapau. Ari ro ira oisi ora rei pieparo vo visii vuutaaro-ia ira oiso toupareverea kovopato visii tauvapaoro. ");
INSERT INTO roo_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ari vosa ro ira visiipa rei ruipaparo ira oiso toureverea, Visii reraaro kovopato. ");
INSERT INTO roo_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Oiso rutu osa ragai ragoa urioraera vore. Uva viapau oiso ruipaparaveira ra oearoi ragai kovopaive oirara vai. Ragoa urioraepa kovoa purasa voea tauvaoro. Ora ragai vaaro tapo tootooa vatesa va iava vaseoro oirara rutupa voea oriruoro.” ");
INSERT INTO roo_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Oire uva Jeriko iava avaroepa. Oa iava oirara rutu Jisas sirova utuaepa. ");
INSERT INTO roo_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Uva voa vaiterei voositoarei raiva vatuaro-ia pausiepa, vo osa rera iava uvusiva Jisas osa vokapareva. Uva oiso puraoro rerare keerapasiepa, “Turaro. Vii-a Devit Aaotoaaro. Vegeivipa siraou.” ");
INSERT INTO roo_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Oa iava riro irara vaitereire korukorupaaepa oiso purapaoro, “Avaitereo, ora tape piesi!” Osa gausiva ita rirovira rutu. Uva oiso purasiepa ita, “Vii-a Devit Aaotoaaro. Vegeivipa siraou!” ");
INSERT INTO roo_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Oa iava Jisas voavi toupaoro vaiterei aatooro oiso puraroepa, “Eake vai-a oapa ruipapasiei ra oai puraa veipa?” ");
INSERT INTO roo_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Uva oiso rera tavisiva, “Turaro. Vegei oiso ruipapaveiei ra vegei osireiaro karuri.” ");
INSERT INTO roo_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Oa iava Jisas vaitereipa siraoroepa. Uva vaiterei osireiaro-ia vavaea tovoreva. Uva va iava vorevira vurasiva. Osa iava rera sirova utusiepa. ");
INSERT INTO roo_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Oire Jerusalem iare avapaoro Betfasi urui iare tutuu pieivoiva, Oliv Kovo Pukui varataaro-ia aitereivu disaipeltoarei ira piereva vaiterei aruoro oiso, ");
INSERT INTO roo_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Vo urui-ia kareu virosa irasi. Ra voa donki kekesi ovusa variaua riara-ia toupaeve oviitoa tapo oira reraaro. Uva vo avaorei rutu karusivere ra vaitereiva voresi ragai iare. ");
INSERT INTO roo_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Oire ra vosa irai vei akepareve oiso, Eakere evaiterei avaorei oupasi? Ra oiso tavisi, Iria-ia Turaro vo kovoaro toupaivoi. Oai iare vaitereo oupavevoi. Ra vaiterei iava vasereve ikauvira veipa.” ");
INSERT INTO roo_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Vo reo oirao piesa vao karekei oreoa purareva profetato oiso, ");
INSERT INTO roo_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","‘Vii Saion vata taviuverea oiso, Eera visii reraaro King ira urioparoi visii iare gavaure vovouto. Ira donki kakae ivara-ia paupaoro urioparo.’ ");
INSERT INTO roo_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Oire uva vaiterei vaitereo disaipeltoarei oisi vaiterei piesiva donki avaorei vaitereiva voreoro oiso osa Jisas vaiterei tavireva. ");
INSERT INTO roo_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Oa iava varoara tovosiva vaiterei ivara-ia oara ivara-ia popotapavira pauparoepa Jisas. ");
INSERT INTO roo_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Uva riro irara oirara ora riakora ora voea varaaro varoara parakapaoro vara tovopaiva raivaaro. Osa oearovu evaoara tosipaoro vara tovopaiva voa raga raivaaro. ");
INSERT INTO roo_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Uva voea oirara ora riakora pireripaoro rerava irapaaepa, osa oearovu utupaaepa kaku piepaoro oiso purapaaepa, “Hosana Devit aaotoaaro-ia Pauto rera viraakoreve, ro-ia ira uriopa Turaro vaisiaro sovara-ia! Hosana vore viara-ia Pauto!” ");
INSERT INTO roo_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Oire uva Jisas Jerusalem urui-ia koataroepa. Oa iava oirara rutu ora riakora voeao vo urui-ia tou irara oea rera kekeoro paripariiva rutu oiso purapaoro, “Avoeao! Iroutoa rutu-a ro-ia?” ");
INSERT INTO roo_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Oa iava oirara ora riakora vokapaoro oiso puraaepa rerare, “Profetato ro-ia Jisas, Nasaret iava rera vo Galili taere sovara-ia.” ");
INSERT INTO roo_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Uva Jisas Rovopa Kepa-ia aue Tempel koataroepa. Oa iava voava oirara rutu sigureva vo osa voa ora voripaaepa vo kepa sovara-ia. Uva voa tebolara petopetoreva oara-ia orekerovu-ia moniara ora tuutuukopaaepa, ora varao paupara oara-ia paupaoro ora tuutuukopaaepa kurue kare-ia. ");
INSERT INTO roo_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Uva oiso voeare puraroepa, “Tugoropa Vuku oiso purapapeira, ‘Ragai vo kepaaro-a vao-ia oa vaisipaiveira oiso, Variripa kepa.’ Uva oiso rutu va piepatavoi, vataupa tapi kavirupa irara voaro.” ");
INSERT INTO roo_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Uva voa toureva Tempel sovara-ia osa oearovuva uriopaaepa voosi irara ora kotupipa irara rera iare voa. Oa iava voea ravotovira porete pie ovoipareva. ");
INSERT INTO roo_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Uva reipa irara pris ora oearovu tarai irara Reo Taisi-ia vao ravotoa kekeiva. Oa iava kakae vure uvuiva osa kaku piepaiva Tempel sovara-ia oiso purapaoro, “Hosana Devit Aaotoaaro-ia!” Osa-a eisi osa iava vuri vovou iraopaaepa rutu rirovira kasipupaoro. ");
INSERT INTO roo_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Uva oiso puraaepa rerare, “E pasi vo reo uvurivoi oa purai viire?” Oa iava Jisas voeare oiso puraroepa, “Iu. Oa uvuavoi. Esa viapau vo reo vieipataveira oa oiso purapai, ‘Vii garepa kakaero oiso pieriva ora voeao sikeo irara roroara-ia tou irara ra vii-ia vuurapa vaisi purapaive’?” ");
INSERT INTO roo_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Oire uva voea kavuoro kosiro viropa uruia iare vao Betani voa tousa vo rupa-ia vao. ");
INSERT INTO roo_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Oire uva vokipaua rutu Jisas voreroepa riro urui iare. Uva voa rirovira rutu ogoeroepa. ");
INSERT INTO roo_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Oa iava oevavu kekereva fik ova raivaaro. Uva vo eva iare avaroepa. Uva viapau oiso kuea vai kekereva voa. Ari guruvara raga toupaiva voa. Uva vo evare oiso puraroepa, “Viapau oiso ra kuepauverea ita.” Oa iava ikauvira erako ovoiepa. ");
INSERT INTO roo_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Uva disaipel va vao kekeiva. Oa iava tavetave iraopaiva oiso purapaoro, “Apeisi iava fik ova ikauvira erako ovoiei?” ");
INSERT INTO roo_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Uva Jisas voea vaaro pukoreva oiso, “Ari ita, oiraopavira visii tavipaa oiso, Vosa oirao pie vovou rutu purapata vakuvaku asavira, oire ra oiso piepata osa vo evaore fik ova pieavoi oa iava erakoei. Ari ita, ra viapau oiso va raga vao purapata. Ari uvuipatai ra vaore pukuia tapo oiso purata, Toreu ra ora vikiu vore avakava-ia. Oire ra oisi pieive. ");
INSERT INTO roo_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Uva vo osa raripaoro rutu variripata orekerovupa ruipapaoro, oa iava uvuipatai ra vara oupata.” ");
INSERT INTO roo_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Uva Tugoropa Kepa-ia aue Tempel koataroepa Jisas. Oa iava oirara rutu siposiporeva voa. Uva reipa irara pris ora oearovu Isrel iava oearoa rutu urioaepa rera akesa, “Eake reesia vao vii vaaro oa iava vo kovo purapari? Irou vii vateva vo reesi?” ");
INSERT INTO roo_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Oa iava Jisas voea aatooro oiso puraroepa, “Ragai tapo ita visii akepaavoi oavure. Vosa ragai gisipoaro pukota, oire ra ragai tapo ita visii aatoa visii tavioro ragai vo reesiaro iava. ");
INSERT INTO roo_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Oire vo baptaiso Jon oa puraparevora, ovuva vo karopoa oa urioera Pauto ruvara-ia, eke vova oiratoa raga? Ra ragai tavita!” Uva ora rugorugoo piepaaepa oiso, Apeisi avu purapaviei? Vosa oiso puravio, Vova Pauto, ra oiso purarovere, Uva apeisi viapau va oirao piepata? ");
INSERT INTO roo_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ari vosa oiso puravio, Oirato vaaro, uva riro irarapa uriripaviei, uvare oirara rutu oiso rugorugoopaai oiso, Jon-a profetato rutu. ");
INSERT INTO roo_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Oa iava oiso purapaaepa, “Viapau taraipaiei.” Uva Jisas voea tavireva, “Ragai tapo ita viapau visii tavia vo reesi iava oa iava vo kovo purapaavora. ");
INSERT INTO roo_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Apeisi rugoopatai? Iravu oirato ira oisoa oviitoareiaro toupasi. Oa iava avaiotoa iare avaroepa oiso rera arusa, Oviitoa oaa avau wain kovo-ia kovosa vo vokio. ");
INSERT INTO roo_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Uva rera vo reoaro pukooro oiso puraroepa avaioto, Reasiparai. Oire va isivaaro iava vovouisi poreoro ita avaroepa kovosa. ");
INSERT INTO roo_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Oire uva kikootoa iare avaroepa aiteto oiso raga ita rera tavisa. Oa iava oiso puraroepa, Iu aite. Avaparai! Uva viapau oiso avaroepa ");
INSERT INTO roo_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Oire uva vaiterei-a vaitereo oviitoarei, uva aa ro aiteto vo reoaro sirova uturoepa?” Oa iava oiso puraaepa, “Ari avaioto.” Uva Jisas voeare oiso puraroepa, “Oiraopavira rutu visii tavi iraopaa oiso, Voeao kavirupa irara takis oupa irara ora vairo otopa riako oea Pauto vo Saraaro-ia koata rovoaverea iraoro visiipa. ");
INSERT INTO roo_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Eake iava? Uvare Jon torevoko pitupitu kareke rovosa urio rovoroepa visiipa. Uva viapau rera oirao pietava ovusa voeao takis oupa irara ora otopa riako rera oirao pieiva. Ari ita, uva va keketava oa iava viapau oiso vovouisiro oavisii poretava rera oirao pieoro. ");
INSERT INTO roo_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Reo ruu uvuta vao oa oiso purapai, Iravu wain kovo paureva. Uva vo kovo rirore kasura purareva. Oa iava voa rikui tekareva auere gerepara pigipato masin. Uva voa uutupa kepa paureva vo kovo ruvara-ia. Oa iava oiso oeavu kovopa irara tavireva, Vo kovo toki ragapatavere ragai vo kovoaro monia purapaoro ragai vaaro. Voea tavirevoiva, voea tovo pieoro vo kovo-ia otaerevu iare avaroepa. ");
INSERT INTO roo_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Uva oivavu sovara-ia oeavu arureva kovopa irara rera voeaaro vo kovo iare, oiso ra vo kovo kuearo iava oarai ouive rerapa voea ruvara-ia voeao oea oisoa vo kovo tokipaive. ");
INSERT INTO roo_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Oire uva voeao oea arureva rera kovopa iraraaro oea ouiva voeao wain kovo tokipa irara. Oa iava voea iava iravu ragipaiva, ari iravu kopii pie ovoiiva, ari iravu vurokoiva aue-ia aveke. ");
INSERT INTO roo_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Uva rera ro ira vo kovoaro-a oeavu ita arureva kovopa irara rera voeaaro riro iraravi rutu. Oa iava oisi raga ita voea pieiva. ");
INSERT INTO roo_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Oire uva ovoiokuvira rutu rera oviitoaaro rutu siporeva voea iare oiso rugoopaoro, Ira vai-ia taru gisipoaro uvuivere ragai rutu oviitoaaro. ");
INSERT INTO roo_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Oa iava oiso ora reoaepa voeao wain kovo tokipa irara, Rera-a ro-ia turaro oviitoaaro rutu. Irare ra rera upoera, rera varaaro rutu oupe. Ra oisi iavirava kovoa tokipe ora vigeipa. ");
INSERT INTO roo_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Uva va iava rera-ia pituiva vo kovo sovara-ia. Oire voava rerava kosia viropa vo kovo vatuaro-ia rera kopii piesa. ");
INSERT INTO roo_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Uva apeisi vai rugorugoopatai vo siposipo uvupaoro? E utupavira urioroverea ro ira vo kovoaro-a? Ra eake vai-a vao oa purasa uriorovere voea-ia voeao vo kovo tokipa irara, raa?” ");
INSERT INTO roo_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Oa iava Jisas-re oiso puraaepa, “Ari voea rutu taru uporeverea voeao vuri irara. Ra oeavu raga ita tovo piereve vo kovo-ia. Uva vo aio oupa vuutaaro-ia vo kovo iava oupaoro rerapa vatepaaverea torevokovira.” ");
INSERT INTO roo_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Uva voeare oiso puraroepa Jisas, “Esa pasi vo reo vaio vieipataveira Tugoropa Vuku-ia oa oiso purapapeira, ‘O-ia aveke iria veraiva voeao kepa paupa irara oira-ia kepa paupa arapa, eira rutu ita-a avekeva rovopava rutu kukuuvu tuuta oa eisi piereva Pauto Turaro. Uva evo kovo purareva oa vigei osireiaro-ia ravotovira toupaiveira.’ ");
INSERT INTO roo_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ari ita, Pauto rera vo Saraaro-ia visii Jiu rui piereverea oeavu raga vatesa voeao oea vearo kue purapaiveira va-ia. ");
INSERT INTO roo_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ari vosa ro ira kovero oira ivara-ia o-ia aveke ra ora pegepegeoro ita. Ari vosa oira o aveke koveo irai ivara-ia, oire ra garepa visivi rutu rera taritaoro koveo.” ");
INSERT INTO roo_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Oire uva voea voeao pris ora Farisi va vao reo ruu uvuiva oa purareva Jisas. Oa iava rera oriorisioro oiso puraaepa, “Asi vigeire oiso puraparoi.” ");
INSERT INTO roo_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Uva va-a vao oa iava oiso vovou ragapaaepa ra rera-ia pituive. Uva rirovira rutu uriripaaepa ita oirara rutupa voeao oea oisoa oiso purapaave rerare, Jisas profetato. ");
INSERT INTO roo_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Oire uva oavu ita purareva reo ruu voeare oa-ia oiso puraroepa, ");
INSERT INTO roo_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Vao Pauto vo Saraaro oa oiso rutu toupai osa iravu reito king, ro ira oiso vo pitupitu purareva vo osa oviitoaaro riako ousa aueparo rei voki-ia. Oire riroa aioa purareva rera ro reito, ");
INSERT INTO roo_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","uvare oearovu oisoa reesi rovopareve oiso, Voeaore kaokaoravere rara vo aio iare. Oire pura piro vo voki vao oa-ia vo aio purareve. Oa iava rera voeaaro arureve, Voeaore keerasa avata. Ari vo osa reasipaave vo aio iare urio arapa. ");
INSERT INTO roo_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Oa iava oisoa oeavu arupareva ita rera voeaaro kovopa irara oiso puraoro, Visii avata ita voeare keerasa ita oeare keera ragaraerao. Ra oiso voea tavita, Uvuta. Ragai vaaro vatatopoei aioa, varao-ia oa puraavo oiso-ia bulmakau kare ora voeao taoropa kare. Ragai vo karearo oea upoavo. Oa iava vara rutu-ia vatatopoavo. Ari uriota va iare vao riako oupa aio. ");
INSERT INTO roo_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Uva eisi-a osa kaokaosa avaaepa voea voeao kovopa irara voeare, osa reasipaaepa ita vo kaokao uvu arapa. Uva voava ora sikasikaaepa oiso oearovu ora voea vo kovoroaro iare vikuiva, osa oearovu ora voea vo kovoroaro purapasa sara kovoro avaaepa. ");
INSERT INTO roo_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Osa oeavu kovopa irara rauiva reito voeaaro voea vuri piesa voea kopii pieoro. ");
INSERT INTO roo_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Uva oisi-a oiso osa iava rera ro reito rirovira rutu kasipuoro rera voeaaro arureva viurupa irara. Oa iava avaaepa voea opesi piesa voeao oea kovopa irara upoiva. Oa iava voea vo uruiaro-ia tapo piuaepa. ");
INSERT INTO roo_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Uva va-a vao oa iava reito rera voeaaro kovopa irara tavipareva oiso, Aioa vao oa vatatopoe tuariri. Oa iare voeare keera ragarae oea reesi rovoavora. Uva viapau uvuipaai ra urioave, uvare viapau uvuivira toupai voea vo rugorugooroaro. ");
INSERT INTO roo_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Oa iava visii tavipaa oiso, Vusita riro raiva iare voa siituepasa oearoire oirara vai ora riakora vai. Ra oeaire keerapaoro oiso purapata, Uriota riako oupa aio iare. ");
INSERT INTO roo_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Uva eisi-a osa puraroepa, oa iava avaaepa kovopa irara riro raiva iare oirara rutu gurusa ora riakora voearo tapo vuri irara ora voeao vearo irara. Oa iava voea rutu pausa urioaepa kavatao kepa-ia. Uva agasiepa voea iava. ");
INSERT INTO roo_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Oire uva voa paupaaepa oirara rutu vo aio-ia osa reito koataroepa voea kekesa. Oa iava voea sovara-ia iravu kekereva ira viapau vearovira oritooro urioroepa vo vokia eva riako oupa aio-ia. ");
INSERT INTO roo_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Oa iava rerare oiso puraroepa reito, Vatetoa oaa. Apeisi iava viapau vearotoa vai-ia kuvutoa vai kuvuoro uriouei vo aio iare? Osa viapau rera aatopareva. ");
INSERT INTO roo_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Oa iava rera voeaaro tavireva oiso, Rera vavaearo tuuketa ora kokotoarei tapo. Ra oisi rera pieoro rera kosi pieta vova eisire rupa-ia. Ra voa rupavira toupaoro ora reuriaro kuripareve ora rerapa siraopaoro. ");
INSERT INTO roo_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Uva oisi-a eisi osa Pauto kaokaoparoveira riro irarare. Ari katakataipa irara raga ora rerapa reesipareve koatapasa rera vo Saraaro-ia.” ");
INSERT INTO roo_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Oire uva Farisi oiso vo reo purasa avaaepa, “Eake reo vai-ia rera tavatavaepe, ra oa iava rera piro piepe ro Jisas?” ");
INSERT INTO roo_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Osa iava Herot aruiva disaipel tapo voeao Farisi voeaaro. Oa iava Jisas iare avaaepa oiso purasa, “Tisato, igei vii-ia taraipaiei oiso, Vii-a oiraopa reotoa rutu. Uva oiraopa vovou rutu vii vaaro oa iava oirara rutupa siposipopariveira Pauto vo pitupituaro iava. Uva viapau oiso oearovure rugoopauveira oiso, Teapi ragaire vuri rugoo puraive. Viapau. Ari katai reoa raga purapariveira oirara rutupa. ");
INSERT INTO roo_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Uva oisi-a eisi osa iava igei tavipari, Apeisi rugoopauei? E torevokopai ra rerapa Sisa takisvio moni vateoro ro gavman vigei reitoaaro, eke viapau?” ");
INSERT INTO roo_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Uva Jisas voea vo reoaro oriorisioro oiso puraroepa, “Visii vao riro ratarataa vovou irara. E ragai tavatavaepata? ");
INSERT INTO roo_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ragai roro pie rovota oai iava takispa moni vai.” Oa iava oavuva urioaepa rera vatesa Jisas. ");
INSERT INTO roo_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Uva oiso voea akereva, “Irouto puaaro-a ro-ia? Ora irouto vaisiaro-a?” ");
INSERT INTO roo_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Oa iava oiso puraaepa, “Ari Sisa.” Uva oiso puraroepa, “Vosa Sisa vaaro, oire rera vateta Sisa. Ari vosa Pauto vaaro, oire Pautoa-pa va vateta.” ");
INSERT INTO roo_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Uva vo reo-a vao oa uvuoro rirovira rutu va-ia rugorugoo iraoaepa. Oa iava rera arova avaaepa. ");
INSERT INTO roo_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Oire uva vo voki raga vao oa-ia reipa irara Sadyusi-pa irara vova lotua Jisas akesa urioaepa. Evoea oea oisoa kopiipa irarare oiso purapaave, “Viapau oiso torepaaverea vorevira kopii tapi iava.” ");
INSERT INTO roo_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Uva oiso rerare puraaepa, “Tisato, Moses oiso puraroepa, Vosa iravu kakae pura asavira kopiiro riakovapa, oire ra araokoto ita oira oureve. Oire rerapa ro kopiito oira-ia kakaeto purareve araokoto. ");
INSERT INTO roo_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Oire vo tuariri erao vatara (7) rutu oaraovu oea oiso igei ruvara-ia toupaive. Oea iava iravu avaioto iriavu arova riakova kopiiroepa kakae pura asavira. Oa iava kikooto ita aia oira oureva. ");
INSERT INTO roo_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Uva eraopato ora vo pevapato oisi raga ita piesiva oira arova. Oa iava vo arao rutu vo rekasiaepa erao vatara rutu-ia oirapa kakae asavira raga kopiipaoro. ");
INSERT INTO roo_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Oire uva vo arao rutu opesiaepa kopiioro. Oa iava vo arao isivaaro iava kopiiopa ita oira. ");
INSERT INTO roo_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Uva vo vokio-ia oa-ia oirara rutu toreaverea vova kopiia-ia. Uva irouto vo arao iava oira oureverea? Aue iava uvare vo arao rutu oisoa oira oupaive oira arova kopiipasa.” ");
INSERT INTO roo_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Oa iava Jisas oiso voea vo reoaro pukooro oiso puraroepa, “Viapau oiso taraipatai Tugoropa Vuku vo rigatoaro-ia. Ora viapau tapo taraipatai Pauto vo goruaro-ia tapo. Eisi osa kokoropavira ora reopatai. ");
INSERT INTO roo_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Oire vo vokio oa-ia oirara rutu kopiia iava vorevira toreaverea oa-ia viapau oiso voreria vaiei riako ou vai. Ari oiso raga toupasa vorevira toreaverea osa purapurapa irara ensel voeao vuvuiua. ");
INSERT INTO roo_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","“Uva vo reo-a vao oa iava visii akepaa voea iava voeao kopii irara oea torepaaverea. Asi viapau pasi vo reo vieipataveira oreoa iava Pauto visii tavireva? Oa-ia oiso puraroepa, ");
INSERT INTO roo_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ragai-a Pauto oaive Ebraham, ora Aisak, ora Jekop voeao oea urauraaro tootoovira toupaiverea.’ Ari ita, uva va-a vao vituaro iava oiso purapai, Viapau oiso kopii irara reraaro-a Pauto. Ari Pauto-a voea reraaro oea tootoopai.” ");
INSERT INTO roo_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Oire uva voea voeao oea vo reo uvuoro vao-ia ora sitaaepa va-ia tavetavepaoro. ");
INSERT INTO roo_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Uva voa-a vo uva Sadyusi-pa irara tape piereva Jisas voea vo reoaro tuuoro. Oa iava Farisi va iava uvuoro urioaepa. Oire voava voearei rutu ora guruaepa rera ruvara-ia. ");
INSERT INTO roo_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Uva voearei rutu iava iravu riro reo kerisito Reo Taisi-ia toupareva. Ira oiso vovouparoepa ra Jisas tavatavaereve rera akeoro. ");
INSERT INTO roo_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Uva oiso puraroepa, “Tisato. Aa vao-a reo goru oa vara rutu-ia reo goruro pute iraopai?” ");
INSERT INTO roo_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Oa iava Jisas vo akeo aatooro oiso puraroepa, “Reito Pauto vii reraaro irapa sopaua oara rutu vateri, ora rugorugooara rutu, ora taraiara rutu varao vii varaaro rera ragapa vateri. ");
INSERT INTO roo_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Va vao-ia reo goru oa reipai rutu ora rovopa rutu. ");
INSERT INTO roo_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Uva eraopa oa vava areiivira raga oiso purapai, Ora vii sopaaro rutu vatepari voeaopa oea vii ruvara-iavi toupaiveira, oiso rutu osa ora viipa siraopauveira. ");
INSERT INTO roo_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Vo taisireo Reo Taisi rutu vituaro varao Moses vase ora profeta irara varaaro.” ");
INSERT INTO roo_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Vo uvuru raga-ia toupaiva Farisi osa Jisas oiso voea akereva, ");
INSERT INTO roo_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Apeisi rugorugoopatai Krais-ia. Irou aaotoaaro?” Oa iava oiso rera taviiva, “Ari Devit aaotoaaro.” ");
INSERT INTO roo_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Uva oiso puraroepa voeare, “Uva apeisi iava Devit vatereva Tugoropato Uraurato vo rugoo oa iava Krais-ia Turaro vaisi tovoreva oiso puraoro, ");
INSERT INTO roo_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Turaro Pauto ragai reraarore Turaro oiso puraroepa, Vo paupauverea oirapapa varata-ia vo tugurasa ovokia-ia voeao vii voeaaro keripa irara tovoaverea vii kokotoaro reroaro.’ ");
INSERT INTO roo_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ari ita, Devit raga turarovira Krais vaisireva. Uva apeisi ragavira? Uvare Devit aaotoaaro-a ro Krais ira Devit sirova kavauroepa.” ");
INSERT INTO roo_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Oa iava viapau oiso irai uvuiparoepa vo reo pukosa Jisas vaaro. Uva voa-a evoa uva rovoaepa uriripaoro rera ake arapa vorevira. ");
INSERT INTO roo_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Utupavira Jisas oirara rutu tavireva ora voeao rera voeaaro disaipel. ");
INSERT INTO roo_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Uva oiso puraroepa, “Voeao tisa irara tarai irara Reo Taisi-ia voearei ora Farisi oearea reesiiva oeavu oavu-ia paupa vo uva oisoa Moses varaaro Reo Taisi aviavi piepaive. ");
INSERT INTO roo_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Uva oisi-a eisi osa vao oiraopa reo rutu va vatepaiveira visiipa. Uva uvuipatai ra va uvupata, ra va sirova utupata. Ari vao voea vo pitupituaro, viapau oiso vao Reo Taisi sirova utupaaveira oa-ia voeao oirara siposipopaiveira. Eva-a oa vituaro iava viapau rutu oiso ra voea vo pitupituroaro sirova utupata. ");
INSERT INTO roo_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ora riro vavatapa ruuro tuukepaiveira oirara vutuaaro-ia vara tovopasa, vo osa ora voea raga viapau varavi-ia pitupaive sipareoaravi raga iava voea tauvapaoro oea vara kaepaive. ");
INSERT INTO roo_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Uva vara rutu purapaiveira oiso ra oirara vara kekepaive. Iu. Riropa pakoro oara oisoa purapaive Tugoropa Reo-ia pakopasa vara-ia. Oire varava riro kaekaepavira variripaave. Ora aue tapo papaapa varoro oara-ia oisoa oritopaave, oara oisoa kokotoara rutu iare vara piepaive. Oire ra vara vituaro-ia riro paraka turua purapaive va iava ora reesipasa, oiso ra oirara rutu vara iava oiso auepaave vara kekepaoro, O, riro tarai irara voeao Tugoropa Reo-ia. ");
INSERT INTO roo_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ora oisoa rovopa tavukipa ruipapaave paupa vo aiopa vokia. Ora vao tapo paupa vo Reo Uvupa Kepa-ia Sinagog oa-ia oisoa paupaave reipa irara. ");
INSERT INTO roo_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ora oiso tapo ruipapaave ra oirara rutu voeapa ora avivikepaoro oiso voeare purapaave, Vearo voki, vo uruiara rutu sovara-ia. Ora oiso tapo purapaave, ra oiso voea vaisipaive, Tisa irara. ");
INSERT INTO roo_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Uva oiso ruipaparai ra viapau oisi visii vaisipaive oiso, Tisa irara. Viapau. Ari kataitoa raga, visii reraaro Tisato. Ari visii rutu-a katai arao rutu. ");
INSERT INTO roo_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Uva vo rasio-ia viapau uvuipatai ra irai rei piepata irai vaisipaoro oiso, Vigei aitearo. Viapau. Ari kataitoa raga Aite oavisii ira oiso toupare vuvuiua-ia. ");
INSERT INTO roo_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ora viapau tapo ra oiso visii vaisipaive, Turaro. Viapau. Ari kataitoa raga visii reraaro, Ragai ita Krais. ");
INSERT INTO roo_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ari vosa ro ira visiipa reiparo, ira-a eera uvui iraopa ra ora vaisiro oiso, Visii reraaro kovopato. ");
INSERT INTO roo_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ari ro ira ora vaisiaro raga kae piepareve, ira-a eera vaisiaro akaipa pierevere Pauto. Ovusa ro ira ora rera vaisiaro vara piepareve, ira vaisiaro kae pierevere utupaua Pauto. ");
INSERT INTO roo_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Oire visii vao tarai irara Reo Taisi-ia ora visii Farisi visiigoa vatatopo iraopata riro kuuvu irara rutu visii. Visiigoa rataoa tupapataveira vao Pauto vo Saraaro iava vo oirara rutu osireiaro-ia. Ora visii ruture tupapataveira vo osa oearovu koata ruipa ragapaave. Oire ra visii raga vo vovouroaro-ia paipaipaive oearovu rara visii raga voeare tupapata. ");
INSERT INTO roo_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Visii vao tarai irara Reo Taisi-ia ora visii Farisi visiigoa vatatopo iraopata riro kuuvu irara rutu visii. Ora riro raroe riakore vo keparoaro ou raga irara. Visiigoa vao oirara osireiaro-ia riro kaekaepa variriro purapataveira vuriara oavisii vataupaoro. Oire uva va-a eva oa vituaro iava vuria rutu oupataverea riroa voria vuria. ");
INSERT INTO roo_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Visii vao tarai irara Reo Taisi-ia ora visii Farisi visiigoa vatatopo iraopata, riro kuuvu irara rutu visii. Visiigoa avakava-ia viripataveira ora voraro vo rasio rutu-ia kataitoa ragare taraapaoro disaipelto, oiso ra visiipa disaipelparo. Oire ra oisi rera pietavora, rera ava pieta Vuri Tapi iare. Ra visii raga vo vovouroaro sirova uturo ita oiso osa vara sirova utupataveira visii. Uva va iava eva visii vo voriroaro-ia vuriara rera vo voriaro vuria rutu pute pievira karekepe. ");
INSERT INTO roo_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Visii vao-ia visiigoa oearovu tuvetuvepataveira raivara-ia oiraravoosipaoro. Visiigoa vatatopo iraopata. Visiigoa ora visii vo siposiporoaro vatepataveira oearovupa. Oire ra oiso voeare purapata, Vosa irouto Tempel vaisi ragapaoro reo ovoi purareve, ra oiso puraparo, Oiraopavira rutu, oa oiso toupaivoi kiuvu reo raga eva. Ari vosa irouto ro ira gol vaisioro reo ovoi purareve vao oa Tempel sovara-ia toupaiveira, oire ra viapau uvuipa ora rera raga vo reoaro gasireve. ");
INSERT INTO roo_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","“Visii kokoropa irara ora voosi irara. Eake vai-a vao oa reipai? Gol pasi oa reipai, eke Tugoropa Kepa aue Tempel oa gol tugoro pievira karekepapeira, ra va iava rei vaisipape? ");
INSERT INTO roo_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ora vao tapo osa ora visii vo siposiporoaro iava oaravu vatepataveira oearovupa. Uva voeare oiso purapata, Vosa irouto eravao raga vaisipaoro oiso puraro, Oiraopavira rutu, oa oiso toupai kiuvu reo raga eva. Ari vosa irouto tauoa eravao-ia toupaive osa oiso puraro, Oiraopavira rutu, oire ra viapau uvuipa ora rera raga vo reoaro gasireve. ");
INSERT INTO roo_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Visii vao voosi irara. Eake vai reipai? E pasi tauoa reipapeira, eke eravao tauoa rei piepaiveira. Oa iava tugoropavira karekepapeira, eke? ");
INSERT INTO roo_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Uva eisi osa iava oisoa oirato eravao oirao piepaoro oiso puraparo, Oiraopavira rutu, ora orekerovu rutu varao oara oira ivara-ia toupaive. ");
INSERT INTO roo_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ari vosa ro ira Tempel vaisioro oisi puraro oiso, Oiraopavira rutu, oire uva rera-a eera ira voa Pauto tapo vaisire. Eake iava? Uvare Pauto voa toupareveira Tugoropa Kepa vao Tempel. ");
INSERT INTO roo_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ari vosa ro ira vuvuiua-ia vaisioro oisi puraro oiso, Oiraopavira rutu, oire uva rera-a eera ira Pautoa tapo vaisire voa. Eake iava? Uvare Pauto voa pauparoveira. ");
INSERT INTO roo_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Visii vao tarai irara Reo Taisi-ia ora visii Farisi riro kuuvu irara. Visii vao garepa aiorovi iava akuku aioro katakataivira vara vatevate ragapataveira varao iava tautauara rutu iava. Oiso osa varao aiorovi taraipara utuuva geesi piepataveira aue-ia geesi kouro Pautoa-pa tauoa purapasa. Ovusa varaore reipara ovaupataveira rutu oiso osa varao-ia oira rovirieipa pitupitu oiraopa, ora oirarapa siraopa pitupitu, ora oirao piea vo pitupituaro. Oire rovopa vao-ia vosa varao purapata, ra viapau oiso gareparavire tapo ovaupata vara purapa arapa. Oiso osa vao-ia taraipa aioro utuuva geesi piepa. ");
INSERT INTO roo_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Visii toupata oiso rutu osa voosi irara. Visiigoa oisore auepataveira ra oirara tuvetuvepata vo raivao-ia oa-ia auere ora kasivaripataveira kuvikuvi kare veraverapaoro roviara iava. Ari vosa koie ra oira rutu kopata. ");
INSERT INTO roo_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Visii vao tarai irara Reo Taisi-ia ora visii Farisi riro kuuvu irara visii. Visiigoa kap iava varaua raga sisupataveira ora dis, ovusa vara sopaaro agasipape varao iava kavirupa pitupituro ora varao ora aio piepa pitupituro visii raga varaaro. ");
INSERT INTO roo_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Vii Farisi voosito! Viigoa kap sopaaro sisigarue pie rovopari, ra oira varaaro tapo sisigarue epao. ");
INSERT INTO roo_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Visii vao tarai irara Reo Taisi-ia ora visii Farisi riro kuuvu irara. Visiigoa vatatopo iraopata. Visiigoa oisi rutu toupataveira osa tova urui. Oa ivara-ia vatoe kerarire vearo kekepapeira vo ragava ivara-ia. Ovusa rikuara sovara-ia riroara oira eruro keruara toupaive, ora oaravu rutu eruara. ");
INSERT INTO roo_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Eisi osa visii iava varaura sopaaro toupaiveira. Oire ra oearovu rutu oirara visii varaaro kekepaoro oiso keapaave, Torevoko irara, ovusa visii iava sopaura oavisii agasipape varao iava ratarataa vo pitupituro ora varao tapo Reo Taisiva kaureopa pitupituro. ");
INSERT INTO roo_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Visii tarai irara Reo Taisi-ia ora visii Farisi riro kuuvu irara. Visiigoa vatatopo iraopata. Visiigoa tova uruiro oritopataveira vo uruiro uva voeao tovaiva torevoko irara ora profet irara. ");
INSERT INTO roo_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Oire oiso purapataveira, Vosa voari rutu toupaiovori igei aao iraraaro vo vuutaaro-ia tuariri, oire ra viapau voea tauvapaio profet irara upopaoro. ");
INSERT INTO roo_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Uva evo reo oa purapatavoi ora visii iavirava oa-ia vaisipatavoi oiso, Igei aao iraraaro oea oisoa profet irara upopaive. ");
INSERT INTO roo_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Visii vo pitupitu vao ovoi pie iraopata, oa rovoiva visiipa aao irara oavisii voari tuariri. ");
INSERT INTO roo_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Visii rakoru kare, ora rakoru kare ovii iraraaro. Apeisi-a oiso osa rugorugoopatai vao-ia reesia vore Vuri Tapi? Viapau visii ouverea, raa? Uva ovu rutu iare toritaverea? ");
INSERT INTO roo_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Uva va-a eva oa vituaro iava voeao siposa aueparai visii vuruvuruaro iare riro tarai irara profet irara, ora tisa irara. Oea iava oearovu upopataverea, vo rara kare uviropaave visii vuruvuruaro iare. Ari oearovu tapapataverea evao parikouro-ia voea iava, ora oearovu ragipataverea Tugoropa Keparo sovara-ia. Ora voea tapo iava oearovu sigupataverea ouruirovu iava, ora voea tariopataverea ra avapaave ouruirovu iare. ");
INSERT INTO roo_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Uva eisi-a osa iava vao visii-ia karekeperea oa puraiva visii aao iraraaro voeao-ia vo rasio-ia. Ari ita, torevokoto Ebel ira kopii pieiva rera upooro. Oire rera-ia rovoaepa oa iava Sekaraia-ia pou piropa vo pitupitu raga eera Berekaia oviitoaaro. Uva voea-a evoea oea upoiva Tempel iava vo tugi vuutaaro-ia ora eravao. Uva evoea-a oea-ia eva puraiva ovuria eva oa vorevira visii-ia kare piereverea Pauto. ");
INSERT INTO roo_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Oiraopavira oiso visii tavipaavoi vao iava oa puraiva voari tuariri oa voriaro vuriaro ouiverea voeao vo vokio iavapa irara.” ");
INSERT INTO roo_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Oiso puraroepa, “Ae! Visii vao Jerusalem vata! Ae, visii Jerusalem vata! Visiigoa profet irara upopataveira voea vurukopaoro aveke-ia. Pauto kovopa irara oaro oea sipo ragapareveira vokiara rutu-ia. Ari ita, visii kakae vure oaa guru ragapaaveira oiso osa kokootu aakova ovii irara rakupaeveira putaeuarei-ia, osa ragaire korukorupata ora visii-ia. ");
INSERT INTO roo_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Oire oiso visii tavipaavoi, Uruia oavisii vao kuvaupai rara. ");
INSERT INTO roo_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Uvare oiraopavira visii tavipaa, Viapau oiso ragai keketavere vorevira vo rekasisa utupaua, vo vuuta-a eva uva oiso purataverea, Pauto viraakoa vateri ropa ira urioroi Turaro vaisiaro-ia.” ");
INSERT INTO roo_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Uva kosiro viropa vova Rovopa Kepa-ia Tempel osa disaipel rerare ravaaepa, vo osa voava urioparoepa. Oa iava Tugoropa Keparore rerare oiso puraaepa, “Auoro, vo keparo kekeri Tugoropara.” ");
INSERT INTO roo_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Oa iava Jisas voeare oiso puraroepa, “Iu! Oara kekepata evara reipa keparo. Uva oiraopavira rutu oiso visii tavipaavoi, Viapau iriai aveke vai eakave iriai ivara-ia aveke vai osa toupaive. Oara evara kururu piroverea koveoro.” ");
INSERT INTO roo_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Uva vo tou-ia vao-ia pauroepa vo pukuia-ia Oliv Kovo-ia. Oa iava voa rera iare urioaepa disaipel. Uva voa rera eripaiva rera akepaoro oiso, “Igei taviri oiso, Aa vo vuutao-a vao oa-ia evara karekeperea? Uva eake vai-a vao oa iava vo vuuta eveiioverea oiso, Vao vii vo vokiaro vao oa-ia kareuverea, ari vao ovoiopa vuuta?” ");
INSERT INTO roo_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Oa iava Jisas voeare oiso puraroepa, “Visii ora vatatopo iraopata, teapi irai visii kearevere. ");
INSERT INTO roo_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Riro irara uriopaaverea ragai vaisiaro raga-ia ora vaisipaoro, ra oiso purapaave, Ragai raga-a vao Krais. Uva riro irara rutu oirara ora riakora keakeapaiverea. ");
INSERT INTO roo_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Uva oiso upoa gurukoaro uvutaverea, ora va iava siposipo ovusa uvavu toupaive. Ra opeita rirovira rugorugoopata ora sitapaoro vo osa va vao kosi piro. Aue iava uvare va-a eva oa kareke rovoperea, ra vovio vo utupaua ovoiopa voki karekeperea rara. ");
INSERT INTO roo_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Oiso-ia oearovu oirara upoa kosi piepaiverea oearovu-ia oirara, ovusa osararovu osararovuva ora upoaverea. Ovusa ogoe vuutaro kosi piroverea voraro rutu ora ravurikeara. ");
INSERT INTO roo_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Uva varao oiso rutu toupaiveira osa riakova oisoa kakaetoava upia rovopao rera kavausa. ");
INSERT INTO roo_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Vo vuuta-a vao-ia oa-ia visii oupaiverea visii vao kovopa irara oaro Pauto vatepasa upia ora kasipua visii upopaoro tapo. Uva osararovu rutu iava oiso visiire vuri vovoupaaverea rutu. Eake iava? Uvare vaisia oaa visii-ia toupai. ");
INSERT INTO roo_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Uva vo vuuta-a vao oa-ia oearovu voea varaarore ovauaverea oirao pie vovouro. Ra araoko irara oaive iava gasipaive keripa irarapa ora voeare kasipupaoro rutu. ");
INSERT INTO roo_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Riro irara rutu tapo profet irara oea karekeaverea oirara rutu keakeasa. ");
INSERT INTO roo_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Oiso-ia vuri pitupituro rutu karekeperea riro irara-ia. Oa iava ora voeapa siraopa vovouro oaive kavuiverea. ");
INSERT INTO roo_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ari vosa ro ira viapau raveraveparo vo tugurasa ovoiopa vuuta iava vo voki-ia, uva rera-a eera ira oureverea Pauto ora rera iare. ");
INSERT INTO roo_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ari ita, oearovu Vearo Siposipo kosi piepaivere Pauto vo Saraaro iava siposipopaoro voraro rutu rasitoa rutu-ia. Ra va iava oirara rutu vo siposipo-ia taraipaave vao-ia. Oa isivaaro-ia karekeperea vao-ia ovoiopa voki. ");
INSERT INTO roo_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Oire uva va-a vao riroa rutu vuria oa keketaverea. Eva-a oa vituaro iava vo reo purareva Daniel tuariri voa toupaoro vo Tugoropa Tapi. Ari ita, ro ira vo reo vieireve vao-ia, oire ra vearovira vare rugooparo. ");
INSERT INTO roo_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Uva vo vuuta-a vao-ia oa-ia oirara rutu Judia-ia touiverea, ra uriripaoro voava tori iraoive pukuia iare. ");
INSERT INTO roo_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ari vosa ro ira kepa ivara-ia kiuvu oupaoro uvuruparoverea, ra viapau oiso voava rerereve auero rutu gurusa varao rera varaaro. ");
INSERT INTO roo_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ari vosa ro ira varuparo toureverea, oire ra viapau oiso voava ora porero kuvuparare rugooro varao rera varaaro. ");
INSERT INTO roo_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Siraovira rutu vairoviopa taruko riako, ora vairo airoa sikeo kakaero roro piepaiverea vo voki-ia vao. ");
INSERT INTO roo_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Variripatavere tuepaoro. Teapi torita vo kiuvupa vuuta eke vao-ia Tugoropa Voki ra Reo Taisi oaro Pauto gasita vokaoro Tugoropa Voki iava vo reo. ");
INSERT INTO roo_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Aue iava uvare vo vuuta-ia eva riroa rutu toupaiverea tavaka. Uva viapau oiso oai va-ia putepai vao iava oa pura piropa voari tuariri oa vao vo vokio-ia tugurapai. Va rutu vao isivaaro iava viapau oiso otavakai perea voari rutu utupaua oiso osa va vao-ia. ");
INSERT INTO roo_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ari vosa Pauto viapau vo vuuta vao poteku piepareve, ra oirara rutu opesiave. Ari ita, voeao ragare rugooro vo vuuta poteku piereverea oea reesireva ora rerapa. ");
INSERT INTO roo_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Vo vuuta-ia vao oire vosa irai visii tavipareve oiso, Krais-a ro vo-ia ira keketa. Eke oiso puraro, Varo vavo-ia, oire ra viapau rera vo reoaro oirao piepata. ");
INSERT INTO roo_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ora oearovu keakea irara krais irara ora oearovu profet irara oearoa rutu toreaverea karekeoro riropara rutu purapaoro ravotoara. Ora oaravu pisipisa kovoro oara tapo ravotovira puraiverea. Ari ita, vosa uvuipaave, oire ra oirara rutu ivuive ora voea iare voeao oea reesireva Pauto ora rerapa. ");
INSERT INTO roo_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Uvuta! Vao iava visii vosiavoi ravaavira, ra uutupata. ");
INSERT INTO roo_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Eisi vosa visii tavipaive, Rera keketa varo ira vavo toupare kuvau tapi. Oire ra viapau voea vo reoaro uvupaoro voare avapata. Ora vosa oiso visii tavipaive, Ro-ia kepa sovara-ia ira vataupa. Oire ra viapau oiso voea vo reoroaro oirao piepata. ");
INSERT INTO roo_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Taraipataveira varakeotoa-ia ira parakaupaoro voraro rutu aviavipareveira vuvuiua-ia. Eisi osa parakauoro voreraverea Oirato Oviitoaaro Ro Ropoto vo oirara rutu osireiaro-ia. ");
INSERT INTO roo_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Uva osa-a eisi osa vatau asavira ruega kare ora gurupaaveira eru karero aiopasa. ");
INSERT INTO roo_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Vo osa vo voki vao tavakapa voki isivaaro iava ravireo ruparoverea, ora kekira tapo oiso viapau rororeverea. Aaviikoara kovekoveperea vova vuvuiua iava. Orekerovu rutu goruara vova vuvuiua ravurikeperea. ");
INSERT INTO roo_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Uva vo vuuta-a vao oa-ia ragai vo reesiaro vuvuiua-ia karekeperea. Oire uva oirara rutu vo rasio-ia va kekeoro gauiverea, vo rara ragai Oirato Oviitoaaro tueiverea ovusa rukuta sovara-ia uriora riroa rutuva gorua ora keraria ragai vaaro. ");
INSERT INTO roo_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Oire utaveoro varapaaverea vo rara ragai voeaaro aruave enselpa irara, ra voea guruive voeao oea ropoava voraro rutuva vo rasito rekasiaro-ia. ");
INSERT INTO roo_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Visii uvuipatai ra vao-ia fik ova tarai oupata vo rara airepa guruvaro kosi pieive. Oire ra va iava oiso taraita, Uukoa toupai vai-ia, oa iava poretevira toupaivoi. Ra va iava oisi ragavira taraipata raipipa vuuta tutuu piepai oa-ia ravireo rororovere. ");
INSERT INTO roo_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Eisi ragavira ita osa iava uvuipatai ra ragai iava taraipata oiso, Reraei ira ratao riaaro-ia ora tovoroi koatasa. ");
INSERT INTO roo_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Oiraopavira rutu visii tavi iraopaavoi oiso, Oirara rutu voeao vo vuuta-ia eva viapau oiso voea rutu kopiiaverea vosa vara rutu evara kareke rovoperea. ");
INSERT INTO roo_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Oire oiso-ia vuvuiua opesiperea ora rasito. Ari ragai vo reoaro viapau rutu oiso opesiperea. ");
INSERT INTO roo_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Uva viapau irai taraiparoi vo voki-ia ora vo vuuta-ia, ora purapurapa irara voeao ensel oaro tapo voeao vo vuvuiua oea viapau taraipaai, ora Oviitoaaro tapo viapau taraipa. Ari Aitetoa raga taraipa Pauto. ");
INSERT INTO roo_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Vo pitupituro oara puraiva vo Noa vo vuutaaro-ia osa raga eisi osa ita pieiverea vo vuutao-ia oa-ia voreraverea Oirato Oviitoaaro Ro Ropoto. ");
INSERT INTO roo_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Voari tuariri uva rirova pirutuva kareke asavira toueva ovusa vo vuuta-ia vearovira aiopaiva, ora vearovira ukaiopaaepa osa oearovu vo vuuta-ia vearopavira raga riako oupaaepa. Oire vo tugurasa urioaepa oisi raga piepaoro uva Noa uvuoa sovara-ia koataroepa, va vaisiaro, aka. ");
INSERT INTO roo_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ari ita, viapau oiso oisi rugoopaaepa. Oa iava akukuvira raga toupaiva osa rirova pirutuva urioopa voea rutu oirara ora riakora turosa. Uva oisi raga ita-a eisi osa pieiverea vosa Oirato Oviitoaaro vorero vo uva viapau rera vorearore rugorugoopaave. ");
INSERT INTO roo_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ari vo osa aiterei toupasiverea varuparo vai. Oire uva vaiterei iava iravu oureverea Pauto iravu arova voa raga. ");
INSERT INTO roo_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ari vo osa airei riakorirei vai plaua purapaereverea auere bret, osa Pauto vairei iava iriavu oureve iriavu arova voa raga. ");
INSERT INTO roo_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Uva eisi osa iava vearovira rutu uutupata. Viapau oiso taraipataveira vo vokio-ia oa-ia Turaro oavisii voreroverea. ");
INSERT INTO roo_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Vare vao rugoo iraopata. Oire rovovira rutu ro ira vo kepaaro-a kepa oiso rugorugooparo, Esa vokiaro vai urio viarovere kavirupato, ra uutuparo. Ra viapau oiso rera eaka ragapareve ovusa rera vo kepaaro tatepareve koatasa. ");
INSERT INTO roo_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Uva visii tapo vao-ia vatatopopata tuevira vokiara rutu-ia vaore rugoopaoro oa-ia Oirato Oviitoaaro voreroverea. Vo ovuutai-ia viapau oiso ra oiso rugoopata, Uriorovere rara. Oire uva vo vuuta-a vao oa-ia oirara rutu rerapa vovou vakuvakuvira touiverea oiso purapaoro, Viapau oiso vo vokio uriorovere. Ovoki-a eva oa-ia voea sita piereverea. ");
INSERT INTO roo_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Oire irouto-a ro kovopato ira oisoa toupareve, Eera vearo rugorugooto ora vearo kovo purapato. Oare rera tovoreva reito ro rera reraaro oearovu-ia kovopa irara vuravurapasa voea tokipaoro ora aio vatepasa vo ora rera vo vuutaroaro-ia. ");
INSERT INTO roo_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Oire utupaua reitoa ro voreroverea, ra rera kekereve ro kovopato ovusa vo kovo purapareve oiso osa vare rera tavireva, ra va-ia rera ro kovopato rorureve. ");
INSERT INTO roo_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Uva oiraopavira rutu visii tavipaavoi oiso, Auero rutu rera varaaro tokipasa rera tovoreva kovopato. ");
INSERT INTO roo_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ari vo osa ro kovopato vurito ora rera raga ora keaparo oiso purapaoro, Ragai reraaro reito viapau uvuipa ra ikauvira urioro. ");
INSERT INTO roo_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Oire rovoro ora rera voeaaro upopaoro kovopa irara aue raga purapaoro ukaio ora aue tapo aio oearovu tapo oirara. ");
INSERT INTO roo_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Oire rera ro vurito kovopato reraaro reito voreroverea vo vokio-ia ovokia-ia viapau oiso rerare tuero. Viapau oiso rrare tueroverea viapau rera-ia taraipaoro osa urioro. ");
INSERT INTO roo_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ra kovopato oaro vurivira rutu uporeve rera ragipaoro. Ra voava rera tovoreve voeao ruvara-ia riro kuuvu irara. Ra voea rutu voa ora reuri oaive kuripaive ora voeapa siraopaoro evoa opesipa tapi. ");
INSERT INTO roo_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Vo vuuta-a eva oa-ia Pauto vo Saraaro iava oiso karekeperea osa vairoo tavauru riako katai tau (10) rutu. Airoa vuravuara oaive ouoro avaaepa rova aivarosa ira reesiiva oiso ra riakova oureve. ");
INSERT INTO roo_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Uva ovavaevu-a vaaruu vovou riako vairo raga iava, ari ovavaevu-a vearo rugorugoo riako. ");
INSERT INTO roo_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Oire uva vairoo vaaruu vovou riako vuravuara ragava avaaepa osa viapau aue kerasina vai vara iare auere vosa vara iava ita opesipe, ra ovuva ita oarai tovoive vara-ia? ");
INSERT INTO roo_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ovusa vairoo vearo rugoo riako kerasin oviro tapo ora vairo varaaro kaeiva vuravuara. ");
INSERT INTO roo_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Uva rera ro riako oupato viapau urioroepa ikauvira. Oa iava ruraiva. Uva va iava uusiaepa. ");
INSERT INTO roo_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Uva vo voki vuuta-ia oavu keera urioepa vairore oiso purasa, Rera ro riako oupato ira urioroi. Avata rerare korotosa. Ra rerava aivarooro rerava uriota! ");
INSERT INTO roo_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Oire va iava vuravuara vatatopopaiva. ");
INSERT INTO roo_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Uva vairoo vaaruu vovou riako oiso puraaepa vairore vearo rugorugoo riako, Ae, igeipa kerasinara vai vateta. Ari igei varaaro iava opesiei. ");
INSERT INTO roo_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Oa iava vairoo vearo rugorugoo riako vo riako aatooro oiso puraaepa, Viapau varao kerasinara vigei rutuva uvuipai. Oara igei raga varaarova uvuipai. Ari avata evoraro voripa kepa vai-ia oarai vorisa. ");
INSERT INTO roo_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Uva avaaepa kerasin vorisa ovusa riako oupato urioroepa. Osa vairo airoa vatatopoaepa airoa raga rera tapo koataaepa kepa-ia rera tapo pausa riroa-ia aioa vao ora oupa aio. Uva rataoa voea ururao tupa piropa. ");
INSERT INTO roo_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Oire uva utuaepa vairo airoa uutupaaepa. Oa iava voa pou virooro oiso puraaepa, Turaro, turaro, igeivire karuri! ");
INSERT INTO roo_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Oa iava vairo vo keeraaro uvuoro vairore oiso puraroepa, Oiraopavira rutu visii tavipaavoi, viapau taraiparai visii-ia.” ");
INSERT INTO roo_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Uva reo ruu opesioro oiso puraroepa Jisas ora rera iava, “Eisi osa toupai oiso, Vearovira rutu uutupata. Viapau taraipatai vuuta-ia ora voki-a vao oa-ia urioroverea Oirato Oviitoaaro. ");
INSERT INTO roo_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Vao Pauto vo Saraaro oa oiso rutu toupaiveira osa ro iravu oirato ira uvavu vokasa aueparoepa. Oa iava rera voeaarore keeraroepa kovopa irara voea vavaearo-ia varao tovosa rera varaaro, oiso ra vara purapaive vara tokipaoro. ");
INSERT INTO roo_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Oire vo voki-a vao oa-ia voea vo pitupituarore rugorugoo rovoroepa ora voea varaaro tapo goruara voea voeao kovopa irara katakataivira. Oa iava monia roo piereva voeapa oiso, iravu vatereva vo vavae tuku kina (K5,000), ari iravu vatereva erao tuku kina (K2,000), ari iravu vatereva katai tuku kina (K1,000). Uva oiso va puraoro voeapa avaroepa vokasa. ");
INSERT INTO roo_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Uva avaroepa osa rera isivaaro iava ro ira vo vavae tuku kina oureva, ira va-ia eva oavu sara kovo purareva. Oa iava oavu ita kareke piereva oisi va-ia kovooro pute piea vo vavae tuku. ");
INSERT INTO roo_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ari ro ira erao tuku kina oureva ira va-ia eva oavu sara kovo purareva. Oa iava oavu ita kareke piereva oisi va-ia kovooro pute piea erao tuku. ");
INSERT INTO roo_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ovusa ro ira katai tuku kina oureva, oa iava vare rikui tekareva va tovasa rasiuaaro. Uva voa-a vo uva rera reraaro reito vo moniaro vataureva. ");
INSERT INTO roo_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Oire uva riro kaekae vuuta rutu puteva. Oa iava va isivaaro iava reito oaive voea iare kovopa irara urioroepa vorevira. Uva oiso rugooparoepa ra voea tapo reoa torevokoreve varao iava moniara oara-ia voea pitupitu piereva. ");
INSERT INTO roo_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Uva ro ira vo vavae tuku kina oureva, oa iava oavu ita karekereva vo vavae tuku kina va sipooro. Uva oiso puraroepa, Reito, ragai vaterivora vo vavae tuku kina (K5,000). Va kekeri vao-ia oa-ia sara kovo puraavora. Uva oavu ita ouvora vo vavae tuku kina pute piea. ");
INSERT INTO roo_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Oa iava rera ro reito oaro oiso rerare puraroepa, Vii vearoto-a rutu kovopato. Viigoa vearoa purarivorao ora vearovira kovoa tokirivorao. Oire varavi tapo gareparavi kasivarivira tokipariveira, uva eisi osa iava vii tovopaa riropaara rutu orekerovu tokipasa. Uriou ra roruri ragai tapo. ");
INSERT INTO roo_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ari ro ira erao tuku kina (K2,000) oureva, ira tapo urioroepa. Oa iava oiso puraroepa, Reito, ragai vaterivora erao tuku kina. Va kekeri vao-ia oa-ia sara kovo puraavora. Uva oavu ita ouvora erao tuku kina pute piea. ");
INSERT INTO roo_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Oa iava reito oiso rera tavireva, Vearoto ita vii kovopato. Viigoa vearoa purarivorao ora vearovira kovoa tokirivorao. Oire varavi tapo gareparavi kasivarivira tokipariveira, uva eisi osa iava vii tovopaa riropaara rutu orekerovu tokipasa. Uriou ra roruri ragai tapo. ");
INSERT INTO roo_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Uva ro tapo urioroepa ira katai tuku kina (K1,000) oureva. Ira oiso puraroepa, Reito, vii-ia taraiparai riro kasivarito vii, viigoa vo kovoro tatepariveira oara viapau oiso paupariveira. Ora varao tapo oara vikipaiveira oearovu vara paupaoro kukaraara vo rasio-ia. Oire uva vara tapo ou ragapariveira. ");
INSERT INTO roo_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Uva eisi osa iava uririraepa. Oa iava vao vatauava katai tuku kina vo rasito. Va kekeri vao-ia vii vaaro! ");
INSERT INTO roo_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Uva reito oaro rerare oiso puraroepa, Vurito-a rutu vii kovopato riro reasito. Uva pasi taraipauveira ragai-ia oiso, Ragai vo kovoro tatepaaveira oara viapau oiso paupaaveira. Ora varao tapo oara vikipaiveira oearovu vara paupaoro kukaraara. Uva evara tapo ou ragapaaveira? ");
INSERT INTO roo_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Uva eakepa ragai vaaro monia tovo asariva beng-ia? Oa iava voa va iava pute piea tapo ouavori? ");
INSERT INTO roo_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Oire rera ruvara iava va outa ro vatesa ira vo vavae tuku kina-ia (K5,000) pitupareva. ");
INSERT INTO roo_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Eake iava? Uvare oirara rutu vao raga-ia pitupai uva oavu ita vatepaa voeapa tauvavuvira pute piea. Ari ita, vosa iravu viapau orekerovu-ia pitupareve, oire gareavi raga-ia pitupareve eva oa-ia rera itoavere rera ruvara iava. ");
INSERT INTO roo_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Uva oiso voea tavireva rerare vurito kovopato, Rera siguta evoare rupa-ia. Ra voa toupaoro ora rera raga iava reuriara kuripareve ora rerapa siraopaoro. ");
INSERT INTO roo_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Utupaua turarovira urioraverea aueva keraria voea tapo enselpa irara. Uva va iava paupa-ia uvururaverea vao king paupaaro. ");
INSERT INTO roo_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Oirara rutu vova rasito ragai ruvara-ia ora guruaverea, ra voava voea rovirieiaverea oiso osa sipsip ragui ora meme ragui toupaiveira oiso, sipsip ragui uvavu, meme ragui uvavu. ");
INSERT INTO roo_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Eisi osa voeao sipsip ragui tovoaverea vo ora ragai vaaro-ia oirapapa varata, ovusa meme ragui oisova tovoave koike varata-ia. ");
INSERT INTO roo_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Oa iava voea-a voeao oirara oea toupai oirapapa varata-ia oea taviaverea oiso, Visii viraakoreva Aite oaa. Visiigoa uriota ra va outa Sara oa puraava visiipa voari rutu rasito rovoaro-ia. ");
INSERT INTO roo_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Eake iava? Uvare vo tuariri oisoa ogoevira toupaa osa ragai aio vatepata. Ora vosa uuko regapara, ra ragai vatepata uukoara. Ragai ita vao ouruivu raga iava taveteto ragoare oisoa keerapata vorarore ora visii vo keparoaro-ia. ");
INSERT INTO roo_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Vosa tapo oisoa varo apotapara, ra ragai vatepata varoara. Ora vosa tapo oisoa upiapara, ra ragai ruvarupata. Ora vosa tapo oisoa tuukea-ia toupaa, osa voa ragai kekepasa uriopata. ");
INSERT INTO roo_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Uva oisi-a eisi osa iava voeao torevoko irara ragai aatooro oiso puraaverea, Turaro. Aa vo vokio vii kekeiovora osa ogoepauera uva vii vateiovora aioara? Ora aa vo vokio uuko regapauera oa iava vii vateiovora aue uuko? ");
INSERT INTO roo_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ari aa vo vokio-ia vii kekeoro oiso puraiera, Uriou, vii-a taveteto ouruivu raga iava vore igei vo kepaaro? Ora aa vo vokio-ia apotapauera auepa varo oa iava viipa vaaro vateiera? ");
INSERT INTO roo_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ari aa vo vokio-ia vii kekeiovora osa upiapauera, ora tuukea-ia touparivora, uva aaviopavira vii kekesa urioiera? ");
INSERT INTO roo_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Uva oiso voeare puraraverea, Ragai visii tavipaavoi oiraopavira oiso, Varao oara oisoa purapata ro-ia akaipato ragai araoko iraraaro iava rera, uva ragai-ia ita rera ragoa-ia vara puratavora. ");
INSERT INTO roo_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Oa iava voeao taviaverea oea koike varata-ia toupai oiso, Opesi irara visii. Visiigoa ragai kavupata tuitui kasi iare avaoro vao oa viapau opesipape. Okasia tovoreva Aite auepa Seten ora voeao purapurapa irara ensel Seten voeaaro. ");
INSERT INTO roo_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Eake iava? Vosa oisoa ogoevira toupaa, osa viapau ragai vatepata aioara vai voari tuariri. Ora vosa oisoa uuko regapara tapo, uva viapau oisoa ragai ukaio piepata. ");
INSERT INTO roo_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ari ita, ragai-a taveteto ouruivu raga iava, uva viapau oisoa ragaire keerapata vorarore ora visii vo keparoaro iare. Ora vosa oisoa varo apotapara, osa viapau ragai vatepata varoara vai. Ora vosa oisoa upiapara, ora vosa oisoa tuukea-ia toupaa, osa viapau ragai kekepasa uriopata. ");
INSERT INTO roo_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Uva eisi osa iava voea tapo ragai vo reoaro pukopaiverea oiso purapaoro, Turaro. Aa vo vokio-ia vii keke ragapaiovora osa ogoevira touparivora, ora vosa uuko regapauera, ora vosa ouruivu raga iava vii-a taveteto, ora vosa varo apotapauera, ora vosa upiapauera, ora vosa tuukea-ia touparivora osa voa viapau vii tauvapaiovora? ");
INSERT INTO roo_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Uva voea aatoaverea oiso puraoro, Oiraopavira visii tavi iraopaavoi, Ari ita, varao oara oisoa viapau purapata ropa akaipatoavi voeao iava ragai araoko irara oaro rera, oire uva ragai-a ita rera ragoapa oisoa reasipata oisi vara purapa arapa. ");
INSERT INTO roo_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Uva eisi osa ragavira iava voeao oirara vuria oaive voriaro ouiverea aue-ia upia ora siitoka ora voeapa vokiara rutu-ia. Osa voeao torevoko irara Tootoo Ovoi ouive vao oa viapau opesipape.” ");
INSERT INTO roo_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Oire uva Jisas rera vo siposiporoaro opesi piereva. Oa iava rera voeaaro disaipel tavireva oiso, ");
INSERT INTO roo_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Visii taraipatai oiso ragavira vo vokirei isivaaro iava Tagausapa Vurei Pasova pura pirovere, ra ragai kosi pieivere ragai vuri piesa evao parikou-ia.” ");
INSERT INTO roo_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Uva vo voki raga-ia Rovopato Pristo tauo purapato vo kepaaro-ia ora guruaepa Kaiafas voearei rutu pris irara ora reipa irara vova Isrel. ");
INSERT INTO roo_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Uva oiso ragavira Jisas-re reo goru puraiva ra rera tuve pieive. Oire ra voava kaviruvira rera rauive, ra rera kopii pieive. ");
INSERT INTO roo_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Uva oiso puraaepa ora voea ragare, “Avoeao, asi viapau uvuipaviei ra vao purape vao-ia vo vokio-ia oa-ia riroa aioa purapapi. Teapi oirara rutu ora sitaoro upoa vai kosi pieive.” ");
INSERT INTO roo_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jisas Betani-ia toureva leprapato vo kepaaro-ia Saimon. ");
INSERT INTO roo_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Uva iriavu riakova urioopa aueva korovo ovi sanda aue-ia popotepa tou vearoa Alabasta, oiso osa aveke. Uva vo ovi kokoeva Jisas kukuearo-ia rera rei pieoro osa tebol-ia pauparoepa. ");
INSERT INTO roo_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Oa iava oearovu disaipel irara va tueoro oiso ora reopaaepa, “Avoeao, uva apeisi o vao pire ragapae korovo ovi? ");
INSERT INTO roo_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ari ita, vosa oira vateeri iraipa, oire va iava oira-ia riroa vai voria vai vatereve vigeipa irai. Oire ra oai vatepe voeaopa apota irara.” ");
INSERT INTO roo_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Oa iava Jisas voea vo vovouaro-ia tarai ovoiroepa. Oa iava oiso puraroepa voeare, “Eakere o vovouaro vavata pie ragapata? Iria vearo pitupitu purae ragai-ia! ");
INSERT INTO roo_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Easi apota irara visii tapo toupaiverea vokiara rutu-ia. Ari ragai viapau oiso visii tapo toupaavere. ");
INSERT INTO roo_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ari o riakova iria o petoe sanda ragai varaaro-ia tova iare, oa puraevoi ragai-ia ravaavira. ");
INSERT INTO roo_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Oiraopavira visii tavipaavoi oiso, Vo uvarovu rutu uva Vearo Siposipo kosi piepaiverea rasitoa rutu-ia, ra va-ia vao tapo ora reopaave vare rugoopaoro oa puraevoi o-ia riakova ragai-ia.” ");
INSERT INTO roo_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Vo vuuta-a vao oa iava vo vokia avaroepa iravu voea iava katai tau erao (12) disaipel. Rera vaisiaro, Judas Iskariot. Ira avaroepa reipa irara iare pris ");
INSERT INTO roo_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","oiso purasa, “Eake vai vate ruipapatai ragaipa, ra visii riara iare rera karekea?” Oire uva va iava rera vateiva vo peva tau (30) aue silva moniro. ");
INSERT INTO roo_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Uva voava rovoroepa rerare raiva taraapaoro oiso, Aa vo voki avuo-ia Jisas kosi piepaa voea vaveaaro iare? ");
INSERT INTO roo_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Uva vo rovo vokiaro-ia Yis Asa Aio aue bret oa-ia disaipel urioaepa Jisas akesa, “Ovu-ia viipa ravaavira aioa vai puraiovere aue Pasova Vurei vai?” ");
INSERT INTO roo_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Oa iava oiso voea tavireva, “Kareta viro evoare Jerusalem urui sovara-ia irai iare. Ra oiso irai tavita, Tisato oiso puraroi, Ragai vo vuutaaro tutuu pievoi. Uva Pasova Vurei aiosa ruipaparai voea tapo disaipel vo vii vo kepaaro-ia.” ");
INSERT INTO roo_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Oire voea disaipel oisi va puraiva oiso osa voea tavireva Jisas-pa va ravaaoro Pasova Vurei. ");
INSERT INTO roo_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Oa iava ovaiarovi tebol-ia pauroepa voea tapo katai tau erao (12) disaipel rera voeaaro. ");
INSERT INTO roo_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Uva aiopaiva ovusa oiso puraroepa, “Oiraopavira visii tavipaa, Iravu visii iava ira ragai kosi pieparevoi rara.” ");
INSERT INTO roo_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Oa iava vovouisiro rutu vavataepa voeare siraooro. Uva voava rovoaepa rera-ia ora veraoro rera akeoro oiso, “Turaro, esa ragai-a?” ");
INSERT INTO roo_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Uva voea aatoreva oiso, “Easi eera ira bretea rupu piere tapi rovu-ia va aiosa ragai tapo, ira-a eera ira ragai kosi pierevere. ");
INSERT INTO roo_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Iu. Oirato Oviitoaaro avapa kopiia-ia oiso osa Tugoropa Vuku taviepa ragai iava. Ari ita, siraovira rutu rerapa ro ira Oirato Oviitoaaro kosi pierevere. Vearopai vosa viapau aakova rera kavauevori?” ");
INSERT INTO roo_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Uva Judas rera kosi piesoto ira rera akereva oiso, “Tisato. Esa ragai-a pasi?” Oa iava Jisas oiso puraroepa, “Iu ita, vii raga-a eva viigoa eisi purauei.” ");
INSERT INTO roo_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Uva voa-a vo aiopaiva uva Jisas bret oureva va-ia vuurapa vaisi purasa Pautoa-ia. Oa iava va puteputereva voeapa disaipel va vatevatesa. Uva oiso puraroepa, “Va-a eva ragai varaaro oa ouri ra va aiori.” ");
INSERT INTO roo_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Oa iava kap-ia wain karo oureva. Oa iava Pautoa-ia vuurapa vaisi purareva va-ia. Uva voava voea vateoro oiso puraroepa, “Ieta, visii rutu vao-ia ukaiota. ");
INSERT INTO roo_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Eira revasiva oaa iria paruevere ragai iava osa kopiira oirara rutu iava vuriara veraoro Pauto vaaro Reo Ovoi oirao pieoro. ");
INSERT INTO roo_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ragai oiso visii tavipaa, Vo vuutao iava vo vokia vo utupaua uva viapau ukaioravere wain karova-ia. Ari ita, vo raga uva airepa karova-ia ukaioraverea utupaua visii tapo Aite vo Saraaro sovara-ia.” ");
INSERT INTO roo_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Oa iava iriavu-ia eraaepa erava. Uva voava kosia viropa Oliv Kovo Pukui iare avasa. ");
INSERT INTO roo_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Oa iava Jisas oiso voeare puraroepa, “Visii rutu varaaro oirao pie vovouro vuripai ragaipa vo rupao-ia vo rara ragai arova torita. Ari ita, aue iava uvare Tugoropa Vuku oiso purapapeira, ‘Pauto sipsip ragui tokipato uporeverea, ra rerare rorooro sikaa viro sipsip ragui.’ ");
INSERT INTO roo_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Uva vorevira toreravere kopiia iava, ra va iava visiipa irara Galili iare.” ");
INSERT INTO roo_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Oire Pita rerare oiso puraroepa, “Ari ita, vosa voea rutu varaaro oirao pie vovouro vuripere viipa, eagara osa ragai vaaro oirao pie vovou viapau oiso ra vuripe!” ");
INSERT INTO roo_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Oa iava Jisas Pita aatoreva oiso purapaoro, “Pita, oiraopavira vii tavipaa oiso, Vo vokiaro vo osa kookai gau asavira tourevere ovusa vo peva purari ragai vaisiaro taeapaoro.” ");
INSERT INTO roo_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Uva Pita oiso puraroepa rerare, “Viapau rutu. Asi vii tapo kopiiravere vo rara viapau vii vaisiaro taeaa.” Oa iava voea rutu disaipel oisi aga puraaepa. ");
INSERT INTO roo_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Oire uva Jisas voea tapo avaroepa uvavure uva oiso vaisipaive oiso, Getsemani. Oa iava voeare disaipel oiso puraroepa, “Vovio toupatavora, osa vavoviore avara voa varirisa.” ");
INSERT INTO roo_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Oa iava Pita vase oureva ora Sebedi oviitoareiaro. Uva voea tapo avaroepa. Oire uva rerare sopaua rirovira rutu siraoepa. ");
INSERT INTO roo_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Uva voa oiso voea tavireva, “Ragaire sopaua rirovira rutu vavatae siraooro, osiraoa vao oiso rutu sovoa oa iava kopiirai vao-ia. Vo touta ragai tapo uutupaoro, ra ragai vo vavataaro sovota.” ");
INSERT INTO roo_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Oire voava gare visivi avaoro kopukopua ivara-ia gerevira koveroepa. Oa iava voa variri ovoiroepa oiso puraoro, “Aite. Vosa ruipapau ra ragai iava o kap verari iria agasioi rutu aue iava siraoa vo vavataaro. Uva viapau uvuipau ra ragai vo ruipaaro sirova utuu. Viapau. Ari vii raga vo ruipaaro sirova utuu.” ");
INSERT INTO roo_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Uva voreroepa Pita vase kekesa osa uusipaaepa. Oa iava oiso puraroepa Pita-re, “E viapau uvuipatai ra ragai tapo uututa katai vuutavi vai raga-ia, raa? ");
INSERT INTO roo_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Uutupaoro variripata. Teapi kokarapa vovou visii iare uriope visii kove piesa. Ari ita, vovouisiro oavisii ruipapai oiso ra ragai tapo touta, ovusa varauraro oavisii raga visii iava raveravepai.” ");
INSERT INTO roo_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Oire uva voreroepa ita erao pie vuuta-ia voare ita varirisa oiso, “Aite. Vosa o-ia kap viapau oiso uvuipauei ra oira verari ragai arova, iria-ia ukaioparai, uvare vii vo ruipaaro-a oa purasa-a.” ");
INSERT INTO roo_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Oa iava voreroepa ita voea iare osa uusipaaepa, uvare voeare rurapaiva osireiara. ");
INSERT INTO roo_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Uva voava voea arova voreroepa ita vo peva pie vuuta-ia varirisa oiso raga osa variri rovoroepa rovovira. ");
INSERT INTO roo_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Oa iava voava voea iare urioroepa disaipel. Uva voeare oiso puraroepa, “E touvira uusipatai reareapaoro? Oire uvuta! Vuuta vao tuguraei oa-ia Oirato Oviitoaaro kosi piepai vo vuri vovou irara vavaearo iare. ");
INSERT INTO roo_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Toreta ra avavio. Rera keketa! Ro-ia ira ragai kosi pierevoi. Ira-a ro ira urioroi.” ");
INSERT INTO roo_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Oire uva vo Jisas touvira reoreoparoepa, ovusa Judas pouro viropa voea iava rera voeao katai tau erao (12). Ira riro irara tuvetuveoro urioroepa oea toorioara kaepaoro urioaepa ora aue kakuara voeao oea aruiva pris irara voearei rutu ora reipa irara vova Isrel. ");
INSERT INTO roo_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Uva rera ro ira rera kosi piereva voeapa ira oavu reesia tovoreva voeapa oiso puraoro, “Vosa rerava uugaaravere, oire ra rera-ia pitu ovoita.” ");
INSERT INTO roo_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Uva voava ikauvira urioroepa Jisas iare oiso puraoro, “Vearo rupa Tisato.” Uva rerava uugaa ovoiroepa. ");
INSERT INTO roo_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Oa iava Jisas oiso puraroepa rerare, “Vatetoa oaa, vao oare uriouei oire va pura ovoiri ikauvira!” Uva evo reo isivaaro iava tupe ovoiaepa rera rauoro Jisas. ");
INSERT INTO roo_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Iravu ro ira Jisas tapo toupareva ira toorio gororeva. Oa iava Rovopato Pristo kovopatoaaro uvareoaro pakoreva rera toeoro. ");
INSERT INTO roo_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Oa iava Jisas rera tavioro oiso puraroepa, “Toorio vore pieri eera rera vo tavukiaro-ia, uvare oirara rutu toorioara-ia ora upopai, oara-a evara voea upoverea voea varaaro vuria oaive kare pieoro. ");
INSERT INTO roo_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Easi pasi vii viapau taraipauei oiso osa ragai uvuiparai vosa oisi oai purasa ruipapara, oire ra Aite area, ra va iava ragai vatereve riro tuku (tausen) vai rutu aue enselpa irara vai ragai-ia tuesa. ");
INSERT INTO roo_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ari vosa oisi oai purasa auepara, ra apeisi ragavira Pauto vo reoaro oiraopavira karekepe, vo reo oa oiso puraepa, Oiso ragavira oiso pieri?” ");
INSERT INTO roo_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Uva vo vuuta-a vao oa-ia voeare oiso puraroepa Jisas, “E ragai ousa uriotai evarava toorioara ora evara ragi vurukoro? Ari ita, oisopai rutu visiipa, Kavirupato ira tuukesa uriotai. Vokiara rutu-ia oirara rutu oisoa siposipopaa Tugoropa Keparo-ia osa eakepa voa ragai rau asapata? ");
INSERT INTO roo_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ari ita, profeta irara vo rigatoroaro ragai iava oirao piesa ragai-ia oara rutu varao kareke piepaa.” Oa iava disaipel rera arova tori ovoiiva. ");
INSERT INTO roo_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Oire rera rauoro rerava avaaepa Rovopato vo kepaaro iare Pristo Kaiafas vo kepao, oa-ia voeao rutu toupaiva Reo Taisi-ia tarai irara ora reipa irara. ");
INSERT INTO roo_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Uva evoa tauaivi Pita rera sirova utuoro riro sitavi-ia kasura-ia rekasiroepa vao Rovopato Pristo vo kepaaro kasuraaro. Oa iava voa koataroepa pausa oeavu ruvara iare polis irara. Aue iava uvare oiso ruipaparoepa ra vao kekereve oa purapai rera-ia Jisas. ");
INSERT INTO roo_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Oire uva reipa irara pris ora Kaunsel irara oea rutu oiso ora reopaaepa, ra irai oiratoa vai reesiive. Ra irai rera iava Jisas kuuvuro kortua-ia vo kuuvu-ia. Ra oa iava rera upoive. ");
INSERT INTO roo_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Oire uva va iava oearovu riro irara uriopaaepa. Oa iava oaravu-ia kuuvu reoro rera toga ragapaiva. Aue iava uvare viapau oiso oai vituaro oiraopavira kekepaiva, oisore ra oai iava rera kopii pieive. Uva va-a vao isivaaro iava aitereivu pousi viropa ");
INSERT INTO roo_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","oreovuva rera iavirava vo reo oa purareva. Uva oiso purasiepa, “Easi ro oiso puraroepa, Ragai uvuiparai ra Pauto vo kepaaro Rovopa Kepa Tugoropa Kepa pakoa. Ra ita vorevira vo peva raga-ia voki vo kepa paua ita.” ");
INSERT INTO roo_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Oire uva Rovopato Pristo toreoro Jisas-re oiso puraroepa, “E reasipauei vo reo eva aato arapa, raa? Apeisi vo reo-a eva oa-ia vii togapaivoi?” ");
INSERT INTO roo_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Osa viapau Jisas reoparoepa. Uva Rovopato Pristo rerare oiso puraroepa ita, “Ragai vii ake iraopaavoi Pauto vaisiarore ro Tootoopato, ra igei tavi iraori oiso, E vii-a Krais Pauto Oviitoaaro, viigoa vigei Jiu-pa irara tuvetuvepasa uriouera, eke?” ");
INSERT INTO roo_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Uva Jisas rera aatooro oiso puraroepa, “Eisi osa purauei. Uva visii tavipaavoi oiso, Vo vuutao iava vo vokia vo utupaua uva ragai-a vao Oirato Oviitoaaro keketaverea, ovusa paupara vo oirapapa varata-ia vao Pauto, ro ira goruara rutuva toupareveira. Uva rukuta sovara-ia tapo vorevira urioraverea vova vuvuiua-ia.” ");
INSERT INTO roo_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Oire uva oisi-a osa puraroiva Jisas, Rovopato Pristo ora rera iava kuvupato karikarioro kasipuroepa oiso puraoro, “Pauto toviparevoi! Uva viapau ita uvuipaviei ra oeaire keeravio rera vo reoaro rovirieisa. Ira ro Pauto tovipare! Ari ita, rera uvutavoi ita! ");
INSERT INTO roo_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Uva apeisi vai rugoopatai?” Oa iava oiso puraaepa rerare, “Ira-a eera uvuipa ra kopiiro. Ira-ia vuria epao!” ");
INSERT INTO roo_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Oa iava rera kagavearo-ia ruipaaepa oearovu rera tapatapapaoro. ");
INSERT INTO roo_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Uva oiso rerare puraaepa, “Vosa oiraopato-a vii profetato, oire igei taviri, Irouto vii tapare?” ");
INSERT INTO roo_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Uva Pita ratau pauparoepa kepa kasuraaro sovara-ia osa voa iriavu kovopava rera iare urioopa oiso purasa, “Vii tapo-a ita iravu viigoa oisoa Jisas tapo toupari ro vova Galili.” ");
INSERT INTO roo_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Oa iava Pita oiso puraroepa voea rutu osireiaro-ia, “Easi viapau eva-ia taraiparai osa purapauei.” ");
INSERT INTO roo_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Oire uva Pita kosiro viropa rataoa riaaro iare. Oa iava voa iriavu ita kovopava oiso puraopa rera kekeoro voeao tavioro oea voa toupaiva, “Easi iravu-a ro ira oisoa Jisas tapo toupareve ro vova Nasaret.” ");
INSERT INTO roo_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Oa iava Pita taearoepa ita erao pievira oiso puraoro, “Oiraopavira rutu vavo oiso viara-ia, viapau taraiparai rera-ia eera.” ");
INSERT INTO roo_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Oa iava oearovu ita utupauavi toreoro ita oiso rerare puraaepa, “Oiraopavira rutu. Easi iravu-a ita vii voea iava. Viigoa eveipaio reoa iava vii vaaro.” ");
INSERT INTO roo_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Oire uva ovoiopa reo-ia oiso voeava kaureopaoro oiso puraroepa, “Avoeao! Oiraopavira rutu viapau rera-ia taraiparai eera. Vosa viapau oiraopa reo vai purapaavori, ra va iava Pauto ragai vuri piereve rutu.” Oire oisi reoroiva, kookai gaureva. ");
INSERT INTO roo_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Osa iava Pita vo reore rugooroepa vao oa-ia Jisas rerare oiso puraroepa, “Vo osa kookai gau asavira tourevere, ovusa vo peva purari ragai vaisiaro taeapaoro.” Oa iava kosiro viropa Pita rirovira gaupasa. ");
INSERT INTO roo_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Oire uva avia sikereva ovusa reipa irara pris ora turaro irara voeao vova Isrel ora reopaaepa, oiso ra rera upoive Jisas. ");
INSERT INTO roo_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Oa iava rera tuukeiva iroiro-ia rerava avapaoro rovopatoa iare Pailat Rom gavman iava rera. ");
INSERT INTO roo_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Oire uva rera ro Judas ira Jisas kosi piereva, ira rera-ia voea tuereva osa rera Jisas ivaoiva kopiia-ia. Oa iava rerare vovouisi ora poreepa. Uva oiso vovouparoepa ra silva moni vo peva tau (30) vore piereve voeapa voeao reipa irara pris ora turaro irara. ");
INSERT INTO roo_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Oa iava oiso puraroepa, “Ari ita, ragai vao ragoa vuria puraavo, uvare ro kosi pieavo oirato ira-ia viapau vuria vaiei. Ira ivaoivo kopiia-ia.” Oa iava oiso puraaepa, “Viapau oiso igei vaaro-a. Vii raga vaaro-a vao vuria.” ");
INSERT INTO roo_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Uva va iava Judas monia vikireva Tempel sovara-ia. Uva voava voea arova avaroepa iroiro-ia ora kaasa. ");
INSERT INTO roo_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Oire uva voeao reipa irara pris irara vo moni vao silva ouoro oiso puraaepa, “Oira upo voriaro vao-ia oa-ia viapau uvuipaviei ra vao tapo va takuvupe Tugoropa Kepa-ia tou moni.” ");
INSERT INTO roo_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Oa iava vo moni-ia oreovu goruiva vao. Oa iava iravu vo rasiaro voriiva katai vovou raga-ia, ira oisoa pitoka puraparo. Oire va iava vo rasi ouiva voeaopa tauaipa irara, auere ra voea tovapaive voa. ");
INSERT INTO roo_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Uva oiso vo rasi vaisiiva, Revasi Tova rasi. Oire uva touvira vo vaisiei toupai vo vokio voa. ");
INSERT INTO roo_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Eisi osa oreovu toupaiveira Pauto oreoa purareva profet Jeremaia gisipoaro-ia. Uva oisi-a eisi osa oiraopavira karekeepa vao-ia oa oiso purapai, ‘Vao ouiverea vo peva tau (30) aue silva moni Isrel-pa irara oa reesiiva oiso ra ro voriive oirato. ");
INSERT INTO roo_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ro vo rasiaro vorisa pitoka purapato. Eisi osa ragai tavireva Turaro.’ ");
INSERT INTO roo_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jisas tore pieiva reito gavman osireiaro-ia. Oire uva rera-a eera rovopato gavman ira rera akepareva oiso, “E vii-a Jiu reraaro king, raa?” Uva Jisas oiso puraroepa, “Vii raga ita-a eva viigoa eisi purauei.” ");
INSERT INTO roo_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Oa iava reipa irara pris ora turaro irara rera togapaiva oaravu-ia reoara. Osa viapau oarai pukopareva vo reoro iava. ");
INSERT INTO roo_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Uva va iava Pailat rerare oiso puraroepa, “Easi pasi viapau vo reoro vaio rutu uvupari oara-ia vii togapai?” ");
INSERT INTO roo_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Uva viapau rutu oiso Jisas oreoi aatoreva vo Pailat-pa oreoiaro. Uva va-a eva oa iava ro rovopato gavman tavetave iraopareva. ");
INSERT INTO roo_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Uva vo ivara rutu-ia uva oisoa ro rovopato gavman oiratoa vai kosi piepareve tuukepa kepa iava vo vokia vao oa-ia oisoa Tagausapa Vurei Pasova aiopaive, vo rara oirara rutu irai arepaive. ");
INSERT INTO roo_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Uva vo voki-a vao oa-ia iravu oirato vuritoa rutu toupareva tuukepa kepa-ia rera vaisiaro, Barabas. ");
INSERT INTO roo_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Uva oirara rutu ora guruaepa. Oa iava Pailat oiso voea akereva, “Aa ropa ruipapatai ra visiipa rera kosi piea Barabas eke Jisas ro ira vaisipaiveira oiso, Krais?” ");
INSERT INTO roo_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ari ita, Pailat voeao-ia tarairoepa oiso osa oisoa rera riiriipaive. Oa-a eva oa iava rera kosi pieivora kortua iare. ");
INSERT INTO roo_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pailat paupa-ia pauparoepa vo kepa-ia oa-ia oisoa oirara rovirieipareve. Oire uva voa-a evoa uva toureva ovusa vatuava rerare oavu tavia ava pieeva oiso puraoro, “Viapau oiso uvuipauei ra orekevu avu vai purari eera-ia torevokoto. Vo vokiaro ira kekeavo urusa-ia. Uva riroa rutu sovoavo vavata vo rera kekeoro.” ");
INSERT INTO roo_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Uva voeao reipa irara pris ora voeao turaro irara oearea oirara rutu vovouaro tore pieiva, oiso ra Pailat arepaoro oiso puraave, “Barabas eakaoro Jisas kopii pieri!” ");
INSERT INTO roo_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Oire uva ro rovopato gavman oiso voea akereva ita, “Iroutoapa ruipapatai vaitereo iava, ra rera vorevira eakaa visiipa?” Oa iava oiso puraaepa ita, “Ari Barabas!” ");
INSERT INTO roo_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Oire uva oiso puraroepa Pailat, “Ari apeisi ro piepaavoi Jisas ira vaisipaiveira oiso, Krais?” Oa iava oiso puraaepa raga pieoro, “Rera kotori evao parikou-ia!” ");
INSERT INTO roo_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Uva Pailat oiso voea akereva, “Eake rutupa? Eakea vuri-a oa purarevora?” Osa rirovira rutu raga piepaoro oiso raga purapaaepa oiso, “Rera kotori evao parikou-ia!” ");
INSERT INTO roo_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Uva Pailat ora rera-ia oiso aueroepa, Easi viapau uvuiparai ra oavu vai purasa rera-ia. Teapi riroa rutu karekepe upoa. Eisi osa iava uukoa oureva ora rera iava vavaea sisusa voea rutu osireiaro-ia oiso puraoro, “Viapau vuria vaiei oiso ra oai iava rera upoa. Ari aue oavisii-a visii raga.” ");
INSERT INTO roo_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Oa iava voea rutu oiso puraaepa, “Oa-a eva vuria uvuipai ra va kekepaioverea ora voeao igei aao kakaeroaro!” ");
INSERT INTO roo_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Eisi osa iava Pailat Barabas iava vasereva voeapa. Oire uva Jisas iava vasereva voeapa upo pura irara, oiso ra rera ragi rovopaoro rera tapaive vo evao parikou-ia. ");
INSERT INTO roo_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Oire uva voeao upo pura irara oaro ro Pailat oea Jisas koata pieiva gavman vo kepaaro-ia. Oa iava vo rerare voea rutu voeao upo pura irara ora guruaepa. ");
INSERT INTO roo_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Uva voa rera iava kuvupara veraiva iravu raga tavari pieoro revasito rera reesioro oiso, Vii-a king. ");
INSERT INTO roo_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Uva oavu kukuvaipa puraiva rokarokapa iro iava. Oa iava va tovoiva rera kukuearo-ia. Uva pito isi-ia rera tooro pieiva oisova oirapapa vavae-ia. Oa iava rerare kokoto rekupaoro oiso purapaaepa, “Jiu reraaro king! Vearo voki rutu!” rera tovipaoro. ");
INSERT INTO roo_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Uva rera-ia ruipaaepa. Oire voava vaisi pito isi ouoro rera kukuearo ragiiva vaisi-ia. ");
INSERT INTO roo_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Uva rera tovi rovopaivoiva, kuvupato veraiva rera iava. Uva voava ora rera reraaro-ia kuvupato rera kuvuiva vorevira. Oa iava rerava avaaepa rera tapasa evao parikou-ia. ");
INSERT INTO roo_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Oire uva voa-a vo uva rera tapo avapaaepa. Oa iava voa avapaoro iravu kekeiva oirato Sairini iava, rera vaisiaro, Saimon. Oa iava voa rera aruiva goruvira rutu Jisas vaaro kaesa evao parikou. ");
INSERT INTO roo_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Oa iava uvavu poua viropa opukuivu-ia, va vaisiaro, Golgota. Oa porearo oiso toupaiveira, Kukue Pukui aue iava uvare oiso kekepa piroveira osa kukue keru. ");
INSERT INTO roo_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Uva voa rera vateiva wain ovi va uvereoro oavu tapo itakopa ovi. Oire uva vapa reasiparoepa ukaio arapa, uvare vo gisipo raga-ia vo ovi sovoreva itakovira. ");
INSERT INTO roo_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Oa iava rera tapaiva evao parikou-ia. Uva rera varaaro-ia kuvupara satu visiko purapaiva vara roo piepaoro ora voeapa. ");
INSERT INTO roo_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Uva voa toupaiva rera-ia uutupaoro. ");
INSERT INTO roo_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Vo rera kukuearo isivaaro uva vo reo rigatoiva oreoa-ia rera togaiva tavaa iare. Uva oiso vo reo rigatoiva, KING OAIVE JIU. ");
INSERT INTO roo_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Oire uva voa-a vo uva rera ruvara-ia Jisas aitereivu tapaiva riro kavirutoarei oiso iravu vova oirapapa varata, ari iravu vova koike varata. ");
INSERT INTO roo_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Uva oirara rutu ora riakora voa rera tovipaoro putepaiva rerare kukue pikupikupaoro oiso purapaaepa, ");
INSERT INTO roo_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Vii-a vao Tugoropa Kepa pakopato. Vo peva raga-ia voki vo kepa paupasa vorevira! Oire ora vii avu raga ora tauvau ita, uvare vii-a Pauto Oviitoaaro. Evoava evao parikou-ia rereri!” ");
INSERT INTO roo_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Uva voea tapo voeao reipa irara pris ora turaro irara oea tapo rera akaipa piepaiva oiso purapaoro, ");
INSERT INTO roo_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ari oearovu raga oisoa tauvapareve. Uva viapau uvuipa ra oisi ora rera raga ora tauvaro? E rera ro Isrel reraaro king? Uva eakepa ra evao parikou kavureve, ra va iava rera-ia oiraovio! ");
INSERT INTO roo_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ira ro oisoa Pauto oirao piepareve oiso purapaoro, Ragai-a Pauto Oviitoaaro. Uva eakepa ra Pauto rera tauvareve, vo rara rera-ia vovouparo!” ");
INSERT INTO roo_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Oire uva vaiterei-a vaitereo oira upopatoarei ora kavirupatoarei aiterea tapo kotoiva evao parikourei-ia uva Jisas vuruvuru-ia siva. Ari ita, vaiterei apo akaipavira vo reo raga purapasiva rerare Jisas. ");
INSERT INTO roo_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Oire uva ravireo vuuta-ia ravireo utoroiva, rupa rovoepa vo rasitoa rutu-ia. Uva vo peva rutu-ia vuuta (3 klok) rekasiepa vo rupa. ");
INSERT INTO roo_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Uva vo peva vuuta ruvara-iavi Jisas koikoiroeva oiso puraoro, “Eli, Eli, lema sabaktani?” Oa oiso ragavira porearo toupai, “Pautoa oaa, Pautoa oaa, Eakere ragaivi kavupari?” ");
INSERT INTO roo_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Oa iava voearo oea rera ruvara-ia toupaiva oea rera uvuoro oiso puraaepa, “Easi profetatoare keerapa ro Ilaija.” ");
INSERT INTO roo_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Uva iravu ikaureva pupupua rupu piesa aue-ia uureopa ovi viniga ovi. Oa iava evao rao-ia vo ovi vatepareva rerapa Jisas. Osa oearovu oiso puraaepa, ");
INSERT INTO roo_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","“Tue rovou, ra Ilaija rera rere piesa urio rovoro, pasi.” ");
INSERT INTO roo_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Oire Jisas rirovira koikoioro vovoua vikireva kopii ovoioro. ");
INSERT INTO roo_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Uva vo voki raga-a vao oa-ia riroua varoua vo rataoa-ia touua Pauto vo topisiaro iava oua vo Tugoropa Kepa-ia aue Tempel vuritavira kari piropa vo rutuva viara-ia vo ruture rasiuaaro. Vouao oua kari pirora, oiso ra oirara rutu Pauto ruvara iare tutuu pieive. Ovusa rasito tapo rikerikeroepa. Oa iava riropa avekero tapo poroporo piropa. ");
INSERT INTO roo_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Osa tova urui tapo karu piropa vo uva voeao Pauto voeaaro oea oisoa tovapaive toreaepa tootoooro vorevira. ");
INSERT INTO roo_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Uva voea-a voeao oea tova urui iava toreaepa vo vokio isivaaro iava oa-ia toreroepa Jisas. Oa iava voea rutu karea viropa Tugoropa Urui iare Jerusalem. Osa iava voa voea rutu kekeiva oearovu. ");
INSERT INTO roo_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Uva voa reito oaive tapo viurupa irara toupaiva Jisas-re uutupaoro. Uva vao kekeiva osa rasito rikerikeroepa ora orekerovu rutu varao oara rutu karekeepa. Oara rutu kekeoro rirovira rutu uriripaaepa. Oa iava oiso puraaepa, “Oiraopavira rutu rera ro Pauto Oviitoaaro!” ");
INSERT INTO roo_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Voa riro riako toupaiva vairo airoa Jisas sirova utuaepa Galili-ia kavuoro rera tauvapaoro. Uva vairo-a evairo airoa tauaivi torepaoro rera siituepaiva ");
INSERT INTO roo_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","oiso-ia, iriavu-a o-ia Maria Makdala iava, ora iriavu ita Maria, Jems araorei aakoaro ora Josep. O tapo Sebedi oviitoareiaro aakoaro, ora airorovu tapo. ");
INSERT INTO roo_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Uva vo ovaiarovi iravu Arimatia iava rera riro monito, rera vaisiaro, Josep ira urioroepa. Uvare iravu Jisas disaipeltoaaro rera-a. ");
INSERT INTO roo_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ira Pailat-ia pouro viropa Jisas kopiire rera aresa. Oa iava Pailat rera voeaaro tavireva, “Vo kopii vatesa rerapa.” ");
INSERT INTO roo_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Uva Josep vo kopii oureva rera tavurusa airepa-ia varoa popotea. ");
INSERT INTO roo_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Oa iava rera tovoreva aveke rikui-ia rera vaaro oa ravaavira teka ragaiva iriavu-ia aveke. Uva vo rikui iare iriavu rirova aveke perireva vo riku riaaro ivitasa oira-ia. ");
INSERT INTO roo_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ovusa Maria vaio o Makdala iava ora iriavu Maria airea paupaereiepa vo tova ruvara-ia. ");
INSERT INTO roo_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Uva aio ravaapa voki putevoiva vao Sabat iare. Oa iava vo voki isivaaro iava avaaepa reipa irara pris voearei ora Farisi oearea rutu ora guruaepa rera ruvara-ia Pailat. ");
INSERT INTO roo_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Oire uva voa oiso puraaepa rerare, “Oreovu vao-ia oare rugooiei Jisas vo reoaro. Oa-ia oiso puraroepa rera ro riro kuuvuto, Vo pevapa voki isivaaro iava vorevira toreravere, vo osa touvira toupareva vo. ");
INSERT INTO roo_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Uva eisi osa iava vii rugoo piepaiovoi, ra taviu va iava. Oire ra vii voeaaro upo purapa irara tovori vo tova-ia uutupasa vo peva rutu-ia voki. Auepa teapi rera voeaaro disaipel rera kavirusa urioave, ra oirara rutu tavitaviive va iava kuuvuvira oiso, Vorevira toreroe tova urui iava. Teapi vo kuuvuo-ia rovopa puteve vo kuuvuo utupa.” ");
INSERT INTO roo_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Oa iava Pailat oiso voea tavireva, “Oire uutupa irara vai tavita, ra avata avukivira rutu vo tova rukusa oiso osa ruipapatai.” ");
INSERT INTO roo_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Uva va iava avaaepa vo tova-ia uutupasa. Oa iava pisikui reesivira tovoiva o ivara-ia aveke iria taku pievira tovoiva vo tova-ia. Oisore ra va-ia oovaupaave auepa teapi irai vo tova kavirureve. ");
INSERT INTO roo_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Oire uva Sabat voki topekakao vo putevoiva, ravireo sikerereva vo vokio iava wiki-ia vituaro vo voki. Oa iava vaireo urioereiepa Maria Makdala ora o iriavu Maria vo tova kekesa. ");
INSERT INTO roo_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Vo osa rasito ravurike ovoiroepa rirovira rutu. Uva Turaro reraaro purapurapato ensel vuvuiua iava vararoepa aveke vera ovoisa oira peka pieoro. Oa iava voava oira ivara-ia pauparoepa. ");
INSERT INTO roo_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Uva rera iava varaua rutu sisikorepaiva aviavipaoro. Ora varoa kuvupara rera iava oisi raga popotevira rutu toupaoro roropaiva. Viapau oiso oai aviaviaro uvuipa ra rera vo aviaviaro-ia puteve. ");
INSERT INTO roo_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Uva va-a vao oa iava voeao uutupa irara rirovira rutu rope kopii puraiva rirovira rutu uriripaoro. Uva oiso paaepa rutu, Voeapa kopiipai. ");
INSERT INTO roo_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Oa iava enselpato Maria vaiore oiso puraroepa, “Teapi uriripaere. Taraiparai vei-ia veigoa urioereie Jisas-re vurasa ro ira kotoivorao evao parikou-ia. ");
INSERT INTO roo_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Viapau oiso vo touparevoi. Ira toreroi vorevira oiso osa puraroera voviri. Ari ita, urioereiei vo tavukio raga kekesa uva toupaivo vo kopii. ");
INSERT INTO roo_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ra ikauvira voreere disaipel irara tavisa oiso, Vorevira toreroe tova iava. Ira visiipa iraroi Galili iare. Rera kekesa utupatai. Uva vo reo-a vao ragai vo reoaro oa vateavoi veipa oare rugoopaerevere.” Oiso osa puraroepa enselto. ");
INSERT INTO roo_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Oa iava vairei riakorirei rirovira rutu uriripaereiepa ora rirovira tapo rorupaereva. Uva ikauvira rikui raga ruvara iava avaereiepa disaipel tavisa. ");
INSERT INTO roo_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Uva voa-a vo uva Jisas vairei iare pouro viropa raivaaro. Oa iava vairei kekeoro oiso puraroepa, “Vearo voki rutu.” Oa iava rera iare tutuu pieereva rerapa avivikepaoro rera kokotoaro-ia pitusa. Uva rera-ia vuurapa vaisi puraereva. ");
INSERT INTO roo_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Oire uva Jisas vaireire oiso puraroepa, “Opeita uriripaere. Avaere araoko irara oaa tavisa, ra Galili iare avaave uva ragai kekeivere.” ");
INSERT INTO roo_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Oire touvira avapaereiepa osa oearovu voea iava vo tova-ia uutupa irara karea viropa vo Jerusalem urui iare reipa irara pris tavitavisa varao rutu iava orekerovu oara karekeepa voa. ");
INSERT INTO roo_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Uva va-a vao oa iava voea rutu ora guruaepa pris irara ora turaro irara. Oire vo pau-a vao oa-ia oavu reoa goruiva. Oa iava riroa monia vateiva voeaopa vo tova-ia uutupa irara ");
INSERT INTO roo_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","oiso voea vosipaoro, “Teapi eisi tavitavipatavere. Ari oiso raga purapatavere, Rera voeaaro disaipel urioae voava rera kavirusa osa uusivira touiovo. ");
INSERT INTO roo_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ari ita, vosa rovopato gavman vo reo iava vao uvurevere, oire ra rera vovouaro poreio. Ra va iava viapau visii-ia vuria vai karekepe.” ");
INSERT INTO roo_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Uva eisi osa iava monia-ia pituoro voea vo reoaro sirova utuaepa. Oa iava oisi raga vo reo sikataiva Juda taere iare. Oa iava oisi va purapaivoi vo vokio-ia tapo. ");
INSERT INTO roo_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Vo katai tau katai (11) disaipel irara vokapaoro avaaepa Galili iare. Oa iava vo pukuio-ia poua viropa oare Jisas voea tavireva oiso ra voare avaave. ");
INSERT INTO roo_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Uva voa-a vo uva rera kekeiva Jisas. Oa iava rera-ia vuurapa vaisi puraiva. Ari ita, vosa oearovu voea iava viapau oiso rera oirao piepaiva. ");
INSERT INTO roo_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Oa iava Jisas voea iare tutuu piereva. Oire voava voea tavireva oiso, “Pauto vo goruro rutu vuvuiua iava ora vo rasito vatereva ragaipa. ");
INSERT INTO roo_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Oiso osa iava uvuipatai ra oirara rutu vo rasitoa-ia disaipel pieta ragai voeaaro. Voea baptaisoro voea reesita Aite vaisiaro-ia, ora Oviito, ora Tugoropato Uraurato. ");
INSERT INTO roo_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Rara voea siposipopata vo reoro rutu iava oara vateavora visiipa. Oire ra vearovira rutu vara sirova utupaave. Ragai uvu iraopata! Ragoa visii tavipaa oiraopavira rutu oiso, Visii tapo toupaaverea vokiara rutu-ia vo tugurasa vo rasio vo vuutaaro opesiaro-ia.” ");
INSERT INTO roo_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Rovoaro Vearo Siposipo Jisas Krais iava, Pauto Oviitoaaro. ");
INSERT INTO roo_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Oa iava oiso va rigatoreva profetato ro reo topa piepato, Aisaia. Oreoa oiso purapai, ‘Uvuri. Ro iava ira ira pieavoi vii iare reo kaepato. Ira raiva oara vatatopoparevere va ravaaoro viipa.’ ");
INSERT INTO roo_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","‘Iravu ira keeraparoi vo raaka tapi oiso purapa, Turaro vo raivaaro vatatopopata va ravaaoro oa-ia pouro viroverea.’ ");
INSERT INTO roo_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Uva vo reo-a vao oirao pieoro karero viropa Jon baptais vatepato vo raaka tapi. Uva voeapa siposipopareva Jon, oiso ra porea viro ra baptaisa ouive, vo rara Pauto voea iava vuriara verareve. ");
INSERT INTO roo_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Uva voea rutu avaaepa rera iare voea rutu voeao vova Judia taere ora vova riro urui Jerusalem. Uva vuriara oaive kosi piepaoro vo vuuta raga-ia baptaisa ouiva Jon ruvara-ia vo uukova Jodan. ");
INSERT INTO roo_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Uva Jon aue kamel oruaro iava oisoa rera-ia oiso kuvuparo kuvupato, ora takipa iro bulmakau rakari. Uva rera vo aioaro-a vao-ia siiko ora koisi. ");
INSERT INTO roo_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Uva oisi siposipopareva, “Ro ira utuparoi ira ragaipa reipa. Uva viapau uvuipara ra rerapa akaipa kovo vai pura ragaa, oiso osa vao rera vaaro tasipa oa-ia viapau uvuiparai ra va akaipavira vera ragaa. ");
INSERT INTO roo_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Uva visii baptaispaavoi aue-ia uukoa. Ari rera visii baptaisrevere Tugoropato Uraurato vo goruaro-ia visii reesipaoro rutu. ");
INSERT INTO roo_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ovuuta-a eva isivaaro iava Jisas Nasaret iava Galili-ia urioroepa. Oa iava Jon rera baptaisreva vo Jodan sir. ");
INSERT INTO roo_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Oa iava veraro viropa voava uukova sirova. Uva voava vuvuiua kekereva osa karu piropa. Uva Tugoropato Uraurato oiso vararoepa osa kurue rera-ia pitusa. ");
INSERT INTO roo_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Uva reoreoa varaepa vuvuiua iava oa oiso puraepa, “Vii-a ragai Oviitoaaro rutu. Viigoa-ia roru iraopaavoi rutu vii kavikopaoro.” ");
INSERT INTO roo_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Uva ikauvira Tugoropato Uraurato rerava avaroepa raaka tapire vo uva viapau oirara vai. ");
INSERT INTO roo_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Uva voa toureva aue-ia vo resura tau (40) voki, osa Seten voa rera-ia kokara ragaparoepa. Uva okarerovu rutu tapo toupareva vavarai kare, osa enselpa irara voa rera tokipaiva. ");
INSERT INTO roo_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Oire uva Jon tovoiva vo tuukepa kepa-ia. Oa isivaaro-ia Jisas urioroepa vore Galili. Uva voa siposipopareva Pauto vaaro iava Vearo Siposipo. ");
INSERT INTO roo_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Uva oiso puraroepa, “Vo vuuta vao-ia oa pou piroi oapa tutuu piei ra karekepe vo vuutao iare oa-ia Pauto ora rera vo Saraaro tokirevere. Poreta viro, ra Vearo Siposipo oirao pieta.” ");
INSERT INTO roo_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jisas Galili rovu vatuaro-ia vokareva. Uva Saimon vaio kekereva vaiterei ora Andru vo araorei, ovusa varuerepasiepa. Uvare vaiterei-a pakupatoarei moni oupasa. ");
INSERT INTO roo_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Uva Jisas vaitereire oiso puraroepa, “Ragai sirova utusi, ra vei siposipoa oira ivupasa ragai iare.” ");
INSERT INTO roo_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Oa iava ikauvira raga kuverava kavusiva rera sirova utuoro. ");
INSERT INTO roo_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Uva oisivi vokaoro Jems-ia pouro viropa Sebedi oviitoaaro vo araorei ora Jon, vo osa uvuoa-ia kuverava murupaoro toupasiva. ");
INSERT INTO roo_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Uva vaitereire keeraroepa. Oa iava Sebedi aiteto kavusiva uvuoa-ia ora kovopa irara utupaoro rera sirova. ");
INSERT INTO roo_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Uva Kapaneam-ia karea viropa. Uva voa-a vo uva Sabat Voki-ia Reo Taisi Uvupa Kepa-ia Sinagog koataroepa. Uva voa oirarapa siposiporeva. ");
INSERT INTO roo_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Oa iava rera vo siposipoaro-ia tavetaveiva, uvare rera vo reoaro-ia gorua toupaiva. Viapau oiso rera-a osa voeao oea Reo Taisi iava siposipopaiveira. ");
INSERT INTO roo_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Uva voa toureva Sinagog sovara-ia evoa uva toupareva iravu oirato ira-ia oiso toupareve tugarato. ");
INSERT INTO roo_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Uva-a vo uva oirato iava tugarato oiveoro oiso puraroepa, “Eake vai purari igeire vii Jisas vova Nasaret? Vii uriouei igei opesi ovoi piesa, eke? Ari ita, taraiparai vii-ia. Vii-a Torevokotoa rutu vova Pauto.” ");
INSERT INTO roo_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Uva Jisas rerare koruoro oiso puraroepa, “Ora tape pieu, ra eera arova kosiu viro.” ");
INSERT INTO roo_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Oa iava voea tugara rera-ia taketokoaepa rera rikerike pieoro, osa rirovira oiveroiva, rera iava kosia viropa. ");
INSERT INTO roo_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Uva voea rutu tavetaveiva. Oa iava voea raga ora akeakepaaepa oiso, “Eake irao vao-ia? E airepa siposipo-a oa karekei vo goruova oa iava tugara rera uvui?” ");
INSERT INTO roo_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Osa iava ikauvira rera iava vo siposipo viriva voraro rutu vo Galili taerero sovara-ia. ");
INSERT INTO roo_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Uva Jisas tapo kosia viroiva Sinagog iava. Oa iava koataaepa voeao disaipel ora Jems vaio ora Jon, vo kepa-ia Saimon vaio vo kepaaro ora Andru. ");
INSERT INTO roo_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Uva-a vo uva Saimon aigevaaro kukue upia puraiva. Oa iava oira iava Jisas taviiva. ");
INSERT INTO roo_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Uva avaroepa oira-ia pitusa vavaea-ia oira tore pieoro. Oa iava kukue upia oira kavu ovoiva. Oa iava voeapa aioara vatatopo ovoieva. ");
INSERT INTO roo_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Uva vo ovaiarovi ravireo ovusa rokoreva uva rera iare oearovu upiapa irara siposa urioaepa, ora oearovu tugara upo irara. ");
INSERT INTO roo_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Oirara rutu voeao vo uruio iava vao riroa oea vo uvuruaro kepa rataoaro tupaiva. ");
INSERT INTO roo_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Uva-a vo uva oirara iava oupirovu rutu ruvarureva, ora oearovu oearoa iava vuri tugararo kosi piereva. Uva tugarare koruroepa oiso ra ora tape pieave, uvare rera-ia taraipaaepa. ");
INSERT INTO roo_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Vo vokipakou rutu-ia Jisas toreroepa. Oa iava voava kosi virooro avaroepa varirisa kuvau tapi. ");
INSERT INTO roo_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Uva Saimon vase ora voeao oea rera tapo vokapaiva oea rerare taraapaoro utupaaepa. ");
INSERT INTO roo_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Oa ava rera kekeoro rera taviiva oiso, “Oirara rutu viire taraapaivoi. ");
INSERT INTO roo_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Oa iava voeare oiso puraroepa, “Irata. Ra voraro tutuu pievira ourui iare avavio, ra oa-ia voa siposipoa vao iava oa vituaro rutu iava vore urioraera.” ");
INSERT INTO roo_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Uva oiso ragavira avaaepa Galili-ia. Uva voa siposiporeva Sinagog sovara-ia Jiu vaaro, ora tugara kosi pie tapo purareva voraro rutu vo Galili taerero sovara-ia. ");
INSERT INTO roo_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Uva rera iare Jisas urioroepa iravu ira-ia oisoa lepra upia toupaive. Ira rera areoro rerare rekureva oiso puraoro, “Vosa apeisi vovoupau ra ragaivi porete pieri.” ");
INSERT INTO roo_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Uva Jisas rerapa siraoroepa rutu. Oa iava rera-ia pitureva vavaea tovooro. Uva rera tavireva oiso, “Ruipaparai ra sisigarueu.” ");
INSERT INTO roo_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Uva va-a eva lepra upia rera kavuva. Oa iava vearoroepa. ");
INSERT INTO roo_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Uva goruvira rera vosipareva rera arupaoro. ");
INSERT INTO roo_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Osa iava rerare oiso puraroepa, “Opeita irai taviparivere. Viapau. Ari varaua oara karekesa avapau pris irarapa. Ra tauoa vai purari oiso osa va iava visii taviva Moses vo rigatoaro. Oire ra oearovu rutu taraiavere oiso, Upia rutu vii iava opesiei.” ");
INSERT INTO roo_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ari ita, avaroepa voraro rutu siposipopaoro. Osa-a eisi vituaro iava Jisas viapau uvuiparoepa ra avaro ouruirovu iare. Ari ratauro raga toupareva kuvau tapiro-ia. Osa iava rera iare urioaepa oirara vova voraro rutu. ");
INSERT INTO roo_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Uva ovokirovu isivaaro iava vo Kapaneam-ia pouro viropa. Uva voa rera iava tavia avaepa vo osa kepa sovara-ia toupareva voa. ");
INSERT INTO roo_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Uva riro irara rutu ora guruiva, agasiepa. Uva viapau oiso oavi viapaa vai touva vo kepa rataoaro-ia. Uva-a vo uva voeapa siposiporeva va iava vao Vearo Siposipo. ");
INSERT INTO roo_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Uva oresuravu iravuva kerauto kaepaoro urioaepa. ");
INSERT INTO roo_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ari ita, viapau uvuiaepa vo kaeva koatasa, uvare riroa ita uvurua. Osa iava kepa kukuuvuaro tokoiva Jisas aivarova. Oa iava vo kae vara pieiva. ");
INSERT INTO roo_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Uva Jisas voea varaaro oirao pie vovouro kekereva. Oa iava kerautore oiso puraroepa, “Oviitoa oaa. Vii vaaro vuria verapi.” ");
INSERT INTO roo_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Vo osa oearovu voavi paupaaepa Reo Taisi-ia tarai irara, oea oiso ora rugorugoo piepaaepa ora voea raga vovouaro-ia. ");
INSERT INTO roo_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Eake vituaro iava eisi puraroi rera ro-ia? Ira Pauto toviparevoi rera reroaropaoro. Irou vai uvuipai vuriara verapasa. Easi Pautoa raga. ");
INSERT INTO roo_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Uva Jisas voea sovoreva ora rera iava sopaua-ia. Oa iava voea oiso akereva, “Eakere eisi ragaire vurivira rugorugoopatai ora visii raga sopaaro-ia? ");
INSERT INTO roo_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","E aa vo reo irao-a oa avekatapai rutu ragaipa, ra va-ia oiso purara, Vuriara oara verapi, eke oiso, Toreu ra urua vii vaaro kaeri, ra vava kareu vokapaoro? ");
INSERT INTO roo_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ari ita, ragai-ia taraipatai ragoa ro arua oiso, Urua kaeri ra vava kareu vokapaoro, auere ra va kekepaoro oiso purapata ragai iavirava, Oirato Oviitoaaro Ro Ropoto vo goruaro vao-ia oiraopa. Oa vao uvuipai vuriara verapasa oirara iava voeao vo rasitoa-ia tou irara.” ");
INSERT INTO roo_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Oire kerauto tavireva oiso, “Vii tavipaavoi, Toreu, ra urua oara kaeoro ra kareu vii vo kepaaro iare.” ");
INSERT INTO roo_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Uva tore ovoiroepa urua oaro kaesa. Uva kareroepa ora karekesa voeare. Oa iava rera-ia tavetavepaiva. Uva Pautoa-ia vuurapa vaisi puraiva oiso puraoro, “Viapau oiso oai kekeiova oiso-ia.” ");
INSERT INTO roo_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Uva vorevira pouro viropa toko rovu rogaraaro-ia. Uva riro irara rutu oirara ora guruaepa voa rera iare. Oa iava voa voeapa siposiporeva. ");
INSERT INTO roo_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Uva Jisas voava avapaoro Livai kekereva, Alfias oviitoaaro, vo osa vo pauparoepa takis oupa kepa-ia moni vikipa tapi. Uva rera tavireva oiso, “Ragai sirova utuu.” Oa iava toreoro rera sirova utu ovoiroepa. ");
INSERT INTO roo_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Uva aiosa avaroepa Jisas voavi pauoro Livai vo kepaaro-ia. Uva riro irara voeao moni oupa irara ora voeao vuri vovou irara, oea tapo toupareva, ora disaipel irara voeao rera voeaaro. Aue iava uvare riro irara rutu rerare utupaaepa. ");
INSERT INTO roo_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Uva voeao Reo Taisi-ia taraipa irara Farisi iava voea oea rera tueiva osa vuri vovou irara tapo aiopareva ora takis oupa irara. Uva voea disaipel akeiva, “Uva apeisi moni oupa irara tapo aiopare ora vuri vovou irara?” ");
INSERT INTO roo_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Uva Jisas va uvureva. Oa iava oiso puraroepa voeare, “Voeao upia asa irara viapau oiso ra avapaave ruvarupatoa iare. Viapau. Ari voeao raga vuri vara irara. Ari ita, voeare torevoko vovou irara viapau oiso keerasa urioraera. Ari voeao-a vuri vovou irara, oiso ra vuriara oaive iava porea viro.” ");
INSERT INTO roo_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Uva Jon voeaaro disaipel ora Farisi urioaepa voeao aio kavu irara. Oa iava oeavu Jisas akeiva oiso puraoro, “Uva apeisi Jon voeaaro disaipel voearei ora Farisi voeaaro aio kavupai, oiso ra vearovira lotu purapaive, vo osa vii voeaaro disaipel viapau oiso aio kavupaaveira?” ");
INSERT INTO roo_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Uva Jisas voea akereva, “E vosa voeao oea saratoaaro riakoparo, oea uvuipaai ra aio kavuave rera tapo touoro, eke? Asi viapau, uvare toupare voea tapo. ");
INSERT INTO roo_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ari ita, ovokivu oa uriopere oa-ia ora voea iava rera veraivere vo osa riako ouro. Oire evo voki oa-ia oiso aio kavuavere siraopaoro.” ");
INSERT INTO roo_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Uva vo reo-a vao oa iava oiso puraroepa, “Viapau rutu irai uvuiparoi ra ruta vai ora airepa varoa vai taporeve. Vosa oisi piereve, ra ita ruta karikari piro airepa arova. Ra karia ita riro iraope. ");
INSERT INTO roo_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Oire vosa airepa ovi wain ovi ora riro piepe, ra viapau rutu irai uvuiparoi ra va vao airepa ovi wain ovi kuvureve ruta tou-ia aue iava meme rakariaro, auepa uvare tuakaka. Vosa oisi va piereve ra poko piro vo oviva, ra va iava vuri ovoipe. Ari vosa airepa ovi raga kuvureve airepa tou-ia, ra oriruvira toupaive.” ");
INSERT INTO roo_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Uva poua viropa kukara kovo-ia Sabat voki-ia. Uva rera voeaaro disaipel kukara tuepaoro rovoaepa vo kovo sovara-ia vokapaoro. ");
INSERT INTO roo_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Uva rerare oiso puraaepa Farisi, “Kekeri. Uva apeisi iava oiso piepai Sabat voki-ia oa-ia viapau uvuipaai, uvare Reo Taisi putepaivoi?” ");
INSERT INTO roo_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Oa iava voea akereva Jisas, “E viapau va vieipataveira vao iava osa piereva Devit tuariri rutu, ira ogoevira toureva ora voeaovio oea tapo toupareva? ");
INSERT INTO roo_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Oa-ia ita koataroepa Pauto vo kepaaro-ia vo vuutao-ia oa-ia Abaiata prisparoepa. Uva bret aioreva vao oa-ia viapau uvuipa akukutoa vai ra va aioreve. Va vao bret oa oisoa vatepaive Pautoa-pa ra va kekepareve. Pris irara raga uvuipaai va aiopasa. Uva rera voeao vatereva oea tapo oisoa toupareve?” ");
INSERT INTO roo_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Uva voea tavireva, “Sabat voki oirato tauvapasa pura piropa. Viapau oiso oirato puraro viropa Sabat vokipa oiso ra rera tokipaive. ");
INSERT INTO roo_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Easi Oirato Oviitoaaro raga ira uvuiparoi vo oirara rutu vo pitupituroaro rovirieipasa varao opitupituroa purapaiveira vo Sabat voki-ia.” ");
INSERT INTO roo_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Uva voava ita vo ovokivu-ia uva vorevira koataroepa Reo Taisi Uvupa Kepa-ia Jiu vaaro, osa voa toupareva iravu oirato kopii vavaeto. ");
INSERT INTO roo_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Uva rera-ia siituepaaepa oiso vosa rera porete piereve vo Sabat voki-ia, ra rera iava gasiive oai iava. ");
INSERT INTO roo_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Uva rera pakoeto tavireva, “Toreu ra uriou vore.” ");
INSERT INTO roo_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Oa iava voea akereva Reo Taisi iava oiso puraoro, “Apeisi torevokopai vao Sabat voki vearoa purapasa, eke vuria purapasa? Oira porete piepasa, eke oira upopasa?” Oa iava ora tape pieaepa ita. ");
INSERT INTO roo_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Uva kasipuvira poreroepa voeare, uvare voea iava sopaura vavagisipaepa. Oa-a vao oa iava rerare vovouisi vavataepa. Uva rera pakoeto tavireva, “Vavaea irairari va torevokooro.” Uva va irairareva. Oa iava rerare vavaea vearo ovoiepa. ");
INSERT INTO roo_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Uva Farisi ora reosa avaaepa voeao tapo King Herot tauvapa irara oiso, “Apeisi vai iava rera upope?” ");
INSERT INTO roo_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jisas rera voeaaro tapo disaipel vararoepa vore toko rovu. Oa iava voeareo vova Galili-ia ora Judia-ia oearea rutu rera sirova utupaaepa. ");
INSERT INTO roo_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ora voeao Jerusalem iava ora vova Idumia, ora vova ivirovira Jodan ora voeao Taia-ia vatuaro ora Saidon-ia. Ogururoa rutu-a voeao oea rera iare urioaepa, uvare riro-a Jisas vo kovoaro oa iava uvuiva. ");
INSERT INTO roo_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Osa iava voea tavireva disaipel irara oaro, oiso ra uvuoa vai ravaaive. Teapi oirara urioave ra rera tavuruoro ora guruave. ");
INSERT INTO roo_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Uvare voa riro irara rutu porete pie rovorevoiva, oearovu oupiarovuva vo uvuru ugapaoro koatapaaepa Jisas-ia rirupasa. ");
INSERT INTO roo_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Uva tugarapa irara rera kekeiva. Oa iava rerare takua viropa oiveoro oiso puraoro, “Vii-a Pauto Oviitoaaro.” ");
INSERT INTO roo_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Oa-a eva oa iava voea vosireva riro goruvira oiso puraoro, “Opeita ragai iava tavipatavere poeravira.” ");
INSERT INTO roo_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Uva Jisas iparoepa pukuia-ia, uvare oiso ruipaparoepa ra oeai reesireve. Oa iava voeare voeao keeraroepa. ");
INSERT INTO roo_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Uva katai tau erao (12) roporeva oiso ra rera tapo toupaive. Oa iava voea vaisireva oiso, Aposel irara. Ra va iava voea siporeve oearovu rutupa siposipopasa. ");
INSERT INTO roo_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Uva gorua voeapa karoporeva vaore, oiso ra va iava tugara kosi piepaive. ");
INSERT INTO roo_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Voea-a voeao katai tau erao oiso, Saimon-a ro ira-ia vo vaisio tovoreva, Pita. ");
INSERT INTO roo_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ora Jems Sebedi oviitoareiaro ora Jon, vo araorei vaisireva oiso, Boanesis. Va vituaro iava uvare riro varakeo reotoarei-a. ");
INSERT INTO roo_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andru ora Filip, ora Batolomyu, ora Matyu, ora Tomas. Jems oviitoaaro Alfias ora Tadias ora Saimon Selot. ");
INSERT INTO roo_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Ora Judas Iskariot, ro ira Jisas kosi piereva keripa irara vavaearo iare. ");
INSERT INTO roo_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Oire uva Jisas kepa-ia koataroepa. Oa iava voa rera iare vorevira ita ora guruaepa oirara rutu. Osa-a eisi osa iava viapau uvuiaepa oiso ra aioive, uvare riro uvuru rutu-a. ");
INSERT INTO roo_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Uva Jisas sara iraraaro va iava vao uvuiva. Osa iava urioaepa rera ou piesa, uvare oeavu oirara oiso puraaepa, “Easi ro kokoropa.” ");
INSERT INTO roo_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Uva voea Reo Taisi-ia tarai irara urioaepa Jerusalem iava varaoro. Uva oiso puraaepa, “Ira-ia pouparo viroveira tugarapa reipato rera vaisiaro, Bielsebul. Ira vo goruaro iavirava tugara kosi piepareveira.” ");
INSERT INTO roo_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Oa iava Jisas voeare keeraroepa ruu reo purasa voeapa oiso, “Apeisi ragavira ra Seten uvuipa ra ora siguro? ");
INSERT INTO roo_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Vosa osarai ora aveavepaave, ra viapau vearovira toupaive. ");
INSERT INTO roo_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ora vosa oaaoi ora sikaave katai kepa vai ora upooro, uva viapau uvuipaai ra oisi iava vearovira touive. ");
INSERT INTO roo_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ra vosa Seten ora vuri pieparo, ra viapau goruvira toupareve. Ra rera vo saraaro toko ovoi piro, ra oisi iava opesi ovoiro.” ");
INSERT INTO roo_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Uva vo reo-a vao oa-ia oiso puraroepa, “Viapau irai uvuipa ra koata ragaro vo goruto vo kepaaro-ia rera varaaro kavirusa. Ari vosa rera tuuke rovoreve iroiro-ia ro goruto, oire ra rera varaaro kavirureve. ");
INSERT INTO roo_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Oiraopavira rutu visii tavipaa oiso, Pauto vuriara rutu verarevere ora orekerovu varao takau reoro varao oara purapaiveira oirara. ");
INSERT INTO roo_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ari vosa ro ira Tugoropato Uraurato takaupareve rera akaipa piepaoro, eva-a oa-ia viapau Pauto uvuipa ra va verareve rera iava va vao vuria oaro. Oa touvira rera vuri piepaiverea vokiara rutu-ia.” ");
INSERT INTO roo_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Uva Jisas oiso puraroepa uvare oearovu oiso purapaaepa, “Ira sopaaro-ia ro tugarato touparevoi.” ");
INSERT INTO roo_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Uva aakova ora araoko irara oavaoa karea viropa ratau tousa uvava aruaepa rerare, oiso ra vo avao iare urioro. ");
INSERT INTO roo_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ari ita, riro uvuru rutu Jisas tavurupaiva. Uva rera taviiva oiso puraoro, “Kekeri. Aakoara ora vii araoko iraraaro oavaoa oiso torepaai ratau. Oea vii kekesa auepaai.” ");
INSERT INTO roo_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Oa iava voea vo reoaro pukooro oiso voea akereva, “Irouva aako ora irou irara araoko irara oaa?” ");
INSERT INTO roo_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Uva ora poreroepa voea iare oea rera tapo toupaiva voeare oiso purasa, “Visii-a aakoa vase ora visii-a vao ragai araoko iraraaro. ");
INSERT INTO roo_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Uvare ro ira Pauto vo vovouaro sirova utuparo, ira ita-a eera araokotoa oaa ora taataava oaa ora aako.” ");
INSERT INTO roo_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Uva vorerivira ita voea siposipopaoro rovoroepa vo toko rovu-ia Galili-ia. Uva riro uruiro rera tavuruiva. Oa iava kaero viropa uvuo-ia voa pausa, osa toko rovu ivara-ia toupaeva. Uva va-ia pauroepa ovusa vo uvuru rogaraua-ia toupaiva. ");
INSERT INTO roo_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Uva voava voea siposiporeva riroara rutu-ia ovoovo reoro oara-ia oiso puraroepa voeare, ");
INSERT INTO roo_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Uvuta. Iravu oirato avaroera wit koko vikisa varuparo. ");
INSERT INTO roo_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Uva vara vikiparevora osa oaravu vo kovepaera raivaaro. Uva kokio kare vara aiopasa uriopaaera. ");
INSERT INTO roo_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ovusa oaravu avekepa tapiro kovepaera vo uva viapau rirovira toupaive rasia vai vearoa vai. Oa iava ikauvira raga kova ovoiera. ");
INSERT INTO roo_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Uva ita, ravireo kaero viro vara raverave piesa vara erako pieoro. Aue-ia ita uvare viapau vavurupatoa vai ita. Oa iava raveraveera. ");
INSERT INTO roo_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ari oaravu kovepaera kokopa kouro sovara-ia varao rokarokapara. Uva kokopa kou varare tavuruoro riroera. Oa iava viapau kueera ita. ");
INSERT INTO roo_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ari oaravu koveera vearo rasi-ia. Oa iava vearovira raga kovaera. Uva vearovira kueera rirovira. Oaravu aue-ia uvuipaera peva tau (30), ari oaravu aue-ia katai vatara tau (60), ari oaravu aue-ia uvuipaera katai vovoto (100).” ");
INSERT INTO roo_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Uva oiso puraroepa, “Vosa irai-ia kokitoa vai karuvira toupareve, vearopai ra va uvureve, uvare uvupatoa ita kokito.” ");
INSERT INTO roo_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Uva oearovu oirara Jisas arova kareaepa ora katai tau erao (12) disaipel. Ora oearovu oea rera tapo toupaiva, oea rera akeiva vo reoro porearore varao ovoovo reoro. ");
INSERT INTO roo_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Oa iava voea raga tavireva oiso, “Vo reo vao oa vataupai, oa vituaro iava visii tavirevora Pauto ora rera vo Saraaro iava. Ari ita, voeao oea ratauvira toupaiveira ragai vo vovouaropa, oeapa vo siposipo puraavoi ovoovovira. ");
INSERT INTO roo_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ari ita, ‘Vura ragapaivo osa viapau vo reo vituaro eveipaivo. Ora va uru pie ragapaivo osa viapau va-ia taraipai oisopa, Teapi porea viro ra vuriara oaive vera piro voea iava.’” ");
INSERT INTO roo_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Uva Jisas voea tavireva, “Vosa viapau vao-ia taraipata ovoovo reo, uva apeisi ragavira oreorovu-ia taraipatavere ovoovo reoro? ");
INSERT INTO roo_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Wit koko vikivikipato ira oiso toupare osa ro ira Pauto vo reoaro paupare. ");
INSERT INTO roo_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Uva varao oara kovepai raiva-ia, uva evoa ora paupai reoa. Ovusa uvupaive ra Seten ita urio ovoiro vo reo kaviru ovoisa vao oa oisoa voea sopaaro-ia toupave. ");
INSERT INTO roo_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ari varao oara ora paupape avekepa tapiro oa oiso toupai, Oea-a vo reo uvuivoi. Oa iava va ou ovoivoi roruvira raga. ");
INSERT INTO roo_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Vo osa viapau ikopitoa vai va-ia, vo osa ovurirovu rutu sasararo pou piro vare vao Pauto vo reoaro. Oire ra va iava ikauvira vo reo kavuive. ");
INSERT INTO roo_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ari oearovu oiso toupai, Oea vuutaaro-ia wit koko kovepai rokarokapa kou sovara-ia. Evoea ita oea vo reo uvuivoi. ");
INSERT INTO roo_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ari ita, rirovira rutu rugorugoopaai varao ruture vo rasio iava vara, uvare oiso rugoopaai ra riroara vai rutu gurupaive moniara vai ora orekerovu rutu riiriipaive. Oara rutu evara oara Pauto vo reoaro tavurupaiveira. Eisi osa vituaro iava viapau vo reo eva kuea vai voea sopaaro-ia. ");
INSERT INTO roo_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ari ita, oearovu oiso toupai osa vearoa rasia, oa iava voa vearovira ora pauepa. Uva voa vo reo tokiiva va sirova utuoro. Oa iava rirovira kueepa oiso, oaravu uvuipaepa peva tau-ia (30), ari oaravu katai vatara tau-ia (60), ari oaravu uvuipai katai vovoto-ia (100) uvuiepa.” ");
INSERT INTO roo_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Uva voea akereva, “E vuravu kaepatavoi ra oira tovota baket sopaaro-ia, ora uruara ita reroaro oira tovota voa? Viapau. Easi tebol ivara-ia oira tovopata. ");
INSERT INTO roo_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ari ita, orekerovu rutu vatauvira toupaiveira oara rutu poeravira kosi piroverea. Ora varao oara rakupareve, oara rutu poerareverea rara utupaua. ");
INSERT INTO roo_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Vosa irai-ia kokitoa vai karuvira toupareve, vearopai ra va uvureve, uvare uvupatoa ita kokito.” ");
INSERT INTO roo_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Uva voeare oiso puraroepa, “Vearovira rutu uvupata. Vosa gare visivi uvupata, eva-a oa iava gare visivi taraipatavere. Ari vosa rirovira rutu uvupata, osa iava uvuipatai ita ra taraipatavere rutu. Vosa vearovira rutu vo reo sirova utupata, eisi osa iava vo reo-ia vearovira tarai iraopataverea. ");
INSERT INTO roo_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Vosa vo taraio kovo piereve, ira ita uvuiparoi ita vorerivira ouroverea. Ari vosa ro ira viapau garea vai-ia pitureve, ira uvuiparoi ita apotaroverea rutu.” ");
INSERT INTO roo_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Uva oiso puraroepa voeare, “Pauto vo Saraaro oiso rutu toupai osa oirato ira wit takuraro vikiparoi vo rasitoa-ia. ");
INSERT INTO roo_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Uva kareroe vokiaro uusisa. Uva avitoa-ia eraoroe osa kovae. Osa viapau vara-ia taraiparoe. ");
INSERT INTO roo_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Rasito raga iava kovapapeira varao witara. Uva rovovira rovopa vakipa kae rovo piro. Ari va isivaaro iava kuepe viorosa. ");
INSERT INTO roo_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Uva vioroepa vo kue. Oa iava rotureva, vo uvare rotupa vuuta-ia tuguraepa.” ");
INSERT INTO roo_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Uva ita oiso akereva, “Aa vao oiso toupai Pauto vo Saraaro? Ora aa vo reo ovoovo reo vava ovoovopai, oa iava uvuipatai oai iava ra va-ia roroiopata? ");
INSERT INTO roo_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Oiso rutu toupaivoi osa oavu aioa oa oiso vaisipaiveira, mastet. Oeva iava oisoa aisivu pauive ra kovape. Ra rirovira rirope. Gare isivi rutu aisia-ia putepaiveira orekerovu rutu kuearo. ");
INSERT INTO roo_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Uva vosa kovape, ra kovaoro ipape. Ra vara rutu-ia puteve evaoara riropavira rutu rao puraoro. Osa iava virata kokioro pitupaive vuavuapasa voa, ora voa epitapaave tapo.” ");
INSERT INTO roo_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Oire uva vo reoro-ia ovoovo reoro voea tavitavireva, oiso ra uvuiave vara uvusa. ");
INSERT INTO roo_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Uva ita, viapau oiso voeapa vo reoro aviavi piereva varao ovoovo reoro. Ari vosa disaipel irara oaro raga tapo oisoa toupareve, ra voea ragapa orekerovu rutu aviavi piepareve. ");
INSERT INTO roo_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ovaiarovi vuri eveivei-ia voea disaipel tavireva oiso, “Irata, ra ouruiara ivirovio ovarata-ia.” ");
INSERT INTO roo_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Uva vo uvuru arova kaea viropa uvuoa-ia rera tapo Jisas. Vo osa oaravivu garepa uvuoro oara voea sirova utuepa. ");
INSERT INTO roo_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Uva vusireva riroto kiuvu. Oa iava sigato kaero viropa uvuoa sovara iare ora va ivara-ia. Uva gareavi raga kavu piropa, ra agasio uukova uvuoa-ia. ");
INSERT INTO roo_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Vo osa rera oira vituaro-ia uusiparoepa orave ivara-ia kukue otarapaoro. Uva rera eraopaiva oiso purapaoro, “Tisa, e viapau vao sovoparivoi oa iava viapau igeipa siraopau? Oa-ia igeipa tutuu pievoi ra kopiiio.” ");
INSERT INTO roo_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Oa iava Jisas erao ovoiroepa. Uva kiuvu rakote piesa reoroepa ora rirova toruva tavireva, “Varau ra ora siroi pieu.” Uva kiuvu rerereva riteoro. ");
INSERT INTO roo_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Oa iava Jisas voea akereva oiso, “Eakepa uriripatai? Ari ita, vosa raria vai toupaive, oire ra viapau uriripata.” ");
INSERT INTO roo_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Osa uriri iraopaoro ora voea raga oiso puraaepa, “Easi iroutoa rutu-a ro, uvare kiuvu rera uvu ovoire ora uukova?” ");
INSERT INTO roo_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Uva Jisas ora rera voeaaro disaipel rereiva ivirovira rovua iava vao Gerasa taere-ia sovara-ia. ");
INSERT INTO roo_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Oire vosa uvuoa iava rereiva uva oiratoava aivaroivoiva, ira tova urui iava kosiro viropa. Ro ira-ia oisoa toupaive tugara. ");
INSERT INTO roo_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Uva voa raga oisoa toupareve tova urui-ia. Uva viapau oiso ra oiratoa vai uvuiro rera tuukesa voa aue-ia sen iro vai. ");
INSERT INTO roo_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ari ita, vokiara rutu-ia oisoa rera vavaearaaro tuuke ragapaive sen iroro-ia. Ora oaravu oara-ia oisoa rera kokotoaro taki ragapaive, ovusa vara rutu tokotokopareve. Viapau rutu irai uvuiparo ra rera tuukereve rera tarai piesa. ");
INSERT INTO roo_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Oire vo osa vokiara rutu-ia aue-ia aviaviaroro ora vo vokiaroro uva oisoa toupareve vo pukuiara ora vo tova uruiro. Ra gaupareve ora rera raga ora upopaoro vorarova varaua iava aue-ia aveke ora tatupaoro. ");
INSERT INTO roo_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Uva Jisas tuepaoro tauai ikaureva rerare taku virosa. ");
INSERT INTO roo_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Oa iava rirovira oivepaoro oiso puraroepa, “Apeisi vai ruipapauei ragaire vii Jisas? Pauto Oviitoaaro ro oiso rutu viara-ia. Ragaipe. Vii arepaavoi vo Pauto vaisiaro sovara-ia oiso, Opeita ragai tekipari.” ");
INSERT INTO roo_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Oiso puraroepa oiso-ia uvare Jisas rerare oiso puraroepa, “Oiratoa iava kosi virou eera vii tugarato.” ");
INSERT INTO roo_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Oa iava Jisas rera akereva oiso, “Irouto-a vii vaisiaro?” Uva rera tavireva, “Vaisia oaa Riro Irara, uvare riro irara igei tugara.” ");
INSERT INTO roo_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Uva tuupavira oiso raga rera akepareva oiso puraoro, “Opeita igei sigupari tauai vaire.” ");
INSERT INTO roo_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Uva oisoa koiepa tapatapa toupaive pukuia-ia vatuaro-ia. Oa oisoa aiopaive. ");
INSERT INTO roo_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Uva Jisas akeiva oiso puraoro, “Igei siguri ra koie kare sopaaro-ia rokoio.” ");
INSERT INTO roo_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Uva voea iava vasereva. Oa iava voea tugara kosia viropa vo koie kare-ia koatasa. Uvava koie kare ikauoro varaaepa vaesia-ia ora vikisa rovu-ia. Oa iava kopiiaepa uuko ovi sovara-ia. Voea rutu uvuiaro erao tuku (2,000). ");
INSERT INTO roo_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Uva koie tokipa irara toriiva vorarore uruiara-ia ora uvarovu tapo tavitavipasa. Oa iava urioaepa aue kekesa vao oa purareva. ");
INSERT INTO roo_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Uva urioaepa Jisas iare. Oa iava rera kekeiva ira-ia oisoa toupaive riro irara tugara, osa varo tuuava pauparoepa ora torevoko rugoo tapo. Oa iava uririaepa. ");
INSERT INTO roo_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Oire voea-a voeao oea ruvara-ia tugara kosi piereva rera iava ro-ia, oea oearovupa siposipopaiva vao iava, uvare oisoa tugara rera-ia toupaive ora aue iava koie ragui. ");
INSERT INTO roo_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Oire eva-a oa iava Jisas aruiva, oiso ra uruia oaive iava avaro. ");
INSERT INTO roo_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Osa-a eisi osa iava koataroepa uvuoa-ia. Uva rera ro ira-ia oisoa toupaive tugara ira ruipaparoepa oiso ra rera sirova utuparo. ");
INSERT INTO roo_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Uva Jisas rerare koruoro rera tavireva oiso, “Avau vore uruia oara ora sara irara oara iare. Ra voea taviri aue iava siraoa oa-ia vo kovo purare Turaro vii-ia.” ");
INSERT INTO roo_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Oire uva avaroepa vo uruiro iare Dikapolis oa porearo oiso vaisipaiveira, Katai Tau Uruiro. Uva voa vao iava tavitaviroepa riro kovo oa purareva Jisas rera-ia. Osa iava uruiara rutu tavetaveiva va iava. ");
INSERT INTO roo_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Oa iava Jisas iviroroepa ovaratavu iare. Uva riro irara ora guruaepa rera iare. Uva vo raga toureva uuko ovi vatuaro. ");
INSERT INTO roo_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Uva Jiu vaaro Reo Taisi Uvupa Kepa tokipato urioroepa. Rera vaisiaro ro-ia, Jairas. Uva Jisas kekeoro takuro viropa vo rera kokotoaro-ia rekuoro. ");
INSERT INTO roo_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Oa iava oiso puraroepa rirovira rutu rera areoro, “Kakaeva oaapa tutuu piepai ra kopiio. Vii arepaavoi ra vavaea oara tovori oira-ia, ra va iava poreteo ora tooo vorevira.” ");
INSERT INTO roo_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Oire uva Jisas rera sirova uturoepa. Uva riro irara vaiterei sirova utuaepa. Oa iava tutututuu piepaiva. ");
INSERT INTO roo_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Uva iriavu riakova iria-ia oisoa kekira koveparo vokiara rutu-ia. Uva oisi raga toupaoro katai tau erao (12) ivaro-ia tuguraopa vo upia purapaoro. ");
INSERT INTO roo_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Uva riro irara rutu iare oisoa ava ragapao, oiso ra oirapa vo ruvaru purapaive, ra opesipe vo kopii. Uva oisoa voeapa ora vori via pie ragapao. Vo ovusa vo kopii oirare riropape rutu, ovusa ora apota pie ragapao. ");
INSERT INTO roo_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Uva Jisas iava uvueva, oa iava riro uvuru sovara-ia rera iare koataopa, oiso ra oira porete piereve. Uva varoa vatuaro-ia pitueva vao rera vaaro. ");
INSERT INTO roo_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Aue iava uvare oira raga oiso ora rugoopaopa, Vosa rera vaaro-ia pitua varoa, ra vearora poreteoro. ");
INSERT INTO roo_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Uva vo vokia-a eva opesiepa upia. Uva varaua sovoeva uvare varaaepa. ");
INSERT INTO roo_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Oisi-a eisi osa iava varaua sovoreva Jisas oiso, Easi iravu iare avai gorua ragai iava. Oa iava ora poreroepa voeare oiso puraoro, “Irou varoa-ia pituvoi?” ");
INSERT INTO roo_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Uva rera voeaaro disaipel rera akeiva oiso, “E vo uvuruo vurapari oea vii iare tutuu piepai. Uva apeisi iava oiso akepari, Irouto ragai-ia piture?” ");
INSERT INTO roo_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Oa iava voea vuravurapareva oiso ra ro kekereve ira rera-ia piturevoi. ");
INSERT INTO roo_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Osa riakova raga va vao ravaeva oa oira-ia karekeepa. Oa iava rikerikepaopa uriripaoro. Uva rekueva rera kokotoaro-ia. Oa iava oiraopavira rera tavieva. ");
INSERT INTO roo_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Uva Jisas oiso puraroepa oirare, “Oviiva oaa. Vii vaaro oirao piea vii porete pievoi ravotovira. Avau gavaurea-ia, ari vearouei.” ");
INSERT INTO roo_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Uva eisi puraparoepa ovusa Sinagog tokipato voeaaro poua viropa oiso tavisa, “Vii oviivaaro kopiioi. Uva uvuipau ra rerare koruu eera Tisato. Ra oirape iria kopiioi.” ");
INSERT INTO roo_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Uva Jisas voea uvupaoro rera tavireva Sinagog tokipato oiso, “Opeita uriripau. Ragai oirao pieri.” ");
INSERT INTO roo_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Uva voeare koruroepa. Oa iava voea raga oureva oiso-ia, Pita-a ro, ora Jems, ora Jon araokotoaaro Jems. ");
INSERT INTO roo_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Uva karea viropa voa vo Jairus vo kepaaro-ia. Oa iava gauara uvuiva. Uva voea kekereva vo ovusa siraopaaepa gau iraopaoro rutu. ");
INSERT INTO roo_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Uva Jisas koataroepa. Oa iava voeare oiso puraroepa, “Eake iraopa gaupata? Ari o kakaeva viapau oiso kopiioi. Iria uusipaoi.” ");
INSERT INTO roo_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Oire uva rera agesipaiva rutu. Oa iava voea kosi piereva. Uva aitetoarei ora kakaeva aakoaro rera sirova utuaepa, ovusa koataroepa vo uva toupaeva kakae kopii. ");
INSERT INTO roo_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Oire oira vavaearo-ia pituoro vo reo purareva, “Talita kumi.” Oa porearo oiso purapai, “Tavauruva, ragai vii tavipaa oiso ra toreu.” ");
INSERT INTO roo_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Oire uva oira-a eira tavauruva vaviopavira raga toreopa voka ovoisa. Oa iava oira-ia tavetave iraoiva rutu. Oira uvuiaro riroaro aue-ia uvuipaoi katai tau erao (12) ivaro. ");
INSERT INTO roo_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Uva Jisas voea vosireva va iava vao-ia oa purareva oiso, “Teapi irai uvureve oira iava. Oire ra aioa vai vateta oirapa ra oai aioeve.” ");
INSERT INTO roo_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Uva Jisas voa kavureva vore rera vo taerearo rutu iare. Oa iava rera sirova utuaepa rera voeaaro disaipel. ");
INSERT INTO roo_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Uva Sabat voki tuguraepa. Uva avaroepa siposiposa vo Reo Taisi Uvupa Kepa-ia. Uva tavetave iraopaiva rera vo siposipoaro uvupaoro. Osa iava oiso puraaepa, “Ovu irao ro vo pitupituro ourevora? Iroutoa vai rera vaterevora vo tarairo? Ora vao ravoto kovo, oa purapare ora rera vavaearo-ia? ");
INSERT INTO roo_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Easi viapau oiso kepa paupato rera ro-ia Maria oviitoaaro, raa? Uvare oiratoa raga-a ro-ia. Ari ita, araoko irara voeao Jems vase ora Josis, ora Judas, ora Saimon, ora taataa riakoaro vairo airoa vigei tapo toupaiveira.” Uva rerare kasipuaepa. ");
INSERT INTO roo_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Uva Jisas voeare oiso puraroepa, “Vosa oearovu voeao ouruirovu raga iava, evoea-a oea profetatoapa avivikepaaveira. Ari viapau oiso voeao rera vo taerearo rutu-ia tou irara rerapa avivikepaaveira, ora sara irara oaro, ora voeao oea vo aao vo kepaaro-ia toupaiveira.” ");
INSERT INTO roo_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Osa iava viapau uvuipa ra riropa ravotoro vai purapareve voa. Ari uvuipa ra vavaea raga tovopareve voearovio-ia upiapa irara voea porete piepaoro. ");
INSERT INTO roo_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Uva Jisas tavetave iraopareva voea vo vovouroaro-ia varao oirao pie asa vovouro. Vo osa avaroepa siposiposa uruiara rutu-ia oirarapa. ");
INSERT INTO roo_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Uva voea voeao katai tau erao (12) oeare keeraroepa. Oa iava voea arureva toatoa pievira. Uva voeapa gorua karoporeva auere ra va iava tugara kosi piepaive. ");
INSERT INTO roo_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Uva goruvira voea tavireva oiso, “Teapi oaravu avu vai kaepatavere vokapaoro. Ari aue raga tooroara vai. Viapau aue breteara vai ora oapara vai ora moniara vai. ");
INSERT INTO roo_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ari aue raga tasipara. Ora viapau oiso ra vaiterei kuvupatoarei, ari kataitoa raga. ");
INSERT INTO roo_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Vosa ourui-ia kareta virora, uvuipatai ra koatata katai kepa vai-ia. Evoa uva toupaoro uvuipatai ra oirara-ia kovopata uruia sovara-ia. Oire voava visii rutu ita kosita viro ita ra avata. ");
INSERT INTO roo_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Vosa ourui visiipa reasipape visii uvu arapa, ra voa kavuta ora visii iava kokotoara iava poupou tovetoveoro, voea vo kaureoroaro reesioro.” ");
INSERT INTO roo_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Uva avaaepa siposiposa oiso ra oearovu rutu iava sopaura poreive. ");
INSERT INTO roo_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Uva riro irara rutu iava tugara kosi piepaiva. Uva gorua ovoovopaoro korovo oviro tovopaiva voeao-ia oea upiaarava toupaiva. Oa iava porete ovoipaaepa. ");
INSERT INTO roo_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Uva King Herot uvureva varao iava, uvare uvarovu rutu Jisas vaisiaro virireva. Osa iava eisi oeavu oiso puraaepa, “Easi pasi Jon Baptais vai-a eera, ira vorevira tootooroi. Ira uvuipa ra evo kovoro ravoto kovoro purapareve ita.” ");
INSERT INTO roo_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Vo osa oearovu oiso purapaaepa, “Easi Ilaija-a eera profetato.” Osa oearovu oiso purapaaepa, “Profetatoa rutu-a eera oiso rera osa tuariripato.” ");
INSERT INTO roo_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Oa iava Herot oiso puraroepa, “Easi Jon vai-a eera ro ira tokoavora, ira vorevira toreroe.” ");
INSERT INTO roo_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","19","Vao iava osa Herot voea arureva tuaririvi oiso ra rera rauive aue Jon. Ra rera tuukeive vo tuukepa kepa auepa Herodias riakovaaro Filip araokoto iria ita oureva Herot. Uva Herodias aveave iraopaopa rirovira rerare, uvare Jon Herot-re kasipuroepa oiso puraoro rerare, “Vuria purari ora vii araokotoaaro riakooro. Viapau oisi torevokopapeira. Oa iava Herodias oiso ruipapaopa ra Jon kopiiro. Uva viapau uvuipaopa. ");
INSERT INTO roo_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Vo osa Herot avivikeparoepa Jon-pa, uvare rera-ia taraiparoepa oiso, Vearo vovouto ora vearo sopato. Oa iava vearovira rera tokipareva. Oire vosa uvureva, oa iava ruruvutuepa rugooaro rerare. Oa iava oiso ruipaparoepa ra rera rutu tuu pievira rera uvureve. ");
INSERT INTO roo_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Uva pou piropa vo vuutao oa iava vo vokia kavauroepa Herot, ovokia-ia uvuiopa oiso ra oira vo ruipaaro kosi pieeve. Uva vo vokia voeapa aioa purareva reipa irara oaro, ora ami iava ofisa irara, ora oira vasi irara vova Galili. ");
INSERT INTO roo_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Oire uva koataopa Herodias oviivaaro rekurekusa. Osa iava eisi Herot vearovira rutu oira vo rekurekuaro tuereva ora voeao oea rera tapo paupaaepa. Uva reito king oira tavireva tavauruva, “Vosa eakepa ruipapau, ra vii vatea va.” ");
INSERT INTO roo_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Uva oiso puraroepa oirare reo ovoi puraoro, “Vao oa areri ragai ruvara-ia oa-ia uvuiparai ra viipa va vatea. Eagara vosa eake vatea ragai varaaro iava oara tokipaaveira, oara-ia pute piea vai rutu-ia uvuiparai ra vii vatea oai.” ");
INSERT INTO roo_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Oire uva va iava avaopa aakova akesa oiso, “Eake vai arepaa?” Uva aakova oira tavieva, “Ari Jon Baptais iava kukue.” ");
INSERT INTO roo_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Oa iava ikauvira rutu voreopa vore reito. Uva oiso puraopa, “Vao-ia oapa ruipaparai. Ra va vateri ragaipa Jon Baptais iava kukueva, ra rera kukuearo tovori aue-ia tauo vai.” ");
INSERT INTO roo_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Uva rerare sopaua vavataepa rutu, uvare viapau oiso uvuiparoepa ora rera vaaro reo ovoi gasireve, vao oa purareva oira uvuru osireiaro-ia. ");
INSERT INTO roo_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Oa iava iravu arureva voeao iava viurupa irara rera voeaaro. Uva rera tavireva oiso ra Jon kukuearova urioro. Uva avaroepa rera tokosa tuukepa kepa-ia. ");
INSERT INTO roo_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Uva vo kokova voreroepa tauo-ia. Oa iava vo kokoa vatereva oirapa tavauruva. Uva vo kokova avaopa aakova vatesa. ");
INSERT INTO roo_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Uva disaipel irara voeao Jon voeaaro rera iava uvuoro urioaepa vo kopii ousa. Oa iava rera tovaiva vo tova urui. ");
INSERT INTO roo_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Uva aposel irara vorevira kareaepa Jisas iare rera tavitavisa varao iava oara puraiva ora varao oara iava siposipoiva. ");
INSERT INTO roo_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Uva oirara rutu ora voreripaaepa. Oa iava Jisas-pa ora rera voeaaro aposel viapau vuutaa vai toupaiva oiso ra oai-ia aioive. Eisi osa iava Jisas voea tavireva oiso puraoro, “Oire irata ra vigei raga avavio uvavire kuvau tapi vai, ra voa reareata gare visivi.” ");
INSERT INTO roo_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Oa iava ipaaepa uvuoa-ia. Oa iava rera tapo avaaepa uvavure kuvau tapi. ");
INSERT INTO roo_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Uva riro irara rutu voea tueiva vo uva avaaepa. Oa iava taraiaepa voea-ia. Uva rovoaepa ikaupaoro vova atoiaro oaive. Osa iava Jisas-re vage rovopaoro voa poua viropa. ");
INSERT INTO roo_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Oa iava Jisas vera uviroroepa rogaraua iare, vo osa riro irara rutu kekereva. Oa iava oiso voeapa siraoroepa, uvare oiso rutu paepa voeapa osa sipsip kare, voeao oea viapau tokipatoa vai. Oire uva Jisas rovoroepa voea siposipopaoro riroara rutu iava. ");
INSERT INTO roo_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Uva ravireo rokosa aueparoepa, oa iava disaipel irara urioaepa rera iare rera tavisa oiso, “Voavi-a vo-ia kuvau tapi. Uva vokiei vigeire. ");
INSERT INTO roo_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Voea aruri ra avaave uvaire ora ouruiroi iare, ra aioara vai voriive ora voeapa.” ");
INSERT INTO roo_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Oa iava voea tavireva oiso, “Voea vateta aioara vai.” Uva rerare oiso puraaepa, “E apeisi-a, ruipapau ra vaova avaio vao-ia erao vovoto kina (K200) bret vorisa voeapa, eke?” ");
INSERT INTO roo_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Uva voea akereva, “Aa voviroa aue bret, oara epao visii ruvara-ia?” Oire uva va iava rera taviiva oiso, “Easi vo vavaevi raga aue bret ora kataitoarei ataritoarei.” ");
INSERT INTO roo_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Uva voea tavireva oiso ra voea pau pieive isiso kou-ia. ");
INSERT INTO roo_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Uva pauaepa guruvira roopavira. Oeavu aue-ia uvuipaaepa katai vovoto (100), ari oeavu aue-ia uvuipaaepa vo vavae tau (50). ");
INSERT INTO roo_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Uva bret vavae oureva ora ataritoarei. Uva viara-ia vurareva vo vuvuiua vuurapa vaisi puraoro. Oa iava vara puteputereva. Uva vara vatereva disaipelpa, oiso ra voea roo pieive vara rutu-ia. ");
INSERT INTO roo_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Oa iava voea oirara rutu aiooro vukuaepa. ");
INSERT INTO roo_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Oa iava vara ururukoaro guruguruiva. Uva aue-ia uvuiepa katai tau erao (12) pekuri. ");
INSERT INTO roo_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Voea uvuiaro voeao oirara raga ouvurua bret aioiva aue-ia uvuipaaepa vo vavae tuku (5,000) oirara. ");
INSERT INTO roo_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Uva Jisas voea disaipel aru ovoireva uvuoa iare, oiso ra iraave eisire Betsaida iare voea iava vaseoro oirara. ");
INSERT INTO roo_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Oa iava voeava tavariooro varirisa iparoepa pukuia-ia. ");
INSERT INTO roo_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Uva vokiepa rerare osa uvuoa touvira vokapaiva toko rovu vuutaro-ia, vo osa Jisas raga touvira vo pukuia-ia toupareva. ");
INSERT INTO roo_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Uva voea tuereva Jisas osa ora takau piepaaepa tuaapaoro kiuvu iare. Oa iava voea iare vokipaua rutu vokiroepa vo osa ravireo kae viro asavira toureva. Uva avaroepa vo toko rovu ivara-ia vokapaoro voeava aivarosa. ");
INSERT INTO roo_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Uva rera siituepaiva osa uuko rovu ivara-ia vokapaoro urioroepa. Uva oiso keapaaepa, Rera urauraaro. Uva rerapa uriripaaepa gaupaoro. ");
INSERT INTO roo_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Vao iava uvare rera vurapaoro rirovira rutu uriri iraopaaepa. Oa iava voeare reoroepa oiso puraoro, “Ora tape pieta. Opeita uriri ragapata. Easi, ragai-a vao,” osa puraroepa Jisas voeare. ");
INSERT INTO roo_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Uva vo osa iparoepa uvuoa-ia, uva kiuvu opesiroepa. Osa-a eisi osa iava rera-ia tavetave iraopaiva. ");
INSERT INTO roo_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ari ita, uvare viapau roroiopaaepa vo kovo-ia oa purareva bret-ia. Osa iava eisi rera eveiivori rera vo goruaro iavirava. Ari voeare vavagisivira raga toupaiva rugooara. ");
INSERT INTO roo_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Uva iviroaepa. Oa iava veraa viropa vo Genesaret urui-ia. Oire uvuoa tuuiva vo toko rovu vatuaro-ia. ");
INSERT INTO roo_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Uva vera uviroaepa, oa iava rera evei ovoiiva. ");
INSERT INTO roo_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Uva tariripaaepa voraro rutu upiapa irara kaepaoro rakorako ururo-ia rera iare. Uva ouruirovu iava uriopaaepa Jisas iava uvupaoro vore uva toupareva. ");
INSERT INTO roo_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Oire oa iava Jisas uvarovure oisoa avaparo garepa uruirovu iare ora riropa uruiro. Uva oisoa upiapa irara tovopaive vo uupa tapiro. Uva rera arepaiva oiso ra varoa vatuaro-ia pitupaive ra porete ovoipaave. Oa iava va-ia pitupaiva, uva porete ovoipaaepa voea rutu. ");
INSERT INTO roo_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Uva Farisi rera ruvara-ia ora guruaepa ora Reo Taisi-ia tarai irara, oea vova urioaepa Jerusalem-ia. ");
INSERT INTO roo_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Oa iava eva disaipel irara tueiva rera voeaaro osa aiopaiva vavae sisu asavira raga, vo pitupituo Farisi vaaro gasipaoro. ");
INSERT INTO roo_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Uva Farisi-pa irara ora Jiu-pa irara vo pitupituaro-a vao-ia vosa viapau vavaeara sisu rovoive, ra viapau uvuipaai ra aioive. Aue iava aao irara vo siposipoaro oisoa sirova utupaave. ");
INSERT INTO roo_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ora vosa aivaropa tapirova kareave, ra viapau vavae sisuave, ra ita viapau aioive ita. Uvare vo pitupituro rutu-a varao voea aao iraraaro varaaro oisi, vao kap sisupa, ari vao pitoka sisupa, ora tauoara varao oara oisoa purapaive bras-ia. ");
INSERT INTO roo_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Uva Farisi ora Reo Taisi-ia tarai irara rera akeiva oiso, “Uva apeisi iava vii voeaaro disaipel viapau vigei aao iraraaro vo pitupituroaro sirova utupaai? Uva viapau vavae sisuai, oa iava aioivoi.” ");
INSERT INTO roo_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Uva Jisas voeare oiso puraroepa, “Oiraoei ravaa reo vao profetato Aisaia oa-ia torevokovira rutu visii reesioro va rigatoreva riro ratarataa vovou irara visii. ‘Voea rutu raga vaisiaro kae pie ragapai gisipoara raga iava, osa voea sopaaro tauaipai rutu ragaipa. ");
INSERT INTO roo_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Oirara raga vo siposipoaro iava siposipopaiveira, ra oiso purapaave, Va vao-ia Pauto vo reoaro. Eisi osa iava ragaipa akukuvira rutu lotu ragapaaveira.’ Eisi osa puraroepa Aisaia. ");
INSERT INTO roo_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Oa ita kavutava Pauto vaaro Reo Taisi oirato raga vo siposipoaro sirova utupasa.” ");
INSERT INTO roo_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Uva voea tavireva, “Pauto vaaro Reo Taisi gasi iraopatavoi, oisore ra ora visii vo pitupituaro raga tokipata. ");
INSERT INTO roo_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Uvuta! Moses oiso puraroepa, ‘Aako oarapa ora avivikepau ora aiteara. Ari ro ira aitetoarei takaupareve, eera-a ira kopii pieivere oearovu.’ ");
INSERT INTO roo_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Vo osa visii oiso purapataveira, Aako ora aite viapau uvuiparai ra vei vatea varao, uvare Pautoa-pa vara rutu vate rovoavora. ");
INSERT INTO roo_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Vosa oisi piepata eisi, oire eva-a oa-ia Pauto vaaro Reo Taisi akaipa piepataveira visii vo pitupituroaro rigapaoro oearovu iare. Uva riroara rutu-a oara purapataveira.” ");
INSERT INTO roo_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Uva Jisas voeare keeraroepa ita. Oa iava voeare oiso puraroepa, “Visii rutu uvuta! Ra roroiota vao-ia. ");
INSERT INTO roo_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Viapau oiso vao oa aiopare oirato oa rera sopaaro vuri piepaivoi, ari vao-a oa rera sopaaro iava kosipa piroi. Evara-a oara oirato vuri piepaivoi. ");
INSERT INTO roo_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Vosa irai-ia kokitoa vai karuvira toupareve, vearopai ra va uvureve, uvare uvupatoa ita kokito.” ");
INSERT INTO roo_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Uva koataroepa kepa-ia oirara rutu arova ratau. Oa iava voa disaipel rera voeaaro rera akeiva vao iava ruu reo. ");
INSERT INTO roo_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Oa iava voeare oiso puraroepa. “E viapau taraia vaiei visii-ia oiso osa evoea oearovu? Uva viapau vara eveipatavoi varao oirato sopaaro-ia ora kiupai. Uva viapau rera vuri piepaivoi. ");
INSERT INTO roo_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ari ita, aue iava uvare viapau ora kiupai sopaua-ia, ari vo raga sare-ia. Ra vorevira vusive.” Uva vo reo-a vao oa-ia aioara ruture oiso puraroepa, “Vearoara varao aioara rutu aiopasa.” ");
INSERT INTO roo_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Uva va-a vao oa iava oiso puraroepa, “Ari vaoa-ia vuri vovou oa oiratoa iava kosipapi oa rera vuri piepai. ");
INSERT INTO roo_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ari ita, vo vuri rugooro-a varao oara kosipapi oirato sopaaro iava vuri rugorugooro oiso-ia, otopa pitupituro, kaviru, oira upo, riako riirii, ");
INSERT INTO roo_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Oearovu vaaro riirii, vuri vovou, keakea reoro, getegete, roruoru, reo toga, egaega, ora kokoropa vovou. ");
INSERT INTO roo_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Evara rutu oara kosipa piroveira visii sopaaro iava oara oirara vuri piepaivoi.” ");
INSERT INTO roo_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Uva evoava ita toparo viropa Jisas aue iare avaoro Taia-ia. Uva voa okepavu-ia voea asavira koataroepa. Ari ita, viapau oiso uvuiparoepa ra tou ragareve rera raga. ");
INSERT INTO roo_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Oa iava vo voki raga-ia eva iriavu rera iava uvuoro rera iare urioopa, iria oisoa oviivaaro-ia tugara toupaive. Oa iava rera kokotoaro-ia Jisas rekueva. ");
INSERT INTO roo_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Oire uva osaravu raga iava oira, vo sarao vo-ia Finisia oea oisoa Siria taere-ia toupaive. Iria Jisas areeva oisore ra tugara kosi piereve oviiva iava. ");
INSERT INTO roo_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Uva oiso oira tavireva, “Kakae vure aio pie rovopai. Viapau oiso vearopai ra kakae vure vo kuroroaro aio kuroro oupe vara vikisa kaakau karepa.” ");
INSERT INTO roo_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","“Oiraopavira ita Turaro,” osa puraopa riakova, “Uvare kaakau kare uvuipaai ururukoara raga aiopasa varao oara kovepapeira vova tebol iava kakae vure vaaro.” ");
INSERT INTO roo_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Oa iava Jisas oiso oirare puraroepa, “Kareu ari tugarato kosirovi oviiva oara iava, uvare vearo reo purari.” ");
INSERT INTO roo_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Uva pouo viropa oira vo kepaaro-ia. Oa iava oviiva kekeeva urua ivara-ia uusivira, vo uvare tugarato oira iava kosiro viropa. ");
INSERT INTO roo_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Oire va-a eva oa iava vorevira virireva Taia taere iava vore Saidon-ia putesa aue iare Galili Rovu. Ora aue-ia tapo putereva Katai Tau Uruiro-ia, Dekapolis. ");
INSERT INTO roo_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Uva iravuva urioaepa uvagito vaaruuto. Oa iava Jisas areiva oiso ra rera-ia vavaea tovoreve. ");
INSERT INTO roo_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Oa iava voea arova rerava avaroepa kuvau tapire. Uva voa sipareo tovoreva rera kokiaro-ia ora ruiroepa. Oa iava aia ita arevuotoa-ia pitureva. ");
INSERT INTO roo_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Uva vuvuiua-ia vurareva. Uva vovou iparoepa rerare oiso puraoro, “Efata.” Oiso ragavira oa porearo toupai, “Auero rutu karu piroi.” ");
INSERT INTO roo_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Uva karu ovoiro viropa kokito rerare, osa arevuoto tapo vase ovoireva. Osa-a eisi osa iava torevokovira reo ovoiroepa. ");
INSERT INTO roo_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Uva Jisas riro goruvira rutu voea vosi ragareva va iava vao oiso ra viapau iraipa taviave. Ari ita, riro goruvira rutu voea vosi ragapareva vo osa ora gorupaaepa rutu va iava vao siposipopaoro. ");
INSERT INTO roo_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Uva tavetaveiva rutu oiso purapaoro, “Avoeao, vearoa rutu purarevo ro-ia voeao uvagi irara oea uvu piepaoro, ora vaaruu irara reoreo pierevo,” eisa osa purapaaepa. ");
INSERT INTO roo_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Uva vo vokia-a vao oa-ia riro uvuru toupaiva. Viapau aioa vai voeapa. Uva voeare keeraroepa rera voeaaro disaipel voea tavisa oiso, ");
INSERT INTO roo_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Siraoparai voeaopa uvare vo peva-ia voki touivo vigei tapo. Uva viapau aiopaivo. ");
INSERT INTO roo_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Vosa voeare koruvio, ra voreave vorarore ora voea vo uruiroaro. Ra raveraveave vo raivaaro, uvare oearovu riro kaekae tapirova uriopaaerao.” ");
INSERT INTO roo_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Oa iava disaipel rera akeiva oiso, “Uva ovu vai voea aio piepai. Ari raaka tapi raga-a vo.” ");
INSERT INTO roo_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Eisi osa iava oiso voea akereva, “Ovirovua bret oa epao visii ruvara-ia?” Oa iava oiso puraaepa, “Ari erao vatara.” ");
INSERT INTO roo_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Uva voea pau piereva vo rasito. Oa iava aue oureva erao vatara (7) bret. Uva vara-ia vearo vaisi purareva vara puteputeoro. Osa iava vara vatereva rera voeaaropa disaipel, oiso ra voea vatevateive taru. ");
INSERT INTO roo_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Uva toupaiva atari kare gare karevi raga. Uva vo kare-ia ita aia vearo vaisi purareva. Oa iava voea tavireva oiso, “Voea vateta atari kare.” ");
INSERT INTO roo_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Uva voea aioivoiva, vukuaepa. Oa iava ururukoara guruiva erao vatara pekuri agasi pieoro vara-ia. ");
INSERT INTO roo_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Uva voea rutu uvuiaro-a voea oiso toupaiva, vo resura tuku (4,000). ");
INSERT INTO roo_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Oa iava voeare koruroepa. Uva rera tapo voeava tavari ovoioro uvuoa-ia ipa ovoiroepa ora disaipel irara tapo vore avasa vo Dalmanuta taere. ");
INSERT INTO roo_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Uva Farisi-pa irara urioaepa rera akesa oiso, “Ruipapaiei ra ravotoa vai purari vo goruo kareke pieoro vuvuiua iava.” Oisi-a eisi osa kokarapaaepa. ");
INSERT INTO roo_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Oa iava Jisas-re sopaua vavataepa. Osa iava oiso puraroepa, “Eake vaire voeao vo vuutao iavapa irara ravoto arepaai? Oiraopavira rutu oiso visii tavipaavoi, Viapau rutu uvuiparai ra ora ragai vo ravotoaro vituaro kareke piepaa visiipa.” ");
INSERT INTO roo_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Oa iava voea arova voa kae viroroepa uvuoa iare. Uva avaroepa ivirosa ovaratavu iare. ");
INSERT INTO roo_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Uva disaipel ovauaepa auere bret ora voeapa osa kataiavi raga toupaiva vo uvuoa. ");
INSERT INTO roo_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Osa-a eisi osa iava Jisas voeare oiso puraroepa ovoovovira, “Vaopa yis vatatopopatai Farisi-pa irara vaaro ora ro Herot.” ");
INSERT INTO roo_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Uva oiso puraaepa ora voea raga, “Aue iava ita oiso vigei tavirevoi, uvare viapau bretea vaiei.” ");
INSERT INTO roo_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Uva Jisas vo reo sovoreva, oa iava oiso puraroepa, “Apeisi iava eisi ora reopatai oiso, Viapau vigei bretea vaiei? E viapau sovopata ora viapau taraipatai? E sopaura oavisii vavagisipai? ");
INSERT INTO roo_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","Ari ita, osireiara oavisii epao, uva viapau vara iava vurapataveira. Ora kokiara oavisii, uva viapau vara iava uvupataveira. E viapau vaore rugoopatai oa-ia vo vavae tukupa (5,000) vo vavaea bret puteputeavora. Uva ovirovua pekuri oara agasi pietavora?” Oa iava rerare oiso puraaepa, “Katai tau erao (12) aue pekuri.” ");
INSERT INTO roo_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Eisi osa iava voeare oiso puraroepa, “Ari ita, ovokivu-ia resura tuku (4,000) vao aioivora erao vatara bret. Uva ovirovua aue pekuri oa agasi pietavora aue-ia bret ururukoro?” Oa iava oiso puraaepa, “Erao vatara.” ");
INSERT INTO roo_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Osa iava eisi voea akereva oiso, “E touvira vo kovo vituaro iava taraitavere vao-ia, raa?” ");
INSERT INTO roo_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Uva Betsaida urui-ia poua viropa. Oa iava iravu sipoiva rera iare voosito. Uva Jisas arepaiva oiso ra rera-ia pitureve. ");
INSERT INTO roo_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Oa iava Jisas rera vavaearo-ia pituoro rerava kosiro viropa uruia iava. Uva Jisas rera osireiaro-ia ruiroiva, rera-ia vavaearei tovoreva. Oa iava oiso rera akereva, “E oavu avu vai vurapari?” ");
INSERT INTO roo_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Uva voosito vurareva viara-ia oiso puraoro, “Ari ita, oirara siituepaavoi oea vokapaivoi. Uva voeapa oisi pai evaoara oara vokapaivoi.” ");
INSERT INTO roo_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Uva Jisas vorerivira ora rera iava vavaearei rera-ia ita tovoreva. Oa iava rera ro voosito tuupavira vurareva. Uva porete ovoiroepa roroiovira vuravura ovoioro. ");
INSERT INTO roo_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Osa iava eisi Jisas rera aruoro oiso puraroepa, “Kareu vii vo kepaaro iare. Ra opeita vo uruio iare vorevira voreu.” ");
INSERT INTO roo_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Uva Jisas avaroepa rera voeaaro tapo disaipel vo urio iare vo Sisaria voa raga Filipai. Uva voare avapaoro voea akereva oiso, “Apeisi oirara ragai vaisipaiveira?” ");
INSERT INTO roo_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Uva oiso rera taviiva, “Ari oearovu oiso purapaaveira, Jon Baptais eera, osa oearovu oiso purapaave, Ilaija eera ro profetato. Ari oearovu oiso purapaaveira, Vii iravu voea iava profet irara.” ");
INSERT INTO roo_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Oa iava voea akereva, “Ari apeisi visii raga ragai vaisipata?” Oa iava Pita oiso puraroepa, “Ari vii-a Krais ro Ropoto viigoa arureva Pauto vore.” ");
INSERT INTO roo_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Uva voea vosireva oiso, “Opeita eisi ragai iava oearoipa tavipatavere.” ");
INSERT INTO roo_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Va vao isivaaro iava voea siposipooro rovoroepa ora rera iava oiso, “Oirato Oviitoaaro riroara siitokaara ourevere. Irare isivaavere taru oira vasi irara, ora pris irara voeao reipa irara, ora Reo Taisi-ia tarai irara, ora rera upoivere. Ra vo peva pie voki-ia torero vorevira.” ");
INSERT INTO roo_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Uva poeravira eisi voea tavirevoiva, Pita rera-ia pituoro Jisas oureva rera tape piesa oiso puraoro, “Opeita oiso purapau.” ");
INSERT INTO roo_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Uva voeao disaipel vurasa ora poreroepa. Osa iava Pita vo rugooaro torevokopasa oiso puraroepa, “Seten, ragai isivaaro-ia ora tovou. Viapau rutu rugoopauei Pauto varaarore. Ari varao ragare rugoopau oirato varaaro,” osa puraroepa Jisas. ");
INSERT INTO roo_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Oa iava oirara ruture keeraroepa ora disaipel irara ora rera iare. Uva voeare oiso puraroepa, “Vosa ro ira vovouparo ra ragai sirova uturo, oire ra ora rera iava vaisia vara pie rovoreve. Oa iava uvuipa ra ora rerapa vavata siitoka kaereve, oiso osa vao evao parikou ragai sirova utupaoro vokiara rutu-ia. ");
INSERT INTO roo_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ari ro ira tootooa virivaripareve, oava eva opesiroverea tootooaro. Ari ro ira tootooaro vatereve vo oearovupa ragai vo ruipaaro sirova utupaoro ora vao iava Vearo Siposipo eera-a ira tootooaro tapo virivariavere taru. ");
INSERT INTO roo_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Aa vao-a vearoa oa oureverea oirato vo rasio-ia, vo rara auero rutu varao vo rasio iava oureve, ovusa tootooa oaro rutu viki ragapareve? ");
INSERT INTO roo_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Uva eake vai oureverea vorevira tootooaro-ia tavariovira? ");
INSERT INTO roo_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ro ira ragaipa ariiro ora ragai siposipoaropa tapo vo oearovu osireiaro-ia voeao iava riro otopa irara ora voea vuri vovou irara, irapa ita eera utupaua Oirato Oviitoaaro ariiroverea vo vokio-ia oa-ia voreraverea vo Aiteto vaarova keraria, ora voeao tapo tugoropa irara ensel irara.” ");
INSERT INTO roo_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Uva Jisas voea tavireva oiso, “Oiraopavira visii tavipaavoi, Oearovuei visii iava oea toupai vo-ia oea kopii asavira toupaoro Pauto vo Saraaro keke rovopaivere, vo osa goruvira karekepe.” ");
INSERT INTO roo_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Uva katai vatara vokiro putevoiva, Jisas Pita vase tapo iparoepa ora Jems ora Jon pukuia iare riro pukui vo uva varaua rera iava ora tavarioepa. ");
INSERT INTO roo_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Varoara tapo oara sisikoreva. Uva viapau oiso irai vo rasio iava ra oisi eisi sisikoreve osa evara varoara. ");
INSERT INTO roo_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Uva Ilaija vaio ora Moses ora karekesiepa. Uva vaiterei siituepaiva ovusa Jisas tapo ora reopasiepa. ");
INSERT INTO roo_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Oa iava Pita Jisas-re oiso puraroepa, “Tisa, vo toupai vearovira. Uva igei uvuipaiei ra kepa peva vai pauio oiso, viipa okepai, ari Moses okepai, ari Ilaija okepai aue guruva keparo vai.” ");
INSERT INTO roo_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Oisi-a eisi osa pura ragaroepa Pita uvare rirovira rutu uririparoepa. Oa-a eva oa iava viapau vearovira rutu reoroepa. ");
INSERT INTO roo_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Uva rukuta voea ruueva, osa oavu reo guruko karekeepa rukuta sovara-ia, oa-ia oiso puraroepa Pauto, “Eera rutu ragai Oviitoaaro ira kaviko iraopaaveira rutu. Ira uvu iraopata.” ");
INSERT INTO roo_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Osa iava ora vura ragapaaepa. Uva viapau oiso iravu avu vai kekepaiva, ari Jisas raga. ");
INSERT INTO roo_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Uva vo osa varapaaepa pukui iava, uva Jisas voea vosipareva oiso ra viapau oearoi tavipaivere vao iava oa kekeivoi. Ari vo raga osa Oirato Oviitoaaro tore rovorovere kopii tapi iava. Uva oisi-a eisi osa ora rera raga iava voea tavireva. ");
INSERT INTO roo_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Uva vo tavi uvu ovoiiva, oiso ragavira ora akepaaepa, Eake rutu-a torea vituaro porearo? ");
INSERT INTO roo_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Oa iava rera akeiva oiso puraoro, “Uva ari eakere Reo Taisi-ia tarai irara oiso purapaaveira, Ilaija ira urio rovorovere?” ");
INSERT INTO roo_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Osa-a eisi osa iava voea tavireva oiso, “Oiraopavira ita oiso osa ragaipa irarovere Ilaija, ira auero rutu torevokoreve. Ari apeisi vo rigato oa oiso purapapeira, Ro-ia Oirato Oviitoaaro ira taru siitoka oureverea, ora rera akaipa piepaiverea? ");
INSERT INTO roo_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ari ita, visii tavipaavoi oiso, Ilaija ira urioroera voviri. Uva oirara oisoa ora voea raga vo ruiparoaro sirova oisoa utupaave. Eisi osa vara sirova utuaiva, opitupiturovu rutu puraiva rera-ia oiso osa Tugoropa Vuku purapai.” ");
INSERT INTO roo_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Oire uva vo peva evoea disaipel iare poua viropa. Uva voa riro irara rutu oirara kekeiva osa voa ora gurupaaepa voeao tapo Reo Taisi-ia tarai irara, oea disaipel irara tapo ora reopaaepa ora kaureopaoro. ");
INSERT INTO roo_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Oa iava voea rutu Jisas kekeiva rera-ia tavetavepaoro. Uva ikauiva rerava ora reosa. ");
INSERT INTO roo_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Uva voea disaipel akereva Jisas, “Eake-ia evoea tapo ora reopaoro voeava ora kaureopatai?” ");
INSERT INTO roo_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Uva iravu voea iava Jisas iare urioroepa. Oa iava rerare osa puraroepa, “Tisa, ragai oviitoaaro vaaruuto ira vaaruu piepareveira vurito tugarato. Irava uriorai vii iare. ");
INSERT INTO roo_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ovuutarovu rutu-ia vurito tugarato rera-ia goruvira rutu pitupaoro rera-ia vikipareveira rasiuaarore. Oa iava ruiruisoara karekepapeira rera gisipoaro-ia, ora tapo vo osa ora rera iava reuriara aiopareveira. Vo osa ora rera iava varaua rutu tuukaupe. Uva eva-a oare vii voeaaro ake ragaavora disaipel. Uva viapau oiso uvuipaaerao ra rera kosi pieive tugarato.” ");
INSERT INTO roo_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Uva Jisas vo reo uvurevoiva, voeare oiso puraroepa, “Avoeao! Visii vao-ia visiigoa viapau oirao pie vovou vai toupai. Ovirovuro-ia vuuta uvuiparai ra visii tapo toupaa. Ora ovirovuro-ia vuuta uvuiparai ra visii ateate piepaoro ragai eisi piepata? Viovokotoava uriota eera ragai iare.” ");
INSERT INTO roo_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Uva rera iare rerava avaaepa. Uva Jisas vurareva tugarato, oa iava kakaeto tuutuusi piereva. Oa iava koveroepa rasiuaaro vereverekooro ruiruisopa akutaoro. ");
INSERT INTO roo_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Uva Jisas aiteto akereva oiso, “Ovirovua voki oa-ia oiso tourevora?” ");
INSERT INTO roo_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Oa iava Jisas tavireva aiteto oiso, “Ari ita, riroara rutu vokiara oara-ia oisi raga rovoroepa, osa rera tovopareveira tugarato eto kasiro-ia ora vo uuko oviro-ia, oiso ra rera kopii piereve. E uvuipauei oavu avu vai purasa ra vegeivipa siraou vegei tauvasa?” ");
INSERT INTO roo_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Eisi osa iava oiso Jisas rera akereva, “Eakere eisi purauei oiso, E uvuipau? Ari ita, ro ira oirao piepareve rutu, irapa uvuipa ra oaravu rutu oiraopape rerapa.” ");
INSERT INTO roo_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Uva aiteto rirovira gauoro oiso puraroepa, “Ragai oirao pie iraopaaveira. Uva oiso ruipaparai ra ragai vo oirao piearo vao-ia riro pieri.” ");
INSERT INTO roo_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Uva Jisas uvurua kekereva osa ora guru ovoiaepa. Oa iava tugaratoare oiso puraroepa, “Vii tugarato vaaruuto uvagito, viire goruvira reoparai ra kosiu viro rera varaua iava. Ra opeita vorevira ita voreu rera iava varaua iare.” ");
INSERT INTO roo_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Oa iava oiveroepa tugarato kakaeto rirovira tuutuusi pieoro. Oire uva rera iava ovoivira kosi ovoiro viropa. Uva oiso paepa kopiito kakaeto. Oa iava oearovu oiso purapaaepa, “Kakaeto kopii ovoiroi.” ");
INSERT INTO roo_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Eisi osa iava Jisas rera vavaearo-ia pitureva rera tore piesa. Oa iava tore ovoiroepa rera ita. ");
INSERT INTO roo_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Uva Jisas koataparoepa osa oiso rera akepaiva disaipel, “Eake rutu vituaro iava viapau uvuipaierao tugara verapasa?” ");
INSERT INTO roo_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Uva voea tavireva, “Viapau oiso oavu avu vai-a oa uvuipai. Ari variria raga-ia.” ");
INSERT INTO roo_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Oire uva evo urui kavuiva, oa iava Galili-ia puteoro avaaepa. Uva oiso rugooparoepa, Teapi vo voka-ia taraiave oearoi, ");
INSERT INTO roo_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","uvare rera voeaaro raga disaipel ora rera iava siposiposa ruipaparoepa. Uva voeare oiso puraroepa, “Iravu Oirato Oviitoaaro kosi pierevere oirara vavaearo iare, oiso ra rera upoive. Vosa kopiirovere, ra torerovere ita vorevira vo pevapa voki-ia.” ");
INSERT INTO roo_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Uva viapau roroiopaaepa vo siposipo-ia. Oa iava rerapa uriripaaepa rera ake arapa va iava. ");
INSERT INTO roo_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Uva Kapaneam-ia poua viropa. Oa iava koata ovoiroepa kepa-ia. Uva voa disaipel akepareva, “Eake-ia ora reopatae eisi raivaaro?” ");
INSERT INTO roo_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Uva viapau reopaaepa, uvare ora reopaoro vokapaiva vo raivaaro vao-ia oiso, Irou vai oiso rovope voeapa. ");
INSERT INTO roo_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Uva Jisas pauroepa katai tau eraore (12) keeraoro disaipel. Oa iava oiso voea tavireva, “Vosa irai ira vovouparo ra ita ira pievira rutu ora tovoro, eera-a ira oirara rutupa kovorevere oiso osa ovoiokuto akaipato.” ");
INSERT INTO roo_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Oa iava iravu oureva kakaeto rera tore piesa voea vuutaaro-ia. Uva rera kaverukooro rera-ia pitureva oiso puraoro voeare, ");
INSERT INTO roo_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Oire vosa irai tauvareve kakaetoa vai vo ragai vaisiaro-ia, ira ita-a eera ira ragai tauvapare. Uva viapau oiso ragai raga, ari ro tapo ira ragai siporeva.” ");
INSERT INTO roo_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Uva Jon rera tavireva oiso puraoro, “Tisa, iravu kekeiovora ira vuri tugararo kosi pieparevorao vii vaisiaro-ia. Uva rerare koruierao uvare viapau oiso vigei iava rera-a.” ");
INSERT INTO roo_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Oa iava Jisas voeare oiso puraroepa, “Opeita rerare korupata. Vosa irai vao ravoto kovo purapareve vo ragai vaisiaro sovara-ia, oire ra viapau rutu oiso ra ragai takaupareve. ");
INSERT INTO roo_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ari ro ira viapau vigeiva keriparo, ira-a eera vigeiva tavosivira toupare. ");
INSERT INTO roo_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Oiraopavira visii tavipaavoi. Vosa irouto voeao iava ragai voeaaro iravivu vatereve uukoa vai rera ukaio piepaoro, aue iava uvare ragai vaisiaro-ia Krais kovopareveira ira vo vorio ou iraoreverea taru Pauto ruvara-ia. ");
INSERT INTO roo_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Vosa iroutoa vai vo kakaeo kove piereve ragai-ia kavusa okakaea ragai oirao piepaiveira, uva ita vearopai vosa oiso vo vovou purasa aueparo, oire voea rutu rera-ia rirova vai aveke vai kotoive iriai tuuoro rera okoearo-ia rera roko piesa riku rovu-ia. ");
INSERT INTO roo_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ari vosa vii iava vavaea raga vii kove pieive vore vuria, oire vo vavae tokori. Oa iava vearopai ra vava avau vao katai vavaea vore uva tootooa viapau opesipape. Oa iava viapau oiso avauverea vore opesipa tapi eto kasi-ia vo vavaerei rutuva. ");
INSERT INTO roo_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Vo uva aviko kare viapau opesipaave varaura aiopaoro, ora viapau rokopaive eto kasi voava. ");
INSERT INTO roo_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ari vosa vii iava kokoto vii kove pieve vuria purasa, ra va poturi. Oa iava vearopai ra katai kokotova avau vore uva tootooa viapau opesipape. Oa iava viapau vii vikiiverea vore opesipa tapi vo eto kasi-ia. ");
INSERT INTO roo_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Vo uva aviko kare viapau opesipaave varaura aiopaoro, ora viapau rokopaive eto kasi voava. ");
INSERT INTO roo_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ari vosa iravu vii iava osireito vii kove piereve vuria purasa, oire vearopai ra rera tateri. Oa iava vearopai ra kataitoava koatau vo Pauto vo Saraaro sovara-ia. Oa iava viapau vii vikiiverea vore opesipa tapi eto kasi-ia. ");
INSERT INTO roo_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Vo uva aviko kare viapau opesipaave varaura aiopaoro, ora viapau rokopaive eto kasi voava. ");
INSERT INTO roo_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Oire uva oirara rutu ruuverea eto kasi oiso osa aioara ruupaiveira avakara vara vearo piepaoro. ");
INSERT INTO roo_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Vearoa rutu avaka aioara vearo piepa. Ari vosa opesipe sipeia va iava, ra apeisi ragavira vorevira va sipei pieta ita. Oire oisi ita toupata visii vao-ia oiso osa avaka sipei vuutaaro. Osa ragavira ora vovou oavisii tokita kavevira visii rutu vearoa puraoro oiso osa avaka (sol).” ");
INSERT INTO roo_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jisas vo uruio kavuoro avaroepa Judia taere iare. Oa iava uukova Jodan-ia iviroreva. Uva riro irara vorevira voreaepa rera iare, oa iava voea rutu siposiporeva, uvare rera vo pitupituaro-a oirara rutu siposiposa. ");
INSERT INTO roo_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Uva Farisi-pa irara urioaepa rera-ia kokarasa oiso puraoro, “E vearopai oiso-ia vao-ia Reo Taisi, vosa iravu vatuava vaiaro kavu ovoireve?” ");
INSERT INTO roo_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Oire uva voea vo reoaro pukooro oiso puraroepa, “Ari aa vo reo goru reo vatereva Moses visiipa?” ");
INSERT INTO roo_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Oa iava rera aatoiva oiso puraoro, “Moses oiso puraroepa, Uvuipai vosa riakova kavuoro oavu rigatoreve reo ovoi, ra va-ia oira sigureve.” ");
INSERT INTO roo_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Oa iava Jisas oiso voea tavireva, “Ari ita, riro kaureo vovou irara visii, oa iava vo taisi vao reo taisi rigatoreva. ");
INSERT INTO roo_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ari ita, vo rasito rovo oaro-ia, uva Pauto oirato purareva ora riakova. ");
INSERT INTO roo_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Oire vearopai vosa viovokoto aitetoarei kavureve riako ouoro. ");
INSERT INTO roo_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ra kataivira rutu toupaoro vo tou-ia kataiua varaua purasi.’ Osa-a eisi osa iava viapau oiso toupasi vaiterei, ari oiso piesivoi kataiua-ia varaua toupasivoi. ");
INSERT INTO roo_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Vosa vaitereo aiterea pitu piereve Pauto vaiterei aivaro pieoro, uva viapau irai uvuipa ra vaiterei vorevira sikareve.” ");
INSERT INTO roo_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Uva vorevira koataaepa kepa sovara-ia ita. Oire uva voa disaipel rera akeiva vo reo iava. ");
INSERT INTO roo_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Uva voea tavireva oiso, “Ro ira riakova oaro kavu ovoireve iriavu raga ousa, uva va-a eva oa-ia otopa pitu purare iriavuva ita. ");
INSERT INTO roo_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ora vosa iriavu riakova oirato kavu ovoieve iravu ousa, eva-a oa-ia rerava otopa pitupitu purapaevoi.” ");
INSERT INTO roo_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Uva vao isivaaro iava kakae vureva urioaepa oiso ra voea-ia pitureve. Uva disaipel irara voeare korupaaepa. ");
INSERT INTO roo_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Oa iava Jisas voea kekeoro kasipuroepa. Uva oiso puraroepa, “Voea eakata oea kakae vure sipopai ragai iare. Opeita voeare korupata. Pauto vo Saraaro-a vao oa toupaivoi voeapa oiso osa voeao kakae vure. ");
INSERT INTO roo_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Oiraopavira rutu visii tavipaavoi, vosa irouto viapau oiso vo ruipaaro toupaive osa ro kakaeto ira vaopa ruipaparoveira Pauto vo Saraaro, oire uva rera-a eera ira viapau uvuipa oiso ra Pauto vo Saraaro sovara-ia toupareve.” ");
INSERT INTO roo_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Oa iava kakae vure oureva voea kaverukooro. Uva voea viraakosa voea rutu-ia vavaeareiaro tovoreva. ");
INSERT INTO roo_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Vo osa Jisas voka rovopareva vo raivaaro uva iravu rera iare ikaureva. Uva rekuoro rerare oiso puraroepa, “Tisa Vearoto. Eake vai puraa, ra Tootoo Ovoi oua?” ");
INSERT INTO roo_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Uva Jisas rera akereva oiso, “Apeisi iava ragai vaisipari oiso, Vearoto? Asi viapau iraiei vearotoa vai. Ari kataitoa raga Pauto Vearotoa rutu. ");
INSERT INTO roo_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Taraipau vao-ia Reo Taisi Pauto vaaro oa oiso purapai, ‘Opeita otopau, opeita oira upopau, opeita kavirupau, opeita oearovu iava kuuvupau, opeita oearovu keakeapari orekerovu karutupaoro, ora aiteara vaio ora aakoarapa avivikepau.’” ");
INSERT INTO roo_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Uva oiso Jisas tavireva, “Tisa, easi varao rutu oisoa tokipaa vova rovoaro osa kakaevira oisoa toupaa.” ");
INSERT INTO roo_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Oa iava Jisas rera-ia vurareva rerapa siraooro. Uva rerare oiso puraroepa, “Ari ita, vosa vearo vovou rutu purasa auepau, oire auero rutu-ia vii varaaro vori rovou vara-ia moni ouoro apota irarapa oarai vatesa. Eva-a oa iava uvuipau ra vearoa ouriverea vo vuvuiua. Oire ra uriou ragai sirova utuoro.” ");
INSERT INTO roo_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Uva vo reo-a vao oa-ia rera tavaka piereva. Oa iava rerare vovouisi vavataepa. Osa iava avaroepa, uvare riro vori guruto-a. ");
INSERT INTO roo_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Uva Jisas voeava vurapaoro ora poreroepa rera voeaaro disaipel tavisa oiso, “Ari ita, vavagisipapeira rutu voeaopa riro kotokoto guru irara vore ora kiusa Pauto vo Saraaro sovara iare.” ");
INSERT INTO roo_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Uva disaipel irara vo reo iava rera-ia tavetave iraopaiva. Oa iava Jisas oiso voeare puraroepa, “Kakae vure oaa oirara. Vavagisipai rutu voeaopa oea moni raga-ia rugorugoopaaveira vore koatapasa Pauto vo Saraaro-ia. ");
INSERT INTO roo_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ari ita, vavagisipai vao tavaatoa iava vo rito vosa rirova vai vo kare iava kamel kare iriai voa koatasa auepao. Ari ita, uva oisi rutu rirovira vavagisi iraopai ropa riro vori guruto vore koatapasa Pauto vo Saraaro-ia.” ");
INSERT INTO roo_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Uva tavetave iraopaive rera-ia. Oa iava oiso puraaepa rerare, “Uva apeisi-a. Iroutoa vai-a ira uvuipa Tootoo Ovoi ousa?” ");
INSERT INTO roo_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Oa iava Jisas voeava vurapareva tuupavira. Uva oiso puraroepa, “Viapau uvuipa oirato, ari Pautoa raga uvuiparoi irai oisiri avu pierevora, rera vo Saraaro iare koataro.” ");
INSERT INTO roo_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Uva Pita rerare oiso puraroepa, “Ari ita, igei auero oaio rutu kavuiovora vii sirova utupasa.” ");
INSERT INTO roo_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Uva Jisas rera vo reoaro pukooro oiso puraroepa, “Oiraopavira rutu visii tavipaavoi oiso, Viapau irai oaravu avu vaiaro rutu kavupare. Ari ita, vosa oiso-ia irai vara rutu kavureve oiso, kepa-a vao, ari araoko irara, ari taataa riako, ora aitetoarei ora aakova, ora kakae vure oaro, ora rasiara oaro rutu vo ragai tauvasa utuoro aue-ia tapo Vearo Siposipo, ");
INSERT INTO roo_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","rera-a eera ira riroara pute pievira rutu ourevere kepaara, ora araoko irara ora taataa riako, ora aite irara, ora rasiara oaro rutu, ora varao sirova tapo tavakaara vo voki-ia uva utupaua taru Tootoo Ovoi oupareverea. ");
INSERT INTO roo_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ari ita, uva voearo oea visii sirova oisoa utupaave, evoea oea visiipa iraaverea vo Pauto vo Saraaro sovara iare. Ovusa voeao oea visiipa oisoa irapaave, oea taru visii sirova utuaverea.” ");
INSERT INTO roo_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Uva vokapaoro raivaaro ipapaaepa Jerusalem iare vo osa Jisas voeapa iraparoepa. Oa iava rirovira tavetave iraopaiva disaipel irara, vo osa oearovu uriripaaepa oea tapo rera sirova utupaaepa. Oa iava rera voeaaro ragapa disaipel rovoroepa siposipooro varao iava oara karekepape utupaua rera-ia. ");
INSERT INTO roo_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Uva oiso puraroepa, “Uvuta! Ipaviei vore Jerusalem-ia. Uva voea ragai-a vao Oirato Oviitoaaro Ro Ropoto tovopaivere reipa irara vavaearo-ia pris irara ora voeao Reo Taisi-ia tarai irara. Oea reo ovoi puraivere oiso, Rera kopii pieta. Oa iava voeaopa ragai kosi pieivere osararovu iava voea. ");
INSERT INTO roo_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ra ragai akaipa piepaive, ora ragai-ia ruipaave, ora ragai ragipaive, ora ragai upoive. Oire vosa vo peva voki puteve, ra toreravere vorevira.” ");
INSERT INTO roo_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Uva Sebedi oviitoareiaro Jems araorei ora Jon uriosiepa oiso purasa, “Tisa, vaopa ruipapaveiei ra va purari vegeipa oa arepave vii ruvara-ia.” ");
INSERT INTO roo_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Oa iava oiso vaiterei akereva, “Eake-a vao oapa ruipapasiei ra va puraa veipa?” ");
INSERT INTO roo_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Uva oiso purasiepa, “Vegeipa vase ra irai pauro vo oirapapa varata oara-ia, osa irai vo koike varata oara-ia vovio uva tokipauveira turaropaoro vii vo goruaro-ia.” ");
INSERT INTO roo_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Uva Jisas oiso puraroepa vaitereire ovoovovira, “Viapau taraipasiei vao-ia oare arepasi. E uvuipasiei ra tavakao ousi oa oupaa o-ia ukaiooro kap iria agasipaoi aue iava siitoka? E uvuipasiei ra koatasi vo tavakao-ia oa-ia koataparai?” ");
INSERT INTO roo_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Oa iava oiso purasiepa, “Uvuipaveiei.” Uva Jisas oiso puraroepa, “O ita. Ukaiosivere o-ia iria-ia ukaioparai. Ora vo tavakao-ia tapo koatasivere oa-ia koataparai. ");
INSERT INTO roo_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Uva viapau oiso ragai vaaro-a ra vei pau piea varei-ia oiso, iravu oirapapa varata iava, osa iravu koike varata iava. Ari Pauto auearo-a ira aitereivu reesirevora, oa iva tavukiarei vatatoporevora vaitereipa.” ");
INSERT INTO roo_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Oire vosa katai tau disaipel va iava vao uvuiva, uva kasipuaepa vaitereire Jems araorei ora Jon. ");
INSERT INTO roo_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Uva Jisas keeraroepa voeareire oiso puraoro, “Taraipatai voeao-ia ratau tou irara oea vo kovoaro oiso toupaiveira, Oearovu oirara tokipasa. Oea ora rei vaisi piepaaveira voeare. Ora voea iava oearovu riro goruva toupaiveira oea oirarapa kovo vatepaaveira. ");
INSERT INTO roo_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ari visii viapau oisi eisi toupatavere osa evoea. Ari ro ira ruipaparo oiso ra rera raga ora rei piero visiire, eera-a ira taru visii tauvapaoro kovorevere. ");
INSERT INTO roo_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ari ro ira iraparo visiipa, eera-a kovopato oavisii vo utupaua. ");
INSERT INTO roo_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Oiso rutu osa urioraera vore. Uva viapau oiso kovopa irara vai ousa ora ragaipa, ari kovoa purapasa oeavu tauvapaoro. Ora vaore tapo ragai vo tootooaro vatepasa voea rutupa oirara voea vorevira voripaoro vuri vovou sovara iava.” ");
INSERT INTO roo_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Va isivaaro iava Jeriko-ia poua viropa. Oire vo osa vo uruio kavureva disaipel irara tapo, ora oearovu riro irara, uva iravu voosito Batimias ro oviitoaaro Timias ira raivaaro pauroepa arepaoro. ");
INSERT INTO roo_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Uva Jisas ro vova Nasaret ira iava uvureva. Oa iava rerare keeraroepa oiso purapaoro, “Jisas Devit Oviitoaaro. Ragaipa siraou.” ");
INSERT INTO roo_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Oa iava riro irara rerare reopaaepa oiso purapaoro, “Auoro, ora tape pieu,” osa keeraroepa ita rirovira rutu. Uva oiso puraroepa ita, “Vii Devit Oviitoaaro. Ragaivipa siraou.” ");
INSERT INTO roo_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Oa iava Jisas voka tuuke piereva oiso puraoro, “Rerare keerata.” Uva rerare keeraaepa voosito oiso, “Toreu, ra roruri, uvare viire keerapa.” ");
INSERT INTO roo_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Osa iava varo rakuraku veraoro tokaoro toreroepa Jisas iare uriooro. ");
INSERT INTO roo_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Oa iava Jisas rera akereva oiso, “Eake vaipa ruipapau ra oai puraa viipa?” Uva oiso puraroepa, “Tisa, ragaivi vura pieri vorevira.” ");
INSERT INTO roo_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Uva Jisas rera tavireva, “Ora poreu ra avau. Aue iava uvare vii raga vaaro oirao piea vii vorevira ravotovira porete pie ovoivoi.” Oa iava vearovira vura ovoirevoiva, Jisas sirova utu ovoiroepa raivaaro. ");
INSERT INTO roo_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Uva tutuu pieiva vokapaoro Jerusalem iare. Oa iava Betfasi urui-ia poua viropa ora Betani-ia vo uva Oliv Kovo Pukui toupaiveira. Oa iava Jisas voava aitereivu arureva voea iava voeao katai tau erao (12) disaipel. ");
INSERT INTO roo_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Uva oiso vaiterei tavireva, “Vavo oiso avasi vavo uruio-ia. Vosa karesi virovere voa, ra gareva vai kekesi donki iria tuu iro riara-ia toupaevoi, o iria-ia viapau irai vokapareva uvare koruova. Ra oira karusi, ra oira ivupaoro uriosi. ");
INSERT INTO roo_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Vosa irai vei akepareve oiso, Eakere purapasi? Ra rera tavisi oiso, Iria-ia Turaro vo kovoaroei. Iria vore pierevere rara.” ");
INSERT INTO roo_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Oa iava avasiepa. Uva oira donki kekesiva kakaeva osa tuu iro-ia toupaeva kepa rataoaro riaaro-ia vo raivaaro. Oire uva oira karusiva. ");
INSERT INTO roo_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Vo ovusa oeavu voa toupaoro vaiterei akepaiva oiso, “Eakere eira donki karupasi?” ");
INSERT INTO roo_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Uva voea tavisiva oiso osa Jisas vaiterei tavireva. Osa iava vaiterei iava vaseiva vorevira. ");
INSERT INTO roo_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Oa iava oirava voresiepa donki vore Jisas. Oa iava oira ivara-ia varoara tovoiva varao oara-ia pauroepa. ");
INSERT INTO roo_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Uva vo voki-a vao oa-ia riro irara rutu varoara oaive-ia urupaiva raiva-ia, osa oearovu evaoara tosipaiva vegoaro vara tovopasa raivaaro rera-ia rorupaoro. ");
INSERT INTO roo_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Oire uva oearovu irapaaepa osa oearovu ita utupaaepa. Oearea rutu rerava rorupaoro kaku piepaiva oiso purapaoro, “Hosana! Vigei Kae Pietoaaro! ‘Pauto ira viraakopare ro-ia ira uriopa vo Turaro Pauto goruaro sovara-ia.’ ");
INSERT INTO roo_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Rera-ia vuurapa vaisi purape, eera ira turarorovere oiso rutu osa Devit ro vigei aaotoaaro ira turaroroepa. Vuurapa vaisi purape Pautoa-ia, Reitoa rutu. Hosana vore viara-ia Pauto!” ");
INSERT INTO roo_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Uva Jisas karero viropa vo Jerusalem. Uva voa koataroepa Rovopa Kepa-ia Tugoropa Kepa Tempel. Uva voa orekerovu rutu vuravurareva. Oa iava vorevira Betani iare katai tau erao (12) disaipel tapo kareroepa, uvare ravireo rokosa aueroepa. ");
INSERT INTO roo_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Oa iava vokiaepa Betani iava voreoro. Uva vo voka-a vao oa-ia ogoeroepa. ");
INSERT INTO roo_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Uva oevavu fik ova evaova kekereva tauaivi, riro guruva ova rutu. Oa iava vo eva iare urioroepa oiso ra voava kueara vai oureve. Uva vo evao-ia pou virooro kasikasiroepa vura ragaoro, oiso ra kuea vai kekereve osa guruvara raga oisoa voa toupaive. Aue iava uvare kuepa vuuta-ia viapau tuguraaepa. ");
INSERT INTO roo_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Oa iava Jisas vo evare oiso puraroepa, “Viapau irai vii kuearo aiopareverea vokiara rutu-ia.” Vo osa rera voeaaro disaipel rera uvuiva. ");
INSERT INTO roo_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Uva urioaepa vore Jerusalem-ia Tempel-ia koatasa. Uva oeavu oirara sigureva osa uupaaepa voa orekerovu-ia ora tuutuupaoro vo Tugoropa Kepa sovara-ia. Uva tebolara petopetoreva voeare oea ora tuutuupaaepa aue-ia moni, ora paupara oaive voeao oea kurue kare-ia ora tuutuupaaepa. ");
INSERT INTO roo_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Uva voeare korukoruoro rutu goruvira oiso puraroepa, “Viapau rutu oiso ra ora visii varaarova oapara oavisii vo Tugoropa Kepa sovara-ia ora putepata.” ");
INSERT INTO roo_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Uva va isivaaro iava voea siposiporeva oiso puraoro voeare, “Tugoropa Vuku oiso purapapeira, ‘Ragai vo Kepaaro-a vao oa oiso vaisipaiveira, Variripa Kepa.’ Ari visii vo kepao oiso piepata, vataupa tapi kavirupa irara vaaro.” ");
INSERT INTO roo_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Uva voeao pris reipa irara ora voeao Reo Taisi-ia tarai irara oea vo reo uvuiva. Oa iava raiva taraapaaepa oiso ra rera upoive. Aue iava uvare rera uriripaiva, uvare oearovu rutu tavetavepaiva rera vo siposipoaro-ia. ");
INSERT INTO roo_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Oire vo osa vokiaroviepa voeare, oa iava kosia viropa voava vo riro uruia-ia. ");
INSERT INTO roo_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Oire uva vokipaua avaaepa. Uva voa avapaoro fik ova kekeoro puteva osa raveraveepa vo eva vavurupaaro tapo. ");
INSERT INTO roo_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Oa iava Pita Jisas vo reoarore rugoooro oiso puraroepa, “Tisa. Vao kekeri fik ova oevare ovoieivira reouerao. Oa iava erakoerao.” ");
INSERT INTO roo_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Oa iava Jisas rera vo reoaro pukooro oiso puraroepa, “Pautoa-ia oirao pie vovouro oavisii tovota. ");
INSERT INTO roo_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Oiraopavira rutu visii tavipaa, Vosa oirao pie vovou rutu purapata vakuvaku asavira, oire ra vaore pukuia oiso purata, Toreu ra ora vikiu eisi avakava. Oire ra oisi pieive, vo rara evo reo oirao piepata rutu. ");
INSERT INTO roo_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Osa-a eisi osa iava visii tavipaa oiso, Vosa variripata orekerovure arepaoro, oire ra vara oirao piepata, ra vara oupata. ");
INSERT INTO roo_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","“Oire vosa torepata variripasa, ari vosa iravuva ora aveaveu, oire va eaka pie rovori. Oisore ra vii vaaro vuri vovou verareve Aite oavisii ro vova vuvuiua. ");
INSERT INTO roo_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ari ita, vosa viapau oiso iravu iava viapau oiso vuri oaro vera rovori, ra viapau vii Aitearo vii iava vuri oara verareve ro ira vuvuiua-ia toupareveira.” ");
INSERT INTO roo_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Uva va vao isivaaro iava voreaepa Jerusalem iare. Uva voa Tempel sovara-ia vokapaoro urioaepa Jisas iare voeao Reo Taisi-ia tarai irara, ora pris reipa irara, ora oira vasi irara. ");
INSERT INTO roo_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Oa iava oiso rera akeiva, “Eake reesi-a vao vii vaaro oa iava vo kovo purapari? Irou vii vateva vo reesi?” ");
INSERT INTO roo_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Oire uva Jisas voeare oiso puraroepa, “Visii akea ra ragaipa vo reo vituaro pukota. Ra visii tavia ita vo reesi iava oa-ia varao purapaa. ");
INSERT INTO roo_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Oire e baptaisa vao Jon oa puraparevora, ovuva vo reesia oa urioera Pauto ruvara-ia, eke vova oiratoa raga? Oire ita ragai tavita.” ");
INSERT INTO roo_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Uva ora rugorugoo piepaaepa oiso, Apeisi avu purapaviei. Vosa oiso puravio, Vova Pauto, ra oiso purarovere, Uva apeisi viapau va oirao piepata? ");
INSERT INTO roo_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ari vosa oiso puravio, Oirato vaaro. Uva ora voea ragapa uriripaaepa, uvare voea rutu oirara oisi taraipaaepa oiso, Rera-a ro profetatoa rutu. ");
INSERT INTO roo_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Oa iava oiso purapaaepa, “Viapau taraipaiei.” Uva Jisas voea tavireva oiso, “Ragai tapo ita, viapau oiso ra visii tavia vo reesi iava oa-ia vo kovo purapaavora.” ");
INSERT INTO roo_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Uva rovoroepa voeapa siposipopaoro aue-ia ovoovo reoro oiso, “Iravu wain kovo paureva. Uva vo kovo rirore kasura purareva. Oa iava rikui tekareva auepa pigipava masin gerep. Uva voa kepa paureva uutupa kepa vo kovo-ia. Uva oeavu kovopa irara tavireva auere ra vo kovo tokipaive moni oupaoro ora rerapa. Oire uva va-a vao oa iava avaroepa otaerevu iare uvavu. ");
INSERT INTO roo_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Uva oivavu-ia iravu kovopato rera reraaro siporeva, oiso ra kovoa iava kuearoa vai oureve voea ruvara-ia vo kovo tokipa irara. ");
INSERT INTO roo_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Oa iava rera rauiva. Uva rera ragipaivoiva, viapavira rera siguiva vorevira. ");
INSERT INTO roo_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Oire uva iravu ita ava piereva ita. Oa iava rera kukuearo gagoagoiva rera tapatapaoro. Uva rera vuri pieiva. ");
INSERT INTO roo_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Oa iava iravu ita arureva ita. Osa iava rera kopii pie ovoiiva. Uva oisi raga oisoa piepaive oiso oearovu oisoa ragi ragapaive, ari oearovu oisoa kopii pie ovoipaive. ");
INSERT INTO roo_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Uva kataitoaviei ira toupare rera oviitoaaro, ira oisoa kavikopareve rutu. Oa iava ovoiokuvira rera utu piereva ita voea iare oiso rugoopaoro, Ira vai-ia taru gisipoaro uvuivere oviitoa oaa. ");
INSERT INTO roo_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Oa iava oiso ora reoaepa voea voeao oea oisoa kovoa tokipaive, Rera ro-ia reito oviitoaaro rutu. Irare ra rera upope. Ra rera vaaro ouoro vo kovo vao tokipe ora vigeipa. ");
INSERT INTO roo_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Oa iava rera rauiva rera kopii pie ovoisa. Oire wain kovo sovara iava vo kopii kosi pieiva.” ");
INSERT INTO roo_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Uva vo reo-a vao ovoovo reoa oa iava oiso akereva Jisas, “Uva eake vai purarevere ro ira vo kovoaro-a vao-ia wain kovo? Oire uva ro ira uriorovere voeao vo kovo tokipa irara opesi piesa voea rutu kopii pieoro. Oire ra ita oeavu raga ita tovo piereve vo kovo tokipasa ita. ");
INSERT INTO roo_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","E viapau vo reo vieitavora Tugoropa Vuku-ia oiso, ‘O-ia aveke iria veraiva voeao kepa paupa irara oira-ia kepa pau arapa, eira rutu ita avekeva rovopava rutu kukuuvu tuuta. ");
INSERT INTO roo_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Easi, vo kovo purareva Turaro, oa vigei osireiaro-ia ravotovira toupaiveira’?” ");
INSERT INTO roo_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Uva oiso ruipa ragapaaepa ra Jisas ouive rera kortusa voeao reipa irara Jiu iava. Ari ita, oeavu ragapa oirara uriripaaepa, uvare oiso taraipaaepa, Asi vao ovoovo reo vigei togapare vo-ia. Uva rera kavuoro avaaepa. ");
INSERT INTO roo_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Uva va-a vao oa iava oeavu Farisi ora voeao tapo King Herot tauvapa irara oea sipoiva rera iare oiso ra ora rera oaiaro-ia ora rera raga ora kove piero. ");
INSERT INTO roo_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Uva evoearei rutu urioaepa. Oa iava rerare oiso puraaepa, “Tisa, taraipaiei vii-ia, uvare vii-a oiraopa reotoa rutu. Ari vaeavira rutu voea rutu siposipopari vo Pauto vo pitupituaro iava. Oire uva apeisi-a? E torevokopai ra Sisa-pa takisvio moni vateoro, eke viapau?” ");
INSERT INTO roo_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ari ita, tarai ovoiroepa voea vo kuuvuaro-ia. Uva voea akereva, “Eakere ragai-ia kokarapatai? Oire ragai vateta moni isi vai ra aisi eveia.” ");
INSERT INTO roo_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Uva aisivu vateiva. Uva voea akereva oiso, “E irou puaaro-a vao-ia vo kiro-ia?” Uva rera taviiva, “Ari Sisa.” ");
INSERT INTO roo_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Oire va iava oiso puraroepa, “Vosa Sisa varaaro, oire Sisa-pa vara vateta. Ari vosa Pauto varaaro, oire Pautoa-pa vara kare pie iraota.” Oa iava vo reo iava rirovira rutu rugorugoo iraopaaepa. ");
INSERT INTO roo_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Uva Sadyusi-pa irara urioaepa rera iare voeao oea oisoa viapau kopiia torearo iava oirao piepaive. Oa iava oiso rera akeiva, ");
INSERT INTO roo_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Tisa, Moses oiso igeipa rigatoroepa, Vosa irai araokotoa vaiaro kopiiro, vo osa riakovaaro toupaeve kakae pura asavira raga. Ra ita araokoto oira oureve rerapa ro kopiito oira-ia kakaeto purasa. ");
INSERT INTO roo_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Uva erao vatara oaraovu oea oisoa toupaive. Oea iava avaioto riakoparoepa. Oa iava oira arova kopiiroepa osa viapau kakaetoa vai. ");
INSERT INTO roo_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Uva ro kikooto oira ita oureva. Uva kopiiroepa ita, osa ita viapau kakaetoa vai. Uva peva piepato oisi raga pie ragareva ita. ");
INSERT INTO roo_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Uva oisi raga piepaoro oira arova opesiaepa vo arao rutu erao vatara, osa viapau kakaetoa vai kavaupaive. Uva utupaua vo arao isivaaro iava kopii ovoiopa. ");
INSERT INTO roo_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Oire uva vo vokio-ia oa-ia oirara rutu toreaverea vova kopiia-ia, uva irouto vo arao iava oira oureverea? Uvare voea voeao erao vatara rutu oea oira ouiva.” ");
INSERT INTO roo_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Oa iava Jisas voeare oiso puraroepa, “Rugorugooara oavisii pirovira avapai. Aue iava uvare viapau taraipatai aue-ia Tugoropa Vuku vo rigatoaro ora goruaro Pauto. ");
INSERT INTO roo_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Vo kopiia iava torea-ia viapau oiso riako ou vai, uvare viapau ora oupaaverea. Viapau. Ari oisi rutu oiso toupaiverea osa enselpa irara vo vuvuiua-ia. ");
INSERT INTO roo_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“Oire ari voeao-ia kopii irara vosa toreave vorevira, uva viapau voea iava vieipataera vo siposipo-ia oa-ia gare kairi evaoa rovaepa. Osiposipo-ia Moses tavireva Pauto oiso, ‘Ragai-a Pautoaaro Ebraham, ora Pautoaaro Aisak, ora Pautoaaro Jekop?’ ");
INSERT INTO roo_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Oire vo Pauto vo rugorugooaro vuraaro-ia voeao tootoovira toupai oea kopiiaepa. Oa-a vao oa iava oiso puraroepa, Ragai Pauto oaive voeao oea tootoopai. Ari rugorugooara oavisii viapau oiso torevokopai.” ");
INSERT INTO roo_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Oire uva iravu urioroepa Reo Taisi iava siposipopato voea uvusa osa ora akepaaepa. Uva Jisas vo reoaro eveireva osa voea vo reoroaro pukopareva. Osa iava rera akereva oiso, “Aa vao-a rovopa rutu Reo Taisiro rutupa?” ");
INSERT INTO roo_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Oa iava Jisas rera vo reoaro pukoreva oiso puraoro, “Vao-ia rovopa rutu Reo Taisi oa oiso purapapeira, ‘Isrel-pa irara uvuta. Ro-ia Turaro Pauto oavi, rera raga ira turaroparoveira. ");
INSERT INTO roo_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ira-ia sopaura oavisii rutu tovota, ora rugorugooara oavisii rutu, ora taraiara oavisii rutu, ora goruara oavisii rutu.’ ");
INSERT INTO roo_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ari erao piepa vao-ia oiso, ‘Voeaopa oea vii ruvara iavi toupaiveira siraopau rutu, oiso rutu osa ora viipa siraopauveira.’ Viapau oiso oarai Reo Taisiro vai vareo-ia putepaiveira.” ");
INSERT INTO roo_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Uva Reo Taisi-ia taraito rera tavireva, “Oiraopavira Tisa. Ari kataitoa raga Turaro Pauto. Uva viapau iraiei turaro vai oiso osa ro-ia. ");
INSERT INTO roo_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Uva vosa rera-ia vii iava sopaua rutu tovori, ora rugorugooara rutu, ora vii vaaro gorua rutu, ora vao tapo-ia oiso ra iravupa siraopau oiso osa ora viipa siraopauveira, oire uva vara-a varao oara koruoupa pitupitu-ia putepaiveira, opitupitua-ia oisoa koruoupa kare riipu piepaiveira.” ");
INSERT INTO roo_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Uva Jisas rera-ia tarairoepa uvare vearovira rera vo reoaro pukopareva. Oa iava rera tavireva oiso, “Viapau oiso tauaipauei Pauto vo Saraaropa.” Osa-a eisi osa iava voea rutu uriripaaepa Jisas ake arapa vorevira. ");
INSERT INTO roo_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Vo osa Jisas siposiporeva Tugoropa Kepa-ia Tempel, uva oiso puraroepa, “Easi eake iava Reo Taisi-ia tarai irara oiso purapaai, Asi Krais Devit aaotoaaro ro vo rasio raga iava. ");
INSERT INTO roo_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Aue iava ita uvare rera raga Devit vatereva Tugoropato Uraurato vo rugoo oa iava oiso puraroepa, ‘Turaro Pauto ira oiso puraroepa rore ragai Turaroaro, Pauu vo oirapapa varata vao-ia vo vuutaore tuepaoro oa-ia vii voeaaro keripa irara tovoaverea vii kokotoaro reroaro, vo rara voea-ia puteri.’ ");
INSERT INTO roo_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ari ita, Devit raga ira turarovira Krais vaisireva. Uva apeisi-a, Krais rera aaotoaaro Devit ira Devit sirova kavauroepa?” Uva riro uvuru rera vo reoaro roruvira uvuiva. ");
INSERT INTO roo_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Uva voea siposipopaoro voea tavireva oiso, “Ora vatatopopata evoeapa Reo Taisi-ia tarai irara oea vearopara-ia kuvupaai kuvupara varoara, ora oiso uvare vaopa tapo ruipapaaveira, oiso ra oearovu oirara voeapa ora avivikepaoro oiso purapaave, Vearo voki voeare vo aivaropa tapi. ");
INSERT INTO roo_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ora oiso tapo osa varaopa ruipapaaveira rovopara paupara varao Reo Taisi Uvupa Keparo sovara-ia touara. Ora varaopa tapo vasivasi tapiro roro pie visivi vo vureipa vokiro-ia. ");
INSERT INTO roo_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Evoea oea auero ou ragapaiveira raroe riako varaaro, ra kuuvuvira riro kaekaepavira variripaaveira ita. Evoea ita oea riroa siitoka ouiverea. Va-a eva vuri oaive voriaro oearovu rutu varaaro-ia oara putepaverea rutu.” ");
INSERT INTO roo_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Uva ipa pie visivi pauroepa Jisas vo moni oupa tapi. Uva voea siituepareva osa moni vikipaaepa voa. Uva voeao riro moni irara oea tapo riropara moniara vikipaiva. ");
INSERT INTO roo_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Osa-a eisi osa iriavu urioopa raroeva apotavavi. Uva aisireivivu vikieva moni isirei gare isireivi bokis iare. Uva ora takuvuepa, uva aue raga-ia uvuipaepa katai tau toea (10t). ");
INSERT INTO roo_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Uva disaipel irarare keeraroepa ora rera iare. Oa iava voea tavireva oiso, “Oiraopavira rutu vikioi apotavavi ita voeao-ia puteoro oea riropa moni vikipai. ");
INSERT INTO roo_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ari ita, voea rutu vikiae riroara iava ita, osa oiravi ita iria ora oira iava sopaua rutu tapo vikievo oa-ia oearovu rutu-ia puteevoi.” ");
INSERT INTO roo_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Uva kosiro viropa vova Tempel, osa iravu voea iava disaipel rerare oiso puraroepa, “Tisa kekeri. Vearopara-ia avekeara ora vearo keparo-ia.” ");
INSERT INTO roo_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Oa iava Jisas voeare oiso puraroepa, “O ita, oara kekepata riropa keparo. Ari viapau iriai aveke vai eakave iriai ivara-ia aveke vai osa toupaive. Oara rutu evara kururu piroverea koveoro.” ");
INSERT INTO roo_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Uva-a vo uva pauparoepa Jisas vo pukuio-ia Oliv Kovo Pukui aueva Tempel tuuravira pauparoepa, osa rera akepaiva vatau visivi voeao Pita vase, ora Jems, ora Jon aue tapo Andru. ");
INSERT INTO roo_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Igei taviri. Aa vo vokio ora purapere vara varao, ora eake ravaa reesiro-a oara ora purapere vara-ia?” ");
INSERT INTO roo_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Uva Jisas oiso puraroepa voeare, “Vatatopopata. Teapi visii piro piereve oiratoa vai. ");
INSERT INTO roo_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Riro irara rutu uriopaaverea ragai vaisiaro-ia, ra oiso puraave, Ragai-a vao Krais. Ra riro irara vai keakeapaive oirara vai. ");
INSERT INTO roo_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Vo osa upoara siposipoaro iava uvutavere varao oara tauai toupaive visiipa ora tutuu pievira visiipa, ra viapau oiso uriripata. Uvare vara-a varao oara pou piroverea taru. Uva viapau oiso vara varao opesiapa tutuu piepai, ari orekerovu urio rovopapere ");
INSERT INTO roo_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","oiso-ia, osararovu osararovuva ora upoaverea. Ari gavman tapo ora rera ragava aia ita gavman ora uporoverea. Ravurikepaperea otaererovu-ia, ora ogoepa vokiro oara poupa piroverea voraro rutu. Uva vara rutu-a varao oara-ia siitoka rovoaro pura piroverea. ");
INSERT INTO roo_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Voeaopa vatatopo iraota oea visii vateiverea auepa Kaunsel irara oea visii ragipaiverea vo keparo-ia Sinagog keparo. Ora oiso tapo osa visii tore piepaiverea vo reipa irara osireiaro-ia, ora vo king irara osireiaro-ia, uvare ragai sirova utupataveira. Uva voea-a voeao turaro irara oeapa tavitavipatavere ragai vo kovoaro iava. ");
INSERT INTO roo_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ari ita, vo osa Vearo Siposipo uvu rovoiverea oirara rutu osararovu rutu iava. Oa isivaaro iava taru Opesi Voki pou piro. ");
INSERT INTO roo_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Vosa visii sipopaiverea voeapa oea visii rovirieipaiverea kortua-ia. Oire uva opeita uriripata oiso rugorugoopaoro, Apeisi purapaiei voea vo reoroaro pukopaoro. Rera raga visii vatereverea eva oa iava tavitavitaverea. Viapau oiso visii-a visiigoa reoreotaverea, ari Tugoropato Uraurato vo visii gisipoaro-ia. ");
INSERT INTO roo_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Oiso-ia tapo, iravu araokoto vatereverea vore gavman vavaearo iare, oiso ra rera kopii pierevere. Ora aiteto oviito vatereverea iravupa ra rera kopii pierevere. Ari ovii irara aite irarava keriaverea ra voea upoive. ");
INSERT INTO roo_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ari ita, oirara rutu visiire vuri vovou iraopaaverea, uvare ragai vaisiaro-ia toupataverea. Ari ro ira goruvira rutu Pautoa-ia rugooa tovopareve vo tugurasa Ovoipa Voki-ia, eera-a ira taru oureverea Pauto ora rera vo Saraaro iare. ");
INSERT INTO roo_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Vosa vao keketaverea oa uvuipai riroa vuria pura iraopasa aue-ia Tugoropa Tapi, oire ra uriripaoro torita visii vao Judia-ia tou irara pukuiara iare. Ari ro ira vao vieipareve, oire tarairo va-ia vao. ");
INSERT INTO roo_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ro ira kepa ivara-ia toupareve, viapau oiso uvuipa ra vararo oavu avu vai ousa vo kepa oaro-ia. ");
INSERT INTO roo_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ro ira toupareve varuparo, viapau uvuipa ra ora rakurakupaarore vorero varoa. ");
INSERT INTO roo_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ari vo riakovio airoa tarukovira toupaiverea, oriakoa sirao iraoaverea tavaka ouoro, ora vairo sikeo kakaero roroopa riako vo voki-ia. ");
INSERT INTO roo_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Variripata. Oa iava viapau pou piroverea vo tavakaro varao vo kiuvupa vuuta-ia. ");
INSERT INTO roo_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Oire vo vokio-ia oa-ia rasito rovoreva Pauto vo vokio-ia pou virosa vao-ia, uva varei sovara-ia vareo viapau oiso oavu avu vai tavaka vai vareo sovara iava oai vo tavakao-ia putepai oa urioperea utupaua riroa rutu. Oire ita vara isivaaro iava varao viapau oiso otavakai ita urioperea oiso osa vo tavaka vao-ia. ");
INSERT INTO roo_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Vosa viapau rugorugooparoeri Pauto vo vuutao poteku piesa, ra viapau oiso iraipe tootoovira toupaoro. Ari voea ragare rugoooro vo vuuta poteku piereverea voeao oea roporeva ora rerapa. ");
INSERT INTO roo_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Vosa irai visii tavipareve oiso, Ro keketa Pauto reraaro Ropoto. O ita, Rera keketa ro, oire ra viapau oiso rera vo reoaro oirao piepata. ");
INSERT INTO roo_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Riro irara rutu krais irara kuuvu irara oea urioaverea. Ora riro irara profet irara kuuvu irara oea ravaavira oreorovu puraiverea ora ravoto kovoro. Oara-ia voeao piro pieiverea vosa uvuipaave voea oea roporeve Pauto. ");
INSERT INTO roo_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ari ita, visii vatatopo piepaa varao iava visii tavitavi rovopaoro. ");
INSERT INTO roo_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Uva tavakapa vuuta isivaaro iava ravireo ruparoverea ora kekira tapo. ");
INSERT INTO roo_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Aaviikoara kovekoveperea vova vuvuiua iava. Orekerovu rutu goruara vova vuvuiua ravurikeperea. ");
INSERT INTO roo_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Vo voki-a vao oa-ia ragai Oirato Oviitoaaro tueiverea oirara rutu, ovusa iriavu rukuta sovara-ia uriora riroa rutuva gorua ora riroa ragai vaaro keraria. ");
INSERT INTO roo_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Uva voea aruaverea enselpa irara oaa, ra voea guruive voeao oea roporeva ora rerapa voraro rutuva vo rasito rekasiaro-ia. ");
INSERT INTO roo_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Oire uva vo evao fik ova taraitavere rara rovovira airepa guruvaro kosi pieve rovo guruvaro. Ra oiso taraita, Raipipa vuuta tutuu piepai oa-ia ravireo rororovere. ");
INSERT INTO roo_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ari ita, visii tapo varao iava taraitaverea vara kekeoro, ra oiso aueta, Ragaipa karepa vuuta tutuu pievoi. ");
INSERT INTO roo_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Oiraopavira visii tavipaavoi, Oirara rutu voeao vo vuuta-ia eva viapau oiso voea rutu kopiiaverea vo osa vara rutu evara kareke rovoperea. ");
INSERT INTO roo_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Oire oiso-ia vuvuiua opesiperea ora rasito, ari ragai vo reoaro viapau rutu oiso opesiperea. ");
INSERT INTO roo_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Uva viapau irai taraiparoi vo voki-ia ora vo aua-ia. Ora enselpa irara tapo voeao vo vuvuiua oea viapau taraipaai. Ora Oviitoaaro tapo viapau taraipa. Ari Aitetoa raga Pauto ira karepa voki rutu-ia taraipa. ");
INSERT INTO roo_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Vearovira rutu uutupata. Uvare viapau taraipatai vo vuuta-ia vao oa-ia urioperea. ");
INSERT INTO roo_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Oiso rutu osa iravu aapaapauroepa ouruivu iare kepaaro kavuoro. Uva kovoara rovirieireva kovopa iraraaropa. Uva goruvira rutu ratao tokipato tavireva oiso ra vara rutu tokipareve. ");
INSERT INTO roo_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Oire visii vao vatatopo iraopatai tuepaoro, uvare viapau taraipatai rera-ia eera reito ira voreroverea rera vo kepaaro kekesa ovaiaro eke voki vuuta-ia, eke vosa kookai kare gaupaive, eke vokipaua. ");
INSERT INTO roo_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Teapi visii sita piesa urioro visii kekeoro osa uusipata. ");
INSERT INTO roo_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Uva va-ia vao visii tavipaa ravaavira ora oearovu rutu, ra ora vatatopopata rutu.” ");
INSERT INTO roo_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Oire uva reipa irara pris irara ora Reo Taisi-ia tarai irara oea raiva taraapaaepa ora voea-ia, oisore ra oa-ia kaviruvira rera rauive. Ra rera upoive vo vokireo isivaaro iava, ovokirea-ia aioa pura pirovere Pasova Vurei ora oaiorovu Yis Asa Aioro aue Bret. ");
INSERT INTO roo_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Oire uva vo voki-ia rugoopaoro oiso ora reopaaepa, “Teapi vo vokiro raga-ia varao oara-ia aioara purapa pirovere rera-ia pituera, oearoi ora sitaoro kasipuave vigei uposa.” ");
INSERT INTO roo_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Uva Jisas toureva Betani-ia ro leprapato vo kepaaro-ia Saimon. Uva voa pauroepa aiopaoro ovusa iriavu riakova urioopa aueva korovo ovi sanda, oovia vaisipai oiso, nad. Oa oisoa purapaive aue iava airepa ruu piero. Oa toupaiva aue-ia popotepa tou vearoa Alabasta oiso osa aveke. Ipa pie vori ovi oava urioopa. Uva vo ovi keeva, oa iava va kokoeva Jisas kukuearo-ia. ");
INSERT INTO roo_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Uva oearovu oiso ora reopaaepa kasipupaoro, “Apeisi o vao ropi ragapae korovo ovi? ");
INSERT INTO roo_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ari uvuipaoi ra va-ia monia vai oueve korovo ovi vo peva vovoto kina (K300), ra oai vateeve voeaopa apota irara.” Uva ora reopaaepa rirovira rutu oirare kasipupaoro. ");
INSERT INTO roo_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Oa iava oiso puraroepa Jisas, “Oirape, ra va puraeve. Eakere oira vovouaro vavata pie ragapata? Vearo pitupitu rutu purapae ragaipa. ");
INSERT INTO roo_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ari ita, apota irara oea toupaiveira touvira rutu visii tapo vokiara rutu-ia. Vosa oisi voeapa oaravu tauvaara purasa ruipapata, uva uvuipatai oisi eisi purapasa. Ari ragai viapau oiso visii tapo toupaavere touvira. ");
INSERT INTO roo_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Oira o iria va puraevoi oiso osa uvuioi va purasa. Iria ita ragai iava varaua atoato rovoevo ravaavira korovo ovi-ia, auere vava ragai tovasa. ");
INSERT INTO roo_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Oiraopavira rutu visii tavipaavoi, Vo uvarovu rutu uva Vearo Siposipo kosi piepaiverea vo rasio-ia, ra va-ia vao tapo ora reopaave vare rugoopaoro oa puraevoi o-ia riakova ragai-ia.” ");
INSERT INTO roo_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Uva iravu voea iava katai tau erao (12) disaipel ro Judas Iskariot ira avaroepa reipa irara iare pris voea ravaavira tavisa, “Visiipa Jisas kosi pieavere.” ");
INSERT INTO roo_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Uva Judas vo reoaro uvuoro roruiva rutu. Oa iava ovoivira rera taviiva aue iava moni. Osa-a eisi osa iava ora rerapa raiva taraaroepa, oiso ra Jisas kosi piereve voea vavaearo iare. ");
INSERT INTO roo_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Uva vo rovo vokiaro-ia Yis Asa Aio aue Bret oa-ia sipsip kakae-ia koruoua oisoa puraive. Oa iava vo vokia vao disaipel irara Jisas akeiva oiso, “Ovu-ia viipa ravaavira aioa vai puraiovere Tagausapa Aio Pasova Aio vai?” ");
INSERT INTO roo_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Uva disaipeltoarei arureva oiso, “Karesi viro urui iare. Vosa iravuva aivarosivere osa uuko ovi vai kaepareve rirova-ia pitokava, ra rera sirova utusi. ");
INSERT INTO roo_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Uva iravu vo kepaaro koatarovere. Oire ro ira vo kepaaro-a irare oiso purasi, Ro-ia Tisato ira oiso puraroi, Ovu-ia ragai vo tugiaro epao tavete tugi uva Pasova Vurei aioavere disaipel irara oaa tapo? ");
INSERT INTO roo_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Uva vei kareke pierevere riro tugia oa toupai ravaavira vo viara-ia. Uva voa aioara ravaasivere vigei rutupa.” ");
INSERT INTO roo_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Uva disaipeltoarei karesi viropa urui iare. Uva va kekesiva vao oare Jisas taviroepa. Oa iava voa Pasova Vurei vatatoposiva. ");
INSERT INTO roo_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Uva vokiarovi pouro viropa Jisas ora katai tau erao disaipel. ");
INSERT INTO roo_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Oa iava aiopaiva osa Jisas voeare oiso puraroepa, “Oiraopavira visii tavipaa, Iravu visii iava ira ragai kosi pierevere oearovupa.” ");
INSERT INTO roo_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Oa iava vovouisiro rutu vavataepa voeare siraooro. Uva voea rutu oisi raga puraaepa, “Easi viapau ragai-a?” ");
INSERT INTO roo_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Oa iava oiso voea tavireva, “Ro katai tau erao iava disaipel, ira vavae roko piere breteva tapi rovu viipaoro va-ia ragai tapo, eera-a ira ragai kosi pierevere. ");
INSERT INTO roo_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Iu, Oirato Oviitoaaro avapa kopiia-ia oiso osa Tugoropa Vuku taviepa ragai iava. Ari ita, siraovira rutu rerapa ira ragai kosi pierevere. Vearopai ita vosa viapau aakova rera kavau rovoevori.” ");
INSERT INTO roo_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Oire vo osa aiopaiva uva Jisas bret oureva va-ia vearo vaisi purasa. Uva va puteputeoro vara vatereva voeapa oiso puraoro, “Ieta, vao outa ragai iava varaua.” ");
INSERT INTO roo_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Oa iava kap-ia wain karo oureva va-ia vearo vaisi purasa. Uva voea vatereva va. Oa iava voea rutu ukaioaepa oira iava. ");
INSERT INTO roo_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Uva oiso voea tavireva, “Eira ragai iava revasiva iria paruevere ragai iava vo osa kopiira voea rutupa oirara Pauto vaaro Reo Ovoi oirao pieoro. ");
INSERT INTO roo_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Oiraopavira ita visii tavipaavoi, Viapau oiso ra vorevira ita vao-ia wain ovi ukaioravere. Ari vo raga uva airepa karova-ia ukaioravere utupaua vo Pauto vo Saraaro-ia.” ");
INSERT INTO roo_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Uva iriavu-ia eraaepa erava. Oa iava ipaaepa Oliv Kovo Pukui iare. ");
INSERT INTO roo_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Uva Jisas voeare oiso puraroepa, “Ragai arova toritavere ragai raga kavuoro, uvare oisi ita va iava rigatoiva vo Pauto vo reoaro-ia oiso, ‘Pauto sipsip ragui tokipato uporevere ra rerare rorooro sikaa viro sipsip ragui.’ ");
INSERT INTO roo_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Vo osa kopiia oaa iava toreoro visiipa iraravere Galili iare.” ");
INSERT INTO roo_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Uva Pita rerare oiso puraroepa, “Vosa voea rutu varaaro oirao pie vovouro vuripere viipa, eagara osa ragai vaaro oirao pie vovou viapau oiso ra vuripe.” ");
INSERT INTO roo_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Uva Jisas rerare oiso puraroepa, “Oiraopavira rutu vii tavipaavoi, Vo osa kookai touvira erao piepa gau purarevere vo vokiaro, ovusa vo peva purari ragai vaisiaro ora taeapaoro.” ");
INSERT INTO roo_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Uva oisi-a oiso osa iava Pita goruvira rutu rera tavitavipareva oiso, “Viapau rutu. Asi vii tapo kopiiravere, vo rara viapau vii vaisiaro taeaa.” Uva voea rutu disaipel oea oisi raga puraaepa oiso osa puraroepa Pita. ");
INSERT INTO roo_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Uva avaaepa aue iare Getsemani-ia. Oa iava rera voeaaro disaipel tavireva oiso, “Vovio pautaera osa avara variri rovosa.” ");
INSERT INTO roo_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Uva Pita vase tapo avaroepa voea Jems ora Jon. Oa iava rovoroepa rirovira rutu siraooro osa vovouisi rerare vavataepa rutu. ");
INSERT INTO roo_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Uva voea tavireva ita oiso, “Ragaire sopaua rirovira rutu vavatae siraooro. Osiraoa vao oisi rutu sovoa, oa iava kopiirai vao-ia. Vo tou rovopaoro uutupata.” ");
INSERT INTO roo_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Uva gare visivi avapaoro gerevira koveroepa rasiua arore. Uva voa variriroepa oiso ra rera-ia puteve vao tavaka vuuta. ");
INSERT INTO roo_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Uva oiso puraroepa, “Aite. Vosa ruipapau ra ragai iava o kap verari iria agasioi rutu aue iava siraoa vo vavataaro. Uva viapau uvuipau ra ragai vo ruipaaro sirova utuu. Viapau. Ari vii raga vo ruipaaro sirova utuu.” ");
INSERT INTO roo_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Uva voreroepa voea kekesa osa uusipaaepa. Uva Pita-re oiso puraroepa, “Saimon. Eari uusipauei? E viapau uvuipauei ovuutavi-ia tokisa? ");
INSERT INTO roo_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Uutupata ora variripata. Teapi kokarapa vovouro visii iare uriope visii kove piesa. Ari ita, vovouisiro oavisii ruipapai oiso ra ragai tapo touta, osa varauraro oavisii raga visii iava raveravepai.” ");
INSERT INTO roo_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Uva voreroepa ita varirisa. Oa iava oiso raga ita variriroepa. ");
INSERT INTO roo_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Uva ita voreroepa voea kekesa osa uusipaaepa, uvare rura iraopaiva rutu. Uva viapau reoavi vai ra oai iava rera aatoive. ");
INSERT INTO roo_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Uva ita, vo peva piepa vuuta-ia voreroepa rera ita. Uva voea tavireva, “Touvira uusipatai reareapaoro? Oire uvuta! Vuuta-a vao tuguraei oa-ia Oirato Oviitoaaro kosi piepai vo vuri vovou irara vavaearo iare. ");
INSERT INTO roo_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Toreta ra avavio. Ro keketa ira ragai kosi pierevoi. Ira-a ro ira urioroi.” ");
INSERT INTO roo_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Uva Jisas touvira reoreoparoepa, ovusa pouro viropa Judas, iravu ita voea iava voeao katai tau erao (12). Ira riro irara tapo urioroepa auerova kakuara ora toorioara, voeao oea aruiva rovopa irara pris irara ora Reo Taisi-ia tarai irara, ora oira vasi irara. ");
INSERT INTO roo_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Uva oisi-a oiso osa voea ravaavira tavireva oiso, “Ro irava uugaaparai, ira-ia pitu ovoita rerava avasa.” ");
INSERT INTO roo_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Uva urioroepa Judas rera iare ava ovoioro oiso purasa, “Tisa.” Oa iava rerava uugaa ovoiroepa. ");
INSERT INTO roo_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Oa iava rera-ia pituiva rera rauoro. ");
INSERT INTO roo_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Uva iravu ruvara-ia toupareva ira toorio gororeva. Uva Rovopato Pristo reraaro kovopato iava uvareoua pakoreva voua toeoro. ");
INSERT INTO roo_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Uva Jisas voeare oiso puraroepa, “E oiso rutu ragaire taraapata osa kavirupato? Oa iava toorioara kaepata ora aue kakuara vo ragai-ia pitusa? ");
INSERT INTO roo_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ari ita, siposipopaavora vokiara rutu-ia visiipa vo Tugoropa Kepa-ia. Uva eakepa viapau voa ragai-ia pitu asatavora? Oire uva va-a eva oa iava vearopai ra va vao Tugoropa Rigato oirao pieve vao oa pura piropa vo ragai-ia.” ");
INSERT INTO roo_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Oa iava voeao disaipel rera arova tori ovoiiva. ");
INSERT INTO roo_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Uva iravu viovokoto Jisas sirova uturoepa ira varoa-ia tuuparoepa. Uva rera-ia pituiva. ");
INSERT INTO roo_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Oa iava varoa iava vase ovoioro gapuvira raga torireva rera ita. ");
INSERT INTO roo_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Uva Jisas-va avaaepa Pristoa iare ro Rovopato, vo uva ora gurupaaepa pris irara voea reipa irara, ora voeao oira vasi irara, ora Reo Taisi-ia tarai irara. ");
INSERT INTO roo_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Uva tauaivi Pita rera sirova uturoepa. Oa iava rera tapo koataroepa vo Rovopato vo tugiaro, oa reroarova oisoa toupaive rera vo kepaaro-ia Pristo. Uva polis irara tapo pauparoepa eto kasi-ia tuituipaoro. ");
INSERT INTO roo_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Oire uva reipa irara pris irara oearovu reipa irara Jiu iava oearea ora reoreopaaepa oiso ra Jisas togapaive oara iava reoara vai, auere ra rera kopii pieive oara iava. Uva taraa ragapaiva. ");
INSERT INTO roo_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ari ita, oearovu riro irara rera togapaiva oreorovu-ia kuuvu reoro rera vo kovoaro iava. Uva viapau oiso vaea reoro-a. Osa-a eisi iava viapau oreoi puraiva vao oiraopa reo vai rutu. ");
INSERT INTO roo_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Uva va-a vao isivaaro iava oearovu torepaaepa oiso kuuvupasa oiso-ia, ");
INSERT INTO roo_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Easi oiso rera uvuiova osa oiso puraroepa, Avoeao, vao Tempel pakoavere oa puraiva vavaeara iava. Ra vorevira vo kepa paua ita vo pevavi raga-ia voki. Vo kepao oa viapau uvuipaoi ra vavae-ia oira paureve.” ");
INSERT INTO roo_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Uva ita, viapau vaea reorovi-a varao oara purapaiva rerare. ");
INSERT INTO roo_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Uva Rovopato Pristo toreroepa voea vuutaro-ia. Oa iava Jisas akereva oiso, “E reasipauei vo reo eva aato arapa, raa? Apeisi vo reo-a eva oa-ia vii togapaivoi?” ");
INSERT INTO roo_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ora uru pie ragapaoro viapau oiso rera vo reoaro pukopareva. Oa iava Jisas akereva rera ita Rovopato Pristo, “Easi vii avu-a Ropoto Krais Pauto Reraaro rutu. Ro Oviitoaaro ira-ia vuurapa vaisi purapaioveira?” ");
INSERT INTO roo_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Oa iava Jisas rera vo reoaro pukooro oiso puraroepa, “Ragai rutu vao-ia. Uva Oirato Oviitoaaro ragai ragoa kekeriverea osa paura vo oirapapa varata-ia Pauto vaaro ira-ia riroa gorua toupaiveira. Ora vo osa rukuta kouro sovara-ia voreraverea vova vuvuiua.” ");
INSERT INTO roo_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Oire uva oisi-a eisi osa puraroiva Jisas, Rovopato Pristo ora rera iava kuvupato karikarioro kasipuroepa rutu oiso puraoro, “Uva aa vo reore taraapai toga reo? ");
INSERT INTO roo_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ari rera uvutavoi osa Pauto tovipare! Uva apeisi vovoupatai?” Oa iava voea rutu katai reo puraoro rera iava vaseiva oiso ra rera kopii pieive. ");
INSERT INTO roo_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Uva oearovu rerapa rui vikipaaepa. Uva rera puaaro tavuruoro rera tapatapapaoro rerare oiso purapaaepa, “Taviu, irouto vii tapare?” Oire uva va-a vao oa iava polis irara rera taparakopaiva. ");
INSERT INTO roo_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Uva Pita otugivivu-ia toupareva reroarovi. Uva Rovopatoapa Pristo oiraaro kovopava urioopa ");
INSERT INTO roo_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pita kekesa osa tuituiparoepa. Oa iava rerava vurapaoro rerare oiso puraopa, “Easi vii vai tapo-a iravu Jisas reraaro ro vova Nasaret-ia.” ");
INSERT INTO roo_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Oa iava taeaparoepa oiso purapaoro, “Viapau taraiparai vao-ia oare oisi purapauei.” Oa iava kosiro viropa rataoa riaaro iare. Uva kookai kokorokureva. ");
INSERT INTO roo_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Oa iava ita rera kekeoro voeao tavieva oira o kovopava oea rera ruvara-ia toupaiva, “Easi iravu-a ro voea iava.” ");
INSERT INTO roo_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Oa iava ora taearoepa ita. Oire uva gare visivi rerare Pita oiso purapaaepa, “E auoro. Easi vii-a iravu voea iava, uvare vii-a ita Galili iava.” ");
INSERT INTO roo_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Oa iava ora rerare vuri reo purareva goruvira rutu ora takauoro oiso puraoro, “Avoeao, viapau rutu taraiparai eera-ia ira iava ragaire eisi purapatai.” ");
INSERT INTO roo_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Uva kookai erao pie gau purareva. Oa iava Pita ora rugoo pieroepa Jisas vo reoarore, vo reo oa iava rera tavireva Jisas, “Kookai touvira erao piepa gau purarevere vo vokiaro ovusa vo peva purari ragai vaisiaro taeapaoro.” Uva ora rugoo pieoro vo reore Pita gau ovoireva rirovira rutu. ");
INSERT INTO roo_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Uva vokipakou rutu ora reopaaepa reipa irara pris irara, ora Reo Taisi-ia tarai irara, ora oira vasi irara, ora voeao rutu Kaunsel irara ora reoaepa. Oa iava Jisas tuukeiva. Uva voava rera ivuoro avaaepa Pailat iare Jisas vatesa rerapa. ");
INSERT INTO roo_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Uva Pailat rera akereva, “E vii-a Jiu reraaro king, raa?” Uva Jisas rera aatoreva, “Iu. Eisi osa purau.” ");
INSERT INTO roo_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Osa iava riroara rutu-ia reoara Jisas togaiva pris irara. ");
INSERT INTO roo_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Oa iava Pailat vorerivira ita rerare oiso puraroepa, “E reasipau voea aato arapa? Oire uvuri. Easi riro reoro-ia vii togapaivoi.” ");
INSERT INTO roo_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Osa Jisas viapau reoparoepa. Oa iava Pailat tavetave iraopareva. ");
INSERT INTO roo_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Vo osa Tagausapa Vurei vao Pasova pura piro ra oisoa iravu tuukepato karupareve Pailat voeapa ro irapa ruipapaave rera kosi piesa. ");
INSERT INTO roo_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Oire uva iravu ro-ia Barabas ira toupareva oeavu tapo tuukepa irara voeao-ia oea gavman oaiveva ora upopaoro iravu kopii pieiva. ");
INSERT INTO roo_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Uva poua viropa Pailat ruvara-ia rera aresa oiso, “Vo pitupitu purari oiso osa vara purapariveira.” ");
INSERT INTO roo_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Uva Pailat oiso puraroepa, “E oiso vovoupatai ra rera karua visiipa ro Jiu reraaro king?” ");
INSERT INTO roo_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ari ita, rera Pailat voeao-ia tarairoepa oiso osa oisoa Jisas vo goruaro riiriipaive. Oa iava Pailat-pa rera vateiva Jisas. ");
INSERT INTO roo_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Uva reipa irara pris irara oearovu rutu vovouaro kasipu piepaiva, oiso ra aue Barabas karureve voeapa. ");
INSERT INTO roo_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Oa iava Pailat voea akereva ita, “Eake vai purapaa visiipa ro-ia ira vaisipata oiso, Jiu reraaro king?” ");
INSERT INTO roo_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Uva rirovira ora reoaepa, “Ae! Rera tapata evao parikou-ia!” ");
INSERT INTO roo_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Uva Pailat oiso puraroepa, “Eake rutupa? Eakea vuri-a oa purarevora?” Oa iava ita voea rutu rirovira ita oiso puraaepa, “Ae! Rera tapata evao parikou-ia!” ");
INSERT INTO roo_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Uva Pailat oiso vovouparoepa ra voea rutu vovouaro roru piereve. Oa iava ro Barabas karureva voeapa. Oire uva Jisas vatereva oearovupa. Oa iava rera ragi rovopaoro rera iava taru vasereva voeapa, oiso ra rera tapaive vo evao parikou-ia. ");
INSERT INTO roo_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Oa iava upo pura irara rerava koataaepa gavman vo kepaaro-ia, okepa oisoa vaisipaive oiso, Pretoriam. Uva voa ora guruaepa voea rutu upo pura irara. ");
INSERT INTO roo_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Uva Jisas tuuiva varoa-ia revasipa varo, ora kukuvaipa puraiva rokarokapa iro iava. Oa iava rera kukuvaiva va-ia rera turaro pieoro kuuvuvira. ");
INSERT INTO roo_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Uva rerare oiso puraaepa avivikevira, “Riro kaekaevira turarovira touri vii vao Jiu reraaro king!” ");
INSERT INTO roo_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Oa iava aue-ia pito tapoko rera ragiiva rera kukuearo. Osa ita rera-ia rui vikipaaepa rerare taku viropaoro kuuvuvira. ");
INSERT INTO roo_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Uva voa rera tovi rovopaivoiva, revasipa varo veraiva rera iava. Oa iava rera vaaro rutu-ia rera tuuiva vorevira. Uva rerava avaaepa rera tapasa. ");
INSERT INTO roo_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Oire uva Saimon ro vova Sairini, Aleksanda vaio ora Rufus aitearo ira urioroepa uvavuva. Uva rera aruiva goruvira evao parikou kaesa vao Jisas vaaro. ");
INSERT INTO roo_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Uva avaaepa uvavure voa vaisiaro Golgota-ia. Oa porearo oiso toupaiveira, Kukue Keru Pukui. ");
INSERT INTO roo_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Oa iava rera vateiva wain ovi va uvereoro oavu tapo itakopa ovi, oiso ra ovirei rutu-ia ukaioro. Vo osa vo ovipa reasiroepa. ");
INSERT INTO roo_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Oa iava rera tapaiva evao parikou-ia, vo osa rera varaaro-ia varoara ora roo pieaepa ora voeapa. Oa iava varare satu visiko purapaiva. ");
INSERT INTO roo_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Aue-ia vo resura vatara vuuta-ia (9 klok) vokipaua, ovuuta-ia rera tapaiva. ");
INSERT INTO roo_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Oa iava vo vaisio rigatoiva oa vituaro iava rera tapaiva oiso puraoro, JISAS KING OAIVE JIU. ");
INSERT INTO roo_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Uva rera tapo aitereivu tapaiva kavirupatoarei oiso-ia, iravu oirapapa varata iava, ari iravu koike varata iava. ");
INSERT INTO roo_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Va vao Tugoropa Vuku iava vo rigato oa oirao pieiva rera-ia va karekeoro, uvare oiso purapapeira, ‘Oa-ia oiso rugooaepa, Iravu ro vuri irara iava rera.’ ");
INSERT INTO roo_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Oire vo osa oearovu rera-ia putepaoro rerare kukue pikupikupaoro oiso purapaaepa, “Aika, ari vii-a vao viigoa Tugoropa Kepa pakosa auepauera. Oire vo kepa vorevira paupari vo peva-ia aue voki! ");
INSERT INTO roo_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Oire ora tauvau ra evao parikou iava varau!” ");
INSERT INTO roo_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Uva pris irara reipa irara, ora Reo Taisi-ia tarai irara tapo rera akaipa piepaiva rerare oiso purapaoro, “Ia, ari oearovu oisoa tauvapareve. Uva viapau oiso ra oisi ora rera raga ora tauvaro. ");
INSERT INTO roo_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Oire vosa vii oiraopatoa rutu Ropoto Krais Pauto reraaro vii Isrel reraaro King, oire varau evoava evao parikou. Ra vii oirao pieio va iava!” Vo osa vaitereo tapo aiterea tapo rera tapaiva rera akaipavira reopasiepa. ");
INSERT INTO roo_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Oa iava ravireopa vuuta-ia (12 klok), ravireo utoroiva, rupa rovoepa voeare aue-ia rekasisa vo peva vuuta (3 klok) vokiarovi vo taere rutu-ia vao. ");
INSERT INTO roo_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Oa iava vo peva vuuta-ia rirovira oiso puraroepa Jisas, “Eloi, Eloi lama sabaktani.” Oa vao porearo oiso purapapeira, “Pautoa oaa, Pautoa oaa. Eakere ragaivi kavuri?” ");
INSERT INTO roo_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Oa iava rera oisi uvuiva voeao oea toupaiva rera ruvara-ia. Oire uva oiso puraaepa, “Uvuta. Keeraroi Ilaija-re.” ");
INSERT INTO roo_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Uva iravu ikaureva iruta rupu piesa aue-ia uureopa viniga ovi. Oa iava evao rao-ia vo ovi vatepareva rerapa Jisas oiso purapaoro, “Tue rovota osa Ilaija rera rere piesa urio rovoro pasi.” ");
INSERT INTO roo_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Uva Jisas rirovira gauoro vovouisi vikireva kopii ovoioro. ");
INSERT INTO roo_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Osa riroua varoua Tempel rataoa-ia kotovira touua, oua vurita piropa varei puraoro vova Pauto vo topisiaro viara iava rovoepa vore rasiuaaro. ");
INSERT INTO roo_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Oa iava ro ira oisoa katai vovoto (100) viurupa irara tokipareve rera Jisas eveireva vosa kopii ovoiroepa. Oa iava oiso puraroepa, “Oiraopavira! Oviitoaaro Pauto eera-a!” ");
INSERT INTO roo_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Uva riakora tapo toupaiva voa rerava vurapaoro tauaiva. Uva aue tapo toupaeva vao Maria aue iava Makdala ora iriavu ita Maria Jems aakoaro ro avaioto, ora Josis, ora Salomi. ");
INSERT INTO roo_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Uva voea-a voeao oea rera oisoa sirova utupaave rera tokipaoro vo osa toupareve Galili, ora airovu riro riako rutu airoa tapo rera sirova utuaepa Jerusalem iare. ");
INSERT INTO roo_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Uva vo ovaiarovi vo vokio ovokia oisoa vaisipaive, Aio Ravaapa Voki vo vokio iare Sabat voki. ");
INSERT INTO roo_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ovokia-ia urioroepa Josep vova Arimatia ro torevoko vovouto Kaunselto. Ro ira oisoa Pauto vo Saraarore tapo rugorugooparo vare tuepaoro. Ira Pailat iare uriri asavira avaroepa. Uva Jisas kopiire rera arepareva. ");
INSERT INTO roo_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Oa iava Pailat rirovira rugorugooroepa, uvare ikauvira kopii ovoiroepa Jisas. Uva ro ira oisoa katai vovoto (100) viurupa irara tokipareve rerare keeraroepa Pailat. Oa iava rera akereva, “E kopiiroe Jisas?” ");
INSERT INTO roo_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Uva viurupa irara tokipato vo taviaro uvureva oiso, Kopiiroe. Oa iava Jisas iava varaua vatereva Josep-pa. ");
INSERT INTO roo_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Oa iava rera Josep ouavu vorireva varoua popoteua. Oa iava Jisas rere piereva rera tavurusa va-ia varoa popotea. Oa iava rera tovoreva aveke rikui-ia, oa ravaavira teka ragaiva rirova-ia aveke. Uva vo rikui iare iriavu rirova aveke perireva iria-ia vo riku riaaro ivitasa. ");
INSERT INTO roo_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Uva vao isivaaro iava Maria Makdala vairei ora iriavu ita Maria Josis aakoaro airea tapo voa kekeereva vo uva Jisas tovoiva. ");
INSERT INTO roo_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Oire uva Sabat voki isivaaro iava Maria Makdala, ora Maria aue Jems aakoaro ora Salomi airoa vearo geesipara voriiva, oiso ra varava avaave Jisas varaaro kipusa. ");
INSERT INTO roo_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Vo vokipakou rutu-ia vo vokio-ia rovopa voki wik iava oa-ia avaaepa tova urui iare. Vo ovusa ravireo kaeparo viropa. ");
INSERT INTO roo_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Oa iava ora akeakepaaepa voa oiso, “Esa, irou vai vigeipa vao aveke veravere vova rikui riaaro iava?” ");
INSERT INTO roo_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Uva voava vurapaiva tuupavira. Oa iava ore rirova aveke vura ragaiva iria voava peri ovoio viropa. ");
INSERT INTO roo_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Uva koatapaaepa rikui-ia. Uva voa iravu kekeiva viovokoto ira oirapapa varata-ia pauparoepa popotetoa-ia kuvupaoro. Oa iava ropeaepa. ");
INSERT INTO roo_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Uva vairo tavireva oiso puraoro, “Opeita uriripata. Jisas ro vova Nasaret-ia, ro ira kopii pieivora, irare taraapatavoi ita, ira vorevira toreroi. Viapau oiso vo touparevoi. Keketa. Vo uva ita rera tovoivorao. Uva viapau. ");
INSERT INTO roo_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Oire voreta disaipel tavisa rera voeaaro Pita tapo. Ira ita iraroe eisi Galili-ia. Uva voa rera keketavere oiso osa visii tavirevora.” ");
INSERT INTO roo_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Uva rikui iava torioro voreaepa osa rikerikepaoro ora ropepaoro tapo. Uva viapau oiso oearoiva ora reopaaepa, uvare rirovira uriripaaepa. ");
INSERT INTO roo_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Uva toreroepa Jisas vokipakou-ia avitoava rovopa voki rupaaro iava vo wik iava. Oa-ia Maria o vova Makdala iriare ora karekeroepa rovovira. O iria iava erao vatara sigureva aue tugara. ");
INSERT INTO roo_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Oa iava voea tavitavisa kareopa voeao oea oisoa rera tapo toupaive. Vo osa gau eraro-ia gaupaoro gaupaiva. ");
INSERT INTO roo_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Oire vo osa oisi uvuiva oiso, Vorevira tootooro toreroi, oa iava rera kekeeva. Uva viapau oiso oira vo reoaro oirao piepaiva. ");
INSERT INTO roo_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Oire va isivaaro iava vaitereore ita ora karekeroepa pisavira aiterea raiva-ia vokapasiva. ");
INSERT INTO roo_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Oa iava va iava voeapa tavitavisa karesiepa. Uva ita, viapau oiso vaiterei vo reoroaro oirao piepaiva. ");
INSERT INTO roo_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Oire uva voea-ia katai tau katai (11) iare ora karekeroepa osa aiopaiva. Oa iava voeare aveavevira reoroepa aue-ia kaureo rugoo oaive ora aue vavagisi vovouro oaive. Aue iava uvare viapau voeao reoaro oirao piepaiva oea rera kekeiva vo osa toreroepa. ");
INSERT INTO roo_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Uva voea tavireva oiso puraoro, “Avata voraro ruture vo rasio-ia Vearo Siposipo iava tavitavisa oirara rutupa. ");
INSERT INTO roo_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ro oirato ira ragai oirao pierevere ra baptaisa oureve, ira-a eera ira oureverea Pauto ora rera iare. Ari ro ira viapau oirao pieparevere ira iava viapau oiso opesipaperea rera vaaro vuri vovou. ");
INSERT INTO roo_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Uva varao ravaa reesiro toupavere voeao-ia oea oirao piepaiveira oiso-ia, Taraiavere tugara kare sigupasa vo raga ragai vo goruaro-ia, ora pisa reoro-ia ora reopaaverea. ");
INSERT INTO roo_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Oea rakoru-ia pituivere, ora itakopara-ia ukaioavere. Uva varei rutu evarei uvuipai oirato kopii pieve. Ari ita, viapau oiso voea vuri piepaivere ita vareo. Oea ita vavaeara oaive tovopaivere voeao-ia upiapa irara voea porete piepaoro.” ");
INSERT INTO roo_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Oire uva vo tavitavia vao isivaaro iava Pauto rera ipa pie ovoireva Turaro Jisas vuvuiua iare vo uva pauparoveira oirapapa varata iava Pauto vaaro. ");
INSERT INTO roo_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Uva va-a vao oa iava ava ovoiaepa voraro ruture rera iava siposiposa. Vo osa Turaro voea vo siposiporoaro oirao piereva aue-ia ravoto kovoro. ");
INSERT INTO roo_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Reito Tiofilas, vo tuariri uva oearovu rovoaera siposipoara rutu rigatooro varao rutu iava oara karekereva Pauto igei rutu vuutaaro-ia. ");
INSERT INTO roo_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Uva voeao gisipoaro sirova utuaera oea Jisas vo kovoaro kekeiva ora voea osireiaro iava voari rovoa-ia ora vo vokiara rutu-ia tapo. Aue iava uvare voea oea oisoa oiso toupaive, Pauto vo reoaro kosi piepa irara. Uva voea-a evoea oea igei vateivora vo siposiporo varao. ");
INSERT INTO roo_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Uva oisi-a eisi osa iava ragai tapo ita vo siposipo rigatopaavoi, oiso ra viipa reito Tiofilas va sipoa, vo rara vara rutu vituarore taraa rovopaavoi vearovira. Ra va iava torevokovira vara rigatoa oiso rutu osa tuariri karekeepa. ");
INSERT INTO roo_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Eisi osa iava uvuipau ra vara-ia vearovira taraiu oiso, Oiraopara varao oara-ia vii siposipoivora Jisas vo kovoaro iava. ");
INSERT INTO roo_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Vo osa King Herot reiparoepa ro vova Judia taere-ia, osa vo vuuta-ia oisoa iravu koruou purapato pristo toupareve. Rera vaisiaro, Sekaraia voeao iava pris irara Abaisa voeaaro. Ari o-ia tapo Ilisabet vatuava vo sarao iava oira pris irara voeao Eron voeaaro. ");
INSERT INTO roo_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Aiterea vaitereo oisoa torevokovira rutu oisoa toupasi Pauto osireiaro-ia. Uva varao Reo Taisiro rutu oara oisoa oirao piepasi, ora varao Pauto vo reoroaro. Oa-a vao oa iava viapau vuria vai vaiterei-ia. ");
INSERT INTO roo_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Vo osa viapau vaiterei oviitoa vaiaro, uvare Ilisabet-a asaova. Oa iava viapau oiso kakae kavaupao. Uva avuka ragasiepa kakae kavau asavira. ");
INSERT INTO roo_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Oire uva ovokivu-ia Sekaraia pris kovo purareva Pauto osireiaro-ia vo vuutao-ia oa-ia oisoa rera voeaaro pris kovo purapaive. ");
INSERT INTO roo_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Uvare oisi rera reesiiva voea vo pitupituaro sirova utupaoro, oiso ra Tugoropa Tugi-ia koataparo vao Turaro Pauto vaaro, aue koruou kuparero purapasa. Otugia-a vao oa Rovopa Kepa Lotupa Kepa Tempel sovara-ia rutu oisoa toupaive. ");
INSERT INTO roo_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Oire uva vo vuuta vao koruou kupare purapa vuuta oa-ia riro irara rutu Jiu ora guruaepa varirisa ratauva. ");
INSERT INTO roo_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Uva Sekaraia purapurapato enselto kekereva eravao vatuaro-ia oirapapa varata iava, uvare voa rera ruvara iare karekeroepa. ");
INSERT INTO roo_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Oa iava voa rera kekeoro rirovira ora sitaroepa. Uva uririparoepa. ");
INSERT INTO roo_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Uva enselto rerare oiso puraroepa, “Sekaraia. Teapi uriripau. Ari Pauto vii vaaro variria uvurevoi. Uva vii tavipaavoi oiso, Vii vatuavaaro Ilisabet veipa oviito oaesi kavauevere. Oa iava oiso rera vaisirivere rara, Jon. ");
INSERT INTO roo_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Osa iava vii iava sopaua vearovira touvere ora tapo rorurivere. Ra riro irara tapo roruivere rera-ia ovusa kavauro. ");
INSERT INTO roo_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ira rei vaisirovere kovopaoro vo Turaro Pauto osireiaro-ia. Uva viapau rutu oiso ukaioparovere varao-ia riro gorupara aue wain oviro, vo oviro oara uvuipai oirara kokoro piepasa. Ira-ia goruvira touparevere Tugoropato Uraurato rera iava sopaua uvui piepaoro vo vuutao-ia vao vo osa aakova kovuaro-ia touparevere, ora vo osa kavauro. Uva vukuparovere Tugoropatoa-ia Uraurato. ");
INSERT INTO roo_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ira riro irara roroiovira soporeparevere voeao vova Isrel-ia. Ra Turarore poreave ro voea reraaro Pauto oaive. ");
INSERT INTO roo_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ira-ia Tugoropato Uraurato ora gorua toupaivere, ro Uraurato ora vo goruo oarea oisoa Ilaija-ia toupaive vo osa Pauto vo reoaro kosi piepareve voari tuariri. Ra iraparo Reitoapa Turaro. Eera oviitoara ira vo aaoro rutu vovouaro porerevere ra ora agiagiave ora voeao tapo riro kaureo irara. Oire ra va iava vearo rugoo ouive voeao torevoko vovou irara vaaro. Ora voea tapo oirara rera voeaaro ravaarevere ra Reitoare Turaro tuevira toupaive rera vo kovoaro purapasa.” ");
INSERT INTO roo_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Uva va-a vao oa iava Sekaraia rerare enselto oiso puraroepa, “Uva eake iava oiso puraravere, Oiraopa reo vao-ia? Easi ragai avukaraerao vegei rutu ora riakova oaa.” ");
INSERT INTO roo_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Oire oa iava enselto oiso rera aatoreva, “Ragai-a Gebriel ragoa Pauto ruvara-ia toreparaveira. Ari ita, uva Pautoa raga-a ira ragai arurevoi oa iava uriorai vii tavisa vao iava vearo siposipo vii oviitoaaro iava. ");
INSERT INTO roo_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Oire uvuri! Vii iava gisipo kapuuevoi, uvare viapau ragai vo reoaro oirao pieparivoi. Ra viapau reopau vo rutu rekasisa, uva vara rutu varao karekepere ragai vo reoroaro oirao pieoro.” ");
INSERT INTO roo_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Oire uva voea rutu oirara rerare tue ragapaaepa Sekaraia oiso purapaoro, “Eake vai karekei Tugoropa Tugi-ia rerare oa iava viapau vigei tavisa kosiro viroi?” ");
INSERT INTO roo_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Uva va isivaaro iava kosiro viropa. Oa iava viapau voeapa reoara vai vatereva. Uva va iava oiso taraiaepa, Easi oavu avu rutu kekerevoi evoa Tugoropa Tugi sovara-ia. Uva vavaea raga-ia voeare reoreoparoepa uvare gisipo rerare kapuueva. ");
INSERT INTO roo_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Oa iava Sekaraia vo kovoaro vao koruou purapa kovo opesiepa. Uva vorevira kareroepa ora rera vo uruiaro iare. ");
INSERT INTO roo_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Oire uva va-a vao osa kakae kovu pura piropa oira kovuaro-ia Ilisabet. Oa iava oisoa toupaeve vo kovuva vo raga oira vo kepaaro raga sovara-ia vo vavae rutu sovara-ia aue kekira. Oa iava oiso puraopa, ");
INSERT INTO roo_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Ari ita, kakae kavau asava ragai. Uva Turaro Pauto ragaipa siraoroi. Oa iava oiso ragai pierevoi ariia veraoro ragai iava oirara rutu osireiaro iava.” ");
INSERT INTO roo_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Uva katai vatara-ia (6) kekira kakae kovuva toupaeva Ilisabet-ia, ovusa Pauto purapurapato Gebriel arureva ouruivu iare vo uruio Galili taere-ia. Va vaisiaro, Nasaret. ");
INSERT INTO roo_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Osa iava avaroepa iriavu iare tavauruva riakova iria reesiiva oiso ra oirato oira oureve. Rera vaisiaro, Josep, King Devit aao iraraaro iava rera. Uva oira vaisiaro-a, Maria o-ia iria viapau oiratoa vaiva uusiopa. ");
INSERT INTO roo_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Oa iava Gebriel oira iare avaroepa. Uva oirare oiso puraroepa, “Vearovira Maria. Pauto vii viraakopare viipa siraooro. Oa iava Turaro vii tapo toupareveira vii tauvapaoro.” ");
INSERT INTO roo_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Oire uva Maria vo reo vao uvuevoiva, oirare sopaua vavataepa rirovira rutu oiso rugorugoopaoro, Apeisi raga reo-a vao-ia? ");
INSERT INTO roo_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Oa iava purapurapato enselto oiso oira tavireva, “Maria. Opeita uriripau. Pauto vo vovouaro vearopa vii-ia. ");
INSERT INTO roo_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Uvuri! Kakae kovu purapapi vii-ia rara, ra iravu kavauri kakaeto ira vaisirivere oiso, Jisas. ");
INSERT INTO roo_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","“Ira turarovira toupareverea. Oa iava oiso rera vaisiiverea, Pauto Oviitoaaro ro oiso viara-ia. Oa iava Pauto turarovira rutu rera tovoreverea oiso rutu osa rera aaotoaaro King Devit. ");
INSERT INTO roo_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ira taru Jekop voeaaropa Jiu-pa irara turaroparoverea vokiara rutu-ia. Ra rera vaaro tokia viapau oiso opesiperea.” ");
INSERT INTO roo_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Oa iava Maria rerare enselto oiso puraopa, “Uva apeisi ragavira karekepere va vao-ia, uvare oira ou asavira toupaavoi.” ");
INSERT INTO roo_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Oire uva enselto oira vo reoaro pukooro oiso puraroepa, “Ari! Tugoropato Uraurato ira vii iare uriopa, vo osa Pauto vo goruaro vii ruuve. Eisi osa iava rera reraaro kakaeto kavaurivere rara utupavira. Uva va-a eva vituaro iava oiso rera vaisipaivere oiso, Roroio Vovoutoa Rutu Pauto Oviitoaaro. ");
INSERT INTO roo_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","“Uvuri! Easi Ilisabet sarava oara iria avukaopa rutu. Iria-ia kakaetoa epao oira kovuaro-ia. Iriare tuariri oisoa oiso purapaave, Viapau uvuipaoi ra kakaetoa vai kavaueve. Ovusa vo vokio-ia oira kovuaro-ia kakae kovuei. Ari ita! Katai vatara (6) kekira oira vaaro oa putevoi. ");
INSERT INTO roo_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Pauto uvui iraopa auero rutu purapasa.” Uva oisi-a eisi Maria tavireva enselto vo osa vairei reesipareva vaireo airea kakaetoarei kavausa auepaereiepa. ");
INSERT INTO roo_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Oa iava Maria rera vo reoaro aatooro oiso puraopa, “Ari ita! Ragai-a Turaro oiraaro kovopava. Ira uvuipa ra ragaipa oisi va purareve oiso osa purauei.” Oa iava enselto oira arova avaroepa. ");
INSERT INTO roo_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Oire uva vo vuuta iava vao vo vokia Maria toreoro ikauvira avaopa ouruivu iare pukuiara vuutaaro-ia vo Judia taere-ia. ");
INSERT INTO roo_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Oa iava Sekaraia vo kepaaro-ia koataopa. Uva voa Ilisabet-va vearo voki puraeva. ");
INSERT INTO roo_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Uva Ilisabet Maria uvueva osa oirava vearo vokieva. Ovusa kakaeto oira kovuaro-ia toupareva Ilisabet. Uva voa toritoripareva. Oa iava Tugoropatoa-ia Uraurato agasiopa Ilisabet. ");
INSERT INTO roo_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Oa iava rirovira rutu goruvira reoopa oiso puraoro, “Vii-ia riroa viraakoa toupaivoi Pauto vaaro. Oa vituaro iava vii vo roruaro oriakorovu rutu vo roruroaro-ia putepaivoi. Uva eera tapo kakaeto vava touparevoi iraei vii kovuaro-ia. ");
INSERT INTO roo_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","E apeisi vai ragai iare taveteevoi Turaro aakoaro. Asi viapau riro vaisivavi-a ragai? ");
INSERT INTO roo_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ari ita! Vii uvuavoi ovusa ragaiva vearo vokirivoi vo pou virooro. Oa iava kakaeto ro iraei ragai kovuaro-ia vo uvava ora sitaoro rorurevoi. ");
INSERT INTO roo_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Vii-a vao riakova viigoa roruava touparivoi vo rera vo reoaro oirao pieoro oiso osa vii tavirevo. Uva oisi oiraopavira vii-ia karekepere.” Eisi osa puraopa Ilisabet oirare Maria. ");
INSERT INTO roo_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria oiso puraopa, “Ragai iava sopaua oaa Turaro vaisiaro kae piepaivoi. ");
INSERT INTO roo_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Oa iava ragai reraaro uraurato Pautoa-ia roruparevoi ro ira ragai virivaripareveira. ");
INSERT INTO roo_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ragai-a vao rerapa kovopava. Ragai akaipavavi raga ragoapa siraoroi. Vo vokio ora vo utupaua uva oirara rutu ragai iava oiso purapaaverea, Pauto oirapa riroa vaterevoi rorua. ");
INSERT INTO roo_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Aue iava uvare riro gorua rutu purare ragai-ia. Rera raga ro Tugoropa Vaisitoa Rutu, ira riro kovo purapareveira. ");
INSERT INTO roo_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ira vaaro siraoa voeaopa toupai oea rera rei piepaiveira rerapa avivikepaoro. Oire uva oisi raga ita voeaopa tapo siraoparoverea ovii irara ovii iraraaro. ");
INSERT INTO roo_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ira iava vavae-a riro goru kovo purava. Ora voea sikasikareva voea siguoro voeao riro kaureo irara oea oisoa ora rei vaisi piepaave ora voea raga. ");
INSERT INTO roo_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ira reipa irara vaisiaro vara piereva voeao vaisiaro kae pieoro akaipa vaisi iraravi. ");
INSERT INTO roo_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ira voeao sopaaro vuku piepareveira oea iava sopaura ogoepapeira vearoparapa. Vo osa voeao vore piereve riro kotokoto guru irara, vo osa viapau oarai ouive rera ruvara-ia. ");
INSERT INTO roo_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Uva rerapa kovopa irara tauvarevo vigei vao Isrel, uvare rera vaarore siraoa rugooroe. ");
INSERT INTO roo_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Oiso osa puraroepa vigei aao iraraarore oiso, Ebraham-pa siraoparaverea ora rera voeaaro utupa irara voari rutu tugurasa utupa vokiro rutu-ia.” ");
INSERT INTO roo_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria vo peva-ia kekira Ilisabet tapo toupaeva. Oa iava vorevira ora oira vo uruiaro iare kareopa. ");
INSERT INTO roo_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Oire uva oira vo vuutaaro pou piropa. Oa iava oviito kavaueva Ilisabet. ");
INSERT INTO roo_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Uva voeao oira vo uruiaro-ia tou irara ora sara irara oea rutu vo siposipo iava vao uvuiva. Vo uvare Turaro Pauto oirapa siraoroepa rutu. Uva va-a eva oa iava oira tapo rorupaiva. ");
INSERT INTO roo_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Uva vo peva vatarapa voki (8) pou piropa. Oa iava vo voki-ia urioaepa rera kakaeto iava rakari verasa rera-ia vo vaisio tovooro, Sekaraia, aiteto vaisiaro. ");
INSERT INTO roo_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Vo osa aakova oiso puraopa, “Viapau. Ari vao iava oiso rera vaisipai, Jon.” ");
INSERT INTO roo_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Uva oirare oiso puraaepa, “Uvare saratoa vai oara oisi ovaisiei oa oisi toupai, oa iava oisi ruipapauei? Viapau!” ");
INSERT INTO roo_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Oire oa iava vavaeara raga-ia Sekaraia akeiva oiso, “Aa vo vaisio-a vao oa iava rera vaisipai ro-ia vii oviitoaaro?” ");
INSERT INTO roo_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Uva slet pero arereva. Oa iava vo vaisi vao Jon-pa rigatoreva va-ia voeapa. Uva rirovira rugorugoopaaepa. ");
INSERT INTO roo_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Oire uva vo vuuta raga-ia Sekaraia iava gisipo karu ovoio viropa. Oa iava arevuoto rera iava vorevira vearoroepa. Uva va iava Pautoa-ia vuurapa vaisi pura ovoireva. ");
INSERT INTO roo_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Uva voeao rera vo uruiaro-ia tou irara uririaepa. Oa iava vara rutu iava varao vo siposipo viriva vo Judia pukuiro vo taerearo rutu-ia. ");
INSERT INTO roo_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Uva va iava oirara rutu vo siposipo vao uvuoro rirovira rutu tavetavepaiva rugorugoopaoro vo ora voea iava sopaura-ia. Uva oiso puraaepa, “Esa apeisi vai ragavira utupaua touparevere rera ro kakaeto?” Ari ita! Uvare taraipaaepa oiso, Pauto vo goruaro toupai rera-ia. ");
INSERT INTO roo_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Oire uva Tugoropato Uraurato Sekaraia sopaaro-ia koataroepa rera vuku pieoro ro kakaeto aitetoaaro. Oa iava ravaa reo purareva oiso puraoro, ");
INSERT INTO roo_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Turaro vaisiaro-ia vuurapa vaisi purape, ro Pauto Isrel reraaro. Ira vigei oirara tauvasa urioroi ora rera voeaaro. Uvare vigeipa oraivavu purareva oraiva iavirava uvuipaviei ra virivarivira toupape. ");
INSERT INTO roo_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Uva vova rera kovopatoaaro Devit ira sara iraraaro iava iravu riro goruto oirato tore pierevoi vigei oupasa vorevira ora rerapa vova vuria iava. ");
INSERT INTO roo_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Eisi osa siposiporeva voari tuariri profet irara gisipoaro-ia voeao torevoko vovou irara. ");
INSERT INTO roo_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Oa-ia oiso puraroepa, Vigei virivaripareverea voeao vavaearo iava oea vigeiva keripaaveira, ora voeao tapo vavaearo iava oea vigeire vuri vovoupaaveira rutu. ");
INSERT INTO roo_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ira vigei aao iraraarore oiso puraroepa, Visii tauvapaaverea. Oire uva va-a vao Reo Ovoi oare rugoooro va oirao piere vigeipa. ");
INSERT INTO roo_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","75","Eisi osa puraroepa rore vigei aaotoaaro Ebraham va vao Reo Ovoi puraoro oiso, Vigei vorevira vore ovoireverea voeao vavaearo iava vigeiva keripa irara. Ra va iava rera vo kovoaro purape uriri asavira. Rara avivikepavio rera osireiaro-ia aue torevoko vovou purapaoro vokiara rutu-ia. ");
INSERT INTO roo_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Oire uva vii-a vao kakaeto viigoa vaisiiverea oiso, Profetato Pauto reraaro ro oiso rutu viara-ia. Viigoa irauvere Turaropa raiva vatatopopaoro. ");
INSERT INTO roo_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Uva oirara rutu siposiporivere voeao rera voeaaro. Oire ra vo reoro iava taraiave oiso, Ira taru voea iava vuri vovouro verapareverea voea vorevira oupaoro ora rerapa. ");
INSERT INTO roo_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Aue vituaro iava uvare rirovira vigeipa siraopa vovou purapareveira Pauto ro vigei reraaro. Osa oiso piepareverea ro ira ora rera iava aviavi piea vatepareverea vigeipa. ");
INSERT INTO roo_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Osa iava voeaopa aviavia vatepareverea oea kopiia vo goruaro sovara-ia toupaiveira voeao rupa vovou irara. Uva vigei kokotoaro torevokoreverea vigei tuvetuvepaoro. Ra va iava gavaure vovou vo raivaaro-ia vokape.” Eisi osa puraroepa Sekaraia. ");
INSERT INTO roo_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Oire uva riroroepa rera kakaeto. Uva rera iava varaua ora uraurato goruvira karekeepa. Oa iava vo toureva raaka tapi vo tugurasa uva ora karekeroepa Isrel-pa irara osireiaro-ia ro aue Jon. ");
INSERT INTO roo_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Vo vuuta-ia vao oa-ia King Sisa Ogastas oavu reo ovoi purareva, oiso ra vo voki-ia oirara rutu vieiaro vaivaisiaro ouive. ");
INSERT INTO roo_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Oire uva rovopa voki rutu-a va vao oa-ia vaisi oupaaepa oirara rutu iava. Ovusa aue Sairinias voa reiparoepa gavmanpaoro vo Siria-ia vo vo voki-ia eva. ");
INSERT INTO roo_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Uva oisi-a eisi osa iava voea rutu oirara vo urui iare eva voea rutu vo uruiaro torevokoaro avaaepa, oiso ra voea rutu vaivaisiaro vieiaro ouive voa. ");
INSERT INTO roo_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ari ita, Josep-a Devit sara iraraaro iava rera. Oa iava ora rera vo uruiaro iava gare urui avaroepa vao Nasaret vo Galili taere-ia. Oa iava voare vo Judia avaroepa vo King Devit vo uruiaro-ia uva oisoa vaisipaive oiso, Betlehem-ia. ");
INSERT INTO roo_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Uva oira tapo Maria avaroepa voare o iria reesiiva rerapa, oisore ra vaiterei rutu vaisiaro tapo ouive voa. Vo osa kakae kovuva toupaeva Maria. ");
INSERT INTO roo_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Uva vo urui raga-ia vao Betlehem urui touvira toupasiva. Oa iava voa kakaeto kavausa aueopa. ");
INSERT INTO roo_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Oire uva bulmakau kare vo kepaaro-ia toupaoro rera eera avaiotoa rutu ira kavaueva voa, uvare tavetepa irara vo kepaaro agasiepa. Oa iava voa rera ruueva varoa-ia. Uva voa rera uusi pieeva bokis-ia o iria-ia oisoa bulmakau kare aiopaive. ");
INSERT INTO roo_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Uva voa-a vo uva oearovu sipsip tokipa irara toupaiva vo urui vatuaro-ia voea vo raguiroaro tokipaoro vokiaro. ");
INSERT INTO roo_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Uva Turaro reraaro ensel voea iare urioroepa. Uva voa Turaro vaaro keraria voeare sisikorevira aviaviva. Oa iava rirovira rutu uririaepa. ");
INSERT INTO roo_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Uva enselto oiso puraroepa voeare, “Opeita uriripata. Uvuta! Ragai visiipa Vearo Siposipo sipoavoi vao oa oirara rutu roru pie iraovere. ");
INSERT INTO roo_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Vo voki-a vao oa-ia iriavu riakova kakaeto kavauevoi vo King Devit vo uruiaro sovara-ia. Ro ira visii ourevere vorevira vova vuria iava. Eera Krais Turaro ira Pauto oiraraaro tuvetuvepareverea. ");
INSERT INTO roo_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Uva ora visii vo reesiroaro iava rera vo kavauaro-ia taraitai eisi osa. Uva rera kakaeto keketavere ira ruuevo varoa-ia rera uusi piesa bulmakau kare aiopavaaro-ia bokis.” ");
INSERT INTO roo_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Oire uva voavi ragava riro irara rutu vuvuiua-ia tou irara poua viropa vuvuiua iava vo toupasa enselto ruvara-ia. Oa iava Pautoa-ia vuurapa vaisi purapaoro oiso purapaaepa erapaoro, ");
INSERT INTO roo_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Pauto vaisiaro-ia vuurapa vaisi purata vo vuvuiua rutu-ia. Ra gavaure vovou rutu outa vo rasitoa-ia toupaoro visii vao visiigoa-ia rorupareveira Pauto.” ");
INSERT INTO roo_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Oire uva enselpa irara voea arova voreaepa vuvuiua iare. Oa iava voeao sipsip tokipa irara ora reoaepa oiso “Irata, ra avavio voare Betlehem-ia. Ra va avu kekepe vao oa karekei voa oa iava Turaro Pauto vigei tavirevoi.” ");
INSERT INTO roo_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Oa iava ikauvira avaaepa. Uva vaiterei Maria vaio ora Josep kekeiva voa osa voa toupasiva. Ovusa kakaeto bulmakau kare aiopavaaro-ia bokis uusiparoepa. ");
INSERT INTO roo_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Uva rera kekeivoiva, vo reo vao taviiva oa uvuiva rera iava ro-ia kakaeto vo enselto ruvara-ia. ");
INSERT INTO roo_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Oire uva voea rutu oirara vo reo uvuiva sipsip tokipa irara ruvara-ia, oea vo reo-ia rirovira rugorugoopaaepa. ");
INSERT INTO roo_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Vo osa Maria vo reoro rutu varao ora oira sopaaro-ia orirupaeva. Oa iava voa varare rugoopaopa rutu. ");
INSERT INTO roo_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Uva sipsip tokipa irara vorevira kareaepa Pautoa-ia vuurapa vaisi purapaoro. Oa iava rirovira rutu rorupaiva Pautoa-ia vara-ia varao oara rutu uvuiva, ora vara rutu tapo kekeiva oiso osa enselpa irara voea taviiva. ");
INSERT INTO roo_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Uva vo peva vatarapa voki (8) pou piropa, oa iava Jisas rakari veraiva rera-ia vo vaisio tovo ovoioro, Jisas-pa vaisi. Ari ita, vo osa vo kovutoa-ia pou viro asavira toureva, ovusa enselto vo vaisi iava rera vaisireva. ");
INSERT INTO roo_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Oire uva vo vuuta-a vao oa pou piropa vo avaorei rutu sisigarue piesa oiso osa Moses vaaro Reo Taisi puraepa. Oa iava aiteto avukarei vo kakaeva avasiepa Jerusalem iare Pauto Turaro vatesa rera. ");
INSERT INTO roo_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Oiso osa oisoa rigatoa purapape vo Turaro vaaro-ia Reo Taisi oiso, ‘Vosa avaio kakae kavaueve aakova, oire ra Turaropa Pauto rera vateive rera reesioro rerapa.’ ");
INSERT INTO roo_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Oa iava oiso ruipapasiepa tapo ra pristo koruoua vai tapo purareve vaiterei vo vovouaro sirova. Oiso osa puraepa Turaro vaaro-ia Reo Taisi oiso, ‘Viovokotoarei kurue vaio, eke tavaururirei vai uruvaurirei.’ ");
INSERT INTO roo_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Oire uva iravu oirato Jerusalem-ia toupareva rera vaisiaro Simion. Torevokotoa rutu ora tapo riro aviviketo Pautoa-pa. Ira oisoa rerare ro tueparo ira Isrel-pa irara vorevira oureverea ora rerapa vova vuria iava. Vo osa Tugoropato Uraurato oisoa Simion sopaaro-ia toupareve. ");
INSERT INTO roo_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ari ita, Tugoropato Uraurato rera tavireva ravaavira oiso, “Viapau ikauvira kopiiuvere. Viapau. Ari Krais keke rovorivere, ira arureva Turaro Pauto vore rasitoa-ia rera voeaaro tuvetuvepasa.” ");
INSERT INTO roo_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Uva Tugoropato Uraurato Simion tuvetuvepaoro koataroepa Rovopa Kepa Lotupa Kepa Tempel sovara-ia, vo osa aiteto ora aakova Jisas kakaeva uriosiepa vo pitupituo purasa osa oisoa purapape Reo Taisi. ");
INSERT INTO roo_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Oire uva Simion Jisas kavaureva ora rera vavaearo-ia. Oa iava Pautoa-ia vuurapa vaisi purareva rerava oiso puraoro, ");
INSERT INTO roo_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“O Turaro Pauto. Ro iava vii reraaro kovopato vaseri ra vova avaro, uvare ragai vo vovouaro gavaurevira toupai. Ra va iava vii vo reoaro oirao pieri oreoa purariva voari tuariri. ");
INSERT INTO roo_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Aue iava uvare ragai iava osireitoarei oaa vao kekesivoi oa purarivoi auere vorevira igei ora viipa ousa vova vuria iava. Va-a eva oa iava kopiisa vovouparai. ");
INSERT INTO roo_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Vii vao ravaarivora oirara rutu osireiaro-ia ");
INSERT INTO roo_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","eva aviavia. Oa-a vao aviavia vatepareverea vo osararovu rutu vo rugorugooroaro karupasa, oiso ra vii vo raivaaro-ia taraiave. Ra va iava vii voeaaro Isrel riro vaisi ouive.” ");
INSERT INTO roo_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Aitetoarei ora aakova rirovira rutu rera-ia Simion tavetave iraopasiva vo reo iava vao oa purareva. ");
INSERT INTO roo_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Oire uva Simion voea vatereva viraakoa. Oa iava Maria tavipareva oiso, “Uvuri! Ro-ia kakaeto ira oearovu rutu Isrel-pa irara kove pierevere ora riro irara tapo tore pierevere tapo. Ra oiso toupareve, Reesia Pauto vaaro. Uva riro irara rutu rera takaupaivere rara. ");
INSERT INTO roo_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Eisi osa iava riro irara varaaro rugorugooara roroiovira karekepere, Uva iravu toorio ira avuavuaro oiso toupare osa siraoa ira vii sopaaro togarevere.” ");
INSERT INTO roo_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Oire uva iriavu profetava riakova toupaeva voa. Oira vaisiaro, Ana o-ia Fanyuel oviivaaro ro vova Asa-pa irara. Iria erao vatara (7) ivaro-ia vatuato tapo toupaeva. Oa iava kopiiroiva, rera isivaaro-ia avukaopa rutu raroevira. ");
INSERT INTO roo_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Uva vo peva vatara tau vo resura (84) ivaro-ia oira vaaro oa-ia tuguraopa. Uva viapau oisoa Tugoropa Kepa Tempel kavupaeve. Ari ita, oisoa aioara kavupao katai rugoo purapasa variripaoro, uvare oisoa Pauto vo kovoaro-ia pitupaeve vo vokiaro ora tapo ravireo-ia. ");
INSERT INTO roo_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Oire uva vo vuuta raga-ia vao urioopa Pautoa-ia vearo vaisi purasa. Oa iava oira tapo siposipoeva rera iava ro kakaeto voeapa oirara voeao oea oisoa Pautoa-re tuepaave, oiso ra Jerusalem vore piereve ora rerapa. ");
INSERT INTO roo_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Oire uva vara rutu varao puraiva oiso osa Pauto vaaro Reo Taisi puraepa. Oa iava ora voea vo uruiaro iare vorevira kareaepa vao vo Galili taere-ia gare uruivi Nasaret-ia. ");
INSERT INTO roo_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Uva kakaeto riroroepa goruoro rutu. Oa iava vearopa tarairo rera-ia karekeepa. Uva Pauto vaaro tapo viraakoa toupaiva rera-ia. ");
INSERT INTO roo_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jisas aitearo avukarei ipasiepa ovokivu-ia Jerusalem iare, vao iare Tagausapa Vurei aue Pasova, oa oisoa purapa piro vo ivara rutu-ia katakataivira. Ra Pauto vaarore siraoa oisoa rugorugoopaave vorevira vo osa voea tauvareva Isip iava voea kosi pieoro. ");
INSERT INTO roo_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Uva Jisas katai tau erao (12) ivaro-ia uvuiroepa. Oa iava vo voki vao vo pitupituaro sirova utuaepa Pasova Aio purapa voki. ");
INSERT INTO roo_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Uva vo vokiroa varao Pasova Aio purapa vokiro oara opesieiva, vorevira kareaepa. Ovusa Jisas viovokoto voa raga touvira toupareva Jerusalem-ia. Uva aitetoarei viapau rera-ia taraipasiepa vo osa touvira voa toupareva. ");
INSERT INTO roo_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","45","Uva oiso keapasiepa, Oearoi tapo vokapare. Oa iava riro sita rutu purasiva rera kavuoro. Oire uva va iava voeao vuruvuru-ia vate irara oaesi ora sara irara vuravura ragasiva rerare. Uva taraa ragapasivoiva rerare, katai voki rutu isivaaro iava vorevira voresiepa Jerusalem iare rerare taraasa voa. ");
INSERT INTO roo_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Uva voa raga rerare taraapasiva vo peva rutu-ia voki peva. Oa iava voa rera kekesiva Tempel atoaro, osa voa pauparoepa tisa irara vuutaro-ia vo voea varaaro reoara uru piepaoro. Uva toupareva, ora voea tapo akepareva vorevira vara iava. ");
INSERT INTO roo_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Vo ovusa rera vo reoroaro uru piepaiva. Uva rera-ia rirovira rutu tavetave iraopaiva aue iava rera vaaro taraia rutu, ora vo reo vearovira oa purareva voea aatooro. ");
INSERT INTO roo_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Oa iava aitetoarei voa rera kekeoro ora sitasiepa rutu. Uva aakova rerare oiso puraopa, “Ae kakaeto. Eakere vegeivi oiso pierivoi oa iava viire taraa raga vasipavevoi?” ");
INSERT INTO roo_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Uva oira vo reoaro pukooro oiso puraroepa, “Ari eakere ragaire taraa rovo asasivo Aite vo kepaaro-ia? Uva kasikasi ragapasiei ragaire taraa ragapaoro?” ");
INSERT INTO roo_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Oa iava vo reo-ia vavagisipasiepa eva oa purareva vaitereire. ");
INSERT INTO roo_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Uva va-a vao oa iava vaiterei tapo kareroepa. Oa iava Nasaret-ia karea viropa. Uva voa oisoa vokiara rutu-ia vaiterei gisipoaro sirova utuparo. Ari ita, uva aakova vara rutu varao-ia orirupaeva oara kekeeva vo rera ruvara-ia. ");
INSERT INTO roo_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Oire uva Jisas riroroepa. Oa iava taraia rera vaaro vearovira rutu karekeepa. Uva Pauto ora oirara rutu rerare vearo vovouaepa rutu. ");
INSERT INTO roo_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Taibirias Sisa Rom-pa irara tokireva katai tau vo vavae (15) ivaro sovara-ia. osa Pontias Pailat gavmanpaoro toupareva Judia-ia. Uva vo vuuta-a vao oa-ia aue Herot reiparoepa Galili taere-ia, ovusa voraro araokoto Filip reiparoepa Ituria taere ora Trakonaitis, vo osa ro Laisenias Abilin taere-ia reiparoepa. ");
INSERT INTO roo_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Vo osa Anas vaio ora Kaiafas pris kovo-ia reipasiepa. Vo vuutao-ia oa-ia Jon Sekaraia oviitoaaro vo rasitoa-ia toupareva kuvau tapi. Uva Pauto vo reoaro urioepa rera iare voa. ");
INSERT INTO roo_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Uvava-a eva oa iava voraro rutu avaroepa Jodan oirara rutupa siposipopaoro, oiso ra sopaura oaive poreive. Ra va iava baptaisa ouive rara Pauto voea iava vuri vovouro vera rovoreve. ");
INSERT INTO roo_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Oiso osa profet Aisaia vo vukuaro-ia oisoa rigatoa toupaive, ‘Iravu ira keeraparoi vo raaka tapi oiso purapa, Turaro vo raivaaro vatatopopata va ravaaoro oa-ia pouro viroverea. ");
INSERT INTO roo_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Oiso ra goreara rutu agasi pieive pukuiara erioro vara vaeaoro. Regorepa raivaro tapo torevokooro ra torevokope. Ora varao tapo vuri raivaro oara vearo pieive rara. ");
INSERT INTO roo_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ra va iava oirara rutu vo kovo vao kekeive Pauto oa purapare vigei vorevira ousapa vuriara iava.’ ");
INSERT INTO roo_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Oire uva riro irara rutu oirara urioaepa Jon vavaearo-ia baptaisa ousa. Oa iava oiso voeare puraroepa. “Visii vao rakoru ovii iraraaro! Irouto visii vosipare, oa iava toripata Pauto vo kasipuaro asavira? ");
INSERT INTO roo_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Visii iava sopaura poreta, ra vuri vovouro oavisii kavuta. Oa iava oirao pie vovouro oavisii poeravira karekepere oearovupa. Opeita ora visii raga vo vovouroaro iava oreorovu kareke piepata oiso purapaoro, Ebraham-a igei aitearo. Oa iava igei-a Pauto oiraraaro rutu. Ari ita, visii tavi iraopaavoi, Pautoa raga uvuipa vo avekero iava kakae vure purapasa. Ra oisi pieive, Ebraham ovii iraraaro. ");
INSERT INTO roo_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Torara eira iriaei ravaavira evaova vituaro-ia. Oire vo evaro oiso toupai osa visii. Varao oara viapau oiso vearo kuero vai kaepaive oara rutu taru toepaiverea vara vikipasa tuitui kasi-ia.” Eisi osa puraroepa Jon. ");
INSERT INTO roo_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Uva voea rutu Jon akeiva oiso puraoro, “Eake vai puraio?” ");
INSERT INTO roo_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Oa iava oiso puraroepa voea aatooro, “Ro ira vaiterei kuvupatoarei, oire iravu vatereve ropa apotato. Ari ro ira aioara toupaive, oire oisi raga ita piereve iravupa oaravu vateoro,” ");
INSERT INTO roo_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Uva oearovu tapo takis oupa irara urioaepa, oiso ra voea tapo baptaisa ouive rera ruvara-ia. Oa iava rerare oiso puraaepa, “Tisa. Eake vai purapaio?” ");
INSERT INTO roo_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Oa iava voeare oiso puraroepa, “Ari moni oupatai oiso osa gavman visii tavirevora. Oire ra viapau vo reesi iava ita pute pievira oarai ita ou ragapata.” ");
INSERT INTO roo_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Uva oearovu tapo ita viurupa irara rera akeiva oiso, “Eake vai purapaio?” Oa iava oiso voeare puraroepa, “Viapau oiso ra oira upopata ora viapau oiso ra kuuvuvira voea rovirieipata kortua-ia voea varaaro ivu ragapasa moniara. Ari voriara oavisii raga rekasiaro reesiaro-ia rorupata.” ");
INSERT INTO roo_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Oire uva voeare vovouisiro riro varivarivira toreepa. Oa iava rirovira rugorugoopaaepa oiso puraoro, “Easi, Jon-a ro-ia Krais, eke?” ");
INSERT INTO roo_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Uva va iava Jon voea vo reoaro pukoreva oiso purapaoro, “Visii baptaispaavoi uukoa raga-ia visii reesioro visiigoa vovouisiro oavisii poretavorao. Ari ro ira ragai sirova uturovere, ira vo goruaro ragai vo goruaro-ia putevere uvare riro vasitoa-a. Uva viapau oiso uvuiparai ra rera vaaro tasipa kaea, uvare akukutoavi raga-a ragai. Ari rera visii vaterevere vao baptaisa Tugoropato Uraurato vaaro visii reesipaoro aue-ia Tugoropato Uraurato vo goruaro-ia ora eto kasi vo goruaro-ia. ");
INSERT INTO roo_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ira vururua-ia pitupare wit ragipasa oira rakariaro verapaoro. Oire ra oira aioaro gurureve rera vo kepaaro-ia wit kepa vo aio kitupasa voa. Oa iava oira rakariaro kasirevere vao-ia tuitui kasi-ia oa viapau rokopaive.” ");
INSERT INTO roo_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon oreorovu rutu tapo purareva voea iava sopaura tore pieoro. Uva vo pitupitu-a vao oa purareva vearo siposipo purapaoro oirara rutupa. ");
INSERT INTO roo_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Oire uva Jon tuu pievira Herot tavireva rera vaaro iava vuria, ro voea reraaro rovopato gavman. Aue iava uvare vuria purareva aue-ia Herodias araokoto vatuavaaro ouoro. Ora opitupiturovu rutu tapo-ia oara oisoa purapareve rera Herot. ");
INSERT INTO roo_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Uva varao vuriara oara oisoa purapareve rera Herot uva vo vuria vao puteva rutu, uvare vao riroa rutu vuria purareva Jon tovooro tuukepa kepa-ia. ");
INSERT INTO roo_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Uva vo vuuta-a vao oa-ia oirara rutu baptais rovopaaepa. Oa iava voa raga ita Jon Jisas tapo baptaisreva. Oire voa baptaisroiva, variri ovoiroepa voa. Uva vuvuiua karu piropa. ");
INSERT INTO roo_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Oa iava Tugoropato Uraurato vararoepa. Uva oiso rera kekeiva osa kurue. Uva Jisas-ia pitusa rerereva. Oa iava vuvuiua iava Pauto vo reoaro varaepa oa oiso puraepa, “Vii-a ragai Oviitoaaro rutu viigoa kaviko iraopaaveira. Uva vii-ia rorupaaveira rutu.” ");
INSERT INTO roo_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jisas ora rera vo kovoaro rovoreva vo peva tau (30) ivaro-ia uvuivira toupaoro. Uva oirara rutu rerare oiso puraaepa, “Eera-a Josep oviitoaaro.” ");
INSERT INTO roo_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Oiso-ia Josep-a Hilai oviitoaaro, ari Hilai-a Matat oviitoaaro, ari Matat-a Livai oviitoaaro, ari Livai-a Melkai oviitoaaro, ari Melkai-a Janai oviitoaaro, ari Janai-a Josep oviitoaaro, ");
INSERT INTO roo_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ari Josep-a Matataias oviitoaaro, ari Matataias-a Emos oviitoaaro, ari Emos-a Neam oviitoaaro, ari Neam-a Eslai oviitoaaro, ari Eslai-a Nagai oviitoaaro, ");
INSERT INTO roo_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ari Nagai-a Meat oviitoaaro, ari Meat-a Matataias oviitoaaro, ari Matataias-a Semen oviitoaaro, ari Semen-a Josek oviitoaaro, ari Josek-a Joda oviitoaaro, ");
INSERT INTO roo_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ari Joda-a Joanan oviitoaaro, ari Joanan-a Resa oviitoaaro, ari Resa-a Serababel oviitoaaro, ari Serababel-a Sialtiel oviitoaaro, ari Sialtiel-a Nerai oviitoaaro, ");
INSERT INTO roo_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ari Nerai-a Melkai oviitoaaro, ari Melkai-a Edai oviitoaaro, ari Edai-a Kosam oviitoaaro, ari Kosam-a Elmadam oviitoaaro, ari Elmadam-a Er oviitoaaro, ");
INSERT INTO roo_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ari Er-a Josua oviitoaaro, ari Josua-a Eliesa oviitoaaro, ari Eliesa-a Jorim oviitoaaro, ari Jorim-a Matat oviitoaaro, ari Matat-a Livai oviitoaaro, ");
INSERT INTO roo_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ari Livai-a Simion oviitoaaro, ari Simion-a Juda oviitoaaro, ari Juda-a Josep oviitoaaro, ari Josep-a Jonam oviitoaaro, ari Jonam-a Elaiakim oviitoaaro, ");
INSERT INTO roo_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ari Elaiakim-a Melia oviitoaaro, ari Melia-a Mena oviitoaaro, ari Mena-a Matata oviitoaaro, ari Matata-a Netan oviitoaaro, ari Netan-a Devit oviitoaaro, ");
INSERT INTO roo_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Devit-a Jesi oviitoaaro, ari Jesi-a Obet oviitoaaro, ari Obet-a Boas oviitoaaro, ari Boas-a Salmon oviitoaaro, ari Salmon-a Nason oviitoaaro, ");
INSERT INTO roo_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ari Nason-a Aminadap oviitoaaro, ari Aminadap-a Atmin oviitoaaro, ari Atmin-a Anai oviitoaaro, ari Anai-a Hesron oviitoaaro, ari Hesron-a Peres oviitoaaro, ari Peres-a Juda oviitoaaro, ");
INSERT INTO roo_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ari Juda-a Jekop oviitoaaro, ari Jekop-a Aisak oviitoaaro, ari Aisak-a Ebraham oviitoaaro, ari Ebraham-a Tira oviitoaaro, ari Tira-a Neho oviitoaaro, ");
INSERT INTO roo_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ari Neho-a Serak oviitoaaro, ari Serak-a Reu oviitoaaro, ari Reu-a Pelek oviitoaaro, ari Pelek-a Ebe oviitoaaro, ari Ebe-a Sela oviitoaaro, ");
INSERT INTO roo_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ari Sela-a Kenan oviitoaaro, ari Kenan-a Apaksat oviitoaaro, ari Apaksat-a Siem oviitoaaro, ari Siem-a Noa oviitoaaro, ari Noa-a Lamek oviitoaaro, ");
INSERT INTO roo_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ari Lamek-a Metusala oviitoaaro, ari Metusala-a Inok oviitoaaro, ari Inok-a Jaret oviitoaaro, ari Jaret-a Mahalalel oviitoaaro, ari Mahalalel-a Kenan oviitoaaro, ");
INSERT INTO roo_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ari Kenan-a Inos oviitoaaro, ari Inos-a Set oviitoaaro, ari Set-a Adam oviitoaaro, ari Adam-a Pauto oviitoaaro. ");
INSERT INTO roo_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Vo Tugoropato Uraurato iava vukuroepa Jisas. Oa iava uukova iava veraro viropa Jodan. Oire voava voreroiva, Tugoropato Uraurato rera tuvetuvepaoro avaroepa kuvau tapirore. ");
INSERT INTO roo_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Oa iava resura tau (40) vokiro rutu-ia toureva. Uva voa Seten rera-ia kokara ragaparoepa, Oire uva vo vuuta-a vao oa-ia oisoa aio kavuvira toupareve. Oa iava vo vokiro varao opesieiva, ogoeroepa rera Jisas. ");
INSERT INTO roo_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Osa iava Seten rera tavireva oiso, “Vosa vii Pauto Oviitoaaro rutu, oire o taviri aveke ra opovira ora poreo.” ");
INSERT INTO roo_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Uva Jisas rera aatoreva oiso puraoro, “Viapau. Uvare Pauto vo reoaro oiso purapai, ‘Opoa raga viapau uvuipai ra oiratoapa tootooa vatepaive.’” ");
INSERT INTO roo_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Oire uva voaviva Seten rera ipa piereva. Oa iava osasararovu ruture voava rera kareke piereva varao vo rasitoa-ia katai vuutavi raga-ia. ");
INSERT INTO roo_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Uva va iava rera raga Seten oiso Jisas tavipareva, “Vo goruro rutu-a varao oara vatepaavoi viipa, ora vao tapo riro vaisi vo vara iavirava, uvare vara rutu-a evara ragai varaaro. Uva oiso toupai, Vosa irai vate ruipapara vara, oire ra irai vatea vara. ");
INSERT INTO roo_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Vosa ragai-ia vuurapa vaisi purapaoro taku virou, oire ra vii ragapa vara rutupe varao.” ");
INSERT INTO roo_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Uva Jisas oiso puraroepa, “Pauto vo reoaro oiso purapai, ‘Pautoa raga-ia vuurapa vaisi purapata eera visii reraaro Turaro. Rara rera raga vo kovoaro purapata eera kataitoa raga.’” ");
INSERT INTO roo_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Uva voa-a vo uvava rerava Jisas avaroepa Seten Jerusalem iare Rovopa Kepa Lotupa Kepa kukuearo-ia rera tovosa viara-ia rutu. Oire uva voa rera tavipareva oiso, “Vosa vii-a Pauto Oviitoaaro rutu, oire vo toreu ra voava ora vikiu. ");
INSERT INTO roo_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Uvare vo rigato toupai oa oiso purapai, ‘Pauto voeao arurevere enselpa irara ra vii tokiive vii-ia uutupaoro.’ ");
INSERT INTO roo_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Uva oreovu oiso purapai, ‘Oea vii-ia pituivere ora voea vavaearo iava. Ra viapau oiso avekeara vai-ia ora upou kokotoa iava.’” ");
INSERT INTO roo_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Oire uva Jisas oiso puraroepa, “Easi, oreovu oiso purapai, ‘Opeita Turaro Pauto oavisii-ia kokarapata.’” ");
INSERT INTO roo_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Vo kokaraara rutu purareva Seten rera-ia. Uva voa Jisas kavureva Seten ovokivure ita tueoro. ");
INSERT INTO roo_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Oire uva Tugoropato Uraurato vo goruaro iavirava vorevira voreroepa Jisas Galili iare. Uva voa rera iava vo siposipo viriva voraro rutu vo taere-ia vao-ia. ");
INSERT INTO roo_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Uva oisoa oirara rutu siposipopareve voea vo keparoaro-ia, Reo Taisi Uvupa Keparo Sinagog. Oa iava oirara rutu rera-ia rei vaisi purapaiva. ");
INSERT INTO roo_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Oire uva Jisas Nasaret iare avaroepa. Ari ita, kakaevira oisoa vo urui-ia toupareve. Oa iava voa toupaoro riroroepa. Uva Sabat voki-ia voa Sinagog-ia koataroepa ora rera vo pitupituaro sirova utuoro. Uva voa toreparoepa Pauto vo reoaro vieipasa. ");
INSERT INTO roo_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Uva oisi-a eisi osa iava profet Aisaia vo vukuaro vateiva rerapa. Oa iava va-ia vo rigato kekereva oa oiso purapapeira, ");
INSERT INTO roo_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","‘Turaro Pauto reraaro Uraurato ira epao ragai-ia. Ira ragai reesirevora rera vo reoaro iava siposiposa voeaopa apotapa irara. Eera ira ragai arurevora voeaopa tuukepa irara siposipopasa, oiso ra tuukea iava kosipaa viro. Ora voeaopa siposipopasa voosi irara, oiso ra vorevira vuravurapaive. Ora oearovu rutu tauvapasa voeao oea riro vavatapara rutu siitokaara kaepaiveira. ");
INSERT INTO roo_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ora voea rutu oirara tavitavipasa vo vuutao iava Turaro vaaro, ro ira ora rera voeaaro oureverea vorevira ora rerapa.’ ");
INSERT INTO roo_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Oire Jisas vukua kapu piereva. Oa iava uutupatoapa va vatereva. Uva va isivaaro iava pauparoepa voa Sinagog-ia, ovusa voeao oea tapo voa toupaiva oea rerava tuupavira rutu vurapaiva. ");
INSERT INTO roo_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Uva voa rovoroepa voea tavitavipaoro oiso, “Oiraopavira rutu vo rigato-ia Pauto vaaro. Oa oiraoei vo vokio vo osa vo reo uvutavoi.” ");
INSERT INTO roo_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Uva va iava rera egaegaiva rutu, uvare vo reoro iare rugoopaaepa vearo reoro oara karekereva ora rera gisipoaro iava. Oa iava oiso puraaepa, “Apeisi ragavira? Easi pasi viapau Josep oviitoaaro ro-ia?” ");
INSERT INTO roo_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Uva oiso voeare puraroepa, “Oiraopavira rutu! Osa ita vo reo puratavere ragaire oiso, Ruvarupato ora vii raga iava varaua porete pieri. Ora oiso puratavere, Eva-ia ravoto kovo oa purarivora Kapeneam-ia evoa oa uvuiovora, osa raga ita eisi osa va purarivere vo ora vii vo uruiaro rutu-ia.” ");
INSERT INTO roo_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Uva oiso puraroepa, “Oiraopavira rutu visiire oiso puraparai, Oirara viapau uvuipaai ra irai profetatoa vai gisipoaro uvupaive vo ora rera vo uruiaro rutu-ia. Ari ita, voa rera reroaropaive. ");
INSERT INTO roo_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Uva ita, oiraopavira oiso puraparai, Voeao Ilaija vo vuutaaro iava oea iava riro riako toupai Isrel-ia airoa vatua iraraaro kopiiaepa. Vo vokio-ia oa-ia vuvuiua tupa piropa rutu. Oire uva viapau kokeva vai vo peva ivaro rutu-ia ora katai vatara kekira vai-ia. Uva voava riroto ogoeto karekeroepa voraro rutu. ");
INSERT INTO roo_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ari ita, oiso-ia viapau oiso Ilaija arureva Pauto iriai iare riakova vai vova Isrel oira tauvasa. Viapau. Ari o ratau touva tauvasa rera arureva iria vo kavauopa Sarefat urui-ia. Iria oisoa raroevira toupaeve vo Saidon-ia. ");
INSERT INTO roo_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Oiso osa tapo voari tuariri vo vuutao-ia oa-ia profet Ilaisa epao. Oa-ia riro irara leprapa irara oisoa toupaive Isrel-ia. Oire uva viapau voea iava irai porete piereva Ilaisa. Ari aue raga Neman ro vova Siria ratau touto ira vearo piereva.” Jisas evo reo purareva vo Jiu iavirava voeao riro reo uvu asa irara. ");
INSERT INTO roo_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Oire uva Reo Taisi Uvupa Kepa-ia toupaoro vo reo uvuiva rerare kasipu iraopaoro. ");
INSERT INTO roo_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Uva voava vusiiva rera sitasa. Oa iava rera ivupaoro kosia viropa vo urui isivaaro iava oa oisoa pukuia-ia kukuearo-ia toupaive. Uvare oiso vovoupaaepa ra voava Jisas-ia vikiave vara pievira. ");
INSERT INTO roo_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Osa voea raga sovara-ia vokaoro avaroepa voea gogu pieoro. ");
INSERT INTO roo_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Uva Kapaneam urui iare avaroepa vo Galili taere sovara-ia. Oa iava voa Sabat voki-ia oirara rutu tarai piepareva voea siposipopaoro. ");
INSERT INTO roo_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Uva rera vo siposipoaro uvuivoiva, vovouisiro oaive rirovira rutu ipaepa. Uvare rera vo reoaro-ia gorua toupaiva. ");
INSERT INTO roo_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Oire uva voa Sinagog-ia iravu oirato toupareva. Ira-ia vurito tugarato oisoa toupareve. Oa iava voa toupaoro rirovira rutu oiveoro keeraroepa oiso puraoro, ");
INSERT INTO roo_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Auoro Jisas Nasaret iava! Eake purasa uriouei igei-ia? Igei opesi ovoi piesa, eke? Vii-ia taraiparai, Tugoropato Pauto reraaro.” ");
INSERT INTO roo_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Oa iava Jisas rerare koruroepa oiso puraoro, “Eakau! Eera iava kosi virou.” Oa iava rera tugarato oiratoa-ia vikiroepa rasiua arore. Uva voa koveroepa voea vuutaaro-ia. Osa iava rera arova ava ovoiroepa rera tugarato. Vo osa viapau vuria vai purareva rera-ia oirato. ");
INSERT INTO roo_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Oa iava voea rutu ropeaepa. Oire ora voea vovouro arova taavi iraopaiva oiso ora reopaoro, “Avoeao! Apeisi raga reo irao-a vao-ia oa iava voeaore vuri tugararo reoroi? Easi ro vai-ia reesia vaiei ora gorua vai. Oa iava rera uvu ovoipaiveira ra oirara arova ava ovoipaave?” ");
INSERT INTO roo_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Uva oisi-a eisi osa iava rera iava Jisas viriva vo siposipo vao-ia voraro rutu vo taere-ia vao-ia. ");
INSERT INTO roo_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Uva Sinagog iava kosiro viropa Jisas. Oa iava Saimon vo kepaaro-ia koataroepa. Vo osa voa Saimon vatuavaaro aakoaro riro upia-ia kukue upia toupaeva. Uva va-a eva oa iava rerare Jisas keeraaepa vo oira porete piesa. ");
INSERT INTO roo_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Uva voa oira ruvara-ia toresa urioroepa vo upia iare reosa. Uva oira iava opesi ovoiepa vo upia. Oire voava vearo ovoioro rerapa aioara vatatopo ovoieva. ");
INSERT INTO roo_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Uva vo ovaiarovi ovusa ravireo rokopareva, uva rera iare oearovuva vuri vara irara urioaepa, ora voearo tapo tugara oearoa oisoa upopaive. Oa iava voea rutu porete piereva ravotovira voea-ia vavaearei tovopaoro. ");
INSERT INTO roo_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Oire uva riro irara rutu iava kosia viropa. Uva voea evoea vuri irara tugara oea rirovira oiveoro oiso puraaepa, “Vii-a Pauto Oviitoaaro.” Osa iava voeare koruparoepa rera iava oreoi pura arapa, uvare taraipaaepa oiso, Rera ro-ia Krais. ");
INSERT INTO roo_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Oire uva avitoava eraoroepa Jisas. Oa iava rokoreva uvavure kuvau tapi voa varirisa. Uva voa-a evoa uva toureva osa rerare taraa ragapaiva. Oa iava rera kekeoro voa oiso rugoopaaepa ra ora voea raga iare rera voreive. ");
INSERT INTO roo_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Oa iava voeare oiso puraroepa, “Oiso ruipaparai ra Vearo Siposipo iava siposipoa aue iava Pauto vo Saraaro voraro ouruirovu-ia tapo. Aue vituaro iava uvare Pauto ragai arurevora okovoa purasa vao-ia.” ");
INSERT INTO roo_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Oa iava vo Judia Distrik-ia riro keparo-ia Reo Taisi Uvupa Keparo siposiporeva va iava vao Vearo Siposipo voeapa. ");
INSERT INTO roo_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Oire uva ovokivu-ia rogaraua-ia toreparoepa vo toko rovu vatuaro-ia vao vo Genesaret. Uva ovaisivu-a vao-ia oiso Galili. Uva voa oirara rutu Jisas tapo toupaiva ora voea-ia paipaoro vo reo vao Pauto vo reoaro uvupasa. ");
INSERT INTO roo_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Uva voa uvuoarei kekereva uvuoarei rogaraua-ia vo toko rovu-ia. Uva voa voeao atari oupa irara vo uvuoarei iava veraa viropa kuverara sisupasa. ");
INSERT INTO roo_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Oire uva vo uvuoarei iava oavu-ia kaero viropa aue Saimon vo uvuoaro. Oa iava Jisas rera tavipareva oiso, “Vo uvuo gare visivi topari rogaraua iava rovua iare.” Oire uva vo uvuo-ia paupaoro Jisas voeapa siposipopareva oirara. ");
INSERT INTO roo_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Uva voeapa siposiporevoiva, rera Saimon tavireva oiso, “Uvuoa viru pieri vavore uva riro rokopai. Ra voava kuverava roko pieta. Ra atari kare vai ivuta.” ");
INSERT INTO roo_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Uva Saimon oiso puraroepa, “Turaro. Easi igei kasivarivira rutu kovo ragaiovo vo rupao-ia. Uva viapau okarei ivuiovo aue atari. Ari ita, vii uvuavoi osa ragai tavitaviri. Uva oisi va purapaavoi.” ");
INSERT INTO roo_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Oa iava oisi oira pieiva. Uva riro kare atari kare ivuiva. Oa iava kuverava toko rovoopa. ");
INSERT INTO roo_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Oisi-a eisi osa iava oearovure puepueiva ora voea raga iava, voeao oea ouvuovu raga-ia toupaiva. Oiso ra urioave voea tauvasa. Oa iava urioaepa. Uva voea rutu vo uvuoarei agasi pieiva vo kare-ia atari kare. Uva roko rovoepa vo uvuoarei rutu vo kare vavatapaoro. ");
INSERT INTO roo_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Uva va-a vao oa kekerevoiva Saimon Pita, Jisas kokotoaro ruvara-ia kokoto rekuoro pauroepa oiso puraoro, “Turaro, ragai ruvara iava avau. Ari ragai-a vurito.” ");
INSERT INTO roo_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Uvare vo kare evoea atari kare kekereva okarea ivuiva. Oa iava rirovira rutu roperoepa. Ora voeao oea rera tapo toupaiva oea tapo ropeaepa. ");
INSERT INTO roo_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Aue oviitoareiaro tapo Sebedi, Jems araorei ora Jon aiterea rera tapo oisoa kovopasi aue Saimon, aiterea tapo ora sitasiepa. Uva va-a vao oa iava Jisas Saimon-re oiso puraroepa, “Teapi uriripau. Ari utupaua oiso oirara ivurivere rara ragai iare.” ");
INSERT INTO roo_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Oa iava uvuoarei rere pieiva rogaraua iare, vo osa auero rutu voea varaaro kavuiva rera sirova utuoro. ");
INSERT INTO roo_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Vo riro urui-ia toureva Jisas. Uva voa-a evoa ouruia-ia iravu oisoa toupareve oirato ira-ia oisoa lepra upia toupaive. Oa iava Jisas kekeoro kokotoarei-ia rekureva varirioro rerare. Oiso puraroepa, “Vosa ragaipa ruipapau ra ragai porete pieri.” ");
INSERT INTO roo_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Oa iava Jisas rera-ia vavaea tovooro oiso puraroepa, “Oiso ruipaparai ra sisigarueu.” Oa iava vaviopavira raga rera iava vo upia eva lepra upia opesiepa. ");
INSERT INTO roo_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Uva Jisas riro goruvira rutu rera vosireva oiso puraoro, “Opeita irai ita taviparivere. Viapau. Ari avapauei ora vii iava varaua karekesa auepa pris koruoua vai puraoro oiso osa purapapeira Reo Taisi vao Moses vaaro. Ra va iava oirara rutu oiraopavira oiso taraiave, O ari vii-a vao viigoa iava upia opesiei rutu.” ");
INSERT INTO roo_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Vo ovusa vara iava vo siposipo viripaoro avaepa varao oara rutu purareva Jisas voea-ia. Oire uva va-a eva oa iava riro irara rutu urioaepa rera vo reoaro uvusa. Ora oiso tapo ra upiara iava voea tapo porete piepareve varao voea varaaro. ");
INSERT INTO roo_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Oire uva voea arova rera raga avaparoepa uvavure kuvau tapivi voa variripasa. ");
INSERT INTO roo_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ovokivu-ia oirara tarai piepareva ovusa oearovu ratarataa vovou irara aue Farisi ora tisa irara tapo voeao Reo Taisiro-ia tarai irara, oea tapo paupaaepa voa voeao oea vo uruiro iava urioaepa oiso-ia, Galili-ia vo, ari Judia-ia, ora Jerusalem-ia. Vo osa Pauto vo goruarova Jisas toupareva ogorua iava oirara porete piepareva. ");
INSERT INTO roo_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Uva oresuravu iravu-ia kaepaoro urioaepa. Ira-ia kerau upia oisoa toupaive keruara rutu-ia. Oire uva oiso ruipapaaepa ra rera kaepaoro urua-ia koataave Jisas iare atoaro voa rera tovosa. ");
INSERT INTO roo_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Vo osa oirara rutu iava tupapaa piropa. Oa iava oiso auepaaepa ra apeisi vai ragavira rera koata pieive rera iare voa atoaro. Oire uva va iava vo kepa ivara iare rera kaepaoro ipaaepa. Oa iava kukuuvua veraiva voava iroiro-ia rera vara piesa urua tapo voa vo voea rutu oirara vuutaaro-ia. Oa iava rera tovoiva vo uva Jisas toupareva. ");
INSERT INTO roo_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Uva Jisas voea varaaro oirao pie vovouro eveirevoiva, rerare oiso puraroepa, “Vatetoa oaa, vii iava vuri vovouro veraavoi.” ");
INSERT INTO roo_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Oire uva va-a vao oa iava voeao riro tarai irara Reo Taisi-ia ora voeao Farisi oearea rutu ora voea raga ora reopaaepa. Oa iava voea iava oearovu riro irara oiso puraaepa, “Avoeao! Iroutoa rutu-a ro-ia ira vao tovi reo purare Pautoa-ia? Irou vai uvuipai vuriara verapasa? Easi Pautoa raga.” ");
INSERT INTO roo_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Uva Jisas voea vo rugorugooroaro-ia tarai ovoiroepa. Oa iava voeare oiso puraroepa, “Eakere eisi ragaire vurivira rugorugoopatai ora visii raga sopaaro-ia? ");
INSERT INTO roo_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ari aa vo reoa-a vao oa-ia avekata vaiei ragaipa ra oa-ia oiso purara, Vii iava vuri vovou veraavoi? Eke oiso, Toreu ra vokari? ");
INSERT INTO roo_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Uva oiso ruipaparai ra oiraopavira rutu taraita oiso, Oirato Oviitoaaro Ro Ropoto ragai raga goruava toupaaveira vo rasio-ia. Vao oa iava uvuiparai varao verapasa vuri vovouro. Eisi osa iava oiso purarai rore ira iava keruara rutu kopiiepa, Toreu, ra vii vaaro ouri urua, ra avau vore vii vo kepaaro iare.” ");
INSERT INTO roo_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Oire uva va-a vao oa iava voea rutu oirara osireiaro-ia toreroepa urua ouoro vao oa-ia uusiparoepa. Uva rera vo kepaaro iare vava avaroepa. Oa iava voa Pautoa-ia vuurapa vaisi purareva karepaoro. ");
INSERT INTO roo_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Oire uva oirara rutu ropeaepa ora sitaoro. Oa iava Pautoa-ia vuurapa vaisi puraiva rerapa avivikeoro. Osa iava oiso puraaepa, “Vo vokio rutu-ia oavu raga ravotoa rutu kekei.” ");
INSERT INTO roo_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Uva utupavira Jisas vokapaoro avaroepa. Oa iava iravu oirato kekereva ovusa takis oupa kepa-ia pauparoepa. Rera vaisiaro ro-ia, Livai. Uva rerare Jisas keeraroepa oiso puraoro, “Uriou ragai sirova utusa.” ");
INSERT INTO roo_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Oire tore ovoiroepa rera varaaro rutu kavuoro, osa toupaiva vo Jisas sirova utuoro. ");
INSERT INTO roo_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Uva rera Livai oavu riroa aioa purareva rerapa Jisas ora rera vo kepaaro-ia. Oa iava oearovu riro irara takis oupa irara va iare urioaepa ora oearovu tapo vuri irara. Oea rutu vaiterei tapo paupaaepa aiopaoro. ");
INSERT INTO roo_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Uva va-a vao oa iava Farisi ora Reo Taisi-ia tarai irara iava voeare kasipupaoro oiso purapaaepa disaipel ruvara-ia voeao Jisas voeaaro, “Uva apeisi iava takis oupa irara tapo voeao kavirupa irara aiopatavoi ora oearovu voeao vuri vovou irara?” ");
INSERT INTO roo_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Oa iava Jisas voea vo reoaro pukooro oiso puraroepa, “Ari ita! Voeao upia asa irara oea viapau oiso ruvarupatoa iare avapaaveira. Viapau. Asi upiapa irara raga oea ruvarupatoa iare avapaaveira. ");
INSERT INTO roo_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ari ita, viapau oiso voeaore keerasa urioraera torevoko vovou irara. Viapau. Easi voeaore keerasa vuri vovou irara urioraera, oiso ra sopaura oaive iava porepaa viro vova vuria.” ");
INSERT INTO roo_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Oire uva Jisas taviiva oiso, “Voeao Jon voeaaro disaipel oea oiso aio arapa kavupaive rirovira rutu variripaoro vo riro vuutaro rutu-ia. Ora voeao Farisi vo disaipelaro oea tapo oisi raga oisoa piepaive. Ari vii voeaaro disaipel oea aioara rutu aiopaiveira ora ukaiopaaveira.” ");
INSERT INTO roo_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Oa iava Jisas voeare oiso puraroepa, “Easi visii uvuipatai vai pasi ra vova sara irara vai aio kavu piepata oea iava rera sarato riako ousa aueparo, vo osa voea raga ruvara-ia toupareve, eke? Ari viapau uvuipai. ");
INSERT INTO roo_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Oire uva utupavira ora voea iava rera veraive oearovu vo osa riako ouro. Ra va iava tauaivira toupaoro viapau oiso vorerivira voea tapo toupareve evoea sara irara. Oire uva vo voki-a vao oa-ia aio kavuave taru rerapa siraopaoro. Osa eisi ragai voeaaro tapo toupaivoi. Oa vituaro iava viapau aio kavupaaveira vo ragai tapo toupaoro.” ");
INSERT INTO roo_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Uva Jisas voeapa oavu reo ruu tapo vatereva. Oa-ia oiso puraroepa, “Viapau oiso irai uvuiparoi ra airepatoa vai kuvupatoa vai karireve, ra rutatoa vaiva oai turureve karia vai-ia. Oire vosa irai oisi oai piereve, ra rera raga airepato vuri piereve. Ra va iava va vao airepa varoa viapau oiso areiivira kekepa piro vao tapo ruta. ");
INSERT INTO roo_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ora viapau irai uvuipa ra airepa wain ovi vai kuvureve ruta rakari vai-ia aue meme. Oire vosa irai oisi oa-ia piereve airepa wain vai kuvuoro, ra ita va vao ruta rakari karikari piro vo osa riropape airepa wain. Ra va vao wain ovi rasiua arore koko piro. Oire ra ita meme rakari tapo vuri ovoipe. ");
INSERT INTO roo_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Uva oirato uvuiparoi ra airepa rakari-ia airepa wain kuvureve. ");
INSERT INTO roo_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ari ro ira rutapa-ia ukaioro wain, ra ita viapau oiso auepa airepa ruipaparo. Oire ra oiso puraro, Va vao vearopai uvare airepa-ia putepai aue wain!” ");
INSERT INTO roo_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ovokivu-ia Sabat voki Jisas wit kovo sovara-ia vokapareva. Vo osa voa rera voeaaro disaipel okokorovu ouiva aue wit. Oa iava vara ruviruviiva ora voeapa vara aiosa. ");
INSERT INTO roo_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Uva oeavu ratarataa vovou irara Farisi-pa irara oiso puraaepa, “Easi varao tugoropapeira Sabat voki-ia. Uva apeisi iava oiso pieivoi?” ");
INSERT INTO roo_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Oa iava Jisas oiso puraroepa, “Easi pasi, viapau vao vieipataveira osa tuariri rutu Devit ora rera voeaaro tapo ogoeroepa? ");
INSERT INTO roo_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Uva Devit Pauto vo kepaaro-ia koataroepa bret ousa pristo ruvara-ia, vao oa oisoa Pauto osireiaro-ia toupaive. Va-a vao tugoropa bret oa oisoa aiopaive koruou purapa irara raga pris irara. Ari ita, uva Devit va aioreva rera voeaaro tapo Reo Taisi-ia gasioro. Osa-a eisi osa ragai voeaaro tapo viapau oiso vuria vai purapaivoi wit aiopaoro vo vokio-ia.” ");
INSERT INTO roo_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Oa iava oiso puraroepa ora rera iava Jisas voea ruture, “Oirato Oviitoaaro raga ira uvuiparoi vo oirara rutu vo pitupituroaro rovirieipasa varao opitupituroa purapaiveira vo Sabat voki-ia.” ");
INSERT INTO roo_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Vo oavu-ia Sabat voki Reo Taisi Uvupa Kepa-ia Sinagog koataroepa. Oa iava voa oirara tarai piepareva siposipopaoro. Uva voa iravu oirato toupareva ira iava oirapapa vavae vuriepa kopiioro. ");
INSERT INTO roo_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Uva riro tarai irara Reo Taisi-ia voearei ora Farisi oearea rerava siituepaaepa Jisas. Uvare oiso ruipapaaepa ra oai iava rera tavatavaeive. Vo rara taraiave rera-ia oiso, Ari Sabat voki-ia va purarevoi upiapa irara porete piepaoro. ");
INSERT INTO roo_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Uva rera raga voea oriorisi ovoioro voea vo vovouroaro-ia tarai ovoiroepa. Oa iava rera tavireva ira iava vavaea kopiiepa oiso, “Uriou. Ra vo-ia torevira toupari.” Oa iava toreroepa. ");
INSERT INTO roo_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Uva Jisas voeare oiso puraroepa, “Visii akea oiso, Apeisi purapai vao Reo Taisi vigei vaaro, ra vuria purapape, eke vearoa purape oirara-ia vo Sabat voki? Ora oirato porete piepe, eke rera kopii piepe?” ");
INSERT INTO roo_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Uva voea rutu-ia vuraoro rera tavireva oiso, “Vavaea irairari va torevokooro.” Uva oisi va piereva. Oa iava rera iava vavaea torevoko ovoiepa vorevira. ");
INSERT INTO roo_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Oire uva rirovira rutu kasipu iraopaaepa. Oa iava voea raga ora reopaoro oiso purapaaepa, “Avoeao! Eake vai purapere ro-ia Jisas?” ");
INSERT INTO roo_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Uva vo vuuta-a vao oa-ia Jisas iparoepa pukuia-ia varirisa Pautoa iare. Oa iava avia-ia rekasiroepa variripaoro. ");
INSERT INTO roo_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Uva ravireo kaero viroiva, voeare keeraroepa disaipel voea rutu oea oisoa rera sirova utupaave. Uva voea iava katai tau erao (12) reesireva. Oa iava voeapa aposelpa vaisi vatereva voeao reo kaepa irara rera voeaaro. ");
INSERT INTO roo_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Uva voea katai tau erao vaivaisiaro-a voeao-ia, Saimon uva Jisas rera-ia Pita-pa vaisi tovoreva, ari Andru, Saimon araokoaro, ora Jems araorei ora Jon, ora Filip, ora Batolomyu. ");
INSERT INTO roo_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Ari Matyu, ora Tomas, ora Jems aue Alfias oviitoaaro ora aue Saimon, rera raga aue Selot. ");
INSERT INTO roo_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Ora Judas, Jems oviitoaaro, ora Judas Iskariot ro ira Jisas kosi piereva keripa irara vavaearo iare. ");
INSERT INTO roo_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Uva Jisas katai tau erao (12) tapo vararoepa tuuria iare voa toresa oearovu tapo riro irara disaipel rera voeaaro. Oa iava voa riro irara rutu voea tapo toupaiva vorarova voea Judia Distrik ora Jerusalem ora voraro tapova avakava sirova aue ruvara-ia Taia-iarei ora Saidon-ia. ");
INSERT INTO roo_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Oea rutu uriopaaepa rera vo reoaro uvupasa. Ora oiso tapo ra voea iava upiara verapareve. Ora voea ro oea-ia oisoa vuri tugararo toupaive oea tapo urioaepa. Oa iava Jisas voea rutu ravotovira porete pie ovoipareva vo tugararo kosi piepaoro. ");
INSERT INTO roo_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Uva voea rutu oirara rera-ia vavaeara tovo ruipapaaepa. Aue iava uvare rera vo goruaro ava ovoipaepa oirara porete pie ovoipaoro. ");
INSERT INTO roo_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Oire uva Jisas ora rera voeaaro-ia disaipel vuraoro oiso puraroepa, “Visii vao apota irara Pauto vo taraiaropa visiigoa roruta, uvare visii-ia Pauto vo Saraaro-ia toupataveira. ");
INSERT INTO roo_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Ora visii vao visiigoa ovovourovu rutupa torevoko vovouro ruipa iraopata oiso osa ro ira ogoeparo auepa aio visiigoa rorupata. Uvare Pauto visii vo ruiparoaro uvui pieoro vaterovere visiipa. “Ora visii vao visiigoa gaupataveira visiigoa tapo roruta. Aue iava uvare utupaua taru agesitavere rorupaoro aue-ia Pauto vaaro kaviko vovou. ");
INSERT INTO roo_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Vo utupaua oirara rutu visii vuraivere osa ragai sirova utupata. Ra va iava visiire rirovira rutu vuri vovou iraopaave. Oire ra vurivira rutu visii vaisiaro akaipa piepaive visii tovipaoro. Oa-a eva oa-ia uvuipatai ra rorupata. ");
INSERT INTO roo_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Vosa oisi visii piepaive, ra va-ia rorupata vearo vovoupaoro rutu. Uvuta! Riroa rutu epao voria visii vaaro vuvuiua-ia. Ari ita, voeao aao irara oaive oea oisi raga eisi oisoa profet irara piepaive voari tuariri. ");
INSERT INTO roo_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Ari visii vao-ia riro moni guru irara visiigoa ora vatatopo iraopata. Eake iava? Uvare visii roru piepaiveira varao oara-ia pitupataveira varao vo rasio iava. Oara rutu opesipere visii arova vo utupaua. ");
INSERT INTO roo_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Visii vao visiigoa aiopatavoi oa iava vukupatai, visiigoa ora vatatopo iraopata rutu. Visiigoa taru ogoetavere utupaua. “Ora visii vao visiigoa agesipataveira, visiigoa ora vatatopo iraopata. Visiigoa gautavere utupaua, ra visii osireiaro-ia gau oviro varape. ");
INSERT INTO roo_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ora vatatopo iraopata. Teapi visii vaisiaro-ia vuurapa vaisi pura ragapaive oiso rutu osa oisoa voari tuariri voea aao iraraaro piepaive oearovu iava profet irara riro kuuvu irara. Aue vituaro iava uvare oisoa oearovu roru pie ragapasa oreorovu raga kuuvu reo oisoa purapaive. ");
INSERT INTO roo_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ari ita, visii tavipaavoi vao visiigoa ragai vo reoaro uvutavoi, oiso ra voearova agiagipata oea visiiva ora keripaaveira. Ora voea tapo ora vearo vovoupata oea visiiva ora vuri vovoupaaveira. ");
INSERT INTO roo_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ora voeaopa tapo vearo vovou vatepata oea visii vuri piepasa oreorovu purapaiveira. Ra tapo variripata voea tauvapasa voeao oea visii tovipaive. ");
INSERT INTO roo_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Vosa irai vii tautauaro tapareve, oire otautauvu ita poreri rerapa, ra va tapareve ita. Ora vosa irai vii kuvupatoa vaiaro itopareve, opeita rerare korukorupau. Rera vate vo popota rutu ora siglis. ");
INSERT INTO roo_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Vosa irai vii arepareve orekevu avu vaire, rera vateri oai. Ora vosa irai vii oavu avu vaiaro oureve, oire ra viapau oiso va voreri vorevira rera ruvara-ia. ");
INSERT INTO roo_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ari vosa vo vovouroa vo oarapa ruipapata oiso ra oirara vara purapaive visiipa, oire ra visii tapo oisi vara pura rovopata voeapa. ");
INSERT INTO roo_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ora vosa voea ragapa sirao vovouro oavisii vatepata voeao oea visiipa sirao vovouro oaive vatepaive. Ra eake vai vearoa outa Pauto ruvara-ia, raa? Ari ita! Oiraopavira voeao vuri irara oea oisi raga ora voeapa sirao vovouro oaive vatepaiveira voeaopa oea voeapa sirao vovouro oaive vatepaive. ");
INSERT INTO roo_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ora vosa voeaopa vearo vovou purapata oea visiipa vearo vovou purapaive. Oire ra eake-a vearoa oa outa Pauto ruvara-ia? Oiraopavira, voeao vuri irara oea oisi raga ora voeapa sirao vovouro oaive vatepaiveira voeaopa oea voeapa sirao vovouro oaive vatepaive. ");
INSERT INTO roo_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ari vosa voeapa orekerovu vatepata ra oisi rugoopata, Vorevira visiipa vara kare piepaive. Oire aa vao-a vearoa oa outavere Pauto ruvara-ia va-ia vao, raa? Ari ita, voea tapo vuri irara orekerovu vatepaiveira voearopa oearovu vuri irara oisore ra kataia raga oupaive vorevira. ");
INSERT INTO roo_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Voeao agiagipata oea visiiva ora keripaaveira, ora voea-ia vearo vovou purapata, ora voeapa orekerovu vatepata. Ra viapau varare vorevira rugoopata oiso ra oarai kare piepaive visiipa vara iava. Oire vosa oisi oiso piepata, ra va iava riroa rutu voria visii vaaro. Uva voeapa siraopaoro oea viapau vearo vaisi purapaiveira visii-ia, uva oiso purapaoro oiso rutu toupata, Pauto ovii iraraaro ro oiso viara-ia. Uvare ro Aite ira voeaopa siraoparoveira oea viapau rera-ia vearo vaisi purapaive. Ora voeao vuri irara oea ora voea raga-ia rugorugoopaaveira, oea tapopa vereopa vovou purapareveira. ");
INSERT INTO roo_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Oirarapa siraopata oiso osa Aite oavisii siraoparoveira. ");
INSERT INTO roo_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Opeita oirara vo vovouroaro rovirieipata oiso osa jas, eva-a oa iava viapau ita Pauto visii rovirieireverea. Ora vosa viapau oirara toga ragapata oreorovu-ia, oa iava ita Pauto viapau visii ita togareverea vo utupaua. Ari oiso ruipaparai ra oirara iava vuriara vera ragapata, oa iava ita Pauto visii iava vuri vovouro verarevere. ");
INSERT INTO roo_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Orekerovu avu vai vatepata oearoipa. Oa iava Pauto visiipa ita oarai vaterevere oisi ragavira ita osa vao, osa visiipa vavaeara agasi pierevere rutu Pauto pute pievira visiipa vateoro. Vo uvuio-ia oa-ia oearovupa oaravu vatepata, oire uva vo uvui raga-a eva oa-ia visii vaterevere ita Pauto.” ");
INSERT INTO roo_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Oire uva Jisas oavu tapo reo ruu vatereva voeapa oa-ia oiso puraroepa, “Easi pasi, voositoa vai uvuipa ra irai voositoa vai tuvetuvepareve raiva vai-ia pasi, eke? Uva viapau. Ra ita vaiterei rutu kovesi vo rikui-ia. ");
INSERT INTO roo_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Viapau oiso tarai taraapato rera reraaro-ia puteparevoi tisato. Ari vorara tarai rovoro, oire ra rerava tisato oaro areiireve. ");
INSERT INTO roo_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Eakere korotoava vurapari eera araokoara osireiaro-ia, osa viapau riro perore rugoo rovopau eva vii osireiaro-ia? ");
INSERT INTO roo_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Uva apeisi ragavira uvuipau ra araokoara taviri oiso, Araoko, ragai oiso ruipaparai koroto veraa eera vii osireiaro iava. Vorara viapau ora vii iava evo keposi riroa rutu viapau vera rovori, vao vuri vovou oa vii tupapai? Ari ita, riro ratarataa vovoutoa rutu vii. Viigoa riro pero rutu vera rovori eva vii osireiaro iava. Viigoa ora osireiara sisiro rovori vearovira. Oa iava araokoara osireiaro sisirorivere rara. Oire ra va iava vearovira vuravurapaoro koro verauvere araokoara osireiaro iava. ");
INSERT INTO roo_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Vao vearo ova oa viapau oiso vuri kuero vai purapaiveira. Eisi osa raga ita vao vuri ova oa viapau oiso vearo kuero vai purapaiveira. ");
INSERT INTO roo_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Oire uva oirara oisoa vo eva kuearo keke rovopaive auere tarai rovosa vearovira oiso, O vearo ova, eke vuri ova. Oirara viapau oiso ra rokarokapa iroiro-ia fik ova kuearo oupaive. Ora viapau oiso ra kapuasisi kouro sovara-ia wain kuearo oupaive. ");
INSERT INTO roo_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ari ita, ro vearoto oirato ira-ia vearo rugorugoo rutu toupaive vo rera sopaaro-ia, eva-a oa vituaro iava vearo pitupituro ita purapareveira. Ari vosa ro ira-ia vuri rugorugooro toupaive, oire ra oisi raga ita vo pitupituro kosi piepareveira varao oara iava rera iava sopaua agasipapeira, vo rara vova rera gisipoaro-ia kosipa piro reoara. ");
INSERT INTO roo_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Eakere ragai vaisipatavoi oiso, Turaro, Turaro. Vo osa viapau ragai sirova utupataveira varao-ia oara-ia visii tavipaaveira? ");
INSERT INTO roo_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ari ro ira ragai iare urioparo ragai vo reoaro uvupasa ora ragai vo reoaro purapasa, ira-a eera oiso toupare osa ro ira iava visii tavipaavoi. ");
INSERT INTO roo_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ro-ia oirato ira kepa paureva. Oire uva riro kaekaevira rikui teka rovoreva. Oa iava voava aue simen tovoreva rirova-ia aveke oira voto pie rovooro rutu vo rasito sovara-ia. Ra oira ivara-ia vo kepa tore piereva o-ia aveke. Uva utupaua pirutuva urioopa. Oa iava viapau uvuiopa vo kepa tatesa. Ari va vurevure ragapaeva. Eake iava? Uvare vearovira rutu vo kepa paureva goruvira. ");
INSERT INTO roo_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ari ita, ro ira ragai vo reoaro uvu ragareve ra viapau va sirova uturo, oiso osa ro oirato ira rasito raga-ia kepa paureva. Uva viapau simen tovo rovoreva vo rasito sovara-ia. Oa iava pirutuva vo kepa-ia ora vikiopa ovusa ikauvira peka ovoi piropa. Oa iava vuri ovoiepa rutu.” ");
INSERT INTO roo_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Oire uva Jisas vo reo oirarapa vaterevoiva, Kapaneam-ia kare uvirosa avaroepa. ");
INSERT INTO roo_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ovusa voa Rom ami keptentoaro toupareva ira reroaro katai vovoto (100) viurupa irara oisoa toupaive. Ira reraaro kovopato toupareva ira oisoa kavikopareve rutu. Uva upiaparoepa kovopato. Oa iava tutuu pieepa rerapa rutu oiso ra kopiiro. ");
INSERT INTO roo_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Oire uva rera kepten Jisas iava uvureva osa toupareva. Osa iava oearovu tuvetuvepa irara Jiu iava voea arureva rera ou piesa, oiso ra urioro rera ro kovopato porete piesa. ");
INSERT INTO roo_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Uva rera-ia poua viropa Jisas. Oa iava goruvira rutu rera kegipaoro oiso purapaaepa, “Vearotoa rutu ira reraaro-ia uvuipau ra rera vearo pieri rera tauvaoro. ");
INSERT INTO roo_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ira vigeipa sopaua rutu vatepareveira vigei vao Jiu. Uva rera raga vigei vo kepaaro paurevora vao Reo Taisi Uvupa Kepa Sinagog.” ");
INSERT INTO roo_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Oire uva Jisas voea tapo voreroepa. Oa iava kepa iare tutuu piereva. Uva rera ro kepten oearovu arureva ora rera vate iraraaro rera tavisa Jisas oiso, “Turaro. Viipe. Teapi ora reasi pie ragau. Ari ita, viapau oiso vearoto-a ragai, ra uriou ragai vo kepaaro-ia koatasa. ");
INSERT INTO roo_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Uva oisi-a eisi osa rugoorai oiso, Viapau vearoto-a ragai, ra vii iare uriora. Uva oiso ruipaparai ra evoa ragava reou, ovusa ro ragai reraaro kovopato porete ovoiro vorevira. ");
INSERT INTO roo_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Eake iava? Uvare ragai tapo ro ita reroarovi toupaavoi ira ragaipa kovo vatepareveira. Ari ita, ragai raga oeavuva toupaa viurupa irara oea ragai reroarovi toupaiveira. Oa iava oiso voea piepaaveira. Vosa irai arua voea iava oiso, Avau. Oire ra irai avaro. Ari vosa iraire voea iava keerara oiso, Uriou. Ra ita irai urioro. Ari vosa ragai kovopatoaaro tavia oiso, Vo kovo purari. Oire ra oai purareve.” Oiso puraroepa kepten. Uva evo reo oa kosi pieva Jisas vo goruaro. ");
INSERT INTO roo_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Uva Jisas vo reo vao uvuoro rirovira rutu rugorugoo iraoparoepa rerare ro oirato. Oire voava ora poreroepa voeaore riro irara oiso purasa, “Oiso visii tavipaavoi, Oiraopavira rutu, Viapau oiso irai oirao pie vovoutoa vai kekeavora Isrel-ia oiso osa ro-ia Rom amipa irara irapato.” ");
INSERT INTO roo_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Oa iava voeao oea arureva rera kepten oea vorevira voreaepa kepa iare. Uva voa rera kovopato kekeiva osa porete ovoiroepa ravotovira. ");
INSERT INTO roo_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Uva utupa visivi Jisas ouruivu iare avaroepa vo urui vaisiaro vao-ia, Nen. Uva rera voeaaro disaipel ora riro irara rutu oea rutu rera tapo avaaepa. ");
INSERT INTO roo_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Oire uva riro ratao iare tutuu piereva vao vo urui vo rataoaro, ovusa iravu oirato kaepaoro kosia viropa kopiito. Uvava aakova oisoa raroevira toupaeve ro raga tapo kataito oviito. Iria sirova utupaaepa riro irara oirara vo kae sirova. ");
INSERT INTO roo_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Uva Turaro oira o riakova kekereva. Oa iava rera iava sopaua siraoepa rutu. Osa iava oirare oiso puraroepa, “Auoo. Opeita gaupari.” ");
INSERT INTO roo_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Oire uva vo kes ruvara iare avaroepa va-ia pitusa vao urua peperava uru. Uva voeao oea vo kes kaepaiva oea voavi torepaaepa. Oa iava Jisas oiso puraroepa, “Viovokoto. Vii tavipaa oiso, Vorevira toou, ra toreu.” ");
INSERT INTO roo_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Oa iava rera ro ira kopiiroepa ora porete ovoioro toreroepa voa paupasa. Oire voava rovoroepa reoreopaoro. Oa iava Jisas aakovapa rera vatereva. ");
INSERT INTO roo_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Uva oisi-a eisi osa iava oirara rutu rirovira rutu ropeaepa. Oa iava Pautoa-ia vuurapa vaisi puraiva oiso puraoro, “Iravu ro-ia reito profetato. Ira vigei vuutaaro-ia pouro viroi.” Uva aia ita oiso puraaepa, “Pauto ro-ia ira vo pouro viroi rera voeaaro oirara tauvasa.” ");
INSERT INTO roo_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Uva rera iava Jisas vo siposipo viriva oiso Judia Distrik sovara-ia ora uvarovu rutu. ");
INSERT INTO roo_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Uva vara rutu iava voeao Jon voeaaro disaipel rera taviiva. ");
INSERT INTO roo_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Oa iava voea iava aitereivure keeraroepa disaipeltoarei. Uva vaiterei arureva Jon oreovu siposa Turaropa. Oa-ia oiso puraroepa, “Tuariri oeavu oirara oisoa oiso purapaave, Iravu oirato ira urioroverea Pauto reraaro. Easi vii vai-a vao viigoa uriouei? Eke iravu raga-a irare tuepaioveira?” ");
INSERT INTO roo_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Uva Jisas iare uriosiepa aitereivu. Oa iava oiso purasiepa, “Jon Baptais vegei arurevoi vii iare ira oiso puraroe, Easi vii vai-a vao viigoare tuepaiei osa uriouei. Eke irai raga-a irare tuepaiei?” ");
INSERT INTO roo_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Oire uva vo vuuta-a vao oa-ia Jisas riro irara ravotovira porete piepareva oea-ia oupiarovu rutu oiso toupaive oiso-ia, oearovu-ia oisoa vuri tugararo toupaive, ari riro irara voosi irara oearoa tapo vorevira vuravura piepareva. ");
INSERT INTO roo_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Uva oiso puraroepa vaitereire, “Voresi Jon tavisa varao rutu iava oara kekesivoi ora varao oara uvusivoi oiso-ia, voosi irara vorevira vuravuraivoi. Ora voeao vuri kokoto irara oea tapo vorevira vokaivoi. Ora voeao leprapa irara oea tapo vorevira sisigarueai. Ora voeao uvagi irara oea tapo reo uvuai. Ora kopii irara oea tapo vorevira toreai. Ora voeao apotapa irara oea tapo Vearo Siposipo uvuivoi. ");
INSERT INTO roo_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ari ita, ro ira ragai goruvira oirao pieparevere rutu ira uvuipa ra viraakoa ouoro rorupareve vo ragai.” ");
INSERT INTO roo_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Oire uva Jon vaitereiaro disaipeltoarei karesiepa. Oa iava oirara rutu tavireva Jisas Jon iava oiso puraoro, “Eaketo-a ro ira kekesa avataera vo raaka tapi vo vokio-ia oa-ia Jon iare avataera? Esa pito isi vai-a aisia va ratesa avataera, ovusa kiuvu vaisi vurevureparevora, raa? Viapau. Uvare Jon viapau oiso raverave vaiva siposiporevora oiso osa pito isi. ");
INSERT INTO roo_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Eke eake-a oa kekesa avataera voa. Easi pasi visii vai irai vai kekesa avataera osa vearopara vai-ia kuvupara vai kuvuparoera voa? Eke viapau? Oearoi pasi oea vai-ia vearopa kuvuro vaiva toupaivora voa ora varao vearopara voea varaaro-ia, varao oarava toupaiveira king irara vo voea vo keparoaro-ia. ");
INSERT INTO roo_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ari eake irao-a oa kekesa voa avataera? Easi irai vaia eera profetato? Iu. Ragai visii tavipaa oiso, Eera profetato Jon ira oearovu rutu-ia profet irara puterevora rei vaisi oupaoro. ");
INSERT INTO roo_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Voari tuariri uva Jon iava Pauto Tugoropa Vuku-ia taviroepa oiso, ‘Ragai Pauto iravu sipopaa reo kaepato. Ira viipa iraparoverea viipa raiva vatatoposa.’ ");
INSERT INTO roo_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Uva oiso visii tavipaavoi, Jon voeao rutu-ia puterevora oea vo toupaiveira rasitoa-ia. Ari ro ira Pauto vo Saraaro-ia ora akaipa pieparoi, ira ita Jon-ia puteparevoi rei vaisi oupaoro.” ");
INSERT INTO roo_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Oire uva vo reo-a vao oa uvuiva Jisas oa purareva. Oa iava voea rutu ora reopaaepa ora voeao takis oupa irara oea rutu oiso puraaepa, “Iu. Ari Pauto vo pitupituaro-a torevokoa.” Oreoroa varao voea varaaro oirao piepaoro baptaisa oupaiva Jon vavaearo-ia. ");
INSERT INTO roo_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Vosa voeareo ratarataa vovou irara Farisi ora voeao riro tarai irara Reo Taisi-ia oearea viapau oiso baptaisa ouiva Jon ruvara-ia. Eva-a oa vituaro iava isivaaepa vaore vearo raiva Pauto vaaro. ");
INSERT INTO roo_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Uva va-a vao oa iava Jisas voeare oiso puraroepa, “Uva eake vai-a vao oa visii vao vo vokio iavapa irara reesiavere oiso apeisi raga irara? ");
INSERT INTO roo_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Visii vao visiigoa oiso rutu toupatavoi osa voeao kakae vure oea uruia vuutaaro-ia paupaaepa okakae vure keerapaoro. Oiso purapaaepa, Ari ita, igei visiipa pupiara-ia pupi ragapaio, osa kovaa arapa reasipatai. Ora visiipa gau eraro-ia kovaa ragapaiei, osa gau arapa reasipatai tapo. ");
INSERT INTO roo_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Uva Jon Baptais urioroera. Uva viapau breteara vai aioparevora. Ora tapo viapau wain oviro vai-ia ukaioparoera. Oa iava eva oisoa oiso purapata rerare, Vuri tugararo ira-ia toupaiveira ro-ia Jon. ");
INSERT INTO roo_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Oire uva Oirato Oviitoaaro ragai urioraera aiopasa ora ukaiopasa tapo aue-ia wain. Oa iava oiso purapataera, Rera keketa eera riro aioto ora riro ukaioto riroara-ia aue wain oviro. Takis oupa irara vatetoaaro ora voeao vuri irara. Eisi osa ragaire purapataveira visii. ");
INSERT INTO roo_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pauto vo taraiaro-a vegei vo kovoaro vituaro ora Jon. Eisi osa vegei vo kovoaro kuearo eveipaivere.” ");
INSERT INTO roo_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Oire uva iravu Farisi-pato Jisas-re keeraroepa rera tapo aiosa. Oa iava rera iare avaroepa. Uva pauroepa aiosa. ");
INSERT INTO roo_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Uva voa iriavu vo urui-ia vuriva riakova toupaeva. Oa iava voa toupaoro rera iava Jisas uvueva ovusa rera tapo Farisi-pato aiopareva vo rera vo kepaaro. Oa iava oira o riakova oavu vearo ovi rutu sanda ovi ouoro urioopa, oovia popotepa tou-ia aveke tou sovara-ia toupaiva. ");
INSERT INTO roo_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Uva Jisas isivaaro iare avaopa rera kokotoaro ruvara iare. Oa iava gaupaeva, vo osa oira osireiaro iava gau oviro kovekovepaepa rera kokotoaro iare Jisas. Oa iava ora oira oruaro-ia vara posiposi piepaeva rera kokotoaro iava. Oire vo osa rerapa avivikepaoro rera kokotoarova uugaapaoro rera kokotoaro kipupaeva aue-ia sanda ovi. ");
INSERT INTO roo_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Uva va-a vao oa kekereva rera ro Farisi-pato, ira rerare Jisas oiso rugorugooparoepa ora rera raga sopaaro-ia, Vosa oiraopatoa rutu rera ro profetato, oire ra va iava oira-ia tarairo iria rera-ia vavaea tovosa uriooi. Ora varao-ia tapo oira vovouroaro tarairo vara eveioro. Ra oiso auero, Vuriva o-ia otopava. ");
INSERT INTO roo_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Uva Jisas Farisi-pato vo rugooroaro pukoreva oiso puraoro rerare, “Saimon. Ragai reo-a vao oava oiso ruipaparai ra vii vatea va.” Osa iava Saimon rerare oiso puraroepa, “Oire Tisato vo reo kosi pieri.” ");
INSERT INTO roo_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Oa iava Jisas oiso puraroepa, “Aitereivu oiratoarei aiterea iravu vaaro moni ou ragasiva oiso, iravu aue uvuiaro vo vavae vovoto kina (K500), ari iravu aue vo vavae tau kina raga (K50). ");
INSERT INTO roo_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Oire uva viapau oiso uvuisiepa oiso ra varei kare piesi vorevira rerapa ro oirato. Oa iava vaitereipa varei eaka ragareva. Oire uva iroutoa vaiei vaiterei iava ira pute pievira rorupaoro ora rera iava sopaua vaiaro vaterevere rerapa ro oirato?” ");
INSERT INTO roo_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","“Ari ro oirato ira riroa rutu ou ragareva,” osa puraro Saimon. Oa iava Jisas oiso puraroepa, “Ari ita, torevokovira oisi rugoouei eisi.” ");
INSERT INTO roo_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Oa iava oirare ora poreroepa o-ia riakova oiso purasa rerare Saimon, “E oira kekeri o-ia riakova? Ari ita, vii vo kepaaro-ia koatasa uriorae. Uva viapau ragai vaterivo uukoa vai kokoto sisusa vao ragai iava vigei vo pitupituaro sirova utupaoro. Osa o riakova ragai kokotoaro sisuevoi ora oira osireiaro iava gau ovi-ia. Oa iava ora oira iava orui-ia vo ovi posiposi pieevoi. ");
INSERT INTO roo_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ora viapau oiso ragaiva uugaaue. Ari ita, vosa koatarae uva oisi raga ita oiso osa toupaavoi vaviopavira. Oa iava oira o-ia riakova iria ragai kokotoarova uugaapaoi touvira ragaipa avivikepaoro. ");
INSERT INTO roo_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ari ita, ragai kukuearo viapau iisirivo korovo ovi vai-ia. Ari o riakova ragai kokotoaro iisievoi vao-ia korovo ovi aue sanda. ");
INSERT INTO roo_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Oire uva oisi-a eisi osa iava vii tavipaavoi oiso, Oira-a o riakova iria ora oira iava sopaua rutu vate iraoevoi ragaipa, uvare oira varaaro-a riroara vuriara, oara verarevora Pauto. Ari ita, Pauto oavivu garea vuria verareve iravu iava oirato, oire ra oisi raga ita ro oirato ora rera iava gare visivi sopaua vatereve iravupa oirato.” ");
INSERT INTO roo_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Oa iava Jisas o riakova tavireva oiso, “Vii iava vuriara veraavoi.” ");
INSERT INTO roo_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Uva rera tapo paupaaepa oirara tebol-ia voeao oea voa rovoaepa rerare oiso puraoro, “Avoeao! Iroutoa rutu-a ro-ia ira vuriara verapare?” ");
INSERT INTO roo_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Uva Jisas oirare oiso puraroepa, “Ari ita, ragai oirao pierivoi, oa iava vii iava vuriara veraavoi. Avau, ra kave vovouvira toupari.” ");
INSERT INTO roo_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Oire uva utupa visivi riropa uruiro-ia virireva Jisas ora garepara-ia tapo voraro vokapaoro. Uva Vearo Siposipo vao Pauto vo Saraaro iava voeapa oirara oisoa siposipopareve. Uva voea disaipel katai tau erao (12) rera tapo vokapaiva. ");
INSERT INTO roo_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ora airorovu riakora airoa iava tuariri tugara verapareva Jisas ora oupiarovu rutu. Airoa-a vairo oriakora rera tapo vokapaiva oiso-ia, iriavu o-ia Maria iria vova Makdala urui iava. Iria iava Jisas erao vatara (7) aue tugara verareva. ");
INSERT INTO roo_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ora aue Joana rera Susa vatuavaaro, ro ira Herot vo kepaaro-ia oisoa tokipareve. Ora o-ia Susana, ora airorovu rutu tapo rera tapo avapaaepa airoa Jisas tauvapaiva ora voea disaipel aue-ia moniara varao vairo varaaro. ");
INSERT INTO roo_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Uva oirara rutu urioaepa ora gurusa Jisas iare voeao vova uruiara rutu iava. Oa iava voea vatereva oavu ruu reo. Oa-ia oiso puraroepa, ");
INSERT INTO roo_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Uva iravu oirato avaroera wit takuraro vikisa varuparo. Oa iava vara vikiparevora. Uva oaravu raivaro kovepaera. Oa iava voa vara-ia tasiasipaivora oirara. Uva kokio kare vara aiopasa uriopaaera voa. ");
INSERT INTO roo_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Uva oaravu witara kovepaera vo uva avekeara toupaivora. Oa iava voa kova ragapaera osa viapau aue uukoa vai. Uva vorevira kopii ovoipaera voa erako ovoipaoro. ");
INSERT INTO roo_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ari oaravu witara vo kovepaera vo kokopa kouro sovara-ia varao rokarokapara. Oa iava voa vo kovaro ururao papatapaivora vara ruupaoro witara. ");
INSERT INTO roo_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ari oaravu witara vo kovepaera vearopa rasiro-ia. Oa iava voa rirovira rutu kuepaera oiso, oaravu katai vovoto (100) kuero puravora.” Uva Jisas oisi oiso puraroepa. Oa iava rirovira oiso ita puraroepa, “Ro ira-ia kokito toupareve, oire vo siposipo orirureve va kuverapaoro ora rera sopaaro-ia.” ");
INSERT INTO roo_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Oire uva rera voeaaro disaipel va vituarore vao reo ruu rera akeiva. ");
INSERT INTO roo_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Oa iava oiso puraroepa Jisas, “Pauto raga visii tavipare vao vatau reo vituaro iava rera vo Saraaro iava vo reo. Ari oearovupa oirara reo ruuro raga vatepaaveira, oiso ra osireiara voea iava vura ragapaive, vo osa viapau vo reoro vituaro eveipaive. Ora vo reoro tapo uvu ragapaive, osa viapau taraipaive vara vituaro-ia. ");
INSERT INTO roo_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Vao reo ruu vituaro oiso toupai, Vao-ia wit takuraro oara oiso toupai, Eva Pauto vo reoaro. ");
INSERT INTO roo_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Oaravu witara vo kovepaepa raivaro oa oiso toupai, Oirara vo reoro uvupaiva, oa iava Seten urioparoepa vo reoro verapasa voea sopaaro iava. Uvare oiso rugorugooparoepa, Teapi vo reo oirao pieive, ra va iava Pauto voea vorereve vorevira ora rerapa. ");
INSERT INTO roo_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ari oaravu vo kovepaepa uva rirovira avekeara toupaiva, oa vituaro oiso toupai, Voeao-ia oirara oea ikauvira Pauto vo Saraaro iava vo reoro uvupaoro vara oupaiva vara-ia rorupasa rutu, osa viapau voea iava sopaura-ia oriruvira toupaive vo reo. Oreoa oiso toupai osa ikopito ro ira viapau avekeara rutu-ia goruvira toupare o pitupare. Oire utupauavi oearovu Pauto vo reoaro tekipasa opitupiturovu purapaive voeao oirara vuri piepaoro. Oa iava voea vaaro oirao pie vovou viapau uvuipai ra gorupe vo osa va kavuive. ");
INSERT INTO roo_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ari varao witara oara kokopa kouro-ia kovepaepa oa vituaro oiso toupai, Oirara evoea oea reoara uvu ragapaoro vokapaiva vo osa orugorugoorovu rutuva toupaiva vo ora voea vo touaro iava, ora orekerovu rutuva rugorugoopaoro moniara oaive, ora varao vearopara rutu oara-ia oisoa rorupaive. Oire uva vara-a varao oara Pauto vo reoaro oisoa vuri piepaive rutu vo voea iava sopaura. Ra viapau aio kue vai voea-ia karekepe. ");
INSERT INTO roo_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Vo osa varao vearopa rasiro-ia kovepaepa witara oara vituaro oiso toupai, Evoea oirara oea reo uvupaaepa, oa iava vara goruvira orirupaiva ora voea iava sopaura varao vearopaura. Oa iava kuepaepa voeapa vo osa goru vovouvira toupaive. ");
INSERT INTO roo_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“E oirara vuravu rukuepaiveira ra oira vataupaive baket sovara-ia, eke uruara reroaro, raa? Viapau! Asi oirara vuravu tovopaiveira tebol ivara-ia viaevira. Oire ra voava roropaeve osa vo aviaviva vurapaoro koatapaavere voeao oea vo kepa-ia toupaiveira. ");
INSERT INTO roo_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ari ita, varao oara vatauvira toupaiveira oara rutu poeravira ora karekeperea. Ora varao rutu varao oara tavurupareve oirato, oara rutu tapo oiso utupaua poeravira ora karekepe. Oire ra va iava oirara vara-ia taraiave. ");
INSERT INTO roo_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Ora vatatopo iraopata visii vao-ia ra vearovira reo uvu iraopata. Vosa irai oiratoa vai oisi vo reo-ia vao pitureve, oire ra ita Pauto aviavi pievira oreorovu ita vatereve rerapa. Ari ro ira oiso kearo, Vo reo ou ovoiavoi va-ia orirusa. Oire uva rera-a eera ira iava vo tarai eva verarevere Pauto.” ");
INSERT INTO roo_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Vo vuutao iava vo vokia aakova ora rera araoko iraraaro urioaepa Jisas iare, vo osa riro irara rutu ora gurupaaepa. Oa iava viapau uvuipaaepa ra rera iare tutuu pieive. ");
INSERT INTO roo_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Uva oearovu rera taviiva oiso, “Aakoara vase-a ora araoko irara oiso torepaai ratau. Oea vii kekesa auepaai.” ");
INSERT INTO roo_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Uva voea vo reoaro pukooro oiso puraroepa, “Ro oirato ira Pauto vo vovou sirova utuparo eira-a ragai aakoaro ora ragai araokotoaaro.” ");
INSERT INTO roo_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ovokivu-ia Jisas oavu-ia kaero viropa uvuoa disaipel iraraaro tapo. Oa iava voeare oiso puraroepa, “Oiso ragavira ivirovira toko rovu avapaviei.” Osa iava voare avaaepa. ");
INSERT INTO roo_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Uva uvuoa ikauvira avaaepa vo osa Jisas uusiparoepa va-ia. Oire uva riroto kiuvu vusireva voeare uuko rovu-ia. Uva tutuu piepa voeapa oiso ra opesiave. ");
INSERT INTO roo_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Oa iava Jisas tore piesa avaaepa oiso puraoro rerare, “Reito! Rokosa tutuu piei.” Oa iava toreroepa kiuvu rakote piesa ora rirova toruva. Oa iava vo vatako rutu rakote ovoiepa vao kiuvu ora toruva. Oa iava uuko rovu viapau oiso ora vurevurepaepa. ");
INSERT INTO roo_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Uva voeare disaipel oiso puraroepa, “Ovu-ia visii varaaroi oirao pie vovouro?” Osa iava rirovira rutu rugorugoopaoro voea raga ora reopaaepa oiso purapaoro, “Avoeao! Irouto-a ro-ia ira vo vatakore kiuvu ora uuko ovi reoroi, oa iava rera gisipoaro uvu ovoivoi?” ");
INSERT INTO roo_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Oire uva Gegesa-ia poua viropa Galili-ia vo toko rovu isivaaro-ia. ");
INSERT INTO roo_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Oa iava Jisas uvuoa iava rerereva, osa iravu oirato vo urui iava vao urioroepa rera iare, ira-ia oisoa vuri irara tugara toupaive. Ari ita, riro kaekaevira rutu oisoa varo tuu asavira toupareve. Ora tapo viapau kepaara vai-ia toupareve. Viapau. Ari tova urui raga-ia oisoa toupareve. ");
INSERT INTO roo_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Uva Jisas kekereva rera ro. Oa iava rirovira rutu oiveoro koveroepa rasiua arore rera kokotoaro ruvara-ia Jisas-pa avivikepaoro. Oa iava voava rerare riro akutaroepa oiso puraoro, “Jisas. Vii-a Pauto Oviitoaaro ro oiso rutu viara-ia. Viire variriparai oiso ra viapau ragai vuri pieri.” ");
INSERT INTO roo_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Uva oisi-a eisi osa puraroepa tugarato Jisas-re, uvare Jisas tugarato kosi piesa aueparoepa oiratoa iava. Aue iava uvare oisoa oiratoa-ia toupaoro rera varivari piepareve. Ra va iava sen tokopareve ora hankap, vorara vara-ia rera tuuke ragapaive. Oa iava oisoa rera tuvetuvepaoro vorarore kuvau tapiro rerava avaparo tugarato uva viapau oisoa oirara vai toupaive. ");
INSERT INTO roo_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Uva oisi-a eisi osa iava Jisas rera akereva oiso, “Irou vaisito-a vii?” Uva oiso puraroepa, “Ragai-a, Riro Irara.” Aue iava uvare riro irara rutu tugara irara oea koataaepa rera sovara iare. ");
INSERT INTO roo_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Oa iava voeao vuri irara tugara rirovira rutu Jisas-re oiso purapaaepa, “Teapi igei sigupari vuri tapi vaire rikui vai sovara iare.” ");
INSERT INTO roo_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Uva oavu koue ragui oa pukuia-ia ororoaro-ia aiopaoro voa toupaiva gare pukui raga. Uva va-a eva oa iare Jisas kegi iraopaiva oiso purapaoro, “Igei tariori vavore koue ragui-ia koatapasa.” Osa iava voea sipo piereva voare. ");
INSERT INTO roo_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Oa iava voeao vuri irara tugara rera iava ro oirato kosia viropa. Uva avaaepa koue ragui-ia koatasa. Oa iava vo ragui vao riro varivarivira ikauoro varaaepa vagapa-ia ora vikioro toko rovu-ia rokosa. Uva voa gisi ovoiaepa kopiioro. ");
INSERT INTO roo_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Oire uva va vao kekeiva voeao oea oisoa vo ragui tokipaive. Oa iava toriiva oirara rutu tavitavisa voeao oea riro urui-ia oisoa toupaive ora uvarovu rutu tapo. ");
INSERT INTO roo_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Uva oirara rutu va vao kekesa urioaepa. Oa iava Jisas ruvara-ia poua viropa, ovusa rera kokotoaro ruvara-ia pauparoepa varoa-ia tuupaoro, rera ro ira iava tugara kosia viropa. Uvare rera iava rugorugooara roroioepa vorevira. Uva va vao kekeoro rirovira rutu voea iava vovouisiro uririepa Jisas vo goruaro asavira. ");
INSERT INTO roo_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Oire uva voeao oea va vao kekeiva opitupitua purareva Jisas. Oa iava siposipopaiva va iava vao oa purareva ro oirato ira-ia tuariri vuri tugararo oisoa toupaive. ");
INSERT INTO roo_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Oa iava oirara rutu voeao vorarova Gegesa oea Jisas-re oiso puraaepa, “Vo kavuoro ava iraopauei,” uvare uriripaaepa. Oire uva va-a vao oa iava Jisas uvuoa-ia kaero viropa vorevira karesa. ");
INSERT INTO roo_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Uva rera ro ira kavuiva tugara Jisas kegipareva rutu oiso purapaoro, “Ruipaparai ra vegei rutu kareve.” Oa iava Jisas vorevira rerare koruroepa oiso puraoro, ");
INSERT INTO roo_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Voreu atoiare vo vii voaaro. Ra voa siposipori varao iava Pauto oara purare vii-ia.” Oa iava voare kareroepa voea rutupa oirara siposiposa vo rera vo uruiaro vara rutu iava varao Jisas oara purareva rera-ia. ");
INSERT INTO roo_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Oire uva Jisas vorevira kareroepa uuko rovu iviropaoro. Oa iava oirara rutu rera-ia rorupaiva. Uvare rerare tuepaaepa voea rutu, osa vorevira kareroepa voea iare. ");
INSERT INTO roo_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Oa iava iravu pouro viropa rera vaisiaro, Jairas reito Reo Taisi Uvupa Kepa iava rera. Ira urioroepa Jisas kokotoaro ruvara-ia rekusa. Oire uva voava goruvira rutu rerare oiso puraparoepa, “E uvuipauei ra urio iraou vore ragai vo kepaaro-ia?” ");
INSERT INTO roo_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ira oviivaaro kataivavi raga. Iria katai tau erao (12) iva-ia uvuipaopa. Oire uva tutuu piepa oirapa oiso ra kopiio. Oa iava voare Jisas avaroepa. Uva riro irara rutu oirara rera kovokovoiva voa rerare ora guruoro. ");
INSERT INTO roo_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Uva voa-a evoa uva iriavu riakova voea tapo toupaeva. Iria-ia kekira oisoa koveparo vokiara rutu-ia. Uva aue rutu uvuiaro-ia toueva rera ragava kekira katai tau erao (12) ivaro vo osa oira oupareve. Uva va-a eva oa-ia oisoa riroara moniara viki ragapaeve riro irara rutupa ruvarupa irara, vo rara oira ruvarupaive. Osa viapau irai oisoa oira iava vo upia opesi piepareve. ");
INSERT INTO roo_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Oire uva urioopa rera isivaaro iare tutuu pieoro Jisas. Uva voaviva rera iava varoa vatuaro-ia pitueva. Oa iava vagevagevira raga revasi upia opesi ovoiepa oira iava posiposi ovoioro. Uva viapau oiso vorerivira ita oira oupaiva vo upia eva. ");
INSERT INTO roo_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Uva Jisas ora rera-ia oira sovooro oiso puraroepa, “Irouto ragai-ia piture?” Oa iava voea rutu taeaaepa oiso puraoro, “Ae, igei viapau.” Uva Pita oiso puraroepa rerare, “Reito. Easi voeao vaio-a riro irara rutu oea vii kovokovoivoi viire ora guruoro.” ");
INSERT INTO roo_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Oa iava Jisas oiso puraroepa, “Iravu ira ragai-ia piturevoi. Oa iava oavure gorua rororai, oa avaei ragai iava irai vearo piesa.” ");
INSERT INTO roo_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Oire uva oira o riakova iria taraiopa. Uva viapau oiso uvuipaopa ra rerare vatauo. Oa iava rerapa uriripaoro rirovira rikerikepaopa. Uva rera ruvara-ia rekusa urioopa vo oirara rutu osireiaro-ia. Oa iava voea rutupa tavitaviopa vao vituaro iava oa iava vavaea tovoeva Jisas-ia pituoro. Uva oiso puraopa, “Ragai iava ikauvira raga upia opesi ovoiei.” ");
INSERT INTO roo_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Oa iava Jisas oiso oirare puraroepa, “Oviiva oaa, vii vaaro oirao pie vovouaro oa vii ravotovira porete pie ovoivoi. Avau. Ra vii iava sopaua gavaurevira toupaive.” ");
INSERT INTO roo_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Oire uva touvira reoreoparoepa, ovusa iravu oirato ro Jairas vo kepaaro iava urioroepa rera tavisa oiso, “Vii oviivaaro kopiioi rutu. Teapi touvira Tisato pugu piepari va iava vao.” ");
INSERT INTO roo_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Oire uva Jisas va vao uvureva. Oa iava rera vo reoaro aatooro oiso puraroepa, “Eakepa uriripauei? Ragai oirao pieri. Oviiva oara ravotovira poretepaoi vorevira tootoooro.” ");
INSERT INTO roo_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Oa iava Jisas avaroepa Jairas vo kepaaro iare. Uva voa voea rutu kosi piereva. Vo osa voeao raga tapo voare koataro Pita vase ora Jon, ora Jems, ora aiteto avukarei, vaitereo uvava oviiva. ");
INSERT INTO roo_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ovusa oirara rutu oirapa kakaeva gaupaiva. Uva va-a vao oa iava Jisas voeare oiso puraroepa, “Opeita gaupata. Viapau oiso kopiioi rutu. Easi eira uusi ragapaoi.” ");
INSERT INTO roo_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Oire uva rera agesipaiva rutu. Eake iava? Uvare oiso taraipaaepa, Iria o kopiioe rutu. ");
INSERT INTO roo_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Oa iava Jisas oira vavaearo-ia pituoro oirare oiso puraroepa, “Kakaeva toreu.” ");
INSERT INTO roo_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Oa iava tootooa oira iava kakaeva vorevira voreepa oira iare. Uva ikauvira vaaraa ovoiopa. Oa iava Jisas oiso voea tavireva, “Oirapa aioara vai vateta.” ");
INSERT INTO roo_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Uva aitetoarei rirovira rope iraopasiepa. Oa iava Jisas goruvira rutu oiso vaiterei tavireva, “Opeita irai tavipasivere.” ");
INSERT INTO roo_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Oire uva voeare katai tau erao (12) disaipel keeraroepa. Oa iava voea vatereva riroa gorua ora reesia tapo voeapa aue rei vaisi, oisore ra va iavirava vuri tugararo kosi piepaive, ora oaravu rutu tapo upiara. ");
INSERT INTO roo_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Uva voea arureva Pauto vo Saraaro iava siposipopasa ora upiapa irara tapo porete piepasa. ");
INSERT INTO roo_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Oire uva oiso voea tavipareva, “Viapau oiso ra oaravu avu vai rutu kaepatavere vokapaoro. Ora viapau oiso ra tooroara vai-ia pitupatavere vokapaoro, ora oapara vai, ora opo, ora moniara vai. Ora viapau oiso ra eraeraovira kuvupara vai-ia pitupata tapo ora visiipa. Uvare voea auearo-a visii tokipasa voeao oea tauvapasa avapatai. ");
INSERT INTO roo_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Vosa okepai-ia koatata, oire ra vo kepa raga-ia touta vo tugurasa uva vo kepa-ia toupaoro ouruivu iare topa uvirosa auepata ita. ");
INSERT INTO roo_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ari vosa viapau visii oupaive vore ora voea vo kepaaro-ia, oire ra vo urui eva kavuoro avata. Ra ora visii iava kokotoaro iava rasiara tovetoveta voare voea vo vuriaro reesipasa. Ra va iava ora voea vo pitupituroarore evara rugooave.” ");
INSERT INTO roo_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Uva va-a eva oa iava avaaepa Vearo Siposipo purapasa vo uruiara rutu-ia. Uva upiapa irara rutu tapo ravotovira porete piepaiva vorevira. ");
INSERT INTO roo_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Oire uva King Herot Galili iavapa irara reitoaaro ira vara rutu iava varao uvureva. Oa iava vavagisiparoepa rutu. Eake iava? Uvare oearovu oiso purapaaepa, “Jon eera ira tova tapi iava vorevira toreroi.” ");
INSERT INTO roo_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Osa oearovu oiso purapaaepa, “Easi Ilaija eera ira vorevira ora karekeroi.” Vo osa oearovu oiso purapaaepa, “Easi reo topa piepato-a profetato eera tuariripato ira vorevira toreroepa.” ");
INSERT INTO roo_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Oa iava ro Herot oiso puraroepa, “Jon kukuearore ragai voeaaro aruavora. Ari iroutoa rutu-a ro ira iava siposipopaivoi oirara?” Oire uva va-a vao oa iava oiso ruipaparoepa ra Jisas kekereve rutu. ");
INSERT INTO roo_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Uva vorevira rera voeaaro aposel irara kareaepa Jisas iare. Oa iava rera tavipaiva varao rutu iava oara puraiva. Osa iava voea raga roporeva voea ouoro oirara rutu sovara iava. Uva ouruivu iare voea tapo avaroepa, oiso ra reareaave. Vo urui vaisiaro, Betsaida urui. ");
INSERT INTO roo_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Uva va iava uvuivoiva, voea sirova utuaepa. Uva viapau oiso Jisas voeare koruroepa. Uva voea rutupa Pauto vo Saraaro iava siposipopareva. Ora oearovu rutu tapo upiapa irara ravotovira porete piepareva. ");
INSERT INTO roo_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ovaiarovi katai tau erao (12) Jisas iare urioaepa rerare oiso purasa, “Voeao taviri ra evoraro uruiara vai-ia uusisa avaave. Ora voeapa aioara vai voripaive voraro. Ari kuvau tapi-a vo-ia uva toupai. Uva viapau oirara vai toupaive.” ");
INSERT INTO roo_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Oa iava Jisas voea tavireva oiso, “Visii raga voeapa aioara vai vateta.” Uva oiso puraaepa, “Viapau riroara vaiei vo igei vara. Ari vo vavaevi raga vao-ia bret ora kataitoarei ataritoarei oaravia rutu-a varao toupai. Esa oiso vaio ruipapauei ra voeapa aioara vai vorisa avaio, eke?” ");
INSERT INTO roo_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Aue rutu vao vo vavae tuku (5,000) rutu uvuiaro oirara, vo osa viapau riakora ora kakae vure vievieiiva voeao oea toupaiva. Uva Jisas rera voeaaro disaipel tavireva oiso, “Voea totoevira pau pieta oiso, oeavu vo vavae tau (50) uvavivu, ra oeavu vo vavae tau uvavivu pauave, osa oeavu ita vo vavae tau uvavivu pauave.” ");
INSERT INTO roo_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Oa iava disaipel oisi voea roorookavira paupau pieiva. Osa iava voea rutu oirara rutu pau pieiva. ");
INSERT INTO roo_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Oire uva Jisas bret vavae ouoro ora ataritoarei vara rutuva vuvuiua-ia vurareva vearo vaisi puraoro. Oa iava vara puteputeoro voeapa disaipel vara vatereva, oiso ra vara vateive voeapa oirara. ");
INSERT INTO roo_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Uva voea rutu uvuivira aioiva. Oa iava ururukoara guruiva varao oara kavu piropa. Oara-ia katai tau erao (12) aue pekuri agasi pieiva. ");
INSERT INTO roo_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ovuutavu-ia rera raga Jisas variriroepa vo osa disaipel irara rera tapo toupaiva. Oa iava voa oiso voea akereva, “Apeisi ragai vaisipaiveira oirara?” ");
INSERT INTO roo_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Oa iava rerare oiso puraaepa, “Ari oearovu oiso vii vaisipaiveira, Jon Baptais, osa oearovu oiso, Ilaija ira oisoa reo topa piepa kovo purapareve voari tuariri. Ari oearovu oiso, iravu tuariripato profetato roari ira vorevira toreroepa.” ");
INSERT INTO roo_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Oa iava oiso ita voea akereva, “Ari apeisi visii raga ragai vaisipata?” Oa iava Pita oiso puraroepa, “Ari vii-a Krais ro Ropoto viigoa arureva Pauto vore.” ");
INSERT INTO roo_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Oire uva vo reo-a vao oa iava Jisas goruvira voea vosireva oiso, “Opeita oisi ragai iava irai tavita.” ");
INSERT INTO roo_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Oa iava topa pievira oiso voea tavireva ora rera iava. “Oirato Oviitoaaro oiso riroara vai siitokaara vai oureve. Uva lotupa irapa irara, ora reipa irara pris, ora voeao Reo Taisi-ia tarai irara rerare isivaavere. Uva rera upoivere, ra vo pevapa voki-ia vorevira torerovere.” ");
INSERT INTO roo_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Oa iava oiso voeare puraroepa, “Vosa ro ira ragai sirova utu ruipaparo, oire ra ora rera iava vaisia vara pie rovoreve. Oa iava uvuipa ra ora rera vo vavataaro kaereve, oiso osa vao evao parikou ragai sirova utupaoro vokiara rutu-ia. ");
INSERT INTO roo_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ro ira tootooaro virivaripareve, oava eva opesiroverea tootooaro. Ari ro ira tootooaro vatereve vo oearovupa ragai vo ruipaaro sirova utupaoro eera-a ira tootooaro tapo virivariavere taru. ");
INSERT INTO roo_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Vosa irai sara kovo vai purareve, ra auero rutu oureve varao vo rasio-ia, vo osa eisi piepaoro ora vuri piero, oire aa vao-a vearoa oa oureverea oirato vo rasio-ia? ");
INSERT INTO roo_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Vosa irai ragaipa ariiparo vo oearovu osireiaro-ia ora ragai vo siposipoaropa tapo. Uva oisi-a eisi osa rerapa ita ariiraverea ragai vao Oirato Oviitoaaro, vo osa ragai vaarova keraria vorera. Ora vao Aiteto, ora voeao tugoropa irara enselpa irara vaaro keraria, oea rutu osireiaro-ia rerapa eera ariiraverea rara. ");
INSERT INTO roo_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Oiraopavira rutu visii tavi iraopaavoi oiso, Ari ita, oearovu oirara visii iava tootoovira toupaiverea oea viapau tuguraaverea kopiia-ia. Oea Pauto vo Saraaro keke rovoivere taru.” ");
INSERT INTO roo_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jisas vo reo purareva, oa iava utupavira vo peva vatara vokiro isivaaro iava vo peva vao oureva oiso, Pita, Jon, ora Jems. Uva voea tapo iparoepa oavu-ia riro pukuia oiso ra voa variriro. ");
INSERT INTO roo_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Voa variriparoepa. Uva rera iava puaua avokorivira karekeepa, osa rerare kuvupara tapo popoteepa rutu oiso sisikoreoro osa aviavia. ");
INSERT INTO roo_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Oa iava voa aitereivu oiratoarei rera iare ora karekesiepa voava Pauto vo uruiaro. Uva evaiterei Jisas tapo ora reopasiepa Moses vaio ora Ilaija. ");
INSERT INTO roo_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Aiterea Pauto vaaro-ia karekesiepa keraria eva aviavia. Uva voa ora reopasiepa aue tapo Jisas varao iava oara purarevere Jerusalem-ia kopiioro Pauto vo vovouaro sirova utuoro. ");
INSERT INTO roo_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Oire uva Pita vase iava osireiara rurava. Oa iava oiso ruipapaaepa ra uusiave, osa viapau oiso uusipaaepa. Oa iava vorevira voea iava osireiara pariiva Jisas vaaro keraria kekesa, ora vaitereo tapo aiterea rera tapo torepasiepa. ");
INSERT INTO roo_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Oire uva va-a vao oa iava Jisas arova avasa auepasiepa ovusa Pita Jisas-re oiso puraroepa, “Reito. Igei-a vao vo toupaio vearopai ra kepa peva vai pauio oiso, Vii okepai, ora Moses okepai, ora Ilaija okepai.” Aue iava uvare Pita viapau vearovira taraiparoepa va-ia vao oa iava oisi eisi puraroepa. ");
INSERT INTO roo_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Oire uva touvira raga vo reo vao purapareva osa iriavu rukuta voea ruueva. Oa iava rirovira rutu uriri iraoaepa. ");
INSERT INTO roo_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Oira sovara-ia o rukuta oreovu Pauto vo reoaro oiso puraepa, “Eera-a ragai Oviitoaaro ira reesiavora rera ropooro. Ira uvu iraota.” ");
INSERT INTO roo_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Uva oisi-a oiso osa puraeiva vo reo vao, voa rera raga kekeiva osa toreparoepa. Oa iava ora tape pieaepa. Uva viapau irai tavipaiva va iava vao oa kekeiva voa. ");
INSERT INTO roo_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Vokipavira pukuia iava vokiaepa voava varaoro, osa oeavu riro irara rera iare Jisas urioaepa raivaaro rerava aivarosa voa. ");
INSERT INTO roo_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Uva iravu oirato voea iava Jisas-re keeraoro oiso puraroepa, “Tisato, goruvira rutu vii arepaavoi oiso ra oviitoa oaa kekeri kataitoavi raga. ");
INSERT INTO roo_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ira-ia pitupareveira iravu vurito tugarato. Oa iava rirovira oivepaoro ikaupavira kove ovoiparoveira vurivira rutu. Ra popotevira rera gisipoaro-ia kosikosipa piro aue ruiruiso. Ari ita, rera iava varaua vuri pie iraopareveira. Ra va iava viapau oiso ikauvira rera eakapareveira. ");
INSERT INTO roo_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Oa iava vii voeaarore gau ragapaavorao disaipel, oiso ra rera ro vurito tugarato kosi pieive. Osa viapau uvuipaaerao.” ");
INSERT INTO roo_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Oa iava Jisas rera aatooro oiso puraroepa voeare, “Ae visii vao-ia oirara vo vokio iava. Viapau oiso oirao pie vovou vaiei visii-ia. Vuri sopa irara rutu-a visii. Ovirovu-ia vuuta visii tapo toupaaveira? Ora ovirovu purapaavere visii vo vovouroaro-ia kasikasipaoro, osa viapau goruvira ragai vaaro-ia pitupata?” Uva va-a vao oa iava rerare ora poreoro oiso puraroepa, “Oviito oarava uriou.” ");
INSERT INTO roo_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Oire uva rera raga kakaeto urioroepa. Oa iava rera vurito tugarato rera-ia vikiroepa rasiua arore rera sisiputaoro rutu vurivira. Osa iava Jisas rerare tugarato kasipuroepa rera kosi pie ovoioro rera iava ro kakaeto. Oa iava vorevira aiteto vatereva rera. ");
INSERT INTO roo_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Oire uva voa-a vo uva oirara rutu vao riroa Pauto kerariaro vo goruaro kekeiva. Oa iava ora sitaaepa rutu va-ia tavetavepaoro. Oa iava rirovira rutu vara iava rugorugoo iraopaaepa varao oara purareva. Oa iava Jisas voea disaipel tavireva oiso, ");
INSERT INTO roo_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Vearovira rutu ora visii iava kokiara gereta, ra vo reo uvuoro va oriruta. Uvare utupauavi Oirato Oviitoaaro vateivere keripa irara vavaearo iare.” ");
INSERT INTO roo_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Osa iava viapau vo reo vituaro-ia taraipaaepa vao vatau reo oa purareva ora rera iava voeare. Oa iava viapau vo reo-ia taraipaaepa vearovira. Uva vo reore ake arapa uriripaaepa rera asavira. ");
INSERT INTO roo_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Uva voea raga disaipel reoa-ia ora upopaaepa oiso ora reopaoro, Iroutoa rutupa ro ira vigei iava reiparoi? ");
INSERT INTO roo_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Uva Jisas voea vo rugorugooaro-ia tarairoepa vao oa toupaiva voa voea iava sopaura. Oa iava iravu oureva kakaeto garetoavi ora rera ruvara-ia rera tore piesa. ");
INSERT INTO roo_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Uva voeare oiso puraroepa, “Ro ira ro kakaeto tauvapareve vo ragai vaisiaro-ia, rera-a eera ira ragai tauvapare. Ora ro ira ragai tauvapare, ira ita ro tauvapare ira ragai arureva vore. Ari ita, ro ira gare visivi rutu toupare akaipavira visii rutu vao-ia vuutaaro-ia, ira-a eera rovopatoa rutu visii rutupa vo Pauto osireiaro-ia.” ");
INSERT INTO roo_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jon oiso puraroepa, “Reito, iravu oirato kekeiovo osa vuri tugararo kosi piepare vii vaisiaro-ia. Ari ita, vo osa viapau vii sirova utuparoveira oiso osa igei vii sirova utupaioveira. Uva va-a eva oa vituaro iava rerare koruie.” ");
INSERT INTO roo_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Uva Jisas rerare oiso puraroepa, “Eakere rerare korutae? Ari ita, ro ira viapau vigeiva ora keriparo, eera-a ira vigeiva tavosivira toupare.” ");
INSERT INTO roo_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Vo vuuta-a vao oa tutuu pieiva oa-ia Pauto oiso ruipaparoepa ra Jisas kae piereve vorevira vuvuiua iare. Oire uva vo vuuta iava vo vokia rovoroepa rera vo ruipaaro tovooro, oiso ra Jerusalem iare avaro. ");
INSERT INTO roo_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Osa iava oeavu ira piereva vo reova vao ora rera iava. Uva ouruivu-ia karea viropa Sameria vo uruiaro. Oa iava rera varaaro vatatoposa aueaepa. ");
INSERT INTO roo_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Vo osa voea voeao vo uruia vao rerapa Jisas reasi iraopaaepa vova ora voea vo uruiaro-ia. Aue iava uvare oiso taraipaaepa rera-ia, Ari ro-ia Jiu ira Jerusalem iare avaparoi, osaravu rutu iava rera. ");
INSERT INTO roo_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Uva va vao kekesiva vaitereo Jems vaio ora Jon. Oire oa iava Jisas-re oiso purasiepa, “Turaro, apeisi vovoupauei ra tuitui kasire keeravio. Ra voeao oirara kasisa varape vova vuvuiua iava?” ");
INSERT INTO roo_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Uva Jisas vaitereire kasipuoro vaiterei tape piesa ora poreroepa. ");
INSERT INTO roo_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Oa iava ouruivu raga iare topaa viropa ita. ");
INSERT INTO roo_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Oire uva raivaaro vokapaoro avapaaepa. Uva voa iravu oiso Jisas tavipareva, “Voraro ouruiroa rutu-ia vokapaoro avapauvere, uvaroa vii sirova utuparavere.” ");
INSERT INTO roo_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Uva oirato vo vovouaro rutu kareke piesa oiso puraroepa rerare, “Aakau kare varaaro rikuara toupaiveira rasiuaaro. Ora kokio kare oea tapo varaaro epitara toupaiveira. Ari ragai Oirato Oviitoaaro viapau oiso oai epao tavukia vai ragaipa ora ragai iava kukue uusi piepasa.” ");
INSERT INTO roo_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Uva va-a vao oa iava Jisas oiso iravu tavireva, “Ragai sirova utuu.” Oa iava rera ro oiso puraroepa, “Vearopai ra ragai iava vase rovori. Ra aite tova rovosa vore rovora, vo rara kopiiro.” ");
INSERT INTO roo_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Uva Jisas rerare oiso puraroepa, “Eagara, voeape evoea kopii rugoo irara ra ora voea raga ora tovapaave. Osa vii Pauto vo Saraaro iava siposiposa avau.” ");
INSERT INTO roo_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Uva iravu ita rera tavipareva oiso, “Turaro, oiso ruipaparai ra vii sirova utupara. Uva apeisi vovoupau? Ra ragai iava vase rovori auere ra sekan rovosa vore rovora ragai voeaarova.” ");
INSERT INTO roo_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Oire uva Jisas rerare oiso puraroepa, “Ro ira ora rera vo kovoaro-ia pitu rovoreve, oire ra voava orugorugoorovu ita porero utupavira, ra apeisi ragavira rera vo kovoaro vearovira rutu karekepe? Ira-a eera viapau uvuiparoi vo kovo-ia pitureve Pauto vo Saraaro-ia okovoa toupaiveira.” ");
INSERT INTO roo_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Vo utupavira Turaro erao vatara tau erao (72) reesirevoiva, voea eraeraopavira siporeva. Uva iraaepa rerapa uruiara rutu iare, varao reipa uruiro ora garepa uruiro tapo. Uva utupavira rera raga avasa aueparoepa vo uruiro iare varao. ");
INSERT INTO roo_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Oire uva Pauto vo kovoaro reesioro oiso puraroepa voeare, “Riroara aioara vioroe, oara oiso toupai osa oirao pie asa irara vo ragai-ia Jisas. Osa viapau kovopa irara vai vo voea tavitavipasa. Eisi osa iava variripatavere rore ira vo kovoaro-a. Ra va iava kovopa irara vai siporeve rerapa aioara gurusa aue oirara. ");
INSERT INTO roo_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“Uvuta! Visii sipopaavoi oiso osa sipsip kakaero aakau kare vuutaaro iare, okarea vo kakaero aiopaiveira. ");
INSERT INTO roo_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Opeita moni oaparo vai kaepatavere, ora ogataara vai, ora aue tasipa su. Teapi ora visii vo vuutaroaro pute pie ragapata ora reoreo ragapaoro oearovu tapo voraro raivaaro. ");
INSERT INTO roo_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Oire vosa oai-ia kepa vai koatasa auepata, oire ra oisi pura rovota, Visii vao vo kepao iava kave vovouvira touta. ");
INSERT INTO roo_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Vosa irai kave vovoutoa vai vo kepa-ia toupareve, oire ra va vao kave vovou tovota rera-ia. Ra rera iare vira piro. Ari vosa viapau oisi irai, oire ra visii vaaro kave vovou vao oa vateta oa visii iare ita vorevira vorepere, vo rara irai viapau va oupareve. ");
INSERT INTO roo_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Oire ra voa katai kepa raga-ia toupata. Ra vo kepa raga-ia aiopata ora ukaiopata tapo varao oara vatepaive visiipa voa. Aue iava uvare ro ira Pautoa-pa kovopareve oirara tauvapaoro, irapa torevokopai oiso ra tauvaa oupareve oearovu ruvara-ia, voeao oea tauvapareve voea tokipaoro. Ari ita, viapau uvuipatai ra okeparovu iare ora sikasikapata. Ari uvuipatai ra katai kepa raga-ia toupata. ");
INSERT INTO roo_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Oire vosa ourui-ia kare uvirota, ra voa visii ouive vorarore ora voea vo keparoaro-ia. Oire ra aioara aiopata varao oara visiipa vatepaive. ");
INSERT INTO roo_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Upiapa irara porete piepata voa vo urui-ia. Ra oisi voea tavipata tapo, Pauto vo Saraaro tutuu piepaivoi visii iare. ");
INSERT INTO roo_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ari vosa ourui-ia kareu virota vao oa-ia visiire korukorupaave, oire ra vo urui vuutaaro-ia toresa avata voava voea siposiposa ");
INSERT INTO roo_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","oiso puraoro, Ae! Poupou rasiro igei kokotoaro-ia votoei. Oire uva visiipa Pauto vo kasipuaro kareke piepaiovoi vara vorevira tovetoveoro ora igei kokotoaro iava. Ra va iava oiso vearovira taraita, Ari ita, Pauto vo reoaro visiire keera ragapai osa va uvu ragapatavoi. Ari ita, tutuu pie ragavoi Pauto vo Saraaro ovusa vapa reasipatai. ");
INSERT INTO roo_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Oire uva visii tavipaa vao iava Ovoiopa Voki oa-ia Sodom vata voeao oea oisoa vuri pitupitu purapaive, oea vo siitokaaro ouiverea, oa-ia visii vo siitokaaro puteverea riroa rutu. ");
INSERT INTO roo_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Siraovira rutu visiipa vo Korasin urui. Ora siraovira rutu visiipa Betsaida urui. Vosa ragai oai ravoto kovo vai puraavori Taia uruireipa ora Saidon voari rutu tuariri, oiso osa vao-ia oa puraavora visii ruvara-ia, oa iava tuariri vuri irara Taia vata ora Saidon vata oearea rutu vuri varorovi raga-ia tuupaaeri. Ra vo tuurova gavutara raga ivara-ia paupaave vuri vovouro oaiveva ariipaoro. Oa iava sopaura oaive voea iava pore pirori vova vuriara oaive iava. ");
INSERT INTO roo_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Oiraopavira rutu oiso osa visii tavipaavoi oiso, Vo vokio vao oa-ia oirara rovirieireverea Pauto ovokia-ia vo siitoka ouverea vo uruireo Taia uruirei ora Saidon, oa-ia puteverea rutu vo tavaka visii vaaro. ");
INSERT INTO roo_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ari visii Kapaneam vata visiigoa kae viro ruipapataveira vuvuiua iare, oiso ra rei vaisipata, raa? Ari viapau. Easi visii vara piereverea vuri tapire.” ");
INSERT INTO roo_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Oa iava oiso Jisas rera voeaaro disaipel tavireva, “Ro ira visii gisipoaro uvureve, oire uva rera-a ita eera ira ragai gisipoaro uvurevoi. Ari ro ira visiire isivaro, eera-a ita ragaire isivaroi ora ro tapore Pauto ira ragai arurevora vore.” ");
INSERT INTO roo_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Oire uva utupa visivi erao vatara tau erao (72) vorevira kareaepa. Oa iava rorupaiva oiso puraoro, “Turaro, igei vii vaisiaro iavirava voeaore reopaie vuri irara tugara. Oa iava igei vo reoaro uvupaivo rutu, vo osa oearovu iava voea kosi piepaio. ");
INSERT INTO roo_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Oa iava Jisas oiso voeare puraroepa, “Seten tueava osa oiso vararoepa osa parakauoro vuvuiua iava koveoro, vo uvare viapau gorua vai epao rera oaiaro. ");
INSERT INTO roo_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Uvuta! Ragai visiipa gorua vatepaavoi. Oa iava ro-ia putetavere ira vigeiva keriparoveira Seten. Ra va iava vo kareo rutu-ia tapo puteta voea-ia tasioro rakoru kare ora siikopi kare. Ra va iava viapau visii vuri piereve ro vurito. ");
INSERT INTO roo_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Opeita rorupaoro oiso purapata, Vuri tugararo igei vo reoroaro uvupaiveira. Viapau. Ari Pautoa-ia roru iraopata ira visii vaivaisiaro rigatoreva rera vo uruiaro-ia oiso puraoro, Ragai voeaaro-a visii.” ");
INSERT INTO roo_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Vo vuutao-ia Tugoropato Uraurato rorua kareke piereva Jisas sopaaro-ia. Oa iava oiso puraroepa, “Aite, vii Reito Turaro vuvuiua-ia ora vo tapo rasitoa-ia. Vii-ia vearo vaisi puraavoi. Uvare viigoa varao rutu vatauriva voeao asavira oirara oea-ia taraiara toupai vo ora voea vo rugorugooaro-ia. Oa iava voeao raga kareke pieriva oea oiso toupaiveira osa garepa kakaero. Iu ita. Aite, vii raga vo ruipaaro osa oiso vearovira toupaiveira. ");
INSERT INTO roo_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Aite ragai vavaearo-ia varao rutu tovoreva. Uva viapau irai oiratoa vai taraipa rutu ragai-ia Oviito. Ari Aite raga kataito. Ira ragai tarai iraopa ragai-ia. Ora viapau irai Aite-ia taraipa rutu. Viapau. Ari ragai raga rera-ia tarai iraoparai, ora voeao oea-ia Aiteto kareke piepareveira Oviito ora rera vo ruipaaro sirova.” ");
INSERT INTO roo_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Oire uva voea raga disaipel Jisas tapo toupaiva. Oa iava voea iare ora poreroepa oiso puraoro, “Oearovu oirara roruive vosa oarai kekepaive varao oara kekepatavoi vo vokio ragai ruvara-ia. ");
INSERT INTO roo_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ari ita, visii tavipaavoi oiso, Voari tuariri uva riro irara profet irara ora king irara oearoa orekerovu rutupa varao oisoa ruipapaave, oiso ra vara kekepaive varao Pauto vo Saraaro iava oara kekepatavoi. Uva viapau oisoa vara kekepaive. Ora vara tapopa ruipapaave oiso ra vara uvupaive varao oreoroa ragai iava. Uva viapau vo reo oisoa uvupaive.” ");
INSERT INTO roo_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Oire uva iravu taraito Reo Taisi-ia toreroepa Jisas-ia kokarasa rera tavatavaeoro. Ira oiso puraroepa, “Tisato. Eake vai-a uvuiparai ra oai puraa. Ra va iava Tootoo Ovoi oua vao oa opesi asavira toupai?” ");
INSERT INTO roo_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Oa iava Jisas rerare oiso puraroepa, “Oavu rigato-a oa toupai Reo Taisi-ia. Oire uva apeisi ragavira rugorugoopau va vieipaoro?” ");
INSERT INTO roo_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Uva Jisas vo reoaro aatooro oiso puraroepa, “Turaro eera-a vii reraaro Pauto. Ira ragapa vii iava sopaua rutu vateri, ora vii vaaro rutu tapo rugorugooara rutu, ora gorua, ora taraiara rutu rera ragapa. Ora eisi osa ropa siraopau ira vii ruvara-iavi toupareveira, oiso rutu osa ora viipa siraopauveira.” ");
INSERT INTO roo_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Oa iava Jisas oiso rera tavireva, “O ita! Torevokovira vo reo aatori. Uva oisi-a eisi osa iava uvuipauei ra va iava Tootoo Ovoi rutu ouri.” ");
INSERT INTO roo_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ari ita, ovusa rera ro riro taraito oiso ruipaparoepa ra ora rera raga vaisiaro raga vearoreve. Oa iava Jisas-re oiso puraroepa, “Iroutoa irao-a ira ragai ruvara-iavi toupareveira?” ");
INSERT INTO roo_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Oa iava Jisas rera vo reoaro topa piepaoro oiso puraroepa, “Iravu oirato ira Jerusalem iava vararoepa Jeriko iare. Uva vuri irara riro kaviru irara rerava aivaroiva raivaaro. Oa iava auero rutu rera varaaro ouiva voa rera vurivira rutu upooro. Oa iava kopii ragaroepa rutu. ");
INSERT INTO roo_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Oire uva iravu koruou purapato pris ira vo raiva gaepareva. Oa iava voa rera vatavatareva vo raiva vatuaro-ia avaoro. ");
INSERT INTO roo_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Uva iravu ita Livai ira oisoa Tugoropa Kepa-ia kovopareve, ira ita oisi raga rera kekeoro rera vatavatareva. ");
INSERT INTO roo_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Oire uva iravu Sameria-pa irara iava rera, voeao oea oisoa voeava Jiu ora keripaave, ira voa rera kekeoro rerapa rirovira rutu siraoroepa. ");
INSERT INTO roo_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Oa iava rera ruvara iare tutuu piereva. Uva voa rera-ia aue wel petoreva. Ora wain ovi tapo oa ro iava kokoroepa vorarore kapuara-ia, oiso ra opeisipe. Oa iava rera kae piereva ora rera oiraaro iare donki. Osa iava rerava avaroepa rera tovosa oavu-ia tavete uusi piepa kepa. Oire uva voa-a evoa uva vearovira rutu rera tokireva. ");
INSERT INTO roo_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Vokipavira moni erao kina (K2) vatereva ropa ira vo kepaaro-a va vao tavete uusi piepa kepa. Uva oiso rera tavireva, Vearovira rera tokipari. Ari vosa vii oaiaro-ia rera tokirivere, oire vosa vorevira vorera ra viipa oai kare piea vorevira. ");
INSERT INTO roo_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Oire ra apeisi rugorugoopauei? Iroutoa vai-a vo pevao iava ira oisi eisi rera piereva vo uvare rera ruvara-iavi toupare, ro ira vuri pieiva kavirupa irara?” ");
INSERT INTO roo_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Uva va-a vao oa iava rera ro Reo Taisi-ia taraipato oiso puraroepa, “Ari ro oirato ira rerapa siraoroepa rera tauvaoro.” Uva Jisas oiso puraroepa rerare, “O ita, uva oisi raga piesa avapauei.” ");
INSERT INTO roo_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Oire uva vokapaoro avaparoepa raivaaro disaipel iraraaro tapo. Oa iava ouruivu-ia karea viropa. Uva iriavu riakova, oira vaisiaro, Mata iria rera ou pieeva ora oira vo kepaaro iare, oiso ra aioa vai vateeve rerapa. ");
INSERT INTO roo_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Uva oira Mata taevaaro toupaeva Maria. Oa iava urioopa Maria rera Turaro kokotoaro ruvara iare. Uva voava rera vo reoaro uru piepaeva. ");
INSERT INTO roo_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Vo osa Mata riro kovo rutu purapaeva aioara ravaapaoro rerapa. Oa iava oirare rugorugooara viriva rutu. Uva Jisas iare urioopa oiso purasa, “Turaro. Asi ragai taevaaro ragai arova avaoi. Oa iava ragai raga varao-ia virikasiparai vara vatatopopaoro aioara. Oire uva apeisi vai-a vao rugorugoopauei? Oiso ruipaparai ra oira aruri ragai tauvasa.” ");
INSERT INTO roo_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Oire uva oira aatooro oiso puraroepa ro Turaro, “Mata. Eakere riro rugorugooro rutu purapari ora vii iava sopaua vavata pie ragapaoro? ");
INSERT INTO roo_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ari ita, kataia ragapa poteparivoi oa vearopai viipa. Oa-a vao oa purasa oira vo vovouaro tovopaevo Maria, oiso ra ragai vo reoaro uru piepaeve. Ari ita, viapau uvuipaveiei ra va vao vearo ruipa verave oira iava.” ");
INSERT INTO roo_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Oire uva uvavu variripaoro toureva Jisas. Oa iava variri opesiroiva, iravu disaipelto rerare oiso puraroepa, “Vearopai Turaro ra igei tarai pieri variria vo pitupituaro iava, oiso osa Jon ora rera voeaaro tarai piereva disaipel.” ");
INSERT INTO roo_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Osa iava Jisas oiso voea tavireva, “Vosa variripata, ra oiso purapata, Aite. Vii vaisiaropa avivikepaiei va kae piepaoro rutu, uvare Tugoropa Vaisito-a vii. Vii vaaro Sara urio pieri poeravira. ");
INSERT INTO roo_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Vo vokio igei vateri aioa vao vo vokio iare. ");
INSERT INTO roo_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Igei varaaro vuri vovouro verari, vo rara oearovu iava oaravu vuriara vera rovopaio voeao oea igei vuri piepaiveira. Ora vosa kokarapara igei iare tutuu piepaive, oire varapa igei vatatopo piepari oiso, teapi vara-ia koveiovere.” ");
INSERT INTO roo_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Uva Jisas oiso puraroepa, “Easi pasi, visii iava irai epao ira vatetoa vaiaro epao. Uva eera ovokivu-ia voki vuuta-ia avaroepa rera tavisa oiso, Ragaipa bret peruva vai vateri vatetoa oaa. ");
INSERT INTO roo_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ari iravu ragai saratoaaro urioparoi raivaaro ragai iare. Uva viapau aioa vaiei oa vateavere rerapa. ");
INSERT INTO roo_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Oire uva rera ro ira kepa sovara-ia toupareva ira rerare oiso puraroepa, Auoro tupavo. Viapau uvuipauei ra ragai pugu pie ragari uusi arapa. Ari ita, kakae vure uusiai ragai tapo urua-ia. Uva viapau uvuiparai viipa oavu avu vai vatesa! Oire uva apeisi-a? ");
INSERT INTO roo_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Visii tavipaavoi, Vosa taraiparoeri oiso, Ragai vatetoaaro ro-ia, oire ra viapau rerapa aioa vai vatereva. Uva kasivarivira rutu rera arepareva. Uva va-a vao vituaro iava rera vatereva aioara. ");
INSERT INTO roo_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Osa iava oiso visii tavipaavoi, Pautoa-pa variripata arepaoro, ra va iava visiipa vara vatepareve. Taraapata, ra vara kekepata. Rataoa totota, ra Pauto visiipa karureve. ");
INSERT INTO roo_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ari ita, voeao oirara oea Pautoa-pa variripaave, ra va iava orekerovu oupaive. Ari ro ira orekerovure taraapareve, ra rera ita vara kekepareve. Ari ro ira rataoa totoreve, irapa eera Pauto karurevere, vo rara rera vaaro uvureve variria. ");
INSERT INTO roo_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Oire vosa irai oviitoa vaiaro visii iava irai aitetoa vai arepareve oiso purapaoro, Aite. Ragaipa ataritoa vai vateri, ra irai aioa. Uva apeisi-a? Ra aiteto rakoru vai vatereve rerapa, raa? Viapau. ");
INSERT INTO roo_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ora vosa rera oviito rera aiteto arepareve, oiso ra rera vatereve aue takura vao va aiosa. Ra pasi vuritoa vai vatereve aue siikopi? Easi eva tapopa viapau. ");
INSERT INTO roo_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Oire visii vao vuri irara visiigoa vearopara vatepataveira ovii irara oavisiipa. Uva oisi-a eisi osa iava vearovira rutu taraipavio va-ia vao, Osa ragavira Aite vearotoa rutu ro vova vuvuiua-ia Tugoropato Uraurato pute pievira vatepareveira voeaopa oea rera arepaiveira rerare variripaoro.” ");
INSERT INTO roo_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Oire uva Jisas iravu vurito tugarato kosi piereva iravu iava oirato ira iava gisipo kapuueva. Uva rera iava rera ro tugarato avaroepa. Oa iava ro kapuu gisipoto vorevira reoreoroepa. Uva va-a vao oa iava tavetave iraopaiva rirovira rutu rugorugoopaoro. ");
INSERT INTO roo_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ovusa oearovu oiso purapaaepa, “Easi ro voeao vuri irara tugara kosi piepare aue Bielsebul vo goruaro iava, ro vuri irara tugara turarotoaaro.” ");
INSERT INTO roo_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Vo osa oearovu oiso purapaaepa rera arepaoro, “Ravotoa vai purari. Ra oai iava vii-ia taraiio oiso, O oiraopavira vii vao arureva Pauto vuvuiua iava.” Uva va-a vao oa-ia oiso ruipapaaepa ra va iava vao rera tavatavaeive. ");
INSERT INTO roo_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ari ita, osa voea vo vovouroaro-ia tarai rovoroepa. Oa iava oiso voeare puraroepa, “Vosa oeavu oirara oavu katai sara ora roopa pieave, oire ora upoave. Ra va iava ora opesi pie ovoiave. Ora vosa oeavu katai kepa iava, ra ora roopa pieave vo keparei puraoro. Oire ra ora opesi pie ovoiave ita. ");
INSERT INTO roo_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Vosa Seten rera raga ita Bielsebul ira vo saraaro ora sikaave, ra apeisi ragavira gorua oupaive ora voea-ia? Eisi osa ragaire purapatai oiso, Aue Bielsebul vo goruaro iava vuri tugararo kosi pieparevo. Asi viapau oiso uvuipaai ra voea raga ora kosi piepaave. Uvare voea raga ita-a. ");
INSERT INTO roo_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Oire vosa Bielsebul oiraopavira ragai tauvapareve vo osa vuri irara tugara verapaa, oire ra irou visii voeaaro tauvapaive vuri tugararo verapasa, raa? Uva voea-a evoea visii raga voeaaro oea visii vo vuriaro karekeivere poeravira rara. ");
INSERT INTO roo_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ari vosa Pauto vo goruaro ragai tauvapaive voeao vuri irara tugara kosi piepaoro, oire ra va iava oiso taraita, Pauto vo Saraaro pou pirora visii iare osa viapau va eveitavora. ");
INSERT INTO roo_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Vosa riro varivaritoa vai ora irai okepaiaro-ia uutuparo togava vaiva, ra va iava vearovira rutu vara rutu rera varaaro oriruvira toupaive. ");
INSERT INTO roo_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Oire ra irai riro varivaritoa vai karero viro rera iare. Ra rera-ia putereve varao rutu itooro rera ruvara-ia togara ora toorio varao upo purapara oara-ia rariparo. Ra va iava vara rera varaaro roo piereve oearovu rutupa. ");
INSERT INTO roo_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Vosa irouto ro ira viapau oiso ragai tapo kovopareve, ira-a eera ragaire isivapa. Ora vosa irouto ro ira viapau ragai iare oirara gurupareve, ari ita uva rera-a eera ira oirara sikasikapareveira ragai arova. ");
INSERT INTO roo_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Vosa iravu iava kosiro viro ro-ia tugarato vore avaoro raaka tapi voa ora rerapa toua vaire taraasa rearea taraapaoro. Oire ra taraa ragaparevoiva, oiso puraro, Voreparai vo kepao iare uva tou rovopaavora tuariri. ");
INSERT INTO roo_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Oire vorero vo kepa kekesa, vo rara vo kepa viouive va rekooro. ");
INSERT INTO roo_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Uva va-a vao oa-ia oisoa oeavu erao vatara tugara tuvetuvepareve ora rera iare, voeao oea vo vovouroaro vuri vovouro oisoa rera vo vovouroaro-ia putepaive rutu. Oire ra voea rutu tapo koataro vorevira voea tapo toupasa voa vo oirato sopaaro-ia. Ra va iava rera vo touaro ro oirato vuri iraope rutu vo touo-ia puteoro oa-ia rera ro rovopato tugarato oisoa rera sopaaro-ia tou rovopareve.” ");
INSERT INTO roo_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jisas vo reo purareva ovusa riro irara toupaiva. Oea vuruvuru-ia iriavu riakova toupaeva. Iria oiso puraopa keeraoro, “O-ia iria vii kavaueva ora vii roro pieeva iria rirovira rorupae, uvare viraakoava toupaevoi.” ");
INSERT INTO roo_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Vo osa Jisas oira vo reoaro aatooro oiso puraroepa, “Viapau. Asi voeao-a oea Pauto vo reoaro uvupaoro va sirova vearovira utupaave, oea roruive.” ");
INSERT INTO roo_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Uva rirovira ora gurupaaepa. Oa iava oiso voea tavireva, “Visii vao vo vokio iavapa irara vuri irara. Visiigoa ragai arepata oiso ra ravoto reesi vai puraa ora ragai reesipasa. Ra oai keketa. Osa viapau oiso ra visiipa va puraa. Ari vao raga-a vao oa keketaverea oiso osa piereva Jona ravotovira. ");
INSERT INTO roo_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Vo tuariri uva Jona ro reo topa piepato profetato vao reesia karekereva voeaopa Niniva, vo osa ravotovira vo pevapa voki-ia vova atarito sopaaro iava vorevira toreroepa oirara vuutaaro-ia. Oire uva oisi-a eisi osa pieaverea ravotovira visiipa va vao reesia karekeoro visiigoa vo vokio-ia toupatavoi. ");
INSERT INTO roo_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Uva vo osa vo vokia-a vao oa-ia Pauto oirara rovirieireverea, ovusa kwin o oisova Siba rovirieia-ia toreoverea aue kort. Oire ra voeao vo vokio iavapa irara togaeverea reoara-ia. Eake iava? Uvare oira o kwin tauai rutuva urioopa Solomon vo taraiaro uvusa, uvare riro taraitoa. Ari ita, uva vo touparevoi ro ira Solomon-ia putepare. Vo osa viapau rera vo reoaro uvupata vovouisiro oavisii poresa. ");
INSERT INTO roo_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Utupaua Pauto oirara rovirieireverea vo vokio-ia oa-ia voeao Niniva kortua-ia toreaverea. Ra vo vokio iavapa irara togaive reoara-ia. Eake iava? Uvare Jona vo reoaro uvuiva vao oa-ia voea tavireva. Oa iava sopaura oaive poreiva. Ari ita, vo toupare visii vuutaaro-ia ro ira Jona-ia putepare.” Eisi osa puraroepa Jisas ora rera iava tavipaoro. ");
INSERT INTO roo_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Uva oiso puraroepa, “Viapau vuravuara rukuepaiveira, ra vara tovopaive rikuara sovara-ia vo kepaara sovara-ia, eke vo baket vai reroaro. Viapau. Asi vo tebol ivara-ia oira tovopaiveira. Ra voeao oea koatapaave vo aviavi kekepaoro vao-ia aviavia. ");
INSERT INTO roo_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Oiso-ia osireitoarei-a aoa auepa sopaua. Vosa osireiara oavisii roroiovira toupaive, oire sopaura oavisii rutu tapo roroiovira ita aviavivira toupaive. Ari vosa osireiara oavisii tapo rupavira toupaive, oire oisi raga ita tapo sopaura oavisii rupavira toupaive. ");
INSERT INTO roo_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Oisi-a eisi osa raga ita ora vatatopopata. Teapi eva aviavia oa visii sopaaro-ia toupai rupape. Ra va iava viapau vearo rugooro eveita. ");
INSERT INTO roo_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Oire vosa visii iava rugorugooara rutu aviavivira toupaive, ra viapau oa visii vara iava rupapape. Oire ra oiso aviavipaive osa vuravu o iria roropaeve visii rutu-ia.” ");
INSERT INTO roo_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Vo reo-a vao oa purareva Jisas. Oa iava iravu ratarataa vovouto Farisi-pato rerare keeraroepa oiso ra rera tapo aioreve. Osa iava Jisas koataroepa tebol-ia pausa. ");
INSERT INTO roo_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Oire uva rera ro Farisi-pato rerava vurapareva osa voa paupaoro aiopareva, uvare viapau vavaea sisu rovoreva Reo Taisi sirova utupaoro. Oa-a vao oa iava rirovira rutu rugorugoo iraoparoepa. ");
INSERT INTO roo_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Uva Turaro oiso rerare puraroepa, “Visii vao-ia Farisi visiigoa kap iava varaua raga sisigarue piepataveira ora aue dis, osa visii iava sopaura oavisii agasipape varao iava kavirupa vovouro ora varao vuri pitupituro. ");
INSERT INTO roo_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Visii vao evao kukue irara. E Pauto auero iava varaura raga purareva, uva viapau tapo vara sopaaro purareva, raa? ");
INSERT INTO roo_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ari ita, vao oa visii sovara-ia toupaive oa-ia uvuipatai ra va-ia voeao apota irara tauvata. Oire vosa oisi oiso piepata, ra va iava visii iava auero rutu sisigaruepape. ");
INSERT INTO roo_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Visii vao-ia Farisi visiigoa ora vatatopo iraopata. Visiigoa vao garepa aiorovi iava akuku aioro katakataivira vara vatevate ragapataveira varao iava tautauara rutu iava. Oiso ra utuuva geesi purapata Pautoa-pa koruou purapaoro. Uva eisi osa piepaoro torevoko pitupitu vatavata iraopataveira ora varao visii varaaro Pautoa-pa siraopa vovouro. Eisi osa vo pitupituro purapata koruou purapasa. Oire ra viapau opitupiturovu varao reipara kavupata. Ra va iava visiipa torevokopape. ");
INSERT INTO roo_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Visii Farisi ora vatatopo iraopata. Visiigoa oirara rutu osireiaro-ia pau ruipapataveira Reo Taisi Uvupa Keparo sovara-ia vo rovopara-ia paupa tavukiro. Ora riro oiso ruipa irara visii ra oirara rutu visiiva vearo voki purapaive visiipa ora avivikepaoro voraro uupa tapirovi. ");
INSERT INTO roo_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Visii vao-ia ora vatatopo iraopata. Visiigoa oiso rutu toupataveira osa tova vao oa rasito sovara-ia toupaiveira. Oire ra oirara viapau va-ia taraipaoro va ivara-ia tasiasipaoro vokapaive vo eruro ivara-ia. Eisi osa visii iava sopaura toupaiveira vao iava vuri vovouro.” ");
INSERT INTO roo_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Oire uva iravu riro taraito Reo Taisi-ia ira rera vo reoaro aatooro oiso puraroepa, “Tisato. Asi vii eisi purapaoro igei tapo toviparivoi.” ");
INSERT INTO roo_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Oa iava Jisas oiso puraroepa, “Visii vao tarai irara Reo Taisi-ia visiigoa ora vatatopo iraopata. Visiigoa riro vavatapa ruuro-ia oirara ogata piepataveira varao visii raga varaaro reo goruro. Vo osa ora visii raga tapo viapau varavi-ia pitupata sipareoaravi raga iava voea tauvapasa oea vara kaepaive. ");
INSERT INTO roo_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Visii ora vatatopo iraopata, uvare voari tuariri aao irara oavisii oisoa profet irara upopaive. Oa iava voea vo tova uruiroaro oritopataveira. ");
INSERT INTO roo_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Oire uva oisi raga-a oiso osa piepaoro visii vo rugorugooroaro karekepatavorao oiso purapaoro, Vearo pitupitu-a vao oa puraiva voeao igei aao iraraaro voeao profet irara upooro. Uva va-a vao oa iava voea vo tovaroaro oritopataveira. ");
INSERT INTO roo_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Aue iava uvare Pauto ora rera taraiaro-ia riroa oiso puraroepa, Voea iare profet irara sipoaverea ora voeao aposel irara. Oa iava voea iava oearovu tariopaiverea voea upopasa. Ra oearovu tapo voea iava vuri piepaive. ");
INSERT INTO roo_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Uva va-a eva oa-ia voeao vo vokio iava voea vo vuriaro vo voriaro ouivere. Aue iava uvare profet irara upopaiva voari tuariri rutu. Uva vo vokio-ia tugurasa urioi oisi raga piepaoro oiso. ");
INSERT INTO roo_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Osa raga ita voari tuariri uva Ebel uporeva araokoto ro torevoko vovouto. Oire ira-ia rovoepa. Uva Sekaraia-ia pou virosa vo pitupitu raga urioepa. Uva oeavu tapo ita oea upoiva Tugoropa Kepa iava vo tugi vuutaaro-ia ora eravao. Uva voea-a evoea oea iava eva puraiva ovuria oiso eva oa vorevira visii-ia oiso kare piereverea Pauto. ");
INSERT INTO roo_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Visii riro tarai irara Reo Taisi-ia visiigoa ora vatatopo iraopata. Aue iava uvare ki veratavora o tarai oupava. Oa iava Tugoropa Vuku karupataveira ovukua-ia taraia toupaiveira. Oire uva va-a vao oa-ia ora visii ruture raiva tupatava. Vo osa oearovu oiso ruipa ragapaave ra koataave. Oa-a eva oa-ia visii raga vo vovouroaro-ia paipaipaiveira oearovu, aue iava rara visii raga voeare tupapata.” ");
INSERT INTO roo_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Oire uva Jisas vo kepa iava kosiro viropa. Oa iava voearei voeareo Farisi ora Reo Taisi-ia tarai irara kasipu iraoaepa. Oa iava rera togapaiva oreorovu-ia. Vo osa oaravu rutu akeara purapaiva rera akepaoro, ");
INSERT INTO roo_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","oiso ra rera tavatavaeive. Oire ra oreoi uvuivora rera gisipoaro iava rera iava gasiive kortua iare. ");
INSERT INTO roo_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Riro tukuro rutu (tausen) oirara ora guruaepa. Oa iava voea iava tupa piropa rutu. Oire uva vo vuuta-a vao oa-ia Jisas ora rera voeaarore disaipel reo rovoroepa. Uva oiso puraroepa, “Avoeao. Vaopa kuuvu pitupitu ora vatatopo iraopata. Oa oiso rutu toupaiveira osa vao yis Farisi vo pitupituaro voeao riro ratarataa vovou irara. ");
INSERT INTO roo_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ari ita, varao oara rutu vataupapeira, oara karekepere utupaua poeravira vore viaea-ia. Uva ita, tavuruvira oisoa toupave, oire ra utupaua oirara vara-ia taraipaave. ");
INSERT INTO roo_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Oire vo reoro oara purapataveira vo rupa-ia, oreoroa uvuivere vo ravireo-ia. Ari vo reo oa-ia ogaogavira ora reopataveira vo kepaara sovara-ia, oarava torepaavere oearovu voraro ora reopa tapiro vara iava siposipopaoro. ");
INSERT INTO roo_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Vate irara oaa, visii tavipaavoi oiso, Opeita voeao ragapa uriripata oea visii iava varaura raga kopii piepaiveira. Uva voea evoea viapau uvuipaai ra utupaua oavu avu vai ita puraive vo visii-ia. ");
INSERT INTO roo_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ari visii tavi iraopaavoi rutu ro iava irapa uvuipatai ra rerapa uriri iraopata. Ro-ia Pauto irapa uriri iraopata. Ira uvuiparoi ra oirato kopii pie ovoireve. Uva toupai tapo rera vaaro gorua vore utupaua uva oirara vikirevere vore vuri tapi. Iu, eisi osa visii tavi iraopaavoi oiso, Eera irapa uriri iraopata. ");
INSERT INTO roo_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Ari ita, taraipatai oiso, Oirara vo vavae kokio kare garepa kare voripaiveira aue-ia erao toea (2t). Osa Pauto viapau oisi iravire ovauparo eisi. ");
INSERT INTO roo_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ari ita, visii tokipaoro visii kukuearo iava oruara rutu vieireva. Uva va-a eva oa iava viapau uvuipatai ra uriripata. Visii vaaro voria vo kareo voriaro-ia putepaiveira garepa kare kokio kare. Eva-a oa vituaro iava Aite vearovira visii tokipareveira. ");
INSERT INTO roo_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Visii tavipaavoi oiso, Vosa irai ragai vaisiaro iava taviro vo oirara rutu osireiaro-ia oiso puraoro, Eera-a ragai reraaro Turaro. Oire uva ira-a eera vaisiaro iava taviraverea ita, ragai Oirato Oviitoaaro vo enselpa irara osireiaro-ia voeao Pauto voeaaro. ");
INSERT INTO roo_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ari ro ira ragaire isivaro vo oirara rutu osireiaro-ia, ragai tapo ita irare taru isivaraverea vo Pauto voeaaro enselpa irara osireiaro-ia. ");
INSERT INTO roo_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Ari ita, ro ira ragaire oavu takau vaisi purareve vuria, oa-a eva verarevere Pauto rera iava. Ari vosa ro ira Tugoropato Uraurato-ia takau vaisi purareve, uva va-a eva oa-ia Pauto viapau rutu oiso uvuipa ra evo vuri verareve rera iava. ");
INSERT INTO roo_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Oire vosa visii rovirieisa kortua-ia visii sipopaivere vorarore voea vo keparoaro-ia Sinagog. Ora vosa vorarore gavman irara osireiaro-ia ora reipa irara kort purasa visii sipopaivere uvare ragai sirova utupataveira, oire ra viapau oiso uriripata voeapa oiso rugorugoopaoro, Apeisi ragavira reoara pukopaiovere? ");
INSERT INTO roo_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Uvare vo vuutavi raga-ia Tugoropato Uraurato visii tavirevere vo reo iava oa-ia voea vo reoroaro pukosa auepata.” ");
INSERT INTO roo_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Oire uva iravu voea iava oirara ira Jisas-re oiso puraroepa, “Tisato, oiso ruipaparai ra araokotoa oaa taviri. Ra auero roo piereve varao aite varaaro. Oire ra ragaipa oarai vatereve.” ");
INSERT INTO roo_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Oa iava Jisas rerare oiso puraroepa, “Irouto ragai reesirevora vei rovirieisa. Ora veipa auero roo piesa vei aitearo varaaro?” ");
INSERT INTO roo_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Oa iava voeare oiso puraroepa, “Avoeao. Ora vatatopo iraopata. Ra vearovira rutu uutupata. Opeita orekerovu riiriipata. Ari ita, ro ira riroara rutuva toupareve orekerovu, oire uva uvuipa ra vara-ia riro kaekae tootoo tapo oupareve? Easi viapau!” ");
INSERT INTO roo_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Uva voeapa oavu reo ruu vatereva Jisas. Oa-ia oiso puraroepa, “Aio kovo iravu riro monito oirato vaaro, okovoa rirovira aio puraera. ");
INSERT INTO roo_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Osa iava ora rera raga sopaaro-ia oiso rugorugooparoera, Eake vai puraa? Viapau oiso kepa vaiei ragai oaiaro oa uvuipai varao aioara gurusa oa-ia vara oriruoro. ");
INSERT INTO roo_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Uva oiso puraroepa, Oiso ragavira va purapaavoi. Vara rutu varao aio kitupa keparo pakopaavoi vara rigaoro. Oire ra riroa rutu puraa va-ia vao. Ra va iava vara rutu witara gurua voa ora varao vearopara ragai varaaro vo kepa-ia. ");
INSERT INTO roo_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ra ora ragai raga ora tavira oiso puraoro, Riroara rutu vearopara vii varaaro. Oara vearovira touvora riroara rutu-ia ivara voarire utupaua tapo uvuivira. Oire reareau aiopaoro, ora ukaiopaoro tapo, ora roruvira touri. ");
INSERT INTO roo_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Oa iava Pauto oiso puraroepa rerare, Auoro. Kokoropato-a vii, viigoa kopiipauei vo rupao raga-ia. Osa vara rutupe varao oara vatatoporivo. Oire uva iroutoa vai vii varaaro ourevere? ");
INSERT INTO roo_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Eisi osa ragavira ita oearovu orekerovu rutu vo rasio raga iava voea varaaro gurupaiveira ora voeapa vo Pauto osireiaro-ia. Vo osa Pauto voea vaisipareveira oiso, Apota irara raga voea.” ");
INSERT INTO roo_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Oire uva Jisas ora rera voeaarore disaipel oiso puraroepa, “Osa-a eisi osa iava visii tavipaavoi oiso, Opeita ora visii varaarore rugorugoopata rutu tootooara oiso purapaoro, Eake vai aiopaio? Ora eake vai-ia varaura oaio rakurakupaio? ");
INSERT INTO roo_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Aioarei ora varoa viapau oiso uvuipai ra visiipa vearo tootoo vai vatepaive. ");
INSERT INTO roo_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Oire voeaore kokio kare rugoopata oea viapau wit taraapaaveira, ora tapo viapau oiso aio gurupaaveira. Uvare viapau voea kepaa vaiaro aio gurupasa ora orekerovu oaive tovopasa. Ari ita, Pauto voea vatepareveira aioara. Oire uva visii oirara voriaro vo kare vo voriaro-ia putepaiveira rutu. Oa iava Pauto pute pievira visii tokipareveira. ");
INSERT INTO roo_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Iroutoa vaiei visii iava ira uvuiparoi ra ivara vai sigusiguvareve ora rera vo tootooaro uvuioro, vo rara rirovira rutu rugorugooparo ora rera tootooarore? ");
INSERT INTO roo_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Oire vosa viapau uvuipatai ra oiso oavi gareavi vai purata ivara siguvapaoro, ra eakere riroara ruture vovousopata? ");
INSERT INTO roo_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Vearovira rutu rugoopata auere kokookoara oara ratau tou ragapaiveira. Ari ita, viapau oiso ora varapa kasivaripapeira kovopaoro ora rakurakupara vai turupaoro. Ari ita, visii tavipaa aue iava King Solomon riro orekerovu rutu-ia pituto, ira oisoa ora rera raga ora oritoparo tuariri rutu. Uva viapau oiso vearo oritoa vaiaro rera oaiaro vearoara rutu oiso osa varao-ia kokookoara. ");
INSERT INTO roo_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Iu, isiso kouro toupai varuparo. Uva vokipavira vo kouro tosiivere vara vikisa tuituia-ia. Uva vara-a evara okouroa oritopareveira Pauto. Oire uva apeisi-a? Easi uvuiparoi Pauto ra oiso visii tapo orito iraopareve? Ari ita, oiraopavira viapau oiso uvuivira rutu raripatai rera-ia. ");
INSERT INTO roo_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Eisi ra opeita rirovira rugorugoopata oiso, Eake vai aiopere, o eake vai-ia ukaioviovere? Ra varare taraapata. ");
INSERT INTO roo_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ari ita, rupa vovou irara oisi eisi oiso rugorugoopaaveira varare varao. Va-ia vao taraiparoveira Aite oavisii ro vova vuvuiua oiso, Vosa viapau aioara vai, ra ogoepaoro kopiitavere. ");
INSERT INTO roo_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Easi uvuipatai ra vao ruture rugorugoo iraopata Pauto vo Saraaro vare taraapasa. Ra va iava vara tapo evara vatereve visiipa. ");
INSERT INTO roo_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Opeita uriripata sipsip ragui ragai voeaaro. Ari Aite oavisii reo ovoi purareva rera vo Saraaro vatesa visiipa, oiso ra va iava oearovu oirara tokitavere voeapa reipaoro Pauto tapo toupaoro. ");
INSERT INTO roo_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ari auero rutu vateta oearoipa. Ra vara voriive. Oire voeao vateta vo moni oea apotapaaveira voea tauvapaoro. Ra vaore moni bokis taraata oa viapau vuripapeira. Oire ra va-ia vearopara guruta vo vuvuiua varao oara viapau opesipape vo vuvuiua-ia. Aue iava uvare kavirupa irara viapau voare tutuu piepaiveira. Ora viapau rivute kare vara vuri piepaiveira voa. ");
INSERT INTO roo_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Oire uva vo tavuki-a vao visii vaaro oa-ia visii varaaro vearopara toupaiverea, uva vo tavuki-a eva oa-ia visii vo vovouroaro toupaiverea vearoparare rugoopaoro. ");
INSERT INTO roo_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Goruvira tuuta aue-ia takipa iroro. Oire ra vuravuara rukueta vatatopovira tuevira tousa. ");
INSERT INTO roo_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ra oiso rutu tuepaoro touta, Oea rore reito tuepaoro toupaivoi. Ira riroa iava riako oupa aio kareparoi. Oa iava rerare tuepai vo osa voava kareparo. Ra voava tupa totosa pouro viro. Oire ra rerapa karuive ikauvira. ");
INSERT INTO roo_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ra voava kareoro voea iare pouro viro osa torevira raga toupaive voea kovopa irara. Oire ra va iava rirovira rutu roruive. Ari ita, oiraopavira visii tavipaavoi oiso, Ora rera raga vaisiaro vara piepaoro ro reito tuu iro goruvira takirevere. Oa iava voava voea tavirevere pausa tebol-ia. Ra rera raga voa voeapa aioara vatevaterevere. ");
INSERT INTO roo_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ari vosa voki vuuta rutu-ia pou virooro urioro, eke vo osa rovo gau purapareve kookai, ra voea kekereve osa viapau uusipaave. Oire ra va iava roruive voea kovopa irara. ");
INSERT INTO roo_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Vaore rugoopata vao-ia. Vosa rera ro ira vo kepaaro-a tarairo oiso, Vo vokio-ia kavirupato urioparoi. Oire ra viapau oiso rera eaka ragaparevori osa vo kepai tateoro kavirusa koataparo. Viapau. ");
INSERT INTO roo_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Oire uva visii tapo vatatopopatavere tuevira. Aue iava uvare Oirato Oviitoaaro vo voki-ia uriorovere oa-ia viapau taraipata oiso, Vo vokio-ia uriorovere.” ");
INSERT INTO roo_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Oire uva Pita oiso puraroepa, “Turaro. Easi vii vao reo ruu vatepari igei ragapa, eke oirara rutupa tapo?” ");
INSERT INTO roo_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Oa iava Jisas oiso puraroepa, “Easi, aa ro-a ro tokipato ira toupare vearo rugorugoo vaiva, ra va iava osivu avu rutu ora rera vo kovoroaro tokipareve? Vosa ro ira oisi ragavira oiso-ia toupareve, oire uva rera-a eera ira reesirevere reito rera voeaaro kovopa irara tokipasa. Ora voeapa aio vatepasa vo voea vo vuutaroaro-ia aiopa vuutaro. ");
INSERT INTO roo_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Oire ra utupavira rera reitoaaro vorevira vorero. Uva rera reraaro kovopato kekerevere, vo osa varao rutu purareve oiso osa rera tavireva voari tuariri. Oire ra va iava rorureve rera ro kovopato. ");
INSERT INTO roo_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Oiraopavira visii tavipaavoi oiso-ia, Reito oaro oiso rera tovoreve auero rutu tokipasa varao rera varaaro. ");
INSERT INTO roo_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Oire ra pasi ora rera raga sopaaro-ia rera ro kovopato oiso rugorugooro, Viapau uvuiparoi ragai reraaro reito, ra vorevira vorero ovoki-ia ikauvira. Oire ra va iava rovoro oearovu kovopa irara upopaoro. Ora airorovu kovopa riako tapo upopareve. Ra va iava rovoro aioa raga purapaoro, ora aue ukaio spak vuri reoreoro raga purapaoro. ");
INSERT INTO roo_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Oire vosa oisi piepareve osa rera ro reito vorevira vorero ovokivu-ia, ovusa vo voki-ia rera ro kovopato viapau rerare tuero. Vo voki-a vao oa-ia oisoa viapau rerare rugorugoopaoro toupareve. Oire ra va iava rera ro reito rera vuri piereve rutu. Ra va iava vo vuri tapi rera tovoreve voea ruvara-ia oea viapau vearovira ora voea vo kovoroaro tokipaive. ");
INSERT INTO roo_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Kovopato oiso taraiparo rutu rera reraaro reito vo vovouaro-ia. Uva viapau rerare tuevira vatatoporoi, uvare viapau rera vo vovouaro sirova utuparoveira. Oire uva rera-a eera ira vurivira rutu uporevere taru reito. ");
INSERT INTO roo_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ari ro kovopato raga ira viapau oisoa taraipa vo reito vo ruipaaro-ia, oire ra oiso raga ita tarai asavira viapau vearo kovo vai purareve. Oire ra va iava oisivi raga ita gare visivi rera uporeve reito. Ora iroutoa rutu-a ro ira vearo taraiva toupareve, ira ita uvuiparoi ra vearo kovo purareve rera vo taraiaro oirao pieoro vo oearovu osireiaro-ia. Ora vosa Pauto irai ruvara-ia oisi oiso oai riro kovo vai tovoreve oiso ra va purareve, oire ra utupavira Pauto oiso ruiparo ra vearoa vai kekereve vo kovo-ia vao oa tovoreva. ");
INSERT INTO roo_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Urioraera tuituia kasisa vo rasitoa-ia. Uva oiso ruipaparai ra ikauvira vuvuoro vuriara rutu rovape vo rasio iava. ");
INSERT INTO roo_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Oa vituaro iava oiso ruipa iraoparai ra ikauvira baptaisa vai oua, ra vo tavakao opesipe vao oa ragaipa siitoka vatepaiveira. Obaptaisa iava sopaua rirovira rutu ragai iava siraope. Ra vo tugurape uva opesipere vo sirao utupaua. ");
INSERT INTO roo_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Esa pasi oiso vaio keapatai, Varao rutu upoara opesi piesa urioraera vo rasio-ia, raa? Viapau. Easi oiso oiraopavira visii tavipaavoi, Ragoa voea oirara oisi piesa urioraera, ra ora voea iava voearei puraive ora tokopaoro. Oa iava oeavu ragai vo reoaro uvuive osa voea-ia oeavu raga viapau. ");
INSERT INTO roo_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Vo voki-a vao oa-ia oira vavae toupaivere katai kepa-ia. Oire uva voava ora voea-ia voearei puraivere ora voea-ia tokooro oiso, operuvavu aitereivuva ora upoave ragai iavirava. Osa ita aitereivu vo peruvava ora uposi ita. ");
INSERT INTO roo_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ora vo osa aite irara ovii irarava ora upoavere. Ovusa ita voea-ia ita ovii irara aite irarava ora upoavere. Osa ovii riako aako riakova ora upopaave. Ovusa aako riako ovii riakorova ora upoave. Ovusa oirato aakovaaro taatovava ora upopao. Ovusa oirato vatuavaaro oirava ita taatova oira ita ora upopao.” ");
INSERT INTO roo_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Oire uva Jisas oirara ruture oiso puraroepa, “Rukuta kekepataveira vo osa uriopaoi vova uva ravireo rokopareveira. Oire ra va iava ikauvira oiso purata, Kokeva kovesa auepaoi. Ari oiraopavira iria kovepaoi rara. ");
INSERT INTO roo_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Oire uva oisoa kiuvu tapo sovopaoro oiso purapata, Ravireo rirovira kasiraoparoi rara. Ari ita, uva oiraopavira osa karekeparoveira eisi. ");
INSERT INTO roo_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Avoeao! Riro ratarataa vovou irara rutu visii. E vearovira rasito vo reesiaro kekepataveira ora vuvuiua, raa? Oire uva apeisi iava viapau vo vokio vo reesiaro eveipata varao iava oara purapaavorao. ");
INSERT INTO roo_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Oire eakere visii raga vearovira rutu rugorugoo rovo asapataveira. Ra va iava viapau torevoko rugooro rovirieipata varao purapaoro? ");
INSERT INTO roo_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Vosa touvira raivaaro vokapaoro avapasi ro tapo ira vii iava gasireve, oire ra raivaaro raga tousi. Oire uva vo vuuta-a eva oa-ia uvuipau ra rera tapo vorevira ora agiagiu. Teapi rera eera viiva avaro reo rovirieipato vavaearo-ia vii tovosa. Oa iava vii vaterevere polis irarapa. Oire evoea vii tovoive tuukepa kepa-ia. ");
INSERT INTO roo_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Oiraopavira visii tavipaavoi, Viapau rutu uvuipauei oiso ra ikauvira tuukepa kepa iava kosi virou. Ari vo raga rara varavio rutu garepa pitupituro vuriara vori rovori. Ora varao riropara varao rutu oara voriaro opesi pie rovorivere rutu.” ");
INSERT INTO roo_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Oire uva ovokivu-ia oeavu oirara toupaiva oea Jisas tavipaiva oeavu iava Galili iava, oea uporeva Pailat voea iava revasiva karasa. Oa iava oira uverereva varao tapo oara-ia Pautoa-pa koruoua purasa auepaaepa voeao Jiu-pa irara. ");
INSERT INTO roo_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","3","Uva Jisas voea vo reoaro aatooro oiso puraroepa, “O ita, oiso rugoopataveira, Voeao raga pute pievira vuri vovou purapaiveira oea rirovira tavaka siraoaro oupaiveira oiso rutu osa voeao oea uporeva Pailat. Ovusa oeavu oea vearovira toupaiveira viapau vuri vovou purapaiveira. Uva visii tavipaavoi, Viapau torevokopai evo rugorugoo, uvare vaeapai voeare rutupa. Oa vituaro iava uvui iraopaai ra vovouisi oaive poreive Pautoa iare. Oa vituaro iava vosa viapau visii vao sopaura oavisii poreta vova vuri vovouro oavisii iava, oire uva va-a eva oa vituaro iava visii rutu opesitaverea taru oisi raga ita eisi. ");
INSERT INTO roo_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Oire voeao-ia katai tau vo peva vatara (18) rutu oirara voeao-ia oea rakuva riro kaekae kepa koveoro vo uuko rovu vatuaro-ia vao Siloam, oa iava kopiiaepa. Oire uva apeisi rugoopatai? Voea vo vuriaro oearovu vo vuriaro-ia putepaivoi voeao oea epao Jerusalem-ia, uvare oisi raga kopiiaepa, raa? ");
INSERT INTO roo_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Torevokovira visii tavipaavoi oiso, Viapau rutu. Ari ita, vosa viapau visii vao sopaura oavisii poreta vova vuri vovouro, oire uva va-a eva oa vituaro iava visii rutu opesitaverea taru oisi raga ita eisi.” ");
INSERT INTO roo_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Oire uva oavu reo ruu kosi piereva oa-ia oiso puraroepa, “Iravu oirato varuparo fik ova paureva wain kovo-ia rera vaaro. Uva utupavira urioroepa vo eva kekesa, oiso ra aio kue vai kekereve vo osa viapau oiso kuepape vo eva. ");
INSERT INTO roo_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Oa iava rera roari vo kovo tokipato tavireva rera ro reito oiso puraoro. Uvupari? Vo peva rutu-ia aue ivaara oara sovara-ia oisoa urio ragapara vo eva ivia ragapasa, osa viapau aioara vai vo eva-ia. Oire uva vii taviipaavoi ra vo eva toeri. Eake iava? Uvare rasia goruaro opesi pie ragapaiveira. Osa viapau aioara vai vo evao iava toupai. ");
INSERT INTO roo_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Oa iava ro kovo tokipato oiso puraroepa, Reito, eaka rovou. Ra vo eva vituaro eri rovoavere bulmakau opokoaro tovo rovosa voa gorua vatepasa. ");
INSERT INTO roo_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Easi pasi, uvuipai ra oiva-ia kuepe vo eva vao. Vosa viapau, oire ra vo eva tateri.” ");
INSERT INTO roo_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jisas ovokivu-ia Sabat voki voeapa siposiporeva Reo Taisi Uvupa Kepa Sinagog sovara-ia, ");
INSERT INTO roo_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ovusa voa iriavu riakova toupaeva iria-ia vurito tugarato oisoa toupareve. Oire uva oira-ia oisoa toupaoro oirapa riroa upia rutu oisoa vatepareve katai tau vo peva vatara (18) ivaro rutu sovara-ia. Uva va-a vao oa iava oira iava avuaua puko piropa. Osa iava viapau oisoa torevokovira torepao. ");
INSERT INTO roo_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Oire uva Jisas oira kekereva. Oa iava oirare oiso puraroepa, “Vii iava upia opesi pieavoi.” ");
INSERT INTO roo_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Uva oira kukuearo-ia vavae tovoreva. Oa iava ravotovira raga torevokovira tore ovoiopa. Osa iava Pautoa-ia vuurapa vaisi pura ovoieva. ");
INSERT INTO roo_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Vo osa ro ira oisoa Sinagog-ia reiparo rirovira rutu kasipu iraoparoepa, uvare Jisas vo voki-ia vao oa purareva oira ravotovira porete pieoro. Oa iava oiso puraroepa reito voeare, “Ari katai vatara (6) vokiro toupai visiipa kovopasa, ovokiroa-ia uriopata ruvarupa tauva oupasa. Uva viapau uvuipatai ra vore uriopata varao purapasa vo vokio-ia vao Sabat voki.” ");
INSERT INTO roo_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Oa iava reito vo reoaro pukooro oiso puraroepa Jisas, “Avoeao! Riro ratarataa vovou irara rutu visii. Easi Sabat Vokiro-ia avapataveira bulmakaupa kepa iare vo karere karupasa voeaore bulmakau kare, ora aue donki kare tapo auere vo kare ukaio piepasa, eke? ");
INSERT INTO roo_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ari o-ia riakova eira iriavu aue Ebraham aaovaaro Jiu-pava, iria tuukereva Seten aue rutu uvuiaro-ia katai tau vo peva vatara ivaro (18). Oire uva va-a eva oa iava oira iava vo tuuke karuavoi oira porete piepaoro vo vokio sovara-ia vao Sabat voki. Uva apeisi-a? Oira-ia vuria puraavoi?” ");
INSERT INTO roo_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Oire uva oisi-a eisi osa puraroepa. Oa iava voeao rerava keripa irara rirovira ariiaepa rutu. Osa oirara rutu rirovira roru iraopaiva vara rutu-ia varao vearopara oara oisoa purapareve. ");
INSERT INTO roo_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Uva va-a vao oa iava voea oirara akereva Jisas oiso, “Aa vao oiso toupai Pauto vo Saraaro? ");
INSERT INTO roo_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Oa-a eva oiso rutu toupaiveira, Oavu aio kue oa vaisipaiveira oiso, mastet. Oa iava aisivu oureva gare isivi rutu iravu oirato vaisi pausa varuparo vo ora rera vo kovoaro-ia. Oa iava voa rirovira rutu riroepa oiso osa evaova. Uva va iava oisoa kokio kare vo eva raoaro-ia pitupaoro epitapasa uriopaave voa.” ");
INSERT INTO roo_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Oire uva Jisas oiso ita puraroepa, “Apeisi ragavira vai uvuiparai ra Pauto vo Saraaro ovoovoa? Eake vai-ia? ");
INSERT INTO roo_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Oa oiso toupai osa aue yis. Vao yis oa oueva iriavu riakova aue tapo plaua dram va uveresa. Oa iava utupavira va vao plaua kae piropa riropaoro.” ");
INSERT INTO roo_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Oire uva Jisas vokapaoro avaroepa ouruirovu-ia reipa uruiro ora varao tapo garepa uruiro. Oirara rutu tarai piepaoro vokapaoro avaparoepa. Uvare oiso vovouparoepa ra Jerusalem-ia kare uviroro. ");
INSERT INTO roo_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Oa iava iravu oirato oiso rera akereva, “Turaro. Esa Pauto katakataipa iraravi vai vorevira oureverea ora rerapa pasi, raa?” Oa iava Jisas oiso rerare puraroepa, ");
INSERT INTO roo_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ora visii vo vovouroaro goru pie iraota. Oa iava uvuipatai ra vaovio gare ratao-ia koatata Pauto vo Saraaro iare taru. Visii tavi iraopaavoi oiso, Riro irara rutu oiso ruipapaave oiso ra koataave, vo osa viapau uvuipaai. ");
INSERT INTO roo_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ari ita, vo utupaua uva ro ira vo kepaaro-a ira rataoa tupareverea. Oire ra ratau torepasa uriota vo ratao totopaoro. Uva oiso purapataverea, Reito. Rataoa karuri igeipa. Osa iava oiso visii akereverea, Ovu iava visii? Viapau visii-ia taraiparai. ");
INSERT INTO roo_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Oire ra oiso purapata, Easi igei vii tapo aioiovora ora ukaioiera, vo uva igei vo uruiaro vuutaaro-ia torepaoro igeipa siposipoparivora. ");
INSERT INTO roo_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Oire uva visiire oiso puraroverea, Avoeao! Ovu iraova visii? Viapau visii-ia taraiparai. Visii-a riro vuriara pura irara. Visiigoa ragai ruvara iava vova avata. ");
INSERT INTO roo_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Oire uva voeao Ebraham vase ora Aisak ora Jekop, ora voea rutu reo topa piepa irara profeta irara oea rutu keketaverea, ovusa Pauto vo Saraaro-ia toupaive. Ovusa visii raga ratau toupata ora visiipa vurivira rutu gaupaoro, ora visii iava reuri oavisii raga kuripaoro siraovira. ");
INSERT INTO roo_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Vo osa oirara rutu vorarova rutu vo rasio-ia ora aivaro piesa urioaverea pauoro vo Pauto vo Saraaro sovara-ia aiopaoro vearotoa-ia tebol. ");
INSERT INTO roo_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ari ita, uva voearo oea visii sirova oisoa utupaave, evoea oea visiipa iraaverea vo Pauto vo Saraaro sovara iare. Ovusa voeao oea visiipa oisoa irapaave, oea taru visii sirova utuaverea.” ");
INSERT INTO roo_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Oire uva vo vuutavi raga oa-ia torevokovira urioaepa Farisi oiso rera tavisa, “Avau vova uvai ragare. Ari King Herot vii uposa aueparoi.” ");
INSERT INTO roo_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Oa iava Jisas oiso voea tavireva, “Voreta oiso rera tavisa Herot ro ira vuri rugoo purapareveira kaakau aakauto. Uvuri! Vo vokio-ia ora vokipavira uva vuri irara tugara kosi pieavere, ora upiapa irara porete piepaavere. Oire uva vo pevapa voki-ia ragai vo kovoaro opesi pieavere. ");
INSERT INTO roo_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ari ita, vo vokio ora vokipavira ora vo vokipari-ia utupa uva vokapaoro avaravere Jerusalem iare. Aue iava uvare voeao vo kovoaro-a profet irara upopasa oea Jerusalem-ia toupaiveira. Teapi oeai raga ragai upoive ourui raga-ia. ");
INSERT INTO roo_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Ae! Visii vao Jerusalem vata! Ae, Visii Jerusalem vata! Visiigoa profet irara upo iraopataveira. Ora voeao vuroko iraopataveira aue-ia avekeara Pauto oea sipo ragapareveira visii iare. Visii ovii iraraaro-ia guru ruipa ragapaaveira oiso osa kokootu ovii irara tavurupaeveira putaeuarei-ia. Vo osa visii vao reasipataveira ragaipa. ");
INSERT INTO roo_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Uvuta! Pauto visii vo uruiaro kavurevoi. Uva oisi-a eisi osa iava visii tavipaavoi, Viapau oiso ragai keketaverea vorevira vo rekasisa utupaua, uva oiso purataverea ragaire ragoa roporeva Pauto, Pauto vearoa viraakoa vatereva ropa ira urioroi Turaro vaisiaro-ia.” ");
INSERT INTO roo_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Uva ovokivu-ia Sabat voki Jisas aiosa avaroepa iravu vo kepaaro iare ro Farisi reraaro reito. Osa voa Jisas siitueiva kasikasi pievira. ");
INSERT INTO roo_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Oire uva iravu oirato ira iava varaua tuvuuepa rera ruvara-ia toupareva. ");
INSERT INTO roo_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Uva Jisas rera kekeoro voeao Reo Taisi-ia tarai irara akereva voearei rutu ora ratarataa vovou irara Farisi oiso, “E pasi, uvuipaviei ra Sabat voki-ia upiapa irara ruvarupape, eke viapau?” ");
INSERT INTO roo_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Uva ora tape pieaepa. Osa iava rera oureva. Uva rera vorevira ravotovira porete piereva. Oa iava rera iava vasereva. Uva avaroepa. ");
INSERT INTO roo_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Oire uva oiso voeare puraroepa, “Vosa irai oviitoa vaiaro visii iava, eke bulmakau vai kove rikui vai-ia uukopava vai, oire ra viapau pasi ikauvira rera vorevira kae piereve vo voki-ia vao Sabat voki, raa?” ");
INSERT INTO roo_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Oa iava ariipaoro viapau rera vo reoaro vao aatoiva. ");
INSERT INTO roo_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Oire uva Jisas voea siituepareva, ovusa vo aio iare urioaepa varao raga-ia rovopara paupasa paupara. Osa iava voeapa oavu reo ruu vatereva. Oa-ia oiso puraroepa, ");
INSERT INTO roo_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Vosa irai viire keeraro kaokaooro, oire ra avau vao iare riako oupa aio. Ra viapau oiso paupau vao-ia rovopa paupa. Auepa teapi rera ro iravure ita keerarovere, ro rei vaisitoa rutu ro ira vii vaisiaro-ia pute pievira toupare. ");
INSERT INTO roo_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Oire ra rera ro ira veire keeraro ira urioro oiso puraoro viire, Evoava rovopa-ia paupa verau eerapa. Ra va iava rirovira rutu ariioro vuria-ia pausa rereri. ");
INSERT INTO roo_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ari vosa irai viire keeraro, oire ra avau vo aio iare. Ra isivauaro rutu pauu. Oire vosa oisi pieri, ra rera ro ira viire keeraro urioro viire oiso purasa, Vatetoa oaa, uriou vo pausa viara-ia ragai ruvara-ia. Oire ra oisi vii piereve oiso-ia. Oa iava uvuipau ra riro vaisi rutu ouri vo oirara rutu osireiaro-ia voeao oea tapo aiopari. ");
INSERT INTO roo_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ari ita, vosa ro ira ora rera raga vaisiaro kae piepareve, uva rera-a eera Pauto ira vaisiaro akaipa piereverea. Osa ro ira ora rera vaisiaro akaipa piepareve, eera-a Pauto ira vaisiaro kae piereverea taru.” ");
INSERT INTO roo_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Oire uva Jisas oiso puraroepa rerare ro ira rerare keeraroepa vo aio iare, “Vosa oai aioa vai purarivere, ra viapau oiso ora vii vate iraraarore keerau, ora araoko irara vai oara, ora vii sara irara vaiaro, ora oearoi vii iavapa irara vai voearo riro moni irara. Auepa teapi vorevira viire keeraave, ra avau voea vo kepaaro iare aiosa. Oire ra vo aio vao vii vaaro kare pieive viipa vorevira. ");
INSERT INTO roo_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Viapau. Ari vosa oai riroa vai purari aioa vai. Oire ra voeaore apota iraravi keerau, ora voeao vuri vara irara, ora voeao vuri kokoto irara, ora voeao voosi irara. ");
INSERT INTO roo_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Oire uva voea-a evoea oea viapau uvuipaai ra viipa oaioi puraive vo aio kare pieoro oa purarivora voeapa. Ari ita, uva oisi-a eisi osa iava uvuipau ra roru iraopari. Eake iava? Uvare Pauto viipa vo aio vao purareverea vo vokio-ia oa-ia voeao torevoko irara toreaverea vova tova urui-ia.” ");
INSERT INTO roo_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Uva va isivaaro iava iravu voea iava voeao oea rera tapo aiopaiva ira vo reo vao uvureva. Oa iava rerare Jisas oiso puraroepa, “Ro ira Pauto vo Saraaro sovara-ia paupaoro aiopareverea, ira uvuipa ra roru iraopareve.” ");
INSERT INTO roo_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Uva Jisas rerare oiso puraroepa, “Iravu ira riroa aioa purasa aueparoepa. Oire uva va iare riro irarare keeraroepa kaokaooro vo aio iare oiso ra urioave. ");
INSERT INTO roo_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Oire uva vo vuuta rutu-a vao vo aio vaaro oa karekeepa. Oa iava voeare rera voeaaro arureva kovopa irara, oiso ra voeare avaave oeare kaokaoa pura rovopareva. Oa iava oiso voeare puraaepa, Uriota aiosa. Ari auero rutu vatatopoe. ");
INSERT INTO roo_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Uva voea rutu vaea reo raga ita purapaiva oiso, Viapau uvuipai oiso ra evo aio iare avavio. Oire uva va-a vao oa-ia iravu oiso puraroepa, Oavu aio kovo voriavo. Vearovira rutu ari viapau uvuiparai ita ra evo aio iare uriora. Uvare oiso ruipaparai vo kovo keke rovosa ava rovora. ");
INSERT INTO roo_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ari iravu oiso voea tavireva, Ari ita, katai tau voriavo aue bulmakau kovopa kare. Oire uva oiso vovouparai ra voea akeakesa avara. Vearovira kaokaoa-ia. Ari viapau uvuiparai oiso ra evo aio iare uriora. ");
INSERT INTO roo_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Uva ita, iravu voeare oiso puraroepa, Ari ita, vaviopavira raga riako ourai. Oa iava viapau uvuiparai ra uriora evo aio iare. ");
INSERT INTO roo_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Oire uva oisi-a eisi osa iava kovopa irara voreaepa reito tavisa va iava vao-ia. Oa iava rera ro ira vo kepaaro-a rirovira rutu kasipuparoepa. Uva oiso kovopa irara tavireva, Ikauvira avata oiso ragavira riropa raivaro iare, ora varao garepa raivaro varao vorarore riropa urui sovara-ia. Voeaore avata apota irara rutu, ora voeao vuri vara irara, ora voosi irara, ora voeao vuri kokoto irara. Oire ra voea rutu koata piesa uriota vo ragai vo kepaaro-ia. ");
INSERT INTO roo_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Oa iava voea voeao kovopa irara oiso puraaepa, Ari ita, reito vii vo reoaro puraiovora. Ari touvira oaravu-a varao paupa tavukiro viapavira. ");
INSERT INTO roo_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Oa iava ita rera ro reito voea tavireva oiso, Avata vorarore riropa raivaro, ra voa kasuraara gaeta varao aio kovoro. Oire ra voava voea rutu ivuoro voreta voea koata piesa vo-ia ragai vo kepaaro. Uvare oiso ruipaparai ra ragai vo kepaaro agasipe rutu. ");
INSERT INTO roo_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Uva oiso visii tavi iraopaavoi, Voeao iava oeare keera ragaraerao oea viapau rutu uvuipaai ra vo aio ouive ragai vaaro.” ");
INSERT INTO roo_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Riro irara rutu Jisas tapo vokapaiva. Uva voeare ora poreoro oiso puraroepa, ");
INSERT INTO roo_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Oire vosa ro ira ragai sirova utu ruipaparo, oire ra aitetoareire isiva rovoro ora aakova, ora riakovaaro, ora kakae vurearo, ora araoko iraraaro, ora taataa riakoaro, ora vao tapo rera vo tootooaro raga. Vosa viapau oisi pie rovoreve ragaire pute pievira rugoopasa, oire uva viapau oiso rera-a eera ragai reraaro-a disaipelto. ");
INSERT INTO roo_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ora ro tapo ira viapau ragai sirova utuoro ora rerapa evao parikou aue siraoa vo tavakaaro kaereve. Oire uva rera-a ita eera viapau oiso ragai reraaro-a disaipelto. ");
INSERT INTO roo_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“E apeisi-a? Vosa irai visii iava riro kaekae kepa vai pausa aueparo viara-ia ruture. Oire ra pau rovoparo vo kepa voriarore vearovira rutu rugoo rovopasa oiso rugoopaoro, Esa ragai vo moniaro uvuipai avu ra va-ia vo kepa vao opesipe, eke viapau? ");
INSERT INTO roo_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Vosa viapau oisi vo kepa pie rovoreve, ra va iava utupavira simen tovoreve. Oire ra viapau oiso ikauvira vo kepa opesi piereve. Ra ita, riro irara rutu rera agesipaoro rera tovipaive. ");
INSERT INTO roo_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ra oiso puraave, E rera-a ro ira vo kepa rovorevorao? Uva apeisi viapau vo kepa opesi pierevo? ");
INSERT INTO roo_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Ora vosa irai king vai iraiva ita king vai ora uposa avaro. Oire ra oiso pau rovoro vearovira rutu rugorugoo rovosa. Aue iava uvare rera voeaaro-a katai tau tuku rutu (10,000) viurupa irara voeao rera voeaaro. Vo osa roari iravu erao tau tuku rutuva (20,000) urioro voeao rera voeaaro viurupa irara. Uva va-a eva oa iava vearovira rutu oiso ora rugorugoo pie rovosa pauro oiso, Esa pasi uvuiparai ra rera roari king upoa rera siguoro, eke viapau? ");
INSERT INTO roo_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ari vosa oiso rugooparo, Viapau uvuiparai. Ra va iava rerava keripatoapa tauaivira toupareve. Oire ra va iava oearovu arupareve rera iare roari rera arepasa, oiso ra vearo reoa vai purasi vo upo opesi piesa. ");
INSERT INTO roo_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“Osa raga ita oiso-ia, vosa irai visii iava vearo rugoo-ia varao ruture rera varaarore isiva rovoparo vara iava vase rovopaoro, oire ra oiso toupareve, Ragai reraaro disaipelto. ");
INSERT INTO roo_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Avaka vearoa rutu. Ari vosa va vo sipeiaro opesipe, ra uvuipai ra oai purape vare? Ra oai iava vorevira sipeipe, raa? ");
INSERT INTO roo_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Vo avaka vao-ia oiso-ia, oa-ia viapau uvuipaviei ra va tovopape varuparo aue tapo bulmakau eekoaro vao uverepaoro, auere gorua vatepasa rasiapa. Oire ra va iava avaka vera ovoiive. Ari vosa ro ira-ia kokito toupare, oire vo siposipo orirureve va kuverapaoro ora rera sopaaro-ia.” ");
INSERT INTO roo_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Takis oupa irara ora oearovu vuri irara oearea rutu Jisas iare urioaepa rera vo siposipoaro uvusa. ");
INSERT INTO roo_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Uva va-a vao oa iava ratarataa vovou irara Farisi ora voeao tarai irara Reo Taisi-ia oearea rutu rirovira kasipu iraopaaepa oiso purapaoro, “Rera-a ro-ia vuri irara vatetoaaro. Ira voea tapo aiopareveira.” ");
INSERT INTO roo_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Uva oisi-a eisi osa iava vao reo ruu vatereva Jisas voeapa. ");
INSERT INTO roo_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Vosa irai visii iava oaiaro aue katai vovoto vai (100) sipsip. Oire vosa iriai voava opesikoo. Oire ra rera ro ira vo raguiaro-a aue raga kavureve vo resura vatara tau vo resura vatara (99), ovusa aiopaive toupaoro uvavivu. Osa avaro oirare o taraasa sipsip iria opesikoo. Osa iava oirare voraro kasivarivira taraapareve. Ra vova oira oureve vorevira. ");
INSERT INTO roo_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Oire vo osa oira ouro, ra oira kaverukopaoro vorevira karero oira-ia rorupaoro. ");
INSERT INTO roo_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Oire ra ora rera vo kepaaro iare urioro oirava. Ra voava ora rera iavapa irarare keeraro voeao rera vate iraraaro. Ra voava urioave ora gurusa. Oa iava voa voea tavireve oiso, Ragai tapo rorupata. Uvare iriavu sipsip ragai oiraaro opesikoora virataoro. Oa iava oirare taraaavoi vorevira oira ousa. ");
INSERT INTO roo_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Uva oisi-a oiso osa visii tavipaavoi, Oiso osa raga ita vuvuiua-ia rorupaiveira oearovu-ia oirara oiso, Voea torevoko vovou irara vo resura vatara tau vo resura vatara (99). Aue iava gareara voea varaaro vuri vovouro. Oire uva vara iava vorevira porepaa virove sopaura oaive iava. Ari ita, vosa irai vuritoa vai iava sopaua vai oisi oiso vorevira pore piro, oire ra va iava riroa rutu rorua karekepe pute pievira vuvuiua-ia. ");
INSERT INTO roo_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Vosa iriai riakova oaiaro katai tau (10) aue monia vai. Oire ra utupaua aisivu voava monia-ia opesikope. Ra vaisire vuravu rukueeve vo aviavia kepa iava vearovira rutu viousa vuravurapaoro. Oire uva vaisire taraapaeve vo tugurasa uva vaisi kekeoro vaisi oueve vorevira. ");
INSERT INTO roo_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Oire vaisi ouoro keerao oearovure voeao oira iavapa irara. Ra va iava urioave oira ruvara-ia ora gurusa. Ra voa voea tavieve oiso puraoro, Ragai tapo rorupatavoi. Uvare aisivu moni isi ragai vaisiaro opesikoera. Uva taraaavo vaisire, oa iava vorevira vaisi kekeavo. ");
INSERT INTO roo_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Uva oisi-a eisi osa raga ita Pauto voeaaro purapurapa irara ensel rorupaiveira, vo rara kataitoavi raga vuritoavi vorevira ora rera iava sopauaaro porereve.” ");
INSERT INTO roo_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jisas oiso puraroepa, “Iravu oirato ira-a vaiterei oviitoarei. ");
INSERT INTO roo_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Uva kikooto oiso puraroepa, Aite. Ragai vateri varao oara iava ragai taviriva oiso, Veipa oiso varao roo piea vovio utupauavi. Oire ra ragai oai oua, rara ragai vateri oai. Uva vearo vaisi purareva aiteto. Oa iava vara rutu roo piereva vaitereipa. ");
INSERT INTO roo_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ikauvira raga rera ro kikooto auero rutu gurureva ora rerapa. Oa iava varava ouruivu iare tauai rutu avaroepa. Osa iava vara rutu moniara oisoa viki ragapareve opitupiturovu rutu-ia vuriara. Uva oisi-a eisi osa oisoa piepareve rera ro kikooto. ");
INSERT INTO roo_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Oire uva vara rutu moniara varao vikireva. Uva va-a vao oa iava ogoeto karekeroepa voa vo taere sovara-ia. Uva viapau monia vai rerapa vao rera tauvapasa. ");
INSERT INTO roo_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Osa iava iravu ruvara-ia kovo ousa avaroepa voava rera vo taere-ia. Uva vuri kovovi raga iare rera siporeva vo ora rera vo rasiaro iare, oiso ra koie ragui tokipare voa. ");
INSERT INTO roo_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Uva oevavu kuearo iava eva ova vo ragui oisoa aio piepareve, uvare vo ragui raga vaaro-a aioa. Oire uva oisoa rera tapo oiso ruipaparo ra vo ragui tapo aiopareve. Uvare viapau irai rerapa aio vatepasa. ");
INSERT INTO roo_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Uva va-a vao oa iava rera rugorugooa karu piropa. Oa iava oiso puraroepa, Aite voeaaro kovopa irara oea riroa rutu aioara aiopaoro toupaiveira. Ari vo uva toupaavoi uva vuri iraorai ogoetoa iava. ");
INSERT INTO roo_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Eagara, uvava vo kareparai aite iare. Ra oiso rerare purara, Aite, asi Pautoa-ia vuria puraavora ora vii-ia tapo. ");
INSERT INTO roo_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Uva viapau oiso vearoto-a ragai, ra oiso ragai vaisipari, Vii oviitoaaro ragai. Viapau. Ari ragai tovopari oiso, Iravu ragai viipa kovopato. ");
INSERT INTO roo_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Oire uva voava kareroepa rera iare aiteto. “Oa iava tauai rutu urioparoepa, osa aiteto rera tuereva. Uva va-a vao oa iava aitetoa iava rirovira rutu sopaua sirao iraoepa. Uva voava ikaureva oviitoa-ia pitu ovoisa. Oire uva rerava uugaa ovoiroepa. ");
INSERT INTO roo_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Oa iava oviito oiso rerare puraroepa, Aite. Ragai Pautoa-ia vuria puraavora ora vii-ia tapo. Uva viapau oiso vearoto-a ragai, ra oiso ragai vaisipari vii oviitoaaro ragai. ");
INSERT INTO roo_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Oa iava aiteto rera voeaaro kovopa irara tavireva oiso, Roari rovopato kuvuto ragai reraaro ouoro uriota ikauvira, ra rera-ia rera kuvuta. Ring vai tapo rera sipareoaro-ia tovopatavoi. Ra va iava vorevira reesia oureve oiso, Ragai oviitoaaro-a rutu. Ora tasiparei vai rera kokotoaro-ia tapo tovopatavoi. ");
INSERT INTO roo_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ra taoropa koruou vai bulmakau upooro oaiva tapo uriota. Ra oai aiopaoro rera tapo rorupe. ");
INSERT INTO roo_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Eake iava? Uvare rera ro ira opesikoroepa oiso rutu osa kopiito ragai oviitoaaro. Oire uva vo vokio vorevira ita ira tootooroi. Ira-a ro opesikoroepa. Oa iava vorevira rera kekeoro rorupai ita. Osa iava rovoaepa rera tapo aiopaoro rorupaoro. ");
INSERT INTO roo_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Vo ovusa avaioto varuparo toupareva kovoa-ia. Uva voava kareparoepa. Oa iava kepa iare kare uviro tutuuroepa. Uva voava pupi guruko uvureva ora aue raurauara. ");
INSERT INTO roo_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Uva va-a vao oa iava iravure kovopato keeraroepa oiso rera akesa, Eake-a vao oa purapai? ");
INSERT INTO roo_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Uva oiso kovopato rera tavireva, Ari vii araokotoaaro ira vorevira karero viroi. Oa iava aiteara taoropa koruou uporevo aue bulmakau. Uvare rera iare vorevira voreroe oviito, osa viapau oiso oavu avu vai vo rera varaaro-ia. ");
INSERT INTO roo_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Uva va-a vao oa iava avaioto rirovira rutu kasipu iraoparoepa. Osa iava reasiparoepa koata arapa. Oa iava aiteto kosiro viropa rera vovouaro vuavua piesa rerare kavevira ora reooro. ");
INSERT INTO roo_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Uva aiteto vo reoaro pukooro oiso puraroepa avaioto, Ari ita, riroara rutu-ia ivara vii vo kovoaro-ia pitu ragapaaveira oiso rutu osa ro kovopato akukutoavi. Osa viapau ovokivi-ia vii varaaro-ia reo goruro tagaupaa vara gasipaoro. Uva va-a eva oa iava viapau ragaipa oavi meme kakae vai vatepariveira, oiso ra ragai voeaaro tapo vate irara oaa rorua oai aiooro. Osa viapau rutu. ");
INSERT INTO roo_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Vo osa eera oviito oara vii varaaro rutu opesi pie ragaparevora vairoropa otopa riako. Oa iava vorevira kareroi. Uva rerare rugooro rerapa taoropava bulmakau uporivoi. ");
INSERT INTO roo_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Oa iava aiteto rerare oiso puraroepa, Oviitoa oaa. Vokiara rutu-ia toupaveaira vegei rutu. Osa iava auero rutu-a varao vii varaaro vo ragai vo kepaaro sovara-ia. ");
INSERT INTO roo_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Uva vo vokio-ia roru iraopai, auere ra vigei iava sopaura vearope rorupaoro rera-ia ro araokotoa oara. Ira opesikoroepa rutu oiso rutu osa kopiito. Oa iava tootooroi. Osa iava vorevira rera kekepai ita.” ");
INSERT INTO roo_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Oire uva Jisas ora rera voeaaro disaipel tavireva oiso, “Iravu riro monito ira reraaro kovo tokipato oisoa toupareve. Uva oearovu rera iare ro riro monito urioaepa. Oa iava rera ro kovo tokipato togapaiva oaravu-ia reoara. Varao oara-ia oiso purapaaepa, Eera vii reraaro kovo tokipato ira auero rutu viki ragapareveira. ");
INSERT INTO roo_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Oa iava rerare keeraroepa ro kovo tokipato. Uva oiso rera akereva, Auoro. Apeisi ragavira vii iava uvuavoi? Avau auero rutu torevokovira vieisa, varao oara oisoa oupari oeavu ruvara-ia, ora varao oara oisoa vikipari oaravu voripaoro ragai varaaro. Uva viapau rutu uvuipauei oiso ra vorevira kovo tokipau. ");
INSERT INTO roo_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Oire uva rera ro kovo tokipato ora rugorugoo pie iraoparoepa vo ora rera raga vovouaro-ia. Oa iava oiso puraroepa ora rera ragare, Esa eake vai purapaavoi? Uvare reito ragai sigurevoi vao iava kovo tokipa kovo. Viapau rutu ragai-ia gorua vaiei vo aio kovo vai purapasa. Ora rirovira rutu arii iraoparai oearovu goruvira are arapa auere aioara vai. ");
INSERT INTO roo_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Oire oavure rugoorai. Vosa va puraa vao-ia, ra va iava ragai ou piepaive vorarore ora voea vo keparoaro-ia, vo rara reito ragai verareve. ");
INSERT INTO roo_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Oa iava katakataivira voea ruture keeraroepa voeao oea oisoa orekerovu rutu ou ragapaive rera ruvara-ia ro-ia reito. Oire uva iravu kovo tokipato iare urioroepa. Oa iava oiso rera akereve, Ovirovuei varao oara oisoa ou ragapari ragai reraaro ruvara-ia reito? ");
INSERT INTO roo_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Uva oiso puraroepa, Katai vovoto (100) auero wel dramro. Oa iava oiso puraroepa, Ie, tiket oa-ia reo goru purarivora vara ouoro. Oire vara rutu vievieioro vara iava vo vavae tau (50) raga rigatori ikau visivi vara vieiaro tavariooro. ");
INSERT INTO roo_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Oire uva iravu ita rera iare urioroepa. Oa iava rera ro kovo tokipato oiso rera akereva, Aa voviroa varao akuku ouara vii varaaro? Uva oiso puraroepa, Ari katai vovoto (100) auero wit bekro. Oa iava oiso rera arureva. Vao ouri tiket. Ra vii vaaro tavariori varao vieiaro rigatooro vo peva vatara tau raga (80). ");
INSERT INTO roo_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Oire uva va-a vao oa iava ro reito rera reraaro vurito kovopato oiso tavireva, Auoro, kasivarivira rutu vii vo kovoaro purarivo oirara varaaro gare piepaoro varao oara oisoa ou ragapaive ragai ruvara-ia. Uvare eisi piepaoro voea roru pierivo ora vii-ia. “Ari ita, oiraopavira voeao oirara oea vo rasio raga-ia rugorugoopaaveira oea kasivarivira rugorugoopaaveira ora voea vate iraraaro roru piepasa, oea raga ita vo pitupituaro oearovu vo pitupituroaro-ia putepaiveira voeao torevoko vovou irara. Aue iava uvare voeao torevoko vovou irara kasivari rugoo asavira voea vo kovoaro purapaiveira ora voea voeaaro vate irara tauvapasa. ");
INSERT INTO roo_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Oire uva visii tavipaavoi vao iava moni vo rasio-ia vuria, vo osa vuri rugooro-ia osivu ragavira va kovo piepata. Uva vara moniara vearovira kovo piepata. Ra vara-ia visii voeaaro vate irara roru piepata. Oire vosa opesipe moni ou vo rasio iava ora orekerovu rutu, ra visii vo pitupituaro iavirava visii oureve Pauto vo ora rera vo uruiaro iare, oa-ia toupaivoi Tootooa opesi asa vo vokiara rutu-ia. ");
INSERT INTO roo_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Vosa irai orekerovi garepara vai vearovira tokipareve, oire ra ita oisi raga reipara vearovira rutu tokipareve. Ari ro ira viapau torevokovira kovopareve varavi-ia garepara, oire ra ita oisi raga viapau oiso reipara-ia torevokovira kovopareve tapo. ");
INSERT INTO roo_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Vosa viapau va-ia vao vuri moni vearovira va kovo piepataverea vo rasio-ia, ra irou rutu visii vatepaive oiraopara vai? Ra oarai tokipata vearovira, raa? ");
INSERT INTO roo_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Vosa viapau vearovira oearovu varaaro tokipata, ra irou visii vatepaive orekerovu avu vai, oiso ra oarai-ia pitupata, raa? ");
INSERT INTO roo_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Viapau kataitoa vai kovopatoa vai uvuiparoi ra aiterei rutupa reitoarei vai okovoreiaro-ia pitupareve. Oire vo osa iravure vuri vovoupaoro iravu ragare vearo vovouparo, eke rerapa ruipaparo rutu roaripa reasipaoro. Ari ita, visii vao viapau uvuipatai ra vo rugoorei rutu sirova ututa oiso, Pauto-a ro, ari vao moniapa.” ");
INSERT INTO roo_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Voeao Farisi oea moniapa ruipa iraopaaveira rutu vare rugoo iraopaoro. Oa iava vo reoro rutu uvuiva Jisas oreoroa purareva. Oire uva rera tovipaiva va iava vao. ");
INSERT INTO roo_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Uva Jisas oiso puraroepa voeare, “Ari ita, visii oiso ruipapataveira ra ora visii vo pitupituroaro vearopa vovouro karekepata oirara rutu osireiaro-ia. Vo osa Pauto visii vo vovouroaro-ia taraiparoveira torevokovira. Oire ra oirara visii vo pitupituroaro kekepaoro oiso purapaave, Torevoko vovouro rutu varao. Vo osa Pauto osireiaro-ia vuivuivira rutu kekepa piro. ");
INSERT INTO roo_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Reo Taisi vo reoroaro Moses vaaro ora profet irara vo reoroaro oara rutu oisoa toupaive oirarapa torevoko rugoo vatepasa. Oa iava vo rutu tugurasa urioepa Jon Baptais vo vuutaaro-ia. Oire uva Jon vo vuutaaro isivaaro iava Pauto vaaro Vearo Siposipo rera vo Saraaro iava vo uruiara rutu-ia kare pirorao. Osa iava oirara rutu kasivarivira kovopai, oiso ra Pauto vo Saraaro-ia koataave. ");
INSERT INTO roo_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Utupaua vuvuiua ora rasito oiso opesiperea taru, ovusa Reo Taisi iava viapau oavi gare rigatovi vai opesiperea vao Pauto vo reoaro. ");
INSERT INTO roo_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Vosa oirato riakova kavureve iriavu raga ousa, oire ra va-ia ora oua vuri piereve otopa pitupitu purapaoro. Ora vosa ro ira oira oureve o iria kavu rovoreve roari, uva rera-a eera ira ora oupa vo taisiaro vuri pierevoi otopa pitupitu purapaoro. ");
INSERT INTO roo_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Tuariri iravu riro monito ira oisoa toupareve. Uva oisoa vokiara rutu-ia vearopa kuvuro-ia kuvuparo revasipara. Ora vokiara rutu-ia vearo aio rutu oisoa tapo aiopareve riro rorua oupasa ora rerapa. ");
INSERT INTO roo_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ovusa rera vo kepaaro rataoaro ruvara-ia iravu apotato oirato toupareve. Rera vaisiaro, Lasaras riro kapukapuato vova varaua-ia. ");
INSERT INTO roo_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Oa iava oisoa rurukopara kavopareve rera ro riro monito reraaro tebol reroarova. Oire ra varavi-ia ora reravi iava kovuto vuku pie ragapareve. Uva voa oisoa kaakau kare rera kapuaaro veaveapasa uriopaave ora voea arevuoaro-ia. ");
INSERT INTO roo_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Oire uva rera ro apotatoavi kopiiroepa. Oa iava enselpa irara rera kaeiva Ebraham ruvara-ia rera tovosa, uva oisoa rera tapo toupareve. Oire uva rera isivaaro iava rera ro riro monito kopiiroepa. Oa iava rera tovaiva. ");
INSERT INTO roo_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Uva vo toupare vuri tapi riro siitoka oupa tapi rutu. Uva voava taraapavira tuupavira aue Ebraham vaio vurapareva, ovusa Lasaras rera sirova toreparoepa, ovusa tauaivira toupasiva rerapa. ");
INSERT INTO roo_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Oire uva voa-a vo uvava rera ro riro monito keeraroepa oiso puraoro, Aite Ebraham. Ragaivipa siraou. Lasaras aruri, ra sipareo rupu pieoro urioro ragai iava arevuotoa-ia oira tovosa. Ra rera vuavua piereve gare visivi. Ari ita, vurivira rutu upia sovo iraopaavoi vo kasio-ia. ");
INSERT INTO roo_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Vo osa Ebraham oiso puraroepa rera aatooro, Oviitoa oaa. E rugoopauei voarire tuariri uva tootoovira touparivora vearopara aiopaoro, ora vara oupaoro ora viipa? Osa ro-ia Lasaras ora rerapa vuriara oisoa oupareve. Uva va-a eva oa iava rerare sopaua vearovira toupaivoi vo uruio-ia, osa vuri siitoka ouparivoi ita vii. ");
INSERT INTO roo_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ora oavu tapo vo vigei vuutaaro-ia oa tovoreva Pauto vigeipa tugivira rirova apui. Eira iria-ia viapau voeao uvuipaai ra oira iviropaoro visii iare uriopaave. Ora voea tapo ita eisiva viapau uvuipaai ra oira-ia iviropaoro vore uriopaave igei iare. ");
INSERT INTO roo_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Oa iava riro monito oiso puraroepa, Ari ita, aite Ebraham. Oiso viire keeraparai ra Lasaras aruri. Ra aite vo kepaaro iare avaro. ");
INSERT INTO roo_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Okepa-ia toupai vo vavae voeao ragai araoko iraraaro. Oire uva oiso ruipaparai ra goruvira rutu Lasaras voea tavirevere auepa, teapi voea tapo ita vore urioave riro-ia siitoka. Vo osa viapau voea iava sopaura pore rovo piro vova vuri vovouro. ");
INSERT INTO roo_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Ari Ebraham rera aatooro oiso puraroepa, Ari ita, reoreoara toupaiveira voea ruvara-ia, oreoa rigatoiva tuariri rutu Moses ora voeao profet irara. Uva vii voeaaro araoko irara uvuipaai ra evo reoreo sirova utupaave. ");
INSERT INTO roo_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Uva riro monito oiso puraroepa, Viapau aite Ebraham. Viapau oiso evara uvuipai. Ari vo raga osa irai kopiitoa vai tovaa vai iava toreoro voea iare avaro. Oa iava uvuipaai ra sopaura oaive iava porea viro vova vuri vovou. ");
INSERT INTO roo_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Uva va-a vao oa iava Ebraham oiso rera tavireva, Ari ita, vosa viapau Moses ora profet irara viapau vo reoroarore rugoopaave, oire ra apeisi ragavira ita irai oreoiaro oirao pieive, vo rara tova tapi vai iava vorevira vorero voea tavisa?” ");
INSERT INTO roo_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jisas ora rera voeaaro disaipel tavireva oiso, “Oiraopavira rutu, oaravu rutu vo vokio kareke iraopapeira oirara rutu kove piepasa, oiso ra vuri vovouro purapaive. Ari ita, uva siraovira ropa ira oisi vo pitupituro kareke pieparevoi vo vokio oirara kove piepasa. ");
INSERT INTO roo_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Vosa irai oiratoa vai irai raverave vovoutoa vai oirao pie vovouaro vuri piereve voeao iava raverave vovou irara oea ragai-ia raripaaveira, oire uva vearopai oiso ra oeai rera-ia rirova aveke vai tuuive rera okoearo-ia rera roko piesa avakava vuruvuruaro-ia. ");
INSERT INTO roo_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","“Ora vatatopo iraopata. Vosa araokotoa oara vuria purareve, oire rera tarairi. Oire vosa ora rera iava sopaua vorevira porereve vo rara vii vo reoaro uvureve, ra va iava rera iava va vuria verari. ");
INSERT INTO roo_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ari vosa vii-ia voreripavira vuria purareve rirovira vo katai voki-ia, oire ra katakataivira vara rutu isivaaro iava vii iare urioparo oiso purapasa, Ragai iava sopaua pore piroi vova vuria oa puraavo vii-ia. Oire ra va iava uvui iraopauei ra rera iava vara rutu evara vuriara verapari katakataivira.” ");
INSERT INTO roo_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Uva aposel irara Turarore oiso puraaepa, “Igei varaaro oirao pie vovouro riro pieri rutu.” ");
INSERT INTO roo_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Uva Turaro oiso voeare puraroepa, “Eagara ita, vosa visii varaaro oirao pie vovouro oisivi raga toupaive oiso osa mastet kuearo garepa takurarovi rutu, oire ra va iava evare riropa eva oiso purata, Vavurupara rutu iava tate uviro, ra avau vavore avakava sovara-ia. Ra voa ora pauu ita. Oire ra va iava visii gisipoaro sirova utupe ita. Aue iavirava visii varaaro oirao pie vovouro. ");
INSERT INTO roo_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Vosa visii iava irai kovopatoa vai varuparo vai gaaripareve rasia porepaoro, eke sipsip ragui vai tokipareve. Oire ra voava karero viro kepa iare. Ra pasi, rera reitoaaro rerare keeraro oiso, Uriou ikauvira pausa ra aiori? ");
INSERT INTO roo_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Viapau. Ari oiso vaio rera tavireve, Varoa tavario rovori. Ra ragaipa aioara ravaari. Oa iava varava uriou. Ra aio rovoa ora tapo ukaio rovora. Oa iava utupavira aiorivere ukaiooro tapo. ");
INSERT INTO roo_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ra apeisi-a? E rera-ia roru vaisi purareve ro kovopato vo rara rera gisipoaro sirova vearovira utuparo, raa? Ari viapau rutu. ");
INSERT INTO roo_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Oire uva oisi-a eisi osa iava visii tapo uvuipatai vosa orekerovu rutu kovoara opesi pie rovopata oiso osa Pauto visii tavireve, oire ra va iava oiso purata, Igeivi-a viapau vearo irara kovopa irara, ra va iava vearo vaisi ouio reito ruvara-ia. Igoa vo kovo raga purapaioveira. Ari viapau oaiei.” ");
INSERT INTO roo_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Oire uva Jisas vo raivao Jerusalem iare gaeoro avaroepa. Oa iava Sameria-iarei vuruvuruaro-ia vokapaoro avaroepa ora Galili-ia. ");
INSERT INTO roo_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Uva voa ouruivu-ia karero viropa. Oire voava katai tau leprapa irara urioaepa rera iare raivaaro. Uva voava tauaivi torepaaepa ");
INSERT INTO roo_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","keerapaoro oiso, “Jisas, Reito. Igeipa siraou!” ");
INSERT INTO roo_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Oa iava Jisas voa voea vuraoro oiso voeare puraroepa, “Avata ora visii iava varaura karekesa koruou purapa irarapa pris irara.” Oa iava vokapaoro avapaaepa. Uva voa voeare varaura sisigarue ovoiepa. ");
INSERT INTO roo_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Uva voa voea iava iravu ora rera iava varaua kekereva uvare sisigarueepa. Oa iava voreroepa. Uva rirovira Pauto vaisiaro-ia vuurapa vaisi purapareva. ");
INSERT INTO roo_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Uva voa Jisas ruvara-ia kokotoaro rekureva rera-ia vearo vaisi puraoro. Ro Sameria iava rera. ");
INSERT INTO roo_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Uva va-a vao oa kekereva Jisas, oa iava oiso puraroepa, “Eari keaparai oiso katai tau rutu sisigaruei. Uva ovu-ia avaai vo resura vatara? ");
INSERT INTO roo_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Easi pasi, viapau irai voreparoi Pautoa-ia vuurapa vaisi purasa? Ari ita, ro-ia kataitoavi raga uvavu ragava rera ratau touto.” ");
INSERT INTO roo_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Oire uva Jisas oiso rerare puraroepa, “Toreu ra avau. Vii vaaro oirao pie vovou vii ravotovira porete pievoi vorevira.” ");
INSERT INTO roo_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Uva Farisi oiso Jisas akeiva, “Aa vo vuutao-ia Pauto vo Saraaro karekeperea?” Oa iava voea aatooro oiso puraroepa, “Vosa Pauto vo Saraaro karekepere, oire ra oirara viapau oiso va kekeive ora voea osireiaro iava. ");
INSERT INTO roo_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ra viapau irai oiso purarovere, Keketa va vao vo-ia. Eke, Asi va vao-a vavo oiso. Oire uvuta! Pauto vo Saraaro epao visii vuutaaro-ia.” ");
INSERT INTO roo_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Uva va-a vao oa iava Jisas ora rera voeaaro disaipel tavireva oiso, “Easi utupaua oiso ruipa ragapatavere ra ragai Oirato Oviitoaaro kekesa katai vokivi vai raga-ia, osa viapau. ");
INSERT INTO roo_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Oire uva oearovu visii tavitavipaivere oiso, Keketa. Asi ro-a vo-ia toupare. Eke, Varo vavo-ia. Oire ra viapau rutu uvuipata ra voea sirova utupata. ");
INSERT INTO roo_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","E varakeotoa-ia taraipataveira? Ira parakaupareveira voraro ruture vuvuiua-ia roropaoro. Oire uva oisi-a eisi osa ragai Oirato Oviitoaaro pieoro karekeraverea vo oirara rutu osireiaro iare katai vuutavi raga-ia. ");
INSERT INTO roo_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ari ita, riroara vai siitokaara vai kae rovopaa. Oa iava voea vo vuutao iava voea ragaire isivapaavere. ");
INSERT INTO roo_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Vo pitupituro-ia oara puraiva vo Noa vo vuutaaro-ia. Oire uva oisi raga ita eisi osa pieiverea vo ragai Oirato Oviitoaaro vo vuutaaro-ia. ");
INSERT INTO roo_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Uva voea rutu oisoa aiopaive, ora ukaiopaave, ora vearovira raga riako oupaave. Oa iava voa vo rekasisa urioaepa oisi raga piepaoro uva Noa sip uvuo-ia koataroepa vo tuariri rutu. Osa iava rirova pirutuva karekeopa. Uva oirara rutu gisiaepa oira-ia. ");
INSERT INTO roo_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Osa raga ita-a eisi pieiva vo Lot vo vuutaaro-ia tapo voari tuariri. Uva oisoa aiopaive, ora ukaiopaave, ora orekerovu voripaive, ra oearovupa vara sipopaive moni oupasa. Ora aio kovoro paupaave, ora kepa paupaave. ");
INSERT INTO roo_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Oire uva Lot Sodom-ia kavuoro avaroepa. Uva vo voki raga vao oa-ia tuitui kasi karekeepa, oa-ia vitavokovira kovekoveoro vuvuiua iava oiso osa kokeva. Oa iava oirara rutu kopii pieva voa. ");
INSERT INTO roo_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Uva oisi raga ita eisi osa pieiverea vo vokio-ia oa-ia Oirato Oviitoaaro karekeroverea poeravira ragai raga ita. ");
INSERT INTO roo_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Uva vo voki raga-ia ro ira kepa ivara-ia toupareverea, vo osa rera varaaro vo kepa sovara-ia toupaive, ira viapau oiso voava rere rovoreve vara ou rovosa rera varaaro, uvare viapau vuutavi toupaive. Eisi osa ro ira varuparo toupareverea ira viapau oiso voava karero ora rera vo kepaaro iare rera varaaro ousa. ");
INSERT INTO roo_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Vearovira rutu rugoopata Lot vatuavaarore. Iria porepaoro kopii ovoiopa. ");
INSERT INTO roo_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ari vosa ro ira ora rera tootooaro ragare taraapareve kovopaoro, oa taru rera iava opesi ovoipere. Ari vosa ro ira ragai-ia vovoupaoro ora rera iava tootooa eaka ragapareve, ira-ia Oiraopa Tootoo rutu toupaiveira. ");
INSERT INTO roo_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Visii tavipaavoi oiso, Vo voki iava vo rupa-a vao oa-ia aiterei atarapasiverea katai uru vai-ia. Oire ra voava Pauto irai raga oureverea vaiterei iava iravu kavuoro vo osa toupareve. ");
INSERT INTO roo_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ari airei riakorirei vai plaua purapaereverea auere bret, osa Pauto iriavu raga ita oureve vairei iava iriavu arova voa osa toupaeve. ");
INSERT INTO roo_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ari aiterei oiratoarei vai varuparo vai toupasiverea osa Pauto vaiterei iava iravu raga ita oureve iravu arova voa raga osa toupareve.” ");
INSERT INTO roo_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Uva va vao uvuoro oiso puraaepa disaipel, “Turaro, ovu-a vo uva va eva karekeperea?” Oa iava Jisas ruuvira raga voea tavireva oiso, “Ari vo uva okarerovu rutu kopiipaaveira, uva ruega kare ora gurupasa rerepaiveira eru karero aiopasa.” ");
INSERT INTO roo_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Oire uva Jisas oavu reo ruu vatereva voeapa voea tarai piepaoro, oiso ra variripaave vokiara rutu-ia reasi asavira. ");
INSERT INTO roo_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Uva oiso puraroepa, “Ouruivu-ia iravu reo rovirieipato oisoa toupareve ira viapau Pautoa-pa uririparo ora avivikepaoro. Ari viapau oiso ra oirarare vearo vovouparo. ");
INSERT INTO roo_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Uva iriavu raroeva riakova oisoa toupaeve vo urui-ia uvava vatuato kopiiroepa. Oire uva vokiara rutu-ia oisoa uriopao rera ro reo rovirieipato tavipasa oiso, Keripato ragai vuri piesa aueparoi. Oiso ruipaparai ra ragai tauvari va-ia vao-ia kort puraoro torevokovira! ");
INSERT INTO roo_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Uva voari rovovira viapau oiso vovouparoepa ra oira tauvareve rera ro reo rovirieipato. Uva utupavira oiso puraroepa ora rerare, Oiraopavira rutu viapau oiso Pautoa-pa uririparai. Ora tapo viapau oiso oirarare rugorugooparaveira voeapa avivikepaoro. ");
INSERT INTO roo_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ari ita, oira o-ia raroeva ragai pugu pie iraopaeveira. Oire ita, eagara ra oira tauvaa kort puraoro oirapa. Teapi ora voreri vasipao. Ra va iava ragaire varaua reasipe rutu.” ");
INSERT INTO roo_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Oa iava Turaro Jisas voeare oiso puraroepa, “E vo reo vao uvutavoi, oreoa purarevora ro-ia vurito reo rovirieipato, raa? ");
INSERT INTO roo_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Uva apeisi-a voea-ia oirara Pauto oea reesipareveira ora rerapa, oea rerare gaupaiveira arepaoro vo aviaviaro ora vo vokiaro tapo? Oire uva apeisi-a? Ra viapau Pauto voea tauvareve, raa? Ra ateate piepaoro toupareve? ");
INSERT INTO roo_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ari ita, ira uvuipa ra ikauvira voea tauvapareve. Uva va-a eva oare rugoopaoro visii akepaavoi oiso, Ovirovua vao oirara voeao oea goruvira ragai-ia raripaaveira oea perea ovusa vorevira vorera ragai Oirato Oviitoaaro rara?” ");
INSERT INTO roo_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Oearovu oea ora voea raga-ia raripaaveira oiso, Igei torevoko irara, ovusa oeavure oiso purapaave, “Vuri irara voeao.” Oire uva voea-a evoea oeare Jisas oavu reo ruu purareva. ");
INSERT INTO roo_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Uva oiso puraparoepa, “Aitereivu oiratoarei aiterea oiso ruipapasiepa ra varirisi. Oa iava Rovopa Kepa Tempel iare ipasiepa oiso, iravu-a ratarataa vovouto Farisi-pato, ari iravu-a takis oupato. ");
INSERT INTO roo_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Oire uva rera ro Farisi-pato toreroepa ora rera sopaua raga iava oiso variripasa, Pauto, ragai viapau oiso osa oearovu vuri irara voeao oea kavirupaaveira, ora varao tapo kuuvu pitupituro purapaiveira, ora riakorava otopa pitupituro tapo purapaiveira. Ora viapau oiso toupaavoi osa ro-ia takis oupato. Eisi osa iava vii-ia vearo vaisi purapaavoi. ");
INSERT INTO roo_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ari ita, vo wikiara rutu-ia eraeraovira vo vokirei-ia aio kavuparaveira vii ragare rugoopaoro. Uva vara rutu varao oara oupaaveira oara iava katai taupara putepaaveira viipa oavu vatepasa voava. ");
INSERT INTO roo_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Oire ro takis oupato ira tauaiviva toreparoepa reasipaoro vuvuiua vura arapa taraaoro. Ira ora kopukopuaro raga tapatapapareva siraopaoro. Uva oiso puraparoepa, Pauto, ragaivi vurito ragoapa siraou. ");
INSERT INTO roo_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Oire uva visii tavipaavoi oiso, Ro-ia takis oupato ira iava vuriara verareva Pauto. Osa iava rera vaisireva oiso, Torevokoto ro-ia oirato. Oa iava vorevira kareroepa ora rera vo uruiaro iare. Vo ovusa ro Farisi-pato ora rera varaarova vorevira kareroepa, oiso osa raga ita varava vuriara urioroepa. Aue vituaro iava uvare ro ira ora rera raga vaisiaro kae piepareve, ira vaisiaro akaipa pierevere Pauto. Ari ro ira ora rera vaisiaro akaipa piepareve, ira taru vaisiaro kae pierevere utupaua Pauto.” ");
INSERT INTO roo_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Oire uva garepa kakaero sipoiva Jisas iare. Uvare oiso ruipapaaepa ra voea-ia vavaeareiaro tovoreve varirioro. Uva disaipel irara voea tueoro voeare korupaaepa. ");
INSERT INTO roo_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Oa iava Jisas ora rera ruvara iare voeare kakae vure keeraroepa oiso puraoro, “Kakae vure eakata. Ra urioave ragai iare. Opeita voeare korupata. Ari ita, Pauto vo Saraaro oa oiso voea-ia toupaiveira oea oiso purapaa viroveira osa voeao-ia garepa kakaero. ");
INSERT INTO roo_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Oiraopavira rutu visii tavi iraopaavoi oiso, Voeao-ia kakae vure riro rari irara rutu ragai-ia. Vosa irouto viapau oiso vo ruipaaro toupaive osa ro kakaeto ira vaopa ruipaparoveira Pauto vo Saraaro, oire uva rera oirato ira viapau uvuipa oiso ra Pauto vo Saraaro sovara iare koataro.” ");
INSERT INTO roo_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Oire uva iravu Jiu-pato reito oiso rerare puraroepa, “Vearoto Tisato. Eake vai-ia uvuiparai ra oai puraa, ra Tootoo Ovoi oua?” ");
INSERT INTO roo_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Oa iava Jisas oiso rerare puraroepa, “Eakere eisi ragai vaisipari oiso, Vearoto? Vo osa kataitoa raga-a vearoto Pauto. ");
INSERT INTO roo_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ari ita, aue-ia taraipauei vao-ia Reo Taisi Moses vaaro. Oa oiso purapapeira, Opeita otopau. Ora opeita oira upopau. Ora opeita kavirupau. Ora opeita oearovu iava kuuvupau. Aiteara vaiopa ora aakoara tapo avivikepau.” ");
INSERT INTO roo_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Oa iava ro reito oiso puraroepa, “Ari ita, vo osa kakaevira oisoa toupaa, uva va eva Reo Taisi oisoa uvupaa va tokipaoro.” ");
INSERT INTO roo_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Uva Jisas rera vo reoaro uvuoro oiso puraroepa, “Ari oavivu ragapa touvira poteparivoi vao-ia oiso-ia, Auero rutu-ia vii varaaro vori rovouvere vara-ia moni ouoro apotapa irarapa oarai vatesa. Vosa oisi pieri oiso, ra va iava vearoa ouri vuvuiua-ia. Oire ra ragai sirova utuu.” ");
INSERT INTO roo_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Osa vo reo uvuoro vao vovouisi vavatareva rutu rera ro reito. Eake iava? Uvare riro monitoa rutu-a. ");
INSERT INTO roo_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Oa iava Jisas rera-ia vurapaoro oiso puraroepa, “Oiraopavira ita. Voeapa voeao riro kotokoto guru irara vavagisi iraopapeira varaova ora kiu arapa vore Pauto vo Saraaro-ia. ");
INSERT INTO roo_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ari ita, vavagisipai vao tavaatoa iava vo rito, vosa rirova vai vo kare iava kamel kare iriai voa koatasa auepao. Uva oisi rutu rirovira vavagisi iraopai ropa riro moni guruto vore koatapasa Pauto vo Saraaro-ia.” ");
INSERT INTO roo_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Oire uva va vao uvuoro oearovu oiso puraaepa, “Vosa oisi eisi, uva iroutoa vai uvuiparoi ra va eva Tootoo Ovoi oureve?” ");
INSERT INTO roo_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Oa iava Jisas voeare oiso puraroepa, “Ari ita, vao oa viapau purapareve oirato, Pauto oa-ia uvuiparoi ra va purareve.” ");
INSERT INTO roo_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Uva va iava Pita oiso puraroepa rerare, “Uvupari? Igei varaaro uruiara kavuiova vii raga sirova utuoro.” ");
INSERT INTO roo_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Oa iava Jisas oiso voeare puraroepa, “Oiraopavira visii tavi iraopaavoi oiso, Voea rutu oea Pauto vo Saraarore rugoopaoro orekerovu rutu kavupaiveira oiso-ia, kepaara varao, ari vatua riakoro, ari araoko irara, ari aite irara, ari kakae vure voea voeaaro. ");
INSERT INTO roo_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Oeapa riroara rutu vatepare Pauto vo vokio-ia voea varaaro-ia pute pievira. Oire va iava utupavira Opesi Asa Tootoo oupaiverea.” ");
INSERT INTO roo_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Oire uva voea katai tau erao (12) oureva disaipel. Oa iava oiso voeare puraroepa, “Uvuta vao. Vo vokio-ia ipapaviei Jerusalem iare. Oire ra vo reoro rutu oiraope profet irara vo reoroaro oara rigatoiva ragai iava ro Oirato Oviitoaaro. ");
INSERT INTO roo_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Uvare ragai vateivere voeao vavaearo iare osararovu iava voea. Oire ra va iava ragai tovipaive, ora ragai vuri piepaoro ragai-ia ruipaave tapo. ");
INSERT INTO roo_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ra ragai ragipaive ragai kopii piepaoro. Ra vo pevapa voki-ia vorevira torera voava kopii tapi tootoopaoro.” ");
INSERT INTO roo_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Oa iava voeao disaipel viapau oiso vo reo-ia vao aviavipaaepa oreoa ruureva voeare. Uva va-a vao oa iava viapau oiso vearovira taraipaaepa vo reo vituaro-ia. ");
INSERT INTO roo_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Oire uva Jisas Jeriko urui ruvara-ia karero viropa vo uva iravu voosito oisoa raiva vatuaro-ia pauparo. Uva oisoa moni areparo oirara rutu ruvara-ia. ");
INSERT INTO roo_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Uva voava riro irara iava uvureva, ovusa vokapaoro uriopaaepa voare. Oa iava oiso voea akepareva, “Eake purapaivoi?” ");
INSERT INTO roo_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Uva oiso rera taviiva, “Ari Jisas ro vova Nasaret-ia ira vokapaoro vigei-ia puteparevoi.” ");
INSERT INTO roo_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Oa iava rirovira oiso puraroepa, “Jisas! Vii-a Devit aaotoaaro. Ragaivipa siraou!” ");
INSERT INTO roo_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Oire uva irapa irara rerare kasipupaaepa oiso purapaoro, “Auoro! Ora tape pieu.” Ovusa rirovira rutu keera iraoparoepa oisi raga purapaoro oiso, “Vii-a Devit aaotoaaro! Ragaipa siraou.” ");
INSERT INTO roo_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Uva Jisas voari toresa urioroepa. Uva voava voea tavireva oiso, “Voea tavita ra rera sipoive ragai iare.” Uva tutuu pieoro rera iare urioroepa. Oa iava Jisas rera akereva, ");
INSERT INTO roo_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Eake vaipa ruipapau, ra oai puraa viipa?” Uva oiso puraroepa, “Turaro. Oiso ruipaparai ra vuraa.” ");
INSERT INTO roo_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Oa iava Jisas rerare oiso puraroepa, “Vorevira vurari. Uvare vii raga vaaro oirao piea vii vorevira ravotovira porete pie ovoivoi.” ");
INSERT INTO roo_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Oire uva oisi-a eisi osa iava vorevira vurareva. Oa iava Jisas sirova utu ovoiroepa. Uva Pautoa-ia vuurapa vaisi pura ovoireva, osa oirara rutu va vao kekeiva. Oa iava voea rutu Pautoa-ia vuurapa vaisi puraiva. ");
INSERT INTO roo_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jisas Jeriko iare vokapaoro karero viropa. ");
INSERT INTO roo_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Oire uva vo urui eva kavupasa aueroepa, vo osa iravu oirato voa toupareva rera vaisiaro, Sakias rera ro takis oupa irara reitoaaro. Uva rera-a riro monito. ");
INSERT INTO roo_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Uva oiso ruipaparoepa ra Jisas-ia tarairo oiso, Iroutoa rutu-a? Ari viapau oiso uvuiparoepa ra rera kekereve, uvare riro irara rutu Jisas utopaiva. Uvare ita potekuto-a rera Sakias. ");
INSERT INTO roo_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Oa iava ikauvira iparoepa oevaovu-ia riro ova, uvare oiso rugooparoepa ra Jisas kekereve rutu. Ari ita, oiso taraiparoepa, Vo raivao-ia vokapaoro uriorovere Jisas. ");
INSERT INTO roo_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Oire uva Jisas voavi pouro viropa. Uva voa vo viara-ia vurareva. Oa iava oiso puraroepa rerare, “Sakias. Ikauvira varau evoava. Ari vo vokio-ia vii vo kepaaro-ia toupaa.” ");
INSERT INTO roo_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Uva oisi-a eisi osa iava ikauvira vararoepa, uvare rera iava sopaua rirovira rutu roruva. Oa iava rera tapo Jisas avaroepa ora rera vo kepaaro iare. ");
INSERT INTO roo_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Oire uva oirara rutu va vao kekeoro aveavevira reoreopaaepa oiso purapaoro, “Uva apeisi vurito vo kepaaro-ia koataro rera tapo tousa?” ");
INSERT INTO roo_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ari toreroepa rera Sakias oiso purasa, “Reito. Oiso ruipaparai ra ora ragai varaaro rutu roo piea oiso, oavu voeaopa apota irara. Ora varao tapo kare piea oara oisoa ou ragapaa kuuvuvira oearovu ruvara-ia katakataivira. Uva voeapa oiso vara kare piepaavere iravu vaaro rekasiaro-ia oresuravu tovoa rerapa pute pievira.” ");
INSERT INTO roo_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Oire uva Jisas rerare oiso puraroepa, “Vo vokio-ia Pauto voeao oea vo kepa-ia toupaiveira oea vorerevoi ora rerapa vova vuriara oaive iava. Ari ita, uvare vii tapo-a iravu Ebraham aaotoaaro. ");
INSERT INTO roo_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ragai-a vao Oirato Oviitoaaro ragoa oirara ousa urioraera voeao oea opesikoaepa, ra va iava voea vorevira vorea Pautoa-re.” ");
INSERT INTO roo_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Oire uva vo reo-a vao oa uvuivoiva, oavu reo ruu vatereva voeapa. Eake iava? Uvare tutuu piereva Jerusalem iare. Vo osa oiso keapaaepa, Vo voki raga-ia Pauto vo Saraaro roroiovira ora karekepai. ");
INSERT INTO roo_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Oa iava oiso puraroepa, “Iravu reito ira oiso ruipaparoepa ra tauai ruture avaro, oisore ra voa rera king pieive. Ra va iava vorevira karero. ");
INSERT INTO roo_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Uva katai taure kovopa irara keeraroepa rera voeaaro. Oa iava voeapa katakataivira erao tau kina (K20) vatereva. Uva oiso voea tavireva, Vao-ia sara kovoro vai puratavere vore tuepaoro uva vorevira voreravere. ");
INSERT INTO roo_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Vo osa rera vo uruiaro iava voea rerare vuri vovoupaaepa. Oa iava voea arova avaroepa. Uva voeao rera iavapa irara oearovu aruiva ora voea raga iava rera sirova utupasa. Oa iava oiso purasa utuaepa, Igei reasipaiei ra ro igeipa kingparo turaropaoro. ");
INSERT INTO roo_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Oire rera king pieivoiva, voava vorevira voreroepa vore rera vo uruiaro-ia. Oa iava oiso puraroepa, Oirarare keerata voeao oeapa moniara vateavora. Aue iava keeraparai voeare uvare oiso ruipaparai ra taraira oiso, Aa voviro kareke pieivora katakataivira vara rutu iava moniara. ");
INSERT INTO roo_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Oire uva iravu iraroepa oiso purasa, Reito, vii vaaro-ia monia sara kovo puraavora aue rutu erao tau kina (K20). Oa iava va-ia pute piea ouavora aue rutu erao vovoto kina (K200) rutu. ");
INSERT INTO roo_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Uva va iava king oiso rera tavireva, Vii vearotoa rutu kovopato. Viigoa vearovira gareparavi-ia vurapariveira vara vearovira rutu tokipaoro. Oire uva va-a eva oa iava vii vatepaavoi oavu reesia. Ra va iava katai tau rutu tokipari aue riropa uruiro (10 taun). ");
INSERT INTO roo_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Oire uva erao pieto ita rera iare pouro viropa oiso purasa, Reito, vii vaaro-ia erao tau kina sara kovo puraavorao. Oa iava aue katai vovoto kina (K100) pute piea ouavorao va-ia ita. ");
INSERT INTO roo_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Osa iava king oiso rera tavireva, Vii tovopaavoi, ra vo vavae tokipari riropa uruiro (5 taun). ");
INSERT INTO roo_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Oire uva iravu ita kovopato rera iare pouro viropa. Oa iava rerare oiso puraroepa, Reito, vii vaaro-a vao erao tau kina vo-ia. Oa ruuava aue-ia varoa va oriruoro. Oa iava vo toupaiveira. ");
INSERT INTO roo_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Eake iava? Uvare vii-ia oisoa taraipara, Riro kasivaritoa rutu varao ou ragapaoro oara tovopaivora oearovu. Ora varao aioara oara paupaiveira oearovu raga, oara tapo tatepariveira vii raga. Eisi osa iava viipa oisoa uriripara varao moniara kovo pie arapa. ");
INSERT INTO roo_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Oa iava rera ro king rerare kovopato oiso puraroepa, Vii vurito kovopato. Viigoa iava gasipaavoi vii raga vo reoaro-ia. Ari ita, ragai-ia oiraopavira oisoa taraipau oiso, Riro kasivarito ragai varao ou ragapaaveira oara tovopaivora oearovu raga. Ora varao tapo tatepaaveira oara paupaiveira oearovu raga. ");
INSERT INTO roo_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ari apeisi iava viapau va vao ragai vaaro moni tovo asariva beng-ia? Oa iava voreraeri voava va ousa aue tapo pute piea vai interes. ");
INSERT INTO roo_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Oire uva oiso puraroepa voeaore oea tutuu pievira rera ruvara-ia toupaiva. Vao outa eva erao tau kina. Ra eera vateta ira erao vovoto kinava touparevoi. ");
INSERT INTO roo_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Oa iava oiso rerare puraaepa, Reito. Easi rerapa erao vovoto kina pura piroi. ");
INSERT INTO roo_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Uva oiso puraroepa, Oiraopavira rutu oiso visii tavipaavoi, Oirara rutu oea oisi vara-ia pitupaivoi, uva voeapa ita oarai vatereverea Pauto pute pievira. Ari vosa viapau oisi oai-ia pitupareve irai, oire ra gareavi raga-ia pitupareve, eva-a oa verareverea rera ruvara iava Pauto. ");
INSERT INTO roo_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ari evoea oea oiso purapaaveira ragaire, Reasipaiei rerapa oiso ra igeipa kingparo turaropaoro. Oire uva voea evoea ragaiva keripa irara. Uva voeava uriota vore ragai osireiaro-ia voea uposa.” ");
INSERT INTO roo_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Oire uva Jisas vo reo vao purareva. Oa iava vokapaoro iraroepa vo raivao gaepaoro oa-ia oisoa Jerusalem iare ipapaave. ");
INSERT INTO roo_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Oa iava Betfasi urui ruvara-ia pouro viropa vo uruirei ora Betani-ia vo pukuio-ia oa oisoa vaisipaive oiso, Oliv Kovo Pukui. Oire uva voava aitereivu disaipeltoarei ira piereva vo uruiri iare oa oiso oisiriva pute pievira vo pukuio-ia toupaive. ");
INSERT INTO roo_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Uva oiso vaiterei reesireesireva, “Vo uruiri iare irasi, ra vo urui-ia kareu virosi. Oire ra voa gareva kekesivere donki, osa variaua riara-ia toupaeve, iria-ia viapau oisoa irai pauparo voari tuariri uvare koruova. Oire ra voava oira karuoro oirava voresivere. ");
INSERT INTO roo_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Vosa irai vei akepareve oiso, Eakere eira donki karupasi? Oire ra oiso ragavira irai tavisi, Iria-ia Turaro vo kovoaroei.” ");
INSERT INTO roo_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Oire uva Jisas vaiterei arureva. Oa iava avasiepa. Uva oisi vara rutu kekesiva oiso osa vaiterei tavireva. ");
INSERT INTO roo_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Uva oira iava iroiro karupasiva o-ia donki. Oa iava voea-a voeao oea oiraaro-a oea oiso vaiterei akeiva, “Eakere eira koruova donki karupasivoi?” ");
INSERT INTO roo_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Uva va-a vao oa iava oiso voea tavisiva, “Iria-ia Turaro vaaroei kovoa.” ");
INSERT INTO roo_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Uva oirava koruova donki voresiepa rera iare Jisas. Uva vaiterei varaaro varoara tovosiva oira ivara-ia. Uva vara ivara-ia Jisas pau piesiva. ");
INSERT INTO roo_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Uva oira ivara-ia paupaoro avaroepa, ovusa voea rutu oirara varoara-ia uruiva parakavira raivaaro vo raiva oritopasa. ");
INSERT INTO roo_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Oire uva voava tutuu pieoro avaroepa vo raivao-ia vova varapaoro Oliv Kovo Pukui iava. Oa iava riro irara rera voeaaro disaipel irara rovoaepa rorupaoro. Uvare varao ruture rugooaepa ravotoara oara oisoa kekepaive, vorara vara purapareve. Oa iava rirovira rutu raga pieiva Pautoa-ia vuurapa vaisi puraoro. ");
INSERT INTO roo_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Oiso purapaoro kaku piepaiva, “Reito king vaisiaro rei piepe. Ira urioroi Turaro Pauto vaisiaro-ia. Uvare Pautoa iava sopaua vearoi vigeipa oirara, uvare kasipua opesiei. Oire ra Pauto vaisiaro rei piepe ro oiso vuvuiua-ia viara-ia rutu.” ");
INSERT INTO roo_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Oire uva oearovu ratarataa vovou irara Farisi iava voava vo uvuru vao sovara-ia toupaiva, oea Jisas-re oiso purapaaepa, “Tisato! Evoea disaipel tapetaperi vii voeaaro. Opeita eisi piepaive.” ");
INSERT INTO roo_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Oa iava voeare oiso puraroepa, “Ari ita, visii tavipaavoi oiso, Vosa voea varaaro gisipoara tuupaive, oire ra varao avekeara raga kaku piepaive vuurapa vaisi puraoro.” ");
INSERT INTO roo_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Oire uva tutuu piereva Jisas voare vo Jerusalem urui-ia. Oa iava vo urui kekeoro siraovira gaureva ");
INSERT INTO roo_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","oiso puraoro, “Vosa vo vokio raga-ia vao-ia vo pitupituo-ia vearovira taraitai oa oiso toupai, Visiipa gavaure vovou vatepai, ra va iava vearota. Ari ita, vo vokio-ia opitupitua vao vataupai. Ra viapau va keketa. ");
INSERT INTO roo_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Uvuta! Vo utupaua uva ovuutavu karekeperea oa-ia visii voeaaro keripa irara uutuva purasa urioaverea, o ora upopava visii ururao visii kovokovooro voraro rutu. ");
INSERT INTO roo_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Oire uva visii kepikepiiverea visii vuri pieoro rutu. Vii urui ora ovii irara oara voeao oea epao vii urui sovara-ia oea toupai. Uva viapau oiso vii iava iriai aveke vai eakaiverea, oiso ra iriai toupaeve vo iriai ivara-ia ita. Eake iava? Uvare viapau vo vuutao eveitavoi oa-ia Pauto urioroi visii tauva ragasa visii oriruoro.” ");
INSERT INTO roo_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Uva Rovopa Kepa-ia Tugoropa Kepa Tempel koataroepa. Oa iava rovoroepa voava voea sigupaoro, ovusa sara kovoro purapaiva voa Tempel sovara-ia. ");
INSERT INTO roo_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Uva oiso voeare puraroepa, “Tugoropa Vuku oiso purapai, ‘Ragai vo kepaaro eakata eva oa oiso toupai Variripa Kepa ragai vaaro.’ Oa oiso rutu piepatavoi, ‘Vataupa tapi uva visii vao kavirupa irara vataupaaveira sara kovoro oavisii purapaoro.’” ");
INSERT INTO roo_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Oire uva vokiara rutu-ia voea tarai piepaoro voa toureva vo kepa sovara-ia vao Tempel. Oa iava voeao reipa irara pris ora voeao tarai irara aue-ia Reo Taisi, ora voeao tapo oirara rutu reipa irara oea rerare raiva taraapaaepa, oiso ra oai iava rera upoive. ");
INSERT INTO roo_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Vo osa oirara rutu goru iraopaaepa rera vo reoaro uvupaoro. Oire uva oisi-a eisi osa iava voeao reipa irara viapau oiso uvuipaaepa oiso ra oraivai kekeive rera uposa. ");
INSERT INTO roo_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ovokivu-ia Jisas voea siposipopareva Rovopa Kepa Tempel Tugoropa Kepa sovara-ia Vearo Siposipo-ia. Uva voea reipa irara koruou purapa irara pris ora voeao Reo Taisi-ia tarai irara, ora voeao tuvetuvepa irara Jiu iava oea urioaepa rera iare Jisas. ");
INSERT INTO roo_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Oa iava rerare oiso puraaepa, “Igei taviri oiso, Eake reesi-a vao oa iava varao kovoara purapariveira? Uva irou-a vao oa vii vateva vo reesi eva?” ");
INSERT INTO roo_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Oa iava voea aatooro oiso puraroepa, “Ari ita, uva ragai tapo ita visii akepaavoi oreovu iava, ra ragai tavita. ");
INSERT INTO roo_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Irouto-a ro ira Jon vatereva vo kovo oa iavirava oirara baptaisreva, Pauto eke oirara raga?” ");
INSERT INTO roo_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Oire uva voea raga ora reopaaepa oiso purapaoro, “Vosa oiso puravio, Pauto ruvara iava va, ra ita oiso puraro, Uva apeisi viapau va oirao piepata? ");
INSERT INTO roo_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ari vosa oiso puravio, Ari oiratoa raga vaaro, oire ra oirara rutu va iava vigei vurokoive aue-ia aveke voeao oea goruvira rutu Jon oirao piepaiveira oiso purapaoro, Profetato Jon.” ");
INSERT INTO roo_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Oire uva oisi-a oiso osa iava rera vo reoaro aatooro oiso puraaepa, “Viapau oiso igei eva-ia Jon vo baptaisaro taraipaiei oiso, Ovu iava karekeepa.” ");
INSERT INTO roo_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Oa iava Jisas voeare oiso puraroepa, “Ragai tapo ita viapau uvuiparai ra visii tavia vo reesi iava oa iava vo kovo purapavora.” ");
INSERT INTO roo_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Uva oisi-a oiso osa puraroiva, voeapa reo ruu vatereva oiso puraoro, “Iravu oirato ira wain kovo paureva. Oa iava vo kovo-ia kovopa irara tovoreva, oiso ra vo kovo-ia sara kovo puraive. Vo osa rera ouruivu iare avaroepa tauai rutu voa toupasa. ");
INSERT INTO roo_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Oire uva aio oupa vuuta-ia vo kovo iava iravu kovopato rera reraaro arureva voea iare voeao oea oisoa vo kovo-ia kovopaive vao wain kovo. Uvare oiso ruipaparoepa ra rera vateive oarai aioara vai vo kovo iava. Vo ovusa voeao oea oisoa vo kovo-ia kovopaive rera ro upopaoro viapavira rera siguiva vorevira. ");
INSERT INTO roo_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Oa iava iravu ita kovopato voea iare arureva reito. Oire uva rera upooro rera vuri pieiva. Oa iava oisi raga akukuvira rera sigu ragaiva ita. ");
INSERT INTO roo_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Oa iava vo peva piepato arureva voea iare. Uva rera upooro rera kosi pieiva rera-ia vikioro rataure. ");
INSERT INTO roo_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Osa iava rera ro ira vo kovoaro-a oiso vovouparoepa, Eake vai puraa? Oire ra ro ragai oviitoaaro rutu arua ira kavikopaaveira rutu. Ira vai-ia taru gisipoaro uvuivere. ");
INSERT INTO roo_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Oa iava voeao oea oisoa vo kovo-ia kovopaive rera tueiva. Uva voea raga ora reopaaepa oiso, Rera-a ro ira utupaua auero rutu varao aiteto varaaro oureverea. Avoeao! Rera upope. Ra va iava vigei raga vo kovo-ia pitupere. ");
INSERT INTO roo_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Osa iava vo kovo iava rera kosi pieoro rera-ia vikiaepa rataure vo wain kovo vatuaro-ia rera kopii pieoro. Oire uva ro ira vo kovoaro-a wain kovo, eake vai purareverea voea-ia? ");
INSERT INTO roo_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ira uriorovere taru voea kopii piesa voeao oea oisoa vo kovo-ia kovopaive vao wain kovo. Oire ra va iava oearoi raga vatereve vo kovo.” Uva vo siposipo uvuiva oa purareva Jisas. Oa iava oiso puraaepa, “Ae! Teapi eisi vai piereverea.” ");
INSERT INTO roo_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Oa iava Jisas voeava vurapaoro oiso puraroepa, “Eake-a vo reo vituaro vao oa toupai Tugoropa Vuku-ia? ‘O-ia aveke kovopa irara iria veraiva, iria oiso karekeopa o aveke rovopava rutu kepa iava kukuuvuva.’ ");
INSERT INTO roo_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Oirara rutu oisoa o-ia aveke ivara-ia kovepaave ora tarita ovoipaoro. Ari vosa oira o aveke irai ivara-ia koveoverea, oire ra irai tarita ovoieve garepa visivi oiso rutu osa poupou.” ");
INSERT INTO roo_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Oire uva voea voeao Reo Taisi-ia tarai irara ora reipa irara pris oiso taraiaepa, Easi Jisas vigei togaparevoi vao-ia reo ruu. Uva va-a eva oa iava oiso vovoupaaepa ra voa raga rera-ia pitu ovoiive. Uva oirara ragapa uriripaaepa rera-ia pitu arapa. ");
INSERT INTO roo_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Oire uva rera siituepaiva. Oa iava oeavu tagorovira aruiva rera iare. Uva kuuvuvira oisoa torevoko pitupitu pura ragapaive rera ruvara-ia, vo osa rera siituepaiva. Uvare oiso rugoopaaepa ra ora rera raga vo reoaro-ia rera iava gasiive auepa reito gavman. Ra gavman vavaearo-ia rera tovoive. ");
INSERT INTO roo_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Oisi-a eisi osa rerare oiso puraaepa, “Tisato, vii vo reoaro-a torevokoa oa vatepariveira oirara rutupa. Uvare viapau oiso rei vaisi irarapa uriripauveira. Viapau. Ari vaeavira rutu oirara rutu tarai piepariveira Pauto vo pitupituaro-ia. Oa uvupaiveira oiso purapasa, Oiraopavira rutu! ");
INSERT INTO roo_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Uva apeisi vai vovoupauei vao-ia vigei vaaro Reo Taisi? E torevokopai ra Sisa-pa takispaviei?” ");
INSERT INTO roo_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Vo osa Jisas vo kuuvu-ia tarairoepa va eveioro. Oa iava oiso puraroepa voea tavioro, ");
INSERT INTO roo_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Oire oa-ia monia vai ragai kareke pieta. Vao oa-ia irou puaaro toupai? Ora irou vaisiaro toupai vo va varaaro-ia?” Uva oiso puraaepa, “Ari King Sisa!” ");
INSERT INTO roo_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Oa iava Jisas oiso puraroepa, “Oire rera vaaro Sisa oa rera vateta Sisa. Ari vao Pauto vaaro, oire ra Pauto vateta va.” ");
INSERT INTO roo_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Oire uva va-a eva oa iava viapau oiso rera rauiva vao-ia rera vo reoaro vo oirara osireiaro-ia. Oa iava rirovira rutu rugorugoo iraopaaepa vo reo-ia vao oa pukoreva voeare. Osa iava ora tape pieaepa rutu. ");
INSERT INTO roo_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Oire uva Sadyusi-pa irara iava oeavu urioaepa rera iare Jisas oea oisoa oiso purapaave, “Voeao kopii irara, viapau uvuipaai ra vorevira torepaave.” ");
INSERT INTO roo_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Oa iava rerare oiso puraaepa, “Tisa, Moses oreovu rigatoreva vigeipa oiso, Vosa iravu kakae pura asavira kopiiro riakovapa, oire ra araokoto oira ita oureve. Oire ra rerapa ro kopiito oira-ia kakaeto purareve araokoto. Eisi osa toupai Reo Taisi. ");
INSERT INTO roo_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Uva oeavu erao vatara rutu (7) oaraovu oea oisoa toupaive. Uva avaioto vo arao iava riakova oureva. Oire uva kakae kavau asavira kopiiroepa oira arova. ");
INSERT INTO roo_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Uva kikooto ita oira oureva o-ia riakova. ");
INSERT INTO roo_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Oire uva vo pevapato ita oisi raga oira oureva ita. Uva oisi raga-a eisi osa vo arao rutu voeao oira oisoa oupaive. Oa iava kakae kavau asavira raga oira arova vo arao rutu oisoa kopiipaave. ");
INSERT INTO roo_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Uva vo arao isivaaro iava utupavira kopiiopa. ");
INSERT INTO roo_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Oire uva vo vokio-ia oa-ia kopii irara oiso vorevira toreaverea, uva iroutoapa oira perea o-ia? Ari ita, vo arao voeao erao vatara (7) oea oisoa oira oupaive. Oa iava voea rutu vatuavaaro-a.” ");
INSERT INTO roo_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Oa iava Jisas voeare oiso puraroepa, “Voea-ia oirara ora riakora vo vokio iava, voea-a oea ora oupaaveira. ");
INSERT INTO roo_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ari voeao oirara Pauto oeare oiso puraroverea, Uvuipatai ra vorevira tootoota toreoro, voeao oea viapau oiso ora oupaaverea. ");
INSERT INTO roo_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Oea viapau uvuipaai ra kopiiave ita. Oea oiso raga ita toupaiverea oiso osa purapurapa irara ensel, vo rara Pauto voea vorevira tore piereve kopii tapi iava. Oire ra oiso toupaive rera ovii iraraaro Pauto. ");
INSERT INTO roo_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ari ita, Moses tapo roroio pievira rutu vigei tavireva oiso, Kopii irara vorevira torepaaverea kopii tapi iava, vo siposipo oa-ia gare kairi evaoa rovaepa. Oa-ia ita oiso puraroepa Pauto, Ragai-a Pautoaaro Ebraham, ora Pautoaaro Aisak, ora Pautoaaro Jekop. Voeao oea urauraaro tootoovira toupaiverea. ");
INSERT INTO roo_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ari ita, viapau oiso kopii irara reraaro-a Pauto. Viapau. Ari voeao reraaro oea tootoopaai rutu vo rera osireiaro-ia.” ");
INSERT INTO roo_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Oire uva oisi-a eisi osa puraroiva, oearovu riro tarai irara iava Reo Taisi-ia oiso puraaepa, “Tisato. Vearovira rutu eisi osa reouei.” ");
INSERT INTO roo_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Oire uva va-a vao oa iava uriripaaepa vorevira Jisas ake arapa. ");
INSERT INTO roo_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Oire uva oiso voea akereva, “Apeisi iava oiso purapataveira, Asi Krais Devit aaotoaaro ro vo rasio raga iava? ");
INSERT INTO roo_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Uvare vao-ia Sam Vuku Devit raga voari tuariri oiso puraroepa Krais iava, ‘Turaro Pauto rore ragai reraaro Turaro oiso puraroepa, Vova pauu ragai vaaro-ia oirapapa varata ");
INSERT INTO roo_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","vo tugurasa uva voeao viiva keripa irara tovoaverea taru vii kokotoaro reroaaro.’ ");
INSERT INTO roo_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Oire uva rera raga Devit turarovira Krais vaisireva. Uva apeisi ragavira ita oiso purapataveira, Krais Devit aaotoaaro, ira Devit sirova kavauroepa?” ");
INSERT INTO roo_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Oirara rutu touvira toupaiva Jisas vo reoaro uvupaoro. Oa iava disaipelre oiso puraroepa, ");
INSERT INTO roo_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Vearovira rutu Reo Taisi-ia tarai irarava siitueta. Evoea riro oiso ruipa irara, ra riro kaekaepa kuvuparo-ia kuvupaave oritopaoro. Ra varava vokapaive. Evoea oea rirovira oiso ruipapaaveira ra voeava oirara oiso purapaave avivikepaoro, Vearo voki, voraro uupa tapiro. Ora oiso tapo ruipapaaveira ra rovopa tavuki-ia paupaave vo Reo Taisi Uvupa Keparo sovara-ia. Ora riro varaopa ruipa irara rovopara paupara vo vurei aiopa vokiro-ia. ");
INSERT INTO roo_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Oea vo riakoro vo keparoaro-ia koatapaaveira vairo varaaro ou ragapasa vairo keakeapaoro raroe riakora. Oire ra vo pitupituro vataupaoro riro kaekaepa variriro purapaive. Uva oisi-a eisi osa iava voea vaaro voria riroa rutu ouiverea siitoka vavata.” ");
INSERT INTO roo_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Oire uva Jisas voeava vurapareva vo Rovopa Kepa Tugoropa Kepa sovara-ia toupaoro, ovusa voa sirao vate vikipaiva bokis-ia moni tovopaoro o Pauto oiraaro. ");
INSERT INTO roo_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Oa iava iriavu apotava raroeva tuereva Jisas, ovusa gare isirei-ia vikiopa moni isirei bokis iare. ");
INSERT INTO roo_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Uva va-a vao oa iava Jisas oiso puraroepa, “Oiraopavira visiire oiso puraparai, O-ia apotapava raroeva iria gare isireivi vikievoi ora oira iava sopaua rutu tapo, oa-ia oearovu rutu-ia puteevoi. ");
INSERT INTO roo_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Osa voeao oea riroara moniara toupaivoi oara iava oaravu-ia sirao vate viki ragapaivoi Pautoa-pa. Ovusa o apota iraopaoi rutu. Oa iava ora oira vaaro rutu viki ovoievoi moni-ia. Uva viapau oai ora oirapa aio voripasa.” ");
INSERT INTO roo_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Uva oeavu oirara ora reopaaepa Rovopa Kepa-ia Tempel oiso, uvare vo kepa oritoiva vearopara-ia avekeara ora varao sirao vatero oara oisoa vatepaive Pautoa-pa. Oa iava Jisas oiso puraroepa, ");
INSERT INTO roo_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Vara-a oara kekepatavoi. Ari vo vuutao-ia vao oa urioperea, ra viapau iriai aveke vai eakave iriai ivara-ia aveke vai osa toupaive. Oara rutu evara kururu piroverea koveoro. Vo osa vara rutu-ia vikiavere voraro voeao keripa irara.” ");
INSERT INTO roo_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Uva rera akeiva oiso puraoro, “Tisa, aa vo vuutao-a oa-ia va vao vuria karekeperea? Uva eake iava va reesiioverea, ra va iava oiso va eveiio, O, ari va-a vao oa karekesa tutuuvoi?” ");
INSERT INTO roo_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Oa iava Jisas oiso puraroepa voeare, “Voeaopa ora vatatopo iraopata vearovira. Teapi visii keaive. Riro irara rutu uriopaaverea ragai vaisiaro-ia ora vaisipaoro, oiso purapaaverea, Ragai raga-a vao-ia Krais. Uva oiso tapo purapaaverea, Vo vuuta-a vao-ia oa tutuu pievoi. Oire ra viapau oiso voea sirova utupata. ");
INSERT INTO roo_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ari ita, utupaua uva riroara iava tatuara upoara uvutaverea taru. Oire ra viapau oiso rikerikepata uriripaoro. Oara-a evara kareke rovoperea, ovusa Ovoiopa Voki kareke asavira touve.” ");
INSERT INTO roo_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Uva oiso voea tavireva, “Osaravu oa osaravu tapo ora upoaverea. Ovusa iravu king voeaaro iravu king voeaaro tapo ora upoaverea. ");
INSERT INTO roo_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Uva riroara aue ravurikeara karekeperea vo rasitoa-ia, ovusa uvarovu rirovira ogoepaave. Ora riroara upiara karekeperea, ovusa vuvuiua-ia riroara reesiara keketaverea ora osasararovu rutu, varao oara visii uriri pieverea ora karekepaoro. ");
INSERT INTO roo_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Oire uva vara-a varao oara ora kareke asavira toupaiverea, ovusa visii ragai voeaaro visiigoa oiso raupaive visii vuri piepasa. Ora tapo visii iava gasipaiverea Reo Taisi Uvupa Keparo sovara-ia visii rovirieipasa kortua-ia. Oa iava visii tovopaiverea tuukepa keparo-ia. Aue iava uvare oiso vovoupaaverea ra ragai vaisiaro akaipa piepaive eisi piepaoro. Ora king irara puaaro iare visii sipopaiverea ora gavman irara oisore ra ragai iava siposipopata. ");
INSERT INTO roo_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Oire uva va-a vao visii vo raivaaro vao iava Vearo Siposipo tavitavipaoro. ");
INSERT INTO roo_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Uva oisi-a eisi osa iava uvui iraopatai ra rugorugooara oavisii rukupata. Auepa teapi oraivaroi vatatopo rovopata ravaavira, oa-ia voea aatotaverea reoreoara oavisii-ia. ");
INSERT INTO roo_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ari ita, ragai raga visii gisipoaro-ia reoparaverea visiipa vearoa taraia vatepaoro. Oire ra voeao oea visiiva keripaave, viapau oiso uvuipaave ra visiiva ora kaureopaave vo reo-ia vakupaoro vao oa vatepaa visiipa. ");
INSERT INTO roo_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Ora voeao tapo aite irara oavisii, ora aako riakoro oavisii tapo, ora araoko irara, ora taataa riakoro oea tapo visii tovopaiverea vo visiiva keripa irara vavaearo-ia. Oire ra visii iava oearoi upopaiverea. ");
INSERT INTO roo_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ora oirara rutu tapo oea visiire vuri vovou iraopaaverea. Eake iava? Uvare ragai vaisiaro toupaverea visii-ia. ");
INSERT INTO roo_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ari ita, ra viapau oiso visii kukuearo iava ouai orua vai opesiko ragape, vo rara virivarivira toupataverea Pauto vavaearo-ia. ");
INSERT INTO roo_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Goruvira rutu toupataverea. Ra va iava visii vaaro Oiraopa Tootooro outaverea vorevira. ");
INSERT INTO roo_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Ari ita, vo utupaua uva viurupa irara keketaverea, ovusa Jerusalem-ia kovokovoiverea. Oire ra va iava vo vuuta eveita oiso, Uruia vuri piepa vuuta vao-ia oa tutuu pievoi. ");
INSERT INTO roo_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Uva vo voki-a vao oa-ia Judia-ia tou irara uriri iraopaaverea, ra toriiverea pukuiara iare. Ovusa voeao oea Jerusalem urui sovara-ia toupaiveira oea uvui iraopaai ra va kavuiverea uvai ragare avaoro. Ovusa voeao oea vo urui vatuaro-ia toupaiveira viapau oiso uvuipaai ra karea viro vo urui sovara iare. ");
INSERT INTO roo_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Uvare vo voki-a eva oa-ia Pauto vuriara vorevira kare piereverea. Oire ra oisi iava vo reo oa epao Tugoropa Vuku-ia oiraope rutu. ");
INSERT INTO roo_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Uva siraovira rutu-a vairopa taruko riakovi, ora vairopa tapo airoa sikeo kakaero roro piepaiverea vo vuuta-ia eva. Ari ita, riroa rutu siraoa oa vo rasio-ia karekeperea. Uva va-a eva Pauto vo kasipuaro oa voea-ia voeao oirara karekeperea. ");
INSERT INTO roo_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Uva aue-ia toorioara voea toepaiverea. Ra va iava keripa irara voea tuukeive. Oire voava voea ouoro voeava avaave osararovu sovara iare. Ra voa toupaive, ovusa osararovu raga iava Jerusalem-ia tasive vo urui upooro. Oire ra oisi raga toupaive vo vuutao rutu-ia rekasisa, oa-ia oearovu vova ratau tou irara iava oea osararovu iava opesiaverea. ");
INSERT INTO roo_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Uva oaravu rutu reesiara karekeperea taru aue-ia ravireo ora kekira ora aaviikoara. Ora vo rasitoa-ia uva oirara rutu vovouaro vuriaverea rutu uririoro auepa toruva gurukoaro uvuoro, ovusa pokoo viro avakava-ia. ");
INSERT INTO roo_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Oirara rutu varao iava rirovira rugorugoopaaverea oara vo rasio-ia karekeperea. Oire ra va iava voeare vovouisiro rirovira uriri iraopape rutu. Ra avavaraopaoro osireiara iava kovepaaverea. Eake iava? Uvare aaviikoara ora tavariopaoro vuvuiua-ia rikerikepaperea. ");
INSERT INTO roo_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Vosa va vao karekeperea, oire uva ragai Oirato Oviitoaaro tueiverea oirara rutu, ovusa iriavu rukuta sovara-ia uriora riroa rutuva gorua ora riroa ragai vaaro keraria. ");
INSERT INTO roo_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Oire uva vara-a evara oara rovopaperea karekepaoro. Uva vo vuuta-a eva oa-ia toretaverea ora visii iava torevokovira kukueara kae pieoro taraasa. Uvare vo vuuta-a eva Pauto vaaro visii vorevira ousa, oa pou virosa tutuu piepai.” ");
INSERT INTO roo_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Oire uva va-a vao oa iava oavu reo ruu vatereva Jisas voeapa. Oa-ia oiso puraroepa, “Fik ova kekepataveira ora oevarovu tapo. ");
INSERT INTO roo_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Oire vosa vo evao keketa ovusa aruapaive airepa guruvaro purapaoro, oire ra va iava taraita oiso, Raipipa vuuta tutuu piepai oa-ia ravireo rororovere. ");
INSERT INTO roo_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Eisi raga ita-a oiso osa vara keketaverea varao ovusa karekepape. Oire ra vara iava vearovira taraita oiso, Pauto vo vuutaaro tutuu pievoi. Vao oa-ia ora rera voeaaro vorevira ouparevoi rara ora rerapa voea tokipasa. ");
INSERT INTO roo_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Oiraopavira rutu oiso osa visii tavipaavoi, Oirara rutu voeao vo vuutao iava oea kopii asavira toupaiverea, ovusa vara evara karekeperea. ");
INSERT INTO roo_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Vuvuiua ora rasito oara rutu opesiperea, vo osa ragai vo reoaro viapau rutu oiso opesipe. ");
INSERT INTO roo_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Ari ita, vearovira rutu uutupata. Teapi aio ragapata vo vokiara rutu-ia spak ragapaoro. Ora viapau oiso ra varao ragare rugorugoopata tapo varaura vo ruiparoaro. Uvare vo pitupituro-a evara oara uvuipai ra visii vuri piepaive. Ovusa vao Turaro vo vokiaro ravotovira raga visii iare pou piro. Oiso rutu osa kuverava atari kare-ia poupa viroveira voea kuverapaoro sita pievira. ");
INSERT INTO roo_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Oire uva vo voki-a vao oa voeao oirara rutu kuveraverea vo oea rasitoa rutu-ia toupaiveira voea-ia vakoravira pou virooro. ");
INSERT INTO roo_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Vuutara rutu-ia vokiara rutu-ia uutupata toupaoro Pautoa iare variripaoro, ra visii vatepareve gorua. Oire ra va iava vara rutupa varao oara virivaripata oara visii-ia karekepaperea. Ora vo osa tapo vo utupavira uva ragai ruvara-ia toretaverea vo ragai osireiaro-ia.” ");
INSERT INTO roo_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Vokiara rutu-ia Jisas oisoa oirara rutu siposipopareve voea tarai piepaoro vo Tempel-ia. Oire uva vokiaro pukuia-ia oisoa toupasa vorevira kareparo vao oa vaisipaiveira oiso, Oliv Kovo Pukui. ");
INSERT INTO roo_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Uva oirara rutu oisoa vokipaua rutu torepaoro rera iare uriopaave rera vo reoaro uvupasa Tugoropa Kepa-ia, vo osa voea siposipopareve. ");
INSERT INTO roo_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Oire uva vo voki-a vao tutuu pieva oa-ia Jiu-pa irara bret-ia aioive vao oa-ia viapau yisa vai. Vo vokiore oisoa rugorugoopaave oa-ia Pauto Isip iava Isrel-pa irara oureva voea oriruoro. Ovokia-a vao oa oiso vaisipaive oiso Tagausapa Pasova Ovapa Vurei. ");
INSERT INTO roo_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Uva voea reipa irara voeao iava koruou purapa irara pris, ora voeao riro tarai irara Reo Taisi-ia oea rutu rirovira uriripaaepa oirara asavira. Oa iava oiso puraaepa, “Apeisi vai ragavira rera upopai rara ro-ia Jisas?” ");
INSERT INTO roo_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Oire uva va-a vao oa iava Seten Judas sopaaro-ia ora kiuroepa. Ro ira oisoa vaisipaive oiso, Iskariot. Voea iava katai tau erao (12) disaipel rera. ");
INSERT INTO roo_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Oire uva voea tapo reipa irara ora reoroepa pris ora reipa irara voeao oea Rovopa Kepa-ia Tempel oisoa uutupaave. Oea rutu ruvara-ia raiva taraaroepa Jisas kosi piesa voea vavaearo iare. ");
INSERT INTO roo_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Osa iava rirovira rutu rorupaiva. Oire uva oavu reoa goruiva rerapa moni vatesa. ");
INSERT INTO roo_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Osa iava Judas voea vo reoaro aatoreva oiso puraoro, “Vearopai.” Uva va-a vao oa iava ora rerapa raiva taraaroepa rera kosi piesa Jisas voea vavaearo iare. Oa iava oiso aueparoepa ra arakasi vuuta vai kekereve vao oa-ia viapau oirara vai Jisas tapo toupaive. ");
INSERT INTO roo_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Vao Tugoropa Voki Yis Asa Bret vo vokiaro oa karekeepa. Oire uva vo vokia-a vao oa-ia oisoa sipsip vai kopii pieive koruova vai aue iare Tagausapa Vurei Pasova. ");
INSERT INTO roo_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Osa iava Jisas Pita vaio arureva ora Jon oiso puraoro, “Irapasiei ragaipa Pasova Vurei vatatoposa ravaavira ra va aiope.” ");
INSERT INTO roo_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Oa iava oiso rera akesiva, “Ovu-ia vo aio ravaaveare?” ");
INSERT INTO roo_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Uva oiso vaiterei tavireva, “Uvusi. Jerusalem-ia kare uvirosivere. Oire iravu veiva aivarorevere raivaaro. Ira uuko ovi kaeparevere rirova-ia pitokava. Ra rera sirova utusi vo kepa-ia koatasa oa-ia koatasa kareparovere. ");
INSERT INTO roo_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Oire uva rera-a ro ira vo kepaaro-a tavi rovosivere rerare oiso puraoro, Tisa oiso puraroi, Ovu-ia ragai vo tugiaro epao tavete tugi oa-ia ragai voeaaro tapo disaipel Pasova Vurei aiopaavere? ");
INSERT INTO roo_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Oa iava vei tavirevere oiso, Otugivu-a vao riroa oa epao oiso viara-ia. Oa-ia aue epao tebolara ora paupara. Oire ra vo tugi-ia Pasova Vurei ravaasi.” ");
INSERT INTO roo_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Uva va-a vao oa iava avasiepa. Oire uva oisi va kekesiva oiso osa Jisas taviroepa. Osa iava Pasova Vurei ravaasiva voa. ");
INSERT INTO roo_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Oire uva vo vuuta-a vao oa pou piropa, oa iava Jisas tebol-ia pauroepa. Uva voea aposel irara rera tapo voa pau ovoiaepa. ");
INSERT INTO roo_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Uva voa oiso voea tavireva, “Oiso ruipa iraoparai ra visii tapo vao Pasova Vurei aio rovopaavoi, uvare utupavira riroa siraoa oupaavoi rara. ");
INSERT INTO roo_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Uva visii tavipaavoi oiso, Viapau vorerivira Pasova aioavere ita vo rutu rekasisa uva va vao oiraopere rutu Pauto vo Saraaro sovara-ia.” ");
INSERT INTO roo_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Oire uva kap oureva. Oa iava oira-ia okarovu puraoro va-ia vearo vaisi purareva Pautoa-ia. Oa iava oiso puraroepa, “Vao outa, ra va roo pieta ora visiipa. ");
INSERT INTO roo_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Uvare oiraopavira visii tavipaavoi oiso, Vo vokio ora vo utupaua uva viapau wain kuearo-ia ukaioraverea vo rutu tugurasa uva Pauto vo Saraaro karekeperea.” ");
INSERT INTO roo_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Oa iava bret oureva va-ia vearo vaisi purasa Pautoa-ia. Uva va puteputeoro voeapa va vatepaoro oiso puraroepa, “Vao-ia ragai iava varaua. Oa vatepaavoi visii tauvapasa. Oa iava ragaire rugoopataverea.” ");
INSERT INTO roo_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Oire uva va aioivoiva ita, oisi raga piereva aue-ia wain karo kap-ia ouoro. Oava oiso puraroepa, “Eva airepa agiagi Pauto vaaro o-ia revasiva ragai iava. Iria petoavoi visii tauvasa. ");
INSERT INTO roo_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Ari! Rera kekepata ro-ia ira vavaearo ragai vate ruipaparoi voeao vavaearo iare ragaiva keripa irara. Ro-ia ira ragai tapo touparevoi vo-ia tebol. ");
INSERT INTO roo_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Iu. Ragai Oirato Oviitoaaro vo raivao sirova uturavere Pauto oa reesireva ragaipa. Ari ita, uva siraovira rutu rerapa ro ira ragai kosi piepare rara voeaopa ragaiva ora keripa irara.” ");
INSERT INTO roo_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Osa-a eisi osa iava voea raga ora akeakepaaepa oiso puraoro, “Iroutoa rutu-a vigei iava ira vo pitupitu vao puraparevoi?” ");
INSERT INTO roo_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Oire uva voea disaipel ora kaureopaaepa ora reopaoro. Uva oiso purapaaepa, “Iroutoa vai vigei iava reiparoi?” ");
INSERT INTO roo_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Oa iava voeare oiso puraroepa Jisas, “King irara osararovu voeaaro oiso toupaiveira reipa irara voea voeaaro. Oa iava voeao oea-ia gorua toupaiveira voea oirara oaive voeao tokipaiveira. Oea oiso ora vaisipaaveira oiso, Vigei vearo pitupitu purapa irara oirarapa. ");
INSERT INTO roo_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ari viapau uvuipatai ra oisi piepata oiso. Viapau. Ari vosa ro ira visiipa oiso reiparo, ira oiso viovoko visivi visii reroarovi toupareve. Ari ro ira visiipa reiparo, ira oiso tou iraopareve visii kovopatoaaro visii tauvapaoro. ");
INSERT INTO roo_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Irouto-a reito? E pasi ro-a ira aioa-ia pauparoi? E pasi kovopato rerapa aio tovoparoi sipopaoro? Eera ro ira aioa-ia pauparoi, eera raga ita. Ari ita, ragai visii vuruvuruaro-ia toupaavoi oiso, Kovopato visii tauvapaoro. ");
INSERT INTO roo_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Voari tuariri uva orekerovu karekepaera ragai-ia varao tavaka vovouro. Oara ragaipa riroara vavatara vatepaivora, vo osa ragai tapo toupatavora. Uva viapau ragai kavupatavora. ");
INSERT INTO roo_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ari ita, Aite ragai reesireva oiso ra oirara rutupa reipaoro voea tokipaa. Eisi raga ita osa visiipa vo reesi vateaverea. ");
INSERT INTO roo_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Oiso ra tokia vao ragai vaaro oa-ia aiotaverea ora ukaiotaverea vo ragai reraaro-ia tebol. Uva oiraopavira king varaaro-ia paupara paupataverea. Oa iava voa toupaoro oiso toupataverea, Reo rovirieipa irara visii vigeipa Isrel katai tau erao (12) sararo Jiu-pa irara. ");
INSERT INTO roo_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Auoro Saimon, Saimon uvuri! Seten visiire arereva oiso ra visii roporoporeve voeao raverave vovou irara veraveraoro. Oiso osa wit rogetaaro veraverapaiveira oira aioaro ariarava. ");
INSERT INTO roo_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ari ita, vii tauvapaoro varirirai, oiso ra vii vaaro oirao pie vovou viapau raveravepape. Ra va iava ora poreuverea vorevira voreoro ragaire. Oa iava araoko irara oara goru pieriverea rutu.” ");
INSERT INTO roo_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Oa iava Pita rerare oiso puraroepa, “Turaro. Easi vatatoporai, oiso ra vii tapo tuukea iare avara. Ora oiso tapo ra vii tapo kopiira.” ");
INSERT INTO roo_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Uva Jisas Pita-re oiso puraroepa, “Vo rupao-ia vo osa kookai gau asavira touparevere, ovusa vo peva purari oiso purapaoro, Viapau taraiparai eera-ia Jisas.” ");
INSERT INTO roo_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Oa iava Jisas voea rutu tavireva oiso, “Voari tuariri uva visii sipoava. Uva viapau auero vai kaeoro avataepa moni bokisro vai, ora ogataara vai, ora tasipara vai, ora toorioara vai. Uva vo vuuta-a eva oa-ia oaravu avu vaipa apotataepa, eke viapau?” Oa iava oiso puraaepa, “Viapau.” ");
INSERT INTO roo_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Oire Jisas oiso voeare puraroepa, “Ari ita, irouto vo vokio-ia moni bokis vaiva toupareve, oire ra vava avaro aue tapo ogata. Ora aue tapo toorio vai. Ari vosa viapau iraipe ira ruvara-ia, oire ra kuvupatoa vai-ia monia vai ou rovoreve ora rerapa irai toorio vai vorisa oa-ia. ");
INSERT INTO roo_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Eake iava? Uvare Tugoropa Vuku oiso puraepa, ‘Rera tapo takuvuiverea vuri pitupituro purapa irara tapo.’ Oire uva oiso visii tavipaavoi ra vo reo eva oiraope rutu vao oa karekeepa ragai iava. Ari ita, vo reoro rutu varao Tugoropa Vuku oara purava ragai iava, evara-a oara oiraosa auepai rutu.” ");
INSERT INTO roo_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Uva disaipel irara rerare oiso puraaepa, “Turaro. Kekepari? Easi igei ruvara-ia vaiterei-ia vaitereo toorio vaio vo-ia.” Oa iava voeare oiso puraroepa, “Ovoiei.” ");
INSERT INTO roo_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Oire uva Jisas riro urui kavuoro avaroepa Oliv Kovo Pukui iare oiso osa raga oisoa piepareve vokiara rutu-ia. Oire uva disaipel irara rera sirova utuaepa voare. ");
INSERT INTO roo_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Oa iava voa pou viro ovoioro oiso voea tavireva, “Variripatai. Ra va iava varao kokarapara viapau visii-ia poupa piro visii kove piepaoro.” ");
INSERT INTO roo_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Oa iava voea arova gare visivi avaroepa. Uva voavi kokoto rekuroepa varirisa oiso puraoro, ");
INSERT INTO roo_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Aite. Vosa ruipapau ra ragai iava o kap verari iria agasioi rutu aue iava siraoa vo vavataaro. Uva viapau uvuipau ra ragai vo ruipaaro sirova utuu. Viapau. Ari vii raga vo ruipaaro sirova utuu.” ");
INSERT INTO roo_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Uva va-a vao oa iava iravu ensel vuvuiua iava vararoepa rera goru piesa. ");
INSERT INTO roo_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Oire uva riroa siraoa sovoreva Jisas ora rera-ia. Oa iava goruvira rutu variriroepa. Uva rirovira rutu pupuraki iraoroepa oiso osa revasiva iria kosikosio viropa rera iava rasiua arore kovekovepaoro. ");
INSERT INTO roo_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Uva variri opesiroiva, rera voeaaro iare voreroepa disaipel. Oa iava voea kekereva, ovusa uusipaaepa. Uvare rirovira siraopaaepa, oa iava rurapaiva. ");
INSERT INTO roo_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Osa iava voea erao piepaoro oiso puraroepa voeare, “Eakere uusipatai? Toreta ra varirita. Teapi kokarapa vovouro visii iare uriope visii kove piesa.” ");
INSERT INTO roo_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Oire uva Jisas touvira raga reoreoparoepa, ovusa riro irara rutu urioaepa. Uva rera ro Judas voeao raga iava aposel irara ira voeapa iraroepa. Oa iava Jisas iare tutuu piereva rerava uugaasa. ");
INSERT INTO roo_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Uva Jisas oiso puraroepa rerare, “Judas. E Oirato Oviitoaarova uugaapauei, oiso ra keripa irarapa rera kosi pieri, eke?” ");
INSERT INTO roo_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Oire uva voeao disaipel irara oea Jisas tapo toupaiva, oea voea kekeoro voea-ia taraiaepa oiso, Asi vo vuuta-a vao oa-ia karekepai vao vuria. Oa iava oiso puraaepa, “Turaro, oiso ruipapaiei ra voeao upoio vara-ia toorioara, eke?” ");
INSERT INTO roo_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Oire uva va-a vao oa iava iravu voea iava Rovopato Pristo kovopatoaaro uvareoaro toereva rera pakooro oisova oirapapa varata-ia. Oa iava voava koveepa. ");
INSERT INTO roo_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Uva Jisas rera kekeoro oiso puraroepa, “Ae! Vo pitupituo eakari!” Oa iava rera kokiaro-ia vavaea tovoreva rera iava uvareoua vore pieoro. Osa iava rera iava vorevira vearoepa. ");
INSERT INTO roo_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Oire uva Jisas voea voeao reipa irara pris irarare vo reoro purapareva, ora voeao Tempel-ia uutupa irarapa reipa irara, ora voeao Jiu-pa irara oira vasi irara oea rutu urioaepa rera rausa. Uva voeare oiso puraroepa, “E toorioarava uriotai ora kakuara, eke? Oire uva oiso pai rutu visiipa, Kavirupatoa vai ira tuukesa uriotai varava evara, raa? ");
INSERT INTO roo_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ari ita, vokiara rutu-ia oisoa visii tapo toupaa vo Tempel-ia. Uva eakepa oisoa voa ragai-ia pitu asapata? Eagara! Va purata. Uvare vo vuuta vao-ia visii vaaro oa-ia rupa vovou vo goruaro riropai rutu.” ");
INSERT INTO roo_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Oire uva oisi-a oiso osa reoroiva, rera-ia pituiva. Oa iava rerava avaaepa. Uva rera koata pieiva Rovopato Pristo vo kepaaro-ia. Uva Pita rera sirova uturoepa. Oa iava voa rerapa tauaivi toureva. ");
INSERT INTO roo_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Uva voa vo kepa kasuraaro sovara-ia tuitui kasi puraiva. Oa iava vo kasi-ia tuituipaoro paupaaepa. Oire uva voa-a evoa uva Pita voea tapo pauparoepa. ");
INSERT INTO roo_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Uva iriavu kovopava rera kekeeva, ovusa pauparoepa tuituipaoro. Oa iava tuupavira rerava vurapaoro oiso puraopa, “Easi ro tapo oisoa Jisas toupareve.” ");
INSERT INTO roo_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Vo osa Pita oiso puraroepa ora taeaoro, “Auoo, viapau eera-ia taraiparai irare purauei.” ");
INSERT INTO roo_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Oire uva va ita isivaaro iava iravu ita rera kekereva. Oa iava oiso puraroepa, “Auoro! Vii tapo iravu voea iava.” Oa iava Pita oiso puraroepa, “Easi ragai viapau.” ");
INSERT INTO roo_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Oire uva katai vuuta putevoiva, va isivaaro iava iravu ita rirovira oiso puraroepa, “Oiraopavira. Ari rera tapo eera oisoa tapo toupareve. Rera ro-ia Galili iava.” ");
INSERT INTO roo_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Vo osa Pita oiso puraroepa, “Auoro! Viapau evo reo-ia taraiparai oa purapari.” Oire uva oisi raga oiso puraparoepa Pita, osa ikauvira kookai gau ovoireva. ");
INSERT INTO roo_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Uva Turaro Jisas ora poreroepa Pita-va tuupavira vurasa. Oa iava Pita vo reore rugooroepa oa purareva rerare Turaro oiso puraoro, “Vo rupao-ia kookai gau asavira touparevere, ovusa vo peva purari oiso purapaoro, Viapau taraiparai eera-ia Jisas.” ");
INSERT INTO roo_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Uva va-a vao oa iava Pita atoarova kosiro viropa rataure. Oa iava voa rirovira rutu gau iraoreva siraopaoro. ");
INSERT INTO roo_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Oire Jisas rauivoiva, rera tovipaiva rera upopaoro. ");
INSERT INTO roo_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Uva rera iava osireito tavuruiva varoa-ia. Oa iava oiso puraaepa rerare, “Oire profet reo purari. Irouto vii taparevoi? Uvare ora vaisipauveira, Profetato-a ragai.” ");
INSERT INTO roo_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Oa iava rera-ia oreorovu rutu takau reoro purapaiva rera-ia. ");
INSERT INTO roo_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ravireo kaero viropa ovusa reipa irara Isrel iava ora guruaepa, ora voeao tapo riro tarai irara Reo Taisi-ia. Oa iava ora voea voeaaro iare Kaunsel irara rerava Jisas avaaepa. Uva oiso puraaepa, ");
INSERT INTO roo_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Igei taviri. Vii-a Krais viigoa roporeva Pauto, eke?” Oa iava oiso puraroepa, “Vosa visii tavia, ra viapau va oirao pieta. ");
INSERT INTO roo_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ora vosa visii akepaa oarai iava reoara vai, ra viapau ita ragai vo reoaro pukopata. ");
INSERT INTO roo_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ari vo vokio ora vo utupaua taru, uva Oirato Oviitoaaro oirapapa varata-ia pauparoverea vao Pauto vaaro vo uva riroa gorua toupaiveira.” ");
INSERT INTO roo_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Oa iava voea rutu oiso puraaepa, “O! Ari vii raga-a vao Pauto Oviitoaaro, raa?” Uva oiso puraroepa, “Ari ita, oiraopavira eisi osa ragai vaisipata oiso, Ragai raga ita vao-ia.” ");
INSERT INTO roo_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Oire uva oiso puraaepa, “Avoeao! Ra eake vaisi vai uvupe vuri vaisi vai rera ruvara-ia. Uvare ora rera gisipoaro-ia vo reo purarevoi oreoa uvuei ita.” ");
INSERT INTO roo_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Oire uva voea rutu rerava avaaepa Pailat iare. ");
INSERT INTO roo_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Oa iava voa rovoaepa rera iava gasioro. Uva oiso puraaepa, “Rera-a ro-ia ira kekeiovora vo osa igei sara iraraaro piro pieparevora. Uva igeire tapo koruroera Sisa-pa takis vate arapa. Ari ita, ora vaisiparoveira oiso puraoro, Ragai raga-a Krais. Ragai king.” ");
INSERT INTO roo_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Oire uva Pailat rera akereva oiso, “E vii-a Jiu reraaro king, raa?” Oa iava Pailat aatooro oiso puraroepa, “Vii raga ita eisi purauei.” ");
INSERT INTO roo_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Uva va-a vao oa iava Pailat reipa irara pris irara ora Jiu-pa tuvetuvepa irara oearea rutu tavioro oiso puraroepa, “Viapau oiso oavu avu vai vuria vai kekeavoi ro-ia Jisas.” ");
INSERT INTO roo_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Oa iava goruvira oiso puraaepa, “Ae! Ira-a eera vurivira oirara rutu sita piepareveira voea siposipopaoro vo Judia taere-ia. Uva Galili iava rovoroepa evo pitupitu raga purapaoro. Oa iava vo rutu pouro virorao va raga purapaoro vo ruture.” ");
INSERT INTO roo_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Oire uva Pailat va uru pieparevoiva, voea akereva oiso, “Esa rera ro-ia Galili taere iava, raa?” ");
INSERT INTO roo_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Oa iava rera taviiva vo osa rera-ia Jisas taraiparoepa oiso, Vo rasio iava rera orasia oisoa tokipareve rera King Herot. Osa iava Pailat rera iare Herot Jisas siporeva, vo osa Jerusalem-ia toupareva. ");
INSERT INTO roo_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Oire uva Herot rera kekereva Jisas. Oa iava rirovira rorupareva. Uvare tuariri rutu oisoa rera iava uvupareve. Oa iava oisoa rera keke ruipaparo rutu. Oire uva oiso ruipaparoepa ra Jisas oai purareve ravotoa vai, ra oai kekereve. ");
INSERT INTO roo_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Uva oisi-a oiso osa iava Herot rera akepareva orekerovu ruture riroara. Vo osa Jisas viapau rerapa oreoi pukopareva vara iava. ");
INSERT INTO roo_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Oa iava reipa irara pris ora voeao tarai irara Reo Taisi-ia oearea rutu vovio rera ruvara-ia toresa urioaepa uvavi-ia rera rovirieipaiva. Uva va iava goruvira rutu rera togapaoro rera iava gasipaiva. ");
INSERT INTO roo_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Osa iava Herot ora rera voeaaro viurupa irara oea rutu Jisas akaipa piepaiva. Ora rera tovipaiva tapo. Osa iava iravu vearoto kuvuto ouiva rera-ia rera kuvusa. Oa iava rera vore pieiva aue iare Pailat. ");
INSERT INTO roo_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ari ita, voari tuariri uva oisoa Herot Pailat tapo ora keriparo. Uva vo vuutao raga-ia ora agiagisiepa. ");
INSERT INTO roo_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Oire uva Pailat reipa irarare pris keeraroepa, ora Jiu voeaaro tuvetuvepa irara tapo, ora voeao rutu oirara. Uva ora gurusa urioaepa. ");
INSERT INTO roo_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Oa iava voeare oiso puraroepa Pailat, “E rova uriotai ragai iare, oa iava oiso puratai, Ira-a ro oirara rutu vo pitupituroaro piro piereva? Uva rera akeavo vo visii osireiaro-ia torevokovira. Oire uvuta! Viapau oavu avu vai vuria vai kekea rera-ia ro-ia vao oa iava rera iava gasitavoi. ");
INSERT INTO roo_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Oiso osa raga ita aue Herot ira rera vore pierevorao vore vigei iare, uvare viapau vuria vai kekerevora rera-ia ro-ia. Oire uvuta! Ro viapau oiso oavu avu vai vuria vai purarevora, ra oai iava rera kopii piepe. ");
INSERT INTO roo_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Uva voeaopa rera vate rovopaavoi, ra rera ragiive. Oa iava rera iava vaseavere rara.  ");
INSERT INTO roo_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Oire uva oiso toupaiveira vo pitupituo Tagausapa Vurei Pasova vo pitupituaro. Ra va-ia Pailat iravu kosi piereve tuukepa kepa iava voea iare. ");
INSERT INTO roo_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Oa-a vao oa vituaro iava voea rutu oirara rirovira kaku pieoro raga pieiva oiso purapaoro, “Rera kopii pieoro Barabas iava vaseri tuukepa kepa iava igei iare!” ");
INSERT INTO roo_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ari ita, Barabas ira oavu upoa kosi piereva gavmanva vo riro urui sovara-ia. Uva oirato tapo kopii piereva. Oa-a eva oa iava rera tovoiva tuukepa kepa-ia. ");
INSERT INTO roo_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Oire uva Pailat voeare ita reoa purareva ita. Uvare Jisas iava vasesa aueparoepa. ");
INSERT INTO roo_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Oa iava kaku pieoro ita oiso puraaepa, “Rera tapari evao parikou-ia!” ");
INSERT INTO roo_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Oa iava ita vo peva pie vuuta-ia vorevira voea ita akereva oiso, “Eakepa? Ro oirato Jisas, aa vao vuri pitupitu purarevora? Viapau oiso rera-ia vuria vai kekeavoi, ra oai iava rera kopii piepe. Uva va-a vao oa iava oiso ruipaparai ra ragai voeaaropa rera vate rovoa, ra rera ragi rovoive. Ra rera iava vasea.” ");
INSERT INTO roo_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Vo ovusa rirovira rutu goru iraopaaepa. Oa iava goruvira rutu voea rutu raga piepaoro rerare oiso puraaepa, “Rera tapari evao parikou-ia!” Osa iava voea vo reoaro uvuparevoiva Pailat, goruvira vorevoreripavira rera iava vasereva. ");
INSERT INTO roo_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Uva va-a eva oa iava Pailat reo goru purareva voea vo ruipaaro sirova utuoro. ");
INSERT INTO roo_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Uva ro-ia riro kaureoto gavmanva ora upo purapato ira tovoiva tuukea-ia, ira arepaiva oirara, oiso ra rera vore piereve Pailat vorevira voeapa. Osa iava Pailat Barabas iava vasereva voeapa voea vo ruipaaro sirova utuoro. Ari rera Jisas tovoreva keripa irara vavaearo-ia. ");
INSERT INTO roo_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Oire uva rerava Jisas avaaepa. Uva iravu-ia oirato pituiva aue Saimon, aue iava rera Sairini urui. Uvare rerava aivaroiva ovusa riro urui-ia kare uvirosa aueparoepa. Oa iava rera vutuoaro-ia evao parikou tovoiva vao Jisas oa kaepareva. Oa iava vava rera sirova uturoepa. ");
INSERT INTO roo_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ovusa riro irara rera sirova utupaaepa. Riro riako tapo airoa rerapa gau eraro-ia gaupaoro utupaaepa rerapa siraopaoro. ");
INSERT INTO roo_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Oa iava Jisas vairore oiso purasa ora poreroepa, “Avairo Jerusalem iava. Opeita gaupata ragaipa. Easi vearopai ra ora visiipa gaupata ora voearopa visii ovii iraraaro tapo. ");
INSERT INTO roo_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Uvuta! Vo utupavira uva ovuutavu urioperea uva oiso puraaverea, Vairo riako, ora vairo kavau asa riako, ora vairo airoa viapau kakae vure roro piepaiva, airoa rutu roruive, uvare viapau ovii irara vai epao siraoa vo vavataaro oupasa. ");
INSERT INTO roo_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Vo vuutao-ia oa-ia oiso puraaverea pukuiarare, Igei rakuoro koveta. Ora varaore garepa pukuirovi tapo oiso puraaverea, Igei tavuruoro koveta. ");
INSERT INTO roo_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Aue iava uvare vosa vo vokio-ia oiso ragai piepaivoi osa vo evao oa-ia uuko ovi toupaivoi, oire ari eake vai puraive vao-ia erako ova?” Ro Jisas ira oiso toupare osa eva ova vo eva-ia uuko ovi toupai vearoa. Uva erako ova oa oiso toupaivoi vao erako ova osa voeao vuri irara vova Jerusalem-ia. ");
INSERT INTO roo_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Oire uva Jisas oiso puraroiva, rerava avaaepa ora aitereivu tapo vaitereo aiterea oisoa vuri pitupituro rutu purapasi. Uvare oiso vovoupaaepa ra vaiterei tapo rera upoive Jisas. ");
INSERT INTO roo_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Uva va-a vao oa iava uvavu poua viropa va vaisiaro, Kukue Keru Pukui-ia opukuia-a vao oa-ia rera tapaiva evao parikou-ia. Oire uva evaiterei tapo tapaiva voa oiso-ia, Iravu oisova oirapapa varata vao Jisas, ari iravu oisova koike varata. ");
INSERT INTO roo_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Oire uva Jisas oiso puraroepa, “Aite! Voeao iava vuriara verari. Oea viapau va-ia taraipaai vao oa puraivoi ragai-ia.” Uva kuvupara-ia satu visiko purapaiva vara roo piepaoro ora voeapa. ");
INSERT INTO roo_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Vo ovusa oirara rutu voeava vurapaiva. Ari voeao tuvetuvepa irara Jiu iava oea oiso puraaepa, “Ari oearovu raga oisoa tauvapari. Oire vosa vii oiraopatoa rutu Ropoto Krais Pauto reraaro, oire uva va iava vii raga uvuipau ra ora tauvau.” ");
INSERT INTO roo_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Uva voa voea tapo viurupa irara rera tovipaoro putepaiva. Oa iava rera vateiva aue viniga itakopa ovi ");
INSERT INTO roo_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","oiso purapaoro, “Vosa vii Juda kingaro rutu, oire ra ora vii raga ora tauvau.” ");
INSERT INTO roo_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Oire uva oavu rigatoa rera kukuearovi-ia toupaiva. Oa oiso purapaepa, JISAS KING OAIVE JIU. ");
INSERT INTO roo_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Uva vaitereo aiterea tapo rera kotoiva aiterea iava iravu rerare oiso puraroepa rera tovipaoro Jisas, “E vii-a Krais, raa? Oire vii raga ora tauvapaoro vigei rutu tapo tauvari.” ");
INSERT INTO roo_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ovusa iravu vaiterei iava rera uvuoro kasipuoro oiso puraroepa, “Easi vii tapo evo siitoka ourivoi, oiso osa reraei. E viapau Pautoa-pa uriripauei, raa? ");
INSERT INTO roo_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Vegei tapo torevokovira vo siitoka ouvevoi oa torevokopai vegei vo pitupituroarova. Ari ro-ia ira viapau vuria vai purareva.” ");
INSERT INTO roo_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Oa iava oiso puraroepa, “Jisas. Vosa turarouvere, uva evo vuuta-ia ragaivire rugoouvere.” ");
INSERT INTO roo_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Uva Jisas oiso rerare puraroepa, “Oiraopavira rutu vii tavipaavoi oiso, Vo vokio-ia ragai tapo tourivoi vo Peradais-ia vo roru oupa tapi.” ");
INSERT INTO roo_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Oire uva ravireo vuuta uvuiaro rutu-ia kopiiroepa. Oa iava ravireo utoroiva, rasitoa rutu-ia rupaepa vo rutu tugurasa vo peva vuuta-ia (3 klok) ovaiaro. ");
INSERT INTO roo_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Vo osa va vao varoua oua oisoa Rovopa Kepa-ia Tempel kotovira toupaive vo rataoa-ia touua Pauto vo topisiaro iava, oa ariarava oua vuritavira rutu kari piropa, oiso ra oirara rutu Pauto ruvara iare tutuu pieive. ");
INSERT INTO roo_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Uva Jisas rirovira rutu oiveoro keeraoro oiso puraroepa, “Aite! Ragai vii vavaearo-ia urauratoa oaa tovoavoi.” Uva oisi-a oiso osa pura ovoioro vovouisi vikireva kopii ovoioro. ");
INSERT INTO roo_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Oire uva va-a vao oa kekereva ro viurupa irara reitoaaro. Oa iava Pauto vaisiaro kae piereva rera-ia vuurapa vaisi puraoro. Oiso puraroepa, “Oiraopatoa rutu ro-ia, torevokoto Jisas.” ");
INSERT INTO roo_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Osa-a eisi osa voea rutu oirara voeao oea urioaepa siituesa oea vara rutu varao kekeiva oara karekeepa. Oa iava ora voea iava kopukopuara tapatapapaoro kareaepa sirao iraopaoro. ");
INSERT INTO roo_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Vo osa rera Jisas vate iraraaro tauaivi toko pievira torepaaepa, voeao oea Galili rutu iava utuaepa rera sirova. Airorovu tapo riakora airoa vara rutu varao siitueiva. ");
INSERT INTO roo_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Oire uva iravu oirato voa toreparoepa. Rera vaisiaro, Josep eera Juda vo uruiaro iava vao oa oisoa vaisipaive oiso, Arimatia uvava rera-a vearoto torevoko vovouto eera. Reipa irara iava rera-a Kaunsel irara voea vo Jiu. Ari ita, ira ro viapau oiso voeao Kaunsel irara vo vovouaro sirova utuparo vao Jisas kopii piepa vovou. Ari oisoa Pauto vo Saraarore rugooparo vare tuepaoro. ");
INSERT INTO roo_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ira-a ro ira Pailat iare avaroepa Jisas kopii aresa rera ruvara-ia. ");
INSERT INTO roo_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Oire uva va-a vao oa iava vo kopii rere piereva rera tavurusa popotepaua-ia varoua. Oa iava rera tovoreva oavu-ia tova urui. Uva voa-a vo uva rikui tekaiva ravaavira aveke-ia rirova voari tuariri uva oirara-ia viapau oisoa irai tovapaive. ");
INSERT INTO roo_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Oire uva vo voki-a vao orekerovu ravaapa voki aue iare Sabat voki oa-ia Josep vao purareva. Oa iava Sabat vokipa tutuu pieva oiso ra karekepe. ");
INSERT INTO roo_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Oa iava vairo riakora Jisas sirova utuaepa Galili rutu iava, airoa Josep sirova ita utuaepa voare vo tova siituesa oiso, Apeisi avu ragavira rera tovaparevoi? Oire uva va-a eva oa tapo kekeiva. ");
INSERT INTO roo_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Uva rera siitueivoiva, vorevira kareaepa ora vairo vo uruiaro iare. Oa iava voa korovo oviro ravaasa kareaepa varao vearopa geesi oviro. Oire uva Sabat voki-ia reareaaepa oiso osa oisoa purapape Reo Taisi. ");
INSERT INTO roo_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Oire uva rovo voki rutu-a vao wik vituaro iava, ovokia-ia avaaepa tova iare vo ovirova varao riro geesi oviro aue korovo oara ravaa rovoiva. ");
INSERT INTO roo_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Uva avekere vura ragaiva iria pekaiva vo tova riaaro iare. Oa iava viapau vo tova-ia toupaeva. ");
INSERT INTO roo_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Uva va-a eva oa iava voa koataaepa. Oire uva voa viapau rera iava varaua kekeiva Turaro Jisas. ");
INSERT INTO roo_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Oa iava rirovira rugorugoo iraopaoro vavagisipaaepa rutu. Uva voa aitereivu oiratoarei kekeiva, ovusa voavi ruvara-ia torepasiepa. Aiterea iava kuvupara rutu sisikorepaiva. ");
INSERT INTO roo_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Oa iava rirovira rutu uririaepa vo riako vairo. Oire uva takua viropa rasiua arore. Vo ovusa vaiterei oiso vairore purasiepa, “Eake-a vao oare rore taraapatai ro tootooto vova kopii irara voaro? ");
INSERT INTO roo_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Viapau oiso vo touparevoi. Ira vorevira toreroe. Ari ita, vo reore rugoo iraota oa vaterevora visiipa vo osa Galili-ia touparevora. ");
INSERT INTO roo_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Vo uva oiso puraroepa, Ragai vatepaivoi rara vuri irara keripa irara vavaearo iare. Ra ragai tapaive evao parikou-ia rara. Oire uva vo pevapa voki-ia toreravere vorevira.” ");
INSERT INTO roo_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Oiso osa iava vo reore rugooaepa Jisas oa purarevora. ");
INSERT INTO roo_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Oire uva tova tavukiaro kavuoro vorevira kareaepa katai tau katai (11) disaipel tavisa ora oearovu rutu. ");
INSERT INTO roo_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Oiso Maria o Makdala iava, ari aue Joana, ari Maria Jems aakoaro airoa rutu toupaiva. Ora airorovu airoa tapo toupaiva, ovusa vo reo iava vao voea aposel irara tavipaiva. ");
INSERT INTO roo_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ari voeao aposel irara keapaaepa oiso, Kiuvu reo raga-a oa tavipaivoi. Oa iava viapau oiso vo riako vo reoaro oirao piepaiva. ");
INSERT INTO roo_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Vo osa Pita ikauvira avaroepa vo tova iare. Oa iava takuro viropa uva voa kokepareva. Uva varoara raga kekereva osa voa toupaiva. Oa iava vorevira voreroepa kepa iare. Osa iava rirovira rutu rugorugoo iraoparoepa tavetavepaoro va-ia vao oa karekeepa. ");
INSERT INTO roo_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Oire uva vo voki raga-a vao oa-ia aitereivu voea iava vokapasiva gare uruivi iare. Va vaisiaro aue-ia, Emeas. Aue iava Jerusalem-ia oisoa vo raiva-ia avapaave voare Emeas. Uva aue-ia oisoa uvuipape voare katai tau katai vuuta rutu (11 kilomita). ");
INSERT INTO roo_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Oa iava voa vokapaoro avapasiepa varao rutu-ia ora reopaoro oara karekeepa. ");
INSERT INTO roo_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Oire uva voa ora reopaoro vokapasiva. Uva rera Jisas vaiterei ruvara-ia ora karekeroepa. Oa iava vaiterei tapo vokapaoro avaparoepa. ");
INSERT INTO roo_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ari vaiterei iava osireiara aauepa. Oa iava viapau oiso rera eveipasiva oiso, Jisas ro-ia. ");
INSERT INTO roo_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Oire uva oiso vaitereire puraroepa vaiterei akeoro, “Eake-a vao oa-ia ora reopaoro avapasiei?” Uva oisi-a oiso osa puraroiva, ruusiva siraooro rutu. ");
INSERT INTO roo_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Oa iava iravu rera vaisiaro, Kliopas rera aatooro oiso puraroepa, “Riro irara rutu ouruirovu iava vo-ia Jerusalem-ia toupaivoi. Ari vii vai pasi kataito, viigoa viapau pasi taraipauei vao-ia oa karekeerao oiso Jerusalem-ia vo vuutao raga-ia, raa?” ");
INSERT INTO roo_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Uva vaiterei akereva Jisas oiso, “Eake-a?” Oa iava oiso purasiepa, “Auoro! Vao-ia oa karekeei ro-ia Jisas vova Nasaret eera profetato. Ira oisoa riro gorupa kovoro purapareve, ora riro gorupa reoro tapo vo Pauto osireiaro-ia ora vo tapo oirara rutu osireiaro-ia. ");
INSERT INTO roo_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Aue tapo uvare voeao reipa irara pris irara ora voeao tuvetuvepa irara vigei voeaaro rera tovoivorao voeao gavman irara vavaearo-ia. Oa iava voea gavman irara reo goru puraivorao rera uposa. Uva rera tapaivorao evao parikou-ia. ");
INSERT INTO roo_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ari ita, voari tuariri uva oisoa igei rera oirao piepaio, Eera ira voea oirara karureverea Isrel-pa irara vova tuukea-ia. Iu. Ora oreovu tapo vao iava rera vo kopiiaro isivaaro iava vo vokio-ia vo pevapa voki vo vokio. ");
INSERT INTO roo_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ari ita, airovua vairo igei iava airoa igei sita pieivoi rutu. Uvare vokipaua rutu vokiae voarire tova-ia. ");
INSERT INTO roo_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Oa iava voa viapau rera iava Jisas varaua kekeivo. Osa iava vorevira voreae igei tavisa. Ari ita, uva voa oearovu enselpa irara tapo kekeivo oea oiso puraae, Ira tootoovira touparevoi. ");
INSERT INTO roo_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Oa iava oearovu igei iava voare tova-ia tavariivo. Uva oisi raga ita va kekeivo oiso osa vo riako taviae. Vo uvare voa viapau rera kekeivo.” ");
INSERT INTO roo_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Oire uva Jisas vaitereire oiso puraroepa, “Ari ita, viapau oiso visii-a rugorugooa vaiei. Uvare visii iava sopaura vavagisi iraopapeira. Oa iava viapau vo reoro oirao piepataveira profet irara oara iava oisoa tavipaave voari tuariri. ");
INSERT INTO roo_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","E apeisi-a? Esa pasi viapau taraipataveira oiso, Vo raga osa Krais siitoka ou rovo iraoreve, oire ra utupavira rera vaaro keraria ora gorua oureve?” ");
INSERT INTO roo_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Uva vova varao rovoepa Moses vo reoaro-ia vo pou virosa voea rutu profet irara. Oa iava vaitereipa siposiporeva oiso vo reo rutu varao oara Tugoropa Vuku-ia oisoa toupaive, vo reoro iava rovopaoro oreoroa rigatoiva Moses ora profet irara. Oara rutu oisoa rera raga iava tavitavipape. ");
INSERT INTO roo_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Oire uva vo urui iare tutuuiva vao oa iare avapasiepa. Oa iava Jisas oiso rovoroepa ra vo urui-ia vaiterei veraoro putereve rera raga avaoro. ");
INSERT INTO roo_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Vo osa rera voresivoiva, oiso purasiepa, “Vo tou rovori vegei tapo. Uvare ravireo rokorevoi. Uva rupasa auepai.” Oire uva vaiterei tapo tousa koataroepa. ");
INSERT INTO roo_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Oa isivaaro iava aiosa auepaaepa. Uva vaiterei tapo pauroepa rera Jisas. Uva bret oureva va-ia vearo vaisi purasa Pautoa-ia. Oa iava vaitereipa va puteputereva vaiterei vatevatesa vara. ");
INSERT INTO roo_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Uva oisi-a oiso osa va purarevoiva, vaiterei iava osireiara karu piropa roroiooro. Oa iava vearovira rutu rera-ia taraisiepa rera eveioro. Uva va isivaaro iava vaiterei arova opesikoroepa avaoro. ");
INSERT INTO roo_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Oire uva ora reopasiepa vaiterei raga oiso, “Ari ita, vo osa vokapavevo raivaaro, ovusa vegei tavitaviparevo aue iava Tugoropa Vuku vituaro iava. Uva oiraopavira ita, vegei iava vovouisirei roruoro rirovira rutu kovatae rera vo reoaro sovooro.” ");
INSERT INTO roo_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Oire uva vo voki raga-ia Jerusalem iare vore karesiepa katai tau katai (11) disaipel iare pou virosa ora oearovu. Uva ora guruaepa voea rutu ");
INSERT INTO roo_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","oiso puraoro, “Oiraopavira rutu Turaro Jisas vorevira toreroi Saimon ira kekerevo.” ");
INSERT INTO roo_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Oa iava voeapa siposiposiva varao iava oara vaiterei iare karekeepa raivaaro. Uva oiso purasiepa voeare, “Easi eera vegeipa bret puteputerevo. Oa iava rera-ia taraiveie rera eveioro.” ");
INSERT INTO roo_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Oire uva oisi-a oiso osa ora reopaoro toupaiva, ovusa Jisas voea vuutaaro-ia ora tore pieoro ora karekeroepa voea iare. ");
INSERT INTO roo_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Uva rirovira rutu ora sitaaepa. Oa iava uriripaaepa rutu oiso keapaoro, Iravu uraurato tugarato ira voea iare pouro viroi. Oa iava rera kekeivoi. ");
INSERT INTO roo_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Uva voeare oiso puraroepa, “Eakepa vurivira rutu ora sitatai? Ari eakere visii iava sopaura ragai-ia vakuvaku asapai? ");
INSERT INTO roo_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ragai vavaearo keketa ora ragai kokotoaro viupara kekesa. Easi ragai raga-a vao, ragoa toupaavoi. Oire ragai-ia pituta ora visii varaaro iava vavaeara, uvare tugaratoa-ia viapau keruara vai toupaiveira oiso osa varao oara ragai-ia toupaivoi oara kekepatavoi ragai-ia.” ");
INSERT INTO roo_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Oire uva oisi-a oiso osa puraroepa ora rera iava vavaearei karekeoro ora kokotoarei voeapa. ");
INSERT INTO roo_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Oa iava rirovira rutu roru iraopaiva. Ari touvira viapau rera oirao piepaiva rutu. Uva rirovira rutu rugorugoo iraopaaepa. Osa iava voea akereva oiso, “Esa aioara vaiei voraro?” ");
INSERT INTO roo_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Oa iava rerapa ataria vateiva oa oriiva. ");
INSERT INTO roo_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Uva va ouoro va aioreva ovusa rera siituepaiva rugorugoo iraopaoro. ");
INSERT INTO roo_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Oire uva voeare oiso puraroepa, “Voari tuariri uva visii tapo toupaavora, uva visii taviavora vo reoro rutu iava varao ragai iava vo Reo Taisi-ia vao Moses vaaro, ora varao rutu oara rigatoiva profet irara vao-ia Vukua voea vaaro, ora vo Sam. Uva vo reoro rutu-a varao oara oiraoei.” ");
INSERT INTO roo_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Uva va-a vao oa-ia voea vovouaro roroio piereva. Oa iava Pauto vo reoroaro-ia taraiaepa rutu. ");
INSERT INTO roo_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Osa iava voeare oiso puraroepa, “Tugoropa Vuku oiso purapapeira, Krais tavaka vo vavataaro kae rovo iraoreve. Oa iava vo pevapa voki-ia vorevira torerovere taru tova tapi iava. ");
INSERT INTO roo_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Oa iava rera vo kovoaro iava siposipo iraopaivere vo oirara rutupa voraro rutu okovoa-ia raiva purareva Pautoa iare. Ra va iava voea iava sopaura oaive vorevira pore piro vova vuri vovouro oaive. Oire ra Pauto voea iava vuriara oaive verareve. Uva vova Jerusalem-ia vo siposipo vao rovo iraopatavoi rara. ");
INSERT INTO roo_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Uva uvui iraopatai ra vara iava varao siposipota oara keketavo rutu. ");
INSERT INTO roo_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Oire uvuta! Va-a vao-ia oa iava Aite taviroepa voari tuariri, ira-a ro ira visiipa vatepaavoi Tugoropato Uraurato. Uva rera sipoavere visiipa vo osa vo urui-ia Jerusalem urui-ia tou rovota. Oa-ia visii iare va vao rera vo goruaro vuvuiua iava varapere visii-ia okovorovu purapasa oearovupa oirara vao Pauto vo kovoaro.” ");
INSERT INTO roo_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Oire uva voava vo voea tuvetuvereva aue-ia ruture Betani-ia. Oa iava vavaea kae piereva voea vateoro viraakrovopaivoivaoa vao Pauto vo goruaro iava. ");
INSERT INTO roo_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Oire uva voa-a vo uva voea viraakopareva touvira, ovusa Pauto rera kae piereva vuvuiua iare. ");
INSERT INTO roo_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Uva voa raga rera-ia Jisas vuurapa vaisi pura, Jerusalem iare voreaepa. Oa iava rirovira rutu rorupaiva rutu. ");
INSERT INTO roo_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Oa iava vao oisoa vokiara rutu-ia Rovopa Kepa-ia Tempel toupaive. Uva Pautoa-ia vuurapa vaisi purapaoro rorupaive rera-ia. ");
INSERT INTO roo_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Voari tuariri vo uva vo rasio pura asavira touva Reoa raga touva. Oa-a Reoa oa Pautoa tapo touva. Uva oisi-a eisi osa Pauto toureva, osa-a eisi osa Reoa raga touva. ");
INSERT INTO roo_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Oa tuariri rutu Pautoa tapo touva. ");
INSERT INTO roo_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Oreoa orekerovu rutu vituaro. Oa iavirava Pauto orekerovu rutu purareva. Ari ita, viapau oiso oai oraivai raga iava karekeepa. Viapau. Ari Reoa raga-a orekerovu rutu vituaro. ");
INSERT INTO roo_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Oa-a Reoa Tootooa rutu vituaro. Oa iava va Tootooa oirara rutupa Aviavia. ");
INSERT INTO roo_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Uva va-a eva Aviavia oa rupapa aviavia vatepaiveira vare roropaoro. Osa iava eisi rupa viapau oiso vo Aviavi papupaiveira. ");
INSERT INTO roo_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Oire uva iravu oirato urioroepa rera vaisiaro Jon, ro ira arureva Pauto. ");
INSERT INTO roo_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ira urioroepa oiraopa reo siposiposa. Va iava vao Aviavia tavitaviroepa voea rutupa, oiso ra va iava vao Aviavia uvuoro oirao pieive. ");
INSERT INTO roo_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Uva rera-a viapau oiso va eva Aviavia. Viapau. Ari eera urio ragaroepa va iava vao Aviavia tavitavisa. ");
INSERT INTO roo_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Oaviavia rutu-a eva oiraopa. Oa oirara rutupa aviavia vatepaiveira. Rera-a eera Aviaviaro oirara rutupa ira urioroepa vo rasio iare. ");
INSERT INTO roo_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Oa raga-a eva Reoa oa urioepa vo rasio-ia tousa. Uva rera-a ro ira iavirava Pauto vo rasio rutu purareva. Uva oirara voea vo rasio-ia oisi iavirava viapau oisoa rera eveipaive. ");
INSERT INTO roo_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Osa iava vararoepa vo tousa uva purareva rera voaaro. Ari ita, uva viapau oiso voeao rera voeaaro rutu rera ouiva. ");
INSERT INTO roo_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Vo ovusa oearovu raga voea iava rera eveioro rera ouiva voeao oea oisoa rera-ia oirao piepaive. Oa iava voea vo vovouroaro-ia taraipaoro voea reesireva, ra oiso toupaive rutu, voea-a Pauto ovii iraraaro rutu. ");
INSERT INTO roo_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ari voeao oea oiso toupaiveira, Pauto ovii iraraaro viapau oiso eisire voea kavauivora aite irara ora aako riakoro oaive. Ora viapau oiso varaua raga vo ruipaaro-ia. Ora viapau oiso vo oiratoa raga vo ruipaaro-a. Viapau. Ari Pautoa raga ora rera vo ruipaaro-ia voea kareke piepareveira oiso rutu, ra oiso toupaive, Rera ovii iraraaro rutu. ");
INSERT INTO roo_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Oa raga-a vao-ia Reoa oa oiravira ora poreepa. Osa iava igei vuutaaro-ia toureva. Oa iava igei rera vaaro keraria kekeiova. Vao keraria-a rera vaaro ro-ia Kataitoa raga Oviito Aite ira arureva oa iava urioroepa. Ira-ia vereopa vovou toupaiveira ora aue oiraopa pitupitu. Oara rutu iava agasiroepa. ");
INSERT INTO roo_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Uva Jon Baptais rera iava tavioro oiso puraroepa, “Eera oirato tuariri rutu ira iava visii taviavora oiso-ia, Ro ira ragai sirova uturovere ira ragaipa reiparoveira. Eake iava? Uvare tuariri rutu toureva ovusa ragai kavau asavira touava.” ");
INSERT INTO roo_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ari ita, vigei rutu ovatevatearovu rutu vorevoreripavira sirao vatero oisoa oupape rera ruvara-ia. Varao oara rutu iava agasiroepa. ");
INSERT INTO roo_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Eake iava? Uvare Pauto vigeipa Reo Taisi vatereva Moses vavaearo-ia. Ari va vao riroa rutu vereopa vovou ora oiraopa pitupitu oara rutu Jisas Krais iavirava karekeepa. ");
INSERT INTO roo_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Viapau oiso irai gare visivi Pauto kekereva. Viapau rutu. Ari rera raga ro-ia Pauto Oviitoaaro ira Aiteto ruvara-ia oisoa toupareve. Oire uva va-a eva oa iava Aitetoa rutu iava oisoa vigei soporepareve. ");
INSERT INTO roo_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Oire uva Jiu iava voea reipa irara oearovu tauo purapa irara pris irara aruiva ora oearovu tapo Livai-pa irara voeao oea oisoa Tugoropa Kepa tokipaive. Oea Jerusalem iava urioaepa Jon akesa oiso, “Vii-a irouto?” ");
INSERT INTO roo_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Uva Jon roroio pievira rutu voeapa siposiporeva. Uva oisi siposipopaoro viapau oiso voeapa oreoi vairupaoro oai vataupareva. Ari oisi raga siposipopareva oiso purapaoro, “Viapau oiso Krais-a ragai ro ira roporeva Pauto, oiso ra Jiu-pa irara tuvetuvereve.” ");
INSERT INTO roo_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Oa iava rera akeiva “Ari apeisi-a. Vii-a profetato Ilaija, eke?” Oa iava oiso puraroepa, “Viapau.” Uva oiso ita puraaepa, “Asi rera vai-a vii ro profetato viigoare tuepaioveira. Ro ira iava tuariri reo purareva Moses?” Uva voea vo reoaro pukooro oiso puraroepa, “Viapau.” ");
INSERT INTO roo_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Osa iava rerare oiso puraaepa, “Ari irouto-a vii? Igei oiso ruipapaiei ra voeao oreoiaro pukoio oea igei aruivoiva, urioie. Apeisi-a oiso osa purapauei ora vii ragare?” ");
INSERT INTO roo_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Oa iava Jon oiso puraroepa profetato Aisaia vo reoroaro sirova utuoro, “Ragai-a iravu gisipoaro. Ragoa vo toupaoro raaka tapi oiso keeraparai, Turaro vo raivaaro torevokota.” ");
INSERT INTO roo_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Uva Farisi oearovu aruiva ora voea raga iava. Oa iava avaaepa rera iare. ");
INSERT INTO roo_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Uva rerare oiso puraaepa, “Ari viapau vii-a Krais, eke viapau vii-a Ilaija, ora viapau vii-a profetato. Vosa viapau Krais vii, uva apeisi ragavira vii reesirevora oa iava oirara rutu baptaisparivoi?” ");
INSERT INTO roo_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Oa iava Jon voeare oiso puraroepa, “Ari ita, voea baptaispaaveira uukoa raga-ia. Vo ovusa visii vuutaaro-ia iravu toupareveira ira viapau eveipataveira. ");
INSERT INTO roo_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ro ira ragai sirova utuparoi. Uva viapau oiso vearoto-a ragai, ra rera vaaro iava tasipa tuukea karua.” ");
INSERT INTO roo_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Vo reoro rutu purareva Betani urui-ia ovaratavu iava uuko ovi iviropavira vo ovio Jodan vo uva Jon oirara baptaispareva. ");
INSERT INTO roo_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Uva vokipaua Jon Jisas tuereva osa vokapaoro urioparoepa rera iare. Oa iava Jon oiso puraroepa, “Va kekepata eva tauo puraso kakae Sipsip Kakae Pauto vaaro. Oa vuriara veravere oirara rutu iava vo rasio-ia. ");
INSERT INTO roo_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Eera ira iava tuariri taviraepa oiso puraoro, Iravu oirato ragai sirova uturovere ira ragaipa reiparoi rutu. Eake iava? Uvare tuariri rutu toureva vo osa kavau asavira ragai touava. ");
INSERT INTO roo_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ari ita, viapau vearovira rera-ia tarai rovoraepa. Oa iava urioraepa oirara rutu baptaisisa uukoa raga-ia ro oirato kareke pieoro voeaopa Isrel-pa irara.” ");
INSERT INTO roo_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Oire Jon oiraopa reo vatepaoro oiso puraroepa, “Uraurato tueavora ovusa vuvuiua iava vararoera oiso rutu osa kurue rera kukuearo ariaraaro toupasa. ");
INSERT INTO roo_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ari ita, viapau rera-ia tarai rovoraepa vo ovusa ro ira ragai arureva oirara rutu baptaisisa uuko raga-ia. Ira ragai tavirevora oiso puraoro, Uraurato kekerivere. Ira vararovere iravu kukuearo ariaraaro iare oirato. Eera ira oirara baptaispareverea rara aue-ia Tugoropato Uraurato. Oa iava aue-ia vukupaaverea Uraurato vo goruaro. ");
INSERT INTO roo_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Uva ragai raga rera kekeava. Oa iava rera iava tavitaviparai oiso purapaoro, Oiraopavira rutu, uvare Pauto Oviitoaaro-a rera ro-ia.” Oiraopavira rutu Jon osa oiso puraroepa. ");
INSERT INTO roo_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Oire uva ovokivu vokipakouaro-ia Jon aitereivu tapo disaipeltoarei rera vaitereiaro toreroepa. ");
INSERT INTO roo_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Uva voa-a vo uvava Jisas tuereva ovusa vokapaoro urioparoepa. Oa iava Jon oiso puraroepa, “Eva Sipsip Kakae Pauto Oviiaro.” ");
INSERT INTO roo_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Uva disaipeltoarei rera uvusiva ovusa oisi puraroepa oiso. Oa iava Jisas sirova utusa avasiepa. ");
INSERT INTO roo_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Uva Jisas vaiterei akesa ora poreroepa ovusa rera sirova utupasiepa. Oa iava oiso puraroepa vaitereire, “Eakere taraapasivoi?” Oa iava rerare oiso purasiepa, “Rabai, ovu-ia touparivoi? Aa vo kepao-ia?” Ovaisi-a vao, Rabai porearo oiso toupai, Tisato. ");
INSERT INTO roo_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Uva vaitereire oiso puraroepa, “Uriosi kekesa.” Oa iava avasiepa vo kepa kekesa voa oa-ia toupareva. Uva voa voeare vokiepa, vo uvare vo resura vuuta rutu-a vao oa-ia rera iare pousi viropa voa. ");
INSERT INTO roo_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andru, Saimon Pita araokotoaaro eera iravu vaiterei iava vaitereo aiterea Jon vo reoaro uvusivoiva, avaroepa Jisas sirova utusa. ");
INSERT INTO roo_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Uva Andru araokotoare taraa rovosa avaroepa aue Saimon. Oa iava rera tavireva oiso, “Igei Mesaia kekeiovoi.” Ovaisia porearo-a vao oiso, Krais. ");
INSERT INTO roo_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Oa iava Andru rera tapo avaroepa Jisas iare. Uva voa Jisas rera kekeoro oiso puraroepa, “Vii-a vao Saimon Jon oviitoaaro. Viigoa vaisiaro perea utupavira oiso, Sifas.” Ovaisia porearo-a vao oiso, Pita eera Aveke. ");
INSERT INTO roo_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Oire uva Jisas Galili iare vokioro Filip kekeoro rera tavireva oiso, “Ragai sirova utuu.” ");
INSERT INTO roo_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Uva rera-a Filip aue iava Betsaida-ia, Andru vo uruiaro rutu vaiterei ora Pita. ");
INSERT INTO roo_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Uva Filip Nataniel kekesa avaroepa. Oa iava rera tavireva oiso “Ro ira iava tuariri Moses reoa rigatoreva Reo Taisi-ia. Ora aue tapo profet irara oea rera iava va rigatoiva, eera ira kekeiovorao ro Jisas Nasaret iava Josep oviitoaaro.” ");
INSERT INTO roo_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Uva oisi-a eisi osa iava Nataniel rerare oiso puraroepa, “Esa pasi oavu avu vai vearoa vai uvuipai avu ra Nasaret-ia karekepe, raa?” Uva va-a vao oa iava Filip rerare oiso puraroepa. “Urio ragau kekesa.” ");
INSERT INTO roo_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Oire uva Jisas Nataniel siituepareva ovusa urioparoepa rera iare. Oa iava rerare oiso puraroepa, “Keketa ro-ia Isrel-patoa rutu. Ira-ia viapau kuuvua vai toupaivoi.” ");
INSERT INTO roo_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Oa iava Nataniel rera akeoro oiso puraroepa, “E apeisi iava ragai-ia maraiuera?” Uva Jisas oiso puraroepa, “Ari ita, vo osa Filip viire keera asavira tourevora ovusa fik ova vituaro-ia touparivora, ovokia-a eva oa-ia vii keke rovoavora.” ");
INSERT INTO roo_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Oa iava Nataniel oiso puraroepa, “Tisato, vii-a Pauto Oviitoaaro. Vii Isrel-pa irara reraaro rutu Kingto.” ");
INSERT INTO roo_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Uva Jisas rerare oiso puraroepa, “Vii tavipaavoi vao iava osa vii keke rovoavora fik ova vituaro-ia. Uva va vai-ia pasi oiraopau vao, raa? Uva utupavira oaravu kekepariverea oara vao-ia putepaiverea rara.” ");
INSERT INTO roo_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Uva Jisas rera ita vorerivira tavireva oiso puraoro, “Oiraopavira rutu eisi osa visii tavipaavoi oiso, Vo utupavira vuvuiua keketaverea ovusa karu piro, ra purapurapa irara ensel keketa voa Pauto voeaaro ovusa voare ipapaave ora voava varapaave Oirato Oviitoaaro iare ragai.” ");
INSERT INTO roo_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Vo pevapa voki-ia iravu oirato riakova oureva Kena-ia oiso Galili taere sovara-ia. Uva Jisas aakoaro voa kavatao kepa-ia toupaeva. ");
INSERT INTO roo_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Uva Jisas-re tapo keeraaepa ora igei rera voeaaro disaipel va vao ora oupa pitupitu kekesa. ");
INSERT INTO roo_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Uva wain ovi opesieiva, aakova Jisas tavieva oiso, “Voeao viapau wain ovi vaiei.” ");
INSERT INTO roo_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Oa iava Jisas oiso oirare puraroepa, “Riakova, ragai auearo. Viapau oiso vii auearo-a. Uvare ragai vo vuutaaro tugura asavira toupaivoi ovuuta-ia ragai vaisiaro roroiovira kareke pieavere.” ");
INSERT INTO roo_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Oa iava aakova kovopa irara tavioro oiso puraopa, “Vosa eake reo purapareve visiire, uvuipatai ra oisi va sirova ututa.” ");
INSERT INTO roo_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Oire uva voa toupaiva aue katai vatara (6) pitokaara avekeara oara-ia Tugoropa Sisu oisoa purapaive vo vavaeara oaive-ia aue Jiu. Oara oisoa uvuipape vo osa vara uukopaoro vara agasi piepaive oiso uvuivira erao tau (20) galen ora vo peva tau (30) galen aue uuko vo kataiva-ia pitokava. ");
INSERT INTO roo_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Oa iava varare Jisas voea tavireva oiso, “Uukoara vai kuvuta vo pitokaara rutu-ia.” Uva vara agasi pieiva rutu. ");
INSERT INTO roo_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jisas voea tavireva oiso, “Oarai kokota. Ra ro vatesa avata ira aioa-ia tokipa.” Oa iava varava avaaepa. ");
INSERT INTO roo_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Oire uva rera ro ira vo aio-ia tokiparoepa vo ovi togovireva, ovusa wainvira ora poreepa. Uva viapau taraiparoepa oiso, Ovu-ia vo ovi ouivo. Vo osa voea raga kovopa irara taraipaaepa voeao oea vara-ia uuko kuvupaaepa. Oa iava rera ro aioa-i tokipato rerare ro riako oupato keeraroepa ");
INSERT INTO roo_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","oiso puraoro, “Oirara rutu vearopa oviro wain oviro roo pie rovopaiveira. Oire ra rirovira ukaioave, ra va isivaaro iava taru wain turi-ia akukuara raga ukaio ragaave. Uva viapau oisi eisi pieri. Uvare vo vuuta-a vao oa-ia vearopara wain oviro roo pieparivoi oirara rutupa vo oviro oara rukurivo.” ");
INSERT INTO roo_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Oire uva vao rovopa rutu ravotoa Jisas oa purareva oiso Kena urui-ia Galili taere sovara-ia. Oa-ia rera vaaro keraria vo goruaro kareke piereva voeapa. Oa iava voeao disaipelpa irara rera voeaaro rera oirao pieiva rutu. ");
INSERT INTO roo_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Uva va vao isivaaro iava Jisas Kapaneam iare tavetereva aakova tapo, ora araoko irara, ora igei disaipel irara. Uva voa ovokirovu-ia vo urui-ia touiova. ");
INSERT INTO roo_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Vo Tagausapa Vurei Pasova Vureipa Jiu vaaro tutuu pieepa oiso ra karekepe, ovusa Jisas Jerusalem iare iparoepa. ");
INSERT INTO roo_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Uva voa Rovopa Kepa Tugoropa Kepa Tempel sovara-ia oirara rutu kekereva, ovusa orekerovu-ia voriara ora tuutuupaaepa aue-ia tapo sara kovoro purapaoro bulmakau kare, ora aue sipsip, ora kurue kare, vo kareo okarea-ia oisoa tauo purapaive. Uva voa voea kekereva ovusa paupaaepa oisi eisi vara-ia ora piepaoro. ");
INSERT INTO roo_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Uva kopirovu kekereva Jisas. Oa iava rera-ia aue purareva ragi vuruko. Osa iava va-ia voea oirara tarioreva voava vo Tempel-ia vo kareva aue sipsip ora bulmakau. Uva voea varaaro petopetoreva moniara voeao oea moni tavariopaaepa varao tapo tebolara voea varaaro. ");
INSERT INTO roo_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Uva va-a vao oa iava voeare oiso puraroepa voeao oea sara kovoro purapaiva kurue kare-ia, “Vo kareva kosita viro. Opeita Aite oaa vo kepaaro oiso piepata, Vori oupa kepa.” ");
INSERT INTO roo_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Uva igei disaipel oreovure rugooiepa oa epao Tugoropa Vuku-ia oa oiso purapapeira, ‘Kasivarivira rugorugoo iraoparaveira vii vo kepaarore oiso vovoupaoro, ra vearovira touve.’ ");
INSERT INTO roo_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Oire uva va vao kekeivoiva, reipa irara Jiu iava oiso puraaepa, “Eake ravoto rutu-a vao oa-ia igei kareke pierivoiva, uvuipaiei ra vii-ia taraiio oiso, Viigoa eva vo reesiva touparivoi oiso piepasa, raa?” ");
INSERT INTO roo_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Uva Jisas voeare oiso puraroepa, “Tugoropa Kepa vao Tempel rigapata okepa rara tore pieavere ita vo pevapa voki-ia.” ");
INSERT INTO roo_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Uva va-a vao oa iava voea Jiu oiso puraaepa, “Vo resura tau katai vatara (46) ivaro-ia vo kepao pauiva. Uva apeisi-a? Vo pevavi raga-ia voki uvuipauei ra vo kepao vorevira tore pieri, raa?” ");
INSERT INTO roo_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jisas vo kepaore Tugoropa Kepa Tempel oisi eisi puraroepa varaua vouao ora rera iava. ");
INSERT INTO roo_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Oire vo tore vokiaro vo osa Pauto vorevira tova tapi iava rera tore piereva ovokia-a eva oa-ia igei disaipel rera vo reoarore rugooiepa vao oa purareva. Oa iava Pauto vo rigatoaro oirao pieiova ora vo reo vao oa purareva Jisas. ");
INSERT INTO roo_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Oire uva Jisas Jerusalem-ia toureva va-ia vao Tugoropa Voki Pasova Vurei vaaro. Uva riro irara rutu oravotorovu rutu kekeiva varao oara purapareva voa. Uva vara-a evara oara iava rera oirao pieiva rutu. ");
INSERT INTO roo_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Osa Jisas viapau oiso voea vo oirao piearo oirao piepareva. Viapau. Oa-a eva vituaro iava viapau oiso voea vavaearo-ia ora tovoroepa. ");
INSERT INTO roo_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Eake iava? Uvare taraiparoepa voea rutu-ia. Viapau oiso vavagisivira toureva ra irai rera tavireve vo oirara vo pitupituroaro iava. Viapau. Ari rera taraiparoepa voea vo sopaaro-ia. ");
INSERT INTO roo_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Iravu ro oirato toupareva rera vaisiaro, Nikodimas ratarataa vovoutoa rutu Farisi-pato. Uva iravu-a voea iava reipa irara Jiu voeaaro. ");
INSERT INTO roo_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ira urioroepa Jisas iare vokiaro oiso rerare purasa, “Tisato. Igei taraipaiei oiso, Pauto vii siporevora oiso rutu osa iravu tisato. Ari vosa viapau Pauto irai-ia toupareve, ra viapau uvuipa ra vo ravotoro purapareve irai oara purapariveira.” ");
INSERT INTO roo_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Oa iava Jisas rerare oiso puraroepa, “Oiraopavira rutu oiso osa vii tavipaavoi oiso, Vosa ro ira viapau airepavira kavauro, ira viapau uvuiparoi ra Pauto vo Saraaro kekereve ora viapau Pauto vo goruaro sovopareve.” ");
INSERT INTO roo_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Oa iava Nikodimas oiso puraroepa, “Apeisi ragavira irai avukaoro uvuiparoi ra vorevira ita kavauro? E pasi uvuiparoi ra vorevira aakova kovuaro-ia koataroera vorevira rera kavaueve ita, raa?” ");
INSERT INTO roo_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Oire uva Jisas rera vo reoaro pukooro oiso puraroepa, “Oiraopavira rutu osa vii tavipaavoi oiso, Vosa viapau uukoa-ia kavau rovoro oirato, ora tapo vosa viapau Tugoropatoa-ia Uraurato ita kavauro, ira viapau uvuipa ra Pauto vo Saraaro-ia koataro ora viapau Pauto vo goruaro sovopareve. ");
INSERT INTO roo_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ari ro oirato ira oiravira kavauro eera oiratoa raga. Ari ro ira Tugoropatoa-ia Uraurato kavauro, eera oirato ira sopaaro-ia Tugoropato Uraurato toupareveira. ");
INSERT INTO roo_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Opeita rirovira rutu rugorugoo iraopau vo osa oiso vii tavipaavoi, Vorevira kavauu airepavira. ");
INSERT INTO roo_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Kiuvu ora rera raga vo ruipaaro sirova utuparoveira uvarovu vuvurepaoro avapaoro. Uva rera vo gurukoaro uvupariveira, ra viapau taraipau oiso, Ovu iava urioparoi, eke ovu-ia avaparoi. Ari ita, oirara rutu uvuipaai ra kiuvu vo goruaro kekepaive. Uva oisi-a eisi osa roroiovira rutu Pauto vo Urauraaro ora rera vo goruaro eveiparivere vo osa vorevira kavaupau, ra airepa rugooro purari.” ");
INSERT INTO roo_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Oa iava Nikodimas rerare oiso puraroepa, “Uva apeisi ragavira va vao uvuipai ra karekepe?” ");
INSERT INTO roo_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Osa iava eisi Jisas rerare oiso puraroepa, “Ari apeisi ragavira-a va-ia vao? Uvare vii-a Isrel-pa irara tuvetuvepato. Oa iava viapau va-ia vao roroiopauei, raa? ");
INSERT INTO roo_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Oiraopavira rutu oiso osa vii tavi iraopaavoi oiso, Igei varao-ia reopaiei oara-ia taraipaiei. Ora varao iava siposipopaiovoi oara kekeiovora. Osa visii vao vo reore isivapataveira oreoa vao oa iava oiraopavira rutu siposipopaiovoi. ");
INSERT INTO roo_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Visii tavipaaveira vara iava varao vo rasio iava. Uva viapau vara oirao piepataveira. Vosa visii tavia ita varao iava vuvuiua iava, ra apeisi ragavira vara oirao piepata ita rara, raa? ");
INSERT INTO roo_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Viapau oiso irai vuvuiua iare iparoepa. Ari Oiratoa raga Oviitoaaro-a ragai ragoa vuvuiua kavuoro vararaepa. Ira raga-a ita ragai Kataito. ");
INSERT INTO roo_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Tuariri Moses brasva rakoru toorotoa-ia kae piereva kuvau tapi iria purareva. Eisi raga ita osa Oirato Oviitoaaro kae pieiverea rara evao parikou iare. ");
INSERT INTO roo_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ra oisi iavirava oearovu oirara rutu iava ragai oirao pieive. Ra va iava Tootoo Ovoi ouive. ");
INSERT INTO roo_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Oreoa vituaro iava oiso toupai, Pauto ora rera vaaro sirao vovou rutu oirara rutupa vatepareveira voeao oea vo rasio-ia toupaiveira. Eva-a oa vituaro iava ro kataitoa raga Oviito voeapa vatereva, oisore ra oirara rutu iava oearovu rera oirao pieive. Ra va iava viapau opesiave. Viapau. Uva uvuipaai ra Opesi Asa Tootoo ouive. ");
INSERT INTO roo_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Pauto viapau oiso Oviito siporeva oirara rovirieipasa voeao vo rasio-ia oiso osa ro reo rovirieipato aue jas. Viapau. Ari eera siporeva vorevira voea kae piepaoro voea oupasa ora rera iare. ");
INSERT INTO roo_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ro ira Pauto Oviitoaaro oirao piepareve ira viapau rovirieia vai. Ari ro ira viapau rera oirao piepareve eera ira opesi ovoiroverea rovirieia-ia. Eake iava? Uvare viapau Kataitoa raga Oviito Pauto Oviitoaaro oirao piepareve. ");
INSERT INTO roo_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Uva va-a vao rovirieia vituaro oa oiso toupai, Aviaviaro oirarapa oa-a vao oa pou pirora vo tuaririvi vo rasio-ia, ovusa oirara rupapa ruipapaaveira. Eake iava? Uvare vuri pitupitu-a voea vaaro. ");
INSERT INTO roo_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Uva voeao oea vuri pitupitupa ruipapaaveira oea aviaviava ora upopaaveira oiso reasipaoro, Teapi voea vo pitupituroaro vuriara poeravira karekepape. Eva-a oa iava viapau uriopaaveira aviavia iare. ");
INSERT INTO roo_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ari ro ira oirao pie vovou rutu purapareve ira aviavia iare urioparoveira. Oire ra va iava oirara vearovira rutu rera vurapaive. Ra oiso puraave rerare, Eera ira ora rera vo kovoaro purapareveira Pauto vo rugooaro-ia.” ");
INSERT INTO roo_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Oire uva va vao opesieiva, Jisas rera voeaaro tapo disaipel avaroepa oisore Judia Distrik sovara-ia. Uva voa igei tapo toupaoro oearovu baptaispareva Jisas ora rera vaisiaro-ia. ");
INSERT INTO roo_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Uva aue tapo Jon Baptais voea rutu tapo baptaispareva vo aue-ia Inon-ia aue ruvara-ia Selim-ia uva oisoa toupaive riroara uuko oviro. Uva oirara rutu iava oearovu baptaisa ousa urioaepa voa. ");
INSERT INTO roo_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Vo ovusa Herot Jon tovo asavira toupareva tuukea-ia. ");
INSERT INTO roo_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Uva va-a vao oa iava oreorovu kosi pieiva Jon voeaaro disaipel ora iravu Jiupato. Oreoroa-ia ora reopaaepa baptaisa vo pitupituaro iava. ");
INSERT INTO roo_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Oa iava voea disaipel Jon voeaaro rerare avaaepa. Oa iava oiso Jon tavipaiva, “Tisato, ro-ia oirato ira vii tapo touparevora oiso Jodan-ia iviropavira uva rera iava siposipoparivora, ira-a ro ira oirara rutu iava voea baptaisparevoi ora rera iava. Oa iava voea rutu rera iare avapaae. Ari apeisi viapau oeai uriopaai vii iare?” ");
INSERT INTO roo_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Uva Jon voea vo reoaro pukopaoro oiso puraroepa. “Vosa Pauto iraipa viapau kovoa vai vatereve, ra viapau oiratoa vai raga uvuiparo oavu avu vai purasa. ");
INSERT INTO roo_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ari ita, visii raga ita vao visiigoa vo reo uvutavora oa puraavora tuaririvi oiso, Viapau oiso Ropoto Krais-a ragai. Ari Pauto ragai ira pierevora. Oa iava iraraera rerapa ro Krais ira ragai sirova uturovere. ");
INSERT INTO roo_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Oire vosa irai riakova vai oureve, ra rerapa oirape ro ira oira oureve. Ra sarato toreparo rera gisipoaro uvupasa. Ra oisi iava rorupareve rutu rera uvupaoro rera ro ira riakova oureve. Uva ragai tapo oiso rutu rorupaavoi, uvare sarato oaa ira iare oirara rutu ora gurupaaveira. ");
INSERT INTO roo_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ira vaisiaro uvui iraopa ra reiparo, ovusa ragai vaisiaro varapara.” ");
INSERT INTO roo_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ro ira viara iava urioroera ira oirara rutupa reipa. Ari ro ira rasitoa iava karekero eera ita vo rasio iava rera-a. Ira varao rutu iava vo rasio-ia reoreoparoveira. Ari ro ira vuvuiua iava urioro ira oirara rutu-ia putepareveira eera. ");
INSERT INTO roo_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ira varao iava siposipopareveira oara rutu kekereva ora vara rutu iava uvureva. Ari viapau irai vara iava vo reoro oupaoro vara-ia goruvira rutu pitupareveira. ");
INSERT INTO roo_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Vosa ro ira vo reo oureve, ra va iava goruvira vo reo-ia pitupareve. Ora tapo vosa ro ira iureve vo Pauto vo reoaro-ia, eera-a ira oiraopa pitupitu kareke piepareveira Pauto vaaro. ");
INSERT INTO roo_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Uva Pauto Oviito arurevora, oa iava urioroera. Oa iava Pauto vo reoaro iava siposipopareveira. Eake iava? Uvare Tugoropato Uraurato vatereva Pauto. Oa iava rera-ia vukuparoveira. ");
INSERT INTO roo_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ari ita, Pauto Oviito kaviko iraopareveira. Oa iava orekerovu rutu vateparevora rera vavaearo iare. ");
INSERT INTO roo_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ro ira Oviitoaaro oirao piepareve, ira-ia Tootoo Ovoi toupaiveira. Ari vosa ro ira viapau Pauto Oviitoaaro vo reoroaro sirova utuparo, ira-a eera viapau uvuiparoi ra Tootoo Ovoi oureve. Viapau. Ari Pauto vaaro kasipua ira-ia eera toupaiverea opesi asavira rutu. ");
INSERT INTO roo_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Vo vuuta-a vao-ia oa-ia oeavu ratarataa vovou irara Farisi oea iava oreovu uvuiva vao oa oiso purapai, Jisas oearovu rutu oupaoro riro irara rutu disaipel baptaisparevoi. Oa-ia Jon-ia puterevoi rutu. ");
INSERT INTO roo_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Uva viapau Jisas voea baptaispareva. Ari igei raga rera voeaaro disaipel igoa voea oirara baptaispaiova. ");
INSERT INTO roo_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Uva Jisas oisi oiso-ia tarairoepa oiso, Farisi vo reoaro-a vao oa uvuivoi oiso, Oirara baptaisparevoi Jisas aue-ia Jon putepaoro. Oa iava Judia-ia kavuoro vorevira kareroepa Galili iare. ");
INSERT INTO roo_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Oa iava vo raivao gaereva oa Sameria-ia vuruvuruiaaro-ia oisoa toupaive. ");
INSERT INTO roo_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Oire uva riro urui-ia karero viropa vao Sameria taere-ia oa oisoa vaisipaive oiso, Saika vo rasio ruvara-ia Jekop oa tuariri rutu vatereva oviitoapa Josep. ");
INSERT INTO roo_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ouruia-a eva oa-ia vao uuko oupa riku oisoa toupaive oa purareva Jekop. Uva Jisas vokapaoro avaroepa voare. Oa iava varaua rerare raveraveepa riro kaekae voka-ia. Osa iava vo riku vao uukopa ruvara-ia pauroepa Jisas aue rutu torevokoaro-ia ravireo vuuta 12 klok. ");
INSERT INTO roo_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Oire uva voava iriavu riakova Sameria-ia urioopa uukosa. Uva Jisas oirare oiso puraroepa, “Ragaipa uukoa vai. Ragoa rirovira rutu uuko regaparai.” ");
INSERT INTO roo_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Vo ovusa igei disaipel irara riro urui iare kareio viropa aio vorisa. ");
INSERT INTO roo_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Uva va-a vao osa oira o Sameria iava rerare oiso puraopa, “Easi vii-a Jiu-pato? Oea viapau oiso Sameria-pa irara tapo paupaaveira. Uva ragai-a vao Sameria iava. Uva apeisi-a oiso osa iava eisi purauei oiso, Ragaipa uukoa vai. Ragoa uuko rega iraoparai?” ");
INSERT INTO roo_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Oa iava Jisas oirare oiso puraroepa, “Vosa taraipau Pauto vaaro-ia vatevatea, ra oisi iavirava va iava ro-ia taraiu ira vii areparevoi oiso purapaoro, Ragaipa uukoa vai. Ragoa uuko regaparai. Oire ra oisi iavirava rera vai areri pasi vaore uukoa oa-ia Tootoo Ovoi toupaiveira. Ra oisi iava va iava vii vatereve.” ");
INSERT INTO roo_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Oa iava riakova rerare oiso puraopa, “Turaro. Viapau baketa vaiei vii iriaiaro, uvare vo rikuo uukopa rokovira rutu toupai. Uva oisi-a eisi osa iava vo uuko eva oa-ia Tootoo Ovoi toupaivoi oa ovu ourivere, raa? ");
INSERT INTO roo_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Oa-a vao uuko riku oa vatereva igeipa aaoto oaio Jekop. Aue iava uvare rera raga va-ia oisoa ukaioparo ora rera ovii iraraaro tapo, ora bulmakau raguiro, ora sipsip raguiro voeao rera voeaaro. Uva vii vai pasi rera vai-ia puteparivoi, raa?” ");
INSERT INTO roo_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Oa iava Jisas oirare oiso puraroepa, “Ari ita, oiraopavira rutu oirara rutu-ia voeao oea vo rikuo iava ukaiopaaveira. Oea ita vorerivira uuko regapaaveira. ");
INSERT INTO roo_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ari vosa irai vao-ia uukoa ukaioro oa vate ruipaparai, ra viapau vorerivira uuko regaparo. Viapau rutu. Oire uva vo uukoa-a vao oa vate ruipaparai, oa oiso rutu toupai tuputupue riku. Oa rera iava sopaua-ia toupaiverea. Oire ra voava vusivusipaive rerapa tootooa vatepaoro vao oa uvuipai toupaive vo vokiara rutu-ia.” ");
INSERT INTO roo_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Oa iava riakova rerare oiso puraopa, “Turaro. Vo uuko vate iraori ragaipa. Oa iava viapau uvuiparai ra voreripavira uriopara uukopasa vo rara uuko regapara.” ");
INSERT INTO roo_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Osa-a eisi osa iava Jisas oira tavireva oiso puraoro, “Avau vatuato oarare keerasa. Oa iava vorevira vore voreuvere.” ");
INSERT INTO roo_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Oa iava Jisas aatoeva oiso puraoro, “Viapau ragai oiratoa vai oaa.” Osa iava Jisas oirare oiso puraroepa, “Vii-a ita vao viigoa oiso purauei, Ragai viapau oiratoa vaiei. Ari ita, uva oiraopavira oisi ita eisi purauei. ");
INSERT INTO roo_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Eake iava? Uvare voari tuaririvi vo vavae rutuva oirara oisoa tou rovopari. Oire uva eera ita irava touparivoi, viapau oiso vii reraaro rutu-a. Ari ita, evo reo vii vaaro oiraopai.” ");
INSERT INTO roo_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Uva rerare oiso puraopa, “Turaro. Ragai vii-ia tarai iraorai oiso, Profetatoa rutu vii, viigoa ragai vo rugooaro sisiro iraopari. ");
INSERT INTO roo_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ari ita, voari tuariri rutu voeao Sameria-pa irara igei aao irara oaio oisoa vo pukuio-ia ora gurupaave lotupasa. Ari visii Jiu oiso purapatai, Vo uva Jerusalem-ia toupaiveira uva oirara uvui iraopaai ra voa Pautoa-pa lotupaave.” ");
INSERT INTO roo_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Oire uva Jisas oiso puraroepa, “Riakova, ragai vo reoaro oirao pie iraori. Ovuutavu urioperea taru oa-ia viapau oiso lotutaverea Aitepa vo pukui raga-ia eva. Ora viapau oiso rerapa lotupataverea tapo Jerusalem raga-ia. ");
INSERT INTO roo_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Visii ropa lotupataveira ira-ia viapau oiso taraipataveira. Ari igei Jiu igoa ropa lotupaioveira ira-ia taraipaioveira. Eake iava? Uvare Pauto vo kovoaro-a vao vorevira oirara oupasa ora rera iare ro iavirava ira Jiu-pa irara iava karekeroepa. ");
INSERT INTO roo_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ari ita, tutuu pievoi vo vuutapa eva oiso ra karekepe uva karekei. Ra oirara rutu oiraopavira rutu lotupaave vuurapa vaisi purapaoro ora voea vo urauraro oaive iavirava Aitepa ora varao voea vo vovouroaro oiraopara. Oeare taraapareveira Aite evoea oea oisi eisi ragavira rera-ia vuurapa vaisi purapaive. ");
INSERT INTO roo_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Pauto-a uraurato. Oa iava uvuipaai oirara rera-ia vuurapa vaisi pura iraopaive. Vo osa ora voea vo urauraroaro iavirava vuurapa vaisi pura iraopaive, ora voea vo vovouroaro oiraopar rutu.” ");
INSERT INTO roo_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Uva riakova rera tavioro oiso puraopa, “Taraiparai oiso, Mesaia uriorovere ro ira vaisipaiveira oiso, Krais. Vosa uriorovere, ra vigei tavireve orekerovu rutu iava.” ");
INSERT INTO roo_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Uva Jisas oira tavireva oiso, “Easi ragai raga-a vao ragoa vii tapo ora reoparai.” ");
INSERT INTO roo_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Uva oisi-a oiso osa puraroepa ovusa rera voeaaro disaipel igei igoa vorevira urioiepa. Oa iava rirovira rutu rera-ia rugorugoo iraopaiepa, uvare oira tapo eira riakova ora reoparoepa. Uva viapau oiso irai oira akepareva oiso, “Eake vai ou ruipapauei?” Eke, “Eakere vii Jisas eira tapo ora reopauei?” ");
INSERT INTO roo_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Oire uva oira o riakova ora oira oiraaro kavuoro uuko kaepava pitokava kareopa riro urui iare oirara rutupa tavitavisa. ");
INSERT INTO roo_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Oiso puraopa, “Avoeao, uriota oirato kekesa ira ragai vo pitupituaro sisiro iraorevo opitupitua oisoa purapaa voari tuariri. Oa iava ragai tavirevo. Esa pasi Krais vai-a vigei muvetuvepatoaaro, eke?” ");
INSERT INTO roo_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Uva va-a vao oa iava riro urui iava urioaepa rera kekesa Jisas. ");
INSERT INTO roo_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ovuuta-a vao oa-ia uriopaaera ovuuta-ia igei disaipel rerare oiso puraiepa, “Tisato. Tepa aio iraori taru.” ");
INSERT INTO roo_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Oa iava igeire oiso puraroepa, “Ragai oaravu aioara toupai. Oara-ia viapau taraipatai.” ");
INSERT INTO roo_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Uva igei raga disaipel oiso ora reopaiepa, “Easi pasi irai vai rerapa oai aioa vai siporevo?” ");
INSERT INTO roo_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Oa iava Jisas igei tavioro oiso puraroepa, “Ragai vaaro-a vao-ia aioa oa oiso toupaivoi, Ro vo ruipaaro sirova utuparai ira ragai arureva. Eva oa oiso toupai osa vao aioa oa aiopaavoi. Uva uvui iraoparai ra rera vo kovoaro opesi pie rovoa. ");
INSERT INTO roo_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Visii vao visiigoa oiso purapataveira, Vo resuraei touvira aue kekira, ra aio oupa vuuta karekepe. Ari oiso rutu visii tavipaavoi, Vuravurata ra riro irara keketa oea uriopaaveira ragai iare. Voeao oea sopaura oaive oiso toupai osa vo kuero okueroa vioro varavaravira toupai. Oea oiso rutu toupai, ragai oirao piesa auepaai. ");
INSERT INTO roo_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Voeao oea ragai vo reoroaro iava siposipopaiveira oea oiso toupaiveira takuraara vikipaiveira. Oea oiso toupai ragai vo reoroaro paupa irara vo oirara sopaaro-ia. Ovusa aia oearovu ita oea ragai vo reoroaro aviavi piepaiveira oea oiso toupai kuero rotupa irara. Oire vo reo uvupaoro oearovu ragai oirao piepaive. Ra va iava Tootoo Ovoi ouive. Eva-a oa vituaro iava voeao takuraara paupa irara ora kue rotupa irara voea rutu rorupaive, uvare ragai-ia oirao piepai. Eva rorua voearei vo kovoreiaro iava. ");
INSERT INTO roo_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Oiraopavira rutu oirara oiso purapaaveira, Iravu raga-a vo kovo paupato ari iravu-a vo kovo kuearo rotupato. ");
INSERT INTO roo_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Oisi-a eisi osa iava visii aruavora vo kovoro kueroaro rotupasa okovoroa evara viapau oiso pau rovotavora. Ari oeavu raga vo kovoro pau rovoivora. Va-a vao osa oirara siposipo rovoivora oeavu Vearo Siposipo ragai iava. Vo osa oirarapa Vearo Siposipo aviavi piepatavora. Oa iava ragai-ia oirao pieivora.” ");
INSERT INTO roo_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Oire uva va-a vao oa iava riro irara Sameria vo uruio iava voea oira reoroaro uvuoro Jisas oirao pieiva rutu. Eake iava? Uvare oira eira oiso puraopa, “Ira ragai tavitavirevoi varao iava muariri oisoa oara purapaa.” ");
INSERT INTO roo_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Oisi-a eisi osa iava voea Sameria-pa irara urioaepa rera iare. Oa iava rera pieoro oiso puraaepa, “Igei tapo vo tou rovori.” Uva vo vokirei-ia tou rovoreva vo urui-ia voea tapo. ");
INSERT INTO roo_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Osa iava riro irara rutu rera raga vo reoroaro uvuoro rera-ia oirao pie iraoiva rutu. ");
INSERT INTO roo_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Uva oirare oiso puraaepa, “Viapau oiso vii raga vo taviaro uvuoro eera oirao pieiovoi oirato. Viapau. Ari igei rera vo reoroaro uvuiovoi. Oa iava taraiiei oiso, O ari rera raga ro-ia ira oirara rutu vorevira oureverea vo rasio iava ora rera iare.” ");
INSERT INTO roo_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Uva vo vokirei vareo opesiepa oarea isivaaro iava Jisas vo uruio kavureva Galili iare avaoro. ");
INSERT INTO roo_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Uva va-a vao osa Jisas siposipopaoro voeare oiso puraroepa, “Profetato ro reo topa piepato ira viapau vaisia vaiei rera oaiaro vo rera vo taerearo rutu-ia.” ");
INSERT INTO roo_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Osa iava Galili-ia kare uvirosa avaroepa. Uva voa Galili-pa irara rera-ia roru iraopaiva, uvare voea iare avaroepa. Uva voea tapo varao kekeiva oara purareva voa evoa Jerusalem-ia vo vokio-ia Tugoropa Voki oa-ia Tugoropa Vurei pura piropa aue Pasova vao Tagausapa Vurei. ");
INSERT INTO roo_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Uva voava ita aue iare karero viropa Kena-ia vo Galili taere sovara-ia. Ouruia-a eva oa-ia uukoa wainvira porereva. Uva Kapaneam urui-ia iravu ofisato reito toureva. Ira oviitoaaro-ia upia toupaiva. ");
INSERT INTO roo_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Uva Jisas iava uvureva ovusa Judia iava ora vaseroepa Galili iare uriooro. Oa iava rera iare avaroepa goruvira rutu rera tavisa, oiso ra vararo rera oviitoaaro porete piesa irapa tutuu pieepa oiso ra kopiiro. ");
INSERT INTO roo_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Uva Jisas oiso rera tavireva, “Vosa visii vao ravoto kovoro viapaua vai kekepata, ra viapau oirao pie vovouro vai purapata.” ");
INSERT INTO roo_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Oa iava rera ro ofisato rerare goruvira rutu oiso puraroepa, “Reito. Ikauvira varau. Teapi oviitoa oaa kopiiro.” ");
INSERT INTO roo_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Uva Jisas oiso puraroepa rera aruoro, “Avau oviitoara tootoovira touparevoi.” Uva Jisas vo reoaro oirao piepaoro vorevira voreroepa. ");
INSERT INTO roo_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Oire uva vaova kareparoepa ovusa kovopa irara rera voeaaro raivaaro rerava aivaroiva. Oa iava voa oiso rera taviiva, “Oviitoara vorevira tootooroi.” ");
INSERT INTO roo_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Uva oiso voea akereva, “Aa vo vuutao-a vao oa-ia gare visivi tootooroi vorevira?” Oa iava oiso puraaepa, “Ari aruvea aue-ia ravireo sipoko. Oa rutu-ia upia rera kavuvo.” ");
INSERT INTO roo_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Oa iava aiteto oiso tarairoepa, O ari vo vuuta raga ita-a vao oa-ia ragai tavirevo oiso puraoro, “Oviitoara vorevira tootooroi.” Oire uva oisi-a eisi osa iava Jisas oirao piereva ora voeao rera voeaaro, oea tapo Jisas oirao pieiva rutu. ");
INSERT INTO roo_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Uva Jisas Judia iava urioroepa vore Galili taere-ia. Uva va vao erao pie ravoto oa purareva voa vo Galili taere-ia. ");
INSERT INTO roo_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Oire uva va-a vao opesieiva, oavu Tugoropa Voki Jiu vaaro pou piropa. Oa iava Jisas Jerusalem iare iparoepa. ");
INSERT INTO roo_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Uva voa-a vo Jerusalem-ia uva riro ratao toupai sipsip ragui vaaro. Uva oavu gareavi toko rovu toupaiveira oa oiso vaisipaiveira, Betesda vo Hibru reo-ia. Uva voa vo rovu vatuaro-ia ovavaevu aue kiuvupa keparo toupaiveira. ");
INSERT INTO roo_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Uva vo keparo-a varao kiuvupa keparo oara-ia riro irara voosi irara, ora voearo vuri kokoto irara, ora voearo oearoa oisoa kerau upiaro iava kopiipaave. Uva auere voa oisoa tuepaoro toupaive vo osa ora vurevurepe uuko rovu. ");
INSERT INTO roo_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Aue iava uvare ovokirovu-ia Turaro Pauto reraaro purapurapato ensel oisoa varaparo vo rovu sovara iare vao toko rovu voava va vurevurepasa. Oire ra vo rovu vao ora vurevurepe. Ra iravu ira rovoro vo rovu sovara iare, vosa apeisi rera vaaro upia, oa iava vorevira vearoro. ");
INSERT INTO roo_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Uva va-a vao osa oisoa iravu voa toupareve vo kiuvu oupa kepa-ia. Ira vo upiaaro aue rutu-ia uvuiepa vo peva tau vo peva vatara ivaro rutu (38 ivaro). ");
INSERT INTO roo_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Uva voa Jisas vo gerepa kekereva. Osa iava rera-ia oiso tarairoepa, Riro kaekaevira rutu oisoa upiaparo. Oa iava Jisas oiso rera tavireva, “E oiso ruipapau ra va iava eva vii vo upiaaro vorevira vearovira karekeu?” ");
INSERT INTO roo_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Oire uva rera ro upiapato rera vo reoaro pukooro oiso puraroepa, “Turaro. Viapau oiso irai ra ragaivi siporeve uuko rovu sovara-ia ragai tovosa vosa ora vurevurepe. Ari ragaivi raga ora akeake ragaparaveira oiso ra avara. Vo ovusa oearovu ragai-ia putepaoro voare ava rovopaave.” ");
INSERT INTO roo_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Uva oisi-a eisi osa iava Jisas rera tavireva oiso, “Toreu. Ra urua ouoro vava vokari.” ");
INSERT INTO roo_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Oire uva ikauvira raga rera iava varaua vearo ovoiepa. Oa iava vokareva urua ouoro vao rera vaaro vava avasa. Oire uva Sabat voki-a vao. ");
INSERT INTO roo_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Oa iava Jiu rerare ro ira vorevira poreteroepa oiso puraaepa, “Auoro. Sabat voki-a vao. Oa-ia viapau rutu uvui iraopauei ra ora vii vo uruaro kaepari vo voki-ia vao Tugoropa.” ");
INSERT INTO roo_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Oa iava voeare oiso puraroepa, “Easi ro-a ira ragai vorevira porete pierevoi ira oiso ragai tavirevoi, Vii uruaro ouoro vava vokari.” ");
INSERT INTO roo_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Oa iava rera akeiva oiso, “Iroutoa rutu-a ira vii tavirevoi oisi osa iava vii vaarova urua ouoro vava vokari, raa?” ");
INSERT INTO roo_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Oire uva rera ro ira vorevira poreteroepa ira viapau oiso taraiparoepa. Uvare riro irara rutu oirara oea-ia ora riroirooro Jisas avaroepa. ");
INSERT INTO roo_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Uva utupa visivi Jisas rera tavireva Tugoropa Kepa-ia Tempel rera kekeoro oiso, “Uvuri. Vorevira poreteue. Uva viapau rutu uvuipauei ra ita vorevira vuria vai purari ita. Viapau rutu. Teapi pute pie upia vai rutu ita vii-ia karekepe.” ");
INSERT INTO roo_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Osa iava avaroepa Jiu tavisa oiso, “Rera-a ro oirato ira ragai vorevira porete pierevorao aue Jisas.” ");
INSERT INTO roo_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Oire uva oisi-a eisi osa iava rovoaepa rera Jisas vuri piepaoro, uvare Sabat voki-a oa-ia va eva purareva. ");
INSERT INTO roo_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Uva Jisas voeare oiso puraroepa, “Aite oaa vokiara rutu-ia kovopareveira. Osa raga ita ragai tapo kovopaavoi ita.” ");
INSERT INTO roo_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Uva va-a vao oa iava voea Jiu oiso vovoupaaepa rutu ra Jisas kopii pieive rera upooro. Eake iava? Uvare viapau oiso vao ragapa-a Sabat voki vo taisiaro reo goru. Ari aue tapo uvare oiso puraroepa, Pauto-a rera rutu Aitetoaaro. Uva vo reo-a eva oa-ia oiso rutu rera raga ora kareke pieparoepa Jisas, Oiso rutu toupare osa Pauto. ");
INSERT INTO roo_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Oire uva Jisas voeare oiso puraroepa ora rera iava, “Oiraopavira rutu oiso-ia osa visii tavipaavoi, Viapau uvuiparai ra ora ragai vo vovouaro iava oavu avu vai puraa. Viapau rutu. Ari vao raga-a oa purapaa oa kekeava ovusa Aitetoa oaa va purapareva. Oire ra ragai tapo ita rera Oviitoaaro ragoa uvuiparai oisi raga va purapaa. ");
INSERT INTO roo_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Aite ruipa iraoroepa ragaipa, ra va iava ragai kareke piereva varao iava oara purareva. Uva ita, ragai tavirevere okovorovu iava ita riropara rutu oara varao-ia putepaivere rutu. Ra va iava rirovira rutu rugorugoo iraopata vara-ia tavetavepaoro. ");
INSERT INTO roo_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Aite ro ira kopii irara vorevira tootoo piepaoro voea vatepareveira tootooa vorevira. Uva oisi raga ita-a eisi osa oearovu vatepaavoi tootooa vorevira voeaopa oea reesipaaveira ora ragaipa. ");
INSERT INTO roo_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Aite viapau irai rovirieipareveira taavaa vai-ia kort. Oara rutu varao rovirieia purapa kovoro oara vatereva ragaipa. ");
INSERT INTO roo_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Oa iava oirara rutu uvui iraopaai ra ragai vaisiaro kae piepaive osa raga ita oiso uvuipaai osa Aiteto vaisiaro kae piepaiveira. Ro ira viapau ragai vaisiaro kae piepareve, eera ira viapau Aite vaisiaro kae pieparevoi ro ira ragai arureva vore rasito puaaro-ia. ");
INSERT INTO roo_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Oiraopavira rutu oiso osa visii tavipaavoi oiso, Ro ira ragai vo reoaro uvupareve, eera-a ira ro oirao piepareve ita ira ragai arureva oa iava urioraera, ira-ia Tootoo Ovoi toupaiveira rutu. Ira ita viapau oiso kortua-ia karekeroverea. Viapau. Ari ira kopiia-ia puterevora vore ivirooro Tootoo Ovoi vo raivaaro-ia. ");
INSERT INTO roo_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Oiraopavira rutu oiso osa visii tavipaavoi oiso, Vo vuuta-a vao oa karekesa auepapeira. Uva vo vuuta-a vao oa karekeiei vo vokia-ia oa-ia kopii roro tou irara Pauto Oviitoaaro gisipoaro uvuivere. Oire ra voea evoea ragai vo reoaro uvuoro tootooave rutu. ");
INSERT INTO roo_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ari Aite-a Tootooa rutu vituaro, uvare rera raga ita. Oa iavirava gorua vatereva ragaipa rera Oviitoaaro. Oire uva ragai tapo ita oisi raga ita toupaavoi osa rera, Tootooa rutu vituaro. ");
INSERT INTO roo_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ragai-a vao Oirato Oviitoaaro ragoa roporeva Pauto. Oa vituaro iava Aite ragai vatereva reesia oirara rutu rovirieipasa taavaa-ia kort. ");
INSERT INTO roo_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Visii vao opeita rugorugoo iraopata vaore oa oiso purapai, Tutuuvoi vo vuutao oa-ia oirara rutu tova uruiro iava ragai gisipoaro uvuiverea. ");
INSERT INTO roo_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Uva tova uruiro iava kosipaa piroverea voeao oea vearo pitupituro purapaiveira. Oea vorevira toreaverea taru Tootoo Ovoi rutu ousa. Ari voeao oea vuri pitupituro purapaiveira oea tapo ita vorevira toreaverea voea vo pitupituroaro vo voriaro ousa taavaa-ia kort. ");
INSERT INTO roo_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Viapau rutu uvuiparai ra oavu avu vai puraa ora ragai vo vovouaro iava. Vo reo oa uvuava Aite ruvara-ia oreoa-a eva raga ita sirova utuparaverea oirara rovirieipaoro kortua-ia. Uvare ragai vo rovirieiaro-a torevokoa rutu. Uvare viapau oiso ora ragai raga vo ruipaaro sirova utuparaveira. Ari ro raga vo ruipaaro sirova utuparaveira ira ragai arurevora vore. ");
INSERT INTO roo_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Vosa ora ragai raga vo reoaro iava siposipopaa, ra va iava vo reo eva viapau oiso oiraopape. ");
INSERT INTO roo_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ari iravu toupare ro Aite ira uvuiparoi ra ragai vo reoaro iava oiraopavira rutu siposipopareve. Taraiparai oiso, Rera vo reoaro oiraopai ragai iava, eisi osa oiraopai rutu. ");
INSERT INTO roo_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Voari tuariri Jon iare oreovu sipotavora ragai iava akesa. Oa iava oiraopa reo rutu iava siposiporevora. ");
INSERT INTO roo_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ragai viapau oiso rerare rugorugoo iraoparai rutu, Irouto ro ira ragai iava siposiporevora. Viapau. Ari oiso ruipa iraoparai ra Pauto visii vorevira oureve. Eisi osa iava vo reo puraavoi vo reo iava Jon vo reoaro oisi osa ra rera vo reoarore rugoopata. ");
INSERT INTO roo_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon oiso tourevora osa vuravu aviavipava. Osa iava eisi oirarapa aviavia vaterevora. Oire uva oisi iava visii iava sopaura vearoepa. Oa iava poteku vuutavi-ia rorutavora rera vo aviaviaro-ia. ");
INSERT INTO roo_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Ari oaravu epao oara Jon-ia putevoi vo osa ragai iava oiraopavira siposiporevora. Oara oiso toupai, Varao kovoara oara vaterevora Aite ragaipa oisore ra vara purapaa. Oara iava evara oirara tavipaiveira ra oiso taraipaave, Aite ragai arureva oa iava urioraepa. ");
INSERT INTO roo_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Uva Aite tapo ira ragai rutu iava siposipoparevora. Ari viapau oisoa rera gisipoaro uvupata gare visivi. Viapau rutu. Ora viapau oisoa rera puaaro kekepata. ");
INSERT INTO roo_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Uvare tapo rera vo reoaro viapau visii sopaaro-ia toupaiveira. Eake iava? Uvare viapau eera vo reoaro oirao piepataveira Aite ira ragai arureva. ");
INSERT INTO roo_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ari ita, riro goruvira rutu Pauto vo rigatoaro aue Tugoropa Vuku vieipaoro va-ia tarai iraopataveira oiso rugorugoopaoro, ra oisi va iavirava Tootoo Ovoi oupata. Origatoa raga-a eva oa ragai rutu iava viaevira rutu siposipopaiveira, ");
INSERT INTO roo_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","vo osa ragai iare urio arapa reasipataveira vo Tootoo eva oupa arapa. ");
INSERT INTO roo_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Viapau oiso ruipaparai ra irai ragai rei vaisi piepareve vova oirara. ");
INSERT INTO roo_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ari visii-ia taraiparaveira visiigoa sopaaro-ia Pautoa-pa siraopa vovou viapau toupaive. ");
INSERT INTO roo_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Aite oaa vaisiaro-ia urioraera. Uva viapau ragai vo reoaro uvupataveira. Vosa irai urioro vo ora irai raga vaisiaro-ia, ra irai vo reoaro uvuta. ");
INSERT INTO roo_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Visii vao visiigoa oearovu raga ruvara-ia vuurapa vaisipa ruipapataveira. Vo osa viapau oiso rugoopata oiso, Vearopai vosa oai purape ra va iava Kataitoa raga Pauto ruvara-ia vuurapa vaisi oupe. Oire uva apeisi ragavira-a oiso osa iava uvuipatai ra ragai oirao pie iraopata, raa? ");
INSERT INTO roo_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Viapau oiso ra ragai-ia rugorugoo ragapata oiso, Visii iava gasiaverea Aitepa. Viapau. Ari ro raga Moses ira oirao piepataveira oiso, Ira visii tauvareverea, ira-a eera ira visii iava gasireverea. ");
INSERT INTO roo_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Vosa rera vo reoaro oirao pietavori Moses, oire ra oisi ragavira ragai oirao piepatavori tapo. Eake iava? Uvare rera-a eera ira ragai iava vo reo rigatoreva. ");
INSERT INTO roo_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ari vosa viapau vo reo oirao piepata oa rigatoreva, ra apeisi ragavira ragai vo reoaro oirao piepata, raa?” ");
INSERT INTO roo_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Uva vo reo opesieiva, Jisas toko rovu iava ovaratavu iare urioroepa. Vao toko rovu Galili-ia oa vaisipaiveira ovaisivu iava vao oiso, Taibirias. ");
INSERT INTO roo_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Uva riro irara rutu riro ravotoro kekeiva oara purareva upiapa irara-ia. Osa iava rera sirova utupaaepa. ");
INSERT INTO roo_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Uva-a vo uva Jisas iparoepa pukuia iare. Oa iava voa pauroepa igei tapo ae disaipel. ");
INSERT INTO roo_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Oire uva Tagausapa Vurei Pasova vo vuutaaropa tutuu pieepa oiso ra karekepe. Evo voki-a Tugoropa Voki Jiu vaaro. ");
INSERT INTO roo_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Uva Jisas vuravurapareva. Oa iava riro irara rutu oirara kekereva ovusa utupaaepa rera iare. Osa iava Filip akereva oiso puraoro, “Ovu-ia breteara vai voripai voeaopa oirara, ra oarai aioive?” ");
INSERT INTO roo_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Uva oisi-a eisi osa Filip akeakeparoepa vo osa rera raga taraiparoepa vao-ia oa purapare rara. ");
INSERT INTO roo_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Uva va-a vao oa iava Filip rerare oiso puraroepa, “Vosa aue-ia erao vovoto kina (K200) bret vorivio, ra pasi viapau vai voea-ia uvuipe vo osa garepa visivi ouave voea voeao-ia.” ");
INSERT INTO roo_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Uva iravu disaipelto Andru aue araokotoaaro Saimon Pita, ira oiso puraroepa rerare, ");
INSERT INTO roo_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Iravu viovokoto ira vo touparevoi ira varaaro vo vavae epao bret ora vaiterei ataritoarei. Ari ita, uva viapau vai uvuipai pasi voea-ia voeao-ia riro irara rutu.” ");
INSERT INTO roo_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Oa iava Jisas oiso puraroepa, “Voea tavita, ra pauave evoa isiso kou ivara-ia.” Uva voea rutu uvuiaro-a voeao-ia oiso-ia, vo vavae tuku rutu uvuiaro (5,000). Uva voa-a evoa uva pauaepa. ");
INSERT INTO roo_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Oa iava breteara ouoro Jisas vara-ia vearo vaisi purareva. Oa iava voeapa oirara vara roo piereva. Uva oisi raga ita ataritoarei piereva voea roo pieoro, voea vo ruiparoaro uvui pieoro. ");
INSERT INTO roo_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Uva uvuivira aioivoiva, igei disaipel tavireva oiso, “Aio ururukoro guruta evara oara touvira toupaivoi. Teapi oarai opesiko ragape.” ");
INSERT INTO roo_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Oa iava vara guruguruiova. Uva katai tau erao (12) pekuriara agasiepa vo vavae iava vao bret vo ururukoro-ia oara iava aiooro vukuaepa. ");
INSERT INTO roo_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Oire uva vo ravoto vao kekeivoiva, voea oiso puraaepa, “Oiraopavira rutu rera-ia ro-ia, Profetato ira vo rasio iare urioroera irare tuepavioveira.” ");
INSERT INTO roo_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Uva Jisas voea-ia tarairoepa oiso, Rera ousa uriopaai ora voeapa, ra oiso toupareve, Voea reraaro reito king. Uva va-a eva oa iava rera raga pukuia iare voreroepa. ");
INSERT INTO roo_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Oire uva vuri eveveia-ia Jisas voeaaro disaipel igei toko rovu iare varaiepa. ");
INSERT INTO roo_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Uva uvuoa-ia kaeio viropa. Oa iava va-ia toko rovu ivara-ia avaiepa, uvare oiso vovoupaiepa ra Kapaneam iare avaio. Uva rupaepa ovusa Jisas voa igei iare pou viro asavira toureva. ");
INSERT INTO roo_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Uva voa riro gorutoa rutu kiuvu purepato igeire vusireva. Ira uuko rovu sigasiga piereva. ");
INSERT INTO roo_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Uva voa rera-ia tuepaoro avapaiepa aue uvuiaro-ia vo peva vuuta, eke vo resura vuuta rutu-ia (6 kilomita). Uva voava ora poreiepa Jisas aivaro rera kekesa, ovusa toko rovu ivara-ia vokapaoro utuparoepa. Uva voa-a vo uva uvuoa iare tutuu pierevoiva, uriripaiepa. ");
INSERT INTO roo_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Oa iava voa igeire oiso puraroepa, “Asi ragai-a vao. Ragoa visii iare uturai. Opeita uriri ragapata.” ");
INSERT INTO roo_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Oire uva voare uvuoa-ia rera kae pieoro rera-ia rorupaiova ovusa ikauvira uvuoa vo pou piropa uvare avapaiepa. ");
INSERT INTO roo_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Uva vokipavira voea oirara touvira toupaiva iviropa varata-ia vao toko rovu iava. Uva Jisas viapau vo uvuo-ia kaero viropa igei tapo disaipel. Viapau. Ari igei raga vo uvuo-ia ipaiepa avaoro. Eisi osa iava oirara taraiaepa, uvare katai uvuovi raga oa voa touva. Oa iava Jisas viapau voea tapo avaroepa va-ia. ");
INSERT INTO roo_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ari ita, vo osa oaravu uvuoara Taibirias iava vara voavi ruvara iare vera piropa vovio uva Turaro breteara-ia vearo vaisi purareve, vao oa aioiva. ");
INSERT INTO roo_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Oire uva voea oirara rutu roroaepa Jisas-re ora disaipel. Uva viapau oiso voea kekeiva osa voa toupaiva. Oa iava ipaaepa uvuoara-ia Taibirias iava oara-ia urioaepa. Uva aue iare Kapaneam-ia avaaepa rerare Jisas voa taraasa. ");
INSERT INTO roo_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Oire uva rera Jisas kekeiva iviropavira toko rovu-ia. Oa iava rerare oiso puraaepa, “Tisato. Aa vo vuutao iava vo vokio-ia vore uriouei?” ");
INSERT INTO roo_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Oa iava Jisas oiso puraroepa, “Ragai oiso oiraopavira visii tavipaavoi, Viapau oiso ra varare varao rugorugoopata ravotoara oara keketavo oa iava ragaire taraapatavoi. Viapau. Ari oa aiotavorao ita eva bret oa iava visii iava kovuara vukuerao. Eva-a oa vituaro iava ragaire taraapatavoi. ");
INSERT INTO roo_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Viapau oiso ra kovopata vo aio eva oupasa oa vuripapeira. Viapau. Ari vo aio ou iraopata oa vokiara rutu-ia toupaiveira. Eva-a tootooa vo aioaro, oa vokiara rutu-ia toupaiveira vearovira. Vo aio Oirato Oviitoaaro ragai oa vateaverea visiipa. Aue iava uvare Pauto Aite ragaipa reesia vatereva.” ");
INSERT INTO roo_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Oa-a eva oa iava rerare oiso puraaepa, “Eake vai uvuipai ra oai puraio, ra Pauto vo kovoaro puraio?” ");
INSERT INTO roo_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Oa iava Jisas voeare oiso puraroepa, “Pauto vo kovoaro oiso toupai, Visii ro oirao pie iraota Pauto ira ragai arurevora vore.” ");
INSERT INTO roo_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Oire uva rera akeiva oiso puraoro, “Eake-a reesia oa kekeiovere vii-ia, ra vii oirao pieio. Ora tapo eake kovo-a vao ravoto kovo oa purarivoi, ra va kekeiovora, vii vo reoaro oirao pieio? ");
INSERT INTO roo_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Vigei aao iraraaro aue aioiva kuvau tapi mana voari tuariri rutu oiso osa Tugoropa Vuku purapai. Uvare vuvuiua iava vo bret vatereva voeapa oa iava va aioiva.” ");
INSERT INTO roo_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Uva oisi-a oiso osa iava Jisas voea tavioro oiso puraroepa, “Oiraopavira rutu oiso osa visii tavipaavoi, Viapau oiso Moses visii vatereva bret vao vova vuvuiua-ia. Viapau. Ari Aite rutu-a ira oiraopa bret vatepareveira vova vuvuiua-ia visiipa. ");
INSERT INTO roo_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Vao bret Pauto oa vateparevora, Ro ira vuvuiua kavuoro vararoepa oirarapa tootooa vatesa voeao vo rasio-ia.” ");
INSERT INTO roo_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Oa iava rerare oiso puraaepa, “Turaro. Igeipa va eva bret vateri vokiara rutu-ia.” ");
INSERT INTO roo_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Oa iava Jisas oiso voea tavireva, “Ragai raga-a ita bret vao Tootoo Vatepa. Ari ro ira ragai iare urioro ira viapau oiso uvuiparoi ra ogoero vorevira. Ora vosa ro ira ragai oirao piepareve ira ita viapau oiso uvuiparoi ra vorevira uuko regaro ita. ");
INSERT INTO roo_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","“Ari ita, visii tavipaavoi, Ragai kekepatavoi ovusa viapau oiso ragai-ia oirao piepataveira. ");
INSERT INTO roo_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Oiraravi voeao Aite ragaipa oeavi-a vatereva, oisore ra voeavi rutu ragai iare uriopaave. Oire vosa ro ira ragai iare urioro, irare viapau uvuiparai ra rerare isivapara. Viapau rutu. ");
INSERT INTO roo_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Aue iava uvare ragai-a vao ragoa vuvuiua iava vararaera vore. Uva viapau oiso ora ragai raga vo ruipaaro sirova utusa-a. Viapau. Ari ragai vararaera ro vo ruipaaro sirova utusa ira ragai arurevora vore oa iava urioraera. ");
INSERT INTO roo_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Uvare ro vo ruipaaro-a ira ragai arurevora, vao oiso ragavira viapau uvuiparai ra oearoi kavua voeao rutu iava oea vatereva Pauto Aite ragaipa. Viapau. Ari oea rutu ita evoea vorevira tore pieaverea voea tootoo pieoro vo Ovoiopa Voki-ia. ");
INSERT INTO roo_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Aite oaa vo ruipaaro oiso toupaiveira, Oirara rutu voeao oea Oviitoa oaa kekepaoro rera oirao piepaive oea uvuipaai ra Tootoo Ovoi oupaive vao oa viapau opesia vai. Evoea oea vorevira tore pieaverea voeapa tootooa vateoro Ovoiopa Voki-ia. ");
INSERT INTO roo_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","“Ragai raga-a ita vao bret ragoa vuvuiua iava vararaera.” Uva oisi-a oiso osa puraroiva, Jisas Jiu-pa irara kasipu iraopaaepa. Oa iava rirovira rutu reoreopaaepa. ");
INSERT INTO roo_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Uva oiso purapaaepa, “Avoeao! Eaketoa vai irao-a rera ro-ia Jisas Josep oviitoaaro? Ari ita, vigei rutu tarai iraopavioveira aitetoarei-ia ora aakova. Uva eake vai iava oiso puraroi, Ragai vuvuiua iava vararaera?” ");
INSERT INTO roo_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Uva Jisas voeare oiso puraroepa, “Teapi rirovira rutu ora reo ragapata ora visii raga vuutaaro-ia. ");
INSERT INTO roo_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Viapau rutu irai uvuiparoi ra ragai iare urio ragaro. Viapau rutu. Easi Aite raga-a. Vosa irai ivureve vo ragai iare, oire ra rera-a eera urioro ragai iare. Uva rera ita-a eera ira vorevira tore pieaverea taru voari Ovoiopa Voki-ia. ");
INSERT INTO roo_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Vo reo toupaivoi vo vukuo-ia profet irara vaaro oiso, ‘Pauto oirara rutu tarai piereverea.’ Oire ra voea rutu rera uvuive vo rera ruvara-ia Aite taraia ouoro. Ra va iava ragai iare uriopaave. ");
INSERT INTO roo_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“Viapau oiso irai Aite kekereva. Ari ragai raga-a ragoa Pautoa tapo oisoa toupaa ragoa urioraera. Uva ragai raga ita-a ragoa Aite kekeava. ");
INSERT INTO roo_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Oiraopavira rutu oiso osa visii tavi iraopaavoi oiso, Vosa ro ira ragai oirao piepareve, eera-a ita ira-ia Tootoo Ovoi rutu toupaivoi. ");
INSERT INTO roo_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ragai raga-a ita bret Tootooa Vatepa. ");
INSERT INTO roo_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Tuariri aao irara oavisii mana aioiva kuvau tapi uva raga-a vo uva kopiiaepa voari tuariri. ");
INSERT INTO roo_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ari bret oa vuvuiua iava varaepa. Vosa irouto ro ira va iava aio ruipaparo, ira viapau uvuiparoi ra kopiiro. ");
INSERT INTO roo_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ragai raga-a ita bret vao Tootoo Vatepa ragoa vuvuiua iava vararaera. Vosa irai va vao bret iava aioro, ira uvuiparoi ra tootoovira toupareve ovoieivira rutu. Oa-a vao bret uvuiparai ra rera vatea vao-ia ragai iava varaua. Oua vatepaavoi oirara rutupa voea vo rasio-ia ra tootoovira toupaive.” ");
INSERT INTO roo_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Oire uva va-a vao oa iava voeao Jiu ora voea raga ora kaureopaoro oiso purapaaepa, “Eaketoa vai-a ro ira uvuiparoi ra ora rera iava varaua vatereve vigeipa? E uvuiparoi ra ora rera iava voua vatereve, ra voua aiope rera iava, raa?” ");
INSERT INTO roo_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Oa iava Jisas oiso voeare puraroepa, “Oiraopavira osa visii tavipaavoi, Vosa viapau Oirato Oviitoaaro iava varaua aiota, ora vosa viapau ragai revasiaro-ia ukaiota, ra viapau Tootoo Ovoi outa. ");
INSERT INTO roo_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ari ro ira ragai iava varaua aioreve ora ragai revasiaro-ia tapo ukaioro, ira tootooparoverea vokiara rutu-ia. Ora ira vorevira tore pieaverea Ovoiopa Voki-ia rera tootoo pieoro. ");
INSERT INTO roo_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Eake iava? Uvare ragai iava varaua-a oiraopa rutu aioa. Ora revasiva oiraopava rutu ukaiopava. ");
INSERT INTO roo_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ro ira ragai iava varaua aioreve ora ragai iava revasiva-ia ukaioro, ira ita-a eera ragaiva ora tavosivira rutu toupare, ovusa ragai rerava ora tavosivira rutu tapo toupaavoi. ");
INSERT INTO roo_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Aite ira tootoovira toupareveira ira ragai arurevora oa iava urioraera. Oa iava ragai Aite vo goruaro-ia tootoovira toupaavoi. Osa-a eisi osa uvuiparoi ro ira ragai iava varaua aioreve, oire ra va iava tootoovira toupareve ragaiva ora tavosipaoro. ");
INSERT INTO roo_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Vao bret oa vuvuiua iava varaepa oa viapau oiso vo bretova vaeavira toupaivoi oa aioiva vigei aao iraraaro tuariri. Oa iava kopii ovoiaepa. Viapau. Ari vosa ro ira vo breto aioreve, ira-a eera uvuiparoi ra vokiara rutu-ia tootooparo.” ");
INSERT INTO roo_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Vo Jisas voea siposipopareva Reo Taisi Uvupa Kepa Sinagog sovara-ia vo Kapaneam-ia uva reo eva vatereva voeapa. ");
INSERT INTO roo_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Oire uva riro irara disaipel vo reo vao uvuiva. Oa iava oiso puraaepa. “Vo reo vavagisi iraopai. Irou vai uvuipai ra vo reo uvuve?” ");
INSERT INTO roo_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Vo osa ora rera iava sopaua-ia voea-ia tarairoepa Jisas oiso, Vo reo iava vao disaipel rirovira rutu oiso ora reopaai. Uva va-a vao oa iava voeare oiso puraroepa. “Evo reo ragai vo reoaro visii vo rugorugooroaro vuri piepaivoi, raa? ");
INSERT INTO roo_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ari vosa Oirato Oviitoaaro ragai tueta ovusa ipara vore uva oisoa toupaave tuariri, ra apeisi? ");
INSERT INTO roo_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Urauratoa raga tootooa vatepareveira oiratoapa. Varaua-a viapau oiso Tootoo Ovoi vituaro-a. Ari vo reo oa vateavoi visii vo urauraroaro aio piepasa. Oa iava uvuipai ra visiipa tootoo vatepaive vo reo. ");
INSERT INTO roo_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Osa oearovu visii vuutaaro iava vo reo vao viapau oirao piepaivoi.” Ari ita, Jisas voea-ia tarai ovoiroepa oea viapau rera vo reoaro oirao piepaiva. Ora tapo osa ro-ia tarairoepa ira keripa irarapa rera kosi piereve. ");
INSERT INTO roo_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Oa iava oiso puraroepa. “Ari ita, va raga vituaro-a vao oa iava visii taviavo oiso. Vosa Aite viapau oirato oisi piereve, ira viapau uvuipa ra ragai iare urioro.” ");
INSERT INTO roo_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Oreoa vao vituaro iava riro irara disaipel irara Jisas kavuoro sikaa viropa. Oa iava viapau oiso rera tapo vorerivira touiva. ");
INSERT INTO roo_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Oire uva Jisas igei katai tau erao (12) akereva oiso, “E visii vai tapo ragai kavuoro avapatai?” ");
INSERT INTO roo_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Oa iava Saimon Pita oiso puraroepa, “Turaro. Ra irou iare avaio? Uvare vii raga-a viigoa-ia Tootoo Vatepa Reo toupaivoi. ");
INSERT INTO roo_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Uvare igei vii raga-ia vovouisi oaio tovoiova vii raga oirao piepaoro. Uvare ita vii raga-ia taraiiepa oiso, Vii-a Tugoropato Pauto reraaro rutu.” ");
INSERT INTO roo_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Osa iava Jisas oiso igei akereva, “Apeisi ragavira iava visii katai tau erao (12) oiso ropooro visii reesiavora, ovusa iravu epao visii vuutaaro-ia vurito ira ragaiva keripa?” ");
INSERT INTO roo_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Auere oiso puraroepa Judas Saimon oviitoaaro Iskariot. Eera-a iravu igei iava vao katai tau erao (12) disaipel. Aue iava uvare rera-a eera ira utupavira Jisas kosi piereve voeaopa oea rera upoive. ");
INSERT INTO roo_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Oire uva va vao opesieiva, Jisas oiso ragavira vokareva Galili taere-ia. Uva aue Jiu rera uposa auepaaepa vo Judia-ia. Oa iava voare ava arapa reasiparoepa. ");
INSERT INTO roo_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Uva va vao Tugoropa Voki Jiu vaaro oa oiso oisoa vaisipaive Oovapa Voki aue-ia Rovopa Kuero-ia. Ovoki-a vao oapa tutuu pieepa. ");
INSERT INTO roo_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Uva oisi-a eisi osa iava araoko irara rera arupaiva oiso, “Vo uruio iava avau Judia Distrik iare. Ra voa vii voeaaro disaipel vo kovoro kekeive oara puraparivoi. ");
INSERT INTO roo_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ari ita, vosa irai oavu avu vai purasa aueparo, ra riro vaisi oureve vo oirara osireiaro-ia. Ra viapau oiso uvuiparoi ra vatau tapi vai oai purareve. Oire vosa oiso varao puraparivoi, uva uvuipauei ra viaevira rutu torepau oirara rutu osireiaro-ia.” ");
INSERT INTO roo_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Uva voea tapo-a araoko iraraaro oea oisoa viapau rera oirao piepaive. Oa iava oisi eisi puraaepa. ");
INSERT INTO roo_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Va-a vao oa vituaro iava Jisas oiso voeare puraroepa. “Ragai vo vuutaaro tugura asavira toupaivoi oa-ia ragai vaisiaro karekeavere. Ari visii raga vo vuutaroaro-a varao-ia. ");
INSERT INTO roo_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Voeao oirara rutu vo rasio-ia viapau uvuipaai ra visiiva ora keripaave. Ari ragai ragava ora keripaaveira. Eake iava? Uvare vo pitupiturore reoreoparaveira vuriara oara purapaiveira vurivira rutu. ");
INSERT INTO roo_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Uva oiso visii tavipaavoi, Visii raga avata voare evoa Oovapa Voki-ia. Ari ragai viapau oiso va iare eva Oovapa Voki avaparai. Aue iava uvare ragai vo vuutaaro tugura asavira toupaivoi.” ");
INSERT INTO roo_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Osa oiso-ia voea tavireva. Oa iava vo raga Galili-ia toureva. ");
INSERT INTO roo_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Uva voea Jisas araoko iraraaro avaaepa Oovapa Voki kekesa. Oa iava rera tapo voare uturoepa vatauvira. Viapau oiso viaevira voare iparoepa. ");
INSERT INTO roo_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Uva va-a vao osa voea Jiu rerare taraa ragapaiva va-ia vao Oovapa Voki oiso puraoro, “Ovu irao ro epao?” ");
INSERT INTO roo_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Voea rutu rirovira rutu rera-ia ora reopaaepa. Uva oearovu oiso purapaaepa, “Avoeao. Asi vearoto-a eera.” Ovusa oearovu oiso purapaaepa, “Viapau. Ari oirara rutu keakea iraopareveira eera.” ");
INSERT INTO roo_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Vo osa oearovu Jiu-pa irarapa uriripaoro vatau visivi raga rera-ia ora reopaaepa. ");
INSERT INTO roo_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Uva vo voki rutu-a vao Oovapa Voki oa vo vuutaaro-ia Jisas Tugoropa Kepa iare iparoepa oirara rutupa siposiposa voa. ");
INSERT INTO roo_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Osa iava voea Jiu iava voea reipa irara rirovira rutu oiso rugorugoo iraopaoro oiso puraaepa, “Eake rutu-a vao oa iava rera vo vukuara vieiparevoi. Viapau oiso taraia vai oureva rera ro oiso osa voeao tarai irara rutu tisa irara.” ");
INSERT INTO roo_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Oa iava Jisas voeare oiso puraroepa, “Vo reo oa vatepaavoi visiipa viapau oiso ragai raga vo reoaro-a. Viapau. Ari Pauto vo reoaro-a ro ira ragai siporevora ragai aruoro. ");
INSERT INTO roo_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Vosa irai Pauto gisipoaro sirova utu ruipa iraoparo, ra ragai vo reoaro iava vao tarairo oiso, Oiraopavira vo reo Pauto iava poupa piroi, eke ora ragai raga vo vovouaro iava oiso reoparai. ");
INSERT INTO roo_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ro ira ora rera raga vo vovouaro iava reoreoparo, ira-a eera oiso vovoupa ra ora rera raga ora vaisiaro kae piepareve. Ari vosa ro ira roari vaisiaro kae pie ruipaparo ira rera siporeve, ira-a eera torevokoto. Ira-ia viapau vuria vai toupai. ");
INSERT INTO roo_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“Tuariri Moses visii vatereva Reo Taisi. Uva apeisi iava viapau irai visii iava viapau vo taisi sirova utuparoveira? Eake-a vao oapa ragai kopii piesa auepatai, raa?” ");
INSERT INTO roo_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Oa iava rerare oiso puraaepa, “Iravuei vurito uraurato vii-ia. Uva irou vii uposa auepai, raa?” ");
INSERT INTO roo_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ua Jisas voeare oiso puraroepa, “Ari ita, vo kovo-ia tavetave iraopatavoi vao-ia, Oirato vorevira porete pieavo vo Sabat voki-ia. Oa iava rirovira rutu rugorugoo iraopatai eisi. ");
INSERT INTO roo_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Easi Moses visiipa rakari verapa pitupitu vatereva. Opitupitua-a eva oa viapau Moses iava kosi piropa. Oa-a eva voeari iare vigei aao iraraaro karekeepa. Uva visii kakae vure rakariaro rooroopaoro voea rakariaro verapataveira vo voki-ia eva Sabat voki, vosa vo voki-a eva rakari verapa voki rera vo vokiaro kakaeto. ");
INSERT INTO roo_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Oiso rugorugoopataveira ra vearovira rutu Moses vaaro Reo Taisi sirova utu iraopata. Oa iava kakae vure rakariaro rooroopataveira va-ia Sabat. Oire uva voa-a vo Sabat uva ragai iravu oirato vorevira porete pieavorao. Uva eakepa ragaire kasipupatai, raa? ");
INSERT INTO roo_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Opeita orekerovu rovirieipata ora visii iava osireiara raga-ia oiso osa ragai piepatavoi. Ari uvui iraopatai ra oearovu sopaaro rutu-ia tarai rovopaoro voea vo rugooroaro kerikerisipata.” ");
INSERT INTO roo_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Oearovu Jerusalem iava oiso puraaepa, “E apeisi-a rera ro uposa auepaai, eke? ");
INSERT INTO roo_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Rera kekepata eera ira viaevira rutu reoreoparoi. Oa iava viapau oiso oreovu avu vai purapaivoi rerare. Easi pasi oiraopai rutu, uvare vai reipa irara taraipaai rera-ia oiso, Krais vai pasi, raa? ");
INSERT INTO roo_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ari ita, vigei taraipaviei rera vo uruiaro rutu-ia. Ari vosa Krais karekero, ra viapau irai taraiparo rera vo uruiaro rutu-ia.” ");
INSERT INTO roo_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Oire uva Jisas Tugoropa Kepa-ia Tempel toupareva voeapa siposipopaoro. Uva rirovira rutu gisipo karureva voeare oiso puraoro, “Ragai-ia taraipatai ita. Ora ragai vo uruiaro rutu-ia tapo taraipatai. Ari ita, osa viapau oiso ora ragai raga vo vovouaro iava urioraera. Ari Aitetoa oaa raga ragai arurevora, oa iava urioraera. Ira vo vovouaro-a oiraopa. Uva viapau visii rera-ia taraipatai. ");
INSERT INTO roo_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ragai ira-ia taraiparai uvare rera tapo oisoa toupaa rera voaaro. Oa iava voava ragai arurevora vore.” ");
INSERT INTO roo_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Uva oisi-a eisi osa iava rera tuukesa auepaaepa. Vo ovusa rera vo vuutaaro tugura asavira toupaiva. Oa iava viapau irai rera-ia vavaea vai tovoreva. Viapau. ");
INSERT INTO roo_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Uva riro irara rutu oisi iava rera oirao pieiva. Oa iava oiso puraaepa, “Vosa Krais pouro virovere, ra pasi riroara ravotoara vai purareve. Oara vai-a uvuipai ra vo ravotoro-ia puteve oara purarevoi ro-ia, eke?” ");
INSERT INTO roo_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Oire uva Farisi ratarataa vovou irara voea oea uvuiva uvare oirara rutu oreorovu rutu purapaiva rerare Jisas. Osa iava reipa irara Pris ora aue Farisi oearovu polis irara aruiva. Oa iava urioaepa oiso ra rera tuukeive Jisas. ");
INSERT INTO roo_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Uva va-a vao oa iava Jisas voeare oiso puraroepa, “Gare visivi visii tapo toupaavoi. Ra ro iare vorera ira ragai arurevora vore. ");
INSERT INTO roo_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Uva ragaire taraa ragapatavere. Ra viapau oiso ragai keketa. Ora viapau tapo oiso ra vo urui-ia pouta viro vao oa iare avaravere. Vao iava uvare viapau oiso uvuipatai ra voare avata.” ");
INSERT INTO roo_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Oire uva voea raga Jiu ora reopaaepa oiso purapaoro, “Ovu iare avarovere vo uva viapau rera kekeperea? Easi pasi vigei iavapa irara vai iare avarovere voeao oea vigei arova sikasikaaepa vorarore avaoro vo voea vo uruiroaro iare Grik-pa irara? Uva voea tarai pieparevere vai Grik, raa? ");
INSERT INTO roo_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Uvare oiso puraroi, Ragaire taraa ragapata. Ra viapau ragai keketa. Ora oiso tapo puraroi, Ra viapau voare avata vo uvare avaravere voa tousa. Uva aa vao-a vo reo vituaro, raa?” ");
INSERT INTO roo_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ovoiopa voki vaopa Oovapa Vurei, reipa voki rutu oa-ia Jisas toreroepa rirovira rutu reooro oiso purasa, “Vosa irai uuko regapaoro urioro, ira-a eera uvuiparoi ra urioro vo ukaiosa ragai. ");
INSERT INTO roo_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Oiso-ia osa Pauto vo rigatoaro oiso purapapeira, ‘Ro ira ragai oirao piepareve ira-a eera sopaaro-ia uuko ovi Tootoo Vatepa ovi karekepapere rera iava vusivusipaoro.’” ");
INSERT INTO roo_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Oire Jisas vo ruu reo purareva ro iava Tugoropato Uraurato ira ouiverea vo rara rera oirao piepaive Jisas. Uvare vo vokia-a eva oa-ia Jisas touvira keraria ou asavira toureva. Aue iava uvare rera eera Tugoropato Uraurato urio asavira toureva irare eisi puraroepa. ");
INSERT INTO roo_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Oire uva oearovu oisi eisi vo reo uvuoro oiso puraaepa, “Oiraopavira rutu rera-ia ro-ia profetato irare tuepavioveira.” ");
INSERT INTO roo_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ovusa oearovu oiso puraaepa, “Eera Krais.” Ari oearovu oiso puraaepa, “Ra viapau oiso Galili iava uriorovere Krais. ");
INSERT INTO roo_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Tugoropa Vuku taviepa Krais iava ro Devit voeaaro iava rera. Ira Betlehem-ia pouro virovere vo uruio-ia oa-ia tuariri Devit tou rovoreva.” ");
INSERT INTO roo_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Oisi-a eisi osa iavirava ora voearei-ia varei puraiva ora roo pieoro Jisas iavirava. ");
INSERT INTO roo_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Uva oearovu oiso vovoupaaepa ra rera tuukeive. Uva viapau oiso irai rera-ia vavaea vai tovoreva. ");
INSERT INTO roo_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Oire voea polis irara vorevira voreaepa reipa irararei iare Pris ora Farisi. Oa iava voeare oiso puraaepa, “Eakepa viapau rerava voretai?” ");
INSERT INTO roo_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Uva polis irara voeare oiso puraaepa, “Ari ita, voari tuariri uva viapau oisoa irai oiso reoparo osa ro reoparoi.” ");
INSERT INTO roo_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Osa iava Farisi voeare oiso puraaepa, “Easi visii vai tapo pasi keakeaparevoi, raa? ");
INSERT INTO roo_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","E pasi oearoi igei vai iava Farisi, o voeao iava reipa irara irai vai keketavo ovusa rera vo reoroaro oirao pieparevo, raa? Viapau. ");
INSERT INTO roo_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Uvare akuku iraravi raga-a evoea oirara oea Jisas vo reoroaro uvupaoro viapau taraipaai Reo Taisi-ia vao oa-ia vuria puraivoi Pauto osireiaro-ia, osa iava opesikoaverea rara.” ");
INSERT INTO roo_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Oire uva iravu-a ro-ia Nikodimas ira tuariri avaroepa Jisas iare. Voea iava rera, ira voeare oiso puraroepa, ");
INSERT INTO roo_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Esa vigei vaaro Reo Taisi oiso toupaivoi ra iravu iava akukuvira gasi ragape, eke? Uvui iraopaviei ra rera vo reoaro uvupe. Oire ra va iava vearovira tarai rovovio vao-ia oa pura rovoreve.” ");
INSERT INTO roo_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Oa iava rerare oiso puraaepa, “Easi vii tapo-a iravu Galili iava, raa? Vearovira rutu Pauto vo reoaro viei rovori, ra taraiu. Viapau irai profetatoa vai uvuiparoi ra Galili iava karekero.” ");
INSERT INTO roo_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Oire uva voea rutu oirara sikasikaaepa vorarore ora voea vo keparoaro avaoro, ovusa Jisas Oliv Kovo Pukui iare avaroepa. ");
INSERT INTO roo_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Oa iava vokipakou rutu voava vokiroepa Tugoropa Kepa iare vao Tempel. Uva riro irara rutu voa rera iare urioaepa. Oire uva paupaoro voea tarai piepareva. ");
INSERT INTO roo_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Uva voa-a vo uva riro tarai irara ora ratarataa vovou irara Farisi iriavuva riakova urioaepa rera iare. Aue iava uvare oira kekeiva iravu tapo. Oa iava ora voea vuruvuruaro rutu-ia oira tore piesa urioaepa. ");
INSERT INTO roo_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Uva oira iava Jisas tavipaoro oiso purapaaepa, “Tisato. O riakova iria ora oua vuri pieevo. Uva oeavu oira-ia poua viro osa eisi pieevorao. ");
INSERT INTO roo_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Vao-ia Reo Taisi Moses igei tavireva oiso puraoro, Vosa oiso iriavu riakova vuria puraeve, oire ra oira vurokope aue-ia aveke. Ra oisi iava eisi apeisi purau?” ");
INSERT INTO roo_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Oiso osa puraaepa rera-ia kokarapaoro. Uvare oiso vovoupaaepa ra oaire reoa vai taraaive rera-ia. Auere ra oreoi iava rera iava gasiive taru. Vo osa Jisas takuro viropa rasia-ia rigatopaoro ora rera iava sipareo-ia. ");
INSERT INTO roo_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Oire uva rera akepaiva voreripavira. Oa iava voava toreoro voeare oiso puraroepa, “Vosa irai visii vuruvuruaro-ia toupareve ro ira-ia viapau vuria vaipe, ira uvuiparoi ra rovova vai-ia aveke vai oira vuro rovoreve o-ia riakova.” ");
INSERT INTO roo_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Uva takuro viropa ita vo rasi rigatosa ita. ");
INSERT INTO roo_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Oisi uvuivoiva, voea rutu ora voea-ia vesipaoro kosikosia viropa oiso, reipa irara rovovira ira rovoaepa. Oa iava oearovu tupepaaepa utupaoro. Osa iava rera raga Jisas kavuiva. Uva rera raga oira tapo toupareva, ovusa torepaopa voari rera puaaro-ia. ");
INSERT INTO roo_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Oire uva Jisas toreoro riakova akereva oiso, “Ovu-ia oirara epao? E viapau irai epao vii iava gasiparevoi, raa?” ");
INSERT INTO roo_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Oa iava riakova oiso puraopa, “Reito. Easi viapau irai epao.” Oa iava Jisas oiso puraroepa, “Ari ita, ragai tapo viapau oiso vii iava gasipaavoi. Avau vova, ra viapau ita vorerivira oai vuria vai purari.” ");
INSERT INTO roo_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jisas voea tavioro oiso puraroepa, “Ragai-a rasitoapa aviavia. Ro ira ragai sirova uturo ira viapau uvuipa ra rupa-ia vokareve. Viapau. Ari aviavia-ia touparevoi vao Tootoo Vatepa vituaro.” ");
INSERT INTO roo_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Oa iava Farisi rerare oiso puraaepa, “Easi vii ora vii raga vo reoaro-ia siposipopariveira. Eva-a oa iava vii vo reoaro iava viapau oarai oirao piepaioveira.” ");
INSERT INTO roo_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Osa iava Jisas voeare oiso puraroepa, “Oiraopavira rutu ita. Ora ragai raga vo reoroaro iava siposipopaaveira. Ari ita, vo osa oiraopa reo rutu-a ita vao ragai vo reoaro. Eake iava? Uvare vo urui-ia taraiparaveira vao oa iava urioraepa. Oa iava vo urui-ia taraipaoro voare avaravere. Vo osa visii viapau voa taraipatai vo uva vo urui iava urioraera. Ora vo uva ragavira avaravere uva tapo viapau taraipatai. ");
INSERT INTO roo_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Visii vao visiigoa oearovivu oirara roviriei iraopataveira vo vovouo-ia vo rasio-ia. Ari ragai viapau irai rovirieipaaveira. ");
INSERT INTO roo_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ari vosa ragai irai rovirieia, oire ra torevokovira rutu irai rovirieia. Eake iava? Uvare viapau oiso ragai raga kataito. Viapau. Ari iravuei Aite, ro ira ragai arurevora. Ira ragai tapo kovopareveira. ");
INSERT INTO roo_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Vo visii vaaro-ia Reo Taisi oiso toupai, Vosa vaiterei katai reo raga iava siposipopasi, oire ra vaiterei vo reoaro torevokopape rutu. ");
INSERT INTO roo_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ari ita, ragai raga ora ragai iava siposipopaaveira ora vo osa Aite ragai arurevora. Ira tapo ragai iava oiraopavira tavitaviparoveira.” ");
INSERT INTO roo_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Oire uva voea rerare oiso puraaepa, “Ovu-ia vii Aitearo epao?” Oa iava Jisas voeare oiso puraroepa, “Viapau oiso ragai-ia taraipatai. Eisi osa viapau Aite oaa-ia taraipata.” ");
INSERT INTO roo_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Vo reo pukoreva Jisas monipa tugi-ia toupaoro. Vo osa oirara tarai piepareva voa evoa Tempel-ia. Uva oisi-a oiso osa iava viapau irai rera tuukepareva voa, uvare rera vo vuutaaro tugura asavira touva. ");
INSERT INTO roo_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jisas vorerivira oiso voea tavireva, “Avarai vore uva ragaire taraa ragapatavere. Ari ita, kopiipataverea visii varaarova vuriara oavisii, vo rara Aite viapau visii iava vara vera rovopareve. Oa iava viapau uvuipatai ra vo poupata viro uvare avaparai.” ");
INSERT INTO roo_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Uva va-a eva oa iava Jiu reipa iraraaro oiso puraaepa, “Apeisi ragavira eisi reoroi oiso, Viapau uvuipatai ra vo uruio iare avata oa iare avaparai? Asi evo reo vai porearo oiso vaio toupai, Ra rera raga ora uporo, eke?” ");
INSERT INTO roo_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Uva voeare oiso puraroepa, “Visii reroarova. Ari ragai viara iava. Uvare visii-a vao vo rasio iava. Ari ragai viapau vo rasi iava vao-ia. ");
INSERT INTO roo_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Osa iava visii taviavoi oiso, Kopiipatavere ovusa vuriara oavisii visii-ia touvira toupaive. Ari ita, vosa viapau ragai vo reoroaro oirao piepata vo uvare ora ragai raga iava visiipa siposipopaavoi. Oire uva oisi-a eisi osa iava vuriara oavisiiva kopiipatavere ovusa touvira visii-ia toupaive.” ");
INSERT INTO roo_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Uva rera akeoro oiso puraaepa, “Iroutoa irao-a vii?” Oa iava Jisas oiso puraroepa, “Ragai raga ita vao-ia oiso osa ora ragai iava tuariri visii taviavora. ");
INSERT INTO roo_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Riro reoro rutuva toupaavoi. Oara-ia uvuiparai ra visii vo pitupituroarore reoreora. Ora visii vo vovouroaro tapo rovirieia oiso osa jas ro reo rovirieipato. Ari ro ira ragai arurevora ira vo vovouaro-a oiraopa rutu. Ora vo reoro rutu oara uvuava rera ruvara-ia, evara-a oara iava siposipopaaveira oirara rutupa voeao vo rasio-ia.” ");
INSERT INTO roo_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Oire uva viapau roroioaepa. Vo uvare voea tavipareva Aitetoa iava. ");
INSERT INTO roo_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Uva osa-a eisi osa iava Jisas oiso voea tavireva, “Voari utupaua oiso Oirato Oviitoaaro kae pietavere rera kotosa. Uva vo vuuta-a eva oa-ia taraitaverea, Oiraopavira oisoa ora rera iava siposipopareve. Oire ra oisi iavirava taraita. Ari ragai viapau oiso oavu avu vai purapaavo ora ragai raga vo rugorugooaro iava. Viapau. Ari ragai vo reo iava siposipopaavo oa iava ragai tavireva Aite. ");
INSERT INTO roo_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Aite ragai siporeva ira ragai tapo toupareveira. Uva viapau oiso ragai kavurevora ra ragai raga toupaa. Viapau. Uvare vokiara rutu-ia varao purapaaveira oarapa ruipaparoveira.” ");
INSERT INTO roo_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Oire uva oisi-a oiso osa puraroiva, oirara rutu iava oearovu rera oirao pie iraoiva. ");
INSERT INTO roo_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Oire uva Jisas Jiu tavireve, voeao oea rera oirao pieiva oiso, “Vosa vokiara rutu-ia ragai vo reoaro vearovira uvupata, oire ra va iava visiipe oiso, Ragai rutu voeaaro disaipel. ");
INSERT INTO roo_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ra oisi iava oiraopa reo rutu-ia taraita. Oa iava oiraopa reo rutu uvuipai ra oiso visii pieve, Viapau uvuipatai ra akukuvira iraipa kovo ragapata. Oiso osa ro ira tuukepa kepa-ia toupareva.” ");
INSERT INTO roo_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Oa iava rera vo reoaro pukooro oiso puraaepa, “Igei-a Ebraham iava vo sara. Viapau oiso irai igei iava akukuvira kovo ragapareveira iraipa. Uva apeisi iava eisi purauei oiso, Viapau oiso akukuvira iraipa kovo ragapatavere?” ");
INSERT INTO roo_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Uva Jisas oiso puraroepa, “Oiraopavira rutu oiso osa visii tavipaavoi, Irou irara voeao oea vuri vovou purapaiveira. Uva varao vuri vovouro oaive oara voea tuukepaiveira. Oa iava akukuvira kovo ragapaiveira vaopa vearo rugoo viapavira. ");
INSERT INTO roo_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Oviito ira vearovira kepaaro-ia aiteto toupareveira eva kepaaro rutu. Ari ro ira tuukepa kepa-ia toupareveira akukuvira kovo ragapaoro, uva viapau kepaaro rutu-a va vao. ");
INSERT INTO roo_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ragai-a vao Oviitoaaro ragoa uvuiparai ra tuukepa kepa iava visii kosi piea vao iava vuri vovou. Oa iava uvuipatai ra vearovira toupata vo Aite oaa vo kepaaro. ");
INSERT INTO roo_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","“Taraiparai oiso, Ebraham sara iraraaro visii. Uva apeisi viapau ragai vo reoaro visii sopaaro-ia toupaivoi, raa? Eisi osa iava oiso ruipapatai ra ragai upooro ragai kopii pieta. ");
INSERT INTO roo_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ari ita, ragai siposipopaaveira varao rutu iava oara kekepaaveira Aite oaa ruvara-ia, ovusa visii evo pitupituro purapataveira oara oupataveira ro ruvara-ia visii aitearo.” ");
INSERT INTO roo_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Oire uva rerare oiso puraaepa, “Eari igei aitearo Ebraham.” Oa iava Jisas oiso puraroepa, “Vosa oiraopavira visii Ebraham ovii iraraaro, oire ra rera vo pitupituroaro rutu tapo purapata oiso osa rera Ebraham oisoa piepareve. ");
INSERT INTO roo_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Visiipa oiraopa reo rutu iava siposipo iraopaavoi varao oara uvuavora Pauto ruvara-ia. Oara-a varao oarapa vo vokio-ia ragai uposa auepatai. Ari ita, viapau oiso Ebraham oisi oiso piereva. ");
INSERT INTO roo_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Oiraopavira uvare ora visii aitearo vo pitupituaro purapataveira.” Uva va-a eva oa iava rerare oiso puraaepa, “Easi igei aako riakoaro viapau oiso otopa vovouro vai purapaoro igei kavaupaivora. Igoa-a kataitoa raga Pauto ovii iraraaro.” ");
INSERT INTO roo_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Oa iava Jisas oiso puraroepa, “Vosa oiraopavira rutu rera Pauto visii aitearo rutu, oire ragaipa siraopata. Eake iava? Uvare ragai oisoa Pauto ruvara-ia toupaa. Ora vo uvare tapo rera vo ruipaaro-ia urioraera. Viapau oiso ora ragai vo ruipaaro-ia vore urioraera. Viapau. Ari Pauto ragai arurevora oa iava vore urioraera. ");
INSERT INTO roo_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Uva eakepa viapau ragai vo reoroaro-ia roroiopatai? Oa vituaro vao-ia oiso toupaivoi, Viapau oiso uvuipatai ra ragai vo reoroaro uvupata riro vavagisiara. ");
INSERT INTO roo_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","“Visii-a Seten ovii iraraaro. Uvare goruvira rutu rera vo vovouaro sirova utu iraopataveira eera visii aitearo. Ari ita, voari tuariri rera-a eera riro oira upoto, ora tapo viapau oisoa oiraopa vovou rutu sirova utuparo. Uvare oiraopa vovou rutu viapau oisoa rera-ia toupaive. Uvare kuuvu reoro raga oisoa purapareve ora rera raga vo reoroaro torevokoaro. Eera-a riro kuuvuto, uvare rera raga-a kuuvu reoro rutu vo vovouaro vituaro. ");
INSERT INTO roo_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ari ragai oiraopa reoro rutu iava siposipopaaveira. Uva apeisi viapau vo reoro oirao piepataveira? Uva kuuvu reoro raga oirao piepataveira ro aite oavisii vo reoroaro Seten. ");
INSERT INTO roo_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Iroutoa vai visii iava uvuiparoi ra ragai iava oai vuria vai kosi piereve vao oa toupaive vo ragai-ia, raa? Ari ita, oiraopa reo rutu kosi piepaavoi. Uva apeisi iava oisi eisi viapau ragai vo reoaro oirao piepatavoi, raa? ");
INSERT INTO roo_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ari Pauto ovii iraraaro rutu rera vo reoroaro rutu uvupaiveira. Ari viapau oiso rera ovii iraraaro-a visii. Oa iava viapau rera vo reoroaro uvupataveira.” ");
INSERT INTO roo_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Oa iava voea Jiu rerare oiso puraaepa, “Eari, igei viire oiso purapaioveira, Sameria iava vii. Viigoa-ia iravu vurito tugarato toupareveira. Uva oiraopavira vai oisi eisi purapaioveira viire, eke?” ");
INSERT INTO roo_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Uva Jisas oiso puraroepa voeare, “Ragai viapau tugaratoa vaiva toupaaveira. Viapau. Ari Aite oaa raga vaisiaro kae piepaaveira, ovusa visii ragai vaisiaro akaipa piepata. ");
INSERT INTO roo_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ari ragai raga viapau oiso uvuiparai ra ora vaisi oaa kae piepaa, uvare iravu raga uvuiparoi ra ragai vaisiaro kae piepareveira. Uvare rera-a eera oirara vo vovouroaro rovirieipato. ");
INSERT INTO roo_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Oiraopavira rutu oiso osa visii tavipaavoi, Vosa irai ragai vo reoaro sirova uturo, ira-a eera viapau uvuiparoi ra kopii ovoiro.” ");
INSERT INTO roo_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Oire uva voea Jiu rerare oiso puraaepa, “Tarai iraoiei vii-ia. Viigoa-ia touparevoi vurito tugarato. Easi Ebraham kopii ovoiroepa, ora voeao reo topa piepa irara profet irara oea tapo kopiiaepa. Uva apeisi-a oiso osa iava oiso purauei, Vosa irai vearovira rutu ragai vo reoaro sirova uturo, eera-a ira viapau uvuiparoi ra kopii ovoiro? ");
INSERT INTO roo_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","E apeisi-a? Easi pasi vii vigei aaotoaaro-ia puteparivoi Ebraham, raa? Ira kopiiroepa ora voeao profet irara oea tapo kopiiaepa. E vii raga apeisi ora kareke piesa auepauei?” ");
INSERT INTO roo_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Uva Jisas voea aatoreva oiso puraoro, “Vosa ora ragai raga vaisiaro kae piepaa, ra oisi iavirava ragai iava vaisia akukupapavira raga toupaive. Ari Aite raga-a ira ragai kae piepareveira ro irare oiso purapataveira, Visii reraaro Pauto, ");
INSERT INTO roo_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","vo osa viapau rera-ia taraipataveira. Ari ragai rera-ia taraiparaveira. Vosa oiso purapara, Viapau rera-ia taraiparai, oire ra oisi iava riro kuuvutoape ragai oiso osa visii. Ari rera-ia taraiparai. Osa iava vearovira rera vo reoroaro sirova rutu utuparaveira. ");
INSERT INTO roo_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","“Aaoto oavisii Ebraham rorureva vo vuutao-ia ragai vaaro-ia taraioro, oa iava urioraera vo rasio iare. Uva oisi-a eisi osa iava rera iava sopaua roruva rutu taraioro.” ");
INSERT INTO roo_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Uva va-a vao oa iava Jiu rerare oiso puraaepa, “Easi vii viapau vo vavae tau (50) ivaro-ia tugurauera avukaoro. Uva apeisi-a? Rera vai kekeriva Ebraham, raa?” ");
INSERT INTO roo_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Uva Jisas oiso puraroepa, “Oiraopavira rutu oiso osa visii tavipaavoi, Vo osa Ebraham kareke asavira toureva, ovusa vo vuuta-a eva oa-ia ragai voari tuariri touava.” ");
INSERT INTO roo_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Oire uva oisi-a eisi osa iava rerare avekeara kae pie ragaiva, oiso ra vara-ia rera vurokoive. Vo osa Jisas voava Tugoropa Kepa-ia vatauvira kosiro viropa. ");
INSERT INTO roo_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Uva vokapaoro Jisas avaroepa. Oa iava iravu voosito oirato kekereva. Aakova oisi raga rera kavaueva voosivira. ");
INSERT INTO roo_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Uva voa igei disaipel Jisas akeiova oiso, “Tisato. Irou vaaro-a vuria oa iava aakova oiso ro voosivira kavauevora? E rera raga vo vuriaro oa iava oisi karekeroepa? Eke aitetoarei vaaro vuria oa purasiva?” ");
INSERT INTO roo_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Uva Jisas igeire oiso puraroepa, “Viapau ro oirato vuria vai purareva, ora aitetoarei ora aakova, ra oisi iava eisi voosivira karekero. Viapau. Ari vaore ro oiso toupareveira, ra rera-ia Pauto vo kovoaro viaevira rutu roroiovira karekepe. ");
INSERT INTO roo_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Vosa ravireo touvira touparevoi, uva uvui iraopaviei ra Pauto vo kovoaro-ia pitupe va puraoro. Uvare rupa urioei oa-ia viapau irai uvuipa ra kovoreve. ");
INSERT INTO roo_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Vosa ragai vo rasio-ia touvira toupaavoi, uva ragai-a aviavia voeaopa oea vo rasio-ia toupaiveira.” ");
INSERT INTO roo_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Uva oisi-a oiso osa iava vavaea-ia ruiroepa. Oire rasia uverereva va tovure pieoro. Oa iava rera osireiaro vavoreva vo tovure-ia. ");
INSERT INTO roo_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Uva Jisas rerare oiso puraroepa, “Avau sisusa uuko rovu-ia va vao Siloam.” Oa porearo oiso toupai, Rera aruiva. Oa iava avaroepa sisusa. Uva vorevira vorepaoro vuravurareva. ");
INSERT INTO roo_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Uva va-a vao oa iava voeao rera vo uruiaro iava ora oearovu tapo voeao oea oisoa rera kekepaive ovusa pauvira raga tou rovopareve, oea rutu rerare oiso puraaepa, “E rera-a ro-ia ira oisoa rirovira moni areparo oirara rutu ruvara-ia, eke viapau?” ");
INSERT INTO roo_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Uva osa iava rerare oiso puraaepa, “Iu. Rera raga-a ita ro-ia.” Ovusa oearovu oiso purapaaepa. “Viapau. Easi oisi raga keketo-a ro-ia. Ari ita, uva iravu raga.” Oa iava rera raga voeare oiso puraroepa, “Easi ragai raga-a ita vao-ia.” ");
INSERT INTO roo_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Uva rera akeiva oiso, “Uva apeisi-a oiso osa iava vii iava osireitoarei vuravurasivo, raa?” ");
INSERT INTO roo_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Uva voeare oiso puraroepa, “Ari ro oirato ira vaisipaiveira oiso, Jisas ira rasia uvererevo va tovure pieoro aue tapo uukoa. Oa iava vo tovure-ia ragai osireiaro vavooro oiso puraroe ragai aruoro, Avau sisusa vavo uuko rovu-ia Siloam. Oire uva voa sisuoro vuravura ovoiavo. Oa iava uvuirai orekerovu kekepasa.” ");
INSERT INTO roo_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Uva eisi osa iava oiso rera akeiva, “Ovu-ia rera epao?” Uva oiso voeapa taearoepa, “Viapau taraiparai.” ");
INSERT INTO roo_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Oire uva rera tapo ro voosito tuariri ira voosivira oisoa toupareve avaaepa Farisi iare voeao ratarataa vovou irara. ");
INSERT INTO roo_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Uva Sabat voki-a vao oa-ia Jisas va vao rasia tovure pieoro va-ia rera iava osireito karureva. ");
INSERT INTO roo_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Osa iava vorerivira ita rera akeiva oiso puraoro, “Apeisi ragavira rutu-a oiso osa iava vii iava osireitoarei vuravurasivo?” Oa iava oiso voea tavireva, “Ragai osireiaro vavorevo tovurea-ia rasia. Oa iava sisusa avaraiva, ragai iava osireitoarei vuravura ovoisivo roroio ovoioro.” ");
INSERT INTO roo_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Osa iava oearovu Farisi oiso puraaepa, “Viapau oiso Pauto rera siporeva, uvare viapau oiso Sabat voki vo pitupituaro sirova utuparoveira ora vao Reo Taisi.” Oa iava eva oearovu oiso puraaepa, “Uva apeisi ragavira-a ro ira-ia vuria toupaive, ra oaiva varao purapareve ravotoara, raa?” Oire uva-a vao oa iava ora voearei-ia vo uvururei purapaiva. ");
INSERT INTO roo_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Uva rera akeoro ita oiso puraaepa, “Uva apeisi vai purapauei rerare ro ira vii iava osireitoarei vura pierevo?” Oa iava oiso puraroepa, “Ari profetato eera.” ");
INSERT INTO roo_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Oiraopavira rutu ira-a ro oisoa voosivira toupareve. Oa iava vo vokio vuravurarevoi. Uva voea Jiu vo reo vao viapau oirao piepaiva. Oa iava aitetoareire keeraaepa vaitereo uvava oviitoa rera ro ira iava osireitoarei karusi viropa. ");
INSERT INTO roo_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Vaiterei akeoro oiso puraaepa, “E rera vai-a ro vei oviitoaaro, pasi? Ira iava oisoa oiso purapasi, Ira kavaueva aakova, ovusa voosivira raga toureva. Oire uva apeisi iava vuravurarevoi?” ");
INSERT INTO roo_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Osa iava aitetoarei voea tavisiva oiso, “Ari ira-ia taraipaveiei eera vegei oviitoaaro, osa raga voosivira aakova rera kavaueva. Oa iava oisi raga karekeroepa. ");
INSERT INTO roo_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Uva vo vokio viapau taraipaveiei oiso osa ragavira iava rera iava osireitoarei aviavisivoi. Ora tapo viapau taraipaveiei oiso, Irouto rera osireiaro karurevo. Rera ake iraota. Ira riroroera. Ira uvuipa ra ora rera raga tavitaviro.” ");
INSERT INTO roo_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Oire uva aitetoarei voea tavipasiva oisi eisi, uvare Jiu asavira uriripasiepa, voeao oea oiso purapaaepa reo goru puraoro, Vosa irai Jisas oiso vaisirevere, Ari Krais-a eera, oire ra oisi iavirava irai siguive vova Reo Taisi Uvupa Kepa Sinagog. ");
INSERT INTO roo_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Oa-a vao oa vituaro iava aitetoarei voea tavioro oiso purasiepa, “Ora visii raga rera aketa. Ira riroroera. Osa iava uvuipa ra ora rera raga visii tavitavireve.” ");
INSERT INTO roo_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Oire uva rerare vorerivira keeraaepa ro ira voosivira tou rovopareve. Oa iava rerare oiso puraaepa, “Pauto vaisipaoro oiraopavira rutu taviu. Uvare Jisas-ia taraipaiei oiso, Vurito.” ");
INSERT INTO roo_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Oa iava voeare oiso puraroepa, “E vurito-a eera, eke viapau? Uvare viapau taraiparai rera vo vovouaro-ia. Ari ita, oiso raga ora ragai-ia taraiparai osa oisoa tuariri voosivira raga toupaa. Uva vo vokio raga-ia ragai iava osireitoarei aviavisivoi karu uviro ovoioro.” ");
INSERT INTO roo_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Oa iava oiso rera akeiva, “Eake rutu purarevo viire? Apeisi ragavira rutu vii iava osireitoarei karurevo, raa?” ");
INSERT INTO roo_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Oire uva voeare oiso puraroepa, “Visii tavi ovoiavo ita. Uva apeisi ragavira uvusa auepatai ita? Easi visii vai tapo oiso ruipapatai ra oiso pieta, Rera voeaaro disaipel, raa?” ");
INSERT INTO roo_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Oa-a eva oa iava rera takaupaoro oiso puraaepa, “Vii raga ita rera disaipeltoaaro. Ari igei-a Moses voeaaro disaipel. ");
INSERT INTO roo_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Uvare taraipaiei oiso, Pauto Moses vatereva reoa. Ari ovu irao rutu iava evo oira urioei? Ira-ia viapau taraipaiei.” ");
INSERT INTO roo_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Uva oiso puraroepa, “Avoeao. Avokoria vao-ia. Oa-ia viapau taraipatai oiso-ia. Uvare oiso purapatai, Ovu iava urioroe? Ira-ia viapau taraipaiei. Rera raga-a ita ro ira ragai iava osireitoarei aviavi pierevo. ");
INSERT INTO roo_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Taraipaviei oiso, Pauto viapau oiso vuri irara vo reoroaro uvupareveira. Ari vosa ro ira rerapa lotuparo ora rera vo reoroaro rutu sirova utuparo eera Pauto, ra va iava rera Pauto vo reoroaro uvupareve vara purapasa. ");
INSERT INTO roo_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Vokiara rutu-ia voari tuariri viapau oisi osiposipoi oisoa toupaive irai iava ira voositoa vai osireiaro vura piereva ro ira voosivira raga kavaueve aakova vai. ");
INSERT INTO roo_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Vosa Pauto viapau ro siporevori vo rasio iare, ra viapau oiso uvuiparoeri oaravu avu vai purapasa.” ");
INSERT INTO roo_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Oa iava rerare oiso puraaepa, “Auoro! Aakoara vii kavaueva vuri pitupitu raga-ia. Osa iava oisoa vurivira rutu toupari. Apeisire auepauei, ra igei tarai pieri, raa?” Uva oiso pura ovoioro rera siguiva vova Sinagog. ");
INSERT INTO roo_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Uva Jisas rera iava uvureva uvare rera siguiva. Oa iava rerare taraapareva. Oa iava rera kekerevoiva, rera akereva oiso, “E Oirato Oviitoaaro Ro Ropoto oirao pieparivoi, eke viapau?” ");
INSERT INTO roo_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Oa iava rerare oiso puraroepa, “Reito. Iroutoa rutu-a Oirato Oviitoaaro? Rera iava ragai taviri, ra rera oirao piea.” ");
INSERT INTO roo_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Osa iava Jisas oiso puraroepa ora rera iava, “Ira kekerivoi ro-ia ovusa vii tapo ora reoparoi.” ");
INSERT INTO roo_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Uva oisi-a eisi osa iavirava oiso puraroepa, “Turaro. Ragai vii oirao pieavoi.” Oire eisi pura ovoioro takuro viropa Jisas-ia vuurapa vaisi pura ovoisa. ");
INSERT INTO roo_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Oire uva Jisas oiso puraroepa, “Ragai urioraera vo rasio iare oirara rovirieisa. Osa iava voearo vuravura asa irara vuravurapaiverea. Ovusa voeao oea vuravurapaiveira oea iava osireiara voosipapere rara.” ");
INSERT INTO roo_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Uva oearovu Farisi iava voa rera ruvara-ia toupaiva. Uva rera uvuoro rerare oiso puraaepa, “E apeisi-a? Igei tapo-a voosi osirei irara, raa?” ");
INSERT INTO roo_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Uva Jisas voeare oiso puraroepa, “Vosa vovouisiro oavisii osireiaro visiire voosivira toupaive, oire ra oisi iava viapau uvuipaai ra oeai visii togapaive aue-ia reo. Ari ita, oiso purapataveira, Igei iava vovouisiro osireiaro aviavipaiveira oiraopara rutu-ia taraipaoro. Oire uva oisi-a eisi osa iava uvuipaai ra visii togapaive oeavu aue-ia reo. ");
INSERT INTO roo_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Oiraopavira rutu oiso visii tavipaavoi, Ro ira viapau rataoa rutu-ia vao sipsip kovokovo vaaro koataro, ora vosa uvavu ragava putereve vo kovokovo kukuearo-ia voare koataoro, ira-a eera oiso toupare, Kavirupato ira orekerovu rutu ou ragapareveira. ");
INSERT INTO roo_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ari vosa ro ira rataoa rutu-ia koataparo, ira-a eera sipsip ragui tokipatoaaro rutu. ");
INSERT INTO roo_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Rataoa tokipato ira rataoa karupareveira ropa ira sipsip ragui tokipareveira. Oa iava sipsip ragui rera gisipoaro uvupaiveira vo osa vo ragui vaivaisiarore keeraparo vo raguio rera voeaaro. Osa iava oisoa vo ragui kosi piepareve rataure vo ragui tuvetuvepaoro. ");
INSERT INTO roo_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Uva oisoa vo ragui sipsip ragui ora rera voeaaro kosi piepareve rataure. Oire ra vo raguipa iraro. Vo rara vo ragui sipsip ragui rera gisipoaro eveipaoro rera sirova utuave. ");
INSERT INTO roo_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Viapau uvuipaai ra iravu raga sirova utuave. Viapau. Ari eera asavira oisoa toripaive, uvare viapau rera gisipoaro eveipai eera iravu raga.” ");
INSERT INTO roo_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Va-a vao reo ruu Jisas oa voeapa vatereva. Uva viapau roroiopaaepa vo reo vituaro-ia vao oa purareva voeare. ");
INSERT INTO roo_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Uva va-a vao oa iava Jisas voeare ita oiso puraroepa, “Oiraopavira oiso visii tavipaavoi, Ragai-a vao rataoaro sipsip ragui vova kovokovoa. ");
INSERT INTO roo_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Voeari oirara oea ragaipa iraaepa oea-a kavirupa irara oea oisoa urio ragapaave sipsip kavirupasa, osa viapau sipsip kare voea gisipoaro uvupaoro voea iare utupaave. ");
INSERT INTO roo_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ragai raga ita ratao-a. Vosa irai ragai iare urioro koatasa vo kasura sovara-ia, ira-a eera orirurevere Pauto vo rara koataro. Ra voava ita kosiro viro aio oupasa. Ra oisi raga ora voreripaoro urioparo koatapasa ita. ");
INSERT INTO roo_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","“Kavirupato viapau oiso orekerovu avu vaire urioparoveira. Ari sipsip ragui kavirupasa urioparoveira voea upopaoro vo kare vuri piepasa rutu. Ari ragai vaore urioraera, ra tootooa rutu oupaive. Oire ra oisi iava voea-ia agasipape rutu vo tootoo. ");
INSERT INTO roo_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ragai vearoto sipsip ragui-ia tokipato. Uvare rera raga vearoto sipsip ragui tokipato ira ora rera iava tootooaro viki ragareverea rara vo ragui iavirava. ");
INSERT INTO roo_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ari ro kovopatoa raga ira voria ragare kovopareve, viapau oiso sipsip ragui tokipatoa rutu-a. Uvare viapau oiso rera vo raguiaro-a sipsip ragui. Eva-a oa vituaro oiso toupai, Ro ira aakau kare tueoro torirevere sipsip ragui kavuoro. Ra oisi iava aakau kare sipsip ragui aiopaoro vo ragui sikasikapaive. ");
INSERT INTO roo_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Eake iava? Uvare eera voria ragare kovoparevoi. Viapau oiso sipsip raguire rugooparo. ");
INSERT INTO roo_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Ari ita, ragai-a vearoto sipsip kare tokipato. Ragoa vo ragui-ia taraiparaveira, ovusa vo ragui tapo ita ragai-ia taraipaave. ");
INSERT INTO roo_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Oiso-ia Aite ragai-ia taraiparoi, ovusa ita Aite-ia taraiparai. Oa iava ora ragai iava tootooa oaa vikiavere rara sipsip ragui tauvaoro. ");
INSERT INTO roo_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Oire uva oraguirovu tapo tou ragapaiveira sipsip ragui. Uva viapau oiso vo kovokovo iava vo raguiro-a. Oraguiroare tapo oiso ruipaparai ra vo raguiro tuvetuvea. Ra va iava ragai raga gisipoaro uvuive. Ra oisi iava katai ragui rutu puraa viro ora takuvuoro. Osa iavirava kataitoa raga pere vo ragui rutu tokipato aue ragai. ");
INSERT INTO roo_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Osa raga vituaro iava Aite ragaipa vo sirao vatereva vare, oiso ra ora ragai vaaro tootooa viki ragaa vo raguipa otootooa vorevira ouaverea. ");
INSERT INTO roo_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Viapau oiso irai ragai iava tootooa verarevere rara. Viapau. Ari ragai raga-a ragoa vare rugoopaoro va viki ragapaavoi vao tootooa. Ari ita, gorua toupaivoi ragai vaaro tootooa viki ragasa. Ora oiso osa tapo toupaivoi vo goruo vo tootoo vorevira ita ousa. Oare oisi vo reo ouavora Aite ruvara-ia vare vao.” ");
INSERT INTO roo_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Oire uva voeao Jiu vo reo vao uvuoro ora voea-ia voearei ita puraiva ora roo pieoro oisi vo reo iavirava. ");
INSERT INTO roo_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Uva oisi-a oiso osa iava riro irara rutu oiso purapaaepa, “Vurito tugarato ira-ia toupare eera oa iava kokoroparoi. Uva eakere rera vo reoaro uvupatavoi?” ");
INSERT INTO roo_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ovusa oearovu voe iava oiso purapaaepa, “Viapau oiso vo reo-a vao ro vo reoaro ira-ia vurito tugarato toupareve. Eari apeisi ragavira vurito tugarato uvuiparoi ra voeao voosi irara osireiaro vorevira vura piepareve, raa?” ");
INSERT INTO roo_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Uva Jerusalem-ia Tugoropa Voki karekeepa vao oa-ia oisoa Oovapa Vurei purapaive vo vokio reesipaoro oa-ia Tugoropa Kepa Tempel vorevira rataoaro karuiva voari tuariri. Ovuuta-a eva riro uteo vuuta. ");
INSERT INTO roo_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Uva voa Tempel sovara-ia Jisas vokareva rakorako uru ivara-ia vao oa paureva Solomon. ");
INSERT INTO roo_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Oire uva voa-a vo uva Jiu rera kovokovosa urioaepa ora guruoro rera iare. Oa iava voa rerare oiso puraaepa, “Auoro. Aa vo vokio igeipa aviavi pievira rutu ora vii iava siposiporivere? Vosa vii rutu Krais, oire igeipa roroio pievira rutu tavi iraou.” ");
INSERT INTO roo_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Uva Jisas voeare oiso puraroepa, “Visii tavipaavora vo vaisio iava. Uva viapau oiso oirao piepataveira. Uvare vo kovoro rutu varao oara purapaaveira Aite vaisiaro-ia oara iava ragai vaisiaro oiraopavira karekeparaveira. ");
INSERT INTO roo_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ari ita, oearovu raga-a visii. Viapau oiso ragai vo raguiaro iava sipsip ragui visii-a. Osa iava viapau oirao piepataveira. ");
INSERT INTO roo_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ari ragai vo raguiaro sipsip ragui ragai gisipoaro uvupaiveira. Oa iava ragai tapo vo ragui-ia taraiparaveira. Osa iava eisi ragai sirova utupaaveira. ");
INSERT INTO roo_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Oa iava vo ragui vatepaaveira Tootoo Ovoi vao vokiara rutu iarepa. Ra oisi iava viapau oiso opesikopaave. Viapau rutu. Uva viapau irai uvuiparoi ra vo ragui verareve ragai vavaearo iava. ");
INSERT INTO roo_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Aite oaa ragaipa oraguia vatereva, uvare rera gorutoa rutu ira orekerovu rutu-ia pute iraopareveira. Uva viapau oiso irai uvuiparoi ra vo ragui verareve vova Aite vavaearo iava. ");
INSERT INTO roo_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ragai ora Aite vegoa-a kataitoarei rutu.” ");
INSERT INTO roo_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Osa-a oiso osa vituaro iava voea Jiu avekeara kae pie ragaiva, oiso ra rera vurukoive vara-ia. ");
INSERT INTO roo_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Oa iava Jisas voeare oiso puraroepa, “Visii tue pieavora riroara rutu-ia vearopa kovoro Aite varaaro. Ari aa vo kovo-a vao oa-ia rugorugoopaoro ragai vurukosa auepatai evara-ia avekeara, raa?” ");
INSERT INTO roo_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Osa iava voea Jiu rerare oiso puraaepa, “Viapau oiso igei okovoi-ia vearoa vai rugorugoopaoro vii vurukosa auepaiei. Viapau. Ari aue iava uvare Pauto toviparivoi vii vao oirato akuku raga. Ora tapo vaopa uvare ora vii ragare oiso purapauei, Vii-a Pauto.” ");
INSERT INTO roo_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Uva Jisas voeare oiso puraroepa, “Apeisi ragavira? Uvare rigatoa oiso toupaivoi vo visii vaaro-ia Reo Taisi oreoa-ia Pauto ora rerapa oeavu reipa irara reesireva voari tuariri oiso puraoro, Visii-a pau irara. ");
INSERT INTO roo_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Uva voea voeao tuariri oea iare Pauto vo reoaro avaepa vao oa oiso puraepa, Voea-a pau irara. Ari ita, Tugoropa Vuku viapau uvuipai ra oku pieive. ");
INSERT INTO roo_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Uva Aite ragai reesioro ragai arureva vo rasio iare. Uva oisi-a eisi osa iava oiso purarai, Ragai-a Pauto Oviitoaaro. Uva eakere oiso purapatai, Pauto toviparivoi, raa? ");
INSERT INTO roo_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","“Vosa viapau Aite vo kovoaro purapaa, ra opeita ragai vo reoaro oirao piepata. ");
INSERT INTO roo_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ari ita, ragai rera vo kovoaro purapaavoi. Vosa irai ragai vo reoroaro oirao pie arapa reasiparo, oa iava uvuiparoi ra vo kovoro raga oirao piepareve oara purapaavoi. Osa iava uvuipatai rutu ra taraita ora vearovira rugorugoota oiso-ia, Ragai-ia toupare Aite, ovusa ita ragai Aite-ia toupaavoi.” ");
INSERT INTO roo_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Uva rera tuuke rovosa auepaaepa ita, ovusa voea vatavataoro avaroepa. ");
INSERT INTO roo_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Uva Jisas vorevira voreoro uukova Jodan iviroreva. Oa iava vo pouro viropa uva tuariri Jon oirara baptaisreva. Uva voa toureva. ");
INSERT INTO roo_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Oire uva voa riro irara rutu rera iare urioaepa. Oa iava oiso puraaepa, “Oiraopavira rutu. Viapau oiso Jon oravotoi purareva. Ari vo osa Jon rera iava ro reoara rutu purareva, oara-a oiraopara rutu.” ");
INSERT INTO roo_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Uva voa-a vo uva riro irara rutu rera oirao pieiva rutu. ");
INSERT INTO roo_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Uva iravu upiaparoepa eera Lasaras aue iava rera Betani urui-ia. Uva-a vo Betani-ia Maria vo voaorei vo uruiaro ora Mata. ");
INSERT INTO roo_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Eira Maria iria oiso vo utupaua sanda kokoeva Turaro kokotoaro iare. Oa iava kokotoarei posiposi pieeva ora oira oruaro-ia. Uvava taataato-a eera Lasaras ira upiaparoepa. ");
INSERT INTO roo_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Uva va-a vao oa-ia taataarirei keeraereiepa Jisas-re oiso puraoro, “Turaro. Ro ira kavikopariveira ira upiaparoi.” ");
INSERT INTO roo_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Oa iava Jisas vo reo uvuoro oiso puraroepa, “Viapau ovoieivira rutu kopiipasa eva upiaro. Ari auere-a keraria vo goruaro kareke piepasa vao Pauto vaaro. Ra oisi iavirava ragai vaisiaro kae pieive rara.” ");
INSERT INTO roo_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Uva Mata ora Maria ora Lasaras ovavuatapa oisoa rirovira siraoparo Jisas. ");
INSERT INTO roo_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Uva Lasaras iava uvureva uvare upiaparoepa. Oa iava vo vokirei-ia toureva vo uruia eva oa-ia toureva. ");
INSERT INTO roo_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Uva utupavira igei disaipel tavioro oiso puraroepa, “Irata ra vorevio Judia Distrik iare.” ");
INSERT INTO roo_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Oa iava igei disaipel rerare oiso puraiepa, “Tisato. Airevi raga ita voa vii vurukosa Jiu aue ragaae. Uva voare ita voresa auepauei, raa?” ");
INSERT INTO roo_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jisas oiso puraroepa, “Asi viapau pasi oiso katai tau erao (12) vaiei o ravireo-ia, eke? Vosa ro ira ravireo-ia vokapareve, ra viapau oiso koveparo. Eake iava? Uvare vo rasio aviaviaro kekeparevoi vokapaoro. ");
INSERT INTO roo_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ari vosa vokiaro vokapareve, ra koveparo, uvare viapau aviavia vai rerapa.” ");
INSERT INTO roo_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Uva oisi-a eisi osa pura rovoroiva, oiso ita puraroepa, “Vatetoa oavi Lasaras uusiroi. Ira tore piesa avaparai.” ");
INSERT INTO roo_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Oa iava igei rerare oiso puraiepa, “Turaro. Vosa uusiroe, uva uvuiparoi ra vorevira torero poreteoro, eke?” ");
INSERT INTO roo_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jisas Lasaras kopiiaro iava eisi puraroepa. Oa iava oiso keapaiepa, Ira uusi ragaparoi. ");
INSERT INTO roo_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Osa iava Jisas aviavi pievira oiso igei tavireva, “Lasaras ira kopiiroe rutu. ");
INSERT INTO roo_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Uva visiire rugorugoopaoro rorupaavoi. Aue iava uvare viapau rera tapo touavo vo vokia eva. Osa iava rera iare avapaviei ra oiraota.” ");
INSERT INTO roo_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Uva Tomas ro ira oisoa vaisipaive oiso, Didimas tavarato, igei disaipel arupareva oiso purapaoro, “Oire irata, ra Tisato tapo kopiisa avavio.” ");
INSERT INTO roo_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Oire uva Jisas avaroepa. Uva pouro viropa. Oa iava tarairoepa oiso, Lasaras vo resura rutu-ia voki toureva tova-ia. ");
INSERT INTO roo_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani-ia uva Jerusalem-ia ruvara-ia toupaiveira aue uvuiaro-ia vo peva vuutara (3 kilomita). ");
INSERT INTO roo_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Uva-a vo uvare riro irara rutu Jiu iava urioaepa Mata voaorei ora Maria vo vovouaro varaata piepasa, uvare taataato vairei arova kopiiroepa. ");
INSERT INTO roo_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Uva Mata Jisas iava uvuoro avaopa raivaaro rerava aivarosa. Ovusa Maria kepa raga sovara-ia paupaoro toupaeva. ");
INSERT INTO roo_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Oire uva Mata rerare oiso puraopa, “Turaro. Vosa vo tourivori, ra viapau taataatoa oaa kopiiro. ");
INSERT INTO roo_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ari taraiparai oiso, Vosa Pautoa iare variriu, ra vii vatereve oavu avu vai vii vo ruipaaro sirova.” ");
INSERT INTO roo_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Oa iava Jisas oiso oira tavireva, “Taataatoara vorevira toreparoi, rara.” ");
INSERT INTO roo_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Uva Mata rerare oiso puraopa, “Ari ita, ragai oiso taraiparai, Ira Ovoiopa Voki-ia toreroverea vo rara tootooro rera raga vo vokiri-ia oa-ia oirara rutu vorevira toreaverea.” ");
INSERT INTO roo_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Uva Jisas oira tavireva, “Ragai raga ita vorevira torea vituaro ora tootooa vituaro eva-a ita ragai raga. Ro ira ragai oirao piepareve eagara vosa kopiiro, ira ita taru oiso tootoovira toupareverea. ");
INSERT INTO roo_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ora voeao oea tootoovira toupai ragai oirao piepaoro oea viapau uvuipaai ra ovoieivira kopii ovoipaave. Viapau. Ari evoea uvuipaai ra tootoovira raga toupaive vokiara rutu-ia. Eva-a vai vao oirao pieparivoi, eke viapau?” ");
INSERT INTO roo_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Osa iava Mata rerare Jisas oiso puraopa, “Aure, Turaro. Vii oirao piepaa, uvare vii-a Krais Pauto Oviitoaaro. Vii vao viigoa iava Pauto taviroepa, oiso ra uriou vo rasio iare.” ");
INSERT INTO roo_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mata oiso puraopa. Oa iava taevare keerasa avaopa Maria. Oire uva oira ou pieoro vatuarore oirava voreopa. Uva voa gare visivi oiso oira tavipaeva, “Tisato eera ira urioroi vo tousa. Ira viire keeraparoi.” ");
INSERT INTO roo_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Uva Maria vo reo uvuoro ikauvira avaopa Jisas iare. ");
INSERT INTO roo_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Oire uva Jisas kare uviro asavira toureva. Uvare voari raga toupareva uva Mata rerava aivaroeva. ");
INSERT INTO roo_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ari ita, vo osa Jiu-pa irara Maria tapo toupaiva kepa-ia oira vovouaro varaata piepaoro. Uva voa-a evoa uvava oira tueiva ovusa ikauvira kosio viropa. Oa iava oira sirova utuaepa uvare oiso keapaaepa, Tova-ia gaupasa avaoe. ");
INSERT INTO roo_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Oire uva Maria vo pouo viropa uva toureva Jisas. Uva voa rera kekeoro rera kokotoaro ruvara-ia rekuoro takuo viropa rerare oiso puraoro, “Turaro. Vosa vo tourivori, ra viapau oiso taataatoa oaa kopiiro.” ");
INSERT INTO roo_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Uva voa Jisas oira vurareva ovusa gaupaeva. Ora voea tapo kekereva Jiu-pa irara oea oira tapo urioaepa. Oea tapo gaupaiva. Osa iava vurivira rutu rera iava sopaua vavataepa kopiia vaarore kasipu iraopaoro aue siitoka. Oa iava siraoroepa rutu. ");
INSERT INTO roo_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Osa iava oiso akereva, “Ovu-ia rera tovatavo?” Uva rerare oiso puraaepa, “Turaro. Uriou vo tova kekesa.” ");
INSERT INTO roo_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Osa iava Jisas gaureva ora rera sopaaro raga-ia. ");
INSERT INTO roo_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Oa iava Jiu rerare oiso puraaepa, “Rera kekepatavoi. Ro ira ro kaviko iraopareveira.” ");
INSERT INTO roo_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ovusa oearovu oiso purapaaepa, “Ira-a eera oearovu osireiaro vura pieparevora voosi irara. Easi pasi, viapau vai uvuiroeri vai, ra ro tauvarevora, viapau vai kopiiroeri?” ");
INSERT INTO roo_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jisas rirovira siraoa vo vavataaro sovorevoiva ora rera sopaaro-ia, vo pouro viropa uva toupaiva vo tova aveke rikui-ia. Uvare iriavu-a rikui iria tekaiva rirova rutu-ia avekeva. Uva iriavu o rikui riaaro veropava aveke tupapaeva. ");
INSERT INTO roo_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Uva Jisas voea tavioro oiso puraroepa, “Aveke verata o-ia.” Oa iava Mata o uvava taataato ira kopiiroepa iria oiso puraopa, “Turaro. Easi kopiiroerao. Vo resura voki putevorao rera isivaaro-ia. Uva eru geesi viapau kosi pirovere rara, eke?” ");
INSERT INTO roo_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Oa iava Jisas oirare oiso puraroepa, “Ari apeisi vii tavi rovoavo? Uva oiso purarae, Vosa oirao pieri, osa iava uvuipauei ra keraria vo goruaro kekeri Pauto vaaro.” ");
INSERT INTO roo_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Oire uva aveke veraiva. Oa iava Jisas viara-ia vuraoro oiso puraroepa, “Aite. Vii-ia vearo vaisi purapaavoi, uvare ragai vaaro variria uvurivoi. ");
INSERT INTO roo_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Taraiparai oiso, Vii ragai vo variriroaro uvupariveira varao oara purapaaveira. Ari voeare oirara rugooparai. Oa iava vo varirio puraavoi, oisore ra oisi vo reo uvuoro vao oirao pieive osa ragai arurivora vore.” ");
INSERT INTO roo_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Eisi puraroiva, rirovira rutu rerare keeraroepa oiso puraoro, “Lasaras! Kosiu viro!” ");
INSERT INTO roo_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Oa iava rera kopiito kosiro viropa kokoto tuukerova ora vavaeara varao oara tuukeiva aue-ia varo iroro. Ora rera puaaro tapo tavuruiva oavu-ia varoa oa oisi raga toupaiva. Oa iava Jisas oiso voea tavireva, “Varoara verata. Ra oisi iava vokareve.” Uva oisi pieiva rera-ia. ");
INSERT INTO roo_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Riro irara Jiu iava urioaepa Maria tapo va kekesa vao oa purareva. Uva va-a eva oa iava rera Jisas oirao pieiva rutu. ");
INSERT INTO roo_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Osa oearovu ratarataa vovou irara aue Farisi iare avaaepa voea tavisa va iava vao oa purareva Jisas. ");
INSERT INTO roo_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Osa iava reipa irara pris voeao tauo purapa irara voearei ora Farisi Kaunsel irara guruiva. Oa iava voea oiso akeiva, “Apeisi rera piepai ro ira riroara rutu ravotoara pura vasiparevoi? ");
INSERT INTO roo_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Vosa rera eaka ragapapere, oire ra oisi raga piepareve. Ra va iava oirara rutu rera raga oirao piepaive. Vosa oisi eisi ra Rom gavmanaro rera voeaaro arureve, ra urioave vigei vaaro Rovopa Kepa Tugoropa Kepa pakosa. Ora orekerovu rutu vuri pieive varao vigei varaaro ora voeao vigei voeaaro.” ");
INSERT INTO roo_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Oire uva iravu oirato rera vaisiaro, Kaiafas vo vuuta iava eva vo iva-ia pris kovo-ia reiparoepa. Ira voeare oiso puraroepa, “E viapau gare visivi taraipatai? ");
INSERT INTO roo_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Opeita voeaore rugorugoopata. Vosa kataitoavi vai raga kopiiro oirara rutupa tootooaro vateoro, eva vearoa rutu visiipa. Teapi oirara rutu voeao vigei voeaaro opesi ragaave.” ");
INSERT INTO roo_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Uva viapau oiso ora rera vovouaro iava oiso vo reo purareva. Ari eera pris kovo-ia reiparoepa vo iva sovara-ia voa-ia. Oa iava Pauto iava vo reo urioepa. Oa iava ravaavira oiso puraroepa, Jisas kopiirovere Jiu-pa irarapa tootooaro vateoro. ");
INSERT INTO roo_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Uva viapau oiso Jiu ragapa tootooaro vatereve kopiioro. Viapau. Ari eera kopiirovere Pauto ovii iraraaro rutu gurusa. Voeao oea vo rasio-ia sikasikavira toupaiveira. Ra va iava katai irara raga puraive. ");
INSERT INTO roo_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Uva vo voki-a eva Jiu reipa iraraaro rovoaepa reoa puraoro Jisas uposa. ");
INSERT INTO roo_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Eva vituaro iava viapau oiso poeravira vokapareva Juda taere vuruvuru-ia. Uva vo taere kavureva eva. Osa iava uvavure avaroepa kuvau tapi ruvara-ia vo uruio iare riro urui oa voavi oisoa toupaive oa oisoa vaisipaive, Efraim. Uva vo uruia eva toureva igei disaipel tapo. ");
INSERT INTO roo_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Oire uva Tagausapa Vurei Pasova vo vuutaaropa tutuu pieepa Jiu vaaro. Uva Pasova vurei oa touvira toupaiva ovusa oirara rutu uruiara rutu iava Jerusalem iare ipaaepa, oisore ra ora voea raga ora sisigarue pie rovoave oavu-ia tugoropa pitupitu voea vaaro. ");
INSERT INTO roo_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Uva osa iava Jisas-re taraapaiva. Uva Tugoropa Kepa Tempel sovara-ia torepaaepa. Oa iava voea raga voa ora reopaaepa oiso purapaoro, “Apeisi vai rugoopatai visii vao? Easi viapau pasi eera Tugoropa Voki kekesa urioparoi vai?” ");
INSERT INTO roo_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Uva voeao reipa irara pris irararei ora Farisi oiso reesia puraiva. Vosa irai Jisas-ia taraiparovere vo osa ovu-ia toupareve, oire irai rera iava taviro. Oa iava uvuipaai ra uvai rera tuukeive. ");
INSERT INTO roo_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Oire uva touvira katai vatara vokiro toupaiva auepa Tagausapa Vurei Pasova oiso ra karekepe. Uva vo vuuta-ia Jisas Betani iare avaroepa Lasaras vo uruiaro iare ro ira vorevira tore piereva tova iava. ");
INSERT INTO roo_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Oa iava vo urui-ia Jisas-pa aioa puraiva. Uva Mata urioopa aio tokesa. Oire voa Lasaras voea tapo oirara pauparoepa oea Jisas tapo paupaaepa. ");
INSERT INTO roo_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Uva Maria aue uvuiaro katai vavata (paun) korovo ovi oueva. Oovia vaisipai oiso, Nad. Oovia puraiva aue iava airepa ruu piero. Ipa pie voriva rutu. Oa iava oira-ia Jisas kokotoaro kipueva. Uva ora oira iava orui-ia rera kokotoaro posiposi pieeva. Oira vearo geesi va vaaro vao sanda kepa sopaaro vogisi pieva. ");
INSERT INTO roo_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Uva iravu disaipelto Judas Iskariot ro ira Jisas kosi pierevere keripa irarapa ira oiso puraroepa, ");
INSERT INTO roo_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Eakepa iraipa vo ovio sanda ovi vate asapai, ra va vorireve irai? Oa iava uvuipaviei ra va-ia aue vo peva vovoto kina (K300) oupe vo ovi-ia. Ra oai apota irara vai vatepe rara.” ");
INSERT INTO roo_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Uva viapau oiso apota irara-a oeare rugorugoopaoro oisi eisi puraroepa. Viapau. Ari ora rera ragare-a, uvare rera-a riro kaviruto. Ira oisoa moni bokis tokipaoro va kavirupareve. ");
INSERT INTO roo_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Uva oisi-a eisi osa iava Jisas voeare oiso puraroepa, “Oira eakata eira. Iria eisi pieevoi ragai kipuoro vo vokio iare ravaavira ovokia-ia ragai tovoivere tova-ia. Uvare ragai vo vokiaro tutuu pievoi. ");
INSERT INTO roo_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Apota irara visii tapo vokiara rutu-ia toupaiveira. Ari ragai viapau oiso visii tapo toupaavere touvira.” ");
INSERT INTO roo_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Oire uva riro irara Jiu iava taraipaaepa oiso, Jisas vo uruio-ia touparevoi. Oa iava rera iare urioaepa. Uva viapau oiso rera raga kekesa urioaepa. Viapau. Ari vao iava tapo-a, uvare Jisas Lasaras tuaririvi vorevira tore piereva tova tapi iava. Oa iava rer tapo kekesa urioaepa. ");
INSERT INTO roo_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Uva oisi-a oiso osa iava reipa irara reo goru puraiva, oiso ra Lasaras tapo upoive. ");
INSERT INTO roo_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Eake iava? Uvare riro irara rutu Jiu iava Lasaras-re rugoopaoro voea kavuiva reipa irara pris Jisas raga oirao piesa. ");
INSERT INTO roo_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Oire uva vo vokio isivaaro riro irara Pasova vurei-ia toupaoro Jisas iava uvuiva oiso, Urioparoi vore Jerusalem-ia. ");
INSERT INTO roo_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Osa iava sorapita raoro ouiva. Oa iava varava rerare korotosa avaaepa raivaaro. Oa iava raga piepaiva varava kaku piepaoro rerava oiso purapaoro, “Hosana! Ro vaisiaro kae piepe ira urioroi Reito Turaro vaisiaro-ia Isrel-pa irara reraaro King!” ");
INSERT INTO roo_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Uva Jisas iriavu donki kakae kekereva. Oa iava oira ivara-ia paupaoro urioroepa oiso osa Tugoropa Vuku purapapeira, ");
INSERT INTO roo_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","‘O Saion-pa irara. Opeita uriripata. Visii reraaro King keketa. Eera-a ira urioroi aue-ia paupaoro donki kakae.’ ");
INSERT INTO roo_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Oire uva rovoa-ia igei disaipel viapau oiso va vituaro-ia taraiiepa. Ari rera vo torearo isivaaro iava Jisas keraria oureva. Ovuuta-a eva oa-ia vorevira ora rugorugoo pieiepa vaore osa Tugoropa Vuku purapapeira rera iava. Osa iava tapo oirara ruture rugooiepa voeao oea orekerovu purapaiva vo rerare. ");
INSERT INTO roo_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Tuariri Lasaras kopiiroepa. Oa iava tova-ia toureva. Uva riro irara Jisas tapo toupaiva ovusa Lasaras-re keeraroepa rera vorevira tore pieoro. Uva va-a vao oa iava riro irara tavitavi iraopaaepa va iava vao oa purareva Jisas. ");
INSERT INTO roo_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Osa iava rera iava uvuiva oirara, uvare ravotoa purareva. Oa iava raivaaro rerava aivarosa avaaepa. ");
INSERT INTO roo_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Uva oisi-a eisi osa iava voea raga Farisi ora reopaaepa oiso purapaoro, “Va eva keketavoi. Visiigoa voeare korukoru ragapataveira, osa viapau. Uva oirara rutu rera raga sirova avaai.” ");
INSERT INTO roo_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Oirara rutu Jerusalem iare ipaaepa Pautoa-pa lotusa vo vokia vao Tugoropa Voki Oovapa. Uva oearovu tapo Grik-pa irara voare ipapaaepa. ");
INSERT INTO roo_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Uva Grik-pa irara urioaepa Filip iare aue iava rera Betsaida vo Galili taere sovara-ia. Uva oiso rerare puraaepa, “Auoro. Oiso ruipapaiei ra Jisas kekeio.” ");
INSERT INTO roo_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Oa iava Filip avaroepa Andru tavisa. Uva vaiterei rutu avasiepa Jisas tavisa. ");
INSERT INTO roo_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Uva Jisas vaitereire oiso puraroepa, “Easi Oirato Oviitoaaro ragai vo vuutaaro-a vao oa pou piroi. Oa-ia keraria oupaavoi. ");
INSERT INTO roo_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Oiraopavira rutu oiso osa vei tavipaavoi ragai vo vuutaaro iava oiso, Vosa wit takura viapau rasiua arore kovepe kopiisa voa, ra va raga kataia toupaive. Ari ita, vosa kopiiro, oire voava vorevira torero riro kouro aioara karekeoro. ");
INSERT INTO roo_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ari ro ira ora rera iava tootooa-ia virivirioparo ira iava opesi ovoipere eera. Ari ro ira tootooaro vatereve vo oearovupa ragai vo ruipaaro sirova utupaoro, eera-a ira ora rera vaaro tootooa oureverea vao Tootoo Ovoi rutu. Oa viapau opesia vai. ");
INSERT INTO roo_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Vosa irai ragai vo kovoaro-ia pitureve, ira uvui iraopa ra ragai sirova uturo, oiso ra ragai tapo toupareve, Kovopatoa oaa vo uva toupaaverea. Vosa ro ira ragai vo kovoaro-ia pitupareve, irapa rei vaisi vatereverea Aite oaa taru. ");
INSERT INTO roo_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Vo vokio ragai iava sopaua vavataei. Uva apeisi puraparai? E uvuiparai ra oiso vaio pasi purara, Aite vao verari oa ragai-ia karekesa auepai? Eke viapau uvuiparai ra eisi purara? Viapau. Uvare va raga-a eva oare poura viropa vo vuutari-ia oa-ia siraoa vo tavakaaro ouavere. ");
INSERT INTO roo_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Aite. Uvuipauei ra ora vii vaisiaro rei pieri oisi iavirava oiso.” Eisi osa puraroepa Jisas. Oa iava Pauto vo reoaro vuvuiua iava varaepa. Oreoa-ia oiso puraroepa, “Tuariri ora ragai iava vaisia rei pieavora. Oire uva vorerivira ora ragai vaisiaro rei piepaavoi rara.” ");
INSERT INTO roo_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Oirara voeao oea rera ruvara-ia tutuu pievira torepaaepa oea vo guruko uvuiva. Oa iava oiso puraaepa, “Varakeoto ira pokoro viroi.” Ovusa oearovu oiso puraaepa, “Iravu purapurapato enselto ira rera tapo ora reoparoi.” ");
INSERT INTO roo_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Oire uva Jisas voeare oiso puraroepa, “Viapau oiso ragai tauvasa oiso vo reo karekeei. Viapau. Ari visii tauvasa-a. ");
INSERT INTO roo_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Vo vokio Pauto oirara rutu voeao vo rasio-ia rovirieiparevoi. Vo vuuta-a vao oa-ia vo rasio vo pitupituaro vo goruaro tokoparevoi Seten vo goruaro-ia pute iraooro. ");
INSERT INTO roo_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Vo vokio vo rasio-ia toupaa. Uva vovio utupauavi ragai kae pieivere ragai kotooro rara. Uva vo vuuta-a eva oa-ia oirara rutu vo rugooroaro ivuavere ora ragai iare. Ra oisi iavirava ragai oirao pieive.” ");
INSERT INTO roo_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Uva oisi-a oiso osa puraroepa ora rera vo kopiiaro reesioro. ");
INSERT INTO roo_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Oa iava oearovu rutu rera vo reoaro pukooro rerare oiso puraaepa, “Igei oiso vo reo uvuiova Reo Taisi-ia, Krais oiso touvira rutu toupareve. Uva eake-a vao oa vituaro iava oiso purauei, Oirato Oviitoaaro kae pieivere rera kotooro? Uva aa ro rutu-a ro Oirato Oviitoaaro, raa?” ");
INSERT INTO roo_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Oa iava Jisas oiso voea tavireva ora rerare, “Gare vuutavi raga-ia aviavia visii tapo toupaivoi. Uva uvui iraopatai ra vo aviavio-ia vokata. Teapi rupa visii tavuruve. Ro ira rupa-ia vokapareve oire ra viapau taraiparo oiso, Ovu avaparoi. ");
INSERT INTO roo_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Vo osa aviavia vaviopavira visii tapo touvira toupai, oire uva uvui iraopatai ra vo aviavi oirao pie iraota. Oa iava uvuipatai ra oiso rutu kareketa, Visii-a aviavia-ia vokapa irara rutu.” Vo reo-a vao oa purarevoiva, Jisas voea kavuoro avaroepa voea osireiaro iava vatausa. ");
INSERT INTO roo_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ari ita, rera oisoa siitue ragapaive Jiu, ovusa riro ravotoro rutu pura ragapareve. Ovusa viapau rera oirao piepaive oisi iavirava. ");
INSERT INTO roo_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Uva oisi-a eisi osa iava profetato Aisaia vo reoaro oiraoepa vao oa iava oiso puraroepa, ‘Turaro Pauto. Irouto igei vo reoaro oirao piepare? Irouto-a ro ira Turaro Pauto vo goruaro eveiparevoi? Viapau rutu oiso iraiei.’ ");
INSERT INTO roo_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Uva viapau oiso uvuipaavere ra Jisas oirao piepaive. Oa vituaro iava Aisaia oiso oreovu rigatoreva. Oa-ia oiso puraroepa, ");
INSERT INTO roo_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","‘Pauto voea osireiaro voosi ovoi piereva. Ora voea vo rugorugooroaro tapo tupareva. Osa iava viapau uvuipaai ra oaravu avu vai kekepaive ora voea osireiaro iava. Ora vo vearo rugoo-ia voea iava sopaura-ia. Oire ra oisi iavirava viapau ora voea iava sopaura oaive porepaive. Osa iava viapau uvuiparai ra voea porete piepaa. Viapau rutu.’ ");
INSERT INTO roo_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ari ita, voari tuariri Aisaia ira Krais vaaro keraria kekereva. Oa iava vo reo purareva rera ragare Krais. ");
INSERT INTO roo_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Riro irara reipa irara Jiu iava rera oirao pieiva. Osa Farisi ragapa uriripaaepa. Oa iava viapau ora voea vo oirao pieroaro iava tavitavipaaepa, uvare oiso rugoopaaepa, Teapi vigei siguive Reo Taisi Uvupa Kepa iava Sinagog. ");
INSERT INTO roo_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Aue iava uvare oiso raga oisoa ruipa iraopaave ra oirara voea vaisiaro kae piepaive. Vo osa oisivi raga Pautoa-re oiso rugoopaave. Ra voea vaisiaro-ia vearo vaisi purapareve. ");
INSERT INTO roo_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Oire uva Jisas rirovira rutu reooro oiso puraroepa, “Ro ira ragai oirao piepareve ira viapau oiso ragai raga oirao pieparevoi. Ari Aite tapo oirao pieparevoi ro ira ragai arureva vore. ");
INSERT INTO roo_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ora ro ira ragai kekereve eera ita-a ira Aite tapo kekepare ro ira ragai arureva. ");
INSERT INTO roo_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Vo rasio iare oiso rutu urioraera osa aviavia vaore, oiso ra oirara rutu ragai oirao pieive. Ra oisi iava viapau oiso rupa-ia toupaive. ");
INSERT INTO roo_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Vosa irai ragai vo reoaro uvupareve, ra viapau va oirao piepareve va sirova utupaoro, eera-a ira viapau rovirieiaverea oiso osa ro reo rovirieipato. Viapau oiso ragai urioraera ra oiso toupaa, Oirara rovirieipato ragai. Viapau. Ari uriorae voea vorevira virivarisa rutu. ");
INSERT INTO roo_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ro ira ragaire isivaparo vo rara viapau ragai vo reoaro oupareve, ira rovirieiverea ragai vo reoaro raga vo Ovoiopa Voki-ia. Uvare ragai vo reoaro, Oiraopa Reo rutu oa toupai oiso rutu osa reo rovirieipato. ");
INSERT INTO roo_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Viapau oiso ora ragai raga vo vovouaro iava oiso reoreoparai. Viapau. Ari Aite-a ira ragai siporeva. Eera ira ragai taviparevoi vo reoro ruture vara purapasa vara rutu tapo iava siposipopaoro. ");
INSERT INTO roo_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Taraiparai Aite vo reoaro-ia. Oa tootooa kareke piepaiveira vao Tootoo Ovoi vokiara rutu iarepa. Eisi osa iava vo reoro rutu varao purapaa oiso osa Aite varare puraroepa.” ");
INSERT INTO roo_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Tagausapa Vurei Pasova vo vuutaaro kareke asavira touva. Uva Jisas tarairoepa vo vuutao-ia oa karekeei oa-ia vo rasio kavurevere Aitetoa iare avaoro. Uva oisoa oirara kaviko iraopareve voeao rera voeaaro oea vo rasio-ia toupaiveira. Okavikoa vao rera vaaro oa vo rutu tugurasa urioepa uva kopiiroepa. ");
INSERT INTO roo_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Oire uva ovaiarovi aiopaoro toupaiva. Vo osa Seten ora rera vo rugorugooaro vuria tovo rovoreva Judas Iskariot sopaaro-ia ro Saimon oviitoaaro, oisore ra Jisas kosi piereve keripa irara vavaearo iare. ");
INSERT INTO roo_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Uva Jisas tarai rovoroepa oiso, Aiteto orekerovu rutu vatereva rera vavaearo iare. Uva vao-ia tapo oiso tarai rovoroepa, Pauto Aite rera arureva oa iava urioroepa vore. Ora uva vorevira voreroverea rara Pautoa iare. ");
INSERT INTO roo_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Oire uva aiopa tapiva toreroepa varoa verasa ora rera iava vao oa-ia oisoa ora rakurakuparo. Oa iava aue taul oureva rera-ia tuusa. ");
INSERT INTO roo_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Osa-a eisi osa pierevoiva, uuko ovi petoreva aue iare dis. Uva rovoroepa igei disaipel kokotoaro sisupaoro. Uvare oiso rutu ora pieroepa, Akukutoavi raga kovopato. Uva voava igei kokotoaro posiposi piepareva vorevira taul-ia. ");
INSERT INTO roo_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Uva Saimon Pita iare ora viruroepa. Oa iava Pita oiso rera akereva, “Turaro. E ragai kokotoaro tapo sisuparivoi?” ");
INSERT INTO roo_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Oa iava Jisas rerare oiso puraroepa, “Vao oa purapaavoi oa-ia viapau taraipauei. Utupavira oa-ia taraiuvere rara.” ");
INSERT INTO roo_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Uva Pita rerare oiso puraroepa, “Viapau oiso ra ragai kokotoaro sisuri. Viapau rutu.” Uva Jisas oiso puraroepa, “Eakepa Pita? Vosa viapau vii sisua, ra viapau uvuipauei ra oiso toupari, Ragai reraaro disaipelto.” ");
INSERT INTO roo_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Oa iava Saimon Pita rerare oiso puraroepa, “Eagara. Ragai kokotoareiaro sisuri, ora vavaearei, ora kukue.” ");
INSERT INTO roo_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Uva Jisas oiso puraroepa, “Ro ira ora rera iava varaua rutu sisu rovoreve ira sisigarue ovoiroi ita. Oa iava uvuiparoi ra kokotoaro raga ita sisureve. Ari ita, sisigaruevira toupatavoi. Uva viapau oiso visii rutu-a.” ");
INSERT INTO roo_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Aue iava uvare tarairoepa ro-ia ira rera kosi pieparevoi rara keripa irarapa. Uva va-a vao oa iava oiso puraroepa, “Viapau oiso visii rutu sisigaruetai.” ");
INSERT INTO roo_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Oire uva Jisas voea sisu rovorevoiva, vorevira varoa-ia ora rakurakuroepa. Oa iava vorevira pauroepa. Uva voea akereva oiso, “E vao-ia taraipatai oa puraavoi visii-ia? ");
INSERT INTO roo_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ari ita, ragai vaisipataveira oiso, Tisato, ora oiso, Turaro. Uva vearovira rutu-a, uvare oisi eisi purapataveira ragaire. Osa raga ita-a eisi osa toupaavoi. ");
INSERT INTO roo_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Oiraopavira rutu, uvare Turaro-a ragai, ora Tisato. Ragoa visii iava kokotoara sisuavoi. Oire uva visii tapo ita uvui iraopatai ra ora visii araoko iraraaro kokotoaro tapo oisi sisupata. Ra voeapa ora vaisiaro oavisii gare piepata. ");
INSERT INTO roo_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Uva visii tapo uvui iraopatai ra oisi ragavira vioevira oisi piepata, oiso osa va vao ovoovovira puraavoi visii-ia. ");
INSERT INTO roo_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Oiraopavira visii tavipaavoi oiso, Kovopato viapau putepare rera reraaro-ia reito. Ora ro ira okovovu iare avaro, ira viapau oiso uvuipa ra roari-ia putepareve ira rera arurevora, avaro. ");
INSERT INTO roo_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Uva vo ovoovo-ia taraitai oa puraavo visii osireiaro-ia. Oa iava uvuipatai ra va sirova utupaoro oarai purapatavora, roru iraopata. ");
INSERT INTO roo_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Viapau oiso visii ruture oiso purarai. Ari ragai voeao-ia taraiparai oea ora ragaipa reereesiava ragai voeaaro. Ari ita, uvare va vao oare Tugoropa Vuku oiso puraepa oa oiraoperea rara. Oiso osa Tugoropa Vuku-ia oiso purapai, ‘Ro ira ragai tapo bret iava aioroera ira kokotoarei kae piere ragai-ia tasisa.’ ");
INSERT INTO roo_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Uva va vao kareke asavira toupai osa rera iava visii tavipaavoi. Uvare oisi karekepere rara. Ra oisi iavirava ragai oirao pieta ragai raga ita vao-ia Krais. ");
INSERT INTO roo_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Oiraopavira visii tavipaavoi oiso, Vosa aa ro avuo ro ira kovopatoa oaare vearo vovou rutu purapareve ro ira arua, ira ita vearo vovou rutu purapareveira ragai tapo-ia. Oa iava ita rera vegei-ia ora Aite tapo-ia vearo vovou rutu purapareveira.” ");
INSERT INTO roo_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Oire uva Jisas sopauaaro vavata iraoepa. Oa iava oiso voeare puraroepa, “Iravu epao visii iava ira ragai kosi pieparevoi keripa irarapa rara.” ");
INSERT INTO roo_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Uva oisi-a eisi osa puraroiva, igei raga disaipel ora igeiva vurapaiova tuupavira oiso purapaoro, “Viapau taraipaviei irouto-a”. ");
INSERT INTO roo_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Uva ragai Jon rera reraaro disaipelto Jisas kopukopuaro-ia otarapaoro pauparaepa. Ragoa oisoa kaviko iraopareve rera Jisas. ");
INSERT INTO roo_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Osa iava Saimon Pita kukue pikuoro ragaire oiso puraroepa, “Rera akeri. Iroure eisi puraroei?” ");
INSERT INTO roo_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Oa iava rera kopukopuaro iare tutuu pieoro rutu ogaga visivi oiso rera akeava, “Turaro. Iroure eisi purauei?” ");
INSERT INTO roo_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Uva Jisas oiso puraroepa, “Aioa vai tovopaavoi tapi rovu-ia. Ra rera vatea ro raga ita-ia.” Osa iava aioa tovoreva kap-ia. Oire va ouoro va vatereva Judas-pa Saimon Iskariot oviitoaaro. ");
INSERT INTO roo_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Oire uva Judas aioa ourevoiva, Seten rera sopauaaro-ia ora kiuroepa. Oa iava Jisas rerare oiso puraroepa, “Vosa va pura ruipapau. Uva uvui iraopauei ra ikauvira raga va purari.” ");
INSERT INTO roo_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Uva viapau oiso irai tebol ruvara-iavi paupaoro oisi iava vo reo vituaro-ia tarairoepa oreoa purareva Judas-re. ");
INSERT INTO roo_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Uva oearovu igei iava disaipel oiso keapaaepa vao iava, uvare Judas moni bokis-ia pitupareveira. Oa iava oiso keapaaepa, Jisas rera taviparevoi orekerovu avu vai vorivorisa Tugoropa Vurei iare. Eke oarai vatevatesa apota irarapa. ");
INSERT INTO roo_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Uva Judas aioa ourevoiva, ikauvira kosi ovoiro viropa ovusa rupa ovoiepa. ");
INSERT INTO roo_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Uva Judas kosiro viroiva, Jisas oiso puraroepa ora rera raga vaisipaoro, “Vaviopavira Oirato Oviitoaaro Ro Ropoto keraria vo goruaro ourevoi, uvare Pauto vo kerariaro rera-ia karekei. ");
INSERT INTO roo_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Vosa ragai Oirato Oviitoaaro Pauto vaaro keraria vo goruaro kareke piea oirarapa, ra Pauto ita ragai vo kerariaro vo goruaro tapo kareke piereve poeravira oirarapa. Ra torevokovira Pauto oisi piereve, uvare ragai vo kerariaro vituaro rera-ia toupaiveira. ");
INSERT INTO roo_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ovii irara oaa. Gare visivi raga visii tapo toupaavoi. Uva ragaire taraa ragapatavere. Oiso osa Jiu taviava oiso-ia osa visii tavipaavoi tapo. Viapau rutu uvuipatai ra voare avata vo uvare avaparai. ");
INSERT INTO roo_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Visii vateavoi airepa reo goru. Oa-ia oiso purarai, Ora visii iava sopaura rutu vatepata araoko irara oavisiipa siraopaoro. Oiso osa ragai ita ora ragai iava sopaua rutu vate rovoavora visiipa siraopaoro. Eisi raga ita osa uvui iraopatai ra ora visii araoko iraraaropa siraopata. ");
INSERT INTO roo_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Vosa araoko irara oavisiipa siraopata. Oa iava uvuipai ra oirara rutu oiso taraipaave, Visii-a ragai voeaaro rutu disaipel irara.” ");
INSERT INTO roo_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Oire uva Saimon Pita rerare oiso puraroepa, “Turaro. Ovu-a vo uvare avauvere?” Uva Jisas oiso puraroepa rerare, “Vo uvare avaravere, uvare viapau oiso uvuipauei ra ragai sirova voare utuu. Ari ita, voari utupavira ragai sirova utuuvere.” ");
INSERT INTO roo_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Oa iava Pita rerare oiso puraroepa, “Turaro. Eake iava viapau uvuiparai ra vii sirova utura? Uvare ora ragai iava tootooa oaa vikisa aueparai vii tauvaoro.” ");
INSERT INTO roo_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Uva Jisas rerare oiso puraroepa, “O ari ragai tauvaoro ora vii vaaro tootooa vikirivere, eke? Oiraopavira rutu oiso osa vii tavipaavoi, Vo osa kookai gau asavira touparevere, ovusa ragai vaisiaro vatauri vo peva piepa taea-ia. ");
INSERT INTO roo_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Opeita visii iava sopaura oavisii siraopape. Ari Pauto oirao piepata ora ragai tapo ita. ");
INSERT INTO roo_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Vo Aite oaa vo kepaaro-ia oa-ia riroara rutu toupaiveira tugitugiara. Vosa viapau oisi eisi toupaivori, ra viapau oiso visii tavi rovoavori. Ari oiraopavira avaparai visiipa uruia ravaasa. ");
INSERT INTO roo_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Oire vo osa avaparai visiipa uruia ravaasa, uva voava vorevira voreraverea visii ou piesa. Ra ragai tapo touta voa. Osa-a eisi osa vo urui-ia eva touavere. Oa-ia ita visii tapo ragai tapo toupataverea. ");
INSERT INTO roo_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Uva taraipatai raiva-ia vo urui iare vao oa iare avaparai.” ");
INSERT INTO roo_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Uva Tomas oiso rera akereva, “Turaro. Ovu-a vo uvare avapauei? Viapau oiso igei taraipaiei. Apeisi ragavira iava uvuipaiei ra vo raiva-ia taraiio eva voare?” ");
INSERT INTO roo_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Oa iava Jisas oiso puraroepa, “Ragai raga ita-a vao-ia raiva, uvare ragai-a Oiraopa Rutu vituaro. Ora ragai-a Tootooa tapo vituaro rutu. Viapau irai uvuiparoi ra oraivai raga iava Aite-ia pouro viro. Viapau rutu. Ari vo raga ragai. ");
INSERT INTO roo_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Vosa ragai-ia taraipataeri, ra oisi iavirava Aite oaa-ia tapo taraipata. Oire uva vaviopavira rovota rera-ia taraipaoro. Uvare ita rera kekepataveira.” ");
INSERT INTO roo_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Uva Filip oiso rerare puraroepa, “Turaro. Igei kareke pieri Aiteara iava. Ra oisi iavirava igei vo ruiparoaro uvui piereve.” ");
INSERT INTO roo_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jisas rerare oiso puraroepa, “Filip. Riro kaekae vuutaro rutu-ia oisoa visii tapo toupaa, osa viapau ragai-ia taraipau, raa? Ro ira ragai kekepareve, eera ita-a ira Aite tapo kekepareveira. Uva apeisi iava oiso purauei, Igei kareke pieri Aiteara iava? ");
INSERT INTO roo_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Easi viapau vai ragai oirao piepariveira vo osa Aite tapo toupaaveira, ovusa ita Aite oaa ragai tapo toupareveira, raa? Vo reo oa vatepaaveira visiipa, uva viapau oiso va purapaaveira ora ragai raga vo rugorugooaro iava. Easi Aite ragai tapo toupareveira ira ora rera vo kovoroaro purapareveira. ");
INSERT INTO roo_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ragai vo reoaro oirao pie iraota aue-ia uvare Aite-ia toupaa, ovusa Aite ita ragai-ia toupare. Vosa vo reopa viapaeri, oire ra vo kovoro ruture rugoo iraopata oara purapaaveira. Osa iava uvuipatai ra vo kovoro iavirava ragai oirao piepata. ");
INSERT INTO roo_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Oiraopavira rutu oiso visii tavipaavoi, Vosa irouto ragai oirao piepareve vo kovoro iava oara purapaaveira, ira-a tapo ita eera ira uvuiparoi ra oisi vara purapareve. Ari ita, oa iava uvuiparoi ra pute pievira rutu okovorovu riroara purapareve. Oire vo kovoro evara vo kovo-ia ragai vaaro puteve. Eake iava? Uvare avaparai Aite iare. Ra voa toupaoro Tugoropato Uraurato vara pieavere visii tauvapasa. ");
INSERT INTO roo_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ra varao orekerovu rutu oarare variripata ragai vaisiaro-ia oara-ia uvuiparai ra vara purapaa. Osa iava uvuipai ra Aiteto vo kerariaro goruaro karekepe ragai iavirava. ");
INSERT INTO roo_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Vosa ragai vaisiaro oirao piepaoro variripata orekevure, ra va puraa taru. ");
INSERT INTO roo_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Vosa ragai kavikopaoro ragaipa ora visii iava sopaura oavisii rutu vatepata, eva-a oa iava ragai vaaro reo goru sirova vearovira rutu utu iraopatavere. ");
INSERT INTO roo_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Oa iava uvuiparai ra varirira Aite iare. Ra oisi iavirava visii vatereve iravu visii Tauvapato visii sopaura oavisii goru piepaoro vokiara rutu-ia. ");
INSERT INTO roo_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ro-ia Tugoropato Uraurato Oiraopara Rutu Kareke Piepato. Ira-ia viapau uvuipaai oirara rutu iava oearovu vo rasio-ia ra rera viapau oupaive, uvare viapau rera eveipaiveira, ora viapau rera-ia taraipaaveira. Ari ita, visii raga rera-ia taraipataveira. Eake iava? Uvare visii tapo toupareveira osa iava visii sopaaro-ia toupare. ");
INSERT INTO roo_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Teapi keapata oiso, Visii kavupaavoi, ra oiso rutu toupata osa virakoi kakaero. Viapau. Ari visii iare vorevira voreraverea rara. ");
INSERT INTO roo_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Tutuu piepai ra oirara rutu voeao vo rasio-ia tou irara viapau ragai kekeive vorerivira. Ari visii raga taru ragai kekepatavere ragoa tootoovira toupaa. Eva-a oa vituaro iavirava visii tapo ita tootoovira toupataverea. ");
INSERT INTO roo_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ovokia-ia eva taraitavere oiso-ia, Ragai Aite tapo ora tavosiparai. Ra ita ragai tapo ora tavosipata, ovusa ragai ita visii tapo ora tavosipara. ");
INSERT INTO roo_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ro ira ragai vaaro reo goru oureve ra oisi iavirava vearovira rutu va sirova utuparo, ira-a eera ragaipa ora rera iava sopaua rutu vateparevoi ragai kavikopaoro. Ora ro ira ragai kavikopareve, ira ita kavikopareverea Aite. Ora ragai tapo ira tapo kavikopaaverea rera iare roroiovira rutu ora karekepaoro.” ");
INSERT INTO roo_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Osa-a eisi osa puraroepa Jisas. Uva iravu raga Judas viapau oiso ro-a Iskariot, ira Jisas-re oiso puraroepa, “Turaro. Apeisi iavirava igei iare roroiovira ora karekeuverea, vo osa oisi eisi viapau roroiovira ora karekeu oirara rutu-ia voeao vo rasio-ia?” ");
INSERT INTO roo_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jisas rera vo reoaro pukooro oiso puraroepa, “Vosa ro ira ragai kavikopareve, ira-a eera vearovira rutu ragai vo reoaro sirova utuparoi. Oa iava Aite rera kavikopareverea. Osa iava vegei aaorei rutu rera iare urioveare rera tapo toupasa vokiara rutu-ia. ");
INSERT INTO roo_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ari ro ira viapau ragai kavikopareve, ira-a eera viapau vearovira ragai vo reoaro sirova utuparoveira. Oire uva vo reo-ia vao-ia oa uvutavoi viapau oiso ragai vo reoaro-a. Ari Aite vo reoaro-a ro ira ragai arureva vore. ");
INSERT INTO roo_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Tou visivi visii tapo toupaoro visii tavipaavoi varao iava. ");
INSERT INTO roo_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ari ita, Tauvapatoa rutu ro Tugoropato Uraurato ira ragai vaisiaro-ia arurevere Aite. Eera ira visii tarai pieparevere orekerovu rutu-ia. Ora visii vo rugorugooroaro toretore pieparevere. Oire ra oisi iavirava vo reoro ruture rugoopata oara vatepaaveira visiipa. ");
INSERT INTO roo_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Visii kavusa aueparai. Ra oisi iava visii vatea gavaure vovou vaore, oiso ra visii-ia toupaive. Eva gavaure vovou oa vatepaavoi visiipa ragai vaaro. Viapau oiso visiipa vao oiso gavaure vovou vateavoi osa voeao oirara vo rasio-ia visiipa gavaure vovou vate ragapaiveira. Opeita visii iava sopaura oavisii vavata ragapape. Ora opeita uriripata. ");
INSERT INTO roo_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Vo reo uvutavoi ita oa vateavoi visiipa oiso, Visii kavuavoi avaoro, oa iava vorevira voreraverea. Vosa ragaipa sirao rovotaeri, oa iava uvuipatai ra ragai-ia rorupata ovusa Aite oaa iare avara. Ra voa toupaoro visiipa Tugoropato Uraurato vara pieavere. Ari ita, Aite reiparoi rutu. Ira ragai-ia putepareveira. ");
INSERT INTO roo_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Va-a vao oa pou viro asavira toupaivoi oa iava vo vokio visii taviavoi. Oa-a eva vovio utupa visivi karekepere taru vo osa Aite iare avara. Ra oisi iavirava taru ragai vo reoroaro oirao pieta. ");
INSERT INTO roo_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Viapau oiso vorevoreripavira visiipa riro reoro vai rutu purapaa. Eake iava? Uvare vo rasio vo pitupituaro goruaro, rera raga-a Seten ira urioroi. Ira viapau rutu uvuiparoi ra ragai vo goruaro-ia putepareve. ");
INSERT INTO roo_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ari ita, uvare oiso ruipaparai ra oirara voeao vo rasio-ia taraiave, Ragai Aite oaa kaviko iraopaavoi. Oa iava oisi piepaaveira oiso osa Aite ragai tavipareveira. Oire toreta ra vova avavio. ");
INSERT INTO roo_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Ragai-a wain ova oiraopa ova. Ari Aite oaa-a vo kovo tokipatoa rutu. ");
INSERT INTO roo_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Oirara voeao oea ragai oirao piepaiveira oea oiso rutu toupai osa sipukau raoro ragai iava oraoroa kuepapeira. Ari ro ira viapau ragai oirao piepareve, ira tokorevere Aite oiso osa rurui raoro oara tokopareveira ro kovo tokipato. Oire uva ro ira oirao pie vovou purapareveira, ira sopaaro iava orugoorovu vuri rugooro oaive verapareveira Aite. Oiso ra rirovira rera vo kuearo kareke piereve aue oirao pie vovouaro-ia. Oiso rutu osa ruipapaoro ro kovo tokipato evao raoro tokopareve. ");
INSERT INTO roo_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Uva visii sopaaro iava vuri rugooro oavisii vera pirora aue iavirava Tugoropa Reo, oreoa iava visiipa siposipopaavora. ");
INSERT INTO roo_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ragai tapo ora tavosipaoro toupata. Ra ragai tapo ita visii tapo ora tavosipaoro toupaa. Uvare viapau raoa kue oupai vosa viapau evaova varaaro-ia toupaive. Oiso rutu osa visii visiigoa viapau uvuipatai ra oirao pie vovouro purapata vosa viapau ragai tapo ora tavosipaoro toupata. ");
INSERT INTO roo_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ragai-a wain ova rutu. Ari visii-a raoara. Ro ira ragai tapo ora tavosipaoro toupareve ovusa ragai tapo ita rera tapo ora tavosipaoro toupaa, ira-a eera ira rirovira rutu aio kue purapareveira. Ari vosa viapau ragai-ia toupata, oa iava viapau oiso uvuipatai ra oavu avu vai purapata. ");
INSERT INTO roo_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Vosa viapau irai ragai tapo ora tavosiparo, ira taru eera verarevere Aite oaa oiso osa evao rao vao oa erakope. Ra va iava vo raoro guruguruive vara-ia vikisa tuitui kasi-ia vara kasioro. ");
INSERT INTO roo_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Vosa ragai tapo ora tavosipaoro toupata. Ora vosa ragai vo reoaro visii-ia toupaive. Ra oisi iavirava uvuipai ra variripata visii vo ruipaaro arova katai vovou purapaoro ragai-ia. Ra va iava visii vo ruipaaro uvureve Aite oaa va purasa. ");
INSERT INTO roo_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Vosa rirovira rutu aio kuero vai purapata, ovovoua iavirava eva eisi vuurapa vaisi oupareveira Aite. Osa iava uvuipatai ra oiso rutu toupata, Ragai voeaaro visii disaipel. ");
INSERT INTO roo_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Aite ragai kavikopareveira. Eisi raga osa visii kavikopaaveira. Oa iava vokiara rutu-ia uvuipatai ra oiso toupata, Ragai voeaaro rutu oea kavikopaaveira. ");
INSERT INTO roo_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Vosa vearovira rutu ragai vaaro reo goru sirova utupata, eva-a oa iava uvuipatai ra ragai vo siraoaro sovara-ia toupata. Oiso raga ita osa Aite vaaro sirova reo goru vearovira utuparaveira. Oa iava rera vo siraoaro sovara-ia toupaaveira. ");
INSERT INTO roo_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Oiso ruipaparai ra ragai vo roruaro visii-ia toupaive. Ra oisi iavirava vo roru eva visii sopaaro agasi piepaive rutu. Eva-a oa vituaro iava vo reo purapaavoi visiire. ");
INSERT INTO roo_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Ragai vaaro-a vao reo goru oiso toupaiveira, Ora visii araoko iraraviaro kaviko iraopata. Oiso osa ragai ita visii kaviko iraopaaveira. ");
INSERT INTO roo_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Vosa irai ora irai iava tootooa vaiaro vikireve ora irai vate irara vaiaro tauvaoro, oire uva viapau oiso ovovouiei siraopa vovou vai oa vao-ia putepaiveira. ");
INSERT INTO roo_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Vosa oiso rutu piepata osa visii tavipaavoi, oa iava uvuipatai ra oiso rutu toupata, Ragai vate iraraaro rutu visii. ");
INSERT INTO roo_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Kovopa irara viapau uvuipaai ra vao-ia taraipaave oa purapareve voea reitoaaro. Eisi osa iava oisi viapau visii vaisipaavoi vorerivira oiso, Kovopa irara. Aue iava uvare reoara rutu vateavorao visii siposipopaoro aue iava Aite. Oreoroa ouava rera ruvara-ia. Eva-a oa iava oiso visii vaisipaavoi, Vate irara oaa. ");
INSERT INTO roo_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","“Viapau oiso ora visiipa ragai reesitava. Viapau. Ari visii ora ragaipa ropooro visii reesiava ragai raga. Oa iava visii tovoava kovoa-ia. Osa iava uvuipatai ra avataera, aio kuero purata. Osa iava visii vo aioroaro uvuipai ra toupaive opesi asavira. Eisi piepaoro uvuipatai ra ragai vaisiaro-ia variripata Aite iare. Ra visii vatereve oavu avu vai. ");
INSERT INTO roo_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Visii vateavora reo goru vaore, oiso ra ora visii araoko iraraviaro kavikopata. ");
INSERT INTO roo_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Vosa oirara voeao vo rasio-ia visiiva keripaave, osa iava uvuipatai ra taraita oiso, Oea-a evoea ragaiva keri rovoaera rovovira. ");
INSERT INTO roo_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Vosa visii vao vo rasio rutu iava-a voea, ra oisi iavirava visii agiagipaive oearovu. Vo uvare visii-a voea iavapa irara. Ari ita, viapau oiso visii-a vo rasio iava. Viapau. Aue iava uvare visii reesiavora oiso ra vo rasio vo pitupituaro kavuta. Eva-a oa iava oirara voeao vo rasio-ia visiiva ora keripaaverea. ");
INSERT INTO roo_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Vearovira rutu vo reore rugoo iraopatavere oa puraavoi visiipa oiso, Viapau oiso kovopato rera reitoaaro-ia putepareveira. Osa-a eisi osa iava voea evoea oisoa ragai upopaive, eisi raga osa visii upopaivere. Ari ita, vosa ragai vo reoaro sirova utupaaeri, oire ra oisi raga ita visii vo reoroaro sirova utupaave. ");
INSERT INTO roo_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ari viapau taraipaaveira Aite-ia ro ira ragai arureva vore. Ra oisi iavirava keapaoro ragai vaisiaro-ia visii-ia vuri vovouro purapaive. ");
INSERT INTO roo_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Vosa viapau oiraopavira urioraeri voeapa siposiposa, eva-a oa iava viapau vuriara vaieri voea-ia. Ari ita, urioraera voea oiraopavira siposipopaoro ragai vo kovoaro vituaro iava. Osa viapau vo siposipo oirao pieive. Eva-a oa voea vo vuriaro vituaro. Oa roroiovira toupaiveira. ");
INSERT INTO roo_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ro ira ragaiva keriparo, eera ita-a ira Aite tapova ora keriparoveira. ");
INSERT INTO roo_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ari ita, okovorovu rutu oara oisoa viapau oearoi tuariri purapaive okovoroa puraavora voea rutu vuutaaro-ia. Oiraopavira rutu vosa viapau vo kovoro puraavori, ra oisi iavirava viapau vuriara vaipe voea-ia. Ari ita, vo osa vo vokio vara kekeivora uva ragaiva ora keripaai ora Aite oaa tapova. Eva-a ita voea vo vuriaro vituaro. ");
INSERT INTO roo_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Uva voea vo pitupituroaro iavirava vo reo oiraopavira karekeepa oa rigatoiva vo voea vaaro-ia Reo Taisi. Oreoa vao oa oiso toupai, Ragaiva keri ragapaai. ");
INSERT INTO roo_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Ro visii Tauvapato ira epao Aite tapo uvava rera aruavere, ra urioro visii iare. Eera Tugoropato Uraurato Oiraopa Rutu Kareke Piepato varao Pautoa iava. Ira Aite tapo toupareveira uvava uriorovere ragai iava oiraopavira siposiposa. ");
INSERT INTO roo_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Visii tapo ragai iava oiraopavira siposipopatavere. Uvare tuariri visii ragai tapo oisoa toupata voari rovoa-ia ovusa kovoa rovoava. Oa iava vo voki-ia rekasisa voava uriotaerao oa-a vao-ia. ");
INSERT INTO roo_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Visii taviavora ragai vo reoroaro iava, Teapi visii varaaro oirao pie vovouro oavisii kovepe opesioro. ");
INSERT INTO roo_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Vo osa visii sigupaivere vova Reo Taisi Uvupa Kepa Sinagog voea vaaro. Osa raga ita visii piepaiverea visii upopaoro vo vuutarori-ia oara uriopaperea. Ra oiso keapaave, Vearo kovo purapaivoi Pauto vaaro. ");
INSERT INTO roo_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Viapau oiso Aite-ia taraipaaveira. Ora viapau oiso ragai-ia tapo taraipaave. Eisi osa iavirava vo vovouro purapaiverea visii-ia. ");
INSERT INTO roo_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ari ita, visii oisoa tavipaa vara iava oara utupaua karekepaperea. Oa iava varare vorevira rugorugoopataverea, vo uvare vara iava visii tavipaaveira. “Tuariri oisoa visii tapo toupaa. Osa vituaro iava eisi viapau oisoa visii tavipaa va iava vao. ");
INSERT INTO roo_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Uva vaoviopavira avaparai ro iare ira ragai arurevoiva, vore urioraepa. Uva viapau oiso irai visii iava ragai akeparevoi oiso, Ovu iare avapauei? ");
INSERT INTO roo_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Viapau. Ari ragai raga vo reo puraavoiva, visiire sopaura oavisii vavatapai siraopaoro. ");
INSERT INTO roo_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Oiraopavira rutu oiso visii tavi iraopaavoi, Visii arova avaparai visii tauvasa. Oire vosa viapau avara, ra va iava viapau irai urioro visii tauvasa. Ari vosa avaparai, osa iava visii iare rera aruavere ra urioro eera visii Tauvapato visii soporepasa. ");
INSERT INTO roo_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Uva uriorovere, ra oirara rutu voeao vo rasio iava tarai iraoaverea vuri vovouro rutu vituaro-ia voea varaaro, ora vao torevoko vovou rutu vituaro, ora kort vituaro-ia oira roviriei pitupitu Pauto vaaro, vo rara voea soporepareve. ");
INSERT INTO roo_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Oire uva ora voea vo vuri vovouroaro vituaro-ia taraipaavere. Oa vituaro oiso toupai, Viapau ragai oirao piepaiveira. ");
INSERT INTO roo_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Oirara rutu vo rasio-ia oea vearovira ragai-ia taraipaavere oiso, O ita, ari torevokotoa rutu-a ro Jisas. Aue iava uvare avaparai vore Aite oaa ruvara-ia. Ra viapau vorerivira ragai kekepata. ");
INSERT INTO roo_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ari oira rovirieipa pitupitu iava voea soporepareverea ro Tugoropato Uraurato. Aue iava uvare Pauto Seten vo goruaro rovirieioro va putereva, uvare rera raga Seten vo rasio vo pitupituaro vituaro. ");
INSERT INTO roo_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Ari ita, riro reoro rutu epao oarava toupaa. Uva oiso ruipaparai ra visiipa tavitavira vara iava, osa viapau. Uvare viapau oiso uvuipatai ra vaoviopavira vo reoro outa. Teapi visii iava sopaura oavisii vavatapape rutu. ");
INSERT INTO roo_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ari vosa oiraopa reoa rutu vituaro urioro, rera ro Tugoropato Uraurato ira oiraopa reo rutu iava visii soporeparevere. Ra viapau oiso ora rera raga vo rugorugooroaro iava reoreoparo. Viapau. Ari vo reo-a oa uvureve Pauto ruvara iava oa siposipoparevere. Oire ra oisi visii tavitavipaoro varao iava oara karekepaperea utupaua visii soporepareve. ");
INSERT INTO roo_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ira ragai vo vovouaro-ia taraipaoro va iava visii soporeparevere. Osa-a eisi piepaoro ragai iava rei vaisi kareke piereverea rara. ");
INSERT INTO roo_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Orekerovu rutu Aite varaaro oara-a evara ragai raga ita varaaro. Eisi osa iava oiso purarai, Ira ragai vo vovouaro ouoro va iava visii siposipopaoro visii soporeparevere ragai iava. ");
INSERT INTO roo_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Gare vuutavi raga ra viapau ragai keketa vorerivira. Oire uva ita utupa visivi aia ragai keketavere ita rara.” ");
INSERT INTO roo_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Uva oearovu disaipel voea raga ora reopaoro oiso purapaaepa, “Aa vao rutu-a vo reo vao vituaro oa purarevoi vigeire? Oa-ia oiso puraroi, Gare vuutavi raga, ra viapau vorerivira ita ragai keketa. Uva ita gare vuutavi raga pere, ra utupauavi ita ragai keketa. Uva oiso tapo pura, Aite iare avaparai.” ");
INSERT INTO roo_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Oire uva oiso puraaepa, “Gare vuutavi raga-a oa iava oisi taviroi. Oa apeisi ragavira toupai? Vigei viapau oiso taraipaviei vo reo vituaro-ia eva oa purarevoi.” ");
INSERT INTO roo_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Oire uva Jisas voea vo rugooaro ou ovoireva vo osa rera akesa auepaaepa. Oa iava oiso puraroepa, “Asi visii vai pasi ora akeakepatai vo reo vituarore oa puraavoi. Oa-ia oiso purarai, Gare vuutavi raga toupai, ra viapau ita vorerivira ragai keketa. Uva ita, utupa visivi rara ragai ita keketavere. ");
INSERT INTO roo_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Oiraopavira rutu visii tavipaavoi oiso, Utupaua gaupatavere sirao pievira rutu. Vo ovusa oirara rutu voeao vo rasio iava rorupaive. Ora tapo osa visii iava sopaura vavata iraope siraoa iava. Oire uva vo sirao-a eva oa roruvira rutu ora porepere taru. ");
INSERT INTO roo_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Vosa riakova kakae kavausa auepao, oire ra ora oira vo vuutaaro-ia taraio oiso, Karekeei ragai vo vuutaaro. Oa iava rirovira rutu siraopao. Oire ra va isivaaro iava kakaeto kavaueve. Ra viapau oiso evo upiare vorerivira rugoo oa puraeve. Viapau. Ari roru iraopaeve kakaeto raga-ia ro ira karekero. ");
INSERT INTO roo_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Oiso ita osa vaoviopavira siraopatai. Ari utupavira vorevira visii kekeavere. Ra oisi iavirava sopaura oavisii visii iava roru iraove. Osa iava eisi viapau oiso irai uvuiroverea ra visii iava vo roru eva verareve. ");
INSERT INTO roo_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Oire uva vo voki-a eva oa-ia viapau oiso ragai akepatavere oavu avu vaire. Oiraopavira rutu visii tavipaavoi, Aite oaa iare variripata ragai vaisiaro oirao piepaoro. Ra visiipa taru vara vaterevere. ");
INSERT INTO roo_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Voari tuariri uva viapau oisoa variripata ragai vaisiaro oirao piepaoro orekerovu avu vai oupasa. Oire vo vokio uva variri iraopatavere, oisore ra oisi iavirava oaravu avu vai oupata. Osa-a eisi osa vituaro iava visii iava sopaura roru iraopaivere rutu. ");
INSERT INTO roo_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ragai oiso vo reoro puraavoi visiire ruuvira. Uva utupaua viapau oiso vorerivira ita visiire oisi ruuvira reoravere. Viapau. Ari visiipa evoa aviavi pievira raga taviravere Aite iava. ");
INSERT INTO roo_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Uva vo voki-a eva oa-ia ragai vaisiaro oirao piepaoro variripatavere. Uva viapau oiso visii tavipaavoi, Ragai raga Aite iare variriparavere, oisore ra visii tauvapareve. ");
INSERT INTO roo_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Viapau. Ari Aite raga visii kavikopareveira. Uvare visii raga-a ita vao visiigoa ragaipa ruipataera. Oa iava ragai oirao pietavora vao iava osa Aite tapo toupaavoiva, urioraera vore. ");
INSERT INTO roo_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Uvare tuariri rutu Aite tapo oisoa toupaa. Oa iava rera arova urioraepa vore rasitoa-ia. Uva vo vokio-ia vo rasio kavuoro Aite iare voreparai.” ");
INSERT INTO roo_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Oire uva igei disaipel rerare oiso puraiepa, “Iu, vo vokio-ia aviavi pievira tavitaviu. Viapau oiso ra ruuvira raga reopau. ");
INSERT INTO roo_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Uvare oiso taraiiei, Viapau oiso voearore tue rovopau oearoa vii akesa auepaave. Viapau. Ari vii auero rutu-ia tarai iraopauei. Eva-a oa vituaro iava vii oirao piepaioveira rutu oiso, Viigoa vao Pautoa tapo tourivoiva, uriouepa vore.” ");
INSERT INTO roo_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Oa iava Jisas oiso igei akereva, “E vo vokio-ia oiraotai rutu, raa? ");
INSERT INTO roo_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Uvuta. Vuuta vao-ia tutuu pievoi vaore oiso ra karekepe. Iu. Kareke ovoiei vo vokio oa-ia visii tariopaivoi rara vorarore visii vo uruiroaro-ia roopavira. Uva ragai kavupatavoi ovusa ragai raga toupaa. Ari ita, uva viapau oiso ragai raga toupaavere. Viapau. Ari ragai tapo touparevere Aite rara. ");
INSERT INTO roo_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Uva oiso ruipaparai rutu ra ragai tapo ora tavosipata. Osa iava sopaura oavisii uvuipai ra gavaurevira toupaive. Eisi osa iava vo reo visiire puraavoi. Oiraopavira uvare vo rasio-ia tou irara visiipa riroa rutu tavaka siraoa vatepaiverea. Osa iava uvuipatai ra tuvuu vovouvira rutu goruvira toupata. Uvare ragai vo rasio vo vovouaro vo goruaro-ia pute iraoavoi.” ");
INSERT INTO roo_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Oisi-a oiso osa puraroepa Jisas. Oa iava vuvuiua taraaoro oiso puraroepa, “Aite. Ragai vo vuutaaro-a vao pura piroi. Osa iavirava uvuipau ra ragai vaisiaro kae pieri. Eisi osa iava ragai vii Oviitoaaro vii vaisiaro kae piepaaverea. ");
INSERT INTO roo_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Uvare ragai vateriva reesia oiso ragai reesioro, Ragai-a oirara rutupa reipato. Osa iavirava uvuiparai ra oirarapa Opesi Asa Tootoo vatepaa voeao oea ragaipa vateriva. ");
INSERT INTO roo_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Oa-a vao Tootoo Ovoi oa oupaivere vo rara vii-ia tarai rovopaave oiso, Vii-a Kataitoa raga Pauto, Oiraopatoa rutu. Ora vo osa ragai-ia tapo tarai rovopaave, Ragai Jisas Krais ragoa aruriva vore. ");
INSERT INTO roo_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","“Vii vaaro keraria vo goruaro kareke pieavora vo rasio-ia. Okovo-a vao vateriva ragaipa va purasa oa opesi pieavoi. ");
INSERT INTO roo_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Aite. Voari tuariri rutu uva rasito kareke asavira toureva, ovuuta-a eva oa-ia vii tapo toupaoro oisoa oisi rei vaisivira toupaa. Uva vo vokio-ia oiso ruipaparai ra vo vaisi raga ita eva reia vateri ragaipa vo vegei vo touaro-ia. ");
INSERT INTO roo_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Voeapa vii vo ruipaaro kosi pieavora voeao oirara oea ragaipa vateriva vo rasio-ia vii voeaaro. Ari ita, uva ragaipa voea vate ovoiriva. Oa iava vii vo reoaro vearovira rutu sirova utupaaveira. ");
INSERT INTO roo_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Osa-a eisi osa iavirava oiso taraiaerao, Orekerovu rutu varao oara vate ovoiriva ragaipa oara vii ruvara iava urioepa. ");
INSERT INTO roo_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ari ita, vo reoro rutu oara ragaipa vateriva oara rutu voeapa vateavora. Oa iava vara ou ovoiivora. Osa iava tarai ovoiaera oiso, Oiraopavira, uvare tuariri rutu oisoa vii tapo toupaa. Oa iava voava urioraepa. Ora vao oirao pieivora rutu ita osa ragai arurivora vore. ");
INSERT INTO roo_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Variriparai voea tauvasa. Ari ita, viapau oiso oirara rutupa voeao vo rasio-ia variriparai. Viapau. Ari voea raga tauvasa oea roporiva ragai iare, uvare vii voeaaro-a. ");
INSERT INTO roo_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Uva voea rutu-a ragai voeaaro evoea vii voeaaro. Uva ita, voea rutu-a vii voeaaro evoea ita ragai voeaaro. Oea ragai vaisiaro kae piepaiveira. ");
INSERT INTO roo_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Vo vokio viapau oiso touvira toupaavoi vo rasio-ia. Ari voea vo rasio-ia toupaivere ovusa vii iare uriora. Aite, Tugoropato. Voea kavikori voea tokipaoro ora vii vaisiaro vo goruaro iavirava, vo goru oa vateriva ragaipa. Osa iava uvuipaai ra katai vovou rutu-ia toupaive. Oiso osa vegei katai vovou rutu-ia toupaveaira. ");
INSERT INTO roo_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Vo osa voea tapo toupaoro voea tokipaaveira vii vaisiaro vo goruaro iavirava. Vo vaisio oa goruaro vateriva ragaipa. Oa iava voea-ia vearovira rutu uutuparaveira voea tokipaoro. Osa iavirava viapau irai opesikoparo. Eera ira iava vii vo rigatoaro oiraopere. ");
INSERT INTO roo_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Uva vii iare urioparai. Osa vituaro iava vo reo puraavoi vo rasio-ia. Oa iava ragai vaaro rorua uvuipai ra voea iava sopaura-ia agasipe rutu. ");
INSERT INTO roo_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","“Ari ita, vii vo reoaro vateava voeapa. Osa iava oirara voeao vo rasio iava voeava keripaaveira. Eake iava? Uvare ragai voeaaro vii vo reoaro-ia taraipaoro viapau vo pitupitu purapaiveira oara vo toupaiveira vo rasio-ia. Oiso ita osa ragai ita viapau vara purapaaveira. ");
INSERT INTO roo_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Viapau oiso viire variriparai oiso ra voea kae pieri vo rasi iava uvaire. Viapau. Ari oiso viire variriparai ra voeavi virivaripari. Ra oisi iava vurito Seten viapau voea piro pieparevere. ");
INSERT INTO roo_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Viapau vo pitupituro purapaiveira oara vo toupaiveira vo rasio-ia. Oiso ita osa ragai ita viapau vara purapaaveira. ");
INSERT INTO roo_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ora viipa voea roro pieoro voea reesiri, oisore ra vii vo vovouaro-ia Oiraopa Vovou goruvira pituive. Uvare vii vo reoaro-ia taraipaoro Oiraopa Vovou rutu-ia taraipaaverea. ");
INSERT INTO roo_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Tuariri ragai aruriva oa iava urioraera oirara rutu vuruvuru-ia tousa voeao vo rasio-ia. Eisi raga osa voea voeao disaipel arusa aueparai, oiso ra oirara rutu vuruvuru-ia toupasa avaave. ");
INSERT INTO roo_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Uva ora ragai iava tootooa oaa reesipaavoi voeao tauvaoro. Oa iava vii vaaro-ia Oiraopa Vovou taraipaoro ora reesiavere oiso, Vii oiraraaro-a igei. ");
INSERT INTO roo_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ari ita, viapau oiso voea raga tauvapasa variriparai. Viapau. Ari voeao tapopa variriparai oea voea vo siposipoaro uvupaive. Ra oisi iavirava ragai oirao piepaive rutu. ");
INSERT INTO roo_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Uva oiso ruipaparai ra voea katai vovou raga-ia toupaive. Oiso rutu osa vii Aite ragai-ia toupariveira, ovusa ita ragai vii-ia toupaa. Osa raga ita voeapa ruipaparai oiso ra vegei tapo tavosivira toupaive. Osa iava uvuipai ra oirara rutu vo rasio iava vigei vo vovouaro katai vovou kekepaive, ra oisi oirao piepaive. Ragai arurivoiva, urioraera vore. ");
INSERT INTO roo_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Uva vao keraria vo goruaro ragaipa oa vateriva eva ita oa voeapa vateavoi, oiso ra va iavirava katai vovou rutu-ia toupaive, oiso osa vegei toupaveaira. ");
INSERT INTO roo_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ari ita, ragai voea-ia toupaavoi, ovusa vii ragai-ia touparivoi. Eisi osa raga ita voeapa oiso ruipaparai ra katai vovou raga-ia toupaive. Ra oisi iavirava oirara voeao vo rasio-ia taraipaave oiso, Vii ragai arurivora vore. Ora tapo oiso osa voeapa siraopauveira oiso osa ragaipa siraopauveira. ");
INSERT INTO roo_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Aite. Oiso ruipaparai ra oirara voeao oea ragaipa vateriva ragai tapo toupaiverea vo uva toupaaverea. Oa iava ragai vaaro keraria vo goruaro kekeiverea voa. Aue iava uvare tuariri vo uva rasito pura uviro asavira toureva ovuuta-a eva oa-ia oisoa ragaipa siraopau. Oa iava ragai vateriva va eva keraria vo goruaro. ");
INSERT INTO roo_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Aite. Vii-a Torevokotoa Rutu. Uva oirara vo rasio iava viapau vii-ia taraipaaveira, vo ovusa ragai raga vii-ia taraiparai. Ora voeao disaipel oiso taraipaaveira, Ragai siporiva oa iava urioraepa vore. ");
INSERT INTO roo_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ari ita, vii vo ruipaaro iava siposipoavora voeapa. Uva topa pievira ita aia vii vo ruipaaro kosi piepaavoi voeapa vaore, ra kaviko vovou rutu sovopaive ora voea sopaaro-ia. Oiso rutu osa vii vaaro kaviko vovou sovopaaveira ora ragai-ia. Ora oisore ra ragai tapo voea-ia toupaaverea voeava ora tavosipaoro.” ");
INSERT INTO roo_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Vo variri purarevoiva, Jisas ora igei disaipel tapo avaroepa uuko ovi ivirooro Kidron. Oa iviropavira okovovu Oliv kovo oisoa toupaive. Oa iava vo kovo-ia ora kiusa avaroepa Jisas igei tapo. ");
INSERT INTO roo_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Uva Judas tapo vo kovo-ia taraiparoepa ro Jisas kosi piepato. Uvare vokiara rutu-ia Jisas igei disaipel tapo vo kovo sovara-ia voa oisoa uvuruparo. ");
INSERT INTO roo_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Uva voa-a vo uvare Judas viurupa irara tuvetuvereva ora oearovu polis irara reipa irara pris voeaaro voearei ora voeao ratarataa vovou irara Farisi. Oa iava voare urioaepa aue-ia pitupaoro vuravuara, ora aoara, ora auero rutu varao upo purapara. ");
INSERT INTO roo_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Oire uva Jisas tarai ovoiroepa vara rutu-ia varao oara rera-ia karekesa auepaaepa. Oa iava Jisas voea iare tutuu piereva rutu voeare oiso purasa, “Iroure taraapatavoi?” ");
INSERT INTO roo_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Uva oiso puraaepa, “Ari Jisas, irare taraapaiovoi ro oisova Nasaret.” Osa iava Jisas oiso puraroepa, “Easi ragai raga ita vao-ia.” Uva Judas toreparoepa voea ruvara-ia. ");
INSERT INTO roo_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Uva Jisas voeare oiso puraroepa, “Easi ragai raga ita vao-ia.” Oa iava ora virupaoro vorepaaepa rasiuaaro kovepaoro. ");
INSERT INTO roo_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Uva vorerivira ita voea akereva oiso, “Iroure taraapatavoi?” Oa iava oiso puraaepa, “Ari Jisas ro oisova Nasaret-ia.” ");
INSERT INTO roo_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Uva Jisas voeare oiso puraroepa, “Voari visii taviavoi ita oiso, Ragai raga ita vao-ia. Vosa ragaire taraapatavoi, oire voeao eakapatavoi ra avaave.” ");
INSERT INTO roo_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Uva eisi puraroepa vo reo oirao pieoro tuaririvi oa purareva. Oa-ia oiso puraroepa, “Voea oirara ragaipa oea vaterivora oea iava viapau oiso irai opesikorovere.” ");
INSERT INTO roo_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Oire uva va-a vao oa iava Saimon Pita toorio gororeva Rovopato Pristo kovopatoaaro iava uvareoua pakosa oisova oirapapa varata-ia uvava voua toereva. Ira vaisiaro-a ro-ia, Malkas. ");
INSERT INTO roo_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Oa iava Jisas Pita oiso tavireva, “Toorio tovori rera vaaro-ia pausa. E apeisi-a? O-ia kap viapau ukaioravere iria agasioi aue iava siraoa vo tavakaaro Aite iria vaterevora ragaipa?” ");
INSERT INTO roo_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Oire uva va-a vao oa iava voea rutu viurupa irara, ora reito ofisato, ora polis irara rutu oea rutu Jisas rauiva rera tuukesa iroara-ia. ");
INSERT INTO roo_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Uva rerava ava rovoaepa Anas iare Kaiafas avuetoaaro, ro ira pris kovo-ia reiparoepa vo iva-ia eva. ");
INSERT INTO roo_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ira-a ro Kaiafas voari Jiu-pa irara tavi rovoreva oiso, “Vearopai vosa kataitoa vai raga kopiirovere oirara rutupa tootooaro vateoro.” ");
INSERT INTO roo_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ragai ora Saimon Pita vegoa Jisas sirova utuveiepa. Uva pristo vo kepaaro kasuraaro iare koataraepa Jisas sirova. ");
INSERT INTO roo_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ovusa Pita ratau toreparoepa. Oa iava ragai vao ragoa-ia oisoa reito pristo taraiparo, ragoa avaraepa riakova tavisa o iria oiso rataoa tokipaeve. Oa iava Pita koata pieava atoarore ragai arova. ");
INSERT INTO roo_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Uva o tavauruva iria oisoa ratao tokipaeve rerare Pita oiso puraopa, “Easi vii-a iravu disaipelto rera reraaro, raa?” Oa iava Pita oiso puraroepa, “Viapau oiso ragai-a.” ");
INSERT INTO roo_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Oire uva kovopa irara voearei ora polis irara oavu tuitui kasi kasiva, uvare rirovira rutu uteopaaepa. Uva voa torepaoro vo kasi-ia tuituipaaepa. Uva Pita voa voea tapo toreparoepa tuituipaoro. ");
INSERT INTO roo_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Uva Rovopato Pristo Jisas akereva disaipelre voeao rera voeaaro ora vaore osa oisoa oirara rutupa siposipopareve. ");
INSERT INTO roo_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Oa iava Jisas rera vo reoaro pukooro oiso puraroepa, “Ari ita, poeravira rutu oirarapa oisoa siposipopaoro voea tarai piepaa vo Tugoropa Kepa-ia aue Tempel, ora varao oara iare oisoa ora gurupaave Reo Taisi uvupasa Jiu-pa irara. Uva viapau oiso vatauvira oreovu avu vai oisoa purapaa. ");
INSERT INTO roo_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Uva eakere ragai akepari? Ari voea akeri evoea oea vo reoro uvuivora. Oa iava vo reoro-ia taraiaera varao oara purapaaveira.” ");
INSERT INTO roo_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Uva oisi-a eisi osa puraroiva, iravu polisto toreroepa Jisas tapaoro oiso puraoro, “Eakere Rovopatoare Pristo eisi reopauei, raa?” ");
INSERT INTO roo_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Uva Jisas rerare oiso puraroepa, “Vosa vuri reo vai puraa, oire uva uvuipau ra vo reo avu vuri reo kosi pieri. Ari vosa vearo reo raga puraa, uva eake-a vao oa rutupa ragai tapari?” ");
INSERT INTO roo_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Osa iava tuukea ragava toupareva Jisas, vo osa vava Anas rera siporeva Rovopatoa iare Pristo Kaiafas. ");
INSERT INTO roo_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Uva Saimon Pita voari tuituipaoro toreparoepa. Osa voa rerare oiso purapaaepa, “Asi vii-a iravu vai disaipelto rera reraaro, raa?” Uva ora taearoepa oiso puraoro, “Viapau oiso ragai-a.” ");
INSERT INTO roo_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Uva iravu kovopato Rovopatoapa Pristo roari saratoaaro Pita ira iava uvareoua toereva, ira oiso puraroepa rerare, “Oiraopavira rutu, uvare ragai tapo ita vii kekeavora ovusa rera tapo touparivora kovoa-ia.” ");
INSERT INTO roo_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Uva Pita ora taearoepa ita oiso puraoro, “Viapau oiso ragai-a.” Vo osa kookai gau ovoireva. ");
INSERT INTO roo_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Oire uva Kaiafas ruvara iava rerava avaaepa ro reito Rom gavmanaro vo kepaaro iare vokipaua rutu. Uva viapau oiso voea rutu Jiu koataaepa vo kepa-ia vao reito gavman vo kepaaro. Uvare oiso rugoopaaepa, Teapi vuivui oupe Reo Taisi gasioro, ra viapau Pasova Vurei aiope. ");
INSERT INTO roo_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Oa iava ratau toupaiva. Uva Pailat voea iare urioroepa oiso voea akesa, “Eakepa ro iava gasitavoi?” ");
INSERT INTO roo_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Oire uva rera vo akearo pukooro oiso puraaepa, “Vosa rera ro viapau vuriara vai purapareve, oire ra viapau oiso rerava urioio vii iare.” ");
INSERT INTO roo_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Osa iava Pailat voeare oiso puraroepa, “Visii raga rera outa, ra rera rovirieita kortua-ia visii vaaro sirova Reo Taisi.” Oa iava Jiu rerare oiso puraaepa, “Asi igeipa tugoropai rutu vaopa vo osa iravu kopii pieio.” ");
INSERT INTO roo_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ari ita, tuariri Jisas ora rera iava taviroepa ora rera vo kopiiaro reesioro. Uva oisi-a oiso osa iava rera vo reoaro oiraosa auepai. ");
INSERT INTO roo_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Oire uva Pailat vorevira koataroepa voarire gavman kepa-ia. Oa iava Jisas-re keeraroepa. Uva rera akeoro oiso puraroepa, “E vii-a Jiu reraaro king, raa?” ");
INSERT INTO roo_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Uva Jisas rerare oiso puraroepa, “Easi vii vai raga oisi eisi rugoouei oa iava evo reo purarivoi, raa? O irai vai pasi vii tavirevo ragai iava oisi eisi, eke?” ");
INSERT INTO roo_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Uva Pailat rerare oiso puraroepa, “Easi pasi Jiu-patoa vai-a ragai, raa? Ari sara irara oara raga ora reipa irara pris irara viiva urioai ragai iare. E eake vai purarivora?” ");
INSERT INTO roo_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jisas oiso puraroepa, “Ari ita, ragai vo Saraaro viapau oiso vo rasio iava. Vosa oisi eisi, oire ra kovopa irara oaa upoa vai puraive. Ra viapau oiso irai uvuiro ragai tovosa Jiu-pa irara vavaearo-ia. Ari ita, uva vo vokio ragai vo Saraaro viapau oiso vo rasio iava.” ");
INSERT INTO roo_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Osa iava Pailat rerare oiso puraroepa, “O ari iravu-a vii king, raa?” Uva Jisas oiso puraroepa, “Vii raga ita-a viigoa ragaire oiso purauei oiso, king. Aako ragai kavaueva. Oa iava vo rasio iare urioraepa va ragare vao-ia. Uvare ragai vo kovoaro-a Oiraopa Reo rutu iava siposipopasa. Ari ita, oirara rutu voeao oea Oiraopa Reo rutu sirova utupaaveira oea-a evoea oea ragai gisipoaro uvupaiveira.” ");
INSERT INTO roo_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Uva Pailat rera akereva oiso, “Eake rutu-a vao Oiraopa Reo, raa?” Oire eva eisi osa akerevoiva, vorevira kosiro viropa voea iare Jiu. Oa iava oiso voea tavireva, “Viapau oiso oavu avu vai vuria vai kekeavoi rera-ia. ");
INSERT INTO roo_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ari visii vo pitupituaro toupai, oiso ra visiipa iravu iava vasea tuukepa kepa iava vo Pasova Aio vo vuutaaro-ia. Uva ruipapatai pasi oiso ra visiipa king iava ro Jiu reraaro vasea, raa?” ");
INSERT INTO roo_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Uva voea rutu raga pieoro oiso puraaepa, “Viapau. Ari Barabas iava vase iraori.” Eera Barabas riro oirara upoto ora orekerovu tapo kavirupato. ");
INSERT INTO roo_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Oire uva Pailat Jisas vorevira koata piereva vore uva viurupa irara rera ragipaiva. ");
INSERT INTO roo_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Oa iava rerapa kukuvaipa puraiva rokarokapa iro iava. Uva va tovoiva rera kukuearo-ia. Ora revasito kuvupato ira-ia rera kuvuiva rera reesioro oiso, Vii-a king. ");
INSERT INTO roo_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Oire uva rera ruvara-ia pou viropaoro rerare oiso purapaaepa, “Vearo voki Jiu reraaro king.” Uva oisi purapaoro rera taparakopaiva. ");
INSERT INTO roo_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Oa isivaaro iava Pailat voea iare kosiro viropa vorerivira ita voeare oiso purasa, “Ragai kekepatavoi ragoa visiipa rera kosi pie ovoiavoi. Ra oisi iavirava taraita oiso, Ragai viapau vuria vai kekeavoi rera-ia.” ");
INSERT INTO roo_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Oire uva Jisas kosiro viropa. Uva va vao kukuvaipa oa puraiva iroiro iava rokarokapa iro oa rera kukuearo-ia toupaiva. Ro tapo revasito kuvupato ira rera-ia toupareva. Uva Pailat voeare oiso puraroepa, “Rera kekepatavoi ro-ia.” ");
INSERT INTO roo_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Uva va-a vao oa iava voea reipa irara pris voearei ora polis irara rera kekeoro oiso puraaepa, “Rera tapa evao parikou-ia! Rera tapa evao parikou-ia!” Oa iava Pailat voeare oiso puraroepa, “Ora visii raga rera outa rera tapasa evao parikou-ia. Ari ragai viapau oiso vuria vai kekeavoi rera-ia.” ");
INSERT INTO roo_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Oire uva voea Jiu rera vo reoaro tuuoro oiso puraaepa, “Ari ita, igei vaaro Reo Taisi toupaivoi rerarepa, oiso ra kopiiro rera ro-ia. Uvare oiso puraparoveira, Ragai-a Pauto Oviitoaaro.” ");
INSERT INTO roo_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Uva Pailat vo reo uvuoro uriri iraoparoepa. ");
INSERT INTO roo_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Oa iava vorevira koataroepa gavman kepa-ia voa Jisas akesa oiso, “Ovuva karekeuepa?” Uva Jisas viapau oiso rera vo reoaro aatopareva. ");
INSERT INTO roo_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Oire uva va-a vao oa iava Pailat rerare oiso puraroepa, “Eakepa viapau ragai aatopari, raa? Auoro. Uvuiparai ra vorevira vii iava vasea. Ora tapo uvuiparai ra vii tapaa evao parikou-ia. Easi pasi viapau va vai-ia taraipauei, raa?” ");
INSERT INTO roo_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Uva Jisas rerare oiso puraroepa, “Vosa Pauto ro oisova viara-ia viapau viipa gorua vai vaterevori, oire ra viapau vii-ia gorua vaipe ragaipa reipasa. Osa-a eisi osa iava ro ira ragai tovorevorao vii vavaearo-ia ira vo vuriaro eisi vii vo vuriaro-ia putepaivoi rutu.” ");
INSERT INTO roo_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Oire uva vo reo vao uvurevoiva, Pailat raiva taraaroepa, oiso ra oai iava Jisas iava vorevira vasereve. Ovusa aue Jiu-pa irara rirovira rerare oiso puraaepa, “Vosa rera iava vorevira vaserivere, oire ra viapau oiso vii-a igei reitoaaro rutu Sisa vatetoaaro. Ro ira ora rera ragare oiso puraparoveira, Ragai-a king, eera Sisa vo tavukiaro ousa auepa.” ");
INSERT INTO roo_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Uva Pailat evo reo uvuoro Jisas kosi piereva. Oa iava oira rovirieipato vaaro-ia paupa pauroepa uvavu uva oisoa vaisipaive oiso, Aveke Uru. Ari aue-ia Hibru reo oiso oisoa va vaisipaive, Gabata. ");
INSERT INTO roo_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Oire uva vo vokia-a vao orekerovu ravaapa voki aue iare Pasova Vurei. Uva ravireo vuuta rutu-a vao oa-ia tuguraaepa. Oa iava Pailat Jiu-re oiso puraroepa, “Rera kekepatavoi, eera Jiu reraaro king.” ");
INSERT INTO roo_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Uva rirovira rutu raga pieoro oiso puraaepa, “Rera siguri! Rera siguri! Rera tapasa evao parikou-ia!” Uva Pailat voeare oiso puraroepa, “E oiso ruipapatai ra visii reraaro king tapaa evao parikou-ia, raa?” Oa iava reipa irara pris irara oiso puraaepa, “Viapau oiso igei irai epao ita kingtoa vai. Ari kataitoa raga, Sisa.” ");
INSERT INTO roo_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Uva va-a vao oa iava Pailat Jisas iava vasereva voea vavaearo iare, oiso ra rera tapaive evao parikou-ia voeao viurupa irara reipa irara pris irara vo ruipaaro sirova utuoro. ");
INSERT INTO roo_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Oire uva Jisas ouiva. Oa iava rera raga evao parikou kaepareva. Uva riro urui kavuoro rerava avaaepa uvavure uva oisoa vaisipaive oiso, Kukue Keru Pukui. Ari aue-ia Hibru reo oiso-ia, Golgota. ");
INSERT INTO roo_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Uva-a evoa uva rera tapaiva evao parikou-ia. Oire evoa aitereivu tapo voa tapaiva aatokorovira oiso, iravu ovaratavu iava ari iravu ovaratavu iava. Uva vaiterei vuruvuruaro-ia Jisas tovoiva. ");
INSERT INTO roo_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Oire uva Pailat oreovu tapo rigatoreva. Oa iava va tovoreva evao parikou-ia vo rigato oa oiso purapai, JISAS KING OAIVE JIU. ");
INSERT INTO roo_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Uva Jisas kotoiva evao parikou-ia vo riro urui ruvara-ia, osa iava riro irara Jiu va vieipaiva voa. Uvare Pailat vo rigato purareva aue-ia Hibru reo, ora Rom reo, ora Grik reo. ");
INSERT INTO roo_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Uva reipa irara pris Jiu voeaaro Pailat tavipaiva oiso purapaoro, “Viapau oiso ra oiso ragavira vo rigato purari, King Jiu reraaro. Viapau. Ari oiso ragavira uvuipauei ra vo rigato purari, Ro oiso puraroepa, Ragai-a king, Jiu reraaro.” ");
INSERT INTO roo_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Oa iava Pailat voeare oiso puraroepa, “Vo reo oa rigatoa, eva-a oa rigato ovoi ita.” ");
INSERT INTO roo_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Uva voea viurupa irara Jisas tapa ovoiiva evao parikou-ia. Uva oisi rera pie ovoioro auero rutu varoara rera varaaro ou ovoiiva. Oire ora voeapa vo resurapavira vara rutu rookaiva, osa voea viurupa irara katakataivira ora voeapa ouaepa. Uva kuvuto tapo rera reraaro ouiva ira-ia viapau oisoa turua vai toupaive. ");
INSERT INTO roo_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Osa-a eisi osa iava viurupa irara ora reopaaepa oiso purapaoro, “Viapau oiso uvuipaviei ra ro karikaripe. Ira-ia uvuipaviei ra rera-ia satupavio, oisore ra oiso piepaoro irai reesipe ro ira rera oureve.” Oire uva oisi-a eisi osa rera-ia piepaiva. Oa iava Tugoropa Vuku vo reoaro oisi iavirava oiraoepa rutu. Vao oiso-ia, ‘Ragai varaaro-ia varoara rooai vara ouoro. Ora satupaai ragai reraaro-ia kuvupato.’ Eisi osa pieiva viurupa irara vara-ia. ");
INSERT INTO roo_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Uva evao parikou vao Jisas vaaro ruvara-ia Jisas aakoaro toupaeva aue tapo taeva, ora Maria rera Klopas vatuavaaro, ora iriavu Maria Makdala iava. Vo resura evairo voavi toupaiva evao parikou ruvara-ia. ");
INSERT INTO roo_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Uva Jisas aakova kekereva vegei rutu ora ragai Jon ragoa oisoa kavikopareve rutu, uvare voavi tutuu pie visivi torepaveiepa. Oa iava Jisas aakovare oiso puraroepa, “Riakova. Eera vii oviitoaaro.” ");
INSERT INTO roo_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Uva ragai tavireva oiso puraoro, “O-ia vii aakoaro.” Oire vo vuuta raga-ia oira ouoro Maria oirava avaraepa ora ragai vo kepaaro iare voa oira tokipasa. ");
INSERT INTO roo_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Uva vao isivaaro iava Jisas oiso tarairoepa, Orekerovu rutu opesi ovoiei vo vokio. Osa iava Pauto vo rigatoaro ora rera iava oirao pieoro oiso puraroepa Jisas, “Uuko regarai.” ");
INSERT INTO roo_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Uva otouvu toupaiva botol tou oa agasiepa aue iava viniga ovi. Oa iava oavu pupupua ouiva va rupu piesa vo ovi-ia viniga ovi. Uva uuko piropa. Uva evao kairi-ia va tuukeiva. Oa iava rera gisipoaro-ia Jisas va tovoiva. ");
INSERT INTO roo_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Uva Jisas va-ia viniga ukaio ovoioro oiso puraroepa, “Opesiei rutu vaoviopavira ragai vo kovoaro.” Eisi osa pura ovoiroiva, rera iava kukue goe ovoio viropa. Osa ora rera iava urauratoaaro iava vasereva Pautoa iare vorevira. ");
INSERT INTO roo_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Uva vo vokia vao orekerovu ravaapa voki aue iare Tagausapa Vurei Pasova ora vao tapo Sabat voki riroa rutu. Oa vituaro iava Jiu-pa irara reasipaaepa oiso, Teapi vo kopiiro evao parikouro raga-ia toupaive vo voki-ia Sabat voki. Oa iava Pailat akeiva voea kokotoaro kepikepisa, oiso ra ikauvira kopiiave. Ra va iava vo kopiiro rere pieive. ");
INSERT INTO roo_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Oire uva voea viurupa irara vaiterei kokotoaro kepikepisa avaaepa aiterea tapaiva Jisas tapo. ");
INSERT INTO roo_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Uva Jisas-ia poua viropa rera kekesa ira kopii ovoiroepa. Oa iava viapau oiso rera kokotoaro kepikepiiva. ");
INSERT INTO roo_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ari iravu viurupato rera varataaro togareva aue-ia togava. Oa iava ikauvira revasiva paru ovoieva ora aue uuko ovi voava rera iava varaua-ia. ");
INSERT INTO roo_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Uva ragai Jon vao kekeava ragoa oisi va-ia tarairaiva, va iava oiso tavitaviparai oiraopavira rutu. Eisi osa iava uvuipatai ra va oirao pieta rutu. ");
INSERT INTO roo_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ari ita, oa-a vao karekeiva oiso-ia Tugoropa Vuku vo reoaro oiraoei vo reo oa oiso purapapeira, ‘Viapau oiso okerui kepiiverea rera iava.’ ");
INSERT INTO roo_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ari oreovu-a vao oiso purapapeira voa Tugoropa Vuku-ia, ‘Irava vurapaiverea ro ira togaivora.’ ");
INSERT INTO roo_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Oa-a vao isivaaro iava Josep Arimatia urui iava rera avaroepa Pailat aresa Jisas kopiire, uvare rera-a iravu disaipelto Jisas reraaro. Ari Jiu ragapa uriripaoro ora rera vo oirao piearo vataupareva. Oire uva Pailat rerapa vasereva. Oa iava Josep avaroepa Jisas iava varaua rere piesa. ");
INSERT INTO roo_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Uva Nikodimas ro ira rovovira rutu Jisas iare urioroepa vokiaro, ira tapo urioroepa oavuva mer vearo geesi ovi iisi ovi. Oa iava va vavataaro rutu aue-ia uvuiepa 34 kilo. ");
INSERT INTO roo_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Uva vo kopii ousiva. Oa iava rera ruusiva varoa-ia oaravu tapo vearo geesiara. Oiso osa vara oisoa purapaive voea Jiu oirara tovapasa. ");
INSERT INTO roo_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Oire uva voa-a vo uva Jisas tapaiva evao parikou-ia uva oisoa oavua kovoa toupaive. Oa sovara-ia oavu oira tovaso riku toupaiva. Ari ita, uva viapau oiso va-ia irai tova rovoiva. ");
INSERT INTO roo_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Uva vo voki-a vao Jiu vaaro orekerovu ravaapa voki aue iare Pasova Vurei Oovapa. Uva vo rikui tutuu pie visivi raga toupaeva. Oa iava Jisas tovosiva rera tovaoro voa vo rikui-ia. ");
INSERT INTO roo_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Oire uva rovo voki rutu-a vao wik iava uva Maria Makdala iava vokipaua rutu urioopa vo tova iare vo osa rupavira raga toupaiva. Iria aveke viapau kekeeva o iria-ia vo tova riaaro-ia toupaeva iria peka pieiva. ");
INSERT INTO roo_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Oa iava ikauvira raga vorevira voreopa ragai ora Saimon Pita tavisa, ragoa Jisas oisoa kavikopareve rutu. Uva Maria vegei tavipaeva oiso purapaoro, “Turaro vorevira tova iava voreivo. Uva viapau taraipaiei oiso, Ovu-ia rera tovoivo.” ");
INSERT INTO roo_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Osa iava vegei ora Pita uruia iava ora vaseveiepa vo tova iare avaoro. ");
INSERT INTO roo_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Uva ikauvira raga avaveiepa. Ari ita, uva ragai Pita-ia puteava ikauoro. Oa iava voa pou rovora viropa vo tova-ia. ");
INSERT INTO roo_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Uva voa kokeesa takura viropa osa iava varoara raga kekeava. Ari ita, uva viapau oiso koataraepa rutu vo rikui-ia. ");
INSERT INTO roo_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Uva Saimon Pita ragai sirova utuoro rikui rutu-ia koataroepa. Oa iava voa varoara kekereva. ");
INSERT INTO roo_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Uva voa oavu kekereva varoa vao oa-ia rera kukuearo tavuruiva Jisas. Oire uva va eva varoa viapau oiso varari tapo toupaiva oara-ia rera rutu tavuruiva. Viapau. Ari evo viko uvavu raga toupaiva. ");
INSERT INTO roo_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Uva ragai tapo ragoa ira rovoraepa voare rikui-ia ragoa tapo ita voare koataraepa. Oa iava va eva kekeava. Uva oisi-a eisi osa iava oiraoraepa rutu. ");
INSERT INTO roo_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Uva evo vuuta-ia viapau oisoa roroiovira rutu taraipaio Pauto vo rigatoaro-ia vao oa oisoa oiso purapape, Jisas vorevira toreroverea tova tapi iava. ");
INSERT INTO roo_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Oire uva vegei disaipeltoarei vorevira kareveiepa atoiare. ");
INSERT INTO roo_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maria rikui raga ruvara-ia torepaopa gaupaoro. Uva voa raga gaupaoro toupaeva rikui sovara-ia kokeepaoro. ");
INSERT INTO roo_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Oa iava aitereivu enseltoarei kekeeva aiterea popotetoarei-ia kuvupasiepa kuvutoarei. Uva voa paupasiepa vo uva Jisas varaaro tovoiva, iravu oisova uva kukueparoepa, ari iravu oisova uva kokotoparoepa. ");
INSERT INTO roo_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Aiterea oira Maria akesiva oiso puraoro, “Riakova. Eakepa gauparivoi?” Uva oiso puraopa vaitereire, “Ari Turaro ragai reraaro ira voraro avu tovosa rera vorevira voreivo vova-ia. Uva viapau taraiparai ovu-ia reraei.” ");
INSERT INTO roo_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Uva oisi-a eisi osa puraoiva, ora poreopa rera Jisas kekesa ovusa toreparoepa. Uva viapau oiso Maria Jisas eveipaeva. ");
INSERT INTO roo_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Uva Jisas oira akereva oiso puraoro, “Riakova. Iroupa gauparivoi? Ora iroure taraaparivoi?” Uva Maria oiso keapaopa, Kovoa tokipato ro-ia. Oa iava oiso puraopa rerare, “Auoro. Vosa vii rera ouri, uva uvuipauei ra ragai taviri vore uva rera tovorivo. Ra voava rera kaeoro karera.” ");
INSERT INTO roo_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Uva Jisas oiso puraroepa oirare, “Maria.” Oa iava Maria ora poreopa rerare oiso purasa Hibru reo-ia, “Rabona.” Oa porearo oiso toupai, Tisato. ");
INSERT INTO roo_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Uva oira tavioro oiso puraroepa, “Opeita ragai-ia pitupari. Ragoa ipa asavira toupaavoi Aite iare. Ari kare iraou, ra araoko irara oaa taviri oiso-ia, Iparai Aite iare ragai reraaro ora visii Aitearo. Ira iare avarai Pauto, ragai reraaro ora visii reraaro Pauto.” ");
INSERT INTO roo_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Oire uva Maria vova Makdala vorevira kareopa disaipel tavisa oiso puraoro, “Turaro kekeavoi.” Uva voea tavieva vo reo iava vao osa oira tavireva Jisas. ");
INSERT INTO roo_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Igei disaipel Jiu asavira uriripaoro toupaiova. Oa iava kepa-ia ora igei ururao tuupaiova. Uva ravireo voa igeire rokoreva rovopa voki-ia wik iava vo voki. Uva voa Jisas igei rutu vuruvuruaro-ia toresa urioroepa oiso puraoro, “Opeita uriripata. Visii iava sopaura oavisii kavepe.” ");
INSERT INTO roo_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Oire uva oisi eisi puraroiva, igeipa ora rera iava vavaearei karekepareva ora ovaratavu rera iava. Oa iava viupara kekepaoro igei iava sopaura oaio roru iraoiva rutu. ");
INSERT INTO roo_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Uva Jisas igei ita tavireva oiso puraoro, “Visii iava sopaura uvuipai ra kave iraope. Ari ita, Aite ragai arureva oa iava urioraepa vore. Osa ita visii arupaavoi ra avata.” ");
INSERT INTO roo_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Uva eisi puraroiva, igei iare vavauroepa oiso igei tavioro, “Tugoropato Uraurato outavoi. ");
INSERT INTO roo_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Vosa oearovivu iava vuri vovouro vai oaive verapataverea, oire ra oisi iavirava vo vovouro vuriara voea iava opesi ovoipape. Ari vosa viapau oisi voea iava vuriara verapata, ra oisi iavirava voea-ia touvira toupaive.” ");
INSERT INTO roo_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jisas ora karekeroepa disaipel irara iare vo vuutao iava vo vokia oa-ia iravu disaipelto igei iava katai tau erao (12) viapau oiso igei tapo toupareva ro-ia Tomas. Ira iava ovaisivu-a, Didimas tavarato. ");
INSERT INTO roo_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Uva oisi-a eisi osa iava oearovu disaipel rera taviiva oiso, “Igei Turaro kekeiovoi.” Uva Tomas oiso voeare puraroepa, “Vosa viapau nilpa vuurei kekea rera vavaearo-ia, ora vosa viapau sipareo roko piea voa vo nilpa vuu-ia. Ora aue tapo vosa viapau vavaea oaa tapo roko piea vo uva rera togaivorao, oire ra viapau oiso oirao piepaa rutu.” ");
INSERT INTO roo_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Oire uva katai wik isivaaro iava igei disaipel kepa sovara-ia toupaiova. Uva Tomas igei tapo toureva. Uva ora igei ururao rataoara rutu tupaiova. Oa iava voa Jisas igei vuutaaro-ia ora karekeoro oiso puraroepa, “Visii iava sopaura kavepe.” ");
INSERT INTO roo_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Oire uva Tomas tavireva oiso, “Ora vii iava sipareo tovori vo-ia. Ora ragai vavaearo kekeri, ra oisi iavirava viapau vakuvakuu. Ari ragai oirao pie iraori.” ");
INSERT INTO roo_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Oa iava Tomas rerare oiso puraroepa, “Vii-a ragai reraaro Turaro. Ora vii-a ragai reraaro Pauto.” ");
INSERT INTO roo_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Osa iava Jisas rerare oiso puraroepa, “Ragai kekerivoiva, ragai oirao pierivoi, raa? Osa-a eisi osa voeao oea viapau oiso ragai kekepaoro ragai oirao piepaive, oea uvuipaai ra vii vo roruaro-ia putepaoro roru iraopaive rutu.” ");
INSERT INTO roo_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ari ita, Jisas ira oisoa oravotorovu purapareve igei disaipel osireiaro-ia. Uva viapau oiso vara rutu rigatoavoi vo vukuo-ia. ");
INSERT INTO roo_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ari vao oa rigatoavoi visiipa, oisore ra va oirao pieoro rutu Jisas oirao pie iraota oiso, Ro-ia Krais. Ora aue tapo oirao pie iraota oiso, Jisas-a Pauto Oviitoaaro. Ora vo osa oirao piepata, osa iava uvuipatai ra Opesi Asa Tootoo rutu ou iraota rera iavirava. ");
INSERT INTO roo_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","2","Uva utupa visivi vorerivira ita Jisas ora karekeroepa igei iare disaipel vo toko rovu ruvara-ia, vao Taibirias. Uva karekeroepa oisi oiso-ia igei iare, Saimon Pita, ora Tomas ira iava ovaisivu-a vao Didimas tavarato. Ari Nataniel Kena iava oiso Galili taere. Ora vegei Sebedi oviitoareiaro, ora aitereivu disaipeltoarei igoa voa toupaiova. ");
INSERT INTO roo_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Uva Saimon Pita igei tavipareva oiso, “Atarisa avaparai.” Oa iava oiso puraiepa, “Vigei rutu ita avapaviei,” Oa iava uvuoa-ia avaiepa. Uva vo rupa-ia eva viapau oiso atari kare vai ouiova. ");
INSERT INTO roo_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Oire uva ravireo sikere asavira toureva ovusa Jisas rogaraua-ia toreparoepa. Uva igei viapau oiso rera-ia taraipaiepa vao oiso, Jisas-a ro-ia. ");
INSERT INTO roo_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Uva Jisas igei akeoro oiso puraroepa, “Ovii irara oaa. E atari kare vai epao?” Oa iava rerare oiso puraiepa, “Viapau rutu.” ");
INSERT INTO roo_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Oa iava Jisas oiso igei tavireva, “Ovaratavu iava oiso uvuoa-ia oirapapa kuverava vikita. Osa iava uvuipatai ra riro kare vai outa aue atari.” Oire uva oisi-a eisi osa iava kuverava roko pieiova uvuoa iava oirapapa varata iava. Uva oira roko pieiovoiva, riro kare rutu kuveraiova. Oa iava viapau oiso uvuipaiepa oiso ra oira kae pieio oira ivuoro. ");
INSERT INTO roo_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Uva ragai Pita taviava oiso puraoro, “Eera Turaro!” Uva Saimon Pita ora rakurakupa varoa veraoro kovopareva. Eisi osa iava vo reo uvureva, Eera Turaro. Oa iava va-ia varoa vorevira ora rakurakuroepa. Uva vo rakurakuva uuko rovu-ia rokoreva. ");
INSERT INTO roo_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ovusa oearovu disaipel uvuoa-ia uriopaaepa kuverava ivupaoro atari kareva. Uva viapau oiso tauaivira toupaiva rogarauapa. Ari oiso uvuivira vo resura vatara tau (90) mita raga-ia. ");
INSERT INTO roo_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Uva reresa urioiepa. Oa iava voava verau viroiepa oavu tuitui kasi kekesa, ovusa atarito voa vo kasi-ia toupareva. Ora bret tapo oa voa toupaiva. ");
INSERT INTO roo_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Uva Jisas igeire oiso puraroepa, “Evo kare iava atari kare oea outavoi okareiva.” ");
INSERT INTO roo_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Osa iava Saimon Pita uvuoa-ia kaero viropa kuverava ivusa. Uva oira ivupaoro urioroepa rogaraua iare. Uva riropa kare raga iava agasiopa kuverava. Okarea oiso uvuipaaepa katai vovoto vo vavae tau vo peva (153). Ari ita, uva riro kare rutu-a. Uva viapau kuverava vo kareva tokopao viropa. ");
INSERT INTO roo_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Oire uva Jisas igeire keeraroepa oiso, “Uriota aiosa.” Osa iava viapau irai disaipeltoa vai uvuiparoepa ra rera akereve oiso puraoro, “Irouto-a vii?” Viapau. Ari taraipaiepa oiso, Turaro-a ro-ia. ");
INSERT INTO roo_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Uva Jisas bret ourevoiva, igeipa va vatevatereva. Uva oisi raga ita igeipa atarito roo piereva ita. ");
INSERT INTO roo_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Vo uvare tova iava vorevira toreroepa rera Jisas. Oire uva va-a vao vo peva piepa vuuta oa-ia igei iare disaipel ora karekeroepa ita. ");
INSERT INTO roo_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Uva aio opesiioiva, Jisas Saimon Pita-re oiso puraroepa, “Saimon, Jon oviitoaaro. Easi vii vai voea rutu-ia voeao puteparivoi vai ragaipa ruipapaoro, eke?” Oa iava Pita rerare oiso puraroepa, “Iu Turaro. Vii kaviko iraopaavoi.” Oa iava Jisas rera tavireva oiso, “O ita, uva vii-ia vovou iraoparai oiso ra ragai vo raguiaro aio pieri sipsip ragui.” ");
INSERT INTO roo_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Uva vorerivira ita rerare oiso puraroepa, “Saimon, Jon oviitoaaro. E ragaipa ruipa iraopauei?” Oa iava Pita rerare oiso puraroepa, “Iu Turaro. Ragai-ia ita taraipauei ragoa vii kaviko iraopaavoi.” Oa iava Jisas oiso puraroepa, “Oire ragai vo raguiaro sipsip ragui tokipari.” ");
INSERT INTO roo_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Uva vo peva piepa vuuta-ia rerare oiso puraroepa, “Saimon, Jon oviitoaaro. Esa pasi ragai vai kaviko iraoparivoi?” Uva va-a eva oa iava Pita iava sopaua vavataepa rutu. Uvare rerare oisi eisi puraroepa vo peva piepa vuuta-ia. Osa iava Jisas-re oiso puraroepa, “Turaro. Orekerovu rutu-ia taraipau. Oiso osa taraipauei ragai-ia, vo osa oisi vii kaviko iraopaavoi.” Oa iava Jisas rerare oiso puraroepa, “Ragai vo raguiaro sipsip ragui tokipari. ");
INSERT INTO roo_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","“Oiraopavira rutu oiso osa vii tavi iraopaavoi oiso. Voari tuariri vii raga oisoa ora asikovira toupari ora vii vo iroaro-ia takipaoro tuu iro. Oire uva oisoa vokapari vii raga asikovira rutu uruiara iare voraro uvare ava vovoupau. Ari ita, uva utupaua avukauverea. Oire ovuuta-a eva oa-ia vii vavaearo kae piereverea, oisore ra iravu raga vii takireve tuu iro-ia. Oire oisi iava vii tuvetuvepaoro uvavure avaparo voraro uvaroare ava arapa reasipau.” ");
INSERT INTO roo_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jisas vo oiso puraroepa, Pita utupavira kopiirovere. Uva vo kopii-ia Pauto vaisiaro kae piereverea. Osa puraroepa Jisas vo Pita-pa kopiia reesioro. Oa iava oiso Pita-re puraroepa, “Ragai sirova utuu.” ");
INSERT INTO roo_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Oire uva Pita ora poreoro ragai vurapareva ragoa oisoa kaviko iraopareve Jisas. Ragoa vaiterei sirova uturaepa avapaoro. Ragai raga ita ragoa voari pauparaepa ovokia-ia aiopaiova uva Jisas kopukopuaro rutu-ia toupaava, uvava oiso puraraepa, “Turaro. Irouto-a ro ira vii kosi pierevere keripa irara vavaearo iare?” ");
INSERT INTO roo_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Uva Pita ragai kekeoro Jisas oiso akereva, “Turaro. Ari apeisi ragavira ro vo kopiiaro?” ");
INSERT INTO roo_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Oa iava Jisas rerare oiso puraroepa, “Vosa ragai raga rerapa ruipara, oiso ra toupareve vore toupaoro uva voreraverea, uva viapau oiso vii auearo-a. Ragai sirova utuu.” ");
INSERT INTO roo_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Osa iava vo reo vao uvarovu rutu araoko irara iare disaipel viriva avaoro oiso, Ro disaipelto viapau oiso kopiiroverea. Ari ita, osa Jisas viapau oiso oisi rera tavireva oiso, Ro viapau kopiiroverea. Viapau. Ari eerare oiso puraroepa, “Vosa oiso ruipapara ra toupareve vo vokiore tuepaoro oa-ia vorevira voreraverea, uva viapau oiso vii auearo-a.” ");
INSERT INTO roo_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ira raga-a ita ragai Jon, ro-ia disaipelto. Ragoa orekerovu rutu iava oiraopavira siposipopaava. Oa iava vo reoro rutu rigato ovoiava vaore, oiso ra vigei rutu vao-ia tarai iraopavio oiso, O ari va vao oiraopa siposipo rutu. ");
INSERT INTO roo_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ari ita, oaravu rutu oisoa purapareve Jisas. Vosa voeao oea vara rutu evara rigatooro varare katakataivira ora kasivariave rutu, oire ra vo vukuro evara rigatoive rirovira. Ra vo rasio iava viapau otavukipe oisi vara rutupa evara. ");
INSERT INTO roo_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Vateto oaa, Tiofilas, viipa rigato rovoavora voviri vo siposiporo iava ora vo kovoro iava varao oara oisoa purapareve Jisas. ");
INSERT INTO roo_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Oara rovoreva osa vorevira iparoepa. Uva varao tapo reoreoara voeapa vatereva vo Tugoropato Uraurato vo goruaro iavirava, oiso ra vara purapaive, voeao aposel irara oea reereesireva Pauto vo kovoaro purapasa. Oire va isivaaro iava iparoepa vuvuiua iare ");
INSERT INTO roo_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","aue-ia vo resura tau (40) vokiro rera kopiiaro isivaaro iava. Oa iava voea iare aposel irara ora karekeroepa vorevira. Ora rera raga ora tootooaro karekereva voeapa oiso ra kekeive. Ora oiso tapo uvare vo kareke-ia eva voea tapo ora reoroepa aue iava Saraaro Pauto ipa asavira touoro. ");
INSERT INTO roo_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ovokivu-ia voea tapo goruvira tavireva oiso, “Opeita vo Jerusalem-ia kavupata. Ari voa raga tuepatai auere ovoiei reoaro Pauto oa varapere vao oa iava visii taviavora tuaririvi. ");
INSERT INTO roo_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Oire Jon oearovu baptaisreva uukoa raga-ia. Ari tou visivi visii Tugoropato Uraurato vo baptaisaro-ia rera vaaro gorua outavere.” ");
INSERT INTO roo_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Uva vo aivaro-a vao oa-ia oiso rera akeiva, “Turaro, apeisi-a? E vo vokio-ia Isrel sara tore piepari vorevira oiso osa voari tuariri?” ");
INSERT INTO roo_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Uva voea tavireva oiso, “Viapau oiso visii vaaro-a ra vo vuutaro-ia ora vo ivaro-ia taraita. Ari aue oaro-a Aite ira varao tovoreva vo ora rera raga vaaro-ia ruipa. ");
INSERT INTO roo_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ari vao raga vo osa Tugoropato Uraurato uriorovere visii iare osa rera-ia gorua outa. Oa iava ragai iava oearovu rutu tavitavitavere voraro oiso, Jerusalem-ia ora Judia ora Sameria, vo taerero rutu varao ora voraro rutu rasitoa rutu ivara-ia.” ");
INSERT INTO roo_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Uva vo reo-a vao oa isivaaro iava kaero viropa ipaoro vo osa rera siitueiva. Osa rukuta rera ruueva Jisas rera vatauoro. ");
INSERT INTO roo_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Uva vuvuiua-ia siituepaaepa osa iparoepa, ovusa sita pievira voea vatuaro-ia karekesiepa aitereivu kaapopatoarei-ia kuvupaoro. ");
INSERT INTO roo_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Oire voeare oiso purasiepa, “Ai. Visii vao Galili-pa irara. Eakere vuvuiua ragava siituepatai? Ro-ia oirato Jisas ira ipa pierevoi Pauto vuvuiua iare. Ira ita vararoverea vorevira oiso osa iparoi osa rera keketa.” ");
INSERT INTO roo_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Uva eva isivaaro iava kareaepa Jerusalem iare vova vo pukuio-ia oa vaisipaiveira oiso, Oliv Kovo Pukui, vo raivao-ia oa oisoa voare potekupape voava vo pukuia. ");
INSERT INTO roo_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Uva kepa oaive-ia poua viropa. Oire voava vo kepa-ia ipaaepa otugivu iare oa oisoa ipavirava toupaive, ivaraiapa tugi. Uva voea rutu vaisiaro-a voeao oea voa toupaiva oiso, Pita ora Jon, ora Jems, Andru, ora Filip vaio tapo ora Tomas, ora Batolomyu vaio tapo ora Matyu, ora Jems aue oviitoaaro Alfias, ora Saimon Selot, ora Judas aue oviitoaaro Jems. ");
INSERT INTO roo_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Uva vaea vovou raga-ia voea rutu toupaiva variripaoro voeao oirara, ora riakora, ora Maria Jisas aakoaro, ora Jisas araoko irara oaro tapo. ");
INSERT INTO roo_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Vo voki-ia vao Pita voea iava toreroepa reoreosa. Uva voea rutu vieiaro uvuiaro-a voeao-ia oiso, Katai vovoto erao tau (120) oirao pie vovou irara. ");
INSERT INTO roo_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Pita ira oiso puraroepa, “Visii araoko irara oaa, aue iava uvare vao Tugoropa Reo oiraoepa oreoa vatereva Tugoropato Uraurato aue-ia Devit gisipoaro. Uva vo vokia oirao piea rutu karekeepa aue-ia Judas, eera ira voea tuvetuvereva voeao oea Jisas ouiva aue iare kort. ");
INSERT INTO roo_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Eera iravu igei iava ira oisoa oiso kovopareve osa igei. ");
INSERT INTO roo_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","“Eera ira monia oureva aue-ia Jisas vuria puraoro. Oa iava oeavu rera vaaro-ia monia vo rasio voriiva oa-ia koveroepa takuvira. Oa iava ora kovuaro poko piereva. Uva sare rera iava vuseva. ");
INSERT INTO roo_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Oire uva Jerusalem-ia tou irara va-ia taraiaepa. Oa iava va vaisiiva voea vo reoaro-ia oiso, Akeldama. Oa porearo oiso toupaiveira, Revasi Tova. ");
INSERT INTO roo_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Oara rutu varao toupaiveira aue-ia Sam Vuku oiso, ‘Kepa oaro viapavira toupaiverea. Viapau oiso ra oirara vai iava irai voa toureve. Iravu rera vo kovoaro oureverea vao oa oisoa pitupareve.’ ");
INSERT INTO roo_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Uva irai vo kovo ou iraorevere, vo kovo aue iava tavitavisa torearo Turaro Jisas. Oa iava voeao sirova uturovere oea oisoa rera sirova utupaave Jisas ora igei tapo. ");
INSERT INTO roo_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Vo voki-a vao-ia ovokia rutu-ia Jon voea baptaispareva, ovokiroa rutu-ia tapo uvuipa ra igei tapo toureve ora vo ovokia-ia Pauto Jisas ipa piereva vorevira.” ");
INSERT INTO roo_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Oire uva voea vaitereo tore pieiva oiso aueroaro Josep ora ovaisireivu vareo-ia Basabas ora Jastas rera raga ita Mataias. ");
INSERT INTO roo_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Uva oiso puraoro variriaepa, “Turaro. Vii oearovu rutu vovouaro-ia taraipau. Oa iava ro igei iare kareke pieri ira igeipa reesirivora. ");
INSERT INTO roo_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Ira aposel kovoaro ourevere Judas vaaro oa arova vuria purarevora vore avaoro opesi tapi oaro aue-ia vuria oaro.” ");
INSERT INTO roo_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Uva va iava voea vao puraiva paupaua rerare Pauto vo ruipaaro sirova. Oa iava vaisiarei uveuvereiva. Oire iravu rera vaisiaro kae piereva torevokovira. Oa iava rera tore pieiva ro-ia Mataias. Uva ora voea iare vaeavira raga rera tovoiva, oiso osa voea voeao aposel irara katai tau katai (11). ");
INSERT INTO roo_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Uva vo osa Pentikos-pa Voki pou piropa. Uva oirao pie vovou irara ora guruaepa katai tapi raga-ia. ");
INSERT INTO roo_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Uva urioepa gurukoa vuvuiua iava sita pievira. Oa oiso urioepa rutu osa riroto kiuvu. Uva vo kepao rutu agasi pieva okepa-ia ora voeava paupaaepa vo guruko vao oa varaepa vuvuiua iava. ");
INSERT INTO roo_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Oire uva voea iare katakataivira karekeepa oiso osa arevuoara etovira voea kukuearo-ia pausa. ");
INSERT INTO roo_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Oa iava rera iava vuku iraoaepa Tugoropato Uraurato ouoro. Uva rera iavirava oearovu rutu pisa reoro rutu puraiva, ovusa voeapa gorua vatereva vo reoro purasa Tugoropato Uraurato. ");
INSERT INTO roo_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Uva va iava oearovu rutu urioaepa Jiu-pa irara riro vuurapa vaisi pura irara voeao oea oisoa Jerusalem-ia toupaive, voeao osararoa oisoa toupaive vo uvarovu rutu vo rasitoa rutu-ia. ");
INSERT INTO roo_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Oire uva gurukoa uvupaoro ora gurupaaepa voea rutu. Vo osa vavagisipaaepa uvare ora reo oaive raga uru piepaiva katakataivira, vo reoro pisipisa reoro oara purapaiva. ");
INSERT INTO roo_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Oiraopavira. Uva voea rutu vavagisipaaepa. Oa iava oiso puraaepa rirovira rutu rugorugooro, “Uvuta. Easi voeao rutu Galili raga iava urioae. ");
INSERT INTO roo_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Uva apeisi ragavira uvuipaviei ra ora vigei vo reoaro raga uvupe vo reo oreoa-ia kakaevira touera. ");
INSERT INTO roo_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Uva vigei rutu oiso toupai vo-ia, vigei Patia, ora voeao Midia, ora voeao Ilam, ora voeao Mesopotemia, ora voeao Judia, ora voeao Kapadosia, ora voeao Pontas, ora voeao Esia, ");
INSERT INTO roo_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ora Frisia, ora Pamfilia, ora Isip, ora voeao otaererovu iava oiso osa Libia-ia sovara-ia oea Sairini-ia ruvara-ia toupaiveira, ora oearovu voeao oea Jiu-pa irara vo pitupituroaro sirova utupaaveira. ");
INSERT INTO roo_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ora Krit-pa irara, ora Arebia-pa irara vigoa rutu oiso ragavira toupai. Vigoa rutu uvuipaviei ra evoea uvupe oea goru kovoaro iava Pauto vaaro tavitavipaai.” ");
INSERT INTO roo_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Osa iava eisi vavagisivira rutu toupaiva oiso purapaoro, “Avoeao! Eake rutu-a vao?” ");
INSERT INTO roo_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Oire uva oearovu oiso puraaepa vakuvakupaoro, “Easi evoea aue raga-ia airepa oviro wain ukaioaiva kokoropaai.” ");
INSERT INTO roo_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Uva Pita aueva toreroepa katai tau katai (11) voeao rera iava oeava oiso puraroepa goruvira, “Visii rutu vao-ia Jerusalem-pa irara ora oearovu uvarovuva Jiu-pa irara visiigoa ragai uvuta. Uva ragai gisipoaro sirova utupatai rara.” ");
INSERT INTO roo_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Uva oiso puraroepa oearovu vo reoaro pukooro, “Viapau oiso evoea kokoropaai wain iava oiso osa purapatai voeare aue-ia toupaoro vo resura vatara vuuta (9 klok) vo vokipaua. Viapau igei vo pitupituaro vao vokipakou-ia ukaiopasa aue-ia wain. ");
INSERT INTO roo_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ari vao iava tuariri profetato Joel taviroepa oiso puraoro, ");
INSERT INTO roo_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Pauto oiso puraroepa auere ovoiopa vokiro, Ragai reraaro Uraurato ira-ia oirara rutu vuku pieaverea voeao oea rasitoa rutu-ia toupaiveira oiso-ia, Voeao-ia ovii irara oavisii ora ovii riako oavisii oea taru ragai vo reoroaro siposipoiverea vo ragai vo goruaro sovara-ia. Oa-ia tapo orekerovu karekeaverea visii ovii iraraaro viovokoa osireiaro-ia aue-ia areo uusi. Ari avuka irara oavisii urusiara oupaiverea. ");
INSERT INTO roo_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ora voeao kovopa irara oaa ora kovopa riako oaa oea tapo vuku pieaverea aue-ia Urauratoa oaa. Oa iava ragai vo reoroaro kosi piepaiverea. ");
INSERT INTO roo_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ragai osasararovu rutupa oaravu rutu ravotoara karekeaverea vova vuvuiua sovara-ia ora vo rasitoa-ia tapo. Uva oaravu rutu tapo puraaverea oisi vo reesiro ravaavira oiso-ia, oaravua revasiara, ari oaravu tuituiara, ari oaravu kupareara. ");
INSERT INTO roo_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ari ro-ia ravireo ira rupavira taru porero viroverea. Ari ro kekira ira revasivira ora porero. Oire vara rutu-a varao oara isivaaro iava taru Turaro vo vokiaro oiraopavira pou piroverea. Vo voki-a eva oa-ia pisavira touperea oa-ia rera vaaro gorua karekereverea ora kortua. ");
INSERT INTO roo_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Vo oiso, irouto-a ro ira Turaro arereverea oiso puraoro, Turaro ragaivi tauvari vii goruaro sovara-ia, eera-a ira oiso kae piereve rera orirusa.’ Eisi osa ro profetato Joel puraroepa tuariri. ");
INSERT INTO roo_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Isrel-pa irara visii-a vao visiigoa vo reoro uvu iraopata. Jisas ro vova Nasaret ira visiipa karekerevora rutu Pauto aue-ia oiraopara. Oa iava pisaara oiraopara rutu purarevora Pauto goruaro-ia oiso-ia, varao oara purarevora oearovu porete piepaoro ora riro gorupa kovoro tapo puraparevora. Uva vara rutu-ia varao vearovira tarai iraopata. ");
INSERT INTO roo_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Eera Jisas ira tapatavora aue-ia evao parikou rera kopii pieoro oeavu raga vavaearo iava oea-ia viapau lotua vai. Uva va puratavora. Ari ita, viapau oiso visii vaaro-a vao-ia, ari Pauto vaaro-a vao oa puratavora, uvare visiipa rera iava vasereva. Uvare rera raga vo ravaaro-a oa oisoa voari rutu toupaive tuariri. Uva vo ravaa-a eva oa vo taraiaro sirova ututaera. ");
INSERT INTO roo_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Oire uva viapau oiso kopiia rera tuukevora. Oa iava Pauto rera ro-ia kae pierevora. Osiitoka eva kavurevora, oa iava tootoovira toupare Jisas. ");
INSERT INTO roo_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Oisi-a eisi osa iava Devit oiso puraroepa vo rera iava ro Jisas, ‘Ro-ia Turaro Pauto ira kekepaaverea vo ora ragai puaaro-ia vo irapaua. Uvare vo ragai oirapapa vavaearo-ia toupareverea Turaro ragai virivaripaoro. Ra viapau vuria vai oua. ");
INSERT INTO roo_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Eva-a oa-ia sopaua oaa agasipapeira aue-ia rorua, ora uvare tapo ragai vuurapa vaisi purapaaveira rera-ia. Vosa kopiira, eagara. Tueparaverea vo ovoiopa voki vare tuepaoro. ");
INSERT INTO roo_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Eva oa iava viapau oiso varaua oaa urauraaro kavuriverea vore kopii irara voaaro voeao uraura irara. Ra viapau va iava vaseriverea, ora oiso tapo ra viapau oiso ra Tugoropato oara varaaro eruro. ");
INSERT INTO roo_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Vii ragaipa tootoopa raiva vaterivora ora ragai vuku piepariverea aue-ia rorua, uvare ragai tapo toupariverea vo vokiara rutu-ia.’ Eisi osa puraroepa Devit. ");
INSERT INTO roo_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Visii-a araoko irara oaa, uvuiparai ra visiipa aviavi pievira tavira aue iava aaotoa oavi ro-ia Devit ira kopiiroepa. Oa iava rera tovaiva aue-ia kakiua rera vouaaro. Uva va vao vigei ruvara-ia toupai vo vokio. ");
INSERT INTO roo_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Uva rera profetato va iava tarairoepa vao oiso osa rera vatereva Pauto vao reo ovoi. Vo reo-a ovoiei reo oreoa-ia oiso puraroepa, Ragai vii aao irara iava irai ouaverea irai turaro piesa oiso osa vii vao Turaro. Uva va-a vao-ia oiso ragavira tarai rovoroepa Devit oiso, Utupaua taru toupareverea ro-ia oirato Pauto reraaro Jisas Krais ro Ropoto vo rasitoa-ia. Ora kopiiroverea, ora vorevira toreroverea tapo. ");
INSERT INTO roo_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Oa-a vao oa-ia taraipaoro oiso puraroepa Devit auere Jisas Krais vaore torea oaro vorevira, Viapau oiso Pauto rera ro-ia urauraaro iava vasereverea vore uva kopii irara urauraaro toupaiveira. Ora oiso, Asi viapau varaua rerare eruperea. ");
INSERT INTO roo_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“Ro-ia oirato Jisas ira vorevira tore piereva Pauto, ira kekeiovora ora igei osireiaro iava tuu pievira. ");
INSERT INTO roo_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Uva toupareveira vo oirapapa varata-ia uva rera tovoreva rera rei pieoro Pauto. Uva vao tapo-a uvare Tugoropato Uraurato oureva ro irare Reo Ovoi purareva Pauto rerapa. Oisi-a oiso osa iava varao rutu kareke pierevo oara rutu keketavo ora vara tapo uvutavo vo-ia. ");
INSERT INTO roo_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ira-a ro-ia Devit viapau oiso iparoepa vuvuiua iare. Ari ora rera raga oiso puraroepa, ‘Ro-ia Turaro Pauto ira oiso puraroepa rerare Turarotoa oaa, Vo pauu oirapapa vavae oaa-ia. ");
INSERT INTO roo_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Ovusa viipa urua puraa tasipasa voeao-ia keripa irara oara, vo rara voea-ia puteri.’ ");
INSERT INTO roo_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Oiraopavira rutu varao Isrel sararo vao-ia tarai iraopaavere Jisas iava ro ira rei piereva Pauto. Ro-ia ira evao parikou-ia tapatavora. Oa-a vao oa iava rera roporeva rera vaisioro oiso, Krais, rera Turaro pieoro.” ");
INSERT INTO roo_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Uva vo reo isivaaro iava voea iava sopaura oaive vavataepa rutu. Oa iava siraoaepa. Oire va iava oiso puraaepa auere Pita ora oearovu aposel irara, “Avoeao araoko irara oaio. Eake vai-ia uvuipaiei ra oai puraio?” ");
INSERT INTO roo_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Oa iava Pita voeare oiso puraroepa, “Ora visii iava vovouisiro oavisii poreta katakataivira visii rutu. Ra baptaisa outa ora reesioro. Ra rera vaisiaro-ia Jisas Krais touta. Oiso ra visii iava vuriara oavisii verareve, oa iava vao Tugoropato Uraurato outavere rera vo goruarova toupaoro. ");
INSERT INTO roo_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Vao-ia Reo Ovoi oa purareva Pauto visiire, ora aao irara oavisii, ora voearore tapo oearoa tauairo rutu tapo toupaiveira, ora oearovu rutu tapo oearoa roporoporeverea Pauto ora rera iare.” ");
INSERT INTO roo_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Uva oreorovu rutu-ia voea goruvira tavireva Pita oiso, “Ora oriruta visii vao-ia ora voearo vo vokio iavapa irara. Uva voearopa ora vatatopopatavere oearovu vuri vovou irara.” ");
INSERT INTO roo_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Oire va iava voea voeao rera reoaro uvu iraoiva. Oa iava baptaisa ouiva. Voea rutu voeao-ia oea vieiaro-a vao vo peva tuku (3,000). Uva voea evoea oirao pie vovou irara tapo ora takutakuvuaepa. ");
INSERT INTO roo_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Oa iava taraia ouiva aue sirova utupaoro aposel irara vo siposiporoaro. Osa iava voea rutu toupaiva oavu-ia ora goruaepa aue komunion aio purasa ora aue tapo variria. ");
INSERT INTO roo_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Voea rutu voea-ia tavetavepaiva, uvare oaravu rutu ravoto kovoro puraiva aposel irara vo Tugoropato Uraurato goruaro-ia. ");
INSERT INTO roo_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Oirara rutu voeao oirao pie vovou irara oea oisoa vaea kaevira toupaive katai tapi, ora orekerovu rutu oaive oara-ia ora roorookaaepa ora voea raga. ");
INSERT INTO roo_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Vara rutu varao oara oisoa voea ruvara-ia toupaive oara-ia moni ouaepa oearovu ruvara-ia. Oa iava oisoa voearopa vara varao moniaro roo piepaive voeaopa apota iraravi. ");
INSERT INTO roo_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Uva oisoa vokiara rutu-ia aivaropaive Rovopa Kepa Tugoropa Kepa-ia Tempel vo katai vovou raga-ia, ora vo tapo kepara oaive-ia tapo. Uva tapo oisoa aue-ia aioara oisi raga vaeavira aiopaive voea rutu. Ora aue-ia roru vovou-ia oisoa oearovupa orekerovu vate ragapaive. ");
INSERT INTO roo_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Oa-a eva oa-ia oisoa Pautoa-ia vuurapa vaisi purapaive. Uva va-ia oearovu voea-ia oisoa tavetavepaive. Oa iava oisoa vokiara rutu-ia Turaro Pauto oearovu gurupareve oirao pie vovou irara voea iare. ");
INSERT INTO roo_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ovokivu-ia Pita vaio ora Jon ipasiepa Tugoropa Kepa Tempel iare aue-ia vo peva vuuta (3 klok) variripa vuuta ovaiarovi. ");
INSERT INTO roo_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Oire iravu oirato ira kavaueva aakova vuri kokototo. Ira iava kopiiepa kokotoarei. Oa iava oisoa rera kaepaive. Uva oisoa vokiara rutu-ia rera tovopaive vo Tempel rataoa riaaro-ia. Vo ratao oa oisoa vaisipaive oiso, Vearo Ratao Rutu. Uva oisoa voa toupaoro oearovu arepareve auere moni, ovusa koatapaave Tempel sovara iare. ");
INSERT INTO roo_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Oire voava kaea-ia Pita vaio kekereva ora Jon ovusa koata rovopasiepa. Oa iava vaiterei arepareva auere oaravu avu vai rerapa, oiso ra oarai vatesi rerapa. ");
INSERT INTO roo_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Uva tuupavira Pita rerava vurapareva. Uva Jon tapo toupaoro oiso puraroepa, “Vegei-ia vurari.” ");
INSERT INTO roo_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Uva va iava vaitereiva vurapareva keapaoro oiso, Ragai vatepasivoi orekevu avu vai. ");
INSERT INTO roo_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Oa iava Pita rerare oiso puraroepa, “Viapau oiso monia vaiei ra viipa oai vateve. Ari ita, oavu raga vao-ia oa iava vii vatepaave Jisas Krais vo goruaro raga iava ro vova Nasaret. Uva vii tavipaa ra toreu, ra vokari.” ");
INSERT INTO roo_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Oire Pita rera oirapapa vavaearo-ia pituoro rera tore piereva. Uva vo vuuta raga-ia eva oa-ia rerare goruepa kokotoarei vova ario kerureiaro iava. ");
INSERT INTO roo_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Uva voava tokatokareva voaviva voka ovoisa. Oire vaiterei tapo koataroepa vore Tugoropa Kepa vao Tempel sovara-ia tokatokapaoro ora Pautoa-ia vuurapa vaisi puraoro. ");
INSERT INTO roo_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Osa iava eisi oirara rutu rera kekeiva osa eisi vokareva Pautoa-ia vuurapa vaisi puraoro. ");
INSERT INTO roo_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Oa iava voava rerare oiso puraroepa, “Akoea, ari ro oisoa Tempel vuura rataoaro-ia toupareve moni arepaoro.” Ari ita, rirovira rugorugoo iraopaaepa vao iava oa rera-ia karekeepa uva oisi vokareva. ");
INSERT INTO roo_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Vo osa Pita vaio-ia pitupareva ora Jon, ovusa oearovu ikaupaoro uriopaaepa vore rakorako uru vao Rovopa Kepa Tugoropa Kepa. Oa oisoa vaisipaive oiso, Solomon Vo Uruaro Rakorako Uru. Osa iava oiso rirovira rutu rugorugoopaaepa voea rutu. ");
INSERT INTO roo_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Oa iava Pita voeare oiso puraroepa, “Ai! Eake iava vegeiva tuupavira vurapata visii Isrel-pa irara. E oiso rugorugoopatai ora vegei raga vo goruaro iava vao puravevo? Ora vao tapo vao iava torevoko vovou oiso ro oirato pievevoi? ");
INSERT INTO roo_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Viapau rutu. Oiraopavira, ari Pauto raga ro Pauto oaive Ebraham vase, ora Aisak, ora Jekop. Uva eera-a Pauto oaive vigei aite iraraaro. Ari ita, rera raga-a eera Oviito Kovopato Jisas ira rei pierevora Pauto. Ira vate ragatavora rera rovirieisa kortua-ia. Rera-ia kuuvu pitupituro rutu puraoro rerare isivataera vo Pailat osireiaro-ia. Oire va iava Pailat Jisas kortuoro oiso puraroepa, Rerape. ");
INSERT INTO roo_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Uva visii rutu vao-ia visiigoa rerare isivaoro ora poretaera rera karusa ro oira upopato. Oire rera kopii pietavora Torevoko Vovouto ora Tugoropato. ");
INSERT INTO roo_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ira upotavora Turaro ira Tootooa vatepareveira. Ro ira vorevira tore pierevora Pauto voeao ruvara iava kopii irara. Uva rera-a eera ira kekevevora vegei. ");
INSERT INTO roo_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Va-a vao oa iava Jisas oirao pievevoiva, vuri kokototo porete pievevora rera vaaro iavirava gorua, oporetea-a vao-ia oa keketavoi vo vokio vao oa karekei ro-ia ira-ia taraitai. ");
INSERT INTO roo_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Araoko irara oaa, taraiparai vao-ia osa vao pura ragatavora vuria, uvare viapau taraipataera oiso rutu osa voeao reipa irara oavisii vo tuariri. ");
INSERT INTO roo_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ari ita, vara rutu varao oara karekereva Pauto aue-ia profet irara gisipoaro tuariri. Oire vo tavakaro urioera Krais iare Pauto Ropotoaaro. Uva vo reoro varao oara oirao pierevora Pauto vo rera-ia. ");
INSERT INTO roo_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","“Oire ora visii vo pitupituroaro tavariota, ra poreta viro. Oa iava vuriara oavisii uvuipai verareve. ");
INSERT INTO roo_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Osa iava eisi uvuipa ra vorerivira airepa goru vatereve, oiso osa ogoepato gorua oupareveira aioa-ia. Aue iava uvare vao raga-ia Turaro Pauto visii tapo toupare. Uva va iava Jisas visiipa siporevere, ro Krais ira roporeva Pauto visiipa. ");
INSERT INTO roo_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ari ita, rera ro tou rovoreverea vo vuvuiua-ia vo vuutare tuepaoro, vo osa orekerovu rutu torevoko rovorevere vo rasitoa-ia. Oara iava rera voeaaro profet irara tavireva tuariri voea vateoro. Osa iava profet irara vara iava tavitaviaepa. ");
INSERT INTO roo_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","“Oire uva Moses tapo oiso puraroepa, ‘Pauto profetatoa vai roporeverea visii araoko iraraaro iava irai oiso osa ragai piereva. Ra irai reoaro uvupata. ");
INSERT INTO roo_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Oire vosa irouto rera reoaro viapau uvupareve, ira-a eera taru voea iava viro piereverea rera opesi piesa.’ ");
INSERT INTO roo_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Oiraopavira ita, voeao-ia profet irara oiso osa ro-ia Samyuel rovopato, ora oearovu rutu voearo oearoa oiso rera sirova utupave vo reoro varao vatepaoro oara rutu iava tavitaviaepa vo vokiro rutu iava varao-ia. ");
INSERT INTO roo_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","“Oire uva evara-a oara iava oaravu outavere varao oara iava tavitaviaepa profet irara voari tuariri. Visiigoa Pauto vo Reo Ovoiaro sovara-ia toupata oreoa iava vigei tuariripa iraraaro tavireva oiso, ‘Ebraham, vova vii ovii iraraaro oea iava taru viraakoa karekeperea vore oearovu rutu-ia vo rasitoa-ia.’ ");
INSERT INTO roo_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Pauto Oviitoaaro roporeva rera sipo rovosa visii iare, oiso ra visii rutu viraakoreve auere, ra vuriara oavisii iava poreta viro.” ");
INSERT INTO roo_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Oire vo osa voea tapo oirara ora reopasiepa, ovusa poua viropa oearovu oirara oiso osa pris irara, ora Sadyusi-pa irara, ora ro rovopatoa rutu vova voeao iava oea oisoa Tugoropa Kepa Tempel tokipaive. ");
INSERT INTO roo_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Uva va iava rirovira kasipupaaepa vo siposiporo iava oara vatesiva oirarapa oiso osa vao-ia oa-ia oiso purasiepa, “Voea rutu taru oirara vorevira toreaverea Tootooa ouoro oiso osa pierevora ro-ia Jisas.” ");
INSERT INTO roo_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Oa iava vaiterei iava gasiiva vaiterei tuukesa uva vaitereire vokiepa voa. ");
INSERT INTO roo_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ari ita, riro irara rutu Pauto vo reoroaro oirao pieiva vo reo oa vatesiva. Eva-a oa iava voea rutu vieiaro aue-ia uvuiaepa, vo vavae tuku (5,000) voea rutu uvuiaro voeao oirao pie vovou irara. ");
INSERT INTO roo_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Uva katai voki putevoiva, voea rutu ora guruaepa Jerusalem-ia. ");
INSERT INTO roo_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Oiso-ia tokipa irara, ora oeavu oira vasi irara, ora oeavu voeao Reo Taisi iava siposipopa irara, ora ro tapo Anas Rovopato Pristo, ora Kaiafas, ora Jon, ora Aleksanda, ora voea rutu voeao Rovopatoa rutu voeaaro. ");
INSERT INTO roo_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Uva ora voea sovara-ia aposel irara tovoiva. Oa iava oiso voea akepaiva, “Aa vo goru-a, ora aa vo karopo-a oa iava varao purapatavo visii oira akukuro?” ");
INSERT INTO roo_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Oire Pita Tugoropato Uraurato vo goruaro iavirava oiso puraroepa voeare, “Visii vao oirarapa uutupa irara reipa irara ora oira vasi irara oae Isrel-pa irara. ");
INSERT INTO roo_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Vosa taraia oupata vegei-ia vava vegei rovirieipasa vao-ia vegei vaaro vearo kovo oa-ia ro porete pievevora vuri kokototo. Uva uvuipatai ra rera kekepaoro rugorugoo iraopata. ");
INSERT INTO roo_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ro Jisas ira vo goruaro-a vao oa aviavi pie iraopaavoi visiipa vao-ia ora voeao Isrel-pa irara. Ari ita, rera raga ro-ia Jisas Krais ro vova Nasaret ira tapatavora aue-ia evao parikou, oa iava rera tore pierevora Pauto aue iava kopiiaro. Ira vo goruaro-a vao oa oiso ro porete pievora vuri kokototo ira tapo toupatavoi vo vokio. ");
INSERT INTO roo_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ro-ia Jisas irare isivataera oiso osa vao vo reo-ia rera iava Jisas aveke tuuta oreoa toupai Tugoropa Vuku sovara-ia oiso, ‘O-ia aveke iriare isivaaera kepa paupa irara. Uva utupauavi oiso karekeoi kukuuvu tuuta oira o aveke.’ ");
INSERT INTO roo_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Uva viapau irai vova rasitoa-ia uvuiparoi irai ita ousa vore Pauto ruvara-ia. Viapau rutu. Ari ro raga vaisiaro-a, ira vigei kae piereverea utupaua ro raga, Jisas Krais.” ");
INSERT INTO roo_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Oa-a eva oa iava vaiterei-ia tarai iraopaaepa voeao Jiu iava voea reipa irara, uvare viapau uriripasi goruvira rutu reopaoro. Uva oiso tapo oisoa taraipaave, Asi vaitereo viapau oiso skulsiepa, ora viapau vigei vo taraiaro ousivora. Oa iava rirovira rutu oiso rugorugoopaaepa, uvare vaiterei eveipaiva oiso, Easi vaitereo Jisas tapo oisoa toupasi. ");
INSERT INTO roo_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ari ita, rera vurapaiva ita ro-ia oirato ira vorevira vearoroepa. Uva viapau oiso uvuipaaepa oiso ra oreovu avu vai puraive va iava eva rera-ia. ");
INSERT INTO roo_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Oire vaiterei kosi pieiva Kaunsel Kepa iava. Oa iava vaiterei-ia ora reopaaepa rirovira rutu rugorugoopaoro vaore oa purasiva. ");
INSERT INTO roo_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Uva oiso puraaepa vaitereire, “Avoeao, eake vai purapere vaitereire? Ari ita, oiraopa rutu ita vao oa purasivorao ravoto kovo rutu puraoro oirara rutu osireiaro-ia voeao Jerusalem-ia tou irara. Uva viapau uvuipaviei ra oiso puravio, Easi viapau oavu avu vaiei vao-ia.” ");
INSERT INTO roo_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Oire vaitereire oiso puraaepa voea raga ora reopaoro, “Vearopai ra oisivu avu rutu ora vaiterei raga-ia vape. Ra viapau rutu avape oearovu siposiposa ro iava Jisas. Teapi oearovu iare ita avape ra va-ia taraiave. ");
INSERT INTO roo_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Uva va isivaaro iava vorevira ita vaitereire keeraaepa. Uva voava oiso vaiterei vearovira rutu vosipaiva oiso vaiterei tavipaoro, “Opeita vo vaisio iava ita Jisas-pa vaisi oearo ita siposiposivere.” ");
INSERT INTO roo_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Uva Pita vaio ora Jon oiso ragavira voea akepasiva voea vo reoroaro pukooro, “Eake vai vearopai vo Pauto osireiaro-ia, visii vo reoroaro sirova utusa, eke Pauto vo reoaro? Oire varei vearovira rookata, aa vao vearopai. ");
INSERT INTO roo_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Viapau rutu uvuipaiei ra varao kavuio oara kekeiovora ora vara uvuiovora.” ");
INSERT INTO roo_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Oire va iava vorerivira vaitereipa oreovu ita goru pie reo vateiva. Oa iava vaiterei iava vaseiva. Uvare viapau uvuipaaepa oiso ra raiva vai kekeve ra oai-ia vaiterei vuri pieive. Aue iava uvare vao ragare vorevira rugorugooaepa oearovure voearo oearoa tapo vova ratau Pautoa-ia vuurapa vaisi purapaiva va-ia vao vaiterei vo kovoaro-ia, oa-ia ro porete piesivora vuri kokototo. ");
INSERT INTO roo_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Rera-a ro irare vo resura tau (40) ivaro puteva. Uva uvuiparoi ra vorevira vokareve vo vokio-ia. ");
INSERT INTO roo_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Oire uva va iava ora vaiterei iavapa irara iare avasiepa voeapa siposiposa vo reoro rutu iava varao oara puraiva voeao rovopa irara rutu pris irara ora oira vasi irara. ");
INSERT INTO roo_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Uva vo siposipo uvuoro katai guruko raga puraiva varirioro vaeavira rutu oiso, “Pauto riro gorutoa rutu-a vii Turaro. Vii raga varao purariva oiso-ia, vuvuiua, ora rasito, ora avakava, ora orekerovu rutu varao oara sovara-ia toupaiveira. ");
INSERT INTO roo_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Uva vii raga vo reoro-ia Tugoropato Uraurato oara iava Devit gisipoaro-ia ro vii kovopatoaaro oara-ia oiso purauepa, ‘Eakere osararovu kasipuvira toupaiveira. Ora eakere oearovu vo kovoro-ia reesiara pura ragaiva akukuvira. ");
INSERT INTO roo_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Uva voeao-ia oira vasi irara oea oisoa rasitoa-ia toupaive ora ravaapaoro uutuvira. Ora oearovu tapo voeao tokipa irara oearoa rutu ora guruaepa uva voava rerare ro Turaro Pauto kasipuaepa ora auere tapo Krais rera reraaro ro Ropoto.’ ");
INSERT INTO roo_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Oiraopavira osa toupai vo-ia. Uva voea voeao ora guruaera auere vii Oviitoaarore kasipusa ro Jisas ira roporiva rera siposa Airereito Kovopato. Uva voea-a voeao-ia oea ora guruaepa oiso-ia, Herot-a ro-ia, Pontias Pailat-a ro, ora Isrel-pa irara, ora oearovu ratau tou irara. ");
INSERT INTO roo_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Oisi ragavira otakutakuvua vao puraiva oiso osa vii vo goruaro ora vii vo ruipaaro reesireva, oisore ra oisi kareke iraope. ");
INSERT INTO roo_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Turaro, igei tauvari voea vo reoaro uvuoro kasipu reo, oiso ra viapau uriripaio vo osa vii vo reoroaro goruvira puraio. ");
INSERT INTO roo_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ora vo osa vavaea oara tovori vo oearovu porete piepaoro, auere ra ravaa reesiro ora karekepe ora ravoto kovoro tapo vao iavirava Jisas vaisiaro vii reraaro Airereito Kovopato.” ");
INSERT INTO roo_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Uva vo varirio isivaaro iava kepa vao rikerikeepa ravurikeoro. Uva voea rutu tapo agasiaepa Tugoropato Uraurato vo goruaro ouoro. Eva-a oa iava uriri asavira oisoa Pauto vo reoaro vatepaive. ");
INSERT INTO roo_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Oire uva voeao oirao pie vovou irara oea aue raga-ia oisoa toupaive katai vovou ora katai tootoo. Uva viapau oiso ra irai voea iava oiso puraro, “Eva-a ragai vaaro.” Oapa viapau oisi oa-ia touiva kataia raga-ia vaea rugorugoo. ");
INSERT INTO roo_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Uva aueva gorua voeao aposel irara Turaro Jisas torearo iava siposipoiva. Osa iava riroa-ia touiva gavaurea ora tauva vereopa vovou-ia. ");
INSERT INTO roo_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Uva viapau irai voea iava apotavira oisoa toupareve, uvare kepaara ora rasiara oaive-ia oisoa voria oupaave varao oara oisoa voea ruvara-ia toupaive. ");
INSERT INTO roo_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Oire vo voriro evara oara oisoa oupaive oara oisoa tovopaive aposel irara ruvara-ia. Uva voava oisoa vara oupaoro voearovio roo piepaive apota irara. ");
INSERT INTO roo_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ro Josep ira oisoa vaisipaive oiso, Banabas. Ovaisia porearo oiso ragavira oisoa toupaive, Vearopa Reoro Vateto. Eera Livai-pato Saipras iava rera. ");
INSERT INTO roo_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Uva oisoa rera vaaro rasia toupaive, oa-ia voriroepa monia ousa aposel irarapa. ");
INSERT INTO roo_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Uva ita, iravu-a ro-ia rera vaisiaro, Ananaias ora vatuava o-ia, Sapaira aiterea tapo oavu oaesi-ia rasia vori ousiepa monia ouoro va-ia. ");
INSERT INTO roo_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ari ita, aiterea vaitereo monia ou ragasiva auero oaesi rutu voriaro-ia. Uva okarutuvu-ia pitureva ora rerapa. Uva vatuava tapo taraiopa va-ia, osa okarutuvu raga ouoro vava avaroepa aposel irara vatesa va. ");
INSERT INTO roo_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Oa iava Pita oiso puraroepa rerare, “Ananaias. Apeisi ragavira iava ora vii iava sopaua iava vaserivoi Seten-pa? Oa iava voua-ia piturevoi. Uva vo pitupitu-a vao kuuvua purarivo Tugoropato Uraurato keaoro ora viipa moni-ia karutuoro rasia voriaro. ");
INSERT INTO roo_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Vo osa vori asavira rasia oisoa toupaive, uva voa-a eva uva oisoa vii raga vo rasia oisoa pitupari. Uva va isivaaro iava vo rasi voriivo viipa. Oa iava va voriaro tokirivo. Oire uva apeisi ragavira vovouisi oara pierivo? Rera tapo Pauto kearivo. Viapau oiso oirara raga kearivo vao-ia. Viapau rutu.” ");
INSERT INTO roo_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Uva va iava Ananaias vo reo uvuoro kove ovoiroepa kopii ovoioro. Oa iava voea rutu rera iava uvuiva va iava eva osa piereva kopiioro ora uririaepa rutu. ");
INSERT INTO roo_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Uva oearovu rera ruuoro rerava kosia viropa rera tovasa. ");
INSERT INTO roo_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Oire vo peva vuuta (3 aua) isivaaro iava urioopa vatuava oaro. Viapau oiso rera-ia taraipaoro oiso, Ro kopiiroe, ra oa-ia koataopa. ");
INSERT INTO roo_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Uva Pita oira akereva oiso, “E vo monia vao-ia rasia oaesi voriaro?” Oa iava oiso puraopa, “Aure. Eisi ita osa torevokopai.” ");
INSERT INTO roo_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Osa iava Pita oirare oiso puraroepa, “Apeisi irao iava vei rutu vaea vovou purasivo Tugoropato Urauratoa-ia kokaraoro Pauto reraaro? Uvuipau ra voea kukuukuaro uvuri ovusa vii kaesa vorepaave vova uva vatuatoa oara tovapa tapi.” ");
INSERT INTO roo_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Oa iava kove ovoiopa kopii ovoioro. Uva voava vokapaoro vo gerepa kekeiva. Oa iava oira kaeiva oira tovasa voari vatuato tova ruvara-ia. ");
INSERT INTO roo_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Uva voea voeao lotupa irara ora oearovu oea rutu vaitereo iava uvuoro rirovira rutu uririaepa. ");
INSERT INTO roo_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Oire voeao aposel irara osasararovu rutu ravoto kovoro puraiva oirara rutu vuutaaro-ia. Oa iava voea rutu vaea vovou puraiva. Uva ora guruaepa rakorako uru-ia Solomon vaaro. ");
INSERT INTO roo_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Oearovu voearo lotu asa irara oea viapau voea tapo ora guruaepa uvare uriripaaepa. Ovusa oearovu oisoa voea iava aposel irarapa avivikepaave. ");
INSERT INTO roo_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ari ita, oearovu oearoa Turaro-ia oirao pie vovou rutu purapaiva, oearoa voea tapo ora guruaepa ora takuvuoro. ");
INSERT INTO roo_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Oa iava voraro rutuva oearovu uriopaaepa oearovu kaepaoro, upiapa irara vore raiva. Uva voeapa urupaiva vo raiva puaaro aue-ia mat ora uru rakorakoro-ia tapo auere rugoopaoro, Vosa Pita voea-ia putepaoro vokaparevere, ra uveiotoa oaro kavupareve voea-ia rera verapaoro voea iare osa voea ruupareve uveiotoa oaro voea porete piepaoro. ");
INSERT INTO roo_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Uva vo uruiro tapo uriopaaepa ouruiroa oisoa Jerusalem-ia ruvara-ia toupaive, ouruiroa oearovu upiapa irara sipopaiva ora oearovu oearoa-ia oisoa tugara kopiiro toupaive. Oa iava vorevira voea porete pieiva. ");
INSERT INTO roo_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Oara-a evara ravoto kovoro riiriireva kasipuoro Rovopato Pristo ora oearovu rera iava Sadyusi-pa irara. ");
INSERT INTO roo_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Osa-a eisi osa iava aposel irara ouiva voea tovosa tuukepa kepa sovara-ia. ");
INSERT INTO roo_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Uva vokiaro urioroepa Turaro purapurapatoaaro ensel rataoa karusa. Oa iava voea kosi piereva rataure. Uva oiso puraroepa, ");
INSERT INTO roo_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Avata. Uva Rovopa Kepa-ia Tempel toutavere, ra voa toupaoro voea rutu oirara siposipota vao iava tootooa, Airepa Tootoo oa vo toupaivoi Jisas vo raivaaro-ia.” ");
INSERT INTO roo_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Eva-a oa uvuoro avaaepa Tempel iare vo reoro-ia rovosa vara vateoro. Uva Rovopato Pristo urioroepa ora voeao rera iavapa irara tapo. Oa iava voeao Kaunsel irara guru pieiva voeare keeraoro voeao Isrel-pa irara oira vasi iraraaro. Uva va isivaaro iava oearovu aposel irara ousa avaaepa tuukepa kepa iava. ");
INSERT INTO roo_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Oire uva polis irara avaaepa voare. Uva viapau voea kekeiva tuukepa kepa sovara-ia. Oa iava vura ragaoro voreaepa oiso purasa, ");
INSERT INTO roo_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Igei tuukepa kepa-ia vura ragaio. Viapau oiso irai ariarava karuiovo. Ari ita, tupavira raga toupaivo tupa. Ora aue tapo uvare vo kepa-ia uutupa irara tapo toupaivo.” ");
INSERT INTO roo_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Uva va iava vo reoro uvuoro Rovopato Pristo ora iravu reito aue iava Tempel aiterea rutu oiso rugorugoo iraopasiepa, Eake irao-a vao-ia oa pou piroi vo-ia? ");
INSERT INTO roo_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Oa iava iravu urioroepa voea rutu tavisa oiso, “Avoeao uvuta. Easi voeao epao Tempel-ia oea oirara siposipopaivoi.” ");
INSERT INTO roo_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Oire reito avaroepa rera voeaaro tapo. Oa iava voea tapo aposel irara voreaepa voea rutu. Uva viapau oiso orekevu avu vai puraiva voea-ia, uvare oiso ragavira rugorugoopaaepa, Teapi vigei iare avekeara vai vikiive. ");
INSERT INTO roo_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Uva voava voeava karea viropa voea tovosa Kaunsel irara sovara-ia. Oa iava ro-ia Rovopato Pristo oiso puraroepa, ");
INSERT INTO roo_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Igei visiipa goru vosi rutu pura ragaiovorao oiso, Opeita vo vaisio iava oearovupa siposipopatavere Jisas-pa vaisi. Uva apeisi iava visii raga vo uruio agasi pieta Jerusalem urui vo ora visii gisipoaro raga iava igeipa vao vuria puraoro oiso, Igoa rera kopii pieiovora?” ");
INSERT INTO roo_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Uva Pita ora oeavu aposel irara vo reo pukoiva oiso puraoro, “Igei Pauto vo reoaro sirova utu iraopaioveira. Ari oirara vo reoroaro oara tupepapeira. ");
INSERT INTO roo_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Vigei aite iraraaro Pautoa-aro ira Jisas tore pierevora vorevira ro ira kopii pietavora evao parikou-ia. ");
INSERT INTO roo_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Uva Pauto rera rei pierevora ora rera oirapapa varata oaro-ia oiso rera pieoro, Turaro Kae Piepato, oisore ra Isrel-pa irara sopaaro oaive poreive. Oire ra va iava voea iava vuriara oaive veraparevere. ");
INSERT INTO roo_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ora igei-ia vao iava tavitavipa irara ora ro tapo Tugoropato Uraurato ira voearopa vatepare Pauto oearoa rera vo reoaro sirova utupaaveira.” ");
INSERT INTO roo_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Oire uva vo reoro voea sopaaro togava rutu. Oa iava voeare vovouisiro tore iraoepa. Uva oiso vovoupaaepa ra aposel irara upoive voea kopii pieoro. ");
INSERT INTO roo_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Uva voava vo vokia vao-ia iravu toreroepa voea iava voeao Kaunsel irara ro-ia Farisi-pato rera vaisiaro, Gameliel. Eera Gameliel riro taraito Reo Taisi-ia. Irare oisoa oearovu rutu oiso purapaave, “Eera-a vearo vovoutoa rutu,” uvare reo keketoa. Oire uva toreroepa oiso purasa, “Eisivi raga ratauvi voeao aposel irara kosi pieta.” ");
INSERT INTO roo_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Oa iava oiso puraroepa Kaunsel irarare, “Visii vao Isrel-pa irara vatatopopata. Teapi voeao vuri pie ragata. ");
INSERT INTO roo_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Teapi oiso pieta osa iravu ro-ia rera vaisiaro, Tiudas ira oisoa ora rera vaisiaro raga rei piepareve. Oire riro irara rutu rera sirova utuaepa. Voea uvuiaro voeao-ia vo resura vovoto (400). Uva va iava oeavu rera upoiva. Osa-a eisi osa iava oisi raga ora rigaaepa voeao vo resura vovoto ora opesi pieoro. ");
INSERT INTO roo_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Uva voea isivaaro iava iravu ro-ia rera vaisiaro, Judas ira karekeroepa aue-ia vo vokio sensispa voki ro-ia Galili-pato. Uva voava riro irara ivureva ora rera iare rera sirova utusa. Ari ita, eisi ita osa ragavira iava ora opesi pieroepa. Uva oisi raga voeao utuaepa rera voeaaro. ");
INSERT INTO roo_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ari ita, vo vokio-ia visii tavipaa oiso, Voeape, ora voea vo kovoaro tapo, ora raivara oaive. Oara tapo evara opesi ragapere, vosa voea raga varaaro oira turiro. ");
INSERT INTO roo_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ari vosa voea varaaro vova Pauto, ra viapau oiso uvuipatai ra voea-ia puteta. Uva oiraopavira pasi oiso, Easi visii vai raga Pauto upopatavere.” ");
INSERT INTO roo_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Osa-a eisi osa iava Gameliel vo reoaro sirova utuaepa. Oa iava voeare aposel irara keeraaepa. Uva voea ragiiva voeare goruvira oiso purapaoro, “Opeita Jisas vo kovoaro iava tavitavipatavere.” Uva va isivaaro iava voea eakaiva. ");
INSERT INTO roo_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Oire Kaunsel-pa irara kavuiva roruoro, uvare Pauto voeapa reoa reesireva oiso puraoro, “Uvuitae ariia ouoro varao rutu vearo