﻿USE sofia;
DROP TABLE IF EXISTS sofia.ronludari_vpl;
CREATE TABLE ronludari_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ronludari_vpl WRITE;
INSERT INTO ronludari_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Poštovani Teofile, kašă kum šti, mulc lumje adat tot dăla jej s skrije izvješće d stvarurj karje Dimizov afukut ăn vrijamja anuastră, baš kašă kum skrije ăn Svăntă pismă. Askris aja če nuavă azăs ălja karje avizut stvarurlja d ănčipjală š karje rubja Bună vorbă. Š jo pažljivo amproučit aštja tuatje događajurlje. Jo agăndit k arfi binje tot s skriuv p rănd, ");
INSERT INTO ronludari_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","aša osă fi siguran k aja če jej ta ănvăcat istina. ");
INSERT INTO ronludari_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Kănd caru Herod avladit p Judeja, afost njeki pop karje s kjamă Zaharija. Jel pripadnja alu skupinej d popje karje s kima skupina alu Abije. Mujarja alu Zaharije afost isto dăn familija alu popilor. Ja s kima Elizabeta. ");
INSERT INTO ronludari_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Amiždoj irja pravedni la Dimizov š uvjek askulta tot aja če Domnu azapovidit ăn zakonu alu Mojsije. ");
INSERT INTO ronludari_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ali na vut kupil daja če Elizabeta afost štjarpă, a amiždoj irja mult bătrnj. ");
INSERT INTO ronludari_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Udată, Zaharija š popilje ăn skupina aluj služaštje ăn Hram. ");
INSERT INTO ronludari_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Običaju alu popilor afost s arunče kocka tuată zuva kum akuljiđja činje osă utrje ăn Svetište alu Domnuluj ăn Hram š činje osă apringă tămăja. Una zuvă akuljes p Zaharija s apringă tămăja. ");
INSERT INTO ronludari_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","D vrijamjaja mult lumje s ruga ăn dvorištja alu Hramuluj. ");
INSERT INTO ronludari_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Atunča alu Zaharija sa ukazăt anđelu alu Domnuluj. Astat p partja alu dăraptej la žrtveniku d tămăja. ");
INSERT INTO ronludari_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Kănd Zaharija avizut p anđelu, jel mult sa spirjat. ");
INSERT INTO ronludari_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","A anđelu ja zăs: “Na vja frikă, Zaharija! Dimizov auzăt rugala ata: Elizabeta, mujarja ata, osă c fakă bijat. Š osă l kjem Ivan. ");
INSERT INTO ronludari_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Osă c fije drag š t veselješt š mulcă osă s radujaskă kănd s fičja jel. ");
INSERT INTO ronludari_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Kupilu alu vostru osă fije marje la intja alu Domnuluj. Jel nusă bja nič vin nič altje bjarje ljutje. Osă fije pljin d Sufljetu alu Svăntuluj još kănd fi ăn burtă. ");
INSERT INTO ronludari_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Jel osă okrinjaskă p multje Izraelcurj la Domnu, Dimizov alor. ");
INSERT INTO ronludari_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Isti sufljet karje ja dat snagă alu Ilije osă fije ăn bijatu alu tov s pripimaskă p narodu d vinjala alu Domnuluj. Osă okrinjaskă inimilje alu tatilje kătri kupi š nagovorjaskă p ălja karje nu skultă p Dimizov s primjaskă mudrost alu ălja karje askultă.” ");
INSERT INTO ronludari_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zaharija azăs alu anđeluj: “Kum s štiuv k s dogodjaštje aja? Š jo š mujarja amja ištjem već bătărnj.” ");
INSERT INTO ronludari_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","P aja anđelu ja zăs: “Jo sănt Gabrijel. Amvinjit dăla prijestolje alu Dimizov. P minje atrimjes la tinje s c aduk asta bună vorbă. ");
INSERT INTO ronludari_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Jakă, da akuma osă rămăj mut š nusă poc s rubještj tot pănla zuvaja pănd s nu dogodja aja, daja če naj krizut ăn vorbilje alji mjalje, karje osă ispunjaskă d vrijamje alor.” ");
INSERT INTO ronludari_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ăn vrijamjaja narodu aštiptat p Zaharija š na razumit dăče atăta sa zabuvit ăn Svetište. ");
INSERT INTO ronludari_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kănd jel napokon aišăt, na putut nimik s lji zăkă š s lja udă. Kănd lumja avizut aja, š znakurlje karje lja dat ku mănilje, ashvatit k jel avut vizije ăn Svetište. ");
INSERT INTO ronludari_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Kănd azavršăt zuvilje alu Zaharija s lukrjază kašă popa ăn Hram, sa tors akas. ");
INSERT INTO ronludari_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Dăpă duavă trje zălje, mujarja aluj Elizabeta arămas grja, š činč (5) lunj na išăt dăn kasă. Ja azăs: ");
INSERT INTO ronludari_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Aša Domnu sa pobrinit d minje š askinit rušunja dăpă minje la intja alu lumje daja če na putut s am kupi.” ");
INSERT INTO ronludari_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Kănd Elizabeta irja grja šasă (6) lunj, Dimizov atrimjes p anđelu Gabrijel ăn sat Nazaret ăn regija Galileja, ");
INSERT INTO ronludari_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","la djevică karje zaručită dăpă om karje s kjamă Josip. Jel irja d sămăncă alu caru David, a djevica s kima Marija. ");
INSERT INTO ronludari_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gabrijel avinjit š azăs alu je: “Zdravo! Domnu ku tinje. Dimizov ta kuljes!” ");
INSERT INTO ronludari_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","P aja Marija sa uznemirit š na razumit če anđelu avrut s zăkă ku pozdravula. ");
INSERT INTO ronludari_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Anđelu azăs: “Na vja frikă, Marija. Tu ješt aja p karje Dimizov akuljes! ");
INSERT INTO ronludari_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Jakă osă fi grja š osă fač fičor p karje osă l kjem Isusu. ");
INSERT INTO ronludari_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Jel osă fije marje š osă s kjamje Bijatu alu Maj marje Dimizov. Domnu Dimizov osă idja autoritet s fije car kum Dimizov aobečit alu David, sămănca aluj. ");
INSERT INTO ronludari_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Osă vladjaskă p sămănca alu Jakov zauvjek š cara aluj nikad nusă prestanjaskă.” ");
INSERT INTO ronludari_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Marija ăntrijabă p anđelu: “Ali kum? Jo još nam fost ku omu.” ");
INSERT INTO ronludari_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Anđelu Gabrijel ja zăs: “Sufljetu alu Svăntuluj osă s slubuadje p tinje š săla alu Maj marje Dimizov osă t ănviljaskă. Š daja kupilu karje l fiča osă fije svănt š osă s kjamje Bijatu alu Dimizov. ");
INSERT INTO ronludari_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Jakă, Elizabeta, rođakinja ata, aša bătărnă isto duče fičor. Aja ista mujarje, d karje arubit k nu puatje s ajbje kupi, a grja je d šasă (6) lunj. ");
INSERT INTO ronludari_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","K alu Dimizov nimika nuje nemoguće!” ");
INSERT INTO ronludari_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Marija azăs alu Gabrijel: “Jakă, argata sănt alu Domnuluj. S fije kum tu zăč!” Š Gabrijel apljikat dăla ja. ");
INSERT INTO ronludari_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Duavă trje zălje dăpă aja, Marija majdată apljikat ăn sat ăn djalurj alu Judeje. ");
INSERT INTO ronludari_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Kănd ja ažuns, auntrat ăn kasa alu Zaharija š apozdravit p Elizabeta. ");
INSERT INTO ronludari_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Kănd Elizabeta auzăt pozdravu alu Marije, kupilu ăn burtă alu Elizabetăj dăturdată mult sa miškat š Elizabeta sa napunit ku Sufljetu alu Svăntuluj. ");
INSERT INTO ronludari_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Elizabeta d radost marje ăntarje astrigat: “Maj mult ješt blagoslovită d tuatje mujerj š blagoslovit je kupilu ăn burta ata! ");
INSERT INTO ronludari_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ku čaja amzaslužăt častula s m positjaskă mama alu Domnuluj alu mjov! ");
INSERT INTO ronludari_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Jakă kănd auzăt pozdravu alu tov, kupilu ăn burtă dăturdată mult sa miškat d radost! ");
INSERT INTO ronludari_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Blagoslovită ješt daja čaj krizut k osă s ispunjskă poruka karje ca trimjes Domnu!” ");
INSERT INTO ronludari_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Atunča Marija azăs: “Inima amja adrikă p Domnu, ");
INSERT INTO ronludari_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","sufljetu alu mjov s radujaštje la Dimizov, Spasitelju alu mjov, ");
INSERT INTO ronludari_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","k p minje ma kuljes, p ponizna argata aluj! Audjec, pănd akuma tuată generacija osă zăkă k Dimizov ma blagoslovit, ");
INSERT INTO ronludari_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","daja če Dimizov karje arje tuată săla afukut marje čudă d minje! Svănt je lumilje aluj. ");
INSERT INTO ronludari_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Iskazaštje milostu p toc ălja ăn tuată vrijamja karje arje frikă d jel. ");
INSERT INTO ronludari_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ku măna capănă afukut marje čudă š aputirit p lumja karje ponosni š umišljeni. ");
INSERT INTO ronludari_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Jel aizbacăt p vladari s nu vladjaskă više, a adrikat p lumje karje je ponizni. ");
INSERT INTO ronludari_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","A p lumja karje irja flămănž lja nasitit ku binje, a p lumja karje bogată lja trimjes dăla jel ku mănilje gualje. ");
INSERT INTO ronludari_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Jel ažutat alu Izrael, alu argatu aluj baš kum adat obečală alu sămănca anuastră, alu Abraham š alu kupi aluj, k osă lji fije uvjek d milă.” ");
INSERT INTO ronludari_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Atunča Marija ku Elizabeta arămas njeđe trje (3) lunj š sa tors akas. ");
INSERT INTO ronludari_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Alu Elizabeta avinjit vrijamja s fakă š ja afukut bijat. ");
INSERT INTO ronludari_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Kănd tuată familija alu je š komšiji auzăt d asta, kum Domnu afost aša d bun kătri ja, toc sa bukurat zajedno ku ja. ");
INSERT INTO ronludari_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kănd kupilu anapunit opt (8) zălje, atribut s fije obrezăt, aša k komšiji š familija avinjit s proslavjaskă aja. Avrut p kupilu s l kjamje Zaharija kum tatusov s kjamă, ");
INSERT INTO ronludari_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ali Elizabeta azăs: “Nu, njego mora s s kjamje Ivan!” ");
INSERT INTO ronludari_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Komšiji š familija azăs: “Nimilja dăla familija ata nu s kjamă Ivan!” ");
INSERT INTO ronludari_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Atunča, daja če Zaharija na putut s audă, lumja ku mănilje la tribat kum jel vrja kupilu s s kjamă. ");
INSERT INTO ronludari_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zaharija akătat s ji dja ploče s skrije š askris: “S kjamă Ivan”, š toc sa mirat. ");
INSERT INTO ronludari_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Dimizov alu Zaharije adiškis gura š ja dizljigat ljimba š jel dăturdată ančiput s rubjaskă š s slavjaskă p Dimizov. ");
INSERT INTO ronludari_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Kănd toc karje trija upruapje d jej avizut če Dimizov afukut alu Zaharije, lja fost frikă d Dimizov. Ăn tuatje saturlje ăn djalurlje alu Judeje, lumja rubja d aja če sa dogodit. ");
INSERT INTO ronludari_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Činje god auzăt d jej găndja d aja š sa tribat: “Atunča če osă fije d bijatusta kănd ufi marje?”, k Domnu sigurno osă fakă nješto marje pisti jel. ");
INSERT INTO ronludari_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Sufljetu alu Svăntuluj aispunit p Zaharija, tata alu Ivan, š jel arubit asta porukă dăla Dimizov: ");
INSERT INTO ronludari_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Slava alu Domnuluj, Dimizov alu Izraelcilor, k avinjit s ažută alu narodu aluj š s lji izbavjaskă! ");
INSERT INTO ronludari_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Š atrimjes nauvă marje Spasitelj dăn sămănca alu argatu aluj David, ");
INSERT INTO ronludari_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","kum jel d mult aobečit pisti vorba alu prorokurlje karje jel atrimjes: ");
INSERT INTO ronludari_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","s nji spasaskă dăla dušmani alji noštri š dăla mănă alu tuată lumja karje nji mrzaštje. ");
INSERT INTO ronludari_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Jel asta afukut s pokazaskă milă alu sămănca anuastră aša ča ispunit savezu alu svănt karje afukut ku jej, ");
INSERT INTO ronludari_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","aša ča ispunit obečala karje adat alu Abraham, alu anuastră sămănca. ");
INSERT INTO ronludari_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Kašă kum aobečit, nja skos dăla dušmanj s putjem s ji služăm frzdă frikă, ");
INSERT INTO ronludari_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","s trijim kum Dimizov azăs š s fičem čije bun ăn tuatje zuvilje anuaštrje. ");
INSERT INTO ronludari_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","A tu, bijatu alu mjov, osă t kjem proroku alu Maj marje Dimizov. Osă plječ la intja alu Domnuluj s ji pripremještj drumu. ");
INSERT INTO ronludari_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Osă ănvăc p narodu aluj s štije kum s s spasaskă kum s lji fije oprostit grešala alor. ");
INSERT INTO ronludari_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Daja če je Dimizov pljin d milă š arje osjećaj d noj, jel trimjatje lumina dăn čerj. Kašă suarilje karje sa drikă ăn diminjacă, ");
INSERT INTO ronludari_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Dimizov osă adukă lumina alu ălja karje trijaštje ăn nuaptje š arje frikă d muartje. Jel osă nji pokazaskă drumu karje aduče ăn mir.” ");
INSERT INTO ronludari_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ivan akriskut š apostanit capăn ăn sufljet. Trija ăn lok undje nuje nimika. Kănd akriskut, jel ančiput la intja alu toc s rubjaskă alu naroduluj alu Izrael. ");
INSERT INTO ronludari_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ăn vrijamaja caru alu Rimuluj, August, azapovjedit s fakă popisu d tuată lumje karje trijaštje ăn cara. ");
INSERT INTO ronludari_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ăsta afost prvi popis d lumje karje sa dogodit ăn vrijamje pănd Kvirinije afost upravitelju p regija Sirija. ");
INSERT INTO ronludari_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Toc apljikat ăn trgu undje trija sămănca aluj s s skrije ăn popis. ");
INSERT INTO ronludari_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Aša š Josip, karje afost sămănca alu caru David, apljikat dăn sat Nazaret ăn regije Galileje ăn sat Betlehem ăn regije Judeje, undje d mult sa fukut David. ");
INSERT INTO ronludari_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Jel apljikat una ku zaručnica aluj, Marija, s s skrije ăn popis. Marija već afost grja, ");
INSERT INTO ronludari_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","š pănd afost ăn Betlehem, ja vinjit vrijamja s fakă. ");
INSERT INTO ronludari_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ja afukut bijat, prvi kupil, la ănvilijat š la pus ăn aljbje daja če ăn sat undje irja sobje d gostjamje nu irja lok d jej. ");
INSERT INTO ronludari_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ăn nuaptjaja p păjenj upruapje d Betlehem, njeki pastirurj păza vojilje alor. ");
INSERT INTO ronludari_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Dăturdată sa ukazăt anđelu alu Domnuluj š lja osvitljit slava alu Domnuluj š jej mult sa spirjat! ");
INSERT INTO ronludari_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Anđelu lja zăs: “Na vjec frikă! Jakă aduk vuavă Bună vorbă karje p tuată lumja s usričaskă! ");
INSERT INTO ronludari_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Astăz sa fukut vuavă Spasitelju ăn Betlehem, ăn trgu alu David. Jel je Kristu, Domnu! ");
INSERT INTO ronludari_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Aša osă štijec k je istina aja če zăk: Osă găsăc kupilu karje je ănvilijat ăn plahtă kum zače ăn aljbje.” ");
INSERT INTO ronludari_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Dăturdată alu anđeluj avinjit marje vuastje d anđelurlje dăn čerj karje aslavit p Dimizov: ");
INSERT INTO ronludari_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Slava alu Dimizov karje vladjaštje p čerj, a p pămănt mir alu lumje karje ja ugodit.” ");
INSERT INTO ronludari_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Š anđelurlje apljikat dăla jej š sa tors p čerj. Pastiri arubit unu ku alc: “Ajdac ăn Betlehem s vidjem ča fost če nuavă azăs Domnu!” ");
INSERT INTO ronludari_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Apripit ăn Betlehem š ănklo angăsăt p Marija š p Josip ku kupilu če sa fukut karje azukut ăn aljbje. ");
INSERT INTO ronludari_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Kănd la găsăt, alu toc arubit aja če anđelu azăs d kupil. ");
INSERT INTO ronludari_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Š tuată lumja karje apus urjajke la pastirurj sa mirat d aja če lja zăs. ");
INSERT INTO ronludari_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","A Marija nimika na mujtat d asta ča uzăt š găndja d aja ăn inima alu je. ");
INSERT INTO ronludari_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Pastiri sa tors la vojilje p karje păza š slavja š zahvalja alu Dimizov. Tot ča uzăt š avizut afost kum lja zăs anđelu. ");
INSERT INTO ronludari_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","D opt (8) zălje maj ănklo kănd avinjit vrijamja s obrezaskă p kupilu, ja pus lumilje Isusu karje anđelu adat majdată njego če Marija arămas grja. ");
INSERT INTO ronludari_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Kănd avinjit vrijamja Marija s s očistjaskă kum skrije ăn zakonu alu Mojsije, Josip š Marija alat p Isusu š apljikat ăn Hram ăn Jeruzalem. La posvitit alu Domnuluj, ");
INSERT INTO ronludari_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","kum skrije ăn zakonu alu Domnuluj: “Tot bijatu karje prvi sa fukut pripadnjaštje alu Domnuluj.” ");
INSERT INTO ronludari_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Š aprinisăt žrtvă kum mama aputja jar s fije čistă, kum zakonu alu Mojsije ănvacă: “duavă (2) grlic ili doj (2) goluburj tănărj.” ");
INSERT INTO ronludari_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Trija atunča unu om ăn Jeruzalem, s kjamă Šimun, karje irja pravedan š askulta zakonu alu Dimizov. Sufljetu alu Svăntuluj irja p jel š aštiptat p Dimizov s izbavjaskă p Izraelcurlje kum aobečit. ");
INSERT INTO ronludari_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Sufljetu alu Svăntuluj ja zăs k nusă muarje pănă god nu vjadje p Kristu karje Domnu atrimjes s izbavjaskă p narodu aluj. ");
INSERT INTO ronludari_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","P zuvă kănd Josip š Marija adus kupilu Isusu s fakă obredu kum je skris ăn zakonu alu Mojsije, Sufljetu alu Svăntuluj adus p Šimun s pljače ăn Hram. ");
INSERT INTO ronludari_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Šimun alat p Isusu ăn mănj š aslavit p Dimizov ku vorbiljaštja: ");
INSERT INTO ronludari_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Domnulje, maj ispunit obečala karje maj dat š akuma jo, argatu alu tov, pot s mor ăn mir. ");
INSERT INTO ronludari_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Akuma vojki alji mjej avizut spasjala, ");
INSERT INTO ronludari_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","p spasitelju karje tu atrimjes d tot narodu. ");
INSERT INTO ronludari_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Jel je lumina s otkrijaskă istina ata alu tot narodu, ăla karje aduče slava alu Izrael, narodu alu tov.” ");
INSERT INTO ronludari_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Josip š Marija sa mirat la vorbje če s rubja d Isusu. ");
INSERT INTO ronludari_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Šimun lja blagoslovit š azăs alu Marije, mama alu Isusuluj: “Jakă, Dimizov atrimjes p kupilusta k mulc Izraelcurj osă kadă š mulc osă adrikă. Dimizov la trimjes kašă znaku s pokazaskă drumu d spasjală, karje mulc inš osă l odbacaskă, ");
INSERT INTO ronludari_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","š aša osă arată rovu ăn inima alor. A kănd l odbacaštje, maču osă probijaskă inima ata.” ");
INSERT INTO ronludari_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Afost ăn Hram š proročică Ana, fata alu Fanuel dăn sămănca alu Ašer. Ja irja mult bătrnă. Afost šaptje (7) aj ăn brak ");
INSERT INTO ronludari_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","š atunča atrijit kašă udovica pănla optzăč š patru (84) aj. Na išăt dăn Hram, njego ăn post š ăn molitvă aslužăt alu Dimizovuluj zuva š nuaptja. ");
INSERT INTO ronludari_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Baš kănd Šimunu azavršăt, avinjit Ana š ančiput s slavjaskă p Dimizov š s rubjaskă d Isusu alu toc karje aštiptat p Dimizov s izbavjaskă p Jeruzalem dăla dušmanji alor. ");
INSERT INTO ronludari_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Kănd Josip š Marija afukut kum zakonu alu Domnuluj azapovjedit, sa tors akas ăn Nazaret ăn regije Galileje. ");
INSERT INTO ronludari_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Kupilu Isusu akriskut. Apostanit capăn š maj mult mudar š Dimizov nastavja s l blagoslovjaskă. ");
INSERT INTO ronludari_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Roditelji alu Isusuluj tot anu pljika ăn Jeruzalem kănd irja prazniku Pasha. ");
INSERT INTO ronludari_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Kănd Isusu avut duavăsprjače (12) d aj, jej apljikat kašă uvjek s slavjaskă prazniku. ");
INSERT INTO ronludari_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Dăpă praznik, roditelji alu Isusuluj ančiput akas, a fălkovu Isusu arămas ăn Jeruzalem, ali roditelji aluj na štijut aja. ");
INSERT INTO ronludari_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Agăndit k Isusu je ăn grupa alor. Jej aumblat una zuvă a atunča ančiput s l katje ăntră familjije š ăntră ortač alor, ");
INSERT INTO ronludari_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ali nu la găsăt š aša sa tors ăn Jeruzalem š ănklo s l katje. ");
INSERT INTO ronludari_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Dăpă trje (3) zălje la găsăt ăn Hram ăntră učiteljurj kum punje urjajke š lji ăntrjabă. ");
INSERT INTO ronludari_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Š toc karje apus urjajke la Isusu sa mirat kăt štije š kum binje odgovorjaštje p pitanje. ");
INSERT INTO ronludari_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Kănd jej angăsăt p Isusu na štijut če s găndjaskă. Azăs mumusa: “Bijatu alu mjov, dăče afukut tu asta nuavă? Jakă, tatutov š jo mult nja sikirit š noj pistot t kătam!” ");
INSERT INTO ronludari_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Isusu azăs alor: “Dăče mas kătat? Dali voj nu štijic k jo mora s fiuv ăn kasa alu Tatimjov?” ");
INSERT INTO ronludari_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ali jej nu razumja če jel avrut s lji zăkă. ");
INSERT INTO ronludari_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Isusu sa tors akas ku mumusa š ku tatusov ăn sat Nazaret š askulta p jej. A mumusa nimika na mujtat d asta če sa dogodit. ");
INSERT INTO ronludari_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Isusu krištja š postanja još maj mult mudar š Dimizov l blagoslovja maj mult š maj mult, a lumja l poštuja maj mult š maj mult. ");
INSERT INTO ronludari_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Afost činčsprjače (15) d aj kum caru alu Rimuluj Tiberije ančiput s vladjaskă. Poncije Pilat afost upravitelju ăn regije Judeje. Herod avladit ăn regije Galileje, a fratusov Filip avladit ăn regije Itureje š Trahonitide, a Lizanije avladit ăn regije Abilene. ");
INSERT INTO ronludari_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Š Ana š Kaifa afost marj popurj ăn Jeruzalem. Ăn vrijamjaja Dimizov rubja alu Ivan, bijatu alu Zaharija, ăn pustinje. ");
INSERT INTO ronludari_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Jel apljikat ăn tuatje lokurj pănglă apă Jordan s rubjaskă alu lumjej k trjebje s s bătjază s pokazaskă kum sa okrinit dăla grešală š Dimizov lja oprostit grešala. ");
INSERT INTO ronludari_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Kum askris proroku Izaija, Ivan afost “glasu karje strigă ăn pustinje: ‘Pripremic drumu d Domnu š očistic d jel stazilje! ");
INSERT INTO ronludari_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ispunic tuată dolina š poravnic tot djalu š brjegu! Ispravic drumu karje strămb š poravnic aja čije nuje ravno! ");
INSERT INTO ronludari_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Tuată lumja osă vjadje spasjala alu Dimizovuluj!” ");
INSERT INTO ronludari_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ivan rubja alu mulc lumje karje vinja s s bătjază: “Voj, šarpilor! Činje va zăs k aša d ljaznje putjec s fuđic dăla kaznă karje Dimizov trimjatje? ");
INSERT INTO ronludari_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Fičec binje karje arată k vas okrinit dăla grešala avuastră. Š vu ănšălăc akă găndic k ištjec sigurni samo daja če ištjec sămănca alu Abraham. Ali jo vu zăk, Dimizov puatje d bulovanjištja s stvurjaskă kupi alu Abraham! ");
INSERT INTO ronludari_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Dimizov uskoro osă luvjaskă ku sukurja ăn tot ljemnu karje nu dă bun plod. Tot ljemnu karje nu dă bun plod osă fije tijat š arunkat ăn fok.” ");
INSERT INTO ronludari_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Antribat mulc lumje p Ivan: “Atunča če trjebje s fičem?” ");
INSERT INTO ronludari_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ivan lja zăs: “Činje arje duavă (2) kămăšj, trjebje s dja alu ălja karje narje ničuna. A činje arje mănkarje, trjebje s podiljaskă ku ălja karje narje.” ");
INSERT INTO ronludari_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Avinjit s s bătjază čak š carinikurlje š la tribat: “Učiteljulje, če trjebje s fičem?” ");
INSERT INTO ronludari_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ivan lja zăs: “Nu lăc maj marje porezu njego če je lumja datorj.” ");
INSERT INTO ronludari_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Š la tribat vuastja: “A če trjebje noj s fičem?” Ivan lja zăs: “Nu lăc banji dăla nimilja ku săla š p nimilja nu punjec minčunj s dobidic banji. Njego fic zadovoljni ku plata avuastră.” ");
INSERT INTO ronludari_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Kum lumja očekuja k Kristu ăndată vinje, toc ăn inimă s ăntriba dal je Ivan Kristu. ");
INSERT INTO ronludari_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Daja Ivan alu toc azăs: “Jo p voj bătjez ku apa, ali vinje njeko maj marje d minje, atăta d marje k jo nu sănt dostojan čak s ji fiuv argat. Jel p voj osă bătjază ku Sufljetu alu Svăntuluj š ku foku. ");
INSERT INTO ronludari_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Jel osă fije kašă omu karje odvojaštje gruvu dăla jarbă. Gruvu osă sprimjaskă ăn ostavă, a jarba osă apringă ku foku karje nikad nu prestanjaštje s argă.” ");
INSERT INTO ronludari_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ivan rubja alu lumjej Bună vorbă d Dimizov ku multje altje opomenje. ");
INSERT INTO ronludari_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ivan la intja alu toc la ukorit p Herod, karje irja vladaru dăn regije Galileje, daja če sa ănsurat ku Herodijada, karje afost mujarja alu fratisov, š d multje altje rovj ča fukut Herod. ");
INSERT INTO ronludari_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ali kănd la ukorit Ivan, Herod p tot aja adodajit još unu rov: jel adat alu vuastja aluj s puje p Ivan ăn kisuarje. ");
INSERT INTO ronludari_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Majdată njego če p Ivan la pus ăn kisuarje, kănd Ivan bătizat p toc karje avinjit la jel, jel bătizat š p Isusu. Atunča kănd Isusu sa rugat, čerju sa diškis, ");
INSERT INTO ronludari_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","š Sufljetu alu Svăntuluj sa slubuzăt p jel ăn oblik kašă golubu. Dăn čerj sa uzăt glasu: “Tu ješt Bijatu alu mjov p karje jo vrjauv! Tu ješt radostu alu mjov!” ");
INSERT INTO ronludari_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Kănd Isusu ančiput s rubjaskă d Dimizov la intja alu toc, avut njeđe trjezăč (30) d aj. P Isusu l kuništja k je bijatu alu Josip. Josip afost bijatu alu Eli, ");
INSERT INTO ronludari_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli afost bijatu alu Matat, Matat afost bijatu alu Levi, Levi afost bijatu alu Malki, Malki afost bijatu alu Janaj, Janaj afost bijatu alu Josip, ");
INSERT INTO ronludari_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josip afost bijatu alu Matatija, Matatija afost bijatu alu Amos, Amos afost bijatu alu Naum, Naum afost bijatu alu Hesli, Hesli afost bijatu alu Nagaj, ");
INSERT INTO ronludari_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaj afost bijatu alu Mahat, Mahat afost bijatu alu Matatija, Matatija afost bijatu alu Šimij, Šimij afost bijatu alu Joseh, Joseh afost bijatu alu Joda, ");
INSERT INTO ronludari_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda afost bijatu alu Johanan, Johanan afost bijatu alu Resa, Resa afost bijatu alu Zerubabel, Zerubabel afost bijatu alu Šealtiel, Šealtiel afost bijatu alu Neri, ");
INSERT INTO ronludari_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri afost bijatu alu Malki, Malki afost bijatu alu Adi, Adi afost bijatu alu Kosam, Kosam afost bijatu alu Elmadam, Elmadam afost bijatu alu Er, ");
INSERT INTO ronludari_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er afost bijatu alu Jošua, Jošua afost bijatu alu Eliezer, Eliezer afost bijatu alu Jorim, Jorim afost bijatu alu Matat, Matat afost bijatu alu Levi, ");
INSERT INTO ronludari_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi afost bijatu alu Šimun, Šimun afost bijatu alu Juda, Juda afost bijatu alu Josip, Josip afost bijatu alu Jonam, Jonam afost bijatu alu Elijakim, ");
INSERT INTO ronludari_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elijakim afost bijatu alu Meleja, Meleja afost bijatu alu Mena, Mena afost bijatu alu Matata, Matata afost bijatu alu Natan, Natan afost bijatu alu David, ");
INSERT INTO ronludari_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","David afost bijatu alu Jišaj, Jišaj afost bijatu alu Obed, Obed afost bijatu alu Boaz, Boaz afost bijatu alu Sala, Sala afost bijatu alu Nahšon, ");
INSERT INTO ronludari_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahšon afost bijatu alu Aminadab, Aminadab afost bijatu alu Admin, Admin afost bijatu alu Arni, Arni afost bijatu alu Hesron, Hesron afost bijatu alu Peres, Peres afost bijatu alu Juda, ");
INSERT INTO ronludari_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda afost bijatu alu Jakov, Jakov afost bijatu alu Izak, Izak afost bijatu alu Abraham, Abraham afost bijatu alu Terah, Terah afost bijatu alu Nahor, ");
INSERT INTO ronludari_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor afost bijatu alu Serug, Serug afost bijatu alu Reu, Reu afost bijatu alu Peleg, Peleg afost bijatu alu Eber, Eber afost bijatu alu Sala, ");
INSERT INTO ronludari_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala afost bijatu alu Kenan, Kenan afost bijatu alu Arpakšad, Arpakšad afost bijatu alu Šem, Šem afost bijatu alu Noa, Noa afost bijatu alu Lamek, ");
INSERT INTO ronludari_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek afost bijatu alu Metušalah, Metušalah afost bijatu alu Henok, Henok afost bijatu alu Jered, Jered afost bijatu alu Mahalalel, Mahalalel afost bijatu alu Kenan, ");
INSERT INTO ronludari_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan afost bijatu alu Enoš, Enoš afost bijatu alu Šet, Šet afost bijatu alu Adam, Adam afost bijatu alu Dimizov. ");
INSERT INTO ronludari_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Isusu, pljin ku Sufljetu alu Svăntuluj, apljikat dăla apa Jordan š Sufljetu la dus ăn lok undje nuje nimika ");
INSERT INTO ronludari_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","š d patruzăč (40) d zălje š la iskušăt nikuratu. D zăljiljalja na mănkat nimik, š kănd atrikut patruzăč (40) d zălje, afost flămănd. ");
INSERT INTO ronludari_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","A nikuratu ja zăs: “Akă ješt Bijatu alu Dimizovuluj, zi alu buluvanusta s postanjaskă mălaj.” ");
INSERT INTO ronludari_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Isusu ja odgovorit: “Skris je ăn Svăntă pismă: ‘Nu trijaštje omu samo d mălaj.’” ");
INSERT INTO ronludari_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Š nikuratu la dus p Isusu p marje djal š ja pokazăt dăturdată tuată cara alu pămăntuluj ");
INSERT INTO ronludari_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","š nikuratu zăče: “Cije osă zdauv asta tuată vlast š slava aluj. Mije je dat š jo dav alu činje vrjauv. ");
INSERT INTO ronludari_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Akă t poklonještj la minje, tot je alu tov.” ");
INSERT INTO ronludari_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Isusu ja odgovorit: “Skris je ăn Svăntă pismă: ‘Klanjaštje la Domnu, Dimizov alu tov, š aluj jedino služaštje!’” ");
INSERT INTO ronludari_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Nikuratu la dus ăn trg Jeruzalem š la pus p špic p Hram š zăče aluj: “Akă ješt Bijatu alu Dimizovuluj, arunkitje da iča ăn zos! ");
INSERT INTO ronludari_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Daja če skris je ăn Svăntă pismă: ‘Jel osă zapovidjaskă alu anđeli aluj d tinje s t păzaskă’, ");
INSERT INTO ronludari_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","š: ‘p mănj s t adukă undje ku pičoru s nu t tu luvješt d buluvan.’” ");
INSERT INTO ronludari_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Isusu ja zăs: “Skris je ăn Svăntă pismă: ‘Nu iskuša p Domnu, Dimizov alu tov!’” ");
INSERT INTO ronludari_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Kănd iscrpit tuată kušnja, nikuratu sa udaljit dăla jel pănla nuavă prilikă s l iskušaskă. ");
INSERT INTO ronludari_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Isusu, pljin d snagă alu Sufljetuluj, sa tors ăn regija Galileja š vorba d jel sa proširit ăn tuatje lokurj ăn Galileja. ");
INSERT INTO ronludari_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Isusu ănvăca ăn lokurj undje židovi s strănđa š s ruga (karje s kjamă sinagoga) š toc l hvalja. ");
INSERT INTO ronludari_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Š atunča Isusu avinjit ăn Nazaret, ăn sat undje akriskut. Š kašă uvjek sămbătă untră ăn sinagogă š sa drikă s čitjaskă d Svănta pismă pănglă toc. ");
INSERT INTO ronludari_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Alu Isusuluj antins knjiga alu prorokuluj Izaija. Jel adiškis knjiga š angăsăt lok undje stă skris: ");
INSERT INTO ronludari_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Sufljetu alu Domnuluj je p minje. Madat snagă š autoritet s rubjesk Bună vorbă alu săračilor. Matrimjes s rubjesk alu lumjej karje zarobic s puatje s pljače slobodni, s tork vidu alu vorbilor, s oslobodjesk p lumja dăla ălja karje lji mučaštje, ");
INSERT INTO ronludari_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","š s rubjesk k ăsta an ăn karje Domnu arată aluj binilje. ");
INSERT INTO ronludari_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Atunča Isusu ankis knjiga, untuarče alu pomoćnikuluj š šadje s rubjaskă. Tuată lumja ăn sinagogă sujăta ăn jel š jedva štipta s zăkă nješto. ");
INSERT INTO ronludari_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Š ančiput ku aštja vorbje s lji zăk: “Astăz sa ispunit aštja vorbje d Svănta pismă karje akuma amčitit.” ");
INSERT INTO ronludari_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Š kănd Isusu azavršăt ku vorba, toc karje irja ăn sinagogă rubja d jel š s mira d binilje alu Dimizovuluj d karje jel rubja. Jej rubja: “Dali nuje ăsta bijatu alu Josip?” ");
INSERT INTO ronludari_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","A Isusu lji zăče: “Sigurno osă mi zăčec asta poslovică: ‘Doktorulje, likujaštje săngur p tinje!’ š: ‘Făj š aiča ăn trg undje ajkriskut aja čam auzăt če sa dogodit ăn trg Kafarnaum.’” ");
INSERT INTO ronludari_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Š nastavit: “Asta poslovică je istinita: ‘Nimilja nu prihvatjaštje p proroku ăn lok undje jel akriskut’. ");
INSERT INTO ronludari_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Kum š štijec afost multje udovic ăn Izrael kănd proroku Ilija afost viuv. Atunča p trje (3) aj š šasă (6) lunj na fost pluaje š apostanit marje fuamje p tot pămăntu. ");
INSERT INTO ronludari_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ali Dimizov na trimjes p Ilija alu ničuna udovică ăn Izrael. Njego jel la trimjes s ažutje alu udovicăj karje na fost Židovkă ăn trg Sarfata majuprapje d trg Sidon. ");
INSERT INTO ronludari_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Š isto aša kănd afost proroku Elizej viuv, ăn Izrael afost multje lumje karje avja gubă, zarazna buală p pjalje. Ali ničunu dăla jej nu sa likujit osim Naaman d Sirija.” ");
INSERT INTO ronludari_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Kănd auzăt, toc ăn sinagogă sa nikăžăt. ");
INSERT INTO ronludari_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Jej sa skulat, la putirit d trg š la dus p rub d litică p karje sagradit alor trgu s l runče ăn zos. ");
INSERT INTO ronludari_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ali jel atrikut ăntră jej š apljikat p drumu aluj. ");
INSERT INTO ronludari_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Isusu sa slubăzăt zos ăn Kafarnaum, karje je još unu trg ăn regija Galileja, undje ănvacă sămbătă ăn sinagogă. ");
INSERT INTO ronludari_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Š lumja karje punja urjajke afost zadivic ku văncală aluj daja če rubja kašă ăla karje arje vlast. ");
INSERT INTO ronludari_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Afost ăn sinagoga omu ku sufljetu alu rov. Jel astrigat ăn tot glasu: ");
INSERT INTO ronludari_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Hej, če aj tu ku noj, Isusulje dăn Nazaret? Ajvinjit s uništještj p noj p sufljeti alji rovj? Štiuv jo činje ješt tu: tu ješt Svăntu karje Dimizov atrimjes!” ");
INSERT INTO ronludari_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Isusu ja zapovjedit: “Tač š ješ dăn jel!” P aja sufljetu alu rov p omu la dubărăt pănglă toc š aišăt d jel š nu ja naudit nimika. ");
INSERT INTO ronludari_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Lumja afost zadivic š ančiput s rubjaskă unji ku alc: “D karje aštja vorbje! Ku autoritetu š ku snaga zapovjedjaštje alu sufljeti alji rovj, š jej jašă!” ");
INSERT INTO ronludari_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Š toc ăn regijaja auzăt če Isusu afukut. ");
INSERT INTO ronludari_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Isusu aišăt d sinagogă š apljikat ăn kasă alu Šimun. A suakra alu Šimunuluj amučito marje fok š jej la rugat s ja žutje. ");
INSERT INTO ronludari_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Isusu astat pănglă ja, zapovjedit alu fokuluj s u lasje š foku alăsato. Š odma sa skulat š lja dus s mălănčje. ");
INSERT INTO ronludari_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kănd akăzut nuaptja, toc karje arje bolesnikurj lja dus la Isusu. A Isusu p tot ăla apus mănilje s lji likujaštje d tuatje bualje. ");
INSERT INTO ronludari_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Isusu putirja sufljeti alji rovj dăn multje lumje, š sufljeti alji rovj striga kănd iša: “Tu ješt Bijatu alu Dimizovuluj!” Atunča jel alor zapovjedit s nu rubjaskă daja če jej aštijut k je jel Kristu p ăla karje Dimizov atrimjes. ");
INSERT INTO ronludari_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kănd asvanit zuva, Isusu aišăt d trgula š apljikat ăn pustinje. Š multă lumje l kată. Kănd la găsăt, jej l ruagă s rămăje ku jej. ");
INSERT INTO ronludari_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","A jel lji zăče: “Trjebje s măduk š ăn alturj trgurj s rubjesk Bună vorbă d cara alu Dimizov. Daja Dimizov matrimjes.” ");
INSERT INTO ronludari_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Š Isusu rubja Bună vorbă ăn sinagogje ăn pămănt alu Židovilor. ");
INSERT INTO ronludari_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Una zuvă, kănd Isusu astat pănglă apă Galileja, multă lumje s strănđa pănglă jel s audje vorba alu Dimizov. ");
INSERT INTO ronludari_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Majdată d asta, njeki ribarji već aišăt dăn čamacurj š ančiput s čistjaskă mrežilje. A Isusu avizut alor doj (2) čamacurj p obală ");
INSERT INTO ronludari_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","š auntrat ăn unu čamac, karje irja alu Šimun. Š Isusu la rugat s puatje ucără s l pinđje dăla obală. Atunča šadje, š ănvăca p narodu d čamac. ");
INSERT INTO ronludari_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Kănd aprestanit s rubjaskă, zăče alu Šimun: “Pinđje čamacu maj dăpartje undje maj adănkă apa, š arunkăc mrežilje d pukat.” ");
INSERT INTO ronludari_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Šimunu zăče alu Isusuluj: “Gospodarulje, tuată nuaptja njam potrudit š nimika nam pukat. Ali kum tu aša zăč, osă arunk mreža.” ");
INSERT INTO ronludari_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kănd Šimun š ortači aluj afukut aja, jej apukat mult pjaštje, atăta d mrežilje ančiput s s rupă. ");
INSERT INTO ronludari_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ribarji afukut ku măna alu ortači alor ăn altu čamac s vije s ažută. Jej avinjit š atăta napunit p amiždoj čamacurj d pjaštje k jej ančiput s potunjaskă. ");
INSERT INTO ronludari_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Kănd Šimun Petar aja avizut, akăzut la intja alu Isusuluj š zăče: “Fuđ dăla minje, Domnulje, daja če nu sănt om bun!” ");
INSERT INTO ronludari_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Š jel š toc karje afost ku jel ăn čamac sa mirat kăt mult pjaštje apukat. ");
INSERT INTO ronludari_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Š isto aša sa mirat Jakov š Ivan, fičorji alu Zebedej, ortači alu Šimun. Isusu atunča zăče alu Šimun: “Navja frikă. Dakuma osă puč p lumja.” ");
INSERT INTO ronludari_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kănd jej askos čamacurj p obală, jej alăsat tot š apljikat dăpă Isusu. ");
INSERT INTO ronludari_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Una zuvă Isusu avinjit ăn unu trg undje afost unu om pljin d bualje p pjalje. Kănd jel avizut p Isusu, akăzut la intja alu Isusuluj ku fălči kătri pămănt š sa rugat d jel: “Domnulje, akă vrjaj, poc s m likuješt.” ");
INSERT INTO ronludari_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Isusu tinđje măna, la dotaknit š zăče: “Vrjauv. Fi likujit!” Š guba odma sa povlačit. ");
INSERT INTO ronludari_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Isusu ja naredit: “Nu zăča alu nimilja, nu još, njego fuđ odma š pokazaštitje alu popăj kum aputja s t pregledjaskă. Prinisaštje žrtvă d čistjala ata, kum Mojsije azapovidit kum aputja toc s vjadă k ješt likujit.” ");
INSERT INTO ronludari_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Atunča glasu d Isusu tot maj mult sa proširit š mulc narod avinja s l audje š s likujaskă d buala alor. ");
INSERT INTO ronludari_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","A maj mult vorj jel s povlača ăn pustinje š s ruagă. ");
INSERT INTO ronludari_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Kănd una zuvă Isusu ănvaca p narodu, ănklo šidja š farizeji š učitelji alu zakonu alu Mojsije karje avinjit dăn tot satu ăn regija Galileja š regija Judeja š d trg Jeruzalem. A săla alu Domnuluj irja ku Isusu s likujaskă p lumja. ");
INSERT INTO ronludari_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Avinjit njeka lumje karje aduče p nosilje p om karje nu puatje s umblje, pa pokuša s l adukă š s položaskă păglu Isusu. ");
INSERT INTO ronludari_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Păntruv narod jej na putut s l adukă ăn kasă undje Isusu ănvăca. La dus p stipinic p krov š afukut rupă š p nosilă, la slubuzăt ăn mižlok d sobă pravo la intja alu Isusuluj. ");
INSERT INTO ronludari_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","D aja Isusu ashvatit k krjadje ăn jel, azăs: “Ortakulje, sa oprostit grešala ata.” ");
INSERT INTO ronludari_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","P asta učitelji d zakonu alu Mojsije š farizeji agăndit: “Činje ăsta karje găndjaštje k rubjaštje kašă Dimizov? Činje, osim Dimizov, puatje s oprostjaskă grešala?” ");
INSERT INTO ronludari_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ali Isusu aštijut če găndjaštje š lji zăče: “Dăče aša găndic? ");
INSERT INTO ronludari_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Dali nuje majušurje s zăkă: ‘Sa oprostit grešala ata’, njego s zăkă: ‘Skual š umblă’? ");
INSERT INTO ronludari_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ali, s štijic k jo, Bijatu alu Omuluj, am autoritet p pămănt s oprostjesk grešala.” Atunča zăče alu omuluj karje nu puatje s umblje: “Cije zăk: ‘Skual, ja nosilă š fuđ akasă!’” ");
INSERT INTO ronludari_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Š omu akuma sa skulat la vojki alor, alat aja p čaja azukut š apljikat akas, slavja p Dimizov p drum. ");
INSERT INTO ronludari_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Š toc afost skroz zadivic š ančiput s slavjaskă p Dimizov. Afost pljin d frikă š rubja: “Astăz noj amvizut nješto če nuje d krizut!” ");
INSERT INTO ronludari_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Isusu dăpă aja aišăt š avizut p cariniku Levi kum šadje la carină, š ja zăs: “Vină dăpă minje.” ");
INSERT INTO ronludari_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Š Levi sa skulat, alăsat tot, š apljikat dăpă jel. ");
INSERT INTO ronludari_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Atunča Levi apriredit d Isusu marje veselije ăn kasa aluj. A ku jej amănkat mulc lumje š ăntră jej irja mulc carinikurj. ");
INSERT INTO ronludari_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Atunča njeki farizeji, š njeki učiteljurj d zakonu alu Mojsije karje irja d grupa alor š prigovorja alu učenikurlje alu Isusuluj ku vorbilje: “Dăče mănkăc š bjec ku carinikurlje š ku lumja karje grešaštje?” ");
INSERT INTO ronludari_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","A Isusu lja zăs: “Alu lumjej zdravănă nu trjebje doktorjamja, već alu lumjej karje bulnavă trjebje doktorjamja. ");
INSERT INTO ronludari_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nam vinjit s kjem p lumja karje găndjaštje k je pravedna, njego amvinjit s kjem p lumja karje grešaštje s s okrinjaskă la Dimizov.” ");
INSERT INTO ronludari_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Njeka lumje ja zăs: “Učenikurlje alu Ivan maj mult vorj postjaštje š s ruagă, aša š učenikurlje alu farizeji, ali alji tjej stalno mălănkă š bja.” ");
INSERT INTO ronludari_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Lja antribat Isusu: “Dali kutizăc svatovi alu mladoženjej s natiric s postjaskă pănd mladoženja ku jej? ");
INSERT INTO ronludari_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ali osă vinje vrijamja kănd osă lji ja p mladoženja š atunča s postjaskă.” ");
INSERT INTO ronludari_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Atunča Isusu nastavit aša če lja spus asta vorbă: “Numilja nu rupje pjatika dăla cuală nuavă s puată s krpjaskă p cuală bătrnă. Akă aja fače, osă rupă cuala nuavă, a pjatika dăla nuavă cuală nu pristajaštje alu cuală bătrnă. ");
INSERT INTO ronludari_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Š numilja nu tuarnă vinu alu nov ăn bătrnă tăšnj d pjalje. Akă aja fače, vinu alu nov osă rupă tăšnjilje š osă varsă, a tăšnjilje osă propanjaskă. ");
INSERT INTO ronludari_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Njego, vinu alu nov trjebje s s tuarnje ăn nuavje tăšnj. ");
INSERT INTO ronludari_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Š numilja činje bja bătărn vin nu vrja vinu dăla nov daja če zăče: ‘Bătărn je maj bun.’” ");
INSERT INTO ronludari_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Una sămbătă Isusu triča pisti pijană d gruv. Učenikurlje aluj rupja gruv, š la trljit ku mănilje š la mănkat. ");
INSERT INTO ronludari_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","A njeki farizeji azăs: “Dăče prekršăc zakonu alu Mojsije ku aja če rupjec gruvu ăn sămbătă?” ");
INSERT INTO ronludari_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Isusu lja odgovorit: “Dali voj nas čitit ăn Svăntă pismă ča fukut David, argatu alu Dimizov, kănd aflămăzăt jel š ălja karje afost ku jel? ");
INSERT INTO ronludari_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Dali na auntrat ăn šator undje Dimizov s poštujaštje, jel amănkat dă mălaju karje posvitit š adat alu ălja karje afost ku jel? Dali nu zăče zakonu alu nostru k mălajusta nu kutjază s mălănčje nimilja činje nuje popă?” ");
INSERT INTO ronludari_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Atunča Isusu lja zăs asta: “Jo, Bijatu alu Omuluj, am autoritet p sămbătă!” ");
INSERT INTO ronludari_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Alta sămbătă Isusu auntrat ăn sinagogă s ănvacă. Afost ănklo om karje na putut s koristjaskă măna dirjaptă. ");
INSERT INTO ronludari_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Učitelji d zakonu alu Mojsije š farizeji avrut s l optužaskă p Isusu k aprekršăt unu zakon alor. Daja pomatrja p Isusu s vjadă dal vrja ăn sămbătă s likujaskă. ");
INSERT INTO ronludari_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","A Isusu aštijut găndjala alor pa zăče alu om karje arje mănă karje nu puatje s koristjaskă: “Skual š stăj aiča la intja alu toc!” Jel sa skulat š astat ănklo. ");
INSERT INTO ronludari_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Atunča Isusu zăče: “S vu ăntrjeb: Dopustjaštje zakonu alu Mojsije s s fakă ăn sămbătă binje, ili rov? S spasaskă životu, ili s l uništjaskă?” ");
INSERT INTO ronludari_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Sa ujtat p toc ăn sinagogă š atunča zăče alu omuluj: “Ătiđje măna!” Jel afukut aša š măna sa likujit. ");
INSERT INTO ronludari_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Atunča farizeji š učitelji d zakon alu Mojsije sa nikăžăt, š ančiput s dogovorjaskă če s fakă păntruv Isusu. ");
INSERT INTO ronludari_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ăn zuviljalja Isusu apljikat p djal s ruađje š provodit nuaptja ku ruguala la Dimizov. ");
INSERT INTO ronludari_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kănd avinjit alta zuva, akimat la jel p učenikurlje š ăntră jej akuljes duavăsprjače (12) d lumje, karje lja odredit d apostolurj. ");
INSERT INTO ronludari_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Afost Šimun, karje Isusu la kimat Petar, Andrija, fratilje alu Petar, Jakov, Ivan, Filip, Bartolomej, ");
INSERT INTO ronludari_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matej, Toma, Jakov, kupilu alu Alfej, Šimun karje avut nadimaku Domoljub, ");
INSERT INTO ronludari_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Juda, kupilu alu Jakov, š Juda Iškariot, karje maj ănklo izdajit p Isusu. ");
INSERT INTO ronludari_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Isusu sa dat ăn zos dăpă djal ku apostoli š astat p ravnică. Ănklo aštiptat mulc alturj učenikurj aluj š mulc narod d trg Jeruzalem š d tot pămăntu alu Židovilor, š d regija pănglă apă undje irja trgurj Tir š Sidon p sjever. ");
INSERT INTO ronludari_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Avinjit toc s puje urjajke la Isusu š s lji likujaskă tuată buala. S likuja š ălja karje lja mučit sufljeti alji rovj. ");
INSERT INTO ronludari_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Tuată lumje la akătat s l dotaknjaskă daja činje l dotaknja snaga ajiša dăn jel š lji likuja. ");
INSERT INTO ronludari_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Atunča Isusu sa ujtat p učenikurj š zăče: “Nurukošj ištjec voj karje ištjec sărač k voj ištjec uključic ăn cara alu Dimizov! ");
INSERT INTO ronludari_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nurukošj ištjec voj karje ištjec flămănž k voj osă fic narinic! Nurukošj ištjec voj karje akuma plănđec k voj osă vu radujic! ");
INSERT INTO ronludari_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Nurukošj ištjec voj kănd lumja vu mrzaštje š kănd p voj isključaštje š vu vridjaštje š vu zăče k ištjec rovj daja če ištjec učenikurlje alji mjej, alu Bijatu alu Omuluj! ");
INSERT INTO ronludari_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Raduicăvă voj ăn zuvaja š săric d radost k istina je nagrada avuastră marje je p čerj, k jej karje vu maltetirjaštje sămănca je alu ălja karje d mult maltetirja p prorokurlje!” ");
INSERT INTO ronludari_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Ali grjev vuavă, lumja karje bugată, k već asprimit utjšala avuastră! ");
INSERT INTO ronludari_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Grjev vuavă karje ištjec narinic, k osă fic flămănž! Grjev vuavă karje akuma vu radujic, k osă tugujic š s plănđec! ");
INSERT INTO ronludari_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Grjev vuavă kănd p voj tuată lumja uhvaljaštje, k jej karje uhvalja p voj sămănca je alu ălja karje uhvalja d mult d prorokurlje alji mičinoš.” ");
INSERT INTO ronludari_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“A jo vu zăk, vuavă karje punjec urjajke: Vrjec p dušmanji alji voštri. Binje fičec alu lumjej karje vu mrzaštje. ");
INSERT INTO ronludari_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Kătăc dăla Dimizov s fakă binje alu ălja karje vu blastămă. Rugăcăvă d ălja karje p voj maltetirjaštje. ");
INSERT INTO ronludari_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Alu ăla karje t luvjaštje p una falkă tinđje š altă, š alu ăla karje c ja ancuku dopustjaštje s c ja š kămaša. ");
INSERT INTO ronludari_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ali dăj alu tot ăla karje dăla tinje kată, a dăla ăla karje dăla tinje fură nu kăta s ăntuarkă. ");
INSERT INTO ronludari_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Fičec alu lumjej isto če vrjec jej vuavă s fakă. ");
INSERT INTO ronludari_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Akă vrjec samo p ălja karje p voj vrja, nu zaslužăc nagradă. Š lumja karje rovj vrja p ălja karje vrja p jej. ");
INSERT INTO ronludari_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Isto aša akă fičec binje samo alu ălja karje fače vuavă binje, nu zaslužăc nagradă. Š lumja karje rovj fače isto aja. ");
INSERT INTO ronludari_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Akă pozajmic samo alu ălja karje puatje s vu ăntuarkă ăndrăt, nu zaslužăc nagradă. Š lumja karje rovj pozajmjaštje alu lumjej karje rovj s s ăntuarkă ăndrăt. ");
INSERT INTO ronludari_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Njego, vrjec isto p dušmani alji voštri. Fičec binje alor š pozajmic alu ălja karje nu puatje s vu ăntuarkă ăndrăt. Akă aja fičec, osă primic marje nagradă š osă fic kašă Maj marje Dimizov karje bun kătri lumje karje nu zahvaljaštje š karje je rovj. ");
INSERT INTO ronludari_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Fic bunj kătri tuată lumje kum Tata alu vostru ăn čerj jaštje bun kătri tuată lumje.” ");
INSERT INTO ronludari_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Nu sudic š nusă fic sudic. Nu optužăc š nusă fic optužăc. Oprostic š osă vu fije oprostit. ");
INSERT INTO ronludari_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Dăc š Dimizov osă vu dja. Jel osă vu tuarnă marje količină ăn puală, ka omu bun karje punjaštje găvanu aluj d gruv aša če nabijaštje š potresaštje gruvu pănd god nu s napunjaštje, š nastavjaštje s dodajaskă još maj mult pănd gruvu nu s prelijaštje. K kum miric alu alcilor, aša Dimizov osă mirjaskă š vuavă.” ");
INSERT INTO ronludari_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Isusu azăs alor š još una vorbă: “Dali puatje vorbu s adukă p vorbu? Nu puatje, k amiždoj osă kadă ăn rupă. ");
INSERT INTO ronludari_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Učeniku nuje maj marje d učitelju aluj. Ali tot učeniku p karje učitelju la ănvăcat tot če štije, osă fije kašă učitelju aluj. ");
INSERT INTO ronludari_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Dăče tujc la aškja ăn vojk alu altuluj, a nu vjez ljemnu ăn vojk alu tov? ");
INSERT INTO ronludari_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Dăče zăč alu altuluj: ‘Omulje, s c skot aškja dăn vojku alu tov’, a săngur ăn vojk nu vjez ljemnu? Ku duavă licje! Skuatje majdată ljemnu dăn vojku alu tov pa atunča osă vjez kum s skoc aškja dăn vojku alu altuluj.” ");
INSERT INTO ronludari_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Ljemnu alu bun nu puatje s rudjaskă plodu karje nuje bun, nič ljemnu karje nuje bun nu puatje s rudjaskă plodu alu bun. ");
INSERT INTO ronludari_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tot ljemnu s kunaštje p plod. Dăn mărčinj nu sa dună smokva nit strugurlje. ");
INSERT INTO ronludari_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Isto aša bun omu rubjaštje bunje vorbje k je inima aluj bună, a omu rov rubjaštje ruavje vorbje k je inima aluj ruavă. Aja če omu rubjaštje arată d karje jel inima arje.” ");
INSERT INTO ronludari_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Če mikimăc, ‘Domnu, Domnu!’, a nu fičec aja če zăk? ");
INSERT INTO ronludari_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ăla karje vinje la minje š auzăt vorbilje alji mjalje š fače aja če zăk ");
INSERT INTO ronludari_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","je kašă omu karje fače kasa š surpa adănkă rupă š postavit temelju p buluvan. A kănd avinja poplava, š kănd apa navalit p kasă, nu puatje s miškă daja če binje făkută. ");
INSERT INTO ronludari_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ali ăla karje auzăt vorbilje alji mjalje š nu fače aja če zăk je kašă omu karje fače kasa p pămănt frzdă temelj. Kănd apa navalit p kasă majdată sa duburăt š irja skroz uništită.” ");
INSERT INTO ronludari_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Dăpă aja če tot azăs alu naroduluj, Isusu apljikat ăn trg Kafarnaum. ");
INSERT INTO ronludari_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ănklo afost njeki kapetan alu rimuluj karje avut argat karje avut d jel milă. Ăla argat afost bulnav p muartje. ");
INSERT INTO ronludari_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kănd kapetanu auzăt d Isusu, atrimjes la jel vođe alu lumjaja karje irja Židovurj ăn trgula s l ruađje s vije š s likujaskă p argatu aluj. ");
INSERT INTO ronludari_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Kănd jej avinjit la Isusu, mult la rugat: “Zaslužăt s ji fač aja ");
INSERT INTO ronludari_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","daja če vrja p narodu alu nostru, frzdă jel noj nam putja s sagradim sinagoga anuastră.” ");
INSERT INTO ronludari_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Isusu apljikat ku jej. Š kănd avinjit la upruapje la kasă, atrimjes kapetanu p ortači la Isusu. Jej azăs: “Kapetanu azăs asta: Domnulje, nu tu mučja. K nu sănt vrjedan s uncăr ăn kasa amja. ");
INSERT INTO ronludari_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nu sănt vrjedan s viuv pănla tinje. Njego samo zi dundje god ješt s s likujaskă argatu alu mjov. ");
INSERT INTO ronludari_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Asta štiuv k š jo mora s askult p kapetanu alu mjov. Am š jo vuastje dusu minje. Š zăk alu unu: ‘Fuđ!’ š jel pljakă. Š alu altuluj zăk: ‘Vină aiča!’ š jel vinje. Š alu argatu alu mjov zăk: ‘Făj aja!’ š jel fače.” ");
INSERT INTO ronludari_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Kănd auzăt aja, sa mirat Isusu š sa okrinit la mulc lumje karje apljikat dăpă jel š zăče: “Istina je, ăn Izrael na găsăt p unu Židov karje krjadje kašă ăsta karje nuje Židov karje aša krjadje.” ");
INSERT INTO ronludari_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Kănd sa tors akas ălja p karje kapetanu atrimjes, angăsăt p argatu likujit. ");
INSERT INTO ronludari_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Dăpă aja Isusu apljikat ăn trg karje s kima Nain. La sljedit učenikurlje aluj š mulc lumje. ");
INSERT INTO ronludari_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Kănd avinjit la upruapje la uša alu trguluj, baš atunča njeka lumje aduče p mort fălkov dăn trg pănla gruapă s l ăngruapă. Fălkovu karje amurit afost jedinac la mamă, karje afost udovică, š mulc lumje dăn trg irja ku ja. ");
INSERT INTO ronludari_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Kănd Domnu Isusu avizuto ja fost žau d ja š ja zăs alu je: “Nu plănđa!” ");
INSERT INTO ronludari_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Avinjit š adotaknit nosiljilje, a lumja karje la dučja astat. Isusu azăs: “Fălkovulje, c zăk, skual!” ");
INSERT INTO ronludari_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Š fălkovu sa drikat š arubit, a Isusu azăs alu mumusăj: “Jakăc kupilu alu tov”. ");
INSERT INTO ronludari_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Toc sa mirat la săla alu Dimizovuluj. L slavja š zăča: “Marje proroku trijaštje ăntră noj! Dimizov avinjit s ažută alu narodu aluj!” ");
INSERT INTO ronludari_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Š toc ăntră Židovj š ăn altje lokurj auzăt aja če Isusu afukut. ");
INSERT INTO ronludari_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Učenikurlje alu Ivan arubit alu Ivan d tot aja če Isusu afukut. Ivan akimat p doj (2) učenikurj aluj ");
INSERT INTO ronludari_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","š lja trimjes la Domnu Isusu s l ăntrjabje: “Ješt tu ăla karje Dimizov aobečit k osă vije ili dal trjebje s štiptăm p altu s vije?” ");
INSERT INTO ronludari_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Kănd jej avinjit la Isusu, azăs lumjaja: “Ivan karje bătjază atrimjes p noj la tinje s t ăntribăm: ‘Ješt tu ăla karje Dimizov aobečit k osă vije ili dal trjebje s štiptăm p altu s vije?’” ");
INSERT INTO ronludari_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Pănd jej afost ănklo, Isusu alikujit p mulc d buală, d patjală š d sufljeti alji rovj. Š alikujit p multă lumje karje vorbj s puatje s vjadă. ");
INSERT INTO ronludari_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Atunča aodgovorit alor: “Fuđic š javic alu Ivan ča vizut š auzăt: vorbi vjadje, lumja karje nu puatje s umblă akuma umblă, lumja karje avut buală p pjalje, akuma je likujic, surdi audje, morcă s skuală, š alu săračilor s rubjaštje Bună vorbă d Dimizov. ");
INSERT INTO ronludari_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Blagoslovit ăla karje nu kadje ăn vjeră dăn minje.” ");
INSERT INTO ronludari_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Kănd apljikat učenikurlje alu Ivan, Isusu ančiput s rubjaskă alu multă lumje d Ivan. Jel azăs: “Aspljikat ăn lok undje nuje nimika. D karje om aspljikat ănklo s vidjec? Dal aspljikat s vidjec p njeko karje kašă trstika karje văntu uljigăna? Nu! Nas pljikat aja s vidjec. ");
INSERT INTO ronludari_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ili aspljikat s vidjec p omu karje măndru ănbrăkat? Nu! K lumja karje aduče măndrje cualje š trijaštje ăn bugacije s nalazaštje ăn palače alu caruluj. ");
INSERT INTO ronludari_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Aspljikat s vidjec p proroku? Da! Jel je maj marje prorok. ");
INSERT INTO ronludari_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ivan je ăla d karje je skris ăn Svăntă pismă: ‘Jakă, trimjet p omu karje duče vorba amja s pljače la intja ata s pripremjaskă drum d tinje.’ ");
INSERT INTO ronludari_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Punjec binje urjajke: d tuată lumje karje ikad atrijit nimilja nuje maj marje d Ivan. A ipak, ăn cara alu Dimizov, ăla karje je maj mik je maj marje d jel.” ");
INSERT INTO ronludari_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Tuată lumja karje apus urjajke la Isusu, čak š carinikurlje, već askultat poruka alu Ivan š p jej jel lja bătizat. Atunča, kănd jej auzăt če Isusu azăs, sa složăt k Dimizov zaista atrimjes p Ivan s kjamje p narodu s s pokajaskă. ");
INSERT INTO ronludari_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Naprotiv, farizeji š učitelji alu zakonu alu Mojsije aodbit planu alu Dimizov d jej daja ča odbit s lji bătjază Ivan. ");
INSERT INTO ronludari_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Isusu azăs: “A ku činje s lji usporidjesk p lumja ăn asta vrijamje? P činje samănă? ");
INSERT INTO ronludari_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Jej je kašă kupi karje šadje la tržnică š unu p alt s strigă: ‘Noj amkăntat vuavă vjasăl kăntič š voj na žukat! Noj amkăntat vuavă tužne kăntič a voj na plăns!’ ");
INSERT INTO ronludari_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","K, avinjit Ivan karje bătjază na mănkat mălaj nič vin na but, a zăčec: ‘Ăn jel je sufljetu alu rov!’ ");
INSERT INTO ronludari_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Jo, Bijatu alu Omuluj, avinjit karje amănkat š ambut, a zăčec: ‘Jakă, omu karje vrja mult s mălănče š s bja mult vin, ortaku alu carinikuluj š ku grešnikurlje!’ ");
INSERT INTO ronludari_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Toc karje prihvatjaštje mudrost alu Dimizov razumjaštje k Dimizov atrimjes š p minje š p Ivan.” ");
INSERT INTO ronludari_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Unu farizej akimat p Isusu s mălănče ku jel. Jel auntrat ăn kasă alu farizej š alat loku la astal s mălănče. ");
INSERT INTO ronludari_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Afost njeka mujarje, kunuskută ăn trgula p grešala alu je. Ja adoznajit k Isusu mălănkă la farizej ăn kasă. Š jakă, mujarja adus skumpă ulje karje miruasă ăn măndru bukal. ");
INSERT INTO ronludari_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Š astat la pičuarje dăpă Isusu. Ančiput s plăngă š lakrmilje kădja p pičuarje. Ku păru lja frikat, š lja surutat š lji uns ku skumpă ulje karje miruasă. ");
INSERT INTO ronludari_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Kănd avizut farizej karje akimat p Isusu, agăndit: “Kănd ăsta om zaista arfi prorok, aštija činje je mujarasta karje l dotaknjaštje, k ja je marje grešnică.” ");
INSERT INTO ronludari_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","P aja Isusu ja zăs: “Šimune, am s c zăk nješto.” A jel azăs: “Učiteljulje, zi!” ");
INSERT INTO ronludari_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","A Isusu azăs: “Doj (2) omurj duguja alu unu om banj. Unu om ja dugujit činč sutje (500) kovanic d arđint, a altu om činzăč (50). ");
INSERT INTO ronludari_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","A kum jej na vut dundje s ăntuarkă, alu amiždoj aoprostit datorija. Atunča karje d jej doj (2) maj mult osă l vrja?” ");
INSERT INTO ronludari_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Šimun azăs: “Găndjesk alu ăla karje maj mult oprostit datorija.” Azăs Isusu: “Binje azăs.” ");
INSERT INTO ronludari_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Atunča Isusu sa okrinit la mujarje š zăče alu Šimun: “Vjez p asta mujarje? Jo auntrat ăn kasă ata, ali tu nu maj dat apă s spăl pičuarilje, a ja aplăns š lakrmilje alu je akăzut p pičuarje a ja lja asplat š ku păru mi lja frikat. ");
INSERT INTO ronludari_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nu maj dučukit ku poljubacu, a ja, d kănd jo amuntrat na prestanit s m surutje pičuarilje. ");
INSERT INTO ronludari_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Tu nu maj uns kapu ku ulja, a ja ku skumpă ulje karje miruasă auns pičuarilje. ");
INSERT INTO ronludari_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Dăče găndješt k ja apokazăt atăta d marje ljubav? C zăk istină: aja je daja če grešala alu je, š akă lja fost multă, afost oprostit. Ăla karje găndjaštje k trjebje aluj ucără s s oprostjaskă, ăla vrja ucără.” ");
INSERT INTO ronludari_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Atunča alu mujarje azăs: “Zaista, grešala ata cam oprostit.” ");
INSERT INTO ronludari_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ălja karje afost ănklo ančiput ăntri jej s rubjaskă: “Činje je ăsta š grešala s oprostjaskă?” ");
INSERT INTO ronludari_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","A jel zăče alu mujarje: “Daja čaj krizut, tu ta spasăt! S c dja Dimizov mir pănd plječ!” ");
INSERT INTO ronludari_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Majdată d aja Isusu pljika p trgurj š p saturj s rubjaskă Bună vorbă d cara alu Dimizov. Afost ku Isusu duavăsprjače (12) apostolurj ");
INSERT INTO ronludari_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","š njeke mujerj karje Isusu lja likujit dăla sufljeti alji rovj š dăla buală. Alja mujerj afost Marija karje afost d trg Magdala, dăn karje Isusu aputirit šaptje (7) sufljeti alji rovj, ");
INSERT INTO ronludari_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ivana, karje afost mujarja alu Kuza karje irja upravitelju ăn palače alu Herod, Suzana š multje altje mujerj. Jalje ku banji alor ažutat alu Isusuluj š alu apostolilor. ");
INSERT INTO ronludari_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kănd pănglă Isusu sa străns mulc lumje dăn tot trgu, atunča Isusu lji rubja asta vorbă: ");
INSERT INTO ronludari_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Una zuvă aišăt omu s posijaskă sămănca ăn polje. Kănd aposijit, njeka sămănca akăzut p drum š lumja umbla p aja š puji lja amănkat. ");
INSERT INTO ronludari_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Njeka sămănca akăzut p pămănt undje jaštje buluvan š tek ča kriskut sa uskat daja če narje apă. ");
INSERT INTO ronludari_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Njeka sămănca akăzut ăntră mărčinj š mărčinjilje akriskut una ku jej š ja sa ugušăt. ");
INSERT INTO ronludari_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","A njeka sămănca akăzut p bun pămănt š krjaštje š rudjaštje d usută (100) d vorj.” Isusu azăs aja, š astrigat: “Toc činje arje urjekj s audă, trjebje s puje urjajke š s razumjaskă!” ");
INSERT INTO ronludari_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Učenikurlje alu Isusuluj la antribat če značaštje asta vorbă. ");
INSERT INTO ronludari_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Isusu azăs: “Dopustit vuavă s razumic tajnilje d cara alu Dimizov. Ali koristjesk aša vorbje kănd jo ănvăc p alcă s ispunjaskă Svănta pismă: ‘S ujtă a nu prepoznajaštje, š s audă, a nu razumjaštje’. ");
INSERT INTO ronludari_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Jakă če značaštje asta vorbă: sămănca je vorba alu Dimizov. ");
INSERT INTO ronludari_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","A sămănca karje akăzut p drum prestavjaštje p ălja karje audje, ali vinje nikuratu š adus vorba alu Dimizov d inima alor aša s nu krjadje š nu s spasaskă. ");
INSERT INTO ronludari_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","A sămănca karje akăzut p buluvan prestavjaštje p ălja karje audje, ku radost primjaštje vorba alu Dimizov, ali narje korjen. Ălja njeka vrijamje krjadje, a kănd vinje iskušjala prestanjaštje s krjadje. ");
INSERT INTO ronludari_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","A sămănca karje akăzut ăn mărčinj prestavjaštje p ăštja karje punje urjajke la vorba alu Dimizov, ali kum vrijamja trjače, p jej lji ugušaštje brigilje, bugucija š tuatje užitkulje alu životuluj, daja jej nu duče plodu kopt. ");
INSERT INTO ronludari_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","A sămănca karje akăzut p bun pămănt prestavjaštje p lumja karje ku bună š ku poštena inimă păzaštje vorba alu Dimizov karje audje, jej pljakă maj dăpartje kănd je grjev, daja jej aduče bun plod.” ");
INSERT INTO ronludari_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Nimilja nu prindje lampa s viljaskă ku posuda ili s uaskundje dusu pat, njego s upuje p postolje aša toc ălja karje untră s puată s vjadă binje. ");
INSERT INTO ronludari_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","K tot čije ăviljit osă fije dăzvăljit š tot čije skuns osă s štije š osă vije p lumină. ");
INSERT INTO ronludari_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Daja punjec binje urjajke k ăla karje păzaštje vorba amja osă razumjaskă mult, a p ălja karje nu păzaštje vorba amja osă s ja š aja če găndjaštje k razumjaštje.” ");
INSERT INTO ronludari_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Atunča muma š fracă alu Isusuluj avinjit s l vjadă, ali na putut s vije la jel k afost mulc lumje. ");
INSERT INTO ronludari_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ajavit alu Isusuluj: “Mumuta š fracă alji tej stă afar š vrja s t vjadă.” ");
INSERT INTO ronludari_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Kănd Isusu auzăt aja, azăs alu lumjej: “Ălja karje punje urjajke š askultă vorba alu Dimizov mije je ka muma š ka frac.” ");
INSERT INTO ronludari_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ăn una zuvă azăs Isusu alu učenikurlje aluj: “Tričem p alta partje la apă.” Jej auntrat ăn čamac š aotplovit. ");
INSERT INTO ronludari_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Pănd plovja, Isusu ančiput s kulčje. Š ančiput s suflje marje vănt. Văntu ančiput s fakă marj valurj karje ančiput s napunjaskă čamacu d apă š jej sa găsăt ăn rov. ");
INSERT INTO ronludari_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Jej avinjit la Isusu š la skulat š ja zăs: “Gospodarulje, Gospodarulje, tonim!” A Isusu sa skulat, azapovidit alu văntuluj š alu valulor alji marj s stja š jej sa smirit š afost tišina. ");
INSERT INTO ronludari_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Atunča Isusu azăs alu učenikurlje aluj: “Dăče nas krizut ăn minje?” A učenikurlje sa spirjat š sa mirat. Azăs unji alu alc: “Činje ăsta s zapovidjaskă čak š alu văntuluj š alu apăj, š punje urjajke la jel?” ");
INSERT INTO ronludari_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Avinjit ăn regija Gerasa, karje je p alta partje d apă d regija Galileja. ");
INSERT INTO ronludari_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Čim Isusu aišăt d čamac p obală, avinjit la intja alu Isusuluj njeki om dăn trg karje avut sufljeti alji rovj ăn jel. Već d mult kum nu sa brkat nič atrijit ăn kasă njego irja la mărmănc. ");
INSERT INTO ronludari_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Multă vrijamje sufljeti alji rovj l cănja š akă lumja la ljigat p lanacurj š okove š l păza, jel rupja lanacu š sufljeti alji rovj l natirja s pljače ăn lok undje nuje nimika. Kănd omula avizut p Isusu, acăpat. Isusu azapovidit alu sufljeti alji rovj s jašă d omula. Akăzut la intja alu Isusuluj š astrigat: “Če vrjaj dăla minje, Isusulje, Bijatu alu Maj marje Dimizov? Mărog d tinje, nu m mučja!” ");
INSERT INTO ronludari_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Isusu la tribat: “Kum t kjem?” Jel zăče: “Mulc”, k afost ăn jel mulc sufljeti alji rovj. ");
INSERT INTO ronludari_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Š sufljeti alji rovj ančiput mult s s ruađje d Isusu s nu naridjaskă s pljače ăn jamă frzdă kraj undje osă fije kaznic. ");
INSERT INTO ronludari_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","A ănklo p djal mult porč s ranja. Sufljeti alji rovj sa rugat d Isusu s dopustjaskă s untră ăn porč š Isusu adopustit. ");
INSERT INTO ronludari_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Atunča sufljeti alji rovj aišăt d om š auntrat ăn porč. Toc porči adat fuga ăn zos dăpă djal ăn apă š sa nikat. ");
INSERT INTO ronludari_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Kănd lumja karje păza p porči avizut ča fost, afuđit š arazglasăt p trg š p saturj. ");
INSERT INTO ronludari_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","A lumja avinjit s vjadje ča fost. Kănd jej ažuns, avizut p Isusu ku omu dăn karje aišăt sufljeti alji rovj. Avizut p omu karje šadje š punja urjajke la Isusu, ănbrkat š bun ăn kap. Š lumja sa spirjat. ");
INSERT INTO ronludari_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Jej karje avizut ča fost, arubit alu lumjaja kum Isusu likujit p omu ăn karje afost sufljeti alji rovj. ");
INSERT INTO ronludari_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tuată lumja d regija Gerasa lja pukat marje frikă, š arugat p Isusu s pljače dăla jej. Isusu auntrat ăn čamac s pljače pisti apă ăndrăt. ");
INSERT INTO ronludari_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Majdată njego če Isusu š učenikurlje aluj aotplovit ăn čamac, omu d karje sufljeti alji rovj aišăt sa rugat mult d Isusu s puată s rămăje ku jel. Ali Isusu ja zăs: ");
INSERT INTO ronludari_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ăntuarčitje akas š zi alu toc če Dimizov afukut d tinje.” Atunča jel apljikat š razglasăt p tot trgu če ja fukut Isusu. ");
INSERT INTO ronludari_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Multă lumje aštipta p Isusu s s ăntuarkă dăpă alta partje d apă. Kănd Isusu ažuns, toc ku radostu la štiptat. ");
INSERT INTO ronludari_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","D dăturdată avinjit omu karje sa kima Jair, karje irja vođa alu lumje karje s sastaja ăn sinagogă. Akăzut la intja alu Isusuluj š mult sa rugat s vije ăn kasa aluj. ");
INSERT INTO ronludari_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Jel avut jedinică fată karje avut duavăsprjače (12) d aj karje irja p muartje. Pănd Isusu pljika la Jair, mulc lumja l pinđja dăpă pistot. ");
INSERT INTO ronludari_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ăntră lumje irja mujerj karje duavăsprjače (12) d aj krvarja, š potrošăt tot ča vut p doktorjamje, ali nimilja na putut s ju likujaskă. ");
INSERT INTO ronludari_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Avinjit d drăt š apus măna p rubu alu cuala alu Isusuluj š odma aprestanit s krvarjaskă. ");
INSERT INTO ronludari_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Antribat Isusu: “Činje apus măna p minje?” Š pănd toc azăs: “Nu jo”, Petar azăs: “Gospodarulje, multă lumje t pinđje š t strănđe!” ");
INSERT INTO ronludari_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","A Isusu azăs: “Njeko namjerno apus măna p minje. Amositit k săla aišăt d minje.” ");
INSERT INTO ronludari_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Kănd mujaraja saznajit k nu puatje s askundă k ja apus măna p Isusu, atrimurat d frikă š akăzut la intja alu Isusuluj š la intja alu tot narodu š lja zăs dăče apus măna p Isusu š kum odma sa likujit. ");
INSERT INTO ronludari_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","A Isusu alu je azăs: “Fata amja, tu ta likujit daja ča krizut. S c dja Dimizov mir pănd plječ!” ");
INSERT INTO ronludari_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Kănd Isusu još arubit alu mujaraja, avinjit njeko d kasă alu Jair ku poruka: “Camurit fata. Nu maj muča učitelju više.” ");
INSERT INTO ronludari_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Auzăt Isusu š azăs alu Jair: “Na vja frikă! Samo krjadje š ja osă fije binje!” ");
INSERT INTO ronludari_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Kănd Isusu avinjit ăn kasă alu Jair, Isusu adopustit samo alu Petar, alu Ivan, š alu Jakov, š alu tatăj š alu mamăj alu fataja s utrje ku jel. ");
INSERT INTO ronludari_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Š toc karje već irja ăn kasă plănđja š tuguja dăpă ja. Isusu lja zăs: “Nu plănđec! Nuje muartă, njego s kulkă!” ");
INSERT INTO ronludari_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Atunča toc ančiput s s ljađe d jel daja ča štijut k je muartă. ");
INSERT INTO ronludari_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Isusu alato d mănă š astrigat: “Kupilulje, skual!” ");
INSERT INTO ronludari_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Š sufljetu sa tors š odma sa skulat. Isusu azăs s ji dja s mălănče. ");
INSERT INTO ronludari_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Roditelji alu je irja začudic, a Isusu ja naredit s nu zăkă alu nimilja če sa dogodit. ");
INSERT INTO ronludari_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Isusu akimat la jel p duavăsprjače (12) apostolurj š lja dat săla š autoritet s putirjaskă p sufljeti alji rovj š s puată s likujaskă p bulnavi. ");
INSERT INTO ronludari_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Lja trimjes s rubjaskă Bună vorbă d cara alu Dimizov š s likujaskă p bulnavi. ");
INSERT INTO ronludari_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Isusu lja zăs: “Nimika nu lăc ku voj p drum: nič băcu, nič tašna, nič mălaju, nič banji, nič altje kămăšj! ");
INSERT INTO ronludari_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ăn tuată kasa ăn karje untrăc s prenočic ănklo, răminjec ăn ja pănd god nu pljikăc ăn altu trg. ");
INSERT INTO ronludari_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Undje p voj nu vu primjaštje, pănd išăc d trgula istrisăc prašăna dăpă pičuarje s lji upozoric p kazna alu Dimizov.” ");
INSERT INTO ronludari_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Učenikurlje apljikat š umbla p saturj. Rubja Bună vorbă d Dimizov š likuja p lumja pistot. ");
INSERT INTO ronludari_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herod, karje irja vladaru d regija Galileja, auzăt tot če sa dogodit š afost zbunjen daja če njeka lumje rubja: “Isusu je Ivan karje bătjază. Sa skulat dăla morc.” ");
INSERT INTO ronludari_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Altu rubja: “Isusu je Ilija karje trjebje s vije.” Aldă trje (3) azăs: “Isusu je unu d prorokurj karje majdată atrijit. Sa tors dăla morc.” ");
INSERT INTO ronludari_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","A Herod azăs: “Jo amzăs s taje kapu alu Ivan karje bătjază š nu puatje s fije k jel je mort. Činje atunča omusta d karje atăta aud?” Aša akătat prilikă s vjadă p Isusu. ");
INSERT INTO ronludari_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Kănd apostoli sa tors ăndrăt undje irja Isusu, jej arubit aluj tot ča fukut. Atunča Isusu lja dus ku jel š apljikat s fije săngur upruapje d trg karje sa kimat Betsaida. ");
INSERT INTO ronludari_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Mulc lumje asaznajit aja š apljikat dăpă Isusu. Isusu lja primit š rubja Bună vorbă d cara alu Dimizov š likuja p toc karje trjebje s likujaskă. ");
INSERT INTO ronludari_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Pănd akăzut nuaptja, avinjit duavăsprjače (12) apostolurj la Isusu š ja zăs: “Las p lumja s pljače p saturj š p okolică s găsaskă mănkarje š undje s s kulčje daja če ištjem aiča undje nuje nimika.” ");
INSERT INTO ronludari_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","A Isusu zăče: “Voj lji nahranic.” A jej zăče: “Avjem samo činč (5) mălajur š doj (2) pještj. Dali s pljikăm š s kumprăm mănkarje d tot narodu?” ");
INSERT INTO ronludari_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","A lja fost njeđe činč mij (5.000) d vujniči. Isusu p aja azăs alu učenikurj aluj: “Zăčec alu lumjej s šagă ăn grupje njeđe činzăč (50).” ");
INSERT INTO ronludari_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Š učenikurlje afukut aša š lumja ašăžut. ");
INSERT INTO ronludari_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Isusu alat činč (5) mălajurj š doj (2) pještj, sa ujtat ăn čerj, š azahvaljit alu Dimizov d mănkarje š arupt mălaju š adat mălaju š pjaštje la učenikurj s podiljaskă alu lumjej. ");
INSERT INTO ronludari_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Toc avut s mălănče kăt god aputut. Š još duavăsprjače (12) d korpje sa nakupit d ostatkurj d mălaj š d pještj. ");
INSERT INTO ronludari_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Maj ănklo, Isusu apljikat dăpartje dăla lumje s s ruađje š učenikurlje aluj apljikat ku jel. Kănd Isusu aprestanit s s ruađje lja tribat: “Če rubjaštje lumja činje sănt jo?” ");
INSERT INTO ronludari_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Jej aodgovorit: “Mulc inš zăče k ješt Ivan karje bătjază, alcă zăče k ješt Ilija, š alcă njeki zăče jar k ješt unu d prorokurj karje majdată atrijit š sa tors dăla morc.” ");
INSERT INTO ronludari_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","A atunča Isusu azăs alu učenikurlje aluj: “A voj, če zăčec činje sănt jo?” Petar zăče: “Tu ješt Kristu, spasitelju karje Dimizov atrimjes!” ");
INSERT INTO ronludari_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","A Isusu lja zapovjedit s nu zăkă alu nimilja. ");
INSERT INTO ronludari_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Azăs: “Jo, Bijatu alu Omuluj, mora mult s patjesk. Vođilje alu židovilor, glavni popurlje, š učitelji d zakonu alu Mojsije mora s m odbacaskă. Mora s m umuară š aldă trje (3) zălje jo mora s fiuv adrikat dăla morc.” ");
INSERT INTO ronludari_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Atunča Isusu azăs alu lumjej: “Akă njeko vrja s fije učeniku alu mjov mora s s odriknjaskă săngur d jel, š tuată zuva s ja kruča aluj š s sljedjaskă p minje. ");
INSERT INTO ronludari_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","K činje god vrja životu aluj s spasaskă, osă l pjargă; a činje god izgubjaštje životu aluj d minje, osă l spasaskă. ");
INSERT INTO ronludari_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Če koristjaštje alu omuluj akă dobidjaštje tot pămăntu, ali pjardje săngur p jel? ");
INSERT INTO ronludari_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Činje god arje rušunje d minje š d vorbilje alji mjalje, jo, Bijatu alu Omuluj, isto aša š d jel osă am rušunje kănd jo vinja ku slava amja š ku slava alu Tatimjov š ku slava alu anđelilor alu svănt. ");
INSERT INTO ronludari_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Punjec urjajke k istina je: njeki dăla voj karje aiča stăc nusă muară pănd nu vjadje cara alu Dimizov.” ");
INSERT INTO ronludari_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Otprilike opt (8) zălje dăpă aja če lja zăs aja, adus Isusu ku jel p Petar, p Ivan š p Jakov š apljikat p djal s s ruađje. ");
INSERT INTO ronludari_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Š pănd Isusu s ruga, lica aluj sa promjenit, a cualjilje ja sjajit čisto albă. ");
INSERT INTO ronludari_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Dăturdată, doj (2) omurj sa pojavit š arubit ku Isusu. Ălja afost Mojsije š proroku Ilija. ");
INSERT INTO ronludari_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Sa pojavit ăn marje sjaj š arubit ku Isusu d išjala aluj d pămăntusta, karje Isusu uskoro osă fakă ăn Jeruzalem s ispunjaskă voja alu Dimizov. ");
INSERT INTO ronludari_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pănd Isusu s ruga, Petar š jej karje afost ku jel lja pukat somnu. Kănd sa skulat, avizut marje lumină karje vinje dăla Isusu š doj (2) omurj karje astat pănglă jel. ");
INSERT INTO ronludari_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Pănd Mojsije š Ilija sa sprimit s pljače dăla Isusu, Petar azăs alu Isusuluj, ali nič jel na štijut če rubjaštje: “Gospodarulje, binje je če ištjem aiča ku voj. Fičem trje (3) kolibje: una cije, una alu Mojsije, š una alu Ilije.” ");
INSERT INTO ronludari_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pănd Petar aja arubit, sa pojavit oblaku, lja prekrijit š alor irja frikă. ");
INSERT INTO ronludari_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Dimizov lja rubit dăn oblak: “Ăsta je Bijatu alu mjov karje jo lam kuljes s fije caru! P jel skultac!” ");
INSERT INTO ronludari_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Š kănd jej auzăt glasu, avizut samo p Isusu. Jej atikut ăn zuviljalja š alu nimilja na rubit d aja če jej avizut. ");
INSERT INTO ronludari_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kănd alta zuvă sa dat ăn zos dăpă djal, multje lumje karje irja ačija avinjit la Isusu. ");
INSERT INTO ronludari_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Dăturdată, njeki om ăntră multje lumje astrigat š sa rugat mult d jel: “Učiteljulje, ujtitje la bijatu alu mjov, k jel je jedini kupil alu mjov. ");
INSERT INTO ronludari_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Jakă, sufljet alu rov mult vorj l pukă š dăturdată jel ănčapje s căpje. La runkă ăn grčurj š ji pljika pjena p gură. Š nu l lasă pănă god skroz nu l iscrpijaštje. ");
INSERT INTO ronludari_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ma rugat d učenikurlje alji tjalje s l putirjaskă, ali na putut.” ");
INSERT INTO ronludari_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Atunča Isusu azăs: “Lumjo karje trijic ăn vrijamjasta, voj nu kridjec š ištjec strikac! Jo amfost ku voj atăta d mult š jar nu kridjec. M trjeb kăt mora s trpjesk p voj? Duj aiča p bijatu alu tov!” ");
INSERT INTO ronludari_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Š pănd bijatu avinjit la Isusu, sufljetu alu rov la duburăt š jel ančiput s s grčaskă. A Isusu alu sufljetuluj alu rov azapovjedit s jašă š alikujit p bijatu š la dat la tatusov. ");
INSERT INTO ronludari_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Toc karje irja ačija sa mirat d moć alu Dimizov. Pănd toc sa mirat la asta š la tot če Isusu fače, jel azăs alu učenikurlje aluj: ");
INSERT INTO ronludari_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Punjec binje urjajke če vu zăk: Još ucără lumja osă predajaskă p minje, p Bijatu alu Omuluj, ăn vlastu la dušmanji alji mjej.” ");
INSERT INTO ronludari_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ali jej na štijut če jel avrut s zăkă. Aja značală afost skuns dăla jej. Jej na putut s razumjaskă š lja fost frikă s l ăntrjabje d aja. ");
INSERT INTO ronludari_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Učenikurlje ančiput s raspravljaskă činje dăla jej maj marje. ");
INSERT INTO ronludari_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Aštijut d čaja raspravljaštje Isusu daja alat p kupilu, š la pus pănglă jel. ");
INSERT INTO ronludari_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Š Isusu lja zăs: “Činje ku drag primjaštje p kupilusta păntruv minje, primjaštje š p minje. A činje p minje primjaštje, primjaštje š p Dimizov karje ma trimjes. Istina je: činje je maj mik ăntră voj toc, ăla je maj marje!” ");
INSERT INTO ronludari_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ivan p asta azăs alu Isusuluj: “Gospodarulje, noj avizut p njeko karje ăn lumilje alu tov zapovidjaštje alu sufljeti alji rovj s jašă d lumje. Noj amzăs aluj s nu fakă aja daja če nuje učeniku alu tov kašă če ištjem noj.” ");
INSERT INTO ronludari_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Isusu azăs: “Nu branic! Akă njeko nu lukrjază păntruv voj, jel atunča lukrjază ku voj!” ");
INSERT INTO ronludari_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kănd s približa vrijamja s ja Dimizov p Isusu ăn čerj, Isusu aodlučit k avinjit vrijamja s pljače ăn Jeruzalem, ");
INSERT INTO ronludari_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","š atunča atrimjes p glasnici la intja aluj. Glasnici apljikat š auntrat ăn sat ăn regija Samarija s ji pripremjaskă če ji trjebje. ");
INSERT INTO ronludari_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","A ănklo lumja na vurut s l primjaskă daja če pljika ăn Jeruzalem. ");
INSERT INTO ronludari_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kănd učenikurlje Jakov š Ivan auzăt k lumja ăn Samarija na primit p Isusu, jej azăs: “Domnulje, vrjaj s zapovidim s lja pringă foku dăn čerj?” ");
INSERT INTO ronludari_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","A Isusu sa okrinit š lja ukorit p Jakov š p Ivan s nu fakă aja. ");
INSERT INTO ronludari_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Atunča Isusu š učenikurlje aluj apljikat ăn altu sat. ");
INSERT INTO ronludari_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Pănd jej još pljika p drum, njeko azăs alu Isusuluj: “Pljek dăpă tinje undje god tu plječ.” ");
INSERT INTO ronludari_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Isusu ja zăs: “Lisica arje jamă š puji arje kujb, a jo, Bijatu alu Omuluj, nam lok alu mjov d kulkat.” ");
INSERT INTO ronludari_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Atunča Isusu azăs alu altuluj: “Vină dăpă minje!” A jel azăs: “Domnulje, lasămă majdată s pljek s ăngrop p tatimjov.” ");
INSERT INTO ronludari_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Isusu ja zăs: “Las p morcă s gruapje p alor morcă, a tu fuđ š rubjaštje alu alcilor Bună vorbă d cara alu Dimizov.” ");
INSERT INTO ronludari_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Š još njeko zăče: “Domnulje, viuv dăpă tinje, ali dopustjaštjem majdată s m oprostijesk ku ukućanji mjej.” ");
INSERT INTO ronludari_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Isusu ja zăs: “Akă ănčepj s orještj ravno, a t ujc dăpă tinje, tu nu poc s služăštj ăn cara alu Dimizov.” ");
INSERT INTO ronludari_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Domnu Isusu dăpă aja akuljes ăntră jej šaptjezăč š doj (72) alcă učenikurj š atrimjes kătă doj (2) s pljače la intja aluj ăn tot trgu š ăn tot loku undje Isusu atribut s pljače. ");
INSERT INTO ronludari_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kănd sa sprimit s pljače lja zăs: “Berba je marje, ali radnič jaštje uncără. Berba pripadnjaštje alu Domnuluj, daja rugăcăvă la jel s trimjată još maj mult radnič ăn berbă. ");
INSERT INTO ronludari_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ănčipjec akuma, ali păzăcăvă k trimjet p voj kašă p vojilje ăntră lumje karje kašă lupurj. ");
INSERT INTO ronludari_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nu dučec ku voj nič banj, nič tašna, nič altje sandalje. Nu stăc p drum ku lumja s nu pridjec vrijamja. ");
INSERT INTO ronludari_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ăn tuată kasa ăn karje untrăc s prenočic ănklo, majdată zăčec: ‘S dja Dimizov miru alu toc ăn asta kasă!’ ");
INSERT INTO ronludari_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Akă ăn aja kasă jaštje omu karje vrja miru ku Dimizov, jel osă ajbje miru ku karje voj la blagoslovit. Akă ănklo nuje om karje vrja miru ku Dimizov, jel nusă primjaskă ăla miru ku karje voj la blagoslovit. ");
INSERT INTO ronludari_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nu vu preselic d kasă ăn kasă! Boravic ăn aja kasă pănd fic ăn trgula š nu fic rušănošj s mănkăc š s bjec aja če vu dă, k kum zăčem: Radniku azaslužăt plata aluj. ");
INSERT INTO ronludari_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ali ăn tot trgu ăn karje untrăc š ănklo vu primjaštje fic zadovoljni ku aja če god vu dă s mănkăc. ");
INSERT INTO ronludari_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Likujic ănklo p lumja karje bulnavj š zăčec alor: ‘Asta arată k cara alu Dimizov avinjit la voj!’ ");
INSERT INTO ronludari_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ali ăn tot trgu ăn karje untrăc š ănklo nu vu primjaštje, išăc la ulicilje aluj š zăčec: ");
INSERT INTO ronludari_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Čak frikăm š prašăna d trgu alu vostru karje sa ljipit p pičuarje alu anuaštrje s vu upozorim p kazna alu Dimizov! Ali štijec k avinjit cara alu Dimizov!’ ");
INSERT INTO ronludari_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Vu zăk: Kănd vinja vrijamja d sud osă fije majušurje alu lumjej ruavă dăn trg Sodoma njego alu lumjej dăn trgula!” ");
INSERT INTO ronludari_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Isusu azăs: “Grjev vuavă, lumjo ăn trg Korozain! Grjev vuavă, lumjo ăn trg Betsaida! Akă njeko afukut čudurj ăntră lumje pogană ăn trg Tir š ăn trg Sidon karje jo afukut ăntră voj, jej već d kănd s okrinja dăla rov. Adučja cualje hrapave š šidja ăn činušă s pokazaskă žalostu. ");
INSERT INTO ronludari_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Daja osă fije majušurje ăn zuvă d sud alu lumje ăn Tir š ăn Sidon njego vuavă ăn Korozain š Betsaida! ");
INSERT INTO ronludari_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","A voj, lumjo ăn trg Kafarnaum, voj sigurno nusă vu drikăc pănla čerj samo daja če jo amfost ăntră voj! Nu! Voj osă vu slubudjec ănklo undje loku d kaznit.” ");
INSERT INTO ronludari_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Atunča azăs alu šaptjezăč š doj (72) učenikurj: “Kănd njeko punje urjajke la voj, aja je kašă kum punje urjajke la minje. Š kănd odbacaštje p voj aja je kašă kum odbacaštje p minje. A kănd njeko odbacaštje p minje aja je kašă kum odbacaštje p Dimizov karje ma trimjes.” ");
INSERT INTO ronludari_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Kănd sa tors šaptjezăč š doj (72) d učenikurj la Isusu, ku drag azăs: “Domnulje, čak š sufljeti alji rovj askultă kănd lji zapovidim ăn lumje alu tov.” ");
INSERT INTO ronludari_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","A Isusu lja zăs: “Štiuv, k amvizut p Sotona kum akăzut d čerj ka sklipjala. ");
INSERT INTO ronludari_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Vidjec, jo amdat vuavă tuată săla š autoritetu p Sotona, dušmanu alu Dimizov, s gazăc šărpj š škorpionurj. Nimika vuavă nu puatje s naudjaskă. ");
INSERT INTO ronludari_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ali nu vu radujic samo daja če p voj sufljeti alji rovj askultă, njego maj mult radujicăvă daja če Dimizov askris lumilje alji voštri p popis ăn čerj.” ");
INSERT INTO ronludari_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Atunča Sufljetu alu Svăntuluj aispunit p Isusu ku radostu š Isusu azăs alu Dimizov: “T slavjesk, Tato, tu karje vladješt ku čerju š ku pămăntu, čaj skuns istina d cara ata dăla lumje karje găndjaštje k je mudri š mintošj š če pokazăštj aja alu lumje karje kašă kupi karje vrjaj s ănvacă. Da, Tato, cije s sviđaštje s fač aja aša.” ");
INSERT INTO ronludari_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Atunča Isusu azăs: “Tata alu mjov ma dat tot če jel arje. Samo Tata binje kunuaštje činje sănt jo, Bijatu aluj, š samo jo, Bijatu aluj, š ălja alu činje jo odlučjesk s l otkrijesk, binje kunuaštje činje je Tata.” ");
INSERT INTO ronludari_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Maj ănklo, kănd afost săngur ku učenikurlje aluj, š ja azăs: “Nurukošj ălja karje vjadje aja če vidjec voj. ");
INSERT INTO ronludari_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","K istina je, mulc prorokurj š carurj avrut s vjadă aja če voj vidjec, ali na vizut; avrut s audă aja če voj audjec, ali na uzăt.” ");
INSERT INTO ronludari_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Udată kănd Isusu ănvăca, njeki učitelj alu zakonu alu Mojsije sa skulat š antribat p Isusu s l iskušaskă: “Učiteljulje, če trjebje s fak s primjesk vječni život ku Dimizov?” ");
INSERT INTO ronludari_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","A Isusu ja zăs: “Če skrije ăn zakonu alu Mojsije? Če tu razumještj če zăče?” ");
INSERT INTO ronludari_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Omu azăs: “Zakonu zăče: ‘Vrja p Domnu, Dimizov alu tov, ku tuată inima ata š ku tot sufljetu alu tov š ku tuată snaga ata š ku tuatje mincilje alji tjalje’ š ‘vrja p bližnji alu tov kum vrjaj săngur p tinje.’” ");
INSERT INTO ronludari_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Isusu ja zăs: “Binje ajzăs. Făj aša š osă primješt vječni život.” ");
INSERT INTO ronludari_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ali omu avrut s s spalje, š aša jel ăntrijabă p Isusu: “D činje rubjaštje kănd zakonu zăče ‘bližnji alu mjov’?” ");
INSERT INTO ronludari_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Isusu aodgovorit ku asta vorbă: “Njeki om putuja dăn Jeruzalem ăn trg Jerihon š la napadnit fărăčoši š alat tot dăpă jel, la butut š apljikat. Š p omula alăsat s zakă skoro mort. ");
INSERT INTO ronludari_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Trjače p drumula slučajno popa alu židovilor. Kănd avizut p omu karje skoro mort, la zaobiđit š apljikat maj dăpartje. ");
INSERT INTO ronludari_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Isto aša pănglă lokula avinjit atunča š levitu, pomoćniku ăn Hram. Kănd la vizut, š jel la zaobiđit š apljikat maj dăpartje. ");
INSERT INTO ronludari_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Atunča njeki omu d regija Samarija trjače p drumula. Kănd avizut p omula, ja fost žau d jel. ");
INSERT INTO ronludari_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Avinjit la upruapje d jel, ja spălat răžnilje ku ulje š ku vinu š ja ănvilijat ku trijanca. La drikat atunča p magarac aluj š la dus ăn gostijonă š ănklo anastavit s s pobrinjaskă d jel. ");
INSERT INTO ronludari_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Mănje zuvă jel adat duavă (2) kovanic d arđint alu gazdăj alu gostijonăj, š ja zăs: ‘Brinjaštitje d jel š akă maj mult putrošăštj, c plătjesk kănd m ănturča.’” ");
INSERT INTO ronludari_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","A Isusu antribat p učitelju d zakon alu Mojsije: “Če găndješt? Karje d ăštja trje (3) alu omuluj sa pokazăt k je bližnji alu omula karje la napadnit fărăčoši?” ");
INSERT INTO ronludari_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Azăs učitelju d zakon alu Mojsije: “Ăla karje ja pokazăt milă.” Isusu ja azăs: “Binje ajzăs. Fuđ š făj kum š jel afukut.” ");
INSERT INTO ronludari_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Pănd Isusu š učenikurlje aluj nastavja s putujaskă kătri Jeruzalem, auntrat ăn unu sat. Ačija afost njeka mujarje karje s kima Marta. La primit ăn kasa alu je. ");
INSERT INTO ronludari_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Avut soră karje s kima Marija. Pănd Domnu Isusu ănvăca, Marija šidja š punja urjajke. ");
INSERT INTO ronludari_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","A Marta afost mult zabrinută k mora s pripremjaskă tuată mănkarja, pa ja avinjit s s žaljaskă: “Domnulje, nu c brigă če sorimja ma lăsat săngură s lukrjez tot lukru? Zi alu je s m ažutje!” ");
INSERT INTO ronludari_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ali Domnu Isusu ja zăs: “Draga Marta! Nu trjebje s t brinještj š t uznemirještj d aja če găndješt k trjebje. ");
INSERT INTO ronludari_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","A una stvar karje trjebje s puj urjajke la vorba amja. Marija aja ashvatit, š aja nusă fije lat dăla ja.” ");
INSERT INTO ronludari_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Udată Isusu sa rugat la njeki lok. Kănd azavršăt ku rugala, avinjit la jel unu d učenikurj š azăs: “Domnulje, ănvacă p noj s nji rugăm kum Ivan karje bătjază anvăcat p učenikurlje aluj.” ");
INSERT INTO ronludari_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Isusu lja zăs: “Kănd rugăc, zăčec: ‘Tato ăn čerj, s s štujaskă lumilje alu tov asvănt. Aduj cara ata p tot pămăntu. ");
INSERT INTO ronludari_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Adă nuavă mănkarje karje trjebje tuată zuva ");
INSERT INTO ronludari_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","š oprostjaštje anuastră grešala, k š noj oprostim alu ălja karje grešaštje păntruv noj. Nu da s kidjem ăn kušnje.’” ");
INSERT INTO ronludari_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Atunča Isusu azăs alu učenikurlje aluj: “Akă plječ ăn ponoć la ortaku alu tov š ji zăč: ‘Adăm trje (3) mălajurj, ");
INSERT INTO ronludari_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","k ma vinjit ortaku ăn gostjamje, a nam s idauv nimik d mănkat!’, če osă zăkă ortaku? ");
INSERT INTO ronludari_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Dali nusă zăkă: ‘Nu m uznemirja! Uša je već ăn kisă, a kupi je ăn pat k nu pot akuma s m skol s c dau!’ ");
INSERT INTO ronludari_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ali vu zăk: čak š akă omula nu s skuală daja če ješt ortak aluj, š nu c dă nimika, osă skuală daja če mult l rođ frzdă rušănje. Š osă zdja atăta kăt cije trjebje. ");
INSERT INTO ronludari_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Š daja vu zăk: Nu odustanic! Rugăc p Dimizov š osă dobidic! Kătăc š osă găsăc! Bitjec la ušă š osă s vu dăškidje! ");
INSERT INTO ronludari_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Činje god ruagă p Dimizov, primjaštje. Činje god kată, găsaštje. Činje god batje, uša s ji dăškidje. ");
INSERT INTO ronludari_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Voj karje ištjec tatje, če afiča voj kănd bijatu alu vostru kată pjaštje? Dal voj ja da šarpje? Nu! ");
INSERT INTO ronludari_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ili akă bijatu alu vostru kată vov dăla voj, dal voj ja da škorpijon? Nu! ");
INSERT INTO ronludari_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Akă voj, karje ištjec rovj, štijec s dăc alu kupi alu voštri bunje darurj, atunča kăt maj mult alu vostru Tata ăn čerj osă darujaskă p Sufljetu alu Svăntuluj alu ălja karje l ruagă?” ");
INSERT INTO ronludari_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Isusu una zuvă aputirit p sufljetu alu rov karje nu ja dat alu omuluj s rubjaskă. Kănd sufljetu alu rov aišăt, omu arubit š mulc lumje sa mirat. ");
INSERT INTO ronludari_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ali njeki dăla jej azăs: “Jel putirjaštje sufljeti alji rovj daja če ji žută Beelzebul, karje je vladaru alu toc sufljeti alji rovj.” ");
INSERT INTO ronludari_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","A alci avrut s la puče ăn zamkă š akătat s idja njeki znak kašă dokazu k Dimizov la trimjes. ");
INSERT INTO ronludari_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","A Isusu aštijut če găndjaštje, pa lja zăs: “Akă lumja ăn ista cară s burjaštje ăntră jej, osă propanjaskă cara alor. Akă familija ăn ista kasă s burjaštje ăntră jej, osă s raspadnjaskă familija alor. ");
INSERT INTO ronludari_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Voj zăčec k jo ku săla alu Beelzebul putirjesk p sufljeti alji rovj. Aja atunča značaštje k š ălja karje je ăn cara alu Sotonăj s burjaštje ăntră jej. Kum atunča cara aluj s rămăje? ");
INSERT INTO ronludari_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","A čije ku učenikurlje alji voštri karje putirjaštje p sufljeti alji rovj? Akă, kašă kum zăčec, jo putirjesk p sufljeti alji rovj ku săla alu Beelzebul, atunča mora aja s fakă š učenikurlje alji voštri ku săla alu Beelzebul. Sigurno nusă slažaštje. Učenikurlje alji voštri osă zăkă k Beelzebul nu s burjaštje săngur păntruv jel. ");
INSERT INTO ronludari_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ali daja če jo p sufljeti alji rovj putirjesk ku săla alu Dimizov, atunča aja arată k la voj avinjit cara alu Dimizov. ");
INSERT INTO ronludari_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Kănd capăn omu karje arje bună oružije păzaštje palača aluj, tot če arje je sigurno. ");
INSERT INTO ronludari_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ali kănd l napadnjaštje maj capăn d jel, l savladjaštje š ija tuată oružija ăn karje sa uzdit dušmanu aluj. Alat tot če omula avut š apodiljit ku lumja aluj. ");
INSERT INTO ronludari_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ăla karje nuje ăn partja amja, jel je păntruv minje; ăla karje ku minje nu strănđe vojilje, jel lji putirjaštje.” ");
INSERT INTO ronludari_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Atunča Isusu azăs asta vorbă: “Kănd sufljetu alu rov jašă d om, lutjaštje p pustinje š kată lok s odmorijaskă. Kănd nu l găsaštje, azăs săngur aluj: ‘M tork ăn om ăn karje maj dată atrijit dăn karje aišăt.’ ");
INSERT INTO ronludari_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Kănd sa tors, găsaštje k je omula kašă kasa karje je čistită š uredna, ali guală. ");
INSERT INTO ronludari_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Atunča sa dus s adukă p alcă šaptje (7) sufljeti alji rovj još maj rov d jel, š toc untră ăn om š ăn jel trijaštje. Š na kraju postanjaštje alu omuluj maj rov njego če irja maj dată njego ča pljikat sufljetu alu rov.” ");
INSERT INTO ronludari_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Pănd Isusu rubja d aštja stvarurj, njeka mujarje d multă lumje astrigat: “Kum je binje alu mujarje karje ta dus š ca dat s suđ p tjeptu alu je!” ");
INSERT INTO ronludari_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Isusu azăs: “Još je maj binje alor karje audje vorba alu Dimizov š askultă.” ");
INSERT INTO ronludari_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Maj mult š maj mult lumje vinja la Isusu. Atunča Isusu lja zăs: “Lumja ăn asta vrijamje je rovj. Vrja s fak znak kašă dokazu k Dimizov ma trimjes, ali nusă dobidjaštje ničunu znak osim znaku karje Dimizov adat d mult alu lumjej ăn vrijamja alu prorokuluj Jonej kănd Dimizov la spasăt dăla muartje. ");
INSERT INTO ronludari_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Baš kašă kum sa dogodit ku Jona afost znaku alu lumjej karje atrijit ăn trg Niniva k Dimizov la trimjes, isto aja, aša osă dogudjaskă ku minje, Bijatu alu Omuluj, osă fije znaku alu lumje ăn asta vrijamje. ");
INSERT INTO ronludari_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","La zuvă kănd Dimizov osă sudjaskă alu pămăntuluj, carica karje d mult avladit p pămănt alu Jugu osă skuală š osă svjedočaskă păntruv lumje ăn asta vrijamje daja če ja avinjit d dăpartje s audă p caru Salomon karje avut mult mudrost, a jakă, ku voj je aiča njeko maj marje d Salomon. ");
INSERT INTO ronludari_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","La zuvă kănd Dimizov osă sudjaskă alu pămăntuluj, lumja karje atrijit ăn trg Niniva osă skuală š osă svjedočaskă păntruv lumja ăn asta vrijamje daja če jej sa okrinit dăla rov alor kănd Jona alor arubit, a jakă, ku voj je aiča njeko maj marje d Jona!” ");
INSERT INTO ronludari_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Isusu azăs: “Nimilja nu prindje lampa s uaskundă ili s upuje dusu košară, već daja s upuje p loku alu je aša kum toc karje utră s puată s vjadă binje. ");
INSERT INTO ronludari_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Vojku alu tov je ka lampa d tjelă. Akă vojku alu tov bun, poc binje s vjez, ali akă vojku alu tov nuje bun, nu poc s vjez nimika. ");
INSERT INTO ronludari_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Daja păzaštje s nu găndještj k poc binje s vjez, već zapravo nu poc nimika s vjez. ");
INSERT INTO ronludari_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Daja, akă poc binje s vjez š akă nuje nimika d tinje skuns, tot poc s vjez. Osă fije kašă če ješt ăn sobă ku lampa karje c dă s vjez.” ");
INSERT INTO ronludari_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Kănd Isusu azavršăt vorba aluj, njeki farizej la kimat la jel akas s mălănče. Isusu auntrat š alat loku la astal. ");
INSERT INTO ronludari_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Isusu na spălat mănilje majdată njego če s mălănče. Farizeju sa mirat daja če jej ănvacă k omu trjebje aša s fakă s fije čist la intja alu Dimizov. ");
INSERT INTO ronludari_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Aša Domnu Isusu ja zăs: “Voj farizeji ištjec kašă lumja karje spală paru š găvanu samo da far, ali nu čistjaštje prljavština dăn nontru, k spălăc mănilje, ali inimilje alji avuaštrje zaista pljinje d pohlepă š d rov. ");
INSERT INTO ronludari_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Voj lumje karje na vjec fir ăn kap! Dimizov karje astvorit p omu da far je isto aša la stvorit dăn nontru. ");
INSERT INTO ronludari_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nu fic lakumj, već dăc dăla inimă alu lumje karje narje. Akă ištjec aša, osă fic čist la intja alu Dimizov dăn nontru š da far. ");
INSERT INTO ronludari_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Grjev vuavă, farizeji! Voj dăc alu Dimizov zjače (10) posto čak š d začinurj š d biljke alji voštrje, ali nu vu ponašăc pravedno nit vrjec p Dimizov. Asta atribut s fičec, ali s nu zanemarujic altje stvarurj karje Dimizov azapovjedit. ");
INSERT INTO ronludari_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Grjev vuavă, farizeji! Vrjec s šidjec p počasne lokurj ăn sinagogje š vrjec k p voj lumja pozdravjaštje ku marje poštujală p ulic. ");
INSERT INTO ronludari_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Grjev vuavă! Voj ištjec kašă pămăntu karje narje spomenik karje nu arată k ănzos s nalazaštje mărmăntje. Pa lumja umblă p ăštja mărmăntje, ali nu štije, š atunča je nečisti la intja alu Dimizov.” ");
INSERT INTO ronludari_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Atunča unu učitelj alu zakonu alu Mojsije ja zăs: “Učiteljulje, kum aša rubješt š p noj ku aja nji uvridještj!” ");
INSERT INTO ronludari_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Isusu ja zăs: “Grjev š vuavă, učitelji alu zakonu alu Mojsije! Voj punjec teretu p lumje karje je grjev š jej nu puatje s la dukă, a nič đajštju nu vrjec s l pomaknic s jažutac s adukă ăla teret. ");
INSERT INTO ronludari_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Grjev vuavă! Voj adrikăc spomenikurlje alu prorokulor, a voj ištjec isti kašă sămănca avuastră karje d mult lja umurăt. ");
INSERT INTO ronludari_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Aša k umjesto s lji osudic, voj aja potvrdic š slažăc ku sămănca avuastră. Jej lja umurăt, a voj lji drikăc spomenikurlje! ");
INSERT INTO ronludari_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Voj ištjec kašă pra tatilje alji voštri. Dimizov ăn mudrostu aluj majdată aštijut k osă fičec istje stvarurj. Jel azăs: ‘Osă trimjet la jej p prorokurlje š p apostoli, a jej p njeki d jej osă muarje, a p alcă osă putirjaskă.’ ");
INSERT INTO ronludari_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Daja Dimizov ku prava aluj osă smatrjaskă k je dăvină lumja ăn asta vrijamje d tuată muartje alu prorokurluj karje lumja lja umurăt d kănd je pămăntu. ");
INSERT INTO ronludari_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Dimizov osă lji osudjaskă d muartje alu tot proroku, dăla Abel pănla Zaharija, p karje la umurăt ăn Hram ăntră svetište š žrtvenik. Istina je, Dimizov osă lji kaznjaskă p lumja ăn asta vrijamje! ");
INSERT INTO ronludari_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Grjev vuavă, učitelji alu zakonu alu Mojsije! Voj ištjec kašă omu karje askuns ključu alu ušăj d cara alu Dimizov. Săngurj nu untrăc ăn cara alu Dimizov š nu dăc nič alu ălja karje kată s untrje.” ");
INSERT INTO ronludari_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Kănd Isusu apljikat dăn kasă alu farizej, učitelji d zakonu alu Mojsije š farizeji ančiput ku nikižala s navaljaskă p jel š azahtjevit s odgovorjaskă p multă vorbje. ");
INSERT INTO ronludari_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Jej pokuša s la pučje ăn zamkă ăn nješto če aputja s zăkă s l puată s l optužaskă. ");
INSERT INTO ronludari_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Maj mult š maj mult lumje anastavit s vije la Isusu. Lja fost atăta k gaza unij pisti alc. Maj dată njego če osă rubjaskă alu lumjej, Isusu arubit alu učenikurlje aluj: “Păzăcăvă d farizeji. Ku duavje trje fălč jaštje š utjecaju alor s proširjaštje ăntră lumje kašă germa karje s proširjaštje ăn mălaj. Păzăcăvă s nu fic kašă jej ku trje fălč. ");
INSERT INTO ronludari_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Vinje vrijamja kănd tot čije skuns osă fije otkrivit š tot čije tajna osă sa audă pănglă toc. ");
INSERT INTO ronludari_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Da, ăn zuvaja če god njeko azăs ăn tamă osă saudă la lumină š tot če njeko ašaptit ăn sobă kisă osă razglasaštje p krov s audă toc! ");
INSERT INTO ronludari_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ortači ajmje, punjec binje urjajke. Na vjec frikă d lumje. Jej puatje s umară samo tjela, ali dăpă aja vuavă nu puatje nimika maj rov s fakă! ");
INSERT INTO ronludari_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Njego osă vu pokazaskă d činje trjebje sa vjec frikă: avjec frikă d Dimizov karje p voj puatje s vu muarje, š atunča p voj s arunče ăn pakao. Da, d jel avjec frikă! ");
INSERT INTO ronludari_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Voj štijic k činč (5) vrabacurj s vindje samo d doj (2) novčičurj. Ali Dimizov nu mujtă p ničunu d jej. ");
INSERT INTO ronludari_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Voj štijec k aluj vridic maj mult njego multje vrabacurj. Dimizov štije čak š kăt avjec păr p kap. Daja na vjec frikă! ");
INSERT INTO ronludari_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Istina je, tot ăla karje aiča p pămănt la intja alu lumje priznajaštje k mije pripadnjaštje, š d jel jo, Bijatu alu Omuluj, la intja alu anđelilor alu Dimizov osă priznajesk k jel pripadnjaštje mije. ");
INSERT INTO ronludari_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Tot ăla karje aiča p pămănt la intja alu lumje s odriknještje k mije pripadnjaštje, osă m odriknjesk la intja alu anđelilor alu Dimizov k jel pripadnjaštje mije. ");
INSERT INTO ronludari_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ipak tot ăla karje rubjaštje păntruv minje, Bijatu alu Omuluj, puatje s oprostjaskă. A alu ăla karje uvridjaštje p Sufljetu alu Svăntuluj nusă oprostjaštje. ");
INSERT INTO ronludari_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Kănd jej aduče p voj la sud ăn sinagogă, la intja alu vladaruluj š la vlast, nu vu sikiric če s zăčec vuavă ăn obrană ");
INSERT INTO ronludari_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","daja če p voj Sufljetu alu Svăntuluj ăn ăla tren osă ănvacă če s zăčec.” ");
INSERT INTO ronludari_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Unu om dăn atăta lumje azăs alu Isusuluj: “Učiteljulje, zi alu fratimjov s podiljaskă ku minje imanja karje adobidit če tatimjov nja lăsat.” ");
INSERT INTO ronludari_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Isusu ja zăs: “Omulje, činje p minje ma pus s sudjesk š s podiljesk ăntră voj?” ");
INSERT INTO ronludari_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Atunča azăs alu toc: “Păzăcăvă š nu dopustic alu bilo d karje lakumije s utră ăn inima avuastră, k život nu s sastajaštje ăn aja če posjeduještj.” ");
INSERT INTO ronludari_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Atunča Isusu arubit asta vorbă: “Alu unu bogataš binje arodit pămăntu. ");
INSERT INTO ronludari_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Bogatašu agăndit: ‘Nu štiuv če s fak daja če nam nič u lok atăta d marje s sprimjesk tot če ma rodit.’ ");
INSERT INTO ronludari_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Atunča azăs: ‘Štiuv! Dubor p skladištilje abătrnje š osă fak maj marje š ănklo osă puj š gruvu š tuată imovina amja.’ ");
INSERT INTO ronludari_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Atunča osă zăk săngur mije: ‘Jakă, am ăn skladištje zalihe d još multje aj. Akuma m odmurjesk, mălănk, bjav š m veseljesk!’ ");
INSERT INTO ronludari_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ali Dimizov ja zăs: ‘Omulje tu karje naj mincă! Još d sară osă c jav sufljetu alu tov. Atunča alu činje s pripadnjaskă tot aja čaj străns d tinje?’ ");
INSERT INTO ronludari_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Omu karje narje mincă je ăla karje strănđe bugacija p pămănt, a nuje bugat ăn vojki alu Dimizov.” ");
INSERT INTO ronludari_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Atunča Isusu azăs alu učenikurlje aluj: “Daja vu zăk: Nu brinicăvă š na vjec frikă kum s preživic, če s mănkăc, nič kum s ănviljic tjala avuastră, če s ănbrkăc! ");
INSERT INTO ronludari_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","K životu maj važniji d mănkarje, š tjela d cualje. ");
INSERT INTO ronludari_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ujtacăvă la gavranurj! Nit sijaštje, nit adună, nit arje skladištje nit kolibă. A Dimizov ipak s pobrinjaštitje d jej. A voj vridic maj mult alu Dimizov d pujurj! ");
INSERT INTO ronludari_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Puatje njeko d voj aša če s brinjaštje s produžaskă životu čak š unu sat? ");
INSERT INTO ronludari_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Daja če nu putjec s fičec nič aša mikă stvar, dăče vu brinic d bilo čaja? ");
INSERT INTO ronludari_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ujtacăvă la frorj ăn polje kum krjaštje! Nu s mučaštje aša s fakă cualje. A ipak nič caru Salomon karje afost maj bugat š maj capăn caru ăn Izrael na fost ănbrkat aša măndru kašă unu d fruarjasta. ");
INSERT INTO ronludari_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Atunča akă Dimizov aša ănbrakă frorji karje krjaštje ăn polje karje jaštje astăz, a već minje s arunkă ăn fok, dali s nu vrja još maj mult s pobrinjaskă d voj? Voj lumjo karje aša d pucăn kridjec! ");
INSERT INTO ronludari_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Nu kătăc če osă mănkăc š če osă bjec š nu vu uznemiric d aja. ");
INSERT INTO ronludari_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","K Tata alu vostru ăn čerj štije k tot asta vuavă trjebje. Nu fic kašă lumja alu pămăntusta karje samo aja kată. ");
INSERT INTO ronludari_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Njego prvo kătăc cara alu Dimizov š Dimizov osă vu dja aja če vuavă trjebje. ");
INSERT INTO ronludari_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Navja frikă, amikă stada, k Tata alu vostru ăn čerj vrja s vu dja bugucija alu cara aluj. ");
INSERT INTO ronludari_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Vinjdjec aja če avjec š banj dăc alu lumje karje narje nimik! Akă aja fičec, osă avjec pravo bugucije p čerj karje nikad nusă fije purdut. Aja je kašă k avjec saku ku banji karje nikad nusă ajbje rupă ăn ja. P čerj nuje lupovj karje vuavă afura stvarurlje š nuje găgj karje amănka cualjilje avuaštrje. ");
INSERT INTO ronludari_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Inima avuastră uvjek osă fije ănklo undje je bugucija avuastră.” ");
INSERT INTO ronludari_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Isusu azăs: “Uvjek fic spremic, kašă argatu karje ănbrkat ăn radne cualje aluj š alu činje je lumina prinsă tuată nuaptja. ");
INSERT INTO ronludari_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Da, fic kašă argatu karje štjaptă p gospodaru aluj karje apljikat ăn svatovj š kănd gospodaru ažunđje akasă š batje la ušă, odma diškidje uša. ");
INSERT INTO ronludari_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Blago alu ălja argac karje je spremic š aštjaptă ăntručala alu gospodaruluj k jel osă lji nagradjaskă. Istina je zăk vuavă, gospodaru osă ănbračje cualjilje alu argatuluj, osă lji zăče s šagă la astal š săngur osă lji poslužaskă. ");
INSERT INTO ronludari_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Blago alu ălja argac karje je spremic š aštjaptă ăntručala alu gospodaruluj, čak š akă jel vinje ăn ponoć ili maj ănklo. ");
INSERT INTO ronludari_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ăn asta putjec s fic sigurni: Akă gazda alu kasăj štija kănd vinje lupovu, na dopustja alu lopovuluj s provaljaskă ăn kasa aluj. ");
INSERT INTO ronludari_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Fic š voj stalno pripremic daja če jo, Bijatu alu Omuluj, osă viuv kănd voj numă očekujic.” ");
INSERT INTO ronludari_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petar antribat: “Domnulje, arubit tu asta vorbă nuavă alu učenikulor ili alu toc?” ");
INSERT INTO ronludari_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Domnu Isusu ja zăs: “P činje găndic k gospodaru osă puje s upravljaskă ku altje argac ăn kasa aluj š s lji nahranjaskă ăn bună vrijamje? Aja je argatu p karje gospodaru smatrjaštje k je vjeran š mudar, dali nuje? ");
INSERT INTO ronludari_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Blago alu argatula p karje gospodaru, kănd s ănturča akas, s găsaskă k vjerno š mudro upravljit ku altje argac, k gospodaru osă nagradjaskă p jel! ");
INSERT INTO ronludari_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Da, istina je k postavljaštje p argatu s upravljaskă ku tuată imanja aluj. ");
INSERT INTO ronludari_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ali če osă fije akă argatula găndjaštje: ‘Gospodaru sa zadržăt p drum š nusă ăntuarčje d mult’, š ančiput s bată p argacă š p argatilje, mult mălănkă š bja š s ămbată? ");
INSERT INTO ronludari_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Atunča gospodaru alu argatula osă vije ăn zuvă ăn karje jel nu l očekuja š ăn vrijamje karje jel nu štije. Gospodaru osă l taje p komadurj š osă l trimjatje ănklo undje mora s pljače toc karje nu krjadje. ");
INSERT INTO ronludari_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Argatula karje aštijut ča čirut gospodaru, ali nu sa pripremit d vinjala aluj š na fukut aja če gospodaru azăs, osă fije luvit ku multje udaracurj. ");
INSERT INTO ronludari_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","A argatula, karje na štijut aja če gospodaru avrut, a afukut nješto d čaja azaslužăt bătaje osă fije luvit ku pucăn udaracurj. Dăla tot ăla alu činje Dimizov mult adat, Dimizov dăla jel osă kată mult. Dăla tot ăla alu činje Dimizov mult apovjerit, Dimizov dăla jel osă čarje mult.” ");
INSERT INTO ronludari_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Atunča Isusu azăs: “Avinjit s aduk sudu alu Dimizov p pămănt, kašă foku. Mult vrjauv s fije već aprinsă. ");
INSERT INTO ronludari_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Mora s trjek vrijamja d marje patjală š nimika nu m spričaštje pănd god nu završa asta vrijamje d patjală! ");
INSERT INTO ronludari_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Voj găndic k amvinjit s aduk miru p pămănt? Nipošto! Njego, istina je amvinjit s aduk podjelă ăntră lumje. ");
INSERT INTO ronludari_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Pănd akuma, akă ăn una kasă jaštje činč (5) lumje, osă podiljaskă unu păntruv altu. Doj (2) osă fije ku minje, a trje (3) osă fije păntruv minje. ");
INSERT INTO ronludari_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Članurlje alu familjije osă podiljaskă unji păntruv alc. Tata osă fije păntruv bijat š bijatu osă fije păntruv tată, mama păntruv fată š fata păntruv mamă, suakra păntruv noră š nora păntruv suakră.” ");
INSERT INTO ronludari_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Atunča Isusu arubit alu mulc lumje: “Kănd opazăc k d zapad dăla more s nakupjaštje njegri oblakurj, odma zăčec: ‘Osă fije nevrijeme’, š jaštje. ");
INSERT INTO ronludari_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","A kănd suflă văntu dăla jug voj zăčec: ‘Osă fije zăpuk!’ š jaštje zăpuk. ");
INSERT INTO ronludari_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Lumjo ku duavă licje! Putjec s ujtac pănglă voj če s dogodjaštje p pămănt š p čerj š s protumačic znakurlje karje ănklo s vjadje. Dăče atunča nu putjec s protumačic događajurlje karje promatric aštja zuvje kănd sănt jo ku voj? ");
INSERT INTO ronludari_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Š dăče nu putjec s prepoznajic čije binje d fukut? ");
INSERT INTO ronludari_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Pănd ku omu karje păntruv tinje plječ la sud, pokušaštje, majdată njego če s fije kasno, s t dogovorješt ku jel. Akă aja nu fač, jel osă vu prisiljaskă s stăc la intja alu sudaculuj, sudacu osă t sudjaskă š t predajaštje la izvršitelj, a jel osă ta runče ăn kisuarje. ");
INSERT INTO ronludari_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Istina je: nusă ješ d ănklo pănd god nu isplatja tuată datorija ata, pănla zadnja kovanică.” ");
INSERT INTO ronludari_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ăn vrijamjaja avinjit la Isusu njeki om karje ja rubit k rimski upravitelju Pilat anaredit p njeka lumje d regija Galileja s lji muară pănd duča žrtvă ăn Hram ăn Jeruzalem. ");
INSERT INTO ronludari_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","A Isusu lja zăs: “Dal găndic k lumja d regija Galileja aša afost umurăc daja ča fost grešni maj mult d toc alcă lumje ăn regija Galileja? ");
INSERT INTO ronludari_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nipošto! Istina je, akă nu vu okrinic dăla grešală, š voj isto osă propanic! ");
INSERT INTO ronludari_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Š če găndic d ăštja optsprjače (18) p karje sa duburăt kula ăn Siloam ăn Jeruzalem š lja murăt? Dal găndic k afost grešni maj mult d toc alcă lumja ăn Jeruzalem? ");
INSERT INTO ronludari_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nipošto! Istina je, akă nu vu okrinic dăla grešală, š voj isto osă propanic!” ");
INSERT INTO ronludari_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Atunča Isusu lji rubjaštje asta vorbă: “Njeki om avut smokvă karje asadit ăn vinograd aluj. Vinja ăn tot anu s vjadje dal arodit, ali na găsăt p ja ničuna smokvă. ");
INSERT INTO ronludari_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Azăs atunča alu omu karje s pobrinjaštje d vinograd: ‘Jakă već trje (3) aj viuv s vjed dal jaštje plod p smokvasta, ali nu l găsăsk. Tajoj. Dăče s iscrpjaskă pămăntu?’ ");
INSERT INTO ronludari_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","A omula azăs: ‘Gospodarulje, las još u an. Osă surp š osă puj păngl ja gnoju. ");
INSERT INTO ronludari_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Akă aja fiča la anu, možda osă rudjaskă smokva. Akă nu, atunča osă utaj d tinje.’” ");
INSERT INTO ronludari_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Isusu una sămbătă ănvăca ăn sinagogă. ");
INSERT INTO ronludari_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Jakă, afost ănklo una mujarje ăn karje afost optsprjače (18) aj sufljetu alu rov karje ufiča bulnavă. Afost grbavă š nikako na putut s s ispravljaskă. ");
INSERT INTO ronludari_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Kănd Isusu avizut p ja, akimato la jel š ja zăs: “Mujarje, oslobodită ješt d bualasta!” ");
INSERT INTO ronludari_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Atunča apus mănilje aluj p ja. Mujarja dăturdată sa ispravit š ančiput s slavjaskă p Dimizov. ");
INSERT INTO ronludari_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Omu karje vudjaštje sinagoga sa nikăžăt. Agăndit k Isusu prekršaštje zakonu alu Mojsije daja če likuja ăn sămbătă. Š azăs alu naroduluj: “Šasă (6) zălje ăn duminikă zakonu alu nostru dopustjaštje s lukrizăm. Ăn zuviljalja vinjic s likujic, a nu sămbătă!” ");
INSERT INTO ronludari_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Domnu Isusu ja zăs: “Voj lumjo karje avjec duavă licje! Š voj lukrizăc sămbătă. Toc voj dizljigăc ăn sămbătă p volu ili p magaracu š l skutjec dăn štală la apă s bja, dal nu? ");
INSERT INTO ronludari_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Asta mujarje karje je sămănca alu Abraham karje Sotona acănăto ljigată optsprjače (18) d aj. Dal stvarno găndic k na atribut s fije dizljigată ăn sămbătă dăla asta buală ku karje irja ljigată?” ");
INSERT INTO ronludari_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","P vorbilje alu Isusuluj, sa posramit toc dušmani aluj, a toc alcă sa radujit d čudurj karje afukut Isusu. ");
INSERT INTO ronludari_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Isusu azăs: “Kum izglidjaštje cara alu Dimizov? Ku čaja s ju usporidjesk? ");
INSERT INTO ronludari_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Cara alu Dimizov je kašă sămănca mikă alu gorušice karje omu asadit ăn baštjava aluj. Aja krjaštje marje kašă ljemnu š puji vinje s gnizdjaštje ăn krăči aluj.” ");
INSERT INTO ronludari_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jar antribat: “Ku čaja s ju usporidjesk cara alu Dimizov? ");
INSERT INTO ronludari_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Aja je kašă germa karje mujarja alato š amišăto ăn marje količină d pjelm pănd tot zolu nu sa drikă.” ");
INSERT INTO ronludari_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Isusu putuja ăn Jeruzalem. Pănd triča p trgurj š p saturj š p drum ănvăca, ");
INSERT INTO ronludari_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","njeko la antribat: “Domnulje, dal Dimizov samo osă spasaskă pucăn lumje dăla sud?” Isusu azăs: ");
INSERT INTO ronludari_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Cara alu Dimizov je kašă kasa karje arje ušă strămtă. Trudicăvă s untrăc p ja. Istina je, mult lumje vrja s untrje, ali nusă puată. ");
INSERT INTO ronludari_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kănd toc ažuns š gospodaru sa skulat š ankis uša, nusă kutizăc s untrăc. Atunča osă stăc afar š osă bătjec la ušă. Osă zăčec: ‘Domnulje, diškidje nuavă!’ A jel osă zăkă: ‘Nu štiuv činje ištjec š dundje vinjic.’ ");
INSERT INTO ronludari_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Atunča osă rubic: ‘Noj ku tinje amănkat š abut, š tu nji ănvăcaj p trgurje alji noštri!’ ");
INSERT INTO ronludari_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","A jel vuavă osă zăkă: ‘Nu štiuv činje ištjec š dundje vinjic. Fuđic dăla minje, toc voj lumjo karje fičec rov!’ ");
INSERT INTO ronludari_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ănklo osă plănđec š osă škrcijic d dinc ăn tugă kănd vidjec p Abraham, p Izak š p Jakov š p toc prorokurlje la gozbă ăn cara alu Dimizov, k voj săngurj afost putiric. ");
INSERT INTO ronludari_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Š osă vije lumja d tuatje părc alu pămăntuluj, čak š ălja karje nuje Židovj, š osă mălănče la gozbă ăn cara alu Dimizov. ");
INSERT INTO ronludari_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Jakă njeki karje akuma s smatrjaštje k je maj mič osă fije atunča maj marje, a njeki karje akuma s smatrjaštje k je maj marje osă fije atunča maj mič.” ");
INSERT INTO ronludari_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ăn vrijamaja, kănd Isusu azavršăt ku vorba, avinjit la jel njeki farizeji š azăs alu Isusuluj: “Fuđ da iča daja če Herod vrja s t muarje!” ");
INSERT INTO ronludari_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","A Isusu lja zăs: “Fuđic š zăčec alu aja lukavăj lisicăj: ‘Jakă, jo osă putirjesk p sufljeti alji rovj š likujaskă astăz š mănje š aldă trje (3) zălje osă dovršăsk lukru alu mjov.’ ");
INSERT INTO ronludari_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Da, astăz, mănje š dăpă mănje mora s nastavjesk p drum. Dali nuje aja ăn Jeruzalem undje umuară p tot proroku? Kum aputja s mor bilo undje altu? ");
INSERT INTO ronludari_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","O Jeruzaleme, o Jeruzaleme, tu karje umorj p prorokurlje š umorj ku buluvanji p ălja karje Dimizov atrimjes la tinje! Kăt vorj avrut s străng p lumja ata kum kloca sakupljaštje p puji š punje dusu ja, ali tu nu ma dat! ");
INSERT INTO ronludari_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Dimizov osă napustjaskă p tinje. Istina je, nu maj m vjez više tot pănd nu vinje vrijamja pănd god nu zăčec: ‘Blagoslovit ăla p karje Domnu atrimjes!’” ");
INSERT INTO ronludari_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ăn una sămbătă Isusu avinjit ăn kasa la unu vođe alu farizejulor s mălănče. Toc karje afost ăn kasă s ujta s vjadă če Isusu osă fakă. ");
INSERT INTO ronludari_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Jakă, la intja alu Isusuluj irja njeki om karje avut apă ăn jel. ");
INSERT INTO ronludari_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Isusu antribat p farizeji š p učitelji alu zakonu alu Mojsije: “Dopustjaštje zakonu s s likujaskă ăn sămbătă ili nu?” ");
INSERT INTO ronludari_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Jej atikut. Š Isusu apus măna p omu karje bulnav, la likujit š ja zăs: “Poc s plječ.” ");
INSERT INTO ronludari_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","A alor azăs: “Akă bijatu alu vostru ili volu kadje ăn puc ăn sămbătă, dal nusă l skutjec? Sigurno odma osă l skutjec, š akă je sămbătă!” ");
INSERT INTO ronludari_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Jej na vut p aja če s zăkă. ");
INSERT INTO ronludari_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Pănd Isusu afost ačija, avizut k gostjamja d jej avrut s kuljađje maj bunj lokurj la domačin. Daja Isusu lja spus asta vorbă: ");
INSERT INTO ronludari_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Kănd njeko t kjamă la nută, nu la maj bun lok la gozbă. Če akă je kimat njeko maj važniji d tinje? ");
INSERT INTO ronludari_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ăla karje ta kimat p tinje š p jel osă vije s c zăkă: ‘Skual š las loku alu omusta!’ Atunča mora s t skolj š s plječ la zadnji lok š osă fi sramotit. ");
INSERT INTO ronludari_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kănd t njeko kjamă nu la maj bun lok la gozbă, njego ja zadnji lok. Atunča kănd ăla karje ta kimat t vidja, osă vije s c zăkă cije: ‘Ortakulje, vină š šăz la maj bun lok.’ Aša osă primještj čast la tuată lumja karje je la gozbă. ");
INSERT INTO ronludari_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Činje p jel săngur adrikă, osă fije ponizăt, a ăla karje săngur p jel ponizaštje osă fije adrikat.” ");
INSERT INTO ronludari_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Atunča Isusu azăs alu farizeju p karje la kimat: “Kănd kjem p gostjamja la ručak ili la vičeră, nu kima samo p ortači alji tej, p fracă, p familija nič komšiji alji bugac, k š jej p tinje osă kjamă š aša c ăntuarčje zajamu. ");
INSERT INTO ronludari_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Njego kănd fač gozbă kjamă š p lumja karje je sărač, invalidj, p ălja karje nu puatje s umblje š p lumja vuarbă ");
INSERT INTO ronludari_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","karje nu puatje s t kjamje la gozbă s c ăntuarkă zajamu. Atunča osă fi zaista blagoslovit, k Dimizov osă c ăntuarkă zajamu, la zuvă karje vinje s uskrisnjaskă toc pravedni lumje dăla morc.” ");
INSERT INTO ronludari_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Kănd unu dăla alcă gostjamje karje afost la astal ku Isusu auzăt kum Isusu asta arubit, jel azăs: “Blago alu tot ăla karje osă mălănčj la gozbă ăn cara alu Dimizov!” ");
INSERT INTO ronludari_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Isusu ja zăs: “Njeki om afukut marje gozbă š akimat p mulc lumje. ");
INSERT INTO ronludari_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kănd vičera afost sprimită, atrimjes p argatu aluj s zăkă alu gostjamje p karje akimat: ‘Tot je gata. Vinjic!’ ");
INSERT INTO ronludari_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ali tot ăla ančiput s zăkă k nu puatje s vije. Unu azăs alu argatuluj: ‘Amkumprat njeka njivă š mora s pljek jar s m ujt. Mărog d tinje, oprostjaštjem.’ ");
INSERT INTO ronludari_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Altu azăs alu argatuluj: ‘Amkumprat činč (5) parurj d volurj š pljek s vjed kum orjaštje. Mărog d tinje, oprostjaštjem.’ ");
INSERT INTO ronludari_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Aldă trje (3) azăs alu argatuluj: ‘Akuma ma surat, š daja nu pot s viuv.’ ");
INSERT INTO ronludari_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Argatu sa tors š arubit alu gospodaru aluj aja če jej azăs. Gospodaru p aja sa nikăžăt š azăs alu argatuluj: ‘Fuđ odma p larđj š p uskje ulic ăn tot trgu š duj aiča p sărači š p invalidj, p lumja vuarbă, š p ălja karje nu puatje s umblje.’ ");
INSERT INTO ronludari_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Kănd aša afukut, argatu azăs: ‘Gospodarulje, amfukut aja če zapovjedit tu š jaštje još lok.’ ");
INSERT INTO ronludari_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Azăs gospodaru alu argatu aluj: ‘Fuđ afar dăn trg š kată p drumurj š p stazje š natirjaštilje s vije s m napunjaskă kasa. ");
INSERT INTO ronludari_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Istina je ničunu d ălja prvi p karje akimat nusă mălănk nimika d gozba amja!’” ");
INSERT INTO ronludari_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Pănd Isusu anastavit drumu aluj ăn Jeruzalem, la sljedit jako multă lumje. Isusu sa okrinit š azăs alor: ");
INSERT INTO ronludari_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Akă njeko vrja s m sljedjaskă, nu puatje s fije učeniku alu mjov akă vrja bilo p činje maj mult njego p minje. Ăn usporedbă ku ljubavu aluj kătri minje, jel mora s mrzaskă š p tatusov, p mumusa, p mujarja, p kupi, š p fracă, p surorilje, čak š p životu aluj. ");
INSERT INTO ronludari_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Činje nu ja kruča aluj š nu pljakă dăpă minje, nu puatje s fije učeniku alu mjov. ");
INSERT INTO ronludari_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Akă njeko dăla voj vrja s sagradještj kulă, nusă šăz prvo š s procinještj kăt kuštjaštje s vjadă arje dăstul banj s u završaskă? ");
INSERT INTO ronludari_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Inače možda osă c nistanjaskă banj dăpă aja če završăštj samo temelju, a atunča toc karje aja vjadje osă rădă d tinje. ");
INSERT INTO ronludari_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Osă zăkă: ‘Ăsta om ančiput s gradjaskă, a na putut s završaskă!’ ");
INSERT INTO ronludari_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Isto aša, dal vrja bilo karje car s krinjaskă ăn rat ku altu car, akă na găndit dal puatje s pobidjaskă? Dal prvo nusă s sastajaskă ku savjetnici aluj š s rubjaskă ku jel dal puatje ku aluj zjače mij (10.000) d vuastje s savladjaskă p ăla karje p jel vinje ku duavăzăč mij (20.000) d vuastje? ");
INSERT INTO ronludari_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","A akă shvatjaštje k nusă puată s pobidjaskă p altu car, osă trimjată p poslanikurlje la dušmanu aluj pănd je još maj dăpartje. Osă ăntrjabje p altu car če vrja dăla jel s puată s fije miru ăntră jej. ");
INSERT INTO ronludari_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Isto aša, găndic d cjenă s m sljedic. Nimilja dăla voj nu puatje s fije učeniku alu mjov, akă nu lasă tot če arje. ");
INSERT INTO ronludari_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ălja karje je uistinu učenikurlje alji mjej je kašă sarja. Sarja je bună, ali akă apurdut okusu, če osă fač jar s fije bună? ");
INSERT INTO ronludari_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Sarja karje apurdut okusu aluj s izbacaštje. Aja nuje bun d pămănt, a nuje bun čak š d hrpă d biljigarj. Toc činje arje urjekj s audă, trjebje s puje urjajke š s razumjaskă!” ");
INSERT INTO ronludari_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Zuviljaštja mulc carinikurj š alcă grešnikurj vinje la Isusu kum apunja urjajke la ănvăcala aluj. ");
INSERT INTO ronludari_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Daja farizeji š učitelji d zakonu alu Mojsije prigovorja: “Isusu s družaštje ku grešnikurlje! Čak š mălănkă ku jej!” ");
INSERT INTO ronludari_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Isusu d aja arubit asta vorbă: ");
INSERT INTO ronludari_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Akă njeko dăla voj arje usută (100) d voj š pjardje una dăla vuaje, če osă fakă? Dal nu lasă nuavăzăč š nuavă (99) p pijană š s pljače s ukatje š p aja una karje apurduto pănd nu ugăsaštje? ");
INSERT INTO ronludari_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Sigurno! Š kănd ugăsaštje, upunje p umirje tot vjasăl ");
INSERT INTO ronludari_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","š aduč akas. Atunča kjamă p ortači š p komšiji š lji zăče: ‘Veseljcăvă ku minje! Angăsăt p vuaja karje sa purdut!’ ");
INSERT INTO ronludari_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Istina je k p čerj isto s fije maj mult radost d unu grešnik karje s okrinjaštje dăla grešală njego d nuavăzăč š nuavă (99) lumje karje je pravedni š već sa okrinit la Dimizov.” ");
INSERT INTO ronludari_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Atunča Isusu azăs: “Također, akă njeka mujarje arje zjače (10) kovanic d arđint š una pjardje, če osă fakă? Dal nu prindje lampa, s mătără kasa š s ukatje binje? ");
INSERT INTO ronludari_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Sigurno! Š kănd ugăsaštje, kjamă p prijateljicilje š p komšinicilje š zăče: ‘Veseljcăvă ku minje! Angăsăt banji karje apurdut!’ ");
INSERT INTO ronludari_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Istina je, isto aša, Dimizov š anđelurlje aluj s radujaštje d unu grešnik karje s okrinjaštje la Dimizov.” ");
INSERT INTO ronludari_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Atunča Isusu arubit asta vorbă: “Afost unu om karje avut doj (2) fičorj. ");
INSERT INTO ronludari_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Fičoru alu tănăr azăs alu tatusov: ‘Tato, vrjauv talu alu mjov d imanja ata akuma majdată če osă morj.’ Aša tata apodjelit imanja, a alu maj tănăr fičor adat talu aluj. ");
INSERT INTO ronludari_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Kănd atrikut duavă trje zălje fičoru alu tănăr avindut tot, apljikat dăn kasă, š apljikat dăpartje ăn alta državă š ănklo atrijit frzdă minc š rasipja tuatje banji p jel. ");
INSERT INTO ronludari_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kănd apotrošăt tuatje banji aluj, ăn pămăntula karje irja afost marje fuamje š na vut če s mălănčje. ");
INSERT INTO ronludari_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Aša apljikat š sa zaposlit la unu om karje afost stanovniku alu pămăntula p karje atrimjes ăn pijană s păzaskă porči. ");
INSERT INTO ronludari_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Jel afost atăta flămănd k avrut čak s mălănčje mănkarja ku karje s rănjaštje porči, ali nimilja nu ja dat. ");
INSERT INTO ronludari_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Kănd fičoru alu tănăr napokon ashvatit ča fukut, agăndit: Toc radniči karje lukrjază d tatimjov arje mănkarje maj mult njego čije dosta d mănkat, a jo aiča mor d fuamje! ");
INSERT INTO ronludari_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Măduk da iča, pljek la tatimjov š osă ji zăk: ‘Tato, ampogrešăt păntruv Dimizov š păntruv tinje. ");
INSERT INTO ronludari_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nu sănt više vrjedan s mikjem bijatu alu tov. Mărog d tinje, primjaštimă s lukrjez la tinje ka radniku alu tov.’ ");
INSERT INTO ronludari_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Apljikat d lokula š sa dus la tatusov. Kănd još irja d partje, tatusov la vizut sa žalostit, adat fuga la jel, la zagrlit š la surutat. ");
INSERT INTO ronludari_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Azăs bijatu: ‘Tato, ampogrešăt păntruv Dimizov š păntruv tinje! Nu sănt više vrjedan s mikjem bijatu alu tov.’ ");
INSERT INTO ronludari_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ali tata azăs alu argacă aluj: ‘Majdată dučec aljina, aja karje maj măndră, š l brkăcălej! Punjec aluj injelu p mănă š sandaljilje p pičuarje! ");
INSERT INTO ronludari_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Š dučec maj bun mjel. Tăjecălăj s priredim gozbă š s nji veselim. ");
INSERT INTO ronludari_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Daja če ăsta bijatu alu mjov irja mort, a akuma je viuv! Irja purdut, a akuma je găsăt!’ Š ančiput s s veseljaskă. ");
INSERT INTO ronludari_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","D vrijamaja fičoru maj bătărn alukrizat ăn polje. Kănd sa tors dăn polje š avinjit aupruapje la kasă, auzăt k nontru kăntă š žuakă. ");
INSERT INTO ronludari_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Akimat la jel p unu d argat s ăntrjabje če s dogodjaštje aja. ");
INSERT INTO ronludari_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Argatu ja zăs: ‘C sa tors fratutov. Tatutov adat s tijem maj bun mjel s proslavjaskă če nuavă sa tors bijatu viuv š zdravăn.’ ");
INSERT INTO ronludari_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ali maj bătărn fičor sa nikăžăt š aodbit s untrje ăn kasă. Aša tatusov aišăt afar s s ruađje mult d jel s utră ăn kasă. ");
INSERT INTO ronludari_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","A fičoru ja zăs: ‘Jakă, jo atăta aj c služăsk š nikad na odbit s fak aja če maj zăs, ali mije nikad nu madat čak š krapă d gozba amikă ku ortači alji mjej. ");
INSERT INTO ronludari_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ali kănd sa tors ăsta bijatu alu tov karje ku prostitutkilje arasipit imanja ata, a tu adat s taje maj bun mjel š apriridit gozba d jel!’ ");
INSERT INTO ronludari_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tatusov ja zăs: ‘Fičoru alu mjov, tu ješt stalno ku minje. Tot če am pripadnjaštje cije. ");
INSERT INTO ronludari_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ali trjebje s proslavim š s nji radujim daja če ăsta fratutov irja mort, a akuma je viuv! Irja purdut, a akuma je găsăt!’” ");
INSERT INTO ronludari_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Isusu arubit alu učenikulor asta vorbă: “Afost unu om karje irja bugat š avut om karje upravlja ku bugucija aluj. Una zuvă njeko azăs alu bogatašuluj kum upravitelju rasipjaštje imanja aluj. ");
INSERT INTO ronludari_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Bogatašu akimat la jel p omula karje upravljaštje ku imanja aluj š ja zăs: ‘Kum aputut aja s mi fač? Nu poc više s upravlještj ku bugacija amja. Pripremjaštje papirulje ăn karje skrij tuată imanja amja š činje če dugujaštje.’ ");
INSERT INTO ronludari_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Upravitelju p aja azăs săngur aluj: ‘Gospodaru osă m lasă. Kum akuma osă priživjesk? Nu sănt capăn s surp, š m rušănje s prosăsk.’ ");
INSERT INTO ronludari_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Štiuv če osă fak kănd gospodaru m lăsa, osă fak aša k lumja osă m primjaskă ăn kasă alor š s pobrinjaskă d minje. ");
INSERT INTO ronludari_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Atunča akimat unu kăti unu p dužnikurlje alu gospodaruluj. P prvi antribat: ‘Kăt ješt datorj alu gospodaru alu mjov?’ ");
INSERT INTO ronludari_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Dužniku ja zăs: ‘Usută (100) d bătojurj d ulje.’ Upravitelju ja zăs: ‘Jakă računu p karje skrije k ajzăs k osă platještj usută (100). Šăz š majdată skrije još unu račun. Prominjaštje iznosu karje duguještj p činzăč (50).’ ");
INSERT INTO ronludari_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Atunča upravitelju p altu antribat: ‘Kăt ješt tu datorj?’ Dužniku ja zăs: ‘Usută (100) d košarje d gruv.’ Upravitelju ja zăs: ‘Jakă računu p karje skrije k ajzăs k osă platještj usută (100). Šăz š majdată skrije još unu račun. Prominjaštje iznosu karje duguještj p optzăč (80).’ ");
INSERT INTO ronludari_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Kănd gospodaru auzăt aja ča fukut nepošteni upravitelju, la pohvalit ča fost aša d snalažljiv. Istina je k lumja p pămăntusta jaštje mult snalažljivi pănd s pripremjaštje d životu alor ăn pămăntusta. Jej jaštje maj mult snalažjivi dăla lumje karje trijaštje ăn lumină pănd s pripremjaštje d životu alor p pămănt karje vinje. ");
INSERT INTO ronludari_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Aša punjec binje urjajke: Koristic bugacija alu pămăntusta s ažutăc alu alcilor š steknic ortačj ăn čerj. Atunča kănd osă fic morc š lăsăc bugacija alu pămăntusta, osă primjaskă p voj ăn vječna kasă. ");
INSERT INTO ronludari_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Činje god je vjeran ăn mič stvarurj, osă fije vjeran š ăn maj marj stvarurj, a činje god je nepošten ăn mič stvarurj, osă fije nepošten š ăn maj marj stvarurj. ");
INSERT INTO ronludari_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Akă nu ištjec vjerni ăn bugacija alu pămăntusta, činje osă vu dja bugacije p čerj? ");
INSERT INTO ronludari_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Š akă vuavă nu puatje s povirjaskă aja če pripadnjaštje alu njeko altuluj, činje osă vu dja aja če vuavă osă pripadnjaskă? ");
INSERT INTO ronludari_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ničunu argat nu puatje s služaskă p doj (2) gospodarurj. P unu osă mrzaskă, a p altu osă vrja, ili alu unu osă fije vjeran, a p altu osă prezirjaskă. Nu putjec s služăc š alu Dimizov š alu bugacije.” ");
INSERT INTO ronludari_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farizeji, karje avrut banji, la tot asta apus urjajke š sa ljigat d Isusu. ");
INSERT INTO ronludari_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Atunča Isusu lja zăs: “Voj la intja alu lumjej fičec k ištjec pravedni, ali Dimizov kunaštje inimilje alji vuaštrje. Aja če lumja smatrjaštje k je bun, aja Dimizov smatrjaštje k nu vridjaštje nimika.” ");
INSERT INTO ronludari_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Pănla vrijamjaja kănd avinjit Ivan karje bătjază, Dimizov arătat planu aluj pisti Zakonu alu Mojsije š knjigilje karje prorokurlje askris. Da tunča noj rubim Bună vorbă d cara alu Dimizov š nagovorim tuată lumje s untrje ăn jel. ");
INSERT INTO ronludari_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Tot čije skris ăn Zakon osă s ispunjaskă. Maj ušurje osă nistanjaskă čerju š pămăntu njego s nu s ispunjaskă š maj mikă slovă d Zakon. ");
INSERT INTO ronludari_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Na primjer: činje god s rastavjaštje d mujarje š s suară dăpă alta fače preljub, š činje god s suară dăpă mujarje karje irja rastavită fače preljub.” ");
INSERT INTO ronludari_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Isusu arubit asta vorbă: “Afost unu bogataš karje s ănbrka ăn skumpje cualje, š tuată zuva amănkat maj bună mănkarje. ");
INSERT INTO ronludari_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","A pănglă uša aluj azukut săraku karje sa kimat Lazar, karje afost pljin d čirurj. ");
INSERT INTO ronludari_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Lazar afost atăta flămănd k avrut s mălănčje čak š puškăji karje kădja dăpă astal alu bogatašuluj. Još maj rov, vinja kănji š linđja čirurlje aluj. ");
INSERT INTO ronludari_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Una zuvă amurit săraku š anđeli la dus pănla lok d čast pănglă Abraham. Maj ănklo amurit š bogatašu š la ăngrupat. ");
INSERT INTO ronludari_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Š bogatašu apljikat ănklo undje loku d kaznit. Pănd s muča, sa ujtat ăn sus, š avizut d dăpartje p Lazar ku Abraham. ");
INSERT INTO ronludari_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Bogatašu astrigat: ‘Tato Abrahame, smilujaštje mitje š trimjatje p Lazar s umučaskă vrhu alu đajštiluj ăn apă š s vije aiča s m ričaskă ljimba daja če mult patjesk ăn fokusta!’ ");
INSERT INTO ronludari_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","A Abraham ja zăs: ‘Bijatu alu mjov, dătje d gănd k tu ajdobidit bunje stvarurj pănd atrijit p pămănt, a Lazar rov. Akuma jel aiča utješăt, a tu t mučeštj. ");
INSERT INTO ronludari_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Osim d aja, ăntră noj jaštje marje provalije. Ălja karje avrja da iča s trjakă la voj nu puatje s fakă aja, a nič d partja avuastră karje avrja s vije la noj nu puatje s trjakă aiča.’ ");
INSERT INTO ronludari_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","Bogatašu ja zăs p aja: ‘Tato Abrahame, am činč (5) frac. Mărog d tinje, trimjatălăj atunča p Lazar ăn kasa alu tatimjov s lji opominjaskă s nu vije jej ăn lokusta undje trpjesk marje mukă.’ ");
INSERT INTO ronludari_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ali azăs Abraham alu bogatašuluj: ‘Nu vrjauv. Fracă alji tej arje p zakonu alu Mojsije š knjigilje karje prorokurlje d mult askris s lji opominjaskă. Trjebje alor s krjadă š s okrinjaskă dăla rov!’ ");
INSERT INTO ronludari_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","A bogatašu ja zăs: ‘Nu vrja, tato Abrahame! Ali akă lji vinja njeko dăla morc, osă okrinjaštje dăla rov.’ ");
INSERT INTO ronludari_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ali Abraham azăs alu bogatašuluj: ‘Akă nu krjadje alu Mojsije š alu prorokurj, nusă s uvirjaskă čak š akă njeko s skuală dăla morc.’” ");
INSERT INTO ronludari_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Atunča Isusu azăs alu učenikurlje aluj: “Lumja sigurno osă fakă stvarurj d karje p alcă navadjaštje p grešală. Ali grjev alu toc karje natirjaštje p njeko altu s grešaskă. ");
INSERT INTO ronludari_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Alu omula arfi majbinje njeko s la runče ăn apă ku marje buluvan pănglă găt, njego s navadjaskă p grešală p una dăla maj mik om. ");
INSERT INTO ronludari_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Pa păzăcăvă če fičec. Akă grešaštje još unu dăla učeniku alu mjov, zi k aja ča fukut k nuje binje š jartăj akă s okrinja dăla grešală aluj. ");
INSERT INTO ronludari_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Čak š akă d šaptje (7) vorj p zuvă grešaštje păntruv tinje š šaptje (7) vorj s ăntuarčje š priznajaštje aja ča fukut k nuje binje, jartăj!” ");
INSERT INTO ronludari_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Atunča apostoli azăs alu Domnuluj Isusuluj: “Ažutănje s kridjem maj mult!” ");
INSERT INTO ronludari_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","A Domnu Isusu lja zăs: “Akă avjec vjeră atăta pucăn kašă sămănca alu goruščică, aputja s zăčec alu dudusta: ‘Skuatitje ku korijenu d pămănt š posadjaštitje ăn apă’, š apunja urjajke la voj. ");
INSERT INTO ronludari_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Zăčem k njeko dăla voj arje argat karje lukrjază ăn polje ili s brinjaštje d voj. Kănd argatu s ăntuarčje d polje, dali gospodaru iziča: ‘Vină akuma, šăz š mălănkă’? Nu ji zăče! ");
INSERT INTO ronludari_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Umjesto aja, osă zăkă gospodaru aša: ‘Priredjaštjem vičera! Dăzbrakitje š poslužaštje p minje ku mănkarja š ku bjarja! A kănd jo završa, poc tu s mălănč š s bjaj.’ ");
INSERT INTO ronludari_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Dali gospodaru dugujaštje alu argatuluj s ji zahvaljaskă daja ča fukut aja če irja azapovjedit aluj? Nu! ");
INSERT INTO ronludari_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Aša š voj, kănd fičec aja tot če vuavă Dimizov azapovjedit, zăčec: ‘Noj ištjem samo argac š nu zaslužăm pohvalje k samo fičem dužnost alu nostru.’” ");
INSERT INTO ronludari_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Pănd Isusu još uvjek pljika kătri Jeruzalem š putuja pănglă granică alu regije Samarije š alu regije Galileje, ");
INSERT INTO ronludari_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","avinjit pănla njeki sat. Pănd untra ăn sat, la vizut zjače (10) lumje karje avja gubă, zarazna buală p pjalje. Jej astat majdăpartje ");
INSERT INTO ronludari_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","š ančiput s striđje dăn tot glasu: “Isusulje, gospodarulje, smilujaštitje p noj!” ");
INSERT INTO ronludari_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Kănd Isusu lja vizut, lja zăs: “Fuđic š pokazăcăvă la popje s puatje jej s vu pregledjaskă!” Pănd apljikat kătri popje, sa likujit d gubă. ");
INSERT INTO ronludari_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Kănd unu d jej avizut k je likujit, sa tors š aslavit p Dimizov p tot glasu. ");
INSERT INTO ronludari_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Akăzut la intja alu Isusuluj ku fălči kătri pămănt š ja zahvaljit. Afost omula d Samarija. ");
INSERT INTO ronludari_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","P aja Isusu antribat p ălja karje afost ku jel: “Dali Dimizov na likujit p zjače (10) lumje? Undje ălja alanc nuavă (9)? ");
INSERT INTO ronludari_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Kum puatje s fije k omusta karje nuje Židov jedini karje sa tors mije š azahvaljit alu Dimizov?” ");
INSERT INTO ronludari_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","A alu omula atunča Isusu azăs: “Skual š fuđ. Tu taj likujit daja čaj krizut.” ");
INSERT INTO ronludari_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ăn una zuvă farizeji antribat p Isusu: “Kănd vinje cara alu Dimizov?” Isusu lja zăs: “Omu nu puatje s predvidjaskă kănd vinja cara ăn znakurj karje promatrjaštje. ");
INSERT INTO ronludari_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Lumja nusă puată s zăkă: ‘Jakălăj aiča je!’, ili: ‘Jatălăj ănklo je!’ Jakă cara alu Dimizov akuma ăntră voj.” ");
INSERT INTO ronludari_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Atunča alu učenikurlje aluj azăs: “Vinje vrijamja kănd s fic žaljnič s vidjec zuva kănd jo, Bijatu alu Omuluj, s m pojavjesk, ali nusă putjec. ");
INSERT INTO ronludari_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","A lumja s vu zăkă: ‘Jatălăj ănklo je’, š: ‘Jakălăj aiča je!’, ali nu dăc fuga dăpă jej s m kătăc. ");
INSERT INTO ronludari_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","K kum š toc vjadje munja kănd s pojavjaštje aša s fije ăn zuvaja kănd jo, Bijatu alu Omuluj, s m pojavjesk. ");
INSERT INTO ronludari_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ali majdată trjebje mult s trpjesk š lumja ăn asta vrijamje trjebje s m odbacaskă.” ");
INSERT INTO ronludari_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Š isto aša, kum afost ăn zuvilje kănd Noa afost viuv š aša osă fije ăn zuvilje majdată kănd jo, Bijatu alu Omuluj, osă m pojavjesk: ");
INSERT INTO ronludari_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Kašă uvjek nastavja s mălănče š s bja, s s ănsuarje š s miritje, tot pănla zuvă kănd Noa auntrat ăn marje brod. A atunča avinjit potopu š p toc lja uništit karje na fost ăn marje brod. ");
INSERT INTO ronludari_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Š isto aša kum afost ăn zuvilje kănd Lot afost viuv: lumja ăn asta regija kašă uvjek nastavja s mălănče š s bja, s kumprje š s vindă, s obradjaskă pămăntu š s gradjaskă. ");
INSERT INTO ronludari_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ali ăn zuvaja kănd Lot aišăt dăn trg Sodoma ăn karje atrijit, atunča dăn čerj foku ku buluvanji karje ardje akăzut ka pluaja p jej š aumurăt p tuată lumja ăn aja regija. ");
INSERT INTO ronludari_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Isto aša osă fije š ăn zuvă kănd osă m pojavjesk jo, Bijatu alu Omuluj. ");
INSERT INTO ronludari_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Činje god ăn zuvaja p krovu alu kasăj, a stvarulje alor je ăn nontru, s nu s dja ăn zos ăn kasă la stvarurj aluj! Činje god s găsaštje ăn pijană, s nu s ăntuarkă ăndrăt s ja stvarulje aluj! ");
INSERT INTO ronludari_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Dăcăvă d gănd če sa dogodit kănd mujarja alu Lot sa ujtat ăndrăt ăn Sodoma š apoginjit! ");
INSERT INTO ronludari_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Činje god pokušaštje s păzaskă životu aluj, osă l pjargă, a činje god spreman s lasă životu aluj, osă l păzaskă. ");
INSERT INTO ronludari_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Istina je, ăn nuaptaja kănd osă m pojavjesk, doj (2) lumje karje s skulkă ăn isti pat, p unu osă ja, a p altu osă l lasă. ");
INSERT INTO ronludari_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Dăla duavă (2) mujerj karje zajedno ăn mlin mačină, p una osă ja, a p alta osă l lasă. ");
INSERT INTO ronludari_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","37","Učenikurlje aluj l ăntrjabă: “Domnulje, undje asta osă fije?” Isusu lji zăče: “Undje zače lumja muartă, ănklo s sakupjaštje lešinari.” ");
INSERT INTO ronludari_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Isusu rubja alu učenikurlje aluj asta vorbă s lji ănvacă kum trjebje uvjek s s ruagă š nikad s nu odustanjaskă: ");
INSERT INTO ronludari_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Irja ăn njeki trg unu sudac. Nič k irja aluj frikă d Dimizov nič ka marit d lumje. ");
INSERT INTO ronludari_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","A ăn trgula irja š njeka udovică karje stalno vinja la jel š s ruga d jel: ‘Adăm pravdă păntruv dušmanu alu mjov!’ ");
INSERT INTO ronludari_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Sudacu d mult na marit d aja, ali napokon agăndit: ‘Š akă numi frikă d Dimizov š nu marjesk d lumje, ");
INSERT INTO ronludari_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","osă dauv pravdă alu asta udovică daja če m stalno zmitjaštje, s nu vije stalno s m dosadjaskă!’” ");
INSERT INTO ronludari_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Zăče Domnu Isusu: “Ăsta sudac irja nepravedan, ali obratic pažnja p aja če jel ipak aodlučit! ");
INSERT INTO ronludari_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Dali nusă dja Dimizov pravdă alu lumja aluj karje akuljes š karje zuva š nuaptja plănđe la jel? Dali Dimizov osă odgodjaskă s lja žută? ");
INSERT INTO ronludari_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Istina je, ănpripă Dimizov osă lji dja pravdă. Ali kănd jo, Bijatu alu Omuluj, mătork p pămănt, dal osă găsăsk p lumje karje aša krjadje ăn Dimizov?” ");
INSERT INTO ronludari_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Isusu rubja asta vorbă alu lumjej karje s uzdja ăn jej k je pravedni, š găndja k je maj bunj d alcă: ");
INSERT INTO ronludari_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Doj (2) lumje avinjit ăn Hram s s ruađje. Unu afost farizej karje lumja l poštuja, a altu om irja carinik karje lumja l mrăza. ");
INSERT INTO ronludari_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farizeju astat š sa rugat d jel: ‘Dimizovulje, fala cije če nu sănt kašă alcă lumje: lopovj, ăštja karje nuje pravedni kătri lumje, preljubnikurj ili kašă carinikusta. ");
INSERT INTO ronludari_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Dadavorj ăn duminikă pustjesk š d tot če stiknjesk zdauv cije unu tal.’ ");
INSERT INTO ronludari_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","A cariniku astat maj d partje š nu sa osudit s s ujtje ăn čerj. Jel tuguja š s bătja ăn tjept š rubja: ‘Dimizovulje, smilujaštje mije karje sănt om rov!’ ");
INSERT INTO ronludari_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Istina je, Dimizov afost zadovoljan ku rugala alu poreznikuluj š da tunča Dimizov la smatrit k je bun om. Ali p farizeju, Dimizov la smatrit k nuje bun om. K činje p jel săngur adrikă, Dimizov osă l ponizaskă, a činje p jel săngur ponizaštje, Dimizov osă l adrikă.” ");
INSERT INTO ronludari_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Jej duča alu Isusuluj š maj mič kupi s puje măna p jej š sa rugat s lji blagoslovjaskă Dimizov. Kănd učenikurlje aja opazăt, jej lja zabranit s adukă kupi. ");
INSERT INTO ronludari_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ali Isusu avrut s vije kupi š zăče: “Lăsăc kupi s vije la minje š nu lji putiric k cara alu Dimizovuluj pripadnjaštje alu ălja karje kašă kupištja! ");
INSERT INTO ronludari_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Istina je zăk vuavă, akă njeko vrja s primjaskă cara alu Dimizovuluj jel mora s postanjaskă kašă kupilu. Inače nikad nusă untrje ăn jel!” ");
INSERT INTO ronludari_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Njeki poglavar ăntrijabă p Isusu: “Učiteljulje alu bun, če mora s fakă s primjesk vječni život ku Dimizov?” ");
INSERT INTO ronludari_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Isusu l ăntrijabă: “Dăče m kjem k sănt bun? Bun je samo Dimizov. ");
INSERT INTO ronludari_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Zakonu alu Mojsije šti: ‘Nu fiča preljub’, ‘Nu umura’, ‘Nu fura’, ‘Nu optužuja ku minčunurlje’, š ‘Poštujaštje p tatutov š p mumuta!’” ");
INSERT INTO ronludari_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Omu azăs: “Poštujesk tuatje aštja zapovjedi alu Mojsije još kănd irjam tănăr.” ");
INSERT INTO ronludari_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Isusu zăče alu omuluj: “Još nješto c faljaštje. Fuđ š vindje tot če aj, a banji podiljaštje alu lumje karje sărač š osă aj blago p čerj. A atunča vină š pratjaštimă!” ");
INSERT INTO ronludari_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ăla om irja mult bogat š mult sa žalostit kănd auzăt aja če ja zăs Isusu. ");
INSERT INTO ronludari_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Kănd Isusu la vizut kăt je žalostit, jel azăs: “Kum je grjev alu bogatašilor s untră ăn cara alu Dimizov! ");
INSERT INTO ronludari_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Maj ušurje arfi alu devăj s s provučaskă p rupă alu akuluj njego alu bogatašuluj s untră ăn cara alu Dimizov!” ");
INSERT INTO ronludari_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ălja karje aja auzăt antribat: “Pa činje atunča puatje s spasaskă?” ");
INSERT INTO ronludari_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Isusu lja zăs: “Aja če lumje nu puatje s fakă, Dimizov puatje.” ");
INSERT INTO ronludari_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Petar zăče: “Jakă, noj tot alu nostru alăsat š t sljedim.” ");
INSERT INTO ronludari_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","A Isusu lja zăs: “Istina je zăk vuavă, tot ăla karje alăsat kasa aluj, ili p mujarja, ili p fracă, ili p roditelji, ili p kupi d cara alu Dimizov ");
INSERT INTO ronludari_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","već akuma p ăsta pămănt osă primjaskă maj mult njego ča lăsat, a p ăla pămănt karje vinje osă primjaskă vječni život.” ");
INSERT INTO ronludari_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Isusu astrăns p duavăsprjače (12) apostolurj š lja zăs: “Jakă untrăm ăn trg Jeruzalem. Ănklo osă s ispunjaskă tot če prorokurlje askris ăn Svăntă pismă d minje, d Bijatu alu Omuluj. ");
INSERT INTO ronludari_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Osă m predajaskă alu lumjej karje narje frikă d Dimizov, osă sprdujaskă d minje, osă m zlostavljaskă š osă škupje p minje. ");
INSERT INTO ronludari_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Š jej osă m bată ku biču š osă m umuară, ali d trje (3) zălje jo osă m skuală dăla morc.” ");
INSERT INTO ronludari_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ali učenikurlje na štijut d čaja Isusu rubjaštje. Na aputut s razumjaskă k aštja stvarurj osă ispunjaskă vorbilje alu prorokuluj. Daja jej na putut s shvatjaskă če Isusu alor azăs. ");
INSERT INTO ronludari_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Kănd Isusu avinjit la uprapje d trg Jerihon, pănglă drum šadje njeki om karje nu vidja š prusa. ");
INSERT INTO ronludari_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Kănd vorbu auzăt p mulc lumje karje vinja kătri jel, ăntriba činje aja. ");
INSERT INTO ronludari_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Jej ja zăs: “Jakă vinje Isusu dăn Nazaret.” ");
INSERT INTO ronludari_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Jel p aja astrigat: “Isusulje, Bijatu alu David, smilujaštitje mije!” ");
INSERT INTO ronludari_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Lumja karje afost la intje ja zăs s takă, ali jel samo još maj tarje strigă: “Bijatu alu David, smilujaštitje mije!” ");
INSERT INTO ronludari_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Kănd Isusu auzăt, astat š zapovjedit alu lumjej s dukă omu la jel. Kănd vorbu avinjit maj uprapje, Isusu la tribat: ");
INSERT INTO ronludari_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Če vrjaj s fak d tinje?” Omu karje je vorb ja zăs: “Vrjauv s m torč vidu, Domnulje!” ");
INSERT INTO ronludari_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","A Isusu ja zăs: “Vjez! Tu ta likujit daja ča krizut.” ");
INSERT INTO ronludari_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Omu karje nu vidja dăturdată avizut š apljikat p drum dăpă Isusu š slavja p Dimizov. Š tot narodu karje avizut aja zahvaljit alu Dimizovuluj. ");
INSERT INTO ronludari_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Isusu auntrat ăn Jerihon. Pănd jel atrikut p trgula, ");
INSERT INTO ronludari_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","afost ănklo unu om karje sa kimat Zakej. Jel irja glavni porezniku ăn aja regija d Rim š mult bogat om. ");
INSERT INTO ronludari_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Apokušăt s vjadă p Isusu činje je jel, ali afost mik š nu putja s l vjadă pisti multă lumje. ");
INSERT INTO ronludari_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Jel daja adat fuga la intje s s urče p smokvă pănglă karje atribja Isusu s trjače s puată p ja s l vjadă. ");
INSERT INTO ronludari_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Kănd Isusu ažuns pănla smokvă, sa ujtat ăn sus š ja zăs aluj: “Zakeju, majdată dătje ăn zos! Astăz mora s viuv la tinje ăn gostjamje.” ");
INSERT INTO ronludari_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zakej majdată sa dat ăn zos š la primit p Isusu ăn gostjamje, tot bukurat. ");
INSERT INTO ronludari_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ali tuată lumja karje avizut aja ančiput s čakaljaskă: “Nu trjebje s pljače ăn gostjamje la omu rov!” ");
INSERT INTO ronludari_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","A maj ănklo Zakej saskulat š zăče alu Domnuluj Isusuluj: “Jakă pola d imanja amja dau alu lumjej karje je sărakă, a p tot ăla p karje la šălat s ji tork d patru (4) vorj kăta amlat dăla jel.” ");
INSERT INTO ronludari_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Isusu azăs p aja: “Astăz ăn kasasta avinjit spasjala k š omusta je prava sămănca alu Abraham! ");
INSERT INTO ronludari_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Jo, Bijatu alu Omuluj, amvinjit s kat š s spasăsk p lumja karje je purdută.” ");
INSERT INTO ronludari_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Pănd lumje apus urjajke la Isusu, daja če irja la upruapje d Jeruzalem š jej agăndit k s cara alu Dimizov akuma s pojavjaštje, Isusu lja spus asta vorbă: ");
INSERT INTO ronludari_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Njeki om dăn familjije bună sa sprimit s putujaskă p dăpartje pămănt. Jel atribut s pljače ănklo s dobidjaskă vlastu dăla caru marje. Atunča s ăntuarče ăn pămăntu aluj s puată s vladjaskă ka caru. ");
INSERT INTO ronludari_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Majdată njego ča pljikat akimat p zjače (10) argac aluj, adat alu tot usută (100) kovanic d arđint š lja zăs: ‘Trgujic pănă god jo nu vinja.’ ");
INSERT INTO ronludari_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ali lumja d pămăntula aluj l mrza š atrimjes la caru alu marje p poslanikurlje s zăkă: ‘Nu vrjem jel s carujaskă p noj.’ ");
INSERT INTO ronludari_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ali jel adobidit vlastu s fije car. Š kănd sa tors akasă, azapovidit s kjamje p argacă alu karje jel adat banji. Avrut s štije kăt tot ăla zaradit d jel. ");
INSERT INTO ronludari_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Prvi argat avinjit š zăče: ‘Gospodarulje amkoristit banjišta karje maj dat š afukut zaradă d zjače (10) vorj maj mult.’ ");
INSERT INTO ronludari_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Zăče caru: ‘Bun lukru! Bun ješt argat. Daja ča fost vjeran ăn maj mikă, c dau s vladješt p zjače (10) trgurj.’ ");
INSERT INTO ronludari_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Altu argat avinjit š zăče: ‘Gospodarulje, amkoristit banjišta karje maj dat š afukut zaradă d još činč (5) vorj maj mult.’ ");
INSERT INTO ronludari_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Š p aja caru zăče: ‘Tu osă vladjaštje p činč (5) trgurj.’ ");
INSERT INTO ronludari_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ali aldă trje (3) argat avinjit frzdă zaradă š ji zăče: ‘Gospodarulje, jakăc arđintu. Lam cănut skuns ăn maramică. ");
INSERT INTO ronludari_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ma fost frikă d tinje daja če ješt strog om. Jaj tuată zaradă dăla ăla če alcă uložăt d tinje š căj tuată bugacija dăla jej karje lukrizat d tinje.’ ");
INSERT INTO ronludari_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Caru ja zăs: ‘Argatulje alu rov! C sudjesk p aja ča zăs tu. Tu zăč k sănt strog. Tu zăč jo jav tuată zarada dăla ăla če alcă auložăt d minje š jo căv tuată bugacija dăla jej karje lukrizat d minje! ");
INSERT INTO ronludari_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Dăče atunča na pus banji alji mje p bankă? Aša barem adobidja kamatje.’ ");
INSERT INTO ronludari_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Atunča caru zăče alu lumje karje afost aiča upruapje: ‘Lăcăj dăla jel usută (100) kovanic d arđint š dăcăj alu ăla karje zaradit zjače (10) vorj maj mult!’ ");
INSERT INTO ronludari_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Jej azăs: ‘Ali, gospodarulje, jel arje mij (1.000) kovanic d arđint!’ ");
INSERT INTO ronludari_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Caru azăs, ‘Istina je tot ăla karje koristjaštje binilje aja ča dobidit, osă dobidjaskă još maj mult, a toc karje nu koristjaštje binilje aja ča dobidit, osă s s ja š aja če arje. ");
INSERT INTO ronludari_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ali ălja dušmani alji mjej, karje na vurut s lji fiuv caru, dučecălje aiča š lji umurăc la intja amja.’” ");
INSERT INTO ronludari_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Dăpă aja če Isusu azăs, nastavit s pljače la intja alor kătri Jeruzalem. ");
INSERT INTO ronludari_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Kănd avinjit la upruapje d saturj Betfaga š Betanija maj upruapje p djal Maslina, atrimjes la intje p doj (2) učenikurj. ");
INSERT INTO ronludari_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Lja zăs: “Fuđic ăn satula la intja avuastră. Š čim untrăc, osă vidjec p magaracu alu tănăr karje je ljigat karje nimilja nu la jahit. Dizljigăcălăj š dučecălăj aiča. ");
INSERT INTO ronludari_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Akă ăntrijabă njeko p voj: ‘Dăče dizljigăc p magaracu alu tănăr?’ Zăčec samo: ‘Trjebje alu Domnuluj.’” ");
INSERT INTO ronludari_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Jej apljikat š angăsăt toto kum lja zăs Isusu. ");
INSERT INTO ronludari_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Pănd jej adizljigat, lumja alu činje magaracu lja tribat: “Dăče dizljigăc p magaracu alu tănăr?” ");
INSERT INTO ronludari_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Jej lja zăs: “Alu Domnuluj ăntrjabje.” ");
INSERT INTO ronludari_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Jej adus p magaracu alu tănăr la Isusu š prebacăt pisti jel ogrtači alor š apus p Isusu p magarac s šagă. ");
INSERT INTO ronludari_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Pănd Isusu pljika mulc lumje raširit alor ogrtačurlje p drum la intja alu Isusuluj s ji pokazaskă častu. ");
INSERT INTO ronludari_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Kănd Isusu sa približăt undje drumu s slubadje dăpă djal Maslina, učenikurj š mulcă lumje karje kridja ăn Isusu ančiput p tot glasu s s radujaskă š s slavjaskă p Dimizov d tuată čuda karje avizut če Isusu majdată afukut. ");
INSERT INTO ronludari_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Jej rubja: “Blagoslovit p caru p karje Domnu atrimjes! Hvaljic p Dimizov karje dă miru! Slava alu Dimizov karje vladjaštje p čerj!” ");
INSERT INTO ronludari_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ali njeki farizeji karje irja ănklo azăs: “Učiteljulje, zapovidjaštje alu učenikurlje alji tej s takă!” ");
INSERT INTO ronludari_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Isusu zăče: “Akă jej osă takă, istina je, š buluvanji p tot glasu osă s radujaskă!” ");
INSERT INTO ronludari_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Kănd Isusu avinjit la upruapje la Jeruzalem š avizut trgu, plănđja dăpă lumjaja ăn trgula ");
INSERT INTO ronludari_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","š azăs: “Kănd barem samo s štijec če vuavă osă adukă miru! Ali akuma je vuavă skuns. ");
INSERT INTO ronludari_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","K vinje vrijamja kănd dušmani alji voštri s gradjaskă kulje pănglă zidu alu trguluj s vu napadjaskă d tuatje părcă, vuastja alor osă vu okuljaskă š nu putjec s fuđic. ");
INSERT INTO ronludari_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nusă s lasă ăn trgu alu vostru nič unu buluvan p buluvan. Jej osă uništjaskă tot trgu alu vostru š tot čije ăn jel voj daja če na prepoznajit asta vrijamje kănd Dimizov p voj avinjit s vu spasaskă.” ");
INSERT INTO ronludari_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Kănd auntrat ăn dvorištja alu Hramuluj, Isusu ančiput dăn jel s putirjaskă p tuată lumja karje ănklo vindje. ");
INSERT INTO ronludari_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Isusu lja zăs: “Skris je ăn Svăntă pismă: ‘Alu mjov Hramu s fije loku d rugală’, a voj pretvorit ăn lok undje s strănđe lopovi!” ");
INSERT INTO ronludari_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Dăpă aja Isusu tuată zuva ănvăca ăn dvorištja alu Hramuluj. Glavni popurlje š učitelji d zakonu alu Mojsije š alcă vođe alu židovilor s ujta kum s l apuče p Isusu š s l osudjaskă p muartje. ");
INSERT INTO ronludari_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ali jej nu ja putut nimika s ji fakă daja če tot narodu upija tuată vorba karje Isusu rubja. ");
INSERT INTO ronludari_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ăn una zuvă kănd Isusu ănvăca ăn dvorištja alu Hramuluj š rubja alu lumjej Bună vorbă d Dimizov avinjit upruapje la jel glavni popurlje š učitelji d zakonu alu Mojsije š vođilje. ");
INSERT INTO ronludari_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Š jej la antribat: “Zi nuavă, dundjec pravo s fač aštja stvarurj? Činje ca dat vlast d asta?” ");
INSERT INTO ronludari_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","A Isusu lja zăs alor: “Š jo osă ăntrijeb p voj. Zăčec mije ");
INSERT INTO ronludari_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","činje adat vlast alu Ivan karje bătjază s rubjaskă š s fakă aja ča fukut, Dimizov ili lumja?” ");
INSERT INTO ronludari_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Jej raspravlja ăntră jej če s zăkă alu Isusuluj. Jej azăs: “Akă zăčem: ‘Dimizov’, osă nji ăntrjabă: ‘Dăče atunča nu ja krizut?’ ");
INSERT INTO ronludari_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","A akă zăčem: ‘Lumja’, tuată lumja osă arunče buluvanji š osă nji muară daja če je uvjeric k je Ivan proroku.” ");
INSERT INTO ronludari_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Atunča jej zăče alu Isusuluj k jej nu štije činje adat vlast alu Ivan. ");
INSERT INTO ronludari_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","A Isusu lja zăs: “Kum voj mije nu zăčec činje alu Ivan adat vlast, š jo nu zăk vuavă činje mije adat vlast!” ");
INSERT INTO ronludari_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Atunča Isusu lji spunje asta vorbă alu lumjej: “Njeki om asadit vinograd š adat ăn zajam alu omuluj karje lukrjază ku vinogradu. Atunča omula apljikat š na vinjit mult lunj. ");
INSERT INTO ronludari_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kănd avinjit vrijamja d strugurj s lja dună, atrimjes gazda alu vinograduluj p argatu aluj s ja talu aluj d berbă. Ali lumja karje lukrjază ăn vinograd je la butut p argatu š la trimjes ăndrăt ku mănilje gualje. ");
INSERT INTO ronludari_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Atrimjes omu p altu argat, ali š p jel la butut š la dat d rušunje š la trimjes ăndrăt ku mănilje gualje. ");
INSERT INTO ronludari_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Gazda alu vinograduluj atrimjes aldă trje (3) argat, ali jej p jel la ranit š la putirit. ");
INSERT INTO ronludari_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Atunča gazda alu vinograduluj zăče: ‘Če s fakă? Osă trimjet p bijatu mjov karje jo vrjauv. Vjerovatno p jel osă l poštujaskă.’ ");
INSERT INTO ronludari_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ali kănd lumja dăn vinograd avizut p bijatu, sa dogovorit š azăs: ‘Ăsta osă nasljedjaskă imanja. L umurăm š atunča imanja osă fije nostru!’ ");
INSERT INTO ronludari_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","La putirit dăn vinograd š la umurăt. Če găndic k osă fakă gazda alu vinograduluj kănd osă audă ča fost? ");
INSERT INTO ronludari_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Osă vije š osă umuară p lumja dăn vinograd, a vinogradu osă dja ăn najam alu alcilor.” Lumja karje punje urjajke la Isusu, ja zăs: “Nikad nu fičem nješto aša rov!” ");
INSERT INTO ronludari_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Atunča Isusu binje s ujtă p jej š zăče: “A če značaštje atunča aja čije skrisă ăn Svăntă pismă: ‘Buluvan karje graditelji arunkat postanit glavni buluvan alu zgradej’? ");
INSERT INTO ronludari_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Toc karje kadje p buluvanula osă sparđje kašă găvanu d glină, š akă kadje ăla buluvanu p njeko osă fije măčinat.” ");
INSERT INTO ronludari_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Učitelji d zakonu alu Mojsije š glavni popurlje avrut odma s la puče p Isusu d aja k jej binje aštijut k Isusu rubjaštje aja vorbă d jej. Ali na fukut aja k lji irja frikă k lumja osă okrunjaskă păntruv jej. ");
INSERT INTO ronludari_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Učitelji d zakon alu Mojsije š glavni popurlje la sljedit p Isusu š atrimjes dăpă jel špijunurj karje sa fukut k je iskreni. Avrut s apuče p Isusu k azăs nješto rov kum s l predajaskă alu upravitelj alu rimuluj ăn asta regija kum aputja s kaznjaskă p Isusu. ");
INSERT INTO ronludari_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Špijunurlje azăs alu Isusuluj, “Učiteljulje, štijem k rubješt š ănvăc istină š k nu ješt naklon alu unu om maj mult d altu, već ispravno ănvăc p lumja s trijaskă aša kum Dimizov vrja s jej trijaskă. ");
INSERT INTO ronludari_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Spunje nuavă dali je dopustit s platim porezu alu caru alu Rimuluj ili nuje.” ");
INSERT INTO ronludari_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ali Isusu avizut k pokuša s l puče ăn zamkă š lja zăs: ");
INSERT INTO ronludari_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Rătăcăm kovanica d arđint ku karje s platjaštje porezu. Alu činje je slikaja š alu činje lumje p ja?” Jej aodgovorit: “Alu caruluj.” ");
INSERT INTO ronludari_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Isusu lji zăča: “Atunča dăc alu caru čije alu caruluj, ali alu Dimizov dăc čije alu Dimizovuluj.” ");
INSERT INTO ronludari_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Daja na putut p Isusu pănglă toc s l optužaskă k azăs nješto če nuje binje, već atikut š sa mirat la vorbaja. ");
INSERT INTO ronludari_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Atunča avinjit la Isusu njeki saduceji. Saduceji nu kridja k lumja s skuală dăla morc, daja jej azăs alu Isusu: ");
INSERT INTO ronludari_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Učiteljulje, Mojsije askris ăn zakonu alu nostru k akă njeki om amurit š alăsat dăpă jel mujarja ali na vut kupi, fratilje aluj mora s ănsuarje p mujarja alu fratusov kum ja aputja s fakă bijat. Ăla bijat osă fije nasljedniku alu pămăntuluj alu omula karje amurit š s adukă lumje aluj. ");
INSERT INTO ronludari_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Udată afost šaptje (7) frac. Prvi fratje sa ănsurat š amurit frzdă kupi. ");
INSERT INTO ronludari_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Atunča altu fratje sa ănsurat ku mujarja alu fratusov karje amurit, ali š jel amurit. ");
INSERT INTO ronludari_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Isto aša aldă trje (3) fratje sa ănsurat š amurit. Š toc fracă karje arămas sa ănsurat ku ja š toc d šaptje (7) frac amurit frzdă kupi. ");
INSERT INTO ronludari_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Maj ănklo amurit š mujarja. ");
INSERT INTO ronludari_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Akă una zuvă toc morcă osă skualje, alu činje ja osă fije mujarja ăn zuvaja kănd irja mărtată dăpă toc šaptje (7) frac?” ");
INSERT INTO ronludari_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Isusu lja zăs: “Lumja p pămăntusta s suară š s mărită. ");
INSERT INTO ronludari_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ali lumja karje s skuală dăla morc trijaštje p pămăntu alu nov. Š p ălja karje Dimizov smatraštje k je dostojni s trijaskă p pămăntula, nusă ănsuară nič s miritje. ");
INSERT INTO ronludari_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Osă fije kašă anđeli daja če nikad nusă muară. Jej jaštje kupi alu Dimizov daja če Dimizov lja tors dăla morc. ");
INSERT INTO ronludari_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ali akuma, dal morcă osă skualje dăla muartje? Čak š Mojsije apokazăt k morcă osă skualje. Mojsije aja apokazăt ăn odlomaku d grmu karje ardje undje Mojsije azăs k Domnu jaštje ‘Dimizov alu Abraham š alu Izak š alu Jakov.’ A jej amurit mult aj majdată Mojsije azăs aja. ");
INSERT INTO ronludari_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","A Dimizov nuje Dimizov alu ălja karje rămănje morc, već Dimizov alu lumje karje vije! Dimizov p tuată lumja smatrjaštje k jej vij.” ");
INSERT INTO ronludari_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Atunča azăs njeki učitelji d zakonu alu Mojsije: “Učiteljulje, binje ajzăs!” ");
INSERT INTO ronludari_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Dăpă aja nu sa osudit s ăntrijabă p Isusu aša pitanja. ");
INSERT INTO ronludari_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Atunča Isusu lja tribat p lumja: “Dăče učitelji zăče k je Kristu bijatu alu Caru David? ");
INSERT INTO ronludari_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","K David săngur zăče ăn knjigă alu Psalam undje askris: ‘Domnu azăs alu Domnuluj alu mjov: Šăz p dirjaptă amja, s vladješt ku minje ");
INSERT INTO ronludari_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","pănd nu puj p dušmanji alji tej kašă klupa dusu pičuarje alji tijalje.’ ");
INSERT INTO ronludari_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Jasno je k David p Mesija akimat ‘Domnu alu mjov’. Kum atunča Mesija puatje s fije samo potomaku alu David?” ");
INSERT INTO ronludari_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Pănd narodu apus urjajke, Isusu azăs alu učenikurlje aluj: ");
INSERT INTO ronludari_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Păzăcăvă d učitelji d zakonu alu Mojsije! Jej vrja s umblje okolo ku aljinilje alji marj š lumja s lji pozdravjaskă ku marje poštujală p ulic. Jej vrja s šagă p počasne lokurj ăn sinagogje š la nutje. ");
INSERT INTO ronludari_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","P prjevară ja imanja alu udovicilor, a s ruagă mult s puată lumja s lji vjadă. Jej osă fije kaznic maj rov d alcă lumje.” ");
INSERT INTO ronludari_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Isusu ăn Hram avizut p bogataši kum ubacăt banji ăn blagajnă alu hramuluj. ");
INSERT INTO ronludari_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Atunča avizut š p njeka udovică kum arunkă samo duavă (2) maj mič kovanic. ");
INSERT INTO ronludari_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Isusu azăs alu učenikulor: “Punjec urjajke, k istina je, asta sărakă udovică apus maj mult njego jej toc zajedno! ");
INSERT INTO ronludari_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","K toc jej adat ča vut viška, a ja, aša d sărakă, adat tot če arje.” ");
INSERT INTO ronludari_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Kănd njeki učenikurlje alu Isusuluj arubit kum je Hramu sagradit d maj măndru buluvan š ukrasăt ku maj măndri darurj karje lumja adat alu Dimizov, Isusu zăče: ");
INSERT INTO ronludari_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Osă vije vrijamja kănd nusă rămije nič unu buluvan p buluvan d Hramusta če vu ujtac. Tot s fije duburăt.” ");
INSERT INTO ronludari_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Š daja jej la antribat: “Učiteljulje, kănd tot aja osă dogodjaštje? D karje znak osă najavljaskă d tot aja če vinje?” ");
INSERT INTO ronludari_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ja zăs Isusu: “Păzăcăvă s nu vu ănšalje! Mulc osă vije š osă zăkă: ‘Jo sănt Mesija’ š osă zăkă avinjit kraju! Nu lji kridjec. ");
INSERT INTO ronludari_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kănd audjec d raturj š d pobună, na vjec frikă. Tot aja mora s dogodjaskă, ali kraju alu pămăntuluj nusă vije još.” ");
INSERT INTO ronludari_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Zăče još: “Narodu osă zaratjaskă păntruv narod š cara păntruv cară. ");
INSERT INTO ronludari_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Osă fije marj potresurj. Osă fije fuamja š kuga p altje lokurj. Osă fije događajurj d karje lumja osă fije frikă š znakurj p čerj k vinje nješto rov. ");
INSERT INTO ronludari_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ali majdată d aja če s fije, osă vu apukă š osă vu maltetirjaskă. Osă vu dja ăn sinagogă la sud š p voj osă trimjată ăn kisuarje. Osă vu dukă la intja alu carurj š la upraviteljurj daja če sljidic p minje. ");
INSERT INTO ronludari_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Osă vu zadisaskă p voj s putjec s rubic svjedočala avuastră d minje. ");
INSERT INTO ronludari_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nu vu brinic akuma če s zăčec d minje ăn obrană ");
INSERT INTO ronludari_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","k jo osă vu dav vorbilje š mudrost karje ničunu alu voštri protivnikurj nusă puată s odoljaskă nič s ăntuarkă vorba. ");
INSERT INTO ronludari_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Čak š roditelji, fracă, familija, š ortači osă vu predajaskă. Osă vu umuară p njeko d voj. ");
INSERT INTO ronludari_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Toc osă vu zamrzaskă daja če sljidic p minje. ");
INSERT INTO ronludari_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ali ničuna d ăštja stvarurj vuavă stvarno nu puatje s vu naštitjaskă. ");
INSERT INTO ronludari_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Osă dobidic život akă mije răminjec vjerni.” ");
INSERT INTO ronludari_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Kănd vidjec k vuastja opkoljaštje Jeruzalemu, osă štijic k avinjit vrijamja d uništijala alu Jeruzalem. ");
INSERT INTO ronludari_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ălja karje sa trefit ăn Judeja atunča s fugă ăn djal. Činje je ăn trg atunča s fugă dăn jel, a ălja karje s găsaštje ăn okolică atunča s nu untră ăn trg. ");
INSERT INTO ronludari_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","K aja osă fije zăljilje alu Dimizovuluj d kaznjală ku karje osă ispunjaskă tot če skrije ăn Svăntă pismă d asta vrijamje. ");
INSERT INTO ronludari_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Grjev alu trudnicilor š alu mujerj karje dă s sugă ăn vrijamjaja daja če osă vije marje rovu ăn pămăntusta š marje gnjev osă kadă p narodusta. ");
INSERT INTO ronludari_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Vuastja osă umuarje p njeka lumja š p alci osă lja dukă kašă p ratne zarobljenikurlje ăn tot pămăntu. Nežidovi osă gazaskă p Jeruzalemu pănă god nu triča vrijamja alor.” ");
INSERT INTO ronludari_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Osă pojavjaskă čudne znakurj p suarje, p lună š p stjalje. A p pămănt osă fije marje zbunjală, ka valurlje alu apăj ăntră marje oluje. Păntruv aja tot narodu osă fije mult zabrinic š ispunic ku frikă. ");
INSERT INTO ronludari_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Čak š stjaljilje p čerj osă skutirje. Lumja osă muarje d frikă š d marje užas karje osă vije p pămănt. ");
INSERT INTO ronludari_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Atunča tuată lumja osă vjadă p minje, Bijatu alu Omuluj, kum viuv p oblak ăn marje moć š ăn slavă. ");
INSERT INTO ronludari_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kănd aja tot ănčapje s dogodjaskă, avjec inimă š fic pljinj d nadă k Dimizov osă vu oslobodjaskă ăndată.” ");
INSERT INTO ronludari_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Atunča Isusu lja rubit asta vorbă: “Ujtacăvă la smokvă ili bilo d karje ljemn. ");
INSERT INTO ronludari_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kănd vidjec pupu alu smokvăj atunča š săngurj štijec k je vara apruapje. ");
INSERT INTO ronludari_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Isto aša kănd vidjec k vinje aja d čaja amrubit, atunča putjec s fic sigurni k je cara alu Dimizovuluj apruapje. ");
INSERT INTO ronludari_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Istina je zăk vuavă, asta generacija nusă trjakă pănd tot asta nu s dogudja. ");
INSERT INTO ronludari_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Čerju š pămăntu osă trjakă, ali vorba amja s rămăje zauvjek!” ");
INSERT INTO ronludari_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Isusu azăs: “Păzăcăvă š nu fic kašă lumja karje je tupavj d mamurluk š d bjarje ili briga alu životusta. Inače, aja zuvă ruavă p voj osă iznenadjaskă ");
INSERT INTO ronludari_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","kašă zamka. K osă vije p tuată lumje karje stanujaštje p pămănt. ");
INSERT INTO ronludari_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ăn tuată vrijamja păzăcăvă š rugacăvă s putjec s avjec snagă s izdržic aštja stvarurj če vinje š fic spremic s stăc la intja amja, la intja alu Bijatu alu Omuluj.” ");
INSERT INTO ronludari_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Isusu tuată zuvă ănvăca ăn Hram, š sara pljika š provodja nuaptja p djal Masline. ");
INSERT INTO ronludari_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","A tot narodu s skula dănzorja š pljika ăn Hram s puje urjajke la Isusu. ");
INSERT INTO ronludari_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","S približa Prazniku d mălaj frzdă germă. Ăsta praznik s kima š Pasha. ");
INSERT INTO ronludari_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Glavni popurlje š učitelji d zakonu alu Mojsije kăta kum s l apuče p Isusu š s l osudjaskă p muartje, ali lja fost frikă d lumje s nusă bunjaskă. ");
INSERT INTO ronludari_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ăn vrijamaja Sotona auntrat ăn Juda Iškariot karje je unu dăn jej duavăsprjače (12) apostolurj. ");
INSERT INTO ronludari_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Jel apljikat š sa dogovorit ku glavni popurlje š ku zapovidnikurlje alu stražăj d Hram kum s lja ažutje s apuče p Isusu. ");
INSERT INTO ronludari_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Jej s raduja š ja obečit k ji dă banj. ");
INSERT INTO ronludari_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Juda apristanit. Aša jel kăta bună vrijamja s lji dja p Isusu kănd lumje nusă fije upruapje. ");
INSERT INTO ronludari_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Avinjit zuva s ănčapje Prazniku d mălaj frzdă germă, kănd s žrtvujaštje vuaje d vičeră alu Pasha. ");
INSERT INTO ronludari_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Isusu atrimjes p Petar š p Ivan: “Fuđic š pripremic vičera alu Pasha s mănkăm una.” ");
INSERT INTO ronludari_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Učenikurlje antribat p Isusu: “Undje vrjaj s mănkăm?” ");
INSERT INTO ronludari_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Lji zăče aša: “Čim untrăc ăn trg Jeruzalem, osă vu sretnjaskă unu om karje aduče apă ăn bukal. Fuđic dăpă jel ăn kasă karje untră ");
INSERT INTO ronludari_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","š zăčec alu domačinuluj: ‘Učitelju ăntrijabă ăn karje sobă puatje s mălănče vičera alu Pasha ku učenikurlje aluj.’ ");
INSERT INTO ronludari_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Jel osă vu ratje marje sobă p kat, karje spremită. Ačija pripremic vičera.” ");
INSERT INTO ronludari_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Petar š Ivan sa dus ăn trg š jej angăsăt tot kum Isusu lja zăs š ačija apriprimit vičera alu Pasha. ");
INSERT INTO ronludari_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kănd avinjit vrijamja d vičeră alu Pasha, Isusu alat loku la astal ku apostoli. ");
INSERT INTO ronludari_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jel azăs: “Amčeznit ku tot sufljetu s mălănk ku voj asta vičera alu Pasha majdată d muka amja. ");
INSERT INTO ronludari_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Vu zăk k nu maj mălănk vičera alu Pasha pănd nu vinja zuva s s mălănče ăn cara alu Dimizov.” ");
INSERT INTO ronludari_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Atunča alat paru ku vinu, azahvaljit alu Dimizov š zăče: “Lăc š podjeljic vinu ăntră voj. ");
INSERT INTO ronludari_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Vu zăk d akuša nu maj bjav vin pănd nu vinje cara alu Dimizovuluj.” ");
INSERT INTO ronludari_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Atunča alat mălaju š zahvaljit alu Dimizov, la frănt š la dat alu učenikulor, š azăs: “Asta je tjela amja karje s predajaštje d voj. Mănkac asta mije d spomen.” ");
INSERT INTO ronludari_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Dăpă vičeră, aša alat š paru ku vinu š azăs: “Asta je sănđilje alu mjov karje s varsă kašă žrtva d voj. Ku sănđilje alu mjov Dimizov fače novi savez ku narodu aluj. ");
INSERT INTO ronludari_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Pănglă tot jakă, izdajniku alu mjov šadje ku minje la astal. ");
INSERT INTO ronludari_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Jo, Bijatu alu Omuluj, mora s mor kum je odredit, ali grjev alu ăla karje izdajaštje p minje!” ");
INSERT INTO ronludari_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Učenikurlje ănčapje ăntră jej s ăntrijabă činje dăn jej putja s fakă aša rov. ");
INSERT INTO ronludari_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Učenikurlje ančiput s s prepirjaskă d aja činje dăn jej arfi maj marje. ");
INSERT INTO ronludari_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Isusu azăs: “Carulje alu pămăntusta vladjaštje p narodu alor š provodjaštje vlastu p jej. Š ălja carurj vrja s lji faljaskă narodu k je maj bunj. ");
INSERT INTO ronludari_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ali voj nu fičec kašă jej! Naprotiv, maj marje ăntră voj s fije kašă ăla maj mik, a vođa kašă argatu. ");
INSERT INTO ronludari_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Mi zăčec, činje je maj marje, ăla karje šadje la astal ili ăla karje l služaštje? Ăla la astal, dănă? Ali nu ăntră voj, k, jakă, jo sănt ăntră voj kašă argatu. ");
INSERT INTO ronludari_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Voj afost pănglă minje ăn kušnjilje alji mjalje. ");
INSERT INTO ronludari_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Vu dauv s vladic ăn cara alu Dimizov, kašă Tatimjov ăn čerj če ma dat mije. ");
INSERT INTO ronludari_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Voj osă mănkăc š osă bijec la astalu mjov ăn cara amja. Osă šidjec p prijestolje š osă vladic p duavăsprjače (12) sămăncje alu Izrael.” ");
INSERT INTO ronludari_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Isusu azăs: “Šimune, Šimune, Sotona ačirut s puată s iskušaskă vjera avuastră kašă omu karje prosijaštje gruvu. ");
INSERT INTO ronludari_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ali mam rugat d tinje vjera ata s c nu nistanjaskă. Aša, kănd t torč mije, učvrstjaštje vjera alu alc učenikurlje!” ");
INSERT INTO ronludari_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Petar azăs: “Domnulje, jo sănt spremit s pljek ku tinje ăn tamnică š ăn muartje!” ");
INSERT INTO ronludari_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Isusu azăs: “C zăk, Petre, majdată če kukošu mănje diminjacă kăntă, d trje (3) vorj osă t odriknještj k uopće m kunoštj.” ");
INSERT INTO ronludari_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Isusu lji ăntrjabă: “Kănd p voj atrimjes p drum frzdă banj, frzdă tašnă š sandalje, dali vuavă čiva afaljit?” Jej odgovorit: “Na faljit.” ");
INSERT INTO ronludari_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Isusu azăs: “Ali akuša, činje arje banj, săla dukă! Tašna isto! Činje narje mač, s vindă cualjilje š s kumpră d jel. ");
INSERT INTO ronludari_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kvu zăk, mora s ispunjaskă aja če d minje skrije ăn Svăntă pismă: ‘L smatrja k je zločinac.’ Tot če prorokurlje askris d minje uskoro osă s ispunjaskă.” ");
INSERT INTO ronludari_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Jej azăs: “Domnulje, avjem ačija doj (2) mačurj!” Isusu azăs: “Dăstul je! Nu maj rubic d aja.” ");
INSERT INTO ronludari_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Atunča Isusu sa dus dăn trg š apljikat, kašă obično, p Maslinskă goră. Učenikurlje sa dus dăpă jel. ");
INSERT INTO ronludari_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Kănd ažuns, lji zăče: “Rugăcăvă s nu kidjec ăn kušnje!” ");
INSERT INTO ronludari_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Sa udaljit dăla jej otprilike kăt puatje buluvanu s s arunče. A kleknit š sa rugat: ");
INSERT INTO ronludari_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Tato, akă tu vrjaj, uklonjaštje asta dăla minje s nu bjav dăn parusta d patjală! Ipak, s fije kum vrjaj tu, a nu kum vrjauv jo.” ");
INSERT INTO ronludari_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Š atunča ji sa pokazăt anđelu š la fukut maj capăn. ");
INSERT INTO ronludari_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tot če maj tarije sa rugat, ăn marje munkă, a znoju ji postanjaštje kašă kaplja dăn sănđe ča kăzut p pămănt. ");
INSERT INTO ronludari_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Kănd azavršăt ku rugala sa skulat, sa tors la učenikurj š lja găsăt kum s kulkă, iscrpic d žalost. ");
INSERT INTO ronludari_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Isusu lji ăntrjaba: “Dăče vu kulkăc? Skulăc š rugăcăvă s nu kidjec ăn kušnje!” ");
INSERT INTO ronludari_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Pănd Isusu arubit, sa pojavit mult lumje, karje lja dus Juda, unu dăn jej duavăsprjače (12) apostolurj. S približa la Isusu š la pozdravit ku poljubacu ăn falkă. ");
INSERT INTO ronludari_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Isusu aluj azăs: “Juda, dali ku poljubacu izdaještj p minje, p Bijatu alu Omuluj?” ");
INSERT INTO ronludari_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Kănd učenikurlje avizut če s spremjaštje, jej azăs: “Domnulje, s lji napadnim ku mačurlje?” ");
INSERT INTO ronludari_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Š unu dăn jej aluvit p argatu alu marje popăj š ja tijat dirjapta urjajke. ");
INSERT INTO ronludari_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ali Isusu azăs: “Lji dopustic! Nu vu odupiric više!” A dirit alu argatuluj urjajka š la iscjelit. ");
INSERT INTO ronludari_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Atunča azăs alu lumjej karje avinjit s la puče, alu glavni popilor, stražari alu hramuluj š vođilje alu židovilor: “Aspljikat p minje ku mačurlje š ku toljagurlje ka p pobunjenik! ");
INSERT INTO ronludari_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Dăče nu mas pukat ăn Hram? Tuată zuva irjam ănklo ku voj. Ali asta je trenutku alu vostru vrijamja kănd vladjaštje săla alu nuaptjej.” ");
INSERT INTO ronludari_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","P Isusu la apukat čuvari š la dus ăn kasă alu marje popăj. A Petar lji pratja. ");
INSERT INTO ronludari_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ăn mižlokuluj d bătutură stražari aprins fok š jej karje irja aiča sa ănklăzăt pănglă ja. Petar ašăžut ku jej. ");
INSERT INTO ronludari_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Njeka argata s ujtă kum jel šadje pănglă fok, l sljedjaštje š zăče: “Š ăsta irja ku omusta karje pukat!” ");
INSERT INTO ronludari_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","A Petar sa odriknit: “Pa jo nič k l kunoskă, mujarjo!” ");
INSERT INTO ronludari_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Nješta maj ănklo, njeko altu la vizut š azăs: “Š tu ješt unu dăn jej!” Petar aodgovorit: “Nu sănt, omulje!” ");
INSERT INTO ronludari_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Dăpă otprilike unu sat, njeko altu tvrdja: “Ăsta om zaista irja ku jel k jel je d regija Galileja, kašă š Isusu p karje la pukat!” ");
INSERT INTO ronludari_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Petar azăs: “Nu štiv d čaja rubještj, omulje!” Ăn trenula, pănd još arubit, akăntat kukošu. ");
INSERT INTO ronludari_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Atunča Domnu Isusu s okrinjaštje š s ujtă p Petar, a Petar sa dat d gănd kum ja zăs Isusu: “Ăn diminjacă, majdată če kukošu kăntă, d trje (3) vorj osă t odriknještj k uopće m kunoštj.” ");
INSERT INTO ronludari_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Aišăt Petar dăn bătutură š aplăns amară. ");
INSERT INTO ronludari_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Čuvari ančiput s s ljađe d Isusu š s l bată. ");
INSERT INTO ronludari_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Jej ja ănviljit vojki š ja zăs: “Tu ješt proroku. Spunje činje ta butut!” ");
INSERT INTO ronludari_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","L vridja još maj mult ku altje vorbje urătje. ");
INSERT INTO ronludari_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kănd sa spart zuva, sa străns Vječa amarje alu Židovilor. Aja afost vođilje alji bătărnj karje afost glavni popurlje š učitelji d zakonu alu Mojsije. Čuvari adus p Isusu la jej ");
INSERT INTO ronludari_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","š ja zăs: “Spunje nuavă dali tu ješt Kristu.” Isusu zăče: “Akă vu zăk k sănt, nusă mi kridjec, ");
INSERT INTO ronludari_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","akă vu ăntrijeb nješta, osă nu mi zăčec. ");
INSERT INTO ronludari_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ipak jo, Bijatu alu Omuluj, ăndată osă šăg p lok d čast š d moć pănglă Dimizov.” ");
INSERT INTO ronludari_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Kănd auzăt aja, toc jej astrigat: “Dal tvrdješt k ješt Bijatu alu Dimizovuluj?” Lja zăs: “Aša je kum voj aja zăčec.” ");
INSERT INTO ronludari_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","P aja jej azăs: “Če maj fičem ku još dokazurj? Aja săngurj noj auzăt dăn gura aluj!” ");
INSERT INTO ronludari_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Atunča tuată Vječa amarje sa skulat š jej adus p Isusu la Pilat karje je upravitelju alu rimuluj. ");
INSERT INTO ronludari_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ačija jej ančiput s l optužaskă: “Noj apukat p omusta kum vrja s stričje p lumja anuastră. Rubjaštje nuavă s nu platim porezu alu caruluj alu Rimuluj, a d jel tvrdjaštje k je Kristu, caru.” ");
INSERT INTO ronludari_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilat antribat p Isusu: “Ješt tu caru alu Židovilor?” Isusu azăs: “Aša je kum tu aja zăč.” ");
INSERT INTO ronludari_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilat atunča zăče alu glavni popilor š alu naroduluj: “Jo nam găsăt k omusta na fukut nimika rov.” ");
INSERT INTO ronludari_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ali jej ănčapje još maj mult s navaljaskă: “Jel ănvacă p lumja ăn tot pămăntu alu nostru š lji navadjaštje p pobună! Ančiput ăn Galileja š avinjit tot pănla aiča ăn Jeruzalem!” ");
INSERT INTO ronludari_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Kănd Pilat auzăt aja, antribat: “Pa dali je jel d regija Galileja?” ");
INSERT INTO ronludari_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Kănd jej azăs: “Da”, Pilat atrimjes p Isusu la Herod, karje vladjaštje p Galileja. Herod baš atunča sa găsăt ăn Jeruzalem. ");
INSERT INTO ronludari_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Kănd Herod avizut p Isusu, mult sa bukurat d aja k d jel mult auzăt. D multă vrijamje Herod avrut s l vjadă d aja če s nadja k pănglă jel osă fakă čudă. ");
INSERT INTO ronludari_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Jel antribat p Isusu pitanje dăpă pitanje, ali Isusu p ničunu pitanje na odgovorit. ");
INSERT INTO ronludari_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Glavni popurlje š učitelji d zakonu alu Mojsije astat ačija š ku nikižala la optužăt. ");
INSERT INTO ronludari_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herod š vuastja aluj s ljiga d Isusu š rădja d jel. L ănbrakă ăn cualje d carurj š l trimjatje ăndrăt la Pilat. ");
INSERT INTO ronludari_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Herod š Pilat, karje irja dušmanj, ăn zuvaja apostanit ortač. ");
INSERT INTO ronludari_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilat akimat la jel p glavni popurlje, p vođilje alu židovilor š p lumja ");
INSERT INTO ronludari_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","š lja azăs: “Mas dus p omusta p optužbă k adrikat pobună ăntră lumja. Lam ispitujit pănglă voj, ali nam vizut divina d karje las optužăt. ");
INSERT INTO ronludari_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nič Herod na găsăt divina aluj š aša la trimjes ăndrăt la noj. Ăsta om na fukut nimika s zaslužaskă kaznă d muartje. ");
INSERT INTO ronludari_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Atunča osă lji zăk s l bată ku biču, š atunča l las.” ");
INSERT INTO ronludari_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","18","Ali toc ăn unu glas astrigat: “P jel umuară, a lasinje p Baraba!” ");
INSERT INTO ronludari_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Baraba irja ăn kisuarje daja če irja umješăt ăn pobună ăn Jeruzalem š daja ča murăt. ");
INSERT INTO ronludari_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilat jar sa obratit alu toc k avrut s oslobodjaskă p Isusu. ");
INSERT INTO ronludari_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ali jej astat s striđje: “Razapnjaštălăj! Razapnjaštălăj!” ");
INSERT INTO ronludari_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilat sa obratit š d trje (3) vorj: “Ali d karje rov afukut? Nam utvrdit k afukut nimika če zaradjaštje kaznă d muartje. Zăk s l bată ku biču, š atunča l las.” ");
INSERT INTO ronludari_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ali, jej š maj dăpartje astrigat š akătat s l razapnjaskă. Jej napokon adobidit aja če jej avrut. ");
INSERT INTO ronludari_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilat aodlučit s fakă p voja alor. ");
INSERT INTO ronludari_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Oslobodit p ăla karje afost ăn kisuarje dăn pobună š daja ča murăt, k jel irja omu p karje avrut Pilat s l oslobodjaskă. A p Isusu la predajit la vuastja aluj s l umuarje kum toc avrut. ");
INSERT INTO ronludari_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Vuastja aduče p Isusu ku kruča p umirje aluj. Pănd jej pljika, apukat p njeki om dăn Cirena karje s kima Šimun karje sa tors d sat š ja pus p umirje kruča s la dukă dăpă Isusu. ");
INSERT INTO ronludari_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Dăpă Isusu apljikat multă lumje š multă mujerj karje aplăns š tuguja. ");
INSERT INTO ronludari_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ali Isusu s okrinjaštje kătri jej š lja zăs: “Mujeri d Jeruzalem, nu plănđec d minje, njego d voj š d kupi alji voštri. ");
INSERT INTO ronludari_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","K vinje zăljilje kănd osă s rubjaskă: ‘Blago alu mujerilor karje narje kupi. Blago alu mujerilor karje na fukut, š alu amižduavje tjepturj karje na supt!’ ");
INSERT INTO ronludari_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ăn aja vrijamje lumja osă zăkă alu planinălor: ‘Kădijec p noj’ š alu djalulor: ‘Ăviljicănje!’ ");
INSERT INTO ronludari_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Akă ăn fok ardje ljemnu vjardje, kăt osă argă još ljemnu auskat?” ");
INSERT INTO ronludari_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","A vuastja aduče š p doj (2) kriminalcurj s lji razapnjaskă ku Isusu. ");
INSERT INTO ronludari_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kănd avinjit la lok karje s kjamă Lubanja, la razapinjit, a š ku jel š p doj (2) kriminalcurj, p unu p dirjaptă alu Isusuluj, a p altu p stăngă. ");
INSERT INTO ronludari_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Isusu sa rugat: “Tato, oprostjaštălje k nu štije če fače!” Vuastja atunča arunkat kockă š aša podjeljaštje cualjilje alu Isusuluj ăntră jej. ");
INSERT INTO ronludari_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Lumja astat š toc s ujta, pănd poglavari alor sa ljigat d Isusu š lja zăs: “P alci jel aspasăt. Akuša s spasaskă săngur p jel akă je stvarno Kristu, izabraniku alu Dimizovuluj!” ");
INSERT INTO ronludari_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sa străbat š vuastja d jel. Avinjit la jel š ji nudja akru vin. ");
INSERT INTO ronludari_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Jej azăs alu Isusuluj: “Spasaštje p tinje akă ješt caru alu Židovilor!” ");
INSERT INTO ronludari_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Dăpă jel astat natpisu: “ĂSTA JE CARU ALU ŽIDOVILOR.” ");
INSERT INTO ronludari_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Unu dăn kriminalcurj karje visja p kruče l uvridja ku vorbilje: “Tu ješt Kristu, dănă? Spasaštje atunča š p tinje š p noj!” ");
INSERT INTO ronludari_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ali altu kriminalc la ukurit: “Dali nu c frikă d Dimizov? Trpještj ista kazna kašă jel. ");
INSERT INTO ronludari_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ali p pravdă je noj s trpim k noj zaslužăm kaznă d djela alu nostru. Ali omusta na fukut numik rov.” ");
INSERT INTO ronludari_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Azăs atunča: “Isusulje, kănd ănčipja s vladješt ka caru, smilujaštitje p minje.” ");
INSERT INTO ronludari_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Isusu ja zăs: “Istină c zăk: astăz osă fi ăn raj ku minje.” ");
INSERT INTO ronludari_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kănd afost njeđe duavăsprjače (12) satje, suarilje aprestanit s sajaskă š nuaptja prekrijit tot pămăntu pănla trje (3) satje posljepodne. ");
INSERT INTO ronludari_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Lumina alu suarilje anistanit, š dăturdată firjanga alu Hramuluj sa rupt p mižlok. ");
INSERT INTO ronludari_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Atunča Isusu ăntarje strigă: “Tato, predajesk sufljetu alu mjov ăn mănilje alji tjalje!” Ćim azăs aja, aslubuzăt sufljetu. ");
INSERT INTO ronludari_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Kănd kapetanu alu rimuluj avizut ča fost, ančiput s slavjaskă p Dimizov š zăča: “Omusta sigurno irja pravedan!” ");
INSERT INTO ronludari_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Maj ănklo, lumja karje afost ačija š avizut če sa dogodit sa razilazăt š s bătja ăn tjept d marje žalost. ");
INSERT INTO ronludari_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","A toc karje aštijut p Isusu š mujerilje karje avinjit dăpă jel dăn Galileja astat maj dăpartje š s ujta la tot če sa dogodit. ");
INSERT INTO ronludari_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","52","Š jakă njeki om, karje s kima Josip d Arimateja, trgu ăn Judeja, apljikat la Pilat š akătat s ji dja tjela alu Isusuluj. Jel afost članu d Vječa amarje alu Židovilor, ali nu sa slažăt ku jej daja ča pukat š osudit p Isusu p muartje. Jel afost bun š pravedan om karje štipta cara alu Dimizov. ");
INSERT INTO ronludari_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Š Josip askinit tjela alu Isusuluj dăpă kruče, š l umotjaštje ăn skumpă albă plahtă š l punje ăn gruapă isklesătă ăn stijenă, ăn karje još nimilja nuje ăngrupat. ");
INSERT INTO ronludari_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Suarilje kădja, š sămbăta samo če na vinjit. ");
INSERT INTO ronludari_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Mujerilje karje avinjit ku Isusu dăn Galileja, apljikat dăpă Josip š avizut undje gruapa š ča fukut ku tjela alu Isusuluj. ");
INSERT INTO ronludari_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Atunča sa tors akasă s pripremjaskă jarbilje š ulje karje miruasă d tjela. Sămbătă sa udinit, d aja k poštuja zakonu alu Mojsije. ");
INSERT INTO ronludari_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Dănzorja ăn duminikă mujeri apljikat la gruapă ku jarbilje š ku unturilje karje miruasă če lja pripremit. ");
INSERT INTO ronludari_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Kănd jalje ažuns, avizut k je buluvanu karje ăvilja ulazu la gruapă runkat ăn partje. ");
INSERT INTO ronludari_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Auntrat ănontru, ali na găsăt tjela alu Domnuluj Isusuluj. ");
INSERT INTO ronludari_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Pănd jalje aša astat zbunjitje păntruv aja če sa dogodit, dăturdată pănglă jej sa pojavit doj (2) omurj ăn cualje karje blistjaštje. ");
INSERT INTO ronludari_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Mujerilje sa spirjat š sa poklonit ku lica kătri pămănt. Doj (2) omurj lja tribat: “Dăče kătăc p viuv ăntră morc? ");
INSERT INTO ronludari_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nuje aiča. Auskrăsnit! Dali nu vu găndic če vam zăs još ăn Galileja: ");
INSERT INTO ronludari_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Jo, Bijatu alu Omuluj, mora s fiuv predajit ăn mănj alu grešnikulor š jej p minje osă m razapnjaskă, ali jo aldă trje (3) zălje osă m skol dăla morc.’” ");
INSERT INTO ronludari_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Jalje sa dat d gănd k Isusu aja azăs. ");
INSERT INTO ronludari_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Š sa tors dăla gruapă s javjaskă alu unsprjače (11) apostolurj š alu toc alcilor. ");
INSERT INTO ronludari_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Irja alja Marija d trg Magdala, Ivana š Marija, mama alu Jakov, š još njeke mujerj. Arubit tot alu apostolilor če sa dogodit, ");
INSERT INTO ronludari_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ali alu apostolilor sa spurut k tot aja mujerj aizmislit. Š nu lja krizut alu mujerilor. ");
INSERT INTO ronludari_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ipak, Petar dă fuga pănla gruapă. Kănd ažuns, s ujtă ănontru ali na vizut nimika osim skumpă albă plahtă ăn karje irja Isusu. Apljikat dăla gruapă š s ăntriba če sa dogodit. ");
INSERT INTO ronludari_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ăn zuvaja doj (2) učenikurj alu Isusuluj pljakă ăn sat Emaus, dăpartje d Jeruzalem njeđe unsprjače (11) kilomjatrje. ");
INSERT INTO ronludari_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","P drum arubit d tot ča fost. ");
INSERT INTO ronludari_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Pănd jej aša arubit š raspravlja ăntră jej, avinjit Isusu š pljakă ku jej. ");
INSERT INTO ronludari_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ali alu vojki alor irja skuns s l kunaskă. ");
INSERT INTO ronludari_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Isusu lja antribat: “D čaja aja raspravljic pănd putujic?” Jej astat pljinj d tugă. ");
INSERT INTO ronludari_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Unu dăn jej, karje s kjamă Kleofa, ja odgovorit: “Tu ješt jedini om karje avinjit d praznik ăn Jeruzalem karje nu štije ča fost ăn zuviljaštja.” ");
INSERT INTO ronludari_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Isusu ăntrijabă: “Če afost?” Azăs: “Pa aja ča fost ku Isusu dăn Nazaret. Jel irja proroku š tuată lumja aputut s vjadă ku vorbilje š ku djela aluj k la trimjes Dimizov. ");
INSERT INTO ronludari_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Pănglă aja glavni popurlje š alji noštri altje članurlje alu vječe Amarje la predajit s fije osudit p muartje š la dat s l razapnjaskă. ");
INSERT INTO ronludari_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","A noj njam nadit k jel ăla karje osă spasaskă p narodu alu Izrael dăla dušmanu aluj, već atrikut trje (3) zălje d kănd je mort. ");
INSERT INTO ronludari_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ali aja nuje tot k š njeke mujeri karje l pratja ku toc noj, nja zbunjit p noj: čim asvanit zuva jalje apljikat la gruapă, ");
INSERT INTO ronludari_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ali ačija na găsăt tjela aluj. Avinjit š azăs k lji sa pokazăt anđelurlje š lja zăs k Isusu viuv. ");
INSERT INTO ronludari_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Njeki dăn noj adat fuga la gruapă š angăsăt k je gruapa guală baš kum azăs mujerilje, ali na vizut p Isusu k je viuv.” ");
INSERT INTO ronludari_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","P aja Isusu lja zăs: “O kum ištjec nerazumni! Dăče vuavă grjev s kridjec ăn aja ča zăs prorokurlje? ");
INSERT INTO ronludari_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Dali nu tribja Kristu s trpjaskă tot majdată njego če s ănčapje s vladjaskă p toc?” ");
INSERT INTO ronludari_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Aša Isusu lja objasnit tot če Mojsije š toc prorokurlje azăs ăn Svăntă pismă d jel. ");
INSERT INTO ronludari_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kănd avinjit upruapje d sat undje pljakă, Isusu sa fukut k vrja s pljače maj dăpartje. ");
INSERT INTO ronludari_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ali jej la nagovorit: “Rămăj ku noj! Već je sara. Vinje nuaptja!” Aša auntrat ăn kasă s rămăje ku jej. ");
INSERT INTO ronludari_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Pănd afost ku jej la astal, Isusu alat mălaju, zahvaljit alu Dimizovuluj, la frănt š la dat alor. ");
INSERT INTO ronludari_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Atunča alor sa diškis vojki š jej la kunuskut. Ali jel la vojki alor anistanit. ");
INSERT INTO ronludari_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","A jej azăs unu alu altuluj: “Kum nja fost pljinje inimilje kănd p drum rubja ku noj š nji objasnja Svănta pisma!” ");
INSERT INTO ronludari_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Sa skulat š sa tors ăn Jeruzalem. Apljikat la lok undje sa străns unsprjače (11) apostolurj š p alcă sljedbenikurj alu Isusuluj. ");
INSERT INTO ronludari_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Jej zăče: “Istina je, Domnu Isusu auskrisnit. Sa ukazăt alu Šimunuluj!” ");
INSERT INTO ronludari_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Atunča š ăštja alji doj (2) rubja če sa dogodit p drum š kum akunuskut p Isusu pănd jel afrănt mălaju. ");
INSERT INTO ronludari_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Pănd jej doj (2) rubja, Isusu dăturdată astat ăntră jej toc. Lji zăče: “Mir vuavă!” ");
INSERT INTO ronludari_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ali lja afost frikă daja če găndit k vjadje măroj. ");
INSERT INTO ronludari_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Š Isusu lji zăče: “Dăče vu frikă? Dăče ăn voj s fače sumnje ăn inimă?” ");
INSERT INTO ronludari_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","40","Atunča lja arătat mănjilje š pičuarilje š azăs: “Ujtacăvă la rănj! Jo sănt aja! Punjec mănilje p minje š osă vidjec! Măroji narje karnje š vuasă kašă če lji am jo!” ");
INSERT INTO ronludari_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","A jej d radost na putut s krjadă alu vojki alor, njego sa mirat. Jel ăntrijabă: “Avjec čiva d mănkat?” ");
INSERT INTO ronludari_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ja dat krod d pjaštje pržăt, ");
INSERT INTO ronludari_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","a jel l ja š mălănk pănglă jej. ");
INSERT INTO ronludari_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Atunča zăče: “Asta če sa dogodit upravo aja če vam zăs k osă dogodjaskă. Pănd majdată amfost ku voj, vam zăs: atribut s s ispunjaskă tot če skrije d minje ăn zakonu alu Mojsije, ăn knjige d prorokurj š ăn Psalmi.” ");
INSERT INTO ronludari_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Atunča lja žutat s razumjaskă čije skris ăn Svăntă pismă. ");
INSERT INTO ronludari_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Kănd azavršăt jel azăs: “Kašă kum vidjec, aša skrije ăn Svăntă pismă k jo, Kristu, trjebje s trpjesk š s mor š aldă trje (3) zălje s m skol dăla morc ");
INSERT INTO ronludari_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","š ku autoritetu alu mjov s rubjaskă alu tuată lumja k trjebje s s okrinjaskă dăla grešală š Dimizov osă lji oprostjaskă grešala. Osă ănčipjec ăn Jeruzalem ");
INSERT INTO ronludari_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","s zăčec alu alcilor aja če voj auzăt š avizut dăla minje. ");
INSERT INTO ronludari_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","A jo osă vu trimjet p Sufljetu alu Svăntuluj, p karje Tatimjov ăn čerj aobečit k vuavă osă vije. Răminjec ăn trg Jeruzalem pănd Dimizov nu trimjatje p voj săla d sus!” ");
INSERT INTO ronludari_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Isusu atunča askos p učenikurlje aluj d trg Jeruzalem pănla lok upruapje d sat Betanija. Ănklo adrikat mănilje š sa rugat s lji blagoslovjaskă Dimizov. ");
INSERT INTO ronludari_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Pănd lja blagoslovit, Isusu afost drikat p čerj tot pănd nu lja nistanit dăn vojk. ");
INSERT INTO ronludari_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Učenikurlje sa poklonit la Isusu, a atunča jej sa tors ku marje radost ăn Jeruzalem. ");
INSERT INTO ronludari_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Atunča irja stalno ăn Hram š slavja p Dimizov. ");
ALTER TABLE ronludari_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
