﻿USE sofia;
DROP TABLE IF EXISTS sofia.ronlsb_vpl;
CREATE TABLE ronlsb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ronlsb_vpl WRITE;
INSERT INTO ronlsb_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Cartea genealogiei lui Isus Hristos, fiul lui David, fiul lui Avraam. ");
INSERT INTO ronlsb_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Avraam a devenit tatăl lui Isaac. Isaac a devenit tatăl lui Iacov. Iacov a devenit tatăl lui Iuda și al fraților săi. ");
INSERT INTO ronlsb_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Iuda a devenit tatăl lui Pereț și al lui Zerah prin Tamar. Perez a devenit tatăl lui Hezron. Hezron a devenit tatăl lui Berbec. ");
INSERT INTO ronlsb_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Berbec a devenit tatăl lui Aminadab. Amminadab a devenit tatăl lui Nahșon. Nahșon a devenit tatăl lui Salmon. ");
INSERT INTO ronlsb_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon a devenit tatăl lui Boaz prin Rahab. Boaz a devenit tatăl lui Obed prin Rut. Obed a devenit tatăl lui Isai. ");
INSERT INTO ronlsb_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isai a devenit tatăl regelui David. Regele David a devenit tatăl lui Solomon prin cea care fusese soția lui Urie. ");
INSERT INTO ronlsb_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon a devenit tatăl lui Roboam. Roboam a devenit tatăl lui Abia. Abiia a devenit tatăl lui Asa. ");
INSERT INTO ronlsb_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa a devenit tatăl lui Iosafat. Iosafat a devenit tatăl lui Ioram. Ioram a devenit tatăl lui Ozia. ");
INSERT INTO ronlsb_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ozia a devenit tatăl lui Iotam. Iotam a devenit tatăl lui Ahaz. Ahaz a devenit tatăl lui Ezechia. ");
INSERT INTO ronlsb_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezechia a devenit tatăl lui Manase. Manase a devenit tatăl lui Amon. Amon a devenit tatăl lui Iosia. ");
INSERT INTO ronlsb_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Iosia a devenit tatăl lui Ieconia și al fraților săi în timpul exilului în Babilon. ");
INSERT INTO ronlsb_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","După exilul în Babilon, Ieconia a devenit tatăl lui Șealtiel. Șealtiel a devenit tatăl lui Zorobabel. ");
INSERT INTO ronlsb_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel a devenit tatăl lui Abiud. Abiud a devenit tatăl lui Eliachim. Eliachim a devenit tatăl lui Azor. ");
INSERT INTO ronlsb_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor a devenit tatăl lui Țadoc. Țadoc a devenit tatăl lui Achim. Achim a devenit tatăl lui Eliud. ");
INSERT INTO ronlsb_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud a devenit tatăl lui Eleazar. Eleazar a devenit tatăl lui Matan. Mathan a devenit tatăl lui Iacov. ");
INSERT INTO ronlsb_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Iacov a devenit tatăl lui Iosif, soțul Mariei, din care s-a născut Isus, care se numește Hristos. ");
INSERT INTO ronlsb_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Astfel, toate generațiile de la Avraam până la David sunt de paisprezece generații; de la David până la exilul în Babilon, paisprezece generații; și de la exilul în Babilon până la Hristos, paisprezece generații. ");
INSERT INTO ronlsb_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Iată cum a fost nașterea lui Isus Hristos: După ce mama Lui, Maria, a fost logodită cu Iosif, înainte de a fi împreună, a fost găsită însărcinată de Duhul Sfânt. ");
INSERT INTO ronlsb_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Iosif, soțul ei, care era un om drept și care nu voia să facă din ea un exemplu public, a vrut să o renege în secret. ");
INSERT INTO ronlsb_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Dar când se gândea la aceste lucruri, iată că un înger al Domnului i s-a arătat în vis și i-a zis: “Iosif, fiul lui David, nu te teme să iei de soție pe Maria, căci ceea ce este conceput în ea este de la Duhul Sfânt. ");
INSERT INTO ronlsb_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ea va naște un fiu. Să-i pui numele Isus, căci El este cel care va mântui poporul Său de păcatele sale.” ");
INSERT INTO ronlsb_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Și toate acestea s-au întâmplat ca să se împlinească ce a spus Domnul prin proorocul care a zis, ");
INSERT INTO ronlsb_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Iată, fecioara va rămâne însărcinată, și va da naștere unui fiu. Îi vor pune numele Emanuel”. care este, fiind interpretat, “Dumnezeu cu noi”. ");
INSERT INTO ronlsb_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Iosif s-a sculat din somn, a făcut cum îi poruncise îngerul Domnului și a luat la el pe nevastă-sa, ");
INSERT INTO ronlsb_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","și n-a cunoscut-o până ce n-a născut pe fiul ei cel întâi născut. I-a pus numele Isus. ");
INSERT INTO ronlsb_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Pe când se născuse Isus în Betleemul Iudeii, în zilele împăratului Irod, iată că au venit la Ierusalim niște înțelepți de la răsărit, care ziceau: ");
INSERT INTO ronlsb_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Unde este Cel ce S-a născut Împărat al Iudeilor? Căci am văzut steaua Lui la răsărit și am venit să ne închinăm Lui”. ");
INSERT INTO ronlsb_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Regele Irod, când a auzit aceasta, s-a tulburat și tot Ierusalimul împreună cu el. ");
INSERT INTO ronlsb_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Adunând pe toți preoții cei mai de seamă și pe cărturarii poporului, i-a întrebat unde se va naște Hristosul. ");
INSERT INTO ronlsb_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ei i-au răspuns: “În Betleemul Iudeii, căci așa este scris prin profet, ");
INSERT INTO ronlsb_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Tu, Betleem, țară a lui Iuda, nu sunt cu nimic mai prejos printre căpeteniile lui Iuda; pentru că din tine va ieși un guvernator care va păstori poporul Meu, Israel.”” ");
INSERT INTO ronlsb_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Irod a chemat pe ascuns pe înțelepți și a aflat de la ei la ce oră a apărut steaua. ");
INSERT INTO ronlsb_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","I-a trimis la Betleem și le-a zis: “Mergeți și căutați cu grijă pruncul. Când îl veți găsi, aduceți-mi vestea, ca să vin și eu să mă închin lui.” ");
INSERT INTO ronlsb_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ei, după ce au auzit pe rege, au plecat; și iată că steaua pe care o văzuseră la răsărit mergea înaintea lor, până ce a venit și s-a oprit deasupra locului unde era pruncul. ");
INSERT INTO ronlsb_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Când au văzut steaua, s-au bucurat cu bucurie nespus de mare. ");
INSERT INTO ronlsb_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Au intrat în casă și au văzut Pruncul cu Maria, mama Lui, și au căzut jos și I s-au închinat. Deschizându-și comorile, i-au oferit daruri: aur, tămâie și smirnă. ");
INSERT INTO ronlsb_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Fiind avertizați în vis să nu se întoarcă la Irod, s-au întors în țara lor pe un alt drum. ");
INSERT INTO ronlsb_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","După ce au plecat, iată că un înger al Domnului s-a arătat în vis lui Iosif și i-a zis: “Scoală-te, ia Pruncul și pe mama lui și fugi în Egipt și rămâi acolo până ce-ți voi spune, căci Irod va căuta Pruncul ca să-l nimicească.” ");
INSERT INTO ronlsb_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","S-a sculat, a luat noaptea pe prunc și pe mama lui și a plecat în Egipt, ");
INSERT INTO ronlsb_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","și a stat acolo până la moartea lui Irod, ca să se împlinească ce spusese Domnul prin proorocul care zicea: “Din Egipt am chemat pe fiul Meu”. ");
INSERT INTO ronlsb_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Atunci Irod, văzând că este batjocorit de magi, s-a mâniat foarte tare și a trimis să ucidă pe toți copiii de parte bărbătească din Betleem și din toată ținutul din jur, de la doi ani în jos, după timpul exact pe care-l aflase de la magi. ");
INSERT INTO ronlsb_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Atunci s-a împlinit ceea ce fusese spus prin profetul Ieremia, care zicea așa ");
INSERT INTO ronlsb_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“S-a auzit o voce în Rama, jale, plâns și jale mare, Rahela plângând pentru copiii ei; ea nu ar fi fost consolată, pentru că ei nu mai sunt.” ");
INSERT INTO ronlsb_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","După ce a murit Irod, iată că un înger al Domnului s-a arătat în vis lui Iosif în Egipt, zicând: ");
INSERT INTO ronlsb_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Scoală-te, ia Pruncul și pe mama lui și du-te în țara lui Israel, căci cei care căutau viața Pruncului au murit.” ");
INSERT INTO ronlsb_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Și s-a sculat, a luat pruncul și pe mama lui și a venit în țara lui Israel. ");
INSERT INTO ronlsb_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Dar, când a auzit că Arhelau domnea în Iudeea în locul tatălui său, Irod, s-a temut să meargă acolo. Fiind avertizat în vis, s-a retras în regiunea Galileii ");
INSERT INTO ronlsb_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","și a venit și a locuit într-o cetate numită Nazaret, ca să se împlinească ceea ce s-a spus prin profeți, că el va fi numit Nazarinean. ");
INSERT INTO ronlsb_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","În zilele acelea, a venit Ioan Botezătorul și propovăduia în pustiul Iudeii, zicând: ");
INSERT INTO ronlsb_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Pocăiți-vă, căci Împărăția cerurilor este aproape!” ");
INSERT INTO ronlsb_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Căci acesta este cel despre care s-a vorbit prin profetul Isaia, care a spus “Glasul cuiva care strigă în pustiu, pregătiți calea Domnului! Fă-i cărările drepte!” ");
INSERT INTO ronlsb_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ioan purta haine de păr de cămilă și o curea de piele la brâu. Hrana lui era lăcuste și miere sălbatică. ");
INSERT INTO ronlsb_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Atunci a ieșit la el popor din Ierusalim, din toată Iudeea și din toată regiunea din jurul Iordanului. ");
INSERT INTO ronlsb_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Au fost botezați de el în Iordan, mărturisindu-și păcatele. ");
INSERT INTO ronlsb_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Dar când a văzut pe mulți dintre farisei și saduchei venind la botezul Său, le-a zis: “Urmași ai viperelor, cine v-a avertizat să fugiți de mânia viitoare? ");
INSERT INTO ronlsb_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","De aceea, produceți roade demne de pocăință! ");
INSERT INTO ronlsb_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nu vă gândiți în sinea voastră: “Îl avem ca tată pe Avraam!”, căci vă spun că Dumnezeu poate să-i ridice lui Avraam copii din aceste pietre. ");
INSERT INTO ronlsb_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Chiar acum securea stă la rădăcina copacilor. De aceea, orice copac care nu produce fructe bune este tăiat și aruncat în foc. ");
INSERT INTO ronlsb_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Eu vă botez în apă pentru pocăință, dar Cel ce vine după mine este mai puternic decât mine, și nu sunt vrednic să port sandalele lui. El vă va boteza în Duhul Sfânt. ");
INSERT INTO ronlsb_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Furca lui de vânat este în mâna lui și își va curăța temeinic aria de treierat. Își va strânge grâul în hambar, dar neghina o va arde cu foc nestins.” ");
INSERT INTO ronlsb_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Atunci Isus a venit din Galileea la Iordan, la Ioan, ca să fie botezat de el. ");
INSERT INTO ronlsb_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Dar Ioan ar fi vrut să-L împiedice, zicând: “Eu am nevoie să fiu botezat de tine, și tu vii la mine?” ");
INSERT INTO ronlsb_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Isus, răspunzând, i-a zis: “Îngăduie acum, căci așa se cuvine să împlinim toată dreptatea.” Atunci el i-a permis. ");
INSERT INTO ronlsb_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Isus, după ce a fost botezat, s-a suit din apă și iată că i s-au deschis cerurile. A văzut Duhul lui Dumnezeu coborând ca un porumbel și venind peste el. ");
INSERT INTO ronlsb_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Și iată, un glas din ceruri a zis: “Acesta este Fiul Meu preaiubit, cu care sunt foarte mulțumit.” ");
INSERT INTO ronlsb_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Isus a fost dus de Duhul Sfânt în pustiu, ca să fie ispitit de diavol. ");
INSERT INTO ronlsb_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","După ce a postit patruzeci de zile și patruzeci de nopți, I-a fost foame după aceea. ");
INSERT INTO ronlsb_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ispititorul a venit și i-a zis: “Dacă ești Fiul lui Dumnezeu, poruncește ca aceste pietre să se transforme în pâine”. ");
INSERT INTO ronlsb_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Iar el a răspuns: “Este scris: “Nu numai cu pâine va trăi omul, ci cu orice cuvânt care iese din gura lui Dumnezeu.”” ");
INSERT INTO ronlsb_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Atunci diavolul l-a dus în cetatea sfântă. L-a așezat pe vârful templului ");
INSERT INTO ronlsb_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","și i-a zis: “Dacă ești Fiul lui Dumnezeu, aruncă-te jos, căci este scris, “El va porunci îngerilor Săi cu privire la voi” și, 'Pe mâinile lor te vor purta, ca să nu te lovești cu piciorul de o piatră.”” ");
INSERT INTO ronlsb_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Isus i-a zis: “Iarăși este scris: “Să nu pui la încercare pe Domnul, Dumnezeul tău”.” ");
INSERT INTO ronlsb_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Diavolul l-a dus iarăși pe un munte foarte înalt și i-a arătat toate împărățiile lumii și slava lor. ");
INSERT INTO ronlsb_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","El i-a spus: “Îți voi da toate aceste lucruri, dacă vei cădea jos și te vei închina mie.” ");
INSERT INTO ronlsb_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Atunci Isus i-a zis: “Du-te de aici, Satano! Căci este scris: “Să te închini Domnului, Dumnezeului tău, și numai lui să-i slujești”.” ");
INSERT INTO ronlsb_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Atunci diavolul L-a lăsat și iată că au venit îngeri și I-au slujit. ");
INSERT INTO ronlsb_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Când a auzit Isus că Ioan fusese predat, s-a retras în Galileea. ");
INSERT INTO ronlsb_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","A plecat din Nazaret, a venit și a locuit în Capernaum, care este lângă mare, în ținutul lui Zabulon și Neftali, ");
INSERT INTO ronlsb_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ca să se împlinească ceea ce fusese spus prin profetul Isaia, care zicea:, ");
INSERT INTO ronlsb_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Țara lui Zabulon și țara lui Neftali, spre mare, dincolo de Iordan, Galileea neamurilor, ");
INSERT INTO ronlsb_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","poporul care ședea în întuneric a văzut o lumină mare; celor care stăteau în regiunea și în umbra morții, pentru ei a răsărit lumina.” ");
INSERT INTO ronlsb_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Din vremea aceea, Isus a început să propovăduiască și să zică: “Pocăiți-vă! Căci Împărăția Cerurilor este aproape”. ");
INSERT INTO ronlsb_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Și mergând pe malul mării Galileii, a văzut doi frați: Simon, numit Petru, și Andrei, fratele său, aruncând o plasă în mare, căci erau pescari. ");
INSERT INTO ronlsb_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","El le-a zis: “Veniți după Mine și vă voi face pescari de oameni.” ");
INSERT INTO ronlsb_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Și îndată și-au lăsat plasele și au mers după El. ");
INSERT INTO ronlsb_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Mergând mai departe de acolo, a văzut alți doi frați, Iacov, fiul lui Zebedei, și Ioan, fratele său, în barcă, împreună cu Zebedei, tatăl lor, reparându-și plasele. El i-a chemat. ");
INSERT INTO ronlsb_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ei au lăsat îndată barca și pe tatăl lor și l-au urmat. ");
INSERT INTO ronlsb_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Isus străbătea toată Galileea, învățând în sinagogile lor, propovăduind vestea cea bună a Împărăției și vindecând orice boală și orice neputință în popor. ");
INSERT INTO ronlsb_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Vestea despre El s-a răspândit în toată Siria. Îi aduceau la el pe toți cei care erau bolnavi, atinși de diferite boli și chinuri, posedați de demoni, epileptici și paralitici; și el îi vindeca. ");
INSERT INTO ronlsb_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","L-au urmat mari mulțimi din Galileea, din Decapole, din Ierusalim, din Iudeea și de dincolo de Iordan. ");
INSERT INTO ronlsb_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Văzând mulțimile, S-a suit pe munte. După ce a șezut, discipolii Lui au venit la El. ");
INSERT INTO ronlsb_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","El a deschis gura și i-a învățat, zicând:, ");
INSERT INTO ronlsb_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ferice de cei săraci cu duhul! pentru că a lor este Împărăția Cerurilor. ");
INSERT INTO ronlsb_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ferice de cei ce plâng! pentru că vor fi mângâiați. ");
INSERT INTO ronlsb_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ferice de cei blânzi! căci ei vor moșteni pământul. ");
INSERT INTO ronlsb_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ferice de cei ce flămânzesc și însetează după dreptate, pentru că vor fi umplute. ");
INSERT INTO ronlsb_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ferice de cei milostivi! pentru că ei vor obține îndurare. ");
INSERT INTO ronlsb_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ferice de cei cu inima curată! pentru că ei îl vor vedea pe Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Fericiți făcătorii de pace! pentru că ei se vor numi copii ai lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ferice de cei ce au fost prigoniți pentru dreptate, pentru că a lor este Împărăția Cerurilor. ");
INSERT INTO ronlsb_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ferice de voi, când vă vor ocărî, vă vor prigoni și vor zice tot felul de lucruri rele împotriva voastră, pe nedrept, din pricina Mea. ");
INSERT INTO ronlsb_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Bucurați-vă și vă veseliți, căci mare este răsplata voastră în ceruri. Căci așa au prigonit ei pe profeții care au fost înaintea voastră. ");
INSERT INTO ronlsb_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Voi sunteți sarea pământului; dar dacă sarea și-a pierdut gustul, cu ce se va săra? Atunci nu mai este bună la nimic, decât să fie aruncată afară și călcată în picioare de oameni. ");
INSERT INTO ronlsb_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Tu ești lumina lumii. O cetate situată pe un deal nu poate fi ascunsă. ");
INSERT INTO ronlsb_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nici nu aprindeți o lampă și nu o puneți sub un coș de măsurat, ci pe un stativ, și ea luminează tuturor celor care sunt în casă. ");
INSERT INTO ronlsb_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Tot așa, lumina voastră să strălucească înaintea oamenilor, ca să vadă faptele voastre bune și să slăvească pe Tatăl vostru care este în ceruri. ");
INSERT INTO ronlsb_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Să nu credeți că am venit să distrug Legea și proorocii. Nu am venit să distrug, ci să împlinesc. ");
INSERT INTO ronlsb_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Căci, cu siguranță, vă spun că, până când vor trece cerul și pământul, nici cea mai mică literă și nici cea mai mică lovitură de peniță nu va trece în vreun fel din Lege, până când toate lucrurile vor fi împlinite. ");
INSERT INTO ronlsb_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","De aceea, oricine va călca una dintre aceste porunci mai mici și va învăța pe alții să facă așa, va fi numit cel mai mic în Împărăția cerurilor; dar oricine le va împlini și le va învăța va fi numit mare în Împărăția cerurilor. ");
INSERT INTO ronlsb_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Căci vă spun că, dacă dreptatea voastră nu o va întrece pe cea a cărturarilor și a fariseilor, în niciun caz nu veți intra în Împărăția Cerurilor. ");
INSERT INTO ronlsb_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ați auzit că s-a spus celor din vechime: “Să nu ucizi!” și că “Oricine va ucide va fi supus judecății”. ");
INSERT INTO ronlsb_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Dar Eu vă spun că oricine se mânie pe fratele său fără motiv va fi în primejdie de judecată. Oricine îi va spune fratelui său: “Raca!” va fi în pericol de consiliu. Oricine îi va spune: “Prostule!” va fi în pericol de focul gheenei. ");
INSERT INTO ronlsb_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Deci, dacă îți aduci darul la altar și îți aduci aminte că fratele tău are ceva împotriva ta, ");
INSERT INTO ronlsb_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","lasă darul tău acolo, înaintea altarului, și du-te. Împăcați-vă mai întâi cu fratele vostru și apoi veniți și aduceți darul vostru. ");
INSERT INTO ronlsb_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Înțelege-te repede cu potrivnicul tău, cât timp ești cu el pe drum, ca nu cumva procurorul să te predea judecătorului, iar judecătorul să te predea ofițerului și să fii aruncat în închisoare. ");
INSERT INTO ronlsb_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Mai mult ca sigur vă spun că nu veți ieși nicidecum de acolo până nu veți plăti și ultimul bănuț. ");
INSERT INTO ronlsb_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ați auzit că s-a zis: “Să nu preacurvești!” ");
INSERT INTO ronlsb_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Dar Eu vă spun că oricine se uită la o femeie ca să o poftească, a preacurvit cu ea în inima lui. ");
INSERT INTO ronlsb_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Dacă ochiul tău drept te face să te poticnești, smulge-l și aruncă-l de la tine. Căci este mai de folos să piară unul dintre membrele tale decât ca tot trupul tău să fie aruncat în gheenă. ");
INSERT INTO ronlsb_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Dacă mâna ta dreaptă te face să te poticnești, taie-o și arunc-o departe de tine. Căci îți este mai de folos să piară unul din membrele tale, decât să fie aruncat tot trupul tău în Gheenă. ");
INSERT INTO ronlsb_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“S-a mai spus: “Oricine își va renega nevasta, să-i dea un act de divorț.” ");
INSERT INTO ronlsb_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Dar Eu vă spun că oricine își reneagă nevasta, afară de motivul desfrânării, o face adulteră; și oricine se căsătorește cu ea după ce a fost renegată, comite adulter. ");
INSERT INTO ronlsb_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ați auzit că s-a spus celor vechi: “Să nu faceți jurăminte false, ci să împliniți jurămintele voastre față de Domnul.” ");
INSERT INTO ronlsb_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Dar Eu vă spun să nu jurați deloc: nici pe cer, căci este tronul lui Dumnezeu, ");
INSERT INTO ronlsb_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","nici pe pământ, căci este așternutul picioarelor Lui, nici pe Ierusalim, căci este cetatea marelui Împărat. ");
INSERT INTO ronlsb_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Să nu juri nici pe capul tău, căci nu poți face nici un fir de păr alb sau negru. ");
INSERT INTO ronlsb_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ci să fie “Da” al tău “Da” și “Nu” al tău “Nu”. Tot ce este mai mult decât acestea este de la cel rău. ");
INSERT INTO ronlsb_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ați auzit că s-a spus: “Ochi pentru ochi și dinte pentru dinte”. ");
INSERT INTO ronlsb_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Dar Eu vă spun: Nu vă împotriviți celui rău; ci, dacă te lovește cineva peste obrazul drept, întoarce-i și celălalt obraz. ");
INSERT INTO ronlsb_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Dacă cineva te dă în judecată ca să-ți ia haina, lasă-i și haina ta. ");
INSERT INTO ronlsb_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Oricine vă silește să mergeți o milă, mergeți cu el două. ");
INSERT INTO ronlsb_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Dă-i celui care îți cere și nu refuza pe cel care vrea să se împrumute de la tine. ");
INSERT INTO ronlsb_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ați auzit că s-a spus: “Să iubești pe aproapele tău și să urăști pe vrăjmașul tău. ");
INSERT INTO ronlsb_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Dar Eu vă spun: iubiți pe vrăjmașii voștri, binecuvântați pe cei ce vă blestemă, faceți bine celor ce vă urăsc și rugați-vă pentru cei ce vă maltratează și vă prigonesc, ");
INSERT INTO ronlsb_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ca să fiți copii ai Tatălui vostru care este în ceruri. Căci El face să răsară soarele Său peste cei răi și peste cei buni și trimite ploaie peste cei drepți și peste cei nedrepți. ");
INSERT INTO ronlsb_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Căci, dacă iubiți pe cei ce vă iubesc, ce răsplată aveți voi? Oare nici măcar vameșii nu fac la fel? ");
INSERT INTO ronlsb_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Dacă nu faci decât să-ți saluți prietenii, ce faci tu mai mult decât ceilalți? Nu fac la fel și vameșii? ");
INSERT INTO ronlsb_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","De aceea, voi să fiți desăvârșiți, după cum Tatăl vostru din ceruri este desăvârșit. ");
INSERT INTO ronlsb_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Luați seama să nu faceți milostenia voastră înaintea oamenilor, ca să fiți văzuți de ei, căci altfel nu veți avea nici o răsplată de la Tatăl vostru care este în ceruri. ");
INSERT INTO ronlsb_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","De aceea, când faceți fapte de milostenie, nu sunați din trâmbiță înaintea voastră, așa cum fac ipocriții în sinagogi și pe străzi, ca să obțină slavă de la oameni. Mai mult ca sigur vă spun că ei și-au primit răsplata. ");
INSERT INTO ronlsb_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Dar când faci fapte de milostenie, nu lăsa ca mâna ta stângă să știe ce face mâna ta dreaptă, ");
INSERT INTO ronlsb_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","pentru ca faptele tale de milostenie să fie în taină; atunci Tatăl tău, care vede în taină, îți va răsplăti în mod deschis. ");
INSERT INTO ronlsb_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Când vă rugați, să nu fiți ca fățarnicii, căci lor le place să stea în picioare și să se roage în sinagogi și la colțurile străzilor, ca să fie văzuți de oameni. Mai mult ca sigur, vă spun, ei și-au primit răsplata. ");
INSERT INTO ronlsb_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Dar tu, când te rogi, intră în camera ta interioară și, după ce ți-ai închis ușa, roagă-te Tatălui tău, care este în ascuns; și Tatăl tău, care vede în ascuns, îți va răsplăti în mod deschis. ");
INSERT INTO ronlsb_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Când vă rugați, nu folosiți repetări deșarte, așa cum fac neamurile, căci ele cred că vor fi auzite pentru vorbăria lor multă. ");
INSERT INTO ronlsb_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","De aceea, nu fiți ca ei, căci Tatăl vostru știe de ce aveți nevoie, înainte ca voi să i le cereți. ");
INSERT INTO ronlsb_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Rugați-vă astfel: “Tatăl nostru care ești în ceruri, fie ca numele Tău să fie păstrat sfânt. ");
INSERT INTO ronlsb_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Să vină Împărăția Ta! Facă-se voia Ta, precum în cer așa și pe pământ. ");
INSERT INTO ronlsb_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Dă-ne astăzi pâinea noastră cea de toate zilele. ");
INSERT INTO ronlsb_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Iartă-ne datoriile noastre, așa cum și noi iertăm datornicilor noștri. ");
INSERT INTO ronlsb_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nu ne duce pe noi în ispită, ci izbăvește-ne de cel rău. Căci a Ta este Împărăția, puterea și slava în veci. Amin. ");
INSERT INTO ronlsb_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Căci, dacă veți ierta oamenilor greșelile lor, și Tatăl vostru ceresc vă va ierta vouă. ");
INSERT INTO ronlsb_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Dar dacă nu veți ierta oamenilor greșelile lor, nici Tatăl vostru nu vă va ierta greșelile voastre. ");
INSERT INTO ronlsb_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Și când postiți, să nu fiți ca fățarnicii, cu fețele triste. Căci ei își desfigurează fețele ca să fie văzuți de oameni că postesc. Mai mult ca sigur vă spun că ei și-au primit răsplata. ");
INSERT INTO ronlsb_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Dar voi, când postiți, ungeți-vă capul și spălați-vă pe față, ");
INSERT INTO ronlsb_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","astfel încât să nu vă vadă oamenii că postiți, ci Tatăl vostru, care este în ascuns; și Tatăl vostru, care vede în ascuns, vă va răsplăti. ");
INSERT INTO ronlsb_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Nu vă adunați comori pe pământ, unde molia și rugina mistuie și unde hoții pătrund și fură; ");
INSERT INTO ronlsb_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","ci adunați-vă comori în ceruri, unde nici molia, nici rugina nu mistuie și unde hoții nu pătrund și nu fură; ");
INSERT INTO ronlsb_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","căci unde este comoara voastră, acolo va fi și inima voastră. ");
INSERT INTO ronlsb_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Lampa trupului este ochiul. De aceea, dacă ochiul tău este sănătos, tot corpul tău va fi plin de lumină. ");
INSERT INTO ronlsb_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Dar dacă ochiul tău este rău, tot trupul tău va fi plin de întuneric. De aceea, dacă lumina care este în tine este întuneric, cât de mare este întunericul! ");
INSERT INTO ronlsb_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Nimeni nu poate sluji la doi stăpâni, căci ori va urî pe unul și va iubi pe celălalt, ori va fi devotat unuia și va disprețui pe celălalt. Nu poți sluji și lui Dumnezeu și lui Mamona. ");
INSERT INTO ronlsb_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","De aceea vă spun: nu vă îngrijorați pentru viața voastră: ce veți mânca sau ce veți bea; și nici pentru trupul vostru, ce veți purta. Nu este viața mai mult decât hrana, iar trupul mai mult decât îmbrăcămintea? ");
INSERT INTO ronlsb_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Priviți păsările cerului, care nu seamănă, nu seceră și nu adună în hambare. Tatăl vostru ceresc le hrănește. Nu sunteți voi mult mai valoroși decât ele? ");
INSERT INTO ronlsb_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","“Cine dintre voi, dacă este îngrijorat, poate să adauge o clipă la viața lui? ");
INSERT INTO ronlsb_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","De ce vă îngrijorați din cauza hainelor? Gândiți-vă la crinii de pe câmp, cum cresc ei. Ei nu se trudesc, nici nu se învârt, ");
INSERT INTO ronlsb_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","și totuși vă spun că nici măcar Solomon, în toată gloria lui, nu era îmbrăcat ca unul dintre aceștia. ");
INSERT INTO ronlsb_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Dar dacă Dumnezeu îmbracă astfel iarba câmpului, care astăzi există, iar mâine este aruncată în cuptor, nu vă va îmbrăca cu mult mai mult pe voi, cei cu puțină credință? ");
INSERT INTO ronlsb_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","De aceea, nu vă îngrijorați, zicând: “Ce vom mânca?”, “Ce vom bea?” sau “Cu ce ne vom îmbrăca?” ");
INSERT INTO ronlsb_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Căci neamurile caută toate aceste lucruri; dar Tatăl vostru cel ceresc știe că aveți nevoie de toate acestea. ");
INSERT INTO ronlsb_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Dar căutați mai întâi Împărăția lui Dumnezeu și dreptatea lui; și toate aceste lucruri vi se vor da și vouă. ");
INSERT INTO ronlsb_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","De aceea, nu vă îngrijorați pentru ziua de mâine, căci ziua de mâine se va îngrijora singură. Răul propriu al fiecărei zile este suficient. ");
INSERT INTO ronlsb_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Nu judecați, ca să nu fiți judecați. ");
INSERT INTO ronlsb_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Căci cu orice judecată veți judeca, veți fi judecați; și cu orice măsură veți măsura, vi se va măsura. ");
INSERT INTO ronlsb_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","De ce vezi paiul care este în ochiul fratelui tău, dar nu te gândești la bârna care este în propriul tău ochi? ");
INSERT INTO ronlsb_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Sau cum îi vei spune fratelui tău: “Lasă-mă să scot paiul din ochiul tău”, și iată că bârna este în propriul tău ochi? ");
INSERT INTO ronlsb_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ipocritule! Scoate mai întâi bârna din ochiul tău și apoi vei putea vedea limpede ca să scoți paiul din ochiul fratelui tău. ");
INSERT INTO ronlsb_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Nu dați la câini ce este sfânt și nu aruncați perlele voastre înaintea porcilor, ca nu cumva să le calce în picioare, să se întoarcă și să vă sfâșie. ");
INSERT INTO ronlsb_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Cereți și vi se va da. Căutați, și veți găsi. Bateți la ușă și vi se va deschide. ");
INSERT INTO ronlsb_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Căci oricine cere primește. Cel care caută găsește. Celui care bate i se va deschide. ");
INSERT INTO ronlsb_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Sau cine dintre voi este acela care, dacă fiul său îi cere pâine, îi va da o piatră? ");
INSERT INTO ronlsb_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Sau, dacă îi cere un pește, cine îi va da un șarpe? ");
INSERT INTO ronlsb_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Deci, dacă voi, care sunteți răi, știți să dați daruri bune copiilor voștri, cu cât mai mult Tatăl vostru, care este în ceruri, va da lucruri bune celor ce i le cer! ");
INSERT INTO ronlsb_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Așadar, orice vreți să vă facă vouă oamenii, să le faceți și voi; căci aceasta este Legea și profeții. ");
INSERT INTO ronlsb_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Intrați pe poarta cea strâmtă, căci poarta este largă și calea cea largă care duce la pieire, și mulți sunt cei ce intră pe ea. ");
INSERT INTO ronlsb_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Cât de strâmtă este poarta și de îngustă este calea care duce la viață! Sunt puțini cei care o găsesc. ");
INSERT INTO ronlsb_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Feriți-vă de proorocii mincinoși, care vin la voi în haine de oi, dar pe dinăuntru sunt lupi răpitori. ");
INSERT INTO ronlsb_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","După roadele lor îi veți cunoaște. Culegeți struguri din spini sau smochine din ciulini? ");
INSERT INTO ronlsb_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tot așa, orice pom bun produce fructe bune, dar pomul stricat produce fructe rele. ");
INSERT INTO ronlsb_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Un pom bun nu poate produce fructe rele, și nici un pom corupt nu poate produce fructe bune. ");
INSERT INTO ronlsb_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Orice copac care nu produce fructe bune este tăiat și aruncat în foc. ");
INSERT INTO ronlsb_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","De aceea, după roadele lor îi veți cunoaște. ");
INSERT INTO ronlsb_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Nu oricine Îmi zice: “Doamne, Doamne!” va intra în Împărăția cerurilor, ci cel ce face voia Tatălui Meu care este în ceruri. ");
INSERT INTO ronlsb_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Mulți îmi vor spune în ziua aceea: “Doamne, Doamne, nu cumva am prorocit în numele Tău, nu cumva în numele Tău am scos demoni și nu cumva în numele Tău am făcut multe lucrări puternice?” ");
INSERT INTO ronlsb_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Atunci le voi spune: “Nu v-am cunoscut niciodată”. Plecați de la Mine, voi care lucrați fărădelegea'. ");
INSERT INTO ronlsb_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Oricine ascultă aceste cuvinte ale Mele și le împlinește, îl voi asemăna cu un om înțelept care și-a zidit casa pe stâncă. ");
INSERT INTO ronlsb_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","A căzut ploaia, au venit inundațiile, au suflat vânturile și au bătut peste casa aceea, dar ea nu a căzut, pentru că era întemeiată pe stâncă. ");
INSERT INTO ronlsb_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Oricine aude aceste cuvinte ale mele și nu le pune în practică va fi ca un om nebun care și-a construit casa pe nisip. ");
INSERT INTO ronlsb_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ploaia a căzut, au venit inundațiile, vânturile au suflat și au bătut peste casa aceea; și ea a căzut — și căderea ei a fost mare.” ");
INSERT INTO ronlsb_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","După ce a isprăvit Isus de spus acestea, mulțimea a rămas uimită de învățătura Lui, ");
INSERT INTO ronlsb_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","căci îi învăța cu putere, și nu ca pe cărturari. ");
INSERT INTO ronlsb_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Când S-a pogorât de pe munte, o mare mulțime de oameni Îl urmau. ");
INSERT INTO ronlsb_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Și iată că un lepros a venit la el și i s-a închinat, zicând: “Doamne, dacă vrei, poți să mă faci curat”. ");
INSERT INTO ronlsb_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Isus a întins mâna și l-a atins, zicând: “Vreau să... Să fii curățat”. Imediat, lepra lui a fost curățată. ");
INSERT INTO ronlsb_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Isus i-a zis: “Ai grijă să nu spui nimănui; ci du-te, arată-te preotului și oferă darul pe care l-a poruncit Moise, ca mărturie pentru ei.” ");
INSERT INTO ronlsb_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Când a ajuns în Capernaum, a venit la El un centurion, care i-a cerut ajutor, ");
INSERT INTO ronlsb_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","zicând: “Doamne, robul meu zace în casă, paralizat și foarte chinuit.” ");
INSERT INTO ronlsb_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Isus i-a zis: “Voi veni și-l voi vindeca.” ");
INSERT INTO ronlsb_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Centurionul a răspuns: “Doamne, nu sunt vrednic să intri sub acoperișul meu. Spune doar un cuvânt și robul meu va fi vindecat. ");
INSERT INTO ronlsb_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Căci și eu sunt un om sub autoritate, având sub mine soldați. Îi spun acestuia: “Du-te!” și el se duce; îi spun altuia: “Vino!” și el vine; îi spun robului meu: “Fă aceasta!” și el o face.” ");
INSERT INTO ronlsb_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Isus, auzind aceasta, s-a mirat și a zis celor ce-l urmau: “Adevărat vă spun că n-am găsit o credință atât de mare, nici măcar în Israel. ");
INSERT INTO ronlsb_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Vă spun că mulți vor veni de la răsărit și de la apus și vor sta cu Avraam, Isaac și Iacov în Împărăția Cerurilor, ");
INSERT INTO ronlsb_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","dar copiii Împărăției vor fi aruncați în întunericul de afară. Acolo va fi plâns și scrâșnire de dinți”.” ");
INSERT INTO ronlsb_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Isus i-a spus centurionului: “Du-te și tu. Să ți se facă așa cum ai crezut.” Robul său a fost vindecat în acel ceas. ");
INSERT INTO ronlsb_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Când a intrat Isus în casa lui Petru, a văzut pe mama nevestei lui, care zăcea bolnavă de febră. ");
INSERT INTO ronlsb_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","I-a atins mâna, și febra a lăsat-o. Ea s-a ridicat și l-a servit. ");
INSERT INTO ronlsb_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Când s-a făcut seară, i-au adus pe mulți posedați de demoni. El a izgonit duhurile cu un cuvânt și a vindecat pe toți cei bolnavi, ");
INSERT INTO ronlsb_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","pentru ca să se împlinească ceea ce s-a spus prin profetul Isaia: “El a luat neputințele noastre și a purtat bolile noastre”. ");
INSERT INTO ronlsb_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Isus, văzând mulțime mare în jurul Lui, a poruncit să se ducă în cealaltă parte. ");
INSERT INTO ronlsb_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Un cărturar a venit și I-a zis: “Învățătorule, Te voi urma oriunde vei merge.” ");
INSERT INTO ronlsb_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Isus i-a zis: “Vulpile au vizuini și păsările cerului au cuiburi, dar Fiul Omului nu are unde să-și pună capul.” ");
INSERT INTO ronlsb_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Un alt ucenic al Lui I-a zis: “Doamne, îngăduie-mi să mă duc mai întâi să îngrop pe tatăl meu.” ");
INSERT INTO ronlsb_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Dar Isus i-a zis: “Urmează-Mă și lasă morții să-și îngroape morții lor.” ");
INSERT INTO ronlsb_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Când a urcat în corabie, ucenicii Lui L-au urmat. ");
INSERT INTO ronlsb_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Iată că s-a iscat o furtună violentă pe mare, încât barca era acoperită de valuri; dar El dormea. ");
INSERT INTO ronlsb_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ucenicii au venit la el și l-au trezit, zicând: “Salvează-ne, Doamne! Suntem pe moarte!” ");
INSERT INTO ronlsb_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","El le-a zis: “De ce vă temeți, oameni cu puțină credință?” Apoi s-a ridicat, a mustrat vântul și marea și s-a făcut o mare liniște. ");
INSERT INTO ronlsb_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Și oamenii se mirau și ziceau: “Ce fel de om este acesta, încât și vântul și marea îl ascultă?” ");
INSERT INTO ronlsb_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Când a ajuns de cealaltă parte, în ținutul Gherghesenilor, l-au întâmpinat doi oameni posedați de demoni, care ieșeau din morminte, foarte înverșunați, încât nimeni nu putea trece pe acolo. ");
INSERT INTO ronlsb_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Și iată că strigau, zicând: “Ce avem noi de-a face cu Tine, Isus, Fiul lui Dumnezeu? Ai venit aici ca să ne chinuiești înainte de vreme?” ");
INSERT INTO ronlsb_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Și era o turmă de mulți porci care păștea departe de ei. ");
INSERT INTO ronlsb_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Demonii l-au implorat, spunând: “Dacă ne scoți afară, îngăduie-ne să plecăm în turma de porci.” ");
INSERT INTO ronlsb_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Și le-a zis: “Mergeți!” Au ieșit și au intrat în turma de porci; și iată că întreaga turmă de porci s-a prăbușit în mare și a murit în apă. ");
INSERT INTO ronlsb_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Cei care îi hrăneau au fugit și s-au dus în cetate și au povestit totul, inclusiv ce s-a întâmplat cu cei care erau posedați de demoni. ");
INSERT INTO ronlsb_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Iată că toată cetatea a ieșit în întâmpinarea lui Isus. Când l-au văzut, l-au implorat să plece de lângă hotarele lor. ");
INSERT INTO ronlsb_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","A intrat într-o corabie, a trecut dincolo și a venit în cetatea sa. ");
INSERT INTO ronlsb_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Și iată că i-au adus un om paralizat, întins pe un pat. Isus, văzând credința lor, i-a spus paraliticului: “Fiule, înveselește-te! Păcatele tale îți sunt iertate”. ");
INSERT INTO ronlsb_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Și iată că unii dintre cărturari își ziceau: “Omul acesta hulește”. ");
INSERT INTO ronlsb_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Isus, cunoscând gândurile lor, a zis: “Pentru ce gândiți rău în inimile voastre? ");
INSERT INTO ronlsb_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Căci ce este mai ușor: să spui: “Păcatele tale sunt iertate”, sau să spui: “Scoală-te și umblă?” ");
INSERT INTO ronlsb_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Dar ca să știți că Fiul Omului are putere pe pământ să ierte păcatele — (apoi i-a spus paraliticului): “Scoală-te, ia-ți rogojina și du-te la casa ta”. ");
INSERT INTO ronlsb_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Și s-a sculat și a plecat la casa lui. ");
INSERT INTO ronlsb_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Dar mulțimile, văzând aceasta, s-au mirat și au slăvit pe Dumnezeu, care dăduse oamenilor o asemenea putere. ");
INSERT INTO ronlsb_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Când a trecut Isus de acolo, a văzut pe un om numit Matei, care ședea la percepție. I-a spus: “Urmează-mă”. El s-a ridicat și l-a urmat. ");
INSERT INTO ronlsb_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Pe când ședea el în casă, iată că au venit mulți vameși și păcătoși și s-au așezat la masă cu Isus și cu discipolii săi. ");
INSERT INTO ronlsb_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Fariseii, văzând aceasta, au zis discipolilor lui: “De ce mănâncă învățătorul vostru cu vameșii și cu păcătoșii?” ");
INSERT INTO ronlsb_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Când a auzit Isus, le-a zis: “Cei sănătoși nu au nevoie de doctor, dar cei bolnavi au nevoie de doctor. ");
INSERT INTO ronlsb_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Voi însă mergeți și învățați ce înseamnă acest lucru: “Eu vreau milă, și nu jertfă”, căci n-am venit să chem la pocăință pe cei drepți, ci pe păcătoși.” ");
INSERT INTO ronlsb_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Atunci ucenicii lui Ioan au venit la el și i-au zis: “De ce noi și fariseii postim des, iar ucenicii tăi nu postesc?” ");
INSERT INTO ronlsb_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Isus le-a zis: “Pot oare prietenii mirelui să jelească atâta timp cât mirele este cu ei? Dar vor veni zile când mirele va fi luat de la ei și atunci vor posti. ");
INSERT INTO ronlsb_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Nimeni nu pune o bucată de pânză neîncălzită pe o haină veche, pentru că petecul s-ar rupe de pe haină și se face o gaură și mai mare. ");
INSERT INTO ronlsb_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nici oamenii nu pun vin nou în piei de vin vechi, căci altfel s-ar sparge piei, s-ar vărsa vinul și s-ar strica piei. Nu, ei pun vin nou în piei de vin proaspăt, și amândouă se păstrează.” ");
INSERT INTO ronlsb_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Pe când le spunea acestea, iată că a venit un domnitor și I s-a închinat, zicând: “Fiica mea a murit; vino și pune mâna pe ea și va trăi.” ");
INSERT INTO ronlsb_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Isus s-a sculat și a mers după el, ca și ucenicii lui. ");
INSERT INTO ronlsb_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Și iată că o femeie, care avea o scurgere de sânge de doisprezece ani, a venit în urma Lui și s-a atins de marginea hainei Lui; ");
INSERT INTO ronlsb_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","căci zicea în sinea ei: “Dacă mă ating de haina Lui, mă voi face bine”. ");
INSERT INTO ronlsb_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Dar Isus, întorcându-se și văzând-o, a zis: “Fiică, înveselește-te! Credința ta te-a făcut sănătoasă”. Și femeia s-a făcut bine din acel ceas. ");
INSERT INTO ronlsb_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Când a intrat Isus în casa domnitorului și a văzut pe cei ce cântau la fluier și mulțimea în dezordine, ");
INSERT INTO ronlsb_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","le-a zis: “Faceți loc, căci fata nu este moartă, ci doarme.” Îl ridiculizau. ");
INSERT INTO ronlsb_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Dar, când mulțimea a fost trimisă afară, El a intrat înăuntru, a luat-o de mână și fata s-a ridicat. ");
INSERT INTO ronlsb_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Vestea aceasta s-a răspândit în toată țara aceea. ");
INSERT INTO ronlsb_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Pe când trecea Isus de acolo, doi orbi L-au urmărit, strigând și zicând: “Ai milă de noi, Fiul lui David!” ");
INSERT INTO ronlsb_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","După ce a intrat în casă, orbii s-au apropiat de El. Isus le-a zis: “Credeți că pot face acest lucru?” Ei i-au spus: “Da, Doamne”. ");
INSERT INTO ronlsb_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Apoi s-a atins de ochii lor și a zis: “Fie vouă după credința voastră!” ");
INSERT INTO ronlsb_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Atunci li s-au deschis ochii. Isus le-a poruncit cu strictețe, zicând: “Aveți grijă ca nimeni să nu afle despre aceasta.” ");
INSERT INTO ronlsb_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Dar ei au ieșit și au răspândit faima Lui în toată țara aceea. ");
INSERT INTO ronlsb_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Pe când ieșeau ei afară, iată că a fost adus la El un mut, care era posedat de un demon. ");
INSERT INTO ronlsb_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","După ce a fost izgonit demonul, omul mut a vorbit. Mulțimile se minunau și spuneau: “Așa ceva nu s-a mai văzut în Israel!” ");
INSERT INTO ronlsb_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Dar fariseii ziceau: “Prin prințul demonilor scoate demoni.” ");
INSERT INTO ronlsb_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Isus străbătea toate cetățile și satele, învățând în sinagogile lor, propovăduind vestea cea bună a Împărăției și vindecând orice boală și orice neputință în popor. ");
INSERT INTO ronlsb_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Când a văzut mulțimile, i s-a făcut milă de ele, pentru că erau hărțuite și împrăștiate, ca niște oi fără păstor. ");
INSERT INTO ronlsb_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Atunci le-a spus discipolilor săi: “Într-adevăr, secerișul este mare, dar lucrătorii sunt puțini. ");
INSERT INTO ronlsb_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Rugați-vădeci ca Domnul secerișului să trimită lucrători la secerișul Său.” ");
INSERT INTO ronlsb_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","A chemat la Sine pe cei doisprezece ucenici ai Săi și le-a dat putere asupra duhurilor necurate, ca să le scoată afară și să vindece orice boală și orice neputință. ");
INSERT INTO ronlsb_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Și numele celor doisprezece apostoli sunt următoarele Cel dintâi, Simon, care se numește Petru; Andrei, fratele său; Iacov, fiul lui Zebedeu; Ioan, fratele său; ");
INSERT INTO ronlsb_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip; Bartolomeu; Toma; Matei, vameșul; Iacov, fiul lui Alfeu; Lebeu, care se mai numea și Tadeu; ");
INSERT INTO ronlsb_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon Zelota; și Iuda Iscarioteanul, care l-a și trădat. ");
INSERT INTO ronlsb_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Isus a trimis pe acești doisprezece și le-a poruncit, zicând: “Să nu mergeți printre neamuri și să nu intrați în nici o cetate a samaritenilor. ");
INSERT INTO ronlsb_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Mergeți mai degrabă la oile pierdute ale casei lui Israel. ");
INSERT INTO ronlsb_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","În timp ce mergeți, propovăduiți, spunând: “Împărăția Cerurilor este aproape!” ");
INSERT INTO ronlsb_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Vindecați bolnavii, curățați leproșii și alungați demonii. De bunăvoie ați primit, de bunăvoie dați. ");
INSERT INTO ronlsb_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Nu luați aur, argint sau aramă în centurile voastre de bani. ");
INSERT INTO ronlsb_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Nu luați nici un sac pentru călătorie, nici două haine, nici sandale, nici toiag, căci cel care muncește este vrednic de hrana sa. ");
INSERT INTO ronlsb_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","În orice cetate sau sat în care intrați, aflați cine este vrednic în el și rămâneți acolo până când veți merge mai departe. ");
INSERT INTO ronlsb_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Când intrați în gospodărie, salutați-o. ");
INSERT INTO ronlsb_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Dacă gospodăria este vrednică, să vină pacea ta peste ea, iar dacă nu este vrednică, să se întoarcă pacea ta la tine. ");
INSERT INTO ronlsb_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Oricine nu vă primește și nu vă ascultă cuvintele, când ieșiți din casa aceea sau din cetatea aceea, scuturați-vă praful de pe picioare. ");
INSERT INTO ronlsb_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Adevărat vă spun că, în ziua judecății, va fi mai ușor de suportat pentru țara Sodomei și Gomorei decât pentru orașul acela. ");
INSERT INTO ronlsb_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Iată, vă trimit ca pe niște oi în mijlocul lupilor. De aceea, fiți înțelepți ca șerpii și inofensivi ca porumbeii. ");
INSERT INTO ronlsb_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Dar păziți-vă de oameni, căci vă vor da pe mâna consiliilor și în sinagogile lor vă vor biciui. ");
INSERT INTO ronlsb_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Da, și veți fi aduși înaintea guvernatorilor și a împăraților din cauza Mea, ca mărturie pentru ei și pentru neamuri. ");
INSERT INTO ronlsb_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Dar, când vă vor preda, nu vă îngrijorați cum și ce veți spune, pentru că vi se va da în ceasul acela ce veți spune. ");
INSERT INTO ronlsb_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Căci nu voi vorbiți, ci Duhul Tatălui vostru care vorbește în voi. ");
INSERT INTO ronlsb_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Fratele va da la moarte pe fratele său și tatăl pe copilul său. Copiii se vor ridica împotriva părinților și îi vor face să moară. ");
INSERT INTO ronlsb_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Veți fi urâți de toți oamenii din cauza numelui Meu, dar cel care va răbda până la sfârșit va fi mântuit. ");
INSERT INTO ronlsb_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Dar când vă vor persecuta în această cetate, fugiți în cealaltă, pentru că, cu siguranță, vă spun că nu veți fi trecut prin cetățile lui Israel până nu va veni Fiul Omului. ");
INSERT INTO ronlsb_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Ucenicul nu este mai presus de învățătorul său, nici sluga mai presus de stăpânul său. ");
INSERT INTO ronlsb_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Este de ajuns ca ucenicul să fie ca învățătorul său, și robul ca domnul său. Dacă pe stăpânul casei l-au numit Beelzebul, cu cât mai mult pe cei din casa lui! ");
INSERT INTO ronlsb_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","De aceea nu vă temeți de ei, căci nu este nimic acoperit care să nu fie descoperit, sau ascuns care să nu fie cunoscut. ");
INSERT INTO ronlsb_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ceea ce vă spun în întuneric, vorbiți la lumină; și ceea ce auziți șoptit la ureche, vestiți pe acoperișurile caselor. ");
INSERT INTO ronlsb_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Nu vă temeți de cei care ucid trupul, dar nu pot ucide sufletul. Temeți-vă mai degrabă de cel care este în stare să nimicească și sufletul și trupul în Gheenă. ");
INSERT INTO ronlsb_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Nu se vând oare două vrăbii cu o monedă de un asarion? Nici una dintre ele nu cade pe pământ fără voia Tatălui vostru. ");
INSERT INTO ronlsb_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Dar chiar și firele de păr de pe capul vostru sunt toate numărate. ");
INSERT INTO ronlsb_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","De aceea nu vă temeți. Voi sunteți mai valoroși decât multe vrăbii. ");
INSERT INTO ronlsb_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Așadar, pe oricine mă mărturisește înaintea oamenilor, îl voi mărturisi și eu înaintea Tatălui meu care este în ceruri. ");
INSERT INTO ronlsb_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Dar pe oricine Mă va nega înaintea oamenilor, îl voi nega și Eu înaintea Tatălui Meu care este în ceruri. ");
INSERT INTO ronlsb_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Să nu credeți că am venit să trimit pacea pe pământ. Nu am venit să trimit pace, ci o sabie. ");
INSERT INTO ronlsb_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Pentru că am venit să pun pe un om împotriva tatălui său, pe o fiică împotriva mamei sale și pe noră împotriva soacrei sale. ");
INSERT INTO ronlsb_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Dușmanii unui om vor fi cei din propria lui casă. ");
INSERT INTO ronlsb_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Cine iubește pe tată sau pe mamă mai mult decât Mine nu este vrednic de Mine; și cine iubește pe fiu sau pe fiică mai mult decât Mine nu este vrednic de Mine. ");
INSERT INTO ronlsb_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Cine nu-și ia crucea și nu vine după mine nu este vrednic de mine. ");
INSERT INTO ronlsb_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Cine își caută viața o va pierde, iar cine își pierde viața pentru mine o va găsi. ");
INSERT INTO ronlsb_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Cine vă primește pe voi, pe Mine Mă primește; și cine Mă primește pe Mine, primește pe Cel ce M-a trimis pe Mine. ");
INSERT INTO ronlsb_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Cine primește un profet în numele unui profet va primi răsplata unui profet. Cine primește un om drept în numele unui om drept va primi răsplata unui om drept. ");
INSERT INTO ronlsb_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Oricineva da unuia dintre acești micuți doar un pahar de apă rece să bea în numele unui ucenic, cu siguranță vă spun că nu-și va pierde nicidecum răsplata.” ");
INSERT INTO ronlsb_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","După ce a isprăvit Isus de a îndruma pe cei doisprezece ucenici ai Săi, a plecat de acolo ca să învețe și să propovăduiască în cetățile lor. ");
INSERT INTO ronlsb_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ioan, auzind în temniță despre faptele lui Hristos, a trimis doi din ucenicii săi ");
INSERT INTO ronlsb_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","și I-a zis: “Tu ești Cel ce vine, sau trebuie să căutăm pe altul?” ");
INSERT INTO ronlsb_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Isus le-a răspuns: “Mergeți și spuneți lui Ioan ce ați auzit și ce ați văzut: ");
INSERT INTO ronlsb_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","orbii își recapătă vederea, șchiopii umblă, leproșii sunt curățiți, surzii aud, morții înviază și săracilor li se vestește o veste bună. ");
INSERT INTO ronlsb_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ferice de cel care nu găsește în mine nici un prilej de poticnire.” ");
INSERT INTO ronlsb_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Pe când se duceau aceștia, Isus a început să spună mulțimii despre Ioan: “Ce ați ieșit în pustie ca să vedeți? O trestie scuturată de vânt? ");
INSERT INTO ronlsb_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Dar voi ce ați ieșit să vedeți? Un om în haine moi? Iată, cei care poartă haine moi sunt în casele regilor. ");
INSERT INTO ronlsb_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Dar tu de ce ai ieșit afară? Ca să vezi un profet? Da, vă spun, și chiar mai mult decât un profet. ");
INSERT INTO ronlsb_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Căci acesta este Cel despre care este scris: “Iată, trimit înaintea feței tale pe trimisul Meu, care îți va pregăti calea înaintea ta”. ");
INSERT INTO ronlsb_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Adevărat vă spun că, dintre cei născuți din femei, nu s-a ridicat nimeni mai mare decât Ioan Botezătorul; totuși, cel mai mic în Împărăția Cerurilor este mai mare decât el. ");
INSERT INTO ronlsb_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Din zilele lui Ioan Botezătorul și până acum, Împărăția Cerurilor suferă violențe și cei violenți o iau cu forța. ");
INSERT INTO ronlsb_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Căci toți profeții și Legea au profețit până la Ioan. ");
INSERT INTO ronlsb_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Dacă sunteți dispuși să-l primiți, acesta este Ilie, care va veni. ");
INSERT INTO ronlsb_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Cine are urechi de auzit, să audă. ");
INSERT INTO ronlsb_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Dar cu ce să compar neamul acesta? Seamănă cu niște copii care stau în piețe, care strigă la tovarășii lor ");
INSERT INTO ronlsb_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","și spun: 'Noi am cântat la flaut pentru voi și voi n-ați dansat. Noi am plâns pentru voi, iar voi nu v-ați plâns'. ");
INSERT INTO ronlsb_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Căci Ioan nu a venit nici să mănânce, nici să bea, și ei spun: “Are un demon”. ");
INSERT INTO ronlsb_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Fiul Omului a venit mâncând și bând și ei spun: 'Iată un om gurmand și un bețiv, prietenul vameșilor și al păcătoșilor!'. Dar înțelepciunea este justificată de copiii ei.” ");
INSERT INTO ronlsb_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Apoi a început să denunțe cetățile în care se săvârșiseră cele mai multe din faptele lui mărețe, pentru că nu se pocăiseră. ");
INSERT INTO ronlsb_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Vai de tine, Corazin! Vai de tine, Betsaida! Pentru că, dacă în Tir și în Sidon s-ar fi făcut în Tir și în Sidon lucrările mărețe care s-au făcut în voi, s-ar fi pocăit demult în sac și cenușă. ");
INSERT INTO ronlsb_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Dar vă spun că, în ziua judecății, va fi mai ușor de suportat pentru Tir și Sidon decât pentru voi. ");
INSERT INTO ronlsb_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Tu, Capernaum, care te-ai înălțat la cer, te vei coborî în Hades. Căci, dacă s-ar fi făcut în Sodoma lucrările mărețe care s-au făcut în voi, ar fi rămas până astăzi. ");
INSERT INTO ronlsb_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Dar Eu vă spun că, în ziua judecății, va fi mai ușor de suportat pentru țara Sodomei decât pentru voi.” ");
INSERT INTO ronlsb_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","În vremea aceea, Isus a răspuns: “Îți mulțumesc, Tată, Doamne al cerului și al pământului, că ai ascuns aceste lucruri de cei înțelepți și pricepuți și le-ai descoperit copiilor. ");
INSERT INTO ronlsb_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Da, Tată, pentru că așa a fost bineplăcut înaintea Ta. ");
INSERT INTO ronlsb_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Toate lucrurile mi-au fost predate de Tatăl meu. Nimeni nu-L cunoaște pe Fiul, în afară de Tatăl; și nimeni nu-L cunoaște pe Tatăl, în afară de Fiul și de cel căruia Fiul vrea să i-L dezvăluie. ");
INSERT INTO ronlsb_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Veniți la Mine, voi toți cei osteniți și împovărați, și Eu vă voi da odihnă. ");
INSERT INTO ronlsb_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Luați jugul Meu asupra voastră și învățați de la Mine, căci Eu sunt blând și smerit cu inima; și veți găsi odihnă pentru sufletele voastre. ");
INSERT INTO ronlsb_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Căcijugul Meu este ușor și povara Mea este ușoară.” ");
INSERT INTO ronlsb_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","În vremea aceea, Iisus mergea în ziua de Sabat prin lanurile de grâu. Discipolilor Săi le era foame și au început să culeagă căpățâni de grâu și să mănânce. ");
INSERT INTO ronlsb_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Dar fariseii, văzând aceasta, i-au spus: “Iată că discipolii tăi fac ceea ce nu este îngăduit să facă în ziua de Sabat.” ");
INSERT INTO ronlsb_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Dar El le-a zis: “N-ați citit ce a făcut David și cei ce erau cu el, când i-a fost foame? ");
INSERT INTO ronlsb_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","cum a intrat în casa lui Dumnezeu și a mâncat pâinea de spectacol, pe care nu era îngăduit să o mănânce nici el, nici cei care erau cu el, ci numai preoții? ");
INSERT INTO ronlsb_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Sau n-ați citit în Lege că, în ziua Sabatului, preoții din templu profanează Sabatul și sunt nevinovați? ");
INSERT INTO ronlsb_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Dar Eu vă spun că unul mai mare decât templul este aici. ");
INSERT INTO ronlsb_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Dar dacă ați fi știut ce înseamnă acest lucru: “Eu doresc milă, și nu jertfă”, nu i-ați fi condamnat pe cei fără vină. ");
INSERT INTO ronlsb_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Căci Fiul Omului este Domnul Sabatului.” ");
INSERT INTO ronlsb_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","A plecat de acolo și a intrat în sinagoga lor. ");
INSERT INTO ronlsb_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Și iată că era acolo un om cu o mână uscată. L-au întrebat: “Este îngăduit să vindeci în ziua de Sabat?”, ca să-l acuze. ");
INSERT INTO ronlsb_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","El le-a zis: “Cine dintre voi are o oaie și, dacă aceasta cade într-o groapă în ziua de Sabat, nu se va apuca de ea și n-o va scoate afară? ");
INSERT INTO ronlsb_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Cu cât este mai valoros atunci un om decât o oaie! De aceea este permis să faci binele în ziua de Sabat”. ");
INSERT INTO ronlsb_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Apoi i-a spus omului: “Întinde-ți mâna”. El a întins-o; și ea a fost refăcută întreagă, la fel ca cealaltă. ");
INSERT INTO ronlsb_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Dar fariseii au ieșit și au uneltit împotriva lui, ca să-l nimicească. ");
INSERT INTO ronlsb_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Isus, aflând aceasta, s-a retras de acolo. L-au urmat mulțimi mari de oameni; și El i-a vindecat pe toți, ");
INSERT INTO ronlsb_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","și le-a poruncit să nu-L facă cunoscut, ");
INSERT INTO ronlsb_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ca să se împlinească ceea ce fusese spus prin profetul Isaia, care zicea ");
INSERT INTO ronlsb_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Iată robul Meu, pe care l-am ales, iubitul meu, în care sufletul meu este binevoitor. Voi pune Duhul Meu peste el. El va proclama dreptatea națiunilor. ");
INSERT INTO ronlsb_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","El nu se va zbate și nu va striga, nici nu-i va auzi cineva vocea pe străzi. ");
INSERT INTO ronlsb_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","El nu va rupe trestia zdrobită. El nu va stinge nici un fân care fumegă, până când va conduce justiția la victorie. ");
INSERT INTO ronlsb_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","În numele Lui vor nădăjdui neamurile.” ");
INSERT INTO ronlsb_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Atunci a fost adus la El un orb și mut, posedat de un demon, și L-a vindecat, astfel că orbul și mutul vorbea și vedea. ");
INSERT INTO ronlsb_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Toată mulțimea era uimită și zicea: “Oare poate fi acesta fiul lui David?” ");
INSERT INTO ronlsb_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Dar fariseii, când au auzit, au zis: “Omul acesta nu scoate demoni decât prin Beelzebul, prințul demonilor.” ");
INSERT INTO ronlsb_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Cunoscându-le gândurile, Isus le-a zis: “Orice împărăție împărțită împotriva ei însăși este dărâmată, și orice cetate sau casă împărțită împotriva ei însăși nu va rămâne în picioare. ");
INSERT INTO ronlsb_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Dacă Satana îl alungă pe Satana, el este dezbinat împotriva lui însuși. Cum va rămâne atunci împărăția lui în picioare? ");
INSERT INTO ronlsb_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Dacă Eu, prin Beelzebul, scot afară demoni, prin cine îi scot copiii voștri? De aceea ei vor fi judecătorii voștri. ");
INSERT INTO ronlsb_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Dar dacă eu, prin Duhul lui Dumnezeu, scot afară demoni, atunci Împărăția lui Dumnezeu a venit peste voi. ");
INSERT INTO ronlsb_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Sau cum poate cineva să intre în casa celui puternic și să-i jefuiască bunurile, dacă nu-l leagă mai întâi pe cel puternic? Atunci îi va jefui casa. ");
INSERT INTO ronlsb_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Cine nu este cu Mine, este împotriva Mea, și cine nu se adună cu Mine, risipește. ");
INSERT INTO ronlsb_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","De aceea vă spun că orice păcat și orice blasfemie va fi iertat oamenilor, dar blasfemia împotriva Duhului nu va fi iertată oamenilor. ");
INSERT INTO ronlsb_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Oricine va spune un cuvânt împotriva Fiului Omului, îi va fi iertat, dar oricine va vorbi împotriva Duhului Sfânt, nu-i va fi iertat, nici în veacul acesta, nici în cel viitor. ");
INSERT INTO ronlsb_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ori faceți pomul bun și rodul lui bun, ori faceți pomul stricat și rodul lui stricat, căci pomul se cunoaște după rodul lui. ");
INSERT INTO ronlsb_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Voi, urmași ai viperelor, cum puteți, fiind răi, să vorbiți lucruri bune? Căci din belșugul inimii, gura vorbește. ");
INSERT INTO ronlsb_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Omul bun din comoara sa bună scoate lucruri bune, iar omul rău din comoara sa rea scoate lucruri rele. ");
INSERT INTO ronlsb_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Eu vă spun că orice cuvânt deșert pe care-l spun oamenii, vor da socoteală de el în ziua judecății. ");
INSERT INTO ronlsb_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Căci prin cuvintele voastre veți fi îndreptățiți, iar prin cuvintele voastre veți fi osândiți.” ");
INSERT INTO ronlsb_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Atunci unii dintre cărturari și farisei au răspuns: “Învățătorule, vrem să vedem un semn de la Tine.” ");
INSERT INTO ronlsb_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Dar El le-a răspuns: “Un neam rău și adulterin caută un semn; dar nu i se va da alt semn decât semnul proorocului Iona. ");
INSERT INTO ronlsb_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Căci, după cum Iona a stat trei zile și trei nopți în pântecele peștelui uriaș, tot așa și Fiul Omului va sta trei zile și trei nopți în inima pământului. ");
INSERT INTO ronlsb_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Bărbații din Ninive vor sta în picioare la judecată cu acest neam și îl vor condamna, pentru că s-au pocăit la propovăduirea lui Iona; și iată că cineva mai mare decât Iona este aici. ");
INSERT INTO ronlsb_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Împărăteasa Sudului se va ridica la judecata cu acest neam și-l va osândi, pentru că a venit de la marginile pământului să asculte înțelepciunea lui Solomon; și iată, cineva mai mare decât Solomon este aici. ");
INSERT INTO ronlsb_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Când un duh necurat iese din om, trece prin locuri fără apă, căutând odihnă, și nu o găsește. ");
INSERT INTO ronlsb_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Atunci el spune: “Mă voi întoarce în casa mea de unde am venit.” Și când se întoarce, o găsește goală, măturată și pusă în ordine. ");
INSERT INTO ronlsb_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Atunci se duce și ia cu el alte șapte duhuri mai rele decât el, intră înăuntru și locuiesc acolo. Ultima stare a acelui om devine mai rea decât prima. Tot așa va fi și cu această generație rea.” ");
INSERT INTO ronlsb_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Pe când vorbea El încă mulțimilor, iată că mama și frații Lui stăteau afară și căutau să vorbească cu El. ");
INSERT INTO ronlsb_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Cineva i-a zis: “Iată, mama ta și frații tăi stau afară și caută să vorbească cu tine.” ");
INSERT INTO ronlsb_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Dar el a răspuns celui ce-i vorbea: “Cine este mama mea? Cine sunt frații mei?” ");
INSERT INTO ronlsb_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","El a întins mâna spre ucenicii Săi și a zis: “Iată mama Mea și frații Mei! ");
INSERT INTO ronlsb_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Căci oricine face voia Tatălui Meu, care este în ceruri, acela este fratele Meu, sora Mea și mama Mea.” ");
INSERT INTO ronlsb_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","În ziua aceea, Isus a ieșit din casă și a șezut pe malul mării. ");
INSERT INTO ronlsb_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","O mare mulțime s-a adunat la El, așa că a intrat într-o barcă și a șezut; și toată mulțimea stătea pe plajă. ");
INSERT INTO ronlsb_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","El le vorbea multe lucruri în parabole, zicând: “Iată, un agricultor a ieșit să semene. ");
INSERT INTO ronlsb_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","În timp ce semăna, unele semințe au căzut pe marginea drumului, iar păsările au venit și le-au mâncat. ");
INSERT INTO ronlsb_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Altele au căzut pe un teren stâncos, unde nu prea avea pământ, și imediat au răsărit, pentru că nu aveau pământ adânc. ");
INSERT INTO ronlsb_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Când a răsărit soarele, s-au pârjolit. Pentru că nu aveau rădăcini, s-au uscat. ");
INSERT INTO ronlsb_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Altele au căzut între spini. Spinii au crescut și le-au sufocat. ");
INSERT INTO ronlsb_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Altele au căzut pe pământ bun și au dat rod: unele de o sută de ori mai mult, altele de șaizeci, altele de treizeci. ");
INSERT INTO ronlsb_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Cine are urechi de auzit, să asculte.” ");
INSERT INTO ronlsb_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ucenicii au venit și I-au zis: “De ce le vorbești în pilde?” ");
INSERT INTO ronlsb_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","El le-a răspuns: “Vouă v-a fost dat să cunoașteți tainele Împărăției cerurilor, dar lor nu le este dat. ");
INSERT INTO ronlsb_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Căci oricui are, i se va da și va avea din belșug; dar oricui nu are, i se va lua chiar și ceea ce are. ");
INSERT INTO ronlsb_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","De aceea le vorbesc în parabole, pentru că, văzând, nu văd, iar auzind, nu aud și nici nu înțeleg. ");
INSERT INTO ronlsb_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","În ei se împlinește profeția lui Isaia, care zice:, 'Auzind, veți auzi, și nu va înțelege în niciun fel; Văzând vei vedea, și nu va percepe în niciun fel; ");
INSERT INTO ronlsb_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Căci inima acestui popor a devenit insensibilă, urechile lor sunt surde de auz, și au închis ochii; sau poate că ar putea percepe cu ochii, aud cu urechile lor, să înțeleagă cu inima lor, și s-ar întoarce din nou, și eu îi voi vindeca. ");
INSERT INTO ronlsb_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Binecuvântați sunt ochii voștri, căci văd, și urechile voastre, căci aud. ");
INSERT INTO ronlsb_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Căci cu adevărat vă spun că mulți profeți și oameni drepți au dorit să vadă lucrurile pe care le vedeți voi și nu le-au văzut; și să audă lucrurile pe care le auziți voi și nu le-au auzit. ");
INSERT INTO ronlsb_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Ascultați, deci, pilda țăranului. ");
INSERT INTO ronlsb_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Când cineva aude cuvântul Împărăției și nu-l înțelege, vine cel rău și smulge ceea ce a fost semănat în inima lui. Iată ce a fost semănat la marginea drumului. ");
INSERT INTO ronlsb_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ceea ce a fost semănat pe locurile stâncoase, acesta este cel care aude cuvântul și îndată îl primește cu bucurie; ");
INSERT INTO ronlsb_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","dar nu are rădăcină în el însuși, ci rezistă o vreme. Când apare opresiunea sau persecuția din cauza cuvântului, îndată se poticnește. ");
INSERT INTO ronlsb_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ceea ce a fost semănat între spini, acesta este cel care ascultă cuvântul, dar grijile veacului acestuia și înșelăciunea bogățiilor înăbușă cuvântul, și el devine neînsuflețit. ");
INSERT INTO ronlsb_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ceea ce a fost semănat în pământ bun, acesta este cel care aude cuvântul și îl înțelege, care cu siguranță face rod și produce, unii de o sută de ori mai mult, alții de șaizeci, iar alții de treizeci.” ");
INSERT INTO ronlsb_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Și le-a pus înaintea lor o altă pildă, zicând: “Împărăția cerurilor se aseamănă cu un om care a semănat sămânță bună în câmpul său; ");
INSERT INTO ronlsb_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","dar, pe când dormeau oamenii, a venit vrăjmașul său, a semănat și el buruieni de neghină printre grâu și a plecat. ");
INSERT INTO ronlsb_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Dar când a răsărit firul și a produs grâu, atunci au apărut și buruienile de scorbură. ");
INSERT INTO ronlsb_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Slujitorii gospodarului au venit și i-au spus: “Domnule, nu ai semănat tu sămânță bună în câmpul tău? De unde au apărut aceste buruieni de scorbură?”. ");
INSERT INTO ronlsb_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","El le-a zis: “Un vrăjmaș a făcut aceasta. Slujitorii l-au întrebat: “Vrei să mergem noi să-i adunăm?”. ");
INSERT INTO ronlsb_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Dar El a zis: “Nu, ca nu cumva, adunând buruienile, să nu dezrădăcinați cu ele grâul. ");
INSERT INTO ronlsb_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Lasă-le pe amândouă să crească împreună până la seceriș, iar la vremea secerișului voi spune secerătorilor: “Mai întâi, strângeți buruienile de scorbură și legați-le în mănunchiuri ca să le ardeți; dar grâul strângeți-l în hambarul Meu.\"”””. ");
INSERT INTO ronlsb_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Și le-a pus înainte o altă pildă, zicând: “Împărăția cerurilor este ca un grăunte de muștar pe care l-a luat un om și l-a semănat în câmpul său, ");
INSERT INTO ronlsb_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","care este mai mic decât toate semințele. Dar, când a crescut, este mai mare decât ierburile și devine un copac, astfel încât păsările cerului vin și se adăpostesc în ramurile lui.” ");
INSERT INTO ronlsb_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Și le-a spus o altă pildă. “Împărăția cerurilor se aseamănă cu drojdia pe care a luat-o o femeie și a ascuns-o în trei măsuri de făină, până ce a fost toată leșinată.” ");
INSERT INTO ronlsb_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Isus vorbea mulțimilor toate aceste lucruri în pilde; și fără pilde nu le vorbea, ");
INSERT INTO ronlsb_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ca să se împlinească ce fusese spus prin proorocul care zicea, “Îmi voi deschide gura în parabole; Voi descoperi lucruri ascunse de la întemeierea lumii.” ");
INSERT INTO ronlsb_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Atunci Isus a dat drumul mulțimii și a intrat în casă. Ucenicii Lui au venit la El și I-au zis: “Explică-ne parabola buruienilor de pe câmp.” ");
INSERT INTO ronlsb_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","El le-a răspuns: “Cel ce seamănă sămânța cea bună este Fiul Omului; ");
INSERT INTO ronlsb_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","câmpul este lumea, semințele bune sunt copiii Împărăției, iar buruienile sunt copiii celui rău. ");
INSERT INTO ronlsb_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Dușmanul care le-a semănat este diavolul. Secerișul este sfârșitul veacului, iar secerătorii sunt îngerii. ");
INSERT INTO ronlsb_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","De aceea, așa cum buruienile de scorbură sunt adunate și arse în foc, așa va fi și la sfârșitul acestui veac. ");
INSERT INTO ronlsb_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Fiul Omului va trimite pe îngerii Săi, care vor strânge din Împărăția Sa tot ce este de poticnire și pe cei ce fac nelegiuiri, ");
INSERT INTO ronlsb_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","și îi vor arunca în cuptorul de foc. Acolo va fi plâns și scrâșnire de dinți. ");
INSERT INTO ronlsb_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Atunci cei drepți vor străluci ca soarele în Împărăția Tatălui lor. Cine are urechi de auzit, să audă. ");
INSERT INTO ronlsb_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Împărăția cerurilor se aseamănă cu o comoară ascunsă în câmp, pe care a găsit-o un om și a ascuns-o. În bucuria lui, se duce și vinde tot ce are și cumpără acel câmp. ");
INSERT INTO ronlsb_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Împărăția cerurilor se aseamănă cu un om care este un negustor care caută perle frumoase, ");
INSERT INTO ronlsb_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","și care, găsind o perlă de mare preț, s-a dus, a vândut tot ce avea și a cumpărat-o. ");
INSERT INTO ronlsb_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Împărăția cerurilor se aseamănă cu o năvodă aruncată în mare, care a adunat pești de toate felurile, ");
INSERT INTO ronlsb_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","și pe care, când s-a umplut, pescarii au tras-o pe plajă. S-au așezat și au adunat ce era bun în recipiente, dar ce era rău l-au aruncat. ");
INSERT INTO ronlsb_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Așa va fi și la sfârșitul lumii. Îngerii vor veni și îi vor despărți pe cei răi dintre cei drepți ");
INSERT INTO ronlsb_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","și îi vor arunca în cuptorul de foc. Acolo va fi plâns și scrâșnire de dinți.” ");
INSERT INTO ronlsb_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Isus le-a zis: “Ați înțeles toate aceste lucruri?” Ei i-au răspuns: “Da, Doamne”. ");
INSERT INTO ronlsb_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","El le-a zis: “De aceea, orice cărturar care a fost făcut ucenic în Împărăția cerurilor se aseamănă cu un om gospodar, care scoate din comoara sa lucruri noi și vechi.” ");
INSERT INTO ronlsb_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","După ce a isprăvit Isus aceste pilde, a plecat de acolo. ");
INSERT INTO ronlsb_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Venind în țara lui, i-a învățat pe oameni în sinagoga lor, așa că ei erau uimiți și ziceau: “De unde are omul acesta atâta înțelepciune și atâtea minuni? ");
INSERT INTO ronlsb_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nu cumva este acesta fiul tâmplarului? Nu cumva mama lui se numește Maria, iar frații săi Iacov, Iose, Simon și Iuda? ");
INSERT INTO ronlsb_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Nu sunt toate surorile lui cu noi? De unde a obținut atunci acest om toate aceste lucruri?”. ");
INSERT INTO ronlsb_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ei s-au simțit jigniți de el. Dar Isus le-a zis: “Un profet nu este lipsit de cinste decât în țara și în casa lui.” ");
INSERT INTO ronlsb_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","El nu a făcut acolo multe lucrări mărețe din cauza necredinței lor. ");
INSERT INTO ronlsb_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","În vremea aceea, Irod tetrarhul a auzit vestea despre Isus ");
INSERT INTO ronlsb_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","și a zis slujitorilor săi: “Acesta este Ioan Botezătorul. El a înviat din morți. De aceea lucrează în el aceste puteri”. ");
INSERT INTO ronlsb_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Pentru că Irod îl prinsese pe Ioan, îl legase și îl întemnițase din cauza Irodiadei, soția fratelui său Filip. ");
INSERT INTO ronlsb_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Căci Ioan îi spusese: “Nu-ți este îngăduit să o ai.” ");
INSERT INTO ronlsb_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Când a vrut să-l omoare, s-a temut de mulțime, pentru că îl socotea profet. ");
INSERT INTO ronlsb_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Dar când a venit ziua de naștere a lui Irod, fiica Irodiadei a dansat printre ei și i-a plăcut lui Irod. ");
INSERT INTO ronlsb_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","De aceea a promis cu jurământ că-i va da tot ce-i va cere. ");
INSERT INTO ronlsb_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ea, fiind îndemnată de mama ei, a zis: “Dă-mi aici, pe un platou, capul lui Ioan Botezătorul”. ");
INSERT INTO ronlsb_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Împăratul s-a mâhnit, dar a poruncit să fie dat, pentru jurămintele sale și pentru cei ce stăteau la masă cu el. ");
INSERT INTO ronlsb_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","A trimis și a decapitat pe Ioan în temniță. ");
INSERT INTO ronlsb_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Capul lui a fost adus pe un platou și dat tinerei domnișoare, iar ea l-a dus mamei sale. ");
INSERT INTO ronlsb_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ucenicii lui au venit, au luat trupul și l-au îngropat. Apoi s-au dus și au anunțat pe Isus. ");
INSERT INTO ronlsb_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Isus, când a auzit aceasta, s-a retras de acolo cu o barcă într-un loc pustiu, la o parte. Când au auzit mulțimile, l-au urmat pe jos dinspre cetăți. ");
INSERT INTO ronlsb_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Isus a ieșit afară și a văzut o mulțime mare. I s-a făcut milă de ei și le-a vindecat bolnavii. ");
INSERT INTO ronlsb_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Când s-a făcut seară, ucenicii Lui au venit la El și I-au zis: “Locul acesta este pustiu și ora este deja târzie. Trimiteți mulțimea să plece, ca să se ducă în sate și să-și cumpere de mâncare.” ");
INSERT INTO ronlsb_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Dar Isus le-a zis: “Nu este nevoie să plece. Dați-le voi ceva de mâncare”. ");
INSERT INTO ronlsb_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ei I-au spus: “Avem aici numai cinci pâini și doi pești.” ");
INSERT INTO ronlsb_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","El a zis: “Adu-i aici la Mine”. ");
INSERT INTO ronlsb_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","A poruncit mulțimilor să se așeze pe iarbă; apoi a luat cele cinci pâini și cei doi pești și, privind spre cer, a binecuvântat, a frânt și a dat pâinile ucenicilor, iar ucenicii au dat mulțimilor. ");
INSERT INTO ronlsb_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Toți au mâncat și s-au săturat. Au luat douăsprezece coșuri pline cu ceea ce rămăsese de la bucățile sparte. ");
INSERT INTO ronlsb_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Cei care au mâncat erau cam cinci mii de bărbați, pe lângă femei și copii. ");
INSERT INTO ronlsb_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Îndată Isus a pus pe ucenici să se urce în corabie și să meargă înaintea Lui, în cealaltă parte, în timp ce El gonea mulțimea. ");
INSERT INTO ronlsb_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","După ce a alungat mulțimile, s-a urcat singur pe munte ca să se roage. Când a venit seara, era acolo singur. ");
INSERT INTO ronlsb_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Dar corabia se afla acum în mijlocul mării, tulburată de valuri, căci vântul era împotrivă. ");
INSERT INTO ronlsb_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","În a patra veghe a nopții, Isus a venit la ei, mergând pe mare. ");
INSERT INTO ronlsb_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Când discipolii l-au văzut umblând pe mare, s-au tulburat și au zis: “Este o fantomă!” și au strigat de frică. ");
INSERT INTO ronlsb_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Dar îndată Isus le-a vorbit și le-a zis: “Înveseliți-vă! Eu sunt! Nu vă temeți!”. ");
INSERT INTO ronlsb_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petru I-a răspuns: “Doamne, dacă ești Tu, poruncește-mi să vin la Tine pe ape.” ");
INSERT INTO ronlsb_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","El a zis: “Vino!” Petru a coborât din barcă și a mers pe ape pentru a veni la Isus. ");
INSERT INTO ronlsb_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Dar, văzând că vântul era puternic, s-a temut și, începând să se scufunde, a strigat: “Doamne, salvează-mă!”. ");
INSERT INTO ronlsb_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Îndată Isus a întins mâna, l-a apucat și i-a zis: “Tu, cel cu puțină credință, de ce te-ai îndoit?” ");
INSERT INTO ronlsb_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Când s-au urcat în barcă, vântul a încetat. ");
INSERT INTO ronlsb_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Cei care erau în barcă au venit și i s-au închinat, spunând: “Cu adevărat ești Fiul lui Dumnezeu!” ");
INSERT INTO ronlsb_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","După ce au trecut dincolo, au ajuns în ținutul Ghenaretului. ");
INSERT INTO ronlsb_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Când oamenii din acel loc l-au recunoscut, au trimis în toată regiunea din jur și i-au adus pe toți cei bolnavi; ");
INSERT INTO ronlsb_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","și l-au rugat să atingă doar franjurii hainei lui. Toți cei care o atingeau se vindecau. ");
INSERT INTO ronlsb_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Fariseii și cărturarii au venit de la Ierusalim la Isus, și au zis: ");
INSERT INTO ronlsb_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Pentru ce nu ascultă ucenicii Tăi tradiția bătrânilor? Căci ei nu se spală pe mâini când mănâncă pâine”. ");
INSERT INTO ronlsb_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","El le-a răspuns: “Pentru ce nu ascultați și voi de porunca lui Dumnezeu, din pricina tradiției voastre? ");
INSERT INTO ronlsb_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Căci Dumnezeu a poruncit: “Cinstește pe tatăl tău și pe mama ta” și: “Cine vorbește de rău pe tatăl sau pe mama, să fie omorât”. ");
INSERT INTO ronlsb_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Dar voi ziceți: “Oricine ar putea spune tatălui său sau mamei sale: “Orice ajutor pe care l-ai fi putut primi altfel de la mine este un dar închinat lui Dumnezeu”, ");
INSERT INTO ronlsb_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","să nu-și cinstească tatăl sau mama”. Voi ați făcut ca porunca lui Dumnezeu să fie nulă din cauza tradiției voastre. ");
INSERT INTO ronlsb_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Voi, ipocriților! Bine a profețit Isaia despre voi, zicând: “Nu vă faceți de râs! ");
INSERT INTO ronlsb_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Oamenii aceștia se apropie de Mine cu gura lor, și mă onorează cu buzele lor; dar inima lor este departe de mine. ");
INSERT INTO ronlsb_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Și în zadar se închină la Mine, învățând ca doctrină reguli făcute de oameni.”” ");
INSERT INTO ronlsb_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","A chemat mulțimea și le-a zis: “Ascultați și înțelegeți. ");
INSERT INTO ronlsb_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ceea ce intră în gură nu spurcă pe om; dar ceea ce iese din gură, aceasta spurcă pe om.” ");
INSERT INTO ronlsb_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Atunci au venit ucenicii și I-au zis: “Știi că fariseii s-au mâniat când au auzit cuvântul acesta?” ");
INSERT INTO ronlsb_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Dar El a răspuns: “Orice plantă pe care nu a plantat-o Tatăl Meu cel ceresc va fi dezrădăcinată. ");
INSERT INTO ronlsb_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Lăsați-le în pace. Ei sunt călăuze oarbe ale orbilor. Dacă orbul îi călăuzește pe orbi, amândoi vor cădea într-o groapă.” ");
INSERT INTO ronlsb_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petru i-a răspuns: “Explică-ne pilda aceasta.” ");
INSERT INTO ronlsb_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Și Isus a zis: “Nu înțelegeți nici voi încă? ");
INSERT INTO ronlsb_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nu înțelegeți că tot ce intră în gură trece în pântece și apoi iese din trup? ");
INSERT INTO ronlsb_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Dar ceea ce iese din gură iese din inimă și îl spurcă pe om. ");
INSERT INTO ronlsb_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Căci din inimă ies gândurile rele, uciderile, adulterele, păcatele sexuale, furturile, mărturia mincinoasă și blasfemiile. ");
INSERT INTO ronlsb_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Acestea sunt lucrurile care îl spurcă pe om; dar a mânca cu mâinile nespălate nu-l spurcă pe om.” ");
INSERT INTO ronlsb_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Isus a ieșit de acolo și s-a retras în ținutul Tirului și al Sidonului. ");
INSERT INTO ronlsb_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Și iată că o femeie cananeeancă a ieșit din acele hotare și a strigat: “Ai milă de mine, Doamne, Fiul lui David! Fiica mea este grav posedată de un demon!” ");
INSERT INTO ronlsb_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Dar el nu i-a răspuns nici un cuvânt. Ucenicii Lui au venit și L-au rugat, zicând: “Trimite-o departe, căci strigă după noi”. ");
INSERT INTO ronlsb_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Dar El a răspuns: “Eu n-am fost trimis decât la oile pierdute ale casei lui Israel.” ");
INSERT INTO ronlsb_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Dar ea a venit și s-a închinat Lui, zicând: “Doamne, ajută-mă!” ");
INSERT INTO ronlsb_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Iar el a răspuns: “Nu se cuvine să iei pâinea copiilor și să o arunci la câini.” ");
INSERT INTO ronlsb_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Iar ea a răspuns: “Da, Doamne, dar și câinii mănâncă firimiturile care cad de la masa stăpânilor lor.” ");
INSERT INTO ronlsb_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Atunci Isus i-a răspuns: “Femeie, mare este credința ta! Să ți se facă așa cum dorești!” Și fiica ei a fost vindecată din acel ceas. ");
INSERT INTO ronlsb_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Isus a plecat de acolo și s-a apropiat de marea Galileii; apoi S-a suit pe munte și a șezut acolo. ");
INSERT INTO ronlsb_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Mulțimi mari au venit la El, având cu ei șchiopi, orbi, muți, mutilați și mulți alții, și i-au pus la picioare. El i-a vindecat, ");
INSERT INTO ronlsb_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","astfel încât mulțimea se mira când vedea pe cei muți vorbind, pe cei răniți vindecându-se, pe cei șchiopi mergând și pe cei orbi văzând — și slăveau pe Dumnezeul lui Israel. ");
INSERT INTO ronlsb_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Isus a chemat pe ucenicii Săi și le-a zis: “Mi-e milă de mulțime, pentru că de trei zile stau cu Mine și nu au ce să mănânce. Nu vreau să îi trimit departe în post, pentru că ar putea să leșine pe drum.” ");
INSERT INTO ronlsb_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ucenicii I-au zis: “De unde am putea lua atâtea pâini într-un loc pustiu ca să săturăm o mulțime atât de mare?” ");
INSERT INTO ronlsb_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Isus le-a zis: “Câte pâini aveți?” Ei au spus: “Șapte și câțiva peștișori”. ");
INSERT INTO ronlsb_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Și a poruncit mulțimii să șadă pe pământ; ");
INSERT INTO ronlsb_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","și a luat cele șapte pâini și peștii. A mulțumit și le-a frânt; le-a împărțit și le-a dat ucenicilor, iar ucenicii mulțimii. ");
INSERT INTO ronlsb_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Toți au mâncat și s-au săturat. Au luat șapte coșuri pline cu bucățile sparte care rămăseseră. ");
INSERT INTO ronlsb_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Cei care au mâncat erau patru mii de bărbați, pe lângă femei și copii. ");
INSERT INTO ronlsb_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Apoi a alungat mulțimile, s-a urcat în barcă și a ajuns în hotarele Magdala. ");
INSERT INTO ronlsb_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fariseii și saducheii au venit și, punându-L la încercare, L-au rugat să le arate un semn din cer. ");
INSERT INTO ronlsb_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Dar el le-a răspuns: “Când se face seară, voi spuneți: “Va fi vreme frumoasă, căci cerul este roșu”. ");
INSERT INTO ronlsb_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Dimineața: 'Astăzi va fi vreme rea, căci cerul este roșu și amenințător'. Ipocriților! Știți să discerneți aspectul cerului, dar nu puteți discerne semnele vremurilor! ");
INSERT INTO ronlsb_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","O generație rea și adulterină caută un semn, dar nu i se va da niciun semn, cu excepția semnului profetului Iona.” I-a lăsat și a plecat. ");
INSERT INTO ronlsb_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ucenicii au ajuns de partea cealaltă și au uitat să ia pâine. ");
INSERT INTO ronlsb_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Isus le-a zis: “Luați aminte și feriți-vă de drojdia fariseilor și a saducheilor.” ");
INSERT INTO ronlsb_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Și se gândeau între ei, zicând: “Nu am adus pâine.” ");
INSERT INTO ronlsb_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Isus, văzând aceasta, a zis: “De ce vă certați între voi, oameni cu puțină credință, pentru că n-ați adus pâine? ");
INSERT INTO ronlsb_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Încă nu vă dați seama și nu vă amintiți de cele cinci pâini pentru cele cinci mii și de câte coșuri ați luat, ");
INSERT INTO ronlsb_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","sau de cele șapte pâini pentru cele patru mii și de câte coșuri ați luat? ");
INSERT INTO ronlsb_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Cum se face că nu vă dați seama că nu v-am vorbit despre pâini? Ci feriți-vă de drojdia fariseilor și a saducheilor.” ");
INSERT INTO ronlsb_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Atunci au înțeles că nu le spusese să se ferească de drojdia pâinii, ci de învățătura fariseilor și a saducheilor. ");
INSERT INTO ronlsb_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Când a ajuns Isus în părțile Cezareei lui Filipi, a întrebat pe ucenicii Săi, zicând: “Cine zic oamenii că sunt Eu, Fiul Omului?” ");
INSERT INTO ronlsb_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ei au zis: “Unii zic Ioan Botezătorul, alții Ilie, iar alții Ieremia sau unul din profeți.” ");
INSERT INTO ronlsb_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","El le-a zis: “Dar voi cine ziceți că sunt Eu?” ");
INSERT INTO ronlsb_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Petru a răspuns: “Tu ești Hristosul, Fiul lui Dumnezeu cel viu.” ");
INSERT INTO ronlsb_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Isus i-a răspuns: “Binecuvântat ești tu, Simon Bar Iona, căci nu carnea și sângele ți-au descoperit acest lucru, ci Tatăl Meu care este în ceruri. ");
INSERT INTO ronlsb_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Îți spun și Eu îți spun că tu ești Petru și pe această piatră voi zidi Adunarea Mea și porțile Hadesului nu o vor birui. ");
INSERT INTO ronlsb_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Îți voi da cheile Împărăției Cerurilor și tot ce vei lega pe pământ va fi fost legat în ceruri; și tot ce vei elibera pe pământ va fi fost eliberat în ceruri.” ");
INSERT INTO ronlsb_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Apoi le-a poruncit discipolilor să nu spună nimănui că El este Isus Hristosul. ");
INSERT INTO ronlsb_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Din clipa aceea, Isus a început să le arate ucenicilor Săi că trebuie să meargă la Ierusalim, să sufere multe de la bătrâni, de la preoții cei mai de seamă și de la cărturari, să fie omorât și a treia zi să învie. ");
INSERT INTO ronlsb_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Petru, luându-l deoparte, a început să-L certe, zicând: “Departe de Tine, Doamne! Nu ți se va face niciodată așa ceva”. ");
INSERT INTO ronlsb_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Dar El, întorcându-se, a zis lui Petru: “Satana, treci înapoia mea! Ești o piatră de poticnire pentru mine, pentru că nu te gândești la lucrurile lui Dumnezeu, ci la cele ale oamenilor.” ");
INSERT INTO ronlsb_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Atunci Isus a zis ucenicilor Săi: “Dacă voiește cineva să vină după Mine, să se lepede de sine, să-și ia crucea și să Mă urmeze. ");
INSERT INTO ronlsb_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Căci oricine vrea să-și salveze viața o va pierde, iar oricine își va pierde viața pentru Mine o va găsi. ");
INSERT INTO ronlsb_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Căci ce-i va folosi cuiva dacă va câștiga toată lumea și-și va pierde viața? Sau ce va da un om în schimbul vieții sale? ");
INSERT INTO ronlsb_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Căci Fiul Omului va veni în slava Tatălui Său cu îngerii Săi și atunci va da fiecăruia după faptele sale. ");
INSERT INTO ronlsb_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Adevărat vă spun că sunt unii care stau aici și care nu vor gusta nicidecum moartea până când nu vor vedea pe Fiul Omului venind în Împărăția Sa.” ");
INSERT INTO ronlsb_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","După șase zile, Isus a luat cu El pe Petru, pe Iacov și pe Ioan, fratele său, și i-a dus singuri pe un munte înalt. ");
INSERT INTO ronlsb_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","El s-a schimbat înaintea lor. Fața Lui a strălucit ca soarele, iar hainele Lui au devenit albe ca lumina. ");
INSERT INTO ronlsb_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Iată că Moise și Ilie li s-au arătat vorbind cu el. ");
INSERT INTO ronlsb_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Petru a luat cuvântul și a zis lui Isus: “Doamne, bine este să fim aici. Dacă vrei, să facem aici trei corturi: unul pentru tine, unul pentru Moise și unul pentru Ilie.” ");
INSERT INTO ronlsb_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pe când vorbea El încă, iată că un nor strălucitor i-a acoperit cu umbra sa. Și iată că din nor a ieșit un glas care zicea: “Acesta este Fiul Meu preaiubit, în care Îmi găsesc plăcerea. Ascultați-L!”. ");
INSERT INTO ronlsb_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ucenicii, când au auzit, au căzut cu fața la pământ și s-au înspăimântat foarte tare. ");
INSERT INTO ronlsb_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Isus a venit, i-a atins și le-a zis: “Ridicați-vă și nu vă temeți.” ");
INSERT INTO ronlsb_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ridicându-și ochii, nu au văzut pe nimeni, decât pe Isus singur. ");
INSERT INTO ronlsb_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Pe când se coborau de pe munte, Isus le-a poruncit: “Să nu spuneți nimănui ce ați văzut, până ce Fiul Omului nu va învia din morți.” ");
INSERT INTO ronlsb_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ucenicii Lui L-au întrebat și I-au zis: “Atunci de ce zic cărturarii că Ilie trebuie să vină mai întâi?” ");
INSERT INTO ronlsb_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Isus le-a răspuns: “Ilie vine mai întâi și va restabili toate lucrurile; ");
INSERT INTO ronlsb_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","dar Eu vă spun că Ilie a venit deja, și ei nu L-au recunoscut, ci i-au făcut ce au vrut. Tot așa și Fiul Omului va suferi din partea lor”. ");
INSERT INTO ronlsb_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Atunci discipolii au înțeles că le vorbea despre Ioan Botezătorul. ");
INSERT INTO ronlsb_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Când au ajuns la mulțime, a venit la El un om, care a îngenuncheat înaintea Lui și I-a zis: ");
INSERT INTO ronlsb_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Doamne, ai milă de fiul meu, care este epileptic și suferă cumplit, căci de multe ori cade în foc și de multe ori în apă. ");
INSERT INTO ronlsb_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","L-am adus la discipolii Tăi și nu au putut să-l vindece.” ");
INSERT INTO ronlsb_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Isus a răspuns: “Neam necredincios și pervers! Până când voi mai fi cu voi? Până când vă voi răbda? Aduceți-l aici la Mine!” ");
INSERT INTO ronlsb_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Isus a mustrat demonul și acesta a ieșit din el, iar băiatul a fost vindecat din ceasul acela. ");
INSERT INTO ronlsb_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Atunci ucenicii au venit la Isus în particular și au zis: “De ce n-am putut să-l scoatem afară?” ");
INSERT INTO ronlsb_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","El le-a zis: “Din pricina necredinței voastre. Căci vă spun cu adevărat că, dacă veți avea credință cât un grăunte de muștar, veți spune acestui munte: “Mută-te de aici încolo”, și se va muta; și nimic nu vă va fi imposibil. ");
INSERT INTO ronlsb_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Dar acest fel nu iese decât prin rugăciune și prin post.” ");
INSERT INTO ronlsb_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Pe când stăteau în Galileea, Isus le-a zis: “Fiul Omului va fi dat în mâinile oamenilor ");
INSERT INTO ronlsb_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","și ei Îl vor ucide, iar a treia zi va învia.” Le-a părut nespus de rău. ");
INSERT INTO ronlsb_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","După ce au ajuns în Capernaum, cei care strângeau monedele de didracma au venit la Petru și i-au zis: “Nu cumva învățătorul tău plătește didracma?” ");
INSERT INTO ronlsb_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","El a răspuns: “Ba da.” Când a intrat în casă, Isus l-a anticipat și i-a zis: “Ce crezi, Simone? De la cine primesc regii pământului taxă sau tribut? De la copiii lor sau de la străini?”. ");
INSERT INTO ronlsb_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petru i-a zis: “De la străini.” Isus i-a spus: “De aceea copiii sunt scutiți. ");
INSERT INTO ronlsb_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Dar, ca să nu-i facem să se poticnească, du-te la mare, aruncă un cârlig și ia primul pește care iese la suprafață. Când îi vei deschide gura, vei găsi o monedă de un stater. Ia-o și dă-le-o pentru mine și pentru tine.” ");
INSERT INTO ronlsb_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","În ceasul acela, ucenicii au venit la Isus și au zis: “Cine este cel mai mare în Împărăția cerurilor?” ");
INSERT INTO ronlsb_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Isus a chemat la Sine un copilaș, l-a așezat în mijlocul lor ");
INSERT INTO ronlsb_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","și le-a zis: “Adevărat vă spun că, dacă nu vă veți întoarce și nu veți fi ca niște copilași, nu veți intra nicidecum în Împărăția cerurilor. ");
INSERT INTO ronlsb_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Așadar, oricine se smerește ca acest copilaș este cel mai mare în Împărăția Cerurilor. ");
INSERT INTO ronlsb_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Oricine primește un astfel de copilaș în numele meu mă primește pe mine, ");
INSERT INTO ronlsb_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","dar oricine face să se poticnească unul dintre acești copilași care cred în mine, ar fi mai bine pentru el dacă i s-ar atârna de gât o piatră de moară uriașă și s-ar scufunda în adâncul mării. ");
INSERT INTO ronlsb_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Vai de lume, din pricina prilejurilor de poticnire! Căci trebuie să vină ocaziile, dar vai de persoana prin care vine ocazia! ");
INSERT INTO ronlsb_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Dacă mâna sau piciorul tău te face să te poticnești, taie-le și leapădă-le de la tine. Este mai bine pentru tine să intri în viață mutilat sau schilodit, decât să ai două mâini sau două picioare pentru a fi aruncat în focul veșnic. ");
INSERT INTO ronlsb_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Dacă ochiul tău te face să te poticnești, smulge-l și aruncă-l de la tine. Este mai bine pentru tine să intri în viață cu un singur ochi, decât să ai doi ochi pentru a fi aruncat în gheena de foc. ");
INSERT INTO ronlsb_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ai grijă să nu disprețuiești pe unul dintre acești micuți, căci vă spun că în ceruri îngerii lor văd întotdeauna fața Tatălui meu care este în ceruri. ");
INSERT INTO ronlsb_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Căci Fiul Omului a venit să salveze ceea ce era pierdut. ");
INSERT INTO ronlsb_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ce părere ai? Dacă un om are o sută de oi și una dintre ele se rătăcește, nu le lasă el pe cele nouăzeci și nouă, nu se duce la munte și nu o caută pe cea rătăcită? ");
INSERT INTO ronlsb_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Dacă o găsește, cu siguranță vă spun că se bucură pentru ea mai mult decât pentru cele nouăzeci și nouă care nu s-au rătăcit. ");
INSERT INTO ronlsb_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Tot așa, nici Tatăl vostru, care este în ceruri, nu vrea să piară unul dintre acești prunci. ");
INSERT INTO ronlsb_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Dacă fratele tău păcătuiește împotriva ta, du-te și arată-i greșeala lui, numai între tine și el. Dacă te ascultă, ai recâștigat pe fratele tău. ");
INSERT INTO ronlsb_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Dar, dacă nu ascultă, ia cu tine încă unul sau doi, pentru ca, la gura a doi sau trei martori, orice cuvânt să fie confirmat. ");
INSERT INTO ronlsb_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Dacă refuză să-i asculte, spuneți acest lucru adunării. Dacă refuză să asculte și adunarea, să fie pentru voi ca un neam sau ca un vameș. ");
INSERT INTO ronlsb_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Adevărat vă spun că tot ce veți lega pe pământ va fi fost legat în cer și tot ce veți dezlega pe pământ va fi fost dezlegat în cer. ");
INSERT INTO ronlsb_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Și iarăși, cu adevărat vă spun că, dacă doi dintre voi se vor învoi pe pământ cu privire la orice lucru pe care îl vor cere, li se va face de către Tatăl Meu care este în ceruri. ");
INSERT INTO ronlsb_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Căci unde sunt doi sau trei adunați în numele Meu, acolo sunt și Eu în mijlocul lor.” ");
INSERT INTO ronlsb_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Atunci Petru a venit și I-a zis: “Doamne, de câte ori va păcătui fratele meu împotriva mea, și eu îl voi ierta? Până de șapte ori?” ");
INSERT INTO ronlsb_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Isus i-a zis: “Nu-ți spun până la șapte ori, ci până la șaptezeci de ori câte șapte. ");
INSERT INTO ronlsb_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","De aceea, Împărăția cerurilor se aseamănă cu un rege care voia să regleze conturile cu slujitorii săi. ");
INSERT INTO ronlsb_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Când a început să regleze, i s-a adus unul care îi datora zece mii de talanți. ");
INSERT INTO ronlsb_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Dar, pentru că nu putea plăti, stăpânul său a poruncit să fie vândut, împreună cu soția, copiii și tot ce avea, și să se facă plata. ");
INSERT INTO ronlsb_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Slujitorul a căzut, așadar, și a îngenuncheat înaintea lui, zicând: “Doamne, ai răbdare cu mine și îți voi plăti totul!”. ");
INSERT INTO ronlsb_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Stăpânul acelui rob, cuprins de compasiune, i-a dat drumul și i-a iertat datoria. ");
INSERT INTO ronlsb_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Dar robul acela a ieșit afară și a găsit pe unul din tovarășii săi de slujbă care îi datora o sută de denari; l-a apucat și l-a luat de gât, zicând: “Plătește-mi ce ai de plătit!”. ");
INSERT INTO ronlsb_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Și a căzut sluga lui la picioarele lui și l-a rugat, zicând: “Ai răbdare cu mine și-ți voi răsplăti!”. ");
INSERT INTO ronlsb_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Dar el n-a vrut, ci s-a dus și l-a aruncat în temniță până ce va plăti ce i se cuvine. ");
INSERT INTO ronlsb_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Când au văzut tovarășii lui de slujbă ce se făcuse, s-au mâhnit foarte tare și au venit și au povestit stăpânului lor tot ce se făcuse. ");
INSERT INTO ronlsb_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Atunci stăpânul său l-a chemat înăuntru și i-a zis: “Slugă ticăloasă! Ți-am iertat toată datoria aceea pentru că m-ai implorat. ");
INSERT INTO ronlsb_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","N-ar fi trebuit să ai și tu milă de tovarășul tău de slujbă, așa cum am avut eu milă de tine?” ");
INSERT INTO ronlsb_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Stăpânul său s-a mâniat și l-a dat pe el torționarilor până când va plăti tot ce i se cuvenea. ");
INSERT INTO ronlsb_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Așava face și Tatăl meu ceresc cu voi, dacă nu-l veți ierta fiecare din inimă pe fratele vostru pentru greșelile lui.” ");
INSERT INTO ronlsb_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","După ce a isprăvit Isus aceste cuvinte, a plecat din Galileea și a ajuns în ținutul Iudeii, dincolo de Iordan. ");
INSERT INTO ronlsb_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","L-au urmat mulțimi mari de oameni și El i-a vindecat acolo. ");
INSERT INTO ronlsb_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Fariseii au venit la El și L-au pus la încercare, zicând: “Este îngăduit oare unui bărbat să divorțeze de nevastă-sa pentru orice motiv?” ");
INSERT INTO ronlsb_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","El a răspuns: “Nu ați citit că Cel ce i-a făcut de la început i-a făcut bărbat și femeie, ");
INSERT INTO ronlsb_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","și a zis: “De aceea va lăsa omul pe tatăl său și pe mama sa și se va uni cu femeia sa, și cei doi vor fi un singur trup?” ");
INSERT INTO ronlsb_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Astfel că nu mai sunt doi, ci un singur trup. Așadar, ceea ce Dumnezeu a unit, să nu lase omul să despartă.” ");
INSERT INTO ronlsb_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Și l-au întrebat: “Atunci de ce ne-a poruncit Moise să-i dăm certificatul de divorț și să divorțăm de ea?” ");
INSERT INTO ronlsb_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Și le-a zis: “Moise, din pricina împietririi inimilor voastre, v-a îngăduit să divorțați de nevestele voastre, dar de la început nu a fost așa. ");
INSERT INTO ronlsb_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Eu vă spun că oricine divorțează de soția sa, cu excepția imoralității sexuale, și se căsătorește cu alta, comite adulter; iar cel care se căsătorește cu ea când este divorțată comite adulter.” ");
INSERT INTO ronlsb_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ucenicii Lui I-au zis: “Dacă așa se întâmplă cu bărbatul și cu nevasta lui, nu este bine să te căsătorești.” ");
INSERT INTO ronlsb_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Dar El le-a zis: “Nu toți oamenii pot primi cuvântul acesta, ci numai aceia cărora le este dat. ");
INSERT INTO ronlsb_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Căci sunt eunuci care s-au născut așa din pântecele mamei lor, sunt eunuci care au fost făcuți eunuci de către oameni și sunt eunuci care s-au făcut eunuci de dragul Împărăției Cerurilor. Cine este în stare să o primească, să o primească”. ");
INSERT INTO ronlsb_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Atunci I-au fost aduși niște copilași, ca să pună mâinile peste ei și să se roage; dar ucenicii îi mustrau. ");
INSERT INTO ronlsb_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Dar Isus a zis: “Lăsați-i pe copilași și nu le interziceți să vină la Mine, căci Împărăția Cerurilor este a unora ca aceștia.” ");
INSERT INTO ronlsb_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Și-a pus mâinile peste ei și a plecat de acolo. ");
INSERT INTO ronlsb_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Și iată că a venit cineva la El și a zis: “Învățătorule, ce să fac ca să am viața veșnică?” ");
INSERT INTO ronlsb_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","El i-a zis: “De ce Mă numești bun? Nimeni nu este bun decât unul singur, adică Dumnezeu. Dar dacă vrei să intri în viață, păzește poruncile”. ");
INSERT INTO ronlsb_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","El i-a zis: “Care dintre ele?” Isus a spus: “Să nu ucizi. Să nu comiți adulter”. 'Să nu furi'. 'Să nu depui mărturie mincinoasă'. ");
INSERT INTO ronlsb_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","'Cinstește pe tatăl tău și pe mama ta'. Și: 'Să iubești pe aproapele tău ca pe tine însuți'”. ");
INSERT INTO ronlsb_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Tânărul i-a zis: “Toate acestea le știu din tinerețea mea. Ce-mi mai lipsește?” ");
INSERT INTO ronlsb_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Isus i-a zis: “Dacă vrei să fii desăvârșit, du-te, vinde ce ai, dă săracilor și vei avea o comoară în ceruri; apoi vino și urmează-Mi.” ");
INSERT INTO ronlsb_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Dar tânărul, când a auzit aceasta, a plecat trist, pentru că era unul care avea averi mari. ");
INSERT INTO ronlsb_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Isus a zis ucenicilor Săi: “Adevărat vă spun că un om bogat va intra cu greu în Împărăția cerurilor. ");
INSERT INTO ronlsb_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Vă spun din nou: este mai ușor să treacă o cămilă prin urechea unui ac decât să intre un bogat în Împărăția lui Dumnezeu.” ");
INSERT INTO ronlsb_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ucenicii, auzind aceasta, au rămas foarte mirați, și au zis: “Cine poate fi mântuit?” ");
INSERT INTO ronlsb_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Și, uitându-se la ei, Isus a zis: “La oameni este cu neputință, dar la Dumnezeu toate sunt cu putință.” ");
INSERT INTO ronlsb_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Atunci Petru a răspuns: “Iată, am lăsat totul și am venit după Tine. Ce vom avea atunci?” ");
INSERT INTO ronlsb_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Isus le-a zis: “Adevărat vă spun că voi, cei ce M-ați urmat, în vremea când Fiul Omului va ședea pe scaunul de domnie al slavei Sale, veți ședea și voi pe douăsprezece scaune de domnie, ca să judecați cele douăsprezece seminții ale lui Israel. ");
INSERT INTO ronlsb_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Oricine a lăsat case, sau frați, sau surori, sau tată, sau mamă, sau soție, sau copii, sau pământuri, de dragul numelui Meu, va primi de o sută de ori și va moșteni viața veșnică. ");
INSERT INTO ronlsb_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Dar mulți vor fi cei din urmă care sunt primii și cei dintâi care sunt ultimii. ");
INSERT INTO ronlsb_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Căci Împărăția cerurilor se aseamănă cu un om, stăpânul unei gospodării, care a ieșit dis-de-dimineață să angajeze lucrători pentru via sa. ");
INSERT INTO ronlsb_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","După ce s-a înțeles cu muncitorii pentru un denar pe zi, i-a trimis în via sa. ");
INSERT INTO ronlsb_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","A ieșit pe la ora trei și a văzut pe alții care stăteau degeaba în piață. ");
INSERT INTO ronlsb_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Și le-a zis: “Mergeți și voi în vie și vă voi da ce este drept. Și ei au plecat. ");
INSERT INTO ronlsb_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","A ieșit iarăși pe la ceasul al șaselea și al nouălea și a făcut la fel. ");
INSERT INTO ronlsb_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Pe la ceasul al unsprezecelea a ieșit și a găsit pe alții care stăteau degeaba. El i-a întrebat: “De ce stați aici toată ziua degeaba?”. ");
INSERT INTO ronlsb_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ei I-au răspuns: “Pentru că nimeni nu ne-a angajat. “El le-a zis: “Mergeți și voi în vie și veți primi tot ce este drept”. ");
INSERT INTO ronlsb_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Când s-a făcut seară, stăpânul viei a zis administratorului său: “Cheamă lucrătorii și dă-le plata, de la cel din urmă până la cel dintâi”. ");
INSERT INTO ronlsb_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Când au venit cei care fuseseră angajați pe la ora unsprezece, au primit fiecare câte un denar. ");
INSERT INTO ronlsb_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Când au venit cei dintâi, au presupus că vor primi mai mult; și, de asemenea, și ei au primit fiecare câte un denar. ");
INSERT INTO ronlsb_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Când l-au primit, au cârtit împotriva stăpânului casei, ");
INSERT INTO ronlsb_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","zicând: “Aceștia din urmă au cheltuit un singur ceas, și tu i-ai făcut egali cu noi, care am dus povara zilei și căldura arzătoare!”. ");
INSERT INTO ronlsb_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Iar el a răspuns unuia dintre ei: “Prietene, nu-ți fac nici un rău. Nu v-ați înțeles cu mine pentru un denar? ");
INSERT INTO ronlsb_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ia ceea ce este al tău și du-te. Dorința mea este să dau și acestui din urmă la fel de mult ca și ție. ");
INSERT INTO ronlsb_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nu-mi este oare permis să fac ce vreau cu ceea ce am? Sau ochiul tău este rău, pentru că eu sunt bun?” ");
INSERT INTO ronlsb_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Astfel, cel din urmă va fi cel dintâi, iar cel dintâi cel din urmă. Căci mulți sunt chemați, dar puțini sunt aleși.” ");
INSERT INTO ronlsb_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Pe când se suia Isus la Ierusalim, i-a luat deoparte pe cei doisprezece ucenici și, pe drum, le-a zis: ");
INSERT INTO ronlsb_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Iată, ne suim la Ierusalim, și Fiul Omului va fi dat preoților de seamă și cărturarilor, care Îl vor condamna la moarte, ");
INSERT INTO ronlsb_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","și-L vor da neamurilor ca să-L batjocorească, să-L biciuiască și să-L răstignească, iar a treia zi va învia.” ");
INSERT INTO ronlsb_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Atunci mama fiilor lui Zebedei a venit la El cu fiii ei, îngenunchind și cerându-I un lucru. ");
INSERT INTO ronlsb_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","El a întrebat-o: “Ce vrei?” Ea i-a zis: “Poruncește ca acești doi fii ai mei să șadă, unul la dreapta Ta și altul la stânga Ta, în Împărăția Ta”. ");
INSERT INTO ronlsb_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Dar Isus i-a răspuns: “Nu știi ce ceri. Ești în stare să bei paharul pe care voi bea eu și să te botezi cu botezul cu care mă botez eu?” Ei i-au spus: “Noi putem”. ");
INSERT INTO ronlsb_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","El le-a zis: “Voi veți bea paharul Meu și veți fi botezați cu botezul cu care sunt botezat Eu; dar șederea la dreapta și la stânga Mea nu este a Mea, ci a cui a fost pregătită de Tatăl Meu.” ");
INSERT INTO ronlsb_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Când au auzit cei zece, s-au mâniat pe cei doi frați. ");
INSERT INTO ronlsb_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Dar Isus i-a chemat și le-a zis: “Știți că domnitorii neamurilor le stăpânesc și că cei mari ale lor le stăpânesc. ");
INSERT INTO ronlsb_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nu va fi așa între voi; ci oricine vrea să devină mare între voi va fi robul vostru. ");
INSERT INTO ronlsb_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Oricine vrea să fie cel dintâi între voi va fi robul vostru, ");
INSERT INTO ronlsb_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","așa cum Fiul Omului nu a venit ca să fie slujit, ci ca să slujească și să-și dea viața ca răscumpărare pentru mulți.” ");
INSERT INTO ronlsb_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Când au ieșit din Ierihon, o mare mulțime a mers după El. ");
INSERT INTO ronlsb_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Și iată că doi orbi care stăteau pe drum, auzind că Isus trece pe acolo, au strigat: “Doamne, ai milă de noi, Fiul lui David!” ");
INSERT INTO ronlsb_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Mulțimea i-a mustrat, spunându-le să tacă, dar ei au strigat și mai tare: “Doamne, ai milă de noi, Fiul lui David!” ");
INSERT INTO ronlsb_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Isus, oprindu-se, i-a chemat și i-a întrebat: “Ce vreți să fac pentru voi?” ");
INSERT INTO ronlsb_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Și I-au zis: “Doamne, ca să ni se deschidă ochii.” ");
INSERT INTO ronlsb_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Isus, cuprins de compasiune, s-a atins de ochii lor; și îndată ochii lor și-au recăpătat vederea, și au mers după El. ");
INSERT INTO ronlsb_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Când s-au apropiat de Ierusalim și au ajuns la Betfaghe, pe Muntele Măslinilor, Isus a trimis doi ucenici, ");
INSERT INTO ronlsb_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","și le-a zis: “Mergeți în satul care este în fața voastră și îndată veți găsi o măgăriță legată și un mânz cu ea. Dezlegați-i și aduceți-i la mine. ");
INSERT INTO ronlsb_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Dacă vă va spune cineva ceva, să spuneți: “Domnul are nevoie de ei”, și îndată îi va trimite.” ");
INSERT INTO ronlsb_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Toate acestea s-au făcut pentru ca să se împlinească ceea ce fusese spus prin proorocul care zice, ");
INSERT INTO ronlsb_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Spune fiicei Sionului, Iată, Regele vostru vine la voi, umil, și călare pe un măgar, pe un mânz, mânzul unei măgărițe.” ");
INSERT INTO ronlsb_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ucenicii s-au dus și au făcut cum le poruncise Isus; ");
INSERT INTO ronlsb_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","au adus măgărița și mânzul, au pus hainele lor pe ei și Isus a șezut pe ei. ");
INSERT INTO ronlsb_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","O mulțime foarte mare și-a întins hainele pe drum. Alții au tăiat ramuri din copaci și le-au întins pe drum. ");
INSERT INTO ronlsb_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Mulțimea care mergea în fața lui și cei care îl urmau strigau întruna: “Osana Fiului lui David! Binecuvântat este cel care vine în numele Domnului! Osana în cele mai înalte!” ");
INSERT INTO ronlsb_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","După ce a intrat în Ierusalim, toată cetatea s-a tulburat și zicea: “Cine este acesta?” ");
INSERT INTO ronlsb_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Și mulțimile ziceau: “Acesta este proorocul Isus, din Nazaret din Galileea.” ");
INSERT INTO ronlsb_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Isus a intrat în Templul lui Dumnezeu și a izgonit pe toți cei ce vindeau și cumpărau în Templu, a răsturnat mesele schimbătorilor de bani și scaunele celor ce vindeau porumbei. ");
INSERT INTO ronlsb_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","El le-a zis: “Este scris: “Casa Mea se va numi casă de rugăciune”, dar voi ați făcut din ea o peșteră de tâlhari!” ");
INSERT INTO ronlsb_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Șchiopii și orbii veneau la El în templu, și El îi vindeca. ");
INSERT INTO ronlsb_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Dar preoții cei mai de seamă și cărturarii, văzând minunile pe care le făcea și pe copiii care strigau în templu și ziceau: “Osana Fiului lui David!”, s-au indignat ");
INSERT INTO ronlsb_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","și i-au zis: “Auzi ce spun aceștia?” Isus le-a zis: “Da, dar nu ați citit niciodată: “Din gura copiilor și a celor ce alăptează, ai desăvârșit lauda?””. ");
INSERT INTO ronlsb_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Și lăsându-i, a ieșit din cetate și s-a dus în Betania și a tăbărât acolo. ");
INSERT INTO ronlsb_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Dimineața, pe când se întorcea în cetate, îi era foame. ");
INSERT INTO ronlsb_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Văzând un smochin lângă drum, s-a apropiat de el și n-a găsit pe el decât frunze. I-a spus: “Să nu mai fie niciun fruct de la tine în veci!” Imediat smochinul s-a uscat. ");
INSERT INTO ronlsb_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ucenicii, văzând aceasta, s-au mirat și au zis: “Cum de s-a uscat smochinul îndată?” ");
INSERT INTO ronlsb_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Isus le-a răspuns: “Adevărat vă spun că, dacă aveți credință și nu vă îndoiți, nu numai că veți face ce s-a făcut cu smochinul, ci chiar dacă ați spune muntelui acesta: “Ridică-te și aruncă-te în mare”, se va face. ");
INSERT INTO ronlsb_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Toate lucrurile, orice veți cere în rugăciune, crezând, le veți primi.” ");
INSERT INTO ronlsb_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","După ce a intrat în Templu, preoții cei mai de seamă și bătrânii norodului au venit la El, pe când învăța El, și I-au zis: “Cu ce putere faci Tu aceste lucruri? Cine ți-a dat această autoritate?” ");
INSERT INTO ronlsb_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Isus le-a răspuns: “Și eu vă voi pune o întrebare; dacă îmi veți răspunde, vă voi spune și eu cu ce putere fac aceste lucruri. ");
INSERT INTO ronlsb_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Botezul lui Ioan, de unde a fost? Din cer sau de la oameni?” Ei se gândeau între ei, zicând: “Dacă spunem: “Din cer”, ne va întreba: “De ce nu l-ați crezut?” ");
INSERT INTO ronlsb_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Dar dacă spunem: “De la oameni”, ne temem de mulțime, căci toți îl consideră pe Ioan ca profet”. ");
INSERT INTO ronlsb_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ei au răspuns lui Isus și au zis: “Nu știm.” El le-a mai spus: “Nu vă voi spune nici cu ce putere fac aceste lucruri. ");
INSERT INTO ronlsb_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Dar voi ce credeți? Un om avea doi fii; a venit la primul și i-a zis: “Fiule, du-te astăzi să lucrezi în via mea!”. ");
INSERT INTO ronlsb_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","El a răspuns: “Nu vreau!” Dar, după aceea, s-a răzgândit și s-a dus. ");
INSERT INTO ronlsb_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","A venit la al doilea și i-a spus același lucru. El a răspuns: “Mă duc, domnule”, dar nu s-a dus. ");
INSERT INTO ronlsb_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Care dintre cei doi a făcut voia tatălui său?” I-au spus: “Cel dintâi”. Isus le-a zis: “Adevărat vă spun că vameșii și prostituatele intră înaintea voastră în Împărăția lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Căci Ioan a venit la voi pe calea dreptății și voi nu l-ați crezut, dar vameșii și prostituatele l-au crezut. Când l-ați văzut, nici măcar nu v-ați pocăit după aceea, ca să-l credeți. ");
INSERT INTO ronlsb_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Ascultați o altă pildă. Era un om care era stăpânul unei gospodării și care a plantat o vie, a pus un gard în jurul ei, a săpat în ea o presă de vin, a construit un turn, a dat-o în arendă unor agricultori și a plecat în altă țară. ");
INSERT INTO ronlsb_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Când s-a apropiat sezonul de recoltare a roadei, el și-a trimis slujitorii la fermieri ca să-i primească roadele. ");
INSERT INTO ronlsb_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Fermierii i-au luat slujitorii, au bătut pe unul, au ucis pe altul și au ucis cu pietre pe altul. ");
INSERT INTO ronlsb_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","A trimis din nou alți slujitori, mai mulți decât primii, și s-au purtat cu ei la fel. ");
INSERT INTO ronlsb_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","După aceea însă, a trimis la ei pe fiul său, spunând: “Îl vor respecta pe fiul meu”. ");
INSERT INTO ronlsb_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Dar țăranii, când au văzut pe fiu, au zis între ei: “Acesta este moștenitorul”. Haideți să-l omorâm și să-i luăm moștenirea'. ");
INSERT INTO ronlsb_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Și l-au luat și l-au aruncat afară din vie, apoi l-au omorât. ");
INSERT INTO ronlsb_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Când va veni, așadar, stăpânul viei, ce va face cu acei țărani?” ");
INSERT INTO ronlsb_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ei i-au spus: “Îi va nimici pe acești oameni nenorociți și va da via în arendă altor agricultori, care îi vor da roadele la vremea lor.” ");
INSERT INTO ronlsb_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Isus le-a zis: “N-ați citit niciodată în Scriptură? “Piatra pe care au respins-o zidarii a fost numit șef de colț. Aceasta a fost de la Domnul. Este minunat în ochii noștri”? ");
INSERT INTO ronlsb_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","De aceea vă spun că Împărăția lui Dumnezeu va fi luată de la voi și va fi dată unui neam care își va face roadele. ");
INSERT INTO ronlsb_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Cine va cădea pe piatra aceasta va fi sfărâmat, dar pe oricine va cădea, îl va împrăștia ca praful.” ");
INSERT INTO ronlsb_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Preoții cei mai de seamă și fariseii, auzind pildele Lui, au înțeles că vorbea despre ei. ");
INSERT INTO ronlsb_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Când au căutat să îl prindă, s-au temut de mulțime, pentru că îl considerau profet. ");
INSERT INTO ronlsb_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Isus, răspunzând, le-a vorbit iarăși în pilde, zicând: ");
INSERT INTO ronlsb_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Împărăția cerurilor se aseamănă cu un împărat care a făcut un ospăț de nuntă pentru fiul său ");
INSERT INTO ronlsb_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","și a trimis pe slujitorii săi să cheme pe cei invitați la nuntă, dar aceștia n-au vrut să vină. ");
INSERT INTO ronlsb_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","A trimis din nou alți slujitori, spunând: “Spuneți-le celor care sunt invitați: “Iată, am pregătit cina mea. Vitele și îngrășămintele mele sunt ucise și toate lucrurile sunt gata. Veniți la ospățul de nuntă!””'”. ");
INSERT INTO ronlsb_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Dar ei au luat totul în derâdere și au plecat, unul la ferma lui, altul la marfa lui; ");
INSERT INTO ronlsb_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","iar ceilalți i-au înșfăcat slujitorii, i-au tratat cu rușine și i-au ucis. ");
INSERT INTO ronlsb_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Când a auzit asta, regele s-a înfuriat și și-a trimis armatele, i-a nimicit pe acei ucigași și le-a ars cetatea. ");
INSERT INTO ronlsb_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Și a zis robilor săi: “Nunta este gata, dar cei ce au fost invitați nu au fost vrednici. ");
INSERT INTO ronlsb_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Duceți-vă, așadar, la intersecțiile drumurilor și, pe câți veți găsi, invitați-i la nuntă'. ");
INSERT INTO ronlsb_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Slujitorii aceia au ieșit pe drumuri și au adunat pe câți au găsit, atât pe cei răi, cât și pe cei buni. Nunta s-a umplut de invitați. ");
INSERT INTO ronlsb_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Dar când a intrat regele să vadă oaspeții, a văzut acolo un om care nu avea haine de nuntă, ");
INSERT INTO ronlsb_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","și l-a întrebat: “Prietene, cum ai intrat aici fără haine de nuntă?” El a rămas fără cuvinte. ");
INSERT INTO ronlsb_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Atunci regele a zis slujitorilor: “Legați-l de mâini și de picioare, luați-l și aruncați-l în întunericul de afară. Acolo va fi plânsul și scrâșnitul dinților”. ");
INSERT INTO ronlsb_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Căci mulți sunt chemați, dar puțini sunt aleși.” ");
INSERT INTO ronlsb_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Atunci fariseii s-au dus și s-au sfătuit cum să-l prindă în discuția lui. ");
INSERT INTO ronlsb_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Și au trimis la el pe ucenicii lor și pe Irodieni, zicând: “Învățătorule, știm că ești cinstit și că înveți calea lui Dumnezeu cu adevărat, indiferent pe cine înveți, pentru că nu ești părtinitor față de nimeni. ");
INSERT INTO ronlsb_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Spuneți-ne, așadar, ce credeți? Este sau nu legitim să plătim impozite Cezarului?” ");
INSERT INTO ronlsb_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Dar Isus, înțelegând răutatea lor, a zis: “Pentru ce Mă încercați, fățarnicilor? ");
INSERT INTO ronlsb_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Arătați-Mi banii de impozit.” I-au adus un denar. ");
INSERT INTO ronlsb_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Și i-a întrebat: “Al cui este chipul acesta și inscripția aceasta?” ");
INSERT INTO ronlsb_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ei i-au zis: “Al Cezarului”. Apoi le-a zis: “Dați deci Cezarului ce este al Cezarului și lui Dumnezeu ce este al lui Dumnezeu”. ");
INSERT INTO ronlsb_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Când au auzit, s-au mirat, L-au lăsat și au plecat. ");
INSERT INTO ronlsb_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","În ziua aceea au venit la El saducheii, care zic că nu există înviere. L-au întrebat ");
INSERT INTO ronlsb_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","și i-au zis: “Învățătorule, Moise a zis: “Dacă un om moare fără să aibă copii, fratele său să se căsătorească cu femeia lui și să ridice urmași fratelui său. ");
INSERT INTO ronlsb_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Or, erau cu noi șapte frați. Cel dintâi s-a căsătorit și a murit și, neavând urmași, și-a lăsat soția fratelui său. ");
INSERT INTO ronlsb_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","La fel, și al doilea, și al treilea, până la al șaptelea. ");
INSERT INTO ronlsb_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","După ei toți, femeia a murit. ");
INSERT INTO ronlsb_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","La înviere, așadar, a cui va fi soția dintre cei șapte? Căci toți au avut-o.” ");
INSERT INTO ronlsb_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Dar Isus le-a răspuns: “Vă înșelați, căci nu cunoașteți Scripturile și nu știți puterea lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Căci la înviere nu se căsătoresc și nici nu sunt dați în căsătorie, ci sunt ca îngerii lui Dumnezeu în ceruri. ");
INSERT INTO ronlsb_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Dar, în ce privește învierea morților, nu ați citit ce v-a spus Dumnezeu, când a zis: ");
INSERT INTO ronlsb_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Eu sunt Dumnezeul lui Avraam, Dumnezeul lui Isaac și Dumnezeul lui Iacov”? Dumnezeu nu este Dumnezeul morților, ci al celor vii.” ");
INSERT INTO ronlsb_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Când au auzit mulțimile, au rămas uimite de învățătura lui. ");
INSERT INTO ronlsb_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Dar fariseii, auzind că i-a redus la tăcere pe saduchei, s-au adunat. ");
INSERT INTO ronlsb_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Unul dintre ei, un avocat, i-a pus o întrebare, punându-l la încercare. ");
INSERT INTO ronlsb_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Învățătorule, care este cea mai mare poruncă din Lege?” ");
INSERT INTO ronlsb_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Isus i-a zis: “Să iubești pe Domnul Dumnezeul tău din toată inima ta, din tot sufletul tău și din tot cugetul tău. ");
INSERT INTO ronlsb_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Aceasta este cea dintâi și cea mai mare poruncă. ");
INSERT INTO ronlsb_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","A doua, la fel, este aceasta: “Să iubești pe aproapele tău ca pe tine însuți”. ");
INSERT INTO ronlsb_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Toată Legea și profeții depind de aceste două porunci.” ");
INSERT INTO ronlsb_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Pe când se adunaseră fariseii, Isus le-a pus o întrebare, ");
INSERT INTO ronlsb_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","și le-a zis: “Ce credeți voi despre Hristos? Al cui fiu este El?” I-au spus: “De David”. ");
INSERT INTO ronlsb_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","El le-a zis: “Cum deci David, în Duhul Sfânt, Îl numește Domn, zicând, ");
INSERT INTO ronlsb_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Domnul a zis Domnului meu, stai la dreapta mea, până când voi face din vrăjmașii tăi un scăunel pentru picioarele tale”? ");
INSERT INTO ronlsb_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Dacă David îl numește Domn, cum este el fiul său?” ");
INSERT INTO ronlsb_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nimeni n-a putut să-i răspundă nimic și nimeni n-a îndrăznit să-i mai pună vreo întrebare din ziua aceea. ");
INSERT INTO ronlsb_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Atunci Isus a vorbit mulțimilor și ucenicilor Săi, ");
INSERT INTO ronlsb_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","și a zis: “Cărturarii și fariseii stau pe scaunul lui Moise. ");
INSERT INTO ronlsb_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Așadar, tot ce vă spun ei să observați, observați și faceți, dar nu faceți faptele lor; căci ei spun și nu fac. ");
INSERT INTO ronlsb_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Căci ei leagă poveri grele, greu de purtat, și le pun pe umerii oamenilor, dar ei înșiși nu vor să ridice un deget pentru a-i ajuta. ");
INSERT INTO ronlsb_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ci își fac toate faptele lor ca să fie văzute de oameni. Își lărgesc filacteriile și își lărgesc franjurile hainelor lor, ");
INSERT INTO ronlsb_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","și le place locul de cinste la sărbători, locurile cele mai bune din sinagogi, ");
INSERT INTO ronlsb_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","salutul în piețe și să fie numiți de oameni “Rabi, Rabi, Rabi”. ");
INSERT INTO ronlsb_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Dar voi nu trebuie să fiți numiți “Rabi”, căci unul singur este învățătorul vostru, Hristosul, și voi toți sunteți frați. ");
INSERT INTO ronlsb_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Nu numiți pe nimeni de pe pământ Tatăl vostru, căci unul singur este Tatăl vostru, Cel din ceruri. ");
INSERT INTO ronlsb_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Și nu vă numiți nici stăpâni, căci unul singur este stăpânul vostru, Hristosul. ");
INSERT INTO ronlsb_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ci cel care este cel mai mare dintre voi va fi robul vostru. ");
INSERT INTO ronlsb_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Cine se înalță va fi smerit, iar cine se smerește va fi înălțat. ");
INSERT INTO ronlsb_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Vai vouă, cărturari și farisei, fățarnici! Căci voi devorați casele văduvelor și, ca un pretext, faceți rugăciuni lungi. De aceea veți primi o condamnare și mai mare. ");
INSERT INTO ronlsb_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Dar vai de voi, cărturari și farisei, fățarnici! Pentru că voi închideți Împărăția Cerurilor împotriva oamenilor; pentru că voi înșivă nu intrați înăuntru, și nici pe cei care intră nu-i lăsați să intre. ");
INSERT INTO ronlsb_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Vai vouă, cărturari și farisei, ipocriților! Pentru că voi călătoriți pe mare și pe uscat ca să faceți un singur proselit; și când acesta devine unul, îl faceți de două ori mai fiu al Gheenei decât voi înșivă. ");
INSERT INTO ronlsb_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Vai de voi, călăuze oarbe, care ziceți: “Oricine se jură pe templu, nu este nimic; dar oricine se jură pe aurul templului, este obligat. ");
INSERT INTO ronlsb_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Voi, nebuni orbi! Căci ce este mai mare, aurul sau templul care sfințește aurul? ");
INSERT INTO ronlsb_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Și: “Oricine se jură pe altar, nu este nimic; dar oricine se jură pe darul care este pe el, este obligat?” ");
INSERT INTO ronlsb_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nebuni orbi! Căci ce este mai mare, darul sau altarul care sfințește darul? ");
INSERT INTO ronlsb_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Așadar, cine jură pe altar, jură pe el și pe tot ce este pe el. ");
INSERT INTO ronlsb_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Cine se jură pe templu, se jură pe el și pe cel care a locuit în el. ");
INSERT INTO ronlsb_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Cine se jură pe cer, se jură pe tronul lui Dumnezeu și pe cel care stă pe el. ");
INSERT INTO ronlsb_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Vai de voi, cărturari și farisei, fățarnici! Pentru că voi dați zeciuială la mentă, mărar și chimen și ați lăsat deoparte cele mai grele lucruri ale Legii: dreptatea, mila și credința. Dar trebuia să le faceți pe acestea și să nu le lăsați pe celelalte nefăcute. ");
INSERT INTO ronlsb_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Voi, călăuze oarbe, care strecurați un țânțar și înghițiți o cămilă! ");
INSERT INTO ronlsb_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Vai vouă, cărturari și farisei, fățarnici! Pentru că voi curățați partea exterioară a paharului și a farfuriei, dar înăuntru sunt pline de jaf și de nedreptate. ");
INSERT INTO ronlsb_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Fariseu orb, curăță mai întâi interiorul paharului și al platoului, pentru ca și exteriorul lui să devină curat. ");
INSERT INTO ronlsb_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Vai de voi, cărturari și farisei, fățarnici! Pentru că sunteți ca niște morminte albite, care în afară par frumoase, dar înăuntru sunt pline de oase de morți și de toată necurăția. ");
INSERT INTO ronlsb_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Tot așa și voi, în aparență, păreți drepți în fața oamenilor, dar pe dinăuntru sunteți plini de fățărnicie și de nelegiuire. ");
INSERT INTO ronlsb_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Vai vouă, cărturari și farisei, fățarnici! Căci voi zidiți mormintele profeților și împodobiți mormintele drepților ");
INSERT INTO ronlsb_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","și spuneți: “Dacă am fi trăit în zilele părinților noștri, nu am fi fost părtași cu ei la sângele profeților”. ");
INSERT INTO ronlsb_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","De aceea vă mărturisiți vouă înșivă că sunteți copiii celor care au ucis pe profeți. ");
INSERT INTO ronlsb_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Umpleți, așadar, măsura părinților voștri. ");
INSERT INTO ronlsb_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Voi, șerpi, urmași ai viperelor, cum veți scăpa de judecata Gheenei? ");
INSERT INTO ronlsb_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","De aceea, iată, trimit la voi profeți, înțelepți și cărturari. Pe unii dintre ei îi veți ucide și îi veți răstigni, iar pe alții îi veți biciui în sinagogile voastre și îi veți persecuta din cetate în cetate, ");
INSERT INTO ronlsb_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","pentru ca asupra voastră să cadă tot sângele neprihănit vărsat pe pământ, de la sângele neprihănitului Abel până la sângele lui Zaharia, fiul lui Barachia, pe care l-ați ucis între sanctuar și altar. ");
INSERT INTO ronlsb_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Cu siguranță vă spun că toate aceste lucruri vor veni peste această generație. ");
INSERT INTO ronlsb_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Ierusalime, Ierusalime, care ucizi pe prooroci și ucizi cu pietre pe cei trimiși la ea! De câte ori aș fi vrut să-ți adun copiii, cum își adună găina puii sub aripi, și tu n-ai vrut! ");
INSERT INTO ronlsb_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Iată, casa ta este lăsată pustie pentru tine. ");
INSERT INTO ronlsb_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Căcivă spun că nu mă veți mai vedea de acum înainte, până când nu veți zice: “Binecuvântat este cel ce vine în numele Domnului!”.” ");
INSERT INTO ronlsb_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Isus a ieșit din templu și mergea pe drumul Său. Discipolii săi au venit la el ca să-i arate clădirile templului. ");
INSERT INTO ronlsb_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Dar el le-a răspuns: “Voi vedeți toate aceste lucruri, nu-i așa? Cu siguranță vă spun că nu va rămâne aici piatră peste piatră care să nu fie dărâmată.” ");
INSERT INTO ronlsb_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Pe când ședea El pe Muntele Măslinilor, ucenicii au venit la El în particular și I-au zis: “Spune-ne, când se vor întâmpla aceste lucruri? Care este semnul venirii Tale și al sfârșitului veacului?” ");
INSERT INTO ronlsb_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Isus le-a răspuns: “Luați seama ca nimeni să nu vă rătăcească. ");
INSERT INTO ronlsb_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Căci mulți vor veni în numele Meu, zicând: “Eu sunt Hristosul”, și vor duce pe mulți în rătăcire. ");
INSERT INTO ronlsb_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Veți auzi de războaie și de zvonuri de războaie. Aveți grijă să nu vă tulburați, căci toate acestea trebuie să se întâmple, dar sfârșitul nu este încă. ");
INSERT INTO ronlsb_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Căci se va ridica națiune împotriva națiunii și regat împotriva regatului, și vor fi foamete, ciumă și cutremure în diferite locuri. ");
INSERT INTO ronlsb_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Dar toate aceste lucruri sunt începutul durerilor nașterii. ");
INSERT INTO ronlsb_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Atunci vă vor da pe voi la asuprire și vă vor ucide. Veți fi urâți de toate neamurile din cauza numelui Meu. ");
INSERT INTO ronlsb_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Atunci mulți se vor poticni, se vor preda unii pe alții și se vor urî unii pe alții. ");
INSERT INTO ronlsb_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Se vor ridica mulți profeți falși și vor duce pe mulți în rătăcire. ");
INSERT INTO ronlsb_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Pentru că se va înmulți nelegiuirea, dragostea multora se va răci. ");
INSERT INTO ronlsb_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Dar cel care va răbda până la sfârșit va fi mântuit. ");
INSERT INTO ronlsb_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Această Veste Bună a Împărăției va fi propovăduită în toată lumea, ca mărturie pentru toate națiunile, și atunci va veni sfârșitul. ");
INSERT INTO ronlsb_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Când veți vedea urâciunea pustiirii, despre care s-a vorbit prin proorocul Daniel, stând în sfântul locaș (să înțeleagă cititorul), ");
INSERT INTO ronlsb_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","atunci cei ce sunt în Iudeea să fugă în munți. ");
INSERT INTO ronlsb_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Cel care este pe acoperișul casei să nu se coboare să scoată lucrurile care sunt în casa lui. ");
INSERT INTO ronlsb_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Cel care este pe câmp să nu se întoarcă să își ia hainele. ");
INSERT INTO ronlsb_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Dar vai de cele însărcinate și de mamele care alăptează în acele zile! ");
INSERT INTO ronlsb_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Rugați-vă ca fuga voastră să nu fie în timpul iernii și nici într-un Sabat, ");
INSERT INTO ronlsb_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","pentru că atunci va fi o mare suferință, așa cum nu a fost de la începutul lumii până acum, nu, și nici nu va fi vreodată. ");
INSERT INTO ronlsb_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Dacă acele zile nu ar fi fost scurtate, nicio făptură nu ar fi fost salvată. Dar, de dragul celor aleși, acele zile vor fi scurtate. ");
INSERT INTO ronlsb_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Dacă vă va spune cineva: “Iată, aici este Hristosul!” sau: “Iată!”, nu-l credeți. ");
INSERT INTO ronlsb_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Căci se vor ridica falși hristoși și falși profeți, care vor face semne și minuni mari, ca să ducă în rătăcire, dacă este posibil, chiar și pe cei aleși. ");
INSERT INTO ronlsb_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","“Iată, v-am spus mai dinainte. ");
INSERT INTO ronlsb_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","De aceea, dacă vă vor spune: “Iată-l în pustie”, nu ieșiți; sau “Iată-l în lăcașuri”, nu credeți. ");
INSERT INTO ronlsb_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Căci, după cum fulgerul fulgeră de la răsărit și se vede până la apus, așa va fi și venirea Fiului Omului. ");
INSERT INTO ronlsb_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Căci oriunde este cadavrul, acolo se adună vulturii. ");
INSERT INTO ronlsb_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Dar îndată după suferința acelor zile, soarele se va întuneca, luna nu va mai lumina, stelele vor cădea din cer și puterile cerurilor se vor clătina; ");
INSERT INTO ronlsb_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","și atunci va apărea pe cer semnul Fiului Omului. Atunci toate semințiile pământului vor plânge și vor vedea pe Fiul Omului venind pe norii cerului cu putere și cu mare slavă. ");
INSERT INTO ronlsb_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","El va trimite pe îngerii Săi cu un sunet mare de trâmbiță și vor aduna pe cei aleși ai Săi din cele patru vânturi, de la un capăt la altul al cerului. ");
INSERT INTO ronlsb_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Învățați acum de la smochin pilda aceasta: Când ramura lui s-a înmuiat și produce frunze, știți că vara este aproape. ");
INSERT INTO ronlsb_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Tot așa și voi, când vedeți toate aceste lucruri, știți că El este aproape, chiar la uși. ");
INSERT INTO ronlsb_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Adevărat vă spun că generația aceasta nu va trece până când nu se vor împlini toate aceste lucruri. ");
INSERT INTO ronlsb_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Cerul și pământul vor trece, dar cuvintele Mele nu vor trece. ");
INSERT INTO ronlsb_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Dar nimeni nu știe ziua și ceasul acela, nici îngerii din ceruri, ci numai Tatăl Meu. ");
INSERT INTO ronlsb_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Cum au fost zilele lui Noe, așa va fi și venirea Fiului Omului. ");
INSERT INTO ronlsb_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Căci, după cum în zilele de dinaintea potopului mâncau și beau, se căsătoreau și se dădeau în căsătorie, până în ziua în care Noe a intrat în corabie, ");
INSERT INTO ronlsb_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","și nu au știut până când a venit potopul și i-a luat pe toți, așa va fi și venirea Fiului Omului. ");
INSERT INTO ronlsb_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Atunci doi oameni vor fi pe câmp: unul va fi luat și unul va rămâne. ");
INSERT INTO ronlsb_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Două femei vor fi măcinând la moară: una va fi luată și una va fi lăsată. ");
INSERT INTO ronlsb_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Vegheați deci, căci nu știți în ce ceas vine Domnul vostru. ");
INSERT INTO ronlsb_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Dar să știți că, dacă stăpânul casei ar fi știut în ce ceas al nopții va veni hoțul, ar fi vegheat și nu ar fi îngăduit să i se spargă casa. ");
INSERT INTO ronlsb_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","De aceea și voi fiți gata, căci în ceasul la care nu vă așteptați, Fiul Omului va veni. ");
INSERT INTO ronlsb_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Cine este robul credincios și înțelept, pe care l-a pus stăpânul său peste casa sa, ca să le dea hrana la vremea potrivită? ");
INSERT INTO ronlsb_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ferice de robul acela pe care îl găsește făcând așa când vine stăpânul său! ");
INSERT INTO ronlsb_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Cu siguranță vă spun că îl va pune peste tot ce are. ");
INSERT INTO ronlsb_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Dar dacă robul acela rău va zice în inima lui: “Stăpânul meu întârzie să vină”, ");
INSERT INTO ronlsb_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","și va începe să-și bată tovarășii de slujbă, să mănânce și să bea cu bețivii, ");
INSERT INTO ronlsb_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","stăpânul acelui rob va veni într-o zi când nu se va aștepta și într-un ceas când nu va ști, ");
INSERT INTO ronlsb_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","și-l va tăia în bucăți și-i va rândui partea lui cu ipocriții. Acolo va fi plânsul și scrâșnitul dinților. ");
INSERT INTO ronlsb_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Atunci Împărăția Cerurilor va fi ca zece fecioare care și-au luat lămpile și au ieșit în întâmpinarea mirelui. ");
INSERT INTO ronlsb_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Cinci dintre ele erau nebune, iar cinci erau înțelepte. ");
INSERT INTO ronlsb_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Cele care erau nebune, când și-au luat lămpile, nu au luat ulei cu ele, ");
INSERT INTO ronlsb_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","dar cele înțelepte au luat ulei în vasele lor împreună cu lămpile lor. ");
INSERT INTO ronlsb_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Și, pe când întârzia mirele, toate au adormit și au dormit. ");
INSERT INTO ronlsb_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Dar la miezul nopții s-a auzit un strigăt: “Iată! Vine mirele! Ieșiți în întâmpinarea lui! ");
INSERT INTO ronlsb_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Atunci toate acele fecioare s-au sculat și și-au aranjat lămpile. ");
INSERT INTO ronlsb_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Cele nebune au zis celor înțelepte: “Dați-ne puțin din untdelemnul vostru, căci lămpile noastre se sting. ");
INSERT INTO ronlsb_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Dar înțeleptele au răspuns: “Și dacă nu este destul pentru noi și pentru voi? Mergeți mai degrabă la cei care vând și cumpărați pentru voi înșivă'. ");
INSERT INTO ronlsb_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","În timp ce ele se duceau să cumpere, a venit mirele, și cele care erau pregătite au intrat cu el la ospățul de nuntă, și ușa s-a închis. ");
INSERT INTO ronlsb_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","După aceea au venit și celelalte fecioare, zicând: “Doamne, Doamne, deschide-ne!”. ");
INSERT INTO ronlsb_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Dar El a răspuns: “Adevărat vă spun că nu vă cunosc. ");
INSERT INTO ronlsb_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Vegheați, deci, pentru că nu știți nici ziua, nici ceasul în care va veni Fiul Omului. ");
INSERT INTO ronlsb_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Căci este ca un om care se duce în altă țară, care și-a chemat slugile sale și le-a încredințat bunurile sale. ");
INSERT INTO ronlsb_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Unuia i-a dat cinci talanți, altuia doi, altuia unul, și altuia unul, fiecăruia după putința lui. Apoi și-a continuat călătoria. ");
INSERT INTO ronlsb_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Imediat, cel care a primit cei cinci talanți s-a dus și a făcut schimb cu ei și a făcut alți cinci talanți. ");
INSERT INTO ronlsb_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","La fel, și cel care a primit cei doi a mai câștigat încă doi. ");
INSERT INTO ronlsb_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Dar cel care a primit un talant s-a dus, a săpat în pământ și a ascuns banii stăpânului său. ");
INSERT INTO ronlsb_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“După multă vreme, a venit stăpânul acelor robi și a făcut socoteli cu ei. ");
INSERT INTO ronlsb_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Cel care primise cei cinci talanți a venit și a adus alți cinci talanți, zicând: “Doamne, mi-ai dat cinci talanți. Iată, am câștigat alți cinci talanți în plus față de ei'. ");
INSERT INTO ronlsb_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Domnul său i-a zis: “Bine, slugă bună și credincioasă. Ai fost credincios peste puține lucruri, te voi pune peste multe lucruri. Intră în bucuria stăpânului tău'. ");
INSERT INTO ronlsb_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Și cel ce a primit cei doi talanți a venit și a zis: “Doamne, mi-ai dat doi talanți. Iată, am mai câștigat încă doi talanți în plus față de ei'. ");
INSERT INTO ronlsb_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Domnul său i-a zis: “Bine, slugă bună și credincioasă. Ai fost credincios în privința câtorva lucruri. Eu te voi pune peste multe lucruri. Intră în bucuria stăpânului tău'. ");
INSERT INTO ronlsb_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Cel care primise un talant a venit și a zis: “Doamne, te-am cunoscut că ești un om aspru, că seceri de unde n-ai semănat și aduni de unde n-ai împrăștiat. ");
INSERT INTO ronlsb_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","M-am temut, m-am dus și am ascuns talantul tău în pământ. Iată că ai ceea ce este al tău'. ");
INSERT INTO ronlsb_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Dar stăpânul său i-a răspuns: “Slugă rea și leneșă! Știai că secer unde n-am semănat și adun unde n-am împrăștiat. ");
INSERT INTO ronlsb_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Trebuia deci să fi depus banii mei la bancheri și, la venirea mea, să-i primesc înapoi pe ai mei cu dobândă. ");
INSERT INTO ronlsb_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Luați deci talantul de la el și dați-l celui care are zece talanți. ");
INSERT INTO ronlsb_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Căci fiecăruia care are i se va da și va avea din belșug, dar celui care nu are i se va lua chiar și ceea ce are. ");
INSERT INTO ronlsb_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Aruncați-l pe robul nefolositor în întunericul de afară, unde va fi plâns și scrâșnit din dinți. ");
INSERT INTO ronlsb_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Dar când va veni Fiul Omului în slava Sa și toți sfinții îngeri cu El, atunci va ședea pe tronul slavei Sale. ");
INSERT INTO ronlsb_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Înaintea Lui se vor aduna toate neamurile și El le va despărți unele de altele, așa cum un păstor desparte oile de capre. ");
INSERT INTO ronlsb_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","El va pune oile la dreapta Sa, iar caprele la stânga. ");
INSERT INTO ronlsb_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Atunci Regele le va spune celor de la dreapta sa: 'Veniți, binecuvântați de Tatăl meu, moșteniți Împărăția pregătită pentru voi de la întemeierea lumii; ");
INSERT INTO ronlsb_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","căci mie mi-a fost foame și voi mi-ați dat de mâncare. Mi-a fost sete și mi-ați dat să beau. Am fost străin și m-ați primit în casă. ");
INSERT INTO ronlsb_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","am fost gol și m-ați îmbrăcat. Am fost bolnav și m-ați vizitat. Am fost în închisoare și ați venit la mine. ");
INSERT INTO ronlsb_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Atunci cei drepți Îi vor răspunde și vor zice: “Doamne, când Te-am văzut noi flămând și Te-am hrănit, sau însetat și Ți-am dat de băut? ");
INSERT INTO ronlsb_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Când Te-am văzut străin și Te-am primit la noi, sau gol și Te-am îmbrăcat? ");
INSERT INTO ronlsb_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Când Te-am văzut bolnav sau în închisoare și am venit la Tine?”. ");
INSERT INTO ronlsb_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Împăratul le va răspunde: “Adevărat vă spun că, pentru că ați făcut aceasta unuia dintre acești frați ai Mei cei mai mici, Mie Mi-ați făcut-o. ");
INSERT INTO ronlsb_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Apoi va spune și celor de la stânga: 'Duceți-vă de la Mine, blestemaților, în focul cel veșnic, pregătit diavolului și îngerilor lui; ");
INSERT INTO ronlsb_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","pentru că am fost flămând și nu Mi-ați dat să mănânc; Mi-a fost sete și nu Mi-ați dat să beau; ");
INSERT INTO ronlsb_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","am fost străin și nu M-ați găzduit; gol și nu M-ați îmbrăcat; bolnav și în temniță și nu M-ați vizitat'. ");
INSERT INTO ronlsb_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Atunci vor răspunde și ei, zicând: Doamne, când Te-am văzut noi flămând, sau însetat, sau străin, sau gol, sau bolnav, sau în temniță, și nu Te-am ajutat? ");
INSERT INTO ronlsb_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Atunci El le va răspunde și le va zice: “Adevărat vă spun că, dacă n-ați făcut lucrul acesta unuia dintre cei mai mici dintre aceștia, nici Mie nu Mi l-ați făcut. ");
INSERT INTO ronlsb_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Aceștiavor pleca la pedeapsa veșnică, dar cei drepți la viața veșnică.” ");
INSERT INTO ronlsb_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","După ce a isprăvit toate aceste cuvinte, Isus a zis ucenicilor Săi: ");
INSERT INTO ronlsb_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Știți că peste două zile vine Paștele și Fiul Omului va fi dat spre răstignire.” ");
INSERT INTO ronlsb_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Atunci preoții cei mai de seamă, cărturarii și bătrânii poporului s-au adunat în curtea marelui preot, care se numea Caiafa. ");
INSERT INTO ronlsb_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","S-au sfătuit împreună ca să prindă pe Isus prin înșelăciune și să-L omoare. ");
INSERT INTO ronlsb_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Dar ei au spus: “Nu în timpul sărbătorii, ca să nu se producă o răscoală în popor”. ");
INSERT INTO ronlsb_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Pe când era Isus în Betania, în casa lui Simon leprosul, ");
INSERT INTO ronlsb_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","a venit la El o femeie care avea un vas de alabastru cu mir de mare preț, și a turnat mir pe capul Lui, pe când ședea la masă. ");
INSERT INTO ronlsb_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ucenicii Lui, văzând aceasta, s-au indignat și au zis: “De ce această risipă? ");
INSERT INTO ronlsb_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","pentru că acest unguent ar fi putut fi vândut cu mult și dat săracilor.” ");
INSERT INTO ronlsb_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Dar Isus, știind aceasta, le-a zis: “De ce tulburați pe femeie? Ea a făcut o faptă bună pentru mine. ");
INSERT INTO ronlsb_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Pentru că voi aveți întotdeauna săraci cu voi, dar pe mine nu mă aveți întotdeauna. ");
INSERT INTO ronlsb_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Căci, turnând acest mir pe trupul meu, ea a făcut-o ca să mă pregătească pentru înmormântare. ");
INSERT INTO ronlsb_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Adevărat vă spun că, oriunde se va propovădui această Bună Vestire în toată lumea, se va vorbi și despre ceea ce a făcut această femeie, ca o amintire a ei.” ");
INSERT INTO ronlsb_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Atunci unul din cei doisprezece, numit Iuda Iscarioteanul, s-a dus la preoții cei mai de seamă ");
INSERT INTO ronlsb_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","și le-a zis: “Cât vreți să-mi dați dacă vi-l predau?” Și au cântărit pentru el treizeci de arginți. ");
INSERT INTO ronlsb_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Din acel moment a căutat prilej să îl trădeze. ");
INSERT INTO ronlsb_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","În prima zi a azimilor, ucenicii au venit la Isus și I-au zis: “Unde vrei să-Ți pregătim Paștile?” ");
INSERT INTO ronlsb_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Și a zis: “Du-te în cetate la un oarecare și spune-i: “Învățătorul zice: “Vremea Mea este aproape. Voi sărbători Paștele în casa ta împreună cu discipolii mei.\"”””. ");
INSERT INTO ronlsb_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ucenicii au făcut cum le poruncise Isus și au pregătit Paștele. ");
INSERT INTO ronlsb_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Când s-a făcut seară, El stătea la masă cu cei doisprezece ucenici. ");
INSERT INTO ronlsb_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","În timp ce mâncau, a zis: “Cu siguranță vă spun că unul dintre voi Mă va trăda.” ");
INSERT INTO ronlsb_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ei erau foarte mâhniți, și fiecare dintre ei a început să-L întrebe: “Nu sunt eu, Doamne, nu-i așa?” ");
INSERT INTO ronlsb_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","El a răspuns: “Cel ce și-a înmuiat mâna cu mine în vasul acesta mă va trăda. ");
INSERT INTO ronlsb_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Fiul Omului merge așa cum este scris despre El, dar vai de omul prin care va fi trădat Fiul Omului! Mai bine ar fi fost pentru acel om dacă nu s-ar fi născut.” ");
INSERT INTO ronlsb_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Iuda, care L-a trădat, a răspuns: “Nu sunt eu, nu-i așa, Rabbi?” El i-a spus: “Tu ai spus-o”. ");
INSERT INTO ronlsb_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Pe când mâncau ei, Isus a luat o pâine, a mulțumit pentru ea și a frânt-o. A dat-o ucenicilor și a zis: “Luați, mâncați; acesta este trupul Meu.” ");
INSERT INTO ronlsb_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","A luat paharul, a mulțumit și le-a dat, zicând: “Beți-l toți, ");
INSERT INTO ronlsb_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","căci acesta este sângele Meu, al noului legământ, care se varsă pentru mulți, spre iertarea păcatelor. ");
INSERT INTO ronlsb_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Dar vă spun că nu voi mai bea din acest fruct al viței de vie de acum înainte, până în ziua în care îl voi bea din nou cu voi în Împărăția Tatălui meu.” ");
INSERT INTO ronlsb_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","După ce au cântat un imn, au ieșit pe Muntele Măslinilor. ");
INSERT INTO ronlsb_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Atunci Isus le-a zis: “În noaptea aceasta, toți vă veți poticni din pricina Mea, căci este scris: “Voi lovi pe păstor și oile turmei vor fi risipite. ");
INSERT INTO ronlsb_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Dar, după ce voi fi înviat, voi merge înaintea voastră în Galileea.” ");
INSERT INTO ronlsb_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Dar Petru i-a răspuns: “Chiar dacă toți se vor poticni din pricina ta, eu nu mă voi poticni niciodată.” ");
INSERT INTO ronlsb_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Isus i-a zis: “Adevărat îți spun că în seara aceasta, până nu va cânta cocoșul, te vei lepăda de Mine de trei ori.” ");
INSERT INTO ronlsb_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petru I-a zis: “Chiar dacă ar fi să mor cu Tine, nu Mă voi lepăda de Tine.” Și toți ucenicii au spus la fel. ");
INSERT INTO ronlsb_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Atunci Isus a venit cu ei la un loc numit Ghetsimani și a zis ucenicilor Săi: “Stați aici, până ce Mă voi duce acolo să Mă rog.” ");
INSERT INTO ronlsb_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","A luat cu El pe Petru și pe cei doi fii ai lui Zebedei, și a început să se întristeze și să fie foarte tulburat. ");
INSERT INTO ronlsb_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Și le-a zis: “Sufletul Meu este foarte îndurerat, până la moarte. Rămâneți aici și vegheați cu mine”. ");
INSERT INTO ronlsb_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","El a înaintat puțin, a căzut cu fața la pământ și se ruga, zicând: “Tatăl Meu, dacă este cu putință, să treacă de la Mine paharul acesta; dar nu ceea ce vreau eu, ci ceea ce vrei Tu.” ");
INSERT INTO ronlsb_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","A venit la ucenici și, găsindu-i dormind, a zis lui Petru: “Ce, n-ați putut să vegheați cu Mine un ceas? ");
INSERT INTO ronlsb_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Vegheați și rugați-vă, ca să nu intrați în ispită. Într-adevăr, duhul este binevoitor, dar carnea este slabă.” ");
INSERT INTO ronlsb_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Și iarăși S-a dus a doua oară și S-a rugat, zicând: “Tatăl Meu, dacă paharul acesta nu poate să treacă de la Mine, dacă nu-l beau, facă-se voia Ta.” ");
INSERT INTO ronlsb_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","A venit iarăși și i-a găsit dormind, căci aveau ochii îngreunați. ");
INSERT INTO ronlsb_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","I-a lăsat din nou, s-a dus și s-a rugat a treia oară, spunând aceleași cuvinte. ");
INSERT INTO ronlsb_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Apoi a venit la ucenicii Săi și le-a zis: “Încă mai dormiți și vă odihniți? Iată că s-a apropiat ceasul și Fiul Omului este dat în mâinile păcătoșilor. ");
INSERT INTO ronlsb_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ridicați-vă, să mergem. Iată, cel care mă trădează este aproape”. ");
INSERT INTO ronlsb_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Pe când vorbea El încă, iată că a venit Iuda, unul din cei doisprezece, și împreună cu el o mare mulțime de preoți de seamă și de bătrâni ai poporului, cu săbii și cu ciomege. ");
INSERT INTO ronlsb_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Cel care l-a trădat le dăduse un semn, zicând: “Pe cine sărut eu, acela este. Prindeți-l!”. ");
INSERT INTO ronlsb_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Imediat s-a apropiat de Isus, a zis: “Salutări, Rabi!” și l-a sărutat. ");
INSERT INTO ronlsb_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Isus i-a zis: “Prietene, ce cauți aici?” Atunci au venit, au pus mâinile pe Isus și L-au luat. ");
INSERT INTO ronlsb_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Iată că unul dintre cei care erau cu Isus a întins mâna și a scos sabia, a lovit pe slujitorul marelui preot și i-a tăiat urechea. ");
INSERT INTO ronlsb_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Atunci Isus i-a zis: “Pune-ți sabia la locul ei, căci toți cei ce iau sabia vor muri de sabie. ");
INSERT INTO ronlsb_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Sau crezi că n-aș putea să-L rog pe Tatăl Meu și chiar acum să-mi trimită mai mult de douăsprezece legiuni de îngeri? ");
INSERT INTO ronlsb_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Cum s-ar împlini atunci Scripturile care trebuie să fie așa?” ");
INSERT INTO ronlsb_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","În ceasul acela, Isus a zis mulțimii: “Ați ieșit voi ca un tâlhar, cu săbii și cu ciomege, ca să Mă prindeți? Eu stăteam în fiecare zi în templu, învățând, și voi nu m-ați arestat. ");
INSERT INTO ronlsb_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Dar toate acestea s-au întâmplat pentru ca să se împlinească Scripturile profeților.” Atunci toți ucenicii l-au lăsat și au fugit. ");
INSERT INTO ronlsb_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Cei ce luaseră pe Isus L-au dus la Caiafa, marele preot, unde erau adunați cărturarii și bătrânii. ");
INSERT INTO ronlsb_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Dar Petru L-a urmărit de la distanță până la curtea marelui preot, a intrat și a șezut cu ofițerii, ca să vadă sfârșitul. ");
INSERT INTO ronlsb_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Iar preoții cei mai de seamă, bătrânii și tot sfatul căutau mărturii false împotriva lui Isus, ca să-L omoare, ");
INSERT INTO ronlsb_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","dar n-au găsit niciuna. Chiar dacă s-au prezentat mulți martori mincinoși, nu au găsit niciunul. Dar, în cele din urmă, doi martori mincinoși au ieșit în față ");
INSERT INTO ronlsb_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","și au spus: “Omul acesta a spus: “Pot să distrug templul lui Dumnezeu și să-l zidesc în trei zile””. ");
INSERT INTO ronlsb_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Marele preot s-a ridicat în picioare și i-a zis: “Nu ai răspuns? Ce este ceea ce mărturisesc aceștia împotriva ta?” ");
INSERT INTO ronlsb_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Dar Isus a tăcut. Marele preot i-a răspuns: “Te conjur, pe Dumnezeul cel viu, să ne spui dacă Tu ești Hristosul, Fiul lui Dumnezeu.” ");
INSERT INTO ronlsb_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Isus i-a zis: “Așa ai spus. Cu toate acestea, îți spun că, după aceea, îl vei vedea pe Fiul Omului șezând la dreapta Puterii și venind pe norii cerului.” ");
INSERT INTO ronlsb_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Atunci marele preot și-a rupt hainele și a zis: “A spus o blasfemie! De ce mai avem nevoie de alți martori? Iată, acum ați auzit blasfemia lui. ");
INSERT INTO ronlsb_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ce părere aveți?” Ei au răspuns: “Este vrednic de moarte!” ");
INSERT INTO ronlsb_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Atunci l-au scuipat în față și l-au bătut cu pumnii, iar unii l-au pălmuit, ");
INSERT INTO ronlsb_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","zicând: “Propovăduiește-ne, Hristoase! Cine te-a lovit?”. ");
INSERT INTO ronlsb_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Petru ședea afară, în curte, și o slujnică a venit la el și i-a zis: “Și tu ai fost cu Iisus Galileanul!” ");
INSERT INTO ronlsb_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Dar el a negat în fața tuturor, zicând: “Nu știu despre ce vorbiți.” ");
INSERT INTO ronlsb_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","După ce a ieșit afară pe prispă, l-a văzut altcineva și a zis celor ce erau acolo: “Și acesta a fost cu Isus din Nazaret.” ");
INSERT INTO ronlsb_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","El a negat din nou cu jurământ: “Nu-l cunosc pe omul acesta.” ");
INSERT INTO ronlsb_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","După puțină vreme, cei ce stăteau de față au venit și au zis lui Petru: “Cu siguranță și tu ești unul dintre ei, căci vorbirea ta te face cunoscut.” ");
INSERT INTO ronlsb_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Atunci a început să înjure și să jure: “Nu-l cunosc pe omul acela!” Imediat a cântat cocoșul. ");
INSERT INTO ronlsb_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Petru și-a adus aminte de cuvântul pe care i-l spusese Isus: “Înainte de a cânta cocoșul, te vei lepăda de Mine de trei ori”. Atunci a ieșit afară și a plâns cu amar. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Când a venit dimineața, toți preoții cei mai de seamă și bătrânii poporului s-au sfătuit împotriva lui Isus ca să-L omoare. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","L-au legat, L-au dus și L-au predat guvernatorului Ponțiu Pilat. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Atunci Iuda, care L-a trădat, văzând că Isus a fost osândit, a avut remușcări și a adus înapoi cei treizeci de arginți preoților cei mai de seamă și bătrânilor, ");
INSERT INTO ronlsb_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","zicând: “Am păcătuit că am trădat sânge nevinovat.” Dar ei au spus: “Ce ne pasă nouă de asta? Voi vă ocupați de asta”. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","A aruncat piesele de argint în sanctuar și a plecat. Apoi s-a dus și s-a spânzurat. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Preoții cei mai de seamă au luat arginții și au zis: “Nu este îngăduit să-i punem în vistierie, fiindcă este prețul sângelui.” ");
INSERT INTO ronlsb_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","S-au sfătuit și au cumpărat cu ele câmpul olarului pentru a îngropa străinii. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","De aceea, câmpul acela a fost numit până în ziua de azi “Câmpul de sânge”. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Atunci s-a împlinit ceea ce fusese spus prin profetul Ieremia, care zicea “Au luat cei treizeci de arginți, prețul celui căruia i s-a pus un preț, pe care unii dintre copiii lui Israel l-au taxat, ");
INSERT INTO ronlsb_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","și le-au dat pentru câmpul olarului, așa cum mi-a poruncit Domnul.” ");
INSERT INTO ronlsb_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Isus a stat în picioare înaintea guvernatorului; și guvernatorul L-a întrebat: “Ești Tu Împăratul iudeilor?” Isus i-a zis: “Așa zici tu”. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Când a fost acuzat de preoții cei mai de seamă și de bătrâni, n-a răspuns nimic. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Atunci Pilat i-a zis: “Nu auzi câte mărturisiri se fac împotriva ta?” ");
INSERT INTO ronlsb_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","El nu i-a răspuns, nici măcar un cuvânt, așa că guvernatorul s-a mirat foarte mult. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","La sărbătoare, guvernatorul obișnuia să elibereze mulțimii câte un prizonier pe care îl dorea. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ei aveau atunci un prizonier de seamă, numit Baraba. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Când s-au adunat deci, Pilat le-a zis: “Pe cine vreți să vă eliberez? Pe Baraba sau pe Isus, care se numește Hristos?” ");
INSERT INTO ronlsb_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Căci știa că din cauza invidiei îl predaseră. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pe când ședea el pe scaunul de judecată, soția lui a trimis la el, zicând: “Nu te mai lega de acest neprihănit, căci astăzi am suferit multe în vis din pricina lui.” ");
INSERT INTO ronlsb_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Iar preoții cei mai de seamă și bătrânii au convins mulțimile să ceară pe Baraba și să nimicească pe Isus. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Dar guvernatorul le-a răspuns: “Pe care dintre cei doi vreți să vi-l eliberez?” Ei au spus: “Baraba!” ");
INSERT INTO ronlsb_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilat le-a zis: “Ce să fac lui Isus, care se numește Hristos?” Și toți i-au zis: “Să fie răstignit!” ");
INSERT INTO ronlsb_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Dar guvernatorul a zis: “De ce? Ce rău a făcut?” Dar ei strigau foarte tare, zicând: “Să fie răstignit!” ");
INSERT INTO ronlsb_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilat, văzând că nu se câștiga nimic, ci că se făcea tulburare, a luat apă și s-a spălat pe mâini în fața mulțimii, zicând: “Eu sunt nevinovat de sângele acestui neprihănit. Aveți grijă de el”. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Și tot poporul a răspuns: “Sângele lui să fie peste noi și peste copiii noștri!” ");
INSERT INTO ronlsb_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Apoi le-a dat drumul lui Baraba, iar pe Isus l-a biciuit și l-a dat spre răstignire. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Atunci soldații guvernatorului au dus pe Isus în pretoriu și au adunat toată garnizoana împotriva Lui. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","L-au dezbrăcat și I-au pus o haină stacojie. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","I-au împletit o cunună de spini și i-au pus-o pe cap, iar în mâna dreaptă o trestie; au îngenuncheat înaintea lui și l-au batjocorit, zicând: “Slavă, Împăratul iudeilor!” ");
INSERT INTO ronlsb_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","L-au scuipat, au luat trestia și l-au lovit în cap. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","După ce l-au batjocorit, i-au luat haina, i-au pus hainele pe el și l-au dus ca să-l răstignească. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Când au ieșit afară, au găsit un om din Cirene, numit Simon, și l-au silit să meargă cu ei, ca să-și ducă crucea. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Când au ajuns la un loc numit “Golgota”, adică “Locul craniului”, ");
INSERT INTO ronlsb_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","i-au dat să bea vin acru amestecat cu fiere. După ce a gustat, nu a vrut să bea. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","După ce l-au răstignit, i-au împărțit hainele, aruncând la sorți, ");
INSERT INTO ronlsb_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","și, stând acolo, îl priveau. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","I-au pus deasupra capului său acuzația scrisă împotriva lui: “ACESTA ESTE IISUS, REGELE IUDEILOR”. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Și erau doi tâlhari răstigniți împreună cu El, unul la dreapta Lui și altul la stânga. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Cei ce treceau pe acolo Îl ocărau, clătinându-și capetele ");
INSERT INTO ronlsb_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","și zicând: “Tu, care distrugi templul și-l zidești în trei zile, mântuiește-te! Dacă ești Fiul lui Dumnezeu, coboară-te de pe cruce!” ");
INSERT INTO ronlsb_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Preoții cei mai de seamă, de asemenea, batjocorind împreună cu cărturarii, cu fariseii și cu bătrânii, au zis: ");
INSERT INTO ronlsb_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“A mântuit pe alții, dar nu se poate mântui pe sine însuși. Dacă el este Regele lui Israel, să se dea jos de pe cruce acum și vom crede în el. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","El se încrede în Dumnezeu. Să-l elibereze Dumnezeu acum, dacă îl vrea, pentru că a spus: “Eu sunt Fiul lui Dumnezeu”.” ");
INSERT INTO ronlsb_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Și tâlharii care au fost răstigniți împreună cu El au aruncat asupra Lui aceeași ocară. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","De la ceasul al șaselea a fost întuneric peste toată țara până la ceasul al nouălea. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Pe la ceasul al nouălea, Isus a strigat cu glas tare: “Eli, Eli, lima sabachthani?” Adică: “Dumnezeul meu, Dumnezeul meu, de ce m-ai părăsit?”. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Unii dintre cei ce stăteau acolo, auzind, au zis: “Omul acesta cheamă pe Ilie.” ");
INSERT INTO ronlsb_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Și îndată unul dintre ei a alergat, a luat un burete, l-a umplut cu oțet, l-a pus pe o trestie și i-a dat să bea. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ceilalți au zis: “Lasă-l în pace. Să vedem dacă vine Ilie să-l salveze”. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Isus a strigat din nou cu glas tare și și-a dat duhul. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Și iată că perdeaua templului s-a rupt în două, de sus până jos. Pământul s-a cutremurat și stâncile s-au despicat. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Mormintele s-au deschis și multe trupuri ale sfinților care adormiseră au înviat; ");
INSERT INTO ronlsb_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","și, ieșind din morminte după înviere, au intrat în cetatea sfântă și s-au arătat multora. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Iar centurionul și cei ce erau cu el, care priveau pe Isus, văzând cutremurul și cele ce se întâmplau, s-au îngrozit și au zis: “Cu adevărat, acesta era Fiul lui Dumnezeu!” ");
INSERT INTO ronlsb_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Și erau acolo multe femei care priveau de departe, și care Îl urmau pe Isus din Galileea și Îl slujeau. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Printre ele erau Maria Magdalena, Maria, mama lui Iacov și a lui Iose și mama fiilor lui Zebedei. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Când s-a făcut seară, a venit un om bogat din Arimateea, numit Iosif, care era și el ucenic al lui Isus. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Acest om s-a dus la Pilat și a cerut trupul lui Isus. Atunci Pilat a poruncit ca trupul să fie predat. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Iosif a luat trupul, l-a înfășurat într-o pânză de in curată ");
INSERT INTO ronlsb_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","și l-a așezat în mormântul său nou, pe care îl tăiase în stâncă. Apoi a rostogolit o piatră mare la ușa mormântului și a plecat. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Magdalena era acolo, împreună cu cealaltă Maria, așezată în fața mormântului. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","A doua zi, adică a doua zi după ziua pregătirii, s-au adunat la Pilat preoții cei mai de seamă și fariseii, și au zis: ");
INSERT INTO ronlsb_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“Domnule, ne aducem aminte ce a spus înșelătorul acela, pe când era încă în viață: “După trei zile voi învia”. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Poruncește, așadar, să se asigure mormântul până a treia zi, ca nu cumva discipolii lui să vină noaptea și să-l fure și să spună poporului: “A înviat din morți”; și ultima înșelăciune va fi mai rea decât prima”.” ");
INSERT INTO ronlsb_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilat le-a zis: “Aveți un paznic. Duceți-vă și asigurați-o cât mai bine”. ");
INSERT INTO ronlsb_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ei s-au dus deci cu garda și au securizat mormântul, sigilând piatra. ");
INSERT INTO ronlsb_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","După Sabat, când a început să se lumineze de ziuă, în prima zi a săptămânii, Maria Magdalena și cealaltă Marie au venit să vadă mormântul. ");
INSERT INTO ronlsb_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Și iată că s-a făcut un cutremur mare, căci un înger al Domnului s-a coborât din cer și a venit și a rostogolit piatra de la ușă și a șezut pe ea. ");
INSERT INTO ronlsb_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Înfățișarea lui era ca un fulger, iar îmbrăcămintea lui era albă ca zăpada. ");
INSERT INTO ronlsb_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","De frica lui, gărzile s-au cutremurat și s-au făcut ca niște oameni morți. ");
INSERT INTO ronlsb_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Îngerul le-a răspuns femeilor: “Nu vă temeți, căci știu că voi căutați pe Isus, care a fost răstignit. ");
INSERT INTO ronlsb_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","El nu este aici, pentru că a înviat, așa cum a spus. Veniți să vedeți locul unde zăcea Domnul. ");
INSERT INTO ronlsb_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Mergeți repede și spuneți-le discipolilor Lui: “A înviat din morți și iată că merge înaintea voastră în Galileea; acolo Îl veți vedea. Iată, v-am spus”. ");
INSERT INTO ronlsb_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Și au ieșit repede din mormânt, cu frică și cu mare bucurie, și au alergat să aducă vestea ucenicilor Lui. ");
INSERT INTO ronlsb_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Pe când se duceau să anunțe pe ucenicii Lui, iată că Isus le-a ieșit în întâmpinare și le-a zis: “Bucurați-vă!” Au venit, s-au prins de picioarele Lui și I s-au închinat. ");
INSERT INTO ronlsb_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Atunci Isus le-a zis: “Nu vă temeți. Duceți-vă și spuneți fraților mei să meargă în Galileea și acolo Mă vor vedea.” ");
INSERT INTO ronlsb_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Pe când se duceau ei, iată că au venit în cetate niște păzitori și au spus preoților cei mai de seamă tot ce se întâmplase. ");
INSERT INTO ronlsb_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","După ce s-au adunat cu bătrânii și s-au sfătuit, au dat soldaților o sumă mare de argint, ");
INSERT INTO ronlsb_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","zicând: “Spuneți că discipolii lui au venit noaptea și l-au furat în timp ce noi dormeam. ");
INSERT INTO ronlsb_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Dacă acest lucru ajunge la urechile guvernatorului, îl vom convinge și vă vom scăpa de griji.” ");
INSERT INTO ronlsb_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ei au luat banii și au făcut cum li s-a spus. Această zicală s-a răspândit printre evrei și continuă până astăzi. ");
INSERT INTO ronlsb_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Dar cei unsprezece ucenici s-au dus în Galileea, pe muntele unde îi trimisese Isus. ");
INSERT INTO ronlsb_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Când L-au văzut, s-au închinat înaintea Lui; dar unii se îndoiau. ");
INSERT INTO ronlsb_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Isus a venit la ei și le-a vorbit, zicând: “Mie Mi s-a dat toată autoritatea în cer și pe pământ. ");
INSERT INTO ronlsb_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Mergeți și faceți discipoli din toate neamurile, botezându-i în numele Tatălui și al Fiului și al Sfântului Duh, ");
INSERT INTO ronlsb_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","învățându-isă păzească toate lucrurile pe care vi le-am poruncit. Iată, Eu sunt cu voi în toate zilele, până la sfârșitul veacului.” Amin. ");
INSERT INTO ronlsb_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Începutul Veștii Bune a lui Iisus Hristos, Fiul lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","După cum este scris în profeți, “Iată, trimit pe mesagerul Meu înaintea feței tale, care îți va pregăti calea înaintea ta: ");
INSERT INTO ronlsb_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","glasul cuiva care strigă în pustiu, 'Pregătiți calea Domnului! Fă-i cărările drepte!” ");
INSERT INTO ronlsb_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ioan a venit să boteze în pustie și să propovăduiască botezul pocăinței pentru iertarea păcatelor. ");
INSERT INTO ronlsb_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Tot ținutul Iudeii și toți cei din Ierusalim au ieșit la el. Au fost botezați de el în râul Iordan, mărturisindu-și păcatele. ");
INSERT INTO ronlsb_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ioan era îmbrăcat cu păr de cămilă și avea o curea de piele la brâu. El mânca lăcuste și miere sălbatică. ");
INSERT INTO ronlsb_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","El propovăduia, spunând: “După mine vine cel care este mai puternic decât mine, a cărui șnur al sandalelor nu sunt vrednic să mă aplec și să îl desfac. ");
INSERT INTO ronlsb_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Eu v-am botezat în apă, dar el vă va boteza în Duhul Sfânt.” ");
INSERT INTO ronlsb_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","În zilele acelea, Isus a venit din Nazaret din Galileea și a fost botezat de Ioan în Iordan. ");
INSERT INTO ronlsb_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Imediat ce a ieșit din apă, a văzut cerurile despărțindu-se și Duhul Sfânt coborând peste el ca un porumbel. ");
INSERT INTO ronlsb_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Un glas a venit din cer: “Tu ești Fiul Meu preaiubit, în care Îmi găsesc plăcerea.” ");
INSERT INTO ronlsb_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Și îndată Duhul Sfânt l-a izgonit în pustiu. ");
INSERT INTO ronlsb_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Acolo, în pustiu, a stat patruzeci de zile, ispitit de Satana. Era cu animalele sălbatice; și îngerii îi slujeau. ");
INSERT INTO ronlsb_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","După ce Ioan a fost luat în temniță, Isus a venit în Galileea, propovăduind vestea cea bună a Împărăției lui Dumnezeu, ");
INSERT INTO ronlsb_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","și zicând: “Timpul s-a împlinit și Împărăția lui Dumnezeu este aproape! Pocăiți-vă și credeți în Vestea cea Bună!”. ");
INSERT INTO ronlsb_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Trecând pe malul mării Galileii, a văzut pe Simon și pe Andrei, fratele lui Simon, care aruncau o plasă în mare, căci erau pescari. ");
INSERT INTO ronlsb_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Isus le-a zis: “Veniți după Mine și vă voi face pescari de oameni”. ");
INSERT INTO ronlsb_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Și îndată și-au lăsat plasele și au mers după El. ");
INSERT INTO ronlsb_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Și, mergând puțin mai departe de acolo, a văzut pe Iacov, fiul lui Zebedei, și pe fratele său Ioan, care erau și ei în corabie și reparau plasele. ");
INSERT INTO ronlsb_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Imediat i-a chemat, iar ei au lăsat pe tatăl lor, Zebedei, în barcă, cu slujitorii angajați, și au mers după el. ");
INSERT INTO ronlsb_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","S-au dus în Capernaum, și îndată, în ziua de Sabat, a intrat în sinagogă și învăța. ");
INSERT INTO ronlsb_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ei erau uimiți de învățătura lui, pentru că îi învăța ca având autoritate, și nu ca pe cărturari. ");
INSERT INTO ronlsb_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Îndată s-a găsit în sinagoga lor un om cu un duh necurat și a strigat, zicând: ");
INSERT INTO ronlsb_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Ha! Ce avem noi de-a face cu tine, Isus, Nazarineanule? Ai venit să ne distrugi? Eu știu cine ești: Sfântul lui Dumnezeu!”. ");
INSERT INTO ronlsb_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Isus l-a mustrat și i-a zis: “Taci și ieși din el!” ");
INSERT INTO ronlsb_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Și duhul necurat a ieșit din el, care-l zguduia și striga cu glas tare. ");
INSERT INTO ronlsb_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Toți erau uimiți, așa că se întrebau între ei și ziceau: “Ce este aceasta? O învățătură nouă? Pentru că el poruncește cu autoritate chiar și duhurilor necurate, iar acestea îl ascultă!” ");
INSERT INTO ronlsb_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Imediat, vestea despre el s-a răspândit pretutindeni în toată regiunea Galileii și în împrejurimile ei. ");
INSERT INTO ronlsb_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Și îndată ce au ieșit din sinagogă, au intrat în casa lui Simon și Andrei, cu Iacov și Ioan. ");
INSERT INTO ronlsb_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Mama soției lui Simon zăcea bolnavă de febră și îndată i-au povestit despre ea. ");
INSERT INTO ronlsb_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","El a venit, a luat-o de mână și a ridicat-o. Febra a lăsat-o imediat și ea le-a slujit. ");
INSERT INTO ronlsb_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Seara, când a apus soarele, au adus la El pe toți cei bolnavi și pe cei posedați de demoni. ");
INSERT INTO ronlsb_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Toată cetatea era adunată la ușă. ");
INSERT INTO ronlsb_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","El a vindecat pe mulți bolnavi de diferite boli și a izgonit mulți demoni. Nu le permitea demonilor să vorbească, pentru că îl cunoșteau. ");
INSERT INTO ronlsb_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Dis-de-dimineață, pe când era încă întuneric, s-a sculat și a ieșit afară, s-a dus într-un loc pustiu și s-a rugat acolo. ");
INSERT INTO ronlsb_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon și cei care erau cu el l-au căutat. ");
INSERT INTO ronlsb_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","L-au găsit și i-au spus: “Toată lumea te caută.” ");
INSERT INTO ronlsb_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Și le-a zis: “Să mergem în altă parte, în cetățile vecine, ca să propovăduiesc și acolo, căci pentru aceasta am ieșit.” ");
INSERT INTO ronlsb_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Și a mers în sinagogile lor în toată Galileea, predicând și scoțând demoni. ");
INSERT INTO ronlsb_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Un leprosar a venit la El și L-a rugat, îngenunchind în fața Lui și spunându-I: “Dacă vrei, poți să mă cureți.” ");
INSERT INTO ronlsb_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Și, cuprins de milă, a întins mâna, l-a atins și i-a zis: “Vreau să... Să fie curățat”. ");
INSERT INTO ronlsb_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","După ce a spus aceasta, îndată lepra s-a depărtat de la el și a fost curățit. ");
INSERT INTO ronlsb_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","El l-a avertizat cu strictețe și l-a trimis imediat afară, ");
INSERT INTO ronlsb_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","și i-a zis: “Vezi să nu spui nimic nimănui, ci du-te să te prezinți preotului și oferă pentru curățirea ta ceea ce a poruncit Moise, ca mărturie pentru ei.” ");
INSERT INTO ronlsb_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Dar el a ieșit și a început să propovăduiască mult și să răspândească vestea, încât Isus nu mai putea intra în cetate, ci era afară, în locuri pustii. Oamenii veneau la el de pretutindeni. ");
INSERT INTO ronlsb_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","După câteva zile, când a intrat din nou în Capernaum, s-a auzit că este acasă. ");
INSERT INTO ronlsb_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Îndată s-au adunat mulți, încât nu mai era loc nici măcar în jurul ușii; și El le-a spus cuvântul. ");
INSERT INTO ronlsb_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Au venit patru oameni care îi duceau un paralitic. ");
INSERT INTO ronlsb_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Cum nu se puteau apropia de el din cauza mulțimii, au îndepărtat acoperișul în care se afla. După ce l-au spart, au dat drumul la covorul pe care era întins paraliticul. ");
INSERT INTO ronlsb_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Isus, văzând credința lor, i-a spus paraliticului: “Fiule, păcatele tale îți sunt iertate.” ");
INSERT INTO ronlsb_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Dar unii din cărturari, care stăteau acolo, gândeau în inimile lor: ");
INSERT INTO ronlsb_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Pentru ce vorbește omul acesta astfel de blasfemii? Cine poate ierta păcatele, dacă nu numai Dumnezeu?” ");
INSERT INTO ronlsb_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Îndată Isus, văzând în duhul Său că ei gândeau astfel în ei înșiși, le-a zis: “Pentru ce gândiți astfel în inimile voastre? ");
INSERT INTO ronlsb_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ce este mai ușor, să-i spui paraliticului: “Păcatele tale sunt iertate”, sau să-i spui: “Scoală-te, ia-ți patul și umblă?” ");
INSERT INTO ronlsb_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Dar ca să știți că Fiul Omului are putere pe pământ să ierte păcatele” — i-a spus paraliticului — ");
INSERT INTO ronlsb_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Îți spun: “Scoală-te, ia-ți patul și du-te la casa ta”. ");
INSERT INTO ronlsb_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","El s-a sculat, a luat îndată rogojina și a ieșit în fața tuturor, așa că toți au rămas uimiți și slăveau pe Dumnezeu, zicând: “Niciodată n-am văzut așa ceva.” ");
INSERT INTO ronlsb_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Și a ieșit din nou la malul mării. Toată mulțimea a venit la el și el îi învăța. ");
INSERT INTO ronlsb_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Pe când trecea pe acolo, a văzut pe Levi, fiul lui Alfeu, care ședea la biroul fiscal. I-a spus: “Vino după mine”. Și el s-a ridicat și l-a urmat. ");
INSERT INTO ronlsb_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","El stătea la masă în casa lui, și mulți vameși și păcătoși s-au așezat la masă cu Isus și cu ucenicii Lui, căci erau mulți, și Îl urmau. ");
INSERT INTO ronlsb_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Cărturarii și fariseii, când au văzut că mănâncă cu păcătoșii și vameșii, au zis ucenicilor Lui: “De ce mănâncă și bea cu vameșii și cu păcătoșii?” ");
INSERT INTO ronlsb_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Când a auzit Isus, le-a zis: “Cei sănătoși nu au nevoie de doctor, ci cei bolnavi. Eu nu am venit să chem pe cei drepți, ci pe păcătoși la pocăință.” ");
INSERT INTO ronlsb_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ucenicii lui Ioan și fariseii posteau și au venit și L-au întrebat: “De ce postesc ucenicii lui Ioan și ucenicii fariseilor, iar ucenicii Tăi nu postesc?” ");
INSERT INTO ronlsb_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Isus le-a zis: “Oare pot posti domnii de onoare, când mirele este cu ei? Atâta timp cât au mirele cu ei, nu pot posti. ");
INSERT INTO ronlsb_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Dar vor veni zile când mirele va fi luat de la ei și atunci vor posti în ziua aceea. ");
INSERT INTO ronlsb_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Nimeni nu coase o bucată de pânză neîncălzită pe o haină veche, căci altfel peticul se micșorează și noul se desprinde de vechi și se face o gaură și mai mare. ");
INSERT INTO ronlsb_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nimeni nu pune vin nou în burdufuri vechi, căci altfel vinul nou sparge burdufurile și vinul se varsă, iar burdufurile se distrug; dar ei pun vin nou în burdufuri proaspete.” ");
INSERT INTO ronlsb_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","În ziua de Sabat, El mergea prin lanurile de grâu; și ucenicii Lui au început, pe când mergeau, să smulgă spice spicele. ");
INSERT INTO ronlsb_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Fariseii I-au zis: “Iată, de ce fac ei ceea ce nu este îngăduit în ziua Sabatului?” ");
INSERT INTO ronlsb_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","El le-a zis: “N-ați citit niciodată ce a făcut David și cei ce erau cu el, când a avut nevoie și a fost flămând? ");
INSERT INTO ronlsb_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","cum a intrat în casa lui Dumnezeu pe vremea marelui preot Abiatar și a mâncat pâinea de spectacol, pe care nu este îngăduit să o mănânce decât preoții, și a dat și celor care erau cu el?” ");
INSERT INTO ronlsb_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","El le-a zis: “Sabatul a fost făcut pentru om, iar nu omul pentru Sabat. ");
INSERT INTO ronlsb_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","De aceea, Fiul Omului este stăpân chiar și pe Sabat.” ");
INSERT INTO ronlsb_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","A intrat iarăși în sinagogă și era acolo un om căruia i se uscase mâna. ");
INSERT INTO ronlsb_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Îl pândeau, ca să vadă dacă îl va vindeca în ziua de Sabat, ca să-l acuze. ");
INSERT INTO ronlsb_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","El i-a zis omului a cărui mână era uscată: “Ridică-te!” ");
INSERT INTO ronlsb_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","El le-a zis: “Este oare îngăduit în ziua Sabatului să faci bine sau să faci rău? Să salvezi o viață sau să ucizi?” Dar ei au rămas tăcuți. ");
INSERT INTO ronlsb_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","După ce s-a uitat cu mânie la ei, mâhnit de împietrirea inimilor lor, i-a zis omului: “Întinde-ți mâna.” El a întins-o și mâna i-a fost redată la fel de sănătoasă ca și cealaltă. ");
INSERT INTO ronlsb_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Fariseii au ieșit afară și îndată au uneltit cu Irodienii împotriva lui, cum să-l nimicească. ");
INSERT INTO ronlsb_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Isus S-a retras cu ucenicii Săi la mare; și o mare mulțime L-a urmat din Galileea, din Iudeea, ");
INSERT INTO ronlsb_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","din Ierusalim, din Idumeea, de dincolo de Iordan, și din împrejurimile Tirului și Sidonului. O mare mulțime, auzind ce lucruri mari făcea, a venit la el. ");
INSERT INTO ronlsb_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","El le-a spus discipolilor săi ca o barcă mică să rămână lângă el, din cauza mulțimii, ca să nu-l îmbrâncească. ");
INSERT INTO ronlsb_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Căci vindecase pe mulți, așa că toți cei care aveau boli se apăsau asupra lui ca să se atingă de el. ");
INSERT INTO ronlsb_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Spiritele necurate, de câte ori îl vedeau, cădeau înaintea lui și strigau: “Tu ești Fiul lui Dumnezeu!” ");
INSERT INTO ronlsb_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","El i-a avertizat cu severitate să nu-l facă cunoscut. ");
INSERT INTO ronlsb_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","El s-a urcat pe munte și a chemat la Sine pe cei pe care-i voia și ei au venit la El. ");
INSERT INTO ronlsb_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","A numit doisprezece, ca să fie cu el și să-i trimită să propovăduiască ");
INSERT INTO ronlsb_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","și să aibă putere să vindece boli și să scoată demoni: ");
INSERT INTO ronlsb_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Simon (căruia i-a dat numele de Petru); ");
INSERT INTO ronlsb_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Iacov, fiul lui Zebedeu, și Ioan, fratele lui Iacov, (pe care i-a numit Boanerges, ceea ce înseamnă: “Fiii tunetului”); ");
INSERT INTO ronlsb_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrei, Filip, Bartolomeu, Matei, Toma, Iacov, fiul lui Alfeu, Tadeu, Simon Zelota, ");
INSERT INTO ronlsb_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","și Iuda Iscarioteanul, care l-a și trădat. Apoi a intrat într-o casă. ");
INSERT INTO ronlsb_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Mulțimea s-a adunat din nou, încât nu mai putea nici măcar să mănânce pâine. ");
INSERT INTO ronlsb_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Când au auzit prietenii lui, au ieșit să-l prindă, căci ziceau: “Este nebun”. ");
INSERT INTO ronlsb_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Cărturarii care se coborau de la Ierusalim spuneau: “Are pe Beelzebul” și: “Prin prințul demonilor scoate afară demonii.” ");
INSERT INTO ronlsb_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Apoi i-a chemat și le-a zis în pilde: “Cum poate Satana să scoată afară pe Satana? ");
INSERT INTO ronlsb_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Dacă o împărăție este împărțită împotriva ei însăși, acea împărăție nu poate rămâne în picioare. ");
INSERT INTO ronlsb_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Dacă o casă este împărțită împotriva ei însăși, casa aceea nu poate sta în picioare. ");
INSERT INTO ronlsb_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Dacă Satana s-a ridicat împotriva lui însuși și este dezbinat, nu poate sta în picioare, ci are un sfârșit. ");
INSERT INTO ronlsb_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Dar nimeni nu poate intra în casa celui puternic ca să jefuiască, dacă nu-l leagă mai întâi pe cel puternic; atunci îi va jefui casa. ");
INSERT INTO ronlsb_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Adevărat vă spun că toate păcatele urmașilor omului vor fi iertate, inclusiv blasfemiile cu care vor huli; ");
INSERT INTO ronlsb_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","dar oricine va huli împotriva Duhului Sfânt nu va avea iertare, ci va fi supus osândei veșnice.” ");
INSERT INTO ronlsb_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","—pentru că au spus: “Are un duh necurat”. ");
INSERT INTO ronlsb_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Mama și frații lui au venit și, stând afară, au trimis la el și l-au chemat. ");
INSERT INTO ronlsb_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","O mulțime stătea în jurul lui și i-au spus: “Iată, mama ta, frații tăi și surorile tale sunt afară și te caută.” ");
INSERT INTO ronlsb_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","El le-a răspuns: “Cine sunt mama Mea și frații Mei?” ");
INSERT INTO ronlsb_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Și, uitându-se la cei care stăteau în jurul lui, a zis: “Iată mama și frații mei! ");
INSERT INTO ronlsb_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Căci oricine face voia lui Dumnezeu este fratele meu, sora mea și mama mea.” ");
INSERT INTO ronlsb_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Și a început din nou să învețe pe malul mării. S-a adunat la El o mare mulțime, așa că a intrat într-o corabie în mare și a șezut jos. Toată mulțimea era pe uscat, lângă mare. ");
INSERT INTO ronlsb_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","El i-a învățat multe lucruri în parabole și le spunea în învățătura sa: ");
INSERT INTO ronlsb_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ascultați! Iată, agricultorul a ieșit să semene. ");
INSERT INTO ronlsb_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","În timp ce semăna, o parte din sămânță a căzut pe drum, iar păsările au venit și au mâncat-o. ");
INSERT INTO ronlsb_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Alte semințe au căzut pe un teren stâncos, unde era puțin pământ, și imediat au răsărit, pentru că nu aveau pământ adânc. ");
INSERT INTO ronlsb_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Când a răsărit soarele, s-a pârjolit; și, pentru că nu avea rădăcină, s-a uscat. ");
INSERT INTO ronlsb_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Alții au căzut între spini, iar spinii au crescut și l-au înăbușit, și nu a dat niciun rod. ");
INSERT INTO ronlsb_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Altele au căzut în pământ bun și au dat rod, crescând și înmulțindu-se. Unii au produs de treizeci de ori, alții de șaizeci de ori, iar alții de o sută de ori mai mult.” ");
INSERT INTO ronlsb_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","El a spus: “Cine are urechi de auzit, să audă.” ");
INSERT INTO ronlsb_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Când a rămas singur, cei ce erau în jurul lui cu cei doisprezece l-au întrebat despre pilde. ");
INSERT INTO ronlsb_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","El le-a spus: “Vouă v-a fost dat misterul Împărăției lui Dumnezeu, dar pentru cei de afară, toate lucrurile se fac în parabole, ");
INSERT INTO ronlsb_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","pentru ca “văzând să vadă și să nu priceapă, și auzind să audă și să nu înțeleagă, ca nu cumva să se întoarcă și să li se ierte păcatele”.” ");
INSERT INTO ronlsb_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","El le-a zis: “Nu înțelegeți pilda aceasta? Cum veți înțelege toate parabolele? ");
INSERT INTO ronlsb_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Fermierul seamănă cuvântul. ");
INSERT INTO ronlsb_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Cei de pe drum sunt cei în care este semănat cuvântul; și când au auzit, îndată vine Satana și ia cuvântul care a fost semănat în ei. ");
INSERT INTO ronlsb_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Aceștia, la fel, sunt cei semănați pe locurile stâncoase, care, când au auzit cuvântul, îndată îl primesc cu bucurie. ");
INSERT INTO ronlsb_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ei nu au rădăcină în ei înșiși, ci sunt de scurtă durată. Când apare opresiunea sau persecuția din cauza cuvântului, imediat se poticnesc. ");
INSERT INTO ronlsb_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Alții sunt cei care sunt semănați printre spini. Aceștia sunt cei care au ascultat cuvântul, ");
INSERT INTO ronlsb_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","dar grijile acestui veac, înșelăciunea bogățiilor și poftele altor lucruri care intră în el înăbușă cuvântul și acesta devine neînsuflețit. ");
INSERT INTO ronlsb_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Cei care au fost semănați pe pământ bun sunt cei care aud cuvântul, îl acceptă și fac rod, unii de treizeci de ori, alții de șaizeci de ori și alții de o sută de ori.” ");
INSERT INTO ronlsb_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","El le-a zis: “Oare se aduce o lampă pentru a fi pusă sub coș sau sub pat? Nu este pusă pe un suport? ");
INSERT INTO ronlsb_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Căci nimic nu este ascuns, decât ca să fie făcut cunoscut, și nimic nu a fost făcut secret, decât ca să iasă la lumină. ");
INSERT INTO ronlsb_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Dacă are cineva urechi de auzit, să audă.” ");
INSERT INTO ronlsb_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Și le-a zis: “Luați aminte la ce auziți. Cu orice măsură veți măsura, vi se va măsura și vouă; și vouă, celor ce ascultați, vi se va da mai mult. ");
INSERT INTO ronlsb_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Căci oricui are, i se va da mai mult; iar celui care nu are, chiar și ceea ce are i se va lua.” ");
INSERT INTO ronlsb_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","El a zis: “Împărăția lui Dumnezeu este ca și cum un om ar arunca sămânță pe pământ, ");
INSERT INTO ronlsb_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","și ar dormi și s-ar scula zi și noapte, iar sămânța ar răsări și ar crește, fără să știe cum. ");
INSERT INTO ronlsb_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Pentru că pământul dă roade de la sine: mai întâi firul, apoi spicul, apoi bobul plin în spice. ");
INSERT INTO ronlsb_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Dar când rodul este copt, îndată se pune secera, pentru că a venit secerișul.” ");
INSERT INTO ronlsb_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","El a zis: “Cum vom asemăna noi Împărăția lui Dumnezeu? Sau cu ce parabolă o vom ilustra? ");
INSERT INTO ronlsb_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Este ca un grăunte de muștar, care, deși este mai mic decât toate semințele care sunt pe pământ, ");
INSERT INTO ronlsb_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","totuși, după ce este semănat, crește și devine mai mare decât toate ierburile și scoate ramuri mari, încât păsările cerului pot să se adăpostească la umbra lui.” ");
INSERT INTO ronlsb_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Cu multe pilde ca acestea le spunea cuvântul, după cum puteau ei să-l audă. ");
INSERT INTO ronlsb_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Fără o pildă nu le vorbea; dar în particular, discipolilor Săi le explica totul. ");
INSERT INTO ronlsb_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","În ziua aceea, când s-a făcut seară, le-a zis: “Să trecem dincolo.” ");
INSERT INTO ronlsb_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Lăsând mulțimea, l-au luat cu ei, așa cum era, în barcă. Și alte bărci mici erau cu el. ");
INSERT INTO ronlsb_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","S-a iscat o furtună mare de vânt și valurile băteau în barcă, atât de mult încât barca era deja plină. ");
INSERT INTO ronlsb_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","El însuși era în pupa, dormind pe pernă; l-au trezit și l-au întrebat: “Învățătorule, nu-ți pasă că suntem pe moarte?” ");
INSERT INTO ronlsb_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","El s-a trezit, a mustrat vântul și a zis mării: “Pace! Liniștește-te!” Vântul a încetat și a fost o mare acalmie. ");
INSERT INTO ronlsb_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","El le-a zis: “De ce vă este atât de frică? Cum se face că nu aveți credință?”. ");
INSERT INTO ronlsb_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ei s-au înspăimântat foarte tare și ziceau unul către altul: “Cine este Acesta, încât și vântul și marea Îl ascultă?” ");
INSERT INTO ronlsb_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Și au ajuns de cealaltă parte a mării, în ținutul Gadarenilor. ");
INSERT INTO ronlsb_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","După ce a ieșit din corabie, îndată i-a ieșit în întâmpinare un om cu un duh necurat din morminte. ");
INSERT INTO ronlsb_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","El locuia în morminte. Nimeni nu-l mai putea lega, nici măcar cu lanțuri, ");
INSERT INTO ronlsb_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","pentru că fusese de multe ori legat cu lanțuri și lanțuri, iar lanțurile fuseseră rupte de el și lanțurile rupte în bucăți. Nimeni nu mai avea puterea să-l îmblânzească. ");
INSERT INTO ronlsb_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Întotdeauna, zi și noapte, în morminte și în munți, striga și se tăia cu pietre. ");
INSERT INTO ronlsb_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Când l-a văzut de departe pe Isus, a alergat și s-a plecat în fața lui, ");
INSERT INTO ronlsb_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","și, strigând cu glas tare, a zis: “Ce am eu de-a face cu tine, Isus, Fiul Dumnezeului Celui Preaînalt? Te conjur pe Dumnezeu, nu mă chinui!”. ");
INSERT INTO ronlsb_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Căci El i-a zis: “Ieși din om, duh necurat!” ");
INSERT INTO ronlsb_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Și l-a întrebat: “Cum te cheamă?” El i-a spus: “Numele meu este Legiune, pentru că suntem mulți.” ");
INSERT INTO ronlsb_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Și l-a rugat mult ca să nu-i trimită afară din țară. ");
INSERT INTO ronlsb_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Or, pe coasta muntelui era o turmă mare de porci care se hrănea. ");
INSERT INTO ronlsb_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Toți demonii îl implorau, zicând: “Trimite-ne la porci, ca să intrăm în ei”. ");
INSERT INTO ronlsb_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Atunci Isus le-a dat voie. Duhurile necurate au ieșit și au intrat în porci. Turma de aproximativ două mii de porci s-a repezit pe malul abrupt în mare și au fost înecați în mare. ");
INSERT INTO ronlsb_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Cei care hrăneau porcii au fugit și au povestit în oraș și în țară. Oamenii au venit să vadă ce s-a întâmplat. ");
INSERT INTO ronlsb_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Au venit la Isus și au văzut pe cel care fusese posedat de demoni stând jos, îmbrăcat și în deplinătatea facultăților mintale, pe cel care avea legionul; și s-au temut. ");
INSERT INTO ronlsb_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Cei care l-au văzut le-au povestit ce s-a întâmplat cu cel care era posedat de demoni și despre porci. ");
INSERT INTO ronlsb_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ei au început să-l roage să plece din regiunea lor. ");
INSERT INTO ronlsb_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Pe când se urca în corabie, cel ce fusese posedat de demoni l-a rugat să fie cu el. ");
INSERT INTO ronlsb_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","El nu i-a îngăduit, ci i-a zis: “Du-te la casa ta, la prietenii tăi, și spune-le ce lucruri mari a făcut Domnul pentru tine și cum a avut milă de tine.” ");
INSERT INTO ronlsb_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","El a plecat și a început să vestească în Decapole cum a făcut Isus lucruri mari pentru el, și toată lumea se mira. ");
INSERT INTO ronlsb_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","După ce a trecut Isus cu corabia pe partea cealaltă, s-a adunat la El o mare mulțime de oameni, și El era pe malul mării. ");
INSERT INTO ronlsb_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Iată că a venit unul dintre conducătorii sinagogii, pe nume Iair; și, văzându-L, a căzut la picioarele Lui ");
INSERT INTO ronlsb_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","și L-a rugat mult, zicând: “Fetița mea este în pragul morții. Te rog, vino și pune-ți mâinile peste ea, ca să se facă sănătoasă și să trăiască”. ");
INSERT INTO ronlsb_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","El a mers cu El și o mare mulțime de oameni Îl urmau și Îl strângeau din toate părțile. ");
INSERT INTO ronlsb_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","O femeie care avea o scurgere de sânge de doisprezece ani, ");
INSERT INTO ronlsb_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","și care suferise multe de la mulți doctori, cheltuise tot ce avea și nu se simțea mai bine, ci mai mult se înrăutățea, ");
INSERT INTO ronlsb_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","și care, după ce a auzit cele despre Isus, s-a apropiat de El în mulțime și s-a atins de hainele Lui. ");
INSERT INTO ronlsb_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Căci ea zicea: “Dacă mă voi atinge de hainele Lui, mă voi face bine.” ");
INSERT INTO ronlsb_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Imediat, curgerea sângelui ei a secat și ea a simțit în trupul ei că este vindecată de suferința ei. ");
INSERT INTO ronlsb_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Îndată Isus, văzând că puterea a ieșit din El, s-a întors în mulțime și a întrebat: “Cine s-a atins de hainele Mele?” ");
INSERT INTO ronlsb_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ucenicii Lui I-au zis: “Vezi mulțimea care Te strânge și zici: “Cine S-a atins de Mine?”” ");
INSERT INTO ronlsb_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","S-a uitat în jur ca să o vadă pe cea care făcuse acest lucru. ");
INSERT INTO ronlsb_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Dar femeia, temându-se și tremurând, știind ce i se făcuse, a venit, a căzut înaintea lui și i-a spus tot adevărul. ");
INSERT INTO ronlsb_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","El i-a zis: “Fiică, credința ta te-a făcut sănătoasă. Du-te în pace și vindecă-te de boala ta.” ");
INSERT INTO ronlsb_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Pe când vorbea El încă, au venit niște oameni de la casa conducătorului sinagogii și au zis: “Fiica ta a murit. De ce să-l mai deranjezi pe Învățător?” ");
INSERT INTO ronlsb_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Dar Isus, când a auzit mesajul rostit, a zis îndată conducătorului sinagogii: “Nu te teme, ci crede!” ");
INSERT INTO ronlsb_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Și nu a lăsat pe nimeni să-L urmeze, decât pe Petru, Iacov și Ioan, fratele lui Iacov. ");
INSERT INTO ronlsb_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","A ajuns la casa conducătorului sinagogii și a văzut zarvă, plânsete și jale mare. ");
INSERT INTO ronlsb_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","După ce a intrat înăuntru, le-a zis: “De ce faceți zarvă și plângeți? Copilul nu este mort, ci a adormit”. ");
INSERT INTO ronlsb_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","L-au batjocorit. Dar el, după ce i-a scos pe toți afară, a luat pe tatăl copilei, pe mama ei și pe cei care erau cu el și a intrat în locul unde zăcea copila. ");
INSERT INTO ronlsb_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Luând copila de mână, i-a zis: “Talitha cumi!”, ceea ce înseamnă, interpretându-se: “Fetiță, îți spun, ridică-te!”. ");
INSERT INTO ronlsb_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Imediat fata s-a ridicat și a mers, căci avea doisprezece ani. Ei au rămas uimiți cu mare uimire. ");
INSERT INTO ronlsb_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","El le-a poruncit cu strictețe ca nimeni să nu știe acest lucru și a poruncit să i se dea ceva de mâncare. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Și a ieșit de acolo. A venit în țara lui și discipolii lui L-au urmat. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Când a venit Sabatul, a început să învețe în sinagogă și mulți care îl auzeau erau uimiți și ziceau: “De unde are omul acesta aceste lucruri?” și: “Ce înțelepciune i-a fost dată acestui om, de se fac prin mâinile lui asemenea lucruri mărețe? ");
INSERT INTO ronlsb_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Nu cumva acesta este tâmplarul, fiul Mariei și fratele lui Iacov, al lui Iose, al lui Iuda și al lui Simon? Nu cumva surorile lui sunt aici cu noi?” Așa că s-au supărat pe el. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Isus le-a zis: “Un prooroc nu este lipsit de cinste decât în țara lui, între rudele lui și în casa lui.” ");
INSERT INTO ronlsb_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Acolo nu a putut face nicio lucrare măreață, decât că și-a pus mâinile peste câțiva bolnavi și i-a vindecat. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","El se mira din cauza necredinței lor. A mers prin sate și a învățat. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","A chemat la Sine pe cei doisprezece și a început să-i trimită doi câte doi; și le-a dat putere asupra duhurilor necurate. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Le-a poruncit să nu-și ia nimic pentru călătorie, în afară de un toiag, doar un toiag: nici pâine, nici portofel, nici bani în pungă, ");
INSERT INTO ronlsb_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ci să poarte sandale și să nu-și pună două tunici. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","El le-a spus: “Oriunde intrați într-o casă, rămâneți acolo până când veți pleca de acolo. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Oricine nu vă va primi și nu vă va asculta, când plecați de acolo, scuturați praful de sub picioarele voastre ca mărturie împotriva lor. Cu siguranță, vă spun că, în ziua judecății, va fi mai ușor de suportat pentru Sodoma și Gomora decât pentru acest oraș!” ");
INSERT INTO ronlsb_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ei au ieșit și propovăduiau oamenilor să se pocăiască. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Au scos mulți demoni, au uns cu untdelemn pe mulți bolnavi și i-au vindecat. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Regele Irod a auzit aceasta, căci numele lui devenise cunoscut, și a zis: “Ioan Botezătorul a înviat din morți și de aceea aceste puteri lucrează în el.” ");
INSERT INTO ronlsb_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Alții însă spuneau: “El este Ilie”. Alții au spus: “Este un profet sau ca unul dintre profeți”. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Dar Irod, când a auzit acestea, a zis: “Acesta este Ioan, pe care l-am decapitat. A înviat din morți”. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Căci însuși Irod trimisese să-l aresteze pe Ioan și-l legase în închisoare din cauza Irodiadei, soția fratelui său Filip, pentru că se căsătorise cu ea. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Căci Ioan îi spusese lui Irod: “Nu-ți este îngăduit să ai pe soția fratelui tău”. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Irodiada s-a pus împotriva lui și a vrut să-l ucidă, dar nu a putut, ");
INSERT INTO ronlsb_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","pentru că Irod se temea de Ioan, știind că este un om drept și sfânt, și l-a păstrat în siguranță. Când îl auzea, făcea multe lucruri și îl asculta cu plăcere. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Atunci a venit o zi potrivită, când Irod, de ziua lui de naștere, a dat o cină pentru nobilii săi, pentru arhierei și pentru căpeteniile Galileii. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Când însăși fiica Irodiadei a intrat și a dansat, a plăcut lui Irod și celor care stăteau cu el. Regele i-a spus tinerei: “Cere-mi tot ce vrei și îți voi da”. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","El i-a jurat: “Orice îmi vei cere, îți voi da, până la jumătate din regatul meu.” ");
INSERT INTO ronlsb_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ea a ieșit și a zis mamei sale: “Ce să cer?” Ea a spus: “Capul lui Ioan Botezătorul”. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ea a venit îndată la rege și i-a zis: “Vreau să-mi dai acum capul lui Ioan Botezătorul pe un platou.” ");
INSERT INTO ronlsb_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Împăratul a fost foarte mâhnit, dar, de dragul jurămintelor sale și al invitaților la masă, n-a vrut să o refuze. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Imediat, regele a trimis un soldat din garda sa și a poruncit să aducă capul lui Ioan; acesta s-a dus și l-a decapitat în închisoare, ");
INSERT INTO ronlsb_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","i-a adus capul pe un platou și l-a dat tinerei domnișoare, iar tânăra domnișoară l-a dat mamei sale. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ucenicii Lui, auzind aceasta, au venit, au luat trupul Lui și l-au pus într-un mormânt. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Apostolii s-au adunat la Isus și I-au povestit tot ce făcuseră și tot ce învățaseră. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","El le-a zis: “Veniți într-un loc pustiu și odihniți-vă puțin.” Căci erau mulți care veneau și plecau, și nu aveau timp liber nici măcar să mănânce. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ei s-au dus cu barca într-un loc pustiu, singuri. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Văzându-i mergând, mulți l-au recunoscut și au alergat acolo pe jos din toate cetățile. Au ajuns înaintea lor și au venit împreună la el. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Isus a ieșit, a văzut o mulțime mare și i s-a făcut milă de ei, pentru că erau ca niște oi fără păstor; și a început să-i învețe multe lucruri. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Când s-a făcut târziu, discipolii Lui au venit la El și i-au spus: “Locul acesta este pustiu și este târziu. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Trimiteți-i afară, ca să meargă în ținutul și în satele din jur și să-și cumpere pâine, căci nu au ce mânca.” ");
INSERT INTO ronlsb_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Dar El le-a răspuns: “Dați-le voi ceva de mâncare.” L-au întrebat: “Să mergem să cumpărăm pâine în valoare de două sute de denari și să le dăm ceva de mâncare?”. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","El le-a zis: “Câte pâini aveți? Mergeți să vedeți.” Când au aflat, au spus: “Cinci și doi pești”. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Și le-a poruncit să se așeze toți în grupuri pe iarba verde. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Și s-au așezat în rânduri, cu sutele și cu cincizeci. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","A luat cele cinci pâini și cei doi pești; și, privind spre cer, a binecuvântat și a frânt pâinile, pe care le-a dat ucenicilor Săi ca să le pună înaintea lor, iar cei doi pești i-a împărțit la toți. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Toți au mâncat și s-au săturat. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Au luat douăsprezece coșuri pline cu bucățile frânte și cu peștii. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Cei care au mâncat pâinile au fost cinci mii de oameni. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Și îndată a pus pe ucenicii Săi să se urce în corabie și să meargă mai departe, în cealaltă parte, la Betsaida, în timp ce El însuși a trimis mulțimea. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","După ce și-a luat rămas bun de la ei, s-a urcat pe munte ca să se roage. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Când s-a făcut seară, corabia era în mijlocul mării, iar el era singur pe uscat. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Văzându-i chinuiți la vâslit, pentru că vântul le era potrivnic, pe la a patra strajă a nopții, a venit la ei, mergând pe mare; și ar fi vrut să treacă pe lângă ei, ");
INSERT INTO ronlsb_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","dar ei, când l-au văzut mergând pe mare, au crezut că este o fantomă și au strigat; ");
INSERT INTO ronlsb_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","pentru că toți l-au văzut și s-au tulburat. Dar el a vorbit imediat cu ei și le-a spus: “Înveseliți-vă! Eu sunt! Nu vă temeți!”. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","S-a urcat cu ei în barcă, iar vântul a încetat, iar ei erau foarte mirați între ei și se minunau; ");
INSERT INTO ronlsb_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","pentru că nu înțeleseseră ce se întâmplase cu pâinile, dar aveau inima împietrită. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","După ce au trecut dincolo, au ajuns la țărm, la Genesaret, și au acostat la țărm. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","După ce au ieșit din barcă, oamenii l-au recunoscut imediat, ");
INSERT INTO ronlsb_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","și au alergat în toată regiunea aceea și au început să-i aducă pe cei bolnavi pe saltelele lor acolo unde auziseră că se află. ");
INSERT INTO ronlsb_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Oriunde intra — în sate, în orașe sau la țară —, ei îi așezau pe bolnavi în piețe și îl rugau să atingă doar franjurii hainei lui; și toți cei care se atingeau de el se făceau bine. ");
INSERT INTO ronlsb_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Atunci s-au adunat la El fariseii și unii din cărturari, veniți de la Ierusalim. ");
INSERT INTO ronlsb_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Când au văzut pe unii dintre ucenicii Săi mâncând pâine cu mâinile spurcate, adică nespălate, au găsit o vină. ");
INSERT INTO ronlsb_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Căci fariseii și toți iudeii nu mănâncă dacă nu-și spală mâinile și antebrațele, ținându-se de tradiția bătrânilor. ");
INSERT INTO ronlsb_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ei nu mănâncă atunci când vin de la piață dacă nu se spală, și mai sunt multe alte lucruri pe care au primit să le țină: spălările paharelor, ale ulcioarelor, ale vaselor de bronz și ale canapelelor). ");
INSERT INTO ronlsb_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Fariseii și cărturarii l-au întrebat: “De ce nu umblă discipolii tăi după tradiția bătrânilor, ci mănâncă pâinea lor cu mâinile nespălate?” ");
INSERT INTO ronlsb_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","El le-a răspuns: “Bine a proorocit Isaia despre voi, fățarnicilor, cum este scris, 'Acest popor mă cinstește cu buzele lui, dar inima lor este departe de mine. ");
INSERT INTO ronlsb_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","În zadar se închină ei la Mine, învățând ca doctrine poruncile oamenilor. ");
INSERT INTO ronlsb_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Căci voi lăsați deoparte porunca lui Dumnezeu și vă țineți de tradiția oamenilor, spălând ulcioarele și paharele, și faceți multe alte lucruri de acest fel.” ");
INSERT INTO ronlsb_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","El le-a zis: “Foarte bine că respingeți porunca lui Dumnezeu, ca să vă păstrați tradiția voastră. ");
INSERT INTO ronlsb_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Căci Moise a zis: “Cinstește pe tatăl tău și pe mama ta”; și: “Cine vorbește de rău pe tatăl sau pe mama, să fie omorât”. ");
INSERT INTO ronlsb_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Dar voi ziceți: “Dacă un om spune tatălui său sau mamei sale: “Orice folos pe care l-ai fi putut primi de la mine este Corban””, adică dat lui Dumnezeu, ");
INSERT INTO ronlsb_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","“atunci nu-i mai permiteți să facă nimic pentru tatăl său sau pentru mama sa, ");
INSERT INTO ronlsb_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","anulând cuvântul lui Dumnezeu prin tradiția voastră pe care ați transmis-o”. Voi faceți multe lucruri de acest fel”. ");
INSERT INTO ronlsb_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","A chemat toată mulțimea la Sine și le-a zis: “Ascultați-mă cu toții și înțelegeți. ");
INSERT INTO ronlsb_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nu este nimic din afara omului care, intrând în el, să îl spurce; dar lucrurile care ies din om sunt cele care îl spurcă pe om. ");
INSERT INTO ronlsb_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Dacă are cineva urechi de auzit, să audă!” ");
INSERT INTO ronlsb_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","După ce a intrat într-o casă, departe de mulțime, ucenicii Lui L-au întrebat despre pilda aceea. ");
INSERT INTO ronlsb_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","El le-a zis: “Sunteți și voi fără pricepere? Nu vă dați seama că tot ceea ce intră în om din afară nu-l poate spurca, ");
INSERT INTO ronlsb_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","pentru că nu intră în inima lui, ci în stomac, apoi în latrină, ceea ce face ca toate alimentele să fie curate?” ");
INSERT INTO ronlsb_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","El a răspuns: “Ceea ce iese din om, aceea spurcă omul. ");
INSERT INTO ronlsb_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Căci dinăuntru, din inima omului, ies gândurile rele, adulterele, păcatele sexuale, crimele, furturile, ");
INSERT INTO ronlsb_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","poftele, răutatea, înșelăciunea, poftele, ochiul rău, blasfemia, mândria și nebunia. ");
INSERT INTO ronlsb_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Toate aceste lucruri rele vin dinăuntru și îl spurcă pe om.” ");
INSERT INTO ronlsb_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","De acolo s-a sculat și a plecat în ținutul Tirului și al Sidonului. A intrat într-o casă și n-a vrut să știe nimeni, dar n-a putut scăpa de observație. ");
INSERT INTO ronlsb_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Căci o femeie a cărei fetiță avea un duh necurat, auzind de el, a venit și s-a aruncat la picioarele lui. ");
INSERT INTO ronlsb_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Femeia era o greacă, siro-feniciană de rasă. Ea l-a implorat să alunge demonul din fiica ei. ");
INSERT INTO ronlsb_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Dar Isus i-a zis: “Lasă să se sature mai întâi copiii, căci nu se cuvine să iei pâinea copiilor și să o arunci la câini.” ");
INSERT INTO ronlsb_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Dar ea i-a răspuns: “Da, Doamne. Totuși, chiar și câinii de sub masă mănâncă firimiturile copiilor.” ");
INSERT INTO ronlsb_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","El i-a zis: “Pentru această vorbă, du-te. Demonul a ieșit din fiica ta.” ");
INSERT INTO ronlsb_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ea s-a dus la casa ei și a găsit copilul culcat pe pat, iar demonul ieșise. ");
INSERT INTO ronlsb_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","A plecat din nou de la hotarele Tirului și ale Sidonului și a ajuns la marea Galileii, trecând prin mijlocul ținutului Decapolei. ");
INSERT INTO ronlsb_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","I-au adus pe unul care era surd și avea o împiedicare în vorbire. L-au rugat să pună mâna pe el. ");
INSERT INTO ronlsb_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","L-a luat la o parte de la mulțime, în particular, și i-a băgat degetele în urechi; apoi a scuipat și i-a atins limba. ");
INSERT INTO ronlsb_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Privind spre cer, a suspinat și i-a zis: “Ephatha!”, adică: “Deschide-te!”. ");
INSERT INTO ronlsb_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Imediat i s-au deschis urechile, i s-a eliberat impedimentul limbii și a vorbit limpede. ");
INSERT INTO ronlsb_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","El le-a poruncit să nu spună nimănui, dar cu cât le poruncea mai mult, cu atât mai mult o vesteau. ");
INSERT INTO ronlsb_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ei au fost uimiți peste măsură, spunând: “A făcut toate lucrurile bine. El îi face chiar și pe surzi să audă și pe cei muți să vorbească!” ");
INSERT INTO ronlsb_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","În zilele acelea, pe când era o mulțime foarte mare și nu aveau ce mânca, Isus a chemat la Sine pe ucenicii Săi și le-a zis: ");
INSERT INTO ronlsb_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Mi-e milă de mulțime, pentru că de trei zile stau la Mine și nu au ce mânca. ");
INSERT INTO ronlsb_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Dacă îi voi trimite cu post la casele lor, vor leșina pe drum, pentru că unii dintre ei au venit de departe.” ");
INSERT INTO ronlsb_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ucenicii Lui I-au răspuns: “De unde ar putea cineva să sature pe acești oameni cu pâine aici, într-un loc pustiu?” ");
INSERT INTO ronlsb_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Și i-a întrebat: “Câte pâini aveți?” Ei au spus: “Șapte”. ");
INSERT INTO ronlsb_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","A poruncit mulțimii să șadă pe pământ și a luat cele șapte pâini. După ce a mulțumit, le-a frânt și le-a dat ucenicilor Săi să le servească, iar ei au servit mulțimii. ");
INSERT INTO ronlsb_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Au luat și câțiva peștișori. După ce i-a binecuvântat, a spus să servească și pe aceștia. ");
INSERT INTO ronlsb_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ei au mâncat și s-au săturat. Au luat șapte coșuri cu bucățile sparte care rămăseseră. ");
INSERT INTO ronlsb_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Cei care mâncaseră erau în jur de patru mii. Apoi i-a trimis departe. ");
INSERT INTO ronlsb_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Și îndată a intrat în corabie cu ucenicii Săi și a ajuns în ținutul Dalmanutha. ");
INSERT INTO ronlsb_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Fariseii au ieșit și au început să-L întrebe, căutând de la El un semn din cer și punându-L la încercare. ");
INSERT INTO ronlsb_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","El a suspinat adânc în duhul său și a zis: “De ce caută neamul acesta un semn? Cu siguranță vă spun că nu se va da niciun semn acestei generații”. ");
INSERT INTO ronlsb_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","I-a lăsat și, intrând din nou în corabie, a plecat în cealaltă parte. ");
INSERT INTO ronlsb_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Au uitat să ia pâine; și nu aveau cu ei în barcă mai mult de o pâine. ");
INSERT INTO ronlsb_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","El i-a avertizat, zicând: “Luați seama: păziți-vă de drojdia fariseilor și de drojdia lui Irod.” ");
INSERT INTO ronlsb_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ei se certau între ei, zicând: “Pentru că nu avem pâine.” ");
INSERT INTO ronlsb_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Isus, văzând aceasta, le-a zis: “De ce credeți că este din pricină că nu aveți pâine? Nu vă dați seama încă și nu înțelegeți? Inima voastră este încă împietrită? ");
INSERT INTO ronlsb_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Având ochi, nu vedeți? Având urechi, nu auziți? Nu vă amintiți? ");
INSERT INTO ronlsb_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Când am împărțit cele cinci pâini la cele cinci mii de oameni, câte coșuri pline de bucăți ați luat?” I-au spus: “Douăsprezece”. ");
INSERT INTO ronlsb_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Când cele șapte pâini au hrănit cele patru mii de oameni, câte coșuri pline cu frânturi ați luat?” I-au spus: “Șapte”. ");
INSERT INTO ronlsb_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Și i-a întrebat: “Nu înțelegeți încă?” ");
INSERT INTO ronlsb_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Și a venit la Betsaida. I-au adus un orb și l-au rugat să se atingă de el. ");
INSERT INTO ronlsb_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","El a apucat pe orb de mână și l-a scos din sat. După ce l-a scuipat pe ochi și și-a pus mâinile pe el, l-a întrebat dacă a văzut ceva. ");
INSERT INTO ronlsb_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Și s-a uitat în sus și a zis: “Văd oameni, dar îi văd ca pe niște copaci care umblă.” ");
INSERT INTO ronlsb_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Apoi și-a pus iarăși mâinile pe ochi. El s-a uitat cu atenție și, după ce s-a refăcut, a văzut clar pe toată lumea. ");
INSERT INTO ronlsb_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","L-a trimis la casa lui, spunându-i: “Să nu intri în sat și să nu spui nimănui din sat.” ");
INSERT INTO ronlsb_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Isus a ieșit cu ucenicii Săi în satele din Cezareea lui Filipi. Pe drum i-a întrebat pe discipolii Săi: “Cine spun oamenii că sunt Eu?”. ");
INSERT INTO ronlsb_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ei i-au spus: “Ioan Botezătorul; alții zic Ilie, iar alții zic Ilie, iar alții, unul din profeți.” ");
INSERT INTO ronlsb_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","El le-a zis: “Dar voi cine ziceți că sunt Eu?” Petru i-a răspuns: “Tu ești Hristosul.” ");
INSERT INTO ronlsb_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Și le-a poruncit să nu spună nimănui despre El. ");
INSERT INTO ronlsb_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","A început să-i învețe că Fiul Omului trebuie să sufere multe, să fie lepădat de bătrâni, de preoții cei mai de seamă și de cărturari, să fie omorât și să învie după trei zile. ");
INSERT INTO ronlsb_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","El le vorbea deschis. Petru l-a luat și a început să îl dojenească. ");
INSERT INTO ronlsb_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Dar el, întorcându-se și văzându-i pe ucenicii săi, l-a mustrat pe Petru și i-a zis: “Treci în spatele meu, Satana! Căci tu nu te gândești la lucrurile lui Dumnezeu, ci la lucrurile oamenilor”. ");
INSERT INTO ronlsb_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","A chemat mulțimea la Sine împreună cu ucenicii Săi și le-a zis: “Cine vrea să vină după Mine, să se lepede de sine, să-și ia crucea și să-Mi urmeze Mie. ");
INSERT INTO ronlsb_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Căci oricine vrea să-și salveze viața o va pierde, iar oricine își va pierde viața pentru Mine și pentru Buna Vestire o va salva. ");
INSERT INTO ronlsb_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Căci ce-i folosește unui om să câștige toată lumea și să-și piardă viața? ");
INSERT INTO ronlsb_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Căci ce va da omul în schimbul vieții sale? ");
INSERT INTO ronlsb_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Căci oricine se va rușina de mine și de cuvintele mele în acest neam adulterin și păcătos, și Fiul Omului se va rușina de el când va veni în slava Tatălui său cu sfinții îngeri.” ");
INSERT INTO ronlsb_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","El le-a zis: “Adevărat vă spun că sunt unii care stau aici și care nu vor gusta moartea până nu vor vedea venind cu putere Împărăția lui Dumnezeu.” ");
INSERT INTO ronlsb_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","După șase zile, Isus a luat cu El pe Petru, Iacov și Ioan și i-a dus singuri pe un munte înalt, în particular, și S-a schimbat în fața lor. ");
INSERT INTO ronlsb_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Hainele Lui au devenit strălucitoare, extrem de albe, ca zăpada, așa cum nici un spălător de pe pământ nu le poate albi. ");
INSERT INTO ronlsb_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Le-au apărut Ilie și Moise, care stăteau de vorbă cu Isus. ");
INSERT INTO ronlsb_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petru a răspuns lui Isus: “Rabi, este bine să fim aici. Să facem trei corturi: unul pentru tine, unul pentru Moise și unul pentru Ilie.” ");
INSERT INTO ronlsb_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Căci nu știa ce să spună, pentru că erau foarte speriați. ");
INSERT INTO ronlsb_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Un nor a venit și i-a acoperit cu umbră, iar din nor a ieșit un glas: “Acesta este Fiul Meu preaiubit. Ascultați-l.” ");
INSERT INTO ronlsb_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Și, uitându-se deodată în jur, n-au mai văzut pe nimeni cu ei, decât numai pe Isus. ");
INSERT INTO ronlsb_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Pe când se coborau de pe munte, le-a poruncit să nu spună nimănui cele ce văzuseră, până ce Fiul Omului nu va învia din morți. ");
INSERT INTO ronlsb_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ei au păstrat pentru ei înșiși acest cuvânt, întrebându-se ce înseamnă “învierea din morți”. ");
INSERT INTO ronlsb_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Și L-au întrebat: “Pentru ce zic cărturarii că Ilie trebuie să vină mai întâi?” ");
INSERT INTO ronlsb_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","El le-a zis: “Ilie vine mai întâi și restaurează toate lucrurile. Cum este scris despre Fiul Omului că trebuie să sufere multe și să fie disprețuit? ");
INSERT INTO ronlsb_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Dar Eu vă spun că Ilie a venit și i-au făcut și lui tot ce au vrut, așa cum este scris despre El.” ");
INSERT INTO ronlsb_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Când a venit la ucenici, a văzut o mulțime mare în jurul lor și cărturari care îi întrebau. ");
INSERT INTO ronlsb_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Îndată toată mulțimea, văzându-l, a fost foarte uimită și, alergând la el, l-a salutat. ");
INSERT INTO ronlsb_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","El i-a întrebat pe cărturari: “Ce-i întrebați?” ");
INSERT INTO ronlsb_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Unul din mulțime a răspuns: “Învățătorule, ți-am adus pe fiul meu, care are un duh mut, ");
INSERT INTO ronlsb_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","și oriunde îl apucă, îl aruncă la pământ; face spume la gură, scrâșnește din dinți și se înțeapă. I-am rugat pe discipolii tăi să-l scoată afară, dar n-au fost în stare.” ");
INSERT INTO ronlsb_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","El i-a răspuns: “Neam necredincios, până când voi fi cu voi? Până când voi mai suporta cu voi? Aduceți-l la Mine!” ");
INSERT INTO ronlsb_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","L-au adus la el și, când l-a văzut, îndată l-a cuprins duhul și a căzut la pământ, zvârcolindu-se și făcând spume la gură. ");
INSERT INTO ronlsb_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Și a întrebat pe tatăl său: “De când i se întâmplă asta?” El a spus: “Din copilărie. ");
INSERT INTO ronlsb_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","De multe ori l-a aruncat atât în foc, cât și în apă, pentru a-l distruge. Dar dacă poți face ceva, ai milă de noi și ajută-ne.” ");
INSERT INTO ronlsb_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Isus i-a zis: “Dacă poți crede, toate sunt cu putință celui ce crede.” ");
INSERT INTO ronlsb_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Și îndată tatăl copilului a strigat cu lacrimi: “Cred. Ajută-mi necredința!” ");
INSERT INTO ronlsb_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Isus, văzând că o mulțime alerga laolaltă, a mustrat pe duhul necurat și i-a zis: “Duh mut și surd, îți poruncesc să ieși din el și să nu mai intri niciodată în el!” ");
INSERT INTO ronlsb_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Și după ce a strigat și a fost cuprins de mari convulsii, a ieșit din el. Băiatul s-a făcut ca un mort, atât de mult încât cei mai mulți dintre ei au spus: “A murit”. ");
INSERT INTO ronlsb_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Dar Isus l-a luat de mână și l-a înviat; și s-a ridicat. ");
INSERT INTO ronlsb_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","După ce a intrat în casă, ucenicii Lui L-au întrebat în particular: “De ce n-am putut să-l scoatem afară?” ");
INSERT INTO ronlsb_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Și le-a zis: “Nu se poate ieși așa ceva decât prin rugăciune și prin post.” ");
INSERT INTO ronlsb_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Au plecat de acolo și au trecut prin Galileea. El nu voia să știe nimeni, ");
INSERT INTO ronlsb_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","pentru că îi învăța pe ucenicii Săi și le spunea: “Fiul Omului va fi dat în mâinile oamenilor și ei Îl vor ucide; iar după ce va fi ucis, a treia zi va învia.” ");
INSERT INTO ronlsb_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Dar ei nu înțelegeau cuvântul acesta și se temeau să-L întrebe. ");
INSERT INTO ronlsb_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Când a ajuns în Capernaum, i-a întrebat pe cei din casă: “Ce vă certați între voi pe drum?” ");
INSERT INTO ronlsb_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Dar ei au tăcut, pentru că pe drum se certau între ei cine este cel mai mare. ");
INSERT INTO ronlsb_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","A șezut jos, a chemat pe cei doisprezece și le-a zis: “Dacă cineva vrea să fie cel dintâi, să fie cel din urmă dintre toți și slujitorul tuturor.” ");
INSERT INTO ronlsb_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","A luat un copilaș și l-a așezat în mijlocul lor. Luându-l în brațe, le-a spus: ");
INSERT INTO ronlsb_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Oricine primește un astfel de copilaș în numele meu, pe mine mă primește; și oricine mă primește pe mine, nu pe mine mă primește, ci pe cel care m-a trimis pe mine.” ");
INSERT INTO ronlsb_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ioan I-a zis: “Învățătorule, am văzut pe cineva care nu ne urmează, care scoate demoni în Numele Tău, și i-am interzis, pentru că nu ne urmează.” ");
INSERT INTO ronlsb_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Dar Isus a zis: “Nu-i interziceți, căci nu este nimeni care să facă o lucrare mare în Numele Meu și să poată repede să vorbească de rău despre Mine. ");
INSERT INTO ronlsb_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Căci oricine nu este împotriva noastră este de partea noastră. ");
INSERT INTO ronlsb_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Căci oricine vă va da să beți un pahar cu apă în numele meu, pentru că sunteți ai lui Hristos, cu siguranță vă spun că nu-și va pierde în niciun fel răsplata. ");
INSERT INTO ronlsb_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Oricine va face să se poticnească pe unul din acești mici care cred în Mine, mai bine ar fi să fie aruncat în mare, cu o piatră de moară atârnată de gât. ");
INSERT INTO ronlsb_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Dacă mâna ta te face să te poticnești, taie-ți-o! Este mai bine pentru tine să intri în viață mutilat, decât să ai cele două mâini pentru a merge în Gheena, în focul nestins, ");
INSERT INTO ronlsb_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","“unde viermele lor nu moare și focul nu se stinge”. ");
INSERT INTO ronlsb_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Dacă piciorul tău te face să te poticnești, taie-l! Este mai bine pentru tine să intri în viață șchiop, decât ca cele două picioare să fie aruncate în Gheena, în focul care nu se va stinge niciodată — ");
INSERT INTO ronlsb_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","'unde viermele lor nu moare și focul nu se stinge'. ");
INSERT INTO ronlsb_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Dacă ochiul tău te face să te poticnești, aruncă-l afară. Este mai bine pentru tine să intri în Împărăția lui Dumnezeu cu un singur ochi, decât să ai doi ochi pentru a fi aruncat în Gheena de foc, ");
INSERT INTO ronlsb_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","'unde viermele lor nu moare și focul nu se stinge'. ");
INSERT INTO ronlsb_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Căci toată lumea va fi sărată cu foc și orice jertfă va fi condimentată cu sare. ");
INSERT INTO ronlsb_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Sarea este bună, dar, dacă sarea și-a pierdut savoarea, cu ce o vei asezona? Aveți sare în voi înșivă și fiți în pace unii cu alții.” ");
INSERT INTO ronlsb_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","S-a ridicat de acolo și a ajuns în ținutul Iudeii și dincolo de Iordan. Mulțimile s-au adunat din nou la El. Așa cum făcea de obicei, îi învăța din nou. ");
INSERT INTO ronlsb_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Fariseii, venind la El, L-au pus la încercare și L-au întrebat: “Este îngăduit ca un bărbat să divorțeze de nevasta sa?” ");
INSERT INTO ronlsb_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","El a răspuns: “Ce ți-a poruncit Moise?” ");
INSERT INTO ronlsb_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ei au zis: “Moise a îngăduit să se scrie un certificat de divorț și să se divorțeze de ea.” ");
INSERT INTO ronlsb_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Dar Isus le-a zis: “Pentru împietrirea inimii voastre, v-a scris porunca aceasta. ");
INSERT INTO ronlsb_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Dar, de la începutul creației, Dumnezeu i-a făcut bărbat și femeie. ");
INSERT INTO ronlsb_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","De aceea, omul va lăsa pe tatăl său și pe mama sa și se va uni cu soția sa, ");
INSERT INTO ronlsb_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","și cei doi se vor face un singur trup, astfel încât nu mai sunt doi, ci un singur trup. ");
INSERT INTO ronlsb_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Așadar, ceea ce Dumnezeu a unit, nimeni să nu despartă.” ");
INSERT INTO ronlsb_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","În casă, ucenicii Lui L-au întrebat din nou despre același lucru. ");
INSERT INTO ronlsb_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","El le-a spus: “Oricine divorțează de soția sa și se căsătorește cu alta comite adulter împotriva ei. ");
INSERT INTO ronlsb_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Dacă o femeie însăși divorțează de soțul ei și se căsătorește cu altul, comite adulter.” ");
INSERT INTO ronlsb_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Îi aduceau prunci, ca să se atingă de ei; dar ucenicii mustrau pe cei ce-i aduceau. ");
INSERT INTO ronlsb_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Dar Isus, văzând aceasta, s-a indignat și le-a zis: “Lăsați copilașii să vină la Mine! Nu le interziceți, căci Împărăția lui Dumnezeu aparține unora ca aceștia. ");
INSERT INTO ronlsb_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Adevărat vă spun că oricine nu va primi Împărăția lui Dumnezeu ca un copilaș, nu va intra nicidecum în ea.” ");
INSERT INTO ronlsb_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","El i-a luat în brațe și i-a binecuvântat, punându-și mâinile peste ei. ");
INSERT INTO ronlsb_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Pe când ieșea El pe cale, a alergat unul la El, a îngenuncheat înaintea Lui și L-a întrebat: “Învățătorule, ce să fac ca să moștenesc viața veșnică?” ");
INSERT INTO ronlsb_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Isus i-a zis: “De ce Mă numești bun? Nimeni nu este bun, în afară de unul singur: Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Tu cunoști poruncile: Să nu ucizi, să nu comiți adulter, să nu furi, să nu depui mărturie mincinoasă, să nu înșeli, să cinstești pe tatăl tău și pe mama ta.” ");
INSERT INTO ronlsb_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","El I-a zis: “Învățătorule, toate acestea le știu din tinerețe.” ");
INSERT INTO ronlsb_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Isus, uitându-se la el, l-a iubit și i-a zis: “Un singur lucru îți lipsește. Du-te, vinde tot ce ai și dă săracilor și vei avea o comoară în ceruri; și vino, urmează-Mi, luându-ți crucea.” ");
INSERT INTO ronlsb_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Dar, când a auzit acest cuvânt, fața lui a căzut și a plecat mâhnit, pentru că era un om care avea multe averi. ");
INSERT INTO ronlsb_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Isus s-a uitat în jur și a zis ucenicilor Săi: “Cât de greu intră în Împărăția lui Dumnezeu cei ce au bogății!” ");
INSERT INTO ronlsb_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ucenicii au rămas uimiți de cuvintele Lui. Dar Isus le-a răspuns din nou: “Copii, cât de greu intră în Împărăția lui Dumnezeu cei ce se încred în bogății! ");
INSERT INTO ronlsb_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Este mai ușor pentru o cămilă să treacă prin urechea unui ac decât pentru un om bogat să intre în Împărăția lui Dumnezeu.” ");
INSERT INTO ronlsb_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ei au fost foarte mirați și I-au zis: “Cine poate fi mântuit?” ");
INSERT INTO ronlsb_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Isus, uitându-se la ei, a zis: “La oameni este cu neputință, dar nu și la Dumnezeu, căci la Dumnezeu toate lucrurile sunt cu putință.” ");
INSERT INTO ronlsb_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Și Petru a început să-i spună: “Iată, noi am lăsat totul și am venit după Tine.” ");
INSERT INTO ronlsb_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Isus a zis: “Adevărat vă spun că nu este nimeni care să fi lăsat casă, frați, surori, tată, mamă, nevastă, copii sau pământ, pentru Mine și pentru Buna Vestire, ");
INSERT INTO ronlsb_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ci va primi de o sută de ori mai mult acum, în veacul acesta: case, frați, surori, mame, copii, pământ, cu prigoane, iar în veacul viitor, viața veșnică. ");
INSERT INTO ronlsb_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Dar mulți dintre cei dintâi vor fi cei din urmă, iar cei din urmă cei dintâi.” ");
INSERT INTO ronlsb_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ei erau pe drum, urcându-se la Ierusalim; și Isus mergea înaintea lor, și ei erau uimiți, iar cei ce-i urmau se temeau. El i-a luat din nou pe cei doisprezece și a început să le spună lucrurile care aveau să i se întâmple. ");
INSERT INTO ronlsb_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Iată, ne suim la Ierusalim. Fiul Omului va fi dat pe mâna preoților de seamă și a cărturarilor. Aceștia îl vor condamna la moarte și îl vor da pe mâna neamurilor. ");
INSERT INTO ronlsb_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Îl vor batjocori, îl vor scuipa, îl vor biciui și îl vor ucide. A treia zi va învia.” ");
INSERT INTO ronlsb_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Iacov și Ioan, fiii lui Zebedei, s-au apropiat de El și I-au zis: “Învățătorule, vrem să faci pentru noi tot ce-Ți vom cere.” ");
INSERT INTO ronlsb_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","El le-a zis: “Ce vreți să fac pentru voi?” ");
INSERT INTO ronlsb_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Și I-au zis: “Dă-ne nouă să ședem, unul la dreapta Ta și altul la stânga Ta, în slava Ta.” ");
INSERT INTO ronlsb_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Dar Isus le-a zis: “Nu știți ce cereți. Sunteți în stare să beți paharul pe care îl beau Eu și să fiți botezați cu botezul cu care sunt botezat Eu?” ");
INSERT INTO ronlsb_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ei i-au zis: “Putem.” Isus le-a zis: “Voi veți bea paharul pe care îl beau Eu și veți fi botezați cu botezul cu care sunt botezat Eu; ");
INSERT INTO ronlsb_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","dar șederea la dreapta și la stânga Mea nu este a Mea, ci a cui a fost pregătită.” ");
INSERT INTO ronlsb_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Cei zece, când au auzit, au început să se mânie pe Iacov și pe Ioan. ");
INSERT INTO ronlsb_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Isus i-a chemat și le-a zis: “Știți că cei ce sunt socotiți stăpâni peste neamuri stăpânesc peste ele și că cei mari stăpânesc peste ele. ");
INSERT INTO ronlsb_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Dar la voi nu va fi așa, ci oricine vrea să devină mare între voi va fi robul vostru. ");
INSERT INTO ronlsb_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Oricine dintre voi va vrea să devină cel dintâi dintre voi va fi robul tuturor. ");
INSERT INTO ronlsb_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Căci și Fiul Omului a venit nu ca să fie slujit, ci ca să slujească și să-și dea viața ca răscumpărare pentru mulți.” ");
INSERT INTO ronlsb_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Au ajuns la Ierihon. Pe când ieșea din Ierihon cu ucenicii Săi și cu o mare mulțime, fiul lui Timeu, Bartimeu, un cerșetor orb, ședea lângă drum. ");
INSERT INTO ronlsb_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Când a auzit că era Isus Nazarineanul, a început să strige și să spună: “Isuse, Fiul lui David, ai milă de mine!” ");
INSERT INTO ronlsb_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Mulți îl mustrau, ca să tacă, dar el striga mult mai tare: “Fiul lui David, ai milă de mine!” ");
INSERT INTO ronlsb_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Isus s-a oprit și a zis: “Cheamă-l.” L-au chemat pe orb și i-au zis: “Înveselește-te! Ridică-te! El te cheamă!” ");
INSERT INTO ronlsb_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","El, aruncându-și haina, s-a ridicat și a venit la Isus. ");
INSERT INTO ronlsb_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Isus l-a întrebat: “Ce vrei să fac pentru tine?” Orbul i-a zis: “Rabboni, ca să văd din nou”. ");
INSERT INTO ronlsb_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Isus i-a zis: “Du-te și mergi. Credința ta te-a făcut sănătos”. Imediat și-a recăpătat vederea și l-a urmat pe Isus pe drum. ");
INSERT INTO ronlsb_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Când s-au apropiat de Ierusalim, de Betfaghe și Betania, pe Muntele Măslinilor, a trimis doi dintre ucenicii Săi ");
INSERT INTO ronlsb_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","și le-a zis: “Mergeți în satul care este în fața voastră. Imediat ce veți intra în el, veți găsi legat un măgăruș tânăr, pe care nu s-a așezat nimeni. Dezlegați-l și aduceți-l. ");
INSERT INTO ronlsb_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Dacă vă întreabă cineva: “De ce faceți asta?”, spuneți: “Domnul are nevoie de el”; și îndată îl va trimite înapoi aici.” ");
INSERT INTO ronlsb_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","S-au dus și au găsit un măgăruș legat la ușă, afară, în plină stradă, și l-au dezlegat. ");
INSERT INTO ronlsb_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Unii dintre cei care stăteau acolo i-au întrebat: “Ce faceți, dezlegând măgărușul?” ");
INSERT INTO ronlsb_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ei le-au spus exact cum le spusese Isus și i-au lăsat să plece. ");
INSERT INTO ronlsb_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Au adus la Isus un măgăruș, și-au aruncat hainele pe el și Isus a șezut pe el. ");
INSERT INTO ronlsb_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Mulți își întindeau hainele pe drum, iar alții tăiau ramuri din copaci și le împrăștiau pe drum. ");
INSERT INTO ronlsb_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Cei care mergeau în față și cei care veneau după ei strigau: “Osana! Binecuvântat este cel care vine în numele Domnului! ");
INSERT INTO ronlsb_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Binecuvântată este împărăția tatălui nostru David, care vine în numele Domnului! Osana în locurile prea înalte!” ");
INSERT INTO ronlsb_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Isus a intrat în Templul din Ierusalim. După ce a privit totul în jur, fiind seară, a ieșit în Betania cu cei doisprezece. ");
INSERT INTO ronlsb_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","A doua zi, după ce au ieșit din Betania, i-a fost foame. ");
INSERT INTO ronlsb_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Văzând de departe un smochin care avea frunze, a venit să vadă dacă nu cumva ar putea găsi ceva pe el. Când a ajuns la el, nu a găsit decât frunze, căci nu era sezonul smochinelor. ");
INSERT INTO ronlsb_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Isus i-a spus: “Fie ca nimeni să nu mai mănânce vreodată fructe de la tine!”, iar discipolii lui au auzit. ");
INSERT INTO ronlsb_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Au ajuns la Ierusalim, și Isus a intrat în Templu și a început să dea afară pe cei ce vindeau și pe cei ce cumpărau în Templu, să răstoarne mesele schimbătorilor de bani și scaunele celor ce vindeau porumbei. ");
INSERT INTO ronlsb_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","El nu permitea nimănui să transporte un recipient prin templu. ");
INSERT INTO ronlsb_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","El îi învăța și le spunea: “Nu este oare scris: “Casa mea va fi numită casă de rugăciune pentru toate neamurile?”? Dar voi ați făcut din ea o peșteră de tâlhari!” ");
INSERT INTO ronlsb_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Preoții cei mai de seamă și cărturarii au auzit acest lucru și căutau cum să-L nimicească. Căci se temeau de el, pentru că toată mulțimea era uimită de învățătura lui. ");
INSERT INTO ronlsb_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Când s-a făcut seară, a ieșit din cetate. ");
INSERT INTO ronlsb_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Dimineața, când a trecut pe acolo, a văzut smochinul uscat din rădăcini. ");
INSERT INTO ronlsb_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petru, aducându-și aminte, i-a zis: “Rabi, uite! Smochinul pe care l-ai blestemat s-a uscat”. ");
INSERT INTO ronlsb_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Isus le-a răspuns: “Aveți credință în Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Căci, cu adevărat vă spun că oricine va spune acestui munte: “Ia-l și aruncă-l în mare” și nu se îndoiește în inima lui, ci crede că ceea ce spune se întâmplă, va avea tot ce spune. ");
INSERT INTO ronlsb_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","De aceea vă spun că orice lucru pe care îl rugați și îl cereți, credeți că l-ați primit și îl veți avea. ");
INSERT INTO ronlsb_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ori de câte ori stați la rugăciune, iertați, dacă aveți ceva împotriva cuiva, pentru ca și Tatăl vostru, care este în ceruri, să vă ierte greșelile voastre. ");
INSERT INTO ronlsb_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Dar dacă nu iertați, nici Tatăl vostru care este în ceruri nu vă va ierta greșelile voastre.” ");
INSERT INTO ronlsb_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Și, întorcându-se la Ierusalim, pe când umbla El în Templu, au venit la El preoții cei mai de seamă, cărturarii și bătrânii ");
INSERT INTO ronlsb_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","și au început să-I spună: “Cu ce putere faci Tu aceste lucruri? Sau cine ți-a dat această autoritate ca să faci aceste lucruri?” ");
INSERT INTO ronlsb_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Isus le-a zis: “Vă voi pune o întrebare. Răspundeți-mi și vă voi spune cu ce autoritate fac aceste lucruri. ");
INSERT INTO ronlsb_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Botezul lui Ioan — a fost din cer sau de la oameni? Răspundeți-mi!” ");
INSERT INTO ronlsb_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ei se gândeau între ei, zicând: “Dacă vom spune: “Din cer”, el va zice: “De ce nu l-ați crezut?” ");
INSERT INTO ronlsb_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Dacă vom spune: “De la oameni””, se temeau de popor, căci toți îl considerau pe Ioan ca fiind cu adevărat un profet. ");
INSERT INTO ronlsb_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ei i-au răspuns lui Isus: “Nu știm”. Isus le-a zis: “Nici Eu nu vă voi spune cu ce putere fac aceste lucruri.” ");
INSERT INTO ronlsb_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Și a început să le vorbească în parabole. “Un om a plantat o vie, a pus un gard în jurul ei, a săpat o groapă pentru presa de vin, a construit un turn, a dat-o în arendă unui fermier și a plecat în altă țară. ");
INSERT INTO ronlsb_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Când a venit vremea, a trimis un servitor la fermier pentru a lua de la acesta partea lui din roadele viei. ");
INSERT INTO ronlsb_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","L-au prins, l-au bătut și l-au trimis departe cu mâna goală. ");
INSERT INTO ronlsb_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","El a trimis din nou un alt slujitor la ei; dar ei au aruncat cu pietre în el, l-au rănit la cap și l-au trimis departe cu un tratament rușinos. ");
INSERT INTO ronlsb_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","A trimis iarăși un altul, și l-au omorât pe el și pe mulți alții, bătându-i pe unii și omorându-i pe alții. ");
INSERT INTO ronlsb_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","De aceea, având încă unul, fiul său preaiubit, l-a trimis ultimul la ei, zicând: “Îl vor respecta pe fiul meu”. ");
INSERT INTO ronlsb_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Dar țăranii aceia au zis între ei: “Acesta este moștenitorul. Haideți să-l omorâm și moștenirea va fi a noastră'. ");
INSERT INTO ronlsb_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","L-au luat, l-au ucis și l-au aruncat afară din vie. ");
INSERT INTO ronlsb_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ce va face, așadar, stăpânul viei? Va veni și îi va nimici pe fermieri și va da via altora. ");
INSERT INTO ronlsb_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","N-ați citit măcar Scriptura aceasta: “Piatra pe care au respins-o zidarii a fost numit șef de colț. ");
INSERT INTO ronlsb_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Aceasta a fost de la Domnul. Este minunat în ochii noștri”?”? ");
INSERT INTO ronlsb_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ei au încercat să-L prindă, dar se temeau de mulțime, pentru că au înțeles că vorbea pilda împotriva lor. L-au lăsat și au plecat. ");
INSERT INTO ronlsb_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Au trimis la el pe unii dintre farisei și dintre erodieni, ca să-l prindă cu vorba. ");
INSERT INTO ronlsb_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","După ce au venit, l-au întrebat: “Învățătorule, știm că ești cinstit și că nu te înfrânezi de la nimeni, căci nu ești părtinitor față de nimeni, ci înveți cu adevărat calea lui Dumnezeu. Este sau nu este drept să plătim impozite Cezarului? ");
INSERT INTO ronlsb_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Să dăm, sau să nu dăm?” Dar El, cunoscând ipocrizia lor, le-a zis: “De ce Mă puneți la încercare? Aduceți-mi un denar, ca să-l văd”. ");
INSERT INTO ronlsb_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Și au adus-o. El le-a întrebat: “A cui este acest chip și această inscripție?” I-au spus: “A lui Cezar”. ");
INSERT INTO ronlsb_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Isus le-a răspuns: “Dați Cezarului ce este al Cezarului și lui Dumnezeu ce este al lui Dumnezeu.” Ei s-au minunat foarte mult de el. ");
INSERT INTO ronlsb_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Au venit la El niște saduchei, care ziceau că nu există înviere. L-au întrebat, zicând: ");
INSERT INTO ronlsb_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Învățătorule, Moise ne-a scris: “Dacă un frate al unui om moare și lasă în urma lui o soție și nu lasă copii, fratele său să ia pe soția lui și să ridice urmași fratelui său”. ");
INSERT INTO ronlsb_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Erau șapte frați. Primul și-a luat o soție și, murind, nu a lăsat urmași. ");
INSERT INTO ronlsb_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Al doilea a luat-o și a murit, fără să lase copii în urma lui. Al treilea, la fel; ");
INSERT INTO ronlsb_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","iar cei șapte au luat-o și nu au lăsat copii. Ultima dintre toate, femeia a murit și ea. ");
INSERT INTO ronlsb_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","La înviere, când vor învia, a cui soție va fi ea dintre ei? Căci cei șapte au avut-o ca soție.” ");
INSERT INTO ronlsb_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Isus le-a răspuns: “Nu cumva vă înșelați, pentru că nu cunoașteți Scripturile și puterea lui Dumnezeu? ");
INSERT INTO ronlsb_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Căci, când vor învia din morți, nici nu se vor căsători, nici nu vor fi dați în căsătorie, ci vor fi ca îngerii din ceruri. ");
INSERT INTO ronlsb_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Dar despre morți, despre faptul că vor învia, n-ați citit în cartea lui Moise, despre Tufișul, cum i-a vorbit Dumnezeu, zicând: “Eu sunt Dumnezeul lui Avraam, Dumnezeul lui Isaac și Dumnezeul lui Iacov”? ");
INSERT INTO ronlsb_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","El nu este Dumnezeul morților, ci al celor vii. Prin urmare, vă înșelați amarnic”. ");
INSERT INTO ronlsb_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Unul dintre cărturari, venind și auzindu-i pe ei întrebând împreună, și știind că le răspunsese bine, L-a întrebat: “Care poruncă este cea mai mare dintre toate?” ");
INSERT INTO ronlsb_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Isus a răspuns: “Cel mai mare este: “Ascultă, Israele, Domnul Dumnezeul nostru, Domnul este unul. ");
INSERT INTO ronlsb_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Să iubești pe Domnul Dumnezeul tău din toată inima ta, din tot sufletul tău, din tot cugetul tău și din toată puterea ta. Aceasta este prima poruncă. ");
INSERT INTO ronlsb_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Cea de-a doua este așa: “Ce este a doua poruncă? “Să iubești pe aproapele tău ca pe tine însuți”. Nu există altă poruncă mai mare decât acestea”.” ");
INSERT INTO ronlsb_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Cărturarul i-a zis: “Cu adevărat, învățătorule, bine ai spus că El este unul și nu este altul decât El; ");
INSERT INTO ronlsb_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","și a-L iubi pe El cu toată inima, cu toată mintea, cu tot sufletul și cu toată puterea și a iubi pe aproapele ca pe sine însuși este mai de preț decât toate arderile de tot și decât toate jertfele.” ");
INSERT INTO ronlsb_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Isus, văzând că a răspuns cu înțelepciune, i-a zis: “Nu ești departe de Împărăția lui Dumnezeu.” Nimeni nu a mai îndrăznit să-i pună întrebări după aceea. ");
INSERT INTO ronlsb_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Isus a răspuns, în timp ce învăța în templu: “Cum se face că scribii spun că Hristosul este fiul lui David? ");
INSERT INTO ronlsb_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Căci David însuși a spus în Duhul Sfânt, “Domnul a spus Domnului meu, “Stai la dreapta mea, până ce voi face din vrăjmașii tăi scăunelul picioarelor tale.” ");
INSERT INTO ronlsb_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","De aceea însuși David îl numește Domn, și cum ar putea fi fiul său?” Oamenii de rând l-au ascultat cu bucurie. ");
INSERT INTO ronlsb_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","În învățătura sa, el le spunea: “Feriți-vă de cărturari, cărora le place să umble în haine lungi, să primească salutări în piețe, ");
INSERT INTO ronlsb_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","să obțină cele mai bune locuri în sinagogi și cele mai bune locuri la sărbători, ");
INSERT INTO ronlsb_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","cei care devorează casele văduvelor și care, pentru a se preface, fac rugăciuni lungi. Aceștia vor primi o condamnare mai mare”. ");
INSERT INTO ronlsb_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Isus a șezut în fața vistieriei și a văzut cum mulțimea arunca bani în vistierie. Mulți dintre cei bogați au aruncat mult. ");
INSERT INTO ronlsb_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","O văduvă săracă a venit și a aruncat două monede mici de aramă, care sunt cât o monedă de un pătrar. ");
INSERT INTO ronlsb_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","El și-a chemat discipolii și le-a spus: “Adevărat vă spun că această văduvă săracă a dat mai mult decât toți cei care dau în vistierie, ");
INSERT INTO ronlsb_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","căcitoți au dat din belșugul lor, dar ea, din sărăcia ei, a dat tot ce avea ca să trăiască.” ");
INSERT INTO ronlsb_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Când a ieșit din templu, unul din ucenicii Săi I-a zis: “Învățătorule, vezi ce fel de pietre și ce fel de clădiri!” ");
INSERT INTO ronlsb_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Isus i-a zis: “Vezi tu aceste clădiri mari? Nu va rămâne aici piatră pe piatră care să nu fie dărâmată.” ");
INSERT INTO ronlsb_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Pe când ședea El pe Muntele Măslinilor, vizavi de Templu, Petru, Iacov, Ioan și Andrei L-au întrebat în particular: ");
INSERT INTO ronlsb_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Spune-ne, când se vor întâmpla aceste lucruri? Care este semnul că toate aceste lucruri sunt pe cale să se împlinească?” ");
INSERT INTO ronlsb_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Isus, răspunzând, a început să le spună: “Luați seama ca nimeni să nu vă ducă în rătăcire. ");
INSERT INTO ronlsb_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Căci mulți vor veni în numele meu, spunând: “Eu sunt!” și vor duce pe mulți în rătăcire. ");
INSERT INTO ronlsb_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Când auziți de războaie și de zvonuri de războaie, nu vă tulburați. Căci acestea trebuie să se întâmple, dar sfârșitul nu este încă. ");
INSERT INTO ronlsb_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Căci se va ridica națiune împotriva națiunii și regat împotriva regatului. Vor fi cutremure în diferite locuri. Vor fi foamete și necazuri. Aceste lucruri sunt începutul durerilor de naștere. ");
INSERT INTO ronlsb_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Dar păziți-vă, căci vă vor da la consilii. Veți fi bătuți în sinagogi. Veți sta în fața conducătorilor și a împăraților din cauza Mea, ca mărturie pentru ei. ");
INSERT INTO ronlsb_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Vestea cea bună trebuie mai întâi să fie propovăduită la toate națiunile. ");
INSERT INTO ronlsb_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Când vă vor duce și vă vor preda, nu vă îngrijorați dinainte și nu premeditați ce veți spune, ci spuneți tot ce vi se va da în acel ceas. Căci nu voi sunteți cei care vorbiți, ci Duhul Sfânt. ");
INSERT INTO ronlsb_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Fratele va da la moarte pe fratele său și tatăl pe copilul său. Copiii se vor ridica împotriva părinților și îi vor face să moară. ");
INSERT INTO ronlsb_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Veți fi urâți de toți oamenii din pricina numelui Meu, dar cel care va răbda până la sfârșit va fi mântuit. ");
INSERT INTO ronlsb_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Dar când veți vedea urâciunea pustiirii, despre care vorbește proorocul Daniel, stând acolo unde nu trebuie” (să înțeleagă cititorul), “atunci cei din Iudeea să fugă în munți, ");
INSERT INTO ronlsb_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","iar cel ce este pe acoperișul casei să nu se coboare și să nu intre să ia nimic din casa lui. ");
INSERT INTO ronlsb_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Cel care este pe câmp să nu se întoarcă să își ia mantaua. ");
INSERT INTO ronlsb_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Dar vai de cele însărcinate și de cele care alăptează copii în acele zile! ");
INSERT INTO ronlsb_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Rugați-vă ca fuga voastră să nu fie în timpul iernii. ");
INSERT INTO ronlsb_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Căci în zilele acelea va fi o asuprire, cum nu a mai fost așa ceva de la începutul creației pe care a creat-o Dumnezeu până acum și nici nu va mai fi vreodată. ");
INSERT INTO ronlsb_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Dacă Domnul nu ar fi scurtat zilele, nicio făptură nu ar fi fost salvată; dar, de dragul celor aleși, pe care i-a ales, a scurtat zilele. ");
INSERT INTO ronlsb_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Așadar, dacă vă spune cineva: “Uite, aici este Hristosul!” sau “Uite, acolo!”, nu-l credeți. ");
INSERT INTO ronlsb_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Căci se vor ridica falși hristoși și falși profeți și vor face semne și minuni, ca să ducă în rătăcire, dacă este posibil, chiar și pe cei aleși. ");
INSERT INTO ronlsb_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Dar voi vegheați. “Iată, v-am spus toate lucrurile mai dinainte. ");
INSERT INTO ronlsb_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Dar în zilele acelea, după acea asuprire, soarele se va întuneca, luna nu-și va mai da lumina, ");
INSERT INTO ronlsb_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","stelele vor cădea din cer și puterile care sunt în ceruri vor fi zguduite. ");
INSERT INTO ronlsb_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Atunci vor vedea pe Fiul Omului venind pe nori, cu mare putere și glorie. ");
INSERT INTO ronlsb_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Atunci va trimite pe îngerii Săi și va aduna pe cei aleși ai Săi din cele patru vânturi, de la marginile pământului până la marginile cerului. ");
INSERT INTO ronlsb_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Și acum, de la smochin, învățați pilda aceasta. Când acum ramura s-a înmuiat și își produce frunzele, știți că vara este aproape; ");
INSERT INTO ronlsb_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","tot așa și voi, când vedeți că se întâmplă aceste lucruri, știți că este aproape, la uși. ");
INSERT INTO ronlsb_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Adevărat vă spun că generația aceasta nu va trece până nu se vor întâmpla toate aceste lucruri. ");
INSERT INTO ronlsb_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Cerul și pământul vor trece, dar cuvintele Mele nu vor trece. ");
INSERT INTO ronlsb_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Dar despre ziua aceea și despre ceasul acela nimeni nu știe, nici îngerii din ceruri, nici Fiul, ci numai Tatăl. ");
INSERT INTO ronlsb_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Vegheați, fiți vigilenți și rugați-vă, căci nu știți când va fi ceasul. ");
INSERT INTO ronlsb_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Este ca și cum un om care pleacă în altă țară, care a plecat din casa sa și a dat putere slugilor sale, a dat fiecăruia lucrul său și a poruncit portarului să vegheze. ");
INSERT INTO ronlsb_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Vegheați, deci, căci nu știți când va veni stăpânul casei — fie seara, fie la miezul nopții, fie când cântă cocoșul, fie dimineața; ");
INSERT INTO ronlsb_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ca nu cumva, venind deodată, să vă găsească dormind. ");
INSERT INTO ronlsb_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ceeace vă spun, spun tuturor: Vegheați!” ");
INSERT INTO ronlsb_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Cu două zile înainte de Paști și de sărbătoarea azimilor, preoții cei mai de seamă și cărturarii căutau cum să-L prindă cu înșelăciune și să-L omoare. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Căci ziceau: “Nu în timpul sărbătorii, pentru că s-ar putea să se facă o răscoală în popor”. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Pe când era în Betania, în casa lui Simon leprosul, pe când ședea la masă, a venit o femeie cu un vas de alabastru cu mir de nard curat, foarte scump. Ea a spart vasul și l-a turnat pe capul lui. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Dar unii dintre ei erau indignați între ei și ziceau: “De ce s-a risipit mirul acesta? ");
INSERT INTO ronlsb_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Pentru că ar fi putut fi vândut cu mai mult de trei sute de denari și dat săracilor.” Așa că au cârtit împotriva ei. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Dar Isus a zis: “Las-o în pace. De ce o tulburați? Ea a făcut o lucrare bună pentru Mine. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Pentru că voi aveți mereu săraci cu voi și, oricând vreți, le puteți face bine, dar pe mine nu mă veți avea mereu. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ea a făcut tot ce a putut. Mi-a uns trupul mai dinainte pentru înmormântare. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Cu siguranță vă spun că, oriunde se va propovădui această Bună Vestire în toată lumea, se va vorbi și despre ceea ce a făcut această femeie, ca o amintire a ei.” ");
INSERT INTO ronlsb_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Iuda Iscarioteanul, care era unul din cei doisprezece, s-a dus la preoții cei mai de seamă, ca să li-l predea. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Aceștia, când au auzit, s-au bucurat și au făgăduit să-i dea bani. El a căutat cum ar putea să-l livreze în mod convenabil. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","În prima zi a azimilor, când se jertfeau Paștile, ucenicii Lui L-au întrebat: “Unde vrei să mergem să pregătim ca să mâncați Paștile?” ");
INSERT INTO ronlsb_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Și a trimis doi dintre ucenicii Săi și le-a zis: “Mergeți în cetate și vă va întâmpina un om care duce un ulcior cu apă. Urmați-l ");
INSERT INTO ronlsb_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","și, oriunde va intra, spuneți-i stăpânului casei: “Învățătorul spune: “Unde este camera de oaspeți, unde pot mânca Paștele cu discipolii mei?””. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","El însuși vă va arăta o cameră mare de sus, mobilată și pregătită. Pregătește-ne acolo”. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ucenicii Lui au ieșit, au intrat în cetate și au găsit lucrurile așa cum le spusese El și au pregătit Paștele. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Când s-a făcut seară, a venit cu cei doisprezece. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Pe când ședeau și mâncau, Isus a zis: “Vă spun cu siguranță că unul dintre voi Mă va trăda — cel care mănâncă cu Mine.” ");
INSERT INTO ronlsb_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Și au început să se întristeze și să-L întrebe unul câte unul: “Nu cumva sunt eu?” Și un altul a zis: “Cu siguranță nu eu?” ");
INSERT INTO ronlsb_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","El le-a răspuns: “Este unul din cei doisprezece, cel care se scufundă cu Mine în mâncare. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Căci Fiul Omului merge așa cum este scris despre El, dar vai de omul acela prin care este trădat Fiul Omului! Mai bine pentru acel om ar fi fost mai bine să nu se fi născut.” ");
INSERT INTO ronlsb_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Pe când mâncau ei, Isus a luat o pâine și, după ce a binecuvântat-o, a frânt-o, le-a dat-o și le-a zis: “Luați, mâncați. Acesta este trupul Meu”. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","A luat paharul și, după ce a mulțumit, le-a dat. Toți au băut din el. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Și le-a zis: “Acesta este sângele Meu, al noului legământ, care se varsă pentru mulți. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Adevărat vă spun că nu voi mai bea din rodul viței de vie până în ziua când îl voi bea din nou în Împărăția lui Dumnezeu.” ");
INSERT INTO ronlsb_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","După ce au cântat un imn, au ieșit pe Muntele Măslinilor. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Isus le-a zis: “În noaptea aceasta, toți vă veți poticni din pricina Mea, căci este scris: “Voi lovi pe păstor și oile vor fi risipite”. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Totuși, după ce voi fi înviat, voi merge înaintea voastră în Galileea.” ");
INSERT INTO ronlsb_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Dar Petru i-a zis: “Chiar dacă toți se vor supăra, eu nu mă voi supăra.” ");
INSERT INTO ronlsb_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Isus i-a zis: “Adevărat îți spun că astăzi, chiar în noaptea aceasta, înainte de a cânta cocoșul de două ori, te vei lepăda de Mine de trei ori.” ");
INSERT INTO ronlsb_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Dar el a vorbit cu atât mai mult: “Chiar dacă va trebui să mor cu voi, nu mă voi lepăda de voi.” Și toți au spus același lucru. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Și au ajuns la un loc numit Ghetsimani. El a zis ucenicilor Săi: “Ședeți aici, în timp ce Mă voi ruga.” ");
INSERT INTO ronlsb_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","A luat cu El pe Petru, Iacov și Ioan și a început să fie foarte tulburat și necăjit. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","El le-a zis: “Sufletul Meu este foarte întristat, până la moarte. Rămâneți aici și vegheați”. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","A înaintat puțin, a căzut la pământ și s-a rugat ca, dacă se putea, să treacă de la el ceasul acela. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Și a zis: “Abba, Tată, toate lucrurile sunt cu putință pentru Tine. Te rog, îndepărtează de la mine paharul acesta. Oricum, nu ceea ce doresc eu, ci ceea ce dorești Tu”. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","El a venit, i-a găsit dormind și a zis lui Petru: “Simon, dormi? N-ați putut să vegheați un ceas? ");
INSERT INTO ronlsb_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Vegheați și rugați-vă, ca să nu intrați în ispită. Într-adevăr, duhul este binevoitor, dar carnea este slabă.” ");
INSERT INTO ronlsb_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Și s-a dus iarăși și s-a rugat, zicând aceleași cuvinte. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","S-a întors iarăși și i-a găsit dormind, căci aveau ochii foarte îngreunați; și nu știau ce să-i răspundă. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","A venit a treia oară și le-a zis: “Dormiți acum și odihniți-vă. Este de ajuns. A sosit ceasul. Iată, Fiul Omului este dat în mâinile păcătoșilor. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ridicați-vă! Haideți să mergem. Iată, cel care mă trădează este aproape”. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Și îndată, pe când vorbea El încă, a venit Iuda, unul din cei doisprezece, și cu el o mulțime de oameni cu săbii și cu ciomege, de la preoții cei mai de seamă, de la cărturari și de la bătrâni. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Cel care l-a trădat le dăduse un semn, zicând: “Pe cine voi săruta eu, acela este. Prindeți-l și duceți-l în siguranță”. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","După ce a venit, îndată s-a apropiat de el și i-a zis: “Rabi! Rabi!” și l-a sărutat. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ei au pus mâinile pe el și l-au prins. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Dar unul dintre cei care stăteau acolo a scos sabia și a lovit pe slujitorul marelui preot și i-a tăiat urechea. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Isus le-a răspuns: “Ați ieșit voi, ca un tâlhar, cu săbii și cu ciomege, ca să Mă prindeți? ");
INSERT INTO ronlsb_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Eu eram zilnic cu voi în templu, învățând, și nu m-ați arestat. Dar aceasta s-a întâmplat ca să se împlinească Scripturile”. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Toți l-au lăsat și au fugit. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Și un tânăr l-a urmat, cu o pânză de in înfășurată peste trupul lui gol. Tinerii l-au apucat, ");
INSERT INTO ronlsb_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","dar el a lăsat pânza de in și a fugit de ei gol. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","L-au dus pe Isus la marele preot. Toți preoții cei mai de seamă, bătrânii și cărturarii au venit împreună cu el. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petru Îl urmase de departe, până ce a intrat în curtea marelui preot. El stătea cu ofițerii și se încălzea la lumina focului. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Preoții cei mai de seamă și tot consiliul căutau martori împotriva lui Isus, ca să-L condamne la moarte, și n-au găsit niciunul. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Căci mulți dădeau mărturie falsă împotriva lui și mărturiile lor nu se potriveau între ele. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Unii s-au ridicat în picioare și au depus mărturie mincinoasă împotriva lui, zicând: ");
INSERT INTO ronlsb_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“L-am auzit spunând: “Voi nimici templul acesta făcut de mână și în trei zile voi zidi un altul făcut fără mâini”.” ");
INSERT INTO ronlsb_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Chiar și așa, mărturia lor nu era de acord. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Marele preot s-a ridicat în picioare la mijloc și a întrebat pe Isus: “Nu ai răspuns? Ce este ceea ce mărturisesc aceștia împotriva ta?”. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Dar el a tăcut și nu a răspuns nimic. Din nou, marele preot l-a întrebat: “Tu ești Hristosul, Fiul Celui Binecuvântat?”. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Isus a spus: “Eu sunt. Îl veți vedea pe Fiul Omului șezând la dreapta Puterii și venind cu norii cerului.” ");
INSERT INTO ronlsb_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Marele preot și-a rupt hainele și a zis: “Ce nevoie mai avem de martori? ");
INSERT INTO ronlsb_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ați auzit blasfemia! Ce părere aveți?” Cu toții l-au condamnat ca fiind vrednic de moarte. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Unii au început să-l scuipe, să-i acopere fața, să-l bată cu pumnii și să-i spună: “Profetizează!” Ofițerii l-au lovit cu palmele. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pe când Petru era în curtea de jos, a venit una din slujnicele marelui preot, ");
INSERT INTO ronlsb_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","și, văzând pe Petru că se încălzea, s-a uitat la el și i-a zis: “Și tu ai fost cu Nazarineanul Iisus!”. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Dar el a negat, zicând: “Nu știu și nu înțeleg ce spui.” A ieșit pe verandă, iar cocoșul a cântat. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Și servitoarea, văzându-l, a început iarăși să spună celor ce stăteau de față: “Acesta este unul dintre ei”. ");
INSERT INTO ronlsb_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Dar el a negat din nou. După puțină vreme, cei care stăteau de față i-au spus din nou lui Petru: “Cu adevărat, tu ești unul dintre ei, căci ești galileean și vorbirea ta o arată.” ");
INSERT INTO ronlsb_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Dar el a început să blesteme și să jure: “Nu-l cunosc pe omul acesta despre care vorbiți!” ");
INSERT INTO ronlsb_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Cocoșul a cântat a doua oară. Petru și-a amintit cuvintele pe care i le spusese Isus: “Înainte ca cocoșul să cânte de două ori, te vei lepăda de Mine de trei ori”. Când s-a gândit la asta, a plâns. ");
INSERT INTO ronlsb_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Îndată de dimineață, preoții cei mai de seamă, împreună cu bătrânii, cărturarii și tot consiliul, s-au sfătuit, au legat pe Isus, L-au dus și L-au predat lui Pilat. ");
INSERT INTO ronlsb_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilat l-a întrebat: “Ești Tu regele iudeilor?”. El a răspuns: “Așa spui tu”. ");
INSERT INTO ronlsb_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Preoții cei mai de seamă L-au acuzat de multe lucruri. ");
INSERT INTO ronlsb_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilat l-a întrebat din nou: “Nu ai răspuns? Vezi câte lucruri depun împotriva ta!” ");
INSERT INTO ronlsb_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Dar Isus n-a mai răspuns nimic, așa că Pilat s-a mirat. ");
INSERT INTO ronlsb_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Și la sărbătoare le dădea drumul la un prizonier, pe oricine îi cereau. ");
INSERT INTO ronlsb_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Era unul numit Baraba, legat împreună cu tovarășii săi de insurecție, oameni care, în timpul insurecției, săvârșiseră o crimă. ");
INSERT INTO ronlsb_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Mulțimea, strigând cu voce tare, a început să-i ceară să facă pentru el ceea ce făcea întotdeauna pentru ei. ");
INSERT INTO ronlsb_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilat le-a răspuns: “Vreți să vi-l eliberez pe Regele iudeilor?” ");
INSERT INTO ronlsb_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pentru că a înțeles că preoții de seamă l-au predat din invidie. ");
INSERT INTO ronlsb_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Dar preoții cei mai de seamă au stârnit mulțimea, ca el să le elibereze în schimb pe Baraba. ");
INSERT INTO ronlsb_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilat i-a întrebat din nou: “Ce să fac atunci cu cel pe care voi îl numiți Regele iudeilor?” ");
INSERT INTO ronlsb_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Și au strigat din nou: “Răstignește-L!” ");
INSERT INTO ronlsb_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilat le-a zis: “Ce rău a făcut?” Dar ei au strigat foarte tare: “Răstignește-L!” ");
INSERT INTO ronlsb_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilat, vrând să mulțumească norodul, i-a dat drumul lui Baraba, iar pe Isus, după ce l-a biciuit, l-a dat spre răstignire. ");
INSERT INTO ronlsb_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Soldații l-au dus în curtea care este pretoriul și au chemat toată cohorta. ");
INSERT INTO ronlsb_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","L-au îmbrăcat cu purpură; și i-au împletit o coroană de spini, pe care i-au pus-o. ");
INSERT INTO ronlsb_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Au început să-l salute: “Slavă, rege al iudeilor!”. ");
INSERT INTO ronlsb_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","I-au lovit capul cu o trestie, l-au scuipat și, plecându-și genunchii, i-au adus omagiu. ");
INSERT INTO ronlsb_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","După ce și-au bătut joc de el, i-au luat mantia de purpură și i-au pus hainele lui. L-au dus afară ca să-l răstignească. ");
INSERT INTO ronlsb_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Și au silit pe unul care trecea pe acolo, venind de la țară, Simon din Cirene, tatăl lui Alexandru și al lui Rufus, să meargă cu ei, ca să-și poarte crucea. ");
INSERT INTO ronlsb_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","L-au dus la locul numit Golgota, care înseamnă, fiind interpretat, “Locul unui craniu”. ");
INSERT INTO ronlsb_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","I-au oferit să bea vin amestecat cu smirnă, dar el nu l-a luat. ");
INSERT INTO ronlsb_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","L-au răstignit, I-au împărțit hainele Lui și au tras la sorți ce să ia fiecare. ");
INSERT INTO ronlsb_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Era ceasul al treilea când L-au răstignit. ");
INSERT INTO ronlsb_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Și peste el era scrisă supranumele acuzării: “REGELE IUDEILOR”. ");
INSERT INTO ronlsb_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Împreună cu El au răstignit doi tâlhari, unul la dreapta și altul la stânga. ");
INSERT INTO ronlsb_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","S-a împlinit Scriptura care zice: “A fost socotit împreună cu călcătorii de lege”. ");
INSERT INTO ronlsb_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Cei ce treceau pe acolo Îl huleau, clătinându-și capetele și zicând: “Tu, care ai distrus templul și l-ai zidit în trei zile, ");
INSERT INTO ronlsb_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","mântuiește-te și coboară-te de pe cruce!” ");
INSERT INTO ronlsb_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","La fel și preoții cei mai de seamă, care își băteau joc între ei împreună cu cărturarii, ziceau: “A mântuit pe alții. El nu se poate salva pe sine însuși. ");
INSERT INTO ronlsb_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Hristosul, Împăratul lui Israel, să se coboare acum de pe cruce, ca să-l vedem și să-l credem.” Cei care au fost răstigniți împreună cu el l-au insultat și ei. ");
INSERT INTO ronlsb_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Când a venit ceasul al șaselea, a fost întuneric peste toată țara până la ceasul al nouălea. ");
INSERT INTO ronlsb_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","La ceasul al nouălea, Isus a strigat cu glas tare, zicând: “Eloi, Eloi, lama sabachthani?”, ceea ce înseamnă, fiind interpretat: “Dumnezeul Meu, Dumnezeul Meu, pentru ce M-ai părăsit?” ");
INSERT INTO ronlsb_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Unii din cei ce stăteau acolo, auzind, au zis: “Iată, cheamă pe Ilie.” ");
INSERT INTO ronlsb_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Unul a alergat și, umplând un burete plin de oțet, l-a pus pe o trestie și i-a dat să bea, zicând: “Lasă-l în pace. Să vedem dacă vine Ilie să îl dea jos”. ");
INSERT INTO ronlsb_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Isus a strigat cu glas tare și și-a dat duhul. ");
INSERT INTO ronlsb_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Voalul templului s-a rupt în două, de sus până jos. ");
INSERT INTO ronlsb_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Când centurionul, care stătea vizavi de el, a văzut că a strigat așa și că și-a dat ultima suflare, a zis: “Cu adevărat, omul acesta era Fiul lui Dumnezeu!” ");
INSERT INTO ronlsb_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Erau și femei care priveau de departe, printre care Maria Magdalena, Maria, mama lui Iacov cel mic și a lui Iose și Salomeea, ");
INSERT INTO ronlsb_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","care, când era în Galileea, L-au urmat și Îi slujeau, și multe alte femei care s-au suit cu El la Ierusalim. ");
INSERT INTO ronlsb_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Și când s-a făcut seară, fiindcă era ziua pregătirii, adică ziua dinaintea Sabatului, ");
INSERT INTO ronlsb_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","a venit Iosif din Arimateea, un sfetnic de seamă, care și el însuși aștepta Împărăția lui Dumnezeu. A intrat cu îndrăzneală la Pilat și a cerut trupul lui Isus. ");
INSERT INTO ronlsb_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilat a fost surprins să audă că era deja mort; și chemând centurionul, l-a întrebat dacă era mort de mult timp. ");
INSERT INTO ronlsb_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Când a aflat de la centurion, i-a dat trupul lui Iosif. ");
INSERT INTO ronlsb_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Acesta a cumpărat o pânză de in și, coborându-l, l-a înfășurat în pânză de in și l-a pus într-un mormânt care fusese tăiat într-o stâncă. A rostogolit o piatră la ușa mormântului. ");
INSERT INTO ronlsb_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Magdalena și Maria, mama lui Iose, au văzut unde fusese pus. ");
INSERT INTO ronlsb_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","După ce a trecut Sabatul, Maria Magdalena, Maria, mama lui Iacov, și Salomeea au cumpărat miresme, ca să vină să-L ungă. ");
INSERT INTO ronlsb_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Foarte devreme, în prima zi a săptămânii, au venit la mormânt, pe când răsărise soarele. ");
INSERT INTO ronlsb_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Și ziceau între ele: “Cine va rostogoli pentru noi piatra de la ușa mormântului?” ");
INSERT INTO ronlsb_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","căci era foarte mare. Uitându-se în sus, au văzut că piatra era rostogolită. ");
INSERT INTO ronlsb_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Intrând în mormânt, au văzut un tânăr care ședea în partea dreaptă, îmbrăcat într-o haină albă, și au rămas înmărmuriți. ");
INSERT INTO ronlsb_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","El le-a zis: “Nu vă mirați. Voi îl căutați pe Isus, Nazarineanul, care a fost răstignit. El a înviat! El nu este aici. Vedeți locul unde l-au pus! ");
INSERT INTO ronlsb_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Dar mergeți și spuneți-le discipolilor săi și lui Petru: “El merge înaintea voastră în Galileea. Acolo îl veți vedea, așa cum v-a spus””.” ");
INSERT INTO ronlsb_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ei au ieșit și au fugit de la mormânt, pentru că tremurau și erau înmărmuriți. Nu au spus nimic nimănui, căci le era frică. ");
INSERT INTO ronlsb_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","În prima zi a săptămânii, când S-a sculat dis-de-dimineață, S-a arătat mai întâi Mariei Magdalena, din care scosese șapte demoni. ");
INSERT INTO ronlsb_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ea s-a dus și a anunțat pe cei care fuseseră cu El, în timp ce se jeleau și plângeau. ");
INSERT INTO ronlsb_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Când au auzit că era viu și că fusese văzut de ea, nu au crezut. ");
INSERT INTO ronlsb_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","După aceea, El s-a arătat sub o altă formă, la doi dintre ei, pe când mergeau pe jos, în drum spre țară. ");
INSERT INTO ronlsb_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ei s-au dus și au povestit celorlalți. Nici ei nu i-au crezut. ");
INSERT INTO ronlsb_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","După aceea s-a arătat celor unsprezece, pe când ședeau la masă, și i-a mustrat pentru necredința și împietrirea inimii lor, pentru că nu crezuseră pe cei ce-l văzuseră după ce înviase. ");
INSERT INTO ronlsb_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","El le-a spus: “Mergeți în toată lumea și propovăduiți Vestea cea Bună la toată creația. ");
INSERT INTO ronlsb_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Cine va crede și va fi botezat va fi mântuit, dar cine nu va crede va fi condamnat. ");
INSERT INTO ronlsb_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Aceste semne îi vor însoți pe cei care vor crede: în numele meu vor alunga demoni, vor vorbi limbi noi, ");
INSERT INTO ronlsb_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","vor lua în brațe șerpi și, dacă vor bea ceva mortal, nu le va face niciun rău, își vor pune mâinile peste bolnavi și aceștia se vor însănătoși.” ");
INSERT INTO ronlsb_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Domnul, după ce le-a vorbit, S-a înălțat la cer și a șezut la dreapta lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ei au ieșit și propovăduiau pretutindeni, Domnul lucrând cu ei și confirmând cuvântul prin semnele care urmau. Amin. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Deoarece mulți s-au încumetat să facă o relatare despre cele ce s-au împlinit printre noi, ");
INSERT INTO ronlsb_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","așa cum ni le-au transmis cei care au fost de la început martori oculari și slujitori ai cuvântului, ");
INSERT INTO ronlsb_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","mi s-a părut bine și mie, după ce am urmărit cu exactitate de la început desfășurarea tuturor lucrurilor, să-ți scriu cu rânduială, preamăritule Teofil, ");
INSERT INTO ronlsb_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ca să cunoști certitudinea lucrurilor în care ai fost instruit. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","În zilele lui Irod, împăratul Iudeii, era un preot numit Zaharia, din seminția preoțească a lui Abia. El avea o soție dintre fiicele lui Aaron, și numele ei era Elisabeta. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Amândoi erau neprihăniți înaintea lui Dumnezeu, umblând fără vină în toate poruncile și rânduielile Domnului. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Dar nu au avut niciun copil, pentru că Elisabeta era stearpă, iar ei amândoi erau înaintați în vârstă. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","În timp ce el îndeplinea slujba de preot în fața lui Dumnezeu, în ordinea împărțiriisale, ");
INSERT INTO ronlsb_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","după obiceiul slujbei de preot, îi revenea sarcina de a intra în templul Domnului și de a aduce tămâie. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Toată mulțimea poporului se ruga afară la ora tămâierii. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Și i s-a arătat un înger al Domnului, care stătea în picioare la dreapta altarului tămâiei. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zaharia s-a tulburat când l-a văzut și l-a cuprins frica. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Dar îngerul i-a zis: “Nu te teme, Zaharia, căci cererea ta a fost ascultată. Soția ta, Elisabeta, îți va naște un fiu și îi vei pune numele Ioan. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Vei avea bucurie și veselie, și mulți se vor bucura de nașterea lui. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Căci el va fi mare înaintea Domnului și nu va bea nici vin, nici băutură tare. El va fi plin de Duhul Sfânt, încă din pântecele mamei sale. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","El va întoarce pe mulți dintre copiii lui Israel la Domnul Dumnezeul lor. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","El va merge înaintea lui în spiritul și cu puterea lui Ilie, “ca să întoarcă inimile părinților la copii” și pe cei neascultători la înțelepciunea celor drepți, ca să pregătească un popor pregătit pentru Domnul.” ");
INSERT INTO ronlsb_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zaharia a zis îngerului: “Cum pot fi sigur de aceasta? Pentru că eu sunt bătrân, iar soția mea este foarte înaintată în vârstă.” ");
INSERT INTO ronlsb_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Îngerul i-a răspuns: “Eu sunt Gabriel, care stă în fața lui Dumnezeu. Am fost trimis să-ți vorbesc și să-ți aduc această veste bună. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Iată că vei tăcea și nu vei putea vorbi până în ziua în care se vor întâmpla aceste lucruri, pentru că nu ai crezut cuvintele mele, care se vor împlini la timpul lor.” ");
INSERT INTO ronlsb_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Poporul îl aștepta pe Zaharia și se mira că întârzie în templu. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Când a ieșit, nu a putut să le vorbească. Ei și-au dat seama că avusese o viziune în templu. El a continuat să le facă semne și a rămas mut. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Când s-au împlinit zilele de slujbă, a plecat la casa lui. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","După aceste zile, Elisabeta, soția sa, a rămas însărcinată și s-a ascuns cinci luni, spunând: ");
INSERT INTO ronlsb_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Așa a făcut Domnul cu mine în zilele în care s-a uitat la mine, ca să-mi îndepărteze ocara printre oameni.” ");
INSERT INTO ronlsb_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","În luna a șasea, îngerul Gabriel a fost trimis de Dumnezeu într-o cetate din Galileea, numită Nazaret, ");
INSERT INTO ronlsb_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","la o fecioară care urma să se mărite cu un bărbat numit Iosif, din casa lui David. Numele fecioarei era Maria. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","După ce a intrat, îngerul i-a spus: “Bucură-te, preaiubită! Domnul este cu tine. Binecuvântată ești tu între femei!” ");
INSERT INTO ronlsb_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Dar când l-a văzut, s-a tulburat foarte tare de această vorbă și s-a gândit ce fel de salut ar putea fi acesta. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Îngerul i-a zis: “Nu te teme, Maria, căci ai găsit bunăvoință la Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Iată că vei concepe în pântecele tău și vei da naștere unui fiu și-i vei pune numele “Isus”. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","El va fi mare și va fi numit Fiul Celui Preaînalt. Domnul Dumnezeu îi va da scaunul de domnie al tatălui său, David, ");
INSERT INTO ronlsb_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","și va domni peste casa lui Iacov pentru totdeauna. Împărăția lui nu va avea sfârșit”. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria a zis îngerului: “Cum se poate, dacă eu sunt fecioară?” ");
INSERT INTO ronlsb_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Îngerul i-a răspuns: “Duhul Sfânt va veni peste tine și puterea Celui Preaînalt te va umbri. De aceea și Sfântul care se va naște din tine se va numi Fiul lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Iată că și Elisabeta, ruda ta, a conceput un fiu la bătrânețe; și aceasta este luna a șasea cu cea care era numită stearpă. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Căci nimic din ceea ce spune Dumnezeu nu este imposibil.” ");
INSERT INTO ronlsb_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Și Maria a zis: “Iată roaba Domnului; să mi se facă după cuvântul Tău.” Apoi îngerul a plecat de la ea. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","În zilele acelea, Maria s-a sculat și s-a dus în grabă în ținutul muntos, într-o cetate din Iuda, ");
INSERT INTO ronlsb_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","a intrat în casa lui Zaharia și a salutat pe Elisabeta. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Când Elisabeta a auzit salutul Mariei, copilul a sărit în pântecele ei; și Elisabeta s-a umplut de Duhul Sfânt. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ea a strigat cu glas tare și a zis: “Binecuvântată ești tu între femei și binecuvântat este rodul pântecelui tău! ");
INSERT INTO ronlsb_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","De ce sunt eu atât de favorizată, încât mama Domnului meu să vină la mine? ");
INSERT INTO ronlsb_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Căci iată că, atunci când vocea salutului tău a ajuns la urechile mele, copilul a sărit de bucurie în pântecele meu! ");
INSERT INTO ronlsb_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Binecuvântată este cea care a crezut, pentru că se va împlini ceea ce i s-a spus de la Domnul!” ");
INSERT INTO ronlsb_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria a spus, “Sufletul meu slăvește pe Domnul. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Duhul meu s-a bucurat în Dumnezeu, Mântuitorul meu, ");
INSERT INTO ronlsb_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Căci a privit la starea umilă a robului Său. Căci iată, de acum înainte, toate generațiile mă vor numi binecuvântat. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Căci Cel ce este puternic a făcut lucruri mari pentru mine. Sfânt este numele lui. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Îndurarea Lui este din generație în generație pentru cei ce se tem de El. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","A dat dovadă de forță cu brațul. El i-a împrăștiat pe cei mândri în închipuirea inimilor lor. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","El a dat jos căpeteniile de pe tronurile lor, și i-a înălțat pe cei umili. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","El a umplut de bunătăți pe cei flămânzi. El i-a trimis pe cei bogați la plimbare cu mâna goală. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","El a ajutat pe Israel, robul Său, ca să-și aducă aminte de îndurare, ");
INSERT INTO ronlsb_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","așa cum a vorbit părinților noștri, lui Avraam și urmașilor lui în veci.” ");
INSERT INTO ronlsb_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria a stat cu ea vreo trei luni și apoi s-a întors la casa ei. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Și s-a împlinit vremea când Elisabeta trebuia să nască și a născut un fiu. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Vecinii și rudele ei au auzit că Domnul și-a mărit mila față de ea și s-au bucurat împreună cu ea. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","În ziua a opta, au venit să taie împrejur copilul; și voiau să-l numească Zaharia, după numele tatălui său. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mama lui a răspuns: “Nu așa, ci se va numi Ioan”. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ei i-au zis: “Nu este nimeni dintre rudele tale care să se numească așa.” ");
INSERT INTO ronlsb_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Și i-au făcut semne tatălui său, cum voia să-l cheme. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","A cerut o tăbliță de scris și a scris: “Numele Lui este Ioan”. Cu toții s-au mirat. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Gura i s-a deschis îndată și limba i s-a eliberat și a vorbit, binecuvântând pe Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Frica a cuprins pe toți cei care locuiau în jurul lor și toate aceste cuvinte au fost povestite în tot ținutul muntos al Iudeii. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Toți cei care le auzeau le strângeau în inima lor, spunând: “Ce va fi atunci copilul acesta?” Mâna Domnului era cu el. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zaharia, tatăl său, s-a umplut de Duhul Sfânt și a proorocit, zicând, ");
INSERT INTO ronlsb_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Binecuvântat să fie Domnul, Dumnezeul lui Israel, pentru că a vizitat și a răscumpărat pe poporul Său; ");
INSERT INTO ronlsb_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","și a ridicat pentru noi un corn de mântuire în casa robului Său David. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","(așa cum a vorbit prin gura sfinților Săi prooroci care au fost din vechime), ");
INSERT INTO ronlsb_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","mântuire de vrăjmașii noștri și din mâna tuturor celor care ne urăsc; ");
INSERT INTO ronlsb_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","pentru a arăta milă față de părinții noștri, să ne aducem aminte de legământul Său sfânt, ");
INSERT INTO ronlsb_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","jurământul pe care l-a făcut lui Avraam, tatăl nostru, ");
INSERT INTO ronlsb_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","să ne îngăduie ca noi, izbăviți din mâna vrăjmașilor noștri, ar trebui să-l slujească fără teamă, ");
INSERT INTO ronlsb_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","în sfințenie și dreptate înaintea Lui în toate zilele vieții noastre. ");
INSERT INTO ronlsb_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Și tu, copile, vei fi numit profet al Celui Preaînalt; căci tu vei merge înaintea feței Domnului, ca să-i pregătești căile, ");
INSERT INTO ronlsb_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","pentru a da cunoștință de mântuire poporului Său prin iertarea păcatelor lor, ");
INSERT INTO ronlsb_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","datorită înduratei milostiviri a Dumnezeului nostru, prin care ne va vizita zorii de sus, ");
INSERT INTO ronlsb_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","să lumineze pe cei ce stau în întuneric și în umbra morții; să ne călăuzească picioarele pe calea păcii.” ");
INSERT INTO ronlsb_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Copilul creștea și se întărea în duh și a stat în pustie până în ziua în care a apărut în fața lui Israel. ");
INSERT INTO ronlsb_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","În vremea aceea, Cezar Augustus a dat o poruncă prin care a poruncit ca toată lumea să fie înscrisă. ");
INSERT INTO ronlsb_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Aceasta a fost prima înscriere făcută când Quirinius era guvernator al Siriei. ");
INSERT INTO ronlsb_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Toți s-au dus să se înscrie, fiecare în cetatea lui. ");
INSERT INTO ronlsb_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Și Iosif s-a urcat din Galileea, din cetatea Nazaret, în Iudeea, în cetatea lui David, care se numește Betleem, pentru că era din casa și din familia lui David, ");
INSERT INTO ronlsb_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ca să se înscrie împreună cu Maria, care, fiind însărcinată, era făgăduită ca soție, pentru a se căsători cu el. ");
INSERT INTO ronlsb_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Pe când erau ei acolo, a venit ziua în care trebuia să nască. ");
INSERT INTO ronlsb_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ea a născut pe primul ei fiu născut. L-a înfășurat în benzi de pânză și l-a culcat într-o iesle, pentru că nu mai era loc pentru ei în han. ");
INSERT INTO ronlsb_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","În același ținut erau niște păstori care stăteau la câmp și vegheau noaptea asupra turmei lor. ");
INSERT INTO ronlsb_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Iată că un înger al Domnului stătea lângă ei și slava Domnului strălucea în jurul lor, și ei s-au îngrozit. ");
INSERT INTO ronlsb_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Îngerul le-a zis: “Nu vă temeți, căci iată că vă aduc o veste bună de mare bucurie, care va fi pentru tot poporul. ");
INSERT INTO ronlsb_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Căci vi s-a născut astăzi, în cetatea lui David, un Mântuitor, care este Hristos Domnul. ");
INSERT INTO ronlsb_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Iată semnul care vă este dat: veți găsi un prunc înfășurat în fâșii de pânză, culcat într-o iesle de mâncare.” ");
INSERT INTO ronlsb_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Deodată, a fost împreună cu îngerul o mulțime de oștiri cerești care lăudau pe Dumnezeu și spuneau ");
INSERT INTO ronlsb_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Slavă lui Dumnezeu în locurile prea înalte, pe pământ pace, bunăvoință față de oameni.” ");
INSERT INTO ronlsb_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Când îngerii au plecat de la ei în cer, păstorii și-au zis unul altuia: “Să mergem acum la Betleem, ca să vedem ce s-a întâmplat și ce ne-a făcut cunoscut Domnul.” ");
INSERT INTO ronlsb_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Au venit în grabă și i-au găsit pe Maria și pe Iosif, iar pruncul era culcat în iesle. ");
INSERT INTO ronlsb_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Când l-au văzut, au făcut să se răspândească pe larg cuvântul care le fusese spus despre acest copil. ");
INSERT INTO ronlsb_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Toți cei care auzeau se mirau de cele ce le spuseseră păstorii. ");
INSERT INTO ronlsb_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Dar Maria a păstrat toate aceste cuvinte, meditându-le în inima ei. ");
INSERT INTO ronlsb_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Păstorii s-au întors, slăvind și lăudând pe Dumnezeu pentru toate lucrurile pe care le auziseră și le văzuseră, așa cum le fusese spus. ");
INSERT INTO ronlsb_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","După ce s-au împlinit cele opt zile pentru tăierea împrejur a copilului, i s-a pus numele de Isus, care fusese dat de înger înainte de a fi conceput în pântece. ");
INSERT INTO ronlsb_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","După ce s-au împlinit zilele de curățire a lor, după legea lui Moise, l-au adus la Ierusalim, ca să-l prezinte Domnului ");
INSERT INTO ronlsb_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(după cum este scris în legea Domnului: “Orice bărbat care va deschide pântecele va fi numit sfânt pentru Domnul”), ");
INSERT INTO ronlsb_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","și să aducă jertfă, după cum este scris în legea Domnului: “O pereche de turturele sau doi pui de porumbel”. ");
INSERT INTO ronlsb_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Iată, era un om în Ierusalim, al cărui nume era Simeon. Omul acesta era neprihănit și evlavios, căutând mângâierea lui Israel, și Duhul Sfânt era peste el. ");
INSERT INTO ronlsb_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","I se descoperise prin Duhul Sfânt că nu avea să vadă moartea înainte de a-L vedea pe Hristosul Domnului. ");
INSERT INTO ronlsb_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","El a venit în Duhul Sfânt în templu. Când părinții au adus copilul Isus, ca să facă cu privire la el după obiceiul legii, ");
INSERT INTO ronlsb_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","el l-a primit în brațe, a binecuvântat pe Dumnezeu și a zis ");
INSERT INTO ronlsb_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Acum, Stăpâne, dai drumul robului tău, după cuvântul Tău, în pace; ");
INSERT INTO ronlsb_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Căci ochii mei au văzut mântuirea Ta, ");
INSERT INTO ronlsb_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","pe care ai pregătit-o înaintea ochilor tuturor popoarelor; ");
INSERT INTO ronlsb_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ca o lumină de revelație pentru neamuri, și slava poporului Tău Israel.” ");
INSERT INTO ronlsb_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Iosif și mama sa se mirau de cele ce se spuneau despre el. ");
INSERT INTO ronlsb_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeon i-a binecuvântat și a zis mamei sale, Maria: “Iată, copilul acesta este rânduit pentru căderea și ridicarea multora în Israel și pentru un semn despre care se vorbește. ");
INSERT INTO ronlsb_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Da, o sabie va străpunge prin sufletul vostru, ca să fie descoperite gândurile multor inimi.” ");
INSERT INTO ronlsb_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Era o proorociță, Ana, fiica lui Fanuel, din seminția lui Așer (era de o vârstă înaintată, căci trăise cu un bărbat șapte ani de la feciorie, ");
INSERT INTO ronlsb_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","și era văduvă de vreo optzeci și patru de ani), care nu se depărta de templu, închinându-se zi și noapte cu post și cu cereri. ");
INSERT INTO ronlsb_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Subind chiar în ceasul acela, ea aducea mulțumiri Domnului și vorbea despre el tuturor celor care așteptau răscumpărarea în Ierusalim. ");
INSERT INTO ronlsb_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","După ce au împlinit tot ce era după Legea Domnului, s-au întors în Galileea, în cetatea lor, Nazaret. ");
INSERT INTO ronlsb_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Copilul creștea și se întărea în spirit, fiind plin de înțelepciune, și harul lui Dumnezeu era peste el. ");
INSERT INTO ronlsb_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Părinții lui se duceau în fiecare an la Ierusalim, la sărbătoarea Paștelui. ");
INSERT INTO ronlsb_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Când a împlinit vârsta de doisprezece ani, s-au suit la Ierusalim, după obiceiul sărbătorii; ");
INSERT INTO ronlsb_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","și, după ce au împlinit zilele, pe când se întorceau, băiatul Isus a rămas în Ierusalim. Iosif și mama lui nu știau acest lucru, ");
INSERT INTO ronlsb_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","dar, presupunând că este în companie, au plecat o zi de drum; și l-au căutat printre rudele și cunoscuții lor. ");
INSERT INTO ronlsb_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Cum nu l-au găsit, s-au întors la Ierusalim, în căutarea lui. ");
INSERT INTO ronlsb_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","După trei zile, l-au găsit în templu, stând în mijlocul învățătorilor, atât pentru a-i asculta, cât și pentru a le pune întrebări. ");
INSERT INTO ronlsb_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Toți cei care îl ascultau erau uimiți de înțelegerea și de răspunsurile lui. ");
INSERT INTO ronlsb_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Când l-au văzut, au rămas uimiți, iar mama lui i-a zis: “Fiule, de ce te-ai purtat așa cu noi? Iată că tatăl tău și cu mine te așteptam cu nerăbdare”. ");
INSERT INTO ronlsb_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","El le-a zis: “Pentru ce Mă căutați? Nu știați că trebuie să fiu în casa Tatălui Meu?” ");
INSERT INTO ronlsb_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ei nu au înțeles cuvântul pe care li-l spunea. ");
INSERT INTO ronlsb_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Și, coborând cu ei, a venit la Nazaret. El era supus lor, iar mama lui păstra în inima ei toate aceste cuvinte. ");
INSERT INTO ronlsb_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Și Isus creștea în înțelepciune și în statură și în favoare înaintea lui Dumnezeu și a oamenilor. ");
INSERT INTO ronlsb_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","În al cincisprezecelea an al domniei lui Tiberiu Cezar, când Ponțiu Pilat era guvernator al Iudeii, Irod era tetrarh al Galileii, iar fratele său Filip era tetrarh al ținutului Ituraei și al Traconitei și Lisanias tetrarh al Abilenei, ");
INSERT INTO ronlsb_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","în timpul marii preoții a lui Ana și Caiafa, cuvântul lui Dumnezeu a venit lui Ioan, fiul lui Zaharia, în pustie. ");
INSERT INTO ronlsb_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","El a venit în toată regiunea din jurul Iordanului, predicând botezul pocăinței pentru iertarea păcatelor. ");
INSERT INTO ronlsb_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","După cum este scris în cartea cuvintelor profetului Isaia, “Glasul cuiva care strigă în pustiu, 'Pregătiți calea Domnului. Fă-i cărările drepte. ");
INSERT INTO ronlsb_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Orice vale va fi umplută. Fiecare munte și deal va fi doborât. Cele strâmbe vor deveni drepte, și căile aspre să fie netede. ");
INSERT INTO ronlsb_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Toată făptura va vedea mântuirea lui Dumnezeu.” ");
INSERT INTO ronlsb_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","De aceea a zis mulțimilor care ieșeau să fie botezate de El: “Neam de vipere, cine v-a pus în gardă să fugiți de mânia viitoare? ");
INSERT INTO ronlsb_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","De aceea, dați roade demne de pocăință și nu începeți să spuneți între voi: “Avem ca tată pe Avraam!” Căci vă spun că Dumnezeu poate să-i ridice lui Avraam copii din aceste pietre!”. ");
INSERT INTO ronlsb_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Chiar și acum toporul se află la rădăcina copacilor. Așadar, orice copac care nu produce fructe bune este tăiat și aruncat în foc.” ");
INSERT INTO ronlsb_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Și mulțimile L-au întrebat: “Ce trebuie să facem?” ");
INSERT INTO ronlsb_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","El le-a răspuns: “Cine are două haine, să le dea celui care nu are. Cine are de mâncare, să facă la fel.” ");
INSERT INTO ronlsb_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Au venit și vameșii să fie botezați și I-au zis: “Învățătorule, ce trebuie să facem?” ");
INSERT INTO ronlsb_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","El le-a zis: “Nu culegeți mai mult decât ceea ce vi se cuvine”. ");
INSERT INTO ronlsb_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Și soldații l-au întrebat și ei: “Și noi? Ce trebuie să facem noi?” El le-a spus: “Nu luați de la nimeni prin violență și nu acuzați pe nimeni pe nedrept. Fiți mulțumiți cu salariile voastre”. ");
INSERT INTO ronlsb_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Pe când norodul era în așteptare și toți oamenii se gândeau în inimile lor dacă nu cumva Ioan este Hristosul, ");
INSERT INTO ronlsb_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ioan le-a răspuns tuturor: “Eu vă botez cu apă, dar vine Cel mai puternic decât mine, căruia nu sunt vrednic să-i dezleg cureaua sandalelor. El vă va boteza în Duhul Sfânt și în foc. ");
INSERT INTO ronlsb_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","În mâna Lui este vânturatorul, va curăța bine aria și va strânge grâul în hambarul Său, dar va arde neghina cu foc nestins.” ");
INSERT INTO ronlsb_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Apoi, cu multe alte îndemnuri, propovăduia poporului vestea cea bună. ");
INSERT INTO ronlsb_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Dar Irod tetrarhul, fiind mustrat de el pentru Irodiada, soția fratelui său, și pentru toate relele pe care le făcuse Irod, ");
INSERT INTO ronlsb_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","a adăugat la toate acestea și aceasta: a închis pe Ioan în temniță. ");
INSERT INTO ronlsb_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Și când tot poporul era botezat, Isus, botezat și el, se ruga. Cerul s-a deschis ");
INSERT INTO ronlsb_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","și Duhul Sfânt s-a pogorât peste el în chip trupesc, ca un porumbel, iar din cer s-a auzit un glas care zicea: “Tu ești Fiul Meu preaiubit. În tine sunt binevoitor”. ");
INSERT INTO ronlsb_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Isus însuși, când a început să învețe, era în vârstă de vreo treizeci de ani, fiind fiul lui Iosif, fiul lui Heli, ");
INSERT INTO ronlsb_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","fiul lui Matei, fiul lui Levi, fiul lui Melchi, fiul lui Jannai, fiul lui Iosif, ");
INSERT INTO ronlsb_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","fiul lui Matatia, fiul lui Amos, fiul lui Naum, fiul lui Esli, fiul lui Naggai, ");
INSERT INTO ronlsb_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","fiul lui Maat, fiul lui Matatia, fiul lui Semein, fiul lui Iosif, fiul lui Iuda, ");
INSERT INTO ronlsb_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","fiul lui Joanan, fiul lui Reșea, fiul lui Zorobabel, fiul lui Șealtiel, fiul lui Neri, ");
INSERT INTO ronlsb_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","fiul lui Melchi, fiul lui Addi, fiul lui Cosam, fiul lui Elmodam, fiul lui Er, ");
INSERT INTO ronlsb_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","fiul lui Iosif, fiul lui Eliezer, fiul lui Jorim, fiul lui Matei, fiul lui Levi, ");
INSERT INTO ronlsb_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","fiul lui Simeon, fiul lui Iuda, fiul lui Iosif, fiul lui Iona, fiul lui Eliachim, ");
INSERT INTO ronlsb_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","fiul lui Melea, fiul lui Menan, fiul lui Matata, fiul lui Natan, fiul lui David, ");
INSERT INTO ronlsb_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","fiul lui Isai, fiul lui Obed, fiul lui Boaz, fiul lui Salmon, fiul lui Nahșon, ");
INSERT INTO ronlsb_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","fiul lui Aminadab, fiul lui Aram, fiul lui Hezron, fiul lui Pereț, fiul lui Iuda, ");
INSERT INTO ronlsb_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","fiul lui Iacov, fiul lui Isaac, fiul lui Avraam, fiul lui Terah, fiul lui Nahor, ");
INSERT INTO ronlsb_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","fiul lui Serug, fiul lui Reu, fiul lui Peleg, fiul lui Eber, fiul lui Șelah, ");
INSERT INTO ronlsb_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","fiul lui Cainan, fiul lui Arfaxad, fiul lui Sem, fiul lui Noe, fiul lui Lameh, ");
INSERT INTO ronlsb_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","fiul lui Matusalem, fiul lui Enoh, fiul lui Iared, fiul lui Mahalaleel, fiul lui Cainan, ");
INSERT INTO ronlsb_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","fiul lui Enos, fiul lui Set, fiul lui Adam, fiul lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Isus, plin de Duhul Sfânt, s-a întors de la Iordan și a fost dus de Duhul în pustiu ");
INSERT INTO ronlsb_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","timp de patruzeci de zile, fiind ispitit de diavol. În acele zile nu a mâncat nimic. După aceea, când acestea s-au încheiat, i-a fost foame. ");
INSERT INTO ronlsb_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Diavolul I-a zis: “Dacă ești Fiul lui Dumnezeu, poruncește ca piatra aceasta să se facă pâine.” ");
INSERT INTO ronlsb_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Isus i-a răspuns: “Este scris: “Nu numai cu pâine va trăi omul, ci cu orice cuvânt al lui Dumnezeu.”” ");
INSERT INTO ronlsb_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Diavolul, ducându-l pe un munte înalt, i-a arătat într-o clipă toate împărățiile lumii. ");
INSERT INTO ronlsb_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Diavolul i-a zis: “Îți voi da toate aceste autorități și slava lor, căci mi-au fost date mie și le dau oricui vreau. ");
INSERT INTO ronlsb_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Așadar, dacă te vei închina înaintea mea, toate acestea vor fi ale tale.” ");
INSERT INTO ronlsb_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Isus i-a răspuns: “Du-te de aici, Satano! Căci este scris: “Să te închini Domnului, Dumnezeului tău, și numai lui să-i slujești!”. ");
INSERT INTO ronlsb_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","L-a dus la Ierusalim, l-a așezat pe vârful templului și i-a zis: “Dacă ești Fiul lui Dumnezeu, aruncă-te jos de aici, ");
INSERT INTO ronlsb_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","căci este scris, “El va pune pe îngerii Săi să vă păzească, ca să vă păzească. ");
INSERT INTO ronlsb_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","și, 'Pe mâinile lor te vor purta, ca nu cumva să-ți lovești piciorul de o piatră.”” ");
INSERT INTO ronlsb_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Isus, răspunzând, i-a zis: “S-a spus: “Să nu ispitești pe Domnul Dumnezeul tău”.” ");
INSERT INTO ronlsb_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","După ce a ispitit pe toți, diavolul a plecat de la el până la o altă dată. ");
INSERT INTO ronlsb_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Isus s-a întors în Galileea cu puterea Duhului Sfânt, și vestea despre El s-a răspândit în tot ținutul din jur. ");
INSERT INTO ronlsb_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","El învăța în sinagogile lor, fiind slăvit de toți. ");
INSERT INTO ronlsb_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Și a venit la Nazaret, unde fusese crescut. A intrat, după obiceiul său, în sinagogă, în ziua de Sabat, și s-a ridicat în picioare să citească. ");
INSERT INTO ronlsb_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","I s-a înmânat cartea profetului Isaia. A deschis cartea și a găsit locul în care era scris, ");
INSERT INTO ronlsb_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Duhul Domnului este peste mine, pentru că El m-a uns să vestesc săracilor vestea cea bună. El m-a trimis să-i vindec pe cei cu inimazdrobită, pentru a vesti eliberarea celor prizonieri, redarea vederii orbilor, pentru a-i elibera pe cei care sunt zdrobiți, ");
INSERT INTO ronlsb_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","și să vestească anul de grație al Domnului.” ");
INSERT INTO ronlsb_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","A închis cartea, a dat-o înapoi slujbașului și s-a așezat. Ochii tuturor celor din sinagogă erau ațintiți asupra lui. ");
INSERT INTO ronlsb_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","El a început să le spună: “Astăzi s-a împlinit în auzul vostru Scriptura aceasta.” ");
INSERT INTO ronlsb_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Toți mărturiseau despre el și se mirau de cuvintele pline de har care ieșeau din gura lui și ziceau: “Nu este acesta fiul lui Iosif?” ");
INSERT INTO ronlsb_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","El le-a zis: “Fără îndoială că îmi veți spune proverbul acesta: “Doctore, vindecă-te! Tot ce am auzit că s-a făcut în Capernaum, fă și aici, în orașul tău natal!””. ");
INSERT INTO ronlsb_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","El a zis: “Adevărat vă spun că niciun profet nu este acceptat în orașul său natal. ");
INSERT INTO ronlsb_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Dar, adevărat vă spun că erau multe văduve în Israel pe vremea lui Ilie, când cerul a fost închis trei ani și șase luni, când a venit o foamete mare în toată țara. ");
INSERT INTO ronlsb_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ilie nu a fost trimis la niciuna dintre ele, decât la Sarepta, în ținutul Sidonului, la o femeie văduvă. ");
INSERT INTO ronlsb_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Pe vremea profetului Elisei, în Israel, erau mulți leproși, dar niciunul dintre ei nu a fost curățat, cu excepția lui Naaman, sirianul.” ");
INSERT INTO ronlsb_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Toți s-au umplut de mânie în sinagogă, când auzeau aceste lucruri. ");
INSERT INTO ronlsb_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","S-au sculat, l-au aruncat afară din cetate și l-au dus pe vârful dealului pe care era zidită cetatea lor, ca să-l arunce de pe stâncă. ");
INSERT INTO ronlsb_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Dar el, trecând prin mijlocul lor, și-a văzut de drum. ");
INSERT INTO ronlsb_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","S-a coborât la Capernaum, o cetate din Galileea. Îi învăța în ziua de Sabat; ");
INSERT INTO ronlsb_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","și ei erau uimiți de învățătura Lui, căci cuvântul Lui era cu autoritate. ");
INSERT INTO ronlsb_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","În sinagogă era un om care avea un duh de demon necurat; și a strigat cu glas tare, ");
INSERT INTO ronlsb_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","zicând: “Ah! ce avem noi de-a face cu tine, Isus din Nazaret? Ai venit să ne distrugi? Eu știu cine ești: Sfântul lui Dumnezeu!”. ");
INSERT INTO ronlsb_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Isus l-a mustrat, zicând: “Taci și ieși de la el!” După ce l-a aruncat jos în mijlocul lor, demonul a ieșit din el, fără să-i facă vreun rău. ");
INSERT INTO ronlsb_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Toți au fost cuprinși de uimire și vorbeau între ei, zicând: “Ce este cuvântul acesta? Pentru că el poruncește cu autoritate și putere duhurilor necurate și ele ies!” ");
INSERT INTO ronlsb_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Vestea despre el s-a răspândit în toate locurile din regiunea înconjurătoare. ");
INSERT INTO ronlsb_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","S-a sculat din sinagogă și a intrat în casa lui Simon. Soacra lui Simon era bolnavă de o febră mare și l-au rugat să o ajute. ");
INSERT INTO ronlsb_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","El a stat lângă ea și a mustrat febra, iar aceasta a lăsat-o. Imediat s-a sculat și i-a servit. ");
INSERT INTO ronlsb_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Pe când apunea soarele, toți cei care aveau pe cineva bolnav de diferite boli i-au adus la el; el și-a pus mâinile peste fiecare dintre ei și i-a vindecat. ");
INSERT INTO ronlsb_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Din mulți ieșeau și demoni, care strigau și ziceau: “Tu ești Hristosul, Fiul lui Dumnezeu!” Reproșându-le, nu le-a permis să vorbească, pentru că știau că el era Hristosul. ");
INSERT INTO ronlsb_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Când s-a făcut ziuă, a plecat și s-a dus într-un loc pustiu; și mulțimile Îl căutau, veneau la El și se țineau de El, ca să nu plece de lângă ele. ");
INSERT INTO ronlsb_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Dar el le-a spus: “Trebuie să propovăduiesc vestea bună a Împărăției lui Dumnezeu și în celelalte cetăți. De aceea am fost trimis”. ");
INSERT INTO ronlsb_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","El predica în sinagogile din Galileea. ");
INSERT INTO ronlsb_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Și, pe când mulțimea îl strângea și asculta cuvântul lui Dumnezeu, el stătea lângă lacul Ghenareț. ");
INSERT INTO ronlsb_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","A văzut două corăbii care stăteau lângă lac, dar pescarii ieșiseră din ele și își spălau plasele. ");
INSERT INTO ronlsb_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","A intrat într-una dintre bărci, care era a lui Simon, și l-a rugat să se depărteze puțin de țărm. S-a așezat și a învățat mulțimile din barcă. ");
INSERT INTO ronlsb_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","După ce a isprăvit de vorbit, a zis lui Simon: “Scoateți în larg și aruncați mrejele ca să prindeți.” ");
INSERT INTO ronlsb_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon I-a răspuns: “Învățătorule, am lucrat toată noaptea și n-am prins nimic; dar, la cuvântul Tău, voi da drumul la mreajă.” ");
INSERT INTO ronlsb_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","După ce au făcut acest lucru, au prins o mare mulțime de pești, iar plasa lor se rupea. ");
INSERT INTO ronlsb_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ei au făcut semn partenerilor lor din cealaltă barcă să vină să-i ajute. Aceștia au venit și au umplut ambele bărci, astfel încât acestea au început să se scufunde. ");
INSERT INTO ronlsb_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Dar Simon Petru, când a văzut, a căzut la genunchii lui Isus și a zis: “Doamne, depărtează-te de la mine, căci sunt un om păcătos!”. ");
INSERT INTO ronlsb_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Căci era uimit, el și toți cei care erau cu el, de capturile de pește pe care le prinseseră; ");
INSERT INTO ronlsb_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","la fel și Iacov și Ioan, fiii lui Zebedei, care erau asociați cu Simon. Isus i-a spus lui Simon: “Nu te teme. De acum înainte vei prinde oameni vii”. ");
INSERT INTO ronlsb_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","După ce și-au adus corăbiile la țărm, au lăsat totul și au mers după El. ");
INSERT INTO ronlsb_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Pe când era într-una din cetăți, iată că era un om plin de lepră. Când L-a văzut pe Isus, a căzut cu fața la pământ și L-a implorat, zicând: “Doamne, dacă vrei, poți să mă cureți.” ");
INSERT INTO ronlsb_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","El a întins mâna și l-a atins, zicând: “Vreau. Să fiu curățat”. Imediat lepra l-a părăsit. ");
INSERT INTO ronlsb_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","I-a poruncit să nu spună nimănui: “Ci du-te, arată-te preotului și adu jertfă pentru curățirea ta, după cum a poruncit Moise, ca mărturie pentru ei.” ");
INSERT INTO ronlsb_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Dar vestea despre El s-a răspândit mult mai mult și mulțimi mari se adunau să-L asculte și să fie vindecate de bolile lor. ");
INSERT INTO ronlsb_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Dar el s-a retras în pustie și se ruga. ");
INSERT INTO ronlsb_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Într-una din zilele acelea, El învăța pe oameni; și stăteau acolo farisei și învățători ai Legii, veniți din toate satele Galileii, din Iudeea și din Ierusalim. Puterea Domnului era cu el ca să-i vindece. ");
INSERT INTO ronlsb_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Iată că niște oameni au adus un paralitic pe un pat de campanie și căutau să-l aducă înăuntru ca să-l pună înaintea lui Isus. ");
INSERT INTO ronlsb_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Nu au găsit cum să-l aducă înăuntru din cauza mulțimii, s-au urcat pe acoperișul casei și l-au coborât prin țigle cu patul lui în mijlocul ei, în fața lui Isus. ");
INSERT INTO ronlsb_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Văzând credința lor, Isus i-a spus: “Omule, păcatele tale îți sunt iertate.” ");
INSERT INTO ronlsb_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Cărturarii și fariseii au început să se certe, zicând: “Cine este acesta care vorbește de hulă? Cine poate ierta păcatele, dacă nu numai Dumnezeu?” ");
INSERT INTO ronlsb_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Dar Isus, înțelegând gândurile lor, le-a răspuns: “De ce gândiți așa în inimile voastre? ");
INSERT INTO ronlsb_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ce este mai ușor să spui: “Păcatele tale îți sunt iertate” sau să spui: “Scoală-te și umblă”? ");
INSERT INTO ronlsb_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Dar ca să știți că Fiul Omului are putere pe pământ să ierte păcatele”, i-a spus paraliticului: “Îți spun: scoală-te, ia-ți patul și du-te la casa ta”. ");
INSERT INTO ronlsb_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Și îndată s-a sculat în fața lor, a luat ce avea pe el și a plecat la casa lui, slăvind pe Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Toată lumea a fost cuprinsă de uimire și a slăvit pe Dumnezeu. S-au umplut de teamă, spunând: “Am văzut astăzi lucruri ciudate.” ");
INSERT INTO ronlsb_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","După aceea, ieșind afară, a văzut un vameș, numit Levi, care ședea la fisc, și i-a zis: “Vino după mine!” ");
INSERT INTO ronlsb_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","A lăsat totul, s-a sculat și l-a urmat. ");
INSERT INTO ronlsb_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Levi i-a făcut un mare ospăț în casa lui. Era o mare mulțime de vameși și de alți oameni care se odihneau cu ei. ");
INSERT INTO ronlsb_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Cărturarii și fariseii cârteau împotriva ucenicilor Lui, zicând: “De ce mâncați și beți cu vameșii și cu păcătoșii?” ");
INSERT INTO ronlsb_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Isus le-a răspuns: “Cei sănătoși nu au nevoie de doctor, dar cei bolnavi au nevoie de doctor. ");
INSERT INTO ronlsb_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Eu n-am venit să chem pe cei drepți, ci pe păcătoși la pocăință.” ");
INSERT INTO ronlsb_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ei I-au zis: “Pentru ce ucenicii lui Ioan postesc și se roagă des, și ucenicii fariseilor, iar ai voștri mănâncă și beau?” ");
INSERT INTO ronlsb_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","El le-a zis: “Puteți voi să faceți pe prietenii mirelui să postească, când mirele este cu ei? ");
INSERT INTO ronlsb_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Dar vor veni zile când mirele va fi luat de la ei. Atunci vor posti în acele zile.” ");
INSERT INTO ronlsb_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Și le-a spus și o pildă. “Nimeni nu pune o bucată dintr-o haină nouă pe o haină veche, căci altfel va rupe haina nouă și, de asemenea, bucata din haina nouă nu se va potrivi cu cea veche. ");
INSERT INTO ronlsb_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nimeni nu pune vin nou în piei de vin vechi, căci altfel vinul nou va sparge piei, se va vărsa și piei vor fi distruse. ");
INSERT INTO ronlsb_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Dar vinul nou trebuie pus în piei de vin proaspăt, și amândouă se păstrează. ");
INSERT INTO ronlsb_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nimeni, după ce a băut vin vechi, nudorește imediat vin nou, pentru că spune: “Cel vechi este mai bun”.” ");
INSERT INTO ronlsb_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","În al doilea Sabat după cel dintâi, el mergea prin lanurile de grâu. Discipolii lui culegeau căpățânile de grâu și mâncau, frecându-le în mâini. ");
INSERT INTO ronlsb_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Dar unii dintre farisei le-au spus: “De ce faceți ceea ce nu este permis să faceți în ziua de Sabat?” ");
INSERT INTO ronlsb_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Isus le-a răspuns: “N-ați citit ce a făcut David, când a flămânzit, el și cei ce erau cu el, ");
INSERT INTO ronlsb_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","cum a intrat în casa lui Dumnezeu, a luat și a mâncat pâinea de sărbătoare și a dat și celor ce erau cu el, care nu se poate mânca decât numai pentru preoți?” ");
INSERT INTO ronlsb_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","El le-a răspuns: “Fiul Omului este stăpânul Sabatului”. ");
INSERT INTO ronlsb_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","În altă zi de Sabat, a intrat în sinagogă și învăța. Era acolo un om, căruia i se uscase mâna dreaptă. ");
INSERT INTO ronlsb_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Cărturarii și fariseii îl urmăreau, ca să vadă dacă nu cumva vindecă în Sabat, ca să găsească o acuzație împotriva lui. ");
INSERT INTO ronlsb_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Dar El le cunoștea gândurile; și a zis omului care avea mâna uscată: “Ridică-te și stai în mijloc”. El s-a ridicat și a stat în picioare. ");
INSERT INTO ronlsb_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Atunci Isus le-a zis: “Vă voi întreba ceva: “Este îngăduit în Sabat să faci bine sau să faci rău? Să salvezi o viață, sau să ucizi?” ");
INSERT INTO ronlsb_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","S-a uitat la toți și a zis omului: “Întinde-ți mâna”. El a făcut-o, și mâna i-a fost redată la fel de sănătoasă ca și cealaltă. ");
INSERT INTO ronlsb_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Dar ei erau plini de furie și vorbeau între ei despre ce ar putea să-i facă lui Isus. ");
INSERT INTO ronlsb_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","În zilele acelea, s-a dus pe munte să se roage și a stat toată noaptea în rugăciune către Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Când s-a făcut ziuă, și-a chemat discipolii și a ales dintre ei doisprezece, pe care i-a numit și apostoli: ");
INSERT INTO ronlsb_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon, pe care l-a numit și Petru; Andrei, fratele său; Iacov; Ioan; Filip; Bartolomeu; ");
INSERT INTO ronlsb_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matei; Toma; Iacov, fiul lui Alfeu; Simon, numit Zelota; ");
INSERT INTO ronlsb_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Iuda, fiul lui Iacov; și Iuda Iscarioteanul, care a devenit și el trădător. ");
INSERT INTO ronlsb_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","S-a coborât cu ei și a stat pe un loc drept, cu o mulțime de ucenici ai Lui și cu un mare număr de oameni din toată Iudeea, din Ierusalim și de pe țărmul mării Tirului și al Sidonului, care veniseră să-L asculte și să se vindece de bolile lor, ");
INSERT INTO ronlsb_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","precum și de cei care erau tulburați de duhuri necurate; și se vindecau. ");
INSERT INTO ronlsb_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Toată mulțimea căuta să se atingă de El, căci ieșea din El o putere și îi vindeca pe toți. ");
INSERT INTO ronlsb_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Și-a ridicat ochii spre ucenicii Săi și a zis: “Ferice de voi, cei săraci! pentru că Împărăția lui Dumnezeu este a ta. ");
INSERT INTO ronlsb_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ferice de voi, care sunteți flămânzi acum! pentru că vei fi umplut. Ferice de voi care plângeți acum, pentru că vei râde. ");
INSERT INTO ronlsb_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ferice de voi, când vă vor urî oamenii, când vă vor respinge, când vă vor batjocori și când vor arunca numele vostru ca fiind rău, din pricina Fiului Omului! ");
INSERT INTO ronlsb_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Bucurați-vă în ziua aceea și săriți de bucurie, căci iată că răsplata voastră este mare în ceruri, pentru că părinții lor au făcut același lucru cu profeții. ");
INSERT INTO ronlsb_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Dar vai de voi, care sunteți bogați! Căci ați primit mângâierea voastră. ");
INSERT INTO ronlsb_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Vai de voi, cei ce sunteți plini acum! pentru că vă va fi foame. Vai de voi care râdeți acum, pentru că veți jeli și veți plânge. ");
INSERT INTO ronlsb_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Vai, când oamenii vorbesc de bine despre tine! căci părinții lor au făcut același lucru cu profeții mincinoși. ");
INSERT INTO ronlsb_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Dar Eu vă spun vouă, celor ce auziți: iubiți pe vrăjmașii voștri, faceți bine celor ce vă urăsc, ");
INSERT INTO ronlsb_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","binecuvântați pe cei ce vă blestemă și rugați-vă pentru cei ce vă maltratează. ");
INSERT INTO ronlsb_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Celui ce vă lovește peste obraz, oferiți-i și celălalt obraz; și celui ce vă ia haina, nu-i reține și haina. ");
INSERT INTO ronlsb_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Dați oricui vă cere și nu cereți celui care vă ia bunurile să vi le dea înapoi. ");
INSERT INTO ronlsb_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","“Fă-le și tu cum vrei să facă oamenii cu tine. ");
INSERT INTO ronlsb_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Dacă iubești pe cei ce te iubesc, ce merite ai tu? Căci chiar și păcătoșii îi iubesc pe cei care îi iubesc. ");
INSERT INTO ronlsb_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Dacă faceți bine celor ce vă fac bine, ce merite aveți voi? Căci și păcătoșii fac la fel. ");
INSERT INTO ronlsb_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Dacă dați cu împrumut celor de la care sperați să primiți, ce merite aveți? Chiar și păcătoșii împrumută păcătoșilor, pentru a primi înapoi la fel de mult. ");
INSERT INTO ronlsb_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Dar iubiți pe vrăjmașii voștri, faceți binele și împrumutați, fără să așteptați nimic în schimb; și răsplata voastră va fi mare și veți fi copiii Celui Preaînalt, căci El este binevoitor față de cei nerecunoscători și răi. ");
INSERT INTO ronlsb_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","“De aceea fiți milostivi, așa cum și Tatăl vostru este milostiv. ");
INSERT INTO ronlsb_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Nu judecați, și nu vei fi judecat. Nu condamnați, și nu vei fi condamnat. Eliberați, și vei fi eliberat. ");
INSERT INTO ronlsb_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","“Dați și vi se va da; o măsură bună, presată, zdruncinată și plină, vi se va da. Căci cu aceeași măsură cu care măsurați, vi se va măsura înapoi.” ");
INSERT INTO ronlsb_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Și le-a spus o pildă. “Poate orbul să călăuzească pe orb? Nu vor cădea amândoi într-o groapă? ");
INSERT INTO ronlsb_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Un ucenic nu este mai presus de învățătorul său, dar fiecare, când va fi pe deplin instruit, va fi ca învățătorul său. ");
INSERT INTO ronlsb_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","De ce vedeți paiul de paie care este în ochiul fratelui vostru, dar nu vă gândiți la bârna care este în ochiul vostru? ");
INSERT INTO ronlsb_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Sau cum poți să-i spui fratelui tău: “Frate, lasă-mă să scot paiul din ochiul tău”, când tu însuți nu vezi bârna care este în ochiul tău? Ipocritule! Îndepărtează mai întâi bârna din ochiul tău și apoi vei putea vedea limpede ca să îndepărtezi paiul care este în ochiul fratelui tău. ");
INSERT INTO ronlsb_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Căci nu este pom bun care să dea roade putrede, nici pom putred care să dea roade bune. ");
INSERT INTO ronlsb_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Căci fiecare pom se cunoaște după rodul său. Căci oamenii nu culeg smochine din spini, nici struguri din tufișuri de mărăcini. ");
INSERT INTO ronlsb_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Omul bun scoate din comoara bună a inimii sale ceea ce este bun, iar omul rău scoate din comoara rea a inimii sale ceea ce este rău, căci din belșugul inimii vorbește gura lui. ");
INSERT INTO ronlsb_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Pentru ce Mă strigați: “Doamne, Doamne!” și nu faceți ce vă spun Eu? ");
INSERT INTO ronlsb_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Oricine vine la Mine, care ascultă cuvintele Mele și le face, vă voi arăta cum este el. ");
INSERT INTO ronlsb_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","El este ca un om care construiește o casă, care a săpat, a mers adânc și a pus temelia pe stâncă. Când s-a ridicat un potop, pârâul s-a izbit de casa aceea și nu a putut să o zdruncine, pentru că era întemeiată pe stâncă. ");
INSERT INTO ronlsb_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Darcel care aude și nu face, se aseamănă cu un om care a zidit o casă pe pământ fără temelie, împotriva căreia a izbucnit pârâul și îndată a căzut; și ruina acelei case a fost mare.” ");
INSERT INTO ronlsb_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","După ce a terminat de vorbit în auzul poporului, a intrat în Capernaum. ");
INSERT INTO ronlsb_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Un slujitor al unui centurion, care îi era foarte drag, era bolnav și era la un pas de moarte. ");
INSERT INTO ronlsb_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Când a auzit despre Isus, a trimis la el pe bătrânii iudeilor, rugându-l să vină și să-i salveze slujitorul. ");
INSERT INTO ronlsb_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Când au ajuns la Isus, l-au rugat insistent, spunând: “Este vrednic ca tu să faci asta pentru el, ");
INSERT INTO ronlsb_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","pentru că el iubește neamul nostru și a zidit sinagoga noastră pentru noi”. ");
INSERT INTO ronlsb_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Isus a mers cu ei. Când nu mai era acum departe de casă, centurionul a trimis la el niște prieteni, spunându-i: “Doamne, nu te îngrijora, căci nu sunt vrednic să intri sub acoperișul meu. ");
INSERT INTO ronlsb_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","De aceea nici eu nu m-am considerat vrednic să vin la tine; dar spune cuvântul și robul meu va fi vindecat. ");
INSERT INTO ronlsb_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Căci și eu sunt un om pus sub autoritate, având sub mine soldați. Îi spun acestuia: “Du-te!” și el se duce; altuia: “Vino!” și vine; iar robului meu: “Fă aceasta” și el o face”.” ");
INSERT INTO ronlsb_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Isus, auzind acestea, s-a mirat de el și, întorcându-se, a zis mulțimii care-L urma: “Vă spun că n-am găsit o credință atât de mare, nici în Israel.” ");
INSERT INTO ronlsb_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Cei care fuseseră trimiși, întorcându-se la casă, au constatat că servitorul care fusese bolnav era sănătos. ");
INSERT INTO ronlsb_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Curând după aceea, s-a dus într-o cetate numită Nain. Mulți dintre discipolii Săi, împreună cu o mare mulțime, au mers cu El. ");
INSERT INTO ronlsb_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Când s-a apropiat de poarta cetății, iată că a fost dus afară un mort, singurul fiu născut al mamei sale, care era văduvă. Mulți oameni din cetate erau cu ea. ");
INSERT INTO ronlsb_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Domnul, când a văzut-o, i s-a făcut milă de ea și i-a zis: “Nu plânge!” ");
INSERT INTO ronlsb_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","S-a apropiat și s-a atins de sicriu, iar purtătorii s-au oprit. El a spus: “Tinere, îți spun: ridică-te!”. ");
INSERT INTO ronlsb_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Cel care era mort s-a așezat și a început să vorbească. Apoi l-a dat mamei sale. ");
INSERT INTO ronlsb_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Toți s-au temut și au slăvit pe Dumnezeu, zicând: “Un mare prooroc s-a ridicat printre noi!” și: “Dumnezeu a vizitat pe poporul Său!”. ");
INSERT INTO ronlsb_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Această veste s-a răspândit despre el în toată Iudeea și în toată regiunea înconjurătoare. ");
INSERT INTO ronlsb_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ucenicii lui Ioan i-au povestit toate acestea. ");
INSERT INTO ronlsb_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ioan, chemând la el doi dintre ucenicii săi, i-a trimis la Isus, zicând: “Tu ești Cel ce vine, sau trebuie să căutăm pe altul?” ");
INSERT INTO ronlsb_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","După ce au venit la el, au spus: “Ioan Botezătorul ne-a trimis la tine, spunând: “Tu ești cel care vine, sau trebuie să căutăm pe altul?”” ");
INSERT INTO ronlsb_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","În ceasul acela a vindecat pe mulți de boli, de molime și de duhuri rele, și multora dintre cei orbi le-a dat vederea. ");
INSERT INTO ronlsb_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Isus le-a răspuns: “Duceți-vă și spuneți lui Ioan lucrurile pe care le-ați văzut și le-ați auzit: că orbii își primesc vederea, șchiopii umblă, leproșii sunt curățiți, surzii aud, morții înviază și săracilor li se vestește o veste bună. ");
INSERT INTO ronlsb_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ferice de cel care nu găsește în mine nici un prilej de poticnire.” ");
INSERT INTO ronlsb_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","După ce au plecat trimișii lui Ioan, a început să spună mulțimii despre Ioan: “Ce ați ieșit în pustie ca să vedeți? O trestie scuturată de vânt? ");
INSERT INTO ronlsb_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Dar voi ce ați ieșit să vedeți? Un om îmbrăcat în haine moi? Iată, cei care sunt îmbrăcați frumos și trăiesc delicat sunt la curțile regilor. ");
INSERT INTO ronlsb_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Dar tu ce ai ieșit să vezi? Un profet? Da, vă spun, și chiar mai mult decât un profet. ");
INSERT INTO ronlsb_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Acesta este cel despre care este scris, “Iată, trimit pe mesagerul Meu înaintea feței tale, care îți va pregăti calea înaintea ta. ");
INSERT INTO ronlsb_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Căci vă spun că, dintre cei născuți din femei, nu este un prooroc mai mare decât Ioan Botezătorul; dar cel mai mic în Împărăția lui Dumnezeu este mai mare decât el.” ");
INSERT INTO ronlsb_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Când a auzit aceasta, tot poporul și vameșii au declarat că Dumnezeu este drept, după ce a fost botezat cu botezul lui Ioan. ");
INSERT INTO ronlsb_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Dar fariseii și avocații au respins sfatul lui Dumnezeu, nefiind ei înșiși botezați de el. ");
INSERT INTO ronlsb_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Cu ce aș putea să compar pe oamenii acestui neam? Cu ce se aseamănă ei? ");
INSERT INTO ronlsb_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Sunt ca niște copii care stau în piață și se strigă unii pe alții, zicând: “Noi v-am cântat la cimpoi, și voi n-ați dansat”. Noi am jelit, iar voi nu ați plâns'. ");
INSERT INTO ronlsb_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Căci Ioan Botezătorul n-a venit nici mâncând pâine, nici bând vin, iar voi spuneți: 'Are un demon'. ");
INSERT INTO ronlsb_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Fiul Omului a venit mâncând și bând și voi ziceți: 'Iată un mâncăcios și un bețiv, un prieten al vameșilor și al păcătoșilor!'. ");
INSERT INTO ronlsb_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Înțelepciunea este îndreptățită de toți copiii ei.” ");
INSERT INTO ronlsb_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Unul dintre farisei l-a invitat să mănânce cu el. El a intrat în casa fariseului și s-a așezat la masă. ");
INSERT INTO ronlsb_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Iată că o femeie din cetate, care era păcătoasă, când a aflat că el se odihnește în casa fariseului, a adus un vas de alabastru cu unguent. ");
INSERT INTO ronlsb_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Stând în spate la picioarele lui, plângând, a început să îi ude picioarele cu lacrimile ei, le-a șters cu părul capului, i-a sărutat picioarele și le-a uns cu mirul. ");
INSERT INTO ronlsb_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Fariseul care îl invitase, văzând aceasta, și-a zis în sinea lui: “Omul acesta, dacă ar fi fost profet, și-ar fi dat seama cine și ce fel de femeie este cea care îl atinge, că este o păcătoasă.” ");
INSERT INTO ronlsb_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Isus i-a răspuns: “Simon, am să-ți spun ceva.” El a spus: “Învățătorule, spune mai departe”. ");
INSERT INTO ronlsb_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Un creditor avea doi datornici. Unul datora cinci sute de denari, iar celălalt cincizeci. ");
INSERT INTO ronlsb_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Când n-au putut plăti, i-a iertat pe amândoi. Așadar, care dintre ei îl va iubi mai mult?” ");
INSERT INTO ronlsb_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon a răspuns: “Cred că pe acela pe care l-a iertat cel mai mult.” El i-a spus: “Ai judecat corect”. ");
INSERT INTO ronlsb_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Și, întorcându-se spre femeie, i-a zis lui Simon: “Vezi tu pe femeia aceasta? Am intrat în casa ta și nu mi-ai dat apă pentru picioarele mele, dar ea mi-a udat picioarele cu lacrimile ei și le-a șters cu părul capului ei. ");
INSERT INTO ronlsb_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Tu nu mi-ai dat nici o sărutare, dar ea, de când am intrat, nu încetează să-mi sărute picioarele. ");
INSERT INTO ronlsb_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Tu nu mi-ai uns capul cu untdelemn, dar ea mi-a uns picioarele cu mir. ");
INSERT INTO ronlsb_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","De aceea vă spun că păcatele ei, care sunt multe, sunt iertate, pentru că a iubit mult. Dar cel căruia i se iartă puțin, iubește puțin.” ");
INSERT INTO ronlsb_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","El i-a zis: “Păcatele tale sunt iertate”. ");
INSERT INTO ronlsb_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Și cei ce ședeau la masă cu El au început să se întrebe: “Cine este Acesta, care chiar iartă păcatele?” ");
INSERT INTO ronlsb_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","El a zis femeii: “Credința ta te-a mântuit. Du-te în pace.” ");
INSERT INTO ronlsb_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Curând după aceea, a străbătut cetățile și satele, propovăduind și aducând vestea cea bună a Împărăției lui Dumnezeu. Împreună cu el erau cei doisprezece ");
INSERT INTO ronlsb_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","și câteva femei care fuseseră vindecate de duhuri rele și de boli: Maria, care se numea Magdalena, din care ieșiseră șapte demoni, ");
INSERT INTO ronlsb_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ioana, soția lui Chuzas, administratorul lui Irod, Susana și multe altele care îi slujeau din averile lor. ");
INSERT INTO ronlsb_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Când s-a adunat o mare mulțime și veneau la el oameni din toate cetățile, el a vorbit printr-o pildă: ");
INSERT INTO ronlsb_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Fermierul a ieșit să-și semene sămânța. Pe când semăna, o parte a căzut pe drum, a fost călcată în picioare și păsările cerului au mâncat-o. ");
INSERT INTO ronlsb_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Altă sămânță a căzut pe stâncă și, de îndată ce a crescut, s-a uscat, pentru că nu avea umiditate. ");
INSERT INTO ronlsb_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Altele au căzut în mijlocul spinilor, iar spinii au crescut cu ea și au înăbușit-o. ");
INSERT INTO ronlsb_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Altă a căzut în pământul bun, a crescut și a produs de o sută de ori mai mult rod.” În timp ce spunea aceste lucruri, a strigat: “Cine are urechi de auzit, să audă!” ");
INSERT INTO ronlsb_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Atunci ucenicii Lui L-au întrebat: “Ce înseamnă pilda aceasta?” ");
INSERT INTO ronlsb_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","El a zis: “Vouă v-a fost dat să cunoașteți tainele Împărăției lui Dumnezeu; dar celorlalți le-a fost dat în pilde, ca să nu vadă, văzând, și să nu înțeleagă, auzind. ");
INSERT INTO ronlsb_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Și pilda este următoarea: Sămânța este cuvântul lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Cei de pe drum sunt cei care ascultă; apoi vine diavolul și le ia cuvântul din inimă, ca să nu creadă și să nu fie mântuiți. ");
INSERT INTO ronlsb_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Cei de pe stâncă sunt cei care, când aud, primesc cuvântul cu bucurie; dar aceștia nu au rădăcină. Ei cred pentru o vreme, apoi cad în timp de ispită. ");
INSERT INTO ronlsb_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ceea ce a căzut între spini, aceștia sunt cei care au auzit și, mergând pe drumul lor, sunt sufocați de griji, de bogății și de plăcerile vieții; și nu aduc niciun rod la maturitate. ");
INSERT INTO ronlsb_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Cele din pământul bun, aceștia sunt cei care, cu inimă cinstită și bună, după ce au auzit cuvântul, îl țin strâns și produc roade cu perseverență. ");
INSERT INTO ronlsb_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Nimeni, când aprinde o lampă, nu o acoperă cu un vas și nu o pune sub pat, ci o pune pe un suport, ca să vadă lumina cei ce intră înăuntru. ");
INSERT INTO ronlsb_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Căci nu este nimic ascuns care să nu fie descoperit, nici nimic secret care să nu fie cunoscut și să nu iasă la lumină. ");
INSERT INTO ronlsb_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Fiți deci atenți cum auziți. Căci oricui are, i se va da; și oricui nu are, i se va lua chiar și ceea ce crede că are.” ");
INSERT INTO ronlsb_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Mama și frații lui au venit la el, dar nu puteau să se apropie de el din cauza mulțimii. ");
INSERT INTO ronlsb_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Unii oameni i-au spus: “Mama ta și frații tăi stau afară și doresc să te vadă.” ");
INSERT INTO ronlsb_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Dar El le-a răspuns: “Mama mea și frații mei sunt aceia care au auzit cuvântul lui Dumnezeu și-l împlinesc.” ");
INSERT INTO ronlsb_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Într-una din zilele acelea, S-a suit într-o barcă, El însuși și ucenicii Săi, și le-a zis: “Să trecem de cealaltă parte a lacului.” Așa că au pornit la apă. ");
INSERT INTO ronlsb_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Dar, în timp ce navigau, el a adormit. O furtună de vânt s-a abătut asupra lacului, iar ei luau cantități periculoase de apă. ");
INSERT INTO ronlsb_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Au venit la el și l-au trezit, spunând: “Stăpâne, stăpâne, murim!” El s-a trezit și a mustrat vântul și furia apei; apoi au încetat și s-a făcut liniște. ");
INSERT INTO ronlsb_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","El i-a întrebat: “Unde este credința voastră?” Înfricoșați, ei s-au mirat, spunându-și unul altuia: “Cine este acesta, care poruncește chiar și vânturilor și apelor, iar acestea îl ascultă?” ");
INSERT INTO ronlsb_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Apoi au ajuns în ținutul Gadarenilor, care este în fața Galileii. ");
INSERT INTO ronlsb_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Când Isus a coborât la țărm, L-a întâmpinat un om din cetate, care avea demoni de multă vreme. Nu purta haine și nu locuia într-o casă, ci în morminte. ");
INSERT INTO ronlsb_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Când L-a văzut pe Isus, a strigat, a căzut înaintea Lui și a zis cu glas tare: “Ce am eu de-a face cu Tine, Isus, Fiul Dumnezeului Celui Preaînalt? Te implor, nu mă chinui!”. ");
INSERT INTO ronlsb_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Căci Isus poruncea duhului necurat să iasă din omul acela. Căci duhul necurat îl apucase de multe ori pe om. El era ținut sub pază și legat cu lanțuri și lanțuri. Rupând legăturile, demonul l-a împins în deșert. ");
INSERT INTO ronlsb_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Isus l-a întrebat: “Care este numele tău?” El a spus: “Legiune”, pentru că mulți demoni intraseră în el. ");
INSERT INTO ronlsb_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ei l-au implorat să nu le poruncească să se ducă în abis. ");
INSERT INTO ronlsb_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Pe munte era o turmă de mulți porci care pășteau pe munte, și l-au rugat să le dea voie să intre în ei. Atunci el le-a îngăduit. ");
INSERT INTO ronlsb_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Demonii au ieșit din omul acela și au intrat în porci, iar turma s-a repezit pe malul abrupt în lac și s-a înecat. ");
INSERT INTO ronlsb_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Când au văzut cei ce-i hrăneau ce se întâmplase, au fugit și au povestit în cetate și în țară. ");
INSERT INTO ronlsb_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Oamenii au ieșit să vadă ce s-a întâmplat. Au venit la Isus și l-au găsit pe omul din care ieșiseră demonii, șezând la picioarele lui Isus, îmbrăcat și în deplinătatea facultăților mintale; și s-au temut. ");
INSERT INTO ronlsb_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Cei care l-au văzut le-au povestit cum s-a vindecat cel care fusese posedat de demoni. ");
INSERT INTO ronlsb_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Toți locuitorii din ținutul Gadarenilor din împrejurimi l-au rugat să se îndepărteze de ei, pentru că se temeau foarte mult. Atunci a intrat în barcă și s-a întors. ");
INSERT INTO ronlsb_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Omul din care ieșiseră demonii l-a implorat să meargă cu el, dar Isus l-a alungat, spunându-i: ");
INSERT INTO ronlsb_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Întoarce-te la casa ta și povestește ce lucruri mari a făcut Dumnezeu pentru tine.” El a plecat, proclamând în toată cetatea ce lucruri mari a făcut Isus pentru el. ");
INSERT INTO ronlsb_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Când s-a întors Isus, mulțimea L-a întâmpinat, căci toți Îl așteptau. ");
INSERT INTO ronlsb_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Și iată că a venit un om cu numele Iair. Era un conducător al sinagogii. A căzut la picioarele lui Isus și l-a rugat să intre în casa lui, ");
INSERT INTO ronlsb_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","pentru că avea o fiică unică, în vârstă de vreo doisprezece ani, și era pe moarte. Dar, pe când se ducea, mulțimea îl apăsa. ");
INSERT INTO ronlsb_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","O femeie care avea o scurgere de sânge de doisprezece ani, care cheltuise tot ce trăia pe medici și nu putea fi vindecată de niciunul, ");
INSERT INTO ronlsb_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","a venit în spatele lui și s-a atins de franjurii hainei lui. Imediat curgerea sângelui ei s-a oprit. ");
INSERT INTO ronlsb_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Isus a zis: “Cine M-a atins?” Când toți au negat, Petru și cei care erau cu el au zis: “Învățătorule, mulțimile te presează și te îmbrâncesc, iar Tu spui: “Cine s-a atins de Mine?””. ");
INSERT INTO ronlsb_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Dar Isus a zis: “Cineva m-a atins, căci am văzut că a ieșit din mine o putere.” ");
INSERT INTO ronlsb_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Când femeia a văzut că nu era ascunsă, a venit tremurând; și, căzând înaintea lui, i-a declarat în fața întregului popor motivul pentru care se atinsese de el și cum s-a vindecat imediat. ");
INSERT INTO ronlsb_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","El i-a zis: “Fiică, înveselește-te! Credința ta te-a făcut sănătoasă. Du-te în pace”. ");
INSERT INTO ronlsb_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Pe când vorbea el încă, a venit unul din casa conducătorului sinagogii și i-a zis: “Fiica ta a murit. Nu-l deranja pe Învățător”. ");
INSERT INTO ronlsb_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Dar Isus, auzind, i-a răspuns: “Nu te teme. Crede numai și ea va fi vindecată.” ");
INSERT INTO ronlsb_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Când a ajuns la casă, n-a lăsat pe nimeni să intre înăuntru, decât pe Petru, pe Ioan, pe Iacov, pe tatăl fetiței și pe mama ei. ");
INSERT INTO ronlsb_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Toți plângeau și o jeleau, dar el a zis: “Nu plângeți. Ea nu este moartă, ci doarme”. ");
INSERT INTO ronlsb_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Îl batjocoreau, știind că ea era moartă. ");
INSERT INTO ronlsb_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Dar el i-a scos pe toți afară și, luând-o de mână, a strigat-o și a zis: “Copila, scoală-te!” ");
INSERT INTO ronlsb_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Spiritul ei s-a întors și s-a sculat îndată. El a poruncit să i se dea ceva de mâncare. ");
INSERT INTO ronlsb_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Părinții ei au fost uimiți, dar el le-a poruncit să nu spună nimănui ce s-a întâmplat. ");
INSERT INTO ronlsb_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","A chemat laolaltă pe cei doisprezece și le-a dat putere și stăpânire asupra tuturor demonilor și să vindece bolile. ");
INSERT INTO ronlsb_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","I-a trimis să propovăduiască Împărăția lui Dumnezeu și să vindece bolnavii. ");
INSERT INTO ronlsb_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","El le-a spus: “Nu luați nimic pentru călătoria voastră — nici toiag, nici portofel, nici pâine, nici bani. Nu aveți câte două tunici fiecare. ");
INSERT INTO ronlsb_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","În orice casă veți intra, rămâneți acolo și plecați de acolo. ");
INSERT INTO ronlsb_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Toți cei care nu vă primesc, când veți pleca din cetatea aceea, scuturați-vă până și praful de pe picioare, ca mărturie împotriva lor.” ");
INSERT INTO ronlsb_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Și au plecat și au străbătut satele, propovăduind vestea cea bună și vindecând pretutindeni. ");
INSERT INTO ronlsb_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Iar Irod tetrarhul a auzit tot ce făcuse el și a fost foarte tulburat, pentru că unii spuneau că Ioan a înviat din morți, ");
INSERT INTO ronlsb_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","alții că Ilie s-a arătat, iar alții că a înviat unul din vechii prooroci. ");
INSERT INTO ronlsb_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Irod a spus: “Eu l-am decapitat pe Ioan, dar cine este acesta despre care aud astfel de lucruri?”. A căutat să îl vadă. ");
INSERT INTO ronlsb_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Apostolii, după ce s-au întors, I-au povestit ce făcuseră. I-a luat și s-a retras deoparte, într-o regiune pustie, într-o cetate numită Betsaida. ");
INSERT INTO ronlsb_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Dar mulțimile, dându-și seama, l-au urmat. El i-a întâmpinat, le-a vorbit despre Împărăția lui Dumnezeu și i-a vindecat pe cei care aveau nevoie de vindecare. ");
INSERT INTO ronlsb_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ziua a început să se scurgă, iar cei doisprezece au venit și i-au spus: “Trimiteți mulțimea să se ducă în satele și fermele din jur, să se cazeze și să facă rost de hrană, pentru că noi suntem aici într-un loc pustiu.” ");
INSERT INTO ronlsb_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Dar El le-a zis: “Dați-le voi să mănânce ceva.” Ei au spus: “Nu avem mai mult de cinci pâini și doi pești, dacă nu cumpărăm mâncare pentru toți acești oameni.” ");
INSERT INTO ronlsb_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Căci erau cam cinci mii de oameni. El le-a spus ucenicilor săi: “Fă-i să se așeze în grupuri de câte cincizeci de persoane.” ");
INSERT INTO ronlsb_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ei au făcut așa și i-au pus pe toți să se așeze. ");
INSERT INTO ronlsb_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","El a luat cele cinci pâini și cei doi pești și, privind spre cer, le-a binecuvântat, le-a frânt și le-a dat discipolilor ca să le pună înaintea mulțimii. ");
INSERT INTO ronlsb_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ei au mâncat și s-au săturat cu toții. Au adunat douăsprezece coșuri cu bucățile sparte care rămăseseră. ");
INSERT INTO ronlsb_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Pe când se ruga El singur, ucenicii erau lângă El și El i-a întrebat: “Cine zice mulțimea că sunt Eu?” ");
INSERT INTO ronlsb_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ei au răspuns: “Ioan Botezătorul”; dar alții zic: “Ilie”, iar alții zic că a înviat unul din vechii prooroci”. ");
INSERT INTO ronlsb_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","El le-a zis: “Dar voi cine ziceți că sunt Eu?” Petru a răspuns: “Hristosul lui Dumnezeu.” ");
INSERT INTO ronlsb_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Dar El i-a avertizat și le-a poruncit să nu spună nimănui acest lucru, ");
INSERT INTO ronlsb_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","zicând: “Fiul Omului trebuie să sufere multe, să fie lepădat de bătrâni, de preoții cei mai de seamă și de cărturari, să fie omorât și a treia zi să învieze.” ");
INSERT INTO ronlsb_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Și a zis tuturor: “Dacă voiește cineva să vină după Mine, să se lepede de sine, să-și ia crucea și să-Mi urmeze Mie. ");
INSERT INTO ronlsb_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Căci oricine vrea să-și salveze viața o va pierde, dar oricine își va pierde viața pentru Mine o va salva. ");
INSERT INTO ronlsb_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Căci ce-i folosește cuiva să câștige toată lumea și să se piardă sau să se piardă pe sine însuși? ");
INSERT INTO ronlsb_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Căci oricine se va rușina de Mine și de cuvintele Mele, de acela se va rușina Fiul Omului când va veni în slava Sa și în slava Tatălui și a sfinților îngeri. ");
INSERT INTO ronlsb_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Dar vă spun adevărul: sunt unii dintre cei care stau aici care nu vor gusta nicidecum moartea până când nu vor vedea Împărăția lui Dumnezeu.” ");
INSERT INTO ronlsb_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","La vreo opt zile după aceste cuvinte, a luat cu Sine pe Petru, pe Ioan și pe Iacov și s-a suit pe munte să se roage. ");
INSERT INTO ronlsb_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","În timp ce se ruga, înfățișarea feței Lui s-a schimbat, iar hainele Lui au devenit albe și orbitoare. ");
INSERT INTO ronlsb_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Iată că vorbeau cu el doi bărbați, care erau Moise și Ilie, ");
INSERT INTO ronlsb_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","care s-au arătat în slavă și i-au vorbit despre plecarea pe care urma să o îndeplinească la Ierusalim. ");
INSERT INTO ronlsb_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petru și cei ce erau cu el erau îngreuiați de somn; dar, când s-au trezit, au văzut slava Lui și pe cei doi bărbați care stăteau cu El. ");
INSERT INTO ronlsb_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Pe când se despărțeau de El, Petru i-a zis lui Isus: “Învățătorule, este bine să fim aici. Să facem trei corturi: unul pentru tine, unul pentru Moise și unul pentru Ilie”, fără să știe ce spune. ");
INSERT INTO ronlsb_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pe când zicea El aceste lucruri, un nor a venit și i-a acoperit și ei s-au temut, când au intrat în nor. ");
INSERT INTO ronlsb_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Un glas a ieșit din nor și a zis: “Acesta este Fiul Meu preaiubit. Ascultați-l!” ");
INSERT INTO ronlsb_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Când a venit vocea, Isus a fost găsit singur. Ei au tăcut și nu au povestit nimănui, în acele zile, nimic din ceea ce văzuseră. ");
INSERT INTO ronlsb_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","A doua zi, când s-au coborât de pe munte, o mare mulțime de oameni I-a ieșit în întâmpinare. ");
INSERT INTO ronlsb_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Și iată că un om din mulțime a strigat: “Învățătorule, te rog să te uiți la fiul meu, căci este singurul meu copil născut. ");
INSERT INTO ronlsb_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Iată că un duh îl ia, strigă deodată și îl convulsionează până la spumegarea lui; și abia se depărtează de el, lovindu-l grav. ");
INSERT INTO ronlsb_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","I-am rugat pe discipolii tăi să-l alunge, dar nu au putut.” ");
INSERT INTO ronlsb_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Isus a răspuns: “Neam necredincios și pervers, până când voi fi cu voi și voi răbda cu voi? Aduceți aici pe fiul vostru”. ");
INSERT INTO ronlsb_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Pe când venea el încă, demonul l-a aruncat la pământ și l-a zdrobit cu putere. Dar Isus a mustrat duhul necurat, a vindecat băiatul și l-a dat înapoi tatălui său. ");
INSERT INTO ronlsb_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Toți erau uimiți de măreția lui Dumnezeu. Și, pe când toți se mirau de toate lucrurile pe care le făcea Isus, a zis ucenicilor Săi: ");
INSERT INTO ronlsb_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Lăsați să vă intre în urechi cuvintele acestea, căci Fiul Omului va fi dat în mâinile oamenilor”. ");
INSERT INTO ronlsb_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Dar ei nu au înțeles acest cuvânt. Le era ascunsă, ca să nu o înțeleagă, și le era teamă să îl întrebe despre acest cuvânt. ");
INSERT INTO ronlsb_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Și s-a iscat între ei o ceartă despre care dintre ei era cel mai mare. ");
INSERT INTO ronlsb_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Isus, pricepând rațiunile inimilor lor, a luat un copilaș, l-a pus lângă El și le-a spus: ");
INSERT INTO ronlsb_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","“Oricine primește pe acest copilaș în numele Meu, pe Mine Mă primește. Oricine mă primește pe mine îl primește pe cel care m-a trimis. Căci oricine este cel mai mic dintre voi toți, acesta va fi mare”. ");
INSERT INTO ronlsb_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ioan a răspuns: “Învățătorule, am văzut pe cineva care scotea demoni în Numele Tău și i-am interzis, pentru că nu este de partea noastră.” ");
INSERT INTO ronlsb_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Isus i-a zis: “Nu-l opri, căci cine nu este împotriva noastră, este pentru noi.” ");
INSERT INTO ronlsb_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Când se apropiau zilele în care trebuia să fie luat, el și-a pus în gând să meargă la Ierusalim ");
INSERT INTO ronlsb_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","și a trimis mesageri înaintea lui. Aceștia s-au dus și au intrat într-un sat al samaritenilor, ca să se pregătească pentru el. ");
INSERT INTO ronlsb_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ei nu l-au primit, pentru că el călătorea cu fața îndreptată spre Ierusalim. ");
INSERT INTO ronlsb_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Când discipolii săi, Iacov și Ioan, au văzut acest lucru, au zis: “Doamne, vrei să poruncim noi să coboare foc din cer și să-i nimicească, așa cum a făcut Ilie?” ");
INSERT INTO ronlsb_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Dar El s-a întors și i-a mustrat: “Nu știți ce fel de duh sunteți. ");
INSERT INTO ronlsb_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Căci Fiul Omului nu a venit să distrugă viețile oamenilor, ci să le salveze.” S-au dus în alt sat. ");
INSERT INTO ronlsb_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Pe când mergeau pe drum, un om I-a zis: “Vreau să Te urmez oriunde vei merge, Doamne.” ");
INSERT INTO ronlsb_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Isus i-a zis: “Vulpile au vizuini și păsările cerului au cuiburi, dar Fiul Omului nu are unde să-Și pună capul.” ");
INSERT INTO ronlsb_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Și a zis altuia: “Urmează-mă!” Dar el a spus: “Doamne, dă-mi voie să mă duc mai întâi să-l îngrop pe tatăl meu”. ");
INSERT INTO ronlsb_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Dar Isus i-a zis: “Lasă morții să-și îngroape morții lor, iar tu du-te și vestește Împărăția lui Dumnezeu.” ");
INSERT INTO ronlsb_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Un altul a mai zis: “Vreau să te urmez, Doamne, dar mai întâi îngăduie-mi să-mi iau rămas bun de la cei care sunt la mine acasă.” ");
INSERT INTO ronlsb_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Dar Isus i-a zis: “Nimeni care a pus mâna la plug și se uită înapoi nu este potrivit pentru Împărăția lui Dumnezeu.” ");
INSERT INTO ronlsb_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","După aceste lucruri, Domnul a rânduit și pe alți șaptezeci și i-a trimis înaintea Lui, doi câte doi, în fiecare cetate și în fiecare loc unde avea să vină. ");
INSERT INTO ronlsb_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Și le-a spus: “Secerișul este într-adevăr mare, dar lucrătorii sunt puțini. Rugați-vă, așadar, Domnului secerișului, ca să trimită lucrători la secerișul Său. ");
INSERT INTO ronlsb_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Mergeți și voi pe căile voastre. Iată, vă trimit ca pe niște miei în mijlocul lupilor. ");
INSERT INTO ronlsb_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nu purtați nici pungă, nici portofel, nici sandale. Nu salutați pe nimeni pe drum. ");
INSERT INTO ronlsb_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","În orice casă veți intra, spuneți mai întâi: “Pacea fie cu casa aceasta!”. ");
INSERT INTO ronlsb_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Dacă este acolo un fiu al păcii, pacea voastră se va odihni asupra lui; dacă nu, se va întoarce la voi. ");
INSERT INTO ronlsb_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Rămâi în aceeași casă, mâncând și bând ce ți se dă, căci lucrătorul este vrednic de plata sa. Nu mergeți din casă în casă. ");
INSERT INTO ronlsb_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","În orice cetate veți intra și vă vor primi, mâncați ceea ce vi se pune înainte. ");
INSERT INTO ronlsb_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Vindecați pe bolnavii care se află acolo și spuneți-le: “Împărăția lui Dumnezeu s-a apropiat de voi”. ");
INSERT INTO ronlsb_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Dar în orice cetate în care intrați și nu vă primesc, ieșiți pe străzile ei și spuneți: ");
INSERT INTO ronlsb_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Chiar și praful din cetatea voastră care se lipește de noi, îl ștergem împotriva voastră. Cu toate acestea, să știți că Împărăția lui Dumnezeu s-a apropiat de voi'. ");
INSERT INTO ronlsb_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Vă spun că, în ziua aceea, va fi mai ușor de suportat pentru Sodoma decât pentru orașul acela. ");
INSERT INTO ronlsb_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Vai de tine, Corazin! Vai de tine, Betsaida! Căci dacă s-ar fi făcut în Tir și în Sidon lucrările mărețe care s-au făcut în voi, s-ar fi pocăit de mult, stând în sac și cenușă. ");
INSERT INTO ronlsb_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Dar, la judecată, Tirului și Sidonului le va fi mai ușor de suportat decât vouă. ");
INSERT INTO ronlsb_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Tu, Capernaum, care te-ai înălțat la cer, vei fi coborât în Hades. ");
INSERT INTO ronlsb_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Cine vă ascultă pe voi mă ascultă pe mine, iar cine vă respinge pe voi mă respinge pe mine. Cine mă respinge pe mine, îl respinge pe cel care m-a trimis pe mine.” ");
INSERT INTO ronlsb_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Cei șaptezeci s-au întors cu bucurie, zicând: “Doamne, chiar și demonii ne sunt supuși în Numele Tău!” ");
INSERT INTO ronlsb_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Și le-a zis: “Am văzut pe Satana căzând din cer ca un fulger. ");
INSERT INTO ronlsb_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Iată, vă dau putere să călcați peste șerpi și scorpioni și peste toată puterea vrăjmașului. Nimic nu vă va răni în vreun fel. ");
INSERT INTO ronlsb_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Cu toate acestea, nu vă bucurați de faptul că duhurile vi se supun, ci bucurați-vă că numele voastre sunt scrise în ceruri.” ");
INSERT INTO ronlsb_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","În același ceas, Isus s-a bucurat în Duhul Sfânt și a zis: “Îți mulțumesc, Tată, Stăpânul cerului și al pământului, că ai ascuns aceste lucruri de cei înțelepți și pricepuți și le-ai descoperit copiilor. Da, Tată, pentru că așa a fost bineplăcut în ochii tăi”. ");
INSERT INTO ronlsb_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Întorcându-Se către ucenici, a zis: “Toate Mi-au fost date de Tatăl Meu. Nimeni nu știe cine este Fiul, în afară de Tatăl, și cine este Tatăl, în afară de Fiul și de cel căruia Fiul vrea să i-l dezvăluie.” ");
INSERT INTO ronlsb_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Și, întorcându-se către ucenici, a zis în particular: “Fericiți ochii care văd ceea ce vedeți voi, ");
INSERT INTO ronlsb_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","căci vă spun că mulți prooroci și împărați au dorit să vadă ceea ce vedeți voi și n-au văzut, și să audă ceea ce auziți voi și n-au auzit.” ");
INSERT INTO ronlsb_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Și iată că un învățător s-a ridicat în picioare și L-a pus la încercare, zicând: “Învățătorule, ce să fac ca să moștenesc viața veșnică?” ");
INSERT INTO ronlsb_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","El i-a zis: “Ce este scris în Lege? Cum o citești?” ");
INSERT INTO ronlsb_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","El a răspuns: “Să iubești pe Domnul Dumnezeul tău din toată inima ta, din tot sufletul tău, din toată puterea ta și din tot cugetul tău, și pe aproapele tău ca pe tine însuți.” ");
INSERT INTO ronlsb_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","El i-a zis: “Ai răspuns corect. Fă așa și vei trăi.” ");
INSERT INTO ronlsb_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Dar el, vrând să se justifice, a întrebat pe Isus: “Cine este aproapele meu?” ");
INSERT INTO ronlsb_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Isus a răspuns: “Un om care se cobora de la Ierusalim la Ierihon, a căzut în mijlocul unor tâlhari care, după ce l-au dezbrăcat și l-au bătut, au plecat și l-au lăsat pe jumătate mort. ");
INSERT INTO ronlsb_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Din întâmplare, un preot cobora pe drumul acela. Când l-a văzut, a trecut pe partea cealaltă. ");
INSERT INTO ronlsb_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","La fel și un levit, când a ajuns la locul acela și l-a văzut, a trecut pe partea cealaltă. ");
INSERT INTO ronlsb_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Dar un oarecare samaritean, pe când călătorea, a ajuns unde era el. Când l-a văzut, i s-a făcut milă, ");
INSERT INTO ronlsb_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","s-a apropiat de el și i-a legat rănile, turnând untdelemn și vin. L-a așezat pe animalul său, l-a dus la un han și a avut grijă de el. ");
INSERT INTO ronlsb_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","A doua zi, când a plecat, a scos doi denari, i-a dat gazdei și i-a spus: “Ai grijă de el. Tot ce vei cheltui în plus, îți voi da înapoi când mă voi întoarce'. ");
INSERT INTO ronlsb_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Acum, care dintre acești trei credeți că vi s-a părut că era vecin cu cel care a căzut între tâlhari?” ");
INSERT INTO ronlsb_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","El a zis: “Cel care a avut milă de el.” Atunci Isus i-a zis: “Du-te și fă și tu la fel”. ");
INSERT INTO ronlsb_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Pe când mergeau ei pe drum, a intrat într-un sat și o femeie, numită Marta, L-a primit în casa ei. ");
INSERT INTO ronlsb_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ea avea o soră, numită Maria, care ședea și ea la picioarele lui Isus și asculta cuvântul Lui. ");
INSERT INTO ronlsb_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Dar Marta, care era ocupată cu multe slujbe, s-a apropiat de el și i-a zis: “Doamne, nu-ți pasă că sora mea m-a lăsat să slujesc singură? Roag-o, așadar, să mă ajute”. ");
INSERT INTO ronlsb_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Isus i-a răspuns: “Marta, Marta, tu ești neliniștită și îngrijorată de multe lucruri; ");
INSERT INTO ronlsb_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","dar un singur lucru este necesar. Maria a ales partea cea bună, care nu-i va fi luată”. ");
INSERT INTO ronlsb_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","După ce a terminat de rugat într-un loc, unul din ucenicii Săi I-a zis: “Doamne, învață-ne să ne rugăm, cum i-a învățat și Ioan pe ucenicii Săi.” ");
INSERT INTO ronlsb_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","El le-a zis: “Când vă rugați, spuneți, “Tatăl nostru care ești în ceruri, fie ca numele tău să fie păstrat sfânt. Fie ca Împărăția Ta să vină. Facă-se voia Ta, precum în cer așa și pe pământ. ");
INSERT INTO ronlsb_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Dă-ne în fiecare zi pâinea noastră cea de toate zilele. ");
INSERT INTO ronlsb_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Iartă-ne nouă păcatele noastre, pentru că și noi înșine iertăm tuturor celor care ne sunt datori. Nu ne duce pe noi în ispită, ci izbăvește-ne pe noi de cel rău”.” ");
INSERT INTO ronlsb_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","El le-a zis: “Care dintre voi, dacă vă veți duce la miezul nopții la un prieten și-i veți spune: “Prietene, împrumută-mi trei pâini, ");
INSERT INTO ronlsb_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","căci un prieten de-al meu a venit la mine din călătorie și nu am ce să-i pun înainte, ");
INSERT INTO ronlsb_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","iar el, dinăuntru, va răspunde și va zice: “Nu mă deranja. Ușa este acum închisă, iar copiii mei sunt cu mine în pat. Nu pot să mă ridic și să ți-i dau'?”? ");
INSERT INTO ronlsb_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Vă spun că, deși nu se va ridica și nu i le va da, pentru că este prietenul lui, totuși, datorită insistenței lui, se va ridica și îi va da atâtea câte îi trebuie. ");
INSERT INTO ronlsb_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Vă spun: cereți și vi se va da. Continuați să căutați și veți găsi. Continuați să bateți la ușă și vi se va deschide. ");
INSERT INTO ronlsb_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Căci oricine cere primește. Cel care caută găsește. Celui care bate i se va deschide. ");
INSERT INTO ronlsb_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Care dintre voi, taților, dacă fiul vostru va cere o pâine, îi va da o piatră? Sau, dacă va cere un pește, nu-i va da un șarpe în loc de pește, nu-i așa? ");
INSERT INTO ronlsb_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Sau, dacă va cere un ou, nu-i va da un scorpion, nu-i așa? ");
INSERT INTO ronlsb_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Dacă voi, deci, fiind răi, știți să dați daruri bune copiilor voștri, cu cât mai mult Tatăl vostru ceresc va da Duhul Sfânt celor care i-l cer?” ");
INSERT INTO ronlsb_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","El scotea un demon, și acesta era mut. După ce demonul a ieșit, muticul a vorbit; și mulțimile se mirau. ");
INSERT INTO ronlsb_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Dar unii dintre ei ziceau: “El scoate demonii prin Beelzebul, prințul demonilor.” ");
INSERT INTO ronlsb_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Alții, punându-l la încercare, căutau de la el un semn din cer. ");
INSERT INTO ronlsb_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Dar El, cunoscându-le gândurile, le-a zis: “Orice împărăție împărțită împotriva ei însăși este dărâmată. O casă împărțită împotriva ei însăși cade. ");
INSERT INTO ronlsb_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Dacă și Satana este dezbinat împotriva lui însuși, cum va rezista împărăția lui? Căci voi spuneți că eu scot demoni prin Beelzebul. ");
INSERT INTO ronlsb_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Dar dacă Eu scot demoni prin Beelzebul, prin cine îi scot copiii voștri? De aceea ei vor fi judecătorii voștri. ");
INSERT INTO ronlsb_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Dar dacă eu, prin degetul lui Dumnezeu, scot afară demoni, atunci Împărăția lui Dumnezeu a venit la voi. ");
INSERT INTO ronlsb_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Când un om puternic, înarmat până-n dinți, își păzește locuința, bunurile sale sunt în siguranță. ");
INSERT INTO ronlsb_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Dar când cineva mai puternic îl atacă și îl învinge, îi ia toată armura în care se încredea și își împarte prada. ");
INSERT INTO ronlsb_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Cine nu este cu Mine, este împotriva Mea. Cine nu se adună cu mine se risipește. ");
INSERT INTO ronlsb_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","După ce a ieșit din om, duhul necurat trece prin locuri uscate, căutând odihnă; și, cum nu găsește nimic, zice: “Mă voi întoarce la casa mea de unde am ieșit. ");
INSERT INTO ronlsb_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Când se întoarce, o găsește măturată și pusă în ordine. ");
INSERT INTO ronlsb_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Atunci se duce și ia alte șapte duhuri mai rele decât el, intră și locuiesc acolo. Ultima stare a acelui om devine mai rea decât prima.” ");
INSERT INTO ronlsb_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Pe când zicea El aceste lucruri, o femeie din mulțime a ridicat glasul și I-a zis: “Binecuvântat este pântecele care Te-a născut și sânii care Te-au alăptat!” ");
INSERT INTO ronlsb_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Iar el a zis: “Dimpotrivă, fericiți cei ce ascultă cuvântul lui Dumnezeu și-l păzesc.” ");
INSERT INTO ronlsb_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Când s-a adunat mulțimea la El, a început să zică: “Acesta este un neam rău. Ea caută un semn. Nu i se va da alt semn decât semnul profetului Iona. ");
INSERT INTO ronlsb_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Căci, după cum Iona a fost un semn pentru niniviteni, așa va fi și Fiul Omului pentru acest neam. ");
INSERT INTO ronlsb_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Împărăteasa Sudului se va ridica la judecată împreună cu oamenii acestui neam și îi va condamna, pentru că a venit de la marginile pământului să asculte înțelepciunea lui Solomon; și iată că unul mai mare decât Solomon este aici. ");
INSERT INTO ronlsb_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Bărbații din Ninive se vor ridica la judecată împreună cu acest neam și îl vor condamna, pentru că s-au pocăit la propovăduirea lui Iona; și iată, unul mai mare decât Iona este aici. ");
INSERT INTO ronlsb_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Nimeni, când aprinde o lampă, nu o pune în pivniță sau sub un coș, ci pe un suport, ca să vadă lumina cei ce intră. ");
INSERT INTO ronlsb_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Lampa trupului este ochiul. De aceea, când ochiul tău este bun, tot corpul tău este și el plin de lumină; dar când este rău, tot corpul tău este plin de întuneric. ");
INSERT INTO ronlsb_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","De aceea, vedeți dacă lumina care este în voi nu este întuneric. ");
INSERT INTO ronlsb_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Așadar, dacă tot trupul vostru este plin de lumină, neavând nicio parte întunecată, va fi în întregime plin de lumină, ca atunci când lampa cu strălucirea ei strălucitoare vă luminează.” ");
INSERT INTO ronlsb_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Pe când vorbea el, un fariseu l-a invitat să ia masa cu el. El a intrat și s-a așezat la masă. ");
INSERT INTO ronlsb_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Fariseul, când l-a văzut, s-a mirat că nu se spălase mai întâi înainte de cină. ");
INSERT INTO ronlsb_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Domnul i-a zis: “Voi, fariseii, curățați partea exterioară a paharului și a farfuriei, dar partea voastră interioară este plină de șantaj și de răutate. ");
INSERT INTO ronlsb_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Voi, nebunilor, nu cumva Cel care a făcut partea exterioară nu a făcut și partea interioară? ");
INSERT INTO ronlsb_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Dar dați ca daruri celor nevoiași cele dinăuntru și iată că toate lucrurile vor fi curate pentru voi. ");
INSERT INTO ronlsb_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Dar vai de voi, fariseilor! Pentru că voi dați zeciuială pentru mentă, rudenie și orice altă plantă, dar ocoliți dreptatea și dragostea lui Dumnezeu. Ar fi trebuit să le faceți pe acestea și să nu le lăsați pe celelalte nefăcute. ");
INSERT INTO ronlsb_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Vai de voi, fariseilor! Pentru că vă plac locurile cele mai bune din sinagogi și salutul din piețe. ");
INSERT INTO ronlsb_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Vai vouă, cărturari și farisei, ipocriților! Pentru că sunteți ca niște morminte ascunse, iar cei care umblă peste ele nu știu.” ");
INSERT INTO ronlsb_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Unul dintre avocați i-a răspuns: “Învățătorule, spunând aceasta, ne insulți și pe noi.” ");
INSERT INTO ronlsb_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","El a zis: “Vai de voi, avocaților! Pentru că îi încărcați pe oameni cu poveri greu de purtat, iar voi înșivă nu ridicați nici măcar un deget pentru a ajuta la purtarea acestor poveri. ");
INSERT INTO ronlsb_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Vai de voi! Pentru că voi construiți mormintele profeților, iar părinții voștri i-au ucis. ");
INSERT INTO ronlsb_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Așa că voi mărturisiți și consimțiți la faptele părinților voștri. Căci ei i-au ucis, iar voi le construiți mormintele. ");
INSERT INTO ronlsb_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","De aceea și înțelepciunea lui Dumnezeu a spus: “Voi trimite la ei profeți și apostoli; și pe unii dintre ei îi vor ucide și îi vor prigoni, ");
INSERT INTO ronlsb_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","pentru ca sângele tuturor profeților, care a fost vărsat de la întemeierea lumii, să fie cerut de acest neam, ");
INSERT INTO ronlsb_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","de la sângele lui Abel până la sângele lui Zaharia, care a pierit între altar și sanctuar. Da, vă spun, va fi cerut de această generație. ");
INSERT INTO ronlsb_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Vai de voi, avocaților! Căci ați luat cheia cunoștinței. Voi înșivă nu ați intrat înăuntru, iar pe cei care intrau, voi i-ați împiedicat.” ");
INSERT INTO ronlsb_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Pe când le spunea El aceste lucruri, cărturarii și fariseii au început să se mânie cumplit și să scoată multe lucruri de la El, ");
INSERT INTO ronlsb_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","pândindu-L și căutând să-L prindă în ceva ce ar putea să spună, ca să-L acuze. ");
INSERT INTO ronlsb_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Între timp, după ce s-a adunat o mulțime de multe mii de oameni, încât se călcau în picioare unii pe alții, a început să spună mai întâi ucenicilor Săi: “Feriți-vă de drojdia fariseilor, care este ipocrizia. ");
INSERT INTO ronlsb_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Dar nu este nimic ascuns care să nu fie descoperit, nici ascuns care să nu fie cunoscut. ");
INSERT INTO ronlsb_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","De aceea, tot ce ați spus în întuneric va fi auzit la lumină. Ceea ce ați spus la ureche în încăperile interioare va fi proclamat pe acoperișurile caselor. ");
INSERT INTO ronlsb_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Vă spun, prietenii mei, să nu vă temeți de cei ce ucid trupul, și după aceea nu mai au ce să facă. ");
INSERT INTO ronlsb_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ci vă voi avertiza de cine trebuie să vă temeți. Temeți-vă de cel care, după ce a ucis, are puterea de a arunca în Gheenă. Da, vă spun, temeți-vă de el. ");
INSERT INTO ronlsb_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Nu se vând cinci vrăbii cu două monede de assaria? Nici una dintre ele nu este uitată de Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Dar până și firele de păr de pe capul vostru sunt toate numărate. De aceea nu vă temeți. Voi sunteți mai valoroși decât multe vrăbii. ");
INSERT INTO ronlsb_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Vă spun că pe oricine Mă va mărturisi înaintea oamenilor, Fiul Omului îl va mărturisi și înaintea îngerilor lui Dumnezeu; ");
INSERT INTO ronlsb_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","iar cine Mă va tăgădui în fața oamenilor, va fi tăgăduit și în fața îngerilor lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Oricine va rosti un cuvânt împotriva Fiului Omului va fi iertat, dar cei care blasfemiază împotriva Duhului Sfânt nu vor fi iertați. ");
INSERT INTO ronlsb_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Când vă vor aduce în fața sinagogilor, a conducătorilor și a autorităților, nu vă îngrijorați cum sau ce veți răspunde sau ce veți spune; ");
INSERT INTO ronlsb_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","pentru că Duhul Sfânt vă va învăța în același ceas ce trebuie să spuneți.” ");
INSERT INTO ronlsb_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Unul din mulțime I-a zis: “Învățătorule, spune fratelui meu să împartă cu mine moștenirea.” ");
INSERT INTO ronlsb_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Iar el i-a zis: “Omule, cine m-a pus pe mine judecător sau arbitru peste tine?” ");
INSERT INTO ronlsb_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","El le-a zis: “Luați seama! Păstrați-vă departe de lăcomie, căci viața unui om nu constă în abundența lucrurilor pe care le posedă”. ");
INSERT INTO ronlsb_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Și le-a spus o pildă, zicând: “Pământul unui om bogat producea din belșug. ");
INSERT INTO ronlsb_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","El se gândea în sinea lui și zicea: “Ce voi face, pentru că nu am loc să-mi depozitez recolta?” ");
INSERT INTO ronlsb_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","El a zis: “Iată ce voi face. Îmi voi dărâma hambarele, voi construi altele mai mari și acolo îmi voi depozita tot grâul și toate bunurile mele. ");
INSERT INTO ronlsb_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Voi spune sufletului meu: “Suflete, ai multe bunuri depozitate de mulți ani. Ia-ți liniștea, mănâncă, bea și fii vesel!””'”. ");
INSERT INTO ronlsb_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Dar Dumnezeu i-a zis: “Nebunule, în seara aceasta ți se cere sufletul tău. Lucrurile pe care le-ai pregătit — ale cui vor fi?” ");
INSERT INTO ronlsb_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Așa este cel care își strânge comori pentru sine și nu este bogat față de Dumnezeu.” ");
INSERT INTO ronlsb_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Și a zis ucenicilor Săi: “De aceea vă spun: Nu vă îngrijorați pentru viața voastră, ce veți mânca, nici pentru trupul vostru, ce veți purta. ");
INSERT INTO ronlsb_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Viața este mai mult decât mâncarea, iar trupul este mai mult decât îmbrăcămintea. ");
INSERT INTO ronlsb_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Gândiți-vă la corbi: ei nu seamănă, nu seceră, nu au depozit sau hambar, și Dumnezeu îi hrănește. Cât de mult mai valoroși sunteți voi decât păsările! ");
INSERT INTO ronlsb_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Care dintre voi, fiind neliniștit, poate adăuga un cot la înălțimea sa? ");
INSERT INTO ronlsb_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Dacă deci nu sunteți în stare să faceți nici măcar cele mai mici lucruri, de ce vă îngrijorați pentru restul? ");
INSERT INTO ronlsb_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Gândiți-vă la crini, cum cresc ei. Ei nu se trudesc, nici nu se învârt; totuși vă spun că nici măcar Solomon, în toată slava lui, nu era îmbrăcat ca unul dintre aceștia. ");
INSERT INTO ronlsb_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Dar dacă așa îmbracă Dumnezeu iarba de pe câmp, care astăzi există, iar mâine este aruncată în cuptor, cu cât mai mult vă va îmbrăca pe voi, cei cu puțină credință? ");
INSERT INTO ronlsb_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Nu căutați ce veți mânca și ce veți bea, și nu vă îngrijorați. ");
INSERT INTO ronlsb_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Căci neamurile lumii caută toate aceste lucruri, dar Tatăl vostru știe că voi aveți nevoie de ele. ");
INSERT INTO ronlsb_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ci căutați Împărăția lui Dumnezeu și toate aceste lucruri vi se vor adăuga. ");
INSERT INTO ronlsb_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Nu vă temeți, turmă mică, căci Tatăl vostru a binevoit să vă dea Împărăția. ");
INSERT INTO ronlsb_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Vindeți ce aveți și dați daruri celor nevoiași. Făceți-vă poșete care nu îmbătrânesc, o comoară în ceruri care nu se strică, de care nu se apropie niciun hoț și pe care nu o distruge molia. ");
INSERT INTO ronlsb_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Căci unde este comoara voastră, acolo va fi și inima voastră. ");
INSERT INTO ronlsb_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Să vă îmbrăcați la brâu și să vă aprindeți lămpile. ");
INSERT INTO ronlsb_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Să fiți ca niște oameni care pândesc pe stăpânul lor când se întoarce de la nuntă, pentru ca, atunci când vine și bate la ușă, să-i deschidă îndată. ");
INSERT INTO ronlsb_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Fericiți sunt acei slujitori pe care Domnul îi va găsi veghind când va veni. Mai mult ca sigur vă spun că se va îmbrăca, îi va face să se culce și va veni să le slujească. ");
INSERT INTO ronlsb_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ei vor fi binecuvântați dacă va veni în a doua sau a treia gardă și îi va găsi așa. ");
INSERT INTO ronlsb_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Dar să știți că, dacă stăpânul casei ar fi știut la ce oră va veni hoțul, ar fi vegheat și nu ar fi permis să i se spargă casa. ");
INSERT INTO ronlsb_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","De aceea și voi fiți gata, căci Fiul Omului vine într-un ceas în care nu vă așteptați.” ");
INSERT INTO ronlsb_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petru I-a zis: “Doamne, ne spui nouă pilda aceasta, sau tuturor?” ");
INSERT INTO ronlsb_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Și Domnul a zis: “Cine este administratorul credincios și înțelept, pe care îl va pune stăpânul său peste casa lui, ca să le dea partea lor de mâncare la vremea potrivită? ");
INSERT INTO ronlsb_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ferice de acel slujitor pe care stăpânul său îl va găsi făcând așa când va veni. ");
INSERT INTO ronlsb_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Adevărat vă spun că îl va pune peste tot ce are. ");
INSERT INTO ronlsb_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Dar dacă robul acela zice în inima lui: “Domnul meu întârzie să vină” și începe să bată pe slujitorii și pe slujnice, să mănânce, să bea și să se îmbete, ");
INSERT INTO ronlsb_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","atunci stăpânul robului acela va veni într-o zi în care nu-l așteaptă și într-un ceas pe care nu-l știe, îl va tăia în două și-i va pune partea lui cu cei necredincioși. ");
INSERT INTO ronlsb_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Robul acela care știa voia stăpânului său și nu s-a pregătit și nici nu a făcut ce voia el, va fi bătut cu multe lovituri, ");
INSERT INTO ronlsb_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","dar cel care nu știa și a făcut lucruri vrednice de lovituri va fi bătut cu puține lovituri. Cui i s-a dat mult, i se va cere mult; și cui i s-a încredințat mult, i se va cere mai mult. ");
INSERT INTO ronlsb_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Am venit să arunc foc pe pământ. Aș vrea să fie deja aprins. ");
INSERT INTO ronlsb_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Dar eu am un botez cu care trebuie să fiu botezat și cât de mult mă chinui până când se va împlini! ");
INSERT INTO ronlsb_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Credeți că am venit să dau pace pe pământ? Vă spun că nu, ci mai degrabă dezbinare. ");
INSERT INTO ronlsb_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Căci, de acum înainte, într-o casă vor fi cinci dezbinați, trei împotriva a doi și doi împotriva a trei. ");
INSERT INTO ronlsb_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Vor fi dezbinați: tatăl împotriva fiului și fiul împotriva tatălui; mama împotriva fiicei și fiica împotriva mamei sale; soacra împotriva nurorii și nora împotriva soacrei.” ");
INSERT INTO ronlsb_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Și a zis mulțimilor: “Când vedeți un nor ridicându-se dinspre apus, îndată ziceți: “Vine o ploaie”, și așa se întâmplă. ");
INSERT INTO ronlsb_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Când suflă un vânt de sud, voi spuneți: “Va fi o căldură toridă”, și așa se întâmplă. ");
INSERT INTO ronlsb_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Voi, ipocriților! Voi știți să interpretați aspectul pământului și al cerului, dar cum se face că nu interpretați acest timp? ");
INSERT INTO ronlsb_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“De ce nu judecați voi înșivă ce este drept? ");
INSERT INTO ronlsb_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Căci, atunci când mergi cu potrivnicul tău înaintea magistratului, încearcă cu sârguință pe drum să te eliberezi de el, ca nu cumva să nu te târască la judecător, iar judecătorul să te predea ofițerului și acesta să te arunce în închisoare. ");
INSERT INTO ronlsb_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Îți spun că nu vei ieși nicidecum de acolo până când nu vei plăti până la ultimul bănuț.” ");
INSERT INTO ronlsb_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","În același timp, erau de față unii care i-au spus despre galileenii al căror sânge Pilat îl amestecase cu jertfele lor. ");
INSERT INTO ronlsb_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Isus le-a răspuns: “Credeți voi că acești galileeni erau mai păcătoși decât toți ceilalți galileeni, pentru că au suferit astfel de lucruri? ");
INSERT INTO ronlsb_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Eu vă spun că nu, ci, dacă nu vă veți pocăi, veți pieri cu toții în același fel. ");
INSERT INTO ronlsb_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Sau acei optsprezece peste care a căzut turnul din Siloam și i-a omorât — credeți că au fost niște păcătoși mai răi decât toți oamenii care locuiesc în Ierusalim? ");
INSERT INTO ronlsb_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Vă spun că nu, dar, dacă nu vă veți pocăi, veți pieri cu toții în același fel.” ");
INSERT INTO ronlsb_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Și a spus pilda aceasta. “Un om avea un smochin plantat în via sa; a venit să caute rod pe el și nu a găsit niciunul. ");
INSERT INTO ronlsb_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","El a zis viticultorului: “Iată, în acești trei ani am venit să caut rod pe acest smochin și n-am găsit niciunul. Tăiați-l! De ce risipește el pământul?” ");
INSERT INTO ronlsb_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","El a răspuns: “Doamne, lasă-l și anul acesta, până ce voi săpa în jurul lui și-l voi fertiliza. ");
INSERT INTO ronlsb_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Dacă va da rod, bine; dacă nu, după aceea îl poți tăia'”.” ");
INSERT INTO ronlsb_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Învăța în una din sinagogi, în ziua de Sabat. ");
INSERT INTO ronlsb_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Și iată că era o femeie care avea un duh de slăbiciune de optsprezece ani. Era încovoiată și nu se putea în niciun fel îndrepta. ");
INSERT INTO ronlsb_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Când a văzut-o, Isus a chemat-o și i-a spus: “Femeie, te-ai eliberat de boala ta”. ");
INSERT INTO ronlsb_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Și-a pus mâinile peste ea, și imediat ea s-a ridicat în picioare și a slăvit pe Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Șeful sinagogii, indignat că Iisus vindecase în ziua Sabatului, a zis mulțimii: “Sunt șase zile în care trebuie să se lucreze. De aceea, veniți în acele zile și vindecați-vă, și nu în ziua de Sabat!” ");
INSERT INTO ronlsb_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","De aceea Domnul i-a răspuns: “Fățarnicilor! Oare nu-și eliberează fiecare dintre voi boul sau măgarul din grajd în ziua de Sabat și nu-l duce la apă? ");
INSERT INTO ronlsb_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Oare nu ar trebui ca această femeie, fiind o fiică a lui Avraam, pe care Satana a legat-o optsprezece ani lungi, să fie eliberată din această robie în ziua de Sabat?” ");
INSERT INTO ronlsb_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Pe când spunea el aceste lucruri, toți potrivnicii lui au fost dezamăgiți, și toată mulțimea s-a bucurat de toate lucrurile glorioase pe care le făcuse el. ");
INSERT INTO ronlsb_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","El a zis: “Cum este Împărăția lui Dumnezeu? Cu ce să o compar? ");
INSERT INTO ronlsb_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Se aseamănă cu un grăunte de muștar pe care l-a luat un om și l-a pus în grădina lui. Acesta a crescut și a devenit un copac mare, iar păsările cerului locuiesc în ramurile lui.” ");
INSERT INTO ronlsb_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Și a zis iarăși: “Cu ce să compar Împărăția lui Dumnezeu? ");
INSERT INTO ronlsb_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ea se aseamănă cu drojdia, pe care a luat-o o femeie și a ascuns-o în trei măsuri de făină, până ce a fost toată leșinată.” ");
INSERT INTO ronlsb_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Și mergea prin cetăți și sate, învățând și mergând până la Ierusalim. ");
INSERT INTO ronlsb_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Cineva i-a zis: “Doamne, sunt puțini cei care se mântuiesc?” El le-a zis: ");
INSERT INTO ronlsb_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Străduiți-vă să intrați pe ușa cea strâmtă, căci vă spun că mulți vor căuta să intre și nu vor putea. ");
INSERT INTO ronlsb_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","După ce se va ridica stăpânul casei și va închide ușa, iar voi veți începe să stați afară și să bateți la ușă, zicând: “Doamne, Doamne, deschide-ne!”, atunci el vă va răspunde și vă va spune: “Nu vă cunosc și nu știu de unde veniți”. ");
INSERT INTO ronlsb_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Atunci veți începe să spuneți: “Am mâncat și am băut în prezența ta și ai învățat pe străzile noastre. ");
INSERT INTO ronlsb_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","El va răspunde: 'Vă spun că nu știu de unde veniți. Depărtați-vă de la Mine, voi toți lucrătorii nelegiuirii'. ");
INSERT INTO ronlsb_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Va fi plâns și scrâșnire de dinți când veți vedea pe Avraam, pe Isaac, pe Iacov și pe toți profeții în Împărăția lui Dumnezeu, iar voi înșivă veți fi aruncați afară. ");
INSERT INTO ronlsb_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ei vor veni de la răsărit, de la apus, de la nord și de la sud și se vor așeza în Împărăția lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Iată, unii dintre cei din urmă vor fi cei dintâi, iar unii dintre cei dintâi vor fi cei din urmă.” ");
INSERT INTO ronlsb_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","În aceeași zi, au venit niște farisei și I-au zis: “Ieși de aici și pleacă, căci Irod vrea să Te omoare.” ");
INSERT INTO ronlsb_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","El le-a zis: “Duceți-vă și spuneți vulpii aceleia: “Iată că astăzi și mâine scot demoni și fac vindecări, iar a treia zi îmi termin misiunea. ");
INSERT INTO ronlsb_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Cu toate acestea, trebuie să-mi continui drumul astăzi, mâine și poimâine și poimâine, căci nu se poate ca un profet să piară în afara Ierusalimului'. ");
INSERT INTO ronlsb_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Ierusalime, Ierusalime, Ierusalime, tu care ucizi pe prooroci și ucizi cu pietre pe cei trimiși la ea! De câte ori am vrut să-ți adun copiii, ca o găină care-și adună puii sub aripi, și tu ai refuzat! ");
INSERT INTO ronlsb_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Iată, casa ta este lăsată pustie pentru tine. Vă spun că nu mă veți vedea până când nu veți spune: “Binecuvântat este cel care vine în numele Domnului!”.” ");
INSERT INTO ronlsb_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Când a intrat în casa unuia dintre fruntașii fariseilor, în ziua de Sabat, ca să mănânce pâine, ei Îl urmăreau. ");
INSERT INTO ronlsb_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Iată că un om care avea hidropizie era în fața lui. ");
INSERT INTO ronlsb_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Isus, răspunzând, a vorbit cu juriștii și cu fariseii și le-a zis: “Este îngăduit să vindeci în Sabat?” ");
INSERT INTO ronlsb_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Dar ei au tăcut. L-a luat, l-a vindecat și l-a lăsat să plece. ");
INSERT INTO ronlsb_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","El le-a răspuns: “Cine dintre voi, dacă fiul său sau boul său ar cădea într-o fântână, nu l-ar scoate imediat într-o zi de Sabat?” ");
INSERT INTO ronlsb_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Nu puteau să-i răspundă la aceste lucruri. ");
INSERT INTO ronlsb_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","El a spus o pildă celor invitați, când a observat că ei își aleg locurile cele mai bune și le-a zis: ");
INSERT INTO ronlsb_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Când sunteți invitați de cineva la o nuntă, nu vă așezați pe locul cel mai bun, căci poate că va fi invitat cineva mai de seamă decât voi, ");
INSERT INTO ronlsb_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","iar cel care v-a invitat pe amândoi va veni și vă va spune: “Faceți loc pentru acesta”. Atunci ați începe, cu rușine, să ocupați locul cel mai de jos. ");
INSERT INTO ronlsb_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Dar când ești invitat, du-te și stai în locul cel mai de jos, pentru ca, atunci când va veni cel care te-a invitat, să-ți spună: “Prietene, urcă-te mai sus”. Atunci vei fi onorat în prezența tuturor celor care stau la masă cu tine. ");
INSERT INTO ronlsb_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Căci oricine se înalță va fi smerit, iar oricine se smerește va fi înălțat.” ");
INSERT INTO ronlsb_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Și a mai zis celui care-l invitase: “Când faci o cină sau un prânz, nu chema pe prietenii tăi, nici pe frații tăi, nici pe rudele tale, nici pe vecinii tăi bogați, căci poate că și ei îți vor întoarce favoarea și-ți vor plăti. ");
INSERT INTO ronlsb_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ci, când faci un ospăț, invită-i pe săraci, pe mutilați, pe șchiopi sau pe orbi; ");
INSERT INTO ronlsb_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","și vei fi binecuvântat, pentru că ei nu au resurse să-ți dea înapoi. Căci veți fi răsplătiți la învierea celor drepți.” ");
INSERT INTO ronlsb_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Unul din cei ce ședeau la masă cu El, auzind aceste lucruri, i-a zis: “Ferice de cel ce va petrece în Împărăția lui Dumnezeu!” ");
INSERT INTO ronlsb_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Dar El i-a zis: “Un om a făcut o cină mare și a invitat multă lume. ");
INSERT INTO ronlsb_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","La ora cinei, a trimis pe slujitorul său să le spună celor invitați: “Veniți, căci totul este gata acum. ");
INSERT INTO ronlsb_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Toți, ca unul singur, au început să se scuze. “Cel dintâi i-a spus: “Am cumpărat un câmp și trebuie să mă duc să-l văd. Te rog să mă scuzi'. ");
INSERT INTO ronlsb_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Altul a zis: “Am cumpărat cinci juguri de boi și trebuie să mă duc să le încerc. Te rog să mă scuzi.'' ");
INSERT INTO ronlsb_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Altul a zis: “M-am căsătorit cu o nevastă și nu pot să vin. ");
INSERT INTO ronlsb_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Și a venit robul acela și a spus aceste lucruri domnului său. Atunci stăpânul casei, mâniindu-se, a zis robului său: “Ieși repede pe străzile și pe ulițele cetății și adu pe cei săraci, schilozi, orbi și șchiopi. ");
INSERT INTO ronlsb_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Robul a zis: “Doamne, s-a făcut cum ai poruncit și mai este loc. ");
INSERT INTO ronlsb_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Domnul a zis robului: “Ieși pe drumuri și pe ulițe și silește-i să intre, ca să se umple casa mea. ");
INSERT INTO ronlsb_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Căci îți spun că niciunul dintre acei oameni care au fost invitați nu va gusta din cina mea.”” ");
INSERT INTO ronlsb_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","O mare mulțime de oameni mergeau cu El. El s-a întors și le-a zis: ");
INSERT INTO ronlsb_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Dacă vine cineva la Mine și nu face abstracție de tatăl său, de mama sa, de soția sa, de copii, de frați și de surori, da, și chiar și de viața sa, nu poate fi ucenicul Meu. ");
INSERT INTO ronlsb_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Oricine nu-și poartă propria cruce și nu vine după mine, nu poate fi discipolul meu. ");
INSERT INTO ronlsb_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Căci care dintre voi, dorind să zidească un turn, nu stă mai întâi și numără costurile, ca să vadă dacă are destul pentru a-l termina? ");
INSERT INTO ronlsb_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Sau poate că, după ce a pus temelia și nu poate să o termine, toți cei care îl văd încep să râdă de el, ");
INSERT INTO ronlsb_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","spunând: “Omul acesta a început să zidească și nu a putut să termine”. ");
INSERT INTO ronlsb_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Sau ce rege, când merge să se întâlnească cu un alt rege în război, nu se așează mai întâi și nu se gândește dacă este în stare cu zece mii de oameni să-l înfrunte pe cel care vine împotriva lui cu douăzeci de mii? ");
INSERT INTO ronlsb_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Sau altfel, pe când celălalt este încă la mare distanță, trimite un trimis și cere condiții de pace. ");
INSERT INTO ronlsb_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Așadar, oricine dintre voi care nu renunță la tot ceea ce are, nu poate fi discipolul meu. ");
INSERT INTO ronlsb_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Sarea este bună, dar dacă sarea devine plată și fără gust, cu ce o condimentezi? ");
INSERT INTO ronlsb_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Eanu este potrivită nici pentru pământ, nici pentru grămada de gunoi de grajd. Ea este aruncată la gunoi. Cine are urechi de auzit, să audă.” ");
INSERT INTO ronlsb_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Și toți vameșii și păcătoșii se apropiau de El ca să-L asculte. ");
INSERT INTO ronlsb_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Fariseii și cărturarii murmurau și ziceau: “Omul acesta îi primește pe păcătoși și mănâncă cu ei.” ");
INSERT INTO ronlsb_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Și le-a spus pilda aceasta: ");
INSERT INTO ronlsb_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Cine dintre voi, dacă ar avea o sută de oi și ar pierde una dintre ele, nu ar lăsa cele nouăzeci și nouă în pustiu și nu s-ar duce după cea pierdută, până o va găsi? ");
INSERT INTO ronlsb_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","După ce o găsește, o poartă pe umeri, bucurându-se. ");
INSERT INTO ronlsb_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Când se întoarce acasă, își cheamă prietenii și vecinii, spunându-le: “Bucurați-vă cu mine, căci am găsit oaia mea care era pierdută!”. ");
INSERT INTO ronlsb_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Eu vă spun că și așa va fi mai multă bucurie în cer pentru un singur păcătos care se pocăiește, decât pentru nouăzeci și nouă de oameni drepți care nu au nevoie de pocăință. ");
INSERT INTO ronlsb_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Sau ce femeie, dacă ar avea zece drahme, dacă ar pierde o drahmă, nu ar aprinde o lampă, nu ar mătura casa și nu ar căuta cu sârguință până ce ar găsi-o? ");
INSERT INTO ronlsb_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","După ce o găsește, își cheamă prietenele și vecinele, spunând: “Bucurați-vă cu mine, căci am găsit drahma pe care o pierdusem!”. ");
INSERT INTO ronlsb_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Tot așa, vă spun, există bucurie în prezența îngerilor lui Dumnezeu pentru un păcătos care se pocăiește.” ");
INSERT INTO ronlsb_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","El a zis: “Un om avea doi fii. ");
INSERT INTO ronlsb_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Cel mai tânăr dintre ei a zis tatălui său: “Tată, dă-mi partea mea din averea ta. Așa că a împărțit între ei averea lui. ");
INSERT INTO ronlsb_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Nu după multe zile, fiul cel mai tânăr a adunat toate acestea și a călătorit într-o țară îndepărtată. Acolo și-a risipit averea cu un trai desfrânat. ");
INSERT INTO ronlsb_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","După ce a cheltuit totul, s-a ivit o foamete cruntă în țara aceea și a început să fie în nevoie. ");
INSERT INTO ronlsb_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","S-a dus și s-a unit cu unul dintre cetățenii acelei țări, care l-a trimis pe câmpurile sale să hrănească porcii. ");
INSERT INTO ronlsb_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","El a vrut să-și umple burta cu păstăile pe care le mâncau porcii, dar nimeni nu i-a dat nimic. ");
INSERT INTO ronlsb_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Când și-a revenit, a zis: “Câți dintre angajații tatălui meu au pâine de prisos, iar eu mor de foame! ");
INSERT INTO ronlsb_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mă voi scula și mă voi duce la tatăl meu și-i voi spune: “Tată, am păcătuit împotriva cerului și în fața ta. ");
INSERT INTO ronlsb_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nu mai sunt vrednic să fiu numit fiul tău. Fă-mă ca pe unul dintre robii tăi angajați!””'”. ");
INSERT INTO ronlsb_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“S-a sculat și a venit la tatăl său. Dar, pe când era încă departe, tatăl său l-a văzut și, mișcat de milă, a alergat, s-a aruncat la gâtul lui și l-a sărutat. ");
INSERT INTO ronlsb_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Fiul i-a zis: “Tată, am păcătuit împotriva cerului și în fața ta. Nu mai sunt vrednic să mă numesc fiul tău'. ");
INSERT INTO ronlsb_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Dar tatăl a zis slugilor sale: “Scoateți cea mai bună haină și îmbrăcați-l. Puneți-i un inel la mână și sandale la picioare. ");
INSERT INTO ronlsb_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Aduceți vițelul îngrășat, înjunghiați-l, să mâncăm și să sărbătorim; ");
INSERT INTO ronlsb_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","căci acesta, fiul meu, a fost mort și a înviat. Era pierdut și s-a regăsit”. Atunci au început să sărbătorească. ");
INSERT INTO ronlsb_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Și fiul său cel mare era la câmp. Când s-a apropiat de casă, a auzit muzică și dansuri. ");
INSERT INTO ronlsb_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","A chemat la el pe unul dintre servitori și l-a întrebat ce se întâmplă. ");
INSERT INTO ronlsb_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Acesta i-a spus: “A venit fratele tău, iar tatăl tău a omorât vițelul îngrășat, pentru că l-a primit înapoi sănătos și nevătămat. ");
INSERT INTO ronlsb_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Dar el s-a mâniat și nu a vrut să intre. De aceea tatăl său a ieșit și l-a rugat. ");
INSERT INTO ronlsb_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Dar el a răspuns tatălui său: “Iată, în acești mulți ani te-am slujit și niciodată nu am nesocotit o poruncă de-a ta, dar niciodată nu mi-ai dat un țap, ca să sărbătoresc cu prietenii mei. ");
INSERT INTO ronlsb_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Dar când a venit acest fiu al tău, care ți-a devorat traiul cu prostituatele, ai ucis vițelul îngrășat pentru el. ");
INSERT INTO ronlsb_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","El i-a zis: “Fiule, tu ești totdeauna cu mine și tot ce este al meu este al tău. ");
INSERT INTO ronlsb_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Darse cuvenea să sărbătorim și să ne bucurăm, pentru că acesta, fratele tău, era mort și a înviat. Era pierdut și s-a găsit”.” ");
INSERT INTO ronlsb_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Și a mai zis ucenicilor Săi: “Era un om bogat care avea un administrator. I s-a făcut o acuzație că acesta își risipește averile. ");
INSERT INTO ronlsb_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","El l-a chemat și i-a zis: “Ce este aceasta pe care o aud despre tine? Dă socoteală de administrarea ta, pentru că nu mai poți fi administrator'. ");
INSERT INTO ronlsb_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Directorul și-a zis în sinea lui: “Ce voi face, dacă domnul meu îmi ia funcția de director? Nu am putere să sap. Mi-e rușine să cerșesc. ");
INSERT INTO ronlsb_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Știu ce voi face, pentru ca, atunci când voi fi înlăturat de la conducere, să mă primească în casele lor. ");
INSERT INTO ronlsb_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Chemând la el pe fiecare dintre datornicii stăpânului său, l-a întrebat pe primul: “Cât îi datorezi stăpânului meu?” ");
INSERT INTO ronlsb_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","El a răspuns: “O sută de batoane de ulei”. El i-a zis: 'Ia-ți nota de plată, așează-te repede și scrie cincizeci'. ");
INSERT INTO ronlsb_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Apoi l-a întrebat pe altul: “Cât datorezi?”. El a răspuns: 'O sută de cors de grâu'. El i-a zis: “Ia-ți nota de plată și scrie optzeci”. ");
INSERT INTO ronlsb_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Domnul său l-a lăudat pe administratorul necinstit pentru că a procedat cu înțelepciune, căci copiii acestei lumi sunt, în neamul lor, mai înțelepți decât copiii luminii. ");
INSERT INTO ronlsb_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Eu vă spun: faceți-vă prieteni prin intermediul bogățiilor nedrepte, pentru ca, atunci când veți eșua, ei să vă primească în corturile veșnice. ");
INSERT INTO ronlsb_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Cine este credincios în foarte puțin, este credincios și în mult. Cine este necinstit în foarte puțin, este necinstit și în mult. ");
INSERT INTO ronlsb_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Așadar, dacă n-ați fost credincioși în bogăția nedreaptă, cine vă va încredința adevăratele bogății? ");
INSERT INTO ronlsb_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Dacă n-ai fost credincios în ceea ce este al altuia, cine îți va da ceea ce este al tău? ");
INSERT INTO ronlsb_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Nici un slujitor nu poate sluji la doi stăpâni, căci ori îl va urî pe unul și-l va iubi pe celălalt, ori se va ține de unul și-l va disprețui pe celălalt. Nu ești în stare să slujești lui Dumnezeu și lui Mamona.” ");
INSERT INTO ronlsb_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Fariseii, care erau iubitori de bani, au auzit și ei toate acestea și au luat în derâdere pe Isus. ");
INSERT INTO ronlsb_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","El le-a zis: “Voi sunteți cei care vă justificați în fața oamenilor, dar Dumnezeu vă cunoaște inimile. Căci ceea ce este înălțat printre oameni este o urâciune în ochii lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Legea și proorocii au fost până la Ioan. De atunci se propovăduiește Vestea cea Bună a Împărăției lui Dumnezeu și fiecare își forțează intrarea în ea. ");
INSERT INTO ronlsb_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Dar este mai ușor să treacă cerul și pământul, decât să cadă o mică lovitură de stilou din lege. ");
INSERT INTO ronlsb_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Oricine divorțează de nevastă-sa și se căsătorește cu alta, săvârșește adulter. Cine se căsătorește cu una care a divorțat de un soț comite adulter. ");
INSERT INTO ronlsb_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Era un om bogat, îmbrăcat în purpură și în in subțire și trăind în fiecare zi în lux. ");
INSERT INTO ronlsb_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Un cerșetor, numit Lazăr, a fost dus la poarta lui, plin de răni, ");
INSERT INTO ronlsb_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","și dorind să fie hrănit cu firimiturile care cădeau de la masa bogatului. Da, chiar și câinii veneau și îi lingeau rănile. ");
INSERT INTO ronlsb_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Cerșetorul a murit și a fost dus de îngeri la sânul lui Avraam. Și bogatul a murit și el și a fost îngropat. ");
INSERT INTO ronlsb_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","În Hades, și-a ridicat ochii, fiind în chinuri, și a văzut departe pe Avraam și pe Lazăr la sânul lui. ");
INSERT INTO ronlsb_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","El a strigat și a zis: “Părinte Avraam, ai milă de mine și trimite-l pe Lazăr, ca să înmoaie vârful degetului în apă și să-mi răcorească limba! Căci sunt în chinuri în această flacără!”. ");
INSERT INTO ronlsb_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Dar Avraam a zis: “Fiule, adu-ți aminte că tu ai primit în viața ta cele bune, iar Lazăr, la fel, cele rele. Dar iată că el este acum mângâiat, iar tu ești în chinuri. ");
INSERT INTO ronlsb_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","În afară de toate acestea, între noi și voi este fixată o prăpastie mare, încât cei care vor să treacă de aici la voi nu pot, și nimeni nu poate trece de acolo la noi'. ");
INSERT INTO ronlsb_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","El a zis: “Te rog, părinte, să-l trimiți la casa tatălui meu, ");
INSERT INTO ronlsb_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","căci am cinci frați, ca să le dea mărturie, ca să nu ajungă și ei în locul acesta de chin. ");
INSERT INTO ronlsb_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Avraam i-a zis: “Ei au pe Moise și pe prooroci. Să-i asculte pe ei!”. ");
INSERT INTO ronlsb_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","El a zis: “Nu, părinte Avraam, dar dacă se va duce la ei cineva din morți, se vor pocăi. ");
INSERT INTO ronlsb_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","El i-a zis: “Dacă nu ascultă de Moise și de prooroci, nici dacă va învia unul din morți nu se vor lăsa convinși.” ");
INSERT INTO ronlsb_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","El a zis ucenicilor: “Nu se poate să nu vină prilejuri de poticnire, ci vai de cel prin care vin! ");
INSERT INTO ronlsb_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ar fi mai bine pentru el să i se atârne de gât o piatră de moară și să fie aruncat în mare, decât să facă să se poticnească unul dintre acești micuți. ");
INSERT INTO ronlsb_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Fiți atenți. Dacă fratele tău păcătuiește împotriva ta, mustră-l. Dacă se pocăiește, iartă-l. ");
INSERT INTO ronlsb_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Dacă va păcătui împotriva ta de șapte ori într-o zi și de șapte ori se va întoarce, spunând: “Mă pocăiesc”, să-l ierți.” ");
INSERT INTO ronlsb_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Apostolii au zis Domnului: “Mărește-ne credința!” ");
INSERT INTO ronlsb_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Domnul a zis: “Dacă ai avea credință ca un grăunte de muștar, ai spune acestui sicomor: “Dezrădăcinează-te și sădește-te în mare”, și el te-ar asculta. ");
INSERT INTO ronlsb_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Dar cine dintre voi, având un rob care ară sau păzește oile, va spune, când vine de la câmp: 'Vino îndată și stai la masă'? ");
INSERT INTO ronlsb_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Nu i-ar spune mai degrabă: 'Pregătește-mi cina, îmbracă-te cum se cuvine și servește-mă în timp ce mănânc și beau. După aceea vei mânca și vei bea'?” ");
INSERT INTO ronlsb_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Îi mulțumește oare acelui servitor pentru că a făcut ceea ce i s-a poruncit? Cred că nu. ");
INSERT INTO ronlsb_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Tot așa și voi, după ce ați făcut tot ce vi s-a poruncit, spuneți: 'Suntem niște servitori nevrednici. Ne-am făcut datoria'”. ");
INSERT INTO ronlsb_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Pe când se îndrepta spre Ierusalim, a trecut pe lângă hotarele Samariei și ale Galileii. ");
INSERT INTO ronlsb_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Pe când intra într-un sat, l-a întâmpinat zece bărbați leproși, care stăteau la distanță. ");
INSERT INTO ronlsb_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ei și-au ridicat glasul și au zis: “Isuse, Învățătorule, ai milă de noi!” ");
INSERT INTO ronlsb_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Când i-a văzut, le-a zis: “Duceți-vă și arătați-vă la preoți.” Pe măsură ce se duceau, au fost curățați. ");
INSERT INTO ronlsb_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Unul dintre ei, când a văzut că s-a vindecat, s-a întors înapoi, slăvind pe Dumnezeu cu glas tare. ");
INSERT INTO ronlsb_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","A căzut cu fața la picioarele lui Isus, mulțumindu-i; și era un samaritean. ");
INSERT INTO ronlsb_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Isus a răspuns: “Nu au fost curățați cei zece? Dar unde sunt cei nouă? ");
INSERT INTO ronlsb_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Nu s-a găsit niciunul care să se întoarcă să dea slavă lui Dumnezeu, în afară de acest străin?” ");
INSERT INTO ronlsb_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Atunci i-a zis: “Scoală-te și du-te. Credința ta te-a vindecat”. ");
INSERT INTO ronlsb_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Fiind întrebat de farisei când va veni Împărăția lui Dumnezeu, El le-a răspuns: “Împărăția lui Dumnezeu nu vine cu observație; ");
INSERT INTO ronlsb_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","nici nu vor spune: “Priviți, aici!” sau “Priviți, acolo!”, căci iată, Împărăția lui Dumnezeu este înăuntrul vostru”. ");
INSERT INTO ronlsb_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","El a zis ucenicilor: “Vor veni zile când veți dori să vedeți una din zilele Fiului Omului și nu o veți vedea. ");
INSERT INTO ronlsb_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ei vă vor spune: “Uite, aici!” sau “Uite, acolo!”. Nu plecați și nu mergeți după ei, nici nu vă luați după ei, ");
INSERT INTO ronlsb_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","pentru că, așa cum fulgerul, când strălucește dintr-o parte de sub cer, strălucește în altă parte de sub cer, așa va fi și Fiul Omului în ziua lui. ");
INSERT INTO ronlsb_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Dar, mai întâi, trebuie să sufere multe și să fie respins de această generație. ");
INSERT INTO ronlsb_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Cum a fost în zilele lui Noe, așa va fi și în zilele Fiului Omului. ");
INSERT INTO ronlsb_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Au mâncat, au băut, s-au căsătorit și s-au dat în căsătorie până în ziua în care Noe a intrat în corabie și a venit potopul și i-a distrus pe toți. ");
INSERT INTO ronlsb_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Tot așa, așa a fost și în zilele lui Lot: au mâncat, au băut, au cumpărat, au vândut, au plantat, au zidit; ");
INSERT INTO ronlsb_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","dar în ziua în care Lot a ieșit din Sodoma, a plouat foc și sulf din cer și i-a nimicit pe toți. ");
INSERT INTO ronlsb_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","La fel se va întâmpla și în ziua în care se va arăta Fiul Omului. ");
INSERT INTO ronlsb_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","În ziua aceea, cel care va fi pe acoperișul casei și cu bunurile sale în casă, să nu se coboare să le ia. Cel care va fi pe câmp, la fel, să nu se întoarcă înapoi. ");
INSERT INTO ronlsb_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Adu-ți aminte de soția lui Lot! ");
INSERT INTO ronlsb_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Cine caută să-și salveze viața o pierde, dar cine își pierde viața o păstrează. ");
INSERT INTO ronlsb_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Vă spun că, în noaptea aceea, vor fi doi oameni în același pat. Unul va fi luat și celălalt va fi lăsat. ");
INSERT INTO ronlsb_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Vor fi doi care vor măcina grâu împreună. Unul va fi luat și celălalt va rămâne.” ");
INSERT INTO ronlsb_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ei, răspunzând, L-au întrebat: “Unde, Doamne?” El le-a spus: “Unde este trupul, acolo se vor aduna și vulturii”. ");
INSERT INTO ronlsb_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Și le-a mai spus o pildă, ca să se roage mereu și să nu se dea bătut, ");
INSERT INTO ronlsb_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","zicând: “Într-o cetate era un judecător care nu se temea de Dumnezeu și nu avea respect față de oameni. ");
INSERT INTO ronlsb_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","În acel oraș era o văduvă care venea adesea la el și îi spunea: “Apără-mă de adversarul meu!”. ");
INSERT INTO ronlsb_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","El nu a vrut pentru o vreme, dar după aceea și-a zis: “Deși nu mă tem de Dumnezeu și nici nu respect pe om, ");
INSERT INTO ronlsb_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","totuși, pentru că această văduvă mă deranjează, o voi apăra, altfel mă va obosi prin venirea ei continuă.”” ");
INSERT INTO ronlsb_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Domnul a zis: “Ascultă ce spune judecătorul nedrept. ");
INSERT INTO ronlsb_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Nu-i va răzbuna oare Dumnezeu pe aleșii Săi care strigă la El zi și noapte și totuși are răbdare cu ei? ");
INSERT INTO ronlsb_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Eu vă spun că îi va răzbuna repede. Cu toate acestea, când va veni Fiul Omului, va găsi el credință pe pământ?” ");
INSERT INTO ronlsb_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Și a spus pilda aceasta unor oameni care erau convinși de dreptatea lor și care disprețuiau pe toți ceilalți: ");
INSERT INTO ronlsb_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Doi oameni s-au urcat în templu să se roage: unul era fariseu, iar celălalt vameș. ");
INSERT INTO ronlsb_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fariseul stătea în picioare și se ruga de unul singur, așa: 'Doamne, îți mulțumesc că nu sunt ca ceilalți oameni: șantajiști, nedrepți, adulteri, sau chiar ca acest vameș. ");
INSERT INTO ronlsb_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Eu postesc de două ori pe săptămână. Dau zeciuială din tot ce primesc'. ");
INSERT INTO ronlsb_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Dar vameșul, care stătea departe, nici măcar nu voia să-și ridice ochii spre cer, ci își bătea pieptul, zicând: 'Doamne, ai milă de mine, păcătosul! ");
INSERT INTO ronlsb_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Vă spun că acesta s-a coborât la casa lui mai degrabă îndreptățit decât celălalt; căci oricine se înalță va fi smerit, dar cel ce se smerește va fi înălțat.” ");
INSERT INTO ronlsb_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Îi aduceau și pruncii lor, ca să se atingă de ei. Dar, văzând aceasta, discipolii i-au mustrat. ");
INSERT INTO ronlsb_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Isus i-a chemat și le-a zis: “Lăsați copiii să vină la Mine și nu-i împiedicați, căci Împărăția lui Dumnezeu este a unora ca aceștia. ");
INSERT INTO ronlsb_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Mai mult ca sigur, vă spun că oricine nu primește Împărăția lui Dumnezeu ca un copilaș, nu va intra nicidecum în ea.” ");
INSERT INTO ronlsb_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Un domnitor L-a întrebat: “Învățătorule, ce să fac ca să moștenesc viața veșnică?” ");
INSERT INTO ronlsb_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Isus l-a întrebat: “De ce Mă numești bun? Nimeni nu este bun, în afară de unul singur: Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Tu cunoști poruncile: Să nu comiți adulter, să nu ucizi, să nu furi, să nu depui mărturie mincinoasă, să cinstești pe tatăl tău și pe mama ta.” ");
INSERT INTO ronlsb_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","El a zis: “Am observat toate aceste lucruri din tinerețea mea.” ");
INSERT INTO ronlsb_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Isus, auzind acestea, i-a zis: “Un singur lucru îți lipsește încă. Vinde tot ce ai și dă-le săracilor. Atunci vei avea o comoară în ceruri; apoi vino și urmează-mă.” ");
INSERT INTO ronlsb_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Dar când a auzit acestea, s-a întristat foarte tare, căci era foarte bogat. ");
INSERT INTO ronlsb_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Isus, văzând că se întrista foarte tare, a zis: “Cât de greu intră în Împărăția lui Dumnezeu cei ce au bogății! ");
INSERT INTO ronlsb_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Căci este mai ușor pentru o cămilă să intre prin urechea unui ac decât pentru un om bogat să intre în Împărăția lui Dumnezeu.” ");
INSERT INTO ronlsb_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Și cei ce au auzit au zis: “Atunci cine poate fi mântuit?” ");
INSERT INTO ronlsb_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Dar El a zis: “Ceea ce este cu neputință la oameni este cu putință la Dumnezeu.” ");
INSERT INTO ronlsb_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Petru a zis: “Uite, am lăsat totul și am venit după Tine.” ");
INSERT INTO ronlsb_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","El le-a zis: “Adevărat vă spun că nu este nimeni care a lăsat casă, sau nevastă, sau frați, sau părinți, sau copii, pentru Împărăția lui Dumnezeu, ");
INSERT INTO ronlsb_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","care să nu primească de multe ori mai mult în acest timp și în lumea viitoare viața veșnică.” ");
INSERT INTO ronlsb_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Apoi a luat pe cei doisprezece deoparte și le-a zis: “Iată, ne vom sui la Ierusalim și se vor împlini toate cele scrise prin prooroci despre Fiul Omului. ");
INSERT INTO ronlsb_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Căci El va fi predat neamurilor, va fi batjocorit, tratat cu rușine și scuipat. ");
INSERT INTO ronlsb_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Îl vor biciui și îl vor ucide. A treia zi, va învia.” ");
INSERT INTO ronlsb_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ei n-au înțeles nimic din toate acestea. Acest cuvânt le-a fost ascuns și nu au înțeles ce se spunea. ");
INSERT INTO ronlsb_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Pe când se apropia de Ierihon, un orb stătea pe drum și cerșea. ");
INSERT INTO ronlsb_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Auzind o mulțime care trecea, a întrebat ce înseamnă aceasta. ");
INSERT INTO ronlsb_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ei i-au spus că Isus din Nazaret trecea pe acolo. ");
INSERT INTO ronlsb_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","El a strigat: “Isuse, Fiul lui David, ai milă de mine!” ");
INSERT INTO ronlsb_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Cei care mergeau în frunte îl mustrau, ca să tacă; dar el striga și mai tare: “Fiul lui David, ai milă de mine!” ");
INSERT INTO ronlsb_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Isus, stând în picioare, a poruncit să fie adus la El. După ce s-a apropiat, l-a întrebat: ");
INSERT INTO ronlsb_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ce vrei să fac?”. El a spus: “Doamne, ca să văd din nou”. ");
INSERT INTO ronlsb_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Isus i-a zis: “Primește-ți vederea. Credința ta te-a vindecat”. ");
INSERT INTO ronlsb_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Și îndată și-a recăpătat vederea și a mers după el, slăvind pe Dumnezeu. Tot poporul, când a văzut, a lăudat pe Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","El a intrat și trecea prin Ierihon. ");
INSERT INTO ronlsb_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Era acolo un om cu numele Zaheu. Era un mare vameș și era bogat. ");
INSERT INTO ronlsb_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Încerca să vadă cine este Isus și nu putea din cauza mulțimii, pentru că era scund. ");
INSERT INTO ronlsb_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","A alergat mai departe și s-a urcat într-un sicomor ca să îl vadă, pentru că urma să treacă pe acolo. ");
INSERT INTO ronlsb_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Când a ajuns în acel loc, Isus s-a uitat în sus, l-a văzut și i-a zis: “Zaheu, grăbește-te și coboară-te, căci astăzi trebuie să rămân în casa ta.” ");
INSERT INTO ronlsb_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","El s-a grăbit, a coborât și l-a primit cu bucurie. ");
INSERT INTO ronlsb_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Când l-au văzut, toți au murmurat, zicând: “A intrat să se cazeze la un om păcătos”. ");
INSERT INTO ronlsb_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zacheu a stat în picioare și a zis Domnului: “Iată, Doamne, jumătate din averea mea o dau săracilor. Dacă am pretins ceva pe nedrept de la cineva, îi dau înapoi de patru ori mai mult.” ");
INSERT INTO ronlsb_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Isus i-a zis: “Astăzi a venit mântuirea în casa aceasta, pentru că și el este fiu al lui Avraam. ");
INSERT INTO ronlsb_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Căci Fiul Omului a venit să caute și să salveze ceea ce era pierdut.” ");
INSERT INTO ronlsb_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Auzind ei aceste lucruri, a continuat și a spus o pildă, pentru că era aproape de Ierusalim și ei credeau că Împărăția lui Dumnezeu se va arăta imediat. ");
INSERT INTO ronlsb_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","El a spus deci: “Un oarecare nobil s-a dus într-o țară îndepărtată ca să primească pentru sine o împărăție și să se întoarcă. ");
INSERT INTO ronlsb_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","El a chemat zece slujitori de-ai săi, le-a dat zece monede de mina și le-a spus: “Faceți afaceri până când voi veni eu”. ");
INSERT INTO ronlsb_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Dar cetățenii lui l-au urât și au trimis un trimis după el, spunând: 'Nu vrem ca acest om să domnească peste noi'. ");
INSERT INTO ronlsb_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","După ce s-a întors, după ce a primit împărăția, a poruncit să fie chemați la el acești slujitori, cărora le dăduse banii, ca să știe ce au câștigat prin negoțul lor. ");
INSERT INTO ronlsb_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Cel dintâi a venit înaintea lui, spunând: “Doamne, mina ta a făcut încă zece mine. ");
INSERT INTO ronlsb_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","El i-a zis: “Bine ai făcut, slugă bună! Pentru că ai fost găsit credincios cu foarte puțin, vei avea autoritate peste zece cetăți'. ");
INSERT INTO ronlsb_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Al doilea a venit și a zis: “Mina ta, Doamne, a făcut cinci mine. ");
INSERT INTO ronlsb_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Și i-a zis: “Și tu vei fi peste cinci cetăți. ");
INSERT INTO ronlsb_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Și a venit un altul, zicând: “Doamne, iată mina ta, pe care o țineam în batistă, ");
INSERT INTO ronlsb_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","căci mă temeam de tine, pentru că ești un om exigent. Tu ridici ceea ce n-ai pus și culegi ceea ce n-ai semănat'. ");
INSERT INTO ronlsb_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","El i-a zis: “Din gura ta te voi judeca, rob rău, din gura ta te voi judeca! Știai că sunt un om exigent, că iau ce nu am pus și culeg ce nu am semănat. ");
INSERT INTO ronlsb_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Atunci de ce nu mi-ai depus banii la bancă și, la venirea mea, aș fi putut câștiga dobândă?” ");
INSERT INTO ronlsb_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","El a zis celor care stăteau de față: “Luați-i mina și dați-o celui care are zece mine. ");
INSERT INTO ronlsb_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“I-au zis: “Doamne, are zece mine!”. ");
INSERT INTO ronlsb_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Căci Eu vă spun că oricui are, i se va da mai mult; dar celui care nu are, i se va lua chiar și ceea ce are. ");
INSERT INTO ronlsb_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Dar aduceți aici pe vrăjmașii mei care n-au vrut să domnesc peste ei și ucideți-i înaintea mea.”” ");
INSERT INTO ronlsb_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","După ce a spus acestea, a plecat înainte, urcând la Ierusalim. ");
INSERT INTO ronlsb_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Când S-a apropiat de Betfaghe și de Betania, pe muntele care se numește Măslinul, a trimis pe doi dintre ucenicii Săi, ");
INSERT INTO ronlsb_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","zicând: “Mergeți în satul de dincolo, în care, când veți intra, veți găsi legat un mânz pe care nimeni nu a șezut vreodată. Dezlegați-l și aduceți-l. ");
INSERT INTO ronlsb_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Dacă vă întreabă cineva: “De ce îl dezlegi?”, spuneți-i: “Domnul are nevoie de el”.” ");
INSERT INTO ronlsb_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Cei trimiși s-au dus și au găsit lucrurile așa cum le spusese. ");
INSERT INTO ronlsb_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Pe când dezlegau mânzul, stăpânii lui i-au întrebat: “De ce dezlegați mânzul?” ");
INSERT INTO ronlsb_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ei au răspuns: “Domnul are nevoie de el.” ");
INSERT INTO ronlsb_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Apoi l-au adus la Isus. Și-au aruncat mantiile pe mânz și l-au așezat pe Isus pe ele. ");
INSERT INTO ronlsb_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Pe când mergea, ei și-au întins mantiile pe drum. ");
INSERT INTO ronlsb_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Pe când se apropia de El, la coborârea de pe Muntele Măslinilor, toată mulțimea ucenicilor a început să se bucure și să laude pe Dumnezeu cu glas tare pentru toate minunile pe care le văzuseră, ");
INSERT INTO ronlsb_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","zicând: “Binecuvântat este Împăratul care vine în numele Domnului! Pace în ceruri și glorie în cele mai înalte!”. ");
INSERT INTO ronlsb_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Unii dintre fariseii din mulțime I-au zis: “Învățătorule, mustră pe ucenicii Tăi!” ");
INSERT INTO ronlsb_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","El le-a răspuns: “Vă spun că, dacă acestea ar tăcea, pietrele ar striga.” ");
INSERT INTO ronlsb_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Când s-a apropiat, a văzut cetatea și a plâns din cauza ei, ");
INSERT INTO ronlsb_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","zicând: “Dacă ai fi știut astăzi ce este al păcii tale! Dar acum, ele sunt ascunse de ochii tăi. ");
INSERT INTO ronlsb_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Căci vor veni zile când vrăjmașii tăi vor ridica o baricadă împotriva ta, te vor înconjura, te vor strânge din toate părțile și ");
INSERT INTO ronlsb_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","te vor trânti la pământ pe tine și pe copiii tăi din tine. Nu vor lăsa în tine piatră peste piatră, pentru că nu ai știut timpul vizitei tale.” ");
INSERT INTO ronlsb_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","El a intrat în Templu și a început să alunge pe cei ce cumpărau și vindeau în el, ");
INSERT INTO ronlsb_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","zicându-le: “Este scris: “Casa Mea este o casă de rugăciune”, iar voi ați făcut din ea o peșteră de tâlhari!”. ");
INSERT INTO ronlsb_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","El învăța în fiecare zi în Templu, dar preoții cei mai de seamă, cărturarii și cei mai de seamă din popor căutau să-L nimicească. ");
INSERT INTO ronlsb_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Nu găseau ce să facă, căci tot poporul se agăța de fiecare cuvânt pe care-l spunea. ");
INSERT INTO ronlsb_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Într-una din zilele acelea, pe când învăța pe norod în Templu și propovăduia vestea cea bună, au venit la El preoții și cărturarii și bătrânii. ");
INSERT INTO ronlsb_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ei l-au întrebat: “Spune-ne: cu ce autoritate faci aceste lucruri? Sau cine îți dă această autoritate?” ");
INSERT INTO ronlsb_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","El le-a răspuns: “Și eu vă voi pune o întrebare. Spuneți-mi: ");
INSERT INTO ronlsb_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Botezul lui Ioan a fost din cer sau de la oameni?” ");
INSERT INTO ronlsb_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ei se gândeau între ei și ziceau: “Dacă vom zice: “Din cer”, va zice: “De ce nu l-ați crezut?” ");
INSERT INTO ronlsb_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Dar dacă vom zice: “De la oameni”, tot poporul ne va ucide cu pietre, pentru că sunt încredințați că Ioan a fost prooroc”. ");
INSERT INTO ronlsb_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ei au răspuns că nu știau de unde este. ");
INSERT INTO ronlsb_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Isus le-a zis: “Nici Eu nu vă voi spune cu ce putere fac aceste lucruri.” ");
INSERT INTO ronlsb_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Și a început să spună poporului pilda aceasta: “Un om a plantat o vie, a dat-o în arendă unor agricultori și a plecat în altă țară pentru multă vreme. ");
INSERT INTO ronlsb_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","La vremea potrivită, a trimis un slujitor la fermieri pentru a-și lua partea lui din roadele viei. Dar fermierii l-au bătut și l-au trimis acasă cu mâna goală. ");
INSERT INTO ronlsb_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","A mai trimis încă un servitor, dar și pe acesta l-au bătut și l-au tratat cu rușine, și l-au trimis cu mâna goală. ");
INSERT INTO ronlsb_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","A mai trimis încă un al treilea, dar l-au rănit și pe el și l-au aruncat afară. ");
INSERT INTO ronlsb_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Stăpânul viei a zis: “Ce să fac? Voi trimite pe fiul meu iubit. Poate că, văzându-l, îl vor respecta'. ");
INSERT INTO ronlsb_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Iar țăranii, văzându-l, s-au gândit între ei și au zis: “Acesta este moștenitorul. Haideți să-l omorâm, ca moștenirea să fie a noastră.' ");
INSERT INTO ronlsb_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Atunci l-au aruncat afară din vie și l-au ucis. Ce le va face, așadar, stăpânul viei? ");
INSERT INTO ronlsb_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","El va veni și îi va nimici pe acești agricultori și va da via altora.” Când au auzit asta, au spus: “Să nu se întâmple asta niciodată!”. ");
INSERT INTO ronlsb_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Dar El, uitându-se la ei, a zis: “Ce este deci ceea ce este scris? “Piatra pe care au respins-o zidarii a fost făcută piatra de temelie? ");
INSERT INTO ronlsb_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Oricine va cădea pe piatra aceea va fi sfărâmat, dar va face praf pe oricine va cădea pe el.” ");
INSERT INTO ronlsb_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Preoții cei mai de seamă și cărturarii au căutat să pună mâna pe El chiar în ceasul acela, dar se temeau de popor, căci știau că El spusese pilda aceasta împotriva lor. ");
INSERT INTO ronlsb_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","L-au urmărit și au trimis spioni, care se prefăceau că sunt drepți, ca să-l prindă în capcană cu ceva din ceea ce ar fi spus, ca să-l predea puterii și autorității guvernatorului. ");
INSERT INTO ronlsb_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ei l-au întrebat: “Învățătorule, știm că tu spui și înveți ceea ce este drept și nu ești părtinitor față de nimeni, ci înveți cu adevărat calea lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ne este permis să plătim sau nu impozite Cezarului?” ");
INSERT INTO ronlsb_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Dar El, înțelegând viclenia lor, le-a zis: “Pentru ce Mă puneți la încercare? ");
INSERT INTO ronlsb_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Arătați-mi un denar. A cui sunt chipul și inscripția de pe el?” Ei au răspuns: “A lui Cezar”. ");
INSERT INTO ronlsb_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Și le-a zis: “Dați Cezarului ce este al Cezarului și lui Dumnezeu ce este al lui Dumnezeu.” ");
INSERT INTO ronlsb_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","N-au putut să-l prindă în cuvintele lui în fața poporului. Ei s-au mirat de răspunsul lui și au tăcut. ");
INSERT INTO ronlsb_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Unii dintre saduchei au venit la el, cei care neagă că există o înviere. ");
INSERT INTO ronlsb_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","L-au întrebat: “Învățătorule, Moise ne-a scris că, dacă fratele unui om moare având o soție, iar acesta nu are copii, fratele său trebuie să ia soția și să crească copii pentru fratele său. ");
INSERT INTO ronlsb_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Așadar, erau șapte frați. Primul și-a luat o soție și a murit fără copii. ");
INSERT INTO ronlsb_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Al doilea a luat-o de soție, și a murit fără copii. ");
INSERT INTO ronlsb_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Cel de-al treilea a luat-o și, la fel, toți cei șapte nu au lăsat copii și au murit. ");
INSERT INTO ronlsb_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","După aceea a murit și femeia. ");
INSERT INTO ronlsb_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Prin urmare, la înviere, a cui soție dintre ei va fi ea? Căci cei șapte au avut-o ca soție.” ");
INSERT INTO ronlsb_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Isus le-a zis: “Copiii veacului acestuia se căsătoresc și sunt dați în căsătorie. ");
INSERT INTO ronlsb_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Dar cei care sunt considerați vrednici să ajungă la vârsta aceea și la învierea din morți nu se căsătoresc și nici nu sunt dați în căsătorie. ");
INSERT INTO ronlsb_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Căci ei nu mai pot muri, pentru că sunt asemenea îngerilor și sunt copii ai lui Dumnezeu, fiind copii ai învierii. ");
INSERT INTO ronlsb_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Dar că morții înviază, chiar Moise a arătat-o la tufiș, când L-a numit pe Domnul “Dumnezeul lui Avraam, Dumnezeul lui Isaac și Dumnezeul lui Iacov”. ");
INSERT INTO ronlsb_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Or, El nu este Dumnezeul morților, ci al celor vii, căci pentru El toți sunt vii.” ");
INSERT INTO ronlsb_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Unii din cărturari au răspuns: “Învățătorule, bine vorbești.” ");
INSERT INTO ronlsb_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Nu au îndrăznit să-i mai pună întrebări. ");
INSERT INTO ronlsb_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","El le-a zis: “Pentru ce zic că Hristosul este fiul lui David? ");
INSERT INTO ronlsb_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Însuși David spune în cartea Psalmilor “Domnul a spus Domnului meu, “Stai la dreapta mea, ");
INSERT INTO ronlsb_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","până ce voi face din vrăjmașii tăi scăunelul picioarelor tale.” ");
INSERT INTO ronlsb_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“David îl numește deci Domn, și cum este el fiul său?” ");
INSERT INTO ronlsb_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","În auzul întregului norod, a zis ucenicilor Săi: ");
INSERT INTO ronlsb_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Feriți-vă de cărturarii aceia cărora le place să umble în haine lungi, și care iubesc să fie salutați în piețe, să aibă cele mai bune locuri în sinagogi și cele mai bune locuri la ospețe; ");
INSERT INTO ronlsb_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","care mănâncă casele văduvelor și care, pentru a se preface, fac rugăciuni lungi. Aceștia vor primi o condamnare mai mare”. ");
INSERT INTO ronlsb_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Și, ridicându-și privirea, a văzut pe cei bogați care puneau darurile lor în vistierie. ");
INSERT INTO ronlsb_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","A văzut o văduvă săracă care a aruncat două monede mici de aramă. ");
INSERT INTO ronlsb_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","El a zis: “Adevărat vă spun că această văduvă săracă a pus mai mult decât toți aceștia, ");
INSERT INTO ronlsb_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","căci toți aceștia au pus daruri pentru Dumnezeu din belșugul lor, dar ea, din sărăcia ei, a pus tot ce avea ca să trăiască.” ");
INSERT INTO ronlsb_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Pe când vorbeau unii despre templu și despre cum era împodobit cu pietre frumoase și cu daruri, a zis: ");
INSERT INTO ronlsb_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Cât despre lucrurile acestea pe care le vedeți, vor veni zile în care nu va mai rămâne aici piatră pe piatră care să nu fie dărâmată.” ");
INSERT INTO ronlsb_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ei L-au întrebat: “Învățătorule, când se vor întâmpla aceste lucruri? Care este semnul că aceste lucruri urmează să se întâmple?” ");
INSERT INTO ronlsb_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Și a zis: “Luați seama să nu vă lăsați rătăciți, căci mulți vor veni în numele Meu, zicând: “Eu sunt” și “Vremea este aproape”. De aceea, nu-i urmați. ");
INSERT INTO ronlsb_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Când auziți de războaie și de tulburări, nu vă înspăimântați, pentru că aceste lucruri trebuie să se întâmple mai întâi, dar sfârșitul nu va veni imediat.” ");
INSERT INTO ronlsb_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Apoi le-a zis: “Neamul se va ridica împotriva neamului și împărăția împotriva împărăției. ");
INSERT INTO ronlsb_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Vor fi cutremure mari, foamete și molime în diferite locuri. Vor fi spaime și semne mari din cer. ");
INSERT INTO ronlsb_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Dar, înainte de toate acestea, vor pune mâna pe voi și vă vor persecuta, vă vor da în sinagogi și în închisori, vă vor aduce înaintea împăraților și a guvernatorilor, din pricina numelui Meu. ");
INSERT INTO ronlsb_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Se va dovedi ca o mărturie pentru voi. ");
INSERT INTO ronlsb_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Așadar, așezați-vă în inimile voastre să nu meditați dinainte cum să răspundeți, ");
INSERT INTO ronlsb_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","pentru că eu vă voi da o gură și o înțelepciune pe care toți adversarii voștri nu vor putea să le înfrunte sau să le contrazică. ");
INSERT INTO ronlsb_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Veți fi predați chiar de părinți, de frați, de rude și de prieteni. Aceștia vor face ca unii dintre voi să fie uciși. ");
INSERT INTO ronlsb_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Veți fi urâți de toți oamenii din cauza numelui meu. ");
INSERT INTO ronlsb_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Și nici un fir de păr din capul vostru nu va pieri. ");
INSERT INTO ronlsb_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","“Prin stăruința voastră veți câștiga viața voastră. ");
INSERT INTO ronlsb_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Dar când veți vedea Ierusalimul înconjurat de oștiri, să știți că s-a apropiat pustiirea lui. ");
INSERT INTO ronlsb_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Atunci, cei care sunt în Iudeea să fugă în munți. Cei care sunt în mijlocul ei să plece. Cei care sunt în țară să nu intre în ea. ");
INSERT INTO ronlsb_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Căci acestea sunt zile de răzbunare, ca să se împlinească tot ce este scris. ");
INSERT INTO ronlsb_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Vai de cele însărcinate și de cele care alăptează prunci în acele zile! Căci va fi mare strâmtorare în țară și mânie pentru acest popor. ");
INSERT INTO ronlsb_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ei vor cădea sub ascuțișul sabiei și vor fi duși prizonieri în toate neamurile. Ierusalimul va fi călcat în picioare de neamuri până la împlinirea vremurilor neamurilor. ");
INSERT INTO ronlsb_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Vor fi semne în soare, în lună și în stele, și pe pământ va fi neliniște printre popoare, în neliniște din cauza vuietului mării și al valurilor; ");
INSERT INTO ronlsb_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","oamenii vor fi înnebuniți de frică și de așteptare pentru lucrurile care vor veni peste lume, căci puterile cerurilor vor fi zguduite. ");
INSERT INTO ronlsb_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Atunci vor vedea pe Fiul Omului venind pe un nor cu putere și cu o mare slavă. ");
INSERT INTO ronlsb_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Dar când vor începe să se întâmple aceste lucruri, priviți în sus și ridicați-vă capetele, pentru că răscumpărarea voastră este aproape.” ");
INSERT INTO ronlsb_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Și le-a spus o pildă. “Priviți smochinul și toți copacii. ");
INSERT INTO ronlsb_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Când sunt deja înmuguriți, voi vedeți și știți de la sine că vara este deja aproape. ");
INSERT INTO ronlsb_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Tot așa și voi, când vedeți că se întâmplă aceste lucruri, știți că Împărăția lui Dumnezeu este aproape. ");
INSERT INTO ronlsb_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Mai mult ca sigur vă spun că generația aceasta nu va trece până când nu se vor împlini toate lucrurile. ");
INSERT INTO ronlsb_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Cerul și pământul vor trece, dar cuvintele mele nu vor trece nicidecum. ");
INSERT INTO ronlsb_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Deci, luați seama, căci inimile voastre se vor împovăra de desfătări, de beții și de grijile vieții acesteia, și ziua aceea va veni pe neașteptate asupra voastră. ");
INSERT INTO ronlsb_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Căci ea va veni ca un laț peste toți cei care locuiesc pe suprafața întregului pământ. ");
INSERT INTO ronlsb_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","De aceea, vegheați tot timpul, rugându-vă ca să fiți socotiți vrednici să scăpați de toate aceste lucruri care se vor întâmpla și să stați în picioare înaintea Fiului Omului.” ");
INSERT INTO ronlsb_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","În fiecare zi, Isus învăța în Templu, iar noaptea ieșea să înnopteze pe muntele care se numește Măslinii. ");
INSERT INTO ronlsb_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Tot poporul venea dis-de-dimineață la el în templu ca să-l asculte. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Se apropia sărbătoarea azimilor, care se cheamă Paștele. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Preoții cei mai de seamă și cărturarii căutau cum să-L omoare, pentru că se temeau de popor. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Satana a intrat în Iuda, numit și Iscarioteanul, care era numărat între cei doisprezece. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","El s-a dus și a vorbit cu preoții cei mai de seamă și cu căpeteniile despre cum să li-l predea. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ei s-au bucurat și au fost de acord să-i dea bani. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","El a consimțit și a căutat un prilej să li-l predea în absența mulțimii. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","A sosit ziua azimilor, în care trebuia să se jertfească Paștele. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Isus i-a trimis pe Petru și pe Ioan, zicând: “Duceți-vă și pregătiți-ne Paștele, ca să mâncăm.” ");
INSERT INTO ronlsb_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ei I-au zis: “Unde vrei să ne pregătim?” ");
INSERT INTO ronlsb_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","El le-a zis: “Iată, când veți intra în cetate, vă va întâmpina un om care duce un ulcior cu apă. Urmați-l în casa în care va intra el. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Spuneți-i stăpânului casei: “Învățătorul vă spune: “Unde este camera de oaspeți, unde pot mânca Paștele cu discipolii mei?””. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Îți va arăta o cameră mare, mobilată, în partea de sus. Fă pregătirile acolo”. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","S-au dus, au găsit lucrurile așa cum le spusese Isus și au pregătit Paștele. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Când a sosit ceasul, a șezut la masă cu cei doisprezece apostoli. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Și le-a zis: “Am dorit foarte mult să mănânc acest Paște cu voi înainte de a suferi, ");
INSERT INTO ronlsb_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","căci vă spun că nu voi mai mânca în niciun fel din el până când nu se va împlini în Împărăția lui Dumnezeu.” ");
INSERT INTO ronlsb_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","A primit un pahar și, după ce a mulțumit, a zis: “Luați și împărțiți-l între voi, ");
INSERT INTO ronlsb_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","pentru că vă spun că nu voi mai bea deloc din rodul viței de vie, până când nu va veni Împărăția lui Dumnezeu.” ");
INSERT INTO ronlsb_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","A luat o pâine și, după ce a mulțumit, a frânt-o și le-a dat-o, zicând: “Acesta este trupul Meu, care se dă pentru voi. Faceți aceasta în amintirea mea”. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","La fel, după cină, a luat paharul, zicând: “Paharul acesta este noul legământ în sângele Meu, care se varsă pentru voi. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Dar iată că mâna celui care mă trădează este cu mine pe masă. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Într-adevăr, Fiul Omului merge așa cum a fost hotărât, dar vai de omul prin care este trădat!” ");
INSERT INTO ronlsb_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Și au început să se întrebe între ei care dintre ei era cel ce voia să facă lucrul acesta. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Între ei s-a iscat și o ceartă, care dintre ei era considerat cel mai mare. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","El le-a zis: “Împărații neamurilor îi stăpânesc, iar cei care au autoritate asupra lor sunt numiți “binefăcători”. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Dar nu este așa cu voi. Mai degrabă, cel care este mai mare dintre voi să devină ca cel mai mic, iar cel care conduce, ca unul care slujește. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Căci cine este mai mare, cel care stă la masă sau cel care slujește? Nu este oare cel care stă la masă? Dar eu sunt în mijlocul vostru ca unul care slujește. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Dar voi sunteți aceia care ați rămas cu mine în încercările mele. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Eu vă dau vouă o împărăție, așa cum Tatăl Meu mi-a dat-o Mie, ");
INSERT INTO ronlsb_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ca să mâncați și să beți la masa Mea în Împărăția Mea. Voi veți sta pe tronuri, judecând cele douăsprezece triburi ale lui Israel.” ");
INSERT INTO ronlsb_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Domnul a zis: “Simon, Simon, iată că Satana a cerut să vă ia pe toți, ca să vă cerne ca pe grâu; ");
INSERT INTO ronlsb_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","dar Eu m-am rugat pentru tine, ca să nu-ți piardă credința. Tu, după ce te vei fi întors din nou, stabilește-i pe frații tăi”. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","El I-a zis: “Doamne, sunt gata să merg cu Tine și la temniță și la moarte!” ");
INSERT INTO ronlsb_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","El a zis: “Îți spun, Petru, că astăzi nu va cânta cocoșul până nu vei nega de trei ori că Mă cunoști.” ");
INSERT INTO ronlsb_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","El le-a zis: “Când v-am trimis fără pungă, fără sac și fără sandale, v-a lipsit ceva?” Ei au spus: “Nimic”. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Apoi le-a zis: “Dar acum, cine are o pungă, s-o ia și un sac. Cine n-are, să-și vândă haina și să-și cumpere o sabie. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Căci vă spun că trebuie să se împlinească încă în mine ceea ce este scris: “A fost socotit împreună cu călcătorii de lege”. Căci ceea ce mă privește pe mine se împlinește.” ");
INSERT INTO ronlsb_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ei au zis: “Doamne, iată două săbii.” El le-a spus: “Ajunge!”. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","El a ieșit și s-a dus, după obiceiul său, pe Muntele Măslinilor. L-au urmat și discipolii Lui. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Când a ajuns la locul acela, le-a zis: “Rugați-vă să nu intrați în ispită.” ");
INSERT INTO ronlsb_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","S-a depărtat de ei ca la o aruncătură de piatră, a îngenuncheat și se ruga, zicând: ");
INSERT INTO ronlsb_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Tată, dacă voiești, depărtează de la Mine paharul acesta. Cu toate acestea, nu voia mea, ci a Ta să se facă”.” ");
INSERT INTO ronlsb_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Un înger din cer i s-a arătat și l-a întărit. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Fiind în agonie, el se ruga cu mai multă stăruință. Sudoarea lui a devenit ca niște picături mari de sânge care cădeau pe pământ. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","După ce S-a sculat din rugăciunea Sa, a venit la ucenici și, găsindu-i adormiți din pricina durerii, ");
INSERT INTO ronlsb_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","le-a zis: “De ce dormiți? Sculați-vă și rugați-vă ca să nu intrați în ispită”. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Pe când vorbea el încă, a apărut o mulțime. Cel care se numea Iuda, unul dintre cei doisprezece, îi conducea. S-a apropiat de Isus ca să-l sărute. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Dar Isus i-a zis: “Iuda, tu Îl trădezi pe Fiul Omului cu o sărutare?” ");
INSERT INTO ronlsb_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Cei ce erau în jurul lui, văzând ce avea să se întâmple, I-au zis: “Doamne, să batem cu sabia?” ");
INSERT INTO ronlsb_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Unul dintre ei a lovit pe slujitorul marelui preot și i-a tăiat urechea dreaptă. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Dar Isus a răspuns: “Lasă-mă măcar să fac lucrul acesta, și, atingându-i urechea, l-a vindecat. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Isus a zis preoților cei mai de seamă, căpeteniilor templului și bătrânilor, care veniseră împotriva Lui: “Ați ieșit ca împotriva unui tâlhar, cu săbii și cu ciomege? ");
INSERT INTO ronlsb_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Când eram zilnic cu voi în templu, nu ați întins mâinile împotriva mea. Dar acesta este ceasul vostru și puterea întunericului”. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","L-au prins și l-au dus și l-au adus în casa marelui preot. Dar Petru îl urmărea de la distanță. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","După ce au aprins un foc în mijlocul curții și au șezut împreună, Petru a șezut în mijlocul lor. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","O slujnică l-a văzut cum ședea la lumină și, uitându-se cu atenție la el, a zis: “Și acesta era cu el.” ");
INSERT INTO ronlsb_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","El s-a lepădat de Isus, zicând: “Femeie, nu-L cunosc.” ");
INSERT INTO ronlsb_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","După puțină vreme, l-a văzut altcineva și i-a zis: “Și tu ești unul dintre ei!” Dar Petru a răspuns: “Omule, eu nu sunt!” ");
INSERT INTO ronlsb_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","După ce a trecut aproape un ceas, un altul a spus cu încredere: “Cu adevărat și acesta era cu El, căci este galileean.” ");
INSERT INTO ronlsb_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Dar Petru a zis: “Omule, nu știu despre ce vorbești!” Imediat, în timp ce el încă vorbea, a cântat un cocoș. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Domnul s-a întors și s-a uitat la Petru. Atunci Petru și-a adus aminte de cuvântul Domnului, cum că i-a spus: “Înainte să cânte cocoșul, te vei lepăda de mine de trei ori”. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","A ieșit afară și a plâns cu amar. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Oamenii care îl țineau pe Isus își băteau joc de el și îl băteau. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","După ce l-au legat la ochi, l-au lovit peste față și l-au întrebat: “Proorocește! Cine este cel care te-a lovit?”. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Și au mai spus multe alte lucruri împotriva lui, insultându-l. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Când s-a făcut ziuă, s-a adunat adunarea bătrânilor poporului, preoții cei mai de seamă și cărturarii, și L-au dus pe Isus în sfatul lor, zicând: ");
INSERT INTO ronlsb_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Dacă Tu ești Hristosul, spune-ne.” Dar El le-a zis: “Dacă vă voi spune, nu veți crede; ");
INSERT INTO ronlsb_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","și dacă vă voi întreba, nu-mi veți răspunde și nu mă veți lăsa să plec. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","De acum încolo, Fiul Omului va ședea la dreapta puterii lui Dumnezeu”. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Și toți au zis: “Deci Tu ești Fiul lui Dumnezeu?” El le-a spus: “Spuneți asta, pentru că așa sunt”. ");
INSERT INTO ronlsb_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ei au zis: “Pentru ce mai avem nevoie de un martor? Pentru că noi înșine am auzit din gura Lui!” ");
INSERT INTO ronlsb_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Toată ceata lor s-a sculat și L-au dus înaintea lui Pilat. ");
INSERT INTO ronlsb_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ei au început să-l acuze, zicând: “Am găsit pe omul acesta pervertindu-și națiunea, interzicând plata impozitelor către Cezar și spunând că el însuși este Hristos, un rege.” ");
INSERT INTO ronlsb_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilat L-a întrebat: “Tu ești Împăratul Iudeilor?” El i-a răspuns: “Așa spui tu”. ");
INSERT INTO ronlsb_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilat a zis preoților de seamă și mulțimii: “Nu găsesc nici un temei de acuzare împotriva omului acesta.” ");
INSERT INTO ronlsb_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Dar ei insistau, zicând: “El stârnește poporul și învață în toată Iudeea, începând din Galileea și până aici.” ");
INSERT INTO ronlsb_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilat, când a auzit vorbindu-se de Galileea, a întrebat dacă omul acela este galileean. ");
INSERT INTO ronlsb_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Când a aflat că se afla sub jurisdicția lui Irod, l-a trimis la Irod, care se afla și el la Ierusalim în acele zile. ");
INSERT INTO ronlsb_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Când a văzut Irod pe Isus, s-a bucurat foarte mult, căci de multă vreme voia să-L vadă, pentru că auzise multe lucruri despre El. Spera să vadă vreo minune făcută de el. ");
INSERT INTO ronlsb_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","L-a întrebat cu multe cuvinte, dar el nu i-a dat niciun răspuns. ");
INSERT INTO ronlsb_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Preoții cei mai de seamă și cărturarii stăteau în picioare, acuzându-l cu vehemență. ");
INSERT INTO ronlsb_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Irod cu soldații săi îl umileau și își băteau joc de el. Îmbrăcându-l în haine luxoase, l-au trimis înapoi la Pilat. ");
INSERT INTO ronlsb_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Irod și Pilat s-au împrietenit chiar în ziua aceea, căci înainte de aceasta erau dușmani unul cu altul. ");
INSERT INTO ronlsb_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilat a chemat pe preoții cei mai de seamă, pe dregători și pe popor, ");
INSERT INTO ronlsb_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","și le-a zis: “Mi l-ați adus pe omul acesta ca pe unul care strică poporul și, după ce l-am cercetat înaintea voastră, n-am găsit nici un temei de acuzație împotriva omului acesta pentru cele de care îl acuzați. ");
INSERT INTO ronlsb_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nici Irod, căci v-am trimis la el și vedeți, nu a făcut nimic vrednic de moarte. ");
INSERT INTO ronlsb_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","De aceea îl voi pedepsi și îl voi elibera.” ");
INSERT INTO ronlsb_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Și a trebuit să le dea drumul la un prizonier la sărbătoare. ");
INSERT INTO ronlsb_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Dar toți au strigat împreună și au zis: “Departe de omul acesta! Eliberați-ne pe Baraba!” — ");
INSERT INTO ronlsb_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","unul care fusese aruncat în închisoare pentru o anumită revoltă în cetate și pentru crimă. ");
INSERT INTO ronlsb_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Atunci Pilat le-a vorbit iarăși și a vrut să dea drumul lui Isus; ");
INSERT INTO ronlsb_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","dar ei strigau și ziceau: “Răstignește! Răstignește-l!” ");
INSERT INTO ronlsb_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","A treia oară le-a zis: “De ce? Ce rău a făcut omul acesta? Nu am găsit în el nicio crimă capitală. De aceea îl voi pedepsi și îl voi elibera.” ");
INSERT INTO ronlsb_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Dar ei insistau cu glasuri puternice, cerând să fie răstignit. Vocile lor și ale preoților de seamă au învins. ");
INSERT INTO ronlsb_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilat a decretat să se facă ceea ce cereau ei. ");
INSERT INTO ronlsb_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","L-a eliberat pe cel care fusese aruncat în închisoare pentru insurecție și crimă, pentru care cereau ei, dar pe Isus l-a predat voinței lor. ");
INSERT INTO ronlsb_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","După ce L-au dus, au apucat pe Simon din Cirene, care venea de la țară, și au pus crucea pe el, ca s-o ducă după Isus. ");
INSERT INTO ronlsb_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","O mare mulțime de oameni îl urmau, inclusiv femei care și ele îl plângeau și îl jeleau. ");
INSERT INTO ronlsb_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Dar Isus, întorcându-se spre ele, le-a zis: “Fiice ale Ierusalimului, nu plângeți pentru mine, ci plângeți pentru voi și pentru copiii voștri. ");
INSERT INTO ronlsb_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Căci iată că vin zile în care se va spune: “Ferice de cele sterpe, de pântecele care n-au născut niciodată și de sânii care n-au alăptat niciodată!”. ");
INSERT INTO ronlsb_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Atunci vor începe să spună munților: “Cădeți peste noi!” și vor spune dealurilor: “Acoperiți-ne!”. ");
INSERT INTO ronlsb_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Căci, dacă fac aceste lucruri în copacul verde, ce se va face în cel uscat?” ");
INSERT INTO ronlsb_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Au mai fost și alți doi criminali, care au fost duși împreună cu el la moarte. ");
INSERT INTO ronlsb_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Când au ajuns la locul numit “Craniul”, L-au răstignit acolo împreună cu criminalii, unul la dreapta și altul la stânga. ");
INSERT INTO ronlsb_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Isus a zis: “Tată, iartă-i, căci nu știu ce fac.” Împărțind hainele lui între ei, au tras la sorți. ");
INSERT INTO ronlsb_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Poporul stătea și privea. Și conducătorii care erau cu ei își băteau joc de el, zicând: “A salvat pe alții. Să se salveze pe sine însuși, dacă acesta este Hristosul lui Dumnezeu, alesul lui!” ");
INSERT INTO ronlsb_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Soldații își băteau joc de El, venind la El și oferindu-i oțet, ");
INSERT INTO ronlsb_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","și zicând: “Dacă ești Împăratul Iudeilor, mântuiește-te!” ");
INSERT INTO ronlsb_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","De asemenea, deasupra lui era scrisă o inscripție cu litere grecești, latinești și ebraice: “Acesta este REGELE EVREILOR”. ");
INSERT INTO ronlsb_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Unul dintre cei spânzurați L-a insultat, zicând: “Dacă ești Hristosul, mântuiește-te pe Tine și pe noi!” ");
INSERT INTO ronlsb_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Dar celălalt a răspuns și, mustrându-l, i-a zis: “Nu te temi tu de Dumnezeu, când ești sub aceeași osândă? ");
INSERT INTO ronlsb_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Și noi, într-adevăr, suntem drepți, căci primim răsplata cuvenită pentru faptele noastre, dar omul acesta nu a făcut nimic rău.” ");
INSERT INTO ronlsb_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","El i-a zis lui Isus: “Doamne, adu-ți aminte de mine când vei veni în Împărăția ta”. ");
INSERT INTO ronlsb_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Isus i-a zis: “Adevărat îți spun că astăzi vei fi cu Mine în Rai.” ");
INSERT INTO ronlsb_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Era pe la ceasul al șaselea și s-a făcut întuneric peste toată țara până la ceasul al nouălea. ");
INSERT INTO ronlsb_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Soarele s-a întunecat, iar perdeaua templului s-a rupt în două. ");
INSERT INTO ronlsb_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Isus, strigând cu glas tare, a zis: “Tată, în mâinile Tale Îmi dau duhul Meu!” După ce a spus aceasta, și-a dat ultima suflare. ");
INSERT INTO ronlsb_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Când a văzut centurionul ce se făcuse, a slăvit pe Dumnezeu, zicând: “Cu adevărat, acesta era un om drept.” ");
INSERT INTO ronlsb_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Toate mulțimile care se adunaseră să vadă acest lucru, când au văzut ce s-a făcut, s-au întors acasă bătându-se pe piept. ");
INSERT INTO ronlsb_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Toți cunoscuții lui și femeile care îl însoțeau din Galileea stăteau deoparte, privind aceste lucruri. ");
INSERT INTO ronlsb_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Și iată că era un om numit Iosif, care făcea parte din consiliu, un om bun și drept ");
INSERT INTO ronlsb_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","(nu consimțise la sfatul și la fapta lor), din Arimateea, cetate a iudeilor, care aștepta și el Împărăția lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Acest om s-a dus la Pilat și a cerut trupul lui Isus. ");
INSERT INTO ronlsb_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Acesta l-a dat jos, l-a înfășurat într-o pânză de in și l-a pus într-un mormânt tăiat în piatră, unde nu fusese pus nimeni niciodată. ");
INSERT INTO ronlsb_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Era ziua Pregătirii și se apropia Sabatul. ");
INSERT INTO ronlsb_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Femeile care veniseră cu el din Galileea au venit după el și au văzut mormântul și cum fusese pus trupul Lui. ");
INSERT INTO ronlsb_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ele s-au întors și au pregătit miresme și miruri. În Sabat s-au odihnit conform poruncii. ");
INSERT INTO ronlsb_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Dar în prima zi a săptămânii, în zorii zilei, au venit la mormânt, împreună cu alții, aducând miresmele pe care le pregătiseră. ");
INSERT INTO ronlsb_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Au găsit piatra rostogolită de pe mormânt. ");
INSERT INTO ronlsb_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Au intrat înăuntru și n-au găsit trupul Domnului Isus. ");
INSERT INTO ronlsb_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","În timp ce erau foarte nedumeriți de acest lucru, iată că au apărut lângă ei doi bărbați îmbrăcați în haine orbitoare. ");
INSERT INTO ronlsb_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Îngrozindu-se, s-au plecat cu fața la pământ. Oamenii le-au zis: “De ce căutați pe cei vii printre cei morți? ");
INSERT INTO ronlsb_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","El nu este aici, ci a înviat. Vă amintiți ce v-a spus când era încă în Galileea, ");
INSERT INTO ronlsb_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","spunând că Fiul Omului trebuie să fie dat în mâinile oamenilor păcătoși, să fie răstignit și a treia zi să învieze?” ");
INSERT INTO ronlsb_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ei și-au adus aminte de cuvintele Lui, ");
INSERT INTO ronlsb_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","s-au întors de la mormânt și au spus toate acestea celor unsprezece și tuturor celorlalți. ");
INSERT INTO ronlsb_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ele erau Maria Magdalena, Ioana și Maria, mama lui Iacov. Celelalte femei care erau cu ele au povestit aceste lucruri apostolilor. ");
INSERT INTO ronlsb_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Aceste cuvinte li s-au părut a fi un nonsens și nu le-au crezut. ");
INSERT INTO ronlsb_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Dar Petru s-a ridicat și a alergat la mormânt. Aplecându-se și uitându-se înăuntru, a văzut fâșiile de pânză așezate singure și a plecat acasă, întrebându-se ce se întâmplase. ");
INSERT INTO ronlsb_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Și iată că doi dintre ei mergeau chiar în ziua aceea într-un sat numit Emaus, care era la șaizeci de stadii de Ierusalim. ");
INSERT INTO ronlsb_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Și vorbeau unul cu altul despre toate aceste lucruri care se întâmplaseră. ");
INSERT INTO ronlsb_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","În timp ce vorbeau și se întrebau împreună, Isus însuși s-a apropiat și a mers cu ei. ");
INSERT INTO ronlsb_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Dar ochii lor erau împiedicați să-L recunoască. ");
INSERT INTO ronlsb_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","El le-a zis: “Despre ce vorbiți în timp ce mergeți și sunteți triști?” ");
INSERT INTO ronlsb_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Unul dintre ei, numit Cleopa, i-a răspuns: “Ești tu singurul străin din Ierusalim care nu știe ce s-a întâmplat acolo în zilele acestea?” ");
INSERT INTO ronlsb_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","El le-a zis: “Ce anume?” Ei I-au zis: “Cele despre Iisus Nazarineanul, care a fost un prooroc puternic cu fapta și cu cuvântul înaintea lui Dumnezeu și a întregului popor, ");
INSERT INTO ronlsb_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","și despre cum preoții cei mai de seamă și căpeteniile noastre L-au dat spre osândă la moarte și L-au răstignit. ");
INSERT INTO ronlsb_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Dar noi speram că el este cel care va răscumpăra pe Israel. Da, și, pe lângă toate acestea, este acum a treia zi de când s-au întâmplat aceste lucruri. ");
INSERT INTO ronlsb_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","De asemenea, ne-au uimit niște femei din anturajul nostru, care au ajuns mai devreme la mormânt; ");
INSERT INTO ronlsb_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","și, când nu i-au găsit trupul, au venit spunând că au văzut și ele o viziune a unor îngeri, care spuneau că este viu. ");
INSERT INTO ronlsb_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Unii dintre noi s-au dus la mormânt și l-au găsit așa cum au spus femeile, dar nu l-au văzut.” ");
INSERT INTO ronlsb_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","El le-a zis: “Popor nebun și încet la inimă ca să creadă în tot ce au spus proorocii! ");
INSERT INTO ronlsb_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Nu trebuia oare Hristosul să sufere aceste lucruri și să intre în gloria Sa?” ");
INSERT INTO ronlsb_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Pornind de la Moise și de la toți profeții, le-a explicat în toate Scripturile ceea ce se referă la el însuși. ");
INSERT INTO ronlsb_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Au ajuns aproape de satul în care se duceau, iar el s-a făcut că vrea să meargă mai departe. ");
INSERT INTO ronlsb_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ei l-au îndemnat, zicând: “Rămâi cu noi, căci este aproape seară și ziua este aproape de sfârșit.” A intrat să stea cu ei. ");
INSERT INTO ronlsb_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","După ce s-a așezat la masă cu ei, a luat pâinea și a mulțumit. A frânt-o și le-a dat-o. ");
INSERT INTO ronlsb_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ochii lor s-au deschis și l-au recunoscut; apoi a dispărut din ochii lor. ");
INSERT INTO ronlsb_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ei și-au zis unul altuia: “Nu ne ardea inima în noi când ne vorbea pe drum și când ne deschidea Scripturile?” ");
INSERT INTO ronlsb_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ei s-au sculat chiar în acel ceas, s-au întors la Ierusalim și i-au găsit pe cei unsprezece adunați împreună cu cei care erau cu ei, ");
INSERT INTO ronlsb_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","spunând: “Domnul a înviat cu adevărat și i s-a arătat lui Simon!” ");
INSERT INTO ronlsb_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ei au povestit cele întâmplate pe drum și cum a fost recunoscut de ei la frângerea pâinii. ");
INSERT INTO ronlsb_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Pe când ziceau ei aceste lucruri, Isus însuși a stat în mijlocul lor și le-a zis: “Pace vouă!” ");
INSERT INTO ronlsb_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Dar ei, îngroziți și înfricoșați, au crezut că au văzut un duh. ");
INSERT INTO ronlsb_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","El le-a zis: “De ce vă tulburați? De ce se ridică îndoieli în inimile voastre? ");
INSERT INTO ronlsb_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Vedeți mâinile și picioarele Mele, că sunt cu adevărat Eu. Atingeți-mă și vedeți, pentru că un duh nu are carne și oase, așa cum vedeți că am eu.” ");
INSERT INTO ronlsb_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","După ce a spus acestea, le-a arătat mâinile și picioarele. ");
INSERT INTO ronlsb_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pe când ei încă nu credeau de bucurie și se mirau, le-a zis: “Aveți ceva de mâncare aici?” ");
INSERT INTO ronlsb_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","I-au dat o bucată de pește fript și un fagure de miere. ");
INSERT INTO ronlsb_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","El le-a luat și a mâncat în fața lor. ");
INSERT INTO ronlsb_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","El le-a zis: “Iată ce v-am spus când eram încă cu voi: trebuie să se împlinească tot ce este scris în Legea lui Moise, în profeți și în psalmi despre Mine.” ");
INSERT INTO ronlsb_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Atunci le-a deschis mintea, ca să înțeleagă Scripturile. ");
INSERT INTO ronlsb_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Și le-a zis: “Așa este scris și așa a fost necesar ca Hristosul să sufere și să învieze din morți a treia zi, ");
INSERT INTO ronlsb_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","iar în numele Lui să se propovăduiască pocăința și iertarea păcatelor la toate neamurile, începând de la Ierusalim. ");
INSERT INTO ronlsb_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Voi sunteți martori ai acestor lucruri. ");
INSERT INTO ronlsb_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Iată, Eu trimit asupra voastră făgăduința Tatălui Meu. Dar așteptați în cetatea Ierusalimului până când veți fi îmbrăcați cu putere de sus.” ");
INSERT INTO ronlsb_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","I-a condus până în Betania, și, ridicându-și mâinile, i-a binecuvântat. ");
INSERT INTO ronlsb_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","În timp ce-i binecuvânta, s-a retras de la ei și a fost dus la cer. ");
INSERT INTO ronlsb_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ei, închinându-se lui, s-au întors la Ierusalim cu mare bucurie, ");
INSERT INTO ronlsb_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","și stăteau neîncetat în templu, lăudând și binecuvântând pe Dumnezeu. Amin. ");
INSERT INTO ronlsb_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","La început era Cuvântul, și Cuvântul era cu Dumnezeu, și Cuvântul era Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","El era la început cu Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Toate lucrurile au fost făcute prin el. Fără el, nimic din ceea ce a fost făcut nu s-a făcut. ");
INSERT INTO ronlsb_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","În El era viața, iar viața era lumina oamenilor. ");
INSERT INTO ronlsb_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Lumina strălucește în întuneric, iar întunericul nu a biruit-o. ");
INSERT INTO ronlsb_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Și a venit un om trimis de Dumnezeu, care se numea Ioan. ");
INSERT INTO ronlsb_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Acesta a venit ca martor, ca să mărturisească despre lumină, pentru ca toți să creadă prin el. ");
INSERT INTO ronlsb_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","El nu era lumina, ci a fost trimis ca să mărturisească despre lumină. ");
INSERT INTO ronlsb_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Lumina adevărată, care luminează pe toată lumea, venea în lume. ");
INSERT INTO ronlsb_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","El era în lume, și lumea a fost făcută prin El, și lumea nu L-a recunoscut. ");
INSERT INTO ronlsb_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","El a venit la ai Săi, și cei ce erau ai Săi nu L-au primit. ");
INSERT INTO ronlsb_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Dar tuturor celor care l-au primit, le-a dat dreptul de a deveni copii ai lui Dumnezeu, celor ce cred în numele lui; ");
INSERT INTO ronlsb_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","care nu s-au născut din sânge, nici din voința cărnii, nici din voința omului, ci din Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Cuvântul S-a făcut trup și a locuit printre noi. Am văzut slava Lui, o slavă ca a Fiului unic născut din Tatăl, plin de har și de adevăr. ");
INSERT INTO ronlsb_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ioan a mărturisit despre el. El a strigat, spunând: “Acesta a fost cel despre care am spus: “Cel care vine după mine m-a întrecut pe mine, pentru că a fost înaintea mea”.” ");
INSERT INTO ronlsb_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Din plinătatea lui, noi toți am primit har peste har. ");
INSERT INTO ronlsb_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Căci Legea a fost dată prin Moise. Harul și adevărul s-au realizat prin Isus Cristos. ");
INSERT INTO ronlsb_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nimeni nu L-a văzut pe Dumnezeu în niciun moment. Fiul unic născut, care este în sânul Tatălui, l-a declarat. ");
INSERT INTO ronlsb_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Iată mărturia lui Ioan, când iudeii au trimis preoți și leviți de la Ierusalim ca să-l întrebe: “Cine ești Tu?” ");
INSERT INTO ronlsb_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","El a declarat, și nu a negat, ci a declarat: “Eu nu sunt Hristosul.” ");
INSERT INTO ronlsb_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Și L-au întrebat: “Și atunci, ce? Ești tu Ilie?” El a spus: “Nu sunt.” “Tu ești profetul?” El a răspuns: “Nu.” ");
INSERT INTO ronlsb_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Și I-au zis: “Cine ești Tu? Dă-ne un răspuns pe care să-l ducem înapoi la cei care ne-au trimis. Ce spui despre tine însuți?” ");
INSERT INTO ronlsb_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","El a zis: “Eu sunt glasul celui care strigă în pustiu: “Îndreptați calea Domnului”, cum a zis profetul Isaia”. ");
INSERT INTO ronlsb_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Cei care fuseseră trimiși erau din partea fariseilor. ");
INSERT INTO ronlsb_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ei L-au întrebat: “De ce deci botezi, dacă nu ești nici Hristosul, nici Ilie, nici proorocul?” ");
INSERT INTO ronlsb_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ioan le-a răspuns: “Eu botez în apă, dar în mijlocul vostru este Unul pe care nu-L cunoașteți. ");
INSERT INTO ronlsb_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","El este cel care vine după mine, care este preferat înaintea mea, căruia nu sunt vrednic să-i dezleg cureaua de la sandale.” ");
INSERT INTO ronlsb_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Aceste lucruri se întâmplau în Betania, dincolo de Iordan, unde boteza Ioan. ");
INSERT INTO ronlsb_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","A doua zi, a văzut pe Isus venind la el și a zis: “Iată Mielul lui Dumnezeu, care ridică păcatul lumii! ");
INSERT INTO ronlsb_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Acesta este Acela despre care am spus: “După mine vine un om care este preferat înaintea mea, pentru că a fost înaintea mea”. ");
INSERT INTO ronlsb_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Eu nu-l cunoșteam, dar pentru aceasta am venit botezând în apă, ca să fie descoperit lui Israel.” ");
INSERT INTO ronlsb_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ioan a depus mărturie și a zis: “Am văzut Duhul Sfânt coborând din cer ca un porumbel și a rămas peste El. ");
INSERT INTO ronlsb_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Eu nu l-am recunoscut, dar cel care m-a trimis să botez în apă mi-a spus: “Pe oricine vei vedea Duhul coborând și rămânând asupra lui, acela este cel care botează în Duhul Sfânt. ");
INSERT INTO ronlsb_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Eu am văzut și am mărturisit că acesta este Fiul lui Dumnezeu.” ");
INSERT INTO ronlsb_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","A doua zi, Ioan, stând în picioare cu doi din ucenicii săi, ");
INSERT INTO ronlsb_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","s-a uitat la Isus, care mergea, și a zis: “Iată Mielul lui Dumnezeu!” ");
INSERT INTO ronlsb_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Cei doi discipoli l-au auzit vorbind și l-au urmat pe Isus. ");
INSERT INTO ronlsb_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Isus s-a întors și, văzându-i că îi urmăreau, le-a zis: “Ce căutați?” I-au zis: “Rabi” (adică, în traducere, Învățător), “unde stai?”. ");
INSERT INTO ronlsb_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Și le-a zis: “Veniți și vedeți.” Au venit și au văzut unde stătea și au rămas cu el în acea zi. Era pe la ora zece. ");
INSERT INTO ronlsb_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Unul dintre cei doi care l-au auzit pe Ioan și l-au urmat a fost Andrei, fratele lui Simon Petru. ");
INSERT INTO ronlsb_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","El l-a găsit mai întâi pe fratele său, Simon, și i-a spus: “L-am găsit pe Mesia!”. (ceea ce înseamnă, fiind interpretat, Hristos). ");
INSERT INTO ronlsb_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","L-a adus la Isus. Isus s-a uitat la el și i-a spus: “Tu ești Simon, fiul lui Iona. Te vei numi Cefa” (ceea ce înseamnă, prin interpretare, Petru). ");
INSERT INTO ronlsb_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","A doua zi, s-a hotărât să se ducă în Galileea și a găsit pe Filip. Isus i-a spus: “Urmează-mă”. ");
INSERT INTO ronlsb_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip era din Betsaida, cetatea lui Andrei și a lui Petru. ");
INSERT INTO ronlsb_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filip l-a găsit pe Natanael și i-a spus: “L-am găsit pe Acela despre care au scris Moise în Lege, dar și profeții: Iisus din Nazaret, fiul lui Iosif”. ");
INSERT INTO ronlsb_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanael I-a zis: “Poate ieși ceva bun din Nazaret?” Filip i-a zis: “Vino și vezi”. ");
INSERT INTO ronlsb_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Isus a văzut pe Natanael venind la El și a zis despre el: “Iată un israelit, în care nu este nici o înșelăciune!” ");
INSERT INTO ronlsb_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanael i-a zis: “De unde Mă cunoști?” Isus i-a răspuns: “Înainte ca Filip să te cheme, când erai sub smochin, te-am văzut.” ");
INSERT INTO ronlsb_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanael I-a răspuns: “Rabi, Tu ești Fiul lui Dumnezeu! Tu ești Regele lui Israel!” ");
INSERT INTO ronlsb_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Isus i-a răspuns: “Pentru că ți-am spus: “Te-am văzut sub smochin”, crezi tu? Vei vedea lucruri mai mari decât acestea!” ");
INSERT INTO ronlsb_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","El i-a zis: “Cu siguranță, vă spun tuturor că, după aceea, veți vedea cerul deschis și îngerii lui Dumnezeu urcând și coborând asupra Fiului Omului.” ");
INSERT INTO ronlsb_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","A treia zi, a fost o nuntă în Cana Galileii. Mama lui Isus era acolo. ");
INSERT INTO ronlsb_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","La nuntă a fost invitat și Isus, împreună cu discipolii săi. ");
INSERT INTO ronlsb_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Când s-a terminat vinul, mama lui Isus i-a spus: “Nu mai au vin”. ");
INSERT INTO ronlsb_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Isus i-a zis: “Femeie, ce are aceasta de-a face cu tine și cu mine? Nu a venit încă ceasul Meu”. ");
INSERT INTO ronlsb_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Mama lui a zis slujitorilor: “Faceți tot ce vă va spune.” ");
INSERT INTO ronlsb_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Și erau acolo șase vase de piatră pentru apă, așezate după obiceiul iudeilor, care conțineau câte doi sau trei metrii fiecare. ");
INSERT INTO ronlsb_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Isus le-a zis: “Umpleți vasele cu apă”. Și le-au umplut până la refuz. ");
INSERT INTO ronlsb_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","El le-a zis: “Acum scoateți puțin și duceți-l la conducătorul sărbătorii.” Și au luat-o. ");
INSERT INTO ronlsb_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Când conducătorul ospățului a gustat apa devenită acum vin și nu știa de unde provine (dar servitorii care scoseseră apa știau), conducătorul ospățului l-a chemat pe mire ");
INSERT INTO ronlsb_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","și i-a spus: “Toată lumea să servească mai întâi vinul bun, iar după ce oaspeții au băut din belșug, apoi pe cel mai rău. Tu ai păstrat vinul bun până acum!”. ");
INSERT INTO ronlsb_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Acest început al semnelor sale, Isus l-a făcut în Cana Galileii și și-a dezvăluit gloria, iar discipolii săi au crezut în el. ");
INSERT INTO ronlsb_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","După aceea, S-a coborât în Capernaum, împreună cu mama Sa, cu frații Săi și cu ucenicii Săi, și au rămas acolo câteva zile. ");
INSERT INTO ronlsb_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Se apropia Paștele iudeilor, și Isus s-a suit la Ierusalim. ");
INSERT INTO ronlsb_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","A găsit în templu pe cei care vindeau boi, oi și porumbei și pe schimbătorii de bani șezând. ");
INSERT INTO ronlsb_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","El a făcut un bici din funii și i-a alungat pe toți din templu, atât pe oi, cât și pe boi; apoi a vărsat banii schimbătorilor și le-a răsturnat mesele. ");
INSERT INTO ronlsb_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Celor care vindeau porumbei le-a zis: “Scoateți aceste lucruri de aici! Nu faceți din casa Tatălui meu o piață!” ");
INSERT INTO ronlsb_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ucenicii lui și-au amintit că era scris: “Zelul pentru casa voastră mă va mânca”. ");
INSERT INTO ronlsb_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Și Iudeii I-au răspuns: “Ce semn ne arăți, dacă faci aceste lucruri?” ");
INSERT INTO ronlsb_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Isus le-a răspuns: “Distrugeți templul acesta și în trei zile îl voi ridica.” ");
INSERT INTO ronlsb_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Iudeii ziceau: “A fost nevoie de patruzeci și șase de ani ca să se zidească templul acesta! Îl veți ridica voi în trei zile?” ");
INSERT INTO ronlsb_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Dar el a vorbit despre templul trupului său. ");
INSERT INTO ronlsb_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","De aceea, când a înviat din morți, discipolii lui și-au adus aminte că el spusese acest lucru și au crezut în Scriptură și în cuvântul pe care îl spusese Isus. ");
INSERT INTO ronlsb_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Când a fost la Ierusalim, în timpul sărbătorii Paștelui, mulți au crezut în Numele Lui și au văzut semnele pe care le făcea. ");
INSERT INTO ronlsb_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Dar Isus nu li s-a încredințat lor, pentru că îi cunoștea pe toți ");
INSERT INTO ronlsb_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","și pentru că nu avea nevoie ca cineva să dea mărturie despre om, pentru că El însuși știa ce este în om. ");
INSERT INTO ronlsb_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Și era un om dintre farisei, numit Nicodim, un fruntaș al iudeilor. ");
INSERT INTO ronlsb_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","El a venit la Isus noaptea și I-a zis: “Rabi, știm că ești un învățător venit de la Dumnezeu, căci nimeni nu poate face aceste semne pe care le faci Tu, dacă nu este Dumnezeu cu el.” ");
INSERT INTO ronlsb_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Isus i-a răspuns: “Adevărat îți spun că, dacă cineva nu se naște din nou, nu poate vedea Împărăția lui Dumnezeu.” ");
INSERT INTO ronlsb_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodim I-a zis: “Cum se poate naște un om când este bătrân? Poate să intre a doua oară în pântecele mamei sale și să se nască?” ");
INSERT INTO ronlsb_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Isus a răspuns: “Adevărat vă spun că, dacă nu se naște cineva din apă și din Duh, nu poate intra în Împărăția lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ceea ce este născut din carne este carne. Ceea ce este născut din Spirit este spirit. ");
INSERT INTO ronlsb_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nu vă mirați că v-am spus: “Trebuie să vă nașteți din nou”. ");
INSERT INTO ronlsb_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Vântulsuflă unde vrea, iar voi îi auziți sunetul, dar nu știți de unde vine și încotro se îndreaptă. La fel este oricine este născut din Spirit.” ");
INSERT INTO ronlsb_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodim I-a răspuns: “Cum pot fi acestea?” ");
INSERT INTO ronlsb_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Isus i-a răspuns: “Ești tu învățătorul lui Israel și nu înțelegi aceste lucruri? ");
INSERT INTO ronlsb_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Adevărat îți spun că noi spunem ceea ce știm și dăm mărturie despre ceea ce am văzut, iar tu nu primești mărturia noastră. ");
INSERT INTO ronlsb_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Dacă v-am spus lucruri pământești și nu credeți, cum veți crede dacă vă voi spune lucruri cerești? ");
INSERT INTO ronlsb_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nimeni nu s-a înălțat la cer decât Cel care S-a coborât din cer, Fiul Omului, care este în ceruri. ");
INSERT INTO ronlsb_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","După cum Moise a înălțat șarpele în pustiu, tot așa trebuie să fie înălțat și Fiul Omului, ");
INSERT INTO ronlsb_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","pentru ca oricine crede în el să nu piară, ci să aibă viață veșnică. ");
INSERT INTO ronlsb_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Fiindcă atât de mult a iubit Dumnezeu lumea, încât a dat pe singurul Său Fiu născut, pentru ca oricine crede în El să nu piară, ci să aibă viață veșnică. ");
INSERT INTO ronlsb_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Căci Dumnezeu nu L-a trimis pe Fiul Său în lume ca să judece lumea, ci pentru ca lumea să fie mântuită prin El. ");
INSERT INTO ronlsb_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Cine crede în El nu este judecat. Cel care nu crede a fost deja judecat, pentru că nu a crezut în numele singurului Fiu născut al lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Aceasta este judecata: că lumina a venit în lume și oamenii au iubit mai degrabă întunericul decât lumina, pentru că faptele lor erau rele. ");
INSERT INTO ronlsb_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Căci oricine face răul urăște lumina și nu vine la lumină, ca să nu i se descopere faptele. ");
INSERT INTO ronlsb_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Dar cel care face adevărul vine la lumină, pentru ca faptele lui să fie descoperite, ca să se vadă că au fost făcute în Dumnezeu.” ");
INSERT INTO ronlsb_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","După aceste lucruri, Isus a venit cu ucenicii Săi în ținutul Iudeii. A rămas acolo cu ei și a botezat. ");
INSERT INTO ronlsb_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ioan boteza și el în Enon, lângă Salim, pentru că acolo era multă apă. Ei au venit și au fost botezați; ");
INSERT INTO ronlsb_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","căci Ioan nu fusese încă aruncat în închisoare. ");
INSERT INTO ronlsb_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","De aceea, s-a iscat o dispută între discipolii lui Ioan și unii iudei în legătură cu purificarea. ");
INSERT INTO ronlsb_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Aceștia au venit la Ioan și i-au zis: “Rabi, cel care era cu tine dincolo de Iordan, despre care ai mărturisit, iată că el botează și toată lumea vine la el.” ");
INSERT INTO ronlsb_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ioan a răspuns: “Nimic nu poate primi omul, dacă nu-i este dat din cer. ");
INSERT INTO ronlsb_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Voi înșivă mărturisiți că am spus: “Nu eu sunt Hristosul”, ci “Eu am fost trimis înaintea lui”. ");
INSERT INTO ronlsb_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Cel care are mireasa este mirele; dar prietenul mirelui, care stă în picioare și îl aude, se bucură foarte mult din cauza glasului mirelui. De aceea bucuria mea este deplină. ");
INSERT INTO ronlsb_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","El trebuie să crească, dar eu trebuie să mă micșorez. ");
INSERT INTO ronlsb_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Cel ce vine de sus este mai presus de toate. Cel care vine de pe pământ aparține pământului și vorbește despre pământ. Cel care vine din cer este mai presus de toate. ");
INSERT INTO ronlsb_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ceea ce a văzut și a auzit, despre aceasta mărturisește; și nimeni nu primește mărturia lui. ");
INSERT INTO ronlsb_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Cel care a primit mărturia lui și-a pus pecetea pe aceasta: Dumnezeu este adevărat. ");
INSERT INTO ronlsb_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Căci cel pe care l-a trimis Dumnezeu vorbește cuvintele lui Dumnezeu; căci Dumnezeu dă Duhul fără măsură. ");
INSERT INTO ronlsb_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tatăl îl iubește pe Fiul și a dat toate lucrurile în mâna lui. ");
INSERT INTO ronlsb_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Cine crede în Fiul are viață veșnică, dar cine nu ascultă de Fiul nu va vedea viața, ci mânia lui Dumnezeu rămâne asupra lui.” ");
INSERT INTO ronlsb_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Când a aflat Domnul că fariseii au auzit că Isus face și botează mai mulți ucenici decât Ioan ");
INSERT INTO ronlsb_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(deși nu Isus însuși boteza, ci ucenicii lui), ");
INSERT INTO ronlsb_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","a părăsit Iudeea și s-a dus în Galileea. ");
INSERT INTO ronlsb_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Trebuia să treacă prin Samaria. ");
INSERT INTO ronlsb_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Și a ajuns la o cetate din Samaria, numită Sihar, lângă parcela de pământ pe care Iacov o dăduse fiului său Iosif. ");
INSERT INTO ronlsb_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Acolo se afla fântâna lui Iacov. Isus, deci, fiind obosit de drum, s-a așezat lângă fântână. Era pe la ceasul al șaselea. ");
INSERT INTO ronlsb_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","O femeie din Samaria a venit să scoată apă. Isus i-a zis: “Dă-mi să beau”. ");
INSERT INTO ronlsb_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Căci ucenicii Săi plecaseră în cetate să cumpere mâncare. ");
INSERT INTO ronlsb_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Atunci femeia samariteancă i-a zis: “Cum se face că Tu, care ești iudeu, ceri de la mine, o samariteancă, să beau ceva?” (Căci iudeii nu au de-a face cu samaritenii). ");
INSERT INTO ronlsb_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Isus i-a răspuns: “Dacă ai fi cunoscut darul lui Dumnezeu și cine este Cel ce-ți zice: “Dă-Mi să beau”, L-ai fi rugat și El ți-ar fi dat apă vie.” ");
INSERT INTO ronlsb_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Femeia i-a zis: “Domnule, nu ai cu ce să scoți apă, și fântâna este adâncă. Atunci de unde iei apa aceea vie? ");
INSERT INTO ronlsb_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ești tu mai mare decât tatăl nostru Iacov, care ne-a dat fântâna și a băut el însuși din ea, la fel ca și copiii și vitele lui?” ");
INSERT INTO ronlsb_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Isus i-a răspuns: “Oricine va bea din apa aceasta va înseta iarăși; ");
INSERT INTO ronlsb_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","dar oricine va bea din apa pe care i-o voi da Eu, nu va mai înseta niciodată, ci apa pe care i-o voi da Eu va deveni în el un izvor de apă care izvorăște pentru viața veșnică.” ");
INSERT INTO ronlsb_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Femeia I-a zis: “Dă-mi, Doamne, apa aceasta, ca să nu-mi fie sete și să nu vin până aici ca să beau.” ");
INSERT INTO ronlsb_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Isus i-a zis: “Du-te, cheamă pe bărbatul tău și vino aici.” ");
INSERT INTO ronlsb_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Femeia a răspuns: “Nu am bărbat.” Isus i-a zis: “Bine ai zis: “Nu am bărbat”, ");
INSERT INTO ronlsb_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","căci ai avut cinci soți; și cel pe care-l ai acum nu este bărbatul tău. Aceasta ai spus-o cu adevărat”. ");
INSERT INTO ronlsb_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Femeia i-a zis: “Domnule, văd că ești prooroc. ");
INSERT INTO ronlsb_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Părinții noștri s-au închinat în muntele acesta, iar voi, iudeii, spuneți că în Ierusalim este locul unde trebuie să se închine oamenii.” ");
INSERT INTO ronlsb_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Isus i-a zis: “Femeie, crede-mă, vine ceasul când nici în muntele acesta, nici în Ierusalim nu vă veți închina Tatălui. ");
INSERT INTO ronlsb_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Voi vă închinați la ceea ce nu cunoașteți. Noi ne închinăm la ceea ce cunoaștem, căci mântuirea vine de la iudei. ");
INSERT INTO ronlsb_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Dar vine ceasul, și acum este, când adevărații închinători se vor închina Tatălui în duh și în adevăr, pentru că Tatăl caută astfel de închinători pentru a fi închinătorii Lui. ");
INSERT INTO ronlsb_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dumnezeu este duh, iar cei care i se închină trebuie să se închine în duh și în adevăr.” ");
INSERT INTO ronlsb_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Femeia I-a zis: “Știu că vine Mesia, Cel ce se numește Hristos. Când va veni, ne va spune toate lucrurile.” ");
INSERT INTO ronlsb_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Isus i-a zis: “Eu sunt Cel ce vorbește cu tine.” ");
INSERT INTO ronlsb_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","În clipa aceea au venit ucenicii Lui. Ei s-au mirat că vorbea cu o femeie; dar nimeni nu i-a întrebat: “Ce cauți?” sau “De ce vorbești cu ea?”. ");
INSERT INTO ronlsb_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Femeia a lăsat vasul cu apă, s-a dus în cetate și a spus oamenilor: ");
INSERT INTO ronlsb_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Veniți să vedeți un om care mi-a spus tot ce am făcut. Poate fi acesta Hristosul?” ");
INSERT INTO ronlsb_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ei au ieșit din cetate și veneau la el. ");
INSERT INTO ronlsb_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Între timp, ucenicii îl îndemnau, zicând: “Rabi, mănâncă.” ");
INSERT INTO ronlsb_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Dar El le-a zis: “Am de mâncat o mâncare de care voi nu știți.” ");
INSERT INTO ronlsb_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Și ucenicii ziceau unul către altul: “I-a adus cineva ceva de mâncare?” ");
INSERT INTO ronlsb_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Isus le-a zis: “Hrana Mea este să fac voia Celui ce M-a trimis și să împlinesc lucrarea Lui. ");
INSERT INTO ronlsb_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nu spuneți voi: “Mai sunt încă patru luni până la seceriș?”? Iată, vă spun: ridicați-vă ochii și priviți câmpurile, că ele sunt deja albe pentru seceriș. ");
INSERT INTO ronlsb_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Cel care seceră primește plata și culege roade pentru viața veșnică, pentru ca atât cel care seamănă, cât și cel care seceră să se bucure împreună. ");
INSERT INTO ronlsb_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Căci în aceasta este adevărată zicala: “Unul seamănă, iar altul culege”. ");
INSERT INTO ronlsb_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Eu v-am trimis să secerați ceea ce nu ați muncit. Alții au muncit, iar tu ai intrat în munca lor.” ");
INSERT INTO ronlsb_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Mulți samariteni din cetatea aceea au crezut în El, din pricina cuvântului femeii care mărturisea: “El mi-a spus tot ce am făcut.” ");
INSERT INTO ronlsb_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Când au venit la el, samaritenii l-au rugat să rămână cu ei. El a rămas acolo două zile. ");
INSERT INTO ronlsb_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Mulți alții au crezut datorită cuvântului lui. ");
INSERT INTO ronlsb_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ei i-au spus femeii: “Acum credem, nu din cauza vorbelor tale, ci pentru că am auzit cu ochii noștri și știm că acesta este cu adevărat Hristosul, Mântuitorul lumii.” ");
INSERT INTO ronlsb_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","După cele două zile, a ieșit de acolo și s-a dus în Galileea. ");
INSERT INTO ronlsb_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Căci Isus însuși a mărturisit că un profet nu are onoare în țara sa. ");
INSERT INTO ronlsb_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Când a ajuns în Galileea, galileenii L-au primit, după ce au văzut tot ce făcuse la Ierusalim la sărbătoare, căci și ei mergeau la sărbătoare. ");
INSERT INTO ronlsb_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Isus a venit deci din nou la Cana Galileii, unde a transformat apa în vin. Era un nobil al cărui fiu era bolnav la Capernaum. ");
INSERT INTO ronlsb_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Când a auzit că Isus a ieșit din Iudeea în Galileea, s-a dus la el și l-a rugat să se coboare și să-i vindece fiul, căci era la un pas de moarte. ");
INSERT INTO ronlsb_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Isus i-a zis: “Dacă nu vei vedea semne și minuni, nu vei crede nicidecum”. ");
INSERT INTO ronlsb_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Și nobilul i-a zis: “Domnule, coboară-te, până nu moare copilul meu.” ");
INSERT INTO ronlsb_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Isus i-a zis: “Du-te și mergi. Fiul tău trăiește”. Omul a crezut cuvântul pe care i-l spusese Isus și a plecat. ");
INSERT INTO ronlsb_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Pe când cobora, l-au întâlnit slujitorii lui și i-au raportat: “Fiul tău trăiește!” ");
INSERT INTO ronlsb_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Și i-a întrebat pe ei la ce oră a început să se facă bine. Ei i-au spus deci: “Ieri, în ceasul al șaptelea, febra l-a lăsat.” ");
INSERT INTO ronlsb_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Astfel, tatăl a știut că a fost în ceasul acela în care Isus i-a spus: “Fiul tău trăiește.” El a crezut, ca și toată casa lui. ");
INSERT INTO ronlsb_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Acesta este iarăși al doilea semn pe care l-a făcut Isus, după ce a ieșit din Iudeea în Galileea. ");
INSERT INTO ronlsb_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","După aceste lucruri, a fost o sărbătoare a iudeilor, și Isus s-a suit la Ierusalim. ");
INSERT INTO ronlsb_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","În Ierusalim, lângă poarta oilor, se află un bazin care se numește în ebraică “Betesda”, având cinci pridvoare. ");
INSERT INTO ronlsb_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","În acestea zăcea o mare mulțime de bolnavi, orbi, șchiopi sau paralizați, care așteptau să se miște apa; ");
INSERT INTO ronlsb_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","pentru că un înger se cobora în anumite momente în bazin și agita apa. Cel care intra primul în bazin, după ce se agita apa, era vindecat de orice boală pe care o avea. ");
INSERT INTO ronlsb_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Era acolo un om care era bolnav de treizeci și opt de ani. ");
INSERT INTO ronlsb_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Când Isus l-a văzut zăcând acolo și a știut că era bolnav de multă vreme, l-a întrebat: “Vrei să te faci sănătos?” ");
INSERT INTO ronlsb_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Și bolnavul i-a răspuns: “Domnule, nu am pe nimeni care să mă bage în bazin când se agită apa, ci, în timp ce vin, altul coboară înaintea mea.” ");
INSERT INTO ronlsb_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Isus i-a zis: “Scoală-te, ia-ți rogojina și umblă.” ");
INSERT INTO ronlsb_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Îndată omul s-a făcut sănătos, și-a luat roata și a mers. În ziua aceea era Sabat. ");
INSERT INTO ronlsb_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Și iudeii au zis către cel vindecat: “Este Sabat. Nu-ți este îngăduit să cari covorul”. ");
INSERT INTO ronlsb_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","El le-a răspuns: “Cel ce m-a făcut sănătos mi-a zis: “Ia-ți roata și umblă!”” ");
INSERT INTO ronlsb_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Și L-au întrebat: “Cine este omul care ți-a zis: “Ia-ți roata și umblă”?” ");
INSERT INTO ronlsb_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Dar cel vindecat nu știa cine era, pentru că Isus se retrăsese, fiindcă era mulțime în locul acela. ");
INSERT INTO ronlsb_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","După aceea, Isus l-a găsit în templu și i-a zis: “Iată că te-ai făcut sănătos. Nu mai păcătui, ca să nu ți se întâmple nimic mai rău.” ");
INSERT INTO ronlsb_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Omul s-a dus și a spus iudeilor că Isus îl făcuse sănătos. ");
INSERT INTO ronlsb_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Din această cauză, iudeii l-au prigonit pe Isus și căutau să-L omoare, pentru că făcea aceste lucruri în ziua de Sabat. ");
INSERT INTO ronlsb_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Dar Isus le-a răspuns: “Tatăl Meu lucrează încă, așa că lucrez și eu.” ");
INSERT INTO ronlsb_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","De aceea iudeii căutau cu atât mai mult să-L omoare, cu cât nu numai că a călcat Sabatul, dar a și numit pe Dumnezeu Tatăl său, făcându-se pe sine egal cu Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Isus le-a răspuns: “Adevărat, vă spun că Fiul nu poate face nimic de la sine, ci doar ceea ce vede pe Tatăl făcând. Căci tot ceea ce face El, face și Fiul la fel. ");
INSERT INTO ronlsb_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Căci Tatăl are afecțiune pentru Fiul și îi arată toate lucrurile pe care le face el însuși. Îi va arăta lucrări mai mari decât acestea, ca să vă minunați. ");
INSERT INTO ronlsb_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Căci, după cum Tatăl înviază morții și le dă viață, tot așa și Fiul dă viață oricui dorește. ");
INSERT INTO ronlsb_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Căci Tatăl nu judecă pe nimeni, ci a dat toată judecata Fiului, ");
INSERT INTO ronlsb_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","pentru ca toți să cinstească pe Fiul, așa cum cinstesc pe Tatăl. Cine nu-l onorează pe Fiul, nu-l onorează pe Tatăl care l-a trimis. ");
INSERT INTO ronlsb_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Adevărat vă spun că cine ascultă cuvântul Meu și crede pe Cel ce M-a trimis pe Mine are viață veșnică și nu vine la judecată, ci a trecut din moarte la viață. ");
INSERT INTO ronlsb_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Adevărat vă spun că vine ceasul, și acum este, când cei morți vor auzi glasul Fiului lui Dumnezeu, iar cei ce-l vor auzi vor trăi. ");
INSERT INTO ronlsb_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Căci, după cum Tatăl are viața în Sine, tot așa a dat și Fiului să aibă viața în Sine. ");
INSERT INTO ronlsb_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","I-a dat, de asemenea, autoritatea de a face judecată, pentru că este fiu al omului. ");
INSERT INTO ronlsb_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Nu vă mirați de aceasta, căci vine ceasul în care toți cei care sunt în morminte vor auzi glasul lui ");
INSERT INTO ronlsb_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","și vor ieși: cei care au făcut binele, la învierea vieții, iar cei care au făcut răul, la învierea judecății. ");
INSERT INTO ronlsb_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Eu nu pot de la mine însumi să fac nimic. Cum aud, judec; și judecata mea este dreaptă, pentru că nu caut voia mea, ci voia Tatălui meu care m-a trimis. ");
INSERT INTO ronlsb_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Dacă mărturisesc despre mine însumi, mărturia mea nu este valabilă. ");
INSERT INTO ronlsb_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Cel care depune mărturie despre mine este altul. Știu că mărturia pe care o depune el despre mine este adevărată. ");
INSERT INTO ronlsb_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Tu ai trimis la Ioan și el a mărturisit adevărul. ");
INSERT INTO ronlsb_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Dar mărturia pe care o primesc eu nu vine de la om. Totuși, spun aceste lucruri pentru ca voi să fiți mântuiți. ");
INSERT INTO ronlsb_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","El era lampa aprinsă și strălucitoare și voi ați vrut să vă bucurați pentru o vreme de lumina lui. ");
INSERT INTO ronlsb_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Dar mărturia pe care o am eu este mai mare decât cea a lui Ioan; pentru că lucrările pe care Tatăl mi-a dat să le îndeplinesc, chiar lucrările pe care le fac eu, mărturisesc despre mine că Tatăl m-a trimis. ");
INSERT INTO ronlsb_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Însuși Tatăl, care m-a trimis, a mărturisit despre mine. Voi nu i-ați auzit niciodată vocea și nici nu i-ați văzut forma. ");
INSERT INTO ronlsb_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Nu aveți cuvântul lui care trăiește în voi, pentru că nu credeți în cel pe care l-a trimis. ");
INSERT INTO ronlsb_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Voi cercetați Scripturile, pentru că credeți că în ele aveți viața veșnică; și acestea sunt cele ce mărturisesc despre Mine. ");
INSERT INTO ronlsb_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Și totuși nu vreți să veniți la Mine, ca să aveți viața. ");
INSERT INTO ronlsb_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Eu nu primesc slavă de la oameni. ");
INSERT INTO ronlsb_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Dar vă cunosc pe voi, că nu aveți în voi înșivă dragostea lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Eu am venit în numele Tatălui Meu, și voi nu Mă primiți. Dacă vine altul în numele lui, îl veți primi. ");
INSERT INTO ronlsb_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Cum puteți crede voi, care primiți slavă unii de la alții, iar voi nu căutați slava care vine de la singurul Dumnezeu? ");
INSERT INTO ronlsb_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Să nu credeți că vă voi acuza la Tatăl. Este unul care vă acuză, chiar Moise, în care v-ați pus nădejdea. ");
INSERT INTO ronlsb_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Căci, dacă l-ați crede pe Moise, m-ați crede și pe mine, căci el a scris despre mine. ");
INSERT INTO ronlsb_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Dardacă nu credeți scrierile lui, cum veți crede cuvintele mele?”. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","După acestea, Isus a plecat de cealaltă parte a Mării Galileii, care se numește Marea Tiberiadei. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","O mare mulțime de oameni Îl urmau, pentru că vedeau semnele pe care le făcea asupra celor bolnavi. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Isus s-a urcat pe munte și a șezut acolo cu discipolii Săi. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Se apropia Paștele, sărbătoarea iudeilor. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Isus, ridicându-și ochii și văzând că o mare mulțime venea la El, a zis lui Filip: “De unde vom cumpăra pâine, ca să mănânce aceștia?” ");
INSERT INTO ronlsb_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","A spus aceasta ca să-l pună la încercare, căci știa el însuși ce va face. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filip i-a răspuns: “Nu le ajunge pâinea de două sute de denari, ca să primească fiecare din ei câte puțin.” ");
INSERT INTO ronlsb_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Unul din ucenicii Săi, Andrei, fratele lui Simon Petru, i-a zis: ");
INSERT INTO ronlsb_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Este aici un băiat care are cinci pâini de orz și doi pești; dar ce sunt aceștia între atâția?” ");
INSERT INTO ronlsb_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Isus a zis: “Fă să șadă poporul.” Or, în locul acela era multă iarbă. Deci oamenii au luat loc, în număr de aproximativ cinci mii. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Isus a luat pâinile și, după ce a mulțumit, a împărțit ucenicilor, iar ucenicii celor ce stăteau jos, la fel și din pește, atât cât au dorit. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","După ce s-au săturat, a zis ucenicilor Săi: “Adunați bucățile rămase, ca să nu se piardă nimic.” ");
INSERT INTO ronlsb_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ei le-au adunat și au umplut douăsprezece coșuri cu bucățile rupte din cele cinci pâini de orz, care rămăseseră de la cei care mâncaseră. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","De aceea, când a văzut poporul semnul pe care-l făcea Isus, a zis: “Acesta este cu adevărat profetul care vine în lume.” ");
INSERT INTO ronlsb_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Isus, deci, dându-și seama că sunt pe cale să vină și să îl ia cu forța ca să îl facă rege, s-a retras din nou pe munte, de unul singur. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Când s-a făcut seară, ucenicii Lui s-au coborât la mare. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","S-au urcat în corabie și se îndreptau peste mare spre Capernaum. Era deja întuneric și Isus nu venise la ei. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Marea era agitată de un vânt mare care sufla. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","După ce au vâslit, așadar, vreo douăzeci și cinci sau treizeci de stadii, au văzut pe Isus mergând pe mare și apropiindu-se de barcă; și s-au temut. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Dar El le-a zis: “Eu sunt; nu vă temeți.” ");
INSERT INTO ronlsb_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ei au fost deci dispuși să îl primească în barcă. Imediat, barca a ajuns la țărmul spre care se îndreptau. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","A doua zi, mulțimea care stătea de cealaltă parte a mării a văzut că nu mai era acolo altă corabie decât cea în care se îmbarcaseră ucenicii Lui și că Isus nu intrase cu ucenicii Lui în corabie, ci ucenicii Lui plecaseră singuri. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Cu toate acestea, niște bărci venite dinspre Tiberiada s-au apropiat de locul unde mâncaseră pâinea după ce Domnul a mulțumit. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Așadar, când mulțimea a văzut că Isus și discipolii lui nu erau acolo, s-a urcat ea însăși în bărci și a venit la Capernaum, căutându-l pe Isus. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Când L-au găsit pe partea cealaltă a mării, L-au întrebat: “Rabi, când ai venit aici?” ");
INSERT INTO ronlsb_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Isus le-a răspuns: “Adevărat vă spun că Mă căutați, nu pentru că ați văzut semne, ci pentru că ați mâncat din pâini și v-ați săturat. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Nu lucrați pentru hrana care piere, ci pentru hrana care rămâne pentru viața veșnică, pe care v-o va da Fiul Omului. Căci Dumnezeu Tatăl l-a pecetluit.” ");
INSERT INTO ronlsb_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Și I-au zis: “Ce trebuie să facem ca să lucrăm lucrările lui Dumnezeu?” ");
INSERT INTO ronlsb_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Isus le-a răspuns: “Aceasta este lucrarea lui Dumnezeu: să credeți în Cel pe care L-a trimis El.” ");
INSERT INTO ronlsb_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Și I-au zis: “Ce faci Tu ca semn, ca să te vedem și să te credem? Ce lucrare faci tu? ");
INSERT INTO ronlsb_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Părinții noștri au mâncat mană în pustiu. După cum este scris: “Le-a dat să mănânce pâine din cer”.” ");
INSERT INTO ronlsb_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Isus le-a zis: “Adevărat vă spun că nu Moise v-a dat pâinea din cer, ci Tatăl Meu vă dă adevărata pâine din cer. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Căci pâinea lui Dumnezeu este cea care se coboară din cer și dă viață lumii.” ");
INSERT INTO ronlsb_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Și I-au zis: “Doamne, dă-ne totdeauna pâinea aceasta.” ");
INSERT INTO ronlsb_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Isus le-a zis: “Eu sunt pâinea vieții. Cine vine la mine nu va flămânzi și cine crede în mine nu va înseta niciodată. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Dar v-am spus că m-ați văzut și totuși nu credeți. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Toți cei pe care mi-i dă Tatăl vor veni la mine. Pe cel care vine la mine nu-l voi da afară în niciun fel. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Căci Eu m-am coborât din cer, nu ca să fac voia Mea, ci voia Celui care M-a trimis. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Aceasta este voia Tatălui Meu care m-a trimis: ca din toți cei pe care Mi i-a dat să nu pierd nimic, ci să-i înviez în ziua de apoi. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Aceasta este voia Celui care m-a trimis: ca oricine vede pe Fiul și crede în El să aibă viața veșnică; și Eu îl voi învia în ziua de apoi.” ");
INSERT INTO ronlsb_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","De aceea Iudeii cârteau împotriva Lui, pentru că zicea: “Eu sunt pâinea care S-a pogorât din cer”. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ei ziceau: “Nu este acesta Isus, fiul lui Iosif, al cărui tată și mamă îi știm? Cum de spune atunci: “Eu am coborât din cer?”?” ");
INSERT INTO ronlsb_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","De aceea Isus le-a răspuns: “Nu vă certați între voi. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nimeni nu poate veni la Mine, dacă nu-l atrage Tatăl care M-a trimis; și Eu îl voi învia în ziua de apoi. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Este scris în profeți: “Toți vor fi învățați de Dumnezeu”. De aceea, oricine aude de la Tatăl și a învățat, vine la mine. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nu că cineva a văzut pe Tatăl, decât cel care vine de la Dumnezeu. El l-a văzut pe Tatăl. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Adevărat, vă spun, cel ce crede în Mine are viața veșnică. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Eu sunt pâinea vieții. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Părinții voștri au mâncat mană în pustiu și au murit. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Aceasta este pâinea care se coboară din cer, ca oricine să mănânce din ea și să nu moară. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Eu sunt pâinea vie care s-a coborât din cer. Dacă cineva mănâncă din pâinea aceasta, va trăi în veci. Da, pâinea pe care o voi da pentru viața lumii este carnea mea.” ");
INSERT INTO ronlsb_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Și iudeii se certau între ei, zicând: “Cum ne va da Acesta să mâncăm carnea Lui?” ");
INSERT INTO ronlsb_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Isus le-a zis: “Adevărat vă spun că, dacă nu mâncați carnea Fiului Omului și nu beți sângele Lui, nu aveți viață în voi înșivă. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Cine mănâncă carnea Mea și bea sângele Meu are viață veșnică și Eu îl voi învia în ziua de apoi. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Căci carnea Mea este cu adevărat hrană și sângele Meu este cu adevărat băutură. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Cine mănâncă carnea Mea și bea sângele Meu trăiește în Mine și Eu în el. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","După cum Tatăl cel viu m-a trimis pe mine și eu trăiesc datorită Tatălui, tot așa și cel care se hrănește din mine va trăi datorită mie. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Aceasta este pâinea care s-a coborât din cer — nu cum au mâncat părinții noștri mana și au murit. Cel care mănâncă această pâine va trăi în veci.” ");
INSERT INTO ronlsb_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","El spunea aceste lucruri în sinagogă, pe când învăța în Capernaum. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","De aceea mulți dintre ucenicii Lui, auzind aceasta, au zis: “Greu este să spui aceasta! Cine poate să o asculte?” ");
INSERT INTO ronlsb_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Dar Isus, știind că ucenicii Săi murmurau din pricina aceasta, le-a zis: “Oare vă împiedică aceasta? ");
INSERT INTO ronlsb_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Atunci, dacă ați vrea să vedeți pe Fiul Omului înălțându-se la locul unde era mai înainte? ");
INSERT INTO ronlsb_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Spiritul este cel care dă viață. Carnea nu folosește la nimic. Cuvintele pe care vi le spun sunt spirit și sunt viață. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Dar sunt unii dintre voi care nu cred.” Pentru că Isus știa de la început cine sunt cei care nu credeau și cine sunt cei care aveau să-l trădeze. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","El a spus: “De aceea v-am spus că nimeni nu poate veni la mine, dacă nu-i este dat de Tatăl meu.” ");
INSERT INTO ronlsb_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Mulți din ucenicii Lui s-au întors și nu mai umblau cu El. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Isus le-a zis deci celor doisprezece: “Nu cumva vreți și voi să plecați?” ");
INSERT INTO ronlsb_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Petru I-a răspuns: “Doamne, la cine să mergem? Tu ai cuvintele vieții veșnice. ");
INSERT INTO ronlsb_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Noi am ajuns să credem și să știm că Tu ești Hristosul, Fiul Dumnezeului celui viu.” ");
INSERT INTO ronlsb_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Isus le-a răspuns: “Nu v-am ales Eu pe voi, cei doisprezece, și unul dintre voi este un diavol?” ");
INSERT INTO ronlsb_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Și vorbea despre Iuda, fiul lui Simon Iscarioteanul, căci el era cel care avea să-L trădeze, fiind unul dintre cei doisprezece. ");
INSERT INTO ronlsb_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","După acestea, Isus umbla prin Galileea, căci nu voia să umble în Iudeea, pentru că iudeii căutau să-L omoare. ");
INSERT INTO ronlsb_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Or, sărbătoarea iudeilor, sărbătoarea Bobotezei, era aproape. ");
INSERT INTO ronlsb_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Frații Lui i-au zis: “Pleacă de aici și du-te în Iudeea, ca să vadă și ucenicii Tăi lucrările pe care le faci. ");
INSERT INTO ronlsb_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Căci nimeni nu face nimic în secret, în timp ce caută să fie cunoscut în mod deschis. Dacă tu faci aceste lucruri, descoperă-te lumii.” ");
INSERT INTO ronlsb_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Căci nici măcar frații lui nu credeau în el. ");
INSERT INTO ronlsb_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Atunci Isus le-a zis: “Încă nu a venit vremea Mea, dar vremea voastră este totdeauna gata. ");
INSERT INTO ronlsb_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Lumea nu vă poate urî pe voi, dar pe Mine Mă urăște, pentru că Eu mărturisesc despre ea că faptele ei sunt rele. ");
INSERT INTO ronlsb_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Voi vă urcați la ospăț. Eu nu mă sui încă la acest ospăț, pentru că timpul meu nu s-a împlinit încă.” ");
INSERT INTO ronlsb_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","După ce le-a spus aceste lucruri, a rămas în Galileea. ");
INSERT INTO ronlsb_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Când frații lui s-au suit la ospăț, s-a suit și el, dar nu în public, ci ca în secret. ");
INSERT INTO ronlsb_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Iudeii îl căutau deci la ospăț și întrebau: “Unde este?” ");
INSERT INTO ronlsb_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Și a fost multă murmurare în mulțime cu privire la el. Unii spuneau: “Este un om bun”. Alții spuneau: “Nu-i așa, dar el duce mulțimea în rătăcire”. ");
INSERT INTO ronlsb_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Totuși, nimeni nu vorbea deschis despre el, de frica iudeilor. ");
INSERT INTO ronlsb_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Dar, când era deja mijlocul sărbătorii, Isus s-a urcat în templu și învăța. ");
INSERT INTO ronlsb_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Iudeii se mirau deci și ziceau: “Cum de știe acesta litere, fără să fi fost educat niciodată?” ");
INSERT INTO ronlsb_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Isus le-a răspuns: “Nu a Mea este învățătura Mea, ci a Celui ce M-a trimis. ");
INSERT INTO ronlsb_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Dacă cineva vrea să facă voia Lui, va cunoaște învățătura, dacă este de la Dumnezeu sau dacă vorbesc de la mine însumi. ");
INSERT INTO ronlsb_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Cine vorbește de la sine caută propria slavă, dar cine caută slava celui care l-a trimis pe el este adevărat și nu există nedreptate în el. ");
INSERT INTO ronlsb_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Nu v-a dat Moise Legea, și totuși niciunul dintre voi nu respectă Legea? De ce căutați să mă omorâți?” ");
INSERT INTO ronlsb_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Mulțimea a răspuns: “Ai un demon! Cine caută să te ucidă?” ");
INSERT INTO ronlsb_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Isus le-a răspuns: “Eu am făcut o singură lucrare și voi toți vă mirați de ea. ");
INSERT INTO ronlsb_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moise v-a dat circumcizia (nu că ar fi de la Moise, ci de la părinți) și în Sabat circumcideți un băiat. ");
INSERT INTO ronlsb_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Dacă un băiat primește circumcizia în Sabat, ca să nu se încalce Legea lui Moise, vă supărați pe Mine pentru că am făcut un om complet sănătos în Sabat? ");
INSERT INTO ronlsb_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Nu judecați după aparențe, ci judecați cu dreaptă judecată.” ");
INSERT INTO ronlsb_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","De aceea, unii din cei din Ierusalim au zis: “Nu cumva nu este acesta pe care caută să-L omoare? ");
INSERT INTO ronlsb_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Iată că el vorbește deschis, și ei nu-i spun nimic. Se poate oare ca într-adevăr conducătorii să știe că acesta este cu adevărat Hristosul? ");
INSERT INTO ronlsb_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Totuși, noi știm de unde vine omul acesta, dar când va veni Hristosul, nimeni nu va ști de unde vine.” ");
INSERT INTO ronlsb_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Isus a strigat în templu, învățând și zicând: “Voi Mă cunoașteți și știți de unde sunt. Eu n-am venit de la mine însumi, ci Cel care m-a trimis este adevărat, pe care voi nu-l cunoașteți. ");
INSERT INTO ronlsb_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Îl cunosc, pentru că Eu sunt de la El și El m-a trimis.” ");
INSERT INTO ronlsb_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Au căutat deci să-L prindă, dar nimeni n-a pus mâna pe El, pentru că nu venise încă ceasul Lui. ");
INSERT INTO ronlsb_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Dar, din mulțime, mulți au crezut în El. Ei spuneau: “Când va veni Hristosul, nu va face mai multe semne decât cele pe care le-a făcut acesta, nu-i așa?” ");
INSERT INTO ronlsb_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Fariseii au auzit mulțimea murmurând aceste lucruri despre el și preoții cei mai de seamă și fariseii au trimis ofițeri ca să-l aresteze. ");
INSERT INTO ronlsb_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Atunci Isus a zis: “Mai stau puțin cu voi, apoi Mă duc la Cel ce M-a trimis. ");
INSERT INTO ronlsb_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mă veți căuta și nu mă veți găsi. Nu puteți veni acolo unde sunt eu.” ");
INSERT INTO ronlsb_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Și iudeii ziceau între ei: “Unde se va duce omul acesta, ca să nu-l găsim? Se va duce oare în Dispersia dintre greci și îi va învăța pe greci? ");
INSERT INTO ronlsb_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ce este cuvântul acesta pe care l-a spus: “Mă veți căuta și nu Mă veți găsi” și “Unde sunt Eu, nu puteți veni”?” ");
INSERT INTO ronlsb_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","În ultima și cea mai mare zi a praznicului, Isus, stând în picioare, a strigat: “Dacă însetează cineva, să vină la Mine și să bea! ");
INSERT INTO ronlsb_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Cine crede în mine, după cum spune Scriptura, dinlăuntrul lui vor curge râuri de apă vie.” ");
INSERT INTO ronlsb_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Dar a spus următoarele despre Duhul Sfânt, pe care urmau să-l primească cei care credeau în el. Căci Duhul Sfânt nu fusese încă dat, pentru că Isus nu fusese încă glorificat. ");
INSERT INTO ronlsb_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Mulți din mulțime, auzind aceste cuvinte, ziceau: “Acesta este cu adevărat proorocul”. ");
INSERT INTO ronlsb_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Alții ziceau: “Acesta este Hristosul”. Dar unii ziceau: “Ce, oare Hristosul vine din Galileea? ");
INSERT INTO ronlsb_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Nu a spus oare Scriptura că Hristosul vine din neamul lui David și din Betleem, satul în care era David?” ");
INSERT INTO ronlsb_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Și s-a creat o dezbinare în mulțime din cauza lui. ");
INSERT INTO ronlsb_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Unii dintre ei ar fi vrut să-l aresteze, dar nimeni nu a pus mâna pe el. ");
INSERT INTO ronlsb_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ofițerii au venit deci la preoții cei mai de seamă și la farisei, care i-au întrebat: “De ce nu l-ați adus?” ");
INSERT INTO ronlsb_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ofițerii au răspuns: “Nimeni n-a vorbit vreodată ca omul acesta!” ");
INSERT INTO ronlsb_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Fariseii le-au răspuns: “Nu cumva și voi sunteți rătăciți? ");
INSERT INTO ronlsb_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","A crezut oare vreunul dintre dregători sau vreunul dintre farisei în el? ");
INSERT INTO ronlsb_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Dar mulțimea aceasta care nu cunoaște Legea este blestemată.” ");
INSERT INTO ronlsb_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodim, care venise noaptea la El, fiind unul dintre ei, le-a zis: ");
INSERT INTO ronlsb_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Oare legea noastră judecă pe cineva dacă nu-l aude mai întâi și nu știe ce face?” ");
INSERT INTO ronlsb_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ei I-au răspuns: “Și Tu ești din Galileea? Caută și vezi că din Galileea nu s-a ridicat niciun profet.” ");
INSERT INTO ronlsb_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Fiecare s-a dus la casa lui, ");
INSERT INTO ronlsb_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Dar Isus s-a dus pe Muntele Măslinilor. ");
INSERT INTO ronlsb_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Și, dis-de-dimineață, a intrat din nou în Templu și tot poporul a venit la El. El a șezut jos și i-a învățat. ");
INSERT INTO ronlsb_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Cărturarii și fariseii au adus o femeie prinsă în adulter. După ce au așezat-o la mijloc, ");
INSERT INTO ronlsb_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","i-au spus: “Învățătorule, am găsit-o pe această femeie în adulter, chiar în flagrant. ");
INSERT INTO ronlsb_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Or, în legea noastră, Moise ne-a poruncit să ucidem cu pietre astfel de femei. Ce spui, așadar, despre ea?” ");
INSERT INTO ronlsb_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ei au spus aceasta punându-l la încercare, ca să aibă de ce să-l acuze. Dar Isus s-a aplecat și a scris cu degetul pe pământ. ");
INSERT INTO ronlsb_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Dar, când ei continuau să-L întrebe, El și-a ridicat privirea și le-a zis: “Cine dintre voi este fără de păcat, să arunce primul cu piatra în ea.” ");
INSERT INTO ronlsb_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Și iarăși s-a aplecat și a scris cu degetul pe pământ. ");
INSERT INTO ronlsb_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Când au auzit, ei, încredințați de conștiința lor, au ieșit unul câte unul, începând de la cel mai bătrân până la cel din urmă. Isus a rămas singur cu femeia acolo unde era, în mijloc. ");
INSERT INTO ronlsb_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Isus, ridicându-se în picioare, a văzut-o și a zis: “Femeie, unde sunt acuzatorii tăi? Nu te-a condamnat nimeni?”. ");
INSERT INTO ronlsb_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ea a răspuns: “Nimeni, Doamne.” Isus a spus: “Nici Eu nu vă condamn. Mergeți pe drumul vostru. De acum încolo, să nu mai păcătuiești”. ");
INSERT INTO ronlsb_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Isus le-a vorbit din nou, zicând: “Eu sunt lumina lumii. Cine Mă urmează pe Mine nu va umbla în întuneric, ci va avea lumina vieții.” ");
INSERT INTO ronlsb_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Fariseii I-au zis: “Tu mărturisești despre tine însuți. Mărturia ta nu este valabilă”. ");
INSERT INTO ronlsb_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Isus le-a răspuns: “Chiar dacă mărturisesc despre mine însumi, mărturia mea este adevărată, căci eu știu de unde am venit și unde mă duc; dar voi nu știți de unde am venit și unde mă duc. ");
INSERT INTO ronlsb_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Voi judecați după trup. Eu nu judec pe nimeni. ");
INSERT INTO ronlsb_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Chiar dacă judec, judecata mea este adevărată, pentru că nu sunt singur, ci sunt cu Tatăl care m-a trimis. ");
INSERT INTO ronlsb_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","De asemenea, este scris în legea voastră că mărturia a doi oameni este valabilă. ");
INSERT INTO ronlsb_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Eu sunt cel care mărturisește despre mine însumi, iar Tatăl care m-a trimis mărturisește despre mine.” ");
INSERT INTO ronlsb_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Și I-au zis: “Unde este Tatăl Tău?” Isus a răspuns: “Nu Mă cunoașteți nici pe Mine, nici pe Tatăl Meu. Dacă M-ați cunoaște pe Mine, L-ați cunoaște și pe Tatăl Meu.” ");
INSERT INTO ronlsb_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Isus a rostit aceste cuvinte în vistierie, în timp ce învăța în templu. Dar nimeni nu l-a arestat, pentru că nu venise încă ceasul lui. ");
INSERT INTO ronlsb_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Isus le-a spus deci din nou: “Mă duc, și voi mă veți căuta și veți muri în păcatele voastre. Unde Mă duc Eu, voi nu puteți veni”. ");
INSERT INTO ronlsb_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Iudeii ziceau: “Oare se va omorî El însuși, pentru că zice: “Unde Mă duc Eu, voi nu puteți veni”?” ");
INSERT INTO ronlsb_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","El le-a zis: “Voi sunteți de jos. Eu sunt de sus. Voi sunteți din lumea aceasta. Eu nu sunt din lumea aceasta. ");
INSERT INTO ronlsb_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","De aceea v-am spus că veți muri în păcatele voastre; căci, dacă nu credeți că Eu sunt, veți muri în păcatele voastre.” ");
INSERT INTO ronlsb_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Și I-au zis: “Cine ești Tu?” Isus le-a spus: “Exact ceea ce v-am spus de la început. ");
INSERT INTO ronlsb_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Am multe lucruri de spus și de judecat cu privire la voi. Totuși, cel care m-a trimis este adevărat; și lucrurile pe care le-am auzit de la el, acestea le spun lumii.” ");
INSERT INTO ronlsb_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ei nu înțelegeau că El le vorbea despre Tatăl. ");
INSERT INTO ronlsb_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Isus le-a zis deci: “Când veți ridica pe Fiul Omului, atunci veți cunoaște că Eu sunt El și nu fac nimic de la mine însumi, ci spun aceste lucruri așa cum M-a învățat Tatăl Meu. ");
INSERT INTO ronlsb_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Cel care m-a trimis este cu mine. Tatăl nu m-a lăsat singur, pentru că eu fac întotdeauna lucrurile care îi sunt plăcute.” ");
INSERT INTO ronlsb_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Pe când vorbea El aceste lucruri, mulți au crezut în El. ");
INSERT INTO ronlsb_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Isus a zis deci iudeilor care crezuseră în El: “Dacă rămâneți în cuvântul Meu, sunteți cu adevărat ucenicii Mei. ");
INSERT INTO ronlsb_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Veți cunoaște adevărul și adevărul vă va face liberi.” ");
INSERT INTO ronlsb_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ei i-au răspuns: “Noi suntem urmașii lui Avraam și n-am fost niciodată robi nimănui. Cum spui tu: “Veți fi liberi”?” ");
INSERT INTO ronlsb_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Isus le-a răspuns: “Adevărat vă spun că oricine săvârșește un păcat este robul păcatului. ");
INSERT INTO ronlsb_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","O roabă nu locuiește în casă pentru totdeauna. Un fiu rămâne pentru totdeauna. ");
INSERT INTO ronlsb_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Așadar, dacă Fiul vă face liberi, veți fi cu adevărat liberi. ");
INSERT INTO ronlsb_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Știu că sunteți urmașii lui Avraam, dar voi căutați să mă omorâți, pentru că cuvântul meu nu-și găsește locul în voi. ");
INSERT INTO ronlsb_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Eu spun lucrurile pe care le-am văzut la Tatăl meu, iar voi faceți și voi lucrurile pe care le-ați văzut la tatăl vostru.” ");
INSERT INTO ronlsb_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ei i-au răspuns: “Tatăl nostru este Avraam.” Isus le-a zis: “Dacă ați fi copiii lui Avraam, ați face faptele lui Avraam. ");
INSERT INTO ronlsb_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Dar acum căutați să Mă omorâți pe Mine, un om care v-a spus adevărul pe care l-am auzit de la Dumnezeu. Avraam nu a făcut asta. ");
INSERT INTO ronlsb_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Voi faceți faptele tatălui vostru.” Ei i-au spus: “Noi nu ne-am născut din imoralitate sexuală. Noi avem un singur Tată, Dumnezeu”. ");
INSERT INTO ronlsb_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Isus le-a zis: “Dacă Dumnezeu ar fi tatăl vostru, M-ați iubi, căci Eu am ieșit și am venit de la Dumnezeu. Căci nu am venit de la mine însumi, ci el m-a trimis. ");
INSERT INTO ronlsb_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","De ce nu înțelegeți vorbirea mea? Pentru că nu puteți auzi cuvântul meu. ");
INSERT INTO ronlsb_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Voi sunteți de la tatăl vostru, diavolul, și vreți să împliniți dorințele tatălui vostru. El a fost ucigaș de la început și nu stă în adevăr, pentru că nu este adevăr în el. Când vorbește o minciună, vorbește de unul singur, căci este un mincinos și tatăl minciunii. ");
INSERT INTO ronlsb_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Dar pentru că spun adevărul, voi nu mă credeți. ");
INSERT INTO ronlsb_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Care dintre voi mă convinge de păcat? Dacă spun adevărul, de ce nu mă credeți? ");
INSERT INTO ronlsb_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Cine este de la Dumnezeu ascultă cuvintele lui Dumnezeu. De aceea voi nu auziți, pentru că nu sunteți din Dumnezeu.” ");
INSERT INTO ronlsb_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Atunci Iudeii I-au răspuns: “Nu spunem noi bine că ești samaritean și că ai un demon?” ");
INSERT INTO ronlsb_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Isus a răspuns: “Eu nu am niciun demon, dar Eu Îl cinstesc pe Tatăl Meu, iar voi Mă necinstiți. ");
INSERT INTO ronlsb_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Dar eu nu caut gloria mea. Există cineva care caută și judecă. ");
INSERT INTO ronlsb_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Mai mult ca sigur, vă spun că, dacă o persoană respectă cuvântul meu, nu va vedea niciodată moartea.” ");
INSERT INTO ronlsb_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Atunci iudeii i-au zis: “Acum știm că ai un demon. Avraam a murit, ca și profeții, iar tu spui: “Dacă un om păzește cuvântul Meu, nu va gusta niciodată moartea”. ");
INSERT INTO ronlsb_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ești tu mai mare decât tatăl nostru Avraam, care a murit? Profeții au murit. Cine te dai tu drept cine ești?”. ");
INSERT INTO ronlsb_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Isus a răspuns: “Dacă mă slăvesc pe mine însumi, slava mea nu este nimic. Cel care mă slăvește pe mine este Tatăl meu, despre care voi spuneți că este Dumnezeul nostru. ");
INSERT INTO ronlsb_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Voi nu L-ați cunoscut, dar Eu Îl cunosc. Dacă aș spune: “Nu-l cunosc”, aș fi ca voi, un mincinos. Dar eu îl cunosc și îi respect cuvântul. ");
INSERT INTO ronlsb_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tatăl vostru Avraam s-a bucurat să vadă ziua mea. A văzut-o și s-a bucurat”. ");
INSERT INTO ronlsb_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Și Iudeii i-au zis: “Nu ești încă în vârstă de cincizeci de ani! L-ai văzut tu pe Avraam?” ");
INSERT INTO ronlsb_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Isus le-a zis: “Adevărat vă spun că, înainte ca Avraam să fi existat, EU SUNT.” ");
INSERT INTO ronlsb_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Și au luat pietre ca să arunce în El; dar Isus S-a ascuns și a ieșit din templu, trecând prin mijlocul lor, și a trecut pe lângă ei. ");
INSERT INTO ronlsb_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Pe când trecea pe acolo, a văzut un om orb din naștere. ");
INSERT INTO ronlsb_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ucenicii Lui l-au întrebat: “Rabi, cine a păcătuit, omul acesta sau părinții lui, de s-a născut orb?” ");
INSERT INTO ronlsb_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Isus a răspuns: “Omul acesta n-a păcătuit, nici părinții lui, ci ca să se arate în el lucrările lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Eu trebuie să lucrez lucrările celui care m-a trimis, cât este ziuă. Se apropie noaptea, când nimeni nu mai poate lucra. ");
INSERT INTO ronlsb_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Cât timp sunt în lume, eu sunt lumina lumii.” ");
INSERT INTO ronlsb_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","După ce a spus acestea, a scuipat pe pământ, a făcut noroi cu saliva, a uns cu noroi ochii orbului ");
INSERT INTO ronlsb_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","și i-a spus: “Du-te și te spală în piscina din Siloam” (care înseamnă “trimis”). El s-a dus, s-a spălat și s-a întors văzând. ");
INSERT INTO ronlsb_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","De aceea, vecinii și cei ce văzuseră mai înainte că era orb, ziceau: “Nu este acesta cel ce ședea și cerșea?” ");
INSERT INTO ronlsb_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Alții spuneau: “El este”. Alții încă mai spuneau: “Seamănă cu el”. El a spus: “Eu sunt”. ");
INSERT INTO ronlsb_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Și ei Îl întrebau: “Cum ți s-au deschis ochii?” ");
INSERT INTO ronlsb_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","El a răspuns: “Un om, numit Isus, a făcut noroi, mi-a uns ochii și mi-a zis: “Du-te la iazul din Siloam și te spală. Așa că m-am dus, m-am spălat și am primit vederea.” ");
INSERT INTO ronlsb_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Atunci l-au întrebat: “Unde este?” El a spus: “Nu știu”. ");
INSERT INTO ronlsb_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","L-au dus pe cel orb la farisei. ");
INSERT INTO ronlsb_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Era Sabat când Isus a făcut noroiul și i-a deschis ochii. ");
INSERT INTO ronlsb_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","De aceea și fariseii l-au întrebat iarăși cum și-a primit vederea. El le-a răspuns: “Mi-a pus noroi pe ochi, m-am spălat și văd”. ");
INSERT INTO ronlsb_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Și unii dintre farisei ziceau: “Omul acesta nu este de la Dumnezeu, pentru că nu ține Sabatul.” Alții spuneau: “Cum poate un om păcătos să facă asemenea semne?” Astfel, a fost dezbinare între ei. ");
INSERT INTO ronlsb_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","De aceea au întrebat iarăși pe orb: “Ce zici despre El, pentru că ți-a deschis ochii?” El a spus: “Este un profet”. ");
INSERT INTO ronlsb_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Iudeii n-au crezut despre El că fusese orb și că și-a recăpătat vederea, până ce au chemat pe părinții celui ce-și recăpătase vederea, ");
INSERT INTO ronlsb_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","și i-au întrebat: “Acesta este fiul vostru, despre care spuneți că s-a născut orb? Cum deci vede acum?” ");
INSERT INTO ronlsb_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Părinții lui le-au răspuns: “Știm că acesta este fiul nostru și că s-a născut orb; ");
INSERT INTO ronlsb_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","dar nu știm cum vede acum, și nu știm cine i-a deschis ochii. El este în vârstă. Întrebați-l pe el. Va vorbi el însuși”. ");
INSERT INTO ronlsb_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Părinții lui au spus aceste lucruri pentru că se temeau de iudei; căci iudeii se înțeleseseră deja că, dacă cineva îl va recunoaște ca fiind Hristos, va fi dat afară din sinagogă. ");
INSERT INTO ronlsb_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","De aceea, părinții lui au spus: “El este major. Întrebați-l”. ");
INSERT INTO ronlsb_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Și au chemat a doua oară pe orbul acela și i-au zis: “Slăvește pe Dumnezeu. Știm că omul acesta este un păcătos.” ");
INSERT INTO ronlsb_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","El a răspuns: “Nu știu dacă este păcătos. Un lucru știu însă: că, deși eram orb, acum văd.” ");
INSERT INTO ronlsb_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Și I-au zis iarăși: “Ce ți-a făcut? Cum ți-a deschis ochii?” ");
INSERT INTO ronlsb_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","El le-a răspuns: “V-am spus deja și nu m-ați ascultat. De ce vreți să auziți din nou? Nu vreți să deveniți și voi discipoli ai lui, nu-i așa?” ");
INSERT INTO ronlsb_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ei l-au insultat și au zis: “Tu ești ucenicul lui, iar noi suntem ucenicii lui Moise. ");
INSERT INTO ronlsb_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Noi știm că Dumnezeu a vorbit lui Moise. Dar în ceea ce-l privește pe acest om, nu știm de unde vine.” ");
INSERT INTO ronlsb_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Omul le-a răspuns: “Ce minunat! Voi nu știți de unde vine, și totuși mi-a deschis ochii. ");
INSERT INTO ronlsb_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Știm că Dumnezeu nu ascultă de păcătoși, dar dacă cineva este închinător lui Dumnezeu și face voia Lui, El îl ascultă. ");
INSERT INTO ronlsb_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","De la începutul lumii nu s-a auzit niciodată ca cineva să fi deschis ochii unui orb din naștere. ");
INSERT INTO ronlsb_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Dacă omul acesta nu era de la Dumnezeu, nu putea face nimic.” ");
INSERT INTO ronlsb_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ei I-au răspuns: “Tu, care te-ai născut cu totul în păcate, ne înveți pe noi?” Atunci l-au aruncat afară. ");
INSERT INTO ronlsb_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Isus a auzit că l-au dat afară și, găsindu-l, a zis: “Crezi tu în Fiul lui Dumnezeu?” ");
INSERT INTO ronlsb_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","El a răspuns: “Cine este El, Doamne, ca să cred în El?” ");
INSERT INTO ronlsb_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Isus i-a zis: “L-ați văzut amândoi și El este Cel ce vorbește cu voi.” ");
INSERT INTO ronlsb_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","El a zis: “Doamne, cred!” și s-a închinat lui. ");
INSERT INTO ronlsb_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Isus a zis: “Eu am venit în lumea aceasta ca să fac judecată, ca cei ce nu văd să vadă, iar cei ce văd să devină orbi.” ");
INSERT INTO ronlsb_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Fariseii care erau cu El, auzind aceste lucruri, I-au zis: “Suntem și noi orbi?” ");
INSERT INTO ronlsb_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Isus le-a zis: “Dacă ați fi orbi, n-ați avea nici un păcat; dar acum ziceți: “Vedem”. Prin urmare, păcatul vostru rămâne. ");
INSERT INTO ronlsb_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Adevărat vă spun că cel ce nu intră pe ușă în staulul oilor, ci se urcă pe altă cale, este un hoț și un tâlhar. ");
INSERT INTO ronlsb_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Dar cel care intră pe ușă este păstorul oilor. ");
INSERT INTO ronlsb_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Portarul îi deschide poarta, și oile ascultă de glasul lui. El își cheamă oile pe nume și le conduce afară. ");
INSERT INTO ronlsb_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ori de câte ori își scoate oile, el merge înaintea lor, și oile îl urmează, pentru că îi cunosc glasul. ");
INSERT INTO ronlsb_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ele nu vor urma nicidecum pe un străin, ci vor fugi de el, pentru că nu cunosc glasul străinilor.” ");
INSERT INTO ronlsb_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Isus le-a spus această parabolă, dar ei nu au înțeles ce le spunea. ");
INSERT INTO ronlsb_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Isus le-a zis din nou: “Adevărat, adevărat vă spun că Eu sunt ușa oilor. ");
INSERT INTO ronlsb_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Toți cei care au venit înaintea mea sunt hoți și tâlhari, dar oile nu i-au ascultat. ");
INSERT INTO ronlsb_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Eu sunt ușa. Dacă intră cineva prin mine, va fi mântuit, va intra și va ieși și va găsi pășune. ");
INSERT INTO ronlsb_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Hoțul vine numai ca să fure, să ucidă și să distrugă. Eu am venit ca ei să aibă viață și să o aibă din belșug. ");
INSERT INTO ronlsb_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Eu sunt păstorul cel bun. Păstorul cel bun își dă viața pentru oi. ");
INSERT INTO ronlsb_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Cel care este angajat și nu păstor, care nu este proprietarul oilor, vede lupul venind, lasă oile și fuge. Lupul smulge oile și le împrăștie. ");
INSERT INTO ronlsb_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Salariatului fuge, pentru că este salariat și nu are grijă de oi. ");
INSERT INTO ronlsb_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Eu sunt păstorul cel bun. Eu îmi cunosc pe ale mele și sunt cunoscut de ale mele; ");
INSERT INTO ronlsb_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","așa cum Tatăl mă cunoaște pe mine și eu îl cunosc pe Tatăl. Eu îmi dau viața pentru oi. ");
INSERT INTO ronlsb_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Am și alte oi care nu sunt din turma aceasta. Trebuie să le aduc și pe ele, și ele vor auzi glasul meu. Ele vor deveni o singură turmă cu un singur păstor. ");
INSERT INTO ronlsb_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","De aceea mă iubește Tatăl, pentru că îmi dau viața, ca să o iau din nou. ");
INSERT INTO ronlsb_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nimeni nu mi-o ia, ci eu mi-o pun singur. Eu am puterea să o dau și am puterea să o iau din nou. Am primit această poruncă de la Tatăl Meu.” ");
INSERT INTO ronlsb_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","De aceea s-a făcut iarăși dezbinare între iudei din cauza acestor cuvinte. ");
INSERT INTO ronlsb_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Mulți dintre ei spuneau: “Are un demon și este nebun! De ce îl ascultați?” ");
INSERT INTO ronlsb_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Alții au spus: “Acestea nu sunt spusele unuia posedat de un demon. Nu este posibil ca un demon să deschidă ochii unui orb, nu-i așa?” ");
INSERT INTO ronlsb_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Era Sărbătoarea Dedicării la Ierusalim. ");
INSERT INTO ronlsb_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Era iarnă, și Isus se plimba prin Templu, în pridvorul lui Solomon. ");
INSERT INTO ronlsb_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Iudeii s-au strâns în jurul lui și i-au zis: “Până când ne vei ține în suspans? Dacă tu ești Hristosul, spune-ne clar”. ");
INSERT INTO ronlsb_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Isus le-a răspuns: “V-am spus, și nu credeți. Lucrările pe care le fac în numele Tatălui meu, acestea mărturisesc despre mine. ");
INSERT INTO ronlsb_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Dar voi nu credeți, pentru că nu sunteți dintre oile Mele, așa cum v-am spus. ");
INSERT INTO ronlsb_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Oile Mele aud glasul Meu, și Eu le cunosc, și ele Mă urmează. ");
INSERT INTO ronlsb_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Eu le dau viața veșnică. Ele nu vor pieri niciodată și nimeni nu le va smulge din mâna mea. ");
INSERT INTO ronlsb_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tatăl Meu, care Mi le-a dat mie, este mai mare decât toți. Nimeni nu poate să le smulgă din mâna Tatălui meu. ");
INSERT INTO ronlsb_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Eu și Tatăl suntem una.” ");
INSERT INTO ronlsb_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","De aceea iudeii au luat iarăși pietre ca să-L ucidă cu pietre. ");
INSERT INTO ronlsb_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Isus le-a răspuns: “Eu v-am arătat multe fapte bune de la Tatăl Meu. Pentru care dintre aceste fapte Mă ucideți cu pietre?” ");
INSERT INTO ronlsb_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Iudeii I-au răspuns: “Noi nu te ucidem cu pietre pentru o faptă bună, ci pentru blasfemie, pentru că tu, fiind om, te faci pe tine însuți Dumnezeu.” ");
INSERT INTO ronlsb_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Isus le-a răspuns: “Nu este scris în legea voastră: “Eu am zis: “Voi sunteți dumnezei”?” ");
INSERT INTO ronlsb_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Dacă El i-a numit dumnezei pe cei la care a venit cuvântul lui Dumnezeu (și Scriptura nu poate fi călcată), ");
INSERT INTO ronlsb_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","spuneți voi despre Cel pe care Tatăl L-a sfințit și L-a trimis în lume: “Tu hulești”, pentru că Eu am zis: “Eu sunt Fiul lui Dumnezeu”? ");
INSERT INTO ronlsb_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Dacă nu fac faptele Tatălui Meu, nu Mă credeți. ");
INSERT INTO ronlsb_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Dar dacă le fac, chiar dacă nu mă credeți, credeți faptele, ca să știți și să credeți că Tatăl este în Mine și Eu în Tatăl.” ");
INSERT INTO ronlsb_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ei au căutat din nou să-L prindă, dar El a scăpat din mâna lor. ");
INSERT INTO ronlsb_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","S-a dus iarăși dincolo de Iordan, în locul unde botezase Ioan la început, și a rămas acolo. ");
INSERT INTO ronlsb_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Mulți veneau la el. Ei spuneau: “Într-adevăr, Ioan nu a făcut niciun semn, dar tot ce a spus Ioan despre omul acesta este adevărat.” ");
INSERT INTO ronlsb_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Mulți au crezut în el acolo. ");
INSERT INTO ronlsb_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Un om bolnav, Lazăr, din Betania, din satul Mariei și al Martei, sora ei, era bolnav. ");
INSERT INTO ronlsb_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maria, care unsese pe Domnul cu mir și Îi ștergea picioarele cu părul ei, era aceea al cărei frate, Lazăr, era bolnav. ");
INSERT INTO ronlsb_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","De aceea surorile au trimis la el, spunând: “Doamne, iată că cel pentru care ai mare afecțiune este bolnav.” ");
INSERT INTO ronlsb_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Dar Isus, auzind, a zis: “Boala aceasta nu este pentru moarte, ci pentru slava lui Dumnezeu, ca Fiul lui Dumnezeu să fie proslăvit prin ea.” ");
INSERT INTO ronlsb_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Isus iubea pe Marta, pe sora ei și pe Lazăr. ");
INSERT INTO ronlsb_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","De aceea, când a auzit că acesta era bolnav, a stat două zile în locul unde se afla. ");
INSERT INTO ronlsb_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","După aceea, a zis ucenicilor: “Să mergem din nou în Iudeea.” ");
INSERT INTO ronlsb_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ucenicii L-au întrebat: “Rabi, iudeii tocmai voiau să Te ucidă cu pietre. Te duci din nou acolo?” ");
INSERT INTO ronlsb_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Isus a răspuns: “Nu sunt oare douăsprezece ore de lumină? Dacă un om umblă ziua, nu se poticnește, pentru că vede lumina acestei lumi. ");
INSERT INTO ronlsb_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Dar dacă un om umblă noaptea, se împiedică, pentru că lumina nu este în el.” ");
INSERT INTO ronlsb_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","El a spus aceste lucruri și, după aceea, le-a zis: “Prietenul nostru Lazăr a adormit, dar eu mă duc ca să-l trezesc din somn.” ");
INSERT INTO ronlsb_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Și ucenicii au zis: “Doamne, dacă a adormit, își va reveni.” ");
INSERT INTO ronlsb_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Isus vorbise despre moartea Sa, dar ei credeau că vorbea despre odihna în somn. ");
INSERT INTO ronlsb_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Atunci Isus le-a spus clar și răspicat: “Lazăr a murit. ");
INSERT INTO ronlsb_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Mă bucur, pentru voi, că nu am fost acolo, ca să credeți. Totuși, să mergem la el”. ");
INSERT INTO ronlsb_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Toma, zis Didim, a zis tovarășilor săi ucenici: “Să mergem și noi, ca să murim împreună cu El”. ");
INSERT INTO ronlsb_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Când a venit Isus, a aflat că era deja de patru zile în mormânt. ");
INSERT INTO ronlsb_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania era aproape de Ierusalim, la o distanță de vreo cincisprezece stadii. ");
INSERT INTO ronlsb_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Mulți dintre iudei se alăturaseră femeilor din jurul Martei și al Mariei, ca să le consoleze cu privire la fratele lor. ");
INSERT INTO ronlsb_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Când a auzit Marta că vine Isus, s-a dus să-l întâmpine, dar Maria a rămas în casă. ");
INSERT INTO ronlsb_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Atunci Marta i-a zis lui Isus: “Doamne, dacă ai fi fost aici, fratele meu nu ar fi murit. ");
INSERT INTO ronlsb_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Chiar și acum știu că tot ce ceri de la Dumnezeu, Dumnezeu îți va da”. ");
INSERT INTO ronlsb_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Isus i-a zis: “Fratele tău va învia.” ");
INSERT INTO ronlsb_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta i-a zis: “Știu că va învia la înviere, în ziua de apoi.” ");
INSERT INTO ronlsb_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Isus i-a zis: “Eu sunt învierea și viața. Cel ce crede în Mine va trăi, chiar dacă va muri. ");
INSERT INTO ronlsb_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Oricine trăiește și crede în Mine nu va muri niciodată. Crezi tu asta?” ");
INSERT INTO ronlsb_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ea i-a zis: “Da, Doamne. Am ajuns să cred că Tu ești Hristosul, Fiul lui Dumnezeu, Cel care vine în lume.” ");
INSERT INTO ronlsb_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","După ce a zis acestea, s-a dus și a chemat pe ascuns pe Maria, sora ei, zicând: “Învățătorul este aici și te cheamă.” ");
INSERT INTO ronlsb_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Când a auzit aceasta, s-a sculat repede și s-a dus la el. ");
INSERT INTO ronlsb_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Isus nu intrase încă în sat, ci era în locul unde L-a întâlnit Marta. ");
INSERT INTO ronlsb_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Iudeii care erau cu ea în casă și o consolau, când au văzut-o pe Maria că s-a sculat repede și a ieșit, au urmărit-o și au zis: “Se duce la mormânt ca să plângă acolo.” ");
INSERT INTO ronlsb_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maria, când a ajuns unde era Isus și L-a văzut, a căzut la picioarele Lui și I-a zis: “Doamne, dacă ai fi fost aici, fratele meu n-ar fi murit.” ");
INSERT INTO ronlsb_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Isus, văzând-o pe ea plângând și pe iudeii care plângeau împreună cu ea, a gemut în duh și s-a tulburat ");
INSERT INTO ronlsb_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","și a zis: “Unde L-ați pus?” I-au spus: “Doamne, vino și vezi”. ");
INSERT INTO ronlsb_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Isus a plâns. ");
INSERT INTO ronlsb_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Iudeii ziceau deci: “Vedeți câtă dragoste avea pentru el!” ");
INSERT INTO ronlsb_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Unii dintre ei spuneau: “Nu putea oare acest om, care a deschis ochii orbului, să împiedice și pe acesta să moară?” ");
INSERT INTO ronlsb_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Isus a venit la mormânt, gemând iarăși în sine. Era o peșteră, și o piatră era așezată împotriva ei. ");
INSERT INTO ronlsb_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Isus a zis: “Scoateți piatra”. Marta, sora celui mort, I-a zis: “Doamne, la ora aceasta este o putoare, căci este mort de patru zile.” ");
INSERT INTO ronlsb_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Isus i-a zis: “Nu ți-am spus Eu că, dacă vei crede, vei vedea slava lui Dumnezeu?” ");
INSERT INTO ronlsb_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Și au îndepărtat piatra din locul unde zăcea mortul. Isus și-a ridicat ochii și a zis: “Tată, îți mulțumesc că m-ai ascultat. ");
INSERT INTO ronlsb_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Știu că întotdeauna mă asculți, dar, din cauza mulțimii care stătea în jur, am spus aceasta, ca să creadă că tu m-ai trimis.” ");
INSERT INTO ronlsb_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","După ce a spus aceasta, a strigat cu glas tare: “Lazăr, ieși afară!” ");
INSERT INTO ronlsb_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Cel mort a ieșit, legat de mâini și de picioare, și avea fața înfășurată cu o pânză. Isus le-a zis: “Eliberați-l și lăsați-l să plece”. ");
INSERT INTO ronlsb_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","De aceea mulți dintre iudeii care au venit la Maria și au văzut ce făcea Isus au crezut în El. ");
INSERT INTO ronlsb_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Dar unii dintre ei s-au dus la farisei și le-au spus ce făcuse Isus. ");
INSERT INTO ronlsb_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Preoții cei mai de seamă și fariseii au adunat deci un consiliu și au zis: “Ce facem? Căci omul acesta face multe semne. ");
INSERT INTO ronlsb_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Dacă îl lăsăm așa, toată lumea va crede în el, iar romanii vor veni și ne vor lua atât locul nostru, cât și națiunea noastră.” ");
INSERT INTO ronlsb_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Dar unul dintre ei, Caiafa, care era mare preot în anul acela, le-a zis: “Voi nu știți nimic, ");
INSERT INTO ronlsb_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","și nici nu vă gândiți că ne este de folos ca un singur om să moară pentru popor și să nu piară tot neamul.” ");
INSERT INTO ronlsb_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Or, el nu a spus acest lucru de la sine, ci, fiind mare preot în acel an, a profețit că Isus va muri pentru națiune, ");
INSERT INTO ronlsb_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","și nu numai pentru națiune, ci și pentru a-i aduna la un loc pe copiii lui Dumnezeu care sunt împrăștiați. ");
INSERT INTO ronlsb_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Astfel, din ziua aceea s-au sfătuit ca să îl omoare. ");
INSERT INTO ronlsb_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","De aceea, Isus nu a mai umblat în mod deschis printre iudei, ci a plecat de acolo în ținutul de lângă pustiu, într-o cetate numită Efraim. Acolo a rămas cu discipolii Săi. ");
INSERT INTO ronlsb_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Și se apropia Paștele iudeilor. Mulți se urcau din țară la Ierusalim înainte de Paște, ca să se purifice. ");
INSERT INTO ronlsb_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Apoi căutau pe Isus și vorbeau între ei, în timp ce stăteau în templu: “Ce credeți voi — că nu vine deloc la sărbătoare?” ");
INSERT INTO ronlsb_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Preoții cei mai de seamă și fariseii porunciseră ca, dacă cineva știa unde se află, să anunțe, ca să îl prindă. ");
INSERT INTO ronlsb_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Cu șase zile înainte de Paști, Isus a venit la Betania, unde era Lazăr, care era mort și pe care l-a înviat din morți. ");
INSERT INTO ronlsb_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Și I-au pregătit acolo o cină. Marta a servit, dar Lazăr era unul dintre cei care stăteau la masă cu el. ");
INSERT INTO ronlsb_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Maria a luat un kilogram de mir de nard curat, foarte prețios, a uns picioarele lui Isus și I-a șters picioarele cu părul ei. Casa s-a umplut de mireasma unguentului. ");
INSERT INTO ronlsb_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Atunci Iuda Iscarioteanul, fiul lui Simon, unul din ucenicii Lui, care avea să-L trădeze, a zis: ");
INSERT INTO ronlsb_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“De ce nu s-a vândut mirul acesta cu trei sute de denari și nu s-a dat săracilor?” ");
INSERT INTO ronlsb_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Și a spus aceasta nu pentru că-i păsa de săraci, ci pentru că era hoț și, având cutia cu bani, obișnuia să fure ce se punea în ea. ");
INSERT INTO ronlsb_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Dar Isus a zis: “Las-o în pace. Ea a păstrat aceasta pentru ziua înmormântării mele. ");
INSERT INTO ronlsb_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Căci voi aveți întotdeauna săraci cu voi, dar pe Mine nu Mă aveți întotdeauna.” ");
INSERT INTO ronlsb_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","O mare mulțime de iudei au aflat că El era acolo și au venit, nu numai de dragul lui Isus, ci ca să vadă și pe Lazăr, pe care El îl înviase din morți. ");
INSERT INTO ronlsb_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Dar preoții cei mai de seamă au uneltit ca să îl omoare și pe Lazăr, ");
INSERT INTO ronlsb_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","pentru că, din cauza lui, mulți dintre iudei au plecat și au crezut în Isus. ");
INSERT INTO ronlsb_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","A doua zi, o mare mulțime a venit la ospăț. Când au auzit că Isus vine la Ierusalim, ");
INSERT INTO ronlsb_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","au luat ramuri de palmier, au ieșit în întâmpinarea lui și au strigat: “Osana! Binecuvântat este cel care vine în numele Domnului, Regele lui Israel!”. ");
INSERT INTO ronlsb_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Isus a găsit un măgăruș tânăr și a șezut pe el. După cum este scris: ");
INSERT INTO ronlsb_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Nu te teme, fiică a Sionului! Iată, Regele tău vine, șezând pe un mânz de măgăriță.” ");
INSERT INTO ronlsb_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","La început, discipolii lui nu au înțeles aceste lucruri, dar când Isus a fost glorificat, atunci și-au adus aminte că aceste lucruri au fost scrise despre el și că ei i-au făcut aceste lucruri. ");
INSERT INTO ronlsb_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Așadar, mulțimea care era cu el când l-a chemat pe Lazăr din mormânt și l-a înviat din morți mărturisea despre aceasta. ");
INSERT INTO ronlsb_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Din această cauză și mulțimea a mers în întâmpinarea lui, pentru că auzise că el făcuse acest semn. ");
INSERT INTO ronlsb_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","De aceea fariseii ziceau între ei: “Vedeți cum nu realizați nimic. Iată că lumea a mers după el”. ");
INSERT INTO ronlsb_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Printre cei ce se suiseră să se închine la sărbătoare erau niște greci. ");
INSERT INTO ronlsb_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Aceștia au venit la Filip, care era din Betsaida Galileii, și l-au întrebat, zicând: “Domnule, vrem să-L vedem pe Isus.” ");
INSERT INTO ronlsb_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filip a venit și i-a spus lui Andrei și, la rândul său, Andrei a venit cu Filip și i-au spus lui Isus. ");
INSERT INTO ronlsb_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Isus le-a răspuns: “A venit vremea ca Fiul Omului să fie proslăvit. ");
INSERT INTO ronlsb_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Adevărat vă spun că, dacă un bob de grâu nu cade în pământ și nu moare, el rămâne singur. Dar, dacă moare, face mult rod. ");
INSERT INTO ronlsb_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Cine își iubește viața o va pierde. Cel care își urăște viața în lumea aceasta o va păstra pentru viața veșnică. ");
INSERT INTO ronlsb_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Dacă cineva îmi slujește, să mă urmeze. Unde sunt eu, acolo va fi și slujitorul meu. Dacă cineva îmi slujește, Tatăl îl va cinsti. ");
INSERT INTO ronlsb_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Acum sufletul meu este tulburat. Ce să spun? 'Tată, salvează-mă din acest timp?'. Dar am venit în acest timp pentru această cauză. ");
INSERT INTO ronlsb_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tată, slăvește numele Tău!” Atunci un glas a ieșit din cer și a zis: “Am proslăvit-o și o voi proslăvi din nou”. ");
INSERT INTO ronlsb_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","De aceea mulțimea care stătea de față și auzea, zicea că a tunat. Alții spuneau: “Un înger i-a vorbit”. ");
INSERT INTO ronlsb_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Isus a răspuns: “Glasul acesta n-a venit pentru Mine, ci pentru voi. ");
INSERT INTO ronlsb_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Acum este judecata lumii acesteia. Acum prințul acestei lumi va fi alungat. ");
INSERT INTO ronlsb_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Iar Eu, dacă voi fi ridicat de pe pământ, voi atrage la Mine toate popoarele.” ");
INSERT INTO ronlsb_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Dar El a spus aceasta, însemnând prin ce fel de moarte va muri. ");
INSERT INTO ronlsb_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Și mulțimea i-a răspuns: “Am auzit din Lege că Hristosul rămâne pentru totdeauna. Cum spuneți voi: 'Fiul Omului trebuie să fie înălțat'? Cine este acest Fiu al Omului?” ");
INSERT INTO ronlsb_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Isus le-a zis: “Încă puțină vreme lumina este cu voi. Umblați cât timp aveți lumina, ca să nu vă cuprindă întunericul. Cel care umblă în întuneric nu știe încotro se îndreaptă. ");
INSERT INTO ronlsb_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Cât timp aveți lumina, credeți în lumină, ca să deveniți copii ai luminii.” Isus a spus aceste lucruri, apoi a plecat și s-a ascuns de ei. ");
INSERT INTO ronlsb_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Dar, deși făcuse atâtea semne înaintea lor, ei nu credeau în el, ");
INSERT INTO ronlsb_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","pentru ca să se împlinească cuvântul proorocului Isaia, pe care îl rostise: “Doamne, cine a crezut raportul nostru? Cui s-a arătat brațul Domnului?” ");
INSERT INTO ronlsb_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","De aceea nu puteau să creadă, pentru că Isaia a spus din nou: ");
INSERT INTO ronlsb_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“El le-a orbit ochii și le-a împietrit inima, ca nu cumva să vadă cu ochii lor, și să perceapă cu inima lor, și s-ar întoarce, și eu îi voi vindeca.” ");
INSERT INTO ronlsb_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaia a spus aceste lucruri când a văzut slava Lui și a vorbit despre El. ");
INSERT INTO ronlsb_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Cu toate acestea, chiar și mulți dintre dregători au crezut în El, dar, din pricina fariseilor, n-au mărturisit-o, ca să nu fie scoși din sinagogă, ");
INSERT INTO ronlsb_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","pentru că ei iubeau mai mult lauda oamenilor decât lauda lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Isus a strigat și a zis: “Cine crede în Mine, nu crede în Mine, ci în Cel ce M-a trimis pe Mine. ");
INSERT INTO ronlsb_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Cine Mă vede pe Mine vede pe Cel ce M-a trimis pe Mine. ");
INSERT INTO ronlsb_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Eu am venit ca o lumină în lume, pentru ca oricine crede în Mine să nu rămână în întuneric. ");
INSERT INTO ronlsb_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Dacă cineva ascultă cele spuse de mine și nu crede, eu nu-l judec. Căci nu am venit să judec lumea, ci să salvez lumea. ");
INSERT INTO ronlsb_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Cine mă respinge pe mine și nu primește spusele mele, are pe cineva care îl judecă. Cuvântul pe care l-am rostit îl va judeca în ziua de apoi. ");
INSERT INTO ronlsb_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Căci nu am vorbit de la mine însumi, ci Tatăl care m-a trimis mi-a dat o poruncă, ce să spun și ce să vorbesc. ");
INSERT INTO ronlsb_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Știu că porunca Lui este viața veșnică. Așadar, lucrurile pe care le spun, așa cum mi-a spus Tatăl, așa vorbesc și eu.” ");
INSERT INTO ronlsb_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Înainte de sărbătoarea Paștelui, Isus, știind că a venit vremea să plece din lumea aceasta la Tatăl, a iubit pe ai Săi care erau în lume și i-a iubit până la sfârșit. ");
INSERT INTO ronlsb_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","În timpul cinei, când diavolul pusese deja în inima lui Iuda Iscarioteanul, fiul lui Simon, ca să-l trădeze, ");
INSERT INTO ronlsb_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Isus, știind că Tatăl îi dăduse toate lucrurile în mâinile sale și că el a venit de la Dumnezeu și că se duce la Dumnezeu, ");
INSERT INTO ronlsb_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","s-a ridicat de la cină și și-a dat la o parte hainele de pe el. A luat un prosop și și-a înfășurat un prosop în jurul taliei. ");
INSERT INTO ronlsb_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Apoi a turnat apă în lighean și a început să spele picioarele discipolilor și să le șteargă cu prosopul care era înfășurat în jurul său. ");
INSERT INTO ronlsb_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Apoi a venit la Simon Petru. Acesta i-a zis: “Doamne, îmi speli tu mie picioarele?”. ");
INSERT INTO ronlsb_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Isus i-a răspuns: “Nu știi ce fac acum, dar vei înțelege mai târziu.” ");
INSERT INTO ronlsb_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petru i-a zis: “Nu-mi vei spăla niciodată picioarele!” Isus i-a răspuns: “Dacă nu te spăl, nu ai parte cu Mine”. ");
INSERT INTO ronlsb_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Petru I-a zis: “Doamne, nu numai picioarele mele, ci și mâinile și capul meu!” ");
INSERT INTO ronlsb_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Isus i-a zis: “Cineva care s-a scăldat nu are nevoie decât să-și spele picioarele, ci este cu totul curat. Voi sunteți curați, dar nu toți”. ");
INSERT INTO ronlsb_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Căci îl cunoștea pe cel care avea să-l trădeze; de aceea a spus: “Nu sunteți toți curați.” ");
INSERT INTO ronlsb_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","După ce le-a spălat picioarele, și-a pus la loc haina de pe el și a șezut din nou jos, le-a zis: “Știți ce v-am făcut? ");
INSERT INTO ronlsb_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Voi Mă numiți: “Învățătorule” și “Doamne”. Spuneți corect, căci așa sunt. ");
INSERT INTO ronlsb_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Dacă deci Eu, Domnul și Învățătorul, v-am spălat picioarele, și voi trebuie să vă spălați picioarele unii altora. ");
INSERT INTO ronlsb_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Căci v-am dat o pildă, ca și voi să faceți cum v-am făcut eu. ");
INSERT INTO ronlsb_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Adevărat vă spun că nu este un slujitor mai mare decât stăpânul său și nici cel trimis nu este mai mare decât cel care l-a trimis. ");
INSERT INTO ronlsb_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Dacă știți aceste lucruri, ferice de voi dacă le veți face. ");
INSERT INTO ronlsb_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Nu vorbesc cu privire la voi toți. Știu pe cine am ales, dar pentru ca să se împlinească Scriptura: “Cel care mănâncă pâine cu mine și-a ridicat călcâiul împotriva mea”. ");
INSERT INTO ronlsb_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","De acum înainte vă spun înainte de a se întâmpla, pentru ca, atunci când se va întâmpla, să credeți că Eu sunt. ");
INSERT INTO ronlsb_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Cu siguranță vă spun: cine primește pe oricine îl trimit Eu, pe Mine Mă primește; și cine Mă primește pe Mine, Îl primește pe Cel care M-a trimis.” ");
INSERT INTO ronlsb_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","După ce a zis acestea, Isus s-a tulburat în duhul său și a zis: “Adevărat vă spun că unul din voi Mă va trăda.” ");
INSERT INTO ronlsb_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ucenicii se uitau unii la alții, și nu știau despre cine vorbea. ");
INSERT INTO ronlsb_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Unul dintre ucenicii Săi, pe care Isus îl iubea, era la masă și se sprijinea de pieptul lui Isus. ");
INSERT INTO ronlsb_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon Petru i-a făcut semn și i-a zis: “Spune-ne cine este acela despre care vorbește.” ");
INSERT INTO ronlsb_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","El, sprijinindu-se pe pieptul lui Isus, L-a întrebat: “Doamne, cine este?” ");
INSERT INTO ronlsb_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Isus a răspuns: “Acela este cel căruia îi voi da această bucată de pâine, după ce o voi înmuia.” După ce a înmuiat bucata de pâine, a dat-o lui Iuda, fiul lui Simon Iscarioteanul. ");
INSERT INTO ronlsb_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","După bucățica de pâine, atunci Satana a intrat în el. Atunci Isus i-a zis: “Ce faci, fă repede!”. ");
INSERT INTO ronlsb_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nimeni de la masă nu știa de ce îi spunea așa. ");
INSERT INTO ronlsb_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Fiindcă unii credeau, pentru că Iuda avea cutia cu bani, că Isus i-a spus: “Cumpără ce ne trebuie pentru sărbătoare”, sau că trebuie să dea ceva săracilor. ");
INSERT INTO ronlsb_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","De aceea, după ce a primit bucățica aceea, a ieșit îndată. Era noapte. ");
INSERT INTO ronlsb_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","După ce a ieșit, Isus a zis: “Acum Fiul Omului a fost proslăvit și Dumnezeu a fost proslăvit în El. ");
INSERT INTO ronlsb_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Dacă Dumnezeu a fost proslăvit în El, Dumnezeu Îl va proslăvi și în El însuși, și Îl va proslăvi îndată. ");
INSERT INTO ronlsb_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Copilașilor, voi mai fi cu voi încă puțin timp. Mă veți căuta și, după cum am spus iudeilor: “Unde Mă duc Eu, voi nu puteți veni”, tot așa vă spun și acum. ");
INSERT INTO ronlsb_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Vă dau o poruncă nouă: să vă iubiți unii pe alții. Așa cum v-am iubit Eu, așa să vă iubiți și voi unii pe alții. ");
INSERT INTO ronlsb_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Prin aceasta va cunoaște toată lumea că sunteți discipolii mei, dacă vă veți iubi unii pe alții.” ");
INSERT INTO ronlsb_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Petru I-a zis: “Doamne, unde Te duci?” Isus i-a răspuns: “Unde Mă duc Eu, nu poți să mă urmezi acum, dar mă vei urma după aceea.” ");
INSERT INTO ronlsb_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petru I-a zis: “Doamne, de ce nu pot să Te urmez acum? Îmi voi da viața pentru Tine”. ");
INSERT INTO ronlsb_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Isus i-a răspuns: “Vrei să-ți dai viața pentru Mine? Adevărat îți spun că nu va cânta cocoșul până când nu te vei lepăda de mine de trei ori. ");
INSERT INTO ronlsb_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Să nu-ți tulburi inima. Credeți în Dumnezeu. Credeți și în mine. ");
INSERT INTO ronlsb_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","În casa Tatălui meu sunt multe case. Dacă nu ar fi fost așa, v-aș fi spus. Am să vă pregătesc un loc. ");
INSERT INTO ronlsb_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Dacă Mă duc și vă pregătesc un loc, Mă voi întoarce și vă voi primi la Mine, pentru ca acolo unde sunt Eu, să fiți și voi. ");
INSERT INTO ronlsb_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Voi știți unde mă duc și știți calea.” ");
INSERT INTO ronlsb_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Toma I-a zis: “Doamne, noi nu știm unde Te duci. Cum am putea cunoaște calea?” ");
INSERT INTO ronlsb_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Isus i-a zis: “Eu sunt calea, adevărul și viața. Nimeni nu vine la Tatăl, decât prin mine. ");
INSERT INTO ronlsb_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Dacă M-ai fi cunoscut pe Mine, L-ai fi cunoscut și pe Tatăl Meu. De acum înainte, tu îl cunoști și l-ai văzut.” ");
INSERT INTO ronlsb_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filip i-a zis: “Doamne, arată-ne pe Tatăl și ne va fi de ajuns.” ");
INSERT INTO ronlsb_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Isus i-a zis: “De atâta vreme sunt cu tine și nu Mă cunoști, Filip? Cine M-a văzut pe Mine, L-a văzut pe Tatăl. Cum spui: “Arată-ne pe Tatăl?” ");
INSERT INTO ronlsb_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nu crezi că Eu sunt în Tatăl și Tatăl în mine? Cuvintele pe care vi le spun nu le spun de la mine însumi, ci Tatăl, care trăiește în mine, face lucrările Lui. ");
INSERT INTO ronlsb_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Credeți-Mă că Eu sunt în Tatăl și Tatăl în Mine, sau credeți-Mă din cauza faptelor înseși. ");
INSERT INTO ronlsb_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Adevărat vă spun că, cel ce crede în Mine, va face și el lucrările pe care le fac Eu; și va face lucrări mai mari decât acestea, pentru că Eu Mă duc la Tatăl Meu. ");
INSERT INTO ronlsb_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Orice veți cere în numele Meu, voi face, pentru ca Tatăl să fie proslăvit în Fiul. ");
INSERT INTO ronlsb_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Dacă veți cere ceva în numele Meu, Eu voi face. ");
INSERT INTO ronlsb_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Dacă Mă iubiți, păziți poruncile Mele. ");
INSERT INTO ronlsb_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Eu mă voi ruga Tatălui și el vă va da un alt Sfetnic, ca să fie cu voi în veci: ");
INSERT INTO ronlsb_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Duhul adevărului, pe care lumea nu-l poate primi, pentru că nu-l vede și nu-l cunoaște. Voi îl cunoașteți, pentru că el trăiește cu voi și va fi în voi. ");
INSERT INTO ronlsb_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nu vă voi lăsa orfani. Eu voi veni la voi. ");
INSERT INTO ronlsb_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Încă puțină vreme și lumea nu mă va mai vedea, dar voi mă veți vedea. Pentru că Eu trăiesc, veți trăi și voi. ");
INSERT INTO ronlsb_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","În ziua aceea, veți cunoaște că Eu sunt în Tatăl Meu, și voi în Mine, și Eu în voi. ");
INSERT INTO ronlsb_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Cine are poruncile Mele și le păzește, acela este unul care Mă iubește. Cel care mă iubește pe mine va fi iubit de Tatăl meu, iar eu îl voi iubi și mă voi arăta lui.” ");
INSERT INTO ronlsb_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Iuda (nu Iscarioteanul) I-a zis: “Doamne, ce s-a întâmplat de Te-ai arătat nouă și nu lumii?” ");
INSERT INTO ronlsb_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Isus i-a răspuns: “Dacă Mă iubește cineva, va păzi cuvântul Meu. Tatăl Meu îl va iubi și noi vom veni la el și ne vom face casa la el. ");
INSERT INTO ronlsb_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Cine nu mă iubește pe mine nu păzește cuvintele mele. Cuvântul pe care îl auziți nu este al meu, ci al Tatălui care m-a trimis. ");
INSERT INTO ronlsb_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“V-am spus aceste lucruri în timp ce trăiam cu voi. ");
INSERT INTO ronlsb_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Dar Consilierul, Duhul Sfânt, pe care Tatăl îl va trimite în numele Meu, vă va învăța toate lucrurile și vă va aminti tot ce v-am spus. ");
INSERT INTO ronlsb_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Vă las pacea. Pacea Mea v-o dau vouă; nu cum dă lumea, vă dau Eu vouă. Să nu vă tulburați inima și să nu vă fie teamă. ");
INSERT INTO ronlsb_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ați auzit cum v-am spus: “Mă duc și mă voi întoarce la voi”. Dacă m-ați fi iubit, v-ați fi bucurat, pentru că am spus: 'Mă duc la Tatăl meu'; căci Tatăl este mai mare decât mine. ");
INSERT INTO ronlsb_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Acum v-am spus înainte de a se întâmpla, pentru ca, atunci când se va întâmpla, să credeți. ");
INSERT INTO ronlsb_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nu voi mai vorbi mult cu voi, pentru că vine prințul lumii și el nu are nimic în mine. ");
INSERT INTO ronlsb_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ci pentru ca lumea să știe că Eu iubesc pe Tatăl și că așa cum Mi-a poruncit Tatăl, așa fac și Eu. Ridicați-vă, să mergem de aici. ");
INSERT INTO ronlsb_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Eu sunt vița cea adevărată și Tatăl Meu este viticultorul. ");
INSERT INTO ronlsb_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Orice ramură din mine care nu face rod, El o taie. Orice ramură care dă rod, el o curăță, ca să dea mai mult rod. ");
INSERT INTO ronlsb_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Voi sunteți deja tăiați curat, din cauza cuvântului pe care vi l-am spus. ");
INSERT INTO ronlsb_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Rămâneți în mine și eu în voi. Așa cum ramura nu poate da rod de una singură dacă nu rămâne în viță, tot așa nici voi nu puteți, dacă nu rămâneți în mine. ");
INSERT INTO ronlsb_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Eu sunt vița de vie. Voi sunteți ramurile. Cel care rămâne în mine și eu în el face multă roadă, pentru că în afară de mine nu puteți face nimic. ");
INSERT INTO ronlsb_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Dacă un om nu rămâne în mine, este aruncat ca o ramură și se usucă; le adună, le aruncă în foc și sunt arse. ");
INSERT INTO ronlsb_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Dacă rămâneți în mine și cuvintele mele rămân în voi, veți cere tot ce doriți și vi se va face. ");
INSERT INTO ronlsb_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Întru aceasta este slăvit Tatăl Meu, că voi faceți multă roadă, și astfel veți fi ucenicii Mei. ");
INSERT INTO ronlsb_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Așa cum M-a iubit pe Mine Tatăl, așa v-am iubit și Eu pe voi. Rămâneți în dragostea mea. ");
INSERT INTO ronlsb_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Dacă veți păzi poruncile Mele, veți rămâne în dragostea Mea, după cum și Eu am păzit poruncile Tatălui Meu și rămân în dragostea Lui. ");
INSERT INTO ronlsb_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","V-am spus aceste lucruri pentru ca bucuria mea să rămână în voi și bucuria voastră să fie deplină. ");
INSERT INTO ronlsb_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Aceasta este porunca Mea: Să vă iubiți unii pe alții, cum v-am iubit Eu pe voi. ");
INSERT INTO ronlsb_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nimeni nu are o dragoste mai mare decât aceasta: să-și dea cineva viața pentru prietenii săi. ");
INSERT INTO ronlsb_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Voi sunteți prietenii Mei, dacă faceți tot ce vă poruncesc eu. ");
INSERT INTO ronlsb_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nu vă mai numesc robi, căci robul nu știe ce face stăpânul său. Ci v-am numit prieteni, pentru că tot ce am auzit de la Tatăl meu v-am făcut cunoscut. ");
INSERT INTO ronlsb_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nu voi m-ați ales pe mine, ci eu v-am ales pe voi și v-am rânduit ca să mergeți și să aduceți roade, iar roadele voastre să rămână, pentru ca tot ce veți cere de la Tatăl în numele meu, să vi se dea. ");
INSERT INTO ronlsb_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Vă poruncesc aceste lucruri, ca să vă iubiți unii pe alții. ");
INSERT INTO ronlsb_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Dacă lumea vă urăște, să știți că și pe Mine M-a urât înainte de a vă urî pe voi. ");
INSERT INTO ronlsb_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Dacă ați fi din lume, lumea și-ar iubi pe ai ei. Dar pentru că nu sunteți din lume, întrucât v-am ales din lume, de aceea vă urăște lumea. ");
INSERT INTO ronlsb_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Aduceți-vă aminte de cuvântul pe care vi l-am spus: 'Un rob nu este mai mare decât stăpânul său'. Dacă m-au persecutat pe mine, vă vor persecuta și pe voi. Dacă ei au păzit cuvântul meu, îl vor păzi și pe al vostru. ");
INSERT INTO ronlsb_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Dar vă vor face toate acestea din cauza numelui meu, pentru că nu-l cunosc pe cel care m-a trimis. ");
INSERT INTO ronlsb_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Dacă nu aș fi venit și nu le-aș fi vorbit, nu ar fi avut păcat; dar acum nu au nicio scuză pentru păcatul lor. ");
INSERT INTO ronlsb_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Cine mă urăște pe mine, îl urăște și pe Tatăl meu. ");
INSERT INTO ronlsb_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Dacă n-aș fi făcut între ei faptele pe care nimeni altcineva nu le-a făcut, ei n-ar fi avut păcat. Dar acum au văzut și m-au urât și pe mine și pe Tatăl meu. ");
INSERT INTO ronlsb_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Dar aceasta s-a întâmplat pentru ca să se împlinească cuvântul care era scris în legea lor: “M-au urât fără motiv”. ");
INSERT INTO ronlsb_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Când va veni Consilierul, pe care vi-L voi trimite de la Tatăl, Duhul adevărului, care purcede de la Tatăl, El va mărturisi despre Mine. ");
INSERT INTO ronlsb_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Și voiveți mărturisi, pentru că ați fost cu mine de la început. ");
INSERT INTO ronlsb_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“V-am spus aceste lucruri ca să nu vă poticniți. ");
INSERT INTO ronlsb_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ei vă vor da afară din sinagogi. Da, vine vremea când oricine vă va ucide va crede că îi oferă un serviciu lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ei vor face aceste lucruri pentru că nu l-au cunoscut pe Tatăl și nici pe mine. ");
INSERT INTO ronlsb_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Dar v-am spus aceste lucruri pentru ca, atunci când va veni vremea, să vă amintiți că v-am vorbit despre ele. Nu v-am spus aceste lucruri de la început, pentru că eram cu voi. ");
INSERT INTO ronlsb_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Dar acum mă duc la cel care m-a trimis și niciunul dintre voi nu mă întreabă: “Unde te duci?” ");
INSERT INTO ronlsb_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ci, pentru că v-am spus aceste lucruri, durerea v-a umplut inima. ");
INSERT INTO ronlsb_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Cu toate acestea, vă spun adevărul: este spre folosul vostru să plec, căci dacă nu plec, Consilierul nu va veni la voi. Dar dacă plec, vi-l voi trimite. ");
INSERT INTO ronlsb_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Când va veni, el va convinge lumea despre păcat, despre dreptate și despre judecată; ");
INSERT INTO ronlsb_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","despre păcat, pentru că nu cred în mine; ");
INSERT INTO ronlsb_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","despre dreptate, pentru că mă duc la Tatăl meu și nu mă veți mai vedea; ");
INSERT INTO ronlsb_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","despre judecată, pentru că prințul acestei lumi a fost judecat. ");
INSERT INTO ronlsb_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Mai am încă multe lucruri să-ți spun, dar acum nu le poți suferi. ");
INSERT INTO ronlsb_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Dar când va veni El, Duhul adevărului, vă va călăuzi în tot adevărul, căci nu va vorbi de la sine, ci va spune tot ce va auzi. El vă va vesti lucrurile care vor veni. ");
INSERT INTO ronlsb_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","El mă va proslăvi, pentru că va lua din ceea ce este al meu și vă va vesti. ");
INSERT INTO ronlsb_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Toate lucrurile pe care le are Tatăl sunt ale mele; de aceea am spus că el ia din ale mele și vi le va vesti vouă. ");
INSERT INTO ronlsb_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Încă puțină vreme și nu Mă veți mai vedea. Din nou puțină vreme, și Mă veți vedea.” ");
INSERT INTO ronlsb_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","De aceea unii dintre ucenicii Lui ziceau unii către alții: “Ce este aceasta, că ne spune: “Peste puțină vreme nu Mă veți vedea; și iarăși peste puțină vreme Mă veți vedea” și: “Pentru că Mă duc la Tatăl”?” ");
INSERT INTO ronlsb_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ei au spus deci: “Ce este aceasta pe care o spune: “Puțin timp”? Nu știm ce vrea să spună”. ");
INSERT INTO ronlsb_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Isus a înțeles că voiau să-L întrebe și le-a zis: “Vă întrebați între voi despre aceasta, că am zis: “Peste puțină vreme nu Mă veți vedea și iarăși peste puțină vreme Mă veți vedea?” ");
INSERT INTO ronlsb_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Adevărat vă spun că voi veți plânge și vă veți tângui, iar lumea se va bucura. Voi veți fi întristați, dar întristarea voastră se va transforma în bucurie. ");
INSERT INTO ronlsb_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Femeia, când naște, are tristețe, pentru că i-a sosit vremea. Dar, după ce a născut, nu-și mai amintește de chin, pentru bucuria că s-a născut o ființă umană în lume. ");
INSERT INTO ronlsb_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","De aceea, acum aveți întristare, dar vă voi revedea, și inima voastră se va bucura, și nimeni nu vă va lua bucuria. ");
INSERT INTO ronlsb_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","În ziua aceea nu-mi veți pune întrebări. Adevărat vă spun că orice veți cere de la Tatăl în numele Meu, El vă va da. ");
INSERT INTO ronlsb_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Până acum, nu ați cerut nimic în numele Meu. Cereți și veți primi, pentru ca bucuria voastră să fie deplină. ");
INSERT INTO ronlsb_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“V-am spus aceste lucruri prin figuri de stil. Dar vine vremea când nu vă voi mai vorbi cu figuri de stil, ci vă voi vorbi în mod clar despre Tatăl. ");
INSERT INTO ronlsb_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","În ziua aceea, veți cere în numele meu; și nu vă spun că eu mă voi ruga Tatălui pentru voi, ");
INSERT INTO ronlsb_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","pentru că însuși Tatăl vă iubește, pentru că voi m-ați iubit pe mine și ați crezut că am venit de la Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Eu am venit de la Tatăl și am venit în lume. Din nou, las lumea și mă duc la Tatăl.” ");
INSERT INTO ronlsb_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ucenicii Lui I-au zis: “Iată că acum vorbești limpede și fără figuri de stil. ");
INSERT INTO ronlsb_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Acum știm că Tu știi toate lucrurile și nu este nevoie ca cineva să Te întrebe. Prin aceasta credem că ai venit de la Dumnezeu.” ");
INSERT INTO ronlsb_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Isus le-a răspuns: “Credeți voi acum? ");
INSERT INTO ronlsb_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Iată că vine vremea, și a venit, că veți fi împrăștiați, fiecare la locul lui, și Mă veți lăsa singur. Totuși, Eu nu sunt singur, pentru că Tatăl este cu Mine. ");
INSERT INTO ronlsb_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","V-am spus aceste lucruri pentru ca în Mine să aveți pace. În lume aveți necazuri; dar înveseliți-vă! Eu am biruit lumea”. ");
INSERT INTO ronlsb_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Isus a spus aceste lucruri, apoi, ridicându-Și ochii spre cer, a zis: “Tată, a venit vremea. Slăvește-l pe Fiul tău, ca și Fiul tău să te slăvească pe tine; ");
INSERT INTO ronlsb_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","așa cum i-ai dat autoritate peste toată făptura, așa va da viață veșnică tuturor celor pe care i-ai dat-o. ");
INSERT INTO ronlsb_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Aceasta este viața veșnică: să te cunoască pe tine, singurul Dumnezeu adevărat, și pe cel pe care l-ai trimis, Isus Hristos. ");
INSERT INTO ronlsb_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Eu te-am slăvit pe pământ. Am împlinit lucrarea pe care mi-ai dat-o să o fac. ");
INSERT INTO ronlsb_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Acum, Tată, proslăvește-mă pe mine însumi cu gloria pe care o aveam cu tine înainte de a exista lumea. ");
INSERT INTO ronlsb_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Eu am arătat Numele Tău poporului pe care mi l-ai dat din lume. Ei erau ai tăi și mi i-ai dat. Ei au respectat cuvântul tău. ");
INSERT INTO ronlsb_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Acum au cunoscut că tot ce mi-ai dat vine de la Tine, ");
INSERT INTO ronlsb_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","pentru că le-am dat cuvintele pe care mi le-ai dat; și ei le-au primit și au știut cu siguranță că vin de la Tine. Ei au crezut că tu m-ai trimis. ");
INSERT INTO ronlsb_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Eu mă rog pentru ei. Nu mă rog pentru lume, ci pentru cei pe care mi i-ai dat, pentru că ei sunt ai tăi. ");
INSERT INTO ronlsb_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Toate lucrurile care sunt ale mele sunt ale tale, iar ale tale sunt ale mele și eu sunt glorificat în ele. ");
INSERT INTO ronlsb_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Eu nu mai sunt în lume, dar aceștia sunt în lume, iar eu vin la voi. Tată sfânt, păzește-i prin numele tău, pe care mi l-ai dat mie, pentru ca ei să fie una, așa cum suntem și noi. ");
INSERT INTO ronlsb_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Cât timp am fost cu ei în lume, i-am păzit în numele Tău. Am păzit pe cei pe care mi i-ai dat. Nici unul dintre ei nu este pierdut, cu excepția fiului pierzării, pentru ca Scriptura să se împlinească. ");
INSERT INTO ronlsb_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Dar acum am venit la voi și spun aceste lucruri în lume, pentru ca ei să aibă bucuria mea deplină în ei înșiși. ");
INSERT INTO ronlsb_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Le-am dat cuvântul Tău. Lumea i-a urât, pentru că nu sunt din lume, după cum nici Eu nu sunt din lume. ");
INSERT INTO ronlsb_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nu te rog să îi iei din lume, ci să îi păzești de cel rău. ");
INSERT INTO ronlsb_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ei nu sunt din lume, după cum nici Eu nu sunt din lume. ");
INSERT INTO ronlsb_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Sfințește-i în adevărul Tău. Cuvântul Tău este adevărul. ");
INSERT INTO ronlsb_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","După cum m-ai trimis pe mine în lume, tot așa i-am trimis și eu pe ei în lume. ");
INSERT INTO ronlsb_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","De dragul lor mă sfințesc pe mine însumi, pentru ca și ei înșiși să fie sfințiți în adevăr. ");
INSERT INTO ronlsb_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Nu numai pentru aceștia mă rog, ci și pentru cei ce vor crede în Mine prin cuvântul lor, ");
INSERT INTO ronlsb_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ca toți să fie una, după cum Tu, Tată, ești în Mine și Eu în Tine, ca și ei să fie una în noi, pentru ca lumea să creadă că Tu M-ai trimis. ");
INSERT INTO ronlsb_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Slava pe care Mi-ai dat-o Tu, Eu le-am dat-o lor, pentru ca ei să fie una, așa cum și noi suntem una, ");
INSERT INTO ronlsb_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Eu în ei și Tu în Mine, ca ei să fie desăvârșiți într-o singură ființă, pentru ca lumea să știe că Tu M-ai trimis și că i-ai iubit, așa cum M-ai iubit pe Mine. ");
INSERT INTO ronlsb_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tată, doresc ca și aceia pe care mi i-ai dat să fie cu mine acolo unde sunt eu, ca să vadă slava pe care mi-ai dat-o, pentru că m-ai iubit înainte de întemeierea lumii. ");
INSERT INTO ronlsb_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tată dreptcredincios, lumea nu Te-a cunoscut, dar Eu Te-am cunoscut pe Tine; și aceștia au cunoscut că Tu M-ai trimis. ");
INSERT INTO ronlsb_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Eule-am făcut cunoscut numele Tău și îl voi face cunoscut, pentru ca dragostea cu care M-ai iubit să fie în ei și Eu în ei.” ");
INSERT INTO ronlsb_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","După ce a rostit aceste cuvinte, Isus a ieșit cu ucenicii Săi peste pârâul Chedron, unde era o grădină, în care a intrat împreună cu ucenicii Săi. ");
INSERT INTO ronlsb_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Iuda, cel care l-a trădat, cunoștea și el locul, pentru că Isus se întâlnea adesea acolo cu ucenicii săi. ");
INSERT INTO ronlsb_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Atunci Iuda, după ce a luat un detașament de soldați și de ofițeri de la preoții cei mai de seamă și de la farisei, a venit acolo cu felinare, torțe și arme. ");
INSERT INTO ronlsb_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Isus, deci, știind toate lucrurile care i se întâmplau, a ieșit și le-a zis: “Pe cine căutați?” ");
INSERT INTO ronlsb_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ei I-au răspuns: “Isus din Nazaret.” Isus le-a spus: “Eu sunt.” Și Iuda, care l-a trădat, stătea cu ei. ");
INSERT INTO ronlsb_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","De aceea, când le-a zis: “Eu sunt Acela”, ei s-au dat înapoi și au căzut la pământ. ");
INSERT INTO ronlsb_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","De aceea i-a întrebat din nou: “Pe cine căutați?” Ei au spus: “Isus din Nazaret”. ");
INSERT INTO ronlsb_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Isus a răspuns: “V-am spus că Eu sunt. De aceea, dacă Mă căutați pe Mine, lăsați-i pe aceștia să meargă pe drumul lor” ");
INSERT INTO ronlsb_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ca să se împlinească cuvântul pe care l-a rostit: “Dintre cei pe care Mi i-ai dat, nu am pierdut pe niciunul”. ");
INSERT INTO ronlsb_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simon Petru, având o sabie, a scos-o, a lovit pe robul marelui preot și i-a tăiat urechea dreaptă. Numele slujitorului era Malchus. ");
INSERT INTO ronlsb_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Isus i-a zis lui Petru: “Pune sabia în teaca ei. Paharul pe care Mi l-a dat Tatăl, nu-l voi bea oare cu siguranță?”. ");
INSERT INTO ronlsb_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Atunci detașamentul, comandantul și ofițerii iudeilor au prins pe Isus și L-au legat, ");
INSERT INTO ronlsb_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","și L-au dus mai întâi la Ana, care era socrul lui Caiafa, care era mare preot în anul acela. ");
INSERT INTO ronlsb_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Caiafa fusese cel care i-a sfătuit pe iudei că este bine ca un om să piară pentru popor. ");
INSERT INTO ronlsb_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Petru și un alt ucenic au urmat pe Isus. Acel ucenic era cunoscut de marele preot și a intrat cu Isus în curtea marelui preot; ");
INSERT INTO ronlsb_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","dar Petru stătea afară la ușă. Deci celălalt ucenic, care era cunoscut de marele preot, a ieșit și a vorbit cu cea care păzea ușa și l-a adus pe Petru înăuntru. ");
INSERT INTO ronlsb_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Atunci servitoarea care păzea ușa i-a zis lui Petru: “Și tu ești unul dintre discipolii acestui om?” El a spus: “Nu sunt.” ");
INSERT INTO ronlsb_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Și stăteau acolo slujitorii și ofițerii și făcuseră un foc de cărbuni, pentru că era frig. Ei se încălzeau. Petru era cu ei, stând în picioare și încălzindu-se. ");
INSERT INTO ronlsb_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Marele preot a întrebat pe Isus despre ucenicii Săi și despre învățătura Lui. ");
INSERT INTO ronlsb_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Isus i-a răspuns: “Eu am vorbit deschis lumii. Întotdeauna am învățat în sinagogi și în templu, unde se întâlnesc mereu evreii. Nu am spus nimic în secret. ");
INSERT INTO ronlsb_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","De ce mă întrebi pe mine? Întreabă-i pe cei care m-au ascultat ce le-am spus. Iată, ei știu ce am spus.” ");
INSERT INTO ronlsb_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","După ce a zis acestea, unul din ofițerii care stăteau acolo a lovit pe Isus cu mâna, zicând: “Așa răspunzi Tu marelui preot?” ");
INSERT INTO ronlsb_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Isus i-a răspuns: “Dacă am vorbit de rău, mărturisește răul; dar dacă am spus bine, de ce mă bați?” ");
INSERT INTO ronlsb_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Și Ana l-a trimis legat la Caiafa, marele preot. ");
INSERT INTO ronlsb_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simon Petru stătea în picioare și se încălzea. Și ei i-au zis: “Nu cumva ești și tu unul dintre ucenicii Lui?” El a negat și a spus: “Nu sunt”. ");
INSERT INTO ronlsb_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Unul din slujitorii marelui preot, rudă cu cel căruia Petru îi tăiase urechea, a zis: “Nu te-am văzut în grădină cu el?” ");
INSERT INTO ronlsb_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Petru a negat din nou, și îndată a cântat cocoșul. ");
INSERT INTO ronlsb_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Și au dus pe Isus de la Caiafa în pretoriu. Era devreme, și ei înșiși nu au intrat în pretoriu, ca să nu se spurce, ci să mănânce Paștele. ");
INSERT INTO ronlsb_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pilat a ieșit deci la ei și i-a întrebat: “Ce acuzație aduceți împotriva omului acesta?” ");
INSERT INTO ronlsb_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ei i-au răspuns: “Dacă n-ar fi fost omul acesta un răufăcător, nu ți l-am fi dat ție.” ");
INSERT INTO ronlsb_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Atunci Pilat le-a zis: “Luați-l voi înșivă și judecați-l după legea voastră.” De aceea Iudeii I-au zis: “Nu ne este îngăduit să omorâm pe nimeni”, ");
INSERT INTO ronlsb_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","pentru ca să se împlinească cuvântul lui Isus, pe care-l spusese și care însemna prin ce fel de moarte avea să moară. ");
INSERT INTO ronlsb_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilat a intrat din nou în pretoriu, a chemat pe Isus și I-a zis: “Tu ești regele iudeilor?” ");
INSERT INTO ronlsb_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Isus i-a răspuns: “Spui lucrul acesta de unul singur, sau ți-au spus alții despre Mine?” ");
INSERT INTO ronlsb_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilat a răspuns: “Eu nu sunt iudeu, nu-i așa? Neamul tău și preoții cei mai de seamă te-au predat mie. Ce ai făcut?” ");
INSERT INTO ronlsb_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Isus a răspuns: “Împărăția Mea nu este din lumea aceasta. Dacă Împărăția mea ar fi din lumea aceasta, atunci slujitorii mei s-ar lupta, ca să nu fiu predat iudeilor. Dar acum Împărăția mea nu este de aici.” ");
INSERT INTO ronlsb_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Și Pilat I-a zis: “Deci ești tu rege?” Isus a răspuns: “Tu spui că sunt rege. De aceea M-am născut și de aceea am venit în lume: ca să mărturisesc adevărul. Oricine este din adevăr ascultă glasul meu”. ");
INSERT INTO ronlsb_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilat I-a zis: “Ce este adevărul?” După ce a spus aceasta, a ieșit din nou la iudei și le-a zis: “Nu găsesc nici un temei pentru o acuzație împotriva lui. ");
INSERT INTO ronlsb_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Dar voi aveți obiceiul ca eu să vă eliberez pe cineva la Paște. Prin urmare, vreți să vi-l eliberez pe regele iudeilor?” ");
INSERT INTO ronlsb_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Atunci toți au strigat iarăși: “Nu pe acesta, ci pe Baraba!” Or, Baraba era un tâlhar. ");
INSERT INTO ronlsb_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Atunci Pilat a luat pe Isus și L-a biciuit. ");
INSERT INTO ronlsb_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Soldații au răsucit spini pentru a face o coroană, i-au pus-o pe cap și l-au îmbrăcat într-o haină de purpură. ");
INSERT INTO ronlsb_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ei tot ziceau: “Slavă ție, rege al iudeilor!” și îl tot pălmuiau. ");
INSERT INTO ronlsb_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Atunci Pilat a ieșit iarăși și le-a zis: “Iată, vi-l scot afară, ca să știți că nu găsesc nici un temei de acuzare împotriva lui.” ");
INSERT INTO ronlsb_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Isus a ieșit afară, purtând cununa de spini și haina de purpură. Pilat le-a zis: “Iată-l pe Omul acesta!”. ");
INSERT INTO ronlsb_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Atunci preoții cei mai de seamă și arhiereii, văzându-L, au strigat și au zis: “Răstignește-L! Răstignește!” Pilat le-a zis: “Luați-L voi înșivă și răstigniți-L, căci nu găsesc nici un temei de acuzare împotriva Lui.” ");
INSERT INTO ronlsb_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Iudeii I-au răspuns: “Noi avem o lege și, după legea noastră, trebuie să moară, pentru că S-a făcut pe Sine Fiul lui Dumnezeu.” ");
INSERT INTO ronlsb_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Când a auzit Pilat aceste cuvinte, s-a înspăimântat și mai mult. ");
INSERT INTO ronlsb_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","A intrat din nou în pretoriu și a întrebat pe Isus: “De unde ești?” Dar Isus nu i-a dat niciun răspuns. ");
INSERT INTO ronlsb_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Atunci Pilat i-a zis: “Nu vorbești cu mine? Nu știi că am puterea să te eliberez și am puterea să te răstignesc?” ");
INSERT INTO ronlsb_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Isus a răspuns: “N-aveți nici o putere împotriva Mea, dacă nu v-ar fi dată de sus. De aceea, cel care m-a predat vouă are un păcat mai mare.” ");
INSERT INTO ronlsb_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Atunci Pilat a vrut să-l elibereze, dar iudeii au strigat: “Dacă-l eliberezi pe omul acesta, nu ești prietenul Cezarului! Oricine se face rege vorbește împotriva Cezarului!” ");
INSERT INTO ronlsb_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilat, auzind aceste cuvinte, a scos pe Isus afară și a șezut pe scaunul de judecată, într-un loc numit “Pavecernița”, dar în ebraică “Gabbatha”. ");
INSERT INTO ronlsb_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Era ziua pregătirii Paștelui, cam pe la ora șase. El le-a spus iudeilor: “Iată Regele vostru!”. ");
INSERT INTO ronlsb_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Și au strigat: “Departe de El! Departe de el! Răstigniți-l!” Pilat i-a întrebat: “Să-l răstignesc pe regele vostru?” Preoții cei mai de seamă au răspuns: “Noi nu avem alt rege decât pe Cezar!” ");
INSERT INTO ronlsb_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Și L-a dat să fie răstignit. Și au luat pe Isus și L-au dus. ");
INSERT INTO ronlsb_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","El a ieșit, purtându-și crucea, la locul numit “Locul craniului”, care în ebraică se numește “Golgota”, ");
INSERT INTO ronlsb_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","unde L-au răstignit și, împreună cu El, pe alți doi, de o parte și de alta, unul de fiecare parte, și pe Isus în mijloc. ");
INSERT INTO ronlsb_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilat a scris și un titlu și l-a pus pe cruce. Acolo era scris: “IISUS DIN NAZARETH, REGELE EVREILOR”. ");
INSERT INTO ronlsb_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","De aceea, mulți dintre iudei citeau acest titlu, căci locul unde a fost răstignit Isus era aproape de cetate; și era scris în ebraică, în latină și în greacă. ");
INSERT INTO ronlsb_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","De aceea, preoții cei mai de seamă ai iudeilor i-au spus lui Pilat: “Nu scrie: “Regele iudeilor”, ci: “El a spus: “Eu sunt Regele iudeilor”.”” ");
INSERT INTO ronlsb_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilat a răspuns: “Ceea ce am scris, am scris.” ");
INSERT INTO ronlsb_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","După ce au răstignit pe Isus, ostașii au luat hainele Lui și au făcut patru părți, câte o parte pentru fiecare ostaș, și tunica. Tunica era fără cusătură, țesută de sus în jos, de la un capăt la altul. ");
INSERT INTO ronlsb_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Și au zis unul către altul: “Să nu o rupem, ci să tragem la sorți pentru ea, ca să hotărâm a cui va fi”, ca să se împlinească Scriptura care zice “Au împărțit hainele mele între ei. Au tras la sorți pentru hainele mele.” De aceea soldații au făcut aceste lucruri. ");
INSERT INTO ronlsb_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Iar lângă crucea lui Isus stăteau mama Lui, sora mamei Lui, Maria, nevasta lui Clopaș, și Maria Magdalena. ");
INSERT INTO ronlsb_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Când a văzut Isus pe mama Sa și pe ucenicul pe care-l iubea stând acolo, a zis mamei Sale: “Femeie, iată fiul tău!” ");
INSERT INTO ronlsb_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Apoi a zis ucenicului: “Iată mama ta!”. Din acel ceas, discipolul a luat-o la el acasă. ");
INSERT INTO ronlsb_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","După aceea, Isus, văzând că toate lucrurile se terminaseră, ca să se împlinească Scriptura, a zis: “Mi-e sete!” ");
INSERT INTO ronlsb_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Și era pus acolo un vas plin cu oțet; au pus un burete plin de oțet pe isop și l-au ținut la gura Lui. ");
INSERT INTO ronlsb_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","După ce a primit deci oțetul, Isus a zis: “S-a sfârșit!” Apoi și-a plecat capul și și-a dat duhul. ");
INSERT INTO ronlsb_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","De aceea iudeii, pentru că era ziua pregătirii, ca să nu rămână trupurile pe cruce în Sabat, căci Sabatul acela era un Sabat special, au cerut lui Pilat să li se rupă picioarele și să fie luați. ");
INSERT INTO ronlsb_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Soldații au venit, așadar, și au rupt picioarele celui dintâi și ale celuilalt care fusese răstignit împreună cu el; ");
INSERT INTO ronlsb_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","dar, când au ajuns la Isus și au văzut că era deja mort, nu i-au rupt picioarele. ");
INSERT INTO ronlsb_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Totuși, unul dintre soldați i-a străpuns coasta cu o suliță și imediat a ieșit sânge și apă. ");
INSERT INTO ronlsb_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Cel care a văzut a depus mărturie, și mărturia lui este adevărată. El știe că spune adevărul, ca să credeți. ");
INSERT INTO ronlsb_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Căci aceste lucruri s-au întâmplat pentru ca să se împlinească Scriptura: “Nici un os din el nu va fi zdrobit”. ");
INSERT INTO ronlsb_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Și iarăși o altă Scriptură spune: “Se vor uita la Cel pe care L-au străpuns.” ");
INSERT INTO ronlsb_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","După acestea, Iosif din Arimateea, care era ucenic al lui Isus, dar care, de frica iudeilor, a cerut lui Pilat să ia trupul lui Isus. Pilat i-a dat permisiunea. A venit, așadar, și a luat trupul Lui. ");
INSERT INTO ronlsb_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodim, care la început venise la Isus noaptea, a venit și el aducând un amestec de smirnă și aloe, cam o sută de lire romane. ");
INSERT INTO ronlsb_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Au luat deci trupul lui Isus și l-au legat în pânze de in cu mirodenii, așa cum este obiceiul iudeilor de a-l îngropa. ");
INSERT INTO ronlsb_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","În locul unde a fost răstignit era o grădină. În grădină era un mormânt nou, în care nu mai fusese așezat niciun om până atunci. ");
INSERT INTO ronlsb_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Atunci, din pricina zilei de pregătire a iudeilor (căci mormântul era aproape), au pus pe Isus acolo. ");
INSERT INTO ronlsb_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","În prima zi a săptămânii, Maria Magdalena s-a dus dis-de-dimineață la mormânt, pe când era încă întuneric, și a văzut că piatra fusese scoasă de pe mormânt. ");
INSERT INTO ronlsb_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","De aceea a alergat și a venit la Simon Petru și la celălalt ucenic pe care-l iubea Isus și le-a zis: “L-au luat pe Domnul din mormânt și nu știm unde L-au pus!” ");
INSERT INTO ronlsb_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Atunci Petru și celălalt ucenic au ieșit și s-au dus la mormânt. ");
INSERT INTO ronlsb_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Și amândoi alergau împreună. Celălalt ucenic l-a întrecut pe Petru și a ajuns primul la mormânt. ");
INSERT INTO ronlsb_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","S-a aplecat și a privit înăuntru, a văzut pânzele de in așezate acolo, dar n-a intrat. ");
INSERT INTO ronlsb_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Atunci Simon Petru a venit după el și a intrat în mormânt. A văzut așezate pânzele de in, ");
INSERT INTO ronlsb_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","iar pânza care fusese pe capul Lui, nu era așezată împreună cu pânzele de in, ci înfășurată într-un loc de sine stătător. ");
INSERT INTO ronlsb_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Atunci a intrat și celălalt ucenic care venise primul la mormânt; a văzut și el și a crezut. ");
INSERT INTO ronlsb_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Căci încă nu cunoșteau Scriptura, că trebuie să învieze din morți. ");
INSERT INTO ronlsb_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ucenicii s-au dus din nou la casele lor. ");
INSERT INTO ronlsb_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Dar Maria stătea afară la mormânt și plângea. Și, în timp ce plângea, s-a aplecat și s-a uitat în mormânt, ");
INSERT INTO ronlsb_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","și a văzut doi îngeri în alb care stăteau, unul la cap și altul la picioare, unde fusese așezat trupul lui Isus. ");
INSERT INTO ronlsb_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ei au întrebat-o: “Femeie, de ce plângi?”. Ea le-a spus: “Pentru că l-au luat pe Domnul meu și nu știu unde l-au pus”. ");
INSERT INTO ronlsb_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","După ce a spus aceasta, s-a întors și a văzut pe Isus în picioare, și nu știa că este Isus. ");
INSERT INTO ronlsb_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Isus i-a zis: “Femeie, de ce plângi? Pe cine cauți?” Ea, presupunând că este grădinarul, i-a spus: “Domnule, dacă l-ai dus, spune-mi unde l-ai pus și îl voi lua.” ");
INSERT INTO ronlsb_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Isus i-a zis: “Maria.” Ea s-a întors și i-a spus: “Rabboni!”, adică “Învățătorule!”. ");
INSERT INTO ronlsb_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Isus i-a zis: “Nu Mă țineți, căci încă nu M-am înălțat la Tatăl Meu, ci du-te la frații Mei și spune-le: Mă înalț la Tatăl Meu și Tatăl vostru, la Dumnezeul Meu și Dumnezeul vostru.” ");
INSERT INTO ronlsb_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maria Magdalena a venit și a spus ucenicilor că a văzut pe Domnul și că El i-a spus aceste lucruri. ");
INSERT INTO ronlsb_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Așadar, când s-a făcut seară în ziua aceea, prima zi a săptămânii, și când ușile erau încuiate acolo unde erau adunați discipolii, de frica iudeilor, Isus a venit, a stat în mijloc și le-a zis: “Pace vouă!”. ");
INSERT INTO ronlsb_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","După ce a zis acestea, le-a arătat mâinile și coasta Lui. Ucenicii s-au bucurat, așadar, când L-au văzut pe Domnul. ");
INSERT INTO ronlsb_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Isus le-a zis din nou: “Pace vouă! Cum M-a trimis Tatăl, așa vă trimit și Eu pe voi”. ");
INSERT INTO ronlsb_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","După ce a spus acestea, a suflat peste ei și le-a zis: “Primiți Duhul Sfânt! ");
INSERT INTO ronlsb_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Dacă iertați păcatele cuiva, i-au fost iertate. Dacă rețineți păcatele cuiva, ele au fost reținute.” ");
INSERT INTO ronlsb_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Dar Toma, unul din cei doisprezece, numit Didimus, nu era cu ei când a venit Isus. ");
INSERT INTO ronlsb_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","De aceea, ceilalți discipoli i-au spus: “L-am văzut pe Domnul!” Dar el le-a zis: “Dacă nu voi vedea în mâinile Lui amprenta cuielor, dacă nu voi pune degetul meu în amprenta cuielor și dacă nu voi pune mâna mea în coasta Lui, nu voi crede.” ");
INSERT INTO ronlsb_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","După opt zile, ucenicii Lui au intrat din nou înăuntru și Toma era cu ei. Isus a venit, ușile fiind încuiate, a stat în mijloc și a zis: “Pace vouă!”. ");
INSERT INTO ronlsb_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Apoi i-a spus lui Toma: “Întinde aici degetul tău și vezi mâinile Mele. Întinde aici mâna ta și pune-o în coasta Mea. Nu fi necredincios, ci credincios.” ");
INSERT INTO ronlsb_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toma I-a răspuns: “Domnul meu și Dumnezeul meu!” ");
INSERT INTO ronlsb_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Isus i-a zis: “Pentru că M-ai văzut, ai crezut. Ferice de cei care nu au văzut și au crezut.” ");
INSERT INTO ronlsb_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Isus a mai făcut multe alte semne în fața ucenicilor Săi, care nu sunt scrise în cartea aceasta; ");
INSERT INTO ronlsb_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","dar acestea sunt scrise pentru ca voi să credeți că Isus este Hristosul, Fiul lui Dumnezeu, și, crezând, să aveți viață în Numele Lui. ");
INSERT INTO ronlsb_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","După acestea, Isus S-a arătat din nou ucenicilor la Marea Tiberiadei. El s-a revelat în felul următor. ");
INSERT INTO ronlsb_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Petru, Toma zis Didim, Natanael din Cana Galileii, fiii lui Zebedei și alți doi dintre discipolii Săi erau împreună. ");
INSERT INTO ronlsb_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Petru le-a spus: “Mă duc la pescuit”. I-au spus: “Și noi venim cu tine”. Au ieșit imediat și au intrat în barcă. În acea noapte, nu au prins nimic. ");
INSERT INTO ronlsb_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Dar când deja se făcuse ziuă, Isus stătea pe plajă; totuși, discipolii nu știau că era Isus. ");
INSERT INTO ronlsb_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Isus le-a zis deci: “Copii, aveți ceva de mâncare?” Ei i-au răspuns: “Nu”. ");
INSERT INTO ronlsb_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Și le-a zis: “Aruncați năvodul în partea dreaptă a corăbiei și veți găsi câteva.” L-au aruncat, deci, și acum nu mai puteau să-l atragă pentru mulțimea de pești. ");
INSERT INTO ronlsb_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","De aceea, ucenicul acela pe care-l iubea Isus i-a spus lui Petru: “Este Domnul!” Când Simon Petru a auzit că este Domnul, și-a înfășurat haina (căci era gol) și s-a aruncat în mare. ");
INSERT INTO ronlsb_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Dar ceilalți ucenici au venit cu barca mică (căci nu erau departe de uscat, ci la vreo două sute de coți), trăgând plasa plină de pește. ");
INSERT INTO ronlsb_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Când au ieșit pe uscat, au văzut acolo un foc de cărbuni, pe care erau așezate pește și pâine. ");
INSERT INTO ronlsb_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Isus le-a zis: “Aduceți o parte din peștele pe care tocmai l-ați prins.” ");
INSERT INTO ronlsb_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Petru s-a suit și a tras la țărm o plasă plină cu o sută cincizeci și trei de pești mari. Chiar dacă erau atât de mulți, plasa nu s-a rupt. ");
INSERT INTO ronlsb_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Isus le-a zis: “Veniți și luați micul dejun!” Nici unul dintre ucenici nu a îndrăznit să-l întrebe: “Cine ești tu?”, știind că era Domnul. ");
INSERT INTO ronlsb_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Isus a venit, a luat pâinea, le-a dat-o și peștele, și tot așa și peștele. ");
INSERT INTO ronlsb_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Aceasta este acum a treia oară când Iisus se arată discipolilor Săi după ce a înviat din morți. ");
INSERT INTO ronlsb_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","După ce au luat micul dejun, Isus i-a zis lui Simon Petru: “Simon, fiul lui Iona, mă iubești tu mai mult decât aceștia?” El i-a răspuns: “Da, Doamne, știi că am o afecțiune pentru tine”. El i-a spus: “Paște mieii mei”. ");
INSERT INTO ronlsb_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Și i-a zis a doua oară: “Simon, fiul lui Iona, mă iubești?” El i-a răspuns: “Da, Doamne, știi că am o afecțiune pentru tine”. El i-a spus: “Păzește oile mele”. ");
INSERT INTO ronlsb_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","A treia oară i-a zis: “Simon, fiul lui Iona, mă iubești?” Petru a fost mâhnit pentru că l-a întrebat a treia oară: “Mă iubești?”. El i-a răspuns: “Doamne, Tu știi totul. Tu știi că am afecțiune pentru tine”. Isus i-a spus: “Paște oile Mele. ");
INSERT INTO ronlsb_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Adevărat îți spun că, atunci când erai tânăr, te îmbrăcai singur și mergeai pe unde voiai. Dar când vei fi bătrân, vei întinde mâinile și altul te va îmbrăca și te va duce unde nu vrei să mergi.” ");
INSERT INTO ronlsb_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Și a spus aceasta, ca să arate prin ce fel de moarte vrea să slăvească pe Dumnezeu. După ce a spus aceasta, i-a zis: “Urmează-mă”. ");
INSERT INTO ronlsb_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Atunci Petru, întorcându-se, a văzut un ucenic care îl urmărea. Acesta era ucenicul pe care Isus îl iubea, cel care se aplecase și el la pieptul lui Isus la cină și care întrebase: “Doamne, cine te va trăda?” ");
INSERT INTO ronlsb_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Petru, văzându-l, l-a întrebat pe Isus: “Doamne, ce-i cu omul acesta?” ");
INSERT INTO ronlsb_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Isus i-a zis: “Dacă vreau să rămână până ce voi veni Eu, ce-ți pasă ție? Urmează-mă tu!” ");
INSERT INTO ronlsb_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","De aceea s-a răspândit acest cuvânt printre frați, ca acest ucenic să nu moară. Totuși, Isus nu i-a spus că nu va muri, ci: “Dacă vreau ca el să rămână până când voi veni eu, ce-ți pasă ție?” ");
INSERT INTO ronlsb_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Acesta este ucenicul care mărturisește despre aceste lucruri și care a scris aceste lucruri. Noi știm că mărturia lui este adevărată. ");
INSERT INTO ronlsb_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Mai sunt și multe alte lucruri pe care le-a făcut Isus, care, dacă ar fi scrise toate, cred că nici măcar lumea însăși nu ar avea loc pentru cărțile care s-ar scrie. ");
INSERT INTO ronlsb_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Prima carte pe care am scris-o, Teofilule, se referă la tot ce a început Isus să facă și să învețe, ");
INSERT INTO ronlsb_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","până în ziua în care a fost înălțat, după ce a dat poruncă prin Duhul Sfânt apostolilor pe care îi alesese. ");
INSERT INTO ronlsb_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Acestora li s-a arătat viu și după ce a suferit, prin multe dovezi, arătându-li-se pe parcursul a patruzeci de zile și vorbindu-le despre Împărăția lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Fiind adunat împreună cu ei, le-a poruncit: “Nu plecați din Ierusalim, ci așteptați promisiunea Tatălui, pe care ați auzit-o de la mine. ");
INSERT INTO ronlsb_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Căci Ioan a botezat într-adevăr în apă, dar voi veți fi botezați în Duhul Sfânt nu peste multe zile”. ");
INSERT INTO ronlsb_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Când s-au adunat, L-au întrebat: “Doamne, acum dai înapoi împărăția lui Israel?” ");
INSERT INTO ronlsb_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","El le-a zis: “Nu este treaba voastră să cunoașteți vremurile și timpurile pe care Tatăl le-a pus în autoritatea Sa. ");
INSERT INTO ronlsb_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Dar voi veți primi putere când va veni Duhul Sfânt peste voi. Îmi veți fi martori în Ierusalim, în toată Iudeea și Samaria și până la marginile pământului.” ");
INSERT INTO ronlsb_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","După ce a spus aceste lucruri, pe când se uitau ei, a fost ridicat și un nor L-a luat din fața lor. ");
INSERT INTO ronlsb_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","În timp ce ei priveau neclintit spre cer, în timp ce El se ducea, iată că lângă ei stăteau doi bărbați îmbrăcați în haine albe, ");
INSERT INTO ronlsb_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","care au spus și ei: “Bărbați galileeni, de ce stați cu ochii în cer? Acest Isus, care a fost primit de la voi în cer, se va întoarce în același mod în care L-ați văzut mergând în cer.” ");
INSERT INTO ronlsb_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Apoi s-au întors la Ierusalim, de pe muntele numit Muntele Măslinilor, care este lângă Ierusalim, la o zi de drum de Sabat. ");
INSERT INTO ronlsb_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","După ce au ajuns, s-au urcat în camera de sus unde stăteau: Petru, Ioan, Iacov, Iacov, Andrei, Filip, Toma, Bartolomeu, Matei, Iacov, fiul lui Alfeu, Simon Zelota și Iuda, fiul lui Iacov. ");
INSERT INTO ronlsb_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Toți aceștia, cu un singur gând, stăruiau cu stăruință în rugăciune și în cereri, împreună cu femeile, cu Maria, mama lui Isus, și cu frații Lui. ");
INSERT INTO ronlsb_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","În zilele acelea, Petru s-a ridicat în picioare în mijlocul ucenicilor, care erau în număr de o sută douăzeci, și a zis: ");
INSERT INTO ronlsb_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Fraților, trebuia să se împlinească Scriptura aceasta, pe care Duhul Sfânt a spus-o mai înainte, prin gura lui David, despre Iuda, care era călăuza celor ce luaseră pe Isus. ");
INSERT INTO ronlsb_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Căci el a fost socotit împreună cu noi și a primit partea lui în această slujbă. ");
INSERT INTO ronlsb_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Omul acesta a obținut un câmp cu răsplata pentru răutatea lui; și, căzând cu capul în jos, i s-a deschis trupul și i-au țâșnit toate intestinele. ");
INSERT INTO ronlsb_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Toți cei care locuiau în Ierusalim au aflat că în limba lor câmpul acela se numea “Akeldama”, adică “Câmpul de sânge”. ");
INSERT INTO ronlsb_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Căci este scris în cartea Psalmilor: “Este un câmp de sânge, “Să fie pustiită locuința lui. Nimeni să nu locuiască în ea”. și, “Lasă-l pe altul să își ocupe funcția. ");
INSERT INTO ronlsb_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Așadar, dintre bărbații care ne-au însoțit în tot timpul în care Domnul Isus a intrat și a ieșit dintre noi, ");
INSERT INTO ronlsb_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","începând de la botezul lui Ioan și până în ziua în care a fost ridicat de la noi, unul dintre aceștia trebuie să fie martor cu noi al învierii Lui.” ");
INSERT INTO ronlsb_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Au propus două: Iosif, zis Barsabas, care se mai numea și Iustus, și Matia. ");
INSERT INTO ronlsb_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ei s-au rugat și au zis: “Tu, Doamne, care cunoști inimile tuturor oamenilor, arată pe care dintre acești doi l-ai ales ");
INSERT INTO ronlsb_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","pentru a lua parte la această slujbă și apostolat, de la care a căzut Iuda, ca să se ducă la locul lui.” ");
INSERT INTO ronlsb_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Au tras la sorți pentru ei și sorțul a căzut pe Matia; și a fost numărat împreună cu cei unsprezece apostoli. ");
INSERT INTO ronlsb_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Când a sosit ziua Cincizecimii, erau toți la un loc, deodată, în același loc. ");
INSERT INTO ronlsb_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Deodată s-a auzit din cer un zgomot ca un vuiet de vânt puternic, care a umplut toată casa în care stăteau. ");
INSERT INTO ronlsb_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Au apărut limbi ca de foc și li s-au împărțit, și câte una s-a așezat pe fiecare dintre ei. ");
INSERT INTO ronlsb_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Cu toții au fost umpluți de Duhul Sfânt și au început să vorbească în alte limbi, după cum le dădea Duhul să vorbească. ");
INSERT INTO ronlsb_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","În Ierusalim locuiau iudei evrei, oameni evlavioși, din toate neamurile de sub cer. ");
INSERT INTO ronlsb_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Când s-a auzit acest sunet, mulțimea s-a adunat și a rămas nedumerită, pentru că fiecare îi auzea vorbind în limba lui. ");
INSERT INTO ronlsb_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Toți erau uimiți și se mirau, spunându-și unii altora: “Iată, oare nu sunt galileeni toți aceștia care vorbesc? ");
INSERT INTO ronlsb_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Cum îi auzim, fiecare în limba sa maternă? ");
INSERT INTO ronlsb_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Parțieni, medi, elamiți și oameni din Mesopotamia, Iudeea, Capadocia, Pont, Asia, ");
INSERT INTO ronlsb_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia, Pamfilia, Egipt, părțile Libiei din jurul Cirenei, vizitatori din Roma, atât evrei cât și prozeliți, ");
INSERT INTO ronlsb_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","cretani și arabi — noi îi auzim vorbind în limbile noastre despre lucrările mărețe ale lui Dumnezeu!” ");
INSERT INTO ronlsb_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Toți au rămas uimiți și perplecși, spunându-și unii altora: “Ce înseamnă aceasta?” ");
INSERT INTO ronlsb_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Alții, batjocorind, spuneau: “Sunt plini de vin nou”. ");
INSERT INTO ronlsb_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Dar Petru, stând în picioare cu cei unsprezece, a ridicat glasul și le-a zis: “Bărbați din Iudeea și voi toți cei ce locuiți la Ierusalim, să vă fie cunoscut lucrul acesta și ascultați cuvintele mele. ");
INSERT INTO ronlsb_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Căci aceștia nu sunt beți, așa cum credeți voi, întrucât este abia al treilea ceas al zilei. ");
INSERT INTO ronlsb_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ci iată ce s-a spus prin profetul Ioel: ");
INSERT INTO ronlsb_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Așa va fi în zilele de pe urmă, zice Dumnezeu, că Îmi voi revărsa Duhul Meu peste toată făptura. Fiii și fiicele voastre vor profeți. Tinerii tăi vor avea viziuni. Bătrânii tăi vor visa vise. ");
INSERT INTO ronlsb_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Și pe robii mei și pe roabele mele în zilele acelea, Voi revărsa Duhul Meu și ei vor profeți. ");
INSERT INTO ronlsb_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Voi face minuni pe cerul de sus, și semne pe pământul de dedesubt: sânge, foc și valuri de fum. ");
INSERT INTO ronlsb_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Soarele se va preface în întuneric, și luna în sânge, înainte ca ziua cea mare și glorioasă a Domnului să vină. ");
INSERT INTO ronlsb_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Oricine va invoca Numele Domnului va fi mântuit. ");
INSERT INTO ronlsb_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Bărbați ai lui Israel, ascultați aceste cuvinte! Pe Isus din Nazaret, un om aprobat de Dumnezeu pentru voi prin fapte puternice, minuni și semne pe care Dumnezeu le-a făcut prin el printre voi, după cum știți voi înșivă, ");
INSERT INTO ronlsb_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","pe El, care a fost predat prin sfatul hotărât și prin știința mai dinainte a lui Dumnezeu, L-ați prins prin mâna unor oameni fără de lege, L-ați răstignit și L-ați ucis; ");
INSERT INTO ronlsb_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","pe care Dumnezeu L-a înviat, eliberându-L de agonia morții, pentru că nu era cu putință ca El să fie ținut de ea. ");
INSERT INTO ronlsb_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Căci David spune despre El: “Nu este posibil să fi fost învins de Dumnezeu, pentru că nu era cu putință să fie învins, 'Îl vedeam pe Domnul mereu înaintea feței mele, Căci El este la dreapta mea, ca să nu mă clatin. ");
INSERT INTO ronlsb_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","De aceea inima mea s-a bucurat și limba mea s-a veselit. Mai mult, și carnea mea va locui în speranță, ");
INSERT INTO ronlsb_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","pentru că nu vei lăsa sufletul meu în Locuința morților, nici nu vei permite ca Sfântul tău să vadă putreziciunea. ");
INSERT INTO ronlsb_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Tu mi-ai făcut cunoscute căile vieții. Mă vei umple de bucurie cu prezența ta. ");
INSERT INTO ronlsb_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Fraților, pot să vă spun, în mod liber, despre patriarhul David, că a murit și a fost îngropat, iar mormântul lui este la noi până în ziua de azi. ");
INSERT INTO ronlsb_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","De aceea, fiind profet și știind că Dumnezeu îi jurase cu jurământ că din rodul trupului său, după trup, va ridica pe Hristos ca să șadă pe tronul său, ");
INSERT INTO ronlsb_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","el, prevăzând acest lucru, a vorbit despre învierea lui Hristos, că sufletul lui nu a rămas în Hades și că trupul lui nu a văzut putrezirea. ");
INSERT INTO ronlsb_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Acest Isus pe care Dumnezeu l-a înviat, despre care noi toți suntem martori. ");
INSERT INTO ronlsb_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","De aceea, fiind înălțat la dreapta lui Dumnezeu și primind de la Tatăl făgăduința Duhului Sfânt, a revărsat ceea ce vedeți și auziți acum. ");
INSERT INTO ronlsb_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Căci David nu s-a înălțat la ceruri, ci el însuși spune, 'Domnul a zis Domnului meu: “Șezi la dreapta Mea. ");
INSERT INTO ronlsb_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","până când voi face din vrăjmașii tăi un tăpșan pentru picioarele tale.” ");
INSERT INTO ronlsb_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Să știe deci toată casa lui Israel că Dumnezeu a făcut Domn și Hristos pe acest Isus pe care voi L-ați răstignit.” ");
INSERT INTO ronlsb_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Auzind acestea, s-au cutremurat și au zis lui Petru și celorlalți apostoli: “Fraților, ce să facem?” ");
INSERT INTO ronlsb_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petru le-a zis: “Pocăiți-vă și fiecare dintre voi să fie botezat în numele lui Isus Hristos, pentru iertarea păcatelor, și veți primi darul Duhului Sfânt. ");
INSERT INTO ronlsb_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Căci făgăduința este pentru voi și pentru copiii voștri și pentru toți cei de departe, pentru toți cei pe care îi va chema la sine Domnul Dumnezeul nostru.” ");
INSERT INTO ronlsb_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Cu multe alte cuvinte a dat mărturie și i-a îndemnat, zicând: “Salvați-vă de acest neam strâmb!”. ");
INSERT INTO ronlsb_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Și cei ce au primit cu bucurie cuvântul Lui au fost botezați. În ziua aceea s-au adăugat în jur de trei mii de suflete. ");
INSERT INTO ronlsb_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ei stăruiau cu stăruință în învățătura apostolilor și în părtășia cu ei, în frângerea pâinii și în rugăciune. ");
INSERT INTO ronlsb_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Înfricoșarea a cuprins fiecare suflet, și multe minuni și semne se făceau prin apostoli. ");
INSERT INTO ronlsb_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Toți cei care credeau erau împreună și aveau toate lucrurile în comun. ");
INSERT INTO ronlsb_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Își vindeau averile și bunurile și le împărțeau la toți, după cum avea cineva nevoie. ");
INSERT INTO ronlsb_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Zi de zi, stăruind cu stăruință și de comun acord în templu și frângând pâinea acasă, își luau hrana cu bucurie și cu inimă curată, ");
INSERT INTO ronlsb_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","lăudând pe Dumnezeu și având parte de bunăvoința întregului popor. Domnul adăuga zi de zi la adunare pe cei care erau salvați. ");
INSERT INTO ronlsb_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Petru și Ioan se urcau în templu la ora de rugăciune, la ceasul al nouălea. ");
INSERT INTO ronlsb_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Se ducea un om șchiop din pântecele mamei sale, pe care îl puneau zilnic la ușa templului numit Frumos, ca să ceară daruri pentru cei nevoiași dintre cei care intrau în templu. ");
INSERT INTO ronlsb_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Văzându-i pe Petru și pe Ioan pe cale să intre în templu, a cerut să primească daruri pentru cei nevoiași. ");
INSERT INTO ronlsb_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Petru, fixându-și ochii asupra lui, împreună cu Ioan, a zis: “Uită-te la noi”. ");
INSERT INTO ronlsb_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","El i-a ascultat, așteptând să primească ceva de la ei. ");
INSERT INTO ronlsb_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Dar Petru a spus: “Nu am nici argint, nici aur, ci ceea ce am, asta vă dau. În numele lui Isus Hristos din Nazaret, ridică-te și umblă!”. ");
INSERT INTO ronlsb_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","El l-a luat de mâna dreaptă și l-a ridicat. Imediat picioarele și oasele gleznelor lui au primit putere. ");
INSERT INTO ronlsb_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Sărind, s-a ridicat în picioare și a început să meargă. A intrat cu ei în templu, mergând, sărind și lăudându-l pe Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Tot poporul l-a văzut mergând și lăudându-l pe Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","L-au recunoscut, că era cel care obișnuia să stea să cerșească daruri pentru nevoiași la Poarta Frumoasă a templului. Erau plini de uimire și de mirare pentru ceea ce i se întâmplase. ");
INSERT INTO ronlsb_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","În timp ce șchiopul vindecat se ținea de Petru și de Ioan, tot poporul a alergat împreună la ei în pridvorul care se numește al lui Solomon, minunându-se foarte mult. ");
INSERT INTO ronlsb_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Petru, văzând aceasta, a zis norodului: “Bărbați israeliți, de ce vă minunați de omul acesta? De ce vă holbați ochii la noi, ca și cum prin puterea sau evlavia noastră l-am fi făcut să meargă? ");
INSERT INTO ronlsb_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Dumnezeul lui Avraam, al lui Isaac și al lui Iacov, Dumnezeul părinților noștri, a proslăvit pe Robul Său Isus, pe care voi L-ați predat și L-ați renegat în fața lui Pilat, când acesta hotărâse să-L elibereze. ");
INSERT INTO ronlsb_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Dar voi L-ați renegat pe Cel Sfânt și Drept și ați cerut să vi se acorde un ucigaș, ");
INSERT INTO ronlsb_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","și ați ucis pe Prințul vieții, pe care Dumnezeu L-a înviat din morți, lucru despre care noi suntem martori. ");
INSERT INTO ronlsb_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Prin credința în numele lui, numele lui l-a făcut puternic pe acest om, pe care îl vedeți și îl cunoașteți. Da, credința care este prin el i-a dat această desăvârșită sănătate în prezența voastră a tuturor. ");
INSERT INTO ronlsb_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Fraților, știu că voi, ca și căpeteniile voastre, ați făcut aceasta din neștiință. ");
INSERT INTO ronlsb_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Dar lucrurile pe care le-a anunțat Dumnezeu prin gura tuturor profeților Săi, că Hristos va suferi, le-a împlinit astfel. ");
INSERT INTO ronlsb_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","“Pocăiți-vă, deci, și întoarceți-vă, ca să vi se șteargă păcatele, ca să vină vremuri de răcorire de la fața Domnului, ");
INSERT INTO ronlsb_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ca să trimită pe Hristos Isus, care a fost rânduit pentru voi mai înainte, ");
INSERT INTO ronlsb_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","pe care cerul trebuie să-L primească până la vremurile de refacere a tuturor lucrurilor, pe care Dumnezeu le-a spus demult prin gura sfinților Săi prooroci. ");
INSERT INTO ronlsb_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Căci Moise a spus într-adevăr părinților: “Domnul Dumnezeu vă va ridica un profet dintre frații voștri, ca mine. Îl veți asculta în toate lucrurile pe care vi le va spune. ");
INSERT INTO ronlsb_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Orice suflet care nu va asculta de acel profet va fi nimicit cu desăvârșire din mijlocul poporului'. ");
INSERT INTO ronlsb_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Da, și toți profeții, de la Samuel și cei care au urmat după el, toți cei care au vorbit, au vorbit și ei despre aceste zile. ");
INSERT INTO ronlsb_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Voi sunteți copiii profeților și ai legământului pe care l-a făcut Dumnezeu cu părinții noștri, când a zis lui Avraam: 'Toate familiile pământului vor fi binecuvântate prin urmașii tăi'. ");
INSERT INTO ronlsb_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Dumnezeu, după ce l-a ridicat pe robul său Isus, l-a trimis mai întâi la voi ca să vă binecuvânteze, întorcându-vă pe fiecare dintre voi de la răutatea voastră.” ");
INSERT INTO ronlsb_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pe când vorbeau ei poporului, au venit la ei preoții, căpetenia templului și saducheii, ");
INSERT INTO ronlsb_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","care erau supărați că ei învățau poporul și propovăduiau în Iisus învierea din morți. ");
INSERT INTO ronlsb_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Au pus mâna pe ei și i-au pus în arest până a doua zi, căci era deja seară. ");
INSERT INTO ronlsb_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Dar mulți dintre cei care au auzit cuvântul au crezut și numărul lor a ajuns să fie cam cinci mii. ");
INSERT INTO ronlsb_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Dimineața, s-au adunat la Ierusalim conducătorii, bătrânii și cărturarii lor. ");
INSERT INTO ronlsb_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Marele preot Ana era acolo, împreună cu Caiafa, cu Ioan, cu Alexandru și cu toți cei care erau rude cu marele preot. ");
INSERT INTO ronlsb_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","După ce au așezat pe Petru și pe Ioan în mijlocul lor, i-au întrebat: “Cu ce putere sau în ce nume ați făcut aceasta?” ");
INSERT INTO ronlsb_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Atunci Petru, plin de Duhul Sfânt, le-a zis: “Căpeteniile poporului și bătrânii lui Israel, ");
INSERT INTO ronlsb_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","dacă suntem cercetați astăzi pentru o faptă bună făcută unui om olog, și pentru că omul acesta a fost vindecat, ");
INSERT INTO ronlsb_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","să știți voi toți și tot poporul lui Israel că, în numele lui Isus Hristos din Nazaret, pe care L-ați răstignit și pe care Dumnezeu L-a înviat din morți, omul acesta stă aici înaintea voastră, întreg în el. ");
INSERT INTO ronlsb_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","El este “piatra care a fost considerată de voi, zidarii, ca fiind fără valoare, și care a devenit capul unghiului”. ");
INSERT INTO ronlsb_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","În nimeni altcineva nu este mântuire, pentru că nu există sub cer un alt nume sub cer, dat între oameni, prin care să fim mântuiți!” ");
INSERT INTO ronlsb_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Când au văzut îndrăzneala lui Petru și a lui Ioan, și au înțeles că erau oameni neînvățați și neștiutori, s-au mirat. Ei au recunoscut că fuseseră cu Isus. ");
INSERT INTO ronlsb_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Văzând că omul care fusese vindecat stătea cu ei, nu au putut spune nimic împotrivă. ");
INSERT INTO ronlsb_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Dar, după ce le-au poruncit să iasă deoparte din consiliu, s-au sfătuit între ei, ");
INSERT INTO ronlsb_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","spunând: “Ce să le facem acestor oameni? Pentru că, într-adevăr, s-a făcut prin ei o minune remarcabilă, după cum pot vedea cu ochiul liber toți cei care locuiesc în Ierusalim, și nu putem nega acest lucru. ");
INSERT INTO ronlsb_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Dar, pentru ca acest lucru să nu se răspândească mai departe în popor, să-i amenințăm, ca de acum înainte să nu mai vorbească nimănui în acest nume.” ");
INSERT INTO ronlsb_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ei i-au chemat și le-au poruncit să nu vorbească deloc și să nu învețe în numele lui Isus. ");
INSERT INTO ronlsb_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Dar Petru și Ioan le-au răspuns: “Judecați voi înșivă dacă este drept înaintea lui Dumnezeu să vă ascultăm pe voi și nu pe Dumnezeu, ");
INSERT INTO ronlsb_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","căci noi nu putem să nu spunem ce am văzut și ce am auzit.” ");
INSERT INTO ronlsb_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","După ce i-au amenințat și mai mult, i-au lăsat să plece, fără să găsească o cale de a-i pedepsi, din cauza poporului, căci toți slăveau pe Dumnezeu pentru ceea ce se făcuse. ");
INSERT INTO ronlsb_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Căci omul asupra căruia s-a făcut această minune de vindecare avea mai mult de patruzeci de ani. ");
INSERT INTO ronlsb_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","După ce li s-a dat drumul, au venit în ceata lor și au povestit tot ce le spuseseră preoții cei mai de seamă și bătrânii. ");
INSERT INTO ronlsb_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","După ce au auzit, și-au înălțat glasul către Dumnezeu într-un glas și au zis: “Doamne, Tu ești Dumnezeu, care ai făcut cerul, pământul, marea și tot ce este în ele; ");
INSERT INTO ronlsb_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","care, prin gura robului Tău David, ai zis: “Doamne, Tu ești Dumnezeu, care ai făcut cerul, pământul, marea și tot ce este în ele; care, prin gura robului Tău David, ai spus 'De ce se înfurie națiunile, Și popoarele uneltesc un lucru deșert? ");
INSERT INTO ronlsb_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Împărații pământului iau atitudine, și conducătorii complotează împreună, împotriva Domnului și împotriva Hristosului Său”. ");
INSERT INTO ronlsb_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Căci, în adevăr, atât Irod, cât și Ponțiu Pilat, cu neamurile și cu poporul lui Israel, s-au adunat împotriva robului Tău cel sfânt, Isus, pe care L-ai uns, ");
INSERT INTO ronlsb_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ca să facă tot ce a hotărât mâna Ta și sfatul Tău să se întâmple. ");
INSERT INTO ronlsb_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Acum, Doamne, privește la amenințările lor și dă-le slujitorilor tăi să rostească cuvântul tău cu toată îndrăzneala, ");
INSERT INTO ronlsb_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","în timp ce tu îți întinzi mâna pentru a vindeca și pentru ca semnele și minunile să se facă prin numele sfântului tău slujitor Isus.” ");
INSERT INTO ronlsb_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","După ce s-au rugat, s-a cutremurat locul unde erau adunați. Toți au fost umpluți de Duhul Sfânt și au rostit cu îndrăzneală cuvântul lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Mulțimea celor ce au crezut era de o inimă și de un suflet. Nici unul dintre ei nu pretindea că ceva din lucrurile pe care le poseda îi aparținea, ci aveau toate lucrurile în comun. ");
INSERT INTO ronlsb_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Cu mare putere, apostolii dădeau mărturie despre învierea Domnului Isus. Mare har era peste ei toți. ");
INSERT INTO ronlsb_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nu era printre ei nici unul care să ducă lipsă, căci toți cei care erau proprietari de terenuri sau de case le vindeau și aduceau veniturile din lucrurile vândute ");
INSERT INTO ronlsb_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","și le puneau la picioarele apostolilor; și se făcea împărțirea la fiecare, după cum avea nevoie. ");
INSERT INTO ronlsb_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Iosif, care era numit de apostoli și Barnaba (care înseamnă, în traducere: Fiul încurajării), levit, om din Cipru, ");
INSERT INTO ronlsb_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","care aveaun câmp, l-a vândut, a adus banii și i-a pus la picioarele apostolilor. ");
INSERT INTO ronlsb_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Dar un om, numit Anania, împreună cu soția sa Safira, au vândut un bun ");
INSERT INTO ronlsb_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","și au păstrat o parte din preț, iar soția sa, care știa de aceasta, a adus o parte și a pus-o la picioarele apostolilor. ");
INSERT INTO ronlsb_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Dar Petru a zis: “Anania, de ce ți-a umplut Satana inima ca să minți pe Duhul Sfânt și să reții o parte din prețul pământului? ");
INSERT INTO ronlsb_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Cât timp l-ai păstrat, nu a rămas oare al tău? După ce a fost vândut, nu a fost în puterea ta? Cum se face că ai conceput acest lucru în inima ta? Nu i-ai mințit pe oameni, ci pe Dumnezeu.” ");
INSERT INTO ronlsb_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Anania, auzind aceste cuvinte, a căzut jos și a murit. O mare frică a cuprins pe toți cei care au auzit aceste lucruri. ");
INSERT INTO ronlsb_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Tinerii s-au sculat, l-au înfășurat, l-au dus afară și l-au îngropat. ");
INSERT INTO ronlsb_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","După vreo trei ore, soția lui, care nu știa ce se întâmplase, a intrat. ");
INSERT INTO ronlsb_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petru i-a răspuns: “Spune-mi dacă ai vândut pământul cu atât de mult.” Ea a spus: “Da, pentru atât de mult”. ");
INSERT INTO ronlsb_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Dar Petru a întrebat-o: “Cum de v-ați învoit împreună să ispitiți Duhul Domnului? Iată, picioarele celor care l-au îngropat pe soțul tău sunt la ușă și te vor scoate afară”. ");
INSERT INTO ronlsb_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ea a căzut îndată la picioarele lui și a murit. Tinerii au intrat și au găsit-o moartă; au dus-o afară și au îngropat-o lângă soțul ei. ");
INSERT INTO ronlsb_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","O mare frică a cuprins toată adunarea și pe toți cei care au auzit aceste lucruri. ");
INSERT INTO ronlsb_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Prin mâinile apostolilor se făceau multe semne și minuni în popor. Toți erau de acord în pridvorul lui Solomon. ");
INSERT INTO ronlsb_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Nici unul dintre ceilalți nu îndrăznea să li se alăture; totuși, poporul îi cinstea. ");
INSERT INTO ronlsb_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Tot mai mulți credincioși s-au adăugat la Domnul, mulțimi de bărbați și de femei. ");
INSERT INTO ronlsb_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Chiar și pe bolnavi îi scoteau în stradă și îi așezau pe paturi și pe saltele, pentru ca, atunci când Petru trecea, măcar umbra lui să-i umbrească pe unii dintre ei. ");
INSERT INTO ronlsb_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","De asemenea, s-a adunat o mulțime din cetățile din jurul Ierusalimului, aducând bolnavi și pe cei chinuiți de duhuri necurate; și toți au fost vindecați. ");
INSERT INTO ronlsb_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Dar marele preot și toți cei ce erau cu el, adică secta saducheilor, s-au sculat în picioare și s-au umplut de gelozie ");
INSERT INTO ronlsb_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","și au pus mâna pe apostoli, apoi i-au pus în temniță publică. ");
INSERT INTO ronlsb_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Dar un înger al Domnului a deschis noaptea ușile închisorii, i-a scos afară și le-a spus: ");
INSERT INTO ronlsb_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Mergeți și stați în picioare și vorbiți poporului în templu toate cuvintele acestei vieți”. ");
INSERT INTO ronlsb_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","După ce au auzit acestea, au intrat în Templu în zori de ziuă și învățau. Dar marele preot și cei care erau cu el au venit și au convocat consiliul, împreună cu tot senatul copiilor lui Israel, și au trimis la închisoare ca să fie aduși. ");
INSERT INTO ronlsb_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Dar ofițerii care au venit nu i-au găsit în închisoare. S-au întors și au raportat: ");
INSERT INTO ronlsb_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Am găsit închisoarea închisă și încuiată, iar gardienii stăteau în fața ușilor, dar când le-am deschis, nu am găsit pe nimeni înăuntru!” ");
INSERT INTO ronlsb_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Când au auzit cuvintele acestea, marele preot, căpetenia templului și preoții cei mai de seamă au fost foarte nedumeriți de ele și de ceea ce putea să se întâmple. ");
INSERT INTO ronlsb_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Cineva a venit și le-a spus: “Iată că oamenii pe care i-ați pus în închisoare sunt în templu, stând în picioare și învățând poporul.” ");
INSERT INTO ronlsb_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Atunci căpitanul s-a dus cu ofițerii și i-a adus fără violență, căci se temeau că poporul îi va ucide cu pietre. ");
INSERT INTO ronlsb_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","După ce i-au adus, i-au pus în fața consiliului. Marele preot i-a interpelat și le-a zis: ");
INSERT INTO ronlsb_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Nu v-am poruncit noi cu strictețe să nu învățați în acest nume? Iată că ați umplut Ierusalimul cu învățătura voastră și intenționați să aduceți asupra noastră sângele acestui om.” ");
INSERT INTO ronlsb_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Dar Petru și apostolii au răspuns: “Trebuie să ascultăm de Dumnezeu mai mult decât de oameni. ");
INSERT INTO ronlsb_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Dumnezeul părinților noștri a înviat pe Isus, pe care voi L-ați omorât, spânzurându-L pe un lemn. ");
INSERT INTO ronlsb_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Dumnezeu L-a înălțat cu dreapta Sa ca să fie Prinț și Mântuitor, ca să dea pocăință lui Israel și iertare de păcate. ");
INSERT INTO ronlsb_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Noi suntem martorii Lui despre aceste lucruri; la fel și Duhul Sfânt, pe care Dumnezeu l-a dat celor care Îl ascultă.” ");
INSERT INTO ronlsb_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Dar ei, auzind aceasta, au fost înduioșați și au hotărât să-i omoare. ");
INSERT INTO ronlsb_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Dar unul dintre ei s-a ridicat în consiliu, un fariseu numit Gamaliel, învățător al legii, cinstit de tot poporul, și a poruncit să-i scoată pe apostoli pentru puțină vreme. ");
INSERT INTO ronlsb_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","El le-a zis: “Bărbați israeliți, fiți atenți la acești oameni, la ceea ce aveți de gând să faceți. ");
INSERT INTO ronlsb_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Pentru că înainte de aceste zile s-a ridicat Theudas, dându-se drept cineva, căruia i s-au alăturat un număr de oameni, cam patru sute. El a fost ucis; și toți, câți l-au ascultat, s-au risipit și au rămas fără nimic. ");
INSERT INTO ronlsb_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","După acesta, Iuda din Galileea s-a ridicat în zilele înrobirii și a atras după el niște oameni. Și el a pierit și el, și toți, câți îl ascultau, au fost împrăștiați. ");
INSERT INTO ronlsb_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Acum vă spun să vă îndepărtați de acești oameni și să-i lăsați în pace. Căci, dacă acest sfat sau această lucrare este de la oameni, va fi răsturnată. ");
INSERT INTO ronlsb_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Dar dacă este de la Dumnezeu, nu veți putea să o răsturnați și veți fi găsiți chiar că luptați împotriva lui Dumnezeu!” ");
INSERT INTO ronlsb_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ei au fost de acord cu el. Chemându-i pe apostoli, i-au bătut, le-au poruncit să nu mai vorbească în numele lui Isus și i-au lăsat să plece. ");
INSERT INTO ronlsb_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Au plecat deci din fața consiliului, bucurându-se că au fost socotiți vrednici să sufere dezonoare pentru numele lui Isus. ");
INSERT INTO ronlsb_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","În fiecare zi, în templu și în casele lor, nu încetau să învețe și să propovăduiască pe Iisus Hristosul. ");
INSERT INTO ronlsb_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","În zilele acelea, când numărul ucenicilor se înmulțea, s-a ridicat o plângere din partea elinilor împotriva evreilor, pentru că văduvele lor erau neglijate în slujba zilnică. ");
INSERT INTO ronlsb_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Cei doisprezece au convocat mulțimea discipolilor și au spus: “Nu se cuvine ca noi să părăsim cuvântul lui Dumnezeu și să servim la mese. ");
INSERT INTO ronlsb_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","De aceea, fraților, alegeți dintre voi șapte bărbați de bună reputație, plini de Duhul Sfânt și de înțelepciune, pe care să îi numim în fruntea acestei afaceri. ");
INSERT INTO ronlsb_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Dar noi vom continua cu stăruință în rugăciune și în slujirea cuvântului.” ");
INSERT INTO ronlsb_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Aceste cuvinte au plăcut întregii mulțimi. Ei au ales pe Ștefan, un om plin de credință și de Duhul Sfânt, pe Filip, Prohor, Nicanor, Timon, Parmenas și Nicolae, un prozelit din Antiohia, ");
INSERT INTO ronlsb_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","pe care i-au pus înaintea apostolilor. După ce s-au rugat, aceștia și-au pus mâinile peste ei. ");
INSERT INTO ronlsb_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Cuvântul lui Dumnezeu creștea și numărul ucenicilor se înmulțea foarte mult în Ierusalim. O mare mulțime de preoți se supuneau credinței. ");
INSERT INTO ronlsb_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ștefan, plin de credință și de putere, făcea minuni și semne mari în popor. ");
INSERT INTO ronlsb_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Dar unii dintre cei din sinagoga numită “Libertinii”, dintre cireni, dintre alexandrini și dintre cei din Cilicia și din Asia s-au sculat, certându-se cu Ștefan. ");
INSERT INTO ronlsb_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ei nu au putut să reziste înțelepciunii și Duhului prin care vorbea el. ");
INSERT INTO ronlsb_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Atunci au determinat pe ascuns pe oameni să spună: “L-am auzit spunând cuvinte blasfemiatoare împotriva lui Moise și a lui Dumnezeu”. ");
INSERT INTO ronlsb_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Au stârnit poporul, bătrânii și cărturarii, au venit împotriva lui și l-au prins, apoi l-au adus în consiliu, ");
INSERT INTO ronlsb_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","și au pus martori falși care spuneau: “Omul acesta nu încetează să rostească cuvinte blasfemiatoare împotriva acestui loc sfânt și a Legii. ");
INSERT INTO ronlsb_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Căci l-am auzit spunând că acest Isus din Nazaret va distruge acest loc și va schimba obiceiurile pe care ni le-a dat Moise.” ");
INSERT INTO ronlsb_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Toți cei care stăteau în consiliu, fixându-și ochii asupra lui, i-au văzut fața ca pe cea a unui înger. ");
INSERT INTO ronlsb_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Marele preot a zis: “Așa stau lucrurile?” ");
INSERT INTO ronlsb_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","El a zis: “Frați și părinți, ascultați. Dumnezeul slavei s-a arătat tatălui nostru Avraam, pe când era în Mesopotamia, înainte de a locui în Haran, ");
INSERT INTO ronlsb_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","și i-a spus: “Ieși din țara ta și de lângă rudele tale și vino într-o țară pe care ți-o voi arăta. ");
INSERT INTO ronlsb_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Atunci a ieșit din țara caldeenilor și a locuit în Haran. De acolo, după ce tatăl său a murit, Dumnezeu l-a mutat în acest pământ în care locuiți acum. ");
INSERT INTO ronlsb_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Nu i-a dat nicio moștenire în ea, nu, nici măcar ca să pună piciorul pe ea. I-a promis că i-o va da ca moștenire și urmașilor lui după el, când el nu avea încă niciun copil. ");
INSERT INTO ronlsb_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Dumnezeu a vorbit astfel: că urmașii lui vor trăi ca niște străini într-o țară străină și că vor fi înrobiți și maltratați timp de patru sute de ani. ");
INSERT INTO ronlsb_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","“Voi judeca națiunea la care vor fi în robie”, a spus Dumnezeu, “și după aceea vor ieși și îmi vor sluji în acest loc. ");
INSERT INTO ronlsb_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Și i-a dat legământul circumciziei. Astfel, Avraam a devenit tatăl lui Isaac și l-a circumcis în ziua a opta. Isaac a devenit tatăl lui Iacob, iar Iacob a devenit tatăl celor doisprezece patriarhi. ");
INSERT INTO ronlsb_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Patriarhii au fost geloși pe Iosif și l-au vândut în Egipt. Dumnezeu a fost cu el ");
INSERT INTO ronlsb_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","și l-a izbăvit din toate necazurile sale și i-a dat favoare și înțelepciune înaintea lui Faraon, regele Egiptului. L-a pus guvernator peste Egipt și peste toată casa lui. ");
INSERT INTO ronlsb_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Și a venit o foamete peste toată țara Egiptului și Canaanului și o mare nenorocire. Părinții noștri nu au găsit hrană. ");
INSERT INTO ronlsb_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Dar când a auzit Iacov că în Egipt era grâu, a trimis prima dată pe părinții noștri. ");
INSERT INTO ronlsb_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","A doua oară, Iosif s-a făcut cunoscut fraților săi, iar familia lui Iosif a fost descoperită lui Faraon. ");
INSERT INTO ronlsb_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Iosif a trimis și a chemat pe tatăl său Iacov și pe toate rudele lui, șaptezeci și cinci de suflete. ");
INSERT INTO ronlsb_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Iacov a coborât în Egipt și a murit, el însuși și părinții noștri; ");
INSERT INTO ronlsb_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","au fost aduși înapoi la Sihem și au fost puși în mormântul pe care Avraam îl cumpărase pe un preț în argint de la fiii lui Hamor din Sihem. ");
INSERT INTO ronlsb_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Dar, când s-a apropiat vremea făgăduinței pe care Dumnezeu o făgăduise lui Avraam, poporul a crescut și s-a înmulțit în Egipt, ");
INSERT INTO ronlsb_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","până când s-a ridicat un alt rege, care nu-l cunoștea pe Iosif. ");
INSERT INTO ronlsb_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Acesta a profitat de neamul nostru și i-a maltratat pe părinții noștri, obligându-i să își abandoneze copiii, ca să nu rămână în viață. ");
INSERT INTO ronlsb_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","În acel timp s-a născut Moise, care era extrem de frumos pentru Dumnezeu. El a fost hrănit trei luni în casa tatălui său. ");
INSERT INTO ronlsb_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","După ce a fost abandonat, fiica lui Faraon l-a luat în brațe și l-a crescut ca pe propriul ei fiu. ");
INSERT INTO ronlsb_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Moise a fost instruit în toată înțelepciunea egiptenilor. A fost puternic în cuvintele și în faptele sale. ");
INSERT INTO ronlsb_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Dar când a împlinit patruzeci de ani, i-a venit în inimă să viziteze pe frații săi, copiii lui Israel. ");
INSERT INTO ronlsb_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Văzând că unul dintre ei suferă nedreptate, l-a apărat și l-a răzbunat pe cel asuprit, lovindu-l pe egiptean. ");
INSERT INTO ronlsb_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","El presupunea că frații săi au înțeles că Dumnezeu, prin mâna lui, le dădea izbăvirea; dar ei nu au înțeles. ");
INSERT INTO ronlsb_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","A doua zi, când se luptau, li s-a arătat și i-a îndemnat să se împace din nou, zicând: “Domnilor, voi sunteți frați. De ce vă faceți rău unul altuia?” ");
INSERT INTO ronlsb_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Dar cel care îi făcea rău aproapelui său îl respingea, spunând: “Cine te-a pus conducător și judecător peste noi? ");
INSERT INTO ronlsb_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Vrei să mă omori pe mine, cum ai omorât ieri pe egiptean?” ");
INSERT INTO ronlsb_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","La acest cuvânt, Moise a fugit și a devenit străin în țara lui Madian, unde a devenit tatăl a doi fii. ");
INSERT INTO ronlsb_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“După ce s-au împlinit patruzeci de ani, un înger al Domnului i s-a arătat în pustiul muntelui Sinai, într-o flacără de foc, într-un tufiș. ");
INSERT INTO ronlsb_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Când a văzut-o, Moise s-a mirat de această priveliște. Pe când se apropia să vadă, vocea Domnului i s-a adresat: ");
INSERT INTO ronlsb_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Eu sunt Dumnezeul părinților tăi: Dumnezeul lui Avraam, Dumnezeul lui Isaac și Dumnezeul lui Iacov. Moise a tremurat și nu a îndrăznit să privească. ");
INSERT INTO ronlsb_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Domnul i-a zis: “Scoate-ți sandalele, căci locul unde stai este pământ sfânt. ");
INSERT INTO ronlsb_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Am văzut cu adevărat necazul poporului Meu care este în Egipt și i-am auzit gemetele. M-am coborât să-i eliberez. Acum vino, te voi trimite în Egipt”. ");
INSERT INTO ronlsb_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Acest Moise, pe care ei l-au refuzat, zicând: “Cine te-a făcut pe tine conducător și judecător?” Dumnezeu l-a trimis ca conducător și eliberator prin mâna îngerului care i s-a arătat în tufiș. ");
INSERT INTO ronlsb_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Acest om i-a condus, după ce a făcut minuni și semne în Egipt, în Marea Roșie și în pustiu timp de patruzeci de ani. ");
INSERT INTO ronlsb_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Acesta este acel Moise care le-a spus copiilor lui Israel: “Domnul Dumnezeul nostru vă va ridica un profet dintre frații voștri, ca mine”. ");
INSERT INTO ronlsb_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Acesta este cel care a fost în adunare în pustiu cu îngerul care i-a vorbit pe muntele Sinai și cu părinții noștri, care a primit revelații vii pe care să ni le dea nouă, ");
INSERT INTO ronlsb_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","căruia părinții noștri nu au vrut să fie ascultători, ci l-au respins și s-au întors cu inima în Egipt, ");
INSERT INTO ronlsb_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","spunând lui Aaron: 'Fă-ne dumnezei care să meargă înaintea noastră, căci în ceea ce-l privește pe acest Moise care ne-a scos din țara Egiptului, nu știm ce s-a întâmplat cu el'. ");
INSERT INTO ronlsb_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","În zilele acelea au făcut un vițel, au adus jertfe idolului și s-au bucurat de lucrările mâinilor lor. ");
INSERT INTO ronlsb_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Dar Dumnezeu s-a întors de la ei și i-a predat să slujească armatei cerului, după cum este scris în cartea profeților, “Mi-ai oferit animale ucise și sacrificii? Patruzeci de ani în pustie, casă a lui Israel? ");
INSERT INTO ronlsb_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Tu ai ridicat cortul lui Moloh, steaua zeului tău, Rephan, figurile pe care le-ai făcut să se închine, așa că te voi duce dincolo de Babilon. ");
INSERT INTO ronlsb_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Părinții noștri au avut cortul mărturiei în pustie, așa cum îi poruncise Cel ce a vorbit lui Moise să îl facă după modelul pe care îl văzuse; ");
INSERT INTO ronlsb_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","și pe care, la rândul lor, părinții noștri l-au adus cu Iosua, când au intrat în stăpânirea neamurilor pe care Dumnezeu le-a alungat dinaintea părinților noștri până în zilele lui David, ");
INSERT INTO ronlsb_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","care au găsit favoare înaintea lui Dumnezeu și au cerut să găsească o locuință pentru Dumnezeul lui Iacov. ");
INSERT INTO ronlsb_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Dar Solomon i-a zidit o casă. ");
INSERT INTO ronlsb_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Totuși, Cel Preaînalt nu locuiește în temple făcute de mâini, cum spune profetul, ");
INSERT INTO ronlsb_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Cerul este tronul meu, și pământul un scăunel pentru picioarele mele. Ce fel de casă îmi vei construi?”, zice Domnul. “Sau care este locul meu de odihnă? ");
INSERT INTO ronlsb_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Nu cumva mâna mea a făcut toate aceste lucruri? ");
INSERT INTO ronlsb_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Voi, cei cu gâtul împietrit și netăiați împrejur la inimă și la urechi, vă împotriviți mereu Duhului Sfânt! Cum au făcut părinții voștri, așa faceți și voi. ");
INSERT INTO ronlsb_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Pe care dintre profeți nu i-au prigonit părinții voștri? Ei i-au ucis pe cei care au prezis venirea Celui Drept, dintre care voi ați devenit acum trădători și ucigași. ");
INSERT INTO ronlsb_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ați primit Legea așa cum a fost rânduită de îngeri și nu ați respectat-o!” ");
INSERT INTO ronlsb_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Când au auzit acestea, li s-a tăiat inima și au scrâșnit din dinți împotriva Lui. ");
INSERT INTO ronlsb_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Dar el, fiind plin de Duhul Sfânt, a privit cu stăruință spre cer și a văzut gloria lui Dumnezeu și pe Isus stând la dreapta lui Dumnezeu, ");
INSERT INTO ronlsb_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","și a zis: “Iată, văd cerurile deschise și pe Fiul Omului stând la dreapta lui Dumnezeu!” ");
INSERT INTO ronlsb_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Dar ei au strigat cu glas tare și și-au astupat urechile, apoi s-au năpustit la unison asupra lui. ");
INSERT INTO ronlsb_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","L-au aruncat afară din cetate și l-au ucis cu pietre. Martorii și-au așezat hainele la picioarele unui tânăr pe nume Saul. ");
INSERT INTO ronlsb_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","L-au ucis cu pietre pe Ștefan, pe când striga: “Doamne Iisuse, primește duhul meu!” ");
INSERT INTO ronlsb_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","El a îngenuncheat și a strigat cu glas tare: “Doamne, nu le reține acest păcat!” După ce a spus aceasta, a adormit. ");
INSERT INTO ronlsb_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saul consimțea la moartea sa. O mare persecuție s-a ridicat împotriva adunării care era în Ierusalim în acea zi. Toți erau împrăștiați prin regiunile Iudeii și Samariei, cu excepția apostolilor. ");
INSERT INTO ronlsb_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Oameni evlavioși l-au îngropat pe Ștefan și l-au plâns mult. ");
INSERT INTO ronlsb_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Dar Saul a devastat Adunarea, a intrat în fiecare casă și a târât în închisoare atât bărbați cât și femei. ");
INSERT INTO ronlsb_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","De aceea, cei care erau împrăștiați prin împrejurimi mergeau de colo-colo, propovăduind cuvântul. ");
INSERT INTO ronlsb_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip s-a coborât în cetatea Samaria și le-a vestit pe Hristos. ");
INSERT INTO ronlsb_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Mulțimile ascultau cu un singur glas cele spuse de Filip, când auzeau și vedeau semnele pe care le făcea. ");
INSERT INTO ronlsb_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Căci duhuri necurate ieșeau din mulți dintre cei care le aveau. Ieșeau, strigând cu glas tare. Mulți dintre cei care fuseseră paralizați și șchiopi au fost vindecați. ");
INSERT INTO ronlsb_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","A fost o mare bucurie în cetatea aceea. ");
INSERT INTO ronlsb_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Dar era un om, pe nume Simon, care făcea vrăjitorii în cetate și care uimea pe locuitorii Samariei, dându-se drept un mare om. ");
INSERT INTO ronlsb_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Toți ascultau, de la cel mai mic până la cel mai mare, și ziceau: “Acesta este o mare putere a lui Dumnezeu.” ");
INSERT INTO ronlsb_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Îl ascultau pentru că de mult timp îi uimise cu vrăjitoriile sale. ");
INSERT INTO ronlsb_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Dar, când au crezut că Filip propovăduia vestea bună despre Împărăția lui Dumnezeu și despre numele lui Isus Hristos, s-au botezat, atât bărbații, cât și femeile. ");
INSERT INTO ronlsb_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Și Simon însuși a crezut. Fiind botezat, a continuat să meargă cu Filip. Văzând că se întâmplă semne și minuni mari, a rămas uimit. ");
INSERT INTO ronlsb_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Apostolii care erau la Ierusalim, auzind că Samaria a primit cuvântul lui Dumnezeu, au trimis la ei pe Petru și pe Ioan, ");
INSERT INTO ronlsb_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","care, după ce s-au coborât, s-au rugat pentru ei, ca să primească Duhul Sfânt, ");
INSERT INTO ronlsb_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","pentru că încă nu se pogorâse peste niciunul dintre ei. Ei fuseseră doar botezați în numele lui Isus Cristos. ");
INSERT INTO ronlsb_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Atunci și-au pus mâinile peste ei și au primit Duhul Sfânt. ");
INSERT INTO ronlsb_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simon, văzând că Duhul Sfânt se dădea prin punerea mâinilor apostolilor, le-a oferit bani, ");
INSERT INTO ronlsb_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","zicând: “Dați-mi și mie această putere, ca oricine îmi voi pune mâinile să primească Duhul Sfânt”. ");
INSERT INTO ronlsb_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Dar Petru i-a spus: “Să piară argintul tău împreună cu tine, pentru că ai crezut că poți obține darul lui Dumnezeu cu bani! ");
INSERT INTO ronlsb_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Tu nu ai nici parte, nici sorți de izbândă în această chestiune, pentru că inima ta nu este dreaptă înaintea lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Pocăiește-te, așadar, de aceasta, de răutatea ta, și întreabă-l pe Dumnezeu dacă nu cumva gândul inimii tale poate să-ți fie iertat. ");
INSERT INTO ronlsb_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Căci văd că ești în otrava amărăciunii și în robia nelegiuirii.” ");
INSERT INTO ronlsb_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simon a răspuns: “Roagă-te pentru mine Domnului, ca să nu mi se întâmple nimic din cele ce ai spus.” ");
INSERT INTO ronlsb_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","După ce au mărturisit și au rostit cuvântul Domnului, s-au întors la Ierusalim și au propovăduit vestea cea bună în multe sate ale samaritenilor. ");
INSERT INTO ronlsb_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Atunci un înger al Domnului a vorbit lui Filip și i-a zis: “Scoală-te și mergi spre sud, pe drumul care coboară de la Ierusalim la Gaza. Acesta este un deșert”. ");
INSERT INTO ronlsb_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","S-a sculat și s-a dus; și iată că era un bărbat din Etiopia, un eunuc cu mare putere sub Candace, regina etiopienilor, care era stăpână pe toată comoara ei, și care venise la Ierusalim să se închine. ");
INSERT INTO ronlsb_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","El se întorcea, ședea în carul său și citea proorocul Isaia. ");
INSERT INTO ronlsb_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Duhul Sfânt a zis lui Filip: “Apropie-te și ia-te de carul acesta.” ");
INSERT INTO ronlsb_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filip a alergat la el, l-a auzit citind pe Isaia proorocul și i-a zis: “Înțelegi tu ce citești?” ");
INSERT INTO ronlsb_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","El a zis: “Cum aș putea, dacă nu-mi explică cineva?” L-a rugat pe Filip să urce și să stea cu el. ");
INSERT INTO ronlsb_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Și pasajul din Scriptură pe care îl citea el era acesta, “A fost dus ca o oaie la abator. Ca un miel în fața celui ce-l tunde tace, ca să nu deschidă gura. ");
INSERT INTO ronlsb_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","În umilirea Lui, a fost luată judecata Lui. Cine va declara generația Lui? Căci viața lui este luată de pe pământ.” ");
INSERT INTO ronlsb_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Eunucul a răspuns lui Filip: “Despre cine vorbește proorocul acesta? Despre el însuși sau despre altcineva?” ");
INSERT INTO ronlsb_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filip a deschis gura și, pornind de la Scriptura aceasta, i-a propovăduit despre Isus. ");
INSERT INTO ronlsb_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Pe când mergeau pe drum, au ajuns la o apă; și eunucul a zis: “Iată, aici este apă. Ce mă împiedică să fiu botezat?” ");
INSERT INTO ronlsb_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38"," Și a poruncit să se oprească carul și s-au coborât amândoi în apă, atât Filip cât și eunucul, și l-a botezat. ");
INSERT INTO ronlsb_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","După ce au ieșit din apă, Duhul Domnului a răpit pe Filip, și eunucul nu l-a mai văzut, căci a plecat bucuros. ");
INSERT INTO ronlsb_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Dar Filip a fost găsit la Azotus. Trecând pe acolo, a propovăduit Vestea cea Bună în toate orașele, până când a ajuns la Cezareea. ");
INSERT INTO ronlsb_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Dar Saul, care continua să arunce amenințări și să ucidă pe ucenicii Domnului, s-a dus la marele preot ");
INSERT INTO ronlsb_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","și a cerut de la el scrisori către sinagogile din Damasc, ca, dacă va găsi pe vreunul din cei de pe Cale, fie bărbați, fie femei, să îl aducă legat la Ierusalim. ");
INSERT INTO ronlsb_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","În timp ce călătorea, s-a apropiat de Damasc și, deodată, o lumină din cer a strălucit în jurul lui. ");
INSERT INTO ronlsb_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","A căzut la pământ și a auzit un glas care îi spunea: “Saul, Saul, de ce mă prigonești?”. ");
INSERT INTO ronlsb_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","El a zis: “Cine ești Tu, Doamne?” Domnul a spus: “Eu sunt Isus, pe care voi Îl prigoniți. ");
INSERT INTO ronlsb_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Dar, sculându-te, intră în cetate și atunci ți se va spune ce trebuie să faci.” ");
INSERT INTO ronlsb_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Oamenii care călătoreau cu el au rămas muți, auzind zgomotul, dar nu vedeau pe nimeni. ");
INSERT INTO ronlsb_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saul s-a ridicat de la pământ și, când și-a deschis ochii, n-a văzut pe nimeni. L-au luat de mână și l-au dus în Damasc. ");
INSERT INTO ronlsb_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","A stat fără vedere timp de trei zile și nu a mâncat și nu a băut. ");
INSERT INTO ronlsb_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Și era în Damasc un ucenic, numit Anania. Domnul i-a spus într-o viziune: “Anania!” El a spus: “Iată, sunt eu, Doamne”. ");
INSERT INTO ronlsb_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Domnul i-a zis: “Scoală-te și du-te pe strada care se cheamă Drept și caută în casa lui Iuda pe unul numit Saul, un om din Tars. Căci iată că el se roagă ");
INSERT INTO ronlsb_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","și a văzut în viziune pe un om numit Anania intrând și punându-și mâinile peste el, ca să-și recapete vederea.” ");
INSERT INTO ronlsb_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Și Anania a răspuns: “Doamne, am auzit de la mulți despre omul acesta, cât rău a făcut sfinților Tăi din Ierusalim. ");
INSERT INTO ronlsb_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Aici are putere de la preoții cei mai de seamă să lege pe toți cei ce cheamă Numele Tău.” ");
INSERT INTO ronlsb_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Dar Domnul i-a zis: “Du-te, căci el este vasul Meu ales ca să poarte numele Meu înaintea neamurilor, a împăraților și a copiilor lui Israel. ");
INSERT INTO ronlsb_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Căci îi voi arăta câte va trebui să sufere pentru Numele Meu.” ");
INSERT INTO ronlsb_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Anania a plecat și a intrat în casă. Și, punându-și mâinile peste el, i-a zis: “Frate Saul, Domnul, care ți s-a arătat pe drumul pe care ai venit, m-a trimis ca să-ți recapeți vederea și să fii umplut de Duhul Sfânt.” ");
INSERT INTO ronlsb_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Imediat, ceva ca niște solzi au căzut de pe ochii lui și și-a recăpătat vederea. S-a sculat și a fost botezat. ");
INSERT INTO ronlsb_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","A luat mâncare și s-a întărit. Saul a stat câteva zile cu ucenicii care se aflau la Damasc. ");
INSERT INTO ronlsb_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Îndată, în sinagogi, a propovăduit pe Hristos, că El este Fiul lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Toți cei care îl auzeau erau uimiți și ziceau: “Nu cumva acesta este cel care, la Ierusalim, a făcut ravagii printre cei care invocau acest nume? Și venise aici cu intenția de a-i aduce legați în fața preoților de seamă!”. ");
INSERT INTO ronlsb_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Dar Saul, care se întărea și mai mult, a zăpăcit pe iudeii care locuiau în Damasc și a dovedit că acesta este Hristosul. ");
INSERT INTO ronlsb_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","După ce s-au împlinit multe zile, iudeii au uneltit împreună ca să-l ucidă, ");
INSERT INTO ronlsb_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","dar complotul lor a fost cunoscut de Saul. Ei pândeau porțile zi și noapte ca să-l ucidă, ");
INSERT INTO ronlsb_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","dar discipolii lui l-au luat noaptea și l-au coborât prin zid, coborându-l într-un coș. ");
INSERT INTO ronlsb_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","După ce a ajuns la Ierusalim, Saul a încercat să se alăture ucenicilor, dar toți se temeau de el, nevenindu-le să creadă că este ucenic. ");
INSERT INTO ronlsb_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Dar Barnaba l-a luat și l-a dus la apostoli și le-a povestit cum Îl văzuse pe Domnul pe drum, cum îi vorbise și cum la Damasc predicase cu îndrăzneală în numele lui Isus. ");
INSERT INTO ronlsb_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","A intrat cu ei în Ierusalim, ");
INSERT INTO ronlsb_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","și propovăduia cu îndrăzneală în Numele Domnului Isus. El vorbea și se certa cu elenii, dar aceștia căutau să-l ucidă. ");
INSERT INTO ronlsb_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Când au aflat frații, l-au coborât în Cezareea și l-au trimis la Tars. ");
INSERT INTO ronlsb_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Și adunările din toată Iudeea, din Galileea și din Samaria au avut pace și s-au întărit. Ele s-au înmulțit, umblând în frica Domnului și în mângâierea Duhului Sfânt. ");
INSERT INTO ronlsb_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petru a străbătut toate părțile acelea, și s-a pogorât și la sfinții care locuiau în Lida. ");
INSERT INTO ronlsb_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Acolo a găsit un om numit Enea, care era țintuit la pat de opt ani, pentru că era paralizat. ");
INSERT INTO ronlsb_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petru i-a zis: “Enea, Isus Hristos te vindecă. Ridică-te și fă-ți patul!” Imediat, el s-a sculat. ");
INSERT INTO ronlsb_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Toți cei care locuiau la Lida și în Saron l-au văzut și s-au întors la Domnul. ");
INSERT INTO ronlsb_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","În Iope era la Iope o ucenică cu numele Tabita, care în traducere înseamnă Dorcas. Această femeie era plină de fapte bune și de acte de milostenie pe care le făcea. ");
INSERT INTO ronlsb_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","În zilele acelea, ea s-a îmbolnăvit și a murit. După ce au spălat-o, au așezat-o într-o cameră de sus. ");
INSERT INTO ronlsb_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Cum Lida era aproape de Iope, ucenicii, auzind că Petru era acolo, au trimis doi bărbați la el, rugându-l să nu întârzie să vină la ei. ");
INSERT INTO ronlsb_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Petru s-a ridicat și a plecat cu ei. După ce a venit, l-au dus în camera de sus. Toate văduvele stăteau lângă el, plângând și arătând tunicile și celelalte haine pe care Dorcas le făcuse cât timp fusese cu ele. ");
INSERT INTO ronlsb_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petru le-a trimis pe toate afară, a îngenuncheat și s-a rugat. Întorcându-se spre trup, a zis: “Tabita, ridică-te!”. Ea a deschis ochii și, când l-a văzut pe Petru, s-a așezat în picioare. ");
INSERT INTO ronlsb_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","El i-a dat mâna și a ridicat-o în picioare. Chemând sfinții și văduvele, a prezentat-o în viață. ");
INSERT INTO ronlsb_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Acest lucru s-a aflat în toată Ioppa și mulți au crezut în Domnul. ");
INSERT INTO ronlsb_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","A stat multe zile în Iope la un tăbăcar cu numele Simon. ");
INSERT INTO ronlsb_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","În Cezareea era un om, Corneliu, centurion în ceea ce se numea regimentul italian, ");
INSERT INTO ronlsb_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","un om evlavios și temător de Dumnezeu în toată casa lui, care dădea cu generozitate poporului daruri pentru cei nevoiași și se ruga mereu lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Pe la ora nouă a zilei, a văzut clar într-o viziune un înger al lui Dumnezeu care a venit la el și i-a spus: “Corneliu!”. ");
INSERT INTO ronlsb_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","El, care, fixându-și ochii asupra Lui și înfricoșându-se, a zis: “Ce este, Doamne?” El i-a spus: “Rugăciunile tale și darurile tale pentru cei nevoiași s-au înălțat ca o amintire înaintea lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Trimite acum oameni la Iope și adu-l pe Simon, care se mai numește și Petru. ");
INSERT INTO ronlsb_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","El locuiește la un tăbăcar pe nume Simon, a cărui casă se află pe malul mării. ");
INSERT INTO ronlsb_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","După ce a plecat îngerul care-i vorbise, Corneliu a chemat doi dintre slujitorii săi de casă și un ostaș credincios dintre cei care-l îngrijeau în permanență. ");
INSERT INTO ronlsb_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","După ce le-a explicat totul, i-a trimis la Iope. ");
INSERT INTO ronlsb_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","A doua zi, când au pornit în călătorie și s-au apropiat de cetate, Petru s-a suit pe acoperișul casei să se roage, pe la amiază. ");
INSERT INTO ronlsb_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","I s-a făcut foame și a vrut să mănânce, dar, în timp ce ei se pregăteau, a căzut în transă. ");
INSERT INTO ronlsb_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","A văzut cerul deschis și un anumit recipient care se cobora la el, ca un cearșaf mare lăsat de patru colțuri pe pământ, ");
INSERT INTO ronlsb_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","în care se aflau tot felul de animale cu patru picioare de pe pământ, animale sălbatice, reptile și păsări ale cerului. ");
INSERT INTO ronlsb_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Un glas a venit la el: “Scoală-te, Petru, ucide și mănâncă!” ");
INSERT INTO ronlsb_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Dar Petru a zis: “Nu, Doamne, căci eu n-am mâncat niciodată nimic din ce este de rând sau necurat.” ");
INSERT INTO ronlsb_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Și a doua oară, un glas a venit din nou la el: “Ceea ce a curățat Dumnezeu, să nu numești necurat.” ");
INSERT INTO ronlsb_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","A făcut aceasta de trei ori și îndată lucrul acesta a fost primit în cer. ");
INSERT INTO ronlsb_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Și pe când Petru era foarte nedumerit în sinea lui cu privire la semnificația viziunii pe care o avusese, iată că oamenii trimiși de Corneliu, după ce au întrebat de casa lui Simon, au stat în fața porții ");
INSERT INTO ronlsb_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","și au strigat și au întrebat dacă Simon, care se mai numea și Petru, era găzduit acolo. ");
INSERT INTO ronlsb_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","În timp ce Petru reflecta asupra viziunii, Duhul i-a spus: “Iată, trei bărbați te caută. ");
INSERT INTO ronlsb_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Dar ridică-te, coboară-te și mergi cu ei, fără să te îndoiești de nimic, pentru că Eu i-am trimis”. ");
INSERT INTO ronlsb_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Petru s-a coborât la oamenii aceia și le-a zis: “Iată, eu sunt cel pe care-l căutați. De ce ați venit?” ");
INSERT INTO ronlsb_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ei au zis: “Corneliu, centurionul, un om drept și temător de Dumnezeu, bine pomenit de tot neamul iudeilor, a fost îndemnat de un înger sfânt să vă cheme în casa lui și să asculte ce veți spune.” ");
INSERT INTO ronlsb_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Așa că i-a chemat și le-a pus la dispoziție un loc de cazare. A doua zi, Petru s-a sculat și a ieșit cu ei; și câțiva dintre frații din Iope l-au însoțit. ");
INSERT INTO ronlsb_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","A doua zi, au intrat în Cezareea. Corneliu îi aștepta, după ce-și adunase rudele și apropiații. ");
INSERT INTO ronlsb_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Când a intrat Petru, Corneliu l-a întâmpinat, a căzut la picioarele lui și i s-a închinat. ");
INSERT INTO ronlsb_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Dar Petru l-a ridicat și i-a zis: “Ridică-te! Și eu însumi sunt un om”. ");
INSERT INTO ronlsb_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","În timp ce vorbea cu el, a intrat și a găsit pe mulți adunați. ");
INSERT INTO ronlsb_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","El le-a zis: “Voi înșivă știți cum este un lucru nelegiuit ca un iudeu să se unească sau să vină la unul de alt neam, dar Dumnezeu mi-a arătat că nu trebuie să numesc pe nimeni profan sau necurat. ");
INSERT INTO ronlsb_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","De aceea am venit și eu fără să mă plâng când am fost chemat. De aceea întreb: “De ce ați trimis după mine?”. ");
INSERT INTO ronlsb_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Corneliu a zis: “Acum patru zile am postit până la ceasul acesta; și la ceasul al nouălea, m-am rugat în casa mea și iată că un om îmbrăcat în haine strălucitoare ");
INSERT INTO ronlsb_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","a stat înaintea mea și a zis: “Corneliu, rugăciunea ta a fost ascultată și darurile tale pentru cei nevoiași au fost luate în seamă înaintea lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Trimite deci la Iope și cheamă-l pe Simon, care se mai numește și Petru. El locuiește în casa unui tăbăcar numit Simon, pe malul mării. Când va veni, va vorbi cu voi”. ");
INSERT INTO ronlsb_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","De aceea am trimis îndată la tine și a fost bine că ai venit. De aceea, acum suntem cu toții prezenți aici, în fața lui Dumnezeu, ca să auzim tot ce ți-a poruncit Dumnezeu.” ");
INSERT INTO ronlsb_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Petru a deschis gura și a zis: “Cu adevărat, am văzut că Dumnezeu nu face favoruri, ");
INSERT INTO ronlsb_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ci, în orice neam, cel ce se teme de El și face dreptate este plăcut Lui. ");
INSERT INTO ronlsb_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Cuvântul pe care l-a trimis copiilor lui Israel, propovăduind vestea bună a păcii prin Isus Cristos — el este Domnul tuturor— ");
INSERT INTO ronlsb_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","voi înșivă știți ce s-a întâmplat, care a fost vestit în toată Iudeea, începând din Galileea, după botezul pe care l-a predicat Ioan; ");
INSERT INTO ronlsb_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","cum Dumnezeu l-a uns cu Duh Sfânt și cu putere pe Isus din Nazaret, care umbla făcând bine și vindecând pe toți cei asupriți de diavol, pentru că Dumnezeu era cu el. ");
INSERT INTO ronlsb_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Noi suntem martori la tot ce a făcut El, atât în țara iudeilor, cât și în Ierusalim, pe care l-au și ucis, spânzurându-l pe un lemn. ");
INSERT INTO ronlsb_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Dumnezeu l-a înviat a treia zi și l-a dat să se arate, ");
INSERT INTO ronlsb_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","nu întregului popor, ci martorilor care au fost aleși mai dinainte de Dumnezeu, nouă, care am mâncat și am băut cu el după ce a înviat din morți. ");
INSERT INTO ronlsb_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ne-a poruncit să propovăduim poporului și să mărturisim că Acesta este Cel desemnat de Dumnezeu ca Judecător al celor vii și al celor morți. ");
INSERT INTO ronlsb_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Toți profeții mărturisesc despre el că, prin numele lui, oricine crede în el va primi iertarea păcatelor.” ");
INSERT INTO ronlsb_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pe când Petru rostea încă aceste cuvinte, Duhul Sfânt a căzut peste toți cei ce auzeau cuvântul. ");
INSERT INTO ronlsb_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Cei din circumcizie care au crezut erau uimiți, toți cei care veniseră cu Petru, pentru că darul Duhului Sfânt se revărsase și peste neamuri. ");
INSERT INTO ronlsb_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Căci îi auzeau vorbind în alte limbi și lăudând pe Dumnezeu. Atunci Petru a răspuns: ");
INSERT INTO ronlsb_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Poate cineva să interzică acestor oameni să fie botezați cu apă? Ei au primit Duhul Sfânt la fel ca și noi”. ");
INSERT INTO ronlsb_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Și le-a poruncit să fie botezați în numele lui Isus Hristos. Apoi l-au rugat să rămână câteva zile. ");
INSERT INTO ronlsb_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Apostolii și frații care erau în Iudeea au auzit că și neamurile au primit cuvântul lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","După ce Petru s-a suit la Ierusalim, cei care erau din circumcizie s-au certat cu el, ");
INSERT INTO ronlsb_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","spunând: “Ai intrat la oameni netăiați împrejur și ai mâncat cu ei!”. ");
INSERT INTO ronlsb_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Dar Petru a început și le-a explicat în ordine, zicând: ");
INSERT INTO ronlsb_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Eram în cetatea Iope, rugându-mă, și am avut o vedenie: un vas care se cobora ca un cearșaf mare, care se lăsa din cer prin patru colțuri. A ajuns până la mine. ");
INSERT INTO ronlsb_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","După ce m-am uitat cu atenție la el, m-am gândit și am văzut animalele cu patru picioare de pe pământ, animalele sălbatice, târâtoarele și păsările cerului. ");
INSERT INTO ronlsb_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Am auzit de asemenea un glas care îmi spunea: “Scoală-te, Petru, ucide și mănâncă!” ");
INSERT INTO ronlsb_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Dar eu am zis: “Nu așa, Doamne, căci în gura mea nu a intrat niciodată nimic nesfânt sau necurat. ");
INSERT INTO ronlsb_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Dar un glas mi-a răspuns a doua oară din cer: “Ceea ce Dumnezeu a curățat, tu să nu numești necurat”. ");
INSERT INTO ronlsb_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Aceasta s-a făcut de trei ori și toți au fost trași din nou în cer. ");
INSERT INTO ronlsb_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Iată că imediat au stat în fața casei în care mă aflam trei bărbați, trimiși de la Cezareea la mine. ");
INSERT INTO ronlsb_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Duhul mi-a spus să merg cu ei fără să fac deosebire. M-au însoțit și acești șase frați și am intrat în casa acelui om. ");
INSERT INTO ronlsb_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","El ne-a povestit cum îl văzuse pe înger stând în casa lui și spunându-i: “Trimite la Iope și adu-l pe Simon, care se numește Petru, ");
INSERT INTO ronlsb_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","care îți va spune cuvintele prin care vei fi mântuit, tu și toată casa ta. ");
INSERT INTO ronlsb_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Când am început să vorbesc, Duhul Sfânt a căzut peste ei, ca și peste noi la început. ");
INSERT INTO ronlsb_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Mi-am adus aminte de cuvântul Domnului, cum a spus: 'Ioan a botezat într-adevăr în apă, dar voi veți fi botezați în Duhul Sfânt'. ");
INSERT INTO ronlsb_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Dacă deci Dumnezeu le-a dat același dar ca și nouă, când am crezut în Domnul Isus Hristos, cine eram eu, ca să mă împotrivesc lui Dumnezeu?” ");
INSERT INTO ronlsb_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Când au auzit acestea, au tăcut și au slăvit pe Dumnezeu, zicând: “Dumnezeu a dat și neamurilor pocăința pentru viață!” ");
INSERT INTO ronlsb_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","De aceea, cei ce se împrăștiaseră din pricina asupririi lui Ștefan au călătorit până în Fenicia, în Cipru și în Antiohia, și nu au vorbit nimănui decât numai iudeilor. ");
INSERT INTO ronlsb_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Dar au fost unii dintre ei, bărbați din Cipru și din Cirene, care, după ce au ajuns în Antiohia, au vorbit elinilor, propovăduind pe Domnul Isus. ");
INSERT INTO ronlsb_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Mâna Domnului a fost cu ei și un mare număr a crezut și s-a întors la Domnul. ");
INSERT INTO ronlsb_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Vestea despre ei a ajuns la urechile adunării care era la Ierusalim. Ei l-au trimis pe Barnaba să meargă până la Antiohia, ");
INSERT INTO ronlsb_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","care, după ce a ajuns și a văzut harul lui Dumnezeu, s-a bucurat. El i-a îndemnat pe toți, ca, cu hotărâre de inimă, să rămână aproape de Domnul. ");
INSERT INTO ronlsb_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Căci era un om bun, plin de Duhul Sfânt și de credință, și mulți oameni s-au adăugat la Domnul. ");
INSERT INTO ronlsb_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Barnaba a plecat la Tars, ca să caute pe Saul. ");
INSERT INTO ronlsb_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","După ce l-a găsit, l-a adus la Antiohia. Timp de un an întreg au fost adunați împreună cu adunarea și au învățat mult popor. Discipolii au fost numiți pentru prima dată creștini în Antiohia. ");
INSERT INTO ronlsb_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","În zilele acestea, au coborât prooroci din Ierusalim în Antiohia. ");
INSERT INTO ronlsb_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Unul dintre ei, pe nume Agabus, s-a ridicat în picioare și a arătat prin Duhul Sfânt că va fi o mare foamete în toată lumea, ceea ce s-a întâmplat și în zilele lui Claudius. ");
INSERT INTO ronlsb_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Cum vreunul dintre discipoli avea belșug, fiecare a hotărât să trimită ajutoare fraților care locuiau în Iudeea; ");
INSERT INTO ronlsb_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ceea ce au și făcut, trimițându-le bătrânilor prin mâna lui Barnaba și a lui Saul. ");
INSERT INTO ronlsb_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","În vremea aceea, regele Irod și-a întins mâinile ca să asuprească pe unii din adunare. ");
INSERT INTO ronlsb_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Și a ucis cu sabia pe Iacov, fratele lui Ioan. ");
INSERT INTO ronlsb_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Când a văzut că aceasta a fost pe placul iudeilor, s-a apucat să prindă și pe Petru. Acest lucru se întâmpla în zilele azimilor. ");
INSERT INTO ronlsb_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","După ce l-a arestat, l-a băgat în închisoare și l-a predat la patru escadroane de câte patru soldați fiecare, ca să-l păzească, cu intenția de a-l scoate în fața poporului după Paști. ");
INSERT INTO ronlsb_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Petru era deci ținut în închisoare, dar adunarea se ruga neîncetat lui Dumnezeu pentru el. ");
INSERT INTO ronlsb_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","În noaptea în care Irod era pe cale să-l scoată afară, Petru dormea între doi soldați, legat cu două lanțuri. Gărzile din fața ușii păzeau închisoarea. ");
INSERT INTO ronlsb_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Și iată că un înger al Domnului stătea lângă el, și o lumină strălucea în chilie. L-a lovit pe Petru peste o parte și l-a trezit, spunându-i: “Ridică-te repede!”. Lanțurile i-au căzut de pe mâini. ");
INSERT INTO ronlsb_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Îngerul i-a spus: “Îmbracă-te și pune-ți sandalele”. Așa a făcut el. El i-a spus: “Pune-ți mantia și urmează-mă”. ");
INSERT INTO ronlsb_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Și el a ieșit și l-a urmat. El nu știa că ceea ce făcea îngerul era real, ci credea că a văzut o viziune. ");
INSERT INTO ronlsb_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","După ce au trecut de prima și de a doua gardă, au ajuns la poarta de fier care duce în cetate, care li s-a deschis singură. Au ieșit și au coborât pe o stradă, și imediat îngerul s-a îndepărtat de el. ");
INSERT INTO ronlsb_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","După ce și-a revenit, Petru a zis: “Acum știu cu adevărat că Domnul a trimis pe îngerul Său și m-a izbăvit din mâna lui Irod și de tot ce aștepta poporul iudeu.” ");
INSERT INTO ronlsb_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Gândindu-se la aceasta, a venit la casa Mariei, mama lui Ioan, zis Marcu, unde erau mulți adunați și se rugau. ");
INSERT INTO ronlsb_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Când Petru a bătut la ușa porții, o slujnică pe nume Rodica a venit să răspundă. ");
INSERT INTO ronlsb_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Când a recunoscut vocea lui Petru, nu a deschis poarta de bucurie, ci a alergat înăuntru și a anunțat că Petru stătea în fața porții. ");
INSERT INTO ronlsb_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ei i-au zis: “Ești nebună!” Dar ea insista că așa este. Ei au spus: “Este îngerul lui.” ");
INSERT INTO ronlsb_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Dar Petru a continuat să bată la ușă. După ce au deschis, l-au văzut și au rămas uimiți. ");
INSERT INTO ronlsb_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Dar el, făcându-le semn cu mâna să tacă, le-a povestit cum l-a scos Domnul din închisoare. Și a zis: “Spuneți aceste lucruri lui Iacov și fraților”. Apoi a plecat și s-a dus în alt loc. ");
INSERT INTO ronlsb_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Și cum s-a făcut ziuă, nu mică era agitația printre ostași despre ce se întâmplase cu Petru. ");
INSERT INTO ronlsb_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","După ce Irod l-a căutat și nu l-a găsit, a cercetat gărzile, apoi a poruncit să fie omorât. S-a coborât din Iudeea în Cezareea și a rămas acolo. ");
INSERT INTO ronlsb_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Irod era foarte mânios pe poporul din Tir și din Sidon. Aceștia au venit de comun acord la el și, făcându-l prieten pe Blastus, ajutorul personal al regelui, i-au cerut pace, pentru că țara lor depindea de țara regelui pentru hrană. ");
INSERT INTO ronlsb_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","În ziua stabilită, Irod s-a îmbrăcat în haine regale, s-a așezat pe tron și le-a ținut un discurs. ");
INSERT INTO ronlsb_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Poporul a strigat: “Vocea unui zeu, și nu a unui om!” ");
INSERT INTO ronlsb_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Imediat, un înger al Domnului l-a lovit, pentru că nu i-a dat slavă lui Dumnezeu. Apoi a fost mâncat de viermi și a murit. ");
INSERT INTO ronlsb_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Dar cuvântul lui Dumnezeu creștea și se înmulțea. ");
INSERT INTO ronlsb_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnaba și Saul s-au întors la Ierusalim, după ce și-au împlinit slujba, luând cu ei și pe Ioan, numit Marcu. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","În adunarea care era în Antiohia erau niște prooroci și învățători: Barnaba, Simeon, care se numea Niger, Lucius din Cirene, Manaen, fratele adoptiv al tetrarhului Irod, și Saul. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","În timp ce slujeau Domnului și posteau, Duhul Sfânt a zis: “Separă-i pe Barnaba și pe Saul pentru mine, pentru lucrarea la care i-am chemat”. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Apoi, după ce au postit și s-au rugat și și-au pus mâinile peste ei, i-au trimis. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Astfel, fiind trimiși de Duhul Sfânt, s-au coborât la Seleucia. De acolo au navigat spre Cipru. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Când au ajuns la Salamina, au vestit cuvântul lui Dumnezeu în sinagogile evreiești. L-au avut și pe Ioan ca însoțitor. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","După ce au străbătut insula până la Pafos, au găsit un vrăjitor, un fals profet, un iudeu care se numea Bar Isus, ");
INSERT INTO ronlsb_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","care se afla cu proconsulul Sergius Paulus, un om înțelegător. Acesta i-a chemat pe Barnaba și pe Saul și a căutat să audă cuvântul lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Dar vrăjitorul Elymas (căci așa se numește el după interpretare) s-a împotrivit lor, căutând să-l întoarcă pe proconsul de la credință. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Dar Saul, care se mai numește și Pavel, plin de Duhul Sfânt, și-a fixat ochii asupra lui ");
INSERT INTO ronlsb_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","și a zis: “Fiu al diavolului, plin de toată înșelăciunea și de toată viclenia, vrăjmaș al oricărei dreptăți, nu vei înceta să pervertești căile drepte ale Domnului? ");
INSERT INTO ronlsb_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Acum, iată, mâna Domnului este asupra ta și vei fi orb, fără să vezi soarele pentru o vreme!” Imediat, o ceață și întunericul au căzut peste el. A umblat de colo-colo căutând pe cineva care să-l ducă de mână. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Atunci proconsulul, când a văzut ce se întâmplase, a crezut, fiind uimit de învățătura Domnului. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pavel și ceata lui au pornit din Pafos și au ajuns la Perga, în Pamfilia. Ioan s-a despărțit de ei și s-a întors la Ierusalim. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Dar ei, trecând de la Perga, au ajuns la Antiohia Pisidiei. Au intrat în sinagogă în ziua de Sabat și au șezut jos. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","După citirea Legii și a profeților, conducătorii sinagogii au trimis la ei, spunându-le: “Fraților, dacă aveți vreun cuvânt de îndemn pentru popor, vorbiți.” ");
INSERT INTO ronlsb_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pavel s-a ridicat în picioare și, făcând semn cu mâna, a zis: “Bărbați israeliți și voi, cei ce vă temeți de Dumnezeu, ascultați. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Dumnezeul acestui popor i-a ales pe părinții noștri și a înălțat poporul când a rămas ca străin în țara Egiptului și, cu brațul ridicat, l-a scos din ea. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Pe o perioadă de aproximativ patruzeci de ani i-a suportat în pustiu. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","După ce a distrus șapte națiuni în țara Canaanului, le-a dat țara lor ca moștenire timp de aproximativ patru sute cincizeci de ani. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","După aceste lucruri, le-a dat judecători până la profetul Samuel. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","După aceea au cerut un rege, și Dumnezeu le-a dat pe Saul, fiul lui Chiș, un bărbat din tribul lui Beniamin, timp de patruzeci de ani. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","După ce l-a înlăturat, l-a ridicat ca rege al lor pe David, căruia i-a și mărturisit: “Am găsit pe David, fiul lui Isai, un om după inima mea, care va face toată voia mea. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Din urmașul acestui om, Dumnezeu a adus mântuirea lui Israel, conform promisiunii sale, ");
INSERT INTO ronlsb_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","înainte de venirea sa, când Ioan a predicat pentru prima dată lui Israel botezul pocăinței. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Pe când Ioan își împlinea cursul, a zis: “Ce credeți că sunt eu? Eu nu sunt el. Dar iată că vine după mine unul, ale cărui sandale nu sunt vrednic să le dezleg'. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Fraților, copii din neamul lui Avraam, și cei din voi care vă temeți de Dumnezeu, cuvântul acestei mântuiri a fost trimis la voi. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Căci cei care locuiesc în Ierusalim și conducătorii lor, pentru că nu l-au cunoscut, nici glasurile profeților care se citesc în fiecare Sabat, le-au împlinit condamnându-l. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Deși nu au găsit nici un motiv de moarte, i-au cerut totuși lui Pilat să-L omoare. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","După ce au împlinit tot ce era scris despre el, l-au dat jos de pe lemn și l-au pus într-un mormânt. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Dar Dumnezeu l-a înviat din morți, ");
INSERT INTO ronlsb_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","și a fost văzut timp de multe zile de cei care au urcat cu el din Galileea la Ierusalim, care sunt martorii lui în fața poporului. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Noi vă aducem vestea cea bună a promisiunii făcute părinților, ");
INSERT INTO ronlsb_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","că Dumnezeu a împlinit-o pentru noi, copiii lor, prin faptul că l-a înviat pe Isus. După cum este scris și în al doilea psalm, “Tu ești Fiul meu. Astăzi am devenit tatăl tău”. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“Despre faptul că l-a înviat din morți, ca să nu se mai întoarcă la stricăciune, așa a vorbit: 'Vă voi da binecuvântările sfinte și sigure ale lui David'. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","De aceea spune și într-un alt psalm: “Nu vei îngădui ca Sfântul Tău să vadă putrezirea”. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Căci David, după ce a slujit în neamul său sfatul lui Dumnezeu, a adormit, a fost culcat cu părinții săi și a văzut putrezirea. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Dar cel pe care l-a înviat Dumnezeu nu a văzut putrezirea. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Să știți, deci, fraților, că prin acest om vi se vestește iertarea păcatelor; ");
INSERT INTO ronlsb_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","și prin el oricine crede este îndreptățit de toate lucrurile de care nu ați putut fi îndreptățiți prin Legea lui Moise. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Feriți-vă, deci, ca să nu vină peste voi ceea ce s-a spus în profeți: ");
INSERT INTO ronlsb_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“Iată, batjocoritorilor! Minunează-te și pieri, Căci Eu fac o lucrare în zilele voastre, o lucrare pe care nu o veți crede în nici un fel, dacă cineva v-o declară.”” ");
INSERT INTO ronlsb_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Iudeii au ieșit din sinagogă, și neamurile au cerut să li se vestească aceste cuvinte în Sabatul următor. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","După ce s-a despărțit sinagoga, mulți dintre iudei și dintre prozeliții evlavioși au urmat pe Pavel și pe Barnaba, care, vorbindu-le, îi îndemnau să continue în harul lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","În sâmbăta următoare, aproape toată cetatea s-a adunat să asculte cuvântul lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Dar iudeii, văzând mulțimea, s-au umplut de gelozie, au contrazis cele spuse de Pavel și au hulit. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pavel și Barnaba au luat cuvântul cu îndrăzneală și au zis: “Trebuia să vă fie vestit mai întâi cuvântul lui Dumnezeu. Întrucât, într-adevăr, îl respingeți de la voi înșivă și vă judecați nevrednici de viața veșnică, iată că ne întoarcem la neamuri. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Căci așa ne-a poruncit Domnul, zicând:, “Te-am pus ca lumină pentru neamuri, ca să aduci mântuirea până la marginile pământului.” ");
INSERT INTO ronlsb_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Neamurile, auzind acestea, s-au bucurat și au slăvit cuvântul lui Dumnezeu. Toți cei care erau rânduiți pentru viața veșnică au crezut. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Cuvântul Domnului s-a răspândit în toată regiunea. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Dar iudeii au stârnit pe femeile evlavioase și de seamă și pe căpeteniile cetății și au stârnit o persecuție împotriva lui Pavel și a lui Barnaba și i-au aruncat afară din hotarele lor. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Dar ei și-au scuturat praful de pe picioare împotriva lor și au venit la Iconia. ");
INSERT INTO ronlsb_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ucenicii au fost plini de bucurie și de Duhul Sfânt. ");
INSERT INTO ronlsb_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","În Iconiu, au intrat împreună în sinagoga iudeilor și au vorbit astfel încât o mare mulțime de iudei și de greci au crezut. ");
INSERT INTO ronlsb_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Dar iudeii necredincioși au stârnit și au învrăjbit sufletele neamurilor împotriva fraților. ");
INSERT INTO ronlsb_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","De aceea au rămas acolo multă vreme, vorbind cu îndrăzneală în Domnul, care dădea mărturie despre cuvântul harului său, îngăduind să se facă semne și minuni prin mâinile lor. ");
INSERT INTO ronlsb_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Dar mulțimea din cetate era împărțită. O parte era de partea iudeilor și o parte de partea apostolilor. ");
INSERT INTO ronlsb_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Când o parte dintre neamuri și iudei, împreună cu conducătorii lor, au încercat cu violență să-i maltrateze și să-i ucidă cu pietre, ");
INSERT INTO ronlsb_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ei au luat cunoștință de aceasta și au fugit în orașele Licaonia, Listra, Derbe și în regiunea înconjurătoare. ");
INSERT INTO ronlsb_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Acolo au propovăduit Vestea cea Bună. ");
INSERT INTO ronlsb_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","La Listra ședea un om neputincios la picioare, olog din pântecele mamei sale, care nu umblase niciodată. ");
INSERT INTO ronlsb_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","El asculta vorbind pe Pavel, care, fixând ochii asupra lui și văzând că are credința de a fi vindecat, ");
INSERT INTO ronlsb_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","a zis cu glas tare: “Ridică-te în picioare!” El a sărit în picioare și a mers. ");
INSERT INTO ronlsb_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Când mulțimea a văzut ce făcuse Pavel, a ridicat glasul și a zis în limba Licaoniei: “Zeii s-au coborât la noi în chip de oameni!” ");
INSERT INTO ronlsb_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ei îl numeau pe Barnaba “Jupiter”, iar pe Pavel “Mercur”, pentru că el era cel care vorbea cel mai mult. ");
INSERT INTO ronlsb_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Preotul lui Jupiter, al cărui templu se afla în fața cetății lor, a adus boi și ghirlande la porți și ar fi vrut să facă un sacrificiu împreună cu mulțimea. ");
INSERT INTO ronlsb_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Apostolii Barnaba și Pavel, auzind, și-au rupt hainele și au sărit în mulțime, strigând: ");
INSERT INTO ronlsb_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Bărbaților, pentru ce faceți aceste lucruri? Și noi suntem oameni de aceeași natură ca și voi și vă aducem o veste bună, ca să vă întoarceți de la aceste lucruri deșarte la Dumnezeul cel viu, care a făcut cerul, pământul, marea și tot ce este în ele; ");
INSERT INTO ronlsb_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","care, în generațiile trecute, a lăsat toate neamurile să umble pe căile lor. ");
INSERT INTO ronlsb_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Și totuși nu s-a lăsat fără mărturie, căci a făcut binele și v-a dat ploi din cer și anotimpuri roditoare, umplându-ne inimile de hrană și de bucurie.” ");
INSERT INTO ronlsb_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Și chiar dacă spuneau aceste lucruri, cu greu au împiedicat mulțimile să le aducă jertfe. ");
INSERT INTO ronlsb_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Dar au venit acolo niște iudei din Antiohia și din Iconiu și, după ce au convins mulțimile, l-au ucis cu pietre pe Pavel și l-au târât afară din cetate, crezând că este mort. ");
INSERT INTO ronlsb_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Dar, pe când stăteau ucenicii în jurul Lui, S-a sculat și a intrat în cetate. A doua zi, a ieșit cu Barnaba la Derbe. ");
INSERT INTO ronlsb_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","După ce au propovăduit vestea cea bună în cetatea aceea și au făcut mulți ucenici, s-au întors la Listra, la Iconiu și la Antiohia, ");
INSERT INTO ronlsb_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","și au întărit sufletele ucenicilor, îndemnându-i să rămână în credință și să le spună că prin multe necazuri trebuie să intrăm în Împărăția lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","După ce au numit pentru ei prezbiteri în fiecare adunare și s-au rugat cu post, i-au încredințat Domnului în care crezuseră. ");
INSERT INTO ronlsb_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Au trecut prin Pisidia și au ajuns în Pamfilia. ");
INSERT INTO ronlsb_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","După ce au rostit cuvântul în Perga, s-au coborât în Attalia. ");
INSERT INTO ronlsb_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","De acolo au navigat spre Antiohia, de unde fuseseră încredințați harului lui Dumnezeu pentru lucrarea pe care o îndepliniseră. ");
INSERT INTO ronlsb_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","După ce au ajuns și au adunat adunarea, au relatat toate lucrurile pe care Dumnezeu le făcuse cu ei și faptul că deschisese o ușă a credinței pentru națiuni. ");
INSERT INTO ronlsb_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Au rămas acolo cu discipolii pentru o lungă perioadă de timp. ");
INSERT INTO ronlsb_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Niște oameni coborâți din Iudeea au învățat pe frați “Dacă nu vă tăiați împrejur după obiceiul lui Moise, nu puteți fi mântuiți.” ");
INSERT INTO ronlsb_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","De aceea, după ce Pavel și Barnaba au avut cu ei nu puține neînțelegeri și discuții, au însărcinat pe Pavel, pe Barnaba și pe alții dintre ei să se suie la Ierusalim la apostoli și la bătrâni în legătură cu această chestiune. ");
INSERT INTO ronlsb_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ei, fiind trimiși pe drum de adunare, au trecut prin Fenicia și Samaria, vestind convertirea neamurilor. Ei au provocat o mare bucurie tuturor fraților. ");
INSERT INTO ronlsb_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","După ce au ajuns la Ierusalim, au fost primiți de Adunare, de apostoli și de bătrâni și au relatat tot ce făcuse Dumnezeu cu ei. ");
INSERT INTO ronlsb_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Dar unii din secta fariseilor credincioși s-au sculat și au zis: “Trebuie să-i tăiem împrejur și să le poruncim să păzească Legea lui Moise.” ");
INSERT INTO ronlsb_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Și apostolii și bătrânii s-au adunat ca să vadă despre aceasta. ");
INSERT INTO ronlsb_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","După ce s-a discutat mult, Petru s-a ridicat și le-a zis: “Fraților, știți că, cu mult timp în urmă, Dumnezeu a făcut o alegere între voi, pentru ca, prin gura mea, neamurile să audă cuvântul Bunei Vestiri și să creadă. ");
INSERT INTO ronlsb_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Dumnezeu, care cunoaște inima, a mărturisit despre ei, dându-le Duhul Sfânt, așa cum ne-a făcut și nouă. ");
INSERT INTO ronlsb_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","El nu a făcut nicio deosebire între noi și ei, curățându-le inimile prin credință. ");
INSERT INTO ronlsb_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Așadar, acum, de ce îl ispitiți pe Dumnezeu, ca să puneți pe gâtul discipolilor un jug pe care nici părinții noștri și nici noi nu am putut să-l purtăm? ");
INSERT INTO ronlsb_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Noi, însă, credem că suntem mântuiți prin harul Domnului Isus, ca și ei.” ");
INSERT INTO ronlsb_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Toată mulțimea tăcea și asculta pe Barnaba și pe Pavel, care vorbeau despre semnele și minunile pe care le făcuse Dumnezeu printre neamuri prin ei. ");
INSERT INTO ronlsb_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","După ce au tăcut, Iacov a răspuns: “Fraților, ascultați-mă. ");
INSERT INTO ronlsb_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simeon a relatat cum Dumnezeu a vizitat mai întâi națiunile pentru a lua din ele un popor pentru numele său. ");
INSERT INTO ronlsb_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Acest lucru este în acord cu cuvintele profeților. După cum este scris, ");
INSERT INTO ronlsb_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“După acestea mă voi întoarce. Voi zidi din nou cortul lui David, care a căzut. Voi construi din nou ruinele sale. Îl voi ridica ");
INSERT INTO ronlsb_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","pentru ca ceilalți oameni să caute pe Domnul: toate neamurile care sunt chemate după numele Meu, zice Domnul, care face toate aceste lucruri. ");
INSERT INTO ronlsb_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","“Toate lucrările lui Dumnezeu sunt cunoscute de El din veșnicie. ");
INSERT INTO ronlsb_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","De aceea, judecata mea este să nu-i tulburăm pe cei din rândul neamurilor care se întorc la Dumnezeu, ");
INSERT INTO ronlsb_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ci să le scriem să se abțină de la spurcarea idolilor, de la imoralitatea sexuală, de la ceea ce este sugrumat și de la sânge. ");
INSERT INTO ronlsb_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Căci Moise, din generații de demult, are în fiecare cetate pe cei care îl propovăduiesc, fiind citit în sinagogi în fiecare Sabat.” ");
INSERT INTO ronlsb_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Atunci apostolii și bătrânii, împreună cu toată adunarea, au găsit de cuviință să aleagă bărbați din ceata lor și să-i trimită la Antiohia cu Pavel și Barnaba: Iuda, numit Barsaba, și Sila, bărbați de seamă între frați. ");
INSERT INTO ronlsb_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ei au scris aceste lucruri de mâna lor: “Apostolii, bătrânii și frații, către frații care sunt dintre neamuri în Antiohia, Siria și Cilicia: salutări. ");
INSERT INTO ronlsb_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Pentru că am auzit că unii care au plecat de la noi v-au tulburat cu vorbe, neliniștindu-vă sufletele, spunând: “Trebuie să vă tăiați împrejur și să țineți Legea”, cărora noi nu le-am dat nicio poruncă; ");
INSERT INTO ronlsb_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","ni s-a părut bine, după ce am ajuns la un acord, să alegem niște oameni și să vi-i trimitem împreună cu preaiubiții noștri Barnaba și Pavel, ");
INSERT INTO ronlsb_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","oameni care și-au riscat viața pentru numele Domnului nostru Isus Hristos. ");
INSERT INTO ronlsb_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Am trimis, așadar, pe Iuda și pe Sila, care și ei înșiși vă vor spune aceleași lucruri prin cuvânt. ");
INSERT INTO ronlsb_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Fiindcă Duhul Sfânt și nouă ni s-a părut bine să nu punem asupra voastră o povară mai mare decât aceste lucruri necesare: ");
INSERT INTO ronlsb_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","să vă abțineți de la lucrurile jertfite idolilor, de la sânge, de la lucrurile sugrumate și de la imoralitatea sexuală, de care, dacă vă veți păzi, vă va fi bine. Adio!” ");
INSERT INTO ronlsb_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","După ce au fost trimiși, au ajuns la Antiohia. După ce au adunat mulțimea, au înmânat scrisoarea. ");
INSERT INTO ronlsb_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","După ce au citit-o, s-au bucurat de încurajare. ");
INSERT INTO ronlsb_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Iuda și Sila, fiind și ei prooroci, i-au încurajat pe frați cu multe cuvinte și i-au întărit. ");
INSERT INTO ronlsb_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","După ce au petrecut ceva timp acolo, frații i-au concediat în pace de la frați la apostoli. ");
INSERT INTO ronlsb_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35"," Dar Pavel și Barnaba au rămas în Antiohia, învățând și propovăduind cuvântul Domnului, împreună cu mulți alții. ");
INSERT INTO ronlsb_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","După câteva zile, Pavel a zis lui Barnaba: “Să ne întoarcem acum și să vizităm pe frații noștri în fiecare cetate în care am vestit cuvântul Domnului, ca să vedem ce mai fac.” ");
INSERT INTO ronlsb_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnaba plănuia să ia cu ei și pe Ioan, căruia i se spunea Marcu. ");
INSERT INTO ronlsb_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Dar lui Pavel nu i s-a părut o idee bună să ia cu ei pe cineva care se retrăsese de la ei în Pamfilia și care nu a mers cu ei să facă lucrarea. ");
INSERT INTO ronlsb_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Atunci cearta a devenit atât de aprinsă, încât s-au despărțit unul de altul. Barnaba l-a luat pe Marcu cu el și a plecat în Cipru, ");
INSERT INTO ronlsb_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","dar Pavel l-a ales pe Sila și a plecat, fiind încredințat de frați harului lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","A străbătut Siria și Cilicia, întărind adunările. ");
INSERT INTO ronlsb_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","A venit la Derbe și la Listra; și iată că era acolo un ucenic, numit Timotei, fiul unei iudeice credincioase, dar tatăl său era grec. ");
INSERT INTO ronlsb_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Frații care erau la Listra și la Iconiu au dat o mărturie bună despre el. ");
INSERT INTO ronlsb_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pavel a vrut ca el să meargă cu el; l-a luat și l-a circumcis din cauza iudeilor care erau în acele părți, căci toți știau că tatăl lui era grec. ");
INSERT INTO ronlsb_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Pe când mergeau prin cetăți, le transmiteau decretele pe care trebuiau să le respecte și care fuseseră rânduite de apostolii și de bătrânii care erau la Ierusalim. ");
INSERT INTO ronlsb_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Astfel, adunările se întăreau în credință și se înmulțeau în fiecare zi. ");
INSERT INTO ronlsb_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","După ce au străbătut ținutul Frigiei și al Galatiei, Duhul Sfânt le-a interzis să vorbească în Asia. ");
INSERT INTO ronlsb_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","După ce au ajuns vizavi de Mysia, au încercat să intre în Bitinia, dar Duhul Sfânt nu le-a permis. ");
INSERT INTO ronlsb_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Trecând de Mysia, au coborât la Troa. ");
INSERT INTO ronlsb_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","O viziune i-a apărut lui Pavel în timpul nopții. Era un om din Macedonia care stătea în picioare, îl implora și îi spunea: “Treci în Macedonia și ajută-ne”. ");
INSERT INTO ronlsb_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","După ce a văzut viziunea, imediat am căutat să mergem în Macedonia, ajungând la concluzia că Domnul ne-a chemat să le vestim Vestea cea Bună. ");
INSERT INTO ronlsb_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Așadar, pornind din Troa, am pornit din Troa, am făcut drum drept spre Samotracia, iar a doua zi spre Neapolis; ");
INSERT INTO ronlsb_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","și de acolo spre Filipi, care este un oraș din Macedonia, cel mai important din district, o colonie romană. Am stat câteva zile în acest oraș. ");
INSERT INTO ronlsb_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","În ziua de Sabat, ne-am dus în afara cetății, la marginea unui râu, unde am crezut că este un loc de rugăciune, și am luat loc și am vorbit cu femeile care se adunaseră. ");
INSERT INTO ronlsb_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ne-a ascultat o femeie numită Lidia, vânzătoare de purpură, din cetatea Tiatira, o femeie care se închina lui Dumnezeu. Domnul i-a deschis inima ca să asculte cele spuse de Pavel. ");
INSERT INTO ronlsb_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","După ce ea și familia ei au fost botezate, ne-a rugat, zicând: “Dacă ați judecat că sunt credincioasă Domnului, intrați în casa mea și rămâneți.” Așa ne-a convins ea. ");
INSERT INTO ronlsb_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Pe când ne duceam la rugăciune, ne-a întâlnit o fată cu duh de ghicitoare, care aducea stăpânilor ei mult câștig prin ghicire. ");
INSERT INTO ronlsb_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Urmărindu-ne pe Pavel și pe noi, ea a strigat: “Acești oameni sunt slujitori ai Dumnezeului Celui Preaînalt, care ne vestesc o cale de mântuire!” ");
INSERT INTO ronlsb_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ea a făcut acest lucru timp de mai multe zile. Dar Pavel, foarte supărat, s-a întors și i-a spus duhului: “Îți poruncesc în numele lui Isus Hristos să ieși din ea!”. A ieșit chiar în acea oră. ");
INSERT INTO ronlsb_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Dar când stăpânii ei au văzut că speranța câștigului lor a dispărut, i-au prins pe Pavel și pe Sila și i-au târât în piață în fața conducătorilor. ");
INSERT INTO ronlsb_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","După ce i-au adus în fața magistraților, aceștia au spus: “Acești oameni, fiind iudei, ne agită cetatea ");
INSERT INTO ronlsb_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","și susțin obiceiuri pe care nouă, fiind romani, nu ne este îngăduit să le acceptăm sau să le respectăm.” ");
INSERT INTO ronlsb_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Mulțimea s-a ridicat împotriva lor, iar magistrații le-au rupt hainele și au poruncit să fie bătuți cu toiege. ");
INSERT INTO ronlsb_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","După ce le-au aplicat multe lovituri, i-au aruncat în închisoare, însărcinând pe temnicer să-i păzească în siguranță. ");
INSERT INTO ronlsb_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","După ce a primit o astfel de poruncă, i-a aruncat în închisoarea interioară și le-a asigurat picioarele în lanțuri. ");
INSERT INTO ronlsb_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Dar, pe la miezul nopții, Pavel și Sila se rugau și cântau cântări lui Dumnezeu, iar cei închiși îi ascultau. ");
INSERT INTO ronlsb_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Deodată s-a produs un cutremur mare, încât s-au zguduit temeliile închisorii; și îndată s-au deschis toate ușile, și toate legăturile tuturor au fost desfăcute. ");
INSERT INTO ronlsb_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Temnicerul, fiind trezit din somn și văzând ușile închisorii deschise, și-a scos sabia și era pe punctul de a se sinucide, crezând că prizonierii au scăpat. ");
INSERT INTO ronlsb_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Dar Pavel a strigat cu glas tare: “Nu-ți face rău, căci suntem cu toții aici!” ");
INSERT INTO ronlsb_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","A chemat lumină, a intrat, a sărit înăuntru, a căzut tremurând înaintea lui Pavel și a lui Sila, ");
INSERT INTO ronlsb_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","i-a scos afară și a zis: “Domnilor, ce trebuie să fac ca să mă mântuiesc?” ");
INSERT INTO ronlsb_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ei au zis: “Credeți în Domnul Isus Hristos și veți fi mântuiți, tu și casa ta.” ");
INSERT INTO ronlsb_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ei i-au spus cuvântul Domnului lui și tuturor celor care erau în casa lui. ");
INSERT INTO ronlsb_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","La aceeași oră din noapte, i-a luat și le-a spălat rănile, și îndată s-a botezat el și toată casa lui. ");
INSERT INTO ronlsb_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","I-a urcat în casa lui, le-a pus mâncare înaintea lor și s-a bucurat foarte mult împreună cu toată casa lui, pentru că a crezut în Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Dar, când s-a făcut ziuă, magistrații au trimis pe sergenți, zicând: “Lasă-i să plece pe oamenii aceia.” ");
INSERT INTO ronlsb_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Temnicerul a raportat aceste cuvinte lui Pavel, zicând: “Magistrații au trimis să te lase să pleci; ieși acum și du-te în pace.” ");
INSERT INTO ronlsb_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Dar Pavel le-a zis: “Ne-au bătut în public, fără judecată, niște romani, și ne-au aruncat în temniță! Ne eliberează ei acum în secret? Nu, cu siguranță, ci să vină ei înșiși și să ne scoată afară!” ");
INSERT INTO ronlsb_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Și sergenții au raportat aceste cuvinte magistraților, care s-au temut când au auzit că erau romani, ");
INSERT INTO ronlsb_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","și au venit și i-au rugat. După ce i-au scos afară, i-au rugat să plece din oraș. ");
INSERT INTO ronlsb_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Au ieșit din închisoare și au intrat în casa Lidiei. După ce i-au văzut pe frați, i-au încurajat, apoi au plecat. ");
INSERT INTO ronlsb_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","După ce au trecut prin Amfipoli și Apolonia, au ajuns la Tesalonic, unde era o sinagogă iudaică. ");
INSERT INTO ronlsb_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pavel, după obiceiul său, a intrat la ei și, timp de trei zile de Sabat, a discutat cu ei din Scripturi, ");
INSERT INTO ronlsb_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","explicând și demonstrând că Hristos trebuia să sufere și să învieze din morți și spunând: “Acest Isus, pe care vi-L vestesc, este Hristosul”. ");
INSERT INTO ronlsb_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Unii dintre ei au fost convinși și s-au alăturat lui Pavel și Sila; dintre greci, o mare mulțime de credincioși și nu puține femei de seamă. ");
INSERT INTO ronlsb_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Dar iudeii neînduplecați au luat cu ei câțiva oameni răi din piață și, adunând o mulțime, au pus cetatea în tumult. Asaltând casa lui Iason, au căutat să-i scoată în fața poporului. ");
INSERT INTO ronlsb_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Cum nu i-au găsit, i-au târât pe Iason și pe unii frați în fața conducătorilor cetății, strigând: “Au venit aici și aceștia care au răsturnat lumea, ");
INSERT INTO ronlsb_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","pe care i-a primit Iason. Toți aceștia acționează împotriva hotărârilor Cezarului, spunând că există un alt rege, Isus!”. ");
INSERT INTO ronlsb_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Mulțimea și conducătorii cetății s-au tulburat când au auzit aceste lucruri. ");
INSERT INTO ronlsb_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","După ce au luat garanții de la Iason și de la ceilalți, i-au lăsat să plece. ");
INSERT INTO ronlsb_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Frații au trimis îndată pe Pavel și pe Sila noaptea la Beroe. Când au ajuns, au intrat în sinagoga iudaică. ");
INSERT INTO ronlsb_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Aceștia erau mai nobili decât cei din Tesalonic, pentru că primeau Cuvântul cu toată disponibilitatea minții, cercetând zilnic Scripturile, ca să vadă dacă aceste lucruri sunt adevărate. ");
INSERT INTO ronlsb_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","De aceea, mulți dintre ei au crezut; de asemenea, dintre femeile grecești de seamă și nu puțini bărbați. ");
INSERT INTO ronlsb_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Dar, când iudeii din Tesalonic au aflat că cuvântul lui Dumnezeu a fost vestit de Pavel și în Beroea, au venit și ei acolo, agitând mulțimile. ");
INSERT INTO ronlsb_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Atunci frații au trimis îndată pe Pavel să meargă până la mare, iar Sila și Timotei au rămas încă acolo. ");
INSERT INTO ronlsb_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Dar cei care îl însoțeau pe Pavel l-au dus până la Atena. Primind poruncă de la Sila și Timotei să vină foarte repede la el, au plecat. ");
INSERT INTO ronlsb_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pavel îi aștepta la Atena și, când a văzut cetatea plină de idoli, i s-a aprins duhul în el. ");
INSERT INTO ronlsb_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Așa că discuta în sinagogă cu iudeii și cu persoanele evlavioase și în piață, în fiecare zi, cu cei care îl întâlneau. ");
INSERT INTO ronlsb_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Unii dintre filosofii epicurieni și stoici stăteau de asemenea de vorbă cu el. Unii ziceau: “Ce vrea să spună acest bălăcar?”. Alții au spus: “Se pare că susține zeități străine”, pentru că l-a predicat pe Isus și învierea. ");
INSERT INTO ronlsb_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","L-au prins și l-au dus în Areopag, zicând: “Să știm ce este această învățătură nouă, despre care vorbești? ");
INSERT INTO ronlsb_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Căci ne aduci la urechi niște lucruri ciudate. Vrem deci să știm ce înseamnă aceste lucruri”. ");
INSERT INTO ronlsb_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Or, toți atenienii și străinii care locuiau acolo nu-și petreceau timpul decât pentru a spune sau a auzi vreun lucru nou. ");
INSERT INTO ronlsb_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pavel, stând în mijlocul Areopagului, a zis: “Oameni din Atena, văd că sunteți foarte credincioși în toate. ");
INSERT INTO ronlsb_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Căci, trecând și observând obiectele cultului vostru, am găsit și un altar cu această inscripție: “PENTRU UN DUMNEZEU NECUNOSCUT.” De aceea, ceea ce voi adorați în necunoștință de cauză, vă anunț. ");
INSERT INTO ronlsb_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Dumnezeul care a făcut lumea și toate lucrurile din ea, el, care este Domnul cerului și al pământului, nu locuiește în temple făcute de mâini. ");
INSERT INTO ronlsb_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","El nu este slujit de mâini omenești, ca și cum ar avea nevoie de ceva, întrucât el însuși dă tuturor viață, suflare și toate lucrurile. ");
INSERT INTO ronlsb_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","El a făcut ca dintr-un singur sânge să locuiască orice neam de oameni pe toată suprafața pământului, stabilind anotimpurile și limitele locuințelor lor, ");
INSERT INTO ronlsb_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","pentru ca ei să îl caute pe Domnul, dacă poate ar putea să întindă mâna spre el și să îl găsească, deși el nu este departe de fiecare dintre noi. ");
INSERT INTO ronlsb_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","“Căci în El trăim, ne mișcăm și suntem”. Așa cum au spus unii dintre poeții voștri: 'Căci și noi suntem urmașii lui'. ");
INSERT INTO ronlsb_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Fiind, așadar, urmașii lui Dumnezeu, nu trebuie să credem că natura divină este ca aurul, argintul sau piatra, gravată prin arta și designul omului. ");
INSERT INTO ronlsb_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","De aceea, Dumnezeu a trecut cu vederea vremurile de ignoranță. Dar acum poruncește ca toți oamenii de pretutindeni să se pocăiască, ");
INSERT INTO ronlsb_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","pentru că a rânduit o zi în care va judeca lumea în dreptate, prin omul pe care l-a rânduit; despre care a dat asigurări tuturor oamenilor, prin faptul că l-a înviat din morți.” ");
INSERT INTO ronlsb_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Iar când auzeau despre învierea morților, unii râdeau, iar alții ziceau: “Vrem să te mai auzim încă o dată despre aceasta.” ");
INSERT INTO ronlsb_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Astfel a ieșit Pavel din mijlocul lor. ");
INSERT INTO ronlsb_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Dar unii oameni s-au alăturat lui și au crezut, printre care Dionisie Areopagitul, o femeie cu numele Damaris și alții împreună cu ei. ");
INSERT INTO ronlsb_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","După aceste lucruri, Pavel a plecat din Atena și a venit la Corint. ");
INSERT INTO ronlsb_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","A găsit un iudeu numit Aquila, de neam din Pont, care venise de curând din Italia cu Priscila, soția sa, pentru că Claudius poruncise ca toți iudeii să plece din Roma. El a venit la ei ");
INSERT INTO ronlsb_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","și, pentru că practica aceeași meserie, a locuit cu ei și lucra, căci de meserie erau constructori de corturi. ");
INSERT INTO ronlsb_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","În fiecare sâmbătă, el discuta în sinagogă și convingea iudei și greci. ");
INSERT INTO ronlsb_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Când Sila și Timotei s-au coborât din Macedonia, Pavel a fost împins de Duhul Sfânt să mărturisească iudeilor că Isus este Hristosul. ");
INSERT INTO ronlsb_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Când aceștia i s-au împotrivit și au blasfemiat, el și-a scuturat hainele și le-a zis: “Sângele vostru să fie pe capetele voastre! Eu sunt curat! De acum înainte, voi merge la neamuri!”. ");
INSERT INTO ronlsb_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","A plecat de acolo și a intrat în casa unui om numit Iustus, care se închina lui Dumnezeu și a cărui casă era lângă sinagogă. ");
INSERT INTO ronlsb_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Crispus, conducătorul sinagogii, a crezut în Domnul cu toată casa lui. Mulți dintre corinteni, când au auzit, au crezut și au fost botezați. ");
INSERT INTO ronlsb_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Domnul i-a spus lui Pavel noaptea, printr-o viziune: “Nu te teme, ci vorbește și nu tăcea; ");
INSERT INTO ronlsb_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","căci Eu sunt cu tine și nimeni nu te va ataca ca să-ți facă rău, căci am mulți oameni în această cetate.” ");
INSERT INTO ronlsb_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Și a locuit acolo un an și șase luni, învățând cuvântul lui Dumnezeu printre ei. ");
INSERT INTO ronlsb_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Dar, când Gallio era proconsul al Ahaiei, iudeii s-au ridicat de comun acord împotriva lui Pavel și l-au adus înaintea scaunului de judecată, ");
INSERT INTO ronlsb_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","spunând: “Omul acesta convinge pe oameni să se închine lui Dumnezeu contrar Legii”. ");
INSERT INTO ronlsb_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Dar când Pavel era pe punctul de a deschide gura, Gallio a zis iudeilor: “Dacă ar fi vorba de o greșeală sau de o crimă rea, iudeilor, ar fi cuviincios să vă îngădui; ");
INSERT INTO ronlsb_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","dar dacă este vorba de cuvinte și de nume și de legea voastră, căutați voi înșivă. Căci eu nu vreau să fiu judecător în aceste chestiuni”. ");
INSERT INTO ronlsb_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Și i-a alungat de pe scaunul de judecată. ");
INSERT INTO ronlsb_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Atunci toți grecii au prins pe Sostene, căpetenia sinagogii, și l-au bătut înaintea scaunului de judecată. Lui Gallio nu i-a păsat de niciunul dintre aceste lucruri. ");
INSERT INTO ronlsb_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pavel, după ce a mai stat încă multe zile, a luat rămas bun de la frați și a plecat de acolo în Siria, împreună cu Priscila și Aquila. La Cencreea și-a ras capul, căci avea un jurământ. ");
INSERT INTO ronlsb_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","A ajuns la Efes și i-a lăsat acolo; dar el însuși a intrat în sinagogă și a discutat cu iudeii. ");
INSERT INTO ronlsb_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Când aceștia l-au rugat să rămână mai mult timp cu ei, el a refuzat; ");
INSERT INTO ronlsb_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","dar, luându-și rămas bun de la ei, a spus: “Trebuie să țin cu orice preț sărbătoarea care urmează la Ierusalim, dar mă voi întoarce la voi dacă Dumnezeu va vrea”. Apoi a pornit din Efes. ");
INSERT INTO ronlsb_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","După ce a debarcat la Cezareea, s-a suit, a salutat adunarea și s-a coborât la Antiohia. ");
INSERT INTO ronlsb_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","După ce a petrecut ceva timp acolo, a plecat și a străbătut în ordine regiunea Galatiei și Frigiei, stabilind pe toți discipolii. ");
INSERT INTO ronlsb_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Un iudeu pe nume Apolo, de neam alexandrin, om elocvent, a venit la Efes. El era puternic în Scripturi. ");
INSERT INTO ronlsb_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Acest om fusese instruit în calea Domnului; și, fiind plin de ardoare în duh, vorbea și învăța cu exactitate lucrurile despre Isus, deși nu cunoștea decât botezul lui Ioan. ");
INSERT INTO ronlsb_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","A început să vorbească cu îndrăzneală în sinagogă. Dar Priscila și Aquila, când l-au auzit, l-au luat deoparte și i-au explicat mai exact calea lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","După ce s-a hotărât să treacă în Ahaia, frații l-au încurajat și au scris ucenicilor să îl primească. După ce a venit, i-a ajutat foarte mult pe cei care crezuseră prin har; ");
INSERT INTO ronlsb_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","pentru că i-a combătut cu putere pe iudei, arătând public, prin Scripturi, că Isus este Hristosul. ");
INSERT INTO ronlsb_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Pe când Apolo era la Corint, Pavel, trecând prin ținutul de sus, a venit la Efes și a găsit niște ucenici. ");
INSERT INTO ronlsb_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","El i-a întrebat: “Ați primit Duhul Sfânt atunci când ați crezut?” Ei i-au spus: “Nu, noi nici măcar nu am auzit că există un Duh Sfânt”. ");
INSERT INTO ronlsb_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","El a zis: “În ce ați fost botezați?” Ei au spus: “În botezul lui Ioan”. ");
INSERT INTO ronlsb_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pavel a spus: “Ioan a botezat cu botezul pocăinței, spunând poporului că trebuie să creadă în cel ce va veni după el, adică în Hristos Isus.” ");
INSERT INTO ronlsb_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Când au auzit acestea, s-au botezat în Numele Domnului Isus. ");
INSERT INTO ronlsb_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","După ce Pavel și-a pus mâinile peste ei, Duhul Sfânt s-a pogorât peste ei și au vorbit în alte limbi și au proorocit. ");
INSERT INTO ronlsb_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Erau în total vreo doisprezece bărbați. ");
INSERT INTO ronlsb_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Și, intrând în sinagogă, a vorbit cu îndrăzneală timp de trei luni de zile, și a vorbit și a convins despre lucrurile legate de Împărăția lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Dar, când unii s-au împietrit și au rămas neascultători, vorbind de rău de Calea Domnului înaintea mulțimii, s-a depărtat de ei și a despărțit pe ucenici, învățând în fiecare zi în școala lui Tiranus. ");
INSERT INTO ronlsb_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Acest lucru a continuat timp de doi ani, astfel încât toți cei care locuiau în Asia au auzit cuvântul Domnului Isus, atât iudeii, cât și grecii. ");
INSERT INTO ronlsb_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Dumnezeu făcea minuni deosebite prin mâinile lui Pavel, ");
INSERT INTO ronlsb_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","astfel că până și batiste sau șorțuri erau duse de pe trupul lui la cei bolnavi, și bolile se depărtau de ei, iar duhurile rele ieșeau. ");
INSERT INTO ronlsb_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Dar unii dintre iudeii ambulanți, exorciști, se apucau să invoce asupra celor care aveau duhuri rele numele Domnului Isus, spunând: “Vă conjurăm pe Isus pe care îl predică Pavel”. ");
INSERT INTO ronlsb_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Erau șapte fii ai unui anume Sceva, un preot-șef iudeu, care făceau acest lucru. ");
INSERT INTO ronlsb_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Duhul cel rău a răspuns: “Pe Isus îl cunosc, pe Pavel îl cunosc, dar tu cine ești?” ");
INSERT INTO ronlsb_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Bărbatul în care era duhul rău a sărit asupra lor, i-a copleșit și i-a biruit, așa că au fugit din casa aceea goi și răniți. ");
INSERT INTO ronlsb_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Acest lucru a ajuns la cunoștința tuturor, atât iudei cât și greci, care locuiau în Efes. Frica a căzut peste toți și numele Domnului Isus a fost mărit. ");
INSERT INTO ronlsb_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Și mulți dintre cei care crezuseră au venit, mărturisind și mărturisind faptele lor. ");
INSERT INTO ronlsb_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Mulți dintre cei care practicau artele magice și-au adunat cărțile și le-au ars în văzul tuturor. Au numărat prețul lor și au găsit că era de cincizeci de mii de arginți. ");
INSERT INTO ronlsb_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Astfel, cuvântul Domnului creștea și devenea puternic. ");
INSERT INTO ronlsb_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","După ce au trecut aceste lucruri, Pavel a hotărât în Duhul Sfânt, după ce a trecut prin Macedonia și Ahaia, să se ducă la Ierusalim, zicând: “După ce am fost acolo, trebuie să văd și Roma.” ");
INSERT INTO ronlsb_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","După ce a trimis în Macedonia pe doi dintre cei ce-i slujeau, Timotei și Erast, a rămas el însuși în Asia pentru o vreme. ");
INSERT INTO ronlsb_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","În vremea aceea, s-a iscat o tulburare nu mică în legătură cu Calea. ");
INSERT INTO ronlsb_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Căci un om pe nume Demetrius, un argintar care făcea sanctuare de argint pentru Artemis, a adus o afacere nu mică meșterilor ");
INSERT INTO ronlsb_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","pe care i-a adunat împreună cu lucrătorii cu aceeași ocupație și le-a spus: “Domnilor, știți că din această afacere ne avem averea. ");
INSERT INTO ronlsb_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Vedeți și auziți că nu numai în Efes, ci aproape în toată Asia, acest Pavel a convins și a îndepărtat pe mulți oameni, spunând că nu sunt dumnezei făcuți de mâini. ");
INSERT INTO ronlsb_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Nu numai că există pericolul ca acest comerț al nostru să ajungă în dizgrație, ci și ca templul marii zeițe Artemis să fie socotit ca nimic și să fie distrusă măreția ei, căreia i se închină toată Asia și toată lumea.” ");
INSERT INTO ronlsb_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Când au auzit acestea, s-au umplut de mânie și au strigat: “Mare este Artemis a efesenilor!”. ");
INSERT INTO ronlsb_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Toată cetatea s-a umplut de confuzie și s-au năpustit deodată în teatru, după ce i-au prins pe Gaius și Aristarh, bărbați din Macedonia, tovarășii de drum ai lui Pavel. ");
INSERT INTO ronlsb_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Când Pavel a vrut să intre în mijlocul poporului, ucenicii nu i-au dat voie. ");
INSERT INTO ronlsb_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","De asemenea, unii dintre asiarhi, care îi erau prieteni, au trimis la el și l-au rugat să nu se aventureze în teatru. ");
INSERT INTO ronlsb_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Unii, așadar, strigau una și alții alta, căci adunarea era în confuzie. Cei mai mulți dintre ei nu știau de ce se adunaseră. ");
INSERT INTO ronlsb_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Au adus pe Alexandru din mulțime, Iudeii punându-l în față. Alexandru făcea semn cu mâna și ar fi vrut să ia apărarea poporului. ");
INSERT INTO ronlsb_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Dar, când și-au dat seama că era iudeu, toți, cu un singur glas, timp de vreo două ore, au strigat: “Mare este Artemis din Efes!”. ");
INSERT INTO ronlsb_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","După ce a liniștit mulțimea, secretarul orașului a zis: “Bărbați din Efes, cine este acela care nu știe că cetatea efesenilor este templu al marii zeițe Artemis și al icoanei căzute de la Zeus? ");
INSERT INTO ronlsb_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Văzând deci că aceste lucruri nu pot fi negate, ar trebui să vă liniștiți și să nu faceți nimic nechibzuit. ");
INSERT INTO ronlsb_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Căci voi i-ați adus aici pe acești oameni, care nu sunt nici hoți de temple, nici blasfemiatori ai zeiței voastre. ");
INSERT INTO ronlsb_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Așadar, dacă Demetrius și meșterii care sunt cu el au ceva împotriva cuiva, tribunalele sunt deschise și sunt proconsuli. Să depună plângere unii împotriva altora. ");
INSERT INTO ronlsb_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Dar dacă căutați ceva despre alte chestiuni, se va rezolva în adunarea obișnuită. ");
INSERT INTO ronlsb_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Căci, într-adevăr, riscăm să fim acuzați cu privire la revolta de astăzi, fără să existe niciun motiv. Cu privire la aceasta, nu am fi în stare să dăm socoteală de această agitație.” ");
INSERT INTO ronlsb_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","După ce a vorbit astfel, a concediat adunarea. ");
INSERT INTO ronlsb_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","După ce a încetat zarva, Pavel a chemat pe ucenici, a luat rămas bun de la ei și a plecat să se ducă în Macedonia. ");
INSERT INTO ronlsb_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","După ce a străbătut acele părți și i-a încurajat cu multe cuvinte, a ajuns în Grecia. ");
INSERT INTO ronlsb_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","După ce a petrecut acolo trei luni și după ce iudeii au pus la cale un complot împotriva lui, pe când era pe punctul de a pleca în Siria, a hotărât să se întoarcă prin Macedonia. ");
INSERT INTO ronlsb_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Aceștia l-au însoțit până în Asia: Sopater din Beroea, Aristarchus și Secundus din Tesalonic, Gaius din Derbe, Timotei, precum și Tychicus și Trofimus din Asia. ");
INSERT INTO ronlsb_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Dar aceștia plecaseră înainte și ne așteptau la Troa. ");
INSERT INTO ronlsb_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Am plecat din Filipi după zilele Azimilor și am ajuns la ei la Troa în cinci zile, unde am stat șapte zile. ");
INSERT INTO ronlsb_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","În prima zi a săptămânii, când ucenicii s-au adunat să frângă pâinea, Pavel a vorbit cu ei, cu gândul de a pleca a doua zi, și a continuat să vorbească până la miezul nopții. ");
INSERT INTO ronlsb_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Erau multe lumini în camera de sus unde eram adunați. ");
INSERT INTO ronlsb_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Un tânăr pe nume Eutihie ședea la fereastră, împovărat de un somn adânc. Pe când Pavel vorbea încă și mai mult, fiind îngreunat de somn, a căzut de la etajul al treilea și a fost luat mort. ");
INSERT INTO ronlsb_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pavel s-a coborât, a căzut peste el și, îmbrățișându-l, i-a zis: “Nu te tulbura, căci viața lui este în el.” ");
INSERT INTO ronlsb_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","După ce S-a suit, a frânt pâinea și a mâncat, și a stat de vorbă cu ei multă vreme, până la ziuă, a plecat. ");
INSERT INTO ronlsb_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ei au adus băiatul viu și au fost foarte mângâiați. ");
INSERT INTO ronlsb_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Dar noi, mergând înainte la corabie, am pornit spre Assos, ca să îmbarcăm acolo pe Pavel, căci el însuși voia să meargă pe uscat. ");
INSERT INTO ronlsb_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Când ne-a întâlnit la Assos, l-am luat la bord și am ajuns la Mitilene. ");
INSERT INTO ronlsb_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Navigând de acolo, am ajuns a doua zi în fața Chiosului. A doua zi am atins Samos și am rămas la Trogyllium, iar a doua zi am ajuns la Milet. ");
INSERT INTO ronlsb_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Căci Pavel hotărâse să treacă pe lângă Efes, ca să nu fie nevoit să petreacă timp în Asia, pentru că se grăbea, dacă îi era posibil, să fie la Ierusalim în ziua Cincizecimii. ");
INSERT INTO ronlsb_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Din Milet a trimis la Efes și a chemat la el pe bătrânii adunării. ");
INSERT INTO ronlsb_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","După ce au venit la el, le-a zis: “Voi înșivă știți, din prima zi în care am pus piciorul în Asia, cum am fost tot timpul cu voi, ");
INSERT INTO ronlsb_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","slujindu-l pe Domnul cu toată smerenia, cu multe lacrimi și cu încercările care mi se întâmplau din cauza uneltirilor iudeilor; ");
INSERT INTO ronlsb_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","cum nu m-am sfiit să vă spun tot ce era de folos, învățându-vă în public și din casă în casă, ");
INSERT INTO ronlsb_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","mărturisind atât iudeilor, cât și grecilor, pocăința față de Dumnezeu și credința în Domnul nostru Isus. ");
INSERT INTO ronlsb_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Acum, iată, mă duc legat de Duhul Sfânt la Ierusalim, fără să știu ce mi se va întâmpla acolo; ");
INSERT INTO ronlsb_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","doar că Duhul Sfânt mărturisește în fiecare cetate, spunând că mă așteaptă legături și necazuri. ");
INSERT INTO ronlsb_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Dar aceste lucruri nu contează, și nici nu țin la viața mea, ca să îmi termin cu bucurie cursa și slujba pe care am primit-o de la Domnul Isus, ca să mărturisesc pe deplin Vestea cea bună a harului lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Acum, iată, știu că voi toți, printre care am umblat propovăduind Împărăția lui Dumnezeu, nu-mi veți mai vedea fața. ");
INSERT INTO ronlsb_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","De aceea vă mărturisesc astăzi că sunt curat de sângele tuturor oamenilor, ");
INSERT INTO ronlsb_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","căci nu m-am sfiit să vă vestesc tot sfatul lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Luați seama, așadar, la voi înșivă și la toată turma, în care Duhul Sfânt v-a pus supraveghetori, ca să păstoriți adunarea Domnului și Dumnezeului, pe care a cumpărat-o cu propriul sânge. ");
INSERT INTO ronlsb_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Căci știu că, după plecarea mea, vor intra în mijlocul vostru lupi vicioși, care nu vor cruța turma. ");
INSERT INTO ronlsb_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Se vor ridica oameni din mijlocul vostru, care vor vorbi lucruri perverse, ca să atragă pe ucenici după ei. ");
INSERT INTO ronlsb_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","De aceea, vegheați, aducându-vă aminte că, timp de trei ani, nu am încetat să avertizez pe toată lumea zi și noapte cu lacrimi. ");
INSERT INTO ronlsb_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Acum, fraților, vă încredințez lui Dumnezeu și cuvântului harului său, care este în măsură să vă zidească și să vă dea moștenirea între toți cei sfințiți. ");
INSERT INTO ronlsb_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Nu am râvnit la argintul, aurul sau îmbrăcămintea nimănui. ");
INSERT INTO ronlsb_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Voi înșivă știți că aceste mâini au slujit nevoilor mele și ale celor care erau cu mine. ");
INSERT INTO ronlsb_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","În toate v-am dat ca exemplu că, lucrând astfel, trebuie să-i ajutați pe cei slabi și să vă aduceți aminte de cuvintele Domnului Isus, care a spus el însuși: “Este mai ferice să dai decât să primești”.” ");
INSERT INTO ronlsb_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","După ce a spus aceste lucruri, a îngenuncheat și s-a rugat împreună cu toți. ");
INSERT INTO ronlsb_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Toți plângeau în hohote de plâns, se aruncau la gâtul lui Pavel și-l sărutau, ");
INSERT INTO ronlsb_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","maimult decât orice altceva, întristați de cuvântul pe care-l spusese, că nu-i vor mai vedea fața. Apoi l-au însoțit până la corabie. ");
INSERT INTO ronlsb_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","După ce ne-am despărțit de ei și am pornit, am ajuns în linie dreaptă la Cos, iar a doua zi la Rodos și de acolo la Patara. ");
INSERT INTO ronlsb_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","După ce am găsit o corabie care traversa spre Fenicia, ne-am urcat la bord și am pornit. ");
INSERT INTO ronlsb_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","După ce am ajuns în dreptul Ciprului, lăsându-l la stânga, am navigat spre Siria și am debarcat la Tir, căci nava se afla acolo pentru a-și descărca încărcătura. ");
INSERT INTO ronlsb_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","După ce am găsit discipoli, am rămas acolo șapte zile. Aceștia i-au spus lui Pavel, prin Duhul Sfânt, că nu trebuie să se urce la Ierusalim. ");
INSERT INTO ronlsb_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","După ce au trecut acele zile, am plecat și ne-am continuat călătoria. Toți, cu soțiile și copiii, ne-au însoțit pe drum până când am ieșit din oraș. Îngenunchind pe plajă, ne-am rugat. ");
INSERT INTO ronlsb_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","După ce ne-am luat rămas bun, ne-am urcat pe corabie, iar ei s-au întors din nou acasă. ");
INSERT INTO ronlsb_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","După ce am plecat din Tir, am ajuns la Ptolemaida. I-am întâmpinat pe frați și am rămas cu ei o zi. ");
INSERT INTO ronlsb_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","A doua zi, noi, care eram tovarășii lui Pavel, am plecat și am ajuns la Cezareea. Am intrat în casa lui Filip, evanghelistul, care era unul dintre cei șapte, și am rămas cu el. ");
INSERT INTO ronlsb_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Omul acesta avea patru fiice fecioare care profețeau. ");
INSERT INTO ronlsb_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Pe când stăteam acolo câteva zile, a coborât din Iudeea un profet numit Agabus. ");
INSERT INTO ronlsb_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Venind la noi și luând centura lui Pavel, și-a legat singur picioarele și mâinile și a zis: “Duhul Sfânt spune: “Astfel, iudeii din Ierusalim vor lega pe omul care are această centură și îl vor da în mâinile neamurilor.”” ");
INSERT INTO ronlsb_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Când am auzit aceste lucruri, noi și oamenii din locul acela l-am rugat să nu se suie la Ierusalim. ");
INSERT INTO ronlsb_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Atunci Pavel a răspuns: “Ce faceți, plângeți și îmi frângeți inima? Căci sunt gata nu numai să fiu legat, ci și să mor la Ierusalim pentru Numele Domnului Isus.” ");
INSERT INTO ronlsb_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Și cum nu se lăsa convins, am încetat, zicând: “Facă-se voia Domnului!” ");
INSERT INTO ronlsb_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","După aceste zile, ne-am luat bagajele și ne-am suit la Ierusalim. ");
INSERT INTO ronlsb_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Unii dintre ucenicii din Cezareea au mers și ei cu noi, aducând și pe un anume Mnason din Cipru, un ucenic dintâi, la care urma să rămânem. ");
INSERT INTO ronlsb_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Când am ajuns la Ierusalim, frații ne-au primit cu bucurie. ");
INSERT INTO ronlsb_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","A doua zi, Pavel a intrat cu noi la Iacov; și toți bătrânii erau de față. ");
INSERT INTO ronlsb_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","După ce i-a salutat, a relatat unul câte unul lucrurile pe care le făcuse Dumnezeu printre neamuri prin slujba lui. ");
INSERT INTO ronlsb_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Aceștia, când au auzit, au slăvit pe Dumnezeu. I-au zis: “Vezi, frate, câte mii sunt printre iudei dintre cei care au crezut și toți sunt zeloși pentru Lege. ");
INSERT INTO ronlsb_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ei au fost informați despre tine, că îi înveți pe toți iudeii care sunt printre neamuri să se lepede de Moise, spunându-le să nu-și taie împrejur copiii și să nu umble după obiceiuri. ");
INSERT INTO ronlsb_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Și atunci, ce este? Adunarea trebuie să se întrunească cu siguranță, căci vor auzi că ai venit. ");
INSERT INTO ronlsb_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Faceți deci ceea ce vă spunem. Avem patru bărbați care au făcut un jurământ. ");
INSERT INTO ronlsb_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ia-i și purifică-te împreună cu ei și plătește-le cheltuielile pentru ei, ca să-și radă capul. Atunci vor ști cu toții că nu este niciun adevăr în lucrurile despre care au fost informați despre tine, ci că și tu însuți umbli respectând Legea. ");
INSERT INTO ronlsb_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Dar în ceea ce privește neamurile care cred, am scris hotărârea noastră că nu trebuie să respecte nimic de acest fel, decât să se ferească de mâncarea oferită idolilor, de sânge, de lucrurile sugrumate și de imoralitatea sexuală.” ");
INSERT INTO ronlsb_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Pavel a luat pe bărbați, s-a curățit a doua zi și a mers cu ei în Templu, și a vestit împlinirea zilelor de curățire, până când s-a adus jertfă pentru fiecare dintre ei. ");
INSERT INTO ronlsb_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Când cele șapte zile erau aproape împlinite, iudeii din Asia, văzându-l în templu, au stârnit toată mulțimea și au pus mâinile pe el, ");
INSERT INTO ronlsb_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","strigând: “Bărbați ai lui Israel, ajutor! Acesta este omul care îi învață pe toți oamenii de pretutindeni împotriva poporului, a legii și a acestui loc. Mai mult, el a adus și greci în templu și a pângărit acest loc sfânt!” ");
INSERT INTO ronlsb_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Căci îl văzuseră pe Trofim, efescianul, împreună cu el în cetate, și au presupus că Pavel l-a adus în templu. ");
INSERT INTO ronlsb_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Toată cetatea s-a mișcat și poporul a alergat. L-au prins pe Pavel și l-au târât afară din templu. Imediat ușile au fost închise. ");
INSERT INTO ronlsb_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","În timp ce încercau să-l ucidă, a sosit la comandantul regimentului vestea că tot Ierusalimul era în zarvă. ");
INSERT INTO ronlsb_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Imediat a luat soldați și centurioni și a alergat la ei. Aceștia, când i-au văzut pe căpitanul principal și pe soldați, au încetat să-l mai bată pe Pavel. ");
INSERT INTO ronlsb_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Atunci comandantul s-a apropiat, l-a arestat, a poruncit să fie legat cu două lanțuri și a întrebat cine este și ce a făcut. ");
INSERT INTO ronlsb_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Unii strigau un lucru și alții altul, în mulțime. Când nu a putut afla adevărul din cauza gălăgiei, a poruncit să fie dus în cazarmă. ");
INSERT INTO ronlsb_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Când a ajuns pe scări, a fost dus de ostași, din pricina mulțimii care se înghesuia; ");
INSERT INTO ronlsb_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","căci mulțimea poporului îl urmărea, strigând: “Luați-l!”. ");
INSERT INTO ronlsb_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Pe când Pavel era pe punctul de a fi dus în cazarmă, l-a întrebat pe comandant: “Pot să-ți vorbesc?” El a spus: “Știi greacă? ");
INSERT INTO ronlsb_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Nu ești tu, deci, egipteanul care, mai înainte de aceste zile, a stârnit răzvrătirea și a condus în pustiu pe cei patru mii de oameni ai asasinilor?” ");
INSERT INTO ronlsb_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Dar Pavel a zis: “Eu sunt un iudeu din Tars, din Cilicia, un cetățean al unei cetăți deloc neînsemnate. Vă rog, dați-mi voie să vorbesc poporului.” ");
INSERT INTO ronlsb_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","După ce i-a dat voie, Pavel, stând pe scări, a făcut semn cu mâna către popor. Când s-a făcut o mare tăcere, el le-a vorbit în limba ebraică, zicând ");
INSERT INTO ronlsb_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Frați și părinți, ascultați apărarea pe care v-o fac acum.” ");
INSERT INTO ronlsb_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Când au auzit că le vorbea în limba ebraică, s-au liniștit și mai mult. El a zis: ");
INSERT INTO ronlsb_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Eu sunt iudeu, născut în Tarsul Ciliciei, dar crescut în această cetate, la picioarele lui Gamaliel, învățat după tradiția strictă a legii părinților noștri, și zelos pentru Dumnezeu, așa cum sunteți și voi toți astăzi. ");
INSERT INTO ronlsb_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Am prigonit această Cale până la moarte, legând și dând în închisori bărbați și femei, ");
INSERT INTO ronlsb_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","așa cum mărturisesc și marele preot și tot consiliul bătrânilor, de la care am primit și scrisori către frați, și am călătorit la Damasc pentru a-i aduce în legături la Ierusalim și pe cei care erau acolo, ca să fie pedepsiți. ");
INSERT INTO ronlsb_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Pe când mergeam și mă apropiam de Damasc, pe la amiază, deodată, din cer, o lumină mare a strălucit în jurul meu. ");
INSERT INTO ronlsb_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Am căzut la pământ și am auzit un glas care îmi spunea: “Saul, Saul, de ce mă prigonești?” ");
INSERT INTO ronlsb_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","I-am răspuns: “Cine ești Tu, Doamne?” El mi-a zis: “Eu sunt Isus din Nazaret, pe care Îl prigonești tu. ");
INSERT INTO ronlsb_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Cei ce erau cu mine au văzut lumina și s-au temut, dar n-au înțeles vocea Celui ce vorbea cu mine. ");
INSERT INTO ronlsb_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Am întrebat: “Ce să fac, Doamne?”. Domnul mi-a zis: 'Ridică-te și du-te în Damasc. Acolo ți se vor spune toate lucrurile care ți-au fost rânduite să le faci”. ");
INSERT INTO ronlsb_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Când nu mai vedeam nimic din cauza slavei acelei lumini, fiind condus de mâna celor care erau cu mine, am intrat în Damasc. ");
INSERT INTO ronlsb_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Un oarecare Anania, un om evlavios după Lege, vestit de toți iudeii care locuiau în Damasc, ");
INSERT INTO ronlsb_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","a venit la mine și, stând lângă mine, mi-a zis: “Frate Saul, primește-ți vederea! Chiar în acel ceas m-am uitat la el. ");
INSERT INTO ronlsb_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","El a zis: “Dumnezeul părinților noștri te-a rânduit să cunoști voia Lui, să-L vezi pe Cel Drept și să auzi un glas din gura Lui. ");
INSERT INTO ronlsb_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Căci tu vei fi martor pentru el, în fața tuturor oamenilor, pentru ceea ce ai văzut și ai auzit. ");
INSERT INTO ronlsb_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Și acum, de ce așteptați? Ridică-te, botează-te și spală-ți păcatele, invocând numele Domnului”. ");
INSERT INTO ronlsb_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","După ce m-am întors la Ierusalim și în timp ce mă rugam în Templu, am căzut în transă ");
INSERT INTO ronlsb_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","și l-am văzut pe El zicându-mi: “Grăbește-te și ieși repede din Ierusalim, pentru că nu vor primi de la tine mărturie despre Mine”. ");
INSERT INTO ronlsb_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Eu am zis: “Doamne, ei înșiși știu că am întemnițat și am bătut în toate sinagogile pe cei care credeau în Tine. ");
INSERT INTO ronlsb_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Când s-a vărsat sângele lui Ștefan, martorul Tău, am stat și eu de față, consimțind la moartea lui și păzind mantiile celor care l-au ucis'. ");
INSERT INTO ronlsb_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","El mi-a zis: “Pleacă, căci te voi trimite departe de aici, la neamuri.” ");
INSERT INTO ronlsb_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","L-au ascultat până ce a spus aceasta; apoi au ridicat glasul și au zis: “Scapă pământul de omul acesta, căci nu este vrednic să trăiască!” ");
INSERT INTO ronlsb_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Pe când strigau, își aruncau mantiile și aruncau praf în aer, ");
INSERT INTO ronlsb_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","comandantul a poruncit să fie dus în cazarmă și a ordonat să fie cercetat prin biciuire, ca să știe pentru ce crimă strigau așa împotriva lui. ");
INSERT INTO ronlsb_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","După ce l-au legat cu chingi, Pavel l-a întrebat pe centurionul care se afla de față: “Îți este permis să biciuiești un om care este roman și nu a fost găsit vinovat?” ");
INSERT INTO ronlsb_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Când a auzit centurionul, s-a dus la comandant și i-a zis: “Ai grijă ce ai de gând să faci, căci omul acesta este roman!” ");
INSERT INTO ronlsb_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Comandantul a venit și l-a întrebat: “Spune-mi, ești roman?” El a spus: “Da”. ");
INSERT INTO ronlsb_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Și comandantul a răspuns: “Mi-am cumpărat cetățenia cu un preț mare.” Pavel a spus: “Dar eu m-am născut roman”. ");
INSERT INTO ronlsb_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Și îndată s-au depărtat de el cei ce voiau să-l cerceteze, iar comandantul s-a temut și el, când a văzut că este roman, pentru că îl legase. ");
INSERT INTO ronlsb_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Dar a doua zi, dorind să afle adevărul despre motivul pentru care era acuzat de iudei, l-a eliberat din legături și a poruncit preoților de seamă și întregului consiliu să se adune, a coborât pe Pavel și l-a pus în fața lor. ");
INSERT INTO ronlsb_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pavel, uitându-se cu stăruință la consiliu, a zis: “Fraților, până astăzi am trăit înaintea lui Dumnezeu cu toată conștiința împăcată”. ");
INSERT INTO ronlsb_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Marele preot Anania a poruncit celor ce stăteau lângă el să îl lovească peste gură. ");
INSERT INTO ronlsb_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Atunci Pavel i-a zis: “Dumnezeu te va lovi, zid albit! Stai tu să mă judeci după lege și poruncești să fiu lovit contrar legii?” ");
INSERT INTO ronlsb_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Cei ce stăteau de față ziceau: “Voi defăimați pe marele preot al lui Dumnezeu?” ");
INSERT INTO ronlsb_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pavel a zis: “Nu știam, fraților, că este mare preot. Căci este scris: “Să nu vorbești de rău despre un conducător al poporului tău”.” ");
INSERT INTO ronlsb_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Dar Pavel, văzând că o parte erau saduchei, iar cealaltă farisei, a strigat în consiliu: “Bărbați și frați, eu sunt fariseu, fiu de farisei. Cu privire la speranța și la învierea morților sunt judecat!” ");
INSERT INTO ronlsb_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","După ce a spus acestea, s-a iscat o ceartă între farisei și saduchei, și mulțimea s-a dezbinat. ");
INSERT INTO ronlsb_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Căci saducheii spuneau că nu există nici înviere, nici înger, nici duh; dar fariseii mărturisesc toate acestea. ");
INSERT INTO ronlsb_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","S-a stârnit o mare zarvă și unii dintre cărturarii din partea fariseilor s-au ridicat în picioare și se certau, zicând: “Noi nu găsim nimic rău în omul acesta. Dar dacă un duh sau un înger i-a vorbit, să nu ne luptăm împotriva lui Dumnezeu!” ");
INSERT INTO ronlsb_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Când s-a iscat o mare ceartă, comandantul, temându-se ca Pavel să nu fie sfâșiat de ei, a poruncit ostașilor să se coboare, să-l ia cu forța dintre ei și să-l ducă în cazarmă. ");
INSERT INTO ronlsb_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","În noaptea următoare, Domnul a stat lângă el și i-a zis: “Înveselește-te, Pavel, căci, după cum ai mărturisit despre Mine la Ierusalim, tot așa trebuie să mărturisești și la Roma.” ");
INSERT INTO ronlsb_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Când s-a făcut ziuă, unii dintre iudei s-au unit și s-au legat cu un blestem, zicând că nu vor mânca și nu vor bea nimic până ce nu vor omorî pe Pavel. ");
INSERT INTO ronlsb_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Erau mai mult de patruzeci de persoane care făcuseră această conspirație. ");
INSERT INTO ronlsb_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ei au venit la preoții cei mai de seamă și la bătrâni și au zis: “Ne-am legat sub un mare blestem să nu gustăm nimic până nu-l vom ucide pe Pavel. ");
INSERT INTO ronlsb_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Acum, deci, voi, împreună cu consiliul, informați comandantul că mâine trebuie să vi-l aducă la voi, ca și cum ați avea de gând să judecați mai exact cazul lui. Noi suntem gata să-l omorâm înainte de a se apropia.” ");
INSERT INTO ronlsb_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Dar fiul surorii lui Pavel a auzit că stau la pândă, a venit și a intrat în cazarmă și a anunțat pe Pavel. ");
INSERT INTO ronlsb_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pavel a chemat pe unul dintre centurioni și a zis: “Duceți-l pe acest tânăr la comandant, căci are ceva să-i spună.” ");
INSERT INTO ronlsb_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","L-a luat, l-a dus la comandant și i-a zis: “Pavel, prizonierul, m-a chemat și m-a rugat să-ți aduc pe acest tânăr. El are ceva să-ți spună”. ");
INSERT INTO ronlsb_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Comandantul l-a luat de mână și, ducându-se la o parte, l-a întrebat în particular: “Ce ai să-mi spui?” ");
INSERT INTO ronlsb_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Și a zis: “Iudeii au căzut de acord să te roage să aduci mâine pe Pavel la sfat, ca și cum ar fi vrut să se intereseze mai bine de el. ");
INSERT INTO ronlsb_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","De aceea, nu le ceda, pentru că îl pândesc mai mult de patruzeci de oameni care s-au legat cu un blestem să nu mănânce și să nu bea nimic până nu-l vor ucide. Acum sunt gata, așteptând promisiunea din partea ta.” ");
INSERT INTO ronlsb_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Și comandantul a lăsat pe tânăr să plece, și i-a zis: “Să nu spui nimănui că mi-ai descoperit aceste lucruri.” ");
INSERT INTO ronlsb_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","A chemat la el doi dintre centurioni și le-a zis: “Pregătiți două sute de ostași, ca să meargă până la Cezareea, cu șaptezeci de călăreți și două sute de oameni înarmați cu sulițe, la ceasul al treilea din noapte”. ");
INSERT INTO ronlsb_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Le-a cerut să pună la dispoziție niște călăreți, ca să-l urce pe Pavel pe unul dintre ei și să-l ducă în siguranță la Felix, guvernatorul. ");
INSERT INTO ronlsb_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Și a scris o scrisoare astfel: “Și a scris o scrisoare ca aceasta: ");
INSERT INTO ronlsb_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Claudius Lysias către cel mai bun guvernator Felix: “Salutări. ");
INSERT INTO ronlsb_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","“Omul acesta a fost prins de iudei și era pe cale să fie omorât de ei, când am venit cu ostașii și l-am salvat, aflând că este roman. ");
INSERT INTO ronlsb_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Dorind să aflu cauza pentru care îl acuzau, l-am adus jos la consiliul lor. ");
INSERT INTO ronlsb_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Am găsit că era acuzat în legătură cu chestiuni legate de legea lor, dar nu era acuzat de nimic vrednic de moarte sau de închisoare. ");
INSERT INTO ronlsb_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Când mi s-a spus că iudeii îl pândesc, l-am trimis imediat la voi, însărcinându-i și pe acuzatorii lui să aducă înaintea voastră acuzațiile lor împotriva lui. Rămas bun!” ");
INSERT INTO ronlsb_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Soldații au luat pe Pavel și, după porunca lor, l-au dus noaptea la Antipatris. ");
INSERT INTO ronlsb_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Dar a doua zi au lăsat călăreții să meargă cu el și s-au întors la cazarmă. ");
INSERT INTO ronlsb_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Când au ajuns la Cezareea și au predat scrisoarea guvernatorului, i-au prezentat și lui Pavel. ");
INSERT INTO ronlsb_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","După ce a citit-o, guvernatorul a întrebat din ce provincie este. Când a înțeles că era din Cilicia, a spus: ");
INSERT INTO ronlsb_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","“Te voi asculta pe deplin când vor sosi și acuzatorii tăi”. El a poruncit să fie ținut în palatul lui Irod. ");
INSERT INTO ronlsb_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","După cinci zile, marele preot Anania s-a coborât cu niște bătrâni și cu un orator, Tertul. Aceștia l-au informat pe guvernator împotriva lui Pavel. ");
INSERT INTO ronlsb_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Când a fost chemat, Tertullus a început să-l acuze, spunând: “Văzând că prin tine ne bucurăm de multă pace și că prosperitatea vine în acest popor prin previziunea ta, ");
INSERT INTO ronlsb_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","o acceptăm în toate felurile și în toate locurile, preasfințite Felix, cu toată recunoștința. ");
INSERT INTO ronlsb_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Dar, ca să nu te întârzii, te rog să ai răbdare cu noi și să asculți câteva cuvinte. ");
INSERT INTO ronlsb_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Pentru că am descoperit că acest om este o plagă, un instigator de insurecții printre toți evreii din întreaga lume și un lider al sectei nazarienilor. ");
INSERT INTO ronlsb_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","A încercat chiar să profaneze templul și l-am arestat. ");
INSERT INTO ronlsb_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8"," Examinându-l tu însuți, poți constata toate aceste lucruri de care îl acuzăm.” ");
INSERT INTO ronlsb_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Și iudeii s-au alăturat și ei atacului, afirmând că așa stau lucrurile. ");
INSERT INTO ronlsb_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","După ce guvernatorul i-a făcut semn să vorbească, Pavel a răspuns: “Fiindcă știu că tu ești de mulți ani judecător al acestui neam, îmi iau cu plăcere apărarea, ");
INSERT INTO ronlsb_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","fiindcă poți să constați că nu au trecut mai mult de douăsprezece zile de când m-am suit să mă închin la Ierusalim. ");
INSERT INTO ronlsb_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","În templu nu m-au găsit certându-mă cu nimeni sau stârnind mulțimea, nici în sinagogi, nici în oraș. ");
INSERT INTO ronlsb_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Și nici nu vă pot dovedi lucrurile de care mă acuză acum. ");
INSERT INTO ronlsb_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Dar vă mărturisesc acest lucru: că, potrivit Căii, pe care ei o numesc sectă, așa slujesc eu Dumnezeului părinților noștri, crezând toate lucrurile care sunt conform Legii și care sunt scrise în profeți; ");
INSERT INTO ronlsb_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","având speranța față de Dumnezeu, pe care și aceștia o așteaptă, că va fi o înviere a morților, atât a celor drepți, cât și a celor nedrepți. ");
INSERT INTO ronlsb_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","În acest sens, practic și eu, având întotdeauna o conștiință lipsită de supărare față de Dumnezeu și față de oameni. ");
INSERT INTO ronlsb_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","După câțiva ani, am venit să aduc națiunii mele daruri pentru cei nevoiași și ofrande; ");
INSERT INTO ronlsb_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","în mijlocul cărora niște iudei din Asia m-au găsit purificat în templu, nu cu o mulțime și nici cu agitație. ");
INSERT INTO ronlsb_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Ei ar fi trebuit să fie aici, înaintea voastră, și să mă acuze, dacă aveau ceva împotriva mea. ");
INSERT INTO ronlsb_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Sau, altfel, să spună ei înșiși ce nedreptate au găsit în mine când am stat în fața consiliului, ");
INSERT INTO ronlsb_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","dacă nu cumva pentru acest singur lucru am strigat stând în picioare în mijlocul lor: “Cu privire la învierea morților sunt judecat astăzi în fața voastră!””. ");
INSERT INTO ronlsb_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Dar Felix, care cunoștea mai bine Calea, i-a amânat, zicând: “Când va coborî Lisias, comandantul, voi lua o hotărâre în privința voastră.” ");
INSERT INTO ronlsb_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","El a poruncit centurionului ca Pavel să fie ținut în custodie și să aibă unele privilegii și să nu interzică niciunui dintre prietenii săi să îl servească sau să îl viziteze. ");
INSERT INTO ronlsb_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","După câteva zile, Felix a venit cu Drusila, soția sa, care era iudeică, și a trimis să cheme pe Pavel și l-a ascultat cu privire la credința în Hristos Isus. ");
INSERT INTO ronlsb_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","În timp ce el vorbea despre neprihănire, despre stăpânirea de sine și despre judecata viitoare, Felix s-a îngrozit și i-a răspuns: “Du-te deocamdată și, când îmi va fi de folos, te voi chema.” ");
INSERT INTO ronlsb_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Între timp, el mai spera că Pavel îi va da bani, ca să-l elibereze. De aceea, de asemenea, trimitea mai des după el și vorbea cu el. ");
INSERT INTO ronlsb_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","După ce s-au împlinit doi ani, Felix a fost înlocuit de Porcius Festus; și Felix, vrând să se facă plăcut iudeilor, a lăsat pe Pavel în temniță. ");
INSERT INTO ronlsb_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Festus, deci, a venit în provincie și, după trei zile, s-a suit din Cezareea la Ierusalim. ");
INSERT INTO ronlsb_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Marele preot și cei mai de seamă dintre iudei l-au informat împotriva lui Pavel și l-au rugat, ");
INSERT INTO ronlsb_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","cerându-i o favoare împotriva lui, să-l cheme la Ierusalim, complotând să-l ucidă pe drum. ");
INSERT INTO ronlsb_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Festus însă a răspuns că Pavel trebuie să fie ținut în custodie la Cezareea și că el însuși urma să plece în curând. ");
INSERT INTO ronlsb_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","“Lăsați deci”, a spus el, “pe cei care sunt în putere printre voi să coboare cu mine și, dacă este ceva rău în acest om, să îl acuze.” ");
INSERT INTO ronlsb_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","După ce a stat printre ei mai mult de zece zile, s-a pogorât la Cezareea și a doua zi a stat pe scaunul de judecată și a poruncit să fie adus Pavel. ");
INSERT INTO ronlsb_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","După ce a venit, iudeii care se coborâseră de la Ierusalim au stat în jurul lui, aducând împotriva lui multe și grave acuzații pe care nu le puteau dovedi, ");
INSERT INTO ronlsb_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","în timp ce el spunea în apărarea sa: “Nu am păcătuit deloc nici împotriva legii iudeilor, nici împotriva templului, nici împotriva lui Cezar”. ");
INSERT INTO ronlsb_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Dar Festus, vrând să-și câștige favoarea iudeilor, a luat cuvântul și a zis lui Pavel: “Vrei să te duci la Ierusalim și să fii judecat de mine acolo despre aceste lucruri?” ");
INSERT INTO ronlsb_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Dar Pavel a zis: “Eu stau în fața scaunului de judecată al Cezarului, unde trebuie să fiu judecat. Nu am făcut niciun rău iudeilor, după cum bine știți și voi. ");
INSERT INTO ronlsb_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Căci, dacă am greșit și am săvârșit ceva vrednic de moarte, nu refuz să mor; dar dacă nu este adevărat niciunul din lucrurile de care mă acuză ei, nimeni nu mă poate preda lor. Eu apelez la Cezar!” ");
INSERT INTO ronlsb_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Atunci Festus, după ce a vorbit cu consiliul, a răspuns: “Ați apelat la Cezar. La Cezar vă veți duce”. ");
INSERT INTO ronlsb_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","După ce au trecut câteva zile, regele Agripa și Berenice au sosit la Cezareea și au salutat pe Festus. ");
INSERT INTO ronlsb_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Cum a stat acolo multe zile, Festus a prezentat împăratului cazul lui Pavel, zicând: “Există un om lăsat prizonier de Felix; ");
INSERT INTO ronlsb_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","despre care, când eram la Ierusalim, m-au informat preoții cei mai de seamă și bătrânii iudeilor, cerând o sentință împotriva lui. ");
INSERT INTO ronlsb_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Le-am răspuns că nu este obiceiul romanilor să predea pe cineva la pieire înainte ca acuzatul să se întâlnească față în față cu acuzatorii și să aibă ocazia să se apere în legătură cu acuzațiile care i se aduc. ");
INSERT INTO ronlsb_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Prin urmare, când s-au adunat aici, nu am întârziat, ci a doua zi am stat pe scaunul de judecată și am poruncit ca omul să fie adus. ");
INSERT INTO ronlsb_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Când acuzatorii s-au ridicat în picioare, nu i-au adus nicio acuzație de lucruri pe care le presupuneam eu, ");
INSERT INTO ronlsb_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","ci au avut anumite întrebări împotriva lui cu privire la propria lor religie și la un Isus mort, despre care Pavel a afirmat că este viu. ");
INSERT INTO ronlsb_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Fiind nedumerit cum să întreb despre aceste lucruri, l-am întrebat dacă este dispus să meargă la Ierusalim și acolo să fie judecat cu privire la aceste lucruri. ");
INSERT INTO ronlsb_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Dar, când Pavel a cerut să fie reținut în vederea deciziei împăratului, am poruncit să fie reținut până când îl voi putea trimite la Cezar.” ");
INSERT INTO ronlsb_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agripa a zis lui Festus: “Aș vrea și eu să aud pe acest om.” “Mâine”, a spus el, “îl veți auzi”. ");
INSERT INTO ronlsb_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","A doua zi, după ce Agripa și Berenice au venit cu mare pompă și au intrat în sala de audieri, împreună cu comandanții și cu cei mai de seamă din cetate, din porunca lui Festus, a fost adus Pavel. ");
INSERT INTO ronlsb_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festus a zis: “Împărate Agripa, și toți bărbații care sunt aici de față cu noi, vedeți pe acest om despre care toată mulțimea iudeilor mi-a făcut o petiție, atât la Ierusalim, cât și aici, strigând că nu trebuie să mai trăiască. ");
INSERT INTO ronlsb_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Dar când am constatat că nu a săvârșit nimic vrednic de moarte și cum el însuși a apelat la împărat, am hotărât să îl trimit pe el, ");
INSERT INTO ronlsb_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","despre care nu am nimic sigur de scris domnului meu. De aceea l-am adus în fața voastră și mai ales în fața ta, rege Agripa, pentru ca, după examinare, să am ce să scriu. ");
INSERT INTO ronlsb_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Căci mi se pare nerezonabil ca, trimițând un prizonier, să nu precizez și acuzațiile care i se aduc.” ");
INSERT INTO ronlsb_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agripa a zis lui Pavel: “Poți să vorbești în numele tău.” Atunci Pavel a întins mâna și a luat apărarea. ");
INSERT INTO ronlsb_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Mă consider fericit, rege Agripa, că astăzi îmi voi lua apărarea în fața ta cu privire la toate lucrurile de care sunt acuzat de iudei, ");
INSERT INTO ronlsb_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","mai ales că tu ești expert în toate obiceiurile și în toate chestiunile care există printre iudei. De aceea te rog să mă asculți cu răbdare. ");
INSERT INTO ronlsb_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Toți iudeii știu cum am trăit din tinerețe, de la început în neamul meu și la Ierusalim, ");
INSERT INTO ronlsb_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","și m-au cunoscut de la început, dacă vor să mărturisească, că am trăit ca fariseu după cea mai strictă sectă a religiei noastre. ");
INSERT INTO ronlsb_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Acum stau aici pentru a fi judecat pentru speranța promisiunii făcute de Dumnezeu părinților noștri, ");
INSERT INTO ronlsb_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","pe care cele douăsprezece triburi ale noastre, slujind cu sârguință zi și noapte, speră să o obțină. Cu privire la această speranță sunt acuzat de iudei, rege Agripa! ");
INSERT INTO ronlsb_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","De ce este judecat incredibil la tine dacă Dumnezeu învie morții? ");
INSERT INTO ronlsb_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Eu însumi am crezut cu adevărat că trebuie să fac multe lucruri potrivnice numelui lui Isus din Nazaret. ");
INSERT INTO ronlsb_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Am făcut și eu așa ceva la Ierusalim. Am închis deopotrivă pe mulți dintre sfinți în închisori, primind autoritate de la preoții cei mai de seamă, iar când au fost condamnați la moarte, mi-am dat votul împotriva lor. ");
INSERT INTO ronlsb_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Pedepsindu-i adesea în toate sinagogile, am încercat să-i fac să hulească. Fiind extrem de înfuriat împotriva lor, i-am persecutat până în cetăți străine. ");
INSERT INTO ronlsb_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Pe când călătoream spre Damasc, cu împuternicirea și însărcinarea preoților cei mai de seamă, ");
INSERT INTO ronlsb_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","la amiază, împărate, am văzut pe drum o lumină din cer, mai strălucitoare decât soarele, care strălucea în jurul meu și al celor ce călătoreau cu mine. ");
INSERT INTO ronlsb_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","După ce am căzut cu toții la pământ, am auzit o voce care îmi spunea în limba ebraică: “Saul, Saul, de ce mă prigonești? Îți este greu să lovești cu piciorul în ghiare'. ");
INSERT INTO ronlsb_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Și am zis: “Cine ești Tu, Doamne? “El a spus: “Eu sunt Isus, pe care voi Îl persecutați. ");
INSERT INTO ronlsb_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Dar ridică-te și stai în picioare, căci pentru aceasta m-am arătat ție: ca să te numesc slujitor și martor atât al lucrurilor pe care le-ai văzut, cât și al celor pe care ți le voi descoperi; ");
INSERT INTO ronlsb_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","să te eliberez de la popor și de la neamuri, la care te trimit, ");
INSERT INTO ronlsb_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","să le deschizi ochii, ca să se întoarcă de la întuneric la lumină și de la puterea lui Satana la Dumnezeu, ca să primească iertarea păcatelor și moștenirea între cei sfințiți prin credința în mine'. ");
INSERT INTO ronlsb_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“De aceea, împărate Agripa, n-am fost neascultător de viziunea cerească, ");
INSERT INTO ronlsb_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ci am vestit mai întâi celor din Damasc, la Ierusalim și în toată țara Iudeii, precum și neamurilor, că trebuie să se pocăiască și să se întoarcă la Dumnezeu, făcând fapte vrednice de pocăință. ");
INSERT INTO ronlsb_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Din acest motiv, iudeii m-au prins în templu și au încercat să mă ucidă. ");
INSERT INTO ronlsb_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","De aceea, după ce am obținut ajutorul care vine de la Dumnezeu, stau până în ziua de azi mărturisind atât celor mici, cât și celor mari, fără să spun nimic altceva decât ceea ce profeții și Moise au spus că se va întâmpla, ");
INSERT INTO ronlsb_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","cum trebuie să sufere Cristos și cum, prin învierea morților, el va fi cel dintâi care va vesti lumina atât acestui popor, cât și neamurilor.” ");
INSERT INTO ronlsb_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pe când se apăra el astfel, Festus a zis cu glas tare: “Pavel, ești nebun! Marea ta învățătură te face să înnebunești!” ");
INSERT INTO ronlsb_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Dar el a răspuns: “Nu sunt nebun, preafericite Festus, ci spun cu îndrăzneală cuvinte adevărate și rezonabile. ");
INSERT INTO ronlsb_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Căci împăratul știe aceste lucruri, căruia îi vorbesc și eu liber. Căci sunt convins că nici unul dintre aceste lucruri nu-i este ascuns, căci acest lucru nu s-a făcut într-un colț. ");
INSERT INTO ronlsb_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Împărate Agripa, crezi tu oare în profeți? Știu că tu crezi.” ");
INSERT INTO ronlsb_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agripa a zis lui Pavel: “Cu puțină convingere vrei să mă faci creștin?” ");
INSERT INTO ronlsb_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pavel a zis: “Rog pe Dumnezeu ca, fie cu puțin, fie cu mult, nu numai voi, ci și toți cei ce mă ascultă astăzi, să ajungeți la fel ca mine, afară de aceste legături.” ");
INSERT INTO ronlsb_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Împăratul s-a sculat, împreună cu guvernatorul, cu Bernice și cu cei ce stăteau cu ei. ");
INSERT INTO ronlsb_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","După ce s-au retras, au vorbit unul cu altul, zicând: “Omul acesta nu face nimic vrednic de moarte sau de legături.” ");
INSERT INTO ronlsb_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agrippa i-a spus lui Festus: “Omul acesta ar fi putut fi eliberat dacă nu ar fi apelat la Cezar.” ");
INSERT INTO ronlsb_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","După ce s-a hotărât să ne îmbarcăm spre Italia, au predat pe Pavel și pe alți prizonieri unui centurion numit Iulius, din trupa lui Augustan. ");
INSERT INTO ronlsb_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Îmbarcându-ne pe o corabie din Adramyttium, care urma să plece spre locuri de pe coasta Asiei, am pornit pe mare, cu noi fiind Aristarchus, un macedonean din Tesalonic. ");
INSERT INTO ronlsb_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","A doua zi, am atins Sidonul. Iulius s-a purtat cu Pavel cu bunăvoință și i-a dat voie să se ducă la prietenii săi și să se răcorească. ");
INSERT INTO ronlsb_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Plecând de acolo, am navigat sub vântul din Cipru, pentru că vânturile erau contrare. ");
INSERT INTO ronlsb_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","După ce am traversat marea care se află în largul Ciliciei și al Pamfiliei, am ajuns la Myra, un oraș din Licia. ");
INSERT INTO ronlsb_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Acolo, centurionul a găsit o corabie din Alexandria, care naviga spre Italia, și ne-a îmbarcat. ");
INSERT INTO ronlsb_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","După ce am navigat încet multe zile și am ajuns cu greu în fața Cnidului, vântul nepermițându-ne să mergem mai departe, am navigat sub vântul dinspre Creta, în fața Salmonei. ");
INSERT INTO ronlsb_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Navigând cu greu de-a lungul ei, am ajuns la un loc numit Fair Havens, lângă orașul Lasea. ");
INSERT INTO ronlsb_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","După ce trecuse mult timp și călătoria era deja periculoasă, pentru că trecuse deja Postul Mare, Pavel i-a sfătuit ");
INSERT INTO ronlsb_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","și le-a zis: “Domnilor, văd că această călătorie va fi cu pagube și cu multe pierderi, nu numai a încărcăturii și a corăbiei, ci și a vieții noastre.” ");
INSERT INTO ronlsb_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Dar centurionul a dat mai multă atenție stăpânului și proprietarului corabiei decât la cele spuse de Pavel. ");
INSERT INTO ronlsb_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Pentru că raiul nu era potrivit pentru a ierna, cei mai mulți au sfătuit să plece pe mare de acolo, dacă prin orice mijloace puteau să ajungă la Phoenix și să ierneze acolo, care este un port din Creta, privind spre sud-vest și nord-vest. ");
INSERT INTO ronlsb_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Când vântul de sud a suflat ușor, crezând că și-au atins scopul, au ridicat ancora și au navigat de-a lungul Cretei, aproape de țărm. ");
INSERT INTO ronlsb_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Dar, nu după mult timp, un vânt furtunos a bătut dinspre țărm, care se numește Euroclydon. ");
INSERT INTO ronlsb_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Când corabia a fost prinsă și nu a putut face față vântului, am cedat în fața lui și am fost împinși de-a lungul. ");
INSERT INTO ronlsb_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Alergând sub vântul unei mici insule numite Clauda, am reușit, cu greu, să asigurăm barca. ");
INSERT INTO ronlsb_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","După ce au ridicat-o, au folosit cabluri pentru a ajuta la consolidarea navei. Temându-se că vor eșua pe bancurile de nisip din Syrtis, au coborât ancora de mare și astfel au fost împinși de-a lungul. ");
INSERT INTO ronlsb_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","În timp ce ne chinuiam foarte mult cu furtuna, a doua zi au început să arunce lucruri peste bord. ");
INSERT INTO ronlsb_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","În a treia zi, au aruncat cu propriile mâini scufundările corăbiei. ");
INSERT INTO ronlsb_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Când nici soarele și nici stelele nu ne-au mai luminat timp de multe zile și nici o furtună mică nu ne apăsa, orice speranță că vom fi salvați era acum înlăturată. ");
INSERT INTO ronlsb_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","După ce au stat multă vreme fără mâncare, Pavel s-a ridicat în mijlocul lor și le-a zis: “Domnilor, trebuia să mă ascultați și să nu plecați din Creta, ca să nu vă alegeți cu această pagubă și cu această pierdere. ");
INSERT INTO ronlsb_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Acum vă îndemn să vă înveseliți, căci nu va fi nicio pierdere de vieți omenești printre voi, ci numai a corabiei. ");
INSERT INTO ronlsb_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Căci în această noapte a stat lângă mine un înger, care aparținea Dumnezeului al cărui sunt și căruia îi slujesc, ");
INSERT INTO ronlsb_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","și care mi-a spus: “Nu te teme, Paul. Trebuie să te prezinți în fața Cezarului. Iată, Dumnezeu ți-a acordat pe toți cei care navighează cu tine.” ");
INSERT INTO ronlsb_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Așadar, domnilor, înveseliți-vă! Căci eu cred în Dumnezeu, că va fi așa cum mi s-a spus. ");
INSERT INTO ronlsb_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Dar trebuie să eșuăm pe o anumită insulă.” ");
INSERT INTO ronlsb_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Dar, când a venit a paisprezecea noapte, pe când eram împinși de colo-colo în Marea Adriatică, pe la miezul nopții, marinarii au bănuit că se apropiau de un țărm. ");
INSERT INTO ronlsb_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Au făcut sondaje și au găsit douăzeci de brațe. După puțin timp, au făcut din nou sondaje și au găsit cincisprezece brazde. ");
INSERT INTO ronlsb_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Temându-se că vom eșua pe un teren stâncos, au aruncat patru ancore de la pupa și au dorit să se lumineze de ziuă. ");
INSERT INTO ronlsb_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","În timp ce marinarii încercau să fugă din corabie și coborâseră barca în mare, prefăcându-se că vor arunca ancorele de la prova, ");
INSERT INTO ronlsb_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Pavel le-a spus centurionului și soldaților: “Dacă aceștia nu rămân în corabie, nu puteți fi salvați.” ");
INSERT INTO ronlsb_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Atunci soldații au tăiat frânghiile bărcii și au lăsat-o să cadă. ");
INSERT INTO ronlsb_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Pe când se făcea ziuă, Pavel i-a rugat pe toți să ia ceva de mâncare, zicând: “Astăzi este a paisprezecea zi în care așteptați și postiți, fără să luați nimic. ");
INSERT INTO ronlsb_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","De aceea vă rog să luați ceva de mâncare, căci aceasta este pentru siguranța voastră, căci nu va pieri niciun fir de păr de pe capul niciunuia dintre voi.” ");
INSERT INTO ronlsb_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","După ce a spus acestea și a luat pâinea, a mulțumit lui Dumnezeu în fața tuturor; apoi a frânt-o și a început să mănânce. ");
INSERT INTO ronlsb_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Atunci toți s-au înveselit și au luat și ei mâncare. ");
INSERT INTO ronlsb_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","În total, eram două sute șaptezeci și șase de suflete pe corabie. ");
INSERT INTO ronlsb_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","După ce au mâncat destul, au ușurat corabia, aruncând grâul în mare. ");
INSERT INTO ronlsb_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Când s-a făcut ziuă, nu au recunoscut pământul, dar au observat un anumit golf cu o plajă și au decis să încerce să conducă corabia pe ea. ");
INSERT INTO ronlsb_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Aruncând ancorele, le-au lăsat în mare, dezlegând în același timp frânghiile cârmei. Ridicând trincheta în direcția vântului, s-au îndreptat spre plajă. ");
INSERT INTO ronlsb_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Dar, ajungând într-un loc unde se întâlneau două mări, au eșuat nava. Prora a lovit și a rămas nemișcată, dar pupa a început să se rupă din cauza violenței valurilor. ");
INSERT INTO ronlsb_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Sfatul ostașilor era să ucidă pe cei prizonieri, ca să nu mai înoate niciunul dintre ei și să scape. ");
INSERT INTO ronlsb_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Dar centurionul, vrând să-l salveze pe Pavel, i-a oprit din planul lor și a poruncit ca cei care știau să înoate să se arunce primii peste bord, ca să se îndrepte spre uscat; ");
INSERT INTO ronlsb_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","iar ceilalți să îi urmeze, unii pe scânduri și alții pe alte lucruri din corabie. Astfel au scăpat cu toții teferi spre uscat. ");
INSERT INTO ronlsb_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","După ce am scăpat, au aflat că insula se numea Malta. ");
INSERT INTO ronlsb_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Băștinașii ne-au arătat o bunătate ieșită din comun, căci au aprins un foc și ne-au primit pe toți, din cauza ploii de acum și din cauza frigului. ");
INSERT INTO ronlsb_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Dar când Pavel a strâns un mănunchi de bețe și le-a pus pe foc, o viperă a ieșit din cauza căldurii și s-a prins de mâna lui. ");
INSERT INTO ronlsb_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Când băștinașii au văzut creatura atârnând de mâna lui, și-au spus unii altora: “Fără îndoială că acest om este un ucigaș, pe care, deși a scăpat din mare, Justiția nu l-a lăsat să trăiască.” ");
INSERT INTO ronlsb_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Cu toate acestea, el a scuturat creatura în foc și nu a pățit nimic. ");
INSERT INTO ronlsb_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Ei se așteptau însă ca el să se fi umflat sau să fi căzut mort deodată, dar când au privit mult timp și au văzut că nu i s-a întâmplat nimic rău, s-au răzgândit și au spus că este un zeu. ");
INSERT INTO ronlsb_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","În împrejurimile acelui loc se aflau niște pământuri ale căpeteniei insulei, numită Publius, care ne-a primit și ne-a găzduit cu amabilitate timp de trei zile. ");
INSERT INTO ronlsb_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Tatăl lui Publius zăcea bolnav de febră și de dizenterie. Pavel a intrat la el, s-a rugat și, punându-și mâinile peste el, l-a vindecat. ");
INSERT INTO ronlsb_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","După ce s-a făcut acest lucru, au venit și ceilalți care aveau boli în insulă și s-au vindecat. ");
INSERT INTO ronlsb_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","De asemenea, ne-au onorat cu multe onoruri și, când am plecat, au pus la bord lucrurile de care aveam nevoie. ");
INSERT INTO ronlsb_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","După trei luni, am plecat cu o corabie din Alexandria care iernase pe insulă și care avea ca emblemă “Frații gemeni”. ");
INSERT INTO ronlsb_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Aterizând la Siracuza, am rămas acolo trei zile. ");
INSERT INTO ronlsb_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","De acolo am făcut un ocol și am ajuns la Rhegium. După o zi, a apărut un vânt dinspre sud și, a doua zi, am ajuns la Puteoli, ");
INSERT INTO ronlsb_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","unde am găsit frați și am fost rugați să rămânem cu ei timp de șapte zile. Astfel am ajuns la Roma. ");
INSERT INTO ronlsb_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","De acolo, frații, când au auzit de noi, au venit în întâmpinarea noastră până la Piața lui Appius și la Cele Trei Taverne. Când i-a văzut, Pavel a mulțumit lui Dumnezeu și a prins curaj. ");
INSERT INTO ronlsb_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Când am intrat în Roma, centurionul i-a predat pe prizonieri căpitanului gărzii, dar lui Pavel i s-a permis să rămână singur cu soldatul care îl păzea. ");
INSERT INTO ronlsb_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","După trei zile, Pavel a chemat laolaltă pe cei care erau conducătorii iudeilor. După ce s-au adunat, le-a zis: “Eu, fraților, deși nu făcusem nimic împotriva poporului și a obiceiurilor părinților noștri, am fost totuși dat prizonier din Ierusalim în mâinile romanilor, ");
INSERT INTO ronlsb_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","care, după ce m-au cercetat, au vrut să mă elibereze, pentru că nu era în mine nici o cauză de moarte. ");
INSERT INTO ronlsb_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Dar, când iudeii s-au opus, am fost nevoit să apelez la Cezar, nu că aș fi avut ceva de care să acuz națiunea mea. ");
INSERT INTO ronlsb_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","De aceea am cerut să te văd și să vorbesc cu tine. Căci, din cauza speranței lui Israel, sunt legat cu acest lanț.” ");
INSERT INTO ronlsb_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Ei I-au zis: “Nu am primit scrisori din Iudeea despre tine, și nici unul din frați n-a venit aici să ne spună sau să ne vorbească de rău despre tine. ");
INSERT INTO ronlsb_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Dar noi dorim să auzim de la tine ce crezi tu. Căci, în ceea ce privește această sectă, ne este cunoscut faptul că peste tot se vorbește împotriva ei.” ");
INSERT INTO ronlsb_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","După ce I-au dat o zi, a venit multă lume la El, la locuința lui. El le dădea explicații, mărturisind despre Împărăția lui Dumnezeu și convingându-i despre Isus, atât din Legea lui Moise, cât și din profeți, de dimineața până seara. ");
INSERT INTO ronlsb_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Unii credeau cele spuse, iar alții nu credeau. ");
INSERT INTO ronlsb_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Când nu s-au înțeles între ei, au plecat după ce Pavel a rostit un singur mesaj: “Duhul Sfânt a vorbit cu dreptate părinților noștri, prin profetul Isaia, ");
INSERT INTO ronlsb_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","spunând: “Du-te la acest popor și spune-i, în auz, veți auzi, dar nu va înțelege în nici un fel. Văzând, veți vedea, dar nu va percepe în nici un fel. ");
INSERT INTO ronlsb_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Căci inima acestui popor a devenit insensibilă. Urechile lor sunt surde de auz. Și-au închis ochii. Ca nu cumva să vadă cu ochii lor, aud cu urechile lor, să înțeleagă cu inima lor, și s-ar întoarce din nou, atunci îi voi vindeca. ");
INSERT INTO ronlsb_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","“Să știți deci că mântuirea lui Dumnezeu este trimisă la neamuri și ele vor asculta.” ");
INSERT INTO ronlsb_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","După ce a spus aceste cuvinte, iudeii au plecat, având între ei o mare ceartă. ");
INSERT INTO ronlsb_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pavel a stat doi ani întregi în casa lui închiriată, și primea pe toți cei ce veneau la el, ");
INSERT INTO ronlsb_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","propovăduind cu toată îndrăzneala, fără nici o opreliște, Împărăția lui Dumnezeu și învățând cele despre Domnul Isus Hristos. ");
INSERT INTO ronlsb_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Pavel, slujitor al lui Isus Hristos, chemat ca apostol, pus deoparte pentru vestea cea bună a lui Dumnezeu, ");
INSERT INTO ronlsb_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","pe care a făgăduit-o mai înainte prin proorocii Săi în Sfintele Scripturi, ");
INSERT INTO ronlsb_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","despre Fiul Său, născut din neamul lui David, după trup, ");
INSERT INTO ronlsb_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","care a fost declarat Fiul lui Dumnezeu cu putere, după Duhul sfințeniei, prin învierea din morți, Isus Hristos, Domnul nostru, ");
INSERT INTO ronlsb_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","prin care am primit harul și apostolatul pentru ascultarea credinței printre toate neamurile, pentru Numele Lui; ");
INSERT INTO ronlsb_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","printre care și voi sunteți chemați să aparțineți lui Isus Cristos; ");
INSERT INTO ronlsb_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","tuturor celor care sunt în Roma, iubiți de Dumnezeu, chemați să fie sfinți: Harul și pacea să vă fie vouă, de la Dumnezeu Tatăl nostru și de la Domnul Isus Hristos. ");
INSERT INTO ronlsb_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Mai întâi, mulțumesc Dumnezeului meu, prin Isus Hristos, pentru voi toți, pentru că credința voastră este vestită în toată lumea. ");
INSERT INTO ronlsb_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Căci martor îmi este Dumnezeu, căruia îi slujesc în duhul meu în Buna Vestire a Fiului său, cât de neîncetat fac mereu pomenirea voastră în rugăciunile mele, ");
INSERT INTO ronlsb_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","cerând, dacă acum, în sfârșit, prin voia lui Dumnezeu, să fiu învrednicit să ajung la voi. ");
INSERT INTO ronlsb_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Căci doresc mult să vă văd, ca să vă pot împărtăși vreun dar spiritual, pentru ca voi să fiți întăriți; ");
INSERT INTO ronlsb_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","adică, ca eu împreună cu voi să fiu încurajat în voi, fiecare dintre noi prin credința celuilalt, atât a voastră, cât și a mea. ");
INSERT INTO ronlsb_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Și nu vreau să nu știți, fraților, că de multe ori am plănuit să vin la voi, dar am fost împiedicat până acum, ca să aduc rod și printre voi, ca și printre celelalte neamuri. ");
INSERT INTO ronlsb_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Sunt dator atât grecilor, cât și străinilor, atât celor înțelepți, cât și celor nebuni. ");
INSERT INTO ronlsb_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Așadar, atât cât este în mine, sunt nerăbdător să propovăduiesc vestea cea bună și vouă, care sunteți în Roma. ");
INSERT INTO ronlsb_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Căci nu mi-e rușine de vestea cea bună a lui Hristos, pentru că ea este puterea lui Dumnezeu pentru mântuirea fiecăruia care crede, mai întâi a iudeilor și apoi a grecilor. ");
INSERT INTO ronlsb_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Căci în ea se descoperă dreptatea lui Dumnezeu, din credință în credință. După cum este scris: “Dar cel neprihănit va trăi prin credință”. ");
INSERT INTO ronlsb_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Căci mânia lui Dumnezeu se arată din ceruri împotriva oricărei nelegiuiri și nedreptăți a oamenilor care înăbușă adevărul în nedreptate, ");
INSERT INTO ronlsb_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","pentru că ceea ce este cunoscut de Dumnezeu se arată în ei, căci Dumnezeu le-a descoperit. ");
INSERT INTO ronlsb_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Căci lucrurile invizibile ale Lui, de la crearea lumii, se văd în mod clar, fiind percepute prin lucrurile care sunt făcute, adică puterea Lui veșnică și divinitatea Lui, pentru ca ei să fie fără scuză. ");
INSERT INTO ronlsb_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Pentru că, cunoscând pe Dumnezeu, nu L-au slăvit ca Dumnezeu și nu I-au adus mulțumiri, ci au devenit deșerți în raționamentul lor și inima lor fără minte s-a întunecat. ");
INSERT INTO ronlsb_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Și, făcându-se înțelepți, s-au făcut nebuni, ");
INSERT INTO ronlsb_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","și au schimbat slava Dumnezeului cel neînsuflețit cu asemănarea unui chip de om coruptibil, de păsări, de patrupede și de târâtoare. ");
INSERT INTO ronlsb_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","De aceea, Dumnezeu i-a și predat, în poftele inimilor lor, la necurăție, pentru ca trupurile lor să fie dezonorate între ei; ");
INSERT INTO ronlsb_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","care au schimbat adevărul lui Dumnezeu cu minciuna și s-au închinat și au slujit mai degrabă creaturii decât Creatorului, care este binecuvântat în veci. Amin. ");
INSERT INTO ronlsb_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","De aceea Dumnezeu i-a lăsat să se lase pradă patimilor josnice. Căci femeile lor au schimbat funcția naturală în ceea ce este împotriva naturii. ");
INSERT INTO ronlsb_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","La fel și bărbații, părăsind funcția naturală a femeii, s-au aprins în poftele lor unii față de alții, bărbații făcând ceea ce este nepotrivit cu bărbații și primind în ei înșiși pedeapsa cuvenită pentru greșeala lor. ");
INSERT INTO ronlsb_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Chiar dacă au refuzat să-L aibă pe Dumnezeu în cunoștința lor, Dumnezeu i-a predat unei minți reprobabile, ca să facă ceea ce nu se cuvine; ");
INSERT INTO ronlsb_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","fiind plini de toată nedreptatea, de imoralitate sexuală, de răutate, de lăcomie, de răutate; plini de invidie, de crimă, de ceartă, de înșelăciune, de obiceiuri rele, calomniatori în secret, ");
INSERT INTO ronlsb_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","hulitori, urâcioși față de Dumnezeu, obraznici, aroganți, lăudăroși, inventatori de lucruri rele, neascultători față de părinți, ");
INSERT INTO ronlsb_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","lipsiți de înțelegere, călcători de legământ, fără afecțiune firească, neiertători, nemiloși; ");
INSERT INTO ronlsb_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","care, cunoscând rânduiala lui Dumnezeu, că cei care practică astfel de lucruri sunt vrednici de moarte, nu numai că fac același lucru, dar și aprobă pe cei care le practică. ");
INSERT INTO ronlsb_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","De aceea, omule, oricine ai fi tu, care judeci, ești fără prihană. Căci în ceea ce judeci pe altul, te osândești pe tine însuți. Căci tu, care judeci, practici aceleași lucruri. ");
INSERT INTO ronlsb_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Noi știm că judecata lui Dumnezeu este conformă cu adevărul împotriva celor care practică astfel de lucruri. ");
INSERT INTO ronlsb_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Crezi tu, omule, care judeci pe cei care practică astfel de lucruri și faci la fel, că vei scăpa de judecata lui Dumnezeu? ");
INSERT INTO ronlsb_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Sau disprețuiești tu bogăția bunătății, a îngăduinței și a răbdării Lui, fără să știi că bunătatea lui Dumnezeu te conduce la pocăință? ");
INSERT INTO ronlsb_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Ci, după împietrirea voastră și inima voastră neîmpăcată, vă strângeți pentru voi înșivă mânie în ziua mâniei, a revelației și a dreptei judecăți a lui Dumnezeu, ");
INSERT INTO ronlsb_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","care “va răsplăti fiecăruia după faptele sale”. ");
INSERT INTO ronlsb_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","celor care, prin perseverența în binele făcut, caută gloria, onoarea și incoruptibilitatea, viața veșnică; ");
INSERT INTO ronlsb_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","dar celor care sunt egoiști și nu ascultă de adevăr, ci ascultă de nedreptate, le va fi mânia, indignarea, ");
INSERT INTO ronlsb_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","asuprirea și chinul asupra oricărui suflet de om care face răul, mai întâi iudeilor și apoi grecilor. ");
INSERT INTO ronlsb_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Dar slava, cinstea și pacea sunt pentru orice om care face binele, mai întâi pentru iudeu și apoi pentru grec. ");
INSERT INTO ronlsb_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Căci la Dumnezeu nu este părtinire. ");
INSERT INTO ronlsb_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Căci toți cei ce au păcătuit fără lege vor pieri și fără lege. Toți cei care au păcătuit sub Lege vor fi judecați prin Lege. ");
INSERT INTO ronlsb_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Căci nu ascultătorii legii sunt cei care sunt drepți înaintea lui Dumnezeu, ci cei care împlinesc legea vor fi îndreptățiți ");
INSERT INTO ronlsb_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","(pentru că atunci când neamurile care nu au legea fac prin natură lucrurile legii, aceștia, neavând legea, sunt o lege pentru ei înșiși, ");
INSERT INTO ronlsb_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","prin faptul că arată lucrarea legii scrisă în inimile lor, conștiința lor mărturisind cu ei, iar gândurile lor între ei acuzându-i sau dimpotrivă scuzându-i) ");
INSERT INTO ronlsb_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","în ziua în care Dumnezeu va judeca tainele oamenilor, potrivit cu Buna Vestire a mea, prin Isus Hristos. ");
INSERT INTO ronlsb_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Tu porți numele de iudeu, te sprijini pe Lege, te lauzi în Dumnezeu, ");
INSERT INTO ronlsb_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","cunoști voia Lui și aprobi lucrurile bune, fiind învățat din Lege, ");
INSERT INTO ronlsb_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","și ești încredințat că tu însuți ești călăuză orbilor, lumină pentru cei ce sunt în întuneric, ");
INSERT INTO ronlsb_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","îndrumător al celor nebuni, învățător al copiilor, având în Lege forma cunoștinței și a adevărului. ");
INSERT INTO ronlsb_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Așadar, tu, care înveți pe altul, nu te înveți și pe tine însuți? Tu, care propovăduiești că omul nu trebuie să fure, tu furi? ");
INSERT INTO ronlsb_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Tu, care spui că un om nu trebuie să comită adulter, comiți tu adulter? Voi, care aveți în ură idolii, jefuiți templele? ");
INSERT INTO ronlsb_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Voi, care vă lăudați cu legea, îl dezonorați pe Dumnezeu prin nerespectarea legii? ");
INSERT INTO ronlsb_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Căci “numele lui Dumnezeu este hulit printre neamuri din cauza voastră”, așa cum este scris. ");
INSERT INTO ronlsb_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Căci, într-adevăr, circumcizia este de folos, dacă ești împlinitor al legii, dar dacă ești călcător al legii, circumcizia ta a devenit necircumcizie. ");
INSERT INTO ronlsb_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Așadar, dacă cel netăiat împrejur ține rânduielile Legii, nu cumva netăierea lui împrejur nu va fi socotită ca fiind circumcizie? ");
INSERT INTO ronlsb_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Nu te vor judeca oare pe tine, care cu litera și cu circumcizia ești un călcător de lege, cei care sunt fizic netăiați împrejur, dar care împlinesc legea? ");
INSERT INTO ronlsb_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Căci nu este iudeu cel care este unul în afară, nici circumcizia care este exterioară în carne; ");
INSERT INTO ronlsb_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","ci este iudeu cel care este unul înăuntru, iar circumcizia este cea a inimii, în duh, nu în literă; a cărui laudă nu vine de la oameni, ci de la Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Atunci ce avantaj are evreul? Sau care este folosul circumciziei? ");
INSERT INTO ronlsb_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Mult în toate privințele! Pentru că, mai întâi de toate, li s-au încredințat revelațiile lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Căci ce s-ar întâmpla dacă unii ar fi fără credință? Oare lipsa lor de credință va anula credincioșia lui Dumnezeu? ");
INSERT INTO ronlsb_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Să nu se întâmple niciodată! Da, să fie găsit Dumnezeu adevărat, dar orice om mincinos. După cum este scris, “pentru ca să fiți îndreptățiți în cuvintele voastre, și ar putea să prevaleze atunci când veți veni la judecată.” ");
INSERT INTO ronlsb_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Dar dacă neprihănirea noastră face să se recunoască neprihănirea lui Dumnezeu, ce vom spune? Este nedrept Dumnezeu care provoacă mânie? Vorbesc așa cum vorbesc oamenii. ");
INSERT INTO ronlsb_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Să nu se întâmple niciodată! Căci atunci cum va judeca Dumnezeu lumea? ");
INSERT INTO ronlsb_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Căci dacă adevărul lui Dumnezeu, prin minciuna mea, a abundat spre gloria lui, de ce sunt și eu judecat tot ca păcătos? ");
INSERT INTO ronlsb_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","De ce nu (așa cum se spune în mod calomnios și cum afirmă unii că spunem): “Să facem răul, ca să vină binele?”? Cei care spun așa sunt condamnați pe bună dreptate. ");
INSERT INTO ronlsb_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Și atunci, ce se întâmplă? Suntem noi mai buni decât ei? Nu, în niciun caz. Căci noi i-am avertizat anterior atât pe iudei, cât și pe greci, că toți sunt sub păcat. ");
INSERT INTO ronlsb_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","După cum este scris, “Nu este nimeni neprihănit; nu, nici unul. ");
INSERT INTO ronlsb_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Nu este nimeni care să înțeleagă. Nu există nimeni care să-L caute pe Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Toți s-au îndepărtat. Împreună au devenit neprofitabile. Nu există nimeni care să facă binele, nu, nici măcar unul.” ");
INSERT INTO ronlsb_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","“Gâtul lor este un mormânt deschis. Cu limbile lor au folosit înșelăciunea.” “Otrava viperelor este sub buzele lor.” ");
INSERT INTO ronlsb_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","“Gura lor este plină de blestem și de amărăciune.” ");
INSERT INTO ronlsb_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Picioarele lor sunt iuți la vărsarea sângelui. ");
INSERT INTO ronlsb_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Distrugerea și nenorocirea sunt în căile lor. ");
INSERT INTO ronlsb_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Calea păcii, ei nu au cunoscut-o.” ");
INSERT INTO ronlsb_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","“Nu este frică de Dumnezeu înaintea ochilor lor.” ");
INSERT INTO ronlsb_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Și știm că tot ce spune Legea vorbește celor ce sunt sub Lege, pentru ca orice gură să fie închisă și toată lumea să fie supusă judecății lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Fiindcă prin faptele Legii, nicio făptură nu va fi îndreptățită înaintea Lui; căci prin Lege vine cunoașterea păcatului. ");
INSERT INTO ronlsb_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Dar acum, afară de Lege, s-a descoperit o neprihănire a lui Dumnezeu, mărturisită prin Lege și prin prooroci, ");
INSERT INTO ronlsb_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","neprihănirea lui Dumnezeu prin credința în Isus Hristos, pentru toți și pentru toți cei ce cred. Căci nu este nicio deosebire, ");
INSERT INTO ronlsb_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","căci toți au păcătuit și sunt lipsiți de gloria lui Dumnezeu; ");
INSERT INTO ronlsb_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","fiind îndreptățiți gratuit prin harul său, prin răscumpărarea care este în Isus Cristos, ");
INSERT INTO ronlsb_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","pe care Dumnezeu l-a trimis ca jertfă de ispășire prin credința în sângele său, pentru o demonstrație a dreptății sale prin trecerea peste păcatele anterioare, în îngăduința lui Dumnezeu; ");
INSERT INTO ronlsb_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","pentru a demonstra dreptatea sa în timpul prezent, pentru ca el însuși să fie drept și justițiarul celui care are credință în Isus. ");
INSERT INTO ronlsb_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Atunci unde este lăudăroșenia? Ea este exclusă. Prin ce fel de lege? A faptelor? Nu, ci printr-o lege a credinței. ");
INSERT INTO ronlsb_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Susținem deci că omul este justificat prin credință, fără faptele legii. ");
INSERT INTO ronlsb_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Sau Dumnezeu este oare numai Dumnezeul iudeilor? Nu este el Dumnezeul și al neamurilor? Ba da, și al neamurilor, ");
INSERT INTO ronlsb_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","de vreme ce, într-adevăr, există un singur Dumnezeu care va justifica pe cei tăiați împrejur prin credință și pe cei netăiați împrejur prin credință. ");
INSERT INTO ronlsb_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","În acest caz, anulăm noi Legea prin credință? Să nu se întâmple niciodată! Nu, noi stabilim legea. ");
INSERT INTO ronlsb_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Atunci ce vom spune că Avraam, strămoșul nostru, a găsit după trup? ");
INSERT INTO ronlsb_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Căci, dacă Avraam a fost îndreptățit prin fapte, are cu ce să se laude, dar nu față de Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Căci ce spune Scriptura? “Avraam a crezut pe Dumnezeu și i s-a socotit ca neprihănire.” ");
INSERT INTO ronlsb_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Or, pentru cel care lucrează, răsplata nu este socotită ca un har, ci ca ceva datorat. ");
INSERT INTO ronlsb_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Dar celui care nu lucrează, ci crede în Cel care justifică pe cei neevlavioși, credința lui este socotită drept dreptate. ");
INSERT INTO ronlsb_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Așa cum și David pronunță binecuvântarea asupra omului căruia Dumnezeu îi socotește dreptate în afară de fapte: ");
INSERT INTO ronlsb_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Ferice de cei cărora li se iartă fărădelegile, ale căror păcate sunt acoperite. ");
INSERT INTO ronlsb_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Binecuvântat este omul pe care Domnul nu-l va acuza de păcat.” ");
INSERT INTO ronlsb_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Este deci binecuvântarea aceasta numai pentru cei tăiați împrejur, sau și pentru cei netăiați împrejur? Căci noi spunem că credința i-a fost socotită lui Avraam ca neprihănire. ");
INSERT INTO ronlsb_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Cum a fost deci socotită? Când era în circumcizie, sau în necircumcizie? Nu în circumcizie, ci în necircumcizie. ");
INSERT INTO ronlsb_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","El a primit semnul circumciziei, ca pecete a neprihănirii credinței pe care o avea când era în necircumcizie, ca să fie tatăl tuturor celor ce cred, chiar dacă sunt în necircumcizie, pentru ca și lor să li se socotească neprihănirea. ");
INSERT INTO ronlsb_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","El este tatăl circumciziei pentru cei care nu numai că sunt din circumcizie, dar care și umblă pe urmele acelei credințe a tatălui nostru Avraam, pe care el a avut-o în necircumcizie. ");
INSERT INTO ronlsb_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Căci făgăduința făcută lui Avraam și urmașilor lui, că el va fi moștenitorul lumii, nu a fost făcută prin lege, ci prin neprihănirea credinței. ");
INSERT INTO ronlsb_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Căci, dacă moștenitorii sunt cei ce țin de Lege, credința se anulează și făgăduința rămâne fără efect. ");
INSERT INTO ronlsb_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Căci legea produce mânie; căci unde nu este lege, nu este nici neascultare. ");
INSERT INTO ronlsb_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","De aceea este din credință, ca să fie după har, pentru ca făgăduința să fie sigură pentru toți urmașii, nu numai pentru cei din lege, ci și pentru cei din credința lui Avraam, care este tatăl nostru al tuturor. ");
INSERT INTO ronlsb_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","După cum este scris: “Te-am făcut tatăl multor neamuri”. Aceasta în prezența celui în care a crezut: Dumnezeu, care dă viață celor morți și numește lucrurile care nu sunt, ca și cum ar fi. ");
INSERT INTO ronlsb_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Împotriva nădejdii, Avraam a crezut în nădejde, ca să devină tatăl multor neamuri, potrivit cu ceea ce fusese spus: “Așa va fi urmașul tău”. ");
INSERT INTO ronlsb_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Fără să slăbească în credință, el nu s-a gândit la propriul său trup, care era deja uzat (el fiind în vârstă de aproape o sută de ani), și la moartea pântecelui Sarei. ");
INSERT INTO ronlsb_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Cu toate acestea, privind la promisiunea lui Dumnezeu, el nu s-a clătinat din necredință, ci s-a întărit prin credință, dând slavă lui Dumnezeu ");
INSERT INTO ronlsb_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","și fiind pe deplin încredințat că ceea ce promisese, era și în stare să împlinească. ");
INSERT INTO ronlsb_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","De aceea și acest lucru i-a fost “creditat ca neprihănire”. ");
INSERT INTO ronlsb_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Or, nu a fost scris că i s-a socotit numai pentru el, ");
INSERT INTO ronlsb_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","ci și pentru noi, cărora li se va socoti, care credem în cel care l-a înviat din morți pe Isus, Domnul nostru, ");
INSERT INTO ronlsb_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","care a fost dat pentru greșelile noastre și a înviat pentru îndreptățirea noastră. ");
INSERT INTO ronlsb_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Deci, fiind îndreptățiți prin credință, avem pace cu Dumnezeu, prin Domnul nostru Isus Hristos, ");
INSERT INTO ronlsb_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","prin care, de asemenea, avem acces prin credință la acest har în care stăm. Ne bucurăm în speranța gloriei lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Și nu numai atât, ci ne bucurăm și în suferințele noastre, știind că suferința produce perseverență; ");
INSERT INTO ronlsb_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","iar perseverența, caracter dovedit; iar caracterul dovedit, speranță; ");
INSERT INTO ronlsb_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","iar speranța nu ne dezamăgește, pentru că dragostea lui Dumnezeu a fost revărsată în inimile noastre prin Duhul Sfânt care ne-a fost dat. ");
INSERT INTO ronlsb_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Căci, pe când eram noi încă slabi, Hristos a murit la vremea potrivită pentru cei nelegiuiți. ");
INSERT INTO ronlsb_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Căci cu greu va muri cineva pentru un om neprihănit. Totuși, poate că pentru un om bun cineva chiar va îndrăzni să moară. ");
INSERT INTO ronlsb_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Dar Dumnezeu Își recomandă dragostea față de noi, prin faptul că, pe când eram încă păcătoși, Hristos a murit pentru noi. ");
INSERT INTO ronlsb_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Cu atât mai mult, fiind acum îndreptățiți prin sângele Lui, vom fi mântuiți prin El de mânia lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Căci dacă, pe când eram vrăjmași, am fost împăcați cu Dumnezeu prin moartea Fiului Său, cu atât mai mult, fiind împăcați, vom fi mântuiți prin viața lui. ");
INSERT INTO ronlsb_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Și nu numai atât, ci ne și bucurăm în Dumnezeu prin Domnul nostru Isus Hristos, prin care am primit acum împăcarea. ");
INSERT INTO ronlsb_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Așadar, după cum păcatul a intrat în lume printr-un singur om și moartea prin păcat, tot așa și moartea a trecut la toți oamenii, pentru că toți au păcătuit. ");
INSERT INTO ronlsb_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Căci, până la apariția Legii, păcatul era în lume; dar păcatul nu este acuzat când nu există Legea. ");
INSERT INTO ronlsb_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Cu toate acestea, moartea a domnit de la Adam până la Moise, chiar și peste cei ale căror păcate nu au fost ca neascultarea lui Adam, care este o prefigurare a celui ce avea să vină. ");
INSERT INTO ronlsb_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Dar darul gratuit nu este ca și fărădelegea. Căci, dacă prin greșeala unuia singur au murit cei mulți, cu atât mai mult harul lui Dumnezeu și darul prin harul unui singur om, Isus Hristos, a abundat pentru cei mulți. ");
INSERT INTO ronlsb_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Darul nu este ca prin unul singur care a păcătuit; căci judecata a venit prin unul singur spre osândă, dar darul gratuit a urmat multor fărădelegi spre îndreptățire. ");
INSERT INTO ronlsb_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Căci, dacă prin fărădelegea unuia singur a domnit moartea prin unul singur, cu atât mai mult cei care primesc abundența harului și a darului neprihănirii vor domni în viață prin unul singur, Isus Hristos. ");
INSERT INTO ronlsb_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Astfel, după cum, printr-o singură fărădelege, toți oamenii au fost condamnați, tot așa, printr-o singură faptă de dreptate, toți oamenii au fost îndreptățiți pentru viață. ");
INSERT INTO ronlsb_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Căci, după cum prin neascultarea unui singur om, mulți au fost făcuți păcătoși, tot așa, prin ascultarea unuia singur, mulți vor fi făcuți neprihăniți. ");
INSERT INTO ronlsb_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Legea a venit pentru ca fărădelegea să abunde; dar acolo unde a abundat păcatul, harul a abundat și mai mult, ");
INSERT INTO ronlsb_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","pentru ca, după cum păcatul a domnit în moarte, tot așa harul să domnească prin dreptate pentru viața veșnică, prin Isus Hristos, Domnul nostru. ");
INSERT INTO ronlsb_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Ce să spunem atunci? Să continuăm în păcat, pentru ca harul să abunde? ");
INSERT INTO ronlsb_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Să nu se întâmple niciodată! Noi, care am murit față de păcat, cum am mai putea trăi în el? ");
INSERT INTO ronlsb_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Sau nu știți că noi toți cei care am fost botezați în Hristos Isus am fost botezați în moartea lui? ");
INSERT INTO ronlsb_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Am fost deci îngropați împreună cu el prin botez în moarte, pentru ca, după cum Hristos a înviat din morți prin gloria Tatălui, tot așa și noi să umblăm într-o viață nouă. ");
INSERT INTO ronlsb_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Căci, dacă ne-am unit cu El în asemănarea morții Lui, vom fi și noi părtași la învierea Lui, ");
INSERT INTO ronlsb_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","știind că omul nostru cel vechi a fost răstignit împreună cu El, pentru ca trupul păcatului să fie desființat, ca să nu mai fim robi ai păcatului. ");
INSERT INTO ronlsb_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Căci cel care a murit a fost eliberat de păcat. ");
INSERT INTO ronlsb_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Dar dacă am murit împreună cu Hristos, credem că și noi vom trăi împreună cu el, ");
INSERT INTO ronlsb_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","știind că Hristos, înviind din morți, nu mai moare. Moartea nu mai are stăpânire asupra lui! ");
INSERT INTO ronlsb_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Căci moartea în care a murit, a murit o singură dată pentru păcat; dar viața pe care o trăiește, trăiește pentru Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Astfel, considerați-vă și voi înșivă ca fiind morți față de păcat, dar vii pentru Dumnezeu în Hristos Isus, Domnul nostru. ");
INSERT INTO ronlsb_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","De aceea, nu lăsați păcatul să domnească în trupul vostru muritor, ca să-l ascultați în poftele lui. ");
INSERT INTO ronlsb_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","De asemenea, nu vă prezentați membrele voastre păcatului ca instrumente ale nedreptății, ci prezentați-vă lui Dumnezeu ca vii din morți, iar membrele voastre ca instrumente ale dreptății pentru Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Căci păcatul nu va avea stăpânire asupra voastră, pentru că nu sunteți sub lege, ci sub har. ");
INSERT INTO ronlsb_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Și atunci, ce se întâmplă? Să păcătuim pentru că nu suntem sub lege, ci sub har? Să nu se întâmple niciodată! ");
INSERT INTO ronlsb_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Nu știți că, atunci când vă prezentați ca niște robi și ascultați de cineva, sunteți robii celui de care ascultați, fie de păcat spre moarte, fie de ascultare spre dreptate? ");
INSERT INTO ronlsb_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Dar mulțumim lui Dumnezeu că, în timp ce erați robi ai păcatului, ați devenit ascultători din inimă față de acea formă de învățătură la care ați fost predați. ");
INSERT INTO ronlsb_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Fiind eliberați de păcat, ați devenit robi ai neprihănirii. ");
INSERT INTO ronlsb_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Vorbesc în termeni omenești, din pricina slăbiciunii cărnii voastre; căci, după cum v-ați prezentat mădularele ca robi ai necurăției și ai răutății peste răutăți, tot așa acum prezentați mădularele voastre ca robi ai neprihănirii pentru sfințire. ");
INSERT INTO ronlsb_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Căci atunci când erați robi ai păcatului, erați liberi de neprihănire. ");
INSERT INTO ronlsb_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Ce roade aveați deci atunci în lucrurile de care vă rușinați acum? Căci sfârșitul acelor lucruri este moartea. ");
INSERT INTO ronlsb_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Dar acum, fiind eliberați de păcat și deveniți robi ai lui Dumnezeu, aveți rodul sfințirii și rezultatul vieții veșnice. ");
INSERT INTO ronlsb_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Căci plata păcatului este moartea, dar darul gratuit al lui Dumnezeu este viața veșnică în Hristos Isus, Domnul nostru. ");
INSERT INTO ronlsb_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Sau nu știți voi, fraților, căci vorbesc cu oameni care cunosc Legea, că Legea stăpânește asupra omului cât trăiește el? ");
INSERT INTO ronlsb_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Căci femeia care are un soț este legată prin lege de soț cât trăiește el, dar dacă soțul moare, ea este eliberată de legea soțului. ");
INSERT INTO ronlsb_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Deci, dacă, cât timp trăiește soțul, ea se unește cu un alt bărbat, ar fi numită adulteră. Dar dacă soțul moare, ea este eliberată de legea soțului, astfel că nu este adulteră, deși este unită cu un alt bărbat. ");
INSERT INTO ronlsb_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Așadar, frații mei, și voi ați fost făcuți morți față de Lege prin trupul lui Hristos, ca să vă uniți cu altul, cu Cel înviat din morți, ca să producem roade pentru Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Căci, atunci când eram în carne, patimile păcătoase care erau prin lege lucrau în membrele noastre pentru a produce roade spre moarte. ");
INSERT INTO ronlsb_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Dar acum am fost eliberați de Lege, după ce am murit față de cea în care eram ținuți, astfel încât slujim în noutatea duhului, și nu în vechimea literei. ");
INSERT INTO ronlsb_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Ce vom spune atunci? Este legea păcat? Să nu fie niciodată! Cu toate acestea, nu aș fi cunoscut păcatul decât prin lege. Căci nu aș fi cunoscut pofta dacă legea nu ar fi spus: “Să nu poftești”. ");
INSERT INTO ronlsb_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Dar păcatul, găsind prilej prin poruncă, a produs în mine tot felul de pofte. Căci, în afara legii, păcatul este mort. ");
INSERT INTO ronlsb_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","În afară de Lege, am fost odată viu, dar când a venit porunca, păcatul a reînviat și am murit. ");
INSERT INTO ronlsb_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Porunca, care era pentru viață, am aflat că este pentru moarte; ");
INSERT INTO ronlsb_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","căci păcatul, găsind prilej prin poruncă, m-a înșelat și prin ea m-a omorât. ");
INSERT INTO ronlsb_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","De aceea, Legea este cu adevărat sfântă și porunca sfântă, dreaptă și bună. ");
INSERT INTO ronlsb_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Deci ceea ce este bun a devenit pentru mine moarte? Să nu fie niciodată! Dar păcatul, ca să se arate că este păcat, producea moarte în mine prin ceea ce este bun, pentru ca prin poruncă păcatul să devină peste măsură de păcătos. ");
INSERT INTO ronlsb_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Căci știm că Legea este spirituală, dar eu sunt trupesc, vândut sub păcat. ");
INSERT INTO ronlsb_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Căci nu înțeleg ce fac. Căci nu practic ceea ce doresc să fac, ci ceea ce urăsc, aceea fac. ");
INSERT INTO ronlsb_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Dar dacă ceea ce nu doresc, aceea fac, consimt Legii că este bună. ");
INSERT INTO ronlsb_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Deci acum nu mai sunt eu cel care o face, ci păcatul care locuiește în mine. ");
INSERT INTO ronlsb_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Căci știu că în mine, adică în carnea mea, nu locuiește nimic bun. Căci dorința este prezentă la mine, dar nu o găsesc făcând ceea ce este bun. ");
INSERT INTO ronlsb_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Căci binele pe care-l doresc, nu-l fac; dar răul pe care nu-l doresc, pe acela îl practic. ");
INSERT INTO ronlsb_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Dar dacă ceea ce nu doresc, fac, nu mai sunt eu cel care face, ci păcatul care locuiește în mine. ");
INSERT INTO ronlsb_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Găsesc deci legea că, în timp ce eu doresc să fac binele, răul este prezent. ");
INSERT INTO ronlsb_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Căci eu mă bucur de legea lui Dumnezeu după cele lăuntrice, ");
INSERT INTO ronlsb_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","dar văd în mădularele mele o lege diferită, care se luptă împotriva legii minții mele și mă aduce în captivitate sub legea păcatului care este în mădularele mele. ");
INSERT INTO ronlsb_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Ce om nenorocit sunt eu! Cine mă va izbăvi din trupul acestei morți? ");
INSERT INTO ronlsb_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Mulțumesc lui Dumnezeu prin Isus Hristos, Domnul nostru! Așadar, cu mintea, eu însumi slujesc legii lui Dumnezeu, dar cu carnea, legii păcatului. ");
INSERT INTO ronlsb_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Așadar, acum nu este nici o condamnare pentru cei ce sunt în Hristos Isus, care nu umblă după trup, ci după Duhul. ");
INSERT INTO ronlsb_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Căci legea Duhului de viață în Hristos Isus m-a făcut liber de legea păcatului și a morții. ");
INSERT INTO ronlsb_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Căci ceea ce nu putea face legea, fiindcă era slabă prin carne, Dumnezeu a făcut, trimițându-și propriul Fiu în chip de carne păcătoasă și pentru păcat, a condamnat păcatul în carne, ");
INSERT INTO ronlsb_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","pentru ca rânduiala legii să fie împlinită în noi, care nu umblăm după carne, ci după Duhul. ");
INSERT INTO ronlsb_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Căci cei care trăiesc după trup își pun mintea la lucrurile trupului, dar cei care trăiesc după Duhul, la lucrurile Duhului. ");
INSERT INTO ronlsb_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Căci mintea cărnii este moarte, dar mintea Duhului este viață și pace; ");
INSERT INTO ronlsb_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","pentru că mintea cărnii este ostilă lui Dumnezeu, deoarece nu se supune legii lui Dumnezeu și nici nu poate fi. ");
INSERT INTO ronlsb_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Cei care sunt în carne nu pot să placă lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Dar voi nu sunteți în carne, ci în Duh, dacă Duhul lui Dumnezeu locuiește în voi. Dar dacă cineva nu are Duhul lui Hristos, nu este al lui. ");
INSERT INTO ronlsb_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Dacă Hristos este în voi, trupul este mort din pricina păcatului, dar spiritul este viu din pricina neprihănirii. ");
INSERT INTO ronlsb_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Dar dacă Duhul celui care l-a înviat pe Isus din morți locuiește în voi, cel care l-a înviat pe Isus Hristos din morți va da viață și trupurilor voastre muritoare, prin Duhul Său care locuiește în voi. ");
INSERT INTO ronlsb_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Deci, fraților, nu suntem datori să trăim după trup, ca să trăim după trup. ");
INSERT INTO ronlsb_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Căci, dacă trăiți după trup, trebuie să muriți; dar dacă, prin Duhul, faceți să moară faptele trupului, veți trăi. ");
INSERT INTO ronlsb_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Căci toți cei ce sunt călăuziți de Duhul lui Dumnezeu, aceștia sunt copiii lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Căci nu ați primit din nou duhul robiei pentru frică, ci ați primit Duhul adopției, prin care strigăm: “Abba! Tată!” ");
INSERT INTO ronlsb_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Însuși Duhul mărturisește cu duhul nostru că suntem copii ai lui Dumnezeu; ");
INSERT INTO ronlsb_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","și, dacă suntem copii, suntem și moștenitori, moștenitori ai lui Dumnezeu și împreună-moștenitori cu Hristos, dacă suferim împreună cu El, ca să fim și noi proslăviți împreună cu El. ");
INSERT INTO ronlsb_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Căci consider că suferințele de acum nu sunt vrednice de comparație cu slava care se va arăta față de noi. ");
INSERT INTO ronlsb_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Căci creația așteaptă cu nerăbdare arătarea copiilor lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Căci creația a fost supusă deșertăciunii, nu din voia ei, ci din cauza celui care a supus-o, în speranța ");
INSERT INTO ronlsb_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","că și creația însăși va fi eliberată din robia stricăciunii în libertatea gloriei copiilor lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Căci știm că întreaga creație geme și se chinuiește în dureri împreună până acum. ");
INSERT INTO ronlsb_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Nu numai noi înșine, ci și noi înșine, care avem primele roade ale Duhului, chiar și noi înșine gemem în noi înșine, așteptând adopția, răscumpărarea trupului nostru. ");
INSERT INTO ronlsb_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Căci am fost mântuiți în speranță, dar speranța care se vede nu este speranță. Căci cine speră în ceea ce vede? ");
INSERT INTO ronlsb_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Dar dacă sperăm în ceea ce nu vedem, așteptăm cu răbdare. ");
INSERT INTO ronlsb_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Tot așa și Duhul Sfânt ne ajută în slăbiciunile noastre, pentru că nu știm să ne rugăm cum trebuie. Dar însuși Duhul mijlocește pentru noi cu gemete care nu pot fi rostite. ");
INSERT INTO ronlsb_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Cel care cercetează inimile știe ce este în mintea Duhului, pentru că el mijlocește pentru sfinți, potrivit lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Știm că toate lucrurile lucrează împreună spre binele celor ce iubesc pe Dumnezeu, al celor ce sunt chemați după planul Lui. ");
INSERT INTO ronlsb_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Căci pe cei pe care i-a cunoscut mai dinainte, i-a și predestinat să fie conformați cu chipul Fiului Său, pentru ca El să fie cel dintâi născut între mulți frați. ");
INSERT INTO ronlsb_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Pe cei pe care i-a predestinat, pe aceia i-a și chemat. Pe cei pe care i-a chemat, pe aceia i-a și îndreptățit. Pe cei pe care i-a justificat, pe aceia i-a și glorificat. ");
INSERT INTO ronlsb_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Ce să spunem despre aceste lucruri? Dacă Dumnezeu este pentru noi, cine poate fi împotriva noastră? ");
INSERT INTO ronlsb_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","El, care nu și-a cruțat propriul Fiu, ci L-a predat pentru noi toți, cum nu ne-ar da și El, împreună cu El, toate lucrurile? ");
INSERT INTO ronlsb_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Cine ar putea aduce o acuzație împotriva aleșilor lui Dumnezeu? Dumnezeu este cel care justifică. ");
INSERT INTO ronlsb_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Cine este cel care condamnă? Este Hristos, care a murit, ba mai mult, care a înviat din morți, care este la dreapta lui Dumnezeu, care și el mijlocește pentru noi. ");
INSERT INTO ronlsb_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Cine ne va despărți pe noi de dragostea lui Hristos? Ar putea oare opresiunea, sau chinul, sau persecuția, sau foametea, sau goliciunea, sau primejdia, sau sabia? ");
INSERT INTO ronlsb_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Așa cum este scris, “De dragul tău suntem uciși toată ziua. Am fost socotiți ca niște oi pentru măcelărie.” ");
INSERT INTO ronlsb_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Nu, în toate aceste lucruri suntem mai mult decât biruitori prin Cel ce ne-a iubit. ");
INSERT INTO ronlsb_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Căci sunt încredințat că nici moartea, nici viața, nici îngerii, nici stăpânirile, nici lucrurile prezente, nici cele viitoare, nici puterile, ");
INSERT INTO ronlsb_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","nici înălțimea, nici adâncimea, nici vreun alt lucru creat nu va putea să ne despartă de dragostea lui Dumnezeu, care este în Hristos Isus, Domnul nostru. ");
INSERT INTO ronlsb_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Eu spun adevărul în Hristos. Nu mint, conștiința mea mărturisește cu mine în Duhul Sfânt ");
INSERT INTO ronlsb_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","că am o mare întristare și o durere neîncetată în inima mea. ");
INSERT INTO ronlsb_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Căci aș putea să doresc să fiu eu însumi blestemat de Cristos, din cauza fraților mei, rudele mele după trup ");
INSERT INTO ronlsb_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","care sunt israeliți; a căror adopție, glorie, legăminte, dăruire a legii, slujire și promisiuni ");
INSERT INTO ronlsb_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","din care sunt părinții și din care provine Cristos în ceea ce privește trupul, care este peste toate, Dumnezeu, binecuvântat în veci. Amin. ");
INSERT INTO ronlsb_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Dar nu este ca și cum Cuvântul lui Dumnezeu ar fi fost zădărnicit. Căci nu toți cei din Israel sunt din Israel. ");
INSERT INTO ronlsb_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","și nici, pentru că sunt urmașii lui Avraam, nu sunt toți copii. Ci, “urmașii voștri vor fi socotiți ca de la Isaac”. ");
INSERT INTO ronlsb_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Adică, nu copiii cărnii sunt copiii lui Dumnezeu, ci copiii promisiunii sunt socotiți moștenitori. ");
INSERT INTO ronlsb_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Căci acesta este un cuvânt al promisiunii: “La timpul hotărât voi veni și Sara va avea un fiu”. ");
INSERT INTO ronlsb_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Și nu numai atât, ci și Rebeca a conceput un fiu, pe tatăl nostru Isaac. ");
INSERT INTO ronlsb_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","Căci, nefiind încă născută, și neavând nimic bun sau rău, pentru ca scopul lui Dumnezeu, potrivit alegerii, să rămână în picioare, nu din fapte, ci de la Cel care cheamă, ");
INSERT INTO ronlsb_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","i s-a spus: “Cel mai mare va sluji celui mai mic”. ");
INSERT INTO ronlsb_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Așa cum este scris: “Pe Iacov l-am iubit, dar pe Esau l-am urât”. ");
INSERT INTO ronlsb_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Ce vom spune atunci? Există nedreptate la Dumnezeu? Să nu fie niciodată! ");
INSERT INTO ronlsb_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Căci El a zis lui Moise: “Voi avea milă de cine am milă și voi avea milă de cine am milă”. ");
INSERT INTO ronlsb_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Deci, nu este a celui care vrea, nici a celui care aleargă, ci a lui Dumnezeu care are milă. ");
INSERT INTO ronlsb_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Căci Scriptura îi spune lui Faraon: “Tocmai pentru aceasta am făcut să te înalț, ca să-mi arăt în tine puterea Mea și ca numele Meu să fie vestit pe tot pământul.” ");
INSERT INTO ronlsb_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Așadar, El are milă de cine vrea și împietrește pe cine vrea. ");
INSERT INTO ronlsb_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Atunci îmi veți zice: “De ce mai găsește el greșeală? Căci cine se împotrivește voinței lui?” ");
INSERT INTO ronlsb_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Dar, într-adevăr, omule, cine ești tu ca să răspunzi împotriva lui Dumnezeu? Oare lucrul format îl va întreba pe cel care l-a format: “De ce m-ai făcut așa?” ");
INSERT INTO ronlsb_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Sau nu are olarul un drept asupra lutului, din aceeași bucată să facă dintr-o parte un vas pentru cinste și din alta pentru dezonoare? ");
INSERT INTO ronlsb_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Și dacă Dumnezeu, vrând să-și arate mânia și să-și facă cunoscută puterea, a îndurat cu multă răbdare vasele mâniei pregătite pentru distrugere, ");
INSERT INTO ronlsb_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","și ca să facă cunoscută bogăția gloriei sale pe vasele milei, pe care le-a pregătit mai dinainte pentru glorie— ");
INSERT INTO ronlsb_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","pe noi, pe care ne-a chemat și pe noi, nu numai dintre iudei, ci și dintre neamuri? ");
INSERT INTO ronlsb_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","După cum spune și în Osea, “Îi voi numi “poporul meu”, pe cei care nu erau poporul meu; și “iubitul” ei, care nu era iubit.” ");
INSERT INTO ronlsb_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","În locul în care li s-a spus: “Voi nu sunteți poporul Meu”. acolo vor fi numiți “copiii Dumnezeului celui viu”.” ");
INSERT INTO ronlsb_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Isaia strigă cu privire la Israel, “Dacă numărul copiilor lui Israel este ca nisipul mării, rămășița este cea care va fi salvată; ");
INSERT INTO ronlsb_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Căci El va isprăvi lucrarea și o va curma cu dreptate, pentru că Domnul va face o lucrare scurtă pe pământ.” ");
INSERT INTO ronlsb_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","După cum a spus Isaia mai înainte, “Dacă Domnul oștirilor nu ne-ar fi lăsat o sămânță, am fi devenit ca Sodoma, și ar fi fost făcut ca Gomora.” ");
INSERT INTO ronlsb_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Ce vom spune atunci? Că neamurile, care nu urmăreau neprihănirea, au ajuns la neprihănire, la neprihănirea care vine din credință; ");
INSERT INTO ronlsb_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","dar Israel, care urmărea o lege a neprihănirii, nu a ajuns la legea neprihănirii. ");
INSERT INTO ronlsb_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","De ce? Pentru că nu au căutat-o prin credință, ci ca și cum ar fi fost prin faptele legii. S-au împiedicat de piatra de poticnire, ");
INSERT INTO ronlsb_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","așa cum este scris, “Iată, pun în Sion o piatră de poticnire și o stâncă de jignire; și nimeni care crede în El nu va fi dezamăgit.” ");
INSERT INTO ronlsb_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Fraților, dorința inimii mele și rugăciunea mea către Dumnezeu este pentru Israel, ca să fie mântuit. ");
INSERT INTO ronlsb_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Căci mărturisesc despre ei că au un zel pentru Dumnezeu, dar nu potrivit cu cunoștința. ");
INSERT INTO ronlsb_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Pentru că, ignorând dreptatea lui Dumnezeu și căutând să își stabilească propria dreptate, nu s-au supus dreptății lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Căci Hristos este împlinirea Legii, ca neprihănire pentru oricine crede. ");
INSERT INTO ronlsb_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Căci Moise scrie despre dreptatea Legii: “Cel ce le împlinește va trăi prin ele.” ");
INSERT INTO ronlsb_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Dar neprihănirea care vine din credință spune următoarele: “Nu spuneți în inima voastră: “Cine se va sui în cer?”. (adică să-l coboare pe Cristos); ");
INSERT INTO ronlsb_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","sau: “Cine se va coborî în abis?” (adică să-l coboare pe Cristos); sau: “Cine se va coborî în abis?”. (adică să-l aducă pe Hristos din morți).” ");
INSERT INTO ronlsb_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Dar ce spune? “Cuvântul este aproape de tine, în gura ta și în inima ta”, adică cuvântul credinței pe care îl predicăm: ");
INSERT INTO ronlsb_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","că, dacă vei mărturisi cu gura ta că Isus este Domnul și dacă vei crede în inima ta că Dumnezeu l-a înviat din morți, vei fi mântuit. ");
INSERT INTO ronlsb_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Căci cu inima se crede, ceea ce duce la neprihănire, iar cu gura se face mărturisirea, ceea ce duce la mântuire. ");
INSERT INTO ronlsb_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Căci Scriptura spune: “Oricine crede în el nu va fi dezamăgit”. ");
INSERT INTO ronlsb_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Căci nu este nici o deosebire între iudei și greci, căci același Domn este Domnul tuturor și este bogat pentru toți cei ce-L cheamă. ");
INSERT INTO ronlsb_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Căci: “Oricine va invoca numele Domnului va fi mântuit”. ");
INSERT INTO ronlsb_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Cum îl vor invoca, așadar, pe cel în care nu au crezut? Cum vor crede în cel pe care nu l-au auzit? Cum vor auzi fără un predicator? ");
INSERT INTO ronlsb_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Și cum vor propovădui ei dacă nu vor fi trimiși? După cum este scris: “Cât de frumoase sunt picioarele celor care propovăduiesc vestea bună a păcii, care aduceți vești bune!” ");
INSERT INTO ronlsb_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Dar nu toți au ascultat vestea cea bună. Căci Isaia spune: “Doamne, cine a crezut în vestea noastră?”. ");
INSERT INTO ronlsb_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Așadar, credința vine prin auz, iar auzul prin cuvântul lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Dar eu zic: nu au auzit ei? Ba da, cu siguranță că da, “Sunetul lor s-a răspândit pe tot pământul, cuvintele lor până la marginile lumii.” ");
INSERT INTO ronlsb_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Dar eu întreb: nu știa Israel? Mai întâi Moise spune, “Vă voi provoca la gelozie cu ceea ce nu este neam. Te voi înfuria cu un neam lipsit de înțelegere.” ");
INSERT INTO ronlsb_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Isaia este foarte îndrăzneț și spune, “Am fost găsit de cei care nu m-au căutat. Am fost dezvăluit celor care nu m-au cerut.” ");
INSERT INTO ronlsb_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Dar despre Israel spune: “Toată ziua mi-am întins mâinile spre un popor neascultător și răzvrătit.” ");
INSERT INTO ronlsb_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Întreb atunci: A respins Dumnezeu pe poporul Său? Fie ca niciodată să nu fie așa! Căci și eu sunt israelit, descendent al lui Avraam, din seminția lui Beniamin. ");
INSERT INTO ronlsb_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Dumnezeu nu și-a respins poporul său, pe care l-a cunoscut dinainte. Sau nu știți ce spune Scriptura despre Ilie? Cum îl imploră el pe Dumnezeu împotriva lui Israel: ");
INSERT INTO ronlsb_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“Doamne, ei au ucis pe profeții Tăi. Au dărâmat altarele Tale. Eu am rămas singur, iar ei îmi caută viața”. ");
INSERT INTO ronlsb_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Dar cum îi răspunde Dumnezeu? “Mi-am rezervat șapte mii de oameni care nu și-au plecat genunchiul în fața lui Baal.” ");
INSERT INTO ronlsb_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Tot așa, și în acest timp prezent există o rămășiță, potrivit alegerii harului. ");
INSERT INTO ronlsb_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Și dacă este prin har, atunci nu mai este prin fapte; altfel, harul nu mai este har. Dar dacă este din fapte, nu mai este har; altfel fapta nu mai este faptă. ");
INSERT INTO ronlsb_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Și atunci, ce se întâmplă? Ceea ce caută Israel, nu a obținut, ci au obținut-o cei aleși, iar ceilalți s-au împietrit. ");
INSERT INTO ronlsb_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","După cum este scris: “Dumnezeu le-a dat un duh de stupoare, ochi ca să nu vadă și urechi ca să nu audă, până în ziua de azi”. ");
INSERT INTO ronlsb_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","David spune, “Masa lor să se facă o cursă, o capcană, o piatră de poticnire și o pedeapsă pentru ei. ");
INSERT INTO ronlsb_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Să li se întunece ochii, ca să nu vadă. Întotdeauna țineți-le spatele îndoit.” ");
INSERT INTO ronlsb_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Întreb, deci, dacă s-au împiedicat ca să cadă? Să nu se întâmple niciodată! Dar, prin căderea lor, mântuirea a ajuns la neamuri, ca să le provoace gelozia. ");
INSERT INTO ronlsb_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Or, dacă căderea lor este bogăția lumii și pierderea lor este bogăția neamurilor, cu cât mai mult plinătatea lor! ");
INSERT INTO ronlsb_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Căci Eu vă vorbesc vouă, care sunteți neamuri. De vreme ce, fiind apostol al neamurilor, îmi slăvesc slujba, ");
INSERT INTO ronlsb_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","dacă, prin orice mijloc, pot să provoc la gelozie pe cei din carnea mea și să salvez pe unii dintre ei. ");
INSERT INTO ronlsb_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Căci, dacă respingerea lor este împăcarea lumii, ce ar fi acceptarea lor, dacă nu viața din morți? ");
INSERT INTO ronlsb_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Dacă cel dintâi fruct este sfânt, la fel este și masa. Dacă rădăcina este sfântă, și ramurile sunt sfinte. ");
INSERT INTO ronlsb_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Dar dacă unele dintre ramuri au fost rupte, iar tu, fiind un măslin sălbatic, ai fost altoit printre ele și ai devenit părtaș cu ele la rădăcina și la bogăția măslinului, ");
INSERT INTO ronlsb_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","nu te lăuda cu ramurile. Dar dacă te lauzi, adu-ți aminte că nu tu susții rădăcina, ci rădăcina te susține pe tine. ");
INSERT INTO ronlsb_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Veți spune atunci: “Ramurile au fost rupte, ca să fiu altoit eu”. ");
INSERT INTO ronlsb_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Adevărat; prin necredința lor au fost rupte, iar voi stați în picioare prin credința voastră. Nu fiți îngâmfați, ci temători; ");
INSERT INTO ronlsb_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","căci dacă Dumnezeu nu a cruțat ramurile naturale, nici pe voi nu vă va cruța. ");
INSERT INTO ronlsb_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Vedeți, așadar, bunătatea și severitatea lui Dumnezeu. Față de cei care au căzut, severitate; dar față de voi, bunătate, dacă rămâneți în bunătatea lui; altfel, și voi veți fi stârpiți. ");
INSERT INTO ronlsb_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Și ei, dacă nu vor continua în necredința lor, vor fi altoiți, căci Dumnezeu este în stare să-i altoiască din nou. ");
INSERT INTO ronlsb_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Căci dacă voi ați fost tăiați din ceea ce este prin natură un măslin sălbatic și ați fost altoiți, contrar naturii, într-un măslin bun, cu cât mai mult aceștia, care sunt ramurile naturale, vor fi altoiți în propriul lor măslin? ");
INSERT INTO ronlsb_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Căci nu voiesc, fraților, să nu cunoașteți taina aceasta, ca să nu fiți înțelepți în închipuirile voastre: că Israel a suferit o împietrire parțială, până ce va veni plinătatea neamurilor, ");
INSERT INTO ronlsb_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","și tot Israelul va fi mântuit. Așa cum este scris, “Din Sion va ieși Eliberatorul, și va îndepărta nelegiuirea din Iacov. ");
INSERT INTO ronlsb_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Acesta este legământul Meu cu ei, când le voi șterge păcatele.” ");
INSERT INTO ronlsb_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","În ceea ce privește Buna Vestire, ei sunt vrăjmași din pricina voastră. Dar în ceea ce privește alegerea, ei sunt iubiți din cauza părinților. ");
INSERT INTO ronlsb_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Căci darurile și chemarea lui Dumnezeu sunt irevocabile. ");
INSERT INTO ronlsb_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Căci, după cum voi, în trecut, ați fost neascultători față de Dumnezeu, dar acum ați obținut îndurare prin neascultarea lor, ");
INSERT INTO ronlsb_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","tot așa și aceștia au fost neascultători, pentru ca, prin îndurarea arătată vouă, să obțină și ei îndurare. ");
INSERT INTO ronlsb_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Căci Dumnezeu i-a legat pe toți de neascultare, ca să aibă milă de toți. ");
INSERT INTO ronlsb_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","O, adâncul bogăției înțelepciunii și a cunoștinței lui Dumnezeu! Cât de nepătrunse sunt judecățile Lui și cât de neîntrecute sunt căile Lui, care nu pot fi trasate! ");
INSERT INTO ronlsb_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Căci cine a cunoscut gândul Domnului? Sau cine a fost consilierul lui?” ");
INSERT INTO ronlsb_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","“Sau cine i-a dat mai întâi, și i se va restitui din nou?” ");
INSERT INTO ronlsb_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Căci din El, prin El și pentru El sunt toate lucrurile. A lui să fie gloria în veci! Amin. ");
INSERT INTO ronlsb_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","De aceea, fraților, vă îndemn, prin mila lui Dumnezeu, să vă aduceți trupurile voastre ca o jertfă vie, sfântă, plăcută lui Dumnezeu, care este slujba voastră spirituală. ");
INSERT INTO ronlsb_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Nu vă potriviți cu lumea aceasta, ci transformați-vă prin înnoirea minții voastre, ca să puteți dovedi care este voia lui Dumnezeu, bună, plăcută și desăvârșită. ");
INSERT INTO ronlsb_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Pentru că, prin harul care mi-a fost dat, spun fiecăruia dintre voi să nu se socoată mai mult decât trebuie să se socoată, ci să se socoată drept, după cum Dumnezeu a dat fiecăruia o măsură de credință. ");
INSERT INTO ronlsb_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Căci, după cum într-un singur trup avem mai multe mădulare și nu toate mădularele au aceeași funcție, ");
INSERT INTO ronlsb_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","tot așa și noi, care suntem mulți, suntem un singur trup în Hristos și, în mod individual, mădulare unul altuia, ");
INSERT INTO ronlsb_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","având daruri diferite, potrivit cu harul care ne-a fost dat: dacă profețește, să profețească după măsura credinței noastre; ");
INSERT INTO ronlsb_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","sau dacă slujește, să ne dăruim slujirii; sau cine învață, să se dăruiască învățăturii; ");
INSERT INTO ronlsb_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","sau cine îndeamnă, să se dăruiască îndemnului; cine dăruiește, să o facă cu generozitate; cine conduce, cu sârguință; cine face milostenie, cu veselie. ");
INSERT INTO ronlsb_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Dragostea să fie fără ipocrizie. Detestați ceea ce este rău. Să se agațe de ceea ce este bun. ");
INSERT INTO ronlsb_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","În dragostea fraților, fiți tandri unii cu alții; în cinste, preferați-vă unii pe alții, ");
INSERT INTO ronlsb_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","nu rămâneți în urmă cu sârguința, fiți fervenți în duh, slujiți Domnului, ");
INSERT INTO ronlsb_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","bucurați-vă în speranță, rezistați în necazuri, continuați cu stăruință în rugăciune, ");
INSERT INTO ronlsb_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","contribuiți la nevoile sfinților și fiți darnici în ospitalitate. ");
INSERT INTO ronlsb_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Binecuvântați pe cei ce vă prigonesc; binecuvântați și nu blestemați. ");
INSERT INTO ronlsb_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Bucurați-vă cu cei ce se bucură. Plângeți cu cei ce plâng. ");
INSERT INTO ronlsb_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Fiți de aceeași părere unii față de alții. Nu vă gândiți la lucruri înalte, ci asociați-vă cu cei umili. Nu fiți înțelepți în închipuirile voastre. ");
INSERT INTO ronlsb_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Nu răsplătiți nimănui rău pentru rău. Respectați ceea ce este onorabil în ochii tuturor oamenilor. ");
INSERT INTO ronlsb_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Dacă este posibil, atât cât depinde de tine, fii în pace cu toți oamenii. ");
INSERT INTO ronlsb_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Nu căutați voi înșivă să vă răzbunați, iubiților, ci lăsați loc mâniei lui Dumnezeu. Căci este scris: “Mie îmi aparține răzbunarea; Eu voi răsplăti, zice Domnul.” ");
INSERT INTO ronlsb_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","De aceea “Dacă dușmanul tău este flămând, dă-i de mâncare. Dacă îi este sete, dați-i să bea; pentru că, făcând așa, îi vei arunca cărbuni de foc pe cap.” ");
INSERT INTO ronlsb_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Nu vă lăsați biruiți de rău, ci biruiți răul cu binele. ");
INSERT INTO ronlsb_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Fiecare suflet să se supună autorităților superioare, căci nu există autoritate decât de la Dumnezeu, iar cele ce există sunt rânduite de Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","De aceea, cel care se împotrivește autorității se împotrivește rânduielii lui Dumnezeu; iar cei care se împotrivesc vor primi pentru ei înșiși judecata. ");
INSERT INTO ronlsb_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Căci conducătorii nu sunt o teroare pentru fapta bună, ci pentru cea rea. Doriți să nu vă temeți de autoritate? Fă ceea ce este bun, și vei avea parte de laudă din partea autorității, ");
INSERT INTO ronlsb_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","căci ea este un slujitor al lui Dumnezeu pentru tine, spre bine. Dar dacă faci ceea ce este rău, teme-te, căci nu degeaba poartă sabia, căci este un slujitor al lui Dumnezeu, răzbunător pentru mânia celui care face răul. ");
INSERT INTO ronlsb_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","De aceea trebuie să vă supuneți, nu numai din cauza mâniei, ci și din cauza conștiinței. ");
INSERT INTO ronlsb_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","De aceea și voi plătiți impozite, pentru că sunt slujitori ai lui Dumnezeu, care fac în permanență tocmai acest lucru. ");
INSERT INTO ronlsb_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","De aceea, dați fiecăruia ceea ce îi este dator: dacă datorați impozite, plătiți impozitele; dacă aveți vameși, atunci vameși; dacă aveți respect, atunci respect; dacă aveți onoare, atunci onoare. ");
INSERT INTO ronlsb_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Să nu datorați nimănui nimic, decât să vă iubiți unii pe alții; căci cine iubește pe aproapele său a împlinit Legea. ");
INSERT INTO ronlsb_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Căci poruncile: “Să nu comiți adulter”, “Să nu ucizi”, “Să nu furi”, “Să nu poftești” și orice alte porunci ar mai fi, toate se rezumă la acest cuvânt, și anume: “Să iubești pe aproapele tău ca pe tine însuți”. ");
INSERT INTO ronlsb_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Dragostea nu face rău aproapelui. Prin urmare, iubirea este împlinirea legii. ");
INSERT INTO ronlsb_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Fă aceasta, știind că a sosit deja vremea să te trezești din somn, căci mântuirea este mai aproape de noi decât atunci când am crezut. ");
INSERT INTO ronlsb_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Noaptea este departe, și ziua este aproape. Să ne lepădăm deci de faptele întunericului și să ne îmbrăcăm cu armura luminii. ");
INSERT INTO ronlsb_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Să umblăm cum se cuvine, ca în timpul zilei; nu în desfrâu și beție, nu în promiscuitate sexuală și acte de desfrânare, nu în certuri și gelozie. ");
INSERT INTO ronlsb_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Ci îmbrăcați-vă în Domnul Isus Hristos și nu faceți niciun fel de provizii pentru carne, pentru poftele ei. ");
INSERT INTO ronlsb_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Acceptați acum pe cel slab în credință, dar nu pentru certuri de păreri. ");
INSERT INTO ronlsb_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Un om are credință să mănânce de toate, dar cel care este slab mănâncă numai legume. ");
INSERT INTO ronlsb_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Să nu-l disprețuiască cel care mănâncă pe cel care nu mănâncă. Cel care nu mănâncă să nu-l judece pe cel care mănâncă, pentru că Dumnezeu l-a acceptat. ");
INSERT INTO ronlsb_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Cine sunteți voi care judecați pe robul altuia? În fața propriului său stăpân stă sau cade. Da, el va fi făcut să stea în picioare, căci Dumnezeu are puterea de a-l face să stea în picioare. ");
INSERT INTO ronlsb_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Un om consideră că o zi este mai importantă. Altul apreciază fiecare zi la fel. Fiecare să fie pe deplin sigur în mintea sa. ");
INSERT INTO ronlsb_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Cine prăznuiește ziua, o prăznuiește pentru Domnul, iar cine nu prăznuiește ziua, nu o prăznuiește pentru Domnul. Cel care mănâncă, mănâncă pentru Domnul, căci mulțumește lui Dumnezeu. Cel care nu mănâncă, pentru Domnul nu mănâncă, și îi mulțumește lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Căci niciunul dintre noi nu trăiește pentru sine și niciunul nu moare pentru sine. ");
INSERT INTO ronlsb_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Căci dacă trăim, trăim pentru Domnul. Sau dacă murim, murim pentru Domnul. Așadar, dacă trăim sau murim, suntem ai Domnului. ");
INSERT INTO ronlsb_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Căci pentru aceasta Hristos a murit, a înviat și a trăit din nou, ca să fie Domnul celor morți și al celor vii. ");
INSERT INTO ronlsb_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Dar tu, de ce judeci pe fratele tău? Sau tu, de ce îl disprețuiești pe fratele tău? Căci toți vom sta în fața scaunului de judecată al lui Hristos. ");
INSERT INTO ronlsb_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Căci este scris:, “Pe viața Mea, zice Domnul, orice genunchi se va pleca înaintea Mea. Orice limbă va mărturisi lui Dumnezeu”.” ");
INSERT INTO ronlsb_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Astfel, fiecare dintre noi va da socoteală de sine lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","De aceea să nu ne mai judecăm unii pe alții, ci să judecăm mai degrabă aceasta: să nu pună nimeni piedică fratelui său și nici prilej de cădere. ");
INSERT INTO ronlsb_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Știu și sunt încredințat în Domnul Isus că nimic nu este necurat de la sine; numai că pentru cel ce consideră ceva necurat, pentru el este necurat. ");
INSERT INTO ronlsb_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Totuși, dacă din pricina mâncării fratele tău este mâhnit, nu mai umblați în dragoste. Nu distruge cu mâncarea ta pe cel pentru care a murit Hristos. ");
INSERT INTO ronlsb_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Atunci nu lăsați ca binele vostru să fie defăimat, ");
INSERT INTO ronlsb_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","căci Împărăția lui Dumnezeu nu este mâncare și băutură, ci dreptate, pace și bucurie în Duhul Sfânt. ");
INSERT INTO ronlsb_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Căci cel ce slujește lui Hristos în aceste lucruri este plăcut lui Dumnezeu și aprobat de oameni. ");
INSERT INTO ronlsb_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Așadar, să urmăm lucrurile care duc la pace și lucrurile prin care ne putem edifica unii pe alții. ");
INSERT INTO ronlsb_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Nu răsturnați lucrarea lui Dumnezeu de dragul mâncării. Într-adevăr, toate lucrurile sunt curate, însă este rău pentru acel om care creează o piedică prin mâncare. ");
INSERT INTO ronlsb_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Este bine să nu mănânci carne, să nu bei vin și să nu faci nimic prin care fratele tău să se poticnească, să fie jignit sau să slăbească. ");
INSERT INTO ronlsb_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Aveți credință? Ai credință în fața lui Dumnezeu. Fericit este cel care nu se judecă pe sine însuși în ceea ce aprobă. ");
INSERT INTO ronlsb_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Dar cel care se îndoiește este condamnat dacă mănâncă, pentru că nu este din credință; și tot ce nu este din credință este păcat. ");
INSERT INTO ronlsb_vpl VALUES ("RM14_24","075_14_24","ROM","14","24","24","Și acum, Celui ce poate să vă întărească, după Buna Vestire a mea și după propovăduirea lui Isus Hristos, după descoperirea tainei, care a fost ținută ascunsă în veacuri îndelungate, ");
INSERT INTO ronlsb_vpl VALUES ("RM14_25","075_14_25","ROM","14","25","25","dar care acum s-a descoperit și, prin Scripturile profeților, după porunca Dumnezeului veșnic, a fost făcută cunoscută tuturor neamurilor, pentru ascultarea credinței, ");
INSERT INTO ronlsb_vpl VALUES ("RM14_26","075_14_26","ROM","14","26","26","pentru singurul și înțeleptul Dumnezeu, prin Isus Hristos, căruia I se cuvine slava în veci! Amin. ");
INSERT INTO ronlsb_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Iar noi, care suntem puternici, trebuie să suportăm slăbiciunile celor slabi și să nu ne mulțumim pe noi înșine. ");
INSERT INTO ronlsb_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Fiecare dintre noi să mulțumească aproapelui său, pentru ceea ce este bine, ca să-l zidim. ");
INSERT INTO ronlsb_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Căci nici măcar Hristos nu s-a mulțumit pe sine însuși. Ci, după cum este scris: “Reproșurile celor care vă ocărau pe voi au căzut asupra mea”. ");
INSERT INTO ronlsb_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Căci tot ceea ce a fost scris mai înainte a fost scris pentru învățătura noastră, pentru ca, prin perseverență și prin încurajarea Scripturilor, să avem nădejde. ");
INSERT INTO ronlsb_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Or, Dumnezeul perseverenței și al încurajării să vă dea să fiți de aceeași părere unii cu alții, potrivit cu Hristos Isus, ");
INSERT INTO ronlsb_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","pentru ca, cu o singură gură, să slăviți cu un singur gând pe Dumnezeul și Tatăl Domnului nostru Isus Hristos. ");
INSERT INTO ronlsb_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","De aceea, acceptați-vă unii pe alții, cum și Hristos v-a acceptat pe voi, spre slava lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Acum spun că Hristos a fost făcut rob al circumciziei pentru adevărul lui Dumnezeu, ca să confirme promisiunile făcute părinților, ");
INSERT INTO ronlsb_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","și ca neamurile să slăvească pe Dumnezeu pentru îndurarea Sa. După cum este scris, “De aceea te voi lăuda printre neamuri. și voi cânta în numele Tău.” ");
INSERT INTO ronlsb_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","El spune din nou, “Bucurați-vă, neamuri, împreună cu poporul Său”. ");
INSERT INTO ronlsb_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Din nou, “Lăudați pe Domnul, voi toate neamurile! Toate popoarele să îl laude.” ");
INSERT INTO ronlsb_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Isaia spune din nou, “Acolo va fi rădăcina lui Iesei, cel care se ridică să stăpânească peste neamuri; în El vor nădăjdui neamurile.” ");
INSERT INTO ronlsb_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Și Dumnezeul nădejdii să vă umple de toată bucuria și pacea în credință, ca să sporiți în nădejde prin puterea Duhului Sfânt. ");
INSERT INTO ronlsb_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Și eu însumi sunt încredințat de voi, frații mei, că voi înșivă sunteți plini de bunătate, plini de toată știința, în stare să îndemnați și pe alții. ");
INSERT INTO ronlsb_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Dar vă scriu cu mai multă îndrăzneală în parte ca să vă reamintesc, datorită harului care mi-a fost dat de Dumnezeu, ");
INSERT INTO ronlsb_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","ca să fiu slujitor al lui Isus Hristos pentru neamuri, slujind ca preot al Bunei Vestiri a lui Dumnezeu, pentru ca jertfa neamurilor să fie acceptabilă, sfințită prin Duhul Sfânt. ");
INSERT INTO ronlsb_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Prin urmare, mă laud în Hristos Isus în ceea ce privește lucrurile care țin de Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Căci nu îndrăznesc să vorbesc despre alte lucruri decât despre cele pe care Hristos le-a lucrat prin mine pentru ascultarea neamurilor, prin cuvânt și prin faptă, ");
INSERT INTO ronlsb_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","în puterea semnelor și a minunilor, în puterea Duhului lui Dumnezeu; astfel încât, din Ierusalim și de jur împrejur până în Iliricum, am propovăduit pe deplin Vestea cea Bună a lui Hristos; ");
INSERT INTO ronlsb_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","da, făcându-mi scopul de a propovădui Vestea cea Bună, nu acolo unde Hristos a fost deja numit, ca să nu construiesc pe temelia altuia. ");
INSERT INTO ronlsb_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Ci, după cum este scris, “Ei vor vedea, la care nu a venit nicio veste despre el. Cei care nu au auzit vor înțelege.” ");
INSERT INTO ronlsb_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","De aceea și eu am fost împiedicat de atâtea ori să vin la voi, ");
INSERT INTO ronlsb_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","dar acum, neavând loc în aceste ținuturi și având de atâția ani dorința de a veni la voi, ");
INSERT INTO ronlsb_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","voi veni la voi ori de câte ori voi merge în Spania. Căci sper să te văd în călătoria mea și să fiu ajutat de tine în drumul meu acolo, dacă mai întâi mă voi putea bucura de compania ta pentru o vreme. ");
INSERT INTO ronlsb_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Dar acum, zic, mă duc la Ierusalim, pentru a sluji sfinților. ");
INSERT INTO ronlsb_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Căci Macedonia și Ahaia au binevoit să facă o anumită contribuție pentru săracii dintre sfinții care sunt la Ierusalim. ");
INSERT INTO ronlsb_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Da, a fost pe placul lor, și ei sunt datori. Căci, dacă neamurile au fost făcute părtașe la lucrurile lor spirituale, le sunt datoare să le slujească și în cele materiale. ");
INSERT INTO ronlsb_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Așadar, după ce voi fi împlinit aceasta și le voi fi pecetluit acest rod, voi pleca pe drumul vostru spre Spania. ");
INSERT INTO ronlsb_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Știu că, atunci când voi veni la voi, voi veni în plinătatea binecuvântării Binecuvântării Bunei Vestiri a lui Hristos. ");
INSERT INTO ronlsb_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Vă rog, fraților, pentru Domnul nostru Isus Hristos și pentru dragostea Duhului Sfânt, să vă rugați împreună cu mine în rugăciunile voastre către Dumnezeu pentru mine, ");
INSERT INTO ronlsb_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","ca să fiu izbăvit de cei neascultători din Iudeea și ca slujba pe care o am pentru Ierusalim să fie plăcută sfinților, ");
INSERT INTO ronlsb_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","ca să vin la voi cu bucurie, prin voia lui Dumnezeu, și împreună cu voi să găsesc odihnă. ");
INSERT INTO ronlsb_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Acum, Dumnezeul păcii să fie cu voi toți. Amin. ");
INSERT INTO ronlsb_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Vă încredințez pe Febe, sora noastră, care este slujitoare a adunării din Cencreea, ");
INSERT INTO ronlsb_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","ca să o primiți în Domnul, în chip vrednic de sfinți, și să o ajutați în tot ceea ce va avea nevoie de la voi, căci ea însăși a ajutat pe mulți și pe mine însumi. ");
INSERT INTO ronlsb_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Salutați pe Prisca și pe Acuila, tovarășii mei de muncă în Hristos Isus, ");
INSERT INTO ronlsb_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","care și-au riscat gâtul pentru viața mea și cărora nu numai eu le mulțumesc, ci și toate adunările neamurilor. ");
INSERT INTO ronlsb_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Salutați adunarea care se află în casa lor. Salutați-l pe Epaeneț, preaiubitul meu, care este cel dintâi rod al Ahaiei pentru Hristos. ");
INSERT INTO ronlsb_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Salutați-o pe Maria, care a muncit mult pentru noi. ");
INSERT INTO ronlsb_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Salutați-i pe Andronic și pe Junia, rudele mele și tovarășii mei de închisoare, care sunt remarcabili printre apostoli, care au fost și ei în Hristos înaintea mea. ");
INSERT INTO ronlsb_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Salutați-l pe Amplias, iubitul meu în Domnul. ");
INSERT INTO ronlsb_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Salutați pe Urbanus, tovarășul nostru de muncă în Hristos, și pe Stachys, iubitul meu. ");
INSERT INTO ronlsb_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Salutați pe Apelles, cel aprobat în Hristos. Salutați-i pe cei din casa lui Aristobulus. ");
INSERT INTO ronlsb_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Salutați pe Irodion, ruda mea. Salutați pe cei din casa lui Narcis, care sunt în Domnul. ");
INSERT INTO ronlsb_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Salutați pe Tryphaena și Tryphosa, care lucrează în Domnul. Salutați-o pe Persis, cea iubită, care a lucrat mult în Domnul. ");
INSERT INTO ronlsb_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Salutați pe Rufus, cel ales în Domnul, pe mama lui și pe ai mei. ");
INSERT INTO ronlsb_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Salutați pe Asincritus, Flegon, Hermes, Patrobas, Hermas și pe frații care sunt cu ei. ");
INSERT INTO ronlsb_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Salutați pe Filologus și pe Iulia, pe Nereus și pe sora lui, pe Olimpa și pe toți sfinții care sunt cu ei. ");
INSERT INTO ronlsb_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Salutați-vă unii pe alții cu o sărutare sfântă. Vă salută adunările lui Hristos. ");
INSERT INTO ronlsb_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Acum, fraților, vă rog să vă uitați la cei ce fac dezbinări și prilejuri de poticnire, împotriva învățăturii pe care ați învățat-o, și să vă depărtați de ei. ");
INSERT INTO ronlsb_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Căci cei ca aceștia nu slujesc Domnului nostru Isus Hristos, ci propriei lor pântece; și prin vorbirea lor netedă și lingușitoare înșală inimile celor nevinovați. ");
INSERT INTO ronlsb_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Căci ascultarea voastră a devenit cunoscută de toți. De aceea mă bucur pentru voi. Dar doresc ca voi să fiți înțelepți în ceea ce este bun, dar nevinovați în ceea ce este rău. ");
INSERT INTO ronlsb_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Și Dumnezeul păcii îl va zdrobi repede pe Satana sub picioarele voastre. Harul Domnului nostru Iisus Hristos să fie cu voi. ");
INSERT INTO ronlsb_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Timotei, tovarășul meu de muncă, vă salută, precum și Lucius, Iason și Sosipater, rudele mele. ");
INSERT INTO ronlsb_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Eu, Tertius, care scriu scrisoarea, vă salut în Domnul. ");
INSERT INTO ronlsb_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Gaius, gazda mea și gazda întregii adunări, vă salută. Erastus, trezorierul orașului, vă salută, la fel ca și fratele Quartus. ");
INSERT INTO ronlsb_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","Harul Domnului nostru Isus Hristos să fie cu voi toți! Amin. ");
INSERT INTO ronlsb_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Pavel, chemat să fie apostol al lui Isus Hristos prin voia lui Dumnezeu, și fratele nostru Sostene, ");
INSERT INTO ronlsb_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","către adunarea lui Dumnezeu care este în Corint, către cei sfințiți în Hristos Isus, numiți sfinți, și către toți cei ce cheamă numele Domnului nostru Isus Hristos în orice loc, atât al lor, cât și al nostru: ");
INSERT INTO ronlsb_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Harul și pacea să vă fie vouă, de la Dumnezeu Tatăl nostru și de la Domnul Isus Hristos. ");
INSERT INTO ronlsb_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Mulțumesc totdeauna Dumnezeului meu pentru harul lui Dumnezeu care v-a fost dat în Hristos Isus, ");
INSERT INTO ronlsb_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","pentru că în toate v-ați îmbogățit în El, în toată vorbirea și în toată cunoștința, ");
INSERT INTO ronlsb_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","după cum a fost întărită în voimărturia lui Hristos, ");
INSERT INTO ronlsb_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","ca să nu rămâneți în urmă cu nici un dar, așteptând descoperirea Domnului nostru Isus Hristos, ");
INSERT INTO ronlsb_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","care vă va întări și el până la sfârșit, nevinovați în ziua Domnului nostru Isus Hristos. ");
INSERT INTO ronlsb_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Dumnezeu este credincios, prin care ați fost chemați la părtășia Fiului său, Isus Hristos, Domnul nostru. ");
INSERT INTO ronlsb_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Vă rog, fraților, în Numele Domnului nostru Isus Hristos, ca toți să vorbiți același lucru și să nu fie între voi nici o deosebire, ci să vă desăvârșiți împreună în același gând și în aceeași judecată. ");
INSERT INTO ronlsb_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Căci mi s-a raportat despre voi, frații mei, de către cei care sunt din casa lui Chloe, că sunt certuri între voi. ");
INSERT INTO ronlsb_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Vreau să spun că fiecare dintre voi spune: “Eu îl urmez pe Pavel”, “Eu îl urmez pe Apolo”, “Eu îl urmez pe Cefa” și “Eu îl urmez pe Hristos”. ");
INSERT INTO ronlsb_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Este Hristos împărțit? Pavel a fost răstignit pentru voi? Sau ați fost botezați în numele lui Pavel? ");
INSERT INTO ronlsb_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Mulțumesc lui Dumnezeu că nu am botezat pe niciunul dintre voi, în afară de Crispus și de Gaius, ");
INSERT INTO ronlsb_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","pentru ca nimeni să nu spună că v-am botezat în numele meu. ");
INSERT INTO ronlsb_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","(Am botezat și casa lui Ștefanas; în afară de ei, nu știu dacă am mai botezat pe altcineva). ");
INSERT INTO ronlsb_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Căci Hristos nu m-a trimis ca să botez, ci ca să propovăduiesc Vestea cea Bună — nu cu înțelepciune de cuvinte, pentru ca crucea lui Hristos să nu fie anulată. ");
INSERT INTO ronlsb_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Căci cuvântul crucii este o nebunie pentru cei care mor, dar pentru noi, cei care suntem mântuiți, este puterea lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Căci este scris, “Voi distruge înțelepciunea celor înțelepți. Voi nimici discernământul celor pricepuți.” ");
INSERT INTO ronlsb_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Unde este înțeleptul? Unde este scribul? Unde este cel care discută în acest veac? Oare nu a făcut Dumnezeu nebună înțelepciunea acestei lumi? ");
INSERT INTO ronlsb_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Căci, văzând că, în înțelepciunea lui Dumnezeu, lumea, prin înțelepciunea ei, nu a cunoscut pe Dumnezeu, a fost plăcerea lui Dumnezeu ca, prin nebunia propovăduirii, să mântuiască pe cei ce cred. ");
INSERT INTO ronlsb_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Căci iudeii cer semne, grecii caută înțelepciunea, ");
INSERT INTO ronlsb_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","dar noi Îl predicăm pe Hristos răstignit, care este o piatră de poticnire pentru iudei și o nebunie pentru greci, ");
INSERT INTO ronlsb_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","dar pentru cei chemați, atât iudei cât și greci, Hristos este puterea lui Dumnezeu și înțelepciunea lui Dumnezeu; ");
INSERT INTO ronlsb_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","pentru că nebunia lui Dumnezeu este mai înțeleaptă decât oamenii, iar slăbiciunea lui Dumnezeu este mai puternică decât oamenii. ");
INSERT INTO ronlsb_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Căci vedeți, fraților, chemarea voastră: nu mulți sunt înțelepți după trup, nu mulți viteji și nu mulți nobili; ");
INSERT INTO ronlsb_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","ci Dumnezeu a ales lucrurile nebunești ale lumii, ca să facă de rușine pe cei înțelepți. Dumnezeu a ales lucrurile slabe ale lumii ca să facă de rușine pe cele puternice. ");
INSERT INTO ronlsb_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","Dumnezeu a ales lucrurile smerite ale lumii, lucrurile disprețuite și lucrurile care nu există, ca să nimicească lucrurile care există, ");
INSERT INTO ronlsb_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","pentru ca nicio făptură să nu se laude înaintea lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Datorită lui, voi sunteți în Hristos Isus, care ne-a fost făcut înțelepciune de la Dumnezeu, și dreptate, și sfințire, și răscumpărare, ");
INSERT INTO ronlsb_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","pentru ca, așa cum este scris: “Cine se laudă, să se laude în Domnul”. ");
INSERT INTO ronlsb_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Când am venit la voi, fraților, n-am venit cu o vorbire sau cu înțelepciune, ca să vă vestesc mărturia lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Căci am hotărât să nu cunosc nimic între voi decât pe Isus Hristos și pe cel răstignit. ");
INSERT INTO ronlsb_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Am fost cu voi în slăbiciune, în frică și în mult tremur. ");
INSERT INTO ronlsb_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","Discursul meu și propovăduirea mea nu erau în cuvinte convingătoare ale înțelepciunii omenești, ci în demonstrația Duhului și a puterii, ");
INSERT INTO ronlsb_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","pentru ca credința voastră să nu stea în înțelepciunea oamenilor, ci în puterea lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Noi însă vorbim cu înțelepciune printre cei maturi, dar nu cu înțelepciunea lumii acesteia și nici cu cea a conducătorilor lumii acesteia, care sunt pe cale de dispariție. ");
INSERT INTO ronlsb_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","Ci noi vorbim înțelepciunea lui Dumnezeu în taină, înțelepciunea care a fost ascunsă, pe care Dumnezeu a rânduit-o mai dinainte de lumi, pentru gloria noastră, ");
INSERT INTO ronlsb_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","și pe care nu a cunoscut-o niciunul dintre conducătorii acestei lumi. Căci, dacă ar fi știut-o, nu L-ar fi răstignit pe Domnul slavei. ");
INSERT INTO ronlsb_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Dar, după cum este scris, “Lucruri pe care ochiul nu le-a văzut și urechea nu le-a auzit, care nu a intrat în inima omului, pe care Dumnezeu le-a pregătit pentru cei care îl iubesc.” ");
INSERT INTO ronlsb_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Dar nouă, Dumnezeu ni le-a descoperit prin Duhul Sfânt. Căci Duhul cercetează toate lucrurile, da, chiar și lucrurile adânci ale lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","Căci cine dintre oameni cunoaște lucrurile unui om, dacă nu spiritul omului care este în el? Tot așa, nimeni nu cunoaște lucrurile lui Dumnezeu, în afară de Duhul lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Dar noi nu am primit spiritul lumii, ci Duhul care vine de la Dumnezeu, ca să cunoaștem lucrurile care ne-au fost date de Dumnezeu în mod gratuit. ");
INSERT INTO ronlsb_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Și noi vorbim aceste lucruri, nu în cuvintele pe care le învață înțelepciunea omenească, ci în cele pe care le învață Duhul Sfânt, comparând lucrurile spirituale cu cele spirituale. ");
INSERT INTO ronlsb_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Or, omul firesc nu primește lucrurile Duhului lui Dumnezeu, pentru că sunt o nebunie pentru el; și nu le poate cunoaște, pentru că ele sunt percepute spiritual. ");
INSERT INTO ronlsb_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Dar cel spiritual discerne toate lucrurile, și el însuși nu trebuie să fie judecat de nimeni. ");
INSERT INTO ronlsb_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","“Căci cine a cunoscut gândul Domnului, ca să îl instruiască?” Dar noi avem mintea lui Hristos. ");
INSERT INTO ronlsb_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Fraților, n-aș putea să vă vorbesc ca unui duhovnicesc, ci ca unui trupesc, ca unor prunci în Hristos. ");
INSERT INTO ronlsb_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","V-am hrănit cu lapte, nu cu hrană solidă, pentru că nu erați încă pregătiți. Într-adevăr, nici acum nu sunteți pregătiți, ");
INSERT INTO ronlsb_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","căci sunteți încă trupești. Căci, în măsura în care între voi există gelozie, certuri și facțiuni, nu sunteți voi carnali și nu umblați voi pe căile oamenilor? ");
INSERT INTO ronlsb_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","Căci atunci când unul spune: “Eu îl urmez pe Pavel”, iar altul: “Eu îl urmez pe Apolo”, nu sunteți voi carnali? ");
INSERT INTO ronlsb_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","Cine este deci Apolo și cine este Pavel, dacă nu niște slujitori prin care ați crezut, și fiecare după cum i-a dat Domnul? ");
INSERT INTO ronlsb_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Eu am sădit. Apolo a udat. Dar Dumnezeu a dat creșterea. ");
INSERT INTO ronlsb_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","Așadar, nici cel care plantează nu este nimic, nici cel care udă, ci Dumnezeu, care dă creșterea. ");
INSERT INTO ronlsb_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","Or, cel care plantează și cel care udă sunt la fel, dar fiecare își va primi răsplata după munca sa. ");
INSERT INTO ronlsb_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Căci noi suntem colaboratori ai lui Dumnezeu. Voi sunteți agricultorii lui Dumnezeu, constructorii lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","După harul lui Dumnezeu, care mi-a fost dat, ca un meșter înțelept am pus o temelie, și altul zidește pe ea. Dar fiecare să fie atent cum zidește pe ea. ");
INSERT INTO ronlsb_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","Căci nimeni nu poate pune o altă temelie decât cea care a fost pusă, care este Isus Hristos. ");
INSERT INTO ronlsb_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Dar dacă cineva construiește pe temelie cu aur, argint, pietre scumpe, lemn, fân, paie sau fân, ");
INSERT INTO ronlsb_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","lucrarea fiecăruia va fi descoperită. Căci Ziua o va vesti, pentru că se descoperă în foc; și focul însuși va testa ce fel de lucrare este lucrarea fiecăruia. ");
INSERT INTO ronlsb_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Dacă va rămâne lucrarea cuiva, pe care a construit-o, va primi o răsplată. ");
INSERT INTO ronlsb_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","Dacă lucrarea cuiva este arsă, va suferi pierderi, dar el însuși va fi salvat, dar ca prin foc. ");
INSERT INTO ronlsb_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Nu știți voi că sunteți templul lui Dumnezeu și că Duhul lui Dumnezeu locuiește în voi? ");
INSERT INTO ronlsb_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Dacă cineva va distruge templul lui Dumnezeu, Dumnezeu îl va distruge, căci templul lui Dumnezeu, care sunteți voi, este sfânt. ");
INSERT INTO ronlsb_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Nimeni să nu se înșele pe sine însuși. Dacă cineva crede că este înțelept între voi în lumea aceasta, să se facă nebun, ca să devină înțelept. ");
INSERT INTO ronlsb_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Căci înțelepciunea lumii acesteia este o nebunie înaintea lui Dumnezeu. Căci este scris: “El a prins pe cei înțelepți în viclenia lor”. ");
INSERT INTO ronlsb_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","Și iarăși: “Domnul cunoaște raționamentele înțelepților, care sunt fără valoare.” ");
INSERT INTO ronlsb_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","De aceea, nimeni să nu se laude în oameni. Căci toate lucrurile sunt ale voastre, ");
INSERT INTO ronlsb_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","fie că este vorba de Pavel, de Apolo sau de Cefa, de lume, de viață sau de moarte, de cele prezente sau de cele viitoare. Toate sunt ale voastre, ");
INSERT INTO ronlsb_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","și voi sunteți ai lui Hristos, iar Hristos este al lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Deci, să ne considere omul ca slujitori ai lui Hristos și administratori ai tainelor lui Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Aici, de altfel, se cere de la administratori să fie găsiți credincioși. ");
INSERT INTO ronlsb_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","Dar în ceea ce mă privește pe mine, este un lucru foarte neînsemnat să fiu judecat de voi sau de un tribunal omenesc. Da, nici măcar nu mă judec pe mine însumi. ");
INSERT INTO ronlsb_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","Căci nu știu nimic împotriva mea însumi. Cu toate acestea, nu prin aceasta sunt îndreptățit, ci cel care mă judecă este Domnul. ");
INSERT INTO ronlsb_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","Așadar, nu judecați nimic înainte de vreme, până când va veni Domnul, care va scoate la lumină atât lucrurile ascunse ale întunericului, cât și va descoperi sfaturile inimilor. Atunci fiecare își va primi lauda de la Dumnezeu. ");
INSERT INTO ronlsb_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","Și aceste lucruri, fraților, le-am transferat, în chip figurat, mie însumi și lui Apolo, din pricina voastră, ca să învățați în noi să nu gândiți mai mult decât este scris, ca să nu vă îngâmfați unii împotriva altora. ");
INSERT INTO ronlsb_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","Căci cine vă deosebește? Și ce aveți voi, pe care nu l-ați primit? Dar dacă l-ați primit, de ce vă lăudați ca și cum nu l-ați fi primit? ");
INSERT INTO ronlsb_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","Sunteți deja plini. Ați devenit deja bogați. Ai venit să domnești fără noi. Da, și aș vrea să domnești, pentru ca și noi să domnească împreună cu tine! ");
INSERT INTO ronlsb_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","Căci mă gândesc că Dumnezeu ne-a arătat pe noi, apostolii, cei din urmă, ca pe niște condamnați la moarte. Căci suntem dați în spectacol lumii, atât îngerilor, cât și oamenilor. ");
INSERT INTO ronlsb_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","Noi suntem nebuni din cauza lui Hristos, dar voi sunteți înțelepți în Hristos. Noi suntem slabi, dar voi sunteți puternici. Voi aveți onoare, dar noi avem dezonoare. ");
INSERT INTO ronlsb_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","Chiar și în ceasul acesta flămânzim, ne este sete, suntem goi, suntem bătuți și nu avem o locuință sigură. ");
INSERT INTO ronlsb_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","Ne chinuim, muncind cu mâinile noastre. Când oamenii ne blestemă, noi binecuvântăm. Fiind persecutați, noi îndurăm. ");
INSERT INTO ronlsb_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","Fiind defăimați, noi implorăm. Suntem făcuți ca mizeria lumii, murdăria ștearsă de toți, chiar și până acum. ");
INSERT INTO ronlsb_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","Nu vă scriu aceste lucruri ca să vă rușinez, ci ca să vă îndemn ca pe niște copii iubiți ai Mei. ");
INSERT INTO ronlsb_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","Căci, deși aveți zece mii de îndrumători în Hristos, nu aveți mulți părinți. Căci, în Cristos Isus, eu am devenit tatăl vostru prin Buna Vestire. ");
INSERT INTO ronlsb_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","Vă rog, așadar, să fiți imitatori ai mei. ");
INSERT INTO ronlsb_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","Din această cauză, v-am trimis pe Timotei, care este copilul meu iubit și credincios în Domnul, care vă va reaminti căile mele care sunt în Cristos, așa cum învăț eu pretutindeni, în orice adunare. ");
INSERT INTO ronlsb_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","Acum, unii sunt îngâmfați, ca și cum n-aș veni la voi. ");
INSERT INTO ronlsb_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","Dar voi veni la voi în curând, dacă Domnul vrea. Și voi cunoaște, nu cuvântul celor ce se umflă în pene, ci puterea. ");
INSERT INTO ronlsb_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","Căci Împărăția lui Dumnezeu nu este în cuvânt, ci în putere. ");
INSERT INTO ronlsb_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","Ce vreți voi? Să vin l