﻿USE sofia;
DROP TABLE IF EXISTS sofia.ronbtf_vpl;
CREATE TABLE ronbtf_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ronbtf_vpl WRITE;
INSERT INTO ronbtf_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","La început Dumnezeu a creat cerul şi pământul. ");
INSERT INTO ronbtf_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Şi pământul era fără formă şi gol; şi întuneric era peste suprafaţa adâncului. Şi Duhul lui Dumnezeu se mişca peste suprafaţa apelor. ");
INSERT INTO ronbtf_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Şi Dumnezeu a spus: Să fie lumină! Şi a fost lumină. ");
INSERT INTO ronbtf_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Şi Dumnezeu a văzut lumina, că era bună; şi Dumnezeu a despărţit lumina de întuneric. ");
INSERT INTO ronbtf_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Şi Dumnezeu a numit lumina zi şi întunericul l-a numit noapte. Şi a fost o seară şi o dimineaţă: ziua întâi. ");
INSERT INTO ronbtf_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Şi Dumnezeu a spus: Să fie o întindere în mijlocul apelor şi aceasta să despartă apele de ape. ");
INSERT INTO ronbtf_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Şi Dumnezeu a făcut întinderea şi a despărţit apele care erau dedesubtul întinderii de apele care erau deasupra întinderii şi aşa a fost. ");
INSERT INTO ronbtf_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Şi Dumnezeu a numit întinderea cer. Şi a fost o seară şi o dimineaţă: ziua a doua. ");
INSERT INTO ronbtf_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Şi Dumnezeu a spus: Apele de sub cer să se adune la un loc şi să se arate uscatul. Şi aşa a fost. ");
INSERT INTO ronbtf_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Şi Dumnezeu a numit uscatul pământ, şi adunarea apelor a numit-o mări; şi Dumnezeu a văzut că lucrul acesta era bun. ");
INSERT INTO ronbtf_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Şi Dumnezeu a spus: Să dea pământul iarbă, verdeaţa care aduce sămânţă şi pomi roditori care aduc rod după felul lor, a căror sămânţă este în ei, pe pământ. Şi aşa a fost. ");
INSERT INTO ronbtf_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Şi pământul a dat iarbă şi verdeaţă care aduce sămânţă după felul ei şi pomi care aduc rod, a căror sămânţă era în ei, după felul lor; şi Dumnezeu a văzut că lucrul acesta era bun. ");
INSERT INTO ronbtf_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Şi a fost o seară şi o dimineaţă: ziua a treia. ");
INSERT INTO ronbtf_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Şi Dumnezeu a spus: Să fie luminători în întinderea cerului pentru a despărţi ziua de noapte; şi ei să fie pentru semne şi pentru anotimpuri şi pentru zile şi ani; ");
INSERT INTO ronbtf_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Şi ei să fie ca luminători în întinderea cerului pentru a da lumină peste pământ. Şi aşa a fost. ");
INSERT INTO ronbtf_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Şi Dumnezeu a făcut doi luminători mari: luminătorul mai mare pentru a stăpâni ziua şi luminătorul mai mic pentru a stăpâni noaptea; el a făcut de asemenea stelele. ");
INSERT INTO ronbtf_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Şi Dumnezeu i-a pus în întinderea cerului pentru a da lumină peste pământ, ");
INSERT INTO ronbtf_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Şi pentru a stăpâni peste zi şi peste noapte şi să despartă lumina de întuneric; şi Dumnezeu a văzut că lucrul acesta era bun. ");
INSERT INTO ronbtf_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Şi a fost o seară şi o dimineaţă: ziua a patra. ");
INSERT INTO ronbtf_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Şi Dumnezeu a spus: Apele să dea abundent fiinţa mişcătoare care are viaţă şi păsări să zboare deasupra pământului pe faţa întinderii cerului. ");
INSERT INTO ronbtf_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Şi Dumnezeu a creat balene mari şi fiecare vieţuitoare care se mişcă, pe care apele le-au dat abundent, după felul lor, şi fiecare pasăre înaripată, după felul ei; şi Dumnezeu a văzut că lucrul acesta era bun. ");
INSERT INTO ronbtf_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Şi Dumnezeu le-a binecuvântat, spunând: Fiţi roditori şi înmulţiţi-vă şi umpleţi apele în mări, şi pasărea să se înmulţească pe pământ. ");
INSERT INTO ronbtf_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Şi a fost o seară şi o dimineaţă: ziua a cincea. ");
INSERT INTO ronbtf_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Şi Dumnezeu a spus: Să dea pământul fiinţa vie după felul ei, vite şi târâtoare şi fiare ale pământului, după felul lor. Şi aşa a fost. ");
INSERT INTO ronbtf_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Şi Dumnezeu a făcut fiara pământului, după felul ei, şi vite, după felul lor, şi fiecare târâtoare pe pământ, după felul ei; şi Dumnezeu a văzut că lucrul acesta era bun. ");
INSERT INTO ronbtf_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Şi Dumnezeu a spus: Să facem om după chipul nostru, după asemănarea noastră; şi ei să domnească peste peştii mării şi peste păsările cerului şi peste vite şi peste tot pământul şi peste fiecare târâtoare ce se târăşte pe pământ. ");
INSERT INTO ronbtf_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Astfel Dumnezeu a creat om după propriul său chip, după chipul lui Dumnezeu l-a creat, parte bărbătească şi parte femeiască i-a creat. ");
INSERT INTO ronbtf_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Şi Dumnezeu i-a binecuvântat şi Dumnezeu le-a spus: Fiţi roditori şi înmulţiţi-vă şi umpleţi pământul şi supuneţi-l şi domniţi peste peştii mării şi peste păsările cerului şi peste fiecare vieţuitoare ce se mişcă pe pământ. ");
INSERT INTO ronbtf_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Şi Dumnezeu a spus: Iată, v-am dat fiecare verdeaţă care aduce sămânţă, care este peste faţa întregului pământ, şi fiecare pom, în care este rodul unui pom care aduce sămânţă, aceasta vă va fi pentru mâncare. ");
INSERT INTO ronbtf_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Şi fiecărei fiare a pământului şi fiecărei păsări a cerului şi fiecărei târâtoare pe pământ, în care este viaţă, le-am dat fiecare plantă verde pentru mâncare; şi aşa a fost. ");
INSERT INTO ronbtf_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Şi Dumnezeu a văzut fiecare lucru pe care l-a făcut şi, iată, totul era foarte bun. Şi a fost o seară şi o dimineaţă: ziua a şasea. ");
INSERT INTO ronbtf_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Astfel au fost terminate cerurile şi pământul şi toată oştirea lor. ");
INSERT INTO ronbtf_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Şi în ziua a şaptea Dumnezeu şi-a terminat lucrarea pe care o făcuse; şi în ziua a şaptea s-a odihnit de toată lucrarea lui pe care o făcuse. ");
INSERT INTO ronbtf_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Şi Dumnezeu a binecuvântat ziua a şaptea şi a sfinţit-o, pentru că în aceasta s-a odihnit de toată lucrarea sa, pe care Dumnezeu a creat-o şi a făcut-o. ");
INSERT INTO ronbtf_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Acestea sunt generaţiile cerurilor şi ale pământului când au fost create, în ziua în care DOMNUL Dumnezeu a făcut pământul şi cerurile, ");
INSERT INTO ronbtf_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Şi fiecare verdeaţă a câmpului, înainte ca aceasta să fi fost în pământ, şi fiecare verdeaţă a câmpului înainte de a fi încolţit, pentru că DOMNUL Dumnezeu nu făcuse să plouă peste pământ şi nu era om să are pământul. ");
INSERT INTO ronbtf_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Ci un abur se ridica din pământ şi uda toată suprafaţa pământului. ");
INSERT INTO ronbtf_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Şi DOMNUL Dumnezeu l-a format pe om din ţărâna pământului şi i-a suflat în nări suflarea vieţii şi omul a devenit un suflet viu. ");
INSERT INTO ronbtf_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Şi DOMNUL Dumnezeu a sădit o grădină înspre est, în Eden, şi acolo a pus pe omul pe care l-a format. ");
INSERT INTO ronbtf_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Şi din pământ DOMNUL Dumnezeu a făcut să încolţească fiecare pom care este plăcut la vedere şi bun pentru mâncare şi pomul vieţii, de asemenea, în mijlocul grădinii şi pomul cunoaşterii binelui şi răului. ");
INSERT INTO ronbtf_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Şi un râu ieşea din Eden ca să ude grădina; şi de acolo se împărţea şi se făcea patru capete. ");
INSERT INTO ronbtf_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Numele întâiului este Pison: acesta este cel ce înconjoară întreaga ţară Havila, unde este aur. ");
INSERT INTO ronbtf_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Şi aurul acelei ţări este bun: acolo este bedelium şi piatra de onix. ");
INSERT INTO ronbtf_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Şi numele celui de al doilea râu este Ghihon: acesta este cel ce înconjoară întreaga ţară a Etiopiei. ");
INSERT INTO ronbtf_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Şi numele celui de al treilea râu este Hidechel: acesta este cel ce merge spre estul Asiriei. Şi al patrulea râu este Eufratul. ");
INSERT INTO ronbtf_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Şi DOMNUL Dumnezeu l-a luat pe om şi l-a pus în grădina Edenului, să o lucreze şi să o păzească. ");
INSERT INTO ronbtf_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Şi DOMNUL Dumnezeu i-a poruncit omului, spunând: Din orice pom din grădină poţi mânca în voie, ");
INSERT INTO ronbtf_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Dar din pomul cunoaşterii binelui şi răului să nu mănânci, căci în ziua în care vei mânca din el, vei muri negreşit. ");
INSERT INTO ronbtf_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Şi DOMNUL Dumnezeu a spus: Nu este bine ca omul să fie singur; îi voi face un ajutor potrivit pentru el. ");
INSERT INTO ronbtf_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Şi din pământ DOMNUL Dumnezeu a format fiecare fiară a câmpului şi fiecare pasăre a cerului şi le-a adus la Adam să vadă cum le va numi; şi oricum a numit Adam fiecare fiinţa vie, acela a fost numele ei. ");
INSERT INTO ronbtf_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Şi Adam a dat nume tuturor vitelor şi tuturor păsărilor cerului şi fiecărei fiare a câmpului, dar pentru Adam nu s-a găsit un ajutor potrivit pentru el. ");
INSERT INTO ronbtf_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Şi DOMNUL Dumnezeu a făcut să cadă un somn adânc peste Adam; şi Adam a dormit; şi a luat una din coastele lui şi a închis carnea la loc; ");
INSERT INTO ronbtf_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Şi din coasta pe care DOMNUL Dumnezeu a luat-o de la om, a făcut o femeie şi a adus-o la om. ");
INSERT INTO ronbtf_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Şi Adam a spus: Aceasta este acum os din oasele mele şi carne din carnea mea; ea se va chema femeie, pentru că a fost luată din bărbat. ");
INSERT INTO ronbtf_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","De aceea va lăsa un bărbat pe tatăl său şi pe mama sa şi se va lipi de soţia sa şi cei doi vor fi un singur trup. ");
INSERT INTO ronbtf_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Şi ei erau amândoi goi, omul şi soţia sa, şi nu se ruşinau. ");
INSERT INTO ronbtf_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Acum şarpele era mai viclean decât orice fiară a câmpului pe care DOMNUL Dumnezeu a făcut-o. Şi a spus femeii: Oare a spus Dumnezeu: Să nu mâncaţi din fiecare pom al grădinii? ");
INSERT INTO ronbtf_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Şi femeia a spus şarpelui: Putem să mâncăm din rodul pomilor grădinii, ");
INSERT INTO ronbtf_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Dar despre rodul pomului care este în mijlocul grădinii, Dumnezeu a spus: Să nu mâncaţi din el, nici să nu îl atingeţi, ca nu cumva să muriţi. ");
INSERT INTO ronbtf_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Şi şarpele a spus femeii: Nu veţi muri nicidecum; ");
INSERT INTO ronbtf_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Fiindcă Dumnezeu ştie că în ziua în care voi mâncaţi din acesta, atunci ochii voştri vor fi deschişi şi veţi fi ca dumnezei, cunoscând binele şi răul. ");
INSERT INTO ronbtf_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Şi când femeia a văzut că pomul era bun pentru mâncare şi că era plăcut ochilor şi un pom de dorit să facă pe cineva înţelept, ea a luat din rodul lui şi a mâncat şi a dat de asemenea soţului ei care era cu ea şi a mâncat şi el. ");
INSERT INTO ronbtf_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Şi li s-au deschis ochii la amândoi şi au ştiut că erau goi; şi au cusut frunze de smochin laolaltă şi şi-au făcut şorţuri. ");
INSERT INTO ronbtf_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Şi au auzit vocea DOMNULUI Dumnezeu umblând în grădină în răcoarea zilei; şi Adam şi soţia lui s-au ascuns de prezența DOMNULUI Dumnezeu, printre pomii grădinii. ");
INSERT INTO ronbtf_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Şi DOMNUL Dumnezeu l-a chemat pe Adam şi i-a spus: Unde eşti? ");
INSERT INTO ronbtf_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Iar el a spus: Am auzit vocea ta în grădină şi m-am temut, pentru că eram gol; şi m-am ascuns. ");
INSERT INTO ronbtf_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Iar el a spus: Cine ţi-a spus că erai gol? Ai mâncat din pomul din care ţi-am poruncit să nu mănânci? ");
INSERT INTO ronbtf_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Şi omul a spus: Femeia pe care mi-ai dat-o să fie cu mine, ea mi-a dat din pom şi eu am mâncat. ");
INSERT INTO ronbtf_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Şi DOMNUL Dumnezeu a spus femeii: Ce este aceasta ce ai făcut? Şi femeia a spus: Şarpele m-a înşelat şi eu am mâncat. ");
INSERT INTO ronbtf_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Şi DOMNUL Dumnezeu a spus şarpelui: Pentru că ai făcut aceasta, eşti blestemat mai mult decât toate vitele şi mai mult decât fiecare fiară a câmpului; pe pântecele tău vei merge şi ţărână vei mânca toate zilele vieţii tale. ");
INSERT INTO ronbtf_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Şi voi pune duşmănie între tine şi femeie şi între sămânţa ta şi sămânţa ei; el îţi va zdrobi capul, și tu îi vei zdrobi călcâiul. ");
INSERT INTO ronbtf_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Femeii i-a spus: Mult îţi voi înmulţi tristeţea şi însărcinarea ta, cu tristeţe vei naşte copii şi dorinţa ta va fi spre soţul tău şi el va stăpâni peste tine. ");
INSERT INTO ronbtf_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Şi lui Adam i-a spus: Pentru că ai dat ascultare vocii soţiei tale şi ai mâncat din pomul despre care ţi-am poruncit, zicând: Să nu mănânci din el, blestemat este pământul din cauza ta; în tristeţe vei mânca din el toate zilele vieţii tale; ");
INSERT INTO ronbtf_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Spini şi ciulini îţi va aduce şi vei mânca verdeaţa câmpului; ");
INSERT INTO ronbtf_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","În sudoarea feţei tale vei mânca pâine, până te vei întoarce în pământ, pentru că din el ai fost luat: căci ţărână eşti şi în ţărână te vei întoarce. ");
INSERT INTO ronbtf_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Şi Adam i-a dat soţiei sale numele Eva, pentru că ea a fost mama tuturor celor vii. ");
INSERT INTO ronbtf_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Lui Adam şi soţiei lui, de asemenea, DOMNUL Dumnezeu le-a făcut haine de piei şi i-a îmbrăcat. ");
INSERT INTO ronbtf_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Şi DOMNUL Dumnezeu a spus: Iată, omul a devenit ca unul dintre noi, să cunoască binele şi răul. Şi acum, ca nu cumva să îşi întindă mâna şi să ia de asemenea din pomul vieţii şi să mănânce şi să trăiască pentru totdeauna, ");
INSERT INTO ronbtf_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","De aceea DOMNUL Dumnezeu l-a trimis din grădina Edenului, ca să are pământul din care fusese luat. ");
INSERT INTO ronbtf_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Astfel l-a alungat afară pe om şi a aşezat la est de grădina Edenului nişte heruvimi şi o sabie arzând care se întorcea în fiecare parte, pentru a păzi calea pomului vieţii. ");
INSERT INTO ronbtf_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Şi Adam a cunoscut-o pe Eva, soţia lui, şi ea a rămas însărcinată şi a născut pe Cain şi a spus: Am primit un bărbat de la DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Şi ea a mai născut pe fratele lui, Abel. Şi Abel era păzitor de oi, dar Cain era lucrător al pământului. ");
INSERT INTO ronbtf_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Şi s-a întâmplat că, după un timp, Cain a adus un dar DOMNULUI, din rodul pământului. ");
INSERT INTO ronbtf_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Şi Abel, de asemenea, a adus din întâii născuţi ai turmei sale şi din grăsimea lor. Şi DOMNUL s-a uitat cu plăcere la Abel şi la darul său. ");
INSERT INTO ronbtf_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Dar la Cain şi la darul său nu s-a uitat cu plăcere. Şi Cain s-a înfuriat tare şi i s-a posomorât faţa. ");
INSERT INTO ronbtf_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Şi DOMNUL i-a spus lui Cain: De ce te-ai înfuriat? Şi de ce ţi s-a posomorât faţa? ");
INSERT INTO ronbtf_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Dacă faci bine, nu vei fi acceptat? Iar dacă nu faci bine, păcatul pândeşte la uşă. Şi dorinţa lui se ţine de tine, dar tu să stăpâneşti peste el. ");
INSERT INTO ronbtf_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Iar Cain a vorbit cu Abel, fratele său, şi a fost aşa: când erau ei pe câmp, Cain s-a ridicat împotriva lui Abel, fratele său, şi l-a ucis. ");
INSERT INTO ronbtf_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Şi DOMNUL i-a spus lui Cain: Unde este Abel, fratele tău? Iar el a spus: Nu ştiu; sunt eu păzitorul fratelui meu? ");
INSERT INTO ronbtf_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Iar el a spus: Ce ai făcut? Vocea sângelui fratelui tău strigă din pământ către mine. ");
INSERT INTO ronbtf_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Şi acum eşti blestemat de pe pământul care şi-a deschis gura să primească sângele fratelui tău din mâna ta. ");
INSERT INTO ronbtf_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Când lucrezi pământul, acesta nu îţi va mai da de aici înainte puterea lui; un fugar şi un rătăcitor vei fi pe pământ. ");
INSERT INTO ronbtf_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Şi Cain a spus DOMNULUI: Pedeapsa mea este mai mare decât o pot purta. ");
INSERT INTO ronbtf_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Iată, tu m-ai alungat astăzi de pe faţa pământului şi de la faţa ta voi fi ascuns şi voi fi un fugar şi un rătăcitor pe pământ şi se va întâmpla că oricine mă găseşte mă va ucide. ");
INSERT INTO ronbtf_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Şi DOMNUL i-a spus: De aceea, oricine ucide pe Cain, răzbunare va fi asupra lui de şapte ori. Şi DOMNUL a pus un semn pe Cain, ca nu cumva cineva, găsindu-l, să îl ucidă. ");
INSERT INTO ronbtf_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Şi Cain a ieşit din prezența DOMNULUI şi a locuit în ţara Nod, la est de Eden. ");
INSERT INTO ronbtf_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Şi Cain a cunoscut-o pe soţia sa şi ea a rămas însărcinată şi a născut pe Enoh; şi a zidit o cetate şi a pus numele cetăţii după numele fiului său, Enoh. ");
INSERT INTO ronbtf_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Şi lui Enoh i s-a născut Irad; şi Irad a născut pe Mehuiael; şi Mehuiael a născut pe Metuşael; şi Metuşael a născut pe Lameh. ");
INSERT INTO ronbtf_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Şi Lameh şi-a luat două soţii: numele uneia era Ada şi numele celeilalte, Ţila. ");
INSERT INTO ronbtf_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Şi Ada a născut pe Iabal: el a fost tatăl celor ce locuiesc în corturi şi au vite. ");
INSERT INTO ronbtf_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Şi numele fratelui său era Iubal: el a fost tatăl tuturor celor ce mânuiesc harpa şi instrumentul de suflat. ");
INSERT INTO ronbtf_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Şi Ţila, de asemenea, a născut pe Tubal-Cain, instructor al fiecărui meşteşugar în aramă şi fier; şi sora lui Tubal-Cain a fost Naama. ");
INSERT INTO ronbtf_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Şi Lameh a spus soţiilor lui, Ada şi Ţila: Auziţi vocea mea, voi soţiile lui Lameh, daţi ascultare la vorbirea mea: pentru că am ucis un om pentru rănirea mea şi un tânăr pentru vânătaia mea. ");
INSERT INTO ronbtf_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Dacă va fi răzbunat Cain de şapte ori, cu adevărat, Lameh de şaptezeci şi şapte de ori. ");
INSERT INTO ronbtf_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Şi Adam a cunoscut-o din nou pe soţia lui şi ea a născut un fiu şi i-a pus numele Set: Pentru că Dumnezeu, a spus ea, mi-a rânduit o altă sămânţă în locul lui Abel, pe care l-a ucis Cain. ");
INSERT INTO ronbtf_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Şi lui Set, de asemenea, i s-a născut un fiu şi i-a pus numele Enos: atunci au început oamenii să cheme numele DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Aceasta este cartea generaţiilor lui Adam. În ziua în care Dumnezeu a creat om, l-a făcut după asemănarea lui Dumnezeu. ");
INSERT INTO ronbtf_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Parte bărbătească şi parte femeiască i-a creat şi i-a binecuvântat şi le-a pus numele lor, Adam, în ziua în care au fost creaţi. ");
INSERT INTO ronbtf_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Şi Adam a trăit o sută treizeci de ani şi a născut un fiu în propria lui asemănare, după chipul lui, şi i-a pus numele Set; ");
INSERT INTO ronbtf_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Şi zilele lui Adam, după ce a născut pe Set, au fost de opt sute de ani; şi a născut fii şi fiice; ");
INSERT INTO ronbtf_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Şi toate zilele pe care Adam le-a trăit au fost nouă sute treizeci de ani; şi a murit. ");
INSERT INTO ronbtf_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Şi Set a trăit o sută cinci ani şi a născut pe Enos; ");
INSERT INTO ronbtf_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Şi Set a trăit, după ce a născut pe Enos, opt sute şapte ani; şi a născut fii şi fiice; ");
INSERT INTO ronbtf_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Şi toate zilele lui Set au fost nouă sute doisprezece ani; şi a murit. ");
INSERT INTO ronbtf_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Şi Enos a trăit nouăzeci de ani şi a născut pe Cainan; ");
INSERT INTO ronbtf_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Şi Enos a trăit, după ce a născut pe Cainan, opt sute cincisprezece ani; şi a născut fii şi fiice; ");
INSERT INTO ronbtf_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Şi toate zilele lui Enos au fost nouă sute cinci ani; şi a murit. ");
INSERT INTO ronbtf_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Şi Cainan a trăit şaptezeci de ani şi a născut pe Mahalaleel; ");
INSERT INTO ronbtf_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Şi Cainan a trăit, după ce a născut pe Mahalaleel, opt sute patruzeci de ani; şi a născut fii şi fiice; ");
INSERT INTO ronbtf_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Şi toate zilele lui Cainan au fost nouă sute zece ani; şi a murit. ");
INSERT INTO ronbtf_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Şi Mahalaleel a trăit şaizeci şi cinci de ani şi a născut pe Iared; ");
INSERT INTO ronbtf_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Şi Mahalaleel a trăit, după ce a născut pe Iared, opt sute treizeci de ani; şi a născut fii şi fiice; ");
INSERT INTO ronbtf_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Şi toate zilele lui Mahalaleel au fost opt sute nouăzeci şi cinci de ani; şi a murit. ");
INSERT INTO ronbtf_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Şi Iared a trăit o sută şaizeci şi doi de ani şi a născut pe Enoh; ");
INSERT INTO ronbtf_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Şi Iared a trăit după ce a născut pe Enoh, opt sute de ani; şi a născut fii şi fiice; ");
INSERT INTO ronbtf_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Şi toate zilele lui Iared au fost nouă sute şaizeci şi doi de ani; şi a murit. ");
INSERT INTO ronbtf_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Şi Enoh a trăit şaizeci şi cinci de ani şi a născut pe Metusala; ");
INSERT INTO ronbtf_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Şi Enoh a umblat cu Dumnezeu, după ce a născut pe Metusala, trei sute de ani; şi a născut fii şi fiice; ");
INSERT INTO ronbtf_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Şi toate zilele lui Enoh au fost trei sute şaizeci şi cinci de ani; ");
INSERT INTO ronbtf_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Şi Enoh a umblat cu Dumnezeu: şi nu a mai fost, pentru că Dumnezeu l-a luat. ");
INSERT INTO ronbtf_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Şi Metusala a trăit o sută optzeci şi şapte de ani şi a născut pe Lameh; ");
INSERT INTO ronbtf_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Şi Metusala a trăit, după ce a născut pe Lameh, şapte sute optzeci şi doi de ani; şi a născut fii şi fiice; ");
INSERT INTO ronbtf_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Şi toate zilele lui Metusala au fost nouă sute şaizeci şi nouă de ani; şi a murit. ");
INSERT INTO ronbtf_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Şi Lameh a trăit o sută optzeci şi doi de ani şi a născut un fiu; ");
INSERT INTO ronbtf_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Şi i-a pus numele Noe, spunând: Acesta ne va mângâia pentru lucrarea noastră şi osteneala mâinilor noastre, din cauza pământului pe care Dumnezeu l-a blestemat. ");
INSERT INTO ronbtf_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Şi Lameh a trăit, după ce a născut pe Noe, cinci sute nouăzeci şi cinci de ani; şi a născut fii şi fiice; ");
INSERT INTO ronbtf_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Şi toate zilele lui Lameh au fost şapte sute şaptezeci şi şapte de ani; şi a murit. ");
INSERT INTO ronbtf_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Şi Noe a fost în vârstă de cinci sute de ani; şi Noe a născut pe Sem, Ham şi Iafet. ");
INSERT INTO ronbtf_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Şi s-a întâmplat, pe când oamenii au început a se înmulţi pe faţa pământului şi li s-au născut fiice, ");
INSERT INTO ronbtf_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Că fiii lui Dumnezeu au văzut că fiicele oamenilor erau frumoase şi şi-au luat soţii din toate pe care le-au ales. ");
INSERT INTO ronbtf_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Şi DOMNUL a spus: Duhul meu nu se va lupta întotdeauna cu omul, căci el este de asemenea şi carne; totuşi zilele lui vor fi o sută douăzeci de ani. ");
INSERT INTO ronbtf_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Erau uriaşi pe pământ în acele zile şi, de asemenea, după aceea, când fiii lui Dumnezeu au intrat la fiicele oamenilor şi ele le-au născut copii, aceştia au fost războinicii, care au fost în vechime oameni de renume. ");
INSERT INTO ronbtf_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Şi Dumnezeu a văzut că stricăciunea omului era mare pe pământ şi că fiecare imaginaţie a gândurilor inimii sale era numai facere de rău continuă. ");
INSERT INTO ronbtf_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Şi aceasta l-a făcut pe DOMNUL să se pocăiască pentru că a făcut pe om pe pământ şi l-a mâhnit în inima lui. ");
INSERT INTO ronbtf_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Şi DOMNUL a spus: Voi nimici de pe faţa pământului pe omul pe care l-am creat, deopotrivă om şi animal şi târâtoarea şi păsările cerului, fiindcă aceasta mă face să mă pocăiesc că i-am făcut. ");
INSERT INTO ronbtf_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Dar Noe a găsit har în ochii DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Acestea sunt generaţiile lui Noe: Noe a fost un bărbat drept şi desăvârşit în generaţiile lui şi Noe a umblat cu Dumnezeu. ");
INSERT INTO ronbtf_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Şi Noe a născut trei fii: Sem, Ham şi Iafet. ");
INSERT INTO ronbtf_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Şi pământul era corupt înaintea lui Dumnezeu şi pământul era umplut de violenţă. ");
INSERT INTO ronbtf_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Şi Dumnezeu a privit peste pământ şi, iată, acesta era corupt, pentru că toată făptura şi-a corupt calea pe pământ. ");
INSERT INTO ronbtf_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Şi Dumnezeu i-a spus lui Noe: Sfârşitul a toată făptura a ajuns înaintea mea, fiindcă pământul este plin de violenţă din cauza lor; şi, iată, îi voi nimici împreună cu pământul. ");
INSERT INTO ronbtf_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Fă-ţi o arcă din lemn de gofer, să faci camere în arcă şi să o smoleşti pe dinăuntru şi pe dinafară cu smoală. ");
INSERT INTO ronbtf_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Şi acesta este modelul după care să o faci: Lungimea arcei să fie de trei sute de coţi, lăţimea acesteia cincizeci de coţi şi înălţimea acesteia treizeci de coţi. ");
INSERT INTO ronbtf_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Să faci arcei o fereastră, deasupra, să o termini la un cot de la acoperiş, şi uşa arcei să o aşezi în latura arcei; să faci arca cu trei nivele: cel de jos, al doilea şi al treilea. ");
INSERT INTO ronbtf_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Şi iată, eu, chiar eu, voi aduce un potop de ape peste pământ, pentru a nimici toată făptura de sub cer, în care este suflarea vieţii şi fiecare lucru care este pe pământ va muri. ");
INSERT INTO ronbtf_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Dar cu tine îmi voi întemeia legământul meu; şi să intri în arcă, tu şi fiii tăi şi soţia ta şi soţiile fiilor tăi cu tine. ");
INSERT INTO ronbtf_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Şi din fiecare vieţuitoare de orice făptură, două din fiecare soi, să aduci în arcă, pentru a le ţine în viaţă cu tine; să fie parte bărbătească şi parte femeiască. ");
INSERT INTO ronbtf_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Din păsări, după felul lor, şi din vite, după felul lor, şi din fiecare târâtoare a pământului, după felul ei, două din fiecare soi vor veni la tine, pentru a le ţine în viaţă. ");
INSERT INTO ronbtf_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Şi ia la tine din toată mâncarea care se mănâncă şi strânge-o la tine şi va fi mâncare pentru tine şi pentru ele. ");
INSERT INTO ronbtf_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Astfel a făcut Noe, conform cu tot ceea ce Dumnezeu i-a poruncit, astfel a făcut el. ");
INSERT INTO ronbtf_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Şi DOMNUL i-a spus lui Noe: Intră tu şi toată casa ta în arcă, fiindcă te-am văzut drept înaintea mea în această generaţie. ");
INSERT INTO ronbtf_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Din fiecare fiară curată să iei la tine câte şapte perechi, partea bărbătească şi partea sa femeiască, şi din fiarele care nu sunt curate, câte două, partea bărbătească şi partea sa femeiască. ");
INSERT INTO ronbtf_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Din păsările cerului de asemenea câte şapte perechi, partea bărbătească şi partea femeiască, pentru a ţine sămânţă în viaţă peste faţa întregului pământ. ");
INSERT INTO ronbtf_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Căci încă şapte zile şi voi face să plouă peste pământ patruzeci de zile şi patruzeci de nopţi şi orice lucru viu pe care l-am făcut, îl voi distruge de pe faţa pământului. ");
INSERT INTO ronbtf_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Şi Noe a făcut conform cu tot ceea ce DOMNUL i-a poruncit. ");
INSERT INTO ronbtf_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Şi Noe era în vârstă de şase sute de ani când potopul apelor era peste pământ. ");
INSERT INTO ronbtf_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Şi Noe a intrat şi fiii lui şi soţia lui şi soţiile fiilor lui cu el în arcă, din cauza apelor potopului. ");
INSERT INTO ronbtf_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Din fiare curate şi din fiare care nu sunt curate şi din păsări şi din fiecare lucru care se târăşte pe pământ, ");
INSERT INTO ronbtf_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Au intrat două câte două la Noe în arcă, partea bărbătească şi partea femeiască, aşa cum Dumnezeu a poruncit lui Noe. ");
INSERT INTO ronbtf_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Şi s-a întâmplat, după şapte zile, că apele potopului au venit peste pământ. ");
INSERT INTO ronbtf_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","În anul şase sute al vieţii lui Noe, în luna a doua, în a şaptesprezecea zi a lunii, în acea zi au fost toate fântânile marelui adânc despicate şi ferestrele cerului s-au deschis. ");
INSERT INTO ronbtf_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Şi ploaia a fost peste pământ patruzeci de zile şi patruzeci de nopţi. ");
INSERT INTO ronbtf_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","În chiar aceeaşi zi a intrat Noe şi Sem şi Ham şi Iafet, fiii lui Noe şi soţia lui Noe şi cele trei soţii ale fiilor săi cu ei în arcă; ");
INSERT INTO ronbtf_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Ei şi fiecare fiară după felul ei şi toate vitele după felul lor şi fiecare târâtoare ce se târăşte pe pământ după felul ei şi fiecare pasăre după felul ei, fiecare păsărică din fiecare specie. ");
INSERT INTO ronbtf_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Şi au intrat la Noe în arcă două câte două din orice făptură în care este suflarea vieţii. ");
INSERT INTO ronbtf_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Şi cele ce au intrat, au intrat partea bărbătească şi partea femeiască din orice făptură, aşa cum Dumnezeu i-a poruncit lui; şi DOMNUL l-a închis înăuntru. ");
INSERT INTO ronbtf_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Şi potopul a fost patruzeci de zile peste pământ şi apele au crescut şi au purtat sus arca şi aceasta a fost înălţată deasupra pământului. ");
INSERT INTO ronbtf_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Şi apele se înălţau şi s-au înmulţit foarte mult asupra pământului, şi arca mergea pe faţa apelor. ");
INSERT INTO ronbtf_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Şi apele s-au înălţat peste măsură asupra pământului şi toţi munţii înalţi, care erau sub întregul cer, au fost acoperiţi. ");
INSERT INTO ronbtf_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Apele s-au înălţat cu cincisprezece coţi deasupra lor şi munţii au fost acoperiţi. ");
INSERT INTO ronbtf_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Şi a murit orice făptură care mişca pe pământ, deopotrivă pasăre şi vită şi fiară şi fiecare târâtoare care se târăşte pe pământ şi fiecare om; ");
INSERT INTO ronbtf_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Toate în a căror nări era suflarea vieţii, toate câte erau pe uscat, au murit. ");
INSERT INTO ronbtf_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Şi orice lucru viu care a fost pe faţa pământului a fost nimicit, deopotrivă om şi vită şi târâtoarele şi pasărea cerului; şi acestea au fost nimicite de pe pământ; şi numai Noe a rămas în viaţă şi cei ce erau cu el în arcă. ");
INSERT INTO ronbtf_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Şi apele s-au înălţat asupra pământului o sută cincizeci de zile. ");
INSERT INTO ronbtf_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Şi Dumnezeu şi-a adus aminte de Noe şi de fiecare vieţuitoare şi de toate vitele care erau cu el în arcă; şi Dumnezeu a făcut să treacă un vânt peste pământ şi apele s-au retras; ");
INSERT INTO ronbtf_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","De asemenea fântânile adâncului şi ferestrele cerului au fost închise şi ploaia din cer a fost oprită; ");
INSERT INTO ronbtf_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Şi apele se retrăgeau de pe pământ continuu şi după ce s-au sfârşit o sută cincizeci de zile, apele s-au împuţinat. ");
INSERT INTO ronbtf_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Şi arca s-a aşezat în a şaptea lună, în a şaptesprezecea zi a lunii, pe munţii Ararat. ");
INSERT INTO ronbtf_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Şi apele au scăzut continuu până în luna a zecea: în luna a zecea, în prima zi a lunii, s-au văzut vârfurile munţilor. ");
INSERT INTO ronbtf_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Şi s-a întâmplat, după ce s-au sfârşit patruzeci de zile, că Noe a deschis fereastra arcei pe care o făcuse, ");
INSERT INTO ronbtf_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Şi a trimis înainte un corb, care a ieşit şi a mers încolo şi încoace, până când au secat apele de pe pământ. ");
INSERT INTO ronbtf_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","De asemenea a trimis de la el un porumbel, să vadă dacă apele s-au retras de pe faţa pământului; ");
INSERT INTO ronbtf_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Dar porumbelul nu a găsit odihnă pentru talpa piciorului său şi s-a întors la el în arcă, pentru că apele erau pe faţa întregului pământ; atunci a întins mâna şi l-a luat şi l-a dus la el în arcă. ");
INSERT INTO ronbtf_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Şi a mai stat alte şapte zile şi din nou a trimis porumbelul afară din arcă; ");
INSERT INTO ronbtf_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Şi porumbelul a venit la el seara şi, iată, în ciocul lui era o frunză de măslin proaspăt ruptă, aşa că Noe a cunoscut că apele s-au retras de pe pământ. ");
INSERT INTO ronbtf_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Şi a mai stat alte şapte zile şi a trimis porumbelul, care nu s-a mai întors la el. ");
INSERT INTO ronbtf_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Şi s-a întâmplat în anul şase sute şi unu, în prima lună, în prima zi a lunii, apele au secat de pe pământ; şi Noe a ridicat acoperişul arcei şi a privit şi, iată, faţa pământului era uscată. ");
INSERT INTO ronbtf_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Şi în a doua lună, în a douăzeci şi şaptea zi a lunii, pământul a fost uscat. ");
INSERT INTO ronbtf_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Şi Dumnezeu i-a vorbit lui Noe, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Ieşi din arcă, tu şi soţia ta şi fiii tăi şi soţiile fiilor tăi cu tine. ");
INSERT INTO ronbtf_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Scoate împreună cu tine fiecare vieţuitoare care este cu tine, a toată făptura, deopotrivă pasăre şi vită şi fiecare târâtoare care se târăşte pe pământ, ca acestea să nască abundent pe pământ şi să fie roditoare şi să se înmulţească pe pământ. ");
INSERT INTO ronbtf_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Şi Noe a ieşit şi fiii lui şi soţia lui şi soţiile fiilor lui cu el; ");
INSERT INTO ronbtf_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Fiecare fiară, fiecare târâtoare şi fiecare pasăre şi orice se târăşte pe pământ, după felurile lor, au ieşit afară din arcă. ");
INSERT INTO ronbtf_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Şi Noe a zidit un altar DOMNULUI şi a luat din fiecare fiară curată şi din fiecare pasăre curată şi a adus ofrande arse pe altar. ");
INSERT INTO ronbtf_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Şi DOMNUL a mirosit o aromă dulce şi DOMNUL a spus în inima sa: Nu voi mai blestema din nou pământul vreodată din cauza omului, pentru că imaginaţia inimii omului este facere de rău din tinereţea lui, nici nu voi mai lovi din nou vreodată fiecare vieţuitoare, aşa cum am făcut. ");
INSERT INTO ronbtf_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Cât timp pământul rămâne, semănatul şi seceratul şi frig şi arşiţă şi vară şi iarnă şi zi şi noapte nu vor înceta. ");
INSERT INTO ronbtf_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Şi Dumnezeu a binecuvântat pe Noe şi pe fiii lui şi le-a spus: Fiţi roditori şi înmulţiţi-vă şi umpleţi pământul. ");
INSERT INTO ronbtf_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Şi teama de voi şi groaza de voi va fi peste fiecare fiară a pământului şi peste fiecare pasăre a cerului, peste tot ce se mişcă pe pământ şi peste toţi peştii mării; în mâna voastră sunt ele predate. ");
INSERT INTO ronbtf_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Tot ce se mişcă şi trăieşte va fi mâncare pentru voi; precum planta verde, v-am dat toate lucrurile. ");
INSERT INTO ronbtf_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Dar carne cu viaţa ei, ceea ce este sângele ei, să nu mâncaţi. ");
INSERT INTO ronbtf_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Şi cu adevărat sângele vostru, al vieţilor voastre, îl voi cere, din mâna fiecărei fiare îl voi cere şi din mâna omului, din mâna fiecărui frate al omului voi cere viaţa omului. ");
INSERT INTO ronbtf_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Oricine varsă sângele omului, prin om să fie vărsat sângele lui, pentru că după chipul lui Dumnezeu l-a făcut pe om. ");
INSERT INTO ronbtf_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Şi voi fiţi roditori şi înmulţiţi-vă, naşteţi abundent pe pământ şi înmulţiţi-vă pe acesta. ");
INSERT INTO ronbtf_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Şi Dumnezeu i-a vorbit lui Noe şi fiilor lui cu el, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Şi eu, iată, întemeiez legământul meu cu voi şi cu sămânţa voastră după voi; ");
INSERT INTO ronbtf_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Şi cu fiecare creatură vie care este cu voi, dintre păsări, dintre vite şi dintre fiecare fiară a pământului cu voi, de la tot ceea ce iese afară din arcă, până la fiecare fiară a pământului. ");
INSERT INTO ronbtf_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Şi voi întemeia legământul meu cu voi şi nici nu va mai fi toată făptura stârpită vreodată prin apele unui potop, nici nu va mai fi vreodată un potop să distrugă pământul. ");
INSERT INTO ronbtf_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Şi Dumnezeu a spus: Acesta este semnul legământului pe care îl fac între mine şi voi şi fiecare creatură vie care este cu voi, pentru generaţii pentru totdeauna: ");
INSERT INTO ronbtf_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Eu aşez curcubeul meu în nor şi acesta va fi ca semn al unui legământ între mine şi pământ. ");
INSERT INTO ronbtf_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Şi se va întâmpla, când aduc un nor peste pământ, că se va vedea curcubeul în nor: ");
INSERT INTO ronbtf_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Şi îmi voi aminti de legământul meu, care este între mine şi voi şi fiecare creatură vie a toată făptura; şi apele nu vor mai deveni un potop ca să nimicească toată făptura. ");
INSERT INTO ronbtf_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Şi curcubeul va fi în nor şi îl voi privi, ca să îmi amintesc de legământul veşnic dintre Dumnezeu şi fiecare creatură vie, a toată făptura, care este pe pământ. ");
INSERT INTO ronbtf_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Şi Dumnezeu i-a spus lui Noe: Acesta este semnul legământului, pe care l-am întemeiat între mine şi toată făptura care este pe pământ. ");
INSERT INTO ronbtf_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Şi fiii lui Noe, care au ieşit din arcă, au fost Sem şi Ham şi Iafet; şi Ham este tatăl lui Canaan. ");
INSERT INTO ronbtf_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Aceştia sunt cei trei fii ai lui Noe şi din ei a fost acoperit întregul pământ. ");
INSERT INTO ronbtf_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Şi Noe a început a fi agricultor şi a sădit o vie; ");
INSERT INTO ronbtf_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Şi a băut din vin şi s-a îmbătat şi s-a dezgolit înăuntrul cortului său. ");
INSERT INTO ronbtf_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Şi Ham, tatăl lui Canaan, a văzut goliciunea tatălui său şi a spus celor doi fraţi ai săi de afară. ");
INSERT INTO ronbtf_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Şi Sem şi Iafet au luat o haină şi au pus-o peste amândoi umerii lor şi au mers cu spatele şi au acoperit goliciunea tatălui lor şi feţele lor erau întoarse şi nu au văzut goliciunea tatălui lor. ");
INSERT INTO ronbtf_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Şi Noe s-a trezit din beţia vinului său şi a cunoscut ceea ce fiul său mai tânăr i-a făcut. ");
INSERT INTO ronbtf_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Şi a spus: Blestemat fie Canaan, un servitor al servitorilor va fi el fraţilor săi. ");
INSERT INTO ronbtf_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Şi a spus: Binecuvântat fie DOMNUL Dumnezeul lui Sem; şi Canaan va fi servitorul lui. ");
INSERT INTO ronbtf_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Dumnezeu va lărgi pe Iafet şi va locui în corturile lui Sem şi Canaan va fi servitorul lui. ");
INSERT INTO ronbtf_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Şi Noe a trăit după potop trei sute cincizeci de ani. ");
INSERT INTO ronbtf_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Şi toate zilele lui Noe au fost nouă sute cincizeci de ani; şi a murit. ");
INSERT INTO ronbtf_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Acum acestea sunt generaţiile fiilor lui Noe: Sem, Ham şi Iafet; şi li s-au născut fii după potop. ");
INSERT INTO ronbtf_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Fiii lui Iafet: Gomer şi Magog şi Madai şi Iavan şi Tubal şi Meşec şi Tiras. ");
INSERT INTO ronbtf_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Şi fiii lui Gomer: Aşchenaz şi Rifat şi Togarma. ");
INSERT INTO ronbtf_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Şi fiii lui Iavan: Elişa şi Tarsis, Chitim şi Dodanim. ");
INSERT INTO ronbtf_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Prin aceştia au fost împărţite insulele neamurilor în pământurile lor, fiecare după limba lui, după familiile lor, în naţiunile lor. ");
INSERT INTO ronbtf_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Şi fiii lui Ham: Cuş şi Miţraim şi Put şi Canaan. ");
INSERT INTO ronbtf_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Şi fiii lui Cuş: Seba şi Havila şi Sabta şi Raema şi Sabteca; şi fiii lui Raema: Şeba şi Dedan. ");
INSERT INTO ronbtf_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Şi Cuş a născut pe Nimrod, el a început să fie unul puternic pe pământ. ");
INSERT INTO ronbtf_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","El era un vânător puternic înaintea DOMNULUI, de aceea s-a spus: Precum Nimrod, puternicul vânător înaintea DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Şi începutul împărăţiei sale a fost Babel şi Erec şi Acad şi Calne, în ţara Şinar. ");
INSERT INTO ronbtf_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Din acea ţară a ieşit Aşur şi a zidit Ninive şi cetatea Rehobot şi Calah, ");
INSERT INTO ronbtf_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Şi Resen, între Ninive şi Calah; aceasta este o mare cetate. ");
INSERT INTO ronbtf_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Şi Miţraim a născut pe ludimi şi pe anamimi şi pe lehabimi şi pe naftuhimi, ");
INSERT INTO ronbtf_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Şi pe patrusimi şi pe casluhimi, (din care au venit filisteni) şi pe caftorimi. ");
INSERT INTO ronbtf_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Şi Canaan a născut pe Sidon, întâiul său născut, şi pe Het, ");
INSERT INTO ronbtf_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Şi pe iebusiţi şi pe amoriţi şi pe ghirgasiţi, ");
INSERT INTO ronbtf_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Şi pe hiviţi şi pe archiţi şi pe siniţi, ");
INSERT INTO ronbtf_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Şi pe arvadiţi şi pe ţemariţi şi pe hamatiţi şi după aceea familiile canaaniţilor au fost împrăştiate peste tot. ");
INSERT INTO ronbtf_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Şi graniţa canaaniţilor era de la Sidon, precum vii la Gherar, spre Gaza, cum mergi spre Sodoma şi Gomora şi Adma şi Zeboim, până la Leşa. ");
INSERT INTO ronbtf_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Aceştia sunt fiii lui Ham, după familiile lor, după limbile lor, în ţările lor şi în naţiunile lor. ");
INSERT INTO ronbtf_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Lui Sem, de asemenea, tatăl tuturor copiilor lui Eber, fratele lui Iafet, care este mai vârstnic, şi lui i s-au născut copii. ");
INSERT INTO ronbtf_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Copiii lui Sem: Elam şi Aşur şi Arpacşad şi Lud şi Aram. ");
INSERT INTO ronbtf_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Şi copiii lui Aram: Uţ şi Hul şi Gheter şi Maş. ");
INSERT INTO ronbtf_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Şi Arpacşad a născut pe Şelah şi Şelah a născut pe Eber. ");
INSERT INTO ronbtf_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Şi lui Eber i s-au născut doi fii: numele unuia a fost Peleg, pentru că în zilele lui a fost pământul împărţit, şi numele fratelui său a fost Ioctan. ");
INSERT INTO ronbtf_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Şi Ioctan a născut pe Almodad şi pe Şelef şi pe Haţarmavet şi pe Ierah, ");
INSERT INTO ronbtf_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Şi pe Hadoram şi pe Uzal şi pe Dicla, ");
INSERT INTO ronbtf_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Şi pe Obal şi pe Abimael şi pe Şeba, ");
INSERT INTO ronbtf_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Şi pe Ofir şi pe Havila şi pe Iobab, toţi aceştia au fost fiii lui Ioctan. ");
INSERT INTO ronbtf_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Şi locuinţa lor era de la Meşa, aşa cum mergi spre Sefar, un munte spre est. ");
INSERT INTO ronbtf_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Aceştia sunt fiii lui Sem, după familiile lor, după limbile lor, în ţările lor, după naţiunile lor. ");
INSERT INTO ronbtf_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Acestea sunt familiile fiilor lui Noe, după generaţiile lor; în naţiunile lor şi prin aceştia au fost naţiunile împărţite pe pământ după potop. ");
INSERT INTO ronbtf_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Şi întreg pământul era cu o singură limbă şi cu o singură vorbire. ");
INSERT INTO ronbtf_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Şi s-a întâmplat, cum au călătorit de la est, că au găsit o câmpie în ţara Şinar şi au locuit acolo. ");
INSERT INTO ronbtf_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Şi au spus unul altuia: Haidem să facem cărămizi şi să le ardem bine. Şi au avut cărămidă ca piatră şi smoală au avut ca mortar. ");
INSERT INTO ronbtf_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Şi au spus: Haidem să ne zidim o cetate şi un turn, al cărui vârf să ajungă până la cer; şi să ne facem un nume, ca nu cumva să fim împrăştiaţi pretutindeni pe faţa întregului pământ. ");
INSERT INTO ronbtf_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Şi DOMNUL a coborât să vadă cetatea şi turnul, pe care copiii oamenilor le-au zidit. ");
INSERT INTO ronbtf_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Şi DOMNUL a spus: Iată, poporul este unul şi ei toţi au o singură limbă şi au început să facă aceasta, şi acum nimic nu îi va opri din ceea ce au de gând să facă. ");
INSERT INTO ronbtf_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Haidem să coborâm, şi acolo să le încurcăm limba, ca ei să nu mai înţeleagă vorbirea unuia către celălalt. ");
INSERT INTO ronbtf_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Astfel DOMNUL i-a împrăştiat pretutindeni de acolo, peste faţa întregului pământ; şi au încetat a zidi cetatea. ");
INSERT INTO ronbtf_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","De aceea i s-a pus numele Babel, pentru că acolo DOMNUL a încurcat limba întregului pământ; şi de acolo DOMNUL i-a împrăştiat peste faţa întregului pământ. ");
INSERT INTO ronbtf_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Acestea sunt generaţiile lui Sem: Sem era în vârstă de o sută de ani şi a născut pe Arpacşad, la doi ani după potop; ");
INSERT INTO ronbtf_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Şi Sem a trăit, după ce a născut pe Arpacşad, cinci sute de ani; şi a născut fii şi fiice. ");
INSERT INTO ronbtf_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Şi Arpacşad a trăit treizeci şi cinci de ani şi a născut pe Şelah; ");
INSERT INTO ronbtf_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Şi Arpacşad a trăit, după ce a născut pe Şelah, patru sute trei ani; şi a născut fii şi fiice. ");
INSERT INTO ronbtf_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Şi Şelah a trăit treizeci de ani şi a născut pe Eber; ");
INSERT INTO ronbtf_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Şi Şelah a trăit, după ce a născut pe Eber, patru sute trei ani; şi a născut fii şi fiice. ");
INSERT INTO ronbtf_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Şi Eber a trăit treizeci şi patru de ani şi a născut pe Peleg; ");
INSERT INTO ronbtf_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Şi Eber a trăit, după ce a născut pe Peleg, patru sute treizeci de ani; şi a născut fii şi fiice. ");
INSERT INTO ronbtf_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Şi Peleg a trăit treizeci de ani şi a născut pe Reu; ");
INSERT INTO ronbtf_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Şi Peleg a trăit, după ce a născut pe Reu, două sute nouă ani; şi a născut fii şi fiice. ");
INSERT INTO ronbtf_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Şi Reu a trăit treizeci şi doi de ani şi a născut pe Serug; ");
INSERT INTO ronbtf_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Şi Reu a trăit, după ce a născut pe Serug, două sute şapte ani; şi a născut fii şi fiice. ");
INSERT INTO ronbtf_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Şi Serug a trăit treizeci de ani şi a născut pe Nahor; ");
INSERT INTO ronbtf_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Şi Serug a trăit, după ce a născut pe Nahor; două sute de ani şi a născut fii şi fiice. ");
INSERT INTO ronbtf_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Şi Nahor a trăit douăzeci şi nouă de ani şi a născut pe Terah; ");
INSERT INTO ronbtf_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Şi Nahor a trăit, după ce a născut pe Terah, o sută nouăsprezece ani; şi a născut fii şi fiice. ");
INSERT INTO ronbtf_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Şi Terah a trăit şaptezeci de ani şi a născut pe Avram, Nahor şi Haran. ");
INSERT INTO ronbtf_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Şi acestea sunt generaţiile lui Terah: Terah a născut pe Avram, pe Nahor, şi pe Haran şi Haran a născut pe Lot. ");
INSERT INTO ronbtf_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Şi Haran a murit înaintea tatălui său, Terah, în ţara naşterii sale, în Urul caldeilor. ");
INSERT INTO ronbtf_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Şi Avram şi Nahor şi-au luat soţii: numele soţiei lui Avram era Sarai şi numele soţiei lui Nahor, Milca, fiica lui Haran, tatăl Milcăi şi tatăl Iscăi. ");
INSERT INTO ronbtf_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Dar Sarai era stearpă, ea nu avea copil. ");
INSERT INTO ronbtf_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Şi Terah a luat pe Avram, fiul său, şi pe Lot, fiul lui Haran, fiul fiului său, şi pe Sarai, nora lui, soţia fiului său, Avram, şi a ieşit împreună cu ei din Urul caldeilor, ca să meargă în ţara lui Canaan; şi au venit la Haran şi au locuit acolo. ");
INSERT INTO ronbtf_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Şi zilele lui Terah au fost două sute cinci ani; şi Terah a murit în Haran. ");
INSERT INTO ronbtf_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Şi DOMNUL îi spusese lui Avram: Ieşi din ţara ta şi din rudenia ta şi din casa tatălui tău, spre o ţară pe care ţi-o voi arăta; ");
INSERT INTO ronbtf_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Şi voi face din tine o mare naţiune şi te voi binecuvânta şi voi face numele tău mare şi vei fi o binecuvântare; ");
INSERT INTO ronbtf_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Şi voi binecuvânta pe cei ce te binecuvântează şi voi blestema pe cel ce te blestemă şi în tine toate familiile pământului vor fi binecuvântate. ");
INSERT INTO ronbtf_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Astfel Avram a ieşit, cum îi spusese DOMNUL, şi Lot a mers cu el; şi Avram era în vârstă de şaptezeci şi cinci de ani când a plecat din Haran. ");
INSERT INTO ronbtf_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Şi Avram a luat pe Sarai, soţia lui, şi pe Lot, fiul fratelui său şi toată averea pe care au adunat-o şi sufletele pe care le-au obţinut în Haran şi au ieşit să meargă în ţara lui Canaan şi au venit în ţara lui Canaan. ");
INSERT INTO ronbtf_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Şi Avram a trecut prin ţară până la locul din Sihem, la câmpia lui More. Şi canaanitul era atunci în ţară. ");
INSERT INTO ronbtf_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Şi DOMNUL i s-a arătat lui Avram şi a spus: Seminţei tale voi da această ţară; şi acolo a zidit un altar DOMNULUI, care i s-a arătat. ");
INSERT INTO ronbtf_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Şi el s-a mutat de acolo la un munte, la est de Betel, şi şi-a întins cortul, având Betel la vest şi Hai la est; şi acolo a zidit un altar DOMNULUI şi a chemat numele DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Şi Avram a călătorit, mergând tot spre sud. ");
INSERT INTO ronbtf_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Şi a fost o foamete în ţară şi Avram a coborât în Egipt să locuiască temporar acolo, pentru că foametea era apăsătoare în ţară. ");
INSERT INTO ronbtf_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Şi s-a întâmplat, când s-a apropiat să intre în Egipt, că el i-a spus Sarei, soţia lui: Acum iată, ştiu că eşti o femeie frumoasă la vedere, ");
INSERT INTO ronbtf_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","De aceea se va întâmpla, când egiptenii te vor vedea, că vor spune: Aceasta este soţia lui; şi mă vor ucide, dar pe tine te vor păstra în viaţă. ");
INSERT INTO ronbtf_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Spune, te rog, că eşti sora mea, ca să îmi fie bine din cauza ta şi sufletul meu să trăiască din cauza ta. ");
INSERT INTO ronbtf_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Şi s-a întâmplat, pe când Avram a ajuns în Egipt, că egiptenii au văzut că femeia era foarte frumoasă. ");
INSERT INTO ronbtf_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Prinţii lui Faraon de asemenea au văzut-o şi au lăudat-o înaintea lui Faraon; şi femeia a fost luată în casa lui Faraon. ");
INSERT INTO ronbtf_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Şi l-a tratat bine pe Avram din cauza ei şi avea oi şi boi şi catâri şi servitori şi servitoare şi măgăriţe şi cămile. ");
INSERT INTO ronbtf_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Şi DOMNUL a lovit cu plăgi pe Faraon şi casa lui, cu plăgi mari din cauza lui Sarai, soţia lui Avram. ");
INSERT INTO ronbtf_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Şi Faraon a chemat pe Avram şi a spus: Ce este aceasta ce mi-ai făcut? De ce nu mi-ai spus că era soţia ta? ");
INSERT INTO ronbtf_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","De ce ai spus: Ea este sora mea; astfel că aproape am luat-o de soţie? De aceea acum, iat-o pe soţia ta, ia-o şi pleacă. ");
INSERT INTO ronbtf_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Şi Faraon a poruncit oamenilor săi referitor la el şi l-au trimis de la ei, pe el şi pe soţia lui şi tot ce avea. ");
INSERT INTO ronbtf_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Şi Avram a urcat din Egipt, el şi soţia lui şi tot ce avea, şi Lot împreună cu el, în sudul Canaanului. ");
INSERT INTO ronbtf_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Şi Avram era foarte bogat în vite, în argint şi în aur. ");
INSERT INTO ronbtf_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Şi a mers în călătoriile lui din sud chiar până la Betel, până la locul unde fusese cortul său la început, între Betel şi Hai; ");
INSERT INTO ronbtf_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Până la locul altarului, pe care l-a făcut acolo la început; şi acolo Avram a chemat numele DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Şi de asemenea Lot, care a mers cu Avram, avea turme şi cirezi şi corturi. ");
INSERT INTO ronbtf_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Şi ţara nu era în stare să îi ţină ca să poată locui împreună, pentru că averea lor era mare, astfel că nu puteau locui împreună. ");
INSERT INTO ronbtf_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Şi a fost o ceartă între păzitorii vitelor lui Avram şi păzitorii vitelor lui Lot; şi canaanitul şi perizitul locuiau pe atunci în ţară. ");
INSERT INTO ronbtf_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Şi Avram i-a spus lui Lot: Să nu fie ceartă, te rog, între mine şi tine şi între păzitorii mei şi păzitorii tăi, pentru că suntem fraţi. ");
INSERT INTO ronbtf_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Nu este întreaga ţară înaintea ta? Desparte-te, te rog, de mine; dacă o vei lua la stânga, atunci eu voi merge la dreapta, sau dacă mergi la dreapta, atunci eu voi merge la stânga. ");
INSERT INTO ronbtf_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Şi Lot şi-a ridicat ochii şi a privit toată câmpia Iordanului, că aceasta era bine udată peste tot, înainte ca DOMNUL să fi distrus Sodoma şi Gomora, era ca grădina DOMNULUI, asemenea ţării Egiptului, cum vii la Ţoar. ");
INSERT INTO ronbtf_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Atunci Lot a ales pentru el toată câmpia Iordanului; şi Lot a călătorit spre est; şi ei s-au despărţit unul de celălalt. ");
INSERT INTO ronbtf_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Avram a locuit în ţara lui Canaan şi Lot a locuit în cetăţile din câmpie şi şi-a întins cortul spre Sodoma. ");
INSERT INTO ronbtf_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Dar oamenii din Sodoma erau peste măsură de stricaţi şi păcătoşi înaintea DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Şi DOMNUL i-a spus lui Avram, după ce s-a despărţit Lot de el: Ridică-ţi acum ochii şi priveşte din locul în care eşti spre nord şi spre sud şi spre est şi spre vest, ");
INSERT INTO ronbtf_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Pentru că tot pământul pe care îl vezi, ţie ţi-l voi da şi seminţei tale pentru totdeauna. ");
INSERT INTO ronbtf_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Şi voi face sămânţa ta ca ţărâna pământului, astfel încât, dacă un om poate număra ţărâna pământului, atunci va fi şi sămânţa ta numărată. ");
INSERT INTO ronbtf_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Ridică-te, umblă prin ţară în lungimea acesteia şi în lăţimea ei, pentru că ţie ţi-o voi da. ");
INSERT INTO ronbtf_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Atunci Avram şi-a mutat cortul şi a venit şi a locuit în câmpia lui Mamre, care este în Hebron; şi a zidit acolo un altar DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Şi s-a întâmplat în zilele lui Amrafel, împărat al Şinarului, Arioc, împărat al Elasarului, Chedorlaomer, împărat al Elamului şi Tidal, împărat al naţiunilor, ");
INSERT INTO ronbtf_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Că aceştia au făcut război cu Bera, împăratul Sodomei, şi cu Birşa, împăratul Gomorei, Şinab, împărat al Admei, şi Şemeber, împăratul Ţeboimului, şi cu împăratul din Bela, care este Ţoar. ");
INSERT INTO ronbtf_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Toţi aceştia s-au adunat în valea Sidim, care este marea sărată. ");
INSERT INTO ronbtf_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Doisprezece ani au servit lui Chedorlaomer, şi în al treisprezecelea an s-au răzvrătit. ");
INSERT INTO ronbtf_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Şi în al paisprezecelea an a venit Chedorlaomer şi împăraţii care erau cu el şi au lovit pe refaimi în Aşterot Carnaim, şi pe zuzimi în Ham, şi pe emimi în Şave Chiriataim, ");
INSERT INTO ronbtf_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Şi pe horiţi în muntele lor Seir, spre Elparan, care este lângă pustie. ");
INSERT INTO ronbtf_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Şi ei s-au întors şi au venit la Enmişpat, care este Cades, şi au lovit toată ţara amaleciţilor şi de asemenea pe amoriţi, care locuiesc în Haţeţon-Tamar. ");
INSERT INTO ronbtf_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Şi au ieşit împăratul Sodomei şi împăratul Gomorei şi împăratul Admei şi împăratul Ţeboimului şi împăratul din Bela (care este Ţoar) şi au intrat în luptă cu ei în valea Sidim; ");
INSERT INTO ronbtf_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Cu Chedorlaomer, împăratul Elamului, şi cu Tidal împăratul naţiunilor, şi Amrafel, împăratul Şinarului, şi Arioc, împăratul Elasarului; patru împăraţi cu cinci. ");
INSERT INTO ronbtf_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Şi valea Sidim era plină cu gropi de smoală; şi împăraţii Sodomei şi Gomorei au fugit şi au căzut acolo; şi cei ce au rămas au fugit la munte. ");
INSERT INTO ronbtf_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Şi au luat toate bunurile Sodomei şi Gomorei şi toate merindele lor şi au plecat. ");
INSERT INTO ronbtf_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Şi au luat pe Lot, fiul fratelui lui Avram, care locuia în Sodoma, şi bunurile lui şi au plecat. ");
INSERT INTO ronbtf_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Şi a venit unul care scăpase şi a spus lui Avram, evreul, căci locuia în câmpia lui Mamre amoritul, fratele lui Eşcol şi fratele lui Aner; şi aceştia erau aliaţi cu Avram. ");
INSERT INTO ronbtf_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Şi când a auzit Avram că fratele său a fost luat captiv, a înarmat pe servitorii lui instruiţi, născuţi în casa lui, trei sute şi optsprezece, şi i-a urmărit până la Dan. ");
INSERT INTO ronbtf_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Şi s-a împărţit împotriva lor, el şi servitorii lui, noaptea, şi i-a lovit şi i-a urmărit până la Hoba, care este la stânga Damascului. ");
INSERT INTO ronbtf_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Şi a adus înapoi toate bunurile şi de asemenea a adus înapoi pe fratele său, Lot, şi bunurile lui şi pe femei de asemenea şi pe oameni. ");
INSERT INTO ronbtf_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Şi împăratul Sodomei a ieşit să îl întâmpine după întoarcerea lui de la măcelul lui Chedorlaomer şi a împăraţilor care erau cu el, la valea Şave, care este valea împăratului. ");
INSERT INTO ronbtf_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Şi Melchisedec, împăratul Salemului, a adus pâine şi vin; şi el era preotul Dumnezeului cel preaînalt. ");
INSERT INTO ronbtf_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Şi l-a binecuvântat şi a spus: Binecuvântat fie Avram de Dumnezeul cel preaînalt, stăpânul cerului şi al pământului; ");
INSERT INTO ronbtf_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Şi binecuvântat fie Dumnezeul cel preaînalt care a dat pe duşmanii tăi în mâna ta. Şi Avram i-a dat zeciuieli din toate. ");
INSERT INTO ronbtf_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Şi împăratul Sodomei i-a spus lui Avram: Dă-mi oamenii şi ia bunurile pentru tine. ");
INSERT INTO ronbtf_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Şi Avram a spus împăratului Sodomei: Mi-am înălţat mâna spre DOMNUL, Dumnezeul cel preaînalt, stăpânul cerului şi pământului, ");
INSERT INTO ronbtf_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Că nu voi lua de la o aţă chiar până la o curea de sandală şi că nu voi lua nimic din ceea ce este al tău, ca nu cumva să spui: Eu l-am făcut pe Avram bogat; ");
INSERT INTO ronbtf_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","În afară de ceea ce tinerii au mâncat şi partea oamenilor care au fost cu mine, Aner, Eşcol şi Mamre, lasă-i să îşi ia partea lor. ");
INSERT INTO ronbtf_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","După aceste lucruri, cuvântul DOMNULUI a venit la Avram într-o viziune, spunând: Nu te teme Avrame, eu sunt scutul tău şi răsplata ta peste măsură de mare. ");
INSERT INTO ronbtf_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Şi Avram a spus: Doamne DUMNEZEULE, ce îmi vei da, văzând că mă duc fără copii, iar administratorul casei mele este acest Eliezer din Damasc? ");
INSERT INTO ronbtf_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Şi Avram a spus: Iată, nu mi-ai dat nicio sămânţă şi, iată, unul născut în casa mea este moştenitorul meu. ");
INSERT INTO ronbtf_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Şi, iată, cuvântul DOMNULUI a venit la el, spunând: Nu acesta va fi moştenitorul tău, ci cel ce va ieşi din propriile tale adâncuri va fi moştenitorul tău. ");
INSERT INTO ronbtf_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Şi l-a dus afară şi a spus: Priveşte acum spre cer şi numără stelele, dacă eşti în stare să le numeri; şi i-a spus: Astfel va fi sămânţa ta. ");
INSERT INTO ronbtf_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Iar el a crezut în DOMNUL, iar DOMNUL i-a socotit aceasta pentru dreptate. ");
INSERT INTO ronbtf_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Şi i-a spus: Eu sunt DOMNUL care te-a scos din cetatea Ur a caldeilor, ca să îţi dau această ţară să o moşteneşti. ");
INSERT INTO ronbtf_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Iar el a spus: Doamne DUMNEZEULE, din ce voi şti că o voi moşteni? ");
INSERT INTO ronbtf_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Iar el i-a spus: Ia-mi o viţea de trei ani şi o capră de trei ani şi un berbec de trei ani şi o turturea şi un pui de porumbel. ");
INSERT INTO ronbtf_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Şi a luat la el toate acestea şi le-a despicat în două şi a aşezat fiecare bucată una în faţa alteia, dar păsările nu le-a despicat. ");
INSERT INTO ronbtf_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Şi când păsările de pradă au coborât peste stârvuri, Avram le-a alungat. ");
INSERT INTO ronbtf_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Şi când soarele apunea, un somn adânc a căzut peste Avram şi, iată, o groază a unui mare întuneric a căzut peste el. ");
INSERT INTO ronbtf_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Iar DOMNUL i-a spus lui Avram: Să ştii cu adevărat că sămânţa ta va fi străină într-o ţară care nu este a lor şi vor servi pe aceia, iar ei îi vor chinui patru sute de ani; ");
INSERT INTO ronbtf_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Şi de asemenea pe acea naţiune, căreia ei îi vor servi, o voi judeca; şi după aceea vor ieşi din ea cu mare avere. ");
INSERT INTO ronbtf_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Iar tu vei merge la părinţii tăi în pace şi vei fi îngropat la o bătrâneţe frumoasă. ");
INSERT INTO ronbtf_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Dar în a patra generaţie vor veni din nou aici, pentru că nelegiuirea amoriţilor nu este încă deplină. ");
INSERT INTO ronbtf_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Şi s-a întâmplat, după ce soarele a apus şi era întuneric, că iată, un cuptor fumegând şi o lampă arzând au trecut printre acele bucăţi. ");
INSERT INTO ronbtf_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","În aceeaşi zi DOMNUL a făcut un legământ cu Avram, spunând: Seminţei tale i-am dat această ţară, de la râul Egiptului până la marele râu, râul Eufrat: ");
INSERT INTO ronbtf_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Cheniţii şi cheniziţii şi cadmoniţii, ");
INSERT INTO ronbtf_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Şi hitiţii şi periziţii şi refaimii, ");
INSERT INTO ronbtf_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Şi amoriţii şi canaaniţii şi ghirgaşiţii şi iebusiţii. ");
INSERT INTO ronbtf_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Acum Sarai, soţia lui Avram, nu îi năştea copii; şi ea avea o roabă, o egipteancă, al cărei nume era Hagar. ");
INSERT INTO ronbtf_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Şi Sarai i-a spus lui Avram: Iată acum, DOMNUL m-a oprit de la a naşte; te rog, intră la servitoarea mea, poate că voi obţine copii prin ea. Şi Avram a dat ascultare vocii lui Sarai. ");
INSERT INTO ronbtf_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Şi Sarai, soţia lui Avram, a luat pe Hagar, servitoarea ei, egipteanca, după ce Avram a locuit zece ani în ţara lui Canaan, şi a dat-o soţului ei, Avram, să fie soţia lui. ");
INSERT INTO ronbtf_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Şi a intrat la Hagar şi ea a rămas însărcinată; şi când a văzut că a rămas însărcinată, stăpâna ei a fost dispreţuită în ochii ei. ");
INSERT INTO ronbtf_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Şi Sarai i-a spus lui Avram: Răul făcut mie fie asupra ta; eu am dat pe servitoarea mea la sânul tău, şi când a văzut ea că a rămas însărcinată, am fost dispreţuită în ochii ei; DOMNUL să judece între mine şi tine. ");
INSERT INTO ronbtf_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Dar Avram i-a spus lui Sarai: Iată, servitoarea ta este în mâna ta, fă-i cum îţi place. Şi când Sarai s-a purtat aspru cu ea, ea a fugit de la faţa ei. ");
INSERT INTO ronbtf_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Şi îngerul DOMNULUI a găsit-o lângă o fântână de apă în pustie, lângă fântâna pe calea spre Şur. ");
INSERT INTO ronbtf_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Şi a spus: Hagar, servitoarea lui Sarai, de unde vii? Şi unde mergi? Iar ea a spus: Fug de la faţa stăpânei mele Sarai. ");
INSERT INTO ronbtf_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Şi îngerul DOMNULUI i-a spus: Întoarce-te la stăpâna ta şi supune-te sub mâinile ei. ");
INSERT INTO ronbtf_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Şi îngerul DOMNULUI i-a spus: Voi înmulţi sămânţa ta peste măsură, încât nu va putea fi numărată din cauza mulţimii ei. ");
INSERT INTO ronbtf_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Şi îngerul DOMNULUI i-a spus: Iată, eşti însărcinată şi vei naşte un fiu şi îi vei pune numele Ismael, pentru că DOMNUL a auzit necazul tău. ");
INSERT INTO ronbtf_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Şi el va fi un om sălbatic, mâna lui va fi împotriva fiecărui om şi mâna fiecărui om împotriva lui şi va locui în faţa tuturor fraţilor săi. ");
INSERT INTO ronbtf_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Şi ea a chemat numele DOMNULUI care i-a vorbit: Tu, Dumnezeu, mă vezi, pentru că ea a spus: Nu am privit de asemenea aici spatele celui care mă vede? ");
INSERT INTO ronbtf_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","De aceea fântâna a fost numită Beerlahairoi; iată, este între Cades şi Bered. ");
INSERT INTO ronbtf_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Şi Hagar a născut lui Avram un fiu şi Avram a pus fiului său, pe care Hagar l-a născut, numele Ismael. ");
INSERT INTO ronbtf_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Şi Avram era în vârstă de optzeci şi şase de ani când Hagar a născut pe Ismael lui Avram. ");
INSERT INTO ronbtf_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Şi când Avram era în vârstă de nouăzeci şi nouă de ani, DOMNUL s-a arătat lui Avram şi i-a spus: Eu sunt Dumnezeul cel Atotputernic, umblă înaintea mea şi fii desăvârşit. ");
INSERT INTO ronbtf_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Şi voi face legământul meu între mine şi tine şi te voi înmulţi peste măsură. ");
INSERT INTO ronbtf_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Şi Avram a căzut cu faţa sa la pământ şi Dumnezeu a vorbit cu el, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Cât despre mine, iată, legământul meu este cu tine şi tu vei fi tată al multor naţiuni. ");
INSERT INTO ronbtf_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Şi nu va mai fi chemat numele tău Avram, ci numele tău va fi Avraam, pentru că te-am făcut tată al multor naţiuni. ");
INSERT INTO ronbtf_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Şi te voi face peste măsură de roditor şi voi face naţiuni din tine şi împăraţi vor ieşi din tine. ");
INSERT INTO ronbtf_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Şi voi întemeia legământul meu între mine şi tine şi sămânţa ta după tine în generaţiile lor, ca legământ fără de sfârşit, pentru a-ţi fi Dumnezeu ţie şi seminţei tale după tine. ");
INSERT INTO ronbtf_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Şi îţi voi da ţie şi seminţei tale după tine ţara în care eşti străin, toată ţara lui Canaan, ca stăpânire fără de sfârşit; şi voi fi Dumnezeul lor. ");
INSERT INTO ronbtf_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Şi Dumnezeu i-a spus lui Avraam: Tu, aşadar, vei ţine legământul meu, tu şi sămânţa ta după tine, în generaţiile lor. ");
INSERT INTO ronbtf_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Acesta este legământul meu, pe care voi îl veţi ţine, între mine şi tine şi sămânţa ta după tine: Fiecare copil de parte bărbătească dintre voi va fi circumcis. ");
INSERT INTO ronbtf_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Şi veţi circumcide pielea prepuţului vostru şi aceasta va fi un semn al legământului dintre mine şi voi. ");
INSERT INTO ronbtf_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Şi cel ce este în vârstă de opt zile va fi circumcis între voi, fiecare copil de parte bărbătească în generaţiile voastre, cel născut în casă, sau cumpărat cu bani de la vreun străin, care nu este din sămânţa ta. ");
INSERT INTO ronbtf_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Cel născut în casa ta şi cel cumpărat cu banii tăi trebuie să fie circumcis, şi legământul meu va fi în carnea voastră ca legământ fără de sfârşit. ");
INSERT INTO ronbtf_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Şi copilul de parte bărbătească necircumcis, a cărui piele a prepuţului său nu este circumcisă, acel suflet va fi stârpit din poporul său; el a rupt legământul meu. ");
INSERT INTO ronbtf_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Şi Dumnezeu i-a spus lui Avraam: Cât despre Sarai, soţia ta, nu vei mai chema numele ei Sarai, ci Sara va fi numele ei. ");
INSERT INTO ronbtf_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Şi o voi binecuvânta şi de asemenea îţi voi da un fiu din ea; da, o voi binecuvânta şi ea va fi o mamă de naţiuni, împăraţi de popoare vor ieşi din ea. ");
INSERT INTO ronbtf_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Atunci Avraam a căzut cu faţa sa la pământ şi a râs şi a spus în inima lui: Îi va fi născut un copil celui ce este în vârstă de o sută de ani? Şi va naşte Sara, care are nouăzeci de ani? ");
INSERT INTO ronbtf_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Şi Avraam i-a spus lui Dumnezeu: O, de ar putea trăi Ismael înaintea ta! ");
INSERT INTO ronbtf_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Şi Dumnezeu a spus: Sara, soţia ta, într-adevăr, îţi va naşte un fiu şi îi vei pune numele Isaac; şi voi întemeia legământul meu cu el, ca legământ fără de sfârşit, şi cu sămânţa lui după el. ");
INSERT INTO ronbtf_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Şi cât despre Ismael, te-am auzit: Iată, l-am binecuvântat şi îl voi face roditor şi îl voi înmulţi peste măsură, doisprezece prinţi va naşte şi îl voi face o mare naţiune. ");
INSERT INTO ronbtf_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Dar legământul meu îl voi întemeia cu Isaac, pe care Sara ţi-l va naşte la timpul cuvenit, în anul viitor. ");
INSERT INTO ronbtf_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Şi a terminat de vorbit cu el, iar Dumnezeu s-a înălţat de la Avraam. ");
INSERT INTO ronbtf_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Şi Avraam a luat pe Ismael, fiul său, şi pe toţi cei născuţi în casa lui şi pe toţi cei cumpăraţi cu banii lui, fiecare parte bărbătească între oamenii casei lui Avraam, şi a circumcis pielea prepuţului lor chiar în aceeaşi zi, aşa cum Dumnezeu îi spusese. ");
INSERT INTO ronbtf_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Şi Avraam era în vârstă de nouăzeci şi nouă de ani când a fost circumcis în pielea prepuţului său. ");
INSERT INTO ronbtf_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Şi Ismael, fiul său, avea treisprezece ani când a fost circumcis în pielea prepuţului său. ");
INSERT INTO ronbtf_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Chiar în aceeaşi zi a fost Avraam circumcis şi Ismael, fiul său. ");
INSERT INTO ronbtf_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Şi toţi oamenii din casa lui, născuţi în casă şi cumpăraţi cu bani de la străin, au fost circumcişi împreună cu el. ");
INSERT INTO ronbtf_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Şi DOMNUL i s-a arătat în câmpiile lui Mamre şi Avraam şedea în uşa cortului, în arşiţa zilei. ");
INSERT INTO ronbtf_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Şi şi-a ridicat ochii şi a privit şi, iată, trei bărbaţi stăteau în picioare lângă el; şi când i-a văzut, a alergat de la uşa cortului să îi întâmpine şi s-a aplecat la pământ, ");
INSERT INTO ronbtf_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Şi a spus: Domnul meu, dacă am găsit acum favoare înaintea ochilor tăi, te rog, nu trece de la servitorul tău; ");
INSERT INTO ronbtf_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Lăsaţi să se aducă puţină apă, vă rog, şi spălaţi-vă picioarele şi odihniţi-vă sub pom; ");
INSERT INTO ronbtf_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Şi voi aduce o bucată de pâine şi mângâiaţi-vă inimile; după aceea veţi trece mai departe, fiindcă de aceea aţi venit voi la servitorul vostru. Iar ei au spus: Aşa să faci, precum ai spus. ");
INSERT INTO ronbtf_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Şi Avraam s-a grăbit în cort la Sara şi a spus: Pregăteşte repede trei măsuri din floarea făinii, frământ-o şi fă turte pe vatră. ");
INSERT INTO ronbtf_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Şi Avraam a alergat la cireadă şi a adus un viţel fraged şi bun şi l-a dat unui tânăr, iar acesta s-a grăbit să îl pregătească. ");
INSERT INTO ronbtf_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Şi a luat unt şi lapte şi viţelul pe care l-a pregătit şi l-a pus înaintea lor şi a stat în picioare lângă ei sub pom şi au mâncat. ");
INSERT INTO ronbtf_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Iar ei i-au spus: Unde este Sara, soţia ta? Iar el a spus: Iată, în cort. ");
INSERT INTO ronbtf_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Iar el a spus: Eu cu adevărat mă voi întoarce la tine, conform timpului vieţii; şi, iată, Sara, soţia ta, va avea un fiu. Şi Sara a auzit aceasta în uşa cortului, care era în spatele lui. ");
INSERT INTO ronbtf_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Acum Avraam şi Sara erau bătrâni şi mult înaintaţi în vârstă şi a încetat a mai fi cu Sara, conform rânduielii femeilor. ");
INSERT INTO ronbtf_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","De aceea Sara a râs în ea însăşi, spunând: După ce am îmbătrânit să mai am eu plăcere, domnul meu fiind şi el bătrân? ");
INSERT INTO ronbtf_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Şi DOMNUL i-a spus lui Avraam: Pentru ce a râs Sara, spunând: Cu adevărat să nasc eu, care sunt bătrână? ");
INSERT INTO ronbtf_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Este vreun lucru prea greu pentru DOMNUL? La timpul rânduit mă voi întoarce la tine, conform timpului vieţii; şi Sara va avea un fiu. ");
INSERT INTO ronbtf_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Atunci Sara a negat, spunând: Nu am râs: pentru că îi era teamă. Dar el a spus: Ba da, ai râs. ");
INSERT INTO ronbtf_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Şi oamenii s-au ridicat de acolo şi au privit spre Sodoma: Şi Avraam a mers cu ei să îi conducă pe cale. ");
INSERT INTO ronbtf_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Şi DOMNUL a spus: Voi ascunde eu de Avraam ceea ce fac, ");
INSERT INTO ronbtf_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Văzând că Avraam cu adevărat va deveni o naţiune mare şi puternică şi toate naţiunile pământului vor fi binecuvântate în el? ");
INSERT INTO ronbtf_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Pentru că îl cunosc că va porunci copiilor săi şi casei lui după el şi ei vor ţine calea DOMNULUI, pentru a face dreptate şi judecată, ca DOMNUL să aducă peste Avraam ceea ce a vorbit despre el. ");
INSERT INTO ronbtf_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Şi DOMNUL a spus: Pentru că strigătul Sodomei şi Gomorei este mare şi pentru că păcatul lor este foarte apăsător, ");
INSERT INTO ronbtf_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Voi coborî acum şi voi vedea dacă au făcut în întregime conform cu strigătul ei, ce a venit până la mine; şi dacă nu, voi şti. ");
INSERT INTO ronbtf_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Şi bărbaţii şi-au întors feţele de acolo şi au mers spre Sodoma, dar Avraam mai stătea încă în picioare înaintea DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Şi Avraam s-a apropiat şi a spus: Vei nimici de asemenea pe cel drept cu cel stricat? ");
INSERT INTO ronbtf_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","De ar fi cumva cincizeci de drepţi înăuntrul cetăţii: vei nimici de asemenea şi nu vei cruţa locul pentru cei cinzeci de drepţi care sunt în el? ");
INSERT INTO ronbtf_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Departe de tine fie să faci astfel, să ucizi pe cel drept cu cel stricat şi cel drept să fie ca cel stricat, departe de tine fie aceasta. Nu va face dreptate Judecătorul întregului pământ? ");
INSERT INTO ronbtf_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Iar DOMNUL a spus: Dacă găsesc în Sodoma cincizeci de drepţi înăuntrul cetăţii, atunci voi cruţa tot acel loc din cauza lor. ");
INSERT INTO ronbtf_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Şi Avraam a răspuns şi a zis: Iată acum, cutez să vorbesc Domnului, eu, care sunt doar ţărână şi cenuşă; ");
INSERT INTO ronbtf_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","De ar lipsi cumva cinci din cei cincizeci de drepţi: vei distruge toată cetatea pentru lipsa a cinci? Iar el a spus: Dacă găsesc acolo patruzeci şi cinci, nu o voi distruge. ");
INSERT INTO ronbtf_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Şi i-a vorbit din nou şi a spus: De ar fi cumva patruzeci găsiţi acolo. Iar el a spus: Nu voi face aceasta din cauza celor patruzeci. ");
INSERT INTO ronbtf_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Iar el i-a spus: Să nu se mânie Domnul şi voi vorbi: De ar fi cumva treizeci găsiţi acolo. Iar el a spus: Nu voi face aceasta, dacă găsesc treizeci acolo. ");
INSERT INTO ronbtf_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Iar el a spus: Iată acum, eu cutez să vorbesc Domnului: De ar fi cumva douăzeci găsiţi acolo. Iar el a spus: Nu o voi distruge din cauza a douăzeci. ");
INSERT INTO ronbtf_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Iar el a spus: Să nu se mânie Domnul şi voi mai vorbi doar de această dată: De ar fi cumva doar zece găsiţi acolo. Iar el a spus: Nu o voi distruge din cauza a zece. ");
INSERT INTO ronbtf_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Şi DOMNUL a plecat imediat după ce a încetat să vorbească îndeaproape cu Avraam şi Avraam s-a întors la locul său. ");
INSERT INTO ronbtf_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Şi pe seară, doi îngeri au venit la Sodoma; şi Lot şedea în poarta Sodomei; şi Lot, văzându-i, s-a ridicat să îi întâmpine şi s-a aplecat cu faţa sa la pământ; ");
INSERT INTO ronbtf_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Şi a spus: Iată acum, domnii mei, abateţi-vă, vă rog, în casa servitorului vostru şi rămâneţi toată noaptea şi spălaţi-vă picioarele şi vă veţi trezi devreme să mergeţi pe căile voastre. Iar ei au spus: Nu, ci vom sta în stradă toată noaptea. ");
INSERT INTO ronbtf_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Dar el a insistat pe lângă ei foarte mult şi s-au abătut la el şi au intrat în casa lui şi a făcut pentru ei un ospăţ şi a copt azimă şi au mâncat. ");
INSERT INTO ronbtf_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Dar înainte să se culce, bărbaţii cetăţii, bărbaţii din Sodoma, au încercuit casa, deopotrivă bătrâni şi tineri, tot poporul din fiecare parte a cetăţii; ");
INSERT INTO ronbtf_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Şi au chemat pe Lot şi i-au spus: Unde sunt bărbaţii care au venit la tine în această noapte? Scoate-i afară la noi să îi cunoaştem. ");
INSERT INTO ronbtf_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Şi Lot a ieşit la uşă la ei şi a închis uşa după el. ");
INSERT INTO ronbtf_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Şi a spus: Vă rog, fraţilor, nu faceţi o astfel de stricăciune. ");
INSERT INTO ronbtf_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Iată acum, am două fete care nu au cunoscut bărbat; lăsaţi-mă, vă rog, să le scot la voi şi faceţi-le precum este bine în ochii voştri, numai acestor bărbaţi nu le faceţi nimic, căci pentru aceasta au venit sub umbra acoperişului meu. ");
INSERT INTO ronbtf_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Dar ei au spus: Dă-te înapoi. Şi au spus din nou: Acesta a venit să locuiască temporar şi voieşte să fie judecător, acum ne vom purta mai rău cu tine decât cu ei. Şi împingeau cu putere asupra bărbatului, adică Lot, şi s-au apropiat să spargă uşa. ");
INSERT INTO ronbtf_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Dar bărbaţii şi-au întins mâna şi l-au tras pe Lot în casă la ei şi au închis uşa. ");
INSERT INTO ronbtf_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Şi au lovit pe bărbaţii care erau la uşa casei cu orbire, deopotrivă pe mici şi mari, astfel că se osteneau să găsească uşa. ");
INSERT INTO ronbtf_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Şi bărbaţii i-au spus lui Lot: Mai ai pe cineva aici? Ginere şi fiii tăi şi fiicele tale şi pe oricine ai în cetate, scoate-i din acest loc, ");
INSERT INTO ronbtf_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Pentru că vom distruge acest loc, deoarece strigătul lor a crescut mult înaintea feţei DOMNULUI şi DOMNUL ne-a trimis să îl distrugem. ");
INSERT INTO ronbtf_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Şi Lot a ieşit şi a vorbit ginerilor săi, care erau căsătoriţi cu fiicele lui, şi a spus: Ridicaţi-vă, ieşiţi din acest loc, pentru că DOMNUL va distruge această cetate. Dar el părea înaintea ginerilor săi ca unul care batjocorea. ");
INSERT INTO ronbtf_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Şi când s-a făcut dimineaţa, atunci îngerii au grăbit pe Lot, spunând: Ridică-te, ia pe soţia ta şi pe cele două fiice ale tale, care sunt aici, ca să nu fii mistuit în nelegiuirea cetăţii. ");
INSERT INTO ronbtf_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Şi în timp ce el întârzia, bărbaţii au apucat mâna lui şi mâna soţiei lui şi mâna celor două fiice ale lui, DOMNUL fiind milostiv cu el, şi l-au scos şi l-au aşezat în afara cetăţii. ");
INSERT INTO ronbtf_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Şi s-a întâmplat, după ce i-au scos afară, că a spus: Scapă-ţi viaţa; nu privi înapoia ta, nici nu sta în câmpie deschisă, scapă la munte ca nu cumva să fii mistuit. ");
INSERT INTO ronbtf_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Şi Lot le-a spus: Nu! Te rog, Domnul meu; ");
INSERT INTO ronbtf_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Iată acum, servitorul tău a găsit har înaintea ochilor tăi şi ai preamărit mila ta, pe care mi-ai arătat-o salvându-mi viaţa; şi nu pot să scap la munte, ca nu cumva ceva rău să mă prindă şi să mor; ");
INSERT INTO ronbtf_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Iată acum, această cetate este aproape, să scap la ea şi aceasta este una mică: Te rog, lasă-mă să scap într-acolo, (nu este aceasta una mică?) şi sufletul meu va trăi. ");
INSERT INTO ronbtf_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Iar el i-a spus: Vezi, te-am acceptat şi în acest lucru, că nu voi dărâma această cetate, pentru care ai vorbit. ");
INSERT INTO ronbtf_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Grăbeşte-te, scapă într-acolo, pentru că nu pot face nimic până ce vei fi ajuns acolo. De aceea s-a pus numele cetăţii, Ţoar. ");
INSERT INTO ronbtf_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Soarele se ridica deasupra pământului când Lot a intrat în Ţoar. ");
INSERT INTO ronbtf_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Atunci DOMNUL a plouat peste Sodoma şi peste Gomora pucioasă şi foc de la DOMNUL din cer; ");
INSERT INTO ronbtf_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Şi a dărâmat acele cetăţi şi toată câmpia şi pe toţi locuitorii cetăţilor şi ceea ce creştea pe pământ. ");
INSERT INTO ronbtf_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Dar soţia lui a privit înapoi din spatele lui şi a devenit un stâlp de sare. ");
INSERT INTO ronbtf_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Şi Avraam s-a sculat devreme dimineaţa şi a mers spre locul unde a stat în picioare înaintea DOMNULUI; ");
INSERT INTO ronbtf_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Şi a privit spre Sodoma şi Gomora şi spre tot ţinutul câmpiei; şi a privit şi, iată, fumul ţinutului se ridica precum fumul unui cuptor. ");
INSERT INTO ronbtf_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Şi s-a întâmplat, când Dumnezeu a distrus cetăţile câmpiei, că Dumnezeu şi-a amintit de Avraam şi a trimis pe Lot afară din mijlocul dărâmării, când el a dărâmat cetăţile în care Lot a locuit. ");
INSERT INTO ronbtf_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Şi Lot s-a urcat din Ţoar şi a locuit în munte şi cele două fiice ale lui cu el, pentru că s-a temut să locuiască în Ţoar şi a locuit într-o peşteră, el şi cele două fiice ale lui. ");
INSERT INTO ronbtf_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Şi cea întâi născută i-a spus celei mai tinere: Tatăl nostru este bătrân şi nu este un bărbat pe pământ să intre la noi, după obiceiul întregului pământ; ");
INSERT INTO ronbtf_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Vino, să facem pe tatăl nostru să bea vin şi ne vom culca cu el, ca să păstrăm o sămânţă a tatălui nostru. ");
INSERT INTO ronbtf_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Şi ele au făcut pe tatăl lor să bea vin în acea noapte şi cea întâi născută a intrat şi s-a culcat cu tatăl ei; şi el nu şi-a dat seama când s-a culcat ea, nici când s-a ridicat. ");
INSERT INTO ronbtf_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Şi s-a întâmplat a doua zi, că cea întâi născută i-a spus celei mai tinere: Iată, m-am culcat noaptea trecută cu tatăl meu; hai să îl facem să bea vin şi în această noapte şi intră şi culcă-te cu el, ca să păstrăm o sămânţă a tatălui nostru. ");
INSERT INTO ronbtf_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Şi ele au făcut pe tatăl lor să bea vin şi în acea noapte; şi cea tânără s-a ridicat şi s-a culcat cu el; şi el nu şi-a dat seama când ea s-a culcat, nici când s-a ridicat. ");
INSERT INTO ronbtf_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Astfel au fost amândouă fiicele lui Lot însărcinate prin tatăl lor. ");
INSERT INTO ronbtf_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Şi cea întâi născută a născut un fiu şi i-a pus numele Moab; el este tatăl moabiţilor până în această zi. ");
INSERT INTO ronbtf_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Şi cea mai tânără de asemenea a născut un fiu şi i-a pus numele Ben-ami; el este tatăl copiilor lui Amon până în această zi. ");
INSERT INTO ronbtf_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Şi Avraam a călătorit de acolo spre ţinutul de sud şi s-a aşezat între Cades şi Şur şi a locuit temporar în Gherar. ");
INSERT INTO ronbtf_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Şi Avraam a spus despre Sara, soţia lui: Ea este sora mea; şi Abimelec, împăratul Gherarului, a trimis şi a luat pe Sara. ");
INSERT INTO ronbtf_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Dar Dumnezeu a venit la Abimelec într-un vis, noaptea, şi i-a spus: Iată, eşti un om mort, din cauza femeii pe care ai luat-o, pentru că ea este soţia unui bărbat. ");
INSERT INTO ronbtf_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Dar Abimelec nu se apropiase de ea şi a spus: Doamne, vei ucide de asemenea o naţiune dreaptă? ");
INSERT INTO ronbtf_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Nu mi-a spus el: Ea este sora mea? Şi ea, chiar ea însăşi a spus: El este fratele meu; în integritatea inimii mele şi în nevinovăţia mâinilor mele am făcut aceasta. ");
INSERT INTO ronbtf_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Şi Dumnezeu i-a spus într-un vis: Da, ştiu că ai făcut aceasta în integritatea inimii tale, pentru că de asemenea te-am oprit de la păcătuire împotriva mea; de aceea nu te-am lăsat să o atingi. ");
INSERT INTO ronbtf_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","De aceea acum dă înapoi bărbatului pe soţia lui; căci este profet şi se va ruga pentru tine şi vei trăi; dar dacă nu o dai înapoi, să ştii că vei muri negreşit, tu şi toţi ai tăi. ");
INSERT INTO ronbtf_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Astfel Abimelec s-a sculat devreme dimineaţa şi a chemat pe toţi servitorii săi şi a spus toate aceste lucruri în urechile lor şi oamenii s-au temut foarte tare. ");
INSERT INTO ronbtf_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Apoi Abimelec l-a chemat pe Avraam şi i-a spus: Ce ne-ai făcut? Şi cu ce te-am ofensat că ai adus asupra mea şi a împărăţiei mele un mare păcat? Tu mi-ai făcut lucruri care nu trebuiau făcute. ");
INSERT INTO ronbtf_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Şi Abimelec i-a spus lui Avraam: Ce ai văzut, de ai făcut acest lucru? ");
INSERT INTO ronbtf_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Şi Avraam a spus: Pentru că am gândit: Cu adevărat teama de Dumnezeu nu este în acest loc; şi mă vor ucide din cauza soţiei mele. ");
INSERT INTO ronbtf_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Şi totuşi într-adevăr ea este sora mea; ea este fiica tatălui meu, dar nu este fiica mamei mele; şi ea a devenit soţia mea. ");
INSERT INTO ronbtf_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Şi s-a întâmplat, pe când Dumnezeu m-a făcut să rătăcesc din casa tatălui meu, că i-am spus: Aceasta să fie bunăvoinţa ta pe care să mi-o arăţi; în fiecare loc unde vom ajunge, spune despre mine: El este fratele meu. ");
INSERT INTO ronbtf_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Şi Abimelec a luat oi şi boi şi servitori şi servitoare şi i-a dat lui Avraam; şi i-a dat înapoi pe Sara, soţia sa. ");
INSERT INTO ronbtf_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Şi Abimelec a spus: Iată, ţara mea este înaintea ta, locuieşte unde îţi place. ");
INSERT INTO ronbtf_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Şi Sarei i-a spus: Iată, am dat fratelui tău o mie de arginţi; iată, el îţi este o acoperitoare a ochilor, pentru toţi cei ce sunt cu tine şi cu toţi ceilalţi; astfel a fost ea mustrată. ");
INSERT INTO ronbtf_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Astfel Avraam s-a rugat lui Dumnezeu, şi Dumnezeu a vindecat pe Abimelec şi pe soţia lui şi pe servitoarele lui; şi ele au născut copii. ");
INSERT INTO ronbtf_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Pentru că DOMNUL a închis de tot toate pântecele femeilor din casa lui Abimelec, din cauza Sarei, soţia lui Avraam. ");
INSERT INTO ronbtf_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Şi DOMNUL a vizitat-o pe Sara aşa cum a spus; şi DOMNUL a făcut Sarei aşa cum el a vorbit. ");
INSERT INTO ronbtf_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Căci Sara a rămas însărcinată şi a născut un fiu lui Avraam la bătrâneţile lui, la timpul cuvenit despre care Dumnezeu îi vorbise. ");
INSERT INTO ronbtf_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Şi Avraam i-a pus fiului său, care i-a fost născut, pe care Sara i l-a născut, numele Isaac. ");
INSERT INTO ronbtf_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Şi Avraam a circumcis pe fiul său Isaac când pruncul avea opt zile, aşa cum Dumnezeu i-a poruncit. ");
INSERT INTO ronbtf_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Şi Avraam era în vârstă de o sută de ani când i s-a născut fiul său Isaac. ");
INSERT INTO ronbtf_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Şi Sara a spus: Dumnezeu m-a făcut să râd, aşa că toţi cei ce vor auzi vor râde împreună cu mine. ");
INSERT INTO ronbtf_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Şi ea a spus: Cine ar fi spus lui Avraam, că Sara ar alăpta copii? Pentru că i-am născut un fiu la bătrâneţile sale. ");
INSERT INTO ronbtf_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Şi copilul a crescut şi a fost înţărcat şi Avraam a făcut un mare ospăţ în ziua în care Isaac a fost înţărcat. ");
INSERT INTO ronbtf_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Şi Sara a văzut pe fiul lui Hagar, egipteanca, pe care aceasta îl născuse lui Avraam, batjocorind. ");
INSERT INTO ronbtf_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","De aceea i-a spus lui Avraam: Alungă pe această roabă şi pe fiul ei, pentru că fiul acestei roabe nu va fi moştenitor împreună cu fiul meu, cu Isaac. ");
INSERT INTO ronbtf_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Şi lucrul a fost foarte dureros înaintea ochilor lui Avraam, din cauza fiului său. ");
INSERT INTO ronbtf_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Şi Dumnezeu i-a spus lui Avraam: Să nu fie acest lucru dureros înaintea ochilor tăi din cauza băiatului şi din cauza roabei tale; în tot ce Sara ţi-a spus, dă ascultare vocii ei, pentru că în Isaac se va chema sămânţa ta. ");
INSERT INTO ronbtf_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Şi de asemenea din fiul roabei voi face o naţiune, pentru că el este sămânţa ta. ");
INSERT INTO ronbtf_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Şi Avraam s-a sculat devreme dimineaţa şi a luat pâine şi un burduf de apă şi copilul şi l-a dat lui Hagar, punându-l pe umărul ei; şi a trimis-o şi ea a plecat şi a rătăcit în pustia Beer-Şeba. ");
INSERT INTO ronbtf_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Şi apa s-a terminat din burduf şi ea a lepădat copilul sub unul dintre tufişuri. ");
INSERT INTO ronbtf_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Şi a mers şi s-a aşezat jos înaintea lui la depărtare de el, cam cât ar trage un arcaş, pentru că spunea: Să nu văd moartea copilului. Şi s-a aşezat înaintea lui şi şi-a înălţat vocea şi a plâns. ");
INSERT INTO ronbtf_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Şi Dumnezeu a auzit vocea băiatului; şi îngerul lui Dumnezeu a chemat pe Hagar din cer şi i-a spus: Ce îţi este, Hagar? Nu te teme, pentru că Dumnezeu a auzit vocea băiatului acolo unde este el. ");
INSERT INTO ronbtf_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Scoală-te, ridică băiatul şi ţine-l în mână, pentru că îl voi face o mare naţiune. ");
INSERT INTO ronbtf_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Şi Dumnezeu i-a deschis ochii şi ea a văzut o fântână de apă; şi s-a dus şi a umplut burduful cu apă şi a dat băiatului să bea. ");
INSERT INTO ronbtf_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Şi Dumnezeu a fost cu băiatul; şi a crescut şi a locuit în pustie şi a devenit arcaş. ");
INSERT INTO ronbtf_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Şi a locuit în pustia Paran şi mama lui i-a luat o soţie din ţara Egiptului. ");
INSERT INTO ronbtf_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Şi s-a întâmplat în acel timp, că Abimelec şi Picol, căpetenia oştirii sale, i-au vorbit lui Avraam, spunând: Dumnezeu este cu tine în tot ceea ce faci; ");
INSERT INTO ronbtf_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","De aceea acum jură-mi aici pe Dumnezeu că nu mă vei înșela nici pe mine, nici pe fiul meu, nici pe fiul fiului meu, ci conform bunătăţii pe care ţi-am făcut-o, îmi vei face şi tu mie şi ţării în care ai locuit temporar. ");
INSERT INTO ronbtf_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Şi Avraam a spus: Jur. ");
INSERT INTO ronbtf_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Şi Avraam a mustrat pe Abimelec din cauza unei fântâni de apă, pe care servitorii lui Abimelec au luat-o cu violenţă. ");
INSERT INTO ronbtf_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Şi Abimelec a spus: Nu am ştiut cine a făcut acest lucru, nici tu nu mi-ai spus, nici nu am auzit de aceasta, decât astăzi. ");
INSERT INTO ronbtf_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Şi Avraam a luat oi şi boi şi le-a dat lui Abimelec; şi amândoi au făcut un legământ. ");
INSERT INTO ronbtf_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Şi Avraam a pus şapte mieluşele din turmă la o parte. ");
INSERT INTO ronbtf_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Şi Abimelec i-a spus lui Avraam: Ce înseamnă aceste şapte mieluşele pe care le-ai pus la o parte? ");
INSERT INTO ronbtf_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Iar el a spus: Aceste şapte mieluşele le vei lua din mâna mea, ca ele să fie o mărturie pentru mine, că am săpat această fântână. ");
INSERT INTO ronbtf_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Pentru aceasta el a numit acel loc Beer-Şeba, pentru că acolo au jurat amândoi. ");
INSERT INTO ronbtf_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Astfel au făcut un legământ la Beer-Şeba, apoi Abimelec s-a ridicat şi Picol, căpetenia oştirii sale, şi s-au întors în ţara filistenilor. ");
INSERT INTO ronbtf_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Şi Avraam a sădit un crâng în Beer-Şeba şi a chemat acolo numele DOMNULUI, Dumnezeul cel veşnic. ");
INSERT INTO ronbtf_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Şi Avraam a locuit temporar în ţara filistenilor multe zile. ");
INSERT INTO ronbtf_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Şi s-a întâmplat după aceste lucruri, că Dumnezeu l-a încercat pe Avraam şi i-a spus: Avraam; iar el a spus: Iată-mă. ");
INSERT INTO ronbtf_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Iar el a spus: Ia acum pe fiul tău, pe singurul tău fiu, Isaac, pe care îl iubeşti, şi du-te în ţinutul Moria; şi adu-l acolo ca o ofrandă arsă pe unul din munţii pe care ţi-l voi spune. ");
INSERT INTO ronbtf_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Şi Avraam s-a sculat devreme dimineaţa şi a înşeuat măgarul său şi a luat doi dintre tinerii săi cu el şi pe Isaac, fiul său, şi a despicat lemnele pentru ofranda arsă şi s-a ridicat şi a mers la locul despre care Dumnezeu îi spusese. ");
INSERT INTO ronbtf_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Apoi în a treia zi Avraam şi-a ridicat ochii şi a văzut locul de departe. ");
INSERT INTO ronbtf_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Şi Avraam a spus tinerilor săi: Staţi aici cu măgarul; şi eu şi băiatul vom merge acolo şi ne vom închina şi ne vom întoarce la voi. ");
INSERT INTO ronbtf_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Şi Avraam a luat lemnele ofrandei arse şi l-a pus pe Isaac, fiul său; şi a luat focul în mâna sa şi un cuţit; şi au mers amândoi împreună. ");
INSERT INTO ronbtf_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Şi Isaac i-a vorbit tatălui său, Avraam, şi a zis: Tată; iar el a spus: Iată-mă, fiul meu. Iar el a spus: Iată, focul şi lemnele, dar unde este mielul pentru ofranda arsă? ");
INSERT INTO ronbtf_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Şi Avraam a spus: Fiul meu, Dumnezeu însuşi se va îngriji de mielul pentru ofranda arsă; astfel au mers amândoi împreună. ");
INSERT INTO ronbtf_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Şi au ajuns la locul despre care Dumnezeu îi spusese; şi Avraam a zidit un altar acolo şi a pus lemnele în ordine şi a legat pe Isaac, fiul său, şi l-a pus pe altar deasupra lemnelor. ");
INSERT INTO ronbtf_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Şi Avraam şi-a întins mâna şi a luat cuţitul să înjunghie pe fiul său. ");
INSERT INTO ronbtf_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Şi îngerul DOMNULUI a strigat către el din cer şi a spus: Avraame, Avraame; iar el a spus: Iată-mă. ");
INSERT INTO ronbtf_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Şi a spus: Nu pune mâna pe băiat, nici nu îi face nimic, pentru că acum ştiu că te temi de Dumnezeu, văzând că nu ai cruţat pe fiul tău, singurul tău fiu, pentru mine. ");
INSERT INTO ronbtf_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Şi Avraam şi-a ridicat ochii şi a privit şi, iată, în spatele lui un berbec prins cu coarnele într-un desiş; şi Avraam a mers şi a luat berbecul şi l-a adus ca o ofrandă arsă în locul fiului său. ");
INSERT INTO ronbtf_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Şi Avraam a pus numele acelui loc, Iehova-Iire, aşa cum este spus până în ziua de azi: În muntele DOMNULUI îngrijirea se va vedea. ");
INSERT INTO ronbtf_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Şi îngerul DOMNULUI a strigat din cer către Avraam a doua oară, ");
INSERT INTO ronbtf_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Şi a spus: Pe mine însumi am jurat, spune DOMNUL, pentru că ai făcut acest lucru şi nu ai cruţat pe fiul tău, pe singurul tău fiu; ");
INSERT INTO ronbtf_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","De aceea binecuvântând te voi binecuvânta şi înmulţind voi înmulţi sămânţa ta ca stelele cerului şi ca nisipul de pe ţărmul mării; şi sămânţa ta va stăpâni poarta duşmanilor săi. ");
INSERT INTO ronbtf_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Şi în sămânţa ta toate naţiunile pământului vor fi binecuvântate, pentru că ai ascultat de vocea mea. ");
INSERT INTO ronbtf_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Aşa că Avraam s-a întors la tinerii săi şi s-au sculat şi au mers împreună la Beer-Şeba; şi Avraam a locuit la Beer-Şeba. ");
INSERT INTO ronbtf_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Şi s-a întâmplat, după aceste lucruri, că i s-a spus lui Avraam, zicând: Iată, Milca a născut şi ea copii fratelui tău, Nahor; ");
INSERT INTO ronbtf_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Uţ, primul său născut, şi Buz, fratele său, şi Chemuel, tatăl lui Aram, ");
INSERT INTO ronbtf_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Şi Chesed şi Hazo şi Pildaş şi Iidlaf şi Betuel. ");
INSERT INTO ronbtf_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Şi Betuel a născut pe Rebeca; pe aceştia opt Milca i-a născut lui Nahor, fratele lui Avraam. ");
INSERT INTO ronbtf_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Şi concubina sa, al cărei nume era Reuma, a născut de asemenea pe Tebah şi pe Gaham şi pe Tahaş şi pe Maaca. ");
INSERT INTO ronbtf_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Şi Sara era în vârstă de o sută douăzeci şi şapte de ani, aceştia au fost anii vieţii lui Sara. ");
INSERT INTO ronbtf_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Şi Sara a murit în Chiriatarba, adică Hebron, în ţara lui Canaan; şi Avraam a venit să jelească pe Sara şi să o plângă. ");
INSERT INTO ronbtf_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Şi Avraam a stat în picioare înaintea moartei sale şi a vorbit fiilor lui Het, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Eu sunt străin şi locuitor temporar cu voi, daţi-mi în stăpânire un loc de îngropare între voi, ca să înmormântez moarta mea dinaintea feţei mele. ");
INSERT INTO ronbtf_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Şi copiii lui Het au răspuns lui Avraam, spunându-i: ");
INSERT INTO ronbtf_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Ascultă-ne, domnul meu: tu eşti un prinţ puternic printre noi; îngroapă-ţi moarta în cel mai ales dintre mormintele noastre; niciunul din noi nu va opri de la tine mormântul său, să îţi îngropi moarta. ");
INSERT INTO ronbtf_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Şi Avraam s-a ridicat şi s-a aplecat până la pământ înaintea poporului ţării, înaintea copiilor lui Het. ");
INSERT INTO ronbtf_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Şi a vorbit îndeaproape cu ei, spunând: Dacă aceasta este dorinţa voastră, să înmormântez moarta mea dinaintea feţei mele, ascultaţi-mă şi rugaţi pentru mine pe Efron, fiul lui Ţohar, ");
INSERT INTO ronbtf_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Ca să îmi dea peştera din Macpela, pe care o are, care este la capătul câmpului său; pentru atâţia bani cât merită aceasta, să mi-o dea în stăpânire ca loc de îngropare printre voi. ");
INSERT INTO ronbtf_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Şi Efron locuia printre copiii lui Het; şi Efron hititul a răspuns lui Avraam în auzul copiilor lui Het, al tuturor celor ce intrau la poarta cetăţii sale, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Nu, domnul meu, ascultă-mă, câmpul ţi-l dau şi peştera care este în el, pe aceasta ţi-o dau; înaintea ochilor fiilor poporului meu ţi-o dau, înmormântează-ţi moarta. ");
INSERT INTO ronbtf_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Şi Avraam s-a aplecat până la pământ înaintea poporului ţării. ");
INSERT INTO ronbtf_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Şi i-a vorbit lui Efron în auzul poporului ţării, spunând: Dar dacă mi-l vei da, te rog ascultă-mă, îţi voi da bani pentru câmp; ia-i de la mine şi îmi voi înmormânta moarta acolo. ");
INSERT INTO ronbtf_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Şi Efron a răspuns lui Avraam, spunându-i: ");
INSERT INTO ronbtf_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Domnul meu, dă-mi ascultare, pământul merită patru sute de şekeli de argint; ce este aceasta între mine şi tine? Înmormântează-ţi aşadar moarta. ");
INSERT INTO ronbtf_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Şi Avraam a dat ascultare lui Efron; şi Avraam i-a cântărit lui Efron argintul, pe care l-a spus în auzul fiilor lui Het, patru sute de şekeli de argint, în moneda comerciantului. ");
INSERT INTO ronbtf_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Şi câmpul lui Efron, care era în Macpela, care era în faţă cu Mamre, câmpul şi peştera care era în el şi toţi copacii care erau în câmp, care erau pe toate marginile de jur împrejur, au fost făcute sigure, ");
INSERT INTO ronbtf_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Lui Avraam ca stăpânire înaintea ochilor copiilor lui Het, înaintea tuturor celor ce intrau pe poarta cetăţii sale. ");
INSERT INTO ronbtf_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Şi după aceasta, Avraam a îngropat pe Sara, soţia lui, în peştera din câmpia din Macpela, în faţă cu Mamre, acesta este Hebron, în ţara lui Canaan. ");
INSERT INTO ronbtf_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Şi câmpul şi peştera care este în el, au fost făcute sigure lui Avraam ca stăpânire a unui loc de îngropare, de fiii lui Het. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Şi Avraam era bătrân şi mult înaintat în vârstă şi DOMNUL a binecuvântat pe Avraam în toate lucrurile. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Şi Avraam a spus celui mai bătrân servitor al casei sale, care conducea peste tot ceea ce el avea: Pune-ţi, te rog, mâna sub coapsa mea, ");
INSERT INTO ronbtf_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Şi te voi face să juri pe DOMNUL, Dumnezeul cerului şi Dumnezeul pământului, că nu vei lua fiului meu o soţie dintre fiicele canaaniţilor, printre care locuiesc eu; ");
INSERT INTO ronbtf_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ci te vei duce în ţara mea şi la rudele mele şi vei lua o soţie fiului meu, Isaac. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Şi servitorul i-a spus: Poate că femeia nu va voi să mă urmeze în această ţară; ar trebui să duc pe fiul tău înapoi în ţara de unde ai venit? ");
INSERT INTO ronbtf_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Şi Avraam i-a spus: Ia seama, să nu duci pe fiul meu înapoi acolo. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","DOMNUL Dumnezeul cerului, care m-a luat din casa tatălui meu şi din ţara rudelor mele şi care mi-a vorbit şi care mi-a jurat, spunând: Seminţei tale voi da această ţară; el va trimite pe îngerul său înaintea ta şi vei lua de acolo o soţie fiului meu. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Şi dacă femeia nu va voi să te urmeze, atunci vei fi eliberat de acest jurământ al meu, numai nu duce pe fiul meu înapoi acolo. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Şi servitorul şi-a pus mâna sub coapsa lui Avraam, stăpânul său, şi i-a jurat referitor la acel lucru. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Şi servitorul a luat zece cămile dintre cămilele stăpânului său şi a plecat, pentru că toate bunurile stăpânului său erau în mâna sa; şi el s-a ridicat şi a mers în Mesopotamia, în cetatea lui Nahor. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Şi a pus cămilele sale să îngenuncheze în afara cetăţii, lângă o fântână de apă, la timpul înserării, la timpul când femeile ies să scoată apă. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Şi a spus: DOAMNE, Dumnezeul stăpânului meu Avraam, te rog, dă-mi reuşită în această zi şi arată bunătate stăpânului meu, Avraam. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Iată, stau aici lângă fântâna de apă; şi fiicele bărbaţilor cetăţii ies să scoată apă, ");
INSERT INTO ronbtf_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Şi să se întâmple că tânăra căreia îi voi spune: Pleacă-ţi ulciorul, te rog, ca să beau; iar ea va spune: Bea şi voi da şi cămilelor tale să bea; aceea să fie cea pe care ai rânduit-o pentru servitorul tău Isaac; şi din aceasta voi cunoaşte că ai arătat bunătate stăpânului meu. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Şi s-a întâmplat, înainte de a termina el de vorbit, că, iată, Rebeca, cea născută lui Betuel, fiul Milcăi, soţia lui Nahor, fratele lui Avraam, a ieşit cu ulciorul pe umărul ei. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Şi tânăra era foarte plăcută la vedere, o fecioară, şi niciun bărbat nu o cunoscuse; şi ea a coborât la fântână şi şi-a umplut ulciorul şi a urcat. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Şi servitorul a alergat să o întâlnească şi a spus: Lasă-mă, te rog, să beau puţină apă din ulciorul tău. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Iar ea a spus: Bea, domnul meu; şi ea s-a grăbit şi şi-a lăsat jos ulciorul peste mâna ei şi i-a dat să bea. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Şi după ce a terminat să îi dea de băut, a spus: Voi scoate apă şi pentru cămilele tale, până o să termine de băut. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Şi s-a grăbit şi şi-a golit ulciorul în adăpătoare şi a alergat din nou la fântână să scoată apă şi a scos pentru toate cămilele lui. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Şi bărbatul, mirându-se de ea, tăcea, voind să cunoască dacă DOMNUL făcuse călătoria lui prosperă sau nu. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Şi s-a întâmplat, pe când cămilele terminaseră de băut, că bărbatul a luat un cercel de aur de o jumătate de şekel în greutate şi două brăţări pentru mâinile ei, în greutate de zece şekeli de aur; ");
INSERT INTO ronbtf_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Şi a spus: A cui fiică eşti tu? Spune-mi, te rog, este loc în casa tatălui tău pentru noi să găzduim? ");
INSERT INTO ronbtf_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Iar ea i-a spus: Eu sunt fiica lui Betuel, fiul Milcăi, pe care ea l-a născut lui Nahor. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Şi i-a mai spus: Avem deopotrivă paie şi nutreţ îndeajuns şi loc să găzduiţi. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Şi bărbatul şi-a plecat capul şi s-a închinat DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Şi a spus: Binecuvântat fie DOMNUL, Dumnezeul stăpânului meu Avraam, care nu a lăsat pe stăpânul meu lipsit de mila sa şi de adevărul său; eu, fiind pe cale, DOMNUL m-a condus la casa fraţilor stăpânului meu. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Şi fata a alergat şi a spus aceste lucruri tuturor celor din casa mamei ei. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Şi Rebeca avea un frate şi numele lui era Laban; şi Laban a alergat afară la bărbat, la fântână. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Şi s-a întâmplat, când a văzut cercelul şi brăţările pe mâinile surorii sale şi când a auzit cuvintele Rebecăi, sora sa, spunând: Astfel mi-a vorbit acel bărbat; că el a venit la acel bărbat; şi, iată, el stătea în picioare lângă cămile, la fântână. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Şi a spus: Intră, tu, binecuvântatul DOMNULUI; pentru ce stai afară? Căci am pregătit casa şi loc pentru cămile. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Şi bărbatul a intrat în casă şi a deşeuat cămilele sale şi a dat paie şi nutreţ pentru cămile şi a luat apă să îşi spele picioarele şi picioarele bărbaţilor care erau cu el. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Şi s-a pus mâncare înaintea lui ca să mănânce; dar a spus: Nu voi mânca, până ce nu voi fi spus vorba mea. Iar Laban a spus: Vorbeşte. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Iar el a spus: Eu sunt servitorul lui Avraam. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Şi DOMNUL a binecuvântat pe stăpânul meu foarte mult; şi a devenit mare şi i-a dat turme şi cirezi şi argint şi aur şi servitori şi servitoare şi cămile şi măgari. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Şi Sara, soţia stăpânului meu, a născut un fiu stăpânului meu când era bătrână; şi el i-a dat tot ce avea. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Şi stăpânul meu m-a făcut să jur, spunând: Nu lua fiului meu o soţie dintre fiicele canaaniţilor, în a căror ţară locuiesc eu; ");
INSERT INTO ronbtf_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Ci te vei duce la casa tatălui meu şi la rudele mele şi vei lua fiului meu o soţie. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Şi am spus stăpânului meu: Poate că femeia nu mă va urma. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Iar el mi-a spus: DOMNUL, înaintea căruia umblu, va trimite îngerul său cu tine şi va face să prospere calea ta; şi vei lua pentru fiul meu o soţie dintre rudele mele şi din casa tatălui meu; ");
INSERT INTO ronbtf_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Atunci vei fi eliberat de acest jurământ al meu, când ajungi la rudele mele; şi dacă ei nu îţi vor da, vei fi eliberat de jurământul meu. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Şi am venit în această zi la fântână şi am spus: DOAMNE, Dumnezeul stăpânului meu Avraam, dacă voieşti acum să prospere calea mea pe care merg, ");
INSERT INTO ronbtf_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Iată, stau lângă fântâna de apă; şi se va întâmpla, că atunci când fecioara iese afară să scoată apă şi îi spun: Dă-mi, te rog, puţină apă din ulciorul tău să beau; ");
INSERT INTO ronbtf_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Iar ea îmi spune: Bea, deopotrivă tu şi voi scoate şi pentru cămilele tale, că aceasta să fie femeia pe care DOMNUL a rânduit-o pentru fiul stăpânului meu. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Şi înainte să termin de vorbit în inima mea, iată, Rebeca a ieşit afară cu ulciorul ei pe umăr; şi a coborât la fântână şi a scos apă, iar eu i-am spus: Lasă-mă să beau, te rog. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Iar ea s-a grăbit şi şi-a coborât ulciorul de pe umăr şi a spus: Bea şi voi da şi cămilelor tale să bea. Aşadar am băut şi a dat şi cămilelor să bea. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Şi am întrebat-o şi am spus: A cui fiică eşti tu? Şi ea a spus: Fiica lui Betuel, fiul lui Nahor, pe care Milca i l-a născut; şi i-am pus cercelul în nas şi brăţări pe mâinile ei. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Şi am plecat capul meu şi m-am închinat DOMNULUI şi am binecuvântat pe DOMNUL Dumnezeul stăpânului meu Avraam, care m-a condus pe calea dreaptă, să iau pe fiica fratelui stăpânului meu pentru fiul său. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Şi acum dacă voiţi să lucraţi cu bunătate şi adevăr cu stăpânul meu, spuneţi-mi; şi dacă nu, spuneţi-mi; ca să mă întorc la dreapta sau la stânga. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Atunci Laban şi Betuel au răspuns şi au zis: Acest lucru iese de la DOMNUL, nu îţi putem vorbi rău sau bine. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Iată, Rebeca este în faţa ta, ia-o şi mergi şi ea să fie soţia fiului stăpânului tău, aşa cum DOMNUL a vorbit. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Şi s-a întâmplat că, pe când servitorul lui Avraam a auzit cuvintele lor, s-a închinat DOMNULUI, prosternându-se la pământ. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Şi servitorul a adus bijuterii de argint şi bijuterii de aur şi haine şi le-a dat Rebecăi; el a dat lucruri preţioase de asemenea fratelui ei şi mamei ei. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Şi au mâncat şi au băut, el şi bărbaţii care erau cu el şi au rămas toată noaptea; şi s-au sculat dimineaţa şi a spus: Trimite-mă la stăpânul meu. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Şi fratele ei şi mama ei au spus: Lasă fata să rămână cu noi câteva zile, măcar zece; după aceea ea va merge. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Şi le-a spus: Nu mă împiedicaţi, văzând că DOMNUL a făcut să prospere calea mea; trimiteţi-mă ca să merg la stăpânul meu. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Iar ei au spus: Vom chema fata şi vom afla din gura ei. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Şi au chemat pe Rebeca şi i-au spus: Voieşti să mergi cu acest bărbat? Şi ea a spus: Voi merge. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Şi au trimis pe Rebeca, sora lor, şi pe dădaca ei şi pe servitorul lui Avraam şi pe bărbaţii lui. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Şi au binecuvântat-o pe Rebeca şi i-au spus: Tu eşti sora noastră, fii mama a mii de milioane şi sămânţa ta să stăpânească poarta celor care îi urăsc. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Şi Rebeca s-a ridicat şi tinerele ei şi au călărit pe cămile şi au urmat pe bărbat; şi servitorul a luat-o pe Rebeca şi a mers pe calea lui. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Şi Isaac a venit de pe calea de la fântâna Lahairoi, pentru că locuia în sudul ţinutului. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Şi Isaac a ieşit să mediteze în câmp, pe înserat; şi şi-a ridicat ochii şi a privit şi, iată, cămilele veneau. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Şi Rebeca şi-a ridicat ochii şi când a văzut pe Isaac a sărit jos de pe cămilă. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Pentru că ea spusese servitorului: Ce bărbat este acesta care umblă în câmp să ne întâmpine? Şi servitorul a spus: Este stăpânul meu; de aceea ea a luat un văl şi s-a acoperit. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Şi servitorul a istorisit lui Isaac toate lucrurile pe care le făcuse. ");
INSERT INTO ronbtf_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Şi Isaac a adus-o în cortul mamei sale, Sara, şi a luat-o pe Rebeca şi ea a devenit soţia lui; şi a iubit-o şi Isaac a fost mângâiat după moartea mamei sale. ");
INSERT INTO ronbtf_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Şi Avraam şi-a mai luat o soţie şi numele ei era Chetura. ");
INSERT INTO ronbtf_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Şi ea i-a născut pe Zimran şi pe Iocşan şi pe Medan şi pe Madian şi pe Işbac şi pe Şuah. ");
INSERT INTO ronbtf_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Şi Iocşan a născut pe Şeba şi pe Dedan. Şi fiii lui Dedan au fost: Aşurim şi Letuşim şi Leumim. ");
INSERT INTO ronbtf_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Şi fiii lui Madian: Efa şi Efer şi Hanoc şi Abida şi Eldaa. Toţi aceştia au fost copiii Cheturei. ");
INSERT INTO ronbtf_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Şi Avraam a dat lui Isaac tot ce a avut. ");
INSERT INTO ronbtf_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Dar fiilor concubinelor, pe care Avraam le-a avut în timp ce încă trăia, Avraam le-a dat daruri şi i-a trimis departe de Isaac, fiul său, spre est, în ţinutul din est. ");
INSERT INTO ronbtf_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Şi acestea sunt zilele anilor vieţii lui Avraam pe care le-a trăit, o sută şaptezeci şi cinci de ani. ");
INSERT INTO ronbtf_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Atunci Avraam şi-a dat duhul şi a murit la o bătrâneţe frumoasă, un om bătrân şi plin de ani; şi a fost adunat la poporul său. ");
INSERT INTO ronbtf_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Şi fiii săi, Isaac şi Ismael, l-au îngropat în peştera Macpela, în câmpul lui Efron, fiul lui Ţohar hititul, care este în faţă cu Mamre; ");
INSERT INTO ronbtf_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Câmpul pe care Avraam l-a cumpărat de la fiii lui Het: acolo a fost Avraam îngropat şi Sara, soţia lui. ");
INSERT INTO ronbtf_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Şi s-a întâmplat, după moartea lui Avraam, că Dumnezeu a binecuvântat pe fiul său, Isaac; şi Isaac a locuit lângă fântâna Lahairoi. ");
INSERT INTO ronbtf_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Acum acestea sunt generaţiile lui Ismael, fiul lui Avraam, pe care Hagar egipteanca, roaba lui Sara, l-a născut lui Avraam; ");
INSERT INTO ronbtf_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Şi acestea sunt numele fiilor lui Ismael, după numele lor, conform cu generaţiile lor: întâiul născut al lui Ismael, Nebaiot, şi Chedar şi Adbeel şi Mibsam, ");
INSERT INTO ronbtf_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Şi Mişma şi Duma şi Masa, ");
INSERT INTO ronbtf_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadar şi Tema, Ietur, Nafiş şi Chedma; ");
INSERT INTO ronbtf_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Aceştia sunt fiii lui Ismael şi acestea sunt numele lor, după satele lor şi după cetăţuile lor; doisprezece prinţi conform cu naţiunile lor. ");
INSERT INTO ronbtf_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Şi aceştia sunt anii vieţii lui Ismael, o sută treizeci şi şapte de ani; şi el şi-a dat duhul şi a murit; şi a fost luat la poporul său. ");
INSERT INTO ronbtf_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Şi au locuit de la Havila până la Şur, care este în faţă cu Egiptul, cum mergi spre Asiria; şi a murit înaintea feţei tuturor fraţilor săi. ");
INSERT INTO ronbtf_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Şi acestea sunt generaţiile lui Isaac, fiul lui Avraam: Avraam a născut pe Isaac; ");
INSERT INTO ronbtf_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Şi Isaac era în vârstă de patruzeci de ani când a luat pe Rebeca de soţie, fiica lui Betuel sirianul din Padanaram, sora lui Laban sirianul. ");
INSERT INTO ronbtf_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Şi Isaac l-a implorat pe DOMNUL pentru soţia lui, pentru că era stearpă; şi DOMNUL s-a lăsat înduplecat de el; şi Rebeca, soţia lui, a rămas însărcinată. ");
INSERT INTO ronbtf_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Şi copiii se luptau înăuntrul ei; şi ea a spus: Dacă este aşa, de ce sunt eu astfel? Şi ea s-a dus să întrebe pe DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Şi DOMNUL i-a spus: Două naţiuni sunt în pântecele tău şi două feluri de popoare se vor separa din adâncurile tale; şi un popor va fi mai tare decât celălalt popor; şi cel mai în vârstă va servi pe cel mai tânăr. ");
INSERT INTO ronbtf_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Şi când i s-au împlinit zilele să nască, iată, erau gemeni în pântecele ei. ");
INSERT INTO ronbtf_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Şi primul a ieşit roşu, peste tot ca un veşmânt păros; şi i-au pus numele, Esau. ");
INSERT INTO ronbtf_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Şi după aceea a ieşit fratele său şi mâna lui ţinea călcâiul lui Esau; şi i-au pus numele Iacob; şi Isaac era în vârstă de şaizeci de ani când ea i-a născut. ");
INSERT INTO ronbtf_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Şi băieţii au crescut şi Esau era un vânător iscusit, un bărbat al câmpului; iar Iacob era un bărbat simplu, locuind în corturi. ");
INSERT INTO ronbtf_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Şi Isaac iubea pe Esau, deoarece mânca din vânatul lui; dar Rebeca iubea pe Iacob. ");
INSERT INTO ronbtf_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Şi Iacob a fiert o supă şi Esau a venit de la câmp şi era leşinat; ");
INSERT INTO ronbtf_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Şi Esau a spus lui Iacob: Hrăneşte-mă, te rog, cu supa aceea roşie; căci sunt leşinat; de aceea i-a pus numele Edom. ");
INSERT INTO ronbtf_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Şi Iacob a spus: Vinde-mi astăzi dreptul tău de întâi născut. ");
INSERT INTO ronbtf_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Şi Esau a spus: Iată, eu sunt pe moarte şi la ce îmi foloseşte acest drept de întâi născut? ");
INSERT INTO ronbtf_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Şi Iacob a spus: Jură-mi astăzi; şi el i-a jurat şi i-a vândut dreptul său de întâi născut lui Iacob. ");
INSERT INTO ronbtf_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Atunci Iacob i-a dat lui Esau pâine şi supă de linte; şi a mâncat şi a băut şi s-a ridicat şi a plecat; astfel Esau a dispreţuit dreptul său de întâi născut. ");
INSERT INTO ronbtf_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Şi a fost o foamete în ţară, în afară de prima foamete care a fost în zilele lui Avraam. Şi Isaac a mers la Abimelec, împăratul filistenilor, la Gherar. ");
INSERT INTO ronbtf_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Şi DOMNUL i s-a arătat şi a spus: Nu coborî în Egipt; locuieşte în ţara despre care îţi voi spune; ");
INSERT INTO ronbtf_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Locuieşte temporar în această ţară şi voi fi cu tine şi te voi binecuvânta, pentru că ţie şi seminţei tale, voi da toate aceste ţări şi voi împlini jurământul pe care l-am jurat lui Avraam, tatăl tău. ");
INSERT INTO ronbtf_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Şi voi înmulţi sămânţa ta ca stelele cerului şi voi da seminţei tale toate aceste ţări; şi în sămânţa ta toate naţiunile pământului vor fi binecuvântate. ");
INSERT INTO ronbtf_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Pentru că Avraam a ascultat de vocea mea şi a păzit însărcinarea mea, poruncile mele, statutele mele şi legile mele. ");
INSERT INTO ronbtf_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Şi Isaac a locuit în Gherar; ");
INSERT INTO ronbtf_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Şi oamenii locului l-au întrebat despre soţia lui; iar el a spus: Ea este sora mea; căci se temea să spună: Este soţia mea; ca nu cumva, spunea el, oamenii locului să mă ucidă pentru Rebeca, pentru că ea era plăcută la vedere. ");
INSERT INTO ronbtf_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Şi s-a întâmplat, în timp ce el era acolo de mult timp, că Abimelec, împăratul filistenilor, a privit afară pe fereastră şi a văzut şi, iată, Isaac se juca cu Rebeca, soţia sa. ");
INSERT INTO ronbtf_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Şi Abimelec a chemat pe Isaac şi a spus: Iată, cu adevărat ea este soţia ta; şi cum de ai spus: Ea este sora mea? Şi Isaac i-a spus: Pentru că mi-am zis: Nu cumva să mor din cauza ei. ");
INSERT INTO ronbtf_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Şi Abimelec a spus: Ce este aceasta ce ne-ai făcut? Unul dintre oameni ar fi putut cu uşurinţă să se culce cu soţia ta şi ai fi adus vinovăţie asupra noastră. ");
INSERT INTO ronbtf_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Şi Abimelec a poruncit întregului popor, spunând: Cel ce se atinge de acest bărbat sau de soţia lui cu adevărat va fi dat la moarte. ");
INSERT INTO ronbtf_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Apoi Isaac a semănat în acel ţinut şi a primit în acelaşi an însutit şi DOMNUL l-a binecuvântat. ");
INSERT INTO ronbtf_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Şi acest bărbat a ajuns mare şi a mers înainte şi a crescut până ce a devenit foarte mare. ");
INSERT INTO ronbtf_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Fiindcă avea în posesiune turme şi în posesiune cirezi şi servitori în număr mare şi filistenii îl invidiau. ");
INSERT INTO ronbtf_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Şi toate fântânile pe care servitorii tatălui său le-au săpat în zilele lui Avraam, tatăl său, filistenii le-au astupat şi le-au umplut cu pământ. ");
INSERT INTO ronbtf_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Şi Abimelec i-a spus lui Isaac: Pleacă de la noi, pentru că eşti mult mai puternic decât noi. ");
INSERT INTO ronbtf_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Şi Isaac a plecat de acolo şi a ridicat cortul său în valea Gherar şi a locuit acolo. ");
INSERT INTO ronbtf_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Şi Isaac a săpat din nou fântânile de apă, pe care ei le săpaseră în zilele lui Avraam, tatăl său, pentru că filistenii le astupaseră după moartea lui Avraam; şi le-a pus numele după numele pe care tatăl său le-a pus. ");
INSERT INTO ronbtf_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Şi servitorii lui Isaac au săpat în vale şi au găsit acolo o fântână de apă ţâşnitoare. ");
INSERT INTO ronbtf_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Şi păstorii din Gherar s-au certat cu păstorii lui Isaac, spunând: Apa este a noastră; şi a pus fântânii numele Esec, pentru că s-au certat cu el. ");
INSERT INTO ronbtf_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Şi au săpat o altă fântână şi s-au certat şi pentru aceasta şi a pus acesteia numele Sitna. ");
INSERT INTO ronbtf_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Şi s-a mutat de acolo şi a săpat o altă fântână; şi pentru aceea nu s-au certat şi acesteia i-a pus numele Rehobot; şi a spus: Căci de acum DOMNUL a făcut loc pentru noi şi vom fi roditori în ţară. ");
INSERT INTO ronbtf_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Şi a urcat de acolo la Beer-Şeba. ");
INSERT INTO ronbtf_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Şi DOMNUL i s-a arătat în aceeaşi noapte şi a spus: Eu sunt Dumnezeul lui Avraam, tatăl tău, nu te teme, pentru că eu sunt cu tine şi te voi binecuvânta şi voi înmulţi sămânţa ta din cauza servitorului meu, Avraam. ");
INSERT INTO ronbtf_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Şi a zidit un altar acolo şi a chemat numele DOMNULUI şi a ridicat cortul său acolo; şi acolo servitorii lui Isaac au săpat o fântână. ");
INSERT INTO ronbtf_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Atunci Abimelec a mers la el, din Gherar, şi Ahuzat, unul din prietenii săi, şi Picol, căpetenia armatei sale. ");
INSERT INTO ronbtf_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Şi Isaac le-a spus: Pentru ce aţi venit la mine, văzând că mă urâţi şi m-aţi trimis de la voi? ");
INSERT INTO ronbtf_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Iar ei au spus: Noi am văzut cu adevărat că DOMNUL a fost cu tine; şi noi ne-am spus: Să fie acum un jurământ între noi, între noi şi tine, şi să facem un legământ cu tine; ");
INSERT INTO ronbtf_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Că nu ne vei face niciun rău, aşa cum nici noi nu ne-am atins de tine şi precum noi nu ţi-am făcut nimic decât bine şi te-am trimis în pace, tu eşti acum binecuvântatul DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Iar el le-a făcut un ospăţ şi au mâncat şi au băut. ");
INSERT INTO ronbtf_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Şi s-au sculat devreme dimineaţa şi au jurat unul altuia; şi Isaac i-a trimis şi au plecat de la el în pace. ");
INSERT INTO ronbtf_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Şi s-a întâmplat, în aceeaşi zi, că servitorii lui Isaac au venit şi i-au povestit referitor la fântâna pe care o săpaseră şi i-au spus: Am găsit apă. ");
INSERT INTO ronbtf_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Şi pe aceasta a numit-o Şeba, de aceea numele cetăţii este Beer-Şeba până în ziua de astăzi. ");
INSERT INTO ronbtf_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Şi Esau era în vârstă de patruzeci de ani când a luat de soţie pe Iudit, fiica lui Beeri hititul, şi pe Basmat, fiica lui Elon hititul, ");
INSERT INTO ronbtf_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Care au fost o mâhnire în duh pentru Isaac şi pentru Rebeca. ");
INSERT INTO ronbtf_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Şi s-a întâmplat, pe când Isaac era bătrân şi ochii săi erau atât de slabi încât nu mai putea să vadă, că a chemat pe Esau, fiul său cel mai în vârstă, şi i-a spus: Fiul meu; iar el i-a spus: Iată-mă. ");
INSERT INTO ronbtf_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Şi a spus: Iată acum, sunt bătrân, nu ştiu ziua morţii mele; ");
INSERT INTO ronbtf_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","De aceea acum, ia, te rog, armele tale, tolba ta şi arcul tău şi du-te afară în câmp şi ia-mi ceva vânat; ");
INSERT INTO ronbtf_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Şi fă-mi mâncare gustoasă, aşa cum îmi place, şi adu-o la mine ca să mănânc; ca sufletul meu să te binecuvânteze înainte să mor. ");
INSERT INTO ronbtf_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Şi Rebeca a auzit când Isaac a vorbit lui Esau, fiul său. Şi Esau a mers la câmp să vâneze vânat şi să îl aducă. ");
INSERT INTO ronbtf_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Şi Rebeca i-a vorbit lui Iacob, fiul ei, spunând: Iată, am auzit pe tatăl tău vorbindu-i lui Esau, fratele tău, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Adu-mi vânat şi fă-mi mâncare gustoasă ca să mănânc şi să te binecuvântez înaintea DOMNULUI înaintea morţii mele. ");
INSERT INTO ronbtf_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Acum, aşadar, fiul meu, ascultă de vocea mea, conform cu ceea ce îţi poruncesc. ");
INSERT INTO ronbtf_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Du-te acum la turmă şi ia şi adu-mi de acolo doi iezi buni de la capre; şi îi voi face mâncare gustoasă pentru tatăl tău, aşa cum îi place; ");
INSERT INTO ronbtf_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Şi o vei duce la tatăl tău, ca să mănânce şi să te binecuvânteze înaintea morţii sale. ");
INSERT INTO ronbtf_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Şi Iacob a spus Rebecăi, mama lui: Iată, Esau fratele meu este un bărbat păros, iar eu sunt un bărbat alunecos; ");
INSERT INTO ronbtf_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Tatăl meu poate mă va pipăi şi am să îi par ca un înşelător; şi voi aduce un blestem asupra mea şi nu o binecuvântare. ");
INSERT INTO ronbtf_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Şi mama lui i-a spus: Asupra mea fie blestemul tău, fiul meu; ascultă doar de vocea mea şi du-te, adu-mi iezii. ");
INSERT INTO ronbtf_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Şi s-a dus şi i-a luat şi i-a adus la mama lui; şi mama lui a făcut mâncare gustoasă, aşa cum îi plăcea tatălui său. ");
INSERT INTO ronbtf_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Şi Rebeca a luat haine bune care erau cu ea în casă, de la fiul ei mai în vârstă, Esau, şi le-a pus peste Iacob, fiul ei mai tânăr; ");
INSERT INTO ronbtf_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Şi ea a pus pieile iezilor de capre peste mâinile lui şi peste partea alunecoasă a gâtului său; ");
INSERT INTO ronbtf_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Şi a dat mâncarea gustoasă şi pâinea, pe care le-a pregătit, în mâna fiului ei, Iacob. ");
INSERT INTO ronbtf_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Şi el a venit la tatăl său şi a spus: Tată; iar el a spus: Iată-mă, cine eşti tu, fiul meu? ");
INSERT INTO ronbtf_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Şi Iacob i-a spus tatălui său: Eu sunt Esau, întâiul tău născut; am făcut după cum m-ai rugat; ridică-te, te rog, şezi şi mănâncă din vânatul meu, ca sufletul tău să mă binecuvânteze. ");
INSERT INTO ronbtf_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Şi Isaac a spus fiului său: Cum se face că ai găsit vânat aşa repede, fiul meu? Iar el a spus: Pentru că DOMNUL Dumnezeul tău l-a adus la mine. ");
INSERT INTO ronbtf_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Şi Isaac i-a spus lui Iacob: Vino aproape, te rog, să te pipăi, fiul meu, dacă eşti sau nu adevăratul meu fiu Esau. ");
INSERT INTO ronbtf_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Şi Iacob s-a apropiat de Isaac, tatăl său; iar el l-a pipăit şi a spus: Vocea este vocea lui Iacob, dar mâinile sunt mâinile lui Esau. ");
INSERT INTO ronbtf_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Şi nu l-a recunoscut, din cauză că mâinile lui erau păroase, ca mâinile fratelui său Esau, aşa că l-a binecuvântat. ");
INSERT INTO ronbtf_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Şi a spus: Eşti tu adevăratul meu fiu Esau? Iar el a spus: Eu sunt. ");
INSERT INTO ronbtf_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Iar el a spus: Adu-o aproape de mine şi voi mânca din vânatul fiului meu, ca sufletul meu să te binecuvânteze. Şi a adus-o aproape de el şi a mâncat; şi i-a adus vin şi a băut. ");
INSERT INTO ronbtf_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Şi tatăl său Isaac i-a spus: Vino aproape acum şi sărută-mă, fiul meu. ");
INSERT INTO ronbtf_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Şi a venit aproape şi l-a sărutat; şi a mirosit mirosul hainelor lui şi l-a binecuvântat şi a spus: Vezi, mirosul fiului meu este ca mirosul unui câmp pe care DOMNUL l-a binecuvântat; ");
INSERT INTO ronbtf_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","De aceea Dumnezeu să îţi dea din roua cerului şi din grăsimea pământului şi abundenţă de grâne şi vin; ");
INSERT INTO ronbtf_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Să te servească poporul şi naţiuni să ţi se prosterneze, fii domn peste fraţii tăi şi fiii mamei tale să ţi se prosterneze; blestemat fie cel ce te blestemă şi binecuvântat fie cel ce te binecuvântează. ");
INSERT INTO ronbtf_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Şi s-a întâmplat, îndată ce Isaac a terminat de binecuvântat pe Iacob şi Iacob tocmai ce ieşise dinaintea lui Isaac, tatăl său, că Esau, fratele său, a venit de la vânătoarea sa. ");
INSERT INTO ronbtf_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Şi el de asemenea a făcut mâncare gustoasă şi a adus-o tatălui său şi a spus tatălui său: Să se ridice tatăl meu şi să mănânce din vânatul fiului său, ca sufletul tău să mă binecuvânteze. ");
INSERT INTO ronbtf_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Şi Isaac tatăl său i-a spus: Cine eşti tu? Iar el a spus: Eu sunt fiul tău, întâiul tău născut Esau. ");
INSERT INTO ronbtf_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Şi Isaac s-a cutremurat peste măsură de mult şi a spus: Cine? Unde este cel ce a luat vânat şi l-a adus la mine şi am mâncat din tot înainte de a veni tu şi l-am binecuvântat? Da şi va fi binecuvântat. ");
INSERT INTO ronbtf_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Şi când Esau a auzit cuvintele tatălui său, a strigat cu un strigăt mare şi grozav de amar şi a spus tatălui său: Binecuvântează-mă şi pe mine tată. ");
INSERT INTO ronbtf_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Iar el a spus: Fratele tău a venit cu viclenie şi ţi-a luat binecuvântarea. ");
INSERT INTO ronbtf_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Iar el a spus: Nu pe drept este numit el Iacob? Pentru că m-a înlocuit în aceste două dăţi, a luat dreptul meu de întâi născut; şi acum, iată, a luat şi binecuvântarea mea. Şi a spus: Nu ai păstrat o binecuvântare pentru mine? ");
INSERT INTO ronbtf_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Şi Isaac a răspuns şi i-a zis lui Esau: Iată, l-am făcut domnul tău şi pe toţi fraţii lui i-am dat ca servitori; şi cu grâne şi vin l-am susţinut şi ce să îţi fac acum, fiul meu? ");
INSERT INTO ronbtf_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Şi Esau a spus tatălui său: Ai doar o singură binecuvântare, tată? Binecuvântează-mă şi pe mine tată. Şi Esau şi-a înălţat vocea şi a plâns. ");
INSERT INTO ronbtf_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Şi Isaac, tatăl lui, a răspuns şi i-a zis: Iată, locuinţa ta va fi grăsimea pământului şi din roua cerului de sus. ");
INSERT INTO ronbtf_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Şi prin sabia ta vei trăi şi vei servi fratelui tău; şi se va întâmpla când vei avea stăpânirea, că vei desface jugul lui de pe gâtul tău. ");
INSERT INTO ronbtf_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Şi Esau a urât pe Iacob din cauza binecuvântării cu care tatăl său l-a binecuvântat; şi Esau a spus în inima sa: Zilele de jelire pentru tatăl meu sunt aproape; atunci voi ucide pe fratele meu Iacob. ");
INSERT INTO ronbtf_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Şi aceste cuvinte ale lui Esau, fiul ei mai în vârstă, au fost spuse Rebecăi; şi ea a trimis şi a chemat pe Iacob, fiul ei mai tânăr, şi i-a spus: Iată, fratele tău, Esau, se mângâie referitor la tine, hotărât să te ucidă. ");
INSERT INTO ronbtf_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","De aceea acum, fiul meu, ascultă de vocea mea; şi ridică-te, fugi la Laban, fratele meu, la Haran. ");
INSERT INTO ronbtf_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Şi rămâi cu el câteva zile, până ce furia fratelui tău se întoarce; ");
INSERT INTO ronbtf_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Până ce mânia fratelui tău se întoarce de la tine şi uită ce i-ai făcut; atunci voi trimite şi te voi aduce de acolo; şi de ce să fiu lipsită de voi doi într-o singură zi? ");
INSERT INTO ronbtf_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Şi Rebeca i-a spus lui Isaac: M-am săturat de viaţa mea din cauza fiicelor lui Het; dacă Iacob ia o soţie dintre fiicele lui Het, ca acestea dintre fiicele ţării, la ce bun îmi va fi viaţa? ");
INSERT INTO ronbtf_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Şi Isaac a chemat pe Iacob şi l-a binecuvântat şi i-a poruncit şi i-a spus: Nu lua o soţie dintre fiicele lui Canaan. ");
INSERT INTO ronbtf_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Ridică-te, mergi la Padanaram, la casa lui Betuel, tatăl mamei tale, şi ia-ţi o soţie de acolo, dintre fiicele lui Laban, fratele mamei tale. ");
INSERT INTO ronbtf_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Şi Dumnezeul Atotputernic să te binecuvânteze şi să te facă roditor şi să te înmulţească să fii o mulţime de popoare; ");
INSERT INTO ronbtf_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Şi să îţi dea binecuvântarea lui Avraam, ţie şi seminţei tale cu tine, ca să moşteneşti ţara în care eşti străin, pe care Dumnezeu a dat-o lui Avraam. ");
INSERT INTO ronbtf_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Şi Isaac l-a trimis pe Iacob; iar el s-a dus la Padanaram, la Laban, fiul lui Betuel sirianul, fratele Rebecăi, mama lui Iacob şi Esau. ");
INSERT INTO ronbtf_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Când Esau a văzut că Isaac a binecuvântat pe Iacob şi l-a trimis la Padanaram să îşi ia o soţie de acolo şi, binecuvântându-l, i-a dat poruncă, spunând: Nu lua o soţie dintre fiicele lui Canaan; ");
INSERT INTO ronbtf_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Şi că Iacob a ascultat de tatăl său şi mama sa şi a mers la Padanaram; ");
INSERT INTO ronbtf_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Şi Esau, văzând că fiicele lui Canaan nu îi plăceau lui Isaac, tatăl său, ");
INSERT INTO ronbtf_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Esau a mers la Ismael şi a luat, pe lângă soţiile pe care le avea, pe Mahalat, fiica lui Ismael, fiul lui Avraam, sora lui Nebaiot, să fie soţia sa. ");
INSERT INTO ronbtf_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Şi Iacob a ieşit din Beer-Şeba şi a mers spre Haran. ");
INSERT INTO ronbtf_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Şi s-a aşezat într-un anumit loc şi a rămas acolo toată noaptea, deoarece soarele apusese; şi a luat dintre pietrele din acel loc şi le-a pus drept perne ale sale şi s-a culcat în locul acela să doarmă. ");
INSERT INTO ronbtf_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Şi a visat şi, iată, o scară pusă pe pământ şi vârful ei ajungea la cer şi, iată, îngerii lui Dumnezeu urcând şi coborând pe ea. ");
INSERT INTO ronbtf_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Şi, iată, DOMNUL a stat în picioare deasupra acesteia şi a spus: Eu sunt DOMNUL Dumnezeul lui Avraam, tatăl tău, şi Dumnezeul lui Isaac; pământul pe care eşti culcat, ţie ţi-l voi da şi seminţei tale; ");
INSERT INTO ronbtf_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Şi sămânţa ta va fi ca ţărâna pământului şi te vei răspândi departe spre vest şi spre est şi spre nord şi spre sud şi în tine şi în sămânţa ta vor fi binecuvântate toate familiile pământului. ");
INSERT INTO ronbtf_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Şi, iată, eu sunt cu tine şi te voi păzi în toate locurile în care mergi şi te voi aduce înapoi în această ţară; fiindcă nu te voi părăsi, până ce nu voi fi făcut lucrul despre care ţi-am vorbit. ");
INSERT INTO ronbtf_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Şi Iacob s-a trezit din somnul său şi a spus: Cu adevărat DOMNUL este în acest loc, iar eu nu am ştiut. ");
INSERT INTO ronbtf_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Şi s-a temut şi a spus: Cât de înspăimântător este acest loc! Aceasta nu este altceva decât casa lui Dumnezeu şi aceasta este poarta cerului. ");
INSERT INTO ronbtf_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Şi Iacob s-a ridicat devreme dimineaţa şi a luat piatra pe care o pusese drept perne ale sale şi a pus-o ca stâlp şi a turnat untdelemn pe vârful acesteia. ");
INSERT INTO ronbtf_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Şi a pus acelui loc numele Betel, dar numele acelei cetăţi era Luz mai înainte. ");
INSERT INTO ronbtf_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Şi Iacob a făcut o promisiune, spunând: Dacă Dumnezeu va fi cu mine şi mă va ţine pe această cale pe care merg şi îmi va da pâine să mănânc şi haine să îmbrac, ");
INSERT INTO ronbtf_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","Aşa ca eu să mă întorc înapoi la casa tatălui meu în pace, atunci DOMNUL va fi Dumnezeul meu; ");
INSERT INTO ronbtf_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Şi această piatră, pe care am pus-o ca stâlp, va fi casa lui Dumnezeu; şi din tot ce îmi vei da, îţi voi da negreşit zeciuială. ");
INSERT INTO ronbtf_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Apoi Iacob a mers în călătoria sa şi a mers în ţara poporului din est. ");
INSERT INTO ronbtf_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Şi a privit şi, iată, o fântână în câmp şi, iată, acolo erau trei turme de oi culcate lângă ea; căci din acea fântână adăpau turmele; şi o piatră mare era peste gura fântânii. ");
INSERT INTO ronbtf_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Şi acolo erau toate turmele adunate şi au rostogolit piatra de la gura fântânii şi au adăpat oile şi au pus piatra din nou peste gura fântânii la locul ei. ");
INSERT INTO ronbtf_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Şi Iacob le-a spus: Fraţii mei, de unde sunteţi voi? Iar ei au spus: Noi suntem din Haran. ");
INSERT INTO ronbtf_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Iar el le-a spus: Îl cunoaşteţi pe Laban, fiul lui Nahor? Iar ei au spus: Îl cunoaştem. ");
INSERT INTO ronbtf_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Iar el le-a spus: Este el bine? Iar ei au spus: Este bine şi, iată, Rahela, fiica lui, vine cu oile. ");
INSERT INTO ronbtf_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Iar el a spus: Iată, ziua este încă mare, nici nu este timpul ca vitele să fie adunate; adăpaţi oile şi mergeţi şi le paşteţi. ");
INSERT INTO ronbtf_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Iar ei au spus: Nu putem, până când toate turmele sunt adunate şi când ei rostogolesc piatra de la gura fântânii, atunci adăpăm oile. ");
INSERT INTO ronbtf_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Şi în timp ce el încă vorbea cu ei, Rahela a venit cu oile tatălui ei, pentru că ea le păzea. ");
INSERT INTO ronbtf_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Şi s-a întâmplat, când Iacob a văzut-o pe Rahela, fiica lui Laban, fratele mamei sale, şi oile lui Laban, fratele mamei sale, că Iacob s-a apropiat şi a rostogolit piatra de la gura fântânii şi a adăpat turma lui Laban, fratele mamei sale. ");
INSERT INTO ronbtf_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Şi Iacob a sărutat pe Rahela şi el şi-a ridicat vocea şi a plâns. ");
INSERT INTO ronbtf_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Şi Iacob a povestit Rahelei că el era fratele tatălui ei şi că el era fiul Rebecăi; şi ea a alergat şi a povestit tatălui ei. ");
INSERT INTO ronbtf_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Şi s-a întâmplat, când Laban a auzit veştile despre Iacob, fiul surorii lui, că el a alergat să îl întâlnească şi l-a îmbrăţişat şi l-a sărutat şi l-a adus în casa lui. Şi el a povestit lui Laban toate aceste lucruri. ");
INSERT INTO ronbtf_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Şi Laban i-a spus: Tu eşti cu adevărat osul meu şi carnea mea. Şi a rămas cu el o lună de zile. ");
INSERT INTO ronbtf_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Şi Laban i-a spus lui Iacob: Pentru că tu eşti fratele meu ar trebui de aceea să îmi serveşti degeaba? Spune-mi, ce va fi plata ta. ");
INSERT INTO ronbtf_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Şi Laban avea două fiice; numele celei mai în vârstă era Leea şi numele celei mai tinere era Rahela. ");
INSERT INTO ronbtf_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leea era slabă de ochi; dar Rahela era frumoasă la statură şi plăcută la vedere. ");
INSERT INTO ronbtf_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Şi Iacob a iubit-o pe Rahela; şi a spus: Te voi servi şapte ani pentru Rahela, fiica ta mai tânără. ");
INSERT INTO ronbtf_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Şi Laban a spus: Este mai bine să ţi-o dau ţie decât să o dau altui bărbat; rămâi la mine. ");
INSERT INTO ronbtf_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Şi Iacob a servit şapte ani pentru Rahela; şi aceştia i-au părut doar câteva zile, din cauza dragostei pe care o avea pentru ea. ");
INSERT INTO ronbtf_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Şi Iacob i-a spus lui Laban: Dă-mi soţia mea, pentru că zilele mi s-au împlinit, ca să intru la ea. ");
INSERT INTO ronbtf_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Şi Laban a strâns împreună toţi bărbaţii locului şi a făcut un ospăţ. ");
INSERT INTO ronbtf_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Şi s-a întâmplat, în timpul serii, că el a luat pe Leea fiica sa, şi i-a adus-o; iar el a intrat la ea. ");
INSERT INTO ronbtf_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Şi Laban a dat fiicei sale, Leea, pe Zilpa, roaba lui, ca servitoare. ");
INSERT INTO ronbtf_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Şi s-a întâmplat, că dimineaţa, iată, era Leea; şi i-a spus lui Laban: Ce este aceasta ce mi-ai făcut? Nu ţi-am servit pentru Rahela? Şi de ce m-ai înşelat? ");
INSERT INTO ronbtf_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Şi Laban a spus: Nu trebuie să fie făcut astfel în ţara noastră, a da pe cea mai tânără înaintea celei întâi născute. ");
INSERT INTO ronbtf_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Împlineşte săptămâna ei şi ţi-o vom da şi pe aceasta pentru serviciul pe care mi-l vei face încă alţi şapte ani. ");
INSERT INTO ronbtf_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Şi Iacob a făcut astfel şi a împlinit săptămâna ei; iar el i-a dat şi pe Rahela, fiica sa, de soţie. ");
INSERT INTO ronbtf_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Şi Laban a dat Rahelei, fiica sa, pe Bilha, roaba lui, să fie roaba ei. ");
INSERT INTO ronbtf_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Iar el a intrat şi la Rahela şi a iubit pe Rahela şi mai mult decât pe Leea şi i-a servit încă alţi şapte ani. ");
INSERT INTO ronbtf_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Şi când DOMNUL a văzut că Leea era urâtă de el, a deschis pântecele ei; dar Rahela era stearpă. ");
INSERT INTO ronbtf_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Şi Leea a rămas însărcinată şi a născut un fiu şi i-a pus numele Ruben, căci ea a spus: Cu adevărat DOMNUL a privit la necazul meu; de aceea acum soţul meu mă va iubi. ");
INSERT INTO ronbtf_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Şi a rămas însărcinată din nou şi a născut un fiu şi a spus: Pentru că DOMNUL a auzit că eu eram urâtă de soţul meu, mi-a dat de aceea şi acest fiu; şi i-a pus numele Simeon. ");
INSERT INTO ronbtf_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Şi a rămas însărcinată din nou şi a născut un fiu şi a spus: Acum, de această dată, soţul meu va fi lipit de mine, pentru că i-am născut lui trei fii; de aceea numele lui a fost chemat Levi. ");
INSERT INTO ronbtf_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Şi a rămas însărcinată din nou şi a născut un fiu; şi a spus: Acum voi lăuda pe DOMNUL; de aceea i-a pus numele Iuda; şi a încetat să nască. ");
INSERT INTO ronbtf_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Şi când Rahela a văzut că ea nu îi naşte lui Iacob copii, Rahela a invidiat pe sora ei; şi i-a spus lui Iacob: Dă-mi copii sau altfel mor. ");
INSERT INTO ronbtf_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Şi mânia lui Iacob s-a aprins împotriva Rahelei şi a spus: Sunt eu în locul lui Dumnezeu care a oprit de la tine rodul pântecelui? ");
INSERT INTO ronbtf_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Iar ea a spus: Iată, pe servitoarea mea, Bilha, intră la ea; şi va naşte pe genunchii mei, ca eu de asemenea să am copii prin ea. ");
INSERT INTO ronbtf_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Şi i-a dat-o pe Bilha, roaba ei, de soţie; şi Iacob a intrat la ea. ");
INSERT INTO ronbtf_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Şi Bilha a rămas însărcinată şi i-a născut lui Iacob un fiu. ");
INSERT INTO ronbtf_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Şi Rahela a spus: Dumnezeu m-a judecat şi a auzit de asemenea vocea mea şi mi-a dat un fiu; de aceea i-a pus numele Dan. ");
INSERT INTO ronbtf_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Şi Bilha, servitoarea Rahelei, a rămas însărcinată din nou şi i-a născut lui Iacob un al doilea fiu. ");
INSERT INTO ronbtf_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Şi Rahela a spus: Cu mari lupte am luptat cu sora mea şi am învins; şi i-a pus numele Neftali. ");
INSERT INTO ronbtf_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Când Leea a văzut că ea a încetat să nască, a luat pe Zilpa, servitoarea ei, şi i-a dat-o lui Iacob de soţie. ");
INSERT INTO ronbtf_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Şi Zilpa, servitoarea Leei, i-a născut lui Iacob un fiu. ");
INSERT INTO ronbtf_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Şi Leea a spus: O trupă înarmată vine; şi i-a pus numele Gad. ");
INSERT INTO ronbtf_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Şi Zilpa, servitoarea Leei, i-a născut lui Iacob un al doilea fiu. ");
INSERT INTO ronbtf_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Şi Leea a spus: Fericită sunt, căci fiicele mă vor numi binecuvântată; şi i-a pus numele Aşer. ");
INSERT INTO ronbtf_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Şi Ruben a mers în zilele secerişului grâului şi a găsit mandragore în câmp şi le-a adus la mama lui, Leea. Atunci Rahela i-a spus Leei: Dă-mi, te rog, din mandragorele fiului tău. ");
INSERT INTO ronbtf_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Iar Leea i-a spus: Este puţin lucru că ai luat pe soţul meu? Şi voieşti să iei şi mandragorele fiului meu? Şi Rahela a spus: De aceea el să se culce cu tine la noapte pentru mandragorele fiului tău. ");
INSERT INTO ronbtf_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Şi Iacob a venit de la câmp pe înserat şi Leea a ieşit să îl întâlnească şi a spus: Trebuie să intri la mine; căci cu adevărat te-am angajat cu mandragorele fiului meu. Şi el s-a culcat cu ea în acea noapte. ");
INSERT INTO ronbtf_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Şi Dumnezeu a dat ascultare Leei şi ea a rămas însărcinată şi i-a născut lui Iacob al cincilea fiu. ");
INSERT INTO ronbtf_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Şi Leea a spus: Dumnezeu mi-a dat plata mea, pentru că am dat pe servitoarea mea soţului meu; şi i-a pus numele Isahar. ");
INSERT INTO ronbtf_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Şi Leea a rămas însărcinată din nou şi i-a născut lui Iacob al şaselea fiu. ");
INSERT INTO ronbtf_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Şi Leea a spus: Dumnezeu m-a înzestrat cu o zestre bună; acum soţul meu va locui cu mine, deoarece i-am născut şase fii; şi i-a pus numele Zabulon. ");
INSERT INTO ronbtf_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Şi mai apoi ea a născut o fiică şi i-a pus numele Dina. ");
INSERT INTO ronbtf_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Şi Dumnezeu şi-a amintit de Rahela şi Dumnezeu i-a dat ascultare şi i-a deschis pântecele. ");
INSERT INTO ronbtf_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Şi ea a rămas însărcinată şi a născut un fiu şi a spus: Dumnezeu mi-a luat ocara; ");
INSERT INTO ronbtf_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Şi i-a pus numele Iosif şi a spus: DOMNUL îmi va adăuga un alt fiu. ");
INSERT INTO ronbtf_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Şi s-a întâmplat, când Rahela a născut pe Iosif, că Iacob i-a spus lui Laban: Trimite-mă, ca să merg la locul meu şi în ţara mea. ");
INSERT INTO ronbtf_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Dă-mi soţiile mele şi copiii mei, pentru care ţi-am servit şi lasă-mă să plec, pentru că ştii serviciul meu pe care ţi l-am făcut. ");
INSERT INTO ronbtf_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Şi Laban i-a spus: Te rog, dacă am găsit favoare în ochii tăi, rămâi, căci am învăţat prin experienţă că DOMNUL m-a binecuvântat din cauza ta. ");
INSERT INTO ronbtf_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Iar el a spus: Rânduieşte-mi plăţile tale şi ţi le voi da. ");
INSERT INTO ronbtf_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Iar el i-a spus: Ştii cum ţi-am servit şi că turma ta era cu mine. ");
INSERT INTO ronbtf_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Căci era puţin ce ai avut înainte ca eu să vin şi acum a sporit într-o mulţime; şi DOMNUL te-a binecuvântat de la venirea mea şi acum, când voi îngriji şi de casa mea? ");
INSERT INTO ronbtf_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Iar el a spus: Ce să îţi dau? Şi Iacob a spus: Nu îmi da nimic, dacă vei face acest lucru pentru mine, voi paşte şi voi ţine din nou turma ta; ");
INSERT INTO ronbtf_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Voi trece prin toată turma ta astăzi, mutând de acolo toate cele pestriţe şi pătate şi toate cele cenuşii dintre oi şi pe cele pestriţe şi pătate dintre capre şi din aceasta va fi plata mea. ");
INSERT INTO ronbtf_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Aşa va răspunde dreptatea mea pentru mine în timpul ce vine, când vine timpul pentru plata mea înaintea feţei tale; fiecare vită care nu este pestriţă sau pătată dintre capre şi cenuşie dintre oi, aceea va fi socotită de mine ca furată. ");
INSERT INTO ronbtf_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Şi Laban a spus: Iată, aş voi să fie conform cuvântului tău. ");
INSERT INTO ronbtf_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Şi a scos în acea zi ţapii care erau vărgaţi şi pătaţi şi toate caprele care erau pestriţe şi pătate şi pe fiecare ce avea ceva alb pe ea şi tot ce era cenuşiu între oi şi le-a dat în mâna fiilor săi. ");
INSERT INTO ronbtf_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Şi a pus trei zile de călătorie între el şi Iacob; şi Iacob a păscut restul turmelor lui Laban. ");
INSERT INTO ronbtf_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Şi Iacob a luat toiege verzi de plop şi de alun şi de castan dulce; şi a descojit dungi albe pe ele şi a făcut să apară albul care era în toiege. ");
INSERT INTO ronbtf_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Şi a pus toiegele pe care le descojise înaintea turmelor în jgheaburi, în adăpătoarele cu apă, când turmele veneau să bea, ca ele, când veneau să bea, să zămislească. ");
INSERT INTO ronbtf_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Şi turmele zămisleau înaintea toiegelor şi năşteau miei vărgaţi, pestriţi şi pătaţi. ");
INSERT INTO ronbtf_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Şi Iacob a separat mieii şi întorcea feţele turmelor spre cele vărgate şi toate cele cenuşii în turma lui Laban; şi a pus propriile sale turme deoparte şi nu le-a pus cu turmele lui Laban. ");
INSERT INTO ronbtf_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Şi s-a întâmplat, de câte ori oile mai puternice zămisleau, că Iacob aşeza toiegele înaintea ochilor oilor în jgheaburile de apă, ca ele să zămislească printre toiege. ");
INSERT INTO ronbtf_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Dar când oile erau slabe, nu le punea înăuntru, aşa că cele mai slabe erau ale lui Laban şi cele mai puternice ale lui Iacob. ");
INSERT INTO ronbtf_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Şi acest bărbat a sporit peste măsură şi avea multe oi şi servitoare şi servitori şi cămile şi măgari. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Şi a auzit cuvintele fiilor lui Laban, spunând: Iacob a luat tot ce era al tatălui nostru; şi din ceea ce era al tatălui nostru el a dobândit toată această glorie. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Şi Iacob a privit înfăţişarea lui Laban şi, iată, aceasta nu mai era faţă de el ca înainte. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Şi DOMNUL i-a spus lui Iacob: Întoarce-te în ţara părinţilor tăi şi la rudele tale; şi eu voi fi cu tine. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Şi Iacob a trimis şi a chemat pe Rahela şi Leea la câmp, la turma sa, ");
INSERT INTO ronbtf_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Şi le-a spus: Văd înfăţişarea tatălui vostru, că aceasta nu mai este faţă de mine ca înainte; dar Dumnezeul părinţilor mei a fost cu mine. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Şi voi ştiţi că eu, cu toată puterea mea, am servit pe tatăl vostru. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Şi tatăl vostru m-a înşelat şi a schimbat plăţile mele de zece ori; dar Dumnezeu nu i-a permis să mă vatăme. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Dacă el a spus astfel: Cele pestriţe vor fi plăţile tale; atunci toate vitele au născut pestriţe; şi dacă el a spus astfel: Cele vărgate vor fi plata ta; atunci toate vitele au născut vărgate. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Astfel Dumnezeu a luat vitele tatălui vostru şi mi le-a dat mie. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Şi s-a întâmplat în acel timp, când vitele zămisleau, că mi-am ridicat ochii şi am văzut într-un vis şi, iată, berbecii care săreau pe oi erau vărgaţi, pestriţi şi bălţaţi. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Şi îngerul lui Dumnezeu mi-a vorbit într-un vis, spunând: Iacob; iar eu am spus: Iată-mă. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Şi a spus: Ridică-ţi acum ochii şi vezi, toţi berbecii care sar pe vite sunt vărgaţi, pestriţi şi bălţaţi, pentru că am văzut tot ceea ce Laban îţi face. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Eu sunt Dumnezeul din Betel, unde ai uns stâlpul şi unde mi-ai făcut o promisiune; acum ridică-te, ieşi din această ţară şi întoarce-te în ţara rudelor tale. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Şi Rahela şi Leea au răspuns şi i-au zis: Este totuşi vreo parte sau moştenire pentru noi în casa tatălui nostru? ");
INSERT INTO ronbtf_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Nu suntem socotite de el ca străine? Căci ne-a vândut şi ne-a mâncat în întregime şi banii. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Pentru că toată bogăţia pe care Dumnezeu a luat-o de la tatăl nostru este a noastră şi a copiilor noştri, acum aşadar, fă orice ţi-a spus Dumnezeu. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Atunci Iacob s-a ridicat şi a aşezat pe fiii săi şi pe soţiile sale pe cămile; ");
INSERT INTO ronbtf_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Şi a dus toate vitele sale şi toate bunurile sale pe care le dobândise, vitele agoniselii sale, pe care le dobândise în Padanaram, pentru a merge la Isaac, tatăl său, în ţara lui Canaan. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Şi Laban s-a dus să-şi tundă oile şi Rahela furase idolii care erau ai tatălui ei. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Şi Iacob s-a furişat pe neştiute de la Laban sirianul, în aceea că nu i-a spus că a fugit. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Aşa că a fugit cu tot ce a avut; şi s-a ridicat şi a trecut dincolo de râu şi el şi-a îndreptat faţa spre muntele Galaad. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Şi în a treia zi i s-a spus lui Laban că Iacob fugise. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Şi a luat pe fraţii săi cu el şi l-a urmărit şapte zile de călătorie; şi l-au ajuns în muntele Galaad. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Şi Dumnezeu a venit la Laban sirianul într-un vis, noaptea, şi i-a spus: Ia seamă să nu vorbeşti lui Iacob nici bine nici rău. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Atunci Laban a ajuns pe Iacob. Şi Iacob şi-a ridicat cortul în munte şi Laban, cu fraţii săi, şi l-au ridicat în muntele Galaad. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Şi Laban i-a spus lui Iacob: Ce ai făcut, că te-ai furişat pe neştiute de la mine şi ai dus pe fiicele mele ca pe captivi luaţi cu sabia? ");
INSERT INTO ronbtf_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Pentru ce ai fugit în secret şi te-ai furişat de la mine; şi nu mi-ai spus, ca să te fi trimis cu bucurie şi cu cântece, cu tamburină şi cu harpă? ");
INSERT INTO ronbtf_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Şi nu m-ai lăsat să sărut pe fiii mei şi pe fiicele mele? Acum ai lucrat prosteşte făcând astfel. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Este în puterea mâinii mele să îţi fac rău, dar Dumnezeul tatălui tău mi-a vorbit azi-noapte, spunând: Ia seamă să nu vorbeşti lui Iacob nici bine nici rău. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Şi acum, deşi ai dori să fii plecat, pentru că tânjeşti aprins după casa tatălui tău, totuşi pentru ce ai furat dumnezeii mei? ");
INSERT INTO ronbtf_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Şi Iacob a răspuns şi a spus lui Laban: Pentru că m-am temut, căci spuneam: S-ar putea să iei cu forţa pe fiicele tale de la mine. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","La oricine găseşti dumnezeii tăi, nu îl lăsa să trăiască, înaintea fraţilor noştri să recunoşti ce este al tău la mine şi ia aceasta la tine. Pentru că Iacob nu ştia că Rahela i-a furat. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Şi Laban a intrat în cortul lui Iacob şi în cortul Leei şi în corturile celor două servitoare, dar nu i-a găsit. Atunci a ieşit din cortul Leei şi a intrat în cortul Rahelei. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Acum Rahela luase idolii şi îi pusese în şeaua cămilei şi stătea peste ei. Şi Laban a căutat în tot cortul, dar nu i-a găsit. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Şi ea a spus tatălui ei: Să nu fie cu supărare domnului meu că nu pot să mă ridic înaintea ta; căci rânduiala femeilor este asupra mea. Iar el a căutat, dar nu a găsit idolii. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Şi Iacob s-a înfuriat şi s-a certat cu Laban; şi Iacob a răspuns şi i-a zis lui Laban: Care îmi este fărădelegea? Care îmi este păcatul, că aşa aprins m-ai urmărit? ");
INSERT INTO ronbtf_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Cu toate că ai căutat în toate lucrurile mele, ce ai găsit din toate lucrurile casei tale? Pune-le aici înaintea fraţilor mei şi a fraţilor tăi, ca ei să judece între noi doi. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Aceşti douăzeci de ani am fost cu tine; oile tale şi caprele tale nu au lepădat puii lor şi berbecii turmei tale nu i-am mâncat. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ce a fost sfâşiat de fiare nu am adus la tine; eu am purtat pierderea aceea; din mâna mea ai cerut-o, fie că a fost furată ziua sau furată noaptea. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Astfel am fost; în timpul zilei seceta mă mistuia şi bruma în timpul nopţii; şi somnul mi s-a depărtat de la ochii mei. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Astfel am fost eu douăzeci de ani în casa ta; ţi-am servit paisprezece ani pentru cele două fiice ale tale şi şase ani pentru vitele tale; şi ai schimbat plăţile mele de zece ori. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Dacă Dumnezeul tatălui meu, Dumnezeul lui Avraam şi teama lui Isaac, nu ar fi fost cu mine, cu adevărat m-ai fi trimis acum gol. Dumnezeu a văzut necazul meu şi munca mâinilor mele şi te-a mustrat aseară. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Şi Laban a răspuns şi i-a zis lui Iacob: Aceste fiice sunt fiicele mele şi aceşti copii sunt copiii mei şi aceste vite sunt vitele mele şi tot ceea ce vezi este al meu şi ce pot face în această zi acestor fiice ale mele, sau copiilor lor pe care i-au născut? ");
INSERT INTO ronbtf_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","De aceea vino acum, să facem un legământ, eu şi tu; şi să fie acesta pentru o mărturie între mine şi tine. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Şi Iacob a luat o piatră şi a aşezat-o drept stâlp. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Şi Iacob le-a spus fraţilor săi: Adunaţi pietre; şi au luat pietre şi au făcut o movilă şi au mâncat acolo pe movilă. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Şi Laban a numit-o Iegarsahaduta, dar Iacob a numit-o Galed. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Şi Laban a spus: Această movilă este o mărturie între mine şi tine în această zi. De aceea a fost pus numele acesteia, Galed; ");
INSERT INTO ronbtf_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Şi Miţpa, căci el a spus: DOMNUL să vegheze între mine şi tine, în timp ce suntem absenţi unul faţă de celalalt. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Dacă vei chinui pe fiicele mele, sau dacă vei lua alte soţii pe lângă fiicele mele, niciun bărbat nu este cu noi; vezi, Dumnezeu este martor între mine şi tine. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Şi Laban i-a spus lui Iacob: Iată, această movilă şi, iată, acest stâlp, pe care l-am aruncat între mine şi tine; ");
INSERT INTO ronbtf_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Această movilă fie mărturie şi acest stâlp fie mărturie, că nu voi trece peste această movilă la tine şi că nu vei trece peste această movilă şi peste acest stâlp la mine, pentru a face rău. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Dumnezeul lui Avraam şi Dumnezeul lui Nahor, Dumnezeul Tatălui lor, să judece între noi. Şi Iacob a jurat pe teama tatălui său Isaac. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Atunci Iacob a oferit sacrificii pe munte şi a chemat pe fraţii săi să mănânce pâine şi au mâncat pâine şi au rămas toată noaptea pe munte. ");
INSERT INTO ronbtf_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Şi devreme dimineaţa Laban s-a ridicat şi a sărutat pe fiii săi şi pe fiicele sale şi i-a binecuvântat; şi Laban a plecat şi s-a întors la locul său. ");
INSERT INTO ronbtf_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Şi Iacob a plecat pe calea sa şi l-au întâlnit îngerii lui Dumnezeu. ");
INSERT INTO ronbtf_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Şi când Iacob i-a văzut, a spus: Aceasta este oştirea lui Dumnezeu; şi a pus numele acelui loc, Mahanaim. ");
INSERT INTO ronbtf_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Şi Iacob a trimis mesageri înaintea lui la Esau, fratele său, până în ţara lui Seir, ţinutul lui Edom. ");
INSERT INTO ronbtf_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Şi le-a poruncit, spunând: Astfel să vorbiţi domnului meu Esau: Servitorul tău, Iacob, spune astfel: Eu am locuit temporar cu Laban şi am rămas acolo până acum; ");
INSERT INTO ronbtf_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Şi am boi şi măgari, turme şi servitori şi servitoare; şi am trimis pentru a spune domnului meu, ca să găsesc har înaintea ochilor tăi. ");
INSERT INTO ronbtf_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Şi mesagerii s-au întors la Iacob, spunând: Am mers la fratele tău, Esau; şi de asemenea el vine să te întâlnească şi patru sute de bărbaţi cu el. ");
INSERT INTO ronbtf_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Atunci Iacob a fost grozav de înspăimântat şi tulburat şi a împărţit oamenii care erau cu el şi turmele şi cirezile şi cămilele, în două cete; ");
INSERT INTO ronbtf_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Şi a spus: Dacă Esau vine la una din cete şi o loveşte, atunci cealaltă ceată care rămâne va scăpa. ");
INSERT INTO ronbtf_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Şi Iacob a spus: Dumnezeul tatălui meu Avraam şi Dumnezeul tatălui meu Isaac, DOMNUL care mi-a spus: Întoarce-te în ţara ta şi la rudele tale şi mă voi purta bine cu tine; ");
INSERT INTO ronbtf_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Eu nu sunt demn nici de cea mai mică din toate îndurările şi de tot adevărul pe care l-ai arătat servitorului tău; căci cu toiagul meu am trecut acest Iordan; şi acum eu am devenit două cete. ");
INSERT INTO ronbtf_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Scapă-mă, te rog, din mâna fratelui meu, din mâna lui Esau, pentru că mă tem de el, ca nu cumva să vină şi să mă lovească pe mine şi pe mamă cu copiii. ");
INSERT INTO ronbtf_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Şi ai spus: Cu adevărat îţi voi face bine şi voi face sămânţa ta precum nisipul mării, care nu poate fi numărat din cauza mulţimii lui. ");
INSERT INTO ronbtf_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Şi a rămas acolo în acea noapte; şi a luat din ceea ce îi cădea la mână un dar pentru fratele său, Esau; ");
INSERT INTO ronbtf_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Două sute de capre şi douăzeci de ţapi, două sute de oi şi douăzeci de berbeci, ");
INSERT INTO ronbtf_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Treizeci de cămile de lapte cu mânjii lor, patruzeci de viţele şi zece tauri, douăzeci de măgăriţe şi zece măgăruşi. ");
INSERT INTO ronbtf_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Şi le-a dat în mâna servitorilor săi, fiecare turmă în parte; şi a spus servitorilor săi: Treceţi înaintea mea şi lăsaţi o distanţă între turmă şi turmă. ");
INSERT INTO ronbtf_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Şi a poruncit celui din frunte, spunând: Când Esau, fratele meu, te întâlneşte şi te întreabă, spunând: Al cui eşti tu? Şi încotro mergi? Şi ale cui sunt acestea care merg înaintea ta? ");
INSERT INTO ronbtf_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Atunci spune: Acestea sunt ale servitorului tău Iacob; acesta este un dar trimis domnului meu, Esau; şi, iată, el de asemenea este în spatele nostru. ");
INSERT INTO ronbtf_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Şi aşa a poruncit celui de al doilea şi celui de al treilea şi tuturor celor ce urmau turmelor, spunând: În acest fel vorbiţi-i lui Esau, când îl găsiţi. ");
INSERT INTO ronbtf_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Şi spuneţi mai departe: Iată, servitorul tău, Iacob, este în spatele nostru. Căci a spus: Îl voi linişti cu darul care merge înaintea mea şi după aceea îi voi vedea faţa; poate că îl va accepta de la mine. ");
INSERT INTO ronbtf_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Astfel darul a mers, trecând înaintea lui; şi el însuşi a rămas în acea noapte cu ceata. ");
INSERT INTO ronbtf_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Şi s-a ridicat în acea noapte şi a luat pe cele două soţii ale lui şi pe cele două servitoare ale lui şi pe cei unsprezece fii ai săi şi a trecut peste vadul pârâului Iaboc. ");
INSERT INTO ronbtf_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Şi i-a luat şi i-a trimis peste pârâu şi a trimis dincolo tot ce avea. ");
INSERT INTO ronbtf_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Şi Iacob a fost lăsat singur; şi acolo s-a luptat un bărbat cu el până la răsăritul zilei. ");
INSERT INTO ronbtf_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Iar când a văzut că nu îl învinge, a atins adâncitura coapsei lui; şi adâncitura coapsei lui Iacob a fost scrântită din încheietură, pe când se lupta cu el. ");
INSERT INTO ronbtf_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Şi a spus: Lasă-mă să plec, pentru că ziua răsare. Iar el a spus: Nu te voi lăsa să pleci, decât dacă mă binecuvântezi. ");
INSERT INTO ronbtf_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Iar el i-a spus: Care este numele tău? Şi a spus: Iacob. ");
INSERT INTO ronbtf_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Iar el a spus: Numele tău nu se va mai numi Iacob, ci Israel: căci ca un prinţ ai putere cu Dumnezeu şi cu oamenii şi ai învins. ");
INSERT INTO ronbtf_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Şi Iacob l-a întrebat şi a spus: Spune-mi, te rog, numele tău. Iar el a spus: Pentru ce este aceasta că tu cercetezi după numele meu? Şi l-a binecuvântat acolo. ");
INSERT INTO ronbtf_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Şi Iacob a chemat numele locului, Peniel, pentru că: Am văzut pe Dumnezeu faţă în faţă şi viaţa mea este păstrată. ");
INSERT INTO ronbtf_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Şi în timp ce trecea de Peniel, soarele a răsărit peste Iacob, iar el şchiopăta din coapsa lui. ");
INSERT INTO ronbtf_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","De aceea copiii lui Israel nu mănâncă din tendonul care s-a scurtat, care este peste adâncitura coapsei, până în această zi, pentru că el a atins adâncitura coapsei lui Iacob în tendonul care s-a scurtat. ");
INSERT INTO ronbtf_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Şi Iacob şi-a ridicat ochii şi a privit şi, iată, Esau venea şi cu el veneau patru sute de bărbaţi. Şi a împărţit copiii Leei şi Rahelei şi celor două roabe. ");
INSERT INTO ronbtf_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Şi a pus roabele şi copiii lor în frunte şi pe Leea şi copiii ei după şi pe Rahela şi Iosif ultimii. ");
INSERT INTO ronbtf_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Şi a trecut înaintea lor şi s-a aplecat până la pământ de şapte ori, până când a ajuns aproape de fratele său. ");
INSERT INTO ronbtf_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Şi Esau a alergat să îl întâlnească şi l-a îmbrăţişat şi a căzut la gâtul lui şi l-a sărutat şi au plâns. ");
INSERT INTO ronbtf_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Şi el şi-a ridicat ochii şi a văzut femeile şi copiii şi a spus: Cine sunt aceştia împreună cu tine? Iar el a spus: Copiii pe care Dumnezeu i-a dat cu har servitorului tău. ");
INSERT INTO ronbtf_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Atunci roabele s-au apropiat, ele şi copiii lor, şi s-au prosternat; ");
INSERT INTO ronbtf_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Şi Leea de asemenea cu copiii ei s-a apropiat şi s-au prosternat; şi după aceea s-a apropiat Iosif şi Rahela şi s-au prosternat. ");
INSERT INTO ronbtf_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Iar el a spus: Ce doreşti să spui tu cu toată această mulţime pe care am întâlnit-o? Iar el a spus: Acestea sunt pentru a găsi har înaintea ochilor domnului meu. ");
INSERT INTO ronbtf_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Şi Esau a spus: Eu am destul, fratele meu; ţine ceea ce ai pentru tine. ");
INSERT INTO ronbtf_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Şi Iacob a spus: Nu, te rog, dacă am găsit acum har înaintea ochilor tăi, atunci primeşte darul meu din mâna mea, căci de aceea am văzut faţa ta, ca şi cum aş fi văzut faţa lui Dumnezeu şi ai fost mulţumit de mine. ");
INSERT INTO ronbtf_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ia, te rog, binecuvântarea mea care îţi este adusă, pentru că Dumnezeu m-a tratat cu har şi pentru că am destul. Şi l-a constrâns, iar el l-a luat. ");
INSERT INTO ronbtf_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Şi a spus: Să continuăm călătoria noastră şi să mergem; şi voi merge înaintea ta. ");
INSERT INTO ronbtf_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Iar el i-a spus: Domnul meu ştie că pruncii sunt plăpânzi şi turmele şi cirezile cu pui sunt cu mine; şi dacă oamenii le vor forţa să meargă repede, toată turma va muri într-o zi. ");
INSERT INTO ronbtf_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Domnul meu să treacă, te rog, înaintea servitorului său şi voi conduce cu blândeţe, după cum vitele care merg înaintea mea şi copiii sunt în stare să îndure, până ce ajung la domnul meu în Seir. ");
INSERT INTO ronbtf_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Şi Esau a spus: Să las acum cu tine pe unii dintre oamenii care sunt cu mine. Iar el a spus: Ce nevoie este de aceasta? Lasă-mă să găsesc har înaintea ochilor domnului meu. ");
INSERT INTO ronbtf_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Astfel Esau s-a întors în acea zi pe calea sa în Seir. ");
INSERT INTO ronbtf_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Şi Iacob a călătorit până la Sucot şi şi-a zidit o casă şi a făcut colibe pentru vitele sale, de aceea numele locului este chemat Sucot. ");
INSERT INTO ronbtf_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Şi Iacob a venit la Salem, o cetate din Sihem, care este în ţara lui Canaan, când a venit de la Padanaram; şi a întins cortul său în faţa cetăţii. ");
INSERT INTO ronbtf_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Şi a cumpărat o parcelă dintr-un câmp, unde şi-a întins cortul, la îndemâna copiilor lui Hamor, tatăl lui Sihem, pentru o sută de monede. ");
INSERT INTO ronbtf_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Şi a înălţat acolo un altar şi l-a numit Elelohe-Israel. ");
INSERT INTO ronbtf_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Şi Dina, fiica Leei, pe care i-a născut-o lui Iacob, a ieşit să vadă fiicele ţării. ");
INSERT INTO ronbtf_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Şi când Sihem, fiul lui Hamor, hivitul, prinţ al ţinutului, a văzut-o, a luat-o şi s-a culcat cu ea şi a pângărit-o. ");
INSERT INTO ronbtf_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Şi sufletul lui s-a lipit de Dina, fiica lui Iacob, şi a iubit fata şi a vorbit frumos fetei. ");
INSERT INTO ronbtf_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Şi Sihem i-a vorbit tatălui său, Hamor, spunând: Ia-mi această fată de soţie. ");
INSERT INTO ronbtf_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Şi Iacob a auzit că el a pângărit pe Dina, fiica sa; acum fiii lui erau cu vitele lui în câmp; şi Iacob a tăcut până ce au venit. ");
INSERT INTO ronbtf_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Şi Hamor, tatăl lui Sihem, a ieşit la Iacob să vorbească îndeaproape cu el. ");
INSERT INTO ronbtf_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Şi fiii lui Iacob au venit din câmp după ce au auzit aceasta şi bărbaţii erau îndureraţi şi s-au înfuriat, deoarece el lucrase prosteşte în Israel, culcându-se cu fiica lui Iacob, lucru care nu trebuia făcut. ");
INSERT INTO ronbtf_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Şi Hamor a vorbit îndeaproape cu ei, spunând: Sufletul fiului meu Sihem tânjeşte după fiica voastră. Vă rog daţi-o lui de soţie. ");
INSERT INTO ronbtf_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Şi încuscriţi-vă cu noi şi daţi-ne fiicele voastre şi luaţi pe fiicele noastre pentru voi. ");
INSERT INTO ronbtf_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Şi veţi locui cu noi şi ţara va fi înaintea voastră; locuiţi şi faceţi comerţ în ea şi dobândiţi-vă stăpâniri în ea. ");
INSERT INTO ronbtf_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Şi Sihem a spus tatălui ei şi fraţilor ei: Să găsesc har în ochii voştri şi ce îmi veţi spune vă voi da. ");
INSERT INTO ronbtf_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Cereţi de la mine zestre mare şi dar şi voi da conform cu ceea ce îmi veţi spune, dar daţi-mi fata de soţie. ");
INSERT INTO ronbtf_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Şi fiii lui Iacob au răspuns lui Sihem şi Hamor, tatăl lui, în mod înşelător şi au spus, deoarece el o pângărise pe Dina sora lor, ");
INSERT INTO ronbtf_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Şi le-au spus: Nu putem face acest lucru, să dăm pe sora noastră unui necircumcis; căci aceasta ar fi ocară pentru noi; ");
INSERT INTO ronbtf_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Dar în aceasta vă vom da acordul: dacă voi veţi fi precum suntem noi, ca fiecare parte bărbătească dintre voi să fie circumcis; ");
INSERT INTO ronbtf_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Atunci vi le vom da pe fiicele noastre şi le vom lua pe fiicele voastre pentru noi şi vom locui cu voi şi vom deveni un singur popor. ");
INSERT INTO ronbtf_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Dar dacă nu ne veţi da ascultare, pentru a fi circumcişi, atunci o vom lua pe fiica noastră şi vom pleca. ");
INSERT INTO ronbtf_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Şi cuvintele lor au plăcut lui Hamor şi lui Sihem, fiul lui Hamor. ");
INSERT INTO ronbtf_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Şi tânărul nu a întârziat să facă aceasta, deoarece a avut desfătare în fiica lui Iacob şi el era demn de mai multă cinste decât toată casa tatălui său. ");
INSERT INTO ronbtf_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Şi Hamor şi Sihem, fiul lui, au venit la poarta cetăţii lor şi au vorbit îndeaproape cu oamenii cetăţii lor, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Aceşti oameni sunt paşnici cu noi; de aceea lăsaţi-i să locuiască în ţară şi să facă comerţ în ea, pentru că ţara, iată, este destul de mare şi pentru ei; să luăm pe fiicele lor de soţii pentru noi şi să le dăm pe fiicele noastre. ");
INSERT INTO ronbtf_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Doar prin aceasta ne vor da acordul bărbaţii pentru a locui cu noi, pentru a fi un singur popor, dacă fiecare parte bărbătească între noi ar fi circumcisă, precum sunt ei circumcişi. ");
INSERT INTO ronbtf_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Nu vor fi turmele lor şi averea lor şi fiecare vită a lor, ale noastre? Doar să le dăm acordul şi vor locui cu noi. ");
INSERT INTO ronbtf_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Şi lui Hamor şi lui Sihem, fiul lui, au dat ascultare toţi cei care ieşeau pe poarta cetăţii sale; şi fiecare parte bărbătească a fost circumcisă, toţi cei care au ieşit pe poarta cetăţii sale. ");
INSERT INTO ronbtf_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Şi s-a întâmplat în a treia zi, când erau în dureri, că doi dintre fiii lui Iacob, Simeon şi Levi, fraţii Dinei, şi-a luat fiecare bărbat sabia şi au venit peste cetate în mod cutezător şi au ucis toată partea bărbătească. ");
INSERT INTO ronbtf_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Şi au ucis pe Hamor şi pe Sihem, fiul lui, cu tăişul sabiei şi au luat pe Dina din casa lui Sihem şi au ieşit. ");
INSERT INTO ronbtf_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Fiii lui Iacob au venit peste cei ucişi şi au prădat cetatea, din cauză că au pângărit pe sora lor. ");
INSERT INTO ronbtf_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ei le-au luat oile şi boii lor şi măgarii lor şi ceea ce era în cetate şi ceea ce era în câmp. ");
INSERT INTO ronbtf_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Şi toată averea lor şi pe toţi micuţii lor şi pe soţiile lor i-au luat captivi şi au prădat de asemenea tot ce era în casă. ");
INSERT INTO ronbtf_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Şi Iacob le-a spus lui Simeon şi lui Levi: Voi m-aţi tulburat să mă faceţi să put printre locuitorii ţării, printre canaaniţi şi periziţi; şi eu, fiind mic la număr, se vor aduna împreună împotriva mea şi mă vor ucide; şi voi fi nimicit, eu şi casa mea. ");
INSERT INTO ronbtf_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Iar ei au spus: Trebuia să se poarte el cu sora noastră precum cu o curvă? ");
INSERT INTO ronbtf_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Şi Dumnezeu i-a spus lui Iacob: Ridică-te, urcă la Betel şi locuieşte acolo şi fă acolo un altar lui Dumnezeu, care ţi s-a arătat când fugeai din faţa lui Esau, fratele tău. ");
INSERT INTO ronbtf_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Atunci Iacob a spus casei lui şi tuturor celor care erau cu el: Puneţi deoparte dumnezeii străini care sunt printre voi şi curăţiţi-vă şi schimbaţi-vă hainele; ");
INSERT INTO ronbtf_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Şi să ne ridicăm şi să urcăm la Betel; şi voi face acolo un altar lui Dumnezeu, care mi-a răspuns în ziua strâmtorării mele şi a fost cu mine în calea pe care am mers. ");
INSERT INTO ronbtf_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Şi i-au dat lui Iacob toţi dumnezeii străini care erau în mâna lor şi toţi cerceii care erau în urechile lor; şi Iacob le-a ascuns sub stejarul care era lângă Sihem. ");
INSERT INTO ronbtf_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Şi au călătorit şi teroarea lui Dumnezeu era asupra cetăţilor care erau împrejurul lor şi nu i-au urmărit pe fiii lui Iacob. ");
INSERT INTO ronbtf_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Astfel Iacob a venit la Luz, adică Betel, care este în ţara lui Canaan, el şi toţi oamenii care erau cu el. ");
INSERT INTO ronbtf_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Şi a zidit acolo un altar şi a pus numele acelui loc El-betel, deoarece acolo Dumnezeu i s-a arătat când fugea din faţa fratelui său. ");
INSERT INTO ronbtf_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Dar Debora, dădaca Rebecăi, a murit şi a fost îngropată la poalele Betelului, sub un stejar; şi acestuia i s-a pus numele Alon-Bacut. ");
INSERT INTO ronbtf_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Şi Dumnezeu i s-a arătat lui Iacob din nou, când a ieşit din Padanaram, şi l-a binecuvântat. ");
INSERT INTO ronbtf_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Şi Dumnezeu i-a spus: Numele tău este Iacob, numele tău nu va mai fi chemat Iacob, ci Israel va fi numele tău; şi i-a pus numele Israel. ");
INSERT INTO ronbtf_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Şi Dumnezeu i-a spus: Eu sunt Dumnezeul cel Atotputernic, fii roditor şi înmulţeşte-te; o naţiune şi o mulţime de naţiuni vor fi din tine şi împăraţi vor ieşi din coapsele tale; ");
INSERT INTO ronbtf_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Şi pământul pe care l-am dat lui Avraam şi Isaac, ţie ţi-l voi da şi seminţei tale după tine îi voi da pământul. ");
INSERT INTO ronbtf_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Şi Dumnezeu s-a înălţat de la el în locul în care a vorbit cu el. ");
INSERT INTO ronbtf_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Şi Iacob a pus un stâlp în locul în care a vorbit cu el, un stâlp de piatră, şi a turnat un dar de băutură pe acesta şi a turnat untdelemn pe acesta. ");
INSERT INTO ronbtf_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Şi Iacob a pus numele locului unde Dumnezeu a vorbit cu el, Betel. ");
INSERT INTO ronbtf_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Şi au plecat de la Betel; şi mai era doar puţin drum până să ajungă la Efrata; şi Rahela a intrat în durerile naşterii şi avea travaliu greu. ");
INSERT INTO ronbtf_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Şi s-a întâmplat, când era în travaliu greu, că moaşa i-a spus: Nu te teme; vei avea şi acest fiu. ");
INSERT INTO ronbtf_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Şi s-a întâmplat, pe când sufletul ei se îndepărta, (pentru că a murit) că i-a pus numele Benoni; dar tatăl lui i-a pus numele, Beniamin. ");
INSERT INTO ronbtf_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Şi Rahela a murit şi a fost îngropată pe calea spre Efrata, adică Betleem. ");
INSERT INTO ronbtf_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Şi Iacob a aşezat un stâlp peste mormântul ei, care este stâlpul mormântului Rahelei până în această zi. ");
INSERT INTO ronbtf_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Şi Israel a plecat şi şi-a întins cortul dincolo de turnul din Edar. ");
INSERT INTO ronbtf_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Şi s-a întâmplat, pe când Israel locuia în acea ţară, că Ruben a mers şi s-a culcat cu Bilha, concubina tatălui său; şi Israel a auzit aceasta. Acum fiii lui Iacob erau doisprezece; ");
INSERT INTO ronbtf_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Fiii Leei: Ruben, întâiul născut al lui Iacob şi Simeon şi Levi şi Iuda şi Isahar şi Zabulon; ");
INSERT INTO ronbtf_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Fiii Rahelei: Iosif şi Beniamin; ");
INSERT INTO ronbtf_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Şi fiii Bilhei, roaba Rahelei: Dan şi Neftali; ");
INSERT INTO ronbtf_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Şi fiii Zilpei, roaba Leei: Gad şi Aşer; aceştia sunt fiii lui Iacob, care i s-au născut în Padanaram. ");
INSERT INTO ronbtf_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Şi Iacob a venit la Isaac, tatăl său, la Mamre, în cetatea Arba, adică Hebron, unde Avraam şi Isaac au locuit temporar. ");
INSERT INTO ronbtf_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Şi zilele lui Isaac erau o sută optzeci de ani. ");
INSERT INTO ronbtf_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Şi Isaac şi-a dat duhul şi a murit şi a fost adunat la poporul său, fiind bătrân şi plin de zile; şi fiii săi, Esau şi Iacob, l-au îngropat. ");
INSERT INTO ronbtf_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Acum acestea sunt generaţiile lui Esau, care este Edom. ");
INSERT INTO ronbtf_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau şi-a luat soţiile lui dintre fiicele lui Canaan: Ada, fiica lui Elon hititul, şi Oholibama, fiica Anei, fiica lui Ţibeon hivitul. ");
INSERT INTO ronbtf_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Şi Basmat, fiica lui Ismael, sora lui Nebaiot. ");
INSERT INTO ronbtf_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Şi Ada i-a născut lui Esau pe Elifaz; şi Basmat a născut pe Reuel; ");
INSERT INTO ronbtf_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Şi Oholibama a născut pe Ieuş şi Iaalam şi Core; aceştia sunt fiii lui Esau, care i s-au născut în ţara lui Canaan. ");
INSERT INTO ronbtf_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Şi Esau şi-a luat soţiile şi fiii lui şi fiicele lui şi toate persoanele din casa lui şi vitele lui şi toate animalele lui şi toată averea lui pe care a dobândit-o în ţara lui Canaan; şi a plecat într-un alt ţinut din faţa fratelui său, Iacob. ");
INSERT INTO ronbtf_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Fiindcă bogăţiile lor erau prea mari ca ei să poată locui împreună; şi ţara în care ei erau străini nu putea să îi ţină din cauza vitelor lor. ");
INSERT INTO ronbtf_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Astfel a locuit Esau în muntele Seir; Esau este Edom. ");
INSERT INTO ronbtf_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Şi acestea sunt generaţiile lui Esau, tatăl Edomiţilor, în muntele Seir, ");
INSERT INTO ronbtf_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Şi acestea sunt numele fiilor lui Esau: Elifaz, fiul Adei, soţia lui Esau; Reuel, fiul lui Basmat, soţia lui Esau. ");
INSERT INTO ronbtf_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Şi fiii lui Elifaz au fost: Teman, Omar, Ţefo şi Gatam şi Chenaz. ");
INSERT INTO ronbtf_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Şi Timna era concubina lui Elifaz, fiul lui Esau; şi i-a născut lui Elifaz pe Amalec; aceştia au fost fiii Adei, soţia lui Esau. ");
INSERT INTO ronbtf_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Şi aceştia sunt fiii lui Reuel: Nahat şi Zerah, Şama şi Miza; aceştia au fost fiii lui Basmat, soţia lui Esau. ");
INSERT INTO ronbtf_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Şi aceştia au fost fiii Oholibamei, fiica Anei, fiica lui Ţibeon, soţia lui Esau; şi i-a născut lui Esau, pe Ieuş şi Iaalam şi Core. ");
INSERT INTO ronbtf_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Aceştia au fost conducătorii fiilor lui Esau: fiii lui Elifaz, întâiul născut fiu al lui Esau, conducătorul Teman, conducătorul Omar, conducătorul Ţefo, conducătorul Chenaz, ");
INSERT INTO ronbtf_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Conducătorul Core, conducătorul Gatam şi conducătorul Amalec; aceştia sunt conducătorii care au ieşit din Elifaz în ţara lui Edom; aceştia au fost fiii Adei. ");
INSERT INTO ronbtf_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Şi aceştia sunt fiii lui Reuel, fiul lui Esau; conducătorul Nahat, conducătorul Zerah, conducătorul Şama, conducătorul Miza; aceştia sunt conducătorii care au ieşit din Reuel în ţara lui Edom; aceştia sunt fiii lui Basmat, soţia lui Esau. ");
INSERT INTO ronbtf_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Şi aceştia sunt fiii Oholibamei, soţia lui Esau, conducătorul Ieuş, conducătorul Iaalam, conducătorul Core; aceştia au fost conducătorii care au ieşit din Oholibama, fiica Anei, soţia lui Esau. ");
INSERT INTO ronbtf_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Aceştia sunt fiii lui Esau, care este Edom, şi aceştia sunt conducătorii lor. ");
INSERT INTO ronbtf_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Aceştia sunt fiii lui Seir horitul, care au locuit ţara: Lotan şi Şobal şi Ţibeon şi Ana, ");
INSERT INTO ronbtf_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Şi Dişon şi Eţer şi Dişan; aceştia sunt conducătorii horiţilor, copiii lui Seir în ţara lui Edom. ");
INSERT INTO ronbtf_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Şi copiii lui Lotan au fost Hori şi Hemam; şi sora lui Lotan a fost Timna. ");
INSERT INTO ronbtf_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Şi copiii lui Şobal au fost aceştia: Alvan şi Manahat şi Ebal, Şefo şi Onam. ");
INSERT INTO ronbtf_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Şi aceştia sunt copiii lui Ţibeon: deopotrivă Aia şi Ana; acesta a fost acel Ana care a găsit catârii în pustie, pe când hrănea măgarii lui Ţibeon, tatăl său. ");
INSERT INTO ronbtf_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Şi copiii lui Ana au fost aceştia: Dişon şi Oholibama, fiica Anei. ");
INSERT INTO ronbtf_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Şi aceştia sunt copiii lui Dişon: Hemdan şi Eşban şi Itran şi Cheran. ");
INSERT INTO ronbtf_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Copiii lui Eţer sunt aceştia: Bilhan şi Zaavan şi Acan. ");
INSERT INTO ronbtf_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Copiii lui Dişan sunt aceştia: Uz şi Aran. ");
INSERT INTO ronbtf_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Aceştia sunt conducătorii care au ieşit din horiţi: conducătorul Lotan, conducătorul Şobal, conducătorul Ţibeon, conducătorul Ana, ");
INSERT INTO ronbtf_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Conducătorul Dişon, conducătorul Eţer, conducătorul Dişan; aceştia sunt conducătorii care au ieşit din Hori, printre conducătorii lor în ţara lui Seir. ");
INSERT INTO ronbtf_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Şi aceştia sunt împăraţii care au domnit în ţara lui Edom, înainte să domnească vreun împărat peste copiii lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Şi Bela, fiul lui Beor, a domnit în Edom; şi numele cetăţii lui a fost Dinhaba. ");
INSERT INTO ronbtf_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Şi Bela a murit; şi Iobab, fiul lui Zerah al lui Boţra, a domnit în locul lui. ");
INSERT INTO ronbtf_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Şi Iobab a murit; şi Huşam, din ţara lui Temani, a domnit în locul lui. ");
INSERT INTO ronbtf_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Şi Huşam a murit; şi Hadad, fiul lui Bedad, care a lovit pe Madian în câmpul lui Moab, a domnit în locul lui; şi numele cetăţii lui a fost Avit. ");
INSERT INTO ronbtf_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Şi Hadad a murit; şi Samla, din Masreca, a domnit în locul lui. ");
INSERT INTO ronbtf_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Şi Samla a murit; şi Saul, din Rehobot, de lângă râu, a domnit în locul lui. ");
INSERT INTO ronbtf_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Şi Saul a murit; şi Baal-Hanan, fiul lui Ahbor, a domnit în locul lui. ");
INSERT INTO ronbtf_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Şi Baal-Hanan, fiul lui Ahbor, a murit; şi Hadar a domnit în locul lui şi numele cetăţii lui a fost Pau; şi numele soţiei lui a fost Mehetabeel, fiica lui Matred, fiica lui Mezahab. ");
INSERT INTO ronbtf_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Şi acestea sunt numele conducătorilor care au ieşit din Esau, conform cu familiile lor, după locurile lor, pe numele lor: conducătorul Timna, conducătorul Alva, conducătorul Iete, ");
INSERT INTO ronbtf_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Conducătorul Oholibama, conducătorul Ela, conducătorul Pinon, ");
INSERT INTO ronbtf_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Conducătorul Chenaz, conducătorul Teman, conducătorul Mibţar, ");
INSERT INTO ronbtf_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Conducătorul Magdiel, conducătorul Iram; aceştia sunt conducătorii lui Edom, conform cu locuinţele lor în ţara stăpânirii lor; el este Esau, tatăl edomiţilor. ");
INSERT INTO ronbtf_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Şi Iacob a locuit în ţara în care tatăl său a fost străin, în ţara lui Canaan. ");
INSERT INTO ronbtf_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Acestea sunt generaţiile lui Iacob. Iosif, fiind în vârstă de şaptesprezece ani, păştea turma cu fraţii săi; şi băiatul era cu fiii Bilhei şi cu fiii Zilpei, soţiile tatălui său; şi Iosif a adus tatălui său vorbirea lor rea. ");
INSERT INTO ronbtf_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Acum Israel iubea pe Iosif mai mult decât pe toţi copiii lui, deoarece el era fiul bătrâneţii sale; şi i-a făcut o haină pestriţă. ");
INSERT INTO ronbtf_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Şi când fraţii lui au văzut că tatăl lor îl iubea mai mult decât pe toţi fraţii săi, l-au urât şi nu puteau să îi vorbească paşnic. ");
INSERT INTO ronbtf_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Şi Iosif a visat un vis şi l-a spus fraţilor săi şi ei l-au urât încă şi mai mult. ");
INSERT INTO ronbtf_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Şi le-a spus: Ascultaţi, vă rog, acest vis pe care l-am visat: ");
INSERT INTO ronbtf_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Şi, iată, noi legam snopi în câmp şi, iată, snopul meu s-a ridicat şi a stat chiar drept în picioare; şi, iată, snopii voştri au stat de jur împrejur şi se prosternau snopului meu. ");
INSERT INTO ronbtf_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Şi fraţii lui i-au spus: Vei domni într-adevăr peste noi? Sau vei avea într-adevăr stăpânire peste noi? Şi l-au urât încă şi mai mult pentru visele lui şi pentru cuvintele lui. ");
INSERT INTO ronbtf_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Şi a visat încă un vis şi l-a spus fraţilor săi şi a zis: Iată, am visat încă un vis; şi, iată, soarele şi luna şi unsprezece stele mi s-au prosternat. ");
INSERT INTO ronbtf_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Şi l-a spus tatălui său şi fraţilor săi şi tatăl său l-a mustrat şi i-a zis: Ce este acest vis pe care l-ai visat? Vom veni eu şi mama ta şi fraţii tăi, într-adevăr, să ne prosternăm ţie până la pământ? ");
INSERT INTO ronbtf_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Şi fraţii lui l-au invidiat, dar tatăl său a dat atenţie acestei spuse. ");
INSERT INTO ronbtf_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Şi fraţii lui au mers să pască turma tatălui lor în Sihem. ");
INSERT INTO ronbtf_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Şi Israel i-a spus lui Iosif: Nu pasc fraţii tăi turma în Sihem? Vino şi te voi trimite la ei. Iar el i-a spus: Iată-mă. ");
INSERT INTO ronbtf_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Iar el i-a spus: Du-te, te rog, să vezi dacă este bine cu fraţii tăi şi bine cu turmele; şi adu-mi cuvânt înapoi. Astfel l-a trimis din valea Hebronului şi a venit la Sihem. ");
INSERT INTO ronbtf_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Şi un anumit bărbat l-a găsit şi, iată, el rătăcea în câmp; şi bărbatul l-a întrebat, spunând: Ce cauţi? ");
INSERT INTO ronbtf_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Iar el a spus: Caut pe fraţii mei; spune-mi te rog, unde îşi pasc ei turmele. ");
INSERT INTO ronbtf_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Şi bărbatul a spus: Au plecat deja de aici; fiindcă i-am auzit spunând: Să mergem la Dotan. Şi Iosif a mers după fraţii săi şi i-a găsit la Dotan. ");
INSERT INTO ronbtf_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Şi când l-au văzut de departe, chiar înainte ca el să se apropie de ei, au uneltit împotriva lui să îl ucidă. ");
INSERT INTO ronbtf_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Şi au spus unul altuia: Iată, vine acest visător. ");
INSERT INTO ronbtf_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Şi acum, aşadar, veniţi să îl ucidem şi să îl aruncăm în vreo groapă şi vom spune: Ceva fiară rea l-a mâncat; şi vom vedea ce vor deveni visele lui. ");
INSERT INTO ronbtf_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Şi Ruben a auzit aceasta şi l-a scăpat din mâinile lor; şi a spus: Să nu îl ucidem. ");
INSERT INTO ronbtf_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Şi Ruben le-a spus: Nu vărsaţi sânge, ci aruncaţi-l în această groapă care este în pustie şi nu puneţi mâna pe el; ca să îl scape din mâinile lor, să îl predea tatălui său din nou. ");
INSERT INTO ronbtf_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Şi s-a întâmplat, când Iosif a ajuns la fraţii săi, că l-au dezbrăcat pe Iosif de haina lui, haina pestriţă care era pe el; ");
INSERT INTO ronbtf_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Şi l-au luat şi l-au aruncat într-o groapă; şi groapa era goală, nu era apă în ea. ");
INSERT INTO ronbtf_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Şi au şezut să mănânce pâine şi şi-au ridicat ochii şi au privit şi, iată, o ceată de ismaeliţi a venit din Galaad cu cămilele lor, purtând mirodenii şi balsam şi smirnă, mergând să le coboare în Egipt. ");
INSERT INTO ronbtf_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Şi Iuda a spus fraţilor săi: Ce folos este dacă ucidem pe fratele nostru şi ascundem sângele lui? ");
INSERT INTO ronbtf_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Veniţi şi să îl vindem ismaeliţilor şi să nu lăsăm mâna noastră să fie asupra lui, pentru că el este fratele nostru şi carnea noastră. Şi fraţii lui au fost mulţumiţi. ");
INSERT INTO ronbtf_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Atunci au trecut pe acolo negustori madianiţi; şi au tras şi au scos pe Iosif din groapă şi au vândut pe Iosif ismaeliţilor pentru douăzeci de arginţi; iar ei au dus pe Iosif în Egipt. ");
INSERT INTO ronbtf_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Şi Ruben s-a întors la groapă; şi, iată, Iosif nu era în groapă; şi el şi-a rupt hainele. ");
INSERT INTO ronbtf_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Şi s-a întors la fraţii săi şi a spus: Copilul nu mai este; iar eu, încotro voi merge? ");
INSERT INTO ronbtf_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Şi au luat haina lui Iosif şi au înjunghiat un ied dintre capre şi au înmuiat haina în sânge; ");
INSERT INTO ronbtf_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Şi au trimis haina pestriţă şi au adus-o la tatăl lor; şi au spus: Noi am găsit aceasta, cercetează acum dacă este haina fiului tău sau nu. ");
INSERT INTO ronbtf_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Şi a cercetat-o şi a spus: Aceasta este haina fiului meu; o fiară rea l-a mâncat; Iosif este fără îndoială rupt în bucăţi. ");
INSERT INTO ronbtf_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Şi Iacob şi-a rupt hainele şi a pus pânză de sac peste coapsele lui şi a jelit pentru fiul său multe zile. ");
INSERT INTO ronbtf_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Şi toţi fiii lui şi toate fiicele lui s-au ridicat să îl mângâie; dar el a refuzat să fie mângâiat; şi a spus: Jelind voi coborî în mormânt la fiul meu. Astfel a plâns tatăl său pentru el. ");
INSERT INTO ronbtf_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Şi madianiţii l-au vândut în Egipt lui Potifar, un ofiţer al lui Faraon şi căpetenia gărzii. ");
INSERT INTO ronbtf_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Şi s-a întâmplat în acel timp, că Iuda a coborât de la fraţii săi şi s-a abătut pe la un anumit adulamit, al cărui nume era Hira. ");
INSERT INTO ronbtf_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Şi Iuda a văzut acolo o fiică a unui anumit canaanit, al cărui nume era Şua; şi a luat-o şi a intrat la ea. ");
INSERT INTO ronbtf_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Şi ea a rămas însărcinată şi a născut un fiu; şi el i-a pus numele Er. ");
INSERT INTO ronbtf_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Şi ea a rămas însărcinată din nou şi a născut un fiu; şi ea i-a pus numele Onan. ");
INSERT INTO ronbtf_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Şi ea a rămas însărcinată încă odată şi a născut un fiu; şi i-a pus numele Şela; şi el era la Chezib când ea l-a născut. ");
INSERT INTO ronbtf_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Şi Iuda a luat o soţie pentru Er, întâiul lui născut, al cărei nume era Tamar. ");
INSERT INTO ronbtf_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Şi Er, întâiul născut al lui Iuda, era stricat înaintea ochilor Domnului; şi Domnul l-a ucis. ");
INSERT INTO ronbtf_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Şi Iuda i-a spus lui Onan: Intră la soţia fratelui tău şi căsătoreşte-te cu ea şi ridică sămânţă fratelui tău. ");
INSERT INTO ronbtf_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Şi Onan a ştiut că sămânţa nu va fi a lui; şi s-a întâmplat, când intra la soţia fratelui său, că vărsa sămânţa pe pământ ca nu cumva să dea sămânţă fratelui său. ");
INSERT INTO ronbtf_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Şi lucrul pe care l-a făcut nu a plăcut Domnului. De aceea l-a ucis şi pe el. ");
INSERT INTO ronbtf_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Atunci Iuda a spus lui Tamar, nora lui: Rămâi văduvă la casa tatălui tău, până Şela, fiul meu, va creşte; fiindcă zicea: Nu cumva să moară şi el ca fraţii săi. Şi Tamar a mers şi a locuit în casa tatălui ei. ");
INSERT INTO ronbtf_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Şi după un timp, fiica lui Şua, soţia lui Iuda a murit; şi Iuda a fost mângâiat şi a urcat la Timnat la tunzătorii lui de oi, el, şi prietenul său, Hira adulamitul. ");
INSERT INTO ronbtf_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Şi i s-a spus lui Tamar, zicând: Iată, socrul tău urcă la Timnat să îşi tundă oile. ");
INSERT INTO ronbtf_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Şi ea şi-a dat jos hainele de văduvă de pe ea şi s-a acoperit cu un văl şi s-a înfăşurat şi a stat jos într-un loc deschis, care este pe lângă calea spre Timnat, pentru că ea a văzut că Şela crescuse, iar ea nu i-a fost dată de soţie. ");
INSERT INTO ronbtf_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Când Iuda a văzut-o, a crezut că ea era o curvă, pentru că îşi acoperise faţa. ");
INSERT INTO ronbtf_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Şi el s-a abătut la ea de pe cale şi a spus: Lasă-mă, te rog, să intru la tine; (pentru că nu a ştiut că ea era nora lui.) Iar ea a spus: Ce îmi vei da, ca să intri la mine? ");
INSERT INTO ronbtf_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Iar el a spus: Îţi voi trimite un ied din turmă. Iar ea a spus: Îmi vei da o garanţie, până îl trimiţi? ");
INSERT INTO ronbtf_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Iar el a spus: Ce garanţie să îţi dau? Iar ea a spus: Sigiliul tău şi brăţările tale şi toiagul tău din mâna ta. Şi el i le-a dat şi a intrat la ea şi ea a rămas însărcinată de la el. ");
INSERT INTO ronbtf_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Şi ea s-a ridicat şi a plecat şi a pus deoparte vălul de pe ea şi a îmbrăcat hainele văduviei ei. ");
INSERT INTO ronbtf_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Şi Iuda a trimis iedul prin mâna prietenului său, adulamitul, ca să primească garanţia lui din mâna femeii; dar nu a găsit-o. ");
INSERT INTO ronbtf_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Atunci el a întrebat bărbaţii acelui loc, spunând: Unde este curva, care era la vedere pe marginea drumului? Iar ei au spus: Nu a fost nicio curvă în acest loc. ");
INSERT INTO ronbtf_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Şi el s-a întors la Iuda şi a spus: Nu o pot găsi; şi de asemenea oamenii locului au spus că nu era nicio curvă în acel loc. ");
INSERT INTO ronbtf_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Şi Iuda a spus: Să o ţină, ca nu cumva să fim ruşinaţi; iată, eu am trimis acest ied şi nu ai găsit-o. ");
INSERT INTO ronbtf_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Şi s-a întâmplat cam după trei luni, că i s-a spus lui Iuda, zicând: Tamar, nora ta, a făcut pe curva; şi de asemenea, iată, ea este însărcinată prin curvie. Şi Iuda a spus: Aduceţi-o aici şi să fie arsă. ");
INSERT INTO ronbtf_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Când ea a fost adusă, ea a trimis la socrul ei, spunând: Prin bărbatul, ale căruia sunt acestea, sunt însărcinată; şi a spus: Cercetează, te rog, ale cui sunt acestea: sigiliul şi brăţările şi toiagul. ");
INSERT INTO ronbtf_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Şi Iuda le-a recunoscut şi a spus: Ea a fost mai dreaptă decât mine; deoarece nu i l-am dat pe Şela, fiul meu. Şi el nu a mai cunoscut-o vreodată. ");
INSERT INTO ronbtf_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Şi s-a întâmplat în timpul travaliului ei, că, iată, gemeni erau în pântecele ei. ");
INSERT INTO ronbtf_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Şi s-a întâmplat, când era în travaliu, că unul şi-a scos mâna; şi moaşa a luat şi i-a legat de mână o aţă stacojie, spunând: Acesta a ieşit afară primul. ");
INSERT INTO ronbtf_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Şi s-a întâmplat, în timp ce şi-a tras înapoi mâna, că, iată, fratele lui a ieşit afară; şi ea a spus: Cum ai ieşit afară? Această spărtură să fie asupra ta; de aceea i-au pus numele Pereţ. ");
INSERT INTO ronbtf_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Şi după aceasta a ieşit afară fratele lui, care avea aţa stacojie la mâna lui; şi i-au pus numele Zerah. ");
INSERT INTO ronbtf_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Şi Iosif a fost coborât în Egipt; şi Potifar, un ofiţer al lui Faraon, căpetenia gărzii, un egiptean, l-a cumpărat din mâinile ismaeliţilor, care îl coborâseră acolo. ");
INSERT INTO ronbtf_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Şi DOMNUL era cu Iosif şi el era un bărbat prosper; şi era în casa stăpânului său, egipteanul. ");
INSERT INTO ronbtf_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Şi stăpânul său a văzut că DOMNUL era cu el şi că DOMNUL făcea să prospere în mâna lui tot ceea ce făcea. ");
INSERT INTO ronbtf_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Şi Iosif a găsit har înaintea ochilor lui şi l-a servit; iar el l-a făcut supraveghetor peste casa lui şi tot ce avea a pus în mâna lui. ");
INSERT INTO ronbtf_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Şi s-a întâmplat, din momentul în care l-a făcut supraveghetor în casa lui şi peste tot ce avea, că DOMNUL a binecuvântat casa egipteanului din cauza lui Iosif; şi binecuvântarea DOMNULUI era peste tot ce avea în casă şi în câmp. ");
INSERT INTO ronbtf_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Şi a lăsat tot ce avea în mâna lui Iosif; şi nu ştia ce avea, în afară de pâinea pe care o mânca. Iar Iosif era frumos la statură şi plăcut la vedere. ");
INSERT INTO ronbtf_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Şi s-a întâmplat, după aceste lucruri că soţia stăpânului său şi-a aruncat ochii pe Iosif; şi ea a spus: Culcă-te cu mine. ");
INSERT INTO ronbtf_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Dar el a refuzat şi a spus soţiei stăpânului său: Iată, pe stăpânul meu nu îl interesează ce este cu mine în casă şi a încredinţat în mâna mea tot ce are; ");
INSERT INTO ronbtf_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Nu este nimeni mai mare în această casă decât mine; nici nu mi-a oprit nimic decât pe tine, deoarece tu eşti soţia lui; cum atunci să pot eu face această mare răutate şi să păcătuiesc împotriva lui Dumnezeu? ");
INSERT INTO ronbtf_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Şi s-a întâmplat, cum vorbea cu Iosif zi de zi, că el nu i-a dat ascultare să se culce lângă ea, sau să fie cu ea. ");
INSERT INTO ronbtf_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Şi s-a întâmplat, cam în acest timp, că Iosif a intrat în casă să îşi facă lucrul; şi niciunul dintre bărbaţii casei nu era acolo în casă. ");
INSERT INTO ronbtf_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Iar ea l-a prins de haină, spunând: Culcă-te cu mine; iar el şi-a lăsat haina în mâna ei şi a fugit şi a ieşit afară. ");
INSERT INTO ronbtf_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Şi s-a întâmplat, când a văzut ea că el şi-a lăsat haina în mâna ei şi a fugit afară, ");
INSERT INTO ronbtf_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","Că a chemat bărbaţii din casa ei şi le-a vorbit, spunând: Vedeţi, el a adus un evreu la noi ca să ne batjocorească; el a intrat la mine să se culce cu mine şi eu am strigat cu voce tare. ");
INSERT INTO ronbtf_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Şi s-a întâmplat, când el a auzit că am ridicat vocea şi am strigat, că şi-a lăsat haina cu mine şi a fugit şi a ieşit afară. ");
INSERT INTO ronbtf_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Şi a aşezat haina lui lângă ea, până când domnul lui a venit acasă. ");
INSERT INTO ronbtf_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Şi a vorbit cu el conform acestor cuvinte, spunând: Servitorul evreu, pe care l-ai adus la noi, a intrat la mine să mă batjocorească. ");
INSERT INTO ronbtf_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Şi s-a întâmplat, pe când mi-am ridicat vocea şi am strigat, că şi-a lăsat haina cu mine şi a fugit afară. ");
INSERT INTO ronbtf_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Şi s-a întâmplat, când stăpânul lui a auzit cuvintele soţiei sale, pe care ea i le-a vorbit, spunând: Astfel mi-a făcut servitorul tău; că furia lui s-a aprins. ");
INSERT INTO ronbtf_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Şi stăpânul lui Iosif l-a luat şi l-a pus în închisoare, un loc unde prizonierii împăratului erau legaţi; iar el era acolo în închisoare. ");
INSERT INTO ronbtf_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Dar DOMNUL era cu Iosif şi i-a arătat milă şi i-a dat favoare înaintea ochilor administratorului închisorii. ");
INSERT INTO ronbtf_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Şi administratorul închisorii a încredinţat în mâna lui Iosif pe toţi prizonierii care erau în închisoare; şi tot ce făceau ei acolo, el era cel ce le făcea. ");
INSERT INTO ronbtf_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Administratorul închisorii nu se uita la nimic din ce era sub mâna lui, pentru că DOMNUL era cu el şi ceea ce el făcea, DOMNUL făcea să prospere. ");
INSERT INTO ronbtf_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Şi s-a întâmplat după aceste lucruri, că paharnicul împăratului Egiptului şi brutarul său au ofensat pe domnul lor, împăratul Egiptului. ");
INSERT INTO ronbtf_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Şi Faraon s-a înfuriat împotriva a doi dintre ofiţerii săi, împotriva mai marelui paharnicilor şi împotriva mai marelui brutarilor. ");
INSERT INTO ronbtf_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Şi i-a pus sub pază în casa căpeteniei gărzii, în închisoare, în locul unde Iosif era legat. ");
INSERT INTO ronbtf_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Şi căpetenia gărzii a însărcinat pe Iosif cu ei şi el i-a servit; şi au rămas un timp sub pază. ");
INSERT INTO ronbtf_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Şi au visat câte un vis amândoi, fiecare visul lui într-o noapte, fiecare conform interpretării visului său, paharnicul şi brutarul împăratului Egiptului, care erau legaţi în închisoare. ");
INSERT INTO ronbtf_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Şi Iosif a intrat la ei dimineaţa şi i-a privit şi, iată, ei erau trişti. ");
INSERT INTO ronbtf_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Şi a întrebat pe ofiţerii lui Faraon care erau cu el sub paza casei domnului său, spunând: Pentru ce arătaţi aşa întristaţi astăzi? ");
INSERT INTO ronbtf_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Iar ei i-au spus: Noi am visat un vis şi nu este un interpret al acestuia. Şi Iosif le-a spus: Nu lui Dumnezeu aparţin interpretările? Spuneţi-mi visele, vă rog. ");
INSERT INTO ronbtf_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Şi mai marele paharnicilor a povestit visul său lui Iosif şi i-a spus: În visul meu, iată, o viţă era înaintea mea; ");
INSERT INTO ronbtf_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Şi în viţă erau trei ramuri şi era ca şi cum aceasta înmugurea şi florile ei creşteau repede; şi ciorchinii acesteia au adus repede struguri copţi; ");
INSERT INTO ronbtf_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Şi paharul lui Faraon era în mâna mea; şi am luat strugurii şi i-am stors în paharul lui Faraon şi am dat paharul în mâna lui Faraon. ");
INSERT INTO ronbtf_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Şi Iosif i-a spus: Aceasta este interpretarea lui: Cele trei ramuri sunt trei zile, ");
INSERT INTO ronbtf_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Totuşi până în trei zile Faraon va înălţa capul tău şi te va restaura la locul tău; şi vei da paharul lui Faraon în mâna sa, după rânduiala dinainte, când ai fost paharnicul lui. ");
INSERT INTO ronbtf_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Dar gândeşte-te la mine când îţi va fi bine şi arată-mi bunătate, te rog, şi aminteşte-i lui Faraon despre mine şi scoate-mă afară din această casă; ");
INSERT INTO ronbtf_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Căci într-adevăr am fost furat în ascuns din ţara evreilor; şi nici aici nu am făcut nimic ca ei să mă pună în groapă. ");
INSERT INTO ronbtf_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Când mai marele brutarilor a văzut că interpretarea era bună, i-a spus lui Iosif: Eu de asemenea am fost în visul meu şi, iată, aveam trei coşuri albe pe capul meu; ");
INSERT INTO ronbtf_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Şi în coşul de deasupra erau tot felul de aluaturi coapte pentru Faraon; şi păsările le mâncau din coşul de pe capul meu. ");
INSERT INTO ronbtf_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Şi Iosif a răspuns şi a zis: Aceasta este interpretarea lui: Cele trei coşuri sunt trei zile; ");
INSERT INTO ronbtf_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Totuşi până în trei zile Faraon va ridica al tău cap de la tine şi te va atârna pe un lemn; şi îţi vor mânca păsările carnea de pe tine. ");
INSERT INTO ronbtf_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Şi s-a întâmplat, în a treia zi, care era ziua de naştere a lui Faraon, că el a făcut un ospăţ tuturor servitorilor săi: şi a înălţat capul mai marelui paharnicilor şi al mai marelui brutarilor între servitorii săi. ");
INSERT INTO ronbtf_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Şi a restaurat pe mai marele paharnicilor în conducerea paharnicilor din nou; şi paharnicul a dat paharul în mâna lui Faraon; ");
INSERT INTO ronbtf_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Dar l-a atârnat pe mai marele brutarilor, aşa cum le interpretase Iosif. ");
INSERT INTO ronbtf_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Totuşi mai marele paharnicilor nu şi-a adus aminte de Iosif, ci l-a uitat. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Şi s-a întâmplat, la sfârşitul a doi ani întregi, că Faraon a visat: şi, iată, el stătea în picioare lângă râu. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Şi, iată, au urcat din râu şapte vaci plăcute la vedere şi grase; şi ele păşteau într-o pajişte. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Şi, iată, alte şapte vaci au urcat după ele din râu, urâte la vedere şi slabe; şi au stat lângă celelalte vaci pe malul râului. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Şi vacile urâte la vedere şi slabe au mâncat vacile plăcute la vedere şi grase. Aşa că Faraon s-a trezit. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Şi a adormit şi a visat a doua oară: şi, iată, şapte spice de grâu s-au ridicat pe un pai, grase şi bune. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Şi, iată, şapte spice subţiri şi prăjite de vântul de est au răsărit după ele. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Şi cele şapte spice subţiri au mâncat cele şapte spice grase şi pline. Şi Faraon s-a trezit şi, iată, a fost un vis. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Şi s-a întâmplat dimineaţa că duhul său era tulburat; şi a trimis şi a chemat pe toţi magicienii Egiptului şi pe toţi înţelepţii acestuia; şi Faraon le-a spus visul său; dar nu era niciunul care să le poată interpreta lui Faraon. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Atunci a vorbit mai marele paharnicilor lui Faraon, spunând: Îmi amintesc greşelile mele în această zi; ");
INSERT INTO ronbtf_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Faraon s-a înfuriat pe servitorii săi şi m-a pus sub pază în casa căpeteniei gărzii, pe mine şi pe mai marele brutarilor. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Şi noi am visat un vis într-o noapte, eu şi el; noi am visat, fiecare conform interpretării visului său. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Şi era acolo cu noi un tânăr, un evreu, servitor al căpeteniei gărzii; şi noi i-am povestit şi el ne-a interpretat visele; fiecăruia conform visului său el ne-a interpretat. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Şi s-a întâmplat, că aşa cum ne-a interpretat, aşa a fost; pe mine el m-a restaurat în serviciul meu şi pe el l-a atârnat. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Atunci Faraon a trimis şi a chemat pe Iosif şi ei l-au adus repede din groapă; şi el s-a bărbierit şi şi-a schimbat hainele şi a intrat la Faraon. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Şi Faraon i-a spus lui Iosif: Am visat un vis şi nu este niciunul care să îl poată interpreta; şi am auzit vorbindu-se despre tine, că poţi înţelege un vis pentru a-l interpreta. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Şi Iosif i-a răspuns lui Faraon, spunând: Aceasta nu este în mine; Dumnezeu va da lui Faraon un răspuns al păcii. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Şi Faraon i-a spus lui Iosif: În visul meu, iată, stăteam în picioare pe malul râului; ");
INSERT INTO ronbtf_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Şi, iată, au urcat din râu şapte vaci grase şi plăcute la vedere; şi ele păşteau pe o pajişte; ");
INSERT INTO ronbtf_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Şi, iată, alte şapte vaci au urcat după ele, jigărite şi foarte urâte la vedere şi slabe, aşa de rele nu am văzut niciodată în toată ţara Egiptului; ");
INSERT INTO ronbtf_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Şi vacile slabe şi urâte la vedere au mâncat primele şapte vaci grase; ");
INSERT INTO ronbtf_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Şi după ce le-au mâncat, nu se putea cunoaşte că ele le-au mâncat pe acelea; ci ele erau încă urâte la vedere, precum la început. Aşa că m-am trezit. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Şi am văzut în visul meu şi, iată, şapte spice s-au ridicat pe un pai, pline şi bune; ");
INSERT INTO ronbtf_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Şi, iată, şapte spice, uscate, subţiri şi prăjite de vântul de est, au răsărit după ele; ");
INSERT INTO ronbtf_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Şi spicele subţiri au mâncat cele şapte spice bune; şi eu am spus aceasta magicienilor; dar nu a fost niciunul să îmi poată explica aceasta. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Şi Iosif i-a spus lui Faraon: Visul lui Faraon este unul singur: Dumnezeu i-a arătat lui Faraon ce este el gata să facă. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Cele şapte vaci bune sunt şapte ani; şi cele şapte spice bune sunt şapte ani; visul este unul singur. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Şi cele şapte vaci slabe şi urâte la vedere care au urcat după ele sunt şapte ani; şi cele şapte spice goale prăjite de vântul de est vor fi şapte ani de foamete. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Acesta este lucrul pe care l-am vorbit lui Faraon: Ceea ce Dumnezeu este gata să facă îi arată lui Faraon. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Iată, vin şapte ani de mare abundenţă prin toată ţara Egiptului; ");
INSERT INTO ronbtf_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Şi se vor ridica după ei şapte ani de foamete; şi toată abundenţa va fi uitată în ţara Egiptului; şi foametea va mistui ţara; ");
INSERT INTO ronbtf_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Şi abundenţa nu va fi cunoscută în ţară din cauza acelei foamete care urmează; căci aceasta va fi foarte apăsătoare. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Şi de aceea visul a fost repetat lui Faraon de două ori; aceasta este din cauză că lucrul este stabilit de Dumnezeu şi Dumnezeu îl va face să se întâmple curând. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Acum de aceea Faraon să caute un bărbat chibzuit şi înţelept şi să îl pună peste ţara Egiptului. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Să facă Faraon aceasta şi să rânduiască supraveghetori peste ţară şi să ia a cincea parte din ţara Egiptului în cei şapte ani de abundenţă. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Şi ei să adune toată hrana acelor ani buni ce vin şi să depoziteze grâne sub mâna lui Faraon şi ei să ţină hrana în cetăţi. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Şi acea hrană va fi ca rezervă ţării pentru cei şapte ani de foamete, care va fi în ţara Egiptului; ca ţara să nu piară prin foamete. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Şi lucrul a fost bun în ochii lui Faraon şi în ochii tuturor servitorilor săi. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Şi Faraon a spus servitorilor săi: Putem noi găsi un astfel de om cum este acesta, un bărbat în care este Duhul lui Dumnezeu? ");
INSERT INTO ronbtf_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Şi Faraon i-a spus lui Iosif: Întrucât Dumnezeu ţi-a arătat toată aceasta, nu există niciunul aşa de chibzuit şi înţelept precum eşti tu; ");
INSERT INTO ronbtf_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Tu vei fi peste casa mea şi conform cuvântului tău va fi guvernat tot poporul meu; numai pe tron voi fi mai mare ca tine. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Şi Faraon i-a spus lui Iosif: Vezi, te-am pus peste toată ţara Egiptului. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Şi Faraon şi-a scos inelul de pe mâna sa şi l-a pus pe mâna lui Iosif şi l-a înveşmântat în veştminte de in subţire şi a pus un lanţ de aur în jurul gâtului său. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Şi l-a făcut să meargă în al doilea car pe care îl avea; şi strigau înaintea lui: Aplecaţi genunchiul! Şi l-a făcut conducător peste toată ţara Egiptului. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Şi Faraon i-a spus lui Iosif: Eu sunt Faraon şi fără tine niciun om nu îşi va ridica mâna sau piciorul în toată ţara Egiptului. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Şi Faraon i-a pus lui Iosif numele Ţafnat-Paneah; şi i-a dat de soţie pe Asenat, fiica lui Potifera, preot din On. Şi Iosif a ieşit prin toată ţara Egiptului. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Şi Iosif era în vârstă de treizeci de ani când a stat în picioare înaintea lui Faraon, împăratul Egiptului. Şi Iosif a ieşit dinaintea lui Faraon şi a mers prin toată ţara Egiptului. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Şi în cei şapte ani abundenţi pământul a adus cu mâini pline. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Şi el a adunat toată hrana celor şapte ani, care era în ţara Egiptului, şi a depozitat hrana în cetăţi; hrana din câmp, care era în jurul fiecărei cetăţi, a depozitat-o în aceeaşi cetate. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Şi Iosif a adunat grâne ca nisipul mării, foarte multe, până ce s-a oprit din numărat, pentru că erau fără număr. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Şi lui Iosif i s-au născut, înainte de a veni anii foametei, doi fii pe care Asenat, fiica lui Potifera, preot din On, i-a născut lui. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Şi Iosif l-a numit pe întâiul născut, Manase: Pentru că Dumnezeu, a spus el, m-a făcut să uit toată osteneala mea şi toată casa tatălui meu. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Şi celui de al doilea, i-a pus numele, Efraim: Pentru că Dumnezeu m-a făcut să fiu roditor în ţara necazului meu. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Şi cei şapte ani ai abundenţei, care au fost în ţara Egiptului, s-au terminat. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Şi cei şapte ani ai sărăciei au început a veni, conform cu ceea ce Iosif spusese; şi sărăcia era în toate ţările; dar în toată ţara Egiptului era pâine. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Şi când toată ţara Egiptului a fost înfometată, poporul a strigat la Faraon pentru pâine; şi Faraon a spus tuturor egiptenilor: Mergeţi la Iosif; ce vă spune el, faceţi. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Şi foametea era peste toată faţa pământului. Şi Iosif a deschis toate depozitele şi a vândut egiptenilor; şi foametea se înăsprea în ţara Egiptului. ");
INSERT INTO ronbtf_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Şi toate ţările au venit în Egipt, la Iosif, pentru a cumpăra grâne, pentru că foametea era aşa de aspră în toate ţările. ");
INSERT INTO ronbtf_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Şi când Iacob a văzut că erau grâne în Egipt, Iacob a spus fiilor săi: De ce vă uitaţi unul la altul? ");
INSERT INTO ronbtf_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Şi a spus: Iată, eu am auzit că sunt grâne în Egipt; coborâţi acolo şi cumpăraţi pentru noi de acolo; ca să trăim şi să nu murim. ");
INSERT INTO ronbtf_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Şi cei zece fraţi ai lui Iosif au coborât pentru a cumpăra grâne în Egipt. ");
INSERT INTO ronbtf_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Dar pe Beniamin, fratele lui Iosif, Iacob nu l-a trimis cu fraţii săi; căci spunea el: Nu cumva să i se întâmple vreo nenorocire. ");
INSERT INTO ronbtf_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Şi fiii lui Israel au venit să cumpere grâne printre aceia ce veneau, pentru că era foamete în ţara lui Canaan. ");
INSERT INTO ronbtf_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Şi Iosif era guvernatorul peste ţară şi el era cel ce vindea la toţi oamenii din ţară; şi fraţii lui Iosif au venit şi s-au prosternat înaintea lui cu feţele lor la pământ. ");
INSERT INTO ronbtf_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Şi Iosif a văzut pe fraţii săi şi i-a recunoscut, dar s-a prefăcut străin faţă de ei şi le-a vorbit aspru; şi le-a spus: De unde veniţi voi? Iar ei au spus: Din ţara lui Canaan, pentru a cumpăra mâncare. ");
INSERT INTO ronbtf_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Şi Iosif a recunoscut pe fraţii săi, dar ei nu l-au recunoscut. ");
INSERT INTO ronbtf_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Şi Iosif şi-a amintit visele pe care le-a visat despre ei şi le-a spus: Voi sunteţi spioni; pentru a vedea goliciunea ţării aţi venit voi. ");
INSERT INTO ronbtf_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Iar ei i-au spus: Nu, domnul meu, ci doar pentru a cumpăra hrană au venit servitorii tăi. ");
INSERT INTO ronbtf_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Noi suntem toţi fii ai unui singur bărbat; noi suntem bărbaţi drepţi, servitorii tăi nu sunt spioni. ");
INSERT INTO ronbtf_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Şi el le-a spus: Nu, ci pentru a vedea goliciunea ţării aţi venit voi. ");
INSERT INTO ronbtf_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Iar ei au spus: Servitorii tăi sunt doisprezece fraţi, fii ai unui singur bărbat în ţara lui Canaan; şi, iată, cel mai tânăr este astăzi cu tatăl nostru, iar unul nu este. ");
INSERT INTO ronbtf_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Şi Iosif le-a spus: Aceasta este ceea ce v-am vorbit, zicând, Sunteţi spioni; ");
INSERT INTO ronbtf_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Prin aceasta veţi fi încercaţi: Pe viaţa lui Faraon, nu veţi pleca de aici, decât dacă cel mai tânăr frate al vostru vine aici. ");
INSERT INTO ronbtf_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Trimiteţi pe unul dintre voi şi el să aducă pe fratele vostru şi voi veţi fi ţinuţi în închisoare, ca ale voastre cuvinte să fie încercate dacă este adevăr în voi, sau altfel pe viaţa lui Faraon, cu adevărat voi sunteţi spioni. ");
INSERT INTO ronbtf_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Şi i-a pus împreună sub pază trei zile. ");
INSERT INTO ronbtf_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Şi Iosif le-a spus în a treia zi: Faceţi aceasta şi trăiţi; fiindcă eu mă tem de Dumnezeu; ");
INSERT INTO ronbtf_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Dacă voi sunteţi drepţi, lăsaţi pe unul dintre fraţii voştri să fie legat în casa închisorii voastre; mergeţi, căraţi grâne pentru foametea caselor voastre; ");
INSERT INTO ronbtf_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Dar aduceţi pe cel mai tânăr frate al vostru la mine; astfel cuvintele voastre vor fi verificate şi nu veţi muri. Şi au făcut astfel. ");
INSERT INTO ronbtf_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Iar ei au spus unul altuia: Noi suntem într-adevăr vinovaţi referitor la fratele nostru, în aceea că noi am văzut chinul sufletului său, când ne-a implorat şi am refuzat să îl ascultăm; pentru aceasta a venit această strâmtorare peste noi. ");
INSERT INTO ronbtf_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Şi Ruben le-a răspuns, zicând: Nu v-am spus eu, zicând: Nu păcătuiţi împotriva copilului; dar aţi refuzat să ascultaţi? Şi acum, iată, şi sângele lui ne este cerut. ");
INSERT INTO ronbtf_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Şi nu au ştiut că Iosif îi înţelegea, pentru că le vorbea printr-un traducător. ");
INSERT INTO ronbtf_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Şi s-a întors cu spatele la ei şi a plâns; şi s-a întors la ei din nou şi a vorbit îndeaproape cu ei şi a luat pe Simeon de la ei şi l-a legat înaintea ochilor lor. ");
INSERT INTO ronbtf_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Atunci Iosif a poruncit să le umple sacii cu grâne şi să pună înapoi banii fiecărui bărbat în sacul lui şi să le dea provizii pentru drum: şi astfel le-a făcut. ");
INSERT INTO ronbtf_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Şi au încărcat grâne pe măgarii lor şi au plecat de acolo. ");
INSERT INTO ronbtf_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Şi pe când unul dintre ei şi-a deschis sacul ca să dea măgarului său nutreţ la han, a văzut banii săi, pentru că, iată, aceştia erau la gura sacului său. ");
INSERT INTO ronbtf_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Şi a spus fraţilor săi: Banii mei îmi sunt înapoiaţi; şi, iată, sunt chiar în sacul meu; şi i-a lăsat inima şi s-au înspăimântat şi şi-au spus unul altuia: Ce este aceasta ce Dumnezeu ne-a făcut? ");
INSERT INTO ronbtf_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Şi au venit la Iacob, tatăl lor, până în ţara lui Canaan şi i-au spus tot ceea ce li s-a întâmplat, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Bărbatul, care este domnul ţării, ne-a vorbit aspru şi ne-a luat de spioni ai ţării. ");
INSERT INTO ronbtf_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Şi noi i-am spus: Noi suntem drepţi, nu suntem spioni, ");
INSERT INTO ronbtf_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Noi suntem doisprezece fraţi, fii ai tatălui nostru; unul nu este şi cel mai tânăr este în această zi cu tatăl nostru în ţara lui Canaan. ");
INSERT INTO ronbtf_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Şi bărbatul, domnul ţării, ne-a spus: Prin aceasta voi şti că voi sunteţi drepţi: lăsaţi pe unul dintre fraţii voştri aici cu mine şi luaţi hrana pentru foametea caselor voastre şi plecaţi, ");
INSERT INTO ronbtf_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Şi aduceţi pe cel mai tânăr frate al vostru la mine; atunci voi şti că voi nu sunteţi spioni, ci sunteţi cinstiţi; astfel vă voi elibera pe fratele vostru, iar voi veţi face comerţ în ţară. ");
INSERT INTO ronbtf_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Şi s-a întâmplat, pe când îşi goleau sacii că, iată, legătura de bani a fiecărui bărbat era în sacul lui; şi când ei şi tatăl lor au văzut legăturile de bani, au fost înspăimântaţi. ");
INSERT INTO ronbtf_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Şi Iacob, tatăl lor, le-a spus: Voi m-aţi văduvit de copii; Iosif nu este şi Simeon nu este şi voi veţi duce departe pe Beniamin; toate aceste lucruri sunt împotriva mea. ");
INSERT INTO ronbtf_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Şi Ruben i-a vorbit tatălui său, spunând: Ucide pe cei doi fii ai mei dacă nu îl aduc înapoi la tine; predă-l în mâna mea şi îl voi aduce din nou la tine. ");
INSERT INTO ronbtf_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Iar el a spus: Fiul meu nu va coborî cu voi, pentru că fratele lui este mort şi a rămas singur; dacă i se întâmplă nenorocire pe calea pe care mergeţi, atunci veţi coborî perii mei cărunţi cu întristare în mormânt. ");
INSERT INTO ronbtf_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Şi foametea era aspră în ţară. ");
INSERT INTO ronbtf_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Şi s-a întâmplat, după ce au terminat de mâncat grânele pe care le-au adus din Egipt, că tatăl lor le-a spus: Mergeţi din nou, cumpăraţi-ne puţină hrană. ");
INSERT INTO ronbtf_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Şi Iuda i-a vorbit, spunând: Bărbatul ne-a avertizat hotărât, spunând: Nu îmi veţi vedea faţa decât dacă fratele vostru va fi cu voi. ");
INSERT INTO ronbtf_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Dacă voieşti să-l trimiţi pe fratele nostru cu noi, vom coborî şi vom cumpăra pentru tine hrană; ");
INSERT INTO ronbtf_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Dar dacă nu voieşti să îl trimiţi, nu vom coborî, pentru că acel bărbat ne-a spus: Nu veţi vedea faţa mea, decât dacă fratele vostru va fi cu voi. ");
INSERT INTO ronbtf_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Şi Israel a spus: Pentru ce aţi lucrat aşa de rău cu mine, încât să spuneţi acelui bărbat că mai aveţi un frate? ");
INSERT INTO ronbtf_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Iar ei au spus: Acel bărbat ne-a întrebat cu de-amănuntul despre starea noastră şi despre rudenia noastră, spunând: Este tatăl vostru încă în viaţă? Mai aveţi vreun alt frate? Şi noi i-am spus conform cu tonul acestor cuvinte, puteam noi să ştim cu adevărat că el va spune: Coborâţi pe fratele vostru aici? ");
INSERT INTO ronbtf_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Şi Iuda i-a spus lui Israel, tatăl său: Trimite băiatul cu mine şi ne vom ridica şi vom merge; ca să trăim şi să nu murim deopotrivă noi şi tu şi micuţii noştri. ");
INSERT INTO ronbtf_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Eu voi fi garanţie pentru el; din mâna mea îl vei cere; dacă nu ţi-l aduc şi nu îl pun înaintea ta, atunci să suport eu vina pentru totdeauna; ");
INSERT INTO ronbtf_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Căci dacă nu am fi întârziat, cu adevărat acum am fi întorşi şi de această a doua oară. ");
INSERT INTO ronbtf_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Şi tatăl lor, Israel, le-a spus: Dacă aşa trebuie să fie acum, faceţi aceasta; luaţi din cele mai bune roade din ţară în vasele voastre şi duceţi-i înapoi un dar acelui bărbat, puţin balsam şi puţină miere, mirodenii şi smirnă, nuci şi migdale; ");
INSERT INTO ronbtf_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Şi luaţi dublul banilor în mâna voastră; şi banii care au fost aduşi înapoi la gura sacilor voştri, duceţi-i înapoi în mâna voastră; poate aceasta a fost o neatenţie. ");
INSERT INTO ronbtf_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Luaţi de asemenea pe fratele vostru şi ridicaţi-vă, mergeţi din nou la acel bărbat; ");
INSERT INTO ronbtf_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Şi Dumnezeu cel Atotputernic să vă dea milă înaintea acelui bărbat, ca el să trimită pe celălalt frate al vostru şi pe Beniamin. Dacă este să fiu văduvit de copiii mei, eu sunt văduvit. ");
INSERT INTO ronbtf_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Şi bărbaţii au luat acel dar şi au luat dublul banilor în mâna lor şi pe Beniamin; şi s-au ridicat şi au coborât în Egipt şi au stat înaintea lui Iosif. ");
INSERT INTO ronbtf_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Şi când Iosif a văzut pe Beniamin cu ei, a spus administratorului casei sale: Adu aceşti bărbaţi în casă şi înjunghie animale şi pregăteşte, pentru că aceşti bărbaţi vor mânca cu mine la amiază. ");
INSERT INTO ronbtf_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Şi bărbatul a făcut cum Iosif a cerut; şi bărbatul a adus bărbaţii în casa lui Iosif. ");
INSERT INTO ronbtf_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Şi bărbaţii s-au temut, deoarece au fost aduşi în casa lui Iosif; şi au spus: Din cauza banilor care au fost întorşi înapoi în sacii noştri de prima dată suntem aduşi înăuntru; ca el să caute motiv împotriva noastră şi să cadă asupra noastră şi să ne ia ca robi şi măgarii noştri. ");
INSERT INTO ronbtf_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Şi s-au apropiat de administratorul casei lui Iosif şi au vorbit îndeaproape cu el la uşa casei, ");
INSERT INTO ronbtf_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Şi au spus: Vai, domnule, noi, într-adevăr, am coborât de prima dată pentru a cumpăra hrană. ");
INSERT INTO ronbtf_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Şi s-a întâmplat când am venit la han, că am deschis sacii noştri şi, iată, banii fiecărui bărbat erau la gura sacului său, banii noştri în greutate deplină; şi noi am adus aceşti bani înapoi în mâna noastră. ");
INSERT INTO ronbtf_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Şi alţi bani am adus aici în mâna noastră pentru a cumpăra hrană; nu putem spune cine a pus banii noştri în sacii noştri. ");
INSERT INTO ronbtf_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Iar el a spus: Pace vouă, nu vă temeţi; Dumnezeul vostru şi Dumnezeul tatălui vostru v-a dat comoară în sacii voştri; eu am avut banii voştri. Şi l-a adus pe Simeon la ei. ");
INSERT INTO ronbtf_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Şi bărbatul a adus bărbaţii în casa lui Iosif şi le-a dat apă şi ei şi-au spălat picioarele; iar el a dat măgarilor lor nutreţ. ");
INSERT INTO ronbtf_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Şi au pregătit darul înainte să vină Iosif la amiază, pentru că au auzit că vor mânca pâine acolo. ");
INSERT INTO ronbtf_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Şi după ce Iosif a venit acasă, i-au adus darul, care era în mâna lor, în casă şi i s-au prosternat până la pământ. ");
INSERT INTO ronbtf_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Iar el i-a întrebat despre bunăstarea lor şi a spus: Este bine tatăl vostru, bătrânul despre care voi aţi vorbit? Mai trăieşte? ");
INSERT INTO ronbtf_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Iar ei au răspuns: Servitorul tău, tatăl nostru, este sănătos, încă trăieşte. Şi ei şi-au aplecat capetele şi s-au prosternat. ");
INSERT INTO ronbtf_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Iar el şi-a ridicat ochii şi a văzut pe fratele său Beniamin, fiul mamei sale, şi a spus: Este acesta fratele vostru mai tânăr, despre care mi-aţi vorbit? Şi a spus: Dumnezeu să aibă har față de tine, fiule. ");
INSERT INTO ronbtf_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Şi Iosif s-a grăbit, pentru că adâncurile lui fremătau pentru fratele său; şi a căutat un loc unde să plângă; şi a intrat în camera sa şi a plâns acolo. ");
INSERT INTO ronbtf_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Şi el şi-a spălat faţa şi a ieşit şi s-a stăpânit şi a spus: Puneţi pâine. ");
INSERT INTO ronbtf_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Şi au pus pentru el deoparte şi pentru ei deoparte şi pentru egiptenii care mâncau cu el deoparte, pentru că egiptenii nu pot mânca pâine cu evreii, pentru că aceasta este o urâciune pentru egipteni. ");
INSERT INTO ronbtf_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Şi au şezut înaintea lui, întâiul născut conform cu dreptul său de întâi născut şi cel mai tânăr conform tinereţii sale; şi bărbaţii se minunau unul către altul. ");
INSERT INTO ronbtf_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Şi a luat şi le-a trimis daruri de mâncare din cele dinaintea lui; iar darul de mâncare al lui Beniamin era de cinci ori mai mult decât al oricăruia dintre ei. Şi au băut şi s-au bucurat împreună cu el. ");
INSERT INTO ronbtf_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Şi a poruncit administratorului casei sale, spunând: Umple sacii bărbaţilor cu hrană, atât cât pot căra; şi pune banii fiecărui bărbat la gura sacului său. ");
INSERT INTO ronbtf_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Şi pune paharul meu, paharul de argint, la gura sacului celui mai tânăr şi banii lui pentru grâne. Iar el a făcut conform cuvântului pe care Iosif l-a spus. ");
INSERT INTO ronbtf_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Imediat ce s-a luminat de dimineaţă, bărbaţii au fost trimişi, ei şi măgarii lor. ");
INSERT INTO ronbtf_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Şi după ce au ieşit din cetate şi nu erau încă departe, Iosif a spus administratorului său: Ridică-te, urmăreşte bărbaţii aceia; şi după ce îi ajungi, spune-le: Pentru ce aţi răsplătit rău pentru bine? ");
INSERT INTO ronbtf_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Nu este acesta, paharul din care domnul meu bea, şi prin care într-adevăr el ghiceşte? Aţi făcut rău făcând astfel. ");
INSERT INTO ronbtf_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Şi i-a ajuns şi le-a vorbit aceste cuvinte. ");
INSERT INTO ronbtf_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Iar ei i-au spus: Pentru ce spune domnul meu aceste cuvinte? Nicidecum nu vor face servitorii tăi conform acestui lucru. ");
INSERT INTO ronbtf_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Iată, banii pe care noi i-am găsit la gura sacilor noştri, i-am adus din nou la tine din ţara lui Canaan; cum atunci am fura noi argint sau aur din casa domnului tău? ");
INSERT INTO ronbtf_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","La oricare din servitorii tăi ar fi găsită, deopotrivă el să moară, iar noi de asemenea vom fi robii domnului meu. ");
INSERT INTO ronbtf_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Iar el a spus: Acum de asemenea aceasta să fie conform cuvintelor voastre, cel la care paharul este găsit va fi robul meu, iar voi veţi fi fără vină. ");
INSERT INTO ronbtf_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Atunci ei îndată şi-au coborât la pământ fiecare sacul său şi fiecare şi-a deschis sacul. ");
INSERT INTO ronbtf_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Şi a căutat începând de la cel mai în vârstă şi a terminat la cel mai tânăr, şi paharul s-a găsit în sacul lui Beniamin. ");
INSERT INTO ronbtf_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Atunci ei şi-au rupt hainele şi fiecare bărbat şi-a încărcat măgarul şi s-au întors în cetate. ");
INSERT INTO ronbtf_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Şi Iuda şi fraţii săi au venit la casa lui Iosif, căci el era încă acolo; şi au căzut înaintea lui la pământ. ");
INSERT INTO ronbtf_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Şi Iosif le-a spus: Ce faptă este aceasta pe care aţi făcut-o? Sau nu ştiţi că un astfel de om ca mine poate cu adevărat ghici? ");
INSERT INTO ronbtf_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Şi Iuda a spus: Ce să spunem domnului meu? Ce să vorbim? Sau cum să ne dezvinovăţim? Dumnezeu a descoperit nelegiuirea servitorilor tăi; iată, noi suntem servitorii domnului meu, deopotrivă noi şi de asemenea cel cu care paharul a fost găsit. ");
INSERT INTO ronbtf_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Iar el a spus: Nicidecum nu voi face astfel; ci bărbatul în a cărui mână a fost găsit paharul, acela va fi servitorul meu; şi cât despre voi, urcaţi-vă în pace la tatăl vostru. ");
INSERT INTO ronbtf_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Atunci Iuda s-a apropiat de el şi a spus: Vai domnul meu, lasă pe servitorul tău, te rog, să vorbească un cuvânt în urechile domnului meu şi nu lăsa mânia ta să se aprindă împotriva servitorului tău, căci tu eşti întocmai ca Faraon. ");
INSERT INTO ronbtf_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Domnul meu a întrebat pe servitorii săi, spunând: Aveţi voi un tată, sau un frate? ");
INSERT INTO ronbtf_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Şi noi am spus domnului meu: Avem un tată, un om bătrân, şi un copil al bătrâneţii lui, unul mic; şi fratele lui este mort şi numai el a rămas de la mama sa; şi tatăl său îl iubeşte. ");
INSERT INTO ronbtf_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Şi tu ai spus servitorilor tăi: Aduceţi-l jos la mine, ca să îmi pun ochii mei peste el. ");
INSERT INTO ronbtf_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Şi noi am spus domnului meu: Tânărul nu poate părăsi pe tatăl său, căci dacă el va părăsi pe tatăl său, tatăl său va muri. ");
INSERT INTO ronbtf_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Şi tu ai spus servitorilor tăi: Dacă fratele vostru cel mai tânăr nu coboară cu voi, nu îmi veţi mai vedea faţa. ");
INSERT INTO ronbtf_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Şi s-a întâmplat când noi am urcat la servitorul tău, tatăl meu, că i-am spus cuvintele domnului meu. ");
INSERT INTO ronbtf_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Şi tatăl nostru a spus: Mergeţi din nou şi cumpăraţi-ne puţină hrană. ");
INSERT INTO ronbtf_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Iar noi am spus: Nu putem coborî decât dacă fratele nostru cel mai tânăr este cu noi, atunci vom coborî; căci nu putem vedea faţa bărbatului, decât dacă fratele nostru cel mai tânăr este cu noi. ");
INSERT INTO ronbtf_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Şi servitorul tău, tatăl meu, ne-a spus: Ştiţi că soţia mea mi-a născut doi fii; ");
INSERT INTO ronbtf_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Şi unul a plecat de la mine şi am spus: Cu adevărat este sfâşiat în bucăţi; şi nu l-am văzut de atunci. ");
INSERT INTO ronbtf_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Şi dacă îl luaţi şi pe acesta de la mine şi i se întâmplă nenorocire veţi coborî perii mei cărunţi cu întristare în mormânt. ");
INSERT INTO ronbtf_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Acum de aceea când eu ajung la servitorul tău, tatăl meu, şi tânărul nu este cu noi, văzând că viaţa lui este legată de viaţa tânărului, ");
INSERT INTO ronbtf_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Se va întâmpla, când el vede că tânărul nu este cu noi, că va muri; şi servitorii tăi vor coborî perii cărunţi ai servitorului tău, tatăl nostru, cu întristare în mormânt. ");
INSERT INTO ronbtf_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Căci servitorul tău a devenit garanţie pentru tânăr pentru tatăl meu, spunând: Dacă nu îl aduc la tine, atunci voi suporta vina faţă de tatăl meu pentru totdeauna. ");
INSERT INTO ronbtf_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Acum de aceea, te rog, lasă pe servitorul tău să rămână în locul tânărului ca rob domnului meu; şi lasă tânărul să urce cu fraţii săi. ");
INSERT INTO ronbtf_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Căci cum voi urca la tatăl meu şi băiatul să nu fie cu mine? Ca nu cumva să văd răul ce va veni peste tatăl meu! ");
INSERT INTO ronbtf_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Atunci Iosif nu s-a putut stăpâni înaintea tuturor celor ce stăteau lângă el şi a strigat: Scoateţi afară pe fiecare bărbat de la mine. Şi nu a stat niciun bărbat cu el în timp ce Iosif s-a făcut cunoscut fraţilor săi. ");
INSERT INTO ronbtf_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Şi a plâns, ridicând vocea; şi egiptenii şi casa lui Faraon au auzit. ");
INSERT INTO ronbtf_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Şi Iosif a spus fraţilor săi: Eu sunt Iosif, mai trăieşte tatăl meu? Şi fraţii lui nu au putut să îi răspundă pentru că au fost tulburaţi de prezenţa lui. ");
INSERT INTO ronbtf_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Şi Iosif a spus fraţilor săi: Apropiaţi-vă de mine, vă rog. Şi s-au apropiat. Iar el a spus: Eu sunt Iosif, fratele vostru, pe care l-aţi vândut în Egipt. ");
INSERT INTO ronbtf_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Acum pentru aceasta nu fiţi îndureraţi, nici mânioşi pe voi înşivă, că m-aţi vândut aici; căci Dumnezeu m-a trimis înaintea voastră pentru a păstra viaţa. ");
INSERT INTO ronbtf_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Pentru că în aceşti doi ani a fost foametea în ţară; şi mai sunt cinci ani, în care nu va fi nici arat nici secerat. ");
INSERT INTO ronbtf_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Şi Dumnezeu m-a trimis înaintea voastră pentru a vă păstra o posteritate pe pământ şi pentru a vă salva vieţile printr-o mare eliberare. ");
INSERT INTO ronbtf_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Aşa că acum nu voi sunteţi cei ce m-aţi trimis aici, ci Dumnezeu; şi m-a făcut un tată lui Faraon şi domn a toată casa lui şi un stăpân peste toată ţara Egiptului. ");
INSERT INTO ronbtf_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Grăbiţi-vă şi urcaţi la tatăl meu şi spuneţi-i: Astfel spune fiul tău, Iosif: Dumnezeu m-a făcut domn a tot Egiptul; coboară la mine, nu întârzia; ");
INSERT INTO ronbtf_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Şi vei locui în ţinutul Gosen şi vei fi aproape de mine, tu şi copiii tăi şi copiii copiilor tăi şi turmele tale şi cirezile tale şi tot ce ai; ");
INSERT INTO ronbtf_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Şi acolo te voi hrăni, pentru că sunt încă cinci ani de foamete; ca nu cumva tu şi casa ta şi tot ce ai, să ajungă la sărăcie. ");
INSERT INTO ronbtf_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Şi, iată, ochii voştri şi ochii lui Beniamin, fratele meu, văd că aceasta este gura mea care vă vorbeşte. ");
INSERT INTO ronbtf_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Şi să spuneţi tatălui meu despre toată gloria mea în Egipt şi despre tot ce aţi văzut; şi grăbiţi-vă şi coborâţi pe tatăl meu aici. ");
INSERT INTO ronbtf_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Şi a căzut pe gâtul fratelui său Beniamin şi a plâns; şi Beniamin a plâns pe gâtul său. ");
INSERT INTO ronbtf_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Mai mult, a sărutat pe toţi fraţii săi şi a plâns asupra lor; şi după aceea fraţii săi au vorbit cu el. ");
INSERT INTO ronbtf_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Şi vestea despre aceasta s-a auzit în casa lui Faraon, spunând: Fraţii lui Iosif au venit; şi aceasta i-a plăcut mult lui Faraon şi servitorilor săi. ");
INSERT INTO ronbtf_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Şi Faraon i-a spus lui Iosif: Spune fraţilor tăi: Aceasta să faceţi voi: încărcaţi-vă vitele şi mergeţi, duceţi-vă în ţara lui Canaan; ");
INSERT INTO ronbtf_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Şi luaţi pe tatăl vostru şi casele voastre şi veniţi la mine; şi vă voi da bunătatea ţării Egiptului şi veţi mânca grăsimea ţării. ");
INSERT INTO ronbtf_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Acum ţie îţi este poruncit, aceasta să faceţi: luaţi care din ţara Egiptului pentru micuţii voştri şi pentru soţiile voastre şi aduceţi pe tatăl vostru şi veniţi. ");
INSERT INTO ronbtf_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","De asemenea nu luaţi aminte la lucrurile voastre; căci bunătatea a toată ţara Egiptului este a voastră. ");
INSERT INTO ronbtf_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Şi copiii lui Israel au făcut astfel; şi Iosif le-a dat care, conform poruncii lui Faraon, şi le-a dat provizii pentru drum. ");
INSERT INTO ronbtf_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Tuturor el le-a dat, fiecărui bărbat, schimburi de haine; dar lui Beniamin i-a dat trei sute de arginţi şi cinci schimburi de haine. ");
INSERT INTO ronbtf_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Şi tatălui său i-a trimis în felul acesta: zece măgari încărcaţi cu lucrurile bune ale Egiptului şi zece măgăriţe încărcate cu grâne şi pâine şi mâncare pentru tatăl său pentru drum. ");
INSERT INTO ronbtf_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Aşa că el a trimis pe fraţii săi, iar ei au plecat; şi le-a spus: Vedeţi să nu vă certaţi pe drum. ");
INSERT INTO ronbtf_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Şi au urcat din Egipt şi au venit în ţara lui Canaan la Iacob, tatăl lor, ");
INSERT INTO ronbtf_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Şi i-au istorisit, spunând: Iosif este încă în viaţă şi este guvernator peste toată ţara Egiptului. Şi inima lui Iacob s-a oprit, pentru că nu i-a crezut. ");
INSERT INTO ronbtf_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Iar ei i-au spus toate cuvintele lui Iosif, pe care le spusese către ei; şi când a văzut carele pe care Iosif le-a trimis să îl ducă, duhul lui Iacob, tatăl lor, a reînviat; ");
INSERT INTO ronbtf_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Şi Israel a spus: Este de ajuns; Iosif, fiul meu, este încă în viaţă; voi merge şi îl voi vedea înainte să mor. ");
INSERT INTO ronbtf_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Şi Israel a plecat în călătoria sa cu tot ce avea şi a venit la Beer-Şeba şi a oferit sacrificii Dumnezeului tatălui său Isaac. ");
INSERT INTO ronbtf_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Şi Dumnezeu i-a vorbit lui Israel în viziunile nopţii şi a spus: Iacob, Iacob. Iar el a spus: Iată-mă. ");
INSERT INTO ronbtf_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Şi a spus: Eu sunt Dumnezeu, Dumnezeul tatălui tău; nu te teme să cobori în Egipt, fiindcă acolo voi face din tine o mare naţiune; ");
INSERT INTO ronbtf_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Voi coborî cu tine în Egipt; şi de asemenea cu adevărat te voi urca înapoi, şi Iosif îşi va pune mâna peste ochii tăi. ");
INSERT INTO ronbtf_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Şi Iacob s-a ridicat din Beer-Şeba; şi fiii lui Israel l-au dus pe Iacob, tatăl lor, şi pe micuţii lor şi pe soţiile lor în carele pe care Faraon le-a trimis să îl ducă. ");
INSERT INTO ronbtf_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Şi au luat vitele lor şi bunurile lor, pe care le dobândiseră în ţara lui Canaan, şi au venit în Egipt, deopotrivă Iacob şi toată sămânţa lui cu el; ");
INSERT INTO ronbtf_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Fiii săi şi fiii fiilor săi cu el, fiicele sale şi fiicele fiilor săi şi toată sămânţa sa el a adus-o cu el în Egipt. ");
INSERT INTO ronbtf_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Şi acestea sunt numele copiilor lui Israel, care au venit în Egipt, Iacob şi fiii săi: Ruben, întâiul născut al lui Iacob. ");
INSERT INTO ronbtf_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Şi fiii lui Ruben: Hanoc şi Falu şi Heţron şi Carmi. ");
INSERT INTO ronbtf_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Şi fiii lui Simeon: Iemuel şi Iamin şi Ohad şi Iachin şi Ţohar şi Şaul, fiul unei femei canaanite. ");
INSERT INTO ronbtf_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Şi fiii lui Levi: Gherşon, Chehat şi Merari. ");
INSERT INTO ronbtf_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Şi fiii lui Iuda: Er şi Onan şi Şela şi Pereţ şi Zerah; dar Er şi Onan au murit în ţara lui Canaan. Şi fiii lui Pereţ au fost: Heţron şi Hamul. ");
INSERT INTO ronbtf_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Şi fiii lui Isahar: Tola şi Pua şi Iov şi Şimron. ");
INSERT INTO ronbtf_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Şi fiii lui Zabulon: Sered şi Elon şi Iahleel. ");
INSERT INTO ronbtf_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Aceştia sunt fiii Leei, cu fiica sa Dina, pe care ea i-a născut lui Iacob în Padanaram; toate sufletele fiilor săi şi a fiicelor sale au fost treizeci şi trei. ");
INSERT INTO ronbtf_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Şi fiii lui Gad: Ţifion şi Hagi, Şuni şi Eţbon, Eri şi Arodi şi Areli. ");
INSERT INTO ronbtf_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Şi fiii lui Aşer: Imna şi Işva şi Işvi şi Beria şi Serah, sora lor; şi fiii lui Beria: Heber şi Malchiel. ");
INSERT INTO ronbtf_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Aceştia sunt fiii Zilpei, pe care Laban a dat-o Leei, fiica sa, şi pe aceştia i-a născut ea lui Iacob, şaisprezece suflete. ");
INSERT INTO ronbtf_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Fiii Rahelei, soţia lui Iacob: Iosif şi Beniamin. ");
INSERT INTO ronbtf_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Şi lui Iosif în ţara Egiptului i s-au născut Manase şi Efraim, pe care Asenat, fiica lui Potifera, preot din On, i-a născut lui. ");
INSERT INTO ronbtf_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Şi fiii lui Beniamin au fost Bela şi Becher şi Aşbel, Ghera şi Naaman, Ehi şi Roş, Mupim şi Hupim şi Ard. ");
INSERT INTO ronbtf_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Aceştia sunt fiii Rahelei, care au fost născuţi lui Iacob; toate sufletele au fost paisprezece. ");
INSERT INTO ronbtf_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Şi fiii lui Dan: Huşim. ");
INSERT INTO ronbtf_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Şi fiii lui Neftali: Iahzeel şi Guni şi Ieţer şi Şilem. ");
INSERT INTO ronbtf_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Aceştia sunt fiii Bilhei, pe care Laban a dat-o Rahelei, fiica sa, şi ea i-a născut pe aceştia lui Iacob; toate sufletele au fost şapte. ");
INSERT INTO ronbtf_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Toate sufletele care au venit cu Iacob în Egipt, care au ieşit din coapsele lui, pe lângă soţiile fiilor lui Iacob, toate sufletele au fost şaizeci şi şase. ");
INSERT INTO ronbtf_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Şi fiii lui Iosif, care i s-au născut în Egipt, au fost două suflete; toate sufletele din casa lui Iacob, care au venit în Egipt, au fost şaptezeci. ");
INSERT INTO ronbtf_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Şi a trimis pe Iuda înaintea lui la Iosif, să îndrepte faţa sa spre Gosen; şi au venit în ţinutul Gosen. ");
INSERT INTO ronbtf_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Şi Iosif şi-a pregătit carul şi s-a urcat să întâmpine pe Israel, tatăl său, la Gosen; şi i s-a înfăţişat; şi a căzut pe gâtul lui şi a plâns pe gâtul lui mult timp. ");
INSERT INTO ronbtf_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Şi Israel i-a spus lui Iosif: Acum pot muri pentru că am văzut faţa ta şi încă trăieşti. ");
INSERT INTO ronbtf_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Şi Iosif a spus fraţilor săi şi casei tatălui său: Voi urca şi îl voi anunţa pe Faraon şi îi voi spune: Fraţii mei şi casa tatălui meu, care au fost în ţara lui Canaan, au venit la mine; ");
INSERT INTO ronbtf_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Şi bărbaţii sunt păstori, pentru că meseria lor era să pască vitele; şi au adus turmele lor şi cirezile lor şi tot ceea ce au. ");
INSERT INTO ronbtf_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Şi se va întâmpla, când Faraon vă va chema şi va spune: Care este ocupaţia voastră? ");
INSERT INTO ronbtf_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Că voi să spuneți: Meseria servitorilor tăi a fost la vite din tinereţea noastră chiar până acum, deopotrivă noi şi părinţii noştri; ca să locuiţi în ţinutul Gosen; căci fiecare păstor este o urâciune înaintea Egiptenilor. ");
INSERT INTO ronbtf_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Atunci Iosif a venit şi i-a povestit lui Faraon şi a spus: Tatăl meu şi fraţii mei şi turmele lor şi cirezile lor şi tot ce au ei, au ieşit din ţara lui Canaan; şi, iată, ei sunt în ţinutul Gosen. ");
INSERT INTO ronbtf_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Şi a luat pe câţiva dintre fraţii săi, cinci bărbaţi, şi i-a prezentat înaintea lui Faraon. ");
INSERT INTO ronbtf_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Şi Faraon a spus fraţilor lui: Care este ocupaţia voastră? Iar ei i-au spus lui Faraon: Servitorii tăi sunt păstori, deopotrivă noi şi părinţii noştri. ");
INSERT INTO ronbtf_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ei i-au mai spus lui Faraon: Noi am venit pentru a locui temporar în ţară; fiindcă servitorii tăi nu au păşune pentru turmele lor, pentru că foametea este aspră în ţara lui Canaan; acum de aceea, te rugăm, lasă pe servitorii tăi să locuiască în ţinutul Gosen. ");
INSERT INTO ronbtf_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Şi Faraon i-a vorbit lui Iosif, spunând: Tatăl tău şi fraţii tăi au venit la tine; ");
INSERT INTO ronbtf_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Ţara Egiptului este înaintea ta; în cea mai bună parte a ţării aşază pe tatăl tău şi pe fraţii tăi să locuiască; în ţinutul Gosen să locuiască; şi dacă tu cunoşti pe unii bărbaţi capabili printre ei, atunci pune-i conducători peste vitele mele. ");
INSERT INTO ronbtf_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Şi Iosif a adus pe Iacob, tatăl său, şi l-a pus înaintea lui Faraon; şi Iacob a binecuvântat pe Faraon. ");
INSERT INTO ronbtf_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Şi Faraon i-a spus lui Iacob: Câte sunt zilele anilor vieţii tale? ");
INSERT INTO ronbtf_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Şi Iacob i-a spus lui Faraon: Zilele anilor călătoriei mele sunt o sută treizeci de ani; puţine şi rele au fost zilele anilor vieţii mele şi nu au ajuns la zilele anilor vieţii părinţilor mei în zilele călătoriei lor. ");
INSERT INTO ronbtf_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Şi Iacob a binecuvântat pe Faraon şi a ieşit dinaintea lui Faraon. ");
INSERT INTO ronbtf_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Şi Iosif a aşezat pe tatăl său şi pe fraţii săi şi le-a dat o stăpânire în ţara Egiptului, în cea mai bună parte a ţării, în ţinutul Ramses, aşa cum Faraon poruncise. ");
INSERT INTO ronbtf_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Şi Iosif a hrănit pe tatăl său şi pe fraţii săi şi toată casa tatălui său, cu pâine, conform cu familiile lor. ");
INSERT INTO ronbtf_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Şi nu era pâine în toată ţara, pentru că foametea era foarte aspră, aşa că toată ţara Egiptului şi toată ţara lui Canaan leşina din cauza foametei. ");
INSERT INTO ronbtf_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Şi Iosif a adunat toţi banii care s-au găsit în ţara Egiptului şi în ţara lui Canaan, pentru grânele pe care le-au cumpărat; şi Iosif a adus banii în casa lui Faraon. ");
INSERT INTO ronbtf_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Şi când s-au terminat banii din ţara Egiptului şi din ţara lui Canaan, toţi egiptenii au venit la Iosif şi au spus: Dă-ne pâine, pentru ce să murim în faţa ta? Pentru că banii s-au terminat. ");
INSERT INTO ronbtf_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Şi Iosif a spus: Daţi vitele voastre; şi vă voi da pentru vitele voastre, dacă banii s-au terminat. ");
INSERT INTO ronbtf_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Şi au adus vitele lor la Iosif; şi Iosif le-a dat pâine în schimb pentru cai şi pentru turme şi pentru vitele cirezilor şi pentru măgari; şi i-a hrănit pe ei cu pâine pentru toate vitele lor în acel an. ");
INSERT INTO ronbtf_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Când acel an s-a terminat, ei au venit la el în al doilea an şi i-au spus: Noi nu vom ascunde aceasta faţă de domnul nostru, cum că banii noştri s-au terminat; domnul nostru are de asemenea cirezile noastre de vite; nu este nimic rămas înaintea domnului nostru decât trupurile noastre şi pământurile noastre; ");
INSERT INTO ronbtf_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Pentru ce să murim înaintea ochilor tăi, deopotrivă noi şi ţara noastră? Cumpără-ne pe noi şi pământul nostru pentru pâine şi noi şi pământul nostru vom fi servitori lui Faraon; şi dă-ne sămânţă, ca noi să trăim şi să nu murim, ca ţara să nu fie pustiită. ");
INSERT INTO ronbtf_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Şi Iosif a cumpărat toată ţara Egiptului pentru Faraon; fiindcă egiptenii au vândut, fiecare bărbat câmpul său, pentru că îi cuprinsese foametea; aşa că ţara a devenit a lui Faraon. ");
INSERT INTO ronbtf_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Şi cât despre popor, i-a mutat în cetăţi de la un capăt al graniţelor Egiptului chiar până la celălalt capăt al lui. ");
INSERT INTO ronbtf_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Numai pământul preoţilor nu l-a cumpărat; fiindcă preoţii aveau o porţie atribuită lor de Faraon şi mâncau porţia lor pe care Faraon le-a dat-o; din această cauză nu şi-au vândut pământurile. ");
INSERT INTO ronbtf_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Atunci Iosif a spus poporului: Iată, v-am cumpărat astăzi pe voi şi pământul vostru pentru Faraon; iată, aici este sămânţă pentru voi şi veţi semăna pământul. ");
INSERT INTO ronbtf_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Şi se va întâmpla la timpul roadelor, că voi veţi da a cincea parte lui Faraon şi patru părţi vor fi ale voastre, pentru sămânţa câmpului şi pentru mâncarea voastră şi pentru cei ai caselor voastre şi pentru mâncare pentru micuţii voştri. ");
INSERT INTO ronbtf_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Iar ei au spus: Tu ai salvat vieţile noastre; să găsim har înaintea ochilor domnului meu şi vom fi servitorii lui Faraon. ");
INSERT INTO ronbtf_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Şi Iosif a făcut aceasta o lege peste ţara Egiptului până în această zi, că Faraon va avea a cincea parte; cu excepţia numai a pământului preoţilor, care nu a devenit al lui Faraon. ");
INSERT INTO ronbtf_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Şi Israel a locuit în ţara Egiptului, în ţinutul Gosen; şi aveau stăpâniri acolo şi au crescut şi s-au înmulţit peste măsură. ");
INSERT INTO ronbtf_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Şi Iacob a trăit în ţara Egiptului şaptesprezece ani, aşa că toate zilele vieţii lui Iacob au fost o sută patruzeci şi şapte de ani. ");
INSERT INTO ronbtf_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Şi s-au apropiat zilele lui Israel ca să moară; şi a chemat pe fiul său, Iosif, şi i-a spus: Dacă eu acum am găsit har înaintea ochilor tăi, pune-ţi, te rog, mâna sub coapsa mea şi lucrează cu bunăvoinţă şi credincioşie faţă de mine; nu mă îngropa, te rog, în Egipt, ");
INSERT INTO ronbtf_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Ci mă voi culca cu părinţii mei şi tu mă vei duce din Egipt şi mă vei îngropa în locul lor de îngropare. Iar el a spus: Voi face precum ai spus. ");
INSERT INTO ronbtf_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Iar el a spus: Jură-mi. Şi el i-a jurat. Şi Israel s-a aplecat pe capul patului. ");
INSERT INTO ronbtf_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Şi s-a întâmplat, după aceste lucruri, că i s-a spus lui Iosif: Iată, tatăl tău este bolnav; iar el a luat cu el pe cei doi fii ai săi, Manase şi Efraim. ");
INSERT INTO ronbtf_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Şi i s-a spus lui Iacob, zicând: Iată, fiul tău, Iosif, vine la tine; şi Israel s-a întărit şi a şezut pe pat. ");
INSERT INTO ronbtf_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Şi Iacob i-a spus lui Iosif: Dumnezeu cel Atotputernic mi s-a arătat la Luz, în ţara lui Canaan, şi m-a binecuvântat. ");
INSERT INTO ronbtf_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Şi mi-a spus: Iată, te voi face roditor şi te voi înmulţi şi voi face din tine o mulţime de popoare; şi voi da această ţară seminţei tale după tine ca stăpânire veşnică. ");
INSERT INTO ronbtf_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Şi acum cei doi fii ai tăi, Efraim şi Manase, care ţi s-au născut în ţara Egiptului înainte să vin la tine în Egipt, sunt ai mei; ca Ruben şi Simeon, vor fi ai mei. ");
INSERT INTO ronbtf_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Şi urmaşii tăi, pe care îi naşti după ei, vor fi ai tăi şi vor fi chemaţi după numele fraţilor lor în moştenirea lor. ");
INSERT INTO ronbtf_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Şi cât despre mine, când eu am venit din Padan, Rahela a murit lângă mine în ţara lui Canaan, pe cale, pe când nu era decât o bucată de drum până să ajungem la Efrata; şi eu am îngropat-o acolo, pe calea Efratei, care este Betleem. ");
INSERT INTO ronbtf_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Şi Israel a privit pe fiii lui Iosif şi a spus: Cine sunt aceştia? ");
INSERT INTO ronbtf_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Şi Iosif a spus tatălui său: Ei sunt fiii mei, pe care Dumnezeu mi i-a dat în acest loc. Iar el a spus: Adu-i la mine, te rog şi îi voi binecuvânta. ");
INSERT INTO ronbtf_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Acum ochii lui Israel erau slabi din cauza vârstei, aşa că nu putea vedea. Şi i-a adus aproape de el; şi i-a sărutat şi i-a îmbrăţişat. ");
INSERT INTO ronbtf_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Şi Israel i-a spus lui Iosif: Nu mă gândisem să văd faţa ta; şi, iată, Dumnezeu mi-a arătat de asemenea sămânţa ta. ");
INSERT INTO ronbtf_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Şi Iosif i-a scos dintre genunchii săi şi s-a prosternat el însuşi cu faţa lui la pământ. ");
INSERT INTO ronbtf_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Şi Iosif i-a luat pe amândoi, pe Efraim în mâna sa dreaptă, spre mâna stângă a lui Israel, şi pe Manase în mâna sa stângă, spre mâna dreaptă a lui Israel, şi i-a apropiat de el. ");
INSERT INTO ronbtf_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Şi Israel a întins mâna sa dreaptă şi a pus-o pe capul lui Efraim, care era mai tânăr, şi mâna sa stângă peste capul lui Manase, punând mâinile sale în mod voit astfel; fiindcă Manase era întâiul născut. ");
INSERT INTO ronbtf_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Şi a binecuvântat pe Iosif şi a spus: Dumnezeu, înaintea căruia părinţii mei, Avraam şi Isaac, au umblat, Dumnezeul care m-a hrănit cât a fost viaţa mea de lungă până în această zi, ");
INSERT INTO ronbtf_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Îngerul care m-a răscumpărat din tot răul, să binecuvânteze băieţii; şi numele meu să fie chemat peste ei şi numele părinţilor mei, Avraam şi Isaac; şi ei să devină o mulţime în mijlocul pământului. ");
INSERT INTO ronbtf_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Şi când Iosif a văzut că tatăl său a pus mâna sa dreaptă peste capul lui Efraim, aceasta nu i-a plăcut; şi a apucat mâna tatălui său, să o mute de pe capul lui Efraim pe capul lui Manase. ");
INSERT INTO ronbtf_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Şi Iosif a spus tatălui său: Nu aşa tată, fiindcă acesta este întâiul născut; pune-ţi mâna dreaptă pe capul lui. ");
INSERT INTO ronbtf_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Dar tatăl său a refuzat şi a spus: Ştiu aceasta fiul meu, o ştiu, el de asemenea va deveni un popor şi el de asemenea va fi mare; dar cu adevărat, fratele lui mai tânăr va fi mai mare decât el şi sămânţa lui va deveni o mulţime de naţiuni. ");
INSERT INTO ronbtf_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Şi i-a binecuvântat în acea zi, spunând: În tine Israel va binecuvânta, zicând: Dumnezeu să te facă pe tine ca pe Efraim şi ca pe Manase; şi a aşezat pe Efraim înaintea lui Manase. ");
INSERT INTO ronbtf_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Şi Israel i-a spus lui Iosif: Iată, eu mor; dar Dumnezeu va fi cu tine şi te va aduce din nou în ţara părinţilor tăi. ");
INSERT INTO ronbtf_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Mai mult, ţi-am dat o porţie mai mult decât fraţilor tăi, pe care i-am scos din mâna amoritului cu sabia mea şi cu arcul meu. ");
INSERT INTO ronbtf_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Şi Iacob a chemat pe fiii săi şi a spus: Adunaţi-vă împreună, ca să vă spun ce vi se va întâmpla în zilele de pe urmă. ");
INSERT INTO ronbtf_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Adunaţi-vă şi ascultaţi, voi copii ai lui Iacob; şi daţi ascultare lui Israel, tatăl vostru. ");
INSERT INTO ronbtf_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, tu eşti întâiul meu născut, tăria mea şi începutul puterii mele, măreţia demnităţii şi măreţia puterii: ");
INSERT INTO ronbtf_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Instabil ca apa, tu nu vei avea întâietatea, pentru că te-ai urcat în patul tatălui tău; atunci l-ai pângărit; el s-a urcat în culcuşul meu. ");
INSERT INTO ronbtf_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon şi Levi sunt fraţi; instrumente ale cruzimii sunt în locuinţele lor. ");
INSERT INTO ronbtf_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Sufletul meu, nu intra în taina lor; onoarea mea, nu te uni cu adunarea lor, pentru că în mânia lor au ucis un bărbat şi în propria lor voie au surpat un zid. ");
INSERT INTO ronbtf_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Blestemată fie mânia lor, pentru că a fost înverşunată, şi furia lor, pentru că a fost crudă. Eu îi voi împărţi în Iacob şi îi voi împrăştia în Israel. ");
INSERT INTO ronbtf_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Iuda, tu eşti cel pe care fraţii tăi îl vor lăuda; mâna ta va fi în gâtul duşmanilor tăi; copiii tatălui tău se vor prosterna înaintea ta. ");
INSERT INTO ronbtf_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Iuda este un pui de leu, de la pradă, fiul meu, te-ai ridicat; el s-a aplecat, el s-a culcat ca un leu şi ca un leu bătrân; cine îl va scula? ");
INSERT INTO ronbtf_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Sceptrul nu se va depărta de la Iuda, nici legiuitor dintre picioarele lui, până ce Şilo vine; şi la el va fi adunarea poporului. ");
INSERT INTO ronbtf_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Legând măgăruşul său la viţă şi mânzul măgăriţei la viţa nobilă; el şi-a spălat hainele în vin şi veştmintele sale în sângele strugurilor. ");
INSERT INTO ronbtf_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Ochii lui vor fi roşii de vin şi dinţii lui albi de lapte. ");
INSERT INTO ronbtf_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zabulon va locui la limanul mării; şi el va fi liman corăbiilor; şi graniţa lui va fi până la Sidon. ");
INSERT INTO ronbtf_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isahar este un măgar puternic, culcându-se jos între două sarcini; ");
INSERT INTO ronbtf_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Şi a văzut că odihna era bună şi ţara că era plăcută; şi şi-a aplecat umărul să poarte povara şi a devenit servitor care dă tribut. ");
INSERT INTO ronbtf_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan va judeca poporul său, ca unul dintre triburile lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan va fi un şarpe pe cale, o viperă pe cărare, care străpunge călcâiele calului, astfel că al său călăreţ va cădea pe spate. ");
INSERT INTO ronbtf_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Eu am aşteptat salvarea ta, DOAMNE. ");
INSERT INTO ronbtf_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Pe Gad, o trupă înarmată îl va învinge; dar el va învinge până la urmă. ");
INSERT INTO ronbtf_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","De la Aşer pâinea îi va fi grasă şi va da delicatese împărăteşti. ");
INSERT INTO ronbtf_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Neftali este o cerboaică dezlegată; el dă cuvinte bune. ");
INSERT INTO ronbtf_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Iosif este o ramură roditoare, o ramură roditoare lângă o fântână; a cărui mlădiţe se întind peste zid; ");
INSERT INTO ronbtf_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Arcaşii l-au mâhnit amarnic şi au tras spre el şi l-au urât; ");
INSERT INTO ronbtf_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Dar arcul său a rămas tare şi braţele mâinilor lui s-au întărit prin mâinile puternicului Dumnezeu al lui Iacob; (de acolo este păstorul, piatra lui Israel): ");
INSERT INTO ronbtf_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Chiar prin Dumnezeul tatălui tău, care te va ajuta; şi prin Atotputernicul, care te va binecuvânta cu binecuvântări ale cerului de sus, binecuvântări ale adâncului care se întinde jos, binecuvântări ale sânilor şi ale pântecelui; ");
INSERT INTO ronbtf_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Binecuvântările tatălui tău au întrecut binecuvântările strămoşilor mei până la cea mai îndepărtată margine a dealurilor veşnice; ele vor fi pe capul lui Iosif şi pe coroana de pe capul lui, el care a fost separat de fraţii săi. ");
INSERT INTO ronbtf_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Beniamin va sfâşia ca un lup; dimineaţa el va mânca prada şi noaptea va împărţi prada. ");
INSERT INTO ronbtf_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Toţi aceştia sunt cele douăsprezece triburi ale lui Israel; şi aceasta este ceea ce tatăl lor le-a spus şi i-a binecuvântat; pe fiecare bărbat conform cu binecuvântarea lui i-a binecuvântat. ");
INSERT INTO ronbtf_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Şi le-a poruncit şi le-a spus: Eu sunt gata a fi adunat la poporul meu; îngropaţi-mă cu părinţii mei în peştera care este în câmpul lui Efron hititul, ");
INSERT INTO ronbtf_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","În peştera care este în câmpul din Macpela, care este în faţă cu Mamre, în ţara lui Canaan, pe care Avraam a cumpărat-o împreună cu câmpul lui Efron hititul ca stăpânire a unui loc de îngropare. ");
INSERT INTO ronbtf_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Acolo au înmormântat pe Avraam şi pe Sara, soţia lui; acolo au îngropat pe Isaac şi Rebeca, soţia lui; şi acolo am îngropat-o eu pe Leea. ");
INSERT INTO ronbtf_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Cumpărarea câmpului şi a peşterii care este în el a fost de la copiii lui Het. ");
INSERT INTO ronbtf_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Şi după ce Iacob a terminat de poruncit fiilor săi, el şi-a strâns picioarele în pat şi şi-a dat duhul şi a fost adunat la poporul lui. ");
INSERT INTO ronbtf_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Şi Iosif a căzut pe faţa tatălui său şi a plâns peste el şi l-a sărutat. ");
INSERT INTO ronbtf_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Şi Iosif a poruncit servitorilor săi medici să îmbălsămeze pe tatăl său; şi medicii l-au îmbălsămat pe Israel. ");
INSERT INTO ronbtf_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Şi patruzeci de zile au fost împlinite pentru el; căci aşa sunt împlinite zilele celor ce sunt îmbălsămaţi; şi egiptenii au jelit pentru el şaptezeci de zile. ");
INSERT INTO ronbtf_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Şi când zilele jelirii lui au trecut, Iosif a vorbit casei lui Faraon, spunând: Dacă acum eu am găsit har în ochii voştri, vorbiţi, vă rog, în urechile lui Faraon, zicând: ");
INSERT INTO ronbtf_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Tatăl meu m-a făcut să jur, spunând: Iată, eu mor; în mormântul meu pe care l-am săpat pentru mine în ţara lui Canaan, acolo să mă îngropi. De aceea acum, lasă-mă să urc, te rog şi să îngrop pe tatăl meu şi voi veni înapoi. ");
INSERT INTO ronbtf_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Şi Faraon a spus: Urcă-te şi îngroapă pe tatăl tău, aşa cum te-a făcut să juri. ");
INSERT INTO ronbtf_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Şi Iosif a urcat să îngroape pe tatăl său; şi cu el au urcat toţi servitorii lui Faraon, bătrânii casei lui şi toţi bătrânii ţării Egiptului, ");
INSERT INTO ronbtf_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Şi toată casa lui Iosif şi fraţii săi şi casa tatălui său; doar micuţii lor şi turmele lor şi cirezile lor, le-au lăsat în ţinutul Gosen. ");
INSERT INTO ronbtf_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Şi au urcat împreună cu el deopotrivă care şi călăreţi; şi aceasta a fost o mare oştire. ");
INSERT INTO ronbtf_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Şi au venit la aria lui Atad, care este dincolo de Iordan; şi acolo au jelit cu o foarte mare şi aprinsă plângere; şi a făcut o jelire pentru tatăl său şapte zile. ");
INSERT INTO ronbtf_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Şi când locuitorii ţării, canaaniţii, au văzut jelirea din aria lui Atad, au spus: Aceasta este o jelire apăsătoare pentru egipteni; pentru aceasta numele ei a fost pus Abelmiţraim, care este dincolo de Iordan. ");
INSERT INTO ronbtf_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Şi fiii lui i-au făcut aşa cum le-a poruncit; ");
INSERT INTO ronbtf_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Căci fiii lui l-au purtat în ţara lui Canaan şi l-au îngropat în peştera din câmpul din Macpela, pe care Avraam a cumpărat-o de la Efron hititul, împreună cu câmpul, care este în faţă cu Mamre, ca stăpânire a locului de îngropare. ");
INSERT INTO ronbtf_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Şi Iosif, după ce a îngropat pe tatăl său, s-a întors în Egipt, el şi fraţii săi şi toţi cei care au urcat cu el ca să îngroape pe tatăl său. ");
INSERT INTO ronbtf_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Şi după ce fraţii lui Iosif au văzut că tatăl lor era mort, au spus: Iosif poate ne va urî şi cu adevărat va cere înapoi de la noi tot răul pe care i l-am făcut. ");
INSERT INTO ronbtf_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Şi au trimis un mesager la Iosif, spunând: Tatăl tău a poruncit înainte ca el să moară, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Aşa să îi spuneţi lui Iosif: Iartă, te rog, acum, fărădelegea fraţilor tăi şi păcatul lor; căci ei ţi-au făcut rău; şi acum, iartă, te rugăm, fărădelegea servitorilor Dumnezeului tatălui tău. Şi Iosif a plâns când i-au vorbit. ");
INSERT INTO ronbtf_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Şi fraţii lui de asemenea au mers şi au căzut jos înaintea feţei sale şi au spus: Iată, noi suntem servitorii tăi. ");
INSERT INTO ronbtf_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Şi Iosif le-a spus: Nu vă temeţi, sunt eu în locul lui Dumnezeu? ");
INSERT INTO ronbtf_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Cât despre voi, aţi gândit facere de rău împotriva mea; dar Dumnezeu a plănuit-o pentru bine, ca să facă să se întâmple, aşa cum este în această zi, pentru a salva mult popor viu. ");
INSERT INTO ronbtf_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","De aceea acum, nu vă temeţi; vă voi hrăni pe voi şi pe micuţii voştri. Şi i-a mângâiat şi le-a vorbit binevoitor. ");
INSERT INTO ronbtf_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Şi Iosif a locuit în Egipt, el şi casa tatălui său; şi Iosif a trăit o sută zece ani. ");
INSERT INTO ronbtf_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Şi Iosif a văzut copiii lui Efraim din a treia generaţie; de asemenea copiii lui Machir, fiul lui Manase, au fost crescuţi pe genunchii lui Iosif. ");
INSERT INTO ronbtf_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Şi Iosif a spus fraţilor săi: Eu mor; şi Dumnezeu cu adevărat vă va vizita şi vă va scoate din această ţară, în ţara pe care a jurat-o lui Avraam, lui Isaac şi lui Iacob. ");
INSERT INTO ronbtf_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Şi Iosif a pus pe copiii lui Israel să îi jure, spunând: Dumnezeu vă va vizita negreşit şi veţi ridica oasele mele de aici. ");
INSERT INTO ronbtf_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Şi Iosif a murit, fiind în vârstă de o sută zece ani; şi l-au îmbălsămat; şi a fost pus într-un sicriu în Egipt. ");
INSERT INTO ronbtf_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Și acestea sunt numele copiilor lui Israel, care au venit în Egipt; fiecare bărbat și casa lui au venit cu Iacob. ");
INSERT INTO ronbtf_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, Simeon, Levi și Iuda, ");
INSERT INTO ronbtf_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isahar, Zabulon și Beniamin, ");
INSERT INTO ronbtf_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan și Neftali, Gad și Așer. ");
INSERT INTO ronbtf_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Și toate sufletele care au ieșit din coapsele lui Iacob au fost șaptezeci de suflete; căci Iosif era deja în Egipt. ");
INSERT INTO ronbtf_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Și Iosif a murit și toți frații lui și toată generația aceea. ");
INSERT INTO ronbtf_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Și copiii lui Israel au fost roditori și au crescut și s-au înmulțit și au devenit peste măsură de tari; și țara s-a umplut cu ei. ");
INSERT INTO ronbtf_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Și s-a ridicat un nou împărat peste Egipt, care nu a cunoscut pe Iosif. ");
INSERT INTO ronbtf_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Și a spus poporului său: Iată, poporul copiilor lui Israel este mai numeros și mai puternic decât noi; ");
INSERT INTO ronbtf_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Haideți să ne purtăm înțelept cu ei, ca nu cumva să se înmulțească și să se întâmple ca, atunci când s-ar întâmpla vreun război, să se alăture și ei dușmanilor noștri și să lupte împotriva noastră și astfel să iasă din țară. ");
INSERT INTO ronbtf_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","De aceea au pus peste ei asupritori, ca să îi chinuiască cu poverile lor. Și au construit pentru Faraon cetăți de provizii: Pitom și Raamses. ");
INSERT INTO ronbtf_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Dar cu cât îi chinuiau mai mult, cu atât se înmulțeau și creșteau mai mult. Și s-au mâhnit din cauza copiilor lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Și egiptenii au constrâns cu asprime pe copiii lui Israel să îi servească; ");
INSERT INTO ronbtf_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Și au amărât viețile lor cu o robie aspră: în lucrări de mortar și în cărămizi și în tot felul de munci în câmp; toată munca lor, în care ei i-au făcut să muncească, era cu asprime. ");
INSERT INTO ronbtf_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Și împăratul Egiptului a vorbit moașelor evreice, dintre care numele uneia era Șifra și numele celeilalte era Pua; ");
INSERT INTO ronbtf_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Și a spus: Când faceți serviciul de moașă femeilor evreice și le vedeți pe scaunele de naștere, dacă este un fiu, să îl ucideți; dar dacă este o fiică, să trăiască. ");
INSERT INTO ronbtf_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Dar moașele s-au temut de Dumnezeu și nu au făcut cum le-a poruncit împăratul Egiptului, ci au lăsat băieții în viață. ");
INSERT INTO ronbtf_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Și împăratul Egiptului a chemat moașele și le-a spus: De ce ați făcut acest lucru și ați lăsat băieții în viață? ");
INSERT INTO ronbtf_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Și moașele i-au spus lui Faraon: Pentru că femeile evreice nu sunt ca femeile egiptence, pentru că ele sunt viguroase și au născut înainte de a veni moașele la ele. ");
INSERT INTO ronbtf_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","De aceea Dumnezeu s-a purtat bine cu moașele; și poporul s-a înmulțit și a devenit foarte tare. ");
INSERT INTO ronbtf_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Și s-a întâmplat, din cauză că moașele s-au temut de Dumnezeu, că el le-a făcut case. ");
INSERT INTO ronbtf_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Și Faraon a poruncit la tot poporul său, spunând: Fiecare fiu care se naște să îl aruncați în râu, dar pe fiecare fiică să o lăsați în viață. ");
INSERT INTO ronbtf_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Și un bărbat din casa lui Levi a mers și a luat de soție o fiică a lui Levi. ");
INSERT INTO ronbtf_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Și femeia a rămas însărcinată și a născut un fiu; și când ea l-a văzut că era frumos, l-a ascuns trei luni. ");
INSERT INTO ronbtf_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Și când nu l-a mai putut ascunde, a luat pentru el o arcă din papură și a uns-o cu bitum și cu smoală și a pus copilul în ea; și a pus arca între trestiile de lângă malul râului. ");
INSERT INTO ronbtf_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Și sora lui a stat departe, pentru a vedea ce i se va face. ");
INSERT INTO ronbtf_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Și fiica lui Faraon a coborât să se spele la râu; și servitoarele ei umblau pe malul râului; și când a văzut arca printre trestii și-a trimis servitoarea să o aducă. ");
INSERT INTO ronbtf_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Și când a deschis-o, a văzut copilul; și, iată, pruncul plângea. Iar ea a avut milă de el și a spus: Acesta este unul dintre copiii evreilor. ");
INSERT INTO ronbtf_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Atunci sora lui a spus fiicei Faraonului: Să merg și să îți chem o doică dintre femeile evreice, ca să alăpteze copilul pentru tine? ");
INSERT INTO ronbtf_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Și fiica lui Faraon i-a spus: Du-te. Și fata a mers și a chemat pe mama copilului. ");
INSERT INTO ronbtf_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Și fiica lui Faraon i-a spus: Ia acest copil și alăptează-l pentru mine și îți voi da plățile tale. Și femeia a luat copilul și l-a alăptat. ");
INSERT INTO ronbtf_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Și copilul a crescut și ea l-a adus la fiica lui Faraon și el a devenit fiul ei. Iar ea i-a pus numele Moise; și a spus: Pentru că l-am scos din apă. ");
INSERT INTO ronbtf_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Și s-a întâmplat, în acele zile, când Moise era mare, că a ieșit la frații săi și a privit la poverile lor; și a văzut un egiptean lovind un evreu, pe unul dintre frații săi. ");
INSERT INTO ronbtf_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Și s-a uitat încoace și încolo și când a văzut că nu era niciun bărbat, a ucis pe egiptean și l-a ascuns în nisip. ");
INSERT INTO ronbtf_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Și când a ieșit a doua zi, iată, doi bărbați dintre evrei se luptau între ei; și a spus celui ce a greșit: Pentru ce lovești pe aproapele tău? ");
INSERT INTO ronbtf_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Iar el a spus: Cine te-a făcut prinț și judecător peste noi? Vrei să mă ucizi așa cum l-ai ucis pe egiptean? Și Moise s-a temut și a spus: Cu adevărat acest lucru este cunoscut. ");
INSERT INTO ronbtf_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Și când Faraon a auzit acest lucru, a căutat să-l ucidă pe Moise. Dar Moise a fugit de la fața lui Faraon și a locuit în țara lui Madian; și a șezut jos lângă o fântână. ");
INSERT INTO ronbtf_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Și preotul din Madian avea șapte fiice; și ele au venit și au scos apă și au umplut jgheaburile ca să adape turma tatălui lor. ");
INSERT INTO ronbtf_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Și păstorii au venit și le-au alungat; dar Moise s-a ridicat și le-a ajutat și le-a adăpat turma. ");
INSERT INTO ronbtf_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Și când ele au venit la Reuel, tatăl lor, el a spus: Cum de ați venit așa devreme astăzi? ");
INSERT INTO ronbtf_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Iar ele au spus: Un egiptean ne-a scăpat din mâna păstorilor și de asemenea a scos apă îndeajuns pentru noi și a adăpat turma. ");
INSERT INTO ronbtf_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Iar el a spus fiicelor sale: Și el, unde este? Pentru ce l-ați lăsat acolo pe bărbatul acela? Chemați-l, ca să mănânce pâine. ");
INSERT INTO ronbtf_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Și Moise s-a mulțumit să locuiască la omul acela; iar el i-a dat lui Moise pe Sefora, fiica sa. ");
INSERT INTO ronbtf_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Și ea i-a născut un fiu, iar el i-a pus numele Gherșom, pentru că a spus: Sunt străin într-o țară străină. ");
INSERT INTO ronbtf_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Și s-a întâmplat, în decursul timpului, că împăratul Egiptului a murit; și copiii lui Israel oftau din cauza robiei și au strigat și strigătul lor a urcat sus la Dumnezeu din cauza robiei. ");
INSERT INTO ronbtf_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Și Dumnezeu a auzit geamătul lor și Dumnezeu și-a adus aminte de legământul său cu Avraam, cu Isaac și cu Iacob. ");
INSERT INTO ronbtf_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Și Dumnezeu a privit peste copiii lui Israel și Dumnezeu a luat cunoștință de starea lor. ");
INSERT INTO ronbtf_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Și Moise a păzit turma lui Ietro, socrul său, preotul din Madian; și a condus turma spre partea din spate a deșertului și a venit la muntele lui Dumnezeu, la Horeb. ");
INSERT INTO ronbtf_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Și îngerul DOMNULUI i s-a arătat într-o flacără de foc ieșind din mijlocul unui rug; și el a privit și, iată, rugul ardea cu foc și rugul nu se mistuia. ");
INSERT INTO ronbtf_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Și Moise a spus: Acum mă voi abate ca să văd această priveliște măreață, pentru ce rugul nu se arde. ");
INSERT INTO ronbtf_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Și când DOMNUL a văzut că s-a abătut pentru a vedea, Dumnezeu l-a chemat din mijlocul rugului și a spus: Moise, Moise. Iar el a spus: Iată-mă. ");
INSERT INTO ronbtf_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Iar el a spus: Nu te apropia aici; scoate-ți sandalele din picioarele tale, pentru că locul pe care tu stai în picioare este pământ sfânt. ");
INSERT INTO ronbtf_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Mai mult, el a spus: Eu sunt Dumnezeul tatălui tău, Dumnezeul lui Avraam, Dumnezeul lui Isaac și Dumnezeul lui Iacob. Și Moise și-a ascuns fața, pentru că s-a temut să se uite la Dumnezeu. ");
INSERT INTO ronbtf_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Și DOMNUL a spus: Cu adevărat am văzut necazul poporului meu care este în Egipt și am auzit strigătul lor din cauza asupritorilor; căci știu întristările lor; ");
INSERT INTO ronbtf_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Și am coborât să îi eliberez din mâna egiptenilor și să îi scot din acea țară într-o țară bună și largă, într-o țară în care curge lapte și miere; în locul canaaniților și al hitiților și al amoriților și al periziților și al hiviților și al iebusiților. ");
INSERT INTO ronbtf_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Și acum, iată, strigătul copiilor lui Israel a ajuns la mine; și eu de asemenea am văzut oprimarea cu care egiptenii îi oprimă. ");
INSERT INTO ronbtf_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Și acum vino și te voi trimite la Faraon, ca să scoți afară din Egipt pe poporul meu, copiii lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Și Moise i-a spus lui Dumnezeu: Cine sunt eu, ca să merg la Faraon și ca să aduc pe copiii lui Israel afară din Egipt? ");
INSERT INTO ronbtf_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Iar el a spus: Cu adevărat voi fi cu tine; și acesta îți va fi un semn, că te-am trimis: După ce vei fi adus poporul afară din Egipt, veți servi lui Dumnezeu pe acest munte. ");
INSERT INTO ronbtf_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Și Moise i-a spus lui Dumnezeu: Iată, când voi veni la copiii lui Israel și le voi spune: Dumnezeul părinților voștri m-a trimis la voi; și îmi vor spune: Care este numele lui? Ce le voi spune? ");
INSERT INTO ronbtf_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Și Dumnezeu i-a spus lui Moise: EU SUNT CEL CE SUNT. Și a spus: Astfel să spui copiilor lui Israel: EU SUNT m-a trimis la voi. ");
INSERT INTO ronbtf_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Și Dumnezeu i-a mai spus lui Moise: Astfel să spui copiilor lui Israel: DOMNUL Dumnezeul părinților voștri, Dumnezeul lui Avraam, Dumnezeul lui Isaac și Dumnezeul lui Iacob, m-a trimis la voi; acesta este numele meu pentru totdeauna și aceasta este amintirea mea pentru toate generațiile. ");
INSERT INTO ronbtf_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Du-te și adună bătrânii lui Israel și spune-le: DOMNUL Dumnezeul părinților voștri, Dumnezeul lui Avraam, al lui Isaac și al lui Iacob, mi s-a arătat, spunând: Cu adevărat eu v-am vizitat și am văzut ce vi se face în Egipt. ");
INSERT INTO ronbtf_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Și am spus: Vă voi scoate din necazul Egiptului în țara canaaniților și a hitiților și a amoriților și a periziților și a hiviților și a iebusiților, într-o țară în care curge lapte și miere. ");
INSERT INTO ronbtf_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Și vor da ascultare vocii tale; și mergi, tu și bătrânii lui Israel, la împăratul Egiptului și îi veți spune: DOMNUL Dumnezeul evreilor s-a întâlnit cu noi; și acum lasă-ne să mergem, te implorăm, într-o călătorie de trei zile în pustie, ca să sacrificăm DOMNULUI Dumnezeului nostru. ");
INSERT INTO ronbtf_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Și sunt sigur că împăratul Egiptului nu vă va lăsa să mergeți, nu, nici chiar cu mână tare. ");
INSERT INTO ronbtf_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Și îmi voi întinde mâna și voi lovi Egiptul cu toate minunile mele pe care le voi face în mijlocul acestuia; și după aceea vă va lăsa să mergeți. ");
INSERT INTO ronbtf_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Și voi da acestui popor favoare înaintea ochilor egiptenilor; și se va întâmpla, când plecați, că nu veți pleca cu mâinile goale, ");
INSERT INTO ronbtf_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Ci fiecare femeie va împrumuta de la vecina ei și de la cea care locuiește temporar în casa ei, bijuterii de argint și bijuterii de aur și haine; și voi le veți pune pe fiii voștri și pe fiicele voastre; și veți prăda pe egipteni. ");
INSERT INTO ronbtf_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Și Moise a răspuns și a zis: Dar, iată, ei nu mă vor crede, nici nu vor da ascultare vocii mele; căci vor spune: DOMNUL nu ți s-a arătat. ");
INSERT INTO ronbtf_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Și DOMNUL i-a spus: Ce este acesta în mâna ta? Iar el a spus: Un toiag. ");
INSERT INTO ronbtf_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Iar el a spus: Aruncă-l pe pământ. Și el l-a aruncat la pământ și acesta a devenit un șarpe; și Moise a fugit dinaintea acestuia. ");
INSERT INTO ronbtf_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Și DOMNUL i-a spus lui Moise: Întinde-ți mâna și ia-l de coadă. Iar el și-a întins mâna și l-a prins, iar acesta a devenit toiag în mâna sa; ");
INSERT INTO ronbtf_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Ca ei să creadă că DOMNUL Dumnezeul părinților lor, Dumnezeul lui Avraam, Dumnezeul lui Isaac și Dumnezeul lui Iacob, ți s-a arătat. ");
INSERT INTO ronbtf_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Și DOMNUL i-a mai spus: Pune-ți acum mâna în sân. Iar el și-a pus mâna în sân; și când și-a scos-o, iată, mâna lui era leproasă ca zăpada. ");
INSERT INTO ronbtf_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Iar el a spus: Pune-ți din nou mâna în sân. Și el din nou și-a pus mâna în sân; și a scos-o afară din sân și, iată, aceasta s-a refăcut din nou ca cealaltă carne a sa. ");
INSERT INTO ronbtf_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Și se va întâmpla, dacă ei nu te vor crede, nici nu vor da ascultare vocii primului semn, că vor crede vocea următorului semn. ");
INSERT INTO ronbtf_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Și se va întâmpla, dacă ei nu vor crede nici aceste două semne, nici nu vor da ascultare vocii tale, că vei lua din apa râului și o vei turna peste uscat; și apa pe care tu o iei din râu va deveni sânge pe uscat. ");
INSERT INTO ronbtf_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Și Moise i-a spus DOMNULUI: O, Domnul meu, eu nu sunt elocvent, nici mai înainte nu am fost, nici de când i-ai vorbit servitorului tău, ci eu sunt greu la vorbă și încet la limbă. ");
INSERT INTO ronbtf_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Și DOMNUL i-a spus: Cine a făcut gura omului? Sau cine face pe cel mut, sau pe cel surd, sau pe cel văzător, sau pe cel orb? Oare nu eu, DOMNUL? ");
INSERT INTO ronbtf_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Și acum mergi și voi fi cu gura ta și te voi învăța ce să spui. ");
INSERT INTO ronbtf_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Iar el a spus: O, DOMNUL meu, trimite mesajul te rog, prin mâna aceluia pe care îl vei trimite. ");
INSERT INTO ronbtf_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Și mânia DOMNULUI s-a aprins împotriva lui Moise și a spus: Nu este Aaron levitul fratele tău? Știu că el poate vorbi bine. Și de asemenea, iată, vine să te întâlnească; și când te va vedea, se va bucura în inima sa. ");
INSERT INTO ronbtf_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Și îi vei vorbi și vei pune cuvinte în gura lui; și voi fi cu gura ta și cu gura lui și vă voi învăța ce veți face. ");
INSERT INTO ronbtf_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Și el va fi purtătorul tău de cuvânt către popor; și el va fi, el îți va fi în loc de gură și tu îi vei fi în loc de Dumnezeu. ");
INSERT INTO ronbtf_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Și ia în mâna ta acest toiag, cu care vei face semne. ");
INSERT INTO ronbtf_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Și Moise a mers și s-a întors la Ietro, socrul său, și i-a spus: Te rog, lasă-mă să merg și să mă întorc la frații mei care sunt în Egipt și să văd dacă ei sunt încă în viață. Și Ietro i-a spus lui Moise: Du-te în pace. ");
INSERT INTO ronbtf_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Și DOMNUL i-a spus lui Moise în Madian: Du-te, întoarce-te în Egipt, pentru că toți bărbații care ți-au căutat viața sunt morți. ");
INSERT INTO ronbtf_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Și Moise a luat pe soția sa și fiii săi și i-a așezat pe măgar și s-a întors în țara Egiptului; și Moise a luat toiagul lui Dumnezeu în mâna sa. ");
INSERT INTO ronbtf_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Și DOMNUL i-a spus lui Moise: Când mergi să te întorci în Egipt, vezi ca tu să faci înaintea lui Faraon toate acele minuni pe care le-am pus în mâna ta; dar voi împietri inima lui, ca el să nu lase poporul să plece. ");
INSERT INTO ronbtf_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Și îi vei spune lui Faraon: Astfel spune DOMNUL: Israel este fiul meu, întâiul meu născut; ");
INSERT INTO ronbtf_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Și îți spun: Lasă pe fiul meu să plece ca să îmi servească; și dacă refuzi să îl lași să plece, iată, voi ucide pe fiul tău, pe întâiul tău născut. ");
INSERT INTO ronbtf_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Și s-a întâmplat pe cale, la han, că DOMNUL l-a întâlnit și a căutat să îl ucidă. ");
INSERT INTO ronbtf_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Atunci Sefora a luat o piatră ascuțită și a retezat prepuțul fiului ei și a aruncat-o la picioarele lui și a spus: Cu adevărat tu îmi ești un soț sângeros. ");
INSERT INTO ronbtf_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Așa că el l-a lăsat să meargă, atunci ea a spus: Un soț sângeros ești, din cauza circumciziei. ");
INSERT INTO ronbtf_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Și DOMNUL i-a spus lui Aaron: Du-te în pustie să întâlnești pe Moise. Și a mers și l-a întâlnit în muntele lui Dumnezeu și l-a sărutat. ");
INSERT INTO ronbtf_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Și Moise i-a povestit lui Aaron toate cuvintele DOMNULUI, cel care l-a trimis, și toate semnele pe care el i le-a poruncit. ");
INSERT INTO ronbtf_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Și Moise și Aaron au mers și au adunat pe toți bătrânii copiilor lui Israel; ");
INSERT INTO ronbtf_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Și Aaron a spus toate cuvintele pe care Domnul le-a spus lui Moise și a făcut semnele înaintea ochilor poporului. ");
INSERT INTO ronbtf_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Și poporul a crezut; și când au auzit că DOMNUL a vizitat pe copiii lui Israel și că el a privit la necazul lor, atunci și-au aplecat capetele și s-au închinat. ");
INSERT INTO ronbtf_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Și după aceea Moise și Aaron au intrat și au spus lui Faraon: Astfel spune DOMNUL Dumnezeul lui Israel: Lasă poporul meu să plece, ca să îmi țină o sărbătoare în pustie. ");
INSERT INTO ronbtf_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Și Faraon a spus: Cine este DOMNUL, ca să ascult de vocea lui pentru a lăsa pe Israel să plece? Nu-l cunosc pe DOMNUL, nici nu voi lăsa pe Israel să plece. ");
INSERT INTO ronbtf_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Iar ei au spus: Dumnezeul evreilor s-a întâlnit cu noi; lasă-ne să mergem, te rugăm, într-o călătorie de trei zile în deșert și să sacrificăm DOMNULUI Dumnezeul nostru, ca nu cumva el să cadă asupra noastră cu ciumă sau cu sabie. ");
INSERT INTO ronbtf_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Și împăratul Egiptului le-a spus: Moise și Aaron, de ce eliberați poporul de la muncile lui? Mergeți la poverile voastre. ");
INSERT INTO ronbtf_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Și Faraon a spus: Iată, poporul țării, acum ei sunt mulți și îi faceți să se odihnească de poverile lor. ");
INSERT INTO ronbtf_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Și Faraon a poruncit în aceeași zi asupritorilor poporului și ofițerilor lor, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Să nu mai dați poporului paie pentru a face cărămidă, ca până acum, să meargă ei să își adune paie. ");
INSERT INTO ronbtf_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Și numărul de cărămizi, pe care l-au făcut până acum, să le impuneți; nu scădeți nimic din el, pentru că sunt leneși; de aceea strigă, spunând: Lasă-ne să mergem și să sacrificăm Dumnezeului nostru. ");
INSERT INTO ronbtf_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Îngreunați munca acestor oameni, ca ei să ostenească în ea; și să nu dea atenție la cuvinte deșarte. ");
INSERT INTO ronbtf_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Și asupritorii poporului au ieșit și ofițerii lor și au vorbit poporului, spunând: Astfel spune Faraon: Nu vă voi da paie. ");
INSERT INTO ronbtf_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Mergeți, procurați-vă paie de unde le puteți găsi; totuși nimic din munca voastră nu va fi micșorat. ");
INSERT INTO ronbtf_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Așa că poporul a fost împrăștiat prin toată țara Egiptului să adune miriște în loc de paie. ");
INSERT INTO ronbtf_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Și asupritorii îi grăbeau, spunând: Împliniți muncile voastre, sarcinile voastre zilnice, ca și când erau paie. ");
INSERT INTO ronbtf_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Și ofițerii copiilor lui Israel, pe care asupritorii Faraonului i-au pus peste ei, au fost bătuți și întrebați: Pentru ce nu ați împlinit sarcina voastră în facerea de cărămizi deopotrivă ieri și azi, ca până acum? ");
INSERT INTO ronbtf_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Atunci ofițerii copiilor lui Israel au venit și au strigat la Faraon, spunând: Pentru ce te porți astfel cu servitorii tăi? ");
INSERT INTO ronbtf_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Nu este dat niciun pai servitorilor tăi și ne spun: Faceți cărămizi! Și, iată, servitorii tăi sunt bătuți; dar vina este în propriul tău popor. ");
INSERT INTO ronbtf_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Dar el a spus: Voi sunteți leneși, sunteți leneși; de aceea spuneți: Lasă-ne să mergem și să sacrificăm DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Duceți-vă acum și lucrați; căci nu vi se va da niciun pai, totuși veți da același număr de cărămizi. ");
INSERT INTO ronbtf_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Și ofițerii copiilor lui Israel au văzut că erau într-o situație rea, după ce s-a spus: Nu veți micșora nimic din sarcina voastră zilnică de cărămizi. ");
INSERT INTO ronbtf_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Și l-au întâlnit pe Moise și pe Aaron, care stăteau în picioare pe cale, pe când veneau de la Faraon, ");
INSERT INTO ronbtf_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Și le-au spus: DOMNUL să privească spre voi și să judece; fiindcă ați făcut mirosul nostru să fie detestat în ochii lui Faraon și în ochii servitorilor săi, să pună o sabie în mâna lor pentru a ne ucide. ");
INSERT INTO ronbtf_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Și Moise s-a întors la DOMNUL și a spus: Doamne, pentru ce te-ai purtat atât de rău cu acest popor? De ce oare m-ai trimis? ");
INSERT INTO ronbtf_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Căci de când am venit la Faraon să vorbesc în numele tău, el a făcut rău acestui popor; și nu ai eliberat nicidecum pe poporul tău. ");
INSERT INTO ronbtf_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Atunci DOMNUL i-a spus lui Moise: Acum vei vedea ce îi voi face lui Faraon: căci cu o mână puternică îi va lăsa să plece și cu o mână puternică îi va alunga afară din țara lui. ");
INSERT INTO ronbtf_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Și Dumnezeu i-a vorbit lui Moise și i-a spus: Eu sunt DOMNUL; ");
INSERT INTO ronbtf_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Și m-am arătat lui Avraam, lui Isaac și lui Iacob, prin numele de Dumnezeu Atotputernic, dar prin numele meu IEHOVA nu le-am fost cunoscut. ");
INSERT INTO ronbtf_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Și de asemenea am întemeiat legământul meu cu ei, pentru a le da țara lui Canaan, țara călătoriei lor, în care au fost străini. ");
INSERT INTO ronbtf_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Și de asemenea am auzit geamătul copiilor lui Israel, pe care egiptenii îi țin în robie; și mi-am adus aminte legământul meu. ");
INSERT INTO ronbtf_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","De aceea spune copiilor lui Israel: Eu sunt DOMNUL și vă voi scoate de sub poverile egiptenilor și vă voi scăpa din sclavia lor și vă voi răscumpăra cu braț întins și cu mari judecăți, ");
INSERT INTO ronbtf_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Și vă voi lua la mine ca popor și vă voi fi Dumnezeu; și veți cunoaște că eu sunt DOMNUL Dumnezeul vostru, care vă scoate de sub poverile egiptenilor. ");
INSERT INTO ronbtf_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Și vă voi duce în țara pe care am jurat să o dau lui Avraam, lui Isaac și lui Iacob; și v-o voi da ca moștenire: Eu sunt DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Și Moise a vorbit astfel copiilor lui Israel, dar ei nu au dat ascultare lui Moise din cauza chinului duhului și din cauza robiei crude. ");
INSERT INTO ronbtf_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Intră, vorbește lui Faraon, împăratul Egiptului, ca el să lase pe copiii lui Israel să plece din țara sa. ");
INSERT INTO ronbtf_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Și Moise a vorbit înaintea DOMNULUI, spunând: Iată, copiii lui Israel nu mi-au dat ascultare; cum mă va asculta Faraon pe mine, care sunt al buzelor necircumcise? ");
INSERT INTO ronbtf_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Și DOMNUL le-a vorbit lui Moise și lui Aaron și le-a dat o poruncă pentru copiii lui Israel și pentru Faraon, împăratul Egiptului, pentru a duce pe copiii lui Israel afară din țara Egiptului. ");
INSERT INTO ronbtf_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Aceștia sunt capii caselor părinților lor: Fiii lui Ruben, întâiul născut al lui Israel: Hanoc și Palu Hețron și Carmi; acestea sunt familiile lui Ruben. ");
INSERT INTO ronbtf_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Și fiii lui Simeon: Iemuel și Iamin și Ohad și Iachin și Țohar și Șaul, fiul unei femei canaanite; acestea sunt familiile lui Simeon. ");
INSERT INTO ronbtf_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Și acestea sunt numele fiilor lui Levi, conform cu generațiile lor: Gherșon și Chehat și Merari; și anii vieții lui Levi au fost o sută treizeci și șapte de ani. ");
INSERT INTO ronbtf_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Fiii lui Gherșon: Libni și Șimi, conform cu familiile lor. ");
INSERT INTO ronbtf_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Și fiii lui Chehat: Amram și Ițehar și Hebron și Uziel; și anii vieții lui Chehat au fost o sută treizeci și trei de ani. ");
INSERT INTO ronbtf_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Și fiii lui Merari: Mahli și Muși; acestea sunt familiile lui Levi conform cu generațiile lor. ");
INSERT INTO ronbtf_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Și Amram a luat la el pe Iochebed, sora tatălui său, de soție; și ea i-a născut pe Aaron și pe Moise; și anii vieții lui Amram au fost o sută treizeci și șapte de ani. ");
INSERT INTO ronbtf_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Și fiii lui Ițehar: Core și Nefeg și Zicri. ");
INSERT INTO ronbtf_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Și fiii lui Uziel: Mișael și Elițafan și Zitri. ");
INSERT INTO ronbtf_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Și Aaron a luat la el pe Elișeba, fiica lui Aminadab, sora lui Nașon, de soție; și ea i-a născut pe Nadab și pe Abihu pe Eleazar și pe Itamar. ");
INSERT INTO ronbtf_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Și fiii lui Core: Asir și Elcana și Abiasaf; acestea sunt familiile coreiților. ");
INSERT INTO ronbtf_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Și Eleazar, fiul lui Aaron, a luat la el pe una din fiicele lui Putiel de soție; și ea i-a născut pe Fineas; aceștia sunt capii părinților leviților conform cu familiile lor. ");
INSERT INTO ronbtf_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Aceștia sunt acel Aaron și acel Moise, cărora DOMNUL le-a spus: Scoateți pe copiii lui Israel din țara Egiptului, conform cu oștirile lor. ");
INSERT INTO ronbtf_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Aceștia sunt cei care au vorbit lui Faraon, împăratul Egiptului, să scoată pe copiii lui Israel din Egipt; aceștia sunt acel Moise și acel Aaron. ");
INSERT INTO ronbtf_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Și s-a întâmplat, în ziua când DOMNUL i-a vorbit lui Moise în țara Egiptului, ");
INSERT INTO ronbtf_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Că DOMNUL i-a vorbit lui Moise, spunând: Eu sunt DOMNUL; spune-i lui Faraon, împăratul Egiptului, tot ceea ce îți spun. ");
INSERT INTO ronbtf_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Și Moise a spus înaintea DOMNULUI: Iată, eu sunt al buzelor necircumcise și cum îmi va da ascultare Faraon? ");
INSERT INTO ronbtf_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Și DOMNUL i-a spus lui Moise: Vezi, te-am făcut un dumnezeu pentru Faraon; și Aaron, fratele tău, va fi profetul tău. ");
INSERT INTO ronbtf_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Vei vorbi tot ceea ce îți poruncesc; și Aaron, fratele tău, îi va vorbi lui Faraon, ca el să trimită afară pe copiii lui Israel din țara lui. ");
INSERT INTO ronbtf_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Și voi împietri inima lui Faraon și voi înmulți semnele mele și minunile mele în țara Egiptului. ");
INSERT INTO ronbtf_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Dar Faraon nu vă va da ascultare, ca să pun mâna mea asupra Egiptului și să scot oștirile mele și poporul meu, copiii lui Israel, afară din țara Egiptului prin mari judecăți. ");
INSERT INTO ronbtf_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Și egiptenii vor cunoaște că eu sunt DOMNUL, când întind mâna mea asupra Egiptului și aduc afară copiii lui Israel de printre ei. ");
INSERT INTO ronbtf_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Și Moise și Aaron au făcut precum le-a poruncit DOMNUL, astfel au făcut. ");
INSERT INTO ronbtf_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Și Moise era în vârstă de optzeci de ani și Aaron în vârstă de optzeci și trei de ani când i-au vorbit lui Faraon. ");
INSERT INTO ronbtf_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Și DOMNUL i-a vorbit lui Moise și lui Aaron, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Când Faraon vă va vorbi, spunând: Arătați un miracol pentru voi, atunci să îi spui lui Aaron: Ia-ți toiagul și aruncă-l înaintea lui Faraon și acesta va deveni un șarpe. ");
INSERT INTO ronbtf_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Și Moise și Aaron au intrat la Faraon și au făcut astfel precum DOMNUL poruncise; și Aaron și-a aruncat jos toiagul înaintea lui Faraon și înaintea servitorilor săi și acesta a devenit un șarpe. ");
INSERT INTO ronbtf_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Atunci Faraon de asemenea a chemat înțelepții și vrăjitorii; acum magicienii Egiptului, ei de asemenea au făcut în același fel cu farmecele lor. ");
INSERT INTO ronbtf_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Căci fiecare și-a aruncat jos toiagul și acestea au devenit șerpi; dar toiagul lui Aaron a înghițit toiegele lor. ");
INSERT INTO ronbtf_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Și el a împietrit inima lui Faraon, astfel că el nu le-a dat ascultare; precum DOMNUL spusese. ");
INSERT INTO ronbtf_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Și DOMNUL i-a spus lui Moise: Inima lui Faraon este împietrită, el refuză să lase poporul să plece. ");
INSERT INTO ronbtf_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Du-te la Faraon mâine dimineață; iată, el iese la apă; și vei sta în picioare la malul râului, întâmpinându-l; și ia în mâna ta toiagul care a fost prefăcut în șarpe. ");
INSERT INTO ronbtf_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Și spune-i: DOMNUL Dumnezeul evreilor m-a trimis la tine, zicând: Lasă poporul meu să plece, ca să îmi servească în pustie; și, iată, până acum ai refuzat să asculți. ");
INSERT INTO ronbtf_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Astfel vorbește DOMNUL: În aceasta vei cunoaște că eu sunt DOMNUL: iată, voi lovi cu toiagul care este în mâna mea apele care sunt în râu și ele vor fi prefăcute în sânge. ");
INSERT INTO ronbtf_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Și peștii care sunt în râu vor muri și râul se va împuți; și egiptenii se vor dezgusta să bea apa din râu. ");
INSERT INTO ronbtf_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Și DOMNUL i-a vorbit lui Moise: Spune lui Aaron: Ia-ți toiagul și întinde-ți mâna peste apele Egiptului, asupra pâraielor lor, asupra râurilor lor și asupra iazurilor lor și asupra tuturor bălților lor de apă, ca ele să devină sânge; și ca să fie sânge prin toată țara Egiptului, deopotrivă în vase de lemn și în vase de piatră. ");
INSERT INTO ronbtf_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Și Moise și Aaron au făcut astfel, precum DOMNUL le-a poruncit; și el a ridicat toiagul și a lovit apele care erau în râu, înaintea ochilor lui Faraon și înaintea ochilor servitorilor săi; și toate apele care erau în râu au fost prefăcute în sânge. ");
INSERT INTO ronbtf_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Și peștii care erau în râu au murit; și râul s-a împuțit și egiptenii nu au putut bea din apa din râu; și a fost sânge prin toată țara Egiptului. ");
INSERT INTO ronbtf_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Și magicienii Egiptului au făcut în același fel cu farmecele lor; și inima lui Faraon a fost împietrită, nici nu le-a dat el ascultare; precum DOMNUL spusese. ");
INSERT INTO ronbtf_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Și Faraon s-a întors și a mers în casa lui, dar nici la aceasta nu și-a pus inima. ");
INSERT INTO ronbtf_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Și toți egiptenii au săpat de jur împrejurul râului pentru apă ca să bea, pentru că nu puteau bea din apa din râu. ");
INSERT INTO ronbtf_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Și s-au împlinit șapte zile, după ce DOMNUL lovise râul. ");
INSERT INTO ronbtf_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Și DOMNUL i-a vorbit lui Moise: Du-te la Faraon și spune-i: Astfel vorbește DOMNUL: Lasă poporul meu să plece, ca să îmi servească. ");
INSERT INTO ronbtf_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Și dacă tu refuzi să îi lași să plece, iată, voi lovi tot cuprinsul tău cu broaște; ");
INSERT INTO ronbtf_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Și râul va aduce broaște din abundență, care vor urca și vor veni în casa ta și în camera ta de dormit și pe patul tău și în casa servitorilor tăi și pe poporul tău și în cuptoarele tale și în covețile tale. ");
INSERT INTO ronbtf_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Și broaștele vor urca deopotrivă pe tine și pe poporul tău și pe toți servitorii tăi. ");
INSERT INTO ronbtf_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Și DOMNUL i-a vorbit lui Moise: Spune-i lui Aaron: Întinde-ți mâna cu toiagul tău asupra pâraielor, asupra râurilor și asupra iazurilor și fă să urce broaște asupra țării Egiptului. ");
INSERT INTO ronbtf_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Și Aaron și-a întins mâna asupra apelor Egiptului; și broaștele au urcat și au acoperit țara Egiptului. ");
INSERT INTO ronbtf_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Și magicienii au făcut în același fel cu farmecele lor și au adus broaște asupra țării Egiptului. ");
INSERT INTO ronbtf_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Atunci Faraon a trimis după Moise și Aaron și a spus: Rugați pe DOMNUL ca el să depărteze broaștele de la mine și de la poporul meu; și voi lăsa poporul să plece, ca să sacrifice DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Iar Moise i-a spus lui Faraon: Fălește-te înaintea mea! Când să mă rog pentru tine și pentru servitorii tăi și pentru poporul tău, să distrugă broaștele de la tine și casele tale, ca ele să rămână numai în râu? ");
INSERT INTO ronbtf_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Iar el a spus: Mâine. Iar el a spus: Fie aceasta conform cuvântului tău, ca tu să cunoști că nu este nimeni asemenea DOMNULUI Dumnezeul nostru. ");
INSERT INTO ronbtf_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Și broaștele se vor depărta de la tine și de la casele tale și de la servitorii tăi și de la poporul tău; ele vor rămâne numai în râu. ");
INSERT INTO ronbtf_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Și Moise și Aaron au ieșit de la Faraon; și Moise a strigat către DOMNUL din cauza broaștelor pe care le adusese împotriva lui Faraon. ");
INSERT INTO ronbtf_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Și DOMNUL a făcut conform cuvântului lui Moise; și au murit broaștele din case, din sate și din câmpuri. ");
INSERT INTO ronbtf_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Și ei le-au adunat în grămezi: și țara s-a împuțit. ");
INSERT INTO ronbtf_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Dar când Faraon a văzut că a avut un răgaz și-a împietrit inima și nu le-a dat ascultare; precum DOMNUL spusese. ");
INSERT INTO ronbtf_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Și DOMNUL i-a spus lui Moise: Spune-i lui Aaron: Întinde-ți toiagul și lovește țărâna pământului, ca aceasta să devină păduchi prin toată țara Egiptului. ");
INSERT INTO ronbtf_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Și au făcut astfel. Și Aaron și-a întins mâna cu toiagul său și a lovit țărâna pământului și aceasta a devenit păduchi pe om și pe vită; toată țărâna țării a devenit păduchi prin toată țara Egiptului. ");
INSERT INTO ronbtf_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Și magicienii au făcut în același fel cu farmecele lor ca să aducă păduchi, dar nu au putut, așa că au fost păduchi pe om și pe vită. ");
INSERT INTO ronbtf_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Atunci magicienii i-au spus lui Faraon: Acesta este degetul lui Dumnezeu; și inima lui Faraon s-a împietrit și nu le-a dat ascultare; precum DOMNUL spusese. ");
INSERT INTO ronbtf_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Și DOMNUL i-a spus lui Moise: Scoală-te devreme dimineața și stai în picioare înaintea lui Faraon; iată, el iese la apă; și spune-i: Astfel vorbește DOMNUL: Lasă poporul meu să plece, ca să îmi servească. ");
INSERT INTO ronbtf_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Altfel, dacă tu nu vei lăsa poporul meu să plece, iată, voi trimite roiuri de muște pe tine și pe servitorii tăi și pe poporul tău și în casele tale, și casele egiptenilor vor fi pline de roiuri de muște și de asemenea pământul pe care ei sunt. ");
INSERT INTO ronbtf_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Și voi separa în acea zi ținutul Gosen, în care poporul meu locuiește, astfel că nu vor fi roiuri de muște acolo; pentru ca să cunoști că eu sunt DOMNUL în mijlocul pământului. ");
INSERT INTO ronbtf_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Și voi face o deosebire între poporul meu și poporul tău: mâine va fi acest semn. ");
INSERT INTO ronbtf_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Și DOMNUL a făcut astfel; și a venit un apăsător roi de muște în casa lui Faraon și în casele servitorilor săi și în toată țara Egiptului: țara a fost stricată din cauza roiului de muște. ");
INSERT INTO ronbtf_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Și Faraon a trimis după Moise și Aaron și a spus: Mergeți, sacrificați Dumnezeului vostru în țară. ");
INSERT INTO ronbtf_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Și Moise a spus: Nu se cuvine să facem astfel; căci DOMNULUI Dumnezeul nostru îi vom sacrifica urâciunea egiptenilor; iată, vom sacrifica urâciunea egiptenilor înaintea ochilor lor și nu vor arunca cu pietre în noi? ");
INSERT INTO ronbtf_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Vom merge trei zile de călătorie în pustie și vom sacrifica DOMNULUI Dumnezeul nostru, așa cum el ne-a poruncit. ");
INSERT INTO ronbtf_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Și Faraon a spus: Vă voi lăsa să plecați, ca să sacrificați DOMNULUI Dumnezeul vostru, în pustie; numai să nu mergeți foarte departe. Rugați-vă pentru mine. ");
INSERT INTO ronbtf_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Și Moise a spus: Iată, eu ies de la tine și voi ruga pe DOMNUL ca roiurile de muște să se depărteze de la Faraon, de la servitorii săi și de la poporul său, mâine; dar Faraon să nu se mai poarte înșelător, nelăsând poporul să plece să sacrifice DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Și Moise a ieșit de la Faraon și l-a implorat pe DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Și DOMNUL a făcut conform cuvântului lui Moise; și el a îndepărtat roiurile de muște de la Faraon, de la servitorii săi și de la poporul lui; nu a rămas niciuna. ");
INSERT INTO ronbtf_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Și Faraon și-a împietrit inima și de această dată și a refuzat să lase poporul să plece. ");
INSERT INTO ronbtf_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Atunci DOMNUL i-a spus lui Moise: Intră la Faraon și spune-i: Astfel vorbește DOMNUL Dumnezeul evreilor: Lasă poporul meu să plece ca să îmi servească. ");
INSERT INTO ronbtf_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Căci dacă refuzi să îi lași să plece și îi vei ține pe loc, ");
INSERT INTO ronbtf_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Iată, mâna DOMNULUI este asupra vitelor tale din câmp, asupra cailor, asupra măgarilor, asupra cămilelor, asupra boilor și asupra oilor tale: va fi o ciumă foarte apăsătoare. ");
INSERT INTO ronbtf_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Și DOMNUL va face deosebire între vitele lui Israel și vitele Egiptului, și nu va muri nimic din tot ce este al copiilor lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Și DOMNUL a rânduit un timp cuvenit, spunând: Mâine DOMNUL va face acest lucru în țară. ");
INSERT INTO ronbtf_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Și DOMNUL a făcut acel lucru a doua zi și toate vitele Egiptului au murit, dar din vitele copiilor lui Israel nu a murit niciuna. ");
INSERT INTO ronbtf_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Și Faraon a trimis și, iată, nu a murit niciuna dintre vitele israeliților. Și inima lui Faraon s-a împietrit și nu a lăsat poporul să plece. ");
INSERT INTO ronbtf_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Și DOMNUL le-a spus lui Moise și lui Aaron: Luați-vă mâinile pline cu cenușă din cuptor și Moise să o arunce spre cer înaintea ochilor lui Faraon. ");
INSERT INTO ronbtf_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Și va deveni țărână în toată țara Egiptului și va fi ulcer, răspândindu-se cu bășici pe om și pe vită, prin toată țara Egiptului. ");
INSERT INTO ronbtf_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Și au luat cenușă din cuptor și au stat în picioare înaintea lui Faraon; și Moise a aruncat cenușa în sus spre cer; și aceasta a devenit un ulcer, răspândindu-se cu bășici pe om și pe vită. ");
INSERT INTO ronbtf_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Și magicienii nu au putut sta în picioare înaintea lui Moise din cauza ulcerelor, pentru că ulcerul era peste magicieni și peste toți egiptenii. ");
INSERT INTO ronbtf_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Și DOMNUL a împietrit inima lui Faraon și nu le-a dat ascultare; precum DOMNUL spusese lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Și DOMNUL i-a spus lui Moise: Scoală-te devreme dimineața și stai în picioare înaintea lui Faraon și spune-i: Astfel vorbește DOMNUL Dumnezeul evreilor: Lasă poporul meu să plece, ca să îmi servească. ");
INSERT INTO ronbtf_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Căci de această dată voi trimite toate plăgile mele asupra inimii tale și asupra servitorilor tăi și asupra poporului tău, ca să cunoști că nu este nimeni asemenea mie pe tot pământul. ");
INSERT INTO ronbtf_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Căci acum îmi voi întinde mâna, ca să te lovesc pe tine și poporul tău cu ciumă; și vei fi stârpit de pe pământ. ");
INSERT INTO ronbtf_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Și tocmai pentru această cauză te-am ridicat, ca să îmi arăt în tine puterea, și ca numele meu să fie vestit peste tot pământul. ");
INSERT INTO ronbtf_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Te mai înalți tu însuți împotriva poporului meu, ca să refuzi să îi lași să plece? ");
INSERT INTO ronbtf_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Iată, mâine, pe timpul acesta, voi face să plouă o grindină foarte apăsătoare, așa cum nu a fost în Egipt de la întemeierea lui chiar până acum. ");
INSERT INTO ronbtf_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","De aceea trimite acum și adună vitele tale și tot ceea ce ai în câmp; căci fiecare om și animal care va fi găsit în câmp și nu va fi adus acasă, grindina va cădea peste ei și vor muri. ");
INSERT INTO ronbtf_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Cel ce s-a temut de cuvântul DOMNULUI printre servitorii lui Faraon a pus pe servitorii săi și vitele sale să fugă în case; ");
INSERT INTO ronbtf_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Și cel ce nu a luat în considerare cuvântul DOMNULUI a lăsat pe servitorii săi și vitele sale în câmp. ");
INSERT INTO ronbtf_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Și DOMNUL i-a spus lui Moise: Întinde-ți mâna spre cer, ca să fie grindină în toată țara Egiptului, peste om și peste animal și peste fiecare iarbă din câmp, prin toată țara Egiptului. ");
INSERT INTO ronbtf_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Și Moise și-a întins toiagul spre cer și DOMNUL a trimis tunet și grindină și focul a alergat de-a lungul pământului; și DOMNUL a plouat grindină peste țara Egiptului. ");
INSERT INTO ronbtf_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Astfel a fost grindină și foc amestecat cu grindină, foarte apăsătoare, cum nu a mai fost asemenea în toată țara Egiptului de când a devenit o națiune. ");
INSERT INTO ronbtf_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Și grindina a lovit în toată țara Egiptului tot ce era în câmp, deopotrivă om și animal; și grindina a lovit fiecare iarbă din câmp și a frânt fiecare copac din câmp. ");
INSERT INTO ronbtf_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Numai în ținutul Gosen, unde erau copiii lui Israel, nu a fost grindină. ");
INSERT INTO ronbtf_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Și Faraon a trimis și a chemat pe Moise și Aaron și le-a spus: Eu am păcătuit de această dată; DOMNUL este drept și eu și poporul meu suntem stricați. ");
INSERT INTO ronbtf_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Rugați pe DOMNUL (pentru că este destul) ca să nu mai fie tunete puternice și grindină; și vă voi lăsa să plecați și nu veți mai sta. ");
INSERT INTO ronbtf_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Și Moise i-a spus: Imediat ce voi fi ieșit din cetate, îmi voi întinde mâinile spre DOMNUL; și tunetul va înceta, nici nu va mai fi grindină; ca să știi că pământul este al DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Dar cât despre tine și servitorii tăi, știu că nu vă veți teme de DOMNUL Dumnezeu. ");
INSERT INTO ronbtf_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Și inul și orzul au fost lovite, pentru că orzul era în spic și inul era înflorit. ");
INSERT INTO ronbtf_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Dar grâul și alacul nu s-au stricat, fiindcă nu erau coapte. ");
INSERT INTO ronbtf_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Și Moise a ieșit din cetate de la Faraon și și-a întins mâinile spre DOMNUL; și tunetele și grindina au încetat și ploaia nu a mai fost turnată pe pământ. ");
INSERT INTO ronbtf_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Și când Faraon a văzut că ploaia și grindina și tunetele au încetat, a păcătuit și mai mult și și-a împietrit inima, el și servitorii săi. ");
INSERT INTO ronbtf_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Și inima lui Faraon s-a împietrit și nu a lăsat pe copiii lui Israel să plece; precum DOMNUL vorbise prin Moise. ");
INSERT INTO ronbtf_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Și DOMNUL i-a spus lui Moise: Intră la Faraon, pentru că i-am împietrit inima și inima servitorilor săi, ca să pot arăta aceste semne ale mele înaintea lui; ");
INSERT INTO ronbtf_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Și ca să spui în urechile fiului tău și a fiului fiului tău, ce lucruri am lucrat în Egipt și semnele mele pe care le-am făcut printre ei, ca ei să știe că eu sunt DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Și Moise și Aaron au intrat la Faraon și i-au spus: Astfel vorbește DOMNUL Dumnezeul evreilor: Până când vei refuza să te umilești înaintea mea? Lasă poporul meu să plece, ca să îmi servească. ");
INSERT INTO ronbtf_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Altfel, dacă refuzi să lași poporul meu să plece, iată, mâine voi aduce lăcustele în cuprinsul tău; ");
INSERT INTO ronbtf_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Și ele vor acoperi fața pământului, ca nimeni să nu poată vedea pământul; și ele vor mânca rămășița a ceea ce a scăpat, care ți-a rămas de la grindină, și vor mânca fiecare copac care crește pentru tine din câmp; ");
INSERT INTO ronbtf_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Și ele vor umple casele tale și casele tuturor servitorilor tăi și casele tuturor egiptenilor, ceea ce nici părinții tăi, nici părinții părinților tăi nu au văzut, din ziua de când au fost pe pământ până în această zi. Și s-a întors și a ieșit de la Faraon. ");
INSERT INTO ronbtf_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Și servitorii lui Faraon i-au spus: Până când acest om va fi o cursă pentru noi? Lasă bărbații să plece, ca să servească pe DOMNUL Dumnezeul lor; încă nu știi că Egiptul este distrus? ");
INSERT INTO ronbtf_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Și Moise și Aaron au fost aduși din nou la Faraon; iar el le-a spus: Mergeți, serviți DOMNULUI Dumnezeul vostru; dar cine sunt cei ce vor merge? ");
INSERT INTO ronbtf_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Și Moise a spus: Vom merge cu tinerii noștri și cu bătrânii noștri, cu fiii noștri și cu fiicele noastre, cu turmele noastre și cu cirezile noastre vom merge, pentru că trebuie să ținem o sărbătoare DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Iar el le-a spus: DOMNUL să fie astfel cu voi, precum o să vă las să plecați și micuții voștri; vedeți că răul este înaintea voastră. ");
INSERT INTO ronbtf_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Nu așa: duceți-vă acum, cei ce sunteți bărbați, și serviți DOMNULUI; căci aceasta ați dorit. Și au fost alungați din prezența lui Faraon. ");
INSERT INTO ronbtf_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Și DOMNUL i-a spus lui Moise: Întinde-ți mâna peste țara Egiptului pentru lăcuste, pentru ca ele să urce peste țara Egiptului și să mănânce fiecare iarbă a pământului, tot ce grindina a lăsat. ");
INSERT INTO ronbtf_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Și Moise și-a întins toiagul asupra țării Egiptului și DOMNUL a adus un vânt de est peste țară toată ziua aceea și toată noaptea; și când a fost dimineață, vântul de est a adus lăcustele. ");
INSERT INTO ronbtf_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Și lăcustele au urcat peste toată țara Egiptului și s-au așezat foarte apăsătoare în tot cuprinsul Egiptului; înaintea lor nu au fost astfel de lăcuste ca ele, nici după ele nu vor fi asemenea. ");
INSERT INTO ronbtf_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Căci ele au acoperit fața întregului pământ, așa că țara s-a întunecat; și au mâncat fiecare iarbă a pământului și tot rodul pomilor pe care grindina i-a lăsat; și nu a rămas niciun lucru verde în copaci, sau în ierburile câmpului, prin toată țara Egiptului. ");
INSERT INTO ronbtf_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Atunci Faraon a trimis după Moise și Aaron în grabă și a spus: Eu am păcătuit împotriva DOMNULUI Dumnezeul vostru și împotriva voastră. ");
INSERT INTO ronbtf_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","De aceea acum iartă, te rog, păcatul meu numai de această dată și rugați pe DOMNUL Dumnezeul vostru să îndepărteze de la mine numai această moarte. ");
INSERT INTO ronbtf_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Și a ieșit de la Faraon și l-a implorat pe DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Și DOMNUL a întors un vânt foarte puternic din vest, care a îndepărtat lăcustele și le-a aruncat în Marea Roșie; nu a rămas nicio lăcustă în tot cuprinsul Egiptului. ");
INSERT INTO ronbtf_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Dar DOMNUL a împietrit inima lui Faraon, așa că a refuzat să lase copiii lui Israel să plece. ");
INSERT INTO ronbtf_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Și DOMNUL i-a spus lui Moise: Întinde-ți mâna spre cer, ca să fie întuneric peste țara Egiptului, un întuneric care să poată fi pipăit. ");
INSERT INTO ronbtf_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Și Moise și-a întins mâna spre cer; și a fost întuneric gros în toată țara Egiptului trei zile. ");
INSERT INTO ronbtf_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Nu s-au văzut unul pe altul, nici nu s-a ridicat vreunul din locul lui pentru trei zile; dar toți copiii lui Israel au avut lumină în locuințele lor. ");
INSERT INTO ronbtf_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Și Faraon a chemat pe Moise și a spus: Mergeți, serviți DOMNULUI; numai turmele voastre și cirezile voastre să rămână aici; micuții voștri să meargă de asemenea cu voi. ");
INSERT INTO ronbtf_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Și Moise a spus: Tu trebuie să ne dai de asemenea sacrificii și ofrande arse, ca să sacrificăm DOMNULUI Dumnezeul nostru. ");
INSERT INTO ronbtf_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Vitele noastre de asemenea vor merge cu noi, nicio copită nu va rămâne, pentru că dintre ele trebuie să luăm pentru a servi DOMNULUI Dumnezeul nostru; și nu știm cu ce trebuie să servim pe DOMNUL, până ce nu mergem acolo. ");
INSERT INTO ronbtf_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Dar DOMNUL a împietrit inima lui Faraon, iar el a refuzat să îi lase să plece. ");
INSERT INTO ronbtf_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Și Faraon i-a spus: Du-te de la mine, ia seama la tine însuți; să nu mai vezi fața mea, pentru că în ziua când vei vedea fața mea vei muri. ");
INSERT INTO ronbtf_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Iar Moise a spus: Tu ai vorbit bine, nu voi mai vedea fața ta. ");
INSERT INTO ronbtf_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Și DOMNUL i-a spus lui Moise: Totuși voi aduce încă o plagă peste Faraon și peste Egipt; după aceea vă va lăsa să plecați de aici; când vă va lăsa să plecați, cu adevărat vă va arunca afară de aici de tot. ");
INSERT INTO ronbtf_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Vorbește acum în urechile poporului și fiecare bărbat să împrumute de la vecinul lui și fiecare femeie de la vecina ei, bijuterii de argint și bijuterii de aur. ");
INSERT INTO ronbtf_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Și DOMNUL a dat poporului favoare înaintea ochilor egiptenilor. Mai mult, bărbatul Moise a fost foarte mare în țara Egiptului, înaintea ochilor servitorilor lui Faraon și înaintea ochilor poporului. ");
INSERT INTO ronbtf_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Și Moise a spus: Astfel vorbește DOMNUL: Spre miezul nopții voi ieși în mijlocul Egiptului. ");
INSERT INTO ronbtf_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Și toți întâii născuți în țara Egiptului vor muri, de la întâiul născut al lui Faraon care șade pe tronul lui, chiar până la întâiul născut al servitoarei care este în spatele morii; și toți întâii născuți ai animalelor. ");
INSERT INTO ronbtf_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Și va fi un mare strigăt prin toată țara Egiptului, așa cum nu a fost niciunul asemenea lui, nici nu va mai fi unul asemenea lui. ");
INSERT INTO ronbtf_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Dar împotriva vreunuia dintre copiii lui Israel niciun câine nu își va mișca limba, împotriva omului sau animalului, ca să știți că DOMNUL face deosebire între egipteni și Israel. ");
INSERT INTO ronbtf_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Și toți acești servitori ai tăi vor coborî la mine și mi se vor prosterna, spunând: Ieși afară și tot poporul care te urmează, și după aceasta voi ieși. Și el a ieșit de la Faraon într-o mare mânie. ");
INSERT INTO ronbtf_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Și DOMNUL i-a spus lui Moise: Faraon nu vă va da ascultare, ca minunile mele să fie înmulțite în țara Egiptului. ");
INSERT INTO ronbtf_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Și Moise și Aaron au făcut toate aceste minuni înaintea lui Faraon; și DOMNUL a împietrit inima lui Faraon, ca el să refuze să lase copiii lui Israel să plece din țara sa. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Și DOMNUL le-a spus lui Moise și lui Aaron în țara Egiptului, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Această lună va fi pentru voi începutul lunilor; aceasta va fi prima lună a anului pentru voi. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Vorbiți întregii adunări a lui Israel, spunând: În ziua a zecea a acestei luni își vor lua un miel, fiecare bărbat, conform cu casa părinților lor, un miel pentru o casă; ");
INSERT INTO ronbtf_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Și dacă este casa prea mică pentru acest miel, să îl ia și vecinul său de lângă casa lui conform cu numărul sufletelor; fiecare conform cu mâncarea lui să vă faceți socoteala pentru miel. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Mielul vostru să fie fără cusur, o parte bărbătească de un an; să îl luați dintre oi sau dintre capre; ");
INSERT INTO ronbtf_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Și să îl păstrați până în a paisprezecea zi a lunii acesteia; și întreagă mulțimea adunării lui Israel să îl înjunghie seara. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Și să ia din acest sânge și să lovească sângele pe cei doi ușori și pe pragul de sus al ușii caselor, în care îl vor mânca. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Și să mănânce carnea în acea noapte, friptă cu foc și azime; și cu ierburi amare să îl mănânce. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Nu îl mâncați crud, nici fiert de loc în apă, ci fript cu foc; capul lui cu picioarele lui și cu măruntaiele lui. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Și să nu lăsați nimic să rămână din el până dimineața; și ceea ce rămâne din el până dimineața să îl ardeți cu foc. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Și astfel să îl mâncați; cu coapsele voastre încinse, sandalele voastre în picioarele voastre și toiagul vostru în mâna voastră; și să îl mâncați în grabă; acesta este paștele DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Pentru că voi trece prin țara Egiptului în această noapte și voi lovi pe toți întâii-născuți din țara Egiptului, deopotrivă om și animal; și împotriva tuturor dumnezeilor Egiptului voi face judecată: Eu sunt DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Și sângele vă va fi semn pe casele unde voi sunteți; și când eu văd sângele, voi trece peste voi; și când lovesc țara Egiptului, plaga nu va fi peste voi, ca să vă nimicească. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Și această zi să vă fie pentru amintire; și să o țineți ca sărbătoare DOMNULUI prin toate generațiile voastre; să o țineți ca sărbătoare printr-o rânduială pentru totdeauna. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Șapte zile să mâncați azime; chiar din prima zi să scoateți dospeala afară din casele voastre, pentru că oricine mănâncă pâine dospită din prima zi până în a șaptea zi, acel suflet va fi stârpit din Israel. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Și în prima zi să fie o adunare solemnă sfântă și în a șaptea zi să fie adunare solemnă sfântă pentru voi; niciun fel de lucrare să nu fie făcută în ele, în afară de ceea ce fiecare om trebuie să mănânce, numai aceasta să fie făcută de voi. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Și să țineți sărbătoarea azimelor; căci în chiar această zi eu am scos oștirile voastre din țara Egiptului; de aceea să țineți această zi în generațiile voastre printr-o rânduială pentru totdeauna. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","În prima lună, în a paisprezecea zi a lunii, seara, să mâncați azime, până în a douăzeci și una zi a lunii, seara. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Șapte zile să nu se găsească dospeală în casele voastre, pentru că oricine mănâncă ceea ce este dospit, chiar acel suflet va fi stârpit din adunarea lui Israel, fie el dintre străini, fie născut în țară. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Să nu mâncați nimic dospit; în toate locuințele voastre să mâncați azime. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Atunci Moise a trimis după toți bătrânii lui Israel și le-a spus: Alegeți și luați-vă un miel conform familiilor voastre și înjunghiați paștele. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Și să luați un mănunchi de isop și înmuiați-l în sângele care este în strachină și loviți pragul de sus și cei doi ușori cu sângele care este în strachină; și niciunul din voi să nu iasă la intrarea casei sale până dimineața. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Pentru că DOMNUL va trece să lovească egiptenii; și când vede sângele pe pragul de sus și pe cei doi ușori, DOMNUL va trece peste ușă și nu va permite nimicitorului să intre în casele voastre să lovească. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Și să țineți acest lucru ca rânduială pentru tine și pentru fiii tăi pentru totdeauna. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Și se va întâmpla, când veți fi venit în țara pe care DOMNUL v-o va da, conform cu ce a promis, că veți ține acest serviciu. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Și se va întâmpla, când copiii voștri vă vor spune: Ce înseamnă acest serviciu pentru voi? ");
INSERT INTO ronbtf_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Că voi să spuneți: Acesta este sacrificiul paștelui DOMNULUI, care a trecut peste casele copiilor lui Israel în Egipt, când a lovit egiptenii și a eliberat casele noastre. Și poporul a plecat capul și s-a închinat. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Și copiii lui Israel au plecat și au făcut așa cum DOMNUL poruncise lui Moise și Aaron, astfel au făcut ei. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Și s-a întâmplat, că la miezul nopții, DOMNUL a lovit tot întâiul născut în țara Egiptului, de la întâiul născut al Faraonului, care ședea pe tronul lui, până la întâiul născut al celui captiv care era în închisoare, și tot întâiul născut al vitelor. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Și Faraon s-a sculat noaptea, el și toți servitorii săi și toți egiptenii; și a fost un mare strigăt în Egipt, pentru că nu a fost casă unde să nu fie un mort. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Și el a trimis după Moise și Aaron noaptea și a spus: Ridicați-vă și ieșiți din poporul meu, deopotrivă voi și copiii lui Israel; și mergeți, serviți pe DOMNUL, așa cum ați spus. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","De asemenea luați turmele voastre și cirezile voastre, așa cum ați spus; și plecați; și de asemenea binecuvântați-mă. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Și egiptenii erau stăruitori asupra poporului, ca să îi trimită afară din țară în grabă; căci spuneau: Noi toți vom muri. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Și oamenii au luat aluatul lor înainte ca acesta să fie dospit, covețile lor fiind legate în hainele lor pe umerii lor. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Și copiii lui Israel au făcut conform cuvântului lui Moise; și au luat de la egipteni bijuterii de argint și bijuterii de aur și haine; ");
INSERT INTO ronbtf_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Și DOMNUL a dat poporului favoare înaintea ochilor egiptenilor, așa că le-au împrumutat astfel de lucruri precum au cerut. Și au prădat pe egipteni. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Și copiii lui Israel au călătorit de la Ramses la Sucot, în jur de șase sute de mii, pe jos, care erau bărbați, în afară de copii. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Și o mulțime amestecată s-a urcat de asemenea împreună cu ei; și turme și cirezi, chiar foarte multe vite. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Și au copt turte nedospite din aluatul pe care l-au scos din Egipt, căci acesta nu era dospit, pentru că au fost aruncați afară din Egipt și nu puteau întârzia, nici nu și-au pregătit merinde. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Și locuirea temporară a copiilor lui Israel, care au locuit în Egipt, a fost de patru sute și treizeci de ani. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Și s-a întâmplat la sfârșitul celor patru sute treizeci de ani, în chiar aceeași zi s-a întâmplat, că toate oștirile DOMNULUI au ieșit din țara Egiptului. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Aceasta este o noapte de ținut pentru DOMNUL pentru scoaterea lor din țara Egiptului; aceasta este acea noapte a DOMNULUI pentru a fi ținută de toți copiii lui Israel în generațiile lor. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Și DOMNUL le-a spus lui Moise și lui Aaron: Aceasta este rânduiala paștelui: Niciun străin nu va mânca din ea; ");
INSERT INTO ronbtf_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Dar servitorul fiecăruia care este cumpărat cu bani, după ce l-ai circumcis, atunci va mânca din ea. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Un locuitor temporar și un servitor angajat nu vor mânca din ea. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Într-o singură casă va fi ea mâncată; să nu aduci nimic din acea carne afară din casă; nici să nu îi zdrobiți vreun os. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Toată adunarea lui Israel să o țină. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Și când un străin va locui temporar cu tine și vei ține paștele DOMNULUI, toți cei ai lui de parte bărbătească să fie circumciși și apoi lasă-l să se apropie și să o țină; și va fi ca unul ce este născut în țară: pentru că niciunul necircumcis nu va mânca din ea. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","O singură lege va fi pentru cel născut în țară și pentru străinul ce locuiește temporar printre voi. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Astfel au făcut toți copiii lui Israel; precum DOMNUL poruncise lui Moise și Aaron, așa au făcut. ");
INSERT INTO ronbtf_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Și s-a întâmplat, în chiar aceeași zi, că DOMNUL a scos pe copiii lui Israel din țara Egiptului conform armatelor lor. ");
INSERT INTO ronbtf_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Și DOMNUL i-a spus lui Moise, zicând: ");
INSERT INTO ronbtf_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","Sfințiți-mi pe fiecare întâi născut, pe oricine deschide pântecele printre copiii lui Israel, deopotrivă al omului și al vitei: acesta este al meu. ");
INSERT INTO ronbtf_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Și Moise a spus poporului: Amintiți-vă această zi, în care ați ieșit din Egipt, din casa robiei, pentru că prin tăria mâinii DOMNUL v-a scos din acest loc: nu se va mânca pâine dospită. ");
INSERT INTO ronbtf_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Astăzi ați ieșit în luna Abib. ");
INSERT INTO ronbtf_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Și va fi, când DOMNUL te va aduce în țara canaaniților și a hitiților și a amoriților și a hiviților și a iebusiților, pe care el a jurat părinților tăi să ți-o dea, o țară în care curge lapte și miere, că în această lună vei ține acest serviciu. ");
INSERT INTO ronbtf_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Șapte zile să mănânci azime și în a șaptea zi să fie o sărbătoare pentru DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Azime să fie mâncate șapte zile; și să nu fie văzută pâine dospită la tine, nici nu va fi văzută dospeală cu tine în toate hotarele tale. ");
INSERT INTO ronbtf_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Și să arăți fiului tău în acea zi, spunând: Aceasta se face din cauza a ceea ce DOMNUL mi-a făcut când eu am ieșit afară din Egipt. ");
INSERT INTO ronbtf_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Și aceasta să îți fie ca semn pe mâna ta și pentru o amintire între ochii tăi, ca legea DOMNULUI să fie în gura ta, căci cu mână puternică DOMNUL te-a scos din Egipt. ");
INSERT INTO ronbtf_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","De aceea ține această rânduială la timpul ei din an în an. ");
INSERT INTO ronbtf_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Și va fi, când DOMNUL te va aduce în țara canaaniților, precum a jurat părinților tăi și ți-o va da, ");
INSERT INTO ronbtf_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Că vei pune deoparte pentru DOMNUL tot ceea ce deschide pântecele și fiecare întâi născut care vine de la un animal pe care îl ai; cei de parte bărbătească vor fi ai DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Și pe fiecare întâi născut al unui măgar să îl răscumperi cu un miel; și dacă refuzi să îl răscumperi, atunci să îi rupi gâtul; să îl răscumperi și pe fiecare întâi născut al omului dintre copiii tăi. ");
INSERT INTO ronbtf_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Și va fi, când fiul tău te va întreba în timpul care vine, spunând: Ce este aceasta? Că îi vei zice: DOMNUL ne-a scos cu mână tare din Egipt, din casa robiei: ");
INSERT INTO ronbtf_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Și s-a întâmplat, când Faraon se încăpățâna să ne lase să plecăm, că DOMNUL a ucis pe toți întâii-născuți din țara Egiptului, deopotrivă întâii-născuți ai oamenilor și întâii-născuți ai animalelor; de aceea eu sacrific DOMNULUI tot ceea ce deschide pântecele, fiind de parte bărbătească; dar pe toți întâii-născuți ai copiilor mei îi răscumpăr. ");
INSERT INTO ronbtf_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Și va fi ca semn pe mâna ta și ca fruntarii între ochii tăi; căci prin puterea mâinii DOMNUL ne-a scos din Egipt. ");
INSERT INTO ronbtf_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Și s-a întâmplat, când Faraon a lăsat poporul să plece, că Dumnezeu nu i-a condus pe calea țării filistenilor, deși aceea era aproape; fiindcă Dumnezeu a spus: Nu cumva să se întâmple ca poporul să se pocăiască văzând război și să se întoarcă în Egipt; ");
INSERT INTO ronbtf_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Ci Dumnezeu a condus poporul pe calea pustiei Mării Roșii; și copiii lui Israel au urcat înarmați din Egipt. ");
INSERT INTO ronbtf_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Și Moise a luat oasele lui Iosif cu el, pentru că acesta luase jurământ copiilor lui Israel, spunând: Dumnezeu cu adevărat vă va vizita; și veți urca cu voi oasele mele de aici. ");
INSERT INTO ronbtf_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Și au început călătoria lor de la Sucot și au așezat tabără în Etam, în marginea pustiei. ");
INSERT INTO ronbtf_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Și DOMNUL a mers înaintea lor ziua într-un stâlp de nor, pentru a le conduce calea; și noaptea într-un stâlp de foc, pentru a le dea lumină; pentru a merge zi și noapte; ");
INSERT INTO ronbtf_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","El nu a depărtat stâlpul de nor ziua, nici stâlpul de foc noaptea, dinaintea poporului. ");
INSERT INTO ronbtf_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Și DOMNUL i-a spus lui Moise, zicând: ");
INSERT INTO ronbtf_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Vorbește copiilor lui Israel, să se întoarcă și să își așeze tabăra înainte de Pi-Hahirot, între Migdol și mare, înainte de Baal-Țefon; înaintea acestuia vă veți așeza tabăra, lângă mare. ");
INSERT INTO ronbtf_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Pentru că Faraon va spune despre copiii lui Israel: Ei s-au încurcat în țară, pustia i-a cuprins. ");
INSERT INTO ronbtf_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Și voi împietri inima lui Faraon, astfel că îi va urmări; și voi fi onorat prin Faraon și prin toată oștirea lui; ca Egiptenii să știe că eu sunt DOMNUL. Și au făcut așa. ");
INSERT INTO ronbtf_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Și i s-a spus împăratului Egiptului că poporul a fugit; și inima lui Faraon și a servitorilor săi s-a întors împotriva poporului și au spus: De ce am făcut aceasta, lăsând pe Israel să plece de la servirea noastră? ");
INSERT INTO ronbtf_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Și el și-a pregătit carul și a luat poporul său cu el; ");
INSERT INTO ronbtf_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Și a luat șase sute de care alese și toate carele Egiptului și căpetenii peste fiecare din ele. ");
INSERT INTO ronbtf_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Și DOMNUL a împietrit inima lui Faraon, împăratul Egiptului, și a urmărit pe copiii lui Israel; și copiii lui Israel au ieșit cu mână înaltă. ");
INSERT INTO ronbtf_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Dar Egiptenii i-au urmărit, toți caii și carele lui Faraon și călăreții lui și oștirea lui și i-a ajuns, așezând tabăra lângă mare, în apropiere de Pi-Hahirot, înainte de Baal-Țefon. ");
INSERT INTO ronbtf_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Și când Faraon s-a apropiat, copiii lui Israel și-au ridicat ochii și, iată, egiptenii mărșăluiau după ei; și au fost grozav de înspăimântați; și copiii lui Israel au strigat către DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Și i-au spus lui Moise: Pentru că nu sunt morminte în Egipt ne-ai luat tu pentru a muri în pustie? Pentru ce te-ai purtat astfel cu noi, pentru a ne scoate din Egipt? ");
INSERT INTO ronbtf_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Nu este acesta cuvântul pe care ți l-am spus în Egipt, zicând: Lasă-ne în pace, să servim egiptenilor? Pentru că ar fi fost mai bine să servim egiptenilor, decât să murim în pustie. ");
INSERT INTO ronbtf_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Și Moise a spus poporului: Nu vă temeți, stați liniștiți și veți vedea salvarea DOMNULUI, pe care el v-o va arăta astăzi; căci egiptenii pe care i-ați văzut astăzi, nu îi veți mai vedea niciodată, pentru totdeauna. ");
INSERT INTO ronbtf_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","DOMNUL va lupta pentru voi, dar voi stați liniștiți. ");
INSERT INTO ronbtf_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Și DOMNUL i-a spus lui Moise: Pentru ce strigi către mine? Vorbește copiilor lui Israel să meargă înainte; ");
INSERT INTO ronbtf_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Dar ridică-ți toiagul și întinde-ți mâna peste mare și despic-o; și copiii lui Israel vor merge pe uscat prin mijlocul mării. ");
INSERT INTO ronbtf_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Și eu, iată, eu voi împietri inimile egiptenilor și îi vor urmări; și îmi voi aduce onoare prin Faraon și prin toată oștirea sa, prin carele sale și prin călăreții săi. ");
INSERT INTO ronbtf_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Și egiptenii vor ști că eu sunt DOMNUL, când mi-am adus onoare prin Faraon, prin carele sale și prin călăreții săi. ");
INSERT INTO ronbtf_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Și îngerul lui Dumnezeu, care mergea înaintea taberei lui Israel, s-a mutat și s-a dus în spatele lor; și stâlpul de nor s-a mutat de dinaintea feței lor și a stat în spatele lor; ");
INSERT INTO ronbtf_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Și a venit între tabăra egiptenilor și tabăra lui Israel; și a fost un nor și întuneric pentru ei, dar dădea lumină noaptea pentru aceștia; așa că nu s-au apropiat unii de alții toată noaptea. ");
INSERT INTO ronbtf_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Și Moise și-a întins mâna peste mare; și DOMNUL a făcut ca marea să meargă înapoi printr-un puternic vânt din est toată noaptea aceea și a făcut marea pământ uscat și apele au fost despicate. ");
INSERT INTO ronbtf_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Și copiii lui Israel au mers în mijlocul mării pe pământ uscat; și apele le erau un zid pe partea dreaptă a lor și pe partea stângă a lor. ");
INSERT INTO ronbtf_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Și egiptenii i-au urmărit și au intrat după ei în mijlocul mării, toți caii lui Faraon, carele sale și călăreții săi. ");
INSERT INTO ronbtf_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Și s-a întâmplat, că în garda dimineții, DOMNUL a privit spre oștirea egiptenilor prin stâlpul de foc și de nor și a tulburat oștirea egiptenilor. ");
INSERT INTO ronbtf_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Și a scos roțile de la carele lor, ca ei să le conducă cu greutate; așa că egiptenii au spus: Să fugim de la fața lui Israel, pentru că DOMNUL luptă pentru ei împotriva egiptenilor. ");
INSERT INTO ronbtf_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Și DOMNUL i-a spus lui Moise: Întinde-ți mâna peste mare, ca apele să vină înapoi peste egipteni, peste carele lor și peste călăreții lor. ");
INSERT INTO ronbtf_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Și Moise și-a întins mâna peste mare și marea s-a întors la puterea ei când a apărut dimineața; și egiptenii au fugit de dinaintea acesteia; și DOMNUL a doborât pe egipteni în mijlocul mării. ");
INSERT INTO ronbtf_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Și apele s-au întors și au acoperit carele și călăreții, chiar toată oștirea lui Faraon care a intrat în mare după ei; nu a rămas nici măcar unul dintre ei. ");
INSERT INTO ronbtf_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Dar copiii lui Israel au umblat pe pământ uscat în mijlocul mării; și apele le erau un zid de partea lor dreaptă și de partea lor stângă. ");
INSERT INTO ronbtf_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Astfel DOMNUL a salvat pe Israel în acea zi din mâna egiptenilor; și Israel a văzut egiptenii morți pe țărmul mării. ");
INSERT INTO ronbtf_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Și Israel a văzut acea măreață lucrare pe care DOMNUL a făcut-o asupra egiptenilor; și poporul s-a temut de DOMNUL și l-a crezut pe DOMNUL și pe servitorul său Moise. ");
INSERT INTO ronbtf_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Atunci Moise și copiii lui Israel au cântat această cântare DOMNULUI și au spus, zicând: Voi cânta DOMNULUI, pentru că a triumfat glorios; calul și călărețul lui i-a aruncat în mare. ");
INSERT INTO ronbtf_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","DOMNUL este tăria și cântarea mea și el a devenit salvarea mea; el este Dumnezeul meu și îi voi pregăti o locuință; Dumnezeul tatălui meu și îl voi înălța. ");
INSERT INTO ronbtf_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","DOMNUL este un bărbat de război; DOMNUL este numele său. ");
INSERT INTO ronbtf_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Carele lui Faraon și oștirea lui le-a aruncat în mare; aleșii lui căpetenii de asemenea sunt înecați în Marea Roșie. ");
INSERT INTO ronbtf_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Adâncurile i-au acoperit; s-au scufundat în adâncuri ca o piatră. ");
INSERT INTO ronbtf_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Dreapta ta, DOAMNE, a devenit glorioasă în putere; dreapta ta, DOAMNE, a zdrobit în bucăți dușmanul. ");
INSERT INTO ronbtf_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Și în măreția maiestății tale ai doborât pe cei ce s-au ridicat împotriva ta; ai trimis înainte furia ta, care i-a mistuit ca pe miriște. ");
INSERT INTO ronbtf_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Și cu pufnirea suflării nărilor tale apele s-au adunat, potopurile au stat drept ca o movilă și adâncurile s-au închegat în inima mării. ");
INSERT INTO ronbtf_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Dușmanul a spus: Voi urmări, voi ajunge, voi împărți prada; îmi voi sătura pofta cu ei; îmi voi trage sabia, mâna mea îi va nimici. ");
INSERT INTO ronbtf_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Tu ai suflat cu suflarea ta, marea i-a acoperit; s-au scufundat ca plumb în apele puternice. ");
INSERT INTO ronbtf_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Cine este asemenea ție, DOAMNE, printre dumnezei? Cine este asemenea ție, glorios în sfințenie, înspăimântător în laude, făcând minuni? ");
INSERT INTO ronbtf_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Tu ai întins mâna ta dreaptă, pământul i-a înghițit. ");
INSERT INTO ronbtf_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","În mila ta ai condus poporul pe care l-ai răscumpărat; i-ai călăuzit în puterea ta la sfânta ta locuință. ");
INSERT INTO ronbtf_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Poporul va auzi și se va înspăimânta; întristare îi va apuca pe locuitorii Palestinei. ");
INSERT INTO ronbtf_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Atunci conducătorii Edomului vor fi uimiți; bărbații tari ai Moabului, tremurând îi vor apuca; toți locuitorii din Canaan se vor topi. ");
INSERT INTO ronbtf_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Spaimă și groază va cădea asupra lor; prin măreția brațului tău vor fi muți ca o piatră, până când trece poporul tău, DOAMNE, până când trece poporul, pe care tu l-ai cumpărat. ");
INSERT INTO ronbtf_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Tu îi vei aduce înăuntru și îi vei sădi în muntele moștenirii tale, în locul, DOAMNE, pe care l-ai făcut pentru tine pentru a locui în el, în Sanctuar, DOAMNE, pe care mâinile tale l-au întemeiat. ");
INSERT INTO ronbtf_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","DOMNUL va domni pentru totdeauna și întotdeauna. ");
INSERT INTO ronbtf_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Căci calul lui Faraon a intrat cu carele lui și cu călăreții lui în mare și DOMNUL a adus înapoi apele mării peste ei; dar copiii lui Israel au mers pe pământ uscat în mijlocul mării. ");
INSERT INTO ronbtf_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Și Miriam, profetesa, sora lui Aaron, a luat o tamburină în mâna ei; și toate femeile au ieșit după ea cu tamburine și cu dansuri. ");
INSERT INTO ronbtf_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Și Miriam le-a răspuns: Cântați DOMNULUI, pentru că el a triumfat glorios; calul și călărețul lui i-a aruncat în mare. ");
INSERT INTO ronbtf_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Astfel Moise a adus pe Israel de la Marea Roșie și au ieșit în pustia Șur; și au mers trei zile în pustie și nu au găsit apă. ");
INSERT INTO ronbtf_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Și când au ajuns la Mara, nu puteau bea din apele din Mara, fiindcă erau amare; de aceea i s-a pus numele Mara. ");
INSERT INTO ronbtf_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Și poporul a cârtit împotriva lui Moise, spunând: Ce vom bea? ");
INSERT INTO ronbtf_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Și el a strigat către DOMNUL; și DOMNUL i-a arătat un pom, pe care, când l-a aruncat în ape, apele s-au făcut dulci; acolo le-a făcut un statut și o rânduială și acolo i-a încercat, ");
INSERT INTO ronbtf_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Și a spus: Dacă vei da ascultare cu toată atenția la vocea DOMNULUI Dumnezeul tău și vei face ceea ce este drept înaintea ochilor lui și vei deschide urechea la poruncile lui și vei ține toate statutele lui, nu voi pune peste tine niciuna din aceste boli pe care le-am adus peste egipteni; căci eu sunt DOMNUL care te vindecă. ");
INSERT INTO ronbtf_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Și au ajuns la Elim, unde erau douăsprezece fântâni de apă și șaptezeci de palmieri; și au așezat tabăra acolo lângă ape. ");
INSERT INTO ronbtf_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Și au pornit de la Elim și toată adunarea copiilor lui Israel a ajuns în pustia lui Sin, care este între Elim și Sinai, în a cincisprezecea zi a celei de a doua luni după ieșirea lor din țara Egiptului. ");
INSERT INTO ronbtf_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Și toată adunarea copiilor lui Israel a cârtit împotriva lui Moise și Aaron în pustie; ");
INSERT INTO ronbtf_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Și copiii lui Israel le-au spus: Mai bine am fi murit prin mâna DOMNULUI în țara Egiptului, când stăteam lângă oalele cu carne și când mâncam pâine pe săturate, pentru că ne-ați scos în această pustie să ucideți această toată adunare cu foamete. ");
INSERT INTO ronbtf_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Atunci DOMNUL i-a spus lui Moise: Iată, voi face să plouă pâine din cer pentru voi; și poporul va ieși și va aduna o anumită cantitate în fiecare zi, ca să îi încerc, dacă vor umbla în legea mea, sau nu. ");
INSERT INTO ronbtf_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Și se va întâmpla, că în a șasea zi vor pregăti ceea ce aduc înăuntru; și aceasta va fi de două ori mai mult decât adună zilnic. ");
INSERT INTO ronbtf_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Și Moise și Aaron le-au spus tuturor copiilor lui Israel: Seara, veți cunoaște că DOMNUL v-a scos din țara Egiptului; ");
INSERT INTO ronbtf_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Și dimineața, veți vedea gloria DOMNULUI; pentru aceea că el aude cârtirile voastre împotriva DOMNULUI; și ce suntem noi ca să cârtiți împotriva noastră? ");
INSERT INTO ronbtf_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Și Moise a spus: Când DOMNUL va da carne să mâncați seara și dimineața pâine pe săturate, va fi semn că DOMNUL aude cârtirile voastre pe care le cârtiți împotriva lui; și ce suntem noi? Cârtirile voastre nu sunt împotriva noastră, ci împotriva DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Și Moise i-a zis lui Aaron: Spune întregii adunări a copiilor lui Israel: Apropiați-vă înaintea DOMNULUI; fiindcă el a auzit cârtirile voastre. ");
INSERT INTO ronbtf_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Și s-a întâmplat, pe când Aaron vorbea întregii adunări a copiilor lui Israel, că au privit spre pustie și, iată, gloria DOMNULUI a apărut în nor. ");
INSERT INTO ronbtf_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Și DOMNUL i-a spus lui Moise, zicând: ");
INSERT INTO ronbtf_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","Am auzit cârtirile copiilor lui Israel. Vorbește-le, zicând: Veți mânca seara carne și dimineața veți fi săturați cu pâine; și veți cunoaște că eu sunt DOMNUL Dumnezeul vostru. ");
INSERT INTO ronbtf_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Și s-a întâmplat, că seara prepelițele au venit și au acoperit tabăra; și dimineața roua era întinsă de jur împrejurul oștirii. ");
INSERT INTO ronbtf_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Și după ce roua care era întinsă s-a ridicat, iată, pe fața pustiei era ceva mărunt rotund, mic, precum bruma pe pământ. ");
INSERT INTO ronbtf_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Și când copiii lui Israel au văzut-o, au spus unul altuia: Aceasta este mană, pentru că nu știau ce era. Și Moise le-a spus: Aceasta este pâinea pe care DOMNUL v-a dat-o să mâncați. ");
INSERT INTO ronbtf_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Acesta este lucrul pe care DOMNUL l-a poruncit: Adunați din ea, fiecare conform cu mâncarea lui, un omer pentru fiecare om, conform cu numărul persoanelor voastre; luați fiecare pentru cei care sunt în corturile lui. ");
INSERT INTO ronbtf_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Și copiii lui Israel au făcut așa și au adunat, unii mai mult, unii mai puțin. ");
INSERT INTO ronbtf_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Și când au măsurat-o cu un omer, cel ce adunase mult nu avea nimic peste și cel ce a adunat puțin nu avea lipsă; au adunat fiecare conform cu mâncarea lui. ");
INSERT INTO ronbtf_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Și Moise a spus: Să nu lase nimeni din aceasta până dimineața. ");
INSERT INTO ronbtf_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Totuși nu au dat ascultare lui Moise; ci unii dintre ei au lăsat din aceasta până dimineața și a făcut viermi și s-a împuțit; și Moise s-a înfuriat pe ei. ");
INSERT INTO ronbtf_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Și au adunat-o în fiecare dimineață, fiecare conform cu mâncarea lui; și când soarele se înfierbânta, atunci se topea. ");
INSERT INTO ronbtf_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Și s-a întâmplat, că în a șasea zi au adunat de două ori mai multă pâine, doi omeri pentru un om; și toți conducătorii adunării au venit și i-au spus lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Iar el le-a spus: Aceasta este ceea ce DOMNUL a spus: Mâine este odihna sfântului sabat către DOMNUL; coaceți ceea ce aveți să coaceți astăzi și fierbeți ce aveți să fierbeți; și ce rămâne peste, puneți deoparte pentru voi ca să se păstreze până dimineața. ");
INSERT INTO ronbtf_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Și au pus-o deoparte până dimineața, precum Moise a poruncit; și nu s-a împuțit, nici nu a fost vreun vierme în ea. ");
INSERT INTO ronbtf_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Și Moise a spus: Mâncați-o astăzi; căci astăzi este un sabat către DOMNUL; astăzi nu o veți găsi în câmp. ");
INSERT INTO ronbtf_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Șase zile o veți aduna; dar în ziua a șaptea, care este sabatul, nu va fi nimic în ea. ");
INSERT INTO ronbtf_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Și s-a întâmplat, că au ieșit unii dintre oameni în ziua a șaptea să adune și nu au găsit nimic. ");
INSERT INTO ronbtf_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Și DOMNUL i-a spus lui Moise: Până când veți refuza să țineți poruncile mele și legile mele? ");
INSERT INTO ronbtf_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Vedeți, pentru că DOMNUL v-a dat sabatul, de aceea vă dă în ziua a șasea pâinea pentru două zile; stați fiecare om la locul lui, să nu iasă nimeni din locul lui în ziua a șaptea. ");
INSERT INTO ronbtf_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Așa că poporul s-a odihnit în ziua a șaptea. ");
INSERT INTO ronbtf_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Și casa lui Israel a pus numele acesteia, Mana; și era asemănătoare seminței de coriandru, albă; și gustul era asemănător turtei făcute cu miere. ");
INSERT INTO ronbtf_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Și Moise a spus: Acesta este lucrul pe care DOMNUL îl poruncește: Umpleți un omer cu aceasta pentru a fi păstrată pentru generațiile voastre; ca ei să vadă pâinea cu care v-am hrănit în pustie, când v-am scos din țara Egiptului. ");
INSERT INTO ronbtf_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Și Moise i-a spus lui Aaron: Ia un vas și pune un omer plin cu mană în el și așază-l înaintea DOMNULUI, pentru a fi păstrat pentru generațiile voastre. ");
INSERT INTO ronbtf_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Așa cum DOMNUL a poruncit lui Moise, așa Aaron l-a așezat înaintea Mărturiei, pentru a fi păstrat. ");
INSERT INTO ronbtf_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Și copiii lui Israel au mâncat mana patruzeci de ani, până ce au ajuns într-o țară locuită; au mâncat mană, până ce au ajuns la granițele țării lui Canaan. ");
INSERT INTO ronbtf_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Și un omer este a zecea parte dintr-o efă. ");
INSERT INTO ronbtf_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Și toată adunarea copiilor lui Israel a călătorit de la pustia lui Sin, după călătoriile lor, conform poruncii DOMNULUI, și au așezat tabăra în Refidim; și nu a fost apă pentru popor să bea. ");
INSERT INTO ronbtf_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","De aceea poporul s-a certat cu Moise și a spus: Dă-ne apă să bem. Și Moise le-a zis: De ce vă certați cu mine? Pentru ce îl ispitiți pe DOMNUL? ");
INSERT INTO ronbtf_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Și poporul era însetat de apă acolo; și poporul a cârtit împotriva lui Moise și a spus: Pentru ce ne-ai scos afară din Egipt, ca să ne ucizi pe noi și copiii noștri și vitele noastre, prin sete? ");
INSERT INTO ronbtf_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Și Moise a strigat către DOMNUL, spunând: Ce să fac acestui popor? Ei sunt aproape gata să mă ucidă cu pietre. ");
INSERT INTO ronbtf_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Și DOMNUL i-a spus lui Moise: Du-te înaintea poporului și ia cu tine dintre bătrânii lui Israel; și toiagul tău, cu care ai lovit râul, ia-l în mâna ta și du-te. ");
INSERT INTO ronbtf_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Iată, voi sta înaintea ta acolo, pe stânca din Horeb; și vei lovi stânca și din ea va ieși apă, ca poporul să bea. Și Moise a făcut așa înaintea ochilor bătrânilor lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Și el a pus numele acelui loc, Masa și Meriba, din cauza cerții copiilor lui Israel și din cauză că au ispitit pe DOMNUL, spunând: Este DOMNUL printre noi, sau nu? ");
INSERT INTO ronbtf_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Atunci Amalec a venit și a luptat cu Israel în Refidim. ");
INSERT INTO ronbtf_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Și Moise i-a spus lui Iosua: Alege bărbați pentru noi și ieși, luptă cu Amalec; mâine voi sta în vârful dealului cu toiagul lui Dumnezeu în mâna mea. ");
INSERT INTO ronbtf_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Așa că Iosua a făcut precum Moise i-a spus și a luptat cu Amalec; și Moise, Aaron și Hur s-au urcat până în vârful dealului. ");
INSERT INTO ronbtf_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Și s-a întâmplat, când Moise își ridica mâna, învingea Israel; și când el își lăsa jos mâna, învingea Amalec. ");
INSERT INTO ronbtf_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Dar mâinile lui Moise erau grele; și au luat o piatră și au pus-o sub el, iar el a șezut pe ea; și Aaron și Hur i-au ținut ridicate mâinile, unul pe o parte și celălalt pe cealaltă parte; și mâinile lui au fost neclintite până la apusul soarelui. ");
INSERT INTO ronbtf_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Și Iosua l-a învins pe Amalec și poporul lui cu tăișul sabiei. ");
INSERT INTO ronbtf_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Și DOMNUL i-a spus lui Moise: Scrie aceasta ca amintire într-o carte și repetă în urechile lui Iosua, pentru că voi șterge cu desăvârșire amintirea lui Amalec de sub ceruri. ");
INSERT INTO ronbtf_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Și Moise a zidit un altar și i-a pus numele acestuia Iehova-Nisi; ");
INSERT INTO ronbtf_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Și a spus: Pentru că DOMNUL a jurat că DOMNUL va avea război cu Amalec din generație în generație. ");
INSERT INTO ronbtf_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Când Ietro, preotul din Madian, socrul lui Moise, a auzit despre tot ceea ce Dumnezeu a făcut pentru Moise și pentru Israel, poporul său, și că DOMNUL a scos pe Israel din Egipt, ");
INSERT INTO ronbtf_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Atunci Ietro, socrul lui Moise, a luat pe Sefora, soția lui Moise, după ce el a trimis-o înapoi, ");
INSERT INTO ronbtf_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Și pe cei doi fii ai ei, dintre care numele unuia era Gherșom, pentru că a spus el: Am fost străin într-o țară străină; ");
INSERT INTO ronbtf_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Și numele celuilalt era Eliezer, pentru că Dumnezeul tatălui meu, a spus el, a fost ajutorul meu și m-a eliberat de sabia Faraonului. ");
INSERT INTO ronbtf_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Și Ietro, socrul lui Moise, a venit cu fiii lui și cu soția lui la Moise în pustie, unde își așezase tabăra la muntele lui Dumnezeu; ");
INSERT INTO ronbtf_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Și i-a spus lui Moise: Eu, Ietro, socrul tău, am venit la tine și soția ta și cei doi fii ai ei cu ea. ");
INSERT INTO ronbtf_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Și Moise a ieșit să întâlnească pe socrul său și s-a prosternat și l-a sărutat; și s-au întrebat unul pe celălalt despre bunăstarea lor; și au intrat în cort. ");
INSERT INTO ronbtf_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Și Moise a istorisit socrului său tot ceea ce DOMNUL a făcut lui Faraon și egiptenilor de dragul lui Israel și toată durerea care a venit peste ei pe cale și cum DOMNUL i-a eliberat. ");
INSERT INTO ronbtf_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Și Ietro s-a bucurat pentru toată bunătatea pe care DOMNUL o făcuse lui Israel, pe care el l-a eliberat din mâna egiptenilor. ");
INSERT INTO ronbtf_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Și Ietro a spus: Binecuvântat fie DOMNUL, care te-a eliberat din mâna egiptenilor și din mâna lui Faraon, care a eliberat poporul de sub mâna egiptenilor. ");
INSERT INTO ronbtf_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Acum știu că DOMNUL este mai mare decât toți dumnezeii, pentru că în lucrul în care s-au purtat cu mândrie, el a fost deasupra lor. ");
INSERT INTO ronbtf_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Și Ietro, socrul lui Moise, a luat o ofrandă arsă și sacrificii pentru Dumnezeu, și Aaron a venit și toți bătrânii lui Israel, pentru a mânca pâine cu socrul lui Moise înaintea lui Dumnezeu. ");
INSERT INTO ronbtf_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Și s-a întâmplat, a doua zi, că Moise s-a așezat să judece poporul; și poporul a stat în picioare lângă Moise de dimineața până seara. ");
INSERT INTO ronbtf_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Și când socrul lui Moise a văzut tot ce făcea el poporului, a spus: Ce este acest lucru pe care tu îl faci poporului? De ce șezi tu singur și tot poporul stă în picioare lângă tine de dimineața până seara? ");
INSERT INTO ronbtf_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Și Moise i-a spus socrului său: Deoarece oamenii vin la mine să întrebe pe Dumnezeu; ");
INSERT INTO ronbtf_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Când au ceva de judecat, ei vin la mine; și judec între unul și celălalt și le fac cunoscute statutele lui Dumnezeu și legile lui. ");
INSERT INTO ronbtf_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Și socrul lui Moise i-a spus: Lucrul pe care îl faci nu este bun. ");
INSERT INTO ronbtf_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Cu adevărat te vei epuiza, deopotrivă tu și acest popor care este cu tine, pentru că acest lucru este prea greu pentru tine; nu ești în stare să îl împlinești singur. ");
INSERT INTO ronbtf_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Dă ascultare acum vocii mele, îți voi da sfat și Dumnezeu va fi cu tine: Fii pentru popor înaintea lui Dumnezeu, ca să aduci cauzele lor lui Dumnezeu; ");
INSERT INTO ronbtf_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Și învață-i rânduieli și legi și arată-le calea în care trebuie să umble și lucrarea pe care trebuie să o facă. ");
INSERT INTO ronbtf_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Mai mult, caută din tot poporul bărbați capabili, care se tem de Dumnezeu, bărbați ai adevărului, urând lăcomia; și pune-i peste ei, pentru a fi conducători a mii și conducători a sute, conducători a cincizeci și conducători a zeci; ");
INSERT INTO ronbtf_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Și ei să judece poporul în tot timpul; și să fie, că fiecare lucru mare îl vor aduce la tine, dar fiecare lucru mic îl vor judeca ei; așa va fi mai ușor pentru tine și vor purta povara împreună cu tine. ");
INSERT INTO ronbtf_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Dacă vei face acest lucru și Dumnezeu îți poruncește astfel, atunci vei fi în stare să înduri și tot acest popor va merge de asemenea la locul lui în pace. ");
INSERT INTO ronbtf_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Atunci Moise a dat ascultare vocii socrului său și a făcut tot ce a spus el. ");
INSERT INTO ronbtf_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Și Moise a ales bărbați capabili din tot Israelul și i-a făcut căpetenii peste popor, conducători a mii, conducători a sute, conducători a cincizeci și conducători a zeci. ");
INSERT INTO ronbtf_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Și au judecat poporul în tot timpul, lucrurile grele le aduceau la Moise, dar fiecare lucru mic îl judecau ei înșiși. ");
INSERT INTO ronbtf_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Și Moise a lăsat pe socrul său să plece; și el a plecat pe calea lui în țara sa. ");
INSERT INTO ronbtf_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","În a treia lună după ce copiii lui Israel au ieșit din țara Egiptului, în aceeași zi au ajuns în pustia Sinai. ");
INSERT INTO ronbtf_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Și au plecat din Refidim și au ajuns la deșertul Sinai și au așezat tabăra în pustie; și acolo Israel a așezat tabăra înaintea muntelui. ");
INSERT INTO ronbtf_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Și Moise a urcat la Dumnezeu și DOMNUL l-a chemat de pe munte, spunând: Vorbește astfel casei lui Iacob și spune copiilor lui Israel: ");
INSERT INTO ronbtf_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Ați văzut ce am făcut egiptenilor și cum v-am purtat pe aripi de acvilă și v-am adus la mine. ");
INSERT INTO ronbtf_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Și acum, dacă veți asculta într-adevăr de vocea mea și veți ține legământul meu, atunci voi îmi veți fi un tezaur deosebit, peste toate popoarele, pentru că tot pământul este al meu. ");
INSERT INTO ronbtf_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Și îmi veți fi o împărăție de preoți și o națiune sfântă. Acestea sunt cuvintele pe care le vei spune copiilor lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Și Moise a venit și a trimis după bătrânii poporului și a pus înaintea fețelor lor toate aceste cuvinte pe care DOMNUL i le-a poruncit. ");
INSERT INTO ronbtf_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Și tot poporul a răspuns împreună și a spus: Vom face tot ceea ce a spus DOMNUL. Și Moise a dus înapoi cuvintele poporului la DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Și DOMNUL i-a spus lui Moise: Iată, vin la tine într-un nor gros, ca poporul să audă când vorbesc cu tine și să te creadă pentru totdeauna. Și Moise a spus DOMNULUI cuvintele poporului. ");
INSERT INTO ronbtf_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Și DOMNUL i-a spus lui Moise: Du-te la popor și sfințește-i astăzi și mâine și să își spele hainele, ");
INSERT INTO ronbtf_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Și să fie gata pentru a treia zi, pentru că în a treia zi DOMNUL va coborî înaintea ochilor întregului popor pe muntele Sinai. ");
INSERT INTO ronbtf_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Și pune îngrădiri poporului de jur împrejur, spunând: Luați seama la voi înșivă, să nu urcați pe acest munte, sau să atingeți marginile acestuia, oricine atinge muntele va fi cu adevărat dat la moarte; ");
INSERT INTO ronbtf_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Nicio mână să nu îl atingă, căci va fi cu adevărat ucis cu pietre, sau străpuns; fie vită, fie om, nu va trăi; când trâmbița va suna lung, să se urce până la munte. ");
INSERT INTO ronbtf_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Și Moise a coborât de pe munte la popor și a sfințit poporul; iar ei și-au spălat hainele. ");
INSERT INTO ronbtf_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Și a spus poporului: Fiți pregătiți pentru a treia zi, nu vă apropiați de soțiile voastre. ");
INSERT INTO ronbtf_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Și s-a întâmplat, în a treia zi, dimineața, că au fost tunete și fulgere și un nor gros pe munte și sunetul trâmbiței foarte tare, așa că tot poporul care era în tabără a tremurat. ");
INSERT INTO ronbtf_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Și Moise a scos poporul din tabără pentru a se întâlni cu Dumnezeu; și au stat în picioare la poalele muntelui. ");
INSERT INTO ronbtf_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Și muntele Sinai fumega în întregime, din cauză că DOMNUL a coborât pe el în foc; și fumul lui se ridica asemenea fumului unui cuptor și întregul munte se cutremura grozav. ");
INSERT INTO ronbtf_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Și când sunetul trâmbiței a sunat lung și a crescut tot mai tare și mai tare, Moise a vorbit și Dumnezeu i-a răspuns printr-o voce. ");
INSERT INTO ronbtf_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Și DOMNUL a coborât pe muntele Sinai, pe vârful muntelui; și DOMNUL l-a chemat pe Moise sus pe vârful muntelui; și Moise a urcat. ");
INSERT INTO ronbtf_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Și DOMNUL i-a spus lui Moise: Coboară, poruncește poporului, ca nu cumva să răzbată la DOMNUL pentru a-l privi lung și mulți dintre ei să piară. ");
INSERT INTO ronbtf_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Și preoții de asemenea, care se apropie de DOMNUL, să se sfințească, pentru ca nu cumva DOMNUL să izbucnească asupra lor. ");
INSERT INTO ronbtf_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Și Moise i-a spus DOMNULUI: Poporul nu poate urca la muntele Sinai, pentru că ne-ai poruncit, spunând: Pune îngrădiri împrejurul muntelui și sfințește-l. ");
INSERT INTO ronbtf_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Și DOMNUL i-a spus: Du-te, coboară-te și vei urca, tu și Aaron cu tine; dar nu lăsa preoții și poporul să răzbată pentru a urca la DOMNUL, ca nu cumva el să izbucnească asupra lor. ");
INSERT INTO ronbtf_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Așa că Moise a coborât la popor și le-a vorbit. ");
INSERT INTO ronbtf_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Și Dumnezeu a vorbit toate aceste cuvinte, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Eu sunt DOMNUL Dumnezeul tău, care te-a scos din țara Egiptului, afară din casa robiei. ");
INSERT INTO ronbtf_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Să nu ai alți dumnezei în afară de mine. ");
INSERT INTO ronbtf_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Să nu îți faci niciun chip cioplit, sau vreo asemănare a oricărui lucru care este în cer deasupra, sau care este în pământ dedesubt, sau care este în apa de sub pământ; ");
INSERT INTO ronbtf_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Să nu te prosterni lor, nici să nu le servești, fiindcă eu, DOMNUL Dumnezeul tău, sunt un Dumnezeu gelos, pedepsind nelegiuirea părinților peste copii până la a treia și a patra generație a celor ce mă urăsc; ");
INSERT INTO ronbtf_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Și arătând milă la mii dintre cei ce mă iubesc și țin poruncile mele. ");
INSERT INTO ronbtf_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Să nu iei în deșert numele DOMNULUI Dumnezeul tău, fiindcă DOMNUL nu îl va ține nevinovat pe cel ce ia în deșert numele lui. ");
INSERT INTO ronbtf_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Adu-ți aminte de ziua sabatului, ca să o sfințești. ");
INSERT INTO ronbtf_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Lucrează șase zile și fă toată munca ta, ");
INSERT INTO ronbtf_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Dar a șaptea zi este sabatul DOMNULUI Dumnezeul tău: în ea să nu faci nicio lucrare, nici tu, nici fiul tău, nici fiica ta, nici servitorul tău, nici servitoarea ta, nici vita ta, nici străinul tău care este înăuntrul porților tale; ");
INSERT INTO ronbtf_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Căci în șase zile DOMNUL a făcut cerul și pământul, marea și tot ce este în ele și s-a odihnit în a șaptea zi, pentru aceasta DOMNUL a binecuvântat ziua sabatului și a sfințit-o. ");
INSERT INTO ronbtf_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Onorează pe tatăl tău și pe mama ta, ca zilele tale să fie lungi în țara pe care ți-o dă DOMNUL Dumnezeul tău. ");
INSERT INTO ronbtf_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Să nu ucizi. ");
INSERT INTO ronbtf_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Să nu comiți adulter. ");
INSERT INTO ronbtf_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Să nu furi. ");
INSERT INTO ronbtf_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Să nu aduci mărturie falsă împotriva aproapelui tău. ");
INSERT INTO ronbtf_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Să nu poftești casa aproapelui tău, să nu poftești soția aproapelui tău, nici servitorul lui, nici servitoarea lui, nici boul lui, nici măgarul lui, nici orice lucru care este al aproapelui tău. ");
INSERT INTO ronbtf_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Și tot poporul a văzut tunetele și fulgerele și sunetul trâmbiței și muntele fumegând; și când poporul a văzut acestea, s-au îndepărtat și au stat departe. ");
INSERT INTO ronbtf_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Și i-au spus lui Moise: Vorbește tu cu noi și vom asculta, dar să nu vorbească Dumnezeu cu noi, ca nu cumva să murim. ");
INSERT INTO ronbtf_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Și Moise a spus poporului: Nu vă temeți, pentru că Dumnezeu a venit pentru a vă încerca și ca temerea lui să fie înaintea fețelor voastre, ca să nu păcătuiți. ");
INSERT INTO ronbtf_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Și poporul a stat departe, iar Moise s-a apropiat de întunericul gros unde era Dumnezeu. ");
INSERT INTO ronbtf_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Și DOMNUL i-a spus lui Moise: Astfel să spui copiilor lui Israel: Ați văzut că am vorbit cu voi din cer. ");
INSERT INTO ronbtf_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Nu faceți dumnezei de argint alături de mine, nici să nu vă faceți dumnezei de aur. ");
INSERT INTO ronbtf_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Fă-mi un altar de pământ și sacrifică pe acesta ofrandele tale arse și ofrandele tale de pace, oile tale și boii tăi; în toate locurile unde voi pune amintirea numelui meu voi veni la tine și te voi binecuvânta. ");
INSERT INTO ronbtf_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Și dacă îmi vei face un altar de piatră, să nu îl zidești din piatră cioplită; căci dacă ridici unealta ta asupra acesteia, l-ai profanat. ");
INSERT INTO ronbtf_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Nici nu urca pe trepte la altarul meu, ca să nu fie descoperită goliciunea ta pe acesta. ");
INSERT INTO ronbtf_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Și acestea sunt judecățile pe care le vei pune înaintea lor. ");
INSERT INTO ronbtf_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Dacă tu cumperi un servitor evreu, el va servi șase ani, și în anul al șaptelea va ieși liber pe gratis. ");
INSERT INTO ronbtf_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Dacă a intrat singur, va ieși singur; dacă a fost căsătorit, atunci soția lui va ieși cu el. ");
INSERT INTO ronbtf_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Dacă stăpânul lui i-a dat o soție și ea i-a născut fii sau fiice, soția și copiii ei vor fi ai stăpânului ei, iar el va ieși singur. ");
INSERT INTO ronbtf_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Și dacă servitorul va spune pe față: Iubesc pe stăpânul meu, pe soția mea și pe copiii mei; nu voi ieși liber; ");
INSERT INTO ronbtf_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","Atunci stăpânul lui îl va duce la judecători; de asemenea îl va duce la ușă sau la ușorul ușii; și stăpânul lui să îi găurească urechea cu o sulă; și îi va servi pentru totdeauna. ");
INSERT INTO ronbtf_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Și dacă un bărbat își vinde fiica să fie servitoare, ea nu va ieși așa cum ies servitorii. ");
INSERT INTO ronbtf_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Dacă ea nu place stăpânului ei, care a logodit-o cu el, atunci el o va lăsa să fie răscumpărată; dar nu va avea nicio putere să o vândă unei națiuni străine, fiindcă s-a purtat înșelător cu ea. ");
INSERT INTO ronbtf_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Iar dacă el a logodit-o cu fiul său, el se va purta cu ea după obiceiul fiicelor. ");
INSERT INTO ronbtf_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Iar dacă îi ia o altă soție, mâncarea ei, haina ei și dreptul ei de soție, el nu le va micșora. ");
INSERT INTO ronbtf_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Și dacă nu îi face acestea trei, atunci ea va ieși liberă, fără bani. ");
INSERT INTO ronbtf_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Cel ce lovește un om și acesta moare, să fie cu siguranță dat la moarte. ");
INSERT INTO ronbtf_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Și dacă un bărbat nu stă la pândă, ci Dumnezeu îl dă pe acela în mâna lui, atunci îți voi rândui un loc în care el să fugă. ");
INSERT INTO ronbtf_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Dar dacă un om vine cu intenție asupra aproapelui său ca să îl ucidă cu vicleșug, ia-l de la altarul meu, ca el să moară. ");
INSERT INTO ronbtf_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Și cel ce lovește pe tatăl său, sau pe mama sa, să fie cu siguranță dat la moarte. ");
INSERT INTO ronbtf_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Și cel ce fură un om și îl vinde, sau dacă va fi găsit în mâna lui, să fie cu siguranță dat la moarte. ");
INSERT INTO ronbtf_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Și cel ce blestemă pe tatăl său, sau pe mama sa, să fie cu siguranță dat la moarte. ");
INSERT INTO ronbtf_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Și dacă oamenii se ceartă și unul lovește pe altul cu o piatră, sau cu pumnul și el nu moare, dar cade la pat, ");
INSERT INTO ronbtf_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","Dacă el se ridică din nou și umblă pe afară sprijinit în toiagul său, atunci cel ce l-a lovit va fi achitat; numai că el va plăti pentru timpul lui pierdut și îi va face să fie complet vindecat. ");
INSERT INTO ronbtf_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Și dacă un bărbat lovește pe servitorul său, sau pe servitoarea sa, cu un toiag și acesta moare sub mâna lui, să fie cu siguranță pedepsit. ");
INSERT INTO ronbtf_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Cu toate acestea, dacă el continuă să trăiască o zi sau două, să nu fie pedepsit, pentru că el este banul lui. ");
INSERT INTO ronbtf_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Dacă oamenii se ceartă și rănesc o femeie însărcinată, așa încât rodul ei iese din ea și totuși nu urmează vătămare, el să fie pedepsit cu siguranță, conform cu ceea ce soțul femeii va așeza peste el; și va plăti așa cum judecătorii hotărăsc. ");
INSERT INTO ronbtf_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Și dacă urmează vreo vătămare, atunci vei da viață pentru viață, ");
INSERT INTO ronbtf_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Ochi pentru ochi, dinte pentru dinte, mână pentru mână, picior pentru picior, ");
INSERT INTO ronbtf_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Arsură pentru arsură, rană pentru rană, vânătaie pentru vânătaie. ");
INSERT INTO ronbtf_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Și dacă un om lovește ochiul servitorului său, sau ochiul servitoarei sale, astfel încât acesta piere, îl va lăsa să plece liber pentru ochiul lui. ");
INSERT INTO ronbtf_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Și dacă îi zboară dintele servitorului său, sau dintele servitoarei sale, îl va lăsa să plece liber pentru dintele său. ");
INSERT INTO ronbtf_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Dacă un bou împunge un bărbat sau o femeie, astfel încât ei mor, atunci boul să fie cu siguranță ucis cu pietre iar carnea sa să nu fie mâncată; dar proprietarul boului să fie achitat. ");
INSERT INTO ronbtf_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Dar dacă boul era cunoscut mai demult că împunge cu coarnele lui și i-a fost făcut cunoscut proprietarului, iar acesta nu l-a ținut înăuntru și boul a ucis un bărbat sau o femeie, boul să fie ucis cu pietre și proprietarul lui de asemenea să fie dat la moarte. ");
INSERT INTO ronbtf_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Și dacă i se va impune o sumă de bani, atunci el va da pentru răscumpărarea vieții sale orice îi este impus. ");
INSERT INTO ronbtf_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Fie că boul a împuns un fiu, sau a împuns o fiică, îi va fi făcut conform cu această judecată. ");
INSERT INTO ronbtf_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Dacă boul va împinge un servitor sau o servitoare, proprietarul va da stăpânului lor treizeci de șekeli de argint și boul să fie ucis cu pietre. ");
INSERT INTO ronbtf_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Și dacă un om va deschide o groapă, sau dacă un om va săpa o groapă și nu o acoperă și un bou sau un măgar cade în ea, ");
INSERT INTO ronbtf_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","Proprietarul gropii îl va plăti și va da bani proprietarului acelora; și vita moartă va fi a lui. ");
INSERT INTO ronbtf_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Și dacă boul unui bărbat vatămă boul altuia, astfel încât moare, atunci vor vinde boul viu și vor împărți banii de la el; și boul mort de asemenea ei îl vor împărți. ");
INSERT INTO ronbtf_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Și dacă este cunoscut că acel bou obișnuia să împingă mai demult iar proprietarul lui nu l-a ținut înăuntru, el cu siguranță va plăti bou pentru bou; și boul mort va fi al lui. ");
INSERT INTO ronbtf_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Dacă un bărbat va fura un bou, sau o oaie și îl va ucide, sau îl va vinde; va restitui cinci boi pentru un bou și patru oi pentru o oaie. ");
INSERT INTO ronbtf_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Dacă un hoț este găsit spărgând și este lovit așa că el moare, să nu se verse sânge pentru el. ");
INSERT INTO ronbtf_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Dacă soarele a răsărit deja peste el, să se verse sânge pentru el, pentru că el trebuia să facă restituire deplină; dacă nu are nimic, să fie vândut pentru furtul lui. ");
INSERT INTO ronbtf_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Dacă furtul se găsește încă viu în mâna lui, fie că este bou, sau măgar, sau oaie, să dea înapoi dublu. ");
INSERT INTO ronbtf_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Dacă un bărbat va face ca un câmp sau o vie să fie păscută și va pune în ea animalul lui și îl va paște în câmpul altui om, să facă restituire din ce este cel mai bun în propriul său câmp și din ce este cel mai bun din propria sa vie. ");
INSERT INTO ronbtf_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Dacă izbucnește foc și cuprinde spinii, așa încât clăile de grâne, sau grânele în picioare, sau câmpul ar fi mistuite cu foc, cel ce a aprins focul cu siguranță să facă restituire. ");
INSERT INTO ronbtf_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Dacă un om va da vecinului său bani sau lucruri să le țină și ele sunt furate din casa bărbatului, dacă hoțul este găsit, să plătească dublu. ");
INSERT INTO ronbtf_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Dacă hoțul nu este găsit, atunci stăpânul casei să fie adus la judecători, pentru a se vedea dacă nu a pus mâna sa pe bunurile vecinului său. ");
INSERT INTO ronbtf_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Pentru că orice fel de fărădelege, fie ea pentru bou, pentru măgar, pentru oaie, pentru haină, sau pentru orice lucru pierdut, pe care altul afirmă că este al său, cauza ambelor părți va fi adusă înaintea judecătorilor; și pe cine vor condamna judecătorii, el să plătească dublu vecinului său. ");
INSERT INTO ronbtf_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Dacă un bărbat dă vecinului său un măgar, sau un bou, sau o oaie, sau orice alt animal pentru a-l ține, și acesta moare, sau este vătămat, sau dus, fără ca cineva să vadă, ");
INSERT INTO ronbtf_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Atunci un jurământ al DOMNULUI să fie între cei doi, că nu a pus mâna sa pe bunurile vecinului său; iar proprietarul acestuia să accepte și el să nu plătească. ");
INSERT INTO ronbtf_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Și dacă este furat de la el, să facă restituire proprietarului acestuia. ");
INSERT INTO ronbtf_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Dacă este sfâșiat în bucăți, atunci să îl aducă pentru mărturie și el să nu plătească ceea ce a fost sfâșiat. ");
INSERT INTO ronbtf_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Și dacă un bărbat împrumută ceva de la vecinul lui și acel ceva este vătămat, sau moare, proprietarul acestuia nefiind cu el, cu siguranță să plătească. ");
INSERT INTO ronbtf_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Dar dacă proprietarul acestuia este cu el, el să nu plătească; dacă este un lucru angajat, acesta a venit pentru plata lui. ");
INSERT INTO ronbtf_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Și dacă un bărbat ademenește o fecioară care nu este logodită și se culcă cu ea, cu siguranță el să o înzestreze pentru a fi soția lui. ");
INSERT INTO ronbtf_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Dacă tatăl ei refuză absolut să i-o dea, el să plătească bani corespunzător zestrei fecioarelor. ");
INSERT INTO ronbtf_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Să nu lași o vrăjitoare să trăiască. ");
INSERT INTO ronbtf_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Oricine se culcă cu un animal să fie cu siguranță dat la moarte. ");
INSERT INTO ronbtf_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Cel ce sacrifică oricărui alt dumnezeu, decât numai DOMNULUI, să fie nimicit complet. ");
INSERT INTO ronbtf_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Nu trata rău pe străin, nici nu îl oprima, pentru că și voi ați fost străini în țara Egiptului. ");
INSERT INTO ronbtf_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Să nu chinuiți vreo văduvă sau vreun copil fără tată. ");
INSERT INTO ronbtf_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Dacă îi chinuiți în orice fel și strigă cumva către mine, eu, cu adevărat voi auzi strigătul lor; ");
INSERT INTO ronbtf_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Și furia mea se va încinge și vă voi ucide cu sabia; și soțiile voastre vor fi văduve și copiii voștri vor fi fără tată. ");
INSERT INTO ronbtf_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Dacă împrumuți bani oricărui sărac de lângă tine, din poporul meu, să nu fii pentru el ca un cămătar, nici nu pune peste el camătă. ");
INSERT INTO ronbtf_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Dacă iei cumva haina vecinului tău pentru garanție, returnează-i-o înainte de apusul soarelui, ");
INSERT INTO ronbtf_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Pentru că doar aceasta îi este acoperitoare, îi este haină pentru pielea lui: în ce va dormi el? Și se va întâmpla când strigă către mine, că îl voi auzi, pentru că eu sunt cu har. ");
INSERT INTO ronbtf_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Să nu ocărești dumnezeii, nici să nu blestemi pe conducătorul poporului tău. ");
INSERT INTO ronbtf_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Nu întârzia să oferi din primele tale roade culese și din musturile tale, întâiul născut dintre fiii tăi dă-mi-l mie. ");
INSERT INTO ronbtf_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Tot așa să faci cu boii tăi și cu oile tale: șapte zile să fie cu mama lui; în ziua a opta dă-mi-l mie. ");
INSERT INTO ronbtf_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Și fiți oameni sfinți pentru mine; nu mâncați vreo carne sfâșiată, de fiare în câmp; aruncați-o la câini. ");
INSERT INTO ronbtf_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Să nu ridici vorbire falsă; nu da mâna ta cu cel stricat pentru a fi martor nedrept. ");
INSERT INTO ronbtf_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Să nu urmezi o mulțime pentru a face rău; nici nu vorbi într-o cauză abătându-te după mulți ca să strâmbi judecata, ");
INSERT INTO ronbtf_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Nici nu favoriza un om sărac în cauza lui. ");
INSERT INTO ronbtf_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Dacă întâlnești boul dușmanului tău sau măgarul lui rătăcind, adu-l negreșit înapoi la el. ");
INSERT INTO ronbtf_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Dacă vezi măgarul celui ce te urăște zăcând sub sarcina lui și te-ai feri să îl ajuți, ajută negreșit împreună cu el. ");
INSERT INTO ronbtf_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Să nu strâmbi judecata săracului tău în cauza lui. ");
INSERT INTO ronbtf_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Ține-te departe de orice lucru fals; și pe cel nevinovat și pe cel drept nu îl ucide, pentru că nu voi declara drept pe cel stricat. ");
INSERT INTO ronbtf_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Și nu lua niciun dar, pentru că darul orbește pe cel înțelept și pervertește cuvintele celui drept. ");
INSERT INTO ronbtf_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","De asemenea să nu oprimi pe străin, căci voi știți inima unui străin, întrucât și voi ați fost străini în țara Egiptului. ");
INSERT INTO ronbtf_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Și șase ani să îți semeni pământul și să îi aduni roadele; ");
INSERT INTO ronbtf_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Dar al șaptelea an lasă-l să se odihnească și să stea nelucrat; ca săracii poporului tău să mănânce; și ce lasă ei, animalele câmpului să mănânce. În același fel să faci cu via ta și cu livada ta de măslini. ");
INSERT INTO ronbtf_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Fă lucrarea ta șase zile și în a șaptea zi odihnește-te, ca boul tău și măgarul tău să se poată odihni, și fiul roabei tale și străinul să fie înviorați. ");
INSERT INTO ronbtf_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Și în toate lucrurile pe care vi le-am spus fiți chibzuiți; și nu amintiți numele altor dumnezei, nici să nu fie auzite acestea din gura voastră. ");
INSERT INTO ronbtf_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","De trei ori pe an ține-mi o sărbătoare. ");
INSERT INTO ronbtf_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Ține sărbătoarea azimelor (să mănânci azimă șapte zile, așa cum ți-am poruncit, în timpul rânduit al lunii Abib; căci în această lună ai ieșit din Egipt; și nimeni să nu se arate înaintea mea cu mâna goală); ");
INSERT INTO ronbtf_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Și sărbătoarea secerișului, primele roade ale ostenelilor tale, pe care le-ai semănat în câmp; și sărbătoarea culesului, care este la sfârșitul anului, după ce ai adunat ostenelile tale din câmp. ");
INSERT INTO ronbtf_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","De trei ori pe an toți cei de parte bărbătească să se prezinte înaintea Domnului DUMNEZEU. ");
INSERT INTO ronbtf_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Să nu oferi sângele sacrificiului meu cu pâine dospită; nici grăsimea sacrificiului meu să nu rămână până dimineața. ");
INSERT INTO ronbtf_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Primul dintre primele roade ale pământului tău, să-l aduci în casa DOMNULUI Dumnezeul tău. Să nu fierbi un ied în laptele mamei lui. ");
INSERT INTO ronbtf_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Iată, trimit un Înger înaintea ta, pentru a te ține pe cale și pentru a te aduce în locul pe care l-am pregătit. ");
INSERT INTO ronbtf_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Ia seama la el și ascultă de vocea lui; nu îl provoca, fiindcă el nu va ierta fărădelegile voastre, pentru că numele meu este în el. ");
INSERT INTO ronbtf_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Dar dacă într-adevăr vei asculta de vocea lui și vei face tot ceea ce eu voi spune, atunci voi fi dușman dușmanilor tăi și potrivnic potrivnicilor tăi. ");
INSERT INTO ronbtf_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Pentru că Îngerul meu va merge înaintea ta și te va duce în țara amoriților și hitiților și periziților și canaaniților, hiviților și iebusiților, și îi voi stârpi. ");
INSERT INTO ronbtf_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Să nu te prosterni înaintea dumnezeilor lor, nici să nu le servești, nici să nu faci conform lucrării lor, ci dărâmă-i complet și sparge idolii lor în întregime. ");
INSERT INTO ronbtf_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Și veți servi DOMNULUI Dumnezeul vostru și el va binecuvânta pâinea ta și apa ta; și voi înlătura boala din mijlocul tău. ");
INSERT INTO ronbtf_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Nimic nu își va lepăda pruncii, nici nu vor fi sterpe în țara ta; numărul zilelor tale îl voi împlini. ");
INSERT INTO ronbtf_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Voi trimite frica mea înaintea ta și voi nimici toate popoarele la care vei ajunge și voi face pe toți dușmanii tăi să își întoarcă spatele spre tine. ");
INSERT INTO ronbtf_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Și voi trimite viespi înaintea ta, care vor alunga pe hivit, pe canaanit și pe hitit, de dinaintea ta. ");
INSERT INTO ronbtf_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Nu îi voi alunga de dinaintea ta într-un an, ca nu cumva țara să devină pustie și fiarele câmpului să se înmulțească împotriva ta. ");
INSERT INTO ronbtf_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Puțin câte puțin îi voi alunga de dinaintea ta, până când te vei fi înmulțit și vei moșteni pământul. ");
INSERT INTO ronbtf_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Și voi așeza granițele tale de la Marea Roșie până la marea filistenilor și de la deșert până la râu, căci voi preda pe locuitorii acelui pământ în mâna voastră, ca să îi alungi de dinaintea ta. ");
INSERT INTO ronbtf_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Nu fă legământ cu ei, nici cu dumnezeii lor. ");
INSERT INTO ronbtf_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Nu vor locui în țara ta, ca nu cumva să te facă să păcătuiești împotriva mea; căci dacă servești dumnezeii lor, cu adevărat aceasta va fi o cursă pentru tine. ");
INSERT INTO ronbtf_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Și i-a spus lui Moise: Urcă la DOMNUL, tu și Aaron, Nadab și Abihu și șaptezeci dintre bătrânii lui Israel; și închinați-vă de departe. ");
INSERT INTO ronbtf_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Și Moise singur să se apropie de DOMNUL; dar ei să nu se apropie; nici poporul să nu se urce cu el. ");
INSERT INTO ronbtf_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Și Moise a venit și a spus poporului toate cuvintele DOMNULUI și toate judecățile; și tot poporul a răspuns cu o singură voce și a zis: Vom face toate cuvintele pe care DOMNUL le-a spus. ");
INSERT INTO ronbtf_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Și Moise a scris toate cuvintele DOMNULUI și s-a sculat devreme dimineața și a zidit un altar sub deal, și douăsprezece stâlpi, conform celor douăsprezece triburi ale lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Și el a trimis bărbați tineri dintre copiii lui Israel, care au oferit ofrande arse și au sacrificat DOMNULUI ofrande de pace cu boi. ");
INSERT INTO ronbtf_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Și Moise a luat jumătate din sânge și l-a pus în vase; și jumătate din sânge l-a stropit pe altar. ");
INSERT INTO ronbtf_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Și a luat cartea legământului și a citit în auzul poporului, iar ei au spus: Vom face tot ceea ce DOMNUL a spus și vom asculta de el. ");
INSERT INTO ronbtf_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Și Moise a luat sângele și l-a stropit peste popor și a spus: Iată, sângele legământului, pe care DOMNUL l-a făcut cu voi, referitor la aceste cuvinte. ");
INSERT INTO ronbtf_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Atunci Moise și Aaron, Nadab și Abihu și șaptezeci dintre bătrânii lui Israel au urcat, ");
INSERT INTO ronbtf_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Și au văzut pe Dumnezeul lui Israel; și era sub picioarele lui ca o lucrare pavată din safir, precum este trupul cerului în claritatea sa. ");
INSERT INTO ronbtf_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Și peste nobilii copiilor lui Israel el nu și-a pus mâna; ei de asemenea au văzut pe Dumnezeu și au mâncat și au băut. ");
INSERT INTO ronbtf_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Și DOMNUL i-a spus lui Moise: Urcă la mine, pe munte, și fii acolo și îți voi da table de piatră și o lege și porunci pe care le-am scris; ca să îi înveți. ");
INSERT INTO ronbtf_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Și Moise s-a ridicat și servitorul său Iosua; și Moise a urcat pe muntele lui Dumnezeu. ");
INSERT INTO ronbtf_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Și a spus bătrânilor: Rămâneți aici pentru noi, până ce ne întoarcem la voi; și, iată, Aaron și Hur sunt cu voi; dacă vreun bărbat va avea anumite chestiuni de făcut, să vină la ei. ");
INSERT INTO ronbtf_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Și Moise a urcat pe munte și un nor a acoperit muntele. ");
INSERT INTO ronbtf_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Și gloria DOMNULUI a locuit peste muntele Sinai și norul l-a acoperit șase zile; și în a șaptea zi, el l-a chemat pe Moise din mijlocul norului. ");
INSERT INTO ronbtf_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Și vederea gloriei DOMNULUI era ca un foc mistuitor pe vârful muntelui înaintea ochilor copiilor lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Și Moise a intrat în mijlocul norului și s-a urcat pe munte; și Moise a fost pe munte patruzeci de zile și patruzeci de nopți. ");
INSERT INTO ronbtf_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Vorbește copiilor lui Israel, ca să îmi aducă un dar: de la fiecare bărbat care îl dă cu voia inimii sale, să luați darul pentru mine. ");
INSERT INTO ronbtf_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Și acesta este darul pe care să îl luați de la ei: aur și argint și aramă, ");
INSERT INTO ronbtf_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","Și material albastru și purpuriu și stacojiu și in subțire și păr de capre, ");
INSERT INTO ronbtf_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","Și piei de berbeci vopsite în roșu și piei de bursuci și lemn de salcâm, ");
INSERT INTO ronbtf_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","Untdelemn pentru lumină, mirodenii pentru untdelemnul pentru ungere și pentru tămâie dulce. ");
INSERT INTO ronbtf_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Pietre de onix și pietre pentru a fi așezate în efod și în pieptar. ");
INSERT INTO ronbtf_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Și ei să îmi facă un sanctuar, ca să locuiesc printre ei. ");
INSERT INTO ronbtf_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Conform cu tot ceea ce îți arăt, după modelul tabernacolului și după modelul tuturor uneltelor din el, chiar așa să îl faceți. ");
INSERT INTO ronbtf_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Și ei să facă un chivot din lemn de salcâm; doi coți și jumătate să fie lungimea lui și un cot și jumătate să fie lărgimea lui și un cot și jumătate înălțimea lui. ");
INSERT INTO ronbtf_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Și îmbracă-l cu aur pur; pe dinăuntru și pe dinafară să-l plachezi și fă peste el o coroană de aur de jur împrejurul lui. ");
INSERT INTO ronbtf_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Și toarnă patru inele de aur pentru el și pune-le în cele patru colțuri ale lui; și două inele vor fi într-una din părțile lui și două inele vor fi în cealaltă parte a lui. ");
INSERT INTO ronbtf_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Și fă drugi din lemn de salcâm și îmbracă-i cu aur. ");
INSERT INTO ronbtf_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Și pune drugii în inele pe părțile laterale ale chivotului, ca să fie purtat cu ei chivotul. ");
INSERT INTO ronbtf_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Drugii vor fi în inelele chivotului; ei nu vor fi scoși din el. ");
INSERT INTO ronbtf_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Și pune în chivot mărturia pe care eu ți-o voi da. ");
INSERT INTO ronbtf_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Și să faci un șezământ al milei din aur pur; doi coți și jumătate să fie lungimea lui și un cot și jumătate lărgimea lui. ");
INSERT INTO ronbtf_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Și să faci doi heruvimi din aur; fă-i din lucrare bătută, la cele două capete ale șezământului milei. ");
INSERT INTO ronbtf_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Și să faci un heruvim la un capăt și alt heruvim la celălalt capăt; chiar la capetele șezământului milei să faceți heruvimii pe cele două capete ale lui. ");
INSERT INTO ronbtf_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Și heruvimii să își întindă aripile deasupra, acoperind șezământul milei cu aripile lor și fețele lor să privească una la cealaltă; spre șezământul milei să fie îndreptate fețele lor. ");
INSERT INTO ronbtf_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Și să pui șezământul milei deasupra, peste chivot; și în chivot să pui mărturia pe care eu ți-o voi da. ");
INSERT INTO ronbtf_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Și acolo mă voi întâlni cu tine și voi vorbi îndeaproape cu tine de deasupra șezământului milei, dintre cei doi heruvimi care sunt peste chivotul mărturiei, despre toate lucrurile pe care ți le voi da în poruncă pentru copiii lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Fă de asemenea o masă din lemn de salcâm; doi coți să fie lungimea ei și un cot să fie lățimea ei și un cot și jumătate înălțimea ei. ");
INSERT INTO ronbtf_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Și să o îmbraci cu aur pur și să faci o coroană de aur de jur împrejurul ei. ");
INSERT INTO ronbtf_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Și să faci acesteia o margine de o palmă de jur împrejur și să faci o coroană de aur marginii acesteia jur împrejurul ei. ");
INSERT INTO ronbtf_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Și să faci pentru ea patru inele de aur și pune inelele în cele patru colțuri care sunt la cele patru picioare ale ei. ");
INSERT INTO ronbtf_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Inelele să fie puse lângă marginea ei, ca locuri pentru drugii care poartă masa. ");
INSERT INTO ronbtf_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Și să faci drugii din lemn de salcâm și să îi îmbraci cu aur, ca masa să fie purtată cu ei. ");
INSERT INTO ronbtf_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Și să faci vasele acesteia și lingurile ei și bolurile ei și capacele ei cu care să le acopere; fă-le din aur pur. ");
INSERT INTO ronbtf_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Și pune pe masă pâinile punerii înainte, pentru a fi înaintea mea întotdeauna. ");
INSERT INTO ronbtf_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Și fă un sfeșnic din aur pur; din lucrare bătută să fie făcut sfeșnicul; stâlpul lui și brațele lui, bolurile lui, butonii lui și florile lui, să fie din aceeași lucrare bătută. ");
INSERT INTO ronbtf_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Și șase brațe vor ieși din laturile acestuia; trei brațe ale sfeșnicului dintr-o parte a lui și trei brațe ale sfeșnicului din cealaltă parte; ");
INSERT INTO ronbtf_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Trei boluri făcute asemenea migdalelor, cu un nod și o floare pe un braț; și trei boluri făcute asemenea migdalelor pe celălalt braț, cu un nod și o floare; astfel să fie făcute pe cele șase brațe care ies din sfeșnic. ");
INSERT INTO ronbtf_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Și pe sfeșnic să fie patru boluri făcute asemenea migdalelor, cu nodurile lor și florile lor. ");
INSERT INTO ronbtf_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Și să fie un nod sub două brațe ale acestuia și un nod sub două brațe ale acestuia și un nod sub două brațe ale acestuia, conform celor șase brațe care ies din sfeșnic. ");
INSERT INTO ronbtf_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Nodurile lor și brațele lor să fie din el; toate acestea să fie o singură lucrare bătută din aur pur. ");
INSERT INTO ronbtf_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Și să faci cele șapte lămpi ale lui; și să aprindă lămpile lui, ca ele să lumineze înaintea lui. ");
INSERT INTO ronbtf_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Și mucările lui și cenușarele lui să fie din aur pur. ");
INSERT INTO ronbtf_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Dintr-un talant de aur pur să îl facă, cu toate aceste vase. ");
INSERT INTO ronbtf_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Și vezi să le faci după modelul lor, care ți-a fost arătat pe munte. ");
INSERT INTO ronbtf_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Mai mult, să faci tabernacolul cu zece covoare din in subțire răsucit și albastru și purpuriu și stacojiu: să le faci cu heruvimi de lucrătură iscusită. ");
INSERT INTO ronbtf_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Lungimea primului covor să fie de douăzeci și opt de coți și lățimea unui covor de patru coți; și fiecare dintre covoare să fie de o singură măsură. ");
INSERT INTO ronbtf_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Cele cinci covoare să fie prinse unul cu altul; și celelalte cinci covoare să fie prinse unul cu altul. ");
INSERT INTO ronbtf_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Și să faci cheutori din albastru pe marginea primului covor, pe marginea îmbinării cu celălalt; și să faci la fel de la marginea din capăt a unui alt covor, în îmbinarea cu următorul. ");
INSERT INTO ronbtf_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Cincizeci de cheutori să faci în primul covor și cincizeci de cheutori să faci în marginea covorului următor cu care este în îmbinare, astfel încât cheutorile să se apuce una pe alta. ");
INSERT INTO ronbtf_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Și să faci cincizeci de copci de aur și să prinzi covoarele împreună cu copcile: și să fie un singur tabernacol. ");
INSERT INTO ronbtf_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Și să faci covoare din păr de capre ca să fie un acoperământ peste tabernacol: să faci unsprezece covoare. ");
INSERT INTO ronbtf_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Lungimea primului covor să fie de treizeci de coți și lățimea primului covor să fie de patru coți: și cele unsprezece covoare să fie toate de o singură măsură. ");
INSERT INTO ronbtf_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Și să prinzi între ele cinci covoare; și șase covoare între ele și îndoaie al șaselea covor pe partea dinainte a tabernacolului. ");
INSERT INTO ronbtf_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Și să faci cincizeci de cheutori pe marginea primului covor care este cel mai îndepărtat în îmbinare și cincizeci de cheutori pe marginea covorului care se îmbină cu următorul. ");
INSERT INTO ronbtf_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Și să faci cincizeci de copci de aramă și pune copcile în cheutori și prinde cortul împreună, ca să fie unul. ");
INSERT INTO ronbtf_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Și rămășița care rămâne din covoarele cortului, jumătatea de covor care rămâne, să atârne peste partea din spate a tabernacolului. ");
INSERT INTO ronbtf_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Și un cot pe o parte și un cot pe partea cealaltă pe lungimea covoarelor cortului, să atârne peste părțile laterale ale tabernacolului, de o parte și de cealaltă, ca să îl acopere. ");
INSERT INTO ronbtf_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Și să faci un acoperământ pentru tabernacol din piei de berbec vopsite roșu și un acoperământ deasupra lui din piei de bursuc. ");
INSERT INTO ronbtf_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Și să faci scânduri pentru tabernacol din lemn de salcâm puse în picioare. ");
INSERT INTO ronbtf_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Zece coți să fie lungimea unei scânduri și un cot și jumătate să fie lățimea unei scânduri. ");
INSERT INTO ronbtf_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Două cepuri să fie într-o scândură, așezate în ordine unul în dreptul altuia: astfel să faci la toate scândurile tabernacolului. ");
INSERT INTO ronbtf_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Și să faci scândurile tabernacolului: douăzeci de scânduri pe partea de sud, spre sud. ");
INSERT INTO ronbtf_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Și fă patruzeci de socluri de argint sub cele douăzeci de scânduri; două socluri sub o singură scândură pentru cele două mânere ale ei și două socluri sub o altă scândură pentru cele două mânere ale ei. ");
INSERT INTO ronbtf_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Și pentru partea următoare a tabernacolului, pe partea de nord, să fie douăzeci de scânduri; ");
INSERT INTO ronbtf_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Și cele patruzeci de socluri ale lor de argint: două socluri sub o singură scândură și două socluri sub o altă scândură. ");
INSERT INTO ronbtf_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Și pentru părțile de vest ale tabernacolului să faci șase scânduri. ");
INSERT INTO ronbtf_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Și să faci două scânduri pentru colțurile tabernacolului pe cele două părți. ");
INSERT INTO ronbtf_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Și să fie prinse împreună dedesubt și ele să fie prinse împreună deasupra capătului acestuia într-un singur inel: astfel să fie pentru ambele; ele să fie pentru cele două colțuri. ");
INSERT INTO ronbtf_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Și să fie opt scânduri și soclurile lor de argint, șaisprezece socluri: două socluri sub o singură scândură și două socluri sub o altă scândură. ");
INSERT INTO ronbtf_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Și să faci drugi de lemn de salcâm; cinci pentru scândurile dintr-o parte a tabernacolului, ");
INSERT INTO ronbtf_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","Și cinci drugi pentru scândurile celeilalte părți a tabernacolului și cinci drugi pentru scândurile părții tabernacolului, pentru cele două părți dinspre vest. ");
INSERT INTO ronbtf_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Și drugul din mijloc în mijlocul scândurilor va ajunge de la un capăt la celălalt. ");
INSERT INTO ronbtf_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Și să îmbraci scândurile cu aur și să faci inelele lor de aur pentru locurile pentru drugi; și să plachezi drugii cu aur. ");
INSERT INTO ronbtf_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Și să ridici tabernacolul conform modelului său care ți-a fost arătat pe munte. ");
INSERT INTO ronbtf_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Și să faci o perdea din albastru și purpuriu și stacojiu și in subțire răsucit de lucrătură iscusită, cu heruvimi să fie aceasta făcută. ");
INSERT INTO ronbtf_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Și să o atârni pe patru coloane de lemn de salcâm placate cu aur; cârligele lor să fie din aur, pe patru socluri de argint. ");
INSERT INTO ronbtf_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Și să atârni perdeaua sub copci, ca să aduci acolo înăuntrul perdelei chivotul mărturiei; și perdeaua vă va separa locul sfânt de cel preasfânt. ");
INSERT INTO ronbtf_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Și să pui șezământul milei peste chivotul mărturiei în locul preasfânt. ");
INSERT INTO ronbtf_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Și să așezi masa în afara perdelei și sfeșnicul în fața mesei pe partea tabernacolului care este spre sud; și să pui masa pe partea de nord. ");
INSERT INTO ronbtf_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Și să faci o perdea pentru ușa cortului, albastră și purpurie și stacojie și din in subțire răsucit, lucrată cu broderie. ");
INSERT INTO ronbtf_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Și să faci pentru perdea cinci stâlpi de lemn de salcâm și să îi îmbraci cu aur și cârligele lor să fie de aur; și să torni cinci socluri de aramă pentru ei. ");
INSERT INTO ronbtf_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Și să faci un altar din lemn de salcâm, lung de cinci coți și lat de cinci coți; altarul să fie pătrat, și înălțimea lui să fie de trei coți. ");
INSERT INTO ronbtf_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Și să faci coarnele acestuia pe cele patru colțuri ale lui: coarnele lui să fie din aceeași bucată; și să-l îmbraci cu aramă. ");
INSERT INTO ronbtf_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Și să îi faci căldările ca să îi scoată cenușa și lopețile lui și oalele lui și cârligele lui pentru carne și tigăile lui: să îi faci toate vasele de aramă. ");
INSERT INTO ronbtf_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Și să îi faci acestuia un grătar de aramă în formă de rețea; și pe rețeaua lui fă-i patru inele de aramă în cele patru colțuri ale lui. ");
INSERT INTO ronbtf_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Și să-l pui sub marginea de sus a altarului pe de dedesubt, ca grătarul să fie chiar la mijlocul altarului. ");
INSERT INTO ronbtf_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Și să faci drugi pentru altar, drugi de lemn de salcâm și să îi îmbraci cu aramă. ");
INSERT INTO ronbtf_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Și drugii să fie puși în inele și drugii să fie pe cele două părți ale altarului, pentru a-l purta. ");
INSERT INTO ronbtf_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Fă-l din scânduri, gol pe dinăuntru; așa cum ți-a fost arătat pe munte, așa să îl facă. ");
INSERT INTO ronbtf_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Și să faci curtea tabernacolului: pentru partea de sud spre sud, vor fi perdele pentru curte de in subțire răsucit cu lungime de o sută de coți pentru o parte; ");
INSERT INTO ronbtf_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Și cei douăzeci de stâlpi ai lor și cele douăzeci de socluri ale lor să fie din aramă; cârligele stâlpilor și vergelele lor să fie de argint. ");
INSERT INTO ronbtf_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Și la fel de-a lungul părții de nord să fie perdele cu lungime de o sută de coți și cei douăzeci de stâlpi ale acesteia și cele douăzeci de socluri ale lor, de aramă; cârligele stâlpilor și vergelele lor de argint. ");
INSERT INTO ronbtf_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Și pentru lățimea curții pe partea de vest să fie perdele de cincizeci de coți, zece stâlpi ai lor și zece socluri ale lor. ");
INSERT INTO ronbtf_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Și lățimea curții pe partea de est să fie de cincizeci de coți. ");
INSERT INTO ronbtf_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Perdelele de pe una din părțile porții să fie de cincisprezece coți, trei stâlpi ai lor și trei socluri ale lor. ");
INSERT INTO ronbtf_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Și pe cealaltă parte să fie perdele de cincisprezece coți, trei stâlpi ai lor și trei socluri ale lor. ");
INSERT INTO ronbtf_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Și pentru poarta curții să fie o perdea de douăzeci de coți, din albastru și purpuriu și stacojiu și in subțire răsucit, lucrat cu broderie; și stâlpii lor să fie patru și soclurile lor, patru. ");
INSERT INTO ronbtf_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Toți stâlpii de jur împrejurul curții să fie înfășurați cu argint; cârligele lor să fie de argint și soclurile lor de aramă. ");
INSERT INTO ronbtf_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Lungimea curții să fie de o sută de coți și lățimea de cincizeci peste tot și înălțimea de cinci coți, de in subțire răsucit și soclurile lor de aramă. ");
INSERT INTO ronbtf_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Toate vasele tabernacolului în tot serviciul lui și toți țărușii acestuia și toți țărușii curții, să fie de aramă. ");
INSERT INTO ronbtf_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Și poruncește copiilor lui Israel să îți aducă untdelemn pur de măsline bătut, pentru lumină, pentru a face ca lampa să ardă continuu. ");
INSERT INTO ronbtf_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","În tabernacolul întâlnirii în afara perdelei, care este înaintea mărturiei, Aaron și fiii lui vor rândui aceasta de seara până dimineața înaintea DOMNULUI; acesta să fie un statut pentru totdeauna, pentru toate generațiile lor, pentru copiii lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Și ia la tine pe Aaron, fratele tău, și fiii lui cu el, dintre copiii lui Israel, ca el să îmi servească în serviciul de preot, chiar Aaron, Nadab și Abihu, Eleazar și Itamar, fiii lui Aaron. ");
INSERT INTO ronbtf_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Și fă veșminte sfinte pentru Aaron, fratele tău, pentru glorie și pentru frumusețe. ");
INSERT INTO ronbtf_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Și vorbește tuturor celor ce sunt înțelepți în inimă, pe care i-am umplut cu duhul înțelepciunii, ca ei să facă veșminte lui Aaron pentru a-l consacra, ca el să îmi servească în serviciul de preot. ");
INSERT INTO ronbtf_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Și acestea sunt veșmintele pe care le vor face: un pieptar și un efod și o robă și o tunică brodată, o mitră și un brâu; și vor face veșminte sfinte pentru Aaron, fratele tău, și fiii lui, ca el să îmi servească în serviciul de preot. ");
INSERT INTO ronbtf_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Și ei să ia aur și albastru și purpuriu și stacojiu și in subțire. ");
INSERT INTO ronbtf_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Și să facă efodul de aur, de albastru și de purpuriu, de stacojiu și de in subțire răsucit, o lucrătură iscusită. ");
INSERT INTO ronbtf_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Acesta va avea cele două umerarii ale lui împreunate la cele două margini ale lui; și astfel să fie legat. ");
INSERT INTO ronbtf_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Și brâul efodului făcut cu iscusință, care este peste el, să fie din aceeași bucată, conform lucrării acestuia chiar de aur, de albastru și purpuriu și stacojiu și in subțire răsucit. ");
INSERT INTO ronbtf_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Și să iei două pietre de onix și să gravezi pe ele numele copiilor lui Israel: ");
INSERT INTO ronbtf_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Șase din numele lor pe o piatră și celelalte șase nume rămase pe cealaltă piatră, conform nașterii lor. ");
INSERT INTO ronbtf_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Cu lucrarea unui gravor în piatră, asemenea gravurilor unui sigiliu să gravezi cele două pietre cu numele copiilor lui Israel: să le faci montate în broșe de aur. ");
INSERT INTO ronbtf_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Și să pui cele două pietre pe umerii efodului ca pietre ale amintirii copiilor lui Israel; și Aaron să poarte numele lor înaintea DOMNULUI pe cele două umerare ale sale drept amintire. ");
INSERT INTO ronbtf_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Și să faci broșe de aur; ");
INSERT INTO ronbtf_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Și două lanțuri de aur pur la capete; fă-le din lucrătură împletită și fixează lanțurile împletite, în broșe. ");
INSERT INTO ronbtf_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Și să faci pieptarul judecății cu lucrătură iscusită; fă-l asemenea lucrării efodului; de aur, de albastru, de purpuriu și de stacojiu și de in subțire răsucit, așa să îl faci. ");
INSERT INTO ronbtf_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Pătrat să fie, fiind dublu; o palmă să fie lungimea lui și o palmă să fie lățimea lui. ");
INSERT INTO ronbtf_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Și așază în el monturi ale pietrelor, patru rânduri de pietre: primul rând să fie un sardiu, un topaz și rubinul, acesta să fie primul rând. ");
INSERT INTO ronbtf_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Și al doilea rând să fie un smarald, un safir și un diamant. ");
INSERT INTO ronbtf_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Și al treilea rând un hiacint, o agată și un ametist. ");
INSERT INTO ronbtf_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Și al patrulea rând un beril și un onix și un jasp; ele vor fi montate în broșe de aur în monturile lor. ");
INSERT INTO ronbtf_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Și pietrele vor fi cu numele copiilor lui Israel, douăsprezece, conform cu numele lor, asemenea gravurilor unui sigiliu; fiecare cu numele lui să fie ele, conform celor douăsprezece triburi. ");
INSERT INTO ronbtf_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Și să faci pe pieptar lanțuri la capete, din lucrătură împletită de aur pur. ");
INSERT INTO ronbtf_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Și să faci pe pieptar două inele de aur și să pui cele două inele pe cele două colțuri ale pieptarului. ");
INSERT INTO ronbtf_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Și să pui cele două lanțuri răsucite de aur în cele două inele care sunt la colțurile pieptarului. ");
INSERT INTO ronbtf_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Și celelalte două capete ale celor două lanțuri împletite fixează-le în cele două broșe și prinde-le în cele două umerarii ale efodului în fața acestuia. ");
INSERT INTO ronbtf_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Și să faci două inele de aur și să le pui pe cele două colțuri ale pieptarului la marginea lui, care este în partea efodului de dinăuntru. ");
INSERT INTO ronbtf_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Și să faci alte două inele de aur și să le pui pe cele două părți laterale ale efodului pe dedesubt, spre partea dinainte a lui, lângă cealaltă îmbinare a lui, deasupra brâului făcut cu iscusință al efodului. ");
INSERT INTO ronbtf_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Și să lege pieptarul prin inelele lui la inelele efodului cu un șnur din albastru, ca acesta să fie deasupra brâului făcut cu iscusință al efodului și ca pieptarul să nu fie dezlegat de efod. ");
INSERT INTO ronbtf_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Și Aaron va purta numele copiilor lui Israel în pieptarul judecății peste inima sa, când intră în locul sfânt, ca o amintire continuă înaintea DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Și să pui în pieptarul judecății Urimul și Tumimul; și ele să fie peste inima lui Aaron, când el intră înaintea DOMNULUI; și Aaron să poarte judecata copiilor lui Israel peste inima lui continuu înaintea DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Și să faci roba efodului toată din albastru. ");
INSERT INTO ronbtf_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Și să fie o gaură în vârful acesteia, în mijlocul ei: să aibă o margine din lucrătură împletită de jur împrejurul găurii, precum gaura unei tunici de zale, ca să nu se sfâșie. ");
INSERT INTO ronbtf_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Și să faci pe tiv, rodii de albastru și de purpuriu și de stacojiu, de jur împrejurul tivului ei; și clopoței de aur între ele de jur împrejur: ");
INSERT INTO ronbtf_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Un clopoțel de aur și o rodie, un clopoțel de aur și o rodie, pe tivul robei de jur împrejur. ");
INSERT INTO ronbtf_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Și să fie peste Aaron pentru a servi; și sunetul lui să fie auzit când el intră în locul sfânt înaintea DOMNULUI și când iese afară, ca să nu moară. ");
INSERT INTO ronbtf_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Și să faci o placă de aur pur și să gravezi pe ea, asemenea gravurilor unui sigiliu: SFINȚENIE DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Și să-l pui pe un șnur albastru, ca să fie peste mitră; aceasta să fie peste partea dinainte a mitrei. ");
INSERT INTO ronbtf_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Și aceasta să fie pe fruntea lui Aaron, ca Aaron să poarte nelegiuirea lucrurilor sfinte, pe care copiii lui Israel le vor sfinți în toate darurile lor sfinte; și aceasta să fie continuu pe fruntea lui, ca ei să fie primiți înaintea DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Și să brodezi tunica de in subțire și să faci mitra de in subțire și să faci brâul din lucrătură brodată. ");
INSERT INTO ronbtf_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Și pentru fiii lui Aaron să faci tunici și să faci pentru ei brâie și bonete să faci pentru ei, pentru glorie și pentru frumusețe. ");
INSERT INTO ronbtf_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Și pune-le pe Aaron, fratele tău, și fiii săi împreună cu el; și unge-i și consacră-i și sfințește-i, ca ei să îmi servească în serviciul de preot. ");
INSERT INTO ronbtf_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Și să le faci izmene de in să le acopere goliciunea; de la șale peste coapse să ajungă acestea; ");
INSERT INTO ronbtf_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Și ele vor fi pe Aaron și pe fiii lui, în timp ce vor veni la tabernacolul întâlnirii, sau în timp ce se vor apropia de altar pentru a servi în locul sfânt; ca ei să nu poarte nelegiuire și să moară: acesta să fie un statut pentru totdeauna, lui și seminței lui după el. ");
INSERT INTO ronbtf_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Și acesta este lucrul pe care să îl faci pentru a-i sfinți, ca să îmi servească în serviciul de preot: ia un taur tânăr și doi berbeci fără cusur, ");
INSERT INTO ronbtf_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Și azimă și turte nedospite frământate cu untdelemn și lipii nedospite unse cu untdelemn; să le faci din floarea făinii de grâu. ");
INSERT INTO ronbtf_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Și să le pui într-un singur coș și să le aduci în coș, cu taurul și cei doi berbeci. ");
INSERT INTO ronbtf_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Și să îi aduci pe Aaron și fiii lui la ușa tabernacolului întâlnirii și să îi speli cu apă. ");
INSERT INTO ronbtf_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Și să iei veșmintele și să pui tunica peste Aaron și roba efodului și efodul și pieptarul și încinge-l cu brâul făcut cu iscusință, al efodului; ");
INSERT INTO ronbtf_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Și pune mitra pe capul lui și pune sfânta coroană peste mitră. ");
INSERT INTO ronbtf_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Ia apoi untdelemnul pentru ungere și toarnă-l pe capul lui și unge-l. ");
INSERT INTO ronbtf_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Și apropie-i pe fiii lui și pune tunici peste ei. ");
INSERT INTO ronbtf_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Și încinge-i cu brâie, pe Aaron și fiii săi, și pune-le bonete; și serviciul de preot va fi al lor ca un statut continuu; și astfel consacră pe Aaron și pe fiii săi. ");
INSERT INTO ronbtf_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Și fă să fie adus un taur înaintea tabernacolului întâlnirii: și Aaron și fiii săi să-și pună mâinile pe capul taurului. ");
INSERT INTO ronbtf_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Și să înjunghii taurul înaintea DOMNULUI, lângă ușa tabernacolului întâlnirii. ");
INSERT INTO ronbtf_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Și să iei din sângele taurului și să-l pui pe coarnele altarului cu degetul tău și să torni tot sângele lângă piciorul altarului. ");
INSERT INTO ronbtf_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Și să iei toată grăsimea care acoperă măruntaiele și lobul de pe ficat și cei doi rinichi și grăsimea care este pe ei și să le arzi pe altar. ");
INSERT INTO ronbtf_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Dar carnea taurului și pielea lui și balega lui, arde-le cu foc în afara taberei: aceasta este o ofrandă pentru păcat. ");
INSERT INTO ronbtf_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Să iei de asemenea un berbec: și Aaron și fiii săi își vor pune mâinile pe capul berbecului. ");
INSERT INTO ronbtf_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Și să înjunghii berbecul și să iei sângele lui și să-l stropești de jur împrejur pe altar. ");
INSERT INTO ronbtf_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Și să tai berbecul în bucăți și să speli măruntaiele lui și picioarele lui și să le pui la bucățile lui și la capul lui. ");
INSERT INTO ronbtf_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Și să arzi întregul berbec pe altar: aceasta este o ofrandă arsă DOMNULUI; aceasta este o aromă dulce, o ofrandă făcută prin foc DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Și să iei celălalt berbec: și Aaron și fiii săi să își pună mâinile pe capul berbecului. ");
INSERT INTO ronbtf_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Apoi înjunghie berbecul și ia din sângele lui și pune-l pe vârful urechii drepte a lui Aaron și pe vârful urechii drepte a fiilor săi și pe degetul mare a mâinii lor drepte și pe degetul mare al piciorului lor drept și stropește sângele pe altar de jur împrejur. ");
INSERT INTO ronbtf_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Și să iei din sângele care este pe altar și din untdelemnul pentru ungere și să-l stropești peste Aaron și peste veșmintele lui și peste fiii săi și peste veșmintele fiilor săi cu el; și el să fie sfințit și veșmintele sale și fiii săi și veșmintele fiilor săi cu el. ");
INSERT INTO ronbtf_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","De asemenea să iei de la berbec grăsimea și dosul și grăsimea care acoperă măruntaiele și lobul de pe ficat și cei doi rinichi și grăsimea care este pe ei și spata dreaptă, pentru că acesta este un berbec al consacrării, ");
INSERT INTO ronbtf_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Și o pâine întreagă și o turtă de pâine uleiată, și o lipie din coșul azimelor care este înaintea DOMNULUI; ");
INSERT INTO ronbtf_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Și să le pui toate în mâinile lui Aaron și în mâinile fiilor săi; și să le legeni ca ofrandă legănată înaintea DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Și să primești din mâinile lor și să le arzi pe altar ca ofrandă arsă, pentru o aromă dulce înaintea DOMNULUI: aceasta este ofrandă făcută prin foc DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Și să iei pieptul berbecului consacrării lui Aaron și să-l legeni ca ofrandă legănată înaintea DOMNULUI: și va fi partea ta. ");
INSERT INTO ronbtf_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Și să sfințești pieptul ofrandei legănate și spata ofrandei ridicate a berbecului consacrării, care este legănată și care este ridicată, a aceleia care este pentru Aaron și a aceleia care este pentru fiii săi; ");
INSERT INTO ronbtf_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Și aceasta va fi a lui Aaron și a fiilor săi printr-un statut etern de la copiii lui Israel, pentru că aceasta este ofrandă ridicată; și va fi ofrandă ridicată de la copiii lui Israel a sacrificiului ofrandelor lor de pace și ofranda lor ridicată DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Și sfintele veșminte ale lui Aaron vor fi ale fiilor săi după el, pentru a fi unși în ele și pentru a fi consacrați în ele. ");
INSERT INTO ronbtf_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Și fiul care va fi preot în locul lui le va îmbrăca șapte zile, când va veni la tabernacolul întâlnirii pentru a servi în locul sfânt. ");
INSERT INTO ronbtf_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Și să iei berbecul consacrării și să fierbi carnea lui în locul sfânt. ");
INSERT INTO ronbtf_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Și vor mânca, Aaron și fiii săi, carnea berbecului și pâinea care este în coș, lângă ușa tabernacolului întâlnirii. ");
INSERT INTO ronbtf_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Și vor mânca acele lucruri cu care a fost făcută ispășirea, pentru a-i consacra și pentru a-i sfinți; dar un străin nu va mânca din ele, pentru că ele sunt sfinte. ");
INSERT INTO ronbtf_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Și dacă ceva din carnea consacrărilor, sau din pâine, rămâne până dimineața, atunci să arzi rămășița cu foc: aceasta să nu fie mâncată, pentru că este sfântă. ");
INSERT INTO ronbtf_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Și să faci astfel lui Aaron și fiilor săi, conform cu toate pe care ți le-am poruncit: consacră-i șapte zile. ");
INSERT INTO ronbtf_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Și să oferi în fiecare zi un taur ca ofrandă pentru păcat pentru ispășire; și să cureți altarul, după ce ai făcut o ispășire pentru acesta și unge-l pentru a-l sfinți. ");
INSERT INTO ronbtf_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Șapte zile să faci ispășire pentru altar și să-l sfințești; și acesta va fi un altar preasfânt: orice atinge altarul va fi sfânt. ");
INSERT INTO ronbtf_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Și aceasta este ce vei oferi pe altar: doi miei de un an, zi de zi, continuu. ");
INSERT INTO ronbtf_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Primul miel să-l oferi dimineața; și celălalt miel să-l oferi seara; ");
INSERT INTO ronbtf_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Și cu primul miel, o zecime dintr-o măsură de făină amestecată cu a patra parte dintr-un hin de untdelemn bătut; și a patra parte dintr-un hin de vin ca un dar de băutură. ");
INSERT INTO ronbtf_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Și celălalt miel să-l aduci seara și să faci cu acesta conform darului de mâncare de dimineață și conform darului de băutură al lui, pentru aromă dulce, ofrandă făcută prin foc DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Aceasta să fie ofrandă arsă neîncetat prin toate generațiile voastre, la ușa tabernacolului întâlnirii, înaintea DOMNULUI, unde te voi întâlni, ca să îți vorbesc. ");
INSERT INTO ronbtf_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Și acolo voi întâlni copiii lui Israel și tabernacolul va fi sfințit prin gloria mea. ");
INSERT INTO ronbtf_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Și voi sfinți tabernacolul întâlnirii și altarul; voi sfinți de asemenea și pe Aaron și pe fiii săi, să îmi servească în serviciul de preot. ");
INSERT INTO ronbtf_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Și voi locui printre copiii lui Israel și voi fi Dumnezeul lor. ");
INSERT INTO ronbtf_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Și vor cunoaște că eu sunt DOMNUL Dumnezeul lor, care i-a scos din țara Egiptului, ca să locuiesc printre ei: Eu sunt DOMNUL Dumnezeul lor. ");
INSERT INTO ronbtf_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Și fă un altar ca să arzi tămâie pe el: să-l faci din lemn de salcâm. ");
INSERT INTO ronbtf_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Un cot să fie lungimea lui și un cot lățimea lui; să fie pătrat; și doi coți înălțimea lui; coarnele lui să fie la fel; ");
INSERT INTO ronbtf_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Și să-l îmbraci cu aur pur, partea de sus a acestuia și părțile lui de jur împrejur și coarnele lui; și să îi faci o coroană de aur de jur împrejur. ");
INSERT INTO ronbtf_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Și să îi faci două inele de aur sub coroana acestuia, la cele două colțuri ale lui, fă-le pe cele două părți ale lui; și ele vor fi locuri pentru drugi, pentru a-l purta cu totul. ");
INSERT INTO ronbtf_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Și fă drugii din lemn de salcâm și îmbracă-i cu aur. ");
INSERT INTO ronbtf_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Și să-l pui înaintea perdelei care este lângă chivotul mărturiei, înaintea șezământului milei care este deasupra mărturiei, unde mă voi întâlni cu tine. ");
INSERT INTO ronbtf_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Și Aaron să ardă tămâie dulce pe el în fiecare dimineață; când pregătește lămpile, va arde tămâie pe el. ");
INSERT INTO ronbtf_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Și când Aaron va aprinde lămpile seara, să ardă tămâie pe el, o tămâie continuă înaintea DOMNULUI prin generațiile voastre. ");
INSERT INTO ronbtf_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Nu aduceți tămâie străină pe el, nici sacrificiu ars, nici dar de mâncare; nici nu turnați dar de băutură pe el. ");
INSERT INTO ronbtf_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Și Aaron să facă o ispășire pe coarnele lui o dată într-un an, cu sângele ofrandei pentru păcate, a ispășirilor; o dată pe an să facă ispășire pe el prin generațiile voastre: este preasfânt DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Când faci numărătoarea copiilor lui Israel după numărul lor, atunci fiecare om să dea pentru sufletul lui o răscumpărare DOMNULUI, când îi numeri; ca să nu fie nicio plagă printre ei, când îi numeri. ");
INSERT INTO ronbtf_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Aceasta să dea, fiecare om care trece între cei ce sunt numărați, o jumătate de șekel conform șekelului sanctuarului (un șekel este douăzeci de gerai) o jumătate de șekel va fi ofrandă DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Fiecare om, care trece între cei ce sunt numărați, de la vârsta de douăzeci de ani în sus, să dea ofrandă DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Cel bogat să nu dea mai mult și cel sărac să nu dea mai puțin decât o jumătate de șekel, când ei vor da ofrandă DOMNULUI, pentru a face ispășire pentru sufletele voastre. ");
INSERT INTO ronbtf_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Și să iei banii de ispășire, ai copiilor lui Israel, și să îi rânduiești pentru serviciul tabernacolului întâlnirii, ca aceștia să fie o amintire copiilor lui Israel înaintea DOMNULUI, pentru a face ispășire pentru sufletele voastre. ");
INSERT INTO ronbtf_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","De asemenea fă un lighean de aramă și piciorul lui de asemenea de aramă, pentru a spăla: și pune-l între tabernacolul întâlnirii și altar și pune apă în el. ");
INSERT INTO ronbtf_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Pentru ca acolo Aaron și fiii lui să își spele mâinile și picioarele lor. ");
INSERT INTO ronbtf_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Când vor intra în tabernacolul întâlnirii, să se spele cu apă, ca să nu moară; sau când se apropie de altar pentru a servi și a arde ofrandă făcută prin foc DOMNULUI; ");
INSERT INTO ronbtf_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Astfel să își spele mâinile și picioarele lor, ca să nu moară; și le va fi un statut pentru totdeauna, lui și seminței lui prin generațiile lor. ");
INSERT INTO ronbtf_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Mai mult, DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Ia-ți de asemenea dintre cele mai alese mirodenii, smirnă pură, cinci sute de șekeli, și scorțișoară dulce, jumătate, chiar două sute cincizeci de șekeli, și trestie dulce, două sute și cincizeci de șekeli, ");
INSERT INTO ronbtf_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","Și casia, cinci sute de șekeli, conform șekelului sanctuarului și untdelemn de măsline, un hin; ");
INSERT INTO ronbtf_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Și fă-l un untdelemn al sfintei ungeri, un unguent amestecat conform artei parfumierilor: acesta va fi un untdelemn sfânt al ungerii. ");
INSERT INTO ronbtf_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Și unge tabernacolul întâlnirii cu el și chivotul mărturiei, ");
INSERT INTO ronbtf_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","Și masa și toate vasele ei și sfeșnicul și vasele lui și altarul tămâiei, ");
INSERT INTO ronbtf_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","Și altarul ofrandei arse cu toate vasele lui și ligheanul și piciorul lui. ");
INSERT INTO ronbtf_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Și sfințește-le, ca ele să fie preasfinte: orice le atinge va fi sfânt. ");
INSERT INTO ronbtf_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Și unge pe Aaron și pe fiii săi și consacră-i, ca ei să îmi servească în serviciul de preot. ");
INSERT INTO ronbtf_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Și vorbește copiilor lui Israel, spunând: Acesta îmi va fi un untdelemn al sfintei ungeri prin generațiile voastre. ");
INSERT INTO ronbtf_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Pe carnea omului să nu fie turnat, nici să nu faceți un altul asemenea lui, după compoziția lui: acesta este sfânt și vă va fi sfânt. ");
INSERT INTO ronbtf_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Oricine prepară vreunul asemenea lui, sau oricine pune din el peste un străin, să fie stârpit din poporul său. ");
INSERT INTO ronbtf_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Și DOMNUL i-a spus lui Moise: Ia-ți mirodenii dulci, stacte și onicha și galbanum; aceste mirodenii dulci cu tămâie pură: din fiecare să fie aceeași cantitate; ");
INSERT INTO ronbtf_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Și fă-le un parfum, un unguent conform artei parfumierilor, sărat, pur și sfânt; ");
INSERT INTO ronbtf_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Și pisează o parte din el foarte mărunt și pune din acesta înaintea mărturiei în tabernacolul întâlnirii, unde mă voi întâlni cu tine: îți va fi preasfânt. ");
INSERT INTO ronbtf_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Și cât despre parfumul pe care îl vei face, nu vă faceți din acesta conform compoziției lui: el îți va fi sfânt pentru DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Oricine va face unul asemenea aceluia, să miroase la fel, să fie stârpit din poporul său. ");
INSERT INTO ronbtf_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Vezi, am chemat pe nume pe Bețaleel, fiul lui Uri, fiul lui Hur, din tribul lui Iuda; ");
INSERT INTO ronbtf_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Și l-am umplut cu duhul lui Dumnezeu, în înțelepciune și în înțelegere și în cunoaștere și în orice fel de meșteșug, ");
INSERT INTO ronbtf_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Pentru a concepe lucruri iscusite, pentru a lucra în aur și în argint și în aramă, ");
INSERT INTO ronbtf_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Și în tăierea pietrelor, pentru a fi montate și în sculptarea lemnăriei, pentru a lucra în orice fel de meșteșug. ");
INSERT INTO ronbtf_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Și eu, iată, eu l-am dat împreună cu el pe Aholiab, fiul lui Ahisama, din tribul lui Dan; și în inimile tuturor celor ce sunt înțelepți în inimă am pus înțelepciune, ca ei să poată face tot ce ți-am poruncit; ");
INSERT INTO ronbtf_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Tabernacolul întâlnirii și chivotul mărturiei și șezământul milei care este pe ea și tot mobilierul tabernacolului, ");
INSERT INTO ronbtf_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","Și masa și vasele ei și sfeșnicul pur cu toate vasele lui și altarul tămâiei, ");
INSERT INTO ronbtf_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","Și altarul ofrandei arse cu toate vasele lui și ligheanul și piciorul lui, ");
INSERT INTO ronbtf_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Și hainele serviciului și veșmintele sfinte pentru preotul Aaron și veșmintele fiilor săi, pentru a servi în serviciul de preot, ");
INSERT INTO ronbtf_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Și untdelemnul pentru ungere și tămâia dulce pentru locul sfânt: să facă conform cu tot ceea ce ți-am poruncit. ");
INSERT INTO ronbtf_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Vorbește de asemenea copiilor lui Israel, spunând: Negreșit să țineți sabatele mele, căci acesta este un semn între mine și voi prin generațiile voastre; ca să știți că eu sunt DOMNUL care vă sfințește. ");
INSERT INTO ronbtf_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Țineți sabatul, căci el vă este sfânt; oricine îl pângărește să fie negreșit dat la moarte, pentru că oricine face vreo lucrare în el, acel suflet să fie stârpit din poporul său. ");
INSERT INTO ronbtf_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Șase zile să se facă muncă; dar în a șaptea este sabatul odihnei, sfânt pentru DOMNUL; oricine face vreo muncă în ziua de sabat, negreșit să fie dat la moarte. ");
INSERT INTO ronbtf_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","De aceea copiii lui Israel să țină sabatul, ca să țină sabatul prin generațiile lor, ca legământ continuu. ");
INSERT INTO ronbtf_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Acesta este un semn între mine și copiii lui Israel pentru totdeauna, pentru că în șase zile DOMNUL a făcut cerul și pământul și în a șaptea zi s-a odihnit și a fost înviorat. ");
INSERT INTO ronbtf_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Și i-a dat lui Moise, când el a sfârșit de vorbit îndeaproape cu el pe muntele Sinai, două table ale mărturiei, table de piatră, scrise cu degetul lui Dumnezeu. ");
INSERT INTO ronbtf_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Și când poporul a văzut că Moise întârzia să coboare de pe munte, oamenii s-au strâns la Aaron și i-au spus: Ridică-te, fă-ne dumnezei care să meargă înaintea noastră; căci, cât despre acest Moise, omul care ne-a scos din țara Egiptului, nu știm ce i s-a întâmplat. ");
INSERT INTO ronbtf_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Și Aaron le-a spus: Desfaceți cerceii de aur, care sunt în urechile soțiilor voastre ale fiilor voștri și ale fiicelor voastre, și aduceți-i la mine. ");
INSERT INTO ronbtf_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Și tot poporul a desfăcut cerceii de aur care erau în urechile lor și i-au adus la Aaron. ");
INSERT INTO ronbtf_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Iar el i-a primit din mâna lor; și după ce le-a făcut un vițel turnat, i-a dat formă cu o daltă și au spus: Israele, aceștia sunt dumnezeii tăi, care te-au scos din țara Egiptului. ");
INSERT INTO ronbtf_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Și când Aaron l-a văzut, a construit un altar înaintea lui; și Aaron a făcut o proclamație și a spus: Mâine este o sărbătoare pentru DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Și s-au sculat devreme a doua zi și au oferit ofrande arse și au adus ofrande de pace; și poporul s-a așezat să mănânce și să bea și s-a ridicat să joace. ");
INSERT INTO ronbtf_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Și DOMNUL i-a spus lui Moise: Du-te, coboară-te, căci poporul tău, pe care l-ai scos din țara Egiptului, s-au corupt; ");
INSERT INTO ronbtf_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","S-au abătut repede de pe calea pe care le-am poruncit-o; ei și-au făcut un vițel turnat și i s-au închinat și i-au sacrificat și au spus: Aceștia sunt dumnezeii tăi, Israele, care te-au scos din țara Egiptului. ");
INSERT INTO ronbtf_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Și DOMNUL i-a spus lui Moise: Am văzut acest popor și, iată, acesta este un popor îndărătnic; ");
INSERT INTO ronbtf_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","De aceea, acum lasă-mă, ca furia mea să se încingă împotriva lor și să îi mistui; și voi face din tine o națiune mare. ");
INSERT INTO ronbtf_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Și Moise a implorat pe DOMNUL Dumnezeul său și a spus: DOAMNE, de ce se încinge furia ta împotriva poporului tău, pe care l-ai scos din țara Egiptului cu mare putere și cu o mână tare? ");
INSERT INTO ronbtf_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Pentru ce să vorbească egiptenii și să spună: Pentru nenorocire i-a scos afară, ca să îi ucidă în munți și să îi mistuie de pe fața pământului? Întoarce-te de la furia ta înverșunată și pocăiește-te de acest rău împotriva poporului tău. ");
INSERT INTO ronbtf_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Adu-ți aminte de Avraam, de Isaac și de Israel, servitorii tăi, cărora le-ai jurat prin tine însuți și le-ai spus: Voi înmulți sămânța ca stelele cerului și toată această țară despre care am vorbit o voi da seminței voastre și o vor moșteni pentru totdeauna. ");
INSERT INTO ronbtf_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Și DOMNUL s-a pocăit de răul pe care s-a gândit să îl facă poporului său. ");
INSERT INTO ronbtf_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Și Moise s-a întors și a coborât de pe munte și cele două table ale mărturiei erau în mâna sa: tablele erau scrise pe amândouă părțile; pe o parte și pe cealaltă parte erau ele scrise. ");
INSERT INTO ronbtf_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Și tablele erau lucrarea lui Dumnezeu și scrisul era scrisul lui Dumnezeu, gravat pe table. ");
INSERT INTO ronbtf_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Și când a auzit Iosua zgomotul poporului pe când strigau, i-a spus lui Moise: Este zgomot de război în tabără. ");
INSERT INTO ronbtf_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Dar el a spus: Nu este vocea celor ce strigă din cauza victoriei, nici nu este vocea celor ce strigă din cauză că sunt învinși, ci aud zgomotul celor ce cântă. ");
INSERT INTO ronbtf_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Și s-a întâmplat, imediat ce s-a apropiat el de tabără, că a văzut vițelul și dansul; și mânia lui Moise s-a încins și a aruncat tablele din mâinile sale și le-a spart sub munte. ");
INSERT INTO ronbtf_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Și a luat vițelul pe care l-au făcut și l-a ars în foc și l-a măcinat până la pulbere și a împrăștiat pulberea pe apă și a făcut pe copiii lui Israel să bea din ea. ");
INSERT INTO ronbtf_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Și Moise i-a spus lui Aaron: Ce ți-a făcut poporul acesta, încât ai adus un așa mare păcat peste ei? ");
INSERT INTO ronbtf_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Și Aaron a spus: Să nu se încingă mânia domnului meu; cunoști poporul, că ei sunt puși pe ticăloșie. ");
INSERT INTO ronbtf_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Fiindcă mi-au spus: Fă-ne dumnezei, care să meargă înaintea noastră, căci cât despre acest Moise, bărbatul care ne-a scos din țara Egiptului, nu știm ce i s-a întâmplat. ");
INSERT INTO ronbtf_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Iar eu le-am spus: Oricine are ceva aur, să îl desfacă. Așa că mi l-au dat; atunci l-am aruncat în foc și a ieșit acest vițel. ");
INSERT INTO ronbtf_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Și după ce Moise a văzut că oamenii erau goi (pentru că Aaron i-a făcut goi spre rușinea lor printre dușmanii lor), ");
INSERT INTO ronbtf_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Atunci Moise a stat în picioare în poarta taberei și a spus: Cine este de partea DOMNULUI? Acela să vină la mine. Și toți fiii lui Levi s-au adunat la el. ");
INSERT INTO ronbtf_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Iar el le-a spus: Astfel spune DOMNUL Dumnezeu al lui Israel: Să-și pună fiecare bărbat sabia la coapsă și să intre și să iasă de la poartă la poartă prin tabără, și fiecare bărbat să ucidă pe fratele său și fiecare bărbat pe însoțitorul său și fiecare bărbat pe vecinul său. ");
INSERT INTO ronbtf_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Și copiii lui Levi au făcut conform cuvântului lui Moise: și au căzut din popor în acea zi în jur de trei mii de bărbați. ");
INSERT INTO ronbtf_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Pentru că Moise a spus: Astăzi, consacrați-vă pe voi înșivă DOMNULUI, fiecare bărbat peste fiul său și peste fratele său, ca astăzi să vă dăruiască o binecuvântare. ");
INSERT INTO ronbtf_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Și s-a întâmplat, a doua zi, că Moise a spus poporului: Ați păcătuit un mare păcat; și acum voi urca la DOMNUL; poate voi face ispășire pentru păcatul vostru. ");
INSERT INTO ronbtf_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Și Moise s-a întors la DOMNUL și a spus: Oh, acest popor a păcătuit un mare păcat și și-au făcut dumnezei de aur. ");
INSERT INTO ronbtf_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Totuși acum dacă voiești, iartă păcatul lor; și dacă nu, șterge-mă, te rog eu, din cartea ta pe care ai scris-o. ");
INSERT INTO ronbtf_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Și DOMNUL i-a spus lui Moise: Oricine a păcătuit împotriva mea, pe el îl voi șterge din cartea mea. ");
INSERT INTO ronbtf_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","De aceea acum du-te, condu poporul la locul despre care ți-am vorbit: iată, Îngerul meu va merge înaintea ta; totuși în ziua cercetării, voi pedepsi păcatul lor peste ei. ");
INSERT INTO ronbtf_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Și DOMNUL a lovit poporul cu plăgi, pentru că au făcut vițelul pe care Aaron l-a făcut. ");
INSERT INTO ronbtf_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Și DOMNUL i-a spus lui Moise: Pleacă și urcă de aici, tu și poporul pe care l-ai scos din țara Egiptului, la țara pe care am jurat-o lui Avraam, lui Isaac și lui Iacob, spunând: Seminței tale o voi da, ");
INSERT INTO ronbtf_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Și voi trimite un înger înaintea ta; și voi alunga pe canaanit, pe amorit, pe hitit și pe perizit, pe hivit și pe iebusit: ");
INSERT INTO ronbtf_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","La o țară în care curge lapte și miere, căci nu mă voi urca în mijlocul tău ca nu cumva eu să te mistui pe cale, pentru că tu ești un popor îndărătnic. ");
INSERT INTO ronbtf_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Și după ce poporul a auzit aceste vești rele, au jelit; și nimeni nu a pus pe el podoabele sale. ");
INSERT INTO ronbtf_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Pentru că DOMNUL i-a spus lui Moise: Spune copiilor lui Israel: Voi sunteți un popor îndărătnic: dintr-odată mă voi urca în mijlocul tău și te voi mistui; de aceea acum scoate podoabele tale de pe tine, ca să știu ce să îți fac. ");
INSERT INTO ronbtf_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Și copiii lui Israel și-au scos podoabele lor la muntele Horeb. ");
INSERT INTO ronbtf_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Și Moise a luat tabernacolul și l-a ridicat în afara taberei, departe de tabără și l-a chemat Tabernacolul întâlnirii. Și s-a întâmplat că oricine căuta pe DOMNUL ieșea afară la tabernacolul întâlnirii, care era în afara taberei. ");
INSERT INTO ronbtf_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Și s-a întâmplat, după ce Moise a ieșit afară la tabernacol, că tot poporul s-a sculat și fiecare bărbat a stat în picioare la ușa cortului său și s-au uitat după Moise, până ce a intrat în tabernacol. ");
INSERT INTO ronbtf_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Și s-a întâmplat că, pe când Moise a intrat în tabernacol, coloana de nor a coborât și a stat la ușa tabernacolului și DOMNUL a vorbit cu Moise. ");
INSERT INTO ronbtf_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Și tot poporul a văzut coloana de nor stând la ușa tabernacolului; și tot poporul s-a ridicat și s-a închinat, fiecare bărbat în ușa cortului său. ");
INSERT INTO ronbtf_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Și DOMNUL i-a vorbit lui Moise față în față, așa cum un bărbat vorbește prietenului său. Și el s-a întors din nou în tabără; dar servitorul său, Iosua, fiul lui Nun, un tânăr, nu s-a depărtat de tabernacol. ");
INSERT INTO ronbtf_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Și Moise a spus DOMNULUI: Vezi, îmi spui: Adu acest popor; și nu mă lași să știu pe cine vei trimite cu mine. Totuși ai spus: Te cunosc pe nume și de asemenea ai găsit har înaintea ochilor mei. ");
INSERT INTO ronbtf_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Și acum, te rog, dacă am găsit har înaintea ochilor tăi, arată-mi acum calea ta, ca să te cunosc, ca să găsesc har înaintea ochilor tăi; și ai în vedere că această națiune este poporul tău. ");
INSERT INTO ronbtf_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Și a spus: Prezența mea va merge cu tine și îți voi da odihnă. ");
INSERT INTO ronbtf_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Iar el i-a spus: Dacă prezența ta nu merge cu mine, nu ne urca de aici. ");
INSERT INTO ronbtf_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Căci în ce va fi cunoscut aici că eu și poporul tău am găsit har înaintea ochilor tăi? Nu este în aceea că mergi cu noi? Astfel vom fi separați, eu și poporul tău, dintre toate popoarele care sunt pe fața pământului. ");
INSERT INTO ronbtf_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Și DOMNUL i-a spus lui Moise: Voi face și lucrul acesta pe care l-ai vorbit, pentru că ai găsit har înaintea ochilor mei și te cunosc pe nume. ");
INSERT INTO ronbtf_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Iar el a spus: Te implor, arată-mi gloria ta. ");
INSERT INTO ronbtf_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Iar el a spus: Voi face ca toată bunătatea mea să treacă pe dinaintea ta și voi vesti numele DOMNULUI înaintea ta; și voi avea har fața de cine voi avea har și voi arăta milă cui voi arăta milă. ");
INSERT INTO ronbtf_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Și a mai spus: Nu poți vedea fața mea, căci niciun om nu mă va vedea și după aceea să trăiască. ");
INSERT INTO ronbtf_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Și DOMNUL a spus: Iată, este un loc lângă mine și stai în picioare pe stâncă; ");
INSERT INTO ronbtf_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Și se va întâmpla, în timp ce gloria mea trece pe lângă tine, că te voi pune într-o crăpătură a stâncii și te voi acoperi cu mâna mea în timp ce trec pe lângă tine; ");
INSERT INTO ronbtf_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Și îmi voi retrage mâna și vei vedea părțile mele din spate, dar fața mea nu se va vedea. ");
INSERT INTO ronbtf_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Și DOMNUL i-a spus lui Moise: Taie-ți două table de piatră asemenea primelor și voi scrie pe aceste table cuvintele care au fost pe primele table, pe care le-ai spart. ");
INSERT INTO ronbtf_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Și fii gata mâine dimineață și urcă-te dimineață pe muntele Sinai și prezintă-te acolo mie pe vârful muntelui. ");
INSERT INTO ronbtf_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Și niciun bărbat să nu urce cu tine, să nu fie văzut niciun bărbat pe tot muntele; să nu pască nici turmele nici cirezile înaintea acelui munte. ");
INSERT INTO ronbtf_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Iar el a tăiat două table de piatră asemenea primelor; și Moise s-a sculat dis-de-dimineață și a urcat pe muntele Sinai, așa cum DOMNUL îi poruncise și a luat în mâna sa cele două table din piatră. ");
INSERT INTO ronbtf_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Și DOMNUL a coborât în nor și a stat cu el acolo și a vestit numele DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Și DOMNUL a trecut pe dinaintea lui și a vestit: DOMNUL, DOMNUL Dumnezeu, milostiv și cu har, îndelung răbdător și abundent în bunătate și adevăr, ");
INSERT INTO ronbtf_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Păstrând milă pentru mii, iertând nelegiuire și fărădelege și păcat și în niciun fel nu va cruța pe vinovat; pedepsind nelegiuirea părinților peste copii și peste copiii copiilor, până la a treia și a patra generație. ");
INSERT INTO ronbtf_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Și Moise s-a grăbit și și-a plecat capul spre pământ și s-a închinat. ");
INSERT INTO ronbtf_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Și a spus: Dacă acum am găsit har înaintea ochilor tăi, Doamne, lasă te rog, ca Domnul meu, să meargă printre noi, pentru că acesta este un popor îndărătnic; și iartă nelegiuirea noastră și păcatul nostru și ia-ne ca moștenirea ta. ");
INSERT INTO ronbtf_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Iar el a spus: Iată, fac un legământ: înaintea întregului tău popor voi face minuni, așa cum nu s-au mai făcut pe tot pământul, nici în vreo națiune; și tot poporul printre care tu te afli vor vedea lucrarea DOMNULUI; căci este un lucru înfricoșător pe care îl voi face cu tine. ");
INSERT INTO ronbtf_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Ține ceea ce îți poruncesc în această zi; iată, alung dinaintea ta pe amorit și pe canaanit și pe hitit și pe perizit și pe hivit și pe iebusit. ");
INSERT INTO ronbtf_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Ia seama la tine însuți, ca nu cumva să faci legământ cu locuitorii țării în care mergi, ca nu cumva să fie o cursă în mijlocul tău; ");
INSERT INTO ronbtf_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Ci să distrugeți altarele lor, să spargeți idolii lor și să le tăiați dumbrăvile, ");
INSERT INTO ronbtf_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Pentru că nu te vei închina niciunui alt dumnezeu, pentru că DOMNUL, a cărui nume este Gelos, este un Dumnezeu gelos; ");
INSERT INTO ronbtf_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Nu cumva să faci legământ cu locuitorii țării și ei să curvească după dumnezeii lor și să aducă sacrificiu dumnezeilor lor și vreunul să te cheme și să mănânci din sacrificiul lui; ");
INSERT INTO ronbtf_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Și să iei dintre fiicele lor pentru fiii tăi și fiicele lor să curvească după dumnezeii lor și să facă pe fiii tăi să curvească după dumnezeii lor. ");
INSERT INTO ronbtf_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Să nu îți faci dumnezei turnați. ");
INSERT INTO ronbtf_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Ține sărbătoarea azimelor. Mănâncă șapte zile azimă cum ți-am poruncit, în timpul lunii Abib, pentru că în luna Abib ai ieșit din Egipt. ");
INSERT INTO ronbtf_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Tot ce deschide pântecele este al meu; și fiecare întâi născut între vitele tale, fie bou sau oaie. ");
INSERT INTO ronbtf_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Dar să răscumperi pe întâiul născut al măgăriței cu un miel; și dacă nu îl răscumperi, atunci să îi frângi gâtul. Să răscumperi pe tot întâiul născut dintre fiii tăi. Și niciunul să nu se arate înaintea mea cu mâna goală. ");
INSERT INTO ronbtf_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Să lucrezi șase zile, dar să te odihnești în a șaptea zi; să te odihnești în timpul aratului și al secerișului. ");
INSERT INTO ronbtf_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Și să ții sărbătoarea săptămânilor, ale primelor roade ale secerișului grâului și sărbătoarea recoltei la sfârșitul anului. ");
INSERT INTO ronbtf_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","De trei ori într-un an toți copiii tăi de parte bărbătească să se arate înaintea Domnului DUMNEZEU, Dumnezeul lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Pentru că voi arunca afară națiunile dinaintea ta și voi lărgi hotarele tale; niciun om nu va dori țara ta, când te vei urca să te arăți înaintea DOMNULUI Dumnezeul tău, de trei ori într-un an. ");
INSERT INTO ronbtf_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Să nu oferi sângele sacrificiului meu cu dospeală; nici să nu fie lăsat sacrificiul sărbătorii paștelui până dimineața. ");
INSERT INTO ronbtf_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Să aduci primul dintre primele roade ale pământului tău la casa DOMNULUI Dumnezeul tău. Să nu fierbi un ied în laptele mamei sale. ");
INSERT INTO ronbtf_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Și DOMNUL i-a spus lui Moise: Scrie-ți aceste cuvinte; căci după tonul acestor cuvinte am făcut un legământ cu tine și cu Israel. ");
INSERT INTO ronbtf_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Iar el a fost acolo cu DOMNUL patruzeci de zile și patruzeci de nopți; nici nu a mâncat pâine, nici nu a băut apă. Și el a scris pe table cuvintele legământului, cele zece porunci. ");
INSERT INTO ronbtf_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Și s-a întâmplat, când a coborât Moise de pe Muntele Sinai, și cele două table ale mărturiei erau în mâna lui Moise când a coborât de pe munte, că Moise nu știa că pielea feței sale strălucea cât timp a vorbit cu el. ");
INSERT INTO ronbtf_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Și când Aaron și toți copiii lui Israel au văzut pe Moise, iată, pielea feței sale strălucea; și s-au temut să se apropie de el. ");
INSERT INTO ronbtf_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Și Moise i-a chemat; și Aaron și toți conducătorii adunării s-au întors la el; și Moise a vorbit cu ei. ");
INSERT INTO ronbtf_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Și după aceea toți copiii lui Israel s-au apropiat, și le-a dat în poruncă tot ceea ce DOMNUL vorbise cu el în muntele Sinai. ");
INSERT INTO ronbtf_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Și când Moise a încetat să vorbească cu ei și-a pus un văl pe față. ");
INSERT INTO ronbtf_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Dar când Moise a intrat înaintea DOMNULUI ca să vorbească cu el, el a scos vălul, până când a ieșit. Și a ieșit și le-a spus copiilor lui Israel ceea ce i-a fost poruncit. ");
INSERT INTO ronbtf_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Și copiii lui Israel au văzut fața lui Moise, că pielea feței lui Moise strălucea; și Moise a pus vălul peste fața sa din nou, până când a intrat să vorbească cu el. ");
INSERT INTO ronbtf_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Și Moise a adunat toată adunarea copiilor lui Israel și le-a spus: Acestea sunt cuvintele pe care DOMNUL le-a poruncit, să le faceți. ");
INSERT INTO ronbtf_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Șase zile se va face lucrarea, dar ziua a șaptea vă va fi o zi sfântă, un sabat de odihnă DOMNULUI: oricine va face vreo lucrare în ea va fi dat la moarte. ");
INSERT INTO ronbtf_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Să nu aprindeți foc în locuințele voastre în ziua de sabat. ");
INSERT INTO ronbtf_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Și Moise a vorbit întregii adunări a copiilor lui Israel, spunând: Acesta este lucrul pe care Domnul l-a poruncit, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Luați dintre voi ofrandă DOMNULUI; oricine are inimă voitoare să aducă o ofrandă DOMNULUI: aur și argint și aramă, ");
INSERT INTO ronbtf_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","Și albastru și purpuriu și stacojiu și in subțire și păr de capre, ");
INSERT INTO ronbtf_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","Și piei de berbeci vopsite roșu și piei de bursuc și lemn de salcâm, ");
INSERT INTO ronbtf_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","Și untdelemn pentru lampă și mirodenii pentru untdelemnul pentru ungere și pentru tămâia dulce, ");
INSERT INTO ronbtf_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","Și pietre de onix și pietre să fie montate pentru efod și pentru pieptar. ");
INSERT INTO ronbtf_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Și fiecare om înțelept în inimă dintre voi să vină și să facă tot ceea ce DOMNUL a poruncit: ");
INSERT INTO ronbtf_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Tabernacolul, cortul lui și acoperământul lui, copcile lui și scândurile lui, drugii lui, coloanele lui și soclurile lui, ");
INSERT INTO ronbtf_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Chivotul și drugii lui, cu șezământul milei și perdeaua acoperământului, ");
INSERT INTO ronbtf_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","Masa și drugii ei și toate vasele ei și pâinile punerii înainte, ");
INSERT INTO ronbtf_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","Sfeșnicul de asemenea pentru lumină și vasele lui și lămpile lui, cu untdelemnul pentru lumină. ");
INSERT INTO ronbtf_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","Și altarul tămâiei și drugii lui și untdelemnul pentru ungere și tămâia dulce și perdeaua pentru ușă la intrarea în tabernacol, ");
INSERT INTO ronbtf_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","Altarul ofrandei arse, cu grătarul de aramă, drugii lui și toate vasele lui, ligheanul și piciorul lui, ");
INSERT INTO ronbtf_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Perdelele curții, stâlpii ei și soclurile lor și perdeaua pentru ușa curții, ");
INSERT INTO ronbtf_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","Țărușii tabernacolului și țărușii curții și frânghiile lor, ");
INSERT INTO ronbtf_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Hainele serviciului, pentru a face serviciul în locul sfânt, veșmintele sfinte pentru preotul Aaron și veșmintele fiilor săi, pentru a servi în serviciul de preot. ");
INSERT INTO ronbtf_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Și toată adunarea copiilor lui Israel a plecat din prezența lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Și a venit fiecare om a cărui inimă l-a stârnit și fiecare om al cărui duh l-a făcut voitor și au adus ofranda DOMNULUI pentru lucrarea tabernacolului întâlnirii și pentru tot serviciul lui și pentru veșmintele sfinte. ");
INSERT INTO ronbtf_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Și au venit, deopotrivă bărbați și femei, atâția câți au fost cu inimă voitoare, și au adus brățări și cercei și inele și table, toate bijuterii din aur; și fiecare om care a oferit, a oferit o ofrandă de aur DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Și toți la care s-a găsit albastru și purpuriu și stacojiu și in subțire și păr de capre și piei roșii de berbeci și piei de bursuci, le-au adus. ");
INSERT INTO ronbtf_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Și fiecare om care a oferit o ofrandă din argint și aramă a adus ofranda DOMNULUI; și toți la care s-a găsit lemn de salcâm pentru orice lucrare a serviciului, l-au adus. ");
INSERT INTO ronbtf_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Și toate femeile care au fost înțelepte în inimă au tors cu mâinile lor și au adus ceea ce au tors, deopotrivă din albastru și din purpuriu și din stacojiu și din in subțire. ");
INSERT INTO ronbtf_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Și toate femeile ale căror inimi le-au stârnit la înțelepciune au tors păr de capre. ");
INSERT INTO ronbtf_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Și conducătorii au adus pietre de onix și pietre să fie montate pentru efod și pentru pieptar; ");
INSERT INTO ronbtf_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Și mirodenii și untdelemn pentru lumină și pentru untdelemnul pentru ungere și pentru tămâia dulce. ");
INSERT INTO ronbtf_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Copiii lui Israel au adus din bunăvoință o ofrandă DOMNULUI, fiecare bărbat și femeie, a cărui inimă i-a făcut voitori să aducă pentru toate felurile de lucrări, pe care DOMNUL le poruncise a fi făcute prin mâna lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Și Moise le-a spus copiilor lui Israel: Vedeți, DOMNUL a chemat pe nume pe Bețaleel, fiul lui Uri, fiul lui Hur, din tribul lui Iuda; ");
INSERT INTO ronbtf_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Și l-a umplut cu duhul lui Dumnezeu în înțelepciune, în înțelegere și în cunoaștere și în orice fel de meșteșug; ");
INSERT INTO ronbtf_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Și pentru a concepe lucruri iscusite, pentru a lucra în aur și în argint și în aramă, ");
INSERT INTO ronbtf_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Și în tăierea pietrelor, pentru a fi montate și în sculptarea lemnului, pentru a face orice fel de lucrare iscusită. ");
INSERT INTO ronbtf_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Și lui și lui Aholiab, fiul lui Ahisamac, din tribul lui Dan, le-a pus în inimă să îi învețe pe alții. ");
INSERT INTO ronbtf_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","I-a umplut cu înțelepciune a inimii, pentru a lucra tot felul de lucrări, ale gravorului și ale meșteșugarului iscusit și ale lucrătorului în broderie, în albastru și în purpuriu, în stacojiu și în in subțire și ale țesătorului, chiar al celor ce fac orice fel de lucrare și al celor ce concep o lucrare iscusită. ");
INSERT INTO ronbtf_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Atunci Bețaleel și Aholiab și fiecare bărbat înțelept în inimă, în care DOMNUL a pus înțelepciune și înțelegere ca să cunoască cum să lucreze orice fel de lucrare pentru serviciul sanctuarului, au lucrat conform cu tot ceea ce DOMNUL poruncise. ");
INSERT INTO ronbtf_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Și Moise a chemat pe Bețaleel și pe Aholiab și pe fiecare bărbat înțelept în inimă, în a cărui inimă DOMNUL pusese înțelepciune, pe fiecare a cărui inimă îl stârnise să vină la lucrare, ca să o facă; ");
INSERT INTO ronbtf_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Și au primit de la Moise toată ofranda, pe care copiii lui Israel au adus-o pentru lucrarea serviciului sanctuarului, pentru a-l face în întregime. Și încă îi mai aduceau ofrande de bunăvoie în fiecare dimineață. ");
INSERT INTO ronbtf_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Și toți bărbații înțelepți, care lucrau toată lucrarea sanctuarului, au venit fiecare bărbat de la lucrarea lui pe care o făceau; ");
INSERT INTO ronbtf_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Și i-au vorbit lui Moise, spunând: Poporul aduce mult mai mult decât este nevoie pentru serviciul lucrării, pe care DOMNUL a poruncit a o face. ");
INSERT INTO ronbtf_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Și Moise a dat poruncă și au făcut ca aceasta să fie proclamată prin toată tabăra, spunând: Nici bărbat, nici femeie să nu mai facă nicio lucrare pentru ofrandă pentru sanctuar. Astfel poporul a fost oprit să aducă. ");
INSERT INTO ronbtf_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Căci materialul lor era suficient pentru toată lucrarea, să o facă și chiar prea mult. ");
INSERT INTO ronbtf_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Și fiecare om înțelept în inimă printre cei ce lucrau lucrarea tabernacolului a făcut zece covoare din in subțire răsucit și albastru și purpuriu și stacojiu cu heruvimi, într-o lucrare iscusită i-a făcut. ");
INSERT INTO ronbtf_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Lungimea unui covor era douăzeci și opt de coți și lățimea unui covor patru coți; covoarele erau toate de aceeași măsură. ");
INSERT INTO ronbtf_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Și el a prins cele cinci covoare, unul de celălalt; și celelalte cinci covoare le-a prins unul de celălalt. ");
INSERT INTO ronbtf_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Și a făcut cheutori albastre la marginea unui covor, pe marginea împreunării; și tot așa a făcut pe marginea din capăt a celuilalt covor, în îmbinarea a doua. ");
INSERT INTO ronbtf_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Cincizeci de cheotori a făcut pe un covor și cincizeci de cheotori a făcut pe marginea covorului care era în îmbinarea a doua: cheotorile au ținut un covor de celălalt. ");
INSERT INTO ronbtf_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Și a făcut cincizeci de copci din aur și a prins covoarele unul de celălalt cu copcile; astfel a devenit un singur tabernacol. ");
INSERT INTO ronbtf_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Și a făcut covoare din păr de capre pentru acoperiș deasupra tabernacolului; a făcut unsprezece covoare. ");
INSERT INTO ronbtf_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Lungimea unui covor era de treizeci de coți și patru coți era lățimea unui covor; cele unsprezece covoare erau de o singură mărime. ");
INSERT INTO ronbtf_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Și a îmbinat cinci covoare între ele și șase covoare între ele. ");
INSERT INTO ronbtf_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Și a făcut cincizeci de cheotori pe marginea din capăt a covorului în îmbinare și cincizeci de cheotori a făcut pe marginea covorului care se îmbină cu al doilea. ");
INSERT INTO ronbtf_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Și a făcut cincizeci de copci din aramă pentru a îmbina acoperișul împreună, ca să fie unul singur. ");
INSERT INTO ronbtf_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Și pentru acoperiș, a făcut un acoperământ din piei de berbeci vopsite roșu și un acoperământ din piei de bursuci deasupra. ");
INSERT INTO ronbtf_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Și a făcut, pentru tabernacol, scânduri din lemn de salcâm, stând în picioare. ");
INSERT INTO ronbtf_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Lungimea unei scânduri era de zece coți și lățimea unei scânduri de un cot și jumătate. ");
INSERT INTO ronbtf_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","O scândură avea două cepuri, la distanță egală unul de celălalt; astfel a făcut pentru toate scândurile tabernacolului. ");
INSERT INTO ronbtf_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Și a făcut scânduri pentru tabernacol: douăzeci de scânduri pe partea de sud, spre sud; ");
INSERT INTO ronbtf_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Și patruzeci de socluri de argint a făcut sub cele douăzeci de scânduri: două socluri sub o scândură pentru cele două cepuri ale ei și două socluri sub altă scândură pentru cele două cepuri ale ei. ");
INSERT INTO ronbtf_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Și pentru cealaltă parte a tabernacolului, care este spre colțul de nord, a făcut douăzeci de scânduri, ");
INSERT INTO ronbtf_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","Și cele patruzeci de socluri ale lor din argint: două socluri sub o scândură și două socluri sub altă scândură. ");
INSERT INTO ronbtf_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Și pentru părțile tabernacolului care sunt spre vest a făcut șase scânduri. ");
INSERT INTO ronbtf_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Și două scânduri a făcut pentru colțurile tabernacolului pe cele două părți. ");
INSERT INTO ronbtf_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Și au fost îmbinate între ele, dedesubt, și au fost îmbinate împreună la capul acesteia, într-un singur inel; astfel a făcut celor două scânduri în ambele colțuri. ");
INSERT INTO ronbtf_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Și au fost opt scânduri; și soclurile lor au fost șaisprezece socluri de argint, sub fiecare scândură, două socluri. ");
INSERT INTO ronbtf_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Și a făcut drugi de lemn de salcâm, cinci pentru scândurile uneia din părțile tabernacolului. ");
INSERT INTO ronbtf_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","Și cinci drugi pentru scândurile celeilalte părți a tabernacolului și cinci drugi pentru scândurile tabernacolului pentru părțile spre vest. ");
INSERT INTO ronbtf_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Și a făcut drugul din mijloc să treacă prin scânduri de la un capăt la celălalt. ");
INSERT INTO ronbtf_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Și a placat scândurile cu aur și le-a făcut inelele din aur pentru a fi locuri pentru drugi și a placat drugii cu aur. ");
INSERT INTO ronbtf_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Și a făcut o perdea albastră și purpurie și stacojie și in subțire răsucit; cu heruvimi a făcut-o într-o lucrare iscusită. ");
INSERT INTO ronbtf_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Și i-a făcut patru piloni din lemn de salcâm și i-a placat cu aur; cârligele lor erau din aur; și a turnat pentru ei patru socluri din argint. ");
INSERT INTO ronbtf_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Și a făcut pentru ușa tabernacolului o perdea albastră și purpurie și stacojie și din in subțire răsucit, din lucrare brodată, ");
INSERT INTO ronbtf_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Și cei cinci stâlpi ale acestuia cu cârligele lor; și a placat capitelurile lor și vergelele lor cu aur; dar cele cinci socluri ale lor erau de aramă. ");
INSERT INTO ronbtf_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Și Bețaleel a făcut chivotul din lemn de salcâm; doi coți și jumătate era lungimea lui și un cot și jumătate lățimea lui și un cot și jumătate înălțimea lui; ");
INSERT INTO ronbtf_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Și l-a îmbrăcat cu aur pur pe dinăuntru și pe dinafară și i-a făcut o coroană de aur de jur împrejur. ");
INSERT INTO ronbtf_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Și i-a turnat patru inele de aur, cele patru colțuri ale lui: două inele pe una din părțile lui și două inele pe cealaltă parte a lui. ");
INSERT INTO ronbtf_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Și a făcut drugi din lemn de salcâm și i-a placat cu aur. ");
INSERT INTO ronbtf_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Și el a pus drugii în inele pe părțile laterale ale chivotului, ca să poarte chivotul. ");
INSERT INTO ronbtf_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Și a făcut șezământul milei din aur pur; doi coți și jumătate era lungimea lui și un cot și jumătate lățimea lui. ");
INSERT INTO ronbtf_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Și a făcut doi heruvimi din aur, i-a făcut din aur bătut dintr-o singură bucată, la cele două capete ale șezământului milei. ");
INSERT INTO ronbtf_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Un heruvim la un capăt de o parte și un alt heruvim la un capăt pe partea cealaltă; ieșind din șezământul milei a făcut heruvimii pe cele două capete ale lui. ");
INSERT INTO ronbtf_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Și heruvimii își întindeau aripile lor în sus și acopereau cu aripile lor șezământul milei, cu fețele lor privind unul la altul; chiar spre șezământul milei erau fețele heruvimilor. ");
INSERT INTO ronbtf_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Și a făcut masa din lemn de salcâm; doi coți era lungimea ei și un cot lățimea ei și un cot și jumătate înălțimea ei; ");
INSERT INTO ronbtf_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Și a îmbrăcat-o cu aur pur și i-a făcut de jur împrejur o coroană de aur. ");
INSERT INTO ronbtf_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","De asemenea i-a făcut o margine cât un lat de palmă de jur împrejur; și a făcut o coroană de aur pentru marginea ei de jur împrejur. ");
INSERT INTO ronbtf_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Și a turnat pentru ea patru inele de aur și a pus inelele în cele patru colțuri care erau la cele patru picioare ale ei. ");
INSERT INTO ronbtf_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Inelele erau în fața marginii în locurile pentru drugi pentru a purta masa. ");
INSERT INTO ronbtf_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Și a făcut drugii din lemn de salcâm și i-a placat cu aur, pentru a purta masa. ");
INSERT INTO ronbtf_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Și a făcut vasele care erau pe masă, farfuriile ei și lingurile ei și bolurile ei și capacele ei cu care să le acopere, din aur pur. ");
INSERT INTO ronbtf_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Și a făcut sfeșnicul din aur pur; a făcut sfeșnicul dintr-o lucrare din aur bătut; stâlpul lui și brațul lui, bolurile lui, nodurile lui și florile lui erau din aceeași lucrare bătută. ");
INSERT INTO ronbtf_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Și șase brațe ieșeau din laturile lui: trei brațe ale sfeșnicului dintr-o parte a lui și trei brațe ale sfeșnicului din cealaltă parte a lui; ");
INSERT INTO ronbtf_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Trei cupe făcute asemenea migdalelor pe un braț, un nod și o floare; și trei boluri făcute asemenea migdalelor pe alt braț, un nod și o floare; astfel să fie făcute pe cele șase brațe ieșind din sfeșnic. ");
INSERT INTO ronbtf_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Și pe sfeșnic erau patru boluri făcute ca migdale, nodurile lui și florile lui; ");
INSERT INTO ronbtf_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Și un nod sub două brațe ale lui și un nod sub două brațe ale lui și un nod sub două brațe ale lui, conform celor șase brațe ieșind din acesta. ");
INSERT INTO ronbtf_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Nodurile lor și brațele lor erau la fel; toate acestea erau o singură lucrare bătută din aur pur. ");
INSERT INTO ronbtf_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Și a făcut cele șapte lămpi ale lui și mucările lui și cenușarele lui, din aur pur. ");
INSERT INTO ronbtf_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Dintr-un talant de aur pur l-a făcut cu toate vasele lui. ");
INSERT INTO ronbtf_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Și a făcut altarul pentru tămâie din lemn de salcâm; lungimea lui era un cot și lățimea lui un cot; era pătrat; și doi coți era înălțimea lui; coarnele lui erau din aceeași bucată. ");
INSERT INTO ronbtf_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Și l-a îmbrăcat cu aur pur, deopotrivă vârful lui și laturile lui de jur împrejur și coarnele lui; de asemenea i-a făcut o coroană din aur de jur împrejur. ");
INSERT INTO ronbtf_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Și a făcut două inele din aur pentru acesta sub coroana lui, lângă cele două colțuri ale lui, pe cele două părți ale lui, să fie locuri pentru drugi pentru a-l purta cu totul. ");
INSERT INTO ronbtf_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Și a făcut drugii din lemn de salcâm și i-a placat cu aur. ");
INSERT INTO ronbtf_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Și a făcut untdelemnul sfânt pentru ungere și tămâia pură din mirodenii dulci, conform artei parfumierilor. ");
INSERT INTO ronbtf_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Și el a făcut altarul ofrandei arse din lemn de salcâm: cinci coți era lungimea lui și cinci coți lățimea lui; era pătrat; și trei coți înălțimea lui. ");
INSERT INTO ronbtf_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Și a făcut coarnele lui pe cele patru colțuri ale acestuia; coarnele lui erau din aceeași bucată și l-a placat cu aramă. ");
INSERT INTO ronbtf_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Și a făcut toate vasele altarului, căldările și lopețile și oalele și cârligele pentru carne și tăvile pentru cărbuni, toate vasele lui le-a făcut din aramă. ");
INSERT INTO ronbtf_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Și a făcut pentru altar un grătar din aramă în formă de rețea sub marginea de sus a lui în jos, până la mijlocul acestuia. ");
INSERT INTO ronbtf_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Și a turnat patru inele pentru cele patru capete ale grătarului din aramă, ca să fie locuri pentru drugi. ");
INSERT INTO ronbtf_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Și a făcut drugii din lemn de salcâm și i-a placat cu aramă. ");
INSERT INTO ronbtf_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Și a pus drugii în inele pe laturile altarului, pentru a-l purta cu totul; a făcut altarul gol pe dinăuntru cu scânduri. ");
INSERT INTO ronbtf_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Și a făcut ligheanul din aramă și piciorul lui din aramă, din oglinzile femeilor care se adunau la ușa tabernacolului întâlnirii. ");
INSERT INTO ronbtf_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Și a făcut curtea: pe partea de sud spre sud, perdelele curții erau din in subțire răsucit, de o sută de coți; ");
INSERT INTO ronbtf_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Stâlpii lor erau douăzeci și soclurile lor de aramă, douăzeci; cârligele stâlpilor și vergelele lor erau din argint. ");
INSERT INTO ronbtf_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Și pentru partea de nord perdelele erau de o sută de coți, stâlpii lor erau douăzeci și soclurile lor din aramă, douăzeci; cârligele stâlpilor și vergelele lor din argint. ");
INSERT INTO ronbtf_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Și pentru partea de vest erau perdele de cincizeci de coți, stâlpii lor zece și soclurile lor zece; cârligele stâlpilor și vergelele lor din argint. ");
INSERT INTO ronbtf_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Și pentru partea de est spre est, cincizeci de coți. ");
INSERT INTO ronbtf_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Perdelele uneia din părțile porții erau de cincisprezece coți; stâlpii lor, trei, și soclurile lor, trei. ");
INSERT INTO ronbtf_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Și pentru cealaltă parte a porții curții, de o parte și de alta, erau perdele de cincisprezece coți; stâlpii lor, trei și soclurile lor, trei. ");
INSERT INTO ronbtf_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Toate perdelele curții de jur împrejur erau din in subțire răsucit. ");
INSERT INTO ronbtf_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Și soclurile pentru stâlpi erau din aramă; cârligele stâlpilor și vergelele lor din argint; și placarea capitelurilor lor era din argint; și toți stâlpii curții erau înfășurați cu argint. ");
INSERT INTO ronbtf_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Și perdeaua pentru poarta curții era lucrare brodată, din albastru și purpuriu și stacojiu și in subțire răsucit; și douăzeci de coți era lungimea și înălțimea ca și lățimea era de cinci coți, corespunzând perdelelor curții. ");
INSERT INTO ronbtf_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Și stâlpii lor erau patru și soclurile lor din aramă, patru; cârligele lor din argint și placarea capitelurilor lor și vergelele lor, din argint. ");
INSERT INTO ronbtf_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Și țărușii tabernacolului și ai curții de jur împrejur erau din aramă. ");
INSERT INTO ronbtf_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Aceasta este socoteala tabernacolului, a tabernacolului mărturiei, așa cum a fost socotită, conform poruncii lui Moise, pentru serviciul leviților, prin mâna lui Itamar, fiul lui Aaron preotul. ");
INSERT INTO ronbtf_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Și Bețaleel, fiul lui Uri, fiul lui Hur, din tribul lui Iuda, a făcut tot ceea ce DOMNUL a poruncit lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Și cu el a fost Aholiab, fiul lui Ahisama, din tribul lui Dan, un gravor, un meșteșugar iscusit și un lucrător cu broderie în albastru și în purpuriu și în stacojiu și in subțire. ");
INSERT INTO ronbtf_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Tot aurul care a fost folosit pentru lucrare în toată lucrarea locului sfânt, chiar aurul ofrandei, a fost de douăzeci și nouă de talanți și șapte sute și treizeci de șekeli, după șekelul sanctuarului. ");
INSERT INTO ronbtf_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Și argintul de la cei ce au fost numărați din adunare a fost de o sută de talanți și o mie șapte sute șaptezeci și cinci de șekeli, după șekelul sanctuarului; ");
INSERT INTO ronbtf_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","O beka pentru fiecare bărbat, adică o jumătate de șekel, după șekelul sanctuarului, pentru fiecare bărbat care a mers să fie numărat, de la vârsta de douăzeci de ani în sus, pentru șase sute trei mii cinci sute cincizeci de bărbați. ");
INSERT INTO ronbtf_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Și din cei o sută de talanți de argint au fost turnate soclurile sanctuarului și soclurile perdelei; o sută de socluri din o sută de talanți, un talant pentru un soclu. ");
INSERT INTO ronbtf_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Și din o mie șapte sute șaptezeci și cinci de șekeli el a făcut cârlige pentru stâlpi și a placat capitelurile lor și le-a înfășurat. ");
INSERT INTO ronbtf_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Și arama ofrandei era de șaptezeci de talanți și două mii patru sute de șekeli. ");
INSERT INTO ronbtf_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Și cu aceasta a făcut soclurile ușii tabernacolului întâlnirii și altarul de aramă și grătarul de aramă pentru acesta și toate vasele altarului, ");
INSERT INTO ronbtf_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Și soclurile curții de jur împrejur și soclurile porții curții și toți țărușii tabernacolului și toți țărușii curții de jur împrejur. ");
INSERT INTO ronbtf_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Și din albastru și purpuriu și stacojiu, au făcut haine pentru serviciu, pentru a face serviciul în locul sfânt și au făcut sfintele veșminte pentru Aaron, precum DOMNUL i-a poruncit lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Iar el a făcut efodul din aur, din albastru și purpuriu și stacojiu și in subțire răsucit. ");
INSERT INTO ronbtf_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Și au bătut aurul în plăci subțiri și l-au tăiat în sârme subțiri, pentru a-l lucra în albastru și în purpuriu și în stacojiu și în in subțire răsucit, cu lucrare iscusită. ");
INSERT INTO ronbtf_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Ei au făcut umerarii pentru acesta, ca să îl îmbine; prin cele două margini a fost acesta îmbinat. ");
INSERT INTO ronbtf_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Și brâul făcut cu iscusință al efodului său, care era peste acesta, era din aceeași bucată, conform lucrării acestuia, din aur, din albastru și purpuriu și stacojiu și in subțire răsucit; așa cum DOMNUL i-a poruncit lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Și au lucrat pietre de onix montate în broșe din aur, gravate precum sigiliile sunt gravate, cu numele copiilor lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Și le-a pus pe umerii efodului, ca să fie pietre pentru amintire copiilor lui Israel, precum DOMNUL i-a poruncit lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Și a făcut pieptarul din lucrare iscusită, asemenea lucrării efodului, din aur, din albastru și purpuriu și stacojiu și in subțire răsucit. ");
INSERT INTO ronbtf_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Era pătrat; au făcut pieptarul dublu: o palmă era lungimea lui și o palmă lățimea lui, dublu. ");
INSERT INTO ronbtf_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Și au montat în acesta patru rânduri de pietre; primul rând a fost un sardiu, un topaz și un rubin, acesta a fost primul rând. ");
INSERT INTO ronbtf_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Și al doilea rând, un smarald, un safir și un diamant. ");
INSERT INTO ronbtf_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Și al treilea rând, un hiacint, o agată și un ametist. ");
INSERT INTO ronbtf_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Și al patrulea rând, un beril, un onix și un jasp, ele au fost montate în broșe de aur în monturile lor. ");
INSERT INTO ronbtf_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Și pietrele erau conform cu numele copiilor lui Israel, douăsprezece, conform cu numele lor, asemenea gravurii unui sigiliu, fiecare cu numele lui, conform celor douăsprezece triburi. ");
INSERT INTO ronbtf_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Și au făcut peste pieptar lanțuri la margini, din lucrare împletită din aur pur. ");
INSERT INTO ronbtf_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Și au făcut două broșe din aur și două inele din aur; și au pus cele două inele în cele două capete ale pieptarului. ");
INSERT INTO ronbtf_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Și au pus cele două lanțuri împletite din aur în cele două inele la capetele pieptarului. ");
INSERT INTO ronbtf_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Și cele două capete ale celor două lanțuri împletite ei le-au fixat în cele două broșe și le-au pus pe umerarii efodului, înaintea acestuia. ");
INSERT INTO ronbtf_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Și au făcut două inele din aur și le-au pus la cele două capete ale pieptarului, pe marginea acestuia, care era pe partea efodului înăuntru. ");
INSERT INTO ronbtf_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Și au făcut alte două inele din aur și le-au pus în cele două părți ale efodului pe dedesubt, spre partea dinainte a acestuia, înaintea celeilalte îmbinări a lui, deasupra brâului făcut cu iscusință al efodului. ");
INSERT INTO ronbtf_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Și au legat pieptarul prin inelele sale la inelele efodului cu un șnur albastru, ca să fie deasupra brâului făcut cu iscusință al efodului și ca pieptarul să nu fie desprins de efod, precum DOMNUL i-a poruncit lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Și el a făcut roba efodului din lucrare țesută, toată albastră. ");
INSERT INTO ronbtf_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Și avea o gaură în mijlocul robei, ca gaura unei tunici de zale, cu o bordură de jur împrejurul găurii, ca să nu se sfâșie. ");
INSERT INTO ronbtf_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Și au făcut pe marginile robei rodii albastre și din purpuriu și stacojiu și in răsucit. ");
INSERT INTO ronbtf_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Și au făcut clopoței din aur pur și au pus clopoțeii între rodii pe marginea robei, de jur împrejur între rodii; ");
INSERT INTO ronbtf_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Un clopoțel și o rodie, un clopoțel și o rodie, de jur împrejurul tivului robei pentru a servi, precum DOMNUL i-a poruncit lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Și au făcut tunici din in subțire din lucrare țesută pentru Aaron și pentru fiii lui, ");
INSERT INTO ronbtf_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Și o mitră din in subțire și bonete frumoase din in subțire și pantaloni din in subțire răsucit, ");
INSERT INTO ronbtf_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Și un brâu din in subțire răsucit și albastru și purpuriu și stacojiu, din lucrare brodată, precum DOMNUL i-a poruncit lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Și au făcut placa sfintei coroane din aur pur și au scris pe ea o inscripție, asemenea gravurilor unui sigiliu: SFINȚENIE DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Și au prins de aceasta un șnur albastru, ca să o fixeze sus peste mitră, precum DOMNUL i-a poruncit lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Astfel a fost terminată toată lucrarea tabernacolului cortului întâlnirii; și copiii lui Israel au făcut conform cu tot ceea ce DOMNUL i-a poruncit lui Moise, astfel au făcut ei. ");
INSERT INTO ronbtf_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Și au adus tabernacolul la Moise, cortul și toată mobila lui, copcile lui, scândurile lui, drugii lui și stâlpii lui și soclurile lui, ");
INSERT INTO ronbtf_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","Și acoperământul din piei roșii de berbeci și acoperământul din piei de bursuci și perdeaua acoperământului, ");
INSERT INTO ronbtf_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Chivotul mărturiei și drugii lui și șezământul milei, ");
INSERT INTO ronbtf_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","Masa și toate vasele ei și pâinile punerii înainte, ");
INSERT INTO ronbtf_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","Sfeșnicul pur, cu lămpile lui, cu lămpile pentru a fi puse în ordine și toate vasele lui și untdelemnul pentru lumină, ");
INSERT INTO ronbtf_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Și altarul din aur și untdelemnul pentru ungere și tămâia dulce și perdeaua pentru ușa tabernacolului, ");
INSERT INTO ronbtf_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Și altarul din aramă și grătarul lui din aramă și drugii lui și toate vasele lui, ligheanul și piciorul lui, ");
INSERT INTO ronbtf_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Perdelele curții, stâlpii ei și soclurile ei și perdeaua pentru poarta curții, frânghiile ei și țărușii ei și toate vasele serviciului tabernacolului, pentru cortul întâlnirii, ");
INSERT INTO ronbtf_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Hainele serviciului pentru a face serviciu în locul sfânt și sfintele veșminte pentru preotul Aaron și veșmintele fiilor săi, pentru a servi în serviciul de preot. ");
INSERT INTO ronbtf_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Conform cu tot ceea ce DOMNUL i-a poruncit lui Moise, așa au făcut copiii lui Israel toată lucrarea. ");
INSERT INTO ronbtf_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Și Moise a privit la toată lucrarea și, iată, ei au făcut-o precum DOMNUL a poruncit, chiar așa au făcut-o; și Moise i-a binecuvântat. ");
INSERT INTO ronbtf_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","În prima zi a primei luni ridică tabernacolul cortului întâlnirii. ");
INSERT INTO ronbtf_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Și pune înăuntru chivotul mărturiei și acoperă chivotul cu perdeaua. ");
INSERT INTO ronbtf_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Și adu înăuntru masa și așază în ordine lucrurile care trebuie să fie așezate în ordine pe ea; și adu înăuntru sfeșnicul și aprinde-i lămpile. ");
INSERT INTO ronbtf_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Și așază altarul din aur pentru tămâie înaintea chivotului mărturiei și pune perdeaua ușii tabernacolului. ");
INSERT INTO ronbtf_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Și așază altarul ofrandei arse înaintea ușii tabernacolului cortului întâlnirii. ");
INSERT INTO ronbtf_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Și așază ligheanul între cortul întâlnirii și altar și pune apă în el. ");
INSERT INTO ronbtf_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Și pune curtea de jur împrejur și atârnă perdeaua la poarta curții. ");
INSERT INTO ronbtf_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Și ia untdelemnul pentru ungere și unge tabernacolul și tot ce este în el și sfințește-l și toate vasele lui; și va fi sfânt. ");
INSERT INTO ronbtf_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Și unge altarul ofrandei arse și toate vasele lui și sfințește altarul; și va fi un altar preasfânt. ");
INSERT INTO ronbtf_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Și unge ligheanul și piciorul său și sfințește-l. ");
INSERT INTO ronbtf_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Și adu pe Aaron și pe fiii săi la ușa tabernacolului întâlnirii și spală-i cu apă. ");
INSERT INTO ronbtf_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Și pune sfintele veșminte peste Aaron și unge-l și sfințește-l, ca el să îmi servească în serviciul de preot. ");
INSERT INTO ronbtf_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Și adu pe fiii săi și îmbracă-i cu haine; ");
INSERT INTO ronbtf_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Și unge-i, precum ai uns pe tatăl lor, ca ei să îmi servească în serviciul de preot, pentru că ungerea lor va fi cu adevărat o preoție veșnică prin toate generațiile. ");
INSERT INTO ronbtf_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Astfel a făcut Moise, conform cu tot ceea ce DOMNUL i-a poruncit, așa a făcut el. ");
INSERT INTO ronbtf_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Și s-a întâmplat, în prima lună, în al doilea an, în prima zi a lunii, că tabernacolul a fost înălțat. ");
INSERT INTO ronbtf_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Și Moise a ridicat tabernacolul și a fixat soclurile acestuia și a așezat scândurile lui și i-a pus drugii și i-a înălțat stâlpii. ");
INSERT INTO ronbtf_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Și a întins cortul peste tabernacol și a pus acoperământul cortului deasupra acestuia, precum DOMNUL i-a poruncit lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Și a luat și a pus mărturia în chivot și a pus drugii la chivot și a pus șezământul milei deasupra, peste chivot. ");
INSERT INTO ronbtf_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Și a adus chivotul în tabernacol și a pus perdeaua acoperământului și a acoperit chivotul mărturiei, precum DOMNUL a poruncit lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Și a pus masa în cortul întâlnirii, pe partea tabernacolului spre nord, dincoace de perdea. ");
INSERT INTO ronbtf_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Și a pus pâinea prezentării în ordine pe aceasta înaintea DOMNULUI, precum DOMNUL i-a poruncit lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Și a pus sfeșnicul în cortul întâlnirii, lângă masă, pe partea tabernacolului spre sud. ");
INSERT INTO ronbtf_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Și a aprins lămpile înaintea DOMNULUI, precum DOMNUL i-a poruncit lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Și a pus altarul din aur în cortul întâlnirii înaintea perdelei; ");
INSERT INTO ronbtf_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Și a ars tămâie dulce pe acesta, precum DOMNUL i-a poruncit lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Și a pus perdeaua la ușa tabernacolului. ");
INSERT INTO ronbtf_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Și a pus altarul ofrandei arse la ușa tabernacolului cortului întâlnirii și a oferit pe acesta ofranda arsă și darul de mâncare, precum DOMNUL i-a poruncit lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Și a așezat ligheanul între cortul întâlnirii și altar și a pus apă acolo pentru spălare. ");
INSERT INTO ronbtf_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Și Moise și Aaron și fiii săi și-au spălat mâinile și picioarele acolo; ");
INSERT INTO ronbtf_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Când au intrat în cortul întâlnirii și când s-au apropiat de altar, s-au spălat, precum DOMNUL i-a poruncit lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Și a înălțat curtea de jur împrejurul tabernacolului și altarului și a atârnat perdeaua porții curții. Astfel Moise a terminat lucrarea. ");
INSERT INTO ronbtf_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Atunci un nor a acoperit cortul întâlnirii și gloria DOMNULUI a umplut tabernacolul. ");
INSERT INTO ronbtf_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Și Moise nu a fost în stare să intre în cortul întâlnirii, deoarece norul a rămas peste el și gloria DOMNULUI a umplut tabernacolul. ");
INSERT INTO ronbtf_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Și după ce norul s-a ridicat de pe tabernacol, copiii lui Israel au mers înainte în toate călătoriile lor; ");
INSERT INTO ronbtf_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Dar dacă norul nu s-a ridicat, nu au călătorit până în ziua în care acesta s-a ridicat. ");
INSERT INTO ronbtf_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Căci norul DOMNULUI era peste tabernacol în timpul zilei și foc era peste el în timpul nopții, înaintea ochilor întregii case a lui Israel, prin toate călătoriile lor. ");
INSERT INTO ronbtf_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Și DOMNUL l-a chemat pe Moise și i-a vorbit din tabernacolul întâlnirii, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Vorbește copiilor lui Israel și spune-le: Dacă cineva dintre voi aduce un dar DOMNULUI, să aduceți darul vostru dintre vite, din cireadă și din turmă. ");
INSERT INTO ronbtf_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Dacă darul lui este un sacrificiu ars din cireadă, să aducă o parte bărbătească, fără cusur; să îl aducă după buna sa voie la ușa tabernacolului întâlnirii înaintea DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Și să își pună mâna pe capul ofrandei arse; și îi va fi primită să facă ispășire pentru el. ");
INSERT INTO ronbtf_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Și să înjunghie taurul înaintea DOMNULUI; și preoții, fiii lui Aaron, să aducă sângele și să stropească sângele de jur împrejur pe altarul care este lângă ușa tabernacolului întâlnirii. ");
INSERT INTO ronbtf_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Și să jupoaie ofranda arsă și să o taie în bucățile ei. ");
INSERT INTO ronbtf_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Și fiii preotului Aaron să pună foc peste altar și să pună lemnele în ordine pe foc; ");
INSERT INTO ronbtf_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Și preoții, fiii lui Aaron, să pună bucățile, capul și grăsimea în ordine peste lemnele care sunt pe focul de pe altar; ");
INSERT INTO ronbtf_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Dar măruntaiele lui și picioarele lui să le spele în apă; și preotul să ardă totul pe altar, pentru a fi un sacrificiu ars, ofrandă făcută prin foc, de o aromă dulce DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Și dacă darul lui este din turme, adică dintre oi, sau dintre capre, pentru un sacrificiu ars, să aducă o parte bărbătească, fără cusur. ");
INSERT INTO ronbtf_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Și să îl înjunghie pe partea altarului dinspre nord înaintea DOMNULUI; și preoții, fiii lui Aaron, să stropească sângele lui pe altar de jur împrejur. ");
INSERT INTO ronbtf_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Și să îl taie în bucățile lui cu capul lui și grăsimea lui; și preotul să le pună în ordine pe lemne, în focul de pe altar; ");
INSERT INTO ronbtf_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Dar să spele măruntaiele și picioarele cu apă și preotul să le aducă pe toate și să le ardă pe altar; este un sacrificiu ars, ofrandă făcută prin foc, de o aromă dulce DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Și dacă sacrificiul ars pentru darul său DOMNULUI este dintre păsări, atunci să aducă darul său dintre turturele, sau dintre porumbei tineri. ");
INSERT INTO ronbtf_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Și preotul să îl aducă la altar și să îi smulgă capul și să îl ardă pe altar; și sângele lui să fie stors la marginea altarului; ");
INSERT INTO ronbtf_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Și să îi smulgă gușa cu penele ei și să o arunce lângă altar în partea de est, lângă locul cenușii; ");
INSERT INTO ronbtf_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Și să despice pasărea cu aripile ei, dar să nu o împartă în două; și preotul să o ardă pe altar, peste lemnele care sunt în foc; este un sacrificiu ars, ofrandă făcută prin foc, de o aromă dulce DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Și când va aduce cineva un dar de mâncare DOMNULUI, darul lui să fie din floarea făinii; și să toarne untdelemn pe el și să pună tămâie pe el; ");
INSERT INTO ronbtf_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Și să îl aducă fiilor lui Aaron, preoții, și să ia din el, din făină, o mână a sa plină și din untdelemnul lui, cu toată tămâia lui; și preotul să ardă amintirea lui pe altar, să fie ofrandă făcută prin foc, de o aromă dulce DOMNULUI; ");
INSERT INTO ronbtf_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Și rămășița din darul de mâncare să fie a lui Aaron și a fiilor săi; este un lucru preasfânt al darurilor DOMNULUI, făcute prin foc. ");
INSERT INTO ronbtf_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Și dacă aduci ca dar, un dar de mâncare copt în cuptor, să fie din turte nedospite din floarea făinii amestecată cu untdelemn, sau biscuiți nedospiți unși cu untdelemn. ");
INSERT INTO ronbtf_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Și dacă darul tău este un dar de mâncare copt într-o tavă, să fie din floarea făinii nedospită, amestecată cu untdelemn. ");
INSERT INTO ronbtf_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Să îl împarți în bucăți și să torni untdelemn peste el, este un dar de mâncare. ");
INSERT INTO ronbtf_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Și dacă darul tău este un dar de mâncare copt în tigaie, să fie făcut din floarea făinii amestecată cu untdelemn. ");
INSERT INTO ronbtf_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Și să aduci DOMNULUI darul de mâncare ce este făcut din aceste lucruri; și când acesta este prezentat preotului, el să îl aducă la altar. ");
INSERT INTO ronbtf_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Și preotul să ia din darul de mâncare o amintire din acesta și să îl ardă pe altar, este ofrandă făcută prin foc, de o aromă dulce DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Și ce rămâne din darul de mâncare să fie a lui Aaron și a fiilor săi; este un lucru preasfânt al ofrandelor DOMNULUI făcute prin foc. ");
INSERT INTO ronbtf_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Niciun dar de mâncare, pe care îl aduceți DOMNULUI, să nu fie făcut cu dospeală, pentru aceasta să nu ardeți nimic dospit, nici ceva cu miere, în niciuna din ofrandele DOMNULUI făcute prin foc. ");
INSERT INTO ronbtf_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Cât despre ofranda primelor roade, să le aduceți DOMNULUI, dar să nu fie arse pe altar pentru o aromă dulce. ");
INSERT INTO ronbtf_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Și fiecare dar al darului tău de mâncare să îl sărezi cu sare; și să nu permiți sării legământului Dumnezeului tău să lipsească din darul tău de mâncare; cu toate darurile tale să oferi sare. ");
INSERT INTO ronbtf_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Și dacă aduci DOMNULUI un dar de mâncare din primele tale roade, să oferi spice verzi de grâne uscate în foc pentru darul de mâncare din primele roade, sau grăunțe din spice pisate și coapte. ");
INSERT INTO ronbtf_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Și să pui untdelemn pe el și să pui tămâie pe el, este un dar de mâncare. ");
INSERT INTO ronbtf_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Și preotul să ardă amintirea acesteia, parte din grăunțele pisate ale acestuia, și parte din untdelemnul acestuia, cu toată tămâia lui; este ofrandă făcută prin foc DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Și dacă darul său este un sacrificiu al ofrandei de pace, dacă îl aduce din cireadă, fie parte bărbătească, fie parte femeiască, să îl aducă, fără cusur, înaintea DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Și să își pună mâna sa pe capul darului său și să îl înjunghie la ușa tabernacolului întâlnirii; și preoții, fiii lui Aaron să stropească sângele pe altar de jur împrejur. ");
INSERT INTO ronbtf_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Și să aducă din sacrificiul ofrandei de pace, ofrandă făcută prin foc DOMNULUI; grăsimea care acoperă măruntaiele și toată grăsimea care este pe măruntaie, ");
INSERT INTO ronbtf_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","Și cei doi rinichi și grăsimea care este pe ei, care este pe coapse și lobul de pe ficat cu rinichii, să le scoată. ");
INSERT INTO ronbtf_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Și fiii lui Aaron să le ardă pe altar pe sacrificiul ars, pe lemnele de pe foc; este ofrandă făcută prin foc, de o aromă dulce DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Și dacă darul lui, ca un sacrificiu al ofrandei de pace pentru DOMNUL, este din turmă, parte bărbătească sau parte femeiască, să îl aducă, fără cusur. ");
INSERT INTO ronbtf_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Dacă aduce un miel, ca ofrandă a sa, atunci să îl aducă înaintea DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Și să își pună mâna pe capul darului său și să îl înjunghie înaintea tabernacolului întâlnirii; și fiii lui Aaron să stropească sângele lui pe altar, de jur împrejur. ");
INSERT INTO ronbtf_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Și să aducă din sacrificiul ofrandei de pace, ofrandă făcută prin foc pentru DOMNUL; grăsimea acestuia și întreaga noadă, să o scoată de pe osul spinării; și grăsimea care acoperă măruntaiele și toată grăsimea care este pe măruntaie, ");
INSERT INTO ronbtf_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","Și cei doi rinichi și grăsimea care este pe ei, care este pe coapse și lobul de pe ficat cu rinichii, să le scoată. ");
INSERT INTO ronbtf_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Și preotul să le ardă pe altar, aceasta este mâncarea din ofranda făcută prin foc DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Și dacă darul său este o capră, atunci să o aducă înaintea DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Și să își pună mâna pe capul ei și să o înjunghie înaintea tabernacolului întâlnirii; și fiii lui Aaron să stropească sângele ei pe altar, de jur împrejur. ");
INSERT INTO ronbtf_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Și să aducă darul său din aceasta, ofrandă făcută prin foc DOMNULUI; grăsimea care acoperă măruntaiele și toată grăsimea care este pe măruntaie, ");
INSERT INTO ronbtf_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","Și cei doi rinichi și grăsimea care este pe ei, care este pe coapse și lobul de pe ficat cu rinichii, să le scoată. ");
INSERT INTO ronbtf_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Și preotul să le ardă pe altar; aceasta este mâncarea din ofranda făcută prin foc, de o aromă dulce, toată grăsimea este a DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Acesta să fie un statut continuu pentru generațiile voastre, prin toate locuințele voastre: Să nu mâncați nici grăsime nici sânge. ");
INSERT INTO ronbtf_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Vorbește copiilor lui Israel, zicând: Dacă un suflet va păcătui din ignoranță împotriva oricăreia dintre poruncile DOMNULUI, referitor la lucruri care nu trebuiesc făcute, și va lucra împotriva oricăreia dintre ele; ");
INSERT INTO ronbtf_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Dacă preotul, care este uns păcătuiește conform cu păcatul poporului, atunci el să aducă DOMNULUI pentru păcatul său, pe care l-a păcătuit, un taur tânăr, fără cusur, DOMNULUI, ca ofrandă pentru păcat. ");
INSERT INTO ronbtf_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Și să aducă taurul la ușa tabernacolului întâlnirii înaintea DOMNULUI; și să își pună mâna pe capul taurului și să înjunghie taurul înaintea DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Și preotul, care este uns, să ia din sângele taurului și să îl aducă la tabernacolul întâlnirii; ");
INSERT INTO ronbtf_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Și preotul să își înmoaie degetul în sânge și să stropească din sângele taurului de șapte ori înaintea DOMNULUI, înaintea perdelei sanctuarului. ");
INSERT INTO ronbtf_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Și preotul să pună din sânge, înaintea DOMNULUI, pe coarnele altarului de tămâie dulce, care este în tabernacolul întâlnirii; și să toarne tot sângele taurului al ofrandei arse la baza altarului, care este la ușa tabernacolului întâlnirii. ");
INSERT INTO ronbtf_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Și să scoată din el toată grăsimea taurului pentru ofranda pentru păcat; grăsimea care acoperă măruntaiele și toată grăsimea care este pe măruntaie. ");
INSERT INTO ronbtf_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","Și cei doi rinichi și grăsimea care este pe ei, care este pe coapse și lobul de pe ficat cu rinichii, pe acestea să le scoată, ");
INSERT INTO ronbtf_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Precum a fost scoasă din taurul sacrificiului ofrandei de pace; și preotul să le ardă pe altarul ofrandei arse. ");
INSERT INTO ronbtf_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Și pielea taurului și toată carnea lui, cu capul lui și cu picioarele lui și măruntaiele lui și balega lui, ");
INSERT INTO ronbtf_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","Chiar întregul taur să-l ducă în afara taberei la un loc curat, unde este turnată cenușa, și să îl ardă cu foc, pe lemne; să fie ars acolo unde este turnată cenușa. ");
INSERT INTO ronbtf_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Și dacă întreaga adunare a lui Israel păcătuiește din ignoranță și lucrul este ascuns de ochii adunării și ei au făcut ceva împotriva oricăreia dintre poruncile DOMNULUI, referitor la lucruri care nu trebuiesc făcute, și sunt vinovați, ");
INSERT INTO ronbtf_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Când păcatul, pe care l-au păcătuit este cunoscut, adunarea să aducă un taur tânăr pentru păcat și să îl aducă înaintea tabernacolului întâlnirii. ");
INSERT INTO ronbtf_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Și bătrânii adunării să își pună mâinile pe capul taurului înaintea DOMNULUI și taurul să fie înjunghiat înaintea DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Și preotul, care este uns, să aducă din sângele taurului la tabernacolul întâlnirii; ");
INSERT INTO ronbtf_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Și preotul să își înmoaie degetul în sânge și să îl stropească de șapte ori înaintea DOMNULUI, înaintea perdelei. ");
INSERT INTO ronbtf_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Și să pună câtva din sânge pe coarnele altarului, care este înaintea DOMNULUI, care este în tabernacolul întâlnirii, și să toarne tot sângele la baza altarului pentru ofrandele arse, care este la ușa tabernacolului întâlnirii. ");
INSERT INTO ronbtf_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Și să îi scoată toată grăsimea și să o ardă pe altar. ");
INSERT INTO ronbtf_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Și să facă cu taurul precum a făcut cu taurul pentru ofrandă pentru păcat, astfel să facă el cu acesta și preotul să facă ispășire pentru ei, și acesta să le fie iertat. ");
INSERT INTO ronbtf_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Și el să care taurul în afara taberei și să îl ardă precum l-a ars pe primul taur, aceasta este ofrandă pentru păcat, pentru adunare. ");
INSERT INTO ronbtf_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Când un conducător a păcătuit și a făcut ceva din ignoranță împotriva oricăreia dintre poruncile DOMNULUI Dumnezeul său, referitor la lucruri care nu trebuiesc făcute, și este vinovat, ");
INSERT INTO ronbtf_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Sau dacă păcatul său, în care a păcătuit, ajunge la cunoașterea sa, el să-și aducă darul, un ied dintre capre, o parte bărbătească, fără cusur; ");
INSERT INTO ronbtf_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Și să își pună mâna pe capul țapului și să îl înjunghie în locul unde ei înjunghie ofranda arsă, înaintea DOMNULUI, aceasta este ofrandă pentru păcat. ");
INSERT INTO ronbtf_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Și preotul să ia din sângele ofrandei pentru păcat, cu degetul său, și să îl pună pe coarnele altarului ofrandei arse și să toarne sângele lui la baza altarului pentru ofranda arsă. ");
INSERT INTO ronbtf_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Și să îi ardă toată grăsimea pe altar, precum grăsimea sacrificiului ofrandelor de pace; și preotul să facă ispășire pentru el, referitor la păcatul lui, și acesta îi va fi iertat. ");
INSERT INTO ronbtf_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Și dacă oricine dintre oamenii de rând păcătuiește din ignoranță, făcând ceva împotriva oricăreia dintre poruncile DOMNULUI, referitor la lucruri care nu trebuiesc făcute, și este vinovat, ");
INSERT INTO ronbtf_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Sau dacă păcatul său, pe care l-a păcătuit ajunge la cunoașterea sa, atunci să își aducă darul: un ied dintre capre, parte femeiască fără cusur, pentru păcatul său pe care l-a păcătuit. ");
INSERT INTO ronbtf_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Și să își pună mâna pe capul ofrandei pentru păcat și să înjunghie ofranda pentru păcat în locul unde se face ofranda arsă. ");
INSERT INTO ronbtf_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Și preotul să ia din sângele ei cu degetul său și să îl pună pe coarnele altarului al ofrandei arse și să toarne tot sângele ei la baza altarului. ");
INSERT INTO ronbtf_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Și să scoată toată grăsimea acesteia, precum este scoasă grăsimea de la sacrificiul ofrandelor de pace; și preotul să o ardă pe altar pentru o aromă dulce DOMNULUI; și preotul să facă ispășire pentru el și acesta să îi fie iertat. ");
INSERT INTO ronbtf_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Și dacă el aduce un miel ca ofrandă pentru păcat, el să aducă o parte femeiască fără cusur. ");
INSERT INTO ronbtf_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Și să își pună mâna pe capul ofrandei pentru păcat și să o înjunghie ca ofrandă pentru păcat în locul unde ei înjunghie ofranda arsă. ");
INSERT INTO ronbtf_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Și preotul să ia din sângele ofrandei pentru păcat cu degetul său și să îl pună pe coarnele altarului pentru ofranda arsă și să toarne tot sângele ei la baza altarului; ");
INSERT INTO ronbtf_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Și să scoată toată grăsimea ei, precum este scoasă grăsimea mielului de la sacrificiul ofrandelor de pace; și preotul să le ardă pe altar, conform ofrandelor făcute prin foc DOMNULUI; și preotul să facă ispășire pentru păcatul lui pe care l-a făcut și acesta îi va fi iertat. ");
INSERT INTO ronbtf_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Și dacă un suflet păcătuiește și aude vocea jurământului și este martor, fie că a văzut, fie că a cunoscut aceasta, dacă el nu rostește aceasta, atunci el să poarte nelegiuirea sa. ");
INSERT INTO ronbtf_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Sau dacă un suflet atinge vreun lucru necurat, fie trupul mort al unei fiare necurate, fie trupul mort al unei vite necurate, fie trupul mort al vreunei târâtoare necurate și dacă aceasta este ascunsă de el, el de asemenea să fie necurat și vinovat. ");
INSERT INTO ronbtf_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Sau dacă atinge necurăția unui om, oricare ar fi această necurăție prin care este pângărit și aceasta este ascunsă de el; când el va ști, să fie vinovat. ");
INSERT INTO ronbtf_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Sau dacă un suflet jură, rostind cu buzele să facă rău, sau să facă bine, orice rostește un om, cu jurământ și aceasta este ascunsă de el; când va ști, să fie vinovat într-una din acestea. ");
INSERT INTO ronbtf_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Și așa să fie, când va fi vinovat într-unul din aceste lucruri, el să mărturisească în ce a păcătuit; ");
INSERT INTO ronbtf_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Și să aducă DOMNULUI ofranda sa pentru fărădelege, pentru păcatul său pe care l-a păcătuit, o parte femeiască din turmă, un miel sau un ied dintre capre, ca ofrandă pentru păcat; și preotul să facă ispășire pentru el referitor la păcatul lui. ");
INSERT INTO ronbtf_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Și dacă nu este în stare să aducă un miel, atunci să aducă DOMNULUI pentru fărădelegea sa ce a făcut-o, două turturele sau doi porumbei tineri; unul ca ofrandă pentru păcat și celălalt ca ofrandă arsă. ");
INSERT INTO ronbtf_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Și să le aducă preotului, care să aducă ceea ce este ca ofrandă pentru păcat mai întâi și să îi smulgă capul de pe gâtul ei, dar să nu o rupă în două bucăți; ");
INSERT INTO ronbtf_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Și să stropească din sângele ofrandei pentru păcat pe latura altarului; și restul sângelui să îl stoarcă la baza altarului, aceasta este ofrandă pentru păcat. ");
INSERT INTO ronbtf_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Și să îl aducă pe al doilea ca ofrandă arsă, conform obiceiului; și preotul să facă ispășire pentru el, pentru păcatul lui pe care l-a păcătuit, și îi va fi iertat. ");
INSERT INTO ronbtf_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Dar dacă el nu este în stare să aducă două turturele, sau doi porumbei tineri, atunci cel ce a păcătuit să aducă pentru darul său, a zecea parte dintr-o efă de floarea făinii, ca ofrandă pentru păcat; să nu pună untdelemn peste ele, nici să nu pună tămâie în ea, pentru că este ofrandă pentru păcat. ");
INSERT INTO ronbtf_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Apoi să o aducă la preot și preotul să ia o mână plină din ea, o amintire a ei și o să ardă pe altar, conform ofrandelor făcute prin foc DOMNULUI, aceasta este ofrandă pentru păcat. ");
INSERT INTO ronbtf_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Și preotul să facă ispășire pentru el referitor la păcatul lui pe care l-a păcătuit într-una din acestea și îi va fi iertat; și ce rămâne să fie a preotului, ca dar de mâncare. ");
INSERT INTO ronbtf_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Dacă un suflet face o fărădelege și păcătuiește din ignoranță, în lucrurile sfinte ale DOMNULUI, atunci el să aducă DOMNULUI pentru fărădelegea sa, un berbec fără cusur din turme, cu prețuirea ta în șekeli de argint, după șekelul sanctuarului, ca ofrandă pentru fărădelege; ");
INSERT INTO ronbtf_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Și pentru vătămarea pe care a adus-o în lucrul sfânt, să plătească înapoi și să adauge a cincea parte la ea și să o dea preotului; și preotul să facă ispășire pentru el cu berbecul ofrandei pentru fărădelege și fărădelegea îi va fi iertată. ");
INSERT INTO ronbtf_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Și dacă un suflet păcătuiește și face oricare din aceste lucruri care sunt interzise, prin poruncile DOMNULUI, a fi făcute; chiar dacă nu a știut, totuși este vinovat și va purta nelegiuirea sa. ");
INSERT INTO ronbtf_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Și să aducă preotului un berbec, fără cusur, din turmă cu prețuirea ta, ca ofrandă pentru fărădelege; și preotul să facă ispășire pentru el referitor la ignoranța lui, în care a greșit și despre care nu a știut și păcatul îi va fi iertat. ");
INSERT INTO ronbtf_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Aceasta este ofrandă pentru fărădelege, a încălcat negreșit împotriva DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Dacă un suflet păcătuiește și face o fărădelege împotriva DOMNULUI și minte pe aproapele său în ceea ce i-a fost încredințat să păstreze, sau în părtășie, sau într-un lucru luat prin violență, sau și-a înșelat aproapele; ");
INSERT INTO ronbtf_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","Sau a găsit ceea ce era pierdut și minte referitor la aceasta și jură în mod fals, în oricare din toate acestea, pe care omul le face, păcătuind în acestea, ");
INSERT INTO ronbtf_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Atunci astfel să fie, deoarece a păcătuit și este vinovat, să restaureze ceea ce a luat în mod violent, sau lucrul pe care l-a dobândit în mod înșelător, sau ceea ce i-a fost predat să păstreze, sau lucrul pierdut pe care l-a găsit, ");
INSERT INTO ronbtf_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Sau tot despre ceea ce a jurat în mod fals, să restaureze întru totul și să adauge a cincea parte în plus la acesta, și să îl dea celui ce îi aparține în ziua ofrandei sale pentru fărădelege. ");
INSERT INTO ronbtf_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Și să aducă DOMNULUI ofranda sa pentru fărădelege, un berbec fără cusur din turmă, cu prețuirea ta, ca ofrandă pentru fărădelege, adusă preotului; ");
INSERT INTO ronbtf_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Și preotul să facă ispășire pentru el înaintea DOMNULUI și să fie iertat pentru orice lucru, tot ceea ce el a făcut în fărădelege. ");
INSERT INTO ronbtf_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Poruncește lui Aaron și fiilor săi, zicând: Aceasta este legea ofrandei arse: Este ofranda arsă, din cauza arderii ei pe altar toată noaptea, până dimineața, și focul altarului să ardă continuu pe el. ");
INSERT INTO ronbtf_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Și preotul să se îmbrace cu hainele sale de in și izmenele sale de in să le pună peste carnea sa, și să ridice cenușa pe care focul a mistuit-o cu ofranda arsă pe altar, și să o pună lângă altar. ");
INSERT INTO ronbtf_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Și să își scoată hainele și să se îmbrace cu alte haine, și să care cenușa în afara taberei la un loc curat. ");
INSERT INTO ronbtf_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Și focul de pe altar să ardă pe el; să nu se stingă; și preotul să ardă lemne pe el în fiecare dimineață și să pună în ordine, peste acestea, ofranda arsă; și să ardă pe el grăsimea ofrandelor de pace. ");
INSERT INTO ronbtf_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Focul să ardă continuu pe altar; să nu se stingă niciodată. ");
INSERT INTO ronbtf_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Și aceasta este legea darului de mâncare: fiii lui Aaron să îl aducă înaintea DOMNULUI, înaintea altarului. ");
INSERT INTO ronbtf_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Și să își ia din el o mână plină de făină, din darul de mâncare și din untdelemnul ei, și toată tămâia care este deasupra darului de mâncare și să ardă pe altar, ca aromă dulce, amintirea lui, adusă DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Și rămășița lui, Aaron și fiii săi să o mănânce, cu azime să fie aceasta mâncată în locul sfânt; în curtea tabernacolului întâlnirii să o mănânce. ");
INSERT INTO ronbtf_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Să nu fie copt cu dospeală. Eu l-am dat lor ca parte a lor din ofrandele mele făcute prin foc; este preasfânt, precum este ofranda pentru păcat și ofranda pentru fărădelege. ");
INSERT INTO ronbtf_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Toți cei de parte bărbătească, dintre copiii lui Aaron, să mănânce din acesta. Este un statut pentru totdeauna în generațiile voastre, referitor la ofrandele DOMNULUI făcute prin foc; fiecare bărbat ce le atinge să fie sfânt. ");
INSERT INTO ronbtf_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Acesta este darul lui Aaron și al fiilor săi, pe care să îl aducă DOMNULUI în ziua în care este uns; a zecea parte dintr-o efă de floarea făinii ca un continuu dar de mâncare, jumătate din ea dimineața și jumătate din ea, noaptea. ");
INSERT INTO ronbtf_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Într-o tavă să fie făcut cu untdelemn, și când este copt să îl aduci înăuntru, și bucățile coapte din darul de mâncare să le oferi ca aromă dulce DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Și preotul, dintre fiii lui, care este uns în locul lui, să îl aducă, acesta este un statut pentru totdeauna adus DOMNULUI, să fie ars în întregime. ");
INSERT INTO ronbtf_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Pentru ca fiecare dar de mâncare, pentru preot, să fie ars în întregime, acesta să nu fie mâncat. ");
INSERT INTO ronbtf_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Și DOMNUL i-a vorbit lui Moise, zicând: ");
INSERT INTO ronbtf_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","Vorbește lui Aaron și fiilor săi, spunând: Aceasta este legea ofrandei pentru păcat: În locul unde ofranda arsă este înjunghiată, să fie și ofranda pentru păcat înjunghiată, înaintea DOMNULUI, ea este preasfântă. ");
INSERT INTO ronbtf_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Preotul, care o aduce pentru păcat să o mănânce, în locul sfânt să fie mâncată, în curtea tabernacolului întâlnirii. ");
INSERT INTO ronbtf_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Orice va atinge carnea acesteia să fie sfânt; și când este stropit din sângele ei peste orice haină, tu să speli ce a fost stropit în locul sfânt. ");
INSERT INTO ronbtf_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Dar vasul de lut în care aceasta este fiartă să fie spart; și dacă este fiartă într-o oală de aramă, aceasta să fie deopotrivă frecată și clătită în apă. ");
INSERT INTO ronbtf_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Toți cei de parte bărbătească dintre preoți să o mănânce, aceasta este preasfântă. ");
INSERT INTO ronbtf_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Și nicio ofrandă pentru păcat, din care este adus sânge în tabernacolul întâlnirii pentru a face împăcare cu el în locul sfânt, să nu fie mâncată, să fie arsă în foc. ");
INSERT INTO ronbtf_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","În același fel aceasta este legea ofrandei pentru fărădelege, este preasfântă. ");
INSERT INTO ronbtf_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","În locul unde ei înjunghie ofranda arsă, acolo să înjunghie ofranda pentru fărădelege, și sângele ei să îl stropească peste altar de jur împrejur. ");
INSERT INTO ronbtf_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Și să aducă din aceasta toată grăsimea ei; noada și grăsimea care acoperă măruntaiele, ");
INSERT INTO ronbtf_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","Și cei doi rinichi și grăsimea care este pe ei, care este pe coapse și lobul de pe ficat cu rinichii, pe acestea să le scoată; ");
INSERT INTO ronbtf_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Și preotul să ardă acestea pe altar ca ofrandă făcută prin foc DOMNULUI, aceasta este ofrandă pentru fărădelege. ");
INSERT INTO ronbtf_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Fiecare bărbat dintre preoți să mănânce din aceasta; ea să fie mâncată în locul sfânt, este preasfântă. ");
INSERT INTO ronbtf_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Precum este ofranda pentru păcat, astfel este ofranda pentru fărădelege, este o singură lege pentru ele, preotul, care face ispășire cu ea, o va avea. ");
INSERT INTO ronbtf_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Și preotul care aduce ofranda arsă a oricărui bărbat, preotul să ia pentru el pielea ofrandei arse, pe care el a adus-o. ");
INSERT INTO ronbtf_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Și darul de mâncare, copt în cuptor, și tot ce este gătit în tigaie și în tavă, să fie al preotului care o aduce. ");
INSERT INTO ronbtf_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Și fiecare dar de mâncare, amestecat cu untdelemn și uscat, îl vor avea toți fiii lui Aaron, al unuia ca și al celuilalt. ");
INSERT INTO ronbtf_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Și aceasta este legea sacrificiului ofrandelor de pace, pe care să îl aducă DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Dacă aduce ca mulțumire, să aducă cu sacrificiul de mulțumire, turte nedospite, amestecate cu untdelemn, și biscuiți nedospiți, unși cu untdelemn, și turte amestecate cu untdelemn, din floarea făinii, prăjite. ");
INSERT INTO ronbtf_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Pe lângă turte, să ofere ca daruri ale sale, pâine dospită cu sacrificiul de mulțumire al ofrandelor sale de pace. ");
INSERT INTO ronbtf_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Și din acestea să aducă unul din darul întreg ca ofrandă ridicată pentru DOMNUL, și să fie a preotului care stropește sângele ofrandelor de pace. ");
INSERT INTO ronbtf_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Și carnea sacrificiului ofrandelor sale de pace pentru mulțumiri să fie mâncată în aceeași zi în care este adusă; să nu lase nimic din ea până dimineață. ");
INSERT INTO ronbtf_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Dar dacă sacrificiul ofrandei sale este un lucru promis, sau ofrandă de bunăvoie, aceasta să fie mâncată în aceeași zi în care este adus sacrificiul lui; și a doua zi, de asemenea să fie mâncată rămășița acesteia; ");
INSERT INTO ronbtf_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Dar rămășița din carnea sacrificiului care rămâne în a treia zi să fie arsă cu foc. ");
INSERT INTO ronbtf_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Și dacă ceva din carnea sacrificiului ofrandelor sale de pace este mâncată în a treia zi, aceasta să nu fie acceptată, nici imputată celui ce a adus-o, să fie o urâciune și sufletul ce o mănâncă va purta nelegiuirea sa. ");
INSERT INTO ronbtf_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Și carnea ce atinge orice lucru necurat să nu fie mâncată, să fie arsă cu foc; și cât despre carne, tot cel ce este curat să mănânce din ea. ");
INSERT INTO ronbtf_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Dar sufletul care mănâncă din carnea sacrificiului ofrandelor de pace, care aparține DOMNULUI, având necurăția lui asupra lui, chiar acel suflet să fie stârpit din poporul său. ");
INSERT INTO ronbtf_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Mai mult, sufletul ce va atinge orice lucru necurat, ca necurăția unui om sau orice vită necurată sau orice lucru urâcios și necurat, și va mânca din carnea sacrificiului ofrandelor de pace, care aparține DOMNULUI, chiar acel suflet să fie stârpit din poporul său. ");
INSERT INTO ronbtf_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Vorbește copiilor lui Israel, zicând: Să nu mâncați niciun fel de grăsime, nici de bou, nici de oaie, nici de capră. ");
INSERT INTO ronbtf_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Și grăsimea vitei care moare de la sine și grăsimea celei care este sfâșiată, de fiare, poate fi folosită în orice altă lucrare, dar voi în niciun caz să nu mâncați din ea. ");
INSERT INTO ronbtf_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Pentru că oricine mănâncă grăsimea vitei, din care oamenii aduc ofrandă făcută prin foc DOMNULUI, chiar acel suflet care o mănâncă să fie stârpit din poporul său. ");
INSERT INTO ronbtf_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Mai mult, să nu mâncați niciun fel de sânge, fie de pasăre fie de vită, în niciuna din locuințele voastre. ");
INSERT INTO ronbtf_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Oricare ar fi sufletul care mănâncă orice fel de sânge, chiar acel suflet să fie stârpit din poporul său. ");
INSERT INTO ronbtf_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Vorbește copiilor lui Israel, zicând: Cel ce aduce DOMNULUI sacrificiul ofrandelor sale de pace, să aducă darul său DOMNULUI din sacrificiul ofrandelor sale de pace. ");
INSERT INTO ronbtf_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Propriile sale mâini să aducă acele ofrande ale DOMNULUI, făcute prin foc, să aducă grăsimea cu pieptul; pieptul să fie legănat ca ofrandă legănată înaintea DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Și preotul să ardă grăsimea pe altar, dar pieptul să fie al lui Aaron și al fiilor săi. ");
INSERT INTO ronbtf_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Și spata dreaptă să o dați preotului ca ofrandă ridicată din sacrificiile ofrandelor voastre de pace. ");
INSERT INTO ronbtf_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Acela dintre fiii lui Aaron, care aduce sângele ofrandelor de pace și grăsimea, să ia spata dreaptă ca partea sa. ");
INSERT INTO ronbtf_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Pentru că pieptul legănat și spata săltată eu am luat-o de la copiii lui Israel de la sacrificiile ofrandelor de pace și le-am dat lui Aaron preotul și fiilor săi, printr-un statut continuu între copiii lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Aceasta este porția din ungerea lui Aaron și din ungerea fiilor săi, din acele ofrande ale DOMNULUI, făcute prin foc, în ziua în care el i-a prezentat pentru a servi DOMNULUI, în serviciul de preot; ");
INSERT INTO ronbtf_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Pe care DOMNUL a poruncit să le fie date de copiii lui Israel, în ziua în care i-a uns, printr-un statut veșnic, prin toate generațiile lor. ");
INSERT INTO ronbtf_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Aceasta este legea ofrandei arse, a darului de mâncare și a ofrandei pentru păcat și a ofrandei pentru fărădelege și a consacrărilor și a sacrificiului ofrandelor de pace; ");
INSERT INTO ronbtf_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Pe care DOMNUL a poruncit-o lui Moise în muntele Sinai, în ziua în care el a poruncit copiilor lui Israel să aducă darurile lor DOMNULUI, în pustiul Sinai. ");
INSERT INTO ronbtf_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Ia pe Aaron și pe fiii săi cu el și veșmintele și untdelemnul ungerii și un taur pentru ofranda pentru păcat și doi berbeci și un coș cu azime; ");
INSERT INTO ronbtf_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Și adună toată adunarea la ușa tabernacolului întâlnirii. ");
INSERT INTO ronbtf_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Și Moise a făcut precum DOMNUL i-a poruncit; și adunarea s-a strâns la ușa tabernacolului întâlnirii. ");
INSERT INTO ronbtf_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Și Moise a spus adunării: Acesta este lucrul pe care DOMNUL l-a poruncit să fie făcut. ");
INSERT INTO ronbtf_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Și Moise a adus pe Aaron și pe fiii săi și i-a spălat cu apă. ");
INSERT INTO ronbtf_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Și a pus tunica pe el și l-a încins cu brâul și l-a îmbrăcat cu mantia și a pus efodul pe el și l-a încins cu brâul efodului, lucrat iscusit, și l-a strâns cu acesta. ");
INSERT INTO ronbtf_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Și a pus pieptarul pe el, de asemenea a pus în pieptar pe Urim și Tumim. ");
INSERT INTO ronbtf_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Și a pus mitra pe capul lui; de asemenea peste mitră, chiar peste partea ei dinainte, a pus placa din aur, sfânta coroană; precum DOMNUL i-a poruncit lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Și Moise a luat untdelemnul ungerii și a uns tabernacolul și tot ce era în el și le-a sfințit. ");
INSERT INTO ronbtf_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Și a stropit cu acesta de șapte ori peste altar și a uns altarul și toate vasele lui, deopotrivă ligheanul și piedestalul lui, pentru a le sfinți. ");
INSERT INTO ronbtf_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Și a turnat pe capul lui Aaron din untdelemnul ungerii și l-a uns, pentru a-l sfinți. ");
INSERT INTO ronbtf_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Și Moise a adus pe fiii lui Aaron și a pus tunici pe ei și i-a încins cu brâie și a pus bonete pe ei, precum DOMNUL a poruncit lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Și a adus taurul pentru ofranda pentru păcat; și Aaron și fiii săi și-au pus mâinile pe capul taurului pentru ofranda pentru păcat. ");
INSERT INTO ronbtf_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Și l-a înjunghiat; și Moise a luat sângele și l-a pus pe coarnele altarului, de jur împrejur, cu degetul său, și a purificat altarul și a turnat sângele la baza altarului și l-a sfințit, pentru a face împăcare pe el. ");
INSERT INTO ronbtf_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Și a luat toată grăsimea care era pe măruntaie și lobul de pe ficat și cei doi rinichi și grăsimea lor și Moise le-a ars pe altar. ");
INSERT INTO ronbtf_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Dar taurul și pielea lui, carnea lui și balega lui, le-a ars cu foc în afara taberei; precum DOMNUL a poruncit lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Și a adus berbecul pentru ofranda arsă, și Aaron și fiii săi, și-au pus mâinile pe capul berbecului. ");
INSERT INTO ronbtf_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Iar el l-a înjunghiat; și Moise a stropit sângele peste altar, de jur împrejur. ");
INSERT INTO ronbtf_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Și a tăiat berbecul în bucăți; și Moise a ars capul și bucățile și grăsimea. ");
INSERT INTO ronbtf_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Și a spălat măruntaiele și picioarele în apă; și Moise a ars întregul berbec pe altar, acesta a fost un sacrificiu ars ca aromă dulce și ofrandă făcută prin foc DOMNULUI; precum DOMNUL a poruncit lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Și a adus celălalt berbec, berbecul consacrării, și Aaron și fiii săi și-au pus mâinile pe capul berbecului. ");
INSERT INTO ronbtf_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Iar el l-a înjunghiat; și Moise a luat din sângele acestuia și a pus pe vârful urechii drepte a lui Aaron și pe degetul mare de la mâna lui dreaptă și pe degetul mare de la piciorul lui drept. ");
INSERT INTO ronbtf_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Și a adus pe fiii lui Aaron și Moise a pus din sânge pe vârful urechii lor drepte și pe degetul mare al mâinii lor drepte și pe degetul mare al piciorului lor drept; și Moise a stropit sângele peste altar, de jur împrejur. ");
INSERT INTO ronbtf_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Și a luat grăsimea și noada și toată grăsimea care era pe măruntaie și lobul de pe ficat și cei doi rinichi și grăsimea lor și spata dreaptă; ");
INSERT INTO ronbtf_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Și din coșul cu azime, care era înaintea DOMNULUI, a luat o turtă nedospită și o turtă unsă cu untdelemn și un biscuit, și le-a pus pe grăsime și pe spata dreaptă; ");
INSERT INTO ronbtf_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Și el a pus toate pe mâinile lui Aaron și pe mâinile fiilor săi și le-a legănat ca ofrandă legănată înaintea DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Și Moise le-a luat de pe mâinile lor și le-a ars pe altar peste ofranda arsă, ele au fost consacrări ca aromă dulce, aceasta este ofrandă făcută prin foc DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Și Moise a luat pieptul și l-a legănat ca ofrandă legănată înaintea DOMNULUI, căci din berbecul consacrării pieptul era partea lui Moise, precum DOMNUL a poruncit lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Și Moise a luat din untdelemnul ungerii și din sângele care era pe altar, și l-a stropit pe Aaron și pe veșmintele lui și pe fiii săi și pe veșmintele fiilor săi, împreună cu el; și a sfințit pe Aaron și veșmintele lui, și pe fiii săi și veșmintele lor, împreună cu el. ");
INSERT INTO ronbtf_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Și Moise le-a spus lui Aaron și fiilor săi: Fierbeți carnea la ușa tabernacolului întâlnirii; și acolo mâncați-o cu pâinea ce este în coșul consacrării, precum am poruncit eu, spunând: Aaron și fiii să o mănânce. ");
INSERT INTO ronbtf_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Și ceea ce rămâne din carne și din pâine să o ardeți cu foc. ");
INSERT INTO ronbtf_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Și să nu ieșiți pe ușa tabernacolului întâlnirii în cele șapte zile, până ce zilele consacrării voastre ajung la sfârșit, pentru că în șapte zile el vă va consacra. ");
INSERT INTO ronbtf_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Precum a făcut el astăzi, astfel a poruncit DOMNUL să facem, pentru a face ispășire pentru voi. ");
INSERT INTO ronbtf_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","De aceea să locuiți la ușa tabernacolului întâlnirii zi și noapte, șapte zile, și să păziți însărcinarea DOMNULUI, ca să nu muriți, pentru că așa îmi este poruncit. ");
INSERT INTO ronbtf_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Astfel Aaron și fiii săi au împlinit toate lucrurile pe care DOMNUL le-a poruncit prin mâna lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Și s-a întâmplat în a opta zi, că Moise a chemat pe Aaron și pe fiii săi și pe bătrânii Israelului; ");
INSERT INTO ronbtf_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Și i-a spus lui Aaron: Ia-ți un vițel tânăr ca ofrandă pentru păcat și un berbec pentru ofrandă arsă, fără cusur și adu-i înaintea DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Și copiilor lui Israel să le vorbești, spunând: Luați un ied dintre capre ca ofrandă pentru păcat; și un vițel și un miel, amândoi de un an, fără cusur, pentru ofrandă arsă; ");
INSERT INTO ronbtf_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","De asemenea un taur și un berbec pentru ofrande de pace pentru a sacrifica înaintea DOMNULUI; și un dar de mâncare amestecat cu untdelemn, pentru că astăzi DOMNUL vi se va arăta. ");
INSERT INTO ronbtf_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Și ei au adus ceea ce Moise a poruncit, înaintea tabernacolului întâlnirii; și toată adunarea s-a apropiat și a stat în picioare înaintea DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Și Moise a spus: Acesta este lucrul pe care DOMNUL l-a poruncit ca voi să îl faceți; și gloria DOMNULUI vi se va arăta. ");
INSERT INTO ronbtf_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Și Moise i-a spus lui Aaron: Du-te la altar și adu ofranda ta pentru păcat și ofranda ta arsă, și fă ispășire pentru tine însuți și pentru popor, și adu ofranda poporului și fă ispășire pentru ei, precum DOMNUL a poruncit. ");
INSERT INTO ronbtf_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","De aceea Aaron a mers la altar și a înjunghiat vițelul ofrandei pentru păcat, care era pentru el. ");
INSERT INTO ronbtf_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Și fiii lui Aaron au adus sângele la el, iar el a înmuiat degetul său în sânge și l-a pus pe coarnele altarului și a turnat sângele la baza altarului; ");
INSERT INTO ronbtf_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Dar grăsimea și rinichii și lobul de pe ficatul ofrandei pentru păcat, le-a ars pe altar; precum DOMNUL a poruncit lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Și carnea și pielea le-a ars cu foc în afara taberei. ");
INSERT INTO ronbtf_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Și a înjunghiat ofranda arsă, și fiii lui Aaron i-au prezentat sângele, pe care el l-a stropit de jur împrejur peste altar. ");
INSERT INTO ronbtf_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Și i-au prezentat ofranda arsă, cu bucățile ei și capul; și le-a ars pe altar. ");
INSERT INTO ronbtf_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Și a spălat măruntaiele și picioarele și le-a ars peste ofranda arsă pe altar. ");
INSERT INTO ronbtf_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Și a adus darul poporului și a luat țapul, care era ofranda pentru păcat pentru popor și l-a înjunghiat și l-a oferit pentru păcat, precum pe cel dintâi. ");
INSERT INTO ronbtf_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Și a adus ofranda arsă și a oferit-o conform rânduielii. ");
INSERT INTO ronbtf_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Și a adus darul de mâncare și a luat o mână plină din el și l-a ars pe altar, lângă sacrificiul ars de dimineață. ");
INSERT INTO ronbtf_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","A înjunghiat de asemenea taurul și berbecul ca sacrificiu al ofrandelor de pace, care era pentru popor; și fiii lui Aaron i-au prezentat sângele, pe care el l-a stropit peste altar de jur împrejur, ");
INSERT INTO ronbtf_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Și grăsimea taurului și a berbecului, noada și ce acoperă măruntaiele și rinichii și lobul de pe ficat; ");
INSERT INTO ronbtf_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Și ei au pus grăsimea peste piepturile sacrificiului, iar el a ars grăsimea pe altar. ");
INSERT INTO ronbtf_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Și piepturile și spata dreaptă Aaron le-a legănat ca ofrandă legănată înaintea DOMNULUI; precum a poruncit Moise. ");
INSERT INTO ronbtf_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Și Aaron și-a ridicat mâna spre popor și l-a binecuvântat și a coborât de la aducerea ofrandei pentru păcat și de la ofranda arsă și de la ofrandele de pace. ");
INSERT INTO ronbtf_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Și Moise și Aaron au intrat în tabernacolul întâlnirii, și au ieșit și au binecuvântat poporul; și gloria DOMNULUI s-a arătat întregului popor. ");
INSERT INTO ronbtf_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Și a ieșit un foc de dinaintea DOMNULUI și a mistuit de pe altar, ofranda arsă și grăsimea, tot poporul când a văzut aceasta a strigat și a căzut cu fețele la pământ. ");
INSERT INTO ronbtf_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Și Nadab și Abihu, fiii lui Aaron, au luat fiecare tămâietoarea lui și au pus foc în ele și au pus tămâie deasupra și au oferit foc străin înaintea DOMNULUI, ceea ce el nu le poruncise. ");
INSERT INTO ronbtf_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Și a ieșit foc de la DOMNUL și i-a mistuit, iar ei au murit înaintea DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Atunci Moise i-a spus lui Aaron: Aceasta este ceea ce DOMNUL a vorbit, spunând: Eu voi fi sfințit în cei ce se apropie de mine și înaintea întregului popor eu voi fi glorificat. Și Aaron a tăcut. ");
INSERT INTO ronbtf_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Și Moise a chemat pe Mișael și Elițafan, fiii lui Uziel, unchiul lui Aaron, și le-a spus: Apropiați-vă, duceți pe frații voștri de dinaintea sanctuarului, afară din tabără. ");
INSERT INTO ronbtf_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Astfel s-au apropiat și i-au dus în tunicile lor, afară din tabără; precum spusese Moise. ");
INSERT INTO ronbtf_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Și Moise i-a zis lui Aaron și lui Eleazar și lui Itamar, fiii săi: Nu vă descoperiți capetele, nici nu vă sfâșiați hainele, ca nu cumva să muriți și ca nu cumva să vină furie peste tot poporul; ci lăsați pe frații voștri, întreaga casă a lui Israel, să plângă arderea pe care DOMNUL a aprins-o. ");
INSERT INTO ronbtf_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Și să nu ieșiți de la ușa tabernacolului întâlnirii ca nu cumva să muriți, pentru că untdelemnul ungerii DOMNULUI este peste voi. Și ei au făcut conform cuvântului lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Și DOMNUL i-a vorbit lui Aaron, zicând: ");
INSERT INTO ronbtf_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","Să nu bei nici vin nici băutură tare, nici tu, nici fiii tăi cu tine, când intrați în tabernacolul întâlnirii, ca să nu muriți, acesta să fie un statut pentru totdeauna, prin toate generațiile voastre; ");
INSERT INTO ronbtf_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Și ca să puteți deosebi între ce este sfânt și ce nu este sfânt și între ce este curat și ce nu este curat. ");
INSERT INTO ronbtf_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Și să îi învățați pe copiii lui Israel toate statutele pe care DOMNUL le-a spus prin mâna lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Și Moise i-a vorbit lui Aaron și lui Eleazar și lui Itamar, fiii săi care rămăseseră: Luați darul de mâncare care rămâne din ofrandele DOMNULUI făcute prin foc și mâncați-l fără dospeală lângă altar, pentru că acesta este preasfânt. ");
INSERT INTO ronbtf_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Și mâncați-l în locul sfânt, deoarece este dreptul tău și dreptul fiilor tăi, din sacrificiile făcute prin foc DOMNULUI, pentru că așa mi s-a poruncit. ");
INSERT INTO ronbtf_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Și pieptul legănat și spata săltată să le mâncați într-un loc curat; tu și fiii tăi și fiicele tale cu tine, pentru că acestea sunt dreptul tău și dreptul fiilor tăi, care sunt date din sacrificiile ofrandelor de pace ale copiilor lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Spata săltată și pieptul legănat să le aducă împreună cu ofrandele făcute prin foc din grăsime, ca să le legene ca ofrandă legănată înaintea DOMNULUI; și aceasta să fie a ta și a fiilor tăi cu tine, printr-un statut veșnic; precum DOMNUL a poruncit. ");
INSERT INTO ronbtf_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Și Moise a căutat cu atenție țapul ofrandei pentru păcat și, iată, acesta era ars, și s-a mâniat pe Eleazar și Itamar, fiii lui Aaron, care rămăseseră în viață, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","Pentru ce nu ați mâncat ofranda pentru păcat în locul sfânt, văzând că aceasta este preasfântă și că Dumnezeu v-a dat-o ca să purtați nelegiuirea adunării, pentru a face ispășire pentru ei înaintea DOMNULUI? ");
INSERT INTO ronbtf_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Iată, sângele lui nu a fost adus înăuntrul locului sfânt; voi într-adevăr trebuia să o fi mâncat în locul sfânt, precum am poruncit. ");
INSERT INTO ronbtf_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Și Aaron i-a vorbit lui Moise: Iată, astăzi ei și-au oferit ofranda pentru păcat și ofranda lor arsă înaintea DOMNULUI; și astfel de lucruri mi s-au întâmplat; și dacă aș fi mâncat ofranda de păcat astăzi, ar fi fost acceptată aceasta înaintea ochilor DOMNULUI? ");
INSERT INTO ronbtf_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Și când Moise a auzit aceasta, a fost mulțumit. ");
INSERT INTO ronbtf_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Și DOMNUL le-a vorbit lui Moise și lui Aaron, spunându-le: ");
INSERT INTO ronbtf_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Vorbește copiilor lui Israel, spunând: Acestea sunt animalele pe care să le mâncați dintre toate animalele de pe pământ. ");
INSERT INTO ronbtf_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Orice desparte copita și este cu copită bifurcată și rumegă hrana, printre animale, pe acelea să le mâncați. ");
INSERT INTO ronbtf_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Totuși pe acestea să nu le mâncați dintre cele ce rumegă, sau dintre cele cu unghie despicată; cămila, pentru că rumegă hrana, dar nu desparte unghia; vă este necurată. ");
INSERT INTO ronbtf_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Și iepurele de stâncă, deoarece rumegă hrana, dar nu desparte unghia; vă este necurat. ");
INSERT INTO ronbtf_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Și iepurele de câmp, pentru că el rumegă hrana, dar nu desparte unghia; vă este necurat. ");
INSERT INTO ronbtf_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Și porcul, deși are unghia despicată și este cu copită bifurcată, totuși el nu rumegă hrana; vă este necurat. ");
INSERT INTO ronbtf_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Din carnea lor să nu mâncați și trupul lor mort să nu îl atingeți; vă sunt necurate. ");
INSERT INTO ronbtf_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Pe acestea să le mâncați din tot ce este în ape; orice are aripioare și solzi în ape, în mări și în râuri, pe acelea să le mâncați. ");
INSERT INTO ronbtf_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Și tot ce nu are aripioare și solzi în mări și în râuri, din tot ce mișcă în ape și din orice viețuitoare ce este în ape, acelea să vă fie o urâciune; ");
INSERT INTO ronbtf_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Da, să vă fie o urâciune; să nu mâncați din carnea lor și trupurile lor moarte să vă fie o urâciune. ");
INSERT INTO ronbtf_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Orice nu are aripioare nici solzi în ape, să vă fie o urâciune. ");
INSERT INTO ronbtf_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Și acestea sunt cele care să vă fie o urâciune printre păsări; să nu fie mâncate, sunt o urâciune; acvila și vulturul bărbos și vulturul pescar, ");
INSERT INTO ronbtf_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","Și vulturul și uliul după felul său; ");
INSERT INTO ronbtf_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","Fiecare corb după felul său; ");
INSERT INTO ronbtf_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","Și bufnița și șoimul de noapte și cucul și șoimul după felul său, ");
INSERT INTO ronbtf_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","Și cucuveaua și cormoranul și bufnița mare, ");
INSERT INTO ronbtf_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","Și lebăda și pelicanul și vulturul egiptean, ");
INSERT INTO ronbtf_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","Și barza, stârcul după felul său și nagâțul și liliacul. ");
INSERT INTO ronbtf_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Toate zburătoarele care se târăsc, umblând pe toate patru picioarele, să vă fie o urâciune. ");
INSERT INTO ronbtf_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Totuși pe acestea să le mâncați din fiecare lucru zburător care se târăște mergând pe toate patru picioarele, care au fluierele picioarelor deasupra labelor lor, ca să sară cu totul de pe pământ. ");
INSERT INTO ronbtf_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Chiar pe acestea dintre ele să le mâncați: lăcusta după felul ei și lăcusta pleșuvă după felul ei și scarabeul după felul său și cosașul după felul său. ");
INSERT INTO ronbtf_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Dar orice alt lucru zburător care se târăște, care are patru picioare, să vă fie o urâciune. ");
INSERT INTO ronbtf_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Și din cauza acestora voi veți fi necurați, oricine atinge trupul lor mort să fie necurat până seara. ");
INSERT INTO ronbtf_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Și oricine trebuie să poarte orice din trupul lor mort să își spele hainele și să fie necurat până seara. ");
INSERT INTO ronbtf_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Trupurile moarte ale fiecărui animal care desparte unghia și nu este cu copită bifurcată, nici nu rumegă mâncarea, vă sunt necurate, fiecare om ce le atinge să fie necurat. ");
INSERT INTO ronbtf_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Și orice merge pe labele sale, printre toate felurile de viețuitoare care merg pe toate patru picioarele, acelea vă sunt necurate, oricine atinge trupul lor mort să fie necurat până seara. ");
INSERT INTO ronbtf_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Și cel ce poartă trupul lor mort să își spele hainele și să fie necurat până seara, vă sunt necurate. ");
INSERT INTO ronbtf_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Acestea de asemenea vă vor fi necurate printre târâtoarele ce se târăsc pe pământ; nevăstuica și șoarecele și țestoasa după felul ei, ");
INSERT INTO ronbtf_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","Și dihorul și cameleonul și șopârla și melcul și cârtița. ");
INSERT INTO ronbtf_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Acestea vă sunt necurate printre toate cele ce se târăsc, oricine le atinge, după ce vor fi murit, să fie necurat până seara. ");
INSERT INTO ronbtf_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Și orice lucru ce cade pe ele, după ce vor fi murit, să fie necurat; fie acesta orice vas de lemn, sau haină, sau piele, sau sac, orice vas în care se face ceva, să fie pus în apă și să fie necurat până seara; astfel să fie el curățat. ");
INSERT INTO ronbtf_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Și fiecare vas de pământ, în care cade ceva din ele, orice este în ele să fie necurat; și să îl spargeți. ");
INSERT INTO ronbtf_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Din toată mâncarea care este de mâncat, peste care vine o asemenea apă să fie necurată; și toată băutura care este de băut în orice astfel de vas să fie necurată. ");
INSERT INTO ronbtf_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Și orice lucru peste care cade orice parte din trupul lor mort să fie necurat; fie cuptor sau vatră pentru oale, să fie dărâmate, pentru că sunt necurate și să vă fie necurate. ");
INSERT INTO ronbtf_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Totuși o fântână sau groapă, în care este abundență de apă, să fie curată, dar ce atinge trupul lor mort să fie necurat. ");
INSERT INTO ronbtf_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Și dacă ceva din trupul lor mort cade pe orice sămânță de semănat care este pentru a fi semănată, aceasta să fie curată. ");
INSERT INTO ronbtf_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Dar dacă ceva apă este pusă peste sămânță și vreo parte din trupul lor mort cade acolo, să vă fie necurată. ");
INSERT INTO ronbtf_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Și dacă vreun animal, din care voi puteți mânca, moare, cel ce atinge trupul lui mort să fie necurat până seara. ");
INSERT INTO ronbtf_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Și cel ce mănâncă din trupul mort al acestuia să își spele hainele și să fie necurat până seara; de asemenea cel ce cară trupul mort al lui să-și spele hainele și să fie necurat până seara. ");
INSERT INTO ronbtf_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Și fiecare târâtoare ce se târăște pe pământ să fie o urâciune; să nu fie mâncată. ");
INSERT INTO ronbtf_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Orice merge pe pântece și orice merge pe toate patru picioarele, sau orice are mai multe picioare printre toate târâtoarele ce se târăsc pe pământ, pe acelea să nu le mâncați, pentru că sunt urâciune. ");
INSERT INTO ronbtf_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Să nu vă faceți sufletele urâcioase cu vreo târâtoare ce se târăște pe pământ, nici să nu vă faceți necurați cu ele, ca să nu fiți pângăriți prin ele. ");
INSERT INTO ronbtf_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Pentru că eu sunt DOMNUL Dumnezeul vostru, de aceea sfințiți-vă și veți fi sfinți; căci eu sunt sfânt, să nu vă pângăriți cu niciun fel de târâtoare ce se târăște pe pământ. ");
INSERT INTO ronbtf_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Pentru că eu sunt DOMNUL care vă aduce din țara Egiptului, pentru a fi Dumnezeul vostru; de aceea fiți sfinți, căci eu sunt sfânt. ");
INSERT INTO ronbtf_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Aceasta este legea despre animale și despre păsări și despre fiecare viețuitoare care se mișcă în ape și despre fiecare târâtoare care se târăște pe pământ, ");
INSERT INTO ronbtf_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Pentru a face o diferență între necurat și curat și între animalul care poate fi mâncat și animalul care nu poate fi mâncat. ");
INSERT INTO ronbtf_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Vorbește copiilor lui Israel, zicând: Dacă o femeie rămâne însărcinată și naște un copil de parte bărbătească, să fie necurată șapte zile; conform cu zilele separării, pentru infirmitatea ei, să fie necurată. ");
INSERT INTO ronbtf_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Și în ziua a opta prepuțul lui să fie circumcis. ");
INSERT INTO ronbtf_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Și să continue în sângele curățirii ei treizeci și trei de zile; să nu atingă niciun lucru sfânt, nici să nu intre în sanctuar, până când zilele purificării ei vor fi împlinite. ");
INSERT INTO ronbtf_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Dar dacă ea naște un copil de parte femeiască, atunci să fie necurată două săptămâni, ca în separarea ei, și să continue în sângele curățirii ei șaizeci și șase de zile. ");
INSERT INTO ronbtf_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Și când zilele curățirii ei sunt împlinite, pentru un fiu, sau pentru o fiică, să aducă un miel de un an, ca ofrandă arsă și un porumbel tânăr sau o turturea, ca ofrandă pentru păcat, la ușa tabernacolului întâlnirii, la preot; ");
INSERT INTO ronbtf_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Acesta să le aducă înaintea DOMNULUI și să facă ispășire pentru ea; iar ea să fie curățată de scurgerea sângerării ei. Aceasta este legea pentru cea care a născut parte bărbătească sau parte femeiască. ");
INSERT INTO ronbtf_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Și dacă nu este în stare să aducă un miel, atunci să aducă două turturele, sau doi porumbei tineri; unul pentru ofranda arsă și celălalt ca ofrandă pentru păcat; și preotul să facă ispășire pentru ea, iar ea să fie curată. ");
INSERT INTO ronbtf_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Și DOMNUL le-a vorbit lui Moise și Aaron, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Când un bărbat va avea pe pielea cărnii sale o umflătură, o crustă sau o pată albă și aceasta este în pielea cărnii lui asemănătoare rănii de lepră, atunci el să fie adus la preotul Aaron, sau la unul dintre fiii săi, preoții; ");
INSERT INTO ronbtf_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Și preotul să se uite la rana din pielea cărnii; și când părul în rană este schimbat în alb și rana la vedere este mai adâncită decât pielea cărnii lui, aceasta este o rană de lepră; și preotul să îl privească și să îl declare necurat. ");
INSERT INTO ronbtf_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Dacă pata strălucitoare este albă în pielea cărnii lui și la vedere nu este mai adâncă decât pielea și părul ei nu este schimbat în alb, atunci preotul să îl închidă pe cel cu rana, șapte zile; ");
INSERT INTO ronbtf_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Și preotul să se uite la el în ziua a șaptea; și, iată, dacă rana înaintea ochilor săi este neschimbată și rana nu se întinde pe piele, atunci preotul să îl mai închidă șapte zile; ");
INSERT INTO ronbtf_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Și preotul să se uite la el din nou în a șaptea zi; și, iată, dacă rana s-a întunecat puțin și rana nu s-a întins pe piele, preotul să îl declare curat, este doar o crustă; iar el să își spele hainele și să fie curat. ");
INSERT INTO ronbtf_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Dar dacă crusta se întinde mult în piele, după ce a fost văzut de preot, pentru curățirea lui, să fie văzut de preot din nou; ");
INSERT INTO ronbtf_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Și dacă preotul vede că, iată, crusta se întinde în piele, atunci preotul să îl declare necurat, aceasta este lepră. ");
INSERT INTO ronbtf_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Când rana de lepră este într-un bărbat, el să fie adus la preot; ");
INSERT INTO ronbtf_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Și preotul să se uite la el; și, iată, dacă umflătura este albă în piele și a schimbat părul în alb și este carne proaspăt vie în umflătură, ");
INSERT INTO ronbtf_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","Aceasta este o lepră veche în pielea cărnii lui, și preotul să îl declare necurat și să nu îl închidă, pentru că este necurat. ");
INSERT INTO ronbtf_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Și dacă lepra se întinde mult pe piele și lepra acoperă toată pielea celui ce are rana, de la cap până în talpa piciorului său, oriunde privește preotul; ");
INSERT INTO ronbtf_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","Atunci preotul să cerceteze; și, iată, dacă lepra i-a acoperit toată carnea, să îl declare curat pe cel ce are rana; totul s-a schimbat în alb, el este curat. ");
INSERT INTO ronbtf_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Dar când apare pe el carne vie să fie necurat. ");
INSERT INTO ronbtf_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Și preotul să se uite la carnea vie și să îl declare a fi necurat, căci carnea vie este necurată; aceasta este lepră. ");
INSERT INTO ronbtf_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Sau dacă se schimbă din nou carnea vie și este schimbată în alb, să vină la preot. ");
INSERT INTO ronbtf_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Și preotul să se uite la el; și, iată, dacă rana este schimbată în alb, atunci preotul să declare curat pe cel ce are rana, el este curat; ");
INSERT INTO ronbtf_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Și carnea, în care era o ulcerație în pielea ei, dacă s-a vindecat, ");
INSERT INTO ronbtf_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","Și dacă în locul ulcerației este o umflătură albă, sau o pată strălucitoare sau albă și cumva roșiatică, și aceasta să fie arătată preotului; ");
INSERT INTO ronbtf_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Și dacă, după ce preotul o vede, iată, este la vedere mai adâncă decât pielea, și părul ei este schimbat în alb, atunci preotul să îl declare necurat, aceasta este o rană de lepră izbucnită din ulcerație. ");
INSERT INTO ronbtf_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Dar dacă preotul se uită la ea și, iată, nu sunt peri albi în ea și dacă nu este mai adâncă decât pielea, dar este cumva întunecată, atunci preotul să îl închidă șapte zile; ");
INSERT INTO ronbtf_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Și dacă aceasta se întinde mult pe piele, atunci preotul să îl declare necurat, aceasta este o rană. ");
INSERT INTO ronbtf_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Dar dacă pata strălucitoare rămâne la locul ei și nu se întinde, aceasta este o ulcerație inflamată; și preotul să îl declare curat. ");
INSERT INTO ronbtf_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Dar dacă este vreo carne, în pielea căreia este o inflamație arzătoare și carnea vie arzătoare are o pată strălucitoare albă, cumva roșiatică sau albă, ");
INSERT INTO ronbtf_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","Atunci preotul să se uite la ea; și, iată, dacă părul în pata strălucitoare este schimbat în alb și la vedere este mai adâncită decât pielea, aceasta este lepră izbucnită din inflamație, pentru aceasta preotul să îl declare necurat, aceasta este rana leprei. ");
INSERT INTO ronbtf_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Dar dacă preotul se uită la ea și, iată, nu este niciun păr alb în pata strălucitoare și aceasta nu este mai adâncită decât pielea din jur, dar este cumva mai întunecată, atunci preotul să îl închidă șapte zile; ");
INSERT INTO ronbtf_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Și preotul să se uite la el în ziua a șaptea; și dacă aceasta s-a întins mult pe piele, atunci preotul să îl declare necurat, aceasta este rana leprei. ");
INSERT INTO ronbtf_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Și dacă pata strălucitoare rămâne la locul ei și nu se întinde pe piele, dar este cumva mai întunecată, aceasta este o umflătură de inflamație; și preotul să îl declare curat, pentru că este o inflamație aprinsă. ");
INSERT INTO ronbtf_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Dacă un bărbat sau o femeie are o rană pe cap sau pe barbă; ");
INSERT INTO ronbtf_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","Atunci preotul să se uite la rană; și, iată, dacă este la vedere mai adâncită decât pielea și este în ea păr galben subțire, atunci preotul să îl declare necurat, este o eczemă, chiar lepră pe cap sau pe barbă. ");
INSERT INTO ronbtf_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Și dacă preotul se uită la rana eczemei de la suprafața pielii și, iată, la vedere nu este mai adâncă decât pielea și nu este păr negru în ea, atunci preotul să îl închidă pe cel ce are rana eczemei la suprafața pielii, șapte zile; ");
INSERT INTO ronbtf_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Și în ziua a șaptea preotul să se uite la rană; și, iată, dacă eczema de la suprafața pielii nu se întinde și în ea nu este păr galben și eczema nu este la vedere mai adâncă decât pielea; ");
INSERT INTO ronbtf_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","El să fie ras, dar să nu radă eczema; și preotul să îl mai închidă, pe cel ce are eczema, șapte zile; ");
INSERT INTO ronbtf_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Și în ziua a șaptea preotul să se uite la eczemă; și, iată, dacă, eczema nu s-a întins pe piele, nici nu este la vedere mai adâncă decât pielea, atunci preotul să îl declare curat, și să își spele hainele și să fie curat. ");
INSERT INTO ronbtf_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Dar dacă eczema se întinde mult pe piele după curățirea sa; ");
INSERT INTO ronbtf_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","Atunci preotul să se uite la el; și, iată, dacă eczema s-a întins pe piele, preotul să nu caute păr galben; el este necurat. ");
INSERT INTO ronbtf_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Dar dacă eczema este înaintea ochilor săi neschimbată și acolo este păr negru crescut în ea, eczema este vindecată, el este curat, și preotul să îl declare curat. ");
INSERT INTO ronbtf_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Dacă de asemenea un bărbat sau o femeie au pe pielea cărnii lor pete strălucitoare, adică pete albe strălucitoare; ");
INSERT INTO ronbtf_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","Atunci preotul să se uite la ele; și, iată, dacă petele strălucitoare în pielea cărnii lor sunt de un alb mai întunecat, acestea sunt pete pistruiate care cresc în piele; el este curat. ");
INSERT INTO ronbtf_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Și bărbatul al cărui păr a căzut de pe capul lui, este chel; el este curat. ");
INSERT INTO ronbtf_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Și bărbatul al cărui păr a căzut de pe partea capului dinspre fața sa, este cu frunte cheală, el este curat. ");
INSERT INTO ronbtf_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Și dacă este pe capul chel, sau pe fruntea cheală, o rană roșiatică, aceasta este o lepră ce a izbucnit pe capul lui chel, sau pe fruntea lui cheală. ");
INSERT INTO ronbtf_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Atunci preotul să se uite la ea; și, iată, dacă umflătura rănii este alb roșiatică pe capul lui chel, sau pe fruntea lui cheală, precum lepra apare pe pielea cărnii, ");
INSERT INTO ronbtf_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","Este un bărbat lepros, este necurat, preotul să îl declare cu desăvârșire necurat, rana lui este pe capul lui. ");
INSERT INTO ronbtf_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Și cât despre lepră, cel în care este rana ei, hainele lui să fie rupte și capul descoperit și să pună un acoperământ peste buza de sus și să strige: Necurat, necurat. ");
INSERT INTO ronbtf_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","În toate zilele, cât timp este rana în cel lepros, să fie pângărit; el este necurat; să locuiască singur; în afara taberei să fie locuința lui. ");
INSERT INTO ronbtf_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","De asemenea haina în care se află rana leprei, fie ea haină de lână, sau haină de in, ");
INSERT INTO ronbtf_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","Fie în urzeală sau băteală, a inului sau a lânii; fie ea în piele sau în orice lucru făcut din piele; ");
INSERT INTO ronbtf_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","Și dacă rana este verzuie sau roșiatică în haină, sau în pielea hainei, fie în urzeală, sau în băteală, sau în orice lucru din piele, aceasta este o rana de lepră și să fie arătată preotului. ");
INSERT INTO ronbtf_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Și preotul să se uite la rană și să închidă lucrul care are rana șapte zile; ");
INSERT INTO ronbtf_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Și să se uite la rană în ziua a șaptea, dacă rana s-a întins în haină, fie în urzeală, fie în băteală sau în pielea hainei, sau în orice lucru care este făcut din piele, atunci rana este lepră care roade; acel lucru este necurat. ");
INSERT INTO ronbtf_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","De aceea să ardă haina aceea, fie urzeală, fie băteală, în lână sau in, sau orice lucru din piele în care este rana, pentru că este lepră care roade; să fie ars în foc. ");
INSERT INTO ronbtf_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Și dacă preotul se uită și, iată, rana nu s-a întins în haină, fie în urzeală, fie în băteală sau în orice lucru din piele, ");
INSERT INTO ronbtf_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","Atunci preotul să poruncească să se spele lucrul în care este rana și să mai fie închis încă șapte zile; ");
INSERT INTO ronbtf_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Și preotul să se uite la rană, după ce este spălată; și, iată, dacă rana nu și-a schimbat culoarea și rana nu s-a întins, este necurată; să o arzi în foc; este roasă dinăuntru, fie pe față, fie pe dos. ");
INSERT INTO ronbtf_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Și dacă preotul se uită la ea și, iată, rana este cumva mai întunecată după spălare, atunci să o rupă din haină sau din piele sau din urzeală sau din băteală; ");
INSERT INTO ronbtf_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Și dacă aceasta încă apare în haină, fie în urzeală, fie în băteală sau în orice lucru de piele, aceasta este o rană care se întinde, lucrul care are rana să îl arzi cu foc. ");
INSERT INTO ronbtf_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Și haina, fie urzeală, fie băteală, fie orice lucru din piele, pe care îl vei spăla, dacă rana s-a depărtat de la acele lucruri, atunci să le speli a doua oară și vor fi curate. ");
INSERT INTO ronbtf_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Aceasta este legea rănii de lepră într-o haină de lână sau de in, fie în urzeala, fie în băteala ei, sau în orice lucru de piele, pentru a-l declara curat, sau a-l declara necurat. ");
INSERT INTO ronbtf_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Aceasta să fie legea leprosului în ziua curățirii lui, să fie adus la preot; ");
INSERT INTO ronbtf_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Și preotul să iasă afară din tabără; și preotul să se uite la rană și, iată, dacă rana de lepră este vindecată pe lepros; ");
INSERT INTO ronbtf_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","Atunci preotul va porunci să se ia, pentru cel pregătit pentru a fi curățit, două păsări vii și curate și lemn de cedru și stacojiu și isop; ");
INSERT INTO ronbtf_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Și preotul să poruncească să fie înjunghiată, una dintre păsări într-un vas de lut peste apa curgătoare; ");
INSERT INTO ronbtf_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Cât despre pasărea vie, să o ia împreună cu lemnul de cedru și stacojiul și isopul și să le înmoaie împreună cu pasărea vie în sângele păsării ucise peste apa curgătoare; ");
INSERT INTO ronbtf_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Și să stropească, pe cel ce este pregătit pentru a fi curățit de lepră, de șapte ori și să îl declare curat și să lase pasărea vie liberă în câmp deschis. ");
INSERT INTO ronbtf_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Și cel ce este pregătit pentru a fi curățit să își spele hainele și să își radă tot părul și să se spele în apă, ca să fie curat; și după aceea să intre în tabără și să rămână afară din cortul lui șapte zile. ");
INSERT INTO ronbtf_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Dar așa să fie în ziua a șaptea, el să își radă tot părul de pe cap și barba și sprâncenele, chiar tot părul să și-l radă; și să își spele hainele, de asemenea să își spele carnea în apă și va fi curat. ");
INSERT INTO ronbtf_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Și în ziua a opta să ia doi miei fără cusur și o mioară de un an, fără cusur, și trei zecimi dintr-o măsură de floarea făinii pentru un dar de mâncare, amestecată cu untdelemn și un log de untdelemn. ");
INSERT INTO ronbtf_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Și preotul care îl curăță să prezinte bărbatul ce este pentru curățire și acele lucruri, înaintea DOMNULUI, la ușa tabernacolului întâlnirii; ");
INSERT INTO ronbtf_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Și preotul să ia un miel și să îl ofere ca ofrandă pentru fărădelege și logul de untdelemn și să le legene ca ofrandă legănată înaintea DOMNULUI; ");
INSERT INTO ronbtf_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Și să înjunghie mielul în locul în care va înjunghia ofranda pentru păcat și ofranda arsă, în locul sfânt, căci precum ofranda pentru păcat este a preotului, astfel este și ofranda pentru fărădelege, aceasta este preasfântă; ");
INSERT INTO ronbtf_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Și preotul să ia câtva sânge din ofranda pentru fărădelege și preotul să îl pună pe vârful urechii drepte a celui pregătit pentru a fi curățit și pe degetul mare de la mâna lui dreaptă și pe degetul mare de la piciorul lui drept; ");
INSERT INTO ronbtf_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Și preotul să ia câtva din logul de untdelemn și să îl toarne în palma mâinii sale stângi; ");
INSERT INTO ronbtf_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Și preotul să își înmoaie degetul drept în untdelemnul care este în palma mâinii stângi și să stropească din untdelemn cu degetul său de șapte ori înaintea DOMNULUI; ");
INSERT INTO ronbtf_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Și din restul untdelemnului care este în mâna sa, preotul să pună pe vârful urechii drepte a celui pregătit pentru a fi curățit și pe degetul mare de la mâna lui dreaptă și peste degetul mare de la piciorul lui drept, peste sângele ofrandei pentru fărădelege; ");
INSERT INTO ronbtf_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Și rămășița din untdelemnul care este în mâna preotului să o toarne pe capul celui pregătit pentru a fi curățit, și preotul să facă ispășire pentru el înaintea DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Și preotul să aducă ofranda pentru păcat și să facă ispășire pentru cel pregătit pentru a fi curățit de necurăția sa; și după aceea să înjunghie ofranda arsă; ");
INSERT INTO ronbtf_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Și preotul să aducă ofranda arsă și darul de mâncare pe altar, și preotul să facă ispășire pentru el și el să fie curat. ");
INSERT INTO ronbtf_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Iar dacă este sărac și nu poate aduce atât de mult, atunci să ia un miel ca ofrandă pentru fărădelege ca să fie legănată, pentru a se face ispășire pentru el, și o zecime dintr-o măsură de floarea făinii amestecată cu untdelemn, ca dar de mâncare, și un log de untdelemn; ");
INSERT INTO ronbtf_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Și două turturele sau doi pui de porumbel, precum este în stare să aducă; și una să fie ofrandă pentru păcat iar cealaltă ofrandă arsă. ");
INSERT INTO ronbtf_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Și să le aducă în ziua a opta pentru curățirea sa, la preot, la ușa tabernacolului întâlnirii, înaintea DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Și preotul să ia mielul ofrandei pentru fărădelege și logul de untdelemn și preotul să le legene ca ofrandă legănată înaintea DOMNULUI; ");
INSERT INTO ronbtf_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Și să înjunghie mielul ofrandei pentru fărădelege, și preotul să ia câtva din sângele ofrandei pentru fărădelege și să îl pună pe vârful urechii drepte a celui pregătit pentru a fi curățit, și pe degetul mare de la mâna lui dreaptă și pe degetul mare de la piciorul lui drept; ");
INSERT INTO ronbtf_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Și preotul să toarne din untdelemn în palma mâinii sale stângi; ");
INSERT INTO ronbtf_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Și preotul să stropească cu degetul său drept câtva din untdelemnul care este în mâna lui stângă, de șapte ori înaintea DOMNULUI; ");
INSERT INTO ronbtf_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Și preotul să pună din untdelemnul care este în mâna sa pe vârful urechii drepte a celui pregătit pentru a fi curățit și pe degetul mare de la mâna sa dreaptă și pe degetul mare de la piciorul lui drept, peste locul sângelui ofrandei pentru fărădelege; ");
INSERT INTO ronbtf_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Și restul untdelemnului care este în mâna preotului să îl pună peste capul celui pregătit pentru a fi curățit, pentru a se face ispășire pentru el înaintea DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Și să aducă pe una dintre turturele, sau unul dintre porumbeii tineri, precum este în stare să aducă; ");
INSERT INTO ronbtf_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Precum este el în stare să le aducă, pe una ca ofrandă pentru păcat și pe cealaltă ca ofrandă arsă, cu darul de mâncare, și preotul să facă ispășire pentru cel pregătit, pentru a fi curățit înaintea DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Aceasta este legea celui în care este rana de lepră, a cărui mână nu este în stare să aducă cele ținând de curățirea lui. ");
INSERT INTO ronbtf_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Și DOMNUL le-a vorbit lui Moise și lui Aaron, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","După ce veți fi intrat în țara Canaanului, pe care eu v-o dau ca stăpânire, și pun rana de lepră într-o casă din țara stăpânirii voastre; ");
INSERT INTO ronbtf_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","Și proprietarul casei să vină și să spună preotului, spunând: Mi se pare că este ceva ca o rană în casă, ");
INSERT INTO ronbtf_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Atunci preotul să poruncească să fie golită casa înainte ca preotul să meargă să se uite la rană, ca să nu se facă necurate toate câte sunt în casă, și după aceea preotul să intre să se uite la casă; ");
INSERT INTO ronbtf_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Și să se uite la rană și, iată, dacă rana este în pereții casei, cu adâncituri mici, verzui sau roșiatice, care la vedere sunt mai adânci decât peretele, ");
INSERT INTO ronbtf_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","Atunci preotul să iasă din casă la ușa casei și să închidă casa șapte zile; ");
INSERT INTO ronbtf_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Și preotul să vină din nou în ziua a șaptea și să se uite; și, iată, dacă rana se întinde în pereții casei, ");
INSERT INTO ronbtf_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","Atunci să poruncească preotul ca ei să scoată pietrele în care este rana și să le arunce într-un loc necurat în afara orașului; ");
INSERT INTO ronbtf_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Și să facă să fie răzuită casa pe dinăuntru de jur împrejur, iar ei să toarne țărâna pe care au răzuit-o în afara orașului, într-un loc necurat; ");
INSERT INTO ronbtf_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Și să ia alte pietre și să le pună în locul acelor pietre; iar el să ia alt mortar și să tencuiască astfel casa. ");
INSERT INTO ronbtf_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Și dacă rana se întoarce înapoi și izbucnește în casă, după ce a scos pietrele și după ce a răzuit casa și după ce aceasta este tencuită, ");
INSERT INTO ronbtf_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","Atunci preotul să vină și să se uite și iată, dacă rana s-a întins în casă, este lepră care roade în casă, aceasta este necurată. ");
INSERT INTO ronbtf_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Și el să dărâme casa, pietrele ei și lemnăria acesteia și tot mortarul casei; și să le care afară din oraș, într-un loc necurat. ");
INSERT INTO ronbtf_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Mai mult, cel ce intră în casă în timpul cât aceasta este închisă, să fie necurat până seara. ");
INSERT INTO ronbtf_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Și cel ce se culcă în casă să își spele hainele; și cel ce mănâncă în casă să își spele hainele. ");
INSERT INTO ronbtf_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Și dacă preotul intră și se uită și, iată, rana nu s-a întins în casă, după ce casa a fost tencuită, atunci preotul să declare casa curată, deoarece rana este vindecată. ");
INSERT INTO ronbtf_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Și să ia, pentru a curăța casa, două păsări împreună cu lemn de cedru și stacojiu și isop; ");
INSERT INTO ronbtf_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Și să ucidă pe una dintre păsări într-un vas de lut peste apa curgătoare; ");
INSERT INTO ronbtf_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Și să ia lemnul de cedru și isopul și stacojiul și pasărea vie și să le înmoaie în sângele păsării ucise și în apa curgătoare și să stropească de șapte ori casa; ");
INSERT INTO ronbtf_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Și casa să o curețe cu sângele păsării și cu apa curgătoare și cu pasărea vie și cu lemnul de cedru și cu isopul și cu stacojiul; ");
INSERT INTO ronbtf_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Dar să lase pasărea să plece în afara cetății, în câmp deschis și să facă ispășire pentru casă, și aceasta să fie curată. ");
INSERT INTO ronbtf_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Aceasta este legea pentru toate felurile de rană de lepră și a eczemei, ");
INSERT INTO ronbtf_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","Și pentru lepra hainei și a casei, ");
INSERT INTO ronbtf_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","Și pentru o umflătură și pentru o crustă și pentru o pată strălucitoare, ");
INSERT INTO ronbtf_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Pentru a învăța pe alții când este necurat și când este curat, aceasta este legea leprei. ");
INSERT INTO ronbtf_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Și DOMNUL le-a vorbit lui Moise și lui Aaron, zicând: ");
INSERT INTO ronbtf_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Vorbește copiilor lui Israel și spune-le: Când vreun bărbat are o scurgere din carnea lui, din cauza scurgerii lui, este necurat. ");
INSERT INTO ronbtf_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Și aceasta să fie necurățenia lui, în scurgerea lui, fie carnea lui curge cu scurgerea lui, fie carnea lui este închisă de la scurgerea lui, aceasta este necurăția lui. ");
INSERT INTO ronbtf_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Fiecare pat, pe care se culcă cel ce are scurgerea, este necurat, și fiecare lucru, pe care șade el, să fie necurat. ");
INSERT INTO ronbtf_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Și oricine atinge patul lui să își spele hainele și să se îmbăieze în apă și să fie necurat până seara. ");
INSERT INTO ronbtf_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Și cel ce șade pe orice lucru pe care a șezut cel ce are scurgerea să își spele hainele și să se îmbăieze în apă și să fie necurat până seara. ");
INSERT INTO ronbtf_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Și cel ce atinge carnea celui ce are scurgerea să își spele hainele și să se îmbăieze în apă și să fie necurat până seara. ");
INSERT INTO ronbtf_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Și dacă cel ce are scurgerea scuipă peste cel ce este curat, atunci acela să își spele hainele și să se îmbăieze în apă și să fie necurat până seara. ");
INSERT INTO ronbtf_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Și orice șea, pe care călărește cel ce are scurgerea, să fie necurată. ");
INSERT INTO ronbtf_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Și oricine atinge orice lucru care a fost sub el, să fie necurat până seara, și cel ce va căra oricare din acele lucruri să își spele hainele și să se îmbăieze și să fie necurat până seara. ");
INSERT INTO ronbtf_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Și pe oricine atinge cel ce are scurgerea și nu și-a clătit mâinile sale în apă, să își spele hainele și să se îmbăieze și să fie necurat până seara. ");
INSERT INTO ronbtf_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Și vasele de lut, pe care le-a atins cel ce are scurgerea, să fie sparte; și fiecare vas de lemn să fie clătit în apă. ");
INSERT INTO ronbtf_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Și când cel ce are o scurgere este curățat de scurgerea sa, atunci el să își numere șapte zile pentru curățirea sa și să își spele hainele și să își îmbăieze carnea în apă curgătoare și să fie curat. ");
INSERT INTO ronbtf_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Și în ziua a opta să ia pentru el două turturele, sau doi porumbei tineri și să vină înaintea DOMNULUI la ușa tabernacolului întâlnirii și să le dea preotului; ");
INSERT INTO ronbtf_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Și preotul să le aducă, una ca ofrandă pentru păcat și cealaltă ca ofrandă arsă; și preotul să facă ispășire pentru el înaintea DOMNULUI, pentru scurgerea lui. ");
INSERT INTO ronbtf_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Și dacă sămânța de împreunare a vreunui bărbat iese din el, atunci să își spele toată carnea în apă și să fie necurat până seara. ");
INSERT INTO ronbtf_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Și fiecare haină și fiecare piele, pe care este sămânța de împreunare, să fie spălată cu apă și să fie necurată până seara. ");
INSERT INTO ronbtf_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","De asemenea femeia cu care bărbatul se va culca cu sămânța împreunării, amândoi să se îmbăieze în apă și să fie necurați până seara. ");
INSERT INTO ronbtf_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Și dacă vreo femeie are o scurgere și scurgerea în carnea ei este sânge, să fie separată șapte zile, și oricine o atinge să fie necurat până seara. ");
INSERT INTO ronbtf_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Și fiecare lucru pe care ea se culcă în separarea ei să fie necurat; orice lucru pe care ea șade, de asemenea să fie necurat. ");
INSERT INTO ronbtf_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Și oricine îi atinge patul să își spele hainele și să se îmbăieze în apă și să fie necurat până seara. ");
INSERT INTO ronbtf_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Și oricine atinge orice lucru pe care ea a șezut să își spele hainele și să se îmbăieze în apă și să fie necurat până seara. ");
INSERT INTO ronbtf_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Și dacă este ceva pe patul ei, sau vreun lucru pe care ea șade, când el îl atinge, să fie necurat până seara. ");
INSERT INTO ronbtf_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Și dacă un bărbat se culcă cu ea și necurăția ei este peste el, să fie necurat șapte zile; și tot patul pe care el se culcă să fie necurat. ");
INSERT INTO ronbtf_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Și dacă o femeie are o scurgere din sângele ei multe zile, mai mult timp decât zilele separării ei; toate zilele scurgerii necurăției ei să fie la fel ca zilele separării ei, ea să fie necurată. ");
INSERT INTO ronbtf_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Orice pat pe care se culcă în toate zilele scurgerii ei, să îi fie ca patul zilelor separării ei, și pe orice lucru se așază să fie necurat, ca necurăția separării ei. ");
INSERT INTO ronbtf_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Și oricine atinge acele lucruri să fie necurat și să își spele hainele și să se îmbăieze în apă și să fie necurat până seara. ");
INSERT INTO ronbtf_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Dar dacă ea este curățată de scurgerea ei, atunci să își numere șapte zile și după aceea să fie curată. ");
INSERT INTO ronbtf_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Și în ziua a opta să ia pentru ea două turturele, sau doi porumbei tineri și să îi aducă la preot, la ușa tabernacolului întâlnirii. ");
INSERT INTO ronbtf_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Și preotul să o aducă pe una ca ofrandă pentru păcat și pe cealaltă ca ofrandă arsă; și preotul să facă ispășire pentru ea înaintea DOMNULUI, pentru scurgerea necurăției ei. ");
INSERT INTO ronbtf_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Astfel să separați pe copiii lui Israel de necurățiile lor; ca să nu moară în necurățiile lor, când ei spurcă tabernacolul meu care este între ei. ");
INSERT INTO ronbtf_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Aceasta este legea celui ce are o scurgere și a aceluia căruia îi iese sămânța din el și este întinat de acestea; ");
INSERT INTO ronbtf_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","Și a celei bolnave cu necurăția ei și a celui ce are o scurgere, a bărbatului sau a femeii și a celui ce se culcă cu cea care este necurată. ");
INSERT INTO ronbtf_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Și DOMNUL i-a vorbit lui Moise după moartea celor doi fii ai lui Aaron, când au oferit înaintea DOMNULUI și au murit. ");
INSERT INTO ronbtf_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Și DOMNUL i-a zis lui Moise: Spune-i lui Aaron, fratele tău, să nu vină tot timpul în locul sfânt dinăuntrul perdelei, care este înaintea șezământului milei de deasupra chivotului, ca să nu moară, pentru că eu voi apărea în norul de peste șezământul milei. ");
INSERT INTO ronbtf_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Astfel să vină Aaron în locul sfânt, cu un taur tânăr ca ofrandă pentru păcat, și cu un berbec ca ofrandă arsă. ");
INSERT INTO ronbtf_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Să îmbrace tunica sfântă de in și să aibă izmenele de in peste carnea sa și să fie încins cu un brâu de in și cu mitra de in să fie împodobit, acestea sunt sfintele veștminte; de aceea să își spele carnea în apă și astfel să le îmbrace. ");
INSERT INTO ronbtf_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Și să ia din adunarea copiilor lui Israel doi iezi dintre capre, ca ofrandă pentru păcat, și un berbec ca ofrandă arsă. ");
INSERT INTO ronbtf_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Și Aaron să aducă taurul său al ofrandei pentru păcat, care este pentru el, și să facă ispășire pentru el și pentru casa lui. ");
INSERT INTO ronbtf_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Și să ia cei doi țapi și să îi prezinte înaintea DOMNULUI la ușa tabernacolului întâlnirii. ");
INSERT INTO ronbtf_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Și Aaron să arunce sorții peste cei doi țapi, un sorț pentru DOMNUL și celălalt sorț pentru țapul ispășitor. ");
INSERT INTO ronbtf_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Și Aaron să aducă țapul peste care a căzut sorțul DOMNULUI și să îl ofere ca ofrandă pentru păcat. ");
INSERT INTO ronbtf_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Dar țapul peste care a căzut sorțul să fie țap ispășitor, să fie prezentat viu înaintea DOMNULUI, să facă ispășire cu el și pentru a-l lăsa să plece în pustie, ca țap ispășitor. ");
INSERT INTO ronbtf_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Și Aaron să aducă taurul ofrandei pentru păcat, care este pentru el, și să facă ispășire pentru el și pentru casa lui, și să înjunghie taurul ofrandei pentru păcat, care este pentru el; ");
INSERT INTO ronbtf_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Și să ia o tămâietoare plină cu cărbuni, arzând din focul de la altarul dinaintea DOMNULUI, și mâinile sale pline de tămâie dulce, zdrobită mărunt, și să le aducă înăuntrul perdelei; ");
INSERT INTO ronbtf_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Și să pună tămâia peste focul dinaintea DOMNULUI, ca norul tămâiei să acopere șezământul milei, care este deasupra mărturiei, ca el să nu moară; ");
INSERT INTO ronbtf_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Și să ia din sângele taurului și să îl stropească cu degetul său peste șezământul milei înspre est; și să stropească cu degetul său de șapte ori, din sânge, înaintea șezământului milei. ");
INSERT INTO ronbtf_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Apoi să înjunghie țapul ofrandei pentru păcat, care este pentru popor, și să aducă sângele lui înăuntrul perdelei și să facă cu acel sânge la fel cum a făcut cu sângele taurului, și să îl stropească peste șezământul milei și înaintea șezământului milei; ");
INSERT INTO ronbtf_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Și să facă ispășire pentru locul sfânt, din cauza necurățiilor copiilor lui Israel și din cauza fărădelegilor lor în toate păcatele lor, și astfel să facă pentru tabernacolul întâlnirii, care rămâne printre ei în mijlocul necurățiilor lor. ");
INSERT INTO ronbtf_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Și să nu fie niciun om în tabernacolul întâlnirii când intră el, pentru a face ispășire în locul sfânt, până când iese și până când nu a făcut ispășire pentru el și pentru casa sa și pentru toată adunarea lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Și să iasă la altarul, care este înaintea DOMNULUI, și să facă ispășire pentru el; și să ia din sângele taurului și din sângele țapului și să îl pună pe coarnele altarului de jur împrejur. ");
INSERT INTO ronbtf_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Și să stropească din sânge peste acesta cu degetul său, de șapte ori, și să îl curețe și să îl sfințească de necurățiile copiilor lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Și după ce a terminat cu împăcarea locului sfânt și a tabernacolului întâlnirii și a altarului, să aducă țapul viu; ");
INSERT INTO ronbtf_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Și Aaron să își pună amândouă mâinile pe capul țapului viu și să mărturisească peste el toate nelegiuirile copiilor lui Israel, și toate fărădelegile lor în toate păcatele lor, punându-le pe capul țapului și să îl trimită să plece departe în pustie, prin mâna unui bărbat pregătit; ");
INSERT INTO ronbtf_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Și țapul să poarte pe el toate nelegiuirile lor într-un pământ nelocuit, și să lase țapul să plece în pustie. ");
INSERT INTO ronbtf_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Și Aaron să intre în tabernacolul întâlnirii și să dezbrace veșmintele de in, pe care le-a îmbrăcat, când a intrat în locul sfânt, și să le lase acolo; ");
INSERT INTO ronbtf_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Și să își spele carnea cu apă în locul sfânt și să își îmbrace veșmintele și să iasă înainte și să aducă ofranda sa arsă și ofranda arsă a poporului, și să facă ispășire pentru el și pentru popor. ");
INSERT INTO ronbtf_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Și grăsimea ofrandei pentru păcat o să ardă pe altar. ");
INSERT INTO ronbtf_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Și cel ce a lăsat țapul să plece, țapul ispășitor, să își spele hainele și să își îmbăieze carnea în apă, și după aceea să intre în tabără. ");
INSERT INTO ronbtf_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Și taurul ca ofrandă pentru păcat și țapul ca ofrandă pentru păcat, al căror sânge a fost adus înăuntru pentru a se face ispășire în locul sfânt, de unul să fie duși afară din tabără, iar ei să ardă în foc pielea lor și carnea lor și balega lor. ");
INSERT INTO ronbtf_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Și cel ce le arde să își spele hainele și să își îmbăieze carnea în apă, și după aceea să intre în tabără. ");
INSERT INTO ronbtf_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Și acesta să vă fie un statut pentru totdeauna, în luna a șaptea, în ziua a zecea a lunii, să vă chinuiți sufletele și să nu faceți deloc nicio lucrare, nici cel din țara voastră, nici străinul care locuiește temporar printre voi; ");
INSERT INTO ronbtf_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Pentru că în ziua aceea preotul va face ispășire pentru voi, pentru a vă curăța ca să fiți curați de toate păcatele voastre înaintea DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Aceasta să vă fie un sabat al odihnei și să vă chinuiți sufletele, printr-un statut pentru totdeauna. ");
INSERT INTO ronbtf_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Și preotul, pe care el îl va unge și pe care îl va consacra pentru a servi în serviciul de preot în locul tatălui său, să facă ispășirea și să îmbrace veșmintele de in, veștmintele sfinte; ");
INSERT INTO ronbtf_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Și să facă ispășire pentru sanctuarul sfânt și să facă ispășire pentru tabernacolul întâlnirii și pentru altar, și să facă ispășire pentru preoți și pentru tot poporul adunării. ");
INSERT INTO ronbtf_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Și acesta să vă fie un statut veșnic, pentru a face ispășire pentru copiii lui Israel pentru toate păcatele lor, o singură dată pe an. Iar el a făcut precum DOMNUL i-a poruncit lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Și DOMNUL i-a vorbit lui Moise, zicând: ");
INSERT INTO ronbtf_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Vorbește lui Aaron și fiilor săi și tuturor copiilor lui Israel și spune-le: Acesta este lucrul pe care DOMNUL l-a poruncit spunând: ");
INSERT INTO ronbtf_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Orice bărbat din casa lui Israel, care înjunghie un bou sau miel sau capră, în tabără, sau îl înjunghie în afara taberei, ");
INSERT INTO ronbtf_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","Și nu îl aduce la ușa tabernacolului întâlnirii, pentru a aduce un dar DOMNULUI înaintea tabernacolului DOMNULUI, sânge să i se impute acelui bărbat; el a vărsat sânge; și acel bărbat să fie stârpit din mijlocul poporului său; ");
INSERT INTO ronbtf_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Pentru ca acești copii ai lui Israel să își aducă sacrificiile, pe care le aduce în câmp deschis, da, ca ei să le aducă DOMNULUI, la ușa tabernacolului întâlnirii, la preot și să le ofere ca ofrande de pace DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Și preotul să stropească sângele peste altarul DOMNULUI la ușa tabernacolului întâlnirii și să ardă grăsimea pentru o aromă dulce DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Iar ei să nu mai aducă sacrificiile lor dracilor, după care au curvit. Acesta să le fie un statut pentru totdeauna prin toate generațiile lor. ");
INSERT INTO ronbtf_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Și să le spui: Orice bărbat din casa lui Israel, sau dintre străinii care locuiesc temporar printre voi, care aduce ofrandă arsă sau un sacrificiu, ");
INSERT INTO ronbtf_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","Și nu îl aduce la ușa tabernacolului întâlnirii, pentru a-l oferi DOMNULUI, chiar acel bărbat să fie stârpit din mijlocul poporului său. ");
INSERT INTO ronbtf_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Și orice bărbat din casa lui Israel, sau dintre străinii care locuiesc temporar printre voi, care mănâncă orice fel de sânge; chiar eu îmi voi întoarce fața împotriva acelui suflet care mănâncă sânge și îl voi stârpi din mijlocul poporului său. ");
INSERT INTO ronbtf_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Pentru că viața cărnii este în sânge; și vi l-am dat pe altar pentru a se face ispășire pentru sufletele voastre, pentru că sângele este cel ce face ispășire pentru suflet. ");
INSERT INTO ronbtf_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","De aceea am spus copiilor lui Israel: Niciun suflet dintre voi să nu mănânce sânge, nici vreun străin care locuiește temporar printre voi să nu mănânce sânge. ");
INSERT INTO ronbtf_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Și orice bărbat dintre copiii lui Israel, sau dintre străinii care locuiesc temporar printre voi, care vânează și prinde orice fiară sau pasăre care poate fi mâncată, chiar el să îi scurgă sângele și să îl acopere cu țărână. ");
INSERT INTO ronbtf_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Pentru că el este viața întregii cărni; sângele acesteia este pentru viața ei; de aceea am spus copiilor lui Israel: Să nu mâncați sânge de la niciun fel de carne, pentru că viața întregii cărni este sângele ei, oricine îl mănâncă să fie stârpit! ");
INSERT INTO ronbtf_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Și fiecare suflet care mănâncă ceea ce a murit de la sine, sau care a fost sfâșiat de fiare, fie unul din țara voastră, sau un străin, deopotrivă să își spele hainele și să se îmbăieze în apă și să fie necurat până seara, apoi să fie curat. ");
INSERT INTO ronbtf_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Dar dacă nu le spală, nici nu își îmbăiază carnea, atunci să își poarte propria nelegiuire. ");
INSERT INTO ronbtf_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Și DOMNUL i-a vorbit lui Moise, zicând: ");
INSERT INTO ronbtf_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Vorbește copiilor lui Israel și spune-le: Eu sunt DOMNUL Dumnezeul vostru. ");
INSERT INTO ronbtf_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Să nu faceți după lucrările din țara Egiptului, în care ați locuit; și după lucrările din țara Canaanului, în care eu v-am adus, să nu faceți, nici să nu umblați în rânduielile lor. ");
INSERT INTO ronbtf_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Să împliniți judecățile mele și să țineți rânduielile mele, ca să umblați în ele: Eu sunt DOMNUL Dumnezeul vostru. ");
INSERT INTO ronbtf_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","De aceea să țineți statutele mele și judecățile mele, pe care un om, dacă le împlinește, va trăi în ele: Eu sunt DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Niciunul dintre voi să nu vă apropiați de niciuna dintre rudele sale, ca să le descoperiți goliciunea: Eu sunt DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Goliciunea tatălui tău sau goliciunea mamei tale, să nu o descoperi, ea este mama ta; să nu îi descoperi goliciunea. ");
INSERT INTO ronbtf_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Goliciunea soției tatălui tău să nu o descoperi, este goliciunea tatălui tău. ");
INSERT INTO ronbtf_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Goliciunea surorii tale, fiica tatălui tău, sau fiica mamei tale, fie născută acasă, sau născută departe, goliciunea lor să nu o descoperi. ");
INSERT INTO ronbtf_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Goliciunea fiicei fiului tău, sau a fiicei fiicei tale, goliciunea lor să nu o descoperi, căci goliciunea lor este propria ta goliciune. ");
INSERT INTO ronbtf_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Goliciunea fiicei soției tatălui tău, născută din tatăl tău, ea este sora ta, să nu îi descoperi goliciunea. ");
INSERT INTO ronbtf_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Să nu descoperi goliciunea surorii tatălui tău, ea este ruda apropiată, a tatălui tău. ");
INSERT INTO ronbtf_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Să nu descoperi goliciunea surorii mamei tale, căci ea este ruda apropiată, a mamei tale. ");
INSERT INTO ronbtf_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Să nu descoperi goliciunea fratelui tatălui tău, să nu te apropii de soția lui, ea este mătușa ta. ");
INSERT INTO ronbtf_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Să nu descoperi goliciunea nurorii tale, ea este soția fiului tău; să nu descoperi goliciunea ei. ");
INSERT INTO ronbtf_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Să nu descoperi goliciunea soției fratelui tău, este goliciunea fratelui tău. ");
INSERT INTO ronbtf_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Să nu descoperi goliciunea unei femei și a fiicei ei; nici să nu iei pe fiica fiului ei, sau pe fiica fiicei ei, ca să îi descoperi goliciunea, pentru că ele sunt rudele ei apropiate, aceasta este stricăciune. ");
INSERT INTO ronbtf_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Nici să nu iei de soție o soră a ei, ca să o chinuiești, pentru a-i descoperi goliciunea, pe lângă a celeilalte, în timpul vieții ei. ");
INSERT INTO ronbtf_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","De asemenea să nu te apropii de o femeie să îi descoperi goliciunea, cât timp ea este pusă deoparte pentru necurăția ei. ");
INSERT INTO ronbtf_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Mai mult să nu te culci carnal cu soția aproapelui tău, ca să te pângărești cu ea. ");
INSERT INTO ronbtf_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Și, să nu lași pe niciunul din sămânța ta să treacă prin foc, pentru Moloh, nici să nu pângărești numele Dumnezeului Tău: Eu sunt DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Să nu te culci cu un bărbat, precum te culci cu o femeie, este urâciune. ");
INSERT INTO ronbtf_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Nici să nu te culci carnal cu vreun animal ca să te pângărești cu el, nici vreo femeie să nu stea înaintea unui animal ca să se culce cu el, este încurcătură. ");
INSERT INTO ronbtf_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Să nu vă pângăriți în vreunul dintre aceste lucruri, pentru că în toate acestea sunt pângărite națiunile, pe care le arunc din fața voastră. ");
INSERT INTO ronbtf_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Și țara este pângărită, de aceea pedepsesc nelegiuirea ei peste ea și țara însăși vomită pe locuitorii ei. ");
INSERT INTO ronbtf_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","De aceea să țineți statutele mele și judecățile mele și să nu faceți niciuna dintre aceste urâciuni, nimeni din națiunea voastră, niciunul dintre străinii care locuiesc temporar printre voi; ");
INSERT INTO ronbtf_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","(Pentru că toate aceste urâciuni le-au făcut oamenii din țară, care au fost înaintea voastră și țara este pângărită;) ");
INSERT INTO ronbtf_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Ca țara să nu vă vomite și pe voi afară, când o pângăriți, precum a vomitat afară națiunile care au fost înaintea voastră. ");
INSERT INTO ronbtf_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Pentru că oricine va face oricare dintre aceste urâciuni, chiar sufletele care le fac vor fi stârpite din mijlocul poporului lor. ");
INSERT INTO ronbtf_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","De aceea să țineți rânduielile, ca să nu faceți niciunul dintre aceste obiceiuri scârboase, care au fost făcute înainte de voi și ca să nu vă pângăriți voi înșivă în ele: Eu sunt DOMNUL Dumnezeul vostru. ");
INSERT INTO ronbtf_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Și DOMNUL i-a vorbit lui Moise, zicând: ");
INSERT INTO ronbtf_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Vorbește întregii adunări a copiilor lui Israel și spune-le: Să fiți sfinți, pentru că eu DOMNUL Dumnezeul vostru sunt sfânt. ");
INSERT INTO ronbtf_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Fiecare om să se teamă de mama sa și de tatăl său și să țineți sabatele mele: Eu sunt DOMNUL Dumnezeul vostru. ");
INSERT INTO ronbtf_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Nu vă întoarceți la idoli, nici să nu vă faceți dumnezei turnați: Eu sunt DOMNUL Dumnezeul vostru. ");
INSERT INTO ronbtf_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Și dacă aduceți un sacrificiu al ofrandelor de pace DOMNULUI, să îl aduceți din propria voastră voie bună. ");
INSERT INTO ronbtf_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Să fie mâncat în aceeași zi în care îl aduceți și a doua zi; și dacă ar rămâne până în a treia zi, să fie ars în foc. ");
INSERT INTO ronbtf_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Și dacă se mănâncă din el în a treia zi, este urâciune; să nu fie acceptat. ");
INSERT INTO ronbtf_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","De aceea oricine care îl mănâncă va purta nelegiuirea sa, deoarece a spurcat lucrul sfințit al DOMNULUI; și acel suflet să fie stârpit din mijlocul poporului său. ");
INSERT INTO ronbtf_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Și când secerați secerișul pământului vostru, să nu seceri în întregime colțurile câmpului tău, nici să nu aduni spicele căzute după secerișul tău. ");
INSERT INTO ronbtf_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Și să nu îți cureți via de boabele căzute, nici să nu strângi fiecare ciorchine din via ta; să le lași pentru cel sărac și pentru cel străin: Eu sunt DOMNUL Dumnezeul vostru. ");
INSERT INTO ronbtf_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Să nu furați, nici să nu vă purtați cu falsitate, nici să nu vă mințiți unul pe celălalt. ");
INSERT INTO ronbtf_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Și să nu jurați fals pe numele meu; nici să nu pângărești numele Dumnezeului tău: Eu sunt DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Să nu escrochezi pe aproapele tău, nici să nu îl jefuiești; plățile celui angajat cu ziua să nu rămână la tine toată noaptea până dimineața. ");
INSERT INTO ronbtf_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Să nu blestemi pe cel surd, nici să nu pui o piatră de poticnire înaintea celui orb, ci să te temi de Dumnezeul tău: Eu sunt DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Să nu faceți nedreptate în judecată; să nu părtinești pe sărac, nici să nu onorezi persoana celui puternic, ci în dreptate să judeci pe aproapele tău. ");
INSERT INTO ronbtf_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Să nu mergi încolo și încoace ca un bârfitor în mijlocul poporului tău, nici să nu stai împotriva sângelui aproapelui tău: Eu sunt DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Să nu urăști pe fratele tău în inima ta; să mustri în vreun fel pe aproapele tău și să nu permiți păcat asupra lui. ");
INSERT INTO ronbtf_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Să nu te răzbuni, nici să nu porți vreo pică împotriva copiilor din poporul tău, ci să iubești pe aproapele tău ca pe tine însuți: Eu sunt DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Să țineți statutele mele. Să nu lași vitele tale să se împerecheze cu un soi amestecat; să nu semeni câmpul tău cu sămânță amestecată; nici să nu îmbraci vreodată o haină amestecată făcută din fire de in și lână. ");
INSERT INTO ronbtf_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Și oricine se culcă în mod carnal cu o femeie, ce este roabă, legată prin logodnă unui soț și nu este răscumpărată, nici având libertatea dată ei, ea să fie biciuită, ei să nu fie dați morții, deoarece nu era liberă. ");
INSERT INTO ronbtf_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Iar el să aducă DOMNULUI ofranda sa pentru fărădelege, la ușa tabernacolului întâlnirii, un berbec ca ofrandă pentru fărădelege. ");
INSERT INTO ronbtf_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Și preotul să facă ispășire pentru el cu berbecul ofrandei pentru fărădelege înaintea DOMNULUI, pentru păcatul lui pe care l-a făcut; și păcatul făcut să îi fie iertat. ");
INSERT INTO ronbtf_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Și când veți intra în țară și veți fi sădit tot felul de pomi pentru hrană, să socotiți rodul lor ca necircumcis; trei ani să vă fie ca necircumcis, din acesta să nu se mănânce. ");
INSERT INTO ronbtf_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Dar în al patrulea an tot rodul lor să fie sfânt pentru a lăuda pe DOMNUL cu el. ");
INSERT INTO ronbtf_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Și în al cincilea an să mâncați din rodul lor, ca să vi se adauge venitul lor: Eu sunt DOMNUL Dumnezeul vostru. ");
INSERT INTO ronbtf_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Să nu mâncați nimic cu sânge; nici să nu folosiți descântarea, nici să nu preziceți timpurile. ");
INSERT INTO ronbtf_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Să nu vă rotunjiți colțurile capetelor, nici să nu distrugi colțurile bărbii tale. ");
INSERT INTO ronbtf_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Să nu faceți niciun fel de tăieturi în carnea voastră pentru morți, nici nu întipăriți niciun fel de semne pe voi: Eu sunt DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Nu prostitua pe fiica ta, să o faci să fie o curvă; ca nu cumva țara să cadă în curvie și pământul să devină plin de stricăciune. ");
INSERT INTO ronbtf_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Să țineți sabatele mele și să respectați sanctuarul meu: Eu sunt DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Să nu mergeți la cei ce au demoni, nici la cei ce caută după vrăjitori, ca să vă pângăriți cu ei: Eu sunt DOMNUL Dumnezeul vostru. ");
INSERT INTO ronbtf_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Să te ridici în picioare în fața capului cărunt și să onorezi fața omului bătrân și să te temi de Dumnezeul tău: Eu sunt DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Și dacă un străin locuiește temporar cu tine în țara voastră, să nu îl chinuiți. ");
INSERT INTO ronbtf_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Ci străinul care locuiește cu voi să vă fie ca unul născut printre voi și să îl iubești ca pe tine însuți, pentru că și voi ați fost străini în țara Egiptului: Eu sunt DOMNUL Dumnezeul vostru. ");
INSERT INTO ronbtf_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Să nu faceți nicio nedreptate în judecată, în linia de măsură, în măsurarea greutății, sau în măsurarea lichidelor. ");
INSERT INTO ronbtf_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Să aveți balanțe drepte, greutăți drepte, o efă dreaptă și un hin drept: Eu sunt DOMNUL Dumnezeul vostru, care v-am scos din țara Egiptului. ");
INSERT INTO ronbtf_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","De aceea să țineți toate statutele mele și toate judecățile mele și să le împliniți: Eu sunt DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Și DOMNUL i-a vorbit lui Moise, zicând: ");
INSERT INTO ronbtf_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Mai spune o dată copiilor lui Israel: Oricine dintre copiii lui Israel, sau dintre străinii care locuiesc temporar în Israel, dă pe cineva din sămânța sa lui Moloh, acela negreșit să fie dat morții, poporul să îl ucidă cu pietre. ");
INSERT INTO ronbtf_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Și îmi voi întoarce fața împotriva acelui om și îl voi stârpi din mijlocul poporului său, pentru că el a dat din sămânța sa lui Moloh, ca să spurce sanctuarul meu și să pângărească numele meu sfânt. ");
INSERT INTO ronbtf_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Și dacă oamenii pământului fac cumva și își ascund ochii de la acel om, când el dă din sămânța sa lui Moloh și nu îl ucid; ");
INSERT INTO ronbtf_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","Atunci îmi voi întoarce fața împotriva acelui om și împotriva familiei sale și îl voi stârpi din mijlocul poporului lor, pe el și pe toți cei ce merg curvind după el, ca să curvească cu Moloh. ");
INSERT INTO ronbtf_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Și sufletul care se întoarce după cei ce au demoni și după vrăjitori, ca să curvească după ei, eu îmi voi întoarce fața împotriva acelui suflet și îl voi stârpi din mijlocul poporului său. ");
INSERT INTO ronbtf_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Sfințiți-vă de aceea și fiți sfinți, pentru că eu sunt DOMNUL Dumnezeul vostru. ");
INSERT INTO ronbtf_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Și să țineți statutele mele și să le împliniți: Eu sunt DOMNUL care vă sfințește. ");
INSERT INTO ronbtf_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Pentru că fiecare om ce blestemă pe tatăl său sau pe mama sa, negreșit să fie dat morții; cel ce a blestemat pe tatăl său sau pe mama sa, sângele său să fie asupra sa. ");
INSERT INTO ronbtf_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Și bărbatul care comite adulter cu soția unui alt bărbat, chiar cel ce comite adulter cu soția aproapelui său, bărbatul și femeia adulteră să fie negreșit uciși. ");
INSERT INTO ronbtf_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Și bărbatul care se culcă cu soția tatălui său, a descoperit goliciunea tatălui său, amândoi negreșit să fie uciși; sângele lor să fie asupra lor. ");
INSERT INTO ronbtf_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Și dacă un bărbat se culcă cu nora sa, amândoi să fie uciși negreșit, au lucrat încurcătură; sângele lor să fie asupra lor. ");
INSERT INTO ronbtf_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","De asemenea dacă un bărbat se culcă cu un bărbat, precum se culcă cu o femeie, amândoi au făcut o urâciune, negreșit să fie uciși; sângele lor să fie asupra lor. ");
INSERT INTO ronbtf_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Și dacă un bărbat ia o soție și pe mama ei, aceasta este stricăciune, să fie arși cu foc, deopotrivă el și ele; ca să nu fie stricăciune între voi. ");
INSERT INTO ronbtf_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Și dacă un bărbat se culcă cu o fiară, negreșit să fie ucis; și să ucideți fiara. ");
INSERT INTO ronbtf_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Și dacă o femeie se apropie de vreo fiară și se culcă cu ea, să ucizi și femeia și fiara, negreșit să fie ucise; sângele lor să fie asupra lor. ");
INSERT INTO ronbtf_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Și dacă un bărbat ia pe sora sa, pe fiica tatălui său, sau pe fiica mamei sale și vede goliciunea ei și ea vede goliciunea lui, acesta este un lucru stricat; și să fie stârpiți înaintea ochilor poporului lor; cel ce a descoperit goliciunea surorii sale va purta propria nelegiuire. ");
INSERT INTO ronbtf_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Și dacă un bărbat se culcă cu o femeie, având necurăția ei, și va descoperi goliciunea ei, el i-a dezgolit fântâna; iar ea și-a descoperit fântâna sângerării; și amândoi să fie stârpiți din mijlocul poporului lor. ");
INSERT INTO ronbtf_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Și să nu descoperi goliciunea surorii mamei tale, sau a surorii tatălui tău, pentru că el dezgolește pe ruda sa apropiată, ei să poarte nelegiuirea lor. ");
INSERT INTO ronbtf_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Și dacă un bărbat se va culca cu soția unchiului său, el a descoperit goliciunea unchiului său, să poarte păcatul lor, să moară fără copii. ");
INSERT INTO ronbtf_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Și dacă un bărbat ia pe soția fratelui său, acesta este un lucru necurat, cel ce a descoperit goliciunea fratelui său, să fie fără copii. ");
INSERT INTO ronbtf_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","De aceea să țineți toate statutele mele și toate judecățile mele și să le împliniți, ca țara, în care eu vă aduc să locuiți în ea, să nu vă vomite afară. ");
INSERT INTO ronbtf_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Și să nu umblați în obiceiurile națiunii, pe care o arunc afară dinaintea voastră, pentru că ei au făcut toate aceste lucruri și de aceea sunt dezgustat de ei. ");
INSERT INTO ronbtf_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Dar eu v-am spus: Veți moșteni țara lor și am să v-o dau vouă ca să o stăpâniți, o țară care curge cu lapte și miere: Eu sunt DOMNUL Dumnezeul vostru, care v-am separat de alte popoare. ");
INSERT INTO ronbtf_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","De aceea să deosebiți între vitele curate și necurate și între păsări necurate și curate; și să nu vă faceți sufletele scârboase prin vite, sau păsări, sau orice fel de târâtoare care se târăște pe pământ, pe care le-am separat de voi, ca fiind necurate. ");
INSERT INTO ronbtf_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Și să îmi fiți sfinți, pentru că eu DOMNUL sunt sfânt și v-am separat de alte popoare, ca să fiți ai mei. ");
INSERT INTO ronbtf_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","De asemenea un bărbat sau o femeie care are demon, sau care este vrăjitor, negreșit să fie dat morții, să îi ucidă cu pietre, sângele lor să fie asupra lor. ");
INSERT INTO ronbtf_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Și DOMNUL i-a vorbit lui Moise: Vorbește preoților, fiii lui Aaron și spune-le: Nimeni să nu se pângărească pentru un mort, în poporul său, ");
INSERT INTO ronbtf_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Dar pentru ruda sa, apropiată, adică pentru mama sa și pentru tatăl său și pentru fiul său și pentru fiica sa și pentru fratele său, ");
INSERT INTO ronbtf_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","Și pentru sora sa fecioară, care îi este apropiată, care nu a avut bărbat, pentru ea poate să se pângărească. ");
INSERT INTO ronbtf_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Dar un conducător în poporul său, un om de seamă, să nu se pângărească, să nu se pângărească pe sine însuși. ");
INSERT INTO ronbtf_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Să nu își radă o porțiune pe cap, nici să nu își radă colțurile bărbilor, nici să nu își facă tăieturi în carnea lor. ");
INSERT INTO ronbtf_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Să fie sfinți Dumnezeului lor și să nu pângărească numele Dumnezeului lor, pentru că ei aduc ofrandele DOMNULUI făcute prin foc, pâinea Dumnezeului lor, de aceea să fie sfinți. ");
INSERT INTO ronbtf_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Să nu își ia o curvă, sau profană, ca soție; nici să nu își ia o femeie divorțată de soțul ei, pentru că el este sfânt Dumnezeului său. ");
INSERT INTO ronbtf_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","De aceea să îl sfințești; căci el aduce pâinea Dumnezeului tău; el să îți fie sfânt, pentru că eu, DOMNUL, care vă sfințește, sunt sfânt. ");
INSERT INTO ronbtf_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Și fiica oricărui preot, dacă se va pângări, curvind, pângărește pe tatăl ei, să fie arsă cu foc. ");
INSERT INTO ronbtf_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Și marele preot printre frații săi, peste al cărui cap a fost turnat untdelemnul ungerii și care este consacrat să se îmbrace cu veșmintele, să nu își descopere capul, nici să nu își sfâșie hainele; ");
INSERT INTO ronbtf_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Nici să nu intre la trupul vreunui mort, nici să nu se pângărească pentru tatăl său, sau pentru mama sa. ");
INSERT INTO ronbtf_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Nici să nu iasă din sanctuar, nici să nu spurce sanctuarul Dumnezeului său; căci coroana ungerii untdelemnului lui Dumnezeu este asupra lui: Eu sunt DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Și el să își ia o soție în fecioria ei. ");
INSERT INTO ronbtf_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","O văduvă, sau o femeie divorțată sau profană sau o curvă, pe acestea să nu le ia, ci să ia de soție o fecioară din poporul său. ");
INSERT INTO ronbtf_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Nici să nu își pângărească sămânța în poporul său, pentru că eu DOMNUL îl sfințesc. ");
INSERT INTO ronbtf_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Și DOMNUL i-a vorbit lui Moise și i-a spus: ");
INSERT INTO ronbtf_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Spune-i lui Aaron, zicând: Orice bărbat din sămânța ta, în generațiile lor, având vreun cusur, să nu se apropie să aducă pâinea Dumnezeului său. ");
INSERT INTO ronbtf_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Căci niciun bărbat în care este vreun cusur să nu se apropie, un bărbat orb sau un șchiop sau cel cu un nas turtit sau având orice lucru în plus; ");
INSERT INTO ronbtf_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","Sau un bărbat cu piciorul rupt sau cu mâna ruptă, ");
INSERT INTO ronbtf_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","Sau cocoșat sau pitic sau cel ce are cusur la ochi sau are cruste scărpinate sau râios sau are testiculele sale frânte; ");
INSERT INTO ronbtf_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Din sămânța preotului Aaron, niciun bărbat, care are un cusur, să nu se apropie să aducă ofrandele DOMNULUI făcute prin foc, el are un cusur; să nu se apropie să aducă pâinea Dumnezeului său. ");
INSERT INTO ronbtf_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Să mănânce pâinea Dumnezeului său, deopotrivă din cea preasfântă și din cea sfântă. ");
INSERT INTO ronbtf_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Doar să nu intre la perdea, nici să nu se apropie de altar, din cauză că are un cusur; ca să nu spurce sanctuarele mele, pentru că eu DOMNUL îi sfințesc. ");
INSERT INTO ronbtf_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Și Moise i-a spus lui Aaron și fiilor săi și tuturor copiilor lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Și DOMNUL i-a vorbit lui Moise, zicând: ");
INSERT INTO ronbtf_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Spune-i lui Aaron și fiilor săi, să se separe de lucrurile sfinte ale copiilor lui Israel, să nu pângărească numele meu sfânt în acele lucruri pe care ei mi le sfințesc: Eu sunt DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Să le spui: Oricine din toată sămânța voastră printre generațiile voastre, merge la lucrurile sfinte, pe care copiii lui Israel le sfințesc DOMNULUI, avându-și necurăția asupra sa, acel suflet să fie stârpit din prezența mea: Eu sunt DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Din sămânța lui Aaron, orice bărbat care este lepros, sau are o scurgere, acela să nu mănânce din lucrurile sfinte, până este curat. Și oricine atinge orice lucru necurat prin moarte, sau pe un bărbat căruia îi iese sămânța de împreunare; ");
INSERT INTO ronbtf_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","Sau oricine atinge orice târâtoare, prin care el este făcut necurat, sau un om de la care poate lua necurăție, orice fel de necurăție ar avea; ");
INSERT INTO ronbtf_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Sufletul care a atins așa ceva să fie necurat până seara și să nu mănânce din lucrurile sfinte, decât dacă își spală carnea cu apă. ");
INSERT INTO ronbtf_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Și când soarele a apus, să fie curat și după aceea să mănânce din lucrurile sfinte; deoarece aceasta este mâncarea sa. ");
INSERT INTO ronbtf_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Ceea ce moare de la sine, sau este sfâșiat de fiare, să nu mănânce pentru a nu se pângări în aceasta: Eu sunt DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","De aceea ei să țină rânduiala mea, ca nu cumva să poarte păcat pentru aceasta și de aceea să moară, dacă o pângărește: Eu DOMNUL îi sfințesc. ");
INSERT INTO ronbtf_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Niciun străin să nu mănânce din lucrul sfânt, un călător oaspete al preotului, sau un servitor angajat, să nu mănânce lucrul sfânt. ");
INSERT INTO ronbtf_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Dar dacă preotul cumpără vreun suflet cu banii săi, el să mănânce din aceasta și cel ce este născut în casa lui, să mănânce din mâncarea lui. ");
INSERT INTO ronbtf_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","De asemenea dacă fiica preotului este măritată după un străin, ea nu poate mânca dintr-o ofrandă a lucrurilor sfinte. ");
INSERT INTO ronbtf_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Dar dacă fiica preotului este văduvă sau divorțată și nu are copil și este întoarsă la casa tatălui ei, ca în tinerețea ei, să mănânce din mâncarea tatălui ei, dar niciun străin să nu mănânce din ea. ");
INSERT INTO ronbtf_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Și dacă un bărbat mănâncă din lucrul sfânt în neștiință, atunci, el să adauge la acesta a cincea parte din el și să îl dea preotului cu lucrul sfânt. ");
INSERT INTO ronbtf_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Iar ei să nu spurce lucrurile sfinte ale copiilor lui Israel, pe care le aduc DOMNULUI; ");
INSERT INTO ronbtf_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Sau să le permită să poarte nelegiuirea fărădelegii, mâncând lucrurile lor sfinte, pentru că eu DOMNUL îi sfințesc. ");
INSERT INTO ronbtf_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Și DOMNUL i-a vorbit lui Moise, zicând: ");
INSERT INTO ronbtf_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Vorbește lui Aaron și fiilor săi și tuturor copiilor lui Israel și spune-le: Oricine din casa lui Israel sau dintre străinii din Israel, care dorește să își aducă darul pentru toate promisiunile sale și toate ofrandele sale de bunăvoie, pe care să le aducă DOMNULUI ca ofrandă arsă; ");
INSERT INTO ronbtf_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","Să aduceți de bunăvoie o parte bărbătească, fără cusur, dintre boi, dintre oi sau dintre capre. ");
INSERT INTO ronbtf_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Dar orice are cusur, să nu îl aduceți, pentru că nu vă va fi bine primit. ");
INSERT INTO ronbtf_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Și oricine aduce un sacrificiu al ofrandelor de pace DOMNULUI, ca să își împlinească promisiunea, sau ofrandă de bunăvoie dintre boi sau oi, aceasta să fie fără cusur pentru a fi bine primită, niciun cusur să nu fie în el. ");
INSERT INTO ronbtf_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Să nu aduceți DOMNULUI nimic dintre acestea: orb sau zdrobit sau ciung sau având o rană care curge sau cruste scărpinate sau râios, nici să nu faceți, din ele pe altar, ofrandă prin foc pentru DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Fie un taur sau un miel care are ceva în plus sau o lipsă în părțile lui, să îl aduci ca ofrandă de bunăvoie, dar ca promisiune nu va fi bine primit. ");
INSERT INTO ronbtf_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Să nu aduceți DOMNULUI ceea ce este lovit sau zdrobit sau frânt sau tăiat; nici să nu faceți din ele ofrandă în țara voastră. ");
INSERT INTO ronbtf_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Nici să nu aduceți pâinea Dumnezeului vostru în niciuna din acestea din mâna unui străin; deoarece în ele este putreziciunea lor și cusururi sunt în ele, nu vă vor fi bine primite. ");
INSERT INTO ronbtf_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","Când un taur sau o oaie sau o capră se nasc, să fie șapte zile sub mamă; și din ziua a opta și de aici încolo va fi bine primit ca ofrandă făcută DOMNULUI prin foc. ");
INSERT INTO ronbtf_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Și dacă este vacă sau oaie, să nu o înjunghiați pe ea și puiul ei în aceeași zi. ");
INSERT INTO ronbtf_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Și când doriți să aduceți un sacrificiu de mulțumire DOMNULUI, să îl aduceți de bunăvoie. ");
INSERT INTO ronbtf_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","În aceeași zi să fie mâncat; să nu lăsați nimic din el până dimineața: Eu sunt DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","De aceea să păziți poruncile mele și să le împliniți: Eu sunt DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Să nu pângăriți numele meu sfânt, ci eu să fiu sfințit printre copiii lui Israel: Eu sunt DOMNUL care vă sfințește, ");
INSERT INTO ronbtf_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Cel care v-a scos afară din țara Egiptului, pentru a fi Dumnezeul vostru: Eu sunt DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Și DOMNUL i-a vorbit lui Moise, zicând: ");
INSERT INTO ronbtf_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Vorbește copiilor lui Israel și spune-le: Referitor la sărbătorile DOMNULUI, pe care le veți proclama adunări sfinte, acestea sunt sărbătorile mele. ");
INSERT INTO ronbtf_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","În șase zile să se facă lucrare, dar ziua a șaptea este sabatul odihnei, o adunare solemnă, sfântă; să nu faceți nicio lucrare în ea, acesta este sabatul DOMNULUI în toate locuințele voastre. ");
INSERT INTO ronbtf_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Acestea sunt sărbătorile DOMNULUI, adunări sfinte, pe care să le proclamați la timpurile lor. ");
INSERT INTO ronbtf_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","În ziua a paisprezecea, din luna întâi pe înserat, este paștele DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Și în ziua a cincisprezecea a aceleași luni este sărbătoarea azimelor DOMNULUI, șapte zile trebuie să mâncați azime. ");
INSERT INTO ronbtf_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","În ziua întâi să aveți o adunare solemnă, sfântă: Să nu faceți nicio lucrare de servire în ea. ");
INSERT INTO ronbtf_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Dar să aduceți DOMNULUI ofrandă făcută prin foc, șapte zile; în ziua a șaptea este o adunare solemnă, sfântă: Să nu faceți nicio lucrare de servire în ea. ");
INSERT INTO ronbtf_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Și DOMNUL i-a vorbit lui Moise, zicând: ");
INSERT INTO ronbtf_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Vorbește copiilor lui Israel și spune-le: Când veți intra în țara pe care v-o dau și veți secera secerișul ei, să aduceți la preot un snop din primele roade ale secerișului vostru; ");
INSERT INTO ronbtf_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Și el va legăna snopul înaintea DOMNULUI ca să vă fie bine primit; preotul îl va legăna a doua zi după sabat. ");
INSERT INTO ronbtf_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Și să aduceți, în ziua când veți legăna acest snop, un miel fără cusur de un an ca ofrandă arsă DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Și darul ei de mâncare să fie două zecimi dintr-o măsură de floarea făinii amestecată cu untdelemn, ofrandă făcută DOMNULUI prin foc, pentru o aromă dulce; și darul lor de băutură să fie din vin, a patra parte dintr-un hin. ");
INSERT INTO ronbtf_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Și să nu mâncați nici pâine nici grâne prăjite nici spice verzi, până în aceeași zi în care ați adus un dar Dumnezeului vostru, acesta să fie un statut pentru totdeauna prin generațiile voastre în toate locuințele voastre. ");
INSERT INTO ronbtf_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Și să vă numărați din ziua următoare sabatului, din ziua în care ați adus mănunchiul ofrandei legănate; șapte sabate întregi; ");
INSERT INTO ronbtf_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Chiar până în ziua următoare celui de al șaptelea sabat să numărați cincizeci de zile; și să aduceți un nou dar de mâncare DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Să scoateți din locuințele voastre două pâini legănate, făcute din două zecimi dintr-o măsură de floarea făinii; să fie coapte cu dospeală; acestea sunt primele roade consacrate DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Și să aduceți împreună cu pâinile, șapte miei fără cusur, de un an, și un taur tânăr și doi berbeci, ei sunt ofrandă arsă DOMNULUI, împreună cu darul lor de mâncare și cu darul lor de băutură, o ofrandă făcută prin foc, de o aromă dulce DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Atunci să sacrificați un ied dintre capre ca ofrandă pentru păcat și doi miei de un an ca un sacrificiu al ofrandelor de pace. ");
INSERT INTO ronbtf_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Și preotul să îi legene împreună cu pâinea primelor roade ca ofrandă legănată înaintea DOMNULUI, cu cei doi miei, să fie sfinți DOMNULUI, pentru preot. ");
INSERT INTO ronbtf_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Și să proclamați în aceeași zi, să vă fie o adunare solemnă, sfântă: Să nu faceți nicio lucrare de servire în ea, acesta să vă fie un statut pentru totdeauna în toate locuințele voastre prin generațiile voastre. ");
INSERT INTO ronbtf_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Și când culegeți secerișul pământului vostru, să nu seceri în întregime colțurile câmpului tău când seceri, nici să nu aduni spicele căzute după secerișul tău, să le lași pentru cel sărac și pentru cel străin: Eu sunt DOMNUL Dumnezeul vostru. ");
INSERT INTO ronbtf_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Și DOMNUL i-a vorbit lui Moise, zicând: ");
INSERT INTO ronbtf_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Vorbește copiilor lui Israel, spunând: În luna a șaptea, în ziua întâi a lunii, să aveți un sabat, o amintire cu sunet de trâmbiță, o adunare solemnă, sfântă. ");
INSERT INTO ronbtf_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Să nu faceți nicio lucrare de servire în ea, ci să aduceți DOMNULUI ofrandă făcută prin foc. ");
INSERT INTO ronbtf_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","De asemenea în ziua a zecea a acestei a șaptea luni să fie o zi a ispășirii, aceasta să fie o adunare solemnă, sfântă pentru voi; și să vă chinuiți sufletele și să aduceți ofrandă făcută prin foc DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Și să nu faceți nicio lucrare în ziua aceea, pentru că este o zi a ispășirii, pentru a se face ispășire pentru voi înaintea DOMNULUI Dumnezeului vostru. ");
INSERT INTO ronbtf_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Pentru că orice suflet care nu se va chinui în ziua aceea, să fie stârpit din mijlocul poporului său. ");
INSERT INTO ronbtf_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Și orice suflet care face vreo lucrare în aceeași zi, pe acel suflet eu îl voi nimici din mijlocul poporului său. ");
INSERT INTO ronbtf_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Să nu faceți niciun fel de lucrare; un statut pentru totdeauna să fie prin generațiile voastre în toate locuințele voastre. ");
INSERT INTO ronbtf_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Acesta să fie pentru voi un sabat al odihnei și să vă chinuiți sufletele, în ziua a noua a lunii, la apus, de la apus la apus, să vă sărbătoriți sabatul. ");
INSERT INTO ronbtf_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Și DOMNUL i-a vorbit lui Moise, zicând: ");
INSERT INTO ronbtf_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Vorbește copiilor lui Israel, spunând: Ziua a cincisprezecea a acestei a șaptea luni, să fie sărbătoarea corturilor pentru DOMNUL, timp de șapte zile. ");
INSERT INTO ronbtf_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","În prima zi să fie o adunare solemnă sfântă: Să nu faceți nicio lucrare de servire în ea. ");
INSERT INTO ronbtf_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Șapte zile să aduceți ofrandă făcută prin foc DOMNULUI, în ziua a opta să fie o adunare solemnă, sfântă pentru voi; și să aduceți ofrandă făcută prin foc DOMNULUI, aceasta este o adunare solemnă: Să nu faceți nicio lucrare de servire în ea. ");
INSERT INTO ronbtf_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Acestea sunt sărbătorile DOMNULUI, pe care să le proclamați pentru a fi adunări sfinte, ca să aduceți ofrandă făcută prin foc DOMNULUI, ofrandă arsă și un dar de mâncare, un sacrificiu și daruri de băutură, fiecare lucru în ziua lui, ");
INSERT INTO ronbtf_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Pe lângă sabatele DOMNULUI și pe lângă darurile voastre și pe lângă toate promisiunile voastre și pe lângă toate darurile voastre de bunăvoie, pe care le aduceți DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","De asemenea tot în ziua a cincisprezecea a lunii a șaptea, după ce ați adunat rodul pământului, să țineți o sărbătoare consacrată DOMNULUI, șapte zile, în prima zi să fie un sabat și în ziua a opta să fie un sabat. ");
INSERT INTO ronbtf_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Și să luați în prima zi din crengile pomilor buni, ramuri de palmier și din crengile copacilor stufoși și sălcii de la izvor; și să vă bucurați înaintea DOMNULUI Dumnezeul vostru, șapte zile. ");
INSERT INTO ronbtf_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Și să țineți o sărbătoare pentru DOMNUL, șapte zile pe an. Acesta să fie un statut veșnic în generațiile voastre, să o sărbătoriți în luna a șaptea. ");
INSERT INTO ronbtf_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Să locuiți în corturi șapte zile; toți cei ce sunt născuți israeliți, să locuiască în corturi; ");
INSERT INTO ronbtf_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Ca generațiile voastre să știe că eu am făcut pe copiii lui Israel să locuiască în corturi, când i-am scos afară din țara Egiptului: Eu sunt DOMNUL Dumnezeul vostru. ");
INSERT INTO ronbtf_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Și Moise a spus copiilor lui Israel sărbătorile DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Poruncește copiilor lui Israel, ca ei să îți aducă untdelemn pur de măsline bătute, pentru lumină, pentru a face ca lămpile să ardă continuu. ");
INSERT INTO ronbtf_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","În afara perdelei mărturiei, în tabernacolul întâlnirii, Aaron să le pună în ordine de seara până dimineața înaintea DOMNULUI, continuu; acesta să fie un statut veșnic în toate generațiile voastre. ");
INSERT INTO ronbtf_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Să pună în ordine lămpile pe sfeșnicul cel pur, continuu înaintea DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Și să iei floarea făinii și să coci douăsprezece turte din ea, două zecimi să fie într-o turtă. ");
INSERT INTO ronbtf_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Și să le pui pe două rânduri, șase pe un rând, pe masa pură înaintea DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Și să pui tămâie pură pe fiecare rând, ca aceasta să fie pe pâine ca o amintire, o ofrandă făcută prin foc DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","În fiecare sabat să o pună în ordine înaintea DOMNULUI, continuu, fiind luată de la copiii lui Israel printr-un legământ veșnic. ");
INSERT INTO ronbtf_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Și aceasta să fie a lui Aaron și a fiilor săi; și ei să o mănânce în locul sfânt, pentru că aceasta este preasfântă pentru el dintre ofrandele făcute prin foc DOMNULUI, printr-un statut veșnic. ");
INSERT INTO ronbtf_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Și fiul unei femei israelite, al cărui tată era egiptean, a ieșit dintre copiii lui Israel; și acest fiu al femeii israelite și un bărbat al lui Israel s-au luptat în tabără; ");
INSERT INTO ronbtf_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Și fiul femeii israelite a blasfemiat numele DOMNULUI și a blestemat. Iar ei l-au adus la Moise (și numele mamei sale era Șelomit, fiica lui Dibri, din tribul lui Dan); ");
INSERT INTO ronbtf_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Și l-au pus sub pază, ca mintea DOMNULUI să le fie arătată. ");
INSERT INTO ronbtf_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","Scoate pe cel ce a blestemat în afara taberei; și toți cei ce l-au auzit să își pună mâinile pe capul lui și toată adunarea să îl ucidă cu pietre. ");
INSERT INTO ronbtf_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Și să vorbești copiilor lui Israel, spunând: Oricine blestemă pe Dumnezeul său să își poarte păcatul. ");
INSERT INTO ronbtf_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Și cel ce a blasfemiat numele DOMNULUI, acela cu siguranță să fie dat morții și toată adunarea să îl ucidă negreșit cu pietre; cel străin în același fel ca cel născut în țară, când el blasfemiază numele DOMNULUI, să fie dat morții. ");
INSERT INTO ronbtf_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Și cel ce ucide vreun om să fie cu siguranță dat morții. ");
INSERT INTO ronbtf_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Și cel ce ucide un animal va plăti; animal pentru animal. ");
INSERT INTO ronbtf_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Și dacă un bărbat provoacă o vătămare aproapelui său; precum a făcut, astfel să îi fie făcut; ");
INSERT INTO ronbtf_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Spărtură pentru spărtură, ochi pentru ochi, dinte pentru dinte, precum a provocat o vătămare într-un om, astfel să îi fie făcut. ");
INSERT INTO ronbtf_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Și cel ce ucide o vită, va plăti vita; și cel ce ucide un om, să fie dat morții. ");
INSERT INTO ronbtf_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Să aveți un singur fel de lege, pentru străin în același fel ca pentru unul din țara voastră, pentru că eu sunt DOMNUL Dumnezeul vostru. ");
INSERT INTO ronbtf_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Și Moise a vorbit copiilor lui Israel, ca ei să scoată pe cel ce a blestemat în afara taberei și să îl ucidă cu pietre. Și copiii lui Israel au făcut precum DOMNUL i-a poruncit lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Și DOMNUL i-a vorbit lui Moise în muntele Sinai, zicând: ");
INSERT INTO ronbtf_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Vorbește copiilor lui Israel și spune-le: Când veți ajunge în țara pe care v-o dau, țara să țină un sabat DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Șase ani să semeni câmpul tău și șase ani să tai via ta și să aduni rodul lor; ");
INSERT INTO ronbtf_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Dar în al șaptelea an să fie un sabat al odihnei pământului, un sabat pentru DOMNUL, să nu semeni câmpul tău, nici să nu tai via ta. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Ceea ce crește de la sine din secerișul tău să nu seceri, nici să nu strângi ciorchinii din via ta netăiată, pentru că este un an al odihnei pământului. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Și sabatul pământului să fie mâncare pentru voi; pentru tine și pentru servitorii tăi și pentru servitoarele tale și pentru angajații tăi și pentru străinul tău care locuiește temporar cu tine, ");
INSERT INTO ronbtf_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Și pentru vitele tale și pentru animalele tale care sunt pe pământul tău, tot rodul lui să fie mâncare. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Și să îți numeri șapte sabate ale anilor, de șapte ori șapte ani; și durata celor șapte sabate ale anilor să îți fie ție de patruzeci și nouă de ani. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Atunci să faci să sune tare trâmbița jubileului în ziua a zecea a lunii a șaptea, în ziua ispășirii să faceți să sune trâmbița prin toată țara voastră. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Și să sfințiți fiecare al cincizecilea an și să vestiți libertate prin toată țara tuturor locuitorilor ei, acesta să vă fie un jubileu; și să întoarceți înapoi, pe fiecare om, la moștenirea lui și să întoarceți înapoi pe fiecare om la familia lui. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Un jubileu să vă fie al cincizecilea an, nici să nu semănați, nici să nu secerați ceea ce crește de la sine, nici să nu strângi ciorchinii viei tale netăiate. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Pentru că este jubileul; acesta să fie sfânt pentru voi, să mâncați rodul lui care iese din câmp. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","În anul acestui jubileu să întoarceți înapoi, pe fiecare bărbat, la posesiunea lui. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Și dacă vinzi orice aproapelui tău, sau cumperi ceva din mâna aproapelui tău, să nu vă oprimați unul pe altul, ");
INSERT INTO ronbtf_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Conform cu numărul anilor de după jubileu să cumperi de la aproapele tău și conform cu numărul anilor roadelor, el să îți vândă ție; ");
INSERT INTO ronbtf_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Conform cu numărul anilor să crești prețul lor și conform împuținării anilor să micșorezi prețul lor, căci conform cu numărul anilor roadelor, el o să îți vândă. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","De aceea să nu vă oprimați unul pe altul; ci să te temi de Dumnezeul tău, pentru că eu sunt DOMNUL Dumnezeul vostru. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Pentru aceea să împliniți statutele mele și să păziți judecățile mele și să le împliniți; și veți locui în țară în siguranță. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Și țara să aducă rodul ei și să mâncați spre săturarea voastră și să locuiți în siguranță în ea. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Și dacă veți spune: Ce vom mânca în al șaptelea an? Iată, nu vom semăna, nici nu vom aduna în rodul nostru; ");
INSERT INTO ronbtf_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Atunci voi porunci binecuvântarea mea peste voi în al șaselea an, iar el va face rod pentru trei ani. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Și veți semăna în al optulea an și veți mânca tot din rodul vechi până în al nouălea an; până ce roadele lui vor intra la voi veți mânca din cele vechi. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Pământul să nu fie vândut pentru totdeauna, căci pământul este al meu, pentru că voi sunteți străini și locuitori temporari cu mine. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Și în toată țara stăpânirii voastre să dați o răscumpărare pentru pământ. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Dacă fratele tău sărăcește și a vândut ceva din moștenirile sale și dacă vine cineva dintre rudele sale să o răscumpere, atunci să răscumpere ceea ce fratele lui a vândut. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Și dacă bărbatul nu are pe nimeni ca să răscumpere și el însuși este în stare să o răscumpere; ");
INSERT INTO ronbtf_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Atunci să socotească anii de la vânzarea ei și să plătească înapoi ce este în plus bărbatului căruia i-a vândut-o; ca să se întoarcă înapoi la stăpânirea sa. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Dar dacă nu este în stare să îi plătească înapoi, atunci ceea ce este vândut să rămână în mâna celui ce a cumpărat, până în anul jubileului; și la jubileu să iasă și să se întoarcă în stăpânirea sa. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Și dacă un bărbat vinde o casă de locuit într-o cetate înconjurată cu ziduri, atunci el poate să o răscumpere în decursul unui an întreg după ce aceasta este vândută; în decursul unui an întreg poate să o răscumpere. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Și dacă nu o răscumpără pe durata unui an întreg, atunci casa care este în cetatea înconjurată cu ziduri să fie întemeiată, pentru totdeauna celui ce a cumpărat-o prin toate generațiile sale, aceasta să nu iasă la jubileu. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Dar casele din satele care nu au ziduri, de jur împrejur, să fie socotite precum câmpurile ținutului, ele pot fi răscumpărate și vor ieși la jubileu. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Totuși cetățile leviților și casele din cetățile stăpânirilor lor, leviții le pot răscumpăra oricând. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Și dacă un bărbat cumpără de la un levit, atunci casa care a fost vândută și cetatea stăpânirii sale, să iasă la jubileu, căci casele din cetățile leviților sunt stăpânirea lor printre copiii lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Dar câmpul de la împrejurimile cetăților lor să nu fie vândut, pentru că este stăpânirea lor veșnică. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Și dacă fratele tău sărăcește și decade lângă tine; atunci să îl ajuți, da, chiar dacă este un străin, sau un locuitor temporar; ca el să trăiască cu tine. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Nu lua camătă de la el, sau dobândă, ci să te temi de Dumnezeul tău; ca fratele tău să trăiască cu tine. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Să nu îi dai banii cu camătă, nici să nu îi împrumuți merinde cu dobândă. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Eu sunt DOMNUL Dumnezeul vostru, care v-am scos afară din țara Egiptului, pentru a vă da țara Canaanului și pentru a fi Dumnezeul vostru. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Și dacă fratele tău care locuiește lângă tine sărăcește și ți s-a vândut, să nu îl obligi să îți facă muncă de rob; ");
INSERT INTO ronbtf_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Ci ca un angajat și ca un locuitor temporar, să fie cu tine și să îți servească până în anul jubileului. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Și să plece de la tine, deopotrivă el și copiii lui cu el și să se întoarcă la propria familie și la stăpânirile părinților săi să se întoarcă. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Pentru că ei sunt servitorii mei, pe care i-am scos afară din țara Egiptului, nu vor fi vânduți ca robi. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Să nu domnești peste el cu asprime; ci să te temi de Dumnezeul tău. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Deopotrivă robii tăi și roabele tale, pe care le vei avea, să fie dintre păgânii care sunt în jurul tău; dintre ei să îți cumperi robi și roabe. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Mai mult dintre copiii străinilor care locuiesc temporar printre voi, dintre ei să cumpărați și dintre familiile lor care sunt cu voi, pe care ei i-au născut în țara voastră, și ei să fie stăpânirea voastră. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Și să îi luați ca moștenire pentru copiii voștri, ca să îi moștenească drept stăpânire; să fie robii voștri pentru totdeauna; dar peste frații voștri, copiii lui Israel, să nu domniți unul peste altul cu asprime. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Și dacă un locuitor temporar sau un străin se îmbogățește lângă tine și dacă fratele tău care locuiește lângă el sărăcește și se vinde străinului sau celui ce locuiește temporar lângă tine, sau la urmașii familiei străinului, ");
INSERT INTO ronbtf_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","După ce este vândut el poate fi răscumpărat din nou; unul dintre frați poate să îl răscumpere; ");
INSERT INTO ronbtf_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Fie unchiul său, fie fiul unchiului său, poate să îl răscumpere, sau oricine îi este rudă apropiată, din familie poate să îl răscumpere; sau dacă este în stare, se poate răscumpăra el însuși. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Și să socotească cu cel ce l-a cumpărat, din anul în care acela i-a fost vândut până în anul jubileului; și prețul vânzării sale să fie conform cu numărul anilor, să îi fie conform cu zilele unui servitor angajat. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Dacă sunt încă mulți ani rămași, conform cu aceia, să dea înapoi prețul răscumpărării sale din banii pentru care a fost cumpărat. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Și dacă rămân doar câțiva ani până la anul jubileului, atunci să socotească împreună cu el și conform cu anii săi să îi dea înapoi prețul răscumpărării sale. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Și să fie cu el precum cu un servitor angajat anual; și celălalt să nu domnească peste el cu asprime, în fața ta. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Și dacă nu este răscumpărat în acești ani, atunci să iasă în anul jubileului, deopotrivă el și copiii lui cu el. ");
INSERT INTO ronbtf_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Pentru că mie îmi sunt servitori copiii lui Israel; ei sunt servitorii mei pe care i-am scos din țara Egiptului: Eu sunt DOMNUL Dumnezeul vostru. ");
INSERT INTO ronbtf_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Să nu vă faceți nici idoli nici chip cioplit, nici să nu ridicați un chip stând în picioare, nici să nu ridicați vreun chip de piatră în pământul vostru, ca să vă prosternați lui, pentru că eu sunt DOMNUL Dumnezeul vostru. ");
INSERT INTO ronbtf_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Să țineți sabatele mele și să respectați sanctuarul meu: Eu sunt DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Dacă umblați în statutele mele și țineți poruncile mele și le împliniți, ");
INSERT INTO ronbtf_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","Atunci vă voi da ploaie la timpul cuvenit și pământul își va aduce venitul lui și pomii câmpului își vor aduce rodul lor. ");
INSERT INTO ronbtf_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Și treieratul vostru se va întinde până la culesul viilor și culesul viilor se va întinde până la timpul semănatului; și vă veți mânca pâinea pe săturate și veți locui în țara voastră în siguranță. ");
INSERT INTO ronbtf_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Și vă voi da pace în țară și vă veți culca și nimeni nu vă va înfrica; și voi scoate fiarele rele afară din țară și sabia nu va trece prin țara voastră. ");
INSERT INTO ronbtf_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Și veți alunga pe dușmanii voștri, iar ei vor cădea în fața voastră prin sabie. ");
INSERT INTO ronbtf_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Și cinci dintre voi vor alunga o sută și o sută dintre voi vor pune pe fugă zece mii; și dușmanii voștri vor cădea înaintea voastră prin sabie. ");
INSERT INTO ronbtf_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Pentru că voi lua cunoștință de voi și vă voi face roditori și vă voi înmulți și voi întemeia legământul meu cu voi. ");
INSERT INTO ronbtf_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Și veți mânca din cele vechi și veți scoate pe cele vechi din cauza celor noi. ");
INSERT INTO ronbtf_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Și voi așeza tabernacolul meu printre voi; și sufletul meu nu se va dezgusta de voi. ");
INSERT INTO ronbtf_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Și voi umbla între voi și voi fi Dumnezeul vostru și voi veți fi poporul meu. ");
INSERT INTO ronbtf_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Eu sunt DOMNUL Dumnezeul vostru, care v-am scos afară din țara Egiptului, ca să nu fiți robii lor; și am frânt legăturile jugului vostru și v-am făcut să mergeți drept. ");
INSERT INTO ronbtf_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Dar dacă nu îmi veți da ascultare și nu veți împlini toate aceste porunci; ");
INSERT INTO ronbtf_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","Și dacă veți disprețui statutele mele, sau dacă sufletul vostru va detesta judecățile mele, astfel încât nu veți împlini toate poruncile mele, ci veți rupe legământul meu, ");
INSERT INTO ronbtf_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","Eu de asemenea vă voi face aceasta, voi rândui peste voi teroare, tuberculoză și febra arzătoare, care va mistui ochii și va cauza întristare inimii, iar voi veți semăna sămânța voastră în zadar, pentru că dușmanii voștri o vor mânca. ");
INSERT INTO ronbtf_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Și îmi voi întoarce fața împotriva voastră și veți fi uciși înaintea dușmanilor voștri, cei ce vă urăsc vor domni peste voi; și veți fugi când nimeni nu vă urmărește. ");
INSERT INTO ronbtf_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Și dacă totuși din cauza tuturor acestor lucruri nu îmi veți da ascultare, atunci vă voi pedepsi înșeptit pentru păcatele voastre. ");
INSERT INTO ronbtf_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Și voi frânge mândria puterii voastre; și voi face, ca fierul, cerul vostru; și ca arama, pământul vostru; ");
INSERT INTO ronbtf_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Și tăria voastră va fi cheltuită în zadar, pentru că pământul vostru nu își va aduce venitul, nici pomii pământului nu își vor aduce roadele. ");
INSERT INTO ronbtf_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Și dacă umblați împotriva mea și nu îmi veți da ascultare; voi aduce înșeptit plăgi peste voi, conform păcatelor voastre. ");
INSERT INTO ronbtf_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","De asemenea voi trimite fiare sălbatice printre voi, care vă vor jefui de copiii voștri și vor distruge vitele voastre și vă vor împuțina la număr; și căile vieții voastre vor fi pustiite. ");
INSERT INTO ronbtf_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Și dacă nu vă veți lăsa corectați de mine prin acestea, ci veți umbla împotriva mea, ");
INSERT INTO ronbtf_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","Atunci eu de asemenea voi umbla împotriva voastră și vă voi pedepsi înșeptit pentru păcatele voastre. ");
INSERT INTO ronbtf_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Și voi aduce sabie asupra voastră, care va pedepsi cearta voastră cu legământul meu; și când vă veți aduna înăuntrul cetăților voastre, voi trimite ciuma printre voi; și veți fi dați în mâna dușmanului. ");
INSERT INTO ronbtf_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Și după ce voi fi frânt toiagul pâinii voastre, zece femei vor coace pâinea voastră într-un singur cuptor și vă vor da înapoi pâinea voastră cântărită; și veți mânca dar nu vă veți sătura. ");
INSERT INTO ronbtf_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Și dacă din cauza a toată aceasta nu îmi veți da ascultare, ci veți umbla împotriva mea, ");
INSERT INTO ronbtf_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","Atunci și eu voi umbla împotriva voastră în furie; și eu, chiar eu, vă voi pedepsi înșeptit pentru păcatele voastre. ");
INSERT INTO ronbtf_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Și carnea fiilor voștri o veți mânca și carnea fiicelor voastre o veți mânca. ");
INSERT INTO ronbtf_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Și voi distruge înălțimile voastre și voi stârpi idolii voștri și voi arunca trupurile voastre moarte peste trupurile moarte ale idolilor voștri și sufletul meu vă va detesta. ");
INSERT INTO ronbtf_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Și voi risipi cetățile voastre și voi aduce sanctuarele voastre la pustiire și nu voi mirosi aromele voastre dulci. ");
INSERT INTO ronbtf_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Și voi aduce țara la pustiire; și dușmanii voștri, care locuiesc în ea, vor fi înmărmuriți la aceasta. ");
INSERT INTO ronbtf_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Și vă voi împrăștia printre păgâni și voi scoate sabie după voi; și țara voastră va fi pustiită și cetățile voastre risipite. ");
INSERT INTO ronbtf_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Atunci țara se va bucura de sabatele ei, atâta timp cât va zăcea pustiită și voi veți fi în țara dușmanilor voștri; atunci țara se va odihni și se va bucura de sabatele ei. ");
INSERT INTO ronbtf_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Atâta timp cât zace pustiită ea se va odihni; deoarece nu s-a odihnit în sabatele voastre, când ați locuit în ea. ");
INSERT INTO ronbtf_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Și peste cei ce au rămas în viață voi trimite o slăbiciune în inimile lor în țările dușmanilor voștri; și sunetul unei frunze scuturate îi va urmări; și vor fugi precum fuga de sabie; și vor cădea când nimeni nu îi urmărește. ");
INSERT INTO ronbtf_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Și vor cădea unul peste altul, de parcă ar fi înaintea unei săbii, când nimeni nu îi urmărește; și nu veți avea putere să stați în picioare înaintea dușmanilor voștri. ");
INSERT INTO ronbtf_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Și veți pieri printre păgâni și țara dușmanilor voștri vă va mânca. ");
INSERT INTO ronbtf_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Și cei rămași dintre voi vor lâncezi în nelegiuirea lor în țările dușmanilor voștri; și de asemenea în nelegiuirile părinților lor vor lâncezi împreună cu ei. ");
INSERT INTO ronbtf_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Dacă își vor mărturisi nelegiuirea lor și nelegiuirea părinților lor, cu fărădelegea lor cu care au încălcat legea împotriva mea și de asemenea că au umblat împotriva mea; ");
INSERT INTO ronbtf_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Și că eu de asemenea am umblat împotriva lor și i-am adus în țara dușmanilor lor; dacă atunci inimile lor necircumcise se vor umili și vor accepta atunci pedeapsa nelegiuirii lor, ");
INSERT INTO ronbtf_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Atunci îmi voi aminti legământul meu cu Iacob și de asemenea legământul meu cu Isaac și de asemenea legământul meu cu Avraam mi-l voi aminti; și îmi voi aminti de țară. ");
INSERT INTO ronbtf_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","De asemenea țara va fi părăsită de ei și se va bucura de sabatele ei, atâta timp cât va zăcea pustiită fără ei; și vor accepta pedeapsa nelegiuirii lor, pentru că, da, pentru că au disprețuit judecățile mele și pentru că sufletul lor a detestat statutele mele. ");
INSERT INTO ronbtf_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Și totuși pentru toate acestea, când vor fi în țara dușmanilor lor, nu îi voi lepăda, nici nu îi voi detesta, ca să îi nimicesc cu desăvârșire și să rup legământul meu cu ei, pentru că eu sunt DOMNUL Dumnezeul lor. ");
INSERT INTO ronbtf_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Dar de dragul lor îmi voi aminti legământul strămoșilor lor, pe care i-am scos din țara Egiptului înaintea ochilor păgânilor, ca să fiu Dumnezeul lor: Eu sunt DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Acestea sunt statutele și judecățile și legile, pe care DOMNUL le-a făcut între el și copiii lui Israel pe muntele Sinai prin mâna lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Și DOMNUL i-a vorbit lui Moise, zicând: ");
INSERT INTO ronbtf_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Vorbește copiilor lui Israel și spune-le: Când un om va face o promisiune însemnată, sufletele acelea să fie pentru DOMNUL, după prețuirea ta. ");
INSERT INTO ronbtf_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Și prețuirea ta să fie pentru partea bărbătească de la vârsta de douăzeci de ani până la vârsta de șaizeci de ani, după șekelul sanctuarului prețuirea ta să fie de cincizeci de șekeli de argint. ");
INSERT INTO ronbtf_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Și dacă este parte femeiască, atunci prețuirea ta să fie de treizeci de șekeli. ");
INSERT INTO ronbtf_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Și dacă este în vârstă de cinci ani până la vârsta de douăzeci de ani, atunci prețuirea ta pentru partea bărbătească să fie douăzeci de șekeli și pentru partea femeiască, zece șekeli. ");
INSERT INTO ronbtf_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Și dacă este de la vârsta de o lună până la vârsta de cinci ani, atunci prețuirea ta pentru partea bărbătească să fie de cinci șekeli de argint și pentru partea femeiască prețuirea ta să fie de trei șekeli de argint. ");
INSERT INTO ronbtf_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Și dacă este de la vârsta de șaizeci de ani și peste, dacă este parte bărbătească, atunci prețuirea ta să fie de cincisprezece șekeli și pentru partea femeiască, zece șekeli. ");
INSERT INTO ronbtf_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Dar dacă este mai sărac decât prețuirea ta, atunci să se prezinte el însuși înaintea preotului și preotul să îl prețuiască; preotul să îl prețuiască conform cu mijloacele celui ce promite. ");
INSERT INTO ronbtf_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Și dacă este un animal, din care oamenii aduc un dar DOMNULUI, tot ce omul dă DOMNULUI din acest dar să fie sfânt. ");
INSERT INTO ronbtf_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Să nu îl schimbe, nici să nu îl înlocuiască, unul bun pentru unul rău, sau unul rău pentru unul bun; și dacă totuși el schimbă animal pentru animal, atunci acesta și cel înlocuit să fie sfinți. ");
INSERT INTO ronbtf_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Și dacă este un animal necurat, din care ei nu aduc sacrificiu DOMNULUI, atunci să prezinte animalul înaintea preotului; ");
INSERT INTO ronbtf_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Și preotul să îl prețuiască, dacă este bun sau rău, conform cu prețuirea preotului, așa va fi. ");
INSERT INTO ronbtf_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Iar dacă el dorește să îl răscumpere, atunci să adauge a cincea partea din el la prețuirea ta. ");
INSERT INTO ronbtf_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Și când un bărbat își va sfinți casa pentru a fi sfântă DOMNULUI, atunci preotul să o prețuiască, dacă este bună sau rea; precum preotul o va prețui, așa să fie. ");
INSERT INTO ronbtf_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Și dacă cel ce a sfințit-o dorește să își răscumpere casa, atunci să adauge la ea a cincea parte din banii prețuirii tale și să fie a lui. ");
INSERT INTO ronbtf_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Și dacă un bărbat va sfinți DOMNULUI o parte din câmpul stăpânirii sale, atunci prețuirea ta să fie conform cu sămânța câmpului, un homer de sămânță de orz să fie prețuit la cincizeci de șekeli de argint. ");
INSERT INTO ronbtf_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Dacă el sfințește câmpul său din anul jubileului, să fie după prețuirea ta. ");
INSERT INTO ronbtf_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Dar dacă îți sfințește câmpul după jubileu, atunci preotul să îi socotească banii conform cu anii care rămân, până la anul jubileului și să fie scăzut din prețuirea ta. ");
INSERT INTO ronbtf_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Și dacă cel ce sfințește câmpul dorește, în vreun fel, să îl răscumpere, atunci să îi adauge a cincea parte din banii prețuirii tale și să îi rămână lui. ");
INSERT INTO ronbtf_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Și dacă nu dorește să răscumpere câmpul, sau dacă a vândut câmpul unui alt om, să nu mai fie răscumpărat. ");
INSERT INTO ronbtf_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Dar câmpul, când iese la jubileu, să fie sfânt DOMNULUI, ca un câmp dedicat; stăpânirea acestuia să fie a preotului. ");
INSERT INTO ronbtf_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Și dacă un om sfințește DOMNULUI un câmp pe care l-a cumpărat, care nu este dintre câmpurile stăpânirii sale, ");
INSERT INTO ronbtf_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","Atunci preotul să îi socotească valoarea prețuirii tale, până la anul jubileului, iar el să dea prețuirea ta în acea zi ca lucru sfânt DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","În anul jubileului câmpul se va întoarce la cel de la care a fost cumpărat, la cel căruia i-a aparținut stăpânirea pământului. ");
INSERT INTO ronbtf_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Și toate prețuirile tale să fie conforme cu șekelul sanctuarului, douăzeci de ghere să fie șekelul. ");
INSERT INTO ronbtf_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Doar pe întâiul născut al animalelor, care să fie întâiul născut al DOMNULUI, niciun om să nu îl sfințească; dacă este bou, sau oaie, este al DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Și dacă este dintr-un animal necurat, atunci să îl răscumpere conform cu prețuirea ta și să îi adauge a cincea parte din ea; și dacă nu este răscumpărată, atunci să se vândă conform cu prețuirea ta. ");
INSERT INTO ronbtf_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Cu toate acestea niciun lucru dedicat, pe care un om îl va dedica DOMNULUI din tot ce are, fie dintre oameni, fie dintre animale, fie din câmpul stăpânirii sale, să nu fie vândut sau răscumpărat, fiecare lucru dedicat este preasfânt DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Nimic dedicat, care va fi dedicat dintre oameni, să nu fie răscumpărat; ci negreșit să fie dat morții. ");
INSERT INTO ronbtf_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Și toată zeciuiala pământului, fie din sămânța pământului, fie din rodul pomilor, este a DOMNULUI, ea este sfântă DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Și dacă un om va dori să răscumpere ceva din zeciuielile sale, să adauge la ele a cincea parte din ele. ");
INSERT INTO ronbtf_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Și referitor la zeciuiala din cireadă, sau din turmă, din tot ce trece pe sub toiag, a zecea parte să fie sfântă DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Să nu se uite dacă este bună sau rea, nici să nu o schimbe una cu alta; și dacă va schimba ceva, atunci deopotrivă aceasta și cea pentru schimb să fie sfântă; să nu se răscumpere. ");
INSERT INTO ronbtf_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Acestea sunt poruncile, pe care DOMNUL le-a poruncit lui Moise pentru copiii lui Israel pe muntele Sinai. ");
INSERT INTO ronbtf_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Și DOMNUL i-a vorbit lui Moise în pustiul Sinai, în tabernacolul întâlnirii, în prima zi a lunii a doua, în al doilea an după ce au ieșit din țara Egiptului, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","Faceți numărătoarea întregii adunări a copiilor lui Israel, după familiile lor, după casa părinților lor, după numărul numelor lor, fiecare parte bărbătească după capii lor; ");
INSERT INTO ronbtf_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","De la douăzeci de ani în sus, toți cei care sunt în stare să iasă la război în Israel; tu și Aaron să îi numeri după oștirile lor. ");
INSERT INTO ronbtf_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Și cu tine să fie un bărbat din fiecare trib; fiecare cap al casei părinților lui. ");
INSERT INTO ronbtf_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Și acestea sunt numele bărbaților care vor sta în picioare cu tine, din tribul lui Ruben, Elițur, fiul lui Ședeur. ");
INSERT INTO ronbtf_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Din Simeon: Șelumiel, fiul lui Țurișadai. ");
INSERT INTO ronbtf_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Din Iuda: Nahșon, fiul lui Aminadab. ");
INSERT INTO ronbtf_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Din Isahar: Nataneel, fiul lui Țuar. ");
INSERT INTO ronbtf_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Din Zabulon: Eliab, fiul lui Helon. ");
INSERT INTO ronbtf_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Din copiii lui Iosif, din Efraim: Elișama, fiul lui Amihud; din Manase: Gamaliel, fiul lui Pedahțur. ");
INSERT INTO ronbtf_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Din Beniamin: Abidan, fiul lui Ghideoni. ");
INSERT INTO ronbtf_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Din Dan: Ahiezer, fiul lui Amișadai. ");
INSERT INTO ronbtf_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Din Așer: Paguiel, fiul lui Ocran. ");
INSERT INTO ronbtf_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Din Gad: Eliasaf, fiul lui Deuel. ");
INSERT INTO ronbtf_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Din Neftali: Ahira, fiul lui Enan. ");
INSERT INTO ronbtf_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Aceștia erau cei renumiți ai adunării, prinți ai triburilor părinților lor, căpeteniile miilor în Israel. ");
INSERT INTO ronbtf_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Și Moise și Aaron au luat pe acești bărbați numiți după numele lor; ");
INSERT INTO ronbtf_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","Și au adunat toată adunarea în prima zi a lunii a doua și au declarat nașterile lor după familiile lor, după casa părinților lor, conform numărului numelor, de la vârsta de douăzeci de ani în sus, după capii lor. ");
INSERT INTO ronbtf_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Precum DOMNUL i-a poruncit lui Moise, astfel i-a numărat în pustiul Sinai. ");
INSERT INTO ronbtf_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Și copiii lui Ruben, fiul cel mai mare al lui Israel, după generațiile lor, după familiile lor, după casa părinților lor, conform numărului numelor, după capii lor, fiecare parte bărbătească de la vârsta de douăzeci de ani în sus, toți care erau în stare să iasă la război; ");
INSERT INTO ronbtf_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Cei numărați dintre ei, din tribul lui Ruben, au fost patruzeci și șase de mii cinci sute. ");
INSERT INTO ronbtf_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Dintre copiii lui Simeon, după generațiile lor, după familiile lor, după casa părinților lor, cei numărați dintre ei, conform numărului numelor, după capii lor, fiecare parte bărbătească de la vârsta de douăzeci de ani în sus, toți care erau în stare să iasă la război; ");
INSERT INTO ronbtf_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Cei numărați dintre ei, din tribul lui Simeon, au fost cincizeci și nouă de mii trei sute. ");
INSERT INTO ronbtf_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Dintre copiii lui Gad, după generațiile lor, după familiile lor, după casa părinților lor, conform numărului numelor, de la vârsta de douăzeci de ani în sus, toți care erau în stare să iasă la război; ");
INSERT INTO ronbtf_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Cei numărați dintre ei, din tribul lui Gad, au fost patruzeci și cinci de mii șase sute cincizeci. ");
INSERT INTO ronbtf_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Dintre copiii lui Iuda, după generațiile lor, după familiile lor, după casa părinților lor, conform numărului numelor, de la vârsta de douăzeci de ani în sus, toți care erau în stare să iasă la război; ");
INSERT INTO ronbtf_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Cei numărați dintre ei, din tribul lui Iuda, au fost șaptezeci și patru de mii șase sute. ");
INSERT INTO ronbtf_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Dintre copiii lui Isahar, după generațiile lor, după familiile lor, după casa părinților lor, conform numărului numelor, de la vârsta de douăzeci de ani în sus, toți care erau în stare să iasă la război; ");
INSERT INTO ronbtf_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Cei numărați dintre ei, din tribul lui Isahar, au fost cincizeci și patru de mii patru sute. ");
INSERT INTO ronbtf_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Dintre copiii lui Zabulon, după generațiile lor, după familiile lor, după casa părinților lor, conform numărului numelor, de la vârsta de douăzeci de ani în sus, toți care erau în stare să iasă la război; ");
INSERT INTO ronbtf_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Cei numărați dintre ei, din tribul lui Zabulon, au fost cincizeci și șapte de mii patru sute. ");
INSERT INTO ronbtf_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Dintre copiii lui Iosif, adică, din copiii lui Efraim, după generațiile lor, după familiile lor, după casa părinților lor, conform numărului numelor, de la vârsta de douăzeci de ani în sus, toți care erau în stare să iasă la război; ");
INSERT INTO ronbtf_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Cei numărați dintre ei, din tribul lui Efraim, au fost patruzeci de mii cinci sute. ");
INSERT INTO ronbtf_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Dintre copiii lui Manase, după generațiile lor, după familiile lor, după casa părinților lor, conform numărului numelor, de la vârsta de douăzeci de ani în sus, toți care erau în stare să iasă la război; ");
INSERT INTO ronbtf_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Cei numărați dintre ei, din tribul lui Manase, au fost treizeci și două de mii două sute. ");
INSERT INTO ronbtf_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Dintre copiii lui Beniamin, după generațiile lor, după familiile lor, după casa părinților lor, conform numărului numelor, de la vârsta de douăzeci de ani în sus, toți care erau în stare să iasă la război; ");
INSERT INTO ronbtf_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Cei numărați dintre ei, din tribul lui Beniamin, au fost treizeci și cinci de mii patru sute. ");
INSERT INTO ronbtf_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Dintre copiii lui Dan, după generațiile lor, după familiile lor, după casa părinților lor, conform numărului numelor, de la vârsta de douăzeci de ani în sus, toți care erau în stare să iasă la război; ");
INSERT INTO ronbtf_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Cei numărați dintre ei, din tribul lui Dan, au fost șaizeci și două de mii șapte sute. ");
INSERT INTO ronbtf_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Dintre copiii lui Așer, după generațiile lor, după familiile lor, după casa părinților lor, conform numărului numelor, de la vârsta de douăzeci de ani în sus, toți care erau în stare să iasă la război; ");
INSERT INTO ronbtf_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Cei numărați dintre ei, din tribul lui Așer, au fost patruzeci și una de mii cinci sute. ");
INSERT INTO ronbtf_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Dintre copiii lui Neftali, după generațiile lor, după familiile lor, după casa părinților lor, conform numărului numelor, de la vârsta de douăzeci de ani în sus, toți care erau în stare să iasă la război; ");
INSERT INTO ronbtf_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Cei numărați dintre ei, din tribul lui Neftali, au fost cincizeci și trei de mii patru sute. ");
INSERT INTO ronbtf_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Aceștia sunt cei numărați, pe care Moise și Aaron i-au numărat și prinții lui Israel, fiind doisprezece bărbați; fiecare era pentru casa părinților lui. ");
INSERT INTO ronbtf_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Astfel au fost toți cei numărați dintre copiii lui Israel, după casa părinților lor, de la vârsta de douăzeci de ani în sus, toți cei care erau în stare să iasă la război în Israel; ");
INSERT INTO ronbtf_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Da, toți cei numărați au fost șase sute trei mii cinci sute cincizeci. ");
INSERT INTO ronbtf_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Dar leviții după tribul părinților lor nu au fost numărați printre ei. ");
INSERT INTO ronbtf_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Fiindcă DOMNUL vorbise lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","Numai tribul lui Levi să nu îl numeri, nici să nu faci numărătoarea lor printre copiii lui Israel, ");
INSERT INTO ronbtf_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Ci să numești pe leviți peste tabernacolul mărturiei și peste toate vasele lui și peste toate lucrurile care aparțin de el; ei vor purta tabernacolul și toate vasele lui; și vor servi în el și își vor așeza tabăra de jur împrejurul tabernacolului. ");
INSERT INTO ronbtf_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Și când tabernacolul pleacă, leviții să îl desfacă; și când tabernacolul trebuie așezat, leviții să îl așeze; și străinul care se apropie să fie dat morții. ");
INSERT INTO ronbtf_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Și copiii lui Israel să își așeze corturile, fiecare om după tabăra lui și fiecare om după steagul lui, prin toate oștirile lor. ");
INSERT INTO ronbtf_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Dar leviții să își așeze corturile de jur împrejurul tabernacolului mărturiei, ca să nu fie furie peste adunarea copiilor lui Israel; și leviții vor păstra însărcinarea tabernacolului mărturiei. ");
INSERT INTO ronbtf_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Și copiii lui Israel au făcut conform cu tot ceea ce DOMNUL i-a poruncit lui Moise, astfel au făcut ei. ");
INSERT INTO ronbtf_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Și DOMNUL i-a vorbit lui Moise și lui Aaron, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Fiecare bărbat dintre copiii lui Israel să își așeze cortul lângă propriul steag cu însemnul casei părinților lor, departe, în jurul tabernacolului întâlnirii să își așeze corturile. ");
INSERT INTO ronbtf_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Și pe partea de est spre răsăritul soarelui să își așeze corturile cei ai steagului taberei lui Iuda după toate oștirile lor și Nahșon, fiul lui Aminadab, să fie căpetenia copiilor lui Iuda. ");
INSERT INTO ronbtf_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Și oștirea lui și cei numărați dintre ei, au fost șaptezeci și patru de mii șase sute. ");
INSERT INTO ronbtf_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Și cei care își așază corturile lângă el să fie tribul lui Isahar și Nataniel, fiul lui Țuar, să fie căpetenia copiilor lui Isahar. ");
INSERT INTO ronbtf_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Și oștirea lui și cei care au fost numărați dintre ei, au fost cincizeci și patru de mii patru sute. ");
INSERT INTO ronbtf_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Apoi tribul lui Zabulon și Eliab, fiul lui Helon, să fie căpetenia copiilor lui Zabulon. ");
INSERT INTO ronbtf_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Și oștirea lui și cei numărați dintre ei, au fost cincizeci și șapte de mii patru sute. ");
INSERT INTO ronbtf_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Toți cei numărați în toate oștirile lor în tabăra lui Iuda au fost o sută optzeci și șase de mii patru sute. Aceștia să plece întâi. ");
INSERT INTO ronbtf_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Pe partea de sud să fie steagul taberei lui Ruben conform cu oștirile lor și căpetenia copiilor lui Ruben să fie Elițur, fiul lui Ședeur. ");
INSERT INTO ronbtf_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Și oștirea lui și cei numărați dintre ei, au fost patruzeci și șase de mii cinci sute. ");
INSERT INTO ronbtf_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Și cei ce își așază corturile lângă el să fie tribul lui Simeon și căpetenia copiilor lui Simeon să fie Șelumiel, fiul lui Țurișadai. ");
INSERT INTO ronbtf_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Și oștirea lui și cei numărați dintre ei, au fost cincizeci și nouă de mii trei sute. ");
INSERT INTO ronbtf_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Apoi tribul lui Gad și căpetenia fiilor lui Gad să fie Eliasaf, fiul lui Reuel. ");
INSERT INTO ronbtf_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Și oștirea lui și cei numărați dintre ei, au fost patruzeci și cinci de mii șase sute cincizeci. ");
INSERT INTO ronbtf_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Toți cei numărați în toate oștirile lor, în tabăra lui Ruben, au fost o sută cincizeci și una de mii patru sute cincizeci. Și ei să plece în al doilea rând. ");
INSERT INTO ronbtf_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Apoi tabernacolul întâlnirii să plece cu tabăra leviților în mijlocul taberei, după cum ei își așază tabăra, astfel să plece, fiecare bărbat la locul lui după steagurile lor. ");
INSERT INTO ronbtf_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Pe partea de vest să fie steagul taberei lui Efraim conform cu oștirile lor și căpetenia fiilor lui Efraim să fie Elișama, fiul lui Amihud. ");
INSERT INTO ronbtf_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Și oștirea lui și cei numărați dintre ei, au fost patruzeci de mii cinci sute. ");
INSERT INTO ronbtf_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Și lângă el să fie tribul lui Manase și căpetenia copiilor lui Manase să fie Gamaliel, fiul lui Pedahțur. ");
INSERT INTO ronbtf_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Și oștirea lui și cei numărați dintre ei, au fost treizeci și două de mii două sute. ");
INSERT INTO ronbtf_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Apoi tribul lui Beniamin și căpetenia fiilor lui Beniamin să fie Abidan, fiul lui Ghideoni. ");
INSERT INTO ronbtf_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Și oștirea lui și cei numărați dintre ei, au fost treizeci și cinci de mii patru sute. ");
INSERT INTO ronbtf_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Toți cei numărați în toate oștirile lor din tabăra lui Efraim au fost o sută opt mii o sută. Și ei să plece în al treilea rând. ");
INSERT INTO ronbtf_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Steagul taberei lui Dan să fie pe partea de nord după oștirile lor și căpetenia copiilor lui Dan să fie Ahiezer, fiul lui Amișadai. ");
INSERT INTO ronbtf_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Și oștirea lui și cei numărați dintre ei, au fost șaizeci și două de mii șapte sute. ");
INSERT INTO ronbtf_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Și cei care își așază tabăra lângă el să fie tribul lui Așer și căpetenia copiilor lui Așer să fie Paghiel, fiul lui Ocran. ");
INSERT INTO ronbtf_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Și oștirea lui și cei numărați dintre ei, au fost patruzeci și una de mii cinci sute. ");
INSERT INTO ronbtf_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Apoi tribul lui Neftali și căpetenia copiilor lui Neftali să fie Ahira, fiul lui Enan. ");
INSERT INTO ronbtf_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Și oștirea lui și cei numărați dintre ei, au fost cincizeci și trei de mii patru sute. ");
INSERT INTO ronbtf_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Toți cei numărați în tabăra lui Dan au fost o sută cincizeci și șapte de mii șase sute. Ei să plece în partea din spate cu steagurile lor. ");
INSERT INTO ronbtf_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Aceștia sunt cei numărați dintre copiii lui Israel după casa părinților lor, toți cei care au fost numărați din tabere cu toate oștirile lor au fost șase sute trei mii cinci sute cincizeci. ");
INSERT INTO ronbtf_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Dar leviții nu au fost numărați printre copiii lui Israel; precum DOMNUL i-a poruncit lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Și copiii lui Israel au făcut conform cu tot ceea ce DOMNUL i-a poruncit lui Moise, astfel și-au așezat corturile lângă steagurile lor și astfel au plecat înainte, fiecare după familiile lor, conform cu casa părinților lor. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Acestea sunt de asemenea generațiile lui Aaron și Moise în ziua în care DOMNUL a vorbit cu Moise pe muntele Sinai. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Și acestea sunt numele fiilor lui Aaron, Nadab întâiul născut și Abihu, Eleazar și Itamar. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Acestea sunt numele fiilor lui Aaron, preoții care au fost unși, pe care el i-a consacrat să servească în serviciul de preot. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Și Nadab și Abihu au murit înaintea DOMNULUI, când au oferit foc străin înaintea DOMNULUI, în pustiul Sinai și nu au avut copii și Eleazar și Itamar au servit în serviciul de preot înaintea ochilor tatălui lor Aaron. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Apropie tribul lui Levi și prezintă-i înaintea lui Aaron preotul, ca ei să îi servească. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Și ei să păzească însărcinarea lui și însărcinarea întregii adunări înaintea tabernacolului întâlnirii, pentru a face serviciul tabernacolului. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Și ei să păzească toate uneltele tabernacolului întâlnirii și însărcinarea copiilor lui Israel, pentru a face serviciul tabernacolului. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Și să dai pe leviți lui Aaron și fiilor săi, ei îi sunt dați în întregime dintre copiii lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Și să rânduiești pe Aaron și pe fiii săi, iar ei să servească în serviciul lor preoțesc și străinul care se apropie să fie dat morții. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","Și eu, iată, am luat pe leviți dintre copiii lui Israel în locul tuturor întâilor născuți care deschid pântecele printre copiii lui Israel; de aceea leviții să fie ai mei; ");
INSERT INTO ronbtf_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Deoarece toți întâii născuți sunt ai mei, pentru că în ziua în care am lovit pe toți întâii născuți în țara Egiptului mi-am sfințit pe toți întâii născuți în Israel, deopotrivă om și animal; ai mei vor fi: Eu sunt DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Și DOMNUL i-a vorbit lui Moise în pustiul Sinai, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Numără copiii lui Levi după casa părinților lor, după familiile lor, să îi numeri fiecare parte bărbătească de la vârsta de o lună în sus. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Și Moise i-a numărat conform cu cuvântul DOMNULUI, precum i s-a poruncit. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Și aceștia au fost fiii lui Levi după numele lor, Gherșon și Chehat și Merari. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Și acestea sunt numele fiilor lui Gherșon după familiile lor, Libni și Șimei. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Și fiii lui Chehat după familiile lor: Amram și Ițehar, Hebron și Uziel. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Și fiii lui Merari după familiile lor, Mahli și Muși. Acestea sunt familiile leviților conform cu casa părinților lor. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Din Gherșon a fost familia libniților și familia șimiților, acestea sunt familiile gherșoniților. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Cei numărați dintre ei, conform cu numărul tuturor celor de parte bărbătească, de la vârsta de o lună în sus, cei numărați dintre ei au fost șapte mii cinci sute. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Familiile gherșoniților să își așeze corturile în spatele tabernacolului spre vest. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Și mai marele casei tatălui gherșoniților să fie Eliasaf, fiul lui Lael. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Și însărcinarea fiilor lui Gherșon în tabernacolul întâlnirii să fie tabernacolul și cortul, acoperământul lui și perdeaua pentru ușa tabernacolului întâlnirii, ");
INSERT INTO ronbtf_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","Și perdelele curții și covorul pentru ușa curții, care este lângă tabernacol și lângă altar de jur împrejur și frânghiile acestuia pentru tot serviciul lui. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Și din Chehat a fost familia amramiților și familia ițehariților și familia hebroniților și familia uzieliților, acestea sunt familiile chehatiților. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","În numărul tuturor celor de parte bărbătească de la vârsta de o lună în sus, au fost opt mii șase sute, având însărcinarea sanctuarului. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Familiile fiilor lui Chehat să își așeze corturile în partea de sud a tabernacolului. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Și mai marele casei tatălui familiilor chehatiților să fie Elițafan, fiul lui Uziel. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Și însărcinarea lor să fie chivotul și masa și sfeșnicul și altarele și vasele sanctuarului cu care ei servesc și perdeaua și tot serviciul lor. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Și Eleazar, fiul preotului Aaron, să fie mai marele peste mai marele leviților și să aibă supravegherea celor ce păstrează însărcinarea sanctuarului. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Din Merari a fost familia mahliților și familia mușiților, acestea sunt familiile lui Merari. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Și cei numărați dintre ei, conform cu numărul tuturor celor de parte bărbătească de la vârsta de o lună în sus, au fost șase mii două sute. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Și mai marele casei tatălui familiilor lui Merari a fost Țuriel, fiul lui Abihail, aceștia să își așeze corturile în partea de nord a tabernacolului. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Și sub custodia și însărcinarea fiilor lui Merari să fie scândurile tabernacolului și drugii lui și stâlpii lui și soclurile lor și toate vasele lui și tot ce servește acolo, ");
INSERT INTO ronbtf_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Și stâlpii curții de jur împrejur și soclurile lor și țărușii lor și frânghiile lor. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Dar cei ce își așază tabăra înaintea tabernacolului spre est, înaintea tabernacolului întâlnirii spre est, să fie Moise și Aaron și fiii săi, având însărcinarea sanctuarului ca sarcină a copiilor lui Israel; și străinul care se apropie să fie dat morții. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Toți cei numărați dintre leviți, pe care Moise și Aaron i-au numărat la porunca DOMNULUI, prin toate familiile lor, toți cei de parte bărbătească în vârstă de la o lună în sus, au fost douăzeci și două de mii. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Și DOMNUL i-a spus lui Moise: Numără pe toți întâii născuți din cei de parte bărbătească dintre copiii lui Israel de la vârsta de o lună în sus și ia numărul numelor lor. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Și să iei pe leviți pentru mine (eu sunt DOMNUL) în locul tuturor întâilor născuți ai copiilor lui Israel; și vitele leviților în locul întâilor pui născuți ai vitelor copiilor lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Și Moise a numărat precum DOMNUL i-a poruncit, pe toți întâii născuți dintre copiii lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Și toți întâii născuți de parte bărbătească după numărul numelor, de la vârsta de o lună în sus, dintre cei care au fost numărați dintre ei, erau douăzeci și două de mii două sute șaptezeci și trei. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","Ia pe leviți în locul tuturor întâilor născuți ai copiilor lui Israel și vitele leviților în locul vitelor acelora; și leviții să fie ai mei: Eu sunt DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Și pentru cei care trebuie răscumpărați, cei două sute șaptezeci și trei dintre întâii născuți ai copiilor lui Israel, care sunt mai mulți decât leviții, ");
INSERT INTO ronbtf_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Să iei cinci șekeli de fiecare cap; după șekelul sanctuarului să îi iei (șekelul are douăzeci de ghere), ");
INSERT INTO ronbtf_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Și să dai banii, cu care trebuie răscumpărat numărul celor în plus, lui Aaron și fiilor săi. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Și Moise a luat banii de răscumpărare de la cei care depășeau numărul celor răscumpărați de leviți, ");
INSERT INTO ronbtf_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","De la întâii născuți ai copiilor lui Israel a luat banii; o mie trei sute șaizeci și cinci de șekeli, după șekelul sanctuarului. ");
INSERT INTO ronbtf_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Și Moise a dat banii de la cei ce fuseseră răscumpărați, lui Aaron și fiilor săi, conform cuvântului DOMNULUI, precum DOMNUL i-a poruncit lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Și DOMNUL i-a vorbit lui Moise și lui Aaron, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Fă numărătoarea fiilor lui Chehat dintre fiii lui Levi, după familiile lor, după casa părinților lor, ");
INSERT INTO ronbtf_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","De la vârsta de treizeci de ani în sus până la vârsta de cincizeci de ani, toți cei ce intră în oștire, să facă lucrarea în tabernacolul întâlnirii. ");
INSERT INTO ronbtf_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Acesta să fie serviciul fiilor lui Chehat în tabernacolul întâlnirii, referitor la lucrurile preasfinte, ");
INSERT INTO ronbtf_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Și când tabăra pleacă, Aaron și fiii săi să vină și să ia jos perdeaua acoperământului și să acopere chivotul mărturiei cu ea; ");
INSERT INTO ronbtf_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Și să pună acolo acoperământul din piei de bursuci și să întindă deasupra lui o pânză în întregime de albastru și să îi pună drugii. ");
INSERT INTO ronbtf_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Și peste masa pâinii punerii înainte să întindă o pânză din albastru și să pună pe ea farfuriile și lingurile și bolurile și capacele ei cu care să le acopere și pâinea cea neîncetată să fie pe ea; ");
INSERT INTO ronbtf_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Și să întindă peste ele o pânză de stacojiu și să o acopere cu un acoperământ din piei de bursuci și să îi pună drugii. ");
INSERT INTO ronbtf_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Și să ia o pânză de albastru și să acopere sfeșnicul luminii și lămpile lui și mucările lui și cenușarele lui și toate vasele lui de untdelemn, cu care ei îi servesc; ");
INSERT INTO ronbtf_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Și să îl pună pe acesta și toate vasele lui într-un acoperământ din piei de bursuci și să îl pună pe un drug. ");
INSERT INTO ronbtf_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Și peste altarul de aur să întindă o pânză de albastru și să o acopere cu un acoperământ din piei de bursuci și să îi pună drugii; ");
INSERT INTO ronbtf_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Și să ia toate uneltele serviciului, cu care ei servesc în sanctuar și să le pună într-o pânză de albastru și să le acopere cu un acoperământ din piei de bursuci și să le pună pe un drug; ");
INSERT INTO ronbtf_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Și să ia cenușa de pe altar și să întindă o pânză purpurie peste el; ");
INSERT INTO ronbtf_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Și să pună pe el toate vasele lui, cu care ei servesc în jurul lui, cenușarele, cârligele de carne, lopețile și oalele, toate vasele altarului; și să întindă peste acestea un acoperământ din piei de bursuci și să îi pună drugii. ");
INSERT INTO ronbtf_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Și după ce Aaron și fiii săi vor fi terminat cu acoperământul sanctuarului și a tuturor vaselor sanctuarului, pe când tabăra este gata să plece înainte; după aceea, fiii lui Chehat să vină să care acestea, dar ei să nu atingă niciun lucru sfânt, ca nu cumva să moară. Aceste lucruri sunt sarcina fiilor lui Chehat în tabernacolul întâlnirii. ");
INSERT INTO ronbtf_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Și serviciului lui Eleazar, fiul preotului Aaron, îi aparține untdelemnul pentru lumină și tămâia dulce și darul de mâncare zilnic și untdelemnul ungerii și supravegherea întregului tabernacol și a tot ce este în el, în sanctuar și în vasele lui. ");
INSERT INTO ronbtf_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Și DOMNUL i-a vorbit lui Moise și lui Aaron, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","Nu stârpiți tribul familiilor chehatiților dintre leviți; ");
INSERT INTO ronbtf_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Ci astfel să le faceți, ca ei să trăiască și să nu moară, când se apropie de lucrurile preasfinte, Aaron și fiii săi să intre și să rânduiască pe fiecare în serviciul lui și la sarcina lui. ");
INSERT INTO ronbtf_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Dar ei să nu intre să se uite când lucrurile preasfinte sunt acoperite, ca nu cumva să moară. ");
INSERT INTO ronbtf_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","Fă de asemenea numărătoarea fiilor lui Gherșon, prin toate casele părinților lor, după familiile lor; ");
INSERT INTO ronbtf_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","De la vârsta de treizeci de ani în sus până la vârsta de cincizeci de ani să îi numeri; pe toți cei ce intră ca să împlinească serviciul, ca să facă lucrarea în tabernacolul întâlnirii. ");
INSERT INTO ronbtf_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Acesta este serviciul familiilor gherșoniților, pentru a servi și pentru sarcini, ");
INSERT INTO ronbtf_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Și ei să care covoarele tabernacolului și tabernacolul întâlnirii, acoperământul său și acoperământul pieilor de bursuci care este deasupra acestuia și perdeaua pentru ușa tabernacolului întâlnirii, ");
INSERT INTO ronbtf_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","Și perdelele curții și perdeaua pentru ușa porții curții, care este lângă tabernacol și lângă altar de jur împrejur și frânghiile lor și toate uneltele serviciului lor și tot ce este făcut pentru ei, astfel să servească ei. ");
INSERT INTO ronbtf_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","La rânduirea lui Aaron și a fiilor săi să fie tot serviciul fiilor gherșoniților, în toate sarcinile lor și în tot serviciul lor și să numiți în grija lor toate însărcinările lor. ");
INSERT INTO ronbtf_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Acesta este serviciul familiilor fiilor lui Gherșon în tabernacolul întâlnirii și însărcinarea lor să fie sub mâna lui Itamar, fiul lui Aaron, preotul. ");
INSERT INTO ronbtf_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Cât despre fiii lui Merari, să îi numeri după familiile lor, după casa părinților lor. ");
INSERT INTO ronbtf_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","De la vârsta de treizeci de ani în sus până la vârsta de cincizeci de ani să îi numeri, pe fiecare bărbat care intră în serviciu, ca să facă lucrarea tabernacolului întâlnirii. ");
INSERT INTO ronbtf_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Și aceasta este datoria sarcinii lor, conform cu tot serviciul lor în tabernacolul întâlnirii, scândurile tabernacolului și drugii lor și stâlpii lor și soclurile lor. ");
INSERT INTO ronbtf_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","Și stâlpii curții de jur împrejur și soclurile lor și țărușii lor și frânghiile lor, cu toate uneltele lor și cu tot serviciul lor și după nume să numărați uneltele datoriei sarcinii lor. ");
INSERT INTO ronbtf_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Acesta este serviciul familiilor fiilor lui Merari, conform cu tot serviciul lor, în tabernacolul întâlnirii, sub mâna lui Itamar, fiul lui Aaron, preotul. ");
INSERT INTO ronbtf_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Și Moise și Aaron și mai marele adunării au numărat pe fiii chehatiților după familiile lor și după casa părinților lor, ");
INSERT INTO ronbtf_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","De la vârsta de treizeci de ani în sus până la vârsta de cincizeci de ani, fiecare bărbat care intră în serviciu, pentru lucrarea în tabernacolul întâlnirii; ");
INSERT INTO ronbtf_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Și cei numărați dintre ei după familiile lor erau două mii șapte sute cincizeci. ");
INSERT INTO ronbtf_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Aceștia au fost cei numărați din familiile chehatiților, toți cei ce pot face serviciul în tabernacolul întâlnirii, pe care Moise și Aaron i-au numărat conform poruncii DOMNULUI prin mâna lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Și cei numărați dintre fiii lui Gherșon, după toate familiile lor și după casa părinților lor, ");
INSERT INTO ronbtf_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","De la vârsta de treizeci de ani în sus până la vârsta de cincizeci de ani, fiecare bărbat care intră în serviciu, pentru lucrarea în tabernacolul întâlnirii, ");
INSERT INTO ronbtf_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Cei numărați dintre ei, după toate familiile lor, după casa părinților lor, au fost două mii șase sute treizeci. ");
INSERT INTO ronbtf_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Aceștia sunt cei numărați din familiile fiilor lui Gherșon, dintre toți cei ce pot face serviciul în tabernacolul întâlnirii, pe care Moise și Aaron i-au numărat conform poruncii DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Și cei numărați din familiile fiilor lui Merari, după toate familiile lor, după casa părinților lor, ");
INSERT INTO ronbtf_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","De la vârsta de treizeci de ani în sus până la vârsta de cincizeci de ani, fiecare bărbat care intră în serviciu, pentru lucrarea în tabernacolul întâlnirii, ");
INSERT INTO ronbtf_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Cei numărați dintre ei după familiile lor, erau trei mii două sute. ");
INSERT INTO ronbtf_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Aceștia sunt cei numărați din familiile fiilor lui Merari, pe care Moise și Aaron i-au numărat conform cuvântului DOMNULUI prin mâna lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Toți cei numărați dintre leviți, pe care Moise și Aaron și mai marele lui Israel i-au numărat, după familiile lor și după casa părinților lor, ");
INSERT INTO ronbtf_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","De la vârsta de treizeci de ani în sus până la vârsta de cincizeci de ani, fiecare bărbat care a venit să facă serviciul lucrării și serviciul sarcinii sale în tabernacolul întâlnirii, ");
INSERT INTO ronbtf_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","Și cei numărați dintre ei au fost opt mii cinci sute optzeci. ");
INSERT INTO ronbtf_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Conform cu porunca DOMNULUI au fost numărați prin mâna lui Moise, fiecare om conform serviciului său și conform sarcinii sale; astfel au fost numărați de el, precum DOMNUL i-a poruncit lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Și DOMNUL i-a vorbit lui Moise spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","Poruncește copiilor lui Israel, să scoată din tabără pe fiecare lepros și pe fiecare om care are o scurgere și pe oricine este pângărit cu mort, ");
INSERT INTO ronbtf_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Deopotrivă parte bărbătească și parte femeiască să îi scoateți afară, în afara taberei să îi scoateți pe aceștia; ca să nu pângărească taberele lor, în mijlocul cărora locuiesc eu. ");
INSERT INTO ronbtf_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Și copiii lui Israel au făcut astfel și i-au scos afară, în afara taberei, precum DOMNUL i-a vorbit lui Moise, astfel au făcut copiii lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Vorbește copiilor lui Israel: Când un bărbat sau o femeie va face orice păcat pe care oamenii îl fac, lucrând o fărădelege împotriva DOMNULUI și acea persoană este vinovată, ");
INSERT INTO ronbtf_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Atunci să își mărturisească păcatul pe care l-a făcut și să plătească pentru fărădelegea sa cu suma întreagă a acesteia și să adauge a cincea parte din ea și să o dea celui împotriva căruia a încălcat. ");
INSERT INTO ronbtf_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Dar dacă bărbatul nu are nicio rudă căruia să îi plătească fărădelegea, să fie plătită DOMNULUI fărădelegea, adică preotului; pe lângă berbecul ispășirii, prin care se va face ispășire pentru el. ");
INSERT INTO ronbtf_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Și fiecare ofrandă din toate lucrurile sfinte ale copiilor lui Israel, pe care ei le aduc preotului, să fie ale lui. ");
INSERT INTO ronbtf_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Și lucrurile sfințite ale fiecărui om să fie ale lui, orice dă vreun bărbat preotului să fie al lui. ");
INSERT INTO ronbtf_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","Vorbește copiilor lui Israel și spune-le: Dacă soția unui bărbat se abate și face fărădelege împotriva lui, ");
INSERT INTO ronbtf_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","Și dacă un bărbat se culcă cu ea carnal și acest lucru este ascuns de ochii soțului ei și este ținut ascuns și ea este pângărită și nu este niciun martor împotriva ei, nici nu a fost prinsă; ");
INSERT INTO ronbtf_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","Și duhul geloziei vine asupra lui și este gelos pe soția sa și ea este pângărită; sau dacă duhul geloziei vine asupra lui și el este gelos pe soția sa iar ea nu este pângărită, ");
INSERT INTO ronbtf_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","Atunci bărbatul să aducă pe soția sa la preot și să aducă darul ei pentru ea, a zecea parte dintr-o efă de făină de orz; să nu pună untdelemn peste el, nici tămâie să nu pună peste el, pentru că este o ofrandă de gelozie, o ofrandă de amintire, aducând nelegiuirea în amintire. ");
INSERT INTO ronbtf_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Și preotul să o apropie și să o pună înaintea DOMNULUI; ");
INSERT INTO ronbtf_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Și preotul să ia apă sfântă într-un vas de pământ; și din pulberea care este pe podeaua tabernacolului preotul să ia și să o pună în apă; ");
INSERT INTO ronbtf_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Și preotul să pună femeia înaintea DOMNULUI și să descopere capul femeii și să pună ofranda de amintire în mâinile ei, care este ofranda de gelozie și preotul să aibă în mâna sa apa amară care provoacă blestemul, ");
INSERT INTO ronbtf_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Și preotul să îi poruncească printr-un jurământ și să spună femeii: Dacă niciun bărbat nu s-a culcat cu tine și dacă nu te-ai abătut spre necurăție cu un altul în locul soțului tău, să fii liberă de această apă amară care provoacă blestemul; ");
INSERT INTO ronbtf_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Dar dacă te-ai abătut la un altul în locul soțului tău și dacă te-ai pângărit și vreun bărbat s-a culcat cu tine în afară de soțul tău; ");
INSERT INTO ronbtf_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","Atunci preotul să poruncească femeii cu un jurământ de blestem și preotul să spună femeii: DOMNUL să te facă un blestem și un jurământ în mijlocul poporului tău, când DOMNUL va face coapsa ta să putrezească și pântecele tău să se umfle. ");
INSERT INTO ronbtf_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Și această apă care provoacă blestemul să intre în măruntaiele tale, ca să umfle pântecele tău și coapsa ta să putrezească și femeia să spună: Amin, Amin. ");
INSERT INTO ronbtf_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Și preotul să scrie aceste blesteme într-o carte și să le șteargă cu apa amară. ");
INSERT INTO ronbtf_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Și să facă pe femeie să bea apa amară care provoacă blestemul și apa care provoacă blestemul să intre în ea și va deveni amară. ");
INSERT INTO ronbtf_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Apoi preotul să ia ofranda de gelozie din mâna femeii și să legene ofranda înaintea DOMNULUI și să o ofere pe altar; ");
INSERT INTO ronbtf_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Și preotul să ia o mână plină din ofrandă, din amintirea acesteia și să o ardă pe altar și după aceea să facă pe femeie să bea apa. ");
INSERT INTO ronbtf_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Și după ce a făcut-o să bea apa, atunci se va întâmpla că, dacă s-a pângărit și a făcut fărădelege împotriva soțului ei, apa care provoacă blestemul să intre în ea și va deveni amară și pântecele ei se va umfla și coapsa ei va putrezi și femeia va fi un blestem în mijlocul poporului ei. ");
INSERT INTO ronbtf_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Dar dacă femeia nu s-a pângărit, ci este curată, atunci ea să fie liberă și să conceapă sămânță. ");
INSERT INTO ronbtf_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Aceasta este legea geloziilor, când o soție se abate la altul în locul soțului ei și se pângărește; ");
INSERT INTO ronbtf_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","Sau când duhul de gelozie vine asupra lui și este gelos pe soția sa și o pune pe femeie înaintea DOMNULUI și preotul să îi facă după toată această lege. ");
INSERT INTO ronbtf_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Atunci bărbatul să fie nevinovat de nelegiuire și această femeie să poarte nelegiuirea ei. ");
INSERT INTO ronbtf_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Vorbește copiilor lui Israel și spune-le: Când, fie un bărbat, fie o femeie, se vor separa ca să facă o promisiune de nazireu, să se separe DOMNULUI, ");
INSERT INTO ronbtf_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","El să se separe de vin și băutură tare și să nu bea deloc oțet din vin, sau oțet din băutură tare, nici să nu bea vreo licoare din struguri, nici să nu mănânce struguri proaspeți sau uscați. ");
INSERT INTO ronbtf_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","În toate zilele separării sale să nu mănânce nimic din ceea ce este făcut din vița de vie, de la sâmburi până la pieliță. ");
INSERT INTO ronbtf_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","În toate zilele promisiunii lui de separare, briciul să nu treacă peste capul lui, până ce se vor împlini zilele, în care el s-a separat pentru DOMNUL, va fi sfânt și să lase șuvițele părului capului său să crească. ");
INSERT INTO ronbtf_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","În toate zilele cât este el separat pentru DOMNUL, să nu vină la niciun trup mort. ");
INSERT INTO ronbtf_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","El să nu se facă necurat nici pentru tatăl său, nici pentru mama sa, nici pentru fratele său, nici pentru sora sa, când ei mor, deoarece consacrarea Dumnezeului său este asupra capului său. ");
INSERT INTO ronbtf_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","În toate zilele separării sale el este sfânt pentru DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Și dacă vreun om moare dintr-odată lângă el, iar el și-a pângărit capul consacrării sale, atunci să își radă capul în ziua curățirii sale; în ziua a șaptea să și-l radă. ");
INSERT INTO ronbtf_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Și în ziua a opta să aducă două turturele, sau doi porumbei tineri, la preot, la ușa tabernacolului întâlnirii; ");
INSERT INTO ronbtf_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Și preotul să ofere pe una ca ofrandă pentru păcat și pe cealaltă ca ofrandă arsă și să facă ispășire pentru el, pentru că a păcătuit prin mort și capul să și-l sfințească în aceeași zi. ");
INSERT INTO ronbtf_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Și să consacre DOMNULUI zilele separării sale și să aducă un miel de un an ca ofrandă pentru fărădelege, dar zilele care au fost mai înainte vor fi pierdute, deoarece separarea lui a fost pângărită. ");
INSERT INTO ronbtf_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Și aceasta este legea nazireului, când zilele separării sale vor fi împlinite, să fie adus la ușa tabernacolului întâlnirii, ");
INSERT INTO ronbtf_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Și să aducă darul său DOMNULUI, un miel de un an, fără cusur, ca ofrandă arsă și o mielușea de un an, fără cusur, ca ofrandă pentru păcat, și un berbec, fără cusur, ca ofrande de pace. ");
INSERT INTO ronbtf_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Și un coș de azime, turte din floarea făinii, amestecate cu untdelemn, și lipii din azime, unse cu untdelemn, și darul lor de mâncare și darurile lor de băutură. ");
INSERT INTO ronbtf_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Și preotul să le aducă înaintea DOMNULUI și să aducă ofranda lui pentru păcat și ofranda lui arsă. ");
INSERT INTO ronbtf_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Și să aducă DOMNULUI berbecul ca sacrificiu al ofrandelor de pace, cu coșul de azime; preotul să aducă de asemenea și darul lui de mâncare și darul lui de băutură. ");
INSERT INTO ronbtf_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Și nazireul să își radă capul separării sale la ușa tabernacolului întâlnirii și să ia părul de pe capul separării sale și să îl pună în focul care este sub sacrificiul ofrandelor de pace. ");
INSERT INTO ronbtf_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Și preotul să ia spata fiartă a berbecului și o turtă nedospită din coș și o lipie nedospită și să le pună pe mâinile nazireului, după ce părul separării sale a fost ras. ");
INSERT INTO ronbtf_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Și preotul să le legene ca ofrandă legănată înaintea DOMNULUI, acesta este sfânt pentru preot, cu pieptul legănat și cu spata săltată și după aceea nazireul poate bea vin. ");
INSERT INTO ronbtf_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Aceasta este legea nazireului, care a jurat, și a darului său către DOMNUL, pentru separarea sa, în afară de ceea ce îi va da mâna, conform cu jurământul, pe care l-a jurat, astfel trebuie să facă după legea separării sale. ");
INSERT INTO ronbtf_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Vorbește lui Aaron și fiilor săi, spunând: Astfel să binecuvântați pe copiii lui Israel, spunându-le: ");
INSERT INTO ronbtf_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","DOMNUL să te binecuvânteze și să te țină; ");
INSERT INTO ronbtf_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Să facă DOMNUL să strălucească fața sa peste tine și să aibă har fața de tine; ");
INSERT INTO ronbtf_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Să înalțe DOMNUL înfățișarea sa peste tine și să îți dea pacea. ");
INSERT INTO ronbtf_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Și ei să pună numele meu peste copiii lui Israel, iar eu îi voi binecuvânta. ");
INSERT INTO ronbtf_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Și s-a întâmplat în ziua în care Moise a ridicat în întregime tabernacolul și l-a uns și l-a sfințit pe el și toate uneltele lui, deopotrivă altarul și toate vasele acestuia și le-a uns și le-a sfințit; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Că prinții lui Israel, căpeteniile caselor părinților lor, care erau prinții triburilor și erau peste cei care au fost numărați, au oferit, ");
INSERT INTO ronbtf_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Și au adus darul lor înaintea DOMNULUI, șase care acoperite și doisprezece boi; un car pentru doi dintre prinți și pentru fiecare dintre ei un bou și i-au adus înaintea tabernacolului. ");
INSERT INTO ronbtf_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","Ia-le de la ei, ca să poată fi făcut serviciul tabernacolului întâlnirii; și să le dai leviților, fiecărui bărbat conform serviciului său. ");
INSERT INTO ronbtf_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Și Moise a luat carele și boii și le-a dat leviților. ");
INSERT INTO ronbtf_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Două care și patru boi le-a dat fiilor lui Gherșon, conform serviciului lor; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Și patru care și opt boi le-a dat fiilor lui Merari, conform serviciului lor, sub mâna lui Itamar, fiul lui Aaron, preotul. ");
INSERT INTO ronbtf_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Dar fiilor lui Chehat nu le-a dat nimic, deoarece serviciul sanctuarului ce le aparținea era ca ei să care pe umerii lor. ");
INSERT INTO ronbtf_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Și prinții au adus ofrande pentru dedicarea altarului în ziua în care a fost uns, prinții au adus darul lor înaintea altarului. ");
INSERT INTO ronbtf_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Și DOMNUL i-a spus lui Moise: Să aducă darul lor, fiecare prinț în ziua lui, pentru dedicarea altarului. ");
INSERT INTO ronbtf_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Și cel ce a adus darul său în prima zi a fost Nahșon, fiul lui Aminadab, din tribul lui Iuda. ");
INSERT INTO ronbtf_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Și darul său a fost un platou de argint, greutatea lui era de o sută treizeci de șekeli, un bol de argint de șaptezeci de șekeli, după șekelul sanctuarului; amândouă erau pline de floarea făinii amestecată cu untdelemn, ca dar de mâncare; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","O lingură din aur, de zece șekeli, plină cu tămâie; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","Un taur tânăr, un berbec, un miel de un an, ca ofrandă arsă; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","Un ied dintre capre ca ofrandă pentru păcat; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","Și ca sacrificiu al ofrandelor de pace, doi boi, cinci berbeci, cinci țapi, cinci miei de un an, acesta a fost darul lui Nahșon, fiul lui Aminadab. ");
INSERT INTO ronbtf_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","În a doua zi a oferit Nataneel, fiul lui Țuar, prințul lui Isahar. ");
INSERT INTO ronbtf_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","A adus ca dar al său, un platou din argint, greutatea lui era de o sută treizeci de șekeli, un bol de argint de șaptezeci de șekeli, după șekelul sanctuarului; amândouă pline cu floarea făinii amestecată cu untdelemn, ca dar de mâncare; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","O lingură din aur, de zece șekeli, plină de tămâie; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","Un taur tânăr, un berbec, un miel de un an ca ofrandă arsă; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","Un ied dintre capre ca ofrandă pentru păcat; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","Și ca sacrificiu al ofrandelor de pace, doi boi, cinci berbeci, cinci țapi, cinci miei de un an, acesta a fost darul lui Nataneel, fiul lui Țuar. ");
INSERT INTO ronbtf_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","În ziua a treia a oferit Eliab, fiul lui Helon, prințul copiilor lui Zabulon. ");
INSERT INTO ronbtf_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Darul său a fost un platou din argint, greutatea lui era de o sută treizeci de șekeli, un bol de argint de șaptezeci de șekeli, după șekelul sanctuarului; amândouă pline cu floarea făinii amestecată cu untdelemn, ca dar de mâncare; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","O lingură din aur, de zece șekeli, plină de tămâie; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","Un taur tânăr, un berbec, un miel de un an, ca ofrandă arsă; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","Un ied dintre capre ca ofrandă pentru păcat; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","Și ca sacrificiu al ofrandelor de pace, doi boi, cinci berbeci, cinci țapi, cinci miei de un an, acesta a fost darul lui Eliab, fiul lui Helon. ");
INSERT INTO ronbtf_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","În ziua a patra a oferit Elițur, fiul lui Ședeur, prințul copiilor lui Ruben. ");
INSERT INTO ronbtf_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Darul său a fost un platou din argint în greutatea de o sută treizeci de șekeli, un bol de argint de șaptezeci de șekeli, după șekelul sanctuarului; amândouă pline cu floarea făinii amestecată cu untdelemn, ca dar de mâncare; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","O lingură din aur, de zece șekeli, plină de tămâie; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","Un taur tânăr, un berbec, un miel de un an ca ofrandă arsă; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","Un ied dintre capre ca ofrandă pentru păcat; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","Și ca sacrificiu al ofrandelor de pace, doi boi, cinci berbeci, cinci țapi, cinci miei de un an, acesta a fost darul lui Elițur, fiul lui Ședeur. ");
INSERT INTO ronbtf_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","În ziua a cincea a oferit Șelumiel, fiul lui Țurișadai, prințul copiilor lui Simeon. ");
INSERT INTO ronbtf_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Darul său a fost un platou din argint, greutatea lui era de o sută treizeci de șekeli, un bol de argint de șaptezeci de șekeli, după șekelul sanctuarului; amândouă pline cu floarea făinii amestecată cu untdelemn, ca dar de mâncare; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","O lingură din aur, de zece șekeli, plină de tămâie; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","Un taur tânăr, un berbec, un miel de un an ca ofrandă arsă; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","Un ied dintre capre ca ofrandă pentru păcat; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","Și ca sacrificiu al ofrandelor de pace, doi boi, cinci berbeci, cinci țapi, cinci miei de un an, acesta a fost darul lui Șelumiel, fiul lui Țurișadai. ");
INSERT INTO ronbtf_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","În ziua a șasea a oferit Eliasaf, fiul lui Deuel, prințul copiilor lui Gad. ");
INSERT INTO ronbtf_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Darul său a fost un platou din argint în greutatea de o sută treizeci de șekeli, un bol de argint de șaptezeci de șekeli, după șekelul sanctuarului; amândouă pline cu floarea făinii amestecată cu untdelemn, ca dar de mâncare; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","O lingură din aur, de zece șekeli, plină de tămâie; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","Un taur tânăr, un berbec, un miel de un an ca ofrandă arsă; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","Un ied dintre capre ca ofrandă pentru păcat; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","Și ca sacrificiu al ofrandelor de pace, doi boi, cinci berbeci, cinci țapi, cinci miei de un an, acesta a fost darul lui Eliasaf, fiul lui Deuel. ");
INSERT INTO ronbtf_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","În ziua a șaptea a oferit Elișama, fiul lui Amihud, prințul copiilor lui Efraim. ");
INSERT INTO ronbtf_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Darul său a fost un platou din argint, greutatea lui era de o sută treizeci de șekeli, un bol de argint de șaptezeci de șekeli, după șekelul sanctuarului; amândouă pline cu floarea făinii amestecată cu untdelemn, ca dar de mâncare; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","O lingură din aur, de zece șekeli, plină de tămâie; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","Un taur tânăr, un berbec, un miel de un an ca ofrandă arsă; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","Un ied dintre capre ca ofrandă pentru păcat; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","Și ca sacrificiu al ofrandelor de pace, doi boi, cinci berbeci, cinci țapi, cinci miei de un an, acesta a fost darul lui Elișama, fiul lui Amihud. ");
INSERT INTO ronbtf_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","În ziua a opta a oferit Gamaliel, fiul lui Pedahțur, prințul copiilor lui Manase. ");
INSERT INTO ronbtf_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Darul său a fost un platou din argint, în greutatea de o sută treizeci de șekeli, un bol de argint de șaptezeci de șekeli, după șekelul sanctuarului; amândouă pline cu floarea făinii amestecată cu untdelemn, ca dar de mâncare; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","O lingură din aur de zece șekeli, plină de tămâie; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","Un taur tânăr, un berbec, un miel de un an ca ofrandă arsă; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","Un ied dintre capre ca ofrandă pentru păcat; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","Și ca sacrificiu al ofrandelor de pace, doi boi, cinci berbeci, cinci țapi, cinci miei de un an, acesta a fost darul lui Gamaliel, fiul lui Pedahțur. ");
INSERT INTO ronbtf_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","În ziua a noua a oferit Abidan, fiul lui Ghideoni, prințul copiilor lui Beniamin. ");
INSERT INTO ronbtf_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Darul său a fost un platou din argint, greutatea lui era de o sută treizeci de șekeli, un bol de argint de șaptezeci de șekeli, după șekelul sanctuarului; amândouă pline cu floarea făinii amestecată cu untdelemn, ca dar de mâncare; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","O lingură din aur, de zece șekeli, plină de tămâie; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","Un taur tânăr, un berbec, un miel de un an ca ofrandă arsă; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","Un ied dintre capre ca ofrandă pentru păcat; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","Și ca sacrificiu al ofrandelor de pace, doi boi, cinci berbeci, cinci țapi, cinci miei de un an, acesta a fost darul lui Abidan, fiul lui Ghideoni. ");
INSERT INTO ronbtf_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","În ziua a zecea a oferit Ahiezer, fiul lui Amișadai, prințul copiilor lui Dan. ");
INSERT INTO ronbtf_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Darul său a fost un platou din argint, greutatea lui era de o sută treizeci de șekeli, un bol de argint de șaptezeci de șekeli, după șekelul sanctuarului; amândouă pline cu floarea făinii amestecată cu untdelemn, ca dar de mâncare; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","O lingură din aur, de zece șekeli, plină de tămâie; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","Un taur tânăr, un berbec, un miel de un an ca ofrandă arsă; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","Un ied dintre capre ca ofrandă pentru păcat; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","Și ca sacrificiu al ofrandelor de pace, doi boi, cinci berbeci, cinci țapi, cinci miei de un an, acesta a fost darul lui Ahiezer, fiul lui Amișadai. ");
INSERT INTO ronbtf_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","În ziua a unsprezecea a oferit Paghiel, fiul lui Ocran, prințul copiilor lui Așer. ");
INSERT INTO ronbtf_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Darul său a fost un platou din argint, greutatea lui era de o sută treizeci de șekeli, un bol de argint de șaptezeci de șekeli, după șekelul sanctuarului; amândouă pline cu floarea făinii amestecată cu untdelemn, ca dar de mâncare; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","O lingură din aur, de zece șekeli, plină de tămâie; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","Un taur tânăr, un berbec, un miel de un an ca ofrandă arsă; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","Un ied dintre capre ca ofrandă pentru păcat; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","Și ca sacrificiu al ofrandelor de pace, doi boi, cinci berbeci, cinci țapi, cinci miei de un an, acesta a fost darul lui Paghiel, fiul lui Ocran. ");
INSERT INTO ronbtf_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","În ziua a douăsprezecea a oferit Ahira, fiul lui Enan, prințul copiilor lui Neftali. ");
INSERT INTO ronbtf_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Darul său a fost un platou din argint, greutatea lui era de o sută treizeci de șekeli, un bol de argint de șaptezeci de șekeli, după șekelul sanctuarului; amândouă pline cu floarea făinii amestecată cu untdelemn, ca dar de mâncare; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","O lingură din aur, de zece șekeli, plină de tămâie; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","Un taur tânăr, un berbec, un miel de un an ca ofrandă arsă; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","Un ied dintre capre ca ofrandă pentru păcat; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","Și ca sacrificiu al ofrandelor de pace, doi boi, cinci berbeci, cinci țapi, cinci miei de un an, acesta a fost darul lui Ahira, fiul lui Enan. ");
INSERT INTO ronbtf_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Aceasta a fost dedicarea altarului, în ziua când a fost uns, de prinții lui Israel, douăsprezece platouri de argint, douăsprezece boluri de argint, douăsprezece linguri de aur; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Fiecare platou din argint cântărind o sută treizeci de șekeli, fiecare bol șaptezeci, toate vasele din argint cântăreau două mii patru sute de șekeli, după șekelul sanctuarului; ");
INSERT INTO ronbtf_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Lingurile din aur erau douăsprezece, pline cu tămâie, cântărind zece șekeli o bucată, după șekelul sanctuarului; tot aurul lingurilor era o sută douăzeci de șekeli. ");
INSERT INTO ronbtf_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Toate vitele pentru ofranda arsă erau, doisprezece tauri, doisprezece berbeci, doisprezece miei de un an, împreună cu darul lor de mâncare; și doisprezece iezi dintre capre pentru ofranda pentru păcat. ");
INSERT INTO ronbtf_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Și toate vitele pentru sacrificiul ofrandelor de pace erau, douăzeci și patru de tauri, șaizeci de berbeci, șaizeci de țapi, șaizeci de miei de un an. Aceasta a fost dedicarea altarului, după ce a fost uns. ");
INSERT INTO ronbtf_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Și când a intrat Moise în tabernacolul întâlnirii, ca să îi vorbească, a auzit vocea unuia vorbind de pe șezământul milei care era pe chivotul mărturiei dintre cei doi heruvimi și vorbea cu el. ");
INSERT INTO ronbtf_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","Vorbește lui Aaron și spune-i: Când aprinzi lămpile, cele șapte lămpi să dea lumină în fața sfeșnicului. ");
INSERT INTO ronbtf_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Și Aaron a făcut astfel; a aprins lămpile în fața sfeșnicului, precum DOMNUL i-a poruncit lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Și această lucrare a sfeșnicului era din aur bătut, până la stâlpul lui, până la florile lui, era lucrare bătută, conform modelului pe care DOMNUL îl arătase lui Moise, astfel a făcut el sfeșnicul. ");
INSERT INTO ronbtf_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","Ia pe leviți dintre copiii lui Israel și curăță-i. ");
INSERT INTO ronbtf_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Și astfel să le faci ca să îi cureți: Stropește apa curățirii peste ei, iar ei să își bărbierească toată carnea lor și să își spele hainele și astfel să se curețe. ");
INSERT INTO ronbtf_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Apoi să ia un taur tânăr cu darul lui de mâncare, floarea făinii amestecată cu untdelemn și un alt taur tânăr să îl iei tu ca ofrandă pentru păcat. ");
INSERT INTO ronbtf_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Și să aduci pe leviți înaintea tabernacolului întâlnirii și să aduni întreaga adunare a copiilor lui Israel la un loc; ");
INSERT INTO ronbtf_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Și să aduci pe leviți înaintea DOMNULUI și copiii lui Israel să își pună mâinile peste leviți; ");
INSERT INTO ronbtf_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Și Aaron să ofere pe leviți înaintea DOMNULUI ca o ofrandă a copiilor lui Israel, ca ei să facă serviciul DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Și leviții să își pună mâinile pe capetele taurilor și tu să aduci pe unul ca ofrandă pentru păcat și pe altul ca ofrandă arsă, DOMNULUI, pentru a face ispășire pentru leviți. ");
INSERT INTO ronbtf_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Și să îi pui să stea pe leviți înaintea lui Aaron și înaintea fiilor săi și să îi aduci ca o ofrandă DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Astfel să îi separi pe leviți dintre copiii lui Israel și leviții vor fi ai mei. ");
INSERT INTO ronbtf_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Și după aceea leviții să intre să facă serviciul tabernacolului întâlnirii și tu să îi cureți și să îi aduci ca ofrandă. ");
INSERT INTO ronbtf_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Pentru că ei sunt în întregime dați mie dintre copiii lui Israel; în locul celor ce deschid fiecare pântece, a întâilor născuți ai tuturor copiilor lui Israel, i-am luat la mine. ");
INSERT INTO ronbtf_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Pentru că toți întâii născuți ai copiilor lui Israel sunt ai mei, deopotrivă om și animal, din ziua în care am lovit pe fiecare întâi născut în țara Egiptului, i-am sfințit pentru mine. ");
INSERT INTO ronbtf_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Și am luat pe leviți în locul tuturor întâilor născuți ai copiilor lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Și din mijlocul copiilor lui Israel am dat pe leviți în dar lui Aaron și fiilor săi, pentru a face serviciul copiilor lui Israel în tabernacolul întâlnirii și pentru a face ispășire pentru copiii lui Israel, ca să nu fie nicio plagă printre copiii lui Israel, când copiii lui Israel se apropie de sanctuar. ");
INSERT INTO ronbtf_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Și Moise și Aaron și toată adunarea copiilor lui Israel, a făcut leviților conform cu tot ceea ce DOMNUL i-a poruncit lui Moise referitor la leviți, astfel le-au făcut copiii lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Și leviții au fost purificați și și-au spălat hainele; și Aaron i-a adus ca ofrandă înaintea DOMNULUI; și Aaron a făcut ispășire pentru ei ca să îi curețe. ");
INSERT INTO ronbtf_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Și după aceea leviții au intrat să facă serviciul în tabernacolul întâlnirii înaintea lui Aaron și înaintea fiilor săi, precum DOMNUL îi poruncise lui Moise referitor la leviți, astfel le-au făcut. ");
INSERT INTO ronbtf_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","Aceasta este ceea ce aparține leviților, de la vârsta de douăzeci și cinci de ani în sus, ei să intre pentru a servi în serviciul tabernacolului întâlnirii, ");
INSERT INTO ronbtf_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Și de la vârsta de cincizeci de ani să înceteze să servească în serviciul acesta și să nu mai servească; ");
INSERT INTO ronbtf_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Ci să servească cu frații lor în tabernacolul întâlnirii, pentru a păzi însărcinarea și să nu facă niciun serviciu. Astfel să le faci leviților referitor la porunca lor. ");
INSERT INTO ronbtf_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Și DOMNUL i-a vorbit lui Moise în pustiul Sinai, în prima lună a celui de al doilea an, după ce au ieșit din țara Egiptului, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","Copiii lui Israel să țină de asemenea paștele la timpul rânduit lui. ");
INSERT INTO ronbtf_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","În ziua a paisprezecea a acestei luni, pe înserat, să îl țineți la timpul rânduit lui, conform cu toate riturile acestuia și conform cu toate ceremoniile lui, să îl țineți. ");
INSERT INTO ronbtf_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Și Moise a vorbit copiilor lui Israel să țină paștele. ");
INSERT INTO ronbtf_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Și au ținut paștele în ziua a paisprezecea a primei luni, pe înserat, în pustiul Sinai, conform cu tot ceea ce DOMNUL i-a poruncit lui Moise, astfel au făcut copiii lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Și au fost anumiți bărbați, care erau pângăriți din cauza trupului mort al unui om, astfel că nu au putut ține paștele în ziua aceea și au venit înaintea lui Moise și înaintea lui Aaron în acea zi; ");
INSERT INTO ronbtf_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Și acei oameni i-au spus: Noi suntem pângăriți din cauza trupului mort al unui om; pentru aceasta suntem ținuți să nu aducem un dar DOMNULUI la timpul rânduit lui printre copiii lui Israel? ");
INSERT INTO ronbtf_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Și Moise le-a spus: Stați liniștiți iar eu o să ascult ce va porunci Domnul referitor la voi. ");
INSERT INTO ronbtf_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Și DOMNUL i-a vorbit lui Moise și a zis: ");
INSERT INTO ronbtf_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Vorbește copiilor lui Israel, spunând: Dacă vreun bărbat dintre voi sau din posteritatea voastră va fi necurat din cauza unui trup mort, sau este în călătorie departe, totuși el să țină paștele DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","În ziua a paisprezecea a celei de a doua luni pe înserat ei să îl țină și să îl mănânce cu azime și ierburi amare. ");
INSERT INTO ronbtf_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Și să nu lase nimic din el până dimineața, nici să nu îi frângă vreun os, să îl țină conform cu toate rânduielile paștelui. ");
INSERT INTO ronbtf_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Dar omul care este curat și nu este într-o călătorie și se ferește să țină paștele, acel suflet să fie stârpit din mijlocul poporului său, pentru că nu a adus darul DOMNULUI la timpul rânduit lui, acel om să poarte păcatul său. ");
INSERT INTO ronbtf_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Și dacă un străin va locui temporar printre voi și voiește să țină paștele DOMNULUI; conform rânduielii paștelui și conform obiceiului acestuia, astfel să facă, să aveți o singură rânduială, deopotrivă pentru străin și pentru cel născut în țară. ");
INSERT INTO ronbtf_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Și în ziua în care tabernacolul a fost ridicat, norul a acoperit tabernacolul, adică, cortul mărturiei, și pe înserat era peste tabernacol ceva ca înfățișarea unui foc, până dimineața. ");
INSERT INTO ronbtf_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Astfel a fost întotdeauna, norul îl acoperea ziua și înfățișarea de foc pe timpul nopții. ");
INSERT INTO ronbtf_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Și când norul era ridicat de pe tabernacol, abia apoi copiii lui Israel călătoreau; și în locul unde norul se așeza, acolo copiii lui Israel își așezau corturile lor. ");
INSERT INTO ronbtf_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","La porunca DOMNULUI copiii lui Israel călătoreau și la porunca lui Dumnezeu așezau corturile, atâta timp cât norul se așeza peste tabernacol, ei se odihneau în corturile lor. ");
INSERT INTO ronbtf_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Și când norul întârzia peste tabernacol multe zile, atunci copiii lui Israel păzeau însărcinarea DOMNULUI și nu călătoreau. ");
INSERT INTO ronbtf_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Și astfel a fost când norul era puține zile peste tabernacol; conform poruncii DOMNULUI locuiau în corturile lor și conform poruncii DOMNULUI călătoreau. ");
INSERT INTO ronbtf_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Și astfel a fost când norul se așeza de seara până dimineața și când norul era ridicat dimineața, atunci călătoreau, fie că era pe ziuă, fie pe noapte, când norul era ridicat, ei călătoreau. ");
INSERT INTO ronbtf_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Sau fie că erau două zile sau o lună sau un an, când norul întârzia peste tabernacol, rămânând acolo, copiii lui Israel locuiau în corturile lor și nu călătoreau, dar când acesta era ridicat, călătoreau. ");
INSERT INTO ronbtf_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","La porunca DOMNULUI se odihneau în corturile lor și la porunca DOMNULUI călătoreau; păzeau însărcinarea DOMNULUI, la porunca DOMNULUI prin mâna lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Fă-ți două trâmbițe din argint; dintr-o singură bucată să le faci, ca să le folosești pentru chemarea adunării și pentru călătoria taberelor. ");
INSERT INTO ronbtf_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Și când vor trâmbița cu ele, toată adunarea să se adune la tine la ușa tabernacolului întâlnirii. ");
INSERT INTO ronbtf_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Și dacă vor trâmbița doar cu una, atunci prinții, căpeteniile miilor lui Israel, să se adune la tine. ");
INSERT INTO ronbtf_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Când trâmbițați o alarmă, atunci taberele care se află pe partea de est să meargă înainte. ");
INSERT INTO ronbtf_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Când trâmbițați o alarmă a doua oară, atunci taberele care se află pe partea de sud să pornească, ei să sune o alarmă pentru călătoriile lor. ");
INSERT INTO ronbtf_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Dar când adunarea trebuie adunată, să trâmbițați, dar să nu sunați o alarmă. ");
INSERT INTO ronbtf_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Și fiii lui Aaron, preoții, să trâmbițeze cu trâmbițele; și ei să vă fie o rânduială pentru totdeauna prin toate generațiile voastre. ");
INSERT INTO ronbtf_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Și dacă mergeți la război în țara voastră împotriva dușmanului care vă oprimă, atunci să sunați o alarmă cu trâmbițele; și veți fi amintiți înaintea DOMNULUI Dumnezeului vostru și veți fi salvați din mâna dușmanilor voștri. ");
INSERT INTO ronbtf_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","De asemenea în ziua veseliei voastre și în zilele voastre solemne și la începuturile lunilor voastre, să trâmbițați cu trâmbițele peste ofrandele voastre arse și peste sacrificiile ofrandelor voastre de pace; ca să vă fie ca o amintire înaintea Dumnezeului vostru: Eu sunt DOMNUL Dumnezeul vostru. ");
INSERT INTO ronbtf_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Și s-a întâmplat în a douăzecea zi a celei de a doua luni, în al doilea an, că norul a fost ridicat de pe tabernacolul mărturiei. ");
INSERT INTO ronbtf_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Și copiii lui Israel au pornit în călătoriile lor ieșind din pustiul Sinai; și norul a rămas în pustiul Paran. ");
INSERT INTO ronbtf_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Și primii au pornit conform poruncii DOMNULUI dată prin mâna lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","În primul rând a plecat steagul taberei copiilor lui Iuda, conform oștirilor lor, și peste oștirea lui era Nahșon, fiul lui Aminadab. ");
INSERT INTO ronbtf_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Și peste oștirea tribului copiilor lui Isahar era Nataneel, fiul lui Țuar. ");
INSERT INTO ronbtf_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Și peste oștirea tribului copiilor lui Zabulon era Eliab, fiul lui Helon. ");
INSERT INTO ronbtf_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Și tabernacolul a fost desfăcut; și fiii lui Gherșon și fiii lui Merari au pornit, purtând tabernacolul. ");
INSERT INTO ronbtf_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Și steagul taberei lui Ruben a pornit conform oștirilor lor și peste oștirea lui era Elițur, fiul lui Ședeur. ");
INSERT INTO ronbtf_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Și peste oștirea tribului copiilor lui Simeon era Șelumiel, fiul lui Țurișadai. ");
INSERT INTO ronbtf_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Și peste oștirea tribului copiilor lui Gad era Eliasaf, fiul lui Deuel. ");
INSERT INTO ronbtf_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Și chehatiții au pornit purtând sanctuarul, iar ceilalți așezaseră cortul până la venirea lor. ");
INSERT INTO ronbtf_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Și steagul taberei copiilor lui Efraim a pornit conform oștirilor lor; și peste oștirea lui era Elișama, fiul lui Amihud. ");
INSERT INTO ronbtf_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Și peste oștirea tribului copiilor lui Manase era Gamaliel, fiul lui Pedahțur. ");
INSERT INTO ronbtf_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Și peste oștirea tribului copiilor lui Beniamin era Abidan, fiul lui Ghideoni. ");
INSERT INTO ronbtf_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Și steagul taberei copiilor lui Dan a pornit în ariergarda tuturor taberelor prin toate oștirile lor; și peste oștirea lui era Ahiezer, fiul lui Amișadai. ");
INSERT INTO ronbtf_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Și peste oștirea tribului copiilor lui Așer era Paghiel, fiul lui Ocran. ");
INSERT INTO ronbtf_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Și peste oștirea tribului copiilor lui Neftali era Ahira, fiul lui Enan. ");
INSERT INTO ronbtf_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Astfel au fost călătoriile copiilor lui Israel conform cu oștirile lor, când porneau. ");
INSERT INTO ronbtf_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Și Moise i-a spus lui Hobab, fiul lui Raguel madianitul, socrul lui Moise: Noi călătorim la locul despre care DOMNUL a spus: Vi-l voi da; vino cu noi și îți vom face bine, pentru că DOMNUL a vorbit bine referitor la Israel. ");
INSERT INTO ronbtf_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Iar el i-a spus: Nu voi merge; ci voi pleca spre țara mea și la rudele mele. ");
INSERT INTO ronbtf_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Dar el a spus: Nu ne părăsi, te rog; căci tu cunoști cum trebuie să ne așezăm tabăra în pustiu și tu vei fi ochi pentru noi. ");
INSERT INTO ronbtf_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Și va fi, dacă mergi cu noi, da, va fi, că orice bunătate ne va face DOMNUL, la fel îți vom face și ție. ");
INSERT INTO ronbtf_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Și au pornit de la muntele DOMNULUI, o călătorie de trei zile, și chivotul legământului DOMNULUI a mers înaintea lor în călătoria de trei zile, pentru a căuta un loc de odihnă pentru ei. ");
INSERT INTO ronbtf_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Și norul DOMNULUI a fost peste ei ziua, când au plecat din tabără. ");
INSERT INTO ronbtf_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Și se întâmpla, când chivotul pornea, că Moise spunea: Ridică-te, DOAMNE, și să fie dușmanii tăi împrăștiați; și cei ce te urăsc să fugă dinaintea ta. ");
INSERT INTO ronbtf_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Și când chivotul se oprea, spunea: Întoarce-te, DOAMNE, la mulțimea miilor lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Și când poporul s-a plâns, aceasta nu a plăcut DOMNULUI, și DOMNUL a auzit și mânia lui s-a aprins; și focul DOMNULUI a ars printre ei și a mistuit pe cei din cele mai îndepărtate părți ale taberei. ");
INSERT INTO ronbtf_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Și poporul a strigat spre Moise, și când Moise s-a rugat DOMNULUI, focul a fost stins. ");
INSERT INTO ronbtf_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Și a pus acelui loc numele Tabeera, deoarece focul DOMNULUI a ars printre ei. ");
INSERT INTO ronbtf_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Și mulțimea amestecată, ce era printre ei, a căzut în lăcomie; și copiii lui Israel de asemenea au plâns din nou și au spus: Cine ne va da carne să mâncăm? ");
INSERT INTO ronbtf_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Ne amintim de peștii, pe care i-am mâncat în Egipt pe gratis; de castraveți și de pepeni și de praji și de ceapă și de usturoi, ");
INSERT INTO ronbtf_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Dar acum sufletul nostru este uscat, nu este nimic înaintea ochilor noștri, în afară de această mană. ");
INSERT INTO ronbtf_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Și mana era asemenea seminței de coriandru și culoarea ei asemenea culorii de bedelium. ");
INSERT INTO ronbtf_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Și poporul a mers încoace și încolo și au strâns-o și au măcinat-o în mori, sau au bătut-o într-o piuă și au copt-o în tăvi și au făcut turte din ea și gustul ei era ca gustul untdelemnului proaspăt. ");
INSERT INTO ronbtf_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Și când roua a căzut peste tabără în timpul nopții, mana a căzut peste ea. ");
INSERT INTO ronbtf_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Atunci Moise a auzit poporul plângând prin toate familiile lor, fiecare bărbat în ușa cortului său, și mânia DOMNULUI s-a aprins foarte tare; Moise de asemenea a fost nemulțumit. ");
INSERT INTO ronbtf_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Și Moise a spus DOMNULUI: Pentru ce ai chinuit pe servitorul tău? Și pentru ce nu am găsit favoare înaintea ochilor tăi, de așezi povara acestui întreg popor asupra mea? ");
INSERT INTO ronbtf_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Am conceput eu pe tot poporul acesta? I-am născut eu, ca să îmi spui: Poartă-i la sânul tău, precum un tată grijuliu poartă sugarul, până la țara pe care ai jurat-o părinților lor? ");
INSERT INTO ronbtf_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","De unde să am eu carne să dau la tot acest popor? Căci ei plâng către mine, spunând: Dă-ne carne să mâncăm. ");
INSERT INTO ronbtf_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Nu sunt în stare să port tot acest popor singur, căci este prea greu pentru mine. ");
INSERT INTO ronbtf_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Și dacă te porți astfel cu mine, ucide-mă, te rog, ucide-mă, dacă am găsit favoare înaintea ochilor tăi; și nu mă lăsa să văd nenorocirea mea. ");
INSERT INTO ronbtf_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Și DOMNUL i-a spus lui Moise: Adună-mi șaptezeci de bărbați dintre bătrânii lui Israel, pe care îi cunoști că sunt bătrânii poporului și ofițeri peste ei; și adu-i la tabernacolul întâlnirii, ca să stea în picioare acolo cu tine. ");
INSERT INTO ronbtf_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Și eu voi coborî și voi vorbi cu tine acolo; și voi lua din duhul care este peste tine și îl voi pune peste ei; și ei vor purta povara poporului cu tine, ca să nu o mai porți de unul singur. ");
INSERT INTO ronbtf_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Și spune poporului: Sfințiți-vă pentru mâine și carne veți mânca, pentru că ați plâns în urechile DOMNULUI, spunând: Cine ne va da carne să mâncăm? Fiindcă era bine de noi în Egipt, de aceea DOMNUL vă va da carne și o veți mânca. ");
INSERT INTO ronbtf_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Nu veți mânca o zi, nici două zile, nici cinci zile, nici zece zile, nici douăzeci de zile; ");
INSERT INTO ronbtf_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Ci chiar o lună întreagă, până vă va ieși afară pe nări și vă va fi dezgustătoare; deoarece ați disprețuit pe DOMNUL care este între voi și ați plâns înaintea lui, spunând: De ce am ieșit afară din Egipt? ");
INSERT INTO ronbtf_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Și Moise a spus: Poporul, printre care eu sunt, sunt șase sute de mii de pedeștri; și tu ai spus: Eu le voi da carne, ca ei să mănânce o lună întreagă. ");
INSERT INTO ronbtf_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Să fie turmele și cirezile ucise pentru ei, ca să îi îndestuleze? Sau vor fi toți peștii mării adunați pentru ei, pentru a-i îndestula? ");
INSERT INTO ronbtf_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Și DOMNUL i-a spus lui Moise: S-a scurtat mâna DOMNULUI? Vei vedea acum dacă ți se va întâmpla sau nu cuvântul meu. ");
INSERT INTO ronbtf_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Și Moise a ieșit și a spus poporului cuvintele DOMNULUI și a adunat pe cei șaptezeci de bărbați dintre bătrânii poporului și i-a pus să stea de jur împrejurul tabernacolului. ");
INSERT INTO ronbtf_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Și DOMNUL a coborât într-un nor și i-a vorbit și a luat din duhul care era peste el și l-a dat celor șaptezeci de bătrâni și s-a întâmplat, când duhul s-a așezat peste ei, că au profețit și nu au încetat. ");
INSERT INTO ronbtf_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Dar acolo au rămas doi dintre bărbați în tabără, numele unuia era Eldad și numele celuilalt Medad, și duhul s-a așezat peste ei; și ei au fost dintre cei ce erau scriși, dar nu au ieșit la tabernacol și au profețit în tabără. ");
INSERT INTO ronbtf_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Și a alergat un tânăr și i-a spus lui Moise zicând: Eldad și Medad profețesc în tabără. ");
INSERT INTO ronbtf_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Și Iosua, fiul lui Nun, servitorul lui Moise, unul dintre tinerii săi, a răspuns și a zis: Moise, domnul meu, oprește-i. ");
INSERT INTO ronbtf_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Și el i-a spus: Ești invidios pentru mine? Să dea Dumnezeu ca tot poporul DOMNULUI să fie profeți și ca DOMNUL să pună duhul său peste ei! ");
INSERT INTO ronbtf_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Și Moise s-a întors în tabără, el și bătrânii lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Și a ieșit un vânt de la DOMNUL și a adus prepelițe de la mare și le-a lăsat să cadă lângă tabără, cât ar fi o zi de călătorie pe partea aceasta și cât ar fi o zi de călătorie pe partea cealaltă, de jur împrejurul taberei, și cât ar fi doi coți în înălțime peste fața pământului. ");
INSERT INTO ronbtf_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Și poporul a stat în picioare toată ziua aceea și toată noaptea și toată ziua următoare și au adunat prepelițele, cel ce a adunat mai puțin a adunat zece omeri; și le-au întins de jur împrejurul taberei. ");
INSERT INTO ronbtf_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Și în timp ce carnea era încă între dinții lor, înainte să fie mestecată, mânia DOMNULUI s-a aprins împotriva poporului și DOMNUL a lovit poporul cu o plagă foarte mare. ");
INSERT INTO ronbtf_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Și a pus acelui loc numele Chibrot-Hataava, deoarece acolo au îngropat poporul care a lăcomit. ");
INSERT INTO ronbtf_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Și poporul a călătorit de la Chibrot-Hataava la Hațerot; și au rămas la Hațerot. ");
INSERT INTO ronbtf_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Și Miriam și Aaron au vorbit împotriva lui Moise din cauza femeii etiopiene cu care el se căsătorise, pentru că el se căsătorise cu o femeie etiopiană. ");
INSERT INTO ronbtf_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Și au spus: A vorbit DOMNUL numai prin Moise? Nu a vorbit el și prin noi? Și DOMNUL a auzit aceasta. ");
INSERT INTO ronbtf_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(Acum bărbatul Moise era foarte blând, mai mult decât toți oamenii care erau pe fața pământului.) ");
INSERT INTO ronbtf_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Și DOMNUL i-a vorbit pe neașteptate lui Moise și lui Aaron și lui Miriam: Ieșiți voi trei la tabernacolul întâlnirii. Și cei trei au ieșit. ");
INSERT INTO ronbtf_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Și DOMNUL a coborât într-un stâlp de nor și a stat în ușa tabernacolului și a chemat pe Aaron și pe Miriam și amândoi au ieșit înainte. ");
INSERT INTO ronbtf_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Și a spus: Ascultați acum cuvintele mele: Dacă este un profet între voi, eu DOMNUL mă voi face cunoscut lui intr-o viziune și îi voi vorbi într-un vis. ");
INSERT INTO ronbtf_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Servitorul meu Moise nu este astfel, el fiind credincios în toată casa mea. ");
INSERT INTO ronbtf_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Cu el voi vorbi gură către gură, chiar pe față și nu în vorbe adânci; și asemănarea DOMNULUI o va privi, pentru ce atunci nu v-ați temut să vorbiți împotriva servitorului meu Moise? ");
INSERT INTO ronbtf_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Și mânia DOMNULUI s-a aprins împotriva lor; și a plecat. ");
INSERT INTO ronbtf_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Și norul s-a depărtat de pe tabernacol; și, iată, Miriam era leproasă, albă ca zăpada; și Aaron a privit la Miriam și, iată, era leproasă. ");
INSERT INTO ronbtf_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Și Aaron i-a spus lui Moise: Vai, domnul meu, te implor, nu așeza peste noi acest păcat în care am lucrat prostește și în care am păcătuit. ");
INSERT INTO ronbtf_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Să nu fie ea ca un mort, din care carnea este pe jumătate mistuită când iese din pântecele mamei ei. ");
INSERT INTO ronbtf_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Și Moise a strigat către DOMNUL, spunând: Vindec-o acum, Dumnezeule, te implor. ");
INSERT INTO ronbtf_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Și DOMNUL i-a spus lui Moise: Dacă tatăl ei doar ar fi scuipat-o în față, nu ar fi fost ea rușinată șapte zile? să fie închisă în afara taberei șapte zile și după aceea să fie primită din nou. ");
INSERT INTO ronbtf_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Și Miriam a fost închisă în afara taberei șapte zile și poporul nu a călătorit până ce Miriam nu a fost adusă din nou. ");
INSERT INTO ronbtf_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Și după aceea poporul a plecat din Hațerot și a așezat corturile în pustiul Paran. ");
INSERT INTO ronbtf_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","Trimite bărbați, ca ei să cerceteze țara lui Canaan, pe care o dau copiilor lui Israel; din fiecare trib al părinților lor să trimiteți un bărbat, fiecare să fie un conducător printre ei. ");
INSERT INTO ronbtf_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Și Moise prin porunca DOMNULUI i-a trimis din pustiul Paran; toți acei bărbați erau căpeteniile copiilor lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Și acestea erau numele lor, din tribul lui Ruben: Șamua, fiul lui Zacur. ");
INSERT INTO ronbtf_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Din tribul lui Simeon: Șafat, fiul lui Hori. ");
INSERT INTO ronbtf_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Din tribul lui Iuda: Caleb, fiul lui Iefune. ");
INSERT INTO ronbtf_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Din tribul lui Isahar: Igal, fiul lui Iosif. ");
INSERT INTO ronbtf_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Din tribul lui Efraim: Oșea, fiul lui Nun. ");
INSERT INTO ronbtf_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Din tribul lui Beniamin: Palti, fiul lui Rafu. ");
INSERT INTO ronbtf_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Din tribul lui Zabulon: Gadiel, fiul lui Sodi. ");
INSERT INTO ronbtf_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Din tribul lui Iosif, adică, din tribul lui Manase: Gadi, fiul lui Susi. ");
INSERT INTO ronbtf_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Din tribul lui Dan: Amiel, fiul lui Ghemali. ");
INSERT INTO ronbtf_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Din tribul lui Așer: Setur, fiul lui Mihail. ");
INSERT INTO ronbtf_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Din tribul lui Neftali: Nabi, fiul lui Vofsi. ");
INSERT INTO ronbtf_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Din tribul lui Gad: Gheuel, fiul lui Machi. ");
INSERT INTO ronbtf_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Acestea sunt numele bărbaților pe care Moise i-a trimis să cerceteze țara. Și Moise a pus numele lui Oșea, fiul lui Nun, Iosua. ");
INSERT INTO ronbtf_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Și Moise i-a trimis să cerceteze țara lui Canaan și le-a spus: Ridicați-vă pe această cale spre sud și urcați-vă la munte; ");
INSERT INTO ronbtf_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Și vedeți țara, cum este; și poporul care locuiește în ea, dacă sunt puternici sau slabi, puțini sau mulți; ");
INSERT INTO ronbtf_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Și cum este țara în care locuiesc, dacă este bună sau rea; și ce fel de cetăți sunt cele în care locuiesc, sau locuiesc în corturi, sau în cetăți întărite. ");
INSERT INTO ronbtf_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Și cum este țara, dacă este grasă sau uscată, dacă este lemn în ea, sau nu. Și încurajați-vă și aduceți din rodul țării. Acum timpul era timpul primului rod al strugurilor. ");
INSERT INTO ronbtf_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Astfel că s-au urcat și au cercetat țara de la pustiul Țin până la Rehob, cum vin oamenii la Hamat. ");
INSERT INTO ronbtf_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Și au urcat pe la sud și au venit la Hebron; unde erau Ahiman, Șeșai și Talmai, copiii lui Anac. (Acum Hebronul a fost zidit cu șapte ani înaintea Țoanului în Egipt.) ");
INSERT INTO ronbtf_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Și au venit la pârâul lui Eșcol și au retezat de acolo o creangă cu un singur ciorchine de struguri și l-au purtat între doi pe un toiag; și au adus din rodii și din smochine. ");
INSERT INTO ronbtf_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Locul a fost numit pârâul Eșcol, din cauza ciorchinelui de struguri pe care copiii lui Israel l-au retezat de acolo. ");
INSERT INTO ronbtf_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Și s-au întors de la cercetarea țării după patruzeci de zile. ");
INSERT INTO ronbtf_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Și au mers și au venit la Moise și la Aaron și la toată adunarea copiilor lui Israel, în pustiul Paran, la Cades; și le-au adus înapoi răspuns, lor și la toată adunarea, și le-au arătat rodul țării. ");
INSERT INTO ronbtf_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Și i-au povestit și au spus: Am intrat în țara unde ne-ai trimis și cu adevărat în aceasta curge lapte și miere; și acesta este rodul ei. ");
INSERT INTO ronbtf_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Totuși poporul care locuiește în țară este puternic și cetățile sunt foarte mari și înconjurate cu ziduri; și mai mult, am văzut pe copiii lui Anac acolo. ");
INSERT INTO ronbtf_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amaleciții locuiesc în țara de sud și hitiții și iebusiții și amoriții locuiesc în munți; și canaaniții locuiesc lângă mare și pe lângă Iordan. ");
INSERT INTO ronbtf_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Și Caleb a liniștit poporul înaintea lui Moise și a spus: Să ne ridicăm deodată și să o stăpânim, pentru că suntem în stare să o învingem. ");
INSERT INTO ronbtf_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Dar bărbații care au urcat cu el au spus: Noi nu suntem în stare să ne ridicăm împotriva acestui popor, pentru că ei sunt mai tari ca noi. ");
INSERT INTO ronbtf_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Și au adus un raport rău copiilor lui Israel despre țara pe care o cercetaseră, spunând: Țara prin care am trecut să o cercetăm, este o țară care mănâncă pe locuitorii ei; și tot poporul pe care l-am văzut în ea sunt oameni de o statură mare. ");
INSERT INTO ronbtf_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Și acolo am văzut pe uriași, fiii lui Anac, care se trag din uriași; și eram în ochii noștri asemenea cosașelor și astfel eram și înaintea ochilor lor. ");
INSERT INTO ronbtf_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Și toată adunarea și-a înălțat vocea și a strigat; și poporul a plâns în noaptea aceea. ");
INSERT INTO ronbtf_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Și toți copiii lui Israel au cârtit împotriva lui Moise și împotriva lui Aaron și întreaga adunare le-a spus: Să fi dat Dumnezeu să fi murit în țara Egiptului! Sau, mai bine să fi murit în pustiu! ");
INSERT INTO ronbtf_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Și pentru ce ne-a adus DOMNUL în această țară? Să cădem prin sabie, ca soțiile noastre și copiii noștri să fie o pradă? Nu ar fi mai bine să ne întoarcem în Egipt? ");
INSERT INTO ronbtf_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Și au spus unul altuia: Să ne facem o căpetenie și să ne întoarcem în Egipt. ");
INSERT INTO ronbtf_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Atunci Moise și Aaron au căzut cu fețele la pământ înaintea întregii adunări a copiilor lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Și Iosua, fiul lui Nun, și Caleb, fiul lui Iefune, care erau dintre cei ce au cercetat țara și-au rupt hainele, ");
INSERT INTO ronbtf_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Și au vorbit întregii adunări a copiilor lui Israel, spunând: Țara prin care noi am trecut să o cercetăm este o țară foarte bună. ");
INSERT INTO ronbtf_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Dacă DOMNUL va găsi plăcere în noi, atunci ne va aduce în această țară și ne-o va da; o țară în care curge lapte și miere. ");
INSERT INTO ronbtf_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Numai să nu vă răzvrătiți împotriva DOMNULUI, nici să nu vă temeți de poporul țării; căci ei sunt pâine pentru noi, apărarea lor s-a depărtat de la ei și DOMNUL este cu noi; să nu vă temeți de ei. ");
INSERT INTO ronbtf_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Dar toată adunarea a cerut să îi ucidă cu pietre. Și gloria DOMNULUI a apărut în tabernacolul întâlnirii înaintea tuturor copiilor lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Și DOMNUL i-a spus lui Moise: Până când voiește acest popor să mă provoace? Și cât timp va trece până când vor crede în mine, cu toate semnele pe care le-am arătat printre ei? ");
INSERT INTO ronbtf_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Îi voi lovi cu ciumă și îi voi dezmoșteni și voi face din tine o națiune mai mare și mai tare decât ei. ");
INSERT INTO ronbtf_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Și Moise a spus DOMNULUI: Atunci egiptenii vor auzi aceasta, (pentru că dintre ei ai scos acest popor în tăria ta;) ");
INSERT INTO ronbtf_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Și o vor spune locuitorilor acestei țări, pentru că ei au auzit că tu, DOMNUL, ești în mijlocul acestui popor, că tu DOMNUL ești văzut față în față și că norul tău stă deasupra lor și că mergi înaintea lor, ziua într-un stâlp de nor și noaptea într-un stâlp de foc. ");
INSERT INTO ronbtf_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Acum dacă o să ucizi tot poporul acesta ca pe un singur om, atunci națiunile care au auzit de faima ta vor vorbi, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Pentru că DOMNUL nu a fost în stare să ducă acest popor în țara pe care le-a jurat-o, de aceea i-a ucis în pustiu. ");
INSERT INTO ronbtf_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Și acum, te implor, să fie puterea Domnului meu mare, conform cu ceea ce ai vorbit, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","DOMNUL este îndelung răbdător și bogat în milă, iertând nelegiuirea și fărădelegea și în niciun fel dezvinovățind pe vinovat, pedepsind nelegiuirea părinților peste copii până la a treia și a patra generație. ");
INSERT INTO ronbtf_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Iartă, te implor, nelegiuirea acestui popor conform măreției milei tale și precum ai iertat acest popor, din Egipt până acum. ");
INSERT INTO ronbtf_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Și DOMNUL a spus: Am iertat conform cuvântului tău; ");
INSERT INTO ronbtf_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Dar pe cât este de adevărat că eu trăiesc, tot pământul va fi umplut cu gloria DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Pentru că toți acei bărbați care au văzut gloria mea și miracolele mele, pe care le-am făcut în Egipt și în pustiu și m-au ispitit de zece ori și nu au dat ascultare vocii mele; ");
INSERT INTO ronbtf_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Cu siguranță nu vor vedea țara pe care am jurat-o părinților lor, niciunul dintre cei ce m-au provocat nu o va vedea, ");
INSERT INTO ronbtf_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Ci servitorul meu Caleb, deoarece a avut un alt duh cu el și m-a urmat pe deplin, pe el îl voi duce în țara în care a mers; și sămânța lui o va stăpâni. ");
INSERT INTO ronbtf_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","(Acum amaleciții și canaaniții locuiau în vale.) Mâine întoarceți-vă și plecați în pustiu pe calea Mării Roșii. ");
INSERT INTO ronbtf_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Și DOMNUL i-a vorbit lui Moise și lui Aaron, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","Cât să mai suport această adunare rea, care cârtește împotriva mea? Am auzit cârtirile copiilor lui Israel, pe care le cârtesc împotriva mea. ");
INSERT INTO ronbtf_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Să le spui: Pe cât este de adevărat că eu trăiesc, spune DOMNUL, precum ați vorbit în urechile mele, astfel vă voi face; ");
INSERT INTO ronbtf_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Trupurile voastre moarte vor cădea în acest pustiu; și toți cei numărați dintre voi, conform numărului vostru în întregime, de la vârsta de douăzeci de ani în sus, care ați cârtit împotriva mea, ");
INSERT INTO ronbtf_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Fără îndoială, voi nu veți intra în țara despre care am jurat că vă voi face să locuiți în ea, cu excepția lui Caleb, fiul lui Iefune, și Iosua, fiul lui Nun. ");
INSERT INTO ronbtf_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Dar micuții voștri, despre care ați spus că vor fi o pradă, pe ei îi voi duce înăuntru și vor cunoaște țara pe care ați disprețuit-o. ");
INSERT INTO ronbtf_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Dar cât despre voi, trupurile voastre moarte vor cădea în acest pustiu. ");
INSERT INTO ronbtf_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Și copiii voștri vor rătăci în pustiu patruzeci de ani și vor purta curviile voastre, până ce trupurile voastre moarte vor fi risipite în pustiu. ");
INSERT INTO ronbtf_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","După numărul zilelor în care ați cercetat țara, adică patruzeci de zile, fiecare zi pentru un an, veți purta nelegiuirile voastre, adică patruzeci de ani și veți cunoaște cum îmi rup promisiunea. ");
INSERT INTO ronbtf_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Eu DOMNUL am spus: Cu siguranță astfel voi face la toată această adunare rea, care s-a adunat împotriva mea; în acest pustiu vor fi mistuiți și acolo vor muri. ");
INSERT INTO ronbtf_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Și bărbații, pe care Moise i-a trimis să cerceteze țara, care s-au întors și au făcut întreaga adunare să cârtească împotriva lui, aducând defăimare asupra țării, ");
INSERT INTO ronbtf_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Chiar acei bărbați care au adus raportul rău despre țară, au murit printr-o plagă înaintea DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Dar Iosua, fiul lui Nun, și Caleb, fiul lui Iefune, dintre oamenii care au mers să cerceteze țara, au trăit. ");
INSERT INTO ronbtf_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Și Moise a spus aceste cuvinte tuturor copiilor lui Israel; și tot poporul a jelit mult. ");
INSERT INTO ronbtf_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Și s-au sculat devreme dimineața și s-au urcat în vârful muntelui, spunând: Iată-ne și vom urca la locul pe care DOMNUL l-a promis, căci am păcătuit. ");
INSERT INTO ronbtf_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Și Moise a spus: Pentru ce încălcați acum porunca DOMNULUI? Aceasta nu va prospera. ");
INSERT INTO ronbtf_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Nu vă urcați, pentru că DOMNUL nu este printre voi; ca să nu fiți bătuți înaintea dușmanilor voștri. ");
INSERT INTO ronbtf_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Fiindcă amaleciții și canaaniții sunt acolo înaintea voastră și veți cădea prin sabie, deoarece v-ați întors de la DOMNUL, de aceea DOMNUL nu va fi cu voi. ");
INSERT INTO ronbtf_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Dar ei au îndrăznit să urce pe vârful dealului, totuși chivotul legământului DOMNULUI și Moise, nu s-au depărtat de tabără. ");
INSERT INTO ronbtf_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Atunci amaleciții au coborât și canaaniții care au locuit pe acel deal și i-au bătut și i-au învins, până la Horma. ");
INSERT INTO ronbtf_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","Vorbește copiilor lui Israel și spune-le: Când veți fi ajuns în țara locuințelor voastre, pe care v-o dau, ");
INSERT INTO ronbtf_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","Și veți face o ofrandă prin foc DOMNULUI, o ofrandă arsă, sau un sacrificiu în împlinirea unui jurământ, sau într-o ofrandă de bunăvoință, sau în sărbătorile voastre solemne, ca să faceți o aromă dulce DOMNULUI, din cireadă, sau din turmă, ");
INSERT INTO ronbtf_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Atunci cel ce aduce darul său DOMNULUI, să aducă dar de mâncare, a zecea parte dintr-o măsură de făină amestecată cu a patra parte dintr-un hin de untdelemn. ");
INSERT INTO ronbtf_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Și a patra parte dintr-un hin de vin ca un dar de băutură să îl pregătești cu ofranda arsă sau sacrificiul, pentru un singur miel. ");
INSERT INTO ronbtf_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Sau pentru un berbec, să îl pregătești ca dar de mâncare cu două zecimi dintr-o măsură de făină amestecată cu a treia parte dintr-un hin de untdelemn. ");
INSERT INTO ronbtf_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Și ca dar de băutură să aduci a treia parte dintr-un hin de vin, de o aromă dulce DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Și când pregătești un taur, ca ofrandă arsă, sau ca sacrificiu în împlinirea unui jurământ, sau ca ofrande de pace DOMNULUI, ");
INSERT INTO ronbtf_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","Să se aducă, cu un taur, un dar de mâncare din trei zecimi dintr-o măsură de făină amestecată cu o jumătate de hin de untdelemn. ");
INSERT INTO ronbtf_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Și să aduci ca dar de băutură o jumătate de hin de vin, ca ofrandă făcută prin foc, de o aromă dulce DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Astfel să se facă pentru un singur taur sau pentru un singur berbec sau pentru un miel sau un ied. ");
INSERT INTO ronbtf_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Conform cu numărul celor pe care le veți pregăti, astfel să faceți fiecăreia dintre ele, după numărul lor. ");
INSERT INTO ronbtf_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Toți cei născuți în țară să facă aceste lucruri după acest obicei, în aducerea unei ofrande făcută prin foc, de o aromă dulce DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Și dacă un străin locuiește temporar cu voi sau oricine este printre voi, în generațiile voastre, și aduce ofrandă făcută prin foc, de o aromă dulce DOMNULUI, precum faceți voi, să facă și el. ");
INSERT INTO ronbtf_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","O singură rânduială să fie deopotrivă pentru voi, cei din adunare, și la fel pentru străinul ce locuiește temporar cu voi, o rânduială pentru totdeauna în generațiile voastre; cum sunteți voi, astfel să fie și străinul înaintea DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","O singură lege și un singur obicei să fie pentru voi și pentru străinul care locuiește temporar cu voi. ");
INSERT INTO ronbtf_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Vorbește copiilor lui Israel și spune-le: Când veți ajunge în țara în care vă duc, ");
INSERT INTO ronbtf_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","Atunci să fie astfel: când mâncați din pâinea țării, să aduceți ofrandă ridicată pentru DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Să aduceți o turtă din primul vostru aluat ca ofrandă ridicată, precum faceți ofranda ridicată din aria de vânturat, astfel să o săltați. ");
INSERT INTO ronbtf_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Din primul vostru aluat să dați DOMNULUI o ofrandă ridicată în generațiile voastre. ");
INSERT INTO ronbtf_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Și dacă ați greșit și nu ați împlinit toate aceste porunci, pe care DOMNUL le-a vorbit lui Moise, ");
INSERT INTO ronbtf_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","Tot ce DOMNUL v-a poruncit prin mâna lui Moise, din ziua când DOMNUL i-a poruncit lui Moise și de atunci înainte prin toate generațiile voastre, ");
INSERT INTO ronbtf_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","Atunci să fie: dacă este făcut prin ignoranță fără cunoașterea adunării, toată adunarea să aducă un taur tânăr ca ofrandă arsă, de o aromă dulce DOMNULUI, împreună cu darul lui de mâncare și darul lui de băutură, conform obiceiului, și un ied dintre capre ca ofrandă pentru păcat. ");
INSERT INTO ronbtf_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Și preotul să facă ispășire pentru toată adunarea copiilor lui Israel și acesta le va fi iertat, fiindcă aceasta este ignoranță; iar ei să aducă darul lor, un sacrificiu făcut prin foc DOMNULUI, și ofranda lor pentru păcat înaintea DOMNULUI, pentru ignoranța lor; ");
INSERT INTO ronbtf_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Și va fi iertat întregii adunări a copiilor lui Israel și străinului ce locuiește temporar printre ei; văzând că tot poporul era în ignoranță. ");
INSERT INTO ronbtf_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Și dacă vreun suflet păcătuiește prin ignoranță, atunci să aducă o capră de un an ca ofrandă pentru păcat. ");
INSERT INTO ronbtf_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Și preotul să facă ispășire pentru sufletul care păcătuiește prin ignoranță, când păcătuiește prin ignoranță înaintea DOMNULUI, pentru a face ispășire pentru el, și îi va fi iertat. ");
INSERT INTO ronbtf_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Să aveți o singură lege pentru cel ce păcătuiește prin ignoranță, deopotrivă pentru cel născut printre copiii lui Israel și pentru străinul ce locuiește temporar printre ei. ");
INSERT INTO ronbtf_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Dar sufletul care o face îngâmfat, fie născut în țară, fie străin, acela îl ocărăște pe DOMNUL; și sufletul acela să fie stârpit din mijlocul poporului său. ");
INSERT INTO ronbtf_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Deoarece a disprețuit cuvântul DOMNULUI și a încălcat porunca lui, acel suflet să fie stârpit cu desăvârșire; nelegiuirea sa să fie asupra sa. ");
INSERT INTO ronbtf_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Și în timp ce copiii lui Israel erau în pustiu, au găsit un bărbat ce aduna lemne în ziua de sabat. ");
INSERT INTO ronbtf_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Și cei ce l-au găsit adunând lemne l-au adus la Moise și Aaron și la toată adunarea. ");
INSERT INTO ronbtf_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Și l-au pus sub pază, deoarece nu a fost declarat ce îi va fi făcut. ");
INSERT INTO ronbtf_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Și DOMNUL i-a spus lui Moise: Acel bărbat negreșit să fie dat morții, toată adunarea să îl ucidă cu pietre, în afara taberei. ");
INSERT INTO ronbtf_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Și toată adunarea l-a scos în afara taberei și l-au ucis cu pietre și a murit; precum DOMNUL i-a poruncit lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Vorbește copiilor lui Israel și poruncește-le să își facă ciucuri pe marginile hainelor lor, prin toate generațiile lor, și să pună peste ciucurii marginilor o panglică de albastru. ");
INSERT INTO ronbtf_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Și aceasta să vă fie drept bordură, ca să o priviți și să vă aduceți aminte toate poruncile DOMNULUI și să le împliniți; și să nu căutați după inima voastră și după ochii voștri, după care obișnuiați să mergeți curvind. ");
INSERT INTO ronbtf_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Ca să vă amintiți și să împliniți toate poruncile mele și să fiți sfinți Dumnezeului vostru. ");
INSERT INTO ronbtf_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Eu sunt DOMNUL Dumnezeul vostru, care v-am scos din țara Egiptului, să fiu Dumnezeul vostru: Eu sunt DOMNUL Dumnezeul vostru. ");
INSERT INTO ronbtf_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Și Core, fiul lui Ițehar, fiul lui Chehat, fiul lui Levi și Datan și Abiram, fiii lui Eliab și On, fiul lui Pelet, fiii lui Ruben, au luat câțiva bărbați, ");
INSERT INTO ronbtf_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Și s-au ridicat înaintea lui Moise, cu unii dintre copiii lui Israel, două sute cincizeci de prinți ai adunării, faimoși în adunare, bărbați de renume; ");
INSERT INTO ronbtf_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Și s-au adunat împotriva lui Moise și împotriva lui Aaron și le-au spus: Luați prea mult asupra voastră, văzând că toată adunarea este sfântă, fiecare om, și DOMNUL este în mijlocul lor, pentru ce atunci vă înălțați deasupra adunării DOMNULUI? ");
INSERT INTO ronbtf_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Și când Moise a auzit aceasta, a căzut cu fața sa la pământ, ");
INSERT INTO ronbtf_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Și i-a vorbit lui Core și întregii lui cete, spunând: Chiar mâine DOMNUL va arăta cine sunt ai lui și cine este sfânt; și îl va face să se apropie de el, chiar pe cel pe care l-a ales îl va face să se apropie de el. ");
INSERT INTO ronbtf_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Să faceți aceasta: luați cenușare, Core și toată ceata lui; ");
INSERT INTO ronbtf_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","Și puneți foc în ele și puneți tămâie în ele înaintea DOMNULUI mâine și va fi, că bărbatul pe care DOMNUL îl alege, acela va fi sfânt, luați prea mult asupra voastră, voi fii ai lui Levi. ");
INSERT INTO ronbtf_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Și Moise i-a spus lui Core: Ascultați, vă rog, fii ai lui Levi, ");
INSERT INTO ronbtf_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Vi se pare doar un lucru mic, că Dumnezeul lui Israel v-a separat din adunarea lui Israel, ca să vă apropie de el pentru a face serviciul tabernacolului DOMNULUI și să stați în picioare înaintea adunării ca să îi serviți? ");
INSERT INTO ronbtf_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Și te-a apropiat pe tine de el și pe toți frații tăi, fiii lui Levi, cu tine și căutați și preoția? ");
INSERT INTO ronbtf_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Pentru ce motiv tu și toată ceata ta v-ați adunat împotriva DOMNULUI; și ce este Aaron ca să cârtiți împotriva lui? ");
INSERT INTO ronbtf_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Și Moise a trimis să cheme pe Datan și pe Abiram, fiii lui Eliab, care au spus: Nu vom urca; ");
INSERT INTO ronbtf_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Este un lucru mic că tu ne-ai scos dintr-o țară în care curge lapte și miere, să ne ucizi în pustiu, doar ca să te faci prinț peste noi? ");
INSERT INTO ronbtf_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Mai mult, nu ne-ai dus într-o țară în care curge lapte și miere, nici nu ne-ai dat moștenire câmpuri și vii, voiești să scoți ochii acestor oameni? Refuzăm să urcăm. ");
INSERT INTO ronbtf_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Și Moise s-a înfuriat tare și a spus DOMNULUI: Nu lua cunoștință de ofranda lor, nu am luat niciun singur măgar de la ei, nici nu am vătămat pe nimeni dintre ei. ");
INSERT INTO ronbtf_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Și Moise i-a spus lui Core: Tu și toată ceata ta să fiți înaintea DOMNULUI, tu și ei și Aaron, mâine; ");
INSERT INTO ronbtf_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Și să ia fiecare cenușarul său și să pună tămâie în ele și aduceți-le înaintea DOMNULUI, fiecare cenușarul lui, două sute cincizeci de cenușare; și tu și Aaron, fiecare cu cenușarul lui. ");
INSERT INTO ronbtf_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Și ei au luat fiecare cenușarul său și au pus foc în ele și au pus tămâie peste ele și au stat în picioare în ușa tabernacolului întâlnirii, cu Moise și Aaron. ");
INSERT INTO ronbtf_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Și Core a adunat toată adunarea împotriva lor la ușa tabernacolului întâlnirii și gloria DOMNULUI a apărut întregii adunări. ");
INSERT INTO ronbtf_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Și DOMNUL i-a vorbit lui Moise și lui Aaron, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","Separați-vă din mijlocul acestei adunări, ca să îi mistui într-o clipită. ");
INSERT INTO ronbtf_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Și ei au căzut cu fețele lor la pământ și au spus: Dumnezeule, Dumnezeul duhurilor a toată făptura, va păcătui un singur om și te vei înfuria pe toată adunarea? ");
INSERT INTO ronbtf_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","Vorbește adunării, zicând: Ridicați-vă din jurul cortului lui Core, Datan și Abiram. ");
INSERT INTO ronbtf_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Și Moise s-a ridicat și a mers la Datan și Abiram; și bătrânii lui Israel l-au urmat. ");
INSERT INTO ronbtf_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Și a vorbit adunării, spunând: Plecați, vă rog, de lângă corturile acestor bărbați stricați și nu atingeți nimic din ale lor, ca nu cumva să fiți mistuiți în toate păcatele lor. ");
INSERT INTO ronbtf_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Astfel că ei s-au ridicat de lângă cortul lui Core, Datan și Abiram, de fiecare parte; și Datan și Abiram au ieșit și au stat în ușa corturilor lor și soțiile lor și fiii lor și copilașii lor. ");
INSERT INTO ronbtf_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Și Moise a spus: Prin aceasta veți cunoaște că DOMNUL m-a trimis să fac toate aceste lucrări, pentru că nu le-am făcut din mintea mea. ");
INSERT INTO ronbtf_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Dacă acești oameni mor de moartea obișnuită a tuturor oamenilor, sau dacă vor fi cercetați după cercetarea tuturor oamenilor, atunci nu DOMNUL m-a trimis. ");
INSERT INTO ronbtf_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Dar dacă DOMNUL face un lucru nou și pământul își deschide gura și îi înghite, cu tot ceea ce le aparține și coboară de vii în groapă, atunci veți înțelege că acești bărbați au provocat pe DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Și s-a întâmplat, pe când a terminat de vorbit toate aceste cuvinte, că pământul care era sub ei s-a despicat în două, ");
INSERT INTO ronbtf_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Și pământul și-a deschis gura și i-a înghițit și casele lor și pe toți oamenii care au aparținut de Core și toate bunurile lor. ");
INSERT INTO ronbtf_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Ei și tot ce le-a aparținut, au coborât de vii în groapă și pământul s-a închis peste ei; și ei au pierit din mijlocul adunării. ");
INSERT INTO ronbtf_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Și tot Israelul care a fost de jur împrejurul lor a fugit la țipătul lor, căci au spus: Nu cumva pământul să ne înghită și pe noi. ");
INSERT INTO ronbtf_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Și a ieșit un foc de la DOMNUL și a mistuit pe cei două sute cincizeci de bărbați care au oferit tămâie. ");
INSERT INTO ronbtf_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","Vorbește-i lui Eleazar, fiul preotului Aaron, să ridice cenușarele din foc și împrăștie tu focul din ele, pentru că ele sunt sfințite. ");
INSERT INTO ronbtf_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Cenușarele acestor păcătoși păcătuind împotriva propriilor suflete, să le facă tăvi late ca acoperământ al altarului, fiindcă le-au oferit înaintea DOMNULUI, de aceea sunt sfințite; și ele vor fi un semn tuturor copiilor lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Și preotul Eleazar, a luat cenușarele de aramă, cu care au oferit cei ce au fost arși; și au fost făcute tăvi late ca acoperământ al altarului; ");
INSERT INTO ronbtf_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Pentru a fi o amintire copiilor lui Israel, ca niciun străin, care nu este din sămânța lui Aaron, să nu se apropie să ofere tămâie înaintea DOMNULUI; ca să nu fie asemenea lui Core și cetei sale, precum DOMNUL i-a spus prin mâna lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Dar a doua zi toată adunarea copiilor lui Israel a cârtit împotriva lui Moise și Aaron, spunând: Ați ucis poporul DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Și s-a întâmplat, când adunarea s-a strâns împotriva lui Moise și împotriva lui Aaron, că au privit la tabernacolul întâlnirii; și, iată, norul l-a acoperit și gloria DOMNULUI a apărut. ");
INSERT INTO ronbtf_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Și Moise și Aaron au venit înaintea tabernacolului întâlnirii. ");
INSERT INTO ronbtf_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","Ridicați-vă din mijlocul acestei adunări, ca să îi mistui într-o clipită. Iar ei au căzut cu fețele lor la pământ. ");
INSERT INTO ronbtf_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Și Moise i-a spus lui Aaron: Ia un cenușar și pune foc din altar în el și pune tămâie deasupra și mergi repede la adunare și fă ispășire pentru ei, fiindcă a ieșit furie de la DOMNUL; a început plaga. ");
INSERT INTO ronbtf_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Și Aaron a luat precum Moise i-a poruncit și a alergat în mijlocul adunării; și, iată, plaga începuse prin popor; și el a pus tămâie și a făcut ispășire pentru popor. ");
INSERT INTO ronbtf_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Și a stat între cei morți și cei vii; și plaga a fost oprită. ");
INSERT INTO ronbtf_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Acum cei ce au murit prin plagă au fost paisprezece mii șapte sute, pe lângă cei ce au murit din cauza lucrului făcut de Core. ");
INSERT INTO ronbtf_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Și Aaron s-a întors la Moise la ușa tabernacolului întâlnirii și plaga a fost oprită. ");
INSERT INTO ronbtf_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","Vorbește copiilor lui Israel și ia de la fiecare dintre ei un toiag conform casei părinților lor, dintre toți prinții lor conform casei părinților lor douăsprezece toiege; scrie numele fiecărui bărbat pe toiagul său. ");
INSERT INTO ronbtf_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Și să scrii numele lui Aaron pe toiagul lui Levi, pentru ca un singur toiag să fie pentru capul casei părinților lor. ");
INSERT INTO ronbtf_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Și să le pui în tabernacolul întâlnirii înaintea mărturiei, unde mă voi întâlni cu voi. ");
INSERT INTO ronbtf_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Și se va întâmpla, că toiagul bărbatului, pe care îl voi alege, va înflori; și voi face să înceteze dinaintea mea cârtirile copiilor lui Israel, prin care ei cârtesc împotriva voastră. ");
INSERT INTO ronbtf_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Și Moise a vorbit copiilor lui Israel și fiecare dintre prinții lor i-a dat câte un toiag, pentru fiecare prinț un singur toiag, conform cu casele părinților lor, douăsprezece toiege și toiagul lui Aaron era printre toiegele lor. ");
INSERT INTO ronbtf_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Și Moise a pus toiegele înaintea DOMNULUI în tabernacolul mărturiei. ");
INSERT INTO ronbtf_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Și s-a întâmplat, că a doua zi Moise a intrat în tabernacolul mărturiei; și, iată, toiagul lui Aaron pentru casa lui Levi a fost înmugurit și a scos muguri și a înflorit flori și a dat migdale. ");
INSERT INTO ronbtf_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Și Moise a scos afară, dinaintea DOMNULUI, toate toiegele, la toți copiii lui Israel, iar ei au privit și și-a luat fiecare toiagul său. ");
INSERT INTO ronbtf_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Și DOMNUL i-a spus lui Moise: Adu toiagul lui Aaron din nou înaintea mărturiei, să fie ținut ca dovadă împotriva răzvrătiților; și să pui capăt cârtirilor lor față de mine, ca să nu moară. ");
INSERT INTO ronbtf_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Și Moise a făcut precum DOMNUL i-a poruncit, astfel a făcut. ");
INSERT INTO ronbtf_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Și copiii lui Israel i-au spus lui Moise, zicând: Iată, murim, pierim, pierim cu toții. ");
INSERT INTO ronbtf_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Oricine se apropie de tabernacolul DOMNULUI va muri; vom muri cu toții? ");
INSERT INTO ronbtf_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Și DOMNUL i-a spus lui Aaron: Tu și fiii tăi și casa tatălui tău cu tine veți purta nelegiuirea sanctuarului; și tu și fiii tăi cu tine veți purta nelegiuirea preoției voastre. ");
INSERT INTO ronbtf_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Și pe frații tăi de asemenea din tribul lui Levi, tribul tatălui tău, să îi aduci cu tine, ca să se alăture ție și să îți servească, dar tu și fiii tăi cu tine să serviți înaintea tabernacolului mărturiei. ");
INSERT INTO ronbtf_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Iar ei să păzească însărcinarea ta și însărcinarea întregului tabernacol, numai să nu se apropie de vasele sanctuarului și de altar, ca nici ei și nici voi de asemenea, să nu muriți. ");
INSERT INTO ronbtf_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Și să se alăture ție și să păzească însărcinarea tabernacolului întâlnirii, pentru tot serviciul tabernacolului, dar un străin să nu se apropie de voi. ");
INSERT INTO ronbtf_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Și să păziți însărcinarea sanctuarului și însărcinarea altarului, ca să nu mai fie furie peste copiii lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Și eu, iată, am luat pe frații voștri leviți dintre copiii lui Israel, ție îți sunt dați ca un dar pentru DOMNUL, pentru a face serviciul tabernacolului întâlnirii. ");
INSERT INTO ronbtf_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","De aceea tu și fiii tăi cu tine să țineți serviciul vostru preoțesc pentru fiecare lucru al altarului și înăuntrul perdelei; și să serviți, v-am dat serviciul vostru preoțesc ca un serviciu al darului; și străinul care se apropie să fie dat morții. ");
INSERT INTO ronbtf_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Și DOMNUL i-a vorbit lui Aaron: Iată, eu de asemenea ți-am dat însărcinarea ofrandelor mele săltate a tuturor lucrurilor sfințite ale copiilor lui Israel; ți le-am dat ție și fiilor tăi din cauza ungerii, printr-o rânduială pentru totdeauna. ");
INSERT INTO ronbtf_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Aceasta să fie a ta din lucrurile preasfinte, puse deoparte de la foc, fiecare dar al lor, fiecare dar de mâncare al lor și fiecare ofrandă a lor pentru păcat și fiecare ofrandă a lor pentru fărădelege, pe care să mi le aducă din nou, să fie preasfinte pentru tine și pentru fiii tăi. ");
INSERT INTO ronbtf_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","În locul preasfânt să o mănânci; fiecare parte bărbătească să o mănânce, aceasta să îți fie sfântă. ");
INSERT INTO ronbtf_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Și aceasta este a ta, ofranda ridicată din darul lor, cu toate ofrandele legănate ale copiilor lui Israel, ți le-am dat ție și fiilor și fiicelor tale cu tine, printr-un statut pentru totdeauna, oricine este curat în casa ta să mănânce din ele. ");
INSERT INTO ronbtf_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Toată grăsimea untdelemnului și toată grăsimea vinului și a grâului, primele roade ale lor pe care le vor oferi DOMNULUI, pe ele ți le-am dat. ");
INSERT INTO ronbtf_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Și cele dintâi roade coapte în țară, pe care ei le vor aduce DOMNULUI, să fie ale tale; oricine este curat în casa ta să mănânce din ele. ");
INSERT INTO ronbtf_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Orice lucru dedicat în Israel să fie al tău. ");
INSERT INTO ronbtf_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Orice deschide pântecele a toată făptura, pe care ei îl aduc DOMNULUI, fie el de la oameni sau vite, să fie al tău, cu toate acestea întâiul născut al omului să îl răscumperi negreșit și întâiul născut al vitelor necurate să îl răscumperi. ");
INSERT INTO ronbtf_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Și cei ce trebuie răscumpărați de la vârsta de o lună să îi răscumperi conform estimării tale, cu banii a cinci șekeli, după șekelul sanctuarului, care este de douăzeci de ghere. ");
INSERT INTO ronbtf_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Dar întâiul născut al unei vaci, sau întâiul născut al unei oi, sau întâiul născut al unei capre, să nu îl răscumperi; ei sunt sfinți, să stropești sângele lor pe altar și să arzi grăsimea lor ca o ofrandă făcută prin foc, de o aromă dulce DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Și carnea lor să fie a ta, precum sunt ale tale pieptul legănat și spata dreaptă. ");
INSERT INTO ronbtf_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Toate ofrandele săltate din lucrurile sfinte, pe care copiii lui Israel le oferă DOMNULUI, ți le-am dat ție și fiilor tăi și fiicelor tale cu tine, printr-un statut pentru totdeauna, acesta este, pentru totdeauna, un legământ al sării înaintea DOMNULUI, ție și seminței tale cu tine. ");
INSERT INTO ronbtf_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Și DOMNUL i-a vorbit lui Aaron: Să nu ai nicio moștenire în țara lor, nici să nu ai vreo parte în mijlocul lor, eu sunt partea ta și moștenirea ta printre copiii lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Și, iată, am dat copiilor lui Levi toate zeciuielile ca o moștenire, pentru serviciul lor pe care îl servesc, serviciul tabernacolului întâlnirii. ");
INSERT INTO ronbtf_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Nici nu trebuie de aici înainte să se apropie copiii lui Israel de tabernacolul întâlnirii, ca nu cumva să poarte vreun păcat și să moară. ");
INSERT INTO ronbtf_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Ci leviții să facă serviciul tabernacolului întâlnirii și să poarte nelegiuirea lor, acesta să fie un statut pentru totdeauna prin generațiile voastre, ca în mijlocul copiilor lui Israel ei să nu aibă nicio moștenire. ");
INSERT INTO ronbtf_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Dar zeciuielile copiilor lui Israel, pe care ei le aduc ca ofrandă ridicată pentru DOMNUL, le-am dat leviților ca moștenire, de aceea le-am spus: Printre copiii lui Israel ei să nu aibă nicio moștenire. ");
INSERT INTO ronbtf_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","Astfel vorbește leviților și spune-le: Când luați de la copiii lui Israel zeciuielile pe care vi le-am dat de la ei ca moștenire a voastră, atunci să oferiți DOMNULUI o ofrandă ridicată din acestea, adică a zecea parte din zeciuială. ");
INSERT INTO ronbtf_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Și această ofrandă ridicată a voastră vă va fi socotită, ca grânele din aria de vânturat și ca plinătatea teascului de vin. ");
INSERT INTO ronbtf_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Astfel să aduceți de asemenea o ofrandă ridicată pentru DOMNUL din toate zeciuielile voastre, pe care le primiți de la copiii lui Israel; și să dați preotului Aaron din ofranda ridicată pentru DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Din toate darurile voastre să oferiți fiecare ofrandă ridicată pentru DOMNUL, din grăsimea acestora, adică din partea lor sfințită. ");
INSERT INTO ronbtf_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","De aceea să le spui: Când ați ridicat grăsimea lor, atunci aceasta va fi socotită leviților ca venit al ariei de vânturat și ca venit al teascului de vin. ");
INSERT INTO ronbtf_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Și să o mâncați în fiecare loc, voi și cei ai caselor voastre, pentru că aceasta este răsplata voastră pentru serviciul vostru în tabernacolul întâlnirii. ");
INSERT INTO ronbtf_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Și nu veți purta niciun păcat din cauza aceasta, când ați ridicat grăsimea din acestea, nici nu veți pângări lucrurile sfinte ale copiilor lui Israel, ca nu cumva să muriți. ");
INSERT INTO ronbtf_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Și DOMNUL i-a vorbit lui Moise și lui Aaron, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","Aceasta este rânduiala legii pe care DOMNUL a poruncit-o, spunând: Vorbește copiilor lui Israel, ca ei să îți aducă o vițea roșie fără pată, în care nu este cusur și peste care nu s-a pus niciodată jug; ");
INSERT INTO ronbtf_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Și să o dați preotului Eleazar, ca să o scoată în afara taberei și cineva să o înjunghie înaintea feței sale, ");
INSERT INTO ronbtf_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Și preotul Eleazar să ia din sângele ei cu degetul său și să stropească din sângele ei drept înaintea tabernacolului întâlnirii de șapte ori; ");
INSERT INTO ronbtf_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Și cineva să ardă vițeaua înaintea ochilor săi; și pielea ei și carnea ei și sângele ei, cu balega ei, să le ardă; ");
INSERT INTO ronbtf_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Și preotul să ia lemn de cedru și isop și stacojiu și să le arunce în mijlocul arderii vițelei. ");
INSERT INTO ronbtf_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Apoi preotul să își spele hainele și el să își îmbăieze carnea în apă și după aceea să intre în tabără și preotul va fi necurat până seara. ");
INSERT INTO ronbtf_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Și cel ce o arde să își spele hainele în apă și să își îmbăieze carnea în apă și va fi necurat până seara. ");
INSERT INTO ronbtf_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Și un bărbat care este curat să adune cenușa vițelei și să o pună în afara taberei într-un loc curat și să fie ținută pentru adunarea copiilor lui Israel ca apă de separare, aceasta este o curățire pentru păcat. ");
INSERT INTO ronbtf_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Și cel ce adună cenușa vițelei să își spele hainele și să fie necurat până seara și aceasta să fie copiilor lui Israel și străinului care locuiește temporar printre ei, un statut pentru totdeauna. ");
INSERT INTO ronbtf_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Cel ce atinge trupul mort al vreunui om, să fie necurat șapte zile. ");
INSERT INTO ronbtf_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Să se purifice cu această apă în ziua a treia și în ziua a șaptea va fi curat, dar dacă nu se purifică în ziua a treia, atunci în ziua a șaptea nu va fi curat. ");
INSERT INTO ronbtf_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Oricine atinge trupul mort al vreunui om mort și nu se purifică, spurcă tabernacolul DOMNULUI; și acel suflet să fie stârpit din Israel, deoarece apa separării nu a fost stropită peste el, el va fi necurat; necurăția lui este încă peste el. ");
INSERT INTO ronbtf_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Aceasta este legea: când un om moare într-un cort, tot ce intră în cort și tot ce este în cort va fi necurat șapte zile. ");
INSERT INTO ronbtf_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Și orice vas deschis, care nu are acoperământ legat peste el, este necurat. ");
INSERT INTO ronbtf_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Și oricine atinge pe cineva ucis cu o sabie în câmpurile deschise sau un trup mort sau un os al unui om sau un mormânt, va fi necurat șapte zile. ");
INSERT INTO ronbtf_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Și pentru o persoană necurată, ei să ia din cenușa vițelei arse a curățirii pentru păcat, și să se adauge apă curgătoare la aceasta într-un vas. ");
INSERT INTO ronbtf_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Și o persoană curată să ia isop și să îl înmoaie în apă și să o stropească peste cort și peste toate vasele și peste persoanele care erau acolo, și peste cel ce atinge un os sau pe cineva ucis sau pe cineva mort sau un mormânt. ");
INSERT INTO ronbtf_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Și persoana curată să stropească peste cel necurat în ziua a treia și în ziua a șaptea; și în ziua a șaptea să se purifice și să își spele hainele și să se îmbăieze în apă și seara va fi curat. ");
INSERT INTO ronbtf_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Dar bărbatul care va fi necurat și nu se va purifica, acel suflet să fie stârpit din mijlocul adunării, deoarece a spurcat sanctuarul DOMNULUI, apa separării nu a fost stropită peste el, el este necurat. ");
INSERT INTO ronbtf_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Și acesta să le fie un statut continuu, cel ce stropește apa separării să își spele hainele; și cel ce atinge apa separării să fie necurat până seara. ");
INSERT INTO ronbtf_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Și orice atinge persoana necurată va fi necurat; și sufletul care atinge acel lucru să fie necurat până seara. ");
INSERT INTO ronbtf_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Atunci au ajuns copiii lui Israel, adică întreaga adunare, în deșertul Țin, în prima lună, și poporul a locuit în Cades; și acolo a murit Miriam și acolo a fost îngropată. ");
INSERT INTO ronbtf_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Și acolo nu era apă pentru adunare și s-au adunat împotriva lui Moise și împotriva lui Aaron. ");
INSERT INTO ronbtf_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Și poporul s-a certat cu Moise și a vorbit, spunând: De am fi murit când frații noștri au murit înaintea DOMNULUI! ");
INSERT INTO ronbtf_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Și de ce ați adus adunarea DOMNULUI în acest pustiu, ca noi și vitele noastre să murim aici? ");
INSERT INTO ronbtf_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Și de ce ne-ați scos din Egipt pentru a ne aduce în acest loc rău? Nu este loc pentru sămânță sau pentru smochine sau pentru viță sau pentru rodii; nici nu este deloc apă pentru băut. ");
INSERT INTO ronbtf_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Și Moise și Aaron au plecat din prezența adunării la ușa tabernacolului întâlnirii și au căzut cu fețele lor la pământ; și gloria DOMNULUI li s-a arătat. ");
INSERT INTO ronbtf_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Ia toiagul și strânge adunarea la un loc, tu și Aaron fratele tău și vorbiți stâncii înaintea ochilor lor; și ea va da apa ei, iar tu să le aduci apă din stâncă, astfel să dai adunării și vitelor lor să bea. ");
INSERT INTO ronbtf_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Și Moise a luat toiagul de dinaintea DOMNULUI, precum i-a poruncit. ");
INSERT INTO ronbtf_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Și Moise și Aaron au strâns adunarea la un loc înaintea stâncii și el le-a spus: Ascultați acum, răzvrătiților; trebuie să vă aducem apă din această stâncă? ");
INSERT INTO ronbtf_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Și Moise și-a ridicat mâna și cu toiagul său a lovit stânca de două ori și apa a ieșit afară din abundență, și adunarea a băut și vitele lor la fel. ");
INSERT INTO ronbtf_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Și DOMNUL i-a vorbit lui Moise și lui Aaron: Deoarece nu m-ați crezut, pentru a mă sfinți în ochii copiilor lui Israel, de aceea nu veți duce această adunare în țara pe care le-am dat-o. ");
INSERT INTO ronbtf_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Acestea sunt apele Meriba, pentru că copiii lui Israel s-au certat cu DOMNUL și el a fost sfințit în ei. ");
INSERT INTO ronbtf_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Și Moise a trimis mesageri de la Cades la împăratul din Edom: Astfel spune fratele tău Israel: Tu cunoști toată durerea căzută peste noi; ");
INSERT INTO ronbtf_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Cum părinții noștri au coborât în Egipt și am locuit în Egipt o lungă perioadă de timp; și egiptenii ne-au chinuit pe noi și pe părinții noștri; ");
INSERT INTO ronbtf_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Și când am strigat către DOMNUL, el a ascultat vocea noastră și a trimis un înger și ne-a scos afară din Egipt; și, iată, noi suntem în Cades, o cetate la marginea graniței tale; ");
INSERT INTO ronbtf_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Lasă-ne să trecem, te rog, prin țara ta, nu vom trece nici prin câmpuri, nici prin vii, nici nu vom bea din apa fântânilor, vom merge pe drumul mare al împăratului, nu ne vom abate nici la dreapta nici la stânga, până ce vom fi trecut de granițele tale. ");
INSERT INTO ronbtf_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Și Edom i-a spus: Să nu treci pe la mine ca nu cumva să ies împotriva ta cu sabia. ");
INSERT INTO ronbtf_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Și copiii lui Israel i-au spus: Vom merge pe drumul mare și dacă eu și vitele mele beau din apa ta, atunci voi plăti pentru ea; voi trece doar prin țară, cu piciorul, fără să fac niciun alt lucru. ");
INSERT INTO ronbtf_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Și el a spus: Să nu treci. Și Edom a ieșit împotriva lui cu mult popor și cu mână tare. ");
INSERT INTO ronbtf_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Astfel Edom a refuzat să lase pe Israel să treacă prin granița sa, pentru aceasta Israel s-a abătut de la el. ");
INSERT INTO ronbtf_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Și copiii lui Israel și întreaga adunare, au călătorit de la Cades și au ajuns la muntele Hor. ");
INSERT INTO ronbtf_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Și DOMNUL i-a vorbit lui Moise și Aaron, în muntele Hor, la granița țării lui Edom, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Aaron va fi adunat la poporul său, pentru că nu va intra în țara pe care eu am dat-o copiilor lui Israel, pentru că v-ați răzvrătit împotriva cuvântului meu la apele Meriba. ");
INSERT INTO ronbtf_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Ia pe Aaron și pe Eleazar, fiul său, și urcă-i la muntele Hor; ");
INSERT INTO ronbtf_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Și dezbracă pe Aaron de veștmintele sale și îmbracă-l cu ele pe Eleazar fiul său; și Aaron va fi adunat la poporul său și va muri acolo. ");
INSERT INTO ronbtf_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Și Moise a făcut precum DOMNUL i-a poruncit, și ei au urcat pe muntele Hor înaintea ochilor întregii adunări. ");
INSERT INTO ronbtf_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Și Moise a dezbrăcat pe Aaron de veștmintele sale și l-a îmbrăcat pe Eleazar, fiul său, cu ele; și Aaron a murit acolo în vârful muntelui, iar Moise și Eleazar au coborât de pe munte. ");
INSERT INTO ronbtf_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Și când toată adunarea a văzut că Aaron a murit, toată casa lui Israel a jelit pentru Aaron, treizeci de zile. ");
INSERT INTO ronbtf_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Și când împăratul Arad canaanitul, care locuia în sud, a auzit spunându-se că Israel vine pe calea spionilor, atunci a luptat împotriva lui Israel și a luat pe unii din ei prizonieri. ");
INSERT INTO ronbtf_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Și Israel a făcut un jurământ DOMNULUI și a spus: Dacă vei da negreșit pe acest popor în mâna mea, atunci voi distruge cu totul cetățile lor. ");
INSERT INTO ronbtf_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Și DOMNUL a dat ascultare vocii lui Israel și i-a dat pe canaaniți în mâna lor; și i-au distrus cu totul pe ei și cetățile lor; și a pus acelui loc numele, Horma. ");
INSERT INTO ronbtf_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Și au călătorit de la muntele Hor pe calea Mării Roșii, să ocolească țara lui Edom, și sufletul poporului a fost mult descurajat din cauza drumului. ");
INSERT INTO ronbtf_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Și poporul a vorbit împotriva lui Dumnezeu și împotriva lui Moise, spunând: Pentru aceasta ne-ați făcut să ne urcăm din Egipt, ca să murim în pustiu? Căci nu este nici pâine, nici urmă de apă; și sufletul nostru detestă această pâine ușoară. ");
INSERT INTO ronbtf_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Și DOMNUL a trimis șerpi înfocați în mijlocul poporului și au mușcat poporul și mult popor din Israel a murit. ");
INSERT INTO ronbtf_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","De aceea poporul a venit la Moise și a spus: Am păcătuit, fiindcă am vorbit împotriva DOMNULUI și împotriva ta; roagă-te DOMNULUI, ca să îndepărteze șerpii de la noi. Și Moise s-a rugat pentru popor. ");
INSERT INTO ronbtf_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Și DOMNUL i-a spus lui Moise: Fă-ți un șarpe înfocat și pune-l pe o prăjină și se va întâmpla, că fiecare om mușcat, când îl privește, va trăi. ");
INSERT INTO ronbtf_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Și Moise a făcut un șarpe din aramă și l-a pus pe o prăjină și s-a întâmplat, că dacă un șarpe a mușcat pe cineva, când acesta a privit șarpele de aramă, a trăit. ");
INSERT INTO ronbtf_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Și copiii lui Israel au mers înainte și au așezat corturile în Obot. ");
INSERT INTO ronbtf_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Și au călătorit de la Obot și au așezat corturile la Iie-Abarim, în pustiul care este înaintea lui Moab, spre răsăritul soarelui. ");
INSERT INTO ronbtf_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","De acolo s-au mutat și au așezat corturile în valea Zered. ");
INSERT INTO ronbtf_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","De acolo s-au mutat și au așezat corturile de partea cealaltă a Arnonului, care este în pustiul care iese din ținuturile amoriților, pentru că Arnon este granița lui Moab, între Moab și amoriți. ");
INSERT INTO ronbtf_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Pentru aceasta s-a spus în cartea războaielor DOMNULUI: Ce a făcut în Marea Roșie și în pâraiele Arnonului, ");
INSERT INTO ronbtf_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","Și la scurgerile pâraielor care coboară în jos la locuința lui Ar și se întinde peste granița lui Moab. ");
INSERT INTO ronbtf_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Și de acolo au mers la Beer, care este fântâna despre care DOMNUL i-a vorbit lui Moise: Adună poporul la un loc și le voi da apă. ");
INSERT INTO ronbtf_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Atunci Israel a cântat această cântare: Înalță-te fântână; cântați-i voi, ");
INSERT INTO ronbtf_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Prinții au săpat fântâna, nobilii poporului au săpat-o, sub conducerea legiuitorului, cu toiegele lor. Și din pustie au mers la Matana; ");
INSERT INTO ronbtf_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Și de la Matana la Nahaliel; și de la Nahaliel la Bamot. ");
INSERT INTO ronbtf_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Și de la Bamot în valea care este în ținutul lui Moab, la vârful Pisga, care privește spre Ieșimon. ");
INSERT INTO ronbtf_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Și Israel a trimis mesageri la Sihon împăratul amoriților, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","Lasă-mă să trec prin țara ta, nu ne vom abate în câmpuri sau în vii; nu vom bea apa din fântâni, ci vom merge înainte pe drumul mare al împăratului, până ce vom fi trecut de granițele tale. ");
INSERT INTO ronbtf_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Și Sihon nu a permis lui Israel să treacă peste granița sa, ci Sihon a adunat tot poporul său și a ieșit împotriva lui Israel în pustiu și a venit la Iahaț și a luptat împotriva lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Și Israel l-a lovit cu tăișul sabiei și a stăpânit țara lui de la Arnon până la Iaboc, chiar până la copiii lui Amon, fiindcă granița copiilor lui Amon era puternică. ");
INSERT INTO ronbtf_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Și Israel a luat toate aceste cetăți și Israel a locuit în toate cetățile amoriților, în Hesbon și în toate satele lor. ");
INSERT INTO ronbtf_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Fiindcă Hesbon era cetatea lui Sihon, împăratul amoriților, care luptase împotriva împăratului de dinainte al lui Moab, și îi luase toată țara din mână, până la Arnon. ");
INSERT INTO ronbtf_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Pentru aceasta cei ce vorbesc în proverbe spun: Veniți la Hesbon, să se zidească și să se pregătească cetatea lui Sihon; ");
INSERT INTO ronbtf_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Fiindcă un foc a ieșit din Hesbon, o flacără din cetatea lui Sihon, aceasta a mistuit Arul Moabului și pe căpeteniile înălțimilor din Arnon. ");
INSERT INTO ronbtf_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Vai ție, Moab, ești adus la nimic, popor al lui Chemoș! El a dat pe fiii săi și pe fiicele sale, care au scăpat, în captivitate la Sihon, împăratul amoriților. ");
INSERT INTO ronbtf_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Am tras asupra lor; Hesbon a pierit chiar până la Dibon și i-am pustiit chiar până la Nofah, care ajunge până la Mediba. ");
INSERT INTO ronbtf_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Astfel Israel a locuit în țara amoriților. ");
INSERT INTO ronbtf_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Și Moise a trimis să spioneze Iaezerul și ei au luat satele lor și au alungat pe amoriții care erau acolo. ");
INSERT INTO ronbtf_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Și s-au întors și au urcat pe calea din Basan; și Og, împăratul Basanului, a ieșit împotriva lor, el și tot poporul său, la bătălia de la Edrei. ");
INSERT INTO ronbtf_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Și DOMNUL i-a spus lui Moise: Nu te teme de el, căci l-am dat în mâna ta, pe el și pe tot poporul lui și țara lui; și să îi faci cum i-ai făcut lui Sihon, împăratul amoriților, care a locuit la Hesbon. ");
INSERT INTO ronbtf_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Astfel că l-au lovit pe el și pe fiii săi și pe tot poporul său, până ce nu a mai fost lăsat niciunul în viață și ei i-au stăpânit țara. ");
INSERT INTO ronbtf_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Și copiii lui Israel au plecat și au așezat corturile în câmpiile lui Moab de partea aceasta a Iordanului lângă Ierihon. ");
INSERT INTO ronbtf_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Și Balac, fiul lui Țipor, a văzut tot ceea ce Israel făcuse amoriților. ");
INSERT INTO ronbtf_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Și Moab a fost foarte înfricoșat de popor, pentru că erau mulți, și Moab s-a tulburat din cauza copiilor lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Și Moab le-a spus bătrânilor lui Madian: Acum, această mulțime va linge pe toți cei ce sunt de jur împrejurul nostru, precum boul linge iarba câmpului. Și Balac, fiul lui Țipor, era împăratul moabiților în acel timp. ");
INSERT INTO ronbtf_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","De aceea a trimis mesageri la Balaam, fiul lui Beor, la Petor, care este lângă râul din țara copiilor poporului său, pentru a-l chema, spunând: Iată, a ieșit un popor din Egipt; iată, ei acoperă fața pământului și s-au așezat înaintea mea; ");
INSERT INTO ronbtf_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Vino, te rog, blestemă-mi pe acest popor, (căci ei sunt prea puternici pentru mine, poate că voi învinge;) ca să îi batem și ca să îi alungăm din țară; căci știu că pe cine binecuvântezi tu, este binecuvântat, și pe cine blestemi tu, este blestemat. ");
INSERT INTO ronbtf_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Și bătrânii lui Moab și bătrânii lui Madian au plecat cu răsplățile pentru ghicire în mâna lor; și au venit la Balaam și i-au spus cuvintele lui Balac. ");
INSERT INTO ronbtf_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Și el le-a spus: Rămâneți aici în această noapte și vă voi aduce vorbă din nou, precum DOMNUL îmi va vorbi și prinții lui Moab au rămas cu Balaam. ");
INSERT INTO ronbtf_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Și Dumnezeu a venit la Balaam și a spus: Cine sunt acești oameni găzduiți la tine? ");
INSERT INTO ronbtf_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Și Balaam i-a spus lui Dumnezeu: Balac, fiul lui Țipor, împăratul lui Moab, a trimis la mine, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Iată, a ieșit din Egipt un popor care acoperă fața pământului, vino acum, blestemă-i pentru mine; poate că voi fi în stare să îi înving și să îi alung. ");
INSERT INTO ronbtf_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Și Dumnezeu i-a spus lui Balaam: Să nu mergi cu ei; să nu blestemi poporul, pentru că ei sunt binecuvântați. ");
INSERT INTO ronbtf_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Și Balaam s-a sculat dimineața și a spus prinților lui Balac: Întoarceți-vă în țara voastră, pentru că DOMNUL refuză să îmi dea voie să merg cu voi. ");
INSERT INTO ronbtf_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Și prinții lui Moab s-au ridicat și au mers la Balac și au spus: Balaam refuză să vină cu noi. ");
INSERT INTO ronbtf_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Și Balac a trimis din nou prinți, mai mulți și demni de mai multă cinste decât ceilalți. ");
INSERT INTO ronbtf_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Și ei au venit la Balaam și i-au spus: Astfel spune Balac, fiul lui Țipor: Te rog, nu lăsa nimic să te împiedice de a veni la mine; ");
INSERT INTO ronbtf_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Pentru că foarte mult te voi onora și voi face orice îmi spui, vino de aceea, te rog, blestemă-mi acest popor. ");
INSERT INTO ronbtf_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Și Balaam a răspuns și a spus servitorilor lui Balac: Dacă Balac mi-ar da casa lui plină de argint și aur, eu nu pot trece peste cuvântul DOMNULUI Dumnezeul meu, pentru a face mai puțin sau mai mult. ");
INSERT INTO ronbtf_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","De aceea acum, vă rog, rămâneți și voi aici în această noapte, ca să știu ce îmi va spune mai mult DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Și Dumnezeu a venit la Balaam în timpul nopții și i-a spus: Dacă bărbații vin să te cheme, scoală-te și du-te cu ei; dar totuși cuvântul pe care ți-l voi spune: Acela să îl faci. ");
INSERT INTO ronbtf_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Și Balaam s-a sculat dimineața și și-a înșeuat măgărița și a mers cu prinții lui Moab. ");
INSERT INTO ronbtf_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Și mânia lui Dumnezeu s-a aprins pentru că el s-a dus și îngerul DOMNULUI a stat în picioare pe cale ca potrivnic împotriva lui. Acum el călărea pe măgărița sa și cei doi servitori ai lui erau cu el. ");
INSERT INTO ronbtf_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Și măgărița a văzut îngerul DOMNULUI stând în picioare pe cale și sabia lui trasă în mâna sa și măgărița s-a abătut afară de pe cale și a intrat în câmp; și Balaam a lovit măgărița să o întoarcă pe cale. ");
INSERT INTO ronbtf_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Dar îngerul DOMNULUI a stat pe o cărare a viilor, un zid fiind de această parte și un zid de cealaltă parte. ");
INSERT INTO ronbtf_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Și când măgărița a văzut îngerul DOMNULUI, s-a trântit de zid și a turtit piciorul lui Balaam de zid și el a lovit-o din nou. ");
INSERT INTO ronbtf_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Și îngerul DOMNULUI a mers mai departe și a stat în picioare într-un loc strâmt, unde nu era drum să întorci nici la dreapta nici la stânga. ");
INSERT INTO ronbtf_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Și când măgărița a văzut pe îngerul DOMNULUI, a căzut sub Balaam și mânia lui Balaam s-a aprins și el a lovit măgărița cu un toiag. ");
INSERT INTO ronbtf_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Și DOMNUL a deschis gura măgăriței și ea a spus lui Balaam: Ce ți-am făcut, că m-ai lovit de aceste trei ori? ");
INSERT INTO ronbtf_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Și Balaam a spus măgăriței: Pentru că m-ai batjocorit, de ar fi fost o sabie în mâna mea te-aș fi ucis chiar acum. ");
INSERT INTO ronbtf_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Iar măgărița i-a spus lui Balaam: Nu sunt eu măgărița ta, pe care ai călărit de când am fost a ta până în această zi? Obișnuiam vreodată să îți fac astfel? Iar el a spus: Nu. ");
INSERT INTO ronbtf_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Atunci DOMNUL a deschis ochii lui Balaam și el a văzut pe îngerul DOMNULUI stând în picioare pe cale și sabia lui trasă în mâna lui și și-a plecat capul și s-a aruncat cu fața sa la pământ. ");
INSERT INTO ronbtf_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Și îngerul DOMNULUI i-a spus: Pentru ce ți-ai lovit măgărița de aceste trei ori? Iată, am ieșit să stau împotriva ta, deoarece calea ta este perversă înaintea mea, ");
INSERT INTO ronbtf_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Și măgărița m-a văzut și s-a abătut de la mine de aceste trei ori, dacă nu s-ar fi abătut de la mine, cu siguranță te-aș fi ucis și pe ea aș fi lăsat-o vie. ");
INSERT INTO ronbtf_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Și Balaam a spus îngerului DOMNULUI: Am păcătuit, pentru că nu am știut că stai în cale împotriva mea; acum de aceea dacă aceasta te nemulțumește, mă voi întoarce înapoi. ");
INSERT INTO ronbtf_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Și îngerul DOMNULUI i-a spus lui Balaam: Du-te cu acești bărbați, dar numai cuvântul pe care ți-l voi spune, acela să îl vorbești. Astfel Balaam a mers cu prinții lui Balac. ");
INSERT INTO ronbtf_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Și când Balac a auzit că a venit Balaam, a ieșit să îl întâlnească la o cetate a lui Moab, care este pe granița Arnonului, care este în ținutul cel mai îndepărtat. ");
INSERT INTO ronbtf_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Și Balac i-a spus lui Balaam: Nu am trimis la tine cu stăruință ca să te cheme? Pentru ce nu ai venit la mine? Nu sunt eu în stare să te onorez? ");
INSERT INTO ronbtf_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Și Balaam i-a spus lui Balac: Iată, am venit la tine, am eu vreo putere în vreun fel să spun ceva? cuvântul pe care Dumnezeu îl pune în gura mea, aceea voi vorbi. ");
INSERT INTO ronbtf_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Și Balaam a mers cu Balac și au venit la Chiriat-Huțot. ");
INSERT INTO ronbtf_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Și Balac a oferit boi și oi și a trimis la Balaam și la prinții care erau cu el. ");
INSERT INTO ronbtf_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Și s-a întâmplat, a doua zi, că Balac a luat pe Balaam și l-a urcat la înălțimile lui Baal, ca de acolo să vadă până și cea mai îndepărtată margine a poporului. ");
INSERT INTO ronbtf_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Și Balaam i-a spus lui Balac: Zidește-mi aici șapte altare și pregătește-mi aici șapte boi și șapte berbeci. ");
INSERT INTO ronbtf_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Și Balac a făcut cum spusese Balaam; și Balac și Balaam au oferit pe fiecare altar un taur și un berbec. ");
INSERT INTO ronbtf_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Și Balaam i-a spus lui Balac: Stai în picioare lângă ofranda ta arsă și eu voi merge, poate cumva DOMNUL va veni să mă întâlnească și orice îmi va arăta îți voi spune. Și el a mers la un loc înalt. ");
INSERT INTO ronbtf_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Și Dumnezeu a întâlnit pe Balaam, iar el i-a spus: Am pregătit șapte altare și am oferit pe fiecare altar un taur și un berbec. ");
INSERT INTO ronbtf_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Și DOMNUL a pus cuvânt în gura lui Balaam și a spus: Întoarce-te la Balac și astfel să vorbești. ");
INSERT INTO ronbtf_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Și s-a întors la el și, iată, el stătea în picioare lângă ofranda lui arsă, el și toți prinții lui Moab. ");
INSERT INTO ronbtf_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Și și-a rostit parabola și a spus: Balac împăratul lui Moab m-a adus din Aram, din munții din est, spunând: Vino, blestemă-mi pe Iacob și vino, sfidează pe Israel. ");
INSERT INTO ronbtf_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Cum să blestem, pe cel pe care Dumnezeu nu l-a blestemat? Sau cum să sfidez, pe cel pe care DOMNUL nu l-a sfidat? ");
INSERT INTO ronbtf_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Pentru că din vârful stâncilor îl văd și de pe dealuri îl privesc, iată, poporul va locui singur și nu va fi socotit printre națiuni. ");
INSERT INTO ronbtf_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Cine poate număra pulberea lui Iacob și numărul celei de a patra părți a lui Israel? Lasă-mă să mor moartea celor drepți și sfârșitul meu să fie ca al lui! ");
INSERT INTO ronbtf_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Și Balac i-a spus lui Balaam: Ce mi-ai făcut? Te-am luat ca să blestemi pe dușmanii mei și, iată, tu i-ai binecuvântat cu totul. ");
INSERT INTO ronbtf_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Și el a răspuns și a zis: Nu trebuie să iau seama să vorbesc ceea ce DOMNUL a pus în gura mea? ");
INSERT INTO ronbtf_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Și Balac i-a spus: Vino cu mine, te rog, la un alt loc, de unde să îi vezi, vei vedea până la cea mai îndepărtată margine a lor, dar nu îi vei vedea pe toți; și blestemă-i pentru mine de acolo. ");
INSERT INTO ronbtf_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Și l-a dus în câmpul lui Țofim, pe vârful Pisga; și a zidit șapte altare și a oferit un taur și un berbec pe fiecare altar. ");
INSERT INTO ronbtf_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Și i-a spus lui Balac: Stai aici în picioare lângă ofranda ta arsă, în timp ce eu mă voi întâlni cu DOMNUL mai încolo. ");
INSERT INTO ronbtf_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Și DOMNUL a întâlnit pe Balaam și a pus un cuvânt în gura lui și a spus: Du-te din nou la Balac și spune astfel. ");
INSERT INTO ronbtf_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Și când a venit la el, iată, el stătea lângă ofranda sa arsă și prinții lui Moab stăteau cu el. Și Balac i-a spus: Ce a vorbit DOMNUL? ");
INSERT INTO ronbtf_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Iar el și-a rostit parabola și a spus: Ridică-te Balac și ascultă; dă-mi ascultare, tu, fiul lui Țipor, ");
INSERT INTO ronbtf_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Dumnezeu nu este om ca să mintă; nici fiu al omului ca să se pocăiască; a spus el și nu va face, sau a vorbit și nu va împlini? ");
INSERT INTO ronbtf_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Iată, eu am primit poruncă să binecuvântez și el a binecuvântat; iar eu nu pot întoarce aceasta. ");
INSERT INTO ronbtf_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","El nu a zărit nelegiuirea în Iacob, nici nu a văzut stricăciune în Israel; DOMNUL Dumnezeul său este cu el și strigătul unui împărat este printre ei. ");
INSERT INTO ronbtf_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Dumnezeu i-a scos din Egipt; el are putere precum un unicorn. ");
INSERT INTO ronbtf_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Cu adevărat nu este niciun farmec împotriva lui Iacob, nici nu este nicio ghicire împotriva lui Israel; referitor la acest timp se va spune despre Iacob și despre Israel: Ce a lucrat Dumnezeu! ");
INSERT INTO ronbtf_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Iată, poporul se va ridica asemenea unui leu mare și se va înălța ca un leu tânăr; nu se va întinde până nu va mânca din pradă și nu va bea sângele celor uciși. ");
INSERT INTO ronbtf_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Și Balac i-a spus lui Balaam: Nici nu îi blestema dar nici nu îi binecuvânta. ");
INSERT INTO ronbtf_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Dar Balaam a răspuns și i-a zis lui Balac: Nu ți-am vorbit, spunând: Tot ceea ce DOMNUL vorbește, aceea trebuie să fac? ");
INSERT INTO ronbtf_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Și Balac i-a spus lui Balaam: Vino, te rog, te voi duce într-un alt loc; poate cumva îi va plăcea lui Dumnezeu să mi-i blestemi de acolo. ");
INSERT INTO ronbtf_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Și Balac a adus pe Balaam pe vârful Peor, care privește spre Ieșimon. ");
INSERT INTO ronbtf_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Și Balaam i-a spus lui Balac: Zidește-mi aici șapte altare și pregătește-mi aici șapte tauri și șapte berbeci. ");
INSERT INTO ronbtf_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Și Balac a făcut cum spusese Balaam și a oferit un taur și un berbec pe fiecare altar. ");
INSERT INTO ronbtf_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Și când Balaam a văzut că îi era plăcut DOMNULUI a binecuvânta pe Israel, nu a mai ieșit, ca în alte dăți, ca să caute farmece, ci și-a îndreptat fața spre pustiu. ");
INSERT INTO ronbtf_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Și Balaam și-a ridicat ochii și a văzut pe Israel locuind în corturile lor după semințiile lor; și duhul lui Dumnezeu a venit peste el. ");
INSERT INTO ronbtf_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Și și-a rostit parabola și a spus: Balaam, fiul lui Beor, a zis; și bărbatul ai cărui ochi sunt deschiși a spus: ");
INSERT INTO ronbtf_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","El a zis: El care a auzit cuvintele lui Dumnezeu, care a văzut viziunea celui Atotputernic, în timp ce cădea în transă, dar având ochii deschiși; ");
INSERT INTO ronbtf_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Ce frumoase sunt corturile tale, Iacobe și locașurile tale, Israele! ");
INSERT INTO ronbtf_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Ca văile se întind, ca grădini la malul râului, ca pomii de aloe pe care DOMNUL i-a sădit și ca cedri lângă ape. ");
INSERT INTO ronbtf_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","El va turna apa din gălețile sale și sămânța sa va fi în multe ape și împăratul său se va înălța mai sus ca Agag și împărăția lui va fi înălțată. ");
INSERT INTO ronbtf_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Dumnezeu l-a scos din Egipt; el are putere precum a unui unicorn; va mânca națiunile, ai săi dușmani, și le va frânge oasele și îi va străpunge cu săgețile lui. ");
INSERT INTO ronbtf_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Se ghemuiește, se culcă asemenea unui leu și asemenea unei leoaice mari, cine îl va stârni? Binecuvântat este cel ce te binecuvântează și blestemat este cel ce te blestemă. ");
INSERT INTO ronbtf_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Și mânia lui Balac s-a aprins împotriva lui Balaam și și-a lovit palmele; și Balac i-a spus lui Balaam: Te-am chemat să blestemi pe dușmanii mei și, iată, i-ai binecuvântat cu totul de aceste trei dăți. ");
INSERT INTO ronbtf_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","De aceea fugi la locul tău, m-am gândit să te onorez foarte mult; dar, iată, DOMNUL te-a oprit de la onoare. ");
INSERT INTO ronbtf_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Și Balaam i-a spus lui Balac: Nu am vorbit eu mesagerilor tăi pe care i-ai trimis, zicând: ");
INSERT INTO ronbtf_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Și dacă Balac mi-ar da casa lui plină de argint și aur, nu pot trece peste porunca DOMNULUI să fac din propria mea minte, fie bine fie rău; să nu vorbesc ceea ce spune DOMNUL? ");
INSERT INTO ronbtf_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Și acum, iată, merg la poporul meu, vino și te voi anunța ce are să facă acest popor poporului tău în zilele de pe urmă. ");
INSERT INTO ronbtf_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Și și-a rostit parabola și a spus: Balaam, fiul lui Beor, a zis și bărbatul ai cărui ochi sunt deschiși a zis: ");
INSERT INTO ronbtf_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","El a spus: El care a auzit cuvintele lui Dumnezeu și a știut cunoașterea celui Preaînalt, care a văzut viziunea celui Atotputernic, în timp ce cădea în transă, dar având ochii săi deschiși; ");
INSERT INTO ronbtf_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Îl voi vedea, dar nu acum; îl voi privi, dar nu de aproape; o Stea va ieși din Iacob și un Sceptru se va ridica din Israel și va lovi colțurile lui Moab și va nimici pe toți copiii lui Set. ");
INSERT INTO ronbtf_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Și Edom va fi o stăpânire, Seir de asemenea va fi o stăpânire pentru dușmanii săi; și Israel va lucra vitejește. ");
INSERT INTO ronbtf_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Din Iacob va veni cel ce va avea stăpânire și va nimici pe cel ce rămâne în cetate. ");
INSERT INTO ronbtf_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Și când a privit la Amalec și-a rostit parabola și a spus: Amalec a fost cel dintâi între națiuni; dar sfârșitul său de pe urmă va fi pieirea veșnică. ");
INSERT INTO ronbtf_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Și a privit la cheniți și și-a rostit parabola și a spus: Tare este locuința ta și cuibul tău îl pui într-o stâncă. ");
INSERT INTO ronbtf_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Totuși cheniții vor fi pustiiți, până ce Așur te va duce captiv. ");
INSERT INTO ronbtf_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Și și-a rostit parabola și a spus: Vai, cine va trăi când Dumnezeu face aceasta! ");
INSERT INTO ronbtf_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Și corăbii vor veni de pe țărmul Chitimului și vor chinui pe Așur și vor chinui pe Eber și va pieri și el pentru totdeauna. ");
INSERT INTO ronbtf_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Și Balaam s-a ridicat și a plecat și s-a întors la locul său; și Balac de asemenea a plecat pe drumul său. ");
INSERT INTO ronbtf_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Și Israel a locuit în Sitim și poporul a început să curvească cu fiicele lui Moab. ");
INSERT INTO ronbtf_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Și ei au chemat poporul la sacrificiile dumnezeilor lor; și poporul a mâncat și s-a prosternat dumnezeilor lor. ");
INSERT INTO ronbtf_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Și Israel s-a alăturat de Baal-Peor și mânia DOMNULUI s-a aprins împotriva lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Şi DOMNUL i-a spus lui Moise: Ia pe toate căpeteniile poporului şi spânzură-le înaintea DOMNULUI în faţa soarelui, ca mânia înverşunată a DOMNULUI să se abată de la Israel. ");
INSERT INTO ronbtf_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Și Moise a spus judecătorilor lui Israel: Fiecare să ucidă pe oamenii săi care s-au alipit de Baal-Peor. ");
INSERT INTO ronbtf_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Și, iată, unul dintre copiii lui Israel a venit și a adus, la frații săi, o femeie madianită, înaintea ochilor lui Moise și înaintea ochilor întregii adunări a copiilor lui Israel, care plângeau înaintea ușii tabernacolului întâlnirii. ");
INSERT INTO ronbtf_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Și când Fineas, fiul lui Eleazar, fiul preotului Aaron, a văzut, s-a ridicat din mijlocul adunării și a luat o lance în mâna sa; ");
INSERT INTO ronbtf_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","Și a mers după bărbatul lui Israel în cort și i-a străpuns pe amândoi, pe bărbatul din Israel și pe femeie prin pântecele ei. Astfel plaga a fost oprită de la copiii lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Și cei ce au murit în plagă au fost douăzeci și patru de mii. ");
INSERT INTO ronbtf_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","Fineas, fiul lui Eleazar, fiul preotului Aaron, a abătut furia mea de la copiii lui Israel, în timp ce era zelos pentru mine, printre ei, astfel că nu am mistuit pe copiii lui Israel în gelozia mea. ");
INSERT INTO ronbtf_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Pentru aceasta spune: Iată, îi dau legământul meu de pace, ");
INSERT INTO ronbtf_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Și să îl aibă el și sămânța lui după el, chiar legământul unei preoții veșnice, pentru că a fost zelos pentru Dumnezeul său și a făcut ispășire pentru copiii lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Și numele israelitului care a fost ucis, adică cel ucis împreună cu femeia madianită, era Zimri, fiul lui Salu, un prinț al unei case părintești printre simeoniți. ");
INSERT INTO ronbtf_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Și numele femeii madianite care a fost ucisă era Cozbi, fiica lui Țur; el era cap peste un popor și a unei case părintești în Madian. ");
INSERT INTO ronbtf_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","Vatămă-i pe madianiți și lovește-i; ");
INSERT INTO ronbtf_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","Pentru că ei te-au vătămat cu uneltirile lor, cu care te-au înșelat în lucrarea lui Peor și în lucrarea lui Cozbi, fiica unui prinț din Madian, sora lor, care a fost ucisă în ziua plăgii, venite din cauza lui Peor. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Și s-a întâmplat după plagă, că DOMNUL i-a vorbit lui Moise și lui Eleazar, fiul preotului Aaron, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","Faceți numărătoarea întregii adunări a copiilor lui Israel, de la vârsta de douăzeci de ani în sus, prin toată casa părinților lor, toți cei ce sunt în stare să meargă la război în Israel. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Și Moise și preotul Eleazar au vorbit cu ei în câmpiile lui Moab, lângă Iordan, aproape de Ierihon, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","Faceți numărătoarea poporului, de la vârsta de douăzeci de ani în sus; precum DOMNUL i-a poruncit lui Moise și copiilor lui Israel care au ieșit din țara Egiptului. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Ruben, fiul cel mai în vârstă al lui Israel: copiii lui Ruben; Hanoc, din care iese familia hanochiților; din Palu, familia paluiților; ");
INSERT INTO ronbtf_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Din Hețron, familia hețroniților; din Carmi, familia carmiților. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Acestea sunt familiile rubeniților și cei numărați dintre ei erau patruzeci și trei de mii șapte sute treizeci. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Și fiii lui Palu: Eliab. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Și fiii lui Eliab: Nemuel și Datan și Abiram. Acesta este acel Datan și Abiram, faimoși în adunare, care au luptat împotriva lui Moise și împotriva lui Aaron în ceata lui Core, când s-au luptat împotriva DOMNULUI; ");
INSERT INTO ronbtf_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Și pământul și-a deschis gura și i-a înghițit împreună cu Core, când acea ceată a murit, în timp ce focul mistuia două sute cincizeci de bărbați; și ei au devenit un semn. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Cu toate acestea copiii lui Core nu au murit. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Fiii lui Simeon după familiile lor: din Nemuel, familia nemueliților; din Iamin, familia iaminiților; din Iachin, familia iachiniților; ");
INSERT INTO ronbtf_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Din Zerah, familia zerahiților; din Saul, familia sauliților. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Acestea sunt familiile simeoniților, douăzeci și două de mii două sute. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Fiii lui Gad după familiile lor: din Țefon, familia țefoniților; din Haghi, familia haghiților; din Șuni, familia șuniților; ");
INSERT INTO ronbtf_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Din Ozni, familia ozniților; din Eri, familia eriților; ");
INSERT INTO ronbtf_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Din Arod, familia arodiților; din Areli, familia areliților. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Acestea sunt familiile copiilor lui Gad conform cu cei numărați dintre ei, patruzeci de mii cinci sute. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Fiii lui Iuda: Er și Onan; și Er și Onan au murit în țara lui Canaan. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Și fiii lui Iuda după familiile lor au fost: din Șela, familia șelaniților; din Pereț, familia perețiților; din Zerah, familia zerahiților. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Și fiii lui Pereț au fost: din Hețron, familia hețroniților; din Hamul, familia hamuliților. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Acestea sunt familiile lui Iuda conform cu cei numărați dintre ei, șaptezeci și șase de mii cinci sute. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Din fiii lui Isahar după familiile lor: din Tola, familia tolaiților; din Pua, familia puaniților; ");
INSERT INTO ronbtf_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Din Iașub, familia iașubiților; din Șimron, familia șimroniților. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Acestea sunt familiile lui Isahar conform cu cei numărați dintre ei, șaizeci și patru de mii trei sute. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Din fiii lui Zabulon după familiile lor: din Sered, familia serediților; din Elon, familia eloniților; din Iahleel, familia iahleeliților. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Acestea sunt familiile Zabuloniților conform cu cei numărați dintre ei, șaizeci de mii cinci sute. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Fiii lui Iosif după familiile lor: Manase și Efraim. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Din fiii lui Manase: din Machir, familia machiriților; și Machir a născut pe Galaad; din Galaad a ieșit familia galaadiților. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Aceștia sunt fiii lui Galaad: din Iezer, familia iezeriților; din Helec, familia heleciților; ");
INSERT INTO ronbtf_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Și din Asriel, familia asrieliților; și din Sihem, familia sihemiților; ");
INSERT INTO ronbtf_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Și din Șemida, familia șemidaiților; și din Hefer, familia heferiților. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Și Țelofhad, fiul lui Hefer, nu a avut fii, ci fiice și numele fiicelor lui Țelofhad erau Mala și Noa, Hogla, Milca și Tirța. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Acestea sunt familiile lui Manase și cei numărați dintre ei, cincizeci și două de mii șapte sute. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Aceștia sunt fiii lui Efraim după familiile lor: din Șutelah, familia șutelhiților; din Becher, familia becheriților; din Tahan, familia tahaniților. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Și aceștia sunt fiii lui Șutelah: din Eran, familia eraniților. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Acestea sunt familiile fiilor lui Efraim conform cu cei numărați dintre ei, treizeci și două de mii cinci sute. Aceștia sunt fiii lui Iosif, după familiile lor. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Fiii lui Beniamin, după familiile lor: din Bela, familia belaiților; din Așbel, familia așbeliților; din Ahiram, familia ahiramiților; ");
INSERT INTO ronbtf_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Din Șufam, familia șufamiților; din Hufam, familia hufamiților. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Și fiii lui Bela au fost Ard și Naaman, din Ard, familia ardiților; și din Naaman, familia naamaniților. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Aceștia sunt fiii lui Beniamin, după familiile lor, și cei numărați dintre ei erau patruzeci și cinci de mii șase sute. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Aceștia sunt fiii lui Dan după familiile lor: din Șuham, familia șuhamiților. Acestea sunt familiile lui Dan, după familiile lor. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Toate familiile șuhamiților, conform cu cei numărați dintre ei, erau șaizeci și patru de mii patru sute. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Din copiii lui Așer după familiile lor: din Imna, familia imnaiților; din Iesui, familia iesuiților; din Beria, familia beriaiților. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Din fiii lui Beria: din Heber, familia heberiților; din Malchiel, familia malchieliților. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Și numele fiicei lui Așer era Serah. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Acestea sunt familiile fiilor lui Așer conform cu cei numărați dintre ei; care erau cincizeci și trei de mii patru sute. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Din fiii lui Neftali după familiile lor: din Iahțeel, familia iahțeeliților; din Guni, familia guniților; ");
INSERT INTO ronbtf_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Din Iețer, familia iețeriților; din Șilem, familia șilemiților. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Acestea sunt familiile din Neftali, după familiile lor, și cei numărați dintre ei erau patruzeci și cinci de mii patru sute. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Aceștia au fost cei numărați dintre copiii lui Israel, șase sute una mii șapte sute treizeci. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","Acestora le va fi împărțită țara drept moștenire, conform numărului numelor. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Celor mai mulți să le dai mai multă moștenire și celor mai puțini să le dai mai puțină moștenire; fiecăruia să îi fie dată moștenirea sa conform cu cei numărați din el. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Cu toate acestea țara să fie împărțită prin sorți, conform numelor triburilor părinților lor să moștenească. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Conform sorțului să fie împărțită stăpânirea lor între mulți și puțini. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Și aceștia sunt cei numărați dintre leviți după familiile lor: din Gherșon, familia gherșoniților; din Chehat, familia chehatiților; din Merari, familia merariților. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Acestea sunt familiile leviților: familia libniților, familia hebroniților, familia mahliților, familia mușiților, familia coreiților. Și Chehat a născut pe Amram. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Și numele soției lui Amram a fost Iochebed, fiica lui Levi, pe care mama ei i-a născut-o lui Levi în Egipt; și i-a născut lui Amram pe Aaron și Moise și pe Miriam sora lor. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Și lui Aaron i-a fost născut Nadab și Abihu, Eleazar și Itamar. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Și Nadab și Abihu au murit, când au oferit foc străin înaintea DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Și cei numărați dintre ei erau douăzeci și trei de mii, toți de parte bărbătească de la vârsta de o lună în sus, și nu au fost numărați printre copiii lui Israel, pentru că lor nu le-a fost dată nicio moștenire în mijlocul copiilor lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Aceștia sunt cei numărați de Moise și preotul Eleazar, care au numărat pe copiii lui Israel în câmpiile lui Moab lângă Iordan, aproape de Ierihon. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Dar printre aceștia nu a fost niciun bărbat dintre cei pe care Moise și preotul Aaron i-au numărat, când au numărat copiii lui Israel în pustiul Sinai. ");
INSERT INTO ronbtf_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Pentru că DOMNUL spusese despre ei: Negreșit vor muri în pustiu. Și nu a rămas niciunul dintre ei, în afară de Caleb, fiul lui Iefune, și Iosua, fiul lui Nun. ");
INSERT INTO ronbtf_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Atunci au venit fiicele lui Țelofhad, fiul lui Hefer, fiul lui Galaad, fiul lui Machir, fiul lui Manase, din familiile lui Manase, fiul lui Iosif; și acestea sunt numele fiicelor sale: Mala, Noa și Hogla și Milca și Tirța. ");
INSERT INTO ronbtf_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Și ele au stat în picioare înaintea lui Moise și înaintea preotului Eleazar și înaintea prinților și a toată adunarea, la ușa tabernacolului întâlnirii, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","Tatăl nostru a murit în pustiu și el nu a fost în ceata celor ce s-au adunat împotriva DOMNULUI în ceata lui Core; ci a murit în propriul său păcat și nu a avut fii. ");
INSERT INTO ronbtf_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","De ce să fie desființat numele tatălui nostru din mijlocul familiei lui, doar pentru că nu are niciun fiu? Dă-ne nouă dar o stăpânire între frații tatălui nostru. ");
INSERT INTO ronbtf_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Și Moise a adus cauza lor înaintea DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","Fiicele lui Țelofhad vorbesc drept, cu adevărat să le dai o stăpânire a moștenirii în mijlocul fraților tatălui lor; și să faci ca moștenirea tatălui lor să treacă asupra lor. ");
INSERT INTO ronbtf_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Și să vorbești copiilor lui Israel, spunând: Dacă un bărbat moare și nu are fiu, atunci să faceți ca moștenirea lui să treacă la fiica sa. ");
INSERT INTO ronbtf_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Și dacă nu are fiică, atunci să dați moștenirea lui fraților săi. ");
INSERT INTO ronbtf_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Și dacă nu are frați, atunci să dați moștenirea lui fraților tatălui său. ");
INSERT INTO ronbtf_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Și dacă tatăl său nu are frați, atunci să dați moștenirea lui rudei sale cea mai apropiată, din familia sa și el să o stăpânească; și acesta va fi un statut al judecății pentru copiii lui Israel, precum DOMNUL i-a poruncit lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Și DOMNUL i-a spus lui Moise: Urcă-te pe acest munte, Abarim, și privește țara pe care am dat-o copiilor lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Și după ce o vei privi, vei fi adunat și tu la poporul tău, precum Aaron fratele tău a fost adunat. ");
INSERT INTO ronbtf_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Pentru că v-ați răzvrătit împotriva poruncii mele în pustiul Țin, în cearta adunării, în loc să mă sfințiți la apa dinaintea ochilor lor, acestea sunt apele Meriba, la Cades, în pustiul Țin. ");
INSERT INTO ronbtf_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Și Moise a vorbit DOMNULUI, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","Să pună DOMNUL, Dumnezeul duhurilor a toată făptura, un bărbat peste adunare, ");
INSERT INTO ronbtf_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","Bărbat care să iasă înaintea lor și care să intre înaintea lor și care să îi conducă afară și care să îi ducă înăuntru; ca adunarea DOMNULUI să nu fie ca niște oi fără păstor. ");
INSERT INTO ronbtf_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Și DOMNUL i-a spus lui Moise: Ia-ți pe Iosua, fiul lui Nun, un bărbat în care este duhul și așază-ți mâna peste el; ");
INSERT INTO ronbtf_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Și să îl pui înaintea preotului Eleazar și înaintea întregii adunări; și să îi dai poruncă înaintea ochilor lor. ");
INSERT INTO ronbtf_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Și să pui din onoarea ta peste el, ca toată adunarea copiilor lui Israel să asculte de DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Și el să stea în picioare înaintea preotului Eleazar, care va cere sfat pentru el după judecata lui Urim înaintea DOMNULUI; la cuvântul său ei vor ieși și la cuvântul său ei vor intra, el și toți copiii lui Israel împreună cu el, chiar toată adunarea. ");
INSERT INTO ronbtf_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Și Moise a făcut precum DOMNUL i-a poruncit și a luat pe Iosua și l-a pus înaintea preotului Eleazar și înaintea întregii adunări. ");
INSERT INTO ronbtf_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Și și-a așezat mâinile peste el și i-a dat poruncă, precum a poruncit DOMNUL prin mâna lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","Poruncește copiilor lui Israel și spune-le: Darul meu și pâinea mea pentru sacrificiile mele făcute prin foc, ca aromă dulce pentru mine, să luați aminte la ele ca să mi le aduceți la timpul cuvenit. ");
INSERT INTO ronbtf_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Și să le spui: Aceasta este ofranda făcută prin foc pe care să o aduceți DOMNULUI; doi miei de un an, fără pată, zi de zi, ca ofrandă arsă neîncetată. ");
INSERT INTO ronbtf_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Un miel să îl aduci dimineața și pe celălalt să îl aduci seara; ");
INSERT INTO ronbtf_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Și o zecime dintr-o efă de făină ca dar de mâncare, amestecată cu o pătrime dintr-un hin de untdelemn bătut. ");
INSERT INTO ronbtf_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Aceasta este ofrandă arsă, neîncetată, care a fost rânduită în muntele Sinai, de o aromă dulce, un sacrificiu făcut prin foc DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Și darul lor de băutură să fie o pătrime dintr-un hin pentru un miel, în locul sfânt să faci să fie turnat DOMNULUI vinul tare, ca dar de băutură. ");
INSERT INTO ronbtf_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Și celălalt miel să îl aduci pe înserat, la fel ca darul de mâncare de dimineață și ca un dar de băutură al lui, să îl aduci, un sacrificiu făcut prin foc, de o aromă dulce DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Și în ziua de sabat, doi miei de un an, fără pată, și două zecimi dintr-o măsură de făină ca dar de mâncare, amestecată cu untdelemn, și darul lor de băutură; ");
INSERT INTO ronbtf_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Aceasta este ofranda arsă a fiecărui sabat, pe lângă ofranda arsă, neîncetată, și darul ei de băutură. ");
INSERT INTO ronbtf_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Și la începuturile lunilor voastre să aduceți ofrandă arsă DOMNULUI; doi tauri tineri și un berbec, șapte miei de un an, fără pată. ");
INSERT INTO ronbtf_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Și trei zecimi dintr-o măsură de făină ca dar de mâncare, amestecată cu untdelemn, pentru un taur; și două zecimi dintr-o măsură de făină, ca dar de mâncare, amestecată cu untdelemn, pentru un berbec; ");
INSERT INTO ronbtf_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","Și câte o zecime dintr-o măsură de făină amestecată cu untdelemn ca dar de mâncare pentru un miel; ca ofrandă arsă de o aromă dulce, un sacrificiu făcut prin foc DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Și darurile lor de băutură să fie o jumătate de hin de vin la un taur și o treime dintr-un hin pentru un berbec și o pătrime dintr-un hin pentru un miel, aceasta este ofranda arsă a fiecărei luni prin toate lunile anului. ");
INSERT INTO ronbtf_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Și un ied dintre capre ca ofrandă pentru păcat adus DOMNULUI să fie oferit pe lângă ofranda arsă, neîncetată, și darul ei de băutură. ");
INSERT INTO ronbtf_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Și paștele DOMNULUI este în ziua a paisprezecea a lunii întâi. ");
INSERT INTO ronbtf_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Și în ziua a cincisprezecea a acestei luni este sărbătoarea, șapte zile să se mănânce azimă. ");
INSERT INTO ronbtf_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","În ziua întâi să fie o adunare solemnă, sfântă; să nu faceți nicio lucrare de servire în ea. ");
INSERT INTO ronbtf_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Ci să aduceți ofrandă făcută prin foc ca ofrandă arsă DOMNULUI; doi tauri tineri și un berbec și șapte miei de un an, să vă fie fără cusur; ");
INSERT INTO ronbtf_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Și darul lor de mâncare să fie din făină amestecată cu untdelemn; trei zecimi dintr-o măsură să aduceți pentru un taur și două zecimi dintr-o măsură pentru un berbec; ");
INSERT INTO ronbtf_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","Câte o zecime dintr-o măsură pentru fiecare miel, din cei șapte miei; ");
INSERT INTO ronbtf_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Și un țap ca ofrandă pentru păcat, ca să se facă ispășire pentru voi. ");
INSERT INTO ronbtf_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Să aduceți acestea pe lângă ofranda arsă de dimineață, care este drept ofrandă arsă, neîncetată. ");
INSERT INTO ronbtf_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Astfel să oferiți zilnic, în toate cele șapte zile, hrana sacrificiului făcut prin foc, de o aromă dulce DOMNULUI, să fie oferită pe lângă ofranda arsă, neîncetată, și darul său de băutură. ");
INSERT INTO ronbtf_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Și în ziua a șaptea să aveți o adunare solemnă, sfântă; să nu faceți vreo lucrare de servire în ea. ");
INSERT INTO ronbtf_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","De asemenea în ziua primelor roade, când aduceți un dar nou de mâncare DOMNULUI, după ce se încheie săptămânile voastre, să aveți o adunare solemnă, sfântă; să nu faceți nicio lucrare de servire în ea. ");
INSERT INTO ronbtf_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Ci să aduceți ofranda arsă de o aromă dulce DOMNULUI: doi tauri tineri, un berbec, șapte miei de un an; ");
INSERT INTO ronbtf_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Și darul lor de mâncare din făină amestecată cu untdelemn: trei zecimi dintr-o măsură pentru un taur, două zecimi dintr-o măsură pentru un berbec, ");
INSERT INTO ronbtf_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","Câte o zecime dintr-o măsură pentru un miel, din cei șapte miei; ");
INSERT INTO ronbtf_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Și un ied dintre capre, pentru a face ispășire pentru voi. ");
INSERT INTO ronbtf_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Să îi aduceți pe lângă ofranda arsă, neîncetată, și darul lui de mâncare, (să vă fie fără cusur) și darurile lor de băutură. ");
INSERT INTO ronbtf_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Și în luna a șaptea, în ziua întâi a lunii, să aveți o adunare solemnă, sfântă; să nu faceți nicio lucrare de servire în ea, aceasta vă este ziua sunării trâmbițelor. ");
INSERT INTO ronbtf_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Și să aduceți ofrandă arsă de o aromă dulce DOMNULUI: un taur tânăr, un berbec și șapte miei de un an, fără cusur. ");
INSERT INTO ronbtf_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Și darul lor de mâncare să fie din făină amestecată cu untdelemn: trei zecimi dintr-o măsură pentru un taur și două zecimi dintr-o măsură pentru un berbec, ");
INSERT INTO ronbtf_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","Și o zecime dintr-o măsură pentru un miel, pentru fiecare dintre cei șapte miei; ");
INSERT INTO ronbtf_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Și un ied dintre capre ca ofrandă pentru păcat, pentru a se face ispășire pentru voi; ");
INSERT INTO ronbtf_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Pe lângă ofranda arsă a lunii și darul ei de mâncare; și ofranda zilnică arsă și darul ei de mâncare și darurile lor de băutură, conform cu rânduiala lor, de o aromă dulce, un sacrificiu făcut prin foc DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Și în ziua a zecea a lunii a șaptea să aveți o adunare solemnă, sfântă; și să vă chinuiți sufletele; să nu faceți nicio lucrare în ea, ");
INSERT INTO ronbtf_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Ci să aduceți ofrandă arsă DOMNULUI de o aromă dulce: un taur tânăr, un berbec și șapte miei de un an; să vă fie fără cusur. ");
INSERT INTO ronbtf_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Și darul lor de mâncare să fie din făină amestecată cu untdelemn: trei zecimi dintr-o măsură pentru un taur și două zecimi dintr-o măsură pentru un berbec, ");
INSERT INTO ronbtf_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","Și câte o zecime dintr-o măsură pentru un miel, pentru fiecare dintre cei șapte miei; ");
INSERT INTO ronbtf_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Un ied dintre capre ca ofrandă pentru păcat; pe lângă ofranda pentru păcat a ispășirii și ofranda arsă, neîncetată, și darul ei de mâncare și darurile lor de băutură. ");
INSERT INTO ronbtf_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Și în ziua a cincisprezecea a lunii a șaptea, să aveți o adunare solemnă, sfântă; să nu faceți nicio lucrare de servire și să țineți o sărbătoare DOMNULUI, timp de șapte zile; ");
INSERT INTO ronbtf_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Și să aduceți ofrandă arsă, un sacrificiu făcut prin foc, de o aromă dulce DOMNULUI; treisprezece tauri tineri, doi berbeci și paisprezece miei de un an; să fie fără cusur; ");
INSERT INTO ronbtf_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Și darul lor de mâncare să fie din făină amestecată cu untdelemn: trei zecimi dintr-o măsură pentru fiecare taur dintre cei treisprezece tauri, două zecimi dintr-o măsură pentru fiecare berbec dintre cei doi berbeci, ");
INSERT INTO ronbtf_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","Și câte o zecime dintr-o măsură pentru fiecare miel din cei paisprezece miei; ");
INSERT INTO ronbtf_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Și un ied dintre capre ca ofrandă pentru păcat; pe lângă ofranda arsă, neîncetată, darul ei de mâncare și darul ei de băutură. ");
INSERT INTO ronbtf_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","Și în ziua a doua să aduceți doisprezece tauri tineri, doi berbeci, paisprezece miei de un an, fără pată; ");
INSERT INTO ronbtf_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Și darul lor de mâncare și darurile lor de băutură pentru tauri, pentru berbeci și pentru miei, să fie conform cu numărul lor, conform rânduielii; ");
INSERT INTO ronbtf_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Și un ied dintre capre ca ofrandă pentru păcat; pe lângă ofranda arsă, neîncetată, și darul lor de mâncare și darurile lor de băutură. ");
INSERT INTO ronbtf_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Și în ziua a treia: unsprezece tauri, doi berbeci, paisprezece miei de un an, fără cusur; ");
INSERT INTO ronbtf_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Și darul lor de mâncare și darurile lor de băutură pentru tauri, pentru berbeci și pentru miei, să fie conform cu numărul lor, conform rânduielii; ");
INSERT INTO ronbtf_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Și un țap ca ofrandă pentru păcat; pe lângă ofranda arsă, neîncetată, și darul ei de mâncare și darul ei de băutură. ");
INSERT INTO ronbtf_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Și în a patra zi zece tauri, doi berbeci și paisprezece miei de un an, fără cusur; ");
INSERT INTO ronbtf_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Darul lor de mâncare și darurile lor de băutură pentru tauri, pentru berbeci și pentru miei, să fie conform cu numărul lor, conform rânduielii; ");
INSERT INTO ronbtf_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Și un ied dintre capre ca ofrandă pentru păcat; pe lângă ofranda arsă, neîncetată, și darul ei de mâncare și darul ei de băutură. ");
INSERT INTO ronbtf_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Și în ziua a cincea: nouă tauri, doi berbeci și paisprezece miei de un an, fără pată; ");
INSERT INTO ronbtf_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Și darul lor de mâncare și darurile lor de băutură pentru tauri, pentru berbeci și pentru miei, să fie conform cu numărul lor, conform rânduielii; ");
INSERT INTO ronbtf_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Și un țap ca ofrandă pentru păcat; pe lângă ofranda arsă, neîncetată, și darul ei de mâncare și darul ei de băutură. ");
INSERT INTO ronbtf_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Și în ziua a șasea: opt tauri, doi berbeci și paisprezece miei de un an, fără cusur; ");
INSERT INTO ronbtf_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Și darul lor de mâncare și darurile lor de băutură pentru tauri, pentru berbeci și pentru miei, să fie conform cu numărul lor, conform rânduielii; ");
INSERT INTO ronbtf_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Și un țap ca ofrandă pentru păcat; pe lângă ofranda arsă, neîncetată, și darul lui de mâncare și darul lui de băutură. ");
INSERT INTO ronbtf_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Și în ziua a șaptea: șapte tauri, doi berbeci și paisprezece miei de un an, fără cusur; ");
INSERT INTO ronbtf_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Și darul lor de mâncare și darurile lor de băutură pentru tauri, pentru berbeci și pentru miei, să fie conform cu numărul lor, conform rânduielii; ");
INSERT INTO ronbtf_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Și un țap ca ofrandă pentru păcat; pe lângă ofranda arsă, neîncetată, și darul ei de mâncare și darul ei de băutură. ");
INSERT INTO ronbtf_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","În ziua a opta să aveți o adunare, solemnă, să nu faceți nicio lucrare de servire în ea; ");
INSERT INTO ronbtf_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Ci să aduceți ofrandă arsă, ofrandă făcută prin foc, de o aromă dulce DOMNULUI: un taur, un berbec, șapte miei de un an, fără cusur; ");
INSERT INTO ronbtf_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Darul lor de mâncare și darurile lor de băutură pentru tauri, pentru berbeci și pentru miei, să fie conform cu numărul lor, conform rânduielii; ");
INSERT INTO ronbtf_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Și un țap ca ofrandă pentru păcat; pe lângă ofranda arsă, neîncetată, și darul ei de mâncare și darul ei de băutură. ");
INSERT INTO ronbtf_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Aceste lucruri să le faceți DOMNULUI în sărbătorile voastre rânduite, pe lângă promisiunile voastre și ofrandele de bună voie, pentru ofrandele voastre arse și pentru darurile voastre de mâncare și pentru darurile voastre de băutură și pentru ofrandele voastre de pace. ");
INSERT INTO ronbtf_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Și Moise a spus copiilor lui Israel conform cu tot ceea ce DOMNUL i-a poruncit lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Și Moise a vorbit căpeteniilor triburilor referitor la copiii lui Israel, spunând: Acesta este lucrul pe care DOMNUL l-a poruncit. ");
INSERT INTO ronbtf_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Dacă un bărbat face o promisiune DOMNULUI, sau face un jurământ ca să își lege sufletul cu o legătură; să nu rupă cuvântul său, să facă conform cu tot ceea ce iese din gura lui. ");
INSERT INTO ronbtf_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Dacă de asemenea o femeie face o promisiune DOMNULUI și se leagă cu o legătură, fiind în casa tatălui ei, în tinerețea ei, ");
INSERT INTO ronbtf_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","Și tatăl ei aude promisiunea ei și legătura ei cu care și-a legat sufletul și dacă tatăl ei păstrează tăcerea față de ea, atunci toate promisiunile ei vor sta în picioare și fiecare legătură cu care și-a legat sufletul va sta în picioare. ");
INSERT INTO ronbtf_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Dar dacă tatăl ei îi interzice în ziua în care aude, niciuna din promisiunile ei, sau din legăturile cu care și-a legat sufletul, nu va sta în picioare; și DOMNUL o va ierta, căci tatăl ei i-a interzis. ");
INSERT INTO ronbtf_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Și dacă ea are soț, când a promis, sau a rostit ceva cu buzele ei, rostirea cu care și-a legat sufletul; ");
INSERT INTO ronbtf_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","Și soțul ei a auzit aceasta și a păstrat tăcerea față de ea în ziua când a auzit, atunci promisiunile ei vor sta în picioare și legăturile ei, cu care și-a legat sufletul, vor sta în picioare. ");
INSERT INTO ronbtf_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Dar dacă soțul ei i-a interzis în ziua în care a auzit, atunci el să facă fără niciun efect promisiunea ei pe care ea a jurat-o și ceea ce a rostit ea în grabă cu buzele ei, și DOMNUL o va ierta. ");
INSERT INTO ronbtf_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Dar fiecare promisiune a unei văduve și a celei ce este divorțată, cu care ele și-au legat sufletele, va sta în picioare împotriva ei. ");
INSERT INTO ronbtf_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Și dacă ea a promis în casa soțului ei, sau și-a legat sufletul cu un legământ, ");
INSERT INTO ronbtf_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","Și soțul l-a auzit și păstrează tăcerea față de ea și nu i-a interzis, atunci toate promisiunile ei vor sta în picioare și fiecare legătură cu care și-a legat sufletul va sta în picioare. ");
INSERT INTO ronbtf_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Dar dacă soțul ei le-a desființat complet în ziua în care le-a auzit, atunci orice iese de pe buzele ei referitor la promisiunile ei, sau referitor la legătura sufletului ei, nu va sta în picioare, soțul ei le-a făcut fără efect; și DOMNUL o va ierta. ");
INSERT INTO ronbtf_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Fiecare promisiune și fiecare legătură prin legământ pentru a chinui sufletul, soțul ei le poate întemeia, sau soțul ei le poate zădărnici. ");
INSERT INTO ronbtf_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Dar dacă soțul ei deja a păstrat tăcerea față de ea, de la o zi la alta, atunci el întemeiază toate promisiunile ei, sau toate legăturile ei, care sunt asupra ei; el le confirmă, deoarece a păstrat tăcerea față de ea în ziua în care le-a auzit. ");
INSERT INTO ronbtf_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Dar dacă el, în orice fel, le zădărnicește după ce le-a auzit, atunci el să poarte nelegiuirea ei. ");
INSERT INTO ronbtf_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Acestea sunt statutele pe care DOMNUL le-a poruncit lui Moise, între un bărbat și soția sa, între tată și fiica sa, fiind în tinerețea ei în casa tatălui ei. ");
INSERT INTO ronbtf_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","Răzbună pe copiii lui Israel asupra madianiților; și după aceasta vei fi adunat la poporul tău. ");
INSERT INTO ronbtf_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Și Moise a vorbit poporului, spunând: Înarmați-vă câțiva dintre voi pentru război și ei să meargă împotriva madianiților și să răzbune pe DOMNUL asupra lui Madian. ");
INSERT INTO ronbtf_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Din fiecare trib, prin toate semințiile lui Israel, să trimiteți o mie la război. ");
INSERT INTO ronbtf_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Astfel au fost aleși dintre miile lui Israel, o mie din fiecare trib, douăsprezece mii înarmați pentru război. ");
INSERT INTO ronbtf_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Și Moise i-a trimis la război, o mie dintre fiecare trib, pe ei și pe Fineas, fiul preotului Eleazar, la război, cu uneltele sfinte și trâmbițele de sunat în mâna sa. ");
INSERT INTO ronbtf_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Și s-au războit împotriva madianiților, precum DOMNUL i-a poruncit lui Moise; și au ucis toată partea bărbătească. ");
INSERT INTO ronbtf_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Și au ucis pe împărații lui Madian, pe lângă restul celor uciși, adică pe Evi și pe Rechem și pe Țur și pe Hur și pe Reba, cinci împărați ai lui Madian, de asemenea l-au ucis cu sabia pe Balaam, fiul lui Beor. ");
INSERT INTO ronbtf_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Și copiii lui Israel au luat captive pe toate femeile lui Madian și pe micuții lor; și au luat ca jaf toate vitele lor și toate turmele lor și toate bunurile lor. ");
INSERT INTO ronbtf_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Și au ars cu foc toate cetățile lor în care ei au locuit și toate cetățuile lor frumoase. ");
INSERT INTO ronbtf_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Și au luat tot jaful și toată prada, deopotrivă din oameni și din animale. ");
INSERT INTO ronbtf_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Și au adus captivii și prada și jaful la Moise și la preotul Eleazar și la adunarea copiilor lui Israel, la tabăra din câmpiile lui Moab, care sunt lângă Iordan aproape de Ierihon. ");
INSERT INTO ronbtf_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Și Moise și preotul Eleazar și toți prinții adunării, au ieșit să îi întâmpine în afara taberei. ");
INSERT INTO ronbtf_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Și Moise s-a înfuriat pe ofițerii oștirii, pe căpeteniile miilor și pe căpeteniile sutelor, care au venit de la bătălie. ");
INSERT INTO ronbtf_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Și Moise le-a spus: Ați lăsat toate femeile în viață? ");
INSERT INTO ronbtf_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Iată, acestea au făcut pe copiii lui Israel, prin sfatul lui Balaam, să facă fărădelege împotriva DOMNULUI în lucrarea lui Peor, și a fost o plagă în mijlocul adunării DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","De aceea, ucide acum pe fiecare dintre micuții lor de parte bărbătească și ucide fiecare femeie care a cunoscut bărbat, culcându-se cu el. ");
INSERT INTO ronbtf_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Dar toți copiii de parte femeiască, ce nu au cunoscut bărbat, culcându-se cu el, lăsați-i în viață pentru voi. ");
INSERT INTO ronbtf_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Și oricine a ucis vreo persoană și oricine a atins pe cineva ucis să locuiască șapte zile în afara taberei; purificați-vă deopotrivă voi și captivii voștri în ziua a treia și în ziua a șaptea. ");
INSERT INTO ronbtf_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Și purificați toate hainele voastre și tot ce este făcut din piei și tot lucrul din păr de capre și toate lucrurile făcute din lemn. ");
INSERT INTO ronbtf_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Și preotul Eleazar le-a spus bărbaților de război care au mers la bătălie: Aceasta este rânduiala legii pe care DOMNUL i-a poruncit-o lui Moise; ");
INSERT INTO ronbtf_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Doar aurul și argintul, arama, fierul, cositorul și plumbul, ");
INSERT INTO ronbtf_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","Fiecare lucru care suportă focul, să îl treceți prin foc și va fi curat, cu toate acestea va fi purificat cu apa separării; și tot ce nu suportă focul să îl treceți prin apă. ");
INSERT INTO ronbtf_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Și să vă spălați hainele în ziua a șaptea și veți fi curați și după aceea să intrați în tabără. ");
INSERT INTO ronbtf_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Și DOMNUL i-a vorbit lui Moise, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","Fă numărătoarea prăzii care a fost luată, deopotrivă dintre oameni și dintre animale, tu și preotul Eleazar, împreună cu mai marii părinți ai adunării, ");
INSERT INTO ronbtf_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Și împarte prada în două părți: între cei ce au dus războiul, care au ieșit la bătălie și între toată adunarea; ");
INSERT INTO ronbtf_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Și ridică o taxă DOMNULUI de la oamenii de război care au ieșit la luptă, un suflet din cinci sute, deopotrivă dintre oameni și dintre boi și dintre măgari și dintre oi; ");
INSERT INTO ronbtf_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Ia acesta din jumătatea lor și să îl dai preotului Eleazar, ca ofrandă ridicată pentru DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Și din jumătatea care este a copiilor lui Israel, să iei o porție de cincizeci, dintre oameni, dintre boi, dintre măgari și din turme, din toate felurile de vite și să le dai leviților, care au păstrat însărcinarea tabernacolului DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Și Moise și preotul Eleazar au făcut precum DOMNUL i-a poruncit lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Și jaful, adică restul prăzii pe care oamenii de război o apucaseră, era șase sute șaptezeci și cinci de mii de oi, ");
INSERT INTO ronbtf_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","Și șaptezeci și două de mii de boi, ");
INSERT INTO ronbtf_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","Și șaizeci și unu de mii de măgari, ");
INSERT INTO ronbtf_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","Și treizeci și două de mii de persoane cu totul, femei care nu cunoscuseră bărbat, culcându-se cu el. ");
INSERT INTO ronbtf_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Și jumătatea, care era porția celor ce au ieșit să se războiască, era în număr de trei sute treizeci și șapte de mii cinci sute de oi; ");
INSERT INTO ronbtf_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","Și taxa DOMNULUI din oi a fost șase sute șaptezeci și cinci; ");
INSERT INTO ronbtf_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","Și boii au fost treizeci și șase de mii; din care taxa DOMNULUI a fost șaptezeci și doi; ");
INSERT INTO ronbtf_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","Și măgarii au fost treizeci de mii cinci sute; din care taxa DOMNULUI a fost șaizeci și unu. ");
INSERT INTO ronbtf_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","Și numărul persoanelor a fost șaisprezece mii; din care taxa DOMNULUI a fost treizeci și două de persoane. ");
INSERT INTO ronbtf_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Și Moise a dat taxa DOMNULUI, care era ofranda ridicată pentru DOMNUL, preotului Eleazar, precum DOMNUL i-a poruncit lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Și din jumătatea care era a copiilor lui Israel, pe care Moise a despărțit-o de la bărbații care s-au războit, ");
INSERT INTO ronbtf_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","(Acum jumătatea ce aparținea adunării era de trei sute treizeci și șapte de mii cinci sute de oi, ");
INSERT INTO ronbtf_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","Și treizeci și șase de mii de boi, ");
INSERT INTO ronbtf_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","Și treizeci de mii cinci sute de măgari, ");
INSERT INTO ronbtf_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","Și șaisprezece mii de persoane;) ");
INSERT INTO ronbtf_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Chiar din jumătatea care era a copiilor lui Israel, Moise a luat o porție de cincizeci, deopotrivă dintre oameni și dintre animale și le-a dat leviților, care au păstrat însărcinarea tabernacolului DOMNULUI; precum DOMNUL i-a poruncit lui Moise. ");
INSERT INTO ronbtf_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Și ofițerii care erau peste miile oștirii, căpeteniile miilor și căpeteniile sutelor, s-au apropiat de Moise, ");
INSERT INTO ronbtf_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","Și i-au spus lui Moise: Servitorii tăi au făcut numărătoarea bărbaților de război care sunt sub porunca noastră și nu lipsește niciun bărbat dintre noi. ");
INSERT INTO ronbtf_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","De aceea am adus un dar pentru DOMNUL, din ce a dobândit fiecare bărbat, din bijuterii de aur, lanțuri, brățări, inele, cercei și tăblițe, pentru a face ispășire pentru sufletele noastre înaintea DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Și Moise și preotul Eleazar au luat aurul de la ei, toate bijuteriile lucrate. ");
INSERT INTO ronbtf_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Și tot aurul ofrandei pe care l-au oferit DOMNULUI, de la căpeteniile miilor și de la căpeteniile sutelor, a fost de șaisprezece mii șapte sute cincizeci de șekeli. ");
INSERT INTO ronbtf_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","(Pentru că bărbații de război prădaseră, fiecare bărbat pentru el însuși.) ");
INSERT INTO ronbtf_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Și Moise și preotul Eleazar au luat aurul de la căpeteniile miilor și ai sutelor și l-au adus în tabernacolul întâlnirii, drept amintire pentru copiii lui Israel înaintea DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Acum, copiii lui Ruben și copiii lui Gad aveau o foarte mare mulțime de vite; și au văzut țara Iaezer și țara Galaad și, iată, locul era un loc pentru vite, ");
INSERT INTO ronbtf_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Copiii lui Gad și copiii lui Ruben au venit și i-au spus lui Moise și preotului Eleazar și prinților adunării, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","Atarot și Dibon și Iaezer și Nimra și Hesbon și Eleale și Sebam și Nebo și Beon, ");
INSERT INTO ronbtf_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","Țara pe care DOMNUL a lovit-o înaintea adunării lui Israel, este un pământ pentru vite și servitorii tăi au vite, ");
INSERT INTO ronbtf_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Pentru aceasta, au spus ei, dacă am găsit har înaintea ochilor tăi, fie ca această țară să se dea servitorilor tăi în stăpânire, nu ne trece peste Iordan. ");
INSERT INTO ronbtf_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Și Moise a spus copiilor lui Gad și copiilor lui Ruben: Vor merge frații voștri să se războiască, iar voi veți ședea aici? ");
INSERT INTO ronbtf_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Și pentru ce descurajați inima copiilor lui Israel de la a intra în țara pe care DOMNUL le-a dat-o? ");
INSERT INTO ronbtf_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Astfel au făcut părinții voștri, când i-am trimis de la Cades-Barnea să vadă țara. ");
INSERT INTO ronbtf_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Căci, când s-au urcat la valea Eșcol și au văzut țara, au descurajat inima copiilor lui Israel, cum că nu ar trebui să intre în țara pe care DOMNUL le-a dat-o. ");
INSERT INTO ronbtf_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Și mânia DOMNULUI s-a aprins în acel timp și el a jurat, spunând: ");
INSERT INTO ronbtf_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","Negreșit niciunul dintre oamenii care s-au urcat din Egipt, de la vârsta de douăzeci de ani în sus, nu va vedea țara pe care eu am jurat-o lui Avraam, lui Isaac și lui Iacob; deoarece nu m-au urmat pe deplin, ");
INSERT INTO ronbtf_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","În afară de Caleb, fiul lui Iefune chenizitul, și Iosua, fiul lui Nun, pentru că ei au urmat pe deplin pe DOMNUL. ");
INSERT INTO ronbtf_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Și mânia DOMNULUI s-a aprins împotriva lui Israel și i-a făcut să rătăcească în pustiu patruzeci de ani, până ce toată generația care făcuse rău înaintea ochilor DOMNULUI a fost mistuită. ");
INSERT INTO ronbtf_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Și, iată, voi v-ați ridicat în locul părinților voștri, urmași înmulțiți ai oamenilor păcătoși, ca să sporiți acum mânia înverșunată a DOMNULUI spre Israel. ");
INSERT INTO ronbtf_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Căci dacă vă abateți de la a-l urma pe el, el îi va lăsa din nou în pustiu; și veți nimici tot acest popor. ");
INSERT INTO ronbtf_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Și ei s-au apropiat de el și au spus: Vom zidi țarcuri pentru oi aici pentru vitele noastre și cetăți pentru micuții noștri, ");
INSERT INTO ronbtf_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Dar noi înșine vom merge gata înarmați înaintea copiilor lui Israel, până îi vom fi dus la locul lor; și micuții noștri vor locui în cetățile fortificate din cauza locuitorilor țării. ");
INSERT INTO ronbtf_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Nu ne vom întoarce la casele noastre până ce copiii lui Israel nu vor fi moștenit fiecare bărbat moștenirea lui. ");
INSERT INTO ronbtf_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Pentru că nu vom moșteni împreună cu ei dincolo de Iordan, sau mai departe; deoarece moștenirea noastră ne-a căzut de această parte a Iordanului spre est. ");
INSERT INTO ronbtf_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Și Moise le-a spus: Dacă veți face acest lucru, dacă veți merge înarmați înaintea DOMNULUI la război, ");
INSERT INTO ronbtf_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","Și veți trece toți înarmați peste Iordan înaintea DOMNULUI, până ce el va fi scos afară pe dușmanii săi de dinaintea lui, ");
INSERT INTO ronbtf_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","Și țara va fi supusă înaintea DOMNULUI; și după aceea vă veți întoarce și veți fi fără vină înaintea DOMNULUI și înaintea lui Israel; și această țară va fi stăpânirea voastră înaintea DOMNULUI. ");
INSERT INTO ronbtf_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Dar dacă nu veți face astfel, iată, ați păcătuit împotriva DOMNULUI și fiți siguri că păcatul vostru vă va găsi. ");
INSERT INTO ronbtf_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Zidiți-vă cetăți pentru micuții voștri și țarcuri pentru oile voastre și faceți ceea ce a ieșit din gura voastră. ");
INSERT INTO ronbtf_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Și copiii lui Gad și copiii lui Ruben i-au spus lui Moise, zicând: Servitorii tăi vor face precum domnul meu poruncește. ");
INSERT INTO ronbtf_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Micuții noștri, soțiile noastre, turmele noastre și toate vitele noastre vor fi acolo în cetățile lui Galaad; ");
INSERT INTO ronbtf_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Dar servitorii tăi vor trece, fiecare bărbat înarmat de război, înaintea DOMNULUI la bătălie, precum domnul meu spune. ");
INSERT INTO ronbtf_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Astfel, referitor la ei, Moise i-a poruncit preotului Eleazar și lui Iosua, fiul lui Nun, și mai marilor părinți ai triburilor copiilor lui Israel, ");
INSERT INTO ronbtf_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Și Moise le-a spus: Dacă copiii lui Gad și copiii lui Ruben vor trece împreună cu voi peste Iordan, fiecare bărbat înarmat de bătălie, înaintea DOMNULUI, și țara va fi supusă înaintea voastră, atunci să le dați țara lui Galaad în stăpânire. ");
INSERT INTO ronbtf_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Dar dacă nu vor trece cu voi înarmați, atunci să aibă stăpâniri printre voi în țara lui Canaan. ");
INSERT INTO ronbtf_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Și copiii lui Gad și copiii lui Ruben au răspuns, zicând: Precum DOMNUL a vorbit servitorilor tăi, astfel vom face. ");
INSERT INTO ronbtf_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Vom trece înarmați înaintea DOMNULUI în țara lui Canaan, pentru ca stăpânirea moștenirii noastre de această parte a Iordanului să fie a noastră. ");
INSERT INTO ronbtf_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Și Moise le-a dat lor, adică copiilor lui Gad și copiilor lui Ruben și la jumătate din tribul lui Manase, fiul lui Iosif, împărăția lui Sihon, împăratul amoriților, și împărăția lui Og, împăratul Basanului, țara, cu cetățile ei în ținuturile ei, cetățile țării de jur împrejur. ");
INSERT INTO ronbtf_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Și copiii lui Gad au zidit Dibonul și Atarotul și Aroerul, ");
INSERT INTO ronbtf_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Și Atrotul, Șofanul și Iaezerul și Iogbeha, ");
INSERT INTO ronbtf_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Și Betnimra și Betharanul, cetăți fortificate; și țarcuri pentru oi. ");
INSERT INTO ronbtf_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Și copiii lui Ruben au zidit Hesbonul și Eleale și Chiriat-Haimul, ");
INSERT INTO ronbtf_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Și Nebo și Baal-Meonul, (numele lor fiind schimbate) și Șibma; și au dat alte nume cetăților pe care le-au zidit. ");
INSERT INTO ronbtf_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Și copiii lui Machir, fiul lui Manase, a mers la Galaad și l-au luat și au alungat pe amoriții care erau în el. ");
INSERT INTO ronbtf_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Și Moise a dat Galaadul lui Machir, fiul lui Manase; și el a locuit în el. ");
INSERT INTO ronbtf_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Și Iair, fiul lui Manase, a ieșit și a luat orașele mici de acolo și le-a numit Havot-Iair. ");
INSERT INTO ronbtf_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Și Nobah a mers și a luat Chenatul și satele lui și l-a numit Nobah, după numele său. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Acestea sunt călătoriile copiilor lui Israel, care au ieșit din țara Egiptului cu oștirile lor sub mâna lui Moise și Aaron. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Și Moise a scris plecările lor conform cu călătoriile lor prin porunca DOMNULUI, și acestea sunt călătoriile lor conform cu plecările lor. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Și ei au plecat de la Ramses în luna întâi, în ziua a cincisprezecea a lunii întâi; a doua zi după paște, copiii lui Israel au ieșit cu o mână înaltă înaintea ochilor tuturor egiptenilor. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","Pentru că egiptenii au înmormântat pe întâii lor născuți, pe care DOMNUL i-a lovit între ei; DOMNUL a făcut de asemenea judecăți asupra dumnezeilor lor. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Și copiii lui Israel au plecat de la Ramses și au așezat corturile în Sucot. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Și au plecat de la Sucot și au așezat corturile în Etam, care este la marginea pustiului. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Și au plecat de la Etam și s-au întors la Piha-Hirot, care este înainte de Baal-Țefon; și au așezat corturile înainte de Migdol. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Și au plecat dinaintea Piha-Hirotului și au trecut prin mijlocul mării în pustiu și au mers o călătorie de trei zile în pustiul Etam și au așezat corturile în Mara. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Și au plecat de la Mara și au venit la Elim; și în Elim erau douăsprezece fântâni de apă și șaptezeci de palmieri; și acolo au așezat corturile. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Și au plecat de la Elim și au așezat corturile lângă Marea Roșie. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Și au plecat de la Marea Roșie și au așezat corturile în pustiul Sin. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Și au plecat în călătoria lor, ieșind din pustiul Sin, și au așezat corturile în Dofca. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Și au plecat de la Dofca și au așezat corturile în Aluș. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Și au plecat de la Aluș și au așezat corturile la Refidim, unde nu era apă ca poporul să bea. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Și au plecat de la Refidim și au așezat corturile în pustiul Sinai. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Și au plecat din pustiul Sinai și au așezat corturile la Chibrot-Hataava. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Și au plecat de la Chibrot-Hataava și au așezat corturile la Hațerot. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Și au plecat de la Hațerot și au așezat corturile în Ritma. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Și au plecat de la Ritma și au așezat corturile la Rimon-Pereț. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Și au plecat de la Rimon-Pereț și au așezat corturile în Libna. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Și au plecat de la Libna și au așezat corturile la Risa. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Și au plecat de la Risa și au așezat corturile la Chehelata. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Și au plecat de la Chehelata și au așezat corturile în muntele Șafer. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Și au plecat de la muntele Șafer și au așezat corturile în Harada. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Și au plecat de la Harada și au așezat corturile în Machelot. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Și au plecat de la Machelot și au așezat corturile la Tahat. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Și au plecat de la Tahat și au așezat corturile la Tarah. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Și au plecat de la Tarah și au așezat corturile în Mitca. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Și au plecat de la Mitca și au așezat corturile în Hașmona. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Și au plecat de la Hașmona și au așezat corturile la Moserot. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Și au plecat de la Moserot și au așezat corturile în Bene-Iaacan. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Și au plecat de la Bene-Iaacan și au așezat corturile la Hor-Hag-Hidgad. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Și au mers de la Hor-Hag-Hidgad și au așezat corturile în Iotbata. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Și au plecat de la Iotbata și au așezat corturile la Abrona. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Și au plecat de la Abrona și au așezat corturile la Ețion-Gheber. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Și au plecat de la Ețion-Gheber și au așezat corturile în pustiul Țin, care este Cades. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Și au plecat de la Cades și au așezat corturile în muntele Hor, la marginea țării lui Edom. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Și preotul Aaron a urcat în muntele Hor la porunca DOMNULUI și a murit acolo, în anul patruzeci, după ce copiii lui Israel ieșiseră din țara Egiptului, în ziua întâi a lunii a cincea. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Și Aaron era în vârstă de o sută douăzeci și trei de ani când a murit în muntele Hor. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Și împăratul Arad canaanitul, care a locuit în sudul țării lui Canaan, a auzit de venirea copiilor lui Israel. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Și ei au plecat de la muntele Hor și au așezat corturile în Țalmona. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Și au plecat de la Țalmona și au așezat corturile în Punon. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Și au plecat de la Punon și au așezat corturile în Obot. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Și au plecat de la Obot și au așezat corturile în Iieabarim, la granița lui Moab. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Și au plecat de la Iim și au așezat corturile în Dibon-Gad. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Și au plecat de la Dibon-Gad și au așezat corturile în Almon-Diblataim. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Și au plecat de la Almon-Diblataim și au așezat corturile în munții Abarim, în fața lui Nebo. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Și au plecat de la munții Abarim și au așezat corturile în câmpiile lui Moab, lângă Iordan, aproape de Ierihon. ");
INSERT INTO ronbtf_vpl VALUES ("NU33_49","00