﻿USE sofia;
DROP TABLE IF EXISTS sofia.ronBayash_vpl;
CREATE TABLE ronBayash_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ronBayash_vpl WRITE;
INSERT INTO ronBayash_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ka kum šćijec mulc su apukat să skriji događajur šje Dimizov u obečalit a su dogodulit ăntri noj. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Orikic as re svedoci dăm kap dă šje ur skris šje ur văzut šă šje svite Isus, jej ăs slugurlje alu vorba. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Aša šă ju mam ăngănđit dăm elši pă rănd să skruv kutotu păntru činji, glavni Teofile. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Aša să fij siguran šă să poc arăta šă să spuj dă ănkriđală dă vorbilje dă šje u fost ănvăcat kă ăj aje anume. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ăm zăljiljelje kănd kralj Herod vladale ăm Judeja, are unu popă šje să čima Zaharija dăm svečenički rodu alu Abiji, šă mujere aluj isto are dăm pleme alu Aron. Je să čima Elizabeta. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Amăndoj ăs re ăm oči alu Dimizov făr dă duvină, pravedni kă jej cănje toći zapovjedurlje šă pravilurlje alu Domnu anostru. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Jej asre făr dă kupij, daje kă Elizabeta nu puće să ajvi kupij, šă amăndoj asre tari bătărnj. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Kănd una ză, Zaharija služule ka popa alu Dimizov ăm Hram, u vinjit vreme pă grupa aluj să služulaskă. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Dă pă običaju ăntri pop lu izabralit ku kockă să mergă ăm svetište alu Domnu să prinusulaskă miomirosur. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Šă ăntreg narodu aščipta afară ăm udvar šă să aruga ăm vreme dă mirosur. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Atunšje anđalu alu Domnu su năstămit ăm Hram alu Zahariji dădănenći pă desna parći dă žrtvenik hunđi are miomiris. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zaharija kănd u văzut pă anđal tari su ănfrikušatăsă. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Daje anđalu ju zăs: “Nuči sprije, Zaharija! Arugală ata u fost auzătă. Mujere ata Elizabeta u ave fišjor, šă tu vi da numi Ivan. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Vi ave fălušăje šă slavlje šă mulc sur ăm făluša la fătala aluj. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Kă jăl anume u fi mari ăm oči lu Domnu anostru. Vin šă tari butură no be. Mar ăm injima alu mumăsa jăl u fi umpljet ku Duhu Svănt. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Mulc fišjori kari ăs Izraelci sur ăntoršji dă rănd dă la jăl ăm napoj la Domnu Dimizovu alor. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Jăl u meržji ăm nenće alu Domnu ka vjesniku ăm duhu šă ăm pučere alu Ilija kari are dă kănva prorok să pomirilaskă pă kupiji ku tatusurlje, să ăntorkă pă eje kari ăs nevjerni să apušji mudrost dă la heje kari ăs pravednă, să pripremalaskă narod păntru Domnu.” ");
INSERT INTO ronBayash_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ali u zăs Zaharija alu anđalu Gabrijel kari stăće ăm nenče alu Dimizov: “Dă pă šje uj šči kă aje ăj anume? Tu vejs kă mes aku om bătărn šă băšăca ame ăj isto ăm aj.” ");
INSERT INTO ronBayash_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Anđalu ju ăntors vorba: “Numilje amnjov ăj Gabrijel šă ju mes ku Dimizov să askultă šje mu spunji, aša mes mănat să svitesk ku činji šă săc aduk Hir fălos. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Punji mă ureći, kănd mar nu maj ănkrizut dă vorbasta šje cam spusu, tu njimika nu vi puće sviti păn šje no su dogoduli asta šje cam spus. Vorbilje šje cam spus ur fi ăm pravă vremi.” ");
INSERT INTO ronBayash_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Lume aščipta afară pă Zaharija, šă să čudule šje fašji atita dobă ăm svetište. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kănd u vinjit afară nu puće să svitaskă. Jăl svite ăm znakovur šă nu puće să svitaskă njimika păn šje nu ju su ave kupilu. Šă atunšje ur prišjepi kă u avut vizijă ăm svetište. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Kănd u završălit vreme dă služba aluj ăm Hram, Zaharija u fužjit akasă. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Atunšje maj dă pă zăljilje băšăca aluj u rămas gărjonă, šă nu jăšă afară šinšj lunj. Elizabeta u zăs: ");
INSERT INTO ronBayash_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Domnu ăj ala kari u făkut asta aku: Dimizov su ujtat pă minji ku milă šă u lot ăndărăt rušănje dăm oči alu ominj.” ");
INSERT INTO ronBayash_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Šasă lunj dă kănd Elizabeta are gărjonă, Dimizov u mănat pă anđalu aluj păšći Gabrijel ăm varuš ăm Galileja kari să čamă Nazaret. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Jăl u vinjit la fată ăm păr kă su zaručulit ku Josip kari are potomku alu Kralju David. Je să čima Marija. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gabrijel u vinjit šă u zăs: “Ănfălušešćići tu kari ješć izabralită! Domnu ăj ku činji! Blagoslovulită ješć tu ăntri mujer!” ");
INSERT INTO ronBayash_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Marija are uznemirenă dă pozdravu aluj šă je u ănšjirkat să să ăngănđaskă šje značalešći. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Anđalu ju zăs alji: “Nuc fijă frikă, Marija! Tu aj aflat la Dimizov milă. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Punji ureći, vi rămănje gărjonă, vi făta fišjoru šă tu ji punji numi Isus! ");
INSERT INTO ronBayash_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Jăl u fi mari, šă u fi čimat Fišjoru lu Hăl Maj Mari! Šă Domnu Dimizov ju da autoritet să vladalaskă ka kralju ka kum ăj predaku aluj David. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Šă jăl u vladalit ăm familija lu Jakov dă erikeš, šă kraljevstva aluj nu ave kraj!” ");
INSERT INTO ronBayash_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Marija u ăntribat atunšje pă anđal: “Kum poći asta fi kă ju mes fată ăm păr!” ");
INSERT INTO ronBayash_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Anđalu ju ăntors vorba: “Duhu Svănt u vinji pă činji, šă pučere dă Hăl Maj Mari ću astupa ku umbră. Dăm ala rănd Kupilu Svănt šje u fi fătat dă la činji u fi čimat Fišjoru alu Dimizov. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Punji ureči: Rođakinja asta Elizabeta ăj bătărnă šă isto u ave fišjor, kă je nu puće să ajvi majmult, ali aku ăj mar ăm šasă lunj dă kănd ăj gărjonă. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kă njimika nuj nemoguće alu Dimizov!” ");
INSERT INTO ronBayash_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Atunšje u zăs Marija: “Da ju mă ligizesk ku asta să fjuv ropkinja alu Domnu. Lasă fijă aša kum tu zăšj.” Atunšje anđalu u fužjit dă la je. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Dovă tri zălji dă pă aje Marija su gătat šă u mers pă kalji, je su ăngribit ăm unu sat ăm Judeja pă đal. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Akulo are kasa lu Zaharija. Je u tunat ăm nontru šă su pozdravalit ku Elizabeta. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Kum u auzăt Elizabeta pozdravu lu Marija u sămcăt pă kupilu alji kum tari su miškat ăm injimă, šă Elizabeta are pljină ku Duhu Svănt. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Elizabeta tari u mužjit lu Marija: “Maj tari ješć blagoslovulită tu ăntri mujer, šă blagoslovulită ăj kupilu atov! ");
INSERT INTO ronBayash_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Adišje mes aša bitnă, kă tu mama lu Domnu amnjov vinji să mă posjetilaskă? ");
INSERT INTO ronBayash_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kă dăm momentu šje am auzăt pozdravalala ata, kupilu amnjov tari su miškat dă fălušăjă ăm injima ame! ");
INSERT INTO ronBayash_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Blagoslovljenă daje kă tu aj ănkrizut kă šje Domnu cu igirit sigurno u fi!” ");
INSERT INTO ronBayash_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Atunšje Marija u zăs: “Duša ame ăl slavalešći pă maj mari Domn, ");
INSERT INTO ronBayash_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","šă duhu amnjov să ănfălušešći ăm Dimizov Spasitelju amnjov, ");
INSERT INTO ronBayash_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","daje kă jăl su ujtat ku milă pă minji pă poniznă ropkinja aluj, aku toći generacijurlje mur čimamă blagoslovljenă, ");
INSERT INTO ronBayash_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","daje kă svemogući Dimizov u făkut mari djelur ku minji, šă numilje aluj ăj svănt. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Pălăngă totă sămănca, Dimizov ăj milos pălăngă eje kari ăl poštivalešći. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ku mănă aluj jăl u făkut pučernjišji lukrur. Jăl u arunkat afară pă eje kari asre ponosnă ăm sufljičilje alor šă pă eje kari asre umišljeni. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Pă heje bălour vladar lju vărlji dă pă prijestolje, a pă heje kari ăs ponizni lju riđikatulji. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","U rănjit pă flămănž ku mănkari bună, a pă găzdašji lju măna ku mănjilje golji. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Jăl u ažutat pă Izrael sluga aluj su ăngănđitusă dă milă aluj, ");
INSERT INTO ronBayash_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ka kum u obečalit alu preci anoštri dă kănva să fijă pljinj dă milă pălăngă Abraham šă pălăngă potomku aluj dă erikeš.” ");
INSERT INTO ronBayash_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Marija u rămas ku Elizabeta tri lunj atunšje su ăntorsăsă akasă. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Kănd u vinjit vreme alu Elizabeti să ajvi kupil, je u fătat fišjor. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Šă kănd ur auzăt susjedi šă njamu kă Domnu are bun pălăngă je, jej ur vinjit una la je šă să ăm făluše ku je una. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kupilu trăbuje să fijă obrezalit pă optă (8) zuva, šă kănd or vinjit una să fakă asta, jej gănđe să ăj đe numi Zaharija dă pă tatusu. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mumăsa u odbijilit šă u zăs: “Nu, jăl su čima Ivan.” ");
INSERT INTO ronBayash_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ali jej ur zăs: “Njime dăm njamuc nu u fost čimat dă pă numiljala!” ");
INSERT INTO ronBayash_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Šă aša jej ăntriba ku znakur pă tatusu alu kupilula, kum su čima. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zaharija u šjirut pločică dă skris šă u skris: “Ivan ăj numilje aluj!” Toc asre ămirac. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Šă dăm ala šas Dimizov u dăsvăkut gura alu Zaharija šă poći să svitaskă. Šă jăl dăđe slavă alu Dimizov! ");
INSERT INTO ronBayash_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Atunšje frika u vinjit pă tot susjedu šă ăm totă parće dă Judeja păm đalur šă spunje šje su dogodulit. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Toc kari ur auzăt dă aje cănje ăm firi šă să ăngănđe: “Šje u fi dăm ala kupil? Anume măna alu Domnuluj are ku kupilula Ivan.” ");
INSERT INTO ronBayash_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zaharija, tatusu alu Ivan are pljin dă Duhu Svănt, atunšje prorokovale šă zăšje: ");
INSERT INTO ronBayash_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Slava alu Domnu Dimizov alu Izrael, Kă jăl u vinjit šă să otkupilaskă pă narodu aluj! ");
INSERT INTO ronBayash_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Jăl u răđikat păntru noj pă spasitelju silni! Dăm potomstva lu sluga amnjov la kralj David. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Asta nju fost spus dăm gurălje dă proroci aluj svănc dă kănva: ");
INSERT INTO ronBayash_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","spasenje dă la dužmanji anoštri šă dăm mănj kari toc nji mărzălešći. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Are milosrdan pălăngă preci anoštri, šă u ispunulit savezu aluj svănt. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ăm zakletvă kari u dat lu Abraham, alu predaku anostru: ");
INSERT INTO ronBayash_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","să nji izbavalaskă dăm mănj alu dužmanj, să pučenj poslužulenj pă jăl făr dă frikă, ");
INSERT INTO ronBayash_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","šă să kustănj svănt šă đirept ăm toći zăljilje dă kustu anostru. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Šă tu Ivan fišjoru amnjov, tu vi fi čimat proroku alu Maj Mari Dimizov, kă tu vi meržji ăm nenće alu Domnuluj šă să ăj đireš kalje aluj, ");
INSERT INTO ronBayash_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Tu vi da alu lume lu Dimizov, Hir fălos dă spasalala šă dă jirtala dă grehurlje alor. ");
INSERT INTO ronBayash_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Kutotu asta ăj dă rănd dă sufljitu milos alu Dimizovu anostru, ka sorilje kari svitlizešči u vinji afară dăm nor pă noj sus ");
INSERT INTO ronBayash_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","u da lumină alu eje kari šađi ăm tunjerik, šă ăm umbra alu morči. Nju punji pišjorilje anoštri pă kalje dă putuljală.” ");
INSERT INTO ronBayash_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ivan u kriskut šă su ămbălurit ăm duh. Kusta ăm pustinjă păn šje nu su arătat javno alu Izraelc. ");
INSERT INTO ronBayash_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ăm aje vremi dă pă šje su avut Ivan, zapovjed u fost mănată dă la car August să fakă skritura dă stanovništvo ăm ăntragă cara. ");
INSERT INTO ronBayash_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Aje are elši skritura dă stanovništvo kari u fost kănd Kvirinije are vladar dă Sirija. ");
INSERT INTO ronBayash_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Aša toc ur mers să să prijavalaskă ăm varušu hunđi preci alor u kustat. ");
INSERT INTO ronBayash_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Aša Josip dăm mik varuš Nazaret ăm Galileja, u mers ăm varuš Betlehem ăm Judeja hunđi su avut David daje kă jej as re njamu alu kralj David. ");
INSERT INTO ronBayash_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Josip u mers akulo să să jivaskă dă skritura una ku Marija zaručnica aluj, kari are gărjonă. ");
INSERT INTO ronBayash_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Šă kum asre dăm Betlehem akulo vreme u vinjit să să ajvi kupilu. ");
INSERT INTO ronBayash_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Je u avut elši fišjor, lu ănvălitălu šă lu pus ăm hištalov daje kă nu are soba păntru jej ăm fugadov. ");
INSERT INTO ronBayash_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ăm ala lok dă apropi dă Betlehem asre pastirur kari rămănje afară pă otvoreno šă păze stadurlje alor totă nopće. ");
INSERT INTO ronBayash_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Šă dăm turdată su pojavalit anđalu alu Domnuluj! Anđalu u stat ăm nenće alor, šă slava alu Domnuluj lju svitlăzăt pă jej. Šă pastiri u gălbănjit ăm ubraz dă frikă. ");
INSERT INTO ronBayash_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ali anđalu lju zăs: “Nu vă fijă frikă! Ju vjuv să vă aduk Hir fălos, dă mari fălušăjă păntru totă lume. ");
INSERT INTO ronBayash_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ăm varušu hunđi su avut Kralj David, astăs su avut Spasitelj. Jăl are Krist, Domnu! ");
INSERT INTO ronBayash_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Asta ăj znak dă pă kari să ăl šćijec: voj vic afla pă kupilu ănvălit ăm hištalov.” ");
INSERT INTO ronBayash_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Atunšje dăm turdată lăngă parće dă anđal u vinjit mulc anđej dăm nor kari hvalale pă Dimizov. Šă jej slavale: ");
INSERT INTO ronBayash_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Slava alu Dimizov ăm nor šă pă pămănt putuljală alu eje ominj kari lju izabralit.” ");
INSERT INTO ronBayash_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Dă pă šje ur fužit anđelji dă la pastir ăm nor, pastiri ur zăs una la alt: “Haj aku am Betlehem, šă să viđenj aje dă šje Domnu nju spus!” ");
INSERT INTO ronBayash_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Aša sur ăngribit ăm Betlehem šă ur aflat pă Marija, šă pă Josip, a kupilu are ăm hištalov. ");
INSERT INTO ronBayash_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Šă kănd pastiri ur văzut pă kupil, jej sur apukatăsă să spujă šje lju fost spus dă la anđej dă kupil. ");
INSERT INTO ronBayash_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Toc eje kari ur auzăt šje pastiri ur spus, jej toc asre ămirac. ");
INSERT INTO ronBayash_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ali Marija cănje toći vorbilje alor ăm sufljičilje alor šă mult su gănđit dă jelji. ");
INSERT INTO ronBayash_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Atunšje pastiri ur fužjit la stadurlje alor šă jej dăđe hvală šă slavă lu Dimizov dă kutotu stvarurlje šje ur auzăt šă šje ur văzut, točno kum lju fost najavalit alor. ");
INSERT INTO ronBayash_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Osma zuva kănd kupilu su avut u fost obrezalit, šă u fost čimat Isus, numilje u dată aluj dă la anđal majnti dă šje Marija u rămas gărjonă. ");
INSERT INTO ronBayash_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Šă kănd u vinjit vreme alu Marija obred dă čistilală kum are zapovjedălală dă la zakonu alu Mojsije, Marije šă Josip ur dus pă Isus am Jeruzalem să ăl posvetilaskă la Domnu, ");
INSERT INTO ronBayash_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","kă ăj skris ăm zakonu alu Domnu: “Tot elši fišjor u fi posvetilită la Domnu.” ");
INSERT INTO ronBayash_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Jej trăbă isto să adukă žrtvă: “Dovă grlicur ili doj tănjiră puromb,” kum ăj zapovjedalit dă la zakonu alu Domnu anostru. ");
INSERT INTO ronBayash_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Atunšje are om ăm Jeruzalem šje să čima Šimun. Jăl are pravedan šă svet šă aščipta pă Mesija să izbavalaskă pă Izrael šă Duhu Svănt are ku jăl. ");
INSERT INTO ronBayash_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Šă Duhu Svănt majnti ju spus aluj kă no mori majnti dă šje no viđe pă Mesija alu Domnu anostru. ");
INSERT INTO ronBayash_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Aša Duhu Svănt lu dus pă Šimun ăm Hram kănd ur adus roditelji pă kupilu Isus ăm nontru šă să fakă obred kum are običaju dă zakonu alu Mojsije. ");
INSERT INTO ronBayash_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Šimun lu apukat ăm mănjilješ pă Isus, slavale pă Dimizov, šă u zăs: ");
INSERT INTO ronBayash_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Aku lasă pă sluga atov să moră ăm putuljală, Domnu, kum tu aj zăs, ");
INSERT INTO ronBayash_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","kă oči amej ur văzut spasenje ata. ");
INSERT INTO ronBayash_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Asta tu aj făkut dă totă lume. ");
INSERT INTO ronBayash_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Asta ăj lumina dă ominj šă lji svitlizaskă alu ominj kari nus Židov, slava alu lume dă Izrael!” ");
INSERT INTO ronBayash_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tata šă mama alu Isus asre umpljec ku ămirală dă kutotu šje Šimun u zăs dă jăl. ");
INSERT INTO ronBayash_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Atunšje Šimun u blagoslovulit pă jej šă u zăs lu Marija: “Dimizov u odredilit pă ala kupil kă păntru jăl mulc Izraelc ur kăđe šă su riđikasă. Jăl ăj odredilit să fijă znaku alu Dimizov, ali mulc lur odbacalilă ");
INSERT INTO ronBayash_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","aša u vinji pă lumină găndurlje askunšă alu mulc, a maču či ămpunžji ăm duša ata.” ");
INSERT INTO ronBayash_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Are isto aša proročica Ana fată alu Fanuel kari ăj dăm pleme alu Ašer. Ana are tari bătărnă mujeri, je are šapči aj ăm brak ");
INSERT INTO ronBayash_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","šă aku ăj vădojă, mar hunđiva osamdeset patru aj. Ana nu fužje dăm Hram, nego služule akulo zuva šă nopće ăm post šă ăm aruguminći. ");
INSERT INTO ronBayash_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Baš pă aje vremi Ana u vinjit, hvalale pă Dimizov, šă je spunje dă kupilu Isus alu toc kari ašćipta pă Dimizov să otkupilaskă pă Jeruzalem. ");
INSERT INTO ronBayash_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Dă pă šje ur făkut Josip šă Marije kutotu šje zakonu alu Domnu u šjirut dă la jej, jej ur mers ăm napoj ăm varušu alor Nazaret ăm Galileja. ");
INSERT INTO ronBayash_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Kupilu u kriskut šă su ămbălurităsă, are pljin dă mudrost, šă blagoslovurlje alu Dimizov asre ku Isus. ");
INSERT INTO ronBayash_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Roditelji alu Isus măržje ăm tot anu ăm Jeruzalem să fijă akulo pă blagdan dă Pasha. ");
INSERT INTO ronBayash_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Aša kănd are Isus dvanaest aj dă bătărn jăl una ku jej u mers pă blagdan ka kum stalno măržje. ");
INSERT INTO ronBayash_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Šă kănd u trikut blagdanu jej sur gătatăsă akasă, ali făr dă šćučilje alu roditelji, kupilu Isus u rămas ăm Jeruzalem. ");
INSERT INTO ronBayash_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Jej gănđe kă ăj hunđiva ăm grupă. Jej ur trikut mari kalji totă zuva, kapu sur apukatăsă să ăl koći ăntri njamu šă ăntri hej kari ăl kunošći. ");
INSERT INTO ronBayash_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Kum nu lor aflat, jej ur mers ăm napoj ăm Jeruzalem šă ăl koći. ");
INSERT INTO ronBayash_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Tri zălji dă pă aje jej lor aflat. Isus are ăm Hram, šăđe ăntri učitelji dă zakonu alu Mojsije, punje ureče šă lji ăntriba. ");
INSERT INTO ronBayash_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Toc kari ăl punje ureče asre ămirac la fire aluj, šă la odgovurlje aluj. ");
INSERT INTO ronBayash_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Roditelji aluj isto aša asre tari ămirac kănd lor văzutălă akulo šă mumăsa ju zăs: “Fišjoru amnjov adăšje njaj făkut asta anovă? Tata atov šă ju as renj ăm mari brigur dă činji, păšći tot či kutanj!” ");
INSERT INTO ronBayash_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Isus u ăntors vorba: “Ali adăšje mă kutac? Nu šćijec kă ju aš trăbuji să fjuv ăm kasa alu Tata amnjov?” ");
INSERT INTO ronBayash_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Jej nur prišjiput šje gănđe să lji spujă. ");
INSERT INTO ronBayash_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ali Isus u mers ăm napoj ku roditelji ăm Nazaret, šă jăl lju u pus ureći. Šă mumăsa aluj u cănut kutotu vorbilje ăm sufljituš. ");
INSERT INTO ronBayash_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Šă ăm aje vremi Isus u kriskut ăm gănd šă ăm telă šă ku milă dă la Dimizov šă dă la lumi. ");
INSERT INTO ronBayash_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Kănd are vladavina alu car Tiberija, trajale skoro 15 aj, Poncije Pilat are upravitelj ăm Judeja, Herod vladale ăm Galileja a Filip, fračilje aluj dă pă tata alor, vladale ăm Itureja šă ăm Trahonitida a Lizanije vladale ăm Abilena, ");
INSERT INTO ronBayash_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ana šă Kaifa asre mar popur, Dimizov u mănat porukă alu Ivan, fišjoru alu Zaharija, kari kusta ăm pustinjă. ");
INSERT INTO ronBayash_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Šă aša Ivan u mers ăm toći lokurlje pă lăngă rijeka Jordan să propovjedălaskă daje kă toc kari u grešălit, a heje kari su pokajalit să lji jarči Dimizov grehurlje a Ivan atunšje lju bučuza. ");
INSERT INTO ronBayash_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ka kum Prorok Izaija svite ăm kenvije aluj dă ešće vorbi: “Graju alu unu kari mužješči ăm pustinjă šă să auze: pripremilec kalje păntru Domnu; ravnalecă kalje! ");
INSERT INTO ronBayash_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Lasă totă dolina să fijă umpljetă šă totă planina să fijă ăm tokmă ku alčilje, šă kăljilje krivă să fijă pravă, šă kăljilje kari nus ravnă să fijă ravnă ");
INSERT INTO ronBayash_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","atunšje totă lume u viđe Spasenje dă la Dimizov.” ");
INSERT INTO ronBayash_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Alu gărmadă dă lumi kari ur vinjit la jăl să să bučazi, Ivan zăšje: “Voj leglo alu otrovni šarpi, šinji vu upozorulit să ănšjirkăc să skăpăc dăm kazna šje u vinji pă voj? ");
INSERT INTO ronBayash_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Arătăc plodur dă ănkăjală! Nu vă apukăc să vă zăšjec una lu alt: Abraham ăj tata anostru! Ju vă zăk: Dimizov poći dăm petrilješće răđika pă kupij alu Abraham!” ");
INSERT INTO ronBayash_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Mar aku săkure dă sudu alu Dimizov ăj pusă sus să taji dăm korjen ljemnu. Tot ljemnu kari nu adušji bun plod u fi tijet ăndărăt šă vărljit ăm fok. ");
INSERT INTO ronBayash_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Gărmadă lu ăntribat pă jăl: “Šje să făšjenj atunšje?” ");
INSERT INTO ronBayash_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ivan u zăs: “Dakă avec dovă kămašă atunšje ămpărcăcăvă ku ala kari nari njiš una. Dakă avec mănkari isto aša trăbă să vă ămpărcăc.” ");
INSERT INTO ronBayash_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Akulo asre isto šă carinici kari ur vinjit să să bučežă šă jej lor ăntribat: “Učitelju, šje să făšjenj?” ");
INSERT INTO ronBayash_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ivan u ăntors vorba: “Nu maj akuljižec majmult dă kită šje avec pravo să locă!” ");
INSERT INTO ronBayash_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Šă kătănjilje isto lor ăntribat: “A noj? Šje trăbă noj să făšjenj?” Alor lju zăs: “Nu loc ku săla dă njime banj, njiš nu svedočulec krivo protiv dă šjinjiva šă fijec zadovoljni ku plata avostră!” ");
INSERT INTO ronBayash_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Lume asre aku pljinj dă aščiptalur, šă să ăntriba ăm sufljičilje alor, nar puće Ivan să fijă Mesija. ");
INSERT INTO ronBayash_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ivan lju ăntors vorba alu toc: “Ju vă bučez ku apă, ali unu kari u vinji kari ăj maj bălour da minji šă lu kari nu mes vredan să ăj ljeg žnirancurlje aluj. Jăl vu bučuza ku Duhu Svănt šă ku fok. ");
INSERT INTO ronBayash_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Jăl cănji furka ăm măna aluj, šă jăl u čistili teleku temeljito. Jăl u akulježi făjna ăm skladišta aluj, ali jăl u arđi jarba uskată ăm fok šje nu să ašćinžji.” ");
INSERT INTO ronBayash_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Šă ăm mulći poticajur svite alu lume šă alu cară dă Hir fălos. ");
INSERT INTO ronBayash_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ivan lu făkut dă njimik pă car Herod dă rănd kă jăl su lot una ku Herodijada băšăcă alu fračisuš isto aša šă dă alci stvarur relji šje u făkut Herod. ");
INSERT INTO ronBayash_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","La kutotu stvarurlje relji šje u făkut jăl u pus maj una: jăl u ănkujet pă Ivan šje bučază ăm čemică. ");
INSERT INTO ronBayash_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Kănd asre totă lume bučuzac dă la Ivan, Isus isto are bučuzat. Kănd Isus su arugat su dăsvăkut noru, ");
INSERT INTO ronBayash_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","šă Duhu Svănt u vinjit žos pă jăl am formă dă purombu šă graj dăm nor u svătit: “Tu ješć Fišjoru amnjov plăkut! Tu ješć fulušuja ame!” ");
INSERT INTO ronBayash_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Aku Isus are hunđiva trideset aj dă bătărn kănd su apukat javno să propovjedălaskă. Isus are cănut dă fišjoru alu Josip. Josip are fišjor alu Eli, ");
INSERT INTO ronBayash_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli are fišjoru alu Matat, Matat are fišjoru alu Levi, Levi are fišjoru alu Malki, Malki are fišjoru alu Janaj, Janaj are fišjor alu Josip, ");
INSERT INTO ronBayash_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josip are fišjoru alu Matatija, Matatija are fišjoru alu Amos, Amos are fišjoru alu Naum, Naum are fišjoru alu Hesli, Hesli are fišjoru alu Nagaj, ");
INSERT INTO ronBayash_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaj are fišjoru alu Mahat, Mahat are fišjoru alu Matatija, Matatija are fišjoru alu Šimij, Šimij are fišjoru alu Joseh, Joseh are fišjoru alu Joda, ");
INSERT INTO ronBayash_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda are fišjoru alu Johanan, Johanan are fišjoru alu Resa, Resa are fišjoru alu Zerubabel, Zerubabel are fišjoru alu Šealtiel, Šealtiel are fišjoru alu Neri, ");
INSERT INTO ronBayash_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri are fišjor alu Malki, Malki are fišjoru alu Adi, Adi are fišjoru alu Kosam, Kosam are fišjoru alu Elmadam, Elmadam are fišjoru alu Er, ");
INSERT INTO ronBayash_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er are fišjoru alu Jošua, Jošua are fišjoru alu Eliezer, Eliezer are fišjoru alu Jorim, Jorim are fišjoru alu Matat, Matat are fišjoru alu Levi, ");
INSERT INTO ronBayash_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi are fišjoru alu Šimun, Šimun are fišjoru alu Juda, Juda are fišjoru alu Josip, Josip are fišjoru alu Jonam, Jonam are fišjoru alu Elijakim, ");
INSERT INTO ronBayash_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elijakim are fišjoru alu Meleja, Meleja are fišjoru alu Mena, Mena are fišjoru alu Matata, Matata are fišjoru alu Natan, Natan are fišjoru alu David, ");
INSERT INTO ronBayash_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","David are fišjoru alu Jišaj, Jišaj are fišjoru alu Obed, Obed are fišjoru alu Boaz, Boaz are fišjoru alu Sala, Sala are fišjoru alu Nahšon, ");
INSERT INTO ronBayash_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahšon are fišjoru alu Aminadab, Aminadab are fišjoru alu Admin, Admin are fišjoru alu Arni, Arni are fišjoru alu Hesron, Hesron are fišjoru alu Peres, Peres are fišjoru alu Juda, ");
INSERT INTO ronBayash_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda are fišjoru alu Jakov, Jakov are fišjoru alu Izak, Izak are fišjoru alu Abraham, Abraham are fišjoru alu Terah, Terah are fišjoru alu Nahor, ");
INSERT INTO ronBayash_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor are fišjoru alu Serug, Serug are fišjor alu Reu, Reu are fišjor alu Peleg, Peleg are fišjor alu Eber, Eber are fišjor alu Sala, ");
INSERT INTO ronBayash_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala are fišjoru alu Kenan, Kenan are fišjor alu Arpakšad, Arpakšad are fišjor alu Šem, Šem are fišjor alu Noa, Noa are fišjor alu Lamek, ");
INSERT INTO ronBayash_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek are fišjoru alu Metušalah, Metušalah are fišjoru alu Henok, Henok are fišjoru alu Jered, Jered are fišjoru alu Mahalalel, Mahalalel are fišjoru alu Kenan, ");
INSERT INTO ronBayash_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan are fišjoru alu Enoš, Enoš are fišjoru alu Šet, Šet are fišjoru alu Adam, a pă Adam Dimizov u stvorulit. ");
INSERT INTO ronBayash_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Isus, pljin dă Duh Svănt su ăntors dăm rijeka Jordan, šă ăl dušje Duhu păm pustinjur ");
INSERT INTO ronBayash_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","četrdeset zălji, hunđi u fost ănšjirkat dă la draku. Ăm zăljiljelje nu u mănkat njimika, šă kănd u vinjit do kraja jăl are flămănd. ");
INSERT INTO ronBayash_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Draku ju zăs atunšje: “Dakă ješć tu Fišjoru alu Dimizov zapovijedalešći alu petrilješće să să fakă pită.” ");
INSERT INTO ronBayash_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Isus ju ăntors vorba: “Skris ăj ăm svăntă kenvija: ‘Lume nu kustă numa dăm pită.’ ” ");
INSERT INTO ronBayash_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Draku lu dus pă jăl pă planină naltă, šă ăm unu moment draku ju arătat aluj kutotu kraljevstvo dă svet. ");
INSERT INTO ronBayash_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Šă draku ju zăs aluj: “Ju cuj da kutotu pučeresta šă măndremesta kari ăj dată mijă, šă ju pot da alu šinji gănđesk. ");
INSERT INTO ronBayash_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kănd čaj klanjali la minji, ju caš da kutotu cijă.” ");
INSERT INTO ronBayash_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Isus ju ăntors vorba: “Skris ăj ăm svăntă kenvija: ‘Alu Domnu, Dimizovu atov numa klanjaleščići šă pă jăl služulešči!” ");
INSERT INTO ronBayash_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Dă pă aje draku lu dus ăm varuš Jeruzalem šă lu pusălă pă maj nalt lok dă Hram. Atunšje ju zăs aluj: “Dakă ješć tu Fišjoru alu Dimizov, seri žos! ");
INSERT INTO ronBayash_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kă ăj skris ăm svăntă kenvija: ‘Jăl u zapovjedali alu anđelji aluj să či păzaskă’, ");
INSERT INTO ronBayash_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","šă ‘ču dušji pă mănă să nu či luvešć ku pišjorilje ăm petră.’” ");
INSERT INTO ronBayash_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Isus ăntoršji vorba: “U zăs ăj ăm svăntă kenvija: ‘Nu ănšjirka pă Domnu Dimizovu atov!’ ” ");
INSERT INTO ronBayash_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Atunšje kănd u trikut draku ku toći ănšjirkalurlje, lu lăsat pă jăl pă una vreme. ");
INSERT INTO ronBayash_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Isus meržji ăm napoj ăm lok dă Galileja ăm pučere lu Duh, šă vorbi dă jăl sor apukat să kružulaskă păšćitot ăm aje regijă. ");
INSERT INTO ronBayash_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jăl ănvăca ăm sinagogurlje alor šă toc ăl slavale. ");
INSERT INTO ronBayash_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jăl u vinjit ăm varuš dă Nazaret, hunđi jăl u kriskut šă pă običaju aluj, jăl u mers sămbăta ăm sinagogă. Šă su skulat să čitalaskă. ");
INSERT INTO ronBayash_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","U dată la jăl svitak dă la proroku Izaija, a jăl u dăsvkut svitku šă u aflat lok hunđi skrijă: ");
INSERT INTO ronBayash_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Duhu alu Domnuluj ăj pă minji dasupra. Dăm ala rănd jăl mu izabralit pă minji să vă propovjedalaskă Hir fălos la sărašj. Jăl mu mănat pă minji să spuj alu hej šje ăs ljigac kă poći să fijă dăsvăkuc šă lu orb kă poći să vadă šă să đe slobodă alu hej tlačalic, ");
INSERT INTO ronBayash_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","šă să proglasalesk anu pljin dă milă alu Domnuluj.” ");
INSERT INTO ronBayash_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Isus u ănčis svitku šă u dat ăm napoj la pomoćniku šă u šăzut. Šă toc ku oči ăm sinagoga u mucăt pă jăl. ");
INSERT INTO ronBayash_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Su apukat să ănveci: “Astăs asta svăntă karči, kari ac auzăt ku urečilje avoštri, su ispunulităsă.” ");
INSERT INTO ronBayash_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Jej toc să ămira la toći vorbilje dă milă šje kăđe dă pă gura aluj. Šă jej su ăntribat: “Nuj jăl fišjoru alu Josip?” ");
INSERT INTO ronBayash_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jăl lju zăs: “Ăj una izrekă kari sigurno ac pripunji pă minji. A šă meržji: ‘Doktoru, ăntrămăći pă činji săngur!’ Kutotu aj făkut, kum anj auzăt, ăm varuš dă Kafarnaum, fă šă aišje, ăm kraju atov!” ");
INSERT INTO ronBayash_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Šă jăl u zăs: “Anume, ju vă zăk niti unu prorok nu u fost ăm benji apukat ăm kraju aluj. ");
INSERT INTO ronBayash_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Anume, ju vă zăk, kănd ăm doba alu proroku Ilija ăm Izrael, noru are ănčis a ploje nu kăđe tri aj šă šinšj lunj šă are mari fomi păm totă pămăntu šă asre mulći vădojur ăm Izrael. ");
INSERT INTO ronBayash_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Tot Ilija nu u fost mănat la njišj unu dăm jej osim la vădoja ăm Sarfata dapropi dă varušu Sidon. ");
INSERT INTO ronBayash_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Isto aša ăm vreme dă prorok Elizeja asre mulc gubavcur ăm pămăntu dă Izrael. Šă njiš unu dăm jej nor fost čistilic osim Naamana Sirijaca.” ");
INSERT INTO ronBayash_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Kănd ur auzăt, toc ăm sinagogă asre tari mirgiš, ");
INSERT INTO ronBayash_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","jej sur skulat sus šă lur mănatulă afară dăm varuš. Jej lur dus pă jăl pă maj nalt đal pă kari are varušu făkut, ăm namjeră să ăl ămpingă žos să ăl amori. ");
INSERT INTO ronBayash_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ali jăl u fužjit ăntri jej šă u mers pă kalje aluj. ");
INSERT INTO ronBayash_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jăl u mers žos ăm Kafarnaum ăm varuš dă Galileja. Šă akulo sămbăta ănvăca. ");
INSERT INTO ronBayash_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Lume asre ămirac la ănvăcală aluj daje kă vorba aluj asre pljinji dă pučeri. ");
INSERT INTO ronBayash_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Unu dăm ominjije ăm sinagogă ave rov duh ăm jăl, aje are drak. Šă jăl u mužjit ku graju glasnik: ");
INSERT INTO ronBayash_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“A! Tu Isus dăm Nazaret, šje gănđešći dă la noj? Aj vinjit să nji uništilec? Ju šćuv benji šjinji ješć tu, tu Svăntu alu Dimizov!” ");
INSERT INTO ronBayash_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Isus lu lot pă frikă šă ju zăs: “Fi putuljit! Hajde afar dăm omusta odma!” Drakula lu vărljit pă omula žos ăm nenće alu toc šă u jăšăt afară, šă njimik nu ju făkut. ");
INSERT INTO ronBayash_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Eje kari ur văzut asre tari ămirac šă zăšje una lu alt: “Šjefăldă vorba ăj asta? Ku autoritet šă ku pučeri šă relji duhovur jašă afară pă vorba aluj!” ");
INSERT INTO ronBayash_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Hiru dă jăl u mers ăm tot kotu dă regijă ăntragă. ");
INSERT INTO ronBayash_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Kănd u fužjit dăm sinagogă jăl u mers la Šimun akasă. Akulo asre sokra alu Šimun ăm pat bičagă ku fok mari ăm je. Šă jej lor ăntribat pă jăl să ăj ažući. ");
INSERT INTO ronBayash_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Isus u mers la je u lot pă frikă pă foku šă foku u lăsatu. Je odma su skulatăsă šă su apukat să lji poslužulaskă. ");
INSERT INTO ronBayash_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Mar kănd să slăbuze sorilje žos toc kari ave njam šă urtaš dăm mulči bičišugur ljor adus la jăl. Šă jăl lju ăntrimat aša dă jăl punje mănjilje aluj pă jej unu pă kići unu. ");
INSERT INTO ronBayash_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Mulc dăm jej ave drašj ăm jej šă kum jăše afară, drašjije dăm jej mužje: “Tu ješć Fišjoru alu Dimizov!” Ali jăl lju răspită šă nu lji dăđe să svitaskă kă jej šćije ka jăl ăj Krist. ");
INSERT INTO ronBayash_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Mar kum vinje zuva jăl u fužjit dăm kasă pă lok pustulot. Gărmadă dă lumi ăl kuta, šă kănd lor aflată gănđe să ăl căjă să nu fugă dă la jej. ");
INSERT INTO ronBayash_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ali Isus lju zăs: “Ju trăbă să mă duk ăm alčilje varušur să spuj Hir fălos dă kraljevstva alu Dimizov. Dăm asta rănd am fost mănat pă pămănt.” ");
INSERT INTO ronBayash_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Šă aša u mers să propovjedalaskă păm sinagogur ăm Judeja. ");
INSERT INTO ronBayash_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ăm una ză Isus stăće lăngă Genezaretsko jezero, kănd gărmadă să astrănžje la jăl să audă vorba alu Dimizov. ");
INSERT INTO ronBayash_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jăl u văzut doj čamcur kum asre pă mal răzămac, kari u lăsat ribari kănd ăš čistile mrežurlje. ");
INSERT INTO ronBayash_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jăl u tunat ăm čamac kari are alu Šimun, šă lu ăntribat să ăl ămpingă maj ăm sus dă la mal. Atunšje jăl u šăzut žos šă su apukat să ănveci pă gărmadă dă lumi. ");
INSERT INTO ronBayash_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Kănd u fost gata ku ănvăcala, jăl u zăs alu Šimun. “Ămpinži ăm maj adănkă apă šă slăbuzăc mrežurlje ăm apă.” ");
INSERT INTO ronBayash_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Šimun ju ăntors vorba aluj: “Domnu luj, anj lukrat totă nopće šă njimik nanj apukat: ali pă vorba ata ju uj slăbuză mreža ăm napoj ăm apasta.” ");
INSERT INTO ronBayash_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kănd u făkut aša jej u apukat mari boglă dă pešć, atit dă mreža kit nu puknje. ");
INSERT INTO ronBayash_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Jej ur mužjit la urtašji alor dă pă alčilje čamcur să lji ažući; jej ur vinjit, šă umpljet dovă karur dă pešć dă maj šjeva să ăntupe. ");
INSERT INTO ronBayash_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Kănd u văzut Šimun Petar aje jăl u kăzut la pišjorilje alu Isus šă u zăs: “Maknaleščići dă la minji, Domnu, kă ju mes grešnă om!” ");
INSERT INTO ronBayash_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Frikă delj svăntă u kăzut pă jej šă pă ominj šje ur vinjit să lji ažući, kănd ur văzut kic pešć ur apukat. ");
INSERT INTO ronBayash_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Isto aša asre ămirac Ivan šă Jakov, jej asre Zebedejevi fišjori šă urtašji alu Šimun. Ali Isus u zăs alu Šimun: “Nuc fijă frikă. Dă aku, maj menkulo tu vi apuka pă ominj!” ");
INSERT INTO ronBayash_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Aša jej ur adus karurlje dă apă pă mal, ur lăsat kutotu šă lor sljedilit pă jăl. ");
INSERT INTO ronBayash_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Isus are ăm unu dăm varušurljelje. Om pljin dă gubă lu văzutulă pă jăl šă su arukănt pă đinučiš ăm nenće aluj šă să aruga la jăl: “O Domnu, dakă numa tu vuješć, tu mă poc ăntrima.” ");
INSERT INTO ronBayash_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Isus u măcăt măna aluj šă lu taknulit, šă u zăs: “Ju gănđesk. Fi čistilit!” Šă dănturdata guba lu lăsat. ");
INSERT INTO ronBayash_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Atunšje lu purunšjitulă să nu spujă alu njime, čar asta să fakă: Elši să mergă la popă šă să să areći, dă pă aje, dă dokaz dă vražă, vi trăbuji să adušj žrtvă dă čistilală ka kum Mojsije u zapovijedălit. ");
INSERT INTO ronBayash_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Svat dă jăl su širilit maj pă dăparći, aša dă gărmadă dă lumi ur vinjit să pujă ureći la jăl, šă să fijă ozdravalic. ");
INSERT INTO ronBayash_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","A jăl să tărăje pă lok pustulot šă să posvetilaskă la aruguminći. ");
INSERT INTO ronBayash_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ăm una ză, Isus ănvăca, ave ăm nenći pă mulc farizej šă učitelj dă zakonu alu Mojsije kari ur vinjit dăm toći kumpănjilje dă Galileja šă Judeja šă dăm Jeruzalem. Pučere alu Domnuluj are ku Isus să ozdravalaskă pă bičež. ");
INSERT INTO ronBayash_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Atunšje šjeva ka ominji ur vinjit šă adušje pă om kari nu puće să umblji. Šă jej gănđe să ăl adukă la Isus. ");
INSERT INTO ronBayash_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ali nu are lok pă hunđi să ăl adukă ăm nontru dă gužva mari. Aša jej sur urkatăsă pă krov šă lor slăbuzăt ăm nontru păm krov ku pat dă tot la dă dă nenče alu Isus. ");
INSERT INTO ronBayash_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Kănd u văzut ănkriđala alor, jăl u zăs aluj: “Omulji, grehurlje atelji ăs jirtaći.” ");
INSERT INTO ronBayash_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Pă ešće vorbi farizeji šă učitelji dă zakonu alu Mojsije să gănđe: “Šjinji ăj omusta šje svitešći aša protiv dă Dimizov? Šjinji osim dă Dimizov poći să jerći grehurlje?” ");
INSERT INTO ronBayash_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Isus šćije šje să gănđešći, šă jăl lju zăs: “Adăšje vă ăntribăc ešće stvarur ăm sufljičilje avoštri? ");
INSERT INTO ronBayash_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Šje ăj maj ušuri dă zăs: ‘Grehurlje cis jirtaći!’, ili să zăšj: ‘Skolăći šă umblă?’ ");
INSERT INTO ronBayash_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ali numa să šćijec kă Fišjoru alu Omu ari autoritet aišje pă pămănt să jerći grehurlje. Dakă zăk alu fišjoru kari nu poči să umblji: ‘Skolăći, jec patu šă dući akasă!’ ” ");
INSERT INTO ronBayash_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Šă odma su skulatăsă šu lot patu pă šje are pă košći, šă u fužjit akasă, šă pă kalji slavale pă Dimizov. ");
INSERT INTO ronBayash_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Šă toc akulo asre ămirac, šă jej slavale pă Dimizov. Šă ku ămirală svite: “Astăs anj văzut šjeva tari mari!” ");
INSERT INTO ronBayash_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Dă pă aje Isus u jišăt afară šă lu văzutulă pă carinik šje să čima Levi, jăl šăđe ăm carinarnică. Isus u zăs: “Sljedilešći mă pă minji!” ");
INSERT INTO ronBayash_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Šă jăl su skulat u lăsat kutotu, šă lu sljedilit. ");
INSERT INTO ronBayash_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Atunšje Levi ăm kasa aluj u făkut mari slavălală păntru jăl; ku jej šăđe mulc carinici šă alci la masă. ");
INSERT INTO ronBayash_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Farizeji šă učitelji dă zakonu alu Mojsije, sur apukat să gumunjaskă kapu su apukată să svitaskă alu učenikurlje alor: “Adišje mănkăc šă bijec ku carinici šă ku grešnici?” ");
INSERT INTO ronBayash_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Isus u ăntors vorba: “Eje kari ăs sănătoš nu trăbă pă doktor, numa aluje kari ăs bičež. ");
INSERT INTO ronBayash_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ju nam vinjit să čem šă să ăntork pă pravedni, nego pă grešnă.” ");
INSERT INTO ronBayash_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Jej atunšje jară u zăs: “Učenici alu Ivan šă alu farizejilor postulešći mulći răndur šă să arogă, ali učenici atej mănănkă šă be. Adăšje ăj aša asta?” ");
INSERT INTO ronBayash_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Isus u ăntors vorba: “Pučec să punjec pă gošć dă nuntă să postulaskă kănd ăj mladoženja ku jej? ");
INSERT INTO ronBayash_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ali u vinji ză kănd mladoženja u fi lot ăndărăt dă la jej, šă kănd u vinji vreme jej ur postuli.” ");
INSERT INTO ronBayash_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jăl lju spus dă una usporedbă: “Njime no rupi um dărab dă la novă colă šă su kărpaskă pă bătărnă, kănd ar fašji aje, pă haj novă colă ar ave gaură, a alu haj bătărnă nar pasali dărăbu dă la novă col. ");
INSERT INTO ronBayash_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Njime nu varsă nov vinu ăm bătărnă šă mari čuturica; nov vinu ar puknji ăm čuturica šă sar vărsa vinu, a čuturica ar propadnuli. ");
INSERT INTO ronBayash_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nov vinu trăbă să fijă vărsat ăm novă čuturica. ");
INSERT INTO ronBayash_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Šă njime dă pă šje u be vin bătărn nu gănđešći să be nov, kă zăšji: ‘Bătărn ăj dăstul dă bun.’” ");
INSERT INTO ronBayash_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Un dată pă zuva dă sămbăta Isus trăšje păm šjeva ka poljă dă pšenică. Učenici aluj ur skos pšenică šu u ribile ku mănjilje šă mănka. ");
INSERT INTO ronBayash_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ali orikic dă farizej ljur zăs alor: “Adăšje făšjec šjeva šje nu ăj ku zakonu ăm tokmă pă zuva dă sămbăta?” ");
INSERT INTO ronBayash_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Isus ju ăntors vorba: “Nac čitalit ăm Svăntă kenvija, šje u făkut David kănd are jăl šă učenici aluj flămănš? ");
INSERT INTO ronBayash_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Kum ur tunat ăm kasa alu Dimizov, David šă u lot pita kari are pusă ăndărăt dă žrtvă, kari čar poči popa să mănăšji, šă su umpărcăt dăm pite ku urtašji?” ");
INSERT INTO ronBayash_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Atunšje jăl lju zăs alor: “Fišjoru Omuluj ăj Domnu dă sămbăta.” ");
INSERT INTO ronBayash_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Pă alta zuva dă sămbăta jăl u mers ăm sinagogă šă su apukat să ănveci. Akulo are om alu kari are măna njimurogă. ");
INSERT INTO ronBayash_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Šă učitelji dă zakonu alu Mojsije šă farizeji să ujta pă jăl să vadă dakă lu ăntrimală jăl pă zuva dă sămbăta. Šă jej dabe šjeva ašćipta să fakă krivo să potă să svitaskă protiv dă jăl. ");
INSERT INTO ronBayash_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jăl šćije šje să gănđešći, šă u zăs alu omuluje ku măna njimurogă: “Skolăći šă hajd dă dă nenći.” Jăl su skulat šă stăće akulo. ");
INSERT INTO ronBayash_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Isus atunšje u zăs alor: “Ju gănđesk să vă ăntreb, ăj benji să fašj benji pă zuva dă sămbăta, ili relji? Să spasalaskă kustu ili să uništilaskă?” ");
INSERT INTO ronBayash_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Atunšje su ujtat okolo pă tot omu, šă jăl u zăs alu omuluje: “Măcešćic măna!” Jăl u făkut aša, šă mănă ju fost sănătosă ka hajelantă. ");
INSERT INTO ronBayash_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ali jej asre tari mirgiš šă sur apukat să svitaskă šje să fakă alu Isus. ");
INSERT INTO ronBayash_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Una ză u mers pă planină să să arožji, šă jăl u fost akulo totă nopće ăm aruguminći la Dimizov. ");
INSERT INTO ronBayash_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Haje zua jăl u čimat pă dvanaest (12) učenikur la jăl pă kari lju akuljes šă lju čimat apostoli. ");
INSERT INTO ronBayash_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ešće asre: Šimun pă kari lu čimat Petar, šă fračisu Andrija, Jakov šă Ivan, Filip šă Bartolomej; ");
INSERT INTO ronBayash_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matej šă Toma, Jakov fišjoru alu Alfej šă Šimun čimat Revan, ");
INSERT INTO ronBayash_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Juda fračisu lu Jakov šă Juda Iskariot, kari u fi izdajica. ");
INSERT INTO ronBayash_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Kum vinje ku jej ăm napoj žjos, jăl u stat pă čistină dă đal hunđi asre grupa dă učenici aluj šă mari gărmadă dă lumi sur akuljesăsă, jej ur vinjit dăm Judeja šă dăm varuš Jeruzalem šă dăm Tir šă Sidon varušurlje lăngă more. ");
INSERT INTO ronBayash_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Jej ur vinjit šă ăl punje ureći, šă să fijă ozdravalic dăm bičišugurlje alor. Isto aša u ozdravalit pă heje kari ave relji duhovur ăm jej. ");
INSERT INTO ronBayash_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Mulc gănđe să pujă măna pă jăl daje kă pučeri fužje dăm jăl šă puće pă toc să lji iscjelilaskă. ");
INSERT INTO ronBayash_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Atunšje su ujtat ăm oč pă učenici aluj šă u svătit: “Ănfălušăcăvă voj kari ščec sărašj kă kraljevstva alu Dimizov aj avostră. ");
INSERT INTO ronBayash_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ănfălušăcăvă voj kari ščec flămănž, kă vic fi sătuj. Ănfălušăcăvă voj kari plănžjec, kă voj vic răđi. ");
INSERT INTO ronBayash_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ănfălušăcăvă voj kari ščec mărzălic, rušunac šă mănac ku relji dă răndu alu Fišjoru Omuluj. ");
INSERT INTO ronBayash_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Kănd u vinji zue, ănfălušăcăvă šă sărec păm sus dă fălušăjă. Kă sigurno nagrada avostră u fi mari ăm nor. Haleluja! Nus are aša šă proroci tretiralică dă la mošurlje alor! ");
INSERT INTO ronBayash_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ali jao avovă, kari ščec găzdašj, kă ac apukat utjehă! ");
INSERT INTO ronBayash_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Jao avovă kari ščec sătulj, kă voj vic fi flămănž. Jao avovă kari aku răđec, kă voj vic žalali šă plănžji! ");
INSERT INTO ronBayash_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Jao avovă dă kari toc benji svitešći, aša isto fišjec pă mišjinjoš prorokur, mošurlje alor kari aša fišjec.” ");
INSERT INTO ronBayash_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“A voj kari mă punjec ureći, vă zăk: ‘Plăšjecăvă pă dužmanji avoštri. Făšjec benji alor kari vă mărzălešći. ");
INSERT INTO ronBayash_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Blagoslovulec pă eje kari vă blastămă! Arugăcăvă dă eje kari relji vă kivinješći. ");
INSERT INTO ronBayash_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Hăl kari či luvešći păšći una parći dă ubraz, ămbijă šă haje parći atunšje. Šă alu hăl kari ac je šuba nuj branalec să ăc je šă kămašă. ");
INSERT INTO ronBayash_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Dă alu toc, šje šjeri dă la činji. Dakă je šjinjiva šjeva šje ăj atov, nu šjire să ac đe ăm napoj. ");
INSERT INTO ronBayash_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Aša maj, făšjec alu altora kum ac gănđi să vă fakă avovă. ");
INSERT INTO ronBayash_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Dakă plăšjec numa pă eje kari vă plašji pă voj, šjefăldă hvală vic kăpăta? Ka šă čak šă grešnici plašji pă eje kari lji plašji pă jej. ");
INSERT INTO ronBayash_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Šă dăkă făšjec numa benji alu eje kari fašji vovă benji, šjefăldă hvală vic kăpăta? Čak šă grešnici fašji aje. ");
INSERT INTO ronBayash_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Dakă dăđec kečinj alu alor dă la kari aščiptăc să vă ăntorkă ăm napoj, šjefăldă hvală vic kăpăta? Čak šă grešnici dă kečinj alu grešnici să potă ăm napoj să kepiči kit lju dat. ");
INSERT INTO ronBayash_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Plăšjec pă dužmanji avoštri, ažutăcălji šă dăđec kečinj, ali nu aščiptăc să vă ăntorkă ăm napoj. Atunšje voj vic kăpăta mari nagradă šă voj vic fi čimac fišjori alu Maj Mari Dimizov daje kă jăl aj bun alu nezahvalni šă alu ubraznjiš. ");
INSERT INTO ronBayash_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Fijec miloš kă jăl Tata dăm nor ăj pljin dă milă.” ");
INSERT INTO ronBayash_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Nu sudulec pă njime, šă njime nu vu suduli pă voj. Nu osudulec pă njime, šă njime nu vu osuduli! Jirtăc šă vu fi jirtat. ");
INSERT INTO ronBayash_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Dăđec šă vu fi dat bună meră astrănsă, zdrănšinată šă tari multă u fi vărsată ăm saku avostru. Kă ku ista mjeră šje voj dăđec vu fi dată.” ");
INSERT INTO ronBayash_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jăl lju spus izrekă: “Poći unu orb să adukă dă mănă pă altu om orb? Nar kăđe jej amăndoj ăm gropă? ");
INSERT INTO ronBayash_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Učeniku nu poći fi maj mari dă učitelju. Jăl u fi ka učitelju aluj kănd su vježbăli dăstul dă benji. ");
INSERT INTO ronBayash_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Adăšje vă ujtăc tot la cupljigă ăm oču alu urtaku, a ăm oču atov nu ves dărab dă ljemn? ");
INSERT INTO ronBayash_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Kum poc zăšji alu urtaku: ‘Lasămă să skot cupljigă dăm očuc’, kănd nu ves dărăbu mari dă ljemn ăm oču atov? Licemjeru, elši skočec dărăbu dă ljemn dăm očuc, kapu vi puće maj benji să skoc cupljigă dăm oču alu urtaku.” ");
INSERT INTO ronBayash_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Tot bun ljemnu ari bun plod, šă tot ljemnu kari nuj bun, fašji nu bun plod. ");
INSERT INTO ronBayash_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tot ljemnu ăj kunuskut dă pă plod šje fašji. Aša lume nu akulježi smokvur ili strugur dăm măršunj. ");
INSERT INTO ronBayash_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Om bun fašji bunji stvarur daje kă ari bună sufljit, ali hej rov fašji stvarur relji daje kă sufljitu lji rov. Gura svitešći, dăm šje ci sufljitu pljin.” ");
INSERT INTO ronBayash_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Šă dăšje mă čimăc: ‘Domnu! Domnu!’, a nu făšjec šje vă zăk? ");
INSERT INTO ronBayash_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ju vuj spunji kum ăj om kari vinji la minji să puji ureći la vorba ame, šă askultă: ");
INSERT INTO ronBayash_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Jăl ăj ka omu šje u gradalit kasa šă u kapalit adănkă să pujă temeljurlje pă petră. U vinjit poplava šă u luvit apa ăm kasa šă njiš nu su zdrănšjinat daje kă are benji gradalită. ");
INSERT INTO ronBayash_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ali ala kari auzăt šje am zapovjedalit a nu făkut aje ka omu šje u gradalit kasă pă pămănt făr dă temelj. Atunšje u luvit apă ăm kasă, su răsăpit dăm turdată šă u fost răstunată dokraja šă čar gunojă u rămas.” ");
INSERT INTO ronBayash_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Kănd u fost gata ku svatu šje svite alu lumi, jăl u mers ăm varuš dă Kafarnaum. ");
INSERT INTO ronBayash_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Akulo are stotnik kari ave sluga pă kari ăl cjenile šă kari are aša bičag dă are pă morči. ");
INSERT INTO ronBayash_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Stotnik u auzăt da Isus šă u mănat pă orikic Židov kari asre glavni la jăl, šă să să arožji, să vijă să ăntremi pă sluga aluj. ");
INSERT INTO ronBayash_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Jej ur vinjit la Isus šă să aruga tari la jăl să vijă. Jej u zăs: “Omusta anume zaslužulešći să fašj aje păntru jăl ");
INSERT INTO ronBayash_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","daje kă plašji pă narodu anostru, šă jăl ăj ala kari u făkut sinagogă păntru noj.” ");
INSERT INTO ronBayash_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Isus u mers ku jej. Šă jăl no mers dăparći dă la kasa, kănd stotnik u mănat pă urtašji aluj să zăkă: “Domnu, nu či činji să vij ăm kasa ame kă ju nu mes vredan să vijă tu dăsup krovu amnjov! ");
INSERT INTO ronBayash_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Kă njiš ju nu mă smatralăsk kă mes vredan să vjuv la činji. Aša numa ză vorba dă pă loku hunđi ješć šă sluga amnjov u fi ăntrimat. ");
INSERT INTO ronBayash_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kă šă ju mes kătănă kari trăbă să apukă zapovjedur dă la vođa amnjov, ka kum am kătănj dăsupă minji kari trăbă să mă askulči. Ju kănd zapovijedalaskă alu unu: ‘Dući!’, šă jăl merži, šă alu aluje: ‘Hajdi!’, šă jăl vinji, šă alu sluga amnjov kănd ăj zăk: ‘Fă asta!’, šă jăl fašji.” ");
INSERT INTO ronBayash_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Kănd Isus u auzăt aje šje u zăs, jăl su ămirat, šă su ăntors la gărmadă šje ăl sljedile šă jăl lju zăs: “Ju vă zăk kă njiš pă unu Židov dăm Izrael nam aflat ku dăstafel vjeră!” ");
INSERT INTO ronBayash_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Kănd heje mănac dăla stotnik su ăntors akasă, jej or aflat pă sluga sănătos. ");
INSERT INTO ronBayash_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Dă pă aje, Isus u mers ăm varuš šje să čamă Nain. Učenici aluj šă gărmadă dă lumi umbla dă pă jăl. ");
INSERT INTO ronBayash_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ali kum ur vinjit dă apropi la uša dă varuš, u văzut kum dušje pă om mort să ăl ăngropi. Mumăsa alu omula mort are vădoja, šă je ave čar unu fišjor. Šă la mărmănči măržje multă lumi. ");
INSERT INTO ronBayash_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Kănd u văzutu Domnu, jăl ave milă, šă ju zăs: “Nu plănžji.” ");
INSERT INTO ronBayash_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Atunšje jăl u pus măna pă kărpašo, šă ominji šje ăl dušje u stat. Atunšje jăl u zăs: “Fišjorulji, ju ac zăk: ‘Skolăći!’ ” ");
INSERT INTO ronBayash_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Šă omu mort su skulat šă su apukat să svitaskă šă Isus lu datălă la mumăsa. ");
INSERT INTO ronBayash_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Mari frikă u kăzut pă jej toc šă su apukat să hvalalaskă pă Dimizov, šă zăšje: “Mari prorok u vinjit ăntri noj! Dimizov u vinjit să ažuči alu lume aluj.” ");
INSERT INTO ronBayash_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Šă hiru dă asta u mers ăm Judeja šă okolo. ");
INSERT INTO ronBayash_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Učenici alu Ivan ăj spunje dă kutotu šje să događale. Kapu Ivan u čimat pă doj učenikur aluj ");
INSERT INTO ronBayash_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","šă lju mănat la Domnu să ăl ăntrebi: “Ješć tu ala kari Dimizov u zăs kă trăbă să vijă ili trăbă să aščiptănj pă altu?” ");
INSERT INTO ronBayash_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Kănd u ažuns jej la Isus, jej u zăs kă Ivan šje bučază nju mănat să či ăntribănj: “Ješć tu ala kari Dimizov u zăs kă trăbă să vijă ili trăbă să aščiptănj pă altu?” ");
INSERT INTO ronBayash_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Isus baš ăntrima atunšje pă multă lumi dăm bičišugur, mukur šă lji oslobodule dăm rov duh, šă alu mulc ominj orb lji dăđe să vadă dăm tot sufljitu. ");
INSERT INTO ronBayash_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Isus lju ăntors vorba: “Dušjec ăm napoj la Ivan šă spunjecăj šje ac văzut šă ac auzăt, šje ăm făkut: kă orbi ăs ăntrimac, šă poći viđe, šlagărzăci poći umbla, gubavci să čistilešči, šă surži poći să audă, morci să skolă ăm kust, šă alu sărašj propovijedalešči Hir fălos. ");
INSERT INTO ronBayash_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Šă blagoslovulit ăj om kari nu află njimika ăm minji šje poći uvredălaskă.” ");
INSERT INTO ronBayash_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Kănd u fužjit glasnici alu Ivan ăndărăt, Isus su apukatăsă să spujă alu gărmadă dă Ivan: “Šje ac mers să viđec ăm pustinjă? Trskă kum să ljagăna pă vănt? Naravno kă nu! ");
INSERT INTO ronBayash_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ili šje ac mers să viđec? Atunšje ac mers să viđec kum ăj ămbărkată ăm šjefelj colji delj măndri? Naravno kă nu! Eje kari ăs măndru ămbrăkac šă kustă ăm luksuz, pă eje lji pućec afla ăm palačur dă kraljur. ");
INSERT INTO ronBayash_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Atunšje šje ac mers să viđec? Pă prorok? Naravno kă da! Ju vă zăk, šă maj mult dă prorok! ");
INSERT INTO ronBayash_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Jăl ăj om dă kari aj skris ăj ăm svăntă kenvija: ‘Ujtăcăvă, asta ăj amnjov glasnik mănat să pripremalaskă ăm nenći kalje ata.’ ");
INSERT INTO ronBayash_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Anume vă zăk, dăm toc ominj kari su avutăsă, nu are maj mari dă kit dă Ivan. Ali majmikă ăm kraljevstva alu Dimizov ăj maj mari dă jăl!” ");
INSERT INTO ronBayash_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Toc kari u auzăt ur priznalit kă šje Dimizov ănvacă ăj benji, čak šă carinici. Eje ăs kari Ivan lju bučuzat. ");
INSERT INTO ronBayash_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ali farizeji šă učitelji dă zakonu alu Mojsije ur odbjilit planu alu Dimizov šje ave păntru jej. Jej ur odbjilit să lji bučeži Ivan. ");
INSERT INTO ronBayash_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Isus u zăs atunšje: “Ku šje să usporedilenj pă ešće ominj ăm asta vremi? Kum samănă jej? ");
INSERT INTO ronBayash_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Jej ăs ka kupiji mišj šje njimik nu lji pasalešći, kari šađi pă trg, šă să čamă una pă alt: ‘Kănd anj kăntat păntru voj, voj nac žukat, šă kănd anj kăntat trišč kănčiši păntru voj, voj nac plăns!’ ");
INSERT INTO ronBayash_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Aša kănd u vinjit Ivan šje bučază jăl nu mănka pită njiš nu bije vin, mar voj ac zăs: ‘Jăl ari drak ăm jăl!’ ");
INSERT INTO ronBayash_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Šă ju, Fišjoru alu Omu, am vinjit, šă ju mănkam šă bjem, ali voj zăšjec: ‘Ujtăcăvă! Flămănd šă butor, urtaku lu carinici šă alu grešnici!’ ");
INSERT INTO ronBayash_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ali mudrostu alu Dimizov su arătat kă ăj anume dă la toc kari u apukat.” ");
INSERT INTO ronBayash_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Unu dăm farizej Šimun, lor čimatulă pă jăl pă večeră, aša Isus u mers la farizejula akasă šă šu aflatusă lok la masă. ");
INSERT INTO ronBayash_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Dăm turdată u vinjit una tari grešnă mujeri, kari u saznalit kă jăl ăj akulo šă kă mănănkă la farizej, šă je u vinjit akulo, u adus tari skumpă uloj ku miros ăm skumpă ujagă dăm petră. ");
INSERT INTO ronBayash_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Je u stat dănapoju aluj, la pišjorilje aluj, šă su apukat să plăngă. Atunšje su apukat să ăj spelji pišjorilje aluj ku lăkrmilje alji, šă să aščargă pišjorilje ku păru alji. Je ăj săruta pišjorilje aluj, šă ku uloj mănže. ");
INSERT INTO ronBayash_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Kănd u văzut aje farizeju Šimun kari lu čimatulă pă večeră, jăl să ăngănđe ăm jăl săngur: “Să fijă omusta anume prorok, jăl ar šći kă je ăj tari grešnă mujeri.” ");
INSERT INTO ronBayash_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Isus ju zăs: “Ju am šjeva să ac zăk cijă Šimun.” Šă Šimun u zăs: “Učitelju ză.” ");
INSERT INTO ronBayash_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Isus u vorbit: “Are om kari dăđe kečinj šă jăl ave doj daturaš. Unu ji are dator petsto banj dăm aržjint a halalănt pedeset banj dăm aržjint. ");
INSERT INTO ronBayash_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Njiš unu dăm jej nu u dat a nu ave dăm šje să ăj ăntork, šă omula u jirtat alu amăndoj. Aku spunjec kari ar trăbuji să ăl plakă maj tari?” ");
INSERT INTO ronBayash_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Šimun ju ăntors vorba: “Kă ar trăbuji să fijă ala alu kari ju jirtat maj mult.” Isus ju zăs: “Benji aj prosudulit.” ");
INSERT INTO ronBayash_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Atunšje su ăntors la mujere šă jăl u zăs alu Šimun: “U vejs pă mujeresta? Ju am vinjit ăm kasa ata ali nu maj dat apă păntru pišjorilje amelji, a je mu lju spălat ku lăkrmilje šă lju aščers ku păru alji. ");
INSERT INTO ronBayash_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nu maj sărutatămă pă minji, ali je mu surătat pišjorilje dă kănd u vinjit ăm nontru, no stat să mă sărući. ");
INSERT INTO ronBayash_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Tu nu maj unsă kapu ku uloj ali je mu unsă kapu amnjov ku uloj ku parfem. ");
INSERT INTO ronBayash_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Dăm asta rănd ju ăc zăk cijă: ‘Mulći grehur jisă jirtaći, daje kă mu plăkut tari. Alu ala kari ari maj pucănj dă jirtat, ala maj pucăn mu arătat plăkătură.’” ");
INSERT INTO ronBayash_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Atunšje u zăs alu mujere: “Grehurlje atelji ăs jirtaći.” ");
INSERT INTO ronBayash_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Atunšje eje kari asre la masă ku jăl sur apukat să svitaskă una ku alt: “Šinji ar puće asta să fijă kari šă grehurlje jartă?” ");
INSERT INTO ronBayash_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","A jăl u zăs alu mujere: “Ănkriđala ata ću spasalit. Dući ăm putuljală.” ");
INSERT INTO ronBayash_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Dă pă aje, Isus u mers păm alčilje varušur šă satur, să propovjedălaskă šă să svitaskă dă Hir fălos dă kraljevstva alu Dimizov. Dvanaest (12) učenikur umbla dă pă jăl, ");
INSERT INTO ronBayash_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","šă šjeva ka mujerilje kari Isus lju oslobodulit dăm rov duhur šă dăm bičišugur: Marija (kari are dăm varuš Magdala, kari u mănat sedam drašj dăm je), ");
INSERT INTO ronBayash_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ivana (băšăca alu upravitelj Kuza a jăl are upravitelj păntru Herod), Suzana, šă mulći alčilje căngăšj. Jelji lji služule ku benjilje šje ave. ");
INSERT INTO ronBayash_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Mari gărmadă să akuljiže šă lume inka vinje la Isus dăm tot varušu. Isus u svătit alor ku usporedbă ");
INSERT INTO ronBayash_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Om šje samănă u mers să seminji sămănca aluj. Šă kum sămăna orikiči dăm sămancurljelje u kăzut pă kalji. Šă sămănce are kălkată, păn šje nor vinjit vrabujilje šă lju mănkalji. ");
INSERT INTO ronBayash_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Šă orikići ur kăzut ăntri petri šă jelji ur kriskut friš, ali sur uskat kă lji ibize vlagă. ");
INSERT INTO ronBayash_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Šă orikići sămăncur ur kăzut ăntră măršunj šă u kriskut ku jej una, ali lji šăguša măršunji. ");
INSERT INTO ronBayash_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Šă orikići u kăzut pă bun pămănt, šă u kriskut šă u avut sto răndur majmult.” Kănd Isus u fost gata ku usporedba u mužjit: “Punjec ureći voj kari avec ureći să auzăc!” ");
INSERT INTO ronBayash_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Učenici aluj lor ăntribat pă Isus atunšje, šje značale usporedbe. ");
INSERT INTO ronBayash_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Isus u zăs: “Avovă Dimizov u dopustulită să prišjipec tajnurlje dă kraljevstva alu Dimizov, ali alu alci trăbă să să spujă ăm usporedbur; ka kum u zăs prorok Izaija: Ăs eje kari să ujtă ali nu veđi, kari auđi ali nu prišjepi. ");
INSERT INTO ronBayash_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Aku usporedba značalešći asta: Sămănca ăj ka Vorba alu Dimizov. ");
INSERT INTO ronBayash_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Sămănca kari ăj pă kalji, ăs ka eje ominj kari auđi Vorba, ali draku u vinji šă lji je vorba ăndărăt dăm sufljičilje alor, să nu potă ănkradă să nu să spasalaskă. ");
INSERT INTO ronBayash_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Aje sămănca ăntri petri ăs la ominj kari auđi Vorba šă u apukă ku fălušăjă ali nari korjen. Jej ănkređi nu dă lungat šă atunšje ăm vreme dă ănšjirkală jej kađi ăndărăt. ");
INSERT INTO ronBayash_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Sămănca kari u kăzut ăntri măršunj šă ka ominji kari auđi Vorba, ali kum vreme fužji jej să astrănži ku brigurlje ăm kust, šă dă găzdăšije, šă žăndur ăm kust, šă eje nu adušji bun plod. ");
INSERT INTO ronBayash_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ali sămănca kari kađi pă bună pămănt aje eje ominj kari auđi Vorba šă u cănji ăm sufljitu bun, jej ăs ustrajni šă u adušji bun plod.” ");
INSERT INTO ronBayash_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Njime nu acăcă lampă să u pujă dăsup ter ili dăsup pat. Nu, jăl u punji pă svijećnjak aša toc u viđe lumină kănd vinji ăm nontru ");
INSERT INTO ronBayash_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","atunšje kutotu šje ăj aku askuns, šă šje ăj pă askuns făkut, kutotu u jăšă afară. ");
INSERT INTO ronBayash_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Daje păzec kum auzăc. Kă šinji ari ju fi dat maj mult, šă šinji gođe nari njimika, dă la jăl u fi lot čak šă aje cară šje samănă kă ari.” ");
INSERT INTO ronBayash_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Alu Isus u vinjit mumăsa šă fraci să ăl posjetilaskă pă Isus ali jej nu puće să vijă apropi dă jăl dă rănd dă gărmadă. ");
INSERT INTO ronBayash_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Šinjiva u javalit alu Isus: “Mumăta ata šă fraci atej stă afară či aščaptă.” ");
INSERT INTO ronBayash_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Isus lju u zăs: “Mama ame šă fraci amej ăs eje kari auđi Vorba alu Dimizov, šă u kustă.” ");
INSERT INTO ronBayash_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Una ză Isus šă učenici aluj ur tunat ăm čamac šă să mergă pă alta parći dă galilejsko jezero. Isus u zăs: “Hajd pă haje parči!” Aša sur maknulit dă la mal. ");
INSERT INTO ronBayash_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ali kum plovule jej, pă Isus lu furat somnu. Atunšje oluja ku văntu una su slăbuzăt pă jezero šă jej asre ăm opasnost, daje ka karu să umplje ku apă. ");
INSERT INTO ronBayash_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Jej ur mers la Isus šă lor skulatulă ăm frikă šă mužje: “Domnu, Domnu, noj nji ăntupenj!” Aša su skulat šă u zapovjedalit alu văntu šă alu valuvurljelje să să putuljaskă. Oluja su putuljit šă are putuljală. ");
INSERT INTO ronBayash_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","“Hunđi vi ănkriđala?”, Isus lju ăntribat pă jej. Ali jej asre pljinj dă frikă šă ămirală, šă u zăs una la alt: “Šinji ăj asta čak šă văntu šă valuvurlje ăl punji ureći pă jăl kănd zapovijedalešći?” ");
INSERT INTO ronBayash_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jej ur plovulit păn la malu dă Gerasa, kari ăj pă alta parći dă Galileja. ");
INSERT INTO ronBayash_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Kum Isus u pus pišjorilje pă pămănt, ju vinjit dădănenči om dăm varuš kari are mar da multă dobă ku drašj ăm jăl. Jăl nu purta colji, šă nu kusta ăm kasă mar ăm gropur. ");
INSERT INTO ronBayash_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Kănd lu văzutulă pă Isus, jăl u mužjit tari šă u kăzut dădănenći la jăl šă dăm tot graju u mužjit: “Šje gănđešč dă la minji, Isuse Fišjoru alu Dimizov, Maj Mari? Ju mă arog la činji să nu mă mučulešć!” ");
INSERT INTO ronBayash_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Draku ăl cănje mar multă vremi. Majnti ominji ku lancurlje ăl ljiga šă ăl păze, ali jăl tod daje rupe lancurlje šă draku lu mănat ăm pustinjă. Isus u dat zapovjed alu rov duhu să ješi afară dăm jăl. ");
INSERT INTO ronBayash_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Isus lu ăntribat: “Kum či čem?” Jăl u zăs: “Legija”, daje kă mulc drašj asre ăm jăl. ");
INSERT INTO ronBayash_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Šă jej sur arugat la Isus să nu lji đe zapovjed să mergă ăm gropă făr dă dno. ");
INSERT INTO ronBayash_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Akulo are mari stadă dă poršj šje mănka pă parće dă đal, šă jej sur arugat să dozvolulaskă să tunji ăm jej, šă Isus lju dazvolulit. ");
INSERT INTO ronBayash_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Drašji dăm omula u fužjit ăm gărmadă poršj, šă stada dă poršj ur arljigată dă pă đal ăm jezero šă akulo sur ăntupit. ");
INSERT INTO ronBayash_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ominji šje păze stado u skăpat kănd u văzut aje, šă jej ur dus hir ăm varuš šă ăm sat. ");
INSERT INTO ronBayash_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Šă lume ur vinjit să vadă šje u fost aje. Kănd ur vinjit la Isus, jej ur aflat pă omu šje are ku drašj ăm jăl are ămbrăkăt, šă šăđe la pišjorilje alu Isus ku fire săntosă. Šă kănd u văzut aje kutotu jej sur ănfrikušat. ");
INSERT INTO ronBayash_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Hej kari ur văzut or spus kum Isus u oslobodulešči pă omu ku drašj. ");
INSERT INTO ronBayash_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ali tota lume dăm lok ăm Gerasa ur zăs alu Isus să fugă dăm akulo kă asre tari ănfrikušac. Isus u tunat ăm kar šă gănđe să fugă ăm napoj. ");
INSERT INTO ronBayash_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Omu dăm kari Isus u mănat afară dăm drašj să aruga la Isus: “Pot să fug ku činji?”, ali Isus lu mănat šă ju zăs: ");
INSERT INTO ronBayash_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Dući ăm napoj akasă, šă spunji alu toc kutotu šje Dimizov u făkut dă činji.” Aša u mers akasă šă u širilit ăm varuš kutotu šje Isus u făkut păntru jăl. ");
INSERT INTO ronBayash_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Gărmadă are akulo să ăl pozdravalaskă pă Isus kănd su ăntorsusă pă alta parči dă jezero, jej toc tari ăl aščipta pă jăl. ");
INSERT INTO ronBayash_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Atunšje su pojavalit om kari să čima Jair vođa dă sinagogă. Jăl u vinjit la Isus šă u kăzut žos la pišjorilje aluj šă să aruga la jăl să vijă la jăl akasă daje kă ");
INSERT INTO ronBayash_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","jedina fata aluj dă dvanaest aj (12) dă bătărnă are pă morči. Isus u mers dă pă Jair kănd mulc să ămpinžje să fijă dapropi dă jăl. ");
INSERT INTO ronBayash_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ăm gărmade are mujeri kari kărvarale dvanaest (12) aj šă je u čiltit kutotu šje ave pă doktur ali no aflat pă njime kari ar puće să u ozdravalaskă. ");
INSERT INTO ronBayash_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Je u vinjit pă dănapoj šă su apukat pus dă cola alu Isus, šă sănžilje u stat să kuri. ");
INSERT INTO ronBayash_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","“Šinji u pus măna pă minji?”, u ăntribat Isus. Toc zăšje kă nu ur pus. Atunšje Petar u zăs: “Domnu, tu vejs kum să ămpinži toc ominji la činji!” ");
INSERT INTO ronBayash_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Isus u zăs: “Šinjiva u pus namjerno măna pă minji kă am sămcăt pučere kum jašă afară dăm minji.” ");
INSERT INTO ronBayash_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Kănd u văzut mujere kă majmult nu poći cănje ăm je, je u vinjit ăm nenći trămurănt dă frikă, u kăzut ăm njenće alu Isus šă u spus la toc adăšje u pus măna pă jăl, šă kum u fost ozdravalită dăm turdată. ");
INSERT INTO ronBayash_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Isus u zăs: “Fato, ănkriđala ata ću ozdravalit. Dući ăm putuljală!” ");
INSERT INTO ronBayash_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Kănd Isus svite ku mujere, glasniku dăm kasa alu vladaru dă sinagogă u vinjit šă u zăs: “Fata ata ăj mortă. Nu ăl gnjavali pă učitelj!” ");
INSERT INTO ronBayash_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Kănd u auzăt Isus aje, jăl u zăs alu Jair: “Nuc fijă frikă! Numa ănkređi mijă šă je u kusta!” ");
INSERT INTO ronBayash_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Kănd ur vinjit jej la kasa, Isus nu lăsă să mergă ăm nontru ku jăl osim Petar, Ivan, Jakov šă mumăsa šă tatusu alu fate haje. ");
INSERT INTO ronBayash_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Šă toc ăm kasa plănžje šă u žalale, aša jăl u zăs: “Nu plănžjec. Je nuj mortă, numa să kulkat!” ");
INSERT INTO ronBayash_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Jej ăl răđe pă Isus, kă jej asre sigurni kă je ăj mortă. ");
INSERT INTO ronBayash_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Isus atunšje u apukatu dă măna šă dăm tot graju u mužjit: “Skolăći kupilu amnjov!” ");
INSERT INTO ronBayash_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Šă duhu alji su ăntorsăsă šă je su skulat dăm turdată. Isus u dat zapovjed atunšje să ăj đe šjeva să mănăšji. ");
INSERT INTO ronBayash_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Roditelji alji asre ămirac a Isus lju purunšjit pă roditelji să nu spujă alu njime šje u fost. ");
INSERT INTO ronBayash_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Isus u čimat pă dvanaest apostolur la jăl šă jăl lju dat pučeri šă autoritet pă toc drašj, šă pučeri să ăntremi bičišugur. ");
INSERT INTO ronBayash_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Atunšje Isus lju mănat afară šă să proglasalaskă kraljevstva alu Dimizov šă să ozdravalaskă pă bičež. ");
INSERT INTO ronBayash_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Isus lju zăs alor: “Nu loc njimika ku voj pă kalje avostră, njiš botă, njiš taškă, njiš mănkari, njiš banj. Njime să nu je maj una kămašă ku jăl. ");
INSERT INTO ronBayash_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ăm kari gođe kasa măržjec, fijec akulo păn šje nu fužjec dăm varuš. ");
INSERT INTO ronBayash_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Hunđi gođe nu vă punji ureči, fužjec dăm ala varuš šă ăm znak dă upozorenje kă ăl laš la sudbina aluj, skutărăcăvă prašina dă pă pišjori.” ");
INSERT INTO ronBayash_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Aša jej sur lot afară să mergă dăm sat ăm sat să propovjedalaskă Hir fălos šă ozdravalaskă pă bičež pă hunđi gođ meržji. ");
INSERT INTO ronBayash_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Vladar Herod u auzăt dă kutotu šje Isus u făkut, šă are zăbunjit kă orikic zăšje kă Ivan Krstitelj u uskrnulit dăm morc. ");
INSERT INTO ronBayash_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Šă orikic zăšje kă prorok Ilija su arătat pă pămănt kănd alci gănđe kă unu prorok dă kănva u vinjit ăm kust. ");
INSERT INTO ronBayash_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ali Herod u zăs: “Ju am tijet kapu alu Ivan, ali šinji ăj omusta dă kari aud dăstafele vorbi?” Jăl da be šćipta să vadă pă Isus. ");
INSERT INTO ronBayash_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Kănd sor ăntors apostoli ur spus alu Isus kutotu šje ur făkut. Atunšje Isus lju dus pă lok pustulot apropi dă varuš Betsaida. ");
INSERT INTO ronBayash_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Lume ur saznalit šă ur sljedilit pă Isus. Aša lju apukat la jăl šă lju spus dă kraljevstva alu Dimizov šă u ozdravalit pă eje kari asre bičež. ");
INSERT INTO ronBayash_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Mar kitră dă sara Dvanaest apostolur ur vinjit la Isus šă ur zăs: “Mănă pă lumi ăndărăt, aša să mergă să ăš aflji lok dă kulkat šă dă mănkat kă noj šćenj ăm pustinjă ajišje.” ");
INSERT INTO ronBayash_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Isus lju zăs: “Voj dăđecălji šjeva dă mănkat.” Jej ur ăntors vorba: “Noj avenj čar pet darabur dă pită šă doj pešć. Noj săngur să mărženj šă să kumpărănj mănkari dă totă lumesta?” ");
INSERT INTO ronBayash_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Jej ur umărat hunđiva pet hiljada dă bărbec, Isus u zăs alu učenici aluj: “Punjecălji să šadă ăm grupur po pedeset lumi să šadă una.” ");
INSERT INTO ronBayash_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Šă apostoli ur făkut kum lju zăs, lju pus pă toc să šadă žjos. ");
INSERT INTO ronBayash_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Atunšje Isus u lot pet dărabur dă pită šă doj dărabur dă pešć šă su ujtat sus ăm nor, Isus u blagoslovulit šă u ruptă ăm dărăbelji, atunšje u dat alu učenici aluj să pujă dădănenći alu lumi. ");
INSERT INTO ronBayash_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Šă jej toc ur mănkat šă asre sătulj. Šă jej ur akuljes dvanaest košarur dă dărăbelji šje ur rămas. ");
INSERT INTO ronBayash_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Undată kănd su ăntors Isus pum parći să să aroži, učenici asre ku jăl šă Isus u ăntribat: “Šje zăšji lume šinji mes ju?” ");
INSERT INTO ronBayash_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Jej ur ăntors vorba: “Ivan šje Bučază, makar orikic zăšji Ilija prorok a hejelanc kă ješć prorok dă kănva kari u uskrsnulit dăm morc.” ");
INSERT INTO ronBayash_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Isus u ăntribat: “A voj? Šje zăšjec voj, šinji mes ju?” Petar u ăntors vorba: “Tu ješć Krist kari ăj mănat dă la Dimizov!” ");
INSERT INTO ronBayash_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Isus u dat atunšje zapovjed mari, šje lji branale să spujă asta alu šjinjiva kă jăl ăj Mesija. ");
INSERT INTO ronBayash_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Atunšje Isus u zăs: “Ju, Fišjoru alu Omuluj trăbă să păc mulći patnjur. Bătărnji kari ăs glavni ăntri židovur, mari popur šă učitelju dă zakonu alu Mojsije mu odbacali. Jej mur amură, a ju treći zuă uj uskrsnuli.” ");
INSERT INTO ronBayash_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Atunšje Isus u zăs alu toc: “Dakă šinjiva gănđešći să mă sljedălaskă pă minji, elši trăbă să odbijalaskă să kušči dă pă žăndurlje aluj, jăl săngur să ăš je krušje aluj totă zua šă să mă sljedălaskă pă minji. ");
INSERT INTO ronBayash_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Šinji gođ gănđešći să ăš spasalaskă kustuš ala lu perđi do kraja, šă šinji gođe šu perđi kustuš păntru minji ala su spasalisă vječno. ");
INSERT INTO ronBayash_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Šje ari benji om dăm aje dakă kapătă celi svet, a jăl ăj uništilit ili părdut? ");
INSERT INTO ronBayash_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Dakă ăj alu šjinjiva rušunji dă minji ili dă vorbilje amelji, šă ju Fišjoru alu Omuluj ju fi rušănji dă ala om, kănd uj vinji ăm slava aluj, ăm slava alu tatusu šă ăm slava alu svănc anđeji. ");
INSERT INTO ronBayash_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Anume ju zăk, ăs orikic kari stă ajišje kari nor muri majnti dă šje nor viđe kraljevstva alu Dimizov.” ");
INSERT INTO ronBayash_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Hunđiva osam zălji dă pă ešće svatur Isus u lot pă Petar, Ivan šă pă Jakov ku jăl, šă u mers sus pă đal să să aroži. ");
INSERT INTO ronBayash_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Atunšje kum să aruga, ubrazu aluj u ščimbat tari, šă coljilje aluj sur ščimbat am alb dă svitlăze. ");
INSERT INTO ronBayash_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Doj ominj su pojavalit, svite ku Isus. Eje asre Mojsije šă prorok Ilija. ");
INSERT INTO ronBayash_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Jej su arătat ăm slavă šă jej svite dă morči aluj šje u fi ăm Jeruzalem. ");
INSERT INTO ronBayash_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pă Petar šă pă urtašji aluj lju furat somnu ali jej sur skulat šă lor văzut pă Isus ăm slava aluj ku doj ominj šje stăće ku Isus. ");
INSERT INTO ronBayash_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kănd jej fužje, Petar u zăs alu Isus: “Domnu, anovă nji benji ajiše! Lasă făšjenj tri koljibur: unu păntru činji, šă unu păntru Mojsije šă unu păntru prorok Ilija.” Jăl nu šćije šje svitešći, sămăna kă bulunzešči. ");
INSERT INTO ronBayash_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Šă kănd Petar svite, oblak u vinjit dasupra pă Petar šă pă urtašji aluj šă jej su ănfrikušat. ");
INSERT INTO ronBayash_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Atunšje su ăuzăt graj dăm oblak: “Asta ăj Fišjoru amnjov, ju lam izabralit! Punjec ureći la jăl!” ");
INSERT INTO ronBayash_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Kănd graju su auzăt, Isus are săngur. Učenici ur tăkut šă nor spus alu njime šje ur văzut. ");
INSERT INTO ronBayash_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Hajelantă ză Isus šă učenici aluj ur vinjit žjos dă pă đal šă ăl ašćipta gărmadă dă lumi. ");
INSERT INTO ronBayash_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ăm gărmade are om kari mužje: “Učitelju, ju mă arog, ujtăći pă fišjorum daje kă jăl ăj jedini kupilu amnjov! ");
INSERT INTO ronBayash_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ujtăći, duh ăl napadalešći šă jăl dăm turdată căpă, ăl skutără ăm gărčur šă fašji spumi la gură šă dabe fužji dă la jăl, ku mukă ăm ăl baći. ");
INSERT INTO ronBayash_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ju mam arugat la učenici atej kari as re ku noj dakă ar puće jej să măjă pă draku afară ali jej nu puće.” ");
INSERT INTO ronBayash_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Isus u ăntors vorba: “O voj nevjernă šă ubraznikă generacijă! Kită dobă trăbă să fjuv ku voj? Kită dobă trăbă să vă trpălesk? Adăl pă fišjoruc ajišje!” ");
INSERT INTO ronBayash_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kănd kupilula u vinjit la Isus, draku lu vărljit žjos šă ăl skutura am gărčur. Isus lu mužjit pă duhu rov šă pă kupilu lu ozdravalit, šă ăm napoj lu dat la tatusu. ");
INSERT INTO ronBayash_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Jej asre toc ămirac la autoritetu aluj šă kit ăj dă mari Dimizov. Atunšje kănd inka toc să ămira šje u făkut, Isus u svătit ku učenici aluj: ");
INSERT INTO ronBayash_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Zapamtalecă vorbilješće, šă ăngănđecăvă dă jelji.” Isus u zăs: “Ju, Fišjoru alu Omuluj uj fi dat ăm mănjilje alu omuluj.” ");
INSERT INTO ronBayash_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Jej nor prišjiput šje u gănđit jăl ku aje să zăkă. Značenje are askunsă dă la jej, a alor lji are frikă să ăl ăntrebi pă jăl dă aje. ");
INSERT INTO ronBayash_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Učenici su apukat să raspravljalaskă šinji dăm jej ar puće să fijă maj mari. ");
INSERT INTO ronBayash_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Isus lji šćije găndu ăm sufljičilje alor atunšje Isus u lot pă kupil mik šă lu pus lăngă jăl ");
INSERT INTO ronBayash_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","atunšje lju zăs: “Šinji gođe apukă pă kupilusta mik ăm numilje amnjov apukă pă minji. Šă šinji gođe apukă pă minji, apukă isto šă pă ala kari mu mănat. Daje kă maj mik ăntri voj ăj maj mari.” ");
INSERT INTO ronBayash_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ivan u zăs: “Domnu noj anj văzut pă unu om kari ăm numilje atov mănă drašj afară dăm ominj šă noj anj zăs să nu fakă aje, daje kă jăl nu ăj unu dăm noj.” ");
INSERT INTO ronBayash_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Isus u zăs aluj: “Nu ăj branalec, kă šinji gođe nuj protiv dă voj, ăj dă voj.” ");
INSERT INTO ronBayash_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Vreme are apropi kănd Isus trăbuje să fijă dus napoj ăm nor, atunšje tari su odlučulit să mergă ăm Jeruzalem. ");
INSERT INTO ronBayash_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Isus u mănat glasnišj ăm nenći la jăl a jej ur vinjit ăm unu sat ăm Samarija să pripremalaskă lok păntru jăl. ");
INSERT INTO ronBayash_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ali lume akulo nu lu apukat ăm benji, daje kă are pă kalje dă Jeruzalem. ");
INSERT INTO ronBayash_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kănd ur văzut učenici Jakov šă Ivan ur ăntribat: “Domnu, gănđešć să čimănj fok dăm nor să lji uništălaskă?” ");
INSERT INTO ronBayash_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Isus su ăntors la jej šă lju făkut dă njimika pă Jakov šă pă Ivan. ");
INSERT INTO ronBayash_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Šă jej ur mers ăm altu sat. ");
INSERT INTO ronBayash_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Kum măržje Isus šă učenici pă kalji, šjeva ka omu u zăs alu Isus: “Ju uj meržji ku činji hunđi gođ vi meržji šă tu!” ");
INSERT INTO ronBayash_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Isus u zăs: “Lisicurlje ari sklonište šă vrăbujilje ari gnjezdurlje alor, ali Ju Fišjoru alu Omuluj nam lok hunđi să ăm pujă kapu.” ");
INSERT INTO ronBayash_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Isus alu altuje u zăs: “Sljedilešći mă!” Omu u zăs: “Domnje, lasămă elši să mă dukă să ăngrop pă tata amnjov.” ");
INSERT INTO ronBayash_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Isus u zăs aluj: “Lasă pă morc să ăš ăngropi pă morc, ali tu dući šă propovjedalešći kraljevstva alu Dimizov!” ");
INSERT INTO ronBayash_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Akulo are inka unu om kari zăšje: “Ju čuj sljedili pă činji, Domnu ali elši lasămă să mă pozdravalesk ku toc akasă.” ");
INSERT INTO ronBayash_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Šă Isus ju ăntors vorba: “Njime kari punji măna pă plug šă să ujtă ăm napoj dă pă jăl, nuj bun dă kraljevstva alu Dimizov.” ");
INSERT INTO ronBayash_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Dă pă ešće stvarur Domnu u odredilit sedamdeset doj učenikur šă lju mănat ăm nenći, doj pă doj la tot varušu šă lok la kari jăl isto aščipta să mergă. ");
INSERT INTO ronBayash_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Isus u zăs alor: “Žetva ăj mari ali pucănj ăs lukroj, dăm ala rănd arogăči la stăpănu dă žetva să măji maj mulc lukroj ăm polja aluj. ");
INSERT INTO ronBayash_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Aku dući ali punji ureći. Ju vă măj pă voj ka pă birkă mikă ăntri lup! ");
INSERT INTO ronBayash_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nu loc ku voj đibularuš ili taškă ili cipiliš, šă nu sta dă lungat ăm svat ku ominji pă kalji să nu zgubec vreme. ");
INSERT INTO ronBayash_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Elši stvar šje trăbă să zăšjec kănd vinjec la kasa ăj: ‘Putuljală fijă la kasasta!’ ");
INSERT INTO ronBayash_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Dakă om kari gănđešči putuljală kustă ăm kase putuljala u fi ku jăl, ali dakă nu, putuljala u vinji ăm napoj la voj. ");
INSERT INTO ronBayash_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Rămănji ăm aje ista kasa, mănănkă šă be šje ari jej, kă lukroju ăj vredan dă šje u lukrat. Nu vă selilec dăm una kasa ăm alta. ");
INSERT INTO ronBayash_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Dakă măržjec ăm bilo kari varuš šă jej vă apukă ăm benji voj mănkăc šje vă punji dădănenći ");
INSERT INTO ronBayash_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","šă ozdravalecă pă bičež kari ar fi akulo, šă spunjecălji kă Kraljevstva alu Dimizov ăj apropi. ");
INSERT INTO ronBayash_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ali dăkă vinjec ăm varuš hunđi nu vă apukă, atunšje dušjecăvă pă ulicur šă zăšjec: ");
INSERT INTO ronBayash_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Čak šă prašina dăm varušu avostru kari su apukat pă pišjorilje anoštri, brisălec dă pă noj, protiv dă voj! Ali šă voj ac trăbuji să šćijec kă kraljevstva alu Dimizov ăj apropi. ");
INSERT INTO ronBayash_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ju vă zăk kă pă zuve dă sudulală u fi maj ušuri lu varušu Sodoma dă kită dă varušula.” ");
INSERT INTO ronBayash_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Isus u zăs: “Jao avovă ominjilor dăm Korazine! Jao avovă ominjilor dăm Betsaido! Kă să vi fost dastafel čudo ăm varuš Tira šă am Sidon ka kum su dogodulit la voj ăm varušu avostru, jej dă kănva sar vi ănkăjit, šăzut ăm colji dă kecă, šă ăm šjinušă znak dă ănkăjală. ");
INSERT INTO ronBayash_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Anume ăm zuve dă sudulală Tira šă Sidonija maj benji ur trešji dă tu! ");
INSERT INTO ronBayash_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Šă voj ominji dăm Kafarnaum! Pănăm nor voj vic răđika? Ăm podzemlje vic fi arunkac. ");
INSERT INTO ronBayash_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Šinji gođe auđi pă voj, mă auđi pă minji, a šjinji odbacalešči pă voj, pă minji odbacalešči, šă šjinji gođe odbacalešči pă minji, odbacalešči pă Dimizov kari mu mănat!” ");
INSERT INTO ronBayash_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Sedamdeset doj učenikur su ăntors ku fălušăjă. Jej ur zăs: “O Domnje, čak šă drašji nji punji ureći ăm numilje atov.” ");
INSERT INTO ronBayash_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jăl lju zăs alor: “Ju mă ujtam la Sotona kum kađi ka munje dăm nor. ");
INSERT INTO ronBayash_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Aku punjec ureći! Ju vam dat autoritet să kălkăc pă šarpi šă pă škorpionur šă ku kutotu pučere pă săla dă dužmanj, šă njimik nu vic păcă rov. ");
INSERT INTO ronBayash_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Tot daje nac trăbuji să vă ănfălušăc kă duhovur vă punji ureći. Fijec făloš la aje kă numilje avoštri ăs skrišă ăm nor.” ");
INSERT INTO ronBayash_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ăm ala šas Isus su ănfălušăt ăm Duhu svănt šă u zăs: “Tata, Domnu pă pămănt šă pă nor, ju dov hvală cijă daje kă tu aj askuns ešće dă la mărđoj šă dă la păršjipuc, šă aj arătat alu hej ‘mišj’ pă pămănt. Da, Tata, cijă asta că să veđi.” ");
INSERT INTO ronBayash_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Šă Isus u zăs: “Kutotu mu fost dat ăm povjerenje dă la Tata amnjov. Njime nu kunošći pă Fišjoru šă njime nu kunošći pă Tata, numa Fišjoru kunošći, šă alu heje kari Fišjoru gănđešći u kunošći pă Tata.” ");
INSERT INTO ronBayash_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Atunšje kănd are jej săngur, Isus su ăntors la učenici aluj šă u zăs: “Blago avovă kă oči avoštri asta veđi! ");
INSERT INTO ronBayash_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Sigurno mulc proroš šă kraljur dă kănva gănđe să vadă stvarurlje kari voj viđec, ali jej no putut să vadă, šă să audă šje voj ac auzăt, ali nor auzăt.” ");
INSERT INTO ronBayash_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Šjeva ka učitelju dă zakonu alu Mojsije su skulat, să ăl iskušulaskă pă Isus šă lu ăntribat: “Učitelju šje trăbă să fakă să kapăt kust dă erikeš? Kum ăl pot kăpăta?” ");
INSERT INTO ronBayash_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","“Šje zăšji zakonu alu Mojsije? Kum prišjep aje?” ");
INSERT INTO ronBayash_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","U ăntors vorba: “Plaši pă Domnu Dimizovu ku tot sufljitu atov, ku duša ata, ku pučere, šă ku kutotu găndu atov, pă susjedu atov kă pă činji săngur!” ");
INSERT INTO ronBayash_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Isus u zăs aluj: “Benji aj zăs, aša fă šă vi kusta.” ");
INSERT INTO ronBayash_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ali kum gănđe să areči kă ăj pravedan, lu ăntribat pă Isus: “Ali šinji ăj susjedu amnjov?” ");
INSERT INTO ronBayash_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Isus u zăs: “Are om kari are pă kalji dă Jeruzalem, are sus ăm varuš Jerihon kari are žjos u fost pljačkalit šă lăpădat, bătut pă morči dă la pljačkaš šă lăsat pă drik. ");
INSERT INTO ronBayash_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Popa dă židov slučajno măržje pă kalje šă kănd lu văzut, u fužjit pă lăngă jăl numa pă alta parći. ");
INSERT INTO ronBayash_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Isto aša Levit, pomočniku alu popa u vinjit isto pă kalje haje. Kănd u vinjit pă lokula šă lu văzut, isto u mers pă alta parći dă kalji. ");
INSERT INTO ronBayash_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Napokon Samaritanac kum măržje pă kalji u vinjit pă lăngă jăl šă kănd lu văzut lu apukat mila dă jăl. ");
INSERT INTO ronBayash_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Jăl u mers la jăl u vărsat uloj šă vin, šă ju ănvălit ranurlje. Atunšje lu pus pă magar šă lu dus ăm fugadov aša su brinulit dă jăl. ");
INSERT INTO ronBayash_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Odma hajelantă điminjacă kum fužje ju dat lu gazda dă kasa šjeva ka banji šă u zăs: ‘Je sama dă jăl, šă dakă asta nu u fi dăstul banj, dă kutotu šje u čilti, ju cuj plăći razlika kănd mă ăntorkă ăm napoj.’ ");
INSERT INTO ronBayash_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Dă pă ganđala ata šje gănđešć kari dăm ešće tri su arătat ka susjedu alu omusta kari u fost pljačkalit šjinji maj benji u ažutat?” ");
INSERT INTO ronBayash_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Jăl u ăntors vorba: “Ala pă kari lu apukat mila dă jăl.” Atunšje Isus ju zăs aluj: “Dući šă fă šă tu isto ka jăl.” ");
INSERT INTO ronBayash_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Kum ur mers maj menkulo, Isus u vinjit ăm unu sat hunđi are mujeri šje să čima Marta kari lu apukat pă jăl ăm kasa alji. ");
INSERT INTO ronBayash_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta ave soră šje să čima Marija kari u šăzut la pišjorilje alu Domnu šă punje ureći la kutotu šje jăl svite. ");
INSERT INTO ronBayash_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ali Marta are ăm brigur dă kutotu šje trăbă să fakă. Aša u vinjit la Isus šă ju zăs: “Nu či dori Domnu, kă sora ame mu lăsat pă minji săngur kutotu să poslužulesk? Šjeva zăj să vijă să ăm ažući.” ");
INSERT INTO ronBayash_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Domnu ju zăs: “Marta, Marta, tu či brinulešč šă či uznemirilešč dă mulći stvarur. ");
INSERT INTO ronBayash_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","U biti numa una stvar trăbujă, šă Marija maj benji u akuljes, šă aje no fi lotă dă la je.” ");
INSERT INTO ronBayash_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Undată kănd Isus u fost gata ku molitva, unu dăm učenici aluj u vinjit la jăl šă ju zăs: “Domnu, ănvacănji să nji arugănj, kum ănvăca Ivan Krstitelj pă učenici aluj.” ");
INSERT INTO ronBayash_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Isus lju zăs alor: “Kănd vă arugăc zăšjec: ‘Tata, la să fijă svănt numilje atov, la să vijă kraljevstva ata, ka kum ăj pă nor la să fijă pă pămănt! ");
INSERT INTO ronBayash_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Pita anostră kari ăj ăm totă ză, dă nji astăs. ");
INSERT INTO ronBayash_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Šă jartănji grehurlje anoštri, ka kum noj jartănj alu eje kari grešilešći protiv dă noj. Nu nji da să kăđenj ăm ănšjirkalur.’” ");
INSERT INTO ronBayash_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Isus u zăs alor: “Haj să zăšjenj kă avec urtak la kari măržjec ăm miržuku dă nopći šă ăj zăšjec: ‘Urtaku amnjov, dăm kečinj tri dărabur dă pită. ");
INSERT INTO ronBayash_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Urtaku u vinjit dă pă kalji la minji, šă nam šje să ăj puj dădănenći.’ ");
INSERT INTO ronBayash_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","A jăl ăm nontru aj zăšji: ‘O nu mă gnjavali! Uša ăj mar ănkujetă, kupiji amej šă ju ăščenj ăm pat, šă jednostavno, nu mă pot skula să ac dov pită.’ ");
INSERT INTO ronBayash_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ju vă zăk: šă dakă nu u meržji daje kă ăs urtašj, u fašji aje să nu să rušunji. ");
INSERT INTO ronBayash_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Šă ju vă zăk: Arugăcăvă, šă vu fi dat! Kutăc, šă vic afla! Kukunjec, šă vu fi dăsvkut. ");
INSERT INTO ronBayash_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kă šjinji gođ să arogă, kapătă! Kari kotă, află! A šjinji gođ kukunješći aluje ju su dăsvašji. ");
INSERT INTO ronBayash_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Kari ăj tata ăntri voj: kănd kupilu šjeri pešći dali ăm lok dă pešći dă šarpi? ");
INSERT INTO ronBayash_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ili kănd šjeri să ăj đe škorpion ăm lok dă ov? ");
INSERT INTO ronBayash_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Dakă voj grešni ominj šćijec să dăđec bunji stvarur alu kupiji avoštri, kit maj mult vu da Tata avostru dăm nor Duh Svănt alu alor kari ăl ăntrabă!” ");
INSERT INTO ronBayash_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Isus undată u vărljit afară pă unu drak kari are mut, šă kănd u fost drakula vărljit afară dăm ala om kari are mut, puće să svitaskă, šă alčilje ominji kari u văzut aje asre ămirac. ");
INSERT INTO ronBayash_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","A orikic dăm jej u zăs: “Jăl u vărljit afară pă drašj afară ku ažutala alu Beelzebul princu dă demonur!” ");
INSERT INTO ronBayash_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Akulo asre alci kari ănšjirka pă Isus, šă jej u šjirut znak dăm nor să đe. ");
INSERT INTO ronBayash_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ali Isus šćije găndurlje alor, šă lju zăs: “Totă kraljevstva kari să borulešči una ku alt, jej ur uništili kraljevstva alor. Dakă familija una ku alt să borulešči, jej šur uništili familija alor. ");
INSERT INTO ronBayash_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Dakă Sotona să borulešči protiv dă jăl săngur, kum kraljevstvo aluj su cănje?, šje rămănje dăm kraljestva aluj? Kum voj zăšjec kă ju vărljesk afară pă drašji dăm lume ku ažutala alu Beelzebul. ");
INSERT INTO ronBayash_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ali dakă ju vărljesk pă drašji afară dăm lumi ku ažutala alu Beelzebul, atunšje učenici avoštri vărlješći isto afară pă drašj ku ažutală alu Beelzebul? Jej săngur u dokazali kă nus točni. ");
INSERT INTO ronBayash_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ali dakă ju măj pă drašji afără ku žejtu alu Dimizov, atunšje u vinjit kraljevstva alu Dimizov la voj. ");
INSERT INTO ronBayash_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Kănd om bălour ăj naoružan šă păzešći kasa hunđi kustă, atunšje pămăntu aluj ăj sigurnă. ");
INSERT INTO ronBayash_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ali kănd bălour om ăl napadalešći šă ăl mănănkă ku bătaje, ăj je oružje dă kari ovisilešći, šă ăj ămparcă šje u furat dă la slab om. ");
INSERT INTO ronBayash_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Kari nu ăj ku minji, ala ăj protiv dă minji šă šjinji gođe nu akulježi ku minji, ala răsăpă. ");
INSERT INTO ronBayash_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Pă lok făr dă apă rov duhu fužji afară dăm om, să lutulaskă šă să koći lok să să odmaralskă. Dakă nu află njiš šjefălj lok, zăšji: ‘Ju uj meržji ăm napoj ăm kasa ame dăm ala om hunđi am fužjit.’ ");
INSERT INTO ronBayash_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Kănd draku u vinjit ăm napoj u aflat kă aje kasa ăj čistilită, šă măturată. ");
INSERT INTO ronBayash_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Atunšje meržji šă adušji maj šapči rov duhur maj rej dă jăl săngur, šă jej u vinji napoj ăm om šă kustă akulo. Aša alu omula are tari urăt dă kit dăm elši.” ");
INSERT INTO ronBayash_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Kum Isus svite, mujeri ăm gărmadă dă ominj u mužjit tari dăm tot graju šă su apukat să svitaskă: “Blagoslovulită ăj aje kari ću purtat ăm injimă, kari ću rănjit šă ću păzăt!” ");
INSERT INTO ronBayash_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Isus u ăntors vorba: “Anume, ali maj blagoslovulit ăs eje kari auđi vorba alu Dimizov šă u cănji!” ");
INSERT INTO ronBayash_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Kănd u vinjit tari mulc ominj akulo, Isus su apukat să svitaskă: “Voj ominj kari kustăc ăm asta vremi, voj ščec rej ominj. Kotă znak, ali njišj šjefălj altu znak no fi dat ka kum u făkut Dimizov čudo păntru prorok Jona. ");
INSERT INTO ronBayash_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Šje su dogodulit alu Jona aje are znak alu Ninivljanur kari kusta ăm varuš Niniva, kă Dimizov lu mănat. Aša šje mu su dogoduli, ju uj fi znak kă pă minji, Fišjoru alu Om kari Dimizov u mănat alu asta narod. ");
INSERT INTO ronBayash_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Pă zuva kănd Dimizov u suduli, kraljica kari dă kănva vladale pă pămănt dă jug ăm Seba, su răđika una šă je u suduli pă heje kari kustă astăs. Je u vinjit dă pă kraju dă svijet, să slušulaskă pă Car Salomon kari are tari mudar. A aišje ăj šjinjiva maj mari dă Salomon a voj nu gănđec să punjec ureči! ");
INSERT INTO ronBayash_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ăm zua kănd Dimizov u suduli, ominji kari kusta ăm varuš Niniva su răđika šă ljur suduli ominji kari aku kustă, kă jej nu sur ănkăjit kănd Jona lji propovijedale. A ajišje ăj šjinjiva maj mari dă kit Jona a voj nu vac pokajalit!” ");
INSERT INTO ronBayash_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Isus svitešči: “Njime nu acăcă lampă šă atunšje u punji pă lok hunđi nu să veđi ili dăsup košară. Nu, jăl u punji ăm svijećnjak aša toc u viđe lumină kănd vinji ăm nontru. ");
INSERT INTO ronBayash_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Oču ăj ka lampa alu telă. Dakă oču atov ăj sănătos, atunšje tela ata ăntragă u fi ăm lumină, ali kănd ci oču bičag, tela ata ăntragă ăj ăm ăntunjerik. ");
INSERT INTO ronBayash_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Bagă sama da aje šje smatralešč kă ăj lumina ăm činji să nu fijă făr dă lumină.” ");
INSERT INTO ronBayash_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Dakă ăj ăntragă tela ata ăm lumină, njiš unu dio dă telă nu ăj ăm ăntunjerik, atunšje ăj kutotu ăm lumină, ka kum čar svitlăze lumina ata. ");
INSERT INTO ronBayash_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Kănd Isus u svătit, unu farizej lu čimat să mănănšji la jăl akasă. Isus u mers, šă u lot lok la masă. ");
INSERT INTO ronBayash_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Kănd farizeju u văzut kă nu šu spălat mănjilje majnti ka kum ăj običaj alu židov, su apukat să mănănšji a farizeju su začudulit. ");
INSERT INTO ronBayash_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ali Domnu Isus ju zăs: “Aku voj farizeji pă dă nă afară cănjec kljištaru šă teru čišć, ali pă dă nontru voj ščec pljinj dă pulkučală šă relji. ");
INSERT INTO ronBayash_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Voj făr dă firi! Nuj Dimizov kari u stvorulit vanjština, u stvorulit šă nutrina? ");
INSERT INTO ronBayash_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Maj benj dăđec milostinja avostră dăm tot sufljitu alu heje kari lji potrebno šje voj avec, atunšje vu fi kutotu čist. ");
INSERT INTO ronBayash_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ali jao avovă farizejilor! Kă voj tari vă trudulec să dăđec desetina dăm tot začinurlje šă povrčur alu Dimizov, a nu băgăc sama dă pravdă šă ljubav alu Dimizov. Una trăbă să fašjec, a hajelantă să nu propustulešč. ");
INSERT INTO ronBayash_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ali jao avovă, farizejilor! Kă voj plăšjec lokurlje glavnă pă sastankur ăm sinagogă, šă pozdravalală ku poštovanje ăm varuš pă trgur. ");
INSERT INTO ronBayash_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Jao avovă, kă voj ščec ka askunsă gropă pă kari ominji umblă a nu šćijă kă obredno ăs atunšje nečisti.” ");
INSERT INTO ronBayash_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","A unu dăm učitelj dă zakonu alu Mojsije u zăs alu Isus: “Učitelju, kănd svitešć aša, tu nji vređălešć šă pă noj.” ");
INSERT INTO ronBayash_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Isus u zăs: “Jao šă avovă učitelji dă zakonu alu Mojsije, kă punjec pă ominj maj mult teret dă pravilurlje alu vjera dă kit šje poći om purta, a voj nu gănđec njiš ku žježjitu mik să ažutăc dă teretula să dukă. ");
INSERT INTO ronBayash_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Jao avovă! Kă voj gradalec spomenikur pă gropă alu proroci šă gănđec kă ku aje fišjec benji, a preci avoštri lju amurăt. ");
INSERT INTO ronBayash_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Aša voj svedočulec šă vă slagalec ku djela alu preci avoštri. Jej lju amurăt, a voj nastavalec ku lukru alor kănd gradalec spomenikur. ");
INSERT INTO ronBayash_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Dimizov ăm mudrostu aluj u zăs: ‘Ju uj măna pă prorokur šă pă apostolur šă orikic dăm jej ur fi amurăc a alci u fi progonulic.’ ");
INSERT INTO ronBayash_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Daje dă la asta generacijă u fi tražalită sănžilje dă la toc proroci kari u fost vărsată dăm elši dă kănd su stvorulit svetu: ");
INSERT INTO ronBayash_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","su apuka dă la sănžilje alu Abel pănă la sănžilje alu Zaharija, kari u fost amurăt ăntri žrtvenik šă ăm svetinja dă Hram. Ju vă zăk: ‘Kă kutotu asta u fi tražalit dă la asta generacijă!’ ");
INSERT INTO ronBayash_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Jao avovă učitelji dă zakonu alu Mojsije! Daje kă voj ac lot ăndărăt čejilje dă kraljevstva alu Dimizov. Voj săngur nac mers ăm nontru šă ac sprečilit pă alci să tunji ăm nontru kănd gănđe.” ");
INSERT INTO ronBayash_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Dă pă šje u fužjit Isus dă pă lokula, učitelji dă zakonu alu Mojsije šă farizeji sur ăngănđit să mergă dă pă jăl să ăl ispitivălaskă. ");
INSERT INTO ronBayash_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Gănđe să ăl apušji pă Isus ăm zamkă šje ar puće să zăkă protiv dă jăl numa să ăl dukă pă sud. ");
INSERT INTO ronBayash_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Aša mulc ominj su sakupilit dă mar kălka una pă alt kic as re pă lănga Isus. Ali Isus elši u zăs alu učenici aluj: “Loc sama dă kvascu alu farizej! Ala kvas ăj licemjerje. ");
INSERT INTO ronBayash_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Njimika nuj akupirit šje no fi dăskupirit, njiš una tajnă kari no fi šćută. ");
INSERT INTO ronBayash_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Aša dakă ac zăs šjeva ăm tunjerik su šći ăm lumină, šă dakă ac šupunjit šjeva ăm soba avostră aje isto u fi mužjit pă krovur dă kăš.” ");
INSERT INTO ronBayash_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Isus u zăs: “Urtašji amej lasăcămă să vă zăk, nu vă fijă frikă dă eje kari numa vă poći amură tela šă nu poći njimika să vă fakă. ");
INSERT INTO ronBayash_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ju vuj zăšji dă šjinji trăbă să vă fijă frikă. Fijă vă frikă dă Dimizov kari poči să amori, atunšje vă poči vărlji ăm pakao. Da anume, dă jăl vă trăbă să vă fijă frikă. ");
INSERT INTO ronBayash_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Nus šinšj (5) vrăbuj văndući dă doj banj? Dimizov nu mujtă pă njime. ");
INSERT INTO ronBayash_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","A avovă čak šă păru pă kap vi umărat. Nu vă fijă frikă! Voj ščec maj vredni dă gărmadă dă vrăbuj.” ");
INSERT INTO ronBayash_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Isus u zăs: “Šjinji gođ pă pămănt mu priznali pă minji ăm nenće alu ominj, Ju Fišjoru Omuluj isto uj priznali pă jăl ăm nenće lu anđelji alu Dimizov. ");
INSERT INTO ronBayash_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ala kari pă minji nu mu priznali pă pămănt ju muj odreknuli dă jăl la anđeljilje alu Dimizov. ");
INSERT INTO ronBayash_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Dakă bilo šjinji svitešći vorba protiv dă minji Fišjoru Omuluj aluje poći fi jirtat; ali dakă šjinjiva svitešči mišjunj dă Duhu Svănt, grehula no fi jirtat. ");
INSERT INTO ronBayash_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Dakă vu adušji la sud ăm sinagogur šă la poglavicur šă vladarur, nu vă brigalec kum šă ku šje muj branali, ili šje să zăk. ");
INSERT INTO ronBayash_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kănd u vinji vreme, Duhu Svănt ću ănvăca šje trăbă să zăšj.” ");
INSERT INTO ronBayash_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Unu dăm ominj ăm gărmadă u zăs alu Isus: “Učitelju ză alu fračilje amnjov să să ămperci ku minji šje anj kăpătat.” ");
INSERT INTO ronBayash_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Isus u odbilit šă zăšje: “Omulji, šinji mu pus pă minji dă sudac, să ămpărc ăntri voj doj?” ");
INSERT INTO ronBayash_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Atunšje kănd u svătit alu toc kutotu, Isus u zăs: “Băgăc sama šă păzăcăvă dă pulkučală! Dakă šjinjiva ari mult, tod daje kustu aluj nuj siguran bez obzira kă ari kutotu.” ");
INSERT INTO ronBayash_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Isus u spus maj una usporedbă: “Are akulo om găzdak făr dă firi kari ave tălek šă tălekula u adus mult plod. ");
INSERT INTO ronBayash_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Šă jăl šu zăs săngur aluj: ‘Šje să fak kă nam dăstul lok să puj ăndărăt šje mu kriskut?’ ");
INSERT INTO ronBayash_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Atunšje, jăl u zăs: ‘Aša uj fašji: Ju uj răstuna skladišturlje amelji šă uj gradali maj mari, dăstul dă mari să spremălesk kutotu šje mu kriskut.’ ");
INSERT INTO ronBayash_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Šă ju muj zăšji alu duša ame: ‘Aj mulći bunji stvarur aku, šă dă mulc ej šje ur vinji. Odmoruleščići, mănănkă šă be, šă ănfulušeščići!’ ");
INSERT INTO ronBayash_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ali Dimizov ju zăs aluj: ‘Tu omulje făr dă firi! Mar ăm asta nopći uj šjire duša ata. Atunšje šjinji u ave korist dăm stvarurlje šje caj pus ăndărăt?’ ");
INSERT INTO ronBayash_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Aša păce omu kari ăš akulježi găzdăšijilje păntru jăl săngur, a nu su găzdašjit ăm oči alu Dimizov.” ");
INSERT INTO ronBayash_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kapu u zăs Isus alu učenici: “Daje vă zăk: voj nu trăbă să vă brigalec, dă kustu avostru, šă să fijec ăm brigur šje vic mănka, ili să vă brinulec ăm šje vic ămbrăka. ");
INSERT INTO ronBayash_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Daje kă kustu ăj maj vrednă dă kit mănkare, šă tela maj mult dă kit colu. ");
INSERT INTO ronBayash_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Numa ujtăcăvă la găgărašć. Jej njišj nu samănă, njišj nu akulježi. Jelji nari skladište ili šupă, šă tod daje Dimizov lji rănješći. Nu ščec voj maj vredni dă vrabujrljelje? ");
INSERT INTO ronBayash_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Poči šjinjiva dăm voj ku brigurlje produžuli kustu? ");
INSERT INTO ronBayash_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Dakă, nu pučec să făšjec niti maj măkăčelji, adăšje ščec ăm brigur dă kutotu ostalo? ");
INSERT INTO ronBayash_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Numa ujtăcăvă la flor ăm telek! Jelji niti să trudulešći niti fašji colji ali ju vă zăk, kă njiš Car Salomon ăm găzdăšije alor nu are ămbrăkat aša măndru ka florurlje ăm telek. ");
INSERT INTO ronBayash_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ali dakă Dimizov dă dastafel măndremi alu jarbă kari kustă astăs, šă să bagă ăm fok, kit atunšje maj mult u da jăl avovă. O voj avec mikă ănkriđală! ");
INSERT INTO ronBayash_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Dăm ala rănd nu vă gănđec šje vic mănka šă šje vic be. Nu vă uznemirilec! ");
INSERT INTO ronBayash_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Dă kutotu aje să brinulešći ominj făr dă Dimizov. Ăngănđecăvă kă Tata avostru dăm nor šćijă šje vă trăbă. ");
INSERT INTO ronBayash_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Šă anume tražalec kraljevstva alu Dimizov elši šă kutotu ostalo vu fi dat. ");
INSERT INTO ronBayash_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","O mikă stadă, nuc fijă frikă, kă Tata avostru să ănfălušešći să vă apušji ăm kraljevstva aluj. ");
INSERT INTO ronBayash_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Vinđec kutotu šje avec šă dăđec alu sărašj. Aša adunăcăvă tăšč kari nu su puće rupi, šă găzdăšijă să vă fijă ăm nor kari nu propadalešči, hunđi lotri nor puće vinji, niti găndašji să mănăšji! ");
INSERT INTO ronBayash_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Daje kă sufljičilje avoštri u fi hunđi ăj blago avostru.” ");
INSERT INTO ronBayash_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Isus u zăs alu učenici: “Fijec spremni dă lukru, la să fijec opremilică šă ăm mănjilje avoštri lasă fijă luminjilje acăcaći. ");
INSERT INTO ronBayash_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Aša u fi ka slugurlje kari u ašćiptat pă gospodaru aluj să să ăntorkă dă pă nuntă, spremni să ăj dăsvăkă kum u kukunji pă ušă. ");
INSERT INTO ronBayash_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Măndremi alu eje slugur kari u fi skulac, kănd u vinji gospodaru! Anume ju vă zăk: Domnu šu punji săngur kintrinca să lji služulaskă šă lju punji să šadă la masă šă lju dvoruli. ");
INSERT INTO ronBayash_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Šă kănd u vinji gospodaru ăm miržuku dă nopči ili dăspru zua šă lju afla aša, măndremi u fi alu ala slugur! ");
INSERT INTO ronBayash_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Slušulecămă dă asta: ka să šćijă gazda ăm kari šas u vinji lotru, jăl ar păză šă nar lăsa să ăj fijă provalalit ăm kasă. ");
INSERT INTO ronBayash_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Voj isto trăbă să fijec spremni, kă ju Fišjoru Omuluj uj vinji ăm vremi kănd nu či nadali.” ");
INSERT INTO ronBayash_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petar atunšje lu ăntribat pă jăl: “Domnu spuj tu asta usporedbă păntru noj učenici, ili ăj păntru toc?” ");
INSERT INTO ronBayash_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Isus u zăs: “Šinji ăj ala vjernă šă kufiri upravitelj kari ăl postavalešći dă gospodar pă kasa, šă ăm pravă vremi u da mănkari alu toc ăm kasa? ");
INSERT INTO ronBayash_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Măndremi alu ala sluga kari kănd u vinji gospodaru, u fašji aša. ");
INSERT INTO ronBayash_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Dă anume, ju vă spuj kă gospodaru u odredilit alu ala sluga să vodulaskă ku kutotu imanje kari ari. ");
INSERT INTO ronBayash_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ali dakă sluga šar zăšji ăm sufljituš: ‘Gospodaru, nu su ăntoršji aša păfriš’, šă atunšje să apušji să bată pă slugur šă să be, mănăšji šă să ambeći? ");
INSERT INTO ronBayash_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Atunšje u vinji gospodaru alu sluga ăm šjas kari nu šćijec. Šă atunšje fărd dă milost lu kaznali, ju da sudbină ku alci una kari nus vjerni. ");
INSERT INTO ronBayash_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Sluga kari šćijă šje gănđešći gospodaru, šă dakă nu fašji šă nu să pripremilešči dă dolasku aluj, jăl u kăpăta mulći luvalur. ");
INSERT INTO ronBayash_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ali dakă sluga nu šćijă voje alu gospodaru, šă fašji šjeva šje zaslužulešći kaznă, atunšje u kăpăta pucănji luvalur. Kă alu toc kari mult u fost dat, mult su ašćipta dă la jej, šă alu eje alu kari u fost mult dat ăm povjerenje, dă la eje šă maj mult u fi šjirut.” ");
INSERT INTO ronBayash_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Isus u zăs: “Ju am vinjit să vărljesk fok dă sud pă pămănt, šă kum aš gănđi să să apušji să ardă! ");
INSERT INTO ronBayash_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Trăbă majnti să mă bučez ku mukur. Kum mă mučulesk pă šje aje no trešji! ");
INSERT INTO ronBayash_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Gănđec kă am vinjit să vă aduk putuljală pă pămănt ăntri ominj? Nu, ju am adus podjelă! ");
INSERT INTO ronBayash_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Dă aku maj menkulo ăm kasa dă šinšj ominj ur fi ămpărcăc tri u fi pă parče ame šă doj protiv dă tri. ");
INSERT INTO ronBayash_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tatusu u fi protiv dă fišjoruš, šă fišjoru u fi protiv dă tatusu, mumăsa protiv dă fataš, a fata protiv dă mumăsa, šă sokra protiv dă njivastaš, šă njivasta protiv dă sokrăsa.” ");
INSERT INTO ronBayash_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Kum svite alu gărmadă, Isus u zăs: “Kănd viđec njegri oblakur kă să răđika dă pă more pă zapad, voj odma zăšjec: ‘Astăs u fi plojă’, šă voj ščec u pravu. ");
INSERT INTO ronBayash_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Šă kănd să apukă să bată văntu dăm pustinja la jug, odma zăšjec: ‘U fi zuva tari kaldă’, šă ăj aša. ");
INSERT INTO ronBayash_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Licemjerilor! Voj šćijec să čitalec znakurlje pă pămănt šă pă nor. Kum dă nu prišjipec šje aku să dogudulešči! ");
INSERT INTO ronBayash_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Voj ac trăbuji dăm haje avostru să šćijec šje ăj benji. ");
INSERT INTO ronBayash_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Dăkă šjinjiva či optužulešći păntru dugu kari nac plăčit šă vă gănđešči să vă adukă la sud, ănšjarkă inka pă kalji să vij la ligizală majnti dă sud! Ar puće să či adukă la sudac, sudacu să či đe la oficir, šă oficiru či poći băgă ăm čemică. ");
INSERT INTO ronBayash_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ju vă zăk, kă akulo vi trăbuji să rămăj păn šje no fi plăčit toc banji.” ");
INSERT INTO ronBayash_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Pă aje vremi orikic dăm regija Galileja ur vinjit la Isus šă jur spus dă Galilejci, a Pilat kari are rimski upravitelj u dat zapovjed pă jej să lji amori kănd jej prinosule žrtvur alu Dimizov ăm Hramu alu Jeruzalem. ");
INSERT INTO ronBayash_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Isus u zăs: “Voj gănđec kă Galilejci ăs maj grešni dă bilo kari alci Galilejc, numa dăm ala rănd kă ur păcăt jej asta? ");
INSERT INTO ronBayash_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nu, uopće nu! Šă punjec ureći! Dăkă nu vic ănkăji voj toc isto aša vic fi duhovno morc. ");
INSERT INTO ronBayash_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Šă gănđec voj kă eje osamnaest lumi kari ur fost amurăc kănd u kăzut tornju alu Siloam asre maj duvinj ominj ăm Jeruzalem? ");
INSERT INTO ronBayash_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nu, uopće nu! Dakă nu vic ănkăji, aša toc vic fi duhovno morc.” ");
INSERT INTO ronBayash_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Isus lji spus asta usporedbă: “Are akulo unu om kari ave sămănat ăm vinograd ljemn dă smokvă šă jăl tot vinje šă să ujtă dăkă ăj plod pă ljemn ali nu afla njimika. ");
INSERT INTO ronBayash_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Šă aša u zăs alu omula šje lukră ăm gard: ‘Ujtăći ajišje! Kă mar tri aj mă ujta pă ljemnusta să aflu plod šă nikad nu am aflat njimik. Tajăl ăndărăt! Adăšje ar čălti pămăntu?’ ");
INSERT INTO ronBayash_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Pă aje, omu šje lukra ăm gard u zăs: ‘Domnu, lasă maj unu aj să fijă. Ju uj kapali pă lăngă jăl šă uj punji gnoj. ");
INSERT INTO ronBayash_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Dar atunšje u ave plod. Dăkă nu, poc să ăl taj ăndărăt.’” ");
INSERT INTO ronBayash_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Pă zua dă sămbăta, Isus ănvăca ăm una dă sinagogur. ");
INSERT INTO ronBayash_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Akulo are mujeri kari patale mar osamnaest ej, dă rov duh ăm je kari izazavale bičišug. Je are apljikată žjos šă nu să puće uspravali. ");
INSERT INTO ronBayash_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Isus u skužulitu, šă ju zăs: “Mujeru, slobodnă ješć dăm bičišugu atov.” ");
INSERT INTO ronBayash_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Atunšje Isus u pus mănjilje aluj pă je, šă je dăm turdată su uspravalit šă su apukat să đe hvală alu Dimizov. ");
INSERT INTO ronBayash_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ali zapovjedniku dă sinagogă are mirgiš daje kă Isus u ăntrimatu pă zuva dă sămbăta šă jăl su ăntors la eje ominj šă u zăs: “Ăs šinšj (6) zălji ăm una sămptămăna hunđi trăbă să lukri! Dakă gănđec să fijec sănătoš hajde pă una dăm elje zălji, a nu pă sămbăta.” ");
INSERT INTO ronBayash_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","A Domnu Isus u zăs: “Licemjerilor! Voj fišjec kănd dăzljăgec pă vašjilje šă pă măgari avoštri pă zuva dă sămbăta šă lji dušjec la apă? ");
INSERT INTO ronBayash_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ali asta mujeri, sămănca alu Abraham, kari Sotona u cănutu ljigată osamnaest ej šă nar ave pravo să fijă dizljigată dăm ala rănd kă pă zuva dă sămbăta?” ");
INSERT INTO ronBayash_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Pă asta, toc eje kari să protivile as re rušănac. Toc alci ăm gărmadă sur ănfălušăt la toći măndri šă bunji stvarurlje šje Isus făšje. ");
INSERT INTO ronBayash_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Isus u ăntribat: “Alu šjinji are slično kraljevstvo alu Dimizov? Kum samănă kraljevstva alu Dimizov? Ku šje să usporidălenj? ");
INSERT INTO ronBayash_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kă kraljevstvo alu Dimizov aj ka gorušičino sămănca kari ăj tari mikă pă kari om u lotu šă u sămănat ăm garduš šă u krešći šă u fost mari ljemn šă vrăbujilje u făkut skujbur ăm granur.” ");
INSERT INTO ronBayash_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jară u ăntribat: “Ku šje să usporidălenj kraljevstvo alu Dimizov? ");
INSERT INTO ronBayash_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kraljevstvo alu Dimizov ăj ka kum mujere ari kvasac să misălaskă mari količină dă făjnă, aša kutotu să să potă răđika.” ");
INSERT INTO ronBayash_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Isus putuvule ăm Jeruzalem, prošule ăm mulći varušur šă satur šă pă akulo ănvăca ");
INSERT INTO ronBayash_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Atunšje šjinjiva lu ăntribat pă jăl: “Domnu u spasali Dimizov čar pucănj ominj?” Šă Isus u zăs alor: ");
INSERT INTO ronBayash_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Uša dă nor ăj uskă. Borulecăvă tari să tunăc ăm nontru. Ju vă pot zăšji kă mulc ur ănšjirka să tunji ali nor puće. ");
INSERT INTO ronBayash_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Vreme u vinji kănd gospodaru dă kasa su riđika šă u ănćižji uša atunšje. Voj pă alta parći vic apuka să kukunjec šă vic aruga: ‘Domnu, dăsvă păntru noj.’ Šă vorba aluj u fi: ‘Ju nu šćuv dă hunđi ščec voj.’ ");
INSERT INTO ronBayash_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Voj vic apuka să zăšjec pă aje: ‘Ali noj anj but šă anj mănkat ku činji kănd ănvăcaj pă ulicurlje anoštri.’ ");
INSERT INTO ronBayash_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Šă jăl u zăšji maj undată: ‘Ju vam zăs kă nu šćuv dă hunđi ščec. Fužjec dă la minji, voj ominjilor rej!’ ");
INSERT INTO ronBayash_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Da akulo vic plănžji šă vic kărcăji ku đinci šă vic fi mirgiš kănd vic viđe pă Abraham, Izak šă pă Jakov šă pă toc proroci ăm kraljevstva alu Dimizov, ali voj vic fi vărljic afară. ");
INSERT INTO ronBayash_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Šă eje kari ur šăđe la masă pă nuntă ăm kraljevstva alu Dimizov ur vinji dă pă Istok, Zapad, Sjever, šă dă pă Jug. ");
INSERT INTO ronBayash_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Băgăc sama kă orikic kari ăs aku maj pucăn važni ur fi maj mar, a hej kari ăs aku maj mar ur fi maj mišj.” ");
INSERT INTO ronBayash_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Orikic farizej ur vinjit la Isus ăm aje ista ză, să ăl ămpurušjaskă. Šă ju zăs: “Herod gănđešći să či amori. Dăm ala rănd lasă lokusta šă dući pă altu lok.” ");
INSERT INTO ronBayash_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Isus u ăntors vorba: “Dušjecăvă šă zăšjec alu lisicurljelje: ‘Ju măn pă drašj afară šă ozdravalaskă pă bičež. Ju uj fašji aša astăs, šă mănji šă tek ăm treća zuva uj zavăršăli.’ ");
INSERT INTO ronBayash_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ali ju trăbă să fjuv pă kalje astăs, mănji šă treća zuva, izgledalešči kă nu slobut proroku să mori afară dăm Jeruzalem. ");
INSERT INTO ronBayash_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","O Jeruzaleme, Jeruzaleme tu kari aj amurăt pă proroc šă aj vărljit petri pă eje kari Dimizov vu mănat la činji! Kiči răndur am gănđit să branalesk pă kupiji atej ka găjna pă pujiš dăsup haripilješ, ali voj nu gănđec! ");
INSERT INTO ronBayash_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ujtăći aku! Kasa ata ăj lăsată săngură golă. Šă nu mic viđe păn šje nu vic zăšji: ‘Blagoslovulit să fijă kari vinji ăm numilje alu Domnu!’ ” ");
INSERT INTO ronBayash_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Undată Isus u mers să večeralaskă la kasa alu vođa dă farizej. Are pă zuva dă sămbăta šă jej să ujta pă jăl tari ku sama. ");
INSERT INTO ronBayash_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Om ku bičišug dă umflală dăm apă su pojavalit dădănenće aluj. ");
INSERT INTO ronBayash_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Isus u ăntribat pă učiteljur dă zakonu alu Mojsije šă pă farizeji šje asre akulo: “Ăj zakonito dă pă zakonu alu Mojsije să ozdravalaskă pă zuva dă sămbăta ili nu?” ");
INSERT INTO ronBayash_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Jej tăšje, Isus pă aje u pus mănjilje pă omula, šă lu ozdravalit šă lu lăsat să fugă. ");
INSERT INTO ronBayash_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Isus lju ăntribat: “Dăkă šjinjiva dăm voj ari fišjor ili pă vakă kari u kăzut ăm bunar adănkă nac skoči odma afară, šă pă zuva dă sămbăta?” ");
INSERT INTO ronBayash_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Pă aje, jej nu puće să uništilaskă vorba. ");
INSERT INTO ronBayash_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Isus u băgat sama kum gošći kari asre čimac izabrale lokurlje helj maj ăm centră la masă. Isus lji ănvacă ku usporedbă pă jej: ");
INSERT INTO ronBayash_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Kănd ješć čimat dă la šjinjiva pă nuntă nu šăđec pă lok dă časni gošć. Domačinu ar puće să vi čimat pă šinjiva maj važni dă voj pă ala lok. ");
INSERT INTO ronBayash_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Domačinu ar puće să vijă ku omula, šă să ac zăkă: ‘Urtaku amnjov, elši lokusta ăj păntru jăl’, šă atunšje tu ješć ăm rušănji. Vi trăbuji să či dušj pă zadnji lok. ");
INSERT INTO ronBayash_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Aša kănd ješć čimat, dući šă akulježjic zadnji lok. Atunšje Domačinu ar puće să vijă šă să ac zăkă: ‘Urtaku amnjov, hajd maj ăm sus.’ Atunšje ăm asta slučaj tu vi puće să aj maj mult poštovanje ăm nenće alu urtašji atej šă gošć. ");
INSERT INTO ronBayash_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","A tot omu kari să răđika săngur u fi ponizilit, ali eje kari u fi ponizni u fi răđikac.” ");
INSERT INTO ronBayash_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Su ăntors la Domačin šă Isus u zăs: “Kănd pripremilešć večeră nu čima numa pă urtašjic, ili pă fračic, ili pă njamuc ili pă găzdašj susjedur, kă jej sigurno čur čimaći pă činji isto šă aša cu fi ăntors. ");
INSERT INTO ronBayash_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Maj benji kănd fašj feštă čamălji pă sărašj să vij šă pă invaliž, šă pă ulož šă pă orb. ");
INSERT INTO ronBayash_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Tu vi fi blagoslovulit, kă jej nuc poći ăntoršji ali Dimizov ču nagradali ăm nor pă zuva dă uskrsnuće dă pravedni ominj.” ");
INSERT INTO ronBayash_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Kănd unu dăm ominjije la masă u auzăt, Jăl u zăs: “Blagoslovulit ăj ala kari u mănka pită ăm kraljevstva alu Dimizov!” ");
INSERT INTO ronBayash_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Isus u ăntors vorba: “Undată are unu om kari u dat mari večeră. Multă lumi are čimat akulo. ");
INSERT INTO ronBayash_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Mar apropi dă večeră sluga u fost mănat la gošć să lji čemi: ‘Hajdec’, u zăs jăl: ‘kă kutotu ăj spremno!’ ");
INSERT INTO ronBayash_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ali jej toc dăm jej sor apukat să ăš aflji izgovorur. Unu u zăs: ‘Ju am kumpărat telek, šă trăbă să mă duk să u văd. Mă arogă la činji, să zăšj săm jerći.’ ");
INSERT INTO ronBayash_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Alci u zăs: ‘Ju am kumpărat šinšj (5) perec dă bikan šă trăbă să mă dukă să ănšjerkă. Mă arogă la činji, să zăšj săm jerći.’ ");
INSERT INTO ronBayash_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Treći om u zăs: ‘Ju baš mam ănsurat šă dăm ala rănd nu pot vinji.’ ");
INSERT INTO ronBayash_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Sluga u mers ăm napoj la gazda aluj šă ju spus kutotu. Asta lu mirgišit pă gazda šă jăl u zăs alu sluga aluj: ‘Ăngribešćići, dući pă ulicur šă ăm centru dă varuš šă adălji pă sărašj, ulož, invaliž šă pă orb să vijă.’ ");
INSERT INTO ronBayash_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Kănd u făkut aje, gazda u javalit kă u făkut aje ali inka are maj lok. ");
INSERT INTO ronBayash_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Atunšje ju zăs gazda alu sluga: ‘Aku dući ăm kot pă ulicur šă čamă šă fă să vijă, aša să fijă kasa ame umpljită. ");
INSERT INTO ronBayash_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Kă njišj unu dăm eje elši kari asre čimac nor gusta dăm večera ame.’ ” ");
INSERT INTO ronBayash_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Mulc ominj ăl sljedile pă jăl. Isus su ăntors ăm napoj šă u svătit alor: ");
INSERT INTO ronBayash_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Bilo šinji dăm voj kari plašji maj tari pă tatusu pă mumăsa pă băšăcaš, pă kupijiš pă fraci šă pă sorălješ šă čak pă kustu aluj maj mult dă kit pă minji, nu poći să fijă učeniku amnjov. ");
INSERT INTO ronBayash_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Dakă šjinjiva gănđešči să fijă učeniku amnjov, trăbă să dukă krušje aluj să mă sljedilaskă šă să fijă spremni să mori păntru minji.” ");
INSERT INTO ronBayash_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Gănđecăvă aku dakă unu dăm voj gănđešći să fakă toranj, nu ac šăđe elši žjos šă să viđec dakă avec dăstul banj să ăl făšjec do kraja tornjula? ");
INSERT INTO ronBayash_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Inače ar puće să fašj temeljurlje šă hej šje să ujtă la voj šar puće fašji šufă dăm voj daje kă nu avec dăstul banj să završălec. ");
INSERT INTO ronBayash_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Jej ur zăšji: ‘Asta om su apukat să gradalaskă ali no putut să završălaskă!’ ");
INSERT INTO ronBayash_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ili ka kum kralju su spremili să mergă ăm bătajă ku altu kralj. Šă să nu šadă elši šă să gănđaskă dakă ku zešji (10) hiljada dă kătănj poći să ăl savladalaskă ku protivnikuš kari ari doj spešj (20) hiljada? ");
INSERT INTO ronBayash_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Atunšje dakă nu poći să ăl savladalaskă u măna pă pregovarać kită ăj inka neprijatelju dă parći să ăntrebi dă uvjetur dă putuljală. ");
INSERT INTO ronBayash_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Šă aša toc dăm voj dakă nu vic lăsa kutotu šje avec, nu poči să fijă učeniku amnjov.” ");
INSERT INTO ronBayash_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Isus u zăs: “Sari ăj bună stvar ali dăkă perđi izu, ku šje poc ăntoršji bălureme? ");
INSERT INTO ronBayash_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Nuj bună atunšje njiš dă pămănt njiš dă šrot. Lume numa u vărlješći ăndărăt. Punjec ureći voj kari avec ureći să auzăc!” ");
INSERT INTO ronBayash_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Pălăngă Isus su okupulit tari mulc carinici šă tari mari grešnici să pujă ureći la vorba aluj. ");
INSERT INTO ronBayash_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Farizeji šă učitelji dă zakonu alu Mojsije sur apukat să ăl gumunjaskă, šă jej zăšje: “Asta om să družulešći ku grešnici, šă mănănkă ku jej.” ");
INSERT INTO ronBayash_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Daje Isus lji spunji asta usporedbă: ");
INSERT INTO ronBayash_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Dakă šjinjiva dăm voj ari sto birš šă să perđi una dăm jelji, nac lăsa pă ešće devedeset devet ăm pustulot, šă ac meržji dă pă aje una su kutăc păn šje nac afla? ");
INSERT INTO ronBayash_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Šă kănd vic afla, aj dušji pă umirilje ku fălušăjă. ");
INSERT INTO ronBayash_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Atunšje ac meržji akasă, vic čima pă urtašjic šă pă susjedi avoštri šă ac zăšji: ‘Ănfălušăcăvă ku minji, kă am aflat pă birka ame kari are pirdută!’ ");
INSERT INTO ronBayash_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ju vă zăk, ku fi maj mari fulušăjă pă nor kănd su ănkăji unu grešnik, nego dă devedeset devet (99) pravednikur kari nu lji trăbă ănkăjală, aša jej gănđe.” ");
INSERT INTO ronBayash_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Isus maj zăšji: “Ili haj să zăšenj kă una mujeri ari zešji (10) banj dăm aržjint šă atunšje unu dăm jej perđi. Nu acăcă lumina šă mătura podu šă u kuta banj, păn šje nu află? ");
INSERT INTO ronBayash_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Šă kănd u afla banj dăm aržjint părdut, je šu čima pă urtašjilje alji šă pă susjedurlje una, šă u zăšji: ‘Ănfălušăcăvă ku minji, kă ju am aflat banji kari am pirdut!’ ");
INSERT INTO ronBayash_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ju vă pot zăšji kă ăj isto aša ăntră anđelji alu Dimizov. Dakă să ănkăješći unu grešnik, jej să ănfălušešći.” ");
INSERT INTO ronBayash_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Isus u zăs: “Are unu om kari ave doj fišjor. ");
INSERT INTO ronBayash_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Hăl maj tănăr u zăs alu tatusu: ‘Tată, dăm dio šje ăm pripadalešći.’ Aša tata aluj u ămpărcăt kutotu šje ave ăntri jej. ");
INSERT INTO ronBayash_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Dă pă dovă tri zălji, fišjoru hăl maj tănăr u akuljes kutotu šje ave šă su pus pă kalji să mergă dăparći šă akulo u čiltit kutotu šje ave, čilte făr dă gănd. ");
INSERT INTO ronBayash_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kănd u čiltit kutotu, mari fomi u vinjit pă pămăntu hunđi are jăl, šă su aflat ăm sărăšijă. ");
INSERT INTO ronBayash_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Aša u mers la unu om ăm pămăntula kari lu mănat ăm telek să aj rănjăskă poršji. ");
INSERT INTO ronBayash_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Aluj ji are aša fomi dă šu kivinjit să mănăšji dăm ha šje mănka poršji, šă njime nuj dăđe njimika. ");
INSERT INTO ronBayash_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Dă pă aje jăl šu vinjit ăm firi. Jăl u zăs: Tata amnjov ari mulći slugur šă jej ari um boglă dă mănkari a ju ajišje mor dă fomi! ");
INSERT INTO ronBayash_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ju muj skula šă uj meržji la tata amnjov šă ju zăšji: ‘Tata amnjov, ju am zgrešilit protiv dă činji, šă alu Dimizov ăm nor. ");
INSERT INTO ronBayash_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ju nu mes maj mult vredan să fjuv čimat fišjoru atov. O lasămă să fjuv radniku atov!’ ");
INSERT INTO ronBayash_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Atunšje su skulat šă u mers la tatusu. Ali mar kănd are inka dăparći dă la kasa alu tata aluj, tatusu lu văzut šă lu apukat mila dă jăl. Tatusu u aljirgat la jăl, lu ăngărgăjet šă ăl surătat tari. ");
INSERT INTO ronBayash_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Fišjoru ju zăs: ‘Tata amnjov, ju am zgrešilit protiv dă činji šă alu Dimizovu ăm nor. Ju nu mes maj mult vredan să fjuv čimat fišjoru atov.’ ");
INSERT INTO ronBayash_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Tatusu u zăs alu slugurlje aluj: ‘Dušjec friš šă aflăc maj bunji colji šă punjec pă jăl, dăđecăj virigă dă măna aluj, šă cipiliš dă pišjorilje aluj. ");
INSERT INTO ronBayash_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Šă apukăc pă maj măndru rănjită vakă šă amurăcu, atunšje lasă să mănkănj šă să fijenj făloš. ");
INSERT INTO ronBayash_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Adăšje? Dăm ala rănd kă astăs fišjoru amnjov are mort, a aku kustă ăm napoj! Jăl are pirdut šă aku su aflat!’ Aša jej sur apukat să să ănfălušaskă. ");
INSERT INTO ronBayash_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Maj bătărn fišjor are ăm telek. Jăl vinje akasă šă kum vinje maj apropi dă udvar, jăl puće să audă muzikă šă žok. ");
INSERT INTO ronBayash_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Aša u čimat pă unu dăm slugur šă u ăntribat šje ăj aje. ");
INSERT INTO ronBayash_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Šă ju spus: ‘Fračitu atov su ăntors akasă šă tatusu u amurăt maj măndră rănjită vakă dăm ala rănd kă su ăntors sănătos!’ ");
INSERT INTO ronBayash_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ali jăl are mirgiš šă nu gănđe să tunji ăm nontru. Šă aša u mers afară, a tatusu să aruga la jăl să vijă ăm nontru. ");
INSERT INTO ronBayash_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ali jăl u ăntors vorba alu tatusu: ‘Numa gănđeščići kă mulc ej šje am lukrat dă činji ka robu, šă uvek am făkut šje maj zăs šă tot nu maj dat njiš mikă kecă să pot ave slavalala ku urtašji amej. ");
INSERT INTO ronBayash_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ali kănd astăs fišjoru atov u vinjit akasă kari u mănkat kutotu šje aj dat găzdăšije, ku bludnicur, atunšje tu či dušj šă amor rănjită vakă păntru jăl!’ ");
INSERT INTO ronBayash_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tatusu u zăs aluj: ‘Fišjoru amnjov, tu ješć uvjek ku minji, šă kutotu šje am ju ăj atov. ");
INSERT INTO ronBayash_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Isto aša benji ăj aku să slavalenj šă să nji ănfălušănj kă astăs fračilje atov are mort šă su ăntors ăm kust ăm napoj, šă jăl are pirdut šă aku su aflat!’” ");
INSERT INTO ronBayash_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Asta usporedbă isto Isus u spus alu učenici: “Are om găzdak kari u dat lukru alu unu upravitelj, šă ju fost spus aluj kă upravitelju čăltešći šă răsăpă găzdăšije alu gazda aluj. ");
INSERT INTO ronBayash_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Aša lu čimat pă jăl šă ju zăs: ‘Šje ăj asta šje audă dă činji? Dăm računu dă kutotu šje aj făkut, kă tu maj mult nu poc fi upravitelj!’ ");
INSERT INTO ronBayash_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Upravitelju u zăs atunšje aluj săngur: ‘Šje să fak, aku kănd gazda je ăndărăt lukru dă la minji? Nu am pučeri să kapalesk? U fi rušănji să mă duk să kuldujesk. ");
INSERT INTO ronBayash_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Šćuv šje uj fašji! Ju uj đirežji aša dă kănd mur măna dăm lukrusta tot uj fi apukat ăm benji la kăšălje ominjistora.’ ");
INSERT INTO ronBayash_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Aša jăl u mănat dă pă ominji šje as re dator alu gazda aluj, unu pă kići unu. Jăl u ăntribat pă elši om: ‘Kit ješć dător alu gazda amnjov?’ ");
INSERT INTO ronBayash_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Jăl u ăntors vorba: ‘Sto bačvur dă uloj dăm maslinur.’ Upravitelju u zăs: ‘Šăz žjos, jec računu šă pă friš skrijă pedeset.’ ");
INSERT INTO ronBayash_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Šă jăl u ăntribat pă altu om: ‘Kit ješć tu dător?’ ‘Sto merur dă pšenică.’ Šă jăl ju zăs aluj: ‘Jec računu šă skrijă osamdeset.’ ");
INSERT INTO ronBayash_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Atunšje gospodaru u ămărit pă nu đirept upravitelj kari ăm oči aluj nu are bun upravitelj, kă u arătat dăstafelă mărđuljijă kari nuj bună. Asta arată, kă ominji dă asta svet ăs maj mudri ăm stvarurlje alor dă kit dă ominji dă lumină. ");
INSERT INTO ronBayash_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Šă ju vă zăk: ‘Koristilec găzdăšije šje fužji daje kă ăj nepravednă ku aje vă făšjec urtašj pă lăngă voj, aša kănd nu maj u fi găzdăšijă, atunšje voj vic fi apukac ăm nor dă erikeš. ");
INSERT INTO ronBayash_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ala kari ăj vjeran ăm maj mišj stvarur, ăj isto aša vjeran ăm stvarurlje mar; šă ala kari nuj vjeran ăm stvarurlje mišj ăj isto nu vjeran ăm stvarurlje mar. ");
INSERT INTO ronBayash_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Šă aša dakă nac fost vjerni ăm svetovno găzdăšijă šjinji vu ănkređi ku pravă găzdăšijă să upravljalec? ");
INSERT INTO ronBayash_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Šă dakă nu šćijec upravljali ku altora benjilje, šjinji vu da aje šje pripadalešći avovă? ");
INSERT INTO ronBayash_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Njiš una sluga nu poći să služulaskă pă doj gazdur dăm turdată, kă pă unu u zamrzăli a pă altu u plašji, ili u fi vjeran alu unu a pă halalănt nu u puće viđe ăm oč. Nu pučec služuli šă alu găzdăšijă šă alu Dimizov istovremeno.” ");
INSERT INTO ronBayash_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Kutotu aje auze farizeji, kari asre lukumic dă banj, šă jej su apukat să ăš fakă šjuf. ");
INSERT INTO ronBayash_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Atunšje Isus u zăs: “Voj vă fišjec pravedni ăm oči alu lume, ali Dimizov šćijă sufljičilje avoštri. Šje lume tari cenilešći, skărbă ăj ăm nenće alu Dimizov.” ");
INSERT INTO ronBayash_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Isus zăšji: “Zakonu alu Mojsije šă kenvijurlje alu proroci kari jej ur skris vridile păn šje no vinjit Ivan kari bučuza šă dă atunšje spunje Hir fălos dă kraljevstva alu Dimizov a noj trăbujenj să nagovurelenj să mergă ăm kraljevstva alu Dimizov. ");
INSERT INTO ronBayash_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Nu značalešči kă zakonu alu Mojsije nuj bun. Majnti u trešji noru šă pămăntu, kită să propadalaskă zakonu ili să kadă una slovă dăm zakon. ");
INSERT INTO ronBayash_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Kari să lasă dă la băšăcaš să să ănsori ku alta băšăca fašji preljub. Šă tot omu kari u ănsura pă mujeri kari ăj lăsată dă la bărbat isto fašji preljub.” ");
INSERT INTO ronBayash_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Isus zăšji: “Are om găzdak kari să ămbrăka ăm colji skumpi šă ăm totă ză mănka skumpă mănkari. ");
INSERT INTO ronBayash_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Akulo are isto aša om sărak kari să čima Lazar kari are astupat ku čirevur pă jăl šă are pă košći la uša la ala găzdak. ");
INSERT INTO ronBayash_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Jăl ăš kivinje să fijă rănjit ku mrvicurlje šje kăđe dă pă masa alu omuluje găzdak. Kănji delj divljă čak vinje la jăl šă ăj ljinže čirevur. ");
INSERT INTO ronBayash_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","U vinjit vreme kănd u murit kuldužu, šă anđeji lor dus ăm bracă la Abraham. Omu găzdak isto u murit šă u fost ăngrupat. ");
INSERT INTO ronBayash_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ăm mari mukă ăm podzemlje, găzdaku su ujtat sus šă u văzut pă Abraham dă dăparći šă pă Lazar kari are lăngă Abraham. ");
INSERT INTO ronBayash_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Šă jăl u plăns ăm mužjală: ‘Tata, Abraham fijăc milă dă minji! Mănăl pă Lazar la minji lasăl să ăntupaskă žježjitu ăm apă šă săm răšjaskă ljimba, kă mari mukur ăs pă minji ăm fokusta.’ ");
INSERT INTO ronBayash_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abraham u ăntors vorba: ‘Fišjoru amnjov, tu trăbă să či ăngănđešć dă aje kănd arej pă pămănt tu avej mulći bunji stvarur, kănd Lazar ave mulći relji stvarur. Ali jăl ăj aku ăm utjehă, kănd ješć tu ăm mukă. ");
INSERT INTO ronBayash_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Šă dă kutotu asta, ăntri noj šă ăntri voj ăj mari gropă făr dă kraj. Eje kari ar gănđi să mergă dă ajišje la voj nu poći, šă njiš njime nu poći dă la voj să vijă la noj.’ ");
INSERT INTO ronBayash_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Atunšje omu šje are găzdak u zăs: ‘Mă arog la činji să ăl măj pă Lazar la kasa alu tata amnjov. ");
INSERT INTO ronBayash_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ju am šinšj frac kari akulo kustă. Lasă să lji upozurulaskă să nu vijă pă ista lok pljin dă mukă!’ ");
INSERT INTO ronBayash_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham u ăntors vorba: ‘Jej ari kenvijur kari Mojsije šă proroci ari skris dă jej să lji opozurulaskă! Lasălji să pujă ureći la jej!’ ");
INSERT INTO ronBayash_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","A jăl u zăs: ‘O nu, Tata amnjov Abraham. Alor lji trăbă să lji vijă šjinjiva dăm morc, šă jej sur ănkăji.’ ");
INSERT INTO ronBayash_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraham u ăntors vorba: ‘Dakă no punji ureče la Mojsije šă la prorokur, nur ănkređi njiš să să skolji šjinjiva dăm morc.’ ” ");
INSERT INTO ronBayash_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Isus u zăs alu učenici aluj: “Napadajur dă relji trăbă să vijă ali jao alu ala om pă kari vinji. ");
INSERT INTO ronBayash_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Aluj jar fi maj benji să ajvi petră dăm mlin ljigată la găt šă să să vărljaskă ăm apă, dă kit să puji pă grehur pă hej mišj. ");
INSERT INTO ronBayash_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Fijec ăm samă! Dakă fračitu ac vitešći ămpurišešćil; atunšje dakă su ănkăji, jartăj. ");
INSERT INTO ronBayash_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Makar să zgrešilaskă protiv dă činji šapči (7) răndur ăm una ză, dakă vinji la činji šapči (7) răndur să priznalaskă dă aje šje u făkut, jartăj.” ");
INSERT INTO ronBayash_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Apostolu u zăs alu Domnu: “Dănji maj mult ănkriđală!” ");
INSERT INTO ronBayash_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Domnu anostru u ăntors vorba: “Să vi avut ănkriđală makar aša dă mikă ka sămănca dă gorušičino zrno voj ac puće zăšji alu ljemnusta: ‘Skočići dăm vănj šă sămănăći ăm more!’, šă voj vic punji ureći. ");
INSERT INTO ronBayash_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Šjinji dăm voj zăšji alu sluga aluj, dă pă šje u lukra ăm telek ili păze pă biršj, să ac zăkă kănd vinji dăm lukru: ‘Hajd jec lok?’ ");
INSERT INTO ronBayash_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Mar ju zăšji am lok dă aje: ‘Dući šă fă šjeva dă mănkat, ščimbăc coljilje, šă ašćaptămă să mănănk šă să bjov, dă pă aje poc tu să šăs šă să mănăšj!’ ");
INSERT INTO ronBayash_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Šă ar kăpăta sluga šjeva ka posebnă zaslugă dă aje dă šje u făkut? Ju gănđesk kă nu. ");
INSERT INTO ronBayash_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Šă voj isto făšjec kutotu šje am zapovjedalit, trăbă să zăšjec: ‘Noj šćenj numa obični slugur. Noj numa anj făkut lukru anostru!’ ” ");
INSERT INTO ronBayash_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Aša pă kalje dă Jeruzalem, Isus u mers pă kalje kari sljedile granicurlje ăntri Samarija šă Galileja. ");
INSERT INTO ronBayash_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Are aje să tunji ăm unu dăm saturljelje šă jăl u aflat pă drik zešji (10) ominj ku gubă. Jej ur stat pă dăparči ");
INSERT INTO ronBayash_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","šă ur mužjit la jăl: “O Isuse Domnu! Fijăc milă dă noj!” ");
INSERT INTO ronBayash_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Kănd u văzut pă jej, Isus u zăs: “Dušjec šă arătăcăvă la pop să vadă dakă ščec sănătoš.” Jej lur pus ureći, šă pă kalji jej ur fost čistilic. ");
INSERT INTO ronBayash_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Atunšje unu dăm jej kănd u văzut kă u fost čistilit su ăntors ăm napoj šă dăm tot graju slavale pă Dimizov. ");
INSERT INTO ronBayash_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jăl u kăzut žjos pă ubrazu la pišjorilje alu Isus šă ju zahvalalit. Ali omula are Samaritanac. ");
INSERT INTO ronBayash_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Isus u ăntribat: “Nas re zešji (10) ominj kari as re čistilic? Hunđi ăs hešćelanc novă (9) ominj? ");
INSERT INTO ronBayash_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Nu su ăntors njime ăm napoj să đe slavalala alu Dimizov, čar strancusta?” ");
INSERT INTO ronBayash_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Atunšje jăl u zăs: “Skolăći šă dući pă kaljec. Ănkriđala ata ću spasalit!” ");
INSERT INTO ronBayash_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Kum u fost ăntribat dă la farizeji kănd u vinji Kraljevstvo alu Dimizov, Isus u ăntors vorba: “Kraljevstvo alu Dimizov nu vinji, aša să potă ominji să promatralaskă dă pă znakovur. ");
INSERT INTO ronBayash_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Aša lume să nu potă să zăkă: ‘Ujtăći! Ajiše ăj.’ Ili: ‘Akulo ăj!’ Nu! Kraljevstvo alu Dimizov ăj ăntri voj!” ");
INSERT INTO ronBayash_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Jăl u zăs lu učenici aluj: “U vinji vremi kănd vic kivinji să viđec una dăm zăljiljelje kănd ju, Fišjoru Omuluj, uj vladali ka kralju, ali kivinjala avostră no fi ispunulită. ");
INSERT INTO ronBayash_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Orikic ur zăšji: ‘Ujtăći akulo ăj! Ajišje ăj!’ Nu fužjec ăm njikere nu vă maknalec! ");
INSERT INTO ronBayash_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kănd ju uj vinji Fišjoru alu Omuluj, ju uj vinji ka skripala pljin dă svetlă svitlăzănt dăm unu kap dă nor păn la altu kap dă nor. Aša u fi šă ku Fišjoru Omuluj ăm zua aluj. ");
INSERT INTO ronBayash_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ali majnti dă aje, ju trăbujesk să patalaskă mult šă ju uj fi odbacalit dă la asta generacijă. ");
INSERT INTO ronBayash_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Kum are ăm zăljilje kănd Noa kusta, aša u fi ăm zăljilje kănd ju Fišjoru Omuluj uj vinji. ");
INSERT INTO ronBayash_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Atunšje jej mănka šă bije, să ănsura šă să ămirita pănă ăm zuve kănd Noa u tunat ăm arkă. Šă poplava u vinjit šă u uništilit pă toc kari nas re ăm arkă. ");
INSERT INTO ronBayash_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Isto aša are ăm zăljilje kănd Lot kusta. Jej mănka šă bije, kumpăra šă vinđe, šă sămăna šă gradale. ");
INSERT INTO ronBayash_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ali pă zuva šje Lot u fužjit dăm Sodoma u kăzut fok šă sumpor dăm nor šă u uništilit pă jej toc. ");
INSERT INTO ronBayash_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Isto aša u fi dăm turdată pă zuve kănd ju, Fišjoru alu Omuluj muj ăntoršji. ");
INSERT INTO ronBayash_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Dakă ăj ăm aje zuva omu pă krovuš dă kasa a stvarurlje aluj ăs ăm kasa, nu mergă žjos dă pă jelji să ăš je ku jăl. Isto aša dakă ăj om ăm telek, nu mergă akasă. ");
INSERT INTO ronBayash_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ăngănđecavă dă băšăca alu Lot šje ju su dogodulit! ");
INSERT INTO ronBayash_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Šinji gođe ănšjarkă să ăš spasalaskă kustuš ala lu perđi a kari lu perđi ala u ave kust. ");
INSERT INTO ronBayash_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ăm aje nopći ju vă spuj ur fi doj ominj ăm ista pat šă unu dăm jej u fi lot, halalănt u fi lăsat. ");
INSERT INTO ronBayash_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Dovă mujer una ur meljali făn, šă una u fi lotă, hajelantă u rămănje.” ");
INSERT INTO ronBayash_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Učenici ur ăntribat pă Isus: “Hunđi u fi aje Domnu.” Jăl u odgovorulit: “Hunđi ăs ominj morc akulo u vinji lešinari.” ");
INSERT INTO ronBayash_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Isus u spus usporedba să areći alu učenikur kă om ar trăbuji uvjek să să aroži šă nikad să nu odustulaskă. ");
INSERT INTO ronBayash_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Jăl u zăs: “Ăm unu varoš are unu sudac. Omusta nu ave frikă dă Dimizov, njiš nu să brigale dă njime šje jej zăšji. ");
INSERT INTO ronBayash_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Šă akulo are una vădojă ăm varušula kari stalno vinje akulo la jăl, šă să aruga: ‘Apără mă dă dužmanu amnjov.’ ");
INSERT INTO ronBayash_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Una vremi nuj ažuta. Dă pă aje su apukat să să ăngănđaskă: ‘Nu am njiš šefălj frikă dă Dimizov, ili brigă pă lăngă ominj. ");
INSERT INTO ronBayash_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Kum gođe, ju uj ažuta alu asta udovică kă mult mă dosadalešći. Uj apăra, inače mu dosadali ku vinjala šă ku ăntribalurlje alji.’” ");
INSERT INTO ronBayash_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Atunšje Domnu Isus u zăs: “Ac băgat sama šje šu zăs săngur aluj sudacu hamiš? ");
INSERT INTO ronBayash_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Šă atunšje nu da Dimizov điriptaći šă zaštită alu lume akuljesă aluj kari plănži la jăl zuva šă nopće šă jăl are strpljiv ku jej. ");
INSERT INTO ronBayash_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ju vă zăk kă jăl u ažuta ku điriptači šă ku zaštită pă friš. Ali uj afla Fišjoru alu Omuluj dăstafelă ănkriđală ăm ominj kănd ju muj ăntoršji pă pămănt?” ");
INSERT INTO ronBayash_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Isus u spus alta puvešči, alu orikic ominj kari asre tari uvjerilică ăm pravednostu alor, a jej pă alci să ujtă ku măržnjă. ");
INSERT INTO ronBayash_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Jăl u zăs: “Doj ominj ur mers sus ăm Hram să să aroži. Unu dăm jej are farizej, šă altu om are carinik. ");
INSERT INTO ronBayash_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farizeju su skulat sus šă u zăs asta aruguminći păntru dă jăl: ‘O Dimizolje, ju dov hvală cijă kă nu mes ju ka hešćelanc ominj: pulkućic, hamiš, preljubnik, ili čak ka asta carinik. ");
INSERT INTO ronBayash_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ju postulesk dovă răndur pă săptămănă; dov desetina cijă dă kutotu šje zaradalesk.’ ");
INSERT INTO ronBayash_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Cariniku pă haje parći, u rămas dă parći, šă nu su ăndura să răđiši očiš ăm nor, numa ăš băče čeptu dă žalji šă zăšje: ‘Dimizolje aj milă dă minji grešnik!’ ");
INSERT INTO ronBayash_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ju ăc zăk kă ala poreznik u mers akasă opravdan la Dimizov, a farizej nu. A tot omu kari să răđika săngur u fi ponizilit, ali eje kari u fi ponizni u fi răđikac.” ");
INSERT INTO ronBayash_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Jej ur adus isto aša šă pă mišj kupijiš, să pujă Isus mănjilje pă jej să lji blagoslovulaskă. Ali kănd ur văzut aje učenici jej ljur svătit să ăj đe uđină. ");
INSERT INTO ronBayash_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Isus lju čimat atunšje la jăl šă u zăs: “Lasălji pă kupiji să vijă la minji šă nu lji branalec, kă kraljevstva alu Dimizov pripadalešći alu dastafel ka jej. ");
INSERT INTO ronBayash_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Anume, ju vă zăk: ‘Kă kari gođe no fi ka kupiji mišj ponizni nor puće să tunji ăm kraljevstva alu Dimizov.’” ");
INSERT INTO ronBayash_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Are unu vladar akulo kari u ăntribat pă Isus: “Bun Učitelju, šje trăbă să fak să kapăt kust dă erikeš?” ");
INSERT INTO ronBayash_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ju zăs Isus aluj: “Adăšje mă čem pă minji bun? Njime nuj bun čar unu Dimizov. ");
INSERT INTO ronBayash_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Zapovjedurlje alu Dimizov šćijă: ‘Nu fă preljub’, ‘Nu amură’, ‘Nu fura’, ‘Nu svedočuli ăm mišjună’, ‘Poštivălešćic pă tatusu šă pă mumăta.’ ” ");
INSERT INTO ronBayash_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Jăl zăs: “Da šă asta am păzăt dăm tănjireme ame.” ");
INSERT INTO ronBayash_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Kănd u auzăt Isus aje, jăl ju zăs: “Ali ac ibizešći una stvară: dući šă vinđic kutotu šje aj, ămparcă banji alu sărašj, šă tu vi ave găzdăšijă ăm nor. Atunšje hajd šă sljedilešćimă pă minji.” ");
INSERT INTO ronBayash_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ali kănd u auzăt aje, tari su ăntristat kă jăl are găzdak ša nu gănđe kutotu să văndă. ");
INSERT INTO ronBayash_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Kănd u văzut Isus kită dă tari su razočaralit, jăl u zăs: “Kită dă grov ăj dă eje kari ăs găzdašj să tunji ăm kraljevstva alu Dimizov! ");
INSERT INTO ronBayash_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Maj ušuri ăj alu devi să tunji păm urečilje dă ak, dă kită alu găzdak să tunji ăm kraljevstva alu Dimizov.” ");
INSERT INTO ronBayash_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Hej šje punje ureći ur zăs pă aje: “Šinji atunšje poći fi spasalit?” ");
INSERT INTO ronBayash_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Isus u ăntors vorba: “Šje ăj nemoguće alu om, ăj moguće alu Dimizov.” ");
INSERT INTO ronBayash_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Atunšje Petar u zăs: “Benji noj anj lăsat kutotu, šă čanj sljedilit pă činji.” ");
INSERT INTO ronBayash_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Isus u ăntors u alor vorba: “Anume, ju vă zăk, kă šinji gođe ăš lasă kasaš, ili pă băšăcaš, ili pă fraciš, ili pă mumăsa šă pă tatusu, ili kupijiš păntru kraljevstva alu Dimizov, ");
INSERT INTO ronBayash_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","a să nu kapići dă aje maj mult ăm asta kust dă kit ave, a u kăpăta pă altu svet kari vinji kustu dă erikeš.” ");
INSERT INTO ronBayash_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Isus u čimat pă dvanaest apostolur la jăl, šă u zăs: “Punjec ureči, noj mărženj ăm Jeruzalem šă kutotu akulo šje u fost skris dă la proroš ăm kenvija svăntă dă minji, Fišjoru Omuluj a aje su dogoduli: ");
INSERT INTO ronBayash_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Jej mu predali ăm mănjilje alu ominj kari nus Židovi šă dăm minji šor fašji šuf, uj fi bătut, jej mu skipa, ");
INSERT INTO ronBayash_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","šă dă pă šje uj fi bičevălit šă uj fi amurăt, ali dă pă aje ju uj uskrsnuli treća zuva.” ");
INSERT INTO ronBayash_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Učenici nu ščije njimik dă asta. Elje vorbi ljur fost askunšă, šă jej nor prišjiput njimika šje să ăngănđe Isus. ");
INSERT INTO ronBayash_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Kum ăs re apropi ăm Jerihon, šjeva ka omu orb šăđe pă drik šă kulduže. ");
INSERT INTO ronBayash_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Kănd omu orb u auzăt kă gărmadă trešji pă akulo, jăl su ăntribat šje ăj aje. ");
INSERT INTO ronBayash_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Aša jur spus kă Isus dăm Nazaret u trikut pă akulo. ");
INSERT INTO ronBayash_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Pă aje u mužjit: “Isuse Fišjoru alu David, mă arog la činji aj milă dă minji!” ");
INSERT INTO ronBayash_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Lume kari umblă ăm nenći ăj zăšje să takă, ali jăl su apukat šă maj tari să mužjaskă la jăl: “O Fišjoru alu David aj milă dă minji!” ");
INSERT INTO ronBayash_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Atunšje Isus u stat šă u dat zapovjed să ăl adukă la jăl. Jăl lu ăntribat: ");
INSERT INTO ronBayash_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Šje gănđešć să fak păntru činji?” Šă jăl u ăntors vorba: “O Domnu, ju gănđesk să văd!” ");
INSERT INTO ronBayash_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Isus ju zăs: “Ujtăći! Ănkriđala ata ću ozdravalită.” ");
INSERT INTO ronBayash_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Šă jăl odma u kăpătat să vadă. Šă lu sljedilit pă Isus, šă slavale pă Dimizov. Šă totă lume kari ur văzut dăđe slavă alu Dimizov. ");
INSERT INTO ronBayash_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Isus u vinjit ăm Jerihon šă u trikut ăm ala varuš. ");
INSERT INTO ronBayash_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Šă akulo are om šje să čima Zakej. Jăl are glavni poreznik, šă are găzdak. ");
INSERT INTO ronBayash_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Jăl ănšjărka să vadă pă Isus šă să saznalaskă šjinji ăj jăl. Ali nu ăl puće să ăl vadă akulo asre mulc ominj daje kă jăl are niskă om. ");
INSERT INTO ronBayash_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Dăm ala rănd jăl u aljărgat ăm nenći šă su urkat pă ljemn dă divlja smokvă ăm nadă kă lu viđe daje kă Isus vinje pă aje kalje. ");
INSERT INTO ronBayash_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Kănd u vinjit Isus pă lokula, jăl su ujtat sus šă lu văzut pă jăl, šă ju zăs: “Zakej, păfriš haj žjos, kă ju trăbă astăs să vju la činji akasă.” ");
INSERT INTO ronBayash_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Šă jăl su ăngribit să vijă žjos šă lu apukat ku fălušăjă. ");
INSERT INTO ronBayash_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Kănd ur văzut lume aje, jej toc gumunje: “Jăl u meržji la om kari ăj grešnik!” ");
INSERT INTO ronBayash_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zakej su skulat šă u zăs: “Domnu, ujtăći! Ju dov žămătaći dăm găzdăšije ame alu sărašj. Šă dakă am ănšjăljit pă šjinjiva, ăntork patru răndur majmult.” ");
INSERT INTO ronBayash_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Isus ju zăs aluj: “Astăs spasenje u vinjit la asta kasa, kă šă asta ăj fišjoru alu Abraham. ");
INSERT INTO ronBayash_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kă ju Fišjoru alu Omuluj am vinjit să kotă šă să spasalaskă pă ominj kari u fost pirdut.” ");
INSERT INTO ronBayash_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Mulc ominj ur auzăt elje vorbi, kum are dapropi dă Jeruzalem, šă ominji să gănđe kă kraljevstva alu Dimizov odma su apuka. Isus daje su apukat să lji spuji maj una usporedbă. ");
INSERT INTO ronBayash_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Jăl u zăs: “Unu găzdak om su gătat să mergă ăm dăparći pămănt să kapići kraljevstva šă atunšje să să ăntorkă. ");
INSERT INTO ronBayash_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Jăl u čimat pă zešji (10) slugur, šă lju dat pola kila dă aržjint, šă u zăs: ‘Făšjec korist aje păn šje nu mă ăntork.’ ");
INSERT INTO ronBayash_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ali ominji dăm lokula aluj ăl mărzăle, šă u mănat pă predstavnišj dă pă jăl să zăkă: ‘Noj nu gănđenj asta om să nji fijă kralj.’ ");
INSERT INTO ronBayash_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ali jăl su ăntors ku autoritet dă kralj šă u dat zapovjed să ăj adukă pă slugurljelje alu kari u dat banj să vijă dădănenći să đe izvještaj šje ur făkut ku banji. ");
INSERT INTO ronBayash_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Elši sluga kari u vinjit, u zăs: ‘Domnu, banji atej mu adus dă zešji (10) majmult.’ ");
INSERT INTO ronBayash_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Šă jăl u zăs aluj: ‘Măndru! Tu ješć bun sluga. Daje kă are vjeran ku mik, aku aj autoritet pă zešji (10) varušur.’ ");
INSERT INTO ronBayash_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Altu om u vinjit, šă u zăs: ‘Domnu, banji atej su răđikat dă šinšj (5) răndur.’ ");
INSERT INTO ronBayash_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Šă jăl u zăs isto astuje: ‘Ju cuj da autoritet pă šinšj (5) varušur.’ ");
INSERT INTO ronBayash_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Šă treći (3) u zăs: ‘Domnu, ajišje ăj banji atej, ju am păzăt păntru činji, am pus ăm maramică. ");
INSERT INTO ronBayash_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mijă mi are frikă dă činji daje ka ješć strog om: Tu jej šje naj ulagalit šă akuljež šje naj sămănat.’ ");
INSERT INTO ronBayash_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Šă u zăs kralju ăm ănturšjală dă vorba: ‘Dăm gura ata cuj suduli, njiš korist sluga! Tu šćijej kă mes om strog, šă jov šje nuj amnjov, šă akuljeg šje nam sămănat. ");
INSERT INTO ronBayash_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Atunšje adišje naj pus banji ăm bankă? Să vi putut šjeri banji ku kamaturlje kănd maš ăntoršji.’ ");
INSERT INTO ronBayash_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Atunšje kralju u zăs alu hej šje stăće akulo: ‘Loc banji dă la jăl šă dăđecăl alu ala kari ari zešji (10).’ ");
INSERT INTO ronBayash_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Jej ur zăs: ‘Ali Domnu, jăl mar ari šinšj (5) kilă dă aržjint!’ ");
INSERT INTO ronBayash_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ju vă zăk: Kari ari u ave majmult, a heje kari nari čak šă haj pucăn šje ari u fi lot dă la jăl. ");
INSERT INTO ronBayash_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","A alu dužmanji amej kari nu gănđe să fjuv kralju alor, adušjecălji ajišje šă amurăcălji ăm oči amej!” ");
INSERT INTO ronBayash_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Kănd Isus u spus usporedbe, u mers maj pă dăparći pă kalje dă Jeruzalem. ");
INSERT INTO ronBayash_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Kănd Isus vinje mar apropi dă lok ăm Betfaga šă Betanija la planina dă maslinur, jăl u mănăt pă doj učenikur aluj ăm nenći. ");
INSERT INTO ronBayash_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Jăl u zăs: “Dušjec ăm sat ăm nenči. Kum vinjec ăm lok, voj vic afla pă magar pă kari njime no šăzut. Dăzljigăcăl šă adušjecăl la minji. ");
INSERT INTO ronBayash_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Dakă vu ăntriba šjinjiva: ‘Adišje ăl dăzljež?’, numa zăj: ‘Alu Domnu ăj trăbă.’” ");
INSERT INTO ronBayash_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Šă kari u fost mănată ur aflat točno kum jăl u zăs. ");
INSERT INTO ronBayash_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Čak šă kănd dăzljiga pă magar, gazdurlje u ăntribat: “Adišje dăzljigăc?” ");
INSERT INTO ronBayash_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Šă ănturšjala dă vorba are: “Alu Domnu ăj trăbă.” ");
INSERT INTO ronBayash_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Šă lu dus la Isus šă ur pus haljinurlje alor pă magar šă u pus pă Isus sus pă jăl să šadă. ");
INSERT INTO ronBayash_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Kum măržje jăl ăm nenći, lume punje haljinurlje alor pă driku hunđi prušule să đe čast alu Isus. ");
INSERT INTO ronBayash_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Šă baš kum vinje jăl apropi dă varuš hunđi planina dă maslinur să slăbođi žjos, toc učenici aluj sur apukat să kănći ăm mari fălušăjă, šă dăm tot graju slavale pă Dimizov dă kutotu mari čudur šje ur văzut. ");
INSERT INTO ronBayash_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Jej mužje: “Blagoslovulit să fijă kralj kari vinji ăm numilje alu Domnu! Putuljală ăm nor, šă slava alu Dimizov!” ");
INSERT INTO ronBayash_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Orikic dă farizej ăm gărmadă jur zăs: “Učitelju, zălji alu učenici atej să nu svitaskă aje.” ");
INSERT INTO ronBayash_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","A Isus lju zăs: “Dakă jej ur tăšje, petrilje sur apuka să mužjaskă ăm slavă.” ");
INSERT INTO ronBayash_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Kănd u vinjit Isus maj apropi la varuš su apukat să plăngă pă jej dasupra. ");
INSERT INTO ronBayash_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Atunšje jăl u zăs: “Să vi šćut numa ăstăs šje adušji putuljala ata! Aku ăj askunsă dă la oči atej. ");
INSERT INTO ronBayash_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Daje kă vinji vreme kănd dužmanji atej ur riđika falur pălăngă činji, jej čur opkululi šă čur ănkuje dăm totă parće. ");
INSERT INTO ronBayash_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Šă jej čur uništili pă činji do kraja šă kutotu šje kustă akulo šă no maj rămănje ăm činji njiš una petră pă alta petră, kutotu păntru aje kă nu aj prepoznulit vreme kănd Dimizov u vinjit la činji.” ");
INSERT INTO ronBayash_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Isus u mers ăm Hram, šă su apukat să lji măji afară pă eje kari vinđe šă kumpăra ăm nontru. ");
INSERT INTO ronBayash_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Jăl u zăs alor: “Skris ăj ăm svăntă kenvija: ‘Kasa ame u fi kasa dă aruguminći’ ali voj ac făkut ‘špiljă dă pljačkaš!’ ” ");
INSERT INTO ronBayash_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Dă zuva Isus ănvăca ăm Hram, a mar popur šă učitelji dă zakonu alu Mojsije šă alci vođur kari as re židovur planărze să ăl amori pă jăl. ");
INSERT INTO ronBayash_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ali jej nor aflat njimika kum ar fašji aje, daje kă lume să cănje apropi dă jăl, šă punje tari ureći la vorbilje aluj. ");
INSERT INTO ronBayash_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Mar popur, učitelji dă zakonu alu Mojsije šă alci vođur kari as re židovur ur vinjit la Isus ăm una ză kănd ănvăca pă lumi ăm Hram šă propovjedale Hir fălos. ");
INSERT INTO ronBayash_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Jej lor ăntribat pă jăl: “Pă alu šinji autoritet fašj stvarurlješće? Šinji cu dat asta autoritet?” ");
INSERT INTO ronBayash_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jăl u zăs: “Lasăcămă pă minji să vă ăntreb una stvar šă ăj dă voj să ăm ănturšjec vorba: ");
INSERT INTO ronBayash_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Anume Dimizov u zăs alu Ivan să bučuzaskă pă ominj, ili ominji u zăs aje să fakă?” ");
INSERT INTO ronBayash_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Jej ur svătit una ku alt šă zăšje: “Dăkă anj zăšji ‘dă la Dimizov’, u ăntriba: ‘Adăšje atunšje nu ănkriđec?’ ");
INSERT INTO ronBayash_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ali dăkă anj zăšji noj: ‘Dă la ominj’, totă lume u vărlji petri pă noj să nji amori. Kă jej ăs uvjerilic kă Ivan are prorok.” ");
INSERT INTO ronBayash_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Aša jej u ăntors vorba kă jej nu šćije dă hunđi u vinjit autoritet să bučuzaskă. ");
INSERT INTO ronBayash_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Šă Isus u zăs: “Njiš ju nu vuj spunji ku alu šinji autoritet fak stvarurlješće.” ");
INSERT INTO ronBayash_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Isus su apukat să spujă usporedbă alu lume: “Are unu om kari u sămănat vinograd šă u lăsat ăm najam vinogradu alu šjeva ka ominji, šă jăl atunšje u fužjit dăm pămăntula pă maj lungă vremi. ");
INSERT INTO ronBayash_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kănd u vinjit vreme, jăl u mănat pă sluga la ominj ăm vinograd să ăj đe parće aluj dăm plodur kari jej duguvule aluj, ali ominji lor bătut šă lor mănat ku mănjilje golji. ");
INSERT INTO ronBayash_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Atunšje u mănat pă altu sluga ali šă pă jăl lor bătut, vređălit šă lor mănat ku mănjilje golji. ");
INSERT INTO ronBayash_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Jăl u ănšjirkat să măji pă treći sluga, ali šă pă jăl lor ranalit šă lor arukănt. ");
INSERT INTO ronBayash_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Gazda dă vinograd u zăs pă aje: ‘Šje să fak? Ju uj măna pă fišjoru amnjov plăkut. Dar kănd lu viđe pă jăl, pălăngă jăl ur ave respekt.’ ");
INSERT INTO ronBayash_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ali ominjije kănd lor văzut sur ligizit ăntri jej: ‘Jăl ăj nasljednik. Hajc să ăl amurănj aša nasljedstva aluj să nji rămăji anovă.’ ");
INSERT INTO ronBayash_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Atunšje lor dus afară dăm vinograd šă lor amurăt. Aku šje u fašji gazda dă vinograd? ");
INSERT INTO ronBayash_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Jăl u vinji šă u uništili pă ominjije. Šă u da ăm najam vinogradu alu alci.” Kănd u auzăt jej aje kum ominji urăt să ponašalešči, jej ur zăs: “Nu đe Dimizov!” ");
INSERT INTO ronBayash_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jăl su ujtat pă jej, šă u zăs: “Skris ăj svăntă kenvija: ‘Petră kari graditelji u vărljit ăndărăt u fost aku petră zaglavnă?’ Šje značalešći asta? ");
INSERT INTO ronBayash_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Toc kari kađi pă petre u fi zdrubit pă dărăbelji, šă toc pă kari kađi u fi zdrubic.” ");
INSERT INTO ronBayash_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Učitelji dă zakonu alu Mojsije šă mar popur ur ănšjirkat să pujă mănjilje pă jăl ăm ala šas ali alor lji frikă dă lumi. Jej ur prišjiput kă jăl u spus dă asta usporedbă protiv dă jej. ");
INSERT INTO ronBayash_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Popi šă alci vođur ăl pratale pă Isus šă or mănat pă špijunj, ominj kari trišje ka ominj đirepc kari ar trăbuji să ăl optužulaskă pă Isus ăm šjeva šje ar zăšji krivo aša să ăl adukă pă Isus ăm mănjilje dă upravitelj alu Rim. ");
INSERT INTO ronBayash_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Aša lor ăntribat pă jăl: “Učitelju, noj ščijenj kă aje šje zăšj šă ănvec ăj točno, šă kă nu arec njiš šefălj parći, ali tu ănvacă anume kalje lu Dimizov. ");
INSERT INTO ronBayash_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Aku ăj benji dă noj židovur să plăčenj porez lu car ili nu?” ");
INSERT INTO ronBayash_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Isus u shvatalit kum jej as re lukavi šă lju zăs alor: ");
INSERT INTO ronBayash_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Arătam banji ku kari plăčešč porezu. Aku alu šjinji ăj ubrazu šă numilje sus?” Jej ur zăs: “Alu car.” ");
INSERT INTO ronBayash_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","“Atunšje plăčec alu car šje ăj pripadalešći lu car šă dăđec lu Dimizov šje pripadalešći alu Dimizov!” ");
INSERT INTO ronBayash_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Jej nu puće să aflji njimika rov ăm svatu aluj ăntri toc lumi, šă jej asre ămirac la ănturšjala dă vorba aluj, šă u tăkut. ");
INSERT INTO ronBayash_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Aku orikic saduceji kari zăšji kă njime nu su skula dăm morc ur vinjit la jăl, ku trik ăntribală: ");
INSERT INTO ronBayash_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Jej ur zăs: “Učitelju, Mojsije u pus žos zakon păntru noj kă dakă fračisu omuluj ar muri šă lasă pă băšăcaš făr dă kupij, atunšje fračisu aluj trăbă să u ămirići šă să răđišji familija păntru fračisu mort. ");
INSERT INTO ronBayash_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Undată asre šapči frac. Elši u lot băšăcă šă u murit făr dă kupij. ");
INSERT INTO ronBayash_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Šă drugi u lotu pă je, šă jăl u murit făr dă kupij. ");
INSERT INTO ronBayash_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Šă treći u lotu pă je. Maj toc šapči ur lotu šă ur murit, šă njiš unu no avut kupij ku je. ");
INSERT INTO ronBayash_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Pă zadnji šă mujere u murit. ");
INSERT INTO ronBayash_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Aku lu šjinji u fi băšăce kănd or uskrsnuli morci? Ăngănđeščići kă toc šapči ur avutu dă băšăcă.” ");
INSERT INTO ronBayash_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Isus u ăntors vorba alor: “Ăm asta svet lume să ămirită šă să ănsoră. ");
INSERT INTO ronBayash_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ali eje kari ur fost smatralic vredni să uskrsnulaskă dăm morc njiš nu su ănsura, njiš nu să ămirită. ");
INSERT INTO ronBayash_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Šă jej nu poći maj mult nikad să mori, kă jej ăs kupiji alu Dimizov daje kă ăs riđikac dăm morc. Jej ăs ka anđeji. ");
INSERT INTO ronBayash_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Atunšje dă uskrsnuće šă Mojsije u arătat aje ăm svedočulala aluj dă grmu šje arđe. Akulo jăl čamă pă Domnu alu Dimizovu lu Abraham, Dimizovu lu Izak, šă Dimizovu lu Jakov, multă dobă dă pă šje jej ur murit. ");
INSERT INTO ronBayash_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Anume, Dimizov nuj Dimizovu alu hej morc, mar alu hej kari kustă, kănd toc kustă păntru jăl.” ");
INSERT INTO ronBayash_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Šjeva ka učitelji dă zakonu alu Mojsije u priznalit: “Učitelju, tu aj svitit benji!” ");
INSERT INTO ronBayash_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Dă pă aje jej nu sor maj ăndurat să ăl ănšjeršji ku ăntribalur. ");
INSERT INTO ronBayash_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Isus u ăntribat: “Šje gănđešći jej kum svitešći dă Mesija kă ăj numa Fišjoru lu Car David? ");
INSERT INTO ronBayash_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","David dă jăl săngur ăm kenvije dă Psalmur zăšji: ‘Domnu u zăs alu Domnu amnjov: Šăz pă desna parće ame. ");
INSERT INTO ronBayash_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Šă ju uj vărlji pă dužmanji atej dăsup pišjorilje atelji.’  ");
INSERT INTO ronBayash_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","David jasno ăl čamă: ‘Domnu’, atunšje kum poći jăl să ăj fijă fišjor?” ");
INSERT INTO ronBayash_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Isus svite lu učenici aluj a totă lume punje ureći. ");
INSERT INTO ronBayash_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Jăl u zăs: “Je sama dă učitelji dă zakon alu Mojsije. Jej uživalešči să să šetalaskă ăm haljinur lunž šă să fijă pozdravalic ku poštovanje ăm varuš pă trgur šă jej plašji să šadă lokurlje časni ăm sinagogur šă pă nuntur. ");
INSERT INTO ronBayash_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Jej pljačkalešći pă udovicur ăm kăšălje alor, kănd fašji lunž aruguminći dă predstavă. Ali jej ur kăpăta maj gre kaznă.” ");
INSERT INTO ronBayash_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Kum su ujtat ăm sus Isus u văzut pă ominj găzdašj kum bagă banj ăm škatulă kari are ăm Hram. ");
INSERT INTO ronBayash_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Jăl u văzutu isto aša pă mujere vădojă kum u pus ăm nontru doj mišj banj dăm aržjint. ");
INSERT INTO ronBayash_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Isus u zăs: “Ju vă zăk anume, kă asta sărakă vădojă anume u dat maj mult dăm toc jej. ");
INSERT INTO ronBayash_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Adišje? Daje kă toc alci or dat dobrovoljni prilog lu Dimizov dăm aje šje ave mult kănd mujere u dat dăm sărăšijă šă kutotu šje ave dă kust.” ");
INSERT INTO ronBayash_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Kănd učenici svite dă Hram, šă zăšje kă ave măndri mar petri, šă are ukrasalit ku ukrasur kari ur dat ominji alu Dimizov, Isus u zăs: ");
INSERT INTO ronBayash_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“A dă ešće stvarur la šje vă ujtăc aku, zuva u vinji, kănd njiš una petră no rămănje ajiše una pă alta. Jelji ur fi toći vărljići žos.” ");
INSERT INTO ronBayash_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Jej lor ăntribat pă jăl: “Učitelju kănd u fi aje? Šă šefălj znakuvur ur fi kari ur zăšji kănd u fi?” ");
INSERT INTO ronBayash_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jăl u zăs: “Ujtăcăvă să nu fijec zăbunjic. Multă lumi ur vinji ăm numilje amnjov šă ur zăšji: ‘Ju mes Mesija’, šă ‘Vreme ăj apropi.’ Ali nu băgăc sama la jej. ");
INSERT INTO ronBayash_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Šă kănd auzăc dă tabărur šă dă nemirur nu fijec frikoš, kă ešće događajur trăbă să fijă elši ali kraj no vinji aša pă friš.” ");
INSERT INTO ronBayash_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jăl isto aša lju zăs: “Nacija sur boruli protiv dă nacija, šă kraljevstva protiv dă kraljevstva. ");
INSERT INTO ronBayash_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Šă u fi potresur pă različită lokur isto ka šă fome šă kugur. Šă pă nor ur fi frikoši stvarur dă văzut šă urăći znakur. ");
INSERT INTO ronBayash_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ali majnti dă šje u fi kutotu asta, šă vor apuka. Jej vur adušji ăm sinagogur la sud šă vor băga ăm čemicur. Jej vur trăje la kraljur šă la alci vladar daje kă ščec učenici amej. ");
INSERT INTO ronBayash_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Kutotu asta vu da šansă să svedočulec. ");
INSERT INTO ronBayash_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ali nu vă brigalec šje ac zăšji ăm nenći dă obrană. ");
INSERT INTO ronBayash_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Kă ju voj da ăm vreme firi šă mărđuljijă ăm aje meră dă njime no puće să să obranalaskă dă aje, ili să să bată protiv dă aje. ");
INSERT INTO ronBayash_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Šă voj vic fi izdalic, da čak šă dă la roditelji avoštri šă dă la frac šă dă la njam, urtašj, šă orikic dăm voj ur fi amurăc. ");
INSERT INTO ronBayash_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Toc vor mărzăli daje kă ščec učenici amej. ");
INSERT INTO ronBayash_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Tot njiš unu păr dă pă kapičilje avoštri nu vu piri. ");
INSERT INTO ronBayash_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Šă dăkă nu odustanalec vic kăpăta kust dă erikeš.” ");
INSERT INTO ronBayash_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Isus spunje: “Voj vic viđe Jeruzalem opkolulit dă kătănj, atunšje voj ac šći kă u fi uništen. ");
INSERT INTO ronBayash_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Atunšje eje ăm regija Judeja trăbă să skepi ăm planinur, eje kari kustă ăm varuš trăbă să fugă dă akulo šă heje păm satur să nu mergă ăm varuš. ");
INSERT INTO ronBayash_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kă ăm elje zălji dă osvetă kutotu stvarurlje dăm Kenvija svăntă sur umplje. ");
INSERT INTO ronBayash_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Jao alu elje kari ăs gărjonji ili rănješći pă căcă kupij ăm zăljilje kă bjeda šă mirgu protiv dă eje ominj u fi mari! ");
INSERT INTO ronBayash_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Orikic ur muri pă špica dă mač šă ostali ur fi zarobulic ăntră mulći nacijur. Jeruzalem u fi kălkat dă la ominji kari nus židovi păn šje nu lji trešji vreme dă vladalală.” ");
INSERT INTO ronBayash_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Isus spunje: “Akulo ur fi znakur, pă sori, lună šă pă šćevilje, šă ominji pă pămănt ur fi ăm mari nevoljur, dă graju mari dă valovur. ");
INSERT INTO ronBayash_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Sufljičilje ominjilor lu lăsa dă frikă dă ha šje tek u vinji pă svet kă silurlje dăm nor sur zdrănšjina. ");
INSERT INTO ronBayash_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Šă atunšje jej ur svedočuli kă ju am vinjit Fišjoru Omuluj pă oblak ku mari pučeri šă ku slavă. ");
INSERT INTO ronBayash_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kănd u fi asta ujtăcăvă sus šă răđikac kapičilje kă Dimizov vinji să vă oslobudulaskă.” ");
INSERT INTO ronBayash_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Isus lju spus usporedbă: “Băgăc sama la ljemnu dă smokvă, šă alčilje ljemnji! ");
INSERT INTO ronBayash_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kit să punji listur, voj viđec kă vara ăj apropi. ");
INSERT INTO ronBayash_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Isto aša kănd vi viđe asta kă u fi voj ac šći kă kraljevstva lu Dimizov ăj apropi. ");
INSERT INTO ronBayash_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Anume, ju pot zăšji: asta ominj kari kustă no fužji ăndărăt majnti dă šje kutotu asta no fi. ");
INSERT INTO ronBayash_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Norurlje šă pămăntu u trešji ăndărăt, ali vorbilje amelji nikad nor trešji.” ");
INSERT INTO ronBayash_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Isus u zăs: “Nu lăsa brigur ăm sufljituc dă mănkari, butură šă brigur dă asta kust, să nu vă dukă dă la Dimizov kă zuve poći să vijă ");
INSERT INTO ronBayash_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","dăm turdată. Kă u vinji pă toc bez obzira hunđi kustăc pă pămănt. ");
INSERT INTO ronBayash_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Păzăc dăm ala rănd pă toći vremilje. Šă arugăcăvă să fijec spremni să skăpăc dă kutotu asta šje u fi, šă să pučec să fijec ăm nenće ame la Fišjoru Omuluj făr dă frikă.” ");
INSERT INTO ronBayash_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ăm totă ză Isus ănvăca ăm Hram, ali nopće jăl fužje afară šă ăš făšje lok la planina dă maslinur. ");
INSERT INTO ronBayash_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ali dă điminjaca răkori, totă lume vinje să pujă ureći la jăl ăm Hram. ");
INSERT INTO ronBayash_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Are apropi Pasha, kari are elši ză dă blagdan dă pita făr dă kvas. ");
INSERT INTO ronBayash_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Mar popur šă učitelji dă zakonu alu Mojsije planărze kum ar puće să amori pă Isus ali alor lji are frikă dă lumi. ");
INSERT INTO ronBayash_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Atunšje Sotona u tunat ăm Juda Iskariot, kari are unu dăm dvanaest (12) apostola. ");
INSERT INTO ronBayash_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Jăl u mers šă su ligizit ku mar popur šă ku stražari dă Hram kum ar puće să ăl izdalaskă pă Isus. ");
INSERT INTO ronBayash_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Jej asre făloš dă aje šă sor ligizit ku Juda să ăj đe banj. ");
INSERT INTO ronBayash_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Juda su ligizit šă atunšje su ujtat dă prilikă să ăl izdalaskă pă jăl afară pă askuns făr dă lumi. ");
INSERT INTO ronBayash_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Zuva dă Pita făr dă kvas, u vinjit pă kalji birkuca pă Pashă a aje trăbuje să fijă žrtvovalită. ");
INSERT INTO ronBayash_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Aša Isus u mănat pă Petar šă pă Ivan šă lju zăs: “Dušjec šă pripremilec večera dă Pashă păntru noj să mănkănj.” ");
INSERT INTO ronBayash_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Jej lor ăntribat pă jăl: “Hunđi gănđešć să pripremilenj?” ");
INSERT INTO ronBayash_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jăl lju zăs alor: “Punjec ureći, kum vinjec ăm varuš, voj ac afla pă om kari dušji mari bukal dă apă. Sljedilecăl păn la kasa hunđi meržji. ");
INSERT INTO ronBayash_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Atunšje zăšjec lu kapu dă kasă: ‘Učitelju ăntrabă, Hunđi ăj soba ăm kari pot mănka večera dă Pashă ku učenici amej?’ ");
INSERT INTO ronBayash_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Jăl cu arăta atunšje soba sus pă kat mari šă opremilită ku kutotu. Făšjec pripremurlje akulo.” ");
INSERT INTO ronBayash_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Aša jej ur mers šă ur aflat stvarurlje kum Isus ljor zăs, šă jej ur făkut priprema dă večera pă Pashă. ");
INSERT INTO ronBayash_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kănd u vinjit vreme să mănăšji una, Isus šu lot lok la masă, šă ku jăl asre dvanaest (12) apostolur. ");
INSERT INTO ronBayash_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jăl u zăs: “Ju am avut mari vojă să am večera dă Pashă ku voj majnti dă šje uj patali ku morče. ");
INSERT INTO ronBayash_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ju vă zăk kă nikad maj mult nu uj mănka večera dă Pasha majnti dă šje nu su ispunuli ăm kraljevstva lu Dimizov.” ");
INSERT INTO ronBayash_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Atunšje u lot kljištaru ku vin šă u dat hvală alu Dimizov, šă u zăs: “Loc asta šă ămpărcăc ăntri voj. ");
INSERT INTO ronBayash_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ăm napoj, ju vă zăk, ju noj be dă plodu dă strugur păn šje no vinji kraljevstva lu Dimizov.” ");
INSERT INTO ronBayash_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Isus u lot pita, šă u dat hvală alu Dimizov, u rupt ăm dovă šă u dat la učenici aluj šă u zăs: “Asta ăj tela ame, kari u fost dată păntru voj. Făšjec asta ăm ăngănđală dă minji.” ");
INSERT INTO ronBayash_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Šă isto aša dă pă mănkari, jăl u lot kljištaru dăm kari toc ur be šă u zăs: “Asta kljištar ăj novi zavjet ăm sănžilje amnjov, kari ăj vărsat păntru voj. ");
INSERT INTO ronBayash_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ujtăcăvă kă izdajica ame ăj la masă apropi dă minji! ");
INSERT INTO ronBayash_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ju Fišjoru Omuluj uj muri kă aša are skris ăm nenći ali jao lu omula kari mu izdalit!” ");
INSERT INTO ronBayash_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Pă aje jej sor apukat să să ăntrebi una pă alt kari ar fašji aje. ");
INSERT INTO ronBayash_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Isto aša su apukat apostoli unu svat ăntri jej, ka šjinji ar trăbuji să fijă maj mari ăntră jej. ");
INSERT INTO ronBayash_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Aša Isus u zăs: “Kraljevi dă asta svet vladalešći ku narodu pă koristu alor šă ari pučeri pă jej, šă jej săngur zăšji kă fašji benji. ");
INSERT INTO ronBayash_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ali nu ăj aša ku voj! Lasăc pă maj mari dăm voj să fijă hăl maj ponizni, a hăl maj bătărn ka sluga. ");
INSERT INTO ronBayash_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Aku šjinji ăj maj mari, gostu la masă ili poslužitelju kari ăj sluga? Hăl kari ăj la masă da nu? Ali ujtăći, ju mes ajišje ku voj ali ka sluga avostru. ");
INSERT INTO ronBayash_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Voj ac rămas ku minji păm ănšjirkalurlje amelji. ");
INSERT INTO ronBayash_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kum mu dat Tata amnjov kraljevstva mijă, aša isto, ju voj da avovă, ");
INSERT INTO ronBayash_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","pravo să mănkăc šă să bijec la masa ame ăm kraljevstva ame, šă să šăđec pă prijestolje, să sudulec pă dvanaest plemurlje dă Izrael.” ");
INSERT INTO ronBayash_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Isus u zăs: “Šă tu Šimun, Šimun, punji ureći! Sotona u šjirut dopuštenje să vă iskušulaskă ka pă pšenică ăm sito. ");
INSERT INTO ronBayash_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ali ju mam arugat păntru činji, dă ănkriđala ata să nu kadă. Šă tu trăbă să ămbălurec ăm vjeră pă fraci atej kănd vij ăm napoj la minji.” ");
INSERT INTO ronBayash_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Petar u zăs: “Domnje ju mes spreman să mă duk ăm čemică šă să mor ku činji!” ");
INSERT INTO ronBayash_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Isus u ăntors vorba: “Lasă mă să ac zăk kă kukošu no kukuruzu astăs majnti dă šje tu mi tăgădi ăm tri răndur kă nu mă kunošć.” ");
INSERT INTO ronBayash_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Isus jară lju ăntribat: “Kănd vam mănat afară făr dă đibularuš šă făr dă tăšč, ili cipiliš, arec ăm šjeva ka potreba?” Jej u zăs: “Nu.” ");
INSERT INTO ronBayash_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ali jăl u svătit: “Maj mejnkulo, dakă avec đibularuš jec ku voj, šă isto aša šă taška šă dakă nu aj mač vinđi šubac šă kumpără mač. ");
INSERT INTO ronBayash_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kă sigurno trăbă să să ispunulaskă šje are skris dă minji, anume: ‘Jăl are smatralit dă zločinac’–isto šje u zăs proroci dă minji trăbă să să ispunulaskă.” ");
INSERT INTO ronBayash_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Atunšje jej ur zăs: “Ujtăći Domnje, noj avenj doj mačur.” Jăl u ăntors vorba: “Aku ăj dăstul ku asta svat.” ");
INSERT INTO ronBayash_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Isus u mers aku la Planina dă maslinur, kum ave jăl običaj să fakă, šă učenici aluj ur vinjit ku jăl. ");
INSERT INTO ronBayash_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Kănd u vinjit jăl pă lok, jăl u zăs alor: “Arugăcăvă dă aje să nu kăđec ăm kušnjă!” ");
INSERT INTO ronBayash_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Jăl su maknulit ăndărăt dă la jej aša dă parči ka kum aj vărlji petră, šă u kăzut pă đinuc, šă să aruga. ");
INSERT INTO ronBayash_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Jăl u zăs: “Tata, dakă tu gănđešć je kljištarusta dă patnjă dă la minji! Jară nu fijă ame vojă mar ata fijă făkută!” ");
INSERT INTO ronBayash_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Atunšje anđalu dăm nor u vinjit šă lu ămbălurit pă jăl. ");
INSERT INTO ronBayash_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Kum are ăm mari mukur jăl šă maj tari să aruga. Šă znoju aluj su făkut ăm kapljicur, dă sănži kura pă pămănt. ");
INSERT INTO ronBayash_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Atunšje Isus su skulat dăm aruguminći šă u mers ăm napoj la apostoli aluj. Jăl lju aflat kum să kulka činjic dă žalji. ");
INSERT INTO ronBayash_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Aša jăl lju zăs: “Adăšje vă kulkăc? Skulăcăvă šă arugăcăvă să nu kăđec ăm kušnjă!” ");
INSERT INTO ronBayash_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Isus inka svite kănd ur vinjit mulc ominj. Jej ur vinjit dă pă jăl. Unu dăm jej are šă Juda unu dăm dvanaest (12) apostolur. Jăl u vinjit dă apropi la Isus šă lu surutat ăm ubraz. ");
INSERT INTO ronBayash_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ali Isus ju zăs aluj: “Juda, izdalešć pă minji, Fišjoru alu Omuluj, ku surutala?” ");
INSERT INTO ronBayash_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Apostoli kănd u văzut šje su dogodulit jej ur ăntribat: “Domnu, să nji băčenj ku mačurlje?” ");
INSERT INTO ronBayash_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Šă unu dăm jej u luvit ku maču pă sluga lu popa mari, šă ju tijet ureče. ");
INSERT INTO ronBayash_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Isus u zăs: “Dăstul, nu maj vă băčec!” Jăl u pus măna pă ureći šă lu iscjelilit. ");
INSERT INTO ronBayash_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Atunšje Isus u zăs lu mar popur šă lu straža dă Hram, šă lu bătărnji kari ur vinjit afară protiv dă jăl: “Ac vinjit ku mačur šă ku palicur ka pă buntovnik? ");
INSERT INTO ronBayash_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nikad nac răđikat njiš žježijtu protiv dă minji kănd arem ku voj ăm totă ză ăm Hram. Ali aku ăj vreme avostră šă să vladalaskă tama.” ");
INSERT INTO ronBayash_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Atunšje jej lor apukat pă Isus, lor dus ăndărăt šă lor dus la kasa la maj mari popă. Petar sljedile pă dăparči. ");
INSERT INTO ronBayash_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Fok ur făkut ăm sredina dă udvar, šă kum šăđe lume akulo, Petar u vinjit ăntri jej. ");
INSERT INTO ronBayash_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Una tănără sluškinja lu văzut kă šađi ăm lumina dă fok, u mucăt pă jăl tari šă u zăs dă pă aje: “Omusta are ku jăl isto.” ");
INSERT INTO ronBayash_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ali jăl u tăgădit šă u zăs: “Nu, ju nu mes. Ju nu ăl kunosk pă jăl!” ");
INSERT INTO ronBayash_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Nu mult dă pă aje altu om lu văzut šă u zăs: “Spunji! Tu ješć unu dăm jej!” Ali Petar u ăntors vorba: “Ju nu mes!” ");
INSERT INTO ronBayash_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Hunđiva unu šas dă pă aje altu om uporno tvrdăle: “Sigurno, asta om are ku jăl, kă jăl ăj Galilejac!” ");
INSERT INTO ronBayash_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ali Petar u zăs: “Ju nu šćuv dă šje svitešć!” Šă točno atunšje kănd inka svite, kukošu u kukuruzăt. ");
INSERT INTO ronBayash_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Domnu su ăntors šă su ujtat pă Petar. Šă vorbilje lu Domnuluj ur vinjit ăm napoj la Petar, kum u zăs jăl: “Majnti dă šje kukošu u kukuruză astăs tu mi tăgădi pă minji ăm tri răndur.” ");
INSERT INTO ronBayash_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Šă Petar u mers afară šă plăngănt tari. ");
INSERT INTO ronBayash_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ominji kari ăl păze pă Isus ăš făšje šjuf dăm jăl šă ăl băče. ");
INSERT INTO ronBayash_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Jej ur pus fljancă pă oč, ăl luve ăm ubraz šă să akăca dă jăl: “Ajde prorokulešći! Spunji nji šjinji ču luvit ăm ubraz?” ");
INSERT INTO ronBayash_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Šă jej alu Isus ur zăs maj mulći urăči vorbi. ");
INSERT INTO ronBayash_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Dă răkori ăm alta ză, bătărnji, una ku mar popur šă učitelji dă zakonu alu Mojsije, ur adus pă Isus ăm nenće dă sudu alor. ");
INSERT INTO ronBayash_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Jej ur zăs: “Spunjinji dakă ješć tu Krist.” Jăl u ăntors vorba: “Să vă spuj nu mac ănkređi, ");
INSERT INTO ronBayash_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","šă să vă ăntreb pă voj dă Krist, voj nu ac ăntoršji vorba. ");
INSERT INTO ronBayash_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Aku maj menkulo ju, Fišjoru alu Omuluj, uj fi ăm pučeri pă desna parći dă măna lu Dimizov.” ");
INSERT INTO ronBayash_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Šă jej toc ur zăs, “Atunšje tu ješć Fišjoru alu Dimizov?” Šă jăl u ăntors vorba: “Da baš kum zăšjec! Ju mes!” ");
INSERT INTO ronBayash_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Atunšje jej or zăs: “Šefălj dokazur maj mult nji trăbujă? Noj săngur anj auzăt dăm gura aluj!” ");
INSERT INTO ronBayash_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Toc kari as re dio dă sud sor skulat šă lor adus pă Isus la Pilat. ");
INSERT INTO ronBayash_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Šă jej sor apukat să adukă optužbur protiv dă jăl: “Noj anj aflat kum strikă pă lumi. Jăl u zabranalit să să plăčaskă porezu lu Caru dă Rim. Jăl tvrdălešći kă jăl ăj Krist Car.” ");
INSERT INTO ronBayash_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilat lu ăntribat: “Ješć tu Car dă Židov?” Isus u ăntors vorba: “Da kum aj zăs tu.” ");
INSERT INTO ronBayash_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilat u zăs atunšje lu mar popur šă lu gărmadă dă lumi, “Ju nam aflat njimika dă šje laš optužuli šă suduli.” ");
INSERT INTO ronBayash_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ali jej šă maj tari navalale: “Jăl bunulešći pă toc pă pămăntu anostru. Su apukat să ănveci ăm Galileja šă u vinjit ăm Jeruzalem.” ");
INSERT INTO ronBayash_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Kănd u auzăt Pilat kă să svitešći dă Galileja, jăl u ăntribat: “Ăj omusta dăm loku Galileja?” ");
INSERT INTO ronBayash_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Kum are informiran Isus pripadale alu autoritetu lu Herod, Pilat lu mănat la Herod kari are ăm Jeruzalem atunšje. ");
INSERT INTO ronBayash_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herod are fălos kă veđi pă Isus. Kă dă mult gănđe să ăl vadă pă Jăl daje kă u auzăt mult dă jăl, šă Herod să nadale kă lu viđe să fakă čudur. ");
INSERT INTO ronBayash_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herod svite mult, ăntriba mulći, ali nu ju fost ăntorsă njiš una vorba. ");
INSERT INTO ronBayash_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Mar popur šă učitelji dă zakonu alu Mojsije asre isto akulo šă jej ur zăs tari mar optužbur protiv dă Isus. ");
INSERT INTO ronBayash_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Atunšje Herod šă stražurlje aluj ăš făšje šodă dăm Isus šă ăl făšje bulănd. Jej lor ămbrăkat pă jăl ăm haljinur dă Car šă lor mănat la Pilat. ");
INSERT INTO ronBayash_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Šă ăm aje ză Pilat šă Herod kari asre dužmanj aku asre urtaš. ");
INSERT INTO ronBayash_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Atunšje Pilat u čimat una pă mar popur šă pă alci vođur kari as re židovi šă pă gărmadă dă lumi. ");
INSERT INTO ronBayash_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Jăl lju zăs: “Voj ac adus pă omusta kă bunule pă lumi ali ju vă uvjerălesk kă kănd ăl ispičem nam aflat njiš šefălj krivică am jăl. Jăl nu ăj duvină njiš dă una krivică dă šje ac optužulit. ");
INSERT INTO ronBayash_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Njiš Herod nu aflat njimik ăm jăl, kapu lu mănat ăm napoj la noj. Jăl no făkut njimika să zavredilaskă kaznă dă morči. ");
INSERT INTO ronBayash_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ju uj da să ăl bičalaskă benji benj šă luj slăbuză.” ");
INSERT INTO ronBayash_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ali jej ur mužjit ăm grupur tari, “Ăndărăt ku omusta! Noj gănđenj să ăl slăbož pă Baraba!” ");
INSERT INTO ronBayash_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Baraba are ăm čemică kă bunule pă lumi ăm Jeruzalem šă u amurăt.) ");
INSERT INTO ronBayash_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilat daje gănđe să slăbodă pă Isus šă aša lju svătit alor ăm napoj, ");
INSERT INTO ronBayash_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ali jej tot ur mužjit maj tari: “Punjecăl pă krušji! Punjecăl pă krušji!” ");
INSERT INTO ronBayash_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Atunšje po treći rănd, jăl lju svătit alor: “Adišje? Spunjecăm šje rov u făkut omusta? Ju nu pot afla njimik rov să zaslužulaskă morči. Aša luj dă să ăl bičalaskă šă atunšje lăsa să fugă.” ");
INSERT INTO ronBayash_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ali jej mužje šă maj tari, šă zahtjevale să ăl pujă pă krušji. Šă napokon jej ur kăpătat šje gănđe. ");
INSERT INTO ronBayash_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilat u dat zapovjed să să fakă kazna šje ur zahtjevalit jej. ");
INSERT INTO ronBayash_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Aša ăm tokmă ku zahtjevula, jăl u slăbuzăt dăm čemică pă om šje u răđikat bună šă u amurăt ali jăl u ăntors pă Isus la jej să ăl pujă pă krušji. ");
INSERT INTO ronBayash_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Šă kum lor dus ăndărăt pă Isus, jej ur apukat pă om šje să čima Šimun, dăm varušu Cirena, kari vinje akasă dăm sat. Jej ur pus krušje pă jăl să dukă ăm loku lu Isus. ");
INSERT INTO ronBayash_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Multă lumi ăl sljedile pă Isus šă mujer kari plănžje šă žalale pă jăl. ");
INSERT INTO ronBayash_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Isus su ăntors la jej šă lju zăs: “Mujerilje dăm Jeruzalem, nu plănžjec păntru minji, mar plănžjec păntru voj šă păntru kupiji avoštri. ");
INSERT INTO ronBayash_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kă anume u vinji vremi kănd ur zăšji lume, ‘Blagoslovulići ăs elje kari nikad no ar avut šă injimilje kari nikad nor purtat kupij šă căcălje kari nikad nor avut lapći ăm jelji!’ ");
INSERT INTO ronBayash_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Lume sor apuka atunšje să zăkă lu planinur: ‘Kăđec žos pă noj!’ šă lu đalur: ‘Astupăcănji!’ ");
INSERT INTO ronBayash_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kă dakă fašji dastafelji stvarur lu ljemnjilje verž, šje nar puće să peci uskat?” ");
INSERT INTO ronBayash_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Akulo asre isto doj alci, amăndoj kriminalci kari trăbă să fijă pus pă krušji să mori ku Isus una. ");
INSERT INTO ronBayash_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kănd ur vinjit pă loku šje să čima osu dă kap, jej lor apukat šă lor pus pă krušji, una ku doj kriminalci, unu pă desna, unu pă ljeva parće aluj. ");
INSERT INTO ronBayash_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Šă Isus u zăs: “Tata Dimizovu amnjov, jartălji kă jej nu šćijă šje fašji.” Šă vojnici ur skos kockă să să ămperci dăm coljilje aluj ăntri jej. ");
INSERT INTO ronBayash_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Lume stăće šă să ujta; šă vladarur asre akulo šă ăl răđe: “Jăl u spasalit pă alci. Aku dakă ăj Krist, akuljes dă la Dimizov, lasă să să spasalaskă săngur!” ");
INSERT INTO ronBayash_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Kătănjilje isto ăš făšje šjuf dăm jăl. Šă jej ur vinjit šă u ămbijet aluj ucăt. ");
INSERT INTO ronBayash_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Jej ur zăs: “Dakă ješć tu Caru dă Židov, spasaleščići pă činji săngur!” ");
INSERT INTO ronBayash_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Sus la kap are skris: “Asta ăj Caru dă Židov.” ");
INSERT INTO ronBayash_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Unu dăm eje kriminalc kari ăs re puš pă krušji ku Isus ăl vređile šă jăl u zăs: “Dakă ješć tu Krist, atunšje spasalešćići, šă pă noj isto!” ");
INSERT INTO ronBayash_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Altu kriminalac lu mužjit pă elši šă u zăs: “Nu ci frikă dă Dimizov? Tărpălešć ista kazna ka jăl. ");
INSERT INTO ronBayash_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Tu šă ju šćenj ista pravedno kaznalic. Noj anj kăpătat kaznă dă lukrurlje relji, ali omusta no făkut njimika.” ");
INSERT INTO ronBayash_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Atunšje ju zăs lu Isus: “Isuse, ăngănđeščići tu dă minji kănd vi vinji ăm kraljevstva ata.” ");
INSERT INTO ronBayash_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Isus ju zăs ăm ănturšjală dă vorba: “Anume, ju ăc zăk: astăs vi fi ku minji ăm Raj!” ");
INSERT INTO ronBayash_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kănd are hunđiva dămnjaza, are ăntunjerik ăntreg pămăntu păn ăm tri (3) šasur. ");
INSERT INTO ronBayash_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Sorilje are ăntunjerik, šă feringa ăm Hram su tijet pă pola. ");
INSERT INTO ronBayash_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Atunšje Isus u plăns ăm graj tari šă zăšje: “Tata ăm mănjilje atelji ju puj duhu amnjov.” Kănd u zăs Isus asta, jăl u murit. ");
INSERT INTO ronBayash_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Kănd u văzut asta kapetanu šje u fost, jăl u slavalit pă Dimizov kum u zăs: “Omusta are sigurno pravedan!” ");
INSERT INTO ronBayash_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Šă totă lume kari sor akuljes să vadă kum lor punji pă krušji, kănd ur văzut šje u fost, ur mers akasă šă ăš băče dă žalji čepturlje. ");
INSERT INTO ronBayash_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ali toc kari ăl kunušće pă jăl una ku mujerilje kari ur vinjit ku Isus dăm Galileja stăće šă să ujta dă dăparći. ");
INSERT INTO ronBayash_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Are om šje să čima Josip. Jăl are član dă mari sud dă židov. Bun om šă pravedan ");
INSERT INTO ronBayash_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","kari no dat pă prav la odlukurlje šje ur făkut ku Isus. Jăl are dăm Arimateja, unu varuš la Judeja šă are dăm unu kari aščipta să vijă kraljevstvo lu Dimizov. ");
INSERT INTO ronBayash_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Omusta u mers la Pilat šă lu ăntribat dakă poći kăpăta tela lu Isus. ");
INSERT INTO ronBayash_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Josip u lot žos pă Isus dă pă krušji šă lu ănvălit ăm plahtă. Šă lu pus ăm gropă šje are sklesalită dăm petră ăm kari inka njime no fost ăngrupată. ");
INSERT INTO ronBayash_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Zuva dă pripremă are šă zuva dă sămbăta vinje. ");
INSERT INTO ronBayash_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Mujerilje kari ur vinjit ku Isus dăm Galileja isto ăl sljedile. Jelji ur văzut gropa, šă kum are tela aluj postavalită. ");
INSERT INTO ronBayash_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Aša ur mers ăm napoj šă ur pripremilit uloj šă parfemur să ungă tela alu Isus, ali pă zuva dă sămbăta jej să odmarale dă pă zapovjed alu Mojsije. ");
INSERT INTO ronBayash_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Elši zuva dă săptămănă, are duminjika, tari dă điminjaca mujerilje ur mers la gropă, šă adušje uloj ku miros šje ur pripremilit. ");
INSERT INTO ronBayash_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Jej ur aflat petră kă u fost ăntorsă ăndărăt dă la gropă. ");
INSERT INTO ronBayash_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Kănd ur tunat jej nor aflat tela lu Domnu Isus. ");
INSERT INTO ronBayash_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Šă atunšje, kănd inka stăće akulo ăm šok, ujtăći! Doj ominj stăće lăngă jelji ăm colji šje svitlăze. ");
INSERT INTO ronBayash_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Mujerilje sur ănfrikušat tari, kapu sur poklonulit păn la pămănt ku ubrazu šă ominji ljor zăs: “Adišje kutăc pă om ăm kust ăntră ominj morc? ");
INSERT INTO ronBayash_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Jăl nuj ajiše. Jăl u uskrsnulit! Ăngănđecăvă šje vu zăs jăl kănd are inka ăm Galileja: ");
INSERT INTO ronBayash_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Trăbă ju Fišjoru Omuluj să fjuv dat ăm mănjilje lu ominji rej šă să mă puji pă krušji daje să uskrsnulaskă pă treća (3) ză.” ");
INSERT INTO ronBayash_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Atunšje jej sor ăngănđit dă vorbilje aluj. ");
INSERT INTO ronBayash_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Kănd sor ăntors dă la gropă kutotu asta ur spus alu jedanaest (11) apostolur šă alu toc. ");
INSERT INTO ronBayash_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Jelji as re Marija dăm varušu Magdala, Ivana šă Marija, mumăsa lu Jakov, kari u adus hiru la apostolur. ");
INSERT INTO ronBayash_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ali puvešče alu mujeriljelje lju su văzut alu apostolur kă svite bulunzemi, dă aša nu ljur ănkrizut. ");
INSERT INTO ronBayash_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ali Petar su skulat šă u aljirgat la gropă. Akulo u stat să să ujći ăm nontru, šă u văzut numa plahtă. Atunšje u mers ăm napoj hunđi are šă să ăntriba šje u fost aje. ");
INSERT INTO ronBayash_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ăm aje ista zuva doj (2) učenikur măržje ăm lok Emaus, jedanaest (11) kilometara dăm Jeruzalem. ");
INSERT INTO ronBayash_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Jej svite una ku alt šje u fost. ");
INSERT INTO ronBayash_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Atunšje kănd svite šă kănd să ăntriba dă kutotu aje, Isus săngur u vinjit šă umbla ku jej. ");
INSERT INTO ronBayash_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ali alu oči alor are uskratalit să nu ăl kunoskă pă Isus. ");
INSERT INTO ronBayash_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Isus lju ăntribat pă jej: “Šă šje raspravljalec aša iskreno kănd umblăc?” Šă jej or stat trišč. ");
INSERT INTO ronBayash_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Unu dăm jej, unu kari să čima Kleofa, ju ăntors vorba: “Ješć tu jedini stranac ăm Jeruzalem kari nu šćijă šje u fost ajiše ăm zadnji par zălji?” ");
INSERT INTO ronBayash_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Isus u ăntribat: “Šje u fost?” Jej ur ăntors vorba: “Dă kutotu šje su dogodulit ku Isus dăm Nazaret. Jăl are Prorok, om bălour ăm djelur, šă ăm vorbi ăm njenće lu Dimizov, šă la lumi. ");
INSERT INTO ronBayash_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Mar popur šă anoštri poglavarur lor dat să sudulaskă pă Isus pă morči, šă jej lur pus pă krušji! ");
INSERT INTO ronBayash_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Noj nji nadalenj kă ăj jăl ala unu kari u otkupili Izrael. Šă astăs ăj treća (3) zuva dă atunšje. ");
INSERT INTO ronBayash_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ali pă aje kutotu orikići mujer dăm grupa anostră nju iznenadalit benji benj. Dă răkori dă điminjacasta jelji ur mers la gropă. ");
INSERT INTO ronBayash_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Jelji nu ur aflat tela aluj, mar ur vinjit ăm napoj să nji zăkă kă ur văzut vizijă dă anđelj dă kari ur zăs kă Isus ăj ăm kust. ");
INSERT INTO ronBayash_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Orikic dăm grupa anostră ur mers la gropă să vadă šă ur aflat kum ur spus mujerilje ali nu lor văzut pă jăl.” ");
INSERT INTO ronBayash_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Šă Isus lju zăs: “O voj ominj bulănž šă ăm sufljičilje avoštri nu ščec spremni să ănkriđec šje ur zăs proroci! ");
INSERT INTO ronBayash_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Nar trăbuji Krist să patalaskă dă toći stvarurlješće šă atunšje Dimizov să ăl proslavalaskă?” ");
INSERT INTO ronBayash_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Jăl u spus maj menkulo šje are zăs dă jăl, ăm toći svănti kenvijur; su apukat ku Mojsije šă păm toc Proroci. ");
INSERT INTO ronBayash_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kănd ur vinjit dapropi ăm lok hunđi măržje, Isus su arătat ăm namjeră să mergă maj menkulo. ");
INSERT INTO ronBayash_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ali jej lor nagovorulit să rămăji. “Rămănji ku noj; mar ăj kasno. Zuva ăj mar gata.” Atunšje jăl u mers ăm nontru să rămăji ku jej. ");
INSERT INTO ronBayash_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Atunšje kănd are ku jej la masă, Isus u lot pită, u blagoslovulitu šă u rupt ăm dovă šă lju dat alor. ");
INSERT INTO ronBayash_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Aku oči alor puće să vadă, šă jej lor kunuskut, šă dă pă aje Isus u nestalit. ");
INSERT INTO ronBayash_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Šă jej ur zăs una la alt: “Nu nji arđe sufljičilje anoštri kănd svite jăl ku noj pă kalji, šă kănd nji objasnale jăl svăntă kenvijă?” ");
INSERT INTO ronBayash_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Atunšje jej sor skulat šă ur mers ăm napoj ăm Jeruzalem. Akulo ur aflat pă jedanaest (11) apostolur una pă kupă, šă pă orikic alci ku jej. ");
INSERT INTO ronBayash_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ešće ljor spus: “Domnu anume u uskrsnulit, šă su arătat la Šimun.” ");
INSERT INTO ronBayash_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Doj (2) učenikur ur spus šje ur păcăt pă kalji, šă kum lor kunuskut kănd u rupt pita. ");
INSERT INTO ronBayash_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Čak šă kănd svite dă aje šje ur păcăt, Isus stăće akulo ăntră jej šă jăl lju zăs: “Putuljală fijă ku voj!” ");
INSERT INTO ronBayash_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Jej as re zubunjic šă ănfrikušac kă jej gănđe kă veđi duh. ");
INSERT INTO ronBayash_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ali Isus u zăs: “Adišje vi frikă? Šă adăšje vinji sumnjur ăm sufljičilje avoštri? ");
INSERT INTO ronBayash_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ujtăcăvă la pišjorilje amelji šă la mănjilje amelji! Ujtăcăvă ju mes! Punjec mănjilje šă uvjerilecăvă, kă duh nari karnji šă osă kum viđec kum ju am.” ");
INSERT INTO ronBayash_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Kănd u zăs asta jăl lju arătat mănjilje šă pišjorilje. ");
INSERT INTO ronBayash_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ali dă fălušuja mari, jej inka nu ănkriđe, šă să čudule. Jăl lju zăs: “Avec ajiše šjeva dă mănkat?” ");
INSERT INTO ronBayash_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Jej jur dat aluj dărab dă pešći fript. ");
INSERT INTO ronBayash_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Isus u lot šă u mănkat ăm nenće alor. ");
INSERT INTO ronBayash_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Isus lju zăs: “Asta ăj aje šje ju vă svitem avovă kănd arem inka ku voj: kutotu stvarurlje kari dă minji as re skrišă ăm zakonu lu Mojsije, šă ăm kenvijurlje dă prorokur šă ăm Psalmur trăbuje să să ispunulaskă.” ");
INSERT INTO ronBayash_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Atunšje jăl lju dăsvăkut găndurlje alor să potă să prišjepi svăntă kenvija. ");
INSERT INTO ronBayash_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Jej u zăs: “Asta ăj skris ăm svăntă kenvijă: kă Krist trăbă să patalaskă šă să uskrsnulaskă dăm morc pă treća (3) ză. ");
INSERT INTO ronBayash_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Isto aša ănkăjală šă jirtala dă grehur ar trăbuji să fijă propovjedalići ăm numilje aluj alu toći nacijurlje aša Dimizov lju jirta grehurlje alor, šă să să apušji elši ku propovjed ăm Jeruzalem. ");
INSERT INTO ronBayash_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Voj ščec svedoci dă stvarurlješće. ");
INSERT INTO ronBayash_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Šă ju uj mănă žos pă voj Duh svănt šje Tata amnjov u igirit. Ali rămănjec ajiše ăm varuš păn šje nu vic fi ămbrăkac ku pučeri dă sus!” ");
INSERT INTO ronBayash_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Isus lju dus dă apropi ăm lok Betanija. Jăl u răđikat mănjilje ăm sus šă lju blagoslovulit pă jej. ");
INSERT INTO ronBayash_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Šă kănd lji blagoslovule pă jej, jăl u fost răđikat šă dus sus ăm nor. ");
INSERT INTO ronBayash_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Jej să klanjale la jăl, šă ku fulušuje mari sur ăntors ăm Jeruzalem, ");
INSERT INTO ronBayash_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","šă ăm Hram cijelo vreme ăl blagoslovule pă Dimizov. ");
ALTER TABLE ronBayash_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
