﻿USE sofia;
DROP TABLE IF EXISTS sofia.ron1924_vpl;
CREATE TABLE ron1924_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ron1924_vpl WRITE;
INSERT INTO ron1924_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Ла ынчепут, Думнезеу а фэкут черуриле ши пэмынтул. ");
INSERT INTO ron1924_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Пэмынтул ера пустиу ши гол; песте фаца адынкулуй де апе ера ынтунерик, ши Духул луй Думнезеу Се мишка пе дясупра апелор. ");
INSERT INTO ron1924_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Думнезеу а зис: „Сэ фие луминэ!” Ши а фост луминэ. ");
INSERT INTO ron1924_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Думнезеу а вэзут кэ лумина ера бунэ ши Думнезеу а деспэрцит лумина де ынтунерик. ");
INSERT INTO ron1924_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Думнезеу а нумит лумина зи, яр ынтунерикул л-а нумит ноапте. Астфел, а фост о сярэ ши апой а фост о диминяцэ: ачаста а фост зиуа ынтый. ");
INSERT INTO ron1924_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Думнезеу а зис: „Сэ фие о ынтиндере ынтре апе ши еа сэ деспартэ апеле де апе.” ");
INSERT INTO ron1924_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Ши Думнезеу а фэкут ынтиндеря, ши еа а деспэрцит апеле каре сунт дедесубтул ынтиндерий де апеле каре сунт дясупра ынтиндерий. Ши аша а фост. ");
INSERT INTO ron1924_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Думнезеу а нумит ынтиндеря чер. Астфел, а фост о сярэ ши апой а фост о диминяцэ: ачаста а фост зиуа а доуа. ");
INSERT INTO ron1924_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Думнезеу а зис: „Сэ се стрынгэ ла ун лок апеле каре сунт дедесубтул черулуй ши сэ се арате ускатул!” Ши аша а фост. ");
INSERT INTO ron1924_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Думнезеу а нумит ускатул пэмынт, яр грэмада де апе а нумит-о мэрь. Думнезеу а вэзут кэ лукрул ачеста ера бун. ");
INSERT INTO ron1924_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Апой Думнезеу а зис: „Сэ дя пэмынтул вердяцэ, ярбэ ку сэмынцэ, помь родиторь, каре сэ факэ род дупэ союл лор ши каре сэ айбэ ын ей сэмынца лор пе пэмынт.” Ши аша а фост. ");
INSERT INTO ron1924_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Пэмынтул а дат вердяцэ, ярбэ ку сэмынцэ дупэ союл ей ши помь каре фак род ши каре ышь ау сэмынца ын ей, дупэ союл лор. Думнезеу а вэзут кэ лукрул ачеста ера бун. ");
INSERT INTO ron1924_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Астфел, а фост о сярэ ши апой а фост о диминяцэ: ачаста а фост зиуа а трея. ");
INSERT INTO ron1924_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Думнезеу а зис: „Сэ фие ниште луминэторь ын ынтиндеря черулуй, ка сэ деспартэ зиуа де ноапте; ей сэ фие ниште семне каре сэ арате времуриле, зилеле ши аний ");
INSERT INTO ron1924_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ши сэ служяскэ де луминэторь ын ынтиндеря черулуй, ка сэ луминезе пэмынтул.” Ши аша а фост. ");
INSERT INTO ron1924_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Думнезеу а фэкут чей дой марь луминэторь, ши ануме: луминэторул чел май маре, ка сэ стэпыняскэ зиуа, ши луминэторул чел май мик, ка сэ стэпыняскэ ноаптя; а фэкут ши стелеле. ");
INSERT INTO ron1924_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Думнезеу й-а ашезат ын ынтиндеря черулуй, ка сэ луминезе пэмынтул, ");
INSERT INTO ron1924_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","сэ стэпыняскэ зиуа ши ноаптя ши сэ деспартэ лумина де ынтунерик. Думнезеу а вэзут кэ лукрул ачеста ера бун. ");
INSERT INTO ron1924_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Астфел, а фост о сярэ ши апой а фост о диминяцэ: ачаста а фост зиуа а патра. ");
INSERT INTO ron1924_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Думнезеу а зис: „Сэ мишуне апеле де вецуитоаре ши сэ збоаре пэсэрь дясупра пэмынтулуй пе ынтиндеря черулуй.” ");
INSERT INTO ron1924_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Думнезеу а фэкут пештий чей марь ши тоате вецуитоареле каре се мишкэ ши де каре мишунэ апеле, дупэ союриле лор; а фэкут ши орьче пасэре ынарипатэ дупэ союл ей. Думнезеу а вэзут кэ ерау буне. ");
INSERT INTO ron1924_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Думнезеу ле-а бинекувынтат ши а зис: „Крештець, ынмулцици-вэ ши умплець апеле мэрилор; сэ се ынмулцяскэ ши пэсэриле пе пэмынт.” ");
INSERT INTO ron1924_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Астфел а фост о сярэ ши апой а фост о диминяцэ: ачаста а фост зиуа а чинчя. ");
INSERT INTO ron1924_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Думнезеу а зис: „Сэ дя пэмынтул вецуитоаре дупэ союл лор; вите, тырытоаре ши фяре пэмынтешть дупэ союл лор.” Ши аша а фост. ");
INSERT INTO ron1924_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Думнезеу а фэкут фяреле пэмынтулуй дупэ союл лор, вителе дупэ союл лор ши тоате тырытоареле пэмынтулуй дупэ союл лор. Думнезеу а вэзут кэ ерау буне. ");
INSERT INTO ron1924_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Апой Думнезеу а зис: „Сэ фачем ом дупэ кипул Ностру, дупэ асемэнаря Ноастрэ; ел сэ стэпыняскэ песте пештий мэрий, песте пэсэриле черулуй, песте вите, песте тот пэмынтул ши песте тоате тырытоареле каре се мишкэ пе пэмынт.” ");
INSERT INTO ron1924_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Думнезеу а фэкут пе ом дупэ кипул Сэу, л-а фэкут дупэ кипул луй Думнезеу; парте бэрбэтяскэ ши парте фемеяскэ й-а фэкут. ");
INSERT INTO ron1924_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Думнезеу й-а бинекувынтат ши Думнезеу ле-а зис: „Крештець, ынмулцици-вэ, умплець пэмынтул ши супунеци-л ши стэпыниць песте пештий мэрий, песте пэсэриле черулуй ши песте орьче вецуитоаре каре се мишкэ пе пэмынт.” ");
INSERT INTO ron1924_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Ши Думнезеу а зис: „Ятэ кэ в-ам дат орьче ярбэ каре фаче сэмынцэ ши каре есте пе фаца ынтрегулуй пэмынт ши орьче пом каре аре ын ел род ку сэмынцэ: ачаста сэ фие храна воастрэ. ");
INSERT INTO ron1924_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Яр тутурор фярелор пэмынтулуй, тутурор пэсэрилор черулуй ши тутурор виетэцилор каре се мишкэ пе пэмынт, каре ау ын еле о суфларе де вяцэ, ле-ам дат ка хранэ тоатэ ярба верде.” Ши аша а фост. ");
INSERT INTO ron1924_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Думнезеу С-а уйтат ла тот че фэкусе ши ятэ кэ ерау фоарте буне. Астфел, а фост о сярэ ши апой а фост о диминяцэ: ачаста а фост зиуа а шася. ");
INSERT INTO ron1924_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Астфел ау фост сфыршите черуриле ши пэмынтул ши тоатэ оштиря лор. ");
INSERT INTO ron1924_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ын зиуа а шаптя, Думнезеу Шь-а сфыршит лукраря пе каре о фэкусе ши ын зиуа а шаптя С-а одихнит де тоатэ лукраря Луй пе каре о фэкусе. ");
INSERT INTO ron1924_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Думнезеу а бинекувынтат зиуа а шаптя ши а сфинцит-о, пентру кэ ын зиуа ачаста С-а одихнит де тоатэ лукраря Луй пе каре о зидисе ши о фэкусе. ");
INSERT INTO ron1924_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Ятэ история черурилор ши а пэмынтулуй, кынд ау фост фэкуте. ");
INSERT INTO ron1924_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Ын зиуа кынд а фэкут Домнул Думнезеу ун пэмынт ши черурь, ну ера ынкэ пе пэмынт ничун копэчел де кымп ши ничо ярбэ де пе кымп ну ынколця ынкэ, фииндкэ Домнул Думнезеу ну дэдусе ынкэ плоае пе пэмынт ши ну ера ничун ом ка сэ лукрезе пэмынтул. ");
INSERT INTO ron1924_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Чи ун абур се ридика де пе пэмынт ши уда тоатэ фаца пэмынтулуй. ");
INSERT INTO ron1924_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Домнул Думнезеу а фэкут пе ом дин цэрына пэмынтулуй, й-а суфлат ын нэрь суфларе де вяцэ, ши омул с-а фэкут астфел ун суфлет виу. ");
INSERT INTO ron1924_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Апой, Домнул Думнезеу а сэдит о грэдинэ ын Еден, спре рэсэрит, ши а пус аколо пе омул пе каре-л ынтокмисе. ");
INSERT INTO ron1924_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Домнул Думнезеу а фэкут сэ рэсарэ дин пэмынт тот фелул де помь плэкуць ла ведере ши бунь ла мынкаре ши помул веций ын мижлокул грэдиний ши помул куноштинцей бинелуй ши рэулуй. ");
INSERT INTO ron1924_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ун рыу ешя дин Еден ши уда грэдина, ши де аколо се ымпэрця ши се фэчя патру браце. ");
INSERT INTO ron1924_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Нумеле челуй динтый есте Писон; ел ынконжоарэ тоатэ цара Хавила, унде се гэсеште аур. ");
INSERT INTO ron1924_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Аурул дин цара ачаста есте бун; аколо се гэсеште ши беделион ши пятрэ де оникс. ");
INSERT INTO ron1924_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Нумеле рыулуй ал дойля есте Гихон; ел ынконжоарэ тоатэ цара Куш. ");
INSERT INTO ron1924_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Нумеле челуй де ал трейля есте Хидекел. Ел курӂе ла рэсэритул Асирией. Ал патруля рыу есте Еуфратул. ");
INSERT INTO ron1924_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Домнул Думнезеу а луат пе ом ши л-а ашезат ын грэдина Еденулуй ка с-о лукрезе ши с-о пэзяскэ. ");
INSERT INTO ron1924_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Домнул Думнезеу а дат омулуй порунка ачаста: „Поць сэ мэнынчь дупэ плэчере дин орьче пом дин грэдинэ, ");
INSERT INTO ron1924_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","дар дин помул куноштинцей бинелуй ши рэулуй сэ ну мэнынчь, кэч, ын зиуа ын каре вей мынка дин ел, вей мури негрешит.” ");
INSERT INTO ron1924_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Домнул Думнезеу а зис: „Ну есте бине ка омул сэ фие сингур; ам сэ-й фак ун ажутор потривит пентру ел.” ");
INSERT INTO ron1924_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Домнул Думнезеу а фэкут дин пэмынт тоате фяреле кымпулуй ши тоате пэсэриле черулуй ши ле-а адус ла ом, ка сэ вадэ кум аре сэ ле нумяскэ, ши орьче нуме пе каре-л дэдя омул фиекэрей вецуитоаре, ачела-й ера нумеле. ");
INSERT INTO ron1924_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Ши омул а пус нуме тутурор вителор, пэсэрилор черулуй ши тутурор фярелор кымпулуй, дар, пентру ом, ну с-а гэсит ничун ажутор каре сэ и се потривяскэ. ");
INSERT INTO ron1924_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Атунч, Домнул Думнезеу а тримис ун сомн адынк песте ом, ши омул а адормит; Домнул Думнезеу а луат уна дин коастеле луй ши а ынкис карня ла локул ей. ");
INSERT INTO ron1924_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Дин коаста пе каре о луасе дин ом, Домнул Думнезеу а фэкут о фемее ши а адус-о ла ом. ");
INSERT INTO ron1924_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ши омул а зис: „Ятэ ын сфыршит ачея каре есте ос дин оаселе меле ши карне дин карня мя! Еа се ва нуми ‘фемее’, пентру кэ а фост луатэ дин ом.” ");
INSERT INTO ron1924_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Де ачея ва лэса омул пе татэл сэу ши пе мама са ши се ва липи де неваста са, ши се вор фаче ун сингур труп. ");
INSERT INTO ron1924_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Омул ши неваста луй ерау амындой гой ши ну ле ера рушине. ");
INSERT INTO ron1924_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Шарпеле ера май ширет декыт тоате фяреле кымпулуй пе каре ле фэкусе Домнул Думнезеу. Ел а зис фемеий: „Оаре а зис Думнезеу ку адевэрат: ‘Сэ ну мынкаць дин тоць помий дин грэдинэ’?” ");
INSERT INTO ron1924_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Фемея а рэспунс шарпелуй: „Путем сэ мынкэм дин родул тутурор помилор дин грэдинэ. ");
INSERT INTO ron1924_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Дар, деспре родул помулуй дин мижлокул грэдиний, Думнезеу а зис: ‘Сэ ну мынкаць дин ел ши нич сэ ну вэ атинӂець де ел, ка сэ ну муриць.’” ");
INSERT INTO ron1924_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Атунч, шарпеле а зис фемеий: „Хотэрыт кэ ну вець мури, ");
INSERT INTO ron1924_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","дар Думнезеу штие кэ, ын зиуа кынд вець мынка дин ел, ви се вор дескиде окий ши вець фи ка Думнезеу, куноскынд бинеле ши рэул.” ");
INSERT INTO ron1924_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Фемея а вэзут кэ помул ера бун де мынкат ши плэкут де привит ши кэ помул ера де дорит ка сэ дескидэ куйва минтя. А луат деч дин родул луй ши а мынкат; а дат ши бэрбатулуй ей, каре ера лынгэ еа, ши бэрбатул а мынкат ши ел. ");
INSERT INTO ron1924_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Атунч ли с-ау дескис окий ла амындой; ау куноскут кэ ерау гой, ау кусут лаолалтэ фрунзе де смокин ши шь-ау фэкут шорцурь дин еле. ");
INSERT INTO ron1924_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Атунч ау аузит гласул Домнулуй Думнезеу, каре умбла прин грэдинэ ын рэкоаря зилей, ши омул ши неваста луй с-ау аскунс де Фаца Домнулуй Думнезеу принтре помий дин грэдинэ. ");
INSERT INTO ron1924_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Дар Домнул Думнезеу а кемат пе ом ши й-а зис: „Унде ешть?” ");
INSERT INTO ron1924_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ел а рэспунс: „Ць-ам аузит гласул ын грэдинэ ши мь-а фост фрикэ, пентру кэ ерам гол, ши м-ам аскунс.” ");
INSERT INTO ron1924_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ши Домнул Думнезеу а зис: „Чине ць-а спус кэ ешть гол? Ну кумва ай мынкат дин помул дин каре ыць порунчисем сэ ну мэнынчь?” ");
INSERT INTO ron1924_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Омул а рэспунс: „Фемея пе каре мь-ай дат-о ка сэ фие лынгэ мине, еа мь-а дат дин пом ши ам мынкат.” ");
INSERT INTO ron1924_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Ши Домнул Думнезеу а зис фемеий: „Че ай фэкут?” Фемея а рэспунс: „Шарпеле м-а амэӂит ши ам мынкат дин пом.” ");
INSERT INTO ron1924_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Домнул Думнезеу а зис шарпелуй: „Фииндкэ ай фэкут лукрул ачеста, блестемат ешть ынтре тоате вителе ши ынтре тоате фяреле де пе кымп; ын тоате зилеле веций тале, сэ те тырэшть пе пынтече ши сэ мэнынчь цэрынэ. ");
INSERT INTO ron1924_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Врэжмэшие вой пуне ынтре тине ши фемее, ынтре сэмынца та ши сэмынца ей. Ачаста ыць ва здроби капул, ши ту ый вей здроби кэлкыюл.” ");
INSERT INTO ron1924_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Фемеий й-а зис: „Вой мэри фоарте мулт суферинца ши ынсэрчинаря та; ку дурере вей наште копий, ши доринцеле тале се вор цине дупэ бэрбатул тэу, яр ел ва стэпыни песте тине.” ");
INSERT INTO ron1924_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Омулуй й-а зис: „Фииндкэ ай аскултат де гласул невестей тале ши ай мынкат дин помул деспре каре ыць порунчисем: ‘Сэ ну мэнынчь делок дин ел’, блестемат есте акум пэмынтул дин причина та. Ку мултэ трудэ сэ-ць скоць храна дин ел ын тоате зилеле веций тале; ");
INSERT INTO ron1924_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","спинь ши пэлэмидэ сэ-ць дя ши сэ мэнынчь ярба де пе кымп. ");
INSERT INTO ron1924_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ын судоаря фецей тале сэ-ць мэнынчь пыня пынэ те вей ынтоарче ын пэмынт, кэч дин ел ай фост луат; кэч цэрынэ ешть ши ын цэрынэ те вей ынтоарче.” ");
INSERT INTO ron1924_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Адам а пус невестей сале нумеле Ева, кэч еа а фост мама тутурор челор вий. ");
INSERT INTO ron1924_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Домнул Думнезеу а фэкут луй Адам ши невестей луй хайне де пеле ши й-а ымбрэкат ку еле. ");
INSERT INTO ron1924_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Домнул Думнезеу а зис: „Ятэ кэ омул а ажунс ка унул дин Ной, куноскынд бинеле ши рэул. Сэ-л ымпедикэм дар акум ка ну кумва сэ-шь ынтиндэ мына, сэ я ши дин помул веций, сэ мэнынче дин ел ши сэ трэяскэ ын вечь.” ");
INSERT INTO ron1924_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Де ачея, Домнул Думнезеу л-а изгонит дин грэдина Еденулуй ка сэ лукрезе пэмынтул, дин каре фусесе луат. ");
INSERT INTO ron1924_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Астфел а изгонит Ел пе Адам; ши ла рэсэритул грэдиний Еденулуй а пус ниште херувимь, каре сэ ынвыртяскэ о сабие ынвэпэятэ, ка сэ пэзяскэ друмул каре дуче ла помул веций. ");
INSERT INTO ron1924_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Адам с-а ымпреунат ку невастэ-са Ева; еа а рэмас ынсэрчинатэ ши а нэскут пе Каин. Ши а зис: „Ам кэпэтат ун ом ку ажуторул Домнулуй!” ");
INSERT INTO ron1924_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","А май нэскут ши пе фрателе сэу Абел. Абел ера чобан, яр Каин ера плугар. ");
INSERT INTO ron1924_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Дупэ о букатэ де време, Каин а адус Домнулуй о жертфэ де мынкаре дин роаделе пэмынтулуй. ");
INSERT INTO ron1924_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Абел а адус ши ел о жертфэ де мынкаре дин оиле ынтый нэскуте але турмей луй ши дин грэсимя лор. Домнул а привит ку плэчере спре Абел ши спре жертфа луй, ");
INSERT INTO ron1924_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","дар спре Каин ши спре жертфа луй н-а привит ку плэчере. Каин с-а мыният фоарте таре ши и с-а посоморыт фаца. ");
INSERT INTO ron1924_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ши Домнул а зис луй Каин: „Пентру че те-ай мыният ши пентру че ци с-а посоморыт фаца? ");
INSERT INTO ron1924_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ну-й аша? Дакэ фачь бине, вей фи бине примит, дар, дакэ фачь рэу, пэкатул пындеште ла ушэ; доринца луй се цине дупэ тине, дар ту сэ-л стэпынешть.” ");
INSERT INTO ron1924_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ынсэ Каин а зис фрателуй сэу Абел: „Хайдем сэ ешим ла кымп.” Дар, пе кынд ерау ла кымп, Каин с-а ридикат ымпотрива фрателуй сэу Абел ши л-а оморыт. ");
INSERT INTO ron1924_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Домнул а зис луй Каин: „Унде есте фрателе тэу Абел?” Ел а рэспунс: „Ну штиу. Сунт еу пэзиторул фрателуй меу?” ");
INSERT INTO ron1924_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ши Думнезеу а зис: „Че ай фэкут? Гласул сынӂелуй фрателуй тэу стригэ дин пэмынт ла Мине. ");
INSERT INTO ron1924_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Акум, блестемат ешть ту, изгонит дин огорул ачеста, каре шь-а дескис гура ка сэ примяскэ дин мына та сынӂеле фрателуй тэу! ");
INSERT INTO ron1924_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Кынд вей лукра пэмынтул, сэ ну-ць май дя богэция луй. Прибяг ши фугар сэ фий пе пэмынт.” ");
INSERT INTO ron1924_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Каин а зис Домнулуй: „Педяпса мя е пря маре ка с-о пот суфери. ");
INSERT INTO ron1924_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ятэ кэ Ту мэ изгонешть азь де пе фаца пэмынтулуй; еу ва требуи сэ мэ аскунд де Фаца Та ши сэ фиу прибяг ши фугар пе пэмынт, ши орьчине мэ ва гэси мэ ва оморы.” ");
INSERT INTO ron1924_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Домнул й-а зис: „Ничдекум, чи, дакэ ва оморы чинева пе Каин, Каин сэ фие рэзбунат де шапте орь.” Ши Домнул а хотэрыт ун семн пентру Каин, ка орьчине ыл ва гэси сэ ну-л омоаре. ");
INSERT INTO ron1924_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Апой, Каин а ешит дин Фаца Домнулуй ши а локуит ын цара Нод, ла рэсэрит де Еден. ");
INSERT INTO ron1924_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Каин с-а ымпреунат ку невастэ-са; еа а рэмас ынсэрчинатэ ши а нэскут пе Енох. Ел а ынчепут апой сэ зидяскэ о четате ши а пус ачестей четэць нумеле фиулуй сэу Енох. ");
INSERT INTO ron1924_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Енох а фост татэл луй Ирад; Ирад а фост татэл луй Мехуиаел; Мехуиаел а фост татэл луй Метушаел ши Метушаел а фост татэл луй Ламех. ");
INSERT INTO ron1924_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Ламех шь-а луат доуэ невесте: нумеле унея ера Ада ши нумеле челейлалте ера Цила. ");
INSERT INTO ron1924_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ада а нэскут пе Иабал: ел а фост татэл челор че локуеск ын кортурь ши пэзеск вителе. ");
INSERT INTO ron1924_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Нумеле фрателуй сэу ера Иубал: ел а фост татэл тутурор челор че кынтэ ку алэута ши ку кавалул. ");
INSERT INTO ron1924_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Цила, де партя ей, а нэскут ши еа пе Тубал-Каин, фэуриторул тутурор унелтелор де арамэ ши де фер. Сора луй Тубал-Каин ера Наама. ");
INSERT INTO ron1924_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Ламех а зис невестелор сале: „Ада ши Цила, аскултаць гласул меу! Невестеле луй Ламех, аскултаць кувынтул меу! Ам оморыт ун ом пентру рана мя Ши ун тынэр пентру вынэтэиле меле. ");
INSERT INTO ron1924_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Каин ва фи рэзбунат де шапте орь, Яр Ламех, де шаптезечь де орь кыте шапте.” ");
INSERT INTO ron1924_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Адам с-а ымпреунат ярэшь ку невастэ-са; еа а нэскут ун фиу ши й-а пус нумеле Сет; „кэч”, а зис еа, „Думнезеу мь-а дат о алтэ сэмынцэ ын локул луй Абел, пе каре л-а учис Каин”. ");
INSERT INTO ron1924_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Луй Сет и с-а нэскут ши луй ун фиу ши й-а пус нумеле Енос. Атунч ау ынчепут оамений сэ кеме Нумеле Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Ятэ картя нямурилор луй Адам. Ын зиуа кынд а фэкут Думнезеу пе ом, л-а фэкут дупэ асемэнаря луй Думнезеу. ");
INSERT INTO ron1924_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Й-а фэкут парте бэрбэтяскэ ши парте фемеяскэ, й-а бинекувынтат ши ле-а дат нумеле де „ом” ын зиуа кынд ау фост фэкуць. ");
INSERT INTO ron1924_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Ла вырста де о сутэ трейзечь де ань, Адам а нэскут ун фиу дупэ кипул ши асемэнаря луй ши й-а пус нумеле Сет. ");
INSERT INTO ron1924_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Дупэ наштеря луй Сет, Адам а трэит опт суте де ань ши а нэскут фий ши фийче. ");
INSERT INTO ron1924_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Тоате зилеле пе каре ле-а трэит Адам ау фост де ноуэ суте трейзечь де ань, апой а мурит. ");
INSERT INTO ron1924_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Ла вырста де о сутэ чинч ань, Сет а нэскут пе Енос. ");
INSERT INTO ron1924_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Дупэ наштеря луй Енос, Сет а май трэит опт суте шапте ань ши а нэскут фий ши фийче. ");
INSERT INTO ron1924_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Тоате зилеле луй Сет ау фост де ноуэ суте дойспрезече ань, апой а мурит. ");
INSERT INTO ron1924_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Ла вырста де ноуэзечь де ань, Енос а нэскут пе Каинан. ");
INSERT INTO ron1924_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Дупэ наштеря луй Каинан, Енос а май трэит опт суте чинчспрезече ань ши а нэскут фий ши фийче. ");
INSERT INTO ron1924_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Тоате зилеле луй Енос ау фост де ноуэ суте чинч ань, апой а мурит. ");
INSERT INTO ron1924_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Ла вырста де шаптезечь де ань, Каинан а нэскут пе Махалалеел. ");
INSERT INTO ron1924_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Дупэ наштеря луй Махалалеел, Каинан а май трэит опт суте патрузечь де ань ши а нэскут фий ши фийче. ");
INSERT INTO ron1924_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Тоате зилеле луй Каинан ау фост де ноуэ суте зече ань, апой а мурит. ");
INSERT INTO ron1924_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Ла вырста де шайзечь ши чинч де ань, Махалалеел а нэскут пе Иаред. ");
INSERT INTO ron1924_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Дупэ наштеря луй Иаред, Махалалеел а май трэит опт суте трейзечь де ань ши а нэскут фий ши фийче. ");
INSERT INTO ron1924_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Тоате зилеле луй Махалалеел ау фост де опт суте ноуэзечь ши чинч де ань, апой а мурит. ");
INSERT INTO ron1924_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Ла вырста де о сутэ шайзечь ши дой де ань, Иаред а нэскут пе Енох. ");
INSERT INTO ron1924_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Дупэ наштеря луй Енох, Иаред а май трэит опт суте де ань ши а нэскут фий ши фийче. ");
INSERT INTO ron1924_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Тоате зилеле луй Иаред ау фост де ноуэ суте шайзечь ши дой де ань, апой а мурит. ");
INSERT INTO ron1924_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Ла вырста де шайзечь ши чинч де ань, Енох а нэскут пе Метусала. ");
INSERT INTO ron1924_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Дупэ наштеря луй Метусала, Енох а умблат ку Думнезеу трей суте де ань ши а нэскут фий ши фийче. ");
INSERT INTO ron1924_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Тоате зилеле луй Енох ау фост трей суте шайзечь ши чинч де ань. ");
INSERT INTO ron1924_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Енох а умблат ку Думнезеу, апой ну с-а май вэзут, пентру кэ л-а луат Думнезеу. ");
INSERT INTO ron1924_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Ла вырста де о сутэ оптзечь ши шапте де ань, Метусала а нэскут пе Ламех. ");
INSERT INTO ron1924_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Дупэ наштеря луй Ламех, Метусала а май трэит шапте суте оптзечь ши дой де ань ши а нэскут фий ши фийче. ");
INSERT INTO ron1924_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Тоате зилеле луй Метусала ау фост де ноуэ суте шайзечь ши ноуэ де ань, апой а мурит. ");
INSERT INTO ron1924_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Ла вырста де о сутэ оптзечь ши дой де ань, Ламех а нэскут ун фиу. ");
INSERT INTO ron1924_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Ел й-а пус нумеле Ное, зикынд: „Ачеста не ва мынгыя пентру остеняла ши труда мынилор ноастре, каре вин дин ачест пэмынт, пе каре л-а блестемат Домнул.” ");
INSERT INTO ron1924_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Дупэ наштеря луй Ное, Ламех а май трэит чинч суте ноуэзечь ши чинч де ань ши а нэскут фий ши фийче. ");
INSERT INTO ron1924_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Тоате зилеле луй Ламех ау фост де шапте суте шаптезечь ши шапте де ань, апой а мурит. ");
INSERT INTO ron1924_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Ное, ла вырста де чинч суте де ань, а нэскут пе Сем, Хам ши Иафет. ");
INSERT INTO ron1924_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Кынд ау ынчепут оамений сэ се ынмулцяскэ пе фаца пэмынтулуй ши ли с-ау нэскут фете, ");
INSERT INTO ron1924_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","фиий луй Думнезеу ау вэзут кэ фетеле оаменилор ерау фрумоасе ши дин тоате шь-ау луат де невесте пе ачеля пе каре ши ле-ау алес. ");
INSERT INTO ron1924_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Атунч, Домнул а зис: „Духул Меу ну ва рэмыне пуруря ын ом, кэч омул ну есте декыт карне пэкэтоасэ; тотушь, зилеле луй вор фи де о сутэ доуэзечь де ань.” ");
INSERT INTO ron1924_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Уриаший ерау пе пэмынт ын времуриле ачеля ши кяр ши дупэ че с-ау ымпреунат фиий луй Думнезеу ку фетеле оаменилор ши ле-ау нэскут еле копий; ачештя ерау витежий каре ау фост ын векиме, оамень ку нуме. ");
INSERT INTO ron1924_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Домнул а вэзут кэ рэутатя омулуй ера маре пе пэмынт ши кэ тоате ынтокмириле гындурилор дин инима луй ерау ындрептате ын фиекаре зи нумай спре рэу. ");
INSERT INTO ron1924_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Й-а пэрут рэу Домнулуй кэ а фэкут пе ом пе пэмынт ши С-а мыхнит ын инима Луй. ");
INSERT INTO ron1924_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Ши Домнул а зис: „Ам сэ штерг де пе фаца пэмынтулуй пе омул пе каре л-ам фэкут, де ла ом пынэ ла вите, пынэ ла тырытоаре ши пынэ ла пэсэриле черулуй, кэч Ымь паре рэу кэ й-ам фэкут.” ");
INSERT INTO ron1924_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Дар Ное а кэпэтат милэ ынаинтя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Ятэ каре сунт урмаший луй Ное. Ное ера ун ом неприхэнит ши фэрэ патэ ынтре чей дин время луй: Ное умбла ку Думнезеу. ");
INSERT INTO ron1924_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Ное а нэскут трей фий: Сем, Хам ши Иафет. ");
INSERT INTO ron1924_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Пэмынтул ера стрикат ынаинтя луй Думнезеу; пэмынтул ера плин де силничие. ");
INSERT INTO ron1924_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Думнезеу С-а уйтат спре пэмынт ши ятэ кэ пэмынтул ера стрикат, кэч орьче фэптурэ ышь стрикасе каля пе пэмынт. ");
INSERT INTO ron1924_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Атунч, Думнезеу а зис луй Ное: „Сфыршитул орькэрей фэптурь есте хотэрыт ынаинтя Мя, фииндкэ ау умплут пэмынтул де силничие; ятэ, ам сэ-й нимическ ымпреунэ ку пэмынтул. ");
INSERT INTO ron1924_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Фэ-ць о корабие дин лемн де гофер (кипарос); корабия ачаста с-о ымпарць ын кэмэруце ши с-о тенкуешть ку смоалэ пе динэунтру ши пе динафарэ. ");
INSERT INTO ron1924_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ятэ кум с-о фачь: корабия сэ айбэ трей суте де коць ын лунӂиме, чинчзечь де коць ын лэциме ши трейзечь де коць ын ынэлциме. ");
INSERT INTO ron1924_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Сэ фачь корабией о ферястрэ, сус, латэ де ун кот; уша с-о пуй ын латура корабией ши сэ фачь ун рынд де кэмэрь жос, алтул ла мижлок ши алтул сус. ");
INSERT INTO ron1924_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Ши ятэ кэ Еу ам сэ фак сэ винэ ун потоп де апе пе пэмынт, ка сэ нимичяскэ орьче фэптурэ де суб чер каре аре суфларе де вяцэ; тот че есте пе пэмынт ва пери. ");
INSERT INTO ron1924_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Дар ку тине фак ун легэмынт: сэ интри ын корабие, ту ши фиий тэй, невастэ-та ши невестеле фиилор тэй ымпреунэ ку тине. ");
INSERT INTO ron1924_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Дин тот че трэеште, дин орьче фэптурэ, сэ ей ын корабие кыте доуэ дин фиекаре сой, ка сэ ле ций вий ку тине: сэ фие о парте бэрбэтяскэ ши о парте фемеяскэ. ");
INSERT INTO ron1924_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Дин пэсэрь дупэ союл лор, дин вите дупэ союл лор ши дин тоате тырытоареле де пе пэмынт дупэ союл лор, сэ винэ ла тине ынэунтру кыте доуэ дин фиекаре сой, ка сэ ле ций ку вяцэ. ");
INSERT INTO ron1924_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ши ту я-ць дин тоате букателе каре се мэнынкэ ши фэ-ць меринде дин еле, ка сэ-ць служяскэ де хранэ цие ши лор.” ");
INSERT INTO ron1924_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Аша а ши фэкут Ное: а фэкут тот че-й порунчисе Думнезеу. ");
INSERT INTO ron1924_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Домнул а зис луй Ное: „Интрэ ын корабие, ту ши тоатэ каса та, кэч те-ам вэзут фэрэ приханэ ынаинтя Мя ын нямул ачеста де оамень. ");
INSERT INTO ron1924_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Я ку тине кыте шапте перекь дин тоате добитоачеле курате, кыте о парте бэрбэтяскэ ши кыте о парте фемеяскэ; о переке дин добитоачеле каре ну сунт курате, кыте о парте бэрбэтяскэ ши кыте о парте фемеяскэ, ");
INSERT INTO ron1924_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","ши кыте шапте перекь, де асеменя, дин пэсэриле черулуй, кыте о парте бэрбэтяскэ ши кыте о парте фемеяскэ, пентру ка сэ ле ций вие сэмынца пе тоатэ фаца пэмынтулуй. ");
INSERT INTO ron1924_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Кэч, дупэ шапте зиле, вой фаче сэ плоуэ пе пэмынт патрузечь де зиле ши патрузечь де нопць ши вой штерӂе астфел де пе фаца пэмынтулуй тоате фэптуриле пе каре ле-ам фэкут.” ");
INSERT INTO ron1924_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ное а фэкут тот че-й порунчисе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Ное ера де шасе суте де ань кынд а венит потопул пе пэмынт. ");
INSERT INTO ron1924_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Ши Ное а интрат ын корабие ку фиий сэй, ку невастэ-са ши ку невестеле фиилор сэй, дин причина апелор потопулуй. ");
INSERT INTO ron1924_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Дин добитоачеле курате ши дин добитоачеле некурате, дин пэсэрь ши дин тот че се тырэште пе пэмынт, ");
INSERT INTO ron1924_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","ау интрат ын корабие ла Ное, доуэ кыте доуэ, кыте о парте бэрбэтяскэ ши кыте о парте фемеяскэ, аша кум порунчисе Думнезеу луй Ное. ");
INSERT INTO ron1924_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Дупэ челе шапте зиле, ау венит апеле потопулуй пе пэмынт. ");
INSERT INTO ron1924_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Ын анул ал шасе сутеля ал веций луй Ное, ын луна а доуа, ын зиуа а шаптеспрезечя а луний, ын зиуа ачея, с-ау рупт тоате извоареле адынкулуй челуй маре ши с-ау дескис стэвилареле черурилор. ");
INSERT INTO ron1924_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Плоая а кэзут пе пэмынт патрузечь де зиле ши патрузечь де нопць. ");
INSERT INTO ron1924_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ын ачеяшь зи ау интрат ын корабие: Ное, Сем, Хам ши Иафет, фиий луй Ное, неваста луй Ное ши челе трей невесте але фиилор луй ку ей; ");
INSERT INTO ron1924_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","ей ши тоате фяреле кымпулуй дупэ союл лор, тоате вителе дупэ союл лор, тоате тырытоареле каре се тырэск пе пэмынт дупэ союл лор, тоате пэсэриле дупэ союл лор, тоате пэсэрелеле, тот че аре арипь. ");
INSERT INTO ron1924_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Ау интрат ын корабие ла Ное, доуэ кыте доуэ, дин орьче фэптурэ каре аре суфларе де вяцэ. ");
INSERT INTO ron1924_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Челе каре ау интрат ерау кыте о парте бэрбэтяскэ ши кыте о парте фемеяскэ, дин орьче фэптурэ, дупэ кум порунчисе Думнезеу луй Ное. Апой, Домнул а ынкис уша дупэ ел. ");
INSERT INTO ron1924_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Потопул а фост патрузечь де зиле пе пэмынт. Апеле ау крескут ши ау ридикат корабия, ши еа с-а ынэлцат дясупра пэмынтулуй. ");
INSERT INTO ron1924_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Апеле ау ажунс марь ши ау крескут фоарте мулт пе пэмынт, ши корабия плутя пе дясупра апелор. ");
INSERT INTO ron1924_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Апеле ау ажунс дин че ын че май марь ши тоць мунций ыналць, каре сунт суб черул ынтрег, ау фост акопериць. ");
INSERT INTO ron1924_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Ку чинчспрезече коць с-ау ынэлцат апеле дясупра мунцилор, каре ау фост акопериць. ");
INSERT INTO ron1924_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Ши а перит орьче фэптурэ каре се мишка пе пэмынт, атыт пэсэриле, кыт ши вителе ши фяреле, тот че се тыра пе пэмынт ши тоць оамений. ");
INSERT INTO ron1924_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Тот че рэсуфла, тот че авя суфларе де дух де вяцэ ын нэрь, тот че ера пе пэмынтул ускат а мурит. ");
INSERT INTO ron1924_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Тоате фэптуриле каре ерау пе фаца пэмынтулуй ау фост нимичите, де ла ом пынэ ла вите, пынэ ла тырытоаре ши пынэ ла пэсэриле черулуй; ау фост нимичите де пе пэмынт. Н-а рэмас декыт Ное ши че ера ку ел ын корабие. ");
INSERT INTO ron1924_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Апеле ау фост марь пе пэмынт о сутэ чинчзечь де зиле. ");
INSERT INTO ron1924_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Думнезеу Шь-а адус аминте де Ное, де тоате вецуитоареле ши де тоате вителе каре ерау ку ел ын корабие ши Думнезеу а фэкут сэ суфле ун вынт пе пэмынт, ши апеле с-ау потолит. ");
INSERT INTO ron1924_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Извоареле адынкулуй ши стэвилареле черурилор ау фост ынкисе ши плоая дин чер а фост опритэ. ");
INSERT INTO ron1924_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Апеле ау скэзут де пе фаца пэмынтулуй, скургынду-се ши ымпуцинынду-се ши, дупэ о сутэ чинчзечь де зиле, апеле с-ау микшорат. ");
INSERT INTO ron1924_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ын луна а шаптя, ын зиуа а шаптеспрезечя а луний, корабия с-а оприт пе мунций Арарат. ");
INSERT INTO ron1924_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Апеле ау мерс скэзынд пынэ ын луна а зечя. Ын луна а зечя, ын зиуа ынтый а луний, с-ау вэзут вырфуриле мунцилор. ");
INSERT INTO ron1924_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Дупэ патрузечь де зиле, Ное а дескис ферястра корабией пе каре о фэкусе. ");
INSERT INTO ron1924_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","А дат друмул унуй корб каре а ешит, дукынду-се ши ынторкынду-се пынэ кынд ау секат апеле де пе пэмынт. ");
INSERT INTO ron1924_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","А дат друмул ши унуй порумбел, ка сэ вадэ дакэ скэзусерэ апеле де пе фаца пэмынтулуй. ");
INSERT INTO ron1924_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Дар порумбелул н-а гэсит ничун лок ка сэ-шь пунэ пичорул ши с-а ынторс ла ел ын корабие, кэч ерау апе пе тоатэ фаца пэмынтулуй. Ное а ынтинс мына, л-а луат ши л-а бэгат ла ел ын корабие. ");
INSERT INTO ron1924_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","А май аштептат алте шапте зиле ши ярэшь а дат друмул порумбелулуй дин корабие. ");
INSERT INTO ron1924_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Порумбелул с-а ынторс ла ел спре сярэ ши ятэ кэ ын чокул луй ера о фрунзэ де мэслин руптэ де курынд. Ное а куноскут астфел кэ апеле скэзусерэ пе пэмынт. ");
INSERT INTO ron1924_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","А май аштептат алте шапте зиле ши а дат друмул порумбелулуй. Дар порумбелул ну с-а май ынторс ла ел. ");
INSERT INTO ron1924_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Ын анул шасе суте уну, ын луна ынтый, ын зиуа ынтый а луний, апеле секасерэ пе пэмынт. Ное а ридикат ынвелитоаря корабией: с-а уйтат ши ятэ кэ фаца пэмынтулуй се ускасе. ");
INSERT INTO ron1924_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ын луна а доуа, ын а доуэзечь ши шаптя зи а луний, пэмынтул ера ускат де тот. ");
INSERT INTO ron1924_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Атунч, Думнезеу а ворбит луй Ное ши й-а зис: ");
INSERT INTO ron1924_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","„Ешь дин корабие, ту ши невастэ-та, фиий тэй ши невестеле фиилор тэй ку тине! ");
INSERT INTO ron1924_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Скоате афарэ ымпреунэ ку тине тоате вецуитоареле де тот фелул, каре сунт ку тине, атыт пэсэриле, кыт ши вителе ши тоате тырытоареле каре се тырэск пе пэмынт: сэ мишуне пе пэмынт, сэ кряскэ ши сэ се ынмулцяскэ пе пэмынт.” ");
INSERT INTO ron1924_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ши Ное а ешит афарэ ку фиий сэй, ку невастэ-са ши ку невестеле фиилор сэй. ");
INSERT INTO ron1924_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Тоате добитоачеле, тоате тырытоареле, тоате пэсэриле, тот че се мишкэ пе пэмынт, дупэ союриле лор, ау ешит дин корабие. ");
INSERT INTO ron1924_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Ное а зидит ун алтар Домнулуй, а луат дин тоате добитоачеле курате ши дин тоате пэсэриле курате ши а адус ардерь-де-тот пе алтар. ");
INSERT INTO ron1924_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Домнул а миросит ун мирос плэкут ши Домнул а зис ын инима Луй: „Ну вой май блестема пэмынтул дин причина омулуй, пентру кэ ынтокмириле гындурилор дин инима омулуй сунт реле дин тинереця луй, ши ну вой май лови тот че есте виу, кум ам фэкут. ");
INSERT INTO ron1924_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Кыт ва фи пэмынтул, ну вор ынчета семэнатул ши сечератул, фригул ши кэлдура, вара ши ярна, зиуа ши ноаптя!” ");
INSERT INTO ron1924_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Думнезеу а бинекувынтат пе Ное ши пе фиий сэй ши ле-а зис: „Крештець, ынмулцици-вэ ши умплець пэмынтул. ");
INSERT INTO ron1924_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","С-апуче гроаза ши фрика де вой пе орьче добиток де пе пэмынт, пе орьче пасэре а черулуй, пе тот че се мишкэ пе пэмынт ши пе тоць пештий мэрий: ви ле-ам дат ын мыниле воастре! ");
INSERT INTO ron1924_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Тот че се мишкэ ши аре вяцэ сэ вэ служяскэ де хранэ; тоате ачестя ви ле дау, ка ши ярба верде. ");
INSERT INTO ron1924_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Нумай карне ку вяца ей, адикэ сынӂеле ей, сэ ну мынкаць. ");
INSERT INTO ron1924_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Кэч вой чере ынапой сынӂеле вецилор воастре; ыл вой чере ынапой де ла орьче добиток ши вой чере ынапой вяца омулуй дин мына омулуй, дин мына орькэруй ом, каре есте фрателе луй. ");
INSERT INTO ron1924_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Дакэ варсэ чинева сынӂеле омулуй, ши сынӂеле луй сэ фие вэрсат де ом, кэч Думнезеу а фэкут пе ом дупэ кипул Луй. ");
INSERT INTO ron1924_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Яр вой крештець ши ынмулцици-вэ; рэспындици-вэ пе пэмынт ши ынмулцици-вэ пе ел!” ");
INSERT INTO ron1924_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Думнезеу а май ворбит луй Ное ши фиилор луй, каре ерау ку ел, ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","„Ятэ, Еу фак ун легэмынт ку вой ши ку сэмынца воастрэ, каре ва вени дупэ вой; ");
INSERT INTO ron1924_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ку тоате вецуитоареле каре сунт ку вой, атыт пэсэриле, кыт ши вителе, ши тоате фяреле де пе пэмынт каре сунт ку вой; ку тоате челе каре ау ешит дин корабие ши ку орьче алте добитоаче де пе пэмынт. ");
INSERT INTO ron1924_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Фак ун легэмынт ку вой кэ ничо фэптурэ ну ва май фи нимичитэ де апеле потопулуй ши ну ва май вени потоп, ка сэ пустияскэ пэмынтул.” ");
INSERT INTO ron1924_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Ши Думнезеу а зис: „Ятэ семнул легэмынтулуй пе каре-л фак ынтре Мине ши вой ши ынтре тоате вецуитоареле каре сунт ку вой, пентру тоате нямуриле де оамень ын вечь: ");
INSERT INTO ron1924_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","куркубеул Меу, пе каре л-ам ашезат ын нор, ел ва служи ка семн ал легэмынтулуй динтре Мине ши пэмынт. ");
INSERT INTO ron1924_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Кынд вой стрынӂе норь дясупра пэмынтулуй, куркубеул се ва арэта ын нор, ");
INSERT INTO ron1924_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ши Еу Ымь вой адуче аминте де легэмынтул динтре Мине ши вой ши динтре тоате вецуитоареле де орьче труп; ши апеле ну се вор май фаче ун потоп, ка сэ нимичяскэ орьче фэптурэ. ");
INSERT INTO ron1924_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Куркубеул ва фи ын нор, ши Еу Мэ вой уйта ла ел, ка сэ-Мь адук аминте де легэмынтул чел вешник динтре Думнезеу ши тоате вецуитоареле де орьче труп де пе пэмынт.” ");
INSERT INTO ron1924_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Ши Думнезеу а зис луй Ное: „Ачеста есте семнул легэмынтулуй пе каре л-ам фэкут ынтре Мине ши орьче фэптурэ де пе пэмынт.” ");
INSERT INTO ron1924_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Фиий луй Ное, каре ау ешит дин корабие, ерау: Сем, Хам ши Иафет: Хам есте татэл луй Канаан. ");
INSERT INTO ron1924_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ачештя ау фост чей трей фий ай луй Ное, ши дин ей с-ау рэспындит оамень песте тот пэмынтул. ");
INSERT INTO ron1924_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Ное а ынчепут сэ фие лукрэтор де пэмынт ши а сэдит о вие. ");
INSERT INTO ron1924_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","А бэут вин, с-а ымбэтат ши с-а дезголит ын мижлокул кортулуй сэу. ");
INSERT INTO ron1924_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Хам, татэл луй Канаан, а вэзут голичуня татэлуй сэу ши а спус челор дой фраць ай луй афарэ. ");
INSERT INTO ron1924_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Атунч, Сем ши Иафет ау луат мантауа, ау пус-о пе умерь, ау мерс де-а-ндэрателя ши ау акоперит голичуня татэлуй лор; фииндкэ фецеле ле ерау ынтоарсе ынапой, н-ау вэзут голичуня татэлуй лор. ");
INSERT INTO ron1924_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Ное с-а трезит дин амецяла винулуй ши а афлат че-й фэкусе фиул сэу чел май тынэр. ");
INSERT INTO ron1924_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Ши а зис: „Блестемат сэ фие Канаан! Сэ фие робул робилор фрацилор луй!” ");
INSERT INTO ron1924_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Ел а май зис: „Бинекувынтат сэ фие Домнул Думнезеул луй Сем, Ши Канаан сэ фие робул луй! ");
INSERT INTO ron1924_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Думнезеу сэ лэрӂяскэ локуриле стэпыните де Иафет. Иафет сэ локуяскэ ын кортуриле луй Сем, Ши Канаан сэ фие робул лор!” ");
INSERT INTO ron1924_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Ное а трэит, дупэ потоп, трей суте чинчзечь де ань. ");
INSERT INTO ron1924_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Тоате зилеле луй Ное ау фост де ноуэ суте чинчзечь де ань, апой а мурит. ");
INSERT INTO ron1924_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Ятэ спица нямулуй фиилор луй Ное: Сем, Хам ши Иафет. Дупэ потоп ли с-ау нэскут фий. ");
INSERT INTO ron1924_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Фиий луй Иафет ау фост: Гомер, Магог, Мадай, Иаван, Тубал, Мешек ши Тирас. ");
INSERT INTO ron1924_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Фиий луй Гомер: Ашкеназ, Рифат ши Тогарма. ");
INSERT INTO ron1924_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Фиий луй Иаван: Елиша, Таршиш, Китим ши Доданим. ");
INSERT INTO ron1924_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Де ла ей се траг попоареле дин цэриле нямурилор де пе малул мэрий, дупэ цинутуриле лор, дупэ лимба фиекэруя, дупэ фамилииле лор, дупэ семинцииле лор. ");
INSERT INTO ron1924_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Фиий луй Хам ау фост: Куш, Мицраим, Пут ши Канаан. ");
INSERT INTO ron1924_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Фиий луй Куш: Себа, Хавила, Сабта, Раема ши Сабтека. Фиий луй Раема: Шеба ши Дедан. ");
INSERT INTO ron1924_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Куш а нэскут ши пе Нимрод: ел есте ачела каре а ынчепут сэ фие путерник пе пэмынт. ");
INSERT INTO ron1924_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ел а фост ун витяз вынэтор ынаинтя Домнулуй; ятэ де че се зиче: „Ка Нимрод, витяз вынэтор ынаинтя Домнулуй.” ");
INSERT INTO ron1924_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Ел а домнит ла ынчепут песте Бабел, Ерек, Акад ши Калне, ын цара Шинеар. ");
INSERT INTO ron1924_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Дин цара ачаста а интрат ын Асирия; а зидит Ниниве, Рехобот-Ир, Калах ");
INSERT INTO ron1924_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ши Ресен ынтре Ниниве ши Калах; ачаста есте четатя чя маре. ");
INSERT INTO ron1924_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Мицраим а нэскут пе лудимь, анамимь, лехабимь, нафтухимь, ");
INSERT INTO ron1924_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","патрусимь, каслухимь (дин каре ау ешит филистений) ши пе кафторимь. ");
INSERT INTO ron1924_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Канаан а нэскут пе Сидон, ынтыюл луй нэскут, ши пе Хет; ");
INSERT INTO ron1924_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","ши пе иебусиць, пе амориць, пе гиргасиць, ");
INSERT INTO ron1924_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","пе хевиць, пе аркиць, пе синиць, ");
INSERT INTO ron1924_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","пе арвадиць, пе цемариць, пе хаматиць. Ын урмэ, фамилииле канааницилор с-ау ымпрэштият. ");
INSERT INTO ron1924_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Хотареле канааницилор се ынтиндяу де ла Сидон, кум мерӂь спре Герар, пынэ ла Газа ши, кум мерӂь спре Содома, Гомора, Адма ши Цебоим, пынэ ла Леша. ");
INSERT INTO ron1924_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ачештя сунт фиий луй Хам, дупэ фамилииле лор, дупэ лимбиле лор, дупэ цэриле лор, дупэ нямуриле лор. ");
INSERT INTO ron1924_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Ши луй Сем, татэл тутурор фиилор луй Ебер ши фрателе чел май маре ал луй Иафет, и с-ау нэскут фий. ");
INSERT INTO ron1924_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Фиий луй Сем ау фост: Елам, Асур, Арпакшад, Луд ши Арам. ");
INSERT INTO ron1924_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Фий луй Арам: Уц, Хул, Гетер ши Маш. ");
INSERT INTO ron1924_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Арпакшад а нэскут пе Шелах, ши Шелах а нэскут пе Ебер. ");
INSERT INTO ron1924_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Луй Ебер и с-ау нэскут дой фий: нумеле унуя ера Пелег, нумит аша пентру кэ пе время луй с-а ымпэрцит пэмынтул, яр нумеле фрателуй сэу ера Иоктан. ");
INSERT INTO ron1924_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Иоктан а нэскут пе Алмодад, пе Шелеф, пе Ацармавет, пе Иерах, ");
INSERT INTO ron1924_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","пе Адорам, пе Узал, пе Дикла, ");
INSERT INTO ron1924_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","пе Обал, пе Абимаел, пе Себа, ");
INSERT INTO ron1924_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","пе Офир, пе Хавила ши пе Иобаб. Тоць ачештя ау фост фиий луй Иоктан. ");
INSERT INTO ron1924_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ей ау локуит де ла Меша, кум мерӂь спре Сефар, пынэ ла мунтеле рэсэритулуй. ");
INSERT INTO ron1924_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ачештя сунт фиий луй Сем, дупэ фамилииле лор, дупэ лимбиле лор, дупэ цэриле лор, дупэ нямуриле лор. ");
INSERT INTO ron1924_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Ачестя сунт фамилииле фиилор луй Ное, дупэ спица нямулуй лор, дупэ нямуриле лор. Ши дин ей ау ешит нямуриле каре с-ау рэспындит пе пэмынт дупэ потоп. ");
INSERT INTO ron1924_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Тот пэмынтул авя о сингурэ лимбэ ши ачеляшь кувинте. ");
INSERT INTO ron1924_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Порнинд ей ынспре рэсэрит, ау дат песте о кымпие ын цара Шинеар ши ау дескэлекат аколо. ");
INSERT INTO ron1924_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Ши ау зис унул кэтре алтул: „Хайдем сэ фачем кэрэмизь ши сэ ле ардем бине ын фок!” Ши кэрэмида ле-а цинут лок де пятрэ, яр смоала ле-а цинут лок де вар. ");
INSERT INTO ron1924_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ши ау май зис: „Хайдем сэ не зидим о четате ши ун турн ал кэруй вырф сэ атингэ черул ши сэ не фачем ун нуме, ка сэ ну фим ымпрэштияць пе тоатэ фаца пэмынтулуй!” ");
INSERT INTO ron1924_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Домнул С-а коборыт сэ вадэ четатя ши турнул пе каре-л зидяу фиий оаменилор. ");
INSERT INTO ron1924_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ши Домнул а зис: „Ятэ, ей сунт ун сингур попор ши тоць ау ачеяшь лимбэ, ши ятэ де че с-ау апукат; акум нимик ну й-ар ымпедика сэ факэ тот че шь-ау пус ын гынд. ");
INSERT INTO ron1924_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Хайдем сэ Не коборым ши сэ ле ынкуркэм аколо лимба, ка сэ ну-шь май ынцелягэ ворба уний алтора!” ");
INSERT INTO ron1924_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Ши Домнул й-а ымпрэштият де аколо пе тоатэ фаца пэмынтулуй, аша кэ ау ынчетат сэ зидяскэ четатя. ");
INSERT INTO ron1924_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Де ачея, четатя а фост нумитэ Бабел, кэч аколо а ынкуркат Домнул лимба ынтрегулуй пэмынт ши де аколо й-а ымпрэштият Домнул пе тоатэ фаца пэмынтулуй. ");
INSERT INTO ron1924_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ятэ спица нямулуй луй Сем. Ла вырста де о сутэ де ань, Сем а нэскут пе Арпакшад, ла дой ань дупэ потоп. ");
INSERT INTO ron1924_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Дупэ наштеря луй Арпакшад, Сем а трэит чинч суте де ань ши а нэскут фий ши фийче. ");
INSERT INTO ron1924_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Ла вырста де трейзечь ши чинч де ань, Арпакшад а нэскут пе Шелах. ");
INSERT INTO ron1924_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Дупэ наштеря луй Шелах, Арпакшад а май трэит патру суте трей ань ши а нэскут фий ши фийче. ");
INSERT INTO ron1924_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Ла вырста де трейзечь де ань, Шелах а нэскут пе Ебер. ");
INSERT INTO ron1924_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Дупэ наштеря луй Ебер, Шелах а май трэит патру суте трей ань ши а нэскут фий ши фийче. ");
INSERT INTO ron1924_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ла вырста де трейзечь ши патру де ань, Ебер а нэскут пе Пелег. ");
INSERT INTO ron1924_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Дупэ наштеря луй Пелег, Ебер а май трэит патру суте трейзечь де ань ши а нэскут фий ши фийче. ");
INSERT INTO ron1924_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Ла вырста де трейзечь де ань, Пелег а нэскут пе Реу. ");
INSERT INTO ron1924_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Дупэ наштеря луй Реу, Пелег а май трэит доуэ суте ноуэ ань ши а нэскут фий ши фийче. ");
INSERT INTO ron1924_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Ла вырста де трейзечь ши дой де ань, Реу а нэскут пе Серуг. ");
INSERT INTO ron1924_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Дупэ наштеря луй Серуг, Реу а май трэит доуэ суте шапте ань ши а нэскут фий ши фийче. ");
INSERT INTO ron1924_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Ла вырста де трейзечь де ань, Серуг а нэскут пе Нахор. ");
INSERT INTO ron1924_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Дупэ наштеря луй Нахор, Серуг а май трэит доуэ суте де ань ши а нэскут фий ши фийче. ");
INSERT INTO ron1924_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Ла вырста де доуэзечь ши ноуэ де ань, Нахор а нэскут пе Терах. ");
INSERT INTO ron1924_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Дупэ наштеря луй Терах, Нахор а май трэит о сутэ ноуэспрезече ань ши а нэскут фий ши фийче. ");
INSERT INTO ron1924_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Ла вырста де шаптезечь де ань, Терах а нэскут пе Аврам, пе Нахор ши пе Харан. ");
INSERT INTO ron1924_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Ятэ спица нямулуй луй Терах. Терах а нэскут пе Аврам, пе Нахор ши пе Харан. Харан а нэскут пе Лот. ");
INSERT INTO ron1924_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Ши Харан а мурит ын фаца татэлуй сэу Терах, ын цара ын каре се нэскусе, ын Ур, ын Халдея. ");
INSERT INTO ron1924_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Аврам ши Нахор шь-ау луат невесте. Нумеле невестей луй Аврам ера Сарай ши нумеле невестей луй Нахор ера Милка, фийка луй Харан, татэл Милкэй ши Искэй. ");
INSERT INTO ron1924_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Сарай ера стярпэ; н-авя копий делок. ");
INSERT INTO ron1924_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Терах а луат пе фиул сэу Аврам ши пе Лот, фиул луй Харан, фиул фиулуй сэу, ши пе Сарай, норэ-са, неваста фиулуй сэу Аврам. Ау ешит ымпреунэ дин Ур, дин Халдея, ка сэ мяргэ ын цара Канаан. Ау венит пынэ ла Харан ши с-ау ашезат аколо. ");
INSERT INTO ron1924_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Зилеле луй Терах ау фост де доуэ суте чинч ань, ши Терах а мурит ын Харан. ");
INSERT INTO ron1924_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Домнул зисесе луй Аврам: „Ешь дин цара та, дин рудения та ши дин каса татэлуй тэу ши вино ын цара пе каре ць-о вой арэта. ");
INSERT INTO ron1924_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Вой фаче дин тине ун ням маре ши те вой бинекувынта; ыць вой фаче ун нуме маре ши вей фи о бинекувынтаре. ");
INSERT INTO ron1924_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Вой бинекувынта пе чей че те вор бинекувынта ши вой блестема пе чей че те вор блестема ши тоате фамилииле пэмынтулуй вор фи бинекувынтате ын тине.” ");
INSERT INTO ron1924_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Аврам а плекат, кум ый спусесе Домнул, ши а плекат ши Лот ымпреунэ ку ел. Аврам авя шаптезечь ши чинч де ань кынд а ешит дин Харан. ");
INSERT INTO ron1924_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Аврам а луат пе Сарай, невастэ-са, ши пе Лот, фиул фрателуй сэу, ымпреунэ ку тоате авериле пе каре ле стрынсесерэ ши ку тоате слуӂиле пе каре ле кыштигасерэ ын Харан. Ау плекат ын цара Канаан ши ау ажунс ын цара Канаан. ");
INSERT INTO ron1924_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Аврам а стрэбэтут цара пынэ ла локул нумит Сихем, пынэ ла стежарул луй Море. Канааниций ерау атунч ын царэ. ");
INSERT INTO ron1924_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Домнул С-а арэтат луй Аврам ши й-а зис: „Тоатэ цара ачаста о вой да семинцей тале.” Ши Аврам а зидит аколо ун алтар Домнулуй, каре и Се арэтасе. ");
INSERT INTO ron1924_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Де аколо а порнит спре мунте, ла рэсэрит де Бетел, ши шь-а ынтинс кортул авынд Бетелул ла апус ши Ай ла рэсэрит. А зидит ши аколо ун алтар Домнулуй ши а кемат Нумеле Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Аврам шь-а урмат друмул, ынаинтынд мереу спре мязэзи. ");
INSERT INTO ron1924_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","А венит ынсэ о фоамете ын царэ, ши Аврам с-а коборыт ын Еӂипт ка сэ локуяскэ пентру кытэва време аколо, кэч ера маре фоамете ын царэ. ");
INSERT INTO ron1924_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Кынд ера апроапе сэ интре ын Еӂипт, а зис невестей сале Сарай: „Ятэ, штиу кэ ешть о фемее фрумоасэ ла фацэ. ");
INSERT INTO ron1924_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Кынд те вор ведя еӂиптений, вор зиче: ‘Ачаста есте неваста луй!’ Ши пе мине мэ вор оморы, яр пе тине те вор лэса ку вяцэ. ");
INSERT INTO ron1924_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Спуне, рогу-те, кэ ешть сора мя, ка сэ-мь мяргэ бине дин причина та ши суфлетул меу сэ трэяскэ даторитэ цие.” ");
INSERT INTO ron1924_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Кынд а ажунс Аврам ын Еӂипт, еӂиптений ау вэзут кэ неваста луй ера фоарте фрумоасэ. ");
INSERT INTO ron1924_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Службаший чей май де фрунте ай луй Фараон ау вэзут-о ши ей ши ау лэудат-о ла Фараон, ши фемея а фост адусэ ын каса луй Фараон. ");
INSERT INTO ron1924_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Пе Аврам л-а примит бине дин причина ей ши Аврам а кэпэтат ой, бой, мэгарь, робь ши роабе, мэгэрице ши кэмиле. ");
INSERT INTO ron1924_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Дар Домнул а ловит ку марь урӂий пе Фараон ши каса луй дин причина невестей луй Аврам, Сарай. ");
INSERT INTO ron1924_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Атунч, Фараон а кемат пе Аврам ши й-а зис: „Че мь-ай фэкут? Пентру че ну мь-ай спус кэ есте невастэ-та? ");
INSERT INTO ron1924_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Де че ай зис: ‘Есте сора мя’, ши ам луат-о астфел де невастэ? Акум, ятэ-ць неваста; я-о ши плякэ!” ");
INSERT INTO ron1924_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Ши Фараон а дат порункэ оаменилор луй сэ-л петрякэ пе ел, пе неваста са ши тот че авя. ");
INSERT INTO ron1924_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Аврам с-а суит дин Еӂипт ын цара де ла мязэзи, ел, невастэ-са ши тот че авя, ымпреунэ ку Лот. ");
INSERT INTO ron1924_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Аврам ера фоарте богат ын вите, ын арӂинт ши ын аур. ");
INSERT INTO ron1924_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Дин цара де ла мязэзи с-а ындрептат ши а мерс пынэ ла Бетел, пынэ ла локул унде фусесе кортул луй ла ынчепут, ынтре Бетел ши Ай, ");
INSERT INTO ron1924_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","ын локул унде ера алтарул пе каре-л фэкусе май ынаинте. Ши аколо, Аврам а кемат Нумеле Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Лот, каре кэлэторя ымпреунэ ку Аврам, авя ши ел ой, бой ши кортурь. ");
INSERT INTO ron1924_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ши цинутул ачела ну-й ынкэпя сэ локуяскэ ымпреунэ, кэч авериле лор ерау аша де марь ынкыт ну путяу сэ локуяскэ ымпреунэ. ");
INSERT INTO ron1924_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","С-а искат о чартэ ынтре пэзиторий вителор луй Аврам ши пэзиторий вителор луй Лот. Канааниций ши ферезиций локуяу атунч ын царэ. ");
INSERT INTO ron1924_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Аврам а зис луй Лот: „Те рог, сэ ну фие чартэ ынтре мине ши тине ши ынтре пэзиторий мей ши пэзиторий тэй, кэч сунтем фраць. ");
INSERT INTO ron1924_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ну-й оаре тоатэ цара ынаинтя та? Май бине деспарте-те де мине: дакэ апучь ту ла стынга, еу вой апука ла дряпта; дакэ апучь ту ла дряпта, еу вой апука ла стынга.” ");
INSERT INTO ron1924_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Лот шь-а ридикат окий ши а вэзут кэ тоатэ Кымпия Йорданулуй ера бине удатэ ын ынтреӂиме. Ынаинте де а нимичи Домнул Содома ши Гомора, пынэ ла Цоар, ера ка о грэдинэ а Домнулуй, ка цара Еӂиптулуй. ");
INSERT INTO ron1924_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Лот шь-а алес тоатэ Кымпия Йорданулуй ши а мерс спре рэсэрит. Астфел с-ау деспэрцит ей унул де алтул. ");
INSERT INTO ron1924_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Аврам а локуит ын цара Канаан, яр Лот а локуит ын четэциле дин Кымпие ши шь-а ынтинс кортуриле пынэ ла Содома. ");
INSERT INTO ron1924_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Оамений дин Содома ерау рэй ши афарэ дин кале де пэкэтошь ымпотрива Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Домнул а зис луй Аврам дупэ че с-а деспэрцит Лот де ел: „Ридикэ-ць окий ши, дин локул ын каре ешть, привеште спре мязэноапте ши спре мязэзи, спре рэсэрит ши спре апус; ");
INSERT INTO ron1924_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","кэч тоатэ цара пе каре о везь ць-о дау цие ши семинцей тале ын вяк. ");
INSERT INTO ron1924_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ыць вой фаче сэмынца ка пулберя пэмынтулуй де маре; аша кэ, дакэ поате нумэра чинева пулберя пэмынтулуй, ши сэмынца та ва путя сэ фие нумэратэ. ");
INSERT INTO ron1924_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Скоалэ-те, стрэбате цара ын лунг ши ын лат, кэч цие ць-о вой да.” ");
INSERT INTO ron1924_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Аврам шь-а ридикат кортуриле ши а венит де а локуит лынгэ стежарий луй Мамре, каре сунт лынгэ Хеброн. Ши аколо а зидит ун алтар Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Пе время луй Амрафел, ымпэратул Шинеарулуй, а луй Ариок, ымпэратул Еласарулуй, а луй Кедорлаомер, ымпэратул Еламулуй, ши а луй Тидеал, ымпэратул Гоиймулуй, ");
INSERT INTO ron1924_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","с-а ынтымплат кэ ей ау фэкут рэзбой ку Бера, ымпэратул Содомей, ку Бирша, ымпэратул Гоморей, ку Шинеаб, ымпэратул Адмей, ку Шемеебер, ымпэратул Цебоимулуй, ши ку ымпэратул Белей, сау Цоарулуй. ");
INSERT INTO ron1924_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Ачештя дин урмэ с-ау адунат ку тоций ын валя Сидим, адикэ Маря Сэратэ. ");
INSERT INTO ron1924_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Тимп де дойспрезече ань фусесерэ супушь луй Кедорлаомер; ши ын анул ал трейспрезечеля с-ау рэскулат. ");
INSERT INTO ron1924_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Дар, ын анул ал пайспрезечеля, Кедорлаомер ши ымпэраций каре ерау ку ел ау порнит ши ау бэтут пе рефаимь ла Аштерот-Карнаим, пе зузимь ла Хам, пе емимь ла Шаве-Кириатаим ");
INSERT INTO ron1924_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ши пе хориць ын мунтеле лор, Сеир, пынэ ла стежарул Паран, каре есте лынгэ пустиу. ");
INSERT INTO ron1924_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Апой с-ау ынторс, ау венит ла Ен-Мишпат, сау Кадес, ши ау бэтут пе амалечиць пе тот цинутул лор, ка ши пе амориць, каре локуяу ла Хацацон-Тамар. ");
INSERT INTO ron1924_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Атунч ау ешит ымпэратул Содомей, ымпэратул Гоморей, ымпэратул Адмей, ымпэратул Цебоимулуй ши ымпэратул Белей, сау Цоарулуй, ши с-ау ашезат ын линие де бэтае ымпотрива лор, ын валя Сидим, ");
INSERT INTO ron1924_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","ши ануме: ымпотрива луй Кедорлаомер, ымпэратул Еламулуй, ымпотрива луй Тидеал, ымпэратул Гоиймулуй, ымпотрива луй Амрафел, ымпэратул Шинеарулуй, ши ымпотрива луй Ариок, ымпэратул Еласарулуй; патру ымпэраць ымпотрива а чинч. ");
INSERT INTO ron1924_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Валя Сидим ера акоперитэ ку фынтынь де смоалэ. Ымпэратул Содомей ши ымпэратул Гоморей ау луат-о ла фугэ ши ау кэзут ын еле; чейлалць ау фуӂит спре мунте. ");
INSERT INTO ron1924_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Бируиторий ау луат тоате богэцииле Содомей ши Гоморей ши тоате меринделе лор ши ау плекат. ");
INSERT INTO ron1924_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ау луат ши пе Лот, фиул фрателуй луй Аврам, каре локуя ын Содома; ау луат ши авериле луй ши ау плекат. ");
INSERT INTO ron1924_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","А венит унул каре скэпасе ши а дат де штире луй Аврам, Евреул; ачеста локуя лынгэ стежарий луй Мамре, Аморитул, фрателе луй Ешкол ши фрателе луй Анер, каре фэкусерэ легэтурэ де паче ку Аврам. ");
INSERT INTO ron1924_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Кум а аузит Аврам кэ фрателе сэу фусесе луат принс де рэзбой, а ынармат трей суте оптспрезече дин чей май витежь служиторь ай луй, нэскуць ын каса луй, ши а урмэрит пе ымпэраций ачея пынэ ла Дан. ");
INSERT INTO ron1924_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Шь-а ымпэрцит оамений ын май мулте чете, с-а арункат асупра лор ноаптя, й-а бэтут ши й-а урмэрит пынэ ла Хоба, каре есте ла стынга Дамаскулуй. ");
INSERT INTO ron1924_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","А адус ынапой тоате богэцииле; а луат ынапой ши пе фрателе сэу Лот, ку авериле луй, прекум ши пе фемей, ши нородул. ");
INSERT INTO ron1924_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Дупэ че с-а ынторс Аврам де ла ынфрынӂеря луй Кедорлаомер ши а ымпэрацилор каре ерау ымпреунэ ку ел, ымпэратул Содомей й-а ешит ын ынтымпинаре ын валя Шаве, сау Валя Ымпэратулуй. ");
INSERT INTO ron1924_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Мелхиседек, ымпэратул Салемулуй, а адус пыне ши вин – ел ера преот ал Думнезеулуй челуй Пряыналт. ");
INSERT INTO ron1924_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Мелхиседек а бинекувынтат пе Аврам ши а зис: „Бинекувынтат сэ фие Аврам де Думнезеул чел Пряыналт, Зидиторул черулуй ши ал пэмынтулуй! ");
INSERT INTO ron1924_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Бинекувынтат сэ фие Думнезеул чел Пряыналт, каре а дат пе врэжмаший тэй ын мыниле тале!” Ши Аврам й-а дат зечуялэ дин тоате. ");
INSERT INTO ron1924_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Ымпэратул Содомей а зис луй Аврам: „Дэ-мь оамений ши цине богэцииле пентру тине.” ");
INSERT INTO ron1924_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Аврам а рэспунс ымпэратулуй Содомей: „Ридик мына спре Домнул Думнезеул чел Пряыналт, Зидиторул черулуй ши ал пэмынтулуй, ");
INSERT INTO ron1924_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ши жур кэ ну вой луа нимик дин тот че есте ал тэу, нич мэкар ун фир де ацэ, нич мэкар о куря де ынкэлцэминте, ка сэ ну зичь: ‘Ам ымбогэцит пе Аврам.’ Нимик пентру мине, ");
INSERT INTO ron1924_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","афарэ де че ау мынкат флэкэий ши партя оаменилор каре ау мерс ку мине: Анер, Ешкол ши Мамре; ей пот сэ-шь я партя лор!” ");
INSERT INTO ron1924_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Дупэ ачесте ынтымплэрь, Кувынтул Домнулуй а ворбит луй Аврам ынтр-о ведение ши а зис: „Авраме, ну те теме; Еу сунт скутул тэу ши рэсплата та чя фоарте маре.” ");
INSERT INTO ron1924_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Аврам а рэспунс: „Доамне Думнезеуле, че-мь вей да? Кэч мор фэрэ копий, ши моштениторул касей меле есте Елиезер дин Дамаск.” ");
INSERT INTO ron1924_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Ши Аврам а зис: „Ятэ кэ ну мь-ай дат сэмынцэ, ши служиторул нэскут ын каса мя ва фи моштениторул меу.” ");
INSERT INTO ron1924_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Атунч, Кувынтул Домнулуй й-а ворбит астфел: „Ну ел ва фи моштениторул тэу, чи чел че ва еши дин тине, ачела ва фи моштениторул тэу.” ");
INSERT INTO ron1924_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Ши дупэ че л-а дус афарэ, й-а зис: „Уйтэ-те спре чер ши нумэрэ стелеле, дакэ поць сэ ле нумерь.” Ши й-а зис: „Аша ва фи сэмынца та.” ");
INSERT INTO ron1924_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Аврам а крезут пе Домнул, ши Домнул й-а сокотит лукрул ачеста ка неприхэнире. ");
INSERT INTO ron1924_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Домнул й-а май зис: „Еу сунт Домнул, каре те-ам скос дин Ур, дин Халдея, ка сэ-ць дау ын стэпынире цара ачаста.” ");
INSERT INTO ron1924_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Аврам а рэспунс: „Доамне Думнезеуле, прин че вой куноаште кэ о вой стэпыни?” ");
INSERT INTO ron1924_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Ши Домнул й-а зис: „Я о жунканэ де трей ань, о капрэ де трей ань, ун бербек де трей ань, о туртуря ши ун пуй де порумбел.” ");
INSERT INTO ron1924_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Аврам а луат тоате добитоачеле ачестя, ле-а деспикат ын доуэ ши а пус фиекаре букатэ уна ын фаца алтея, дар пэсэриле ну ле-а деспикат. ");
INSERT INTO ron1924_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Пэсэриле рэпитоаре с-ау нэпустит песте стырвурь, дар Аврам ле-а изгонит. ");
INSERT INTO ron1924_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ла апусул соарелуй, ун сомн адынк а кэзут песте Аврам ши ятэ кэ л-а апукат о гроазэ ши ун маре ынтунерик. ");
INSERT INTO ron1924_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ши Домнул а зис луй Аврам: „Сэ штий хотэрыт кэ сэмынца та ва фи стрэинэ ынтр-о царэ каре ну ва фи а ей; аколо ва фи робитэ, ши о вор апэса греу, тимп де патру суте де ань. ");
INSERT INTO ron1924_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Дар пе нямул кэруя ый ва фи роабэ, ыл вой жудека Еу, ши пе урмэ ва еши де аколо ку марь богэций. ");
INSERT INTO ron1924_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ту вей мерӂе ын паче ла пэринций тэй; вей фи ынгропат дупэ о бэтрынеце феричитэ. ");
INSERT INTO ron1924_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Ын ал патруля ням, еа се ва ынтоарче аич, кэч нелеӂюиря аморицилор ну шь-а атинс ынкэ вырфул.” ");
INSERT INTO ron1924_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Дупэ че а асфинцит соареле, с-а фэкут ун ынтунерик адынк ши ятэ кэ а ешит ун фум ка динтр-ун куптор ши ниште флэкэрь ау трекут принтре добитоачеле деспикате. ");
INSERT INTO ron1924_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ын зиуа ачея, Домнул а фэкут ун легэмынт ку Аврам ши й-а зис: „Семинцей тале дау цара ачаста, де ла рыул Еӂиптулуй пынэ ла рыул чел маре, рыул Еуфрат, ");
INSERT INTO ron1924_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ши ануме цара кеницилор, а кенизицилор, а кадмоницилор, ");
INSERT INTO ron1924_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","а хетицилор, а ферезицилор, а рефаимицилор, ");
INSERT INTO ron1924_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","а аморицилор, а канааницилор, а гиргасицилор ши а иебусицилор.” ");
INSERT INTO ron1924_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Сарай, неваста луй Аврам, ну-й нэскусе делок копий. Еа авя о роабэ еӂиптянкэ, нумитэ Агар. ");
INSERT INTO ron1924_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Ши Сарай а зис луй Аврам: „Ятэ, Домнул м-а фэкут стярпэ; интрэ, те рог, ла роаба мя; поате кэ вой авя копий де ла еа.” Аврам а аскултат челе спусе де Сарай. ");
INSERT INTO ron1924_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Атунч, Сарай, неваста луй Аврам, а луат пе еӂиптянка Агар, роаба ей, ши а дат-о де невастэ бэрбатулуй сэу, Аврам, дупэ че Аврам локуисе ка стрэин зече ань ын цара Канаан. ");
INSERT INTO ron1924_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ел а интрат ла Агар, ши еа а рэмас ынсэрчинатэ. Кынд с-а вэзут еа ынсэрчинатэ, а привит ку диспрец пе стэпынэ-са. ");
INSERT INTO ron1924_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Ши Сарай а зис луй Аврам: „Асупра та сэ кадэ батжокура ачаста, каре ми се фаче! Еу ынсумь ць-ам дат ын браце пе роаба мя, ши еа, кынд а вэзут кэ а рэмас ынсэрчинатэ, м-а привит ку диспрец. Сэ жудече Домнул ынтре мине ши тине!” ");
INSERT INTO ron1924_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Аврам а рэспунс Сараей: „Ятэ, роаба та есте ын мына та; фэ-й че-ць плаче!” Атунч, Сарай с-а пуртат рэу ку еа, ши Агар а фуӂит де еа. ");
INSERT INTO ron1924_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Ынӂерул Домнулуй а гэсит-о лынгэ ун извор де апэ ын пустиу, ши ануме лынгэ изворул каре есте пе друмул че дуче ла Шур. ");
INSERT INTO ron1924_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ел а зис: „Агар, роаба Сараей, де унде вий ши унде те дучь?” Еа а рэспунс: „Фуг де стэпына мя Сарай.” ");
INSERT INTO ron1924_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ынӂерул Домнулуй й-а зис: „Ынтоарче-те ла стэпынэ-та ши супуне-те суб мына ей.” ");
INSERT INTO ron1924_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Ынӂерул Домнулуй й-а зис: „Ыць вой ынмулци фоарте мулт сэмынца ши еа ва фи атыт де мултэ ла нумэр, кэ ну ва путя фи нумэратэ.” ");
INSERT INTO ron1924_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ынӂерул Домнулуй й-а зис: „Ятэ, акум ешть ынсэрчинатэ ши вей наште ун фиу, кэруя ый вей пуне нумеле Исмаел, кэч Домнул а аузит мыхниря та. ");
INSERT INTO ron1924_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ел ва фи ка ун мэгар сэлбатик принтре оамень; мына луй ва фи ымпотрива тутурор оаменилор, ши мына тутурор оаменилор ва фи ымпотрива луй ши ва локуи ын фаца тутурор фрацилор луй.” ");
INSERT INTO ron1924_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Еа а нумит Нумеле Домнулуй каре-й ворбисе: „Ту ешть Думнезеу каре мэ веде!” Кэч а зис еа: „Ку адевэрат, ам вэзут аич спателе Челуй че м-а вэзут!” ");
INSERT INTO ron1924_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Де ачея, фынтына ачея с-а нумит „Фынтына Челуй Виу каре мэ веде ”; еа есте ынтре Кадес ши Баред. ");
INSERT INTO ron1924_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Агар а нэскут луй Аврам ун фиу ши Аврам а пус фиулуй пе каре и л-а нэскут Агар нумеле Исмаел. ");
INSERT INTO ron1924_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Аврам ера де оптзечь ши шасе де ань кынд й-а нэскут Агар пе Исмаел. ");
INSERT INTO ron1924_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Кынд а фост Аврам ын вырстэ де ноуэзечь ши ноуэ де ань, Домнул и С-а арэтат ши й-а зис: „Еу сунт Думнезеул чел Атотпутерник. Умблэ ынаинтя Мя ши фий фэрэ приханэ. ");
INSERT INTO ron1924_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Вой фаче ун легэмынт ынтре Мине ши тине ши те вой ынмулци неспус де мулт.” ");
INSERT INTO ron1924_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Аврам с-а арункат ку фаца ла пэмынт ши Думнезеу й-а ворбит астфел: ");
INSERT INTO ron1924_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","„Ятэ легэмынтул Меу пе каре-л фак ку тине: вей фи татэл мултор нямурь. ");
INSERT INTO ron1924_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ну те вей май нуми Аврам, чи нумеле тэу ва фи Авраам, кэч те фак татэл мултор нямурь. ");
INSERT INTO ron1924_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Те вой ынмулци неспус де мулт; вой фаче дин тине нямурь ынтреӂь ши дин тине вор еши ымпэраць. ");
INSERT INTO ron1924_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Вой пуне легэмынтул Меу ынтре Мине ши тине ши сэмынца та дупэ тине дин ням ын ням; ачеста ва фи ун легэмынт вешник, ын путеря кэруя Еу вой фи Думнезеул тэу ши ал семинцей тале дупэ тине. ");
INSERT INTO ron1924_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Цие ши семинцей тале дупэ тине ыць вой да цара ын каре локуешть акум ка стрэин, ши ануме ыць вой да тоатэ цара Канаанулуй ын стэпынире вешникэ; ши Еу вой фи Думнезеул лор.” ");
INSERT INTO ron1924_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Думнезеу а зис луй Авраам: „Сэ пэзешть легэмынтул Меу, ту ши сэмынца та дупэ тине, дин ням ын ням. ");
INSERT INTO ron1924_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ачеста есте легэмынтул Меу пе каре сэ-л пэзиць ынтре Мине ши вой ши сэмынца та дупэ тине: тот че есте де парте бэрбэтяскэ ынтре вой сэ фие тэят ымпрежур. ");
INSERT INTO ron1924_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Сэ вэ тэяць ымпрежур ын карня препуцулуй востру, ши ачеста сэ фие семнул легэмынтулуй динтре Мине ши вой. ");
INSERT INTO ron1924_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Ла вырста де опт зиле, орьче копил де парте бэрбэтяскэ динтре вой сэ фие тэят ымпрежур, ням дупэ ням: фие кэ есте роб нэскут ын касэ, фие кэ есте кумпэрат ку бань де ла вреун стрэин, каре ну фаче парте дин нямул тэу. ");
INSERT INTO ron1924_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Ва требуи тэят ымпрежур атыт робул нэскут ын касэ, кыт ши чел кумпэрат ку бань, ши астфел легэмынтул Меу сэ фие ынтэрит ын карня воастрэ ка ун легэмынт вешник. ");
INSERT INTO ron1924_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ун копил де парте бэрбэтяскэ нетэят ымпрежур ын карня препуцулуй луй сэ фие нимичит дин мижлокул нямулуй сэу: а кэлкат легэмынтул Меу.” ");
INSERT INTO ron1924_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Думнезеу а зис луй Авраам: „Сэ ну май кемь Сарай пе невастэ-та Сарай, чи нумеле ей сэ фие Сара. ");
INSERT INTO ron1924_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Еу о вой бинекувынта ши ыць вой да ун фиу дин еа; да, о вой бинекувынта ши еа ва фи мама унор нямурь ынтреӂь; кяр ымпэраць де нороаде вор еши дин еа.” ");
INSERT INTO ron1924_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Авраам с-а арункат ку фаца ла пэмынт ши а рыс, кэч а зис ын инима луй: „Сэ и се май наскэ оаре ун фиу унуй бэрбат де о сутэ де ань? Ши сэ май наскэ оаре Сара ла ноуэзечь де ань?” ");
INSERT INTO ron1924_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ши Авраам а зис луй Думнезеу: „Сэ трэяскэ Исмаел ынаинтя Та!” ");
INSERT INTO ron1924_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Думнезеу а зис: „Ку адевэрат, неваста та Сара ыць ва наште ун фиу ши-й вей пуне нумеле Исаак. Еу вой ынкея легэмынтул Меу ку ел, ка ун легэмынт вешник пентру сэмынца луй дупэ ел. ");
INSERT INTO ron1924_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Дар ши ку привире ла Исмаел те-ам аскултат. Ятэ, ыл вой бинекувынта, ыл вой фаче сэ кряскэ ши ыл вой ынмулци неспус де мулт: дойспрезече воевозь ва наште ши вой фаче дин ел ун ням маре. ");
INSERT INTO ron1924_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Дар легэмынтул меу ыл вой ынкея ку Исаак, пе каре ци-л ва наште Сара ла анул пе время ачаста.” ");
INSERT INTO ron1924_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Кынд а испрэвит де ворбит ку ел, Думнезеу С-а ынэлцат де ла Авраам. ");
INSERT INTO ron1924_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Авраам а луат пе фиул сэу Исмаел, пе тоць чей че се нэскусерэ ын каса луй ши пе тоць робий кумпэраць ку бань, адикэ пе тоць чей де парте бэрбэтяскэ динтре оамений дин каса луй Авраам, ши ле-а тэят ымпрежур карня препуцулуй кяр ын зиуа ачея, дупэ порунка пе каре й-о дэдусе Думнезеу. ");
INSERT INTO ron1924_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Авраам ера ын вырстэ де ноуэзечь ши ноуэ де ань кынд а фост тэят ымпрежур ын карня препуцулуй сэу. ");
INSERT INTO ron1924_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Фиул сэу Исмаел ера ын вырстэ де трейспрезече ань кынд а фост тэят ымпрежур ын карня препуцулуй сэу. ");
INSERT INTO ron1924_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Авраам ши фиул сэу Исмаел ау фост тэяць ымпрежур кяр ын зиуа ачея. ");
INSERT INTO ron1924_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Ши тоць оамений дин каса луй: робь нэскуць ын каса луй сау кумпэраць ку бань де ла стрэинь ау фост тэяць ымпрежур ымпреунэ ку ел. ");
INSERT INTO ron1924_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Домнул и С-а арэтат ла стежарий луй Мамре, пе кынд Авраам шедя ла уша кортулуй, ын тимпул зэдуфулуй зилей. ");
INSERT INTO ron1924_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Авраам а ридикат окий ши с-а уйтат, ши ятэ кэ трей бэрбаць стэтяу ын пичоаре лынгэ ел. Кынд й-а вэзут, а алергат ынаинтя лор, де ла уша кортулуй, ши с-а плекат пынэ ла пэмынт. ");
INSERT INTO ron1924_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Апой а зис: „Доамне, дакэ ам кэпэтат тречере ын окий Тэй, ну трече, рогу-Те, пе лынгэ робул Тэу. ");
INSERT INTO ron1924_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Ынгэдуе сэ се адукэ пуцинэ апэ, ка сэ ви се спеле пичоареле, ши одихници-вэ суб копакул ачеста. ");
INSERT INTO ron1924_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ам сэ мэ дук сэ яу о букатэ де пыне, ка сэ приндець ла инимэ, ши дупэ ачея вэ вець ведя де друм, кэч пентру ачаста тречець пе лынгэ робул востру.” „Фэ кум ай зис”, й-ау рэспунс ей. ");
INSERT INTO ron1924_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Авраам с-а дус репеде ын корт ла Сара ши а зис: „Я репеде трей мэсурь де фэинэ албэ, фрэмынтэ ши фэ турте.” ");
INSERT INTO ron1924_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Ши Авраам а алергат ла вите, а луат ун вицел тынэр ши бун ши л-а дат уней слуӂь сэ-л гэтяскэ ын грабэ. ");
INSERT INTO ron1924_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Апой а луат унт ши лапте, ымпреунэ ку вицелул пе каре-л гэтисе, ши ле-а пус ынаинтя лор. Ел ынсушь а стат лынгэ ей, суб копак, ши ле-а служит пынэ че ау мынкат. ");
INSERT INTO ron1924_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Атунч, ей й-ау зис: „Унде есте невастэ-та, Сара?” „Уйте-о ын корт ”, а рэспунс ел. ");
INSERT INTO ron1924_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Унул динтре ей а зис: „Ла анул пе время ачаста, Мэ вой ынтоарче негрешит ла тине ши ятэ кэ Сара, невастэ-та, ва авя ун фиу.” Сара аскулта ла уша кортулуй каре ера ынапоя луй. ");
INSERT INTO ron1924_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Авраам ши Сара ерау бэтрынь, ынаинтаць ын вырстэ, ши Сарей ну-й май веня рындуяла фемеилор. ");
INSERT INTO ron1924_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Сара а рыс ын сине, зикынд: „Акум, кынд ам ымбэтрынит, сэ май ам пофте? Домнул меу бэрбатул де асеменя есте бэтрын.” ");
INSERT INTO ron1924_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Домнул а зис луй Авраам: „Пентру че а рыс Сара, зикынд: ‘Ку адевэрат сэ май пот авя копил еу, каре сунт бэтрынэ?’ ");
INSERT INTO ron1924_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Есте оаре чева пря греу пентру Домнул? Ла анул пе время ачаста, Мэ вой ынтоарче ла тине, ши Сара ва авя ун фиу.” ");
INSERT INTO ron1924_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Сара а тэгэдуит ши а зис: „Н-ам рыс.” Кэч й-а фост фрикэ. Дар Ел а зис: „Ба да, ай рыс.” ");
INSERT INTO ron1924_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Бэрбаций ачея с-ау скулат сэ плече ши с-ау уйтат ынспре Содома. Авраам а плекат ку ей, сэ-й петрякэ. ");
INSERT INTO ron1924_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Атунч, Домнул а зис: „Сэ аскунд Еу оаре де Авраам че ам сэ фак?… ");
INSERT INTO ron1924_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Кэч Авраам ва ажунӂе негрешит ун ням маре ши путерник ши ын ел вор фи бинекувынтате тоате нямуриле пэмынтулуй. ");
INSERT INTO ron1924_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Кэч Еу ыл куноск ши штиу кэ аре сэ порунчяскэ фиилор луй ши касей луй дупэ ел сэ цинэ Каля Домнулуй, фэкынд че есте дрепт ши бине, пентру ка астфел Домнул сэ ымплиняскэ фацэ де Авраам че й-а фэгэдуит.” ");
INSERT INTO ron1924_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Ши Домнул а зис: „Стригэтул ымпотрива Содомей ши Гоморей с-а мэрит ши пэкатул лор ынтр-адевэр есте неспус де греу. ");
INSERT INTO ron1924_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Де ачея Мэ вой коборы акум сэ вэд дакэ ын адевэр ау лукрат ын тотул дупэ звонул венит пынэ ла Мине ши, дакэ ну ва фи аша, вой шти.” ");
INSERT INTO ron1924_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Бэрбаций ачея с-ау депэртат ши ау плекат спре Содома. Дар Авраам стэтя тот ынаинтя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Авраам с-а апропият ши а зис: „Вей нимичи Ту оаре ши пе чел бун ымпреунэ ку чел рэу? ");
INSERT INTO ron1924_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Поате кэ ын мижлокул четэций сунт чинчзечь де оамень бунь: ый вей нимичи оаре ши пе ей ши ну вей ерта локул ачела дин причина челор чинчзечь де оамень бунь, каре сунт ын мижлокул ей? ");
INSERT INTO ron1924_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Сэ оморь пе чел бун ымпреунэ ку чел рэу, аша ка чел бун сэ айбэ ачеяшь соартэ ка чел рэу, департе де Тине аша чева! Департе де Тине! Чел че жудекэ тот пэмынтул ну ва фаче оаре дрептате?” ");
INSERT INTO ron1924_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Ши Домнул а зис: „Дакэ вой гэси ын Содома чинчзечь де оамень бунь ын мижлокул четэций, вой ерта тот локул ачела дин причина лор.” ");
INSERT INTO ron1924_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Авраам а луат дин ноу кувынтул ши а зис: „Ятэ, ам ындрэзнит сэ ворбеск Домнулуй еу, каре ну сунт декыт праф ши ченушэ. ");
INSERT INTO ron1924_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Поате кэ дин чинчзечь де оамень бунь вор липси чинч: пентру чинч, вей нимичи Ту оаре тоатэ четатя?” Ши Домнул а зис: „Н-о вой нимичи дакэ вой гэси ын еа патрузечь ши чинч де оамень бунь.” ");
INSERT INTO ron1924_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Авраам Й-а ворбит май департе ши а зис: „Поате кэ се вор гэси ын еа нумай патрузечь де оамень бунь.” Ши Домнул а зис: „Н-о вой нимичи пентру чей патрузечь.” ");
INSERT INTO ron1924_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Авраам а зис: „Сэ ну Те мыний, Доамне, дакэ вой май ворби. Поате кэ се вор гэси ын еа нумай трейзечь де оамень бунь.” Ши Домнул а зис: „Н-о вой нимичи дакэ вой гэси ын еа трейзечь де оамень бунь.” ");
INSERT INTO ron1924_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Авраам а зис: „Ятэ, ам ындрэзнит сэ ворбеск Домнулуй. Поате кэ се вор гэси ын еа нумай доуэзечь де оамень бунь.” Ши Домнул а зис: „Н-о вой нимичи, пентру чей доуэзечь.” ");
INSERT INTO ron1924_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Авраам а зис: „Сэ ну Те мыний, Доамне, дакэ вой май ворби нумай де дата ачаста. Поате кэ се вор гэси ын еа нумай зече оамень бунь.” Ши Домнул а зис: „Н-о вой нимичи, пентру чей зече оамень бунь.” ");
INSERT INTO ron1924_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Дупэ че а испрэвит де ворбит луй Авраам, Домнул а плекат. Ши Авраам с-а ынторс ла локуинца луй. ");
INSERT INTO ron1924_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Чей дой ынӂерь ау ажунс ла Содома сяра, ши Лот шедя ла поарта Содомей. Кынд й-а вэзут, Лот с-а скулат, ле-а ешит ынаинте ши с-а плекат пынэ ла пэмынт. ");
INSERT INTO ron1924_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Апой а зис: „Домний мей, интраць, вэ рог, ын каса робулуй востру, ка сэ рэмынець песте ноапте ын еа, ши спэлаци-вэ пичоареле; мыне вэ вець скула де диминяцэ ши вэ вець ведя де друм.” „Ну”, ау рэспунс ей, „чи вом петрече ноаптя ын улицэ.” ");
INSERT INTO ron1924_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Дар Лот а стэруит де ей пынэ ау венит ши ау интрат ын каса луй. Ле-а прегэтит о чинэ, а пус сэ коакэ азиме ши ау мынкат. ");
INSERT INTO ron1924_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Дар ну се кулкасерэ ынкэ, ши оамений дин четате, бэрбаций дин Содома, тинерь ши бэтрынь, ау ынконжурат каса; тот нородул а алергат дин тоате колцуриле. ");
INSERT INTO ron1924_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ау кемат пе Лот ши й-ау зис: „Унде сунт оамений каре ау интрат ла тине ын ноаптя ачаста? Скоате-й афарэ ла ной, ка сэ не ымпреунэм ку ей.” ");
INSERT INTO ron1924_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Лот а ешит афарэ ла ей ла ушэ, а ынкуят уша дупэ ел ");
INSERT INTO ron1924_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","ши а зис: „Фрацилор, вэ рог, ну фачець о асеменя рэутате! ");
INSERT INTO ron1924_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Ятэ кэ ам доуэ фете каре ну штиу де бэрбат; ам сэ ви ле адук афарэ ши ле вець фаче че вэ ва плэчя. Нумай ну фачець нимик ачестор оамень, фииндкэ ау венит суб умбра акоперишулуй касей меле.” ");
INSERT INTO ron1924_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ей ау стригат: „Плякэ!” Ши ау зис: „Омул ачеста а венит сэ локуяскэ аич ка ун стрэин ши акум вря сэ факэ пе жудекэторул. Ей бине, о сэ-ць фачем май рэу декыт лор.” Ши, ымпингынд пе Лот ку сила, с-ау апропият сэ спаргэ уша. ");
INSERT INTO ron1924_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Дар бэрбаций ачея ау ынтинс мына, ау трас пе Лот ынэунтру ла ей ын касэ ши ау ынкуят уша. ");
INSERT INTO ron1924_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Яр пе оамений каре ерау ла уша касей й-ау ловит ку орбире, де ла чел май мик пынэ ла чел май маре, аша кэ деӂяба се трудяу сэ гэсяскэ уша. ");
INSERT INTO ron1924_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Бэрбаций ачея ау зис луй Лот: „Пе чине май ай аич? Ӂинерь, фий ши фийче ши тот че ай ын четате – скоате-й дин локул ачеста. ");
INSERT INTO ron1924_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Кэч авем сэ нимичим локул ачеста, пентру кэ а ажунс маре плынӂере ынаинтя Домнулуй ымпотрива локуиторилор луй. Де ачея не-а тримис Домнул, ка сэ-л нимичим.” ");
INSERT INTO ron1924_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Лот а ешит ши а ворбит ку ӂинерий сэй, каре луасерэ пе фетеле луй: „Скулаци-вэ”, а зис ел, „ешиць дин локул ачеста; кэч Домнул аре сэ нимичяскэ четатя.” Дар ӂинерий луй кредяу кэ глумеште. ");
INSERT INTO ron1924_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Кынд с-а крэпат де зиуэ, ынӂерий ау стэруит де Лот зикынд: „Скоалэ-те, я-ць неваста ши челе доуэ фете, каре се афлэ аич, ка сэ ну перь ши ту ын нелеӂюиря четэций.” ");
INSERT INTO ron1924_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ши, фииндкэ Лот зэбовя, бэрбаций ачея й-ау апукат де мынэ пе ел, пе невастэ-са ши пе челе доуэ фете але луй, кэч Домнул воя сэ-й круце; л-ау скос ши л-ау лэсат афарэ дин четате. ");
INSERT INTO ron1924_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Дупэ че й-ау скос афарэ, унул дин ей а зис: „Скапэ-ць вяца; сэ ну те уйць ынапой ши сэ ну те опрешть ын вреун лок дин кымпие. Скапэ ла мунте, ка сэ ну перь.” ");
INSERT INTO ron1924_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Лот ле-а зис: „О! ну, Доамне! ");
INSERT INTO ron1924_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Ятэ кэ ам кэпэтат тречере ынаинтя Та ши ай арэтат маре ындураре фацэ де мине, пэстрынду-мь вяца, дар ну пот сэ фуг ла мунте ынаинте ка сэ мэ атингэ прэпэдул ши вой пери. ");
INSERT INTO ron1924_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Ятэ, четатя ачаста есте дестул де апроапе ка сэ фуг ын еа ши есте микэ. О! де аш путя сэ фуг аколо…, есте аша де микэ… ши сэ скап ку вяцэ!” ");
INSERT INTO ron1924_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ши Ел й-а зис: „Ятэ кэ-ць фак ши хатырул ачеста ши ну вой нимичи четатя де каре ворбешть. ");
INSERT INTO ron1924_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Грэбеште-те де фуӂь ын еа, кэч ну пот фаче нимик пынэ ну вей ажунӂе аколо.” Пентру ачея с-а пус четэций ачелея нумеле Цоар. ");
INSERT INTO ron1924_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Рэсэря соареле пе пэмынт кынд а интрат Лот ын Цоар. ");
INSERT INTO ron1924_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Атунч, Домнул а фэкут сэ плоуэ песте Содома ши песте Гомора пучоасэ ши фок де ла Домнул дин чер. ");
INSERT INTO ron1924_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","А нимичит ку десэвыршире четэциле ачеля, тоатэ кымпия ши пе тоць локуиторий четэцилор, ши тот че крештя пе пэмынт. ");
INSERT INTO ron1924_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Неваста луй Лот с-а уйтат ынапой ши с-а префэкут ынтр-ун стылп де саре. ");
INSERT INTO ron1924_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Авраам с-а скулат а доуа зи дис-де-диминяцэ ши с-а дус ла локул унде стэтусе ынаинтя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Шь-а ындрептат привириле спре Содома ши Гомора ши спре тоатэ кымпия ши ятэ кэ а вэзут ридикынду-се де пе пэмынт ун фум, ка фумул унуй куптор. ");
INSERT INTO ron1924_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Кынд а нимичит Думнезеу четэциле кымпией, Шь-а адус аминте де Авраам ши а скэпат пе Лот дин мижлокул прэпэдулуй, прин каре а сурпат дин темелие четэциле унде ышь ашезасе Лот локуинца. ");
INSERT INTO ron1924_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Лот а ешит дин Цоар ши а рэмас пе мунте ку челе доуэ фете але луй, кэч с-а темут сэ рэмынэ ын Цоар. А локуит ынтр-о пештерэ ку челе доуэ фете але луй. ");
INSERT INTO ron1924_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Чя май маре а зис челей май тинере: „Татэл ностру есте бэтрын ши ну май есте ничун бэрбат ын цинутул ачеста ка сэ интре ла ной, дупэ обичеюл тутурор цэрилор. ");
INSERT INTO ron1924_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Вино сэ пунем пе татэл ностру сэ бя вин ши сэ не кулкэм ку ел, ка сэ не пэстрэм сэмынца прин татэл ностру.” ");
INSERT INTO ron1924_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Ау фэкут дар пе татэл лор де а бэут вин ын ноаптя ачея, ши чя май маре с-а дус ши с-а кулкат ку татэл ей. Ел н-а бэгат де сямэ нич кынд с-а кулкат еа, нич кынд с-а скулат. ");
INSERT INTO ron1924_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","А доуа зи, чя май маре а зис челей май тинере: „Ятэ, еу м-ам кулкат ын ноаптя трекутэ ку татэл меу; хайдем сэ-й дэм сэ бя вин ши ын ноаптя ачаста, ши ду-те де те кулкэ ши ту ку ел, ка сэ не пэстрэм сэмынца прин татэл ностру.” ");
INSERT INTO ron1924_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Ау дат татэлуй лор де а бэут вин ши ын ноаптя ачея; апой чя май тынэрэ с-а дус ши с-а кулкат ку ел. Ел н-а бэгат де сямэ нич кынд с-а кулкат еа, нич кынд с-а скулат. ");
INSERT INTO ron1924_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Челе доуэ фете але луй Лот ау рэмас астфел ынсэрчинате де татэл лор. ");
INSERT INTO ron1924_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Чя май маре а нэскут ун фиу, кэруя й-а пус нумеле Моаб. Ел есте татэл моабицилор дин зиуа де азь. ");
INSERT INTO ron1924_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Чя май тынэрэ а нэскут ши еа ун фиу, кэруя й-а пус нумеле Бен-Амми. Ел есте татэл амоницилор дин зиуа де азь. ");
INSERT INTO ron1924_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Авраам а плекат де аколо ын цара де мязэзи, с-а ашезат ынтре Кадес ши Шур ши а локуит ка стрэин ын Герар. ");
INSERT INTO ron1924_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Авраам зичя деспре Сара, невастэ-са: „Есте сора мя!” С-а темут сэ спунэ кэ есте невастэ-са, ка сэ ну-л омоаре оамений дин четате дин причина ей. Абимелек, ымпэратул Герарулуй, а тримис ши а луат пе Сара. ");
INSERT INTO ron1924_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Атунч, Думнезеу С-а арэтат ноаптя ын вис луй Абимелек ши й-а зис: „Ятэ, ай сэ морь дин причина фемеий пе каре ай луат-о, кэч есте неваста унуй бэрбат.” ");
INSERT INTO ron1924_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Абимелек, каре ну се апропиясе де еа, а рэспунс: „Доамне, вей оморы Ту оаре кяр ши ун ням невиноват? ");
INSERT INTO ron1924_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ну мь-а спус ел кэ есте сорэ-са? Ши н-а зис еа ынсэшь кэ ел есте фрате-сэу? Еу ам лукрат ку инимэ куратэ ши ку мынь невиновате.” ");
INSERT INTO ron1924_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Думнезеу й-а зис ын вис: „Штиу ши Еу кэ ай лукрат ку инимэ куратэ, де ачея те-ам ши ферит сэ пэкэтуешть ымпотрива Мя. Ятэ де че н-ам ынгэдуит сэ те атинӂь де еа. ");
INSERT INTO ron1924_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Акум, дэ омулуй неваста ынапой, кэч ел есте пророк. Се ва руга пентру тине ши вей трэи. Дар, дакэ н-о дай ынапой, сэ штий кэ вей мури негрешит, ту ши тот че-й ал тэу.” ");
INSERT INTO ron1924_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Абимелек с-а скулат дис-де-диминяцэ, а кемат пе тоць служиторий сэй ши ле-а спус тот че се ынтымпласе. Ши оамений ачея ау фост куприншь де о маре спаймэ. ");
INSERT INTO ron1924_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Абимелек а кемат ши пе Авраам ши й-а зис: „Че не-ай фэкут? Ши ку че ам пэкэтуит еу ымпотрива та, де ай фэкут сэ винэ песте мине ши песте ымпэрэция мя ун пэкат атыт де маре? Ай фэкут фацэ де мине лукрурь каре ну требуяу ничдекум фэкуте.” ");
INSERT INTO ron1924_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Ши Абимелек а зис луй Авраам: „Че ай вэзут де ай фэкут лукрул ачеста?” ");
INSERT INTO ron1924_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Авраам а рэспунс: „Ымь зичям кэ, фэрэ ындоялэ, ну-й ничо фрикэ де Думнезеу ын цара ачаста ши кэ ау сэ мэ омоаре дин причина невестей меле. ");
INSERT INTO ron1924_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Де алтфел, есте адевэрат кэ есте сора мя, фийка татэлуй меу; нумай кэ ну-й фийка мамей меле ши а ажунс сэ-мь фие невастэ. ");
INSERT INTO ron1924_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Кынд м-а скос Думнезеу дин каса татэлуй меу, ам зис Сарей: ‘Ятэ хатырул пе каре ай сэ ми-л фачь: ын тоате локуриле унде вом мерӂе, спуне деспре мине кэ сунт фрателе тэу.’” ");
INSERT INTO ron1924_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Абимелек а луат ой ши бой, робь ши роабе ши ле-а дат луй Авраам ши й-а дат ынапой ши пе Сара, невастэ-са. ");
INSERT INTO ron1924_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Абимелек а зис: „Ятэ, цара мя есте ынаинтя та; локуеште унде-ць ва плэчя.” ");
INSERT INTO ron1924_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ши Сарей й-а зис: „Ятэ, дау фрателуй тэу о мие де арӂинць; ачаста сэ-ць фие о довадэ де чинсте фацэ де тоць чей че сунт ку тине, аша кэ ынаинтя тутурор вей фи фэрэ винэ.” ");
INSERT INTO ron1924_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Авраам с-а ругат луй Думнезеу, ши Думнезеу а ынсэнэтошит пе Абимелек, пе неваста ши роабеле луй, аша кэ ау путут сэ наскэ. ");
INSERT INTO ron1924_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Фииндкэ Домнул ынкуясе пынтечеле тутурор фемеилор дин каса луй Абимелек дин причина Сарей, неваста луй Авраам. ");
INSERT INTO ron1924_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Домнул Шь-а адус аминте де челе че спусесе Сарей ши Домнул а ымплинит фацэ де Сара че фэгэдуисе. ");
INSERT INTO ron1924_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Сара а рэмас ынсэрчинатэ ши а нэскут луй Авраам ун фиу ла бэтрынеце, ла время хотэрытэ, деспре каре-й ворбисе Думнезеу. ");
INSERT INTO ron1924_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Авраам а пус фиулуй сэу ноу-нэскут, пе каре и-л нэскусе Сара, нумеле Исаак. ");
INSERT INTO ron1924_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Авраам а тэят ымпрежур пе фиул сэу Исаак ла вырста де опт зиле, кум ый порунчисе Думнезеу. ");
INSERT INTO ron1924_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Авраам ера ын вырстэ де о сутэ де ань ла наштеря фиулуй сэу Исаак. ");
INSERT INTO ron1924_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Ши Сара а зис: „Думнезеу м-а фэкут де рыс: орьчине ва аузи ва рыде де мине.” ");
INSERT INTO ron1924_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ши а адэугат: „Чине с-ар фи гындит сэ спунэ луй Авраам кэ Сара ва да цыцэ ла копий? Ши тотушь й-ам нэскут ун фиу ла бэтрынеце!” ");
INSERT INTO ron1924_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Копилул с-а фэкут маре ши а фост ынцэркат. Авраам а фэкут ун оспэц маре ын зиуа кынд а фост ынцэркат Исаак. ");
INSERT INTO ron1924_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Сара а вэзут рызынд пе фиул пе каре-л нэскусе луй Авраам еӂиптянка Агар. ");
INSERT INTO ron1924_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Ши а зис луй Авраам: „Изгонеште пе роаба ачаста ши пе фиул ей, кэч фиул роабей ачестея ну ва моштени ымпреунэ ку фиул меу, ку Исаак.” ");
INSERT INTO ron1924_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Кувинтеле ачестя н-ау плэкут делок луй Авраам, дин причина фиулуй сэу. ");
INSERT INTO ron1924_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Дар Думнезеу а зис луй Авраам: „Сэ ну те мыхнешть де кувинтеле ачестя, дин причина копилулуй ши дин причина роабей тале; фэ Сарей тот че-ць чере, кэч нумай дин Исаак ва еши о сэмынцэ каре ва пурта ку адевэрат нумеле тэу. ");
INSERT INTO ron1924_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Дар ши пе фиул роабей тале ыл вой фаче ун ням, кэч есте сэмынца та.” ");
INSERT INTO ron1924_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","А доуа зи, Авраам с-а скулат де диминяцэ, а луат пыне ши ун бурдуф ку апэ, пе каре и л-а дат Агарей ши и л-а пус пе умэр; й-а дат ши копилул ши й-а дат друмул. Еа а плекат ши а рэтэчит прин пустиул Беер-Шеба. ");
INSERT INTO ron1924_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Кынд с-а испрэвит апа дин бурдуф, а арункат копилул суб ун туфиш ");
INSERT INTO ron1924_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","ши с-а дус де а шезут ын фаца луй ла о микэ депэртаре де ел, ка ла о арункэтурэ де арк, кэч зичя еа: „Сэ ну вэд моартя копилулуй!” А шезут дар ын фаца луй ла о парте, а ридикат гласул ши а ынчепут сэ плынгэ. ");
INSERT INTO ron1924_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Думнезеу а аузит гласул копилулуй, ши Ынӂерул луй Думнезеу а стригат дин чер пе Агар ши й-а зис: „Че ай ту, Агар? Ну те теме, кэч Думнезеу а аузит гласул копилулуй ын локул унде есте. ");
INSERT INTO ron1924_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Скоалэ-те, я копилул ши цине-л де мынэ, кэч вой фаче дин ел ун ням маре.” ");
INSERT INTO ron1924_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Ши Думнезеу й-а дескис окий ши еа а вэзут ун извор де апэ; с-а дус де а умплут бурдуфул ку апэ ши а дат копилулуй сэ бя. ");
INSERT INTO ron1924_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Думнезеу а фост ку копилул, каре а крескут, а локуит ын пустиу ши а ажунс вынэтор ку аркул. ");
INSERT INTO ron1924_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","А локуит ын пустиул Паран ши мама са й-а луат о невастэ дин цара Еӂиптулуй. ");
INSERT INTO ron1924_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Ын время ачея, Абимелек, ынсоцит де Пикол, кэпетения оштирий луй, а ворбит астфел луй Авраам: „Думнезеу есте ку тине ын тот че фачь. ");
INSERT INTO ron1924_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Журэ-мь акум, аич, пе Нумеле луй Думнезеу, кэ ну мэ вей ыншела ничодатэ, нич пе мине, нич пе копиий мей, нич пе непоций мей, ши кэ вей авя фацэ де мине ши фацэ де цара ын каре локуешть ка стрэин ачеяшь бунэвоинцэ пе каре о ам еу фацэ де тине.” ");
INSERT INTO ron1924_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Авраам а зис: „Жур!” ");
INSERT INTO ron1924_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Дар Авраам а бэгат винэ луй Абимелек пентру о фынтынэ де апэ, пе каре пусесерэ мына ку сила робий луй Абимелек. ");
INSERT INTO ron1924_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Абимелек а рэспунс: „Ну штиу чине а фэкут лукрул ачеста; нич ту ну мь-ай дат де штире ши нич еу ну афлу декыт азь.” ");
INSERT INTO ron1924_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Ши Авраам а луат ой ши бой, пе каре й-а дат луй Абимелек, ши ау фэкут легэмынт амындой. ");
INSERT INTO ron1924_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Авраам а пус деопарте шапте мелушеле дин турмэ. ");
INSERT INTO ron1924_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Ши Абимелек а зис луй Авраам: „Че сунт ачесте шапте мелушеле пе каре ле-ай пус деопарте?” ");
INSERT INTO ron1924_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ел а рэспунс: „Требуе сэ примешть дин мына мя ачесте шапте мелушеле, пентру ка сэ-мь служяскэ де мэртурие кэ ам сэпат фынтына ачаста.” ");
INSERT INTO ron1924_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Ятэ де че локул ачела се нумеште Беер-Шеба, кэч аколо шь-ау журат ей крединцэ унул алтуя. ");
INSERT INTO ron1924_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Астфел ау фэкут ей легэмынт ла Беер-Шеба. Дупэ ачея, Абимелек с-а скулат ымпреунэ ку Пикол, кэпетения оштирий сале, ши с-ау ынторс ын цара филистенилор. ");
INSERT INTO ron1924_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Авраам а сэдит ун тамариск ла Беер-Шеба ши а кемат аколо Нумеле Домнулуй Думнезеулуй челуй вешник. ");
INSERT INTO ron1924_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Авраам а локуит мултэ време ка стрэин ын цара филистенилор. ");
INSERT INTO ron1924_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Дупэ ачесте лукрурь, Думнезеу а пус ла ынчеркаре пе Авраам ши й-а зис: „Аврааме!” „Ятэ-мэ”, а рэспунс ел. ");
INSERT INTO ron1924_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Думнезеу й-а зис: „Я пе фиул тэу, пе сингурул тэу фиу, пе каре-л юбешть, пе Исаак; ду-те ын цара Мория ши аду-л ардере-де-тот аколо, пе ун мунте пе каре ци-л вой спуне.” ");
INSERT INTO ron1924_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Авраам с-а скулат дис-де-диминяцэ, а пус шауа пе мэгар ши а луат ку ел доуэ слуӂь ши пе фиул сэу Исаак. А тэят лемне пентру ардеря-де-тот ши а порнит спре локул пе каре и-л спусесе Думнезеу. ");
INSERT INTO ron1924_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","А трея зи, Авраам а ридикат окий ши а вэзут локул де департе. ");
INSERT INTO ron1924_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ши Авраам а зис слуӂилор сале: „Рэмынець аич ку мэгарул; еу ши бэятул не вом дуче пынэ коло сэ не ынкинэм ши апой не вом ынтоарче ла вой.” ");
INSERT INTO ron1924_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Авраам а луат лемнеле пентру ардеря-де-тот, ле-а пус ын спинаря фиулуй сэу Исаак ши а луат ын мынэ фокул ши куцитул. Ши ау мерс астфел амындой ымпреунэ. ");
INSERT INTO ron1924_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Атунч Исаак, ворбинд ку татэл сэу Авраам, а зис: „Татэ!” „Че есте, фиуле?” й-а рэспунс ел. Исаак а зис дин ноу: „Ятэ фокул ши лемнеле, дар унде есте мелул пентру ардеря-де-тот?” ");
INSERT INTO ron1924_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","„Фиуле”, а рэспунс Авраам, „Думнезеу Ынсушь ва пурта грижэ де мелул пентру ардеря-де-тот.” Ши ау мерс амындой ымпреунэ ынаинте. ");
INSERT INTO ron1924_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Кынд ау ажунс ла локул пе каре и-л спусесе Думнезеу, Авраам а зидит аколо ун алтар ши а ашезат лемнеле пе ел. А легат пе фиул сэу Исаак ши л-а пус пе алтар, дясупра лемнелор. ");
INSERT INTO ron1924_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Апой, Авраам а ынтинс мына ши а луат куцитул, ка сэ ынжунгие пе фиул сэу. ");
INSERT INTO ron1924_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Атунч, Ынӂерул Домнулуй л-а стригат дин черурь ши а зис: „Аврааме! Аврааме!” „Ятэ-мэ!” а рэспунс ел. ");
INSERT INTO ron1924_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Ынӂерул а зис: „Сэ ну пуй мына пе бэят ши сэ ну-й фачь нимик; кэч штиу акум кэ те темь де Думнезеу, ынтрукыт н-ай круцат пе фиул тэу, пе сингурул тэу фиу, пентру Мине.” ");
INSERT INTO ron1924_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Авраам а ридикат окий ши а вэзут ынапоя луй ун бербек ынкуркат ку коарнеле ынтр-ун туфиш, ши Авраам с-а дус де а луат бербекул ши л-а адус ка ардере-де-тот ын локул фиулуй сэу. ");
INSERT INTO ron1924_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Авраам а пус локулуй ачелуя нумеле: „Домнул ва пурта де грижэ”. Де ачея се зиче ши азь: „Ла мунтеле унде Домнул ва пурта де грижэ”. ");
INSERT INTO ron1924_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Ынӂерул Домнулуй а кемат а доуа оарэ дин черурь пе Авраам ");
INSERT INTO ron1924_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","ши а зис: „‘Пе Мине Ынсумь жур’, зиче Домнул, ‘пентру кэ ай фэкут лукрул ачеста ши н-ай круцат пе фиул тэу, пе сингурул тэу фиу, ");
INSERT INTO ron1924_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","те вой бинекувынта фоарте мулт ши-ць вой ынмулци фоарте мулт сэмынца, ши ануме: ка стелеле черулуй ши ка нисипул де пе цэрмул мэрий, ши сэмынца та ва стэпыни четэциле врэжмашилор ей. ");
INSERT INTO ron1924_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Тоате нямуриле пэмынтулуй вор фи бинекувынтате ын сэмынца та, пентру кэ ай аскултат де порунка Мя!’” ");
INSERT INTO ron1924_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Авраам с-а ынторс ла слуӂиле сале ши с-ау скулат ши ау плекат ымпреунэ ла Беер-Шеба, кэч Авраам локуя ла Беер-Шеба. ");
INSERT INTO ron1924_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Дупэ ачесте лукрурь, и с-а спус луй Авраам: „Ятэ, Милка а нэскут ши еа копий фрателуй тэу Нахор, ");
INSERT INTO ron1924_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","ши ануме пе Уц, ынтыюл сэу нэскут, пе Буз, фрателе сэу, пе Кемуел, татэл луй Арам, ");
INSERT INTO ron1924_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","пе Кесед, пе Хазо, пе Пилдаш, пе Иидлаф ши пе Бетуел. ");
INSERT INTO ron1924_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Бетуел а нэскут пе Ребека. Ачештя сунт чей опт фий пе каре й-а нэскут Милка луй Нахор, фрателе луй Авраам.” ");
INSERT INTO ron1924_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Циитоаря луй, нумитэ Реума, а нэскут ши еа пе Тебах, Гахам, Тахаш ши Маака. ");
INSERT INTO ron1924_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Вяца Сарей а фост де о сутэ доуэзечь ши шапте де ань: ачештя сунт аний веций Сарей. ");
INSERT INTO ron1924_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Сара а мурит ла Кириат-Арба, адикэ Хеброн, ын цара Канаан, ши Авраам а венит сэ желяскэ пе Сара ши с-о плынгэ. ");
INSERT INTO ron1924_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Авраам с-а скулат апой динаинтя моартей сале ши а ворбит астфел фиилор луй Хет: ");
INSERT INTO ron1924_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","„Еу сунт стрэин ши венетик принтре вой; даци-мь ун огор, ка лок де ынгропаре ла вой, ка сэ-мь ынгроп моарта ши с-о ридик динаинтя мя.” ");
INSERT INTO ron1924_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Фиий луй Хет ау рэспунс астфел луй Авраам: ");
INSERT INTO ron1924_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","„Аскултэ-не, домнуле! Ту ешть ка ун домнитор ал луй Думнезеу ын мижлокул ностру; ынгроапэ-ць моарта ын чел май бун дин морминтеле ноастре! Ничунул дин ной ну те ва опри сэ-ць ынгропь моарта ын мормынтул луй.” ");
INSERT INTO ron1924_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Авраам с-а скулат ши с-а арункат ку фаца ла пэмынт ынаинтя нородулуй цэрий, адикэ ынаинтя фиилор луй Хет. ");
INSERT INTO ron1924_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Ши ле-а ворбит астфел: „Дакэ гэсиць ку кале сэ-мь ынгроп моарта ши с-о яу динаинтя окилор мей, аскултаци-мэ ши ругаць пентру мине пе Ефрон, фиул луй Цохар, ");
INSERT INTO ron1924_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","сэ-мь дя пештера Макпела, каре-й а луй ши каре есте кяр ла марӂиня огорулуй луй; сэ мь-о дя ын скимбул прецулуй ей, ка сэ-мь служяскэ дрепт лок пентру ынгропаре ын мижлокул востру.” ");
INSERT INTO ron1924_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ефрон ера ши ел аколо, ын мижлокул фиилор луй Хет. Ши Ефрон, Хетитул, а рэспунс луй Авраам ын аузул фиилор луй Хет ши ын аузул тутурор челор че тречяу пе поарта четэций: ");
INSERT INTO ron1924_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","„Ну, домнул меу, аскултэ-мэ! Ыць дэруеск огорул ши-ць дэруеск ши пештера каре есте ын ел. Ци ле дэруеск ын фаца фиилор нородулуй меу: ши ынгроапэ-ць моарта.” ");
INSERT INTO ron1924_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Авраам с-а арункат ку фаца ла пэмынт ынаинтя нородулуй цэрий. ");
INSERT INTO ron1924_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Ши а ворбит астфел луй Ефрон ын аузул нородулуй цэрий: „Аскултэ-мэ, те рог! Ыць дау прецул огорулуй. Примеште-л де ла мине ши-мь вой ынгропа моарта ын ел.” ");
INSERT INTO ron1924_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ши Ефрон а рэспунс астфел луй Авраам: ");
INSERT INTO ron1924_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","„Домнул меу, аскултэ-мэ! О букатэ де пэмынт де патру суте де сикли де арӂинт – че есте ачаста ынтре мине ши тине? Ынгроапэ-ць дар моарта!” ");
INSERT INTO ron1924_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Авраам а ынцелес пе Ефрон. Ши Авраам а кынтэрит луй Ефрон прецул кумпэрэрий деспре каре ворбисе, ын фаца фиилор луй Хет: патру суте де сикли де арӂинт, каре мерӂяу ла орьче негустор. ");
INSERT INTO ron1924_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Огорул луй Ефрон дин Макпела, каре есте фацэ ын фацэ ку Мамре, огорул ши пештера дин ел ши тоць копачий каре се афлау ын огор ши ын тоате хотареле луй де жур ымпрежур ");
INSERT INTO ron1924_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","ау фост ынтэрите астфел ка мошие а луй Авраам, ын фаца фиилор луй Хет ши а тутурор челор че тречяу пе поарта четэций. ");
INSERT INTO ron1924_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Дупэ ачея, Авраам а ынгропат пе Сара, невастэ-са, ын пештера дин огорул Макпела, каре есте фацэ ын фацэ ку Мамре, адикэ Хеброн, ын цара Канаан. ");
INSERT INTO ron1924_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Огорул ши пештера дин ел ау фост ынтэрите астфел луй Авраам, ка огор пентру ынмормынтаре, де кэтре фиий луй Хет. ");
INSERT INTO ron1924_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Авраам ера бэтрын, ынаинтат ын вырстэ, ши Домнул бинекувынтасе пе Авраам ын орьче лукру. ");
INSERT INTO ron1924_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Авраам а зис челуй май бэтрын роб дин каса луй, каре ера ынгрижиторул тутурор аверилор луй: „Пуне-ць, те рог, мына суб коапса мя ");
INSERT INTO ron1924_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ши те вой пуне сэ журь пе Домнул Думнезеул черулуй ши Думнезеул пэмынтулуй кэ ну вей луа фиулуй меу о невастэ динтре фетеле канааницилор ын мижлокул кэрора локуеск, ");
INSERT INTO ron1924_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","чи те вей дуче ын цара ши ла руделе меле сэ ей невастэ фиулуй меу Исаак.” ");
INSERT INTO ron1924_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Робул й-а рэспунс: „Поате кэ фемея н-аре сэ вря сэ мэ урмезе ын цара ачаста. Ва требуи сэ дук оаре пе фиул тэу ын цара де унде ай ешит ту?” ");
INSERT INTO ron1924_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Авраам й-а зис: „Сэ ну каре кумва сэ дучь пе фиул меу аколо! ");
INSERT INTO ron1924_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Домнул Думнезеул черулуй, каре м-а скос дин каса татэлуй меу ши дин патрия мя, каре мь-а ворбит ши мь-а журат зикынд: ‘Семинцей тале вой да цара ачаста’, ва тримите пе Ынӂерул Сэу ынаинтя та, ши де аколо вей луа о невастэ фиулуй меу. ");
INSERT INTO ron1924_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Дакэ фемея ну ва вря сэ те урмезе, вей фи дезлегат де журэмынтул ачеста пе каре те пун сэ-л фачь. Ку ничун кип сэ ну дучь ынсэ аколо пе фиул меу.” ");
INSERT INTO ron1924_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Робул шь-а пус мына суб коапса стэпынулуй сэу Авраам ши й-а журат кэ аре сэ пэзяскэ ачесте лукрурь. ");
INSERT INTO ron1924_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Робул а луат зече кэмиле динтре кэмилеле стэпынулуй сэу ши а плекат, авынд ку ел тоате лукруриле де прец але стэпынулуй сэу. С-а скулат ши а плекат ын Месопотамия, ын четатя луй Нахор. ");
INSERT INTO ron1924_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","А лэсат кэмилеле сэ се одихняскэ, ын ӂенункь, афарэ дин четате, лынгэ о фынтынэ. Ера сяра, пе время кынд ес фемеиле сэ скоатэ апэ. ");
INSERT INTO ron1924_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ши а зис: „Доамне, Думнезеул стэпынулуй меу Авраам! Те рог, дэ-мь избындэ астэзь ши ындурэ-Те де стэпынул меу Авраам. ");
INSERT INTO ron1924_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ятэ, стау лынгэ изворул ачеста де апэ, ши фетеле оаменилор дин четате вин сэ скоатэ апэ. ");
INSERT INTO ron1924_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Фэ ка фата кэрея ый вой зиче: ‘Плякэ-ць вадра, те рог, ка сэ бяу’ ши каре ва рэспунде: ‘Бя ши ам сэ дау де бэут ши кэмилелор тале’ сэ фие ачея пе каре ай рындуит-о Ту пентру робул Тэу Исаак! Ши прин ачаста вой куноаште кэ Те-ай ындурат де стэпынул меу.” ");
INSERT INTO ron1924_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Ну сфыршисе ел ынкэ де ворбит ши а ешит ку вадра пе умэр Ребека, фата луй Бетуел, фиул Милкэй, неваста луй Нахор, фрателе луй Авраам. ");
INSERT INTO ron1924_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Фата ера фоарте фрумоасэ, ера фечоарэ ши ничун бэрбат н-авусесе легэтурь ку еа. Еа с-а коборыт ла извор, шь-а умплут вадра ши с-а суит ярэшь. ");
INSERT INTO ron1924_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Робул а алергат ынаинтя ей ши а зис: „Дэ-мь, те рог, сэ бяу пуцинэ апэ дин вадра та.” ");
INSERT INTO ron1924_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","„Бя, домнул меу”, а рэспунс еа. Ши с-а грэбит де а плекат вадра пе мынэ ши й-а дат сэ бя. ");
INSERT INTO ron1924_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Дупэ че й-а дат ши а бэут де с-а сэтурат, а зис: „Ам сэ скот апэ ши пентру кэмилеле тале, пынэ вор бя ши се вор сэтура.” ");
INSERT INTO ron1924_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","А вэрсат ын грабэ вадра ын адэпэтоаре ши а алергат ярэшь ла фынтынэ ка сэ скоатэ апэ ши а скос пентру тоате кэмилеле луй. ");
INSERT INTO ron1924_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Омул о привя ку мираре ши фэрэ сэ зикэ нимик, ка сэ вадэ дакэ Домнул а фэкут сэ-й избутяскэ сау ну кэлэтория. ");
INSERT INTO ron1924_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Кынд с-ау сэтурат кэмилеле де бэут, омул а луат о веригэ де аур де греутатя уней жумэтэць де сиклу ши доуэ брэцэрь греле де зече сикли де аур. ");
INSERT INTO ron1924_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Ши а зис: „А куй фатэ ешть? Спуне-мь, те рог. Есте лок пентру ной ын каса татэлуй тэу, ка сэ рэмынем песте ноапте?” ");
INSERT INTO ron1924_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Еа а рэспунс: „Еу сунт фата луй Бетуел, фиул Милкэй ши ал луй Нахор.” ");
INSERT INTO ron1924_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ши й-а зис май департе: „Авем пае ши нутрец дин белшуг ши есте ши лок де гэздуит песте ноапте.” ");
INSERT INTO ron1924_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Атунч, омул а плекат капул ши с-а арункат ку фаца ла пэмынт ынаинтя Домнулуй, ");
INSERT INTO ron1924_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","зикынд: „Бинекувынтат сэ фие Домнул Думнезеул стэпынулуй меу Авраам, каре н-а пэрэсит ындураря ши крединчошия Луй фацэ де стэпынул меу! Домнул м-а ындрептат ын каса фрацилор стэпынулуй меу.” ");
INSERT INTO ron1924_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Фата а алергат ши а историсит мамей сале акасэ челе ынтымплате. ");
INSERT INTO ron1924_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Ребека авя ун фрате, нумит Лабан. Ши Лабан а алергат афарэ ла омул ачела, ла извор. ");
INSERT INTO ron1924_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Вэзусе верига ши брэцэриле ын мыниле сурорий сале ши аузисе пе сорэ-са Ребека спунынд: „Аша мь-а ворбит омул ачела.” А венит дар ла омул ачела, каре стэтя лынгэ кэмиле ла извор, ");
INSERT INTO ron1924_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","ши а зис: „Вино, бинекувынтатул Домнулуй! Пентру че стай афарэ? Ам прегэтит каса ши ам прегэтит ун лок пентру кэмиле.” ");
INSERT INTO ron1924_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Омул а интрат ын касэ. Лабан а пус сэ дескарче кэмилеле, а дат пае ши нутрец кэмилелор ши а адус апэ пентру спэлат пичоареле омулуй ачелуя ши але оаменилор каре ерау ку ел. ");
INSERT INTO ron1924_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Апой, й-а дат сэ мэнынче. Дар ел а зис: „Ну мэнынк пынэ ну вой спуне че ам де спус.” „Ворбеште!” а зис Лабан. ");
INSERT INTO ron1924_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Атунч, ел а зис: „Еу сунт робул луй Авраам. ");
INSERT INTO ron1924_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Домнул а умплут де бинекувынтэрь пе стэпынул меу, каре а ажунс ла маре пропэшире. Й-а дат ой ши бой, арӂинт ши аур, робь ши роабе, кэмиле ши мэгарь. ");
INSERT INTO ron1924_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Сара, неваста стэпынулуй меу, а нэскут ла бэтрынеце ун фиу стэпынулуй меу ши луй й-а дат ел тот че аре. ");
INSERT INTO ron1924_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Стэпынул меу м-а пус сэ жур ши а зис: ‘Сэ ну ей фиулуй меу о невастэ динтре фетеле канааницилор, ын цара кэрора локуеск, ");
INSERT INTO ron1924_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","чи сэ те дучь ын каса татэлуй меу ши ла руделе меле, ка де аколо сэ ей невастэ фиулуй меу.’ ");
INSERT INTO ron1924_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Еу ам зис стэпынулуй меу: ‘Поате кэ фемея н-аре сэ вря сэ мэ урмезе.’ ");
INSERT INTO ron1924_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ши ел мь-а рэспунс: ‘Домнул, ынаинтя кэруя умблу, ва тримите пе Ынӂерул Сэу ку тине ши-ць ва да избындэ ын кэлэторие ши вей луа фиулуй меу о невастэ дин руделе ши дин каса татэлуй меу. ");
INSERT INTO ron1924_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Вей фи дезлегат де журэмынтул пе каре ми-л фачь дакэ те вей дуче ла руделе меле ши, дакэ ну ць-о вор да, вей фи дезлегат де журэмынтул пе каре ми-л фачь.’ ");
INSERT INTO ron1924_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Еу ам ажунс азь ла извор ши ам зис: ‘Доамне, Думнезеул стэпынулуй меу Авраам, дакэ биневоешть сэ-мь дай избындэ ын кэлэтория пе каре о фак, ");
INSERT INTO ron1924_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","ятэ, еу стау ла изворул де апэ, ши фата каре ва еши сэ скоатэ апэ ши кэрея ый вой зиче: «Дэ-мь, те рог, сэ бяу пуцинэ апэ дин вадра та» ");
INSERT INTO ron1924_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ши каре ымь ва рэспунде: «Бя ту ынсуць ши вой да де бэут ши кэмилелор тале», фата ачея сэ фие неваста пе каре а рындуит-о Домнул пентру фиул стэпынулуй меу!’ ");
INSERT INTO ron1924_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Ынаинте де а сфырши де ворбит ын инима мя, ятэ кэ а ешит Ребека ку вадра пе умэр, с-а коборыт ла извор ши а скос апэ. Еу й-ам зис: ‘Дэ-мь сэ бяу, те рог.’ ");
INSERT INTO ron1924_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Еа с-а грэбит, шь-а плекат вадра дясупра умэрулуй ши а зис: ‘Бя ши вой да де бэут ши кэмилелор тале.’ Ам бэут ши а дат де бэут ши кэмилелор меле. ");
INSERT INTO ron1924_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Еу ам ынтребат-о ши ам зис: ‘А куй фатэ ешть?’ Еа а рэспунс: ‘Сунт фата луй Бетуел, фиул луй Нахор ши ал Милкэй.’ Й-ам пус верига ын нас ши брэцэриле ла мынь. ");
INSERT INTO ron1924_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Апой ам плекат капул, м-ам арункат ку фаца ла пэмынт ынаинтя Домнулуй ши ам бинекувынтат пе Домнул Думнезеул стэпынулуй меу Авраам кэ м-а кэлэузит пе каля чя дряптэ, ка сэ яу пе фата фрателуй стэпынулуй меу пентру фиул луй. ");
INSERT INTO ron1924_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Акум, дакэ воиць сэ арэтаць бунэвоинцэ ши крединчошие фацэ де стэпынул меу, спунеци-мь; дакэ ну, спунеци-мь ярэшь, ка сэ мэ ындрепт ла дряпта сау ла стынга.” ");
INSERT INTO ron1924_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Лабан ши Бетуел, дрепт рэспунс, ау зис: „Де ла Домнул вине лукрул ачеста; ной ну-ць май путем спуне нич рэу, нич бине. ");
INSERT INTO ron1924_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Ятэ, Ребека есте ынаинтя та; я-о ши ду-те, ка сэ фие неваста фиулуй стэпынулуй тэу, кум а спус Домнул.” ");
INSERT INTO ron1924_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Кынд а аузит робул луй Авраам кувинтеле лор, с-а арункат ку фаца ла пэмынт ынаинтя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Ши робул а скос скуле де арӂинт, скуле де аур ши ымбрэкэминте, пе каре ле-а дат Ребекэй; а дат, де асеменя, дарурь богате фрателуй сэу ши мамей сале. ");
INSERT INTO ron1924_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Дупэ ачея, ау мынкат ши ау бэут, ел ши оамений каре ерау ымпреунэ ку ел, ши с-ау кулкат. Диминяца кынд с-ау скулат, робул а зис: „Лэсаци-мэ сэ мэ ынторк ла стэпынул меу.” ");
INSERT INTO ron1924_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Фрателе ши мама фетей ау зис: „Фата сэ май рэмынэ кытва тимп ку ной, мэкар врео зече зиле: пе урмэ, поате сэ плече.” ");
INSERT INTO ron1924_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ел ле-а рэспунс: „Ну мэ оприць, фииндкэ Домнул мь-а дат избындэ ын кэлэтория мя; лэсаци-мэ сэ плек ши сэ мэ дук ла стэпынул меу.” ");
INSERT INTO ron1924_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Атунч, ей ау рэспунс: „Сэ кемэм пе фатэ ши с-о ынтребэм.” ");
INSERT INTO ron1924_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ау кемат дар пе Ребека ши й-ау зис: „Врей сэ те дучь ку омул ачеста?” „Да, вряу”, а рэспунс еа. ");
INSERT INTO ron1924_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Ши ау лэсат пе сора лор Ребека сэ плече ку дойка ей, ку робул луй Авраам ши ку оамений луй. ");
INSERT INTO ron1924_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ау бинекувынтат пе Ребека ши й-ау зис: „О, сора ноастрэ, сэ ажунӂь мама а мий де зечь де мий ши сэмынца та сэ стэпыняскэ четэциле врэжмашилор сэй!” ");
INSERT INTO ron1924_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Ребека с-а скулат, ымпреунэ ку служничеле ей, ау ынкэлекат пе кэмиле ши ау урмат пе омул ачела. Робул а луат пе Ребека ши а плекат. ");
INSERT INTO ron1924_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Исаак се ынторсесе де ла фынтына Лахай-Рой, кэч локуя ын цара де мязэзи. ");
INSERT INTO ron1924_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ынтр-о сярэ, кынд Исаак ешисе сэ куӂете ын тайнэ пе кымп, а ридикат окий ши с-а уйтат; ши ятэ кэ веняу ниште кэмиле. ");
INSERT INTO ron1924_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ребека а ридикат ши еа окий, а вэзут пе Исаак ши с-а дат жос де пе кэмилэ. ");
INSERT INTO ron1924_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Ши а зис робулуй: „Чине есте омул ачеста каре вине ынаинтя ноастрэ пе кымп?” Робул а рэспунс: „Есте стэпынул меу!” Атунч, еа шь-а луат марама ши с-а акоперит. ");
INSERT INTO ron1924_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Робул а историсит луй Исаак тоате лукруриле пе каре ле фэкусе. ");
INSERT INTO ron1924_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Исаак а дус пе Ребека ын кортул мамей сале Сара; а луат пе Ребека, еа а фост неваста луй, ши ел а юбит-о. Астфел а фост мынгыят Исаак пентру пердеря мамей сале. ");
INSERT INTO ron1924_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Авраам а май луат о невастэ, нумитэ Кетура. ");
INSERT INTO ron1924_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Еа й-а нэскут пе Зимран, пе Иокшан, пе Медан, пе Мадиан, пе Ишбак ши Шуах. ");
INSERT INTO ron1924_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Иокшан а нэскут пе Себа ши пе Дедан. Фиий луй Дедан ау фост ашуримий, летушимий ши леумимий. ");
INSERT INTO ron1924_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Фиий луй Мадиан ау фост: Ефа, Ефер, Енох, Абида ши Елдаа. Тоць ачештя сунт фиий Кетурей. ");
INSERT INTO ron1924_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Авраам а дат луй Исаак тоате авериле сале. ");
INSERT INTO ron1924_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Дар а дат дарурь фиилор циитоарелор сале ши, пе кынд ера ынкэ ын вяцэ, й-а ындепэртат де лынгэ фиул сэу Исаак ынспре рэсэрит, ын Цара Рэсэритулуй. ");
INSERT INTO ron1924_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Ятэ зилеле анилор веций луй Авраам: ел а трэит о сутэ шаптезечь ши чинч де ань. ");
INSERT INTO ron1924_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Авраам шь-а дат духул ши а мурит дупэ о бэтрынеце феричитэ, ынаинтат ын вырстэ ши сэтул де зиле, ши а фост адэугат ла попорул сэу. ");
INSERT INTO ron1924_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Исаак ши Исмаел, фиий сэй, л-ау ынгропат ын пештера Макпела, ын огорул луй Ефрон, фиул луй Цохар, Хетитул, каре есте фацэ ын фацэ ку Мамре. ");
INSERT INTO ron1924_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Ачеста есте огорул пе каре-л кумпэрасе Авраам де ла фиий луй Хет. Аколо ау фост ынгропаць Авраам ши невастэ-са Сара. ");
INSERT INTO ron1924_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Дупэ моартя луй Авраам, Думнезеу а бинекувынтат пе фиул сэу Исаак. Ел локуя лынгэ фынтына Лахай-Рой. ");
INSERT INTO ron1924_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ятэ спица нямулуй луй Исмаел, фиул луй Авраам, пе каре-л нэскусе луй Авраам еӂиптянка Агар, роаба Сарей. ");
INSERT INTO ron1924_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ятэ нумеле фиилор луй Исмаел, дупэ нумеле лор, дупэ нямуриле лор: Небаиот, ынтыюл нэскут ал луй Исмаел, Кедар, Адбеел, Мибсам, ");
INSERT INTO ron1924_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Мишма, Дума, Маса, ");
INSERT INTO ron1924_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Хадад, Тема, Иетур, Нафиш ши Кедма. ");
INSERT INTO ron1924_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ачештя сунт фиий луй Исмаел; ачестя сунт нумеле лор, дупэ сателе ши табереле лор. Ей ау фост чей дойспрезече воевозь, дупэ нямуриле лор. ");
INSERT INTO ron1924_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ши ятэ аний веций луй Исмаел: о сутэ трейзечь ши шапте де ань. Ел шь-а дат духул ши а мурит ши а фост адэугат ла попорул сэу. ");
INSERT INTO ron1924_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Фиий луй ау локуит де ла Хавила пынэ ла Шур, каре есте ын фаца Еӂиптулуй, кум мерӂь спре Асирия. Ел с-а ашезат ын фаца тутурор фрацилор луй. ");
INSERT INTO ron1924_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ятэ спица нямулуй луй Исаак, фиул луй Авраам. Авраам а нэскут пе Исаак. ");
INSERT INTO ron1924_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Исаак ера ын вырстэ де патрузечь де ань кынд а луат де невастэ пе Ребека, фата луй Бетуел, Арамеул дин Падан-Арам, ши сора луй Лабан, Арамеул. ");
INSERT INTO ron1924_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Исаак с-а ругат Домнулуй пентру невастэ-са, кэч ера стярпэ, ши Домнул л-а аскултат: невастэ-са Ребека а рэмас ынсэрчинатэ. ");
INSERT INTO ron1924_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Копиий се бэтяу ын пынтечеле ей, ши еа а зис: „Дакэ-й аша, пентру че май сунт ынсэрчинатэ?” С-а дус сэ ынтребе пе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Ши Домнул й-а зис: „Доуэ нямурь сунт ын пынтечеле тэу, Ши доуэ нороаде се вор деспэрци ла еширя дин пынтечеле тэу. Унул дин нороаделе ачестя ва фи май таре декыт челэлалт. Ши чел май маре ва служи челуй май мик.” ");
INSERT INTO ron1924_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","С-ау ымплинит зилеле кынд авя сэ наскэ ши ятэ кэ ын пынтечеле ей ерау дой ӂемень. ");
INSERT INTO ron1924_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Чел динтый а ешит рошу де тот, ка о манта де пэр, ши де ачея й-ау пус нумеле Есау. ");
INSERT INTO ron1924_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Апой а ешит фрателе сэу, каре циня ку мына де кэлкый пе Есау, ши де ачея й-ау пус нумеле Иаков. Исаак ера ын вырстэ де шайзечь де ань кынд с-ау нэскут ей. ");
INSERT INTO ron1924_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Бэеций ачештя с-ау фэкут марь. Есау а ажунс ун вынэтор ындемынатик, ун ом каре ышь петречя время май мулт пе кымп, дар Иаков ера ун ом лиништит, каре стэтя акасэ ын кортурь. ");
INSERT INTO ron1924_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Исаак юбя пе Есау, пентру кэ мынка дин вынатул луй; Ребека ынсэ юбя май мулт пе Иаков. ");
INSERT INTO ron1924_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Одатэ, пе кынд фербя Иаков о чорбэ, Есау с-а ынторс де ла кымп рупт де обосялэ. ");
INSERT INTO ron1924_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ши Есау а зис луй Иаков: „Дэ-мь, те рог, сэ мэнынк дин чорба ачаста рошиатикэ, фииндкэ сунт рупт де обосялэ.” Пентру ачея с-а дат луй Есау нумеле Едом. ");
INSERT INTO ron1924_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Иаков а зис: „Винде-мь азь дрептул тэу де ынтый нэскут!” ");
INSERT INTO ron1924_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Есау а рэспунс: „Ятэ-мэ, сунт пе моарте; ла че-мь служеште дрептул ачеста де ынтый нэскут?” ");
INSERT INTO ron1924_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Ши Иаков а зис: „Журэ-мь ынтый.” Есау й-а журат ши астфел шь-а вындут дрептул де ынтый нэскут луй Иаков. ");
INSERT INTO ron1924_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Атунч, Иаков а дат луй Есау пыне ши чорбэ де линте. Ел а мынкат ши а бэут; апой с-а скулат ши а плекат. Астфел шь-а несокотит Есау дрептул де ынтый нэскут. ");
INSERT INTO ron1924_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ын царэ а венит о фоамете, афарэ де фоаметя динтый, каре фусесе пе время луй Авраам. Исаак с-а дус ла Абимелек, ымпэратул филистенилор, ла Герар. ");
INSERT INTO ron1924_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Домнул и С-а арэтат ши й-а зис: „Ну те коборы ын Еӂипт! Рэмый ын цара ын каре ыць вой спуне. ");
INSERT INTO ron1924_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Локуеште ка стрэин ын цара ачаста. Еу вой фи ку тине ши те вой бинекувынта, кэч тоате цинутуриле ачестя ци ле вой да цие ши семинцей тале ши вой цине журэмынтул пе каре л-ам фэкут татэлуй тэу Авраам. ");
INSERT INTO ron1924_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ыць вой ынмулци сэмынца ка стелеле черулуй; вой да семинцей тале тоате цинутуриле ачестя ши тоате нямуриле пэмынтулуй вор фи бинекувынтате ын сэмынца та, ка рэсплатэ ");
INSERT INTO ron1924_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","пентру кэ Авраам а аскултат де порунка Мя ши а пэзит че й-ам черут, а пэзит порунчиле Меле, орындуириле Меле ши леӂиле Меле.” ");
INSERT INTO ron1924_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Астфел, Исаак а рэмас ла Герар. ");
INSERT INTO ron1924_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Кынд ый пуняу оамений локулуй ачелуя ынтребэрь ку привире ла неваста луй, ел зичя: „Есте сора мя.” Кэч ый ера фрикэ сэ спунэ кэ есте невастэ-са, ка сэ ну-л омоаре оамений локулуй ачелуя, фииндкэ Ребека ера фрумоасэ ла кип. ");
INSERT INTO ron1924_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Фииндкэ шедеря луй аколо се лунӂисе, с-а ынтымплат кэ Абимелек, ымпэратул филистенилор, уйтынду-се пе ферястрэ, а вэзут пе Исаак жукынду-се ку невастэ-са Ребека. ");
INSERT INTO ron1924_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Абимелек а тримис сэ кеме пе Исаак ши й-а зис: „Ну май ынкапе ындоялэ кэ е невастэ-та. Кум ай путут зиче: ‘Е сорэ-мя’?” Исаак й-а рэспунс: „Ам зис аша, ка сэ ну мор дин причина ей.” ");
INSERT INTO ron1924_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Ши Абимелек а зис: „Че не-ай фэкут? Че ушор с-ар фи путут ка вреунул дин нород сэ се кулче ку невастэ-та ши не-ай фи фэкут виноваць.” ");
INSERT INTO ron1924_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Атунч, Абимелек а дат урмэтоаря порункэ ынтрегулуй нород: „Чине се ва атинӂе де омул ачеста сау де неваста луй ва фи оморыт.” ");
INSERT INTO ron1924_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Исаак а фэкут семэнэтурь ын цара ачея ши а стрынс род ынсутит ын анул ачела, кэч Домнул л-а бинекувынтат. ");
INSERT INTO ron1924_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Астфел, омул ачеста с-а ымбогэцит ши а мерс ымбогэцинду-се дин че ын че май мулт, пынэ че а ажунс фоарте богат. ");
INSERT INTO ron1924_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Авя чирезь де вите ши турме де ой ши ун маре нумэр де робь, де ачея филистений ыл пизмуяу. ");
INSERT INTO ron1924_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Тоате фынтыниле пе каре ле сэпасерэ робий татэлуй сэу пе время татэлуй сэу Авраам, филистений ле-ау аступат ши ле-ау умплут ку цэрынэ. ");
INSERT INTO ron1924_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ши Абимелек а зис луй Исаак: „Плякэ де ла ной, кэч ай ажунс мулт май путерник декыт ной.” ");
INSERT INTO ron1924_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Исаак а плекат де аколо ши а тэбэрыт ын валя Герар, унде с-а ашезат ку локуинца. ");
INSERT INTO ron1924_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Исаак а сэпат дин ноу фынтыниле де апэ пе каре ле сэпасерэ робий татэлуй сэу Авраам ши пе каре ле аступасерэ филистений дупэ моартя луй Авраам, ши ле-а пус ярэшь ачеляшь нуме пе каре ле пусесе татэл сэу. ");
INSERT INTO ron1924_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Робий луй Исаак ау май сэпат ын вале ши ау дат аколо песте о фынтынэ ку апэ де извор. ");
INSERT INTO ron1924_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Пэсторий дин Герар с-ау чертат ынсэ ку пэсторий луй Исаак, зикынд: „Апа есте а ноастрэ.” Ши а пус фынтыний нумеле Есек, пентру кэ се чертасерэ ку ел. ");
INSERT INTO ron1924_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Апой ау сэпат о алтэ фынтынэ, пентру каре яр ау фэкут гылчавэ, де ачея а нумит-о Ситна. ");
INSERT INTO ron1924_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Пе урмэ с-а мутат де аколо ши а сэпат о алтэ фынтынэ, пентру каре ну с-ау май чертат, ши а нумит-о Рехобот, „кэч”, а зис ел, „Домнул не-а фэкут лок ларг, ка сэ не путем ынтинде ын царэ”. ");
INSERT INTO ron1924_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Де аколо с-а суит ла Беер-Шеба. ");
INSERT INTO ron1924_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Домнул и С-а арэтат кяр ын ноаптя ачея ши й-а зис: „Еу сунт Думнезеул татэлуй тэу Авраам; ну те теме, кэч Еу сунт ку тине. Те вой бинекувынта ши ыць вой ынмулци сэмынца дин причина робулуй Меу Авраам.” ");
INSERT INTO ron1924_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Исаак а зидит аколо ун алтар, а кемат Нумеле Домнулуй ши шь-а ынтинс кортул аколо. Робий луй Исаак ау сэпат аколо о фынтынэ. ");
INSERT INTO ron1924_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Абимелек а венит дин Герар ла ел ку приетенул сэу Ахузат ши ку Пикол, кэпетения оштирий луй. ");
INSERT INTO ron1924_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Исаак ле-а зис: „Пентру че вениць ла мине вой, каре мэ урыць ши м-аць изгонит де ла вой?” ");
INSERT INTO ron1924_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ей ау рэспунс: „Ведем лэмурит кэ Домнул есте ку тине. Де ачея зичем: ‘Сэ фие ун журэмынт ынтре ной, ынтре ной ши тине, ши сэ фачем ун легэмынт ку тине! ");
INSERT INTO ron1924_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Ануме, журэ кэ ну не вей фаче ничун рэу, дупэ кум нич ной ну не-ам атинс де тине, чи ць-ам фэкут нумай бине ши те-ам лэсат сэ плечь ын паче. Ту акум ешть бинекувынтат де Домнул.’” ");
INSERT INTO ron1924_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Исаак ле-а дат ун оспэц ши ау мынкат ши ау бэут. ");
INSERT INTO ron1924_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","С-ау скулат дис-де-диминяцэ ши с-ау легат унул ку алтул принтр-ун журэмынт. Исаак й-а лэсат апой сэ плече, ши ей л-ау пэрэсит ын паче. ");
INSERT INTO ron1924_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ын ачеяшь зи, ниште робь ай луй Исаак ау венит сэ-й ворбяскэ де фынтына пе каре о сэпау ши й-ау зис: „Ам дат де апэ!” ");
INSERT INTO ron1924_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ши ел а нумит-о Шиба. Де ачея с-а пус четэций нумеле Беер-Шеба пынэ ын зиуа де азь. ");
INSERT INTO ron1924_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Ла вырста де патрузечь де ань, Есау а луат де невесте пе Иудита, фата хетитулуй Беери, ши пе Басмат, фата хетитулуй Елон. ");
INSERT INTO ron1924_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Еле ау фост о причинэ де маре амэрэчуне пентру Исаак ши Ребека. ");
INSERT INTO ron1924_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Исаак ымбэтрынисе ши окий ый слэбисерэ, аша кэ ну май ведя. Атунч а кемат пе Есау, фиул луй чел май маре, ши й-а зис: „Фиуле!” „Ятэ-мэ”, й-а рэспунс ел. ");
INSERT INTO ron1924_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Исаак а зис: „Ятэ, ам ымбэтрынит ши ну штиу зиуа морций меле. ");
INSERT INTO ron1924_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Акум дар, те рог, я-ць армеле, толба ши аркул, ду-те ла кымп ши аду-мь вынат. ");
INSERT INTO ron1924_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Фэ-мь о мынкаре, кум ымь плаче мие, ши аду-мь с-о мэнынк, ка сэ те бинекувынтезе суфлетул меу ынаинте де а мури.” ");
INSERT INTO ron1924_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ребека а аскултат че спуня Исаак фиулуй сэу Есау. Ши Есау с-а дус ла кымп, ка сэ приндэ вынатул ши сэ-л адукэ. ");
INSERT INTO ron1924_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Апой, Ребека а зис фиулуй сэу Иаков: „Ятэ, ам аузит пе татэл тэу ворбинд астфел фрателуй тэу Есау: ");
INSERT INTO ron1924_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Аду-мь вынат ши фэ-мь о мынкаре ка сэ мэнынк, ши те вой бинекувынта ынаинтя Домнулуй, ынаинте де моартя мя.’ ");
INSERT INTO ron1924_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Акум, фиуле, аскултэ сфатул меу ши фэ че ыць порунческ. ");
INSERT INTO ron1924_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ду-те де я-мь дин турмэ дой езь бунь, ка сэ фак дин ей татэлуй тэу о мынкаре густоасэ, кум ый плаче; ");
INSERT INTO ron1924_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","ту ай с-о дучь татэлуй тэу с-о мэнынче, ка сэ те бинекувынтезе ынаинте де моартя луй.” ");
INSERT INTO ron1924_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Иаков а рэспунс мамей сале: „Ятэ, фрателе меу Есау есте пэрос, яр еу н-ам пэр делок. ");
INSERT INTO ron1924_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Поате кэ татэл меу мэ ва пипэи ши вой трече дрепт минчинос ынаинтя луй ши, ын лок де бинекувынтаре, вой фаче сэ винэ песте мине блестемул.” ");
INSERT INTO ron1924_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Мама са й-а зис: „Блестемул ачеста, фиуле, сэ кадэ песте мине! Аскултэ нумай сфатул меу ши ду-те де аду-ми-й.” ");
INSERT INTO ron1924_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Иаков с-а дус де й-а луат ши й-а адус мамей сале, каре а фэкут о мынкаре кум ый плэчя татэлуй сэу. ");
INSERT INTO ron1924_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Ын урмэ, Ребека а луат хайнеле челе буне але луй Есау, фиул ей чел май маре, каре се гэсяу акасэ, ши ле-а пус пе Иаков, фиул ей чел май тынэр. ");
INSERT INTO ron1924_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Й-а акоперит ку пеля езилор мыниле ши гытул, каре ерау фэрэ пэр. ");
INSERT INTO ron1924_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Ши а дат ын мына фиулуй сэу Иаков мынкаря густоасэ ши пыня пе каре ле прегэтисе. ");
INSERT INTO ron1924_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Ел а венит ла татэл сэу ши а зис: „Татэ!” „Ятэ-мэ”, а зис Исаак. „Чине ешть ту, фиуле?” ");
INSERT INTO ron1924_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Иаков а рэспунс татэлуй сэу: „Еу сунт Есау, фиул тэу чел май маре; ам фэкут че мь-ай спус. Скоалэ-те, рогу-те, шезь де мэнынкэ дин вынатул меу, пентру ка сэ мэ бинекувынтезе суфлетул тэу!” ");
INSERT INTO ron1924_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Исаак а зис фиулуй сэу: „Кум, л-ай ши гэсит, фиуле?” Ши Иаков а рэспунс: „Домнул Думнезеул тэу ми л-а скос ынаинте.” ");
INSERT INTO ron1924_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Исаак а зис луй Иаков: „Апропие-те дар, сэ те пипэй, фиуле, ка сэ штиу дакэ ешть ку адевэрат фиул меу Есау сау ну.” ");
INSERT INTO ron1924_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Иаков с-а апропият де татэл сэу Исаак, каре л-а пипэит ши а зис: „Гласул есте гласул луй Иаков, дар мыниле сунт мыниле луй Есау.” ");
INSERT INTO ron1924_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ну л-а куноскут, пентру кэ мыниле ый ерау пэроасе, ка мыниле фрателуй сэу Есау, ши л-а бинекувынтат. ");
INSERT INTO ron1924_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Исаак а зис: „Ту ешть деч фиул меу Есау?” Ши Иаков а рэспунс: „Еу сунт.” ");
INSERT INTO ron1924_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Исаак а зис: „Аду-мь сэ мэнынк дин вынатул фиулуй меу, ка суфлетул меу сэ те бинекувынтезе.” Иаков й-а адус, ши ел а мынкат; й-а адус ши вин ши а бэут. ");
INSERT INTO ron1924_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Атунч, татэл сэу, Исаак, й-а зис: „Апропие-те дар ши сэрутэ-мэ, фиуле.” ");
INSERT INTO ron1924_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Иаков с-а апропият ши л-а сэрутат. Исаак а симцит миросул хайнелор луй; апой л-а бинекувынтат ши а зис: „Ятэ, миросул фиулуй меу есте ка миросул унуй кымп пе каре л-а бинекувынтат Домнул. ");
INSERT INTO ron1924_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Сэ-ць дя Думнезеу роуэ дин чер Ши грэсимя пэмынтулуй, Грыу ши вин дин белшуг! ");
INSERT INTO ron1924_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Сэ-ць фие супусе нороаде, Ши нямурь сэ се ынкине ынаинтя та! Сэ фий стэпынул фрацилор тэй, Ши фиий мамей тале сэ се ынкине ынаинтя та! Блестемат сэ фие орьчине те ва блестема Ши бинекувынтат сэ фие орьчине те ва бинекувынта.” ");
INSERT INTO ron1924_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Исаак сфыршисе де бинекувынтат пе Иаков ши абя плекасе Иаков де ла татэл сэу Исаак, кынд фрателе сэу Есау с-а ынторс де ла вынэтоаре. ");
INSERT INTO ron1924_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","А фэкут ши ел о мынкаре густоасэ, пе каре а адус-о татэлуй сэу. Ши а зис татэлуй сэу: „Татэ, скоалэ-те ши мэнынкэ дин вынатул фиулуй тэу, пентру ка сэ мэ бинекувынтезе суфлетул тэу!” ");
INSERT INTO ron1924_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Татэл сэу Исаак й-а зис: „Чине ешть ту?” Ши ел а рэспунс: „Еу сунт фиул тэу чел май маре, Есау.” ");
INSERT INTO ron1924_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Исаак с-а ынспэймынтат фоарте таре ши а зис: „Чине есте атунч чел че а принс вынат ши ми л-а адус? Еу ам мынкат дин тоате ынаинте де а вени ту ши л-ам бинекувынтат. Де ачея ва рэмыне бинекувынтат.” ");
INSERT INTO ron1924_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Кынд а аузит Есау кувинтеле татэлуй сэу, а скос марь ципете, плине де амэрэчуне, ши а зис татэлуй сэу: „Бинекувынтязэ-мэ ши пе мине, татэ!” ");
INSERT INTO ron1924_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Исаак а зис: „Фрателе тэу а венит ку виклешуг ши ць-а луат бинекувынтаря.” ");
INSERT INTO ron1924_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Есау а зис: „Да, ну деӂяба й-ау пус нумеле Иаков, кэч м-а ыншелат де доуэ орь. Мь-а луат дрептул де ынтый нэскут ши ятэ-л акум кэ а венит де мь-а луат ши бинекувынтаря!” Ши а зис: „Н-ай пэстрат ничо бинекувынтаре пентру мине?” ");
INSERT INTO ron1924_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Исаак а рэспунс ши а зис луй Есау: „Ятэ, л-ам фэкут стэпын песте тине ши й-ам дат ка служиторь пе тоць фраций луй, л-ам ынзестрат ку грыу ши вин дин белшуг. Че май пот фаче оаре пентру тине, фиуле?” ");
INSERT INTO ron1924_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Есау а зис татэлуй сэу: „Н-ай декыт ачастэ сингурэ бинекувынтаре, татэ? Бинекувынтязэ-мэ ши пе мине, татэ!” Ши Есау а ридикат гласул ши а плынс. ");
INSERT INTO ron1924_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Татэл сэу Исаак а рэспунс ши й-а зис: „Ятэ! Локуинца та ва фи липситэ де грэсимя пэмынтулуй Ши де роуа черулуй, де сус. ");
INSERT INTO ron1924_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Вей трэи дин сабия та Ши вей служи фрателуй тэу, Дар, кынд те вей рэскула, Вей скутура жугул луй де пе гытул тэу!” ");
INSERT INTO ron1924_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Есау а принс урэ пе Иаков дин причина бинекувынтэрий ку каре-л бинекувынтасе татэл сэу. Ши Есау зичя ын инима са: „Зилеле де бочет пентру татэл меу сунт апроапе, ши апой ам сэ учид пе фрателе меу Иаков.” ");
INSERT INTO ron1924_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ши ау спус Ребекэй кувинтеле луй Есау, фиул ей чел май маре. Еа а тримис атунч де а кемат пе Иаков, фиул ей чел май тынэр, ши й-а зис: „Ятэ, фрателе тэу Есау вря сэ се рэзбуне пе тине, оморынду-те. ");
INSERT INTO ron1924_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Акум, фиуле, аскултэ сфатул меу: скоалэ-те, фуӂь ла фрателе меу Лабан, ын Харан, ");
INSERT INTO ron1924_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","ши рэмый ла ел кытэва време, пынэ се ва потоли мыния фрателуй тэу, ");
INSERT INTO ron1924_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","пынэ ва трече де ла тине урӂия фрателуй тэу ши ва уйта че й-ай фэкут. Атунч вой тримите сэ те кеме. Пентру че сэ фиу липситэ де вой амындой ынтр-о зи?” ");
INSERT INTO ron1924_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Ребека а зис луй Исаак: „М-ам скырбит де вяцэ дин причина фетелор луй Хет. Дакэ Иаков ва луа о асеменя невастэ динтре фетеле луй Хет, динтре фетеле цэрий ачестея, ла че-мь май есте бунэ вяца?” ");
INSERT INTO ron1924_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Исаак а кемат пе Иаков, л-а бинекувынтат ши й-а дат порунка ачаста: „Сэ ну-ць ей невастэ динтре фетеле луй Канаан. ");
INSERT INTO ron1924_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Скоалэ-те, ду-те ла Падан-Арам, ын каса луй Бетуел, татэл мамей тале, ши я-ць де аколо о невастэ динтре фетеле луй Лабан, фрателе мамей тале. ");
INSERT INTO ron1924_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Думнезеул чел Атотпутерник сэ те бинекувынтезе, сэ те факэ сэ крешть ши сэ те ынмулцешть, ка сэ ажунӂь о чатэ де нороаде! ");
INSERT INTO ron1924_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Сэ-ць дя бинекувынтаря луй Авраам, цие ши семинцей тале ку тине, ка сэ стэпынешть цара ын каре локуешть ка стрэин ши пе каре а дат-о луй Авраам.” ");
INSERT INTO ron1924_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Ши Исаак а тримис пе Иаков, каре с-а дус ла Падан-Арам, ла Лабан, фиул луй Бетуел, Арамеул, фрателе Ребекэй, мама луй Иаков ши а луй Есау. ");
INSERT INTO ron1924_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Есау а вэзут кэ Исаак бинекувынтасе пе Иаков ши-л тримисесе ла Падан-Арам, ка сэ-шь я невастэ де аколо, ши кэ, бинекувынтынду-л, ый дэдусе порунка ачаста: „Сэ ну-ць ей невастэ динтре фетеле луй Канаан.” ");
INSERT INTO ron1924_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","А вэзут кэ Иаков аскултасе де татэл сэу ши де мама са ши плекасе ла Падан-Арам. ");
INSERT INTO ron1924_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Есау а ынцелес астфел кэ фетеле луй Канаан ну-й плэчяу татэлуй сэу Исаак. ");
INSERT INTO ron1924_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Ши Есау с-а дус ла Исмаел. Ел а май луат де невастэ, пе лынгэ невестеле пе каре ле авя, пе Махалат, фата луй Исмаел, фиул луй Авраам, ши сора луй Небаиот. ");
INSERT INTO ron1924_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Иаков а плекат дин Беер-Шеба ши шь-а луат друмул спре Харан. ");
INSERT INTO ron1924_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","А ажунс ынтр-ун лок унде а рэмас песте ноапте, кэч асфинцисе соареле. А луат о пятрэ де аколо, а пус-о кэпэтый ши с-а кулкат ын локул ачела. ");
INSERT INTO ron1924_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Ши а висат о скарэ резематэ де пэмынт, ал кэрей вырф ажунӂя пынэ ла чер. Ынӂерий луй Думнезеу се суяу ши се коборау пе скара ачея. ");
INSERT INTO ron1924_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ши Домнул стэтя дясупра ей ши зичя: „Еу сунт Домнул Думнезеул татэлуй тэу Авраам ши Думнезеул луй Исаак. Пэмынтул пе каре ешть кулкат ци-л вой да цие ши семинцей тале. ");
INSERT INTO ron1924_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Сэмынца та ва фи ка пулберя пэмынтулуй; те вей ынтинде ла апус ши ла рэсэрит, ла мязэноапте ши ла мязэзи ши тоате фамилииле пэмынтулуй вор фи бинекувынтате ын тине ши ын сэмынца та. ");
INSERT INTO ron1924_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ятэ, Еу сунт ку тине; те вой пэзи претутиндень пе унде вей мерӂе ши те вой адуче ынапой ын цара ачаста, кэч ну те вой пэрэси пынэ ну вой ымплини че-ць спун.” ");
INSERT INTO ron1924_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Иаков с-а трезит дин сомн ши а зис: „Ку адевэрат, Домнул есте ын локул ачеста, ши еу н-ам штиут.” ");
INSERT INTO ron1924_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Й-а фост фрикэ ши а зис: „Кыт де ынфрикошат есте локул ачеста! Аич есте каса луй Думнезеу, аич есте поарта черурилор!” ");
INSERT INTO ron1924_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Ши Иаков с-а скулат дис-де-диминяцэ, а луат пятра пе каре о пусесе кэпэтый, а пус-о ка стылп де адучере аминте ши а турнат унтделемн пе вырфул ей. ");
INSERT INTO ron1924_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","А дат локулуй ачестуя нумеле Бетел, дар май ынаинте четатя се кема Луз. ");
INSERT INTO ron1924_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Иаков а фэкут о журуинцэ ши а зис: „Дакэ ва фи Думнезеу ку мине ши мэ ва пэзи ын тимпул кэлэторией пе каре о фак, дакэ-мь ва да пыне сэ мэнынк ши хайне сэ мэ ымбрак ");
INSERT INTO ron1924_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ши дакэ мэ вой ынтоарче ын паче ын каса татэлуй меу, атунч Домнул ва фи Думнезеул меу; ");
INSERT INTO ron1924_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","пятра ачаста пе каре ам пус-о ка стылп де адучере аминте ва фи каса луй Думнезеу ши Ыць вой да а зечя парте дин тот че-мь вей да.” ");
INSERT INTO ron1924_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Иаков а порнит ла друм ши с-а дус ын цара челор че локуеск ла Рэсэрит. ");
INSERT INTO ron1924_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","С-а уйтат ынаинте ши ятэ кэ пе кымп ера о фынтынэ, ши лынгэ еа ерау трей турме де ой каре се одихняу, кэч ла фынтына ачаста обишнуяу чобаний сэ-шь адапе турмеле. Ши пятра де пе гура фынтыний ера маре. ");
INSERT INTO ron1924_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Тоате турмеле се стрынӂяу аколо; чобаний прэвэляу пятра де пе гура фынтыний, адэпау турмеле ши апой пуняу пятра ярэшь ла лок пе гура фынтыний. ");
INSERT INTO ron1924_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Иаков а зис пэсторилор: „Фрацилор, де унде сунтець?” „Дин Харан”, ау рэспунс ей. ");
INSERT INTO ron1924_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ел ле-а зис: „Куноаштець пе Лабан, фиул луй Нахор?” „Ыл куноаштем”, й-ау рэспунс ей. ");
INSERT INTO ron1924_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Ел ле-а зис: „Есте сэнэтос?” „Сэнэтос”, ау рэспунс ей. Ши токмай атунч веня Рахела, фата луй, ку оиле. ");
INSERT INTO ron1924_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Ел а зис: „Ятэ, соареле есте ынкэ сус ши-й пря девреме ка сэ стрынӂець вителе: адэпаць оиле, апой дучеци-вэ ши паштеци-ле ярэшь.” ");
INSERT INTO ron1924_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ей ау рэспунс: „Ну путем пынэ ну се вор стрынӂе тоате турмеле; атунч се прэвэлеште пятра де пе гура фынтыний ши вом адэпа оиле.” ");
INSERT INTO ron1924_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Пе кынд ле ворбя ел ынкэ, вине Рахела ку оиле татэлуй сэу, кэч еа ле пэзя. ");
INSERT INTO ron1924_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Кынд а вэзут Иаков пе Рахела, фата луй Лабан, фрателе мамей сале, ши турма луй Лабан, фрателе мамей сале, с-а апропият, а прэвэлит пятра де пе гура фынтыний ши а адэпат турма луй Лабан, фрателе мамей сале. ");
INSERT INTO ron1924_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Апой Иаков а сэрутат пе Рахела ши а ынчепут сэ плынгэ таре. ");
INSERT INTO ron1924_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Иаков а спус Рахелей кэ есте рудэ ку татэл ей, кэ есте фиул Ребекэй. Ши еа а дат фуга де а спус татэлуй сэу. ");
INSERT INTO ron1924_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Кум а аузит Лабан де Иаков, фиул сурорий сале, й-а алергат ынаинте, л-а ымбрэцишат, л-а сэрутат ши л-а адус ын касэ. Иаков а историсит луй Лабан тоате челе ынтымплате. ");
INSERT INTO ron1924_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Ши Лабан й-а зис: „Ку адевэрат, ту ешть ос дин оаселе меле ши карне дин карня мя!” Иаков а стат ла Лабан о лунэ. ");
INSERT INTO ron1924_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Апой Лабан а зис луй Иаков: „Фииндкэ ешть рудэ ку мине, сэ-мь служешть оаре деӂяба? Спуне-мь че симбрие врей?” ");
INSERT INTO ron1924_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Лабан ынсэ авя доуэ фете: чя май маре се нумя Лея ши чя май микэ, Рахела. ");
INSERT INTO ron1924_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Лея авя окий слабь, дар Рахела ера фрумоасэ ла статурэ ши мындрэ ла фацэ. ");
INSERT INTO ron1924_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Иаков юбя пе Рахела ши а зис: „Ыць вой служи шапте ань пентру Рахела, фата та чя май микэ.” ");
INSERT INTO ron1924_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Ши Лабан а рэспунс: „Май бине сэ ць-о дау цие, декыт с-о дау алтуя. Рэмый ла мине!” ");
INSERT INTO ron1924_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Астфел, Иаков а служит шапте ань пентру Рахела; ши аний ачештя и с-ау пэрут ка врео кытева зиле, пентру кэ о юбя. ");
INSERT INTO ron1924_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Ын урмэ, Иаков а зис луй Лабан: „Дэ-мь неваста, кэч ми с-а ымплинит сорокул, ка сэ интру ла еа.” ");
INSERT INTO ron1924_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Лабан а адунат пе тоць оамений локулуй ши а фэкут ун оспэц. ");
INSERT INTO ron1924_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Сяра, а луат пе фийкэ-са Лея ши а адус-о ла Иаков, каре с-а кулкат ку еа. ");
INSERT INTO ron1924_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Ши Лабан а дат ка роабэ фетей сале Лея пе роаба са Зилпа. ");
INSERT INTO ron1924_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","А доуа зи диминяцэ, ятэ кэ ера Лея. Атунч, Иаков а зис луй Лабан: „Че мь-ай фэкут? Ну ць-ам служит оаре пентру Рахела? Пентру че м-ай ыншелат?” ");
INSERT INTO ron1924_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Лабан а рэспунс: „Ын локул ачеста ну-й обичей сэ се дя чя май тынэрэ ынаинтя челей май марь. ");
INSERT INTO ron1924_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Испрэвеште сэптэмына ку ачаста, ши-ць вом да ши пе чялалтэ пентру служба пе каре о вей май фаче ла мине алць шапте ань.” ");
INSERT INTO ron1924_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Иаков а фэкут аша ши а испрэвит сэптэмына ку Лея; апой, Лабан й-а дат де невастэ пе фийкэ-са Рахела. ");
INSERT INTO ron1924_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Ши Лабан а дат ка роабэ фетей сале Рахела пе роаба са Билха. ");
INSERT INTO ron1924_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Иаков а интрат ши ла Рахела, пе каре о юбя май мулт декыт пе Лея, ши а май служит ла Лабан алць шапте ань. ");
INSERT INTO ron1924_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Домнул а вэзут кэ Лея ну ера юбитэ ши а фэкут-о сэ айбэ копий, пе кынд Рахела ера стярпэ. ");
INSERT INTO ron1924_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Лея а рэмас ынсэрчинатэ ши а нэскут ун фиу, кэруя й-а пус нумеле Рубен; „кэч”, а зис еа, „Домнул а вэзут мыхниря мя, ши акум бэрбатул меу аре сэ мэ юбяскэ негрешит”. ");
INSERT INTO ron1924_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","А рэмас ярэшь ынсэрчинатэ ши а нэскут ун фиу ши а зис: „Домнул а аузит кэ ну ерам юбитэ ши мь-а дат ши пе ачеста.” Де ачея, й-а пус нумеле Симеон. ");
INSERT INTO ron1924_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Яр а рэмас ынсэрчинатэ ши а нэскут ун фиу ши а зис: „Де дата ачаста, бэрбатул меу се ва алипи де мине, кэч й-ам нэскут трей фий.” Де ачея й-а пус нумеле Леви. ");
INSERT INTO ron1924_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","А рэмас ярэшь ынсэрчинатэ ши а нэскут ун фиу, ши а зис: „Де дата ачаста, вой лэуда пе Домнул.” Де ачея й-а пус нумеле Иуда. Ши а ынчетат сэ май наскэ. ");
INSERT INTO ron1924_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Кынд а вэзут Рахела кэ ну фаче копий луй Иаков, а пизмуит пе сорэ-са ши а зис луй Иаков: „Дэ-мь копий орь мор!” ");
INSERT INTO ron1924_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Иаков с-а мыният пе Рахела ши а зис: „Сунт еу оаре ын локул луй Думнезеу, каре те-а оприт сэ ай копий?” ");
INSERT INTO ron1924_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Еа а зис: „Ятэ роаба мя Билха; кулкэ-те ку еа, ка сэ наскэ пе ӂенункий мей ши сэ ам ши еу копий прин еа.” ");
INSERT INTO ron1924_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Ши й-а дат де невастэ пе роаба ей Билха, ши Иаков с-а кулкат ку еа. ");
INSERT INTO ron1924_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Билха а рэмас ынсэрчинатэ ши а нэскут луй Иаков ун фиу. ");
INSERT INTO ron1924_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Рахела а зис: „Мь-а фэкут Думнезеу дрептате, мь-а аузит гласул ши мь-а дэруит ун фиу.” Де ачея й-а пус нумеле Дан. ");
INSERT INTO ron1924_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Билха, роаба Рахелей, а рэмас яр ынсэрчинатэ ши а нэскут луй Иаков ун ал дойля фиу. ");
INSERT INTO ron1924_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Рахела а зис: „Ам луптат ку Думнезеу ымпотрива сурорий меле ши ам бируит.” Де ачея й-а пус нумеле Нефтали. ");
INSERT INTO ron1924_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Кынд а вэзут Лея кэ ну май наште, а луат пе роаба са Зилпа ши а дат-о луй Иаков де невастэ. ");
INSERT INTO ron1924_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Зилпа, роаба Леей, а нэскут луй Иаков ун фиу. ");
INSERT INTO ron1924_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","„Ку норок!” а зис Лея. Де ачея й-а пус нумеле Гад. ");
INSERT INTO ron1924_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Зилпа, роаба Леей, а нэскут ун ал дойля фиу луй Иаков. ");
INSERT INTO ron1924_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","„Че феричитэ сунт!” а зис Лея; „кэч фемеиле мэ вор нуми феричитэ.” Де ачея й-а пус нумеле Ашер. ");
INSERT INTO ron1924_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Рубен а ешит одатэ афарэ, пе время сечератулуй грыулуй, ши а гэсит мандрагоре пе кымп. Ле-а адус мамей сале Лея. Атунч, Рахела а зис Леей: „Дэ-мь, те рог, дин мандрагореле фиулуй тэу.” ");
INSERT INTO ron1924_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Еа й-а рэспунс: „Ну-ць ажунӂе кэ мь-ай луат бэрбатул, де врей сэ ей ши мандрагореле фиулуй меу?” Ши Рахела а зис: „Ей бине! Поате сэ се кулче ку тине ын ноаптя ачаста пентру мандрагореле фиулуй тэу.” ");
INSERT INTO ron1924_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Сяра, пе кынд се ынторчя Иаков де ла кымп, Лея й-а ешит ынаинте ши а зис: „Ла мине ай сэ вий, кэч те-ам кумпэрат ку мандрагореле фиулуй меу.” Ши ын ноаптя ачея с-а кулкат ку еа. ");
INSERT INTO ron1924_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Думнезеу а аскултат пе Лея, каре а рэмас ынсэрчинатэ ши а нэскут луй Иаков ал чинчиля фиу. ");
INSERT INTO ron1924_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Лея а зис: „М-а рэсплэтит Думнезеу, пентру кэ ам дат бэрбатулуй меу пе роаба мя.” Де ачея й-а пус нумеле Исахар. ");
INSERT INTO ron1924_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Лея а рэмас ярэшь ынсэрчинатэ ши а нэскут ун ал шаселя фиу луй Иаков. ");
INSERT INTO ron1924_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Лея а зис: „Фрумос дар мь-а дат Думнезеу! Де дата ачаста, бэрбатул меу ва локуи ку мине, кэч й-ам нэскут шасе фий.” Де ачея й-а пус нумеле Забулон. ");
INSERT INTO ron1924_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Ын урмэ, а нэскут о фатэ, кэрея й-а пус нумеле Дина. ");
INSERT INTO ron1924_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Думнезеу Шь-а адус аминте де Рахела, а аскултат-о ши а фэкут-о сэ айбэ копий. ");
INSERT INTO ron1924_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Еа а рэмас ынсэрчинатэ ши а нэскут ун фиу, ши а зис: „Мь-а луат Думнезеу окара!” ");
INSERT INTO ron1924_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ши й-а пус нумеле Иосиф, зикынд: „Домнул сэ-мь май адауӂе ун фиу!” ");
INSERT INTO ron1924_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Дупэ че а нэскут Рахела пе Иосиф, Иаков а зис луй Лабан: „Ласэ-мэ сэ плек, ка сэ мэ дук акасэ, ын цара мя. ");
INSERT INTO ron1924_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Дэ-мь невестеле ши копиий, пентру каре ць-ам служит, ши вой плека, фииндкэ штий че службэ ць-ам фэкут.” ");
INSERT INTO ron1924_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Лабан й-а зис: „Дакэ ам кэпэтат тречере ынаинтя та, май зэбовеште; вэд бине кэ Домнул м-а бинекувынтат дин причина та; ");
INSERT INTO ron1924_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","хотэрэште-мь симбрия та ши ць-о вой да.” ");
INSERT INTO ron1924_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Иаков й-а рэспунс: „Штий кум ць-ам служит ши кум ць-ау пропэшит вителе ку мине, ");
INSERT INTO ron1924_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","кэч пуцинул пе каре-л авяй ынаинте де вениря мя а крескут мулт ши Домнул те-а бинекувынтат орьынкотро ам мерс еу. Акум, кынд ам сэ мунческ ши пентру каса мя?” ");
INSERT INTO ron1924_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Лабан а зис: „Че сэ-ць дау?” Ши Иаков а рэспунс: „Сэ ну-мь дай нимик. Дакэ те ынвоешть ку че-ць вой спуне, ыць вой паште турма ши май департе ши о вой пэзи. ");
INSERT INTO ron1924_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Азь ам сэ трек прин тоатэ турма та; ам сэ пун деопарте дин ой орьче мел сеин ши пестриц ши орьче мел негру, ши дин капре, тот че есте пестриц ши сеин. Ачаста сэ фие симбрия мя. ");
INSERT INTO ron1924_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ятэ кум се ва доведи чинстя мя: де акум ынколо, кынд ай сэ вий сэ-мь везь симбрия, тот че ну ва фи сеин ши пестриц ынтре капре ши негру ынтре мей ши се ва гэси ла мине сэ фие сокотит ка фурат.” ");
INSERT INTO ron1924_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Лабан а зис: „Бине! Фие аша кум ай зис.” ");
INSERT INTO ron1924_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Ын ачеяшь зи, а пус деопарте цапий бэлцаць ши пестриць, тоате капреле сеине ши пестрице, тоате челе че авяу алб пе еле ши тоць меий каре ерау негри. Ле-а дат ын мыниле фиилор сэй. ");
INSERT INTO ron1924_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Апой а пус о депэртаре де трей зиле де друм ынтре ел ши Иаков, ши Иаков пэштя челелалте ой але луй Лабан. ");
INSERT INTO ron1924_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Иаков а луат нуеле верзь де плоп, де мигдал ши де платан; а деспуят де пе еле фыший де коажэ ши а фэкут сэ се вадэ албяца каре ера пе нуеле. ");
INSERT INTO ron1924_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Апой а пус нуелеле пе каре ле деспуясе де коажэ ын жгябурь, ын адэпэторь, суб окий оилор каре веняу сэ бя, ка, атунч кынд вор вени сэ бя, сэ зэмисляскэ. ");
INSERT INTO ron1924_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Оиле зэмисляу уйтынду-се ла нуеле ши фэчяу мей бэлцаць, сеинь ши пестриць. ");
INSERT INTO ron1924_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Иаков деспэрця меий ачештя ши абэтя фецеле оилор дин турма луй Лабан кэтре челе сеине ши бэлцате. Шь-а фэкут астфел турме деосебите, пе каре ну ле-а ымпреунат ку турма луй Лабан. ");
INSERT INTO ron1924_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Орь де кыте орь се ынфербынтау оиле челе май тарь, Иаков пуня нуелеле ын жгябурь, суб окий оилор, ка еле сэ зэмисляскэ уйтынду-се ла нуеле. ");
INSERT INTO ron1924_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Кынд оиле ерау слабе, ну пуня нуелеле; аша кэ челе слабе ерау пентру Лабан, яр челе тарь, пентру Иаков. ");
INSERT INTO ron1924_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Омул ачеста с-а ымбогэцит астфел дин че ын че май мулт; а авут мулте турме, робь ши роабе, кэмиле ши мэгарь. ");
INSERT INTO ron1924_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Иаков а аузит ворбеле фиилор луй Лабан, каре зичяу: „Иаков а луат тот че ера ал татэлуй ностру ши ку аверя татэлуй ностру шь-а агонисит ел тоатэ богэция ачаста.” ");
INSERT INTO ron1924_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Иаков с-а уйтат ши ла фаца луй Лабан ши ятэ кэ еа ну май ера ка ынаинте. ");
INSERT INTO ron1924_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Атунч, Домнул а зис луй Иаков: „Ынтоарче-те ын цара пэринцилор тэй ши ын локул тэу де наштере, ши Еу вой фи ку тине.” ");
INSERT INTO ron1924_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Иаков а тримис де а кемат пе Рахела ши пе Лея ла кымп, ла турма луй. ");
INSERT INTO ron1924_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Ел ле-а зис: „Дупэ фаца татэлуй востру, вэд бине кэ ел ну май есте ка ынаинте, дар Думнезеул татэлуй меу а фост ку мине. ");
INSERT INTO ron1924_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Вой ыншивэ штиць кэ ам служит татэлуй востру ку тоатэ путеря мя. ");
INSERT INTO ron1924_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Ши татэл востру м-а ыншелат: де зече орь мь-а скимбат симбрия, дар Думнезеу ну й-а ынгэдуит сэ мэ пэгубяскэ. ");
INSERT INTO ron1924_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Чи кынд зичя ел: ‘Меий пестриць сэ фие симбрия та’, тоате оиле фэчяу мей пестриць. Ши кынд зичя: ‘Меий бэлцаць сэ фие симбрия та’, тоате оиле фэчяу мей бэлцаць. ");
INSERT INTO ron1924_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Думнезеу а луат астфел тоатэ турма татэлуй востру ши мь-а дат-о мие. ");
INSERT INTO ron1924_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Пе время кынд се ынфербынтау оиле, еу ам ридикат окий ши ам вэзут ын вис кэ цапий ши бербечий каре сэряу пе капре ши пе ой ерау бэлцаць, пестриць ши сеинь. ");
INSERT INTO ron1924_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Ши Ынӂерул луй Думнезеу мь-а зис ын вис: ‘Иакове!’ ‘Ятэ-мэ’, ам рэспунс еу. ");
INSERT INTO ron1924_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ел а зис: ‘Ридикэ окий ши привеште: тоць цапий ши бербечий каре сар пе капре ши пе ой сунт бэлцаць, пестриць ши сеинь, кэч ам вэзут тот че ць-а фэкут Лабан. ");
INSERT INTO ron1924_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Еу сунт Думнезеул дин Бетел, унде ай унс ун стылп де адучере аминте, унде Мь-ай фэкут о журуинцэ. Акум, скоалэ-те, ешь дин цара ачаста ши ынтоарче-те ын цара та де наштере.’” ");
INSERT INTO ron1924_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Рахела ши Лея ау рэспунс ши й-ау зис: „Май авем ной оаре парте ши моштенире ын каса татэлуй ностру? ");
INSERT INTO ron1924_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ну сунтем ной оаре привите де ел ка ниште стрэине, фииндкэ не-а вындут ши не-а мынкат ши баний? ");
INSERT INTO ron1924_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Тоатэ богэция пе каре а луат-о Думнезеу де ла татэл ностру есте а ноастрэ ши а копиилор ноштри. Фэ акум тот че ць-а спус Думнезеу.” ");
INSERT INTO ron1924_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Иаков с-а скулат ши а пус пе копиий ши невестеле сале кэларе пе кэмиле. ");
INSERT INTO ron1924_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Шь-а луат тоатэ турма ши тоате авериле пе каре ле авя, турма пе каре о агонисисе ын Падан-Арам, ши а плекат ла татэл сэу Исаак, ын цара Канаан. ");
INSERT INTO ron1924_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Пе кынд Лабан се дусесе сэ-шь тундэ оиле, Рахела а фурат идолий татэлуй сэу, ");
INSERT INTO ron1924_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","ши Иаков а ыншелат пе Лабан, Арамеул, кэч ну л-а ынштиинцат де фуга са. ");
INSERT INTO ron1924_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","А фуӂит астфел ку тот че авя; с-а скулат, а трекут рыул (Еуфрат) ши с-а ындрептат спре мунтеле Галаад. ");
INSERT INTO ron1924_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","А трея зи, ау дат де весте луй Лабан кэ Иаков а фуӂит. ");
INSERT INTO ron1924_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Лабан а луат ку ел пе фраций сэй, л-а урмэрит кале де шапте зиле ши л-а ажунс ла мунтеле Галаад. ");
INSERT INTO ron1924_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Дар Думнезеу С-а арэтат ноаптя ын вис луй Лабан, Арамеул, ши й-а зис: „Фереште-те сэ спуй о ворбэ ря луй Иаков!” ");
INSERT INTO ron1924_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Лабан а ажунс дар пе Иаков. Иаков ышь ынтинсесе кортул пе мунте; Лабан шь-а ынтинс ши ел кортул ку фраций луй пе мунтеле Галаад. ");
INSERT INTO ron1924_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Атунч, Лабан а зис луй Иаков: „Че-ай фэкут? Пентру че м-ай ыншелат ши мь-ай луат фетеле ка пе ниште роабе луате ку сабия? ");
INSERT INTO ron1924_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Пентру че ай фуӂит пе аскунс, м-ай ыншелат ши ну мь-ай дат де штире? Те-аш фи лэсат сэ плечь ын мижлокул веселией ши ал кынтечелор, ын сунет де тимпане ши алэутэ. ");
INSERT INTO ron1924_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ну мь-ай ынгэдуит нич мэкар сэ-мь сэрут непоций ши фетеле! Ка ун небун ай лукрат. ");
INSERT INTO ron1924_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Мына мя есте дестул де таре ка сэ вэ фак рэу, дар Думнезеул татэлуй востру мь-а зис ын ноаптя трекутэ: ‘Фереште-те сэ спуй о ворбэ ря луй Иаков!’ ");
INSERT INTO ron1924_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Дар акум, одатэ че ай плекат, пентру кэ те топешть де дор дупэ каса татэлуй тэу, де че мь-ай фурат думнезеий мей?” ");
INSERT INTO ron1924_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Дрепт рэспунс, Иаков а зис луй Лабан: „Ам фуӂит, фииндкэ мь-ера фрикэ, гындинду-мэ кэ поате ымь вей луа ынапой фетеле тале. ");
INSERT INTO ron1924_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Дар сэ пярэ ачела ла каре ыць вей гэси думнезеий тэй! Ын фаца фрацилор ноштри, черчетязэ ши везь че-й ла мине дин але тале, ши я-ци-л.” Иаков ну штия кэ Рахела ый фурасе. ");
INSERT INTO ron1924_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Лабан а интрат ын кортул луй Иаков, ын кортул Леей, ын кортул челор доуэ роабе ши н-а гэсит нимик. А ешит дин кортул Леей ши а интрат ын кортул Рахелей. ");
INSERT INTO ron1924_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Рахела луасе идолий, ый пусесе суб самарул кэмилей ши шезусе дясупра. Лабан а скоточит тот кортул, дар н-а гэсит нимик. ");
INSERT INTO ron1924_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Еа а зис татэлуй сэу: „Домнул меу, сэ ну те суперь дакэ ну мэ пот скула ынаинтя та, кэч мь-а венит рындуяла фемеилор.” А кэутат песте тот, дар н-а гэсит идолий. ");
INSERT INTO ron1924_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Иаков с-а мыният ши а чертат пе Лабан. А луат дин ноу кувынтул ши й-а зис: „Каре есте нелеӂюиря мя ши каре есте пэкатул меу, де мэ урмэрешть ку атыта ынвершунаре? ");
INSERT INTO ron1924_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Мь-ай скормонит тоате лукруриле ши че ай гэсит дин лукруриле дин каса та? Скоате-ле аич, ынаинтя фрацилор мей ши фрацилор тэй, ка сэ жудече ей ынтре ной амындой! ");
INSERT INTO ron1924_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Ятэ, ам стат ла тине доуэзечь де ань; оиле ши капреле ну ци с-ау стырпит ши н-ам мынкат бербечь дин турма та. ");
INSERT INTO ron1924_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ну ць-ам адус акасэ вите сфышияте де фяре: еу ынсумь те-ам деспэгубит пентру еле; ымь черяй ынапой че ми се фура зиуа сау че ми се фура ноаптя. ");
INSERT INTO ron1924_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Зиуа мэ топям де кэлдурэ, яр ноаптя мэ прэпэдям де фриг ши-мь фуӂя сомнул де пе окь. ");
INSERT INTO ron1924_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Ятэ, доуэзечь де ань ам стат ын каса та, ць-ам служит пайспрезече ань пентру челе доуэ фете але тале ши шасе ань пентру турма та ши де зече орь мь-ай скимбат симбрия. ");
INSERT INTO ron1924_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Дакэ н-аш фи авут ку мине пе Думнезеул татэлуй меу, пе Думнезеул луй Авраам, пе Ачела де каре се теме Исаак, мь-ай фи дат друмул акум ку мыниле гоале. Дар Думнезеу а вэзут суферинца мя ши остеняла мынилор меле ши ерь ноапте а ростит жудеката.” ");
INSERT INTO ron1924_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Дрепт рэспунс, Лабан а зис луй Иаков: „Фийчеле ачестя сунт фийчеле меле, копиий ачештя сунт копиий мей, турма ачаста есте турма мя ши тот че везь есте ал меу. Ши че пот фаче еу азь пентру фийчеле меле сау пентру копиий лор пе каре й-ау нэскут? ");
INSERT INTO ron1924_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Вино сэ фачем амындой ун легэмынт, ши легэмынтул ачеста сэ служяскэ де мэртурие ынтре мине ши тине!” ");
INSERT INTO ron1924_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Иаков а луат о пятрэ ши а пус-о ка стылп де адучере аминте. ");
INSERT INTO ron1924_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Иаков а зис фрацилор сэй: „Стрынӂець петре.” Ей ау стрынс петре ши ау фэкут о мовилэ, ши ау мынкат аколо пе мовилэ. ");
INSERT INTO ron1924_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Лабан а нумит-о Иегар-Сахадута, ши Иаков а нумит-о Галед. ");
INSERT INTO ron1924_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Лабан а зис: „Мовила ачаста сэ служяскэ азь де мэртурие ынтре мине ши тине!” Де ачея й-ау пус нумеле Галед. ");
INSERT INTO ron1924_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Се май нумеште ши Мицпа, пентру кэ Лабан а зис: „Домнул сэ вегезе асупра мя ши асупра та кынд не вом перде дин ведере унул пе алтул. ");
INSERT INTO ron1924_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Дакэ вей асупри пе фетеле меле ши дакэ вей май луа ши алте невесте афарэ де фетеле меле, я бине сяма кэ ну ун ом ва фи ку ной, чи Думнезеу ва фи мартор ынтре мине ши тине.” ");
INSERT INTO ron1924_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Лабан а зис луй Иаков: „Ятэ мовила ачаста ши ятэ стылпул ачеста пе каре л-ам ридикат ынтре мине ши тине. ");
INSERT INTO ron1924_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Мовила ачаста сэ фие марторэ ши стылпул ачеста сэ фие мартор кэ нич еу ну вой трече ла тине песте мовила ачаста ши нич ту ну вей трече ла мине песте мовила ачаста ши песте стылпул ачеста, ка сэ не фачем рэу. ");
INSERT INTO ron1924_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Думнезеул луй Авраам ши ал луй Нахор, Думнезеул татэлуй лор сэ жудече ынтре ной.” Иаков а журат пе Ачела де каре се темя Исаак. ");
INSERT INTO ron1924_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Иаков а адус о жертфэ пе мунте ши а пофтит пе фраций луй сэ мэнынче; ей ау мынкат ши ау рэмас тоатэ ноаптя пе мунте. ");
INSERT INTO ron1924_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Лабан с-а скулат дис-де-диминяцэ, шь-а сэрутат непоций ши фетеле ши й-а бинекувынтат. Апой а плекат ши с-а ынторс ла локуинца луй. ");
INSERT INTO ron1924_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Иаков шь-а вэзут де друм ши л-ау ынтылнит ынӂерий луй Думнезеу. ");
INSERT INTO ron1924_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Кынд й-а вэзут, Иаков а зис: „Ачаста есте табэра луй Думнезеу!” Де ачея а пус локулуй ачелуя нумеле Маханаим. ");
INSERT INTO ron1924_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Иаков а тримис ынаинте ниште соль ла фрателе сэу Есау, ын цара Сеир, ын цинутул луй Едом. ");
INSERT INTO ron1924_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Ел ле-а дат порунка урмэтоаре: „Ятэ че сэ спунець домнулуй меу Есау: ‘Аша ворбеште робул тэу Иаков: «Ам локуит ла Лабан ши ам рэмас ла ел пынэ акум; ");
INSERT INTO ron1924_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","ам бой, мэгарь, ой, робь ши роабе ши тримит сэ дя де штире лукрул ачеста домнулуй меу, ка сэ капэт тречере ынаинтя та.»’” ");
INSERT INTO ron1924_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Солий с-ау ынторс ынапой ла Иаков ши ау зис: „Не-ам дус ла фрателе тэу Есау, ши ел вине ынаинтя та ку патру суте де оамень.” ");
INSERT INTO ron1924_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Иаков с-а ынспэймынтат фоарте мулт ши л-а апукат гроаза. А ымпэрцит ын доуэ табере оамений пе каре-й авя ку ел, оиле, боий ши кэмилеле ");
INSERT INTO ron1924_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","ши а зис: „Дакэ вине Есау ымпотрива унея дин табере ши о бате, табэра каре ва рэмыне ва путя сэ скапе.” ");
INSERT INTO ron1924_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Иаков а зис: „Думнезеул татэлуй меу Авраам, Думнезеул татэлуй меу Исаак! Ту, Доамне, каре мь-ай зис: ‘Ынтоарче-те ын цара та ши ын локул тэу де наштере ши вой ынгрижи ка сэ-ць мяргэ бине!’ ");
INSERT INTO ron1924_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Еу сунт пря мик пентру тоате ындурэриле ши пентру тоатэ крединчошия пе каре ай арэтат-о фацэ де робул Тэу, кэч ам трекут Йорданул ачеста нумай ку тоягул меу, ши ятэ кэ акум фак доуэ табере. ");
INSERT INTO ron1924_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Избэвеште-мэ, Те рог, дин мына фрателуй меу, дин мына луй Есау! Кэч мэ тем де ел, ка сэ ну винэ ши сэ мэ ловяскэ, пе мине, пе маме ши пе копий. ");
INSERT INTO ron1924_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ши Ту ай зис: ‘Еу вой ынгрижи ка сэ-ць мяргэ бине ши-ць вой фаче сэмынца ка нисипул мэрий, каре, де мулт че есте, ну се поате нумэра.’” ");
INSERT INTO ron1924_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Иаков а петрекут ноаптя ын локул ачела. А луат дин че май авя ку ел ши а пус деопарте, ка дар пентру фрателе сэу Есау: ");
INSERT INTO ron1924_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","доуэ суте де капре ши доуэзечь де цапь, доуэ суте де ой ши доуэзечь де бербечь, ");
INSERT INTO ron1924_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","трейзечь де кэмиле алэптэтоаре ку мынжий лор, патрузечь де вачь ши зече таурь, доуэзечь де мэгэрице ши зече мэгэрушь. ");
INSERT INTO ron1924_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Ле-а дат робилор сэй, турмэ ку турмэ, деосебит, ши а порунчит робилор сэй: „Тречець ынаинтя мя ши лэсаць о депэртаре ынтре фиекаре турмэ.” ");
INSERT INTO ron1924_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","А дат челуй динтый порунка урмэтоаре: „Кынд те ва ынтылни фрателе меу Есау ши те ва ынтреба: ‘Ал куй ешть? Унде те дучь? Ши а куй есте турма ачаста динаинтя та?’ ");
INSERT INTO ron1924_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","сэ рэспунзь: ‘А робулуй тэу Иаков; еа есте ун дар тримис домнулуй меу Есау, ши ел ынсушь вине ын урма ноастрэ.’” ");
INSERT INTO ron1924_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","А дат ачеяшь порункэ челуй де ал дойля, челуй де ал трейля ши тутурор челор че мынау турмеле: „Аша сэ ворбиць домнулуй меу Есау кынд ыл вець ынтылни. ");
INSERT INTO ron1924_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Сэ спунець: ‘Ятэ, робул тэу Иаков вине ши ел дупэ ной.’” Кэч ышь зичя ел: „Ыл вой потоли ку дарул ачеста каре мерӂе ынаинтя мя; ын урмэ ыл вой ведя фацэ ын фацэ, ши поате кэ мэ ва прими ку бунэвоинцэ.” ");
INSERT INTO ron1924_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Астфел, дарул а трекут ынаинте, яр ел а рэмас ын табэрэ ын ноаптя ачея. ");
INSERT INTO ron1924_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Тот ын ноаптя ачея с-а скулат, а луат пе челе доуэ невесте але луй, пе челе доуэ роабе ши пе чей унспрезече копий ай луй ши а трекут вадул Иабокулуй. ");
INSERT INTO ron1924_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Й-а луат, й-а трекут пырыул ши а трекут тот че авя. ");
INSERT INTO ron1924_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Иаков ынсэ а рэмас сингур. Атунч, ун ом с-а луптат ку ел пынэ ын ревэрсатул зорилор. ");
INSERT INTO ron1924_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Вэзынд кэ ну-л поате бируи, омул ачеста л-а ловит ла ынкеетура коапсей, аша кэ и с-а скрынтит ынкеетура коапсей луй Иаков, пе кынд се лупта ку ел. ");
INSERT INTO ron1924_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Омул ачела а зис: „Ласэ-мэ сэ плек, кэч се реварсэ зориле.” Дар Иаков а рэспунс: „Ну Те вой лэса сэ плечь пынэ ну мэ вей бинекувынта.” ");
INSERT INTO ron1924_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Омул ачела й-а зис: „Кум ыць есте нумеле?” „Иаков”, а рэспунс ел. ");
INSERT INTO ron1924_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Апой а зис: „Нумеле тэу ну ва май фи Иаков, чи те вей кема Исраел, кэч ай луптат ку Думнезеу ши ку оамень, ши ай фост бируитор.” ");
INSERT INTO ron1924_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Иаков л-а ынтребат: „Спуне-мь, Те рог, нумеле Тэу.” Ел а рэспунс: „Пентру че Ымь черь нумеле?” Ши л-а бинекувынтат аколо. ");
INSERT INTO ron1924_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Иаков а пус локулуй ачелуя нумеле Пениел; „кэч”, а зис ел, „ам вэзут пе Думнезеу фацэ ын фацэ, ши тотушь ам скэпат ку вяцэ”. ");
INSERT INTO ron1924_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Рэсэря соареле кынд а трекут пе лынгэ Пениел. Ынсэ Иаков шкьопэта дин коапсэ. ");
INSERT INTO ron1924_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ятэ де че, пынэ ын зиуа де азь, исраелиций ну мэнынкэ вына де ла ынкеетура коапсей, кэч Думнезеу а ловит пе Иаков ла ынкеетура коапсей ын вынэ. ");
INSERT INTO ron1924_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Иаков а ридикат окий ши с-а уйтат, ши ятэ кэ Есау веня ку патру суте де оамень. Атунч а ымпэрцит копиий ынтре Лея, Рахела ши челе доуэ роабе. ");
INSERT INTO ron1924_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","А пус ын фрунте роабеле ку копиий лор, апой пе Лея ку копиий ей ши ла урмэ пе Рахела ку Иосиф. ");
INSERT INTO ron1924_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ел ынсушь а трекут ынаинтя лор ши с-а арункат ку фаца ла пэмынт де шапте орь, пынэ че с-а апропият де тот де фрателе сэу. ");
INSERT INTO ron1924_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Есау а алергат ынаинтя луй, л-а ымбрэцишат, и с-а арункат пе грумаз ши л-а сэрутат. Ши ау плынс. ");
INSERT INTO ron1924_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Есау, ридикынд окий, а вэзут фемеиле ши копиий ши а зис: „Чине сунт ачея?” Ши Иаков а рэспунс: „Сунт копиий пе каре й-а дат Думнезеу робулуй тэу.” ");
INSERT INTO ron1924_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Роабеле с-ау апропият ку копиий лор ши с-ау арункат ку фаца ла пэмынт. ");
INSERT INTO ron1924_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Лея ши копиий ей, де асеменя, с-ау апропият ши с-ау арункат ку фаца ла пэмынт. Ын урмэ с-ау апропият Иосиф ши Рахела ши с-ау арункат ку фаца ла пэмынт. ");
INSERT INTO ron1924_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Есау а зис: „Че ай де гынд сэ фачь ку тоатэ табэра ачея пе каре ам ынтылнит-о?” Ши Иаков а рэспунс: „Воеск сэ капэт тречере ку еа ынаинтя домнулуй меу.” ");
INSERT INTO ron1924_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Есау а зис: „Еу ам дин белшуг; пэстрязэ, фрате, че есте ал тэу.” ");
INSERT INTO ron1924_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Ши Иаков а рэспунс: „Ну, те рог, дакэ ам кэпэтат тречере ынаинтя та, примеште дарул ачеста дин мына мя, кэч м-ам уйтат ла фаца та кум се уйтэ чинева ла Фаца луй Думнезеу, ши ту м-ай примит ку бунэвоинцэ. ");
INSERT INTO ron1924_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Примеште деч дарул меу каре ць-а фост адус, фииндкэ Думнезеу м-а умплут де бунэтэць ши ам де тоате.” Астфел а стэруит де ел, ши Есау а примит. ");
INSERT INTO ron1924_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Есау а зис: „Хайдем сэ плекэм ши сэ порним ла друм; еу вой мерӂе ынаинтя та.” ");
INSERT INTO ron1924_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Иаков й-а рэспунс: „Домнул меу веде кэ копиий сунт микшорь ши ам ой ши вачь фэтате; дакэ ле-ам сили ла друм о сингурэ зи, тоатэ турма ва пери. ");
INSERT INTO ron1924_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Домнул меу с-о я ынаинтя робулуй сэу, ши еу вой вени ынчет пе урмэ, ла пас ку турма, каре ва мерӂе ынаинтя мя, ши ла пас ку копиий, пынэ вой ажунӂе ла домнул меу ын Сеир.” ");
INSERT INTO ron1924_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Есау а зис: „Вряу сэ лас ку тине мэкар о парте дин оамений мей.” Ши Иаков а рэспунс: „Пентру че ачаста? Мь-ажунӂе сэ капэт тречере ынаинтя та, домнул меу!” ");
INSERT INTO ron1924_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Ын ачеяшь зи, Есау а луат друмул ынапой ла Сеир. ");
INSERT INTO ron1924_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Иаков а плекат май департе ла Сукот. Шь-а зидит о касэ ши а фэкут колибе пентру турме. Де ачея с-а дат локулуй ачелуя нумеле Сукот. ");
INSERT INTO ron1924_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Ла ынтоарчеря луй дин Падан-Арам, Иаков а ажунс ку бине ын четатя Сихем, ын цара Канаан, ши а тэбэрыт ынаинтя четэций. ");
INSERT INTO ron1924_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Партя де огор пе каре ышь ынтинсесе кортул а кумпэрат-о де ла фиий луй Хамор, татэл луй Сихем, ку о сутэ де кесита. ");
INSERT INTO ron1924_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ши аколо а ридикат ун алтар, пе каре л-а нумит Ел-Елохе-Исраел. ");
INSERT INTO ron1924_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Дина, фата пе каре о нэскусе луй Иаков Лея, а ешит сэ вадэ пе фетеле цэрий. ");
INSERT INTO ron1924_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Еа а фост зэритэ де Сихем, фиул хевитулуй Хамор, домниторул цэрий. Ел а пус мына пе еа, с-а кулкат ку еа ши а нечинстит-о. ");
INSERT INTO ron1924_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","С-а липит ку тоатэ инима де Дина, фата луй Иаков, а юбит фата ши а кэутат с-о лиништяскэ. ");
INSERT INTO ron1924_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Дупэ ачея Сихем а зис татэлуй сэу Хамор: „Я-мь де невастэ пе фата ачаста!” ");
INSERT INTO ron1924_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Иаков а афлат кэ-й нечинстисе пе фийкэ-са Дина ши, фииндкэ фиий сэй ерау ку вителе ла пэшуне, Иаков а тэкут пынэ ла ынтоарчеря лор. ");
INSERT INTO ron1924_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Хамор, татэл луй Сихем, с-а дус ла Иаков ка сэ-й ворбяскэ. ");
INSERT INTO ron1924_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Дар, кынд с-ау ынторс фиий луй Иаков де ла пэшуне ши ау аузит лукрул ачеста, с-ау супэрат ши с-ау мыният фоарте таре, пентру кэ Сихем сэвыршисе о мишелие ын Исраел, кулкынду-се ку фата луй Иаков: аша чева н-ар фи требуит сэ се факэ ничодатэ. ");
INSERT INTO ron1924_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Хамор ле-а ворбит астфел: „Фиул меу Сихем с-а липит ку тоатэ инима де фата воастрэ. Вэ рог, даци-й-о де невастэ ");
INSERT INTO ron1924_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","ши ынкускрици-вэ ку ной; вой даци-не фетеле воастре ши луаць пентру вой пе але ноастре! ");
INSERT INTO ron1924_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Локуиць ку ной; цара вэ стэ ынаинте, рэмынець ын еа, фачець негоц ши кумпэраць пэмынтурь ын еа.” ");
INSERT INTO ron1924_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Сихем а зис татэлуй ши фрацилор Диней: „Сэ капэт тречере ынаинтя воастрэ, ши вэ вой да че-мь вець чере. ");
INSERT INTO ron1924_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Череци-мь о зестре кыт де маре ши кыт де мулте дарурь, ши вой да тот че-мь вець зиче; нумай даци-мь фата де невастэ.” ");
INSERT INTO ron1924_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Фиий луй Иаков ау рэспунс ши ау ворбит ку виклешуг луй Сихем ши татэлуй сэу Хамор, пентру кэ Сихем нечинстисе пе сора лор Дина. ");
INSERT INTO ron1924_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Ей й-ау зис: „Есте ун лукру пе каре ну-л путем фаче, сэ дэм пе сора ноастрэ унуй ом нетэят ымпрежур, кэч ар фи о окарэ пентру ной. ");
INSERT INTO ron1924_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Ну не вом ынвои ла аша чева декыт дакэ вэ фачець ши вой ка ной ши дакэ орьче парте бэрбэтяскэ динтре вой се ва тэя ымпрежур. ");
INSERT INTO ron1924_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Атунч вэ вом да пе фетеле ноастре ши вом луа пентру ной пе але воастре; вом локуи ку вой ши вом фаче ымпреунэ ун сингур нород. ");
INSERT INTO ron1924_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Дар, дакэ ну воиць сэ не аскултаць ши сэ вэ тэяць ымпрежур, не вом луа фата ши вом плека.” ");
INSERT INTO ron1924_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Кувинтеле лор ау плэкут луй Хамор ши луй Сихем, фиул луй Хамор. ");
INSERT INTO ron1924_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Тынэрул н-а преӂетат сэ факэ лукрул ачеста, кэч юбя пе фата луй Иаков ши ера чел май бине вэзут ын каса татэлуй сэу. ");
INSERT INTO ron1924_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Хамор ши фиул луй Сихем с-ау дус ла поарта четэций ши ау ворбит астфел оаменилор дин четатя лор: ");
INSERT INTO ron1924_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","„Оамений ачештя ау гындурь де паче фацэ де ной; сэ рэмынэ дар ын царэ ши сэ факэ негоц; цара есте дестул де ларгэ пентру ей. Ной вом луа де невесте пе фетеле лор ши ле вом да де невесте пе фетеле ноастре. ");
INSERT INTO ron1924_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Дар оамений ачештя ну вор вои сэ локуяскэ ымпреунэ ку ной, ка сэ алкэтуим ун сингур попор, декыт дакэ орьче парте бэрбэтяскэ динтре ной се ва тэя ымпрежур, дупэ кум ши ей ыншишь сунт тэяць ымпрежур. ");
INSERT INTO ron1924_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Турмеле лор, авериле лор ши тоате вителе лор вор фи атунч але ноастре. Сэ примим нумай че чер ей, ка сэ рэмынэ ла ной.” ");
INSERT INTO ron1924_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Тоць чей че тречяу пе поарта четэций ау аскултат пе Хамор ши пе фиул сэу Сихем ши тоць бэрбаций ау фост тэяць ымпрежур, тоць чей че тречяу пе поарта четэций. ");
INSERT INTO ron1924_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","А трея зи, пе кынд суферяу ей ынкэ, чей дой фий ай луй Иаков, Симеон ши Леви, фраций Диней, шь-ау луат фиекаре сабия, с-ау нэпустит асупра четэций каре се кредя ын линиште ши ау учис пе тоць бэрбаций. ");
INSERT INTO ron1924_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ау трекут, де асеменя, прин аскуцишул сабией пе Хамор ши пе фиул сэу Сихем; ау ридикат пе Дина дин каса луй Сихем ши ау ешит афарэ. ");
INSERT INTO ron1924_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Фиий луй Иаков с-ау арункат асупра челор морць ши ау жефуит четатя, пентру кэ нечинстисерэ пе сора лор. ");
INSERT INTO ron1924_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ле-ау луат оиле, боий ши мэгарий, тот че ера ын четате ши че ера пе кымп; ");
INSERT INTO ron1924_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","ле-ау луат ка прадэ де рэзбой тоате богэцииле, копиий ши невестеле ши тот че се гэся ын касе. ");
INSERT INTO ron1924_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Атунч, Иаков а зис луй Симеон ши луй Леви: „Вой м-аць ненорочит, фэкынду-мэ урыт локуиторилор цэрий, канааницилор ши ферезицилор. Н-ам суб порунка мя декыт ун мик нумэр де оамень; ей се вор стрынӂе ымпотрива мя, мэ вор бате ши вой фи нимичит, еу ши каса мя.” ");
INSERT INTO ron1924_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ей ау рэспунс: „Се кувеня оаре сэ се поарте ку сора ноастрэ кум се поартэ ку о курвэ?” ");
INSERT INTO ron1924_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Думнезеу а зис луй Иаков: „Скоалэ-те, суе-те ла Бетел, локуеште аколо ши ридикэ аколо ун алтар Думнезеулуй каре ци С-а арэтат кынд фуӂяй де фрателе тэу Есау.” ");
INSERT INTO ron1924_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Иаков а зис касей луй ши тутурор челор че ерау ку ел: „Скоатець думнезеий стрэинь каре сунт ын мижлокул востру, курэцици-вэ ши скимбаци-вэ хайнеле, ");
INSERT INTO ron1924_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","ка сэ не скулэм ши сэ не суим ла Бетел, кэч аколо вой ридика ун алтар Думнезеулуй каре м-а аскултат ын зиуа неказулуй меу ши каре а фост ку мине ын кэлэтория пе каре ам фэкут-о.” ");
INSERT INTO ron1924_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Ей ау дат луй Иаков тоць думнезеий стрэинь каре ерау ын мыниле лор ши черчеий пе каре-й пуртау ын урекь. Иаков й-а ынгропат ын пэмынт, суб стежарул де лынгэ Сихем. ");
INSERT INTO ron1924_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Апой ау плекат. Гроаза луй Думнезеу с-а рэспындит песте четэциле каре-й ынконжурау, аша кэ локуиторий лор н-ау урмэрит пе фиий луй Иаков. ");
INSERT INTO ron1924_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Иаков ши тоць чей че ерау ку ел ау ажунс ла Луз, адикэ Бетел, ын цара Канаан. ");
INSERT INTO ron1924_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","А зидит аколо ун алтар ши а нумит локул ачела Ел-Бетел, кэч аколо и Се дескоперисе Думнезеу кынд фуӂя де фрателе сэу. ");
INSERT INTO ron1924_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Дебора, дойка Ребекэй, а мурит ши а фост ынгропатэ май жос де Бетел, суб стежарул кэруя и с-а пус нумеле: „Стежарул жалей”. ");
INSERT INTO ron1924_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Думнезеу С-а арэтат ярэшь луй Иаков дупэ ынтоарчеря луй дин Падан-Арам ши л-а бинекувынтат. ");
INSERT INTO ron1924_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Думнезеу й-а зис: „Нумеле тэу есте Иаков, дар ну те вей май кема Иаков, чи нумеле тэу ва фи Исраел.” Ши й-а пус нумеле Исраел. ");
INSERT INTO ron1924_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Думнезеу й-а зис: „Еу сунт Думнезеул чел Атотпутерник. Креште ши ынмулцеште-те; ун ням ши о мулциме де нямурь се вор наште дин тине ши кяр ымпэраць вор еши дин коапселе тале. ");
INSERT INTO ron1924_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Цие ыць вой да цара пе каре ам дат-о луй Авраам ши луй Исаак ши вой да цара ачаста семинцей тале дупэ тине.” ");
INSERT INTO ron1924_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Думнезеу С-а ынэлцат де ла ел, ын локул унде ый ворбисе. ");
INSERT INTO ron1924_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Ши Иаков а ридикат ун стылп де адучере аминте ын локул унде ый ворбисе Думнезеу, ун стылп де пятрэ, пе каре а адус о жертфэ де бэутурэ ши а турнат унтделемн. ");
INSERT INTO ron1924_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Иаков а нумит локул унде ый ворбисе Думнезеу, Бетел. ");
INSERT INTO ron1924_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Апой ау плекат дин Бетел ши май ера о депэртаре буничикэ пынэ ла Ефрата, кынд Рахелей й-ау венит дурериле наштерий. А авут о наштере гря ");
INSERT INTO ron1924_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","ши, ын тимпул дурерилор наштерий, моаша й-а зис: „Ну те теме, кэч май ай ун фиу!” ");
INSERT INTO ron1924_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Ши, пе кынд ышь дэдя еа суфлетул, кэч трэӂя сэ моарэ, й-а пус нумеле Бен-Они дар татэл сэу л-а нумит Бениамин. ");
INSERT INTO ron1924_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Рахела а мурит ши а фост ынгропатэ пе друмул каре дуче ла Ефрата, сау Бетлеем. ");
INSERT INTO ron1924_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Иаков а ридикат ун стылп пе мормынтул ей: ачеста есте стылпул де пе мормынтул Рахелей, каре есте ши азь. ");
INSERT INTO ron1924_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Исраел а плекат май департе ши шь-а ынтинс кортул динколо де Мигдал-Едер. ");
INSERT INTO ron1924_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Пе кынд локуя Исраел ын цинутул ачеста, Рубен с-а дус ши с-а кулкат ку Билха, циитоаря татэлуй сэу. Ши Исраел а афлат. Фиий луй Иаков ерау ын нумэр де дойспрезече. ");
INSERT INTO ron1924_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Фиий Леей: Рубен, ынтыюл нэскут ал луй Иаков, Симеон, Леви, Иуда, Исахар ши Забулон. ");
INSERT INTO ron1924_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Фиий Рахелей: Иосиф ши Бениамин. ");
INSERT INTO ron1924_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Фиий Билхей, роаба Рахелей: Дан ши Нефтали. ");
INSERT INTO ron1924_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Фиий Зилпей, роаба Леей: Гад ши Ашер. Ачештя сунт фиий луй Иаков, каре и с-ау нэскут ын Падан-Арам. ");
INSERT INTO ron1924_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Иаков а ажунс ла татэл сэу Исаак, ла Мамре, ла Кириат-Арба, каре есте тот уна ку Хебронул, унде локуисерэ ка стрэинь Авраам ши Исаак. ");
INSERT INTO ron1924_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Зилеле веций луй Исаак ау фост де о сутэ оптзечь де ань. ");
INSERT INTO ron1924_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Исаак шь-а дат духул ши а мурит ши а фост адэугат ла попорул сэу, бэтрын ши сэтул де зиле. Фиий сэй, Есау ши Иаков, л-ау ынгропат. ");
INSERT INTO ron1924_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ятэ спица нямулуй луй Есау, адикэ Едом. ");
INSERT INTO ron1924_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Есау шь-а луат невесте динтре фетеле Канаанулуй: пе Ада, фата хетитулуй Елон, пе Охолибама, фата Аней, фата хевитулуй Цибеон, ");
INSERT INTO ron1924_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ши пе Басмат, фата луй Исмаел, сора луй Небаиот. ");
INSERT INTO ron1924_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ада а нэскут луй Есау пе Елифаз, Басмат а нэскут пе Реуел ");
INSERT INTO ron1924_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ши Охолибама а нэскут пе Иеуш, Иаелам ши Коре. Ачештя сунт фиий луй Есау, каре и с-ау нэскут ын цара Канаан. ");
INSERT INTO ron1924_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Есау шь-а луат невестеле, фиий ши фийчеле, тоатэ лумя дин касэ, турмеле, тоате вителе ши тоатэ аверя пе каре шь-о агонисисе ын цара Канаан ши с-а дус ынтр-о алтэ царэ, департе де фрателе сэу Иаков. ");
INSERT INTO ron1924_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Кэч богэцииле лор ерау пря марь ка сэ поатэ локуи ымпреунэ ши цинутул ын каре локуяу ка стрэинь ну ле май путя ажунӂе дин причина турмелор лор. ");
INSERT INTO ron1924_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Есау с-а ашезат ын мунтеле Сеир. Есау ынсямнэ Едом. ");
INSERT INTO ron1924_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ятэ спица нямулуй луй Есау, татэл едомицилор, ын мунтеле Сеир. ");
INSERT INTO ron1924_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Ятэ нумеле фиилор луй Есау: Елифаз, фиул Адей, неваста луй Есау; Реуел, фиул Басматей, неваста луй Есау. ");
INSERT INTO ron1924_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Фиий луй Елифаз ау фост: Теман, Омар, Цефо, Гаетам ши Кеназ. ");
INSERT INTO ron1924_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Ши Тимна ера циитоаря луй Елифаз, фиул луй Есау; еа а нэскут луй Елифаз пе Амалек. Ачештя сунт фиий Адей, неваста луй Есау. ");
INSERT INTO ron1924_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Ятэ фиий луй Реуел: Нахат, Зерах, Шама ши Миза. Ачештя сунт фиий Басматей, неваста луй Есау. ");
INSERT INTO ron1924_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Ятэ фиий Охолибамей, фата Аней, фата луй Цибеон, неваста луй Есау: Еа а нэскут луй Есау пе Иеуш, Иаелам ши Коре. ");
INSERT INTO ron1924_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Ятэ кэпетенииле семинциилор ешите дин фиий луй Есау. Ятэ фиий луй Елифаз, ынтыюл нэскут ал луй Есау: кэпетения Теман, кэпетения Омар, кэпетения Цефо, кэпетения Кеназ, ");
INSERT INTO ron1924_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","кэпетения Коре, кэпетения Гаетам, кэпетения Амалек. Ачештя сунт кэпетенииле ешите дин Елифаз, ын цара Едом. Ачештя сунт фиий Адей. ");
INSERT INTO ron1924_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Ятэ фиий луй Реуел, фиул луй Есау: кэпетения Нахат, кэпетения Зерах, кэпетения Шама, кэпетения Миза. Ачештя сунт кэпетенииле ешите дин Реуел, ын цара Едом. Ачештя сунт фиий Басматей, неваста луй Есау. ");
INSERT INTO ron1924_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Ятэ фиий Охолибамей, неваста луй Есау: кэпетения Иеуш, кэпетения Иаелам, кэпетения Коре. Ачештя сунт кэпетенииле ешите дин Охолибама, фата Аней, неваста луй Есау. ");
INSERT INTO ron1924_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Ачештя сунт фиий луй Есау ши ачештя сунт кэпетенииле семинциилор лор. Есау ынсямнэ Едом. ");
INSERT INTO ron1924_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Ятэ фиий луй Сеир, Хоритул, векий локуиторь ай цэрий: Лотан, Шобал, Цибеон, Ана, ");
INSERT INTO ron1924_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Дишон, Ецер ши Дишан. Ачештя сунт кэпетенииле хорицилор, фиий луй Сеир, ын цара Едом. ");
INSERT INTO ron1924_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Фиий луй Лотан ау фост: Хори ши Хемам. Сора луй Лотан а фост Тимна. ");
INSERT INTO ron1924_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Ятэ фиий луй Шобал: Алван, Манахат, Ебал, Шефо ши Онам. ");
INSERT INTO ron1924_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Ятэ фиий луй Цибеон: Ая ши Ана. Ана ачеста а гэсит извоареле калде ын пустиу, кынд пэштя мэгарий татэлуй сэу Цибеон. ");
INSERT INTO ron1924_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ятэ фиий луй Ана: Дишон ши Охолибама, фата луй Ана. ");
INSERT INTO ron1924_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Ятэ фиий луй Дишон: Хемдан, Ешбан, Итран ши Керан. ");
INSERT INTO ron1924_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ятэ фиий луй Ецер: Билхан, Зааван ши Акан. ");
INSERT INTO ron1924_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Ятэ фиий луй Дишан: Уц ши Аран. ");
INSERT INTO ron1924_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Ятэ кэпетенииле хорицилор: кэпетения Лотан, кэпетения Шобал, кэпетения Цибеон, кэпетения Ана, ");
INSERT INTO ron1924_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","кэпетения Дишон, кэпетения Ецер, кэпетения Дишан. Ачештя сунт кэпетенииле хорицилор, кэпетенииле пе каре ле-ау авут ын цара луй Сеир. ");
INSERT INTO ron1924_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Ятэ ымпэраций каре ау ымпэрэцит ын цара Едом, ынаинте де а ымпэрэци ун ымпэрат песте копиий луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Бела, фиул луй Беор, а ымпэрэцит песте Едом, ши нумеле четэций луй ера Динхаба. ");
INSERT INTO ron1924_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Бела а мурит ши ын локул луй а ымпэрэцит Иобаб, фиул луй Зерах дин Боцра. ");
INSERT INTO ron1924_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Иобаб а мурит ши ын локул луй а ымпэрэцит Хушам, дин цара теманицилор. ");
INSERT INTO ron1924_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Хушам а мурит ши ын локул луй а ымпэрэцит Хадад, фиул луй Бедад. Ел а бэтут пе Мадиан ын кымпия Моабулуй. Нумеле четэций луй ера Авит. ");
INSERT INTO ron1924_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Хадад а мурит ши ын локул луй а ымпэрэцит Самла дин Масрека. ");
INSERT INTO ron1924_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Самла а мурит ши ын локул луй а ымпэрэцит Саул дин Рехобот пе Рыу. ");
INSERT INTO ron1924_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Саул а мурит ши ын локул луй а ымпэрэцит Баал-Ханан, фиул луй Акбор. ");
INSERT INTO ron1924_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Баал-Ханан, фиул луй Акбор, а мурит ши ын локул луй а ымпэрэцит Хадар. Нумеле четэций луй ера Пау ши нумеле невестей луй ера Мехетабеел, фата луй Матред, фата луй Мезахаб. ");
INSERT INTO ron1924_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Ятэ нумеле кэпетениилор ешите дин Есау, дупэ семинцииле лор, дупэ цинутуриле лор ши дупэ нумеле лор: кэпетения Тимна, кэпетения Алва, кэпетения Иетет, ");
INSERT INTO ron1924_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","кэпетения Охолибама, кэпетения Ела, кэпетения Пинон, ");
INSERT INTO ron1924_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","кэпетения Кеназ, кэпетения Теман, кэпетения Мибцар, ");
INSERT INTO ron1924_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","кэпетения Магдиел, кэпетения Ирам. Ачестя сунт кэпетенииле луй Едом, дупэ локуинцеле лор, ын цара пе каре о авяу. Ачеста есте Есау, татэл едомицилор. ");
INSERT INTO ron1924_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Иаков а локуит ын цара Канаан, унде локуисе ка стрэин татэл сэу. ");
INSERT INTO ron1924_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ятэ история луй Иаков: Иосиф, ла вырста де шаптеспрезече ань, пэштя оиле ку фраций луй; бэятул ачеста ера ку фиий Билхей ши ку фиий Зилпей, невестеле татэлуй сэу. Ши Иосиф спуня татэлуй лор ворбеле лор челе реле. ");
INSERT INTO ron1924_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Исраел юбя пе Иосиф май мулт декыт пе тоць чейлалць фий ай сэй, пентру кэ ыл нэскусе ла бэтрынеце, ши й-а фэкут о хайнэ пестрицэ. ");
INSERT INTO ron1924_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Фраций луй ау вэзут кэ татэл лор ыл юбя май мулт декыт пе ей тоць ши ау ынчепут сэ-л ураскэ. Ну путяу сэ-й спунэ ничо ворбэ приетеняскэ. ");
INSERT INTO ron1924_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Иосиф а висат ун вис ши л-а историсит фрацилор сэй, каре л-ау урыт ши май мулт. ");
INSERT INTO ron1924_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Ел ле-а зис: „Я аскултаць че вис ам висат! ");
INSERT INTO ron1924_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Ной ерам ла легатул снопилор ын мижлокул кымпулуй ши ятэ кэ снопул меу с-а ридикат ши а стат ын пичоаре, яр снопий воштри л-ау ынконжурат ши с-ау арункат ку фаца ла пэмынт ынаинтя луй.” ");
INSERT INTO ron1924_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Фраций луй й-ау зис: „Доар н-ай сэ ымпэрэцешть ту песте ной? Доар н-ай сэ не кырмуешть ту пе ной?” Ши л-ау урыт ши май мулт дин причина виселор луй ши дин причина кувинтелор луй. ");
INSERT INTO ron1924_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Иосиф а май висат ун алт вис ши л-а историсит фрацилор сэй. Ел а зис: „Ам май висат ун вис! Соареле, луна ши унспрезече стеле се арункау ку фаца ла пэмынт ынаинтя мя.” ");
INSERT INTO ron1924_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Л-а историсит татэлуй сэу ши фрацилор сэй. Татэл сэу л-а мустрат ши й-а зис: „Че ынсямнэ висул ачеста пе каре л-ай висат? Ну кумва вом вени еу, мама та ши фраций тэй сэ не арункэм ку фаца ла пэмынт ынаинтя та?” ");
INSERT INTO ron1924_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Фраций сэй ау ынчепут сэ-л пизмуяскэ, дар татэл сэу а цинут минте лукруриле ачестя. ");
INSERT INTO ron1924_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Фраций луй Иосиф се дусесерэ ла Сихем, ка сэ паскэ оиле татэлуй лор. ");
INSERT INTO ron1924_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Исраел а зис луй Иосиф: „Фраций тэй паск оиле ла Сихем! Вино, кэч вряу сэ те тримит ла ей.” „Ятэ-мэ, сунт гата”, а рэспунс ел. ");
INSERT INTO ron1924_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Исраел й-а зис: „Ду-те, рогу-те, ши везь дакэ фраций тэй сунт сэнэтошь ши дакэ оиле сунт бине ши аду-мь вешть.” Л-а тримис астфел дин Валя Хебронулуй ши Иосиф а ажунс ла Сихем. ");
INSERT INTO ron1924_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Пе кынд рэтэчя пе кымп, л-а ынтылнит ун ом. Омул ачела л-а ынтребат: „Че кауць?” ");
INSERT INTO ron1924_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","„Каут пе фраций мей”, а рэспунс Иосиф. „Спуне-мь, те рог, унде паск ей оиле?” ");
INSERT INTO ron1924_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ши омул ачела а зис: „Ау плекат де аич, кэч й-ам аузит спунынд: ‘Хайдем ла Дотан.’” Иосиф с-а дус дупэ фраций сэй ши й-а гэсит ла Дотан. ");
INSERT INTO ron1924_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ей л-ау зэрит де департе ши, пынэ сэ се апропие де ей, с-ау сфэтуит сэ-л омоаре. ");
INSERT INTO ron1924_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ей ау зис унул кэтре алтул: „Ятэ кэ вине фэуриторул де висе! ");
INSERT INTO ron1924_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Вениць акум, сэ-л оморым ши сэ-л арункэм ынтр-уна дин ачесте гропь; вом спуне кэ л-а мынкат о фярэ сэлбатикэ ши вом ведя че се ва алеӂе де виселе луй.” ");
INSERT INTO ron1924_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Рубен а аузит лукрул ачеста ши л-а скос дин мыниле лор. Ел а зис: „Сэ ну-й луэм вяца!” ");
INSERT INTO ron1924_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Рубен ле-а зис: „Сэ ну вэрсаць сынӂе, чи май бине арункаци-л ын гроапа ачаста каре есте ын пустиу ши ну пунець мына пе ел.” Кэч авя де гынд сэ-л скапе дин мыниле лор ши сэ-л адукэ ынапой ла татэл сэу. ");
INSERT INTO ron1924_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Кынд а ажунс Иосиф ла фраций сэй, ачештя л-ау дезбрэкат де хайна луй, де хайна чя пестрицэ пе каре о авя пе ел. ");
INSERT INTO ron1924_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Л-ау луат ши л-ау арункат ын гроапэ. Гроапа ачаста ера гоалэ: ну ера апэ ын еа. ");
INSERT INTO ron1924_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Апой ау шезут сэ мэнынче. Ридикынду-шь окий, ау вэзут о чатэ де исмаелиць венинд дин Галаад; кэмилеле лор ерау ынкэркате ку тэмые, ку ляк алинэтор ши смирнэ, пе каре ле дучяу ын Еӂипт. ");
INSERT INTO ron1924_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Атунч, Иуда а зис фрацилор сэй: „Че вом кыштига сэ учидем пе фрателе ностру ши сэ-й аскундем сынӂеле? ");
INSERT INTO ron1924_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Вениць май бине сэ-л виндем исмаелицилор ши сэ ну пунем мына пе ел, кэч есте фрателе ностру, карне дин карня ноастрэ.” Ши фраций луй л-ау аскултат. ");
INSERT INTO ron1924_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Ла тречеря негусторилор мадианиць, ау трас ши ау скос пе Иосиф афарэ дин гроапэ ши л-ау вындут ку доуэзечь де сикли де арӂинт исмаелицилор, каре л-ау дус ын Еӂипт. ");
INSERT INTO ron1924_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Рубен с-а ынторс ла гроапэ ши ятэ кэ Иосиф ну май ера ын гроапэ. Ел шь-а рупт хайнеле, ");
INSERT INTO ron1924_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","с-а ынторс ла фраций сэй ши а зис: „Бэятул ну май есте! Че мэ вой фаче еу?” ");
INSERT INTO ron1924_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ей ау луат атунч хайна луй Иосиф ши, жунгиинд ун цап, й-ау ынмуят хайна ын сынӂе. ");
INSERT INTO ron1924_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ау тримис татэлуй лор хайна чя пестрицэ, пунынд сэ-й спунэ: „Ятэ че ам гэсит! Везь дакэ есте хайна фиулуй тэу сау ну.” ");
INSERT INTO ron1924_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Иаков а куноскут-о ши а зис: „Есте хайна фиулуй меу! О фярэ сэлбатикэ л-а мынкат! Да, Иосиф а фост фэкут букэць!” ");
INSERT INTO ron1924_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Ши шь-а рупт хайнеле, шь-а пус ун сак пе коапсе ши а желит мултэ време пе фиул сэу. ");
INSERT INTO ron1924_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Тоць фиий ши тоате фийчеле луй ау венит ка сэ-л мынгые, дар ел ну воя сэ примяскэ ничо мынгыере, чи зичя: „Плынгынд мэ вой коборы ла фиул меу, ын Локуинца морцилор.” Ши плынӂя астфел пе фиул сэу. ");
INSERT INTO ron1924_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Мадианиций л-ау вындут ын Еӂипт луй Потифар, ун дрегэтор ал луй Фараон, ши ануме кэпетения стрэжерилор. ");
INSERT INTO ron1924_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ын время ачея, Иуда а пэрэсит пе фраций сэй ши а трас ла ун ом дин Адулам, нумит Хира. ");
INSERT INTO ron1924_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Аколо, Иуда а вэзут пе фата унуй канаанит, нумит Шуа. А луат-о де невастэ ши с-а кулкат ку еа. ");
INSERT INTO ron1924_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Еа а рэмас ынсэрчинатэ ши а нэскут ун фиу, пе каре л-а нумит Ер. ");
INSERT INTO ron1924_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","А рэмас ярэшь ынсэрчинатэ ши а май нэскут ун фиу, кэруя й-а пус нумеле Онан. ");
INSERT INTO ron1924_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","А май нэскут ярэшь ун фиу, кэруя й-а пус нумеле Шела; Иуда ера ла Кзиб кынд а нэскут еа. ");
INSERT INTO ron1924_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Иуда а луат ынтыюлуй сэу нэскут, Ер, о невастэ нумитэ Тамар. ");
INSERT INTO ron1924_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ер, ынтыюл нэскут ал луй Иуда, ера рэу ынаинтя Домнулуй, ши Домнул л-а оморыт. ");
INSERT INTO ron1924_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Атунч, Иуда а зис луй Онан: „Ду-те ла неваста фрателуй тэу, я-о де невастэ, ка кумнат, ши ридикэ сэмынцэ фрателуй тэу.” ");
INSERT INTO ron1924_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Онан, штиинд кэ сэмынца ачаста н-аре сэ фие а луй, вэрса сэмынца пе пэмынт орь де кыте орь се кулка ку неваста фрателуй сэу, ка сэ ну дя сэмынцэ фрателуй сэу. ");
INSERT INTO ron1924_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Че фэчя ел н-а плэкут Домнулуй, каре л-а оморыт ши пе ел. ");
INSERT INTO ron1924_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Атунч, Иуда а зис нурорий сале Тамар: „Рэмый вэдувэ ын каса татэлуй тэу пынэ ва креште фиул меу Шела.” Зичя аша ка сэ ну моарэ ши Шела ка фраций луй. Тамар с-а дус ши а локуит ын каса татэлуй ей. ");
INSERT INTO ron1924_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Ау трекут мулте зиле ши фата луй Шуа, неваста луй Иуда, а мурит. Дупэ че ау трекут зилеле де жале, Иуда с-а суит ла Тимна, ла чей че-й тундяу оиле, ел ши приетенул сэу Хира, Адуламитул. ");
INSERT INTO ron1924_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Ау дат де весте Тамарей деспре лукрул ачеста ши й-ау зис: „Ятэ кэ сокру-тэу се суе ла Тимна, ка сэ-шь тундэ оиле.” ");
INSERT INTO ron1924_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Атунч, еа шь-а лепэдат хайнеле де вэдувэ, с-а акоперит ку о марамэ, с-а ымбрэкат ын алте хайне ши а шезут жос ла интраря ын Енаим, пе друмул каре дуче ла Тимна, кэч ведя кэ Шела се фэкусе маре, ши еа ну-й фусесе датэ де невастэ. ");
INSERT INTO ron1924_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Иуда а вэзут-о ши а луат-о дрепт курвэ, пентру кэ ышь акоперисе фаца. ");
INSERT INTO ron1924_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","С-а абэтут ла еа дин друм ши а зис: „Ласэ-мэ сэ мэ кулк ку тине!” Кэч н-а куноскут-о кэ ера норэ-са. Еа а зис: „Че-мь дай ка сэ те кулчь ку мине?” ");
INSERT INTO ron1924_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Ел а рэспунс: „Ам сэ-ць тримит ун ед дин турма мя.” Еа а зис: „Ымь дай ун зэлог пынэ ыл вей тримите?” ");
INSERT INTO ron1924_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Ел а рэспунс: „Че зэлог сэ-ць дау?” Еа а зис: „Инелул тэу, ланцул тэу ши тоягул пе каре-л ай ын мынэ.” Ел и ле-а дат. Апой с-а кулкат ку еа ши еа а рэмас ынсэрчинатэ де ла ел. ");
INSERT INTO ron1924_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Еа с-а скулат ши а плекат; шь-а скос марама ши с-а ымбрэкат ярэшь ын хайнеле де вэдувэ. ");
INSERT INTO ron1924_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Иуда а тримис едул прин приетенул сэу Адуламитул, ка сэ скоатэ зэлогул дин мыниле фемеий. Дар ачеста н-а гэсит-о. ");
INSERT INTO ron1924_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","А ынтребат пе оамений локулуй ши а зис: „Унде есте курва ачея каре стэтя аич, ла Енаим, пе друм?” Ей ау рэспунс: „Н-а фост ничо курвэ аич.” ");
INSERT INTO ron1924_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Адуламитул с-а ынторс ла Иуда ши й-а спус: „Н-ам гэсит-о ши кяр оамений де аколо ау зис: ‘Н-а фост ничо курвэ аич.’” ");
INSERT INTO ron1924_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Иуда а зис: „Цинэ че а луат, нумай сэ ну не фачем де рыс. Ятэ, ам тримис едул ачеста, ши н-ай гэсит-о.” ");
INSERT INTO ron1924_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Кам дупэ трей лунь, ау венит ши ау спус луй Иуда: „Тамар, норэ-та, а курвит ши а рэмас кяр ынсэрчинатэ ын урма курвирий ей.” Ши Иуда а зис: „Скоатець-о афарэ ка сэ фие арсэ.” ");
INSERT INTO ron1924_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Дупэ че ау скос-о афарэ, еа а тримис сэ спунэ сокрулуй сэу: „Де ла омул ачела але куй сунт лукруриле ачестя ам рэмас еу ынсэрчинатэ; везь, те рог, але куй сунт инелул ачеста, ланцуриле ачестя ши тоягул ачеста.” ");
INSERT INTO ron1924_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Иуда ле-а куноскут ши а зис: „Еа есте май пуцин виноватэ декыт мине, фииндкэ н-ам дат-о де невастэ фиулуй меу Шела.” Ши ну с-а май ымпреунат ку еа де атунч. ");
INSERT INTO ron1924_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Кынд й-а венит время сэ наскэ, ятэ кэ ын пынтечеле ей ерау дой ӂемень. ");
INSERT INTO ron1924_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Ши, ын тимпул наштерий, унул а скос мына ынаинте; моаша й-а апукат мына ши а легат-о ку ун фир рошу, зикынд: „Ачеста а ешит чел динтый.” ");
INSERT INTO ron1924_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Дар ел а трас мына ынапой ши а ешит фрате-сэу. Атунч, моаша а зис: „Че спэртурэ ай фэкут!” Де ачея й-а пус нумеле Перец. ");
INSERT INTO ron1924_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Ын урмэ а ешит фрателе луй, каре авя фирул рошу ла мынэ; де ачея й-ау пус нумеле Зерах. ");
INSERT INTO ron1924_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Иосиф а фост дус ын Еӂипт, ши Потифар, дрегэторул луй Фараон, кэпетения стрэжерилор, ун еӂиптян, л-а кумпэрат де ла исмаелиций каре-л адусесерэ аколо. ");
INSERT INTO ron1924_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Домнул а фост ку Иосиф, аша кэ тоате ый мерӂяу бине; ел локуя ын каса стэпынулуй сэу, еӂиптянул. ");
INSERT INTO ron1924_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Стэпынул луй а вэзут кэ Домнул ера ку ел ши кэ Домнул фэчя сэ-й мяргэ бине орь де че се апука. ");
INSERT INTO ron1924_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Иосиф а кэпэтат маре тречере ынаинтя стэпынулуй сэу, каре л-а луат ын служба луй, л-а пус май-маре песте каса луй ши й-а ынкрединцат тот че авя. ");
INSERT INTO ron1924_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Де ындатэ че Потифар л-а пус май-маре песте каса луй ши песте тот че авя, Домнул а бинекувынтат каса еӂиптянулуй дин причина луй Иосиф, ши бинекувынтаря Домнулуй а фост песте тот че авя ел: фие акасэ, фие ла кымп. ");
INSERT INTO ron1924_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Еӂиптянул а лэсат пе мыниле луй Иосиф тот че авя ши н-авя алтэ грижэ декыт сэ мэнынче ши сэ бя. Дар Иосиф ера фрумос ла статурэ ши плэкут ла кип. ");
INSERT INTO ron1924_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Дупэ кытэва време, с-а ынтымплат кэ неваста стэпынулуй сэу а пус окий пе Иосиф ши а зис: „Кулкэ-те ку мине!” ");
INSERT INTO ron1924_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ел н-а воит ши а зис невестей стэпынулуй сэу: „Везь кэ стэпынул меу ну-мь чере сокотялэ де нимик дин касэ ши мь-а дат пе мынэ тот че аре. ");
INSERT INTO ron1924_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ел ну есте май маре декыт мине ын каса ачаста ши ну мь-а оприт нимик, афарэ де тине, пентру кэ ешть неваста луй. Кум аш путя сэ фак еу ун рэу атыт де маре ши сэ пэкэтуеск ымпотрива луй Думнезеу?” ");
INSERT INTO ron1924_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Мэкар кэ еа ворбя ын тоате зилеле луй Иосиф, ел н-а воит сэ се кулче ши сэ се ымпреуне ку еа. ");
INSERT INTO ron1924_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Ынтр-о зи, кынд интрасе ын касэ ка сэ-шь факэ лукрул ши кынд ну ера аколо ничунул дин оамений касей, ");
INSERT INTO ron1924_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","еа л-а апукат де хайнэ, зикынд: „Кулкэ-те ку мине!” Ел й-а лэсат хайна ын мынэ ши а фуӂит афарэ дин касэ. ");
INSERT INTO ron1924_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Кынд а вэзут еа кэ-й лэсасе хайна ын мынэ ши фуӂисе афарэ, ");
INSERT INTO ron1924_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","а кемат оамений дин касэ ши ле-а зис: „Ведець, не-а адус ун евреу ка сэ-шь батэ жок де ной! Омул ачеста а венит ла мине ка сэ се кулче ку мине, дар еу ам ципат ын гура маре. ");
INSERT INTO ron1924_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Ши, кынд а вэзут кэ ридик гласул ши стриг, шь-а лэсат хайна лынгэ мине ши а фуӂит афарэ.” ");
INSERT INTO ron1924_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ши а пус хайна луй Иосиф лынгэ еа пынэ с-а ынторс акасэ стэпынул луй. ");
INSERT INTO ron1924_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Атунч й-а ворбит астфел: „Робул ачела евреу пе каре ни л-ай адус а венит ла мине ка сэ-шь батэ жок де мине. ");
INSERT INTO ron1924_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ши кум ам ридикат гласул ши ам ципат, шь-а лэсат хайна лынгэ мине ши а фуӂит афарэ.” ");
INSERT INTO ron1924_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Дупэ че а аузит кувинтеле невестей сале, каре-й зичя: „Ятэ че мь-а фэкут робул тэу”, стэпынул луй Иосиф с-а мыният фоарте таре. ");
INSERT INTO ron1924_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","А луат пе Иосиф ши л-а арункат ын темницэ, ын локул унде ерау ынкишь ынтемницаций ымпэратулуй, ши астфел Иосиф а стат аколо, ын темницэ. ");
INSERT INTO ron1924_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Домнул а фост ку Иосиф ши Шь-а ынтинс бунэтатя песте ел. Л-а фэкут сэ капете тречере ынаинтя май-марелуй темницей. ");
INSERT INTO ron1924_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ши май-мареле темницей а пус суб привегеря луй пе тоць ынтемницаций каре ерау ын темницэ. Ши нимик ну се фэчя аколо декыт прин ел. ");
INSERT INTO ron1924_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Май-мареле темницей ну се май ынгрижя де нимик дин че авя Иосиф ын мынэ, пентру кэ Домнул ера ку ел. Ши Домнул ый дэдя избындэ ын тот че фэчя. ");
INSERT INTO ron1924_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Дупэ кытэва време, с-а ынтымплат кэ пахарникул ши питарул ымпэратулуй Еӂиптулуй ау супэрат пе стэпынул лор, ымпэратул Еӂиптулуй. ");
INSERT INTO ron1924_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Фараон с-а мыният пе чей дой дрегэторь ай сэй: пе май-мареле пахарничилор ши пе май-мареле питарилор. ");
INSERT INTO ron1924_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Ши й-а пус суб пазэ ын каса кэпетенией стрэжерилор, ын темницэ, ын локул унде фусесе ынкис Иосиф. ");
INSERT INTO ron1924_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Кэпетения стрэжерилор й-а пус суб суправегеря луй Иосиф, каре фэчя де службэ лынгэ ей, ши ау стат май мултэ време ын темницэ. ");
INSERT INTO ron1924_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Пахарникул ши питарул ымпэратулуй Еӂиптулуй, каре ерау ынкишь ын темницэ, ау висат ынтр-о ноапте амындой кыте ун вис, ши ануме фиекаре кыте ун вис каре путя сэ капете о тэлмэчире деосебитэ. ");
INSERT INTO ron1924_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Иосиф, кынд а венит диминяца ла ей, с-а уйтат ла ей ши й-а вэзут тришть. ");
INSERT INTO ron1924_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Атунч а ынтребат пе дрегэторий луй Фараон, каре ерау ку ел ын темница стэпынулуй сэу, ши ле-а зис: „Пентру че авець о фацэ аша де посоморытэ азь?” ");
INSERT INTO ron1924_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ей й-ау рэспунс: „Ам висат ун вис ши ну есте нимень каре сэ-л тэлмэчяскэ.” Иосиф ле-а зис: „Тэлмэчириле сунт але луй Думнезеу. Историсици-мь дар висул востру.” ");
INSERT INTO ron1924_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Май-мареле пахарничилор шь-а историсит луй Иосиф висул ши й-а зис: „Ын висул меу, се фэчя кэ ынаинтя мя ера о вицэ. ");
INSERT INTO ron1924_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Вица ачаста авя трей млэдице. Кынд а ынчепут сэ дя лэстарь, и с-а дескис флоаря, ши чоркинеле ау фэкут стругурь копць. ");
INSERT INTO ron1924_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Пахарул луй Фараон ера ын мына мя. Еу ам луат стругурий, й-ам сторс ын пахарул луй Фараон ши ам пус пахарул ын мына луй Фараон.” ");
INSERT INTO ron1924_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Иосиф й-а зис: „Ятэ тэлмэчиря висулуй. Челе трей млэдице сунт трей зиле. ");
INSERT INTO ron1924_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Песте трей зиле, Фараон те ва скоате дин темницэ, те ва пуне ярэшь ын служба та ши вей пуне ярэшь пахарул ын мына луй Фараон, кум обишнуяй май ынаинте, кынд ерай пахарникул луй. ");
INSERT INTO ron1924_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Дар аду-ць аминте ши де мине кынд вей фи феричит ши аратэ, рогу-те, бунэтате фацэ де мине; пуне о ворбэ бунэ пентру мине ла Фараон ши скоате-мэ дин каса ачаста. ");
INSERT INTO ron1924_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Кэч ам фост луат ку сила дин цара евреилор ши кяр аич н-ам фэкут нимик ка сэ фиу арункат ын темницэ.” ");
INSERT INTO ron1924_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Май-мареле питарилор, вэзынд кэ Иосиф дэдусе о тэлмэчире ымбукурэтоаре, а зис: „Ятэ, ши ын висул меу се фэчя кэ порт трей кошурь ку пыне албэ пе капул меу. ");
INSERT INTO ron1924_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Ын кошул де дясупра де тот ерау тот фелул де букате пентру Фараон – прэжитурь коапте ын куптор – ши пэсэриле мынкау дин кошул каре ера дясупра де тот, пе капул меу.” ");
INSERT INTO ron1924_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Иосиф а рэспунс ши а зис: „Ятэ-й тэлмэчиря. Челе трей кошурь сунт трей зиле. ");
INSERT INTO ron1924_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Песте трей зиле, Фараон ыць ва луа капул, те ва спынзура де ун лемн, ши карня ць-о вор мынка пэсэриле.” ");
INSERT INTO ron1924_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","А трея зи, ера зиуа наштерий луй Фараон. Ел а дат ун оспэц тутурор служиторилор сэй ши а скос афарэ дин темницэ пе май-мареле пахарничилор ши пе май-мареле питарилор, ын фаца служиторилор сэй: ");
INSERT INTO ron1924_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","пе май-мареле пахарничилор л-а пус ярэшь ын служба луй де пахарник, ка сэ пунэ пахарул ын мына луй Фараон, ");
INSERT INTO ron1924_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","яр пе май-мареле питарилор л-а спынзурат, дупэ тэлмэчиря пе каре ле-о дэдусе Иосиф. ");
INSERT INTO ron1924_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Май-мареле пахарничилор ну с-а май гындит ынсэ ла Иосиф. Л-а уйтат. ");
INSERT INTO ron1924_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Дупэ дой ань, Фараон а висат ун вис. И се пэря кэ стэтя лынгэ рыу. ");
INSERT INTO ron1924_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Ши ятэ кэ шапте вачь фрумоасе ла ведере ши грасе ла труп с-ау суит дин рыу ши ау ынчепут сэ паскэ прин млаштинь. ");
INSERT INTO ron1924_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Дупэ еле с-ау май суит дин рыу алте шапте вачь, урыте ла ведере ши слабе ла труп, ши с-ау ашезат лынгэ еле, пе марӂиня рыулуй. ");
INSERT INTO ron1924_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Вачиле урыте ла ведере ши слабе ла труп ау мынкат пе челе шапте вачь фрумоасе ла ведере ши грасе ла труп. Ши Фараон с-а трезит. ");
INSERT INTO ron1924_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","А адормит дин ноу ши а висат ун ал дойля вис. Се фэчя кэ шапте спиче де грыу грасе ши фрумоасе ау крескут пе ачелашь пай. ");
INSERT INTO ron1924_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Ши дупэ еле ау рэсэрит алте шапте спиче, слабе ши арсе де вынтул де рэсэрит. ");
INSERT INTO ron1924_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Спичеле слабе ау ынгицит пе челе шапте спиче грасе ши плине. Ши Фараон с-а трезит. Ятэ висул. ");
INSERT INTO ron1924_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Диминяца, Фараон с-а тулбурат ши а тримис сэ кеме пе тоць маӂий ши пе тоць ынцелепций Еӂиптулуй. Ле-а историсит виселе луй. Дар нимень н-а путут сэ ле тэлмэчяскэ луй Фараон. ");
INSERT INTO ron1924_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Атунч, май-мареле пахарничилор а луат кувынтул ши а зис луй Фараон: „Мь-адук аминте астэзь де грешяла мя. ");
INSERT INTO ron1924_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Фараон се мыниясе пе служиторий луй ши мэ арункасе ын темницэ, ын каса кэпетенией стрэжерилор, пе мине ши пе май-мареле питарилор. ");
INSERT INTO ron1924_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Амындой ам висат кыте ун вис ын ачеяшь ноапте, ши ануме фиекаре дин ной а висат ун вис каре а примит о тэлмэчире деосебитэ. ");
INSERT INTO ron1924_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ера аколо ку ной ун тынэр евреу, роб ал кэпетенией стрэжерилор. Й-ам историсит виселе ноастре, ши ел ни ле-а тэлмэчит ши не-а спус ынтокмай че ынсямнэ висул фиекэруя. ");
INSERT INTO ron1924_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Лукруриле с-ау ынтымплат ынтокмай дупэ тэлмэчиря пе каре не-о дэдусе ел. Пе мине, Фараон м-а пус ярэшь ын служба мя, яр пе май-мареле питарилор л-а спынзурат.” ");
INSERT INTO ron1924_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Фараон а тримис сэ кеме пе Иосиф. Л-ау скос ын грабэ дин темницэ. Иосиф с-а рас, шь-а скимбат хайнеле ши с-а дус ла Фараон. ");
INSERT INTO ron1924_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Фараон а зис луй Иосиф: „Ам висат ун вис. Нимень ну л-а путут тэлмэчи ши ам афлат кэ ту тэлмэчешть ун вис ындатэ дупэ че л-ай аузит.” ");
INSERT INTO ron1924_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Иосиф а рэспунс луй Фараон: „Ну еу! Думнезеу есте Ачела каре ва да ун рэспунс приелник луй Фараон!” ");
INSERT INTO ron1924_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Фараон а ынчепут сэ историсяскэ атунч луй Иосиф: „Ын висул меу, се фэчя кэ стэтям пе малул рыулуй. ");
INSERT INTO ron1924_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Ши деодатэ, шапте вачь грасе ла труп ши фрумоасе ла кип с-ау суит дин рыу ши ау ынчепут сэ паскэ прин млаштинь. ");
INSERT INTO ron1924_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Дупэ еле, с-ау суит алте шапте вачь слабе, фоарте урыте ла кип ши сфрижите: н-ам май вэзут алтеле аша де урыте ын тоатэ цара Еӂиптулуй. ");
INSERT INTO ron1924_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Вачиле челе сфрижите ши слабе ау мынкат пе челе шапте вачь динтый, каре ерау грасе. ");
INSERT INTO ron1924_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ле-ау ынгицит, фэрэ сэ се поатэ куноаште кэ интрасерэ ын пынтечеле лор; ба ынкэ ынфэцишаря лор ера тот аша де урытэ ка май ынаинте. Ши м-ам дештептат. ");
INSERT INTO ron1924_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Ам май вэзут ын вис шапте спиче плине ши фрумоасе, каре крештяу пе ачелашь пай. ");
INSERT INTO ron1924_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Ши дупэ еле ау рэсэрит шапте спиче гоале, слабе, арсе де вынтул де рэсэрит. ");
INSERT INTO ron1924_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Спичеле слабе ау ынгицит пе челе шапте спиче фрумоасе. Ам спус ачесте лукрурь маӂилор, дар нимень ну ми ле-а путут тэлмэчи.” ");
INSERT INTO ron1924_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Иосиф а зис луй Фараон: „Че а висат Фараон ынсямнэ ун сингур лукру: Думнезеу а арэтат май динаинте луй Фараон че аре сэ факэ. ");
INSERT INTO ron1924_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Челе шапте вачь фрумоасе ынсямнэ шапте ань ши челе шапте спиче фрумоасе ынсямнэ шапте ань: есте ун сингур вис. ");
INSERT INTO ron1924_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Челе шапте вачь сфрижите ши урыте, каре се суяу дупэ челе динтый, ынсямнэ шапте ань, ши челе шапте спиче гоале, арсе де вынтул де рэсэрит, вор фи шапте ань де фоамете. ");
INSERT INTO ron1924_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Астфел, дупэ кум ам спус луй Фараон, Думнезеу а арэтат луй Фараон че аре сэ факэ. ");
INSERT INTO ron1924_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Ятэ, вор фи шапте ань де маре белшуг ын тоатэ цара Еӂиптулуй. ");
INSERT INTO ron1924_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Дупэ ей, вор вени шапте ань де фоамете, аша кэ се ва уйта тот белшугул ачеста ын цара Еӂиптулуй, ши фоаметя ва топи цара. ");
INSERT INTO ron1924_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Фоаметя ачаста каре ва урма ва фи аша де маре кэ ну се ва май куноаште белшугул ын царэ. ");
INSERT INTO ron1924_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Кыт привеште фаптул кэ Фараон а висат висул де доуэ орь, ынсямнэ кэ лукрул есте хотэрыт дин партя луй Думнезеу ши кэ Думнезеу Се ва грэби сэ-л адукэ ла ындеплинире. ");
INSERT INTO ron1924_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Акум, Фараон сэ алягэ ун ом причепут ши ынцелепт ши сэ-л пунэ ын фрунтя цэрий Еӂиптулуй. ");
INSERT INTO ron1924_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Фараон сэ пунэ префекць ын царэ, ка сэ ридиче о чинчиме дин роаделе Еӂиптулуй ын тимпул челор шапте ань де белшуг. ");
INSERT INTO ron1924_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Сэ се стрынгэ тоате букателе дин ачешть ань бунь каре ау сэ винэ; сэ се факэ, ла ындемына луй Фараон, грэмезь де грыу, провизий ын четэць, ши сэ ле пэзяскэ. ");
INSERT INTO ron1924_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Букателе ачестя вор фи провизия цэрий пентру чей шапте ань де фоамете каре вор вени ын цара Еӂиптулуй, пентру ка цара сэ ну фие прэпэдитэ де фоамете.” ");
INSERT INTO ron1924_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Кувинтеле ачестя ау плэкут луй Фараон ши тутурор служиторилор луй. ");
INSERT INTO ron1924_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Ши Фараон а зис служиторилор сэй: „Ам путя ной оаре сэ гэсим ун ом ка ачеста, каре сэ айбэ ын ел Духул луй Думнезеу?” ");
INSERT INTO ron1924_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Ши Фараон а зис луй Иосиф: „Фииндкэ Думнезеу ць-а фэкут куноскуте тоате ачесте лукрурь, ну есте нимень каре сэ фие атыт де причепут ши атыт де ынцелепт ка тине. ");
INSERT INTO ron1924_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Те пун май-маре песте каса мя ши тот попорул меу ва аскулта де порунчиле тале. Нумай скаунул меу де домние мэ ва ридика май пресус де тине.” ");
INSERT INTO ron1924_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Фараон а зис луй Иосиф: „Уйте, ыць дау стэпынире песте тоатэ цара Еӂиптулуй.” ");
INSERT INTO ron1924_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Фараон шь-а скос инелул дин деӂет ши л-а пус ын деӂетул луй Иосиф; л-а ымбрэкат ку хайне де ин субцире ши й-а пус ун ланц де аур ла гыт. ");
INSERT INTO ron1924_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Л-а суит ын карул каре веня дупэ ал луй ши стригау ынаинтя луй: „Ын ӂенункь!” Астфел й-а дат Фараон стэпынире песте тоатэ цара Еӂиптулуй. ");
INSERT INTO ron1924_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Ши а май зис луй Иосиф: „Еу сунт Фараон! Дар фэрэ тине нимень ну ва ридика мына, нич пичорул, ын тоатэ цара Еӂиптулуй.” ");
INSERT INTO ron1924_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Фараон а пус луй Иосиф нумеле: Цафнат-Паенях ши й-а дат де невастэ пе Аснат, фата луй Поти-Фера, преотул луй Он. Ши Иосиф а порнит сэ черчетезе цара Еӂиптулуй. ");
INSERT INTO ron1924_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Иосиф ера ын вырстэ де трейзечь де ань кынд с-а ынфэцишат ынаинтя луй Фараон, ымпэратул Еӂиптулуй, ши а плекат де ла Фараон ши а стрэбэтут тоатэ цара Еӂиптулуй. ");
INSERT INTO ron1924_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Ын тимпул челор шапте ань де род, пэмынтул а дат букате дин белшуг. ");
INSERT INTO ron1924_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Иосиф а стрынс тоате букателе дин ачешть шапте ань де белшуг ын цара Еӂиптулуй. А фэкут провизий ын четэць, пунынд ын фиекаре четате букателе де пе кымпул де примпрежур. ");
INSERT INTO ron1924_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Иосиф а стрынс грыу ка нисипул мэрий, атыт де мулт, кэ ау ынчетат сэ-л май мэсоаре, пентру кэ ера фэрэ мэсурэ. ");
INSERT INTO ron1924_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Ынаинтя анилор де фоамете, и с-ау нэскут луй Иосиф дой фий, пе каре й-а нэскут Аснат, фата луй Поти-Фера, преотул луй Он. ");
INSERT INTO ron1924_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Иосиф а пус ынтыюлуй нэскут нумеле Манасе „кэч”, а зис ел, „Думнезеу м-а фэкут сэ уйт тоате неказуриле меле ши тоатэ каса татэлуй меу”. ");
INSERT INTO ron1924_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Ши челуй де ал дойля й-а пус нумеле Ефраим „кэч”, а зис ел, „Думнезеу м-а фэкут родитор ын цара ынтристэрий меле”. ");
INSERT INTO ron1924_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Чей шапте ань де белшуг каре ау фост ын цара Еӂиптулуй ау трекут ");
INSERT INTO ron1924_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ши ау ынчепут сэ винэ чей шапте ань де фоамете, аша кум вестисе Иосиф. Ын тоате цэриле ера фоамете, дар ын тоатэ цара Еӂиптулуй ера пыне. ");
INSERT INTO ron1924_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Кынд а флэмынзит, ын сфыршит, тоатэ цара Еӂиптулуй, попорул а стригат ла Фараон сэ-й дя пыне. Фараон а спус тутурор еӂиптенилор: „Дучеци-вэ ла Иосиф ши фачець че вэ ва спуне ел.” ");
INSERT INTO ron1924_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Фоаметя бынтуя ын тоатэ цара. Иосиф а дескис тоате локуриле ку провизий ши а вындут грыу еӂиптенилор. Фоаметя крештя дин че ын че май мулт ын цара Еӂиптулуй. ");
INSERT INTO ron1924_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Ши дин тоате цэриле веня лумя ын Еӂипт ка сэ кумпере грыу де ла Иосиф, кэч ын тоате цэриле ера фоамете маре. ");
INSERT INTO ron1924_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Кынд а аузит Иаков кэ есте грыу ын Еӂипт, а зис фиилор сэй: „Пентру че стаць ши вэ уйтаць уний ла алций?” ");
INSERT INTO ron1924_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Ши а зис: „Ятэ, ауд кэ есте грыу ын Еӂипт; коборыци-вэ ши кумпэраци-не грыу де аколо, ка сэ трэим ши сэ ну мурим.” ");
INSERT INTO ron1924_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Зече фраць ай луй Иосиф с-ау коборыт ын Еӂипт ка сэ кумпере грыу. ");
INSERT INTO ron1924_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Иаков н-а тримис ку ей пе Бениамин, фрателе луй Иосиф, де тямэ сэ ну и се ынтымпле врео ненорочире. ");
INSERT INTO ron1924_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Фиий луй Исраел ау венит сэ кумпере ши ей грыу, ымпреунэ ку чей че веняу пентру ачелашь лукру, кэч ын Канаан ера фоамете. ");
INSERT INTO ron1924_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Иосиф ера май-маре ын царэ; ел виндя грыу ла тот попорул дин царэ. Фраций луй Иосиф ау венит ши с-ау арункат ку фаца ла пэмынт ынаинтя луй. ");
INSERT INTO ron1924_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Иосиф, кум а вэзут пе фраций сэй, й-а куноскут, дар с-а фэкут кэ ле есте стрэин, ле-а ворбит аспру ши ле-а зис: „Де унде вениць?” Ей ау рэспунс: „Веним дин цара Канаан ка сэ кумпэрэм меринде.” ");
INSERT INTO ron1924_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Иосиф а куноскут пе фраций сэй, дар ей ну л-ау куноскут. ");
INSERT INTO ron1924_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Иосиф шь-а адус аминте де виселе пе каре ле висасе ку привире ла ей ши ле-а зис: „Вой сунтець искоаде; аць венит нумай ка сэ черчетаць локуриле слабе але цэрий.” ");
INSERT INTO ron1924_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ей й-ау рэспунс: „Ну, домнул меу, робий тэй ау венит сэ кумпере хранэ. ");
INSERT INTO ron1924_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ной тоць сунтем фиий ачелуяшь ом; сунтем оамень де трябэ, робий тэй ну сунт искоаде.” ");
INSERT INTO ron1924_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Ел ле-а зис: „Ба ну, аць венит сэ черчетаць локуриле слабе але цэрий.” ");
INSERT INTO ron1924_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ей ау рэспунс: „Ной, робий тэй, сунтем дойспрезече фраць, фий ай ачелуяшь ом, дин цара Канаан; ши, ятэ, чел май тынэр есте азь ку татэл ностру, яр унул ну май есте ын вяцэ.” ");
INSERT INTO ron1924_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Иосиф ле-а зис: „В-ам спус кэ сунтець искоаде. ");
INSERT INTO ron1924_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ятэ кум вець фи ынчеркаць. Пе вяца луй Фараон кэ ну вець еши де аич пынэ ну ва вени фрателе востру чел тынэр! ");
INSERT INTO ron1924_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Тримитець пе унул дин вой сэ адукэ пе фрателе востру, яр вой рэмынець ла опрялэ. Кувинтеле воастре вор фи пусе астфел ла ынчеркаре ши вой шти дакэ адевэрул есте ку вой сау ну; алтфел, пе вяца луй Фараон кэ сунтець ниште искоаде.” ");
INSERT INTO ron1924_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ши й-а арункат пе тоць трей зиле ын темницэ. ");
INSERT INTO ron1924_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","А трея зи, Иосиф ле-а зис: „Фачець лукрул ачеста, ши вець трэи. Еу мэ тем де Думнезеу! ");
INSERT INTO ron1924_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Дакэ сунтець оамень де трябэ, сэ рэмынэ унул дин фраций воштри ынкис ын темница воастрэ, яр чейлалць плекаць, луаць грыу ка сэ вэ хрэниць фамилииле ");
INSERT INTO ron1924_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","ши адучеци-мь пе фрателе востру чел тынэр, пентру ка ворбеле воастре сэ фие пусе астфел ла ынчеркаре ши сэ скэпаць де моарте.” Ши аша ау фэкут. ");
INSERT INTO ron1924_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ей ау зис атунч унул кэтре алтул: „Да, ам фост виноваць фацэ де фрателе ностру, кэч ам вэзут нелиништя суфлетулуй луй кынд не руга, ши ну л-ам аскултат! Пентру ачея вине песте ной неказул ачеста.” ");
INSERT INTO ron1924_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Рубен а луат кувынтул ши ле-а зис: „Ну вэ спуням еу сэ ну фачець о астфел де нелеӂюире фацэ де бэятул ачеста? Дар н-аць аскултат. Акум ятэ кэ ни се чере сокотялэ пентру сынӂеле луй.” ");
INSERT INTO ron1924_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Ей ну штияу кэ Иосиф ый ынцелеӂя, кэч ворбя ку ей принтр-ун тэлмачь. ");
INSERT INTO ron1924_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Иосиф а плекат ла о парте де ла ей ка сэ плынгэ. Ын урмэ с-а ынторс ши ле-а ворбит, апой а луат динтре ей пе Симеон ши а пус сэ-л леӂе ку ланцурь ын фаца лор. ");
INSERT INTO ron1924_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Иосиф а порунчит сэ ли се умпле сачий ку грыу, сэ пунэ арӂинтул фиекэруя ын сакул луй ши сэ ли се дя меринде пентру друм. Ши аша с-а фэкут. ");
INSERT INTO ron1924_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ей шь-ау ынкэркат грыул пе мэгарь ши ау плекат. ");
INSERT INTO ron1924_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Унул динтре ей шь-а дескис сакул ка сэ дя нутрец мэгарулуй ын локул унде ау рэмас песте ноапте. А вэзут арӂинтул ла гура сакулуй ");
INSERT INTO ron1924_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","ши а зис фрацилор сэй: „Арӂинтул меу ми с-а дат ынапой ши ятэ-л ын сакул меу.” Атунч ли с-а тэят инима ши ау зис унул алтуя, тремурынд: „Че не-а фэкут Думнезеу?” ");
INSERT INTO ron1924_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","С-ау ынторс ла татэл лор Иаков, ын цара Канаан, ши й-ау историсит тот че ли се ынтымпласе. Ей ау зис: ");
INSERT INTO ron1924_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","„Омул ачела, каре есте домнул цэрий, не-а ворбит аспру ши не-а луат дрепт искоаде. ");
INSERT INTO ron1924_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ной й-ам спус: ‘Сунтем оамень де трябэ, ну сунтем искоаде. ");
INSERT INTO ron1924_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Сунтем дойспрезече фраць, фий ай татэлуй ностру; унул ну май есте, ши чел май тынэр есте азь ку татэл ностру ын цара Канаан.’ ");
INSERT INTO ron1924_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ши омул ачела, каре есте домнул цэрий, не-а зис: ‘Ятэ кум вой куноаште дакэ сунтець оамень де трябэ. Лэсаць ла мине пе унул дин фраций воштри, луаць меринде пентру фамилииле воастре, плекаць ");
INSERT INTO ron1924_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","ши адучеци-мь пе фрателе востру чел тынэр. Вой шти астфел кэ ну сунтець искоаде, чи сунтець оамень де трябэ; апой вэ вой да ынапой пе фрателе востру ши вець путя сэ стрэбатець цара ын вое.’” ");
INSERT INTO ron1924_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Кынд шь-ау голит сачий, ятэ кэ легэтура ку арӂинтул фиекэруя ера ын сакул луй. Ей ши татэл лор ау вэзут легэтуриле ку арӂинтул ши с-ау темут. ");
INSERT INTO ron1924_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Татэл лор Иаков ле-а зис: „Вой мэ липсиць де копий: Иосиф ну май есте, Симеон ну май есте ши воиць сэ луаць ши пе Бениамин. Тоате ачестя пе мине мэ ловеск!” ");
INSERT INTO ron1924_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Рубен а зис татэлуй сэу: „Сэ-мь оморь пе амындой фиий мей дакэ ну-ць вой адуче ынапой пе Бениамин; дэ-л ын мына мя ши ци-л вой адуче ынапой.” ");
INSERT INTO ron1924_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Иаков а зис: „Фиул меу ну се поате коборы ымпреунэ ку вой; кэч фрателе луй а мурит ши ел а рэмас сингур; дакэ и с-ар ынтымпла врео ненорочире ын кэлэтория пе каре о фачець, ку дурере ымь вець коборы перий мей чей албь ын Локуинца морцилор.” ");
INSERT INTO ron1924_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Фоаметя бынтуя греу ын царэ. ");
INSERT INTO ron1924_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Кынд ау испрэвит де мынкат грыул пе каре-л адусесерэ дин Еӂипт, Иаков а зис фиилор сэй: „Дучеци-вэ ярэшь ши кумпэраци-не чева меринде.” ");
INSERT INTO ron1924_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Иуда й-а рэспунс: „Омул ачела не-а спус курат: ‘Сэ ну-мь май ведець фаца дакэ фрателе востру ну ва фи ку вой.’ ");
INSERT INTO ron1924_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Дакэ врей деч сэ тримиць пе фрателе ностру ку ной, не вом коборы ши-ць вом кумпэра меринде. ");
INSERT INTO ron1924_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Дар, дакэ ну врей сэ-л тримиць, ну не вом коборы, кэч омул ачела не-а спус: ‘Сэ ну-мь май ведець фаца дакэ фрателе востру ну ва фи ку вой!’” ");
INSERT INTO ron1924_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Исраел а зис атунч: „Пентру че мь-аць фэкут ун астфел де рэу ши аць спус омулуй ачелуя кэ май авець ун фрате?” ");
INSERT INTO ron1924_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ей ау рэспунс: „Омул ачела не-а ынтребат деспре ной ши фамилия ноастрэ ши а зис: ‘Май трэеште татэл востру? Май авець вреун фрате?’ Ши ной ам рэспунс ла ынтребэриле ачестя. Путям ной сэ штим кэ аре сэ зикэ: ‘Адучець пе фрателе востру’?” ");
INSERT INTO ron1924_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Иуда а зис татэлуй сэу Исраел: „Тримите копилул ку мине, ка сэ не скулэм ши сэ плекэм, ши вом трэи ши ну вом мури, ной, ту ши копиий ноштри. ");
INSERT INTO ron1924_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Рэспунд еу пентру ел; ай сэ-л черь ынапой дин мына мя. Дакэ ну-л вой адуче ынапой ла тине ши дакэ ну-л вой пуне ынаинтя та, виноват сэ фиу фацэ де тине пентру тотдяуна. ");
INSERT INTO ron1924_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Кэч, дакэ н-ам май фи зэбовит, де доуэ орь не-ам фи ынторс пынэ акум.” ");
INSERT INTO ron1924_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Исраел, татэл лор, ле-а зис: „Фииндкэ требуе, фачець аша. Луаци-вэ ын сачь чева дин челе май буне роаде але цэрий, ка сэ дучець ун дар омулуй ачелуя, ши ануме: пуцин ляк алинэтор ши пуцинэ мьере, миродений, смирнэ, фистикурь ши мигдале. ");
INSERT INTO ron1924_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Луаць ку вой арӂинт ындоит ши дучець ынапой арӂинтул пе каре ви-л пусесерэ ла гура сачилор: поате кэ а фост о грешялэ. ");
INSERT INTO ron1924_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Луаць ши пе фрателе востру, скулаци-вэ ши ынтоарчеци-вэ ла омул ачела. ");
INSERT INTO ron1924_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Думнезеул чел Атотпутерник сэ вэ факэ сэ кэпэтаць тречере ынаинтя омулуй ачелуя ши сэ ласе сэ се ынтоаркэ ымпреунэ ку вой пе челэлалт фрате ал востру ши пе Бениамин! Яр еу, дакэ требуе сэ фиу липсит де копиий мей, липсит сэ фиу!” ");
INSERT INTO ron1924_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ау луат дарул; ау луат ку ей арӂинт ындоит, прекум ши пе Бениамин; с-ау скулат, с-ау коборыт ын Еӂипт ши с-ау ынфэцишат ынаинтя луй Иосиф. ");
INSERT INTO ron1924_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Кум а вэзут Иосиф пе Бениамин ку ей, а зис економулуй сэу: „Багэ пе оамений ачештя ын касэ, тае вите ши гэтеште, кэч оамений ачештя ау сэ мэнынче ку мине ла амязэ.” ");
INSERT INTO ron1924_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Омул ачела а фэкут че-й порунчисе Иосиф ши а дус пе оамений ачея ын каса луй Иосиф. ");
INSERT INTO ron1924_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ей с-ау темут кынд ау вэзут кэ-й багэ ын каса луй Иосиф ши ау зис: „Не багэ ынэунтру дин причина арӂинтулуй пус ын сачий ноштри дата трекутэ; вор сэ се нэпустяскэ песте ной ка сэ не я робь ши сэ пунэ мына пе мэгарий ноштри.” ");
INSERT INTO ron1924_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","С-ау апропият де економул касей луй Иосиф ши ау интрат ын ворбэ ку ел ла уша касей ");
INSERT INTO ron1924_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","ши ау зис: „Домнуле, ной не-ам май коборыт о датэ аич, ка сэ кумпэрэм меринде. ");
INSERT INTO ron1924_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Апой, кынд ам ажунс ла локул унде требуя сэ рэмынем песте ноапте, не-ам дескис сачий ши ятэ кэ арӂинтул фиекэруя ера ла гура сакулуй сэу – арӂинтул ностру, дупэ греутатя луй – ши л-ам адус ынапой ку ной. ");
INSERT INTO ron1924_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Ам адус ши алт арӂинт, ка сэ кумпэрэм меринде. Ну штим чине а пус арӂинтул ын сачий ноштри.” ");
INSERT INTO ron1924_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Економул а рэспунс: „Фиць пе паче! Ну вэ темець де нимик. Думнезеул востру, Думнезеул татэлуй востру, в-а пус пе аскунс о комоарэ ын сачь. Арӂинтул востру а трекут прин мыниле меле.” Ши ле-а адус ши пе Симеон. ");
INSERT INTO ron1924_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Омул ачеста й-а бэгат ын каса луй Иосиф; ле-а дат апэ де шь-ау спэлат пичоареле; а дат ши нутрец мэгарилор лор. ");
INSERT INTO ron1924_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Ей шь-ау прегэтит дарул пынэ ла вениря луй Иосиф, ла амязэ, кэч афласерэ кэ ау сэ мэнынче ла ел. ");
INSERT INTO ron1924_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Кынд а ажунс Иосиф акасэ, й-ау дат дарул пе каре и-л адусесерэ ши с-ау арункат ку фаца ла пэмынт ынаинтя луй. ");
INSERT INTO ron1924_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ел й-а ынтребат де сэнэтате ши а зис: „Бэтрынул востру татэ, де каре аць ворбит, есте сэнэтос? Май трэеште?” ");
INSERT INTO ron1924_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ей ау рэспунс: „Робул тэу, татэл ностру, есте сэнэтос; трэеште ынкэ.” Ши с-ау плекат ши с-ау арункат ку фаца ла пэмынт. ");
INSERT INTO ron1924_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Иосиф а ридикат окий ши, арункынд о привире спре фрате-сэу Бениамин, фиул мамей сале, а зис: „Ачеста есте фрателе востру чел тынэр деспре каре мь-аць ворбит?” Ши а адэугат: „Думнезеу сэ айбэ милэ де тине, фиуле!” ");
INSERT INTO ron1924_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Иосиф а испрэвит репеде, кэч и се рупя инима пентру фрателе сэу ши симця невоя сэ плынгэ; а интрат деграбэ ынтр-о одае ши а плынс аколо. ");
INSERT INTO ron1924_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Дупэ че с-а спэлат пе фацэ, а ешит дин одае ши, силинду-се сэ се стэпыняскэ, а зис: „Адучець де мынкаре!” ");
INSERT INTO ron1924_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Ау адус де мынкаре луй Иосиф деопарте ши фрацилор луй деопарте; еӂиптенилор каре мынкау ку ел ле-ау адус, де асеменя, мынкаре деопарте, кэч еӂиптений ну путяу сэ мэнынче ку евреий, фииндкэ лукрул ачеста пентру ей есте о урычуне. ");
INSERT INTO ron1924_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Фраций луй Иосиф с-ау ашезат ла масэ ын фаца луй: де ла ынтыюл нэскут, дупэ дрептул луй де ынтый нэскут, ши пынэ ла чел май тынэр, ашезаць дупэ вырстэ; ши се уйтау уний ла алций ку мираре. ");
INSERT INTO ron1924_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Иосиф а пус сэ ле дя дин букателе каре ерау ынаинтя луй, яр Бениамин а кэпэтат де чинч орь май мулт декыт чейлалць. Ши ау бэут ши с-ау веселит ымпреунэ ку ел. ");
INSERT INTO ron1924_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Иосиф а дат урмэтоаря порункэ економулуй касей луй: „Умпле ку меринде сачий оаменилор ачестора кыт вор путя сэ дукэ ши пуне арӂинтул фиекэруя ла гура сакулуй сэу. ");
INSERT INTO ron1924_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Сэ пуй ши пахарул меу, пахарул де арӂинт, ла гура сакулуй челуй май тынэр, ымпреунэ ку арӂинтул кувенит пентру прецул грыулуй луй.” Економул а фэкут кум ый порунчисе Иосиф. ");
INSERT INTO ron1924_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Диминяца, кум с-а крэпат де зиуэ, ау дат друмул оаменилор ачестора ымпреунэ ку мэгарий лор. ");
INSERT INTO ron1924_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Дар абя ешисерэ дин четате ши ну се депэртасерэ делок де еа, кынд Иосиф а зис економулуй сэу: „Скоалэ-те, аляргэ дупэ оамений ачея ши, кынд ый вей ажунӂе, сэ ле спуй: ‘Пентру че аць рэсплэтит бинеле ку рэу? ");
INSERT INTO ron1924_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Де че аць фурат пахарул дин каре бя домнул меу ши де каре се служеште пентру гичит? Рэу аць фэкут кэ в-аць пуртат астфел.’” ");
INSERT INTO ron1924_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Економул й-а ажунс ши ле-а спус ачесте кувинте. ");
INSERT INTO ron1924_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ей й-ау рэспунс: „Домнуле, пентру че ворбешть астфел? Сэ феряскэ Думнезеу пе робий тэй сэ фи сэвыршит о асеменя фаптэ! ");
INSERT INTO ron1924_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ятэ, ной ць-ам адус дин цара Канаанулуй арӂинтул пе каре л-ам гэсит ла гура сачилор ноштри. Кум ам фи путут сэ фурэм арӂинт сау аур дин каса домнулуй тэу? ");
INSERT INTO ron1924_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Сэ моарэ ачела динтре робий тэй ла каре се ва гэси пахарул ши ной ыншине сэ фим робь ай домнулуй ностру!” ");
INSERT INTO ron1924_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ел а зис: „Фие дупэ кувинтеле воастре! Ачела ла каре се ва гэси пахарул сэ фие робул меу, яр вой вець фи невиноваць.” ");
INSERT INTO ron1924_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ындатэ, шь-а коборыт фиекаре сакул ла пэмынт. Фиекаре шь-а дескис сакул. ");
INSERT INTO ron1924_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Економул й-а скоточит, ынчепынд ку чел май ын вырстэ ши сфыршинд ку чел май тынэр, ши пахарул а фост гэсит ын сакул луй Бениамин. ");
INSERT INTO ron1924_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ей шь-ау рупт хайнеле, шь-а ынкэркат фиекаре мэгарул ши с-ау ынторс ын четате. ");
INSERT INTO ron1924_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Иуда ши фраций луй ау ажунс ла каса луй Иосиф пе кынд ера ел ынкэ аколо ши с-ау арункат ку фаца ла пэмынт ынаинтя луй. ");
INSERT INTO ron1924_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Иосиф ле-а зис: „Че фаптэ аць фэкут? Ну штиць кэ ун ом ка мине аре путере сэ гичаскэ?” ");
INSERT INTO ron1924_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Иуда а рэспунс: „Че сэ май спунем домнулуй ностру? Кум сэ май ворбим? Кум сэ не май ындрептэцим? Думнезеу а дат пе фацэ нелеӂюиря робилор тэй. Ятэ-не робь ай домнулуй ностру: ной ши ачела ла каре с-а гэсит пахарул.” ");
INSERT INTO ron1924_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Дар Иосиф а зис: „Сэ мэ феряскэ Думнезеу сэ фак аша чева! Омул ла каре с-а гэсит пахарул ва фи робул меу, дар вой суици-вэ ынапой ын паче ла татэл востру.” ");
INSERT INTO ron1924_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Атунч, Иуда с-а апропият де Иосиф ши а зис: „Те рог, домнул меу, дэ вое робулуй тэу сэ спунэ о ворбэ домнулуй меу ши сэ ну те мыний пе робул тэу! Кэч ту ешть ка Фараон. ");
INSERT INTO ron1924_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Домнул меу а ынтребат пе робий сэй, зикынд: ‘Май трэеште татэл востру ши май авець вреун фрате?’ ");
INSERT INTO ron1924_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ной ам рэспунс домнулуй меу: ‘Авем ун татэ бэтрын ши ун фрате тынэр, копил фэкут ла бэтрынеця луй; бэятул ачеста авя ун фрате каре а мурит ши каре ера де ла ачеяшь мамэ; ел а рэмас сингур ши татэл луй ыл юбеште.’ ");
INSERT INTO ron1924_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Ту ай спус робилор тэй: ‘Адучеци-л ла мине ка сэ-л вэд ку окий мей.’ ");
INSERT INTO ron1924_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ной ам рэспунс домнулуй меу: ‘Бэятул ну поате пэрэси пе татэл сэу; дакэ-л ва пэрэси, татэл сэу аре сэ моарэ.’ ");
INSERT INTO ron1924_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ту ай спус робилор тэй: ‘Дакэ ну се ва коборы ши фрателе востру ымпреунэ ку вой, сэ ну-мь май ведець фаца.’ ");
INSERT INTO ron1924_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Кынд не-ам суит ла татэл меу, робул тэу, й-ам спус кувинтеле домнулуй меу. ");
INSERT INTO ron1924_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Татэл ностру а зис: ‘Дучеци-вэ ярэшь сэ не кумпэраць чева меринде.’ ");
INSERT INTO ron1924_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Ной ам рэспунс: ‘Ну путем сэ не дучем, дар, дакэ фрателе ностру чел тынэр ва фи ку ной, не вом дуче, кэч ну путем ведя фаца омулуй ачелуя декыт дакэ фрателе ностру чел тынэр ва фи ку ной.’ ");
INSERT INTO ron1924_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Робул тэу, татэл ностру, не-а зис: ‘Вой штиць кэ невастэ-мя мь-а нэскут дой фий. ");
INSERT INTO ron1924_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Унул а ешит де ла мине ши кред кэ а фост сфышият, негрешит, де фяре, кэч ну л-ам май вэзут пынэ астэзь. ");
INSERT INTO ron1924_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Дакэ-мь май луаць ши пе ачеста ши и се ва ынтымпла врео ненорочире, ку дурере ымь вець коборы бэтрынециле ын Локуинца морцилор.’ ");
INSERT INTO ron1924_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Акум, дакэ мэ вой ынтоарче ла робул тэу, татэл меу, фэрэ сэ авем ку ной бэятул де суфлетул кэруя есте недезлипит суфлетул луй, ");
INSERT INTO ron1924_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","ел аре сэ моарэ кынд ва ведя кэ бэятул ну есте, ши робий тэй вор коборы ку дурере ын Локуинца морцилор бэтрынециле робулуй тэу, татэл ностру. ");
INSERT INTO ron1924_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Кэч робул тэу с-а пус кезаш пентру копил ши а зис татэлуй меу: ‘Дакэ ну-л вой адуче ынапой ла тине, виноват сэ фиу пентру тотдяуна фацэ де татэл меу.’ ");
INSERT INTO ron1924_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Ынгэдуе дар, те рог, робулуй тэу сэ рэмынэ ын локул бэятулуй, ка роб ал домнулуй меу, яр бэятул сэ се суе ынапой ку фраций сэй. ");
INSERT INTO ron1924_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Кум мэ вой путя суи еу ла татэл меу дакэ бэятул ну есте ку мине? Ах! сэ ну вэд мыхниря татэлуй меу!” ");
INSERT INTO ron1924_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Иосиф ну с-а май путут стэпыни ынаинтя тутурор челор че-л ынконжурау. Ши а стригат: „Скоатець афарэ пе тоатэ лумя.” Ши н-а май рэмас нимень ку Иосиф кынд с-а фэкут куноскут фрацилор сэй. ");
INSERT INTO ron1924_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","А избукнит ынтр-ун плынс аша де таре, кэ л-ау аузит еӂиптений ши каса луй Фараон. ");
INSERT INTO ron1924_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Иосиф а зис фрацилор сэй: „Еу сунт Иосиф! Май трэеште татэл меу?” Дар фраций луй ну й-ау путут рэспунде, аша де ынкремениць рэмэсесерэ ынаинтя луй. ");
INSERT INTO ron1924_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Иосиф а зис фрацилор сэй: „Апропияци-вэ де мине.” Ши ей с-ау апропият. Ел а зис: „Еу сунт фрателе востру Иосиф, пе каре л-аць вындут ка сэ фие дус ын Еӂипт. ");
INSERT INTO ron1924_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Акум, ну вэ ынтристаць ши ну фиць мыхниць кэ м-аць вындут ка сэ фиу адус аич, кэч ка сэ вэ скап вяца м-а тримис Думнезеу ынаинтя воастрэ. ");
INSERT INTO ron1924_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Ятэ, сунт дой ань де кынд бынтуе фоаметя ын царэ ши ынкэ чинч ань ну ва фи нич арэтурэ, нич сечериш. ");
INSERT INTO ron1924_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Думнезеу м-а тримис ынаинтя воастрэ ка сэ вэ рэмынэ сэмынца вие ын царэ ши ка сэ вэ пэстрезе вяца принтр-о маре избэвире. ");
INSERT INTO ron1924_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Аша кэ ну вой м-аць тримис аич, чи Думнезеу; Ел м-а фэкут ка ун татэ ал луй Фараон, стэпын песте тоатэ каса луй ши кырмуиторул ынтреӂий цэрь а Еӂиптулуй. ");
INSERT INTO ron1924_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Грэбици-вэ де вэ суиць ла татэл меу ши спунеци-й: ‘Аша а ворбит фиул тэу Иосиф: «Думнезеу м-а пус домн песте тот Еӂиптул; кобоарэ-те ла мине ши ну зэбови! ");
INSERT INTO ron1924_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Вей локуи ын цинутул Госен ши вей фи лынгэ мине, ту, фиий тэй ши фиий фиилор тэй, оиле тале ши боий тэй ши тот че есте ал тэу. ");
INSERT INTO ron1924_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Аколо те вой хрэни, кэч вор май фи ынкэ чинч ань де фоамете, ши астфел ну вей пери ту, каса та ши тот че есте ал тэу.»’ ");
INSERT INTO ron1924_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Вой ведець ку окий воштри ши фрателе меу Бениамин веде ку окий луй кэ еу ынсумь вэ ворбеск. ");
INSERT INTO ron1924_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Историсиць татэлуй меу тоатэ слава пе каре о ам ын Еӂипт ши тот че аць вэзут ши адучець аич кыт май курынд пе татэл меу.” ");
INSERT INTO ron1924_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Ел с-а арункат де гытул фрателуй сэу Бениамин ши а плынс, ши Бениамин а плынс ши ел де гытул луй. ");
INSERT INTO ron1924_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","А ымбрэцишат, де асеменя, пе тоць фраций луй, плынгынд. Дупэ ачея, фраций луй ау стат де ворбэ ку ел. ");
INSERT INTO ron1924_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","С-а рэспындит вестя ын каса луй Фараон кэ ау венит фраций луй Иосиф; лукрул ачеста а плэкут луй Фараон ши служиторилор луй. ");
INSERT INTO ron1924_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Фараон а зис луй Иосиф: „Спуне фрацилор тэй: ‘Ятэ че сэ фачець: Ынкэркаци-вэ добитоачеле ши плекаць ын цара Канаанулуй, ");
INSERT INTO ron1924_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","луаць пе татэл востру ши фамилииле воастре ши вениць ла мине. Еу вэ вой да че есте май бун ын цара Еӂиптулуй ши вець мынка грэсимя цэрий.’ ");
INSERT INTO ron1924_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ай порункэ сэ ле спуй: ‘Аша сэ фачець! Луаци-вэ дин цара Еӂиптулуй каре пентру прунчий воштри ши пентру невестеле воастре; адучець пе татэл востру ши вениць. ");
INSERT INTO ron1924_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Сэ ну вэ парэ рэу де чея че вець лэса, кэч тот че есте май бун ын цара Еӂиптулуй ва фи пентру вой.’” ");
INSERT INTO ron1924_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Фиий луй Исраел ау фэкут аша. Иосиф ле-а дат каре, дупэ порунка луй Фараон; ле-а дат ши меринде пентру друм. ");
INSERT INTO ron1924_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ле-а дат ла тоць хайне де скимб, яр луй Бениамин й-а дат трей суте де сикли де арӂинт ши чинч хайне де скимб. ");
INSERT INTO ron1924_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Татэлуй сэу й-а тримис зече мэгарь ынкэркаць ку че ера май бун ын Еӂипт ши зече мэгэрице ынкэркате ку грыу, пыне ши меринде, пентру ка сэ айбэ пе друм. ");
INSERT INTO ron1924_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Апой а дат друмул фрацилор сэй, каре ау плекат, ши ле-а зис: „Сэ ну вэ чертаць пе друм.” ");
INSERT INTO ron1924_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ей ау ешит дин Еӂипт ши ау ажунс ын цара Канаанулуй, ла татэл лор Иаков. ");
INSERT INTO ron1924_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ши й-ау спус: „Иосиф тот май трэеште ши кяр ел кырмуеште тоатэ цара Еӂиптулуй.” Дар инима луй Иаков а рэмас рече, пентру кэ ну-й кредя. ");
INSERT INTO ron1924_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Кынд й-ау историсит ынсэ тот че ле спусесе Иосиф ши а вэзут кареле пе каре ле тримисесе Иосиф ка сэ-л дукэ, духул татэлуй лор Иаков с-а ынвиорат. ");
INSERT INTO ron1924_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Ши Исраел а зис: „Дестул! Фиул меу Иосиф тот май трэеште! Вряу сэ мэ дук сэ-л вэд ынаинте де моарте.” ");
INSERT INTO ron1924_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Исраел а плекат ку тот че авя. А ажунс ла Беер-Шеба ши а адус жертфе Думнезеулуй татэлуй сэу Исаак. ");
INSERT INTO ron1924_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Думнезеу а ворбит луй Исраел ынтр-о ведение ноаптя ши а зис: „Иакове! Иакове!” Исраел а рэспунс: „Ятэ-мэ!” ");
INSERT INTO ron1924_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ши Думнезеу а зис: „Еу сунт Думнезеу, Думнезеул татэлуй тэу. Ну те теме сэ те коборь ын Еӂипт, кэч аколо те вой фаче сэ ажунӂь ун ням маре. ");
INSERT INTO ron1924_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Еу Ынсумь Мэ вой коборы ку тине ын Еӂипт ши Еу Ынсумь те вой скоате ярэшь де аколо, яр Иосиф ыць ва ынкиде окий.” ");
INSERT INTO ron1924_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Иаков а пэрэсит Беер-Шеба ши фиий луй Исраел ау пус пе татэл лор Иаков, ку копилаший ши невестеле лор, ын кареле пе каре ле тримисесе Фараон ка сэ-л дукэ. ");
INSERT INTO ron1924_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Шь-ау луат ши турмеле, ши авериле пе каре ле агонисисерэ ын цара Канаанулуй. Ши Иаков с-а дус ын Еӂипт ку тоатэ фамилия луй. ");
INSERT INTO ron1924_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","А луат ку ел ын Еӂипт пе фиий луй ши пе фиий фиилор луй, пе фийчеле луй ши пе фийчеле фиилор луй ши пе тоатэ фамилия луй. ");
INSERT INTO ron1924_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Ятэ нумеле фиилор луй Исраел каре ау венит ын Еӂипт. Иаков ши фиий луй. Ынтыюл нэскут ал луй Иаков: Рубен. ");
INSERT INTO ron1924_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Фиий луй Рубен: Енох, Палу, Хецрон ши Карми. ");
INSERT INTO ron1924_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Фиий луй Симеон: Иемуел, Иамин, Охад, Иакин ши Цохар, ши Саул, фиу динтр-о фемее канаанитэ. ");
INSERT INTO ron1924_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Фиий луй Леви: Гершон, Кехат ши Мерари. ");
INSERT INTO ron1924_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Фиий луй Иуда: Ер, Онан, Шела, Перец ши Зарах, дар Ер ши Онан ау мурит ын цара Канаанулуй. Фиий луй Перец ау фост: Хецрон ши Хамул. ");
INSERT INTO ron1924_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Фиий луй Исахар: Тола, Пува, Йов ши Шимрон. ");
INSERT INTO ron1924_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Фиий луй Забулон: Серед, Елон ши Иахлеел. ");
INSERT INTO ron1924_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ачештя сунт фиий пе каре й-а нэскут луй Иаков Лея ын Падан-Арам, ымпреунэ ку фийкэ-са Дина. Фиий ши фийчеле луй алкэтуяу ын тотул трейзечь ши трей де иншь. ");
INSERT INTO ron1924_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Фиий луй Гад: Цифион, Хагги, Шуни, Ецбон, Ери, Ароди ши Ареели. ");
INSERT INTO ron1924_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Фиий луй Ашер: Имна, Ишва, Ишви ши Берия, ши Серах, сора лор. Ши фиий луй Берия: Хебер ши Малкиел. ");
INSERT INTO ron1924_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Ачештя сунт фиий Зилпей, пе каре о дэдусе Лабан фетей сале Лея; пе ачештя й-а нэскут еа луй Иаков. Ын тотул шайспрезече иншь. ");
INSERT INTO ron1924_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Фиий Рахелей, неваста луй Иаков: Иосиф ши Бениамин. ");
INSERT INTO ron1924_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Луй Иосиф и с-ау нэскут ын цара Еӂиптулуй: Манасе ши Ефраим, пе каре й-а нэскут Аснат, фата луй Поти-Фера, преотул луй Он. ");
INSERT INTO ron1924_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Фиий луй Бениамин: Бела, Бекер, Ашбел, Гера, Нааман, Ехи, Рош, Мупим, Хупим ши Ард. ");
INSERT INTO ron1924_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Ачештя сунт фиий Рахелей, пе каре й-а нэскут луй Иаков. Ын тотул пайспрезече иншь. ");
INSERT INTO ron1924_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Фиул луй Дан: Хушим. ");
INSERT INTO ron1924_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Фиий луй Нефтали: Иахцеел, Гуни, Иецер ши Шилем. ");
INSERT INTO ron1924_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Ачештя сунт фиий Билхей, пе каре о дэдусе Лабан фетей сале Рахела; ши пе ачештя й-а нэскут еа луй Иаков. Ын тотул шапте иншь. ");
INSERT INTO ron1924_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Суфлетеле каре ау венит ку Иаков ын Еӂипт ши каре ешисерэ дин ел ерау ын тотул шайзечь ши шасе, фэрэ сэ нумэрэм невестеле фиилор луй Иаков. ");
INSERT INTO ron1924_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Ши Иосиф авя дой фий, каре и се нэскусерэ ын Еӂипт. Тоате суфлетеле дин фамилия луй Иаков каре ау венит ын Еӂипт ерау ын нумэр де шаптезечь. ");
INSERT INTO ron1924_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Иаков а тримис пе Иуда ынаинте ла Иосиф, ка сэ-й дя де штире сэ-й ясэ ынаинте ын Госен. ");
INSERT INTO ron1924_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Ши ау венит ын цинутул Госен. Иосиф шь-а прегэтит карул ши с-а суит ка сэ се дукэ ын Госен, ын ынтымпинаря татэлуй сэу Исраел. Кум л-а вэзут, с-а арункат пе гытул луй ши а плынс мултэ време пе гытул луй. ");
INSERT INTO ron1924_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Исраел а зис луй Иосиф: „Акум пот сэ мор, фииндкэ ць-ам вэзут фаца ши ту тот май трэешть.” ");
INSERT INTO ron1924_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Иосиф а зис фрацилор сэй ши фамилией татэлуй сэу: „Мэ дук сэ ынштиинцез пе Фараон ши сэ-й спун: ‘Фраций мей ши фамилия татэлуй меу, каре ерау ын цара Канаан, ау венит ла мине. ");
INSERT INTO ron1924_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Оамений ачештя сунт пэсторь, кэч креск вите; ей шь-ау адус оиле ши боий ши тот че есте ал лор.’ ");
INSERT INTO ron1924_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Ши, кынд вэ ва кема Фараон ши вэ ва ынтреба: ‘Ку че вэ ынделетничиць?’, ");
INSERT INTO ron1924_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","вой сэ рэспундець: ‘Робий тэй ау крескут вите дин тинереця ноастрэ пынэ акум, атыт ной, кыт ши пэринций ноштри.’ Ын фелул ачеста, вець локуи ын цинутул Госен, кэч тоць пэсторий сунт о урычуне пентру еӂиптень.” ");
INSERT INTO ron1924_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Иосиф с-а дус сэ ынштиинцезе пе Фараон ши й-а спус: „Фраций мей ши татэл меу ау сосит дин цара Канаан, ку оиле ши боий ши ку тот авутул лор; ши сунт ын цинутул Госен.” ");
INSERT INTO ron1924_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","А луат пе чинч дин фраций луй ши й-а адус ынаинтя луй Фараон. ");
INSERT INTO ron1924_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Фараон а ынтребат пе фраций луй Иосиф: „Ку че вэ ынделетничиць?” Ей ау рэспунс луй Фараон: „Робий тэй сунт пэсторь, кум ерау ши пэринций ноштри.” ");
INSERT INTO ron1924_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ши ау май зис луй Фараон: „Ной ам венит ка сэ локуим о време аич ын царэ, пентру кэ ну май есте пэшуне пентру оиле робилор тэй ши есте о маре фоамете ын цара Канаанулуй; ынгэдуе дар робилор тэй сэ локуяскэ ын цинутул Госен.” ");
INSERT INTO ron1924_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Фараон а зис луй Иосиф: „Татэл тэу ши фраций тэй ау венит ла тине. ");
INSERT INTO ron1924_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Цара Еӂиптулуй есте дескисэ ынаинтя та; ашазэ пе татэл тэу ши пе фраций тэй ын чя май бунэ парте а цэрий. Сэ локуяскэ ын цинутул Госен ши, дакэ гэсешть принтре ей оамень дестойничь, пуне-й ын фрунтя турмелор меле.” ");
INSERT INTO ron1924_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Иосиф а адус пе татэл сэу Иаков ши л-а ынфэцишат ынаинтя луй Фараон. Ши Иаков а бинекувынтат пе Фараон. ");
INSERT INTO ron1924_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Фараон а ынтребат пе Иаков: „Каре есте нумэрул зилелор анилор веций тале?” ");
INSERT INTO ron1924_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Иаков а рэспунс луй Фараон: „Зилеле анилор кэлэторией меле сунт о сутэ трейзечь де ань. Зилеле анилор веций меле ау фост пуцине ла нумэр ши реле ши н-ау атинс зилеле анилор веций пэринцилор мей ын тимпул кэлэторией лор.” ");
INSERT INTO ron1924_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Иаков а бинекувынтат ярэшь пе Фараон ши а плекат динаинтя луй Фараон. ");
INSERT INTO ron1924_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Иосиф а ашезат пе татэл сэу ши пе фраций сэй ши ле-а дат о мошие ын цара Еӂиптулуй, ын чя май бунэ парте а цэрий, ын цинутул луй Рамсес, кум порунчисе Фараон. ");
INSERT INTO ron1924_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Иосиф а хрэнит ку пыне пе татэл сэу, пе фраций сэй ши пе тоатэ фамилия татэлуй сэу, дупэ нумэрул копиилор. ");
INSERT INTO ron1924_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Ну май ера пыне ын тоатэ цара, кэч фоаметя ера фоарте маре; цара Еӂиптулуй ши цара Канаанулуй тынжяу дин причина фоаметей. ");
INSERT INTO ron1924_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Иосиф а стрынс тот арӂинтул каре се гэся ын цара Еӂиптулуй ши ын цара Канаанулуй ын скимбул грыулуй пе каре-л кумпэрау оамений ши астфел а фэкут ка тот арӂинтул ачеста сэ интре ын каса луй Фараон. ");
INSERT INTO ron1924_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Кынд с-а сфыршит арӂинтул дин цара Еӂиптулуй ши дин цара Канаанулуй, тоць еӂиптений ау венит ла Иосиф ши ау зис: „Дэ-не пыне! Пентру че сэ мурим ын фаца та? Кэч арӂинт ну май авем.” ");
INSERT INTO ron1924_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Иосиф а зис: „Даць вителе воастре, ши вэ вой да пыне ын скимбул вителор воастре, дакэ ну май авець арӂинт.” ");
INSERT INTO ron1924_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Шь-ау адус вителе ла Иосиф, ши Иосиф ле-а дат пыне ын скимбул каилор, ын скимбул турмелор де ой ши де бой ши ын скимбул мэгарилор. Ле-а дат астфел пыне ын анул ачела ын скимбул тутурор турмелор лор. ");
INSERT INTO ron1924_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Дупэ че а трекут анул ачела, ау венит ла Иосиф ын анул урмэтор ши й-ау зис: „Ну путем сэ аскундем домнулуй ностру фаптул кэ арӂинтул с-а сфыршит ши турмеле де вите ау трекут ын стэпыниря домнулуй ностру; ну май рэмын ынаинтя домнулуй ностру декыт трупуриле ши пэмынтуриле ноастре. ");
INSERT INTO ron1924_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Пентру че сэ мурим суб окий тэй, ной ши пэмынтуриле ноастре? Кумпэрэ-не ымпреунэ ку пэмынтуриле ноастре ын скимбул пыний, ши вом фи ай домнулуй ностру, ной ши пэмынтуриле ноастре. Дэ-не сэмынцэ сэ семэнэм, ка сэ трэим ши сэ ну мурим ши сэ ну не рэмынэ пэмынтуриле пустий.” ");
INSERT INTO ron1924_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Иосиф а кумпэрат пентру Фараон тоате пэмынтуриле Еӂиптулуй; кэч еӂиптений шь-ау вындут фиекаре огорул, пентру кэ ый силя фоаметя. Ши цара а ажунс ын стэпыниря луй Фараон. ");
INSERT INTO ron1924_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Кыт деспре попор, л-а мутат ын четэць, де ла о марӂине а хотарелор Еӂиптулуй пынэ ла чялалтэ. ");
INSERT INTO ron1924_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Нумай пэмынтуриле преоцилор ну ле-а кумпэрат, пентру кэ ера о леӂе а луй Фараон, датэ ын фолосул преоцилор, каре трэяу дин венитул пе каре ли-л дэдя Фараон: де ачея ей ну шь-ау вындут пэмынтуриле. ");
INSERT INTO ron1924_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Иосиф а зис попорулуй: „В-ам кумпэрат азь ку пэмынтуриле воастре пентру Фараон; ятэ, вэ дау сэмынцэ, ка сэ путець семэна пэмынтул. ");
INSERT INTO ron1924_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Ла время роаделор, вець да а чинчя парте луй Фараон, яр челелалте патру пэрць вэ вор рэмыне воуэ, ка сэ семэнаць огоареле ши сэ вэ хрэниць ымпреунэ ку копиий воштри ши ку чей че сунт ын каселе воастре.” ");
INSERT INTO ron1924_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ей ау зис: „Ту не-ай скэпат вяца! Сэ кэпэтэм тречере ынаинтя домнулуй ностру, ши вом фи робь ай луй Фараон.” ");
INSERT INTO ron1924_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Иосиф а фэкут дин ачаста о леӂе каре а рэмас ын пичоаре пынэ ын зиуа де азь ши дупэ каре а чинчя парте дин венитул пэмынтурилор Еӂиптулуй есте а луй Фараон; нумай пэмынтуриле преоцилор ну сунт але луй Фараон. ");
INSERT INTO ron1924_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Исраел а локуит ын цара Еӂиптулуй, ын цинутул Госен. Ей с-ау ынстэрит, ау крескут ши с-ау ынмулцит фоарте мулт. ");
INSERT INTO ron1924_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Иаков а трэит шаптеспрезече ань ын цара Еӂиптулуй ши зилеле анилор веций луй Иаков ау фост де о сутэ патрузечь ши шапте де ань. ");
INSERT INTO ron1924_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Кынд с-а апропият Исраел де клипа морций, а кемат пе фиул сэу Иосиф ши й-а зис: „Дакэ ам кэпэтат тречере ынаинтя та, пуне, рогу-те, мына суб коапса мя ши поартэ-те ку бунэтате ши крединчошие фацэ де мине: сэ ну мэ ынгропь ын Еӂипт. ");
INSERT INTO ron1924_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Чи, кынд мэ вой кулка лынгэ пэринций мей, сэ мэ скоць афарэ дин Еӂипт ши сэ мэ ынгропь ын мормынтул лор.” Иосиф а рэспунс: „Вой фаче дупэ кувынтул тэу.” ");
INSERT INTO ron1924_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Иаков а зис: „Журэ-мь.” Ши Иосиф й-а журат. Апой Исраел с-а плекат ку фаца пе кэпэтыюл патулуй. ");
INSERT INTO ron1924_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Дупэ ачея, ау венит ши ау спус луй Иосиф: „Татэл тэу есте болнав.” Ши Иосиф а луат ку ел пе чей дой фий ай сэй, Манасе ши Ефраим. ");
INSERT INTO ron1924_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Ау дат де штире луй Иаков ши й-ау спус: „Ятэ кэ фиул тэу Иосиф вине ла тине.” Ши Исраел шь-а адунат путериле ши с-а ашезат пе пат. ");
INSERT INTO ron1924_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Иаков а зис луй Иосиф: „Думнезеул чел Атотпутерник ми С-а арэтат ла Луз, ын цара Канаан, ши м-а бинекувынтат. ");
INSERT INTO ron1924_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Ел мь-а зис: ‘Те вой фаче сэ крешть, те вой ынмулци ши вой фаче дин тине о чатэ де попоаре; вой да цара ачаста семинцей тале дупэ тине, ка с-о стэпыняскэ пентру тотдяуна.’ ");
INSERT INTO ron1924_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Акум, чей дой фий каре ци с-ау нэскут ын цара Еӂиптулуй, ынаинте де вениря мя ла тине, ын Еӂипт, вор фи ай мей; Ефраим ши Манасе вор фи ай мей, ка ши Рубен ши Симеон. ");
INSERT INTO ron1924_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Дар копиий пе каре й-ай нэскут дупэ ей вор фи ай тэй; ей вор пурта нумеле фрацилор лор ын партя лор де моштенире. ");
INSERT INTO ron1924_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Ла ынтоарчеря мя дин Падан, Рахела а мурит пе друм лынгэ мине, ын цара Канаан, ла о депэртаре буничикэ де Ефрата, ши ам ынгропат-о аколо, пе друмул каре дуче ла Ефрата, сау Бетлеем.” ");
INSERT INTO ron1924_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Исраел с-а уйтат ла фиий луй Иосиф ши а зис: „Чине сунт ачештя?” ");
INSERT INTO ron1924_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Иосиф а рэспунс татэлуй сэу: „Сунт фиий мей пе каре ми й-а дат Думнезеу аич.” Исраел а зис: „Апропие-й, те рог, де мине, ка сэ-й бинекувынтез.” ");
INSERT INTO ron1924_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Окий луй Исраел ерау ынгреуяць де бэтрынеце, аша кэ ну май путя сэ вадэ. Иосиф й-а апропият де ел, ши Исраел й-а сэрутат ши й-а ымбрэцишат. ");
INSERT INTO ron1924_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Исраел а зис луй Иосиф: „Ну кредям кэ ам сэ-ць май вэд фаца ши ятэ кэ Думнезеу м-а фэкут сэ-ць вэд ши сэмынца.” ");
INSERT INTO ron1924_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Иосиф й-а дат ла о парте де лынгэ ӂенункий татэлуй сэу ши с-а арункат ку фаца ла пэмынт ынаинтя луй. ");
INSERT INTO ron1924_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Апой Иосиф й-а луат пе амындой, пе Ефраим ку мына дряптэ, ла стынга луй Исраел, ши пе Манасе ку мына стынгэ, ла дряпта луй Исраел, ши й-а адус апроапе де ел. ");
INSERT INTO ron1924_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Исраел шь-а ынтинс мына дряптэ ши а пус-о пе капул луй Ефраим, каре ера чел май тынэр, яр мына стынгэ а пус-о пе капул луй Манасе; ынадинс шь-а ынкручишат мыниле астфел, кэч Манасе ера чел динтый нэскут. ");
INSERT INTO ron1924_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","А бинекувынтат пе Иосиф ши а зис: „Думнезеул ынаинтя кэруя ау умблат пэринций мей Авраам ши Исаак, Думнезеул каре м-а кэлэузит де кынд м-ам нэскут пынэ ын зиуа ачаста, ");
INSERT INTO ron1924_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Ынӂерул каре м-а избэвит де орьче рэу, сэ бинекувынтезе пе копиий ачештя! Ей сэ поарте нумеле меу ши нумеле пэринцилор мей Авраам ши Исаак ши сэ се ынмулцяскэ фоарте мулт ын мижлокул цэрий!” ");
INSERT INTO ron1924_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Луй Иосиф ну й-а венит бине кынд а вэзут кэ татэл сэу ышь пуне мына дряптэ пе капул луй Ефраим, де ачея а апукат мына татэлуй сэу ка с-о я де пе капул луй Ефраим ши с-о ындрепте пе ал луй Манасе. ");
INSERT INTO ron1924_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Ши Иосиф а зис татэлуй сэу: „Ну аша, татэ, кэч ачела есте чел ынтый нэскут; пуне-ць мына дряптэ пе капул луй.” ");
INSERT INTO ron1924_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Татэл сэу н-а врут, чи а зис: „Штиу, фиуле, штиу; ши ел ва ажунӂе ун попор, ши ел ва фи маре; дар фрателе луй чел май мик ва фи май маре декыт ел ши сэмынца луй ва ажунӂе о чатэ де нямурь.” ");
INSERT INTO ron1924_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Ел й-а бинекувынтат ын зиуа ачея ши а зис: „Нумеле тэу ыл вор ынтребуинца исраелиций кынд вор бинекувынта, зикынд: ‘Думнезеу сэ Се поарте ку тине кум С-а пуртат ку Ефраим ши ку Манасе!’” Ши а пус астфел пе Ефраим ынаинтя луй Манасе. ");
INSERT INTO ron1924_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Исраел а зис луй Иосиф: „Ятэ кэ ын курынд ам сэ мор! Дар Думнезеу ва фи ку вой ши вэ ва адуче ынапой ын цара пэринцилор воштри. ");
INSERT INTO ron1924_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ыць дау май мулт декыт фрацилор тэй – о парте пе каре ам луат-о дин мына аморицилор ку сабия мя ши ку аркул меу.” ");
INSERT INTO ron1924_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Иаков а кемат пе фиий сэй ши а зис: „Стрынӂеци-вэ ши вэ вой вести че ви се ва ынтымпла ын времуриле каре вор вени. ");
INSERT INTO ron1924_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Стрынӂеци-вэ ши аскултаць, фий ай луй Иаков! Аскултаць пе татэл востру Исраел! ");
INSERT INTO ron1924_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Рубен, ту, ынтыюл меу нэскут, Путеря мя ши пырга тэрией меле, Ынтыюл ын вредничие ши ынтыюл ын путере, ");
INSERT INTO ron1924_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Нэвалник ка апеле – ту ну вей май авя ынтыетатя! Кэч те-ай суит ын патул татэлуй тэу, Мь-ай спуркат патул суинду-те ын ел. ");
INSERT INTO ron1924_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Симеон ши Леви сунт фраць; Сэбииле лор сунт ниште унелте де силничие. ");
INSERT INTO ron1924_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ну вряу сэ интре суфлетул меу ла сфатуриле лор, Ну вряу сэ се уняскэ духул меу ку адунаря лор! Кэч, ын мыния лор, ау учис оамень Ши, ын рэутатя лор, ау тэят винеле таурилор. ");
INSERT INTO ron1924_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Блестематэ сэ фие мыния лор, пентру кэ а фост пря турбатэ, Ши фурия лор, кэч а фост пря сэлбатикэ! Ый вой ымпэрци ын Иаков Ши-й вой рисипи ын Исраел. ");
INSERT INTO ron1924_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Иудо, ту вей прими лауделе фрацилор тэй. Мына та ва апука де чафэ пе врэжмаший тэй. Фиий татэлуй тэу се вор ынкина пынэ ла пэмынт ынаинтя та. ");
INSERT INTO ron1924_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Иуда есте ун пуй де леу. Ту те-ай ынторс де ла мэчел, фиуле! Иуда ышь плякэ ӂенункий, се кулкэ ынтокмай ка ун леу, Ка о леоайкэ: чине-л ва скула? ");
INSERT INTO ron1924_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Тоягул де домние ну се ва депэрта дин Иуда, Нич тоягул де кырмуире динтре пичоареле луй, Пынэ ва вени Шило, Ши де Ел вор аскулта попоареле. ");
INSERT INTO ron1924_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ел ышь лягэ мэгарул де вицэ Ши де чел май бун бутук де вицэ мынзул мэгэрицей луй; Ышь спалэ хайна ын вин Ши мантауа ын сынӂеле стругурилор. ");
INSERT INTO ron1924_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Аре окий роший де вин Ши динций албь де лапте. ");
INSERT INTO ron1924_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Забулон ва локуи пе цэрмул мэрилор, Лынгэ лиманул корэбиилор, Ши хотарул луй се ва ынтинде ынспре Сидон. ");
INSERT INTO ron1924_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Исахар есте ун мэгар осос, Каре се кулкэ ын граждурь. ");
INSERT INTO ron1924_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Веде кэ локул унде се одихнеште есте плэкут Ши кэ цинутул луй есте мэрец; Ышь плякэ умэрул суб поварэ Ши се супуне бирулуй. ");
INSERT INTO ron1924_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Дан ва жудека пе попорул сэу, Ка уна дин семинцииле луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Дан ва фи ун шарпе пе друм, О нэпыркэ пе кэраре, Мушкынд кэлкыеле калулуй, Фэкынд сэ кадэ кэлэрецул пе спате. ");
INSERT INTO ron1924_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Ын ажуторул Тэу нэдэждуеск, Доамне! ");
INSERT INTO ron1924_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Песте Гад вор да иуреш чете ынармате, Дар ши ел ва да иуреш песте еле ши ле ва урмэри. ");
INSERT INTO ron1924_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Ашер дэ о хранэ минунатэ; Ел ва да букате алесе ымпэрацилор. ");
INSERT INTO ron1924_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Нефтали есте о чербоайкэ слободэ, Ростеште кувинте фрумоасе. ");
INSERT INTO ron1924_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Иосиф есте влэстарул унуй пом родитор, Влэстарул унуй пом родитор сэдит лынгэ ун извор; Рамуриле луй се ыналцэ дясупра зидулуй. ");
INSERT INTO ron1924_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Аркаший л-ау ацыцат, ау арункат сэӂець Ши л-ау урмэрит ку ура лор. ");
INSERT INTO ron1924_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Дар аркул луй а рэмас таре Ши мыниле луй ау фост ынтэрите Де мыниле Путерникулуй луй Иаков: Ши а ажунс астфел пэсторул, стынка луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Ачаста есте лукраря Думнезеулуй татэлуй тэу, каре те ва ажута; Ачаста есте лукраря Челуй Атотпутерник, каре те ва бинекувынта Ку бинекувынтэриле черурилор де сус, Ку бинекувынтэриле апелор де жос, Ку бинекувынтэриле цыцелор ши але пынтечелуй мамей. ");
INSERT INTO ron1924_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Бинекувынтэриле татэлуй тэу Ынтрек бинекувынтэриле пэринцилор мей ши се ыналцэ Пынэ ын крештетул дялурилор вешниче: Еле сэ винэ песте капул луй Иосиф, Песте крештетул капулуй домнулуй фрацилор сэй! ");
INSERT INTO ron1924_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Бениамин есте ун луп каре сфышие; Диминяца мэнынкэ прада, Яр сяра ымпарте прада рэпитэ.” ");
INSERT INTO ron1924_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ачештя сунт тоць чей че алкэтуеск челе доуэспрезече семинций але луй Исраел. Ши ачестя сунт лукруриле пе каре ли ле-а спус татэл лор кынд й-а бинекувынтат. Й-а бинекувынтат пе фиекаре ку о бинекувынтаре деосебитэ. ");
INSERT INTO ron1924_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Апой ле-а дат порунка урмэтоаре: „Еу ам сэ фиу адэугат ла попорул меу, деч сэ мэ ынгропаць ымпреунэ ку пэринций мей, ын пештера каре есте ын огорул хетитулуй Ефрон, ");
INSERT INTO ron1924_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","ын пештера дин огорул Макпела, каре есте фацэ ын фацэ ку Мамре, ын цара Канаан. Ачеста есте огорул пе каре л-а кумпэрат Авраам де ла хетитул Ефрон ка мошие де ынмормынтаре. ");
INSERT INTO ron1924_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Аколо ау ынгропат пе Авраам ши пе Сара, неваста луй; аколо ау ынгропат пе Исаак ши пе Ребека, неваста луй, ши аколо ам ынгропат еу пе Лея. ");
INSERT INTO ron1924_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Огорул ши пештера каре се афлэ аколо ау фост кумпэрате де ла фиий луй Хет.” ");
INSERT INTO ron1924_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Кынд а испрэвит Иаков де дат порунчь фиилор сэй, шь-а трас пичоареле ын пат, шь-а дат духул ши а фост адэугат ла попорул сэу. ");
INSERT INTO ron1924_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Иосиф с-а арункат пе фаца татэлуй сэу, л-а плынс ши л-а сэрутат. ");
INSERT INTO ron1924_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","А порунчит докторилор каре ерау ын служба луй сэ ымбэлсэмезе пе татэл сэу, ши докторий ау ымбэлсэмат пе Исраел. ");
INSERT INTO ron1924_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Патрузечь де зиле ау трекут астфел ши ау фост ынтребуинцате ку ымбэлсэмаря луй. Ши еӂиптений л-ау плынс шаптезечь де зиле. ");
INSERT INTO ron1924_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Дупэ че ау трекут зилеле де жале, Иосиф а ворбит оаменилор дин каса луй Фараон ши ле-а зис: „Дакэ ам кэпэтат тречере ынаинтя воастрэ, спунець, вэ рог, луй Фараон че вэ спун еу. ");
INSERT INTO ron1924_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Татэл меу м-а пус сэ жур, зикынд: «Ятэ, ын курынд еу ам сэ мор! Сэ мэ ынгропь ын мормынтул пе каре ми л-ам сэпат ын цара Канаан.» Аш вря дар сэ мэ суй аколо, ка сэ ынгроп пе татэл меу, ши дупэ ачея мэ вой ынтоарче.’” ");
INSERT INTO ron1924_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Фараон а рэспунс: „Суе-те ши ынгроапэ пе татэл тэу, дупэ журэмынтул пе каре те-а пус сэ-л фачь.” ");
INSERT INTO ron1924_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Иосиф с-а суит ка сэ ынгроапе пе татэл сэу. Ымпреунэ ку ел с-ау суит тоць служиторий луй Фараон, бэтрыний касей луй, тоць бэтрыний цэрий Еӂиптулуй, ");
INSERT INTO ron1924_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","тоатэ каса луй Иосиф, фраций сэй ши каса татэлуй сэу; н-ау лэсат ын цинутул Госен декыт прунчий, оиле ши боий. ");
INSERT INTO ron1924_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Ымпреунэ ку Иосиф май ерау каре ши кэлэрець, аша кэ алаюл ера фоарте маре. ");
INSERT INTO ron1924_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Кынд ау ажунс ла ария луй Атад, каре есте динколо де Йордан, ау фэкут плынӂере маре ши жалникэ, ши Иосиф а цинут ын чинстя татэлуй сэу ун бочет де шапте зиле. ");
INSERT INTO ron1924_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Локуиторий цэрий, канааниций, ау фост марторь ла бочетул ачеста дин ария луй Атад ши ау зис: „Ятэ ун маре бочет принтре еӂиптень!” Де ачея с-а дат ачестей арий нумеле Абел-Мицраим; еа есте динколо де Йордан. ");
INSERT INTO ron1924_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Астфел ау ымплинит фиий луй Иаков порунчиле татэлуй лор. ");
INSERT INTO ron1924_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Л-ау дус ын цара Канаан ши л-ау ынгропат ын пештера дин огорул Макпела, пе каре-л кумпэрасе Авраам де ла хетитул Ефрон ка мошие де ынмормынтаре ши каре есте фацэ ын фацэ ку Мамре. ");
INSERT INTO ron1924_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Иосиф, дупэ че а ынгропат пе татэл сэу, с-а ынторс ын Еӂипт ымпреунэ ку фраций сэй ши ку тоць чей че се суисерэ ку ел ка сэ ынгроапе пе татэл сэу. ");
INSERT INTO ron1924_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Кынд ау вэзут фраций луй Иосиф кэ татэл лор а мурит, ау зис: „Дакэ ва принде Иосиф урэ пе ной ши не ва ынтоарче тот рэул пе каре и л-ам фэкут?” ");
INSERT INTO ron1924_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ши ау тримис сэ спунэ луй Иосиф: „Татэл тэу а дат порунка ачаста ынаинте де моарте: ");
INSERT INTO ron1924_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Аша сэ ворбиць луй Иосиф: «О, яртэ нелеӂюиря фрацилор тэй ши пэкатул лор, кэч ць-ау фэкут рэу!»’ Яртэ акум пэкатул робилор Думнезеулуй татэлуй тэу!” Иосиф а плынс кынд а аузит кувинтеле ачестя. ");
INSERT INTO ron1924_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Фраций луй ау венит ши с-ау арункат ей ыншишь ку фаца ла пэмынт ынаинтя луй ши й-ау зис: „Сунтем робий тэй.” ");
INSERT INTO ron1924_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Иосиф ле-а зис: „Фиць фэрэ тямэ, кэч сунт еу оаре ын локул луй Думнезеу? ");
INSERT INTO ron1924_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Вой, негрешит, в-аць гындит сэ-мь фачець рэу, дар Думнезеу а скимбат рэул ын бине, ка сэ ымплиняскэ чея че се веде азь, ши ануме сэ скапе вяца унуй попор ын маре нумэр. ");
INSERT INTO ron1924_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Фиць дар фэрэ тямэ, кэч еу вэ вой хрэни пе вой ши пе копиий воштри.” Ши й-а мынгыят ши ле-а ымбэрбэтат инимиле. ");
INSERT INTO ron1924_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Иосиф а локуит ын Еӂипт, ел ши каса татэлуй сэу, ши а трэит о сутэ зече ань. ");
INSERT INTO ron1924_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Иосиф а вэзут пе фиий луй Ефраим пынэ ла ал трейля ням; ши фиий луй Макир, фиул луй Манасе, с-ау нэскут пе ӂенункий луй. ");
INSERT INTO ron1924_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Иосиф а зис фрацилор сэй: „Еу ам сэ мор! Дар Думнезеу вэ ва черчета ши вэ ва фаче сэ вэ суиць дин цара ачаста ын цара пе каре а журат кэ о ва да луй Авраам, луй Исаак ши луй Иаков.” ");
INSERT INTO ron1924_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Иосиф а пус пе фиий луй Исраел сэ журе, зикынд: „Кынд вэ ва черчета Думнезеу, сэ луаць ши оаселе меле де аич.” ");
INSERT INTO ron1924_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Иосиф а мурит ын вырстэ де о сутэ зече ань. Л-ау ымбэлсэмат ши л-ау пус ынтр-ун сикриу ын Еӂипт. ");
INSERT INTO ron1924_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Ятэ нумеле фиилор луй Исраел интраць ын Еӂипт; ау интрат ку Иаков фиекаре ку фамилия луй: ");
INSERT INTO ron1924_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Рубен, Симеон, Леви, Иуда, ");
INSERT INTO ron1924_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Исахар, Забулон, Бениамин, ");
INSERT INTO ron1924_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Дан, Нефтали, Гад ши Ашер. ");
INSERT INTO ron1924_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Суфлетеле ешите дин коапселе луй Иаков ерау шаптезечь де тоате. Иосиф ера атунч ын Еӂипт. ");
INSERT INTO ron1924_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Иосиф а мурит ши тоць фраций луй ши тоатэ вырста ачея де оамень. ");
INSERT INTO ron1924_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Фиий луй Исраел с-ау ынмулцит, с-ау мэрит, ау крескут ши ау ажунс фоарте путерничь. Ши с-а умплут цара де ей. ");
INSERT INTO ron1924_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Песте Еӂипт с-а ридикат ун ноу ымпэрат, каре ну куноскусе пе Иосиф. ");
INSERT INTO ron1924_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Ел а зис попорулуй сэу: „Ятэ кэ попорул копиилор луй Исраел есте май маре ши май путерник декыт ной. ");
INSERT INTO ron1924_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Вениць сэ не арэтэм дибачь фацэ де ел, ка сэ ну кряскэ, пентру ка ну кумва, дакэ се ва ынтымпла ун рэзбой, сэ се уняскэ ши ел ку врэжмаший ноштри, сэ не батэ ши сэ ясэ апой дин царэ.” ");
INSERT INTO ron1924_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Ши ау пус песте ей испрэвничей, ка сэ-й асупряскэ прин мунчь греле. Астфел а зидит ел четэциле Питом ши Рамсес, ка сэ служяскэ де хамбаре луй Фараон. ");
INSERT INTO ron1924_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Дар, ку кыт ыл асупряу май мулт, ку атыт се ынмулця ши крештя, ши с-ау скырбит де копиий луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Атунч, еӂиптений ау адус пе копиий луй Исраел ла о аспрэ робие. ");
INSERT INTO ron1924_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Ле-ау фэкут вяца амарэ прин лукрэрь греле де лут ши кэрэмизь ши прин тот фелул де лукрэрь де пе кымп; ын тоате мунчиле ачестя пе каре-й силяу сэ ле факэ ерау фэрэ ничун пик де милэ. ");
INSERT INTO ron1924_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Ымпэратул Еӂиптулуй а порунчит моашелор евреилор, нумите уна Шифра ши чялалтэ Пуа, ");
INSERT INTO ron1924_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","ши ле-а зис: „Кынд вець ымплини служба де моаше пе лынгэ фемеиле евреилор ши ле вець ведя пе скаунул де наштере, дакэ есте бэят, сэ-л оморыць, яр дакэ есте фатэ, с-о лэсаць сэ трэяскэ.” ");
INSERT INTO ron1924_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Дар моашеле с-ау темут де Думнезеу ши н-ау фэкут че ле порунчисе ымпэратул Еӂиптулуй, чи ау лэсат пе копиий де парте бэрбэтяскэ сэ трэяскэ. ");
INSERT INTO ron1924_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Ымпэратул Еӂиптулуй а кемат пе моаше ши ле-а зис: „Пентру че аць фэкут лукрул ачеста ши аць лэсат пе копиий де парте бэрбэтяскэ сэ трэяскэ?” ");
INSERT INTO ron1924_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Моашеле ау рэспунс луй Фараон: „Пентру кэ фемеиле евреилор ну сунт ка еӂиптенчеле; еле сунт вынжоасе ши наск ынаинте де вениря моашей.” ");
INSERT INTO ron1924_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Думнезеу а фэкут бине моашелор ши попорул с-а ынмулцит ши а ажунс фоарте маре ла нумэр. ");
INSERT INTO ron1924_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Пентру кэ моашеле се темусерэ де Думнезеу, Думнезеу ле-а фэкут касе. ");
INSERT INTO ron1924_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Атунч, Фараон а дат урмэтоаря порункэ ла тот попорул луй: „Сэ арункаць ын рыу пе орьче бэят каре се ва наште ши сэ лэсаць пе тоате фетеле сэ трэяскэ.” ");
INSERT INTO ron1924_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Ун ом дин каса луй Леви луасе де невастэ пе о фатэ а луй Леви. ");
INSERT INTO ron1924_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Фемея ачаста а рэмас ынсэрчинатэ ши а нэскут ун фиу. А вэзут кэ есте фрумос ши л-а аскунс трей лунь. ");
INSERT INTO ron1924_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Немайпутынд сэ-л аскундэ, а луат ун сикриаш де папурэ, пе каре л-а унс ку лут ши ку смоалэ, а пус копилул ын ел ши л-а ашезат ынтре трестий, пе малул рыулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Сора копилулуй пындя ла о депэртаре оарекаре, ка сэ вадэ че аре сэ и се ынтымпле. ");
INSERT INTO ron1924_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Фата луй Фараон с-а коборыт ла рыу сэ се скалде, ши фетеле каре о ынсоцяу се плимбау пе марӂиня рыулуй. Еа а зэрит сикриашул ын мижлокул трестиилор ши а тримис пе роаба ей сэ-л я. ");
INSERT INTO ron1924_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Л-а дескис ши а вэзут копилул: ера ун бэецаш каре плынӂя. Й-а фост милэ де ел ши а зис: „Есте ун копил де-ал евреилор!” ");
INSERT INTO ron1924_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Атунч, сора копилулуй а зис фетей луй Фараон: „Сэ мэ дук сэ-ць кем о дойкэ динтре фемеиле евреилор ка сэ-ць алэптезе копилул?” ");
INSERT INTO ron1924_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","„Ду-те”, й-а рэспунс фата луй Фараон. Ши фата с-а дус ши а кемат пе мама копилулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Фата луй Фараон й-а зис: „Я копилул ачеста, алэптязэ-ми-л ши ыць вой плэти.” Фемея а луат копилул ши л-а алэптат. ");
INSERT INTO ron1924_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Копилул а крескут ши еа л-а адус фетей луй Фараон, ши ел й-а фост фиу. Й-а пус нумеле Мойсе „кэч”, а зис еа, „л-ам скос дин апе”. ");
INSERT INTO ron1924_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Ын время ачея, Мойсе, крескынд маре, а ешит пе ла фраций сэй ши а фост мартор ла мунчиле лор греле. А вэзут пе ун еӂиптян каре бэтя пе ун евреу, унул динтре фраций луй. ");
INSERT INTO ron1924_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","С-а уйтат ын тоате пэрциле ши, вэзынд кэ ну есте нимень, а оморыт пе еӂиптян ши л-а аскунс ын нисип. ");
INSERT INTO ron1924_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","А ешит ши ын зиуа урмэтоаре ши ятэ кэ дой еврей се чертау. А зис челуй че н-авя дрептате: „Пентру че ловешть пе семенул тэу?” ");
INSERT INTO ron1924_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ши омул ачела а рэспунс: „Чине те-а пус пе тине май-маре ши жудекэтор песте ной? Ну кумва ай де гынд сэ мэ оморь ши пе мине кум ай оморыт пе еӂиптянул ачела?” Мойсе с-а темут ши а зис: „Ну май ынкапе ындоялэ кэ фаптул есте куноскут.” ");
INSERT INTO ron1924_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Фараон а афлат че се петрекусе ши кэута сэ-л омоаре пе Мойсе. Дар Мойсе а фуӂит динаинтя луй Фараон ши а локуит ын цара Мадиан. А шезут лынгэ о фынтынэ. ");
INSERT INTO ron1924_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Преотул дин Мадиан авя шапте фете. Еле ау венит сэ скоатэ апэ ши ау умплут жгябуриле ка сэ адапе турма татэлуй лор. ");
INSERT INTO ron1924_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Дар ау венит пэсторий ши ле-ау луат ла гоанэ. Атунч, Мойсе с-а скулат, ле-а ажутат ши ле-а адэпат турма. ");
INSERT INTO ron1924_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Кынд с-ау ынторс еле ла татэл лор, Реуел, ел а зис: „Пентру че вэ ынтоарчець аша де курынд азь?” ");
INSERT INTO ron1924_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Еле ау рэспунс: „Ун еӂиптян не-а скэпат дин мына пэсторилор ши кяр не-а скос апэ ши а адэпат турма.” ");
INSERT INTO ron1924_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Ши ел а зис фетелор: „Унде есте? Пентру че аць лэсат аколо пе омул ачела? Кемаци-л сэ мэнынче пыне!” ");
INSERT INTO ron1924_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Мойсе с-а хотэрыт сэ локуяскэ ла омул ачела, каре й-а дат де невастэ пе фийкэ-са Сефора. ");
INSERT INTO ron1924_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Еа а нэскут ун фиу, кэруя ел й-а пус нумеле Гершом „кэч”, а зис ел, „локуеск ка стрэин ынтр-о царэ стрэинэ”. ");
INSERT INTO ron1924_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Дупэ мултэ време, ымпэратул Еӂиптулуй а мурит, ши копиий луй Исраел ӂемяу ынкэ дин причина робией ши скотяу стригэте дезнэдэждуите. Стригэтеле ачестя, пе каре ли ле смулӂя робия, с-ау суит пынэ ла Думнезеу. ");
INSERT INTO ron1924_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Думнезеу а аузит ӂеметеле лор ши Шь-а адус аминте де легэмынтул Сэу фэкут ку Авраам, Исаак ши Иаков. ");
INSERT INTO ron1924_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Думнезеу а привит спре копиий луй Исраел ши а луат куноштинцэ де ей. ");
INSERT INTO ron1924_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Мойсе пэштя турма сокрулуй сэу, Иетро, преотул Мадианулуй. Одатэ, а мынат турма пынэ динколо де пустиу ши а ажунс ла мунтеле луй Думнезеу, ла Хореб. ");
INSERT INTO ron1924_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Ынӂерул Домнулуй и С-а арэтат ынтр-о флакэрэ де фок, каре ешя дин мижлокул унуй руг. Мойсе с-а уйтат ши ятэ кэ ругул ера тот ун фок ши ругул ну се мистуя делок. ");
INSERT INTO ron1924_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Мойсе а зис: „Ам сэ мэ ынторк сэ вэд че есте ачастэ ведение минунатэ ши пентру че ну се мистуе ругул.” ");
INSERT INTO ron1924_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Домнул а вэзут кэ ел се ынтоарче сэ вадэ ши Думнезеу л-а кемат дин мижлокул ругулуй ши а зис: „Мойсе! Мойсе!” Ел а рэспунс: „Ятэ-мэ!” ");
INSERT INTO ron1924_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Думнезеу а зис: „Ну те апропия де локул ачеста; скоате-ць ынкэлцэминтя дин пичоаре, кэч локул пе каре калчь есте ун пэмынт сфынт.” ");
INSERT INTO ron1924_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Ши а адэугат: „Еу сунт Думнезеул татэлуй тэу, Думнезеул луй Авраам, Думнезеул луй Исаак ши Думнезеул луй Иаков.” Мойсе шь-а аскунс фаца, кэч се темя сэ-Л привяскэ пе Думнезеу. ");
INSERT INTO ron1924_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Домнул а зис: „Ам вэзут асуприря попорулуй Меу, каре есте ын Еӂипт, ши ам аузит стригэтеле пе каре ле скоате дин причина асуприторилор луй, кэч ый куноск дурериле. ");
INSERT INTO ron1924_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","М-ам коборыт ка сэ-л избэвеск дин мына еӂиптенилор ши сэ-л скот дин цара ачаста ши сэ-л дук ынтр-о царэ бунэ ши ынтинсэ, ынтр-о царэ унде курӂе лапте ши мьере, ши ануме ын локуриле пе каре ле локуеск канааниций, хетиций, амориций, ферезиций, хевиций ши иебусиций. ");
INSERT INTO ron1924_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Ятэ кэ стригэтеле исраелицилор ау ажунс пынэ ла Мине ши ам вэзут кинул ку каре ый кинуеск еӂиптений. ");
INSERT INTO ron1924_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Акум, вино, Еу те вой тримите ла Фараон ши вей скоате дин Еӂипт пе попорул Меу, пе копиий луй Исраел.” ");
INSERT INTO ron1924_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Мойсе а зис луй Думнезеу: „Чине сунт еу, ка сэ мэ дук ла Фараон ши сэ скот дин Еӂипт пе копиий луй Исраел?” ");
INSERT INTO ron1924_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Думнезеу а зис: „Еу вой фи негрешит ку тине, ши ятэ каре ва фи пентру тине семнул кэ Еу те-ам тримис: дупэ че вей скоате пе попор дин Еӂипт, вець служи луй Думнезеу пе мунтеле ачеста.” ");
INSERT INTO ron1924_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Мойсе а зис луй Думнезеу: „Ятэ, кынд мэ вой дуче ла копиий луй Исраел ши ле вой спуне: ‘Думнезеул пэринцилор воштри м-а тримис ла вой’ ши мэ вор ынтреба: ‘Каре есте Нумеле Луй?’, че ле вой рэспунде?” ");
INSERT INTO ron1924_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Думнезеу а зис луй Мойсе: „Еу сунт Чел че сунт.” Ши а адэугат: „Вей рэспунде копиилор луй Исраел астфел: ‘Чел че Се нумеште «Еу сунт» м-а тримис ла вой.’” ");
INSERT INTO ron1924_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Думнезеу а май зис луй Мойсе: „Аша сэ ворбешть копиилор луй Исраел: ‘Домнул Думнезеул пэринцилор воштри, Думнезеул луй Авраам, Думнезеул луй Исаак ши Думнезеул луй Иаков, м-а тримис ла вой. Ачеста есте Нумеле Меу пентру вешничие, ачеста есте Нумеле Меу дин ням ын ням.’ ");
INSERT INTO ron1924_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Ду-те, стрынӂе пе бэтрыний луй Исраел ши спуне-ле: ‘Ми с-а арэтат Домнул Думнезеул пэринцилор воштри, Думнезеул луй Авраам, луй Исаак ши луй Иаков. Ел а зис: «В-ам вэзут ши ам вэзут че ви се фаче ын Еӂипт ");
INSERT INTO ron1924_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","ши ам зис: Вэ вой скоате дин суферинца Еӂиптулуй ши вэ вой дуче ын цара канааницилор, хетицилор, аморицилор, ферезицилор, хевицилор ши иебусицилор, ынтр-о царэ унде курӂе лапте ши мьере.»’ ");
INSERT INTO ron1924_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Ей вор аскулта де гласул тэу ши те вей дуче, ту ши бэтрыний луй Исраел, ла ымпэратул Еӂиптулуй ши ый вець спуне: ‘Домнул Думнезеул евреилор С-а ынтылнит ку ной. Дэ-не вое сэ мерӂем кале де трей зиле ын пустиу, ка сэ адучем жертфе Домнулуй Думнезеулуй ностру.’ ");
INSERT INTO ron1924_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Штиу кэ ымпэратул Еӂиптулуй н-аре сэ вэ ласе сэ плекаць декыт силит де о мынэ путерникэ. ");
INSERT INTO ron1924_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Еу Ымь вой ынтинде мына ши вой лови Еӂиптул ку тот фелул де минунь, пе каре ле вой фаче ын мижлокул луй. Дупэ ачея, аре сэ вэ ласе сэ плекаць. ");
INSERT INTO ron1924_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Вой фаче кяр ка попорул ачеста сэ капете тречере ынаинтя еӂиптенилор, ши, кынд вець плека, ну вець плека ку мыниле гоале. ");
INSERT INTO ron1924_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Фиекаре фемее ва чере де ла вечина ей ши де ла чя каре локуеште ын каса ей васе де арӂинт, васе де аур ши хайне пе каре ле вець пуне пе фиий ши фийчеле воастре. Ши вець жефуи астфел пе еӂиптень.” ");
INSERT INTO ron1924_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Мойсе а рэспунс ши а зис: „Ятэ кэ н-ау сэ мэ крядэ, нич н-ау сэ аскулте де гласул меу. Чи вор зиче: ‘Ну ци С-а арэтат Домнул!’” ");
INSERT INTO ron1924_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Домнул й-а зис: „Че ай ын мынэ?” Ел а рэспунс: „Ун тояг.” ");
INSERT INTO ron1924_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Домнул а зис: „Арункэ-л ла пэмынт.” Ел л-а арункат ла пэмынт, ши тоягул с-а префэкут ынтр-ун шарпе. Мойсе фуӂя де ел. ");
INSERT INTO ron1924_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Домнул а зис луй Мойсе: „Ынтинде-ць мына ши апукэ-л де коадэ.” Ел а ынтинс мына ши л-а апукат, ши шарпеле с-а префэкут ярэшь ынтр-ун тояг ын мына луй. ");
INSERT INTO ron1924_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","„Ятэ”, а зис Домнул, „че вей фаче ка сэ крядэ кэ ци С-а арэтат Домнул Думнезеул пэринцилор лор: Думнезеул луй Авраам, Думнезеул луй Исаак ши Думнезеул луй Иаков.” ");
INSERT INTO ron1924_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Домнул й-а май зис: „Багэ-ць мына ын сын.” Ел шь-а бэгат мына ын сын; апой а скос-о ши ятэ кэ мына и се акоперисе де лепрэ ши се фэкусе албэ ка зэпада. ");
INSERT INTO ron1924_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Домнул а зис: „Багэ-ць дин ноу мына ын сын.” Ел шь-а бэгат дин ноу мына ын сын, апой а скос-о дин сын ши ятэ кэ мына се фэкусе ярэшь кум ера карня луй. ");
INSERT INTO ron1924_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","„Дакэ ну те вор креде”, а зис Домнул, „ши ну вор аскулта де гласул челуй динтый семн, вор креде гласул челуй де ал дойля семн. ");
INSERT INTO ron1924_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Дакэ ну вор креде нич ачесте доуэ семне ши ну вор аскулта де гласул тэу, сэ ей апэ дин рыу ши с-о торнь пе пэмынт, ши апа пе каре о вей луа дин рыу се ва префаче ын сынӂе пе пэмынт.” ");
INSERT INTO ron1924_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Мойсе а зис Домнулуй: „Ах! Доамне, еу ну сунт ун ом ку ворбиря ушоарэ ши кусурул ачеста ну-й нич де ерь, нич де алалтэерь, нич мэкар де кынд ворбешть Ту робулуй Тэу, кэч ворба ши лимба ымь сунт ынкуркате.” ");
INSERT INTO ron1924_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Домнул й-а зис: „Чине а фэкут гура омулуй? Ши чине фаче пе ом мут сау сурд, ку ведере сау орб? Оаре ну Еу, Домнул? ");
INSERT INTO ron1924_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Ду-те дар; Еу вой фи ку гура та ши те вой ынвэца че вей авя де спус.” ");
INSERT INTO ron1924_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Мойсе а зис: „Ах, Доамне, тримите пе чине вей вря сэ тримиць!” ");
INSERT INTO ron1924_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Атунч, Домнул С-а мыният пе Мойсе ши а зис: „Ну-й оаре аколо фрателе тэу Аарон, Левитул? Штиу кэ ел ворбеште ушор. Ятэ кэ ел ынсушь вине ынаинтя та ши, кынд те ва ведя, се ва букура ын инима луй. ");
INSERT INTO ron1924_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Ту ый вей ворби ши вей пуне кувинтеле ын гура луй, ши Еу вой фи ку гура та ши ку гура луй ши вэ вой ынвэца че вець авя де фэкут. ");
INSERT INTO ron1924_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Ел ва ворби попорулуй пентру тине, ыць ва служи дрепт гурэ, ши ту вей цине пентру ел локул луй Думнезеу. ");
INSERT INTO ron1924_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Я ын мынэ тоягул ачеста ку каре вей фаче семнеле.” ");
INSERT INTO ron1924_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Мойсе а плекат ши, кынд с-а ынторс ла сокрул сэу Иетро, й-а зис: „Ласэ-мэ, те рог, сэ плек ши сэ мэ ынторк ла фраций мей, каре сунт ын Еӂипт, ка сэ вэд дакэ май трэеск.” Иетро а зис луй Мойсе: „Ду-те ын паче!” ");
INSERT INTO ron1924_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Домнул а зис луй Мойсе ын Мадиан: „Ду-те, ынтоарче-те ын Еӂипт, кэч тоць чей че умблау сэ-ць я вяца ау мурит.” ");
INSERT INTO ron1924_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Мойсе шь-а луат неваста ши копиий, й-а пус кэларе пе мэгарь ши с-а ынторс ын цара Еӂиптулуй. Шь-а луат ын мынэ тоягул луй Думнезеу. ");
INSERT INTO ron1924_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Домнул а зис луй Мойсе: „Плекынд ка сэ те ынторчь ын Еӂипт, везь, тоате минуниле пе каре ци ле пун ын мынэ сэ ле фачь ынаинтя луй Фараон. Еу ый вой ымпетри инима, ши ну ва лэса пе попор сэ плече. ");
INSERT INTO ron1924_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Ту вей зиче луй Фараон: ‘Аша ворбеште Домнул: «Исраел есте фиул Меу, ынтыюл Меу нэскут. ");
INSERT INTO ron1924_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Ыць спун: Ласэ пе фиул Меу сэ плече, ка сэ-Мь служяскэ; дакэ ну врей сэ-л лашь сэ плече, вой учиде пе фиул тэу, пе ынтыюл тэу нэскут.»’” ");
INSERT INTO ron1924_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Ын тимпул кэлэторией, ынтр-ун лок унде а рэмас Мойсе песте ноапте, л-а ынтылнит Домнул ши а врут сэ-л омоаре. ");
INSERT INTO ron1924_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Сефора а луат о пятрэ аскуцитэ, а тэят препуцул фиулуй сэу ши л-а арункат ла пичоареле луй Мойсе, зикынд: „Ту ешть ун соц де сынӂе пентру мине.” ");
INSERT INTO ron1924_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Ши Домнул л-а лэсат. Атунч а зис еа: „Соц де сынӂе!” дин причина тэерий ымпрежур. ");
INSERT INTO ron1924_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Домнул а зис луй Аарон: „Ду-те ынаинтя луй Мойсе ын пустиу.” Аарон а плекат. А ынтылнит пе Мойсе ла мунтеле луй Думнезеу ши л-а сэрутат. ");
INSERT INTO ron1924_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Мойсе а фэкут куноскуте луй Аарон тоате кувинтеле Домнулуй, каре-л тримисесе, ши тоате семнеле пе каре-й порунчисе сэ ле факэ. ");
INSERT INTO ron1924_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Мойсе ши Аарон шь-ау вэзут де друм ши ау адунат пе тоць бэтрыний копиилор луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Аарон а историсит тоате кувинтеле пе каре ле спусесе Домнул луй Мойсе ши Мойсе а фэкут семнеле ынаинтя попорулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Попорул а крезут. Астфел ау афлат кэ Домнул черчетасе пе копиий луй Исраел, кэ ле вэзусе суферинца ши с-ау плекат ши с-ау арункат ку фаца ла пэмынт. ");
INSERT INTO ron1924_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Мойсе ши Аарон с-ау дус апой ла Фараон ши й-ау зис: „Аша ворбеште Домнул Думнезеул луй Исраел: ‘Ласэ пе попорул Меу сэ плече, ка сэ прэзнуяскэ ын пустиу ун празник ын чинстя Мя.’” ");
INSERT INTO ron1924_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Фараон а рэспунс: „Чине есте Домнул, ка сэ аскулт де гласул Луй ши сэ лас пе Исраел сэ плече? Еу ну куноск пе Домнул ши ну вой лэса пе Исраел сэ плече.” ");
INSERT INTO ron1924_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Ей ау зис: „Ни С-а арэтат Думнезеул евреилор. Дэ-не вое сэ фачем ун друм де трей зиле ын пустиу, ка сэ адучем жертфе Домнулуй, пентру ка сэ ну не батэ ку чумэ сау ку сабие.” ");
INSERT INTO ron1924_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Ши ымпэратул Еӂиптулуй ле-а зис: „Мойсе ши Аарон, пентру че абатець попорул де ла лукрул луй? Плекаць ла лукрэриле воастре.” ");
INSERT INTO ron1924_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Фараон а зис: „Ятэ кэ попорул ачеста с-а ынмулцит акум ын царэ, ши вой май воиць сэ-л фачець сэ-шь ынчетезе лукрэриле?” ");
INSERT INTO ron1924_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Ши кяр ын зиуа ачея, Фараон а дат урмэтоаря порункэ испрэвничеилор нородулуй ши логофецилор: ");
INSERT INTO ron1924_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","„Сэ ну май даць попорулуй пае ка май ынаинте пентру фачеря кэрэмизилор, чи сэ се дукэ сингурь сэ стрынгэ пае. ");
INSERT INTO ron1924_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Тотушь сэ ле черець ачелашь нумэр де кэрэмизь пе каре ле фэчяу май ынаинте; сэ ну ле скэдець нимик дин еле, кэч сунт ниште ленешь, де ачея стригэ мереу: ‘Хайдем сэ адучем жертфе Думнезеулуй ностру!’ ");
INSERT INTO ron1924_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Сэ се дя мулт де лукру оаменилор ачестора, ка сэ айбэ де лукру ши сэ ну май умбле дупэ нэлучь.” ");
INSERT INTO ron1924_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Испрэвничеий попорулуй ши логофеций ау венит ши ау спус попорулуй: „Аша ворбеште Фараон: ‘Ну вэ май дау пае; ");
INSERT INTO ron1924_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","дучеци-вэ сингурь де вэ луаць пае де унде вець гэси, дар ну ви се скаде нимик дин лукрул востру.’” ");
INSERT INTO ron1924_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Попорул с-а рэспындит ын тоатэ цара Еӂиптулуй, ка сэ стрынгэ мириште ын лок де пае. ");
INSERT INTO ron1924_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Испрэвничеий ый силяу зикынд: „Испрэвици-вэ лукрул зи де зи, ка атунч кынд ерау пае!” ");
INSERT INTO ron1924_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Ау бэтут кяр пе логофеций копиилор луй Исраел, пушь песте ей де испрэвничеий луй Фараон. „Пентру че”, ли се зичя, „н-аць испрэвит ерь ши азь, ка май ынаинте, нумэрул де кэрэмизь каре вэ фусесе хотэрыт?” ");
INSERT INTO ron1924_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Логофеций копиилор луй Исраел с-ау дус сэ се плынгэ ла Фараон ши й-ау зис: „Пентру че те порць аша ку робий тэй? ");
INSERT INTO ron1924_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Робилор тэй ну ли се май дау пае ка май ынаинте, ши тотушь ни се спуне: ‘Фачець кэрэмизь!’ Ба ынкэ, робий тэй сунт ши бэтуць, ка ши кынд попорул тэу ар фи виноват.” ");
INSERT INTO ron1924_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Фараон а рэспунс: „Сунтець ниште ленешь ши ниште трынторь! Де ачея зичець: ‘Хайдем сэ адучем жертфе Домнулуй!’ ");
INSERT INTO ron1924_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Акум, дучеци-вэ ындатэ де лукраць; ну ви се вор да пае ши вець фаче ачелашь нумэр де кэрэмизь.” ");
INSERT INTO ron1924_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Логофеций копиилор луй Исраел ау вэзут ын че старе ненорочитэ ерау кынд ли се зичя: „Ну ви се скаде нимик дин нумэрул де кэрэмизь, чи ын фиекаре зи сэ фачець лукрул кувенит уней зиле.” ");
INSERT INTO ron1924_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Кынд ау ешит де ла Фараон, ау ынтылнит пе Мойсе ши пе Аарон, каре ый аштептау. ");
INSERT INTO ron1924_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Ши ле-ау зис: „Сэ вэ вадэ Домнул ши сэ жудече! Вой не-аць фэкут урыць луй Фараон ши служиторилор луй; ба ынкэ ле-аць дат сабия ын мынэ ка сэ не омоаре.” ");
INSERT INTO ron1924_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Мойсе с-а ынторс ла Домнул ши а зис: „Доамне, пентру че ай фэкут ун астфел де рэу попорулуй ачестуя? Пентру че м-ай тримис? ");
INSERT INTO ron1924_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Де кынд м-ам дус ла Фараон ка сэ-й ворбеск ын Нумеле Тэу, ел фаче ши май рэу попорулуй ачестуя, ши н-ай избэвит пе попорул Тэу.” ");
INSERT INTO ron1924_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Домнул а зис луй Мойсе: „Вей ведя акум че вой фаче луй Фараон: о мынэ путерникэ ыл ва сили сэ-й ласе сэ плече; да, о мынэ путерникэ ыл ва сили сэ-й изгоняскэ дин цара луй.” ");
INSERT INTO ron1924_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Думнезеу а май ворбит луй Мойсе ши й-а зис: „Еу сунт Домнул. ");
INSERT INTO ron1924_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Еу М-ам арэтат луй Авраам, луй Исаак ши луй Иаков ка Думнезеул чел Атотпутерник, дар н-ам фост куноскут де ей суб Нумеле Меу ка ‘Домнул’. ");
INSERT INTO ron1924_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Де асеменя, Мь-ам ынкеят легэмынтул Меу ку ей ка сэ ле дау цара Канаан, цара кэлэториилор лор сфинте, ын каре ау локуит ка стрэинь. ");
INSERT INTO ron1924_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Акум ынсэ ам аузит ӂеметеле копиилор луй Исраел, пе каре-й цин еӂиптений ын робие, ши Мь-ам адус аминте де легэмынтул Меу. ");
INSERT INTO ron1924_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Де ачея, спуне копиилор луй Исраел: ‘Еу сунт Домнул. Еу вэ вой избэви дин мунчиле ку каре вэ апасэ еӂиптений, вэ вой избэви дин робия лор ши вэ вой скэпа ку брац ынтинс ши ку марь жудекэць. ");
INSERT INTO ron1924_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Вэ вой луа ка попор ал Меу; Еу вой фи Думнезеул востру ши вець куноаште кэ Еу, Домнул Думнезеул востру, вэ избэвеск де мунчиле ку каре вэ апасэ еӂиптений. ");
INSERT INTO ron1924_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Еу вэ вой дуче ын цара пе каре ам журат кэ о вой да луй Авраам, луй Исаак ши луй Иаков; Еу вэ вой да-о ын стэпынире; Еу, Домнул.’” ");
INSERT INTO ron1924_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Астфел а ворбит Мойсе копиилор луй Исраел. Дар дезнэдеждя ши робия аспрэ ын каре се афлау й-ау ымпедикат сэ-л аскулте пе Мойсе. ");
INSERT INTO ron1924_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","„Ду-те де ворбеште луй Фараон, ымпэратул Еӂиптулуй, сэ ласе пе копиий луй Исраел сэ ясэ дин цара луй.” ");
INSERT INTO ron1924_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Мойсе а рэспунс ын фаца Домнулуй: „Ятэ кэ нич копиий луй Исраел ну м-ау аскултат. Кум аре сэ м-аскулте Фараон пе мине, каре н-ам о ворбире ушоарэ?” ");
INSERT INTO ron1924_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Домнул а ворбит луй Мойсе ши луй Аарон ши ле-а дат порунчь ку привире ла копиий луй Исраел ши ку привире ла Фараон, ымпэратул Еӂиптулуй, ка сэ скоатэ дин цара Еӂиптулуй пе копиий луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Ятэ кэпетенииле фамилиилор лор. Фиий луй Рубен, ынтыюл нэскут ал луй Исраел: Енох, Палу, Хецрон ши Карми. Ачестя сунт фамилииле луй Рубен. ");
INSERT INTO ron1924_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Фиий луй Симеон: Иемуел, Иамин, Охад, Иакин ши Цохар; ши Саул, фиу нэскут динтр-о фемее канаанитэ. Ачестя сунт фамилииле луй Симеон. ");
INSERT INTO ron1924_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Ятэ нумеле фиилор луй Леви, дупэ спица нямулуй лор: Гершон, Кехат ши Мерари. Аний веций луй Леви ау фост о сутэ трейзечь ши шапте де ань. ");
INSERT INTO ron1924_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Фиий луй Гершон: Либни ши Шимей ши фамилииле лор. ");
INSERT INTO ron1924_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Фиий луй Кехат: Амрам, Ицехар, Хеброн ши Узиел. Аний веций луй Кехат ау фост о сутэ трейзечь ши трей де ань. ");
INSERT INTO ron1924_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Фиий луй Мерари: Махли ши Муши. Ачестя сунт фамилииле луй Леви, дупэ спица нямулуй лор. ");
INSERT INTO ron1924_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Амрам а луат де невастэ пе мэтушэ-са Иокебед ши еа й-а нэскут пе Аарон ши пе Мойсе. Аний веций луй Амрам ау фост о сутэ трейзечь ши шапте де ань. ");
INSERT INTO ron1924_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Фиий луй Ицехар: Коре, Нефег ши Зикри. ");
INSERT INTO ron1924_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Фиий луй Узиел: Мишаел, Елцафан ши Ситри. ");
INSERT INTO ron1924_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Аарон а луат де невастэ пе Елишеба, фата луй Аминадаб, сора луй Нахшон, ши еа й-а нэскут пе Надаб, Абиху, Елеазар ши Итамар. ");
INSERT INTO ron1924_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Фиий луй Коре: Асир, Елкана ши Абиасаф. Ачестя сунт фамилииле корицилор. ");
INSERT INTO ron1924_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Елеазар, фиул луй Аарон, а луат де невастэ пе уна дин фетеле луй Путиел, ши еа л-а нэскут пе Финеас. Ачестя сунт кэпетенииле фамилиилор левицилор ку фамилииле лор. ");
INSERT INTO ron1924_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Ачештя сунт Аарон ачела ши Мойсе ачела, кэрора ле-а зис Домнул: „Скоатець дин цара Еӂиптулуй пе копиий луй Исраел, дупэ оштириле лор.” ");
INSERT INTO ron1924_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Ей сунт ачея каре ау ворбит луй Фараон, ымпэратул Еӂиптулуй, ка сэ скоатэ дин Еӂипт пе копиий луй Исраел. Ачештя сунт Мойсе ачела ши Аарон ачела. ");
INSERT INTO ron1924_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Кынд а ворбит Домнул луй Мойсе ын цара Еӂиптулуй, ");
INSERT INTO ron1924_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Домнул а зис луй Мойсе: „Еу сунт Домнул. Спуне луй Фараон, ымпэратул Еӂиптулуй, тот че-ць спун.” ");
INSERT INTO ron1924_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Ши Мойсе а рэспунс ынаинтя Домнулуй: „Ятэ кэ еу ну ворбеск ушор. Кум аре сэ м-аскулте Фараон?” ");
INSERT INTO ron1924_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Домнул а зис луй Мойсе: „Ятэ кэ те фак Думнезеу пентру Фараон, ши фрателе тэу Аарон ва фи пророкул тэу. ");
INSERT INTO ron1924_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ту вей спуне тот че-ць вой порунчи Еу, яр фрателе тэу Аарон ва ворби луй Фараон, ка сэ ласе пе копиий луй Исраел сэ плече дин цара луй. ");
INSERT INTO ron1924_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Еу вой ымпетри инима луй Фараон ши Ымь вой ынмулци семнеле ши минуниле ын цара Еӂиптулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Тотушь Фараон н-аре сэ в-аскулте. Апой Ымь вой ынтинде мына асупра Еӂиптулуй ши вой скоате дин цара Еӂиптулуй оштиле Меле, пе попорул Меу, пе копиий луй Исраел, прин марь жудекэць. ");
INSERT INTO ron1924_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Еӂиптений вор куноаште кэ Еу сунт Домнул кынд Ымь вой ынтинде мына асупра Еӂиптулуй ши кынд вой скоате дин мижлокул лор пе копиий луй Исраел.” ");
INSERT INTO ron1924_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Мойсе ши Аарон ау фэкут че ле порунчисе Домнул: аша ау фэкут. ");
INSERT INTO ron1924_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Мойсе ера ын вырстэ де оптзечь де ань, яр Аарон, де оптзечь ши трей де ань кынд ау ворбит луй Фараон. ");
INSERT INTO ron1924_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Домнул а зис луй Мойсе ши луй Аарон: ");
INSERT INTO ron1924_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","„Дакэ вэ ва ворби Фараон ши вэ ва зиче: ‘Фачець о минуне!’ сэ зичь луй Аарон: ‘Я-ць тоягул ши арункэ-л ынаинтя луй Фараон.’ Ши тоягул се ва префаче ынтр-ун шарпе.” ");
INSERT INTO ron1924_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Мойсе ши Аарон с-ау дус ла Фараон ши ау фэкут кум порунчисе Домнул. Аарон шь-а арункат тоягул ынаинтя луй Фараон ши ынаинтя служиторилор луй, ши тоягул с-а префэкут ынтр-ун шарпе. ");
INSERT INTO ron1924_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Дар Фараон а кемат пе ниште ынцелепць ши пе ниште врэжиторь, ши врэжиторий Еӂиптулуй ау фэкут ши ей ла фел прин врэжиторииле лор. ");
INSERT INTO ron1924_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Тоць шь-ау арункат тоеӂеле ши с-ау префэкут ын шерпь. Дар тоягул луй Аарон а ынгицит тоеӂеле лор. ");
INSERT INTO ron1924_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Инима луй Фараон с-а ымпетрит ши н-а аскултат де Мойсе ши де Аарон, дупэ кум спусесе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Домнул а зис луй Мойсе: „Фараон аре инима ымпетритэ: ну вря сэ ласе попорул сэ плече. ");
INSERT INTO ron1924_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Ду-те ла Фараон дис-де-диминяцэ, кынд аре сэ ясэ сэ се дукэ ла апэ, ши сэ те ынфэцишезь ынаинтя луй пе малул рыулуй. Сэ-ць ей ын мынэ тоягул каре а фост префэкут ын шарпе ");
INSERT INTO ron1924_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","ши сэ зичь луй Фараон: ‘Домнул Думнезеул евреилор м-а тримис ла тине сэ-ць спун: «Ласэ пе попорул Меу сэ плече, ка сэ-Мь служяскэ ын пустиу.» Дар ятэ кэ пынэ акум н-ай аскултат. ");
INSERT INTO ron1924_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Акум, аша ворбеште Домнул: «Ятэ кум вей куноаште кэ Еу сунт Домнул. Ам сэ ловеск апеле рыулуй ку тоягул дин мына мя, ши еле се вор префаче ын сынӂе. ");
INSERT INTO ron1924_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Пештий дин рыу вор пери, рыул се ва ымпуци, аша кэ ле ва фи гряцэ еӂиптенилор сэ бя дин апа рыулуй.»’” ");
INSERT INTO ron1924_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Домнул а зис луй Мойсе: „Спуне луй Аарон: ‘Я-ць тоягул ши ынтинде-ць мына песте апеле еӂиптенилор, песте рыуриле лор, песте пыраеле лор, песте язуриле лор ши песте тоате бэлциле лор. Еле се вор префаче ын сынӂе ши ва фи сынӂе ын тоатэ цара Еӂиптулуй, атыт ын васеле де лемн, кыт ши ын васеле де пятрэ.’” ");
INSERT INTO ron1924_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Мойсе ши Аарон ау фэкут кум ле порунчисе Домнул. Аарон а ридикат тоягул ши а ловит апеле рыулуй суб окий луй Фараон ши суб окий служиторилор луй, ши тоате апеле рыулуй с-ау префэкут ын сынӂе. ");
INSERT INTO ron1924_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Пештий дин рыу ау перит, рыул с-а ымпуцит, аша кэ еӂиптений ну май путяу сэ бя апа рыулуй ши а фост сынӂе ын тоатэ цара Еӂиптулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Дар врэжиторий Еӂиптулуй ау фэкут ши ей ла фел прин врэжиторииле лор. Инима луй Фараон с-а ымпетрит ши н-а аскултат де Мойсе ши де Аарон, дупэ кум спусесе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Фараон с-а ынторс де ла рыу ши с-а дус акасэ, дар ну шь-а пус ла инимэ ачесте лукрурь. ");
INSERT INTO ron1924_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Тоць еӂиптений ау сэпат ын ымпрежуримиле рыулуй ка сэ гэсяскэ апэ де бэут, кэч ну путяу сэ бя дин апа рыулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Ау трекут шапте зиле дупэ че а ловит Домнул рыул. ");
INSERT INTO ron1924_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Домнул а зис луй Мойсе: „Ду-те ла Фараон ши спуне-й: ‘Аша ворбеште Домнул: «Ласэ пе попорул Меу сэ плече ка сэ-Мь служяскэ. ");
INSERT INTO ron1924_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Дакэ ну врей сэ-л лашь сэ плече, ам сэ адук броаште пе тоатэ ынтиндеря цэрий тале. ");
INSERT INTO ron1924_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Рыул ва мишуна де броаште; еле се вор суи ши вор интра ын каса та, ын одая та де дормит ши ын патул тэу, ын каса служиторилор тэй ши ын каселе попорулуй тэу, ын куптоареле ши ын постэвиле де фрэмынтат пыня. ");
INSERT INTO ron1924_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Ба ынкэ броаштеле се вор суи ши пе тине, пе попорул тэу ши пе тоць служиторий тэй.»’” ");
INSERT INTO ron1924_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Домнул а зис луй Мойсе: „Спуне луй Аарон: ‘Ынтинде-ць мына ку тоягул песте рыурь, песте пырае ши песте язурь ши скоате броаште дин еле песте цара Еӂиптулуй!’” ");
INSERT INTO ron1924_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Аарон шь-а ынтинс мына песте апеле Еӂиптулуй ши ау ешит броаштеле ши ау акоперит цара Еӂиптулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Дар ши врэжиторий ау фэкут ла фел прин врэжиторииле лор: ау скос ши ей броаште песте тоатэ цара Еӂиптулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Фараон а кемат пе Мойсе ши пе Аарон ши а зис: „Ругаци-вэ Домнулуй сэ депэртезе броаштеле де ла мине ши де ла попорул меу, ши ам сэ лас пе попор сэ плече сэ адукэ жертфе Домнулуй.” ");
INSERT INTO ron1924_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Мойсе а зис луй Фараон: „Хотэрэште-мь кынд сэ мэ рог Домнулуй пентру тине, пентру служиторий тэй ши пентру попорул тэу, ка сэ ындепэртезе броаштеле де ла тине ши дин каселе тале! Ну вор май рэмыне декыт ын рыу.” ");
INSERT INTO ron1924_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Ел а рэспунс: „Мыне.” Ши Мойсе а зис: „Аша ва фи, ка сэ штий кэ нимень ну есте ка Домнул Думнезеул ностру. ");
INSERT INTO ron1924_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Броаштеле се вор депэрта де ла тине ши дин каселе тале, де ла служиторий тэй ши де ла попорул тэу; ну вор май рэмыне декыт ын рыу.” ");
INSERT INTO ron1924_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Мойсе ши Аарон ау ешит де ла Фараон. Ши Мойсе а стригат кэтре Домнул ку привире ла броаштеле ку каре ловисе пе Фараон. ");
INSERT INTO ron1924_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Домнул а фэкут кум черя Мойсе, ши броаштеле ау перит ын касе, ын курць ши ын огоаре. ");
INSERT INTO ron1924_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Ле-ау стрынс грэмезь, ши цара с-а ымпуцит. ");
INSERT INTO ron1924_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Фараон, вэзынд кэ аре рэгаз сэ рэсуфле ын вое, шь-а ымпетрит инима ши н-а аскултат де Мойсе ши де Аарон, дупэ кум спусесе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Домнул а зис луй Мойсе: „Спуне луй Аарон: ‘Ынтинде-ць тоягул ши ловеште цэрына пэмынтулуй, ши се ва префаче ын пэдукь, ын тоатэ цара Еӂиптулуй.’” ");
INSERT INTO ron1924_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Аша ау фэкут. Аарон шь-а ынтинс мына ку тоягул ши а ловит цэрына пэмынтулуй, ши с-а префэкут ын пэдукь пе тоць оамений ши пе тоате добитоачеле. Тоатэ цэрына пэмынтулуй с-а префэкут ын пэдукь ын тоатэ цара Еӂиптулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Врэжиторий ау кэутат сэ факэ ши ей пэдукь прин врэжиторииле лор, дар н-ау путут. Пэдукий ерау пе оамень ши пе добитоаче. ");
INSERT INTO ron1924_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Ши врэжиторий ау зис луй Фараон: „Аич есте деӂетул луй Думнезеу!” Дар инима луй Фараон с-а ымпетрит ши н-а аскултат де Мойсе ши де Аарон, дупэ кум спусесе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Домнул а зис луй Мойсе: „Скоалэ-те дис-де-диминяцэ ши ду-те ынаинтя луй Фараон кынд аре сэ ясэ сэ се дукэ ла апэ. Сэ-й спуй: ‘Аша ворбеште Домнул: «Ласэ пе попорул Меу сэ плече, ка сэ-Мь служяскэ. ");
INSERT INTO ron1924_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Дакэ ну вей лэса пе попорул Меу сэ плече, ам сэ тримит муште кынешть ымпотрива та, ымпотрива служиторилор тэй, ымпотрива попорулуй тэу ши ымпотрива каселор тале; каселе еӂиптенилор вор фи плине де муште ши пэмынтул ва фи акоперит де еле. ");
INSERT INTO ron1924_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Дар ын зиуа ачея вой деосеби цинутул Госен, унде локуеште попорул Меу, ши аколо ну вор фи муште, пентру ка сэ куношть кэ Еу, Домнул, сунт ын мижлокул цинутулуй ачестуя. ");
INSERT INTO ron1924_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Вой фаче о деосебире ынтре попорул Меу ши попорул тэу. Семнул ачеста ва фи мыне.»’” ");
INSERT INTO ron1924_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Домнул а фэкут аша. А венит ун рой де муште кынешть ын каса луй Фараон ши а служиторилор луй ши тоатэ цара Еӂиптулуй а фост пустиитэ де муште кынешть. ");
INSERT INTO ron1924_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Фараон а кемат пе Мойсе ши пе Аарон ши ле-а зис: „Дучеци-вэ де адучець жертфе Думнезеулуй востру аич ын царэ.” ");
INSERT INTO ron1924_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Мойсе а рэспунс: „Ну есте делок потривит сэ фачем аша, кэч ам адуче Домнулуй Думнезеулуй ностру жертфе каре сунт о урычуне пентру еӂиптень. Ши дакэ ам адуче суб окий лор жертфе каре сунт о урычуне пентру еӂиптень, ну не вор учиде ей оаре ку петре? ");
INSERT INTO ron1924_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Вом фаче май бине ун друм де трей зиле ын пустиу ши аколо вом адуче жертфе Домнулуй Думнезеулуй ностру, дупэ кум не ва спуне.” ");
INSERT INTO ron1924_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Фараон а зис: „Вэ вой лэса сэ плекаць ка сэ адучець жертфе Домнулуй Думнезеулуй востру ын пустиу; нумай сэ ну вэ депэртаць пря мулт, дакэ плекаць. Ругаци-вэ пентру мине.” ");
INSERT INTO ron1924_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Мойсе а рэспунс: „Ам сэ ес де ла тине ши ам сэ мэ рог Домнулуй. Мыне, муштеле се вор депэрта де ла Фараон, де ла служиторий луй ши де ла попорул луй. Дар сэ ну не май ыншеле Фараон, неврынд сэ ласе пе попор сэ плече ка сэ адукэ жертфе Домнулуй.” ");
INSERT INTO ron1924_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Мойсе а ешит де ла Фараон ши с-а ругат Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Домнул а фэкут кум черя Мойсе, ши муштеле с-ау депэртат де ла Фараон, де ла служиторий луй ши де ла попорул луй; н-а май рэмас уна. ");
INSERT INTO ron1924_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Дар Фараон ши де дата ачаста шь-а ымпетрит инима ши н-а лэсат пе попор сэ плече. ");
INSERT INTO ron1924_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Домнул а зис луй Мойсе: „Ду-те ла Фараон ши спуне-й: ‘Аша ворбеште Домнул Думнезеул евреилор: «Ласэ пе попорул Меу сэ плече, ка сэ-Мь служяскэ. ");
INSERT INTO ron1924_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Дакэ ну врей сэ-л лашь сэ плече ши дакэ-л май опрешть, ");
INSERT INTO ron1924_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ятэ, мына Домнулуй ва фи песте турмеле тале де пе кымп; песте кай, песте мэгарь, песте кэмиле, песте бой ши песте ой, ши ануме ва фи о чумэ фоарте маре. ");
INSERT INTO ron1924_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Дар Домнул ва фаче деосебире ынтре турмеле луй Исраел ши турмеле еӂиптенилор, аша кэ ну ва пери нимик дин тот че есте ал копиилор луй Исраел.» ");
INSERT INTO ron1924_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Домнул а хотэрыт время ши а зис: «Мыне ва фаче Домнул лукрул ачеста ын царэ.»’” ");
INSERT INTO ron1924_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Ши Домнул а фэкут аша кяр де а доуа зи. Тоате турмеле еӂиптенилор ау перит, дар н-а перит ничо витэ дин турмеле копиилор луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Фараон а тримис сэ вадэ че се ынтымпласе, ши ятэ кэ ничо витэ дин турмеле луй Исраел ну перисе. Дар инима луй Фараон с-а ымпетрит ши н-а лэсат пе попор сэ плече. ");
INSERT INTO ron1924_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Домнул а зис луй Мойсе ши луй Аарон: „Умплеци-вэ мыниле ку ченушэ дин куптор, ши Мойсе с-о арунче спре чер, суб окий луй Фараон. ");
INSERT INTO ron1924_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Еа се ва префаче ынтр-о цэрынэ каре ва акопери тоатэ цара Еӂиптулуй ши ва да наштере ын тоатэ цара Еӂиптулуй, пе оамень ши пе добитоаче, ла ниште бубе причинуите де ниште бэшичь фербинць.” ");
INSERT INTO ron1924_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Ей ау луат ченушэ дин куптор ши с-ау ынфэцишат ынаинтя луй Фараон; Мойсе а арункат-о спре чер, ши еа а дат наштере, пе оамень ши пе добитоаче, ла ниште бубе причинуите де ниште бэшичь фербинць. ");
INSERT INTO ron1924_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Врэжиторий ну с-ау путут арэта ынаинтя луй Мойсе дин причина бубелор, кэч бубеле ерау пе врэжиторь, ка ши пе тоць еӂиптений. ");
INSERT INTO ron1924_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Домнул а ымпетрит инима луй Фараон, ши Фараон н-а аскултат де Мойсе ши де Аарон, дупэ кум спусесе Домнул луй Мойсе. ");
INSERT INTO ron1924_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Домнул а зис луй Мойсе: „Скоалэ-те дис-де-диминяцэ, ду-те ынаинтя луй Фараон ши спуне-й: ‘Аша ворбеште Домнул Думнезеул евреилор: «Ласэ пе попорул Меу сэ плече, ка сэ-Мь служяскэ. ");
INSERT INTO ron1924_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Фииндкэ де дата ачаста ам сэ тримит тоате урӂииле Меле ымпотрива инимий тале, ымпотрива служиторилор тэй ши ымпотрива попорулуй тэу, ка сэ штий кэ нимень ну есте ка Мине пе тот пэмынтул. ");
INSERT INTO ron1924_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Дакэ Мь-аш фи ынтинс мына ши те-аш фи ловит ку чумэ, пе тине ши пе попорул тэу, ай фи перит де пе пэмынт. ");
INSERT INTO ron1924_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Дар те-ам лэсат сэ рэмый ын пичоаре ка сэ везь путеря Мя ши Нумеле Меу сэ фие вестит ын тот пэмынтул. ");
INSERT INTO ron1924_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Дакэ те май ридичь ымпотрива попорулуй Меу ши дакэ ну-л лашь сэ плече, ");
INSERT INTO ron1924_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","ятэ, мыне, ла часул ачеста, вой фаче сэ батэ о пятрэ аша де маре кум н-а май фост ын Еӂипт дин зиуа ынтемеерий луй ши пынэ азь. ");
INSERT INTO ron1924_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Пуне-ць дар ла адэпост турмеле ши тот че ай пе кымп. Пятра аре сэ батэ пе тоць оамений ши тоате вителе де пе кымп, каре ну вор фи интрат ын касе, ши вор пери.»’” ");
INSERT INTO ron1924_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Ачея динтре служиторий луй Фараон каре с-ау темут де Кувынтул Домнулуй шь-ау адунат ын касе робий ши турмеле. ");
INSERT INTO ron1924_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Дар чей че ну шь-ау пус ла инимэ Кувынтул Домнулуй шь-ау лэсат робий ши турмеле пе кымп. ");
INSERT INTO ron1924_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Домнул а зис луй Мойсе: „Ынтинде-ць мына спре чер, ши аре сэ батэ пятра ын тоатэ цара Еӂиптулуй, пе оамень, пе вите ши пе тоатэ ярба де пе кымп ын цара Еӂиптулуй!” ");
INSERT INTO ron1924_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Мойсе шь-а ынтинс тоягул спре чер, ши Домнул а тримис тунете ши пятрэ, де кэдя фок пе пэмынт. Домнул а фэкут сэ батэ пятра песте цара Еӂиптулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","А бэтут пятра, ши фокул се аместека ку пятра; пятра ера аша де маре ынкыт ну май бэтусе пятрэ ка ачея ын тоатэ цара Еӂиптулуй де кынд есте ел локуит де оамень. ");
INSERT INTO ron1924_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Пятра а нимичит, ын тоатэ цара Еӂиптулуй, тот че ера пе кымп, де ла оамень пынэ ла добитоаче; пятра а нимичит ши тоатэ ярба де пе кымп ши а фрынт тоць копачий де пе кымп. ");
INSERT INTO ron1924_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Нумай ын цинутул Госен, унде ерау копиий луй Исраел, н-а бэтут пятра. ");
INSERT INTO ron1924_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Фараон а тримис сэ кеме пе Мойсе ши пе Аарон ши ле-а зис: „Де дата ачаста ам пэкэтуит; Домнул аре дрептате, яр еу ши попорул меу сунтем виноваць. ");
INSERT INTO ron1924_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Ругаци-вэ Домнулуй ка сэ ну май фие тунете ши пятрэ, ши вэ вой лэса сэ плекаць ши ну вець май фи оприць.” ");
INSERT INTO ron1924_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Мойсе й-а зис: „Кынд вой еши дин четате, вой ридика мыниле спре Домнул, тунетеле вор ынчета ши ну ва май бате пятра, ка сэ штий кэ ал Домнулуй есте пэмынтул! ");
INSERT INTO ron1924_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Дар штиу кэ ту ши служиторий тэй тот ну вэ вець теме де Домнул Думнезеу.” ");
INSERT INTO ron1924_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Инул ши орзул се прэпэдисерэ, пентру кэ орзул токмай дэдусе ын спик, яр инул ера ын флоаре; ");
INSERT INTO ron1924_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","грыул ши овэзул ну се стрикасерэ, пентру кэ ерау тырзий. ");
INSERT INTO ron1924_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Мойсе а плекат де ла Фараон ши а ешит афарэ дин четате; шь-а ридикат мыниле спре Домнул, тунетеле ши пятра ау ынчетат ши н-а май кэзут плоая пе пэмынт. ");
INSERT INTO ron1924_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Фараон, вэзынд кэ плоая, пятра ши тунетеле ынчетасерэ, н-а контенит сэ пэкэтуяскэ ши шь-а ымпетрит инима, ел ши служиторий луй. ");
INSERT INTO ron1924_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Луй Фараон и с-а ымпетрит инима ши н-а лэсат пе копиий луй Исраел сэ плече, дупэ кум спусесе Домнул прин Мойсе. ");
INSERT INTO ron1924_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Домнул а зис луй Мойсе: „Ду-те ла Фараон, кэч й-ам ымпетрит инима луй ши а служиторилор луй, ка сэ фак семнеле Меле ын мижлокул лор ");
INSERT INTO ron1924_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","ши ка сэ историсешть фиулуй тэу ши фиулуй фиулуй тэу кум М-ам пуртат ку еӂиптений ши че семне ам фэкут ын мижлокул лор. Ши вець куноаште кэ Еу сунт Домнул.” ");
INSERT INTO ron1924_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Мойсе ши Аарон с-ау дус ла Фараон ши й-ау зис: „Аша ворбеште Домнул Думнезеул евреилор: ‘Пынэ кынд ай де гынд сэ ну врей сэ те смерешть ынаинтя Мя? Ласэ пе попорул Меу сэ плече, ка сэ-Мь служяскэ. ");
INSERT INTO ron1924_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Дакэ ну врей сэ лашь пе попорул Меу сэ плече, ятэ, вой тримите мыне ниште лэкусте пе тоатэ ынтиндеря цэрий тале. ");
INSERT INTO ron1924_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Еле вор акопери фаца пэмынтулуй, де ну се ва май путя ведя пэмынтул; вор мынка че а май рэмас невэтэмат, вор мынка че в-а лэсат пятра, вор мынка тоць копачий каре креск пе кымпииле воастре, ");
INSERT INTO ron1924_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","ыць вор умпле каселе тале, каселе тутурор служиторилор тэй ши каселе тутурор еӂиптенилор. Пэринций тэй ши пэринций пэринцилор тэй н-ау вэзут аша чева де кынд сунт ей пе пэмынт пынэ ын зиуа де азь.’” Мойсе а плекат ши а ешит де ла Фараон. ");
INSERT INTO ron1924_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Служиторий луй Фараон й-ау зис: „Пынэ кынд аре сэ фие омул ачеста о пакосте пентру ной? Ласэ пе оамений ачештя сэ плече ши сэ служяскэ Домнулуй Думнезеулуй лор. Тот ну везь кэ пере Еӂиптул?” ");
INSERT INTO ron1924_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Ау ынторс ла Фараон пе Мойсе ши Аарон. „Дучеци-вэ”, ле-а зис ел, „ши служиць Домнулуй Думнезеулуй востру. Каре ши чине сунт чей че вор мерӂе?” ");
INSERT INTO ron1924_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Мойсе а рэспунс: „Вом мерӂе ку копиий ши ку бэтрыний ноштри, ку фиий ши фийчеле ноастре, ку оиле ши боий ноштри, кэч авем сэ цинем о сэрбэтоаре ын чинстя Домнулуй.” ");
INSERT INTO ron1924_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Фараон ле-а зис: „Аша сэ фие Домнул ку вой, кум вэ вой лэса еу сэ плекаць, пе вой ши пе копиий воштри! Луаць сяма, кэч есте рэу че авець де гынд сэ фачець! ");
INSERT INTO ron1924_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Ну, ну, чи дучеци-вэ вой, бэрбаций, ши служиць Домнулуй, кэч аша аць черут.” Ши й-ау изгонит динаинтя луй Фараон. ");
INSERT INTO ron1924_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Домнул а зис луй Мойсе: „Ынтинде-ць мына песте цара Еӂиптулуй, ка сэ винэ лэкустеле песте цара Еӂиптулуй ши сэ мэнынче тоатэ ярба пэмынтулуй, тот че а лэсат пятра.” ");
INSERT INTO ron1924_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Мойсе шь-а ынтинс тоягул песте цара Еӂиптулуй, ши Домнул а фэкут сэ суфле ун вынт динспре рэсэрит песте царэ тоатэ зиуа ши тоатэ ноаптя ачея. Диминяца, вынтул динспре рэсэрит адусесе лэкустеле. ");
INSERT INTO ron1924_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Лэкустеле ау венит песте цара Еӂиптулуй ши с-ау ашезат пе тоатэ ынтиндеря Еӂиптулуй; ерау ын нумэр атыт де маре кум ну май фусесе ши ну ва май фи ун астфел де рой де лэкусте. ");
INSERT INTO ron1924_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Ау акоперит тоатэ фаца пэмынтулуй, де ну се май ведя пэмынтул; ау мынкат тоатэ ярба де пе пэмынт ши тот родул помилор, тот че лэсасе пятра, ши н-а рэмас нимик верде ын копачь, нич ын ярба де пе кымп, ын тоатэ цара Еӂиптулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Фараон а кемат ындатэ пе Мойсе ши пе Аарон ши а зис: „Ам пэкэтуит ымпотрива Домнулуй Думнезеулуй востру ши ымпотрива воастрэ. ");
INSERT INTO ron1924_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Дар яртэ-мь пэкатул нумай де дата ачаста ши ругаць пе Домнул Думнезеул востру сэ депэртезе де ла мине ши урӂия ачаста де моарте!” ");
INSERT INTO ron1924_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Мойсе а ешит де ла Фараон ши с-а ругат Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Домнул а фэкут сэ суфле ун вынт фоарте путерник динспре апус, каре а луат лэкустеле ши ле-а арункат ын Маря Рошие; н-а рэмас о лэкустэ пе тоатэ ынтиндеря Еӂиптулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Домнул а ымпетрит инима луй Фараон, ши Фараон н-а лэсат пе копиий луй Исраел сэ плече. ");
INSERT INTO ron1924_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Домнул а зис луй Мойсе: „Ынтинде-ць мына спре чер, ши ва фи ынтунерик песте цара Еӂиптулуй, аша де ынтунерик де сэ се поатэ пипэй.” ");
INSERT INTO ron1924_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Мойсе шь-а ынтинс мына спре чер ши а фост ынтунерик безнэ ын тоатэ цара Еӂиптулуй тимп де трей зиле. ");
INSERT INTO ron1924_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Нич ну се ведяу уний пе алций ши нимень ну с-а скулат дин локул луй тимп де трей зиле. Дар ын локуриле унде локуяу тоць копиий луй Исраел ера луминэ. ");
INSERT INTO ron1924_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Фараон а кемат пе Мойсе ши а зис: „Дучеци-вэ ши служиць Домнулуй! Сэ ну рэмынэ ын царэ декыт оиле ши боий воштри; копиий воштри вор путя мерӂе ши ей ымпреунэ ку вой.” ");
INSERT INTO ron1924_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Мойсе а рэспунс: „Кяр сэ не дай ту ынсуць жертфеле ши ардериле-де-тот пе каре ле вом адуче Домнулуй Думнезеулуй ностру, ");
INSERT INTO ron1924_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","ши турмеле ноастре тот требуе сэ мяргэ ку ной ши сэ ну рэмынэ о унгие дин еле, кэч дин еле вом луа ка сэ служим Домнулуй Думнезеулуй ностру, яр пынэ вом ажунӂе аколо, ну штим че вом алеӂе ка сэ адучем Домнулуй.” ");
INSERT INTO ron1924_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Домнул а ымпетрит инима луй Фараон, ши Фараон н-а врут сэ-й ласе сэ плече. ");
INSERT INTO ron1924_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Фараон а зис луй Мойсе: „Ешь де ла мине! Сэ ну кумва сэ те май арэць ынаинтя мя, кэч ын зиуа ын каре те вей арэта ынаинтя мя, вей мури.” ");
INSERT INTO ron1924_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","„Да!” а рэспунс Мойсе, „ну мэ вой май арэта ынаинтя та.” ");
INSERT INTO ron1924_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Домнул а зис луй Мойсе: „Вой май адуче о урӂие асупра луй Фараон ши асупра Еӂиптулуй. Дупэ ачея, вэ ва лэса сэ плекаць де аич. Кынд вэ ва лэса сэ плекаць де тот, кяр вэ ва изгони де аич. ");
INSERT INTO ron1924_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Ворбеште ку попорул ка атунч фиекаре сэ чарэ де ла вечинул сэу ши фиекаре де ла вечина ей васе де арӂинт ши васе де аур.” ");
INSERT INTO ron1924_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Домнул а фэкут ка попорул сэ капете тречере ынаинтя еӂиптенилор. Кяр Мойсе ера фоарте бине вэзут ын цара Еӂиптулуй, ынаинтя служиторилор луй Фараон ши ынаинтя попорулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Мойсе а зис: „Аша ворбеште Домнул: ‘Пе ла мезул нопций, вой трече прин Еӂипт ");
INSERT INTO ron1924_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","ши тоць ынтыий нэскуць дин цара Еӂиптулуй вор мури, де ла ынтыюл нэскут ал луй Фараон, каре шаде пе скаунул луй де домние, пынэ ла ынтыюл нэскут ал роабей каре стэ ла рышницэ ши пынэ ла тоць ынтыий нэскуць ай добитоачелор. ");
INSERT INTO ron1924_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Ын тоатэ цара Еӂиптулуй вор фи ципете марь, аша кум н-ау фост ши ну вор май фи. ");
INSERT INTO ron1924_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Дар динтре тоць копиий луй Исраел, де ла оамень пынэ ла добитоаче, нич мэкар ун кыне ну ва келэлэи ку лимба луй, ка сэ штиць че деосебире фаче Домнул ынтре еӂиптень ши Исраел. ");
INSERT INTO ron1924_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Атунч, тоць ачешть служиторь ай тэй се вор коборы ла мине ши се вор ынкина пынэ ла пэмынт ынаинтя мя, зикынд: «Ешь, ту ши тот попорул каре те урмязэ!» Дупэ ачея, вой еши.’” Мойсе а ешит де ла Фараон апринс де мыние. ");
INSERT INTO ron1924_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Домнул а зис луй Мойсе: „Фараон н-аре с-аскулте де вой, пентру ка сэ се ынмулцяскэ минуниле Меле ын цара Еӂиптулуй.” ");
INSERT INTO ron1924_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Мойсе ши Аарон ау фэкут тоате ачесте минунь ынаинтя луй Фараон. Домнул а ымпетрит инима луй Фараон, ши Фараон н-а лэсат пе копиий луй Исраел сэ плече дин цара луй. ");
INSERT INTO ron1924_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Домнул а зис луй Мойсе ши луй Аарон ын цара Еӂиптулуй: ");
INSERT INTO ron1924_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","„Луна ачаста ва фи пентру вой чя динтый лунэ; еа ва фи пентру вой чя динтый лунэ а анулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Ворбиць ынтреӂий адунэрь а луй Исраел ши спунеци-й: ‘Ын зиуа а зечя а ачестей лунь, фиекаре ом сэ я ун мел де фиекаре фамилие, ун мел де фиекаре касэ. ");
INSERT INTO ron1924_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Дакэ сунт пря пуцинь ын касэ пентру ун мел, сэ-л я ку вечинул луй чел май де апроапе, дупэ нумэрул суфлетелор; сэ фачець сокотяла кыт поате мынка фиекаре дин мелул ачеста. ");
INSERT INTO ron1924_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Сэ фие ун мел фэрэ кусур, де парте бэрбэтяскэ, де ун ан; вець путя сэ луаць ун мел сау ун ед. ");
INSERT INTO ron1924_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Сэ-л пэстраць пынэ ын зиуа а пайспрезечя а луний ачестея, ши тоатэ адунаря луй Исраел сэ-л ынжунгие сяра. ");
INSERT INTO ron1924_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Сэ я дин сынӂеле луй ши сэ унгэ амындой стылпий уший ши прагул де сус ал каселор унде ыл вор мынка. ");
INSERT INTO ron1924_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Карня с-о мэнынче кяр ын ноаптя ачея, фриптэ ла фок, ши ануме с-о мэнынче ку азиме ши ку вердецурь амаре. ");
INSERT INTO ron1924_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Сэ ну-л мынкаць круд сау ферт ын апэ, чи сэ фие фрипт ла фок: атыт капул, кыт ши пичоареле ши мэрунтаеле. ");
INSERT INTO ron1924_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Сэ ну лэсаць нимик дин ел пынэ а доуа зи диминяца; ши дакэ ва рэмыне чева дин ел пе а доуа зи диминяца, сэ-л ардець ын фок. ");
INSERT INTO ron1924_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Кынд ыл вець мынка, сэ авець мижлокул ынчинс, ынкэлцэминтя ын пичоаре ши тоягул ын мынэ ши сэ-л мынкаць ын грабэ, кэч сунт Паштеле Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Ын ноаптя ачея, Еу вой трече прин цара Еӂиптулуй ши вой лови пе тоць ынтыий нэскуць дин цара Еӂиптулуй, де ла оамень пынэ ла добитоаче, ши вой фаче жудекатэ ымпотрива тутурор зеилор Еӂиптулуй; Еу, Домнул. ");
INSERT INTO ron1924_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Сынӂеле вэ ва служи ка семн пе каселе унде вець фи. Еу вой ведя сынӂеле ши вой трече пе лынгэ вой, аша кэ ну вэ ва нимичи ничо урӂие атунч кынд вой лови цара Еӂиптулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Ши помениря ачестей зиле с-о пэстраць ши с-о прэзнуиць принтр-о сэрбэтоаре ын чинстя Домнулуй; с-о прэзнуиць ка о леӂе вешникэ пентру урмаший воштри. ");
INSERT INTO ron1924_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Тимп де шапте зиле, вець мынка азиме. Дин чя динтый зи, вець скоате алуатул дин каселе воастре, кэч орьчине ва мынка пыне доспитэ дин зиуа ынтый пынэ ын зиуа а шаптя ва фи нимичит дин Исраел. ");
INSERT INTO ron1924_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Ын зиуа динтый, вець авя о адунаре де сэрбэтоаре сфынтэ; ши ын зиуа а шаптя, вець авя о адунаре де сэрбэтоаре сфынтэ. Сэ ну фачець ничо мункэ ын зилеле ачеля; вець путя нумай сэ прегэтиць мынкаря фиекэруй инс. ");
INSERT INTO ron1924_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Сэ цинець Сэрбэтоаря Азимилор, кэч кяр ын зиуа ачея вой скоате оштиле воастре дин цара Еӂиптулуй; сэ цинець зиуа ачея ка о леӂе вешникэ пентру урмаший воштри. ");
INSERT INTO ron1924_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Ын луна ынтый, дин а пайспрезечя зи а луний, сяра, сэ мынкаць азиме, пынэ ын сяра зилей а доуэзечь ши уна а луний. ");
INSERT INTO ron1924_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Тимп де шапте зиле, сэ ну се гэсяскэ алуат ын каселе воастре; кэч орьчине ва мынка пыне доспитэ ва фи нимичит дин адунаря луй Исраел, фие стрэин, фие бэштинаш. ");
INSERT INTO ron1924_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Сэ ну мынкаць пыне доспитэ, чи, ын тоате локуинцеле воастре, сэ мынкаць азиме.’” ");
INSERT INTO ron1924_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Мойсе а кемат пе тоць бэтрыний луй Исраел ши ле-а зис: „Дучеци-вэ де луаць ун мел пентру фамилииле воастре ши ынжунгияць Паштеле. ");
INSERT INTO ron1924_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Сэ луаць апой ун мэнункь де исоп, сэ-л ынмуяць ын сынӂеле дин стракинэ ши сэ унӂець прагул де сус ши чей дой стылпь ай уший ку сынӂеле дин стракинэ. Нимень дин вой сэ ну ясэ дин касэ пынэ диминяца. ");
INSERT INTO ron1924_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Кынд ва трече Домнул ка сэ ловяскэ Еӂиптул ши ва ведя сынӂеле пе прагул де сус ши пе чей дой стылпь ай уший, Домнул ва трече пе лынгэ ушэ ши ну ва ынгэдуи Нимичиторулуй сэ интре ын каселе воастре ка сэ вэ ловяскэ. ");
INSERT INTO ron1924_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Сэ пэзиць лукрул ачеста ка о леӂе пентру вой ши пентру копиий воштри ын вяк. ");
INSERT INTO ron1924_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Кынд вець интра ын цара пе каре в-о ва да Домнул, дупэ фэгэдуинца Луй, сэ цинець ачест обичей сфынт. ");
INSERT INTO ron1924_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Ши кынд вэ вор ынтреба копиий воштри: ‘Че ынсямнэ обичеюл ачеста?’ ");
INSERT INTO ron1924_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","сэ рэспундець: ‘Есте жертфа де Паште ын чинстя Домнулуй, каре а трекут пе лынгэ каселе копиилор луй Исраел ын Еӂипт, кынд а ловит Еӂиптул ши не-а скэпат каселе ноастре.’” Попорул с-а плекат ши с-а ынкинат пынэ ла пэмынт. ");
INSERT INTO ron1924_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Ши копиий луй Исраел ау плекат ши ау фэкут кум порунчисе Домнул луй Мойсе ши луй Аарон; аша ау фэкут. ");
INSERT INTO ron1924_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Ла мезул нопций, Домнул а ловит пе тоць ынтыий нэскуць дин цара Еӂиптулуй, де ла ынтыюл нэскут ал луй Фараон, каре шедя пе скаунул луй де домние, пынэ ла ынтыюл нэскут ал челуй ынкис ын темницэ ши пынэ ла тоць ынтыий нэскуць ай добитоачелор. ");
INSERT INTO ron1924_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Фараон с-а скулат ноаптя, ел ши тоць служиторий луй ши тоць еӂиптений, ши ау фост марь ципете ын Еӂипт, кэч ну ера касэ унде сэ ну фие ун морт. ");
INSERT INTO ron1924_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Ын ачеяшь ноапте, Фараон а кемат пе Мойсе ши пе Аарон ши ле-а зис: „Скулаци-вэ, ешиць дин мижлокул попорулуй меу, вой ши копиий луй Исраел. Дучеци-вэ сэ служиць Домнулуй, кум аць зис. ");
INSERT INTO ron1924_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Луаци-вэ ши оиле ши боий, кум аць зис, дучеци-вэ ши бинекувынтаци-мэ.” ");
INSERT INTO ron1924_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Еӂиптений зоряу попорул ши се грэбяу сэ-й скоатэ дин царэ, кэч зичяу: „Алтфел, тоць вом пери.” ");
INSERT INTO ron1924_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Попорул шь-а луат плэмэдяла (кока) ынаинте де а се доспи. Шь-ау ынвелит постэвиле ку плэмэдяла ын хайне ши ле-ау пус пе умерь. ");
INSERT INTO ron1924_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Копиий луй Исраел ау фэкут че спусесе Мойсе ши ау черут еӂиптенилор васе де арӂинт, васе де аур ши хайне. ");
INSERT INTO ron1924_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Домнул а фэкут ка попорул сэ капете тречере ынаинтя еӂиптенилор, каре ле-ау ымплинит череря. Ши астфел ау жефуит пе еӂиптень. ");
INSERT INTO ron1924_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Копиий луй Исраел ау плекат дин Рамсес спре Сукот, ын нумэр де апроапе шасе суте де мий де оамень каре мерӂяу пе жос, афарэ де копий. ");
INSERT INTO ron1924_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","О мулциме де оамень де тот союл с-ау суит ымпреунэ ку ей; авяу ши турме ынсемнате де ой ши бой. ");
INSERT INTO ron1924_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Ку плэмэдяла пе каре о луасерэ дин Еӂипт ши каре ну се досписе ынкэ, ау фэкут турте фэрэ алуат, кэч фусесерэ изгониць де еӂиптень фэрэ сэ май поатэ зэбови ши фэрэ сэ-шь я меринде ку ей. ");
INSERT INTO ron1924_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Шедеря копиилор луй Исраел ын Еӂипт а фост де патру суте трейзечь де ань. ");
INSERT INTO ron1924_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Ши, дупэ патру суте трейзечь де ань, токмай ын зиуа ачея, тоате оштиле Домнулуй ау ешит дин цара Еӂиптулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Ноаптя ачея требуе прэзнуитэ ын чинстя Домнулуй, пентру кэ атунч й-а скос дин цара Еӂиптулуй. Ноаптя ачея требуе прэзнуитэ ын чинстя Домнулуй де тоць копиий луй Исраел ши де урмаший лор. ");
INSERT INTO ron1924_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Домнул а зис луй Мойсе ши луй Аарон: „Ятэ порунка привитоаре ла Паште: ничун стрэин сэ ну мэнынче дин еле. ");
INSERT INTO ron1924_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Сэ тай ымпрежур пе орьче роб кумпэрат ку бань, ши апой сэ мэнынче дин еле. ");
INSERT INTO ron1924_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Венетикул ши симбриашул сэ ну мэнынче. ");
INSERT INTO ron1924_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Сэ ну ле мэнынче декыт ынтр-о сингурэ касэ; сэ ну луаць делок карне афарэ дин касэ ши сэ ну здробиць ничун ос. ");
INSERT INTO ron1924_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Тоатэ адунаря луй Исраел сэ факэ Паштеле. ");
INSERT INTO ron1924_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Дакэ ун стрэин каре ва локуи ла тине ва вря сэ факэ Паштеле Домнулуй, орьче парте бэрбэтяскэ дин каса луй ва требуи тэятэ ымпрежур; апой се ва апропия сэ ле факэ, ши ва фи ка ши бэштинашул, дар ничун нетэят ымпрежур сэ ну мэнынче дин еле. ");
INSERT INTO ron1924_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Ачеяшь леӂе ва фи пентру бэштинаш ка ши пентру стрэинул каре ва локуи ын мижлокул востру.” ");
INSERT INTO ron1924_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Тоць копиий луй Исраел ау фэкут кум порунчисе Домнул луй Мойсе ши луй Аарон; аша ау фэкут. ");
INSERT INTO ron1924_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Ши кяр ын зиуа ачея, Домнул а скос дин цара Еӂиптулуй пе копиий луй Исраел, дупэ оштиле лор. ");
INSERT INTO ron1924_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","„Пуне-Мь деопарте ка сфынт пе орьче ынтый нэскут, пе орьче ынтый нэскут динтре копиий луй Исраел, атыт динтре оамень, кыт ши динтре добитоаче: есте ал Меу.” ");
INSERT INTO ron1924_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Мойсе а зис попорулуй: „Адучеци-вэ аминте де зиуа ачаста, кынд аць ешит дин Еӂипт, дин каса робией, кэч ку мынэ путерникэ в-а скос Домнул де аколо. Сэ ну мынкаць пыне доспитэ. ");
INSERT INTO ron1924_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Астэзь ешиць, ын луна спичелор. ");
INSERT INTO ron1924_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Кынд те ва дуче Домнул ын цара канааницилор, хетицилор, аморицилор, хевицилор ши иебусицилор, пе каре а журат пэринцилор тэй кэ ць-о ва да, царэ унде курӂе лапте ши мьере, сэ ций урмэтоаря службэ ын луна ачаста. ");
INSERT INTO ron1924_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Тимп де шапте зиле, сэ мэнынчь азиме, ши ын зиуа а шаптя, сэ фие о сэрбэтоаре ын чинстя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Ын тимпул челор шапте зиле, сэ мынкаць азиме; сэ ну се вадэ ла тине нимик доспит, нич алуат, пе тоатэ ынтиндеря цэрий тале. ");
INSERT INTO ron1924_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Сэ спуй атунч фиулуй тэу: ‘Ачаста есте спре помениря челор че а фэкут Домнул пентру мине, кынд ам ешит дин Еӂипт.’ ");
INSERT INTO ron1924_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Сэ-ць фие ка ун семн пе мынэ ши ка ун семн де адучере аминте пе фрунте, ынтре окий тэй, пентру ка Леӂя Домнулуй сэ фие тотдяуна ын гура та; кэч ку мынэ путерникэ те-а скос Домнул дин Еӂипт. ");
INSERT INTO ron1924_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Сэ ций порунка ачаста ла время хотэрытэ, дин ан ын ан. ");
INSERT INTO ron1924_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Кынд те ва адуче Домнул ын цара канааницилор, кум а журат цие ши пэринцилор тэй, ши кынд ць-о ва да, ");
INSERT INTO ron1924_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","сэ ынкинь Домнулуй пе орьче ынтый нэскут, кяр пе орьче ынтый нэскут дин вителе пе каре ле вей авя: орьче парте бэрбэтяскэ есте а Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Сэ рэскумперь ку ун мел пе орьче ынтый нэскут ал мэгэрицей, яр дакэ ну-л вей рэскумпэра, сэ-й фрынӂь гытул. Сэ рэскумперь, де асеменя, пе орьче ынтый нэскут де парте бэрбэтяскэ динтре фиий тэй. ");
INSERT INTO ron1924_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Ши кынд те ва ынтреба фиул тэу ынтр-о зи: ‘Че ынсямнэ лукрул ачеста?’ сэ-й рэспунзь: ‘Прин мына Луй чя атотпутерникэ, Домнул не-а скос дин Еӂипт, дин каса робией; ");
INSERT INTO ron1924_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","ши, фииндкэ Фараон се ынкэпэцына ши ну воя сэ не ласе сэ плекэм, Домнул а оморыт пе тоць ынтыий нэскуць дин цара Еӂиптулуй, де ла ынтыий нэскуць ай оаменилор пынэ ла ынтыий нэскуць ай добитоачелор. Ятэ де че адук жертфэ Домнулуй пе орьче ынтый нэскут де парте бэрбэтяскэ ши рэскумпэр пе орьче ынтый нэскут динтре фиий мей. ");
INSERT INTO ron1924_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Сэ-ць фие ка ун семн пе мынэ ши ка ун семн де адучере аминте пе фрунте, ынтре окь, кэч прин мына Луй атотпутерникэ не-а скос Домнул дин Еӂипт.’” ");
INSERT INTO ron1924_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Дупэ че Фараон а лэсат пе попор сэ плече, Думнезеу ну л-а дус пе друмул каре дэ ын цара филистенилор, мэкар кэ ера май апроапе, кэч а зис Думнезеу: „С-ар путя сэ-й парэ рэу попорулуй вэзынд рэзбоюл ши сэ се ынтоаркэ ын Еӂипт.” ");
INSERT INTO ron1924_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Чи Думнезеу а пус пе попор сэ факэ ун окол пе друмул каре дуче спре пустиу, спре Маря Рошие. Копиий луй Исраел ау ешит ынармаць дин цара Еӂиптулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Мойсе а луат ку ел оаселе луй Иосиф; кэч Иосиф пусесе пе фиий луй Исраел сэ журе, зикынд: „Кынд вэ ва черчета Думнезеу, сэ луаць ку вой оаселе меле де аич.” ");
INSERT INTO ron1924_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Ау плекат дин Сукот ши ау тэбэрыт ла Етам, ла марӂиня пустиулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Домнул мерӂя ынаинтя лор: зиуа ынтр-ун стылп де нор, ка сэ-й кэлэузяскэ пе друм, яр ноаптя ынтр-ун стылп де фок, ка сэ-й луминезе, пентру ка сэ мяргэ ши зиуа, ши ноаптя. ");
INSERT INTO ron1924_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Стылпул де нор ну се депэрта динаинтя попорулуй ын тимпул зилей, нич стылпул де фок, ын тимпул нопций. ");
INSERT INTO ron1924_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","„Спуне копиилор луй Исраел сэ се ынтоаркэ ши сэ тэбэраскэ ынаинтя Пи-Хахиротулуй, ынтре Мигдол ши маре, фацэ ын фацэ ку Баал-Цефон: ын дрептул локулуй ачестуя сэ тэбэрыць, лынгэ маре. ");
INSERT INTO ron1924_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Фараон ва зиче деспре копиий луй Исраел: ‘С-ау рэтэчит прин царэ; ый ынкиде пустиул.’ ");
INSERT INTO ron1924_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Еу вой ымпетри инима луй Фараон, ши-й ва урмэри, дар Фараон ши тоатэ оастя луй вор фаче сэ се арате слава Мя, ши еӂиптений вор шти кэ Еу сунт Домнул.” Копиий луй Исраел ау фэкут аша. ");
INSERT INTO ron1924_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","С-а дат де штире ымпэратулуй Еӂиптулуй кэ попорул а луат фуга. Атунч, инима луй Фараон ши а служиторилор луй с-а скимбат фацэ де попор. Ей ау зис: „Че ам фэкут де ам лэсат пе Исраел сэ плече ши сэ ну не май служяскэ?” ");
INSERT INTO ron1924_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Фараон шь-а прегэтит карул де рэзбой ши шь-а луат оамений де рэзбой ку ел. ");
INSERT INTO ron1924_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","А луат шасе суте де каре де луптэ ку оамень алешь ши тоате кареле Еӂиптулуй; ын тоате ерау луптэторь. ");
INSERT INTO ron1924_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Домнул а ымпетрит инима луй Фараон, ымпэратул Еӂиптулуй, ши Фараон а урмэрит пе копиий луй Исраел. Копиий луй Исраел ешисерэ гата де луптэ. ");
INSERT INTO ron1924_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Еӂиптений й-ау урмэрит, ши тоць каий, кареле луй Фараон, кэлэреций луй ши оштиря луй й-ау ажунс токмай кынд ерау тэбэрыць лынгэ маре, лынгэ Пи-Хахирот, фацэ ын фацэ ку Баал-Цефон. ");
INSERT INTO ron1924_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Фараон се апропия. Копиий луй Исраел шь-ау ридикат окий ши ятэ кэ еӂиптений веняу дупэ ей. Ши копиий луй Исраел с-ау ынспэймынтат фоарте таре ши ау стригат кэтре Домнул дупэ ажутор. ");
INSERT INTO ron1924_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Ей ау зис луй Мойсе: „Ну ерау оаре морминте ын Еӂипт, ка сэ ну май фи фост невое сэ не адучь сэ мурим ын пустиу? Че не-ай фэкут де не-ай скос дин Еӂипт? ");
INSERT INTO ron1924_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ну-ць спуням ной ын Еӂипт: ‘Ласэ-не сэ служим ка робь еӂиптенилор, кэч врем май бине сэ служим ка робь еӂиптенилор декыт сэ мурим ын пустиу’?” ");
INSERT INTO ron1924_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Мойсе а рэспунс попорулуй: „Ну вэ темець де нимик, стаць пе лок ши вець ведя избэвиря пе каре в-о ва да Домнул ын зиуа ачаста, кэч пе еӂиптений ачештя пе каре-й ведець азь, ну-й вець май ведя ничодатэ. ");
INSERT INTO ron1924_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Домнул Се ва лупта пентру вой, дар вой стаць лиништиць.” ");
INSERT INTO ron1924_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Домнул а зис луй Мойсе: „Че рост ау стригэтеле ачестя? Спуне копиилор луй Исраел сэ порняскэ ынаинте. ");
INSERT INTO ron1924_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Ту ридикэ-ць тоягул, ынтинде-ць мына спре маре ши деспик-о, ши копиий луй Исраел вор трече прин мижлокул мэрий ка пе ускат. ");
INSERT INTO ron1924_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Еу вой ымпетри инима еӂиптенилор, ка сэ интре ын маре дупэ ей. Ши Фараон ши тоатэ оастя луй, кареле ши кэлэреций луй вор фаче сэ се арате слава Мя. ");
INSERT INTO ron1924_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Ши вор шти еӂиптений кэ Еу сунт Домнул кынд Фараон, кареле ши кэлэреций луй вор фаче сэ се арате слава Мя.” ");
INSERT INTO ron1924_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Ынӂерул луй Думнезеу, каре мерӂя ынаинтя таберей луй Исраел, Шь-а скимбат локул ши а мерс ынапоя лор, ши стылпул де нор каре мерӂя ынаинтя лор шь-а скимбат локул ши а стат ынапоя лор. ");
INSERT INTO ron1924_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Ел с-а ашезат ынтре табэра еӂиптенилор ши табэра луй Исраел. Норул ачеста пе о парте ера ынтунекос, яр пе чялалтэ лумина ноаптя. Ши тоатэ ноаптя челе доуэ табере ну с-ау апропият уна де алта. ");
INSERT INTO ron1924_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Мойсе шь-а ынтинс мына спре маре. Ши Домнул а пус маря ын мишкаре принтр-ун вынт динспре рэсэрит, каре а суфлат ку путере тоатэ ноаптя; ел а ускат маря, ши апеле с-ау деспэрцит ын доуэ. ");
INSERT INTO ron1924_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Копиий луй Исраел ау трекут прин мижлокул мэрий ка пе ускат, ши апеле стэтяу ка ун зид ла дряпта ши ла стынга лор. ");
INSERT INTO ron1924_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Еӂиптений й-ау урмэрит, ши тоць каий луй Фараон, кареле ши кэлэреций луй ау интрат дупэ ей ын мижлокул мэрий. ");
INSERT INTO ron1924_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Ын стража диминеций, Домнул, дин стылпул де фок ши де нор, С-а уйтат спре табэра еӂиптенилор ши а арункат ынвэлмэшялэ ын табэра еӂиптенилор. ");
INSERT INTO ron1924_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","А скос роциле карелор ши ле-а ынгреуят мерсул. Еӂиптений ау зис атунч: „Хайдем сэ фуӂим динаинтя луй Исраел, кэч Домнул Се луптэ пентру ел ымпотрива еӂиптенилор.” ");
INSERT INTO ron1924_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Домнул а зис луй Мойсе: „Ынтинде-ць мына спре маре, ши апеле ау сэ се ынтоаркэ песте еӂиптень, песте кареле лор ши песте кэлэреций лор.” ");
INSERT INTO ron1924_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Мойсе шь-а ынтинс мына спре маре. Ши, ынспре диминяцэ, маря шь-а луат ярэшь репезичуня курсулуй ши, ла апропиеря ей, еӂиптений ау луат-о ла фугэ, дар Домнул а нэпустит пе еӂиптень ын мижлокул мэрий. ");
INSERT INTO ron1924_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Апеле с-ау ынторс ши ау акоперит кареле, кэлэреций ши тоатэ оастя луй Фараон, каре интрасерэ ын маре дупэ копиий луй Исраел; ничунул мэкар н-а скэпат. ");
INSERT INTO ron1924_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Дар копиий луй Исраел ау трекут прин мижлокул мэрий ка пе ускат, ын тимп че апеле стэтяу ка ун зид ла дряпта ши ла стынга лор. ");
INSERT INTO ron1924_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Ын зиуа ачея, Домнул а избэвит пе Исраел дин мына еӂиптенилор, ши Исраел а вэзут пе еӂиптень морць пе цэрмул мэрий. ");
INSERT INTO ron1924_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Исраел а вэзут мына путерникэ пе каре о ындрептасе Домнул ымпотрива еӂиптенилор. Ши попорул с-а темут де Домнул ши а крезут ын Домнул ши ын робул Сэу Мойсе. ");
INSERT INTO ron1924_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Атунч, Мойсе ши копиий луй Исраел ау кынтат Домнулуй кынтаря ачаста. Ей ау зис: „Вой кынта Домнулуй, кэч Шь-а арэтат слава: А нэпустит ын маре пе кал ши пе кэлэрец. ");
INSERT INTO ron1924_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Домнул есте тэрия мя ши темеюл кынтэрилор меле де лаудэ: Ел м-а скэпат. Ел есте Думнезеул меу: пе Ел Ыл вой лэуда. Ел есте Думнезеул татэлуй меу: пе Ел Ыл вой прямэри. ");
INSERT INTO ron1924_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Домнул есте ун рэзбойник витяз: Нумеле Луй есте Домнул. ");
INSERT INTO ron1924_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Ел а арункат ын маре кареле луй Фараон ши оастя луй; Луптэторий луй алешь ау фост ынгициць ын Маря Рошие. ");
INSERT INTO ron1924_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Й-ау акоперит валуриле Ши с-ау коборыт ын фундул апелор, ка о пятрэ. ");
INSERT INTO ron1924_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Дряпта Та, Доамне, шь-а фэкут веститэ тэрия; Мына Та чя дряптэ, Доамне, а здробит пе врэжмашь. ");
INSERT INTO ron1924_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Прин мэримя мэрецией Тале, Ту трынтешть ла пэмынт пе врэжмаший Тэй; Ыць дезлэнцуй мыния Ши еа-й мистуе ка пе о трестие. ");
INSERT INTO ron1924_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Ла суфларя нэрилор Тале, с-ау ынгрэмэдит апеле, С-ау ридикат талазуриле ка ун зид Ши с-ау ынкегат валуриле ын мижлокул мэрий. ");
INSERT INTO ron1924_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Врэжмашул зичя: ‘Ый вой урмэри, ый вой ажунӂе, Вой ымпэрци прада де рэзбой; Мэ вой рэзбуна пе ей, Вой скоате сабия ши-й вой нимичи ку мына мя!’ ");
INSERT INTO ron1924_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Дар Ту ай суфлат ку суфларя Та Ши маря й-а акоперит; Ка плумбул с-ау афундат Ын адынчимя апелор. ");
INSERT INTO ron1924_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Чине есте ка Тине ынтре думнезей, Доамне? Чине есте ка Тине минунат ын сфинцение, Богат ын фапте де лаудэ Ши фэкэтор де минунь? ");
INSERT INTO ron1924_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Ту Ць-ай ынтинс мына дряптэ, Ши й-а ынгицит пэмынтул. ");
INSERT INTO ron1924_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Прин ындураря Та, Ту ай кэлэузит Ши ай избэвит пе попорул ачеста, Яр прин путеря Та ыл ындрепць Спре локашул сфинценией Тале. ");
INSERT INTO ron1924_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Попоареле вор афла лукрул ачеста ши се вор кутремура: Апукэ гроаза пе филистень, ");
INSERT INTO ron1924_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Се ынспэймынтэ кэпетенииле Едомулуй Ши ун тремур апукэ пе рэзбойничий луй Моаб. Тоць локуиторий Канаанулуй лешинэ де ла инимэ. ");
INSERT INTO ron1924_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Ый ва апука тяма ши спайма; Яр вэзынд мэреция брацулуй Тэу, Вор ста муць ка о пятрэ, Пынэ ва трече попорул Тэу, Доамне! Пынэ ва трече Попорул пе каре Ци л-ай рэскумпэрат. ");
INSERT INTO ron1924_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Ту ый вей адуче ши-й вей ашеза пе мунтеле моштенирий Тале, Ын локул пе каре Ци л-ай прегэтит ка локаш, Доамне, Ла Темплул пе каре мыниле Тале л-ау ынтемеят, Доамне! ");
INSERT INTO ron1924_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Ши Домнул ва ымпэрэци ын вяк ши ын вечь де вечь. ");
INSERT INTO ron1924_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Кэч каий луй Фараон, кареле ши кэлэреций луй ау интрат ын маре, Ши Домнул а адус песте ей апеле мэрий; Дар копиий луй Исраел ау мерс ка пе ускат прин мижлокул мэрий.” ");
INSERT INTO ron1924_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Мария, пророчица, сора луй Аарон, а луат ын мынэ ун тимпан ши тоате фемеиле ау венит дупэ еа ку тимпане ши жукынд. ");
INSERT INTO ron1924_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Мария рэспундя копиилор луй Исраел: „Кынтаць Домнулуй, кэч Шь-а арэтат слава: А нэпустит ын маре пе кал ши пе кэлэрец.” ");
INSERT INTO ron1924_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Мойсе а порнит пе Исраел де ла Маря Рошие. Ау апукат ынспре пустиул Шур ши, дупэ трей зиле де мерс ын пустиу, н-ау гэсит апэ. ");
INSERT INTO ron1924_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Ау ажунс ла Мара, дар н-ау путут сэ бя апэ дин Мара, пентру кэ ера амарэ. Де ачея локул ачела а фост нумит Мара. ");
INSERT INTO ron1924_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Попорул а кыртит ымпотрива луй Мойсе, зикынд: „Че авем сэ бем?” ");
INSERT INTO ron1924_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Мойсе а стригат кэтре Домнул, ши Домнул й-а арэтат ун лемн, пе каре л-а арункат ын апэ. Ши апа с-а фэкут дулче. Аколо а дат Домнул попорулуй леӂь ши порунчь ши аколо л-а пус ла ынчеркаре. ");
INSERT INTO ron1924_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Ел а зис: „Дакэ вей аскулта ку луаре аминте гласул Домнулуй Думнезеулуй тэу, дакэ вей фаче че есте бине ынаинтя Луй, дакэ вей аскулта де порунчиле Луй ши дакэ вей пэзи тоате леӂиле Луй, ну те вой лови ку ничуна дин болиле ку каре ам ловит пе еӂиптень, кэч Еу сунт Домнул, каре те виндекэ.” ");
INSERT INTO ron1924_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Ау ажунс ла Елим, унде ерау доуэспрезече извоаре де апэ ши шаптезечь де финичь. Ши ау тэбэрыт аколо, лынгэ апэ. ");
INSERT INTO ron1924_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Тоатэ адунаря копиилор луй Исраел а плекат дин Елим ши ау ажунс ын пустиул Син, каре есте ынтре Елим ши Синай, ын а чинчспрезечя зи а луний а доуа, дупэ еширя лор дин цара Еӂиптулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Ши тоатэ адунаря копиилор луй Исраел а кыртит ын пустиул ачела ымпотрива луй Мойсе ши Аарон. ");
INSERT INTO ron1924_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Копиий луй Исраел ле-ау зис: „Кум де н-ам мурит ловиць де мына Домнулуй ын цара Еӂиптулуй, кынд шедям лынгэ оалеле ноастре ку карне, кынд мынкам пыне де не сэтурам? Кэч не-аць адус ын пустиул ачеста ка сэ фачець сэ моарэ де фоаме тоатэ мулцимя ачаста.” ");
INSERT INTO ron1924_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Домнул а зис луй Мойсе: „Ятэ кэ вой фаче сэ вэ плоуэ пыне дин черурь. Попорул ва еши афарэ ши ва стрынӂе кыт ый требуе пентру фиекаре зи, ка сэ-л пун ла ынчеркаре ши сэ вэд дакэ ва умбла сау ну дупэ Леӂя Мя. ");
INSERT INTO ron1924_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ын зиуа а шася, кынд вор прегэти че ау адус акасэ, вор авя де доуэ орь май мулт декыт вор стрынӂе ын фиекаре зи.” ");
INSERT INTO ron1924_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Мойсе ши Аарон ау зис тутурор копиилор луй Исраел: „Астэ-сярэ, вець ынцелеӂе кэ Домнул есте Ачела каре в-а скос дин цара Еӂиптулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Ши мыне диминяцэ, вець ведя слава Домнулуй, пентру кэ в-а аузит кыртириле ымпотрива Домнулуй; кэч че сунтем ной, ка сэ кыртиць ымпотрива ноастрэ?” ");
INSERT INTO ron1924_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Мойсе а зис: „Домнул вэ ва да астэ-сярэ карне де мынкат, ши мыне диминяцэ вэ ва да пыне сэ вэ сэтураць, пентру кэ а аузит Домнул кыртириле пе каре ле-аць ростит ымпотрива Луй; кэч че сунтем ной? Кыртириле воастре ну се ындряптэ ымпотрива ноастрэ, чи ымпотрива Домнулуй.” ");
INSERT INTO ron1924_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Мойсе а зис луй Аарон: „Спуне ынтреӂий адунэрь а копиилор луй Исраел: ‘Апропияци-вэ ынаинтя Домнулуй, кэч в-а аузит кыртириле.’” ");
INSERT INTO ron1924_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Ши, пе кынд ворбя Аарон ынтреӂий адунэрь а луй Исраел, с-ау уйтат ынспре пустиу, ши ятэ кэ слава Домнулуй с-а арэтат ын нор. ");
INSERT INTO ron1924_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Домнул, ворбинд луй Мойсе, а зис: ");
INSERT INTO ron1924_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","„Ам аузит кыртириле копиилор луй Исраел. Спуне-ле: ‘Ынтре челе доуэ серь авець сэ мынкаць карне, ши диминяца вэ вець сэтура де пыне ши вець шти кэ Еу сунт Домнул Думнезеул востру.’” ");
INSERT INTO ron1924_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Сяра ау венит ниште препелице ши ау акоперит табэра, ши диминяца с-а ашезат ун страт грос де роуэ ын журул таберей. ");
INSERT INTO ron1924_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Кынд с-а луат роуа ачаста, пе фаца пустиулуй ера чева мэрунт ка ниште грэунце, мэрунт ка бобицеле де гяцэ албэ пе пэмынт. ");
INSERT INTO ron1924_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Копиий луй Исраел с-ау уйтат ла еа ши ау зис унул кэтре алтул: „Че есте ачаста?” кэч ну штияу че есте. Мойсе ле-а зис: „Есте пыня пе каре в-о дэ Домнул ка хранэ.” ");
INSERT INTO ron1924_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Ятэ че а порунчит Домнул: „Фиекаре динтре вой сэ стрынгэ кыт ый требуе пентру хранэ, ши ануме ун омер де кап, дупэ нумэрул суфлетелор воастре; фиекаре сэ я дин еа пентру чей дин кортул луй.” ");
INSERT INTO ron1924_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Исраелиций ау фэкут аша ши ау стрынс уний май мулт, алций май пуцин. ");
INSERT INTO ron1924_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Ын урмэ о мэсурау ку омерул, ши чине стрынсесе май мулт н-авя нимик де присос, яр чине стрынсесе май пуцин ну дучя липсэ делок. Фиекаре стрынӂя токмай кыт ый требуя пентру хранэ. ");
INSERT INTO ron1924_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Мойсе ле-а зис: „Нимень сэ ну ласе чева дин еа пынэ а доуа зи диминяца.” ");
INSERT INTO ron1924_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Н-ау аскултат де Мойсе ши с-ау гэсит уний каре ау лэсат чева дин еа пынэ диминяца, дар а фэкут вермь ши с-а ымпуцит. Мойсе с-а мыният пе оамений ачея. ");
INSERT INTO ron1924_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Астфел, ын тоате диминециле, фиекаре стрынӂя кыт ый требуя пентру хранэ ши, кынд веня кэлдура соарелуй, се топя. ");
INSERT INTO ron1924_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Ын зиуа а шася, ау стрынс хранэ ындоит, ши ануме дой омерь де фиекаре. Тоць фрунташий адунэрий ау венит ши ау спус луй Мойсе лукрул ачеста. ");
INSERT INTO ron1924_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Ши Мойсе ле-а зис: „Домнул а порунчит аша. Мыне есте зиуа де одихнэ, Сабатул ынкинат Домнулуй; коачець че авець де копт, фербець че авець де ферт ши пэстраць пынэ а доуа зи диминяца тот че ва рэмыне!” ");
INSERT INTO ron1924_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Ау лэсат-о пынэ а доуа зи диминяца, кум порунчисе Мойсе, ши ну с-а ымпуцит ши н-а фэкут вермь. ");
INSERT INTO ron1924_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Мойсе а зис: „Мынкаць-о азь, кэч есте зиуа Сабатулуй; азь ну вець гэси манэ пе кымп. ");
INSERT INTO ron1924_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Вець стрынӂе тимп де шасе зиле, дар ын зиуа а шаптя, каре есте Сабатул, ну ва фи.” ");
INSERT INTO ron1924_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Ын зиуа а шаптя, уний дин попор ау ешит сэ стрынгэ манэ, ши н-ау гэсит. ");
INSERT INTO ron1924_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Атунч, Домнул а зис луй Мойсе: „Пынэ кынд авець де гынд сэ ну пэзиць порунчиле ши леӂиле Меле? ");
INSERT INTO ron1924_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Ведець кэ Домнул в-а дат Сабатул; де ачея вэ дэ ын зиуа а шася хранэ пентру доуэ зиле. Фиекаре сэ рэмынэ ла локул луй ши, ын зиуа а шаптя, нимень сэ ну ясэ дин локул ын каре се гэсеште.” ");
INSERT INTO ron1924_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Ши попорул с-а одихнит ын зиуа а шаптя. ");
INSERT INTO ron1924_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Каса луй Исраел а нумит храна ачаста „манэ”. Еа семэна ку бобул де кориандру; ера албэ ши авя ун густ де туртэ ку мьере. ");
INSERT INTO ron1924_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Мойсе а зис: „Ятэ че а порунчит Домнул: ‘Сэ се пэстрезе ун омер плин ку манэ пентру урмаший воштри, ка сэ вадэ ши ей пыня пе каре в-ам дат-о с-о мынкаць ын пустиу, дупэ че в-ам скос дин цара Еӂиптулуй.’” ");
INSERT INTO ron1924_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Ши Мойсе а зис луй Аарон: „Я ун вас, пуне ын ел ун омер плин ку манэ ши ашазэ-л ынаинтя Домнулуй, ка сэ фие пэстрат пентру урмаший воштри.” ");
INSERT INTO ron1924_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Дупэ порунка датэ де Домнул луй Мойсе, Аарон л-а пус ынаинтя кивотулуй мэртурией, ка сэ фие пэстрат. ");
INSERT INTO ron1924_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Копиий луй Исраел ау мынкат манэ патрузечь де ань, пынэ ла сосиря лор ынтр-о царэ локуитэ; ау мынкат манэ пынэ ла сосиря лор ла хотареле цэрий Канаанулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Омерул есте а зечя парте динтр-о ефэ. ");
INSERT INTO ron1924_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Тоатэ адунаря копиилор луй Исраел а плекат дин пустиул Син, дупэ кэлэторииле зилниче пе каре порунчисе Домнул сэ ле факэ, ши ау тэбэрыт ла Рефидим. Аколо попорул н-а гэсит апэ де бэут. ");
INSERT INTO ron1924_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Атунч, попорул а кэутат чартэ ку Мойсе. Ей ау зис: „Дэ-не апэ сэ бем!” Мойсе ле-а рэспунс: „Пентру че кэутаць чартэ ку мине? Пентру че испитиць пе Домнул?” ");
INSERT INTO ron1924_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Попорул стэтя аколо, кинуит де сете, ши кыртя ымпотрива луй Мойсе. Ел зичя: „Пентру че не-ай скос дин Еӂипт, ка сэ не фачь сэ мурим де сете аич, ку копиий ши турмеле ноастре?” ");
INSERT INTO ron1924_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Мойсе а стригат кэтре Домнул ши а зис: „Че сэ фак ку попорул ачеста? Ынкэ пуцин, ши ау сэ мэ учидэ ку петре.” ");
INSERT INTO ron1924_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Домнул а зис луй Мойсе: „Тречь ынаинтя попорулуй ши я ку тине врео кыцьва дин бэтрыний луй Исраел; я-ць ын мынэ ши тоягул ку каре ай ловит рыул ши порнеште! ");
INSERT INTO ron1924_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Ятэ, Еу вой ста ынаинтя та пе стынка Хоребулуй; вей лови стынка ши ва цышни апэ дин еа, ши попорул ва бя.” Мойсе а фэкут аша ын фаца бэтрынилор луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Ел а нумит локул ачела Маса ши Мериба, кэч копиий луй Исраел се чертасерэ ши испитисерэ пе Домнул, зикынд: „Есте оаре Домнул ын мижлокул ностру сау ну есте?” ");
INSERT INTO ron1924_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Амалек а венит сэ батэ пе Исраел ла Рефидим. ");
INSERT INTO ron1924_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Атунч, Мойсе а зис луй Иосуа: „Алеӂе ниште бэрбаць ши ешь де луптэ ымпотрива луй Амалек. Яр еу вой ста мыне пе вырфул дялулуй ку тоягул луй Думнезеу ын мынэ.” ");
INSERT INTO ron1924_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Иосуа а фэкут че-й спусесе Мойсе ши а ешит сэ лупте ымпотрива луй Амалек. Яр Мойсе, Аарон ши Хур с-ау суит пе вырфул дялулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Кынд ышь ридика Мойсе мына, ера май таре Исраел ши кынд ышь лэса мына ын жос, ера май таре Амалек. ");
INSERT INTO ron1924_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Мыниле луй Мойсе фиинд трудите, ей ау луат о пятрэ, ау пус-о суб ел, ши ел а шезут пе еа. Аарон ши Хур ый сприжиняу мыниле, унул де о парте, яр алтул де алта, ши мыниле луй ау рэмас ынтинсе пынэ ла асфинцитул соарелуй. ");
INSERT INTO ron1924_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Ши Иосуа а бируит пе Амалек ши попорул луй ку тэишул сабией. ");
INSERT INTO ron1924_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Домнул а зис луй Мойсе: „Скрие лукрул ачеста ын карте, ка сэ се пэстрезе адучеря аминте, ши спуне луй Иосуа кэ вой штерӂе помениря луй Амалек де суб черурь.” ");
INSERT INTO ron1924_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Мойсе а зидит ун алтар ши й-а пус нумеле „Домнул, стягул меу”. ");
INSERT INTO ron1924_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Ел а зис: „Пентру кэ шь-а ридикат мына ымпотрива скаунулуй де домние ал Домнулуй, Домнул ва пурта рэзбой ымпотрива луй Амалек, дин ням ын ням!” ");
INSERT INTO ron1924_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Иетро, преотул Мадианулуй, сокрул луй Мойсе, а афлат тот че фэкусе Думнезеу пентру Мойсе ши попорул Сэу Исраел; а афлат кэ Домнул скосесе пе Исраел дин Еӂипт. ");
INSERT INTO ron1924_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Иетро, сокрул луй Мойсе, а луат пе Сефора, неваста луй Мойсе, каре фусесе тримисэ акасэ. ");
INSERT INTO ron1924_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","А луат ши пе чей дой фий ай Сефорей; унул се нумя Гершом, кэч Мойсе зисесе: „Локуеск ка стрэин ынтр-о царэ стрэинэ”, ");
INSERT INTO ron1924_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","яр челэлалт се нумя Елиезер, кэч зисесе: „Думнезеул татэлуй меу мь-а ажутат ши м-а скэпат де сабия луй Фараон.” ");
INSERT INTO ron1924_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Иетро, сокрул луй Мойсе, а венит ку фиий ши неваста луй Мойсе ын пустиу, унде тэбэра ел, ла мунтеле луй Думнезеу. ");
INSERT INTO ron1924_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","А тримис ворбэ луй Мойсе сэ-й спунэ: „Еу, сокрул тэу Иетро, вин ла тине ку невастэ-та ши ку чей дой фий ай тэй.” ");
INSERT INTO ron1924_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Мойсе а ешит ынаинтя сокрулуй сэу, с-а арункат ку фаца ла пэмынт ши л-а сэрутат. С-ау ынтребат унул пе алтул де сэнэтате ши ау интрат ын кортул луй Мойсе. ");
INSERT INTO ron1924_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Мойсе а историсит сокрулуй сэу тот че фэкусе Домнул ымпотрива луй Фараон ши ымпотрива Еӂиптулуй дин причина луй Исраел, тоате суферинцеле каре венисерэ песте ей пе друм ши кум ый избэвисе Домнул дин еле. ");
INSERT INTO ron1924_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Иетро с-а букурат пентру тот бинеле пе каре-л фэкусе Домнул луй Исраел ши пентру кэ-л избэвисе дин мына еӂиптенилор. ");
INSERT INTO ron1924_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Ши Иетро а зис: „Бинекувынтат сэ фие Домнул, каре в-а избэвит дин мына еӂиптенилор ши дин мына луй Фараон, Ел, каре а избэвит попорул дин мына еӂиптенилор! ");
INSERT INTO ron1924_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Куноск акум кэ Домнул есте май маре декыт тоць думнезеий, кэч ын лукрул ын каре с-ау пуртат ку труфие, Ел а фост май пресус де ей.” ");
INSERT INTO ron1924_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Иетро, сокрул луй Мойсе, а адус луй Думнезеу о ардере-де-тот ши о жертфэ де мынкаре. Аарон ши тоць бэтрыний луй Исраел ау венит ши ау луат парте ла масэ ку сокрул луй Мойсе, ынаинтя луй Думнезеу. ");
INSERT INTO ron1924_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","А доуа зи, Мойсе с-а ашезат сэ жудече попорул, ши попорул а стат ынаинтя луй де диминяца пынэ сяра. ");
INSERT INTO ron1924_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Сокрул луй Мойсе а вэзут тот че фэчя ел пентру попор ши а зис: „Че фачь ту аколо ку попорул ачела? Де че стай сингур, ши тот попорул стэ ынаинтя та де диминяца пынэ сяра?” ");
INSERT INTO ron1924_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Мойсе а рэспунс сокрулуй сэу: „Попорул вине ла мине ка сэ чарэ сфат луй Думнезеу. ");
INSERT INTO ron1924_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Кынд ау врео трябэ, вин ла мине; еу жудек ынтре ей ши фак куноскуте порунчиле луй Думнезеу ши леӂиле Луй.” ");
INSERT INTO ron1924_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Сокрул луй Мойсе й-а зис: „Че фачь ту ну есте бине. ");
INSERT INTO ron1924_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Те истовешть сингур ши вей истови ши попорул ачеста, каре есте ку тине, кэч лукрул есте май пресус де путериле тале ши ну-л вей путя фаче сингур. ");
INSERT INTO ron1924_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Акум аскултэ гласул меу; ам сэ-ць дау ун сфат, ши Думнезеу ва фи ку тине! Фий тэлмачул попорулуй ынаинтя луй Думнезеу ши ду причиниле ынаинтя луй Думнезеу. ");
INSERT INTO ron1924_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Ынвацэ-й порунчиле ши леӂиле ши аратэ-ле каля пе каре требуе с-о урмезе ши че требуе сэ факэ. ");
INSERT INTO ron1924_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Алеӂе дин тот попорул оамень дестойничь, темэторь де Думнезеу, оамень де ынкредере, врэжмашь ай лэкомией; пуне-й песте попор дрепт кэпетений песте о мие, кэпетений песте о сутэ, кэпетений песте чинчзечь ши кэпетений песте зече. ");
INSERT INTO ron1924_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Ей сэ жудече попорул ын тот тимпул; сэ адукэ ынаинтя та тоате причиниле ынсемнате, яр причиниле челе май мичь, сэ ле жудече ей ыншишь. Ын фелул ачеста, ыць вей ушура сарчина, кэч о вор пурта ши ей ымпреунэ ку тине. ");
INSERT INTO ron1924_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Дакэ вей фаче лукрул ачеста ши дакэ Думнезеу ыць ва порунчи аша, вей путя фаче фацэ лукрурилор, ши тот попорул ачеста ва ажунӂе феричит ла локул луй.” ");
INSERT INTO ron1924_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Мойсе а аскултат сфатул сокрулуй сэу ши а фэкут тот че спусесе ел. ");
INSERT INTO ron1924_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Мойсе а алес оамень дестойничь дин тот Исраелул ши й-а пус кэпетений але попорулуй, кэпетений песте о мие, кэпетений песте о сутэ, кэпетений песте чинчзечь ши кэпетений песте зече. ");
INSERT INTO ron1924_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Ей жудекау попорул тот тимпул; адучяу ынаинтя луй Мойсе причиниле греле, яр тоате причиниле мичь ле жудекау ей ыншишь. ");
INSERT INTO ron1924_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Апой Мойсе а тримис пе сокрул сэу ын цара луй. ");
INSERT INTO ron1924_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Ын луна а трея дупэ еширя лор дин цара Еӂиптулуй, копиий луй Исраел ау ажунс ын зиуа ачея ын пустиул Синай. ");
INSERT INTO ron1924_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Дупэ че ау плекат де ла Рефидим, ау ажунс ын пустиул Синай ши ау тэбэрыт ын пустиу. Исраел а тэбэрыт аколо, ын фаца мунтелуй. ");
INSERT INTO ron1924_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Мойсе с-а суит ла Думнезеу. Ши Домнул л-а кемат де пе мунте, зикынд: „Аша сэ ворбешть касей луй Иаков ши сэ спуй копиилор луй Исраел: ");
INSERT INTO ron1924_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Аць вэзут че ам фэкут Еӂиптулуй ши кум в-ам пуртат пе арипь де вултур ши в-ам адус аич ла Мине. ");
INSERT INTO ron1924_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Акум, дакэ вець аскулта гласул Меу ши дакэ вець пэзи легэмынтул Меу, вець фи ай Мей динтре тоате попоареле, кэч тот пэмынтул есте ал Меу; ");
INSERT INTO ron1924_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Ымь вець фи о ымпэрэцие де преоць ши ун ням сфынт. Ачестя сунт кувинтеле пе каре ле вей спуне копиилор луй Исраел.’” ");
INSERT INTO ron1924_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Мойсе а венит де а кемат пе бэтрыний попорулуй ши ле-а пус ынаинте тоате кувинтеле ачестя, кум ый порунчисе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Тот попорул а рэспунс: „Вом фаче тот че а зис Домнул!” Мойсе а спус Домнулуй кувинтеле попорулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Ши Домнул а зис луй Мойсе: „Ятэ, вой вени ла тине ынтр-ун нор грос, пентру ка сэ аудэ попорул кынд ыць вой ворби ши сэ айбэ тотдяуна ынкредере ын тине.” Мойсе а спус Домнулуй кувинтеле попорулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Ши Домнул а зис луй Мойсе: „Ду-те ла попор, сфинцеште-й азь ши мыне ши пуне-й сэ-шь спеле хайнеле. ");
INSERT INTO ron1924_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Сэ фие гата пентру а трея зи, кэч а трея зи Домнул Се ва коборы ын фаца ынтрегулуй попор, пе мунтеле Синай. ");
INSERT INTO ron1924_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Сэ хотэрэшть попорулуй анумите марӂинь де жур ымпрежур ши сэ спуй: ‘Сэ ну кумва сэ вэ суиць пе мунте сау сэ вэ атинӂець де поалеле луй. Орьчине се ва атинӂе де мунте ва фи педепсит ку моартя. ");
INSERT INTO ron1924_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Ничо мынэ сэ ну се атингэ де ел, чи пе орьчине се ва атинӂе, сэ-л омоаре ку петре сау сэ-л стрэпунгэ ку сэӂець: добиток сау ом ну ва трэи.’ Кынд ва суна трымбица, ей вор ынаинта спре мунте.” ");
INSERT INTO ron1924_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Мойсе с-а коборыт де пе мунте ла попор, а сфинцит попорул ши ей шь-ау спэлат хайнеле. ");
INSERT INTO ron1924_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Ши а зис попорулуй: „Фиць гата ын трей зиле; сэ ну вэ апропияць де врео фемее.” ");
INSERT INTO ron1924_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","А трея зи диминяца, ау фост тунете, фулӂере ши ун нор грос пе мунте; трымбица рэсуна ку путере ши тот попорул дин табэрэ а фост апукат де спаймэ. ");
INSERT INTO ron1924_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Мойсе а скос попорул дин табэрэ, спре ынтымпинаря луй Думнезеу, ши с-ау ашезат ла поалеле мунтелуй. ");
INSERT INTO ron1924_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Мунтеле Синай ера тот нумай фум, пентру кэ Домнул Се коборысе пе ел ын мижлокул фокулуй. Фумул ачеста се ынэлца ка фумул унуй куптор, ши тот мунтеле се кутремура ку путере. ");
INSERT INTO ron1924_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Трымбица рэсуна тот май путерник. Мойсе ворбя, ши Думнезеу ый рэспундя ку глас таре. ");
INSERT INTO ron1924_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Домнул С-а коборыт пе мунтеле Синай, ши ануме пе вырфул мунтелуй. Домнул а кемат пе Мойсе пе вырфул мунтелуй. Ши Мойсе с-а суит сус. ");
INSERT INTO ron1924_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Домнул а зис луй Мойсе: „Кобоарэ-те ши порунчеште попорулуй ку тот динадинсул сэ ну дя бузна спре Домнул, ка сэ се уйте, пентру ка ну кумва сэ пярэ ун маре нумэр динтре ей. ");
INSERT INTO ron1924_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Преоций каре се апропие де Домнул сэ се сфинцяскэ ши ей, ка ну кумва сэ-й ловяскэ Домнул ку моартя.” ");
INSERT INTO ron1924_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Мойсе а зис Домнулуй: „Попорул ну ва путя сэ се суе пе мунтеле Синай, кэч не-ай оприт ку тот динадинсул, зикынд: ‘Хотэрэште анумите марӂинь ын журул мунтелуй ши сфинцеште-л.’” ");
INSERT INTO ron1924_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Домнул й-а зис: „Ду-те, кобоарэ-те ши суе-те апой ярэшь ку Аарон, дар преоций ши попорул сэ ну дя бузна сэ се суе ла Домнул, ка ну кумва сэ-й ловяскэ ку моартя.” ");
INSERT INTO ron1924_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Мойсе с-а коборыт ла попор ши й-а спус ачесте лукрурь. ");
INSERT INTO ron1924_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Атунч, Думнезеу а ростит тоате ачесте кувинте ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","„Еу сунт Домнул Думнезеул тэу, каре те-а скос дин цара Еӂиптулуй, дин каса робией. ");
INSERT INTO ron1924_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Сэ ну ай алць думнезей афарэ де Мине. ");
INSERT INTO ron1924_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Сэ ну-ць фачь кип чоплит, нич врео ынфэцишаре а лукрурилор каре сунт сус ын черурь сау жос пе пэмынт сау ын апеле май де жос декыт пэмынтул. ");
INSERT INTO ron1924_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Сэ ну те ынкинь ынаинтя лор ши сэ ну ле служешть, кэч Еу, Домнул Думнезеул тэу, сунт ун Думнезеу ӂелос, каре педепсеск нелеӂюиря пэринцилор ын копий пынэ ла ал трейля ши ла ал патруля ням ал челор че Мэ урэск ");
INSERT INTO ron1924_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","ши Мэ ындур пынэ ла ал мииля ням де чей че Мэ юбеск ши пэзеск порунчиле Меле. ");
INSERT INTO ron1924_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Сэ ну ей ын дешерт Нумеле Домнулуй Думнезеулуй тэу, кэч Домнул ну ва лэса непедепсит пе чел че ва луа ын дешерт Нумеле Луй. ");
INSERT INTO ron1924_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Аду-ць аминте де зиуа де одихнэ, ка с-о сфинцешть. ");
INSERT INTO ron1924_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Сэ лукрезь шасе зиле ши сэ-ць фачь лукрул тэу. ");
INSERT INTO ron1924_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Дар зиуа а шаптя есте зиуа де одихнэ ынкинатэ Домнулуй Думнезеулуй тэу: сэ ну фачь ничо лукраре ын еа, нич ту, нич фиул тэу, нич фийка та, нич робул тэу, нич роаба та, нич вита та, нич стрэинул каре есте ын каса та. ");
INSERT INTO ron1924_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Кэч ын шасе зиле а фэкут Домнул черуриле, пэмынтул ши маря ши тот че есте ын еле, яр ын зиуа а шаптя С-а одихнит, де ачея а бинекувынтат Домнул зиуа де одихнэ ши а сфинцит-о. ");
INSERT INTO ron1924_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Чинстеште пе татэл тэу ши пе мама та, пентру ка сэ ци се лунӂяскэ зилеле ын цара пе каре ць-о дэ Домнул Думнезеул тэу. ");
INSERT INTO ron1924_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Сэ ну учизь. ");
INSERT INTO ron1924_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Сэ ну прякурвешть. ");
INSERT INTO ron1924_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Сэ ну фурь. ");
INSERT INTO ron1924_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Сэ ну мэртурисешть стрымб ымпотрива апроапелуй тэу. ");
INSERT INTO ron1924_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Сэ ну пофтешть каса апроапелуй тэу; сэ ну пофтешть неваста апроапелуй тэу, нич робул луй, нич роаба луй, нич боул луй, нич мэгарул луй, нич вреун алт лукру каре есте ал апроапелуй тэу.” ");
INSERT INTO ron1924_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Тот попорул аузя тунетеле ши сунетул трымбицей ши ведя флэкэриле мунтелуй каре фумега. Ла привелиштя ачаста, попорул тремура ши стэтя ын депэртаре. ");
INSERT INTO ron1924_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Ей ау зис луй Мойсе: „Ворбеште-не ту ынсуць, ши те вом аскулта, дар сэ ну не май ворбяскэ Думнезеу, ка сэ ну мурим.” ");
INSERT INTO ron1924_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Мойсе а зис попорулуй: „Ну вэ ынспэймынтаць, кэч Думнезеу а венит токмай ка сэ вэ пунэ ла ынчеркаре ши ка сэ авець фрика Луй ынаинтя окилор воштри, пентру ка сэ ну пэкэтуиць.” ");
INSERT INTO ron1924_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Попорул стэтя ын депэртаре, яр Мойсе с-а апропият де норул ын каре ера Думнезеу. ");
INSERT INTO ron1924_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Домнул а зис луй Мойсе: „Аша сэ ворбешть копиилор луй Исраел: ‘Аць вэзут кэ в-ам ворбит дин черурь. ");
INSERT INTO ron1924_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Сэ ну фачець думнезей де арӂинт ши думнезей де аур ка сэ-й пунець алэтурь де Мине; сэ ну вэ фачець алць думнезей. ");
INSERT INTO ron1924_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Сэ-Мь ридичь ун алтар де пэмынт, пе каре сэ-ць адучь ардериле-де-тот ши жертфеле де мулцумире, оиле ши боий. Ын орьче лок ын каре Ымь вой адуче аминте де Нумеле Меу, вой вени ла тине ши те вой бинекувынта. ");
INSERT INTO ron1924_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Дакэ-Мь вей ридика ун алтар де пятрэ, сэ ну-л зидешть дин петре чоплите, кэч, кум ыць вей пуне далта ын пятрэ, о вей пынгэри. ");
INSERT INTO ron1924_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Сэ ну те суй ла алтарул Меу пе трепте, ка сэ ну ци се дескопере голичуня ынаинтя луй.’” ");
INSERT INTO ron1924_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","„Ятэ леӂиле пе каре ле вей пуне ынаинтя лор. ");
INSERT INTO ron1924_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Дакэ вей кумпэра ун роб евреу, сэ служяскэ шасе ань ка роб, дар ын ал шаптеля, сэ ясэ слобод, фэрэ сэ плэтяскэ нимик ка деспэгубире. ");
INSERT INTO ron1924_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Дакэ а интрат сингур, сэ ясэ сингур; дакэ ера ынсурат, сэ ясэ ши невастэ-са ымпреунэ ку ел. ");
INSERT INTO ron1924_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Дакэ стэпынул луй й-а дат о невастэ ши а авут фий ши фийче ку еа, неваста ши копиий сэ фие ай стэпынулуй луй, яр ел сэ ясэ сингур. ");
INSERT INTO ron1924_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Дакэ робул ва зиче: ‘Еу юбеск пе стэпынул меу, пе невастэ-мя ши копиий мей ши ну вряу сэ ес слобод’, ");
INSERT INTO ron1924_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","атунч стэпынул луй сэ-л дукэ ынаинтя луй Думнезеу, сэ-л апропие де ушэ сау де стылпул уший ши стэпынул луй сэ-й гэуряскэ урекя ку о сулэ, ши робул сэ рэмынэ пентру тотдяуна ын служба луй. ");
INSERT INTO ron1924_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Дакэ ун ом ышь ва винде фата ка роабэ, еа сэ ну ясэ кум ес робий. ");
INSERT INTO ron1924_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Дакэ ну ва плэчя стэпынулуй ей, каре о луасе де невастэ, ел сэ-й ынлесняскэ рэскумпэраря, дар ну ва авя дрептул с-о вындэ унор стрэинь, дакэ ну-шь ва цине кувынтул. ");
INSERT INTO ron1924_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Дакэ о дэ де невастэ фиулуй сэу, сэ се поарте ку еа дупэ дрептул фийчелор. ");
INSERT INTO ron1924_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Дакэ-й ва луа о алтэ невастэ, ну ва скэдя нимик пентру чя динтый дин хранэ, дин ымбрэкэминте ши дин дрептул ей де социе. ");
INSERT INTO ron1924_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Дакэ ну-й фаче ачесте трей лукрурь, еа ва путя еши фэрэ ничо деспэгубире, фэрэ сэ дя бань. ");
INSERT INTO ron1924_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Чине ва лови пе алтул ку о ловитурэ де моарте сэ фие педепсит ку моартя. ");
INSERT INTO ron1924_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Дакэ ну й-а ынтинс лацурь ши дакэ Думнезеу л-а фэкут сэ-й кадэ ын мынэ, ыць вой хотэры ун лок унде ва путя сэ фугэ. ");
INSERT INTO ron1924_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Дар, дакэ лукрязэ чинева ку рэутате ымпотрива апроапелуй сэу, фолосинду-се де викление ка сэ-л омоаре, кяр ши де ла алтарул Меу сэ-л смулӂь, ка сэ фие оморыт. ");
INSERT INTO ron1924_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Чине ва лови пе татэл сэу сау пе мама са сэ фие педепсит ку моартя. ");
INSERT INTO ron1924_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Чине ва фура ун ом ши-л ва винде сау ыл ва цине ын мыниле луй сэ фие педепсит ку моартя. ");
INSERT INTO ron1924_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Чине ва блестема пе татэл сэу сау пе мама са сэ фие педепсит ку моартя. ");
INSERT INTO ron1924_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Дакэ се вор черта дой оамень, ши унул дин ей ва лови пе челэлалт ку о пятрэ сау ку пумнул, фэрэ сэ-й причинуяскэ моартя, дар силинду-л сэ стя ын пат, ");
INSERT INTO ron1924_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","чел че л-а ловит сэ ну фие педепсит дакэ челэлалт се ва скула ши се ва плимба афарэ, сприжинит пе ун тояг. Нумай сэ-л деспэгубяскэ пентру ынчетаря лукрулуй луй ши сэ-л ынгрижяскэ пынэ ла виндекаре. ");
INSERT INTO ron1924_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Дакэ ун ом ва лови ку бэцул пе робул сэу, фие бэрбат, фие фемее, ши робул моаре суб мына луй, стэпынул сэ фие педепсит. ");
INSERT INTO ron1924_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Дар, дакэ май трэеште о зи сау доуэ, стэпынул сэ ну фие педепсит; кэч есте арӂинтул луй. ");
INSERT INTO ron1924_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Дакэ се чартэ дой оамень ши ловеск пе о фемее ынсэрчинатэ ши о фак доар сэ наскэ ынаинте де време, фэрэ алтэ ненорочире, сэ фие педепсиць ку о глоабэ пусэ де бэрбатул фемеий ши пе каре о вор плэти дупэ хотэрыря жудекэторилор. ");
INSERT INTO ron1924_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Дар, дакэ се ынтымплэ о ненорочире, вей да вяцэ пентру вяцэ, ");
INSERT INTO ron1924_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","окь пентру окь, динте пентру динте, мынэ пентру мынэ, пичор пентру пичор, ");
INSERT INTO ron1924_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","арсурэ пентру арсурэ, ранэ пентру ранэ, вынэтае пентру вынэтае. ");
INSERT INTO ron1924_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Дакэ ун ом ловеште окюл робулуй сэу, фие бэрбат, фие фемее, ши-л фаче сэ-шь пярдэ окюл, сэ-й дя друмул ка деспэгубире пентру окюл луй. ");
INSERT INTO ron1924_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Ши дакэ фаче сэ кадэ ун динте робулуй сэу, фие бэрбат, фие фемее, ка деспэгубире пентру динтеле луй, сэ-й дя друмул. ");
INSERT INTO ron1924_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Дакэ ун боу ва ымпунӂе ши ва оморы пе ун бэрбат сау пе о фемее, боул сэ фие учис ку петре, карня сэ ну и се мэнынче, яр стэпынул боулуй сэ ну фие педепсит. ");
INSERT INTO ron1924_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Дар, дакэ боул авя обичей май ынаинте сэ ымпунгэ ши стэпынул фусесе ынштиинцат де лукрул ачеста ши ну л-а ынкис, боул сэ фие учис ку петре, дакэ ва учиде ун бэрбат сау о фемее, ши стэпынул луй сэ фие педепсит ку моартя. ");
INSERT INTO ron1924_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Дакэ и се пуне стэпынулуй ун прец пентру рэскумпэраря веций луй, ва плэти тот че и се ва чере. ");
INSERT INTO ron1924_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Кынд боул ва ымпунӂе пе ун бэят сау пе о фатэ, и се ва фаче дупэ леӂя ачаста, ");
INSERT INTO ron1924_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","дар, дакэ боул ымпунӂе пе ун роб, фие бэрбат, фие фемее, сэ се дя трей сикли де арӂинт стэпынулуй робулуй, ши боул сэ фие учис ку петре. ");
INSERT INTO ron1924_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Дакэ ун ом дескоперэ о гроапэ сау дакэ ун ом сапэ о гроапэ ши н-о акоперэ ши каде ын еа ун боу сау ун мэгар, ");
INSERT INTO ron1924_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","стэпынул гропий сэ плэтяскэ стэпынулуй лор прецул витей ын арӂинт, яр вита моартэ сэ фие а луй. ");
INSERT INTO ron1924_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Дакэ боул унуй ом ымпунӂе боул унуй алт ом ши боул ачеста моаре, вор винде боул чел виу ши прецул луй ыл вор ымпэрци; вор ымпэрци ши боул морт. ");
INSERT INTO ron1924_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Дар, дакэ се штия кэ боул авя обичей май ынаинте сэ ымпунгэ, ши стэпынул луй ну л-а ынкис, стэпынул ачеста сэ дя боу пентру боу, яр боул чел морт сэ-л я ел. ");
INSERT INTO ron1924_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Дакэ ун ом фурэ ун боу сау о оае ши-л тае сау ыл винде, сэ дя чинч бой пентру боул фурат ши патру ой пентру оая фуратэ. ");
INSERT INTO ron1924_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Дакэ хоцул есте принс спэргынд ши е ловит ши моаре, чел че л-а ловит ну ва фи виноват де омор фацэ де ел; ");
INSERT INTO ron1924_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","дар, дакэ а рэсэрит соареле, ва фи виноват де омор фацэ де ел. Хоцул требуе сэ дя ынапой че есте датор сэ дя; дакэ н-аре нимик, сэ фие вындут роб, ка деспэгубире пентру фуртул луй. ");
INSERT INTO ron1924_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Дакэ чея че а фурат, фие боу, фие мэгар сау оае, се гэсеште ынкэ виу ын мыниле луй, сэ дя ындоит ынапой. ");
INSERT INTO ron1924_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Дакэ чинева фаче стрикэчуне ынтр-ун огор сау ынтр-о вие ши ышь ласэ вита сэ паскэ пе огорул алтуя, сэ дя ка деспэгубире чел май бун род дин огорул ши вия луй. ");
INSERT INTO ron1924_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Дакэ избукнеште ун фок ши ынтылнеште мэрэчинь ын кале ши арде грыул ын снопь сау ын пичоаре сау кымпул, чел че а пус фок сэ фие силит сэ дя о деспэгубире деплинэ. ");
INSERT INTO ron1924_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Дакэ ун ом дэ алтуя бань сау унелте спре пэстраре ши ле фурэ чинева дин каса ачестуя дин урмэ, хоцул требуе сэ ынтоаркэ ындоит, дакэ ва фи гэсит. ");
INSERT INTO ron1924_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Дакэ хоцул ну се гэсеште, стэпынул касей сэ се ынфэцишезе ынаинтя луй Думнезеу ка сэ спунэ кэ н-а пус мына пе авутул апроапелуй сэу. ");
INSERT INTO ron1924_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Ын орьче причинэ де ыншелэчуне ку привире ла ун боу, ун мэгар, о оае, о хайнэ сау ун лукру пердут, деспре каре се ва зиче: ‘Уйте-л!’ – причина амындурор пэрцилор сэ мяргэ пынэ ла Думнезеу; ачела пе каре-л ва осынди Думнезеу требуе сэ ынтоаркэ ындоит апроапелуй сэу. ");
INSERT INTO ron1924_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Дакэ ун ом дэ алтуя ун мэгар, ун боу, о оае сау ун добиток оарекаре сэ и-л пэстрезе ши добитокул моаре, ышь стрикэ ун мэдулар сау е луат ку сила де ла ел, фэрэ сэ фи вэзут чинева, ");
INSERT INTO ron1924_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","сэ се факэ ун журэмынт, ын Нумеле Домнулуй, ынтре челе доуэ пэрць, ши чел че а пэстрат добитокул ва мэртуриси кэ н-а пус мына пе авутул апроапелуй сэу; стэпынул добитокулуй ва прими журэмынтул ачеста, ши челэлалт ну ва фи датор сэ и-л ынлокуяскэ. ");
INSERT INTO ron1924_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Дар, дакэ добитокул а фост фурат де ла ел, ва фи датор фацэ де стэпынул луй сэ и-л ынлокуяскэ. ");
INSERT INTO ron1924_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Дакэ добитокул а фост сфышият де фяре сэлбатиче, ыл ва адуче ка довадэ ши ну ва фи датор сэ-й ынлокуяскэ добитокул сфышият. ");
INSERT INTO ron1924_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Дакэ ун ом ымпрумутэ алтуя о витэ, ши вита ышь стрикэ ун мэдулар сау моаре ын липса стэпынулуй ей, ва требуи с-о плэтяскэ. ");
INSERT INTO ron1924_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Дакэ стэпынул е де фацэ, ну й-о ва плэти. Дакэ вита а фост датэ ку кирие, прецул кирией ва фи де ажунс. ");
INSERT INTO ron1924_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Дакэ ун ом ыншалэ пе о фатэ нелогодитэ ши се кулкэ ку еа, ый ва плэти зестря ши о ва луа де невастэ. ");
INSERT INTO ron1924_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Дакэ татэл ну вря сэ й-о дя, ел ва плэти ын арӂинт прецул зестрей кувените фетелор. ");
INSERT INTO ron1924_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Пе врэжитоаре сэ н-о лашь сэ трэяскэ. ");
INSERT INTO ron1924_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Орьчине се кулкэ ку ун добиток сэ фие педепсит ку моартя. ");
INSERT INTO ron1924_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Чине адуче жертфе алтор думнезей декыт Домнулуй сингур сэ фие нимичит ку десэвыршире. ");
INSERT INTO ron1924_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Сэ ну кинуешть пе стрэин ши сэ ну-л асупрешть, кэч ши вой аць фост стрэинь ын цара Еӂиптулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Сэ ну асупрешть пе вэдувэ, нич пе орфан. ");
INSERT INTO ron1924_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Дакэ-й асупрешть, ши ей стригэ ла Мине дупэ ажутор, Еу ле вой аузи стригэтеле; ");
INSERT INTO ron1924_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","мыния Мя се ва апринде ши вэ вой нимичи ку сабия; невестеле воастре вор рэмыне вэдуве ши копиий воштри вор рэмыне орфань. ");
INSERT INTO ron1924_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Дакэ ымпрумуць бань вреунуя дин попорул Меу, сэракулуй каре есте ку тине, сэ ну фий фацэ де ел ка ун кэмэтар ши сэ ну черь камэтэ де ла ел. ");
INSERT INTO ron1924_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Дакэ ей зэлог хайна апроапелуй тэу, сэ й-о дай ынапой ынаинте де апусул соарелуй, ");
INSERT INTO ron1924_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","кэч есте сингура луй ынвелитоаре, есте хайна ку каре ышь ынвелеште трупул – ку че аре сэ се кулче? Дакэ стригэ спре Мине дупэ ажутор, Еу ыл вой аузи, кэч Еу сунт милостив. ");
INSERT INTO ron1924_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Сэ ну хулешть пе Думнезеу ши сэ ну блестемь пе май-мареле попорулуй тэу. ");
INSERT INTO ron1924_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Сэ ну преӂець сэ-Мь адучь пырга сечеришулуй тэу ши а кулесулуй вией тале. Сэ-Мь дай пе ынтыюл нэскут дин фиий тэй. ");
INSERT INTO ron1924_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Сэ-Мь дай ши ынтыюл нэскут ал вачий тале ши ал оий тале; сэ рэмынэ шапте зиле ку мама са, яр ын зиуа а опта сэ Ми-л адучь. ");
INSERT INTO ron1924_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Сэ-Мь фиць ниште оамень сфинць. Сэ ну мынкаць карне сфышиятэ де фяре пе кымп, чи с-о арункаць ла кынь. ");
INSERT INTO ron1924_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Сэ ну рэспындешть звонурь неадевэрате. Сэ ну те унешть ку чел рэу, ка сэ фачь о мэртурисире минчиноасэ пентру ел. ");
INSERT INTO ron1924_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Сэ ну те ей дупэ мулциме ка сэ фачь рэу ши ла жудекатэ сэ ну мэртурисешть трекынд де партя челор мулць, ка сэ абаць дрептатя. ");
INSERT INTO ron1924_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Сэ ну пэртинешть пе сэрак ла жудекатэ. ");
INSERT INTO ron1924_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Дакэ ынтылнешть боул врэжмашулуй тэу сау мэгарул луй рэтэчит, сэ и-л адучь акасэ. ");
INSERT INTO ron1924_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Дакэ везь мэгарул врэжмашулуй тэу кэзут суб повара луй, сэ ну тречь пе лынгэ ел, чи сэ-й ажуць сэ я повара де пе мэгар. ");
INSERT INTO ron1924_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Ла жудекатэ, сэ ну те атинӂь де дрептул сэракулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Фереште-те де о ынвинуире недряптэ ши сэ ну оморь пе чел невиноват ши пе чел дрепт, кэч ну вой ерта пе чел виноват. ");
INSERT INTO ron1924_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Сэ ну примешть дарурь, кэч даруриле орбеск пе чей че ау окий дескишь ши суческ хотэрыриле челор дрепць. ");
INSERT INTO ron1924_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Сэ ну асупрешть пе стрэин; штиць че симте стрэинул, кэч ши вой аць фост стрэинь ын цара Еӂиптулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Тимп де шасе ань, сэ семень пэмынтул ши сэ-й стрынӂь родул. ");
INSERT INTO ron1924_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Дар ын ал шаптеля, сэ-й дай рэгаз ши сэ-л лашь сэ се одихняскэ; дин родул луй сэ мэнынче сэрачий попорулуй тэу, яр че ва май рэмыне сэ мэнынче фяреле де пе кымп. Тот аша сэ фачь ку вия ши мэслиний тэй. ");
INSERT INTO ron1924_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Тимп де шасе зиле сэ-ць фачь лукраря. Дар ын зиуа а шаптя сэ те одихнешть, пентру ка боул ши мэгарул тэу сэ айбэ одихнэ, пентру ка фиул роабей тале ши стрэинул сэ айбэ рэгаз ши сэ рэсуфле. ");
INSERT INTO ron1924_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Сэ пэзиць тот че в-ам спус ши сэ ну ростиць нумеле алтор думнезей: нумеле лор сэ ну се аудэ ешинд дин гура воастрэ. ");
INSERT INTO ron1924_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Де трей орь пе ан сэ прэзнуешть сэрбэторь ын чинстя Мя. ");
INSERT INTO ron1924_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Сэ ций Сэрбэтоаря Азимилор; тимп де шапте зиле, ла время хотэрытэ, ын луна спичелор, сэ мэнынчь азиме, кум ць-ам порунчит – кэч ын луна ачаста ай ешит дин Еӂипт – ши сэ ну вий ку мыниле гоале ынаинтя Мя. ");
INSERT INTO ron1924_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Сэ ций Сэрбэтоаря Сечеришулуй, а челор динтый роаде дин мунка та, дин чея че вей семэна пе кымп; ши сэ ций Сэрбэтоаря Стрынӂерий Роаделор, ла сфыршитул анулуй, кынд вей стрынӂе де пе кымп родул мунчий тале. ");
INSERT INTO ron1924_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Де трей орь пе ан, тоатэ партя бэрбэтяскэ сэ се ынфэцишезе ынаинтя Домнулуй Думнезеу. ");
INSERT INTO ron1924_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Сэ н-адучь ку пыне доспитэ сынӂеле жертфей Меле; ши грэсимя празникулуй Меу сэ ну рэмынэ тоатэ ноаптя пынэ диминяца. ");
INSERT INTO ron1924_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Сэ адучь ын каса Домнулуй Думнезеулуй тэу пырга челор динтый роаде але пэмынтулуй. Сэ ну фербь ун ед ын лаптеле мамей луй. ");
INSERT INTO ron1924_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Ятэ, Еу тримит ун Ынӂер ынаинтя та, ка сэ те окротяскэ пе друм ши сэ те дукэ ын локул пе каре л-ам прегэтит. ");
INSERT INTO ron1924_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Фий ку окий ын патру ынаинтя Луй ши аскултэ гласул Луй; сэ ну те ымпотривешть Луй, пентру кэ ну вэ ва ерта пэкателе, кэч Нумеле Меу есте ын Ел. ");
INSERT INTO ron1924_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Дар, дакэ вей аскулта гласул Луй ши дакэ вей фаче тот че-ць вой спуне, Еу вой фи врэжмашул врэжмашилор тэй ши потривникул потривничилор тэй. ");
INSERT INTO ron1924_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Ынӂерул Меу ва мерӂе ынаинтя та ши те ва дуче ла амориць, хетиць, ферезиць, канааниць, хевиць ши иебусиць ши-й вой нимичи. ");
INSERT INTO ron1924_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Сэ ну те ынкинь ынаинтя думнезеилор лор ши сэ ну ле служешть; сэ ну те ей дупэ попоареле ачестя ын пуртаря лор, чи сэ ле нимичешть ку десэвыршире ши сэ ле дэрымь капиштиле. ");
INSERT INTO ron1924_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Вой сэ служиць Домнулуй Думнезеулуй востру, ши Ел вэ ва бинекувынта пыня ши апеле ши ва депэрта боала дин мижлокул тэу. ");
INSERT INTO ron1924_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Ну ва фи ын цара та нич фемее каре сэ-шь лепеде копилул, нич фемее стярпэ. Нумэрул зилелор тале ыл вой фаче сэ фие деплин. ");
INSERT INTO ron1924_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Вой тримите гроаза Мя ынаинтя та, вой пуне пе фугэ пе тоате попоареле ла каре вей ажунӂе ши вой фаче ка тоць врэжмаший тэй сэ дя досул ынаинтя та. ");
INSERT INTO ron1924_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Вой тримите веспиле бондэрешть ынаинтя та ши вор изгони динаинтя та пе хевиць, канааниць ши хетиць. ");
INSERT INTO ron1924_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Ну-й вой изгони ынтр-ун сингур ан динаинтя та, пентру ка цара сэ н-ажунгэ ун пустиу ши сэ ну се ынмулцяскэ ымпотрива та фяреле де пе кымп. ");
INSERT INTO ron1924_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Чи ле вой изгони ынчетул ку ынчетул динаинтя та, пынэ вей креште ла нумэр ши вей путя сэ интри ын стэпыниря цэрий. ");
INSERT INTO ron1924_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Ыць вой ынтинде хотареле де ла Маря Рошие пынэ ла маря филистенилор ши де ла пустиу пынэ ла рыу (Еуфрат). Кэч вой да ын мыниле воастре пе локуиторий цэрий ши-й вей изгони динаинтя та. ");
INSERT INTO ron1924_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Сэ ну фачь легэмынт ку ей, нич ку думнезеий лор. ");
INSERT INTO ron1924_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Ей сэ ну локуяскэ ын цара та, ка сэ ну те факэ сэ пэкэтуешть ымпотрива Мя, кэч атунч ай служи думнезеилор лор, ши ачаста ар фи о курсэ пентру тине.” ");
INSERT INTO ron1924_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Думнезеу а зис луй Мойсе: „Суе-те ла Домнул, ту ши Аарон, Надаб ши Абиху ши шаптезечь де бэтрынь ай луй Исраел ши сэ вэ ынкинаць де департе, арункынду-вэ ку фаца ла пэмынт. ");
INSERT INTO ron1924_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Нумай Мойсе сэ се апропие де Домнул; чейлалць сэ ну се апропие ши попорул сэ ну се суе ку ел.” ");
INSERT INTO ron1924_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Мойсе а венит ши а спус попорулуй тоате кувинтеле Домнулуй ши тоате леӂиле. Тот попорул а рэспунс ынтр-ун глас: „Вом фаче тот че а зис Домнул.” ");
INSERT INTO ron1924_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Мойсе а скрис тоате кувинтеле Домнулуй. Апой с-а скулат дис-де-диминяцэ, а зидит ун алтар ла поалеле мунтелуй ши а ридикат доуэспрезече петре пентру челе доуэспрезече семинций але луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","А тримис пе ниште тинерь динтре копиий луй Исраел, сэ адукэ Домнулуй ардерь-де-тот ши сэ ынжунгие таурь ка жертфе де мулцумире. ");
INSERT INTO ron1924_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Мойсе а луат жумэтате дин сынӂе ши л-а пус ын стрэкинь, яр чялалтэ жумэтате а стропит-о пе алтар. ");
INSERT INTO ron1924_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","А луат картя легэмынтулуй ши а читит-о ын фаца попорулуй. Ей ау зис: „Вом фаче ши вом аскулта тот че а зис Домнул.” ");
INSERT INTO ron1924_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Мойсе а луат сынӂеле ши а стропит попорул, зикынд: „Ятэ сынӂеле легэмынтулуй пе каре л-а фэкут Домнул ку вой пе темеюл тутурор ачестор кувинте.” ");
INSERT INTO ron1924_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Мойсе с-а суит ымпреунэ ку Аарон, Надаб ши Абиху ши ку шаптезечь де бэтрынь ай луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Ей ау вэзут пе Думнезеул луй Исраел; суб пичоареле Луй ера ун фел де лукраре де сафир стрэвезиу, ынтокмай ка черул ын курэция луй. ");
INSERT INTO ron1924_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Ел ну Шь-а ынтинс мына ымпотрива алешилор копиилор луй Исраел. Ей ау вэзут пе Думнезеу, ши тотушь ау мынкат ши ау бэут. ");
INSERT INTO ron1924_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Домнул а зис луй Мойсе: „Суе-те ла Мине пе мунте ши рэмый аколо. Еу ыць вой да ниште табле де пятрэ ку Леӂя ши порунчиле пе каре ле-ам скрис пентру ынвэцэтура лор.” ");
INSERT INTO ron1924_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Мойсе с-а скулат, ымпреунэ ку Иосуа, каре-й служя, ши Мойсе с-а суит пе мунтеле луй Думнезеу. ");
INSERT INTO ron1924_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Ел а зис бэтрынилор: „Аштептаци-не аич пынэ не вом ынтоарче ла вой. Ятэ, Аарон ши Хур вор рэмыне ку вой; дакэ ва авя чинева врео неынцелеӂере, сэ мяргэ ла ей.” ");
INSERT INTO ron1924_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Мойсе с-а суит пе мунте, ши норул а акоперит мунтеле. ");
INSERT INTO ron1924_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Слава Домнулуй с-а ашезат пе мунтеле Синай ши норул л-а акоперит тимп де шасе зиле. Ын зиуа а шаптя, Домнул а кемат пе Мойсе дин мижлокул норулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Ынфэцишаря славей Домнулуй ера ка ун фок мистуитор пе вырфул мунтелуй, ынаинтя копиилор луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Мойсе а интрат ын мижлокул норулуй ши с-а суит пе мунте. Мойсе а рэмас пе мунте патрузечь де зиле ши патрузечь де нопць. ");
INSERT INTO ron1924_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","„Ворбеште копиилор луй Исраел сэ-Мь адукэ ун дар; сэ-л примиць пентру Мине де ла орьче ом каре-л ва да ку траӂере де инимэ. ");
INSERT INTO ron1924_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Ятэ че вець прими де ла ей ка дар: аур, арӂинт ши арамэ; ");
INSERT INTO ron1924_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","материй вопсите ын албастру, пурпуриу, кэрэмизиу, пынзэ де ин субцире ши пэр де капрэ; ");
INSERT INTO ron1924_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","пей де бербек вопсите ын рошу ши пей де вицел де маре; лемн де салкым; ");
INSERT INTO ron1924_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","унтделемн пентру сфешник, миродений пентру унтделемнул унӂерий ши пентру тэмыя мироситоаре; ");
INSERT INTO ron1924_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","петре де оникс ши алте петре пентру ефод (умэрар) ши пептар. ");
INSERT INTO ron1924_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Сэ-Мь факэ ун локаш сфынт, ши Еу вой локуи ын мижлокул лор. ");
INSERT INTO ron1924_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Сэ фачець кортул ши тоате васеле луй дупэ кипул пе каре ци-л вой арэта. ");
INSERT INTO ron1924_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Сэ факэ ун кивот де лемн де салкым; лунӂимя луй сэ фие де дой коць ши жумэтате, лэцимя, де ун кот ши жумэтате ши ынэлцимя, де ун кот ши жумэтате. ");
INSERT INTO ron1924_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Сэ-л полеешть ку аур курат, сэ-л полеешть пе динэунтру ши пе динафарэ ши сэ-й фачь ун кенар де аур де жур ымпрежур. ");
INSERT INTO ron1924_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Сэ торнь пентру ел патру вериӂь де аур ши сэ ле пуй ла челе патру колцурь але луй: доуэ вериӂь де о парте ши доуэ вериӂь де чялалтэ парте. ");
INSERT INTO ron1924_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Сэ фачь ниште друӂь де лемн де салкым ши сэ-й полеешть ку аур. ");
INSERT INTO ron1924_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Сэ вырь друӂий ын вериӂиле де пе латуриле кивотулуй, ка сэ служяскэ ла дучеря кивотулуй; ");
INSERT INTO ron1924_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","друӂий вор рэмыне ын вериӂиле кивотулуй ши ну вор фи скошь дин еле. ");
INSERT INTO ron1924_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Сэ пуй ын кивот мэртурия пе каре ць-о вой да. ");
INSERT INTO ron1924_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Сэ фачь ун капак ал испэширий дин аур курат; лунӂимя луй сэ фие де дой коць ши жумэтате ши лэцимя луй, де ун кот ши жумэтате. ");
INSERT INTO ron1924_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Сэ фачь дой херувимь де аур, сэ-й фачь де аур бэтут ла челе доуэ капете але капакулуй испэширий; ");
INSERT INTO ron1924_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","сэ фачь ун херувим ла ун капэт ши ун херувим ла челэлалт капэт; сэ фачець херувимий ачештя ешинд дин капакул испэширий ла челе доуэ капете але луй. ");
INSERT INTO ron1924_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Херувимий сэ фие ку арипиле ынтинсе пе дясупра, акоперинд ку арипиле лор капакул испэширий, ши ку фецеле ынтоарсе уна спре алта; херувимий сэ айбэ фаца ынтоарсэ спре капакул испэширий. ");
INSERT INTO ron1924_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Сэ пуй капакул испэширий пе кивот ши ын кивот сэ пуй мэртурия пе каре ць-о вой да. ");
INSERT INTO ron1924_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Аколо Мэ вой ынтылни ку тине; ши де ла ынэлцимя капакулуй испэширий, динтре чей дой херувимь ашезаць пе кивотул мэртурией, ыць вой да тоате порунчиле Меле пентру копиий луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Сэ фачь о масэ де лемн де салкым; лунӂимя ей сэ фие де дой коць; лэцимя, де ун кот ши ынэлцимя, де ун кот ши жумэтате. ");
INSERT INTO ron1924_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","С-о полеешть ку аур курат ши сэ-й фачь ун кенар де аур де жур ымпрежур. ");
INSERT INTO ron1924_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Сэ-й фачь ымпрежур ун перваз де ун лат де мынэ; песте ел сэ пуй ун кенар де аур де жур ымпрежур. ");
INSERT INTO ron1924_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Сэ фачь пентру масэ патру вериӂь де аур ши сэ пуй вериӂиле ын челе патру колцурь, каре вор фи ла челе патру пичоаре але ей. ");
INSERT INTO ron1924_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Вериӂиле сэ фие лынгэ перваз, ши ын еле се вор выры друӂий, ка сэ дукэ маса. ");
INSERT INTO ron1924_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Друӂий сэ-й фачь дин лемн де салкым ши сэ-й акоперь ку аур, ши ей вор служи ла дучеря месей. ");
INSERT INTO ron1924_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Сэ-й фачь фарфурий, кэцуй, потире ши чешть, ка сэ служяскэ ла жертфеле де бэутурэ: сэ ле фачь де аур курат. ");
INSERT INTO ron1924_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Сэ пуй пе масэ пыниле пентру пунеря ынаинте, ка сэ фие некурмат ынаинтя Мя. ");
INSERT INTO ron1924_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Сэ фачь ун сфешник де аур курат; сфешникул ачеста сэ фие фэкут де аур бэтут: пичорул, фусул, потирашеле, гэмэлиоареле ши флориле луй сэ фие динтр-о букатэ. ");
INSERT INTO ron1924_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Дин латуриле луй сэ ясэ шасе браце; трей браце але сфешникулуй динтр-о парте ши трей браце але сфешникулуй дин чялалтэ парте. ");
INSERT INTO ron1924_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Пе ун брац сэ фие трей потираше ын кип де флоаре де мигдал, ку гэмэлиоареле ши флориле лор, ши пе челэлалт брац, трей потираше ын кип де флоаре де мигдал, ку гэмэлиоареле ши флориле лор; тот аша сэ фие ши челе шасе браце каре ес дин сфешник. ");
INSERT INTO ron1924_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Пе фусул сфешникулуй, сэ фие патру потираше ын кип де флоаре де мигдал, ку гэмэлиоареле ши флориле лор. ");
INSERT INTO ron1924_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Сэ фие о гэмэлиоарэ суб челе доуэ браце каре ес дин фусул сфешникулуй, о гэмэлиоарэ суб алте доуэ браце ши о гэмэлиоарэ суб алте доуэ браце; тот аша сэ фие ши суб челе шасе браце каре ес дин сфешник. ");
INSERT INTO ron1924_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Гэмэлиоареле ши брацеле сфешникулуй сэ фие динтр-о сингурэ букатэ; тотул сэ фие де аур бэтут, де аур курат. ");
INSERT INTO ron1924_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Сэ фачь челе шапте канделе, каре вор фи пусе дясупра, аша ка сэ луминезе ын фацэ. ");
INSERT INTO ron1924_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Мукэриле ши ченушареле луй сэ фие де аур курат. ");
INSERT INTO ron1924_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Се ва ынтребуинца ун талант де аур курат пентру фачеря сфешникулуй ку тоате унелтеле луй. ");
INSERT INTO ron1924_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Везь сэ фачь дупэ кипул каре ци с-а арэтат пе мунте. ");
INSERT INTO ron1924_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Кортул сэ-л фачь дин зече ковоаре де ин субцире рэсучит ши дин материй вопсите ын албастру, пурпуриу ши кэрэмизиу; пе ел сэ фачь херувимь лукраць ку мэестрие. ");
INSERT INTO ron1924_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Лунӂимя унуй ковор сэ фие де доуэзечь ши опт де коць, яр лэцимя унуй ковор сэ фие де патру коць; тоате ковоареле сэ айбэ ачеяшь мэсурэ. ");
INSERT INTO ron1924_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Чинч динтре ачесте ковоаре сэ фие принсе ымпреунэ, яр челелалте чинч ковоаре сэ фие, де асеменя, принсе ымпреунэ. ");
INSERT INTO ron1924_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Ла марӂиня коворулуй ку каре се сфыршеште чя динтый ымпреунаре де ковоаре, сэ фачь ниште киоторь албастре; тот аша сэ фачь ши ла марӂиня коворулуй ку каре се сфыршеште а доуа ымпреунаре де ковоаре. ");
INSERT INTO ron1924_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Ла чел динтый ковор сэ фачь чинчзечь де киоторь, яр ла марӂиня коворулуй ку каре се сфыршеште а доуа ымпреунаре де ковоаре сэ фачь тот чинчзечь де киоторь. Киоториле ачестя сэ се потривяскэ унеле ку алтеле ши сэ винэ фацэ ын фацэ. ");
INSERT INTO ron1924_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Апой сэ фачь чинчзечь де копчь де аур ши ку копчиле ачестя сэ принзь ковоареле унул де алтул, аша ынкыт кортул сэ алкэтуяскэ ун ынтрег. ");
INSERT INTO ron1924_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Сэ май фачь ниште ковоаре де пэр де капрэ, ка сэ служяскэ де акопериш песте корт; сэ фачь унспрезече ковоаре де ачестя. ");
INSERT INTO ron1924_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Лунӂимя фиекэруй ковор сэ фие де трейзечь де коць ши лэцимя фиекэруй ковор сэ фие де патру коць; тоате челе унспрезече ковоаре сэ айбэ ачеяшь мэсурэ. ");
INSERT INTO ron1924_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Пе чинч динтре ачесте ковоаре сэ ле леӂь ымпреунэ деосебит ши пе челелалте шасе деосебит, яр пе ал шаселя ковор сэ-л ындоешть ын фаца кортулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Сэ пуй апой чинчзечь де киоторь ла марӂиня коворулуй ку каре се сфыршеште чя динтый ымпреунаре де ковоаре ши чинчзечь де киоторь ла марӂиня коворулуй ку каре се сфыршеште а доуа ымпреунаре де ковоаре. ");
INSERT INTO ron1924_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Сэ фачь чинчзечь де копчь де арамэ ши сэ пуй копчиле ын киоторь. Сэ ымпреунь астфел акоперишул кортулуй, аша ынкыт сэ алкэтуяскэ ун ынтрег. ");
INSERT INTO ron1924_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Фииндкэ ва май трече чева дин ковоареле акоперишулуй кортулуй, жумэтате дин че трече динтр-ун ковор сэ акопере партя динапой а кортулуй, ");
INSERT INTO ron1924_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","яр че май трече дин лунӂимя челорлалте ковоаре але акоперишулуй кортулуй сэ кадэ кыте ун кот де о парте ши ун кот де чялалтэ парте, песте челе доуэ латурь але кортулуй, аша ынкыт сэ ле акопере. ");
INSERT INTO ron1924_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Сэ май фачь апой пентру акоперишул кортулуй о ынвелитоаре дин пей де бербечь вопсите ын рошу ши песте еа о ынвелитоаре де пей де вицел де маре. ");
INSERT INTO ron1924_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Апой сэ фачь ниште скындурь пентру корт; скындуриле ачестя сэ фие дин лемн де салкым, пусе ын пичоаре. ");
INSERT INTO ron1924_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Лунӂимя фиекэрей скындурь сэ фие де зече коць ши лэцимя фиекэрей скындурь сэ фие де ун кот ши жумэтате. ");
INSERT INTO ron1924_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Фиекаре скындурэ сэ айбэ доуэ урекь уните уна ку алта; аша сэ фачь ла тоате скындуриле кортулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Сэ фачь доуэзечь де скындурь пентру корт ынспре латура де мязэзи. ");
INSERT INTO ron1924_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Суб челе доуэзечь де скындурь, сэ пуй патрузечь де пичоаре де арӂинт, кыте доуэ пичоаре суб фиекаре скындурэ пентру челе доуэ урекь але ей. ");
INSERT INTO ron1924_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Пентру а доуа латурэ а кортулуй, латура де мязэноапте, де асеменя, сэ фачь доуэзечь де скындурь, ");
INSERT INTO ron1924_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","ымпреунэ ку челе патрузечь де пичоаре де арӂинт але лор: кыте доуэ пичоаре суб фиекаре скындурэ. ");
INSERT INTO ron1924_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Пентру фундул кортулуй, ынспре латура де апус, сэ фачь шасе скындурь. ");
INSERT INTO ron1924_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Сэ май фачь доуэ скындурь пентру унгюриле дин фундул кортулуй; ");
INSERT INTO ron1924_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","сэ фие кыте доуэ ла ун лок, ынчепынд де жос, ши бине легате ла вырф ку ун черк; амындоуэ ачесте скындурь, каре сунт пусе ын челе доуэ унгюрь, сэ фие ла фел. ");
INSERT INTO ron1924_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Вор фи астфел опт скындурь, ку пичоареле лор де арӂинт, адикэ шайспрезече пичоаре, кыте доуэ пичоаре суб фиекаре скындурэ. ");
INSERT INTO ron1924_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Сэ фачь апой чинч друӂь де лемн де салкым пентру скындуриле унея дин пэрциле кортулуй, ");
INSERT INTO ron1924_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","чинч друӂь пентру скындуриле дин а доуа парте а кортулуй ши чинч друӂь пентру скындуриле дин партя дин фундул кортулуй динспре апус. ");
INSERT INTO ron1924_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Другул де ла мижлок сэ ажунгэ де ла ун капэт ла челэлалт ал скындурилор. ");
INSERT INTO ron1924_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Сэ полеешть скындуриле ку аур ши вериӂиле ын каре вор интра друӂий сэ ле фачь де аур, яр друӂий сэ-й полеешть тот ку аур. ");
INSERT INTO ron1924_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Кортул сэ-л фачь дупэ кипул каре ци с-а арэтат пе мунте. ");
INSERT INTO ron1924_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Сэ фачь апой о пердя албастрэ, пурпурие ши кэрэмизие ши де ин субцире рэсучит; сэ фие лукратэ ку мэестрие ши сэ айбэ пе еа херувимь. ");
INSERT INTO ron1924_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","С-о принзь де патру стылпь де салкым полеиць ку аур; стылпий ачештя сэ айбэ ниште кырлиӂе де аур ши сэ стя пе патру пичоаре де арӂинт. ");
INSERT INTO ron1924_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Сэ атырнь пердяуа де копчь, ши ын досул перделей сэ вырь кивотул мэртурией: пердяуа сэ факэ деспэрциря ынтре Локул Сфынт ши Локул Прясфынт. ");
INSERT INTO ron1924_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Сэ пуй капакул испэширий пе кивотул мэртурией, ын Локул Прясфынт. ");
INSERT INTO ron1924_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Маса с-о пуй динкоаче де пердя ши сфешникул ын фаца месей, ын партя динспре мязэзи а кортулуй, яр маса с-о пуй ынспре партя де мязэноапте. ");
INSERT INTO ron1924_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Ла интраря кортулуй, сэ май фачь о пердя албастрэ, пурпурие ши кэрэмизие ши де ин субцире рэсучит; ачаста сэ фие о лукраре де кусэтурэ ла гергеф. ");
INSERT INTO ron1924_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Пентру пердяуа ачаста сэ фачь чинч стылпь де салкым ши сэ-й ымбрачь ку аур; стылпий ачештя сэ айбэ кырлиӂе де аур ши сэ торнь пентру ей чинч пичоаре де арамэ. ");
INSERT INTO ron1924_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Алтарул сэ-л фачь дин лемн де салкым; лунӂимя луй сэ фие де чинч коць ши лэцимя луй, де чинч коць. Алтарул сэ фие ын патру колцурь ши ынэлцимя луй сэ фие де чинч коць. ");
INSERT INTO ron1924_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Ын челе патру колцурь, сэ фачь ниште коарне каре сэ фие динтр-о букатэ ку алтарул ши сэ-л акоперь ку арамэ. ");
INSERT INTO ron1924_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Сэ фачь пентру алтар оале де скос ченуша, лопець, лигене, фуркулице ши тигэй пентру кэрбунь; тоате унелтеле луй сэ ле фачь де арамэ. ");
INSERT INTO ron1924_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Сэ фачь алтарулуй ун грэтар де арамэ, ын кип де реця, ши сэ пуй патру вериӂь де арамэ ла челе патру колцурь але рецелей. ");
INSERT INTO ron1924_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Грэтарул сэ-л пуй суб стряшина алтарулуй, ынчепынд де жос, аша кэ грэтарул сэ винэ пынэ ла жумэтатя алтарулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Сэ фачь апой ниште друӂь пентру алтар, друӂь де лемн де салкым, ши сэ-й акоперь ку арамэ. ");
INSERT INTO ron1924_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Сэ вырь друӂий ын вериӂь, ши друӂий сэ фие де амындоуэ пэрциле алтарулуй кынд ыл вор пурта. ");
INSERT INTO ron1924_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Сэ-л фачь дин скындурь ши гол пе динэунтру. Сэ фие фэкут аша кум ци с-а арэтат пе мунте. ");
INSERT INTO ron1924_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Куртя кортулуй с-о фачь астфел. Ынспре партя де мязэзи, пентру алкэтуиря курций, сэ фие ниште пынзе де ин субцире, рэсучит, пе о лунӂиме де о сутэ де коць пентру ачастэ примэ латурэ, ");
INSERT INTO ron1924_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","ку доуэзечь де стылпь, каре сэ стя пе доуэзечь де пичоаре де арамэ; кырлиӂеле стылпилор ши бецеле лор де легэтурэ сэ фие де арӂинт. ");
INSERT INTO ron1924_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Ынспре партя де мязэноапте, сэ фие, де асеменя, ниште пынзе пе о лунӂиме де о сутэ де коць, ку доуэзечь де стылпь ши ку челе доуэзечь де пичоаре але лор де арамэ; кырлиӂеле стылпилор ши бецеле лор де легэтурэ сэ фие де арӂинт. ");
INSERT INTO ron1924_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Ынспре партя де апус, сэ фие пентру лэцимя курций ниште пынзе де чинчзечь де коць, ку зече стылпь ши челе зече пичоаре але лор. ");
INSERT INTO ron1924_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Ынспре партя де рэсэрит, пе лынгэ чей чинчзечь де коць пентру лэцимя курций, ");
INSERT INTO ron1924_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","сэ май фие чинчспрезече коць де пынзэ пентру о арипэ, ку трей стылпь ши челе трей пичоаре але лор, ");
INSERT INTO ron1924_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","ши чинчспрезече коць де пынзэ пентру а доуа арипэ, ку трей стылпь ши челе трей пичоаре але лор. ");
INSERT INTO ron1924_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Пентру поарта курций кортулуй, сэ фие о пердя латэ де доуэзечь де коць, албастрэ, пурпурие ши кэрэмизие ши де ин субцире рэсучит, лукратэ ла гергеф, ку патру стылпь ши челе патру пичоаре але лор. ");
INSERT INTO ron1924_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Тоць стылпий курций де жур ымпрежур сэ айбэ беце де легэтурэ де арӂинт, кырлиӂе де арӂинт ши пичоаре де арамэ. ");
INSERT INTO ron1924_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Лунӂимя курций сэ фие де о сутэ де коць; лэцимя, де чинчзечь де коць де фиекаре парте ши ынэлцимя, де чинч коць; пынзеле сэ фие де ин субцире рэсучит, яр пичоареле сэ фие де арамэ. ");
INSERT INTO ron1924_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Тоате унелтеле рындуите пентру служба кортулуй, тоць цэруший луй ши тоць цэруший курций сэ фие де арамэ. ");
INSERT INTO ron1924_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Сэ порунчешть копиилор луй Исраел сэ-ць адукэ пентру сфешник унтделемн курат де мэслине, фэрэ дрождий, ка сэ ардэ ын канделе некурмат. ");
INSERT INTO ron1924_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Аарон ши фиий сэй сэ-л прегэтяскэ ын кортул ынтылнирий, динкоаче де пердяуа каре есте ынаинтя кивотулуй мэртурией, пентру ка сэ ардэ де сяра пынэ диминяца ынаинтя Домнулуй. Ачаста есте о леӂе вешникэ пентру урмаший лор ши пе каре копиий луй Исраел вор требуи с-о цинэ. ");
INSERT INTO ron1924_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Апропие де тине пе фрателе тэу, Аарон, ши пе фиий сэй ши я-й динтре копиий луй Исраел ши пуне-й деопарте ын служба Мя ка преоць: пе Аарон ши пе фиий луй Аарон: Надаб, Абиху, Елеазар ши Итамар. ");
INSERT INTO ron1924_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Фрателуй тэу, Аарон, сэ-й фачь хайне сфинте, ка сэ-й служяскэ де чинсте ши подоабэ. ");
INSERT INTO ron1924_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Ворбеште ку тоць чей дестойничь, кэрора ле-ам дат ун дух де причепере, сэ факэ вешминтеле луй Аарон ка сэ фие сфинцит ши сэ-Мь ымплиняскэ служба де преот. ");
INSERT INTO ron1924_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Ятэ вешминтеле пе каре ле вор фаче: ун пептар, ун ефод, о мантие, о туникэ лукратэ ла гергеф, о митрэ ши ун брыу. Сэ факэ фрателуй тэу, Аарон, ши фиилор сэй вешминте сфинте, ка сэ-Мь ымплиняскэ служба де преот. ");
INSERT INTO ron1924_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Сэ ынтребуинцезе аур, материй вопсите ын албастру, ын пурпуриу, ын кэрэмизиу ши ин субцире. ");
INSERT INTO ron1924_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Ефодул сэ-л факэ дин аур, дин фир албастру, пурпуриу ши кэрэмизиу ши дин ин субцире рэсучит; сэ фие лукрат ку мэестрие. ");
INSERT INTO ron1924_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Сэ айбэ дой умэрарь униць ку ел; ла челе доуэ капете але луй, сэ фие легат де ей. ");
INSERT INTO ron1924_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Брыул сэ фие де ачеяшь лукрэтурэ ка ефодул ши принс пе ел; сэ фие де аур, де фир албастру, пурпуриу ши кэрэмизиу ши де ин субцире рэсучит. ");
INSERT INTO ron1924_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Сэ ей апой доуэ петре де оникс ши сэ сапь пе еле нумеле фиилор луй Исраел: ");
INSERT INTO ron1924_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","шасе дин нумеле лор пе о пятрэ ши алте шасе пе а доуа пятрэ, дупэ ширул наштерилор. ");
INSERT INTO ron1924_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Пе челе доуэ петре сэ сапь нумеле фиилор луй Исраел, кум се фаче сэпэтура пе петре ши пе печець; сэ ле леӂь ынтр-о ферекэтурэ де аур. ");
INSERT INTO ron1924_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Амындоуэ ачесте петре сэ ле пуй пе умэрарий ефодулуй, ка адучере аминте де фиий луй Исраел, ши Аарон ле ва пурта нумеле ынаинтя Домнулуй, пе чей дой умерь ай луй, ка адучере аминте де ей. ");
INSERT INTO ron1924_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Сэ фачь апой ниште ферекэтурь де аур ");
INSERT INTO ron1924_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","ши доуэ лэнцишоаре де аур курат, пе каре сэ ле ымплетешть ын кип де сфорь, ши ланцуриле ачестя, ымплетите астфел, сэ ле пуй ын ферекэтурь. ");
INSERT INTO ron1924_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Сэ фачь апой пептарул жудекэций, лукрат ку мэестрие, сэ-л фачь дин ачеяшь лукрэтурэ ка ефодул; сэ-л фачь дин аур, дин фир албастру, пурпуриу ши кэрэмизиу ши дин ин субцире рэсучит. ");
INSERT INTO ron1924_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Сэ фие ын патру колцурь ши ындоит; лунӂимя луй сэ фие де о палмэ ши лэцимя, тот де о палмэ. ");
INSERT INTO ron1924_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Ын ел сэ цешь о цесэтурэ де петре, ши ануме патру рындурь де петре: ын рындул ынтый, ун сардоникс, ун топаз ши ун смаралд; ");
INSERT INTO ron1924_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","ын ал дойля рынд, ун рубин, ун сафир ши ун диамант; ");
INSERT INTO ron1924_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","ын ал трейля рынд, ун опал, ун агат ши ун аметист; ");
INSERT INTO ron1924_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","ын ал патруля рынд, ун крисолит, ун оникс ши ун яспис. Ачесте петре сэ фие легате ын ферекэтура лор де аур. ");
INSERT INTO ron1924_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Сэ фие доуэспрезече, дупэ нумеле фиилор луй Исраел, сэпате ка ниште печець, фиекаре ку нумеле унея дин челе доуэспрезече семинций. ");
INSERT INTO ron1924_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Пентру пептар сэ фачь ниште лэнцишоаре де аур курат, ымплетите ка ниште сфорь. ");
INSERT INTO ron1924_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Сэ фачь пентру пептар доуэ вериӂь де аур, ши ачесте доуэ вериӂь де аур сэ ле пуй ла челе доуэ капете але пептарулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Челе доуэ ланцурь де аур ымплетите сэ ле принзь де челе доуэ вериӂь де ла челе доуэ капете але пептарулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Яр челелалте доуэ капете але челор доуэ ланцурь ымплетите сэ ле принзь де челе доуэ ферекэтурь ши сэ ле пуй песте умэрарий ефодулуй, ын партя динаинте. ");
INSERT INTO ron1924_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Сэ май фачь доуэ вериӂь де аур ши сэ ле пуй ла челелалте доуэ капете де жос але пептарулуй, пе марӂиня динэунтру каре есте ындрептатэ спре ефод. ");
INSERT INTO ron1924_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Ши сэ май фачь алте доуэ вериӂь де аур, пе каре сэ ле пуй жос ла чей дой умэрарь ай ефодулуй пе партя динаинте а луй, токмай аколо унде се ымбукэ ефодул ку умэрарий, дясупра брыулуй ефодулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Пептарул ку вериӂиле луй сэ-л леӂе де вериӂиле ефодулуй ку о сфоарэ албастрэ, пентру ка пептарул сэ стя цяпэн дясупра брыулуй ефодулуй ши сэ ну поатэ сэ се миште де пе ефод. ");
INSERT INTO ron1924_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Кынд ва интра Аарон ын Сфынтул Локаш, ва пурта пе инима луй нумеле фиилор луй Исраел, сэпате пе пептарул жудекэций, ка сэ пэстрезе тотдяуна адучеря аминте де ей ынаинтя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Сэ пуй ын пептарул жудекэций Урим ши Тумим, каре сэ фие пе инима луй Аарон кынд се ва ынфэциша ел ынаинтя Домнулуй. Астфел, Аарон ва пурта некурмат пе инима луй жудеката копиилор луй Исраел кынд се ва ынфэциша ынаинтя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Мантия де суб ефод с-о фачь ынтрягэ де материе албастрэ. ");
INSERT INTO ron1924_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Ла мижлок, сэ айбэ о гурэ пентру интраря капулуй ши гура ачаста сэ айбэ де жур ымпрежур о тивитурэ цесутэ, ка гура уней платоше, ка сэ ну се рупэ. ");
INSERT INTO ron1924_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Пе марӂине, де жур ымпрежурул тивитурий, сэ пуй ниште родий де кулоаре албастрэ, пурпурие ши кэрэмизие, пресэрате ку клопоцей де аур: ");
INSERT INTO ron1924_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","ун клопоцел де аур ши о родие, ун клопоцел де аур ши о родие, пе тоатэ марӂиня мантией, де жур ымпрежур. ");
INSERT INTO ron1924_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Аарон се ва ымбрэка ку еа ка сэ факэ служба; кынд ва интра ын Локашул Сфынт ынаинтя Домнулуй, ши кынд ва еши дин ел, се ва аузи сунетул клопоцеилор, аша кэ ел ну ва мури. ");
INSERT INTO ron1924_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Сэ фачь ши о таблэ де аур курат ши сэ сапь пе еа, кум се сапэ пе о печете: ‘Сфинцение Домнулуй’. ");
INSERT INTO ron1924_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","С-о леӂь ку о сфоарэ албастрэ де митрэ, ын партя динаинте а митрей. ");
INSERT INTO ron1924_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Еа сэ фие пе фрунтя луй Аарон ши Аарон ва пурта фэрэделеӂиле сэвыршите де копиий луй Исраел кынд ышь адук тоате даруриле лор сфинте; еа ва фи некурмат пе фрунтя луй ынаинтя Домнулуй, пентру ка ей сэ фие плэкуць ынаинтя Луй. ");
INSERT INTO ron1924_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Туника с-о фачь де ин субцире; сэ фачь о митрэ де ин субцире ши сэ фачь ун брыу лукрат ла гергеф. ");
INSERT INTO ron1924_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Фиилор луй Аарон сэ ле фачь туничь, сэ ле фачь брые ши сэ ле фачь скуфий, спре чинсте ши подоабэ. ");
INSERT INTO ron1924_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Сэ ымбрачь ку еле пе фрателе тэу Аарон ши пе фиий луй ымпреунэ ку ел. Сэ-й унӂь, сэ-й ынкинь ын службэ, сэ-й сфинцешть, ши-Мь вор служи ка преоць. ");
INSERT INTO ron1924_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Фэ-ле измене де ин, ка сэ-шь акопере голичуня, де ла брыу пынэ ла глезне. ");
INSERT INTO ron1924_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Аарон ши фиий луй ле вор пурта кынд вор интра ын кортул ынтылнирий сау кынд се вор апропия де алтар, ка сэ факэ служба ын Локашул Сфынт; астфел ей ну се вор фаче виноваць ши ну вор мури. Ачаста есте о леӂе вешникэ пентру Аарон ши пентру урмаший луй дупэ ел. ");
INSERT INTO ron1924_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Ятэ че вей фаче, пентру ка сэ-й сфинцешть ши сэ-Мь ымплиняскэ служба де преоць. Я ун вицел ши дой бербечь фэрэ кусур. ");
INSERT INTO ron1924_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Фэ ку фэинэ алясэ де грыу ниште азиме, турте недоспите, фрэмынтате ку унтделемн, ши плэчинте недоспите, стропите ку унтделемн. ");
INSERT INTO ron1924_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Сэ ле пуй ынтр-ун кош ши сэ ле адучь ымпреунэ ку вицелул ши чей дой бербечь. ");
INSERT INTO ron1924_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Сэ адучь апой пе Аарон ши пе фиий луй ла уша кортулуй ынтылнирий ши сэ-й спель ку апэ. ");
INSERT INTO ron1924_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Сэ ей вешминтеле; сэ ымбрачь пе Аарон ку туника, ку мантия ефодулуй, ку ефодул ши ку пептарул ши сэ-л ынчинӂь ку брыул ефодулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Сэ-й пуй митра пе кап ши пе митрэ сэ пуй табла сфинценией. ");
INSERT INTO ron1924_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Сэ ей унтделемнул пентру унӂере, сэ и-л торнь пе кап ши сэ-л унӂь. ");
INSERT INTO ron1924_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Сэ адучь апой пе фиий луй ши сэ-й ымбрачь ку туничиле. ");
INSERT INTO ron1924_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Сэ ынчинӂь пе Аарон ши пе фиий луй ку ун брыу ши сэ пуй скуфииле пе капетеле фиилор луй Аарон. Преоция ва фи а лор принтр-о леӂе вешникэ. Астфел сэ ынкинь пе Аарон ши пе фиий луй ын служба Мя. ");
INSERT INTO ron1924_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Сэ адучь вицелул ынаинтя кортулуй ынтылнирий ши Аарон ши фиий луй сэ-шь пунэ мыниле пе капул вицелулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Сэ жунгий вицелул ынаинтя Домнулуй, ла уша кортулуй ынтылнирий. ");
INSERT INTO ron1924_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Сэ ей ку деӂетул тэу дин сынӂеле вицелулуй, сэ пуй пе коарнеле алтарулуй, яр челэлалт сынӂе сэ-л вершь ла пичоареле алтарулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Сэ ей тоатэ грэсимя каре акоперэ мэрунтаеле ши прапурул фикатулуй, чей дой рэрункь ку грэсимя каре-й акоперэ ши сэ ле арзь пе алтар. ");
INSERT INTO ron1924_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Дар карня вицелулуй, пеля ши балега луй сэ ле арзь ын фок, афарэ дин табэрэ: ачаста есте о жертфэ пентру пэкат. ");
INSERT INTO ron1924_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Сэ ей пе унул дин чей дой бербечь; яр Аарон ши фиий луй сэ-шь пунэ мыниле пе капул бербекулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Сэ жунгий бербекул; сэ-й ей сынӂеле ши сэ-л стропешть пе алтар де жур ымпрежур. ");
INSERT INTO ron1924_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Апой, сэ тай бербекул ын букэць ши сэ-й спель мэрунтаеле ши пичоареле, ши сэ ле пуй лынгэ челелалте букэць ши лынгэ капул луй. ");
INSERT INTO ron1924_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Бербекул сэ-л арзь де тот пе алтар; ачаста есте о ардере-де-тот пентру Домнул, есте о жертфэ мистуитэ де фок, де ун мирос плэкут Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Сэ ей апой пе челэлалт бербек, яр Аарон ши фиий луй сэ-шь пунэ мыниле пе капул бербекулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Сэ жунгий бербекул; сэ ей дин сынӂеле луй, сэ пуй пе вырфул урекий дрепте а луй Аарон ши пе вырфул урекий дрепте а фиилор луй, пе деӂетул чел маре ал мыний лор дрепте ши пе деӂетул чел маре ал пичорулуй лор дрепт, яр челэлалт сынӂе сэ-л стропешть пе алтар де жур ымпрежур. ");
INSERT INTO ron1924_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Сэ ей дин сынӂеле де пе алтар ши дин унтделемнул пентру унӂере ши сэ стропешть пе Аарон ши вешминтеле луй, пе фиий луй ши вешминтеле лор. Астфел вор фи ынкинаць Аарон ши вешминтеле луй, фиий ши вешминтеле лор ын служба Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Сэ ей апой грэсимя бербекулуй, коада, грэсимя каре акоперэ мэрунтаеле, прапурул фикатулуй, чей дой рэрункь ку грэсимя каре-й акоперэ ши спата дряптэ, кэч ачеста есте ун бербек де ынкинаре ын служба Домнулуй; ");
INSERT INTO ron1924_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","дин кош сэ ей, дин азимиле пусе ынаинтя Домнулуй, о туртэ де пыне, о туртэ ку унтделемн ши о плэчинтэ. ");
INSERT INTO ron1924_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Тоате ачестя сэ ле пуй ын мыниле луй Аарон ши ын мыниле фиилор луй ши сэ ле леӂень ынтр-о парте ши ынтр-алта, ка ун дар легэнат ынаинтя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Сэ ле ей апой дин мыниле лор ши сэ ле арзь пе алтар, дясупра ардерий-де-тот; ачаста есте о жертфэ мистуитэ де фок ынаинтя Домнулуй, де ун мирос плэкут Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Сэ ей ши пептул бербекулуй каре ва служи ла ынкинаря луй Аарон ын служба Домнулуй ши сэ-л леӂень ынтр-о парте ши ын алта, ка ун дар легэнат ынаинтя Домнулуй: ачаста ва фи партя та. ");
INSERT INTO ron1924_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Сэ сфинцешть пептул легэнат ши спата ридикатэ дин бербекул каре ва служи ла ынкинаря луй Аарон ши а фиилор луй ын служба Домнулуй, пептул легэнынду-л ынтр-о парте ши ынтр-алта, спата ынфэцишынд-о ынаинтя Домнулуй прин ридикаре. ");
INSERT INTO ron1924_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Еле вор фи але луй Аарон ши але фиилор луй, принтр-о леӂе вешникэ, пе каре о вор цине копиий луй Исраел; кэч есте о жертфэ адусэ прин ридикаре, ши, ын жертфеле де мулцумире але копиилор луй Исраел, жертфа адусэ прин ридикаре ва фи а Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Вешминтеле сфинте але луй Аарон вор фи дупэ ел але фиилор луй, каре ле вор пуне кынд вор фи уншь ши кынд вор фи ынкинаць ын службэ. ");
INSERT INTO ron1924_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Вор фи пуртате тимп де шапте зиле де ачела динтре фиий луй, каре ый ва урма ын служба преоцией ши каре ва интра ын кортул ынтылнирий ка сэ факэ служба ын Сфынтул Локаш. ");
INSERT INTO ron1924_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Сэ ей апой бербекул пентру ынкинаря ын служба Домнулуй ши сэ пуй сэ-й фярбэ карня ынтр-ун лок сфынт. ");
INSERT INTO ron1924_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Аарон ши фиий луй сэ мэнынче, ла уша кортулуй ынтылнирий, карня бербекулуй ши пыня дин кош. ");
INSERT INTO ron1924_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Сэ мэнынче астфел тот че а служит ла фачеря испэширий, ка сэ фие ынкинаць ын службэ ши сфинциць; нимень алтул сэ ну мэнынче дин еле, кэч сунт лукрурь сфинте. ");
INSERT INTO ron1924_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Дакэ ва рэмыне чева дин карня ынтребуинцатэ пентру ынкинаря ын службэ ши дин пыне пынэ диминяца, сэ арзь ын фок че ва рэмыне; сэ ну се мэнынче, кэч есте ун лукру сфынт. ");
INSERT INTO ron1924_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Сэ урмезь, ку привире ла Аарон ши ла фиий луй, тоате порунчиле пе каре ци ле-ам дат. Ын шапте зиле сэ-й ынкинь ын службэ. ");
INSERT INTO ron1924_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Ын фиекаре зи сэ май адучь ун вицел ка жертфэ пентру пэкат, пентру испэшире; сэ курэцешть алтарул, фэкынд испэширя ачаста, ши сэ-л унӂь ка сэ-л сфинцешть. ");
INSERT INTO ron1924_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Тимп де шапте зиле, сэ фачь испэшире пентру алтар ши сэ-л сфинцешть, ши астфел алтарул ва фи прясфынт, ши орьчине се ва атинӂе де алтар ва фи сфинцит. ");
INSERT INTO ron1924_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Ятэ че сэ жертфешть пе алтар: дой мей де ун ан ын фиекаре зи, некурмат. ");
INSERT INTO ron1924_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Ун мел сэ-л жертфешть диминяца, яр челэлалт мел, сяра. ");
INSERT INTO ron1924_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Ымпреунэ ку чел динтый мел, сэ адучь а зечя парте динтр-о ефэ де флоаре де фэинэ, фрэмынтатэ ынтр-ун сферт де хин де унтделемн де мэслине, фэрэ дрождий, ши о жертфэ де бэутурэ де ун сферт де хин де вин. ");
INSERT INTO ron1924_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Пе ал дойля мел сэ-л жертфешть сяра ши сэ адучь ымпреунэ ку ел о жертфэ де мынкаре ши о жертфэ де бэутурэ ка челе де диминяцэ; ачаста есте о жертфэ мистуитэ де фок де ун мирос плэкут Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Ачаста есте ардеря-де-тот некурматэ, каре ва фи адусэ де урмаший воштри ла уша кортулуй ынтылнирий, ынаинтя Домнулуй; аколо Мэ вой ынтылни ку вой ши ыць вой ворби. ");
INSERT INTO ron1924_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Аколо Мэ вой ынтылни ку копиий луй Исраел ши локул ачела ва фи сфинцит де слава Мя. ");
INSERT INTO ron1924_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Вой сфинци кортул ынтылнирий ши алтарул; вой сфинци пе Аарон ши пе фиий луй, ка сэ фие ын служба Мя ка преоць. ");
INSERT INTO ron1924_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Еу вой локуи ын мижлокул копиилор луй Исраел ши вой фи Думнезеул лор. ");
INSERT INTO ron1924_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Ей вор куноаште кэ Еу сунт Домнул Думнезеул лор, каре й-ам скос дин цара Еӂиптулуй, ка сэ локуеск ын мижлокул лор. Еу сунт Домнул Думнезеул лор. ");
INSERT INTO ron1924_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Сэ фачь апой ун алтар пентру ардеря тэмыий, ши ануме сэ-л фачь дин лемн де салкым. ");
INSERT INTO ron1924_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Лунӂимя луй сэ фие де ун кот, яр лэцимя, тот де ун кот; сэ фие ын патру колцурь, ши ынэлцимя луй сэ фие де дой коць. Коарнеле алтарулуй сэ фие динтр-о букатэ ку ел. ");
INSERT INTO ron1924_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Сэ-й полеешть ку аур курат атыт партя де сус, кыт ши переций луй де жур ымпрежур ши коарнеле ши сэ-й фачь о кунунэ де аур де жур ымпрежур. ");
INSERT INTO ron1924_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Дедесубтул кунуний, сэ-й фачь доуэ вериӂь де аур, де амындоуэ латуриле, ын челе доуэ унгюрь, пентру пунеря друӂилор каре вор служи ла дучеря луй. ");
INSERT INTO ron1924_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Друӂий сэ-й фачь дин лемн де салкым ши сэ-й полеешть ку аур. ");
INSERT INTO ron1924_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Сэ ашезь алтарул ын фаца перделей динэунтру, каре есте ынаинтя кивотулуй мэртурией, ын фаца капакулуй испэширий, каре есте дясупра мэртурией ши унде Мэ вой ынтылни ку тине. ");
INSERT INTO ron1924_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Аарон ва арде пе ел тэмые мироситоаре; ва арде тэмые ын фиекаре диминяцэ, кынд ва прегэти канделеле; ");
INSERT INTO ron1924_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","ва арде ши сяра кынд ва ашеза канделеле. Астфел се ва арде некурмат дин партя воастрэ тэмые ынаинтя Домнулуй дин ням ын ням. ");
INSERT INTO ron1924_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Сэ ну адучець пе алтар алтфел де тэмые, нич ардере-де-тот, нич жертфэ де мынкаре ши сэ ну турнаць пе ел ничо жертфэ де бэутурэ. ");
INSERT INTO ron1924_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Нумай о датэ пе фиекаре ан, Аарон ва фаче испэшире пе коарнеле алтарулуй. Испэширя ачаста о ва фаче о датэ пе ан ку сынӂеле добитокулуй адус ка жертфэ пентру испэширя пэкатулуй, принтре урмаший воштри. Ачеста ва фи ун лукру прясфынт ынаинтя Домнулуй.” ");
INSERT INTO ron1924_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","„Кынд вей сокоти пе копиий луй Исраел ши ле вей фаче нумэрэтоаря, фиекаре дин ей сэ дя Домнулуй ун дар ын бань пентру рэскумпэраря суфлетулуй луй, ка сэ ну фие ловиць де ничо урӂие, ку прилежул ачестей нумэрэторь. ");
INSERT INTO ron1924_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Ятэ че вор да тоць чей че вор фи куприншь ын нумэрэтоаря ачаста: о жумэтате де сиклу, дупэ сиклул Сфынтулуй Локаш, каре есте де доуэзечь де гере; о жумэтате де сиклу ва фи дарул ридикат пентру Домнул. ");
INSERT INTO ron1924_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Орьче ом купринс ын нумэрэтоаре, де ла вырста де доуэзечь де ань ын сус, ва плэти дарул ридикат пентру Домнул. ");
INSERT INTO ron1924_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Богатул сэ ну плэтяскэ май мулт ши сэракул сэ ну плэтяскэ май пуцин де о жумэтате де сиклу ка дар ридикат пентру Домнул, пентру рэскумпэраря суфлетелор. ");
INSERT INTO ron1924_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Сэ ридичь де ла копиий луй Исраел арӂинтул пентру рэскумпэраре ши сэ-л ынтребуинцезь пентру служба кортулуй ынтылнирий; ачаста ва фи пентру копиий луй Исраел о адучере аминте ынаинтя Домнулуй пентру рэскумпэраря суфлетелор лор.” ");
INSERT INTO ron1924_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","„Сэ фачь ун лигян де арамэ, ку пичорул луй де арамэ, пентру спэлат; сэ-л ашезь ынтре кортул ынтылнирий ши алтар ши сэ торнь апэ ын ел, ");
INSERT INTO ron1924_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","ка сэ-шь спеле ын ел Аарон ши фиий луй мыниле ши пичоареле. ");
INSERT INTO ron1924_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Кынд вор интра ын кортул ынтылнирий, се вор спэла ку апа ачаста, ка сэ ну моарэ, ши се вор спэла ши кынд се вор апропия де алтар, ка сэ факэ служба ши ка сэ адукэ Домнулуй жертфе арсе де фок. ");
INSERT INTO ron1924_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Ышь вор спэла мыниле ши пичоареле ка сэ ну моарэ. Ачаста ва фи о леӂе некурматэ пентру Аарон, пентру фиий луй ши пентру урмаший лор.” ");
INSERT INTO ron1924_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","„Я дин челе май буне миродений, чинч суте де сикли де смирнэ фоарте куратэ, жумэтате, адикэ доуэ суте чинчзечь де сикли, де скорцишоарэ мироситоаре, доуэ суте чинчзечь де сикли де трестие мироситоаре, ");
INSERT INTO ron1924_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","чинч суте де сикли де касия, дупэ сиклул Сфынтулуй Локаш, ши ун хин де унтделемн де мэслине. ");
INSERT INTO ron1924_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Ку еле сэ фачь ун унтделемн пентру унӂеря сфынтэ, о аместекэтурэ мироситоаре, фэкутэ дупэ мештешугул фэкэторулуй де мир; ачеста ва фи унтделемнул пентру унӂеря сфынтэ. ");
INSERT INTO ron1924_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Ку ел сэ унӂь кортул ынтылнирий ши кивотул мэртурией, ");
INSERT INTO ron1924_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","маса ши тоате унелтеле ей, сфешникул ши унелтеле луй, алтарул тэмыерий, ");
INSERT INTO ron1924_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","алтарул ардерилор-де-тот, ку тоате унелтеле луй, ши лигянул ку пичорул луй. ");
INSERT INTO ron1924_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Сэ сфинцешть ачесте лукрурь, ши еле вор фи прясфинте; орьчине се ва атинӂе де еле ва фи сфинцит. ");
INSERT INTO ron1924_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Сэ унӂь, де асеменя, пе Аарон ши пе фиий луй ши сэ-й сфинцешть, ка сэ фие ын служба Мя ка преоць. ");
INSERT INTO ron1924_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Сэ ворбешть копиилор луй Исраел ши сэ ле спуй: ‘Ачеста Ымь ва фи унтделемнул пентру унӂеря сфынтэ, принтре урмаший воштри. ");
INSERT INTO ron1924_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Сэ ну се унгэ ку ел трупул ничунуй ом ши сэ ну фачець ун алт унтделемн ка ел дупэ ачеяшь ынтокмире; ел есте сфынт, ши вой сэ-л привиць ка сфынт. ");
INSERT INTO ron1924_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Орьчине ва фаче ун унтделемн ка ел сау ва унӂе ку ел пе алтул ва фи нимичит дин попорул луй.’” ");
INSERT INTO ron1924_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Домнул а зис луй Мойсе: „Я миродений, стакте, ониче мироситоаре, халван ши тэмые куратэ ын ачеяшь мэсурэ. ");
INSERT INTO ron1924_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Ку еле сэ фачь тэмые, о аместекэтурэ мироситоаре, алкэтуитэ дупэ мештешугул фэкэторулуй де мир; сэ фие сэратэ, куратэ ши сфынтэ. ");
INSERT INTO ron1924_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","С-о писезь мэрунт ши с-о пуй ынаинтя мэртурией, ын кортул ынтылнирий, унде Мэ вой ынтылни ку тине. Ачеста ва фи пентру вой ун лукру прясфынт. ");
INSERT INTO ron1924_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Тэмые ка ачаста, ын ачеяшь ынтокмире, сэ ну вэ фачець, чи с-о привиць ка сфынтэ ши пэстратэ пентру Домнул. ");
INSERT INTO ron1924_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Орьчине ва фаче тэмые ка еа ка с-о мироасе ва фи нимичит дин попорул луй.” ");
INSERT INTO ron1924_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","„Сэ штий кэ ам алес пе Бецалеел, фиул луй Ури, фиул луй Хур, дин семинция луй Иуда. ");
INSERT INTO ron1924_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Л-ам умплут ку Духул луй Думнезеу, й-ам дат ун дух де ынцелепчуне, причепере ши штиинцэ пентру тот фелул де лукрэрь, ");
INSERT INTO ron1924_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","й-ам дат путере сэ нэскочаскэ тот фелул де лукрэрь мештешуӂите, сэ лукрезе ын аур, ын арӂинт ши ын арамэ, ");
INSERT INTO ron1924_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","сэ сапе ын петре ши сэ ле леӂе, сэ лукрезе ын лемн ши сэ факэ тот фелул де лукрэрь. ");
INSERT INTO ron1924_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Ши ятэ кэ й-ам дат ка ажутор пе Охолиаб, фиул луй Ахисамак, дин семинция луй Дан. Ам дат причепере ын минтя тутурор челор че сунт искусиць, ка сэ факэ тот че ць-ам порунчит: ");
INSERT INTO ron1924_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","кортул ынтылнирий, кивотул мэртурией, капакул испэширий каре ва фи дясупра луй ши тоате унелтеле кортулуй; ");
INSERT INTO ron1924_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","маса ку унелтеле ей, сфешникул де аур курат ку тоате унелтеле луй, алтарул тэмыерий; ");
INSERT INTO ron1924_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","алтарул ардерилор-де-тот ку тоате унелтеле луй, лигянул ку пичорул луй; ");
INSERT INTO ron1924_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","вешминтеле пентру службэ, вешминтеле сфинте але преотулуй Аарон, вешминтеле фиилор луй пентру службеле преоцешть; ");
INSERT INTO ron1924_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","унтделемнул пентру унӂере ши тэмыя мироситоаре пентру Сфынтул Локаш. Ле вор фаче дупэ тоате порунчиле пе каре ци ле-ам дат.” ");
INSERT INTO ron1924_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","„Ворбеште копиилор луй Исраел ши спуне-ле: ‘Сэ ну каре кумва сэ ну цинець Сабателе Меле, кэч ачеста ва фи ынтре Мине ши вой, ши урмаший воштри, ун семн дупэ каре се ва куноаште кэ Еу сунт Домнул, каре вэ сфинцеск. ");
INSERT INTO ron1924_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Сэ цинець Сабатул, кэч ел ва фи пентру вой чева сфынт. Чине ыл ва кэлка ва фи педепсит ку моартя; чине ва фаче врео лукраре ын зиуа ачаста ва фи нимичит дин мижлокул попорулуй сэу. ");
INSERT INTO ron1924_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Сэ лукрезь шасе зиле, дар а шаптя есте Сабатул, зиуа де одихнэ ынкинатэ Домнулуй. Чине ва фаче врео лукраре ын зиуа Сабатулуй ва фи педепсит ку моартя. ");
INSERT INTO ron1924_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Копиий луй Исраел сэ пэзяскэ Сабатул, прэзнуинду-л, ей ши урмаший лор, ка ун легэмынт некурмат. ");
INSERT INTO ron1924_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Ачаста ва фи ынтре Мине ши копиий луй Исраел ун семн вешник, кэч ын шасе зиле а фэкут Домнул черуриле ши пэмынтул, яр ын зиуа а шаптя С-а одихнит ши а рэсуфлат.’” ");
INSERT INTO ron1924_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Кынд а испрэвит Домнул де ворбит ку Мойсе пе мунтеле Синай, й-а дат челе доуэ табле але мэртурией, табле де пятрэ, скрисе ку деӂетул луй Думнезеу. ");
INSERT INTO ron1924_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Попорул, вэзынд кэ Мойсе зэбовеште сэ се кобоаре де пе мунте, с-а стрынс ын журул луй Аарон ши й-а зис: „Хайде, фэ-не ун думнезеу каре сэ мяргэ ынаинтя ноастрэ, кэч Мойсе, омул ачела каре не-а скос дин цара Еӂиптулуй, ну штим че с-а фэкут!” ");
INSERT INTO ron1924_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Аарон ле-а рэспунс: „Скоатець черчеий де аур дин урекиле невестелор, фиилор ши фийчелор воастре ши адучеци-й ла мине.” ");
INSERT INTO ron1924_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Ши тоць шь-ау скос черчеий де аур дин урекь ши й-ау адус луй Аарон. ");
INSERT INTO ron1924_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Ел й-а луат дин мыниле лор, а бэтут аурул ку далта ши а фэкут ун вицел турнат. Ши ей ау зис: „Исраеле, ятэ думнезеул тэу каре те-а скос дин цара Еӂиптулуй!” ");
INSERT INTO ron1924_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Кынд а вэзут Аарон лукрул ачеста, а зидит ун алтар ынаинтя луй ши а стригат: „Мыне ва фи о сэрбэтоаре ын чинстя Домнулуй!” ");
INSERT INTO ron1924_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","А доуа зи, с-ау скулат дис-де-диминяцэ ши ау адус ардерь-де-тот ши жертфе де мулцумире. Попорул а шезут де а мынкат ши а бэут; апой с-ау скулат сэ жоаче. ");
INSERT INTO ron1924_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Домнул а зис луй Мойсе: „Скоалэ ши кобоарэ-те, кэч попорул тэу, пе каре л-ай скос дин цара Еӂиптулуй, с-а стрикат. ");
INSERT INTO ron1924_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Фоарте курынд с-ау абэтут де ла каля пе каре ле-о порунчисем Еу; шь-ау фэкут ун вицел турнат, с-ау ынкинат пынэ ла пэмынт ынаинтя луй, й-ау адус жертфе ши ау зис: ‘Исраеле, ятэ думнезеул тэу каре те-а скос дин цара Еӂиптулуй!’” ");
INSERT INTO ron1924_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Домнул а зис луй Мойсе: „Вэд кэ попорул ачеста есте ун попор ынкэпэцынат. ");
INSERT INTO ron1924_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Акум, ласэ-Мэ; мыния Мя аре сэ се априндэ ымпотрива лор ши-й вой мистуи, дар пе тине те вой фаче стрэмошул унуй ням маре.” ");
INSERT INTO ron1924_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Мойсе с-а ругат Домнулуй Думнезеулуй сэу ши а зис: „Пентру че сэ се априндэ, Доамне, мыния Та ымпотрива попорулуй Тэу, пе каре л-ай скос дин цара Еӂиптулуй ку маре путере ши ку мынэ таре? ");
INSERT INTO ron1924_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Пентру че сэ зикэ еӂиптений: ‘Спре ненорочиря лор й-а скос, ка сэ-й омоаре прин мунць ши ка сэ-й штяргэ де пе фаца пэмынтулуй’? Ынтоарче-Те дин юцяла мынией Тале ши ласэ-Те де рэул ачеста пе каре врей сэ-л фачь попорулуй Тэу. ");
INSERT INTO ron1924_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Аду-ць аминте де Авраам, де Исаак ши де Исраел, робий Тэй, кэрора ле-ай спус, журынду-Те пе Тине Ынсуць: ‘Вой ынмулци сэмынца воастрэ ка стелеле черулуй, вой да урмашилор воштри тоатэ цара ачаста де каре ам ворбит, ши ей о вор стэпыни ын вяк.’” ");
INSERT INTO ron1924_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Ши Домнул С-а лэсат де рэул пе каре спусесе кэ вря сэ-л факэ попорулуй Сэу. ");
INSERT INTO ron1924_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Мойсе с-а ынторс ши с-а коборыт де пе мунте ку челе доуэ табле але мэртурией ын мынэ. Таблеле ерау скрисе пе амындоуэ пэрциле, пе о парте ши пе алта. ");
INSERT INTO ron1924_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Таблеле ерау лукраря луй Думнезеу ши скрисул ера скрисул луй Думнезеу, сэпат пе табле. ");
INSERT INTO ron1924_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Иосуа а аузит гласул попорулуй, каре скотя стригэте, ши а зис луй Мойсе: „Ын табэрэ есте ун стригэт де рэзбой!” ");
INSERT INTO ron1924_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Мойсе а рэспунс: „Стригэтул ачеста ну-й нич стригэт де бируиторь, нич стригэт де бируиць; че ауд еу есте гласул унор оамень каре кынтэ!” ");
INSERT INTO ron1924_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Ши, пе кынд се апропия де табэрэ, а вэзут вицелул ши жокуриле. Мойсе с-а апринс де мыние, а арункат таблеле дин мынэ ши ле-а сфэрымат де пичорул мунтелуй. ");
INSERT INTO ron1924_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","А луат вицелул пе каре-л фэкусерэ ей ши л-а арс ын фок; л-а префэкут ын ченушэ, а пресэрат ченуша пе фаца апей ши а дат-о копиилор луй Исраел с-о бя. ");
INSERT INTO ron1924_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Мойсе а зис луй Аарон: „Че ць-а фэкут попорул ачеста, де ай адус асупра луй ун пэкат атыт де маре?” ");
INSERT INTO ron1924_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Аарон а рэспунс: „Сэ ну се априндэ де мыние домнул меу! Ту сингур штий кэ попорул ачеста есте порнит ла рэу. ");
INSERT INTO ron1924_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Ей мь-ау зис: ‘Фэ-не ун думнезеу каре сэ мяргэ ынаинтя ноастрэ; кэч Мойсе, омул ачела каре не-а скос дин цара Еӂиптулуй, ну штим че с-а фэкут!’ ");
INSERT INTO ron1924_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Еу ле-ам зис: ‘Чине аре аур сэ-л скоатэ!’ Ши ми л-ау дат; л-ам арункат ын фок ши дин ел а ешит вицелул ачеста.” ");
INSERT INTO ron1924_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Мойсе а вэзут кэ попорул ера фэрэ фрыу, кэч Аарон ыл фэкусе сэ фие фэрэ фрыу, спре батжокура врэжмашилор сэй; ");
INSERT INTO ron1924_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","с-а ашезат ла уша таберей ши а зис: „Чине есте пентру Домнул сэ винэ ла мине!” Ши тоць копиий луй Леви с-ау стрынс ла ел. ");
INSERT INTO ron1924_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Ел ле-а зис: „Аша ворбеште Домнул Думнезеул луй Исраел: ‘Фиекаре дин вой сэ се ынчингэ ку сабия; мерӂець ши стрэбатець табэра де ла о поартэ ла алта ши фиекаре сэ омоаре пе фрателе, пе приетенул ши пе руда са.’” ");
INSERT INTO ron1924_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Копиий луй Леви ау фэкут дупэ порунка луй Мойсе ши апроапе трей мий де оамень ау перит ын зиуа ачея дин попор. ");
INSERT INTO ron1924_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Мойсе а зис: „Предаци-вэ азь ын служба Домнулуй, кяр ку жертфа фиулуй ши фрателуй востру, пентру ка бинекувынтаря Луй сэ винэ астэзь песте вой!” ");
INSERT INTO ron1924_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","А доуа зи, Мойсе а зис попорулуй: „Аць фэкут ун пэкат фоарте маре. Ам сэ мэ суй акум ла Домнул: поате кэ вой кэпэта ертаре пентру пэкатул востру.” ");
INSERT INTO ron1924_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Мойсе с-а ынторс ла Домнул ши а зис: „Ах, попорул ачеста а фэкут ун пэкат фоарте маре! Шь-ау фэкут ун думнезеу де аур. ");
INSERT INTO ron1924_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Яртэ-ле акум пэкатул! Дакэ ну, атунч штерӂе-мэ дин картя Та пе каре ай скрис-о!” ");
INSERT INTO ron1924_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Домнул а зис луй Мойсе: „Пе чел че а пэкэтуит ымпотрива Мя, пе ачела ыл вой штерӂе дин картя Мя. ");
INSERT INTO ron1924_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ду-те дар ши ду попорул унде ць-ам спус. Ятэ, Ынӂерул Меу ва мерӂе ынаинтя та, дар ын зиуа рэзбунэрий Меле, ый вой педепси пентру пэкатул лор!” ");
INSERT INTO ron1924_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Домнул а ловит ку урӂие попорул, пентру кэ фэкусе вицелул фэурит де Аарон. ");
INSERT INTO ron1924_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Домнул а зис луй Мойсе: „Ду-те ши порнеште де аич ку попорул пе каре л-ай скос дин цара Еӂиптулуй; суе-те ын цара пе каре ам журат кэ о вой да луй Авраам, луй Исаак ши луй Иаков, зикынд: ‘Семинцей тале о вой да!’ ");
INSERT INTO ron1924_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Вой тримите ынаинтя та ун ынӂер ши вой изгони пе канааниць, амориць, хетиць, ферезиць, хевиць ши иебусиць. ");
INSERT INTO ron1924_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Суе-те ын цара ачаста унде курӂе лапте ши мьере. Дар Еу ну Мэ вой суи ын мижлокул тэу, ка сэ ну те прэпэдеск пе друм, кэч ешть ун попор ынкэпэцынат.” ");
INSERT INTO ron1924_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Кынд а аузит попорул ачесте тристе кувинте, тоць с-ау ынтристат ши нимень ну шь-а пус подоабеле пе ел. ");
INSERT INTO ron1924_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Ши Домнул а зис луй Мойсе: „Спуне копиилор луй Исраел: ‘Вой сунтець ун попор ынкэпэцынат; нумай о клипэ дакэ М-аш суи ын мижлокул тэу, те-аш прэпэди. Арункэ-ць акум подоабеле де пе тине, ши вой ведя че-ць вой фаче.’” ");
INSERT INTO ron1924_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Копиий луй Исраел шь-ау скос де пе ей подоабеле ши ау плекат де ла мунтеле Хореб. ");
INSERT INTO ron1924_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Мойсе а луат кортул луй ши л-а ынтинс афарэ дин табэрэ, ла о депэртаре оарекаре; л-а нумит кортул ынтылнирий. Ши тоць чей че ынтребау пе Домнул се дучяу ла кортул ынтылнирий, каре ера афарэ дин табэрэ. ");
INSERT INTO ron1924_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Кынд се дучя Мойсе ла корт, тот попорул се скула ын пичоаре; фиекаре стэтя ла уша кортулуй сэу ши урмэря ку окий пе Мойсе, пынэ интра ел ын корт. ");
INSERT INTO ron1924_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Ши кынд интра Мойсе ын корт, стылпул де нор се кобора ши се опря ла уша кортулуй, ши Домнул ворбя ку Мойсе. ");
INSERT INTO ron1924_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Тот попорул ведя стылпул де нор опринду-се ла уша кортулуй; тот попорул се скула ши се арунка ку фаца ла пэмынт ла уша кортулуй луй. ");
INSERT INTO ron1924_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Домнул ворбя ку Мойсе фацэ ын фацэ, кум ворбеште ун ом ку приетенул луй. Апой, Мойсе се ынторчя ын табэрэ, дар тынэрул луй служитор, Иосуа, фиул луй Нун, ну ешя делок дин мижлокул кортулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Мойсе а зис Домнулуй: „Ятэ, Ту ымь зичь: ‘Ду пе попорул ачеста!’ Ши ну-мь арэць пе чине вей тримите ку мине. Ынсэ Ту ай зис: ‘Еу те куноск пе нуме ши ай кэпэтат тречере ынаинтя Мя!’ ");
INSERT INTO ron1924_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Акум, дакэ ам кэпэтат тречере ынаинтя Та, аратэ-мь кэиле Тале; атунч Те вой куноаште ши вой авя тречере ынаинтя Та. Ши гындеште-Те кэ нямул ачеста есте попорул Тэу!” ");
INSERT INTO ron1924_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Домнул а рэспунс: „Вой мерӂе Еу Ынсумь ку тине ши ыць вой да одихнэ.” ");
INSERT INTO ron1924_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Мойсе й-а зис: „Дакэ ну мерӂь Ту Ынсуць ку ной, ну не лэса сэ плекэм де аич. ");
INSERT INTO ron1924_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Кум се ва шти кэ ам кэпэтат тречере ынаинтя Та, еу ши попорул Тэу? Оаре ну кынд вей мерӂе Ту ку ной ши кынд прин ачаста вом фи деосебиць, еу ши попорул Тэу, де тоате попоареле де пе фаца пэмынтулуй?” ");
INSERT INTO ron1924_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Домнул а зис луй Мойсе: „Вой фаче ши чея че-мь черь акум, кэч ай кэпэтат тречере ынаинтя Мя ши те куноск пе нуме!” ");
INSERT INTO ron1924_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Мойсе а зис: „Аратэ-мь слава Та!” ");
INSERT INTO ron1924_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Домнул а рэспунс: „Вой фаче сэ трякэ пе динаинтя та тоатэ фрумусеця Мя ши вой кема Нумеле Домнулуй ынаинтя та; Еу Мэ ындур де чине вряу сэ Мэ ындур ши ам милэ де чине вряу сэ ам милэ!” ");
INSERT INTO ron1924_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Домнул а зис: „Фаца ну вей путя сэ Мь-о везь, кэч ну поате омул сэ Мэ вадэ ши сэ трэяскэ!” ");
INSERT INTO ron1924_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Домнул а зис: „Ятэ ун лок лынгэ Мине; вей ста пе стынкэ. ");
INSERT INTO ron1924_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Ши кынд ва трече слава Мя, те вой пуне ын крэпэтура стынчий ши те вой акопери ку мына Мя пынэ вой трече. ");
INSERT INTO ron1924_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Яр кынд Ымь вой траӂе мына ла о парте де ла тине, Мэ вей ведя пе динапой; дар Фаца Мя ну се поате ведя.” ");
INSERT INTO ron1924_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Домнул а зис луй Мойсе: „Тае доуэ табле де пятрэ ка челе динтый ши Еу вой скрие пе еле кувинтеле каре ерау пе таблеле динтый, пе каре ле-ай сфэрымат. ");
INSERT INTO ron1924_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Фий гата дис-де-диминяцэ ши суе-те де диминяцэ пе мунтеле Синай; сэ стай аколо ынаинтя Мя, пе вырфул мунтелуй. ");
INSERT INTO ron1924_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Нимень сэ ну се суе ку тине ши нимень сэ ну се арате пе тот мунтеле, ши нич бой, нич ой сэ ну паскэ пе лынгэ мунтеле ачеста.” ");
INSERT INTO ron1924_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Мойсе а тэят доуэ табле де пятрэ ка ши челе динтый; с-а скулат дис-де-диминяцэ ши с-а суит пе мунтеле Синай, дупэ кум ый порунчисе Домнул, ши а луат ын мынэ челе доуэ табле де пятрэ. ");
INSERT INTO ron1924_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Домнул С-а коборыт ынтр-ун нор, а стат аколо лынгэ ел ши а ростит Нумеле Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Ши Домнул а трекут пе динаинтя луй ши а стригат: „Домнул Думнезеу есте ун Думнезеу плин де ындураре ши милостив, ынчет ла мыние, плин де бунэтате ши крединчошие, ");
INSERT INTO ron1924_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","каре Ышь цине драгостя пынэ ын мий де нямурь де оамень, яртэ фэрэделеӂя, рэзврэтиря ши пэкатул, дар ну сокотеште пе чел виноват дрепт невиноват ши педепсеште фэрэделеӂя пэринцилор ын копий ши ын копиий копиилор лор пынэ ла ал трейля ши ал патруля ням!” ");
INSERT INTO ron1924_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Ындатэ, Мойсе с-а плекат пынэ ла пэмынт ши с-а ынкинат. ");
INSERT INTO ron1924_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Ел а зис: „Доамне, дакэ ам кэпэтат тречере ынаинтя Та, Те рог сэ мерӂь ын мижлокул ностру, Доамне; попорул ачеста есте ын адевэр ун попор ынкэпэцынат, дар яртэ-не фэрэделеӂиле ши пэкателе ноастре ши я-не ын стэпыниря Та!” ");
INSERT INTO ron1924_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Домнул а рэспунс: „Ятэ, Еу фак ун легэмынт. Вой фаче ын фаца ынтрегулуй попор минунь каре н-ау авут лок ын ничо царэ ши ла ничун ням; тот попорул каре есте ын журул тэу ва ведя лукраря Домнулуй ши прин тине вой фаче лукрурь ынфрикошате. ");
INSERT INTO ron1924_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Я сяма ла чея че-ць порунческ азь. Ятэ, вой изгони динаинтя та пе амориць, канааниць, хетиць, ферезиць, хевиць ши иебусиць. ");
INSERT INTO ron1924_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Сэ ну кумва сэ фачь легэмынт ку локуиторий цэрий унде ай сэ интри, ка сэ ну фие о курсэ пентру тине, дакэ вор локуи ын мижлокул тэу. ");
INSERT INTO ron1924_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Димпотривэ, сэ ле дэрымаць алтареле, сэ ле сфэрымаць стылпий идолешть ши сэ ле трынтиць ла пэмынт идолий. ");
INSERT INTO ron1924_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Сэ ну те ынкинь ынаинтя унуй алт думнезеу; кэч Домнул се нумеште ӂелос, есте ун Думнезеу ӂелос. ");
INSERT INTO ron1924_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Фереште-те сэ фачь легэмынт ку локуиторий цэрий, ка ну кумва, курвинд ынаинтя думнезеилор лор ши адукынду-ле жертфе, сэ те пофтяскэ ши пе тине ши сэ мэнынчь дин жертфеле лор; ");
INSERT INTO ron1924_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","ка ну кумва сэ ей дин фетеле лор невесте фиилор тэй ши, астфел, фетеле лор, курвинд ынаинтя думнезеилор лор, сэ тыраскэ ши пе фиий тэй сэ курвяскэ ынаинтя думнезеилор лор. ");
INSERT INTO ron1924_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Сэ ну-ць фачь ун думнезеу турнат. ");
INSERT INTO ron1924_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Сэ ций Сэрбэтоаря Азимилор: тимп де шапте зиле, ла время хотэрытэ, ын луна спичелор, сэ мэнынчь азиме, кум ць-ам порунчит, кэч ын луна спичелор ай ешит дин Еӂипт. ");
INSERT INTO ron1924_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Орьче ынтый нэскут есте ал Меу, кяр орьче ынтый нэскут де парте бэрбэтяскэ дин турмеле де вачь сау де ой. ");
INSERT INTO ron1924_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Сэ рэскумперь ку ун мел пе ынтыюл нэскут ал мэгэрицей, яр дакэ ну-л рэскумперь, сэ-й фрынӂь гытул. Сэ рэскумперь пе орьче ынтый нэскут ал фиилор тэй ши сэ ну те ынфэцишезь ку мыниле гоале ынаинтя Мя. ");
INSERT INTO ron1924_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Шасе зиле сэ лукрезь, яр ын зиуа а шаптя сэ те одихнешть; сэ те одихнешть, кяр ын время аратулуй ши а сечератулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Сэ ций Сэрбэтоаря Сэптэмынилор, а челор динтый роаде дин сечеришул грыулуй, ши Сэрбэтоаря Стрынӂерий Роаделор ла сфыршитул анулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Де трей орь пе ан, тоць чей де парте бэрбэтяскэ сэ се ынфэцишезе ынаинтя Домнулуй Думнезеу, Думнезеул луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Кэч вой изгони нямуриле динаинтя та ши-ць вой ынтинде хотареле ши нимень ну-ць ва пофти цара ын тимпул кынд те вей суи де трей орь пе ан ка сэ те ынфэцишезь ынаинтя Домнулуй Думнезеулуй тэу. ");
INSERT INTO ron1924_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Сэ н-адучь ку пыне доспитэ сынӂеле добитокулуй жертфит ын чинстя Мя, ши карня дин жертфа празникулуй Паштелор сэ ну фие цинутэ ын тимпул нопций пынэ диминяца. ");
INSERT INTO ron1924_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Сэ адучь ын каса Домнулуй Думнезеулуй тэу пырга челор динтый роаде але пэмынтулуй. Едул сэ ну-л фербь ын лаптеле мамей луй.” ");
INSERT INTO ron1924_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Домнул а зис луй Мойсе: „Скрие-ць кувинтеле ачестя, кэч пе темеюл ачестор кувинте ынкей легэмынт ку тине ши ку Исраел!” ");
INSERT INTO ron1924_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Мойсе а стат аколо ку Домнул патрузечь де зиле ши патрузечь де нопць. Н-а мынкат делок пыне ши н-а бэут делок апэ. Ши Домнул а скрис пе табле кувинтеле легэмынтулуй, Челе Зече Порунчь. ");
INSERT INTO ron1924_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Мойсе с-а коборыт де пе мунтеле Синай ку челе доуэ табле але мэртурией ын мынэ. Кынд се кобора де пе мунте, ну штия кэ пеля фецей луй стрэлучя, пентру кэ ворбисе ку Домнул. ");
INSERT INTO ron1924_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Аарон ши тоць копиий луй Исраел с-ау уйтат ла Мойсе ши ятэ кэ пеля фецей луй стрэлучя ши се темяу сэ се апропие де ел. ");
INSERT INTO ron1924_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Мойсе й-а кемат; Аарон ши тоць фрунташий адунэрий с-ау ынторс ла ел, ши ел ле-а ворбит. ");
INSERT INTO ron1924_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Дупэ ачея, тоць копиий луй Исраел с-ау апропият, ши ел ле-а дат тоате порунчиле, пе каре ле примисе де ла Домнул пе мунтеле Синай. ");
INSERT INTO ron1924_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Кынд а ынчетат сэ ле ворбяскэ, шь-а пус о марамэ пе фацэ. ");
INSERT INTO ron1924_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Кынд интра Мойсе ынаинтя Домнулуй ка сэ-Й ворбяскэ, ышь скотя марама пынэ че ешя; яр кынд ешя, спуня копиилор луй Исраел че и се порунчисе. ");
INSERT INTO ron1924_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Копиий луй Исраел се уйтау ла фаца луй Мойсе ши ведяу кэ пеля фецей луй стрэлучя, ши Мойсе ышь пуня ярэшь марама пе фацэ пынэ че интра ка сэ ворбяскэ ку Домнул. ");
INSERT INTO ron1924_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Мойсе а стрынс тоатэ адунаря копиилор луй Исраел ши ле-а зис: „Ятэ лукруриле пе каре а порунчит Домнул сэ ле фачець: ");
INSERT INTO ron1924_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Шасе зиле сэ лукраць, дар зиуа а шаптя сэ вэ фие сфынтэ; ачеста есте Сабатул, зиуа де одихнэ ынкинатэ Домнулуй. Чине ва фаче врео лукраре ын зиуа ачея сэ фие педепсит ку моартя. ");
INSERT INTO ron1924_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Сэ н-априндець фок ын ничуна дин локуинцеле воастре ын зиуа Сабатулуй.” ");
INSERT INTO ron1924_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Мойсе а ворбит ынтреӂий адунэрь а копиилор луй Исраел ши а зис: „Ятэ че а порунчит Домнул. ");
INSERT INTO ron1924_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Луаць дин че авець ши адучець ун принос Домнулуй. Фиекаре сэ адукэ принос Домнулуй че-л ласэ инима: аур, арӂинт ши арамэ; ");
INSERT INTO ron1924_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","материй вопсите ын албастру, ын пурпуриу, ын кэрэмизиу, ин субцире ши пэр де капрэ; ");
INSERT INTO ron1924_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","пей де бербек вопсите ын рошу ши пей де вицел де маре; лемн де салкым, ");
INSERT INTO ron1924_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","унтделемн пентру сфешник, миродений пентру унтделемнул унӂерий ши пентру тэмыя мироситоаре; ");
INSERT INTO ron1924_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","петре де оникс ши алте петре пентру ымподобиря ефодулуй ши а пептарулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Тоць чей искусиць динтре вой сэ винэ ши сэ факэ тот че а порунчит Домнул: ");
INSERT INTO ron1924_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","локашул, кортул ши акоперишул луй, копчиле, скындуриле, друӂий, стылпий ши пичоареле луй; ");
INSERT INTO ron1924_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","кивотул ши друӂий луй, капакул испэширий ши пердяуа динэунтру пентру акопериря кивотулуй; ");
INSERT INTO ron1924_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","маса ши друӂий ей, ку тоате унелтеле ей, ши пыниле пентру пунеря ынаинтя Домнулуй; ");
INSERT INTO ron1924_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","сфешникул ку унелтеле луй, канделеле луй ши унтделемнул пентру сфешник; ");
INSERT INTO ron1924_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","алтарул пентру тэмые ши друӂий луй, унтделемнул пентру унӂере ши тэмыя мироситоаре, ши пердяуа уший де афарэ, де ла интраря кортулуй; ");
INSERT INTO ron1924_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","алтарул пентру ардериле-де-тот, грэтарул луй де арамэ, друӂий луй ши тоате унелтеле луй, лигянул ку пичорул луй, ");
INSERT INTO ron1924_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","пынзеле курций, стылпий ей, пичоареле ей ши пердяуа де ла поарта курций; ");
INSERT INTO ron1924_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","цэруший кортулуй, цэруший курций ши фунииле лор; ");
INSERT INTO ron1924_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","вешминтеле преоцешть пентру служба Сфынтулуй Локаш, вешминтеле сфинте але преотулуй Аарон ши вешминтеле фиилор луй пентру службеле преоцешть.” ");
INSERT INTO ron1924_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Тоатэ адунаря копиилор луй Исраел а ешит динаинтя луй Мойсе. ");
INSERT INTO ron1924_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Тоць чей ку траӂере де инимэ ши бунэвоинцэ ау венит ши ау адус ун принос Домнулуй пентру лукраря кортулуй ынтылнирий, пентру тоатэ служба луй ши пентру вешминтеле сфинте. ");
INSERT INTO ron1924_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Ау венит ындатэ бэрбаций ши фемеиле, тоць чей ку траӂере де инимэ ши ау адус белчуӂе де нас, инеле, черчей, брэцэрь, салбе ши тот фелул де лукрурь де аур; фиекаре а адус приносул де аур, пе каре-л ынкинасе Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Тоць чей че авяу стофе (материй) вопсите ын албастру, ын пурпуриу, ын кэрэмизиу, дин ин субцире ши пэр де капрэ, пей де бербек вопсите ын рошу ши пей де вицел де маре ле-ау адус. ");
INSERT INTO ron1924_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Тоць чей че путяу адуче прин ридикаре ун принос де арӂинт ши де арамэ ау адус приносул Домнулуй. Тоць чей че авяу лемн де салкым бун пентру лукрэриле рындуите пентру службэ л-ау адус. ");
INSERT INTO ron1924_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Тоате фемеиле искусите ау торс ку мыниле лор ши ау адус лукрул лор, ши ануме: торт вопсит ын албастру, ын пурпуриу, ын кэрэмизиу ши ин субцире. ");
INSERT INTO ron1924_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Тоате фемеиле ку траӂере де инимэ ши искусите ау торс пэр де капрэ. ");
INSERT INTO ron1924_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Фрунташий попорулуй ау адус петре де оникс ши алте петре пентру ефод ши пептар; ");
INSERT INTO ron1924_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","миродений ши унтделемн, пентру сфешник, пентру унтделемнул унӂерий ши пентру тэмыя мироситоаре. ");
INSERT INTO ron1924_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Тоць копиий луй Исраел, бэрбаць ши фемей, пе каре-й трэӂя инима сэ ажуте ла лукрул порунчит де Домнул прин Мойсе ау адус Домнулуй дарурь де бунэвое. ");
INSERT INTO ron1924_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Мойсе а зис копиилор луй Исраел: „Сэ штиць кэ Домнул а алес пе Бецалеел, фиул луй Ури, фиул луй Хур, дин семинция луй Иуда. ");
INSERT INTO ron1924_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Л-а умплут ку Духул луй Думнезеу, дух де ынцелепчуне, причепере ши штиинцэ пентру тот фелул де лукрэрь. ");
INSERT INTO ron1924_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Й-а дат путере сэ нэскочаскэ планурь, сэ лукрезе ын аур, ын арӂинт ши ын арамэ, ");
INSERT INTO ron1924_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","сэ сапе ын петре ши сэ ле леӂе, сэ лукрезе лемнул ку мештешуг ши сэ факэ тот фелул де лукрэрь мештешуӂите. ");
INSERT INTO ron1924_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Й-а дат ши дарул сэ ынвеце пе алций, атыт луй, кыт ши луй Охолиаб, фиул луй Ахисамак, дин семинция луй Дан. ");
INSERT INTO ron1924_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Й-а умплут ку причепере, ка сэ факэ тоате лукрэриле де сэпэтурэ ын пятрэ, де чоплитурэ мештешуӂитэ, де лукрат ла гергеф ши де цесут материй вопсите ын албастру, ын пурпуриу, ын кэрэмизиу ши ин субцире, сэ факэ тот фелул де лукрэрь ши нэскочирь де планурь.” ");
INSERT INTO ron1924_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Бецалеел, Охолиаб ши тоць бэрбаций искусиць ын каре пусесе Домнул ынцелепчуне ши причепере, ка сэ штие сэ факэ лукрэриле рындуите пентру служба Сфынтулуй Локаш, ау фэкут тотул дупэ кум порунчисе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Мойсе а кемат пе Бецалеел, Охолиаб ши пе тоць бэрбаций искусиць ын минтя кэрора пусесе Домнул причепере, ши ануме пе тоць чей ку траӂере де инимэ ла лукрул ачеста, ка сэ-л факэ. ");
INSERT INTO ron1924_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Ей ау луат динаинтя луй Мойсе тоате приноаселе пе каре ле адусесерэ копиий луй Исраел ка сэ факэ лукрэриле рындуите пентру служба Сфынтулуй Локаш. Кяр ши дупэ че се ынчепусе лукраря, тот се май адучяу луй Мойсе ын фиекаре диминяцэ дарурь де бунэвое. ");
INSERT INTO ron1924_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Атунч, тоць бэрбаций искусиць, приншь ла тоате лукрэриле Сфынтулуй Локаш, шь-ау лэсат фиекаре лукрул пе каре-л фэчяу ");
INSERT INTO ron1924_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","ши ау венит де ау спус луй Мойсе: „Попорул адуче мулт май мулт декыт требуе пентру фачеря лукрэрилор пе каре а порунчит Домнул сэ ле фачем.” ");
INSERT INTO ron1924_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Мойсе а пус сэ стриӂе ын табэрэ ка нимень, фие бэрбат, фие фемее, сэ ну май адукэ дарурь пентру Сфынтул Локаш. Ау оприт астфел пе попор сэ май адукэ дарурь. ");
INSERT INTO ron1924_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Материалул адус ера де ажунс пентру тоате лукрэриле каре требуяу фэкуте, ба ынкэ май ши тречя. ");
INSERT INTO ron1924_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Тоць бэрбаций искусиць ши лукрэторий ау фэкут кортул дин зече ковоаре де ин субцире ши рэсучит, дин фир албастру, пурпуриу ши кэрэмизиу; пе еле ау цесут херувимь лукраць ку мэестрие. ");
INSERT INTO ron1924_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Лунӂимя унуй ковор ера де доуэзечь ши опт де коць; яр лэцимя унуй ковор ера де патру коць. Тоате ковоареле авяу ачеяшь мэсурэ. ");
INSERT INTO ron1924_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Чинч дин ачесте ковоаре ау фост принсе ла ун лок; челелалте чинч, де асеменя, ау фост принсе ла ун лок. ");
INSERT INTO ron1924_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Ау фэкут киоторь албастре ла марӂиня коворулуй ку каре се сфыршя чя динтый ымпреунаре; тот аша ау фэкут ши ла марӂиня коворулуй ку каре се сфыршя а доуа ымпреунаре де ковоаре. ");
INSERT INTO ron1924_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Ау фэкут чинчзечь де киоторь ла чел динтый ковор ши чинчзечь де киоторь ла марӂиня коворулуй ку каре се сфыршя а доуа ымпреунаре де ковоаре; киоториле ачестя ерау уна ын фаца алтея. ");
INSERT INTO ron1924_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Ау фэкут чинчзечь де копчь де аур ши ау принс ковоареле унул де алтул ку копчиле, аша ынкыт кортул алкэтуя ун ынтрег. ");
INSERT INTO ron1924_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Ау фэкут ниште ковоаре дин пэр де капрэ, ка сэ служяскэ де акопериш пентру корт: унспрезече ковоаре де ачестя ау фэкут. ");
INSERT INTO ron1924_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Лунӂимя унуй ковор ера де трейзечь де коць ши лэцимя унуй ковор ера де патру коць: челе унспрезече ковоаре авяу ачеяшь мэсурэ. ");
INSERT INTO ron1924_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Ау принс ымпреунэ деопарте чинч дин ачесте ковоаре, яр пе челелалте шасе де алтэ парте. ");
INSERT INTO ron1924_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Ау фэкут чинчзечь де киоторь ла марӂиня коворулуй ку каре се сфыршя о ымпреунаре де ковоаре ши чинчзечь де киоторь ла марӂиня коворулуй ку каре се сфыршя а доуа ымпреунаре де ковоаре. ");
INSERT INTO ron1924_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Ау май фэкут ши чинчзечь де копчь де арамэ, ку каре сэ се ымпреуне акоперишул кортулуй, ка сэ алкэтуяскэ ун ынтрег. ");
INSERT INTO ron1924_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Ау фэкут пентру акоперишул кортулуй о ынвелитоаре де пей де бербек вопсите ын рошу ши о ынвелитоаре де пей де вицел де маре, каре требуя пусэ пе дясупра. ");
INSERT INTO ron1924_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Скындуриле пентру корт ле-ау фэкут дин лемн де салкым, ашезате ын пичоаре. ");
INSERT INTO ron1924_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Лунӂимя уней скындурь ера де зече коць ши лэцимя уней скындурь ера де ун кот ши жумэтате. ");
INSERT INTO ron1924_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Фиекаре скындурэ авя доуэ урекь, уните уна ку алта; тот аша ау фэкут ла тоате скындуриле кортулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Ау фэкут доуэзечь де скындурь пентру корт, ынспре партя де мязэзи. ");
INSERT INTO ron1924_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Ау пус патрузечь де пичоаре де арӂинт суб челе доуэзечь де скындурь, кыте доуэ пичоаре суб фиекаре скындурэ, пентру челе доуэ урекь але ей. ");
INSERT INTO ron1924_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Ау фэкут апой доуэзечь де скындурь пентру а доуа латурэ а кортулуй, латура динспре мязэноапте, ");
INSERT INTO ron1924_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","ку челе патрузечь де пичоаре де арӂинт але лор, кыте доуэ пичоаре суб фиекаре скындурэ. ");
INSERT INTO ron1924_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Ау фэкут апой шасе скындурь пентру фундул кортулуй, ынспре апус. ");
INSERT INTO ron1924_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Ау фэкут доуэ скындурь пентру челе доуэ унгюрь але кортулуй ын партя дин фунд; ");
INSERT INTO ron1924_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","ачестя ерау фэкуте дин доуэ букэць, ынчепынд де ла партя де жос, ши бине легате ла вырф, принтр-ун черк; ла фел ау фэкут пентру амындоуэ скындуриле дин челе доуэ унгюрь. ");
INSERT INTO ron1924_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Ерау астфел опт скындурь, ку пичоареле лор де арӂинт, адикэ шайспрезече пичоаре, кыте доуэ пичоаре суб фиекаре скындурэ. ");
INSERT INTO ron1924_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Ау фэкут чинч друӂь дин лемн де салкым пентру скындуриле унея дин латуриле кортулуй, ");
INSERT INTO ron1924_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","чинч друӂь пентру скындуриле челей де а доуа латурь а кортулуй ши чинч друӂь пентру скындуриле латурий кортулуй дин фундул динспре апус; ");
INSERT INTO ron1924_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","другул де ла мижлок л-ау фэкут аша ка сэ трякэ прин мижлокул скындурилор, де ла ун капэт ла челэлалт. ");
INSERT INTO ron1924_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Ау полеит скындуриле ку аур ши вериӂиле лор де аур ле-ау фэкут аша ка сэ се поатэ петрече друӂий прин еле, ши друӂий й-ау полеит ку аур. ");
INSERT INTO ron1924_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Пердяуа динэунтру ау фэкут-о дин фир албастру, пурпуриу ши кэрэмизиу ши дин ин субцире рэсучит; ау лукрат-о ку мэестрие ши ау фэкут херувимь пе еа. ");
INSERT INTO ron1924_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Ау фэкут патру стылпь де салкым пентру еа ши й-ау полеит ку аур; кырлиӂеле лор ерау де аур ши ау турнат пентру стылпий ачештя патру пичоаре де арӂинт. ");
INSERT INTO ron1924_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Пентру уша кортулуй ау фэкут о пердя дин фир албастру, пурпуриу ши кэрэмизиу ши дин ин субцире рэсучит; ачаста ера о лукраре фэкутэ ла гергеф. ");
INSERT INTO ron1924_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Ау фэкут чей чинч стылпь ай ей ку кырлиӂеле лор, яр кэпэтыеле ши бецеле лор де легэтурэ ле-ау полеит ку аур; челе чинч пичоаре але лор ерау де арамэ. ");
INSERT INTO ron1924_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Апой Бецалеел а фэкут кивотул дин лемн де салкым; лунӂимя луй ера де дой коць ши жумэтате; лэцимя, де ун кот ши жумэтате ши ынэлцимя, тот де ун кот ши жумэтате. ");
INSERT INTO ron1924_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Л-а полеит ку аур курат пе динэунтру ши пе динафарэ ши й-а фэкут ун кенар де жур ымпрежур. ");
INSERT INTO ron1924_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","А турнат пентру ел патру вериӂь де аур, пе каре ле-а пус ла челе патру колцурь але луй: доуэ вериӂь де о парте ши доуэ вериӂь де чялалтэ парте. ");
INSERT INTO ron1924_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","А фэкут ниште друӂь де лемн де салкым ши й-а полеит ку аур. ");
INSERT INTO ron1924_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","А вырыт друӂий ын вериӂиле де ла челе доуэ латурь але кивотулуй, ка сэ дукэ кивотул. ");
INSERT INTO ron1924_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","А фэкут ши капакул испэширий дин аур курат; лунӂимя луй ера де дой коць ши жумэтате ши лэцимя, де ун кот ши жумэтате. ");
INSERT INTO ron1924_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","А фэкут дой херувимь дин аур бэтут ла челе доуэ капете але капакулуй испэширий; ");
INSERT INTO ron1924_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","ун херувим ла ун капэт ши ун херувим ла челэлалт капэт; херувимий й-а фэкут пе капакул испэширий ла челе доуэ капете але луй. ");
INSERT INTO ron1924_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Херувимий ерау ку арипиле ынтинсе дясупра, акоперинд капакул испэширий ку арипиле лор ши уйтынду-се унул ла алтул. Херувимий стэтяу ку фаца ынтоарсэ спре капакул испэширий. ");
INSERT INTO ron1924_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","А фэкут маса дин лемн де салкым: лунӂимя ей ера де дой коць; лэцимя, де ун кот ши ынэлцимя, де ун кот ши жумэтате. ");
INSERT INTO ron1924_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","А полеит-о ку аур курат ши й-а фэкут ун кенар де жур ымпрежур. ");
INSERT INTO ron1924_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Й-а фэкут ымпрежур ун перваз де ун лат де мынэ, пе каре а фэкут ун кенар де жур ымпрежур. ");
INSERT INTO ron1924_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","А турнат пентру масэ патру вериӂь де аур ши а пус вериӂиле ын челе патру колцурь, каре ерау ла челе патру пичоаре але ей. ");
INSERT INTO ron1924_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Вериӂиле ерау лынгэ перваз, ши ын еле ерау вырыць друӂий пентру дучеря месей. ");
INSERT INTO ron1924_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","А фэкут друӂий дин лемн де салкым ши й-а полеит ку аур; ей служяу ла дучеря месей. ");
INSERT INTO ron1924_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","А фэкут апой унелтеле каре требуяу пусе пе масэ, фарфурииле, кэцуиле, потиреле ши чештиле ей, каре служяу ла жертфеле де бэутурэ; ле-а фэкут дин аур курат. ");
INSERT INTO ron1924_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","А фэкут сфешникул дин аур курат; а фэкут сфешникул дин аур курат, бэтут; пичорул, фусул, потирашеле, гэмэлиоареле ши флориле луй ерау динтр-о букатэ ку ел. ");
INSERT INTO ron1924_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Дин амындоуэ пэрциле луй ешяу шасе браце: трей браце динтр-о латурэ ши трей браце дин чялалтэ латурэ. ");
INSERT INTO ron1924_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Пе ун брац ерау трей потираше ын кип де флоаре де мигдал, ку гэмэлиоареле ши флориле лор, ши пе ун алт брац, алте трей потираше ын кип де флоаре де мигдал, ку гэмэлиоареле ши флориле лор; аша ера ла тоате челе шасе браце каре ешяу дин сфешник. ");
INSERT INTO ron1924_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Пе фусул сфешникулуй ерау патру потираше ын кип де флоаре де мигдал, ку гэмэлиоареле ши флориле лор. ");
INSERT INTO ron1924_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Ера о гэмэлиоарэ суб доуэ браце каре ешяу дин сфешник, о гэмэлиоарэ суб алте доуэ браце ши о гэмэлиоарэ суб алте доуэ браце; аша ера ла тоате челе шасе браце каре ешяу дин сфешник. ");
INSERT INTO ron1924_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Гэмэлиоареле ши брацеле сфешникулуй ерау динтр-о букатэ ку ел, бэтут ын ынтреӂиме динтр-о букатэ де аур курат. ");
INSERT INTO ron1924_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","А фэкут апой челе шапте канделе але луй, мукэриле ши ченушареле луй, тоате дин аур курат. ");
INSERT INTO ron1924_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","А ынтребуинцат ун талант де аур курат пентру фачеря сфешникулуй ку тоате унелтеле луй. ");
INSERT INTO ron1924_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Апой а фэкут алтарул пентру тэмые дин лемн де салкым: лунӂимя луй ера де ун кот ши лэцимя, де ун кот; ера ын патру мукий, ши ынэлцимя луй ера де дой коць. Коарнеле ерау динтр-о букатэ ку ел. ");
INSERT INTO ron1924_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Л-а полеит ку аур курат, атыт партя де сус, кыт ши латуриле де жур ымпрежур ши коарнеле. Ши й-а фэкут о кунунэ де жур ымпрежур. ");
INSERT INTO ron1924_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Суб кунунэ а фэкут доуэ вериӂь де аур, пе каре ле-а пус ын челе доуэ унгюрь дин челе доуэ латурь, ка сэ се выре ын еле друӂий каре служяу ла дучеря луй. ");
INSERT INTO ron1924_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","А фэкут ниште друӂь дин лемн де салкым ши й-а полеит ку аур. ");
INSERT INTO ron1924_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","А фэкут унтделемнул пентру унӂеря сфынтэ ши тэмыя мироситоаре, куратэ, алкэтуитэ дупэ мештешугул фэкэторулуй де мир. ");
INSERT INTO ron1924_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","А фэкут алтарул пентру ардериле-де-тот дин лемн де салкым: лунӂимя луй ера де чинч коць ши лэцимя, де чинч коць; ера ын патру мукий, ши ынэлцимя луй ера де трей коць. ");
INSERT INTO ron1924_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Ла челе патру колцурь, й-а фэкут ниште коарне динтр-о букатэ ку ел ши л-а полеит ку арамэ. ");
INSERT INTO ron1924_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","А фэкут тоате унелтеле алтарулуй: оалеле пентру ченушэ, лопециле, лигенеле, фуркулицеле ши тигэиле пентру кэрбунь; тоате унелтеле ачестя ле-а фэкут де арамэ. ");
INSERT INTO ron1924_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","А фэкут пентру алтар ун грэтар де арамэ, ка о реця, пе каре а пус-о суб первазул алтарулуй, ынчепынд де жос, аша кэ веня пынэ ла жумэтатя алтарулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","А турнат апой патру вериӂь, пе каре ле-а пус ын челе патру колцурь але грэтарулуй де арамэ, ка сэ выре друӂий ын еле. ");
INSERT INTO ron1924_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","А фэкут друӂий дин лемн де салкым ши й-а полеит ку арамэ. ");
INSERT INTO ron1924_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","А вырыт друӂий ын вериӂиле де пе латуриле алтарулуй ка сэ-л дукэ. Л-а фэкут дин скындурь, гол пе динэунтру. ");
INSERT INTO ron1924_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","А фэкут лигянул де арамэ, ку пичорул луй де арамэ, дин оглинзиле фемеилор каре служяу ла уша кортулуй ынтылнирий. ");
INSERT INTO ron1924_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Апой а фэкут куртя. Ынспре партя де мязэзи, пентру курте, ерау ниште пынзе де ин субцире рэсучит, пе о лунӂиме де о сутэ де коць, ");
INSERT INTO ron1924_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","ку доуэзечь де стылпь ашезаць пе доуэзечь де пичоаре де арамэ; кырлиӂеле стылпилор ши бецеле лор де легэтурэ ерау де арӂинт. ");
INSERT INTO ron1924_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Ынспре партя де мязэноапте, ерау о сутэ де коць де пынзэ, ку доуэзечь де стылпь ши ку челе доуэзечь де пичоаре де арамэ але лор; кырлиӂеле стылпилор ши бецеле лор де легэтурэ ерау де арӂинт. ");
INSERT INTO ron1924_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Ынспре партя де апус, ерау чинчзечь де коць де пынзэ, ку зече стылпь ши челе зече пичоаре але лор; кырлиӂеле стылпилор ши бецеле лор де легэтурэ ерау дин арӂинт. ");
INSERT INTO ron1924_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Ынспре партя де рэсэрит, пе чей чинчзечь де коць лэциме, ерау: ");
INSERT INTO ron1924_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","пентру о арипэ, чинчспрезече коць де пынзэ, ку трей стылпь ши челе трей пичоаре але лор, ");
INSERT INTO ron1924_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","ши пентру а доуа арипэ, каре ера ын фаца ей, де чялалтэ парте а порций курций, чинчспрезече коць де пынзэ, ку трей стылпь ши челе трей пичоаре але лор. ");
INSERT INTO ron1924_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Тоате пынзеле де жур ымпрежурул курций ерау дин ин субцире рэсучит. ");
INSERT INTO ron1924_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Пичоареле стылпилор ерау де арамэ, кырлиӂеле стылпилор ши бецеле лор де легэтурэ ерау дин арӂинт, ши кэпэтыеле лор ерау полеите ку арӂинт. Тоць стылпий курций ерау легаць ынтре ей ку беце де арӂинт. ");
INSERT INTO ron1924_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Пердяуа де ла поарта курций кортулуй ера о лукрэтурэ фэкутэ ла гергеф дин фир албастру, пурпуриу, кэрэмизиу ши дин ин субцире рэсучит; авя о лунӂиме де доуэзечь де коць ши ынэлцимя ера де чинч коць, ка лэцимя пынзелор курций; ");
INSERT INTO ron1924_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","чей патру стылпь ай ей ши челе патру пичоаре але лор ерау дин арамэ; кырлиӂеле ши бецеле лор де легэтурэ ерау дин арӂинт, яр кэпэтыеле ерау полеите ку арӂинт. ");
INSERT INTO ron1924_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Тоць цэруший дин журул кортулуй ши курций ерау дин арамэ. ");
INSERT INTO ron1924_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Ятэ сокотяла локашулуй кортулуй ынтылнирий, фэкутэ дупэ порунка луй Мойсе, прин ынгрижиря левицилор, суб кырмуиря луй Итамар, фиул преотулуй Аарон. ");
INSERT INTO ron1924_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Бецалеел, фиул луй Ури, фиул луй Хур, дин семинция луй Иуда, а фэкут тот че порунчисе луй Мойсе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Ел а авут ка ажутор пе Охолиаб, фиул луй Ахисамак, дин семинция луй Дан, мештер ла сэпат ын петре, ла чоплит ку мештешуг ши ла лукрат пе гергеф ын материиле вопсите ын албастру, ын пурпуриу, ын кэрэмизиу ши ын ин субцире. ");
INSERT INTO ron1924_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Тот аурул ынтребуинцат ла лукру пентру тоате лукрэриле Сфынтулуй Локаш, аур ешит дин дарурь, се суя ла доуэзечь ши ноуэ де таланць ши шапте суте трейзечь де сикли, дупэ сиклул кортулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Арӂинтул челор ешиць ла нумэрэтоаре дин адунаре се суя ла о сутэ де таланць ши о мие шапте суте шаптезечь ши чинч де сикли, дупэ сиклул Сфынтулуй Локаш. ");
INSERT INTO ron1924_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Кыте о жумэтате де сиклу де кап, о жумэтате де сиклу, дупэ сиклул Сфынтулуй Локаш, пентру фиекаре ом купринс ын нумэрэтоаре, де ла вырста де доуэзечь де ань ын сус, адикэ пентру шасе суте трей мий чинч суте чинчзечь де оамень. ");
INSERT INTO ron1924_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Дин чей о сутэ де таланць де арӂинт с-ау турнат пичоареле Сфынтулуй Локаш ши пичоареле перделей динэунтру, адикэ о сутэ де пичоаре ла чей о сутэ де таланць, кыте ун талант де пичор. ");
INSERT INTO ron1924_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Ши ку чей о мие шапте суте шаптезечь ши чинч де сикли с-ау фэкут кырлиӂеле ши бецеле де легэтурэ динтре стылпь ши ле-ау полеит кэпэтыеле. ");
INSERT INTO ron1924_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Арама дэруитэ се суя ла шаптезечь де таланць ши доуэ мий патру суте де сикли. ");
INSERT INTO ron1924_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Дин еа ау фэкут пичоареле де ла уша кортулуй ынтылнирий; алтарул де арамэ ку грэтарул луй ши тоате унелтеле алтарулуй; ");
INSERT INTO ron1924_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","пичоареле стылпилор курций де жур ымпрежур ши пичоареле стылпилор де ла поарта курций, ши тоць цэруший дин журул кортулуй ши ай курций. ");
INSERT INTO ron1924_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Ку материиле вопсите ын албастру, ын пурпуриу ши ын кэрэмизиу, ау фэкут вешминтеле преоцилор пентру служба Сфынтулуй Локаш ши ау фэкут вешминте сфинте луй Аарон, кум порунчисе луй Мойсе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Ау фэкут ефодул дин аур, дин фир албастру, пурпуриу ши кэрэмизиу ши дин ин субцире рэсучит. ");
INSERT INTO ron1924_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Ау ынтинс ниште плэчь де аур ши ле-ау тэят ын фире субцирь, пе каре ле-ау цесут ын материиле вопсите ын албастру, ын пурпуриу ши ын кэрэмизиу, ши ын ин субцире; ера лукрат ку мэестрие. ");
INSERT INTO ron1924_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Й-ау фэкут ниште умэрарь каре се ымпреунау ку ел, аша кэ, ла челе доуэ капете але луй, ефодул ера легат ку ей. ");
INSERT INTO ron1924_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Брыул ера де ачеяшь лукрэтурэ ка ефодул ши принс де ел; ера де аур, де фир албастру, пурпуриу ши кэрэмизиу ши де ин субцире рэсучит, кум порунчисе луй Мойсе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Ау прегэтит петреле де оникс, ле-ау принс ын легэтурь де аур ши ау сэпат пе еле нумеле фиилор луй Исраел, кум се сапэ печециле. ");
INSERT INTO ron1924_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Ле-ау пус пе умэрарий ефодулуй ка петре де адучере аминте пентру фиий луй Исраел, кум порунчисе луй Мойсе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Ау фэкут апой пептарул, лукрат ку мэестрие, дин ачеяшь лукрэтурэ ка ефодул: дин аур, дин фир албастру, пурпуриу ши кэрэмизиу ши дин ин субцире рэсучит. ");
INSERT INTO ron1924_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Ера ын патру колцурь. Пептарул л-ау фэкут ындоит; лунӂимя луй ера де о палмэ ши лэцимя, де о палмэ; ера ындоит. ");
INSERT INTO ron1924_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Ау пус ын ел патру ширурь де петре: ын ширул ынтый – ун сардоникс, ун топаз ши ун смаралд; ");
INSERT INTO ron1924_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","ын ал дойля шир – ун рубин, ун сафир ши ун диамант; ");
INSERT INTO ron1924_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","ын ал трейля шир – ун опал, ун агат ши ун аметист; ");
INSERT INTO ron1924_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","яр ын ал патруля шир: ун крисолит, ун оникс ши ун яспис. Петреле ачестя ерау легате ын ферекэтуриле лор де аур. ");
INSERT INTO ron1924_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Ерау доуэспрезече, дупэ нумеле фиилор луй Исраел; ерау сэпате ка ниште печець, фиекаре ку нумеле унея дин челе доуэспрезече семинций. ");
INSERT INTO ron1924_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Пе пептар ау фэкут апой ниште лэнцишоаре де аур курат, ымплетите ка ниште сфорь. ");
INSERT INTO ron1924_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Ау фэкут доуэ ферекэтурь де аур ши доуэ вериӂь де аур ши ау пус челе доуэ вериӂь ла челе доуэ капете але пептарулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Апой челе доуэ лэнцишоаре ымплетите, дин аур ле-ау вырыт ын челе доуэ вериӂь де ла челе доуэ капете але пептарулуй; ");
INSERT INTO ron1924_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","яр челелалте доуэ капете але челор доуэ лэнцишоаре ле-ау агэцат де челе доуэ ферекэтурь ши ле-ау пус пе умэрарий ефодулуй ын партя динаинте. ");
INSERT INTO ron1924_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Ау май фэкут доуэ вериӂь де аур, пе каре ле-ау пус ла челе доуэ капете де жос але пептарулуй, пе марӂиня динэунтру динспре ефод. ");
INSERT INTO ron1924_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Апой ау фэкут алте доуэ вериӂь де аур, пе каре ле-ау пус ла чей дой умэрарь ай ефодулуй жос, пе партя динаинте а луй, токмай аколо унде се ымпреунэ ефодул ку умэрарий, дясупра брыулуй ефодулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Ау легат пептарул ку вериӂиле луй де вериӂиле ефодулуй ку о сфоарэ албастрэ, аша ка пептарул сэ стя цяпэн дясупра брыулуй ефодулуй ши сэ ну се поатэ мишка де пе ефод, кум порунчисе луй Мойсе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Ау фэкут мантия де суб ефод, цесутэ тоатэ ку мештешуг дин материе албастрэ. ");
INSERT INTO ron1924_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Ла мижлокул мантией, сус, ера о гурэ ка гура уней платоше; гура ачаста ера тивитэ де жур ымпрежур, ка сэ ну се рупэ. ");
INSERT INTO ron1924_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Пе марӂиня мантией ау фэкут ниште родий де кулоаре албастрэ, пурпурие ши кэрэмизие, дин фир рэсучит; ");
INSERT INTO ron1924_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","ау фэкут ши ниште клопоцей де аур курат, ши клопоцеий й-ау пус ынтре родий, де жур ымпрежурул мантией: ");
INSERT INTO ron1924_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","веня ун клопоцел ши о родие, ун клопоцел ши о родие пе тоатэ марӂиня димпрежурул мантией, пентру службэ, кум порунчисе луй Мойсе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Ау фэкут ши туничиле дин ин субцире, цесуте ку мэестрие, пентру Аарон ши фиий луй; ");
INSERT INTO ron1924_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","митра дин ин субцире ши скуфииле дин ин субцире каре служяу ка подоабэ; изменеле дин ин субцире рэсучит; ");
INSERT INTO ron1924_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","брыул дин ин субцире рэсучит, лукрат ла гергеф ши де кулоаре албастрэ, пурпурие ши кэрэмизие, кум порунчисе луй Мойсе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Ау фэкут апой ши плака де аур курат, кунуна ымпэрэтяскэ сфынтэ, ши ау сэпат пе еа, кум се сапэ пе о печете: „Сфынт Домнулуй”. ");
INSERT INTO ron1924_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Ау легат-о де митрэ сус ку о сфоарэ албастрэ, кум порунчисе луй Мойсе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Астфел ау фост испрэвите тоате лукрэриле локашулуй кортулуй ынтылнирий. Копиий луй Исраел ау фэкут тот че порунчисе луй Мойсе Домнул: аша ау фэкут. ");
INSERT INTO ron1924_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Ау адус локашул ла Мойсе: кортул ши тоате унелтеле луй, копчиле, скындуриле, друӂий, стылпий ши пичоареле луй; ");
INSERT INTO ron1924_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ынвелитоаря дин пей де бербек вопсите ын рошу, ынвелитоаря дин пей де вицел де маре ши пердяуа де деспэрцире; ");
INSERT INTO ron1924_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","кивотул мэртурией ши друӂий луй, ши капакул испэширий; ");
INSERT INTO ron1924_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","маса ку тоате унелтеле ей ши пыниле пентру пунеря ынаинтя Домнулуй; ");
INSERT INTO ron1924_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","сфешникул де аур курат, канделеле луй ашезате ын рынд ши тоате унелтеле луй, ши унтделемнул пентру сфешник; ");
INSERT INTO ron1924_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","алтарул де аур, унтделемнул пентру унӂере ши тэмыя мироситоаре, ши пердяуа де ла уша кортулуй; ");
INSERT INTO ron1924_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","алтарул де арамэ, грэтарул луй де арамэ, друӂий луй ши тоате унелтеле луй; лигянул ку пичорул луй; ");
INSERT INTO ron1924_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","пынзеле курций, стылпий ей ши пичоареле лор, пердяуа де ла поарта курций, фунииле ей, цэруший ей ши тоате унелтеле пентру служба локашулуй кортулуй ынтылнирий; ");
INSERT INTO ron1924_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","вешминтеле пентру службэ, пентру фэкут служба ын Локул Сфынт, вешминтеле сфинте пентру преотул Аарон ши вешминтеле фиилор луй пентру службеле преоцешть. ");
INSERT INTO ron1924_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Копиий луй Исраел ау фэкут тоате ачесте лукрэрь дупэ тоате порунчиле пе каре ле дэдусе луй Мойсе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Мойсе а черчетат тоате лукрэриле ши ятэ, ле фэкусерэ кум порунчисе Домнул, аша ле фэкусерэ. Ши Мойсе й-а бинекувынтат. ");
INSERT INTO ron1924_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","„Ын зиуа ынтый а луний ынтый, сэ ынтинзь локашул кортулуй ынтылнирий. ");
INSERT INTO ron1924_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Сэ пуй ын ел кивотул мэртурией ши, ынаинтя кивотулуй, сэ атырнь пердяуа динэунтру. ");
INSERT INTO ron1924_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Апой сэ адучь маса ши сэ пуй пе еа челе рындуите. Дупэ ачея, сэ адучь сфешникул ши сэ-й ашезь канделеле. ");
INSERT INTO ron1924_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Алтарул дин аур пентру тэмые сэ-л ашезь ынаинтя кивотулуй мэртурией ши сэ атырнь пердяуа ла уша кортулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Сэ ашезь алтарул пентру ардериле-де-тот ынаинтя уший локашулуй кортулуй ынтылнирий. ");
INSERT INTO ron1924_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Лигянул сэ-л ашезь ынтре кортул ынтылнирий ши алтар ши сэ пуй апэ ын ел. ");
INSERT INTO ron1924_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Сэ ашезь куртя де жур ымпрежур ши сэ пуй пердяуа ла поарта курций. ");
INSERT INTO ron1924_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Сэ ей унтделемнул пентру унӂере, сэ унӂь ку ел кортул ши тот че купринде ел ши сэ-л сфинцешть, ку тоате унелтеле луй, ши ва фи сфынт. ");
INSERT INTO ron1924_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Сэ унӂь алтарул пентру ардериле-де-тот ши тоате унелтеле луй ши сэ сфинцешть алтарул, ши алтарул ва фи прясфынт. ");
INSERT INTO ron1924_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Сэ унӂь лигянул ку пичорул луй ши сэ-л сфинцешть. ");
INSERT INTO ron1924_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Апой сэ адучь пе Аарон ши пе фиий луй ла уша кортулуй ынтылнирий ши сэ-й спель ку апэ. ");
INSERT INTO ron1924_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Сэ ымбрачь пе Аарон ку вешминтеле сфинте, сэ-л унӂь ши сэ-л сфинцешть, ка сэ-Мь факэ служба де преот. ");
INSERT INTO ron1924_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Сэ кемь ши пе фиий луй, сэ-й ымбрачь ку туничиле ");
INSERT INTO ron1924_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","ши сэ-й унӂь кум ай унс пе татэл лор, ка сэ-Мь факэ служба де преоць. Ын путеря ачестей унӂерь, ей вор авя пуруря дрептул преоцией принтре урмаший лор.” ");
INSERT INTO ron1924_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Мойсе а фэкут ынтокмай кум ый порунчисе Домнул; аша а фэкут. ");
INSERT INTO ron1924_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Ын зиуа ынтый а луний ынтый а анулуй ал дойля, кортул ера ашезат. ");
INSERT INTO ron1924_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Мойсе а ашезат кортул; й-а пус пичоареле, а ашезат скындуриле ши вериӂиле ши а ридикат стылпий. ");
INSERT INTO ron1924_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","А ынтинс ынвелитоаря каре служя де акопериш дясупра кортулуй ши пе дясупра а пус ынвелитоаря акоперишулуй кортулуй, кум порунчисе луй Мойсе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Апой а луат мэртурия ши а пус-о ын кивот; а пус друӂий ла кивот ши а ашезат капакул испэширий дясупра кивотулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","А адус кивотул ын корт; а атырнат пердяуа деспэрцитоаре ынаинтя луй ши а акоперит астфел кивотул мэртурией, кум порунчисе луй Мойсе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","А ашезат маса ын кортул ынтылнирий, ын партя де мязэноапте а кортулуй, динкоаче де пердяуа динэунтру; ");
INSERT INTO ron1924_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","ши а пус пе еа пыниле ынаинтя Домнулуй, кум порунчисе луй Мойсе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Апой а ашезат сфешникул ын кортул ынтылнирий, ын фаца месей, ын партя де мязэзи а кортулуй; ");
INSERT INTO ron1924_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","ши й-а ашезат канделеле ынаинтя Домнулуй, кум порунчисе луй Мойсе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Апой а ашезат алтарул де аур ын кортул ынтылнирий ын фаца перделей динэунтру, ");
INSERT INTO ron1924_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","а арс пе ел тэмые мироситоаре, кум порунчисе луй Мойсе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","А ашезат пердяуа ла уша кортулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","А ашезат алтарул пентру ардериле-де-тот ла уша локашулуй кортулуй ынтылнирий ши а адус пе ел ардеря-де-тот ши жертфа де мынкаре, кум порунчисе луй Мойсе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","А ашезат лигянул ынтре кортул ынтылнирий ши алтар ши а пус ын ел апэ пентру спэлат. ");
INSERT INTO ron1924_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Мойсе, Аарон ши фиий луй шь-ау спэлат мыниле ши пичоареле ын ел; ");
INSERT INTO ron1924_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","кынд интрау ын кортул ынтылнирий ши се апропияу де алтар, се спэлау, кум порунчисе луй Мойсе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Апой а ридикат куртя ымпрежурул кортулуй ши алтарулуй ши а пус пердяуа ла поарта курций. Астфел а испрэвит Мойсе лукраря. ");
INSERT INTO ron1924_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Атунч, норул а акоперит кортул ынтылнирий ши слава Домнулуй а умплут кортул. ");
INSERT INTO ron1924_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Мойсе ну путя сэ интре ын кортул ынтылнирий, пентру кэ норул стэтя дясупра луй ши слава Домнулуй умпля кортул. ");
INSERT INTO ron1924_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Кыт ау цинут кэлэторииле лор, копиий луй Исраел порняу нумай кынд се ридика норул дясупра кортулуй. ");
INSERT INTO ron1924_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Ши кынд ну се ридика норул, ну порняу пынэ че ну се ридика. ");
INSERT INTO ron1924_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Норул Домнулуй ера дясупра кортулуй зиуа, яр ноаптя ера ун фок ынаинтя ынтреӂий касе а луй Исраел, ын тимпул тутурор кэлэториилор лор. ");
INSERT INTO ron1924_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Домнул а кемат пе Мойсе, й-а ворбит дин кортул ынтылнирий ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","„Ворбеште копиилор луй Исраел ши спуне-ле: ‘Кынд чинева динтре вой ва адуче ун дар Домнулуй, сэ-л адукэ дин вите, фие дин чирядэ, фие дин турмэ. ");
INSERT INTO ron1924_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Дакэ дарул луй ва фи о ардере-де-тот дин чирядэ, сэ-л адукэ дин партя бэрбэтяскэ фэрэ кусур, ши ануме сэ-л адукэ ла уша кортулуй ынтылнирий, ынаинтя Домнулуй, ка сэ фие плэкут Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Сэ-шь пунэ мына пе капул добитокулуй адус ка ардере-де-тот, ши ва фи примит де Домнул, ка сэ факэ испэшире пентру ел. ");
INSERT INTO ron1924_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Сэ ынжунгие вицелул ынаинтя Домнулуй ши преоций, фиий луй Аарон, сэ адукэ сынӂеле ши сэ-л стропяскэ де жур ымпрежур пе алтарул де ла уша кортулуй ынтылнирий. ");
INSERT INTO ron1924_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Сэ жупоае вицелул адус ка ардере-де-тот ши сэ-л тае ын букэць. ");
INSERT INTO ron1924_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Фиий преотулуй Аарон сэ факэ фок пе алтар ши сэ пунэ лемне пе фок. ");
INSERT INTO ron1924_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Преоций, фиий луй Аарон, сэ ашезе букэциле, капул ши грэсимя пе лемнеле пусе пе фокул де пе алтар. ");
INSERT INTO ron1924_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Сэ спеле ку апэ мэрунтаеле ши пичоареле, ши преотул сэ ле ардэ тоате пе алтар. Ачаста есте о ардере-де-тот, о жертфэ мистуитэ де фок, де ун мирос плэкут Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Дакэ дарул луй ва фи о ардере-де-тот дин турмэ, де мей сау капре, сэ адукэ о парте бэрбэтяскэ фэрэ кусур. ");
INSERT INTO ron1924_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Сэ-л ынжунгие ын партя де мязэноапте а алтарулуй, ынаинтя Домнулуй, ши преоций, фиий луй Аарон, сэ-й стропяскэ сынӂеле пе алтар де жур ымпрежур. ");
INSERT INTO ron1924_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Ел сэ-л тае ын букэць, ши преотул сэ ле пунэ, ымпреунэ ку капул ши грэсимя, пе лемнеле дин фокул де пе алтар. ");
INSERT INTO ron1924_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Сэ спеле ку апэ мэрунтаеле ши пичоареле, ши преотул сэ ле адукэ пе тоате ши сэ ле ардэ пе алтар. Ачаста есте о ардере-де-тот, о жертфэ мистуитэ де фок, де ун мирос плэкут Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Дакэ дарул адус де ел Домнулуй ва фи о ардере-де-тот дин пэсэрь, сэ-л адукэ дин туртуреле сау дин пуй де порумбел. ");
INSERT INTO ron1924_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Преотул сэ адукэ пасэря пе алтар, сэ-й деспиче капул ку унгия ши с-о ардэ пе алтар, яр сынӂеле сэ и се скургэ пе ун перете ал алтарулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Сэ скоатэ гуша ку пенеле ей ши с-о арунче лынгэ алтар, спре рэсэрит, ын локул унде се стрынӂе ченуша. ");
INSERT INTO ron1924_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Сэ-й фрынгэ арипиле, фэрэ сэ ле дезлипяскэ, ши преотул сэ ардэ пасэря пе алтар, пе лемнеле де пе фок. Ачаста есте о ардере-де-тот, о жертфэ мистуитэ де фок, де ун мирос плэкут Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Кынд ва адуче чинева Домнулуй ун дар ка жертфэ де мынкаре, дарул луй сэ фие дин флоаря фэиний: сэ тоарне унтделемн песте еа ши сэ адауӂе ши тэмые. ");
INSERT INTO ron1924_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","С-о адукэ преоцилор, фиилор луй Аарон; преотул сэ я ун пумн дин ачастэ флоаре а фэиний стропитэ ку унтделемн, ымпреунэ ку тоатэ тэмыя, ши с-о ардэ пе алтар ка жертфэ де адучере аминте. Ачеста есте ун дар де мынкаре де ун мирос плэкут Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Че ва рэмыне дин дарул ачеста де мынкаре сэ фие ал луй Аарон ши ал фиилор луй; ачеста есте ун лукру прясфынт ынтре жертфеле де мынкаре мистуите де фок ынаинтя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Дакэ вей адуче ка жертфэ де мынкаре ун дар дин чея че се коаче ын куптор, сэ адучь ниште турте недоспите, фэкуте дин флоаре де фэинэ, фрэмынтате ку унтделемн, ши ниште плэчинте недоспите, стропите ку унтделемн. ");
INSERT INTO ron1924_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Дакэ дарул тэу адус ка жертфэ де мынкаре ва фи о туртэ коаптэ ын тигае, сэ фие фэкутэ дин флоаря фэиний, недоспитэ ши фрэмынтатэ ку унтделемн. ");
INSERT INTO ron1924_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","С-о фрынӂь ын букэць ши сэ торнь унтделемн пе еа; ачеста есте ун дар адус ка жертфэ де мынкаре. ");
INSERT INTO ron1924_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Дакэ дарул тэу адус ка жертфэ де мынкаре ва фи о туртэ коаптэ пе грэтар, сэ фие фэкутэ дин флоаря фэиний, фрэмынтатэ ку унтделемн. ");
INSERT INTO ron1924_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Дарул де мынкаре фэкут дин ачесте лукрурь сэ-л адучь Домнулуй, ши ануме сэ фие дат преотулуй, каре-л ва адуче пе алтар. ");
INSERT INTO ron1924_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Преотул ва луа дин дарул де мынкаре партя каре требуе адусэ ка адучере аминте ши о ва арде пе алтар. Ачеста есте ун дар адус ка жертфэ де мынкаре, де ун мирос плэкут Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Че ва рэмыне дин дарул ачеста де мынкаре сэ фие ал луй Аарон ши ал фиилор луй; ачеста есте ун лукру прясфынт ынтре даруриле мистуите де фок ынаинтя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Ничунул дин даруриле пе каре ле вець адуче ка жертфэ де мынкаре ынаинтя Домнулуй сэ ну фие фэкут ку алуат, кэч ну требуе сэ ардець нимик ку алуат сау ку мьере, ка жертфэ де мынкаре мистуитэ де фок ынаинтя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Ка жертфэ де мынкаре дин челе динтый роаде, вець путя сэ ле адучець Домнулуй, дар ка дар де мынкаре де ун мирос плэкут, сэ ну фие адусе пе алтар. ");
INSERT INTO ron1924_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Тоате даруриле тале де мынкаре сэ ле сэрезь ку саре; сэ ну лашь сэ липсяскэ ничодатэ де пе даруриле тале де мынкаре саря, каре есте семнул легэмынтулуй Думнезеулуй тэу; ла тоате даруриле тале де мынкаре сэ адучь саре. ");
INSERT INTO ron1924_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Дакэ вей адуче Домнулуй ун дар ка жертфэ де мынкаре дин челе динтый роаде, сэ адучь ка дар де мынкаре, дин челе динтый роаде але тале, спиче коапте де курынд, прэжите ла фок ши боабе ной писате. ");
INSERT INTO ron1924_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Сэ торнь унтделемн пе еле ши сэ адауӂь ши тэмые; ачеста есте ун дар де мынкаре. ");
INSERT INTO ron1924_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Преотул сэ ардэ ка адучере аминте о парте дин боабеле писате ши дин унтделемн, ку тоатэ тэмыя. Ачеста есте ун дар адус ка жертфэ де мынкаре, мистуитэ де фок ынаинтя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Кынд чинева ва адуче Домнулуй ун дар ка жертфэ де мулцумире, дакэ ыл ва адуче дин чирядэ, фие парте бэрбэтяскэ, фие парте фемеяскэ, с-о адукэ фэрэ кусур ынаинтя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Сэ пунэ мына пе капул добитокулуй, сэ-л ынжунгие ла уша кортулуй ынтылнирий, ши преоций, фиий луй Аарон, сэ стропяскэ сынӂеле пе алтар де жур ымпрежур. ");
INSERT INTO ron1924_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Дин ачастэ жертфэ де мулцумире, сэ адукэ дрепт жертфэ мистуитэ де фок ынаинтя Домнулуй грэсимя каре акоперэ мэрунтаеле ши тоатэ грэсимя каре цине де мэрунтае, ");
INSERT INTO ron1924_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","чей дой рэрункь ши грэсимя де пе ей ши де пе коапсе ши прапурул де пе фикат, пе каре-л ва дезлипи де лынгэ рэрункь. ");
INSERT INTO ron1924_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Фиий луй Аарон сэ ле ардэ пе алтар, дясупра ардерий-де-тот, каре ва фи пе лемнеле де пе фок. Ачаста есте о жертфэ мистуитэ де фок, де ун мирос плэкут Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Дакэ дарул пе каре-л адуче ка жертфэ де мулцумире Домнулуй ва фи дин турмэ, фие парте бэрбэтяскэ, фие парте фемеяскэ, с-о адукэ фэрэ кусур. ");
INSERT INTO ron1924_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Дакэ ва адуче жертфэ ун мел, сэ-л адукэ ынаинтя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Сэ-шь пунэ мына пе капул добитокулуй ши сэ-л ынжунгие ынаинтя кортулуй ынтылнирий; фиий луй Аарон сэ-й стропяскэ сынӂеле пе алтар, де жур ымпрежур. ");
INSERT INTO ron1924_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Дин ачастэ жертфэ де мулцумире, сэ адукэ о жертфэ мистуитэ де фок ынаинтя Домнулуй, ши ануме: грэсимя, коада ынтрягэ, пе каре о ва десфаче де ла осул спинэрий, грэсимя каре акоперэ мэрунтаеле ши тоатэ грэсимя каре цине де мэрунтае, ");
INSERT INTO ron1924_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","чей дой рэрункь ши грэсимя де пе ей, де пе коапсе, ши прапурул фикатулуй, пе каре-л ва дезлипи де лынгэ рэрункь. ");
INSERT INTO ron1924_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Преотул сэ ле ардэ пе алтар. Ачаста есте мынкаря уней жертфе мистуите де фок ынаинтя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Дакэ дарул луй ва фи о капрэ, с-о адукэ ынаинтя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Сэ-шь пунэ мына пе капул витей ши с-о ынжунгие ынаинтя кортулуй ынтылнирий, ши фиий луй Аарон сэ-й стропяскэ сынӂеле пе алтар, де жур ымпрежур. ");
INSERT INTO ron1924_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Апой, дин еа сэ адукэ дрепт жертфэ мистуитэ де фок ынаинтя Домнулуй: грэсимя каре акоперэ мэрунтаеле ши тоатэ грэсимя каре цине де еле, ");
INSERT INTO ron1924_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","чей дой рэрункь ши грэсимя де пе ей, де пе коапсе, ши прапурул фикатулуй, пе каре-л ва дезлипи де лынгэ рэрункь. ");
INSERT INTO ron1924_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Преотул сэ ле ардэ пе алтар. Ачаста есте мынкаря уней жертфе мистуите де фок, де ун мирос плэкут Домнулуй. Тоатэ грэсимя есте а Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Ачаста есте о леӂе вешникэ пентру урмаший воштри, ын тоате локуриле унде вець локуи. Ку ничун кип сэ ну мынкаць нич грэсиме, нич сынӂе.’” ");
INSERT INTO ron1924_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","„Ворбеште копиилор луй Исраел ши спуне: ‘Кынд ва пэкэтуи чинева фэрэ вое ымпотрива вреунея дин порунчиле Домнулуй, фэкынд лукрурь каре ну требуе фэкуте, ши ануме: ");
INSERT INTO ron1924_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Дакэ а пэкэтуит преотул каре а примит унӂеря ши, прин ачаста, а адус вина асупра попорулуй, сэ адукэ Домнулуй ун вицел фэрэ кусур, ка жертфэ де испэшире пентру пэкатул пе каре л-а фэкут. ");
INSERT INTO ron1924_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Сэ адукэ вицелул ла уша кортулуй ынтылнирий, ынаинтя Домнулуй, сэ-шь пунэ мына пе капул вицелулуй ши сэ-л ынжунгие ынаинтя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Преотул, каре а примит унӂеря, сэ я дин сынӂеле вицелулуй ши сэ-л адукэ ын кортул ынтылнирий, ");
INSERT INTO ron1924_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","сэ-шь ынмоае деӂетул ын сынӂе ши сэ стропяскэ де шапте орь ынаинтя Домнулуй, ын фаца перделей динэунтру а Сфынтулуй Локаш. ");
INSERT INTO ron1924_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Апой, преотул сэ унгэ ку сынӂе коарнеле алтарулуй пентру тэмыя мироситоаре, каре есте ынаинтя Домнулуй ын кортул ынтылнирий, яр тот челэлалт сынӂе ал вицелулуй сэ-л версе ла пичоареле алтарулуй пентру ардериле-де-тот, каре есте ла уша кортулуй ынтылнирий. ");
INSERT INTO ron1924_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Сэ я тоатэ грэсимя вицелулуй адус ка жертфэ де испэшире, ши ануме грэсимя каре акоперэ мэрунтаеле ши тоатэ грэсимя каре цине де еле, ");
INSERT INTO ron1924_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","чей дой рэрункь ши грэсимя де пе ей, де пе коапсе, ши прапурул фикатулуй, пе каре-л ва дезлипи де лынгэ рэрункь. Преотул сэ я ачесте пэрць, ");
INSERT INTO ron1924_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","кум се яу де ла вицелул адус ка жертфэ де мулцумире, ши сэ ле ардэ пе алтарул пентру ардериле-де-тот. ");
INSERT INTO ron1924_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Дар пеля вицелулуй, тоатэ карня луй, ку капул, пичоареле, мэрунтаеле ши балега луй, ");
INSERT INTO ron1924_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","адикэ тот вицелул каре а май рэмас, сэ ле скоатэ афарэ дин табэрэ, ынтр-ун лок курат, унде се арункэ ченуша, ши сэ ле ардэ ку лемне пе фок; сэ фие арсе пе грэмада де ченушэ. ");
INSERT INTO ron1924_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Дакэ тоатэ адунаря луй Исраел а пэкэтуит фэрэ вое ши фэрэ сэ штие, фэкынд ымпотрива унея дин порунчиле Домнулуй лукрурь каре ну требуе фэкуте ши фэкынду-се астфел виноватэ, ");
INSERT INTO ron1924_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","ши дакэ пэкатул сэвыршит с-а дескоперит, адунаря сэ адукэ ун вицел ка жертфэ де испэшире, ши ануме сэ-л адукэ ынаинтя кортулуй ынтылнирий. ");
INSERT INTO ron1924_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Бэтрыний адунэрий сэ-шь пунэ мыниле пе капул вицелулуй ынаинтя Домнулуй ши сэ ынжунгие вицелул ынаинтя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Преотул каре а примит унӂеря сэ адукэ дин сынӂеле вицелулуй ын кортул ынтылнирий, ");
INSERT INTO ron1924_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","сэ-шь ынмоае деӂетул ын сынӂе ши сэ стропяскэ ку ел де шапте орь ынаинтя Домнулуй, ын фаца перделей динэунтру. ");
INSERT INTO ron1924_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Сэ унгэ ку сынӂеле ачеста коарнеле алтарулуй каре есте ынаинтя Домнулуй, ын кортул ынтылнирий, ши сэ версе тот сынӂеле каре а май рэмас ла пичоареле алтарулуй пентру ардериле-де-тот, каре есте ла уша кортулуй ынтылнирий. ");
INSERT INTO ron1924_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Тоатэ грэсимя вицелулуй с-о я ши с-о ардэ пе алтар. ");
INSERT INTO ron1924_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Ку вицелул ачеста сэ факэ ынтокмай кум а фэкут ку вицелул адус ка жертфэ де испэшире; сэ факэ ла фел. Астфел сэ факэ преотул испэшире пентру ей, ши ли се ва ерта. ");
INSERT INTO ron1924_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Вицелул рэмас сэ-л скоатэ апой афарэ дин табэрэ ши сэ-л ардэ ка ши пе вицелул динтый. Ачаста есте о жертфэ де испэшире пентру адунаре. ");
INSERT INTO ron1924_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Дакэ о кэпетение а пэкэтуит фэкынд фэрэ вое ымпотрива унея дин порунчиле Домнулуй Думнезеулуй сэу лукрурь каре ну требуе фэкуте ши с-а фэкут астфел виноватэ ");
INSERT INTO ron1924_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","ши ажунӂе сэ дескопере пэкатул пе каре л-а фэкут, сэ адукэ жертфэ ун цап фэрэ кусур! ");
INSERT INTO ron1924_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Сэ-шь пунэ мына пе капул цапулуй ши сэ-л ынжунгие ын локул унде се ынжунгие ардериле-де-тот ынаинтя Домнулуй. Ачаста есте о жертфэ де испэшире. ");
INSERT INTO ron1924_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Преотул сэ я ку деӂетул дин сынӂеле жертфей де испэшире, сэ унгэ ку ел коарнеле алтарулуй пентру ардериле-де-тот, яр челэлалт сынӂе сэ-л версе ла пичоареле алтарулуй пентру ардериле-де-тот. ");
INSERT INTO ron1924_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Тоатэ грэсимя с-о ардэ пе алтар, кум а арс грэсимя де ла жертфа де мулцумире. Астфел ва фаче преотул пентру кэпетения ачея испэширя пэкатулуй луй, ши и се ва ерта. ");
INSERT INTO ron1924_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Дакэ чинева дин попорул де рынд а пэкэтуит фэрэ вое, фэкынд ымпотрива унея дин порунчиле Домнулуй лукрурь каре ну требуе фэкуте ши с-а фэкут астфел виноват ");
INSERT INTO ron1924_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","ши ажунӂе сэ дескопере пэкатул пе каре л-а фэкут, сэ адукэ жертфэ о ядэ фэрэ кусур пентру пэкатул пе каре л-а фэкут. ");
INSERT INTO ron1924_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Сэ-шь пунэ мына пе капул жертфей де испэшире ши с-о ынжунгие ын локул унде се ынжунгие ардериле-де-тот. ");
INSERT INTO ron1924_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Преотул сэ я ку деӂетул дин сынӂеле жертфей, сэ унгэ коарнеле алтарулуй пентру ардериле-де-тот, яр тот челэлалт сынӂе сэ-л версе ла пичоареле алтарулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Преотул сэ я тоатэ грэсимя, кум се я грэсимя жертфей де мулцумире, ши с-о ардэ пе алтар, ши еа ва фи де ун мирос плэкут Домнулуй. Астфел ва фаче преотул испэширя пентру омул ачеста, ши и се ва ерта. ");
INSERT INTO ron1924_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Дакэ ва адуче ка жертфэ де испэшире ун мел, сэ адукэ о парте фемеяскэ фэрэ кусур. ");
INSERT INTO ron1924_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Сэ-шь пунэ мына пе капул жертфей ши с-о ынжунгие ка жертфэ де испэшире ын локул унде се ынжунгие ардериле-де-тот. ");
INSERT INTO ron1924_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Преотул сэ я ку деӂетул дин сынӂеле жертфей, сэ унгэ ку ел коарнеле алтарулуй пентру ардериле-де-тот, яр тот челэлалт сынӂе сэ-л версе ла пичоареле алтарулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Преотул сэ я тоатэ грэсимя, кум се я грэсимя мелулуй адус ка жертфэ де мулцумире, ши с-о ардэ пе алтар, песте жертфеле мистуите де фок ынаинтя Домнулуй. Астфел ва фаче преотул пентру омул ачеста испэширя пэкатулуй пе каре л-а сэвыршит, ши и се ва ерта. ");
INSERT INTO ron1924_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Кынд чинева, фиинд пус суб журэмынт ка мартор, ва пэкэтуи неспунынд че а вэзут сау че штие ши ва кэдя астфел суб винэ ");
INSERT INTO ron1924_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","сау кынд чинева, фэрэ сэ штие, се ва атинӂе де чева некурат, фие де хойтул уней фяре сэлбатиче некурате, фие де хойтул уней вите де касэ некурате, фие де хойтул уней тырытоаре некурате, ши ва бэга апой де сямэ ши се ва фаче астфел виноват ");
INSERT INTO ron1924_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","сау кынд чинева, фэрэ сэ я сяма, се ва атинӂе де врео спуркэчуне оменяскэ, де орьче спуркэчуне каре фаче пе чинева некурат, ши ва бэга де сямэ май тырзиу ши се ва фаче астфел виноват ");
INSERT INTO ron1924_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","сау кынд чинева, ворбинд ку ушуринцэ, журэ кэ аре сэ факэ чева рэу сау бине ши, небэгынд де сямэ ла ынчепут, багэ де сямэ май тырзиу ши се ва фаче астфел виноват – ");
INSERT INTO ron1924_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","кынд чинева деч се ва фаче виноват де унул дин ачесте лукрурь, требуе сэ-шь мэртурисяскэ пэкатул. ");
INSERT INTO ron1924_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Апой, сэ адукэ луй Думнезеу ка жертфэ де винэ пентру пэкатул пе каре л-а фэкут о парте фемеяскэ дин турмэ, ши ануме о оае сау о капрэ, ка жертфэ испэшитоаре, ши преотул сэ факэ пентру ел испэширя пэкатулуй луй. ");
INSERT INTO ron1924_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Дакэ ну ва путя сэ адукэ о оае сау о капрэ, сэ адукэ Домнулуй ка жертфэ де винэ пентру пэкатул луй доуэ туртуреле сау дой пуй де порумбел, унул ка жертфэ де испэшире, яр челэлалт ка ардере-де-тот. ");
INSERT INTO ron1924_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Сэ ле адукэ преотулуй, каре ва жертфи ынтый пе чя каре аре сэ служяскэ дрепт жертфэ де испэшире. Преотул сэ-й фрынгэ ку унгия капул де ла грумаз, фэрэ сэ-л деспартэ, ");
INSERT INTO ron1924_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","сэ стропяскэ ун перете ал алтарулуй ку сынӂеле жертфей де испэшире, яр челэлалт сынӂе сэ-л стоаркэ ла пичоареле алтарулуй – ачаста есте о жертфэ де испэшире. ");
INSERT INTO ron1924_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Чялалтэ пасэре с-о прегэтяскэ дрепт ардере-де-тот, дупэ рындуелиле ашезате. Астфел ва фаче преотул пентру омул ачеста испэширя пэкатулуй пе каре л-а фэкут, ши и се ва ерта. ");
INSERT INTO ron1924_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Дакэ ну поате сэ адукэ нич доуэ туртуреле сау дой пуй де порумбел, сэ адукэ пентру пэкатул луй, ка дар, а зечя парте динтр-о ефэ де флоаря фэиний, ши ануме ка дар де испэшире; сэ ну пунэ унтделемн пе еа ши сэ ну адауӂе нич тэмые, кэч есте ун дар де испэшире. ");
INSERT INTO ron1924_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","С-о адукэ ла преот, ши преотул сэ я дин еа ун пумн плин, ка адучере аминте, ши с-о ардэ пе алтар, ка ши пе даруриле де мынкаре мистуите де фок ынаинтя Домнулуй – ачеста есте ун дар де испэшире. ");
INSERT INTO ron1924_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Астфел ва фаче преотул пентру омул ачела испэширя пэкатулуй пе каре л-а фэкут фацэ де унул дин ачесте лукрурь, ши и се ва ерта. Чялалтэ парте каре ва май рэмыне дин дарул ачеста сэ фие а преотулуй, ка ши ла дарул де мынкаре.’” ");
INSERT INTO ron1924_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","„Кынд чинева ва фаче о нелеӂюире ши ва пэкэтуи фэрэ вое фацэ де лукруриле ынкинате Домнулуй, сэ адукэ Домнулуй ка жертфэ де винэ пентру пэкатул луй ун бербек фэрэ кусур дин турмэ, дупэ прецуиря та, ын сикли де арӂинт, дупэ сиклул Сфынтулуй Локаш. ");
INSERT INTO ron1924_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Сэ май адауӂе а чинчя парте ла прецул лукрулуй ку каре а ыншелат Сфынтул Локаш ши сэ-л ынкрединцезе преотулуй. Ши преотул сэ факэ испэшире пентру ел ку бербекул адус ка жертфэ пентру винэ, ши и се ва ерта. ");
INSERT INTO ron1924_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Кынд ва пэкэтуи чинева фэкынд, фэрэ сэ штие, ымпотрива унея дин порунчиле Домнулуй лукрурь каре ну требуе фэкуте ши се ва фаче виноват, пуртынду-шь астфел вина, ");
INSERT INTO ron1924_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","сэ адукэ преотулуй ка жертфэ пентру винэ ун бербек фэрэ кусур, луат дин турмэ, дупэ прецуиря та. Ши преотул сэ факэ пентру ел испэширя грешелий пе каре а фэкут-о фэрэ сэ штие, ши и се ва ерта. ");
INSERT INTO ron1924_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Ачаста есте о жертфэ пентру винэ. Омул ачеста се фэкусе виноват фацэ де Домнул.” ");
INSERT INTO ron1924_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","„Кынд ва пэкэтуи чинева ши ва сэвырши о нелеӂюире фацэ де Домнул, тэгэдуинд апроапелуй сэу ун лукру ынкрединцат луй сау дат ын пэстраря луй сау луат ку сила, сау ва ыншела пе апроапеле луй, ");
INSERT INTO ron1924_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","тэгэдуинд кэ а гэсит ун лукру пердут сау фэкынд ун журэмынт стрымб ку привире ла ун лукру оарекаре пе каре-л фаче омул ши пэкэтуеште, ");
INSERT INTO ron1924_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","кынд ва пэкэтуи астфел ши се ва фаче виноват, сэ дя ынапой лукрул луат ку сила сау луат прин ыншелэчуне, сау ынкрединцат луй, сау лукрул пердут пе каре л-а гэсит, ");
INSERT INTO ron1924_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","сау лукрул пентру каре а фэкут ун журэмынт стрымб – орькаре ар фи – сэ-л дя ынапой ынтрег, сэ май адауӂе а чинчя парте дин прецул луй ши сэ-л дя ын мына стэпынулуй луй, кяр ын зиуа кынд ышь ва адуче жертфа луй пентру винэ. ");
INSERT INTO ron1924_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Яр ка жертфэ пентру винэ, сэ адукэ Домнулуй пентру пэкатул луй ун бербек фэрэ кусур, луат дин турмэ, дупэ прецуиря та, ши сэ-л дя преотулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Ши преотул ва фаче пентру ел испэширя ынаинтя Домнулуй, ши и се ва ерта, орькаре ар фи грешяла де каре се ва фи фэкут виноват.” ");
INSERT INTO ron1924_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","„Дэ урмэтоаря порункэ луй Аарон ши фиилор сэй ши зи: ‘Ятэ леӂя ардерий-де-тот. Ардеря-де-тот сэ рэмынэ пе ватра алтарулуй тоатэ ноаптя, пынэ диминяца, ши ын фелул ачеста фокул сэ ардэ пе алтар. ");
INSERT INTO ron1924_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Преотул сэ се ымбраче ку туника де ин, сэ-шь акопере голичуня ку изменеле, сэ я ченуша фэкутэ де фокул каре ва мистуи ардеря-де-тот де пе алтар ши с-о версе лынгэ алтар. ");
INSERT INTO ron1924_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Апой сэ се дезбраче де вешминтеле луй ши сэ се ымбраче ку алтеле, ка сэ скоатэ ченуша афарэ дин табэрэ, ынтр-ун лок курат. ");
INSERT INTO ron1924_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Фокул сэ ардэ пе алтар ши сэ ну се стингэ делок: ын фиекаре диминяцэ, преотул сэ априндэ лемне пе алтар, сэ ашезе ардеря-де-тот пе еле ши сэ ардэ дясупра грэсимя жертфелор де мулцумире. ");
INSERT INTO ron1924_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Фокул сэ ардэ некурмат пе алтар ши сэ ну се стингэ делок. ");
INSERT INTO ron1924_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Ятэ леӂя дарулуй адус ка жертфэ де мынкаре. Фиий луй Аарон с-о адукэ ынаинтя Домнулуй, ынаинтя алтарулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Преотул сэ я ун пумн дин флоаря фэиний ши дин унтделемн, ку тоатэ тэмыя адэугатэ ла дарул де мынкаре, ши с-о ардэ пе алтар ка адучере аминте де ун мирос плэкут Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Аарон ши фиий луй сэ мэнынче че ва май рэмыне дин дарул де мынкаре; с-о мэнынче фэрэ алуат, ынтр-ун лок сфынт, ын куртя кортулуй ынтылнирий. ");
INSERT INTO ron1924_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Сэ н-о коакэ ку алуат. Ачаста есте партя пе каре ле-ам дат-о Еу дин даруриле Меле де мынкаре мистуите де фок. Еа есте ун лукру прясфынт, ка ши жертфа де испэшире ши ка ши жертфа пентру винэ. ");
INSERT INTO ron1924_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Тоатэ партя бэрбэтяскэ динтре копиий луй Аарон сэ мэнынче дин еа. Ачаста есте о леӂе вешникэ пентру урмаший воштри, ку привире ла даруриле де мынкаре мистуите де фок ынаинтя Домнулуй: орьчине се ва атинӂе де еле ва фи сфинцит.’” ");
INSERT INTO ron1924_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","„Ятэ дарул пе каре ыл вор фаче Домнулуй Аарон ши фиий луй ын зиуа кынд вор прими унӂеря: а зечя парте динтр-о ефэ де флоаря фэиний, ка дар де мынкаре вешник, жумэтате диминяца ши жумэтате сяра, ");
INSERT INTO ron1924_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","сэ фие прегэтитэ ын тигае ку унтделемн ши с-о адучь прэжитэ; с-о адучь коаптэ ши тэятэ ын букэць, ка ун дар де мынкаре де ун мирос плэкут Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Преотул динтре фиий луй Аарон каре ва фи унс ын локул луй сэ адукэ дарул ачеста ка жертфэ де мынкаре. Ачаста есте о леӂе вешникэ ынаинтя Домнулуй: сэ фие арсэ ынтрягэ. ");
INSERT INTO ron1924_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Орьче дар де мынкаре ал унуй преот сэ фие арс ын ынтреӂиме: сэ ну се мэнынче.” ");
INSERT INTO ron1924_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","„Ворбеште луй Аарон ши фиилор луй ши зи-ле: ‘Ятэ леӂя жертфей де испэшире. Вита пентру жертфа де испэшире сэ фие ынжунгиятэ ынаинтя Домнулуй ын локул унде се ынжунгие ардеря-де-тот: еа есте ун лукру прясфынт. ");
INSERT INTO ron1924_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Преотул каре ва адуче жертфа де испэшире, ачела с-о мэнынче, ши ануме сэ фие мынкатэ ынтр-ун лок сфынт, ын куртя кортулуй ынтылнирий. ");
INSERT INTO ron1924_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Орьчине се ва атинӂе де карня ей ва фи сфинцит. Дакэ ва сэри сынӂе дин еа пе вреун вешмынт, локул стропит ку сынӂе сэ фие спэлат ынтр-ун лок сфынт. ");
INSERT INTO ron1924_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Васул де пэмынт ын каре се ва фербе сэ се спаргэ; дакэ с-а ферт ынтр-ун вас де арамэ, васул сэ фие фрекат ши спэлат ку апэ. ");
INSERT INTO ron1924_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Тоатэ партя бэрбэтяскэ динтре преоць сэ мэнынче дин еа: еа есте ун лукру прясфынт. ");
INSERT INTO ron1924_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Дар сэ ну се мэнынче ничо жертфэ де испэшире дин ал кэрей сынӂе се ва адуче ын кортул ынтылнирий пентру фачеря испэширий ын Сфынтул Локаш, чи ачея сэ фие арсэ ын фок. ");
INSERT INTO ron1924_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Ятэ леӂя жертфей пентру винэ: еа есте ун лукру прясфынт. ");
INSERT INTO ron1924_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Ын локул унде се ынжунгие ардеря-де-тот, сэ се ынжунгие ши вита каре служеште ка жертфэ пентру винэ. Сынӂеле ей сэ се стропяскэ пе алтар де жур ымпрежур. ");
INSERT INTO ron1924_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Сэ и се адукэ тоатэ грэсимя, коада, грэсимя каре акоперэ мэрунтаеле, ");
INSERT INTO ron1924_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","чей дой рэрункь ши грэсимя де пе ей, де пе коапсе, ши прапурул фикатулуй, каре ва фи дезлипит де лынгэ рэрункь. ");
INSERT INTO ron1924_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Преотул сэ ле ардэ пе алтар ка жертфэ мистуитэ де фок ынаинтя Домнулуй. Ачаста есте о жертфэ пентру винэ. ");
INSERT INTO ron1924_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Тоатэ партя бэрбэтяскэ динтре преоць сэ мэнынче дин еа, ши ануме с-о мэнынче ынтр-ун лок сфынт, кэч есте ун лукру прясфынт. ");
INSERT INTO ron1924_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Ку жертфа пентру винэ есте ка ши ку жертфа де испэшире; ачеяшь леӂе есте пентру амындоуэ ачесте жертфе: вита жертфитэ ва фи а преотулуй каре ва фаче испэширя. ");
INSERT INTO ron1924_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Преотул каре ва адуче ардеря-де-тот а куйва сэ айбэ пентру ел пеля ардерий-де-тот пе каре а адус-о. ");
INSERT INTO ron1924_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Орьче жертфэ де мынкаре коаптэ ын куптор, гэтитэ пе грэтар сау ын тигае сэ фие а преотулуй каре а адус-о. ");
INSERT INTO ron1924_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Яр орьче жертфэ де мынкаре фрэмынтатэ ку унтделемн ши ускатэ сэ фие а тутурор фиилор луй Аарон, а унуя ка ши а челуйлалт. ");
INSERT INTO ron1924_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Ятэ леӂя жертфей де мулцумире, каре се ва адуче Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Дакэ чинева о адуче ка жертфэ де лаудэ, сэ адукэ, ымпреунэ ку жертфа де мулцумире, ниште турте недоспите, фрэмынтате ку унтделемн, ниште плэчинте недоспите, стропите ку унтделемн, ши ниште турте дин флоаря де фэинэ, прэжите ши фрэмынтате ку унтделемн. ");
INSERT INTO ron1924_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Пе лынгэ ачесте турте, сэ адукэ ши пыне доспитэ пентру дарул луй де мынкаре, ымпреунэ ку жертфа луй де лаудэ ши де мулцумире. ");
INSERT INTO ron1924_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Дин тоате ачеле дарурь сэ адукэ Домнулуй кыте о букатэ ка дар ридикат; еа сэ фие а преотулуй каре стропеште сынӂеле жертфей де мулцумире. ");
INSERT INTO ron1924_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Карня жертфей де лаудэ ши де мулцумире сэ фие мынкатэ кяр ын зиуа ын каре есте адусэ; сэ ну се ласе нимик дин еа пынэ диминяца. ");
INSERT INTO ron1924_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Дакэ адуче чинева о жертфэ пентру ымплиниря уней журуинце сау ка дар де бунэвое, жертфа сэ фие мынкатэ кяр ын зиуа кынд о ва адуче, яр че ва рэмыне дин еа сэ се мэнынче а доуа зи. ");
INSERT INTO ron1924_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Че ва май рэмыне дин карня витей пынэ а трея зи сэ фие арс ын фок. ");
INSERT INTO ron1924_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Дакэ с-ар ынтымпла сэ мэнынче чинева а трея зи дин карня жертфей луй де мулцумире, жертфа луй ну ва фи примитэ ши ну се ва цине ын сямэ челуй че а адус-о, чи ва фи ун лукру урычос ши орьчине ва мынка дин еа ышь ва пурта вина. ");
INSERT INTO ron1924_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Нич карня каре с-а атинс де чева некурат ну требуе мынкатэ, чи требуе арсэ ын фок. Орьче ом курат поате сэ мэнынче карне, ");
INSERT INTO ron1924_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","дар ачела каре, гэсинду-се ын старе де некурэцение, ва мынка дин карня жертфей де мулцумире, каре есте а Домнулуй, сэ фие нимичит дин попорул сэу. ");
INSERT INTO ron1924_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Ши чине се ва атинӂе де чева некурат, фие де врео спуркэчуне оменяскэ, фие де ун добиток некурат, фие де о алтэ спуркэчуне, ши ва мынка дин карня жертфей де мулцумире, каре есте а Домнулуй, сэ фие нимичит дин попорул сэу.’” ");
INSERT INTO ron1924_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","„Ворбеште копиилор луй Исраел ши спуне: ‘Сэ ну мынкаць грэсиме де боу, де мел сау де капрэ. ");
INSERT INTO ron1924_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Грэсимя унуй добиток морт сау сфышият де фярэ ва путя сэ фие ынтребуинцатэ ла орьче алтчева, нумай сэ н-о мынкаць. ");
INSERT INTO ron1924_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Кэч чине ва мынка дин грэсимя добитоачелор дин каре се адук Домнулуй жертфе мистуите де фок ва фи нимичит дин попорул сэу. ");
INSERT INTO ron1924_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Сэ ну мынкаць сынӂе, нич де пасэре, нич де витэ, ын тоате локуриле ын каре вець локуи. ");
INSERT INTO ron1924_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Чине ва мынка вреун фел де сынӂе ва фи нимичит дин попорул сэу!’” ");
INSERT INTO ron1924_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","„Ворбеште копиилор луй Исраел ши спуне-ле: ‘Чине ва адуче Домнулуй жертфа луй де мулцумире сэ адукэ Домнулуй дарул луй, луат дин жертфа луй де мулцумире. ");
INSERT INTO ron1924_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Сэ адукэ ку мыниле луй чея че требуе мистуит де фок ынаинтя Домнулуй, ши ануме сэ адукэ грэсимя ку пептул, пептул ка сэ-л леӂене ынтр-о парте ши ынтр-алта, ка дар легэнат ынаинтя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Преотул сэ ардэ грэсимя пе алтар, яр пептул сэ фие ал луй Аарон ши ал фиилор луй. ");
INSERT INTO ron1924_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Дин жертфеле воастре де мулцумире, сэ даць преотулуй ши спата дряптэ, адукынд-о ка дар луат прин ридикаре. ");
INSERT INTO ron1924_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Спата ачея дряптэ сэ фие партя ачелуя динтре фиий луй Аарон каре ва адуче сынӂеле ши грэсимя жертфей де мулцумире. ");
INSERT INTO ron1924_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Кэч Еу яу дин жертфеле де мулцумире адусе де копиий луй Исраел: пептул, каре ва фи легэнат ынтр-о парте ши ынтр-алта, ка дар легэнат, ши спата, каре ва фи адусэ ка дар луат прин ридикаре, ши ле дау преотулуй Аарон ши фиилор луй, принтр-о леӂе вешникэ, пе каре о вор пэзи тотдяуна копиий луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Ачеста есте дрептул пе каре ли-л ва да унӂеря луй Аарон ши а фиилор луй асупра жертфелор мистуите де фок ынаинтя Домнулуй, дин зиуа кынд вор фи ынфэцишаць ка сэ фие ын служба Мя ка преоць. ");
INSERT INTO ron1924_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Ятэ че порунчеште Домнул сэ ле дя копиий луй Исраел дин зиуа унӂерий лор; ачаста ва фи о леӂе вешникэ принтре урмаший лор.’” ");
INSERT INTO ron1924_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Ачаста есте леӂя ардерий-де-тот, а дарулуй де мынкаре, а жертфей де испэшире, а жертфей пентру винэ, а ынкинэрий ын служба Домнулуй ши а жертфей де мулцумире. ");
INSERT INTO ron1924_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Домнул а дат-о луй Мойсе пе мунтеле Синай ын зиуа кынд а порунчит копиилор луй Исраел сэ-шь адукэ даруриле ынаинтя Домнулуй, ын пустиул Синай. ");
INSERT INTO ron1924_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","„Я пе Аарон ши пе фиий луй ымпреунэ ку ел, вешминтеле, унтделемнул пентру унӂере, вицелул пентру жертфа де испэшире, чей дой бербечь ши кошул ку азимиле ");
INSERT INTO ron1924_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","ши кямэ тоатэ адунаря ла уша кортулуй ынтылнирий.” ");
INSERT INTO ron1924_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Мойсе а фэкут кум ый порунчисе Домнул, ши адунаря с-а стрынс ла уша кортулуй ынтылнирий. ");
INSERT INTO ron1924_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Мойсе а зис адунэрий: „Ятэ че а порунчит Домнул сэ се факэ.” ");
INSERT INTO ron1924_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Мойсе а адус пе Аарон ши пе фиий луй ши й-а спэлат ку апэ. ");
INSERT INTO ron1924_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","А пус туника пе Аарон, л-а ынчинс ку брыул, л-а ымбрэкат ку мантия ши а пус пе ел ефодул, пе каре л-а стрынс ку брыул ефодулуй ку каре л-а ымбрэкат. ");
INSERT INTO ron1924_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Й-а пус пептарул ши а пус ын пептар Урим ши Тумим. ");
INSERT INTO ron1924_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Й-а пус митра пе кап, яр пе партя динаинте а митрей а ашезат плака де аур, кунуна ымпэрэтяскэ сфынтэ, кум порунчисе луй Мойсе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Мойсе а луат унтделемнул пентру унӂере, а унс Сфынтул Локаш ши тоате лукруриле каре ерау ын ел ши ле-а сфинцит. ");
INSERT INTO ron1924_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","А стропит ку ел алтарул де шапте орь ши а унс алтарул ши тоате унелтеле луй, ши лигянул ку пичорул луй, ка сэ ле сфинцяскэ. ");
INSERT INTO ron1924_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Дин унтделемнул пентру унӂере а турнат пе капул луй Аарон ши л-а унс, ка сэ-л сфинцяскэ. ");
INSERT INTO ron1924_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Мойсе а адус ши пе фиий луй Аарон; й-а ымбрэкат ку туничиле, й-а ынчинс ку брыеле ши ле-а легат скуфииле, кум порунчисе луй Мойсе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","А апропият апой вицелул адус ка жертфэ де испэшире, ши Аарон ши фиий луй шь-ау пус мыниле пе капул вицелулуй адус ка жертфэ де испэшире. ");
INSERT INTO ron1924_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Мойсе л-а ынжунгият, а луат сынӂе ши а унс ку деӂетул коарнеле алтарулуй де жур ымпрежур ши а курэцит алтарул; челэлалт сынӂе л-а турнат ла пичоареле алтарулуй ши л-а сфинцит астфел, фэкынд испэшире пентру ел. ");
INSERT INTO ron1924_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","А луат апой тоатэ грэсимя каре акоперэ мэрунтаеле, прапурул фикатулуй, чей дой рэрункь ку грэсимя лор ши ле-а арс пе алтар. ");
INSERT INTO ron1924_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Яр чялалтэ парте каре а май рэмас дин вицел, ши ануме пеля, карня ши балега, а арс-о ын фок, афарэ дин табэрэ, кум порунчисе луй Мойсе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","А апропият апой бербекул пентру ардеря-де-тот, ши Аарон ши фиий луй шь-ау пус мыниле пе капул бербекулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Мойсе л-а ынжунгият ши а стропит сынӂеле пе алтар де жур ымпрежур. ");
INSERT INTO ron1924_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","А тэят бербекул ын букэць ши а арс капул, букэциле ши грэсимя. ");
INSERT INTO ron1924_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","А спэлат ку апэ мэрунтаеле ши пичоареле ши а арс тот бербекул пе алтар; ачаста а фост ардеря-де-тот, о жертфэ мистуитэ де фок, де ун мирос плэкут Домнулуй, кум порунчисе луй Мойсе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","А адус апой челэлалт бербек, адикэ бербекул пентру ынкинаря ын служба Домнулуй, ши Аарон ши фиий луй шь-ау пус мыниле пе капул бербекулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Мойсе а ынжунгият бербекул, а луат дин сынӂеле луй ши а пус пе марӂиня урекий дрепте а луй Аарон, пе деӂетул чел маре ал мыний дрепте ши пе деӂетул чел маре де ла пичорул луй чел дрепт. ");
INSERT INTO ron1924_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","А адус пе фиий луй Аарон, а пус сынӂе пе марӂиня урекий лор дрепте, пе деӂетул чел маре ал мыний дрепте ши пе деӂетул чел маре де ла пичорул лор чел дрепт, яр сынӂеле рэмас л-а стропит пе алтар де жур ымпрежур. ");
INSERT INTO ron1924_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","А луат грэсимя, коада, тоатэ грэсимя каре акоперэ мэрунтаеле, прапурул фикатулуй, чей дой рэрункь ку грэсимя лор ши спата дряптэ; ");
INSERT INTO ron1924_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","а луат, де асеменя, дин кошул ку азиме пус ынаинтя Домнулуй о туртэ фэрэ алуат, о туртэ де пыне фэкутэ ку унтделемн ши о плэчинтэ ши ле-а пус пе грэсиме ши пе спата дряптэ. ");
INSERT INTO ron1924_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Тоате ачесте лукрурь ле-а пус ын мыниле луй Аарон ши ын мыниле фиилор сэй ши ле-а легэнат ынтр-о парте ши ынтр-алта, ка дар легэнат ынаинтя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Апой, Мойсе ле-а луат дин мыниле лор ши ле-а арс пе алтар, дясупра ардерий-де-тот; ачаста а фост жертфа де ынкинаре ын служба Домнулуй, о жертфэ мистуитэ де фок, де ун мирос плэкут Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Мойсе а луат пептул бербекулуй де ынкинаре ын служба Домнулуй ши л-а легэнат ынтр-о парте ши ынтр-алта, ка дар легэнат ынаинтя Домнулуй; ачаста а фост партя луй Мойсе, кум порунчисе луй Мойсе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Мойсе а луат дин унтделемнул пентру унӂере ши дин сынӂеле де пе алтар; а стропит ку ел пе Аарон ши вешминтеле луй, пе фиий луй Аарон ши вешминтеле лор ши а сфинцит астфел пе Аарон ши вешминтеле луй, пе фиий луй Аарон ши вешминтеле лор ымпреунэ ку ел. ");
INSERT INTO ron1924_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Мойсе а зис луй Аарон ши фиилор луй: „Фербець карня ла уша кортулуй ынтылнирий; аколо с-о мынкаць, ымпреунэ ку пыня каре есте ын кош пентру жертфа де ынкинаре ын служба Домнулуй, кум ам порунчит зикынд: ‘Аарон ши фиий луй с-о мэнынче.’ ");
INSERT INTO ron1924_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Яр партя каре ва май рэмыне дин карне ши дин пыне с-о ардець ын фок. ");
INSERT INTO ron1924_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Тимп де шапте зиле сэ ну ешиць делок дин уша кортулуй ынтылнирий, пынэ се вор ымплини зилеле пентру ынкинаря воастрэ ын служба Домнулуй; кэч шапте зиле се вор ынтребуинца пентру ынкинаря воастрэ ын служба Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Че с-а фэкут азь, Домнул а порунчит сэ се факэ ши де акум ынколо ка испэшире пентру вой. ");
INSERT INTO ron1924_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Сэ рэмынець дар шапте зиле ла уша кортулуй ынтылнирий, зи ши ноапте, ши сэ пэзиць порунчиле Домнулуй, ка сэ ну муриць; кэч аша ми с-а порунчит.” ");
INSERT INTO ron1924_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Аарон ши фиий луй ау фэкут тоате челе порунчите де Домнул прин Мойсе. ");
INSERT INTO ron1924_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Ын зиуа а опта, Мойсе а кемат пе Аарон ши пе фиий луй ши пе бэтрыний луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Ши а зис луй Аарон: „Я ун вицел пентру жертфа де испэшире ши ун бербек пентру ардеря-де-тот, амындой фэрэ кусур, ши аду-й ынаинтя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Сэ ворбешть копиилор луй Исраел ши сэ ле спуй: ‘Луаць ун цап пентру жертфа де испэшире, ун вицел ши ун мел де ун ан ши фэрэ кусур пентру ардеря-де-тот; ");
INSERT INTO ron1924_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","ун таур ши ун бербек пентру жертфа де мулцумире, ка сэ-й жертфиць ынаинтя Домнулуй, ши ун дар де мынкаре фрэмынтат ку унтделемн. Кэч азь ви се ва арэта Домнул.’” ");
INSERT INTO ron1924_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Ей ау адус ынаинтя кортулуй ынтылнирий тот че порунчисе Мойсе, ши тоатэ адунаря с-а апропият ши а стат ынаинтя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Мойсе а зис: „Сэ фачець че а порунчит Домнул, ши ви се ва арэта слава Домнулуй.” ");
INSERT INTO ron1924_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Мойсе а зис луй Аарон: „Апропие-те де алтар, аду-ць жертфа та де испэшире ши ардеря та де тот ши фэ испэшире пентру тине ши пентру попор; аду ши жертфа попорулуй ши фэ испэшире пентру ел, кум а порунчит Домнул.” ");
INSERT INTO ron1924_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Аарон с-а апропият де алтар ши а ынжунгият вицелул пентру жертфа луй де испэшире. ");
INSERT INTO ron1924_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Фиий луй Аарон ау адус сынӂеле ла ел; ел шь-а ынмуят деӂетул ын сынӂе, а унс коарнеле алтарулуй, яр челэлалт сынӂе л-а турнат ла пичоареле алтарулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","А арс пе алтар грэсимя, рэрункий ши прапурул фикатулуй де ла вицелул пентру жертфа де испэшире, кум порунчисе луй Мойсе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Яр карня ши пеля ле-а арс ын фок афарэ дин табэрэ. ");
INSERT INTO ron1924_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","А ынжунгият апой ардеря-де-тот. Фиий луй Аарон ау адус сынӂеле ла ел, ши ел л-а стропит пе алтар де жур ымпрежур. ");
INSERT INTO ron1924_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Й-ау адус ши ардеря-де-тот тэятэ ын букэць, ку кап ку тот, ши а арс-о пе алтар. ");
INSERT INTO ron1924_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","А спэлат мэрунтаеле ши пичоареле ши ле-а арс пе алтар, дясупра ардерий-де-тот. ");
INSERT INTO ron1924_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Ын урмэ, а адус жертфа пентру попор. А луат цапул пентру жертфа де испэшире а попорулуй, л-а ынжунгият ши л-а адус жертфэ де испэшире, ка ши пе чя динтый жертфэ. ");
INSERT INTO ron1924_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","А адус апой ардеря-де-тот ши а жертфит-о, дупэ рындуелиле ашезате. ");
INSERT INTO ron1924_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","А адус ши жертфа де мынкаре, а умплут ун пумн дин еа ши а арс-о пе алтар, афарэ де ардеря-де-тот де диминяцэ. ");
INSERT INTO ron1924_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","А ынжунгият апой таурул ши бербекул ка жертфэ де мулцумире пентру попор. Фиий луй Аарон ау адус сынӂеле ла ел, ши ел а стропит пе алтар де жур ымпрежур. ");
INSERT INTO ron1924_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Й-ау адус апой грэсимя таурулуй ши а бербекулуй, коада, грэсимя каре акоперэ мэрунтаеле, рэрункий ши прапурул фикатулуй; ");
INSERT INTO ron1924_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","ау пус грэсимиле ачестя дясупра пептурилор ши ел а арс грэсимиле пе алтар. ");
INSERT INTO ron1924_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Аарон а легэнат ынтр-о парте ши ынтр-алта, ка дар легэнат ынаинтя Домнулуй, пептуриле ши спата дряптэ, кум порунчисе луй Мойсе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Аарон шь-а ридикат мыниле спре попор ши л-а бинекувынтат. Апой, дупэ че а адус жертфа де испэшире, ардеря-де-тот ши жертфа де мулцумире, с-а коборыт. ");
INSERT INTO ron1924_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Мойсе ши Аарон ау интрат ын кортул ынтылнирий. Кынд ау ешит дин ел, ау бинекувынтат попорул. Ши слава Домнулуй с-а арэтат ынтрегулуй попор. ");
INSERT INTO ron1924_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Ун фок а ешит динаинтя Домнулуй ши а мистуит пе алтар ардеря-де-тот ши грэсимиле. Тот попорул а вэзут лукрул ачеста; ау скос стригэте де букурие ши с-ау арункат ку фаца ла пэмынт. ");
INSERT INTO ron1924_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Фиий луй Аарон Надаб ши Абиху шь-ау луат, фиекаре, кэделница, ау пус фок ын еа ши ау пус тэмые пе фок, ши ау адус астфел ынаинтя Домнулуй фок стрэин, лукру пе каре Ел ну ли-л порунчисе. ");
INSERT INTO ron1924_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Атунч а ешит ун фок динаинтя Домнулуй, й-а мистуит ши ау мурит ынаинтя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Мойсе а зис луй Аарон: „Ачаста есте че а спус Домнул кынд а зис: ‘Вой фи сфинцит де чей че се апропие де Мине ши вой фи прослэвит ын фаца ынтрегулуй попор.’” Аарон а тэкут. ");
INSERT INTO ron1924_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Ши Мойсе а кемат пе Мишаел ши Елцафан, фиий луй Узиел, ункюл луй Аарон, ши ле-а зис: „Апропияци-вэ, скоатець пе фраций воштри дин Сфынтул Локаш ши дучеци-й афарэ дин табэрэ.” ");
INSERT INTO ron1924_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Ей с-ау апропият ши й-ау скос афарэ дин табэрэ, ымбрэкаць ын туничиле лор, кум зисесе Мойсе. ");
INSERT INTO ron1924_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Мойсе а зис луй Аарон, луй Елеазар ши луй Итамар, фиий луй Аарон: „Сэ ну вэ дескопериць капетеле ши сэ ну вэ рупець хайнеле, ка ну кумва сэ муриць ши сэ Се мыние Домнул ымпотрива ынтреӂий адунэрь. Лэсаць пе фраций воштри, пе тоатэ каса луй Исраел, сэ плынгэ ардеря каре а венит де ла Домнул. ");
INSERT INTO ron1924_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Вой сэ ну ешиць дин уша кортулуй ынтылнирий, ка сэ ну муриць, кэч унтделемнул унӂерий Домнулуй есте песте вой.” Ей ау фэкут кум зисесе Мойсе. ");
INSERT INTO ron1924_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Домнул а ворбит луй Аарон ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","„Ту ши фиий тэй ымпреунэ ку тине сэ ну бець вин, нич бэутурэ амецитоаре кынд вець интра ын кортул ынтылнирий, ка сэ ну муриць: ачаста ва фи о леӂе вешникэ принтре урмаший воштри, ");
INSERT INTO ron1924_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","ка сэ путець деосеби че есте сфынт де че ну есте сфынт, че есте некурат де че есте курат, ");
INSERT INTO ron1924_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","ши сэ путець ынвэца пе копиий луй Исраел тоате леӂиле пе каре ли ле-а дат Домнул прин Мойсе.” ");
INSERT INTO ron1924_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Мойсе а зис луй Аарон, луй Елеазар ши луй Итамар, чей дой фий каре май рэмэсесерэ луй Аарон: „Луаць партя дин дарул де мынкаре рэмасэ дин жертфеле мистуите де фок ынаинтя Домнулуй ши мынкаць-о фэрэ алуат лынгэ алтар, кэч есте ун лукру прясфынт. ");
INSERT INTO ron1924_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","С-о мынкаць ынтр-ун лок сфынт; ачеста есте дрептул тэу ши дрептул фиилор тэй, ка парте дин даруриле де мынкаре мистуите де фок ынаинтя Домнулуй, кэч аша мь-а фост порунчит. ");
INSERT INTO ron1924_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Сэ мынкаць, де асеменя, ынтр-ун лок курат, ту, фиий тэй ши фийчеле тале ымпреунэ ку тине, пептул каре а фост легэнат ынтр-о парте ши алта ши спата каре а фост адусэ ка жертфэ прин ридикаре, кэч еле вэ сунт дате, ка ун дрепт кувенит цие ши ка ун дрепт кувенит фиилор тэй, дин жертфеле де мулцумире але копиилор луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Ымпреунэ ку грэсимиле рындуите сэ фие мистуите де фок, ей вор адуче спата адусэ ка жертфэ прин ридикаре ши пептул каре се лягэнэ ынтр-о парте ши алта ынаинтя Домнулуй; еле вор фи але тале ши але фиилор тэй ымпреунэ ку тине, принтр-о леӂе вешникэ, аша кум а порунчит Домнул.” ");
INSERT INTO ron1924_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Мойсе а кэутат цапул адус ка жертфэ де испэшире ши ятэ кэ фусесе арс. Атунч с-а мыният пе Елеазар ши Итамар, фиий каре май рэмэсесерэ луй Аарон, ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","„Пентру че н-аць мынкат жертфа де испэшире ынтр-ун лок сфынт? Еа есте ун лукру прясфынт, ши Домнул в-а дат-о ка сэ пуртаць нелеӂюиря адунэрий ши сэ фачець испэшире пентру еа ынаинтя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Ятэ кэ сынӂеле жертфей н-а фост дус ынэунтрул Сфынтулуй Локаш; требуя с-о мынкаць ын Сфынтул Локаш, кум ам порунчит.” ");
INSERT INTO ron1924_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Аарон а рэспунс луй Мойсе: „Ятэ, ей шь-ау адус азь жертфа де испэшире ши ардеря-де-тот ынаинтя Домнулуй ши, дупэ челе че ми с-ау ынтымплат, дакэ аш фи мынкат азь жертфа де испэшире, ар фи фост бине оаре ынаинтя Домнулуй?” ");
INSERT INTO ron1924_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Мойсе а аузит ши а фост мулцумит ку ачесте кувинте. ");
INSERT INTO ron1924_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Домнул а ворбит луй Мойсе ши луй Аарон ши ле-а зис: ");
INSERT INTO ron1924_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","„Ворбиць копиилор луй Исраел ши спунеци-ле: ‘Ятэ добитоачеле пе каре ле вець мынка динтре тоате добитоачеле де пе пэмынт. ");
INSERT INTO ron1924_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Сэ мынкаць орьче добиток каре аре унгия деспикатэ, копита деспэрцитэ ши румегэ. ");
INSERT INTO ron1924_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Дар сэ ну мынкаць дин челе че румегэ нумай сау каре ау нумай унгия деспикатэ. Астфел, сэ ну мынкаць кэмила, каре румегэ, дар н-аре унгия деспикатэ; с-о привиць ка некуратэ. ");
INSERT INTO ron1924_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Сэ ну мынкаць епуреле де касэ, каре румегэ, дар н-аре унгия деспикатэ; сэ-л привиць ка некурат. ");
INSERT INTO ron1924_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Сэ ну мынкаць епуреле, каре румегэ, дар н-аре унгия деспикатэ; сэ-л привиць ка некурат. ");
INSERT INTO ron1924_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Сэ ну мынкаць поркул, каре аре унгия деспикатэ ши копита деспэрцитэ, дар ну румегэ; сэ-л привиць ка некурат. ");
INSERT INTO ron1924_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Сэ ну мынкаць дин карня лор ши сэ ну вэ атинӂець де трупуриле лор моарте; сэ ле привиць ка некурате. ");
INSERT INTO ron1924_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Ятэ вецуитоареле пе каре сэ ле мынкаць динтре тоате челе че сунт ын апе. Сэ мынкаць дин тоате челе че ау арипь (ынотэтоаре) ши солзь ши каре сунт ын апе, фие ын мэрь, фие ын рыурь. ");
INSERT INTO ron1924_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Дар сэ привиць ка о урычуне пе тоате челе че н-ау арипь ши солзь дин тот че мишунэ ын апе ши тот че трэеште ын апе, фие ын мэрь, фие ын рыурь. ");
INSERT INTO ron1924_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Сэ ле привиць ка о урычуне, сэ ну мынкаць дин карня лор, ши трупуриле лор моарте сэ ле привиць ка о урычуне. ");
INSERT INTO ron1924_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Сэ привиць ка о урычуне пе тоате челе каре н-ау арипь ши солзь ын апе. ");
INSERT INTO ron1924_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Ятэ динтре пэсэрь челе пе каре ле вець приви ка о урычуне ши дин каре сэ ну мынкаць: вултурул, грипсорул ши вултурул де маре; ");
INSERT INTO ron1924_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","шорекарул, шоймул ши тот че есте дин нямул луй; ");
INSERT INTO ron1924_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","корбул ши тоате союриле луй; ");
INSERT INTO ron1924_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","струцул, буфница, пескэрелул, короюл ши тот че цине де нямул луй; ");
INSERT INTO ron1924_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","хухурезул, еретеле ши кокостыркул; ");
INSERT INTO ron1924_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","лебэда, пеликанул ши корбул де маре; ");
INSERT INTO ron1924_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","барза, бытланул ши че есте дин нямул луй, пупэза ши лилиакул. ");
INSERT INTO ron1924_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Сэ привиць ка о урычуне орьче тырытоаре каре збоарэ ши умблэ пе патру пичоаре. ");
INSERT INTO ron1924_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Дар, динтре тоате тырытоареле каре збоарэ ши умблэ пе патру пичоаре, сэ мынкаць пе челе че ау флуерул пичоарелор динапой май лунг, ка сэ поатэ сэри пе пэмынт. ");
INSERT INTO ron1924_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Ятэ пе каре сэ ле мынкаць: лэкуста, лэкуста солам, лэкуста харгол ши лэкуста хагаб, дупэ союриле лор. ");
INSERT INTO ron1924_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Пе тоате челелалте тырытоаре каре збоарэ ши каре ау патру пичоаре сэ ле привиць ка о урычуне. ");
INSERT INTO ron1924_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Еле вэ вор фаче некураць: орьчине се ва атинӂе де трупуриле лор моарте ва фи некурат пынэ сяра ");
INSERT INTO ron1924_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","ши орьчине ва пурта трупуриле лор моарте сэ-шь спеле хайнеле ши ва фи некурат пынэ сяра. ");
INSERT INTO ron1924_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Сэ привиць ка некурат орьче добиток ку унгия деспикатэ, дар каре н-аре копита деспэрцитэ ши ну румегэ: орьчине се ва атинӂе де ел ва фи некурат. ");
INSERT INTO ron1924_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Сэ привиць ка некурате тоате ачеле добитоаче ку патру пичоаре каре умблэ пе лабеле лор: орьчине се ва атинӂе де трупуриле лор моарте ва фи некурат пынэ сяра ");
INSERT INTO ron1924_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","ши орьчине ле ва пурта трупуриле моарте ышь ва спэла хайнеле ши ва фи некурат пынэ сяра. Сэ ле привиць ка некурате. ");
INSERT INTO ron1924_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Ятэ, дин виетэциле каре се тырэск пе пэмынт, челе пе каре ле вець приви ка некурате: кыртица, шоаречеле ши шопырла, дупэ союриле лор; ");
INSERT INTO ron1924_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","аричул, броаска, броаска цестоасэ, мелкул ши камелеонул. ");
INSERT INTO ron1924_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Сэ ле привиць ка некурате динтре тоате тырытоареле. Орьчине се ва атинӂе де еле моарте ва фи некурат пынэ сяра. ");
INSERT INTO ron1924_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Орьче лукру пе каре ва кэдя чева дин трупуриле лор моарте ва фи некурат, фие вас де лемн, фие хайнэ, фие пеле, фие сак, фие орьче алт лукру каре се ынтребуинцязэ ла чева; сэ фие пус ын апэ ши ва рэмыне некурат пынэ сяра; дупэ ачея ва фи курат. ");
INSERT INTO ron1924_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Тот че се ва гэси ынтр-ун вас де пэмынт ын каре ва кэдя чева дин ачесте трупурь моарте ва фи некурат ши вець спарӂе васул. ");
INSERT INTO ron1924_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Орьче лукру де мынкаре пе каре ва кэдя чева дин апа ачаста ва фи некурат ши орьче бэутурэ каре се ынтребуинцязэ ла бэут, орькаре ар фи васул ын каре се ва гэси, ва фи некуратэ. ");
INSERT INTO ron1924_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Орьче лукру пе каре ва кэдя чева дин трупуриле лор моарте ва фи некурат; купторул ши ватра сэ се дэрыме; вор фи некурате ши ле вець приви ка некурате. ");
INSERT INTO ron1924_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Нумай извоареле ши фынтыниле, каре алкэтуеск грэмезь де апе, вор рэмыне курате, дар чине се ва атинӂе де трупуриле лор моарте ва фи некурат. ");
INSERT INTO ron1924_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Дакэ се ынтымплэ сэ кадэ чева дин трупуриле лор моарте пе о сэмынцэ каре требуе семэнатэ, еа ва рэмыне куратэ. ");
INSERT INTO ron1924_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Дар, дакэ се пусесе апэ пе сэмынцэ ши каде пе еа чева дин трупуриле лор моарте, ва фи некуратэ. ");
INSERT INTO ron1924_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Дакэ моаре уна дин вителе каре вэ служеск ка хранэ, чине се ва атинӂе де трупул ей морт ва фи некурат пынэ сяра; ");
INSERT INTO ron1924_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","чине ва мынка дин трупул ей морт ышь ва спэла хайнеле ши ва фи некурат пынэ сяра ши чине ва пурта трупул ей морт ышь ва спэла хайнеле ши ва фи некурат пынэ сяра. ");
INSERT INTO ron1924_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Пе орьче тырытоаре каре се тырэште пе пэмынт, с-о привиць ка некуратэ; сэ ну се мэнынче. ");
INSERT INTO ron1924_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Дин тоате тырытоареле каре се тырэск пе пэмынт, дин тоате челе че се тырэск пе пынтече, сэ ну мынкаць; нич дин тоате челе че умблэ пе патру пичоаре сау пе ун маре нумэр де пичоаре, чи сэ ле привиць ка о урычуне. ");
INSERT INTO ron1924_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Сэ ну вэ фачець урычошь прин тоате ачесте тырытоаре каре се тырэск; сэ ну вэ фачець некураць прин еле, сэ ну вэ спуркаць прин еле. ");
INSERT INTO ron1924_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Кэч Еу сунт Домнул Думнезеул востру. Вой сэ вэ сфинциць ши фиць сфинць, кэч Еу сунт сфынт; сэ ну вэ фачець некураць прин тоате ачесте тырытоаре каре се тырэск пе пэмынт. ");
INSERT INTO ron1924_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Кэч Еу сунт Домнул, каре в-ам скос дин цара Еӂиптулуй ка сэ фиу Думнезеул востру ши сэ фиць сфинць, кэч Еу сунт сфынт. ");
INSERT INTO ron1924_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Ачаста есте леӂя привитоаре ла добитоачеле, пэсэриле, тоате вецуитоареле каре се мишкэ ын апе ши тоате виетэциле каре се тырэск пе пэмынт, ");
INSERT INTO ron1924_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","ка сэ фачець деосебире ынтре че есте некурат ши че есте курат, ынтре добитокул каре се мэнынкэ ши добитокул каре ну се мэнынкэ.’” ");
INSERT INTO ron1924_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","„Ворбеште копиилор луй Исраел ши спуне-ле: ‘Кынд о фемее ва рэмыне ынсэрчинатэ ши ва наште ун копил де парте бэрбэтяскэ, сэ фие некуратэ шапте зиле; сэ фие некуратэ ка ын время сорокулуй ей. ");
INSERT INTO ron1924_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Ын зиуа а опта, копилул сэ фие тэят ымпрежур. ");
INSERT INTO ron1924_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Фемея сэ май рэмынэ ынкэ трейзечь ши трей де зиле, ка сэ се курэцяскэ де сынӂеле ей; сэ ну се атингэ де ничун лукру сфынт ши сэ ну се дукэ ла Сфынтул Локаш пынэ ну се вор ымплини зилеле курэцирий ей. ");
INSERT INTO ron1924_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Дакэ наште о фатэ, сэ фие некуратэ доуэ сэптэмынь, ка пе время кынд й-а венит сорокул, ши сэ рэмынэ шайзечь ши шасе де зиле ка сэ се курэцяскэ де сынӂеле ей. ");
INSERT INTO ron1924_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Кынд се вор ымплини зилеле курэцирий ей, пентру ун фиу сау пентру о фийкэ, сэ адукэ преотулуй, ла уша кортулуй ынтылнирий, ун мел де ун ан пентру ардеря-де-тот ши ун пуй де порумбел сау о туртуря пентру жертфа де испэшире. ");
INSERT INTO ron1924_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Преотул сэ ле жертфяскэ ынаинтя Домнулуй ши сэ факэ испэшире пентру еа ши, астфел, еа ва фи курэцитэ де курӂеря сынӂелуй ей. Ачаста есте леӂя пентру фемея каре наште ун бэят сау о фатэ. ");
INSERT INTO ron1924_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Дакэ ну поате сэ адукэ ун мел, сэ я доуэ туртуреле сау дой пуй де порумбел, унул пентру ардеря-де-тот, алтул пентру жертфа де испэшире. Преотул сэ факэ испэшире пентру еа, ши ва фи куратэ.’” ");
INSERT INTO ron1924_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Домнул а ворбит луй Мойсе ши луй Аарон ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","„Кынд ун ом ва авя пе пеля трупулуй о умфлэтурэ, о печинӂине сау о патэ албэ, каре ва семэна ку о ранэ де лепрэ пе пеля трупулуй луй, требуе адус ла преотул Аарон сау ла унул дин фиий луй, каре сунт преоць. ");
INSERT INTO ron1924_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Преотул сэ черчетезе рана де пе пеля трупулуй. Дакэ пэрул дин ранэ с-а фэкут алб ши дакэ рана се аратэ май адынкэ декыт пеля трупулуй, есте о ранэ де лепрэ: преотул каре ва фаче черчетаря сэ декларе пе омул ачела некурат. ");
INSERT INTO ron1924_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Дакэ пе пеля трупулуй ва фи о патэ албэ каре ну се аратэ май адынкэ декыт пеля ши дакэ пэрул ну с-а фэкут алб, преотул сэ ынкидэ шапте зиле пе чел ку рана. ");
INSERT INTO ron1924_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","А шаптя зи, преотул сэ-л черчетезе ярэшь. Дакэ и се паре кэ рана а стат пе лок ши ну с-а ынтинс пе пеле, преотул сэ-л ынкидэ а доуа оарэ ынкэ шапте зиле. ");
INSERT INTO ron1924_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Преотул сэ-л черчетезе а доуа оарэ ын зиуа а шаптя. Дакэ рана а май скэзут ши ну с-а ынтинс пе пеле, преотул ва спуне кэ омул ачеста есте курат: есте о печинӂине; ел сэ-шь спеле хайнеле, ши ва фи курат. ");
INSERT INTO ron1924_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Дар, дакэ печинӂиня с-а ынтинс пе пеле дупэ че с-а арэтат ел преотулуй ши дупэ че ачеста л-а декларат курат, сэ се май супунэ ынкэ о датэ черчетэрий преотулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Преотул ыл ва черчета. Дакэ печинӂиня с-а ынтинс пе пеле, преотул ыл ва деклара некурат: есте лепрэ. ");
INSERT INTO ron1924_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Кынд се ва арэта о ранэ де лепрэ пе ун ом, сэ фие адус ла преот. ");
INSERT INTO ron1924_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Преотул сэ-л черчетезе. Ши, дакэ аре пе пеле о умфлэтурэ албэ, дакэ умфлэтура ачаста а фэкут ка пэрул сэ албяскэ ши ын умфлэтурэ есте ши о урмэ де карне вие, ");
INSERT INTO ron1924_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","атунч пе пеля трупулуй омулуй ачестуя есте о лепрэ ынвекитэ: преотул сэ-л декларе некурат. Сэ ну-л ынкидэ, кэч есте некурат. ");
INSERT INTO ron1924_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Дакэ лепра ва фаче о спузялэ пе пеле ши ва акопери тоатэ пеля челуй ку рана, дин кап пынэ ын пичоаре, претутиндень пе унде-шь ва арунка преотул привириле, ");
INSERT INTO ron1924_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","преотул сэ-л черчетезе ши, дакэ ва ведя кэ лепра а акоперит тот трупул, сэ декларе курат пе чел ку рана; фииндкэ с-а фэкут тоатэ албэ, ел есте курат. ");
INSERT INTO ron1924_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Дар, ын зиуа кынд се ва ведя ын ел карне вие, ва фи некурат; ");
INSERT INTO ron1924_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","кынд преотул ва ведя карня вие, сэ-л декларе некурат: карня вие есте некуратэ, есте лепрэ. ");
INSERT INTO ron1924_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Дакэ се скимбэ карня вие ши се фаче албэ, сэ се дукэ ла преот; ");
INSERT INTO ron1924_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","преотул сэ-л черчетезе ши, дакэ рана с-а фэкут албэ, преотул сэ декларе курат пе чел ку рана: ел есте курат. ");
INSERT INTO ron1924_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Кынд ун ом ва авя пе пеля трупулуй сэу о бубэ каре а фост тэмэдуитэ, ");
INSERT INTO ron1924_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","ши пе локул унде ера буба се ва арэта о умфлэтурэ албэ сау о патэ де ун алб рошиатик, омул ачела сэ се арате преотулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Преотул сэ-л черчетезе. Дакэ пата паре май адынкэ декыт пеля ши дакэ пэрул с-а фэкут алб, преотул сэ-л декларе некурат: есте о ранэ де лепрэ, каре а дат ын бубэ. ");
INSERT INTO ron1924_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Дакэ преотул веде кэ ну есте пэр алб ын патэ, кэ еа ну есте май адынкэ декыт пеля ши кэ а май скэзут, сэ ынкидэ пе омул ачела шапте зиле. ");
INSERT INTO ron1924_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Дакэ с-а ынтинс пата пе пеле, преотул сэ-л декларе некурат: есте о ранэ де лепрэ. ");
INSERT INTO ron1924_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Дар, дакэ пата а рэмас пе лок ши ну с-а ынтинс, есте семнул рэний ускате, унде а фост буба; преотул сэ-л декларе курат. ");
INSERT INTO ron1924_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Кынд ун ом ва авя пе пеля трупулуй о арсурэ причинуитэ де фок ши се ва арэта пе урма арсурий о патэ албэ сау де ун алб рошиатик, ");
INSERT INTO ron1924_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","преотул сэ-л черчетезе. Дакэ пэрул дин патэ с-а фэкут алб ши еа паре май адынкэ декыт пеля, есте лепрэ, каре а дат ын арсурэ. Преотул сэ декларе пе омул ачела некурат: есте о ранэ де лепрэ. ");
INSERT INTO ron1924_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Дакэ преотул веде кэ ну есте пэр алб ын патэ, кэ еа ну есте май адынкэ декыт пеля ши кэ а май скэзут, сэ ынкидэ пе омул ачела шапте зиле. ");
INSERT INTO ron1924_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Преотул сэ-л черчетезе а шаптя зи ши, дакэ пата с-а ынтинс пе пеле, преотул сэ-л декларе некурат: есте о ранэ де лепрэ. ");
INSERT INTO ron1924_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Дар, дакэ пата а рэмас пе лок, ну с-а ынтинс пе пеле ши а май скэзут, есте о ранэ причинуитэ де умфлэтура арсурий; преотул сэ-л декларе курат, кэч есте семнул рэний виндекате а арсурий. ");
INSERT INTO ron1924_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Кынд ун бэрбат сау о фемее ва авя о ранэ пе кап сау ла барбэ, ");
INSERT INTO ron1924_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","преотул сэ черчетезе рана. Дакэ паре май адынкэ декыт пеля ши аре пэр гэлбуй ши субцире, преотул сэ декларе пе омул ачела некурат: есте рые де кап, есте лепрэ де кап сау де барбэ. ");
INSERT INTO ron1924_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Дакэ преотул веде кэ рана рыей ну паре май адынкэ декыт пеля ши н-аре пэр негру, сэ ынкидэ шапте зиле пе чел ку рана де рые ла кап. ");
INSERT INTO ron1924_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Преотул сэ черчетезе рана а шаптя зи. Дакэ рыя ну с-а ынтинс, дакэ н-аре пэр гэлбуй ши дакэ ну паре май адынкэ декыт пеля, ");
INSERT INTO ron1924_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","чел ку рыя ла кап сэ се радэ, дар сэ ну радэ локул унде есте рыя ши преотул сэ-л ынкидэ а доуа оарэ шапте зиле. ");
INSERT INTO ron1924_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Преотул сэ черчетезе рыя а шаптя зи. Дакэ рыя ну с-а ынтинс пе пеле ши ну паре май адынкэ декыт пеля, преотул сэ-л декларе курат. Ел сэ-шь спеле хайнеле ши ва фи курат. ");
INSERT INTO ron1924_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Дар, дакэ рыя с-а ынтинс пе пеле дупэ че а фост декларат курат, ");
INSERT INTO ron1924_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","преотул сэ-л черчетезе. Ши, дакэ рыя с-а ынтинс пе пеле, преотул н-аре сэ май кауте сэ вадэ дакэ аре пэр гэлбуй: есте некурат. ");
INSERT INTO ron1924_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Дакэ и се паре кэ рыя а стат пе лок ши кэ дин еа а крескут пэр негру, рыя есте виндекатэ: есте курат ши преотул сэ-л декларе курат. ");
INSERT INTO ron1924_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Кынд ун бэрбат сау о фемее ва авя пете пе пеля трупулуй, ши ануме пете албе, ");
INSERT INTO ron1924_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","преотул сэ-л черчетезе. Дакэ пе пеля трупулуй луй сунт пете де ун алб гэлбуй, ачестя ну сунт декыт ниште пете каре ау фэкут спузялэ пе пеле: есте курат. ");
INSERT INTO ron1924_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Кынд унуй ом ый ва кэдя пэрул де пе кап, есте плешув: есте курат. ");
INSERT INTO ron1924_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Дакэ й-а кэзут пэрул де пе кап нумай ын партя динаинте, есте плешув ын партя динаинте: есте курат. ");
INSERT INTO ron1924_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Дар, дакэ ын партя плешувэ динаинте сау динапой есте о ранэ де ун алб рошиатик, есте лепрэ, каре а фэкут спузялэ ын партя плешувэ динаинте сау динапой. ");
INSERT INTO ron1924_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Преотул сэ-л черчетезе. Дакэ ын партя плешувэ динапой сау динаинте есте о умфлэтурэ де ранэ де ун алб рошиатик, асемэнэтоаре ку лепра де пе пеля трупулуй, ");
INSERT INTO ron1924_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","есте лепрос, есте некурат. Преотул сэ-л декларе некурат; рана луй есте пе кап. ");
INSERT INTO ron1924_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Лепросул, атинс де ачастэ ранэ, сэ-шь поарте хайнеле сфышияте ши сэ умбле ку капул гол; сэ-шь акопере барба ши сэ стриӂе: ‘Некурат! Некурат!’ ");
INSERT INTO ron1924_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Кытэ време ва авя рана, ва фи некурат: есте некурат. Сэ локуяскэ сингур; локуинца луй сэ фие афарэ дин табэрэ. ");
INSERT INTO ron1924_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Кынд се ва арэта о ранэ де лепрэ пе о хайнэ, фие хайнэ де лынэ, фие хайнэ де ин, ");
INSERT INTO ron1924_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ын урзяла сау ын бэтэтура де ин сау де лынэ, пе о пеле сау пе вреун лукру де пеле, ");
INSERT INTO ron1924_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","ши рана ва фи верзуе сау рошиатикэ пе хайнэ сау пе пеле, ын урзялэ сау ын бэтэтурэ, сау пе вреун лукру де пеле, есте о ранэ де лепрэ ши требуе арэтатэ преотулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Преотул сэ черчетезе рана ши сэ ынкидэ шапте зиле лукрул ку рана. ");
INSERT INTO ron1924_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Сэ черчетезе а шаптя зи рана. Дакэ рана с-а ынтинс пе хайнэ, ын урзялэ сау ын бэтэтурэ, пе пеле сау пе лукрул ачела де пеле, есте о ранэ де лепрэ ынвекитэ: лукрул ачела есте некурат. ");
INSERT INTO ron1924_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Сэ ардэ хайна, урзяла сау бэтэтура де лынэ сау де ин сау лукрул де пеле пе каре се гэсеште рана, кэч есте о лепрэ ынвекитэ: сэ фие арс ын фок. ");
INSERT INTO ron1924_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Дар, дакэ преотул веде кэ рана ну с-а ынтинс пе хайнэ, пе урзялэ сау пе бэтэтурэ сау пе лукрул ачела де пеле, ");
INSERT INTO ron1924_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","сэ порунчяскэ сэ се спеле партя атинсэ де ранэ ши сэ-л ынкидэ а доуа оарэ шапте зиле. ");
INSERT INTO ron1924_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Преотул сэ черчетезе рана дупэ че се ва спэла. Ши, дакэ рана ну шь-а скимбат ынфэцишаря ши ну с-а ынтинс, лукрул ачела есте некурат: сэ фие арс ын фок, кэч о парте дин фацэ сау дин дос а фост роасэ. ");
INSERT INTO ron1924_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Дакэ преотул веде кэ рана а май скэзут дупэ че а фост спэлатэ, с-о рупэ дин хайнэ сау дин пеле, дин урзялэ сау дин бэтэтурэ. ");
INSERT INTO ron1924_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Ши, дакэ се май ивеште пе хайнэ, ын урзялэ сау ын бэтэтурэ сау пе лукрул де пеле, ынсямнэ кэ есте о спузялэ де лепрэ: лукрул атинс де ранэ сэ фие арс ын фок. ");
INSERT INTO ron1924_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Хайна, урзяла сау бэтэтура сау вреун лукру де пеле каре а фост спэлат ши унде а перит рана сэ се май спеле а доуа оарэ ши ва фи курат. ");
INSERT INTO ron1924_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Ачаста есте леӂя привитоаре ла рана лепрей, кынд ловеште хайнеле де лынэ сау де ин, урзяла сау бэтэтура сау ун лукру оарекаре де пеле ши дупэ каре вор фи декларате курате сау некурате.” ");
INSERT INTO ron1924_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","„Ятэ каре ва фи леӂя ку привире ла чел лепрос ын зиуа курэцирий луй. Сэ-л адукэ ынаинтя преотулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Преотул сэ ясэ афарэ дин табэрэ ши сэ черчетезе пе чел лепрос. Дакэ лепросул есте тэмэдуит де рана лепрей, ");
INSERT INTO ron1924_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","преотул сэ порунчяскэ сэ се я, пентру чел че требуе курэцит, доуэ пэсэрь вий ши курате, лемн де чедру, кырмыз ши исоп. ");
INSERT INTO ron1924_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Преотул сэ порунчяскэ сэ се ынжунгие уна дин ачесте пэсэрь ынтр-ун вас де пэмынт, ын апэ кургэтоаре. ");
INSERT INTO ron1924_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Сэ я пасэря чя вие, лемнул де чедру, кырмызул ши исопул ши сэ ле ынмоае, ымпреунэ ку пасэря чя вие, ын сынӂеле пэсэрий ынжунгияте ын апа кургэтоаре. ");
INSERT INTO ron1924_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Сэ стропяскэ де шапте орь пе чел че требуе курэцит де лепрэ. Апой сэ-л декларе курат ши сэ дя друмул пэсэрий челей вий пе кымп. ");
INSERT INTO ron1924_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Чел че се курэцеште требуе сэ-шь спеле хайнеле, сэ-шь радэ тот пэрул ши сэ се скалде ын апэ ши ва фи курат. Апой ва путя сэ интре ын табэрэ, дар сэ рэмынэ шапте зиле афарэ дин корт. ");
INSERT INTO ron1924_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Ын зиуа а шаптя, сэ-шь радэ тот пэрул, капул, барба ши спрынченеле: тот пэрул сэ ши-л радэ; сэ-шь спеле хайнеле ши сэ-шь скалде трупул ын апэ ши ва фи курат. ");
INSERT INTO ron1924_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","А опта зи, сэ я дой мей фэрэ кусур ши о оае де ун ан фэрэ кусур, трей зечимь динтр-о ефэ де флоаря фэиний, ка дар де мынкаре фрэмынтат ку унтделемн, ши ун лог (пахар) де унтделемн. ");
INSERT INTO ron1924_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Преотул каре фаче курэциря сэ адукэ ынаинтя Домнулуй пе омул каре се курэцеште ши тоате лукруриле ачестя, ла уша кортулуй ынтылнирий. ");
INSERT INTO ron1924_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Преотул сэ я унул дин мей ши сэ-л адукэ жертфэ пентру винэ, ымпреунэ ку логул де унтделемн; сэ ле леӂене ынтр-о парте ши ынтр-алта ынаинтя Домнулуй, ка дар легэнат. ");
INSERT INTO ron1924_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Сэ ынжунгие мелул ын локул унде се ынжунгие жертфеле де испэшире ши ардериле-де-тот, адикэ ын Локул Сфынт, кэч ла жертфа пентру винэ, ка ши ла жертфа де испэшире, добитокул пентру жертфэ ва фи ал преотулуй: ел есте ун лукру прясфынт. ");
INSERT INTO ron1924_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Преотул сэ я дин сынӂеле жертфей де испэшире; сэ пунэ пе марӂиня урекий дрепте а челуй че се курэцеште, пе деӂетул чел маре де ла мына дряптэ а луй ши пе деӂетул чел маре де ла пичорул дрепт. ");
INSERT INTO ron1924_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Преотул сэ я унтделемн дин лог ши сэ тоарне ын палма мыний стынӂь. ");
INSERT INTO ron1924_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Преотул сэ-шь ынмоае деӂетул мыний дрепте ын унтделемнул дин палма мыний стынӂь ши сэ стропяскэ дин унтделемн де шапте орь ку деӂетул ынаинтя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Дин унтделемнул каре-й май рэмыне ын мынэ, преотул сэ пунэ пе (моалеле) марӂиня урекий дрепте а челуй че се курэцеште, пе деӂетул чел маре ал мыний дрепте ши пе деӂетул чел маре ал пичорулуй дрепт, дясупра сынӂелуй де ла жертфа пентру винэ. ");
INSERT INTO ron1924_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Яр унтделемнул каре-й май рэмыне ын мынэ, преотул сэ-л пунэ пе капул челуй че се курэцеште ши преотул сэ факэ испэшире пентру ел ынаинтя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Апой, преотул сэ адукэ жертфа де испэшире ши сэ факэ испэшире пентру чел че се курэцеште де ынтинэчуня луй. Апой, сэ ынжунгие ардеря-де-тот. ");
INSERT INTO ron1924_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Преотул сэ адукэ пе алтар ардеря-де-тот ши дарул де мынкаре ши сэ факэ испэшире пентру омул ачеста, ши ва фи курат. ");
INSERT INTO ron1924_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Дакэ есте сэрак ши ну поате сэ адукэ тоате ачесте лукрурь, атунч сэ я ун сингур мел, каре сэ фие адус ка жертфэ пентру винэ дупэ че а фост легэнат ынтр-о парте ши ынтр-алта, ка дар легэнат, ши сэ факэ испэшире пентру ел. Сэ я о зечиме дин флоаря фэиний фрэмынтатэ ку унтделемн, пентру дарул де мынкаре, ши ун лог де унтделемн. ");
INSERT INTO ron1924_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Сэ я ши доуэ туртуреле сау дой пуй де порумбел, дупэ мижлоачеле луй, унул ка жертфэ де испэшире, челэлалт ка ардере-де-тот. ");
INSERT INTO ron1924_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Ын зиуа а опта, сэ адукэ пентру курэциря луй тоате ачесте лукрурь ла преот, ла уша кортулуй ынтылнирий, ынаинтя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Преотул сэ я мелул пентру жертфа де винэ ши логул ку унтделемн ши сэ ле леӂене ынтр-о парте ши ынтр-алта, ка дар легэнат, ынаинтя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Сэ ынжунгие мелул жертфей пентру винэ. Преотул сэ я дин сынӂеле жертфей пентру винэ; сэ пунэ пе марӂиня урекий дрепте а челуй че се курэцеште, пе деӂетул чел маре ал мыний дрепте ши пе деӂетул чел маре ал пичорулуй дрепт. ");
INSERT INTO ron1924_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Преотул сэ тоарне унтделемн ын палма мыний стынӂь. ");
INSERT INTO ron1924_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Преотул сэ стропяскэ де шапте орь ку деӂетул де ла мына дряптэ ынаинтя Домнулуй дин унтделемнул каре есте ын мына стынгэ а луй. ");
INSERT INTO ron1924_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Яр дин унтделемнул дин мына луй, преотул сэ пунэ пе марӂиня урекий дрепте а челуй че се курэцеште, пе деӂетул чел маре ал мыний дрепте ши пе деӂетул чел маре ал пичорулуй дрепт, ын локул унде а пус дин сынӂеле жертфей пентру винэ. ");
INSERT INTO ron1924_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Че май рэмыне дин унтделемн ын мынэ, преотул сэ-л пунэ пе капул челуй че се курэцеште, ка сэ факэ испэшире пентру ел ынаинтя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Апой сэ адукэ уна дин туртуреле сау ун пуй де порумбел, кум ва путя, ");
INSERT INTO ron1924_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","унул ка жертфэ де испэшире ши алтул ка ардере-де-тот, ымпреунэ ку дарул де мынкаре, ши преотул сэ факэ испэшире ынаинтя Домнулуй пентру чел че се курэцеште. ");
INSERT INTO ron1924_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Ачаста есте леӂя пентру курэциря челуй че аре о ранэ де лепрэ ши ну поате сэ адукэ тот че есте рындуит пентру курэциря луй.” ");
INSERT INTO ron1924_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Домнул а ворбит луй Мойсе ши луй Аарон ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","„Дупэ че вець интра ын цара Канаанулуй, пе каре в-о дау ын стэпынире, дакэ вой тримите о ранэ де лепрэ пе врео касэ дин цара пе каре о вець стэпыни, ");
INSERT INTO ron1924_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","чел ку каса сэ се дукэ сэ спунэ преотулуй ши сэ зикэ: ‘Ми се паре кэ есте чева ка о ранэ ын каса мя.’ ");
INSERT INTO ron1924_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Преотул, ынаинте де а интра ка сэ черчетезе рана, сэ порунчяскэ сэ се дешерте каса, ка ну кумва тот че есте ын еа сэ се факэ некурат. Дупэ ачея сэ интре преотул ши сэ черчетезе каса. ");
INSERT INTO ron1924_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Преотул сэ черчетезе рана. Дакэ веде кэ пе зидуриле касей сунт ниште гропишоаре верзуй сау рошиатиче, каре пар май адынчь декыт зидул, ");
INSERT INTO ron1924_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","сэ ясэ дин касэ ши, кынд ва ажунӂе ла ушэ, сэ пунэ сэ ынкуе каса шапте зиле. ");
INSERT INTO ron1924_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Ын зиуа а шаптя, преотул сэ се ынтоаркэ ын еа. Ши, дакэ ва ведя кэ рана с-а ынтинс пе зидуриле касей, ");
INSERT INTO ron1924_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","сэ порунчяскэ сэ се скоатэ петреле атинсе де ранэ ши сэ ле арунче афарэ дин четате ынтр-ун лок некурат. ");
INSERT INTO ron1924_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Сэ пунэ сэ рэзэлуяскэ тоатэ партя динэунтру а касей ши тенкуяла рэзэлуитэ сэ се арунче афарэ дин четате, ынтр-ун лок некурат. ");
INSERT INTO ron1924_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Сэ я алте петре ши сэ ле пунэ ын локул челор динтый ши сэ се я алтэ тенкуялэ, ка сэ се тенкуяскэ дин ноу каса. ");
INSERT INTO ron1924_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Дакэ рана се ва ынтоарче ши ва избукни дин ноу ын касэ, дупэ че ау скос петреле, дупэ че ау рэзэлуит ши тенкуит дин ноу каса, ");
INSERT INTO ron1924_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","преотул сэ се ынтоаркэ ын еа. Ши, дакэ веде кэ рана с-а ынтинс ын касэ, есте о лепрэ ынвекитэ ын касэ: каса есте некуратэ. ");
INSERT INTO ron1924_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Сэ дэрыме каса, лемнеле ши тоатэ тенкуяла касей ши сэ скоатэ ачесте лукрурь афарэ дин четате, ынтр-ун лок некурат. ");
INSERT INTO ron1924_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Чине ва интра ын касэ ын тот тимпул кынд ера ынкисэ ва фи некурат пынэ сяра. ");
INSERT INTO ron1924_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Чине се ва кулка ын касэ сэ-шь спеле хайнеле. Чине ва мынка ын касэ, де асеменя, сэ-шь спеле хайнеле. ");
INSERT INTO ron1924_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Дакэ преотул каре с-а ынторс ын касэ веде кэ рана ну с-а ынтинс дупэ че а фост тенкуитэ дин ноу каса, сэ декларе каса куратэ, кэч рана есте виндекатэ. ");
INSERT INTO ron1924_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Пентру курэциря касей сэ я доуэ пэсэрь, лемн де чедру, кырмыз ши исоп. ");
INSERT INTO ron1924_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Сэ ынжунгие уна дин пэсэрь ынтр-ун вас де пэмынт, ынтр-о апэ кургэтоаре. ");
INSERT INTO ron1924_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Сэ я лемнул де чедру, исопул, кырмызул ши пасэря чя вие; сэ ле ынмоае ын сынӂеле пэсэрий жунгияте ши ын апа кургэтоаре ши сэ стропяскэ де шапте орь каса. ");
INSERT INTO ron1924_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Сэ курэцяскэ каса ку сынӂеле пэсэрий, ку апа кургэтоаре ку пасэря чя вие, ку лемнул де чедру, ку исопул ши кырмызул. ");
INSERT INTO ron1924_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Сэ дя друмул пэсэрий челей вий афарэ дин четате, пе кымп. Сэ факэ астфел испэшире пентру касэ, ши еа ва фи куратэ. ");
INSERT INTO ron1924_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Ачаста есте леӂя пентру орьче ранэ де лепрэ ши пентру рыя де кап, ");
INSERT INTO ron1924_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","пентру лепра де пе хайне ши де пе касе, ");
INSERT INTO ron1924_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","пентру умфлэтурь, пентру печинӂинь ши пентру пете: ");
INSERT INTO ron1924_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","еа аратэ кынд ун лукру есте некурат ши кынд есте курат. Ачаста есте леӂя пентру лепрэ.” ");
INSERT INTO ron1924_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Домнул а ворбит луй Мойсе ши луй Аарон ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","„Ворбиць копиилор луй Исраел ши спунеци-ле: ‘Орьче ом каре аре о скурӂере дин трупул луй, прин кяр фаптул ачеста есте некурат. ");
INSERT INTO ron1924_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Дин причина скурӂерий луй есте некурат: фие кэ трупул луй ласэ сэ се факэ скурӂеря, фие кэ о опреште, есте некурат. ");
INSERT INTO ron1924_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Орьче пат ын каре се ва кулка ва фи некурат ши орьче лукру пе каре ва шедя ва фи некурат. ");
INSERT INTO ron1924_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Чине се ва атинӂе де патул луй сэ-шь спеле хайнеле, сэ се скалде ын апэ ши ва фи некурат пынэ сяра. ");
INSERT INTO ron1924_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Чине ва шедя пе лукрул пе каре а шезут ел сэ-шь спеле хайнеле, сэ се скалде ын апэ ши сэ фие некурат пынэ сяра. ");
INSERT INTO ron1924_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Чине се ва атинӂе де трупул луй сэ-шь спеле хайнеле, сэ се скалде ын апэ ши ва фи некурат пынэ сяра. ");
INSERT INTO ron1924_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Дакэ омул ачела скуйпэ пе ун ом курат, ачеста сэ-шь спеле хайнеле, сэ се скалде ын апэ ши ва фи некурат пынэ сяра. ");
INSERT INTO ron1924_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Орьче ша пе каре ва кэлэри ел ва фи некуратэ. ");
INSERT INTO ron1924_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Чине се ва атинӂе де вреун лукру каре а фост суб ел ва фи некурат пынэ сяра ши чине ва ридика лукрул ачела сэ-шь спеле хайнеле, сэ се скалде ын апэ ши ва фи некурат пынэ сяра. ");
INSERT INTO ron1924_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Чине ва фи атинс де чел ку скурӂере ши ну-шь ва спэла мыниле ын апэ сэ-шь спеле хайнеле, сэ се скалде ын апэ ши ва фи некурат пынэ сяра. ");
INSERT INTO ron1924_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Орьче вас де пэмынт каре ва фи атинс де ел сэ фие спарт ши орьче вас де лемн сэ фие спэлат ын апэ. ");
INSERT INTO ron1924_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Дупэ че ва фи курэцит де скурӂеря луй, омул ачела сэ нумере шапте зиле пентру курэциря луй; сэ-шь спеле хайнеле, сэ-шь скалде трупул ын апэ кургэтоаре ши ва фи курат. ");
INSERT INTO ron1924_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Ын зиуа а опта, сэ я доуэ туртуреле сау дой пуй де порумбел, сэ се дукэ ынаинтя Домнулуй, ла уша кортулуй ынтылнирий, ши сэ-й дя преотулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Преотул сэ-й адукэ, унул ка жертфэ де испэшире ши челэлалт ка ардере-де-тот, ши преотул сэ факэ испэшире пентру ел ынаинтя Домнулуй, пентру скурӂеря луй. ");
INSERT INTO ron1924_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Омул каре ва авя о скурӂере а семинцей ын сомн сэ-шь скалде тот трупул ын апэ ши ва фи некурат пынэ сяра. ");
INSERT INTO ron1924_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Орьче хайнэ ши орьче пеле каре вор фи атинсе де скурӂеря луй вор фи спэлате ку апэ ши вор фи некурате пынэ сяра. ");
INSERT INTO ron1924_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Дакэ о фемее с-а кулкат ку ун астфел де ом, сэ се скалде амындой ын апэ ши вор фи некураць пынэ сяра. ");
INSERT INTO ron1924_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Фемея каре ва авя о скурӂере, ши ануме о скурӂере де сынӂе дин трупул ей, сэ рэмынэ шапте зиле ын некурэция ей. Орьчине се ва атинӂе де еа ва фи некурат пынэ сяра. ");
INSERT INTO ron1924_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Орьче пат ын каре се ва кулка еа ын тимпул некурэцией ей ва фи некурат ши орьче лукру пе каре ва шедя еа ва фи некурат. ");
INSERT INTO ron1924_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Орьчине се ва атинӂе де патул ей сэ-шь спеле хайнеле, сэ се скалде ын апэ ши ва фи некурат пынэ сяра. ");
INSERT INTO ron1924_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Орьчине се ва атинӂе де ун лукру пе каре а шезут еа сэ-шь спеле хайнеле, сэ се скалде ын апэ ши ва фи некурат пынэ сяра. ");
INSERT INTO ron1924_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Дакэ есте чева пе патул сау пе лукрул пе каре а шезут еа, чине се ва атинӂе де лукрул ачела ва фи некурат пынэ сяра. ");
INSERT INTO ron1924_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Дакэ се кулкэ чинева ку еа ши вине песте ел некурэция фемеий ачелея, ел ва фи некурат тимп де шапте зиле ши орьче пат ын каре се ва кулка ва фи некурат. ");
INSERT INTO ron1924_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Фемея каре ва авя о скурӂере де сынӂе тимп де май мулте зиле, афарэ де сороачеле ей обишнуите, сау а кэрей скурӂере ва цине май мулт ка де обичей, ва фи некуратэ тот тимпул скурӂерий ей, ка пе время кынд ый вине сорокул. ");
INSERT INTO ron1924_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Орьче пат ын каре се ва кулка ын тимпул кыт ва цине скурӂеря ачаста ва фи ка ши патул дин тимпул кынд еа есте ла скурӂеря де ла сорок ши орьче лукру пе каре ва шедя ва фи некурат, ка атунч кынд есте еа ла скурӂеря де ла сорок. ");
INSERT INTO ron1924_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Орьчине се ва атинӂе де еле ва фи некурат; сэ-шь спеле хайнеле, сэ се скалде ын апэ ши ва фи некурат пынэ сяра. ");
INSERT INTO ron1924_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Дупэ че ва фи курэцитэ де скурӂеря ей, сэ нумере шапте зиле ши апой ва фи куратэ. ");
INSERT INTO ron1924_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","А опта зи, сэ я доуэ туртуреле сау дой пуй де порумбел ши сэ-й дукэ преотулуй ла уша кортулуй ынтылнирий. ");
INSERT INTO ron1924_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Преотул сэ адукэ унул ка жертфэ де испэшире ши алтул ка ардере-де-тот; ши преотул сэ факэ испэшире пентру еа ынаинтя Домнулуй, пентру скурӂеря каре о фэчя некуратэ. ");
INSERT INTO ron1924_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Аша сэ депэртаць пе копиий луй Исраел де некурэцииле лор, ка сэ ну моарэ дин причина некурэциилор лор, дакэ пынгэреск кортул Меу, каре есте ын мижлокул лор. ");
INSERT INTO ron1924_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Ачаста есте леӂя пентру чел че аре о скурӂере сау есте ынтинат принтр-о лепэдаре де сэмынцэ ын сомн, ");
INSERT INTO ron1924_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","пентру чя каре есте ла скурӂеря де ла сорок, пентру бэрбатул сау фемея каре аре о скурӂере ши пентру бэрбатул каре се кулкэ ку о фемее некуратэ.’” ");
INSERT INTO ron1924_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Домнул а ворбит луй Мойсе дупэ моартя челор дой фий ай луй Аарон, морць кынд с-ау ынфэцишат ынаинтя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Домнул а зис луй Мойсе: „Ворбеште фрателуй тэу Аарон ши спуне-й сэ ну интре ын тот тимпул ын Сфынтул Локаш, динколо де пердяуа динэунтру, ынаинтя капакулуй испэширий, каре есте пе кивот, ка сэ ну моарэ, кэч дясупра капакулуй испэширий Мэ вой арэта ын нор. ");
INSERT INTO ron1924_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Ятэ кум сэ интре Аарон ын Сфынтул Локаш. Сэ я ун вицел пентру жертфа де испэшире ши ун бербек пентру ардеря-де-тот. ");
INSERT INTO ron1924_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Сэ се ымбраче ку туника сфинцитэ де ин ши сэ-шь пунэ пе труп изменеле де ин; сэ се ынчингэ ку брыул де ин ши сэ-шь акопере капул ку митра де ин; ачестя сунт вешминтеле сфинците ку каре се ва ымбрэка ел дупэ че ышь ва спэла трупул ын апэ. ");
INSERT INTO ron1924_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Сэ я де ла адунаря копиилор луй Исраел дой цапь пентру жертфа де испэшире ши ун бербек пентру ардеря-де-тот. ");
INSERT INTO ron1924_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Аарон сэ-шь адукэ вицелул луй пентру жертфа де испэшире ши сэ факэ испэшире пентру ел ши пентру каса луй. ");
INSERT INTO ron1924_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Сэ я чей дой цапь ши сэ-й пунэ ынаинтя Домнулуй, ла уша кортулуй ынтылнирий. ");
INSERT INTO ron1924_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Аарон сэ арунче сорций пентру чей дой цапь: ун сорц пентру Домнул ши ун сорц пентру Азазел. ");
INSERT INTO ron1924_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Аарон сэ я цапул каре а ешит ла сорць пентру Домнул ши сэ-л адукэ жертфэ де испэшире. ");
INSERT INTO ron1924_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Яр цапул каре а ешит ла сорць пентру Азазел сэ фие пус виу ынаинтя Домнулуй, ка сэ служяскэ пентру фачеря испэширий, ши сэ и се дя друмул ын пустиу пентру Азазел. ");
INSERT INTO ron1924_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Аарон сэ-шь адукэ вицелул луй пентру жертфа де испэшире ши сэ факэ испэшире пентру ел ши пентру каса луй. Сэ ынжунгие вицелул пентру жертфа луй де испэшире. ");
INSERT INTO ron1924_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Сэ я о кэделницэ плинэ ку кэрбунь априншь де пе алтарул динаинтя Домнулуй ши дой пумнь де тэмые мироситоаре, писатэ мэрунт; сэ дукэ ачесте лукрурь динколо де пердяуа динэунтру; ");
INSERT INTO ron1924_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","сэ пунэ тэмыя пе фок ынаинтя Домнулуй, пентру ка норул де фум де тэмые сэ акопере капакул испэширий де пе кивотул мэртурией, ши астфел ну ва мури. ");
INSERT INTO ron1924_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Сэ я дин сынӂеле вицелулуй ши сэ стропяскэ ку деӂетул пе партя динаинте а капакулуй испэширий спре рэсэрит; сэ стропяскэ дин сынӂе де шапте орь ку деӂетул луй ынаинтя капакулуй испэширий. ");
INSERT INTO ron1924_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Сэ ынжунгие цапул адус ка жертфэ де испэшире пентру попор ши сэ-й дукэ сынӂеле динколо де пердяуа динэунтру. Ку сынӂеле ачеста сэ факэ ынтокмай кум а фэкут ку сынӂеле вицелулуй, сэ стропяскэ ку ел спре капакул испэширий ши ынаинтя капакулуй испэширий. ");
INSERT INTO ron1924_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Астфел, сэ факэ испэшире пентру Сфынтул Локаш, пентру некурэцииле копиилор луй Исраел ши пентру тоате кэлкэриле де леӂе прин каре ау пэкэтуит ей. Сэ факэ ла фел пентру кортул ынтылнирий, каре есте ку ей ын мижлокул некурэциилор лор. ");
INSERT INTO ron1924_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Сэ ну фие нимень ын кортул ынтылнирий кынд ва интра Аарон сэ факэ испэширя ын Сфынтул Локаш, пынэ ва еши дин ел. Сэ факэ испэшире пентру ел ши пентру каса луй ши пентру тоатэ адунаря луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Дупэ че ва еши, сэ се дукэ ла алтарул каре есте ынаинтя Домнулуй ши сэ факэ испэшире пентру алтар; сэ я дин сынӂеле вицелулуй ши цапулуй ши сэ пунэ пе коарнеле алтарулуй де жур ымпрежур. ");
INSERT INTO ron1924_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Сэ стропяскэ пе алтар ку деӂетул луй де шапте орь дин сынӂе ши астфел сэ-л курэцяскэ ши сэ-л сфинцяскэ де некурэцииле копиилор луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Кынд ва испрэви де фэкут испэширя пентру Сфынтул Локаш, пентру кортул ынтылнирий ши пентру алтар, сэ адукэ цапул чел виу. ");
INSERT INTO ron1924_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Аарон сэ-шь пунэ амындоуэ мыниле пе капул цапулуй челуй виу ши сэ мэртурисяскэ песте ел тоате фэрэделеӂиле копиилор луй Исраел ши тоате кэлкэриле лор де леӂе ку каре ау пэкэтуит ей; сэ ле пунэ пе капул цапулуй, апой сэ-л изгоняскэ ын пустиу принтр-ун ом каре ва авя ынсэрчинаря ачаста. ");
INSERT INTO ron1924_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Цапул ачела ва дуче асупра луй тоате фэрэделеӂиле лор ынтр-ун пэмынт пустиит; ын пустиу сэ-й дя друмул. ");
INSERT INTO ron1924_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Аарон сэ интре ын кортул ынтылнирий; сэ-шь лепеде вешминтеле де ин, пе каре ле ымбрэкасе ла интраря ын Сфынтул Локаш, ши сэ ле пунэ аколо. ");
INSERT INTO ron1924_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Сэ-шь спеле трупул ку апэ ынтр-ун лок сфынт ши сэ-шь я дин ноу вешминтеле. Апой сэ ясэ афарэ, сэ-шь адукэ ардеря-де-тот а луй ши ардеря-де-тот а попорулуй ши сэ факэ испэшире пентру ел ши пентру попор. ");
INSERT INTO ron1924_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Яр грэсимя жертфей де испэшире с-о ардэ пе алтар. ");
INSERT INTO ron1924_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Чел че ва изгони цапул пентру Азазел сэ-шь спеле хайнеле ши сэ-шь скалде трупул ын апэ, дупэ ачея сэ интре ярэшь ын табэрэ. ");
INSERT INTO ron1924_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Сэ скоатэ афарэ дин табэрэ вицелул испэшитор ши цапул испэшитор, ал кэрор сынӂе а фост дус ын Сфынтул Локаш пентру фачеря испэширий, ши сэ ле ардэ ын фок пеиле, карня ши балега. ");
INSERT INTO ron1924_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Чел че ле ва арде сэ-шь спеле хайнеле ши сэ-шь скалде трупул ын апэ, дупэ ачея сэ интре ярэшь ын табэрэ. ");
INSERT INTO ron1924_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Ачаста сэ вэ фие о леӂе вешникэ: ын луна а шаптя, ын а зечя зи а луний, сэ вэ смериць суфлетеле, сэ ну фачець ничо лукраре, нич бэштинашул, нич стрэинул каре локуеште ын мижлокул востру. ");
INSERT INTO ron1924_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Кэч ын зиуа ачаста се ва фаче испэшире пентру вой, ка сэ вэ курэциць: вець фи курэциць де тоате пэкателе воастре ынаинтя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Ачаста сэ фие пентру вой о зи де Сабат, о зи де одихнэ, ын каре сэ вэ смериць суфлетеле. Ачаста сэ фие о леӂе вешникэ. ");
INSERT INTO ron1924_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Испэширя сэ фие фэкутэ де преотул каре а примит унӂеря ши каре а фост ынкинат ын служба Домнулуй, ка сэ урмезе татэлуй сэу ын служба преоцией; сэ се ымбраче ку вешминтеле де ин, ку вешминтеле сфинците. ");
INSERT INTO ron1924_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Сэ факэ испэшире пентру Локул Прясфынт, сэ факэ испэшире пентру кортул ынтылнирий ши пентру алтар ши сэ факэ испэшире пентру преоць ши пентру тот попорул адунэрий. ");
INSERT INTO ron1924_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Ачаста сэ фие пентру вой о леӂе вешникэ: о датэ пе ан, сэ се факэ испэшире пентру копиий луй Исраел, пентру пэкателе лор.” Аарон а фэкут ынтокмай кум порунчисе луй Мойсе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","„Ворбеште луй Аарон ши фиилор луй ши тутурор копиилор луй Исраел ши спуне-ле: ‘Ятэ че а порунчит Домнул: ");
INSERT INTO ron1924_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","«Дакэ чинева дин каса луй Исраел ынжунгие ын табэрэ сау афарэ дин табэрэ ун боу, ун мел сау о капрэ, ");
INSERT INTO ron1924_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","ши ну-л адуче ла уша кортулуй ынтылнирий, ка сэ-л адукэ дар Домнулуй ынаинтя кортулуй Домнулуй, сынӂеле ачеста ва фи пус ын сокотяла омулуй ачелуя: а вэрсат сынӂе; омул ачела ва фи нимичит дин мижлокул попорулуй сэу. ");
INSERT INTO ron1924_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Де ачея, копиий луй Исраел, ын лок сэ-шь ынжунгие жертфеле пе кымп, требуе сэ ле адукэ ла преот, ынаинтя Домнулуй, ла уша кортулуй ынтылнирий, ши сэ ле адукэ Домнулуй ка жертфе де мулцумире. ");
INSERT INTO ron1924_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Преотул сэ ле стропяскэ сынӂеле пе алтарул Домнулуй, ла уша кортулуй ынтылнирий, ши сэ ардэ грэсимя, каре ва фи де ун мирос плэкут Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Сэ ну-шь май адукэ жертфеле лор ла идолий ку каре курвеск. Ачаста ва фи о леӂе вешникэ пентру ей ши пентру урмаший лор.» ");
INSERT INTO ron1924_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Сэ ле спуй дар: «Дакэ ун ом дин каса луй Исраел сау динтре стрэиний каре локуеск ын мижлокул лор адуче о ардере-де-тот сау врео алтэ жертфэ ");
INSERT INTO ron1924_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","ши н-о адуче ла уша кортулуй ынтылнирий, ка с-о адукэ жертфэ Домнулуй, омул ачела сэ фие нимичит дин попорул луй. ");
INSERT INTO ron1924_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Дакэ ун ом дин каса луй Исраел сау дин стрэиний каре локуеск ын мижлокул лор мэнынкэ сынӂе де орьче фел, Ымь вой ынтоарче Фаца ымпотрива челуй че мэнынкэ сынӂеле ши-л вой нимичи дин мижлокул попорулуй сэу. ");
INSERT INTO ron1924_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Кэч вяца трупулуй есте ын сынӂе. Ви л-ам дат ка сэ-л пунець пе алтар, ка сэ служяскэ де испэшире пентру суфлетеле воастре, кэч прин вяца дин ел фаче сынӂеле испэшире.» ");
INSERT INTO ron1924_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Де ачея, ам зис копиилор луй Исраел: «Нимень динтре вой сэ ну мэнынче сынӂе ши нич стрэинул каре локуеште ын мижлокул востру сэ ну мэнынче сынӂе. ");
INSERT INTO ron1924_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Дакэ вреунул дин копиий луй Исраел сау дин стрэиний каре локуеск ын мижлокул лор вынязэ о фярэ сау о пасэре каре се мэнынкэ, сэ-й версе сынӂеле ши сэ-л акопере ку цэрынэ.» ");
INSERT INTO ron1924_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Кэч вяца орькэруй труп стэ ын сынӂеле луй, каре есте ын ел. Де ачея ам зис копиилор луй Исраел: «Сэ ну мынкаць сынӂеле ничунуй труп», кэч вяца орькэруй труп есте сынӂеле луй: орьчине ва мынка дин ел ва фи нимичит. ");
INSERT INTO ron1924_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Орьчине, фие бэштинаш, фие стрэин, каре ва мынка динтр-о фярэ моартэ сау сфышиятэ, сэ-шь спеле хайнеле, сэ се скалде ын апэ ши ва фи некурат пынэ сяра; апой ва фи курат. ");
INSERT INTO ron1924_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Дакэ ну-шь спалэ хайнеле ши ну-шь скалдэ трупул, ышь ва пурта фэрэделеӂя луй.’” ");
INSERT INTO ron1924_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","„Ворбеште копиилор луй Исраел ши спуне-ле: ‘Еу сунт Домнул Думнезеул востру. ");
INSERT INTO ron1924_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Сэ ну фачець че се фаче ын цара Еӂиптулуй, унде аць локуит, ши сэ ну фачець че се фаче ын цара Канаанулуй, унде вэ дук Еу: сэ ну вэ луаць дупэ обичеюриле лор. ");
INSERT INTO ron1924_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Сэ ымплиниць порунчиле Меле ши сэ цинець леӂиле Меле: сэ ле урмаць. Еу сунт Домнул Думнезеул востру. ");
INSERT INTO ron1924_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Сэ пэзиць леӂиле ши порунчиле Меле: омул каре ле ва ымплини ва трэи прин еле. Еу сунт Домнул! ");
INSERT INTO ron1924_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Ничунул динтре вой сэ ну се апропие де руда луй де сынӂе ка сэ-й дескопере голичуня. Еу сунт Домнул. ");
INSERT INTO ron1924_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Сэ ну дескоперь голичуня татэлуй тэу, нич голичуня мамей тале. Ыць есте мамэ: сэ ну-й дескоперь голичуня. ");
INSERT INTO ron1924_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Сэ ну дескоперь голичуня невестей татэлуй тэу. Есте голичуня татэлуй тэу. ");
INSERT INTO ron1924_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Сэ ну дескоперь голичуня сурорий тале, фата татэлуй тэу сау фата мамей тале, нэскутэ ын касэ сау афарэ дин касэ. ");
INSERT INTO ron1924_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Сэ ну дескоперь голичуня фетей фиулуй тэу сау а фетей тале. Кэч есте голичуня та. ");
INSERT INTO ron1924_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Сэ ну дескоперь голичуня фетей невестей татэлуй тэу, нэскутэ дин татэл тэу. Ыць есте сорэ. ");
INSERT INTO ron1924_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Сэ ну дескоперь голичуня сурорий татэлуй тэу. Есте рудэ де апроапе ку татэл тэу. ");
INSERT INTO ron1924_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Сэ ну дескоперь голичуня сурорий мамей тале. Есте рудэ де апроапе ку мама та. ");
INSERT INTO ron1924_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Сэ ну дескоперь голичуня фрателуй татэлуй тэу. Сэ ну те апропий де неваста луй. Ыць есте мэтушэ. ");
INSERT INTO ron1924_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Сэ ну дескоперь голичуня нурорий тале. Есте неваста фиулуй тэу: сэ ну-й дескоперь голичуня. ");
INSERT INTO ron1924_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Сэ ну дескоперь голичуня невестей фрателуй тэу. Есте голичуня фрателуй тэу. ");
INSERT INTO ron1924_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Сэ ну дескоперь голичуня уней фемей ши а фетей ей. Сэ ну ей пе фата фиулуй ей, нич пе фата фетей ей, ка сэ ле дескоперь голичуня. Ыць сунт руде де апроапе: есте о нелеӂюире. ");
INSERT INTO ron1924_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Сэ ну ей пе сора невестей тале, ка сэ-й фачь ын неказ, дескоперинду-й голичуня алэтурь де невастэ-та, кыт тимп еа есте ынкэ ын вяцэ. ");
INSERT INTO ron1924_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Сэ ну те апропий де о фемее ын тимпул некурэцией ей, кынд есте ла сорок, ка сэ-й дескоперь голичуня. ");
INSERT INTO ron1924_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Сэ ну те ымпреунь ку неваста семенулуй тэу, ка сэ те пынгэрешть ку еа. ");
INSERT INTO ron1924_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Сэ ну дай пе ничунул дин копиий тэй ка сэ фие адус жертфэ луй Молох ши сэ ну пынгэрешть Нумеле Думнезеулуй тэу. Еу сунт Домнул. ");
INSERT INTO ron1924_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Сэ ну те кулчь ку ун бэрбат кум се кулкэ чинева ку о фемее. Есте о урычуне. ");
INSERT INTO ron1924_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Сэ ну те кулчь ку о витэ ка сэ те пынгэрешть ку еа. Фемея сэ ну се апропие де о витэ ка сэ курвяскэ ку еа. Есте о маре мишелие. ");
INSERT INTO ron1924_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Сэ ну вэ спуркаць ку ничунул дин ачесте лукрурь, кэч прин тоате ачесте лукрурь с-ау спуркат нямуриле пе каре ле вой изгони динаинтя воастрэ. ");
INSERT INTO ron1924_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Цара а фост спуркатэ прин еле; Еу ый вой педепси фэрэделеӂя ши пэмынтул ва вэрса дин гура луй пе локуиторий луй. ");
INSERT INTO ron1924_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Пэзиць дар леӂиле ши порунчиле Меле ши ну фачець ничуна дин ачесте спуркэчунь, нич бэштинашул, нич стрэинул каре локуеште ын мижлокул востру. ");
INSERT INTO ron1924_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Кэч тоате ачесте спуркэчунь ле-ау фэкут оамений дин цара ачаста, каре ау фост ынаинтя воастрэ ын еа; ши астфел цара а фост пынгэритэ. ");
INSERT INTO ron1924_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Луаць сяма ка ну кумва сэ вэ версе ши пе вой цара дин гура ей, дакэ о спуркаць, кум а вэрсат пе нямуриле каре ерау ын еа ынаинтя воастрэ. ");
INSERT INTO ron1924_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Кэч тоць чей че вор фаче вреуна дин ачесте спуркэчунь вор фи нимичиць дин мижлокул попорулуй лор. ");
INSERT INTO ron1924_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Пэзиць порунчиле Меле ши ну фачець ничунул дин обичеюриле урыте каре се фэчяу ынаинтя воастрэ, ка сэ ну вэ спуркаць ку еле. Еу сунт Домнул Думнезеул востру.’” ");
INSERT INTO ron1924_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","„Ворбеште ынтреӂий адунэрь а копиилор луй Исраел ши спуне-ле: ‘Фиць сфинць, кэч Еу сунт сфынт, Еу, Домнул Думнезеул востру. ");
INSERT INTO ron1924_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Фиекаре дин вой сэ чинстяскэ пе мама са ши пе татэл сэу ши сэ пэзяскэ Сабателе Меле. Еу сунт Домнул Думнезеул востру. ");
INSERT INTO ron1924_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Сэ ну вэ ынтоарчець спре идоль ши сэ ну вэ фачець думнезей турнаць. Еу сунт Домнул Думнезеул востру. ");
INSERT INTO ron1924_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Кынд вець адуче Домнулуй о жертфэ де мулцумире, с-о адучець аша ка сэ фие примитэ. ");
INSERT INTO ron1924_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Жертфа сэ фие мынкатэ ын зиуа кынд о вець жертфи сау а доуа зи; че ва май рэмыне пынэ а трея зи сэ се ардэ ын фок. ");
INSERT INTO ron1924_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Дакэ ва мынка чинева дин еа а трея зи, фаптул ачеста ва фи ун лукру урыт: жертфа ну ва фи примитэ. ");
INSERT INTO ron1924_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Чине ва мынка дин еа ышь ва пурта вина пэкатулуй сэу, кэч нечинстеште че а фост ынкинат Домнулуй: омул ачела ва фи нимичит дин попорул луй. ");
INSERT INTO ron1924_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Кынд вей сечера холделе цэрий, сэ лашь несечерат ун колц дин кымпул тэу ши сэ ну стрынӂь спичеле рэмасе пе урма сечерэторилор. ");
INSERT INTO ron1924_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Нич сэ ну кулеӂь стругурий рэмашь дупэ кулес ын вия та ши сэ ну стрынӂь боабеле каре вор кэдя дин ей. Сэ ле лашь сэракулуй ши стрэинулуй. Еу сунт Домнул Думнезеул востру. ");
INSERT INTO ron1924_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Сэ ну фураць ши сэ ну минциць, нич сэ ну вэ ыншелаць уний пе алций. ");
INSERT INTO ron1924_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Сэ ну жураць стрымб пе Нумеле Меу, кэч ай нечинсти астфел Нумеле Думнезеулуй тэу. Еу сунт Домнул. ");
INSERT INTO ron1924_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Сэ ну асупрешть пе апроапеле тэу ши сэ ну сторчь нимик де ла ел прин силэ. Сэ ну опрешть пынэ а доуа зи плата челуй токмит ку зиуа. ");
INSERT INTO ron1924_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Сэ ну ворбешть де рэу пе ун сурд ши сэ ну пуй ынаинтя унуй орб нимик каре сэ-л поатэ фаче сэ кадэ, чи сэ те темь де Думнезеул тэу. Еу сунт Домнул. ");
INSERT INTO ron1924_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Сэ ну фачь недрептате ла жудекатэ: сэ ну кауць ла фаца сэракулуй ши сэ ну пэртинешть пе нимень дин чей марь, чи сэ жудечь пе апроапеле тэу дупэ дрептате. ");
INSERT INTO ron1924_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Сэ ну умбли ку бырфель ын попорул тэу. Сэ ну те ридичь ымпотрива веций апроапелуй тэу. Еу сунт Домнул. ");
INSERT INTO ron1924_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Сэ ну урэшть пе фрателе тэу ын инима та; сэ мустри пе апроапеле тэу, дар сэ ну те ынкарчь ку ун пэкат дин причина луй. ");
INSERT INTO ron1924_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Сэ ну те рэзбунь ши сэ ну ций неказ пе копиий попорулуй тэу. Сэ юбешть пе апроапеле тэу ка пе тине ынсуць. Еу сунт Домнул. ");
INSERT INTO ron1924_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Сэ пэзиць леӂиле Меле. Сэ ну ымпреунь вите де доуэ союрь деосебите; сэ ну семень ын огорул тэу доуэ фелурь де семинце ши сэ ну порць о хайнэ цесутэ дин доуэ фелурь де фире. ");
INSERT INTO ron1924_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Кынд ун ом се ва кулка ку о фемее роабэ, логодитэ ку ун алт бэрбат, ши еа н-а фост рэскумпэратэ де тот сау слобозитэ, сэ фие педепсиць амындой, дар ну педепсиць ку моартя, пентру кэ еа ну ера слободэ. ");
INSERT INTO ron1924_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Ел сэ адукэ Домнулуй пентру вина луй ла уша кортулуй ынтылнирий ун бербек ка жертфэ пентру винэ. ");
INSERT INTO ron1924_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Преотул сэ факэ испэшире пентру ел ынаинтя Домнулуй, пентру пэкатул пе каре л-а фэкут, ку бербекул адус ка жертфэ пентру винэ, ши пэкатул пе каре л-а фэкут ый ва фи ертат. ");
INSERT INTO ron1924_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Кынд вець интра ын царэ ши вець сэди тот фелул де помь родиторь, роаделе лор сэ ле привиць ка нетэяте ымпрежур; тимп де трей ань сэ фие нетэяте ымпрежур пентру вой; сэ ну мынкаць дин еле. ");
INSERT INTO ron1924_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Ын ал патруля ан, тоате роаделе сэ фие ынкинате Домнулуй, спре лауда Луй. ");
INSERT INTO ron1924_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Ын ал чинчиля ан, сэ мынкаць роаделе, ка еле сэ ви се ынмулцяскэ дин че ын че май мулт: Еу сунт Домнул Думнезеул востру. ");
INSERT INTO ron1924_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Сэ ну мынкаць нимик ку сынӂе. Сэ ну гичиць дупэ вырколачь, нич дупэ норь. ");
INSERT INTO ron1924_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Сэ ну-ць тай ротунд колцуриле пэрулуй ши сэ ну-ць разь колцуриле бэрбий. ");
INSERT INTO ron1924_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Сэ ну вэ фачець тэетурь ын карне пентру ун морт ши сэ ну вэ фачець слове сэпате пе вой. Еу сунт Домнул. ");
INSERT INTO ron1924_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Сэ ну-ць нечинстешть фата дынд-о сэ фие курвэ, пентру ка ну кумва цара сэ ажунгэ ун лок де курвие ши сэ се умпле де фэрэделеӂь. ");
INSERT INTO ron1924_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Сэ пэзиць Сабателе Меле ши сэ чинстиць Локашул Меу чел Сфынт. Еу сунт Домнул. ");
INSERT INTO ron1924_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Сэ ну вэ дучець ла чей че кямэ духуриле морцилор, нич ла врэжиторь: сэ ну-й ынтребаць, ка сэ ну вэ спуркаць ку ей. Еу сунт Домнул Думнезеул востру. ");
INSERT INTO ron1924_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Сэ те сколь ынаинтя перилор албь ши сэ чинстешть пе бэтрын. Сэ те темь де Думнезеул тэу. Еу сунт Домнул. ");
INSERT INTO ron1924_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Дакэ ун стрэин вине сэ локуяскэ ымпреунэ ку вой ын цара воастрэ, сэ ну-л асуприць. ");
INSERT INTO ron1924_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Сэ вэ пуртаць ку стрэинул каре локуеште ынтре вой ка ши ку ун бэштинаш дин мижлокул востру; сэ-л юбиць ка пе вой ыншивэ, кэч ши вой аць фост стрэинь ын цара Еӂиптулуй. Еу сунт Домнул Думнезеул востру. ");
INSERT INTO ron1924_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Сэ ну фачець недрептате ла жудекатэ, нич ын мэсуриле де лунӂиме, нич ын греутэць, нич ын мэсуриле де ынкэпере. ");
INSERT INTO ron1924_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Сэ авець кумпене дрепте, греутэць дрепте, ефе дрепте ши хине дрепте. Еу сунт Домнул Думнезеул востру, каре в-ам скос дин цара Еӂиптулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Сэ пэзиць тоате леӂиле Меле ши тоате порунчиле Меле ши сэ ле ымплиниць. Еу сунт Домнул.’” ");
INSERT INTO ron1924_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","„Спуне копиилор луй Исраел: ‘Дакэ ун ом динтре копиий луй Исраел сау динтре стрэиний каре локуеск ын Исраел дэ луй Молох пе унул дин копиий луй, омул ачела сэ фие педепсит ку моартя: попорул дин царэ сэ-л учидэ ку петре. ");
INSERT INTO ron1924_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Ши Еу Ымь вой ынтоарче Фаца ымпотрива омулуй ачелуя ши-л вой нимичи дин мижлокул попорулуй сэу, пентру кэ а дат луй Молох пе унул дин копиий сэй, а спуркат Локашул Меу чел Сфынт ши а нечинстит Нумеле Меу чел сфынт. ");
INSERT INTO ron1924_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Дакэ попорул цэрий ынкиде окий фацэ де омул ачела каре дэ луй Молох копий де-ай сэй ши ну-л омоарэ, ");
INSERT INTO ron1924_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","Ымь вой ынтоарче Еу Фаца ымпотрива омулуй ачелуя ши ымпотрива фамилией луй ши-л вой нимичи дин мижлокул попорулуй луй, ымпреунэ ку тоць чей че курвеск ка ел ку Молох. ");
INSERT INTO ron1924_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Дакэ чинева се дуче ла чей че кямэ пе морць ши ла гичиторь ка сэ курвяскэ дупэ ей, Ымь вой ынтоарче Фаца ымпотрива омулуй ачелуя ши-л вой нимичи дин мижлокул попорулуй луй. ");
INSERT INTO ron1924_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Вой сэ вэ сфинциць ши сэ фиць сфинць, кэч Еу сунт Домнул Думнезеул востру. ");
INSERT INTO ron1924_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Сэ пэзиць леӂиле Меле ши сэ ле ымплиниць. Еу сунт Домнул, каре вэ сфинцеск. ");
INSERT INTO ron1924_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Дакэ ун ом оарекаре блестемэ пе татэл сэу сау пе мама са, сэ фие педепсит ку моартя; а блестемат пе татэл сэу сау пе мама са: сынӂеле луй сэ кадэ асупра луй. ");
INSERT INTO ron1924_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Дакэ ун ом прякурвеште ку о фемее мэритатэ, дакэ прякурвеште ку неваста апроапелуй сэу, омул ачела ши фемея ачея прякурварь сэ фие педепсиць ку моартя. ");
INSERT INTO ron1924_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Дакэ ун ом се кулкэ ку неваста татэлуй сэу ши дескоперэ астфел голичуня татэлуй сэу, омул ачела ши фемея ачея сэ фие педепсиць ку моартя; сынӂеле лор сэ кадэ асупра лор. ");
INSERT INTO ron1924_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Дакэ ун ом се кулкэ ку норэ-са, амындой сэ фие педепсиць ку моартя; ау фэкут о аместекэтурэ де сынӂе: сынӂеле лор сэ кадэ асупра лор. ");
INSERT INTO ron1924_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Дакэ ун ом се кулкэ ку ун ом кум се кулкэ чинева ку о фемее, амындой ау фэкут ун лукру скырбос; сэ фие педепсиць ку моартя, сынӂеле лор сэ кадэ асупра лор. ");
INSERT INTO ron1924_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Дакэ ун ом я де невесте пе фатэ ши пе мама ей, есте о нелеӂюире: сэ-й ардэ ын фок, пе ел ши пе еле, ка нелеӂюиря ачаста сэ ну фие ын мижлокул востру. ");
INSERT INTO ron1924_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Дакэ ун ом се кулкэ ку о витэ, сэ фие педепсит ку моартя, ши вита с-о оморыць. ");
INSERT INTO ron1924_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Дакэ о фемее се апропие де о витэ ка сэ курвяскэ ку еа, сэ учизь ши пе фемее, ши пе витэ; сэ фие оморыте: сынӂеле лор сэ кадэ асупра лор. ");
INSERT INTO ron1924_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Дакэ ун ом я пе сорэ-са, фата татэлуй сэу сау фата мамей луй, дакэ ый веде голичуня ей ши еа й-о веде пе а луй, есте о мишелие; сэ фие нимичиць суб окий копиилор попорулуй лор; ел а дескоперит голичуня сурорий луй, ышь ва луа педяпса пентру пэкатул луй. ");
INSERT INTO ron1924_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Дакэ ун ом се кулкэ ку о фемее каре есте ла сорокул фемеилор ши-й дескоперэ голичуня, дакэ-й дескоперэ скурӂеря ши еа ышь дескоперэ скурӂеря сынӂелуй ей, амындой сэ фие нимичиць дин мижлокул попорулуй лор. ");
INSERT INTO ron1924_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Сэ ну дескоперь голичуня сурорий мамей тале, нич а сурорий татэлуй тэу, кэч ынсямнэ сэ дескоперь пе руда та де апроапе: амындой ачештя ышь вор луа педяпса пэкатулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Дакэ ун ом се кулкэ ку мэтушэ-са, а дескоперит голичуня ункюлуй сэу; ышь вор луа педяпса пэкатулуй лор: вор мури фэрэ копий. ");
INSERT INTO ron1924_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Дакэ ун ом я пе неваста фрателуй сэу, есте о некурэцие; а дескоперит голичуня фрателуй сэу: ну вор авя копий. ");
INSERT INTO ron1924_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Сэ пэзиць тоате леӂиле Меле ши тоате порунчиле Меле ши сэ ле ымплиниць, пентру ка цара ын каре вэ дук сэ вэ ашез сэ ну вэ версе дин гура ей. ");
INSERT INTO ron1924_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Сэ ну трэиць дупэ обичеюриле нямурилор пе каре ле вой изгони динаинтя воастрэ, кэч еле ау фэкут тоате ачесте лукрурь ши Мь-есте скырбэ де еле. ");
INSERT INTO ron1924_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","В-ам спус: «Вой ле вець стэпыни цара; Еу вэ вой да-о ын стэпынире: есте о царэ ын каре курӂе лапте ши мьере.» Еу сунт Домнул Думнезеул востру, каре в-ам пус деопарте динтре попоаре. ");
INSERT INTO ron1924_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Сэ фачець деосебире ынтре добитоачеле курате ши некурате, ынтре пэсэриле курате ши некурате, ка сэ ну вэ спуркаць прин добитоаче, прин пэсэрь, прин тоате тырытоареле де пе пэмынт, пе каре в-ам ынвэцат сэ ле деосебиць ка некурате. ");
INSERT INTO ron1924_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Вой сэ-Мь фиць сфинць, кэч Еу сунт сфынт, Еу, Домнул; Еу в-ам пус деопарте динтре попоаре, ка сэ фиць ай Мей. ");
INSERT INTO ron1924_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Дар, дакэ ун ом сау о фемее кямэ духул унуй морт сау се ынделетничеште ку гичиря, сэ фие педепсит ку моартя; сэ-й учидець ку петре: сынӂеле лор сэ кадэ асупра лор.’” ");
INSERT INTO ron1924_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Домнул а зис луй Мойсе: „Ворбеште преоцилор, фиилор луй Аарон, ши спуне-ле: ‘Ун преот сэ ну се атингэ де ун морт дин попорул сэу, ка сэ ну се факэ некурат; ");
INSERT INTO ron1924_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","афарэ де руделе луй челе май де апроапе: де мама луй, де татэл луй, де фиул луй, де фрателе луй ");
INSERT INTO ron1924_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ши де сорэ-са каре-й ынкэ фечоарэ, стэ лынгэ ел ши ну есте мэритатэ; афарэ де ачештя, сэ ну се атингэ де ничун алт морт. ");
INSERT INTO ron1924_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Ка унул каре есте фрунташ ын попорул луй, сэ ну се факэ некурат атингынду-се де ун морт. ");
INSERT INTO ron1924_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Преоций сэ ну-шь факэ ун лок плешув ын кап пентру ун морт, сэ ну-шь радэ колцуриле бэрбий ши сэ ну-шь факэ тэетурь ын карне. ");
INSERT INTO ron1924_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Сэ фие сфинць пентру Думнезеул лор ши сэ ну нечинстяскэ Нумеле Думнезеулуй лор, кэч ей адук Домнулуй жертфеле мистуите де фок, мынкаря Думнезеулуй лор, де ачея сэ фие сфинць. ");
INSERT INTO ron1924_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Сэ ну-шь я де невастэ о курвэ сау о спуркатэ, нич о фемее лэсатэ де бэрбатул ей, кэч ей сунт сфинць пентру Думнезеул лор. ");
INSERT INTO ron1924_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Сэ-л сокотешть ка сфынт, кэч ел адуче мынкаря Думнезеулуй тэу; ел сэ фие сфынт пентру тине, кэч Еу сунт сфынт, Еу, Домнул, каре вэ сфинцеск. ");
INSERT INTO ron1924_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Дакэ фата унуй преот се нечинстеште курвинд, нечинстеште пе татэл ей: сэ фие арсэ ын фок. ");
INSERT INTO ron1924_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Преотул каре есте маре преот ынтре фраций луй, пе капул кэруя а фост турнат унтделемнул пентру унӂере ши каре а фост ынкинат ын служба Домнулуй ши ымбрэкат ын вешминте сфинците, сэ ну-шь дескопере капул ши сэ ну-шь сфышие вешминтеле. ");
INSERT INTO ron1924_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Сэ ну се дукэ ла ничун морт; сэ ну се факэ некурат ши сэ ну се атингэ нич кяр де татэл сэу сау де мама са. ");
INSERT INTO ron1924_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Сэ ну ясэ дин Сфынтул Локаш ши сэ ну нечинстяскэ Сфынтул Локаш ал Думнезеулуй сэу, кэч унтделемнул унӂерий Думнезеулуй сэу есте о кунунэ пе ел. Еу сунт Домнул. ");
INSERT INTO ron1924_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Фемея пе каре о ва луа ел де невастэ сэ фие фечоарэ. ");
INSERT INTO ron1924_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Сэ ну я нич о вэдувэ, нич о фемее деспэрцитэ де бэрбат, нич о фемее спуркатэ сау курвэ, чи фемея пе каре о ва луа де невастэ дин попорул сэу сэ фие фечоарэ. ");
INSERT INTO ron1924_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Сэ ну-шь нечинстяскэ сэмынца ын попорул луй, кэч Еу сунт Домнул, каре-л сфинцеск.’” ");
INSERT INTO ron1924_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","„Ворбеште луй Аарон ши спуне-й: ‘Ничун ом дин нямул тэу ши дин урмаший тэй каре ва авя о метяхнэ трупяскэ сэ ну се апропие ка сэ адукэ мынкаря Думнезеулуй луй. ");
INSERT INTO ron1924_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Ничун ом каре ва авя о метяхнэ трупяскэ ну ва путя сэ се апропие, ши ануме ничун ом орб, шкьоп, ку насул кырн сау ку ун мэдулар май лунг; ");
INSERT INTO ron1924_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ничун ом ку пичорул фрынт сау ку мына фрынтэ; ");
INSERT INTO ron1924_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ничун ом гебос сау пиперничит, ку албяцэ ын окь, каре аре рые, печинӂине сау бошит. ");
INSERT INTO ron1924_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Ничун ом дин нямул преотулуй Аарон каре ва авя врео метяхнэ трупяскэ сэ ну се апропие ка сэ адукэ Домнулуй жертфеле мистуите де фок; аре о метяхнэ трупяскэ – сэ ну се апропие ка сэ адукэ мынкаря Думнезеулуй луй. ");
INSERT INTO ron1924_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Дин мынкаря Думнезеулуй луй, фие лукрурь прясфинте, фие лукрурь сфинте, ва путя сэ мэнынче. ");
INSERT INTO ron1924_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Дар сэ ну се дукэ ла пердяуа динэунтру ши сэ ну се апропие де алтар, кэч аре о метяхнэ трупяскэ; сэ ну-Мь нечинстяскэ локашуриле Меле челе сфинте, кэч Еу сунт Домнул, каре ый сфинцеск.’” ");
INSERT INTO ron1924_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Астфел а ворбит Мойсе луй Аарон ши фиилор сэй ши тутурор копиилор луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","„Ворбеште луй Аарон ши фиилор луй ка сэ се феряскэ де лукруриле сфинте, каре Ымь сунт ынкинате де копиий луй Исраел ши сэ ну нечинстяскэ Нумеле Меу чел сфынт. Еу сунт Домнул. ");
INSERT INTO ron1924_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Спуне-ле: ‘Орьче ом динтре урмаший воштри ши дин нямул востру каре се ва апропия де лукруриле сфинте пе каре ле ынкинэ Домнулуй копиий луй Исраел ши каре ва авя пе ел о некурэцие, омул ачела сэ фие нимичит динаинтя Мя. Еу сунт Домнул. ");
INSERT INTO ron1924_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Орьче ом дин нямул луй Аарон каре ва авя лепрэ сау скурӂере де сэмынцэ сэ ну мэнынче дин лукруриле сфинте пынэ ну ва фи курат. Тот аша ши чел че се ва атинӂе де чинева спуркат прин атинӂеря де вреун морт, де чел че ва авя о лепэдаре де сэмынцэ ын сомн, ");
INSERT INTO ron1924_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","чел че се ва атинӂе де о тырытоаре ши се ва спурка сау ун ом атинс де врео некурэцие оарекаре ши каре се ва фи фэкут некурат прин еа. ");
INSERT INTO ron1924_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Чине се ва атинӂе де ачесте лукрурь ва фи некурат пынэ сяра; сэ ну мэнынче дин лукруриле сфинте декыт дупэ че ышь ва скэлда трупул ын апэ; ");
INSERT INTO ron1924_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","дупэ асфинцитул соарелуй ва фи курат ши, ын урмэ, ва мынка дин лукруриле сфинте, кэч ачаста есте храна луй. ");
INSERT INTO ron1924_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Сэ ну мэнынче динтр-о витэ моартэ сау сфышиятэ, ка сэ ну се спурче ку еа. Еу сунт Домнул. ");
INSERT INTO ron1924_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Сэ пэзяскэ порунчиле Меле, ка сэ ну-шь я педяпса пентру пэкатул лор ши сэ ну моарэ пентру кэ ау нечинстит лукруриле сфинте. Еу сунт Домнул, каре ый сфинцеск. ");
INSERT INTO ron1924_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Ничун стрэин сэ ну мэнынче дин лукруриле сфинте; чел че локуеште ла ун преот ка оаспете ши чел токмит ку зиуа сэ ну мэнынче дин лукруриле сфинте. ");
INSERT INTO ron1924_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Дар робул кумпэрат де преот ку прец де арӂинт ва путя сэ мэнынче, тот аша ши чел нэскут ын каса луй; ей сэ мэнынче дин храна луй. ");
INSERT INTO ron1924_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Фата унуй преот мэритатэ дупэ ун стрэин сэ ну мэнынче дин лукруриле сфинте адусе жертфэ прин ридикаре. ");
INSERT INTO ron1924_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Дар фата унуй преот каре ва фи рэмас вэдувэ сау деспэрцитэ де бэрбат, фэрэ сэ айбэ копий, ши каре се ва ынтоарче ын каса татэлуй сэу, ка атунч кынд ера фатэ, ва путя сэ мэнынче дин храна татэлуй ей. Дар ничун стрэин сэ ну мэнынче дин еа. ");
INSERT INTO ron1924_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Дакэ ун ом мэнынкэ динтр-ун лукру сфынт фэрэ сэ баӂе де сямэ, сэ дя преотулуй прецул лукрулуй сфынт, адэугынд ынкэ о чинчиме ла ел. ");
INSERT INTO ron1924_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Преоций сэ ну нечинстяскэ лукруриле сфинте адусе де копиий луй Исраел, пе каре ле-ау адус ей Домнулуй ка жертфэ прин ридикаре; ");
INSERT INTO ron1924_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","ей вор фаче сэ апесе астфел асупра лор пэкатул де каре с-ар фаче виноваць мынкынд дин лукруриле сфинте: кэч Еу сунт Домнул, каре ый сфинцеск.’” ");
INSERT INTO ron1924_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","„Ворбеште луй Аарон ши фиилор луй ши тутурор копиилор луй Исраел ши спуне-ле: ‘Орьче ом дин каса луй Исраел сау динтре стрэиний дин Исраел каре ва адуче о ардере-де-тот Домнулуй, фие пентру ымплиниря уней журуинце, фие ка дар де бунэвое, ");
INSERT INTO ron1924_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","сэ я о парте бэрбэтяскэ фэрэ кусур дин бой, мей сау капре, пентру ка жертфа сэ фие примитэ. ");
INSERT INTO ron1924_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Сэ ну адучець ничуна каре сэ айбэ вреун кусур, кэч н-ар фи примитэ. ");
INSERT INTO ron1924_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Дакэ ун ом адуче Домнулуй дин бой сау дин ой о жертфэ де мулцумире, фие пентру ымплиниря уней журуинце, фие ка дар де бунэвое, вита пентру жертфэ сэ фие фэрэ кусур, ка сэ фие примитэ; сэ н-айбэ ничун кусур ын еа. ");
INSERT INTO ron1924_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Сэ н-адучець ничуна каре сэ фие оарбэ, слутэ сау чунтитэ, каре сэ айбэ бубе, рые сау печинӂине; дин ачестя сэ н-адучець пе алтар ка жертфэ мистуитэ де фок ынаинтя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Ка дар де бунэвое, вей путя сэ жертфешть ун боу сау ун мел ку ун мэдулар пря лунг сау пря скурт, дар, ка дар пентру ымплиниря уней журуинце, ну ва фи примит. ");
INSERT INTO ron1924_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Сэ н-адучець Домнулуй ун добиток ку боашеле фрынте, стрикате, смулсе сау тэяте; сэ ну-л адучець ка жертфэ ын цара воастрэ. ");
INSERT INTO ron1924_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Нич сэ ну луаць де ла стрэин вреунул дин ачесте добитоаче ка сэ-л адучець ка мынкаре Думнезеулуй востру, кэч сунт слуците, ау метехне, ши н-ар фи примите.’” ");
INSERT INTO ron1924_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Домнул а зис луй Мойсе: ");
INSERT INTO ron1924_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","„Вицелул, мелул сау едул, дупэ наштере, сэ май рэмынэ шапте зиле ку мама са ши апой, де ла а опта зи ынаинте, ва фи примит сэ фие адус Домнулуй ка жертфэ мистуитэ де фок. ");
INSERT INTO ron1924_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Вака, оая сау капра сэ н-о ынжунгияць ка жертфэ ын ачеяшь зи ку фэтул ей. ");
INSERT INTO ron1924_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Кынд вець адуче Домнулуй о жертфэ де мулцумире, с-о адучець аша ка сэ фие примитэ. ");
INSERT INTO ron1924_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Вита сэ се мэнынче ын ачеяшь зи; сэ ну лэсаць нимик дин еа пынэ а доуа зи диминяца. Еу сунт Домнул. ");
INSERT INTO ron1924_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Сэ пэзиць порунчиле Меле ши сэ ле ымплиниць. Еу сунт Домнул. ");
INSERT INTO ron1924_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Сэ ну нечинстиць Нумеле Меу чел сфынт, ка сэ фиу сфинцит ын мижлокул копиилор луй Исраел. Еу сунт Домнул, каре вэ сфинцеск ");
INSERT INTO ron1924_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","ши каре в-ам скос дин цара Еӂиптулуй, ка сэ фиу Думнезеул востру. Еу сунт Домнул.” ");
INSERT INTO ron1924_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","„Ворбеште копиилор луй Исраел ши спуне-ле: ‘Ятэ сэрбэториле Домнулуй, пе каре ле вець вести ка адунэрь сфинте, ятэ сэрбэториле Меле: ");
INSERT INTO ron1924_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Шасе зиле сэ лукраць, дар зиуа а шаптя есте Сабатул, зиуа де одихнэ, ку о адунаре сфынтэ. Сэ ну фачець ничо лукраре ын тимпул ей: есте Сабатул Домнулуй ын тоате локуинцеле воастре. ");
INSERT INTO ron1924_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Ятэ сэрбэториле Домнулуй, ку адунэрь сфинте, пе каре ле вець вести ла времуриле лор хотэрыте. ");
INSERT INTO ron1924_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Ын луна ынтый, ын а пайспрезечя зи а луний, ынтре челе доуэ серь, вор фи Паштеле Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Ши ын а чинчспрезечя зи а луний ачестея, ва фи Сэрбэтоаря Азимилор ын чинстя Домнулуй; шапте зиле сэ мынкаць азиме. ");
INSERT INTO ron1924_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Ын зиуа ынтый, сэ авець о адунаре сфынтэ: атунч сэ ну фачець ничо лукраре де слугэ. ");
INSERT INTO ron1924_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Шапте зиле сэ адучець Домнулуй жертфе мистуите де фок. Ын зиуа а шаптя сэ фие о адунаре сфынтэ: атунч сэ ну фачець ничо лукраре де слугэ.’” ");
INSERT INTO ron1924_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","„Ворбеште копиилор луй Исраел ши спуне-ле: ‘Кынд вець интра ын цара пе каре в-о дау ши кынд вець сечера семэнэтуриле, сэ адучець преотулуй ун сноп, ка пыргэ а сечеришулуй востру. ");
INSERT INTO ron1924_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Ел сэ леӂене снопул ынтр-о парте ши ынтр-алта ынаинтя Домнулуй, ка сэ фие примит: преотул сэ-л леӂене ынтр-о парте ши ынтр-алта, а доуа зи дупэ Сабат. ");
INSERT INTO ron1924_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Ын зиуа кынд вець легэна снопул, сэ адучець, ка ардере-де-тот Домнулуй, ун мел де ун ан фэрэ кусур; ");
INSERT INTO ron1924_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","сэ адэугаць ла ел доуэ зечимь де ефэ дин флоаря фэиний фрэмынтатэ ку унтделемн, ка дар де мынкаре мистуит де фок, де ун мирос плэкут Домнулуй, ши сэ адучець о жертфэ де бэутурэ де ун сферт де хин де вин. ");
INSERT INTO ron1924_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Сэ ну мынкаць нич пыне, нич спиче прэжите сау писате пынэ ын зиуа ачаста, кынд вець адуче ун дар де мынкаре Думнезеулуй востру. Ачаста есте о леӂе вешникэ пентру урмаший воштри, ын тоате локуриле ын каре вець локуи. ");
INSERT INTO ron1924_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Де а доуа зи дупэ Сабат, дин зиуа кынд вець адуче снопул ка сэ фие легэнат ынтр-о парте ши ынтр-алта, сэ нумэраць шапте сэптэмынь ынтреӂь. ");
INSERT INTO ron1924_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Сэ нумэраць чинчзечь де зиле, пынэ ын зиуа каре вине дупэ ал шаптеля Сабат, ши атунч сэ адучець Домнулуй ун ноу дар де мынкаре. ");
INSERT INTO ron1924_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Сэ адучець дин локуинцеле воастре доуэ пынь, ка сэ фие легэнате ынтр-о парте ши ынтр-алта; сэ фие фэкуте ку доуэ зечимь де ефэ дин флоаря фэиний ши коапте ку алуат: ачестя сунт челе динтый роаде пентру Домнул. ");
INSERT INTO ron1924_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Афарэ де ачесте пынь, сэ адучець ка ардере-де-тот Домнулуй шапте мей де ун ан, фэрэ кусур, ун вицел ши дой бербечь; сэ адэугаць ла ей дарул де мынкаре ши жертфа де бэутурэ обишнуите, ка дар де мынкаре мистуит де фок, де ун мирос плэкут Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Сэ адучець ши ун цап, ка жертфэ де испэшире, ши дой мей де ун ан, ка жертфэ де мулцумире. ");
INSERT INTO ron1924_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Преотул сэ леӂене ачесте добитоаче ынтр-о парте ши ынтр-алта ка дар легэнат ынаинтя Домнулуй, ымпреунэ ку пыня адусэ ка пыргэ ши ку чей дой мей: еле сэ фие ынкинате Домнулуй ши сэ фие але преотулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Ын ачеяшь зи, сэ вестиць сэрбэтоаря ши сэ авець о адунаре сфынтэ: атунч сэ ну фачець ничо лукраре де слугэ. Ачаста есте о леӂе вешникэ пентру урмаший воштри, ын тоате локуриле ын каре вець локуи. ");
INSERT INTO ron1924_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Кынд вей сечера семэнэтуриле дин цара воастрэ, сэ лашь несечерат ун колц дин кымпул тэу ши сэ ну стрынӂь че рэмыне де пе урма сечерэторилор. Сэ лашь сэракулуй ши стрэинулуй ачесте спиче. Еу сунт Домнул Думнезеул востру.’” ");
INSERT INTO ron1924_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","„Ворбеште копиилор луй Исраел ши спуне-ле: ‘Ын луна а шаптя, ын чя динтый зи а луний, сэ авець о зи де одихнэ, веститэ ку сунет де трымбице, ши о адунаре сфынтэ. ");
INSERT INTO ron1924_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Атунч сэ ну фачець ничо лукраре де слугэ ши сэ адучець Домнулуй жертфе мистуите де фок.’” ");
INSERT INTO ron1924_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","„Ын зиуа а зечя а ачестей а шаптя лунь, ва фи Зиуа Испэширий: атунч сэ авець о адунаре сфынтэ, сэ вэ смериць суфлетеле ши сэ адучець Домнулуй жертфе мистуите де фок. ");
INSERT INTO ron1924_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Сэ ну фачець ничо лукраре ын зиуа ачея, кэч есте Зиуа Испэширий, кынд требуе фэкутэ испэшире пентру вой ынаинтя Домнулуй Думнезеулуй востру. ");
INSERT INTO ron1924_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Орьчине ну се ва смери ын зиуа ачея ва фи нимичит дин попорул луй. ");
INSERT INTO ron1924_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Пе орьчине ва фаче ын зиуа ачея врео лукраре оарекаре, ыл вой нимичи дин мижлокул попорулуй луй. ");
INSERT INTO ron1924_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Сэ ну фачець ничо лукраре атунч. Ачаста есте о леӂе вешникэ пентру урмаший воштри, ын тоате локуриле ын каре вець локуи. ");
INSERT INTO ron1924_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Ачаста сэ фие пентру вой о зи де Сабат, о зи де одихнэ, ши сэ вэ смериць суфлетеле ын зиуа ачаста; дин сяра зилей а ноуа пынэ ын сяра урмэтоаре, сэ прэзнуиць Сабатул востру.” ");
INSERT INTO ron1924_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","„Ворбеште копиилор луй Исраел ши спуне-ле: ‘Ын а чинчспрезечя зи а ачестей а шаптя лунь, ва фи Сэрбэтоаря Кортурилор ын чинстя Домнулуй, тимп де шапте зиле. ");
INSERT INTO ron1924_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Ын зиуа ынтый сэ фие о адунаре сфынтэ: сэ ну фачець ничо лукраре де слугэ ын тимпул ей. ");
INSERT INTO ron1924_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Тимп де шапте зиле, сэ адучець Домнулуй жертфе мистуите де фок. А опта зи, сэ авець о адунаре сфынтэ ши сэ адучець Домнулуй жертфе мистуите де фок; ачаста сэ фие о адунаре де сэрбэтоаре: сэ ну фачець ничо лукраре де слугэ ын тимпул ей. ");
INSERT INTO ron1924_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Ачестя сунт сэрбэториле Домнулуй, ын каре вець вести адунэрь сфинте, ка сэ се адукэ Домнулуй жертфе мистуите де фок, ардерь-де-тот, дарурь де мынкаре, жертфе де вите ши жертфе де бэутурэ, фиекаре лукру ла зиуа хотэрытэ. ");
INSERT INTO ron1924_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Афарэ де ачаста, сэ пэзиць Сабателе Домнулуй ши сэ вэ адучець даруриле воастре Домнулуй, сэ адучець тоате жертфеле фэкуте пентру ымплиниря уней журуинце ши тоате даруриле воастре фэкуте де бунэвое. ");
INSERT INTO ron1924_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Ын а чинчспрезечя зи а луний ачестея а шаптя, кынд вець стрынӂе роаделе цэрий, сэ прэзнуиць о сэрбэтоаре ын чинстя Домнулуй, тимп де шапте зиле: чя динтый зи сэ фие о зи де одихнэ ши а опта сэ фие тот о зи де одихнэ. ");
INSERT INTO ron1924_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Ын зиуа ынтый сэ луаць поаме дин помий чей фрумошь, рамурь де финичь, рамурь де копачь стуфошь ши де сэлчий де рыу ши сэ вэ букураць ынаинтя Домнулуй Думнезеулуй востру шапте зиле. ");
INSERT INTO ron1924_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Ын фиекаре ан сэ прэзнуиць сэрбэтоаря ачаста ын чинстя Домнулуй, тимп де шапте зиле. Ачаста есте о леӂе вешникэ пентру урмаший воштри. Ын луна а шаптя с-о прэзнуиць. ");
INSERT INTO ron1924_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Шапте зиле сэ локуиць ын кортурь; тоць бэштинаший дин Исраел сэ локуяскэ ын кортурь, ");
INSERT INTO ron1924_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","пентру ка урмаший воштри сэ штие кэ ам фэкут пе копиий луй Исраел сэ локуяскэ ын кортурь, дупэ че й-ам скос дин цара Еӂиптулуй. Еу сунт Домнул Думнезеул востру.’” ");
INSERT INTO ron1924_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Аша а спус Мойсе копиилор луй Исраел каре сунт сэрбэториле Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","„Порунчеште копиилор луй Исраел сэ-ць адукэ пентру сфешник унтделемн курат де мэслине тескуите, ка сэ цинэ канделеле апринсе неынчетат. ");
INSERT INTO ron1924_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Аарон сэ-л прегэтяскэ динкоаче де пердяуа динэунтру, каре есте ынаинтя мэртурией, ын кортул ынтылнирий, пентру ка сэ ардэ неынчетат, де сяра пынэ диминяца, ын фаца Домнулуй. Ачаста есте о леӂе вешникэ пентру урмаший воштри. ");
INSERT INTO ron1924_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Сэ ашезе канделеле ын сфешникул де аур курат, ка сэ ардэ неынчетат ынаинтя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Сэ ей флоаре де фэинэ ши сэ фачь дин еа доуэспрезече турте; фиекаре туртэ сэ фие фэкутэ дин доуэ зечимь де ефэ. ");
INSERT INTO ron1924_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Сэ ле пуй ын доуэ ширурь, кыте шасе ын фиекаре шир, пе маса де аур курат, ынаинтя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Песте фиекаре шир сэ пуй тэмые куратэ, каре сэ фие пе пыне ка адучере аминте, ка ун дар де мынкаре мистуит де фок ынаинтя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Ын фиекаре зи де Сабат, сэ се пунэ ачесте пынь ынаинтя Домнулуй, неынчетат: ачеста есте ун легэмынт вешник пе каре-л вор цине копиий луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Пыниле ачестя сэ фие але луй Аарон ши але фиилор луй ши сэ ле мэнынче ынтр-ун лок сфынт; кэч еле сунт пентру ей ун лукру прясфынт, о парте дин даруриле де мынкаре мистуите де фок ынаинтя Домнулуй. Ачаста есте о леӂе вешникэ.” ");
INSERT INTO ron1924_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Фиул уней фемей исраелите ши ал унуй бэрбат еӂиптян, венинд ын мижлокул копиилор луй Исраел, с-а чертат ын табэрэ ку ун бэрбат исраелит. ");
INSERT INTO ron1924_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Фиул фемеий исраелите а хулит ши а блестемат Нумеле луй Думнезеу. Л-ау адус ла Мойсе. Мама са се нумя Шеломит, фата луй Дибри, дин семинция луй Дан. ");
INSERT INTO ron1924_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Л-ау арункат ын темницэ, пынэ ва спуне Мойсе че ва порунчи Домнул. ");
INSERT INTO ron1924_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","„Скоате дин табэрэ пе чел че а хулит; тоць чей че л-ау аузит сэ-шь пунэ мыниле пе капул луй ши тоатэ адунаря сэ-л учидэ ку петре. ");
INSERT INTO ron1924_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Сэ ворбешть копиилор луй Исраел ши сэ ле спуй: ‘Орьчине ва блестема пе Думнезеул луй ышь ва луа педяпса пентру пэкатул луй. ");
INSERT INTO ron1924_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Чине ва блестема Нумеле Домнулуй ва фи педепсит ку моартя: тоатэ адунаря сэ-л учидэ ку петре. Фие стрэин, фие бэштинаш, сэ моарэ, пентру кэ а хулит Нумеле луй Думнезеу. ");
INSERT INTO ron1924_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Чине ва да унуй ом о ловитурэ де моарте сэ фие педепсит ку моартя. ");
INSERT INTO ron1924_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Чине ва да унуй добиток о ловитурэ де моарте сэ-л ынлокуяскэ: вяцэ пентру вяцэ. ");
INSERT INTO ron1924_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Дакэ чинева рэнеште пе апроапеле луй, сэ и се факэ аша кум а фэкут ши ел: ");
INSERT INTO ron1924_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","фрынтурэ пентру фрынтурэ, окь пентру окь, динте пентру динте; сэ и се факэ ачеяшь ранэ пе каре а фэкут-о ел апроапелуй сэу. ");
INSERT INTO ron1924_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Чине ва учиде ун добиток сэ-л ынлокуяскэ, дар чине ва учиде ун ом сэ фие педепсит ку моартя. ");
INSERT INTO ron1924_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Сэ авець ачеяшь леӂе пентру стрэин ка ши пентру бэштинаш; кэч Еу сунт Домнул Думнезеул востру.’” ");
INSERT INTO ron1924_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Мойсе а ворбит копиилор луй Исраел; ау скос афарэ дин табэрэ пе чел че хулисе ши л-ау учис ку петре. Копиий луй Исраел ау фэкут дупэ порунка пе каре о дэдусе луй Мойсе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Домнул а ворбит ку Мойсе пе мунтеле Синай ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","„Ворбеште копиилор луй Исраел ши спуне-ле: ‘Кынд вець интра ын цара пе каре в-о дау, пэмынтул сэ се одихняскэ, сэ цинэ ун Сабат ын чинстя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Шасе ань сэ-ць семень огорул, шасе ань сэ-ць тай вия ши сэ стрынӂь роаделе. ");
INSERT INTO ron1924_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Дар анул ал шаптеля сэ фие ун Сабат, о време де одихнэ пентру пэмынт, ун Сабат цинут ын чинстя Домнулуй: ын анул ачела сэ ну-ць семень огорул ши сэ ну-ць тай вия. ");
INSERT INTO ron1924_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Сэ ну сечерь че ва еши дин грэунцеле кэзуте де ла сечериш ши сэ ну кулеӂь стругурий дин вия та нетэятэ: ачеста сэ фие ун ан де одихнэ пентру пэмынт. ");
INSERT INTO ron1924_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Чея че ва еши де ла сине дин пэмынт ын тимпул Сабатулуй луй сэ вэ служяскэ де хранэ, цие, робулуй ши роабей тале, челуй токмит де тине ку зиуа ши стрэинулуй каре локуеште ку тине, ");
INSERT INTO ron1924_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","вителор тале ши фярелор дин цара та; тот венитул пэмынтулуй сэ служяскэ де хранэ. ");
INSERT INTO ron1924_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Сэ нумерь шапте сэптэмынь де ань, де шапте орь шапте ань, ши зилеле ачестор шапте сэптэмынь де ань вор фаче патрузечь ши ноуэ де ань. ");
INSERT INTO ron1924_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Ын а зечя зи а луний а шаптя, сэ пуй сэ суне ку трымбица рэсунэтоаре; ын Зиуа Испэширий, сэ сунаць ку трымбица ын тоатэ цара воастрэ ");
INSERT INTO ron1924_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","ши сэ сфинциць астфел анул ал чинчзечеля. Сэ вестиць слобозения ын царэ пентру тоць локуиторий ей: ачеста сэ фие пентру вой анул де веселие; фиекаре динтре вой сэ се ынтоаркэ ла мошия луй ши фиекаре динтре вой сэ се ынтоаркэ ын фамилия луй. ");
INSERT INTO ron1924_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Анул ал чинчзечеля сэ фие пентру вой анул де веселие; атунч сэ ну семэнаць, сэ ну сечераць че вор адуче огоареле де ла еле ши сэ ну кулеӂець вия нетэятэ. ");
INSERT INTO ron1924_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Кэч есте анул де веселие: сэ-л привиць ка чева сфынт. Сэ мынкаць че вэ вор да огоареле воастре. ");
INSERT INTO ron1924_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Ын анул ачеста де веселие, фиекаре динтре вой сэ се ынтоаркэ ла мошия луй. ");
INSERT INTO ron1924_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Дакэ виндець чева апроапелуй востру сау дакэ кумпэраць чева де ла апроапеле востру, ничунул динтре вой сэ ну ыншеле пе фрателе луй. ");
INSERT INTO ron1924_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Сэ кумперь де ла апроапеле тэу сокотинд аний де ла анул де веселие, ши ел сэ-ць вындэ сокотинд аний де род. ");
INSERT INTO ron1924_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Ку кыт вор фи май мулць ань, ку атыт сэ ридичь прецул ши ку кыт вор фи май пуцинь ань, ку атыт сэ-л сказь, кэч ел ыць винде нумай нумэрул сечеришурилор. ");
INSERT INTO ron1924_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Ничунул динтре вой сэ ну ыншеле деч пе апроапеле луй ши сэ те темь де Думнезеул тэу, кэч Еу сунт Домнул Думнезеул востру. ");
INSERT INTO ron1924_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Ымплиниць леӂиле Меле, пэзиць порунчиле Меле ши ымплиници-ле, ши вець локуи фэрэ фрикэ ын царэ. ");
INSERT INTO ron1924_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Цара ышь ва да роаделе, вець мынка дин еле ши вэ вець сэтура ши вець локуи фэрэ фрикэ ын еа. ");
INSERT INTO ron1924_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Дакэ вець зиче: «Че вом мынка ын анул ал шаптеля, фииндкэ ну вом семэна ши ну вом стрынӂе роаделе?» ");
INSERT INTO ron1924_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Еу вэ вой да бинекувынтаря Мя ын анул ал шаселя, ши пэмынтул ва да роаде пентру трей ань. ");
INSERT INTO ron1924_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Кынд вець семэна ын анул ал оптуля, вець мынка тот дин векиле роаде; пынэ ла ал ноуэля ан, пынэ ла ноиле роаде, вець мынка тот дин челе векь. ");
INSERT INTO ron1924_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Пэмынтуриле сэ ну се вындэ де вечь; кэч цара есте а Мя, яр вой сунтець ла Мине ка ниште стрэинь ши венетичь. ");
INSERT INTO ron1924_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Де ачея, ын тоатэ цара пе каре о вець стэпыни, сэ даць дрептул де рэскумпэраре пентру пэмынтурь. ");
INSERT INTO ron1924_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Дакэ фрателе тэу сэрэчеште ши винде о букатэ дин мошия луй, чел че аре дрептул де рэскумпэраре, руда луй чя май де апроапе, сэ винэ ши сэ рэскумпере че а вындут фрателе сэу. ");
INSERT INTO ron1924_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Дакэ ун ом н-аре пе нимень каре сэ айбэ дрептул де рэскумпэраре ши-й стэ ын путинцэ луй сингур сэ факэ рэскумпэраря, ");
INSERT INTO ron1924_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","сэ сокотяскэ аний де ла вынзаре, сэ дя ынапой кумпэрэторулуй че присосеште ши сэ се ынтоаркэ ла мошия луй. ");
INSERT INTO ron1924_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Дакэ н-аре ку че сэ-й дя ынапой, лукрул вындут сэ рэмынэ ын мыниле кумпэрэторулуй пынэ ла анул де веселие; ла анул де веселие, ел сэ се ынтоаркэ ла мошия луй ши кумпэрэторул сэ ясэ дин еа. ");
INSERT INTO ron1924_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Дакэ ун ом винде о касэ де локуит ынтр-о четате ынконжуратэ ку зидурь, сэ айбэ дрепт де рэскумпэраре пынэ ла ымплиниря унуй ан де ла вынзаре; дрептул луй де рэскумпэраре сэ цинэ ун ан. ");
INSERT INTO ron1924_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Дар, дакэ ачастэ касэ, ашезатэ ынтр-о четате ынконжуратэ ку зидурь, ну есте рэскумпэратэ ынаинте де ымплиниря унуй ан ынтрег, еа ва рэмыне пе вечь кумпэрэторулуй ши урмашилор луй; яр ын анул де веселие сэ ну ясэ дин еа. ");
INSERT INTO ron1924_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Каселе дин сате каре ну сунт ынконжурате ку зидурь сэ фие привите ка царинь де пэмынт: еле вор путя фи рэскумпэрате, ши кумпэрэторул ва еши дин еле ын анул де веселие. ");
INSERT INTO ron1924_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Кыт привеште четэциле левицилор ши каселе пе каре ле вор авя ей ын ачесте четэць, левиций сэ айбэ ун дрепт некурмат де рэскумпэраре. ");
INSERT INTO ron1924_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Чине ва кумпэра де ла левиць о касэ сэ ясэ ын анул де веселие дин каса вындутэ луй ши дин четатя ын каре о авя; кэч каселе дин четэциле левицилор сунт аверя лор ын мижлокул копиилор луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Огоареле ашезате ын журул четэцилор левицилор ну се вор путя винде; кэч ей ле вор стэпыни пе вечь. ");
INSERT INTO ron1924_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Дакэ фрателе тэу сэрэчеште ши ну май поате мунчи лынгэ тине, сэ-л сприжинь, фие ка стрэин, фие ка венетик, ка сэ трэяскэ ымпреунэ ку тине. ");
INSERT INTO ron1924_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Сэ ну ей де ла ел нич добындэ, нич камэтэ: сэ те темь де Думнезеул тэу, ши фрателе тэу сэ трэяскэ ымпреунэ ку тине. ");
INSERT INTO ron1924_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Сэ ну-й ымпрумуць баний тэй ку добындэ ши сэ ну-й ымпрумуць меринделе тале пе камэтэ. ");
INSERT INTO ron1924_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Еу сунт Домнул Думнезеул тэу, каре в-ам скос дин цара Еӂиптулуй, ка сэ вэ дау цара Канаанулуй, ка сэ фиу Думнезеул востру. ");
INSERT INTO ron1924_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Дакэ фрателе тэу сэрэчеште лынгэ тине ши се винде цие, сэ ну-л пуй сэ-ць факэ мункэ де роб. ");
INSERT INTO ron1924_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Чи сэ фие ла тине ка ун ом токмит ку зиуа, ка ун венетик; сэ стя ын служба та пынэ ла анул де веселие. ");
INSERT INTO ron1924_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Атунч, сэ ясэ де ла тине ел ши копиий луй каре вор фи ку ел ши сэ се ынтоаркэ ын фамилия луй, ла мошия пэринцилор луй. ");
INSERT INTO ron1924_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Кэч ей сунт служиторий Мей, пе каре й-ам скос дин цара Еӂиптулуй; сэ ну фие вындуць кум се вынд робий. ");
INSERT INTO ron1924_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Сэ ну-л стэпынешть ку асприме ши сэ те темь де Думнезеул тэу. ");
INSERT INTO ron1924_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Дакэ врець сэ авець робь ши роабе, сэ-й луаць де ла нямуриле каре вэ ынконжоарэ; де ла еле сэ кумпэраць робь ши роабе. ");
INSERT INTO ron1924_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Вець путя сэ-й кумпэраць ши динтре копиий стрэинилор каре вор локуи ла тине ши дин фамилииле лор пе каре ле вор наште ын цара воастрэ; ей вор фи аверя воастрэ. ");
INSERT INTO ron1924_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Ый путець лэса моштенире копиилор воштри дупэ вой, ка пе о мошие, ши путець сэ-й цинець астфел робь пе вечь. Дар кыт деспре фраций воштри, копиий луй Исраел, нич унул дин вой сэ ну стэпыняскэ пе фрателе сэу ку асприме. ");
INSERT INTO ron1924_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Дакэ ун стрэин сау ун венетик се ымбогэцеште, ши фрателе тэу сэрэчеште лынгэ ел ши се винде стрэинулуй каре локуеште ла тине сау вреунуя дин фамилия стрэинулуй, ");
INSERT INTO ron1924_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","ел сэ айбэ дрептул де рэскумпэраре, дупэ че се ва фи вындут: унул дин фраций луй сэ поатэ сэ-л рэскумпере. ");
INSERT INTO ron1924_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Ункюл луй сау фиул ункюлуй луй сау уна дин руделе луй де апроапе ва путя сэ-л рэскумпере сау, дакэ аре мижлоаче, сэ се рэскумпере сингур. ");
INSERT INTO ron1924_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Сэ факэ сокотяла ку чел че л-а кумпэрат, дин анул кынд с-а вындут пынэ ын анул де веселие, ши прецул де плэтит ва атырна де нумэрул анилор, каре вор фи прецуиць ка ай унуй ом токмит ку платэ. ");
INSERT INTO ron1924_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Дакэ май сунт ынкэ мулць ань пынэ ла анул де веселие, ышь ва плэти рэскумпэраря дупэ прецул анилор ачелора ши сэ-л скадэ дин прецул ку каре а фост кумпэрат; ");
INSERT INTO ron1924_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","дакэ май рэмын пуцинь ань пынэ ла анул де веселие, сэ ле факэ сокотяла ши сэ-шь плэтяскэ рэскумпэраря дупэ ачешть ань. ");
INSERT INTO ron1924_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Сэ фие ла ел ка унул токмит ку анул; ши ачела ла каре ва фи сэ ну се поарте ку асприме ку ел суб окий тэй. ");
INSERT INTO ron1924_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Яр дакэ ну есте рэскумпэрат ын ничунул дин ачесте фелурь, сэ ясэ де ла ел ын анул де веселие, ел ши копиий луй каре вор фи ымпреунэ ку ел. ");
INSERT INTO ron1924_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Кэч копиий луй Исраел сунт робий Мей; ей сунт робий Мей, пе каре й-ам скос дин цара Еӂиптулуй. Еу сунт Домнул Думнезеул востру. ");
INSERT INTO ron1924_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Сэ ну вэ фачець идоль, сэ ну вэ ридикаць нич кип чоплит, нич стылп де адучере аминте; сэ ну пунець ын цара воастрэ ничо пятрэ ымподобитэ ку кипурь, ка сэ вэ ынкинаць ынаинтя ей; кэч Еу сунт Домнул Думнезеул востру. ");
INSERT INTO ron1924_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Сэ пэзиць Сабателе Меле ши сэ чинстиць Локашул Меу чел Сфынт. Еу сунт Домнул. ");
INSERT INTO ron1924_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Дакэ вець урма леӂиле Меле, дакэ вець пэзи порунчиле Меле ши ле вець ымплини, ");
INSERT INTO ron1924_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","вэ вой тримите плой ла време, пэмынтул ышь ва да роаделе ши помий де пе кымп ышь вор да родул. ");
INSERT INTO ron1924_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Абия вець треера грыул, ши вець ынчепе кулесул вией, ши кулесул вией ва цине пынэ ла семэнэтурэ; вець авя пыне дин белшуг, вець мынка ши вэ вець сэтура ши вець локуи фэрэ фрикэ ын цара воастрэ. ");
INSERT INTO ron1924_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Вой да паче ын царэ ши нимень ну вэ ва тулбура сомнул; вой фаче сэ пярэ дин царэ фяреле сэлбатиче ши сабия ну ва трече прин цара воастрэ. ");
INSERT INTO ron1924_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Вець урмэри пе врэжмаший воштри, ши ей вор кэдя учишь де сабие ынаинтя воастрэ. ");
INSERT INTO ron1924_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Чинч динтре вой вор урмэри о сутэ ши о сутэ динтре вой вор урмэри зече мий, ши врэжмаший воштри вор кэдя учишь де сабие ынаинтя воастрэ. ");
INSERT INTO ron1924_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Еу Мэ вой ынтоарче спре вой, вэ вой фаче сэ крештець, вэ вой ынмулци ши Ымь вой цине легэмынтул Меу ку вой. ");
INSERT INTO ron1924_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Вець мынка дин роаделе челе векь ши вець скоате афарэ пе челе векь, ка сэ фачець лок челор ной. ");
INSERT INTO ron1924_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Вой ашеза Локашул Меу ын мижлокул востру ши суфлетул Меу ну вэ ва уры. ");
INSERT INTO ron1924_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Вой умбла ын мижлокул востру; Еу вой фи Думнезеул востру ши вой вець фи попорул Меу. ");
INSERT INTO ron1924_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Еу сунт Домнул Думнезеул востру, каре в-ам скос дин цара Еӂиптулуй, каре в-ам скос дин робие; Еу ам рупт легэтуриле жугулуй востру ши в-ам фэкут сэ мерӂець ку капул ридикат. ");
INSERT INTO ron1924_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Дар, дакэ ну Мэ аскултаць ши ну ымплиниць тоате ачесте порунчь, ");
INSERT INTO ron1924_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","дакэ несокотиць леӂиле Меле ши дакэ суфлетул востру урэште рындуелиле Меле, аша ынкыт сэ ну ымплиниць тоате порунчиле Меле ши сэ рупець легэмынтул Меу, ");
INSERT INTO ron1924_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","ятэ че вэ вой фаче атунч. Вой тримите песте вой гроаза, лингоаря ши фригуриле, каре вор фаче сэ ви се стингэ окий ши сэ пярэ вяца дин вой. Сэмынца о вець семэна ын задар, кэч о вор мынка врэжмаший воштри. ");
INSERT INTO ron1924_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Ымь вой ынтоарче Фаца ымпотрива воастрэ ши вець фи бэтуць ши вець фуӂи динаинтя врэжмашилор воштри; чей че вэ урэск вэ вор субжуга ши вець фуӂи фэрэ сэ фиць урмэриць кяр. ");
INSERT INTO ron1924_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Дакэ, ку тоате ачестя, ну Мэ вець аскулта, вэ вой педепси де шапте орь май мулт пентру пэкателе воастре. ");
INSERT INTO ron1924_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Вой фрынӂе мындрия путерий воастре, вой фаче ка дясупра воастрэ черул сэ фие де фер ши пэмынтул, де арамэ. ");
INSERT INTO ron1924_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Ви се ва истови путеря фэрэ фолос: пэмынтул востру ну-шь ва да роаделе ши помий де пе пэмынт ну-шь вор да родул. ");
INSERT INTO ron1924_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Дакэ ши дупэ ачаста вэ вець ымпотриви ши ну вець вои сэ Мэ аскултаць, вэ вой лови де шапте орь май мулт пентру пэкателе воастре. ");
INSERT INTO ron1924_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Вой тримите ымпотрива воастрэ фяреле де пе кымп, каре вэ вор лэса фэрэ копий, вэ вор нимичи вителе ши вэ вор ымпуцина; аша кэ вэ вор рэмыне друмуриле пустий. ");
INSERT INTO ron1924_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Дакэ педепселе ачестя ну вэ вор ындрепта ши дакэ вэ вець ымпотриви Мие, ");
INSERT INTO ron1924_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","Мэ вой ымпотриви ши Еу воуэ ши вэ вой лови де шапте орь май мулт пентру пэкателе воастре. ");
INSERT INTO ron1924_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Вой фаче сэ винэ ымпотрива воастрэ сабие, каре ва рэзбуна кэлкаря легэмынтулуй Меу, ши, кынд вэ вець стрынӂе ын четэциле воастре, вой тримите чума ын мижлокул востру ши вець фи даць ын мыниле врэжмашулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Кынд вэ вой тримите липсэ де пыне, зече фемей вэ вор коаче пыне ынтр-ун сингур куптор ши ви се ва да пыня ку кынтарул; вець мынка, дар ну вэ вець сэтура. ");
INSERT INTO ron1924_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Дакэ, ку тоате ачестя, ну Мэ вець аскулта ши дакэ вэ вець ымпотриви Мие, ");
INSERT INTO ron1924_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","Мэ вой ымпотриви ши Еу воуэ ку мыние ши вэ вой педепси де шапте орь май мулт пентру пэкателе воастре. ");
INSERT INTO ron1924_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Вець мынка пынэ ши карня фиилор воштри, вець мынка пынэ ши карня фийчелор воастре. ");
INSERT INTO ron1924_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Вэ вой нимичи ынэлцимиле пентру жертфэ, вэ вой дэрыма стылпий ынкинаць соарелуй, вой арунка трупуриле воастре моарте песте трупуриле моарте але идолилор воштри ши суфлетул Меу вэ ва уры. ");
INSERT INTO ron1924_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Вэ вой лэса четэциле пустий, вэ вой пустии локашуриле сфинте ши ну вой май мироси миросул плэкут ал тэмыий воастре. ");
INSERT INTO ron1924_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Вой пустии цара, аша кэ врэжмаший воштри каре о вор локуи вор рэмыне ынкремениць вэзынд-о. ");
INSERT INTO ron1924_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Вэ вой ымпрэштия принтре нямурь ши вой скоате сабия дупэ вой. Цара воастрэ ва фи пустиитэ ши четэциле воастре вор рэмыне пустий. ");
INSERT INTO ron1924_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Атунч, цара се ва букура де Сабателе ей тот тимпул кыт ва фи пустиитэ ши кыт вець фи ын цара врэжмашилор воштри; атунч, цара се ва одихни ши се ва букура де Сабателе ей. ");
INSERT INTO ron1924_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Тот тимпул кыт ва фи пустиитэ, ва авя одихна пе каре н-о авусесе ын аний воштри де Сабат, кынд о локуяць. ");
INSERT INTO ron1924_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Ын инима ачелора динтре вой каре вор май рэмыне ын вяцэ ын цара врэжмашилор лор, вой бэга фрика ши ый ва урмэри пынэ ши фошнетул уней фрунзе суфлате де вынт; вор фуӂи ка де сабие ши вор кэдя фэрэ сэ фие урмэриць. ");
INSERT INTO ron1924_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Се вор прэвэли уний песте алций ка ынаинтя сабией, фэрэ сэ фие урмэриць. Ну вець путя сэ стаць ын пичоаре ын фаца врэжмашилор воштри; ");
INSERT INTO ron1924_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","вець пери принтре нямурь ши вэ ва мынка цара врэжмашилор воштри. ");
INSERT INTO ron1924_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Яр пе ачея динтре вой каре вор май рэмыне ын вяцэ ый ва апука дуреря пентру фэрэделеӂиле лор, ын цара врэжмашилор лор; ый ва апука дуреря ши пентру фэрэделеӂиле пэринцилор лор. ");
INSERT INTO ron1924_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Ышь вор мэртуриси фэрэделеӂиле лор ши фэрэделеӂиле пэринцилор лор, кэлкэриле де леӂе пе каре ле-ау сэвыршит фацэ де Мине ши ымпотривиря ку каре Ми с-ау ымпотривит, пэкате дин причина кэрора ");
INSERT INTO ron1924_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","ши Еу М-ам ымпотривит лор ши й-ам дус ын цара врэжмашилор лор. Ши атунч, инима лор нетэятэ ымпрежур се ва смери ши вор плэти датория фэрэделеӂилор лор. ");
INSERT INTO ron1924_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Атунч Ымь вой адуче аминте де легэмынтул Меу ку Иаков, Ымь вой адуче аминте де легэмынтул Меу ку Исаак ши де легэмынтул Меу ку Авраам ши Ымь вой адуче аминте де царэ. ");
INSERT INTO ron1924_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Цара ынсэ ва требуи сэ фие пэрэситэ де ей ши се ва букура де Сабателе ей ын тимпул кынд ва рэмыне пустиитэ департе де ей; ши ей вор плэти датория фэрэделеӂилор лор пентру кэ ау несокотит порунчиле Меле ши пентру кэ суфлетул лор а урыт леӂиле Меле. ");
INSERT INTO ron1924_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Дар, ши кынд вор фи ын цара врэжмашилор лор, ну-й вой лепэда де тот ши ну-й вой уры пынэ аколо ынкыт сэ-й нимическ де тот ши сэ руп легэмынтул Меу ку ей, кэч Еу сунт Домнул Думнезеул лор. ");
INSERT INTO ron1924_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Чи Ымь вой адуче аминте, спре бинеле лор, де векюл легэмынт прин каре й-ам скос дин цара Еӂиптулуй ын фаца нямурилор, ка сэ фиу Думнезеул лор. Еу сунт Домнул.’” ");
INSERT INTO ron1924_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Ачестя сунт рындуелиле, порунчиле ши леӂиле пе каре ле-а статорничит Домнул ынтре Ел ши копиий луй Исраел, пе мунтеле Синай, прин Мойсе. ");
INSERT INTO ron1924_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Домнул а ворбит луй Мойсе ши а зис: „Ворбеште копиилор луй Исраел ши спуне-ле: ");
INSERT INTO ron1924_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","‘Кынд се вор фаче журуинце Домнулуй, дакэ е ворба де оамень, ей сэ фие ай Домнулуй, дупэ прецуиря та. ");
INSERT INTO ron1924_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Яр прецуиря пе каре о вей фаче унуй бэрбат, де ла доуэзечь пынэ ла шайзечь де ань, сэ фие де чинчзечь де сикли де арӂинт, дупэ сиклул Сфынтулуй Локаш: ");
INSERT INTO ron1924_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","дакэ есте фемее, прецуиря сэ фие де трейзечь де сикли. ");
INSERT INTO ron1924_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Де ла чинч пынэ ла доуэзечь де ань, прецуиря сэ фие де доуэзечь де сикли пентру ун бэят ши де зече сикли пентру о фатэ. ");
INSERT INTO ron1924_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Де ла о лунэ пынэ ла чинч ань, прецуиря сэ фие де чинч сикли де арӂинт пентру ун бэят ши де трей сикли де арӂинт пентру о фатэ. ");
INSERT INTO ron1924_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Де ла шайзечь де ань ын сус, прецуиря сэ фие де чинчспрезече сикли пентру ун бэрбат ши де зече сикли пентру о фемее. ");
INSERT INTO ron1924_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Дакэ чел че а фэкут журуинца есте пря сэрак ка сэ плэтяскэ прецуиря ачаста фэкутэ де тине, сэ-л адукэ ла преот, сэ-л прецуяскэ, ши преотул сэ факэ о прецуире потривит ку мижлоачеле омулуй ачелуя. ");
INSERT INTO ron1924_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Дакэ есте ворба де добитоачеле каре пот фи адусе ка жертфэ Домнулуй, орьче добиток каре се ва да Домнулуй ва фи чева сфынт. ");
INSERT INTO ron1924_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Сэ ну-л скимбе ши сэ ну пунэ унул рэу ын локул унуя бун, нич унул бун ын локул унуя рэу; дакэ с-ар ынтымпла сэ се ынлокуяскэ ун добиток ку алтул, ши унул, ши челэлалт ва фи сфынт. ");
INSERT INTO ron1924_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Дакэ есте ворба де добитоачеле некурате, каре ну пот фи адусе ка жертфэ Домнулуй, сэ адукэ добитокул ла преот, ");
INSERT INTO ron1924_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","каре-й ва фаче прецуиря дупэ кум ва фи бун сау рэу ши ва рэмыне ла прецуиря преотулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Дакэ вря сэ-л рэскумпере, сэ май адауӂе о чинчиме ла прецуиря луй. ");
INSERT INTO ron1924_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Дакэ чинева ышь ынкинэ Домнулуй каса, хэрэзинд-о Домнулуй ка ун дар сфынт, преотул сэ-й факэ прецуиря дупэ кум ва фи, бунэ сау ря, ши сэ рэмынэ ла прецуиря фэкутэ де преот. ");
INSERT INTO ron1924_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Дакэ чел че шь-а ынкинат Домнулуй каса вря с-о рэскумпере, сэ адауӂе о чинчиме ла прецул прецуирий ей, ши ва фи а луй. ");
INSERT INTO ron1924_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Дакэ чинева ынкинэ Домнулуй ун огор дин мошия луй, прецуиря та сэ фие дупэ кытимя де сэмынцэ пе каре о дэ, ши ануме чинчзечь де сикли де арӂинт пентру ун омер де сэмынцэ де орз. ");
INSERT INTO ron1924_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Дакэ ышь ынкинэ Домнулуй огорул, ку ынчепере кяр дин анул де веселие, сэ рэмынэ ла прецуиря та, ");
INSERT INTO ron1924_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","дар, дакэ ышь ынкинэ Домнулуй огорул дупэ анул де веселие, атунч преотул сэ-й сокотяскэ прецул дупэ нумэрул анилор каре май рэмын пынэ ла анул де веселие ши сэ-л скадэ дин прецуиря та. ");
INSERT INTO ron1924_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Дакэ чел че шь-а ынкинат Домнулуй огорул вря сэ-л рэскумпере, атунч сэ май адауӂе о чинчиме ла арӂинтул прецуит де тине, ши огорул сэ рэмынэ ал луй. ");
INSERT INTO ron1924_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Дакэ ну-шь рэскумпэрэ огорул, ши-л винде алтуй ом, ну ва май путя фи рэскумпэрат. ");
INSERT INTO ron1924_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Ши кынд ва еши кумпэрэторул дин ел ла анул де веселие, огорул ачела сэ фие ынкинат Домнулуй, ка огор хэрэзит Луй; сэ фие мошия преотулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Дакэ чинева ынкинэ Домнулуй ун огор кумпэрат де ел, каре ну фаче парте дин мошия луй, ");
INSERT INTO ron1924_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","преотул сэ-й сокотяскэ прецул дупэ кыт фаче прецуиря пынэ ла анул де веселие, ши омул ачела сэ плэтяскэ ын ачеяшь зи прецул хотэрыт де тине, ка лукру ынкинат Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Ын анул де веселие, огорул сэ се ынтоаркэ ла ачела де ла каре фусесе кумпэрат ши дин мошия кэруя фэчя парте. ");
INSERT INTO ron1924_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Тоате прецуириле сэ се факэ ын сиклий Сфынтулуй Локаш: сиклул аре доуэзечь де гере. ");
INSERT INTO ron1924_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Нимень ну ва путя сэ ынкине Домнулуй пе ынтыюл нэскут дин вита луй, каре кяр есте ал Домнулуй ка ынтый нэскут; фие боу, фие мел, есте ал Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Дакэ есте ворба ынсэ де ун добиток некурат, сэ-л рэскумпере ку прецул прецуит де тине, май адэугынд ынкэ о чинчиме; дакэ ну есте рэскумпэрат, сэ фие вындут дупэ прецуиря та. ");
INSERT INTO ron1924_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Тот че ва дэруи ун ом Домнулуй прин фэгэдуинцэ, дин че аре, ну ва путя нич сэ се вындэ, нич сэ се рэскумпере: фие ом, фие добиток, фие ун огор дин мошия луй; тот че ва фи дэруит Домнулуй прин фэгэдуинцэ ва фи ун лукру прясфынт, пентру Домнул. ");
INSERT INTO ron1924_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Ничун ом ынкинат Домнулуй прин фэгэдуинцэ ну ва путя фи рэскумпэрат, чи ва фи оморыт. ");
INSERT INTO ron1924_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Орьче зечуялэ дин пэмынт, фие дин роаделе пэмынтулуй, фие дин родул помилор, есте а Домнулуй; есте ун лукру ынкинат Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Дакэ вря чинева сэ рэскумпере чева дин зечуяла луй, сэ май адауӂе о чинчиме. ");
INSERT INTO ron1924_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Орьче зечуялэ дин чирезь ши дин турме, дин тот че трече суб тояг, сэ фие о зечуялэ ынкинатэ Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Сэ ну се черчетезе дакэ добитокул есте бун сау рэу ши сэ ну се скимбе; дакэ се ынлокуеште ун добиток ку ун алтул, ши унул, ши челэлалт вор фи сфинте ши ну вор путя фи рэскумпэрате.’” ");
INSERT INTO ron1924_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Ачестя сунт порунчиле пе каре ле-а дат луй Мойсе Домнул пентру копиий луй Исраел, пе мунтеле Синай. ");
INSERT INTO ron1924_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Домнул а ворбит луй Мойсе ын пустиул Синай, ын кортул ынтылнирий, ын чя динтый зи а луний а доуа, ын ал дойля ан дупэ еширя лор дин цара Еӂиптулуй. Ел а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","„Фачець нумэрэтоаря ынтреӂий адунэрь а копиилор луй Исраел, дупэ фамилииле лор, дупэ каселе пэринцилор лор, нумэрынд пе кап нумеле тутурор бэрбацилор ");
INSERT INTO ron1924_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","де ла вырста де доуэзечь де ань ын сус, пе тоць чей дин Исраел каре сунт ын старе сэ поарте армеле; сэ ле фачець нумэрэтоаря дупэ четеле лор, ту ши Аарон. ");
INSERT INTO ron1924_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Сэ фие ку вой кыте ун бэрбат де фиекаре семинцие, кэпетение а касей пэринцилор сэй. ");
INSERT INTO ron1924_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Ятэ нумеле бэрбацилор каре вор фи ымпреунэ ку вой. Пентру Рубен: Елицур, фиул луй Шедеур; ");
INSERT INTO ron1924_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","пентру Симеон: Шелумиел, фиул луй Цуришадай; ");
INSERT INTO ron1924_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","пентру Иуда: Нахшон, фиул луй Аминадаб; ");
INSERT INTO ron1924_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","пентру Исахар: Нетанеел, фиул луй Цуар; ");
INSERT INTO ron1924_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","пентру Забулон: Елиаб, фиул луй Хелон; ");
INSERT INTO ron1924_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","пентру фиий луй Иосиф – пентру Ефраим: Елишама, фиул луй Амихуд; пентру Манасе: Гамлиел, фиул луй Педахцур; ");
INSERT INTO ron1924_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","пентру Бениамин: Абидан, фиул луй Гидеони; ");
INSERT INTO ron1924_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","пентру Дан: Ахиезер, фиул луй Амишадай; ");
INSERT INTO ron1924_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","пентру Ашер: Пагуиел, фиул луй Окран; ");
INSERT INTO ron1924_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","пентру Гад: Елиасаф, фиул луй Деуел; ");
INSERT INTO ron1924_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","пентру Нефтали: Ахира, фиул луй Енан.” ");
INSERT INTO ron1924_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Ачештя сунт чей че ау фост алешь де адунаре, май-марий семинциилор пэринцилор лор, кэпетенииле миилор луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Мойсе ши Аарон ау луат пе бэрбаций ачештя каре фусесерэ кемаць пе нуме ");
INSERT INTO ron1924_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","ши ау стрынс тоатэ адунаря ын чя динтый зи а луний а доуа. Й-ау трекут ын кэрциле каре куприндяу спица нямулуй, дупэ фамилииле лор, дупэ каселе пэринцилор лор, нумэрынд пе кап нумеле бэрбацилор де ла вырста де доуэзечь де ань ын сус. ");
INSERT INTO ron1924_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Мойсе а фэкут нумэрэтоаря ын пустиул Синай, кум ый порунчисе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Ау трекут ын кэрциле нямулуй пе фиий луй Рубен, ынтыюл нэскут ал луй Исраел, дупэ фамилииле лор, дупэ каселе пэринцилор лор, нумэрынд пе кап нумеле тутурор бэрбацилор де ла вырста де доуэзечь де ань ын сус, пе тоць чей ын старе сэ поарте армеле: ");
INSERT INTO ron1924_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","бэрбаций дин семинция луй Рубен ешиць ла нумэрэтоаре ау фост патрузечь ши шасе де мий чинч суте. ");
INSERT INTO ron1924_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Ау трекут ын кэрциле нямулуй пе фиий луй Симеон, дупэ фамилииле лор, дупэ каселе пэринцилор лор; ле-ау фэкут нумэрэтоаря, нумэрынд пе кап нумеле тутурор бэрбацилор де ла вырста де доуэзечь де ань ын сус, тоць чей ын старе сэ поарте армеле: ");
INSERT INTO ron1924_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","бэрбаций дин семинция луй Симеон ешиць ла нумэрэтоаре ау фост чинчзечь ши ноуэ де мий трей суте. ");
INSERT INTO ron1924_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Ау трекут ын кэрциле нямулуй пе фиий луй Гад, дупэ фамилииле лор, дупэ каселе пэринцилор лор, нумэрынд нумеле бэрбацилор де ла вырста де доуэзечь де ань ын сус, пе тоць чей ын старе сэ поарте армеле: ");
INSERT INTO ron1924_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","бэрбаций дин семинция луй Гад ешиць ла нумэрэтоаре ау фост патрузечь ши чинч де мий шасе суте чинчзечь. ");
INSERT INTO ron1924_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Ау трекут ын кэрциле нямулуй пе фиий луй Иуда, дупэ фамилииле лор, дупэ каселе пэринцилор лор, нумэрынд нумеле бэрбацилор де ла вырста де доуэзечь де ань ын сус, пе тоць чей ын старе сэ поарте армеле: ");
INSERT INTO ron1924_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","бэрбаций дин семинция луй Иуда ешиць ла нумэрэтоаре ау фост шаптезечь ши патру де мий шасе суте. ");
INSERT INTO ron1924_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Ау трекут ын кэрциле нямулуй пе фиий луй Исахар, дупэ фамилииле лор, дупэ каселе пэринцилор лор, нумэрынд нумеле бэрбацилор де ла вырста де доуэзечь де ань ын сус, пе тоць чей ын старе сэ поарте армеле: ");
INSERT INTO ron1924_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","бэрбаций дин семинция луй Исахар ешиць ла нумэрэтоаре ау фост чинчзечь ши патру де мий патру суте. ");
INSERT INTO ron1924_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Ау трекут ын кэрциле нямулуй пе фиий луй Забулон, дупэ фамилииле лор, дупэ каселе пэринцилор лор, нумэрынд нумеле бэрбацилор де ла вырста де доуэзечь де ань ын сус, пе тоць чей ын старе сэ поарте армеле: ");
INSERT INTO ron1924_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","бэрбаций дин семинция луй Забулон ешиць ла нумэрэтоаре ау фост чинчзечь ши шапте де мий патру суте. ");
INSERT INTO ron1924_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Ау трекут ын кэрциле нямулуй, динтре фиий луй Иосиф, пе фиий луй Ефраим, дупэ фамилииле лор, дупэ каселе пэринцилор лор, нумэрынд нумеле бэрбацилор де ла вырста де доуэзечь де ань ын сус, пе тоць чей ын старе сэ поарте армеле: ");
INSERT INTO ron1924_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","бэрбаций дин семинция луй Ефраим ешиць ла нумэрэтоаре ау фост патрузечь де мий чинч суте. ");
INSERT INTO ron1924_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Ау трекут ын кэрциле нямулуй пе фиий луй Манасе, дупэ фамилииле лор, дупэ каселе пэринцилор лор, нумэрынд нумеле бэрбацилор де ла вырста де доуэзечь де ань ын сус, пе тоць чей ын старе сэ поарте армеле: ");
INSERT INTO ron1924_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","бэрбаций дин семинция луй Манасе ешиць ла нумэрэтоаре ау фост трейзечь ши доуэ де мий доуэ суте. ");
INSERT INTO ron1924_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Ау трекут ын кэрциле нямулуй пе фиий луй Бениамин, дупэ фамилииле лор, дупэ каселе пэринцилор лор, нумэрынд нумеле бэрбацилор де ла вырста де доуэзечь де ань ын сус, пе тоць чей ын старе сэ поарте армеле: ");
INSERT INTO ron1924_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","бэрбаций дин семинция луй Бениамин ешиць ла нумэрэтоаре ау фост трейзечь ши чинч де мий патру суте. ");
INSERT INTO ron1924_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Ау трекут ын кэрциле нямулуй пе фиий луй Дан, дупэ фамилииле лор, дупэ каселе пэринцилор лор, нумэрынд нумеле бэрбацилор де ла вырста де доуэзечь де ань ын сус, пе тоць чей ын старе сэ поарте армеле: ");
INSERT INTO ron1924_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","бэрбаций дин семинция луй Дан ешиць ла нумэрэтоаре ау фост шайзечь ши доуэ де мий шапте суте. ");
INSERT INTO ron1924_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Ау трекут ын кэрциле нямулуй пе фиий луй Ашер, дупэ фамилииле лор, дупэ каселе пэринцилор лор, нумэрынд нумеле бэрбацилор де ла вырста де доуэзечь де ань ын сус, пе тоць чей ын старе сэ поарте армеле: ");
INSERT INTO ron1924_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","бэрбаций дин семинция луй Ашер ешиць ла нумэрэтоаре ау фост патрузечь ши уну де мий чинч суте. ");
INSERT INTO ron1924_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Ау трекут ын кэрциле нямулуй пе фиий луй Нефтали, дупэ фамилииле лор, дупэ каселе пэринцилор лор, нумэрынд нумеле бэрбацилор де ла вырста де доуэзечь де ань ын сус, пе тоць чей ын старе сэ поарте армеле: ");
INSERT INTO ron1924_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","бэрбаций дин семинция луй Нефтали ешиць ла нумэрэтоаре ау фост чинчзечь ши трей де мий патру суте. ");
INSERT INTO ron1924_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Ачештя сунт ачея а кэрор нумэрэтоаре а фост фэкутэ де Мойсе ши Аарон ши де чей дойспрезече бэрбаць, май-марь ай луй Исраел; ера кыте ун бэрбат пентру фиекаре дин каселе пэринцилор лор. ");
INSERT INTO ron1924_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Тоць ачея динтре копиий луй Исраел ешиць ла нумэрэтоаре, дупэ каселе пэринцилор лор, де ла вырста де доуэзечь де ань ын сус, тоць ачея дин Исраел каре ерау ын старе сэ поарте армеле, ");
INSERT INTO ron1924_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","тоць чей ешиць ла нумэрэтоаре, ау фост шасе суте трей мий чинч суте чинчзечь. ");
INSERT INTO ron1924_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Левиций, дупэ семинция пэринцилор лор, н-ау интрат ын нумэрэтоаря ачаста. ");
INSERT INTO ron1924_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","„Сэ ну фачь нумэрэтоаря семинцией луй Леви ши сэ ну-й нумерь капетеле ын мижлокул челорлалць копий ай луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Дэ ын грижа левицилор кортул ынтылнирий, тоате унелтеле луй ши тот че цине де ел. Ей вор дуче кортул ши тоате унелтеле луй, вор фаче служба ын ел ши вор тэбэры ын журул кортулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Кынд ва порни кортул, левиций сэ-л десфакэ; ши кынд се ва опри кортул, левиций сэ-л ынтиндэ, яр стрэинул каре се ва апропия де ел сэ фие педепсит ку моартя. ");
INSERT INTO ron1924_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Копиий луй Исраел сэ тэбэраскэ фиекаре ын табэра луй, фиекаре лынгэ стягул луй, дупэ четеле лор. ");
INSERT INTO ron1924_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Дар левиций сэ тэбэраскэ ын журул кортулуй ынтылнирий, пентру ка сэ ну избукняскэ мыния Мя ымпотрива адунэрий копиилор луй Исраел, ши левиций сэ айбэ паза кортулуй ынтылнирий.” ");
INSERT INTO ron1924_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Копиий луй Исраел ау фэкут ынтокмай дупэ тоате порунчиле пе каре ле дэдусе луй Мойсе Домнул; аша ау фэкут. ");
INSERT INTO ron1924_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Домнул а ворбит луй Мойсе ши луй Аарон ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","„Копиий луй Исраел ау сэ тэбэраскэ фиекаре лынгэ стягул луй, суб семнеле касей пэринцилор луй; сэ тэбэраскэ ын фаца ши ымпрежурул кортулуй ынтылнирий. ");
INSERT INTO ron1924_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Ла рэсэрит, табэра луй Иуда, ку стягул ей ши ку оштириле сале. Аколо сэ тэбэраскэ май-мареле фиилор луй Иуда, Нахшон, фиул луй Аминадаб, ");
INSERT INTO ron1924_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","ку оштиря луй, алкэтуитэ дин шаптезечь ши патру де мий шасе суте де оамень ешиць ла нумэрэтоаре. ");
INSERT INTO ron1924_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Лынгэ ел сэ тэбэраскэ семинция луй Исахар ши май-мареле фиилор луй Исахар, Нетанеел, фиул луй Цуар, ");
INSERT INTO ron1924_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","ку оштиря луй, алкэтуитэ дин чинчзечь ши патру де мий патру суте де оамень, ешиць ла нумэрэтоаре; ");
INSERT INTO ron1924_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","апой семинция луй Забулон ши май-мареле фиилор луй Забулон, Елиаб, фиул луй Хелон, ");
INSERT INTO ron1924_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","ку оштиря луй, алкэтуитэ дин чинчзечь ши шапте де мий патру суте де оамень ешиць ла нумэрэтоаре. ");
INSERT INTO ron1924_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Тоць чей дин табэра луй Иуда ешиць ла нумэрэтоаре сунт о сутэ оптзечь ши шасе де мий патру суте де бэрбаць, дупэ оштиря лор. Ей сэ порняскэ чей динтый. ");
INSERT INTO ron1924_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Ла мязэзи, табэра луй Рубен, ку стягул ей ши ку оштириле ей. Аколо сэ тэбэраскэ май-мареле фиилор луй Рубен, Елицур, фиул луй Шедеур, ");
INSERT INTO ron1924_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","ку оштиря луй, алкэтуитэ дин патрузечь ши шасе де мий чинч суте де бэрбаць ешиць ла нумэрэтоаре. ");
INSERT INTO ron1924_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Лынгэ ел сэ тэбэраскэ семинция луй Симеон ши май-мареле фиилор луй Симеон, Шелумиел, фиул луй Цуришадай, ");
INSERT INTO ron1924_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","ку оштиря луй, алкэтуитэ дин чинчзечь ши ноуэ де мий трей суте де оамень ешиць ла нумэрэтоаре; ");
INSERT INTO ron1924_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","апой семинция луй Гад ши май-мареле фиилор луй Гад, Елиса, фиул луй Деуел, ");
INSERT INTO ron1924_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","ку оштиря луй, алкэтуитэ дин патрузечь ши чинч де мий шасе суте чинчзечь де оамень ешиць ла нумэрэтоаре. ");
INSERT INTO ron1924_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Тоць чей дин табэра луй Рубен ешиць ла нумэрэтоаре сунт о сутэ чинчзечь ши уну де мий патру суте чинчзечь де оамень, дупэ оштириле лор. Ей сэ порняскэ ын ал дойля рынд. ");
INSERT INTO ron1924_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Апой ва порни кортул ынтылнирий, ымпреунэ ку табэра левицилор, ашезатэ ын мижлокул челорлалте табере. Пе друм, вор цине ширул ын каре а тэбэрыт фиекаре, ла рындул луй, дупэ стягул луй. ");
INSERT INTO ron1924_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Ла апус, табэра луй Ефраим, ку стягул сэу ши ку оштириле сале. Аколо сэ тэбэраскэ май-мареле фиилор луй Ефраим, Елишама, фиул луй Амихуд, ");
INSERT INTO ron1924_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","ку оштиря луй, алкэтуитэ дин патрузечь де мий чинч суте де оамень ешиць ла нумэрэтоаре. ");
INSERT INTO ron1924_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Лынгэ ел сэ тэбэраскэ семинция луй Манасе ши май-мареле фиилор луй Манасе, Гамлиел, фиул луй Педахцур, ");
INSERT INTO ron1924_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","ку оштиря луй, алкэтуитэ дин трейзечь ши доуэ де мий доуэ суте де оамень ешиць ла нумэрэтоаре; ");
INSERT INTO ron1924_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","апой семинция луй Бениамин ши май-мареле фиилор луй Бениамин, Абидан, фиул луй Гидеони, ");
INSERT INTO ron1924_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","ку оштиря луй, алкэтуитэ дин трейзечь ши чинч де мий патру суте де оамень ешиць ла нумэрэтоаре. ");
INSERT INTO ron1924_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Тоць чей дин табэра луй Ефраим ешиць ла нумэрэтоаре сунт о сутэ опт мий о сутэ де оамень, дупэ оштириле лор. Ей сэ порняскэ ын ал трейля рынд. ");
INSERT INTO ron1924_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Ла мязэноапте, табэра луй Дан, ку стягул ей ши ку оштириле ей. Аколо сэ тэбэраскэ май-мареле фиилор луй Дан, Ахиезер, фиул луй Амишадай, ");
INSERT INTO ron1924_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","ку оштиря луй, алкэтуитэ дин шайзечь ши доуэ де мий шапте суте де оамень ешиць ла нумэрэтоаре. ");
INSERT INTO ron1924_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Лынгэ ел сэ тэбэраскэ семинция луй Ашер ши май-мареле фиилор луй Ашер, Пагуиел, фиул луй Окран, ");
INSERT INTO ron1924_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","ку оштиря луй, алкэтуитэ дин патрузечь ши уну де мий чинч суте де оамень ешиць ла нумэрэтоаре; ");
INSERT INTO ron1924_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","апой семинция луй Нефтали ши май-мареле фиилор луй Нефтали, Ахира, фиул луй Енан, ");
INSERT INTO ron1924_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","ку оштиря луй, алкэтуитэ дин чинчзечь ши трей де мий патру суте де оамень ешиць ла нумэрэтоаре. ");
INSERT INTO ron1924_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Тоць чей дин табэра луй Дан ешиць ла нумэрэтоаре сунт о сутэ чинчзечь ши шапте де мий шасе суте де оамень. Ей сэ порняскэ чей дин урмэ, дупэ стягул лор.” ");
INSERT INTO ron1924_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Ачештя сунт копиий луй Исраел ешиць ла нумэрэтоаре, дупэ каселе пэринцилор лор. Тоць чей ешиць ла нумэрэтоаре ши каре ау алкэтуит табереле дупэ оштириле лор ау фост шасе суте трей мий чинч суте чинчзечь. ");
INSERT INTO ron1924_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Левиций, дупэ порунка пе каре о дэдусе луй Мойсе Домнул, н-ау интрат ла нумэрэтоаре ын мижлокул копиилор луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Ши копиий луй Исраел ау фэкут ынтокмай дупэ тоате порунчиле пе каре ле дэдусе луй Мойсе Домнул. Аша тэбэрау ей, дупэ стягуриле лор, ши астфел порняу ла друм, фиекаре дупэ фамилия луй, дупэ каса пэринцилор луй. ");
INSERT INTO ron1924_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Ятэ сэмынца луй Аарон ши а луй Мойсе пе время кынд а ворбит Домнул ку Мойсе, пе мунтеле Синай. ");
INSERT INTO ron1924_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Ятэ нумеле фиилор луй Аарон: Надаб, ынтыюл нэскут, Абиху, Елеазар ши Итамар. ");
INSERT INTO ron1924_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Ачестя сунт нумеле фиилор луй Аарон каре ау примит унӂеря преоцяскэ ши каре ау фост ынкинаць ын служба преоцией. ");
INSERT INTO ron1924_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Надаб ши Абиху ау мурит ынаинтя Домнулуй, кынд ау адус ынаинтя Домнулуй фок стрэин, ын пустиул Синай; ей н-авяу фий. Елеазар ши Итамар ау ымплинит служба преоцией ын фаца татэлуй лор Аарон. ");
INSERT INTO ron1924_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","„Апропие семинция луй Леви ши пуне-о ынаинтя преотулуй Аарон, ка сэ фие ын служба луй. ");
INSERT INTO ron1924_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Ей сэ айбэ грижэ де тот че есте дат ын паза луй ши де тот че есте порунчит ынтреӂий адунэрь, ынаинтя кортулуй ынтылнирий: сэ факэ служба кортулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Сэ айбэ грижэ де тоате унелтеле кортулуй ынтылнирий ши де тот че есте порунчит копиилор луй Исраел: ей сэ факэ служба кортулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Сэ дай пе левиць луй Аарон ши фиилор луй; ей сэ-й фие даць луй ын тотул, дин партя копиилор луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Пе Аарон ши пе фиий луй сэ-й пуй сэ пэзяскэ служба преоцией лор, яр стрэинул каре се ва апропия сэ фие педепсит ку моартя.” ");
INSERT INTO ron1924_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","„Ятэ кэ ам луат пе левиць дин мижлокул копиилор луй Исраел, ын локул тутурор ынтыилор нэскуць каре се наск ынтый динтре копиий луй Исраел, ши левиций вор фи ай Мей. ");
INSERT INTO ron1924_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Кэч орьче ынтый нэскут есте ал Меу. Ын зиуа кынд ам ловит пе тоць ынтыий нэскуць дин цара Еӂиптулуй, Мь-ам ынкинат Мие пе тоць ынтыий нэскуць дин Исраел, атыт дин оамень, кыт ши дин добитоаче: ей вор фи ай Мей. Еу сунт Домнул.” ");
INSERT INTO ron1924_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Домнул а ворбит луй Мойсе ын пустиул Синай ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","„Фэ нумэрэтоаря копиилор луй Леви дупэ каселе пэринцилор лор, дупэ фамилииле лор, ши ануме фэ нумэрэтоаря тутурор челор де парте бэрбэтяскэ де ла вырста де о лунэ ын сус.” ");
INSERT INTO ron1924_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Мойсе ле-а фэкут нумэрэтоаря дупэ порунка Домнулуй, ынтокмай кум порунчисе. ");
INSERT INTO ron1924_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Ятэ каре сунт фиий луй Леви, дупэ нумеле лор: Гершон, Кехат ши Мерари. ");
INSERT INTO ron1924_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Ятэ нумеле фиилор луй Гершон, дупэ фамилииле лор: Либни ши Шимей. ");
INSERT INTO ron1924_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Ятэ фиий луй Кехат, дупэ фамилииле лор: Амрам, Ицехар, Хеброн ши Узиел; ");
INSERT INTO ron1924_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","ши фиий луй Мерари, дупэ фамилииле лор: Махли ши Муши. Ачестя сунт фамилииле луй Леви, дупэ каселе пэринцилор лор. ");
INSERT INTO ron1924_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Дин Гершон се кобоарэ фамилия луй Либни ши фамилия луй Шимей, алкэтуинд фамилииле гершоницилор. ");
INSERT INTO ron1924_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Чей ешиць ла нумэрэтоаре, кынд ау нумэрат пе тоць бэрбаций де ла вырста де о лунэ ын сус, ау фост шапте мий чинч суте. ");
INSERT INTO ron1924_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Фамилииле гершоницилор тэбэрау ынапоя кортулуй, ла апус. ");
INSERT INTO ron1924_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Кэпетения касей пэринтешть а гершоницилор ера Елисаф, фиул луй Лаел. ");
INSERT INTO ron1924_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Ын че привеште кортул ынтылнирий, ын грижа фиилор луй Гершон ерау дате: кортул ши акоперишул кортулуй, ынвелитоаря акоперишулуй кортулуй ши пердяуа де ла уша кортулуй ынтылнирий; ");
INSERT INTO ron1924_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","апой пынзеле курций ши пердяуа де ла поарта курций кортулуй де жур ымпрежурул кортулуй ши алтарулуй ши тоате фунииле пентру служба кортулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Дин Кехат се кобоарэ фамилия амрамицилор, фамилия ицехарицилор, фамилия хеброницилор ши фамилия узиелицилор, алкэтуинд фамилииле кехатицилор. ");
INSERT INTO ron1924_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Нумэрынд пе тоць бэрбаций де ла вырста де о лунэ ын сус, с-ау гэсит опт мий шасе суте де бэрбаць ынсэрчинаць ку ынгрижиря Сфынтулуй Локаш. ");
INSERT INTO ron1924_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Фамилииле фиилор луй Кехат тэбэрау ын партя де мязэзи а кортулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Кэпетения касей пэринтешть а фамилиилор кехатицилор ера Елицафан, фиул луй Узиел. ");
INSERT INTO ron1924_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Ын грижа лор ау дат кивотул, маса, сфешникул, алтареле, унелтеле Сфынтулуй Локаш, ку каре ышь фэчяу служба, пердяуа динэунтру ши тот че цине де еа. ");
INSERT INTO ron1924_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Кэпетения кэпетениилор левицилор ера Елеазар, фиул преотулуй Аарон; ел авя привегеря асупра челор ынсэрчинаць сэ ынгрижяскэ де Сфынтул Локаш. ");
INSERT INTO ron1924_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Дин Мерари се кобоарэ фамилия луй Махли ши фамилия луй Муши, алкэтуинд фамилииле мерарицилор. ");
INSERT INTO ron1924_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Чей ешиць ла нумэрэтоаре, кынд ау нумэрат пе тоць бэрбаций де ла вырста де о лунэ ын сус, ау фост шасе мий доуэ суте. ");
INSERT INTO ron1924_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Кэпетения касей пэринтешть а фамилиилор луй Мерари ера Цуриел, фиул луй Абихаил. Ей тэбэрау ын партя де мязэноапте а кортулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Ын паза ши грижа фиилор луй Мерари ау дат: скындуриле кортулуй, друӂий, стылпий ши пичоареле лор, тоате унелтеле ши тот че цине де еле; ");
INSERT INTO ron1924_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","апой стылпий курций де жур ымпрежур, пичоареле лор, цэруший лор ши фунииле лор. ");
INSERT INTO ron1924_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Мойсе, Аарон ши фиий луй тэбэрау ынаинтя кортулуй, ла рэсэрит, ынаинтя кортулуй ынтылнирий, спре рэсэритул соарелуй; ей авяу сэ ындеплиняскэ ла Сфынтул Локаш тот че фусесе порунчит копиилор луй Исраел; яр стрэинул каре се ва апропия сэ фие педепсит ку моартя. ");
INSERT INTO ron1924_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Тоць левиций а кэрор нумэрэтоаре ау фэкут-о Мойсе ши Аарон дупэ порунка Домнулуй, дупэ фамилииле лор, тоць бэрбаций, де ла вырста де о лунэ ын сус, ау фост доуэзечь ши доуэ де мий. ");
INSERT INTO ron1924_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Домнул а зис луй Мойсе: „Фэ нумэрэтоаря тутурор ынтыилор нэскуць де парте бэрбэтяскэ динтре копиий луй Исраел, де ла вырста де о лунэ ын сус, ши нумэрэ-й дупэ нумеле лор. ");
INSERT INTO ron1924_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Сэ ей пе левиць пентру Мине, Домнул, ын локул тутурор ынтыилор нэскуць дин копиий луй Исраел ши вителе левицилор ын локул тутурор ынтыилор нэскуць дин вителе копиилор луй Исраел!” ");
INSERT INTO ron1924_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Мойсе а фэкут нумэрэтоаря тутурор ынтыилор нэскуць динтре копиий луй Исраел, дупэ порунка пе каре й-о дэдусе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Тоць ынтыий нэскуць де парте бэрбэтяскэ, а кэрор нумэрэтоаре ау фэкут-о, нумэрынду-ле нумеле, де ла вырста де о лунэ ын сус, ау фост доуэзечь ши доуэ де мий доуэ суте шаптезечь ши трей. ");
INSERT INTO ron1924_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","„Я пе левиць ын локул тутурор ынтыилор нэскуць дин копиий луй Исраел ши вителе левицилор ын локул вителор лор; ши левиций вор фи ай Мей. Еу сунт Домнул. ");
INSERT INTO ron1924_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Пентру рэскумпэраря челор доуэ суте шаптезечь ши трей каре трек песте нумэрул левицилор, динтре ынтыий нэскуць ай копиилор луй Исраел, ");
INSERT INTO ron1924_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","сэ ей кыте чинч сикли де кап, дупэ сиклул Сфынтулуй Локаш, каре есте де доуэзечь де гере. ");
INSERT INTO ron1924_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Сэ дай арӂинтул ачеста луй Аарон ши фиилор луй пентру рэскумпэраря челор че трек песте нумэрул левицилор.” ");
INSERT INTO ron1924_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Мойсе а луат арӂинтул пентру рэскумпэраря челор че тречяу песте нумэрул челор рэскумпэраць де левиць; ");
INSERT INTO ron1924_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","а луат арӂинтул ынтыилор нэскуць дин копиий луй Исраел: о мие трей суте шайзечь ши чинч де сикли, дупэ сиклул Сфынтулуй Локаш. ");
INSERT INTO ron1924_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Ши Мойсе а дат арӂинтул де рэскумпэраре луй Аарон ши фиилор луй, дупэ порунка Домнулуй, кум порунчисе луй Мойсе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Домнул а ворбит луй Мойсе ши луй Аарон ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","„Нумэрэ пе фиий луй Кехат динтре копиий луй Леви, дупэ фамилииле лор, дупэ каселе пэринцилор лор, ");
INSERT INTO ron1924_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","де ла вырста де трейзечь де ань ын сус пынэ ла вырста де чинчзечь де ань, пе тоць чей дестойничь сэ факэ врео службэ ла кортул ынтылнирий. ");
INSERT INTO ron1924_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Ятэ службеле фиилор луй Кехат ын кортул ынтылнирий: еле привеск Локул Прясфынт. ");
INSERT INTO ron1924_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Ла порниря таберей, Аарон ши фиий луй сэ винэ сэ дя жос пердяуа динэунтру ши сэ акопере ку еа кивотул мэртурией; ");
INSERT INTO ron1924_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","сэ пунэ дясупра ей о ынвелитоаре де пеле де вицел де маре ши сэ ынтиндэ пе дясупра ун ковор фэкут ын ынтреӂиме дин материе албастрэ; апой сэ пунэ друӂий кивотулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Сэ ынтиндэ ун ковор албастру песте маса пынилор пентру пунеря ынаинте ши дясупра сэ пунэ стрэкиниле, кэцуиле, чештиле ши потиреле пентру жертфеле де бэутурэ; дясупра сэ фие ши пыня каре се пуне некурмат ынаинтя Домнулуй; ");
INSERT INTO ron1924_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","песте тоате ачесте лукрурь, сэ ынтиндэ ун ковор кэрэмизиу ши сэ-л акопере ку о ынвелитоаре де пеле де вицел де маре; апой сэ пунэ друӂий месей. ");
INSERT INTO ron1924_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Сэ я ун ковор албастру ши сэ акопере сфешникул, канделеле луй, мукэриле луй, ченушареле луй ши тоате васеле луй пентру унтделемн, каре се ынтребуинцязэ пентру служба луй; ");
INSERT INTO ron1924_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","сэ-л пунэ ку тоате унелтеле луй ынтр-о ынвелитоаре де пеле де вицел де маре; апой сэ-л пунэ пе таргэ. ");
INSERT INTO ron1924_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Песте алтарул де аур сэ ынтиндэ ун ковор албастру ши сэ-л акопере ку о ынвелитоаре де пеле де вицел де маре; апой сэ-й пунэ друӂий. ");
INSERT INTO ron1924_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Сэ я апой тоате унелтеле ынтребуинцате пентру службэ ын Сфынтул Локаш ши сэ ле пунэ ынтр-ун ковор албастру ши сэ ле акопере ку о ынвелитоаре де пеле де вицел де маре; апой сэ ле пунэ пе таргэ. ");
INSERT INTO ron1924_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Сэ я ченуша дин алтар ши сэ ынтиндэ песте алтар ун ковор де пурпурэ; ");
INSERT INTO ron1924_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","сэ пунэ дясупра тоате унелтеле пентру служба луй, тигэиле пентру кэрбунь, фуркулицеле, лопециле, лигенеле, тоате унелтеле алтарулуй ши дясупра сэ ынтиндэ о ынвелитоаре де пеле де вицел де маре; апой сэ-й пунэ друӂий. ");
INSERT INTO ron1924_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Дупэ че Аарон ши фиий луй вор испрэви де акоперит Сфынтул Локаш ши тоате унелтеле Сфынтулуй Локаш, фиий луй Кехат сэ винэ, ла порниря таберей, ка сэ ле дукэ, дар сэ ну се атингэ де лукруриле сфинте, ка сэ ну моарэ. Ачестя сунт лукруриле пе каре ау сэ ле дукэ фиий луй Кехат дин кортул ынтылнирий. ");
INSERT INTO ron1924_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Елеазар, фиул преотулуй Аарон, сэ айбэ суб привегеря луй унтделемнул пентру сфешник, тэмыя мироситоаре, дарул де пыне де тоате зилеле ши унтделемнул пентру унӂере; сэ айбэ ын грижа луй тот кортул ши тот че купринде ел, Сфынтул Локаш ши унелтеле луй.” ");
INSERT INTO ron1924_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Домнул а ворбит луй Мойсе ши луй Аарон ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","„Сэ ну кумва сэ пунець нямул фамилиилор кехатицилор ын примеждие сэ фие нимичит дин мижлокул левицилор. ");
INSERT INTO ron1924_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Ятэ че сэ фачець пентру ей ка сэ трэяскэ, ши сэ ну моарэ, кынд се вор апропия де Локул Прясфынт: Аарон ши фиий луй сэ винэ ши сэ пунэ пе фиекаре дин ей ла служба ши сарчина луй. ");
INSERT INTO ron1924_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Сэ ну интре ей сэ ынвеляскэ лукруриле сфинте, ка сэ ну моарэ.” ");
INSERT INTO ron1924_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","„Нумэрэ ши пе фиий луй Гершон, дупэ каселе пэринцилор лор, дупэ фамилииле лор, ");
INSERT INTO ron1924_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","ши ануме сэ фачь нумэрэтоаря, ынчепынд де ла вырста де трейзечь де ань ын сус пынэ ла вырста де чинчзечь де ань, а тутурор челор че сунт ын старе сэ ымплиняскэ врео службэ ын кортул ынтылнирий. ");
INSERT INTO ron1924_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Ятэ службеле фамилиилор гершоницилор, служба пе каре вор требуи с-о факэ ши че вор требуи сэ дукэ. ");
INSERT INTO ron1924_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Сэ дукэ ковоареле кортулуй ши кортул ынтылнирий, ынвелитоаря луй ши ынвелитоаря де пеле де вицел де маре, каре се пуне дясупра, пердяуа де ла уша кортулуй ынтылнирий, ");
INSERT INTO ron1924_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","пынзеле курций ши пердяуа де ла уша порций курций, де жур ымпрежурул кортулуй ши алтарулуй, фунииле лор ши тоате унелтеле каре цин де еле. Ши ей сэ факэ тоатэ служба привитоаре ла ачесте лукрурь. ");
INSERT INTO ron1924_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Ын службеле лор, фиий гершоницилор сэ фие суб порунчиле луй Аарон ши фиилор луй, пентру тот че вор дуче ши пентру тоатэ служба пе каре вор требуи с-о факэ; ын грижа лор сэ даць тот че ау де дус. ");
INSERT INTO ron1924_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Ачестя сунт службеле фамилиилор фиилор гершоницилор ын кортул ынтылнирий ши че ау ей де пэзит суб кырмуиря луй Итамар, фиул преотулуй Аарон. ");
INSERT INTO ron1924_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Сэ фачь нумэрэтоаря фиилор луй Мерари, дупэ фамилииле лор, дупэ каселе пэринцилор лор, ");
INSERT INTO ron1924_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","ши ануме сэ фачь нумэрэтоаря, ынчепынд де ла вырста де трейзечь де ань ын сус пынэ ла вырста де чинчзечь де ань, а тутурор челор че сунт ын старе сэ факэ врео службэ ын кортул ынтылнирий. ");
INSERT INTO ron1924_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Ятэ че есте дат ын грижа лор ши че ау ей де дус, пентру тоате службеле дин кортул ынтылнирий: скындуриле кортулуй, друӂий луй, стылпий луй, пичоареле луй; ");
INSERT INTO ron1924_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","стылпий курций де жур ымпрежур, пичоареле лор, цэруший лор, фунииле лор, тоате унелтеле каре цин де ей ши тот че есте рындуит пентру служба лор. Сэ спунець пе нуме лукруриле каре сунт дате ын грижа лор ши пе каре ле ау ей де пуртат. ");
INSERT INTO ron1924_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Ачестя сунт службеле фамилиилор фиилор луй Мерари, тоате службеле пе каре ау сэ ле факэ ей ын кортул ынтылнирий, суб кырмуиря луй Итамар, фиул преотулуй Аарон.” ");
INSERT INTO ron1924_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Мойсе, Аарон ши май-марий адунэрий ау фэкут нумэрэтоаря фиилор кехатицилор, дупэ фамилииле лор ши дупэ каселе пэринцилор лор, ");
INSERT INTO ron1924_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","ши ануме а тутурор ачелора каре, де ла вырста де трейзечь де ань ын сус, пынэ ла вырста де чинчзечь де ань, ерау ын старе сэ факэ врео службэ ын кортул ынтылнирий. ");
INSERT INTO ron1924_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Чей ешиць ла нумэрэтоаре, дупэ фамилииле лор, ау фост доуэ мий шапте суте чинчзечь. ");
INSERT INTO ron1924_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Ачештя сунт чей ешиць ла нумэрэтоаре дин фамилииле кехатицилор, тоць чей че фэчяу врео службэ ын кортул ынтылнирий; Мойсе ши Аарон ле-ау фэкут нумэрэтоаря, дупэ порунка Домнулуй датэ прин Мойсе. ");
INSERT INTO ron1924_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Фиий луй Гершон ешиць ла нумэрэтоаре, дупэ фамилииле лор ши дупэ каселе пэринцилор лор, ");
INSERT INTO ron1924_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","де ла вырста де трейзечь де ань ын сус пынэ ла вырста де чинчзечь де ань, ши ануме тоць чей че ерау ын старе сэ факэ врео службэ ын кортул ынтылнирий, ");
INSERT INTO ron1924_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","чей ешиць ла нумэрэтоаре, дупэ фамилииле лор, дупэ каселе пэринцилор лор, ау фост доуэ мий шасе суте трейзечь. ");
INSERT INTO ron1924_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Ачештя сунт чей ешиць ла нумэрэтоаре дин фамилииле фиилор луй Гершон, тоць чей че фэчяу врео службэ ын кортул ынтылнирий; Мойсе ши Аарон ле-ау фэкут нумэрэтоаря дупэ порунка Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Чей ешиць ла нумэрэтоаре динтре фамилииле фиилор луй Мерари, дупэ фамилииле лор, дупэ каселе пэринцилор лор, ");
INSERT INTO ron1924_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","де ла вырста де трейзечь де ань ын сус пынэ ла вырста де чинчзечь де ань, тоць чей че ерау ын старе сэ факэ врео службэ ын кортул ынтылнирий, ");
INSERT INTO ron1924_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","чей ешиць ла нумэрэтоаре, дупэ фамилииле лор, ау фост трей мий доуэ суте. ");
INSERT INTO ron1924_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Ачештя сунт чей ешиць ла нумэрэтоаре дин фамилииле фиилор луй Мерари; Мойсе ши Аарон ле-ау фэкут нумэрэтоаря дупэ порунка Домнулуй датэ прин Мойсе. ");
INSERT INTO ron1924_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Тоць ачея динтре левиць а кэрор нумэрэтоаре ау фэкут-о Мойсе, Аарон ши май-марий луй Исраел, дупэ фамилииле лор ши дупэ каселе пэринцилор лор, ");
INSERT INTO ron1924_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","де ла вырста де трейзечь де ань ын сус пынэ ла вырста де чинчзечь де ань, тоць чей че ерау ын старе сэ факэ врео службэ ши сэ дукэ кортул ынтылнирий, ");
INSERT INTO ron1924_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","тоць чей ешиць ла нумэрэтоаре ау фост опт мий чинч суте оптзечь. ");
INSERT INTO ron1924_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Ле-ау фэкут нумэрэтоаря дупэ порунка Домнулуй датэ прин Мойсе, арэтынд фиекэруя служба пе каре требуя с-о факэ ши че требуя сэ дукэ; ле-ау фэкут нумэрэтоаря дупэ порунка пе каре о дэдусе луй Мойсе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","„Порунчеште копиилор луй Исраел сэ изгоняскэ дин табэрэ пе орьче лепрос ши пе орьчине аре о лепэдаре де сэмынцэ сау есте ынтинат прин атинӂеря де ун морт. ");
INSERT INTO ron1924_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Фие бэрбаць, фие фемей, сэ-й скоатець дин табэрэ; сэ-й скоатець афарэ, ка сэ ну спурче табэра ын мижлокул кэрея Ымь ам Еу локуинца.” ");
INSERT INTO ron1924_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Копиий луй Исраел ау фэкут аша ши й-ау скос афарэ дин табэрэ; кум порунчисе луй Мойсе Домнул, аша ау фэкут копиий луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","„Спуне копиилор луй Исраел: ‘Кынд ун бэрбат сау о фемее ва пэкэтуи ымпотрива апроапелуй сэу, фэкынд о кэлкаре де леӂе фацэ де Домнул, ши се ва фаче астфел виноват, ");
INSERT INTO ron1924_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","сэ-шь мэртурисяскэ пэкатул ши сэ дя ынапой ын ынтреӂиме прецул лукрулуй кыштигат прин мижлоаче нечинстите, адэугынд а чинчя парте; сэ-л дя ачелуя фацэ де каре с-а фэкут виноват. ");
INSERT INTO ron1924_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Дакэ ну есте нимень каре сэ айбэ дрепт сэ я ынапой лукрул кыштигат прин мижлоаче нечинстите, лукрул ачела сэ се ынтоаркэ ла Домнул, ла преот, афарэ де бербекул адус ка жертфэ де испэшире ку каре се ва фаче испэшире пентру чел виноват. ");
INSERT INTO ron1924_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Орьче дар ридикат дин лукруриле ынкинате Домнулуй де копиий луй Исраел сэ фие ал преотулуй кэруя ый сунт адусе. ");
INSERT INTO ron1924_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Лукруриле ынкинате Домнулуй вор фи але преотулуй: тот че и се ва да преотулуй ал луй сэ фие.’” ");
INSERT INTO ron1924_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","„Ворбеште копиилор луй Исраел ши спуне-ле: ‘Дакэ пэкэтуеште неваста куйва фацэ де бэрбатул ей ши-й есте некрединчоасэ; ");
INSERT INTO ron1924_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","дакэ алтул се кулкэ ку еа ши лукрул есте аскунс де бэрбатул ей; дакэ еа с-а пынгэрит ын аскунс, фэрэ сэ фие вреун мартор ымпотрива ей ши фэрэ сэ фие принсэ асупра фаптулуй; ");
INSERT INTO ron1924_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","ши дакэ бэрбатул есте апукат де ун дух де ӂелозие ши аре бэнуель асупра невестей луй, каре с-а пынгэрит, сау дакэ есте купринс де ун дух де ӂелозие ши аре бэнуель асупра невестей луй, каре ну с-а пынгэрит, ");
INSERT INTO ron1924_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","омул ачела сэ-шь адукэ неваста ла преот ши, ка дар де мынкаре пентру еа, сэ адукэ а зечя парте динтр-о ефэ де флоаре де фэинэ де орз; сэ ну тоарне унтделемн пе еа ши сэ ну пунэ тэмые пе еа, кэч ачеста есте ун дар де мынкаре адус пентру ӂелозие, ун дар де дескоперире, каре дескоперэ о фэрэделеӂе. ");
INSERT INTO ron1924_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Преотул с-о апропие ши с-о пунэ сэ стя ын пичоаре ынаинтя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Преотул сэ я апэ сфынтэ ынтр-ун вас де пэмынт, сэ я цэрынэ де пе подяуа кортулуй ши с-о пунэ ын апэ. ");
INSERT INTO ron1924_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Преотул сэ пунэ пе фемее сэ стя ын пичоаре ынаинтя Домнулуй, сэ дескопере капул фемеий ши сэ-й пунэ ын мынь дарул де мынкаре адус пентру дескоперире, дарул де мынкаре адус пентру ӂелозие; преотул сэ айбэ ын мынэ апеле амаре адукэтоаре де блестем. ");
INSERT INTO ron1924_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Преотул сэ пунэ пе фемее сэ журе ши сэ-й зикэ: «Дакэ ничун ом ну с-а кулкат ку тине ши дакэ, фиинд суб путеря бэрбатулуй тэу, ну те-ай абэтут де ла ел ка сэ те пынгэрешть ку алтул, сэ ну-ць факэ ничун рэу ачесте апе амаре адукэтоаре де блестем! ");
INSERT INTO ron1924_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Дар дакэ, фиинд суб путеря бэрбатулуй тэу, те-ай абэтут де ла ел ши те-ай пынгэрит ши дакэ ун алт ом декыт бэрбатул тэу с-а кулкат ку тине», ");
INSERT INTO ron1924_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","ши преотул сэ пунэ пе фемее сэ журе ку ун журэмынт де блестем ши сэ-й зикэ: «Домнул сэ те факэ сэ ажунӂь де блестем ши де урӂие ын мижлокул попорулуй тэу, фэкынд сэ ци се усуче коапса ши сэ ци се умфле пынтечеле, ");
INSERT INTO ron1924_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","ши апеле ачестя адукэтоаре де блестем сэ интре ын мэрунтаеле тале, ка сэ факэ сэ ци се умфле пынтечеле ши сэ ци се усуче коапса!» Ши фемея сэ зикэ: «Амин! Амин!» ");
INSERT INTO ron1924_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Преотул сэ скрие блестемеле ачестя ынтр-о карте, апой сэ ле штяргэ ку апеле челе амаре. ");
INSERT INTO ron1924_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Ши сэ дя фемеий сэ бя апеле амаре адукэтоаре де блестем, ши апеле адукэтоаре де блестем вор интра ын еа ши-й вор причинуи амэрэчуня. ");
INSERT INTO ron1924_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Преотул сэ я дин мыниле фемеий дарул де мынкаре адус пентру ӂелозие, сэ леӂене дарул ынтр-о парте ши ынтр-алта ынаинтя Домнулуй ши сэ-л адукэ пе алтар. ");
INSERT INTO ron1924_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Апой преотул сэ я ун пумн дин дарул ачеста, ка адучере аминте, ши сэ-л ардэ пе алтар. Дупэ ачея, сэ дя фемеий сэ бя апеле. ");
INSERT INTO ron1924_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Дупэ че ый ва да сэ бя апеле, дакэ еа с-а пынгэрит ши а фост некрединчоасэ бэрбатулуй ей, апеле адукэтоаре де блестем вор интра ын еа ши-й вор причинуи амэрэчуня; пынтечеле и се ва умфла, коапса и се ва уска, ши фемея ачаста ва фи де блестем ын мижлокул попорулуй ей. ");
INSERT INTO ron1924_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Дар, дакэ фемея ну с-а пынгэрит ши есте куратэ, ва рэмыне неатинсэ ши ва авя копий. ");
INSERT INTO ron1924_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Ачаста есте леӂя асупра ӂелозией, пентру ымпрежураря кынд о фемее каре есте суб путеря бэрбатулуй ей се абате ши се пынгэреште ");
INSERT INTO ron1924_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ши пентру ымпрежураря кынд ун бэрбат, апукат де ун дух де ӂелозие, аре бэнуель асупра невестей луй: преотул с-о пунэ сэ стя ын пичоаре ынаинтя Домнулуй ши сэ-й факэ ынтокмай дупэ леӂя ачаста. ");
INSERT INTO ron1924_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Бэрбатул ва фи скутит де винэ, дар фемея ачея ышь ва луа педяпса нелеӂюирий ей.’” ");
INSERT INTO ron1924_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","„Ворбеште копиилор луй Исраел ши спуне-ле: ‘Кынд ун бэрбат сау о фемее се ва деспэрци де чейлалць, фэкынд о журуинцэ де назиреат, ка сэ се ынкине Домнулуй, ");
INSERT INTO ron1924_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","сэ се феряскэ де вин ши де бэутурэ ымбэтэтоаре; сэ ну бя нич оцет фэкут дин вин, нич оцет фэкут дин врео бэутурэ ымбэтэтоаре; сэ ну бя ничо бэутурэ стоарсэ дин стругурь ши сэ ну мэнынче стругурь проаспець, нич ускаць. ");
INSERT INTO ron1924_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Ын тот тимпул назиреатулуй луй, сэ ну мэнынче нимик каре вине дин вицэ, де ла сымбурь пынэ ла пелица стругурелуй. ");
INSERT INTO ron1924_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Ын тот тимпул назиреатулуй, бричул сэ ну трякэ пе капул луй; пынэ ла ымплиниря зилелор пентру каре с-а ынкинат Домнулуй, ва фи сфынт; сэ-шь ласе пэрул сэ кряскэ ын вое. ");
INSERT INTO ron1924_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Ын тот тимпул кыт с-а фэгэдуит Домнулуй прин журэмынт, сэ ну се апропие де ун морт; ");
INSERT INTO ron1924_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","сэ ну се пынгэряскэ нич ла моартя татэлуй сэу, нич а мамей сале, нич а фрателуй сэу, нич а сурорий сале, кэч поартэ пе кап ынкинаря Думнезеулуй луй. ");
INSERT INTO ron1924_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Ын тот тимпул назиреатулуй, сэ фие ынкинат Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Дакэ моаре чинева де моарте нэпрасникэ лынгэ ел ши капул луй ынкинат се фаче астфел некурат, сэ-шь радэ капул ын зиуа курэцирий, ши ануме сэ ши-л радэ а шаптя зи. ");
INSERT INTO ron1924_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Ын зиуа а опта, сэ адукэ преотулуй доуэ туртуреле сау дой пуй де порумбел, ла уша кортулуй ынтылнирий. ");
INSERT INTO ron1924_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Преотул сэ жертфяскэ пе унул ка жертфэ де испэшире, яр пе челэлалт ка ардере-де-тот ши сэ факэ пентру ел испэширя пэкатулуй луй, фэкут ку прилежул мортулуй. Назиреул сэ-шь сфинцяскэ апой капул кяр ын зиуа ачея. ");
INSERT INTO ron1924_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Сэ ынкине дин ноу Домнулуй зилеле назиреатулуй луй динаинте ши сэ адукэ ун мел де ун ан ка жертфэ пентру винэ; зилеле динаинте ну вор фи сокотите, пентру кэ назиреатул луй а фост пынгэрит. ");
INSERT INTO ron1924_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Ятэ леӂя назиреулуй. Ын зиуа кынд се ва ымплини время назиреатулуй луй, сэ фие адус ла уша кортулуй ынтылнирий. ");
INSERT INTO ron1924_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Ка дар, сэ адукэ Домнулуй ун мел де ун ан фэрэ кусур пентру ардеря-де-тот, о оае де ун ан ши фэрэ кусур пентру жертфа де испэшире ши ун бербек фэрэ кусур пентру жертфа де мулцумире; ");
INSERT INTO ron1924_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","ун кош ку азиме, турте фэкуте дин флоаря фэиний фрэмынтатэ ку унтделемн, ши плэчинте фэрэ алуат, стропите ку унтделемн, ымпреунэ ку дарул де мынкаре ши жертфа де бэутурэ обишнуите. ");
INSERT INTO ron1924_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Преотул сэ адукэ ачесте лукрурь ынаинтя Домнулуй ши сэ адукэ жертфа луй де испэшире ши ардеря-де-тот; ");
INSERT INTO ron1924_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","сэ прегэтяскэ бербекул ка жертфэ де мулцумире Домнулуй, ымпреунэ ку кошул ку азиме, ши сэ прегэтяскэ ши дарул луй де мынкаре ши жертфа луй де бэутурэ. ");
INSERT INTO ron1924_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Назиреул сэ-шь радэ, ла уша кортулуй ынтылнирий, капул ынкинат Домнулуй; сэ я пэрул капулуй сэу ынкинат Домнулуй ши сэ-л пунэ пе фокул каре есте суб жертфа де мулцумире. ");
INSERT INTO ron1924_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Преотул сэ я спата дряптэ фяртэ а бербекулуй, о туртэ недоспитэ дин кош ши о плэчинтэ недоспитэ ши сэ ле пунэ ын мыниле назиреулуй, дупэ че ачеста шь-а рас капул ынкинат Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Преотул сэ ле леӂене ынтр-о парте ши ынтр-алта ынаинтя Домнулуй: ачеста есте ун лукру сфынт, каре есте ал преотулуй, ымпреунэ ку пептул легэнат ши спата адусэ ка жертфэ прин ридикаре. Апой, назиреул ва путя сэ бя вин. ");
INSERT INTO ron1924_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Ачаста есте леӂя пентру чел че а фэкут журуинца де назиреат: ачеста есте дарул луй, каре требуе адус Домнулуй пентру назиреатул луй, афарэ де че-й вор ынгэдуи мижлоачеле луй. Сэ ымплиняскэ тот че есте порунчит пентру журуинца пе каре а фэкут-о, дупэ леӂя назиреатулуй.’” ");
INSERT INTO ron1924_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","„Ворбеште луй Аарон ши фиилор луй ши спуне-ле: ‘Аша сэ бинекувынтаць пе копиий луй Исраел ши сэ ле зичець: ");
INSERT INTO ron1924_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","«Домнул сэ те бинекувынтезе ши сэ те пэзяскэ! ");
INSERT INTO ron1924_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Домнул сэ факэ сэ луминезе Фаца Луй песте тине ши сэ Се ындуре де тине! ");
INSERT INTO ron1924_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Домнул сэ-Шь ыналце Фаца песте тине ши сэ-ць дя пачя!» ");
INSERT INTO ron1924_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Астфел сэ пунэ Нумеле Меу песте копиий луй Исраел, ши Еу ый вой бинекувынта.’” ");
INSERT INTO ron1924_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Кынд а испрэвит Мойсе де ашезат кортул, л-а унс ши л-а сфинцит ымпреунэ ку тоате унелтеле луй, прекум ши алтарул ку тоате унелтеле луй; ле-а унс ши ле-а сфинцит. ");
INSERT INTO ron1924_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Атунч, май-марий луй Исраел, кэпетенииле каселор пэринцилор лор, шь-ау адус даруриле лор: ачештя ерау май-марий семинциилор каре луасерэ парте ла нумэрэтоаре. ");
INSERT INTO ron1924_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Ей ау адус ка дар ынаинтя Домнулуй шасе каре акоперите ши дойспрезече бой, адикэ ун кар ла доуэ кэпетений ши ун боу де фиекаре кэпетение, ши ле-ау адус ынаинтя кортулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","„Я де ла ей ачесте лукрурь ши сэ ле ынтребуинцезь пентру служба кортулуй ынтылнирий; сэ ле дай левицилор, фиекэруя дупэ кум чере служба луй.” ");
INSERT INTO ron1924_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Мойсе а луат кареле ши боий ши ле-а дат левицилор. ");
INSERT INTO ron1924_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","А дат доуэ каре ши патру бой фиилор луй Гершон, дупэ кум черяу службеле лор; ");
INSERT INTO ron1924_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","а дат патру каре ши опт бой фиилор луй Мерари, дупэ кум черяу службеле лор, суб кырмуиря луй Итамар, фиул преотулуй Аарон. ");
INSERT INTO ron1924_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Дар н-а дат ничунул фиилор луй Кехат, пентру кэ, дупэ кум черяу службеле лор, ей требуяу сэ дукэ лукруриле сфинте пе умерь. ");
INSERT INTO ron1924_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Кэпетенииле шь-ау адус даруриле пентру тырносиря алтарулуй ын зиуа кынд л-ау унс; кэпетенииле шь-ау адус даруриле ынаинтя алтарулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Домнул а зис луй Мойсе: „Кэпетенииле сэ винэ унул кыте унул, ши ануме фиекаре ын кыте о зи деосебитэ, ка сэ-шь адукэ дарул пентру тырносиря алтарулуй.” ");
INSERT INTO ron1924_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Чел че шь-а адус дарул ын зиуа ынтый а фост Нахшон, фиул луй Аминадаб, дин семинция луй Иуда. ");
INSERT INTO ron1924_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Ел а адус о фарфурие де арӂинт ын греутате де о сутэ трейзечь де сикли, ун лигян де арӂинт де шаптезечь де сикли, дупэ сиклул Сфынтулуй Локаш, амындоуэ плине ку флоаре де фэинэ фрэмынтатэ ку унтделемн, пентру дарул де мынкаре; ");
INSERT INTO ron1924_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","о кэцуе де аур де зече сикли, плинэ ку тэмые, ");
INSERT INTO ron1924_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","ун вицел, ун бербек, ун мел де ун ан пентру ардеря-де-тот; ");
INSERT INTO ron1924_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","ун цап пентру жертфа де испэшире ");
INSERT INTO ron1924_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","ши, пентру жертфа де мулцумире, дой бой, чинч бербечь, чинч цапь, чинч мей де ун ан. Ачеста а фост дарул луй Нахшон, фиул луй Аминадаб. ");
INSERT INTO ron1924_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","А доуа зи, шь-а адус дарул Нетанеел, фиул луй Цуар, кэпетения луй Исахар. ");
INSERT INTO ron1924_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Ел а адус о фарфурие де арӂинт ын греутате де о сутэ трейзечь де сикли, ун лигян де арӂинт де шаптезечь де сикли, дупэ сиклул Сфынтулуй Локаш, амындоуэ плине ку флоаре де фэинэ фрэмынтатэ ку унтделемн, пентру дарул де мынкаре; ");
INSERT INTO ron1924_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","о кэцуе де аур де зече сикли, плинэ ку тэмые; ");
INSERT INTO ron1924_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","ун вицел, ун бербек, ун мел де ун ан пентру ардеря-де-тот; ");
INSERT INTO ron1924_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","ун цап пентру жертфа де испэшире ");
INSERT INTO ron1924_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","ши, пентру жертфа де мулцумире, дой бой, чинч бербечь, чинч цапь, чинч мей де ун ан. Ачеста а фост дарул луй Нетанеел, фиул луй Цуар. ");
INSERT INTO ron1924_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","А трея зи, кэпетения фиилор луй Забулон, Елиаб, фиул луй Хелон, ");
INSERT INTO ron1924_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","а адус о фарфурие де арӂинт ын греутате де о сутэ трейзечь де сикли, ун лигян де арӂинт де шаптезечь де сикли, дупэ сиклул Сфынтулуй Локаш, амындоуэ плине ку флоаре де фэинэ фрэмынтатэ ку унтделемн, пентру дарул де мынкаре; ");
INSERT INTO ron1924_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","о кэцуе де аур де зече сикли, плинэ ку тэмые; ");
INSERT INTO ron1924_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","ун вицел, ун бербек, ун мел де ун ан пентру ардеря-де-тот; ");
INSERT INTO ron1924_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","ун цап пентру жертфа де испэшире ");
INSERT INTO ron1924_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","ши, пентру жертфа де мулцумире, дой бой, чинч бербечь, чинч цапь, чинч мей де ун ан. Ачеста а фост дарул луй Елиаб, фиул луй Хелон. ");
INSERT INTO ron1924_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","А патра зи, кэпетения фиилор луй Рубен, Елицур, фиул луй Шедеур, ");
INSERT INTO ron1924_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","а адус о фарфурие де арӂинт ын греутате де о сутэ трейзечь де сикли, ун лигян де арӂинт де шаптезечь де сикли, дупэ сиклул Сфынтулуй Локаш, амындоуэ плине ку флоаре де фэинэ фрэмынтатэ ку унтделемн, пентру дарул де мынкаре; ");
INSERT INTO ron1924_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","о кэцуе де аур де зече сикли, плинэ ку тэмые; ");
INSERT INTO ron1924_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","ун вицел, ун бербек, ун мел де ун ан пентру ардеря-де-тот; ");
INSERT INTO ron1924_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","ун цап пентру жертфа де испэшире ");
INSERT INTO ron1924_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","ши, пентру жертфа де мулцумире, дой бой, чинч бербечь, чинч цапь, чинч мей де ун ан. Ачеста а фост дарул луй Елицур, фиул луй Шедеур. ");
INSERT INTO ron1924_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","А чинчя зи, кэпетения фиилор луй Симеон, Шелумиел, фиул луй Цуришадай, ");
INSERT INTO ron1924_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","а адус о фарфурие де арӂинт ын греутате де о сутэ трейзечь де сикли, ун лигян де арӂинт де шаптезечь де сикли, дупэ сиклул Сфынтулуй Локаш, амындоуэ плине ку флоаре де фэинэ фрэмынтатэ ку унтделемн, пентру дарул де мынкаре; ");
INSERT INTO ron1924_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","о кэцуе де аур де зече сикли, плинэ ку тэмые; ");
INSERT INTO ron1924_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","ун вицел, ун бербек, ун мел де ун ан пентру ардеря-де-тот; ");
INSERT INTO ron1924_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","ун цап пентру жертфа де испэшире ");
INSERT INTO ron1924_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","ши, пентру жертфа де мулцумире, дой бой, чинч бербечь, чинч цапь, чинч мей де ун ан. Ачеста а фост дарул де мынкаре ал луй Шелумиел, фиул луй Цуришадай. ");
INSERT INTO ron1924_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","А шася зи, кэпетения фиилор луй Гад, Елиасаф, фиул луй Деуел, ");
INSERT INTO ron1924_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","а адус о фарфурие де арӂинт ын греутате де о сутэ трейзечь де сикли, ун лигян де арӂинт де шаптезечь де сикли, дупэ сиклул Сфынтулуй Локаш, амындоуэ плине ку флоаре де фэинэ фрэмынтатэ ку унтделемн, пентру дарул де мынкаре; ");
INSERT INTO ron1924_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","о кэцуе де аур де зече сикли, плинэ ку тэмые; ");
INSERT INTO ron1924_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","ун вицел, ун бербек, ун мел де ун ан пентру ардеря-де-тот; ");
INSERT INTO ron1924_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","ун цап пентру жертфа де испэшире ");
INSERT INTO ron1924_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","ши, пентру жертфа де мулцумире, дой бой, чинч бербечь, чинч цапь, чинч мей де ун ан. Ачеста а фост дарул луй Елиасаф, фиул луй Деуел. ");
INSERT INTO ron1924_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","А шаптя зи, кэпетения фиилор луй Ефраим, Елишама, фиул луй Амихуд, ");
INSERT INTO ron1924_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","а адус о фарфурие де арӂинт ын греутате де о сутэ трейзечь де сикли, ун лигян де арӂинт де шаптезечь де сикли, дупэ сиклул Сфынтулуй Локаш, амындоуэ плине ку флоаре де фэинэ фрэмынтатэ ку унтделемн, пентру дарул де мынкаре; ");
INSERT INTO ron1924_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","о кэцуе де аур де зече сикли, плинэ ку тэмые; ");
INSERT INTO ron1924_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","ун вицел, ун бербек, ун мел де ун ан пентру ардеря-де-тот; ");
INSERT INTO ron1924_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","ун цап пентру жертфа де испэшире ");
INSERT INTO ron1924_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","ши, пентру жертфа де мулцумире, дой бой, чинч бербечь, чинч цапь, чинч мей де ун ан. Ачеста а фост дарул луй Елишама, фиул луй Амихуд. ");
INSERT INTO ron1924_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","А опта зи, кэпетения фиилор луй Манасе, Гамлиел, фиул луй Педахцур, ");
INSERT INTO ron1924_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","а адус о фарфурие де арӂинт ын греутате де о сутэ трейзечь де сикли, ун лигян де арӂинт де шаптезечь де сикли, дупэ сиклул Сфынтулуй Локаш, амындоуэ плине ку флоаре де фэинэ фрэмынтатэ ку унтделемн, пентру дарул де мынкаре; ");
INSERT INTO ron1924_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","о кэцуе де аур де зече сикли, плинэ ку тэмые; ");
INSERT INTO ron1924_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","ун вицел, ун бербек, ун мел де ун ан пентру ардеря-де-тот; ");
INSERT INTO ron1924_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","ун цап пентру жертфа де испэшире ");
INSERT INTO ron1924_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","ши, пентру жертфа де мулцумире, дой бой, чинч бербечь, чинч цапь, чинч мей де ун ан. Ачеста а фост дарул луй Гамлиел, фиул луй Педахцур. ");
INSERT INTO ron1924_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","А ноуа зи, кэпетения фиилор луй Бениамин, Абидан, фиул луй Гидеони, ");
INSERT INTO ron1924_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","а адус о фарфурие де арӂинт ын греутате де о сутэ трейзечь де сикли, ун лигян де арӂинт де шаптезечь де сикли, дупэ сиклул Сфынтулуй Локаш, амындоуэ плине ку флоаре де фэинэ фрэмынтатэ ку унтделемн, пентру дарул де мынкаре; ");
INSERT INTO ron1924_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","о кэцуе де аур де зече сикли, плинэ ку тэмые; ");
INSERT INTO ron1924_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","ун вицел, ун бербек, ун мел де ун ан пентру ардеря-де-тот; ");
INSERT INTO ron1924_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","ун цап пентру жертфа де испэшире ");
INSERT INTO ron1924_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","ши, пентру жертфа де мулцумире, дой бой, чинч бербечь, чинч цапь, чинч мей де ун ан. Ачеста а фост дарул луй Абидан, фиул луй Гидеони. ");
INSERT INTO ron1924_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","А зечя зи, кэпетения фиилор луй Дан, Ахиезер, фиул луй Амишадай, ");
INSERT INTO ron1924_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","а адус о фарфурие де арӂинт ын греутате де о сутэ трейзечь де сикли, ун лигян де арӂинт де шаптезечь де сикли, дупэ сиклул Сфынтулуй Локаш, амындоуэ плине ку флоаре де фэинэ фрэмынтатэ ку унтделемн, пентру дарул де мынкаре; ");
INSERT INTO ron1924_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","о кэцуе де аур, плинэ ку тэмые; ");
INSERT INTO ron1924_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","ун вицел, ун бербек, ун мел де ун ан пентру ардеря-де-тот; ");
INSERT INTO ron1924_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","ун цап пентру жертфа де испэшире ");
INSERT INTO ron1924_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","ши, пентру жертфа де мулцумире, дой бой, чинч бербечь, чинч цапь, чинч мей де ун ан. Ачеста а фост дарул луй Ахиезер, фиул луй Амишадай. ");
INSERT INTO ron1924_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","А унспрезечя зи, кэпетения фиилор луй Ашер, Пагуиел, фиул луй Окран, ");
INSERT INTO ron1924_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","а адус о фарфурие де арӂинт ын греутате де о сутэ трейзечь де сикли, ун лигян де арӂинт де шаптезечь де сикли, дупэ сиклул Сфынтулуй Локаш, амындоуэ плине ку флоаре де фэинэ фрэмынтатэ ку унтделемн, пентру дарул де мынкаре; ");
INSERT INTO ron1924_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","о кэцуе де аур де зече сикли, плинэ ку тэмые; ");
INSERT INTO ron1924_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","ун вицел, ун бербек, ун мел де ун ан пентру ардеря-де-тот; ");
INSERT INTO ron1924_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","ун цап пентру жертфа де испэшире ");
INSERT INTO ron1924_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","ши, пентру жертфа де мулцумире, дой бой, чинч бербечь, чинч цапь, чинч мей де ун ан. Ачеста а фост дарул луй Пагуиел, фиул луй Окран. ");
INSERT INTO ron1924_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","А доуэспрезечя зи, кэпетения фиилор луй Нефтали, Ахира, фиул луй Енан, ");
INSERT INTO ron1924_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","а адус о фарфурие де арӂинт ын греутате де о сутэ трейзечь де сикли, ун лигян де арӂинт де шаптезечь де сикли, дупэ сиклул Сфынтулуй Локаш, амындоуэ плине ку флоаре де фэинэ фрэмынтатэ ку унтделемн, пентру дарул де мынкаре; ");
INSERT INTO ron1924_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","о кэцуе де аур де зече сикли, плинэ ку тэмые; ");
INSERT INTO ron1924_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","ун вицел, ун бербек, ун мел де ун ан пентру ардеря-де-тот; ");
INSERT INTO ron1924_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","ун цап пентру жертфа де испэшире ");
INSERT INTO ron1924_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","ши, пентру жертфа де мулцумире, дой бой, чинч бербечь, чинч цапь, чинч мей де ун ан. Ачеста а фост дарул луй Ахира, фиул луй Енан. ");
INSERT INTO ron1924_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Ачестя ау фост даруриле адусе де кэпетенииле луй Исраел пентру тырносиря алтарулуй, ын зиуа кынд л-ау унс. Ау фост доуэспрезече фарфурий де арӂинт, доуэспрезече лигене де арӂинт, доуэспрезече кэцуй де аур; ");
INSERT INTO ron1924_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","фиекаре фарфурие де арӂинт кынтэря о сутэ трейзечь де сикли ши фиекаре лигян кынтэря шаптезечь де сикли, аша кэ арӂинтул ачестор унелте се ридика ын тотул ла доуэ мий патру суте де сикли, дупэ сиклул Сфынтулуй Локаш. ");
INSERT INTO ron1924_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Ау фост доуэспрезече кэцуй де аур плине ку тэмые, кыте зече сикли кэцуя, дупэ сиклул Сфынтулуй Локаш; аурул кэцуилор се ридика ын тотул ла о сутэ доуэзечь де сикли. ");
INSERT INTO ron1924_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Тоате добитоачеле пентру ардеря-де-тот ау фост: дойспрезече вицей, дойспрезече бербечь, дойспрезече мей де ун ан, ку даруриле де мынкаре обишнуите, дойспрезече цапь, пентру жертфа де испэшире. ");
INSERT INTO ron1924_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Тоате добитоачеле пентру жертфа де мулцумире: доуэзечь ши патру де бой, шайзечь де бербечь, шайзечь де цапь, шайзечь де мей де ун ан. Ачестя ау фост даруриле адусе пентру тырносиря алтарулуй, дупэ че л-ау унс. ");
INSERT INTO ron1924_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Кынд интра Мойсе ын кортул ынтылнирий ка сэ ворбяскэ ку Домнул, аузя гласул каре-й ворбя де пе капакул испэширий, каре ера ашезат пе кивотул мэртурией, ынтре чей дой херувимь. Ши ворбя ку Домнул. ");
INSERT INTO ron1924_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","„Ворбеште луй Аарон ши спуне-й: ‘Кынд вей ашеза канделеле ын сфешник, челе шапте канделе вор требуи сэ луминезе ын партя динаинте а сфешникулуй.’” ");
INSERT INTO ron1924_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Аарон а фэкут аша; а ашезат канделеле ын партя динаинте а сфешникулуй, кум порунчисе луй Мойсе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Сфешникул ера де аур бэтут; атыт пичорул, кыт ши флориле луй ерау де аур бэтут. Мойсе фэкусе сфешникул дупэ кипул пе каре и-л арэтасе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","„Я пе левиць дин мижлокул копиилор луй Исраел ши курэцеште-й. ");
INSERT INTO ron1924_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Ятэ кум сэ-й курэцешть: Стропеште-й ку апэ испэшитоаре, сэ ласе сэ трякэ бричул песте тот трупул лор, сэ-шь спеле хайнеле ши сэ се курэцяскэ. ");
INSERT INTO ron1924_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Сэ я апой ун вицел, ку дарул де мынкаре обишнуит, фэкут дин флоаре де фэинэ фрэмынтатэ ку унтделемн, ши сэ май ей ун алт вицел пентру жертфа де испэшире. ");
INSERT INTO ron1924_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Сэ апропий пе левиць ынаинтя кортулуй ынтылнирий ши сэ стрынӂь тоатэ адунаря копиилор луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Сэ апропий пе левиць ынаинтя Домнулуй, ши копиий луй Исраел сэ-шь пунэ мыниле пе левиць. ");
INSERT INTO ron1924_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Аарон сэ леӂене пе левиць ынтр-о парте ши ынтр-алта ынаинтя Домнулуй, ка ун дар легэнат дин партя копиилор луй Исраел, ши сэ фие ынкинаць астфел ын служба Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Левиций сэ-шь пунэ мыниле пе капул вицеилор ши сэ адучь унул ка жертфэ де испэшире ши алтул ка ардере-де-тот, ка сэ фачь испэшире пентру левиць. ");
INSERT INTO ron1924_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Сэ пуй пе левиць ын пичоаре ынаинтя луй Аарон ши ынаинтя фиилор луй ши сэ-й леӂень ынтр-о парте ши ынтр-алта, ка ун дар легэнат Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Аша сэ деспарць пе левиць дин мижлокул копиилор луй Исраел, ши левиций вор фи ай Мей. ");
INSERT INTO ron1924_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Дупэ ачея, левиций сэ винэ сэ факэ служба ын кортул ынтылнирий. Астфел сэ-й курэцешть ши сэ-й леӂень ынтр-о парте ши ынтр-алта, ка ун дар легэнат. ");
INSERT INTO ron1924_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Кэч ей Ымь сунт даць ку тотул дин мижлокул копиилор луй Исраел: Еу й-ам луат пентру Мине ын локул ынтыилор нэскуць, дин тоць ынтыий нэскуць ай копиилор луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Кэч орьче ынтый нэскут ал копиилор луй Исраел есте ал Меу, атыт дин оамень, кыт ши дин добитоаче; Мие Ми й-ам ынкинат ын зиуа кынд ам ловит пе тоць ынтыий нэскуць ын цара Еӂиптулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Ши Еу ам луат пе левиць ын локул тутурор ынтыилор нэскуць ай копиилор луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Ам дат пе левиць ын тотул луй Аарон ши фиилор луй, дин мижлокул копиилор луй Исраел, ка сэ факэ службэ пентру копиий луй Исраел ын кортул ынтылнирий, сэ факэ испэшире пентру копиий луй Исраел, ши астфел копиий луй Исраел сэ ну фие ловиць ку ничо урӂие кынд се вор апропия де Сфынтул Локаш.” ");
INSERT INTO ron1924_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Мойсе, Аарон ши тоатэ адунаря копиилор луй Исраел ау фэкут ку левиций тот че порунчисе луй Мойсе Домнул деспре левиць; аша ау фэкут копиий луй Исраел ку ей. ");
INSERT INTO ron1924_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Левиций с-ау курэцит ши шь-ау спэлат хайнеле. Аарон й-а легэнат ынтр-о парте ши ынтр-алта, ка ун дар легэнат ынаинтя Домнулуй, ши а фэкут испэшире пентру ей, ка сэ-й курэцяскэ. ");
INSERT INTO ron1924_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Дупэ ачея, левиций ау венит сэ-шь факэ служба ын кортул ынтылнирий, ын фаца луй Аарон ши а фиилор луй. Ынтокмай кум порунчисе луй Мойсе Домнул ку привире ла левиць, аша с-а фэкут ку ей. ");
INSERT INTO ron1924_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","„Ятэ леӂя привитоаре ла левиць. Де ла вырста де доуэзечь ши чинч де ань ын сус, орьче левит ва интра ын служба кортулуй ынтылнирий ка сэ ындеплиняскэ о службэ аколо. ");
INSERT INTO ron1924_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Де ла вырста де чинчзечь де ань ынколо, сэ ясэ дин службэ ши сэ ну май служяскэ. ");
INSERT INTO ron1924_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Ва путя сэ ажуте пе фраций луй ын кортул ынтылнирий, сэ пэзяскэ че ле есте дат ын грижэ, дар сэ ну май факэ службэ. Аша сэ фачь ку левиций ын че привеште службеле лор.” ");
INSERT INTO ron1924_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Домнул а ворбит луй Мойсе ын пустиул Синай, ын луна ынтый а анулуй ал дойля дупэ еширя лор дин цара Еӂиптулуй. Ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","„Копиий луй Исраел сэ прэзнуяскэ Паштеле ла время хотэрытэ. ");
INSERT INTO ron1924_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Сэ ле прэзнуиць ла время хотэрытэ, ын а пайспрезечя зи а луний ачестея, сяра; сэ ле прэзнуиць дупэ тоате леӂиле ши дупэ тоате порунчиле привитоаре ла еле.” ");
INSERT INTO ron1924_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Мойсе а ворбит копиилор луй Исраел сэ прэзнуяскэ Паштеле. ");
INSERT INTO ron1924_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Ши ау прэзнуит Паштеле ын а пайспрезечя зи а луний ынтый, сяра, ын пустиул Синай; копиий луй Исраел ау фэкут ынтокмай дупэ тоате порунчиле пе каре ле дэдусе луй Мойсе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","С-а ынтымплат кэ ниште оамень, фиинд некураць дин причинэ кэ се атинсесерэ де ун морт, ну путяу прэзнуи Паштеле ын зиуа ачея. Ей с-ау ынфэцишат ын ачеяшь зи ынаинтя луй Мойсе ши ынаинтя луй Аарон. ");
INSERT INTO ron1924_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Ши оамений ачея ау зис луй Мойсе: „Ной сунтем некураць дин причина унуй морт. Де че сэ фим невоиць сэ ну не адучем ла время хотэрытэ дарул кувенит Домнулуй ын мижлокул копиилор луй Исраел?” ");
INSERT INTO ron1924_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Мойсе ле-а рэспунс: „Аштептаць сэ вэд че вэ порунчеште Домнул.” ");
INSERT INTO ron1924_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Ши Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","„Ворбеште копиилор луй Исраел ши спуне-ле: ‘Дакэ чинева динтре вой сау динтре урмаший воштри есте некурат дин причина унуй морт сау есте ынтр-о кэлэторие лунгэ, тотушь сэ прэзнуяскэ Паштеле ын чинстя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Ши сэ ле прэзнуяскэ ын луна а доуа, ын зиуа а пайспрезечя, сяра; сэ ле мэнынче ку азиме ши ербурь амаре. ");
INSERT INTO ron1924_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Сэ ну ласе дин еле нимик пынэ а доуа зи диминяца ши сэ ну фрынгэ ничун ос дин еле. Сэ ле прэзнуяскэ дупэ тоате порунчиле привитоаре ла Паште. ");
INSERT INTO ron1924_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Дакэ чинева ну есте некурат, нич ну есте ын кэлэторие, ши тотушь ну прэзнуеште Паштеле, суфлетул ачела сэ фие нимичит дин попорул луй, пентру кэ н-а адус дарул кувенит Домнулуй ла время хотэрытэ, омул ачела сэ-шь я педяпса пентру пэкатул луй. ");
INSERT INTO ron1924_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Дакэ ун стрэин каре локуеште ынтре вой прэзнуеште Паштеле Домнулуй, сэ се цинэ де леӂиле ши порунчиле привитоаре ла Паште. Ачеяшь леӂе сэ фие ынтре вой, пентру стрэин, ка ши пентру бэштинаш.’” ");
INSERT INTO ron1924_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Ын зиуа кынд а фост ашезат кортул, норул а акоперит локашул кортулуй ынтылнирий ши, де сяра пынэ диминяца, дясупра кортулуй ера ка ынфэцишаря унуй фок. ");
INSERT INTO ron1924_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Тотдяуна ера аша: зиуа, норул акоперя кортул, яр ноаптя авя ынфэцишаря унуй фок. ");
INSERT INTO ron1924_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Кынд се ридика норул де пе корт, порняу ши копиий луй Исраел; ши аколо унде се опря норул, тэбэрау ши копиий луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Копиий луй Исраел порняу дупэ порунка Домнулуй ши тэбэрау дупэ порунка Домнулуй; тэбэрау атыта време кыт рэмыня норул дясупра кортулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Кынд норул рэмыня май мултэ време дясупра кортулуй, копиий луй Исраел аскултау де порунка Домнулуй ши ну порняу. ");
INSERT INTO ron1924_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Кынд норул рэмыня май пуцине зиле дясупра кортулуй, ей тэбэрау дупэ порунка Домнулуй ши порняу дупэ порунка Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Дакэ норул се опря де сяра пынэ диминяца ши се ридика диминяца, атунч порняу ши ей. Дакэ норул се ридика дупэ о зи ши о ноапте, атунч порняу ши ей. ");
INSERT INTO ron1924_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Дакэ норул се опря дясупра кортулуй доуэ зиле сау о лунэ сау ун ан, копиий луй Исраел рэмыняу тэбэрыць ши ну порняу; ши кынд се ридика, порняу ши ей. ");
INSERT INTO ron1924_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Тэбэрау дупэ порунка Домнулуй ши порняу дупэ порунка Домнулуй; аскултау де порунка Домнулуй, де порунка Домнулуй датэ прин Мойсе. ");
INSERT INTO ron1924_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","„Фэ-ць доуэ трымбице де арӂинт; сэ ле фачь де арӂинт бэтут. Еле сэ-ць служяскэ пентру кемаря адунэрий ши пентру порниря таберелор. ");
INSERT INTO ron1924_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Кынд се ва суна ку еле, тоатэ адунаря сэ се стрынгэ ла тине, ла уша кортулуй ынтылнирий. ");
INSERT INTO ron1924_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Кынд се ва суна нумай ку о трымбицэ, сэ се стрынгэ ла тине кэпетенииле, май-марий песте мииле луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Кынд вець суна ку вылвэ, сэ порняскэ чей че тэбэрэск ла рэсэрит; ");
INSERT INTO ron1924_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","кынд вець суна а доуа оарэ ку вылвэ, сэ порняскэ чей че тэбэрэск ла мязэзи; пентру плекаря лор, сэ се суне ку вылвэ. ");
INSERT INTO ron1924_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Кынд ва фи ворба де стрынӂеря адунэрий, сэ сунаць, дар сэ ну сунаць ку вылвэ. ");
INSERT INTO ron1924_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Дин трымбице сэ суне фиий луй Аарон, преоций. Ачаста сэ фие о леӂе вешникэ пентру вой ши пентру урмаший воштри. ");
INSERT INTO ron1924_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Кынд вець мерӂе ла рэзбой, ын цара воастрэ, ымпотрива врэжмашулуй каре ва лупта ымпотрива воастрэ, сэ сунаць ку вылвэ дин трымбице, ши Домнул Думнезеул востру Ышь ва адуче аминте де вой ши вець фи избэвиць де врэжмаший воштри. ");
INSERT INTO ron1924_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Ын зилеле воастре де букурие, ла сэрбэториле воастре ши ла луниле ной але воастре, сэ сунаць дин трымбице, кынд вэ вець адуче ардериле-де-тот ши жертфеле де мулцумире, ши еле вор фаче ка Думнезеул востру сэ-Шь адукэ аминте де вой. Еу сунт Домнул Думнезеул востру.” ");
INSERT INTO ron1924_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Ын зиуа а доуэзечя а луний а доуа а анулуй ал дойля, с-а ридикат норул де пе кортул ынтылнирий. ");
INSERT INTO ron1924_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Ши копиий луй Исраел ау порнит дин пустиул Синай дупэ табереле лор. Норул с-а оприт ын пустиул Паран. ");
INSERT INTO ron1924_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Ачастэ чя динтый плекаре ау фэкут-о дупэ порунка Домнулуй датэ прин Мойсе. ");
INSERT INTO ron1924_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Ынтый а порнит стягул таберей фиилор луй Иуда, ымпреунэ ку оштириле луй. Песте оштиря луй Иуда ера май-маре Нахшон, фиул луй Аминадаб; ");
INSERT INTO ron1924_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","песте оштиря семинцией фиилор луй Исахар ера Нетанеел, фиул луй Цуар; ");
INSERT INTO ron1924_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","песте оштиря семинцией фиилор луй Забулон ера Елиаб, фиул луй Хелон. ");
INSERT INTO ron1924_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Кынд а фост десфэкут кортул, ау порнит ынтый фиий луй Гершон ши фиий луй Мерари, дукынд кортул. ");
INSERT INTO ron1924_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Апой а порнит стягул таберей луй Рубен, ымпреунэ ку оштириле луй. Песте оштиря луй Рубен ера май-маре Елицур, фиул луй Шедеур; ");
INSERT INTO ron1924_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","песте оштиря семинцией фиилор луй Симеон ера Шелумиел, фиул луй Цуришадай; ");
INSERT INTO ron1924_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","песте оштиря семинцией фиилор луй Гад ера Елиасаф, фиул луй Деуел. ");
INSERT INTO ron1924_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Апой ау порнит кехатиций, дукынд Сфынтул Локаш; пынэ ла вениря лор чейлалць ынтинсесерэ кортул. ");
INSERT INTO ron1924_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Апой а порнит стягул таберей фиилор луй Ефраим, ымпреунэ ку оштириле луй. Песте оштиря луй Ефраим ера май-маре Елишама, фиул луй Амихуд; ");
INSERT INTO ron1924_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","песте оштиря семинцией фиилор луй Манасе ера Гамлиел, фиул луй Педахцур; ");
INSERT INTO ron1924_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","песте оштиря семинцией фиилор луй Бениамин ера Абидан, фиул луй Гидеони. ");
INSERT INTO ron1924_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Апой а порнит стягул таберей фиилор луй Дан, ымпреунэ ку оштириле луй: ей ерау коада тутурор таберелор. Песте оштиря луй Дан ера май-маре Ахиезер, фиул луй Амишадай; ");
INSERT INTO ron1924_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","песте оштиря семинцией фиилор луй Ашер ера Пагуиел, фиул луй Окран; ");
INSERT INTO ron1924_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","песте оштиря семинцией фиилор луй Нефтали ера Ахира, фиул луй Енан. ");
INSERT INTO ron1924_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Ачеста а фост ширул ын каре ау порнит копиий луй Исраел, дупэ оштириле лор; аша ау плекат. ");
INSERT INTO ron1924_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Мойсе а зис луй Хобаб, фиул луй Реуел, Мадианитул, сокрул луй Мойсе: „Ной плекэм спре локул деспре каре Домнул а зис: ‘Еу ви-л вой да.’ Вино ку ной, ши ыць вом фаче бине, кэч Домнул а фэгэдуит кэ ва фаче бине луй Исраел.” ");
INSERT INTO ron1924_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Хобаб й-а рэспунс: „Ну пот сэ мерг, чи мэ вой дуче ын цара мя ши ын локул меу де наштере.” ");
INSERT INTO ron1924_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Ши Мойсе а зис: „Ну не пэрэси, те рог, фииндкэ ту куношть локуриле унде путем сэ тэбэрым ын пустиу, деч ту сэ не фий кэлэузэ. ");
INSERT INTO ron1924_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Ши дакэ вий ку ной, те вом фаче сэ те букурь де бинеле пе каре ни-л ва фаче Домнул.” ");
INSERT INTO ron1924_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Ей ау плекат де ла мунтеле Домнулуй ши ау мерс трей зиле; кивотул легэмынтулуй Домнулуй а порнит ынаинтя лор ши а фэкут ун друм де трей зиле, ка сэ ле кауте ун лок де одихнэ. ");
INSERT INTO ron1924_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Норул Домнулуй ера дясупра лор ын тимпул зилей, кынд порняу дин табэрэ. ");
INSERT INTO ron1924_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Кынд порня кивотул, Мойсе зичя: „Скоалэ-Те, Доамне, ка сэ се ымпрэштие врэжмаший Тэй ши сэ фугэ динаинтя Фецей Тале чей че Те урэск!” ");
INSERT INTO ron1924_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Яр кынд ыл ашезау, зичя: „Ынтоарче-Те, Доамне, ла зечиле де мий але миилор луй Исраел!” ");
INSERT INTO ron1924_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Попорул а кыртит ын гура маре ымпотрива Домнулуй, зикынд кэ-й мерӂе рэу. Кынд а аузит, Домнул С-а мыният. С-а апринс ынтре ей фокул Домнулуй ши а мистуит о парте дин марӂиня таберей. ");
INSERT INTO ron1924_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Попорул а стригат кэтре Мойсе. Мойсе с-а ругат Домнулуй, ши фокул с-а стинс. ");
INSERT INTO ron1924_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Локулуй ачелуя й-ау пус нумеле Табеера, пентру кэ се апринсесе фокул Домнулуй принтре ей. ");
INSERT INTO ron1924_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Адунэтурий де оамень каре се афлау ын мижлокул луй Исраел й-а венит пофтэ, ба кяр ши копиий луй Исраел ау ынчепут сэ плынгэ ши сэ зикэ: „Чине не ва да карне сэ мынкэм? ");
INSERT INTO ron1924_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Не адучем аминте де пештий пе каре-й мынкам ын Еӂипт ши каре ну не костау нимик, де кастравець, де пепень, де пражь, де чапэ ши де устурой. ");
INSERT INTO ron1924_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Акум ни с-а ускат суфлетул: ну май есте нимик! Окий ноштри ну вэд декыт мана ачаста.” ");
INSERT INTO ron1924_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Мана семэна ку грэунтеле де кориандру ши ла ведере ера ка беделионул. ");
INSERT INTO ron1924_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Попорул се рисипя ши о стрынӂя, о мэчина ла рышницэ сау о писа ынтр-о пиуэ; о фербя ын оалэ ши фэчя турте дин еа. Мана авя густул уней турте фэкуте ку унтделемн. ");
INSERT INTO ron1924_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Кынд кэдя роуа ноаптя ын табэрэ, кэдя ши мана. ");
INSERT INTO ron1924_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Мойсе а аузит пе попор плынгынд, фиекаре ын фамилия луй ши ла уша кортулуй луй. Мыния Домнулуй с-а апринс ку тэрие. Мойсе с-а ынтристат ");
INSERT INTO ron1924_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","ши а зис Домнулуй: „Пентру че мыхнешть Ту пе робул Тэу ши пентру че н-ам кэпэтат еу тречере ынаинтя Та, де ай пус песте мине сарчина ачестуй попор ынтрег? ");
INSERT INTO ron1924_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Оаре еу ам зэмислит пе попорул ачеста? Оаре еу л-ам нэскут, ка сэ-мь зичь: ‘Поартэ-л ла сынул тэу, кум поартэ дойка пе копил, пынэ ын цара пе каре ай журат пэринцилор луй кэ й-о вей да’? ");
INSERT INTO ron1924_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Де унде сэ яу карне, ка сэ дау ла тот попорул ачеста? Кэч ей плынг ла мине, зикынд: ‘Дэ-не карне ка сэ мынкэм!’ ");
INSERT INTO ron1924_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Еу сингур ну пот сэ порт пе тот попорул ачеста, кэч есте пря греу пентру мине. ");
INSERT INTO ron1924_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Декыт сэ Те порць аша ку мине, май бине омоарэ-мэ, Те рог, дакэ май ам врео тречере ынаинтя Та, ка сэ ну-мь май вэд ненорочиря.” ");
INSERT INTO ron1924_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Домнул а зис луй Мойсе: „Адунэ ла Мине шаптезечь де бэрбаць, динтре бэтрыний луй Исраел, дин чей пе каре-й куношть ка бэтрынь ай попорулуй ши ку путере асупра лор; аду-й ла кортул ынтылнирий ши сэ се ынфэцишезе аколо ымпреунэ ку тине. ");
INSERT INTO ron1924_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Еу Мэ вой коборы ши ыць вой ворби аколо; вой луа дин духул каре есте песте тине ши-л вой пуне песте ей, ка сэ поарте ымпреунэ ку тине сарчина попорулуй ши сэ н-о порць ту сингур. ");
INSERT INTO ron1924_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Сэ спуй попорулуй: ‘Сфинцици-вэ пентру мыне ши авець сэ мынкаць карне, фииндкэ аць плынс ын аузул Домнулуй ши аць зис: «Чине не ва да карне сэ мынкэм? Кэч ной о дучям бине ын Еӂипт!» Домнул вэ ва да карне ши вець мынка. ");
INSERT INTO ron1924_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Авець сэ мынкаць карне ну о зи, нич доуэ зиле, нич чинч зиле, нич зече зиле, нич доуэзечь де зиле, ");
INSERT INTO ron1924_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","чи о лунэ ынтрягэ, пынэ вэ ва еши пе нэрь ши вэ вець скырби де еа, пентру кэ н-аць аскултат де Домнул каре есте ын мижлокул востру ши пентру кэ аць плынс ынаинтя Луй, зикынд: «Пентру че ам ешит ной оаре дин Еӂипт?»’” ");
INSERT INTO ron1924_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Мойсе а зис: „Шасе суте де мий де оамень каре мерг пе жос алкэтуеск попорул ын мижлокул кэруя сунт еу, ши Ту зичь: ‘Ле вой да карне ши вор мынка о лунэ ынтрягэ!’ ");
INSERT INTO ron1924_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Путем тэя оаре атытя ой ши атыця бой, ка сэ ажунгэ? Сау ну кумва авем сэ приндем тоць пештий мэрий, ка сэ ле ажунгэ?” ");
INSERT INTO ron1924_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Домнул а рэспунс луй Мойсе: „Ну кумва с-а скуртат оаре мына Домнулуй? Вей ведя акум дакэ чея че ць-ам спус се ва ынтымпла сау ну.” ");
INSERT INTO ron1924_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Мойсе а ешит ши а спус попорулуй кувинтеле Домнулуй. А адунат шаптезечь де бэрбаць дин бэтрыний попорулуй ши й-а пус ын журул кортулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Домнул С-а коборыт ын нор ши а ворбит луй Мойсе; а луат дин духул каре ера песте ел ши л-а пус песте чей шаптезечь де бэтрынь. Ши де ындатэ че духул с-а ашезат песте ей, ау ынчепут сэ пророчаскэ, дар дупэ ачея н-ау май пророчит. ");
INSERT INTO ron1924_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Дой оамень, унул нумит Елдад ши алтул Медад, рэмэсесерэ ын табэрэ, ши духул с-а ашезат ши песте ей, кэч ерау динтре чей скришь, мэкар кэ ну се дусесерэ ла корт. Ши ау ынчепут сэ пророчаскэ ши ей ын табэрэ. ");
INSERT INTO ron1924_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Ун тынэр а алергат ши а дат де штире луй Мойсе, зикынд: „Елдад ши Медад пророческ ын табэрэ.” ");
INSERT INTO ron1924_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Ши Иосуа, фиул луй Нун, каре служя луй Мойсе дин тинереця луй, а луат кувынтул ши а зис: „Домнуле Мойсе, опреште-й.” ");
INSERT INTO ron1924_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Мойсе й-а рэспунс: „Ешть ӂелос пентру мине? Сэ дя Думнезеу ка тот попорул Домнулуй сэ фие алкэтуит дин пророчь ши Домнул сэ-Шь пунэ Духул Луй песте ей!” ");
INSERT INTO ron1924_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Апой Мойсе с-а ынторс ын табэрэ, ел ши бэтрыний луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Домнул а фэкут сэ суфле де песте маре ун вынт, каре а адус препелице ши ле-а рэспындит песте табэрэ кале кам де о зи ынтр-о парте ши кале кам де о зи де чялалтэ парте ын журул таберей. Авяу о ынэлциме де апроапе дой коць де ла фаца пэмынтулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Ын тот тимпул зилей ачелея ши тоатэ ноаптя ши тоатэ зиуа урмэтоаре, попорул с-а скулат ши а стрынс препелице; чел че стрынсесе чел май пуцин авя зече омерь. Ей ши ле-ау ынтинс ын журул таберей. ");
INSERT INTO ron1924_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Пе кынд карня ера ынкэ ын динций лор, фэрэ сэ фие местекатэ, Домнул С-а апринс де мыние ымпотрива попорулуй ши Домнул а ловит попорул ку о урӂие фоарте маре. ");
INSERT INTO ron1924_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Ау пус локулуй ачелуя нумеле Киброт-Хатаава, пентру кэ аколо ау ынгропат пе попорул апукат де пофтэ. ");
INSERT INTO ron1924_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Де ла Киброт-Хатаава, попорул а плекат ла Хацерот ши с-а оприт ла Хацерот. ");
INSERT INTO ron1924_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Мария ши Аарон ау ворбит ымпотрива луй Мойсе дин причина фемеий етиопене пе каре о луасе ел де невастэ, кэч луасе о фемее етиопиянэ. ");
INSERT INTO ron1924_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Ши ау зис: „Оаре нумай прин Мойсе ворбеште Домнул? Ну ворбеште оаре ши прин ной?” Ши Домнул а аузит-о. ");
INSERT INTO ron1924_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Мойсе ынсэ ера ун ом фоарте блынд, май блынд декыт орьче ом де пе фаца пэмынтулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Деодатэ, Домнул а зис луй Мойсе, луй Аарон ши Марией: „Дучеци-вэ, кытешьтрей ла кортул ынтылнирий.” Ши с-ау дус кытешьтрей. ");
INSERT INTO ron1924_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Домнул С-а коборыт ын стылпул де нор ши а стат ла уша кортулуй. А кемат пе Аарон ши пе Мария, ши ей с-ау апропият амындой. ");
INSERT INTO ron1924_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Ши а зис: „Аскултаць бине че вэ спун! Кынд ва фи принтре вой ун пророк, Еу, Домнул, Мэ вой дескопери луй ынтр-о ведение сау ый вой ворби ынтр-ун вис. ");
INSERT INTO ron1924_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Ну тот аша есте ынсэ ку робул Меу Мойсе. Ел есте крединчос ын тоатэ каса Мя. ");
INSERT INTO ron1924_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Еу ый ворбеск гурэ кэтре гурэ, Мэ дескопэр луй ну прин лукрурь греу де ынцелес, чи ел веде кипул Домнулуй. Кум де ну в-аць темут деч сэ ворбиць ымпотрива робулуй Меу, ымпотрива луй Мойсе?” ");
INSERT INTO ron1924_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Домнул С-а апринс де мыние ымпотрива лор. Ши а плекат. ");
INSERT INTO ron1924_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Норул с-а депэртат де пе корт. Ши ятэ кэ Мария ера плинэ де лепрэ, албэ ка зэпада. Аарон с-а ынторс спре Мария, ши ятэ кэ еа авя лепрэ. ");
INSERT INTO ron1924_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Атунч Аарон а зис луй Мойсе: „Ах, домнул меу, ну не фаче сэ пуртэм педяпса пэкатулуй пе каре л-ам фэкут ка ниште некибзуиць ши де каре не-ам фэкут виноваць! ");
INSERT INTO ron1924_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Сэ ну фие Мария ка ун копил нэскут морт, а кэруй карне есте пе жумэтате путредэ кынд есе дин пынтечеле мамей луй!” ");
INSERT INTO ron1924_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Мойсе а стригат кэтре Домнул, зикынд: „Думнезеуле, Те рог, виндек-о!” ");
INSERT INTO ron1924_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Ши Домнул а зис луй Мойсе: „Дакэ ар фи скуйпат-о татэл ей ын образ, н-ар фи фост еа оаре де окарэ тимп де шапте зиле? Сэ фие ынкисэ деч шапте зиле афарэ дин табэрэ, дупэ ачея сэ фие примитэ ын табэрэ.” ");
INSERT INTO ron1924_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Мария а фост ынкисэ шапте зиле афарэ дин табэрэ. Ши попорул н-а порнит пынэ че н-а интрат дин ноу Мария ын табэрэ. ");
INSERT INTO ron1924_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Дупэ ачея, попорул а плекат дин Хацерот ши а тэбэрыт ын пустиул Паран. ");
INSERT INTO ron1924_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","„Тримите ниште оамень сэ искодяскэ цара Канаанулуй, пе каре о дау копиилор луй Исраел. Сэ тримиць кыте ун ом пентру фиекаре дин семинцииле пэринцилор лор, тоць сэ фие динтре фрунташий лор.” ");
INSERT INTO ron1924_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Мойсе й-а тримис дин пустиул Паран, дупэ порунка Домнулуй; тоць оамений ачештя ерау кэпетений але копиилор луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Ятэ нумеле лор: пентру семинция луй Рубен: Шамуа, фиул луй Закур; ");
INSERT INTO ron1924_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","пентру семинция луй Симеон: Шафат, фиул луй Хори; ");
INSERT INTO ron1924_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","пентру семинция луй Иуда: Калеб, фиул луй Иефуне; ");
INSERT INTO ron1924_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","пентру семинция луй Исахар: Игуал, фиул луй Иосиф; ");
INSERT INTO ron1924_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","пентру семинция луй Ефраим: Хосея, фиул луй Нун; ");
INSERT INTO ron1924_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","пентру семинция луй Бениамин: Палти, фиул луй Рафу; ");
INSERT INTO ron1924_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","пентру семинция луй Забулон: Гадиел, фиул луй Соди; ");
INSERT INTO ron1924_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","пентру семинция луй Иосиф, семинция луй Манасе: Гади, фиул луй Суси; ");
INSERT INTO ron1924_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","пентру семинция луй Дан: Амиел, фиул луй Гемали; ");
INSERT INTO ron1924_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","пентру семинция луй Ашер: Сетур, фиул луй Микаел; ");
INSERT INTO ron1924_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","пентру семинция луй Нефтали: Нахби, фиул луй Вофси; ");
INSERT INTO ron1924_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","пентру семинция луй Гад: Геуел, фиул луй Маки. ");
INSERT INTO ron1924_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Ачестя сунт нумеле бэрбацилор пе каре й-а тримис Мойсе сэ искодяскэ цара. Луй Хосея, фиул луй Нун, Мойсе й-а пус нумеле Иосуа. ");
INSERT INTO ron1924_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Мойсе й-а тримис сэ искодяскэ цара Канаанулуй. Ел ле-а зис: „Мерӂець де аич спре мязэзи ши апой сэ вэ суиць пе мунте. ");
INSERT INTO ron1924_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Ведець цара, ведець кум есте еа, кум есте попорул каре о локуеште: дакэ есте таре сау слаб, дакэ есте мик сау маре ла нумэр; ");
INSERT INTO ron1924_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","ведець кум есте цара ын каре локуеште: дакэ есте бунэ сау ря; кум сунт четэциле ын каре локуеште: дакэ сунт дескисе сау ынтэрите; ");
INSERT INTO ron1924_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","кум есте пэмынтул: дакэ есте грас сау стерп, дакэ сунт сау ну копачь пе ел. Фиць ку инимэ ши луаць ку вой роаде дин царэ.” Ера пе время кынд ынчеп сэ се коакэ стругурий. ");
INSERT INTO ron1924_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Ей с-ау суит ши ау искодит цара, де ла пустиул Цин пынэ ла Рехоб, пе друмул каре дуче ла Хамат. ");
INSERT INTO ron1924_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","С-ау суит пе ла мязэзи ши ау мерс пынэ ла Хеброн, унде се афлау Ахиман, Шешай ши Талмай, копиий луй Анак. Хебронул фусесе зидит ку шапте ань ынаинте де четатя Цоан дин Еӂипт. ");
INSERT INTO ron1924_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Ау ажунс пынэ ла валя Ешкол. Аколо ау тэят о рамурэ де вицэ ку ун стругуре ши л-ау дус кыте дой ку ажуторул уней прэжинь. Ау луат ши родий ши смокине. ");
INSERT INTO ron1924_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Локул ачела л-ау нумит валя Ешкол дин причина стругурелуй пе каре л-ау тэят де аколо копиий луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","С-ау ынторс де ла искодиря цэрий дупэ патрузечь де зиле ымплините. ");
INSERT INTO ron1924_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Ау плекат ши ау ажунс ла Мойсе ши ла Аарон ши ла тоатэ адунаря копиилор луй Исраел, ла Кадес, ын пустиул Паран. Ле-ау адус штирь, лор ши ынтреӂий адунэрь, ши ле-ау арэтат роаделе цэрий. ");
INSERT INTO ron1924_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Ятэ че ау историсит луй Мойсе: „Не-ам дус ын цара ын каре не-ай тримис. Ку адевэрат, есте о царэ ын каре курӂе лапте ши мьере ши ятэ-й роаделе. ");
INSERT INTO ron1924_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Дар попорул каре локуеште ын цара ачаста есте путерник, четэциле сунт ынтэрите ши фоарте марь. Ба ынкэ ам вэзут аколо ши пе фиий луй Анак. ");
INSERT INTO ron1924_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Амалечиций локуеск цинутул де ла мязэзи; иебусиций ши амориций локуеск мунтеле ши канааниций ши хетиций локуеск лынгэ маре ши де-а лунгул Йорданулуй.” ");
INSERT INTO ron1924_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Калеб а потолит попорул каре кыртя ымпотрива луй Мойсе. Ел а зис: „Хайдем сэ не суим ши сэ пунем мына пе царэ, кэч вом фи бируиторь!” ");
INSERT INTO ron1924_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Дар бэрбаций каре фусесерэ ымпреунэ ку ел ау зис: „Ну путем сэ не суим ымпотрива попорулуй ачестуя, кэч есте май таре декыт ной.” ");
INSERT INTO ron1924_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Ши ау ыннегрит ынаинтя копиилор луй Исраел цара пе каре о искодисерэ. Ей ау зис: „Цара пе каре ам стрэбэтут-о, ка с-о искодим, есте о царэ каре мэнынкэ пе локуиторий ей; тоць ачея пе каре й-ам вэзут аколо сунт оамень де статурэ ыналтэ. ");
INSERT INTO ron1924_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Апой, ам май вэзут ын еа пе уриаший, пе копиий луй Анак, каре се траг дин нямул уриашилор: ынаинтя ноастрэ ши фацэ де ей паркэ ерам ниште лэкусте.” ");
INSERT INTO ron1924_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Тоатэ адунаря а ридикат гласул ши а ынчепут сэ ципе. Ши попорул а плынс ын ноаптя ачея. ");
INSERT INTO ron1924_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Тоць копиий луй Исраел ау кыртит ымпотрива луй Мойсе ши Аарон ши тоатэ адунаря ле-а зис: „Де че н-ом фи мурит ной ын цара Еӂиптулуй сау де че н-ом фи мурит ын пустиул ачеста? ");
INSERT INTO ron1924_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Пентру че не дуче Домнул ын цара ачаста ын каре вом кэдя учишь де сабие, яр невестеле ноастре ши копилаший ноштри вор фи де жаф? Ну есте оаре май бине сэ не ынтоарчем ын Еӂипт?” ");
INSERT INTO ron1924_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Ши ау зис унул алтуя: „Сэ не алеӂем о кэпетение ши сэ не ынтоарчем ын Еӂипт.” ");
INSERT INTO ron1924_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Мойсе ши Аарон ау кэзут ку фаца ла пэмынт ын фаца ынтреӂий адунэрь а копиилор луй Исраел каре ера стрынсэ лаолалтэ. ");
INSERT INTO ron1924_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Ши, динтре чей че искодисерэ цара, Иосуа, фиул луй Нун, ши Калеб, фиул луй Иефуне, шь-ау рупт хайнеле ");
INSERT INTO ron1924_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","ши ау ворбит астфел ынтреӂий адунэрь а копиилор луй Исраел: „Цара пе каре ам стрэбэтут-о ной ка с-о искодим есте о царэ фоарте бунэ, минунатэ. ");
INSERT INTO ron1924_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Дакэ Домнул ва фи биневоитор ку ной, не ва дуче ын цара ачаста ши не-о ва да: есте о царэ ын каре курӂе лапте ши мьере. ");
INSERT INTO ron1924_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Нумай ну вэ рэзврэтиць ымпотрива Домнулуй ши ну вэ темець де оамений дин цара ачея, кэч ый вом мынка. Ей ну май ау ничун сприжин: Домнул есте ку ной, ну вэ темець де ей!” ");
INSERT INTO ron1924_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Тоатэ адунаря ворбя сэ-й учидэ ку петре, кынд слава Домнулуй с-а арэтат песте кортул ынтылнирий, ынаинтя тутурор копиилор луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Ши Домнул а зис луй Мойсе: „Пынэ кынд Мэ ва несокоти попорул ачеста? Пынэ кынд ну ва креде ел ын Мине, ку тоате минуниле пе каре ле фак ын мижлокул луй? ");
INSERT INTO ron1924_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Де ачея ыл вой лови ку чумэ ши-л вой нимичи, дар пе тине те вой фаче ун ням май маре ши май путерник декыт ел.” ");
INSERT INTO ron1924_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Мойсе а зис Домнулуй: „Еӂиптений вор аузи лукрул ачеста, ей, дин мижлокул кэрора ай скос пе попорул ачеста прин путеря Та. ");
INSERT INTO ron1924_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Ши вор спуне локуиторилор цэрий ачелея. Ей штияу кэ Ту, Домнул, ешть ын мижлокул попорулуй ачестуя; кэ Те арэтай ын кип вэзут, Ту, Домнул; кэ норул Тэу стэ песте ел; кэ Ту мерӂь ынаинтя луй зиуа ынтр-ун стылп де нор ши ноаптя ынтр-ун стылп де фок. ");
INSERT INTO ron1924_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Дакэ оморь пе попорул ачеста ка пе ун сингур ом, нямуриле каре ау аузит ворбинду-се де Тине вор зиче: ");
INSERT INTO ron1924_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Домнул н-авя путере сэ дукэ пе попорул ачеста ын цара пе каре журасе кэ й-о ва да, де ачея л-а оморыт ын пустиу!’ ");
INSERT INTO ron1924_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Акум, сэ се арате путеря Домнулуй ын мэримя ей, кум ай спус кынд ай зис: ");
INSERT INTO ron1924_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Домнул есте ынчет ла мыние ши богат ын бунэтате, яртэ фэрэделеӂя ши рэзврэтиря, дар ну цине пе чел виноват дрепт невиноват ши педепсеште фэрэделеӂя пэринцилор ын копий пынэ ла ал трейля ши ла ал патруля ням.’ ");
INSERT INTO ron1924_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Яртэ дар фэрэделеӂя попорулуй ачестуя, дупэ мэримя ындурэрий Тале, кум ай ертат попорулуй ачестуя дин Еӂипт пынэ аич.” ");
INSERT INTO ron1924_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Ши Домнул а спус: „Ерт, кум ай черут. ");
INSERT INTO ron1924_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Дар кыт есте де адевэрат кэ Еу сунт виу ши кэ слава Домнулуй ва умпле тот пэмынтул, ");
INSERT INTO ron1924_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","атыт есте де адевэрат кэ тоць чей че ау вэзут ку окий лор слава Мя ши минуниле пе каре ле-ам фэкут ын Еӂипт ши ын пустиу, ши тотушь М-ау испитит де зече орь акум ши н-ау аскултат гласул Меу, ");
INSERT INTO ron1924_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","тоць ачея ну вор ведя цара пе каре ам журат пэринцилор лор кэ ле-о вой да, ши ануме тоць чей че М-ау несокотит н-о вор ведя. ");
INSERT INTO ron1924_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Яр пентру кэ робул Меу Калеб а фост ынсуфлецит де ун алт дух ши а урмат ын тотул каля Мя, ыл вой фаче сэ интре ын цара ын каре с-а дус ши урмаший луй о вор стэпыни. ");
INSERT INTO ron1924_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Амалечиций ши канааниций локуеск валя ачаста, деч мыне, ынтоарчеци-вэ ши плекаць ын пустиу, пе каля каре дуче спре Маря Рошие.” ");
INSERT INTO ron1924_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Домнул а ворбит луй Мойсе ши луй Аарон ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","„Пынэ кынд вой лэса ачастэ ря адунаре сэ кыртяскэ ымпотрива Мя? Ам аузит кыртириле копиилор луй Исраел, каре кыртяу ымпотрива Мя. ");
INSERT INTO ron1924_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Спуне-ле: ‘Пе вяца Мя’, зиче Домнул, ‘кэ вэ вой фаче ынтокмай кум аць ворбит ын аузул урекилор Меле! ");
INSERT INTO ron1924_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Трупуриле воастре моарте вор кэдя ын пустиул ачеста. Вой тоць, а кэрор нумэрэтоаре с-а фэкут нумэрынду-вэ де ла вырста де доуэзечь де ань ын сус ши каре аць кыртит ымпотрива Мя, ");
INSERT INTO ron1924_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","ну вець интра ын цара пе каре журасем кэ вэ вой да-о с-о локуиць, афарэ де Калеб, фиул луй Иефуне, ши Иосуа, фиул луй Нун. ");
INSERT INTO ron1924_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Пе копилаший воштри ынсэ, деспре каре аць зис кэ вор фи де жаф, ый вой фаче сэ интре ын еа, ка сэ куноаскэ цара пе каре аць несокотит-о вой. ");
INSERT INTO ron1924_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Яр кыт деспре вой, трупуриле воастре моарте вор кэдя ын пустиу. ");
INSERT INTO ron1924_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Ши копиий воштри вор рэтэчи патрузечь де ань ын пустиу ши вор испэши астфел пэкателе воастре, пынэ че тоате трупуриле воастре моарте вор кэдя ын пустиу. ");
INSERT INTO ron1924_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Дупэ кум ын патрузечь де зиле аць искодит цара, тот аша, патрузечь де ань вець пурта педяпса фэрэделеӂилор воастре, адикэ ун ан де фиекаре зи, ши вець шти атунч че ынсямнэ сэ-Мь траг Еу мына де ла вой. ");
INSERT INTO ron1924_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Еу, Домнул, ам ворбит! Ын адевэр, аша вой фаче ачестей реле адунэрь, каре с-а унит ымпотрива Мя; вор фи нимичиць ын пустиул ачеста ши ын ел вор мури.’” ");
INSERT INTO ron1924_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Бэрбаций пе каре ый тримисесе Мойсе сэ искодяскэ цара ши каре, ла ынтоарчеря лор, фэкусерэ ка тоатэ адунаря сэ кыртяскэ ымпотрива луй, ыннегринд цара, ");
INSERT INTO ron1924_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","оамений ачештя, каре ыннегрисерэ цара, ау мурит аколо, ынаинтя Домнулуй, ловиць де о моарте нэпрасникэ. ");
INSERT INTO ron1924_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Нумай Иосуа, фиул луй Нун, ши Калеб, фиул луй Иефуне, ау рэмас ку вяцэ динтре оамений ачея каре се дусесерэ сэ искодяскэ цара. ");
INSERT INTO ron1924_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Мойсе а спус ачесте лукрурь тутурор копиилор луй Исраел, ши попорул а фост ынтр-о маре жале. ");
INSERT INTO ron1924_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","С-ау скулат дис-де-диминяцэ а доуа зи ши с-ау суит пе вырфул мунтелуй, зикынд: „Ятэ-не! Сунтем гата сэ не суим ын локул де каре а ворбит Домнул, кэч ам пэкэтуит.” ");
INSERT INTO ron1924_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Мойсе а зис: „Пентру че кэлкаць порунка Домнулуй? Ну вець избути. ");
INSERT INTO ron1924_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Ну вэ суиць, кэч Домнул ну есте ын мижлокул востру! Ну кэутаць сэ фиць бэтуць де врэжмаший воштри. ");
INSERT INTO ron1924_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Кэч амалечиций ши канааниций сунт ынаинтя воастрэ ши вець кэдя учишь де сабие; одатэ че в-аць абэтут де ла Домнул, Домнул ну ва фи ку вой.” ");
INSERT INTO ron1924_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Ей с-ау ындэрэтничит ши с-ау суит пе вырфул мунтелуй, дар кивотул легэмынтулуй ши Мойсе н-ау ешит дин мижлокул таберей. ");
INSERT INTO ron1924_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Атунч с-ау коборыт амалечиций ши канааниций каре локуяу пе мунтеле ачела, й-ау бэтут ши й-ау тэят ын букэць пынэ ла Хорма. ");
INSERT INTO ron1924_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","„Ворбеште копиилор луй Исраел ши спуне-ле: ‘Кынд вець интра ын цара пе каре в-о дау ка сэ вэ ашезаць локуинцеле ын еа ");
INSERT INTO ron1924_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","ши вець адуче Домнулуй о жертфэ мистуитэ де фок, фие о ардере-де-тот, фие о жертфэ адусэ пентру ымплиниря уней журуинце сау ка дар де бунэвое сау ла сэрбэториле воастре, ка сэ фачець дин чирезиле сау турмеле воастре ун мирос плэкут Домнулуй, ");
INSERT INTO ron1924_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","чел че ышь ва адуче дарул сэу Домнулуй сэ адукэ Домнулуй ка дар де мынкаре а зечя парте динтр-о ефэ де флоаре де фэинэ фрэмынтатэ ынтр-ун сферт де хин де унтделемн, ");
INSERT INTO ron1924_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","яр вин пентру жертфа де бэутурэ ла ардеря-де-тот сау ла жертфэ, сэ адукэ ун сферт де хин де фиекаре мел. ");
INSERT INTO ron1924_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Пентру ун бербек, сэ адучь ка дар де мынкаре доуэ зечимь де ефэ дин флоаря фэиний фрэмынтатэ ынтр-о треиме де хин де унтделемн ");
INSERT INTO ron1924_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","ши сэ фачь о жертфэ де бэутурэ де о треиме де хин де вин, ка дар де мынкаре де ун мирос плэкут Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Дакэ адучь ун вицел, фие ка ардере-де-тот, фие ка жертфэ пентру ымплиниря уней журуинце сау ка жертфэ де мулцумире Домнулуй, ");
INSERT INTO ron1924_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","сэ адучь ка дар де мынкаре, ымпреунэ ку вицелул, трей зечимь де ефэ дин флоаря фэиний фрэмынтатэ ынтр-о жумэтате де хин де унтделемн ");
INSERT INTO ron1924_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","ши сэ фачь о жертфэ де бэутурэ де о жумэтате де хин де вин: ачаста есте о жертфэ мистуитэ де фок, де ун мирос плэкут Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Аша сэ се факэ пентру фиекаре боу, пентру фиекаре бербек, пентру фиекаре мел сау ед. ");
INSERT INTO ron1924_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Дупэ нумэрул вителор, аша сэ фачець пентру фиекаре, дупэ нумэрул лор. ");
INSERT INTO ron1924_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Аша сэ факэ лукруриле ачестя орьче бэштинаш кынд ва адуче о жертфэ мистуитэ де фок, де ун мирос плэкут Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Дакэ ун стрэин каре локуеште ла вой сау каре се ва гэси ын виитор ын мижлокул востру адуче о жертфэ мистуитэ де фок, де ун мирос плэкут Домнулуй, с-о адукэ ын ачелашь фел ка вой. ");
INSERT INTO ron1924_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Сэ фие о сингурэ леӂе пентру тоатэ адунаря, атыт пентру вой, кыт ши пентру стрэинул каре локуеште ын мижлокул востру; ачаста сэ фие о леӂе некурматэ принтре урмаший воштри: ку стрэинул сэ фие ка ши ку вой ынаинтя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","О сингурэ леӂе ши о сингурэ порункэ сэ фие атыт пентру вой, кыт ши пентру стрэинул каре локуеште принтре вой.’” ");
INSERT INTO ron1924_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","„Ворбеште копиилор луй Исраел ши спуне-ле: ‘Кынд вець интра ын цара ын каре вэ вой дуче ");
INSERT INTO ron1924_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","ши кынд вець мынка пыне дин цара ачея, сэ луаць ынтый ун дар ридикат пентру Домнул. ");
INSERT INTO ron1924_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Ка дар ридикат, сэ адучець о туртэ дин пырга плэмэделий воастре; с-о адучець кум адучець дарул каре се я ынтый дин арие. ");
INSERT INTO ron1924_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Дин пырга плэмэделий воастре сэ луаць ынтый ун дар ридикат пентру Домнул дин ням ын ням. ");
INSERT INTO ron1924_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Дакэ пэкэтуиць фэрэ вое ши ну пэзиць тоате порунчиле пе каре ле-а фэкут куноскуте луй Мойсе Домнул, ");
INSERT INTO ron1924_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","тот че в-а порунчит Домнул прин Мойсе, дин зиуа кынд а дат Домнул порунчь ши май тырзиу дин ням ын ням, ");
INSERT INTO ron1924_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","дакэ пэкатул а фост фэкут фэрэ вое ши фэрэ сэ штие адунаря, тоатэ адунаря сэ адукэ ун вицел ка ардере-де-тот, де ун мирос плэкут Домнулуй, ымпреунэ ку дарул сэу де мынкаре ши ку жертфа са де бэутурэ, дупэ рындуелиле ашезате; сэ май адукэ ши ун цап ка жертфэ де испэшире. ");
INSERT INTO ron1924_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Преотул сэ факэ испэшире пентру тоатэ адунаря копиилор луй Исраел ши ли се ва ерта, кэч ау пэкэтуит фэрэ вое ши шь-ау адус дарул лор: о жертфэ мистуитэ де фок ын чинстя Домнулуй ши о жертфэ де испэшире ынаинтя Домнулуй пентру пэкатул пе каре л-ау сэвыршит фэрэ вое. ");
INSERT INTO ron1924_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Се ва ерта ынтреӂий адунэрь а копиилор луй Исраел ши стрэинулуй каре локуеште ын мижлокул лор, кэч тот попорул а пэкэтуит фэрэ вое. ");
INSERT INTO ron1924_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Дакэ унул сингур а пэкэтуит фэрэ вое, сэ адукэ о капрэ де ун ан ка жертфэ пентру пэкат. ");
INSERT INTO ron1924_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Преотул сэ факэ испэшире пентру чел че а пэкэтуит фэрэ вое ынаинтя Домнулуй; кынд ва фаче испэшире пентру ел, и се ва ерта. ");
INSERT INTO ron1924_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Атыт пентру бэштинашул динтре копиий луй Исраел, кыт ши пентру стрэинул каре локуеште ын мижлокул лор, сэ фие ачеяшь леӂе, кынд ва пэкэтуи фэрэ вое. ");
INSERT INTO ron1924_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Дар, дакэ чинева, фие бэштинаш, фие стрэин, пэкэтуеште ку вое, хулеште пе Домнул, ачела ва фи нимичит дин мижлокул попорулуй сэу, ");
INSERT INTO ron1924_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","кэч а несокотит Кувынтул Домнулуй ши а кэлкат порунка Луй; ва фи нимичит ши ышь ва луа астфел педяпса пентру нелеӂюиря луй.’” ");
INSERT INTO ron1924_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Кынд ерау копиий луй Исраел ын пустиу, ау гэсит пе ун ом стрынгынд лемне ын зиуа Сабатулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Чей че-л гэсисерэ стрынгынд лемне л-ау адус ла Мойсе, ла Аарон ши ла тоатэ адунаря. ");
INSERT INTO ron1924_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Л-ау арункат ын темницэ, кэч ну се спусесе че требуяу сэ-й факэ. ");
INSERT INTO ron1924_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Домнул а зис луй Мойсе: „Омул ачеста сэ фие педепсит ку моартя, тоатэ адунаря сэ-л учидэ ку петре афарэ дин табэрэ.” ");
INSERT INTO ron1924_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Тоатэ адунаря л-а скос афарэ дин табэрэ ши л-а учис ку петре; ши а мурит, кум порунчисе луй Мойсе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Домнул а зис луй Мойсе: ");
INSERT INTO ron1924_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","„Ворбеште копиилор луй Исраел ши спуне-ле сэ-шь факэ, дин ням ын ням, ун чукуре ла колцуриле вешминтелор лор ши сэ пунэ ун фир албастру песте чукуреле ачеста дин колцуриле вешминтелор. ");
INSERT INTO ron1924_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Кынд вець авя чукуреле ачеста, сэ вэ уйтаць ла ел ши сэ вэ адучець аминте де тоате порунчиле Домнулуй, ка сэ ле ымплиниць ши сэ ну урмаць дупэ пофтеле инимилор воастре ши дупэ пофтеле окилор воштри, ка сэ вэ лэсаць тырыць ла курвие. ");
INSERT INTO ron1924_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Сэ вэ адучець астфел аминте де порунчиле Меле, сэ ле ымплиниць ши сэ фиць сфинць пентру Думнезеул востру. ");
INSERT INTO ron1924_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Еу сунт Домнул Думнезеул востру, каре в-ам скос дин цара Еӂиптулуй, ка сэ фиу Думнезеул востру.” ");
INSERT INTO ron1924_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Коре, фиул луй Ицехар, фиул луй Кехат, фиул луй Леви, с-а рэскулат ымпреунэ ку Датан ши Абирам, фиий луй Елиаб ши Он, фиул луй Пелет, кытешьтрей фиий луй Рубен. ");
INSERT INTO ron1924_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","С-ау рэскулат ымпотрива луй Мойсе, ымпреунэ ку доуэ суте чинчзечь де оамень дин копиий луй Исраел, дин фрунташий адунэрий, дин чей че ерау кемаць ла сфат ши каре ерау оамень ку нуме. ");
INSERT INTO ron1924_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Ей с-ау адунат ымпотрива луй Мойсе ши Аарон ши ле-ау зис: „Дестул! Кэч тоатэ адунаря, тоць сунт сфинць ши Домнул есте ын мижлокул лор. Пентру че вэ ридикаць вой май пресус де адунаря Домнулуй?” ");
INSERT INTO ron1924_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Кынд а аузит Мойсе лукрул ачеста, а кэзут ку фаца ла пэмынт. ");
INSERT INTO ron1924_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","А ворбит луй Коре ши ла тоатэ чата луй ши а зис: „Мыне, Домнул ва арэта чине есте ал Луй ши чине есте сфынт ши-л ва лэса сэ се апропие де Ел; ва лэса сэ се апропие де Ел пе ачела пе каре-л ва алеӂе. ");
INSERT INTO ron1924_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Ятэ че сэ фачець. Луаць кэделнице, Коре ши тоатэ чата луй. ");
INSERT INTO ron1924_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","Мыне, пунець фок ын еле ши пунець тэмые пе ел ынаинтя Домнулуй. Ачела пе каре-л ва алеӂе Домнул ва фи сфынт. Дестул, копиий луй Леви!” ");
INSERT INTO ron1924_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Мойсе а зис луй Коре: „Аскултаць дар, копиий луй Леви! ");
INSERT INTO ron1924_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Пря пуцин лукру есте оаре пентру вой кэ Думнезеул луй Исраел в-а алес дин адунаря луй Исраел, лэсынду-вэ сэ вэ апропияць де Ел, ка сэ фиць ынтребуинцаць ла служба кортулуй Домнулуй ши сэ вэ ынфэцишаць ынаинтя адунэрий ка сэ-й служиць? ");
INSERT INTO ron1924_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","В-а лэсат сэ вэ апропияць де Ел, пе тине ши пе тоць фраций тэй, пе копиий луй Леви, ши акум май воиць ши преоция! ");
INSERT INTO ron1924_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Де ачея те адунь ту ши чата та ымпотрива Домнулуй! Кэч чине есте Аарон, ка сэ кыртиць ымпотрива луй?” ");
INSERT INTO ron1924_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Мойсе а тримис сэ кеме пе Датан ши пе Абирам, фиий луй Елиаб. Дар ей ау зис: „Ну не суим. ");
INSERT INTO ron1924_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Н-ажунӂе кэ не-ай скос динтр-о царэ унде курӂе лапте ши мьере ка сэ не фачь сэ мурим ын пустиу, де врей сэ май ши стэпынешть песте ной? ");
INSERT INTO ron1924_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Че бине не-ай май дус ынтр-о царэ унде курӂе лапте ши мьере ши че бине не-ай май дат ын стэпынире огоаре ши вий! Крезь кэ поць сэ ей окий оаменилор? Ну не суим!” ");
INSERT INTO ron1924_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Мойсе с-а мыният фоарте таре ши а зис Домнулуй: „Ну кэута ла дарул лор. Ну ле-ам луат нич мэкар ун мэгар ши н-ам фэкут рэу ничунуя дин ей.” ");
INSERT INTO ron1924_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Мойсе а зис луй Коре: „Ту ши тоатэ чата та мыне сэ фиць ынаинтя Домнулуй, ту ши ей, ымпреунэ ку Аарон. ");
INSERT INTO ron1924_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Луаци-вэ фиекаре кэделница, пунець тэмые ын еа ши адучець фиекаре ынаинтя Домнулуй кэделница луй: доуэ суте чинчзечь де кэделнице, ту ши Аарон; сэ вэ луаць ши вой фиекаре кэделница луй.” ");
INSERT INTO ron1924_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Шь-ау луат, фиекаре, кэделница, ау пус фок ын еа, ау пус тэмые ын фок ши ау стат ла уша кортулуй ынтылнирий, ымпреунэ ку Мойсе ши Аарон. ");
INSERT INTO ron1924_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Ши Коре а кемат тоатэ адунаря ымпотрива луй Мойсе ши Аарон, ла уша кортулуй ынтылнирий. Атунч, слава Домнулуй с-а арэтат ынтреӂий адунэрь. ");
INSERT INTO ron1924_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Ши Домнул а ворбит луй Мойсе ши луй Аарон ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","„Деспэрцици-вэ дин мижлокул ачестей адунэрь ши-й вой топи ынтр-о клипэ.” ");
INSERT INTO ron1924_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Ей ау кэзут ку фецеле ла пэмынт ши ау зис: „Думнезеуле, Думнезеул духурилор орькэруй труп! Ун сингур ом а пэкэтуит, ши сэ Те мыний ымпотрива ынтреӂий адунэрь?” ");
INSERT INTO ron1924_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","„Ворбеште адунэрий ши спуне-й: ‘Даци-вэ ла о парте дин пряжма локуинцей луй Коре, Датан ши Абирам!’” ");
INSERT INTO ron1924_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Мойсе с-а скулат ши с-а дус ла Датан ши Абирам; ши бэтрыний луй Исраел ау мерс дупэ ел. ");
INSERT INTO ron1924_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","А ворбит адунэрий ши а зис: „Депэртаци-вэ де кортуриле ачестор оамень рэй ши ну вэ атинӂець де нимик дин че есте ал лор, ка сэ ну периць одатэ ку педепсиря лор пентру тоате пэкателе лор.” ");
INSERT INTO ron1924_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Ей с-ау депэртат дин пряжма локуинцей луй Коре, Датан ши Абирам. Датан ши Абирам ау ешит афарэ ши ау стат ла уша кортурилор лор, ку невестеле, копиий ши прунчий лор. ");
INSERT INTO ron1924_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Мойсе а зис: „Ятэ кум вець куноаште кэ Домнул м-а тримис сэ фак тоате ачесте лукрурь ши кэ ну лукрез дин капул меу. ");
INSERT INTO ron1924_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Дакэ оамений ачештя вор мури кум мор тоць оамений ши дакэ вор авя ачеяшь соартэ ка тоць оамений, ну м-а тримис Домнул, ");
INSERT INTO ron1924_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","дар дакэ Домнул ва фаче ун лукру немайаузит, дакэ пэмынтул ышь ва дескиде гура ка сэ-й ынгитэ ку тот че ау, аша ынкыт се вор коборы де вий ын Локуинца морцилор, атунч вець шти кэ оамений ачештя ау хулит пе Домнул.” ");
INSERT INTO ron1924_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Пе кынд испрэвя ел де спус тоате ачесте ворбе, пэмынтул де суб ей с-а деспикат ын доуэ. ");
INSERT INTO ron1924_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Пэмынтул шь-а дескис гура ши й-а ынгицит, пе ей ши каселе лор, ымпреунэ ку тоць оамений луй Коре ши тоате авериле лор. ");
INSERT INTO ron1924_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Ши с-ау коборыт астфел де вий ын Локуинца морцилор, ей ши тот че авяу; пэмынтул й-а акоперит де тот ши ау перит дин мижлокул адунэрий. ");
INSERT INTO ron1924_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Тот Исраелул каре ера ын журул лор, кынд ау ципат ей, а фуӂит, кэч зичяу: „Сэ фуӂим ка сэ ну не ынгитэ пэмынтул!” ");
INSERT INTO ron1924_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Ун фок а ешит де ла Домнул ши а мистуит пе чей доуэ суте чинчзечь де оамень каре адучяу тэмыя. ");
INSERT INTO ron1924_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","„Спуне луй Елеазар, фиул преотулуй Аарон, сэ скоатэ кэделницеле дин фок ши сэ лепеде фокул дин еле, кэч сунт сфинците. ");
INSERT INTO ron1924_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Ку кэделницеле ачестор оамень каре ау пэкэтуит ши ау испэшит пэкатул ку вяца лор сэ се факэ ниште плэчь ынтинсе, ку каре сэ се акопере алтарул. Фииндкэ ау фост адусе ынаинтя Домнулуй ши сунт сфинците, сэ служяскэ де адучере аминте копиилор луй Исраел.” ");
INSERT INTO ron1924_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Преотул Елеазар а луат кэделницеле де арамэ пе каре ле адусесерэ чей аршь ши а фэкут дин еле ниште плэчь пентру акопериря алтарулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Ачеста есте ун семн де адучере аминте пентру копиий луй Исраел, пентру ка ничун стрэин каре ну есте дин нямул луй Аарон сэ ну се апропие сэ адукэ тэмые ынаинтя Домнулуй ши сэ ну и се ынтымпле ка луй Коре ши четей луй, дупэ кум спусесе Домнул прин Мойсе. ");
INSERT INTO ron1924_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","А доуа зи, тоатэ адунаря копиилор луй Исраел а кыртит ымпотрива луй Мойсе ши ымпотрива луй Аарон, зикынд: „Вой аць оморыт пе попорул Домнулуй!” ");
INSERT INTO ron1924_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Пе кынд се стрынӂя адунаря ымпотрива луй Мойсе ши ымпотрива луй Аарон ши пе кынд ышь ындрептау привириле спре кортул ынтылнирий, ятэ кэ л-а акоперит норул ши с-а арэтат слава Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Атунч, Мойсе ши Аарон ау венит ынаинтя кортулуй ынтылнирий. ");
INSERT INTO ron1924_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Ши Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","„Даци-вэ ла о парте дин мижлокул ачестей адунэрь ши-й вой топи ынтр-о клипэ!” Ей ау кэзут ку фецеле ла пэмынт; ");
INSERT INTO ron1924_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","ши Мойсе а зис луй Аарон: „Я кэделница, пуне фок ын еа де пе алтар, пуне тэмые ын еа, ду-те репеде ла адунаре ши фэ испэшире пентру ей, кэч а избукнит мыния Домнулуй ши а ынчепут урӂия.” ");
INSERT INTO ron1924_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Аарон а луат кэделница, кум зисесе Мойсе, ши а алергат ын мижлокул адунэрий ши ятэ кэ ынчепусе урӂия принтре попор. Ел а тэмыят ши а фэкут испэшире пентру нород. ");
INSERT INTO ron1924_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","С-а ашезат ынтре чей морць ши ынтре чей вий, ши урӂия а ынчетат. ");
INSERT INTO ron1924_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Пайспрезече мий шапте суте де иншь ау мурит де урӂия ачаста, афарэ де чей че мурисерэ дин причина луй Коре. ");
INSERT INTO ron1924_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Аарон с-а ынторс ла Мойсе, ла уша кортулуй ынтылнирий. Урӂия ынчетасе. ");
INSERT INTO ron1924_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","„Ворбеште копиилор луй Исраел ши я де ла ей ун тояг, дупэ каселе пэринцилор лор, адикэ доуэспрезече тоеӂе дин партя кэпетениилор лор, дупэ каселе пэринцилор лор. Сэ скрий нумеле фиекэруя пе тоягул луй; ");
INSERT INTO ron1924_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","ши сэ скрий нумеле луй Аарон пе тоягул луй Леви, кэч ва фи кыте ун тояг де фиекаре кэпетение а каселор пэринцилор лор. ");
INSERT INTO ron1924_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Сэ ле пуй ын кортул ынтылнирий, ынаинтя мэртурией, унде Мэ ынтылнеск ку вой. ");
INSERT INTO ron1924_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Бэрбатул пе каре-л вой алеӂе ва фи ачела ал кэруй тояг ва ынфлори, ши вой пуне капэт динаинтя Мя кыртирилор пе каре ле ридикэ ымпотрива воастрэ копиий луй Исраел.” ");
INSERT INTO ron1924_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Мойсе а ворбит копиилор луй Исраел, ши тоате кэпетенииле лор й-ау дат кыте ун тояг; фиекаре кэпетение кыте ун тояг, дупэ каселе пэринцилор лор, адикэ доуэспрезече тоеӂе. Тоягул луй Аарон ера ын мижлокул тоеӂелор лор. ");
INSERT INTO ron1924_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Мойсе а пус тоеӂеле ынаинтя Домнулуй, ын кортул мэртурией. ");
INSERT INTO ron1924_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","А доуа зи, кынд а интрат Мойсе ын кортул мэртурией, ятэ кэ тоягул луй Аарон, каре ера пентру каса луй Леви, ынверзисе, фэкусе мугурь, ынфлорисе ши копсесе мигдале. ");
INSERT INTO ron1924_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Мойсе а луат динаинтя Домнулуй тоате тоеӂеле ши ле-а дус тутурор копиилор луй Исраел, ка сэ ле вадэ ши сэ-шь я фиекаре тоягул луй. ");
INSERT INTO ron1924_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Домнул а зис луй Мойсе: „Пуне тоягул луй Аарон ынапой ынаинтя мэртурией ши сэ фие пэстрат ка ун семн пентру чей рэзврэтиць, ка сэ пуй астфел капэт ынаинтя Мя кыртирилор лор ши сэ ну моарэ.” ");
INSERT INTO ron1924_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Мойсе а фэкут аша; а фэкут ынтокмай дупэ порунка пе каре й-о дэдусе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Копиий луй Исраел ау зис луй Мойсе: „Ятэ кэ мурим, перим, перим ку тоций! ");
INSERT INTO ron1924_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Орьчине се апропие де кортул Домнулуй моаре. Ва требуи оаре сэ мурим ку тоций?” ");
INSERT INTO ron1924_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Домнул а зис луй Аарон: „Ту ши фиий тэй ши каса татэлуй тэу ку тине сэ пуртаць педяпса фэрэделеӂилор фэкуте ын Сфынтул Локаш; ту ши фиий тэй ымпреунэ ку тине сэ пуртаць педяпса фэрэделеӂилор фэкуте ын ымплиниря службей воастре преоцешть. ");
INSERT INTO ron1924_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Апропие, де асеменя, де тине пе фраций тэй, семинция луй Леви, семинция татэлуй тэу, ка сэ фие легаць де тине ши сэ-ць служяскэ атунч кынд ту ши фиий тэй ымпреунэ ку тине вець фи ынаинтя кортулуй ынтылнирий. ");
INSERT INTO ron1924_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Ей сэ пэзяскэ че ле вей порунчи ту ши челе привитоаре ла тот кортул, дар сэ ну се апропие нич де унелтеле Сфынтулуй Локаш, нич де алтар, ка сэ ну муриць, ши ей, ши вой. ");
INSERT INTO ron1924_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Ей сэ се алипяскэ де тине ши сэ пэзяскэ тот че привеште кортул ынтылнирий пентру тоатэ служба кортулуй. Ничун стрэин сэ ну се апропие де вой. ");
INSERT INTO ron1924_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Сэ пэзиць челе привитоаре ла Сфынтул Локаш ши алтар, ка сэ ну май фие мыние ымпотрива копиилор луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Ятэ кэ ам луат пе фраций воштри левиций дин мижлокул копиилор луй Исраел, ка уний каре сунт даць Домнулуй; ей вэ сунт ынкрединцаць воуэ ын дар, ка сэ факэ служба кортулуй ынтылнирий. ");
INSERT INTO ron1924_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Ту ши фиий тэй ымпреунэ ку тине сэ пэзиць службеле преоцией воастре ын тот че привеште алтарул ши тот че есте динколо де пердяуа динэунтру: ачаста есте служба пе каре о вець фаче. Вэ дау ын дар служба преоцией. Стрэинул каре се ва апропия ва фи оморыт.” ");
INSERT INTO ron1924_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Домнул а зис луй Аарон: „Ятэ, дин тоате лукруриле пе каре Ми ле ынкинэ копиий луй Исраел, ыць дау пе челе каре Ымь сунт адусе прин ридикаре; ци ле дау цие ши фиилор тэй ка дрепт ал унӂерий, принтр-о леӂе вешникэ. ");
INSERT INTO ron1924_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Ятэ че ва фи ал тэу динтре лукруриле прясфинте каре ну сунт мистуите де фок: тоате даруриле дин жертфеле лор де мынкаре, тоате жертфеле лор де испэшире ши тоате жертфеле пентру винэ пе каре Ми ле вор адуче; лукруриле ачестя прясфинте сэ фие але тале ши але фиилор тэй. ");
INSERT INTO ron1924_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Сэ ле мынкаць ынтр-ун лок прясфынт; орьче бэрбат сэ мэнынче дин еле; сэ ле привиць ка сфинте. ");
INSERT INTO ron1924_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Ятэ че ва май фи ал тэу: тоате даруриле пе каре ле вор адуче копиий луй Исраел прин ридикаре ши легэнынду-ле ынтр-о парте ши ын алта ци ле дау цие, фиилор тэй ши фийчелор тале ымпреунэ ку тине, принтр-о леӂе вешникэ. Орьчине ва фи курат ын каса та сэ мэнынче дин еле. ");
INSERT INTO ron1924_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Ыць дау челе динтый роаде пе каре ле вор адуче Домнулуй: тот че ва фи май бун дин унтделемн, тот че ва фи май бун дин муст ши грыу. ");
INSERT INTO ron1924_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Челе динтый роаде але пэмынтулуй лор пе каре ле вор адуче Домнулуй сэ фие але тале. Орьчине ва фи курат ын каса та сэ мэнынче дин еле. ");
INSERT INTO ron1924_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Тот че ва фи ынкинат Домнулуй прин фэгэдуинцэ ын Исраел сэ фие ал тэу. ");
INSERT INTO ron1924_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Орьче ынтый нэскут дин орьче труп пе каре-л вор адуче Домнулуй, атыт дин оамень, кыт ши дин добитоаче, сэ фие ал тэу. Нумай сэ лашь сэ се рэскумпере ынтыюл нэскут ал омулуй ши сэ лашь сэ се рэскумпере ши ынтыюл нэскут ал унуй добиток некурат. ");
INSERT INTO ron1924_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Сэ лашь сэ се рэскумпере ынтыий нэскуць ай оаменилор де ла вырста де о лунэ, дупэ прецуиря та, ку прецул де чинч сикли де арӂинт, дупэ сиклул Сфынтулуй Локаш, каре есте де доуэзечь де гере. ");
INSERT INTO ron1924_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Дар сэ ну лашь сэ се рэскумпере ынтыюл нэскут ал вачий, нич ынтыюл нэскут ал оий, нич ынтыюл нэскут ал капрей; ачестя сунт лукрурь сфинте. Сынӂеле лор сэ-л стропешть пе алтар ши сэ ле арзь грэсимя; ачаста ва фи о жертфэ мистуитэ де фок де ун мирос плэкут Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Карня лор сэ фие а та, ка ши пептул каре се лягэнэ ынтр-о парте ши ын алта ши ка ши спата дряптэ. ");
INSERT INTO ron1924_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Ыць дау цие, фиилор тэй ши фийчелор тале ымпреунэ ку тине, принтр-о леӂе вешникэ, тоате даруриле сфинте пе каре ле вор адуче Домнулуй копиий луй Исраел прин ридикаре. Ачеста есте ун легэмынт де некэлкат ши пе вечие ынаинтя Домнулуй, пентру тине ши пентру сэмынца та ымпреунэ ку тине.” ");
INSERT INTO ron1924_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Домнул а зис луй Аарон: „Ту сэ н-ай ничо моштенире ын цара лор ши сэ н-ай ничо парте де мошие ын мижлокул лор. Еу сунт моштениря ши партя та де мошие ын мижлокул копиилор луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Фиилор луй Леви ле дау ка моштенире орьче зечуялэ ын Исраел, пентру служба пе каре о фак ей, пентру служба кортулуй ынтылнирий. ");
INSERT INTO ron1924_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Копиий луй Исраел сэ ну се май апропие де кортул ынтылнирий, ка сэ ну се факэ виноваць де вреун пэкат ши сэ моарэ. ");
INSERT INTO ron1924_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Чи левиций сэ факэ служба кортулуй ынтылнирий ши сэ рэмынэ ынкэркаць ку фэрэделеӂиле лор. Ей сэ н-айбэ ничо моштенире ын мижлокул копиилор луй Исраел: ачаста сэ фие о леӂе вешникэ принтре урмаший воштри. ");
INSERT INTO ron1924_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Левицилор ле дау де моштенире зечуелиле пе каре ле вор адуче копиий луй Исраел Домнулуй прин ридикаре, де ачея зик ку привире ла ей: ‘Сэ ну айбэ ничо моштенире ын мижлокул копиилор луй Исраел.’” ");
INSERT INTO ron1924_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","„Сэ ворбешть левицилор ши сэ ле спуй: ‘Кынд вець прими де ла копиий луй Исраел зечуяла пе каре в-о дау дин партя лор, ка моштенире а воастрэ, сэ луаць ынтый дин еа ун дар пентру Домнул, ши ануме а зечя парте дин зечуялэ, ");
INSERT INTO ron1924_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","ши дарул востру ви се ва сокоти ка грыул каре се я ынтый дин арие ши ка мустул каре се я ынтый дин тяск. ");
INSERT INTO ron1924_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Астфел, сэ луаць ши вой ынтый ун дар пентру Домнул дин тоате зечуелиле пе каре ле вець прими де ла копиий луй Исраел ши сэ даць преотулуй Аарон дарул пе каре-л вець луа ынтый дин еле пентру Домнул. ");
INSERT INTO ron1924_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Дин тоате даруриле каре ви се вор да, сэ луаць ынтый тоате даруриле пентру Домнул; дин тот че ва фи май бун, сэ луаць ынтый партя ынкинатэ Домнулуй.’ ");
INSERT INTO ron1924_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Сэ ле спуй: ‘Дупэ че вець луа дин еле партя чя май бунэ, зечуяла ва фи сокотитэ левицилор ка венитул де ла арие ши ка венитул де ла тяск. ");
INSERT INTO ron1924_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Сэ-л мынкаць ынтр-ун лок оарекаре, вой ши каса воастрэ, кэч ачаста есте плата воастрэ пентру служба пе каре о фачець ын кортул ынтылнирий. ");
INSERT INTO ron1924_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Ну вэ вець фаче виноваць пентру ачаста де ничун пэкат, дакэ вець луа дин еле пентру Домнул че есте май бун, нич ну вець пынгэри даруриле сфинте але копиилор луй Исраел ши ну вець мури.’” ");
INSERT INTO ron1924_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Домнул а ворбит луй Мойсе ши луй Аарон ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","„Ятэ че порунчеште леӂя пе каре а дат-о Домнул, зикынд: ‘Ворбеште копиилор луй Исраел сэ-ць адукэ о вакэ рошие, фэрэ патэ, фэрэ вреун кусур трупеск ши каре сэ ну фи фост пусэ ла жуг. ");
INSERT INTO ron1924_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","С-о даць преотулуй Елеазар; ел с-о скоатэ дин табэрэ ши сэ фие жунгиятэ ынаинтя луй. ");
INSERT INTO ron1924_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Преотул Елеазар сэ я ку деӂетул дин сынӂеле вачий ши сэ стропяскэ де шапте орь ынаинтя кортулуй ынтылнирий. ");
INSERT INTO ron1924_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Вака сэ фие арсэ суб окий луй; сэ-й ардэ пеля, карня ши сынӂеле, ымпреунэ ку балега. ");
INSERT INTO ron1924_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Преотул сэ я лемн де чедру, исоп ши кырмыз ши сэ ле арунче ын мижлокул флэкэрилор каре вор мистуи вака. ");
INSERT INTO ron1924_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Преотул сэ-шь спеле хайнеле ши сэ-шь скалде трупул ын апэ, апой сэ интре ярэшь ын табэрэ ши сэ фие некурат пынэ сяра. ");
INSERT INTO ron1924_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Чел че ва арде вака сэ-шь спеле хайнеле ын апэ ши сэ-шь скалде трупул ын апэ ши сэ фие некурат пынэ сяра. ");
INSERT INTO ron1924_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Ун ом курат сэ стрынгэ ченуша вачий ши с-о пунэ ынтр-ун лок курат афарэ дин табэрэ; с-о пэстрезе пентру адунаря копиилор луй Исраел, ка сэ факэ апа де курэцире. Ачаста есте о апэ де испэшире. ");
INSERT INTO ron1924_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Чел че ва стрынӂе ченуша вачий сэ-шь спеле хайнеле ши сэ фие некурат пынэ сяра. Ачаста сэ фие о леӂе вешникэ атыт пентру копиий луй Исраел, кыт ши пентру стрэинул каре локуеште ын мижлокул лор. ");
INSERT INTO ron1924_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Чине се ва атинӂе де вреун морт, де вреун труп оменеск морт, сэ фие некурат тимп де шапте зиле. ");
INSERT INTO ron1924_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Сэ се курэцяскэ ку апа ачаста а трея зи ши а шаптя зи ши ва фи курат, дар, дакэ ну се курэцеште а трея зи ши а шаптя зи, ну ва фи курат. ");
INSERT INTO ron1924_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Чине се ва атинӂе де ун морт, де трупул унуй ом морт, ши ну се ва курэци пынгэреште кортул Домнулуй; ачела сэ фие нимичит дин Исраел. Фииндкэ ну с-а стропит песте ел апа де курэцире, есте некурат ши некурэция луй есте ынкэ песте ел. ");
INSERT INTO ron1924_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Ятэ леӂя кынд ва мури ун ом ынтр-ун корт: орьчине ва интра ын корт ши орьчине се ва афла ын корт ва фи некурат шапте зиле. ");
INSERT INTO ron1924_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Де асеменя, орьче вас дескоперит, каре ну ва авя ун капак бине стрынс пе ел, ва фи некурат. ");
INSERT INTO ron1924_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Орьчине се ва атинӂе пе кымп де ун ом учис де сабие сау де ун морт сау де оасе оменешть сау де вреун мормынт ва фи некурат тимп де шапте зиле. ");
INSERT INTO ron1924_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Пентру чел некурат, сэ се я ченушэ де ла жертфа де испэшире каре а фост арсэ ши сэ тоарне песте еа апэ де извор ынтр-ун вас. ");
INSERT INTO ron1924_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Ун ом курат сэ я исоп ши сэ-л ынмоае ын апэ; сэ стропяскэ апой ку ел кортул, тоате унелтеле, оамений каре сунт аколо, пе чел че с-а атинс де оасе оменешть сау де вреун ом учис сау де вреун морт сау де вреун мормынт. ");
INSERT INTO ron1924_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Чел курат сэ стропяскэ пе чел некурат а трея зи ши а шаптя зи ши сэ-л курэцяскэ ын зиуа а шаптя. Сэ-шь спеле хайнеле ши сэ се скалде ын апэ ши сяра ва фи курат. ");
INSERT INTO ron1924_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Ун ом каре ва фи некурат ши ну се ва курэци ва фи нимичит дин мижлокул адунэрий, кэч а спуркат Сфынтул Локаш ал Домнулуй; фииндкэ н-а фост стропитэ песте ел апа де курэцире, есте некурат. ");
INSERT INTO ron1924_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Ачаста сэ фие о леӂе вешникэ пентру ей. Чел че ва стропи пе алтул ку апа де курэцире сэ-шь спеле хайнеле ши чел че се ва атинӂе де апа де курэцире сэ фие некурат пынэ сяра. ");
INSERT INTO ron1924_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Орьче лукру де каре се ва атинӂе чел некурат ва фи некурат ши чине се ва атинӂе де ел сэ фие некурат пынэ сяра.’” ");
INSERT INTO ron1924_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Тоатэ адунаря копиилор луй Исраел а ажунс ын пустиул Цин ын луна ынтый. Ши попорул с-а оприт ла Кадес. Аколо а мурит ши а фост ынгропатэ Мария. ");
INSERT INTO ron1924_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Адунаря н-авя апэ. Ши с-ау рэскулат ымпотрива луй Мойсе ши ымпотрива луй Аарон. ");
INSERT INTO ron1924_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Попорул а кэутат чартэ ку Мойсе. Ей ау зис: „Че бине ар фи фост сэ фи мурит ной кынд ау мурит фраций ноштри ынаинтя Домнулуй! ");
INSERT INTO ron1924_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Пентру че аць адус адунаря Домнулуй ын пустиул ачеста, ка сэ мурим ын ел, ной ши вителе ноастре? ");
INSERT INTO ron1924_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Пентру че не-аць скос дин Еӂипт ши не-аць адус ын ачест лок рэу, унде ну есте нич лок де семэнат, нич смокин, нич вицэ, нич родиу, нич апэ де бэут?” ");
INSERT INTO ron1924_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Мойсе ши Аарон ау плекат де ла адунаре ши с-ау дус ла уша кортулуй ынтылнирий. Ау кэзут ку фаца ла пэмынт ши ли с-а арэтат слава Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","„Я тоягул ши кямэ адунаря, ту ши фрателе тэу Аарон. Сэ ворбиць стынчий ачестея ын фаца лор, ши еа ва да апэ. Сэ ле скоць астфел апэ дин стынкэ ши сэ адэпь адунаря ши вителе лор.” ");
INSERT INTO ron1924_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Мойсе а луат тоягул динаинтя Домнулуй, кум ый порунчисе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Мойсе ши Аарон ау кемат адунаря ынаинтя стынчий. Ши Мойсе ле-а зис: „Аскултаць, рэзврэтицилор! Вом путя ной оаре сэ вэ скоатем апэ дин стынка ачаста?” ");
INSERT INTO ron1924_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Апой Мойсе а ридикат мына ши а ловит стынка де доуэ орь ку тоягул. Ши а ешит апэ дин белшуг, аша ынкыт а бэут ши адунаря ши ау бэут ши вителе. ");
INSERT INTO ron1924_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Атунч, Домнул а зис луй Мойсе: „Пентру кэ н-аць крезут ын Мине ка сэ Мэ сфинциць ынаинтя копиилор луй Исраел, ну вой вець дуче адунаря ачаста ын цара пе каре й-о дау.” ");
INSERT INTO ron1924_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Ачестя сунт апеле Мериба, унде с-ау чертат копиий луй Исраел ку Домнул, каре а фост сфинцит ынтре ей. ");
INSERT INTO ron1924_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Де ла Кадес, Мойсе а тримис ниште соль ла ымпэратул Едомулуй ка сэ-й спунэ: „Аша ворбеште фрателе тэу Исраел: ‘Ту штий тоате суферинцеле прин каре ам трекут. ");
INSERT INTO ron1924_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Пэринций ноштри с-ау коборыт ын Еӂипт ши ам локуит аколо мултэ време. Дар еӂиптений не-ау кинуит, пе ной ши пе пэринций ноштри. ");
INSERT INTO ron1924_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Ам стригат кэтре Домнул, ши Ел не-а аузит гласул. А тримис ун Ынӂер ши не-а скос дин Еӂипт. Ши ятэ кэ сунтем ла Кадес, четате каре се афлэ ла марӂиня цинутулуй тэу. ");
INSERT INTO ron1924_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Ласэ-не сэ тречем прин цара та; ну вом трече нич прин огоаре, нич прин вий ши нич ну вом бя апэ дин фынтынь; вом мерӂе пе друмул ымпэрэтеск, фэрэ сэ не абатем ла дряпта сау ла стынга, пынэ вом трече де цинутул тэу.’” ");
INSERT INTO ron1924_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Едом й-а рэспунс: „Сэ ну кумва сэ тречь пе ла мине, кэч алтфел ыць вой еши ынаинте ку сабия.” ");
INSERT INTO ron1924_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Копиий луй Исраел й-ау зис: „Вом мерӂе пе друмул чел маре ши, дакэ вом бя дин апа та еу ши турмеле меле, ыць вой плэти прецул; ну-ць чер алтчева декыт сэ трек ку пичоареле!” ");
INSERT INTO ron1924_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Ел а рэспунс: „Сэ ну кумва сэ тречь!” Ши Едом й-а ешит ынаинте ку мултэ глоатэ ши ку мынэ таре. ");
INSERT INTO ron1924_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Астфел, Едом н-а врут сэ ласе пе Исраел сэ трякэ прин цинутул луй. Ши Исраел с-а абэтут де ла ел. ");
INSERT INTO ron1924_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Тоатэ адунаря копиилор луй Исраел а плекат де ла Кадес ши а ажунс ла мунтеле Хор. ");
INSERT INTO ron1924_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Домнул а зис луй Мойсе ши луй Аарон лынгэ мунтеле Хор, ла хотареле цэрий луй Едом: ");
INSERT INTO ron1924_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","„Аарон аре сэ фие адэугат ла попорул луй, кэч ну ва интра ын цара пе каре о дау копиилор луй Исраел, пентру кэ в-аць ымпотривит порунчий Меле, ла апеле Мериба. ");
INSERT INTO ron1924_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Я пе Аарон ши пе фиул сэу Елеазар ши суе-й пе мунтеле Хор. ");
INSERT INTO ron1924_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Дезбракэ пе Аарон де вешминтеле луй ши ымбракэ пе фиул сэу Елеазар ку еле. Аколо ва фи адэугат Аарон ла попорул луй ши ва мури.” ");
INSERT INTO ron1924_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Мойсе а фэкут че-й порунчисе Домнул. С-ау суит пе мунтеле Хор, ын фаца ынтреӂий адунэрь. ");
INSERT INTO ron1924_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Мойсе а дезбрэкат пе Аарон де вешминтеле луй ши а ымбрэкат ку еле пе фиул сэу Елеазар. Аарон а мурит аколо, пе вырфул мунтелуй. Мойсе ши Елеазар с-ау коборыт де пе мунте. ");
INSERT INTO ron1924_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Тоатэ адунаря а вэзут кэ Аарон мурисе ши тоатэ каса луй Исраел а плынс пе Аарон трейзечь де зиле. ");
INSERT INTO ron1924_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Ымпэратул Арадулуй, ун канаанит каре локуя ла мязэзи, а аузит кэ Исраел вине пе друмул Атарим. Ел с-а луптат ымпотрива луй Исраел ши а луат май мулць приншь де рэзбой. ");
INSERT INTO ron1924_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Атунч Исраел а фэкут Домнулуй о журуинцэ ши а зис: „Дакэ вей да пе попорул ачеста ын мыниле меле, ый вой нимичи ку десэвыршире четэциле.” ");
INSERT INTO ron1924_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Домнул а аузит гласул луй Исраел ши а дат пе канааниць ын мыниле луй. Исраелиций й-ау нимичит ку десэвыршире, пе ей ши четэциле лор, ши локул ачела л-ау нумит Хорма. ");
INSERT INTO ron1924_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Ау плекат де ла мунтеле Хор пе друмул каре дуче спре Маря Рошие, ка сэ околяскэ цара Едомулуй. Попорул шь-а пердут рэбдаря пе друм ");
INSERT INTO ron1924_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","ши а ворбит ымпотрива луй Думнезеу ши ымпотрива луй Мойсе: „Пентру че не-аць скос дин Еӂипт ка сэ мурим ын пустиу? Кэч ну есте нич пыне, нич апэ ши ни с-а скырбит суфлетул де ачастэ хранэ проастэ.” ");
INSERT INTO ron1924_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Атунч, Домнул а тримис ымпотрива попорулуй ниште шерпь ынфокаць, каре ау мушкат попорул, аша ынкыт ау мурит мулць оамень ын Исраел. ");
INSERT INTO ron1924_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Попорул а венит ла Мойсе ши а зис: „Ам пэкэтуит, кэч ам ворбит ымпотрива Домнулуй ши ымпотрива та. Роагэ-те Домнулуй ка сэ депэртезе де ла ной ачешть шерпь.” Мойсе с-а ругат пентру попор. ");
INSERT INTO ron1924_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Домнул а зис луй Мойсе: „Фэ-ць ун шарпе ынфокат ши спынзурэ-л де о прэжинэ; орьчине есте мушкат ши ва приви спре ел ва трэи.” ");
INSERT INTO ron1924_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Мойсе а фэкут ун шарпе де арамэ ши л-а пус ынтр-о прэжинэ ши орьчине ера мушкат де ун шарпе ши привя спре шарпеле де арамэ трэя. ");
INSERT INTO ron1924_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Копиий луй Исраел ау плекат ши ау тэбэрыт ла Обот. ");
INSERT INTO ron1924_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Ау плекат дин Обот ши ау тэбэрыт ла Иие-Абарим, ын пустиул дин фаца Моабулуй, спре рэсэритул соарелуй. ");
INSERT INTO ron1924_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Де аколо ау плекат ши ау тэбэрыт ын валя Зеред. ");
INSERT INTO ron1924_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Де аколо ау плекат ши ау тэбэрыт динколо де Арнон, каре курӂе прин пустиу, ешинд дин цинутул аморицилор, кэч Арнонул фаче хотарул Моабулуй, ынтре Моаб ши амориць. ");
INSERT INTO ron1924_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Де ачея се зиче ын Картя Рэзбоаелор Домнулуй: „Вахеб ын Суфа, Шувоаеле Арнонулуй ");
INSERT INTO ron1924_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","Ши скурӂериле шувоаелор Каре се ынтинд ынспре Ар ши се атинг ку хотарул луй Моаб.” ");
INSERT INTO ron1924_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Де аколо с-ау дус ла Беер. Ла ачастэ фынтынэ, Домнул а зис луй Мойсе: „Стрынӂе попорул ши ле вой да апэ.” ");
INSERT INTO ron1924_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Атунч а кынтат Исраел кынтаря ачаста: „Цышнеште, фынтынэ! Кынтаць ын чинстя ей! ");
INSERT INTO ron1924_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Фынтына пе каре ау сэпат-о кэпетенииле, Пе каре ау сэпат-о май-марий попорулуй, Ку тоягул де кырмуире, ку тоеӂеле лор!” Дин пустиул ачеста с-ау дус ла Матана; ");
INSERT INTO ron1924_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","дин Матана, ла Нахалиел; дин Нахалиел, ла Бамот; ");
INSERT INTO ron1924_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","дин Бамот, ла валя дин кымпия Моабулуй, ын вырфул мунтелуй Писга, каре каутэ спре пустиу. ");
INSERT INTO ron1924_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Исраел а тримис соль ла Сихон, ымпэратул аморицилор, ка сэ-й спунэ: ");
INSERT INTO ron1924_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","„Ласэ-мэ сэ трек прин цара та; ну вом интра нич ын огоаре, нич ын вий ши ну вом бя апэ дин фынтынь; вом цине друмул ымпэрэтеск, пынэ вом трече де цинутул тэу.” ");
INSERT INTO ron1924_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Сихон н-а ынгэдуит луй Исраел сэ трякэ прин цинутул луй. Сихон а стрынс тот попорул ши а ешит ынаинтя луй Исраел, ын пустиу. А венит ла Иахац ши с-а луптат ымпотрива луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Исраел л-а бэтут ку аскуцишул сабией ши й-а кучерит цара де ла Арнон пынэ ла Иабок, пынэ ла хотарул копиилор луй Амон, кэч хотарул копиилор луй Амон ера ынтэрит. ");
INSERT INTO ron1924_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Исраел а луат тоате четэциле ачеля ши с-а ашезат ын тоате четэциле аморицилор, ын Хесбон ши ын тоате сателе де прин ымпрежуримь. ");
INSERT INTO ron1924_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Кэч Хесбонул ера четатя луй Сихон, ымпэратул аморицилор. Ел порнисе ку рэзбой ымпотрива ымпэратулуй динаинте ал Моабулуй ши-й луасе тоатэ цара пынэ ла Арнон. ");
INSERT INTO ron1924_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Де ачея зик поеций: „Вениць ла Хесбон! Сэ се зидяскэ дин ноу ши сэ се ынтэряскэ четатя луй Сихон. ");
INSERT INTO ron1924_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Кэч а ешит ун фок дин Хесбон, О флакэрэ дин четатя луй Сихон, Ши а мистуит пе Ар-Моаб, Пе локуиторий ынэлцимилор Арнонулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Вай де тине, Моаб! Ешть пердут, попорул луй Кемош! Ел а фэкут пе фиий луй фугарь, Ши пе фетеле луй ле-а дат роабе Луй Сихон, ымпэратул аморицилор. ");
INSERT INTO ron1924_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Ной ам арункат ку сэӂециле асупра лор: Дин Хесбон пынэ ла Дибон тотул есте нимичит; Ам пустиит пынэ ла Нофах, Каре се ынтинде пынэ ла Медеба.” ");
INSERT INTO ron1924_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Исраел с-а ашезат астфел ын цара аморицилор. ");
INSERT INTO ron1924_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Мойсе а тримис сэ искодяскэ Иаезерул. Ау луат сателе каре циняу де ел ши ау изгонит пе амориций каре ерау ын еле. ");
INSERT INTO ron1924_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Ау скимбат апой друмул ши с-ау суит пе друмул каре дуче ла Басан. Ог, ымпэратул Басанулуй, ле-а ешит ынаинте ку тот попорул луй, ка сэ лупте ымпотрива лор ла Едрей. ");
INSERT INTO ron1924_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Домнул а зис луй Мойсе: „Ну те теме де ел, кэч ыл дау ын мыниле тале, пе ел ши тот попорул луй ши тоатэ цара луй; сэ-й фачь кум ай фэкут луй Сихон, ымпэратул аморицилор, каре локуя ла Хесбон.” ");
INSERT INTO ron1924_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Ши ей л-ау бэтут, пе ел ши пе фиий луй ши тот попорул луй, де н-ау лэсат сэ скапе унул мэкар, ши ау пус мына пе цара луй. ");
INSERT INTO ron1924_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Копиий луй Исраел ау порнит ши ау тэбэрыт ын шесуриле Моабулуй, динколо де Йордан, ын фаца Иерихонулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Балак, фиул луй Ципор, а вэзут тот че фэкусе Исраел аморицилор. ");
INSERT INTO ron1924_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Ши Моаб а рэмас фоарте ынгрозит ын фаца унуй попор атыт де маре ла нумэр; л-а апукат гроаза ын фаца копиилор луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Моаб а зис бэтрынилор луй Мадиан: „Мулцимя ачаста аре сэ ынгитэ тот че есте ын журул ностру, кум паште боул вердяца де пе кымп.” Балак, фиул луй Ципор, ера пе атунч ымпэрат ал Моабулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Ел а тримис соль ла Балаам, фиул луй Беор, ла Петор пе Рыу (Еуфрат), ын цара фиилор попорулуй сэу, ка сэ-л кеме ши сэ-й спунэ: „Ятэ, ун попор а ешит дин Еӂипт, акоперэ фаца пэмынтулуй ши с-а ашезат ын фаца мя! ");
INSERT INTO ron1924_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Вино, те рог, сэ-мь блестемь пе попорул ачеста, кэч есте май путерник декыт мине. Поате кэ аша ыл вой путя бате ши-л вой изгони дин царэ, кэч штиу кэ пе чине бинекувынтезь ту есте бинекувынтат ши пе чине блестемь ту есте блестемат.” ");
INSERT INTO ron1924_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Бэтрыний луй Моаб ши бэтрыний луй Мадиан ау плекат авынд ку ей дарурь пентру гичитор. Ау ажунс ла Балаам ши й-ау спус кувинтеле луй Балак. ");
INSERT INTO ron1924_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Балаам ле-а зис: „Рэмынець аич песте ноапте ши вэ вой да рэспунс дупэ кум ымь ва спуне Домнул.” Ши кэпетенииле Моабулуй ау рэмас ла Балаам. ");
INSERT INTO ron1924_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Думнезеу а венит ла Балаам ши а зис: „Чине сунт оамений ачештя пе каре-й ай ла тине?” ");
INSERT INTO ron1924_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Балаам а рэспунс луй Думнезеу: „Балак, фиул луй Ципор, ымпэратул Моабулуй, й-а тримис сэ-мь спунэ: ");
INSERT INTO ron1924_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘Ятэ, ун попор а ешит дин Еӂипт ши акоперэ фаца пэмынтулуй; вино дар ши блестемэ-л; поате кэ аша ыл вой путя бате ши-л вой изгони.’” ");
INSERT INTO ron1924_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Думнезеу а зис луй Балаам: „Сэ ну те дучь ку ей ши нич сэ ну блестемь попорул ачела, кэч есте бинекувынтат.” ");
INSERT INTO ron1924_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Балаам с-а скулат диминяца ши а зис кэпетениилор луй Балак: „Дучеци-вэ ынапой ын цара воастрэ, кэч Домнул ну вря сэ мэ ласе сэ мерг ку вой.” ");
INSERT INTO ron1924_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Ши май-марий Моабулуй с-ау скулат, с-ау ынторс ла Балак ши й-ау спус: „Балаам н-а врут сэ винэ ку ной.” ");
INSERT INTO ron1924_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Балак а тримис дин ноу май мулте кэпетений май ку вазэ декыт челе динаинте. ");
INSERT INTO ron1924_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Ау ажунс ла Балаам ши й-ау зис: „Аша ворбеште Балак, фиул луй Ципор: ‘Ну май пуне педичь ши вино ла мине, ");
INSERT INTO ron1924_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","кэч ыць вой да мултэ чинсте ши вой фаче тот че-мь вей спуне; нумай вино, те рог, ши блестемэ-мь попорул ачеста!’” ");
INSERT INTO ron1924_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Балаам а рэспунс ши а зис служиторилор луй Балак: „Сэ-мь дя Балак кяр ши каса луй плинэ де арӂинт ши де аур, ши тот н-аш путя сэ фак ничун лукру, фие мик, фие маре, ымпотрива порунчий Домнулуй Думнезеулуй меу. ");
INSERT INTO ron1924_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Тотушь, вэ рог, рэмынець аич ла ноапте ши вой ведя че-мь ва май спуне Домнул.” ");
INSERT INTO ron1924_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Думнезеу а венит ла Балаам ын тимпул нопций ши й-а зис: „Фииндкэ оамений ачештя ау венит сэ те кеме, скоалэ-те ши ду-те ку ей, дар сэ фачь нумай че-ць вой спуне.” ");
INSERT INTO ron1924_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Балаам с-а скулат диминяцэ, а пус шауа пе мэгэрицэ ши а плекат ку кэпетенииле луй Моаб. ");
INSERT INTO ron1924_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Думнезеу С-а апринс де мыние пентру кэ плекасе. Ши Ынӂерул Домнулуй С-а ашезат ын друм, ка сэ и Се ымпотривяскэ. Балаам ера кэларе пе мэгэрица луй ши чей дой служиторь ай луй ерау ку ел. ");
INSERT INTO ron1924_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Мэгэрица а вэзут пе Ынӂерул Домнулуй стынд ын друм, ку сабия скоасэ дин тякэ ын мынэ, с-а абэтут дин друм ши а луат-о пе кымп. Балаам шь-а бэтут мэгэрица ка с-о адукэ ла друм. ");
INSERT INTO ron1924_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Ынӂерул Домнулуй С-а ашезат ынтр-о кэраре динтре вий ши де фиекаре парте а кэрэрий ера кыте ун зид. ");
INSERT INTO ron1924_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Мэгэрица а вэзут пе Ынӂерул Домнулуй, с-а стрынс спре зид ши а стрынс пичорул луй Балаам де зид. Балаам а бэтут-о дин ноу. ");
INSERT INTO ron1924_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Ынӂерул Домнулуй а трекут май департе ши С-а ашезат ынтр-ун лок унде ну ера кип сэ те ынторчь нич ла дряпта, нич ла стынга. ");
INSERT INTO ron1924_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Мэгэрица а вэзут пе Ынӂерул Домнулуй ши с-а кулкат суб Балаам. Балаам с-а апринс де мыние ши а бэтут мэгэрица ку ун бэц. ");
INSERT INTO ron1924_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Домнул а дескис гура мэгэрицей ши еа а зис луй Балаам: „Че ць-ам фэкут, де м-ай бэтут де трей орь?” ");
INSERT INTO ron1924_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Балаам а рэспунс мэгэрицей: „Пентру кэ ць-ай бэтут жок де мине; дакэ аш авя о сабие ын мынэ, те-аш учиде пе лок.” ");
INSERT INTO ron1924_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Мэгэрица а зис луй Балаам: „Ну сунт еу оаре мэгэрица та, пе каре ай кэлэрит ын тот тимпул пынэ ын зиуа де азь? Ам еу оаре обичей сэ-ць фак аша?” Ши ел а рэспунс: „Ну.” ");
INSERT INTO ron1924_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Домнул а дескис окий луй Балаам, ши Балаам а вэзут пе Ынӂерул Домнулуй стынд ын друм, ку сабия скоасэ ын мынэ. Ши с-а плекат ши с-а арункат ку фаца ла пэмынт. ");
INSERT INTO ron1924_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Ынӂерул Домнулуй й-а зис: „Пентру че ць-ай бэтут мэгэрица де трей орь? Ятэ, Еу ам ешит ка сэ-ць стау ымпотривэ, кэч друмул пе каре мерӂь есте ун друм каре дуче ла перзаре ынаинтя Мя. ");
INSERT INTO ron1924_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Мэгэрица М-а вэзут ши с-а абэтут де трей орь динаинтя Мя; дакэ ну с-ар фи абэтут динаинтя Мя, пе тине те-аш фи оморыт, яр пе еа аш фи лэсат-о вие.” ");
INSERT INTO ron1924_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Балаам а зис Ынӂерулуй Домнулуй: „Ам пэкэтуит, кэч ну штиям кэ Те-ай ашезат ынаинтя мя ын друм, ши акум, дакэ ну гэсешть кэ е бине че фак еу, мэ вой ынтоарче.” ");
INSERT INTO ron1924_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Ынӂерул Домнулуй а зис луй Балаам: „Ду-те ку оамений ачештя, дар сэ спуй нумай кувинтеле пе каре ци ле вой спуне Еу.” Ши Балаам а плекат ынаинте ку кэпетенииле луй Балак. ");
INSERT INTO ron1924_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Балак а аузит кэ вине Балаам ши й-а ешит ынаинте пынэ ла четатя Моабулуй, каре есте ла хотарул Арнонулуй, ла хотарул чел май депэртат. ");
INSERT INTO ron1924_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Балак а зис луй Балаам: „Н-ам тримис еу оаре ла тине сэ те кеме? Пентру че н-ай венит ла мине? Кум, ну пот еу оаре сэ-ць дау чинсте?” ");
INSERT INTO ron1924_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Балаам а рэспунс луй Балак: „Ятэ кэ ам венит ла тине. Акум ымь ва фи оаре ынгэдуит сэ спун чева? Вой спуне кувинтеле пе каре ми ле ва пуне Думнезеу ын гурэ.” ");
INSERT INTO ron1924_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Балаам а мерс ку Балак ши ау ажунс ла Кириат-Хуцот. ");
INSERT INTO ron1924_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Балак а жертфит бой ши ой ши а тримис дин ей луй Балаам ши кэпетениилор каре ерау ку ел. ");
INSERT INTO ron1924_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Диминяца, Балак а луат пе Балаам ши л-а суит пе Бамот-Баал, де унде Балаам путя сэ вадэ о парте дин попор. ");
INSERT INTO ron1924_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Балаам а зис луй Балак: „Зидеште-мь аич шапте алтаре ши прегэтеште-мь аич шапте вицей ши шапте бербечь.” ");
INSERT INTO ron1924_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Балак а фэкут кум спусесе Балаам, ши Балак ши Балаам ау адус кыте ун вицел ши кыте ун бербек пе фиекаре алтар. ");
INSERT INTO ron1924_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Балаам а зис луй Балак: „Стай лынгэ ардеря та де тот, ши еу мэ вой депэрта де еа; поате кэ Домнул ымь ва еши ынаинте ши че-мь ва дескопери ыць вой спуне.” Ши с-а дус пе ун лок ыналт. ");
INSERT INTO ron1924_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Думнезеу а венит ынаинтя луй Балаам ши Балаам Й-а зис: „Ам ридикат шапте алтаре ши, пе фиекаре алтар, ам адус кыте ун вицел ши кыте ун бербек.” ");
INSERT INTO ron1924_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Домнул а пус кувинте ын гура луй Балаам ши а зис: „Ынтоарче-те ла Балак ши аша сэ-й ворбешть.” ");
INSERT INTO ron1924_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Балаам с-а ынторс ла Балак ши ятэ кэ Балак стэтя лынгэ ардеря луй де тот, ел ши тоате кэпетенииле Моабулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Балаам шь-а ростит пророчия ши а зис: „Балак м-а адус дин Арам (Месопотамия). Ымпэратул Моабулуй м-а кемат дин мунций Рэсэритулуй, зикынд: ‘Вино ши блестемэ-мь пе Иаков! Вино ши дефэймязэ-мь пе Исраел!’ ");
INSERT INTO ron1924_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Кум сэ блестем еу пе чел че ну-л блестемэ Думнезеу? Кум сэ дефэймез еу пе чел пе каре ну-л дефэймязэ Домнул? ");
INSERT INTO ron1924_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Ыл вэд дин вырфул стынчилор, Ыл привеск де пе ынэлцимя дялурилор: Есте ун попор каре локуеште деопарте Ши ну фаче парте динтре нямурь. ");
INSERT INTO ron1924_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Чине поате сэ нумере пулберя луй Иаков Ши сэ спунэ нумэрул унуй сферт дин Исраел? О, де аш мури де моартя челор неприхэниць Ши сфыршитул меу сэ фие ка ал лор!” ");
INSERT INTO ron1924_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Балак а зис луй Балаам: „Че мь-ай фэкут? Те-ам луат сэ блестемь пе врэжмашул меу, ши ятэ кэ ту-л бинекувынтезь!” ");
INSERT INTO ron1924_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Ел а рэспунс ши а зис: „Ну требуе оаре сэ спун че-мь пуне Домнул ын гурэ?” ");
INSERT INTO ron1924_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Балак й-а зис: „Вино, те рог, ку мине ын алт лок, де унде ыл поць ведя, кэч аич ну везь декыт о парте дин ел, ну-л везь ынтрег. Ши де аколо сэ ми-л блестемь.” ");
INSERT INTO ron1924_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Л-а дус ын кымпул Цофим, спре вырфул мунтелуй Писга, а зидит шапте алтаре ши а адус кыте ун вицел ши ун бербек пе фиекаре алтар. ");
INSERT INTO ron1924_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Балаам а зис луй Балак: „Стай аич, лынгэ ардеря та де тот, ши еу мэ вой дуче ынаинтя луй Думнезеу.” ");
INSERT INTO ron1924_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Домнул а венит ынаинтя луй Балаам, й-а пус кувинте ын гурэ ши а зис: „Ынтоарче-те ла Балак ши аша сэ-й ворбешть.” ");
INSERT INTO ron1924_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Балаам с-а ынторс ла ел, ши ятэ кэ Балак стэтя лынгэ ардеря луй де тот, ку кэпетенииле Моабулуй. Балак й-а зис: „Че ць-а спус Домнул?” ");
INSERT INTO ron1924_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Балаам шь-а ростит пророчия ши а зис: „Скоалэ-те, Балак, ши аскултэ! Я аминте ла мине, фиул луй Ципор! ");
INSERT INTO ron1924_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Думнезеу ну есте ун ом, ка сэ минтэ, Нич ун фиу ал омулуй, ка сэ-Й парэ рэу. Че а спус, оаре ну ва фаче? Че а фэгэдуит, оаре ну ва ымплини? ");
INSERT INTO ron1924_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Ятэ кэ ам примит порункэ сэ бинекувынтез. Да, Ел а бинекувынтат, ши еу ну пот ынтоарче. ");
INSERT INTO ron1924_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Ел ну веде ничо фэрэделеӂе ын Иаков, Ну веде ничо рэутате ын Исраел. Домнул Думнезеул луй есте ку ел, Ел есте Ымпэратул луй, веселия луй. ");
INSERT INTO ron1924_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Думнезеу й-а скос дин Еӂипт, Тэрия Луй есте пентру ел ка а биволулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Дескынтекул ну поате фаче нимик ымпотрива луй Иаков, Нич врэжитория ымпотрива луй Исраел. Акум се поате спуне деспре Иаков ши Исраел: ‘Че лукрурь марь а фэкут Думнезеу!’ ");
INSERT INTO ron1924_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Да, попорул ачеста се скоалэ ка о леоайкэ Ши се ридикэ ынтокмай ка ун леу. Ну се кулкэ пынэ че н-а мынкат прада Ши н-а бэут сынӂеле челор учишь.” ");
INSERT INTO ron1924_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Балак а зис луй Балаам: „Ну-л блестема, дар мэкар нич ну-л бинекувынта!” ");
INSERT INTO ron1924_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Балаам а рэспунс ши а зис луй Балак: „Ну ць-ам спус кэ вой фаче тот че ва спуне Домнул?” ");
INSERT INTO ron1924_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Балак а зис луй Балаам: „Вино, те рог, те вой дуче ынтр-ун алт лок; поате кэ Думнезеу ва гэси ку кале сэ-мь блестемь де аколо пе попорул ачеста!” ");
INSERT INTO ron1924_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Балак а дус пе Балаам пе вырфул мунтелуй Пеор, каре есте ку фаца спре пустиу. ");
INSERT INTO ron1924_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Балаам а зис луй Балак: „Зидеште-мь аич шапте алтаре ши прегэтеште-мь аич шапте вицей ши шапте бербечь!” ");
INSERT INTO ron1924_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Балак а фэкут кум зисесе Балаам ши а адус кыте ун вицел ши кыте ун бербек пе фиекаре алтар. ");
INSERT INTO ron1924_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Балаам а вэзут кэ Домнул гэсеште ку кале сэ бинекувынтезе пе Исраел ши н-а май алергат ка ын челелалте рындурь ла дескынтече, чи шь-а ынторс фаца спре пустиу. ");
INSERT INTO ron1924_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Балаам а ридикат окий ши а вэзут пе Исраел тэбэрыт ын кортурь, дупэ семинцииле луй. Атунч, Духул луй Думнезеу а венит песте ел. ");
INSERT INTO ron1924_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Балаам шь-а ростит пророчия ши а зис: „Ятэ че зиче Балаам, фиул луй Беор, Омул ку окий дескишь, ");
INSERT INTO ron1924_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Чел че ауде кувинтеле луй Думнезеу, Чел че веде ведения Челуй Атотпутерник, Чел че каде ку фаца ла пэмынт ши ай кэруй окь сунт дескишь: ");
INSERT INTO ron1924_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","‘Че фрумоасе сунт кортуриле тале, Иакове! Локуинцеле тале, Исраеле! ");
INSERT INTO ron1924_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Еле се ынтинд ка ниште вэй, Ка ниште грэдинь лынгэ ун рыу, Ка ниште копачь де алое пе каре й-а сэдит Домнул, Ка ниште чедри пе лынгэ апе. ");
INSERT INTO ron1924_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Апа курӂе дин гэлециле луй Ши сэмынца луй есте удатэ де апе марь. Ымпэратул луй се ыналцэ май пресус де Агаг Ши ымпэрэция луй ажунӂе путерникэ. ");
INSERT INTO ron1924_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Думнезеу л-а скос дин Еӂипт, Тэрия Луй есте ка а биволулуй пентру ел. Ел нимичеште нямуриле каре се ридикэ ымпотрива луй, Ле сфэрымэ оаселе ши ле прэпэдеште ку сэӂециле луй. ");
INSERT INTO ron1924_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Ындоае ӂенункий, се кулкэ ынтокмай ка ун леу, Ка о леоайкэ. Чине-л ва скула? Бинекувынтат сэ фие орьчине те ва бинекувынта, Ши блестемат сэ фие орьчине те ва блестема!’” ");
INSERT INTO ron1924_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Балак с-а апринс де мыние ымпотрива луй Балаам, а бэтут дин мынь ши а зис луй Балаам: „Еу те-ам кемат сэ-мь блестемь врэжмаший, ши ятэ кэ де трей орь ту й-ай бинекувынтат! ");
INSERT INTO ron1924_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Фуӂь акум ши ду-те акасэ! Спусесем кэ-ць вой да чинсте, дар Домнул те-а ымпедикат с-о примешть.” ");
INSERT INTO ron1924_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Балаам а рэспунс луй Балак: „Ех! Н-ам спус еу оаре солилор пе каре ми й-ай тримис ");
INSERT INTO ron1924_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","кэ, дакэ мь-ар да Балак кяр ши каса луй плинэ ку арӂинт ши ку аур, тот н-аш путя сэ фак де ла мине ынсумь нич бине, нич рэу ымпотрива порунчий Домнулуй, чи вой спуне ынтокмай че ва зиче Домнул? ");
INSERT INTO ron1924_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Ши акум, ятэ кэ мэ дук ла попорул меу. Вино, ши-ць вой вести че ва фаче попорул ачеста попорулуй тэу ын времуриле каре вор урма.” ");
INSERT INTO ron1924_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Балаам шь-а ростит пророчия ши а зис: „Аша зиче Балаам, фиул луй Беор, Аша зиче омул каре аре окий дескишь, ");
INSERT INTO ron1924_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Аша зиче чел че ауде кувинтеле луй Думнезеу, Чел че куноаште плануриле Челуй Пряыналт, Чел че веде ведения Челуй Атотпутерник, Чел че каде ку фаца ла пэмынт ши ай кэруй окь сунт дескишь: ");
INSERT INTO ron1924_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","‘Ыл вэд, дар ну акум, Ыл привеск, дар ну де апроапе. О стя рэсаре дин Иаков, Ун тояг де кырмуире се ридикэ дин Исраел. Ел стрэпунӂе латуриле Моабулуй Ши прэпэдеште пе тоць копиий луй Сет. ");
INSERT INTO ron1924_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Се фаче стэпын пе Едом, Се фаче стэпын пе Сеир, врэжмаший луй. Исраел фаче фапте марь. ");
INSERT INTO ron1924_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Чел че се наште дин Иаков домнеште ка стэпынитор Ши перде пе чей че скапэ дин четэць.’” ");
INSERT INTO ron1924_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Балаам а вэзут пе Амалек ши а ростит урмэтоаря пророчие: „Амалек есте чел динтый динтре нямурь, Дар ынтр-о зи ва фи нимичит.” ");
INSERT INTO ron1924_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Балаам а вэзут пе кениць ши а ростит урмэтоаря пророчие: „Локуинца та есте таре де тот Ши куйбул тэу есте пус пе стынкэ. ");
INSERT INTO ron1924_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Дар Каин ва фи пустиит, Пынэ че те ва луа принс Асур.” ");
INSERT INTO ron1924_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Балаам а ростит урмэтоаря пророчие: „Вай! Чине ва май путя трэи кынд ва фаче Думнезеу ачест лукру? ");
INSERT INTO ron1924_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Дар ниште корэбий вор вени дин Китим, Вор смери пе Асур, вор смери пе Ебер Ши ла урмэ вор фи нимичите ши еле.” ");
INSERT INTO ron1924_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Балаам с-а скулат, а плекат ши с-а ынторс акасэ. Балак а плекат ши ел акасэ. ");
INSERT INTO ron1924_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Исраел локуя ын Ситим ши попорул а ынчепут сэ се дя ла курвие ку фетеле луй Моаб. ");
INSERT INTO ron1924_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Еле ау пофтит попорул ла жертфеле думнезеилор лор, ши попорул а мынкат ши с-а ынкинат пынэ ла пэмынт ынаинтя думнезеилор лор. ");
INSERT INTO ron1924_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Исраел с-а алипит де Баал-Пеор, ши Домнул С-а апринс де мыние ымпотрива луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Домнул а зис луй Мойсе: „Стрынӂе пе тоате кэпетенииле попорулуй ши спынзурэ пе чей виноваць ынаинтя Домнулуй ын фаца соарелуй, пентру ка сэ се ынтоаркэ де ла Исраел мыния апринсэ а Домнулуй.” ");
INSERT INTO ron1924_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Мойсе а зис жудекэторилор луй Исраел: „Фиекаре дин вой сэ учидэ пе ачея динтре ай луй каре с-ау липит де Баал-Пеор.” ");
INSERT INTO ron1924_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Ши ятэ кэ ун бэрбат динтре копиий луй Исраел а венит ши а адус ла фраций луй пе о мадианитэ, суб окий луй Мойсе ши суб окий ынтреӂий адунэрь а копиилор луй Исраел, пе кынд плынӂяу ла уша кортулуй ынтылнирий. ");
INSERT INTO ron1924_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Ла ведеря ачестуй лукру, Финеас, фиул луй Елеазар, фиул преотулуй Аарон, с-а скулат дин мижлокул адунэрий ши а луат о сулицэ ын мынэ. ");
INSERT INTO ron1924_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","С-а луат дупэ омул ачела дин Исраел пынэ ын кортул луй, й-а стрэпунс прин пынтече пе амындой: атыт пе бэрбатул ачела дин Исраел, кыт ши пе фемея ачея. Ши а ынчетат астфел урӂия каре избукнисе принтре копиий луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Доуэзечь ши патру де мий ау мурит ловиць де урӂия ачея. ");
INSERT INTO ron1924_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","„Финеас, фиул луй Елеазар, фиул преотулуй Аарон, а абэтут мыния Мя де ла копиий луй Исраел прин рывна пе каре а авут-о пентру Мине ын мижлокул лор ши н-ам нимичит, ын мыния Мя, пе копиий луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Де ачея сэ спуй кэ ынкей ку ел ун легэмынт де паче. ");
INSERT INTO ron1924_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Ачеста ва фи пентру ел ши пентру сэмынца луй дупэ ел легэмынтул уней преоций вешниче, пентру кэ а фост плин де рывнэ пентру Думнезеул луй ши а фэкут испэшире пентру копиий луй Исраел.” ");
INSERT INTO ron1924_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Бэрбатул ачела дин Исраел каре а фост учис ымпреунэ ку мадианита се нумя Зимри, фиул луй Салу; ел ера кэпетения уней касе пэринтешть а симеоницилор. ");
INSERT INTO ron1924_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Фемея каре а фост учисэ се нумя Козби, фата луй Цур, кэпетения семинциилор ешите динтр-о касэ пэринтяскэ дин Мадиан. ");
INSERT INTO ron1924_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","„Привици-й пе мадианиць ка врэжмашь ши учидеци-й, ");
INSERT INTO ron1924_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","кэч ши ей ви с-ау арэтат врэжмашь, амэӂинду-вэ прин виклешугуриле лор, ын фапта луй Пеор ши ын фапта Козбией, фата уней кэпетений а луй Мадиан, сора лор, учисэ ын зиуа урӂией каре а авут лок ку прилежул фаптей луй Пеор.” ");
INSERT INTO ron1924_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Ын урма ачестей урӂий, Домнул а зис луй Мойсе ши луй Елеазар, фиул преотулуй Аарон: ");
INSERT INTO ron1924_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","„Фачець нумэрэтоаря ынтреӂий адунэрь а копиилор луй Исраел, де ла вырста де доуэзечь де ань ын сус, дупэ каселе пэринцилор лор, а тутурор челор дин Исраел каре сунт ын старе сэ поарте армеле.” ");
INSERT INTO ron1924_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Мойсе ши преотул Елеазар ле-ау ворбит ын кымпия Моабулуй, лынгэ Йордан, ын фаца Иерихонулуй. Ши ау зис: ");
INSERT INTO ron1924_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","„Сэ се факэ нумэрэтоаря, де ла вырста де доуэзечь де ань ын сус, кум порунчисе луй Мойсе ши копиилор луй Исраел Домнул, кынд ау ешит дин цара Еӂиптулуй.” ");
INSERT INTO ron1924_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Рубен, ынтыюл нэскут ал луй Исраел. Фиий луй Рубен ау фост: Енох, дин каре се кобоарэ фамилия енохицилор; Палу, дин каре се кобоарэ фамилия палуицилор; ");
INSERT INTO ron1924_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Хецрон, дин каре се кобоарэ фамилия хецроницилор; Карми, дин каре се кобоарэ фамилия кармицилор. ");
INSERT INTO ron1924_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Ачестя сунт фамилииле рубеницилор: чей ешиць ла нумэрэтоаре ау фост патрузечь ши трей де мий шапте суте трейзечь. ");
INSERT INTO ron1924_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Фиий луй Палу ау фост: Елиаб. ");
INSERT INTO ron1924_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Фиий луй Елиаб ау фост: Немуел, Датан ши Абирам. Датан ачеста ши Абирам ачеста ау фост дин чей че ерау кемаць ла адунаре ши каре с-ау рэскулат ымпотрива луй Мойсе ши Аарон, ын адунаря луй Коре, кынд ку рэскоала лор ымпотрива Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Пэмынтул шь-а дескис гура ши й-а ынгицит ымпреунэ ку Коре, кынд ау мурит чей че се адунасерэ ши кынд а мистуит фокул пе чей доуэ суте чинчзечь де оамень. Ей ау служит попорулуй ка пилдэ. ");
INSERT INTO ron1924_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Фиий луй Коре н-ау мурит. ");
INSERT INTO ron1924_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Фиий луй Симеон, дупэ фамилииле лор: дин Немуел се кобоарэ фамилия немуелицилор; дин Иамин, фамилия иаминицилор; дин Иакин, фамилия иакиницилор; ");
INSERT INTO ron1924_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","дин Зерах, фамилия зерахицилор; дин Саул, фамилия саулицилор. ");
INSERT INTO ron1924_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Ачестя сунт фамилииле симеоницилор: доуэзечь ши доуэ де мий доуэ суте. ");
INSERT INTO ron1924_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Фиий луй Гад дупэ фамилииле лор: дин Цефон се кобоарэ фамилия цефоницилор; дин Хагги, фамилия хагицилор; дин Шуни, фамилия шуницилор; ");
INSERT INTO ron1924_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","дин Озни, фамилия озницилор; дин Ери, фамилия ерицилор; ");
INSERT INTO ron1924_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","дин Арод, фамилия ародицилор; дин Арели, фамилия арелицилор. ");
INSERT INTO ron1924_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Ачестя сунт фамилииле фиилор луй Гад, дупэ чей ешиць ла нумэрэтоаре: патрузечь де мий чинч суте. ");
INSERT INTO ron1924_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Фиий луй Иуда: Ер ши Онан; дар Ер ши Онан ау мурит ын цара Канаанулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Ятэ фиий луй Иуда дупэ фамилииле лор: дин Шела се кобоарэ фамилия шеланицилор; дин Перец, фамилия перецицилор; дин Зерах, фамилия зерахицилор. ");
INSERT INTO ron1924_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Фиий луй Перец ау фост: Хецрон, дин каре се кобоарэ фамилия хецроницилор; Хамул, дин каре се кобоарэ фамилия хамулицилор. ");
INSERT INTO ron1924_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Ачестя сунт фамилииле луй Иуда дупэ нумэрэтоаря лор: шаптезечь ши шасе де мий чинч суте. ");
INSERT INTO ron1924_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Фиий луй Исахар дупэ фамилииле лор: дин Тола се кобоарэ фамилия толаицилор; дин Пува, фамилия пувицилор; ");
INSERT INTO ron1924_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","дин Иашуб, фамилия иашубицилор; дин Шимрон, фамилия шимроницилор. ");
INSERT INTO ron1924_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Ачестя сунт фамилииле луй Исахар, дупэ нумэрэтоаря лор: шайзечь ши патру де мий трей суте. ");
INSERT INTO ron1924_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Фиий луй Забулон дупэ фамилииле лор: дин Серед се кобоарэ фамилия середицилор; дин Елон, фамилия елоницилор; дин Иахлеел, фамилия иахлеелицилор. ");
INSERT INTO ron1924_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Ачестя сунт фамилииле забулоницилор, дупэ нумэрэтоаря лор: шайзечь де мий чинч суте. ");
INSERT INTO ron1924_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Фиий луй Иосиф, дупэ фамилииле лор: Манасе ши Ефраим. ");
INSERT INTO ron1924_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Фиий луй Манасе: дин Макир се кобоарэ фамилия макирицилор. Макир а нэскут пе Галаад. Дин Галаад се кобоарэ фамилия галаадицилор. ");
INSERT INTO ron1924_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Ятэ фиий луй Галаад: Иезер, дин каре се кобоарэ фамилия иезерицилор; Хелек, фамилия хелекицилор; ");
INSERT INTO ron1924_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Асриел, фамилия асриелицилор; Сихем, фамилия сихемицилор; ");
INSERT INTO ron1924_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Шемида, фамилия шемидаицилор; Хефер, фамилия хеферицилор. ");
INSERT INTO ron1924_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Целофхад, фиул луй Хефер, н-а авут фий, дар а авут фете. Ятэ нумеле фетелор луй Целофхад: Махла, Ноа, Хогла, Милка ши Тирца. ");
INSERT INTO ron1924_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Ачестя сунт фамилииле луй Манасе, дупэ нумэрэтоаря лор: чинчзечь ши доуэ де мий шапте суте. ");
INSERT INTO ron1924_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Ятэ фиий луй Ефраим, дупэ фамилииле лор: дин Шутелах се кобоарэ фамилия шутелахицилор; дин Бекер, фамилия бекерицилор; дин Тахан, фамилия таханицилор. ");
INSERT INTO ron1924_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Ятэ фиий луй Шутелах: дин Еран се кобоарэ фамилия ераницилор. ");
INSERT INTO ron1924_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Ачестя сунт фамилииле фиилор луй Ефраим, дупэ нумэрэтоаря лор: трейзечь ши доуэ де мий чинч суте. Ачештя сунт фиий луй Иосиф, дупэ фамилииле лор. ");
INSERT INTO ron1924_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Фиий луй Бениамин, дупэ фамилииле лор: дин Бела се кобоарэ фамилия белаицилор; дин Ашбел, фамилия ашбелицилор; дин Ахирам, фамилия ахирамицилор; ");
INSERT INTO ron1924_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","дин Шуфам, фамилия шуфамицилор; дин Хуфам, фамилия хуфамицилор. ");
INSERT INTO ron1924_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Фиий луй Бела ау фост: Ард ши Нааман. Дин Ард се кобоарэ фамилия ардицилор; дин Нааман, фамилия нааманицилор. ");
INSERT INTO ron1924_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Ачештя сунт фиий луй Бениамин, дупэ фамилииле лор ши дупэ нумэрэтоаря лор: патрузечь ши чинч де мий шасе суте. ");
INSERT INTO ron1924_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Ятэ фиий луй Дан, дупэ фамилииле лор: дин Шухам се кобоарэ фамилия шухамицилор. Ачестя сунт фамилииле луй Дан, дупэ фамилииле лор. ");
INSERT INTO ron1924_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Тоате фамилииле шухамицилор, дупэ нумэрэтоаря лор: шайзечь ши патру де мий патру суте. ");
INSERT INTO ron1924_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Фиий луй Ашер дупэ фамилииле лор: дин Имна се кобоарэ фамилия имницилор; дин Ишви, фамилия ишвицилор; дин Берия, фамилия бериицилор. ");
INSERT INTO ron1924_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Дин фиий луй Берия се кобоарэ: дин Хебер, фамилия хеберицилор; дин Малкиел, фамилия малкиелицилор. ");
INSERT INTO ron1924_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Нумеле фетей луй Ашер ера Серах. ");
INSERT INTO ron1924_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Ачестя сунт фамилииле фиилор луй Ашер, дупэ нумэрэтоаря лор: чинчзечь ши трей де мий патру суте. ");
INSERT INTO ron1924_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Фиий луй Нефтали, дупэ фамилииле лор: дин Иахцеел се кобоарэ фамилия иахцеелицилор; дин Гуни, фамилия гуницилор; ");
INSERT INTO ron1924_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","дин Иецер, фамилия иецерицилор; дин Шилем, фамилия шилемицилор. ");
INSERT INTO ron1924_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Ачестя сунт фамилииле луй Нефтали дупэ фамилииле лор ши дупэ нумэрэтоаря лор: патрузечь ши чинч де мий патру суте. ");
INSERT INTO ron1924_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Ачештя сунт чей ешиць ла нумэрэтоаре динтре копиий луй Исраел: шасе суте уна мий шапте суте трейзечь. ");
INSERT INTO ron1924_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Домнул а ворбит луй Мойсе ши й-а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","„Цара сэ се ымпартэ ынтре ей, ка сэ фие моштениря лор, дупэ нумэрул нумелор. ");
INSERT INTO ron1924_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Челор че сунт ын нумэр май маре сэ ле дай о парте май маре, ши челор че сунт ын нумэр май мик сэ ле дай о парте май микэ; сэ се дя фиекэруя партя луй дупэ чей ешиць ла нумэрэтоаре. ");
INSERT INTO ron1924_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Дар ымпэрциря цэрий сэ се факэ прин сорць; с-о я ын стэпынире дупэ нумеле семинциилор пэринцилор лор. ");
INSERT INTO ron1924_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Цара сэ фие ымпэрцитэ прин сорць ынтре чей че сунт ын маре нумэр ши ынтре чей че сунт ын мик нумэр.” ");
INSERT INTO ron1924_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Ятэ левиций а кэрор нумэрэтоаре с-а фэкут дупэ фамилииле лор: дин Гершон се кобоарэ фамилия гершоницилор; дин Кехат, фамилия кехатицилор; дин Мерари, фамилия мерарицилор. ");
INSERT INTO ron1924_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Ятэ фамилииле луй Леви: фамилия либницилор, фамилия хеброницилор, фамилия махлицилор, фамилия мушицилор, фамилия корицилор. Кехат а нэскут пе Амрам. ");
INSERT INTO ron1924_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Нумеле невестей луй Амрам ера Иокебед, фата луй Леви, каре и с-а нэскут луй Леви ын Еӂипт; еа а нэскут луй Амрам пе Аарон, пе Мойсе ши пе Мария, сора лор. ");
INSERT INTO ron1924_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Луй Аарон и с-ау нэскут: Надаб ши Абиху, Елеазар ши Итамар. ");
INSERT INTO ron1924_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Надаб ши Абиху ау мурит кынд ау адус ынаинтя Домнулуй фок стрэин. ");
INSERT INTO ron1924_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Чей ешиць ла нумэрэтоаре, тоць бэрбаций де ла вырста де о лунэ ын сус, ау фост де доуэзечь ши трей де мий. Ей н-ау фост куприншь ын нумэрэтоаря копиилор луй Исраел, пентру кэ ну ли с-а дат моштенире ын мижлокул копиилор луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Ачештя сунт ачея динтре копиий луй Исраел а кэрор нумэрэтоаре ау фэкут-о Мойсе ши преотул Елеазар ын кымпия Моабулуй, лынгэ Йордан, ын фаца Иерихонулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Ынтре ей, ну ера ничунул дин копиий луй Исраел а кэрор нумэрэтоаре о фэкусе Мойсе ши преотул Аарон ын пустиул Синай. ");
INSERT INTO ron1924_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Кэч Домнул зисесе: „Вор мури ын пустиу ши ну ва рэмыне ничунул дин ей, афарэ де Калеб, фиул луй Иефуне, ши Иосуа, фиул луй Нун.” ");
INSERT INTO ron1924_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Фетеле луй Целофхад, фиул луй Хефер, фиул луй Галаад, фиул луй Макир, фиул луй Манасе, дин фамилииле луй Манасе, фиул луй Иосиф, ши але кэрор нуме ерау: Махла, Ноа, Хогла, Милка ши Тирца, ");
INSERT INTO ron1924_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","с-ау апропият ши с-ау ынфэцишат ынаинтя луй Мойсе, ынаинтя преотулуй Елеазар, ынаинтя май-марилор ши ынаинтя ынтреӂий адунэрь, ла уша кортулуй ынтылнирий. Еле ау зис: ");
INSERT INTO ron1924_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","„Татэл ностру а мурит ын пустиу; ел ну ера ын мижлокул четей челор че с-ау рэзврэтит ымпотрива Домнулуй, ын мижлокул четей луй Коре, чи а мурит пентру пэкатул луй ши н-а авут фий. ");
INSERT INTO ron1924_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Пентру че сэ се стингэ нумеле татэлуй ностру дин мижлокул фамилией луй, пентру кэ н-а авут фий? Дэ-не ши ноуэ деч о моштенире ынтре фраций татэлуй ностру.” ");
INSERT INTO ron1924_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Мойсе а адус причина лор ынаинтя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Ши Домнул а зис луй Мойсе: ");
INSERT INTO ron1924_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","„Фетеле луй Целофхад ау дрептате. Сэ ле дай де моштенире о мошие ынтре фраций татэлуй лор ши сэ тречь асупра лор моштениря татэлуй лор. ");
INSERT INTO ron1924_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Яр копиилор луй Исраел сэ ле ворбешть ши сэ ле спуй: Кынд ун ом ва мури фэрэ сэ ласе фий, сэ тречець моштениря луй асупра фетей луй. ");
INSERT INTO ron1924_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Дакэ н-аре ничо фатэ, моштениря луй с-о даць фрацилор луй. ");
INSERT INTO ron1924_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Дакэ н-аре нич фраць, моштениря луй с-о даць фрацилор татэлуй сэу. ");
INSERT INTO ron1924_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Ши, дакэ нич татэл луй н-аре фраць, моштениря луй с-о даць рудей челей май апропияте дин фамилия луй ши еа с-о стэпыняскэ. Ачаста сэ фие о леӂе ши ун дрепт пентру копиий луй Исраел, кум а порунчит луй Мойсе Домнул.” ");
INSERT INTO ron1924_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Домнул а зис луй Мойсе: „Суе-те пе мунтеле ачеста Абарим ши привеште цара пе каре ам дат-о копиилор луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","С-о привешть, дар ши ту вей фи адэугат ла попорул тэу, кум а фост адэугат фрателе тэу Аарон, ");
INSERT INTO ron1924_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","пентру кэ в-аць ымпотривит порунчий Меле ын пустиул Цин, кынд ку чарта адунэрий, ши ну М-аць сфинцит ынаинтя лор ку прилежул апелор.” (Ачестя сунт апеле де чартэ, ла Кадес, ын пустиул Цин.) ");
INSERT INTO ron1924_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Мойсе а ворбит Домнулуй ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","„Домнул Думнезеул духурилор орькэруй труп сэ рындуяскэ песте адунаре ун ом ");
INSERT INTO ron1924_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","каре сэ ясэ ынаинтя лор ши сэ интре ынаинтя лор, каре сэ-й скоатэ афарэ ши сэ-й выре ынэунтру, пентру ка адунаря Домнулуй сэ ну фие ка ниште ой каре н-ау пэстор.” ");
INSERT INTO ron1924_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Домнул а зис луй Мойсе: „Я-ць пе Иосуа, фиул луй Нун, бэрбат ын каре есте Духул Меу, ши сэ-ць пуй мына песте ел. ");
INSERT INTO ron1924_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Сэ-л ашезь ынаинтя преотулуй Елеазар ши ынаинтя ынтреӂий адунэрь ши сэ-й дай порунчь суб окий лор. ");
INSERT INTO ron1924_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Сэ-л фачь пэрташ ла дрегэтория та, пентру ка тоатэ адунаря копиилор луй Исраел сэ-л аскулте. ");
INSERT INTO ron1924_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Сэ се ынфэцишезе ынаинтя преотулуй Елеазар, каре сэ ынтребе пентру ел жудеката луй Урим ынаинтя Домнулуй, ши Иосуа, тоць копиий луй Исраел, ымпреунэ ку ел, ши тоатэ адунаря сэ ясэ дупэ порунка луй Елеазар ши сэ интре дупэ порунка луй.” ");
INSERT INTO ron1924_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Мойсе а фэкут кум ый порунчисе Домнул. А луат пе Иосуа ши л-а пус ынаинтя преотулуй Елеазар ши ынаинтя ынтреӂий адунэрь. ");
INSERT INTO ron1924_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Шь-а пус мыниле песте ел ши й-а дат порунчь, кум спусесе Домнул прин Мойсе. ");
INSERT INTO ron1924_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","„Порунчеште копиилор луй Исраел ши спуне-ле: ‘Сэ авець грижэ сэ-Мь адучець, ла время хотэрытэ, дарул Меу де мынкаре, храна жертфелор Меле мистуите де фок, каре Ымь сунт де ун плэкут мирос.’ ");
INSERT INTO ron1924_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Сэ ле спуй: ‘Ятэ жертфа мистуитэ де фок пе каре о вець адуче Домнулуй: ын фиекаре зи, кыте дой мей де ун ан фэрэ кусур, ка ардере-де-тот некурматэ. ");
INSERT INTO ron1924_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Сэ адучь ун мел диминяца ши челэлалт мел сяра, ");
INSERT INTO ron1924_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","яр, ка дар де мынкаре, сэ адучь а зечя парте динтр-о ефэ де флоаря фэиний фрэмынтатэ ынтр-ун сферт де хин де унтделемн де мэслине сфэрымате. ");
INSERT INTO ron1924_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Ачаста есте ардеря-де-тот некурматэ каре а фост адусэ ла мунтеле Синай; о жертфэ мистуитэ де фок де ун мирос плэкут Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Жертфа де бэутурэ сэ фие де ун сферт де хин пентру фиекаре мел; жертфа де бэутурэ де вин с-о фачь Домнулуй ын Локул Сфынт. ");
INSERT INTO ron1924_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Ал дойля мел сэ-л адучь сяра, ку ун дар де мынкаре ши о жертфэ де бэутурэ ка челе де диминяцэ; ачаста есте о жертфэ мистуитэ прин фок, де ун мирос плэкут Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Ын зиуа Сабатулуй, сэ адучець дой мей де ун ан фэрэ кусур ши, ка дар де мынкаре, доуэ зечимь де ефэ дин флоаря фэиний фрэмынтатэ ку унтделемн, ымпреунэ ку жертфа де бэутурэ. ");
INSERT INTO ron1924_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Ачаста есте ардеря-де-тот пентру фиекаре зи де Сабат, афарэ де ардеря-де-тот некурматэ ши жертфа ей де бэутурэ. ");
INSERT INTO ron1924_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Ла ынчепутул лунилор воастре, сэ адучець, ка ардере-де-тот Домнулуй, дой вицей, ун бербек ши шапте мей де ун ан фэрэ кусур ");
INSERT INTO ron1924_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","ши, ка дар де мынкаре пентру фиекаре вицел, трей зечимь де ефэ дин флоаря фэиний фрэмынтатэ ку унтделемн; ка дар де мынкаре пентру бербек, сэ адучець доуэ зечимь де ефэ дин флоаря фэиний фрэмынтатэ ку унтделемн; ");
INSERT INTO ron1924_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","ка дар де мынкаре пентру фиекаре мел, сэ адучець о зечиме де ефэ дин флоаря фэиний фрэмынтатэ ку унтделемн. Ачаста есте о ардере-де-тот, о жертфэ мистуитэ де фок де ун мирос плэкут Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Жертфеле де бэутурэ сэ фие де о жумэтате де хин де вин пентру ун вицел, а трея парте динтр-ун хин пентру ун бербек ши ун сферт де хин пентру ун мел. Ачаста есте ардеря-де-тот пентру ынчепутул луний, ын фиекаре лунэ, ын тоате луниле анулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Сэ се адукэ Домнулуй ун цап ка жертфэ де испэшире, афарэ де ардеря-де-тот некурматэ ши жертфа ей де бэутурэ. ");
INSERT INTO ron1924_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Ын луна ынтый, ын зиуа а пайспрезечя а луний, вор фи Паштеле Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Зиуа а чинчспрезечя а ачестей лунь сэ фие о зи де сэрбэтоаре. Тимп де шапте зиле сэ се мэнынче азиме. ");
INSERT INTO ron1924_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Ын зиуа динтый, сэ фие о адунаре сфынтэ: сэ ну фачець ничо лукраре де слугэ ын еа. ");
INSERT INTO ron1924_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Сэ адучець ка ардере-де-тот Домнулуй о жертфэ мистуитэ де фок: дой вицей, ун бербек ши шапте мей де ун ан фэрэ кусур. ");
INSERT INTO ron1924_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Сэ май адэугаць ши дарул лор де мынкаре дин флоаря фэиний фрэмынтатэ ку унтделемн, трей зечимь де ефэ пентру ун вицел, доуэ зечимь пентру ун бербек ");
INSERT INTO ron1924_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","ши о зечиме пентру фиекаре дин чей шапте мей. ");
INSERT INTO ron1924_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Сэ адучець ун цап ка жертфэ де испэшире, ка сэ факэ испэшире пентру вой. ");
INSERT INTO ron1924_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Сэ адучець ачесте жертфе, афарэ де ардеря-де-тот де диминяцэ, каре есте о ардере-де-тот некурматэ. ");
INSERT INTO ron1924_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Сэ ле адучець ын фиекаре зи, тимп де шапте зиле, ка храна уней жертфе мистуите де фок, де ун мирос плэкут Домнулуй. Сэ фие адусе афарэ де ардеря-де-тот некурматэ ши жертфа ей де бэутурэ. ");
INSERT INTO ron1924_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Ын зиуа а шаптя сэ авець о адунаре сфынтэ: сэ ну фачець ничо лукраре де слугэ ын еа. ");
INSERT INTO ron1924_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Ын зиуа челор динтый роаде, кынд вець адуче Домнулуй ун дар де мынкаре, ла сэрбэтоаря ынкеерий сэптэмынилор, сэ авець о адунаре сфынтэ; сэ ну фачець ничо лукраре де слугэ ын еа. ");
INSERT INTO ron1924_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Сэ адучець ка ардере-де-тот де ун мирос плэкут Домнулуй: дой вицей, ун бербек ши шапте мей де ун ан. ");
INSERT INTO ron1924_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Сэ май адэугаць дарул лор де мынкаре дин флоаря фэиний фрэмынтатэ ку унтделемн, кыте трей зечимь де фиекаре вицел, доуэ зечимь пентру бербек ");
INSERT INTO ron1924_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","ши о зечиме пентру фиекаре дин чей шапте мей. ");
INSERT INTO ron1924_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Сэ адучець ши ун цап, ка сэ факэ испэшире пентру вой. ");
INSERT INTO ron1924_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Сэ адучець ачесте жертфе, афарэ де ардеря-де-тот некурматэ ши дарул ей де мынкаре. Меий сэ фие фэрэ кусур ши сэ адэугаць ши жертфеле лор де бэутурэ. ");
INSERT INTO ron1924_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Ын луна а шаптя, ын чя динтый зи а луний, сэ авець о адунаре сфынтэ: атунч сэ ну фачець ничо лукраре де слугэ. Зиуа ачаста сэ фие веститэ ынтре вой ку сунет де трымбицэ. ");
INSERT INTO ron1924_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Сэ адучець ка ардере-де-тот де ун мирос плэкут Домнулуй ун вицел, ун бербек ши шапте мей де ун ан фэрэ кусур. ");
INSERT INTO ron1924_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Сэ май адэугаць ши дарул лор де мынкаре дин флоаря фэиний фрэмынтатэ ку унтделемн, трей зечимь пентру вицел, доуэ зечимь пентру бербек ");
INSERT INTO ron1924_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","ши о зечиме пентру фиекаре дин чей шапте мей. ");
INSERT INTO ron1924_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Сэ адучець ши ун цап ка жертфэ де испэшире, ка сэ факэ испэшире пентру вой. ");
INSERT INTO ron1924_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Сэ адучець ачесте жертфе, афарэ де ардеря-де-тот ши дарул ей де мынкаре дин фиекаре лунэ, афарэ де ардеря-де-тот некурматэ, дарул ей де мынкаре ши жертфеле де бэутурэ каре се адаугэ ла еле, дупэ рындуелиле ашезате. Ачестя сунт ниште жертфе мистуите де фок, де ун мирос плэкут Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Ын зиуа а зечя а ачестей лунь а шаптя, сэ авець о адунаре сфынтэ ши сэ вэ смериць суфлетеле; атунч сэ ну фачець ничо лукраре. ");
INSERT INTO ron1924_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Сэ адучець ка ардере-де-тот де ун мирос плэкут Домнулуй: ун вицел, ун бербек ши шапте мей де ун ан фэрэ кусур. ");
INSERT INTO ron1924_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Сэ май адэугаць ши дарул лор де мынкаре дин флоаря фэиний фрэмынтатэ ку унтделемн, трей зечимь пентру вицел, доуэ зечимь пентру бербек ");
INSERT INTO ron1924_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","ши о зечиме пентру фиекаре дин чей шапте мей. ");
INSERT INTO ron1924_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Сэ адучець ши ун цап ка жертфэ де испэшире, афарэ де жертфа де испэшире, афарэ де ардеря-де-тот некурматэ ку дарул ей де мынкаре ши жертфеле де бэутурэ обишнуите. ");
INSERT INTO ron1924_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Ын зиуа а чинчспрезечя а луний а шаптя, сэ авець о адунаре сфынтэ; атунч сэ ну фачець ничо лукраре де слугэ. Сэ прэзнуиць о сэрбэтоаре ын чинстя Домнулуй тимп де шапте зиле. ");
INSERT INTO ron1924_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Сэ адучець, ка ардере-де-тот, о жертфэ мистуитэ де фок, де ун мирос плэкут Домнулуй: трейспрезече вицей, дой бербечь ши пайспрезече мей де ун ан фэрэ кусур. ");
INSERT INTO ron1924_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Сэ май адэугаць ши дарул лор де мынкаре дин флоаря фэиний фрэмынтатэ ку унтделемн, трей зечимь пентру фиекаре дин чей трейспрезече вицей, доуэ зечимь пентру фиекаре дин чей дой бербечь ");
INSERT INTO ron1924_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","ши о зечиме пентру фиекаре дин чей пайспрезече мей. ");
INSERT INTO ron1924_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Сэ адучець ши ун цап ка жертфэ де испэшире, афарэ де ардеря-де-тот некурматэ, дарул ей де мынкаре ши жертфа са де бэутурэ. ");
INSERT INTO ron1924_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","А доуа зи, сэ адучець дойспрезече вицей, дой бербечь ши пайспрезече мей де ун ан фэрэ кусур, ");
INSERT INTO ron1924_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","ымпреунэ ку дарул лор де мынкаре ши жертфеле лор де бэутурэ пентру вицей, бербечь ши мей, дупэ нумэрул лор, дупэ рындуелиле ашезате. ");
INSERT INTO ron1924_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Сэ адучець ши ун цап ка жертфэ де испэшире, афарэ де ардеря-де-тот некурматэ, дарул ей де мынкаре ши жертфеле де бэутурэ. ");
INSERT INTO ron1924_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","А трея зи, сэ адучець унспрезече вицей, дой бербечь ши пайспрезече мей де ун ан фэрэ кусур, ");
INSERT INTO ron1924_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","ымпреунэ ку дарул лор де мынкаре ши жертфеле лор де бэутурэ пентру вицей, бербечь ши мей, дупэ нумэрул лор, дупэ рындуелиле ашезате. ");
INSERT INTO ron1924_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Сэ адучець ши ун цап ка жертфэ де испэшире, афарэ де ардеря-де-тот некурматэ, дарул ей де мынкаре ши жертфа де бэутурэ. ");
INSERT INTO ron1924_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","А патра зи, сэ адучець зече вицей, дой бербечь ши пайспрезече мей де ун ан фэрэ кусур, ");
INSERT INTO ron1924_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","ымпреунэ ку дарул лор де мынкаре ши жертфеле лор де бэутурэ пентру вицей, бербечь ши мей, дупэ нумэрул лор, дупэ рындуелиле ашезате. ");
INSERT INTO ron1924_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Сэ адучець ши ун цап ка жертфэ де испэшире, афарэ де ардеря-де-тот некурматэ, дарул ей де мынкаре ши жертфа де бэутурэ. ");
INSERT INTO ron1924_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Ын зиуа а чинчя, сэ адучець ноуэ вицей, дой бербечь ши пайспрезече мей де ун ан фэрэ кусур, ");
INSERT INTO ron1924_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","ымпреунэ ку дарул лор де мынкаре ши жертфеле лор де бэутурэ пентру вицей, бербечь ши мей, дупэ нумэрул лор, дупэ рындуелиле ашезате. ");
INSERT INTO ron1924_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Сэ адучець ши ун цап ка жертфэ де испэшире, афарэ де ардеря-де-тот некурматэ, дарул ей де мынкаре ши жертфа де бэутурэ. ");
INSERT INTO ron1924_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Ын зиуа а шася, сэ адучець опт вицей, дой бербечь ши пайспрезече мей де ун ан фэрэ кусур, ");
INSERT INTO ron1924_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","ымпреунэ ку дарул лор де мынкаре ши жертфеле лор де бэутурэ пентру вицей, бербечь ши мей, дупэ нумэрул лор, дупэ рындуелиле ашезате. ");
INSERT INTO ron1924_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Сэ адучець ши ун цап ка жертфэ де испэшире, афарэ де ардеря-де-тот некурматэ, дарул ей де мынкаре ши жертфеле де бэутурэ. ");
INSERT INTO ron1924_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Ын зиуа а шаптя, сэ адучець шапте вицей, дой бербечь ши пайспрезече мей де ун ан фэрэ кусур, ");
INSERT INTO ron1924_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","ымпреунэ ку дарул лор де мынкаре ши жертфеле лор де бэутурэ пентру вицей, бербечь ши мей, дупэ нумэрул лор, дупэ рындуелиле ашезате. ");
INSERT INTO ron1924_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Сэ адучець ши ун цап ка жертфэ де испэшире, афарэ де ардеря-де-тот некурматэ, дарул ей де мынкаре ши жертфа де бэутурэ. ");
INSERT INTO ron1924_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Ын зиуа а опта, сэ авець о адунаре де сэрбэтоаре; атунч сэ ну фачець ничо лукраре де слугэ. ");
INSERT INTO ron1924_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Сэ адучець ка ардере-де-тот о жертфэ мистуитэ де фок, де ун мирос плэкут Домнулуй: ун вицел, ун бербек ши шапте мей де ун ан, фэрэ кусур, ");
INSERT INTO ron1924_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","ымпреунэ ку дарул лор де мынкаре ши жертфеле лор де бэутурэ пентру вицел, бербек ши мей, дупэ нумэрул лор, дупэ рындуелиле ашезате. ");
INSERT INTO ron1924_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Сэ адучець ши ун цап ка жертфэ де испэшире, афарэ де ардеря-де-тот некурматэ, дарул ей де мынкаре ши жертфа де бэутурэ. ");
INSERT INTO ron1924_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Ачестя сунт жертфеле пе каре сэ ле адучець Домнулуй ла сэрбэториле воастре, афарэ де ардериле воастре де тот, де даруриле воастре де мынкаре, де жертфеле воастре де бэутурэ ши де жертфеле воастре де мулцумире, ка ымплинире а уней журуинце сау ка дарурь де бунэвое.’” ");
INSERT INTO ron1924_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Мойсе а спус копиилор луй Исраел тот че-й порунчисе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Мойсе а ворбит кэпетениилор семинциилор копиилор луй Исраел ши а зис: „Ятэ че порунчеште Домнул. ");
INSERT INTO ron1924_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Кынд ун ом ва фаче о журуинцэ Домнулуй сау ун журэмынт прин каре се ва лега принтр-о фэгэдуялэ, сэ ну-шь калче кувынтул, чи сэ факэ потривит ку тот че й-а ешит дин гурэ. ");
INSERT INTO ron1924_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Кынд о фемее ва фаче о журуинцэ Домнулуй ши се ва лега принтр-о фэгэдуялэ ын тинереця ей ши ын каса татэлуй ей ");
INSERT INTO ron1924_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","ши татэл ей ва афла де журуинца пе каре а фэкут-о еа ши де фэгэдуяла ку каре с-а легат, дакэ ну-й зиче нимик ын зиуа кынд афлэ де журуинца ей, тоате журуинцеле ей вор фи примите ши орьче фэгэдуялэ ку каре с-а легат еа ва фи примитэ, ");
INSERT INTO ron1924_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","дар, дакэ татэл ей ну-й дэ вое ын зиуа кынд я куноштинцэ де журуинца ей, тоате журуинцеле ей ши тоате фэгэдуелиле ку каре се ва фи легат еа ну вор авя ничо тэрие; ши Домнул о ва ерта, пентру кэ ну й-а дат вое татэл ей. ");
INSERT INTO ron1924_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Кынд се ва мэрита, дупэ че а фэкут журуинце сау дупэ че с-а легат принтр-ун кувынт ешит де пе бузеле ей ");
INSERT INTO ron1924_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","ши бэрбатул ей ва луа куноштинцэ де лукрул ачеста ши ну-й ва зиче нимик ын зиуа кынд ва луа куноштинцэ де еле, журуинцеле ей вор рэмыне ын пичоаре ши фэгэдуелиле ку каре се ва фи легат еа вор рэмыне ын пичоаре, ");
INSERT INTO ron1924_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","дар, дакэ бэрбатул ей ну-й дэ вое ын зиуа кынд я куноштинцэ де журуинца ей, ел ва десфиинца журуинца пе каре а фэкут-о ши кувынтул скэпат де пе бузеле ей ку каре с-а легат еа ши Домнул о ва ерта. ");
INSERT INTO ron1924_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Журуинца уней фемей вэдуве сау деспэрците де бэрбат, фэгэдуинца ку каре се ва фи легат еа, ва рэмыне ын пичоаре пентру еа. ");
INSERT INTO ron1924_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Кынд о фемее, фиинд ынкэ ын каса бэрбатулуй ей, ва фаче журуинце сау се ва лега ку вреун журэмынт ");
INSERT INTO ron1924_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","ши бэрбатул ей ва афла де лукрул ачеста, дакэ ну-й зиче нимик ши н-о опреште, тоате журуинцеле ей вор рэмыне ын пичоаре ши тоате фэгэдуинцеле прин каре се ва фи легат еа вор рэмыне ын пичоаре, ");
INSERT INTO ron1924_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","дар, дакэ бэрбатул ей ну ле примеште ын зиуа кынд афлэ де еле, орьче журуинцэ ши орьче фэгэдуялэ ешите де пе бузеле ей ну вор авя ничун прец, бэрбатул ей ну ле-а примит; ши Домнул о ва ерта. ");
INSERT INTO ron1924_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Бэрбатул ей поате ынтэри ши бэрбатул ей поате десфиинца орьче журуинцэ, орьче журэмынт ку каре се лягэ еа ка сэ-шь мыхняскэ суфлетул. ");
INSERT INTO ron1924_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Ши ануме, дакэ ну-й зиче нимик зи де зи дупэ че афлэ де лукрул ачеста, ел ынтэреште астфел тоате журуинцеле ши тоате фэгэдуелиле ку каре с-а легат еа; ле ынтэреште пентру кэ ну й-а зис нимик ын зиуа кынд а афлат де еле. ");
INSERT INTO ron1924_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Дар, дакэ ну ле примеште, дупэ че а трекут зиуа ын каре ле-а афлат, ва фи виноват де пэкатул невестей луй.” ");
INSERT INTO ron1924_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Ачестя сунт леӂиле пе каре ле-а дат луй Мойсе Домнул, ка сэ айбэ путере ынтре ун бэрбат ши неваста луй, ынтре ун татэ ши фата луй, кынд еа есте ын тинереце ши акасэ ла татэл ей. ");
INSERT INTO ron1924_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","„Рэзбунэ пе копиий луй Исраел ымпотрива мадианицилор, апой вей фи адэугат ла попорул тэу.” ");
INSERT INTO ron1924_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Мойсе а ворбит попорулуй ши а зис: „Ынармаць динтре вой ниште бэрбаць пентру оштире ши сэ мяргэ ымпотрива Мадианулуй, ка сэ адукэ ла ындеплинире рэзбунаря Домнулуй ымпотрива Мадианулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Сэ тримитець ла оасте кыте о мие де оамень де семинцие, дин тоате семинцииле луй Исраел.” ");
INSERT INTO ron1924_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Ау луат динтре мииле луй Исраел кыте о мие де оамень де семинцие, адикэ доуэспрезече мий де оамень ынармаць пентру оасте. ");
INSERT INTO ron1924_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Мойсе а тримис ла оасте пе ачешть о мие де оамень де семинцие ши а тримис ку ей пе фиул преотулуй Елеазар, Финеас, каре дучя унелтеле сфинте ши трымбицеле рэсунэтоаре. ");
INSERT INTO ron1924_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Ау ынаинтат ымпотрива Мадианулуй, дупэ порунка пе каре о дэдусе луй Мойсе Домнул, ши ау оморыт пе тоць бэрбаций. ");
INSERT INTO ron1924_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Ымпреунэ ку тоць чейлалць, ау оморыт ши пе ымпэраций Мадианулуй: Еви, Рекем, Цур, Хур ши Реба, чей чинч ымпэраць ай Мадианулуй; ау учис ку сабия ши пе Балаам, фиул луй Беор. ");
INSERT INTO ron1924_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Копиий луй Исраел ау луат принсе пе фемеиле мадианицилор ку прунчий лор ши ле-ау жефуит тоате вителе, тоате турмеле ши тоате богэцииле. ");
INSERT INTO ron1924_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Ле-ау арс тоате четэциле пе каре ле локуяу ши тоате окоалеле лор. ");
INSERT INTO ron1924_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Ау луат тоатэ прада ши тоате жафуриле де оамень ши добитоаче, ");
INSERT INTO ron1924_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","ши пе чей приншь, прада ши жафуриле ле-ау адус луй Мойсе, преотулуй Елеазар ши адунэрий копиилор луй Исраел, каре ерау тэбэрыць ын кымпия Моабулуй, лынгэ Йордан, ын фаца Иерихонулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Мойсе, преотул Елеазар ши тоць май-марий адунэрий ле-ау ешит ынаинте, афарэ дин табэрэ. ");
INSERT INTO ron1924_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Ши Мойсе с-а мыният пе кэпетенииле оштирий, пе кэпетенииле песте о мие ши пе кэпетенииле песте о сутэ каре се ынторчяу де ла рэзбой. ");
INSERT INTO ron1924_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Ел ле-а зис: „Кум? Аць лэсат ку вяцэ пе тоате фемеиле? ");
INSERT INTO ron1924_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Ятэ, еле сунт ачеля каре, дупэ кувынтул луй Балаам, ау тырыт пе копиий луй Исраел сэ пэкэтуяскэ ымпотрива Домнулуй, ын фапта луй Пеор, ши атунч а избукнит урӂия ын адунаря Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Акум дар оморыць пе орьче прунк де парте бэрбэтяскэ ши оморыць пе орьче фемее каре а куноскут пе ун бэрбат кулкынду-се ку ел, ");
INSERT INTO ron1924_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","дар лэсаць ку вяцэ пентру вой тоць прунчий де парте фемеяскэ ши пе тоате фетеле каре н-ау куноскут ымпреунаря ку ун бэрбат. ");
INSERT INTO ron1924_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Яр вой тэбэрыць шапте зиле афарэ дин табэрэ; тоць ачея динтре вой каре ау учис пе чинева ши тоць чей че с-ау атинс де вреун морт сэ се курэцяскэ а трея ши а шаптя зи, ей ши чей приншь де вой. ");
INSERT INTO ron1924_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Сэ курэциць, де асеменя, орьче хайнэ, орьче лукру де пеле, орьче лукру де пэр де капрэ ши орьче унялтэ де лемн.” ");
INSERT INTO ron1924_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Преотул Елеазар а зис осташилор каре се дусесерэ ла рэзбой: „Ятэ че есте порунчит прин леӂя пе каре а дат-о луй Мойсе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Аурул, арӂинтул, арама, ферул, коситорул ши плумбул, ");
INSERT INTO ron1924_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","орьче лукру каре поате суфери фокул, сэ-л тречець прин фок ка сэ се курэцяскэ. Дар тот че ну поате суфери фокул сэ фие курэцит ку апа де курэцире; сэ-л тречець прин апэ. ");
INSERT INTO ron1924_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Сэ вэ спэлаць хайнеле ын зиуа а шаптя ши вець фи кураць, апой вець путя интра ын табэрэ.” ");
INSERT INTO ron1924_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Домнул а зис луй Мойсе: ");
INSERT INTO ron1924_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","„Фэ, ымпреунэ ку преотул Елеазар ши ку кэпетенииле каселор адунэрий, сокотяла прэзий луате, фие оамень, фие добитоаче. ");
INSERT INTO ron1924_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Ымпарте прада ынтре луптэторий каре с-ау дус ла оасте ши ынтре тоатэ адунаря. ");
INSERT INTO ron1924_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Сэ ей ынтый дин партя осташилор каре с-ау дус ла оасте о даре пентру Домнул, ши ануме унул дин чинч суте, атыт дин оамень, кыт ши дин бой, мэгарь ши ой. ");
INSERT INTO ron1924_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Сэ ле ей дин жумэтатя кувенитэ лор ши сэ ле дай преотулуй Елеазар, ка ун дар ридикат пентру Домнул. ");
INSERT INTO ron1924_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Ши дин жумэтатя каре се кувине копиилор луй Исраел сэ ей унул дин чинчзечь, атыт дин оамень, кыт ши дин бой, мэгарь ши ой, дин орьче добиток, ши сэ ле дай левицилор каре пэзеск кортул Домнулуй.” ");
INSERT INTO ron1924_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Мойсе ши преотул Елеазар ау фэкут че порунчисе луй Мойсе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Прада де рэзбой, рэмасэ дин жафул челор че фэкусерэ парте дин оасте, ера де шасе суте шаптезечь ши чинч де мий де ой, ");
INSERT INTO ron1924_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","шаптезечь ши доуэ де мий де бой, ");
INSERT INTO ron1924_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","шайзечь ши уну де мий де мэгарь ");
INSERT INTO ron1924_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","ши трейзечь ши доуэ де мий де суфлете, адикэ фемей каре ну куноскусерэ ымпреунаря ку ун бэрбат. ");
INSERT INTO ron1924_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Жумэтатя каре алкэтуя партя челор че се дусесерэ ла оасте а фост де трей суте трейзечь ши шапте де мий чинч суте де ой, ");
INSERT INTO ron1924_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","дин каре шасе суте шаптезечь ши чинч ау фост луаць ка даре Домнулуй; ");
INSERT INTO ron1924_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","трейзечь ши шасе де мий де бой, дин каре шаптезечь ши дой луаць ка даре Домнулуй; ");
INSERT INTO ron1924_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","трейзечь де мий чинч суте де мэгарь, дин каре шайзечь ши уну луаць ка даре Домнулуй, ");
INSERT INTO ron1924_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","ши шайспрезече мий де иншь, дин каре трейзечь ши дой луаць ка даре Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Мойсе а дат преотулуй Елеазар даря луатэ ка дар ридикат пентру Домнул, дупэ кум ый порунчисе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Жумэтатя кувенитэ копиилор луй Исраел, пе каре а деспэрцит-о Мойсе де а бэрбацилор каре мерсесерэ ла оасте ");
INSERT INTO ron1924_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","ши каре ера партя адунэрий, а фост де трей суте трейзечь ши шапте де мий чинч суте де ой, ");
INSERT INTO ron1924_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","трейзечь ши шасе де мий де бой, ");
INSERT INTO ron1924_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","трейзечь де мий чинч суте де мэгарь ");
INSERT INTO ron1924_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","ши шайспрезече мий де суфлете. ");
INSERT INTO ron1924_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Дин ачастэ жумэтате каре се кувеня копиилор луй Исраел, Мойсе а луат унул дин чинчзечь, атыт дин оамень, кыт ши дин добитоаче, ши ле-а дат левицилор каре пэзеск кортул Домнулуй, дупэ кум ый порунчисе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Кэпетенииле оштирий, кэпетенииле песте о мие ши кэпетенииле песте о сутэ с-ау апропият де Мойсе ");
INSERT INTO ron1924_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","ши й-ау зис: „Робий тэй ау фэкут сокотяла осташилор каре ерау суб порунчиле ноастре ши ну липсеште ничун ом динтре ной. ");
INSERT INTO ron1924_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Ной адучем деч ка дар Домнулуй фиекаре че а гэсит ка скуле де аур, ши ануме лэнцишоаре, брэцэрь, инеле, черчей ши салбе, ка сэ се факэ испэшире пентру суфлетеле ноастре ынаинтя Домнулуй.” ");
INSERT INTO ron1924_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Мойсе ши преотул Елеазар ау примит де ла ей тоате ачесте скуле лукрате ын аур. ");
INSERT INTO ron1924_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Тот аурул пе каре л-ау адус Домнулуй кэпетенииле песте о мие ши кэпетенииле песте о сутэ, ка дар ридикат, кынтэря шайспрезече мий шапте суте чинчзечь де сикли. ");
INSERT INTO ron1924_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Оамений дин оасте ау пэстрат, фиекаре пентру сине, прада пе каре о фэкусерэ. ");
INSERT INTO ron1924_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Мойсе ши преотул Елеазар ау луат аурул де ла кэпетенииле песте о мие ши де ла кэпетенииле песте о сутэ ши л-ау адус ын кортул ынтылнирий, ка адучере аминте пентру копиий луй Исраел ынаинтя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Фиий луй Рубен ши фиий луй Гад авяу о маре мулциме де вите ши ау вэзут кэ цара луй Иаезер ши цара Галаадулуй ерау ун лок бун пентру вите. ");
INSERT INTO ron1924_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Атунч, фиий луй Гад ши фиий луй Рубен ау венит ла Мойсе, ла преотул Елеазар ши ла май-марий адунэрий ши ле-ау зис: ");
INSERT INTO ron1924_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","„Атарот, Дибон, Иаезер, Нимра, Хесбон, Елеале, Себам, Небо ши Беон, ");
INSERT INTO ron1924_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","цара ачаста пе каре а ловит-о Домнул ынаинтя адунэрий луй Исраел есте ун лок бун пентру вите, ши робий тэй ау вите.” ");
INSERT INTO ron1924_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Апой ау адэугат: „Дакэ ам кэпэтат тречере ынаинтя та, сэ се дя цара ачаста ын стэпыниря робилор тэй ши сэ ну не тречь песте Йордан.” ");
INSERT INTO ron1924_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Мойсе а рэспунс фиилор луй Гад ши фиилор луй Рубен: „Фраций воштри сэ мяргэ оаре ла рэзбой, ши вой сэ рэмынець аич? ");
INSERT INTO ron1924_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Пентру че воиць сэ ынмуяць инима копиилор луй Исраел ши сэ-й фачець сэ ну трякэ ын цара пе каре ле-о дэ Домнул? ");
INSERT INTO ron1924_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Аша ау фэкут ши пэринций воштри кынд й-ам тримис дин Кадес-Барня сэ искодяскэ цара. ");
INSERT INTO ron1924_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","С-ау суит пынэ ла валя Ешкол ши, дупэ че ау искодит цара, ау ынмуят инима копиилор луй Исраел ши й-ау фэкут сэ ну интре ын цара пе каре ле-о дэдя Домнул. ");
INSERT INTO ron1924_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Ши Домнул С-а апринс де мыние ын зиуа ачея ши а журат зикынд: ");
INSERT INTO ron1924_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘Оамений ачештя каре с-ау суит дин Еӂипт, де ла вырста де доуэзечь де ань ын сус, ну вор ведя цара пе каре ам журат кэ о вой да луй Авраам, луй Исаак ши луй Иаков, кэч н-ау урмат ын тотул каля Мя, ");
INSERT INTO ron1924_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","афарэ де Калеб, фиул луй Иефуне, Кенизитул, ши Иосуа, фиул луй Нун, каре ау урмат ын тотул каля Домнулуй.’ ");
INSERT INTO ron1924_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Домнул С-а апринс де мыние ымпотрива луй Исраел ши й-а фэкут сэ рэтэчяскэ ын пустиу тимп де патрузечь де ань, пынэ ла стинӂеря ынтрегулуй лят де оамень каре фэкусерэ рэу ынаинтя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Ши ятэ кэ вой луаць локул пэринцилор воштри, ка ниште одрасле де оамень пэкэтошь, ка сэ фачець пе Домнул сэ Се априндэ ши май таре де мыние ымпотрива луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Кэч, дакэ вэ ынтоарчець де ла Ел, Ел ва лэса май департе пе Исраел сэ рэтэчяскэ ын пустиу ши вець адуче пердеря попорулуй ачестуя ынтрег.” ");
INSERT INTO ron1924_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Ей с-ау апропият де Мойсе ши ау зис: „Вом фаче аич окоале пентру вителе ноастре ши четэць пентру прунчий ноштри, ");
INSERT INTO ron1924_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","апой не вом ынарма ын грабэ ши вом мерӂе ынаинтя копиилор луй Исраел, пынэ ый вом дуче ын локул каре ле есте рындуит, ши прунчий ноштри вор локуи ын ачесте четэць ынтэрите, дин причина локуиторилор цэрий ачестея. ");
INSERT INTO ron1924_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Ну не вом ынтоарче ын каселе ноастре май ынаинте ка фиекаре дин копиий луй Исраел сэ фи пус стэпынире пе моштениря луй ");
INSERT INTO ron1924_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","ши ну вом стэпыни нимик ку ей динколо де Йордан, нич май департе, пентру кэ ной не вом авя моштениря ноастрэ динкоаче де Йордан, ла рэсэрит.” ");
INSERT INTO ron1924_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Мойсе ле-а зис: „Дакэ фачець аша, дакэ вэ ынармаць ка сэ луптаць ынаинтя Домнулуй, ");
INSERT INTO ron1924_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","дакэ тоць ачея динтре вой каре се вор ынарма трек Йорданул ынаинтя Домнулуй, пынэ че ва изгони пе врэжмаший Луй динаинтя Луй, ");
INSERT INTO ron1924_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","ши дакэ вэ вець ынтоарче ынапой нумай дупэ че цара ва фи супусэ ынаинтя Домнулуй, атунч вець фи фэрэ винэ ынаинтя Домнулуй ши ынаинтя луй Исраел, ши цинутул ачеста ва фи мошия воастрэ ынаинтя Домнулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Дар, дакэ ну фачець аша, пэкэтуиць ымпотрива Домнулуй ши сэ штиць кэ пэкатул востру вэ ва ажунӂе. ");
INSERT INTO ron1924_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Зидиць четэць пентру прунчий воштри ши окоале пентру вителе воастре ши фачець че аць спус ку гура воастрэ.” ");
INSERT INTO ron1924_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Фиий луй Гад ши фиий луй Рубен ау зис луй Мойсе: „Робий тэй вор фаче тот че порунчеште домнул ностру. ");
INSERT INTO ron1924_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Прунчий ноштри, невестеле, турмеле ноастре ши тоате вителе ноастре вор рэмыне ын четэциле Галаадулуй, ");
INSERT INTO ron1924_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","яр робий тэй, тоць ынармаць пентру рэзбой, вор мерӂе сэ се лупте ынаинтя Домнулуй, кум зиче домнул ностру.” ");
INSERT INTO ron1924_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Мойсе а дат порунчь ку привире ла ей преотулуй Елеазар, луй Иосуа, фиул луй Нун, ши капилор де фамилие дин семинцииле копиилор луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Ел ле-а зис: „Дакэ фиий луй Гад ши фиий луй Рубен трек ку вой Йорданул, ынармаць ку тоций ка сэ лупте ынаинтя Домнулуй, дупэ че цара ва фи супусэ ынаинтя воастрэ, сэ ле даць ын стэпынире цинутул Галаадулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Дар дакэ ну вор мерӂе ынармаць ымпреунэ ку вой, сэ се ашезе ын мижлокул востру ын цара Канаанулуй.” ");
INSERT INTO ron1924_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Фиий луй Гад ши фиий луй Рубен ау рэспунс: „Вом фаче тот че а спус робилор тэй Домнул. ");
INSERT INTO ron1924_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Вом трече ынармаць ынаинтя Домнулуй ын цара Канаанулуй, дар ной сэ не авем моштениря ноастрэ динкоаче де Йордан.” ");
INSERT INTO ron1924_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Мойсе а дат фиилор луй Гад ши фиилор луй Рубен ши ла жумэтате дин семинция луй Манасе, фиул луй Иосиф, ымпэрэция луй Сихон, ымпэратул аморицилор, ши ымпэрэция луй Ог, ымпэратул Басанулуй, цара ку четэциле ей, ку цинутуриле четэцилор цэрий де жур ымпрежур. ");
INSERT INTO ron1924_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Фиий луй Гад ау зидит Дибонул, Атаротул, Ароерул, ");
INSERT INTO ron1924_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Атрот-Шофан, Иаезер, Иогбеха, ");
INSERT INTO ron1924_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Бет-Нимра ши Бет-Харан, четэць ынтэрите, ши ау фэкут стауле пентру турме. ");
INSERT INTO ron1924_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Фиий луй Рубен ау зидит Хесбонул, Елеале, Кириатаим, ");
INSERT INTO ron1924_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Небо ши Баал-Меон, але кэрор нуме ау фост скимбате, ши Сибма ши ау пус алте нуме четэцилор пе каре ле-ау зидит. ");
INSERT INTO ron1924_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Фиий луй Макир, фиул луй Манасе, ау мерс ымпотрива Галаадулуй ши ау пус мына пе ел; ау изгонит пе амориций каре ерау аколо. ");
INSERT INTO ron1924_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Мойсе а дат Галаадул луй Макир, фиул луй Манасе, каре с-а ашезат аколо. ");
INSERT INTO ron1924_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Иаир, фиул луй Манасе, а порнит ши ел ши а луат тыргуриле, ши ле-а нумит тыргуриле луй Иаир. ");
INSERT INTO ron1924_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Нобах а порнит ши ел ши а луат Кенатул, ымпреунэ ку четэциле каре циняу де ел, ши л-а нумит Нобах, дупэ нумеле луй. ");
INSERT INTO ron1924_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Ятэ попасуриле копиилор луй Исраел каре ау ешит дин цара Еӂиптулуй, дупэ оштириле лор, суб повэцуиря луй Мойсе ши луй Аарон. ");
INSERT INTO ron1924_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Мойсе а скрис кэлэторииле лор дин попас ын попас, дупэ порунка Домнулуй. Ши ятэ попасуриле лор, дупэ кэлэторииле лор. ");
INSERT INTO ron1924_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Ау порнит дин Рамсес ын луна ынтый, ын зиуа а чинчспрезечя а луний ынтый. А доуа зи дупэ Паште, копиий луй Исраел ау ешит гата де луптэ ын фаца тутурор еӂиптенилор, ");
INSERT INTO ron1924_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","ын тимп че еӂиптений ышь ынгропау пе тоць ынтыий лор нэскуць пе каре-й ловисе Домнул динтре ей. Кэч Домнул фэкусе кяр ши пе думнезеий лор сэ симтэ путеря Луй. ");
INSERT INTO ron1924_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Копиий луй Исраел ау порнит дин Рамсес ши ау тэбэрыт ла Сукот. ");
INSERT INTO ron1924_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Ау порнит дин Сукот ши ау тэбэрыт ла Етам, каре есте ла марӂиня пустиулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Ау порнит дин Етам, с-ау ынторс ынапой ла Пи-Хахирот, фацэ ын фацэ ку Баал-Цефон, ши ау тэбэрыт ынаинтя Мигдолулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Ау порнит динаинтя Пи-Хахиротулуй ши ау трекут прин мижлокул мэрий, ынспре пустиу; ау фэкут ун друм де трей зиле ын пустиул Етамулуй ши ау тэбэрыт ла Мара. ");
INSERT INTO ron1924_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Ау порнит де ла Мара ши ау ажунс ла Елим; ла Елим ерау доуэспрезече извоаре де апэ ши шаптезечь де финичь; аколо ау тэбэрыт. ");
INSERT INTO ron1924_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Ау порнит дин Елим ши ау тэбэрыт лынгэ Маря Рошие. ");
INSERT INTO ron1924_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Ау порнит де ла Маря Рошие ши ау тэбэрыт ын пустиул Син. ");
INSERT INTO ron1924_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Ау порнит дин пустиул Син ши ау тэбэрыт ла Дофка. ");
INSERT INTO ron1924_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Ау порнит дин Дофка ши ау тэбэрыт ла Алуш. ");
INSERT INTO ron1924_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Ау порнит дин Алуш ши ау тэбэрыт ла Рефидим, унде попорул н-а гэсит апэ де бэут. ");
INSERT INTO ron1924_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Ау порнит дин Рефидим ши ау тэбэрыт ын пустиул Синай. ");
INSERT INTO ron1924_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Ау порнит дин пустиул Синай ши ау тэбэрыт ла Киброт-Хатаава. ");
INSERT INTO ron1924_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Ау порнит де ла Киброт-Хатаава ши ау тэбэрыт ла Хацерот. ");
INSERT INTO ron1924_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Ау порнит дин Хацерот ши ау тэбэрыт ла Ритма. ");
INSERT INTO ron1924_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Ау порнит де ла Ритма ши ау тэбэрыт ла Римон-Перец. ");
INSERT INTO ron1924_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Ау порнит дин Римон-Перец ши ау тэбэрыт ла Либна. ");
INSERT INTO ron1924_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Ау порнит дин Либна ши ау тэбэрыт ла Риса. ");
INSERT INTO ron1924_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Ау порнит дин Риса ши ау тэбэрыт ла Кехелата. ");
INSERT INTO ron1924_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Ау порнит дин Кехелата ши ау тэбэрыт ла мунтеле Шафер. ");
INSERT INTO ron1924_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Ау порнит де ла мунтеле Шафер ши ау тэбэрыт ла Харада. ");
INSERT INTO ron1924_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Ау порнит дин Харада ши ау тэбэрыт ла Макелот. ");
INSERT INTO ron1924_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Ау порнит дин Макелот ши ау тэбэрыт ла Тахат. ");
INSERT INTO ron1924_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Ау порнит дин Тахат ши ау тэбэрыт ла Тарах. ");
INSERT INTO ron1924_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Ау порнит дин Тарах ши ау тэбэрыт ла Митка. ");
INSERT INTO ron1924_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Ау порнит дин Митка ши ау тэбэрыт ла Хашмона. ");
INSERT INTO ron1924_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Ау порнит дин Хашмона ши ау тэбэрыт ла Мосерот. ");
INSERT INTO ron1924_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Ау порнит дин Мосерот ши ау тэбэрыт ла Бене-Иаакан. ");
INSERT INTO ron1924_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Ау порнит дин Бене-Иаакан ши ау тэбэрыт ла Хор-Гидгад. ");
INSERT INTO ron1924_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Ау порнит дин Хор-Гидгад ши ау тэбэрыт ла Иотбата. ");
INSERT INTO ron1924_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Ау порнит дин Иотбата ши ау тэбэрыт ла Аброна. ");
INSERT INTO ron1924_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Ау порнит дин Аброна ши ау тэбэрыт ла Ецион-Гебер. ");
INSERT INTO ron1924_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Ау порнит дин Ецион-Гебер ши ау тэбэрыт ын пустиул Цин, адикэ ла Кадес. ");
INSERT INTO ron1924_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Ау порнит дин Кадес ши ау тэбэрыт ла мунтеле Хор, ла марӂиня цэрий Едомулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Преотул Аарон с-а суит пе мунтеле Хор, дупэ порунка Домнулуй, ши а мурит аколо, ын ал патрузечеля ан дупэ еширя копиилор луй Исраел дин цара Еӂиптулуй, ын луна а чинчя, ын чя динтый зи а луний. ");
INSERT INTO ron1924_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Аарон ера ын вырстэ де о сутэ доуэзечь ши трей де ань кынд а мурит пе мунтеле Хор. ");
INSERT INTO ron1924_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Ымпэратул Арадулуй, канаанитул каре локуя ын партя де мязэзи а цэрий Канаанулуй, а афлат де сосиря копиилор луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Ау порнит де ла мунтеле Хор ши ау тэбэрыт ла Цалмона. ");
INSERT INTO ron1924_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Ау порнит дин Цалмона ши ау тэбэрыт ла Пунон. ");
INSERT INTO ron1924_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Ау порнит дин Пунон ши ау тэбэрыт ла Обот. ");
INSERT INTO ron1924_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Ау порнит дин Обот ши ау тэбэрыт ла Иие-Абарим, ла хотарул Моабулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Ау порнит дин Иие-Абарим ши ау тэбэрыт ла Дибон-Гад. ");
INSERT INTO ron1924_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Ау порнит дин Дибон-Гад ши ау тэбэрыт ла Алмон-Диблатаим. ");
INSERT INTO ron1924_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Ау порнит дин Алмон-Диблатаим ши ау тэбэрыт ла мунций Абарим, ынаинтя мунтелуй Небо. ");
INSERT INTO ron1924_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Ау порнит де ла мунций Абарим ши ау тэбэрыт ын кымпия Моабулуй, лынгэ Йордан, ын фаца Иерихонулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Ау тэбэрыт лынгэ Йордан, де ла Бет-Иешимот пынэ ла Абел-Ситим, ын кымпия Моабулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Домнул а ворбит луй Мойсе ын кымпия Моабулуй, лынгэ Йордан, ын фаца Иерихонулуй, ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","„Ворбеште копиилор луй Исраел ши спуне-ле: ‘Дупэ че вець трече Йорданул ши вець интра ын цара Канаанулуй, ");
INSERT INTO ron1924_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","сэ изгониць динаинтя воастрэ пе тоць локуиторий цэрий, сэ ле дэрымаць тоць идолий де пятрэ, сэ ле нимичиць тоате икоанеле турнате ши сэ ле нимичиць тоате ынэлцимиле пентру жертфе. ");
INSERT INTO ron1924_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Сэ луаць цара ын стэпынире ши сэ вэ ашезаць ын еа, кэч Еу в-ам дат цара ачаста ка сэ фие мошия воастрэ. ");
INSERT INTO ron1924_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Сэ ымпэрциць цара прин сорць, дупэ фамилииле воастре. Челор че сунт ын нумэр май маре, сэ ле даць о парте май маре ши челор че сунт ын нумэр май мик, сэ ле даць о парте май микэ. Фиекаре сэ стэпыняскэ че-й ва кэдя ла сорць; с-о луаць ын стэпынире дупэ семинцииле пэринцилор воштри. ");
INSERT INTO ron1924_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Дар дакэ ну вець изгони динаинтя воастрэ пе локуиторий цэрий, ачея динтре ей пе каре ый вець лэса вэ вор фи ка ниште спинь ын окь ши ка ниште гимпь ын коасте; вэ вор фи врэжмашь ын цара ын каре вець мерӂе сэ вэ ашезаць. ");
INSERT INTO ron1924_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Ши вэ вой фаче ши воуэ кум хотэрысем сэ ле фак лор.’” ");
INSERT INTO ron1924_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","„Дэ порунка ачаста копиилор луй Исраел ши спуне-ле: ‘Кынд вець интра ын цара Канаанулуй, цара ачаста ва фи моштениря воастрэ – цара Канаанулуй, але кэрей хотаре ятэ-ле: ");
INSERT INTO ron1924_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Хотарул дин партя де мязэзи ва ынчепе дин пустиул Цин, лынгэ Едом. Астфел, хотарул востру де мязэзи ва ынчепе де ла марӂиня Мэрий Сэрате спре рэсэрит; ");
INSERT INTO ron1924_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","се ва ынтоарче ла мязэзи де ынэлцимя Акрабим, ва трече прин Цин ши се ва ынтинде пынэ ла мязэзи де Кадес-Барня; ва урма май департе прин Хацар-Адар ши ва трече спре Ацмон; ");
INSERT INTO ron1924_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","де ла Ацмон, се ва ынтоарче пынэ ла пырыул Еӂиптулуй ши ва еши ла маре. ");
INSERT INTO ron1924_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Хотарул востру динспре апус ва фи Маря чя Маре; ачаста ва фи хотарул востру ла апус. ");
INSERT INTO ron1924_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Ятэ каре ва фи хотарул востру спре мязэноапте: ынчепынд де ла Маря чя Маре, сэ траӂець хотарул пынэ ла мунтеле Хор; ");
INSERT INTO ron1924_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","де ла мунтеле Хор, сэ-л траӂець прин Хамат ши сэ ажунгэ пынэ ла Цедад; ");
INSERT INTO ron1924_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","сэ урмезе май департе прин Зифрон, ка сэ ажунгэ ла Хацар-Енан: ачеста сэ вэ фие хотарул ынспре мязэноапте. ");
INSERT INTO ron1924_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Сэ вэ траӂець хотарул спре рэсэрит де ла Хацар-Енан пынэ ла Шефам; ");
INSERT INTO ron1924_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","сэ се кобоаре дин Шефам спре Рибла, ла рэсэрит де Аин; се ва коборы ши се ва ынтинде де-а лунгул мэрий Кинерет, ла рэсэрит; ");
INSERT INTO ron1924_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","се ва коборы ярэшь спре Йордан, ка сэ ажунгэ ла Маря Сэратэ. Ачаста ва фи цара воастрэ, ку хотареле ей де жур ымпрежур.’” ");
INSERT INTO ron1924_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Мойсе а дат порунка ачаста копиилор луй Исраел ши а зис: „Ачаста есте цара пе каре о вець ымпэрци прин сорць ши пе каре а порунчит Домнул с-о дя челор ноуэ семинций ши жумэтате. ");
INSERT INTO ron1924_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Кэч семинция фиилор луй Рубен, дупэ каселе лор пэринтешть, ши семинция фиилор луй Гад, дупэ каселе пэринцилор лор, прекум ши жумэтате дин семинция луй Манасе шь-ау луат моштениря. ");
INSERT INTO ron1924_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Ачесте доуэ семинций ши жумэтате шь-ау луат моштениря динкоаче де Йордан, ын фаца Иерихонулуй, ынспре рэсэрит.” ");
INSERT INTO ron1924_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","„Ятэ нумеле бэрбацилор каре вор ымпэрци цара ынтре вой: преотул Елеазар ши Иосуа, фиул луй Нун. ");
INSERT INTO ron1924_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Сэ май луаць кыте о кэпетение дин фиекаре семинцие, ка сэ факэ ымпэрциря цэрий. ");
INSERT INTO ron1924_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Ятэ нумеле бэрбацилор ачестора. Пентру семинция луй Иуда: Калеб, фиул луй Иефуне; ");
INSERT INTO ron1924_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","пентру семинция фиилор луй Симеон: Самуел, фиул луй Амихуд; ");
INSERT INTO ron1924_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","пентру семинция луй Бениамин: Елидад, фиул луй Кислон; ");
INSERT INTO ron1924_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","пентру семинция фиилор луй Дан: кэпетения Буки, фиул луй Иогли; ");
INSERT INTO ron1924_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","пентру фиий луй Иосиф: пентру семинция фиилор луй Манасе – кэпетения Ханиел, фиул луй Ефод; ");
INSERT INTO ron1924_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","ши пентру семинция фиилор луй Ефраим – кэпетения Кемуел, фиул луй Шифтан; ");
INSERT INTO ron1924_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","пентру семинция фиилор луй Забулон: кэпетения Елицафан, фиул луй Парнак; ");
INSERT INTO ron1924_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","пентру семинция фиилор луй Исахар: кэпетения Палтиел, фиул луй Азан; ");
INSERT INTO ron1924_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","пентру семинция фиилор луй Ашер: кэпетения Ахихуд, фиул луй Шеломи; ");
INSERT INTO ron1924_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","пентру семинция фиилор луй Нефтали: кэпетения Педахел, фиул луй Амихуд.” ");
INSERT INTO ron1924_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Ачештя сунт ачея кэрора ле-а порунчит Домнул сэ ымпартэ цара Канаанулуй ынтре копиий луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Домнул а ворбит луй Мойсе ын кымпия Моабулуй, лынгэ Йордан, ын фаца Иерихонулуй, ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","„Порунчеште копиилор луй Исраел сэ дя левицилор, дин моштениря пе каре о вор авя, ниште четэць ын каре сэ поатэ локуи. Сэ май даць левицилор ши ун лок гол ымпрежурул ачестор четэць. ");
INSERT INTO ron1924_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Четэциле сэ фие але лор, ка сэ локуяскэ ын еле, яр локуриле гоале сэ фие пентру вителе лор, пентру авериле лор ши пентру тоате добитоачеле лор. ");
INSERT INTO ron1924_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Локуриле гоале дин журул четэцилор пе каре ле вець да левицилор сэ айбэ, ынчепынд де ла зидул четэций ын афарэ, о мие де коць де жур ымпрежур. ");
INSERT INTO ron1924_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Сэ мэсураць афарэ дин четате доуэ мий де коць ын партя де рэсэрит, доуэ мий де коць ын партя де мязэзи, доуэ мий де коць ын партя де апус ши доуэ мий де коць ын партя де мязэноапте, аша ынкыт четатя сэ фие ла мижлок. Ачестя сэ фие локуриле гоале дин журул четэцилор лор. ");
INSERT INTO ron1924_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","Динтре четэциле пе каре ле вець да левицилор, шасе сэ фие четэць де скэпаре, унде ва путя сэ фугэ учигашул, ши афарэ де ачестя, сэ ле май даць алте патрузечь ши доуэ де четэць. ");
INSERT INTO ron1924_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Тоате четэциле пе каре ле вець да левицилор сэ фие патрузечь ши опт де четэць, ымпреунэ ку локуриле лор гоале. ");
INSERT INTO ron1924_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Четэциле пе каре ле вець да дин мошииле копиилор луй Исраел сэ фие дате май мулте де чей че ау май мулте ши май пуцине де чей че ау май пуцине; фиекаре сэ дя левицилор дин четэциле луй дупэ моштениря пе каре о ва авя.” ");
INSERT INTO ron1924_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Домнул а ворбит луй Мойсе ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","„Ворбеште копиилор луй Исраел ши спуне-ле: ‘Кынд вець трече Йорданул ши вець интра ын цара Канаанулуй, ");
INSERT INTO ron1924_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","сэ вэ алеӂець ниште четэць каре сэ вэ фие четэць де скэпаре, унде сэ поатэ скэпа учигашул каре ва оморы пе чинева фэрэ вое. ");
INSERT INTO ron1924_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Ачесте четэць сэ вэ служяскэ дрепт четэць де скэпаре ымпотрива рэзбунэторулуй сынӂелуй, пентру ка учигашул сэ ну фие оморыт ынаинте де а се ынфэциша ын фаца адунэрий ка сэ фие жудекат. ");
INSERT INTO ron1924_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Дин четэциле пе каре ле вець да, шасе сэ вэ фие четэць де скэпаре. ");
INSERT INTO ron1924_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Сэ даць трей четэць динкоаче де Йордан ши трей четэць ын цара Канаанулуй: ачестя сэ вэ фие четэць де скэпаре. ");
INSERT INTO ron1924_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Ачесте шасе четэць сэ фие четэць де скэпаре пентру копиий луй Исраел, пентру стрэин ши пентру чел че локуеште ын мижлокул востру: аколо ва путя сэ скапе орьче ом каре ва учиде пе чинева фэрэ вое. ");
INSERT INTO ron1924_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","Дакэ ун ом ловеште пе апроапеле сэу ку о унялтэ де фер ши ачеста моаре, есте ун учигаш: учигашул сэ фие педепсит ку моартя. ");
INSERT INTO ron1924_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Дакэ-л ловеште ку о пятрэ пе каре о цине ын мынэ, де каре поате мури, ши моаре, есте ун учигаш: учигашул сэ фие педепсит ку моартя. ");
INSERT INTO ron1924_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Дакэ-л ловеште ку врео унялтэ де лемн пе каре о цине ын мынэ, де каре поате мури, ши моаре, есте ун учигаш; учигашул сэ фие педепсит ку моартя. ");
INSERT INTO ron1924_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Рэзбунэторул сынӂелуй сэ омоаре пе учигаш; кынд ыл ва ынтылни, сэ-л омоаре. ");
INSERT INTO ron1924_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Дакэ ун ом ымпинӂе пе апроапеле сэу дин урэ сау дакэ-л пындеште ши арункэ чева асупра луй ши моаре ");
INSERT INTO ron1924_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","сау дакэ-л ловеште ку мына дин врэжмэшие ши моаре, чел че л-а ловит сэ фие педепсит ку моартя; есте ун учигаш: рэзбунэторул сынӂелуй сэ омоаре пе учигаш кынд ыл ва ынтылни. ");
INSERT INTO ron1924_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","Дар дакэ ун ом ымпинӂе пе апроапеле луй фэрэ весте, ши ну дин врэжмэшие, сау дакэ арункэ чева асупра луй фэрэ сэ-л фи пындит ");
INSERT INTO ron1924_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","сау дакэ арункэ асупра луй дин небэгаре де сямэ о пятрэ каре-й поате причинуи моартя ши моаре, фэрэ сэ-л ураскэ ши фэрэ сэ кауте сэ-й факэ рэу, ");
INSERT INTO ron1924_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","ятэ леӂиле дупэ каре ва жудека адунаря ынтре чел че л-а ловит ши рэзбунэторул сынӂелуй: ");
INSERT INTO ron1924_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Адунаря ва избэви пе учигаш дин мына рэзбунэторулуй сынӂелуй ши-л ва фаче сэ се ынтоаркэ ын четатя де скэпаре унде фуӂисе. Сэ локуяскэ аколо пынэ ла моартя марелуй преот каре есте унс ку унтделемн сфынт. ");
INSERT INTO ron1924_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Дакэ учигашул есе дин хотарул четэций де скэпаре унде фуӂисе ");
INSERT INTO ron1924_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","ши дакэ рэзбунэторул сынӂелуй ыл ынтылнеште афарэ дин хотарул четэций де скэпаре ши учиде пе учигаш, ну ва фи виноват де омор. ");
INSERT INTO ron1924_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Кэч учигашул требуя сэ локуяскэ ын четатя луй де скэпаре пынэ ла моартя марелуй преот, ши, дупэ моартя марелуй преот, путя сэ се ынтоаркэ ла мошия луй. ");
INSERT INTO ron1924_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","Ятэ порунчиле де дрепт пентру вой ши пентру урмаший воштри, ын тоате локуриле ын каре вець локуи. ");
INSERT INTO ron1924_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","Дакэ ун ом омоарэ пе чинева, учигашул сэ фие оморыт пе мэртурия марторилор. Ун сингур мартор ну ва фи де ажунс ка сэ фие осындит чинева ла моарте. ");
INSERT INTO ron1924_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","Сэ ну примиць рэскумпэраре пентру вяца унуй учигаш виноват де моарте, чи сэ фие педепсит ку моартя. ");
INSERT INTO ron1924_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Сэ ну примиць рэскумпэраре пентру чел че требуе сэ фугэ ын четатя луй де скэпаре, ка сэ се ынтоаркэ сэ локуяскэ ын царэ пынэ ла моартя преотулуй. ");
INSERT INTO ron1924_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Сэ ну пынгэриць цара унде вець фи, кэч сынӂеле челуй невиноват пынгэреште цара; ши испэширя сынӂелуй вэрсат ын царэ ну се ва путя фаче декыт прин сынӂеле челуй че-л ва вэрса. ");
INSERT INTO ron1924_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Сэ ну пынгэриць деч цара ын каре вець мерӂе сэ локуиць ши ын мижлокул кэрея вой локуи ши Еу, кэч Еу сунт Домнул, каре локуеште ын мижлокул копиилор луй Исраел.’” ");
INSERT INTO ron1924_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Кэпетенииле фамилией луй Галаад, фиул луй Макир, фиул луй Манасе, динтре фамилииле фиилор луй Иосиф, с-ау апропият ши ау ворбит ынаинтя луй Мойсе ши ынаинтя май-марилор песте каселе пэринтешть але копиилор луй Исраел. ");
INSERT INTO ron1924_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","Ей ау зис: „Домнуле, цие ць-а порунчит Домнул сэ дай копиилор луй Исраел цара ка моштенире прин сорць. Ту, домнуле, ай примит, де асеменя, порункэ де ла Домнул ка моштениря фрателуй ностру Целофхад с-о дай фетелор луй. ");
INSERT INTO ron1924_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Дар, дакэ еле се мэритэ дупэ унул дин фиий алтей семинций а копиилор луй Исраел, моштениря лор ва фи штярсэ дин моштениря пэринцилор ноштри ши адэугатэ ла а семинцией дин каре вор фаче парте ши, астфел, моштениря каре не-а кэзут ноуэ ла сорць се ва микшора. ");
INSERT INTO ron1924_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Ши кынд ва вени анул де веселие пентру копиий луй Исраел, моштениря лор ва рэмыне адэугатэ ла а семинцией дин каре вор фаче парте ши ва фи штярсэ астфел дин моштениря семинцией пэринцилор ноштри.” ");
INSERT INTO ron1924_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Мойсе а порунчит копиилор луй Исраел дин партя Домнулуй ши а зис: „Семинция фиилор луй Иосиф аре дрептате. ");
INSERT INTO ron1924_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Ятэ че порунчеште Домнул ку привире ла фетеле луй Целофхад: сэ се мэрите дупэ чине вор вря, нумай сэ се мэрите ынтр-о фамилие дин семинция пэринцилор лор. ");
INSERT INTO ron1924_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Ничо моштенире а копиилор луй Исраел сэ ну трякэ де ла о семинцие ла алта, чи фиекаре дин копиий луй Исраел сэ се цинэ липит де моштениря семинцией пэринцилор луй. ");
INSERT INTO ron1924_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Ши орьче фатэ каре аре о моштенире ын семинцииле копиилор луй Исраел сэ се мэрите дупэ чинева динтр-о фамилие дин семинция татэлуй ей, пентру ка фиекаре дин копиий луй Исраел сэ-шь айбэ моштениря пэринцилор сэй. ");
INSERT INTO ron1924_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Ничо моштенире сэ ну трякэ де ла о семинцие ла алта, чи семинцииле копиилор луй Исраел сэ се цинэ фиекаре де моштениря са.” ");
INSERT INTO ron1924_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Фетеле луй Целофхад ау фэкут ынтокмай дупэ порунка пе каре о дэдусе луй Мойсе Домнул. ");
INSERT INTO ron1924_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Махла, Тирца, Хогла, Милка ши Ноа, фетеле луй Целофхад, с-ау мэритат дупэ фиий ункилор лор; ");
INSERT INTO ron1924_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","с-ау мэритат ын фамилииле фиилор луй Манасе, фиул луй Иосиф, ши моштениря лор а рэмас ын семинция фамилией татэлуй лор. ");
INSERT INTO ron1924_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Ачестя сунт порунчиле ши леӂиле пе каре ле-а дат Домнул прин Мойсе копиилор луй Исраел ын кымпия Моабулуй, лынгэ Йордан, ын фаца Иерихонулуй. ");
INSERT INTO ron1924_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Ятэ кувинтеле пе каре ле-а спус Мойсе ынтрегулуй Исраел динкоаче де Йордан, ын пустиу, ынтр-о кымпие, фацэ ын фацэ ку Суф, ынтре Паран, Тофел, Лабан, Хацерот ши Ди-Захаб. ");
INSERT INTO ron1924_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","(Де ла Хореб пынэ ла Кадес-Барня, пе друмул каре дуче ла мунтеле Сеир, есте о депэртаре де унспрезече зиле.) ");
INSERT INTO ron1924_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Ын ал патрузечеля ан, ын луна а унспрезечя, ын зиуа ынтый а луний, Мойсе а ворбит копиилор луй Исраел ши ле-а спус тот че-й порунчисе Домнул сэ ле спунэ. ");
INSERT INTO ron1924_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Ачаста ера дупэ че а бэтут пе Сихон, ымпэратул аморицилор, каре локуя ла Хесбон, ши пе Ог, ымпэратул Басанулуй, каре локуя ла Аштарот ши ла Едрей. ");
INSERT INTO ron1924_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Динкоаче де Йордан, ын цара Моабулуй, Мойсе а ынчепут сэ лэмуряскэ леӂя ачаста ши а зис: ");
INSERT INTO ron1924_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","„Домнул Думнезеул ностру не-а ворбит ла Хореб, зикынд: ‘Аць локуит дестулэ време ын мунтеле ачеста. ");
INSERT INTO ron1924_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Ынтоарчеци-вэ ши плекаць; дучеци-вэ ла мунтеле аморицилор ши ын тоате ымпрежуримиле: ын кымпие, пе мунте, ын вале, ын партя де мязэзи, пе цэрмул мэрий, ын цара канааницилор ши ын Либан, пынэ ла рыул чел маре, рыул Еуфрат. ");
INSERT INTO ron1924_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Ведець, в-ам пус цара ынаинте, интраць ши луаць ын стэпынире цара пе каре Домнул а журат пэринцилор воштри, Авраам, Исаак ши Иаков, кэ о ва да лор ши семинцей лор дупэ ей.’ ");
INSERT INTO ron1924_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","Ын время ачея, в-ам спус: ‘Еу ну вэ пот пурта сингур. ");
INSERT INTO ron1924_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Домнул Думнезеул востру в-а ынмулцит, ши азь сунтець фоарте мулць ла нумэр, ка стелеле черулуй. ");
INSERT INTO ron1924_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Домнул Думнезеул пэринцилор воштри сэ вэ мэряскэ де о мие де орь пе атыт ши сэ вэ бинекувынтезе, дупэ кум а фэгэдуит! ");
INSERT INTO ron1924_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Кум аш путя сэ порт еу сингур причиниле воастре, повара воастрэ ши чертуриле воастре? ");
INSERT INTO ron1924_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Луаць дин семинцииле воастре ниште бэрбаць ынцелепць, причепуць ши куноскуць ши-й вой пуне ын фрунтя воастрэ.’ ");
INSERT INTO ron1924_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Вой мь-аць рэспунс ши аць зис: ‘Чея че спуй ту сэ фачем есте ун лукру бун.’ ");
INSERT INTO ron1924_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Ам луат атунч пе кэпетенииле семинциилор воастре, бэрбаць ынцелепць ши куноскуць, ши й-ам пус ын фрунтя воастрэ дрепт кэпетений песте о мие, кэпетений песте о сутэ, кэпетений песте чинчзечь ши кэпетений песте зече, ка дрегэторь ын семинцииле воастре. ");
INSERT INTO ron1924_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Ам дат, ын ачелашь тимп, урмэтоаря порункэ жудекэторилор воштри: ‘Сэ аскултаць пе фраций воштри ши сэ жудекаць дупэ дрептате неынцелеӂериле фиекэруя ку фрателе луй сау ку стрэинул. ");
INSERT INTO ron1924_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Сэ ну кэутаць ла фаца оаменилор ын жудекэциле воастре; сэ аскултаць пе чел мик ка ши пе чел маре; сэ ну вэ темець де нимень, кэч Думнезеу е Чел каре фаче дрептате. Ши кынд вець гэси о причинэ пря гря, с-о адучець ынаинтя мя, ка с-о ауд.’ ");
INSERT INTO ron1924_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Аша в-ам порунчит, ын время ачея, тот че авяць де фэкут. ");
INSERT INTO ron1924_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Ам плекат дин Хореб ши ам стрэбэтут тот пустиул ачела маре ши грозав пе каре л-аць вэзут; ам луат друмул каре дуче ын мунтеле аморицилор, кум не порунчисе Домнул Думнезеул ностру, ши ам ажунс ла Кадес-Барня. ");
INSERT INTO ron1924_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","Ши еу в-ам зис: ‘Аць ажунс ла мунтеле аморицилор пе каре ни-л дэ Домнул Думнезеул ностру. ");
INSERT INTO ron1924_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Ятэ кэ Домнул Думнезеул тэу ыць пуне цара ынаинте; суе-те, я-о ын стэпынире, кум ць-а спус Домнул Думнезеул пэринцилор тэй; ну те теме ши ну те ынспэймынта.’ ");
INSERT INTO ron1924_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Вой в-аць апропият ку тоций де мине ши аць зис: ‘Сэ тримитем ниште оамень ынаинтя ноастрэ ка сэ искодяскэ цара ши сэ не адукэ рэспунс ку привире ла друмул пе каре не вом суи ын еа ши асупра четэцилор ын каре вом ажунӂе.’ ");
INSERT INTO ron1924_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","Пэреря ачаста ми с-а пэрут бунэ ши ам луат дойспрезече оамень динтре вой, кыте ун ом де фиекаре семинцие. ");
INSERT INTO ron1924_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Ей ау плекат, ау трекут мунтеле ши ау ажунс пынэ ла валя Ешкол ши ау искодит цара. ");
INSERT INTO ron1924_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","Ау луат ын мынь дин роаделе цэрий ши ни ле-ау адус; не-ау фэкут о даре де сямэ ши ау зис: ‘Бунэ царэ не дэ Домнул Думнезеул ностру!’ ");
INSERT INTO ron1924_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Дар вой н-аць врут сэ вэ суиць ын еа ши в-аць рэзврэтит ымпотрива порунчий Домнулуй Думнезеулуй востру. ");
INSERT INTO ron1924_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Аць кыртит ын кортуриле воастре ши аць зис: ‘Пентру кэ не урэште, де ачея не-а скос Домнул дин цара Еӂиптулуй, ка сэ не дя ын мыниле аморицилор ши сэ не нимичяскэ. ");
INSERT INTO ron1924_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Унде сэ не суим? Фраций ноштри не-ау ынмуят инима, зикынд: «Попорул ачела есте ун попор май маре ши май ыналт ла статурэ декыт ной; четэциле сунт марь ши ынтэрите пынэ ла чер; ба ынкэ, ам вэзут аколо ши копий де-ай луй Анак.»’ ");
INSERT INTO ron1924_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","Еу в-ам зис: ‘Ну вэ ынспэймынтаць ши ну вэ фие фрикэ де ей. ");
INSERT INTO ron1924_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Домнул Думнезеул востру, каре мерӂе ынаинтя воастрэ, Се ва лупта Ел Ынсушь пентру вой, потривит ку тот че а фэкут пентру вой суб окий воштри ын Еӂипт.’ ");
INSERT INTO ron1924_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","Апой, ын пустиу, ай вэзут кэ Домнул Думнезеул тэу те-а пуртат кум поартэ ун ом пе фиул сэу, пе тот друмул пе каре л-аць фэкут пынэ ла сосиря воастрэ ын локул ачеста. ");
INSERT INTO ron1924_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Ку тоате ачестя, вой н-аць авут ынкредере ын Домнул Думнезеул востру, ");
INSERT INTO ron1924_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","каре мерӂя ынаинтя воастрэ пе друм, ка сэ вэ кауте ун лок де попосире: ноаптя ынтр-ун фок, ка сэ вэ арате друмул пе каре требуя сэ мерӂець, ши зиуа ынтр-ун нор. ");
INSERT INTO ron1924_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","Домнул а аузит гласул кувинтелор воастре. С-а мыният ши а журат зикынд: ");
INSERT INTO ron1924_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","‘Ничунул дин бэрбаций каре фак парте дин ачест ням рэу ну ва ведя цара ачея бунэ пе каре ам журат кэ о вой да пэринцилор воштри, ");
INSERT INTO ron1924_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","афарэ де Калеб, фиул луй Иефуне. Ел о ва ведя, ши цара ын каре а мерс о вой да луй ши копиилор луй, пентру кэ а урмат ын тотул каля Домнулуй.’ ");
INS